// ========== Copyright Header Begin ============================================
// Copyright (c) 2015 Princeton University
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Princeton University nor the
//       names of its contributors may be used to endorse or promote products
//       derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY PRINCETON UNIVERSITY "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL PRINCETON UNIVERSITY BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// ========== Copyright Header End ============================================

module sram_l15_hmt
(
input wire MEMCLK,
input wire RESET_N,
input wire CE,
input wire [8:0] A,
input wire RDWEN,
input wire [31:0] BW,
input wire [31:0] DIN,
output wire [31:0] DOUT,

input wire [`BIST_OP_WIDTH-1:0] BIST_COMMAND,
input wire [`SRAM_WRAPPER_BUS_WIDTH-1:0] BIST_DIN,
output reg [`SRAM_WRAPPER_BUS_WIDTH-1:0] BIST_DOUT,
input wire [`BIST_ID_WIDTH-1:0] SRAMID
);

wire           write_en;
wire           read_en;
wire  [3:0]    wen_mask;


assign write_en   = CE & (RDWEN == 1'b0);
assign read_en    = CE & (RDWEN == 1'b1);
assign wen_mask   = {4{BW[0]}};

always @*
   BIST_DOUT = {`SRAM_WRAPPER_BUS_WIDTH{1'b0}};

`ifdef ML605_BOARD
   bram_512x32 mem (
      .clka    (MEMCLK     ),
      .ena     (write_en   ),
      .wea     (wen_mask   ),
      .addra   (A          ),
      .dina    (DIN        ),
      
      .clkb    (MEMCLK     ),
      .enb     (read_en    ),
      .addrb   (A          ),
      .doutb   (DOUT       )
   );
`elsif NEXYS4DDR_BOARD
   artix7_bram_512x32 mem (
      .BRAM_PORTA_clk    (MEMCLK     ),
      .BRAM_PORTA_en     (write_en   ),
      .BRAM_PORTA_we     (wen_mask   ),
      .BRAM_PORTB_addr   (A          ),
      .BRAM_PORTA_din    (DIN        ),
      
      .BRAM_PORTB_clk    (MEMCLK     ),
      .BRAM_PORTB_en     (read_en    ),
      .BRAM_PORTA_addr   (A          ),
      .BRAM_PORTB_dout   (DOUT       )
   );
`elsif VC707_BOARD
   virtex7_bram_512x32 mem (
      .clka    (MEMCLK     ),
      .ena     (write_en   ),
      .wea     (wen_mask   ),
      .addra   (A          ),
      .dina    (DIN        ),
      
      .clkb    (MEMCLK     ),
      .enb     (read_en    ),
      .addrb   (A          ),
      .doutb   (DOUT       )
   );

`else
   
   bram_512x32 mem (
      .clka    (MEMCLK     ),
      .ena     (write_en   ),
      .wea     (wen_mask   ),
      .addra   (A          ),
      .dina    (DIN        ),
      
      .clkb    (MEMCLK     ),
      .enb     (read_en    ),
      .addrb   (A          ),
      .doutb   (DOUT       )
   );

`endif



endmodule
