// Modified by Princeton University on June 9th, 2015
/*
* ========== Copyright Header Begin ==========================================
* 
* OpenSPARC T1 Processor File: bug7117_2.s
* Copyright (c) 2006 Sun Microsystems, Inc.  All Rights Reserved.
* DO NOT ALTER OR REMOVE COPYRIGHT NOTICES.
* 
* The above named program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License version 2 as published by the Free Software Foundation.
* 
* The above named program is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
* 
* You should have received a copy of the GNU General Public
* License along with this work; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
* 
* ========== Copyright Header End ============================================
*/
/*
********************************************************************************
   random seed:	639930522
   Jal lsubug.j:	
********************************************************************************/


#define CIOP
#define THREAD_MASK 0xf
#define NO_TRAPCHECK
#include "enable_traps.h"
#include "hboot.s"

.text
.global main

main:

	ta	%icc, T_RD_THID
! fork: source strm = 0xffffffff; target strm = 0x1
	cmp	%o1, 0
	setx	fork_lbl_0_1, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x2
	cmp	%o1, 1
	setx	fork_lbl_0_2, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x4
	cmp	%o1, 2
	setx	fork_lbl_0_3, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x8
	cmp	%o1, 3
	setx	fork_lbl_0_4, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_4:
        setx  0xfe401ad00d004264, %r1, %r1
        setx  0x4042ae2ad36416d0, %r1, %r2
        setx  0x381b34375b015774, %r1, %r3
        setx  0xf89d678c76de00d9, %r1, %r4
        setx  0xa59a7998b2e3a0f2, %r1, %r5
        setx  0xd4cdf6e5892492d6, %r1, %r6
        setx  0xad619a7ec497200d, %r1, %r7
        setx  0x53f6f8406795744e, %r1, %r8
        setx  0x7e0d2fe876a64000, %r1, %r9
        setx  0xba4fde3b0d68b0ed, %r1, %r10
        setx  0x2fdc416f8510a6dd, %r1, %r11
        setx  0xc081a0b1a8019edb, %r1, %r12
        setx  0x2c623193fd8d0e35, %r1, %r13
        setx  0x8b9fc0cce1e582df, %r1, %r14
        setx  0xd05e258498206f28, %r1, %r15
        setx  0x041cb5d355dbf113, %r1, %r16
        setx  0x8dcfdd809d975c1e, %r1, %r17
        setx  0x1d04ab2961e4d391, %r1, %r18
        setx  0xf790ebc3b90036e7, %r1, %r19
        setx  0xc0346badfa8c926a, %r1, %r20
        setx  0xd1d379d3495c8249, %r1, %r21
        setx  0x5730d3fc9bac2acf, %r1, %r22
        setx  0xdd38c986919141ac, %r1, %r23
        setx  0x40aa5de6a5b0c029, %r1, %r24
        setx  0x0c5f2bf00913e2ef, %r1, %r25
        setx  0x77c5d1a585277473, %r1, %r26
        setx  0xae2b43cf96db6be9, %r1, %r27
        setx  0xac3c6c000401cddf, %r1, %r28
        setx  0x4d03893aa6d10d3b, %r1, %r29
        setx  0xb3a33c0438d5a79e, %r1, %r30
        setx  0xd60bf9f2e99f8654, %r1, %r31
        setx  0x00000000000006e0, %r1, %r2
	setx shared_data, %r1, %r16
        wr %g0, 0x80, %asi
        wr %g0, 0x4, %fprs
	ldd	[%r16 + 0], %f0
	ldd	[%r16 + 8], %f2
	ldd	[%r16 + 16], %f4
	ldd	[%r16 + 24], %f6
	ldd	[%r16 + 32], %f8
	ldd	[%r16 + 40], %f10
	ldd	[%r16 + 48], %f12
	ldd	[%r16 + 56], %f14
	ldd	[%r16 + 64], %f16
	ldd	[%r16 + 72], %f18
	ldd	[%r16 + 80], %f20
	ldd	[%r16 + 88], %f22
	ldd	[%r16 + 96], %f24
	ldd	[%r16 + 104], %f26
	ldd	[%r16 + 112], %f28
	ldd	[%r16 + 120], %f30
	ldd	[%r16 + 128], %f32
	ldd	[%r16 + 136], %f34
	ldd	[%r16 + 144], %f36
	ldd	[%r16 + 152], %f38
	ldd	[%r16 + 160], %f40
	ldd	[%r16 + 168], %f42
	ldd	[%r16 + 176], %f44
	ldd	[%r16 + 184], %f46
	ldd	[%r16 + 192], %f48
	ldd	[%r16 + 200], %f50
	ldd	[%r16 + 208], %f52
	ldd	[%r16 + 216], %f54
	ldd	[%r16 + 224], %f56
	ldd	[%r16 + 232], %f58
	ldd	[%r16 + 240], %f60
	ldd	[%r16 + 248], %f62
        mov 0x23, %r31
thr3_loop_cnt_0:
	.word 0xe88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r20
	.word 0xc6942fdc  ! 1: LDUHA_I	lduha	[%r16, + 0x0fdc] %asi, %r3
	.word 0xd2842708  ! 1: LDUWA_I	lduwa	[%r16, + 0x0708] %asi, %r9
	.word 0xc6042f7c  ! 1: LDUW_I	lduw	[%r16 + 0x0f7c], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xc6942af6  ! 1: LDUHA_I	lduha	[%r16, + 0x0af6] %asi, %r3
	.word 0xdadc2fe0  ! 1: LDXA_I	ldxa	[%r16, + 0x0fe0] %asi, %r13
	.word 0xee841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r23
	brnz %r31,thr3_loop_cnt_0
	dec %r31
	.word 0x860423e6  ! 1: ADD_I	add 	%r16, 0x03e6, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0xae440002  ! 1: ADDC_R	addc 	%r16, %r2, %r23
        mov 0x67, %r31
thr3_loop_cnt_1:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc68c2eef  ! 1: LDUBA_I	lduba	[%r16, + 0x0eef] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xde941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r15
	.word 0xe4842a5c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a5c] %asi, %r18
	.word 0xf4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r26
	.word 0xea941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r21
	.word 0xec8c2f97  ! 1: LDUBA_I	lduba	[%r16, + 0x0f97] %asi, %r22
	brnz %r31,thr3_loop_cnt_1
	dec %r31
	.word 0x863c2736  ! 1: XNOR_I	xnor 	%r16, 0x0736, %r3
	.word 0x8d2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r6
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0xa7, %r31
thr3_loop_cnt_2:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe8042404  ! 1: LDUW_I	lduw	[%r16 + 0x0404], %r20
	.word 0xce4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r7
	.word 0xc60c2433  ! 1: LDUB_I	ldub	[%r16 + 0x0433], %r3
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xeecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r23
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf4942e26  ! 1: LDUHA_I	lduha	[%r16, + 0x0e26] %asi, %r26
	brnz %r31,thr3_loop_cnt_2
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x903c2524  ! 1: XNOR_I	xnor 	%r16, 0x0524, %r8
        mov 0x5d, %r31
thr3_loop_cnt_3:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6c42e4c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e4c] %asi, %r3
	.word 0xeedc27d8  ! 1: LDXA_I	ldxa	[%r16, + 0x07d8] %asi, %r23
	.word 0xf0c42fd0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0fd0] %asi, %r24
	.word 0xee540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r23
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc65c2118  ! 1: LDX_I	ldx	[%r16 + 0x0118], %r3
	.word 0xf0542c9e  ! 1: LDSH_I	ldsh	[%r16 + 0x0c9e], %r24
	brnz %r31,thr3_loop_cnt_3
	dec %r31
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x862c238b  ! 1: ANDN_I	andn 	%r16, 0x038b, %r3
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0x40, %r31
thr3_loop_cnt_4:
	.word 0xe2942a00  ! 1: LDUHA_I	lduha	[%r16, + 0x0a00] %asi, %r17
	.word 0xc68c2c77  ! 1: LDUBA_I	lduba	[%r16, + 0x0c77] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xc6042514  ! 1: LDUW_I	lduw	[%r16 + 0x0514], %r3
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xc6042f14  ! 1: LDUW_I	lduw	[%r16 + 0x0f14], %r3
	.word 0xce0c2731  ! 1: LDUB_I	ldub	[%r16 + 0x0731], %r7
	.word 0xf0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r24
	.word 0xea5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r21
	.word 0xdcd42774  ! 1: LDSHA_I	ldsha	[%r16, + 0x0774] %asi, %r14
	brnz %r31,thr3_loop_cnt_4
	dec %r31
	.word 0x861c222c  ! 1: XOR_I	xor 	%r16, 0x022c, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x90442a38  ! 1: ADDC_I	addc 	%r16, 0x0a38, %r8
	.word 0x86342dd5  ! 1: SUBC_I	orn 	%r16, 0x0dd5, %r3
        mov 0x33, %r31
thr3_loop_cnt_5:
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xcc4420e0  ! 1: LDSW_I	ldsw	[%r16 + 0x00e0], %r6
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf88c2e05  ! 1: LDUBA_I	lduba	[%r16, + 0x0e05] %asi, %r28
	.word 0xc6042c88  ! 1: LDUW_I	lduw	[%r16 + 0x0c88], %r3
	.word 0xf88c2c0e  ! 1: LDUBA_I	lduba	[%r16, + 0x0c0e] %asi, %r28
	.word 0xc64c2158  ! 1: LDSB_I	ldsb	[%r16 + 0x0158], %r3
	brnz %r31,thr3_loop_cnt_5
	dec %r31
	.word 0x86142c6a  ! 1: OR_I	or 	%r16, 0x0c6a, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x8e042526  ! 1: ADD_I	add 	%r16, 0x0526, %r7
	.word 0xaf2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r23
        mov 0x97, %r31
thr3_loop_cnt_6:
	.word 0xde04225c  ! 1: LDUW_I	lduw	[%r16 + 0x025c], %r15
	.word 0xcccc2df7  ! 1: LDSBA_I	ldsba	[%r16, + 0x0df7] %asi, %r6
	.word 0xc6042834  ! 1: LDUW_I	lduw	[%r16 + 0x0834], %r3
	.word 0xd61426f6  ! 1: LDUH_I	lduh	[%r16 + 0x06f6], %r11
	.word 0xcc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r6
	.word 0xd85c2268  ! 1: LDX_I	ldx	[%r16 + 0x0268], %r12
	.word 0xe444204c  ! 1: LDSW_I	ldsw	[%r16 + 0x004c], %r18
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_6
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x12, %r31
thr3_loop_cnt_7:
	.word 0xc6942590  ! 1: LDUHA_I	lduha	[%r16, + 0x0590] %asi, %r3
	.word 0xd2542226  ! 1: LDSH_I	ldsh	[%r16 + 0x0226], %r9
	.word 0xeadc2910  ! 1: LDXA_I	ldxa	[%r16, + 0x0910] %asi, %r21
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r20
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6142fd2  ! 1: LDUH_I	lduh	[%r16 + 0x0fd2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xe2442c40  ! 1: LDSW_I	ldsw	[%r16 + 0x0c40], %r17
	.word 0xc60c2884  ! 1: LDUB_I	ldub	[%r16 + 0x0884], %r3
	.word 0xf05c2ae0  ! 1: LDX_I	ldx	[%r16 + 0x0ae0], %r24
	brnz %r31,thr3_loop_cnt_7
	dec %r31
	.word 0x93343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r9
        mov 0x67, %r31
thr3_loop_cnt_8:
	.word 0xfa140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r29
	.word 0xf4142720  ! 1: LDUH_I	lduh	[%r16 + 0x0720], %r26
	.word 0xe48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r18
	.word 0xec44221c  ! 1: LDSW_I	ldsw	[%r16 + 0x021c], %r22
	.word 0xc6cc2838  ! 1: LDSBA_I	ldsba	[%r16, + 0x0838] %asi, %r3
	.word 0xec8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r22
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc65c2e50  ! 1: LDX_I	ldx	[%r16 + 0x0e50], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xea8422f8  ! 1: LDUWA_I	lduwa	[%r16, + 0x02f8] %asi, %r21
	brnz %r31,thr3_loop_cnt_8
	dec %r31
	.word 0xab3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r21
	.word 0x8c342764  ! 1: SUBC_I	orn 	%r16, 0x0764, %r6
	.word 0x86342c9e  ! 1: ORN_I	orn 	%r16, 0x0c9e, %r3
        mov 0xc6, %r31
thr3_loop_cnt_9:
	.word 0xdccc29b1  ! 1: LDSBA_I	ldsba	[%r16, + 0x09b1] %asi, %r14
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xde5c2290  ! 1: LDX_I	ldx	[%r16 + 0x0290], %r15
	.word 0xf0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r24
	.word 0xd6442390  ! 1: LDSW_I	ldsw	[%r16 + 0x0390], %r11
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd2cc2c24  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c24] %asi, %r9
	.word 0xda5c24a8  ! 1: LDX_I	ldx	[%r16 + 0x04a8], %r13
	brnz %r31,thr3_loop_cnt_9
	dec %r31
	.word 0x861c2ce1  ! 1: XOR_I	xor 	%r16, 0x0ce1, %r3
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
        mov 0x5d, %r31
thr3_loop_cnt_10:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd68c21c7  ! 1: LDUBA_I	lduba	[%r16, + 0x01c7] %asi, %r11
	.word 0xdadc2078  ! 1: LDXA_I	ldxa	[%r16, + 0x0078] %asi, %r13
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xe8842bf0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0bf0] %asi, %r20
	.word 0xf0042ad0  ! 1: LDUW_I	lduw	[%r16 + 0x0ad0], %r24
	.word 0xf0dc2fe8  ! 1: LDXA_I	ldxa	[%r16, + 0x0fe8] %asi, %r24
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xe4142a1a  ! 1: LDUH_I	lduh	[%r16 + 0x0a1a], %r18
	.word 0xe694252e  ! 1: LDUHA_I	lduha	[%r16, + 0x052e] %asi, %r19
	.word 0xea540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r21
	brnz %r31,thr3_loop_cnt_10
	dec %r31
        mov 0x41, %r31
thr3_loop_cnt_11:
	.word 0xf6442f00  ! 1: LDSW_I	ldsw	[%r16 + 0x0f00], %r27
	.word 0xd8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r12
	.word 0xeed4293c  ! 1: LDSHA_I	ldsha	[%r16, + 0x093c] %asi, %r23
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xde0c252a  ! 1: LDUB_I	ldub	[%r16 + 0x052a], %r15
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c425cc  ! 1: LDSWA_I	ldswa	[%r16, + 0x05cc] %asi, %r3
	.word 0xd4542aa8  ! 1: LDSH_I	ldsh	[%r16 + 0x0aa8], %r10
	brnz %r31,thr3_loop_cnt_11
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0xa33c1002  ! 1: SRAX_R	srax	%r16, %r2, %r17
        mov 0x71, %r31
thr3_loop_cnt_12:
	.word 0xc64c209a  ! 1: LDSB_I	ldsb	[%r16 + 0x009a], %r3
	.word 0xc60c2d9f  ! 1: LDUB_I	ldub	[%r16 + 0x0d9f], %r3
	.word 0xd0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r8
	.word 0xdacc2d24  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d24] %asi, %r13
	.word 0xe8142684  ! 1: LDUH_I	lduh	[%r16 + 0x0684], %r20
	.word 0xccc42ff0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ff0] %asi, %r6
	.word 0xe8c42b68  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b68] %asi, %r20
	.word 0xd0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r8
	.word 0xdac427e0  ! 1: LDSWA_I	ldswa	[%r16, + 0x07e0] %asi, %r13
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_12
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0x58, %r31
thr3_loop_cnt_13:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd8542f60  ! 1: LDSH_I	ldsh	[%r16 + 0x0f60], %r12
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc60c23da  ! 1: LDUB_I	ldub	[%r16 + 0x03da], %r3
	.word 0xee440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r23
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	.word 0xc6442b5c  ! 1: LDSW_I	ldsw	[%r16 + 0x0b5c], %r3
	.word 0xf45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r26
	brnz %r31,thr3_loop_cnt_13
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0xc1, %r31
thr3_loop_cnt_14:
	.word 0xc60425c4  ! 1: LDUW_I	lduw	[%r16 + 0x05c4], %r3
	.word 0xc6cc2f82  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f82] %asi, %r3
	.word 0xf4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r26
	.word 0xc60422c0  ! 1: LDUW_I	lduw	[%r16 + 0x02c0], %r3
	.word 0xc6d42e36  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e36] %asi, %r3
	.word 0xce5c2b68  ! 1: LDX_I	ldx	[%r16 + 0x0b68], %r7
	.word 0xc614208c  ! 1: LDUH_I	lduh	[%r16 + 0x008c], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd2c42dac  ! 1: LDSWA_I	ldswa	[%r16, + 0x0dac] %asi, %r9
	.word 0xf2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r25
	.word 0xda44248c  ! 1: LDSW_I	ldsw	[%r16 + 0x048c], %r13
	.word 0xc6942e3e  ! 1: LDUHA_I	lduha	[%r16, + 0x0e3e] %asi, %r3
	brnz %r31,thr3_loop_cnt_14
	dec %r31
	.word 0x9f341002  ! 1: SRLX_R	srlx	%r16, %r2, %r15
	.word 0x9644201d  ! 1: ADDC_I	addc 	%r16, 0x001d, %r11
        mov 0xb7, %r31
thr3_loop_cnt_15:
	.word 0xc654286e  ! 1: LDSH_I	ldsh	[%r16 + 0x086e], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc64c202d  ! 1: LDSB_I	ldsb	[%r16 + 0x002d], %r3
	.word 0xce042494  ! 1: LDUW_I	lduw	[%r16 + 0x0494], %r7
	.word 0xc6442528  ! 1: LDSW_I	ldsw	[%r16 + 0x0528], %r3
	.word 0xee941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r23
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	.word 0xc6dc2cc8  ! 1: LDXA_I	ldxa	[%r16, + 0x0cc8] %asi, %r3
	brnz %r31,thr3_loop_cnt_15
	dec %r31
	.word 0x91343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r8
        mov 0x3b, %r31
thr3_loop_cnt_16:
	.word 0xfc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r30
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc60c21eb  ! 1: LDUB_I	ldub	[%r16 + 0x01eb], %r3
	.word 0xea9426da  ! 1: LDUHA_I	lduha	[%r16, + 0x06da] %asi, %r21
	.word 0xc6142292  ! 1: LDUH_I	lduh	[%r16 + 0x0292], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf4842a80  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a80] %asi, %r26
	.word 0xc6d421b0  ! 1: LDSHA_I	ldsha	[%r16, + 0x01b0] %asi, %r3
	.word 0xc6042fb8  ! 1: LDUW_I	lduw	[%r16 + 0x0fb8], %r3
	.word 0xc69423dc  ! 1: LDUHA_I	lduha	[%r16, + 0x03dc] %asi, %r3
	.word 0xe28426b4  ! 1: LDUWA_I	lduwa	[%r16, + 0x06b4] %asi, %r17
	.word 0xfcc42bbc  ! 1: LDSWA_I	ldswa	[%r16, + 0x0bbc] %asi, %r30
	brnz %r31,thr3_loop_cnt_16
	dec %r31
	.word 0xa32c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r17
	.word 0x9e040002  ! 1: ADD_R	add 	%r16, %r2, %r15
        mov 0x47, %r31
thr3_loop_cnt_17:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xfadc2608  ! 1: LDXA_I	ldxa	[%r16, + 0x0608] %asi, %r29
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd6d42c78  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c78] %asi, %r11
	.word 0xe6442090  ! 1: LDSW_I	ldsw	[%r16 + 0x0090], %r19
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6842304  ! 1: LDUWA_I	lduwa	[%r16, + 0x0304] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_17
	dec %r31
	.word 0x863422de  ! 1: ORN_I	orn 	%r16, 0x02de, %r3
	.word 0xa4042493  ! 1: ADD_I	add 	%r16, 0x0493, %r18
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0xac, %r31
thr3_loop_cnt_18:
	.word 0xd0942f72  ! 1: LDUHA_I	lduha	[%r16, + 0x0f72] %asi, %r8
	.word 0xc68c2465  ! 1: LDUBA_I	lduba	[%r16, + 0x0465] %asi, %r3
	.word 0xc6d42780  ! 1: LDSHA_I	ldsha	[%r16, + 0x0780] %asi, %r3
	.word 0xc6142a2a  ! 1: LDUH_I	lduh	[%r16 + 0x0a2a], %r3
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xe68c2335  ! 1: LDUBA_I	lduba	[%r16, + 0x0335] %asi, %r19
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf45426d2  ! 1: LDSH_I	ldsh	[%r16 + 0x06d2], %r26
	.word 0xfa5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r29
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf28422f0  ! 1: LDUWA_I	lduwa	[%r16, + 0x02f0] %asi, %r25
	brnz %r31,thr3_loop_cnt_18
	dec %r31
	.word 0xae0c28be  ! 1: AND_I	and 	%r16, 0x08be, %r23
        mov 0x9c, %r31
thr3_loop_cnt_19:
	.word 0xc6842b14  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b14] %asi, %r3
	.word 0xe8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r20
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6942d84  ! 1: LDUHA_I	lduha	[%r16, + 0x0d84] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf0c42b64  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b64] %asi, %r24
	.word 0xe4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r18
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	.word 0xc6d429d6  ! 1: LDSHA_I	ldsha	[%r16, + 0x09d6] %asi, %r3
	.word 0xda440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r13
	.word 0xc64c2cae  ! 1: LDSB_I	ldsb	[%r16 + 0x0cae], %r3
	brnz %r31,thr3_loop_cnt_19
	dec %r31
	.word 0xb41c0002  ! 1: XOR_R	xor 	%r16, %r2, %r26
	.word 0x96140002  ! 1: OR_R	or 	%r16, %r2, %r11
        mov 0xab, %r31
thr3_loop_cnt_20:
	.word 0xc64425bc  ! 1: LDSW_I	ldsw	[%r16 + 0x05bc], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc64c24f0  ! 1: LDSB_I	ldsb	[%r16 + 0x04f0], %r3
	.word 0xc6c42384  ! 1: LDSWA_I	ldswa	[%r16, + 0x0384] %asi, %r3
	.word 0xc6842bd4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0bd4] %asi, %r3
	.word 0xfa8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r29
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xcc042420  ! 1: LDUW_I	lduw	[%r16 + 0x0420], %r6
	brnz %r31,thr3_loop_cnt_20
	dec %r31
	.word 0x9e140002  ! 1: OR_R	or 	%r16, %r2, %r15
        mov 0x3a, %r31
thr3_loop_cnt_21:
	.word 0xc65c2218  ! 1: LDX_I	ldx	[%r16 + 0x0218], %r3
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe644214c  ! 1: LDSW_I	ldsw	[%r16 + 0x014c], %r19
	.word 0xf40c2657  ! 1: LDUB_I	ldub	[%r16 + 0x0657], %r26
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xe20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r17
	.word 0xd28422f4  ! 1: LDUWA_I	lduwa	[%r16, + 0x02f4] %asi, %r9
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_21
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0xbb340002  ! 1: SRL_R	srl 	%r16, %r2, %r29
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x861c29bc  ! 1: XOR_I	xor 	%r16, 0x09bc, %r3
        mov 0x84, %r31
thr3_loop_cnt_22:
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xc6c421e8  ! 1: LDSWA_I	ldswa	[%r16, + 0x01e8] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6542e2c  ! 1: LDSH_I	ldsh	[%r16 + 0x0e2c], %r3
	.word 0xea0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r21
	.word 0xfa5c2ad8  ! 1: LDX_I	ldx	[%r16 + 0x0ad8], %r29
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd8cc2e87  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e87] %asi, %r12
	.word 0xc6cc2ad3  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ad3] %asi, %r3
	brnz %r31,thr3_loop_cnt_22
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x5b, %r31
thr3_loop_cnt_23:
	.word 0xea4c2612  ! 1: LDSB_I	ldsb	[%r16 + 0x0612], %r21
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xcc142264  ! 1: LDUH_I	lduh	[%r16 + 0x0264], %r6
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc64c2f0f  ! 1: LDSB_I	ldsb	[%r16 + 0x0f0f], %r3
	.word 0xc6c42654  ! 1: LDSWA_I	ldswa	[%r16, + 0x0654] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6d42c76  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c76] %asi, %r3
	.word 0xe80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r20
	brnz %r31,thr3_loop_cnt_23
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x90342716  ! 1: SUBC_I	orn 	%r16, 0x0716, %r8
        mov 0x9, %r31
thr3_loop_cnt_24:
	.word 0xc6d42cce  ! 1: LDSHA_I	ldsha	[%r16, + 0x0cce] %asi, %r3
	.word 0xf0dc2400  ! 1: LDXA_I	ldxa	[%r16, + 0x0400] %asi, %r24
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6842f90  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f90] %asi, %r3
	.word 0xd6542e00  ! 1: LDSH_I	ldsh	[%r16 + 0x0e00], %r11
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc60c2bc6  ! 1: LDUB_I	ldub	[%r16 + 0x0bc6], %r3
	.word 0xcc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r6
	.word 0xc60c202a  ! 1: LDUB_I	ldub	[%r16 + 0x002a], %r3
	brnz %r31,thr3_loop_cnt_24
	dec %r31
	.word 0x8d3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r6
	.word 0xb12c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r24
	.word 0x8d3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r6
	.word 0x9b2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r13
        mov 0x64, %r31
thr3_loop_cnt_25:
	.word 0xde94253c  ! 1: LDUHA_I	lduha	[%r16, + 0x053c] %asi, %r15
	.word 0xc694238c  ! 1: LDUHA_I	lduha	[%r16, + 0x038c] %asi, %r3
	.word 0xc64c248f  ! 1: LDSB_I	ldsb	[%r16 + 0x048f], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc65c2620  ! 1: LDX_I	ldx	[%r16 + 0x0620], %r3
	.word 0xc6842284  ! 1: LDUWA_I	lduwa	[%r16, + 0x0284] %asi, %r3
	.word 0xee8c2ab4  ! 1: LDUBA_I	lduba	[%r16, + 0x0ab4] %asi, %r23
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	brnz %r31,thr3_loop_cnt_25
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x860c20fc  ! 1: AND_I	and 	%r16, 0x00fc, %r3
	.word 0x9f3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r15
	.word 0x86342286  ! 1: SUBC_I	orn 	%r16, 0x0286, %r3
        mov 0x5f, %r31
thr3_loop_cnt_26:
	.word 0xc6842cac  ! 1: LDUWA_I	lduwa	[%r16, + 0x0cac] %asi, %r3
	.word 0xc6c42018  ! 1: LDSWA_I	ldswa	[%r16, + 0x0018] %asi, %r3
	.word 0xc694251c  ! 1: LDUHA_I	lduha	[%r16, + 0x051c] %asi, %r3
	.word 0xc6d42686  ! 1: LDSHA_I	ldsha	[%r16, + 0x0686] %asi, %r3
	.word 0xe6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r19
	.word 0xe6542d18  ! 1: LDSH_I	ldsh	[%r16 + 0x0d18], %r19
	.word 0xd4c429b8  ! 1: LDSWA_I	ldswa	[%r16, + 0x09b8] %asi, %r10
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	.word 0xfa440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r29
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_26
	dec %r31
        mov 0x17, %r31
thr3_loop_cnt_27:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc65c26e0  ! 1: LDX_I	ldx	[%r16 + 0x06e0], %r3
	.word 0xd0d427c4  ! 1: LDSHA_I	ldsha	[%r16, + 0x07c4] %asi, %r8
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xea0422f0  ! 1: LDUW_I	lduw	[%r16 + 0x02f0], %r21
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r25
	brnz %r31,thr3_loop_cnt_27
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0xb6140002  ! 1: OR_R	or 	%r16, %r2, %r27
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x2d, %r31
thr3_loop_cnt_28:
	.word 0xf2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r25
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r8
	.word 0xfa442334  ! 1: LDSW_I	ldsw	[%r16 + 0x0334], %r29
	.word 0xc6cc2d75  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d75] %asi, %r3
	.word 0xdedc2de8  ! 1: LDXA_I	ldxa	[%r16, + 0x0de8] %asi, %r15
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r17
	.word 0xde0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r15
	brnz %r31,thr3_loop_cnt_28
	dec %r31
	.word 0x900429dd  ! 1: ADD_I	add 	%r16, 0x09dd, %r8
	.word 0x8f3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r7
	.word 0xb61423a9  ! 1: OR_I	or 	%r16, 0x03a9, %r27
        mov 0xa7, %r31
thr3_loop_cnt_29:
	.word 0xe2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r17
	.word 0xc6cc2fb8  ! 1: LDSBA_I	ldsba	[%r16, + 0x0fb8] %asi, %r3
	.word 0xc6dc2e50  ! 1: LDXA_I	ldxa	[%r16, + 0x0e50] %asi, %r3
	.word 0xc65c26f8  ! 1: LDX_I	ldx	[%r16 + 0x06f8], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xdc8c27d0  ! 1: LDUBA_I	lduba	[%r16, + 0x07d0] %asi, %r14
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc68c201f  ! 1: LDUBA_I	lduba	[%r16, + 0x001f] %asi, %r3
	brnz %r31,thr3_loop_cnt_29
	dec %r31
	.word 0xa9342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r20
	.word 0xb8040002  ! 1: ADD_R	add 	%r16, %r2, %r28
	.word 0x9c342b54  ! 1: ORN_I	orn 	%r16, 0x0b54, %r14
	.word 0x86342c40  ! 1: SUBC_I	orn 	%r16, 0x0c40, %r3
        mov 0x85, %r31
thr3_loop_cnt_30:
	.word 0xdc842a94  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a94] %asi, %r14
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xda042d38  ! 1: LDUW_I	lduw	[%r16 + 0x0d38], %r13
	.word 0xd254206a  ! 1: LDSH_I	ldsh	[%r16 + 0x006a], %r9
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc242c  ! 1: LDSBA_I	ldsba	[%r16, + 0x042c] %asi, %r3
	.word 0xf4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r26
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_30
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0xb23c25ab  ! 1: XNOR_I	xnor 	%r16, 0x05ab, %r25
        mov 0x39, %r31
thr3_loop_cnt_31:
	.word 0xc6142082  ! 1: LDUH_I	lduh	[%r16 + 0x0082], %r3
	.word 0xc6cc252c  ! 1: LDSBA_I	ldsba	[%r16, + 0x052c] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc65425ae  ! 1: LDSH_I	ldsh	[%r16 + 0x05ae], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r26
	.word 0xc6d42804  ! 1: LDSHA_I	ldsha	[%r16, + 0x0804] %asi, %r3
	.word 0xc6d4232a  ! 1: LDSHA_I	ldsha	[%r16, + 0x032a] %asi, %r3
	brnz %r31,thr3_loop_cnt_31
	dec %r31
	.word 0xa41c2e83  ! 1: XOR_I	xor 	%r16, 0x0e83, %r18
	.word 0x863c2291  ! 1: XNOR_I	xnor 	%r16, 0x0291, %r3
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x39, %r31
thr3_loop_cnt_32:
	.word 0xe684269c  ! 1: LDUWA_I	lduwa	[%r16, + 0x069c] %asi, %r19
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	.word 0xe2442c30  ! 1: LDSW_I	ldsw	[%r16 + 0x0c30], %r17
	.word 0xf2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r25
	.word 0xc6142420  ! 1: LDUH_I	lduh	[%r16 + 0x0420], %r3
	.word 0xee442484  ! 1: LDSW_I	ldsw	[%r16 + 0x0484], %r23
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6cc2c01  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c01] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_32
	dec %r31
	.word 0xab342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r21
        mov 0x35, %r31
thr3_loop_cnt_33:
	.word 0xd2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r9
	.word 0xd4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r10
	.word 0xc6542772  ! 1: LDSH_I	ldsh	[%r16 + 0x0772], %r3
	.word 0xccc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r6
	.word 0xfc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r30
	.word 0xd25c25b8  ! 1: LDX_I	ldx	[%r16 + 0x05b8], %r9
	.word 0xd0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r8
	.word 0xc6542452  ! 1: LDSH_I	ldsh	[%r16 + 0x0452], %r3
	.word 0xd49427bc  ! 1: LDUHA_I	lduha	[%r16, + 0x07bc] %asi, %r10
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd6942ce8  ! 1: LDUHA_I	lduha	[%r16, + 0x0ce8] %asi, %r11
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_33
	dec %r31
	.word 0xa9343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r20
        mov 0x33, %r31
thr3_loop_cnt_34:
	.word 0xf4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r26
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	.word 0xf0142986  ! 1: LDUH_I	lduh	[%r16 + 0x0986], %r24
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc64c2b78  ! 1: LDSB_I	ldsb	[%r16 + 0x0b78], %r3
	.word 0xc65424f6  ! 1: LDSH_I	ldsh	[%r16 + 0x04f6], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r12
	.word 0xec142e34  ! 1: LDUH_I	lduh	[%r16 + 0x0e34], %r22
	.word 0xdacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r13
	brnz %r31,thr3_loop_cnt_34
	dec %r31
        mov 0x9a, %r31
thr3_loop_cnt_35:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xea8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r21
	.word 0xc6542044  ! 1: LDSH_I	ldsh	[%r16 + 0x0044], %r3
	.word 0xc6c42934  ! 1: LDSWA_I	ldswa	[%r16, + 0x0934] %asi, %r3
	.word 0xf2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r25
	.word 0xce5c2ad8  ! 1: LDX_I	ldx	[%r16 + 0x0ad8], %r7
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	.word 0xc64421a4  ! 1: LDSW_I	ldsw	[%r16 + 0x01a4], %r3
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	brnz %r31,thr3_loop_cnt_35
	dec %r31
        mov 0xc4, %r31
thr3_loop_cnt_36:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	.word 0xda4c2c36  ! 1: LDSB_I	ldsb	[%r16 + 0x0c36], %r13
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xda841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r13
	.word 0xde4c232d  ! 1: LDSB_I	ldsb	[%r16 + 0x032d], %r15
	.word 0xcc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r6
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc68c2df2  ! 1: LDUBA_I	lduba	[%r16, + 0x0df2] %asi, %r3
	.word 0xe65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r19
	.word 0xd25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r9
	.word 0xc64c2559  ! 1: LDSB_I	ldsb	[%r16 + 0x0559], %r3
	brnz %r31,thr3_loop_cnt_36
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x94342838  ! 1: ORN_I	orn 	%r16, 0x0838, %r10
        mov 0x6b, %r31
thr3_loop_cnt_37:
	.word 0xeecc2773  ! 1: LDSBA_I	ldsba	[%r16, + 0x0773] %asi, %r23
	.word 0xda5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r13
	.word 0xc68c235e  ! 1: LDUBA_I	lduba	[%r16, + 0x035e] %asi, %r3
	.word 0xded420b6  ! 1: LDSHA_I	ldsha	[%r16, + 0x00b6] %asi, %r15
	.word 0xc654241a  ! 1: LDSH_I	ldsh	[%r16 + 0x041a], %r3
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xc6442f30  ! 1: LDSW_I	ldsw	[%r16 + 0x0f30], %r3
	.word 0xc6c42530  ! 1: LDSWA_I	ldswa	[%r16, + 0x0530] %asi, %r3
	.word 0xecd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r22
	.word 0xf2942bf2  ! 1: LDUHA_I	lduha	[%r16, + 0x0bf2] %asi, %r25
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_37
	dec %r31
	.word 0xbc340002  ! 1: SUBC_R	orn 	%r16, %r2, %r30
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0x7c, %r31
thr3_loop_cnt_38:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xc6c42a78  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a78] %asi, %r3
	.word 0xf49427b6  ! 1: LDUHA_I	lduha	[%r16, + 0x07b6] %asi, %r26
	.word 0xe84421d0  ! 1: LDSW_I	ldsw	[%r16 + 0x01d0], %r20
	.word 0xc6842ff4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ff4] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xda0423dc  ! 1: LDUW_I	lduw	[%r16 + 0x03dc], %r13
	.word 0xf4cc2bbc  ! 1: LDSBA_I	ldsba	[%r16, + 0x0bbc] %asi, %r26
	.word 0xf48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r26
	brnz %r31,thr3_loop_cnt_38
	dec %r31
        mov 0x10, %r31
thr3_loop_cnt_39:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2eb5  ! 1: LDSBA_I	ldsba	[%r16, + 0x0eb5] %asi, %r3
	.word 0xe60c2467  ! 1: LDUB_I	ldub	[%r16 + 0x0467], %r19
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xea94278a  ! 1: LDUHA_I	lduha	[%r16, + 0x078a] %asi, %r21
	.word 0xecc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r22
	.word 0xc6142bda  ! 1: LDUH_I	lduh	[%r16 + 0x0bda], %r3
	.word 0xd2442e78  ! 1: LDSW_I	ldsw	[%r16 + 0x0e78], %r9
	.word 0xc6cc220e  ! 1: LDSBA_I	ldsba	[%r16, + 0x020e] %asi, %r3
	.word 0xe64c2f35  ! 1: LDSB_I	ldsb	[%r16 + 0x0f35], %r19
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc60c222b  ! 1: LDUB_I	ldub	[%r16 + 0x022b], %r3
	brnz %r31,thr3_loop_cnt_39
	dec %r31
	.word 0xa53c0002  ! 1: SRA_R	sra 	%r16, %r2, %r18
	.word 0xa73c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r19
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x9e340002  ! 1: SUBC_R	orn 	%r16, %r2, %r15
        mov 0x24, %r31
thr3_loop_cnt_40:
	.word 0xc6042220  ! 1: LDUW_I	lduw	[%r16 + 0x0220], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6c42b14  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b14] %asi, %r3
	.word 0xcc5c2520  ! 1: LDX_I	ldx	[%r16 + 0x0520], %r6
	brnz %r31,thr3_loop_cnt_40
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x84, %r31
thr3_loop_cnt_41:
	.word 0xc6942ae0  ! 1: LDUHA_I	lduha	[%r16, + 0x0ae0] %asi, %r3
	.word 0xc64427b0  ! 1: LDSW_I	ldsw	[%r16 + 0x07b0], %r3
	.word 0xc64c235b  ! 1: LDSB_I	ldsb	[%r16 + 0x035b], %r3
	.word 0xfc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r30
	.word 0xd2d42514  ! 1: LDSHA_I	ldsha	[%r16, + 0x0514] %asi, %r9
	.word 0xc6cc206b  ! 1: LDSBA_I	ldsba	[%r16, + 0x006b] %asi, %r3
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xc64c26b7  ! 1: LDSB_I	ldsb	[%r16 + 0x06b7], %r3
	brnz %r31,thr3_loop_cnt_41
	dec %r31
	.word 0xa33c0002  ! 1: SRA_R	sra 	%r16, %r2, %r17
	.word 0x86342108  ! 1: SUBC_I	orn 	%r16, 0x0108, %r3
        mov 0x4a, %r31
thr3_loop_cnt_42:
	.word 0xd0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r8
	.word 0xe45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r18
	.word 0xe2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r17
	.word 0xc65c2680  ! 1: LDX_I	ldx	[%r16 + 0x0680], %r3
	.word 0xc6042b98  ! 1: LDUW_I	lduw	[%r16 + 0x0b98], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	brnz %r31,thr3_loop_cnt_42
	dec %r31
	.word 0xb1340002  ! 1: SRL_R	srl 	%r16, %r2, %r24
	.word 0x862c2b5c  ! 1: ANDN_I	andn 	%r16, 0x0b5c, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x863c2932  ! 1: XNOR_I	xnor 	%r16, 0x0932, %r3
        mov 0x10, %r31
thr3_loop_cnt_43:
	.word 0xd4cc26af  ! 1: LDSBA_I	ldsba	[%r16, + 0x06af] %asi, %r10
	.word 0xc6c42644  ! 1: LDSWA_I	ldswa	[%r16, + 0x0644] %asi, %r3
	.word 0xc6942d74  ! 1: LDUHA_I	lduha	[%r16, + 0x0d74] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6c421b0  ! 1: LDSWA_I	ldswa	[%r16, + 0x01b0] %asi, %r3
	.word 0xf6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r27
	.word 0xd0d4261c  ! 1: LDSHA_I	ldsha	[%r16, + 0x061c] %asi, %r8
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6042e60  ! 1: LDUW_I	lduw	[%r16 + 0x0e60], %r3
	.word 0xcec425e4  ! 1: LDSWA_I	ldswa	[%r16, + 0x05e4] %asi, %r7
	brnz %r31,thr3_loop_cnt_43
	dec %r31
	.word 0x86342024  ! 1: SUBC_I	orn 	%r16, 0x0024, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x9e, %r31
thr3_loop_cnt_44:
	.word 0xda84273c  ! 1: LDUWA_I	lduwa	[%r16, + 0x073c] %asi, %r13
	.word 0xea542ec2  ! 1: LDSH_I	ldsh	[%r16 + 0x0ec2], %r21
	.word 0xc65c2c68  ! 1: LDX_I	ldx	[%r16 + 0x0c68], %r3
	.word 0xf2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r25
	.word 0xe20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r17
	.word 0xde842a88  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a88] %asi, %r15
	.word 0xc68c209d  ! 1: LDUBA_I	lduba	[%r16, + 0x009d] %asi, %r3
	.word 0xd8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r12
	.word 0xecdc2140  ! 1: LDXA_I	ldxa	[%r16, + 0x0140] %asi, %r22
	.word 0xe8c423f8  ! 1: LDSWA_I	ldswa	[%r16, + 0x03f8] %asi, %r20
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xeacc27d5  ! 1: LDSBA_I	ldsba	[%r16, + 0x07d5] %asi, %r21
	brnz %r31,thr3_loop_cnt_44
	dec %r31
	.word 0x952c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r10
        mov 0x84, %r31
thr3_loop_cnt_45:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd68c25b3  ! 1: LDUBA_I	lduba	[%r16, + 0x05b3] %asi, %r11
	.word 0xc6dc2298  ! 1: LDXA_I	ldxa	[%r16, + 0x0298] %asi, %r3
	.word 0xf00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r24
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd89427e8  ! 1: LDUHA_I	lduha	[%r16, + 0x07e8] %asi, %r12
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd4cc203b  ! 1: LDSBA_I	ldsba	[%r16, + 0x003b] %asi, %r10
	brnz %r31,thr3_loop_cnt_45
	dec %r31
	.word 0xaf340002  ! 1: SRL_R	srl 	%r16, %r2, %r23
	.word 0xa8240002  ! 1: SUB_R	sub 	%r16, %r2, %r20
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x38, %r31
thr3_loop_cnt_46:
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6d42b6a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b6a] %asi, %r3
	.word 0xc65c2418  ! 1: LDX_I	ldx	[%r16 + 0x0418], %r3
	.word 0xc6d424c8  ! 1: LDSHA_I	ldsha	[%r16, + 0x04c8] %asi, %r3
	.word 0xfcc421a4  ! 1: LDSWA_I	ldswa	[%r16, + 0x01a4] %asi, %r30
	brnz %r31,thr3_loop_cnt_46
	dec %r31
        mov 0x31, %r31
thr3_loop_cnt_47:
	.word 0xc61420f4  ! 1: LDUH_I	lduh	[%r16 + 0x00f4], %r3
	.word 0xee042d1c  ! 1: LDUW_I	lduw	[%r16 + 0x0d1c], %r23
	.word 0xf8042080  ! 1: LDUW_I	lduw	[%r16 + 0x0080], %r28
	.word 0xc654235c  ! 1: LDSH_I	ldsh	[%r16 + 0x035c], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r19
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_47
	dec %r31
	.word 0x953c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r10
	.word 0x86342fb5  ! 1: ORN_I	orn 	%r16, 0x0fb5, %r3
        mov 0x57, %r31
thr3_loop_cnt_48:
	.word 0xd2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r9
	.word 0xf60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r27
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xdcd42080  ! 1: LDSHA_I	ldsha	[%r16, + 0x0080] %asi, %r14
	.word 0xfa0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r29
	.word 0xc6042ec0  ! 1: LDUW_I	lduw	[%r16 + 0x0ec0], %r3
	.word 0xe6142994  ! 1: LDUH_I	lduh	[%r16 + 0x0994], %r19
	.word 0xf6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r27
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6042794  ! 1: LDUW_I	lduw	[%r16 + 0x0794], %r3
	brnz %r31,thr3_loop_cnt_48
	dec %r31
        mov 0x58, %r31
thr3_loop_cnt_49:
	.word 0xc614241e  ! 1: LDUH_I	lduh	[%r16 + 0x041e], %r3
	.word 0xc6cc2372  ! 1: LDSBA_I	ldsba	[%r16, + 0x0372] %asi, %r3
	.word 0xc60c2d30  ! 1: LDUB_I	ldub	[%r16 + 0x0d30], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc644256c  ! 1: LDSW_I	ldsw	[%r16 + 0x056c], %r3
	.word 0xde442d80  ! 1: LDSW_I	ldsw	[%r16 + 0x0d80], %r15
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_49
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0xb02c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r24
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x89, %r31
thr3_loop_cnt_50:
	.word 0xce941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r7
	.word 0xc60c252b  ! 1: LDUB_I	ldub	[%r16 + 0x052b], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe25c2130  ! 1: LDX_I	ldx	[%r16 + 0x0130], %r17
	.word 0xc6c425b8  ! 1: LDSWA_I	ldswa	[%r16, + 0x05b8] %asi, %r3
	.word 0xc65428ce  ! 1: LDSH_I	ldsh	[%r16 + 0x08ce], %r3
	.word 0xfc542ffa  ! 1: LDSH_I	ldsh	[%r16 + 0x0ffa], %r30
	.word 0xf24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r25
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe8dc2958  ! 1: LDXA_I	ldxa	[%r16, + 0x0958] %asi, %r20
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	brnz %r31,thr3_loop_cnt_50
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0x58, %r31
thr3_loop_cnt_51:
	.word 0xea0c25e8  ! 1: LDUB_I	ldub	[%r16 + 0x05e8], %r21
	.word 0xe4042e84  ! 1: LDUW_I	lduw	[%r16 + 0x0e84], %r18
	.word 0xec0c2f7e  ! 1: LDUB_I	ldub	[%r16 + 0x0f7e], %r22
	.word 0xcc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r6
	.word 0xee140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r23
	.word 0xc6542a5a  ! 1: LDSH_I	ldsh	[%r16 + 0x0a5a], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2048  ! 1: LDXA_I	ldxa	[%r16, + 0x0048] %asi, %r3
	brnz %r31,thr3_loop_cnt_51
	dec %r31
	.word 0xa32c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r17
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x1e, %r31
thr3_loop_cnt_52:
	.word 0xd45c29f8  ! 1: LDX_I	ldx	[%r16 + 0x09f8], %r10
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r26
	.word 0xdcc422d0  ! 1: LDSWA_I	ldswa	[%r16, + 0x02d0] %asi, %r14
	.word 0xe6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r19
	.word 0xc6442038  ! 1: LDSW_I	ldsw	[%r16 + 0x0038], %r3
	.word 0xc6542e1a  ! 1: LDSH_I	ldsh	[%r16 + 0x0e1a], %r3
	.word 0xc6cc2be3  ! 1: LDSBA_I	ldsba	[%r16, + 0x0be3] %asi, %r3
	.word 0xc64c2456  ! 1: LDSB_I	ldsb	[%r16 + 0x0456], %r3
	brnz %r31,thr3_loop_cnt_52
	dec %r31
	.word 0x860420eb  ! 1: ADD_I	add 	%r16, 0x00eb, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x8e, %r31
thr3_loop_cnt_53:
	.word 0xea0429d8  ! 1: LDUW_I	lduw	[%r16 + 0x09d8], %r21
	.word 0xfc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r30
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6c427cc  ! 1: LDSWA_I	ldswa	[%r16, + 0x07cc] %asi, %r3
	.word 0xc65c2020  ! 1: LDX_I	ldx	[%r16 + 0x0020], %r3
	.word 0xda042ad4  ! 1: LDUW_I	lduw	[%r16 + 0x0ad4], %r13
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6542f1a  ! 1: LDSH_I	ldsh	[%r16 + 0x0f1a], %r3
	brnz %r31,thr3_loop_cnt_53
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0xa2242ba7  ! 1: SUB_I	sub 	%r16, 0x0ba7, %r17
	.word 0x9c040002  ! 1: ADD_R	add 	%r16, %r2, %r14
        mov 0x8b, %r31
thr3_loop_cnt_54:
	.word 0xd4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r10
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6c42200  ! 1: LDSWA_I	ldswa	[%r16, + 0x0200] %asi, %r3
	.word 0xda5c2538  ! 1: LDX_I	ldx	[%r16 + 0x0538], %r13
	.word 0xf20c2508  ! 1: LDUB_I	ldub	[%r16 + 0x0508], %r25
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xdc542a16  ! 1: LDSH_I	ldsh	[%r16 + 0x0a16], %r14
	.word 0xf05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r24
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r12
	brnz %r31,thr3_loop_cnt_54
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x8f3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r7
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0xa4, %r31
thr3_loop_cnt_55:
	.word 0xe2d42b36  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b36] %asi, %r17
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r28
	.word 0xe8042dfc  ! 1: LDUW_I	lduw	[%r16 + 0x0dfc], %r20
	.word 0xe8542462  ! 1: LDSH_I	ldsh	[%r16 + 0x0462], %r20
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6542e56  ! 1: LDSH_I	ldsh	[%r16 + 0x0e56], %r3
	.word 0xe6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r19
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r9
	.word 0xc6cc2224  ! 1: LDSBA_I	ldsba	[%r16, + 0x0224] %asi, %r3
	brnz %r31,thr3_loop_cnt_55
	dec %r31
        mov 0x5f, %r31
thr3_loop_cnt_56:
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xccc422e8  ! 1: LDSWA_I	ldswa	[%r16, + 0x02e8] %asi, %r6
	.word 0xdcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r14
	.word 0xf60427b0  ! 1: LDUW_I	lduw	[%r16 + 0x07b0], %r27
	.word 0xc6d42b50  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b50] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc60c2b2a  ! 1: LDUB_I	ldub	[%r16 + 0x0b2a], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_56
	dec %r31
	.word 0xb4342068  ! 1: ORN_I	orn 	%r16, 0x0068, %r26
        mov 0x5e, %r31
thr3_loop_cnt_57:
	.word 0xee440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r23
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	.word 0xc6c429c0  ! 1: LDSWA_I	ldswa	[%r16, + 0x09c0] %asi, %r3
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6d42ef0  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ef0] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xce8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r7
	brnz %r31,thr3_loop_cnt_57
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x86342621  ! 1: ORN_I	orn 	%r16, 0x0621, %r3
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0xb83c28a7  ! 1: XNOR_I	xnor 	%r16, 0x08a7, %r28
        mov 0x27, %r31
thr3_loop_cnt_58:
	.word 0xd6dc2d28  ! 1: LDXA_I	ldxa	[%r16, + 0x0d28] %asi, %r11
	.word 0xc6c427e0  ! 1: LDSWA_I	ldswa	[%r16, + 0x07e0] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r8
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6042ba0  ! 1: LDUW_I	lduw	[%r16 + 0x0ba0], %r3
	.word 0xfa540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r29
	.word 0xc6d42004  ! 1: LDSHA_I	ldsha	[%r16, + 0x0004] %asi, %r3
	.word 0xdc4421c0  ! 1: LDSW_I	ldsw	[%r16 + 0x01c0], %r14
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_58
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x860c29ed  ! 1: AND_I	and 	%r16, 0x09ed, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x55, %r31
thr3_loop_cnt_59:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc65c2a40  ! 1: LDX_I	ldx	[%r16 + 0x0a40], %r3
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xc6cc2390  ! 1: LDSBA_I	ldsba	[%r16, + 0x0390] %asi, %r3
	.word 0xc60c282f  ! 1: LDUB_I	ldub	[%r16 + 0x082f], %r3
	.word 0xced41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r7
	.word 0xc6042bc4  ! 1: LDUW_I	lduw	[%r16 + 0x0bc4], %r3
	.word 0xc64c24e2  ! 1: LDSB_I	ldsb	[%r16 + 0x04e2], %r3
	.word 0xf4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r26
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_59
	dec %r31
        mov 0xaa, %r31
thr3_loop_cnt_60:
	.word 0xd41426d8  ! 1: LDUH_I	lduh	[%r16 + 0x06d8], %r10
	.word 0xfa5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r29
	.word 0xc65425b2  ! 1: LDSH_I	ldsh	[%r16 + 0x05b2], %r3
	.word 0xc64c2049  ! 1: LDSB_I	ldsb	[%r16 + 0x0049], %r3
	.word 0xc6c42474  ! 1: LDSWA_I	ldswa	[%r16, + 0x0474] %asi, %r3
	.word 0xe25c2190  ! 1: LDX_I	ldx	[%r16 + 0x0190], %r17
	.word 0xe28c21fd  ! 1: LDUBA_I	lduba	[%r16, + 0x01fd] %asi, %r17
	.word 0xc65c2c00  ! 1: LDX_I	ldx	[%r16 + 0x0c00], %r3
	.word 0xc6dc2868  ! 1: LDXA_I	ldxa	[%r16, + 0x0868] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_60
	dec %r31
        mov 0x14, %r31
thr3_loop_cnt_61:
	.word 0xe6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r19
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe8042384  ! 1: LDUW_I	lduw	[%r16 + 0x0384], %r20
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64420b0  ! 1: LDSW_I	ldsw	[%r16 + 0x00b0], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r28
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_61
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x8e340002  ! 1: ORN_R	orn 	%r16, %r2, %r7
        mov 0x5f, %r31
thr3_loop_cnt_62:
	.word 0xcc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r6
	.word 0xeecc26ec  ! 1: LDSBA_I	ldsba	[%r16, + 0x06ec] %asi, %r23
	.word 0xc6442554  ! 1: LDSW_I	ldsw	[%r16 + 0x0554], %r3
	.word 0xc6c428a0  ! 1: LDSWA_I	ldswa	[%r16, + 0x08a0] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6842738  ! 1: LDUWA_I	lduwa	[%r16, + 0x0738] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6042440  ! 1: LDUW_I	lduw	[%r16 + 0x0440], %r3
	.word 0xd0d42528  ! 1: LDSHA_I	ldsha	[%r16, + 0x0528] %asi, %r8
	brnz %r31,thr3_loop_cnt_62
	dec %r31
	.word 0x86442137  ! 1: ADDC_I	addc 	%r16, 0x0137, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x8e140002  ! 1: OR_R	or 	%r16, %r2, %r7
        mov 0x67, %r31
thr3_loop_cnt_63:
	.word 0xf4cc233d  ! 1: LDSBA_I	ldsba	[%r16, + 0x033d] %asi, %r26
	.word 0xec040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r22
	.word 0xc6c42c84  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c84] %asi, %r3
	.word 0xda540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r13
	.word 0xd68c2be4  ! 1: LDUBA_I	lduba	[%r16, + 0x0be4] %asi, %r11
	.word 0xf00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r24
	.word 0xc6d42ec8  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ec8] %asi, %r3
	.word 0xe4042654  ! 1: LDUW_I	lduw	[%r16 + 0x0654], %r18
	.word 0xd6d4272a  ! 1: LDSHA_I	ldsha	[%r16, + 0x072a] %asi, %r11
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_63
	dec %r31
	.word 0x86342ba6  ! 1: SUBC_I	orn 	%r16, 0x0ba6, %r3
	.word 0x902c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r8
	.word 0x8f341002  ! 1: SRLX_R	srlx	%r16, %r2, %r7
	.word 0xaa440002  ! 1: ADDC_R	addc 	%r16, %r2, %r21
        mov 0x31, %r31
thr3_loop_cnt_64:
	.word 0xc6d4259a  ! 1: LDSHA_I	ldsha	[%r16, + 0x059a] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc65c2620  ! 1: LDX_I	ldx	[%r16 + 0x0620], %r3
	.word 0xc6c42000  ! 1: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r3
	.word 0xe2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r17
	.word 0xda042d78  ! 1: LDUW_I	lduw	[%r16 + 0x0d78], %r13
	.word 0xc68c2bb4  ! 1: LDUBA_I	lduba	[%r16, + 0x0bb4] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xec440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r22
	.word 0xc6042fe0  ! 1: LDUW_I	lduw	[%r16 + 0x0fe0], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd8cc26cf  ! 1: LDSBA_I	ldsba	[%r16, + 0x06cf] %asi, %r12
	brnz %r31,thr3_loop_cnt_64
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x4f, %r31
thr3_loop_cnt_65:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd88c2a6e  ! 1: LDUBA_I	lduba	[%r16, + 0x0a6e] %asi, %r12
	.word 0xf4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r26
	.word 0xce442754  ! 1: LDSW_I	ldsw	[%r16 + 0x0754], %r7
	.word 0xd04c2d9b  ! 1: LDSB_I	ldsb	[%r16 + 0x0d9b], %r8
	brnz %r31,thr3_loop_cnt_65
	dec %r31
        mov 0x21, %r31
thr3_loop_cnt_66:
	.word 0xc60427c8  ! 1: LDUW_I	lduw	[%r16 + 0x07c8], %r3
	.word 0xea140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r21
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd4dc22d8  ! 1: LDXA_I	ldxa	[%r16, + 0x02d8] %asi, %r10
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc60420e4  ! 1: LDUW_I	lduw	[%r16 + 0x00e4], %r3
	.word 0xcc042640  ! 1: LDUW_I	lduw	[%r16 + 0x0640], %r6
	.word 0xc6c42c84  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c84] %asi, %r3
	.word 0xf65c2080  ! 1: LDX_I	ldx	[%r16 + 0x0080], %r27
	brnz %r31,thr3_loop_cnt_66
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0xae040002  ! 1: ADD_R	add 	%r16, %r2, %r23
        mov 0x9d, %r31
thr3_loop_cnt_67:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c2ef5  ! 1: LDSB_I	ldsb	[%r16 + 0x0ef5], %r3
	.word 0xc6442318  ! 1: LDSW_I	ldsw	[%r16 + 0x0318], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc69421ea  ! 1: LDUHA_I	lduha	[%r16, + 0x01ea] %asi, %r3
	.word 0xf00c2e6e  ! 1: LDUB_I	ldub	[%r16 + 0x0e6e], %r24
	.word 0xe84424fc  ! 1: LDSW_I	ldsw	[%r16 + 0x04fc], %r20
	.word 0xe2942e46  ! 1: LDUHA_I	lduha	[%r16, + 0x0e46] %asi, %r17
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd45c2ae0  ! 1: LDX_I	ldx	[%r16 + 0x0ae0], %r10
	.word 0xc6042964  ! 1: LDUW_I	lduw	[%r16 + 0x0964], %r3
	.word 0xc64428bc  ! 1: LDSW_I	ldsw	[%r16 + 0x08bc], %r3
	brnz %r31,thr3_loop_cnt_67
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x862c2ac1  ! 1: ANDN_I	andn 	%r16, 0x0ac1, %r3
	.word 0x9604204f  ! 1: ADD_I	add 	%r16, 0x004f, %r11
        mov 0x2d, %r31
thr3_loop_cnt_68:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xfc8c28ee  ! 1: LDUBA_I	lduba	[%r16, + 0x08ee] %asi, %r30
	.word 0xc64c2e23  ! 1: LDSB_I	ldsb	[%r16 + 0x0e23], %r3
	.word 0xec4c2539  ! 1: LDSB_I	ldsb	[%r16 + 0x0539], %r22
	.word 0xc68c2cf2  ! 1: LDUBA_I	lduba	[%r16, + 0x0cf2] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xce4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r7
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_68
	dec %r31
        mov 0xac, %r31
thr3_loop_cnt_69:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xdec42a50  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a50] %asi, %r15
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd2d42e16  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e16] %asi, %r9
	.word 0xc6042978  ! 1: LDUW_I	lduw	[%r16 + 0x0978], %r3
	.word 0xce440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r7
	.word 0xd8442704  ! 1: LDSW_I	ldsw	[%r16 + 0x0704], %r12
	.word 0xc65c2648  ! 1: LDX_I	ldx	[%r16 + 0x0648], %r3
	.word 0xf45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r26
	brnz %r31,thr3_loop_cnt_69
	dec %r31
        mov 0x48, %r31
thr3_loop_cnt_70:
	.word 0xc60c2fb1  ! 1: LDUB_I	ldub	[%r16 + 0x0fb1], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc644271c  ! 1: LDSW_I	ldsw	[%r16 + 0x071c], %r3
	.word 0xc6cc2ed7  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ed7] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6d42794  ! 1: LDSHA_I	ldsha	[%r16, + 0x0794] %asi, %r3
	.word 0xdedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r15
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_70
	dec %r31
	.word 0x863c2a76  ! 1: XNOR_I	xnor 	%r16, 0x0a76, %r3
        mov 0x7a, %r31
thr3_loop_cnt_71:
	.word 0xd85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r12
	.word 0xd08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r8
	.word 0xc60c2a3c  ! 1: LDUB_I	ldub	[%r16 + 0x0a3c], %r3
	.word 0xf8542178  ! 1: LDSH_I	ldsh	[%r16 + 0x0178], %r28
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xfc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r30
	.word 0xc68c2ece  ! 1: LDUBA_I	lduba	[%r16, + 0x0ece] %asi, %r3
	.word 0xfcd426e2  ! 1: LDSHA_I	ldsha	[%r16, + 0x06e2] %asi, %r30
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	brnz %r31,thr3_loop_cnt_71
	dec %r31
	.word 0xb5343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r26
	.word 0x86342072  ! 1: ORN_I	orn 	%r16, 0x0072, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0x9d, %r31
thr3_loop_cnt_72:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c229d  ! 1: LDSB_I	ldsb	[%r16 + 0x029d], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r11
	.word 0xf25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r25
	.word 0xc6cc2c07  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c07] %asi, %r3
	.word 0xe6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r19
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	brnz %r31,thr3_loop_cnt_72
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x862c2917  ! 1: ANDN_I	andn 	%r16, 0x0917, %r3
        mov 0x0, %r31
thr3_loop_cnt_73:
	.word 0xea542d5e  ! 1: LDSH_I	ldsh	[%r16 + 0x0d5e], %r21
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc68c2b02  ! 1: LDUBA_I	lduba	[%r16, + 0x0b02] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc64c2d0a  ! 1: LDSB_I	ldsb	[%r16 + 0x0d0a], %r3
	.word 0xc60428e4  ! 1: LDUW_I	lduw	[%r16 + 0x08e4], %r3
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6442b08  ! 1: LDSW_I	ldsw	[%r16 + 0x0b08], %r3
	.word 0xdcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r14
	brnz %r31,thr3_loop_cnt_73
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0x16, %r31
thr3_loop_cnt_74:
	.word 0xc6542508  ! 1: LDSH_I	ldsh	[%r16 + 0x0508], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc61421ea  ! 1: LDUH_I	lduh	[%r16 + 0x01ea], %r3
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xe49424be  ! 1: LDUHA_I	lduha	[%r16, + 0x04be] %asi, %r18
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe20421c4  ! 1: LDUW_I	lduw	[%r16 + 0x01c4], %r17
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_74
	dec %r31
        mov 0x69, %r31
thr3_loop_cnt_75:
	.word 0xf6442b04  ! 1: LDSW_I	ldsw	[%r16 + 0x0b04], %r27
	.word 0xc6842634  ! 1: LDUWA_I	lduwa	[%r16, + 0x0634] %asi, %r3
	.word 0xd04c2631  ! 1: LDSB_I	ldsb	[%r16 + 0x0631], %r8
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xc6d42756  ! 1: LDSHA_I	ldsha	[%r16, + 0x0756] %asi, %r3
	.word 0xc6542e84  ! 1: LDSH_I	ldsh	[%r16 + 0x0e84], %r3
	.word 0xdc142f4c  ! 1: LDUH_I	lduh	[%r16 + 0x0f4c], %r14
	.word 0xc6842ea0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ea0] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_75
	dec %r31
	.word 0x862c2eef  ! 1: ANDN_I	andn 	%r16, 0x0eef, %r3
        mov 0x51, %r31
thr3_loop_cnt_76:
	.word 0xd84c22ed  ! 1: LDSB_I	ldsb	[%r16 + 0x02ed], %r12
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	.word 0xf4442cec  ! 1: LDSW_I	ldsw	[%r16 + 0x0cec], %r26
	.word 0xc65427c0  ! 1: LDSH_I	ldsh	[%r16 + 0x07c0], %r3
	.word 0xd0842af0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0af0] %asi, %r8
	.word 0xda8c2435  ! 1: LDUBA_I	lduba	[%r16, + 0x0435] %asi, %r13
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	.word 0xea8424ac  ! 1: LDUWA_I	lduwa	[%r16, + 0x04ac] %asi, %r21
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	.word 0xc6542178  ! 1: LDSH_I	ldsh	[%r16 + 0x0178], %r3
	.word 0xc6942494  ! 1: LDUHA_I	lduha	[%r16, + 0x0494] %asi, %r3
	brnz %r31,thr3_loop_cnt_76
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x860c2162  ! 1: AND_I	and 	%r16, 0x0162, %r3
        mov 0x1d, %r31
thr3_loop_cnt_77:
	.word 0xf8c420ac  ! 1: LDSWA_I	ldswa	[%r16, + 0x00ac] %asi, %r28
	.word 0xc6c42520  ! 1: LDSWA_I	ldswa	[%r16, + 0x0520] %asi, %r3
	.word 0xdc5420ec  ! 1: LDSH_I	ldsh	[%r16 + 0x00ec], %r14
	.word 0xfc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r30
	.word 0xe65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r19
	.word 0xc64c2042  ! 1: LDSB_I	ldsb	[%r16 + 0x0042], %r3
	.word 0xe8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r20
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xdac425c0  ! 1: LDSWA_I	ldswa	[%r16, + 0x05c0] %asi, %r13
	brnz %r31,thr3_loop_cnt_77
	dec %r31
	.word 0xa92c0002  ! 1: SLL_R	sll 	%r16, %r2, %r20
	.word 0xb8440002  ! 1: ADDC_R	addc 	%r16, %r2, %r28
	.word 0x86142008  ! 1: OR_I	or 	%r16, 0x0008, %r3
        mov 0x97, %r31
thr3_loop_cnt_78:
	.word 0xc68c2dd7  ! 1: LDUBA_I	lduba	[%r16, + 0x0dd7] %asi, %r3
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xcc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r6
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xce8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r7
	.word 0xf4d427c8  ! 1: LDSHA_I	ldsha	[%r16, + 0x07c8] %asi, %r26
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf4142f8c  ! 1: LDUH_I	lduh	[%r16 + 0x0f8c], %r26
	.word 0xecdc2258  ! 1: LDXA_I	ldxa	[%r16, + 0x0258] %asi, %r22
	brnz %r31,thr3_loop_cnt_78
	dec %r31
	.word 0xaa242ab1  ! 1: SUB_I	sub 	%r16, 0x0ab1, %r21
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x9d, %r31
thr3_loop_cnt_79:
	.word 0xc60c2335  ! 1: LDUB_I	ldub	[%r16 + 0x0335], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd28c2470  ! 1: LDUBA_I	lduba	[%r16, + 0x0470] %asi, %r9
	.word 0xc6942d22  ! 1: LDUHA_I	lduha	[%r16, + 0x0d22] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6442034  ! 1: LDSW_I	ldsw	[%r16 + 0x0034], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r28
	.word 0xc6cc2b8a  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b8a] %asi, %r3
	brnz %r31,thr3_loop_cnt_79
	dec %r31
	.word 0xac3420a4  ! 1: ORN_I	orn 	%r16, 0x00a4, %r22
	.word 0x86042d23  ! 1: ADD_I	add 	%r16, 0x0d23, %r3
	.word 0x982c2d51  ! 1: ANDN_I	andn 	%r16, 0x0d51, %r12
	.word 0xba3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r29
        mov 0xb3, %r31
thr3_loop_cnt_80:
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	.word 0xc60420e0  ! 1: LDUW_I	lduw	[%r16 + 0x00e0], %r3
	.word 0xe84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r20
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6dc21f8  ! 1: LDXA_I	ldxa	[%r16, + 0x01f8] %asi, %r3
	.word 0xec0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r22
	.word 0xf4942056  ! 1: LDUHA_I	lduha	[%r16, + 0x0056] %asi, %r26
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc65c28b8  ! 1: LDX_I	ldx	[%r16 + 0x08b8], %r3
	brnz %r31,thr3_loop_cnt_80
	dec %r31
	.word 0xa42c2346  ! 1: ANDN_I	andn 	%r16, 0x0346, %r18
	.word 0xa22c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r17
	.word 0xbb2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r29
        mov 0xc6, %r31
thr3_loop_cnt_81:
	.word 0xfa8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r29
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc60c265c  ! 1: LDUB_I	ldub	[%r16 + 0x065c], %r3
	.word 0xf8442bd4  ! 1: LDSW_I	ldsw	[%r16 + 0x0bd4], %r28
	.word 0xd8d42df4  ! 1: LDSHA_I	ldsha	[%r16, + 0x0df4] %asi, %r12
	.word 0xe2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r17
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_81
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0x70, %r31
thr3_loop_cnt_82:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd24c23f3  ! 1: LDSB_I	ldsb	[%r16 + 0x03f3], %r9
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r8
	.word 0xc64c2ee4  ! 1: LDSB_I	ldsb	[%r16 + 0x0ee4], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6942e60  ! 1: LDUHA_I	lduha	[%r16, + 0x0e60] %asi, %r3
	brnz %r31,thr3_loop_cnt_82
	dec %r31
	.word 0x86242d40  ! 1: SUB_I	sub 	%r16, 0x0d40, %r3
	.word 0xaa140002  ! 1: OR_R	or 	%r16, %r2, %r21
        mov 0x28, %r31
thr3_loop_cnt_83:
	.word 0xc60c2dbf  ! 1: LDUB_I	ldub	[%r16 + 0x0dbf], %r3
	.word 0xf6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r27
	.word 0xc69429b4  ! 1: LDUHA_I	lduha	[%r16, + 0x09b4] %asi, %r3
	.word 0xec94253e  ! 1: LDUHA_I	lduha	[%r16, + 0x053e] %asi, %r22
	.word 0xf4cc22f5  ! 1: LDSBA_I	ldsba	[%r16, + 0x02f5] %asi, %r26
	.word 0xee4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r23
	.word 0xecdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r22
	.word 0xd65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r11
	.word 0xc6842288  ! 1: LDUWA_I	lduwa	[%r16, + 0x0288] %asi, %r3
	.word 0xdc0425c4  ! 1: LDUW_I	lduw	[%r16 + 0x05c4], %r14
	.word 0xe4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r18
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_83
	dec %r31
	.word 0x9d3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r14
	.word 0xb22c2e3a  ! 1: ANDN_I	andn 	%r16, 0x0e3a, %r25
	.word 0xa6440002  ! 1: ADDC_R	addc 	%r16, %r2, %r19
        mov 0x4d, %r31
thr3_loop_cnt_84:
	.word 0xd494212a  ! 1: LDUHA_I	lduha	[%r16, + 0x012a] %asi, %r10
	.word 0xd0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r8
	.word 0xc6142c30  ! 1: LDUH_I	lduh	[%r16 + 0x0c30], %r3
	.word 0xccdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r6
	.word 0xc64421d4  ! 1: LDSW_I	ldsw	[%r16 + 0x01d4], %r3
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xe2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r17
	.word 0xd25c2550  ! 1: LDX_I	ldx	[%r16 + 0x0550], %r9
	.word 0xc69421f8  ! 1: LDUHA_I	lduha	[%r16, + 0x01f8] %asi, %r3
	brnz %r31,thr3_loop_cnt_84
	dec %r31
	.word 0x863429ce  ! 1: ORN_I	orn 	%r16, 0x09ce, %r3
        mov 0x13, %r31
thr3_loop_cnt_85:
	.word 0xc61424fc  ! 1: LDUH_I	lduh	[%r16 + 0x04fc], %r3
	.word 0xfccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r30
	.word 0xf60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r27
	.word 0xf0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r24
	.word 0xe68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r19
	.word 0xd2942f96  ! 1: LDUHA_I	lduha	[%r16, + 0x0f96] %asi, %r9
	.word 0xc6142e12  ! 1: LDUH_I	lduh	[%r16 + 0x0e12], %r3
	.word 0xd45c2b90  ! 1: LDX_I	ldx	[%r16 + 0x0b90], %r10
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xec0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r22
	.word 0xe8842b78  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b78] %asi, %r20
	.word 0xc68c2624  ! 1: LDUBA_I	lduba	[%r16, + 0x0624] %asi, %r3
	brnz %r31,thr3_loop_cnt_85
	dec %r31
	.word 0xb63423f5  ! 1: SUBC_I	orn 	%r16, 0x03f5, %r27
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x30, %r31
thr3_loop_cnt_86:
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xf24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r25
	.word 0xc68c284f  ! 1: LDUBA_I	lduba	[%r16, + 0x084f] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd8942a18  ! 1: LDUHA_I	lduha	[%r16, + 0x0a18] %asi, %r12
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xce142170  ! 1: LDUH_I	lduh	[%r16 + 0x0170], %r7
	.word 0xc6c42fe4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0fe4] %asi, %r3
	brnz %r31,thr3_loop_cnt_86
	dec %r31
        mov 0x7, %r31
thr3_loop_cnt_87:
	.word 0xce142d8a  ! 1: LDUH_I	lduh	[%r16 + 0x0d8a], %r7
	.word 0xd8dc24b0  ! 1: LDXA_I	ldxa	[%r16, + 0x04b0] %asi, %r12
	.word 0xf6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r27
	.word 0xc68429a0  ! 1: LDUWA_I	lduwa	[%r16, + 0x09a0] %asi, %r3
	.word 0xec440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r22
	.word 0xc68c2486  ! 1: LDUBA_I	lduba	[%r16, + 0x0486] %asi, %r3
	.word 0xf0d4233c  ! 1: LDSHA_I	ldsha	[%r16, + 0x033c] %asi, %r24
	.word 0xe4842f18  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f18] %asi, %r18
	.word 0xc65c2a18  ! 1: LDX_I	ldx	[%r16 + 0x0a18], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r24
	brnz %r31,thr3_loop_cnt_87
	dec %r31
	.word 0xa93c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r20
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x95340002  ! 1: SRL_R	srl 	%r16, %r2, %r10
        mov 0x5c, %r31
thr3_loop_cnt_88:
	.word 0xf2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r25
	.word 0xfcdc2590  ! 1: LDXA_I	ldxa	[%r16, + 0x0590] %asi, %r30
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xc6942278  ! 1: LDUHA_I	lduha	[%r16, + 0x0278] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf65425de  ! 1: LDSH_I	ldsh	[%r16 + 0x05de], %r27
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r18
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_88
	dec %r31
        mov 0x7b, %r31
thr3_loop_cnt_89:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xdedc2078  ! 1: LDXA_I	ldxa	[%r16, + 0x0078] %asi, %r15
	.word 0xdc842d54  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d54] %asi, %r14
	.word 0xf4dc2a68  ! 1: LDXA_I	ldxa	[%r16, + 0x0a68] %asi, %r26
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd0cc2da6  ! 1: LDSBA_I	ldsba	[%r16, + 0x0da6] %asi, %r8
	.word 0xd0942978  ! 1: LDUHA_I	lduha	[%r16, + 0x0978] %asi, %r8
	.word 0xcc942bf8  ! 1: LDUHA_I	lduha	[%r16, + 0x0bf8] %asi, %r6
	brnz %r31,thr3_loop_cnt_89
	dec %r31
	.word 0x993c1002  ! 1: SRAX_R	srax	%r16, %r2, %r12
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x860c26ff  ! 1: AND_I	and 	%r16, 0x06ff, %r3
        mov 0x68, %r31
thr3_loop_cnt_90:
	.word 0xce4422d8  ! 1: LDSW_I	ldsw	[%r16 + 0x02d8], %r7
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6d42bbe  ! 1: LDSHA_I	ldsha	[%r16, + 0x0bbe] %asi, %r3
	.word 0xec0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r22
	.word 0xe8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r20
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r10
	brnz %r31,thr3_loop_cnt_90
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x93343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r9
	.word 0x97343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r11
	.word 0x953c0002  ! 1: SRA_R	sra 	%r16, %r2, %r10
        mov 0xbf, %r31
thr3_loop_cnt_91:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf4c423c0  ! 1: LDSWA_I	ldswa	[%r16, + 0x03c0] %asi, %r26
	.word 0xd8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r12
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r27
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r18
	.word 0xe4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r18
	.word 0xde0c291a  ! 1: LDUB_I	ldub	[%r16 + 0x091a], %r15
	brnz %r31,thr3_loop_cnt_91
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x86142831  ! 1: OR_I	or 	%r16, 0x0831, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0xbc, %r31
thr3_loop_cnt_92:
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf014225c  ! 1: LDUH_I	lduh	[%r16 + 0x025c], %r24
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r19
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	.word 0xc6cc2a83  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a83] %asi, %r3
	brnz %r31,thr3_loop_cnt_92
	dec %r31
        mov 0xad, %r31
thr3_loop_cnt_93:
	.word 0xf2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r25
	.word 0xfc442e08  ! 1: LDSW_I	ldsw	[%r16 + 0x0e08], %r30
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r24
	.word 0xdecc2058  ! 1: LDSBA_I	ldsba	[%r16, + 0x0058] %asi, %r15
	.word 0xf4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r26
	.word 0xee5c2260  ! 1: LDX_I	ldx	[%r16 + 0x0260], %r23
	.word 0xc6142d4a  ! 1: LDUH_I	lduh	[%r16 + 0x0d4a], %r3
	brnz %r31,thr3_loop_cnt_93
	dec %r31
	.word 0x861c264a  ! 1: XOR_I	xor 	%r16, 0x064a, %r3
        mov 0x9d, %r31
thr3_loop_cnt_94:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6442cf0  ! 1: LDSW_I	ldsw	[%r16 + 0x0cf0], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc68c2a6c  ! 1: LDUBA_I	lduba	[%r16, + 0x0a6c] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xfc5c26f8  ! 1: LDX_I	ldx	[%r16 + 0x06f8], %r30
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xeed42358  ! 1: LDSHA_I	ldsha	[%r16, + 0x0358] %asi, %r23
	brnz %r31,thr3_loop_cnt_94
	dec %r31
	.word 0x960c2d6a  ! 1: AND_I	and 	%r16, 0x0d6a, %r11
	.word 0x86442725  ! 1: ADDC_I	addc 	%r16, 0x0725, %r3
	.word 0x863c213d  ! 1: XNOR_I	xnor 	%r16, 0x013d, %r3
        mov 0x1a, %r31
thr3_loop_cnt_95:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xce8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r7
	.word 0xe8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r20
	.word 0xc61425c0  ! 1: LDUH_I	lduh	[%r16 + 0x05c0], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xda8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r13
	.word 0xcc542cf6  ! 1: LDSH_I	ldsh	[%r16 + 0x0cf6], %r6
	.word 0xe6dc27a0  ! 1: LDXA_I	ldxa	[%r16, + 0x07a0] %asi, %r19
	.word 0xf2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r25
	.word 0xd8d4257c  ! 1: LDSHA_I	ldsha	[%r16, + 0x057c] %asi, %r12
	.word 0xc6d42422  ! 1: LDSHA_I	ldsha	[%r16, + 0x0422] %asi, %r3
	brnz %r31,thr3_loop_cnt_95
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x952c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r10
        mov 0xbb, %r31
thr3_loop_cnt_96:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd65c2590  ! 1: LDX_I	ldx	[%r16 + 0x0590], %r11
	.word 0xccc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r6
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc644214c  ! 1: LDSW_I	ldsw	[%r16 + 0x014c], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r25
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xec5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r22
	brnz %r31,thr3_loop_cnt_96
	dec %r31
	.word 0x962c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r11
        mov 0xc7, %r31
thr3_loop_cnt_97:
	.word 0xd8cc2e31  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e31] %asi, %r12
	.word 0xc654202e  ! 1: LDSH_I	ldsh	[%r16 + 0x002e], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	.word 0xe6142b04  ! 1: LDUH_I	lduh	[%r16 + 0x0b04], %r19
	.word 0xd40424d0  ! 1: LDUW_I	lduw	[%r16 + 0x04d0], %r10
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xfa442b60  ! 1: LDSW_I	ldsw	[%r16 + 0x0b60], %r29
	.word 0xcc5423ea  ! 1: LDSH_I	ldsh	[%r16 + 0x03ea], %r6
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_97
	dec %r31
	.word 0x963c2d39  ! 1: XNOR_I	xnor 	%r16, 0x0d39, %r11
        mov 0x1, %r31
thr3_loop_cnt_98:
	.word 0xe20c2fc8  ! 1: LDUB_I	ldub	[%r16 + 0x0fc8], %r17
	.word 0xde440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r15
	.word 0xd8c4211c  ! 1: LDSWA_I	ldswa	[%r16, + 0x011c] %asi, %r12
	.word 0xc60c25d7  ! 1: LDUB_I	ldub	[%r16 + 0x05d7], %r3
	.word 0xced42118  ! 1: LDSHA_I	ldsha	[%r16, + 0x0118] %asi, %r7
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2254  ! 1: LDSBA_I	ldsba	[%r16, + 0x0254] %asi, %r3
	.word 0xc6cc2cb4  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cb4] %asi, %r3
	brnz %r31,thr3_loop_cnt_98
	dec %r31
	.word 0x863c204c  ! 1: XNOR_I	xnor 	%r16, 0x004c, %r3
	.word 0x861c2f2a  ! 1: XOR_I	xor 	%r16, 0x0f2a, %r3
	.word 0xb4240002  ! 1: SUB_R	sub 	%r16, %r2, %r26
	.word 0xb3342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r25
        mov 0x8b, %r31
thr3_loop_cnt_99:
	.word 0xd64c277e  ! 1: LDSB_I	ldsb	[%r16 + 0x077e], %r11
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd44c2638  ! 1: LDSB_I	ldsb	[%r16 + 0x0638], %r10
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6d427e6  ! 1: LDSHA_I	ldsha	[%r16, + 0x07e6] %asi, %r3
	.word 0xd484232c  ! 1: LDUWA_I	lduwa	[%r16, + 0x032c] %asi, %r10
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xde140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r15
	brnz %r31,thr3_loop_cnt_99
	dec %r31
	.word 0x8e042890  ! 1: ADD_I	add 	%r16, 0x0890, %r7
	.word 0x93340002  ! 1: SRL_R	srl 	%r16, %r2, %r9
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0xb42c26d1  ! 1: ANDN_I	andn 	%r16, 0x06d1, %r26
        mov 0x7e, %r31
thr3_loop_cnt_100:
	.word 0xf68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r27
	.word 0xd85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r12
	.word 0xd08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r8
	.word 0xe4442d90  ! 1: LDSW_I	ldsw	[%r16 + 0x0d90], %r18
	.word 0xd2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r9
	.word 0xc60429bc  ! 1: LDUW_I	lduw	[%r16 + 0x09bc], %r3
	.word 0xf8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r28
	.word 0xdcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r14
	brnz %r31,thr3_loop_cnt_100
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x8d3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r6
        mov 0xa6, %r31
thr3_loop_cnt_101:
	.word 0xe45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r18
	.word 0xd644238c  ! 1: LDSW_I	ldsw	[%r16 + 0x038c], %r11
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xec442d9c  ! 1: LDSW_I	ldsw	[%r16 + 0x0d9c], %r22
	.word 0xc68c2d6c  ! 1: LDUBA_I	lduba	[%r16, + 0x0d6c] %asi, %r3
	.word 0xdadc2d50  ! 1: LDXA_I	ldxa	[%r16, + 0x0d50] %asi, %r13
	.word 0xc6c42eec  ! 1: LDSWA_I	ldswa	[%r16, + 0x0eec] %asi, %r3
	.word 0xc6442c24  ! 1: LDSW_I	ldsw	[%r16 + 0x0c24], %r3
	.word 0xc64c2142  ! 1: LDSB_I	ldsb	[%r16 + 0x0142], %r3
	.word 0xd4dc2610  ! 1: LDXA_I	ldxa	[%r16, + 0x0610] %asi, %r10
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xfa842e28  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e28] %asi, %r29
	brnz %r31,thr3_loop_cnt_101
	dec %r31
        mov 0x8d, %r31
thr3_loop_cnt_102:
	.word 0xf44c2e6e  ! 1: LDSB_I	ldsb	[%r16 + 0x0e6e], %r26
	.word 0xe84428e8  ! 1: LDSW_I	ldsw	[%r16 + 0x08e8], %r20
	.word 0xd0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r8
	.word 0xee040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r23
	.word 0xde042e60  ! 1: LDUW_I	lduw	[%r16 + 0x0e60], %r15
	.word 0xfadc2310  ! 1: LDXA_I	ldxa	[%r16, + 0x0310] %asi, %r29
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd0442270  ! 1: LDSW_I	ldsw	[%r16 + 0x0270], %r8
	brnz %r31,thr3_loop_cnt_102
	dec %r31
	.word 0xb40c2ff2  ! 1: AND_I	and 	%r16, 0x0ff2, %r26
	.word 0x86142ca8  ! 1: OR_I	or 	%r16, 0x0ca8, %r3
	.word 0xa63c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r19
        mov 0xbc, %r31
thr3_loop_cnt_103:
	.word 0xe40c2e5e  ! 1: LDUB_I	ldub	[%r16 + 0x0e5e], %r18
	.word 0xf0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r24
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc60424d0  ! 1: LDUW_I	lduw	[%r16 + 0x04d0], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6d423e0  ! 1: LDSHA_I	ldsha	[%r16, + 0x03e0] %asi, %r3
	.word 0xf0442a04  ! 1: LDSW_I	ldsw	[%r16 + 0x0a04], %r24
	brnz %r31,thr3_loop_cnt_103
	dec %r31
	.word 0x864425dc  ! 1: ADDC_I	addc 	%r16, 0x05dc, %r3
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0xba140002  ! 1: OR_R	or 	%r16, %r2, %r29
        mov 0x6a, %r31
thr3_loop_cnt_104:
	.word 0xf45423ce  ! 1: LDSH_I	ldsh	[%r16 + 0x03ce], %r26
	.word 0xc6cc22b9  ! 1: LDSBA_I	ldsba	[%r16, + 0x02b9] %asi, %r3
	.word 0xc60c2df7  ! 1: LDUB_I	ldub	[%r16 + 0x0df7], %r3
	.word 0xd0d4215c  ! 1: LDSHA_I	ldsha	[%r16, + 0x015c] %asi, %r8
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xccdc27d8  ! 1: LDXA_I	ldxa	[%r16, + 0x07d8] %asi, %r6
	.word 0xecdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r22
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6dc2760  ! 1: LDXA_I	ldxa	[%r16, + 0x0760] %asi, %r3
	brnz %r31,thr3_loop_cnt_104
	dec %r31
	.word 0x861c298c  ! 1: XOR_I	xor 	%r16, 0x098c, %r3
	.word 0x8604215b  ! 1: ADD_I	add 	%r16, 0x015b, %r3
        mov 0x93, %r31
thr3_loop_cnt_105:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r12
	.word 0xc6dc2110  ! 1: LDXA_I	ldxa	[%r16, + 0x0110] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r12
	.word 0xc6142f6c  ! 1: LDUH_I	lduh	[%r16 + 0x0f6c], %r3
	.word 0xc68c2b86  ! 1: LDUBA_I	lduba	[%r16, + 0x0b86] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf0942e40  ! 1: LDUHA_I	lduha	[%r16, + 0x0e40] %asi, %r24
	.word 0xc684204c  ! 1: LDUWA_I	lduwa	[%r16, + 0x004c] %asi, %r3
	.word 0xd0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r8
	.word 0xc6dc2220  ! 1: LDXA_I	ldxa	[%r16, + 0x0220] %asi, %r3
	brnz %r31,thr3_loop_cnt_105
	dec %r31
	.word 0x86242d22  ! 1: SUB_I	sub 	%r16, 0x0d22, %r3
        mov 0x5a, %r31
thr3_loop_cnt_106:
	.word 0xec5427a8  ! 1: LDSH_I	ldsh	[%r16 + 0x07a8], %r22
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xec142768  ! 1: LDUH_I	lduh	[%r16 + 0x0768], %r22
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd4cc2187  ! 1: LDSBA_I	ldsba	[%r16, + 0x0187] %asi, %r10
	.word 0xd65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r11
	.word 0xda8c20f5  ! 1: LDUBA_I	lduba	[%r16, + 0x00f5] %asi, %r13
	brnz %r31,thr3_loop_cnt_106
	dec %r31
	.word 0xaa1c0002  ! 1: XOR_R	xor 	%r16, %r2, %r21
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x10, %r31
thr3_loop_cnt_107:
	.word 0xea142bc0  ! 1: LDUH_I	lduh	[%r16 + 0x0bc0], %r21
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xcc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r6
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xf6c42048  ! 1: LDSWA_I	ldswa	[%r16, + 0x0048] %asi, %r27
	.word 0xc64421d0  ! 1: LDSW_I	ldsw	[%r16 + 0x01d0], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc614204a  ! 1: LDUH_I	lduh	[%r16 + 0x004a], %r3
	.word 0xc6c42c10  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c10] %asi, %r3
	.word 0xc6cc26eb  ! 1: LDSBA_I	ldsba	[%r16, + 0x06eb] %asi, %r3
	.word 0xd6842798  ! 1: LDUWA_I	lduwa	[%r16, + 0x0798] %asi, %r11
	brnz %r31,thr3_loop_cnt_107
	dec %r31
	.word 0x863c2376  ! 1: XNOR_I	xnor 	%r16, 0x0376, %r3
	.word 0xb92c0002  ! 1: SLL_R	sll 	%r16, %r2, %r28
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x860c28d6  ! 1: AND_I	and 	%r16, 0x08d6, %r3
        mov 0x31, %r31
thr3_loop_cnt_108:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xcc9428d2  ! 1: LDUHA_I	lduha	[%r16, + 0x08d2] %asi, %r6
	.word 0xe4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r18
	.word 0xc64c23b6  ! 1: LDSB_I	ldsb	[%r16 + 0x03b6], %r3
	.word 0xc65c2508  ! 1: LDX_I	ldx	[%r16 + 0x0508], %r3
	.word 0xc6042308  ! 1: LDUW_I	lduw	[%r16 + 0x0308], %r3
	.word 0xcc942c80  ! 1: LDUHA_I	lduha	[%r16, + 0x0c80] %asi, %r6
	.word 0xf6142fca  ! 1: LDUH_I	lduh	[%r16 + 0x0fca], %r27
	.word 0xc65423d6  ! 1: LDSH_I	ldsh	[%r16 + 0x03d6], %r3
	.word 0xdc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r14
	.word 0xc6942df2  ! 1: LDUHA_I	lduha	[%r16, + 0x0df2] %asi, %r3
	brnz %r31,thr3_loop_cnt_108
	dec %r31
	.word 0xaa1c2c0d  ! 1: XOR_I	xor 	%r16, 0x0c0d, %r21
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x96042d56  ! 1: ADD_I	add 	%r16, 0x0d56, %r11
	.word 0x973c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r11
        mov 0xab, %r31
thr3_loop_cnt_109:
	.word 0xe2c428a4  ! 1: LDSWA_I	ldswa	[%r16, + 0x08a4] %asi, %r17
	.word 0xc644213c  ! 1: LDSW_I	ldsw	[%r16 + 0x013c], %r3
	.word 0xc68420e8  ! 1: LDUWA_I	lduwa	[%r16, + 0x00e8] %asi, %r3
	.word 0xc6842e08  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e08] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6dc2410  ! 1: LDXA_I	ldxa	[%r16, + 0x0410] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xda8c2715  ! 1: LDUBA_I	lduba	[%r16, + 0x0715] %asi, %r13
	brnz %r31,thr3_loop_cnt_109
	dec %r31
	.word 0x98240002  ! 1: SUB_R	sub 	%r16, %r2, %r12
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x47, %r31
thr3_loop_cnt_110:
	.word 0xee4c2f97  ! 1: LDSB_I	ldsb	[%r16 + 0x0f97], %r23
	.word 0xc6042a5c  ! 1: LDUW_I	lduw	[%r16 + 0x0a5c], %r3
	.word 0xdcd4211e  ! 1: LDSHA_I	ldsha	[%r16, + 0x011e] %asi, %r14
	.word 0xfc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r30
	.word 0xd2942bb8  ! 1: LDUHA_I	lduha	[%r16, + 0x0bb8] %asi, %r9
	.word 0xf84c2504  ! 1: LDSB_I	ldsb	[%r16 + 0x0504], %r28
	.word 0xd2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r9
	.word 0xf4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r26
	.word 0xf0cc204b  ! 1: LDSBA_I	ldsba	[%r16, + 0x004b] %asi, %r24
	.word 0xcc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r6
	.word 0xf60428b4  ! 1: LDUW_I	lduw	[%r16 + 0x08b4], %r27
	.word 0xee941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r23
	brnz %r31,thr3_loop_cnt_110
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0xa5, %r31
thr3_loop_cnt_111:
	.word 0xea1429a4  ! 1: LDUH_I	lduh	[%r16 + 0x09a4], %r21
	.word 0xc6c42e58  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e58] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd4042cdc  ! 1: LDUW_I	lduw	[%r16 + 0x0cdc], %r10
	.word 0xc61420f6  ! 1: LDUH_I	lduh	[%r16 + 0x00f6], %r3
	.word 0xce440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r7
	.word 0xeed42a26  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a26] %asi, %r23
	.word 0xf6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r27
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc64c2c56  ! 1: LDSB_I	ldsb	[%r16 + 0x0c56], %r3
	.word 0xd88c280d  ! 1: LDUBA_I	lduba	[%r16, + 0x080d] %asi, %r12
	brnz %r31,thr3_loop_cnt_111
	dec %r31
        mov 0x71, %r31
thr3_loop_cnt_112:
	.word 0xda4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r13
	.word 0xec5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r22
	.word 0xf4cc2331  ! 1: LDSBA_I	ldsba	[%r16, + 0x0331] %asi, %r26
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6442500  ! 1: LDSW_I	ldsw	[%r16 + 0x0500], %r3
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xf0c4249c  ! 1: LDSWA_I	ldswa	[%r16, + 0x049c] %asi, %r24
	.word 0xf08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r24
	.word 0xc6542e46  ! 1: LDSH_I	ldsh	[%r16 + 0x0e46], %r3
	.word 0xc64c26f9  ! 1: LDSB_I	ldsb	[%r16 + 0x06f9], %r3
	brnz %r31,thr3_loop_cnt_112
	dec %r31
	.word 0x862424db  ! 1: SUB_I	sub 	%r16, 0x04db, %r3
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x860c273b  ! 1: AND_I	and 	%r16, 0x073b, %r3
	.word 0xa92c0002  ! 1: SLL_R	sll 	%r16, %r2, %r20
        mov 0x56, %r31
thr3_loop_cnt_113:
	.word 0xd2542354  ! 1: LDSH_I	ldsh	[%r16 + 0x0354], %r9
	.word 0xe4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r18
	.word 0xe8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r20
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xc64c2909  ! 1: LDSB_I	ldsb	[%r16 + 0x0909], %r3
	.word 0xc64426a4  ! 1: LDSW_I	ldsw	[%r16 + 0x06a4], %r3
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xc6c42ea4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ea4] %asi, %r3
	brnz %r31,thr3_loop_cnt_113
	dec %r31
	.word 0x99343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r12
        mov 0x7b, %r31
thr3_loop_cnt_114:
	.word 0xc6442a3c  ! 1: LDSW_I	ldsw	[%r16 + 0x0a3c], %r3
	.word 0xe6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r19
	.word 0xe6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r19
	.word 0xdccc2a03  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a03] %asi, %r14
	.word 0xc6d42474  ! 1: LDSHA_I	ldsha	[%r16, + 0x0474] %asi, %r3
	.word 0xeadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r21
	.word 0xf85c20c0  ! 1: LDX_I	ldx	[%r16 + 0x00c0], %r28
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6d423d6  ! 1: LDSHA_I	ldsha	[%r16, + 0x03d6] %asi, %r3
	brnz %r31,thr3_loop_cnt_114
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x8604216c  ! 1: ADD_I	add 	%r16, 0x016c, %r3
	.word 0x86342bda  ! 1: SUBC_I	orn 	%r16, 0x0bda, %r3
        mov 0x88, %r31
thr3_loop_cnt_115:
	.word 0xee8424b4  ! 1: LDUWA_I	lduwa	[%r16, + 0x04b4] %asi, %r23
	.word 0xc6542b4a  ! 1: LDSH_I	ldsh	[%r16 + 0x0b4a], %r3
	.word 0xc65c2618  ! 1: LDX_I	ldx	[%r16 + 0x0618], %r3
	.word 0xc6842a48  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a48] %asi, %r3
	.word 0xc60c2c2a  ! 1: LDUB_I	ldub	[%r16 + 0x0c2a], %r3
	.word 0xdc442cac  ! 1: LDSW_I	ldsw	[%r16 + 0x0cac], %r14
	.word 0xc6dc2d00  ! 1: LDXA_I	ldxa	[%r16, + 0x0d00] %asi, %r3
	.word 0xe6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r19
	.word 0xfa540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r29
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_115
	dec %r31
	.word 0xad343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r22
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0xa7341002  ! 1: SRLX_R	srlx	%r16, %r2, %r19
        mov 0x95, %r31
thr3_loop_cnt_116:
	.word 0xc65c2180  ! 1: LDX_I	ldx	[%r16 + 0x0180], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf68c2c56  ! 1: LDUBA_I	lduba	[%r16, + 0x0c56] %asi, %r27
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xc6942160  ! 1: LDUHA_I	lduha	[%r16, + 0x0160] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r28
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6142262  ! 1: LDUH_I	lduh	[%r16 + 0x0262], %r3
	.word 0xd6142c04  ! 1: LDUH_I	lduh	[%r16 + 0x0c04], %r11
	.word 0xc65c2ba0  ! 1: LDX_I	ldx	[%r16 + 0x0ba0], %r3
	brnz %r31,thr3_loop_cnt_116
	dec %r31
	.word 0x9e3425fe  ! 1: ORN_I	orn 	%r16, 0x05fe, %r15
        mov 0x30, %r31
thr3_loop_cnt_117:
	.word 0xde842dc0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0dc0] %asi, %r15
	.word 0xea0428e4  ! 1: LDUW_I	lduw	[%r16 + 0x08e4], %r21
	.word 0xd0542976  ! 1: LDSH_I	ldsh	[%r16 + 0x0976], %r8
	.word 0xe6842ec8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ec8] %asi, %r19
	.word 0xda8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r13
	.word 0xc6dc2040  ! 1: LDXA_I	ldxa	[%r16, + 0x0040] %asi, %r3
	.word 0xe8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r20
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r24
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_117
	dec %r31
	.word 0xb12c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r24
        mov 0x60, %r31
thr3_loop_cnt_118:
	.word 0xda440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r13
	.word 0xecc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r22
	.word 0xec941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r22
	.word 0xc6042a44  ! 1: LDUW_I	lduw	[%r16 + 0x0a44], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xfa442648  ! 1: LDSW_I	ldsw	[%r16 + 0x0648], %r29
	.word 0xc6cc292c  ! 1: LDSBA_I	ldsba	[%r16, + 0x092c] %asi, %r3
	brnz %r31,thr3_loop_cnt_118
	dec %r31
        mov 0xe, %r31
thr3_loop_cnt_119:
	.word 0xf64c2e37  ! 1: LDSB_I	ldsb	[%r16 + 0x0e37], %r27
	.word 0xc64c2459  ! 1: LDSB_I	ldsb	[%r16 + 0x0459], %r3
	.word 0xc6042a20  ! 1: LDUW_I	lduw	[%r16 + 0x0a20], %r3
	.word 0xfadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r29
	.word 0xcecc2524  ! 1: LDSBA_I	ldsba	[%r16, + 0x0524] %asi, %r7
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r27
	.word 0xc6842afc  ! 1: LDUWA_I	lduwa	[%r16, + 0x0afc] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6042414  ! 1: LDUW_I	lduw	[%r16 + 0x0414], %r3
	.word 0xe80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r20
	brnz %r31,thr3_loop_cnt_119
	dec %r31
	.word 0xb83c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r28
	.word 0xb12c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r24
	.word 0x86042eaf  ! 1: ADD_I	add 	%r16, 0x0eaf, %r3
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x68, %r31
thr3_loop_cnt_120:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd6c42a0c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a0c] %asi, %r11
	.word 0xda0c2044  ! 1: LDUB_I	ldub	[%r16 + 0x0044], %r13
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r19
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6c42234  ! 1: LDSWA_I	ldswa	[%r16, + 0x0234] %asi, %r3
	.word 0xf6042580  ! 1: LDUW_I	lduw	[%r16 + 0x0580], %r27
	brnz %r31,thr3_loop_cnt_120
	dec %r31
	.word 0x8c04235f  ! 1: ADD_I	add 	%r16, 0x035f, %r6
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0x61, %r31
thr3_loop_cnt_121:
	.word 0xc6042f1c  ! 1: LDUW_I	lduw	[%r16 + 0x0f1c], %r3
	.word 0xf414281e  ! 1: LDUH_I	lduh	[%r16 + 0x081e], %r26
	.word 0xcc442478  ! 1: LDSW_I	ldsw	[%r16 + 0x0478], %r6
	.word 0xc60c210f  ! 1: LDUB_I	ldub	[%r16 + 0x010f], %r3
	.word 0xde5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r15
	.word 0xe45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r18
	.word 0xe20429bc  ! 1: LDUW_I	lduw	[%r16 + 0x09bc], %r17
	.word 0xe8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r20
	.word 0xc6942530  ! 1: LDUHA_I	lduha	[%r16, + 0x0530] %asi, %r3
	.word 0xe2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r17
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd61427ca  ! 1: LDUH_I	lduh	[%r16 + 0x07ca], %r11
	brnz %r31,thr3_loop_cnt_121
	dec %r31
	.word 0x8e3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r7
        mov 0x2f, %r31
thr3_loop_cnt_122:
	.word 0xc64429a8  ! 1: LDSW_I	ldsw	[%r16 + 0x09a8], %r3
	.word 0xe6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r19
	.word 0xcec42718  ! 1: LDSWA_I	ldswa	[%r16, + 0x0718] %asi, %r7
	.word 0xc6442770  ! 1: LDSW_I	ldsw	[%r16 + 0x0770], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf8c42e34  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e34] %asi, %r28
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xee042f94  ! 1: LDUW_I	lduw	[%r16 + 0x0f94], %r23
	brnz %r31,thr3_loop_cnt_122
	dec %r31
        mov 0x9f, %r31
thr3_loop_cnt_123:
	.word 0xd6c422ec  ! 1: LDSWA_I	ldswa	[%r16, + 0x02ec] %asi, %r11
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c42ff0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ff0] %asi, %r3
	.word 0xd2542966  ! 1: LDSH_I	ldsh	[%r16 + 0x0966], %r9
	.word 0xc60c2520  ! 1: LDUB_I	ldub	[%r16 + 0x0520], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r26
	brnz %r31,thr3_loop_cnt_123
	dec %r31
	.word 0x97342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r11
	.word 0x862c204a  ! 1: ANDN_I	andn 	%r16, 0x004a, %r3
	.word 0x9a1c21b1  ! 1: XOR_I	xor 	%r16, 0x01b1, %r13
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0xb6, %r31
thr3_loop_cnt_124:
	.word 0xc65c2038  ! 1: LDX_I	ldx	[%r16 + 0x0038], %r3
	.word 0xfa040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r29
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xd2c421fc  ! 1: LDSWA_I	ldswa	[%r16, + 0x01fc] %asi, %r9
	.word 0xd2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r9
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_124
	dec %r31
        mov 0x19, %r31
thr3_loop_cnt_125:
	.word 0xc6042394  ! 1: LDUW_I	lduw	[%r16 + 0x0394], %r3
	.word 0xec140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r22
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xdc9420ac  ! 1: LDUHA_I	lduha	[%r16, + 0x00ac] %asi, %r14
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6942800  ! 1: LDUHA_I	lduha	[%r16, + 0x0800] %asi, %r3
	.word 0xd2542216  ! 1: LDSH_I	ldsh	[%r16 + 0x0216], %r9
	.word 0xde841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r15
	.word 0xc64c2d2a  ! 1: LDSB_I	ldsb	[%r16 + 0x0d2a], %r3
	.word 0xe61420dc  ! 1: LDUH_I	lduh	[%r16 + 0x00dc], %r19
	.word 0xee142ecc  ! 1: LDUH_I	lduh	[%r16 + 0x0ecc], %r23
	brnz %r31,thr3_loop_cnt_125
	dec %r31
	.word 0x8f342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r7
        mov 0xbd, %r31
thr3_loop_cnt_126:
	.word 0xfcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r30
	.word 0xc6042ce8  ! 1: LDUW_I	lduw	[%r16 + 0x0ce8], %r3
	.word 0xc6042f74  ! 1: LDUW_I	lduw	[%r16 + 0x0f74], %r3
	.word 0xc64c222b  ! 1: LDSB_I	ldsb	[%r16 + 0x022b], %r3
	.word 0xc65c2e78  ! 1: LDX_I	ldx	[%r16 + 0x0e78], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6442258  ! 1: LDSW_I	ldsw	[%r16 + 0x0258], %r3
	.word 0xc6d42d7e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d7e] %asi, %r3
	.word 0xc6cc20bd  ! 1: LDSBA_I	ldsba	[%r16, + 0x00bd] %asi, %r3
	brnz %r31,thr3_loop_cnt_126
	dec %r31
	.word 0xb53c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r26
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0xa4440002  ! 1: ADDC_R	addc 	%r16, %r2, %r18
        mov 0xa6, %r31
thr3_loop_cnt_127:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xe6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r19
	.word 0xd0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r8
	.word 0xc6cc2713  ! 1: LDSBA_I	ldsba	[%r16, + 0x0713] %asi, %r3
	.word 0xc6542652  ! 1: LDSH_I	ldsh	[%r16 + 0x0652], %r3
	.word 0xc68c2f6d  ! 1: LDUBA_I	lduba	[%r16, + 0x0f6d] %asi, %r3
	.word 0xc60c22a8  ! 1: LDUB_I	ldub	[%r16 + 0x02a8], %r3
	.word 0xf60420b8  ! 1: LDUW_I	lduw	[%r16 + 0x00b8], %r27
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe68c224a  ! 1: LDUBA_I	lduba	[%r16, + 0x024a] %asi, %r19
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc604239c  ! 1: LDUW_I	lduw	[%r16 + 0x039c], %r3
	brnz %r31,thr3_loop_cnt_127
	dec %r31
	.word 0x86142eca  ! 1: OR_I	or 	%r16, 0x0eca, %r3
        mov 0xa9, %r31
thr3_loop_cnt_128:
	.word 0xc6d42a44  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a44] %asi, %r3
	.word 0xecdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r22
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd6842a38  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a38] %asi, %r11
	.word 0xd00c27aa  ! 1: LDUB_I	ldub	[%r16 + 0x07aa], %r8
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xc684226c  ! 1: LDUWA_I	lduwa	[%r16, + 0x026c] %asi, %r3
	.word 0xd2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r9
	brnz %r31,thr3_loop_cnt_128
	dec %r31
        mov 0x19, %r31
thr3_loop_cnt_129:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6942342  ! 1: LDUHA_I	lduha	[%r16, + 0x0342] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf29424f4  ! 1: LDUHA_I	lduha	[%r16, + 0x04f4] %asi, %r25
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	brnz %r31,thr3_loop_cnt_129
	dec %r31
        mov 0xc4, %r31
thr3_loop_cnt_130:
	.word 0xf4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r26
	.word 0xc6c420f4  ! 1: LDSWA_I	ldswa	[%r16, + 0x00f4] %asi, %r3
	.word 0xc6cc2146  ! 1: LDSBA_I	ldsba	[%r16, + 0x0146] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6dc2f20  ! 1: LDXA_I	ldxa	[%r16, + 0x0f20] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xeed41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r23
	.word 0xc6dc20a8  ! 1: LDXA_I	ldxa	[%r16, + 0x00a8] %asi, %r3
	brnz %r31,thr3_loop_cnt_130
	dec %r31
	.word 0x9e040002  ! 1: ADD_R	add 	%r16, %r2, %r15
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x62, %r31
thr3_loop_cnt_131:
	.word 0xfc142d88  ! 1: LDUH_I	lduh	[%r16 + 0x0d88], %r30
	.word 0xc60c2ec0  ! 1: LDUB_I	ldub	[%r16 + 0x0ec0], %r3
	.word 0xde042e28  ! 1: LDUW_I	lduw	[%r16 + 0x0e28], %r15
	.word 0xdcc42798  ! 1: LDSWA_I	ldswa	[%r16, + 0x0798] %asi, %r14
	.word 0xde44218c  ! 1: LDSW_I	ldsw	[%r16 + 0x018c], %r15
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe8042f38  ! 1: LDUW_I	lduw	[%r16 + 0x0f38], %r20
	.word 0xf6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r27
	brnz %r31,thr3_loop_cnt_131
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0x2d, %r31
thr3_loop_cnt_132:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r17
	.word 0xd85c20e8  ! 1: LDX_I	ldx	[%r16 + 0x00e8], %r12
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc60c28d0  ! 1: LDUB_I	ldub	[%r16 + 0x08d0], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc68429e4  ! 1: LDUWA_I	lduwa	[%r16, + 0x09e4] %asi, %r3
	.word 0xd08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r8
	brnz %r31,thr3_loop_cnt_132
	dec %r31
	.word 0xaf343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r23
	.word 0xaa140002  ! 1: OR_R	or 	%r16, %r2, %r21
        mov 0x3e, %r31
thr3_loop_cnt_133:
	.word 0xdc442414  ! 1: LDSW_I	ldsw	[%r16 + 0x0414], %r14
	.word 0xc64c2ac5  ! 1: LDSB_I	ldsb	[%r16 + 0x0ac5], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf0442994  ! 1: LDSW_I	ldsw	[%r16 + 0x0994], %r24
	.word 0xcccc2df4  ! 1: LDSBA_I	ldsba	[%r16, + 0x0df4] %asi, %r6
	.word 0xf88423a0  ! 1: LDUWA_I	lduwa	[%r16, + 0x03a0] %asi, %r28
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r24
	.word 0xec042f24  ! 1: LDUW_I	lduw	[%r16 + 0x0f24], %r22
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe6442730  ! 1: LDSW_I	ldsw	[%r16 + 0x0730], %r19
	.word 0xe8842ef8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ef8] %asi, %r20
	brnz %r31,thr3_loop_cnt_133
	dec %r31
        mov 0x6c, %r31
thr3_loop_cnt_134:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6842254  ! 1: LDUWA_I	lduwa	[%r16, + 0x0254] %asi, %r3
	.word 0xf6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r27
	.word 0xdacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r13
	.word 0xd0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r8
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd2842e64  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e64] %asi, %r9
	.word 0xc6942d68  ! 1: LDUHA_I	lduha	[%r16, + 0x0d68] %asi, %r3
	brnz %r31,thr3_loop_cnt_134
	dec %r31
	.word 0x992c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r12
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0x2b, %r31
thr3_loop_cnt_135:
	.word 0xd054275a  ! 1: LDSH_I	ldsh	[%r16 + 0x075a], %r8
	.word 0xe25c2d68  ! 1: LDX_I	ldx	[%r16 + 0x0d68], %r17
	.word 0xfc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r30
	.word 0xc64c2985  ! 1: LDSB_I	ldsb	[%r16 + 0x0985], %r3
	.word 0xc6d42cfa  ! 1: LDSHA_I	ldsha	[%r16, + 0x0cfa] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6042200  ! 1: LDUW_I	lduw	[%r16 + 0x0200], %r3
	.word 0xc6142bd4  ! 1: LDUH_I	lduh	[%r16 + 0x0bd4], %r3
	.word 0xd6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r11
	.word 0xc604279c  ! 1: LDUW_I	lduw	[%r16 + 0x079c], %r3
	brnz %r31,thr3_loop_cnt_135
	dec %r31
	.word 0x862425eb  ! 1: SUB_I	sub 	%r16, 0x05eb, %r3
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
        mov 0x5a, %r31
thr3_loop_cnt_136:
	.word 0xce042c54  ! 1: LDUW_I	lduw	[%r16 + 0x0c54], %r7
	.word 0xde5422cc  ! 1: LDSH_I	ldsh	[%r16 + 0x02cc], %r15
	.word 0xfa5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r29
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xc6c427f0  ! 1: LDSWA_I	ldswa	[%r16, + 0x07f0] %asi, %r3
	.word 0xc64c2308  ! 1: LDSB_I	ldsb	[%r16 + 0x0308], %r3
	.word 0xc60c2dd2  ! 1: LDUB_I	ldub	[%r16 + 0x0dd2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd8dc2b30  ! 1: LDXA_I	ldxa	[%r16, + 0x0b30] %asi, %r12
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_136
	dec %r31
	.word 0x861429cf  ! 1: OR_I	or 	%r16, 0x09cf, %r3
        mov 0xaa, %r31
thr3_loop_cnt_137:
	.word 0xc64422e8  ! 1: LDSW_I	ldsw	[%r16 + 0x02e8], %r3
	.word 0xc68425f8  ! 1: LDUWA_I	lduwa	[%r16, + 0x05f8] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd6442774  ! 1: LDSW_I	ldsw	[%r16 + 0x0774], %r11
	.word 0xc6dc2aa0  ! 1: LDXA_I	ldxa	[%r16, + 0x0aa0] %asi, %r3
	.word 0xeadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r21
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6c424d8  ! 1: LDSWA_I	ldswa	[%r16, + 0x04d8] %asi, %r3
	brnz %r31,thr3_loop_cnt_137
	dec %r31
	.word 0xa83c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r20
	.word 0xa614272b  ! 1: OR_I	or 	%r16, 0x072b, %r19
        mov 0x85, %r31
thr3_loop_cnt_138:
	.word 0xc6842cc4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0cc4] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xee84221c  ! 1: LDUWA_I	lduwa	[%r16, + 0x021c] %asi, %r23
	.word 0xc6142046  ! 1: LDUH_I	lduh	[%r16 + 0x0046], %r3
	.word 0xee540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r23
	.word 0xf8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r28
	.word 0xf40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r26
	.word 0xd6d426da  ! 1: LDSHA_I	ldsha	[%r16, + 0x06da] %asi, %r11
	.word 0xc6cc2e5d  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e5d] %asi, %r3
	.word 0xccd425d6  ! 1: LDSHA_I	ldsha	[%r16, + 0x05d6] %asi, %r6
	brnz %r31,thr3_loop_cnt_138
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x861c2c04  ! 1: XOR_I	xor 	%r16, 0x0c04, %r3
	.word 0xb52c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r26
	.word 0x96342128  ! 1: ORN_I	orn 	%r16, 0x0128, %r11
        mov 0x19, %r31
thr3_loop_cnt_139:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd0dc2690  ! 1: LDXA_I	ldxa	[%r16, + 0x0690] %asi, %r8
	.word 0xd25c2508  ! 1: LDX_I	ldx	[%r16 + 0x0508], %r9
	.word 0xc6d421ec  ! 1: LDSHA_I	ldsha	[%r16, + 0x01ec] %asi, %r3
	.word 0xc60c2ce5  ! 1: LDUB_I	ldub	[%r16 + 0x0ce5], %r3
	.word 0xc6c42cac  ! 1: LDSWA_I	ldswa	[%r16, + 0x0cac] %asi, %r3
	.word 0xd6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r11
	.word 0xcc9422f6  ! 1: LDUHA_I	lduha	[%r16, + 0x02f6] %asi, %r6
	.word 0xd65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r11
	.word 0xde440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r15
	.word 0xe88423d8  ! 1: LDUWA_I	lduwa	[%r16, + 0x03d8] %asi, %r20
	brnz %r31,thr3_loop_cnt_139
	dec %r31
	.word 0x86342348  ! 1: SUBC_I	orn 	%r16, 0x0348, %r3
	.word 0x862426d8  ! 1: SUB_I	sub 	%r16, 0x06d8, %r3
	.word 0x983428aa  ! 1: ORN_I	orn 	%r16, 0x08aa, %r12
	.word 0x9e4420bf  ! 1: ADDC_I	addc 	%r16, 0x00bf, %r15
        mov 0x2c, %r31
thr3_loop_cnt_140:
	.word 0xc6442fac  ! 1: LDSW_I	ldsw	[%r16 + 0x0fac], %r3
	.word 0xd0c42fb4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0fb4] %asi, %r8
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf2cc2de6  ! 1: LDSBA_I	ldsba	[%r16, + 0x0de6] %asi, %r25
	.word 0xc6d42134  ! 1: LDSHA_I	ldsha	[%r16, + 0x0134] %asi, %r3
	.word 0xf6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r27
	.word 0xda440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r13
	.word 0xd2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r9
	brnz %r31,thr3_loop_cnt_140
	dec %r31
	.word 0xb7343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r27
	.word 0xae3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r23
	.word 0xb33c1002  ! 1: SRAX_R	srax	%r16, %r2, %r25
	.word 0x86342949  ! 1: SUBC_I	orn 	%r16, 0x0949, %r3
        mov 0x2d, %r31
thr3_loop_cnt_141:
	.word 0xfcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r30
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xea5c2350  ! 1: LDX_I	ldx	[%r16 + 0x0350], %r21
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xeacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r21
	.word 0xf0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r24
	.word 0xf2142da8  ! 1: LDUH_I	lduh	[%r16 + 0x0da8], %r25
	.word 0xd45c24e0  ! 1: LDX_I	ldx	[%r16 + 0x04e0], %r10
	.word 0xf6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r27
	.word 0xde142486  ! 1: LDUH_I	lduh	[%r16 + 0x0486], %r15
	.word 0xc64c2a05  ! 1: LDSB_I	ldsb	[%r16 + 0x0a05], %r3
	brnz %r31,thr3_loop_cnt_141
	dec %r31
	.word 0x86342829  ! 1: ORN_I	orn 	%r16, 0x0829, %r3
        mov 0xbb, %r31
thr3_loop_cnt_142:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6542e6c  ! 1: LDSH_I	ldsh	[%r16 + 0x0e6c], %r3
	.word 0xc6942678  ! 1: LDUHA_I	lduha	[%r16, + 0x0678] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc61428b0  ! 1: LDUH_I	lduh	[%r16 + 0x08b0], %r3
	.word 0xf04c20ce  ! 1: LDSB_I	ldsb	[%r16 + 0x00ce], %r24
	.word 0xecdc21d0  ! 1: LDXA_I	ldxa	[%r16, + 0x01d0] %asi, %r22
	.word 0xde5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r15
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xc64c2d63  ! 1: LDSB_I	ldsb	[%r16 + 0x0d63], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_142
	dec %r31
        mov 0x23, %r31
thr3_loop_cnt_143:
	.word 0xd24c2ca0  ! 1: LDSB_I	ldsb	[%r16 + 0x0ca0], %r9
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xdacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r13
	.word 0xc6042930  ! 1: LDUW_I	lduw	[%r16 + 0x0930], %r3
	.word 0xc60c24fd  ! 1: LDUB_I	ldub	[%r16 + 0x04fd], %r3
	.word 0xfa4c2a30  ! 1: LDSB_I	ldsb	[%r16 + 0x0a30], %r29
	.word 0xda540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r13
	.word 0xc6042a90  ! 1: LDUW_I	lduw	[%r16 + 0x0a90], %r3
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xd0cc2cda  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cda] %asi, %r8
	.word 0xd6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r11
	brnz %r31,thr3_loop_cnt_143
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x1c, %r31
thr3_loop_cnt_144:
	.word 0xf4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r26
	.word 0xc6942dec  ! 1: LDUHA_I	lduha	[%r16, + 0x0dec] %asi, %r3
	.word 0xce0422a4  ! 1: LDUW_I	lduw	[%r16 + 0x02a4], %r7
	.word 0xc6542b62  ! 1: LDSH_I	ldsh	[%r16 + 0x0b62], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6942f26  ! 1: LDUHA_I	lduha	[%r16, + 0x0f26] %asi, %r3
	.word 0xdc0c2b92  ! 1: LDUB_I	ldub	[%r16 + 0x0b92], %r14
	.word 0xde140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r15
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xc6d426bc  ! 1: LDSHA_I	ldsha	[%r16, + 0x06bc] %asi, %r3
	.word 0xc6142dd4  ! 1: LDUH_I	lduh	[%r16 + 0x0dd4], %r3
	brnz %r31,thr3_loop_cnt_144
	dec %r31
        mov 0x9c, %r31
thr3_loop_cnt_145:
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xc6042b08  ! 1: LDUW_I	lduw	[%r16 + 0x0b08], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2a02  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a02] %asi, %r3
	.word 0xd4842550  ! 1: LDUWA_I	lduwa	[%r16, + 0x0550] %asi, %r10
	.word 0xf44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r26
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xec4c2864  ! 1: LDSB_I	ldsb	[%r16 + 0x0864], %r22
	brnz %r31,thr3_loop_cnt_145
	dec %r31
	.word 0xa72c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r19
        mov 0x7b, %r31
thr3_loop_cnt_146:
	.word 0xd08c2dff  ! 1: LDUBA_I	lduba	[%r16, + 0x0dff] %asi, %r8
	.word 0xc6c426fc  ! 1: LDSWA_I	ldswa	[%r16, + 0x06fc] %asi, %r3
	.word 0xcc942388  ! 1: LDUHA_I	lduha	[%r16, + 0x0388] %asi, %r6
	.word 0xd4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r10
	.word 0xd48c27fc  ! 1: LDUBA_I	lduba	[%r16, + 0x07fc] %asi, %r10
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc65c2078  ! 1: LDX_I	ldx	[%r16 + 0x0078], %r3
	.word 0xd81426d2  ! 1: LDUH_I	lduh	[%r16 + 0x06d2], %r12
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_146
	dec %r31
	.word 0x86342ad3  ! 1: ORN_I	orn 	%r16, 0x0ad3, %r3
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x8c3c29b3  ! 1: XNOR_I	xnor 	%r16, 0x09b3, %r6
        mov 0x7c, %r31
thr3_loop_cnt_147:
	.word 0xc6d4202a  ! 1: LDSHA_I	ldsha	[%r16, + 0x002a] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xde040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r15
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xdadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r13
	.word 0xc6d4263e  ! 1: LDSHA_I	ldsha	[%r16, + 0x063e] %asi, %r3
	.word 0xc65421c4  ! 1: LDSH_I	ldsh	[%r16 + 0x01c4], %r3
	.word 0xd0942772  ! 1: LDUHA_I	lduha	[%r16, + 0x0772] %asi, %r8
	brnz %r31,thr3_loop_cnt_147
	dec %r31
	.word 0x962c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r11
        mov 0x63, %r31
thr3_loop_cnt_148:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6542820  ! 1: LDSH_I	ldsh	[%r16 + 0x0820], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe2542738  ! 1: LDSH_I	ldsh	[%r16 + 0x0738], %r17
	.word 0xda8c235d  ! 1: LDUBA_I	lduba	[%r16, + 0x035d] %asi, %r13
	.word 0xc604216c  ! 1: LDUW_I	lduw	[%r16 + 0x016c], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	brnz %r31,thr3_loop_cnt_148
	dec %r31
	.word 0x9e242ba3  ! 1: SUB_I	sub 	%r16, 0x0ba3, %r15
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0xbe, %r31
thr3_loop_cnt_149:
	.word 0xf65c2768  ! 1: LDX_I	ldx	[%r16 + 0x0768], %r27
	.word 0xd88429d8  ! 1: LDUWA_I	lduwa	[%r16, + 0x09d8] %asi, %r12
	.word 0xe6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r19
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xfa8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r29
	.word 0xc68c2d05  ! 1: LDUBA_I	lduba	[%r16, + 0x0d05] %asi, %r3
	.word 0xc60c20dd  ! 1: LDUB_I	ldub	[%r16 + 0x00dd], %r3
	.word 0xc65c2008  ! 1: LDX_I	ldx	[%r16 + 0x0008], %r3
	.word 0xf40c26f5  ! 1: LDUB_I	ldub	[%r16 + 0x06f5], %r26
	brnz %r31,thr3_loop_cnt_149
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x9d, %r31
thr3_loop_cnt_150:
	.word 0xd0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r8
	.word 0xdccc24ee  ! 1: LDSBA_I	ldsba	[%r16, + 0x04ee] %asi, %r14
	.word 0xf68c2a81  ! 1: LDUBA_I	lduba	[%r16, + 0x0a81] %asi, %r27
	.word 0xc60425bc  ! 1: LDUW_I	lduw	[%r16 + 0x05bc], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf6442cd0  ! 1: LDSW_I	ldsw	[%r16 + 0x0cd0], %r27
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf4042344  ! 1: LDUW_I	lduw	[%r16 + 0x0344], %r26
	.word 0xda442638  ! 1: LDSW_I	ldsw	[%r16 + 0x0638], %r13
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_150
	dec %r31
	.word 0x8c3420e5  ! 1: SUBC_I	orn 	%r16, 0x00e5, %r6
        mov 0x57, %r31
thr3_loop_cnt_151:
	.word 0xda4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r13
	.word 0xd0cc2aac  ! 1: LDSBA_I	ldsba	[%r16, + 0x0aac] %asi, %r8
	.word 0xc64429e0  ! 1: LDSW_I	ldsw	[%r16 + 0x09e0], %r3
	.word 0xc6c423ec  ! 1: LDSWA_I	ldswa	[%r16, + 0x03ec] %asi, %r3
	.word 0xea4c2ca5  ! 1: LDSB_I	ldsb	[%r16 + 0x0ca5], %r21
	.word 0xc6442934  ! 1: LDSW_I	ldsw	[%r16 + 0x0934], %r3
	.word 0xdadc2980  ! 1: LDXA_I	ldxa	[%r16, + 0x0980] %asi, %r13
	.word 0xc6542750  ! 1: LDSH_I	ldsh	[%r16 + 0x0750], %r3
	.word 0xfc4c2ccf  ! 1: LDSB_I	ldsb	[%r16 + 0x0ccf], %r30
	brnz %r31,thr3_loop_cnt_151
	dec %r31
        mov 0x87, %r31
thr3_loop_cnt_152:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6942ba8  ! 1: LDUHA_I	lduha	[%r16, + 0x0ba8] %asi, %r3
	.word 0xc68c24e5  ! 1: LDUBA_I	lduba	[%r16, + 0x04e5] %asi, %r3
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc68c2f06  ! 1: LDUBA_I	lduba	[%r16, + 0x0f06] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6942440  ! 1: LDUHA_I	lduha	[%r16, + 0x0440] %asi, %r3
	.word 0xdcdc25b8  ! 1: LDXA_I	ldxa	[%r16, + 0x05b8] %asi, %r14
	brnz %r31,thr3_loop_cnt_152
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0xc7, %r31
thr3_loop_cnt_153:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc60426b8  ! 1: LDUW_I	lduw	[%r16 + 0x06b8], %r3
	.word 0xc68c2e6a  ! 1: LDUBA_I	lduba	[%r16, + 0x0e6a] %asi, %r3
	.word 0xc60c2756  ! 1: LDUB_I	ldub	[%r16 + 0x0756], %r3
	.word 0xfac42604  ! 1: LDSWA_I	ldswa	[%r16, + 0x0604] %asi, %r29
	.word 0xced420d8  ! 1: LDSHA_I	ldsha	[%r16, + 0x00d8] %asi, %r7
	.word 0xf2142036  ! 1: LDUH_I	lduh	[%r16 + 0x0036], %r25
	.word 0xc6c4226c  ! 1: LDSWA_I	ldswa	[%r16, + 0x026c] %asi, %r3
	.word 0xccdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r6
	.word 0xf64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r27
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_153
	dec %r31
        mov 0xb1, %r31
thr3_loop_cnt_154:
	.word 0xe6d42000  ! 1: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r19
	.word 0xc68c20ad  ! 1: LDUBA_I	lduba	[%r16, + 0x00ad] %asi, %r3
	.word 0xd8c42cd0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0cd0] %asi, %r12
	.word 0xfac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r29
	.word 0xec540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r22
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6942622  ! 1: LDUHA_I	lduha	[%r16, + 0x0622] %asi, %r3
	.word 0xf65c24b0  ! 1: LDX_I	ldx	[%r16 + 0x04b0], %r27
	.word 0xd4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r10
	.word 0xc6c42cd4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0cd4] %asi, %r3
	brnz %r31,thr3_loop_cnt_154
	dec %r31
	.word 0x99343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r12
        mov 0x20, %r31
thr3_loop_cnt_155:
	.word 0xc614258c  ! 1: LDUH_I	lduh	[%r16 + 0x058c], %r3
	.word 0xc6442808  ! 1: LDSW_I	ldsw	[%r16 + 0x0808], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xec4c2dc6  ! 1: LDSB_I	ldsb	[%r16 + 0x0dc6], %r22
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xce5c2210  ! 1: LDX_I	ldx	[%r16 + 0x0210], %r7
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	.word 0xc6cc2ac5  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ac5] %asi, %r3
	.word 0xc68c2689  ! 1: LDUBA_I	lduba	[%r16, + 0x0689] %asi, %r3
	.word 0xe6d427a6  ! 1: LDSHA_I	ldsha	[%r16, + 0x07a6] %asi, %r19
	brnz %r31,thr3_loop_cnt_155
	dec %r31
	.word 0x863c2391  ! 1: XNOR_I	xnor 	%r16, 0x0391, %r3
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x9c3c25d9  ! 1: XNOR_I	xnor 	%r16, 0x05d9, %r14
        mov 0x98, %r31
thr3_loop_cnt_156:
	.word 0xc6142d60  ! 1: LDUH_I	lduh	[%r16 + 0x0d60], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6142b1e  ! 1: LDUH_I	lduh	[%r16 + 0x0b1e], %r3
	.word 0xc65c2230  ! 1: LDX_I	ldx	[%r16 + 0x0230], %r3
	.word 0xdc4c23e7  ! 1: LDSB_I	ldsb	[%r16 + 0x03e7], %r14
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_156
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x10, %r31
thr3_loop_cnt_157:
	.word 0xce9420de  ! 1: LDUHA_I	lduha	[%r16, + 0x00de] %asi, %r7
	.word 0xc6c42d40  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d40] %asi, %r3
	.word 0xd00c2c00  ! 1: LDUB_I	ldub	[%r16 + 0x0c00], %r8
	.word 0xc6842ef8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ef8] %asi, %r3
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xc64427e0  ! 1: LDSW_I	ldsw	[%r16 + 0x07e0], %r3
	.word 0xc6542edc  ! 1: LDSH_I	ldsh	[%r16 + 0x0edc], %r3
	.word 0xc64c20b4  ! 1: LDSB_I	ldsb	[%r16 + 0x00b4], %r3
	brnz %r31,thr3_loop_cnt_157
	dec %r31
        mov 0x53, %r31
thr3_loop_cnt_158:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe68c220e  ! 1: LDUBA_I	lduba	[%r16, + 0x020e] %asi, %r19
	.word 0xc6cc2597  ! 1: LDSBA_I	ldsba	[%r16, + 0x0597] %asi, %r3
	.word 0xc6d4210c  ! 1: LDSHA_I	ldsha	[%r16, + 0x010c] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf8042c0c  ! 1: LDUW_I	lduw	[%r16 + 0x0c0c], %r28
	.word 0xd4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r10
	.word 0xe4c4294c  ! 1: LDSWA_I	ldswa	[%r16, + 0x094c] %asi, %r18
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd0dc2360  ! 1: LDXA_I	ldxa	[%r16, + 0x0360] %asi, %r8
	brnz %r31,thr3_loop_cnt_158
	dec %r31
	.word 0x862c2b6b  ! 1: ANDN_I	andn 	%r16, 0x0b6b, %r3
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x86142ed7  ! 1: OR_I	or 	%r16, 0x0ed7, %r3
	.word 0xba3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r29
        mov 0x65, %r31
thr3_loop_cnt_159:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc68429a8  ! 1: LDUWA_I	lduwa	[%r16, + 0x09a8] %asi, %r3
	.word 0xea4c2f98  ! 1: LDSB_I	ldsb	[%r16 + 0x0f98], %r21
	.word 0xc6042b9c  ! 1: LDUW_I	lduw	[%r16 + 0x0b9c], %r3
	.word 0xc64c2ad4  ! 1: LDSB_I	ldsb	[%r16 + 0x0ad4], %r3
	.word 0xc6d42c02  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c02] %asi, %r3
	.word 0xc64c24ef  ! 1: LDSB_I	ldsb	[%r16 + 0x04ef], %r3
	.word 0xce8c207e  ! 1: LDUBA_I	lduba	[%r16, + 0x007e] %asi, %r7
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_159
	dec %r31
        mov 0x23, %r31
thr3_loop_cnt_160:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6042978  ! 1: LDUW_I	lduw	[%r16 + 0x0978], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xce8c2b78  ! 1: LDUBA_I	lduba	[%r16, + 0x0b78] %asi, %r7
	.word 0xdc4c2f8f  ! 1: LDSB_I	ldsb	[%r16 + 0x0f8f], %r14
	.word 0xc60422dc  ! 1: LDUW_I	lduw	[%r16 + 0x02dc], %r3
	.word 0xc60c22c6  ! 1: LDUB_I	ldub	[%r16 + 0x02c6], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xdcc429e4  ! 1: LDSWA_I	ldswa	[%r16, + 0x09e4] %asi, %r14
	brnz %r31,thr3_loop_cnt_160
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x863421be  ! 1: SUBC_I	orn 	%r16, 0x01be, %r3
	.word 0xa20428a1  ! 1: ADD_I	add 	%r16, 0x08a1, %r17
        mov 0xab, %r31
thr3_loop_cnt_161:
	.word 0xc65c2f30  ! 1: LDX_I	ldx	[%r16 + 0x0f30], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d42a42  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a42] %asi, %r3
	.word 0xf4c42684  ! 1: LDSWA_I	ldswa	[%r16, + 0x0684] %asi, %r26
	.word 0xe6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r19
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf28c22de  ! 1: LDUBA_I	lduba	[%r16, + 0x02de] %asi, %r25
	brnz %r31,thr3_loop_cnt_161
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x82, %r31
thr3_loop_cnt_162:
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xdc4c2b07  ! 1: LDSB_I	ldsb	[%r16 + 0x0b07], %r14
	.word 0xc68c2f4f  ! 1: LDUBA_I	lduba	[%r16, + 0x0f4f] %asi, %r3
	.word 0xecc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r22
	.word 0xc6542472  ! 1: LDSH_I	ldsh	[%r16 + 0x0472], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xee540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r23
	.word 0xe40c2992  ! 1: LDUB_I	ldub	[%r16 + 0x0992], %r18
	.word 0xc68c2bdd  ! 1: LDUBA_I	lduba	[%r16, + 0x0bdd] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_162
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x23, %r31
thr3_loop_cnt_163:
	.word 0xc6542d50  ! 1: LDSH_I	ldsh	[%r16 + 0x0d50], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd00c2cc9  ! 1: LDUB_I	ldub	[%r16 + 0x0cc9], %r8
	.word 0xc6dc2db0  ! 1: LDXA_I	ldxa	[%r16, + 0x0db0] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc68c2f28  ! 1: LDUBA_I	lduba	[%r16, + 0x0f28] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf4c42e08  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e08] %asi, %r26
	.word 0xe44c2e7d  ! 1: LDSB_I	ldsb	[%r16 + 0x0e7d], %r18
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	brnz %r31,thr3_loop_cnt_163
	dec %r31
	.word 0x96340002  ! 1: ORN_R	orn 	%r16, %r2, %r11
	.word 0x8d3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r6
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0xa1, %r31
thr3_loop_cnt_164:
	.word 0xf0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r24
	.word 0xc6dc21b8  ! 1: LDXA_I	ldxa	[%r16, + 0x01b8] %asi, %r3
	.word 0xc68c2b9e  ! 1: LDUBA_I	lduba	[%r16, + 0x0b9e] %asi, %r3
	.word 0xc69423f0  ! 1: LDUHA_I	lduha	[%r16, + 0x03f0] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc64424c4  ! 1: LDSW_I	ldsw	[%r16 + 0x04c4], %r3
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	.word 0xc60c25f9  ! 1: LDUB_I	ldub	[%r16 + 0x05f9], %r3
	.word 0xfa14266c  ! 1: LDUH_I	lduh	[%r16 + 0x066c], %r29
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_164
	dec %r31
        mov 0x7d, %r31
thr3_loop_cnt_165:
	.word 0xd2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r9
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6942e1c  ! 1: LDUHA_I	lduha	[%r16, + 0x0e1c] %asi, %r3
	.word 0xe64c2461  ! 1: LDSB_I	ldsb	[%r16 + 0x0461], %r19
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xfa142cec  ! 1: LDUH_I	lduh	[%r16 + 0x0cec], %r29
	.word 0xd08426ac  ! 1: LDUWA_I	lduwa	[%r16, + 0x06ac] %asi, %r8
	.word 0xe8542f34  ! 1: LDSH_I	ldsh	[%r16 + 0x0f34], %r20
	.word 0xde542fae  ! 1: LDSH_I	ldsh	[%r16 + 0x0fae], %r15
	.word 0xc6042a1c  ! 1: LDUW_I	lduw	[%r16 + 0x0a1c], %r3
	.word 0xde4429c0  ! 1: LDSW_I	ldsw	[%r16 + 0x09c0], %r15
	.word 0xd0142242  ! 1: LDUH_I	lduh	[%r16 + 0x0242], %r8
	brnz %r31,thr3_loop_cnt_165
	dec %r31
	.word 0x963c20f5  ! 1: XNOR_I	xnor 	%r16, 0x00f5, %r11
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x56, %r31
thr3_loop_cnt_166:
	.word 0xf2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r25
	.word 0xc68c2928  ! 1: LDUBA_I	lduba	[%r16, + 0x0928] %asi, %r3
	.word 0xd2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r9
	.word 0xf24c27ab  ! 1: LDSB_I	ldsb	[%r16 + 0x07ab], %r25
	.word 0xc6942706  ! 1: LDUHA_I	lduha	[%r16, + 0x0706] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6942a66  ! 1: LDUHA_I	lduha	[%r16, + 0x0a66] %asi, %r3
	.word 0xc684203c  ! 1: LDUWA_I	lduwa	[%r16, + 0x003c] %asi, %r3
	brnz %r31,thr3_loop_cnt_166
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x36, %r31
thr3_loop_cnt_167:
	.word 0xc654273e  ! 1: LDSH_I	ldsh	[%r16 + 0x073e], %r3
	.word 0xd25c2088  ! 1: LDX_I	ldx	[%r16 + 0x0088], %r9
	.word 0xf4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r26
	.word 0xc64c28af  ! 1: LDSB_I	ldsb	[%r16 + 0x08af], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc60c21f9  ! 1: LDUB_I	ldub	[%r16 + 0x01f9], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_167
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x863c2bcc  ! 1: XNOR_I	xnor 	%r16, 0x0bcc, %r3
	.word 0xb20c0002  ! 1: AND_R	and 	%r16, %r2, %r25
        mov 0x81, %r31
thr3_loop_cnt_168:
	.word 0xc694202a  ! 1: LDUHA_I	lduha	[%r16, + 0x002a] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6542814  ! 1: LDSH_I	ldsh	[%r16 + 0x0814], %r3
	.word 0xf8dc2fa0  ! 1: LDXA_I	ldxa	[%r16, + 0x0fa0] %asi, %r28
	.word 0xf60c23b0  ! 1: LDUB_I	ldub	[%r16 + 0x03b0], %r27
	.word 0xe6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r19
	.word 0xc60c293e  ! 1: LDUB_I	ldub	[%r16 + 0x093e], %r3
	.word 0xc6d42ae8  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ae8] %asi, %r3
	.word 0xe24c299d  ! 1: LDSB_I	ldsb	[%r16 + 0x099d], %r17
	.word 0xc6c42238  ! 1: LDSWA_I	ldswa	[%r16, + 0x0238] %asi, %r3
	brnz %r31,thr3_loop_cnt_168
	dec %r31
        mov 0x4, %r31
thr3_loop_cnt_169:
	.word 0xf2d42640  ! 1: LDSHA_I	ldsha	[%r16, + 0x0640] %asi, %r25
	.word 0xc6cc21ff  ! 1: LDSBA_I	ldsba	[%r16, + 0x01ff] %asi, %r3
	.word 0xd4c42d60  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d60] %asi, %r10
	.word 0xd0842860  ! 1: LDUWA_I	lduwa	[%r16, + 0x0860] %asi, %r8
	.word 0xd2542c52  ! 1: LDSH_I	ldsh	[%r16 + 0x0c52], %r9
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe20c2afe  ! 1: LDUB_I	ldub	[%r16 + 0x0afe], %r17
	.word 0xfa540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r29
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6042274  ! 1: LDUW_I	lduw	[%r16 + 0x0274], %r3
	brnz %r31,thr3_loop_cnt_169
	dec %r31
	.word 0xa33c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r17
	.word 0xb0340002  ! 1: ORN_R	orn 	%r16, %r2, %r24
        mov 0x34, %r31
thr3_loop_cnt_170:
	.word 0xc6442008  ! 1: LDSW_I	ldsw	[%r16 + 0x0008], %r3
	.word 0xc654289e  ! 1: LDSH_I	ldsh	[%r16 + 0x089e], %r3
	.word 0xdedc2f40  ! 1: LDXA_I	ldxa	[%r16, + 0x0f40] %asi, %r15
	.word 0xe2042474  ! 1: LDUW_I	lduw	[%r16 + 0x0474], %r17
	.word 0xc60c29ab  ! 1: LDUB_I	ldub	[%r16 + 0x09ab], %r3
	.word 0xe8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r20
	.word 0xc6cc2882  ! 1: LDSBA_I	ldsba	[%r16, + 0x0882] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r25
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_170
	dec %r31
	.word 0x8f343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r7
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x92340002  ! 1: ORN_R	orn 	%r16, %r2, %r9
        mov 0x73, %r31
thr3_loop_cnt_171:
	.word 0xf8d427f2  ! 1: LDSHA_I	ldsha	[%r16, + 0x07f2] %asi, %r28
	.word 0xd8042fa0  ! 1: LDUW_I	lduw	[%r16 + 0x0fa0], %r12
	.word 0xcc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r6
	.word 0xfa542db8  ! 1: LDSH_I	ldsh	[%r16 + 0x0db8], %r29
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xda5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r13
	.word 0xc60c2bd8  ! 1: LDUB_I	ldub	[%r16 + 0x0bd8], %r3
	.word 0xc6dc2128  ! 1: LDXA_I	ldxa	[%r16, + 0x0128] %asi, %r3
	brnz %r31,thr3_loop_cnt_171
	dec %r31
	.word 0x972c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r11
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x8e1c2cbd  ! 1: XOR_I	xor 	%r16, 0x0cbd, %r7
        mov 0x75, %r31
thr3_loop_cnt_172:
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xf8842ed0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ed0] %asi, %r28
	.word 0xcc042a08  ! 1: LDUW_I	lduw	[%r16 + 0x0a08], %r6
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6d42c76  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c76] %asi, %r3
	.word 0xf68c297f  ! 1: LDUBA_I	lduba	[%r16, + 0x097f] %asi, %r27
	.word 0xc6dc2f40  ! 1: LDXA_I	ldxa	[%r16, + 0x0f40] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_172
	dec %r31
	.word 0x864421de  ! 1: ADDC_I	addc 	%r16, 0x01de, %r3
        mov 0x7c, %r31
thr3_loop_cnt_173:
	.word 0xd2cc2c37  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c37] %asi, %r9
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xda04242c  ! 1: LDUW_I	lduw	[%r16 + 0x042c], %r13
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r19
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6d42a54  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a54] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_173
	dec %r31
	.word 0x86242134  ! 1: SUB_I	sub 	%r16, 0x0134, %r3
	.word 0xac1427f9  ! 1: OR_I	or 	%r16, 0x07f9, %r22
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x8d, %r31
thr3_loop_cnt_174:
	.word 0xd84c2da9  ! 1: LDSB_I	ldsb	[%r16 + 0x0da9], %r12
	.word 0xc6cc26a6  ! 1: LDSBA_I	ldsba	[%r16, + 0x06a6] %asi, %r3
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	.word 0xdcc42674  ! 1: LDSWA_I	ldswa	[%r16, + 0x0674] %asi, %r14
	.word 0xd2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r9
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd40428e0  ! 1: LDUW_I	lduw	[%r16 + 0x08e0], %r10
	.word 0xda5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r13
	brnz %r31,thr3_loop_cnt_174
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x861424dc  ! 1: OR_I	or 	%r16, 0x04dc, %r3
	.word 0x960c0002  ! 1: AND_R	and 	%r16, %r2, %r11
        mov 0x10, %r31
thr3_loop_cnt_175:
	.word 0xc68c2e4a  ! 1: LDUBA_I	lduba	[%r16, + 0x0e4a] %asi, %r3
	.word 0xec142b6a  ! 1: LDUH_I	lduh	[%r16 + 0x0b6a], %r22
	.word 0xfc442f90  ! 1: LDSW_I	ldsw	[%r16 + 0x0f90], %r30
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d42fca  ! 1: LDSHA_I	ldsha	[%r16, + 0x0fca] %asi, %r3
	.word 0xc6d4259a  ! 1: LDSHA_I	ldsha	[%r16, + 0x059a] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf0dc2fd0  ! 1: LDXA_I	ldxa	[%r16, + 0x0fd0] %asi, %r24
	.word 0xf45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r26
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	brnz %r31,thr3_loop_cnt_175
	dec %r31
	.word 0x9424206c  ! 1: SUB_I	sub 	%r16, 0x006c, %r10
        mov 0xb2, %r31
thr3_loop_cnt_176:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc60c2063  ! 1: LDUB_I	ldub	[%r16 + 0x0063], %r3
	.word 0xf2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r25
	.word 0xee542fa8  ! 1: LDSH_I	ldsh	[%r16 + 0x0fa8], %r23
	.word 0xf0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r24
	.word 0xc6d4200a  ! 1: LDSHA_I	ldsha	[%r16, + 0x000a] %asi, %r3
	.word 0xdadc23e8  ! 1: LDXA_I	ldxa	[%r16, + 0x03e8] %asi, %r13
	.word 0xea040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r21
	.word 0xc6cc255b  ! 1: LDSBA_I	ldsba	[%r16, + 0x055b] %asi, %r3
	.word 0xd2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r9
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_176
	dec %r31
        mov 0x83, %r31
thr3_loop_cnt_177:
	.word 0xe80c2b71  ! 1: LDUB_I	ldub	[%r16 + 0x0b71], %r20
	.word 0xd4042084  ! 1: LDUW_I	lduw	[%r16 + 0x0084], %r10
	.word 0xf60c2341  ! 1: LDUB_I	ldub	[%r16 + 0x0341], %r27
	.word 0xe65c2f60  ! 1: LDX_I	ldx	[%r16 + 0x0f60], %r19
	.word 0xc61426d8  ! 1: LDUH_I	lduh	[%r16 + 0x06d8], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xcc0c2c79  ! 1: LDUB_I	ldub	[%r16 + 0x0c79], %r6
	.word 0xc6442820  ! 1: LDSW_I	ldsw	[%r16 + 0x0820], %r3
	.word 0xc6dc23f8  ! 1: LDXA_I	ldxa	[%r16, + 0x03f8] %asi, %r3
	.word 0xce142bf4  ! 1: LDUH_I	lduh	[%r16 + 0x0bf4], %r7
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_177
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0x95, %r31
thr3_loop_cnt_178:
	.word 0xee442498  ! 1: LDSW_I	ldsw	[%r16 + 0x0498], %r23
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	.word 0xc6542046  ! 1: LDSH_I	ldsh	[%r16 + 0x0046], %r3
	.word 0xc6142a72  ! 1: LDUH_I	lduh	[%r16 + 0x0a72], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r12
	.word 0xd6c42e74  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e74] %asi, %r11
	.word 0xf05c2400  ! 1: LDX_I	ldx	[%r16 + 0x0400], %r24
	brnz %r31,thr3_loop_cnt_178
	dec %r31
        mov 0x8b, %r31
thr3_loop_cnt_179:
	.word 0xda842ae8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ae8] %asi, %r13
	.word 0xe2942af8  ! 1: LDUHA_I	lduha	[%r16, + 0x0af8] %asi, %r17
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xdadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r13
	.word 0xda0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r13
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xce8429bc  ! 1: LDUWA_I	lduwa	[%r16, + 0x09bc] %asi, %r7
	.word 0xfc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r30
	brnz %r31,thr3_loop_cnt_179
	dec %r31
	.word 0xad3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r22
	.word 0x993c0002  ! 1: SRA_R	sra 	%r16, %r2, %r12
	.word 0x932c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r9
        mov 0xb1, %r31
thr3_loop_cnt_180:
	.word 0xea841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r21
	.word 0xea142140  ! 1: LDUH_I	lduh	[%r16 + 0x0140], %r21
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r8
	.word 0xd0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r8
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc65424b6  ! 1: LDSH_I	ldsh	[%r16 + 0x04b6], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_180
	dec %r31
        mov 0x35, %r31
thr3_loop_cnt_181:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	.word 0xe2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r17
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r28
	.word 0xdad42998  ! 1: LDSHA_I	ldsha	[%r16, + 0x0998] %asi, %r13
	.word 0xc64c2bbc  ! 1: LDSB_I	ldsb	[%r16 + 0x0bbc], %r3
	.word 0xf6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r27
	.word 0xf2cc2c59  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c59] %asi, %r25
	.word 0xd2142a1e  ! 1: LDUH_I	lduh	[%r16 + 0x0a1e], %r9
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_181
	dec %r31
	.word 0xac3c2bfb  ! 1: XNOR_I	xnor 	%r16, 0x0bfb, %r22
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0xc5, %r31
thr3_loop_cnt_182:
	.word 0xc654218c  ! 1: LDSH_I	ldsh	[%r16 + 0x018c], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc644216c  ! 1: LDSW_I	ldsw	[%r16 + 0x016c], %r3
	.word 0xf4942194  ! 1: LDUHA_I	lduha	[%r16, + 0x0194] %asi, %r26
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6042068  ! 1: LDUW_I	lduw	[%r16 + 0x0068], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_182
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0x9b, %r31
thr3_loop_cnt_183:
	.word 0xd85423b4  ! 1: LDSH_I	ldsh	[%r16 + 0x03b4], %r12
	.word 0xc64c2e6d  ! 1: LDSB_I	ldsb	[%r16 + 0x0e6d], %r3
	.word 0xf8dc2908  ! 1: LDXA_I	ldxa	[%r16, + 0x0908] %asi, %r28
	.word 0xc60c240c  ! 1: LDUB_I	ldub	[%r16 + 0x040c], %r3
	.word 0xe6142848  ! 1: LDUH_I	lduh	[%r16 + 0x0848], %r19
	.word 0xc6142a68  ! 1: LDUH_I	lduh	[%r16 + 0x0a68], %r3
	.word 0xdecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r15
	.word 0xfc442efc  ! 1: LDSW_I	ldsw	[%r16 + 0x0efc], %r30
	.word 0xc6542ff4  ! 1: LDSH_I	ldsh	[%r16 + 0x0ff4], %r3
	brnz %r31,thr3_loop_cnt_183
	dec %r31
	.word 0x86242889  ! 1: SUB_I	sub 	%r16, 0x0889, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0xa9340002  ! 1: SRL_R	srl 	%r16, %r2, %r20
	.word 0x86442136  ! 1: ADDC_I	addc 	%r16, 0x0136, %r3
        mov 0x2e, %r31
thr3_loop_cnt_184:
	.word 0xc6942aec  ! 1: LDUHA_I	lduha	[%r16, + 0x0aec] %asi, %r3
	.word 0xc64c248b  ! 1: LDSB_I	ldsb	[%r16 + 0x048b], %r3
	.word 0xf0142e94  ! 1: LDUH_I	lduh	[%r16 + 0x0e94], %r24
	.word 0xf4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r26
	.word 0xce842f60  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f60] %asi, %r7
	.word 0xde4c276a  ! 1: LDSB_I	ldsb	[%r16 + 0x076a], %r15
	.word 0xfa042944  ! 1: LDUW_I	lduw	[%r16 + 0x0944], %r29
	.word 0xe60420fc  ! 1: LDUW_I	lduw	[%r16 + 0x00fc], %r19
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_184
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0x8b, %r31
thr3_loop_cnt_185:
	.word 0xf2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r25
	.word 0xc60c2bb0  ! 1: LDUB_I	ldub	[%r16 + 0x0bb0], %r3
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xc614235e  ! 1: LDUH_I	lduh	[%r16 + 0x035e], %r3
	.word 0xc6cc2739  ! 1: LDSBA_I	ldsba	[%r16, + 0x0739] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xfacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r29
	brnz %r31,thr3_loop_cnt_185
	dec %r31
	.word 0xb60c2150  ! 1: AND_I	and 	%r16, 0x0150, %r27
	.word 0x9e1c260b  ! 1: XOR_I	xor 	%r16, 0x060b, %r15
        mov 0x8b, %r31
thr3_loop_cnt_186:
	.word 0xc69428c2  ! 1: LDUHA_I	lduha	[%r16, + 0x08c2] %asi, %r3
	.word 0xc65c2a18  ! 1: LDX_I	ldx	[%r16 + 0x0a18], %r3
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xf00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r24
	.word 0xc60c2240  ! 1: LDUB_I	ldub	[%r16 + 0x0240], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2352  ! 1: LDSBA_I	ldsba	[%r16, + 0x0352] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc60c2bbd  ! 1: LDUB_I	ldub	[%r16 + 0x0bbd], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd2c42f48  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f48] %asi, %r9
	brnz %r31,thr3_loop_cnt_186
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x8c040002  ! 1: ADD_R	add 	%r16, %r2, %r6
        mov 0x7b, %r31
thr3_loop_cnt_187:
	.word 0xd08c20d7  ! 1: LDUBA_I	lduba	[%r16, + 0x00d7] %asi, %r8
	.word 0xd2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r9
	.word 0xfa540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r29
	.word 0xd8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r12
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	.word 0xf6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r27
	.word 0xc6542bde  ! 1: LDSH_I	ldsh	[%r16 + 0x0bde], %r3
	.word 0xc6cc25b6  ! 1: LDSBA_I	ldsba	[%r16, + 0x05b6] %asi, %r3
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	brnz %r31,thr3_loop_cnt_187
	dec %r31
	.word 0x861c2c85  ! 1: XOR_I	xor 	%r16, 0x0c85, %r3
	.word 0x8f340002  ! 1: SRL_R	srl 	%r16, %r2, %r7
        mov 0xa5, %r31
thr3_loop_cnt_188:
	.word 0xd2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r9
	.word 0xc69424a4  ! 1: LDUHA_I	lduha	[%r16, + 0x04a4] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6942e2c  ! 1: LDUHA_I	lduha	[%r16, + 0x0e2c] %asi, %r3
	.word 0xec040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r22
	.word 0xc60c2093  ! 1: LDUB_I	ldub	[%r16 + 0x0093], %r3
	brnz %r31,thr3_loop_cnt_188
	dec %r31
	.word 0xa33c1002  ! 1: SRAX_R	srax	%r16, %r2, %r17
        mov 0x1e, %r31
thr3_loop_cnt_189:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc644243c  ! 1: LDSW_I	ldsw	[%r16 + 0x043c], %r3
	.word 0xf044275c  ! 1: LDSW_I	ldsw	[%r16 + 0x075c], %r24
	.word 0xea5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r21
	.word 0xfa042780  ! 1: LDUW_I	lduw	[%r16 + 0x0780], %r29
	.word 0xc6542a08  ! 1: LDSH_I	ldsh	[%r16 + 0x0a08], %r3
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xd4442e0c  ! 1: LDSW_I	ldsw	[%r16 + 0x0e0c], %r10
	.word 0xe8d42284  ! 1: LDSHA_I	ldsha	[%r16, + 0x0284] %asi, %r20
	brnz %r31,thr3_loop_cnt_189
	dec %r31
	.word 0x9f3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r15
        mov 0x60, %r31
thr3_loop_cnt_190:
	.word 0xfa042980  ! 1: LDUW_I	lduw	[%r16 + 0x0980], %r29
	.word 0xfcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r30
	.word 0xc6842f7c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f7c] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xce142314  ! 1: LDUH_I	lduh	[%r16 + 0x0314], %r7
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xec4c24f3  ! 1: LDSB_I	ldsb	[%r16 + 0x04f3], %r22
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	.word 0xcccc27ec  ! 1: LDSBA_I	ldsba	[%r16, + 0x07ec] %asi, %r6
	.word 0xc6cc2ae6  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ae6] %asi, %r3
	.word 0xd24c22b5  ! 1: LDSB_I	ldsb	[%r16 + 0x02b5], %r9
	brnz %r31,thr3_loop_cnt_190
	dec %r31
	.word 0xb2142297  ! 1: OR_I	or 	%r16, 0x0297, %r25
	.word 0x861c291c  ! 1: XOR_I	xor 	%r16, 0x091c, %r3
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x6a, %r31
thr3_loop_cnt_191:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe6dc23f8  ! 1: LDXA_I	ldxa	[%r16, + 0x03f8] %asi, %r19
	.word 0xde5c23e8  ! 1: LDX_I	ldx	[%r16 + 0x03e8], %r15
	.word 0xc65c2e28  ! 1: LDX_I	ldx	[%r16 + 0x0e28], %r3
	.word 0xc6d4252c  ! 1: LDSHA_I	ldsha	[%r16, + 0x052c] %asi, %r3
	.word 0xd4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r10
	.word 0xc6c42658  ! 1: LDSWA_I	ldswa	[%r16, + 0x0658] %asi, %r3
	.word 0xd8c42c84  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c84] %asi, %r12
	.word 0xfadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r29
	brnz %r31,thr3_loop_cnt_191
	dec %r31
	.word 0x863429cf  ! 1: ORN_I	orn 	%r16, 0x09cf, %r3
        mov 0x6b, %r31
thr3_loop_cnt_192:
	.word 0xee442908  ! 1: LDSW_I	ldsw	[%r16 + 0x0908], %r23
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xd4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r10
	.word 0xe4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r18
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xc64424a0  ! 1: LDSW_I	ldsw	[%r16 + 0x04a0], %r3
	.word 0xf84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r28
	.word 0xf4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r26
	.word 0xc6142062  ! 1: LDUH_I	lduh	[%r16 + 0x0062], %r3
	brnz %r31,thr3_loop_cnt_192
	dec %r31
        mov 0xa4, %r31
thr3_loop_cnt_193:
	.word 0xd2942376  ! 1: LDUHA_I	lduha	[%r16, + 0x0376] %asi, %r9
	.word 0xc6442620  ! 1: LDSW_I	ldsw	[%r16 + 0x0620], %r3
	.word 0xea5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r21
	.word 0xd6dc2e00  ! 1: LDXA_I	ldxa	[%r16, + 0x0e00] %asi, %r11
	.word 0xc6d42bec  ! 1: LDSHA_I	ldsha	[%r16, + 0x0bec] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd89427e4  ! 1: LDUHA_I	lduha	[%r16, + 0x07e4] %asi, %r12
	.word 0xc64428d4  ! 1: LDSW_I	ldsw	[%r16 + 0x08d4], %r3
	brnz %r31,thr3_loop_cnt_193
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x86342635  ! 1: SUBC_I	orn 	%r16, 0x0635, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x86342745  ! 1: ORN_I	orn 	%r16, 0x0745, %r3
        mov 0xa4, %r31
thr3_loop_cnt_194:
	.word 0xc6d4257e  ! 1: LDSHA_I	ldsha	[%r16, + 0x057e] %asi, %r3
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xc64c290a  ! 1: LDSB_I	ldsb	[%r16 + 0x090a], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf8dc2680  ! 1: LDXA_I	ldxa	[%r16, + 0x0680] %asi, %r28
	.word 0xf0d42eda  ! 1: LDSHA_I	ldsha	[%r16, + 0x0eda] %asi, %r24
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd8d42296  ! 1: LDSHA_I	ldsha	[%r16, + 0x0296] %asi, %r12
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r18
	.word 0xce142e8c  ! 1: LDUH_I	lduh	[%r16 + 0x0e8c], %r7
	.word 0xc6542032  ! 1: LDSH_I	ldsh	[%r16 + 0x0032], %r3
	brnz %r31,thr3_loop_cnt_194
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0x6d, %r31
thr3_loop_cnt_195:
	.word 0xcc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r6
	.word 0xeac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r21
	.word 0xc64c2271  ! 1: LDSB_I	ldsb	[%r16 + 0x0271], %r3
	.word 0xdc8c2d1b  ! 1: LDUBA_I	lduba	[%r16, + 0x0d1b] %asi, %r14
	.word 0xded42116  ! 1: LDSHA_I	ldsha	[%r16, + 0x0116] %asi, %r15
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc69426bc  ! 1: LDUHA_I	lduha	[%r16, + 0x06bc] %asi, %r3
	.word 0xc6842a70  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a70] %asi, %r3
	brnz %r31,thr3_loop_cnt_195
	dec %r31
	.word 0x86442329  ! 1: ADDC_I	addc 	%r16, 0x0329, %r3
        mov 0x50, %r31
thr3_loop_cnt_196:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc68c26a4  ! 1: LDUBA_I	lduba	[%r16, + 0x06a4] %asi, %r3
	.word 0xf85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r28
	.word 0xfc0422fc  ! 1: LDUW_I	lduw	[%r16 + 0x02fc], %r30
	.word 0xdc0c2701  ! 1: LDUB_I	ldub	[%r16 + 0x0701], %r14
	.word 0xde5c2dc8  ! 1: LDX_I	ldx	[%r16 + 0x0dc8], %r15
	.word 0xc64429a8  ! 1: LDSW_I	ldsw	[%r16 + 0x09a8], %r3
	.word 0xc6cc2a4b  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a4b] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xfc842c9c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c9c] %asi, %r30
	brnz %r31,thr3_loop_cnt_196
	dec %r31
	.word 0xb52c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r26
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0xa1, %r31
thr3_loop_cnt_197:
	.word 0xc65c23c0  ! 1: LDX_I	ldx	[%r16 + 0x03c0], %r3
	.word 0xc6442854  ! 1: LDSW_I	ldsw	[%r16 + 0x0854], %r3
	.word 0xc60c2f4a  ! 1: LDUB_I	ldub	[%r16 + 0x0f4a], %r3
	.word 0xf85c2610  ! 1: LDX_I	ldx	[%r16 + 0x0610], %r28
	.word 0xd6442a38  ! 1: LDSW_I	ldsw	[%r16 + 0x0a38], %r11
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6c42580  ! 1: LDSWA_I	ldswa	[%r16, + 0x0580] %asi, %r3
	brnz %r31,thr3_loop_cnt_197
	dec %r31
        mov 0x79, %r31
thr3_loop_cnt_198:
	.word 0xfc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r30
	.word 0xde4c2df5  ! 1: LDSB_I	ldsb	[%r16 + 0x0df5], %r15
	.word 0xd25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r9
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xdc8c2844  ! 1: LDUBA_I	lduba	[%r16, + 0x0844] %asi, %r14
	.word 0xc6dc2008  ! 1: LDXA_I	ldxa	[%r16, + 0x0008] %asi, %r3
	.word 0xf0d42586  ! 1: LDSHA_I	ldsha	[%r16, + 0x0586] %asi, %r24
	brnz %r31,thr3_loop_cnt_198
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x86042972  ! 1: ADD_I	add 	%r16, 0x0972, %r3
        mov 0x5, %r31
thr3_loop_cnt_199:
	.word 0xda442934  ! 1: LDSW_I	ldsw	[%r16 + 0x0934], %r13
	.word 0xc6dc2548  ! 1: LDXA_I	ldxa	[%r16, + 0x0548] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xfa0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r29
	.word 0xc6dc2120  ! 1: LDXA_I	ldxa	[%r16, + 0x0120] %asi, %r3
	.word 0xd4042d68  ! 1: LDUW_I	lduw	[%r16 + 0x0d68], %r10
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf65c2288  ! 1: LDX_I	ldx	[%r16 + 0x0288], %r27
	brnz %r31,thr3_loop_cnt_199
	dec %r31
        mov 0x95, %r31
thr3_loop_cnt_200:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xec0c2cbd  ! 1: LDUB_I	ldub	[%r16 + 0x0cbd], %r22
	.word 0xd4dc2a60  ! 1: LDXA_I	ldxa	[%r16, + 0x0a60] %asi, %r10
	.word 0xd2842100  ! 1: LDUWA_I	lduwa	[%r16, + 0x0100] %asi, %r9
	.word 0xe6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r19
	.word 0xf85422ac  ! 1: LDSH_I	ldsh	[%r16 + 0x02ac], %r28
	.word 0xec542a3e  ! 1: LDSH_I	ldsh	[%r16 + 0x0a3e], %r22
	.word 0xeac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r21
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6542844  ! 1: LDSH_I	ldsh	[%r16 + 0x0844], %r3
	.word 0xee4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r23
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_200
	dec %r31
	.word 0x86242f8d  ! 1: SUB_I	sub 	%r16, 0x0f8d, %r3
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0xa5342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r18
        mov 0x8e, %r31
thr3_loop_cnt_201:
	.word 0xc6142b1a  ! 1: LDUH_I	lduh	[%r16 + 0x0b1a], %r3
	.word 0xe6d42512  ! 1: LDSHA_I	ldsha	[%r16, + 0x0512] %asi, %r19
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	.word 0xc6142b94  ! 1: LDUH_I	lduh	[%r16 + 0x0b94], %r3
	.word 0xc6dc2c00  ! 1: LDXA_I	ldxa	[%r16, + 0x0c00] %asi, %r3
	.word 0xfa8c2cc3  ! 1: LDUBA_I	lduba	[%r16, + 0x0cc3] %asi, %r29
	.word 0xc684255c  ! 1: LDUWA_I	lduwa	[%r16, + 0x055c] %asi, %r3
	.word 0xda142b60  ! 1: LDUH_I	lduh	[%r16 + 0x0b60], %r13
	brnz %r31,thr3_loop_cnt_201
	dec %r31
        mov 0x7, %r31
thr3_loop_cnt_202:
	.word 0xea540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r21
	.word 0xde8c23ea  ! 1: LDUBA_I	lduba	[%r16, + 0x03ea] %asi, %r15
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc604286c  ! 1: LDUW_I	lduw	[%r16 + 0x086c], %r3
	.word 0xd28422f8  ! 1: LDUWA_I	lduwa	[%r16, + 0x02f8] %asi, %r9
	.word 0xd0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r8
	.word 0xccc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r6
	brnz %r31,thr3_loop_cnt_202
	dec %r31
	.word 0xbc440002  ! 1: ADDC_R	addc 	%r16, %r2, %r30
	.word 0xa6340002  ! 1: SUBC_R	orn 	%r16, %r2, %r19
	.word 0x963c2182  ! 1: XNOR_I	xnor 	%r16, 0x0182, %r11
	.word 0xb4240002  ! 1: SUB_R	sub 	%r16, %r2, %r26
        mov 0x4a, %r31
thr3_loop_cnt_203:
	.word 0xe80c2375  ! 1: LDUB_I	ldub	[%r16 + 0x0375], %r20
	.word 0xc6c428c8  ! 1: LDSWA_I	ldswa	[%r16, + 0x08c8] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xead4253e  ! 1: LDSHA_I	ldsha	[%r16, + 0x053e] %asi, %r21
	.word 0xd8442710  ! 1: LDSW_I	ldsw	[%r16 + 0x0710], %r12
	.word 0xee0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r23
	.word 0xeacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r21
	.word 0xeed41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r23
	.word 0xc6d4206e  ! 1: LDSHA_I	ldsha	[%r16, + 0x006e] %asi, %r3
	brnz %r31,thr3_loop_cnt_203
	dec %r31
        mov 0x94, %r31
thr3_loop_cnt_204:
	.word 0xd84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r12
	.word 0xf8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r28
	.word 0xf2842bf0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0bf0] %asi, %r25
	.word 0xc65c23a8  ! 1: LDX_I	ldx	[%r16 + 0x03a8], %r3
	.word 0xc6142980  ! 1: LDUH_I	lduh	[%r16 + 0x0980], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xda0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r13
	.word 0xc69420e4  ! 1: LDUHA_I	lduha	[%r16, + 0x00e4] %asi, %r3
	brnz %r31,thr3_loop_cnt_204
	dec %r31
	.word 0x96440002  ! 1: ADDC_R	addc 	%r16, %r2, %r11
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x5e, %r31
thr3_loop_cnt_205:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xd88c2ede  ! 1: LDUBA_I	lduba	[%r16, + 0x0ede] %asi, %r12
	.word 0xd84421b0  ! 1: LDSW_I	ldsw	[%r16 + 0x01b0], %r12
	.word 0xe8d42c34  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c34] %asi, %r20
	.word 0xc6442348  ! 1: LDSW_I	ldsw	[%r16 + 0x0348], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc69424aa  ! 1: LDUHA_I	lduha	[%r16, + 0x04aa] %asi, %r3
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	brnz %r31,thr3_loop_cnt_205
	dec %r31
	.word 0x940c0002  ! 1: AND_R	and 	%r16, %r2, %r10
	.word 0x9c040002  ! 1: ADD_R	add 	%r16, %r2, %r14
	.word 0x862c2bee  ! 1: ANDN_I	andn 	%r16, 0x0bee, %r3
	.word 0x86142a1b  ! 1: OR_I	or 	%r16, 0x0a1b, %r3
        mov 0xa3, %r31
thr3_loop_cnt_206:
	.word 0xec4c2e4e  ! 1: LDSB_I	ldsb	[%r16 + 0x0e4e], %r22
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6942a66  ! 1: LDUHA_I	lduha	[%r16, + 0x0a66] %asi, %r3
	.word 0xc6442d30  ! 1: LDSW_I	ldsw	[%r16 + 0x0d30], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd80424c8  ! 1: LDUW_I	lduw	[%r16 + 0x04c8], %r12
	.word 0xc65c2d68  ! 1: LDX_I	ldx	[%r16 + 0x0d68], %r3
	brnz %r31,thr3_loop_cnt_206
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0xa73c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r19
	.word 0x860c2a59  ! 1: AND_I	and 	%r16, 0x0a59, %r3
        mov 0x8f, %r31
thr3_loop_cnt_207:
	.word 0xc69422f0  ! 1: LDUHA_I	lduha	[%r16, + 0x02f0] %asi, %r3
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	.word 0xee0c291f  ! 1: LDUB_I	ldub	[%r16 + 0x091f], %r23
	.word 0xda5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r13
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc60c2de3  ! 1: LDUB_I	ldub	[%r16 + 0x0de3], %r3
	.word 0xee0c2d72  ! 1: LDUB_I	ldub	[%r16 + 0x0d72], %r23
	.word 0xc65c2598  ! 1: LDX_I	ldx	[%r16 + 0x0598], %r3
	brnz %r31,thr3_loop_cnt_207
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x861423bb  ! 1: OR_I	or 	%r16, 0x03bb, %r3
	.word 0x920c224e  ! 1: AND_I	and 	%r16, 0x024e, %r9
        mov 0x16, %r31
thr3_loop_cnt_208:
	.word 0xe6942bd2  ! 1: LDUHA_I	lduha	[%r16, + 0x0bd2] %asi, %r19
	.word 0xd6542034  ! 1: LDSH_I	ldsh	[%r16 + 0x0034], %r11
	.word 0xc60c2dd0  ! 1: LDUB_I	ldub	[%r16 + 0x0dd0], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xea0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r21
	.word 0xdacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r13
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6842b90  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b90] %asi, %r3
	.word 0xc65c2678  ! 1: LDX_I	ldx	[%r16 + 0x0678], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xea4c2311  ! 1: LDSB_I	ldsb	[%r16 + 0x0311], %r21
	brnz %r31,thr3_loop_cnt_208
	dec %r31
	.word 0xa5340002  ! 1: SRL_R	srl 	%r16, %r2, %r18
        mov 0x3f, %r31
thr3_loop_cnt_209:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xdcc42364  ! 1: LDSWA_I	ldswa	[%r16, + 0x0364] %asi, %r14
	.word 0xe6dc2018  ! 1: LDXA_I	ldxa	[%r16, + 0x0018] %asi, %r19
	.word 0xe6442aec  ! 1: LDSW_I	ldsw	[%r16 + 0x0aec], %r19
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc64427cc  ! 1: LDSW_I	ldsw	[%r16 + 0x07cc], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xeccc2672  ! 1: LDSBA_I	ldsba	[%r16, + 0x0672] %asi, %r22
	brnz %r31,thr3_loop_cnt_209
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x86342afd  ! 1: ORN_I	orn 	%r16, 0x0afd, %r3
        mov 0x5, %r31
thr3_loop_cnt_210:
	.word 0xc68c21b9  ! 1: LDUBA_I	lduba	[%r16, + 0x01b9] %asi, %r3
	.word 0xc65c2510  ! 1: LDX_I	ldx	[%r16 + 0x0510], %r3
	.word 0xc6dc20e0  ! 1: LDXA_I	ldxa	[%r16, + 0x00e0] %asi, %r3
	.word 0xeacc2b86  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b86] %asi, %r21
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xc68c2dfc  ! 1: LDUBA_I	lduba	[%r16, + 0x0dfc] %asi, %r3
	.word 0xc6442830  ! 1: LDSW_I	ldsw	[%r16 + 0x0830], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_210
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x8f2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r7
        mov 0x6, %r31
thr3_loop_cnt_211:
	.word 0xc68c2d13  ! 1: LDUBA_I	lduba	[%r16, + 0x0d13] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xdc1427d6  ! 1: LDUH_I	lduh	[%r16 + 0x07d6], %r14
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd20c2a10  ! 1: LDUB_I	ldub	[%r16 + 0x0a10], %r9
	.word 0xc684279c  ! 1: LDUWA_I	lduwa	[%r16, + 0x079c] %asi, %r3
	.word 0xc6842d70  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d70] %asi, %r3
	brnz %r31,thr3_loop_cnt_211
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x94342568  ! 1: ORN_I	orn 	%r16, 0x0568, %r10
        mov 0x20, %r31
thr3_loop_cnt_212:
	.word 0xc6442cdc  ! 1: LDSW_I	ldsw	[%r16 + 0x0cdc], %r3
	.word 0xc60c21ce  ! 1: LDUB_I	ldub	[%r16 + 0x01ce], %r3
	.word 0xc6942e42  ! 1: LDUHA_I	lduha	[%r16, + 0x0e42] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd44c2046  ! 1: LDSB_I	ldsb	[%r16 + 0x0046], %r10
	.word 0xead423ac  ! 1: LDSHA_I	ldsha	[%r16, + 0x03ac] %asi, %r21
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6042214  ! 1: LDUW_I	lduw	[%r16 + 0x0214], %r3
	.word 0xf2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r25
	.word 0xce8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r7
	brnz %r31,thr3_loop_cnt_212
	dec %r31
	.word 0xad341002  ! 1: SRLX_R	srlx	%r16, %r2, %r22
        mov 0x5d, %r31
thr3_loop_cnt_213:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r20
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xead42430  ! 1: LDSHA_I	ldsha	[%r16, + 0x0430] %asi, %r21
	.word 0xea942a32  ! 1: LDUHA_I	lduha	[%r16, + 0x0a32] %asi, %r21
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf8dc2640  ! 1: LDXA_I	ldxa	[%r16, + 0x0640] %asi, %r28
	.word 0xf2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r25
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xdccc2acc  ! 1: LDSBA_I	ldsba	[%r16, + 0x0acc] %asi, %r14
	brnz %r31,thr3_loop_cnt_213
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x94340002  ! 1: SUBC_R	orn 	%r16, %r2, %r10
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x6c, %r31
thr3_loop_cnt_214:
	.word 0xded42004  ! 1: LDSHA_I	ldsha	[%r16, + 0x0004] %asi, %r15
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d42956  ! 1: LDSHA_I	ldsha	[%r16, + 0x0956] %asi, %r3
	.word 0xc6142302  ! 1: LDUH_I	lduh	[%r16 + 0x0302], %r3
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xd8442938  ! 1: LDSW_I	ldsw	[%r16 + 0x0938], %r12
	.word 0xccd42844  ! 1: LDSHA_I	ldsha	[%r16, + 0x0844] %asi, %r6
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_214
	dec %r31
        mov 0x71, %r31
thr3_loop_cnt_215:
	.word 0xe20c2500  ! 1: LDUB_I	ldub	[%r16 + 0x0500], %r17
	.word 0xd8c424ec  ! 1: LDSWA_I	ldswa	[%r16, + 0x04ec] %asi, %r12
	.word 0xc6cc2568  ! 1: LDSBA_I	ldsba	[%r16, + 0x0568] %asi, %r3
	.word 0xc6c4285c  ! 1: LDSWA_I	ldswa	[%r16, + 0x085c] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xecd42af0  ! 1: LDSHA_I	ldsha	[%r16, + 0x0af0] %asi, %r22
	.word 0xe4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r18
	brnz %r31,thr3_loop_cnt_215
	dec %r31
	.word 0x863c283f  ! 1: XNOR_I	xnor 	%r16, 0x083f, %r3
	.word 0x922c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r9
        mov 0xb1, %r31
thr3_loop_cnt_216:
	.word 0xf40c2245  ! 1: LDUB_I	ldub	[%r16 + 0x0245], %r26
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xcc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r6
	.word 0xc6942ca8  ! 1: LDUHA_I	lduha	[%r16, + 0x0ca8] %asi, %r3
	.word 0xd80c28fc  ! 1: LDUB_I	ldub	[%r16 + 0x08fc], %r12
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6142728  ! 1: LDUH_I	lduh	[%r16 + 0x0728], %r3
	.word 0xf6cc2b5e  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b5e] %asi, %r27
	.word 0xc6cc2b95  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b95] %asi, %r3
	.word 0xd65c2498  ! 1: LDX_I	ldx	[%r16 + 0x0498], %r11
	.word 0xf4c422e8  ! 1: LDSWA_I	ldswa	[%r16, + 0x02e8] %asi, %r26
	brnz %r31,thr3_loop_cnt_216
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x8f2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r7
        mov 0x92, %r31
thr3_loop_cnt_217:
	.word 0xe28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r17
	.word 0xe64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r19
	.word 0xee8c23ee  ! 1: LDUBA_I	lduba	[%r16, + 0x03ee] %asi, %r23
	.word 0xea5422ae  ! 1: LDSH_I	ldsh	[%r16 + 0x02ae], %r21
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf4cc22df  ! 1: LDSBA_I	ldsba	[%r16, + 0x02df] %asi, %r26
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_217
	dec %r31
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0x75, %r31
thr3_loop_cnt_218:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd4542cf8  ! 1: LDSH_I	ldsh	[%r16 + 0x0cf8], %r10
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6042dbc  ! 1: LDUW_I	lduw	[%r16 + 0x0dbc], %r3
	.word 0xe6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r19
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf6442058  ! 1: LDSW_I	ldsw	[%r16 + 0x0058], %r27
	.word 0xda4c2eae  ! 1: LDSB_I	ldsb	[%r16 + 0x0eae], %r13
	brnz %r31,thr3_loop_cnt_218
	dec %r31
	.word 0xa4340002  ! 1: SUBC_R	orn 	%r16, %r2, %r18
        mov 0x9e, %r31
thr3_loop_cnt_219:
	.word 0xec442bec  ! 1: LDSW_I	ldsw	[%r16 + 0x0bec], %r22
	.word 0xc694287c  ! 1: LDUHA_I	lduha	[%r16, + 0x087c] %asi, %r3
	.word 0xc6cc2ded  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ded] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	.word 0xcc4425b4  ! 1: LDSW_I	ldsw	[%r16 + 0x05b4], %r6
	.word 0xe4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r18
	.word 0xd6d42196  ! 1: LDSHA_I	ldsha	[%r16, + 0x0196] %asi, %r11
	brnz %r31,thr3_loop_cnt_219
	dec %r31
        mov 0xa1, %r31
thr3_loop_cnt_220:
	.word 0xc6cc24fd  ! 1: LDSBA_I	ldsba	[%r16, + 0x04fd] %asi, %r3
	.word 0xe6942868  ! 1: LDUHA_I	lduha	[%r16, + 0x0868] %asi, %r19
	.word 0xc6cc2e44  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e44] %asi, %r3
	.word 0xecc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r22
	.word 0xfa941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r29
	.word 0xc60c2ae2  ! 1: LDUB_I	ldub	[%r16 + 0x0ae2], %r3
	.word 0xc68c2478  ! 1: LDUBA_I	lduba	[%r16, + 0x0478] %asi, %r3
	.word 0xc6d427ce  ! 1: LDSHA_I	ldsha	[%r16, + 0x07ce] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_220
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x8634225a  ! 1: SUBC_I	orn 	%r16, 0x025a, %r3
        mov 0x69, %r31
thr3_loop_cnt_221:
	.word 0xde140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r15
	.word 0xea540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r21
	.word 0xf8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r28
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r20
	.word 0xde0c2075  ! 1: LDUB_I	ldub	[%r16 + 0x0075], %r15
	.word 0xf2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r25
	.word 0xc68c2374  ! 1: LDUBA_I	lduba	[%r16, + 0x0374] %asi, %r3
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xd2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r9
	brnz %r31,thr3_loop_cnt_221
	dec %r31
	.word 0x862c2154  ! 1: ANDN_I	andn 	%r16, 0x0154, %r3
	.word 0xb53c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r26
        mov 0xa1, %r31
thr3_loop_cnt_222:
	.word 0xe8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r20
	.word 0xc61428d8  ! 1: LDUH_I	lduh	[%r16 + 0x08d8], %r3
	.word 0xec4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r22
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc65c2228  ! 1: LDX_I	ldx	[%r16 + 0x0228], %r3
	.word 0xc65426d8  ! 1: LDSH_I	ldsh	[%r16 + 0x06d8], %r3
	.word 0xd4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r10
	brnz %r31,thr3_loop_cnt_222
	dec %r31
	.word 0x863c229e  ! 1: XNOR_I	xnor 	%r16, 0x029e, %r3
	.word 0xa9340002  ! 1: SRL_R	srl 	%r16, %r2, %r20
	.word 0x9d2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r14
	.word 0x8d340002  ! 1: SRL_R	srl 	%r16, %r2, %r6
        mov 0xb6, %r31
thr3_loop_cnt_223:
	.word 0xc69428a8  ! 1: LDUHA_I	lduha	[%r16, + 0x08a8] %asi, %r3
	.word 0xfa841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r29
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c2bbf  ! 1: LDSB_I	ldsb	[%r16 + 0x0bbf], %r3
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xd25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r9
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf8442814  ! 1: LDSW_I	ldsw	[%r16 + 0x0814], %r28
	.word 0xf8442288  ! 1: LDSW_I	ldsw	[%r16 + 0x0288], %r28
	brnz %r31,thr3_loop_cnt_223
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x861c23ec  ! 1: XOR_I	xor 	%r16, 0x03ec, %r3
	.word 0xb33c1002  ! 1: SRAX_R	srax	%r16, %r2, %r25
        mov 0xa6, %r31
thr3_loop_cnt_224:
	.word 0xf28c2806  ! 1: LDUBA_I	lduba	[%r16, + 0x0806] %asi, %r25
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xce0c26c3  ! 1: LDUB_I	ldub	[%r16 + 0x06c3], %r7
	.word 0xe4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r18
	.word 0xc6042218  ! 1: LDUW_I	lduw	[%r16 + 0x0218], %r3
	.word 0xec942240  ! 1: LDUHA_I	lduha	[%r16, + 0x0240] %asi, %r22
	.word 0xf44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r26
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc65c2f30  ! 1: LDX_I	ldx	[%r16 + 0x0f30], %r3
	.word 0xc61423ea  ! 1: LDUH_I	lduh	[%r16 + 0x03ea], %r3
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xd84c2316  ! 1: LDSB_I	ldsb	[%r16 + 0x0316], %r12
	brnz %r31,thr3_loop_cnt_224
	dec %r31
	.word 0x861c28d3  ! 1: XOR_I	xor 	%r16, 0x08d3, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0xbd341002  ! 1: SRLX_R	srlx	%r16, %r2, %r30
        mov 0xc1, %r31
thr3_loop_cnt_225:
	.word 0xe6442f0c  ! 1: LDSW_I	ldsw	[%r16 + 0x0f0c], %r19
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc60c2819  ! 1: LDUB_I	ldub	[%r16 + 0x0819], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r10
	.word 0xec440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r22
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xfc5427b6  ! 1: LDSH_I	ldsh	[%r16 + 0x07b6], %r30
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r9
	.word 0xd65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r11
	.word 0xda54255e  ! 1: LDSH_I	ldsh	[%r16 + 0x055e], %r13
	brnz %r31,thr3_loop_cnt_225
	dec %r31
        mov 0x1f, %r31
thr3_loop_cnt_226:
	.word 0xd84421e8  ! 1: LDSW_I	ldsw	[%r16 + 0x01e8], %r12
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd40c20a5  ! 1: LDUB_I	ldub	[%r16 + 0x00a5], %r10
	.word 0xc6942906  ! 1: LDUHA_I	lduha	[%r16, + 0x0906] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r9
	.word 0xeadc2e78  ! 1: LDXA_I	ldxa	[%r16, + 0x0e78] %asi, %r21
	.word 0xc614288a  ! 1: LDUH_I	lduh	[%r16 + 0x088a], %r3
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_226
	dec %r31
	.word 0xb2040002  ! 1: ADD_R	add 	%r16, %r2, %r25
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
        mov 0x9d, %r31
thr3_loop_cnt_227:
	.word 0xc6942066  ! 1: LDUHA_I	lduha	[%r16, + 0x0066] %asi, %r3
	.word 0xda142c14  ! 1: LDUH_I	lduh	[%r16 + 0x0c14], %r13
	.word 0xc6442700  ! 1: LDSW_I	ldsw	[%r16 + 0x0700], %r3
	.word 0xe8942f82  ! 1: LDUHA_I	lduha	[%r16, + 0x0f82] %asi, %r20
	.word 0xfa040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r29
	.word 0xfc142b64  ! 1: LDUH_I	lduh	[%r16 + 0x0b64], %r30
	.word 0xc6dc27b0  ! 1: LDXA_I	ldxa	[%r16, + 0x07b0] %asi, %r3
	.word 0xc6042f54  ! 1: LDUW_I	lduw	[%r16 + 0x0f54], %r3
	brnz %r31,thr3_loop_cnt_227
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0xa20429f1  ! 1: ADD_I	add 	%r16, 0x09f1, %r17
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0x25, %r31
thr3_loop_cnt_228:
	.word 0xf8542b80  ! 1: LDSH_I	ldsh	[%r16 + 0x0b80], %r28
	.word 0xf4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r26
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc65c2660  ! 1: LDX_I	ldx	[%r16 + 0x0660], %r3
	.word 0xf2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r25
	.word 0xd4c42180  ! 1: LDSWA_I	ldswa	[%r16, + 0x0180] %asi, %r10
	.word 0xec0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r22
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	brnz %r31,thr3_loop_cnt_228
	dec %r31
	.word 0xa21c2b30  ! 1: XOR_I	xor 	%r16, 0x0b30, %r17
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0x26, %r31
thr3_loop_cnt_229:
	.word 0xc68426e0  ! 1: LDUWA_I	lduwa	[%r16, + 0x06e0] %asi, %r3
	.word 0xe6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r19
	.word 0xc64c2ffe  ! 1: LDSB_I	ldsb	[%r16 + 0x0ffe], %r3
	.word 0xec4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r22
	.word 0xc60c2878  ! 1: LDUB_I	ldub	[%r16 + 0x0878], %r3
	.word 0xce4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r7
	.word 0xc65c2638  ! 1: LDX_I	ldx	[%r16 + 0x0638], %r3
	.word 0xd44c2a25  ! 1: LDSB_I	ldsb	[%r16 + 0x0a25], %r10
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xfa442a88  ! 1: LDSW_I	ldsw	[%r16 + 0x0a88], %r29
	.word 0xfc4423c8  ! 1: LDSW_I	ldsw	[%r16 + 0x03c8], %r30
	.word 0xeccc2e53  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e53] %asi, %r22
	brnz %r31,thr3_loop_cnt_229
	dec %r31
	.word 0x86342296  ! 1: SUBC_I	orn 	%r16, 0x0296, %r3
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0x32, %r31
thr3_loop_cnt_230:
	.word 0xe48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r18
	.word 0xc65429e4  ! 1: LDSH_I	ldsh	[%r16 + 0x09e4], %r3
	.word 0xfcdc2fc8  ! 1: LDXA_I	ldxa	[%r16, + 0x0fc8] %asi, %r30
	.word 0xcc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r6
	.word 0xea5c2360  ! 1: LDX_I	ldx	[%r16 + 0x0360], %r21
	.word 0xde842568  ! 1: LDUWA_I	lduwa	[%r16, + 0x0568] %asi, %r15
	.word 0xc65429de  ! 1: LDSH_I	ldsh	[%r16 + 0x09de], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xeacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r21
	.word 0xda0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r13
	.word 0xd88c2c90  ! 1: LDUBA_I	lduba	[%r16, + 0x0c90] %asi, %r12
	brnz %r31,thr3_loop_cnt_230
	dec %r31
	.word 0xae442efb  ! 1: ADDC_I	addc 	%r16, 0x0efb, %r23
	.word 0x952c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r10
        mov 0x4a, %r31
thr3_loop_cnt_231:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc64c259b  ! 1: LDSB_I	ldsb	[%r16 + 0x059b], %r3
	.word 0xc64c28d2  ! 1: LDSB_I	ldsb	[%r16 + 0x08d2], %r3
	.word 0xf04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r24
	.word 0xd6442e14  ! 1: LDSW_I	ldsw	[%r16 + 0x0e14], %r11
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6d422e8  ! 1: LDSHA_I	ldsha	[%r16, + 0x02e8] %asi, %r3
	.word 0xc65c2af0  ! 1: LDX_I	ldx	[%r16 + 0x0af0], %r3
	brnz %r31,thr3_loop_cnt_231
	dec %r31
	.word 0x8e042ab0  ! 1: ADD_I	add 	%r16, 0x0ab0, %r7
	.word 0x903427da  ! 1: SUBC_I	orn 	%r16, 0x07da, %r8
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x941c28c2  ! 1: XOR_I	xor 	%r16, 0x08c2, %r10
        mov 0x54, %r31
thr3_loop_cnt_232:
	.word 0xd6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r11
	.word 0xe40421c4  ! 1: LDUW_I	lduw	[%r16 + 0x01c4], %r18
	.word 0xc6042288  ! 1: LDUW_I	lduw	[%r16 + 0x0288], %r3
	.word 0xd6c42ebc  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ebc] %asi, %r11
	.word 0xe88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r20
	.word 0xc6dc2318  ! 1: LDXA_I	ldxa	[%r16, + 0x0318] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2158  ! 1: LDXA_I	ldxa	[%r16, + 0x0158] %asi, %r3
	.word 0xc6dc26f8  ! 1: LDXA_I	ldxa	[%r16, + 0x06f8] %asi, %r3
	.word 0xc6c420cc  ! 1: LDSWA_I	ldswa	[%r16, + 0x00cc] %asi, %r3
	brnz %r31,thr3_loop_cnt_232
	dec %r31
	.word 0x940c0002  ! 1: AND_R	and 	%r16, %r2, %r10
        mov 0x73, %r31
thr3_loop_cnt_233:
	.word 0xf6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r27
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	.word 0xeccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r22
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xcc542618  ! 1: LDSH_I	ldsh	[%r16 + 0x0618], %r6
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xdac42120  ! 1: LDSWA_I	ldswa	[%r16, + 0x0120] %asi, %r13
	brnz %r31,thr3_loop_cnt_233
	dec %r31
	.word 0xad2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r22
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x953c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r10
        mov 0x7c, %r31
thr3_loop_cnt_234:
	.word 0xfa1424b0  ! 1: LDUH_I	lduh	[%r16 + 0x04b0], %r29
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc64c2e55  ! 1: LDSB_I	ldsb	[%r16 + 0x0e55], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc61428fc  ! 1: LDUH_I	lduh	[%r16 + 0x08fc], %r3
	.word 0xc6442e44  ! 1: LDSW_I	ldsw	[%r16 + 0x0e44], %r3
	.word 0xde140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r15
	.word 0xd4c42c54  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c54] %asi, %r10
	brnz %r31,thr3_loop_cnt_234
	dec %r31
	.word 0x96442fcd  ! 1: ADDC_I	addc 	%r16, 0x0fcd, %r11
	.word 0xb92c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r28
        mov 0x2, %r31
thr3_loop_cnt_235:
	.word 0xc68c2c48  ! 1: LDUBA_I	lduba	[%r16, + 0x0c48] %asi, %r3
	.word 0xe4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r18
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xce4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r7
	.word 0xc684257c  ! 1: LDUWA_I	lduwa	[%r16, + 0x057c] %asi, %r3
	.word 0xea142898  ! 1: LDUH_I	lduh	[%r16 + 0x0898], %r21
	.word 0xc6c42230  ! 1: LDSWA_I	ldswa	[%r16, + 0x0230] %asi, %r3
	.word 0xf4542b94  ! 1: LDSH_I	ldsh	[%r16 + 0x0b94], %r26
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_235
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0xb61421f0  ! 1: OR_I	or 	%r16, 0x01f0, %r27
        mov 0x1b, %r31
thr3_loop_cnt_236:
	.word 0xf65c2188  ! 1: LDX_I	ldx	[%r16 + 0x0188], %r27
	.word 0xea842b9c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b9c] %asi, %r21
	.word 0xec5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r22
	.word 0xc68c2e3d  ! 1: LDUBA_I	lduba	[%r16, + 0x0e3d] %asi, %r3
	.word 0xfadc25e0  ! 1: LDXA_I	ldxa	[%r16, + 0x05e0] %asi, %r29
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xe88c2ff5  ! 1: LDUBA_I	lduba	[%r16, + 0x0ff5] %asi, %r20
	.word 0xce942fc6  ! 1: LDUHA_I	lduha	[%r16, + 0x0fc6] %asi, %r7
	.word 0xc6542f70  ! 1: LDSH_I	ldsh	[%r16 + 0x0f70], %r3
	.word 0xd0842da4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0da4] %asi, %r8
	.word 0xe4542dde  ! 1: LDSH_I	ldsh	[%r16 + 0x0dde], %r18
	.word 0xe4cc2a28  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a28] %asi, %r18
	brnz %r31,thr3_loop_cnt_236
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x86242080  ! 1: SUB_I	sub 	%r16, 0x0080, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0xb8, %r31
thr3_loop_cnt_237:
	.word 0xec8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r22
	.word 0xc6142bd2  ! 1: LDUH_I	lduh	[%r16 + 0x0bd2], %r3
	.word 0xe8c42730  ! 1: LDSWA_I	ldswa	[%r16, + 0x0730] %asi, %r20
	.word 0xd0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r8
	.word 0xda4c239e  ! 1: LDSB_I	ldsb	[%r16 + 0x039e], %r13
	.word 0xce542d84  ! 1: LDSH_I	ldsh	[%r16 + 0x0d84], %r7
	.word 0xe20c2ca8  ! 1: LDUB_I	ldub	[%r16 + 0x0ca8], %r17
	.word 0xe8142f42  ! 1: LDUH_I	lduh	[%r16 + 0x0f42], %r20
	brnz %r31,thr3_loop_cnt_237
	dec %r31
	.word 0x8c340002  ! 1: SUBC_R	orn 	%r16, %r2, %r6
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x862c2b7e  ! 1: ANDN_I	andn 	%r16, 0x0b7e, %r3
	.word 0x92140002  ! 1: OR_R	or 	%r16, %r2, %r9
        mov 0x13, %r31
thr3_loop_cnt_238:
	.word 0xd654250a  ! 1: LDSH_I	ldsh	[%r16 + 0x050a], %r11
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6042740  ! 1: LDUW_I	lduw	[%r16 + 0x0740], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6442ae4  ! 1: LDSW_I	ldsw	[%r16 + 0x0ae4], %r3
	.word 0xdc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r14
	.word 0xe25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r17
	.word 0xf4dc2708  ! 1: LDXA_I	ldxa	[%r16, + 0x0708] %asi, %r26
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	brnz %r31,thr3_loop_cnt_238
	dec %r31
	.word 0xa2040002  ! 1: ADD_R	add 	%r16, %r2, %r17
	.word 0x9a242e85  ! 1: SUB_I	sub 	%r16, 0x0e85, %r13
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x863425d4  ! 1: ORN_I	orn 	%r16, 0x05d4, %r3
        mov 0x18, %r31
thr3_loop_cnt_239:
	.word 0xdc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r14
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xec841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r22
	.word 0xc6842164  ! 1: LDUWA_I	lduwa	[%r16, + 0x0164] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc64c21c5  ! 1: LDSB_I	ldsb	[%r16 + 0x01c5], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf0d420fe  ! 1: LDSHA_I	ldsha	[%r16, + 0x00fe] %asi, %r24
	.word 0xd60c27f9  ! 1: LDUB_I	ldub	[%r16 + 0x07f9], %r11
	.word 0xfa8c2cfa  ! 1: LDUBA_I	lduba	[%r16, + 0x0cfa] %asi, %r29
	brnz %r31,thr3_loop_cnt_239
	dec %r31
	.word 0xb5341002  ! 1: SRLX_R	srlx	%r16, %r2, %r26
	.word 0xb72c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r27
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0x36, %r31
thr3_loop_cnt_240:
	.word 0xee542a20  ! 1: LDSH_I	ldsh	[%r16 + 0x0a20], %r23
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6d42d62  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d62] %asi, %r3
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xf6542302  ! 1: LDSH_I	ldsh	[%r16 + 0x0302], %r27
	.word 0xf05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r24
	.word 0xc65c2f48  ! 1: LDX_I	ldx	[%r16 + 0x0f48], %r3
	.word 0xee5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r23
	.word 0xc68c2809  ! 1: LDUBA_I	lduba	[%r16, + 0x0809] %asi, %r3
	brnz %r31,thr3_loop_cnt_240
	dec %r31
        mov 0x21, %r31
thr3_loop_cnt_241:
	.word 0xd2d42afc  ! 1: LDSHA_I	ldsha	[%r16, + 0x0afc] %asi, %r9
	.word 0xc60c23ef  ! 1: LDUB_I	ldub	[%r16 + 0x03ef], %r3
	.word 0xc60c2707  ! 1: LDUB_I	ldub	[%r16 + 0x0707], %r3
	.word 0xee040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r23
	.word 0xda0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r13
	.word 0xeccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r22
	.word 0xc6842720  ! 1: LDUWA_I	lduwa	[%r16, + 0x0720] %asi, %r3
	.word 0xd4542904  ! 1: LDSH_I	ldsh	[%r16 + 0x0904], %r10
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6042f64  ! 1: LDUW_I	lduw	[%r16 + 0x0f64], %r3
	.word 0xc6d42c62  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c62] %asi, %r3
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	brnz %r31,thr3_loop_cnt_241
	dec %r31
	.word 0x933c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r9
        mov 0xad, %r31
thr3_loop_cnt_242:
	.word 0xd04425b4  ! 1: LDSW_I	ldsw	[%r16 + 0x05b4], %r8
	.word 0xd24c2f4a  ! 1: LDSB_I	ldsb	[%r16 + 0x0f4a], %r9
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xda4c23a4  ! 1: LDSB_I	ldsb	[%r16 + 0x03a4], %r13
	.word 0xc64c2b5e  ! 1: LDSB_I	ldsb	[%r16 + 0x0b5e], %r3
	.word 0xf2942b82  ! 1: LDUHA_I	lduha	[%r16, + 0x0b82] %asi, %r25
	.word 0xde14260c  ! 1: LDUH_I	lduh	[%r16 + 0x060c], %r15
	brnz %r31,thr3_loop_cnt_242
	dec %r31
	.word 0x86342412  ! 1: SUBC_I	orn 	%r16, 0x0412, %r3
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x86142304  ! 1: OR_I	or 	%r16, 0x0304, %r3
        mov 0x16, %r31
thr3_loop_cnt_243:
	.word 0xc60c27f7  ! 1: LDUB_I	ldub	[%r16 + 0x07f7], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xc6c428ec  ! 1: LDSWA_I	ldswa	[%r16, + 0x08ec] %asi, %r3
	.word 0xdad425ba  ! 1: LDSHA_I	ldsha	[%r16, + 0x05ba] %asi, %r13
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6842848  ! 1: LDUWA_I	lduwa	[%r16, + 0x0848] %asi, %r3
	.word 0xe2942a42  ! 1: LDUHA_I	lduha	[%r16, + 0x0a42] %asi, %r17
	.word 0xe8942840  ! 1: LDUHA_I	lduha	[%r16, + 0x0840] %asi, %r20
	brnz %r31,thr3_loop_cnt_243
	dec %r31
	.word 0x9c440002  ! 1: ADDC_R	addc 	%r16, %r2, %r14
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0xb92c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r28
	.word 0xb52c0002  ! 1: SLL_R	sll 	%r16, %r2, %r26
        mov 0x3b, %r31
thr3_loop_cnt_244:
	.word 0xc65c28d0  ! 1: LDX_I	ldx	[%r16 + 0x08d0], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xda142162  ! 1: LDUH_I	lduh	[%r16 + 0x0162], %r13
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	.word 0xdc142a80  ! 1: LDUH_I	lduh	[%r16 + 0x0a80], %r14
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xdc442b38  ! 1: LDSW_I	ldsw	[%r16 + 0x0b38], %r14
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe6942cc2  ! 1: LDUHA_I	lduha	[%r16, + 0x0cc2] %asi, %r19
	brnz %r31,thr3_loop_cnt_244
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x67, %r31
thr3_loop_cnt_245:
	.word 0xcc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r6
	.word 0xea841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r21
	.word 0xda941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r13
	.word 0xeedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r23
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r27
	.word 0xc6542ad8  ! 1: LDSH_I	ldsh	[%r16 + 0x0ad8], %r3
	.word 0xfc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r30
	.word 0xce4c24ee  ! 1: LDSB_I	ldsb	[%r16 + 0x04ee], %r7
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	.word 0xc65425b0  ! 1: LDSH_I	ldsh	[%r16 + 0x05b0], %r3
	brnz %r31,thr3_loop_cnt_245
	dec %r31
        mov 0x4, %r31
thr3_loop_cnt_246:
	.word 0xf00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r24
	.word 0xf4d42d90  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d90] %asi, %r26
	.word 0xc64c2d18  ! 1: LDSB_I	ldsb	[%r16 + 0x0d18], %r3
	.word 0xf05c2208  ! 1: LDX_I	ldx	[%r16 + 0x0208], %r24
	.word 0xf2842114  ! 1: LDUWA_I	lduwa	[%r16, + 0x0114] %asi, %r25
	.word 0xea040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r21
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc65c2d30  ! 1: LDX_I	ldx	[%r16 + 0x0d30], %r3
	.word 0xf21427de  ! 1: LDUH_I	lduh	[%r16 + 0x07de], %r25
	.word 0xc68c2bb3  ! 1: LDUBA_I	lduba	[%r16, + 0x0bb3] %asi, %r3
	brnz %r31,thr3_loop_cnt_246
	dec %r31
	.word 0xab342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r21
	.word 0x860c29df  ! 1: AND_I	and 	%r16, 0x09df, %r3
	.word 0xa434229b  ! 1: SUBC_I	orn 	%r16, 0x029b, %r18
        mov 0x42, %r31
thr3_loop_cnt_247:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xfc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r30
	.word 0xc6542832  ! 1: LDSH_I	ldsh	[%r16 + 0x0832], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xda942826  ! 1: LDUHA_I	lduha	[%r16, + 0x0826] %asi, %r13
	.word 0xc60420c8  ! 1: LDUW_I	lduw	[%r16 + 0x00c8], %r3
	.word 0xc60c23cd  ! 1: LDUB_I	ldub	[%r16 + 0x03cd], %r3
	.word 0xc6cc2336  ! 1: LDSBA_I	ldsba	[%r16, + 0x0336] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xfc5c2e00  ! 1: LDX_I	ldx	[%r16 + 0x0e00], %r30
	brnz %r31,thr3_loop_cnt_247
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x92342db4  ! 1: ORN_I	orn 	%r16, 0x0db4, %r9
	.word 0x863c2223  ! 1: XNOR_I	xnor 	%r16, 0x0223, %r3
        mov 0x75, %r31
thr3_loop_cnt_248:
	.word 0xecd42b52  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b52] %asi, %r22
	.word 0xf05c29d8  ! 1: LDX_I	ldx	[%r16 + 0x09d8], %r24
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6542db4  ! 1: LDSH_I	ldsh	[%r16 + 0x0db4], %r3
	.word 0xc64c26f9  ! 1: LDSB_I	ldsb	[%r16 + 0x06f9], %r3
	.word 0xf84c2947  ! 1: LDSB_I	ldsb	[%r16 + 0x0947], %r28
	.word 0xde5c2410  ! 1: LDX_I	ldx	[%r16 + 0x0410], %r15
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6942df6  ! 1: LDUHA_I	lduha	[%r16, + 0x0df6] %asi, %r3
	.word 0xc6cc24e5  ! 1: LDSBA_I	ldsba	[%r16, + 0x04e5] %asi, %r3
	brnz %r31,thr3_loop_cnt_248
	dec %r31
	.word 0x9214299d  ! 1: OR_I	or 	%r16, 0x099d, %r9
	.word 0x86142918  ! 1: OR_I	or 	%r16, 0x0918, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x961c0002  ! 1: XOR_R	xor 	%r16, %r2, %r11
        mov 0x5d, %r31
thr3_loop_cnt_249:
	.word 0xeac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r21
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	.word 0xc6c42184  ! 1: LDSWA_I	ldswa	[%r16, + 0x0184] %asi, %r3
	.word 0xe6dc2968  ! 1: LDXA_I	ldxa	[%r16, + 0x0968] %asi, %r19
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r17
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6d42660  ! 1: LDSHA_I	ldsha	[%r16, + 0x0660] %asi, %r3
	.word 0xd65c2bc8  ! 1: LDX_I	ldx	[%r16 + 0x0bc8], %r11
	brnz %r31,thr3_loop_cnt_249
	dec %r31
	.word 0x9c142185  ! 1: OR_I	or 	%r16, 0x0185, %r14
        mov 0xa, %r31
thr3_loop_cnt_250:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xec4422c8  ! 1: LDSW_I	ldsw	[%r16 + 0x02c8], %r22
	.word 0xea0c2420  ! 1: LDUB_I	ldub	[%r16 + 0x0420], %r21
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xf4dc2ac0  ! 1: LDXA_I	ldxa	[%r16, + 0x0ac0] %asi, %r26
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xce440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r7
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	brnz %r31,thr3_loop_cnt_250
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x941c2c03  ! 1: XOR_I	xor 	%r16, 0x0c03, %r10
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x40, %r31
thr3_loop_cnt_251:
	.word 0xc6442eac  ! 1: LDSW_I	ldsw	[%r16 + 0x0eac], %r3
	.word 0xc60428b8  ! 1: LDUW_I	lduw	[%r16 + 0x08b8], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2b68  ! 1: LDXA_I	ldxa	[%r16, + 0x0b68] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6442c20  ! 1: LDSW_I	ldsw	[%r16 + 0x0c20], %r3
	.word 0xc60c2b3a  ! 1: LDUB_I	ldub	[%r16 + 0x0b3a], %r3
	.word 0xcc5424f2  ! 1: LDSH_I	ldsh	[%r16 + 0x04f2], %r6
	.word 0xc68c2c87  ! 1: LDUBA_I	lduba	[%r16, + 0x0c87] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_251
	dec %r31
	.word 0xa7340002  ! 1: SRL_R	srl 	%r16, %r2, %r19
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x863c2817  ! 1: XNOR_I	xnor 	%r16, 0x0817, %r3
        mov 0x44, %r31
thr3_loop_cnt_252:
	.word 0xc6842898  ! 1: LDUWA_I	lduwa	[%r16, + 0x0898] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6d425d4  ! 1: LDSHA_I	ldsha	[%r16, + 0x05d4] %asi, %r3
	.word 0xd2542244  ! 1: LDSH_I	ldsh	[%r16 + 0x0244], %r9
	.word 0xce4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r7
	.word 0xfa0c24b1  ! 1: LDUB_I	ldub	[%r16 + 0x04b1], %r29
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xc6cc2422  ! 1: LDSBA_I	ldsba	[%r16, + 0x0422] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xce842ed4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ed4] %asi, %r7
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_252
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0x37, %r31
thr3_loop_cnt_253:
	.word 0xf6d42d5e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d5e] %asi, %r27
	.word 0xd0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r8
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd65c2ea8  ! 1: LDX_I	ldx	[%r16 + 0x0ea8], %r11
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xf61427e4  ! 1: LDUH_I	lduh	[%r16 + 0x07e4], %r27
	.word 0xc6942ef8  ! 1: LDUHA_I	lduha	[%r16, + 0x0ef8] %asi, %r3
	.word 0xc6d42f6c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f6c] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd6042c94  ! 1: LDUW_I	lduw	[%r16 + 0x0c94], %r11
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	brnz %r31,thr3_loop_cnt_253
	dec %r31
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
        mov 0x6b, %r31
thr3_loop_cnt_254:
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xc6842adc  ! 1: LDUWA_I	lduwa	[%r16, + 0x0adc] %asi, %r3
	.word 0xf4cc29ed  ! 1: LDSBA_I	ldsba	[%r16, + 0x09ed] %asi, %r26
	.word 0xcc04283c  ! 1: LDUW_I	lduw	[%r16 + 0x083c], %r6
	.word 0xf8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r28
	.word 0xd0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r8
	.word 0xd4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r10
	.word 0xfc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r30
	.word 0xd4cc2d6a  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d6a] %asi, %r10
	.word 0xf0942f28  ! 1: LDUHA_I	lduha	[%r16, + 0x0f28] %asi, %r24
	.word 0xf48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r26
	.word 0xf0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r24
	brnz %r31,thr3_loop_cnt_254
	dec %r31
        mov 0x25, %r31
thr3_loop_cnt_255:
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	.word 0xc68c21b0  ! 1: LDUBA_I	lduba	[%r16, + 0x01b0] %asi, %r3
	.word 0xf0d42466  ! 1: LDSHA_I	ldsha	[%r16, + 0x0466] %asi, %r24
	.word 0xc6042674  ! 1: LDUW_I	lduw	[%r16 + 0x0674], %r3
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xe68c27d7  ! 1: LDUBA_I	lduba	[%r16, + 0x07d7] %asi, %r19
	.word 0xe4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r18
	.word 0xda542788  ! 1: LDSH_I	ldsh	[%r16 + 0x0788], %r13
	.word 0xdcdc22e8  ! 1: LDXA_I	ldxa	[%r16, + 0x02e8] %asi, %r14
	.word 0xe2142930  ! 1: LDUH_I	lduh	[%r16 + 0x0930], %r17
	.word 0xde841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r15
	brnz %r31,thr3_loop_cnt_255
	dec %r31
	.word 0xa4140002  ! 1: OR_R	or 	%r16, %r2, %r18
	.word 0xa32c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r17
        mov 0xba, %r31
thr3_loop_cnt_256:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2775  ! 1: LDSBA_I	ldsba	[%r16, + 0x0775] %asi, %r3
	.word 0xc684250c  ! 1: LDUWA_I	lduwa	[%r16, + 0x050c] %asi, %r3
	.word 0xf68c2728  ! 1: LDUBA_I	lduba	[%r16, + 0x0728] %asi, %r27
	.word 0xd48425b4  ! 1: LDUWA_I	lduwa	[%r16, + 0x05b4] %asi, %r10
	.word 0xf6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r27
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r8
	.word 0xeed41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r23
	.word 0xee4422ec  ! 1: LDSW_I	ldsw	[%r16 + 0x02ec], %r23
	brnz %r31,thr3_loop_cnt_256
	dec %r31
        mov 0x20, %r31
thr3_loop_cnt_257:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6d429a6  ! 1: LDSHA_I	ldsha	[%r16, + 0x09a6] %asi, %r3
	.word 0xc68c2d15  ! 1: LDUBA_I	lduba	[%r16, + 0x0d15] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xdedc2840  ! 1: LDXA_I	ldxa	[%r16, + 0x0840] %asi, %r15
	brnz %r31,thr3_loop_cnt_257
	dec %r31
        mov 0x49, %r31
thr3_loop_cnt_258:
	.word 0xc6042784  ! 1: LDUW_I	lduw	[%r16 + 0x0784], %r3
	.word 0xf6d421f6  ! 1: LDSHA_I	ldsha	[%r16, + 0x01f6] %asi, %r27
	.word 0xc6dc2a80  ! 1: LDXA_I	ldxa	[%r16, + 0x0a80] %asi, %r3
	.word 0xde5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r15
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xea540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r21
	.word 0xde841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r15
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xd4d42e1e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e1e] %asi, %r10
	.word 0xf28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r25
	.word 0xc604205c  ! 1: LDUW_I	lduw	[%r16 + 0x005c], %r3
	brnz %r31,thr3_loop_cnt_258
	dec %r31
	.word 0xa92c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r20
	.word 0x973c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r11
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0xa434221a  ! 1: SUBC_I	orn 	%r16, 0x021a, %r18
        mov 0x62, %r31
thr3_loop_cnt_259:
	.word 0xfa0c2650  ! 1: LDUB_I	ldub	[%r16 + 0x0650], %r29
	.word 0xdc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r14
	.word 0xd41426a8  ! 1: LDUH_I	lduh	[%r16 + 0x06a8], %r10
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2590  ! 1: LDXA_I	ldxa	[%r16, + 0x0590] %asi, %r3
	.word 0xf2d4291a  ! 1: LDSHA_I	ldsha	[%r16, + 0x091a] %asi, %r25
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xdac42d08  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d08] %asi, %r13
	.word 0xee442b6c  ! 1: LDSW_I	ldsw	[%r16 + 0x0b6c], %r23
	brnz %r31,thr3_loop_cnt_259
	dec %r31
        mov 0xbe, %r31
thr3_loop_cnt_260:
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xfa4426bc  ! 1: LDSW_I	ldsw	[%r16 + 0x06bc], %r29
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6c42fb0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0fb0] %asi, %r3
	.word 0xccd42fc2  ! 1: LDSHA_I	ldsha	[%r16, + 0x0fc2] %asi, %r6
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xfc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r30
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_260
	dec %r31
	.word 0xba2c2146  ! 1: ANDN_I	andn 	%r16, 0x0146, %r29
        mov 0x28, %r31
thr3_loop_cnt_261:
	.word 0xc64c2d6f  ! 1: LDSB_I	ldsb	[%r16 + 0x0d6f], %r3
	.word 0xee540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r23
	.word 0xfc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r30
	.word 0xf64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r27
	.word 0xcc9422ba  ! 1: LDUHA_I	lduha	[%r16, + 0x02ba] %asi, %r6
	.word 0xda5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r13
	.word 0xc64428a4  ! 1: LDSW_I	ldsw	[%r16 + 0x08a4], %r3
	.word 0xc6142f82  ! 1: LDUH_I	lduh	[%r16 + 0x0f82], %r3
	.word 0xc65c20c0  ! 1: LDX_I	ldx	[%r16 + 0x00c0], %r3
	.word 0xf40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r26
	.word 0xcc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r6
	brnz %r31,thr3_loop_cnt_261
	dec %r31
	.word 0x98040002  ! 1: ADD_R	add 	%r16, %r2, %r12
	.word 0x863c2331  ! 1: XNOR_I	xnor 	%r16, 0x0331, %r3
	.word 0x922c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r9
        mov 0x67, %r31
thr3_loop_cnt_262:
	.word 0xfa8c2379  ! 1: LDUBA_I	lduba	[%r16, + 0x0379] %asi, %r29
	.word 0xeccc24c0  ! 1: LDSBA_I	ldsba	[%r16, + 0x04c0] %asi, %r22
	.word 0xdc542cb2  ! 1: LDSH_I	ldsh	[%r16 + 0x0cb2], %r14
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xc6d42e9a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e9a] %asi, %r3
	.word 0xc6cc2462  ! 1: LDSBA_I	ldsba	[%r16, + 0x0462] %asi, %r3
	.word 0xc6c42f88  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f88] %asi, %r3
	.word 0xc604256c  ! 1: LDUW_I	lduw	[%r16 + 0x056c], %r3
	brnz %r31,thr3_loop_cnt_262
	dec %r31
	.word 0x9f341002  ! 1: SRLX_R	srlx	%r16, %r2, %r15
	.word 0x9c140002  ! 1: OR_R	or 	%r16, %r2, %r14
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0xc1, %r31
thr3_loop_cnt_263:
	.word 0xc60c29cd  ! 1: LDUB_I	ldub	[%r16 + 0x09cd], %r3
	.word 0xd4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r10
	.word 0xf6942b6a  ! 1: LDUHA_I	lduha	[%r16, + 0x0b6a] %asi, %r27
	.word 0xeecc25c1  ! 1: LDSBA_I	ldsba	[%r16, + 0x05c1] %asi, %r23
	.word 0xc6d42ece  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ece] %asi, %r3
	.word 0xc6142246  ! 1: LDUH_I	lduh	[%r16 + 0x0246], %r3
	.word 0xc6942976  ! 1: LDUHA_I	lduha	[%r16, + 0x0976] %asi, %r3
	.word 0xd0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r8
	.word 0xfc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r30
	.word 0xf28425a8  ! 1: LDUWA_I	lduwa	[%r16, + 0x05a8] %asi, %r25
	brnz %r31,thr3_loop_cnt_263
	dec %r31
	.word 0x8c042cbc  ! 1: ADD_I	add 	%r16, 0x0cbc, %r6
	.word 0x9c240002  ! 1: SUB_R	sub 	%r16, %r2, %r14
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x4f, %r31
thr3_loop_cnt_264:
	.word 0xde9423e8  ! 1: LDUHA_I	lduha	[%r16, + 0x03e8] %asi, %r15
	.word 0xd48c23db  ! 1: LDUBA_I	lduba	[%r16, + 0x03db] %asi, %r10
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd00c2e01  ! 1: LDUB_I	ldub	[%r16 + 0x0e01], %r8
	.word 0xe68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r19
	.word 0xf8c4231c  ! 1: LDSWA_I	ldswa	[%r16, + 0x031c] %asi, %r28
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xc61428ac  ! 1: LDUH_I	lduh	[%r16 + 0x08ac], %r3
	.word 0xcc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r6
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe84c2013  ! 1: LDSB_I	ldsb	[%r16 + 0x0013], %r20
	brnz %r31,thr3_loop_cnt_264
	dec %r31
	.word 0x860c2c35  ! 1: AND_I	and 	%r16, 0x0c35, %r3
        mov 0x5d, %r31
thr3_loop_cnt_265:
	.word 0xd04c2cc9  ! 1: LDSB_I	ldsb	[%r16 + 0x0cc9], %r8
	.word 0xea142b56  ! 1: LDUH_I	lduh	[%r16 + 0x0b56], %r21
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc68c264a  ! 1: LDUBA_I	lduba	[%r16, + 0x064a] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xdc042f44  ! 1: LDUW_I	lduw	[%r16 + 0x0f44], %r14
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xccc42744  ! 1: LDSWA_I	ldswa	[%r16, + 0x0744] %asi, %r6
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	.word 0xe45c2e38  ! 1: LDX_I	ldx	[%r16 + 0x0e38], %r18
	brnz %r31,thr3_loop_cnt_265
	dec %r31
	.word 0x8c3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r6
        mov 0xbd, %r31
thr3_loop_cnt_266:
	.word 0xc6c42294  ! 1: LDSWA_I	ldswa	[%r16, + 0x0294] %asi, %r3
	.word 0xced41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r7
	.word 0xfc5423f8  ! 1: LDSH_I	ldsh	[%r16 + 0x03f8], %r30
	.word 0xf814230c  ! 1: LDUH_I	lduh	[%r16 + 0x030c], %r28
	.word 0xfc8426c4  ! 1: LDUWA_I	lduwa	[%r16, + 0x06c4] %asi, %r30
	.word 0xe21426ce  ! 1: LDUH_I	lduh	[%r16 + 0x06ce], %r17
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xdc5c2dc0  ! 1: LDX_I	ldx	[%r16 + 0x0dc0], %r14
	brnz %r31,thr3_loop_cnt_266
	dec %r31
	.word 0xbc142cd1  ! 1: OR_I	or 	%r16, 0x0cd1, %r30
        mov 0x70, %r31
thr3_loop_cnt_267:
	.word 0xc68c2736  ! 1: LDUBA_I	lduba	[%r16, + 0x0736] %asi, %r3
	.word 0xda94218c  ! 1: LDUHA_I	lduha	[%r16, + 0x018c] %asi, %r13
	.word 0xe4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r18
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r18
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xde0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r15
	.word 0xd2442984  ! 1: LDSW_I	ldsw	[%r16 + 0x0984], %r9
	.word 0xe2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r17
	.word 0xdcdc24d8  ! 1: LDXA_I	ldxa	[%r16, + 0x04d8] %asi, %r14
	.word 0xc60c2133  ! 1: LDUB_I	ldub	[%r16 + 0x0133], %r3
	brnz %r31,thr3_loop_cnt_267
	dec %r31
	.word 0x9c1c2551  ! 1: XOR_I	xor 	%r16, 0x0551, %r14
        mov 0x6f, %r31
thr3_loop_cnt_268:
	.word 0xc6542e0a  ! 1: LDSH_I	ldsh	[%r16 + 0x0e0a], %r3
	.word 0xc60c2b50  ! 1: LDUB_I	ldub	[%r16 + 0x0b50], %r3
	.word 0xf65424e2  ! 1: LDSH_I	ldsh	[%r16 + 0x04e2], %r27
	.word 0xc68420c8  ! 1: LDUWA_I	lduwa	[%r16, + 0x00c8] %asi, %r3
	.word 0xc65c2348  ! 1: LDX_I	ldx	[%r16 + 0x0348], %r3
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc64c2167  ! 1: LDSB_I	ldsb	[%r16 + 0x0167], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xfc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r30
	.word 0xc6042ff8  ! 1: LDUW_I	lduw	[%r16 + 0x0ff8], %r3
	brnz %r31,thr3_loop_cnt_268
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x9f3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r15
	.word 0x860c2ba8  ! 1: AND_I	and 	%r16, 0x0ba8, %r3
        mov 0x76, %r31
thr3_loop_cnt_269:
	.word 0xd0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r8
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc65c2078  ! 1: LDX_I	ldx	[%r16 + 0x0078], %r3
	.word 0xd2cc242d  ! 1: LDSBA_I	ldsba	[%r16, + 0x042d] %asi, %r9
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf0d427b2  ! 1: LDSHA_I	ldsha	[%r16, + 0x07b2] %asi, %r24
	.word 0xf25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r25
	.word 0xc6842168  ! 1: LDUWA_I	lduwa	[%r16, + 0x0168] %asi, %r3
	.word 0xe2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r17
	.word 0xf0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r24
	.word 0xe6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r19
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_269
	dec %r31
	.word 0x860428ed  ! 1: ADD_I	add 	%r16, 0x08ed, %r3
	.word 0xa6340002  ! 1: SUBC_R	orn 	%r16, %r2, %r19
        mov 0x62, %r31
thr3_loop_cnt_270:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xfa9427a2  ! 1: LDUHA_I	lduha	[%r16, + 0x07a2] %asi, %r29
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r28
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xea0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r21
	.word 0xc6842334  ! 1: LDUWA_I	lduwa	[%r16, + 0x0334] %asi, %r3
	.word 0xe8042a24  ! 1: LDUW_I	lduw	[%r16 + 0x0a24], %r20
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_270
	dec %r31
	.word 0x96442a6d  ! 1: ADDC_I	addc 	%r16, 0x0a6d, %r11
        mov 0x38, %r31
thr3_loop_cnt_271:
	.word 0xcccc2332  ! 1: LDSBA_I	ldsba	[%r16, + 0x0332] %asi, %r6
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf4c42108  ! 1: LDSWA_I	ldswa	[%r16, + 0x0108] %asi, %r26
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r9
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xccc421b0  ! 1: LDSWA_I	ldswa	[%r16, + 0x01b0] %asi, %r6
	.word 0xec142cda  ! 1: LDUH_I	lduh	[%r16 + 0x0cda], %r22
	.word 0xc69426d0  ! 1: LDUHA_I	lduha	[%r16, + 0x06d0] %asi, %r3
	.word 0xc6942a2e  ! 1: LDUHA_I	lduha	[%r16, + 0x0a2e] %asi, %r3
	brnz %r31,thr3_loop_cnt_271
	dec %r31
        mov 0xaa, %r31
thr3_loop_cnt_272:
	.word 0xf65c2b48  ! 1: LDX_I	ldx	[%r16 + 0x0b48], %r27
	.word 0xc64c2bc5  ! 1: LDSB_I	ldsb	[%r16 + 0x0bc5], %r3
	.word 0xd05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r8
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf6042648  ! 1: LDUW_I	lduw	[%r16 + 0x0648], %r27
	.word 0xfadc2850  ! 1: LDXA_I	ldxa	[%r16, + 0x0850] %asi, %r29
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6042548  ! 1: LDUW_I	lduw	[%r16 + 0x0548], %r3
	brnz %r31,thr3_loop_cnt_272
	dec %r31
	.word 0xb02c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r24
	.word 0x92042502  ! 1: ADD_I	add 	%r16, 0x0502, %r9
        mov 0x2e, %r31
thr3_loop_cnt_273:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xeccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r22
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xea941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r21
	.word 0xc60c224f  ! 1: LDUB_I	ldub	[%r16 + 0x024f], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6c42e64  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e64] %asi, %r3
	.word 0xd2dc2b18  ! 1: LDXA_I	ldxa	[%r16, + 0x0b18] %asi, %r9
	.word 0xe6142900  ! 1: LDUH_I	lduh	[%r16 + 0x0900], %r19
	brnz %r31,thr3_loop_cnt_273
	dec %r31
	.word 0xa63c25e6  ! 1: XNOR_I	xnor 	%r16, 0x05e6, %r19
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0x90, %r31
thr3_loop_cnt_274:
	.word 0xc6dc2e18  ! 1: LDXA_I	ldxa	[%r16, + 0x0e18] %asi, %r3
	.word 0xf88c22db  ! 1: LDUBA_I	lduba	[%r16, + 0x02db] %asi, %r28
	.word 0xe68425e8  ! 1: LDUWA_I	lduwa	[%r16, + 0x05e8] %asi, %r19
	.word 0xc6c4220c  ! 1: LDSWA_I	ldswa	[%r16, + 0x020c] %asi, %r3
	.word 0xc6142f40  ! 1: LDUH_I	lduh	[%r16 + 0x0f40], %r3
	.word 0xc60c2cc5  ! 1: LDUB_I	ldub	[%r16 + 0x0cc5], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc68c2e02  ! 1: LDUBA_I	lduba	[%r16, + 0x0e02] %asi, %r3
	.word 0xf0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r24
	brnz %r31,thr3_loop_cnt_274
	dec %r31
	.word 0x860c248d  ! 1: AND_I	and 	%r16, 0x048d, %r3
	.word 0xa2440002  ! 1: ADDC_R	addc 	%r16, %r2, %r17
	.word 0xb8340002  ! 1: ORN_R	orn 	%r16, %r2, %r28
	.word 0x900420dd  ! 1: ADD_I	add 	%r16, 0x00dd, %r8
        mov 0x1f, %r31
thr3_loop_cnt_275:
	.word 0xfc142254  ! 1: LDUH_I	lduh	[%r16 + 0x0254], %r30
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r24
	.word 0xfc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r30
	.word 0xc6542038  ! 1: LDSH_I	ldsh	[%r16 + 0x0038], %r3
	.word 0xc6842838  ! 1: LDUWA_I	lduwa	[%r16, + 0x0838] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd84c2493  ! 1: LDSB_I	ldsb	[%r16 + 0x0493], %r12
	brnz %r31,thr3_loop_cnt_275
	dec %r31
        mov 0x48, %r31
thr3_loop_cnt_276:
	.word 0xc68c2c6c  ! 1: LDUBA_I	lduba	[%r16, + 0x0c6c] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc61428e4  ! 1: LDUH_I	lduh	[%r16 + 0x08e4], %r3
	.word 0xe6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r19
	.word 0xd8142c66  ! 1: LDUH_I	lduh	[%r16 + 0x0c66], %r12
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c24ae  ! 1: LDSB_I	ldsb	[%r16 + 0x04ae], %r3
	.word 0xe4542eca  ! 1: LDSH_I	ldsh	[%r16 + 0x0eca], %r18
	.word 0xd4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r10
	brnz %r31,thr3_loop_cnt_276
	dec %r31
        mov 0x34, %r31
thr3_loop_cnt_277:
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xfa4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r29
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xc64c22ab  ! 1: LDSB_I	ldsb	[%r16 + 0x02ab], %r3
	brnz %r31,thr3_loop_cnt_277
	dec %r31
	.word 0xbd2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r30
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x7, %r31
thr3_loop_cnt_278:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xea8427c8  ! 1: LDUWA_I	lduwa	[%r16, + 0x07c8] %asi, %r21
	.word 0xe65428e8  ! 1: LDSH_I	ldsh	[%r16 + 0x08e8], %r19
	.word 0xe61429ac  ! 1: LDUH_I	lduh	[%r16 + 0x09ac], %r19
	.word 0xc6942c28  ! 1: LDUHA_I	lduha	[%r16, + 0x0c28] %asi, %r3
	.word 0xe2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r17
	.word 0xfcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r30
	.word 0xc6cc293b  ! 1: LDSBA_I	ldsba	[%r16, + 0x093b] %asi, %r3
	.word 0xd8042630  ! 1: LDUW_I	lduw	[%r16 + 0x0630], %r12
	.word 0xdecc2d01  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d01] %asi, %r15
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	brnz %r31,thr3_loop_cnt_278
	dec %r31
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x94442a86  ! 1: ADDC_I	addc 	%r16, 0x0a86, %r10
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0xc, %r31
thr3_loop_cnt_279:
	.word 0xfa440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r29
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xcc042278  ! 1: LDUW_I	lduw	[%r16 + 0x0278], %r6
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd2d42b9c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b9c] %asi, %r9
	.word 0xccdc23d0  ! 1: LDXA_I	ldxa	[%r16, + 0x03d0] %asi, %r6
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6d4271e  ! 1: LDSHA_I	ldsha	[%r16, + 0x071e] %asi, %r3
	.word 0xf60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r27
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_279
	dec %r31
        mov 0x1b, %r31
thr3_loop_cnt_280:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r11
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc644240c  ! 1: LDSW_I	ldsw	[%r16 + 0x040c], %r3
	.word 0xd644297c  ! 1: LDSW_I	ldsw	[%r16 + 0x097c], %r11
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe64c2529  ! 1: LDSB_I	ldsb	[%r16 + 0x0529], %r19
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r9
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc65c2d40  ! 1: LDX_I	ldx	[%r16 + 0x0d40], %r3
	.word 0xcc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r6
	brnz %r31,thr3_loop_cnt_280
	dec %r31
        mov 0x4a, %r31
thr3_loop_cnt_281:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r18
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xc6142034  ! 1: LDUH_I	lduh	[%r16 + 0x0034], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xea440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r21
	.word 0xf05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r24
	.word 0xcc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r6
	.word 0xec4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r22
	brnz %r31,thr3_loop_cnt_281
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x863c264c  ! 1: XNOR_I	xnor 	%r16, 0x064c, %r3
	.word 0x91342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r8
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x93, %r31
thr3_loop_cnt_282:
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xd8d425c6  ! 1: LDSHA_I	ldsha	[%r16, + 0x05c6] %asi, %r12
	.word 0xc6942778  ! 1: LDUHA_I	lduha	[%r16, + 0x0778] %asi, %r3
	.word 0xd0942290  ! 1: LDUHA_I	lduha	[%r16, + 0x0290] %asi, %r8
	.word 0xd65422ae  ! 1: LDSH_I	ldsh	[%r16 + 0x02ae], %r11
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc68c2a58  ! 1: LDUBA_I	lduba	[%r16, + 0x0a58] %asi, %r3
	.word 0xc6842598  ! 1: LDUWA_I	lduwa	[%r16, + 0x0598] %asi, %r3
	brnz %r31,thr3_loop_cnt_282
	dec %r31
        mov 0x1c, %r31
thr3_loop_cnt_283:
	.word 0xc68c24ab  ! 1: LDUBA_I	lduba	[%r16, + 0x04ab] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd44420bc  ! 1: LDSW_I	ldsw	[%r16 + 0x00bc], %r10
	.word 0xc6042b5c  ! 1: LDUW_I	lduw	[%r16 + 0x0b5c], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd8142ca2  ! 1: LDUH_I	lduh	[%r16 + 0x0ca2], %r12
	.word 0xe60c228c  ! 1: LDUB_I	ldub	[%r16 + 0x028c], %r19
	.word 0xf88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r28
	.word 0xc65c2c28  ! 1: LDX_I	ldx	[%r16 + 0x0c28], %r3
	brnz %r31,thr3_loop_cnt_283
	dec %r31
	.word 0x9a042cc6  ! 1: ADD_I	add 	%r16, 0x0cc6, %r13
	.word 0x863c2d5f  ! 1: XNOR_I	xnor 	%r16, 0x0d5f, %r3
        mov 0x59, %r31
thr3_loop_cnt_284:
	.word 0xf0442014  ! 1: LDSW_I	ldsw	[%r16 + 0x0014], %r24
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2330  ! 1: LDXA_I	ldxa	[%r16, + 0x0330] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6542408  ! 1: LDSH_I	ldsh	[%r16 + 0x0408], %r3
	.word 0xc6dc22c8  ! 1: LDXA_I	ldxa	[%r16, + 0x02c8] %asi, %r3
	.word 0xf6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r27
	.word 0xc6c42fb4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0fb4] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc60c2bbc  ! 1: LDUB_I	ldub	[%r16 + 0x0bbc], %r3
	.word 0xd65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r11
	brnz %r31,thr3_loop_cnt_284
	dec %r31
	.word 0xa23425d7  ! 1: SUBC_I	orn 	%r16, 0x05d7, %r17
        mov 0x33, %r31
thr3_loop_cnt_285:
	.word 0xde0c23ee  ! 1: LDUB_I	ldub	[%r16 + 0x03ee], %r15
	.word 0xc61429a0  ! 1: LDUH_I	lduh	[%r16 + 0x09a0], %r3
	.word 0xc6542cb4  ! 1: LDSH_I	ldsh	[%r16 + 0x0cb4], %r3
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	.word 0xd0cc2d67  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d67] %asi, %r8
	.word 0xd84c2144  ! 1: LDSB_I	ldsb	[%r16 + 0x0144], %r12
	.word 0xd2842058  ! 1: LDUWA_I	lduwa	[%r16, + 0x0058] %asi, %r9
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	.word 0xe80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r20
	brnz %r31,thr3_loop_cnt_285
	dec %r31
        mov 0x36, %r31
thr3_loop_cnt_286:
	.word 0xf2942fe0  ! 1: LDUHA_I	lduha	[%r16, + 0x0fe0] %asi, %r25
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xde5421a2  ! 1: LDSH_I	ldsh	[%r16 + 0x01a2], %r15
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc604276c  ! 1: LDUW_I	lduw	[%r16 + 0x076c], %r3
	.word 0xc64c298e  ! 1: LDSB_I	ldsb	[%r16 + 0x098e], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc65c26c8  ! 1: LDX_I	ldx	[%r16 + 0x06c8], %r3
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	brnz %r31,thr3_loop_cnt_286
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x45, %r31
thr3_loop_cnt_287:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2578  ! 1: LDXA_I	ldxa	[%r16, + 0x0578] %asi, %r3
	.word 0xc6d42d94  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d94] %asi, %r3
	.word 0xccc42320  ! 1: LDSWA_I	ldswa	[%r16, + 0x0320] %asi, %r6
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xea841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r21
	.word 0xe4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r18
	.word 0xf4dc2a20  ! 1: LDXA_I	ldxa	[%r16, + 0x0a20] %asi, %r26
	.word 0xc6cc21bb  ! 1: LDSBA_I	ldsba	[%r16, + 0x01bb] %asi, %r3
	.word 0xc64c2a2f  ! 1: LDSB_I	ldsb	[%r16 + 0x0a2f], %r3
	brnz %r31,thr3_loop_cnt_287
	dec %r31
        mov 0x65, %r31
thr3_loop_cnt_288:
	.word 0xe44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r18
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	.word 0xc6942f36  ! 1: LDUHA_I	lduha	[%r16, + 0x0f36] %asi, %r3
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	.word 0xee4429a8  ! 1: LDSW_I	ldsw	[%r16 + 0x09a8], %r23
	.word 0xeacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r21
	.word 0xdc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r14
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc64c2b89  ! 1: LDSB_I	ldsb	[%r16 + 0x0b89], %r3
	.word 0xcc4c2028  ! 1: LDSB_I	ldsb	[%r16 + 0x0028], %r6
	.word 0xf0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r24
	brnz %r31,thr3_loop_cnt_288
	dec %r31
	.word 0xb41c2add  ! 1: XOR_I	xor 	%r16, 0x0add, %r26
	.word 0x9e242ed5  ! 1: SUB_I	sub 	%r16, 0x0ed5, %r15
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0x73, %r31
thr3_loop_cnt_289:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r25
	.word 0xc6c4200c  ! 1: LDSWA_I	ldswa	[%r16, + 0x000c] %asi, %r3
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd4c4206c  ! 1: LDSWA_I	ldswa	[%r16, + 0x006c] %asi, %r10
	.word 0xd6d42714  ! 1: LDSHA_I	ldsha	[%r16, + 0x0714] %asi, %r11
	brnz %r31,thr3_loop_cnt_289
	dec %r31
        mov 0x77, %r31
thr3_loop_cnt_290:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r17
	.word 0xc6c42184  ! 1: LDSWA_I	ldswa	[%r16, + 0x0184] %asi, %r3
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6d429b4  ! 1: LDSHA_I	ldsha	[%r16, + 0x09b4] %asi, %r3
	.word 0xfa5c2fa0  ! 1: LDX_I	ldx	[%r16 + 0x0fa0], %r29
	brnz %r31,thr3_loop_cnt_290
	dec %r31
	.word 0x9e3c23d5  ! 1: XNOR_I	xnor 	%r16, 0x03d5, %r15
	.word 0xa43c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r18
	.word 0x95343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r10
        mov 0xaf, %r31
thr3_loop_cnt_291:
	.word 0xc6dc22d8  ! 1: LDXA_I	ldxa	[%r16, + 0x02d8] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xfa540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r29
	.word 0xea8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r21
	.word 0xc6142e80  ! 1: LDUH_I	lduh	[%r16 + 0x0e80], %r3
	.word 0xde5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r15
	.word 0xc6542298  ! 1: LDSH_I	ldsh	[%r16 + 0x0298], %r3
	.word 0xd244242c  ! 1: LDSW_I	ldsw	[%r16 + 0x042c], %r9
	.word 0xf6dc2fd0  ! 1: LDXA_I	ldxa	[%r16, + 0x0fd0] %asi, %r27
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xf6cc2a35  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a35] %asi, %r27
	brnz %r31,thr3_loop_cnt_291
	dec %r31
        mov 0xab, %r31
thr3_loop_cnt_292:
	.word 0xc6c422fc  ! 1: LDSWA_I	ldswa	[%r16, + 0x02fc] %asi, %r3
	.word 0xfc5c2038  ! 1: LDX_I	ldx	[%r16 + 0x0038], %r30
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	.word 0xc6dc2d50  ! 1: LDXA_I	ldxa	[%r16, + 0x0d50] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xea5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r21
	.word 0xce842220  ! 1: LDUWA_I	lduwa	[%r16, + 0x0220] %asi, %r7
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r19
	.word 0xc65c2700  ! 1: LDX_I	ldx	[%r16 + 0x0700], %r3
	brnz %r31,thr3_loop_cnt_292
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x961c0002  ! 1: XOR_R	xor 	%r16, %r2, %r11
        mov 0x7e, %r31
thr3_loop_cnt_293:
	.word 0xfc442040  ! 1: LDSW_I	ldsw	[%r16 + 0x0040], %r30
	.word 0xf85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r28
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	.word 0xc6dc2688  ! 1: LDXA_I	ldxa	[%r16, + 0x0688] %asi, %r3
	.word 0xd4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r10
	.word 0xe8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r20
	.word 0xec542d10  ! 1: LDSH_I	ldsh	[%r16 + 0x0d10], %r22
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc654250e  ! 1: LDSH_I	ldsh	[%r16 + 0x050e], %r3
	.word 0xc64c2cc1  ! 1: LDSB_I	ldsb	[%r16 + 0x0cc1], %r3
	brnz %r31,thr3_loop_cnt_293
	dec %r31
	.word 0x923c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r9
	.word 0x8604265c  ! 1: ADD_I	add 	%r16, 0x065c, %r3
        mov 0x52, %r31
thr3_loop_cnt_294:
	.word 0xe8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r20
	.word 0xc654231a  ! 1: LDSH_I	ldsh	[%r16 + 0x031a], %r3
	.word 0xc64421b8  ! 1: LDSW_I	ldsw	[%r16 + 0x01b8], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r9
	.word 0xfacc2bee  ! 1: LDSBA_I	ldsba	[%r16, + 0x0bee] %asi, %r29
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd2442674  ! 1: LDSW_I	ldsw	[%r16 + 0x0674], %r9
	.word 0xdecc2e33  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e33] %asi, %r15
	.word 0xc6dc29a0  ! 1: LDXA_I	ldxa	[%r16, + 0x09a0] %asi, %r3
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	brnz %r31,thr3_loop_cnt_294
	dec %r31
	.word 0xa53c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r18
        mov 0xc3, %r31
thr3_loop_cnt_295:
	.word 0xeecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r23
	.word 0xc64c22cf  ! 1: LDSB_I	ldsb	[%r16 + 0x02cf], %r3
	.word 0xf8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r28
	.word 0xdecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r15
	.word 0xc65428d4  ! 1: LDSH_I	ldsh	[%r16 + 0x08d4], %r3
	.word 0xc6542acc  ! 1: LDSH_I	ldsh	[%r16 + 0x0acc], %r3
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xf69429ce  ! 1: LDUHA_I	lduha	[%r16, + 0x09ce] %asi, %r27
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xc68c245f  ! 1: LDUBA_I	lduba	[%r16, + 0x045f] %asi, %r3
	.word 0xfa5421e4  ! 1: LDSH_I	ldsh	[%r16 + 0x01e4], %r29
	.word 0xfa4429b8  ! 1: LDSW_I	ldsw	[%r16 + 0x09b8], %r29
	brnz %r31,thr3_loop_cnt_295
	dec %r31
	.word 0x8c1c0002  ! 1: XOR_R	xor 	%r16, %r2, %r6
        mov 0xbf, %r31
thr3_loop_cnt_296:
	.word 0xc6dc2eb8  ! 1: LDXA_I	ldxa	[%r16, + 0x0eb8] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r12
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xcec42828  ! 1: LDSWA_I	ldswa	[%r16, + 0x0828] %asi, %r7
	.word 0xc6442f0c  ! 1: LDSW_I	ldsw	[%r16 + 0x0f0c], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd4d42ca6  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ca6] %asi, %r10
	brnz %r31,thr3_loop_cnt_296
	dec %r31
        mov 0x13, %r31
thr3_loop_cnt_297:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xee4c27bb  ! 1: LDSB_I	ldsb	[%r16 + 0x07bb], %r23
	.word 0xe2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r17
	.word 0xf8542ffc  ! 1: LDSH_I	ldsh	[%r16 + 0x0ffc], %r28
	.word 0xc6042a48  ! 1: LDUW_I	lduw	[%r16 + 0x0a48], %r3
	.word 0xeadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r21
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_297
	dec %r31
        mov 0x34, %r31
thr3_loop_cnt_298:
	.word 0xf6dc25b8  ! 1: LDXA_I	ldxa	[%r16, + 0x05b8] %asi, %r27
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r26
	.word 0xc6542af2  ! 1: LDSH_I	ldsh	[%r16 + 0x0af2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xdc5426de  ! 1: LDSH_I	ldsh	[%r16 + 0x06de], %r14
	.word 0xda4c278c  ! 1: LDSB_I	ldsb	[%r16 + 0x078c], %r13
	.word 0xfad420c6  ! 1: LDSHA_I	ldsha	[%r16, + 0x00c6] %asi, %r29
	.word 0xe61421a2  ! 1: LDUH_I	lduh	[%r16 + 0x01a2], %r19
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r10
	.word 0xf68c2f7b  ! 1: LDUBA_I	lduba	[%r16, + 0x0f7b] %asi, %r27
	brnz %r31,thr3_loop_cnt_298
	dec %r31
	.word 0x862426a9  ! 1: SUB_I	sub 	%r16, 0x06a9, %r3
	.word 0x863c2b46  ! 1: XNOR_I	xnor 	%r16, 0x0b46, %r3
	.word 0x8d340002  ! 1: SRL_R	srl 	%r16, %r2, %r6
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x21, %r31
thr3_loop_cnt_299:
	.word 0xc6442d90  ! 1: LDSW_I	ldsw	[%r16 + 0x0d90], %r3
	.word 0xc6d420ee  ! 1: LDSHA_I	ldsha	[%r16, + 0x00ee] %asi, %r3
	.word 0xc65c2e00  ! 1: LDX_I	ldx	[%r16 + 0x0e00], %r3
	.word 0xc69423f8  ! 1: LDUHA_I	lduha	[%r16, + 0x03f8] %asi, %r3
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xe40429b8  ! 1: LDUW_I	lduw	[%r16 + 0x09b8], %r18
	.word 0xe2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r17
	.word 0xd8142b92  ! 1: LDUH_I	lduh	[%r16 + 0x0b92], %r12
	brnz %r31,thr3_loop_cnt_299
	dec %r31
	.word 0xbb340002  ! 1: SRL_R	srl 	%r16, %r2, %r29
        mov 0xae, %r31
thr3_loop_cnt_300:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xc6842110  ! 1: LDUWA_I	lduwa	[%r16, + 0x0110] %asi, %r3
	.word 0xc614227a  ! 1: LDUH_I	lduh	[%r16 + 0x027a], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc654208a  ! 1: LDSH_I	ldsh	[%r16 + 0x008a], %r3
	.word 0xc6042dcc  ! 1: LDUW_I	lduw	[%r16 + 0x0dcc], %r3
	.word 0xc604290c  ! 1: LDUW_I	lduw	[%r16 + 0x090c], %r3
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	brnz %r31,thr3_loop_cnt_300
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x96342814  ! 1: ORN_I	orn 	%r16, 0x0814, %r11
	.word 0x9f2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r15
        mov 0x71, %r31
thr3_loop_cnt_301:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xea440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r21
	.word 0xc654271e  ! 1: LDSH_I	ldsh	[%r16 + 0x071e], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xeadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r21
	.word 0xc60c2156  ! 1: LDUB_I	ldub	[%r16 + 0x0156], %r3
	.word 0xc60424b4  ! 1: LDUW_I	lduw	[%r16 + 0x04b4], %r3
	.word 0xf8142be6  ! 1: LDUH_I	lduh	[%r16 + 0x0be6], %r28
	.word 0xfa042380  ! 1: LDUW_I	lduw	[%r16 + 0x0380], %r29
	.word 0xc694291a  ! 1: LDUHA_I	lduha	[%r16, + 0x091a] %asi, %r3
	brnz %r31,thr3_loop_cnt_301
	dec %r31
        mov 0x79, %r31
thr3_loop_cnt_302:
	.word 0xeadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r21
	.word 0xfc042280  ! 1: LDUW_I	lduw	[%r16 + 0x0280], %r30
	.word 0xc61429b8  ! 1: LDUH_I	lduh	[%r16 + 0x09b8], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xfa0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r29
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xce5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r7
	brnz %r31,thr3_loop_cnt_302
	dec %r31
	.word 0x992c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r12
	.word 0x860422d7  ! 1: ADD_I	add 	%r16, 0x02d7, %r3
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x5, %r31
thr3_loop_cnt_303:
	.word 0xd294252a  ! 1: LDUHA_I	lduha	[%r16, + 0x052a] %asi, %r9
	.word 0xf8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r28
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r19
	.word 0xc6842300  ! 1: LDUWA_I	lduwa	[%r16, + 0x0300] %asi, %r3
	.word 0xc6542a4a  ! 1: LDSH_I	ldsh	[%r16 + 0x0a4a], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd45c2fd8  ! 1: LDX_I	ldx	[%r16 + 0x0fd8], %r10
	.word 0xeac42cd4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0cd4] %asi, %r21
	.word 0xec540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r22
	.word 0xf0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r24
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_303
	dec %r31
	.word 0x86342e92  ! 1: SUBC_I	orn 	%r16, 0x0e92, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x3b, %r31
thr3_loop_cnt_304:
	.word 0xf4cc2e63  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e63] %asi, %r26
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc68c2d37  ! 1: LDUBA_I	lduba	[%r16, + 0x0d37] %asi, %r3
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xd8cc2dd6  ! 1: LDSBA_I	ldsba	[%r16, + 0x0dd6] %asi, %r12
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xcc4c234b  ! 1: LDSB_I	ldsb	[%r16 + 0x034b], %r6
	brnz %r31,thr3_loop_cnt_304
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x93340002  ! 1: SRL_R	srl 	%r16, %r2, %r9
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0xc1, %r31
thr3_loop_cnt_305:
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r17
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xcccc256f  ! 1: LDSBA_I	ldsba	[%r16, + 0x056f] %asi, %r6
	.word 0xec942644  ! 1: LDUHA_I	lduha	[%r16, + 0x0644] %asi, %r22
	.word 0xf0042260  ! 1: LDUW_I	lduw	[%r16 + 0x0260], %r24
	.word 0xd4d42ae4  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ae4] %asi, %r10
	.word 0xf89421e4  ! 1: LDUHA_I	lduha	[%r16, + 0x01e4] %asi, %r28
	brnz %r31,thr3_loop_cnt_305
	dec %r31
	.word 0xb41420b7  ! 1: OR_I	or 	%r16, 0x00b7, %r26
        mov 0x5, %r31
thr3_loop_cnt_306:
	.word 0xc6d42934  ! 1: LDSHA_I	ldsha	[%r16, + 0x0934] %asi, %r3
	.word 0xf2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r25
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	.word 0xee142258  ! 1: LDUH_I	lduh	[%r16 + 0x0258], %r23
	.word 0xd25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r9
	.word 0xee0c2045  ! 1: LDUB_I	ldub	[%r16 + 0x0045], %r23
	.word 0xd8cc20c8  ! 1: LDSBA_I	ldsba	[%r16, + 0x00c8] %asi, %r12
	.word 0xc654210a  ! 1: LDSH_I	ldsh	[%r16 + 0x010a], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xee0428d8  ! 1: LDUW_I	lduw	[%r16 + 0x08d8], %r23
	.word 0xe8cc21db  ! 1: LDSBA_I	ldsba	[%r16, + 0x01db] %asi, %r20
	brnz %r31,thr3_loop_cnt_306
	dec %r31
	.word 0x86442808  ! 1: ADDC_I	addc 	%r16, 0x0808, %r3
	.word 0x863425e4  ! 1: SUBC_I	orn 	%r16, 0x05e4, %r3
	.word 0xb6340002  ! 1: ORN_R	orn 	%r16, %r2, %r27
        mov 0x31, %r31
thr3_loop_cnt_307:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc65c21b8  ! 1: LDX_I	ldx	[%r16 + 0x01b8], %r3
	.word 0xc68c2ce2  ! 1: LDUBA_I	lduba	[%r16, + 0x0ce2] %asi, %r3
	.word 0xe8442c4c  ! 1: LDSW_I	ldsw	[%r16 + 0x0c4c], %r20
	.word 0xd8142ff0  ! 1: LDUH_I	lduh	[%r16 + 0x0ff0], %r12
	.word 0xced4213a  ! 1: LDSHA_I	ldsha	[%r16, + 0x013a] %asi, %r7
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_307
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0xba0c0002  ! 1: AND_R	and 	%r16, %r2, %r29
        mov 0x6b, %r31
thr3_loop_cnt_308:
	.word 0xe24429ec  ! 1: LDSW_I	ldsw	[%r16 + 0x09ec], %r17
	.word 0xd0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r8
	.word 0xea540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r21
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc65425b4  ! 1: LDSH_I	ldsh	[%r16 + 0x05b4], %r3
	.word 0xde4c219e  ! 1: LDSB_I	ldsb	[%r16 + 0x019e], %r15
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d421de  ! 1: LDSHA_I	ldsha	[%r16, + 0x01de] %asi, %r3
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xe8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r20
	brnz %r31,thr3_loop_cnt_308
	dec %r31
	.word 0x8d3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r6
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x36, %r31
thr3_loop_cnt_309:
	.word 0xf0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r24
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xdc4c2804  ! 1: LDSB_I	ldsb	[%r16 + 0x0804], %r14
	.word 0xc6942c0a  ! 1: LDUHA_I	lduha	[%r16, + 0x0c0a] %asi, %r3
	.word 0xc65422dc  ! 1: LDSH_I	ldsh	[%r16 + 0x02dc], %r3
	.word 0xc6c42dcc  ! 1: LDSWA_I	ldswa	[%r16, + 0x0dcc] %asi, %r3
	.word 0xc6c4269c  ! 1: LDSWA_I	ldswa	[%r16, + 0x069c] %asi, %r3
	.word 0xda44266c  ! 1: LDSW_I	ldsw	[%r16 + 0x066c], %r13
	.word 0xec042718  ! 1: LDUW_I	lduw	[%r16 + 0x0718], %r22
	.word 0xd4442ba8  ! 1: LDSW_I	ldsw	[%r16 + 0x0ba8], %r10
	brnz %r31,thr3_loop_cnt_309
	dec %r31
	.word 0xb72c0002  ! 1: SLL_R	sll 	%r16, %r2, %r27
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x90042ce1  ! 1: ADD_I	add 	%r16, 0x0ce1, %r8
	.word 0x93343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r9
        mov 0x32, %r31
thr3_loop_cnt_310:
	.word 0xc6c426ac  ! 1: LDSWA_I	ldswa	[%r16, + 0x06ac] %asi, %r3
	.word 0xf40426a0  ! 1: LDUW_I	lduw	[%r16 + 0x06a0], %r26
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xc6042fc0  ! 1: LDUW_I	lduw	[%r16 + 0x0fc0], %r3
	.word 0xdedc2280  ! 1: LDXA_I	ldxa	[%r16, + 0x0280] %asi, %r15
	.word 0xec4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r22
	.word 0xc6c42a28  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a28] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6042d20  ! 1: LDUW_I	lduw	[%r16 + 0x0d20], %r3
	.word 0xc6d42334  ! 1: LDSHA_I	ldsha	[%r16, + 0x0334] %asi, %r3
	.word 0xc6442464  ! 1: LDSW_I	ldsw	[%r16 + 0x0464], %r3
	brnz %r31,thr3_loop_cnt_310
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0xaa3c24e9  ! 1: XNOR_I	xnor 	%r16, 0x04e9, %r21
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0x83, %r31
thr3_loop_cnt_311:
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r27
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xee5c2920  ! 1: LDX_I	ldx	[%r16 + 0x0920], %r23
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	.word 0xf88c291e  ! 1: LDUBA_I	lduba	[%r16, + 0x091e] %asi, %r28
	.word 0xf0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r24
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_311
	dec %r31
	.word 0xb21c0002  ! 1: XOR_R	xor 	%r16, %r2, %r25
	.word 0xb0340002  ! 1: SUBC_R	orn 	%r16, %r2, %r24
	.word 0xba440002  ! 1: ADDC_R	addc 	%r16, %r2, %r29
        mov 0x70, %r31
thr3_loop_cnt_312:
	.word 0xcc442f38  ! 1: LDSW_I	ldsw	[%r16 + 0x0f38], %r6
	.word 0xc6dc2478  ! 1: LDXA_I	ldxa	[%r16, + 0x0478] %asi, %r3
	.word 0xecc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r22
	.word 0xea440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r21
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6442764  ! 1: LDSW_I	ldsw	[%r16 + 0x0764], %r3
	.word 0xe80c24e5  ! 1: LDUB_I	ldub	[%r16 + 0x04e5], %r20
	brnz %r31,thr3_loop_cnt_312
	dec %r31
	.word 0xbc2c2cc6  ! 1: ANDN_I	andn 	%r16, 0x0cc6, %r30
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0xb72c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r27
	.word 0xae1c0002  ! 1: XOR_R	xor 	%r16, %r2, %r23
        mov 0x41, %r31
thr3_loop_cnt_313:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xea941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r21
	.word 0xda942164  ! 1: LDUHA_I	lduha	[%r16, + 0x0164] %asi, %r13
	.word 0xf80c2bc8  ! 1: LDUB_I	ldub	[%r16 + 0x0bc8], %r28
	.word 0xc6cc2f08  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f08] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc282d  ! 1: LDSBA_I	ldsba	[%r16, + 0x082d] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_313
	dec %r31
        mov 0x21, %r31
thr3_loop_cnt_314:
	.word 0xdad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r13
	.word 0xee5c21c0  ! 1: LDX_I	ldx	[%r16 + 0x01c0], %r23
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc604212c  ! 1: LDUW_I	lduw	[%r16 + 0x012c], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6dc2310  ! 1: LDXA_I	ldxa	[%r16, + 0x0310] %asi, %r3
	.word 0xfadc2170  ! 1: LDXA_I	ldxa	[%r16, + 0x0170] %asi, %r29
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xda842328  ! 1: LDUWA_I	lduwa	[%r16, + 0x0328] %asi, %r13
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_314
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0xb93c1002  ! 1: SRAX_R	srax	%r16, %r2, %r28
        mov 0x3b, %r31
thr3_loop_cnt_315:
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xda841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r13
	.word 0xeec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r23
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r25
	.word 0xe2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r17
	.word 0xc61420cc  ! 1: LDUH_I	lduh	[%r16 + 0x00cc], %r3
	.word 0xf0842d1c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d1c] %asi, %r24
	.word 0xd0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r8
	.word 0xec841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r22
	brnz %r31,thr3_loop_cnt_315
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x9a0c2513  ! 1: AND_I	and 	%r16, 0x0513, %r13
        mov 0x27, %r31
thr3_loop_cnt_316:
	.word 0xc6842f34  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f34] %asi, %r3
	.word 0xc6dc2d70  ! 1: LDXA_I	ldxa	[%r16, + 0x0d70] %asi, %r3
	.word 0xf65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r27
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xcc8c2de5  ! 1: LDUBA_I	lduba	[%r16, + 0x0de5] %asi, %r6
	.word 0xde040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r15
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc654225a  ! 1: LDSH_I	ldsh	[%r16 + 0x025a], %r3
	brnz %r31,thr3_loop_cnt_316
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0xb8340002  ! 1: SUBC_R	orn 	%r16, %r2, %r28
        mov 0x5, %r31
thr3_loop_cnt_317:
	.word 0xc60420f0  ! 1: LDUW_I	lduw	[%r16 + 0x00f0], %r3
	.word 0xfc442368  ! 1: LDSW_I	ldsw	[%r16 + 0x0368], %r30
	.word 0xf2542842  ! 1: LDSH_I	ldsh	[%r16 + 0x0842], %r25
	.word 0xf80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r28
	.word 0xc64c278f  ! 1: LDSB_I	ldsb	[%r16 + 0x078f], %r3
	.word 0xf0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r24
	.word 0xfc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r30
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2d28  ! 1: LDXA_I	ldxa	[%r16, + 0x0d28] %asi, %r3
	.word 0xd64425bc  ! 1: LDSW_I	ldsw	[%r16 + 0x05bc], %r11
	.word 0xc60c2d43  ! 1: LDUB_I	ldub	[%r16 + 0x0d43], %r3
	brnz %r31,thr3_loop_cnt_317
	dec %r31
	.word 0x86042bce  ! 1: ADD_I	add 	%r16, 0x0bce, %r3
	.word 0x9a3c2706  ! 1: XNOR_I	xnor 	%r16, 0x0706, %r13
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x9c, %r31
thr3_loop_cnt_318:
	.word 0xd84c2f2a  ! 1: LDSB_I	ldsb	[%r16 + 0x0f2a], %r12
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd0042b8c  ! 1: LDUW_I	lduw	[%r16 + 0x0b8c], %r8
	.word 0xfcd427a0  ! 1: LDSHA_I	ldsha	[%r16, + 0x07a0] %asi, %r30
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xdc4420bc  ! 1: LDSW_I	ldsw	[%r16 + 0x00bc], %r14
	.word 0xec042e34  ! 1: LDUW_I	lduw	[%r16 + 0x0e34], %r22
	.word 0xdc5c2600  ! 1: LDX_I	ldx	[%r16 + 0x0600], %r14
	brnz %r31,thr3_loop_cnt_318
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x8f2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r7
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0xaa, %r31
thr3_loop_cnt_319:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd2dc29a0  ! 1: LDXA_I	ldxa	[%r16, + 0x09a0] %asi, %r9
	.word 0xc6cc2f59  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f59] %asi, %r3
	.word 0xe2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r17
	.word 0xc65c22e0  ! 1: LDX_I	ldx	[%r16 + 0x02e0], %r3
	.word 0xf4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r26
	.word 0xc684209c  ! 1: LDUWA_I	lduwa	[%r16, + 0x009c] %asi, %r3
	.word 0xccdc24c8  ! 1: LDXA_I	ldxa	[%r16, + 0x04c8] %asi, %r6
	.word 0xc6442200  ! 1: LDSW_I	ldsw	[%r16 + 0x0200], %r3
	.word 0xe80c27e5  ! 1: LDUB_I	ldub	[%r16 + 0x07e5], %r20
	brnz %r31,thr3_loop_cnt_319
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0xaf, %r31
thr3_loop_cnt_320:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xdadc2e90  ! 1: LDXA_I	ldxa	[%r16, + 0x0e90] %asi, %r13
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc21a9  ! 1: LDSBA_I	ldsba	[%r16, + 0x01a9] %asi, %r3
	.word 0xc6d4290a  ! 1: LDSHA_I	ldsha	[%r16, + 0x090a] %asi, %r3
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xc6042c30  ! 1: LDUW_I	lduw	[%r16 + 0x0c30], %r3
	.word 0xc65c28d8  ! 1: LDX_I	ldx	[%r16 + 0x08d8], %r3
	brnz %r31,thr3_loop_cnt_320
	dec %r31
        mov 0x38, %r31
thr3_loop_cnt_321:
	.word 0xc6042838  ! 1: LDUW_I	lduw	[%r16 + 0x0838], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc64c25e4  ! 1: LDSB_I	ldsb	[%r16 + 0x05e4], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd8042764  ! 1: LDUW_I	lduw	[%r16 + 0x0764], %r12
	.word 0xfc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r30
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd00c27c4  ! 1: LDUB_I	ldub	[%r16 + 0x07c4], %r8
	.word 0xe6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r19
	brnz %r31,thr3_loop_cnt_321
	dec %r31
	.word 0x920c20cf  ! 1: AND_I	and 	%r16, 0x00cf, %r9
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0xa8342394  ! 1: ORN_I	orn 	%r16, 0x0394, %r20
        mov 0xa9, %r31
thr3_loop_cnt_322:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf88421c8  ! 1: LDUWA_I	lduwa	[%r16, + 0x01c8] %asi, %r28
	.word 0xc694231a  ! 1: LDUHA_I	lduha	[%r16, + 0x031a] %asi, %r3
	.word 0xc6442bb8  ! 1: LDSW_I	ldsw	[%r16 + 0x0bb8], %r3
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	.word 0xe4cc200d  ! 1: LDSBA_I	ldsba	[%r16, + 0x000d] %asi, %r18
	brnz %r31,thr3_loop_cnt_322
	dec %r31
	.word 0xb2442356  ! 1: ADDC_I	addc 	%r16, 0x0356, %r25
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0xbc040002  ! 1: ADD_R	add 	%r16, %r2, %r30
	.word 0x86142c95  ! 1: OR_I	or 	%r16, 0x0c95, %r3
        mov 0xf, %r31
thr3_loop_cnt_323:
	.word 0xc6d424c0  ! 1: LDSHA_I	ldsha	[%r16, + 0x04c0] %asi, %r3
	.word 0xda442ec8  ! 1: LDSW_I	ldsw	[%r16 + 0x0ec8], %r13
	.word 0xc60427bc  ! 1: LDUW_I	lduw	[%r16 + 0x07bc], %r3
	.word 0xc6542a6e  ! 1: LDSH_I	ldsh	[%r16 + 0x0a6e], %r3
	.word 0xe64c206b  ! 1: LDSB_I	ldsb	[%r16 + 0x006b], %r19
	.word 0xf0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r24
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_323
	dec %r31
	.word 0x861c2ac7  ! 1: XOR_I	xor 	%r16, 0x0ac7, %r3
        mov 0x6b, %r31
thr3_loop_cnt_324:
	.word 0xf04427f4  ! 1: LDSW_I	ldsw	[%r16 + 0x07f4], %r24
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c2dd4  ! 1: LDSB_I	ldsb	[%r16 + 0x0dd4], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6cc2109  ! 1: LDSBA_I	ldsba	[%r16, + 0x0109] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf6c42164  ! 1: LDSWA_I	ldswa	[%r16, + 0x0164] %asi, %r27
	.word 0xf4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r26
	brnz %r31,thr3_loop_cnt_324
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x862c2b96  ! 1: ANDN_I	andn 	%r16, 0x0b96, %r3
	.word 0x86342162  ! 1: ORN_I	orn 	%r16, 0x0162, %r3
	.word 0xba3423a7  ! 1: SUBC_I	orn 	%r16, 0x03a7, %r29
        mov 0x25, %r31
thr3_loop_cnt_325:
	.word 0xc65c2fe0  ! 1: LDX_I	ldx	[%r16 + 0x0fe0], %r3
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc213c  ! 1: LDSBA_I	ldsba	[%r16, + 0x013c] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xfad42f3a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f3a] %asi, %r29
	.word 0xd0842a60  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a60] %asi, %r8
	.word 0xe8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r20
	brnz %r31,thr3_loop_cnt_325
	dec %r31
	.word 0xa83c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r20
	.word 0x860c2c52  ! 1: AND_I	and 	%r16, 0x0c52, %r3
	.word 0x92342b5d  ! 1: SUBC_I	orn 	%r16, 0x0b5d, %r9
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x4a, %r31
thr3_loop_cnt_326:
	.word 0xc6842d7c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d7c] %asi, %r3
	.word 0xc6042668  ! 1: LDUW_I	lduw	[%r16 + 0x0668], %r3
	.word 0xcc0c2051  ! 1: LDUB_I	ldub	[%r16 + 0x0051], %r6
	.word 0xf2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r25
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xda140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r13
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xc6cc251d  ! 1: LDSBA_I	ldsba	[%r16, + 0x051d] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc68c2c37  ! 1: LDUBA_I	lduba	[%r16, + 0x0c37] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_326
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x8c442362  ! 1: ADDC_I	addc 	%r16, 0x0362, %r6
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x2f, %r31
thr3_loop_cnt_327:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6042130  ! 1: LDUW_I	lduw	[%r16 + 0x0130], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c42760  ! 1: LDSWA_I	ldswa	[%r16, + 0x0760] %asi, %r3
	.word 0xc60c29cd  ! 1: LDUB_I	ldub	[%r16 + 0x09cd], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc60c2866  ! 1: LDUB_I	ldub	[%r16 + 0x0866], %r3
	.word 0xcc5c2898  ! 1: LDX_I	ldx	[%r16 + 0x0898], %r6
	.word 0xd45c2e78  ! 1: LDX_I	ldx	[%r16 + 0x0e78], %r10
	.word 0xf4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r26
	brnz %r31,thr3_loop_cnt_327
	dec %r31
        mov 0x19, %r31
thr3_loop_cnt_328:
	.word 0xf85c26c0  ! 1: LDX_I	ldx	[%r16 + 0x06c0], %r28
	.word 0xde5422c6  ! 1: LDSH_I	ldsh	[%r16 + 0x02c6], %r15
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r26
	.word 0xf8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r28
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xee542e32  ! 1: LDSH_I	ldsh	[%r16 + 0x0e32], %r23
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_328
	dec %r31
	.word 0x9d2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r14
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x81, %r31
thr3_loop_cnt_329:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe8c420f4  ! 1: LDSWA_I	ldswa	[%r16, + 0x00f4] %asi, %r20
	.word 0xfcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r30
	.word 0xe85427d0  ! 1: LDSH_I	ldsh	[%r16 + 0x07d0], %r20
	.word 0xc6042828  ! 1: LDUW_I	lduw	[%r16 + 0x0828], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd2042a60  ! 1: LDUW_I	lduw	[%r16 + 0x0a60], %r9
	.word 0xfc942260  ! 1: LDUHA_I	lduha	[%r16, + 0x0260] %asi, %r30
	.word 0xc6dc2aa0  ! 1: LDXA_I	ldxa	[%r16, + 0x0aa0] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_329
	dec %r31
	.word 0xa80c22fd  ! 1: AND_I	and 	%r16, 0x02fd, %r20
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0xf, %r31
thr3_loop_cnt_330:
	.word 0xd8042284  ! 1: LDUW_I	lduw	[%r16 + 0x0284], %r12
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd80428cc  ! 1: LDUW_I	lduw	[%r16 + 0x08cc], %r12
	.word 0xc60424d4  ! 1: LDUW_I	lduw	[%r16 + 0x04d4], %r3
	.word 0xc6dc2d30  ! 1: LDXA_I	ldxa	[%r16, + 0x0d30] %asi, %r3
	.word 0xf694273a  ! 1: LDUHA_I	lduha	[%r16, + 0x073a] %asi, %r27
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xeadc2690  ! 1: LDXA_I	ldxa	[%r16, + 0x0690] %asi, %r21
	brnz %r31,thr3_loop_cnt_330
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0x93, %r31
thr3_loop_cnt_331:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd0cc2f6e  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f6e] %asi, %r8
	.word 0xc6842f30  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f30] %asi, %r3
	.word 0xc68421b8  ! 1: LDUWA_I	lduwa	[%r16, + 0x01b8] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	.word 0xc6dc2308  ! 1: LDXA_I	ldxa	[%r16, + 0x0308] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r9
	brnz %r31,thr3_loop_cnt_331
	dec %r31
        mov 0x80, %r31
thr3_loop_cnt_332:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r24
	.word 0xfc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r30
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xec54218e  ! 1: LDSH_I	ldsh	[%r16 + 0x018e], %r22
	.word 0xd40c2a22  ! 1: LDUB_I	ldub	[%r16 + 0x0a22], %r10
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	.word 0xde8c25fd  ! 1: LDUBA_I	lduba	[%r16, + 0x05fd] %asi, %r15
	.word 0xf2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r25
	.word 0xc60c2724  ! 1: LDUB_I	ldub	[%r16 + 0x0724], %r3
	brnz %r31,thr3_loop_cnt_332
	dec %r31
        mov 0xa9, %r31
thr3_loop_cnt_333:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r27
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe4042528  ! 1: LDUW_I	lduw	[%r16 + 0x0528], %r18
	.word 0xee540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r23
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6442c10  ! 1: LDSW_I	ldsw	[%r16 + 0x0c10], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_333
	dec %r31
	.word 0xa844273d  ! 1: ADDC_I	addc 	%r16, 0x073d, %r20
	.word 0xa6040002  ! 1: ADD_R	add 	%r16, %r2, %r19
        mov 0x7d, %r31
thr3_loop_cnt_334:
	.word 0xd0442770  ! 1: LDSW_I	ldsw	[%r16 + 0x0770], %r8
	.word 0xfcdc2b18  ! 1: LDXA_I	ldxa	[%r16, + 0x0b18] %asi, %r30
	.word 0xeed41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r23
	.word 0xec440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r22
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6042cf4  ! 1: LDUW_I	lduw	[%r16 + 0x0cf4], %r3
	.word 0xc6942496  ! 1: LDUHA_I	lduha	[%r16, + 0x0496] %asi, %r3
	.word 0xcc5c2d10  ! 1: LDX_I	ldx	[%r16 + 0x0d10], %r6
	.word 0xe28c2fe8  ! 1: LDUBA_I	lduba	[%r16, + 0x0fe8] %asi, %r17
	.word 0xea5c2b30  ! 1: LDX_I	ldx	[%r16 + 0x0b30], %r21
	brnz %r31,thr3_loop_cnt_334
	dec %r31
	.word 0xa62c28cb  ! 1: ANDN_I	andn 	%r16, 0x08cb, %r19
        mov 0x32, %r31
thr3_loop_cnt_335:
	.word 0xc60c233b  ! 1: LDUB_I	ldub	[%r16 + 0x033b], %r3
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	.word 0xc6042278  ! 1: LDUW_I	lduw	[%r16 + 0x0278], %r3
	.word 0xeac420e4  ! 1: LDSWA_I	ldswa	[%r16, + 0x00e4] %asi, %r21
	.word 0xfa140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r29
	.word 0xeed426a4  ! 1: LDSHA_I	ldsha	[%r16, + 0x06a4] %asi, %r23
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	.word 0xf4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r26
	.word 0xf2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r25
	.word 0xf4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r26
	brnz %r31,thr3_loop_cnt_335
	dec %r31
	.word 0xbb342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r29
	.word 0x992c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r12
        mov 0x8, %r31
thr3_loop_cnt_336:
	.word 0xc65423bc  ! 1: LDSH_I	ldsh	[%r16 + 0x03bc], %r3
	.word 0xea442ea4  ! 1: LDSW_I	ldsw	[%r16 + 0x0ea4], %r21
	.word 0xce94219e  ! 1: LDUHA_I	lduha	[%r16, + 0x019e] %asi, %r7
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd0042258  ! 1: LDUW_I	lduw	[%r16 + 0x0258], %r8
	.word 0xc6442858  ! 1: LDSW_I	ldsw	[%r16 + 0x0858], %r3
	.word 0xc6c42a20  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a20] %asi, %r3
	brnz %r31,thr3_loop_cnt_336
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0xb0340002  ! 1: SUBC_R	orn 	%r16, %r2, %r24
        mov 0x80, %r31
thr3_loop_cnt_337:
	.word 0xd0c425ec  ! 1: LDSWA_I	ldswa	[%r16, + 0x05ec] %asi, %r8
	.word 0xe8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r20
	.word 0xd8c42a5c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a5c] %asi, %r12
	.word 0xe2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r17
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	.word 0xc6942072  ! 1: LDUHA_I	lduha	[%r16, + 0x0072] %asi, %r3
	.word 0xf05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r24
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_337
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0xa8, %r31
thr3_loop_cnt_338:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6042f4c  ! 1: LDUW_I	lduw	[%r16 + 0x0f4c], %r3
	.word 0xe6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r19
	.word 0xc6d4245a  ! 1: LDSHA_I	ldsha	[%r16, + 0x045a] %asi, %r3
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xfc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r30
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r26
	.word 0xe8dc2580  ! 1: LDXA_I	ldxa	[%r16, + 0x0580] %asi, %r20
	brnz %r31,thr3_loop_cnt_338
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0xa2, %r31
thr3_loop_cnt_339:
	.word 0xd68c2181  ! 1: LDUBA_I	lduba	[%r16, + 0x0181] %asi, %r11
	.word 0xeadc2f50  ! 1: LDXA_I	ldxa	[%r16, + 0x0f50] %asi, %r21
	.word 0xcc542930  ! 1: LDSH_I	ldsh	[%r16 + 0x0930], %r6
	.word 0xea8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r21
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	.word 0xd0cc262f  ! 1: LDSBA_I	ldsba	[%r16, + 0x062f] %asi, %r8
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc64c251c  ! 1: LDSB_I	ldsb	[%r16 + 0x051c], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xec442d9c  ! 1: LDSW_I	ldsw	[%r16 + 0x0d9c], %r22
	.word 0xec140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r22
	brnz %r31,thr3_loop_cnt_339
	dec %r31
	.word 0x9a442a4e  ! 1: ADDC_I	addc 	%r16, 0x0a4e, %r13
	.word 0xbc242db7  ! 1: SUB_I	sub 	%r16, 0x0db7, %r30
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0x1, %r31
thr3_loop_cnt_340:
	.word 0xc6d429f2  ! 1: LDSHA_I	ldsha	[%r16, + 0x09f2] %asi, %r3
	.word 0xe814293a  ! 1: LDUH_I	lduh	[%r16 + 0x093a], %r20
	.word 0xe4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r18
	.word 0xd65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r11
	.word 0xec5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r22
	.word 0xd88c2648  ! 1: LDUBA_I	lduba	[%r16, + 0x0648] %asi, %r12
	.word 0xc6dc2f88  ! 1: LDXA_I	ldxa	[%r16, + 0x0f88] %asi, %r3
	.word 0xdc442160  ! 1: LDSW_I	ldsw	[%r16 + 0x0160], %r14
	.word 0xe2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r17
	.word 0xfadc2fe0  ! 1: LDXA_I	ldxa	[%r16, + 0x0fe0] %asi, %r29
	brnz %r31,thr3_loop_cnt_340
	dec %r31
	.word 0x992c0002  ! 1: SLL_R	sll 	%r16, %r2, %r12
	.word 0x93341002  ! 1: SRLX_R	srlx	%r16, %r2, %r9
        mov 0x8a, %r31
thr3_loop_cnt_341:
	.word 0xced42d54  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d54] %asi, %r7
	.word 0xf00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r24
	.word 0xc6542cb4  ! 1: LDSH_I	ldsh	[%r16 + 0x0cb4], %r3
	.word 0xc6942e9a  ! 1: LDUHA_I	lduha	[%r16, + 0x0e9a] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xdc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r14
	.word 0xe4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r18
	.word 0xc68c2874  ! 1: LDUBA_I	lduba	[%r16, + 0x0874] %asi, %r3
	.word 0xd0042c98  ! 1: LDUW_I	lduw	[%r16 + 0x0c98], %r8
	.word 0xf4442cb8  ! 1: LDSW_I	ldsw	[%r16 + 0x0cb8], %r26
	brnz %r31,thr3_loop_cnt_341
	dec %r31
        mov 0x68, %r31
thr3_loop_cnt_342:
	.word 0xc6d42dd8  ! 1: LDSHA_I	ldsha	[%r16, + 0x0dd8] %asi, %r3
	.word 0xd4dc2960  ! 1: LDXA_I	ldxa	[%r16, + 0x0960] %asi, %r10
	.word 0xc64c2266  ! 1: LDSB_I	ldsb	[%r16 + 0x0266], %r3
	.word 0xde5c2068  ! 1: LDX_I	ldx	[%r16 + 0x0068], %r15
	.word 0xc60423c0  ! 1: LDUW_I	lduw	[%r16 + 0x03c0], %r3
	.word 0xd2cc293d  ! 1: LDSBA_I	ldsba	[%r16, + 0x093d] %asi, %r9
	.word 0xd0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r8
	.word 0xc6c42aa8  ! 1: LDSWA_I	ldswa	[%r16, + 0x0aa8] %asi, %r3
	.word 0xf2dc2dc0  ! 1: LDXA_I	ldxa	[%r16, + 0x0dc0] %asi, %r25
	.word 0xd00c2328  ! 1: LDUB_I	ldub	[%r16 + 0x0328], %r8
	.word 0xced42ab8  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ab8] %asi, %r7
	brnz %r31,thr3_loop_cnt_342
	dec %r31
	.word 0x9604259d  ! 1: ADD_I	add 	%r16, 0x059d, %r11
	.word 0x861422da  ! 1: OR_I	or 	%r16, 0x02da, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x7b, %r31
thr3_loop_cnt_343:
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xc6542ae0  ! 1: LDSH_I	ldsh	[%r16 + 0x0ae0], %r3
	.word 0xc6d427b8  ! 1: LDSHA_I	ldsha	[%r16, + 0x07b8] %asi, %r3
	.word 0xd05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r8
	.word 0xc6842f00  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f00] %asi, %r3
	.word 0xd0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r8
	.word 0xc6d42b0a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b0a] %asi, %r3
	.word 0xd0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r8
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_343
	dec %r31
	.word 0x86442973  ! 1: ADDC_I	addc 	%r16, 0x0973, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0x1e, %r31
thr3_loop_cnt_344:
	.word 0xf6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r27
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd2c42c4c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c4c] %asi, %r9
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6142764  ! 1: LDUH_I	lduh	[%r16 + 0x0764], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6542654  ! 1: LDSH_I	ldsh	[%r16 + 0x0654], %r3
	.word 0xd014291c  ! 1: LDUH_I	lduh	[%r16 + 0x091c], %r8
	.word 0xc6942bee  ! 1: LDUHA_I	lduha	[%r16, + 0x0bee] %asi, %r3
	.word 0xc6542d1a  ! 1: LDSH_I	ldsh	[%r16 + 0x0d1a], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_344
	dec %r31
	.word 0xa81c0002  ! 1: XOR_R	xor 	%r16, %r2, %r20
	.word 0x86242191  ! 1: SUB_I	sub 	%r16, 0x0191, %r3
	.word 0x962c2e98  ! 1: ANDN_I	andn 	%r16, 0x0e98, %r11
        mov 0x29, %r31
thr3_loop_cnt_345:
	.word 0xf0d420be  ! 1: LDSHA_I	ldsha	[%r16, + 0x00be] %asi, %r24
	.word 0xf2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r25
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6dc2778  ! 1: LDXA_I	ldxa	[%r16, + 0x0778] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc60425cc  ! 1: LDUW_I	lduw	[%r16 + 0x05cc], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6842a04  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a04] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_345
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x9e3426c6  ! 1: ORN_I	orn 	%r16, 0x06c6, %r15
        mov 0x29, %r31
thr3_loop_cnt_346:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xce8c281c  ! 1: LDUBA_I	lduba	[%r16, + 0x081c] %asi, %r7
	.word 0xd2d42b9e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b9e] %asi, %r9
	.word 0xe28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r17
	.word 0xc68c2f9d  ! 1: LDUBA_I	lduba	[%r16, + 0x0f9d] %asi, %r3
	.word 0xc64c2579  ! 1: LDSB_I	ldsb	[%r16 + 0x0579], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc614217c  ! 1: LDUH_I	lduh	[%r16 + 0x017c], %r3
	brnz %r31,thr3_loop_cnt_346
	dec %r31
	.word 0xa82421eb  ! 1: SUB_I	sub 	%r16, 0x01eb, %r20
	.word 0x8c2c25f3  ! 1: ANDN_I	andn 	%r16, 0x05f3, %r6
	.word 0xa8340002  ! 1: ORN_R	orn 	%r16, %r2, %r20
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x3a, %r31
thr3_loop_cnt_347:
	.word 0xc64c2ac8  ! 1: LDSB_I	ldsb	[%r16 + 0x0ac8], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d42fa2  ! 1: LDSHA_I	ldsha	[%r16, + 0x0fa2] %asi, %r3
	.word 0xdc142990  ! 1: LDUH_I	lduh	[%r16 + 0x0990], %r14
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd0d4216e  ! 1: LDSHA_I	ldsha	[%r16, + 0x016e] %asi, %r8
	.word 0xe65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r19
	.word 0xc6c4295c  ! 1: LDSWA_I	ldswa	[%r16, + 0x095c] %asi, %r3
	.word 0xc64c2268  ! 1: LDSB_I	ldsb	[%r16 + 0x0268], %r3
	brnz %r31,thr3_loop_cnt_347
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0xb0, %r31
thr3_loop_cnt_348:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xea5423fe  ! 1: LDSH_I	ldsh	[%r16 + 0x03fe], %r21
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc69420ac  ! 1: LDUHA_I	lduha	[%r16, + 0x00ac] %asi, %r3
	.word 0xea5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r21
	.word 0xce042dc4  ! 1: LDUW_I	lduw	[%r16 + 0x0dc4], %r7
	.word 0xc6d42abe  ! 1: LDSHA_I	ldsha	[%r16, + 0x0abe] %asi, %r3
	.word 0xc6dc24e8  ! 1: LDXA_I	ldxa	[%r16, + 0x04e8] %asi, %r3
	.word 0xf08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r24
	brnz %r31,thr3_loop_cnt_348
	dec %r31
        mov 0x46, %r31
thr3_loop_cnt_349:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf2cc298e  ! 1: LDSBA_I	ldsba	[%r16, + 0x098e] %asi, %r25
	.word 0xc68c2dea  ! 1: LDUBA_I	lduba	[%r16, + 0x0dea] %asi, %r3
	.word 0xd0d42cba  ! 1: LDSHA_I	ldsha	[%r16, + 0x0cba] %asi, %r8
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc69426c6  ! 1: LDUHA_I	lduha	[%r16, + 0x06c6] %asi, %r3
	.word 0xe6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r19
	.word 0xc6d428fc  ! 1: LDSHA_I	ldsha	[%r16, + 0x08fc] %asi, %r3
	.word 0xce4c2359  ! 1: LDSB_I	ldsb	[%r16 + 0x0359], %r7
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc26ed  ! 1: LDSBA_I	ldsba	[%r16, + 0x06ed] %asi, %r3
	brnz %r31,thr3_loop_cnt_349
	dec %r31
	.word 0x86342e02  ! 1: ORN_I	orn 	%r16, 0x0e02, %r3
	.word 0xa2342e36  ! 1: ORN_I	orn 	%r16, 0x0e36, %r17
        mov 0x83, %r31
thr3_loop_cnt_350:
	.word 0xc68c2ff9  ! 1: LDUBA_I	lduba	[%r16, + 0x0ff9] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc65c22e8  ! 1: LDX_I	ldx	[%r16 + 0x02e8], %r3
	.word 0xe49426d8  ! 1: LDUHA_I	lduha	[%r16, + 0x06d8] %asi, %r18
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xcc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r6
	.word 0xc61422dc  ! 1: LDUH_I	lduh	[%r16 + 0x02dc], %r3
	brnz %r31,thr3_loop_cnt_350
	dec %r31
	.word 0xa80429b1  ! 1: ADD_I	add 	%r16, 0x09b1, %r20
	.word 0xbb342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r29
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x3, %r31
thr3_loop_cnt_351:
	.word 0xc61428bc  ! 1: LDUH_I	lduh	[%r16 + 0x08bc], %r3
	.word 0xf0142d90  ! 1: LDUH_I	lduh	[%r16 + 0x0d90], %r24
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xea1421e0  ! 1: LDUH_I	lduh	[%r16 + 0x01e0], %r21
	.word 0xe68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r19
	.word 0xc6942d92  ! 1: LDUHA_I	lduha	[%r16, + 0x0d92] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xce1428f0  ! 1: LDUH_I	lduh	[%r16 + 0x08f0], %r7
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf8d424a0  ! 1: LDSHA_I	ldsha	[%r16, + 0x04a0] %asi, %r28
	brnz %r31,thr3_loop_cnt_351
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x902c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r8
        mov 0x19, %r31
thr3_loop_cnt_352:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xeec42538  ! 1: LDSWA_I	ldswa	[%r16, + 0x0538] %asi, %r23
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xc6142f10  ! 1: LDUH_I	lduh	[%r16 + 0x0f10], %r3
	.word 0xc684209c  ! 1: LDUWA_I	lduwa	[%r16, + 0x009c] %asi, %r3
	.word 0xc68c2670  ! 1: LDUBA_I	lduba	[%r16, + 0x0670] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6942254  ! 1: LDUHA_I	lduha	[%r16, + 0x0254] %asi, %r3
	brnz %r31,thr3_loop_cnt_352
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0x52, %r31
thr3_loop_cnt_353:
	.word 0xd8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r12
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xfa0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r29
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6dc29c8  ! 1: LDXA_I	ldxa	[%r16, + 0x09c8] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r24
	.word 0xc60c29f2  ! 1: LDUB_I	ldub	[%r16 + 0x09f2], %r3
	.word 0xe6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r19
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xd8842b2c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b2c] %asi, %r12
	brnz %r31,thr3_loop_cnt_353
	dec %r31
	.word 0x860c2b56  ! 1: AND_I	and 	%r16, 0x0b56, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x862c2458  ! 1: ANDN_I	andn 	%r16, 0x0458, %r3
        mov 0x89, %r31
thr3_loop_cnt_354:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xeecc2833  ! 1: LDSBA_I	ldsba	[%r16, + 0x0833] %asi, %r23
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	.word 0xc6042268  ! 1: LDUW_I	lduw	[%r16 + 0x0268], %r3
	.word 0xd00c2cc0  ! 1: LDUB_I	ldub	[%r16 + 0x0cc0], %r8
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf2042a50  ! 1: LDUW_I	lduw	[%r16 + 0x0a50], %r25
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_354
	dec %r31
        mov 0xa8, %r31
thr3_loop_cnt_355:
	.word 0xc64429b8  ! 1: LDSW_I	ldsw	[%r16 + 0x09b8], %r3
	.word 0xf2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r25
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6c42e2c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e2c] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf8942a74  ! 1: LDUHA_I	lduha	[%r16, + 0x0a74] %asi, %r28
	.word 0xe68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r19
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xced41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r7
	brnz %r31,thr3_loop_cnt_355
	dec %r31
	.word 0xb02c2ade  ! 1: ANDN_I	andn 	%r16, 0x0ade, %r24
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0xbc342c80  ! 1: ORN_I	orn 	%r16, 0x0c80, %r30
	.word 0x9e442dd3  ! 1: ADDC_I	addc 	%r16, 0x0dd3, %r15
        mov 0x64, %r31
thr3_loop_cnt_356:
	.word 0xe8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r20
	.word 0xf6cc20a6  ! 1: LDSBA_I	ldsba	[%r16, + 0x00a6] %asi, %r27
	.word 0xc64c2c34  ! 1: LDSB_I	ldsb	[%r16 + 0x0c34], %r3
	.word 0xd0542a32  ! 1: LDSH_I	ldsh	[%r16 + 0x0a32], %r8
	.word 0xea841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r21
	.word 0xc6dc2e38  ! 1: LDXA_I	ldxa	[%r16, + 0x0e38] %asi, %r3
	.word 0xf6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r27
	.word 0xc6cc2cca  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cca] %asi, %r3
	.word 0xf6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r27
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	.word 0xd2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r9
	brnz %r31,thr3_loop_cnt_356
	dec %r31
        mov 0xba, %r31
thr3_loop_cnt_357:
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r26
	.word 0xfc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r30
	.word 0xc65c2510  ! 1: LDX_I	ldx	[%r16 + 0x0510], %r3
	.word 0xc6542182  ! 1: LDSH_I	ldsh	[%r16 + 0x0182], %r3
	.word 0xfc9422ba  ! 1: LDUHA_I	lduha	[%r16, + 0x02ba] %asi, %r30
	.word 0xc68c2fdb  ! 1: LDUBA_I	lduba	[%r16, + 0x0fdb] %asi, %r3
	.word 0xeed41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r23
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_357
	dec %r31
	.word 0x860c2769  ! 1: AND_I	and 	%r16, 0x0769, %r3
	.word 0x9c04279d  ! 1: ADD_I	add 	%r16, 0x079d, %r14
	.word 0xa63c21a2  ! 1: XNOR_I	xnor 	%r16, 0x01a2, %r19
        mov 0x1a, %r31
thr3_loop_cnt_358:
	.word 0xc6442a10  ! 1: LDSW_I	ldsw	[%r16 + 0x0a10], %r3
	.word 0xf8042cd0  ! 1: LDUW_I	lduw	[%r16 + 0x0cd0], %r28
	.word 0xf8c4270c  ! 1: LDSWA_I	ldswa	[%r16, + 0x070c] %asi, %r28
	.word 0xc6842084  ! 1: LDUWA_I	lduwa	[%r16, + 0x0084] %asi, %r3
	.word 0xe48c2e28  ! 1: LDUBA_I	lduba	[%r16, + 0x0e28] %asi, %r18
	.word 0xc6dc29a0  ! 1: LDXA_I	ldxa	[%r16, + 0x09a0] %asi, %r3
	.word 0xc6442414  ! 1: LDSW_I	ldsw	[%r16 + 0x0414], %r3
	.word 0xc694290a  ! 1: LDUHA_I	lduha	[%r16, + 0x090a] %asi, %r3
	.word 0xc65c2578  ! 1: LDX_I	ldx	[%r16 + 0x0578], %r3
	brnz %r31,thr3_loop_cnt_358
	dec %r31
        mov 0x74, %r31
thr3_loop_cnt_359:
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xc6c42338  ! 1: LDSWA_I	ldswa	[%r16, + 0x0338] %asi, %r3
	.word 0xd8cc24c9  ! 1: LDSBA_I	ldsba	[%r16, + 0x04c9] %asi, %r12
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d42bc0  ! 1: LDSHA_I	ldsha	[%r16, + 0x0bc0] %asi, %r3
	.word 0xc6542c14  ! 1: LDSH_I	ldsh	[%r16 + 0x0c14], %r3
	.word 0xec442840  ! 1: LDSW_I	ldsw	[%r16 + 0x0840], %r22
	.word 0xee142494  ! 1: LDUH_I	lduh	[%r16 + 0x0494], %r23
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	brnz %r31,thr3_loop_cnt_359
	dec %r31
        mov 0x64, %r31
thr3_loop_cnt_360:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xce5c2850  ! 1: LDX_I	ldx	[%r16 + 0x0850], %r7
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xce4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r7
	.word 0xc614218a  ! 1: LDUH_I	lduh	[%r16 + 0x018a], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xdad42294  ! 1: LDSHA_I	ldsha	[%r16, + 0x0294] %asi, %r13
	.word 0xc60421d4  ! 1: LDUW_I	lduw	[%r16 + 0x01d4], %r3
	.word 0xd0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r8
	.word 0xce942d30  ! 1: LDUHA_I	lduha	[%r16, + 0x0d30] %asi, %r7
	brnz %r31,thr3_loop_cnt_360
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0xe, %r31
thr3_loop_cnt_361:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	.word 0xf88c2ffd  ! 1: LDUBA_I	lduba	[%r16, + 0x0ffd] %asi, %r28
	.word 0xfa540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r29
	.word 0xc6d42e48  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e48] %asi, %r3
	.word 0xd8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r12
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc60c2b71  ! 1: LDUB_I	ldub	[%r16 + 0x0b71], %r3
	.word 0xd04422b8  ! 1: LDSW_I	ldsw	[%r16 + 0x02b8], %r8
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r11
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_361
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x8f3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r7
        mov 0x2a, %r31
thr3_loop_cnt_362:
	.word 0xe6c42710  ! 1: LDSWA_I	ldswa	[%r16, + 0x0710] %asi, %r19
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf28c2925  ! 1: LDUBA_I	lduba	[%r16, + 0x0925] %asi, %r25
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	.word 0xc6442188  ! 1: LDSW_I	ldsw	[%r16 + 0x0188], %r3
	.word 0xc68c2b72  ! 1: LDUBA_I	lduba	[%r16, + 0x0b72] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xda0c2cce  ! 1: LDUB_I	ldub	[%r16 + 0x0cce], %r13
	.word 0xe414255a  ! 1: LDUH_I	lduh	[%r16 + 0x055a], %r18
	.word 0xc6942698  ! 1: LDUHA_I	lduha	[%r16, + 0x0698] %asi, %r3
	brnz %r31,thr3_loop_cnt_362
	dec %r31
	.word 0x8f342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r7
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0xa8340002  ! 1: SUBC_R	orn 	%r16, %r2, %r20
        mov 0x5b, %r31
thr3_loop_cnt_363:
	.word 0xccd428d0  ! 1: LDSHA_I	ldsha	[%r16, + 0x08d0] %asi, %r6
	.word 0xc6042bd4  ! 1: LDUW_I	lduw	[%r16 + 0x0bd4], %r3
	.word 0xc6c42fcc  ! 1: LDSWA_I	ldswa	[%r16, + 0x0fcc] %asi, %r3
	.word 0xda4c2760  ! 1: LDSB_I	ldsb	[%r16 + 0x0760], %r13
	.word 0xcc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r6
	.word 0xfc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r30
	.word 0xea5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r21
	.word 0xfa0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r29
	.word 0xcec42b3c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b3c] %asi, %r7
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_363
	dec %r31
	.word 0x863c264a  ! 1: XNOR_I	xnor 	%r16, 0x064a, %r3
        mov 0xa5, %r31
thr3_loop_cnt_364:
	.word 0xf25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r25
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6142776  ! 1: LDUH_I	lduh	[%r16 + 0x0776], %r3
	.word 0xee8c2f6c  ! 1: LDUBA_I	lduba	[%r16, + 0x0f6c] %asi, %r23
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6042c74  ! 1: LDUW_I	lduw	[%r16 + 0x0c74], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	.word 0xeec42460  ! 1: LDSWA_I	ldswa	[%r16, + 0x0460] %asi, %r23
	brnz %r31,thr3_loop_cnt_364
	dec %r31
	.word 0xb52c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r26
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0x81, %r31
thr3_loop_cnt_365:
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6dc2b48  ! 1: LDXA_I	ldxa	[%r16, + 0x0b48] %asi, %r3
	.word 0xda5c2510  ! 1: LDX_I	ldx	[%r16 + 0x0510], %r13
	.word 0xc614246e  ! 1: LDUH_I	lduh	[%r16 + 0x046e], %r3
	.word 0xcc54217c  ! 1: LDSH_I	ldsh	[%r16 + 0x017c], %r6
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6c42388  ! 1: LDSWA_I	ldswa	[%r16, + 0x0388] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xea8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r21
	.word 0xd8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r12
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_365
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0xb12c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r24
        mov 0x80, %r31
thr3_loop_cnt_366:
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xecc42c1c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c1c] %asi, %r22
	.word 0xf4042a20  ! 1: LDUW_I	lduw	[%r16 + 0x0a20], %r26
	.word 0xc694275a  ! 1: LDUHA_I	lduha	[%r16, + 0x075a] %asi, %r3
	.word 0xe2c42094  ! 1: LDSWA_I	ldswa	[%r16, + 0x0094] %asi, %r17
	.word 0xc64c286d  ! 1: LDSB_I	ldsb	[%r16 + 0x086d], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xea140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r21
	.word 0xc6dc2f68  ! 1: LDXA_I	ldxa	[%r16, + 0x0f68] %asi, %r3
	.word 0xec5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r22
	brnz %r31,thr3_loop_cnt_366
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x7d, %r31
thr3_loop_cnt_367:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6542868  ! 1: LDSH_I	ldsh	[%r16 + 0x0868], %r3
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xc6dc2098  ! 1: LDXA_I	ldxa	[%r16, + 0x0098] %asi, %r3
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xe45c2330  ! 1: LDX_I	ldx	[%r16 + 0x0330], %r18
	.word 0xd44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r10
	.word 0xc6542bd2  ! 1: LDSH_I	ldsh	[%r16 + 0x0bd2], %r3
	brnz %r31,thr3_loop_cnt_367
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x952c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r10
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x9c, %r31
thr3_loop_cnt_368:
	.word 0xe6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r19
	.word 0xc60c2740  ! 1: LDUB_I	ldub	[%r16 + 0x0740], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xecd42196  ! 1: LDSHA_I	ldsha	[%r16, + 0x0196] %asi, %r22
	.word 0xc6542d32  ! 1: LDSH_I	ldsh	[%r16 + 0x0d32], %r3
	.word 0xced42f0c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f0c] %asi, %r7
	.word 0xc6442b54  ! 1: LDSW_I	ldsw	[%r16 + 0x0b54], %r3
	.word 0xde8c2314  ! 1: LDUBA_I	lduba	[%r16, + 0x0314] %asi, %r15
	.word 0xe6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r19
	brnz %r31,thr3_loop_cnt_368
	dec %r31
	.word 0xaa34230d  ! 1: SUBC_I	orn 	%r16, 0x030d, %r21
        mov 0x14, %r31
thr3_loop_cnt_369:
	.word 0xc6c42f64  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f64] %asi, %r3
	.word 0xe44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r18
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xe2542fcc  ! 1: LDSH_I	ldsh	[%r16 + 0x0fcc], %r17
	.word 0xd4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r10
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	.word 0xe4042224  ! 1: LDUW_I	lduw	[%r16 + 0x0224], %r18
	.word 0xccc423d0  ! 1: LDSWA_I	ldswa	[%r16, + 0x03d0] %asi, %r6
	.word 0xc64c29d8  ! 1: LDSB_I	ldsb	[%r16 + 0x09d8], %r3
	brnz %r31,thr3_loop_cnt_369
	dec %r31
	.word 0xb8342c9b  ! 1: ORN_I	orn 	%r16, 0x0c9b, %r28
        mov 0x8c, %r31
thr3_loop_cnt_370:
	.word 0xdccc2891  ! 1: LDSBA_I	ldsba	[%r16, + 0x0891] %asi, %r14
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc64c25f1  ! 1: LDSB_I	ldsb	[%r16 + 0x05f1], %r3
	.word 0xd4142a0c  ! 1: LDUH_I	lduh	[%r16 + 0x0a0c], %r10
	.word 0xd20c24ff  ! 1: LDUB_I	ldub	[%r16 + 0x04ff], %r9
	.word 0xd84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r12
	.word 0xd0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r8
	.word 0xda54256e  ! 1: LDSH_I	ldsh	[%r16 + 0x056e], %r13
	brnz %r31,thr3_loop_cnt_370
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0xbb340002  ! 1: SRL_R	srl 	%r16, %r2, %r29
        mov 0xb2, %r31
thr3_loop_cnt_371:
	.word 0xc6942c7c  ! 1: LDUHA_I	lduha	[%r16, + 0x0c7c] %asi, %r3
	.word 0xc6542c16  ! 1: LDSH_I	ldsh	[%r16 + 0x0c16], %r3
	.word 0xd45c2cf0  ! 1: LDX_I	ldx	[%r16 + 0x0cf0], %r10
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xce8425f0  ! 1: LDUWA_I	lduwa	[%r16, + 0x05f0] %asi, %r7
	.word 0xc64c2f12  ! 1: LDSB_I	ldsb	[%r16 + 0x0f12], %r3
	.word 0xe2c42228  ! 1: LDSWA_I	ldswa	[%r16, + 0x0228] %asi, %r17
	.word 0xda042fec  ! 1: LDUW_I	lduw	[%r16 + 0x0fec], %r13
	.word 0xc6cc2865  ! 1: LDSBA_I	ldsba	[%r16, + 0x0865] %asi, %r3
	.word 0xfa442aa0  ! 1: LDSW_I	ldsw	[%r16 + 0x0aa0], %r29
	brnz %r31,thr3_loop_cnt_371
	dec %r31
        mov 0x90, %r31
thr3_loop_cnt_372:
	.word 0xe2942674  ! 1: LDUHA_I	lduha	[%r16, + 0x0674] %asi, %r17
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc60c2721  ! 1: LDUB_I	ldub	[%r16 + 0x0721], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc64c2ece  ! 1: LDSB_I	ldsb	[%r16 + 0x0ece], %r3
	.word 0xd4dc2380  ! 1: LDXA_I	ldxa	[%r16, + 0x0380] %asi, %r10
	.word 0xd05c26e8  ! 1: LDX_I	ldx	[%r16 + 0x06e8], %r8
	.word 0xe8842164  ! 1: LDUWA_I	lduwa	[%r16, + 0x0164] %asi, %r20
	brnz %r31,thr3_loop_cnt_372
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x97343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r11
        mov 0x68, %r31
thr3_loop_cnt_373:
	.word 0xd8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r12
	.word 0xc6942d96  ! 1: LDUHA_I	lduha	[%r16, + 0x0d96] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xfa540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r29
	.word 0xd2542da4  ! 1: LDSH_I	ldsh	[%r16 + 0x0da4], %r9
	.word 0xc6842e80  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e80] %asi, %r3
	.word 0xcc942e8a  ! 1: LDUHA_I	lduha	[%r16, + 0x0e8a] %asi, %r6
	.word 0xfc4420d0  ! 1: LDSW_I	ldsw	[%r16 + 0x00d0], %r30
	brnz %r31,thr3_loop_cnt_373
	dec %r31
	.word 0x98440002  ! 1: ADDC_R	addc 	%r16, %r2, %r12
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x9d, %r31
thr3_loop_cnt_374:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xce0424e4  ! 1: LDUW_I	lduw	[%r16 + 0x04e4], %r7
	.word 0xc64c2fd3  ! 1: LDSB_I	ldsb	[%r16 + 0x0fd3], %r3
	.word 0xd64c2ef2  ! 1: LDSB_I	ldsb	[%r16 + 0x0ef2], %r11
	.word 0xc6d42558  ! 1: LDSHA_I	ldsha	[%r16, + 0x0558] %asi, %r3
	.word 0xc6dc24b0  ! 1: LDXA_I	ldxa	[%r16, + 0x04b0] %asi, %r3
	.word 0xc6042380  ! 1: LDUW_I	lduw	[%r16 + 0x0380], %r3
	.word 0xc6542c18  ! 1: LDSH_I	ldsh	[%r16 + 0x0c18], %r3
	.word 0xd24c26ed  ! 1: LDSB_I	ldsb	[%r16 + 0x06ed], %r9
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_374
	dec %r31
	.word 0x9e140002  ! 1: OR_R	or 	%r16, %r2, %r15
	.word 0x9e3c213f  ! 1: XNOR_I	xnor 	%r16, 0x013f, %r15
        mov 0x7a, %r31
thr3_loop_cnt_375:
	.word 0xc6042014  ! 1: LDUW_I	lduw	[%r16 + 0x0014], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r24
	.word 0xdad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r13
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xf2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r25
	.word 0xdcd4250a  ! 1: LDSHA_I	ldsha	[%r16, + 0x050a] %asi, %r14
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_375
	dec %r31
        mov 0x79, %r31
thr3_loop_cnt_376:
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r20
	.word 0xda4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r13
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6d423c8  ! 1: LDSHA_I	ldsha	[%r16, + 0x03c8] %asi, %r3
	.word 0xc6442f6c  ! 1: LDSW_I	ldsw	[%r16 + 0x0f6c], %r3
	brnz %r31,thr3_loop_cnt_376
	dec %r31
        mov 0x50, %r31
thr3_loop_cnt_377:
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	.word 0xd2142d44  ! 1: LDUH_I	lduh	[%r16 + 0x0d44], %r9
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xc6dc26b8  ! 1: LDXA_I	ldxa	[%r16, + 0x06b8] %asi, %r3
	.word 0xe6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r19
	.word 0xd6c422e8  ! 1: LDSWA_I	ldswa	[%r16, + 0x02e8] %asi, %r11
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r19
	.word 0xec4c2ab7  ! 1: LDSB_I	ldsb	[%r16 + 0x0ab7], %r22
	.word 0xc64c27ae  ! 1: LDSB_I	ldsb	[%r16 + 0x07ae], %r3
	brnz %r31,thr3_loop_cnt_377
	dec %r31
	.word 0x86342db4  ! 1: SUBC_I	orn 	%r16, 0x0db4, %r3
	.word 0x86142b14  ! 1: OR_I	or 	%r16, 0x0b14, %r3
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0x28, %r31
thr3_loop_cnt_378:
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xc6542fea  ! 1: LDSH_I	ldsh	[%r16 + 0x0fea], %r3
	.word 0xded42002  ! 1: LDSHA_I	ldsha	[%r16, + 0x0002] %asi, %r15
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf0542b30  ! 1: LDSH_I	ldsh	[%r16 + 0x0b30], %r24
	.word 0xccd42900  ! 1: LDSHA_I	ldsha	[%r16, + 0x0900] %asi, %r6
	.word 0xc69425ec  ! 1: LDUHA_I	lduha	[%r16, + 0x05ec] %asi, %r3
	brnz %r31,thr3_loop_cnt_378
	dec %r31
        mov 0x43, %r31
thr3_loop_cnt_379:
	.word 0xd45c22c8  ! 1: LDX_I	ldx	[%r16 + 0x02c8], %r10
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf6942ac0  ! 1: LDUHA_I	lduha	[%r16, + 0x0ac0] %asi, %r27
	.word 0xc614297e  ! 1: LDUH_I	lduh	[%r16 + 0x097e], %r3
	.word 0xc6842490  ! 1: LDUWA_I	lduwa	[%r16, + 0x0490] %asi, %r3
	.word 0xe44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r18
	.word 0xe65423d2  ! 1: LDSH_I	ldsh	[%r16 + 0x03d2], %r19
	.word 0xec440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r22
	.word 0xc6cc27e8  ! 1: LDSBA_I	ldsba	[%r16, + 0x07e8] %asi, %r3
	brnz %r31,thr3_loop_cnt_379
	dec %r31
	.word 0xae340002  ! 1: ORN_R	orn 	%r16, %r2, %r23
	.word 0xbd3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r30
	.word 0xa92c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r20
	.word 0xa21c0002  ! 1: XOR_R	xor 	%r16, %r2, %r17
        mov 0x7f, %r31
thr3_loop_cnt_380:
	.word 0xf0d42084  ! 1: LDSHA_I	ldsha	[%r16, + 0x0084] %asi, %r24
	.word 0xeecc2a7b  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a7b] %asi, %r23
	.word 0xc6542176  ! 1: LDSH_I	ldsh	[%r16 + 0x0176], %r3
	.word 0xc64c247f  ! 1: LDSB_I	ldsb	[%r16 + 0x047f], %r3
	.word 0xc65c2f10  ! 1: LDX_I	ldx	[%r16 + 0x0f10], %r3
	.word 0xf88c259f  ! 1: LDUBA_I	lduba	[%r16, + 0x059f] %asi, %r28
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xdec424a4  ! 1: LDSWA_I	ldswa	[%r16, + 0x04a4] %asi, %r15
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6442a70  ! 1: LDSW_I	ldsw	[%r16 + 0x0a70], %r3
	brnz %r31,thr3_loop_cnt_380
	dec %r31
        mov 0x9e, %r31
thr3_loop_cnt_381:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r11
	.word 0xcc5c20f8  ! 1: LDX_I	ldx	[%r16 + 0x00f8], %r6
	.word 0xe4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r18
	.word 0xda842900  ! 1: LDUWA_I	lduwa	[%r16, + 0x0900] %asi, %r13
	.word 0xf61426c0  ! 1: LDUH_I	lduh	[%r16 + 0x06c0], %r27
	.word 0xf2c4278c  ! 1: LDSWA_I	ldswa	[%r16, + 0x078c] %asi, %r25
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xfad42158  ! 1: LDSHA_I	ldsha	[%r16, + 0x0158] %asi, %r29
	.word 0xc69421c4  ! 1: LDUHA_I	lduha	[%r16, + 0x01c4] %asi, %r3
	brnz %r31,thr3_loop_cnt_381
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x861c204b  ! 1: XOR_I	xor 	%r16, 0x004b, %r3
        mov 0x12, %r31
thr3_loop_cnt_382:
	.word 0xe4942376  ! 1: LDUHA_I	lduha	[%r16, + 0x0376] %asi, %r18
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xda0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r13
	.word 0xd40c2cce  ! 1: LDUB_I	ldub	[%r16 + 0x0cce], %r10
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xfa4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r29
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xfc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r30
	.word 0xc614280e  ! 1: LDUH_I	lduh	[%r16 + 0x080e], %r3
	.word 0xd4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r10
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe254283e  ! 1: LDSH_I	ldsh	[%r16 + 0x083e], %r17
	brnz %r31,thr3_loop_cnt_382
	dec %r31
	.word 0x863c238b  ! 1: XNOR_I	xnor 	%r16, 0x038b, %r3
	.word 0x9d340002  ! 1: SRL_R	srl 	%r16, %r2, %r14
	.word 0x9f3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r15
        mov 0xa3, %r31
thr3_loop_cnt_383:
	.word 0xfac42a28  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a28] %asi, %r29
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	.word 0xc68c287f  ! 1: LDUBA_I	lduba	[%r16, + 0x087f] %asi, %r3
	.word 0xf2c42dac  ! 1: LDSWA_I	ldswa	[%r16, + 0x0dac] %asi, %r25
	.word 0xee5c2110  ! 1: LDX_I	ldx	[%r16 + 0x0110], %r23
	.word 0xd4dc28e8  ! 1: LDXA_I	ldxa	[%r16, + 0x08e8] %asi, %r10
	.word 0xc6c42f4c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f4c] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6442238  ! 1: LDSW_I	ldsw	[%r16 + 0x0238], %r3
	brnz %r31,thr3_loop_cnt_383
	dec %r31
	.word 0xb2242dca  ! 1: SUB_I	sub 	%r16, 0x0dca, %r25
	.word 0x8c2c253c  ! 1: ANDN_I	andn 	%r16, 0x053c, %r6
	.word 0x86242dae  ! 1: SUB_I	sub 	%r16, 0x0dae, %r3
        mov 0x2e, %r31
thr3_loop_cnt_384:
	.word 0xde442544  ! 1: LDSW_I	ldsw	[%r16 + 0x0544], %r15
	.word 0xe8d42b5a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b5a] %asi, %r20
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc61424e4  ! 1: LDUH_I	lduh	[%r16 + 0x04e4], %r3
	.word 0xe2c428c4  ! 1: LDSWA_I	ldswa	[%r16, + 0x08c4] %asi, %r17
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xfa841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r29
	.word 0xc6c42ea4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ea4] %asi, %r3
	.word 0xc65c2820  ! 1: LDX_I	ldx	[%r16 + 0x0820], %r3
	.word 0xc6542ccc  ! 1: LDSH_I	ldsh	[%r16 + 0x0ccc], %r3
	.word 0xc60c2f69  ! 1: LDUB_I	ldub	[%r16 + 0x0f69], %r3
	.word 0xea040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r21
	brnz %r31,thr3_loop_cnt_384
	dec %r31
	.word 0x8634261e  ! 1: ORN_I	orn 	%r16, 0x061e, %r3
        mov 0x51, %r31
thr3_loop_cnt_385:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe6dc22d0  ! 1: LDXA_I	ldxa	[%r16, + 0x02d0] %asi, %r19
	.word 0xcecc2363  ! 1: LDSBA_I	ldsba	[%r16, + 0x0363] %asi, %r7
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xfa941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r29
	.word 0xc6842aac  ! 1: LDUWA_I	lduwa	[%r16, + 0x0aac] %asi, %r3
	.word 0xdcc42e9c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e9c] %asi, %r14
	brnz %r31,thr3_loop_cnt_385
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0xa60c2b36  ! 1: AND_I	and 	%r16, 0x0b36, %r19
        mov 0x8c, %r31
thr3_loop_cnt_386:
	.word 0xc65c2770  ! 1: LDX_I	ldx	[%r16 + 0x0770], %r3
	.word 0xc694250a  ! 1: LDUHA_I	lduha	[%r16, + 0x050a] %asi, %r3
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	.word 0xe68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r19
	.word 0xc614285c  ! 1: LDUH_I	lduh	[%r16 + 0x085c], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xea84299c  ! 1: LDUWA_I	lduwa	[%r16, + 0x099c] %asi, %r21
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_386
	dec %r31
	.word 0x9e140002  ! 1: OR_R	or 	%r16, %r2, %r15
	.word 0x9c442086  ! 1: ADDC_I	addc 	%r16, 0x0086, %r14
        mov 0x52, %r31
thr3_loop_cnt_387:
	.word 0xfc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r30
	.word 0xc65c2418  ! 1: LDX_I	ldx	[%r16 + 0x0418], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe2c42d08  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d08] %asi, %r17
	.word 0xc6042174  ! 1: LDUW_I	lduw	[%r16 + 0x0174], %r3
	.word 0xd0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r8
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe8042270  ! 1: LDUW_I	lduw	[%r16 + 0x0270], %r20
	.word 0xcc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r6
	brnz %r31,thr3_loop_cnt_387
	dec %r31
        mov 0xa2, %r31
thr3_loop_cnt_388:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd0042c34  ! 1: LDUW_I	lduw	[%r16 + 0x0c34], %r8
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe6c42544  ! 1: LDSWA_I	ldswa	[%r16, + 0x0544] %asi, %r19
	.word 0xc6542374  ! 1: LDSH_I	ldsh	[%r16 + 0x0374], %r3
	.word 0xe6942f66  ! 1: LDUHA_I	lduha	[%r16, + 0x0f66] %asi, %r19
	.word 0xc6c4204c  ! 1: LDSWA_I	ldswa	[%r16, + 0x004c] %asi, %r3
	.word 0xd4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r10
	.word 0xc6442404  ! 1: LDSW_I	ldsw	[%r16 + 0x0404], %r3
	.word 0xdcd422ac  ! 1: LDSHA_I	ldsha	[%r16, + 0x02ac] %asi, %r14
	.word 0xf2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r25
	brnz %r31,thr3_loop_cnt_388
	dec %r31
        mov 0xc0, %r31
thr3_loop_cnt_389:
	.word 0xc6c42f68  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f68] %asi, %r3
	.word 0xd2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r9
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd44427e4  ! 1: LDSW_I	ldsw	[%r16 + 0x07e4], %r10
	.word 0xe80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r20
	.word 0xde4429d0  ! 1: LDSW_I	ldsw	[%r16 + 0x09d0], %r15
	.word 0xc6c42428  ! 1: LDSWA_I	ldswa	[%r16, + 0x0428] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_389
	dec %r31
        mov 0x51, %r31
thr3_loop_cnt_390:
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd28421e4  ! 1: LDUWA_I	lduwa	[%r16, + 0x01e4] %asi, %r9
	.word 0xe65c27f0  ! 1: LDX_I	ldx	[%r16 + 0x07f0], %r19
	.word 0xf0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r24
	.word 0xc6542fc4  ! 1: LDSH_I	ldsh	[%r16 + 0x0fc4], %r3
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	.word 0xc64421f4  ! 1: LDSW_I	ldsw	[%r16 + 0x01f4], %r3
	brnz %r31,thr3_loop_cnt_390
	dec %r31
	.word 0xb4242d51  ! 1: SUB_I	sub 	%r16, 0x0d51, %r26
	.word 0x86342a1c  ! 1: SUBC_I	orn 	%r16, 0x0a1c, %r3
	.word 0x921c2771  ! 1: XOR_I	xor 	%r16, 0x0771, %r9
        mov 0x37, %r31
thr3_loop_cnt_391:
	.word 0xe84c2c42  ! 1: LDSB_I	ldsb	[%r16 + 0x0c42], %r20
	.word 0xc68c2e15  ! 1: LDUBA_I	lduba	[%r16, + 0x0e15] %asi, %r3
	.word 0xc65c20f0  ! 1: LDX_I	ldx	[%r16 + 0x00f0], %r3
	.word 0xc60c2a13  ! 1: LDUB_I	ldub	[%r16 + 0x0a13], %r3
	.word 0xc6cc2578  ! 1: LDSBA_I	ldsba	[%r16, + 0x0578] %asi, %r3
	.word 0xda941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r13
	.word 0xd0042e80  ! 1: LDUW_I	lduw	[%r16 + 0x0e80], %r8
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_391
	dec %r31
        mov 0x2d, %r31
thr3_loop_cnt_392:
	.word 0xdc9429a4  ! 1: LDUHA_I	lduha	[%r16, + 0x09a4] %asi, %r14
	.word 0xe4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r18
	.word 0xc6dc2760  ! 1: LDXA_I	ldxa	[%r16, + 0x0760] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r25
	.word 0xd0cc206a  ! 1: LDSBA_I	ldsba	[%r16, + 0x006a] %asi, %r8
	.word 0xf64c29ba  ! 1: LDSB_I	ldsb	[%r16 + 0x09ba], %r27
	.word 0xfa941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r29
	.word 0xee0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r23
	brnz %r31,thr3_loop_cnt_392
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0xa41c23fe  ! 1: XOR_I	xor 	%r16, 0x03fe, %r18
	.word 0x973c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r11
        mov 0xbe, %r31
thr3_loop_cnt_393:
	.word 0xc6dc2bc0  ! 1: LDXA_I	ldxa	[%r16, + 0x0bc0] %asi, %r3
	.word 0xc6142418  ! 1: LDUH_I	lduh	[%r16 + 0x0418], %r3
	.word 0xeadc26b0  ! 1: LDXA_I	ldxa	[%r16, + 0x06b0] %asi, %r21
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xde842a24  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a24] %asi, %r15
	.word 0xc6042a18  ! 1: LDUW_I	lduw	[%r16 + 0x0a18], %r3
	.word 0xc6842a40  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a40] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xea14247a  ! 1: LDUH_I	lduh	[%r16 + 0x047a], %r21
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_393
	dec %r31
        mov 0x84, %r31
thr3_loop_cnt_394:
	.word 0xecd42724  ! 1: LDSHA_I	ldsha	[%r16, + 0x0724] %asi, %r22
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r10
	.word 0xc6142cf0  ! 1: LDUH_I	lduh	[%r16 + 0x0cf0], %r3
	.word 0xc65428c2  ! 1: LDSH_I	ldsh	[%r16 + 0x08c2], %r3
	.word 0xf0442cec  ! 1: LDSW_I	ldsw	[%r16 + 0x0cec], %r24
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xecd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r22
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6442cac  ! 1: LDSW_I	ldsw	[%r16 + 0x0cac], %r3
	.word 0xc6442194  ! 1: LDSW_I	ldsw	[%r16 + 0x0194], %r3
	brnz %r31,thr3_loop_cnt_394
	dec %r31
	.word 0xa4442f9d  ! 1: ADDC_I	addc 	%r16, 0x0f9d, %r18
	.word 0xbc240002  ! 1: SUB_R	sub 	%r16, %r2, %r30
	.word 0x8f2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r7
	.word 0x90140002  ! 1: OR_R	or 	%r16, %r2, %r8
        mov 0x85, %r31
thr3_loop_cnt_395:
	.word 0xc6042134  ! 1: LDUW_I	lduw	[%r16 + 0x0134], %r3
	.word 0xdedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r15
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xe25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r17
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe2c42718  ! 1: LDSWA_I	ldswa	[%r16, + 0x0718] %asi, %r17
	.word 0xf6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r27
	.word 0xe6942480  ! 1: LDUHA_I	lduha	[%r16, + 0x0480] %asi, %r19
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	brnz %r31,thr3_loop_cnt_395
	dec %r31
	.word 0x860c2f47  ! 1: AND_I	and 	%r16, 0x0f47, %r3
        mov 0xd, %r31
thr3_loop_cnt_396:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf88c2495  ! 1: LDUBA_I	lduba	[%r16, + 0x0495] %asi, %r28
	.word 0xe4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r18
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xcec42b8c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b8c] %asi, %r7
	.word 0xfa941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r29
	.word 0xeac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r21
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6942b64  ! 1: LDUHA_I	lduha	[%r16, + 0x0b64] %asi, %r3
	.word 0xce44282c  ! 1: LDSW_I	ldsw	[%r16 + 0x082c], %r7
	.word 0xc65c2180  ! 1: LDX_I	ldx	[%r16 + 0x0180], %r3
	brnz %r31,thr3_loop_cnt_396
	dec %r31
	.word 0xbd2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r30
	.word 0xa6340002  ! 1: SUBC_R	orn 	%r16, %r2, %r19
        mov 0x78, %r31
thr3_loop_cnt_397:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6542e6e  ! 1: LDSH_I	ldsh	[%r16 + 0x0e6e], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xcc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r6
	.word 0xc6d42cc0  ! 1: LDSHA_I	ldsha	[%r16, + 0x0cc0] %asi, %r3
	.word 0xd2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r9
	.word 0xd85427be  ! 1: LDSH_I	ldsh	[%r16 + 0x07be], %r12
	.word 0xea942482  ! 1: LDUHA_I	lduha	[%r16, + 0x0482] %asi, %r21
	.word 0xd8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r12
	.word 0xc614208e  ! 1: LDUH_I	lduh	[%r16 + 0x008e], %r3
	.word 0xd68c2ee4  ! 1: LDUBA_I	lduba	[%r16, + 0x0ee4] %asi, %r11
	brnz %r31,thr3_loop_cnt_397
	dec %r31
	.word 0xad3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r22
        mov 0xbd, %r31
thr3_loop_cnt_398:
	.word 0xc64427fc  ! 1: LDSW_I	ldsw	[%r16 + 0x07fc], %r3
	.word 0xc65c2218  ! 1: LDX_I	ldx	[%r16 + 0x0218], %r3
	.word 0xc6c42098  ! 1: LDSWA_I	ldswa	[%r16, + 0x0098] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xcccc2f18  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f18] %asi, %r6
	.word 0xf8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r28
	.word 0xe8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r20
	.word 0xc64c2bb7  ! 1: LDSB_I	ldsb	[%r16 + 0x0bb7], %r3
	.word 0xea942092  ! 1: LDUHA_I	lduha	[%r16, + 0x0092] %asi, %r21
	brnz %r31,thr3_loop_cnt_398
	dec %r31
        mov 0xa0, %r31
thr3_loop_cnt_399:
	.word 0xc6dc26e8  ! 1: LDXA_I	ldxa	[%r16, + 0x06e8] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xfacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r29
	.word 0xc6142eee  ! 1: LDUH_I	lduh	[%r16 + 0x0eee], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc64c28fc  ! 1: LDSB_I	ldsb	[%r16 + 0x08fc], %r3
	.word 0xde4421c0  ! 1: LDSW_I	ldsw	[%r16 + 0x01c0], %r15
	.word 0xc6d42b84  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b84] %asi, %r3
	.word 0xee040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r23
	brnz %r31,thr3_loop_cnt_399
	dec %r31
	.word 0xbd343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r30
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0xbe, %r31
thr3_loop_cnt_400:
	.word 0xce5c28d0  ! 1: LDX_I	ldx	[%r16 + 0x08d0], %r7
	.word 0xd80c2852  ! 1: LDUB_I	ldub	[%r16 + 0x0852], %r12
	.word 0xdc5c2c40  ! 1: LDX_I	ldx	[%r16 + 0x0c40], %r14
	.word 0xec042094  ! 1: LDUW_I	lduw	[%r16 + 0x0094], %r22
	.word 0xc60c220b  ! 1: LDUB_I	ldub	[%r16 + 0x020b], %r3
	.word 0xc6c429b8  ! 1: LDSWA_I	ldswa	[%r16, + 0x09b8] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc68c2a3b  ! 1: LDUBA_I	lduba	[%r16, + 0x0a3b] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc68c27dc  ! 1: LDUBA_I	lduba	[%r16, + 0x07dc] %asi, %r3
	brnz %r31,thr3_loop_cnt_400
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x9e340002  ! 1: ORN_R	orn 	%r16, %r2, %r15
	.word 0xa53c0002  ! 1: SRA_R	sra 	%r16, %r2, %r18
        mov 0x2f, %r31
thr3_loop_cnt_401:
	.word 0xc65c2a08  ! 1: LDX_I	ldx	[%r16 + 0x0a08], %r3
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xc6942ba6  ! 1: LDUHA_I	lduha	[%r16, + 0x0ba6] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc60c203d  ! 1: LDUB_I	ldub	[%r16 + 0x003d], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6c422b8  ! 1: LDSWA_I	ldswa	[%r16, + 0x02b8] %asi, %r3
	.word 0xe20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r17
	brnz %r31,thr3_loop_cnt_401
	dec %r31
	.word 0x9d3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r14
	.word 0xbc1c0002  ! 1: XOR_R	xor 	%r16, %r2, %r30
	.word 0xb00c23fa  ! 1: AND_I	and 	%r16, 0x03fa, %r24
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x86, %r31
thr3_loop_cnt_402:
	.word 0xf6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r27
	.word 0xea941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r21
	.word 0xc69428c4  ! 1: LDUHA_I	lduha	[%r16, + 0x08c4] %asi, %r3
	.word 0xc6942946  ! 1: LDUHA_I	lduha	[%r16, + 0x0946] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xecc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r22
	.word 0xc69423b2  ! 1: LDUHA_I	lduha	[%r16, + 0x03b2] %asi, %r3
	.word 0xd8dc2ee0  ! 1: LDXA_I	ldxa	[%r16, + 0x0ee0] %asi, %r12
	brnz %r31,thr3_loop_cnt_402
	dec %r31
        mov 0x94, %r31
thr3_loop_cnt_403:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc61427fe  ! 1: LDUH_I	lduh	[%r16 + 0x07fe], %r3
	.word 0xe84c2f03  ! 1: LDSB_I	ldsb	[%r16 + 0x0f03], %r20
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xec442cb4  ! 1: LDSW_I	ldsw	[%r16 + 0x0cb4], %r22
	.word 0xc64c2990  ! 1: LDSB_I	ldsb	[%r16 + 0x0990], %r3
	.word 0xd25429f4  ! 1: LDSH_I	ldsh	[%r16 + 0x09f4], %r9
	.word 0xdcdc2d98  ! 1: LDXA_I	ldxa	[%r16, + 0x0d98] %asi, %r14
	brnz %r31,thr3_loop_cnt_403
	dec %r31
	.word 0x8604275f  ! 1: ADD_I	add 	%r16, 0x075f, %r3
        mov 0xa8, %r31
thr3_loop_cnt_404:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd8cc200d  ! 1: LDSBA_I	ldsba	[%r16, + 0x000d] %asi, %r12
	.word 0xc69426f0  ! 1: LDUHA_I	lduha	[%r16, + 0x06f0] %asi, %r3
	.word 0xdc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r14
	.word 0xf68c2007  ! 1: LDUBA_I	lduba	[%r16, + 0x0007] %asi, %r27
	.word 0xf8042460  ! 1: LDUW_I	lduw	[%r16 + 0x0460], %r28
	brnz %r31,thr3_loop_cnt_404
	dec %r31
	.word 0x97341002  ! 1: SRLX_R	srlx	%r16, %r2, %r11
	.word 0xb60c2aeb  ! 1: AND_I	and 	%r16, 0x0aeb, %r27
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x15, %r31
thr3_loop_cnt_405:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r28
	.word 0xd8442848  ! 1: LDSW_I	ldsw	[%r16 + 0x0848], %r12
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xdedc2418  ! 1: LDXA_I	ldxa	[%r16, + 0x0418] %asi, %r15
	.word 0xda8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r13
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xc6442084  ! 1: LDSW_I	ldsw	[%r16 + 0x0084], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6042df0  ! 1: LDUW_I	lduw	[%r16 + 0x0df0], %r3
	brnz %r31,thr3_loop_cnt_405
	dec %r31
	.word 0x9a442fbe  ! 1: ADDC_I	addc 	%r16, 0x0fbe, %r13
        mov 0xb, %r31
thr3_loop_cnt_406:
	.word 0xf2dc29c0  ! 1: LDXA_I	ldxa	[%r16, + 0x09c0] %asi, %r25
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc65c26d0  ! 1: LDX_I	ldx	[%r16 + 0x06d0], %r3
	.word 0xe4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r18
	.word 0xc6442bfc  ! 1: LDSW_I	ldsw	[%r16 + 0x0bfc], %r3
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xc6cc28f2  ! 1: LDSBA_I	ldsba	[%r16, + 0x08f2] %asi, %r3
	.word 0xe8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r20
	.word 0xc6c42c78  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c78] %asi, %r3
	.word 0xe8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r20
	.word 0xc6d42f24  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f24] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_406
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0xa41c0002  ! 1: XOR_R	xor 	%r16, %r2, %r18
	.word 0x90440002  ! 1: ADDC_R	addc 	%r16, %r2, %r8
        mov 0x88, %r31
thr3_loop_cnt_407:
	.word 0xf2c42e68  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e68] %asi, %r25
	.word 0xc68c2211  ! 1: LDUBA_I	lduba	[%r16, + 0x0211] %asi, %r3
	.word 0xdedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r15
	.word 0xfc4426c0  ! 1: LDSW_I	ldsw	[%r16 + 0x06c0], %r30
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe254250c  ! 1: LDSH_I	ldsh	[%r16 + 0x050c], %r17
	.word 0xc6cc220b  ! 1: LDSBA_I	ldsba	[%r16, + 0x020b] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6442880  ! 1: LDSW_I	ldsw	[%r16 + 0x0880], %r3
	.word 0xf80c2d50  ! 1: LDUB_I	ldub	[%r16 + 0x0d50], %r28
	brnz %r31,thr3_loop_cnt_407
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x8e242e69  ! 1: SUB_I	sub 	%r16, 0x0e69, %r7
	.word 0xa5342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r18
        mov 0x71, %r31
thr3_loop_cnt_408:
	.word 0xd08c26fd  ! 1: LDUBA_I	lduba	[%r16, + 0x06fd] %asi, %r8
	.word 0xd2cc2d7b  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d7b] %asi, %r9
	.word 0xce842b64  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b64] %asi, %r7
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd0942d48  ! 1: LDUHA_I	lduha	[%r16, + 0x0d48] %asi, %r8
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc644267c  ! 1: LDSW_I	ldsw	[%r16 + 0x067c], %r3
	.word 0xd4c42b44  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b44] %asi, %r10
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_408
	dec %r31
	.word 0x9a442fe0  ! 1: ADDC_I	addc 	%r16, 0x0fe0, %r13
        mov 0x59, %r31
thr3_loop_cnt_409:
	.word 0xdec42348  ! 1: LDSWA_I	ldswa	[%r16, + 0x0348] %asi, %r15
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	.word 0xcc5c25a8  ! 1: LDX_I	ldx	[%r16 + 0x05a8], %r6
	.word 0xf0842514  ! 1: LDUWA_I	lduwa	[%r16, + 0x0514] %asi, %r24
	.word 0xeedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r23
	.word 0xdccc2a32  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a32] %asi, %r14
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_409
	dec %r31
	.word 0x863c2048  ! 1: XNOR_I	xnor 	%r16, 0x0048, %r3
	.word 0x860c2beb  ! 1: AND_I	and 	%r16, 0x0beb, %r3
        mov 0x91, %r31
thr3_loop_cnt_410:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xccd42274  ! 1: LDSHA_I	ldsha	[%r16, + 0x0274] %asi, %r6
	.word 0xd2542344  ! 1: LDSH_I	ldsh	[%r16 + 0x0344], %r9
	.word 0xfacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r29
	.word 0xce942bce  ! 1: LDUHA_I	lduha	[%r16, + 0x0bce] %asi, %r7
	.word 0xe8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r20
	.word 0xc60422d8  ! 1: LDUW_I	lduw	[%r16 + 0x02d8], %r3
	.word 0xd644261c  ! 1: LDSW_I	ldsw	[%r16 + 0x061c], %r11
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_410
	dec %r31
        mov 0x7b, %r31
thr3_loop_cnt_411:
	.word 0xf60c2524  ! 1: LDUB_I	ldub	[%r16 + 0x0524], %r27
	.word 0xdcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r14
	.word 0xd8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r12
	.word 0xd2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r9
	.word 0xec842620  ! 1: LDUWA_I	lduwa	[%r16, + 0x0620] %asi, %r22
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xe40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r18
	.word 0xc6442ba0  ! 1: LDSW_I	ldsw	[%r16 + 0x0ba0], %r3
	.word 0xe8942156  ! 1: LDUHA_I	lduha	[%r16, + 0x0156] %asi, %r20
	.word 0xc6c42398  ! 1: LDSWA_I	ldswa	[%r16, + 0x0398] %asi, %r3
	brnz %r31,thr3_loop_cnt_411
	dec %r31
	.word 0x8f2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r7
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x35, %r31
thr3_loop_cnt_412:
	.word 0xf0842c30  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c30] %asi, %r24
	.word 0xf0442e9c  ! 1: LDSW_I	ldsw	[%r16 + 0x0e9c], %r24
	.word 0xe2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r17
	.word 0xc6c42bfc  ! 1: LDSWA_I	ldswa	[%r16, + 0x0bfc] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc69429fc  ! 1: LDUHA_I	lduha	[%r16, + 0x09fc] %asi, %r3
	.word 0xc6442a64  ! 1: LDSW_I	ldsw	[%r16 + 0x0a64], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r27
	.word 0xf4cc2ed8  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ed8] %asi, %r26
	.word 0xc68426e8  ! 1: LDUWA_I	lduwa	[%r16, + 0x06e8] %asi, %r3
	.word 0xf8c42768  ! 1: LDSWA_I	ldswa	[%r16, + 0x0768] %asi, %r28
	brnz %r31,thr3_loop_cnt_412
	dec %r31
	.word 0x860426a9  ! 1: ADD_I	add 	%r16, 0x06a9, %r3
        mov 0xb0, %r31
thr3_loop_cnt_413:
	.word 0xd4d42dc6  ! 1: LDSHA_I	ldsha	[%r16, + 0x0dc6] %asi, %r10
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6942ef6  ! 1: LDUHA_I	lduha	[%r16, + 0x0ef6] %asi, %r3
	.word 0xd0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r8
	.word 0xe84c2e21  ! 1: LDSB_I	ldsb	[%r16 + 0x0e21], %r20
	.word 0xda142b3a  ! 1: LDUH_I	lduh	[%r16 + 0x0b3a], %r13
	.word 0xd08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r8
	.word 0xde941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r15
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_413
	dec %r31
	.word 0x8e1c2e18  ! 1: XOR_I	xor 	%r16, 0x0e18, %r7
        mov 0x2d, %r31
thr3_loop_cnt_414:
	.word 0xccd42256  ! 1: LDSHA_I	ldsha	[%r16, + 0x0256] %asi, %r6
	.word 0xcecc29e2  ! 1: LDSBA_I	ldsba	[%r16, + 0x09e2] %asi, %r7
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xec142ed4  ! 1: LDUH_I	lduh	[%r16 + 0x0ed4], %r22
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xced421aa  ! 1: LDSHA_I	ldsha	[%r16, + 0x01aa] %asi, %r7
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_414
	dec %r31
	.word 0xae040002  ! 1: ADD_R	add 	%r16, %r2, %r23
	.word 0xad3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r22
	.word 0xba240002  ! 1: SUB_R	sub 	%r16, %r2, %r29
	.word 0x981c0002  ! 1: XOR_R	xor 	%r16, %r2, %r12
        mov 0x75, %r31
thr3_loop_cnt_415:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r9
	.word 0xc6942e6c  ! 1: LDUHA_I	lduha	[%r16, + 0x0e6c] %asi, %r3
	.word 0xf6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r27
	.word 0xec5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r22
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	.word 0xda8428c8  ! 1: LDUWA_I	lduwa	[%r16, + 0x08c8] %asi, %r13
	.word 0xf0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r24
	.word 0xe4d428e0  ! 1: LDSHA_I	ldsha	[%r16, + 0x08e0] %asi, %r18
	.word 0xf4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r26
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_415
	dec %r31
	.word 0x86342b07  ! 1: ORN_I	orn 	%r16, 0x0b07, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x2, %r31
thr3_loop_cnt_416:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6442ea4  ! 1: LDSW_I	ldsw	[%r16 + 0x0ea4], %r3
	.word 0xe2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r17
	.word 0xe2442718  ! 1: LDSW_I	ldsw	[%r16 + 0x0718], %r17
	.word 0xc6142e9e  ! 1: LDUH_I	lduh	[%r16 + 0x0e9e], %r3
	.word 0xea4c20b6  ! 1: LDSB_I	ldsb	[%r16 + 0x00b6], %r21
	.word 0xc60420c0  ! 1: LDUW_I	lduw	[%r16 + 0x00c0], %r3
	.word 0xf0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r24
	.word 0xc6442cb4  ! 1: LDSW_I	ldsw	[%r16 + 0x0cb4], %r3
	.word 0xeacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r21
	.word 0xc65c2f80  ! 1: LDX_I	ldx	[%r16 + 0x0f80], %r3
	brnz %r31,thr3_loop_cnt_416
	dec %r31
	.word 0xb4342f6a  ! 1: ORN_I	orn 	%r16, 0x0f6a, %r26
        mov 0x77, %r31
thr3_loop_cnt_417:
	.word 0xd08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r8
	.word 0xc65425e2  ! 1: LDSH_I	ldsh	[%r16 + 0x05e2], %r3
	.word 0xda941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r13
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe8842e6c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e6c] %asi, %r20
	.word 0xe6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r19
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xcc042114  ! 1: LDUW_I	lduw	[%r16 + 0x0114], %r6
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xc65420ec  ! 1: LDSH_I	ldsh	[%r16 + 0x00ec], %r3
	.word 0xc6542f42  ! 1: LDSH_I	ldsh	[%r16 + 0x0f42], %r3
	brnz %r31,thr3_loop_cnt_417
	dec %r31
        mov 0x20, %r31
thr3_loop_cnt_418:
	.word 0xdc4c2f35  ! 1: LDSB_I	ldsb	[%r16 + 0x0f35], %r14
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6542ac0  ! 1: LDSH_I	ldsh	[%r16 + 0x0ac0], %r3
	.word 0xf2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r25
	.word 0xd8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r12
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xec842ac4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ac4] %asi, %r22
	.word 0xd81420d8  ! 1: LDUH_I	lduh	[%r16 + 0x00d8], %r12
	brnz %r31,thr3_loop_cnt_418
	dec %r31
	.word 0x92140002  ! 1: OR_R	or 	%r16, %r2, %r9
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0xa4040002  ! 1: ADD_R	add 	%r16, %r2, %r18
        mov 0x12, %r31
thr3_loop_cnt_419:
	.word 0xc6dc26a8  ! 1: LDXA_I	ldxa	[%r16, + 0x06a8] %asi, %r3
	.word 0xc6cc29e0  ! 1: LDSBA_I	ldsba	[%r16, + 0x09e0] %asi, %r3
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	.word 0xfa5c2060  ! 1: LDX_I	ldx	[%r16 + 0x0060], %r29
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc68c2d7d  ! 1: LDUBA_I	lduba	[%r16, + 0x0d7d] %asi, %r3
	.word 0xeccc26da  ! 1: LDSBA_I	ldsba	[%r16, + 0x06da] %asi, %r22
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf2042b10  ! 1: LDUW_I	lduw	[%r16 + 0x0b10], %r25
	.word 0xdc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r14
	.word 0xde5c2778  ! 1: LDX_I	ldx	[%r16 + 0x0778], %r15
	brnz %r31,thr3_loop_cnt_419
	dec %r31
	.word 0x8624247b  ! 1: SUB_I	sub 	%r16, 0x047b, %r3
        mov 0x8c, %r31
thr3_loop_cnt_420:
	.word 0xe8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r20
	.word 0xeccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r22
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r8
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc694209e  ! 1: LDUHA_I	lduha	[%r16, + 0x009e] %asi, %r3
	.word 0xc6542f4c  ! 1: LDSH_I	ldsh	[%r16 + 0x0f4c], %r3
	.word 0xc6842578  ! 1: LDUWA_I	lduwa	[%r16, + 0x0578] %asi, %r3
	.word 0xc6dc29e8  ! 1: LDXA_I	ldxa	[%r16, + 0x09e8] %asi, %r3
	.word 0xc6842d78  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d78] %asi, %r3
	.word 0xccc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r6
	.word 0xee140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r23
	brnz %r31,thr3_loop_cnt_420
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0x20, %r31
thr3_loop_cnt_421:
	.word 0xdad42c8c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c8c] %asi, %r13
	.word 0xc64427fc  ! 1: LDSW_I	ldsw	[%r16 + 0x07fc], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc644299c  ! 1: LDSW_I	ldsw	[%r16 + 0x099c], %r3
	.word 0xec0423c4  ! 1: LDUW_I	lduw	[%r16 + 0x03c4], %r22
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d42008  ! 1: LDSHA_I	ldsha	[%r16, + 0x0008] %asi, %r3
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xf68c2984  ! 1: LDUBA_I	lduba	[%r16, + 0x0984] %asi, %r27
	.word 0xd4142e8c  ! 1: LDUH_I	lduh	[%r16 + 0x0e8c], %r10
	.word 0xc6042654  ! 1: LDUW_I	lduw	[%r16 + 0x0654], %r3
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	brnz %r31,thr3_loop_cnt_421
	dec %r31
	.word 0x8c342610  ! 1: ORN_I	orn 	%r16, 0x0610, %r6
        mov 0x6b, %r31
thr3_loop_cnt_422:
	.word 0xc6dc2908  ! 1: LDXA_I	ldxa	[%r16, + 0x0908] %asi, %r3
	.word 0xdc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r14
	.word 0xcc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r6
	.word 0xc6cc2646  ! 1: LDSBA_I	ldsba	[%r16, + 0x0646] %asi, %r3
	.word 0xd8d42c86  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c86] %asi, %r12
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xda54251c  ! 1: LDSH_I	ldsh	[%r16 + 0x051c], %r13
	.word 0xec0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r22
	.word 0xc6542bf4  ! 1: LDSH_I	ldsh	[%r16 + 0x0bf4], %r3
	brnz %r31,thr3_loop_cnt_422
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0x3b, %r31
thr3_loop_cnt_423:
	.word 0xf41426ce  ! 1: LDUH_I	lduh	[%r16 + 0x06ce], %r26
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6d420ca  ! 1: LDSHA_I	ldsha	[%r16, + 0x00ca] %asi, %r3
	.word 0xec140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r22
	.word 0xec5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r22
	.word 0xdc8c291e  ! 1: LDUBA_I	lduba	[%r16, + 0x091e] %asi, %r14
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6042c44  ! 1: LDUW_I	lduw	[%r16 + 0x0c44], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6942b30  ! 1: LDUHA_I	lduha	[%r16, + 0x0b30] %asi, %r3
	brnz %r31,thr3_loop_cnt_423
	dec %r31
	.word 0xa8440002  ! 1: ADDC_R	addc 	%r16, %r2, %r20
	.word 0x922c2f56  ! 1: ANDN_I	andn 	%r16, 0x0f56, %r9
	.word 0x972c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r11
	.word 0x9a3427ea  ! 1: ORN_I	orn 	%r16, 0x07ea, %r13
        mov 0x44, %r31
thr3_loop_cnt_424:
	.word 0xea4424b4  ! 1: LDSW_I	ldsw	[%r16 + 0x04b4], %r21
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r17
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xeccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r22
	.word 0xd8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r12
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	.word 0xf24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r25
	brnz %r31,thr3_loop_cnt_424
	dec %r31
	.word 0xa4240002  ! 1: SUB_R	sub 	%r16, %r2, %r18
	.word 0x8e0c2d98  ! 1: AND_I	and 	%r16, 0x0d98, %r7
	.word 0x90442760  ! 1: ADDC_I	addc 	%r16, 0x0760, %r8
        mov 0x53, %r31
thr3_loop_cnt_425:
	.word 0xdedc2df0  ! 1: LDXA_I	ldxa	[%r16, + 0x0df0] %asi, %r15
	.word 0xc6dc2218  ! 1: LDXA_I	ldxa	[%r16, + 0x0218] %asi, %r3
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe6cc2ac5  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ac5] %asi, %r19
	.word 0xd85429b6  ! 1: LDSH_I	ldsh	[%r16 + 0x09b6], %r12
	.word 0xc68c2eba  ! 1: LDUBA_I	lduba	[%r16, + 0x0eba] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2930  ! 1: LDXA_I	ldxa	[%r16, + 0x0930] %asi, %r3
	brnz %r31,thr3_loop_cnt_425
	dec %r31
	.word 0x9e242f34  ! 1: SUB_I	sub 	%r16, 0x0f34, %r15
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x4d, %r31
thr3_loop_cnt_426:
	.word 0xc6142d9e  ! 1: LDUH_I	lduh	[%r16 + 0x0d9e], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xde8c2986  ! 1: LDUBA_I	lduba	[%r16, + 0x0986] %asi, %r15
	.word 0xfc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r30
	.word 0xf60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r27
	.word 0xda0c2cb8  ! 1: LDUB_I	ldub	[%r16 + 0x0cb8], %r13
	.word 0xf0142396  ! 1: LDUH_I	lduh	[%r16 + 0x0396], %r24
	.word 0xee4c2524  ! 1: LDSB_I	ldsb	[%r16 + 0x0524], %r23
	.word 0xc60428ac  ! 1: LDUW_I	lduw	[%r16 + 0x08ac], %r3
	.word 0xdedc26c0  ! 1: LDXA_I	ldxa	[%r16, + 0x06c0] %asi, %r15
	.word 0xdc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r14
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_426
	dec %r31
        mov 0xaa, %r31
thr3_loop_cnt_427:
	.word 0xc6842c50  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c50] %asi, %r3
	.word 0xd4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r10
	.word 0xc6542092  ! 1: LDSH_I	ldsh	[%r16 + 0x0092], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6d42234  ! 1: LDSHA_I	ldsha	[%r16, + 0x0234] %asi, %r3
	.word 0xe6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r19
	.word 0xf0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r24
	.word 0xd05c26c0  ! 1: LDX_I	ldx	[%r16 + 0x06c0], %r8
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xdedc2408  ! 1: LDXA_I	ldxa	[%r16, + 0x0408] %asi, %r15
	.word 0xdc442908  ! 1: LDSW_I	ldsw	[%r16 + 0x0908], %r14
	.word 0xc6942de4  ! 1: LDUHA_I	lduha	[%r16, + 0x0de4] %asi, %r3
	brnz %r31,thr3_loop_cnt_427
	dec %r31
	.word 0xb80c2cb6  ! 1: AND_I	and 	%r16, 0x0cb6, %r28
	.word 0xa8140002  ! 1: OR_R	or 	%r16, %r2, %r20
        mov 0xb6, %r31
thr3_loop_cnt_428:
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	.word 0xf2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r25
	.word 0xdedc2f60  ! 1: LDXA_I	ldxa	[%r16, + 0x0f60] %asi, %r15
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc64c2223  ! 1: LDSB_I	ldsb	[%r16 + 0x0223], %r3
	.word 0xe40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r18
	.word 0xee8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r23
	.word 0xc64c2e07  ! 1: LDSB_I	ldsb	[%r16 + 0x0e07], %r3
	.word 0xc68427b8  ! 1: LDUWA_I	lduwa	[%r16, + 0x07b8] %asi, %r3
	.word 0xe6cc2377  ! 1: LDSBA_I	ldsba	[%r16, + 0x0377] %asi, %r19
	.word 0xce5c2060  ! 1: LDX_I	ldx	[%r16 + 0x0060], %r7
	brnz %r31,thr3_loop_cnt_428
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x92440002  ! 1: ADDC_R	addc 	%r16, %r2, %r9
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x6e, %r31
thr3_loop_cnt_429:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd61428f0  ! 1: LDUH_I	lduh	[%r16 + 0x08f0], %r11
	.word 0xc68427c4  ! 1: LDUWA_I	lduwa	[%r16, + 0x07c4] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc644281c  ! 1: LDSW_I	ldsw	[%r16 + 0x081c], %r3
	.word 0xc68c2139  ! 1: LDUBA_I	lduba	[%r16, + 0x0139] %asi, %r3
	brnz %r31,thr3_loop_cnt_429
	dec %r31
	.word 0xb01c20b6  ! 1: XOR_I	xor 	%r16, 0x00b6, %r24
	.word 0x92440002  ! 1: ADDC_R	addc 	%r16, %r2, %r9
	.word 0xae2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r23
        mov 0x10, %r31
thr3_loop_cnt_430:
	.word 0xc6842c0c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c0c] %asi, %r3
	.word 0xc6c42bd4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0bd4] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xf84c2df7  ! 1: LDSB_I	ldsb	[%r16 + 0x0df7], %r28
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2028  ! 1: LDXA_I	ldxa	[%r16, + 0x0028] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_430
	dec %r31
        mov 0xb1, %r31
thr3_loop_cnt_431:
	.word 0xec0c2223  ! 1: LDUB_I	ldub	[%r16 + 0x0223], %r22
	.word 0xcc0c2d7f  ! 1: LDUB_I	ldub	[%r16 + 0x0d7f], %r6
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf68c232a  ! 1: LDUBA_I	lduba	[%r16, + 0x032a] %asi, %r27
	.word 0xf6c42598  ! 1: LDSWA_I	ldswa	[%r16, + 0x0598] %asi, %r27
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf6cc2ffb  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ffb] %asi, %r27
	.word 0xd6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r11
	brnz %r31,thr3_loop_cnt_431
	dec %r31
	.word 0x90342446  ! 1: ORN_I	orn 	%r16, 0x0446, %r8
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0xa2042f2e  ! 1: ADD_I	add 	%r16, 0x0f2e, %r17
        mov 0x21, %r31
thr3_loop_cnt_432:
	.word 0xc64c27d4  ! 1: LDSB_I	ldsb	[%r16 + 0x07d4], %r3
	.word 0xce542190  ! 1: LDSH_I	ldsh	[%r16 + 0x0190], %r7
	.word 0xc654265c  ! 1: LDSH_I	ldsh	[%r16 + 0x065c], %r3
	.word 0xc6dc2da8  ! 1: LDXA_I	ldxa	[%r16, + 0x0da8] %asi, %r3
	.word 0xde5c2410  ! 1: LDX_I	ldx	[%r16 + 0x0410], %r15
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xced41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r7
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_432
	dec %r31
	.word 0xb61c2637  ! 1: XOR_I	xor 	%r16, 0x0637, %r27
	.word 0x9a440002  ! 1: ADDC_R	addc 	%r16, %r2, %r13
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x1d, %r31
thr3_loop_cnt_433:
	.word 0xc65c27f8  ! 1: LDX_I	ldx	[%r16 + 0x07f8], %r3
	.word 0xfadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r29
	.word 0xc6442460  ! 1: LDSW_I	ldsw	[%r16 + 0x0460], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r10
	.word 0xfcdc2f68  ! 1: LDXA_I	ldxa	[%r16, + 0x0f68] %asi, %r30
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xf0dc2718  ! 1: LDXA_I	ldxa	[%r16, + 0x0718] %asi, %r24
	.word 0xe4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r18
	brnz %r31,thr3_loop_cnt_433
	dec %r31
        mov 0x49, %r31
thr3_loop_cnt_434:
	.word 0xf04c27c6  ! 1: LDSB_I	ldsb	[%r16 + 0x07c6], %r24
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r8
	.word 0xfc4c2844  ! 1: LDSB_I	ldsb	[%r16 + 0x0844], %r30
	.word 0xe68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r19
	.word 0xf4c427b4  ! 1: LDSWA_I	ldswa	[%r16, + 0x07b4] %asi, %r26
	.word 0xfc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r30
	.word 0xda04226c  ! 1: LDUW_I	lduw	[%r16 + 0x026c], %r13
	brnz %r31,thr3_loop_cnt_434
	dec %r31
        mov 0x7e, %r31
thr3_loop_cnt_435:
	.word 0xee440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r23
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xda140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r13
	.word 0xe4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r18
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xee440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r23
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd44c24bb  ! 1: LDSB_I	ldsb	[%r16 + 0x04bb], %r10
	brnz %r31,thr3_loop_cnt_435
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0xb33c1002  ! 1: SRAX_R	srax	%r16, %r2, %r25
	.word 0x86142569  ! 1: OR_I	or 	%r16, 0x0569, %r3
	.word 0x92140002  ! 1: OR_R	or 	%r16, %r2, %r9
        mov 0x16, %r31
thr3_loop_cnt_436:
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc60c2f36  ! 1: LDUB_I	ldub	[%r16 + 0x0f36], %r3
	.word 0xec841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r22
	.word 0xd4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r10
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xce5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r7
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_436
	dec %r31
	.word 0x9a240002  ! 1: SUB_R	sub 	%r16, %r2, %r13
	.word 0xb33c1002  ! 1: SRAX_R	srax	%r16, %r2, %r25
	.word 0x8c3c20b0  ! 1: XNOR_I	xnor 	%r16, 0x00b0, %r6
        mov 0x43, %r31
thr3_loop_cnt_437:
	.word 0xc68422a4  ! 1: LDUWA_I	lduwa	[%r16, + 0x02a4] %asi, %r3
	.word 0xc6cc2aa3  ! 1: LDSBA_I	ldsba	[%r16, + 0x0aa3] %asi, %r3
	.word 0xc6d427bc  ! 1: LDSHA_I	ldsha	[%r16, + 0x07bc] %asi, %r3
	.word 0xc6c42144  ! 1: LDSWA_I	ldswa	[%r16, + 0x0144] %asi, %r3
	.word 0xc6842ce8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ce8] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6842620  ! 1: LDUWA_I	lduwa	[%r16, + 0x0620] %asi, %r3
	.word 0xc68c2dca  ! 1: LDUBA_I	lduba	[%r16, + 0x0dca] %asi, %r3
	brnz %r31,thr3_loop_cnt_437
	dec %r31
	.word 0x8c0c22a2  ! 1: AND_I	and 	%r16, 0x02a2, %r6
        mov 0x5a, %r31
thr3_loop_cnt_438:
	.word 0xfa4c240c  ! 1: LDSB_I	ldsb	[%r16 + 0x040c], %r29
	.word 0xd48c20e6  ! 1: LDUBA_I	lduba	[%r16, + 0x00e6] %asi, %r10
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf41420a2  ! 1: LDUH_I	lduh	[%r16 + 0x00a2], %r26
	.word 0xf85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r28
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2e40  ! 1: LDXA_I	ldxa	[%r16, + 0x0e40] %asi, %r3
	.word 0xf68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r27
	.word 0xc6dc2888  ! 1: LDXA_I	ldxa	[%r16, + 0x0888] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6dc2be0  ! 1: LDXA_I	ldxa	[%r16, + 0x0be0] %asi, %r3
	.word 0xf24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r25
	brnz %r31,thr3_loop_cnt_438
	dec %r31
	.word 0xbb341002  ! 1: SRLX_R	srlx	%r16, %r2, %r29
	.word 0xa8440002  ! 1: ADDC_R	addc 	%r16, %r2, %r20
	.word 0x972c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r11
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x7c, %r31
thr3_loop_cnt_439:
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	.word 0xc6c42728  ! 1: LDSWA_I	ldswa	[%r16, + 0x0728] %asi, %r3
	.word 0xc6d4205c  ! 1: LDSHA_I	ldsha	[%r16, + 0x005c] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xe68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r19
	.word 0xc6dc2230  ! 1: LDXA_I	ldxa	[%r16, + 0x0230] %asi, %r3
	.word 0xce040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r7
	.word 0xdc4c2f66  ! 1: LDSB_I	ldsb	[%r16 + 0x0f66], %r14
	brnz %r31,thr3_loop_cnt_439
	dec %r31
	.word 0xb7343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r27
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0xb01c0002  ! 1: XOR_R	xor 	%r16, %r2, %r24
	.word 0x9d3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r14
        mov 0x48, %r31
thr3_loop_cnt_440:
	.word 0xc6d42c4a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c4a] %asi, %r3
	.word 0xf4cc28cf  ! 1: LDSBA_I	ldsba	[%r16, + 0x08cf] %asi, %r26
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xda4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r13
	.word 0xf20c264f  ! 1: LDUB_I	ldub	[%r16 + 0x064f], %r25
	.word 0xdac42174  ! 1: LDSWA_I	ldswa	[%r16, + 0x0174] %asi, %r13
	.word 0xe2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r17
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_440
	dec %r31
	.word 0x942c2dd0  ! 1: ANDN_I	andn 	%r16, 0x0dd0, %r10
        mov 0xb4, %r31
thr3_loop_cnt_441:
	.word 0xf85c2d30  ! 1: LDX_I	ldx	[%r16 + 0x0d30], %r28
	.word 0xf8d428ac  ! 1: LDSHA_I	ldsha	[%r16, + 0x08ac] %asi, %r28
	.word 0xf8cc208a  ! 1: LDSBA_I	ldsba	[%r16, + 0x008a] %asi, %r28
	.word 0xc68c254e  ! 1: LDUBA_I	lduba	[%r16, + 0x054e] %asi, %r3
	.word 0xe85c2560  ! 1: LDX_I	ldx	[%r16 + 0x0560], %r20
	.word 0xd4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r10
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6d42dba  ! 1: LDSHA_I	ldsha	[%r16, + 0x0dba] %asi, %r3
	brnz %r31,thr3_loop_cnt_441
	dec %r31
	.word 0x86242163  ! 1: SUB_I	sub 	%r16, 0x0163, %r3
	.word 0x86342774  ! 1: ORN_I	orn 	%r16, 0x0774, %r3
        mov 0x66, %r31
thr3_loop_cnt_442:
	.word 0xd644212c  ! 1: LDSW_I	ldsw	[%r16 + 0x012c], %r11
	.word 0xccd423fe  ! 1: LDSHA_I	ldsha	[%r16, + 0x03fe] %asi, %r6
	.word 0xc6c423dc  ! 1: LDSWA_I	ldswa	[%r16, + 0x03dc] %asi, %r3
	.word 0xf4042a5c  ! 1: LDUW_I	lduw	[%r16 + 0x0a5c], %r26
	.word 0xf4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r26
	.word 0xc64c23a0  ! 1: LDSB_I	ldsb	[%r16 + 0x03a0], %r3
	.word 0xe25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r17
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xea042e58  ! 1: LDUW_I	lduw	[%r16 + 0x0e58], %r21
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_442
	dec %r31
	.word 0x973c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r11
        mov 0x11, %r31
thr3_loop_cnt_443:
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	.word 0xd8442958  ! 1: LDSW_I	ldsw	[%r16 + 0x0958], %r12
	.word 0xd8942d50  ! 1: LDUHA_I	lduha	[%r16, + 0x0d50] %asi, %r12
	.word 0xc68c2a18  ! 1: LDUBA_I	lduba	[%r16, + 0x0a18] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2a38  ! 1: LDXA_I	ldxa	[%r16, + 0x0a38] %asi, %r3
	.word 0xc6542832  ! 1: LDSH_I	ldsh	[%r16 + 0x0832], %r3
	.word 0xdad428d8  ! 1: LDSHA_I	ldsha	[%r16, + 0x08d8] %asi, %r13
	.word 0xf80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r28
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_443
	dec %r31
	.word 0xb4440002  ! 1: ADDC_R	addc 	%r16, %r2, %r26
        mov 0x60, %r31
thr3_loop_cnt_444:
	.word 0xe68c2c06  ! 1: LDUBA_I	lduba	[%r16, + 0x0c06] %asi, %r19
	.word 0xc6d42f10  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f10] %asi, %r3
	.word 0xc6042200  ! 1: LDUW_I	lduw	[%r16 + 0x0200], %r3
	.word 0xe85c2e58  ! 1: LDX_I	ldx	[%r16 + 0x0e58], %r20
	.word 0xc6d4248e  ! 1: LDSHA_I	ldsha	[%r16, + 0x048e] %asi, %r3
	.word 0xc6d42620  ! 1: LDSHA_I	ldsha	[%r16, + 0x0620] %asi, %r3
	.word 0xc614201c  ! 1: LDUH_I	lduh	[%r16 + 0x001c], %r3
	.word 0xe8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r20
	.word 0xc6c42c10  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c10] %asi, %r3
	.word 0xfcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r30
	.word 0xd4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r10
	.word 0xce0c2bea  ! 1: LDUB_I	ldub	[%r16 + 0x0bea], %r7
	brnz %r31,thr3_loop_cnt_444
	dec %r31
        mov 0x68, %r31
thr3_loop_cnt_445:
	.word 0xf0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r24
	.word 0xc60c2217  ! 1: LDUB_I	ldub	[%r16 + 0x0217], %r3
	.word 0xf64c28e2  ! 1: LDSB_I	ldsb	[%r16 + 0x08e2], %r27
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	.word 0xd44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r10
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf65c2e80  ! 1: LDX_I	ldx	[%r16 + 0x0e80], %r27
	.word 0xce0c22d7  ! 1: LDUB_I	ldub	[%r16 + 0x02d7], %r7
	.word 0xde542894  ! 1: LDSH_I	ldsh	[%r16 + 0x0894], %r15
	.word 0xe2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r17
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe68420f8  ! 1: LDUWA_I	lduwa	[%r16, + 0x00f8] %asi, %r19
	brnz %r31,thr3_loop_cnt_445
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x9e340002  ! 1: SUBC_R	orn 	%r16, %r2, %r15
        mov 0x41, %r31
thr3_loop_cnt_446:
	.word 0xe4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r18
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf854217e  ! 1: LDSH_I	ldsh	[%r16 + 0x017e], %r28
	.word 0xee8c2b7c  ! 1: LDUBA_I	lduba	[%r16, + 0x0b7c] %asi, %r23
	.word 0xf0d42428  ! 1: LDSHA_I	ldsha	[%r16, + 0x0428] %asi, %r24
	.word 0xe6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r19
	.word 0xde042990  ! 1: LDUW_I	lduw	[%r16 + 0x0990], %r15
	.word 0xcc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r6
	.word 0xde842b0c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b0c] %asi, %r15
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_446
	dec %r31
	.word 0xad342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r22
        mov 0x76, %r31
thr3_loop_cnt_447:
	.word 0xf04c209a  ! 1: LDSB_I	ldsb	[%r16 + 0x009a], %r24
	.word 0xc6542402  ! 1: LDSH_I	ldsh	[%r16 + 0x0402], %r3
	.word 0xdc8421e0  ! 1: LDUWA_I	lduwa	[%r16, + 0x01e0] %asi, %r14
	.word 0xd4dc2218  ! 1: LDXA_I	ldxa	[%r16, + 0x0218] %asi, %r10
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc69425e0  ! 1: LDUHA_I	lduha	[%r16, + 0x05e0] %asi, %r3
	.word 0xc6cc22bc  ! 1: LDSBA_I	ldsba	[%r16, + 0x02bc] %asi, %r3
	.word 0xf8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r28
	.word 0xf8842578  ! 1: LDUWA_I	lduwa	[%r16, + 0x0578] %asi, %r28
	.word 0xcecc2dfa  ! 1: LDSBA_I	ldsba	[%r16, + 0x0dfa] %asi, %r7
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	brnz %r31,thr3_loop_cnt_447
	dec %r31
	.word 0xae040002  ! 1: ADD_R	add 	%r16, %r2, %r23
	.word 0x9a240002  ! 1: SUB_R	sub 	%r16, %r2, %r13
        mov 0x82, %r31
thr3_loop_cnt_448:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc68425b4  ! 1: LDUWA_I	lduwa	[%r16, + 0x05b4] %asi, %r3
	.word 0xc6442b10  ! 1: LDSW_I	ldsw	[%r16 + 0x0b10], %r3
	.word 0xd084270c  ! 1: LDUWA_I	lduwa	[%r16, + 0x070c] %asi, %r8
	.word 0xd2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r9
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6d42604  ! 1: LDSHA_I	ldsha	[%r16, + 0x0604] %asi, %r3
	.word 0xc6dc2f78  ! 1: LDXA_I	ldxa	[%r16, + 0x0f78] %asi, %r3
	.word 0xdc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r14
	brnz %r31,thr3_loop_cnt_448
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0xb2442582  ! 1: ADDC_I	addc 	%r16, 0x0582, %r25
        mov 0x5b, %r31
thr3_loop_cnt_449:
	.word 0xde5c26b8  ! 1: LDX_I	ldx	[%r16 + 0x06b8], %r15
	.word 0xf04429d8  ! 1: LDSW_I	ldsw	[%r16 + 0x09d8], %r24
	.word 0xc64420b8  ! 1: LDSW_I	ldsw	[%r16 + 0x00b8], %r3
	.word 0xc6542312  ! 1: LDSH_I	ldsh	[%r16 + 0x0312], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xdc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r14
	.word 0xeadc2138  ! 1: LDXA_I	ldxa	[%r16, + 0x0138] %asi, %r21
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd4142ff2  ! 1: LDUH_I	lduh	[%r16 + 0x0ff2], %r10
	.word 0xec5c2978  ! 1: LDX_I	ldx	[%r16 + 0x0978], %r22
	brnz %r31,thr3_loop_cnt_449
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0xbd2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r30
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x961c0002  ! 1: XOR_R	xor 	%r16, %r2, %r11
        mov 0x7, %r31
thr3_loop_cnt_450:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc64c29f7  ! 1: LDSB_I	ldsb	[%r16 + 0x09f7], %r3
	.word 0xcc442294  ! 1: LDSW_I	ldsw	[%r16 + 0x0294], %r6
	.word 0xc6d4214e  ! 1: LDSHA_I	ldsha	[%r16, + 0x014e] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6842b54  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b54] %asi, %r3
	.word 0xc68424f8  ! 1: LDUWA_I	lduwa	[%r16, + 0x04f8] %asi, %r3
	.word 0xcc5c2e18  ! 1: LDX_I	ldx	[%r16 + 0x0e18], %r6
	.word 0xc68c27e6  ! 1: LDUBA_I	lduba	[%r16, + 0x07e6] %asi, %r3
	brnz %r31,thr3_loop_cnt_450
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x9e042826  ! 1: ADD_I	add 	%r16, 0x0826, %r15
	.word 0x8634207d  ! 1: SUBC_I	orn 	%r16, 0x007d, %r3
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0xb1, %r31
thr3_loop_cnt_451:
	.word 0xc6042b7c  ! 1: LDUW_I	lduw	[%r16 + 0x0b7c], %r3
	.word 0xf4942c56  ! 1: LDUHA_I	lduha	[%r16, + 0x0c56] %asi, %r26
	.word 0xc60c2593  ! 1: LDUB_I	ldub	[%r16 + 0x0593], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc68c22e9  ! 1: LDUBA_I	lduba	[%r16, + 0x02e9] %asi, %r3
	.word 0xcccc2460  ! 1: LDSBA_I	ldsba	[%r16, + 0x0460] %asi, %r6
	.word 0xec5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r22
	.word 0xd0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r8
	.word 0xd014234c  ! 1: LDUH_I	lduh	[%r16 + 0x034c], %r8
	.word 0xcc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r6
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r10
	brnz %r31,thr3_loop_cnt_451
	dec %r31
	.word 0x9e240002  ! 1: SUB_R	sub 	%r16, %r2, %r15
	.word 0xb23c2bcf  ! 1: XNOR_I	xnor 	%r16, 0x0bcf, %r25
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0x54, %r31
thr3_loop_cnt_452:
	.word 0xc6d42e40  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e40] %asi, %r3
	.word 0xfcdc21e0  ! 1: LDXA_I	ldxa	[%r16, + 0x01e0] %asi, %r30
	.word 0xd444282c  ! 1: LDSW_I	ldsw	[%r16 + 0x082c], %r10
	.word 0xc6042c78  ! 1: LDUW_I	lduw	[%r16 + 0x0c78], %r3
	.word 0xc6142ede  ! 1: LDUH_I	lduh	[%r16 + 0x0ede], %r3
	.word 0xc6dc2ff0  ! 1: LDXA_I	ldxa	[%r16, + 0x0ff0] %asi, %r3
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	.word 0xd844264c  ! 1: LDSW_I	ldsw	[%r16 + 0x064c], %r12
	.word 0xde4c2325  ! 1: LDSB_I	ldsb	[%r16 + 0x0325], %r15
	.word 0xcc4c21f9  ! 1: LDSB_I	ldsb	[%r16 + 0x01f9], %r6
	.word 0xe4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r18
	.word 0xe68c212c  ! 1: LDUBA_I	lduba	[%r16, + 0x012c] %asi, %r19
	brnz %r31,thr3_loop_cnt_452
	dec %r31
        mov 0x63, %r31
thr3_loop_cnt_453:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xdc0c2800  ! 1: LDUB_I	ldub	[%r16 + 0x0800], %r14
	.word 0xd4042828  ! 1: LDUW_I	lduw	[%r16 + 0x0828], %r10
	.word 0xfa5425d0  ! 1: LDSH_I	ldsh	[%r16 + 0x05d0], %r29
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xee841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r23
	.word 0xfa4c23d8  ! 1: LDSB_I	ldsb	[%r16 + 0x03d8], %r29
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xde140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r15
	.word 0xdcc428c8  ! 1: LDSWA_I	ldswa	[%r16, + 0x08c8] %asi, %r14
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	brnz %r31,thr3_loop_cnt_453
	dec %r31
	.word 0x8c3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r6
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0x65, %r31
thr3_loop_cnt_454:
	.word 0xc65c21a8  ! 1: LDX_I	ldx	[%r16 + 0x01a8], %r3
	.word 0xde842c40  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c40] %asi, %r15
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6d42792  ! 1: LDSHA_I	ldsha	[%r16, + 0x0792] %asi, %r3
	.word 0xccc4293c  ! 1: LDSWA_I	ldswa	[%r16, + 0x093c] %asi, %r6
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6542cee  ! 1: LDSH_I	ldsh	[%r16 + 0x0cee], %r3
	brnz %r31,thr3_loop_cnt_454
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x8c340002  ! 1: SUBC_R	orn 	%r16, %r2, %r6
	.word 0xaf2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r23
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x47, %r31
thr3_loop_cnt_455:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6942ec2  ! 1: LDUHA_I	lduha	[%r16, + 0x0ec2] %asi, %r3
	.word 0xc6842efc  ! 1: LDUWA_I	lduwa	[%r16, + 0x0efc] %asi, %r3
	.word 0xdc042c44  ! 1: LDUW_I	lduw	[%r16 + 0x0c44], %r14
	.word 0xc6c42910  ! 1: LDSWA_I	ldswa	[%r16, + 0x0910] %asi, %r3
	.word 0xde0c2c89  ! 1: LDUB_I	ldub	[%r16 + 0x0c89], %r15
	.word 0xf0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r24
	.word 0xc6042cbc  ! 1: LDUW_I	lduw	[%r16 + 0x0cbc], %r3
	brnz %r31,thr3_loop_cnt_455
	dec %r31
	.word 0xa53c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r18
        mov 0x16, %r31
thr3_loop_cnt_456:
	.word 0xd28c2666  ! 1: LDUBA_I	lduba	[%r16, + 0x0666] %asi, %r9
	.word 0xc6142d0e  ! 1: LDUH_I	lduh	[%r16 + 0x0d0e], %r3
	.word 0xd8d4222c  ! 1: LDSHA_I	ldsha	[%r16, + 0x022c] %asi, %r12
	.word 0xce440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r7
	.word 0xd28c25d0  ! 1: LDUBA_I	lduba	[%r16, + 0x05d0] %asi, %r9
	.word 0xc6d42a6e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a6e] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf04c203a  ! 1: LDSB_I	ldsb	[%r16 + 0x003a], %r24
	.word 0xc6d42842  ! 1: LDSHA_I	ldsha	[%r16, + 0x0842] %asi, %r3
	.word 0xc68425f0  ! 1: LDUWA_I	lduwa	[%r16, + 0x05f0] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_456
	dec %r31
	.word 0x9b3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r13
        mov 0x57, %r31
thr3_loop_cnt_457:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xee4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r23
	.word 0xc6dc2d28  ! 1: LDXA_I	ldxa	[%r16, + 0x0d28] %asi, %r3
	.word 0xc68427a8  ! 1: LDUWA_I	lduwa	[%r16, + 0x07a8] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf81429be  ! 1: LDUH_I	lduh	[%r16 + 0x09be], %r28
	.word 0xc6dc2830  ! 1: LDXA_I	ldxa	[%r16, + 0x0830] %asi, %r3
	.word 0xdc842838  ! 1: LDUWA_I	lduwa	[%r16, + 0x0838] %asi, %r14
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_457
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0xb63428dd  ! 1: ORN_I	orn 	%r16, 0x08dd, %r27
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0xb7342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r27
        mov 0x7a, %r31
thr3_loop_cnt_458:
	.word 0xec542218  ! 1: LDSH_I	ldsh	[%r16 + 0x0218], %r22
	.word 0xc68c21ca  ! 1: LDUBA_I	lduba	[%r16, + 0x01ca] %asi, %r3
	.word 0xfcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r30
	.word 0xde941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r15
	.word 0xc68c2721  ! 1: LDUBA_I	lduba	[%r16, + 0x0721] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2de0  ! 1: LDXA_I	ldxa	[%r16, + 0x0de0] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_458
	dec %r31
	.word 0x943c2dac  ! 1: XNOR_I	xnor 	%r16, 0x0dac, %r10
	.word 0xb414258f  ! 1: OR_I	or 	%r16, 0x058f, %r26
	.word 0x86042ca0  ! 1: ADD_I	add 	%r16, 0x0ca0, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x80, %r31
thr3_loop_cnt_459:
	.word 0xc6dc2448  ! 1: LDXA_I	ldxa	[%r16, + 0x0448] %asi, %r3
	.word 0xde142ffc  ! 1: LDUH_I	lduh	[%r16 + 0x0ffc], %r15
	.word 0xc6cc2f87  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f87] %asi, %r3
	.word 0xeedc2040  ! 1: LDXA_I	ldxa	[%r16, + 0x0040] %asi, %r23
	.word 0xfa4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r29
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc64425cc  ! 1: LDSW_I	ldsw	[%r16 + 0x05cc], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xe6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r19
	.word 0xde142374  ! 1: LDUH_I	lduh	[%r16 + 0x0374], %r15
	brnz %r31,thr3_loop_cnt_459
	dec %r31
	.word 0x860c2a4d  ! 1: AND_I	and 	%r16, 0x0a4d, %r3
	.word 0xa81c2b8a  ! 1: XOR_I	xor 	%r16, 0x0b8a, %r20
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0xb81c0002  ! 1: XOR_R	xor 	%r16, %r2, %r28
        mov 0x5c, %r31
thr3_loop_cnt_460:
	.word 0xfc142db6  ! 1: LDUH_I	lduh	[%r16 + 0x0db6], %r30
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe484221c  ! 1: LDUWA_I	lduwa	[%r16, + 0x021c] %asi, %r18
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc64c2f4d  ! 1: LDSB_I	ldsb	[%r16 + 0x0f4d], %r3
	.word 0xfa540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r29
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc60423e0  ! 1: LDUW_I	lduw	[%r16 + 0x03e0], %r3
	.word 0xc60c2ef5  ! 1: LDUB_I	ldub	[%r16 + 0x0ef5], %r3
	.word 0xc6d426ba  ! 1: LDSHA_I	ldsha	[%r16, + 0x06ba] %asi, %r3
	.word 0xd604228c  ! 1: LDUW_I	lduw	[%r16 + 0x028c], %r11
	.word 0xecdc2130  ! 1: LDXA_I	ldxa	[%r16, + 0x0130] %asi, %r22
	brnz %r31,thr3_loop_cnt_460
	dec %r31
        mov 0x2e, %r31
thr3_loop_cnt_461:
	.word 0xc65427da  ! 1: LDSH_I	ldsh	[%r16 + 0x07da], %r3
	.word 0xc614265a  ! 1: LDUH_I	lduh	[%r16 + 0x065a], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xcc142c3a  ! 1: LDUH_I	lduh	[%r16 + 0x0c3a], %r6
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc64423f8  ! 1: LDSW_I	ldsw	[%r16 + 0x03f8], %r3
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	brnz %r31,thr3_loop_cnt_461
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0xa7341002  ! 1: SRLX_R	srlx	%r16, %r2, %r19
        mov 0x52, %r31
thr3_loop_cnt_462:
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	.word 0xcc4422e4  ! 1: LDSW_I	ldsw	[%r16 + 0x02e4], %r6
	.word 0xc69428ac  ! 1: LDUHA_I	lduha	[%r16, + 0x08ac] %asi, %r3
	.word 0xc6c42d04  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d04] %asi, %r3
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	.word 0xded42e04  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e04] %asi, %r15
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r11
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd20423a8  ! 1: LDUW_I	lduw	[%r16 + 0x03a8], %r9
	brnz %r31,thr3_loop_cnt_462
	dec %r31
	.word 0x862c2b9f  ! 1: ANDN_I	andn 	%r16, 0x0b9f, %r3
        mov 0x92, %r31
thr3_loop_cnt_463:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6042ef4  ! 1: LDUW_I	lduw	[%r16 + 0x0ef4], %r3
	.word 0xf28c2ea3  ! 1: LDUBA_I	lduba	[%r16, + 0x0ea3] %asi, %r25
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xdcd42a52  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a52] %asi, %r14
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc68c2e5a  ! 1: LDUBA_I	lduba	[%r16, + 0x0e5a] %asi, %r3
	.word 0xf6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r27
	.word 0xc65421bc  ! 1: LDSH_I	ldsh	[%r16 + 0x01bc], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_463
	dec %r31
        mov 0x93, %r31
thr3_loop_cnt_464:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe2c42e64  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e64] %asi, %r17
	.word 0xc60c2381  ! 1: LDUB_I	ldub	[%r16 + 0x0381], %r3
	.word 0xccdc2e78  ! 1: LDXA_I	ldxa	[%r16, + 0x0e78] %asi, %r6
	.word 0xc6042748  ! 1: LDUW_I	lduw	[%r16 + 0x0748], %r3
	.word 0xc6d420b4  ! 1: LDSHA_I	ldsha	[%r16, + 0x00b4] %asi, %r3
	.word 0xf6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r27
	.word 0xf4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r26
	.word 0xe4dc2240  ! 1: LDXA_I	ldxa	[%r16, + 0x0240] %asi, %r18
	.word 0xcc5c2d00  ! 1: LDX_I	ldx	[%r16 + 0x0d00], %r6
	.word 0xc6c42d4c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d4c] %asi, %r3
	brnz %r31,thr3_loop_cnt_464
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x861c2298  ! 1: XOR_I	xor 	%r16, 0x0298, %r3
        mov 0xbd, %r31
thr3_loop_cnt_465:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xdc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r14
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe6542ea6  ! 1: LDSH_I	ldsh	[%r16 + 0x0ea6], %r19
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd4542744  ! 1: LDSH_I	ldsh	[%r16 + 0x0744], %r10
	.word 0xf08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r24
	brnz %r31,thr3_loop_cnt_465
	dec %r31
	.word 0x98340002  ! 1: ORN_R	orn 	%r16, %r2, %r12
	.word 0x9a2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r13
        mov 0xab, %r31
thr3_loop_cnt_466:
	.word 0xc6d4272c  ! 1: LDSHA_I	ldsha	[%r16, + 0x072c] %asi, %r3
	.word 0xdc4424d4  ! 1: LDSW_I	ldsw	[%r16 + 0x04d4], %r14
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6842d60  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d60] %asi, %r3
	.word 0xc6042a30  ! 1: LDUW_I	lduw	[%r16 + 0x0a30], %r3
	.word 0xc6cc2060  ! 1: LDSBA_I	ldsba	[%r16, + 0x0060] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xdc042764  ! 1: LDUW_I	lduw	[%r16 + 0x0764], %r14
	brnz %r31,thr3_loop_cnt_466
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0x2b, %r31
thr3_loop_cnt_467:
	.word 0xc64c2828  ! 1: LDSB_I	ldsb	[%r16 + 0x0828], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	.word 0xc6c42f10  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f10] %asi, %r3
	.word 0xf0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r24
	.word 0xee4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r23
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc64420d8  ! 1: LDSW_I	ldsw	[%r16 + 0x00d8], %r3
	.word 0xd2842cb0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0cb0] %asi, %r9
	.word 0xc60c29d7  ! 1: LDUB_I	ldub	[%r16 + 0x09d7], %r3
	.word 0xd4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r10
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_467
	dec %r31
	.word 0xbc1c2d89  ! 1: XOR_I	xor 	%r16, 0x0d89, %r30
	.word 0x8f340002  ! 1: SRL_R	srl 	%r16, %r2, %r7
	.word 0x99342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r12
	.word 0xb13c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r24
        mov 0x7b, %r31
thr3_loop_cnt_468:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc65c2b20  ! 1: LDX_I	ldx	[%r16 + 0x0b20], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6cc2f63  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f63] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r17
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf04423c8  ! 1: LDSW_I	ldsw	[%r16 + 0x03c8], %r24
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_468
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0xb42c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r26
	.word 0x9d3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r14
        mov 0x31, %r31
thr3_loop_cnt_469:
	.word 0xc65c20c0  ! 1: LDX_I	ldx	[%r16 + 0x00c0], %r3
	.word 0xcc4c2c60  ! 1: LDSB_I	ldsb	[%r16 + 0x0c60], %r6
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6942d14  ! 1: LDUHA_I	lduha	[%r16, + 0x0d14] %asi, %r3
	.word 0xc6142382  ! 1: LDUH_I	lduh	[%r16 + 0x0382], %r3
	.word 0xde5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r15
	.word 0xc68c2b3c  ! 1: LDUBA_I	lduba	[%r16, + 0x0b3c] %asi, %r3
	.word 0xec5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r22
	.word 0xd28c2948  ! 1: LDUBA_I	lduba	[%r16, + 0x0948] %asi, %r9
	brnz %r31,thr3_loop_cnt_469
	dec %r31
	.word 0x952c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r10
	.word 0x93342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r9
        mov 0x54, %r31
thr3_loop_cnt_470:
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	.word 0xc64c204a  ! 1: LDSB_I	ldsb	[%r16 + 0x004a], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6d4238c  ! 1: LDSHA_I	ldsha	[%r16, + 0x038c] %asi, %r3
	.word 0xc6c42534  ! 1: LDSWA_I	ldswa	[%r16, + 0x0534] %asi, %r3
	.word 0xf65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r27
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r28
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xe6cc207e  ! 1: LDSBA_I	ldsba	[%r16, + 0x007e] %asi, %r19
	.word 0xee4c2937  ! 1: LDSB_I	ldsb	[%r16 + 0x0937], %r23
	brnz %r31,thr3_loop_cnt_470
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0xb33c1002  ! 1: SRAX_R	srax	%r16, %r2, %r25
        mov 0x8a, %r31
thr3_loop_cnt_471:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xdacc2b23  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b23] %asi, %r13
	.word 0xd8942eba  ! 1: LDUHA_I	lduha	[%r16, + 0x0eba] %asi, %r12
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xd6dc2f18  ! 1: LDXA_I	ldxa	[%r16, + 0x0f18] %asi, %r11
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc68c25cf  ! 1: LDUBA_I	lduba	[%r16, + 0x05cf] %asi, %r3
	.word 0xc6dc2a20  ! 1: LDXA_I	ldxa	[%r16, + 0x0a20] %asi, %r3
	.word 0xfc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r30
	.word 0xd8c42948  ! 1: LDSWA_I	ldswa	[%r16, + 0x0948] %asi, %r12
	brnz %r31,thr3_loop_cnt_471
	dec %r31
	.word 0x8f2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r7
	.word 0x8634260b  ! 1: SUBC_I	orn 	%r16, 0x060b, %r3
	.word 0x9c3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r14
        mov 0xaa, %r31
thr3_loop_cnt_472:
	.word 0xf6d42bee  ! 1: LDSHA_I	ldsha	[%r16, + 0x0bee] %asi, %r27
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xecdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r22
	.word 0xecc423cc  ! 1: LDSWA_I	ldswa	[%r16, + 0x03cc] %asi, %r22
	.word 0xf2c42c00  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c00] %asi, %r25
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xce842fe8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0fe8] %asi, %r7
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_472
	dec %r31
	.word 0x863428cb  ! 1: ORN_I	orn 	%r16, 0x08cb, %r3
	.word 0x862c2e12  ! 1: ANDN_I	andn 	%r16, 0x0e12, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x921420fd  ! 1: OR_I	or 	%r16, 0x00fd, %r9
        mov 0x7d, %r31
thr3_loop_cnt_473:
	.word 0xc60424a8  ! 1: LDUW_I	lduw	[%r16 + 0x04a8], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe49421f6  ! 1: LDUHA_I	lduha	[%r16, + 0x01f6] %asi, %r18
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	.word 0xc69421d8  ! 1: LDUHA_I	lduha	[%r16, + 0x01d8] %asi, %r3
	.word 0xce142616  ! 1: LDUH_I	lduh	[%r16 + 0x0616], %r7
	.word 0xc65c2800  ! 1: LDX_I	ldx	[%r16 + 0x0800], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_473
	dec %r31
        mov 0x59, %r31
thr3_loop_cnt_474:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc604254c  ! 1: LDUW_I	lduw	[%r16 + 0x054c], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc654256a  ! 1: LDSH_I	ldsh	[%r16 + 0x056a], %r3
	.word 0xdc0c20c2  ! 1: LDUB_I	ldub	[%r16 + 0x00c2], %r14
	.word 0xf4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r26
	.word 0xd2c42574  ! 1: LDSWA_I	ldswa	[%r16, + 0x0574] %asi, %r9
	.word 0xcecc2bbb  ! 1: LDSBA_I	ldsba	[%r16, + 0x0bbb] %asi, %r7
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6542484  ! 1: LDSH_I	ldsh	[%r16 + 0x0484], %r3
	brnz %r31,thr3_loop_cnt_474
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x86042508  ! 1: ADD_I	add 	%r16, 0x0508, %r3
        mov 0x9b, %r31
thr3_loop_cnt_475:
	.word 0xce040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r7
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xcc942efc  ! 1: LDUHA_I	lduha	[%r16, + 0x0efc] %asi, %r6
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6042404  ! 1: LDUW_I	lduw	[%r16 + 0x0404], %r3
	.word 0xf01424a4  ! 1: LDUH_I	lduh	[%r16 + 0x04a4], %r24
	.word 0xf68c2c21  ! 1: LDUBA_I	lduba	[%r16, + 0x0c21] %asi, %r27
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xfcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r30
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_475
	dec %r31
	.word 0x98142e8f  ! 1: OR_I	or 	%r16, 0x0e8f, %r12
	.word 0xab340002  ! 1: SRL_R	srl 	%r16, %r2, %r21
	.word 0x86242841  ! 1: SUB_I	sub 	%r16, 0x0841, %r3
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x28, %r31
thr3_loop_cnt_476:
	.word 0xdc8424b0  ! 1: LDUWA_I	lduwa	[%r16, + 0x04b0] %asi, %r14
	.word 0xc61426a8  ! 1: LDUH_I	lduh	[%r16 + 0x06a8], %r3
	.word 0xc6942bc8  ! 1: LDUHA_I	lduha	[%r16, + 0x0bc8] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xde540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r15
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_476
	dec %r31
	.word 0x86142f6c  ! 1: OR_I	or 	%r16, 0x0f6c, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0xf, %r31
thr3_loop_cnt_477:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xfc5c2190  ! 1: LDX_I	ldx	[%r16 + 0x0190], %r30
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xde8c2880  ! 1: LDUBA_I	lduba	[%r16, + 0x0880] %asi, %r15
	.word 0xf44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r26
	.word 0xc65c2938  ! 1: LDX_I	ldx	[%r16 + 0x0938], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6d4276a  ! 1: LDSHA_I	ldsha	[%r16, + 0x076a] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_477
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0xa1, %r31
thr3_loop_cnt_478:
	.word 0xecdc2628  ! 1: LDXA_I	ldxa	[%r16, + 0x0628] %asi, %r22
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r25
	.word 0xd00c286a  ! 1: LDUB_I	ldub	[%r16 + 0x086a], %r8
	.word 0xf45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r26
	.word 0xc6c42bbc  ! 1: LDSWA_I	ldswa	[%r16, + 0x0bbc] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6d42ad2  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ad2] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xdcd42182  ! 1: LDSHA_I	ldsha	[%r16, + 0x0182] %asi, %r14
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xd8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r12
	brnz %r31,thr3_loop_cnt_478
	dec %r31
	.word 0x9d343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r14
        mov 0x1c, %r31
thr3_loop_cnt_479:
	.word 0xc68c203a  ! 1: LDUBA_I	lduba	[%r16, + 0x003a] %asi, %r3
	.word 0xc6cc20d2  ! 1: LDSBA_I	ldsba	[%r16, + 0x00d2] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d42de4  ! 1: LDSHA_I	ldsha	[%r16, + 0x0de4] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r10
	.word 0xe6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r19
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6942d80  ! 1: LDUHA_I	lduha	[%r16, + 0x0d80] %asi, %r3
	brnz %r31,thr3_loop_cnt_479
	dec %r31
	.word 0xb32c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r25
        mov 0x0, %r31
thr3_loop_cnt_480:
	.word 0xdc8c23a0  ! 1: LDUBA_I	lduba	[%r16, + 0x03a0] %asi, %r14
	.word 0xeccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r22
	.word 0xde8c263f  ! 1: LDUBA_I	lduba	[%r16, + 0x063f] %asi, %r15
	.word 0xd0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r8
	.word 0xf4542f88  ! 1: LDSH_I	ldsh	[%r16 + 0x0f88], %r26
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xdc5c2af8  ! 1: LDX_I	ldx	[%r16 + 0x0af8], %r14
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xde5426de  ! 1: LDSH_I	ldsh	[%r16 + 0x06de], %r15
	.word 0xdc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r14
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd20c2e67  ! 1: LDUB_I	ldub	[%r16 + 0x0e67], %r9
	brnz %r31,thr3_loop_cnt_480
	dec %r31
        mov 0x26, %r31
thr3_loop_cnt_481:
	.word 0xc65c20e0  ! 1: LDX_I	ldx	[%r16 + 0x00e0], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd6c42ff0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ff0] %asi, %r11
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xec140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r22
	.word 0xcccc2caa  ! 1: LDSBA_I	ldsba	[%r16, + 0x0caa] %asi, %r6
	.word 0xf88424d8  ! 1: LDUWA_I	lduwa	[%r16, + 0x04d8] %asi, %r28
	.word 0xc6442054  ! 1: LDSW_I	ldsw	[%r16 + 0x0054], %r3
	.word 0xe6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r19
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_481
	dec %r31
        mov 0x65, %r31
thr3_loop_cnt_482:
	.word 0xc6942ade  ! 1: LDUHA_I	lduha	[%r16, + 0x0ade] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc60c2600  ! 1: LDUB_I	ldub	[%r16 + 0x0600], %r3
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xc6542d34  ! 1: LDSH_I	ldsh	[%r16 + 0x0d34], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf85c2e00  ! 1: LDX_I	ldx	[%r16 + 0x0e00], %r28
	.word 0xd8cc22d7  ! 1: LDSBA_I	ldsba	[%r16, + 0x02d7] %asi, %r12
	brnz %r31,thr3_loop_cnt_482
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0xa4, %r31
thr3_loop_cnt_483:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2830  ! 1: LDXA_I	ldxa	[%r16, + 0x0830] %asi, %r3
	.word 0xe6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r19
	.word 0xced41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r7
	.word 0xd0442508  ! 1: LDSW_I	ldsw	[%r16 + 0x0508], %r8
	.word 0xc6dc2298  ! 1: LDXA_I	ldxa	[%r16, + 0x0298] %asi, %r3
	.word 0xdccc2bc9  ! 1: LDSBA_I	ldsba	[%r16, + 0x0bc9] %asi, %r14
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_483
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x20, %r31
thr3_loop_cnt_484:
	.word 0xc684237c  ! 1: LDUWA_I	lduwa	[%r16, + 0x037c] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xfa1424dc  ! 1: LDUH_I	lduh	[%r16 + 0x04dc], %r29
	.word 0xd4c42358  ! 1: LDSWA_I	ldswa	[%r16, + 0x0358] %asi, %r10
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf88c2041  ! 1: LDUBA_I	lduba	[%r16, + 0x0041] %asi, %r28
	.word 0xd0942e24  ! 1: LDUHA_I	lduha	[%r16, + 0x0e24] %asi, %r8
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe20425fc  ! 1: LDUW_I	lduw	[%r16 + 0x05fc], %r17
	brnz %r31,thr3_loop_cnt_484
	dec %r31
	.word 0x86142880  ! 1: OR_I	or 	%r16, 0x0880, %r3
        mov 0xa6, %r31
thr3_loop_cnt_485:
	.word 0xce8c2cea  ! 1: LDUBA_I	lduba	[%r16, + 0x0cea] %asi, %r7
	.word 0xe20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r17
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6d424a6  ! 1: LDSHA_I	ldsha	[%r16, + 0x04a6] %asi, %r3
	.word 0xc6442f8c  ! 1: LDSW_I	ldsw	[%r16 + 0x0f8c], %r3
	.word 0xdc842b44  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b44] %asi, %r14
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	.word 0xf8dc2fa8  ! 1: LDXA_I	ldxa	[%r16, + 0x0fa8] %asi, %r28
	.word 0xc6cc2ea7  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ea7] %asi, %r3
	brnz %r31,thr3_loop_cnt_485
	dec %r31
        mov 0xbc, %r31
thr3_loop_cnt_486:
	.word 0xc6042174  ! 1: LDUW_I	lduw	[%r16 + 0x0174], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd2d4284e  ! 1: LDSHA_I	ldsha	[%r16, + 0x084e] %asi, %r9
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xdc5c23e8  ! 1: LDX_I	ldx	[%r16 + 0x03e8], %r14
	.word 0xfa540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r29
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf09427cc  ! 1: LDUHA_I	lduha	[%r16, + 0x07cc] %asi, %r24
	brnz %r31,thr3_loop_cnt_486
	dec %r31
	.word 0x963425ba  ! 1: ORN_I	orn 	%r16, 0x05ba, %r11
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0xb634250f  ! 1: ORN_I	orn 	%r16, 0x050f, %r27
        mov 0x9f, %r31
thr3_loop_cnt_487:
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	.word 0xdc942db8  ! 1: LDUHA_I	lduha	[%r16, + 0x0db8] %asi, %r14
	.word 0xd8542ea6  ! 1: LDSH_I	ldsh	[%r16 + 0x0ea6], %r12
	.word 0xc65c2b40  ! 1: LDX_I	ldx	[%r16 + 0x0b40], %r3
	.word 0xd0042484  ! 1: LDUW_I	lduw	[%r16 + 0x0484], %r8
	.word 0xe4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r18
	.word 0xf6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r27
	.word 0xc6c42650  ! 1: LDSWA_I	ldswa	[%r16, + 0x0650] %asi, %r3
	.word 0xc64c2127  ! 1: LDSB_I	ldsb	[%r16 + 0x0127], %r3
	brnz %r31,thr3_loop_cnt_487
	dec %r31
	.word 0x953c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r10
	.word 0xa72c0002  ! 1: SLL_R	sll 	%r16, %r2, %r19
        mov 0xc4, %r31
thr3_loop_cnt_488:
	.word 0xc6442454  ! 1: LDSW_I	ldsw	[%r16 + 0x0454], %r3
	.word 0xc65c2c48  ! 1: LDX_I	ldx	[%r16 + 0x0c48], %r3
	.word 0xc60c2d2e  ! 1: LDUB_I	ldub	[%r16 + 0x0d2e], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xe4dc2a50  ! 1: LDXA_I	ldxa	[%r16, + 0x0a50] %asi, %r18
	.word 0xc68c2ee6  ! 1: LDUBA_I	lduba	[%r16, + 0x0ee6] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_488
	dec %r31
        mov 0x6f, %r31
thr3_loop_cnt_489:
	.word 0xe84422ec  ! 1: LDSW_I	ldsw	[%r16 + 0x02ec], %r20
	.word 0xc6042dd8  ! 1: LDUW_I	lduw	[%r16 + 0x0dd8], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6c422b0  ! 1: LDSWA_I	ldswa	[%r16, + 0x02b0] %asi, %r3
	.word 0xe2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r17
	.word 0xc6cc2fcd  ! 1: LDSBA_I	ldsba	[%r16, + 0x0fcd] %asi, %r3
	.word 0xc6d42998  ! 1: LDSHA_I	ldsha	[%r16, + 0x0998] %asi, %r3
	.word 0xde8c2ef4  ! 1: LDUBA_I	lduba	[%r16, + 0x0ef4] %asi, %r15
	.word 0xee0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r23
	.word 0xda4c294b  ! 1: LDSB_I	ldsb	[%r16 + 0x094b], %r13
	brnz %r31,thr3_loop_cnt_489
	dec %r31
	.word 0x86342862  ! 1: SUBC_I	orn 	%r16, 0x0862, %r3
	.word 0x862c226e  ! 1: ANDN_I	andn 	%r16, 0x026e, %r3
        mov 0x98, %r31
thr3_loop_cnt_490:
	.word 0xc6942070  ! 1: LDUHA_I	lduha	[%r16, + 0x0070] %asi, %r3
	.word 0xf88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r28
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xda1421d8  ! 1: LDUH_I	lduh	[%r16 + 0x01d8], %r13
	.word 0xc6042e08  ! 1: LDUW_I	lduw	[%r16 + 0x0e08], %r3
	.word 0xdc942b9a  ! 1: LDUHA_I	lduha	[%r16, + 0x0b9a] %asi, %r14
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe6542d84  ! 1: LDSH_I	ldsh	[%r16 + 0x0d84], %r19
	.word 0xf69422fc  ! 1: LDUHA_I	lduha	[%r16, + 0x02fc] %asi, %r27
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_490
	dec %r31
	.word 0xad341002  ! 1: SRLX_R	srlx	%r16, %r2, %r22
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
        mov 0x23, %r31
thr3_loop_cnt_491:
	.word 0xc6942368  ! 1: LDUHA_I	lduha	[%r16, + 0x0368] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd08c2560  ! 1: LDUBA_I	lduba	[%r16, + 0x0560] %asi, %r8
	.word 0xfc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r30
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xda540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r13
	.word 0xdedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r15
	.word 0xc694234e  ! 1: LDUHA_I	lduha	[%r16, + 0x034e] %asi, %r3
	.word 0xc64c2462  ! 1: LDSB_I	ldsb	[%r16 + 0x0462], %r3
	.word 0xc6442aa4  ! 1: LDSW_I	ldsw	[%r16 + 0x0aa4], %r3
	.word 0xe8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r20
	brnz %r31,thr3_loop_cnt_491
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0xad3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r22
	.word 0x86342d60  ! 1: ORN_I	orn 	%r16, 0x0d60, %r3
        mov 0x39, %r31
thr3_loop_cnt_492:
	.word 0xc6042c58  ! 1: LDUW_I	lduw	[%r16 + 0x0c58], %r3
	.word 0xdc5429e6  ! 1: LDSH_I	ldsh	[%r16 + 0x09e6], %r14
	.word 0xd2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r9
	.word 0xf0d423b8  ! 1: LDSHA_I	ldsha	[%r16, + 0x03b8] %asi, %r24
	.word 0xd654214e  ! 1: LDSH_I	ldsh	[%r16 + 0x014e], %r11
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	.word 0xc65420b0  ! 1: LDSH_I	ldsh	[%r16 + 0x00b0], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe2142194  ! 1: LDUH_I	lduh	[%r16 + 0x0194], %r17
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd0cc2b3a  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b3a] %asi, %r8
	brnz %r31,thr3_loop_cnt_492
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x86242f73  ! 1: SUB_I	sub 	%r16, 0x0f73, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x6d, %r31
thr3_loop_cnt_493:
	.word 0xd4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r10
	.word 0xf65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r27
	.word 0xde1426fc  ! 1: LDUH_I	lduh	[%r16 + 0x06fc], %r15
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xe8442f84  ! 1: LDSW_I	ldsw	[%r16 + 0x0f84], %r20
	.word 0xc6842410  ! 1: LDUWA_I	lduwa	[%r16, + 0x0410] %asi, %r3
	.word 0xd6d42470  ! 1: LDSHA_I	ldsha	[%r16, + 0x0470] %asi, %r11
	.word 0xe89424f4  ! 1: LDUHA_I	lduha	[%r16, + 0x04f4] %asi, %r20
	.word 0xc60c24d5  ! 1: LDUB_I	ldub	[%r16 + 0x04d5], %r3
	brnz %r31,thr3_loop_cnt_493
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x6e, %r31
thr3_loop_cnt_494:
	.word 0xc64c2efc  ! 1: LDSB_I	ldsb	[%r16 + 0x0efc], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd60c2f08  ! 1: LDUB_I	ldub	[%r16 + 0x0f08], %r11
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc69426fe  ! 1: LDUHA_I	lduha	[%r16, + 0x06fe] %asi, %r3
	.word 0xd80c268b  ! 1: LDUB_I	ldub	[%r16 + 0x068b], %r12
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe4cc289c  ! 1: LDSBA_I	ldsba	[%r16, + 0x089c] %asi, %r18
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xcc8429e8  ! 1: LDUWA_I	lduwa	[%r16, + 0x09e8] %asi, %r6
	.word 0xd25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r9
	brnz %r31,thr3_loop_cnt_494
	dec %r31
	.word 0xa82c2ae1  ! 1: ANDN_I	andn 	%r16, 0x0ae1, %r20
        mov 0xd, %r31
thr3_loop_cnt_495:
	.word 0xe8d42dd6  ! 1: LDSHA_I	ldsha	[%r16, + 0x0dd6] %asi, %r20
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xfa4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r29
	.word 0xf0142d6a  ! 1: LDUH_I	lduh	[%r16 + 0x0d6a], %r24
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf6c42608  ! 1: LDSWA_I	ldswa	[%r16, + 0x0608] %asi, %r27
	.word 0xd0cc2064  ! 1: LDSBA_I	ldsba	[%r16, + 0x0064] %asi, %r8
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc64c2670  ! 1: LDSB_I	ldsb	[%r16 + 0x0670], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf85c2ee8  ! 1: LDX_I	ldx	[%r16 + 0x0ee8], %r28
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_495
	dec %r31
        mov 0x7e, %r31
thr3_loop_cnt_496:
	.word 0xf4cc2774  ! 1: LDSBA_I	ldsba	[%r16, + 0x0774] %asi, %r26
	.word 0xc6cc2213  ! 1: LDSBA_I	ldsba	[%r16, + 0x0213] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xea94266a  ! 1: LDUHA_I	lduha	[%r16, + 0x066a] %asi, %r21
	.word 0xd45c2d08  ! 1: LDX_I	ldx	[%r16 + 0x0d08], %r10
	.word 0xe2d423b0  ! 1: LDSHA_I	ldsha	[%r16, + 0x03b0] %asi, %r17
	.word 0xd8cc232c  ! 1: LDSBA_I	ldsba	[%r16, + 0x032c] %asi, %r12
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xea8c2d89  ! 1: LDUBA_I	lduba	[%r16, + 0x0d89] %asi, %r21
	.word 0xf4c42f10  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f10] %asi, %r26
	brnz %r31,thr3_loop_cnt_496
	dec %r31
	.word 0x963c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r11
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x9c140002  ! 1: OR_R	or 	%r16, %r2, %r14
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x83, %r31
thr3_loop_cnt_497:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc68421c0  ! 1: LDUWA_I	lduwa	[%r16, + 0x01c0] %asi, %r3
	.word 0xc61420ac  ! 1: LDUH_I	lduh	[%r16 + 0x00ac], %r3
	.word 0xd65c23d8  ! 1: LDX_I	ldx	[%r16 + 0x03d8], %r11
	.word 0xfcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r30
	.word 0xf85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r28
	.word 0xc6842a54  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a54] %asi, %r3
	.word 0xd60c2381  ! 1: LDUB_I	ldub	[%r16 + 0x0381], %r11
	.word 0xcecc2840  ! 1: LDSBA_I	ldsba	[%r16, + 0x0840] %asi, %r7
	brnz %r31,thr3_loop_cnt_497
	dec %r31
        mov 0xbf, %r31
thr3_loop_cnt_498:
	.word 0xdc5c28e8  ! 1: LDX_I	ldx	[%r16 + 0x08e8], %r14
	.word 0xea440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r21
	.word 0xf05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r24
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc694284a  ! 1: LDUHA_I	lduha	[%r16, + 0x084a] %asi, %r3
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6542d7a  ! 1: LDSH_I	ldsh	[%r16 + 0x0d7a], %r3
	.word 0xc65c2b60  ! 1: LDX_I	ldx	[%r16 + 0x0b60], %r3
	.word 0xe4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r18
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_498
	dec %r31
        mov 0xc6, %r31
thr3_loop_cnt_499:
	.word 0xc6942326  ! 1: LDUHA_I	lduha	[%r16, + 0x0326] %asi, %r3
	.word 0xdc5c26b8  ! 1: LDX_I	ldx	[%r16 + 0x06b8], %r14
	.word 0xc60c218b  ! 1: LDUB_I	ldub	[%r16 + 0x018b], %r3
	.word 0xda542a12  ! 1: LDSH_I	ldsh	[%r16 + 0x0a12], %r13
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xee8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r23
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	.word 0xe4442fc4  ! 1: LDSW_I	ldsw	[%r16 + 0x0fc4], %r18
	brnz %r31,thr3_loop_cnt_499
	dec %r31
        mov 0xa1, %r31
thr3_loop_cnt_500:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6842d30  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d30] %asi, %r3
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r10
	.word 0xd0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r8
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd2542530  ! 1: LDSH_I	ldsh	[%r16 + 0x0530], %r9
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_500
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0xa81426eb  ! 1: OR_I	or 	%r16, 0x06eb, %r20
	.word 0x86142222  ! 1: OR_I	or 	%r16, 0x0222, %r3
        mov 0x73, %r31
thr3_loop_cnt_501:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd85c2d88  ! 1: LDX_I	ldx	[%r16 + 0x0d88], %r12
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	.word 0xd80c2021  ! 1: LDUB_I	ldub	[%r16 + 0x0021], %r12
	.word 0xc65c2c20  ! 1: LDX_I	ldx	[%r16 + 0x0c20], %r3
	.word 0xda140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r13
	.word 0xfc8c252d  ! 1: LDUBA_I	lduba	[%r16, + 0x052d] %asi, %r30
	.word 0xd8dc2050  ! 1: LDXA_I	ldxa	[%r16, + 0x0050] %asi, %r12
	.word 0xfcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r30
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r20
	brnz %r31,thr3_loop_cnt_501
	dec %r31
	.word 0xb0240002  ! 1: SUB_R	sub 	%r16, %r2, %r24
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0x91, %r31
thr3_loop_cnt_502:
	.word 0xdc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r14
	.word 0xf84c2b1e  ! 1: LDSB_I	ldsb	[%r16 + 0x0b1e], %r28
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xea941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r21
	.word 0xf604254c  ! 1: LDUW_I	lduw	[%r16 + 0x054c], %r27
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe84c2233  ! 1: LDSB_I	ldsb	[%r16 + 0x0233], %r20
	brnz %r31,thr3_loop_cnt_502
	dec %r31
        mov 0x1c, %r31
thr3_loop_cnt_503:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd0042e1c  ! 1: LDUW_I	lduw	[%r16 + 0x0e1c], %r8
	.word 0xf0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r24
	.word 0xf8942534  ! 1: LDUHA_I	lduha	[%r16, + 0x0534] %asi, %r28
	.word 0xf25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r25
	.word 0xf6942d80  ! 1: LDUHA_I	lduha	[%r16, + 0x0d80] %asi, %r27
	.word 0xe25c2a40  ! 1: LDX_I	ldx	[%r16 + 0x0a40], %r17
	.word 0xdcdc20c0  ! 1: LDXA_I	ldxa	[%r16, + 0x00c0] %asi, %r14
	brnz %r31,thr3_loop_cnt_503
	dec %r31
	.word 0xad342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r22
	.word 0x8d340002  ! 1: SRL_R	srl 	%r16, %r2, %r6
        mov 0x69, %r31
thr3_loop_cnt_504:
	.word 0xc6542574  ! 1: LDSH_I	ldsh	[%r16 + 0x0574], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c42e50  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e50] %asi, %r3
	.word 0xc6142a66  ! 1: LDUH_I	lduh	[%r16 + 0x0a66], %r3
	.word 0xc6dc2700  ! 1: LDXA_I	ldxa	[%r16, + 0x0700] %asi, %r3
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xfc5c2050  ! 1: LDX_I	ldx	[%r16 + 0x0050], %r30
	.word 0xce4c229c  ! 1: LDSB_I	ldsb	[%r16 + 0x029c], %r7
	.word 0xe4842e9c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e9c] %asi, %r18
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_504
	dec %r31
	.word 0x8d3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r6
	.word 0x860c23db  ! 1: AND_I	and 	%r16, 0x03db, %r3
	.word 0x860c206c  ! 1: AND_I	and 	%r16, 0x006c, %r3
	.word 0x864429d6  ! 1: ADDC_I	addc 	%r16, 0x09d6, %r3
        mov 0x82, %r31
thr3_loop_cnt_505:
	.word 0xd25c22b8  ! 1: LDX_I	ldx	[%r16 + 0x02b8], %r9
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	.word 0xf2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r25
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf4d42736  ! 1: LDSHA_I	ldsha	[%r16, + 0x0736] %asi, %r26
	.word 0xe20425fc  ! 1: LDUW_I	lduw	[%r16 + 0x05fc], %r17
	.word 0xf4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r26
	brnz %r31,thr3_loop_cnt_505
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x863c2862  ! 1: XNOR_I	xnor 	%r16, 0x0862, %r3
	.word 0xb33c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r25
        mov 0x5f, %r31
thr3_loop_cnt_506:
	.word 0xfc14233c  ! 1: LDUH_I	lduh	[%r16 + 0x033c], %r30
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xc6442ce8  ! 1: LDSW_I	ldsw	[%r16 + 0x0ce8], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc60c297d  ! 1: LDUB_I	ldub	[%r16 + 0x097d], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc65c23f0  ! 1: LDX_I	ldx	[%r16 + 0x03f0], %r3
	brnz %r31,thr3_loop_cnt_506
	dec %r31
        mov 0xb, %r31
thr3_loop_cnt_507:
	.word 0xf8842e1c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e1c] %asi, %r28
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	.word 0xccc42488  ! 1: LDSWA_I	ldswa	[%r16, + 0x0488] %asi, %r6
	.word 0xe48427dc  ! 1: LDUWA_I	lduwa	[%r16, + 0x07dc] %asi, %r18
	.word 0xccdc2368  ! 1: LDXA_I	ldxa	[%r16, + 0x0368] %asi, %r6
	.word 0xce0c2722  ! 1: LDUB_I	ldub	[%r16 + 0x0722], %r7
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_507
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x9b3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r13
	.word 0xa62428bf  ! 1: SUB_I	sub 	%r16, 0x08bf, %r19
        mov 0x75, %r31
thr3_loop_cnt_508:
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xc654214e  ! 1: LDSH_I	ldsh	[%r16 + 0x014e], %r3
	.word 0xc6cc2903  ! 1: LDSBA_I	ldsba	[%r16, + 0x0903] %asi, %r3
	.word 0xc6842310  ! 1: LDUWA_I	lduwa	[%r16, + 0x0310] %asi, %r3
	.word 0xc6cc2764  ! 1: LDSBA_I	ldsba	[%r16, + 0x0764] %asi, %r3
	.word 0xc6442770  ! 1: LDSW_I	ldsw	[%r16 + 0x0770], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe4d42322  ! 1: LDSHA_I	ldsha	[%r16, + 0x0322] %asi, %r18
	.word 0xc6142d60  ! 1: LDUH_I	lduh	[%r16 + 0x0d60], %r3
	brnz %r31,thr3_loop_cnt_508
	dec %r31
	.word 0x9e2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r15
        mov 0x9d, %r31
thr3_loop_cnt_509:
	.word 0xe48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r18
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	.word 0xc64c2faf  ! 1: LDSB_I	ldsb	[%r16 + 0x0faf], %r3
	.word 0xd294205c  ! 1: LDUHA_I	lduha	[%r16, + 0x005c] %asi, %r9
	.word 0xc604293c  ! 1: LDUW_I	lduw	[%r16 + 0x093c], %r3
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	.word 0xe4c42f28  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f28] %asi, %r18
	brnz %r31,thr3_loop_cnt_509
	dec %r31
	.word 0x860c2435  ! 1: AND_I	and 	%r16, 0x0435, %r3
        mov 0x8e, %r31
thr3_loop_cnt_510:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc68426ec  ! 1: LDUWA_I	lduwa	[%r16, + 0x06ec] %asi, %r3
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xcc0429e4  ! 1: LDUW_I	lduw	[%r16 + 0x09e4], %r6
	.word 0xde841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r15
	.word 0xf6c421f4  ! 1: LDSWA_I	ldswa	[%r16, + 0x01f4] %asi, %r27
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r25
	brnz %r31,thr3_loop_cnt_510
	dec %r31
        mov 0x52, %r31
thr3_loop_cnt_511:
	.word 0xe45c20c0  ! 1: LDX_I	ldx	[%r16 + 0x00c0], %r18
	.word 0xead4226c  ! 1: LDSHA_I	ldsha	[%r16, + 0x026c] %asi, %r21
	.word 0xec842870  ! 1: LDUWA_I	lduwa	[%r16, + 0x0870] %asi, %r22
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd4942706  ! 1: LDUHA_I	lduha	[%r16, + 0x0706] %asi, %r10
	.word 0xc64c2961  ! 1: LDSB_I	ldsb	[%r16 + 0x0961], %r3
	.word 0xc6042aec  ! 1: LDUW_I	lduw	[%r16 + 0x0aec], %r3
	.word 0xf0cc23e3  ! 1: LDSBA_I	ldsba	[%r16, + 0x03e3] %asi, %r24
	.word 0xc6842860  ! 1: LDUWA_I	lduwa	[%r16, + 0x0860] %asi, %r3
	.word 0xc6cc2136  ! 1: LDSBA_I	ldsba	[%r16, + 0x0136] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_511
	dec %r31
	.word 0x86442d1f  ! 1: ADDC_I	addc 	%r16, 0x0d1f, %r3
	.word 0x9824246f  ! 1: SUB_I	sub 	%r16, 0x046f, %r12
        mov 0xaa, %r31
thr3_loop_cnt_512:
	.word 0xdecc27f4  ! 1: LDSBA_I	ldsba	[%r16, + 0x07f4] %asi, %r15
	.word 0xc654208c  ! 1: LDSH_I	ldsh	[%r16 + 0x008c], %r3
	.word 0xd4cc2707  ! 1: LDSBA_I	ldsba	[%r16, + 0x0707] %asi, %r10
	.word 0xec542a4a  ! 1: LDSH_I	ldsh	[%r16 + 0x0a4a], %r22
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2ab4  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ab4] %asi, %r3
	.word 0xc65c2200  ! 1: LDX_I	ldx	[%r16 + 0x0200], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_512
	dec %r31
	.word 0x8644294b  ! 1: ADDC_I	addc 	%r16, 0x094b, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0x1f, %r31
thr3_loop_cnt_513:
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xda140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r13
	.word 0xc60c2f71  ! 1: LDUB_I	ldub	[%r16 + 0x0f71], %r3
	.word 0xcecc2e36  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e36] %asi, %r7
	.word 0xc60c22ab  ! 1: LDUB_I	ldub	[%r16 + 0x02ab], %r3
	.word 0xf6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r27
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6542846  ! 1: LDSH_I	ldsh	[%r16 + 0x0846], %r3
	.word 0xe8dc2e78  ! 1: LDXA_I	ldxa	[%r16, + 0x0e78] %asi, %r20
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_513
	dec %r31
	.word 0xba340002  ! 1: ORN_R	orn 	%r16, %r2, %r29
	.word 0x9f3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r15
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x86, %r31
thr3_loop_cnt_514:
	.word 0xc6442ce4  ! 1: LDSW_I	ldsw	[%r16 + 0x0ce4], %r3
	.word 0xd4542e4e  ! 1: LDSH_I	ldsh	[%r16 + 0x0e4e], %r10
	.word 0xc6542ada  ! 1: LDSH_I	ldsh	[%r16 + 0x0ada], %r3
	.word 0xf2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r25
	.word 0xc6d425e6  ! 1: LDSHA_I	ldsha	[%r16, + 0x05e6] %asi, %r3
	.word 0xfc442ba8  ! 1: LDSW_I	ldsw	[%r16 + 0x0ba8], %r30
	.word 0xd084201c  ! 1: LDUWA_I	lduwa	[%r16, + 0x001c] %asi, %r8
	.word 0xd4842e00  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e00] %asi, %r10
	.word 0xf044259c  ! 1: LDSW_I	ldsw	[%r16 + 0x059c], %r24
	.word 0xec042674  ! 1: LDUW_I	lduw	[%r16 + 0x0674], %r22
	brnz %r31,thr3_loop_cnt_514
	dec %r31
        mov 0x4c, %r31
thr3_loop_cnt_515:
	.word 0xc65c2310  ! 1: LDX_I	ldx	[%r16 + 0x0310], %r3
	.word 0xd2942f2e  ! 1: LDUHA_I	lduha	[%r16, + 0x0f2e] %asi, %r9
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6cc2bfe  ! 1: LDSBA_I	ldsba	[%r16, + 0x0bfe] %asi, %r3
	.word 0xe2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r17
	.word 0xd05c2cd8  ! 1: LDX_I	ldx	[%r16 + 0x0cd8], %r8
	.word 0xd8142e4a  ! 1: LDUH_I	lduh	[%r16 + 0x0e4a], %r12
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xfa142932  ! 1: LDUH_I	lduh	[%r16 + 0x0932], %r29
	.word 0xd4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r10
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xcc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r6
	brnz %r31,thr3_loop_cnt_515
	dec %r31
	.word 0xb63c2d6a  ! 1: XNOR_I	xnor 	%r16, 0x0d6a, %r27
        mov 0x3, %r31
thr3_loop_cnt_516:
	.word 0xea8c2439  ! 1: LDUBA_I	lduba	[%r16, + 0x0439] %asi, %r21
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r26
	.word 0xda941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r13
	.word 0xd60c277a  ! 1: LDUB_I	ldub	[%r16 + 0x077a], %r11
	.word 0xded429f4  ! 1: LDSHA_I	ldsha	[%r16, + 0x09f4] %asi, %r15
	.word 0xf24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r25
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xced41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r7
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_516
	dec %r31
	.word 0xa234274c  ! 1: SUBC_I	orn 	%r16, 0x074c, %r17
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x94440002  ! 1: ADDC_R	addc 	%r16, %r2, %r10
	.word 0x862429ff  ! 1: SUB_I	sub 	%r16, 0x09ff, %r3
        mov 0x74, %r31
thr3_loop_cnt_517:
	.word 0xc6942996  ! 1: LDUHA_I	lduha	[%r16, + 0x0996] %asi, %r3
	.word 0xd2c42048  ! 1: LDSWA_I	ldswa	[%r16, + 0x0048] %asi, %r9
	.word 0xc6c42864  ! 1: LDSWA_I	ldswa	[%r16, + 0x0864] %asi, %r3
	.word 0xc6cc2b9d  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b9d] %asi, %r3
	.word 0xc6142b74  ! 1: LDUH_I	lduh	[%r16 + 0x0b74], %r3
	.word 0xd48c21bb  ! 1: LDUBA_I	lduba	[%r16, + 0x01bb] %asi, %r10
	.word 0xeacc299a  ! 1: LDSBA_I	ldsba	[%r16, + 0x099a] %asi, %r21
	.word 0xfc442660  ! 1: LDSW_I	ldsw	[%r16 + 0x0660], %r30
	.word 0xe2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r17
	.word 0xfc4c21a9  ! 1: LDSB_I	ldsb	[%r16 + 0x01a9], %r30
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_517
	dec %r31
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0xb7342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r27
	.word 0x862c248a  ! 1: ANDN_I	andn 	%r16, 0x048a, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x3b, %r31
thr3_loop_cnt_518:
	.word 0xce5c2c98  ! 1: LDX_I	ldx	[%r16 + 0x0c98], %r7
	.word 0xe8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r20
	.word 0xfc042964  ! 1: LDUW_I	lduw	[%r16 + 0x0964], %r30
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6cc27e0  ! 1: LDSBA_I	ldsba	[%r16, + 0x07e0] %asi, %r3
	.word 0xc6cc2324  ! 1: LDSBA_I	ldsba	[%r16, + 0x0324] %asi, %r3
	.word 0xf0942f1c  ! 1: LDUHA_I	lduha	[%r16, + 0x0f1c] %asi, %r24
	.word 0xc6142d56  ! 1: LDUH_I	lduh	[%r16 + 0x0d56], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_518
	dec %r31
	.word 0x8f342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r7
        mov 0x8a, %r31
thr3_loop_cnt_519:
	.word 0xfc442e40  ! 1: LDSW_I	ldsw	[%r16 + 0x0e40], %r30
	.word 0xfcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r30
	.word 0xf60c275c  ! 1: LDUB_I	ldub	[%r16 + 0x075c], %r27
	.word 0xc6442e40  ! 1: LDSW_I	ldsw	[%r16 + 0x0e40], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	.word 0xf8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r28
	.word 0xd44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r10
	brnz %r31,thr3_loop_cnt_519
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x9e2c25b7  ! 1: ANDN_I	andn 	%r16, 0x05b7, %r15
        mov 0x35, %r31
thr3_loop_cnt_520:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xcec426d0  ! 1: LDSWA_I	ldswa	[%r16, + 0x06d0] %asi, %r7
	.word 0xc6c42360  ! 1: LDSWA_I	ldswa	[%r16, + 0x0360] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe2942fa6  ! 1: LDUHA_I	lduha	[%r16, + 0x0fa6] %asi, %r17
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xec040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r22
	.word 0xf85429bc  ! 1: LDSH_I	ldsh	[%r16 + 0x09bc], %r28
	.word 0xd4142214  ! 1: LDUH_I	lduh	[%r16 + 0x0214], %r10
	.word 0xfc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r30
	brnz %r31,thr3_loop_cnt_520
	dec %r31
        mov 0x70, %r31
thr3_loop_cnt_521:
	.word 0xc6042358  ! 1: LDUW_I	lduw	[%r16 + 0x0358], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf6dc2038  ! 1: LDXA_I	ldxa	[%r16, + 0x0038] %asi, %r27
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	.word 0xee4c2e5a  ! 1: LDSB_I	ldsb	[%r16 + 0x0e5a], %r23
	.word 0xd0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r8
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd8cc209c  ! 1: LDSBA_I	ldsba	[%r16, + 0x009c] %asi, %r12
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_521
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0xa92c0002  ! 1: SLL_R	sll 	%r16, %r2, %r20
        mov 0x75, %r31
thr3_loop_cnt_522:
	.word 0xd8542992  ! 1: LDSH_I	ldsh	[%r16 + 0x0992], %r12
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6142d94  ! 1: LDUH_I	lduh	[%r16 + 0x0d94], %r3
	.word 0xd00426c0  ! 1: LDUW_I	lduw	[%r16 + 0x06c0], %r8
	.word 0xce941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r7
	.word 0xdc1425a0  ! 1: LDUH_I	lduh	[%r16 + 0x05a0], %r14
	.word 0xf6cc2ba7  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ba7] %asi, %r27
	.word 0xf84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r28
	.word 0xf69421bc  ! 1: LDUHA_I	lduha	[%r16, + 0x01bc] %asi, %r27
	brnz %r31,thr3_loop_cnt_522
	dec %r31
        mov 0x7a, %r31
thr3_loop_cnt_523:
	.word 0xc6442448  ! 1: LDSW_I	ldsw	[%r16 + 0x0448], %r3
	.word 0xc6dc2a40  ! 1: LDXA_I	ldxa	[%r16, + 0x0a40] %asi, %r3
	.word 0xfcd429cc  ! 1: LDSHA_I	ldsha	[%r16, + 0x09cc] %asi, %r30
	.word 0xd8542bb0  ! 1: LDSH_I	ldsh	[%r16 + 0x0bb0], %r12
	.word 0xee4c27c2  ! 1: LDSB_I	ldsb	[%r16 + 0x07c2], %r23
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xcc8c2cab  ! 1: LDUBA_I	lduba	[%r16, + 0x0cab] %asi, %r6
	.word 0xc6dc24f8  ! 1: LDXA_I	ldxa	[%r16, + 0x04f8] %asi, %r3
	.word 0xc6842e34  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e34] %asi, %r3
	.word 0xc6d421ea  ! 1: LDSHA_I	ldsha	[%r16, + 0x01ea] %asi, %r3
	brnz %r31,thr3_loop_cnt_523
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x5e, %r31
thr3_loop_cnt_524:
	.word 0xd0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r8
	.word 0xf04c2168  ! 1: LDSB_I	ldsb	[%r16 + 0x0168], %r24
	.word 0xe654217e  ! 1: LDSH_I	ldsh	[%r16 + 0x017e], %r19
	.word 0xc65c26c8  ! 1: LDX_I	ldx	[%r16 + 0x06c8], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6c4269c  ! 1: LDSWA_I	ldswa	[%r16, + 0x069c] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6042708  ! 1: LDUW_I	lduw	[%r16 + 0x0708], %r3
	.word 0xc6142a2c  ! 1: LDUH_I	lduh	[%r16 + 0x0a2c], %r3
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xf014225c  ! 1: LDUH_I	lduh	[%r16 + 0x025c], %r24
	brnz %r31,thr3_loop_cnt_524
	dec %r31
	.word 0x8e342531  ! 1: ORN_I	orn 	%r16, 0x0531, %r7
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x9d2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r14
        mov 0x98, %r31
thr3_loop_cnt_525:
	.word 0xe4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r18
	.word 0xee4c26a4  ! 1: LDSB_I	ldsb	[%r16 + 0x06a4], %r23
	.word 0xc65c2bf8  ! 1: LDX_I	ldx	[%r16 + 0x0bf8], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c26f3  ! 1: LDSB_I	ldsb	[%r16 + 0x06f3], %r3
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d423e6  ! 1: LDSHA_I	ldsha	[%r16, + 0x03e6] %asi, %r3
	brnz %r31,thr3_loop_cnt_525
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x86342de2  ! 1: SUBC_I	orn 	%r16, 0x0de2, %r3
        mov 0x64, %r31
thr3_loop_cnt_526:
	.word 0xe4c424ac  ! 1: LDSWA_I	ldswa	[%r16, + 0x04ac] %asi, %r18
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc684242c  ! 1: LDUWA_I	lduwa	[%r16, + 0x042c] %asi, %r3
	.word 0xf88c2b70  ! 1: LDUBA_I	lduba	[%r16, + 0x0b70] %asi, %r28
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r8
	brnz %r31,thr3_loop_cnt_526
	dec %r31
	.word 0x8f2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r7
        mov 0x2c, %r31
thr3_loop_cnt_527:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd04c2410  ! 1: LDSB_I	ldsb	[%r16 + 0x0410], %r8
	.word 0xee8421e0  ! 1: LDUWA_I	lduwa	[%r16, + 0x01e0] %asi, %r23
	.word 0xe4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r18
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xfadc2328  ! 1: LDXA_I	ldxa	[%r16, + 0x0328] %asi, %r29
	.word 0xd044268c  ! 1: LDSW_I	ldsw	[%r16 + 0x068c], %r8
	.word 0xc6c42d38  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d38] %asi, %r3
	.word 0xe2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r17
	.word 0xe6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r19
	brnz %r31,thr3_loop_cnt_527
	dec %r31
	.word 0x8e1c0002  ! 1: XOR_R	xor 	%r16, %r2, %r7
	.word 0xb92c0002  ! 1: SLL_R	sll 	%r16, %r2, %r28
	.word 0xaa040002  ! 1: ADD_R	add 	%r16, %r2, %r21
        mov 0x2d, %r31
thr3_loop_cnt_528:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc64c2c97  ! 1: LDSB_I	ldsb	[%r16 + 0x0c97], %r3
	.word 0xc6942166  ! 1: LDUHA_I	lduha	[%r16, + 0x0166] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd6842c20  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c20] %asi, %r11
	.word 0xe6cc2f02  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f02] %asi, %r19
	.word 0xc65c2698  ! 1: LDX_I	ldx	[%r16 + 0x0698], %r3
	.word 0xc6cc2fa4  ! 1: LDSBA_I	ldsba	[%r16, + 0x0fa4] %asi, %r3
	.word 0xfa841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r29
	.word 0xd85c22b8  ! 1: LDX_I	ldx	[%r16 + 0x02b8], %r12
	brnz %r31,thr3_loop_cnt_528
	dec %r31
        mov 0xbc, %r31
thr3_loop_cnt_529:
	.word 0xc6d4291e  ! 1: LDSHA_I	ldsha	[%r16, + 0x091e] %asi, %r3
	.word 0xd4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r10
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc60c2a6a  ! 1: LDUB_I	ldub	[%r16 + 0x0a6a], %r3
	.word 0xd2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r9
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xeacc21b1  ! 1: LDSBA_I	ldsba	[%r16, + 0x01b1] %asi, %r21
	.word 0xec140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r22
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	.word 0xd88c2743  ! 1: LDUBA_I	lduba	[%r16, + 0x0743] %asi, %r12
	brnz %r31,thr3_loop_cnt_529
	dec %r31
        mov 0x4c, %r31
thr3_loop_cnt_530:
	.word 0xc6dc2618  ! 1: LDXA_I	ldxa	[%r16, + 0x0618] %asi, %r3
	.word 0xd80c28f2  ! 1: LDUB_I	ldub	[%r16 + 0x08f2], %r12
	.word 0xe20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r17
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xee0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r23
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf20c2325  ! 1: LDUB_I	ldub	[%r16 + 0x0325], %r25
	.word 0xc6842ac0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ac0] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	brnz %r31,thr3_loop_cnt_530
	dec %r31
	.word 0xbc340002  ! 1: ORN_R	orn 	%r16, %r2, %r30
        mov 0x38, %r31
thr3_loop_cnt_531:
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xc6042674  ! 1: LDUW_I	lduw	[%r16 + 0x0674], %r3
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xc684220c  ! 1: LDUWA_I	lduwa	[%r16, + 0x020c] %asi, %r3
	.word 0xf00c22b8  ! 1: LDUB_I	ldub	[%r16 + 0x02b8], %r24
	.word 0xc6042134  ! 1: LDUW_I	lduw	[%r16 + 0x0134], %r3
	.word 0xc64c214c  ! 1: LDSB_I	ldsb	[%r16 + 0x014c], %r3
	.word 0xc6842900  ! 1: LDUWA_I	lduwa	[%r16, + 0x0900] %asi, %r3
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xec140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r22
	brnz %r31,thr3_loop_cnt_531
	dec %r31
	.word 0xa5341002  ! 1: SRLX_R	srlx	%r16, %r2, %r18
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x862c2528  ! 1: ANDN_I	andn 	%r16, 0x0528, %r3
        mov 0x54, %r31
thr3_loop_cnt_532:
	.word 0xc68c25bd  ! 1: LDUBA_I	lduba	[%r16, + 0x05bd] %asi, %r3
	.word 0xd44425e8  ! 1: LDSW_I	ldsw	[%r16 + 0x05e8], %r10
	.word 0xea042ec8  ! 1: LDUW_I	lduw	[%r16 + 0x0ec8], %r21
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xecc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r22
	.word 0xc6dc2e20  ! 1: LDXA_I	ldxa	[%r16, + 0x0e20] %asi, %r3
	.word 0xc64c2cc6  ! 1: LDSB_I	ldsb	[%r16 + 0x0cc6], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd45c2798  ! 1: LDX_I	ldx	[%r16 + 0x0798], %r10
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6c42b10  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b10] %asi, %r3
	brnz %r31,thr3_loop_cnt_532
	dec %r31
	.word 0xa52c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r18
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x862422da  ! 1: SUB_I	sub 	%r16, 0x02da, %r3
	.word 0xb8342b44  ! 1: SUBC_I	orn 	%r16, 0x0b44, %r28
        mov 0x8f, %r31
thr3_loop_cnt_533:
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	.word 0xc6042f4c  ! 1: LDUW_I	lduw	[%r16 + 0x0f4c], %r3
	.word 0xc6c42388  ! 1: LDSWA_I	ldswa	[%r16, + 0x0388] %asi, %r3
	.word 0xeacc25f7  ! 1: LDSBA_I	ldsba	[%r16, + 0x05f7] %asi, %r21
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	.word 0xf05c2780  ! 1: LDX_I	ldx	[%r16 + 0x0780], %r24
	.word 0xc6dc26c0  ! 1: LDXA_I	ldxa	[%r16, + 0x06c0] %asi, %r3
	.word 0xc6cc22bd  ! 1: LDSBA_I	ldsba	[%r16, + 0x02bd] %asi, %r3
	brnz %r31,thr3_loop_cnt_533
	dec %r31
        mov 0x95, %r31
thr3_loop_cnt_534:
	.word 0xfa8425b0  ! 1: LDUWA_I	lduwa	[%r16, + 0x05b0] %asi, %r29
	.word 0xd0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r8
	.word 0xc6142e40  ! 1: LDUH_I	lduh	[%r16 + 0x0e40], %r3
	.word 0xd0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r8
	.word 0xd24c2680  ! 1: LDSB_I	ldsb	[%r16 + 0x0680], %r9
	.word 0xc6442df4  ! 1: LDSW_I	ldsw	[%r16 + 0x0df4], %r3
	.word 0xc68c2acc  ! 1: LDUBA_I	lduba	[%r16, + 0x0acc] %asi, %r3
	.word 0xd0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r8
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_534
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x8e442a8f  ! 1: ADDC_I	addc 	%r16, 0x0a8f, %r7
	.word 0xb4340002  ! 1: SUBC_R	orn 	%r16, %r2, %r26
	.word 0x860c216f  ! 1: AND_I	and 	%r16, 0x016f, %r3
        mov 0x5b, %r31
thr3_loop_cnt_535:
	.word 0xc6d42b54  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b54] %asi, %r3
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	.word 0xd80426e8  ! 1: LDUW_I	lduw	[%r16 + 0x06e8], %r12
	.word 0xcccc2ed5  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ed5] %asi, %r6
	.word 0xc6442bb4  ! 1: LDSW_I	ldsw	[%r16 + 0x0bb4], %r3
	.word 0xd4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r10
	.word 0xe6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r19
	.word 0xc60c2597  ! 1: LDUB_I	ldub	[%r16 + 0x0597], %r3
	brnz %r31,thr3_loop_cnt_535
	dec %r31
        mov 0x5b, %r31
thr3_loop_cnt_536:
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xded42c32  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c32] %asi, %r15
	.word 0xe8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r20
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xc68c2386  ! 1: LDUBA_I	lduba	[%r16, + 0x0386] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc68424ec  ! 1: LDUWA_I	lduwa	[%r16, + 0x04ec] %asi, %r3
	.word 0xc69424ce  ! 1: LDUHA_I	lduha	[%r16, + 0x04ce] %asi, %r3
	.word 0xc6d42e8c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e8c] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_536
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x9d3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r14
        mov 0x26, %r31
thr3_loop_cnt_537:
	.word 0xc6d42696  ! 1: LDSHA_I	ldsha	[%r16, + 0x0696] %asi, %r3
	.word 0xce5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r7
	.word 0xf414218c  ! 1: LDUH_I	lduh	[%r16 + 0x018c], %r26
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc69422c6  ! 1: LDUHA_I	lduha	[%r16, + 0x02c6] %asi, %r3
	.word 0xc68c24f5  ! 1: LDUBA_I	lduba	[%r16, + 0x04f5] %asi, %r3
	.word 0xc694200e  ! 1: LDUHA_I	lduha	[%r16, + 0x000e] %asi, %r3
	.word 0xf4942f3c  ! 1: LDUHA_I	lduha	[%r16, + 0x0f3c] %asi, %r26
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xc6542448  ! 1: LDSH_I	ldsh	[%r16 + 0x0448], %r3
	brnz %r31,thr3_loop_cnt_537
	dec %r31
	.word 0xb72c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r27
	.word 0x8c040002  ! 1: ADD_R	add 	%r16, %r2, %r6
	.word 0xa6042fd0  ! 1: ADD_I	add 	%r16, 0x0fd0, %r19
        mov 0xa7, %r31
thr3_loop_cnt_538:
	.word 0xc6142880  ! 1: LDUH_I	lduh	[%r16 + 0x0880], %r3
	.word 0xc64c2e99  ! 1: LDSB_I	ldsb	[%r16 + 0x0e99], %r3
	.word 0xd0942b5c  ! 1: LDUHA_I	lduha	[%r16, + 0x0b5c] %asi, %r8
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd8dc27d8  ! 1: LDXA_I	ldxa	[%r16, + 0x07d8] %asi, %r12
	.word 0xd8442af8  ! 1: LDSW_I	ldsw	[%r16 + 0x0af8], %r12
	.word 0xdadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r13
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_538
	dec %r31
        mov 0x25, %r31
thr3_loop_cnt_539:
	.word 0xc684267c  ! 1: LDUWA_I	lduwa	[%r16, + 0x067c] %asi, %r3
	.word 0xc68c2153  ! 1: LDUBA_I	lduba	[%r16, + 0x0153] %asi, %r3
	.word 0xce5c28c8  ! 1: LDX_I	ldx	[%r16 + 0x08c8], %r7
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	.word 0xd60c21cc  ! 1: LDUB_I	ldub	[%r16 + 0x01cc], %r11
	.word 0xc6442bf4  ! 1: LDSW_I	ldsw	[%r16 + 0x0bf4], %r3
	.word 0xe4d4257e  ! 1: LDSHA_I	ldsha	[%r16, + 0x057e] %asi, %r18
	.word 0xe2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r17
	.word 0xc6cc2849  ! 1: LDSBA_I	ldsba	[%r16, + 0x0849] %asi, %r3
	.word 0xc6dc24a8  ! 1: LDXA_I	ldxa	[%r16, + 0x04a8] %asi, %r3
	brnz %r31,thr3_loop_cnt_539
	dec %r31
	.word 0x9b3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r13
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x862c23ab  ! 1: ANDN_I	andn 	%r16, 0x03ab, %r3
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x2a, %r31
thr3_loop_cnt_540:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xf44c25f4  ! 1: LDSB_I	ldsb	[%r16 + 0x05f4], %r26
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe8842384  ! 1: LDUWA_I	lduwa	[%r16, + 0x0384] %asi, %r20
	.word 0xe2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r17
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc604246c  ! 1: LDUW_I	lduw	[%r16 + 0x046c], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_540
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0xb8, %r31
thr3_loop_cnt_541:
	.word 0xc60c268e  ! 1: LDUB_I	ldub	[%r16 + 0x068e], %r3
	.word 0xea440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r21
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc60c25d1  ! 1: LDUB_I	ldub	[%r16 + 0x05d1], %r3
	.word 0xc614294e  ! 1: LDUH_I	lduh	[%r16 + 0x094e], %r3
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_541
	dec %r31
	.word 0xa62c2bcf  ! 1: ANDN_I	andn 	%r16, 0x0bcf, %r19
	.word 0xad2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r22
        mov 0x5c, %r31
thr3_loop_cnt_542:
	.word 0xc6542d78  ! 1: LDSH_I	ldsh	[%r16 + 0x0d78], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd2842268  ! 1: LDUWA_I	lduwa	[%r16, + 0x0268] %asi, %r9
	.word 0xe804219c  ! 1: LDUW_I	lduw	[%r16 + 0x019c], %r20
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r24
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xce942db8  ! 1: LDUHA_I	lduha	[%r16, + 0x0db8] %asi, %r7
	brnz %r31,thr3_loop_cnt_542
	dec %r31
        mov 0x2e, %r31
thr3_loop_cnt_543:
	.word 0xd2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r9
	.word 0xe8842484  ! 1: LDUWA_I	lduwa	[%r16, + 0x0484] %asi, %r20
	.word 0xe4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r18
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	.word 0xc6542fca  ! 1: LDSH_I	ldsh	[%r16 + 0x0fca], %r3
	.word 0xf08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r24
	.word 0xd854230c  ! 1: LDSH_I	ldsh	[%r16 + 0x030c], %r12
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xd0cc2c54  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c54] %asi, %r8
	brnz %r31,thr3_loop_cnt_543
	dec %r31
        mov 0x9b, %r31
thr3_loop_cnt_544:
	.word 0xc64c2ebe  ! 1: LDSB_I	ldsb	[%r16 + 0x0ebe], %r3
	.word 0xd4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r10
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd0dc22a0  ! 1: LDXA_I	ldxa	[%r16, + 0x02a0] %asi, %r8
	.word 0xc60c292b  ! 1: LDUB_I	ldub	[%r16 + 0x092b], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r26
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6042e64  ! 1: LDUW_I	lduw	[%r16 + 0x0e64], %r3
	brnz %r31,thr3_loop_cnt_544
	dec %r31
	.word 0x8c440002  ! 1: ADDC_R	addc 	%r16, %r2, %r6
        mov 0x2d, %r31
thr3_loop_cnt_545:
	.word 0xc6442270  ! 1: LDSW_I	ldsw	[%r16 + 0x0270], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xce0c2df5  ! 1: LDUB_I	ldub	[%r16 + 0x0df5], %r7
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd69429ec  ! 1: LDUHA_I	lduha	[%r16, + 0x09ec] %asi, %r11
	.word 0xc6cc25fa  ! 1: LDSBA_I	ldsba	[%r16, + 0x05fa] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xcc142f72  ! 1: LDUH_I	lduh	[%r16 + 0x0f72], %r6
	.word 0xe4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r18
	.word 0xda942720  ! 1: LDUHA_I	lduha	[%r16, + 0x0720] %asi, %r13
	.word 0xf6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r27
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	brnz %r31,thr3_loop_cnt_545
	dec %r31
	.word 0x9d340002  ! 1: SRL_R	srl 	%r16, %r2, %r14
        mov 0x9c, %r31
thr3_loop_cnt_546:
	.word 0xf2042d50  ! 1: LDUW_I	lduw	[%r16 + 0x0d50], %r25
	.word 0xf6c42b70  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b70] %asi, %r27
	.word 0xf6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r27
	.word 0xcc0c2320  ! 1: LDUB_I	ldub	[%r16 + 0x0320], %r6
	.word 0xeec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r23
	.word 0xd0c42cf4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0cf4] %asi, %r8
	.word 0xfc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r30
	.word 0xc6042cb4  ! 1: LDUW_I	lduw	[%r16 + 0x0cb4], %r3
	.word 0xe4dc22a8  ! 1: LDXA_I	ldxa	[%r16, + 0x02a8] %asi, %r18
	.word 0xc6dc2bd8  ! 1: LDXA_I	ldxa	[%r16, + 0x0bd8] %asi, %r3
	.word 0xc6cc2515  ! 1: LDSBA_I	ldsba	[%r16, + 0x0515] %asi, %r3
	brnz %r31,thr3_loop_cnt_546
	dec %r31
        mov 0x26, %r31
thr3_loop_cnt_547:
	.word 0xd4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r10
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf8dc2960  ! 1: LDXA_I	ldxa	[%r16, + 0x0960] %asi, %r28
	.word 0xf2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r25
	.word 0xe8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r20
	.word 0xda5c2bb8  ! 1: LDX_I	ldx	[%r16 + 0x0bb8], %r13
	.word 0xe64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r19
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_547
	dec %r31
	.word 0xa9340002  ! 1: SRL_R	srl 	%r16, %r2, %r20
	.word 0x90040002  ! 1: ADD_R	add 	%r16, %r2, %r8
	.word 0xba342e25  ! 1: SUBC_I	orn 	%r16, 0x0e25, %r29
	.word 0xad2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r22
        mov 0x32, %r31
thr3_loop_cnt_548:
	.word 0xfc4c2bf9  ! 1: LDSB_I	ldsb	[%r16 + 0x0bf9], %r30
	.word 0xea440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r21
	.word 0xc6442874  ! 1: LDSW_I	ldsw	[%r16 + 0x0874], %r3
	.word 0xd0042374  ! 1: LDUW_I	lduw	[%r16 + 0x0374], %r8
	.word 0xce442b64  ! 1: LDSW_I	ldsw	[%r16 + 0x0b64], %r7
	.word 0xd89428cc  ! 1: LDUHA_I	lduha	[%r16, + 0x08cc] %asi, %r12
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xcc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r6
	brnz %r31,thr3_loop_cnt_548
	dec %r31
	.word 0x9d340002  ! 1: SRL_R	srl 	%r16, %r2, %r14
	.word 0x8634270b  ! 1: SUBC_I	orn 	%r16, 0x070b, %r3
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0x99, %r31
thr3_loop_cnt_549:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd4442634  ! 1: LDSW_I	ldsw	[%r16 + 0x0634], %r10
	.word 0xc6c42848  ! 1: LDSWA_I	ldswa	[%r16, + 0x0848] %asi, %r3
	.word 0xc60c2097  ! 1: LDUB_I	ldub	[%r16 + 0x0097], %r3
	.word 0xc65426f6  ! 1: LDSH_I	ldsh	[%r16 + 0x06f6], %r3
	.word 0xe84c2e86  ! 1: LDSB_I	ldsb	[%r16 + 0x0e86], %r20
	.word 0xc6942056  ! 1: LDUHA_I	lduha	[%r16, + 0x0056] %asi, %r3
	.word 0xc6842c48  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c48] %asi, %r3
	.word 0xcedc27c0  ! 1: LDXA_I	ldxa	[%r16, + 0x07c0] %asi, %r7
	brnz %r31,thr3_loop_cnt_549
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x94, %r31
thr3_loop_cnt_550:
	.word 0xf20424e4  ! 1: LDUW_I	lduw	[%r16 + 0x04e4], %r25
	.word 0xc6842690  ! 1: LDUWA_I	lduwa	[%r16, + 0x0690] %asi, %r3
	.word 0xde140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r15
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xe4042eb0  ! 1: LDUW_I	lduw	[%r16 + 0x0eb0], %r18
	.word 0xf6842c98  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c98] %asi, %r27
	.word 0xc6842350  ! 1: LDUWA_I	lduwa	[%r16, + 0x0350] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r8
	.word 0xd28c22fa  ! 1: LDUBA_I	lduba	[%r16, + 0x02fa] %asi, %r9
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r9
	brnz %r31,thr3_loop_cnt_550
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0xa60c2ee7  ! 1: AND_I	and 	%r16, 0x0ee7, %r19
        mov 0xa0, %r31
thr3_loop_cnt_551:
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xde942c64  ! 1: LDUHA_I	lduha	[%r16, + 0x0c64] %asi, %r15
	.word 0xfa540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r29
	.word 0xc65c2d58  ! 1: LDX_I	ldx	[%r16 + 0x0d58], %r3
	.word 0xee442f6c  ! 1: LDSW_I	ldsw	[%r16 + 0x0f6c], %r23
	.word 0xfa941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r29
	.word 0xc68425fc  ! 1: LDUWA_I	lduwa	[%r16, + 0x05fc] %asi, %r3
	.word 0xfc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r30
	.word 0xec140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r22
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xf25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r25
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	brnz %r31,thr3_loop_cnt_551
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x9c040002  ! 1: ADD_R	add 	%r16, %r2, %r14
        mov 0x16, %r31
thr3_loop_cnt_552:
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6142216  ! 1: LDUH_I	lduh	[%r16 + 0x0216], %r3
	.word 0xc644230c  ! 1: LDSW_I	ldsw	[%r16 + 0x030c], %r3
	.word 0xfa4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r29
	.word 0xfa8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r29
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe4cc29e4  ! 1: LDSBA_I	ldsba	[%r16, + 0x09e4] %asi, %r18
	.word 0xf60c24a0  ! 1: LDUB_I	ldub	[%r16 + 0x04a0], %r27
	.word 0xf44c25bd  ! 1: LDSB_I	ldsb	[%r16 + 0x05bd], %r26
	.word 0xfa0c2ff2  ! 1: LDUB_I	ldub	[%r16 + 0x0ff2], %r29
	.word 0xdc8c202d  ! 1: LDUBA_I	lduba	[%r16, + 0x002d] %asi, %r14
	brnz %r31,thr3_loop_cnt_552
	dec %r31
	.word 0xb1343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r24
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0xb4, %r31
thr3_loop_cnt_553:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc64c262c  ! 1: LDSB_I	ldsb	[%r16 + 0x062c], %r3
	.word 0xc6842ac0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ac0] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc684236c  ! 1: LDUWA_I	lduwa	[%r16, + 0x036c] %asi, %r3
	.word 0xc6842cb8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0cb8] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r28
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xce4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r7
	.word 0xc604270c  ! 1: LDUW_I	lduw	[%r16 + 0x070c], %r3
	brnz %r31,thr3_loop_cnt_553
	dec %r31
	.word 0xb82c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r28
	.word 0x99341002  ! 1: SRLX_R	srlx	%r16, %r2, %r12
	.word 0x86442954  ! 1: ADDC_I	addc 	%r16, 0x0954, %r3
        mov 0x33, %r31
thr3_loop_cnt_554:
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xfa8c2bf4  ! 1: LDUBA_I	lduba	[%r16, + 0x0bf4] %asi, %r29
	.word 0xfa5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r29
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r26
	.word 0xe65c2d38  ! 1: LDX_I	ldx	[%r16 + 0x0d38], %r19
	.word 0xe8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r20
	.word 0xc61424fc  ! 1: LDUH_I	lduh	[%r16 + 0x04fc], %r3
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	brnz %r31,thr3_loop_cnt_554
	dec %r31
	.word 0x86342bbf  ! 1: SUBC_I	orn 	%r16, 0x0bbf, %r3
        mov 0x6b, %r31
thr3_loop_cnt_555:
	.word 0xec4421b8  ! 1: LDSW_I	ldsw	[%r16 + 0x01b8], %r22
	.word 0xc604211c  ! 1: LDUW_I	lduw	[%r16 + 0x011c], %r3
	.word 0xc6d422aa  ! 1: LDSHA_I	ldsha	[%r16, + 0x02aa] %asi, %r3
	.word 0xd6cc289f  ! 1: LDSBA_I	ldsba	[%r16, + 0x089f] %asi, %r11
	.word 0xdcd42194  ! 1: LDSHA_I	ldsha	[%r16, + 0x0194] %asi, %r14
	.word 0xda4c2750  ! 1: LDSB_I	ldsb	[%r16 + 0x0750], %r13
	.word 0xfa140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r29
	.word 0xc6c42990  ! 1: LDSWA_I	ldswa	[%r16, + 0x0990] %asi, %r3
	.word 0xd0d42ad6  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ad6] %asi, %r8
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	brnz %r31,thr3_loop_cnt_555
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x90242a84  ! 1: SUB_I	sub 	%r16, 0x0a84, %r8
	.word 0xbd3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r30
        mov 0x87, %r31
thr3_loop_cnt_556:
	.word 0xc6d420f4  ! 1: LDSHA_I	ldsha	[%r16, + 0x00f4] %asi, %r3
	.word 0xec140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r22
	.word 0xdec42ae4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ae4] %asi, %r15
	.word 0xda942a6e  ! 1: LDUHA_I	lduha	[%r16, + 0x0a6e] %asi, %r13
	.word 0xdc8c2d3f  ! 1: LDUBA_I	lduba	[%r16, + 0x0d3f] %asi, %r14
	.word 0xc65c2cf0  ! 1: LDX_I	ldx	[%r16 + 0x0cf0], %r3
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	.word 0xf2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r25
	.word 0xc64c2ea6  ! 1: LDSB_I	ldsb	[%r16 + 0x0ea6], %r3
	.word 0xdcc42144  ! 1: LDSWA_I	ldswa	[%r16, + 0x0144] %asi, %r14
	brnz %r31,thr3_loop_cnt_556
	dec %r31
	.word 0x9c2c2e11  ! 1: ANDN_I	andn 	%r16, 0x0e11, %r14
        mov 0x34, %r31
thr3_loop_cnt_557:
	.word 0xd0842360  ! 1: LDUWA_I	lduwa	[%r16, + 0x0360] %asi, %r8
	.word 0xc68c28e9  ! 1: LDUBA_I	lduba	[%r16, + 0x08e9] %asi, %r3
	.word 0xf45c2658  ! 1: LDX_I	ldx	[%r16 + 0x0658], %r26
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xce442830  ! 1: LDSW_I	ldsw	[%r16 + 0x0830], %r7
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xc6942c26  ! 1: LDUHA_I	lduha	[%r16, + 0x0c26] %asi, %r3
	.word 0xe6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r19
	.word 0xec941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r22
	brnz %r31,thr3_loop_cnt_557
	dec %r31
	.word 0xbb2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r29
	.word 0xa8242a49  ! 1: SUB_I	sub 	%r16, 0x0a49, %r20
        mov 0xb6, %r31
thr3_loop_cnt_558:
	.word 0xd2142890  ! 1: LDUH_I	lduh	[%r16 + 0x0890], %r9
	.word 0xdcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r14
	.word 0xc6842dcc  ! 1: LDUWA_I	lduwa	[%r16, + 0x0dcc] %asi, %r3
	.word 0xc6542b82  ! 1: LDSH_I	ldsh	[%r16 + 0x0b82], %r3
	.word 0xea042c1c  ! 1: LDUW_I	lduw	[%r16 + 0x0c1c], %r21
	.word 0xf61421bc  ! 1: LDUH_I	lduh	[%r16 + 0x01bc], %r27
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf6d426bc  ! 1: LDSHA_I	ldsha	[%r16, + 0x06bc] %asi, %r27
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xee841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r23
	brnz %r31,thr3_loop_cnt_558
	dec %r31
        mov 0xb, %r31
thr3_loop_cnt_559:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc65c2528  ! 1: LDX_I	ldx	[%r16 + 0x0528], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xda941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r13
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6142c0c  ! 1: LDUH_I	lduh	[%r16 + 0x0c0c], %r3
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xc65c2438  ! 1: LDX_I	ldx	[%r16 + 0x0438], %r3
	brnz %r31,thr3_loop_cnt_559
	dec %r31
	.word 0xb72c0002  ! 1: SLL_R	sll 	%r16, %r2, %r27
	.word 0xb0140002  ! 1: OR_R	or 	%r16, %r2, %r24
        mov 0xe, %r31
thr3_loop_cnt_560:
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	.word 0xd884242c  ! 1: LDUWA_I	lduwa	[%r16, + 0x042c] %asi, %r12
	.word 0xf00c217b  ! 1: LDUB_I	ldub	[%r16 + 0x017b], %r24
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe40423e0  ! 1: LDUW_I	lduw	[%r16 + 0x03e0], %r18
	.word 0xe64c222b  ! 1: LDSB_I	ldsb	[%r16 + 0x022b], %r19
	.word 0xe65c29f8  ! 1: LDX_I	ldx	[%r16 + 0x09f8], %r19
	.word 0xc60c2807  ! 1: LDUB_I	ldub	[%r16 + 0x0807], %r3
	.word 0xe4d427ea  ! 1: LDSHA_I	ldsha	[%r16, + 0x07ea] %asi, %r18
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	brnz %r31,thr3_loop_cnt_560
	dec %r31
        mov 0xa, %r31
thr3_loop_cnt_561:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r19
	.word 0xee8c24be  ! 1: LDUBA_I	lduba	[%r16, + 0x04be] %asi, %r23
	.word 0xc6dc2d48  ! 1: LDXA_I	ldxa	[%r16, + 0x0d48] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r26
	.word 0xe8842ef8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ef8] %asi, %r20
	.word 0xc60c2fd0  ! 1: LDUB_I	ldub	[%r16 + 0x0fd0], %r3
	.word 0xc6dc2eb8  ! 1: LDXA_I	ldxa	[%r16, + 0x0eb8] %asi, %r3
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	brnz %r31,thr3_loop_cnt_561
	dec %r31
        mov 0x12, %r31
thr3_loop_cnt_562:
	.word 0xfcdc25a0  ! 1: LDXA_I	ldxa	[%r16, + 0x05a0] %asi, %r30
	.word 0xc614244c  ! 1: LDUH_I	lduh	[%r16 + 0x044c], %r3
	.word 0xda4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r13
	.word 0xee841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r23
	.word 0xc60428ec  ! 1: LDUW_I	lduw	[%r16 + 0x08ec], %r3
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xda8c276c  ! 1: LDUBA_I	lduba	[%r16, + 0x076c] %asi, %r13
	.word 0xc68c2b44  ! 1: LDUBA_I	lduba	[%r16, + 0x0b44] %asi, %r3
	.word 0xc6c42ae0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ae0] %asi, %r3
	.word 0xdacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r13
	brnz %r31,thr3_loop_cnt_562
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x953c1002  ! 1: SRAX_R	srax	%r16, %r2, %r10
        mov 0x12, %r31
thr3_loop_cnt_563:
	.word 0xc654228c  ! 1: LDSH_I	ldsh	[%r16 + 0x028c], %r3
	.word 0xc60429dc  ! 1: LDUW_I	lduw	[%r16 + 0x09dc], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xe8442cb4  ! 1: LDSW_I	ldsw	[%r16 + 0x0cb4], %r20
	.word 0xc6d42d9a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d9a] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xcc5c2678  ! 1: LDX_I	ldx	[%r16 + 0x0678], %r6
	.word 0xc68c2e56  ! 1: LDUBA_I	lduba	[%r16, + 0x0e56] %asi, %r3
	.word 0xe68c250e  ! 1: LDUBA_I	lduba	[%r16, + 0x050e] %asi, %r19
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_563
	dec %r31
	.word 0xa2340002  ! 1: ORN_R	orn 	%r16, %r2, %r17
	.word 0x9a2c25a5  ! 1: ANDN_I	andn 	%r16, 0x05a5, %r13
	.word 0x960c0002  ! 1: AND_R	and 	%r16, %r2, %r11
        mov 0x8d, %r31
thr3_loop_cnt_564:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6d42690  ! 1: LDSHA_I	ldsha	[%r16, + 0x0690] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6442f30  ! 1: LDSW_I	ldsw	[%r16 + 0x0f30], %r3
	.word 0xce4c26ef  ! 1: LDSB_I	ldsb	[%r16 + 0x06ef], %r7
	.word 0xc6d422fa  ! 1: LDSHA_I	ldsha	[%r16, + 0x02fa] %asi, %r3
	.word 0xe6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r19
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	.word 0xc69420c8  ! 1: LDUHA_I	lduha	[%r16, + 0x00c8] %asi, %r3
	brnz %r31,thr3_loop_cnt_564
	dec %r31
	.word 0x941c0002  ! 1: XOR_R	xor 	%r16, %r2, %r10
        mov 0x37, %r31
thr3_loop_cnt_565:
	.word 0xc6042f5c  ! 1: LDUW_I	lduw	[%r16 + 0x0f5c], %r3
	.word 0xd4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r10
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r25
	.word 0xcc542afa  ! 1: LDSH_I	ldsh	[%r16 + 0x0afa], %r6
	.word 0xea8c27d8  ! 1: LDUBA_I	lduba	[%r16, + 0x07d8] %asi, %r21
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6c42be8  ! 1: LDSWA_I	ldswa	[%r16, + 0x0be8] %asi, %r3
	.word 0xc6c42e20  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e20] %asi, %r3
	.word 0xd4042ea8  ! 1: LDUW_I	lduw	[%r16 + 0x0ea8], %r10
	brnz %r31,thr3_loop_cnt_565
	dec %r31
	.word 0x8c342155  ! 1: SUBC_I	orn 	%r16, 0x0155, %r6
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0x61, %r31
thr3_loop_cnt_566:
	.word 0xc6842bb4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0bb4] %asi, %r3
	.word 0xf44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r26
	.word 0xe40c244e  ! 1: LDUB_I	ldub	[%r16 + 0x044e], %r18
	.word 0xc6dc2c08  ! 1: LDXA_I	ldxa	[%r16, + 0x0c08] %asi, %r3
	.word 0xc68427b0  ! 1: LDUWA_I	lduwa	[%r16, + 0x07b0] %asi, %r3
	.word 0xe4142dba  ! 1: LDUH_I	lduh	[%r16 + 0x0dba], %r18
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xe8dc2238  ! 1: LDXA_I	ldxa	[%r16, + 0x0238] %asi, %r20
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	brnz %r31,thr3_loop_cnt_566
	dec %r31
	.word 0x863c2ed1  ! 1: XNOR_I	xnor 	%r16, 0x0ed1, %r3
        mov 0x27, %r31
thr3_loop_cnt_567:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf2c423f0  ! 1: LDSWA_I	ldswa	[%r16, + 0x03f0] %asi, %r25
	.word 0xea542c64  ! 1: LDSH_I	ldsh	[%r16 + 0x0c64], %r21
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xdac424fc  ! 1: LDSWA_I	ldswa	[%r16, + 0x04fc] %asi, %r13
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6542ba8  ! 1: LDSH_I	ldsh	[%r16 + 0x0ba8], %r3
	.word 0xdec420f8  ! 1: LDSWA_I	ldswa	[%r16, + 0x00f8] %asi, %r15
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_567
	dec %r31
        mov 0xaa, %r31
thr3_loop_cnt_568:
	.word 0xc6d421ec  ! 1: LDSHA_I	ldsha	[%r16, + 0x01ec] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xeed42340  ! 1: LDSHA_I	ldsha	[%r16, + 0x0340] %asi, %r23
	.word 0xc6c4207c  ! 1: LDSWA_I	ldswa	[%r16, + 0x007c] %asi, %r3
	.word 0xc64c22bd  ! 1: LDSB_I	ldsb	[%r16 + 0x02bd], %r3
	.word 0xf8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r28
	.word 0xc65c25f8  ! 1: LDX_I	ldx	[%r16 + 0x05f8], %r3
	.word 0xcc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r6
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd084244c  ! 1: LDUWA_I	lduwa	[%r16, + 0x044c] %asi, %r8
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_568
	dec %r31
	.word 0xa22c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r17
        mov 0x3e, %r31
thr3_loop_cnt_569:
	.word 0xf0cc2f86  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f86] %asi, %r24
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r17
	.word 0xc65c2d28  ! 1: LDX_I	ldx	[%r16 + 0x0d28], %r3
	.word 0xf0dc2360  ! 1: LDXA_I	ldxa	[%r16, + 0x0360] %asi, %r24
	.word 0xc6842a38  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a38] %asi, %r3
	.word 0xf8142222  ! 1: LDUH_I	lduh	[%r16 + 0x0222], %r28
	.word 0xc65c2aa8  ! 1: LDX_I	ldx	[%r16 + 0x0aa8], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_569
	dec %r31
	.word 0xbd2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r30
	.word 0x86042e71  ! 1: ADD_I	add 	%r16, 0x0e71, %r3
        mov 0x71, %r31
thr3_loop_cnt_570:
	.word 0xfc542336  ! 1: LDSH_I	ldsh	[%r16 + 0x0336], %r30
	.word 0xfcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r30
	.word 0xc6042ec8  ! 1: LDUW_I	lduw	[%r16 + 0x0ec8], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6442b9c  ! 1: LDSW_I	ldsw	[%r16 + 0x0b9c], %r3
	.word 0xdad4219e  ! 1: LDSHA_I	ldsha	[%r16, + 0x019e] %asi, %r13
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6942ed8  ! 1: LDUHA_I	lduha	[%r16, + 0x0ed8] %asi, %r3
	brnz %r31,thr3_loop_cnt_570
	dec %r31
	.word 0xa22c2261  ! 1: ANDN_I	andn 	%r16, 0x0261, %r17
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
        mov 0x67, %r31
thr3_loop_cnt_571:
	.word 0xde0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r15
	.word 0xf8042204  ! 1: LDUW_I	lduw	[%r16 + 0x0204], %r28
	.word 0xe60c29e3  ! 1: LDUB_I	ldub	[%r16 + 0x09e3], %r19
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xfcdc2568  ! 1: LDXA_I	ldxa	[%r16, + 0x0568] %asi, %r30
	.word 0xe694210e  ! 1: LDUHA_I	lduha	[%r16, + 0x010e] %asi, %r19
	.word 0xc60424ec  ! 1: LDUW_I	lduw	[%r16 + 0x04ec], %r3
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xf24c2b3b  ! 1: LDSB_I	ldsb	[%r16 + 0x0b3b], %r25
	brnz %r31,thr3_loop_cnt_571
	dec %r31
        mov 0x21, %r31
thr3_loop_cnt_572:
	.word 0xc6842d3c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d3c] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r27
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xde04289c  ! 1: LDUW_I	lduw	[%r16 + 0x089c], %r15
	.word 0xd8d42576  ! 1: LDSHA_I	ldsha	[%r16, + 0x0576] %asi, %r12
	.word 0xc6d42224  ! 1: LDSHA_I	ldsha	[%r16, + 0x0224] %asi, %r3
	brnz %r31,thr3_loop_cnt_572
	dec %r31
	.word 0x9c342ff0  ! 1: SUBC_I	orn 	%r16, 0x0ff0, %r14
	.word 0x860c24e4  ! 1: AND_I	and 	%r16, 0x04e4, %r3
        mov 0x9e, %r31
thr3_loop_cnt_573:
	.word 0xc6142c94  ! 1: LDUH_I	lduh	[%r16 + 0x0c94], %r3
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6442110  ! 1: LDSW_I	ldsw	[%r16 + 0x0110], %r3
	.word 0xce4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r7
	.word 0xe4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r18
	.word 0xf6842d98  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d98] %asi, %r27
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd2142aac  ! 1: LDUH_I	lduh	[%r16 + 0x0aac], %r9
	.word 0xf2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r25
	brnz %r31,thr3_loop_cnt_573
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0xa52c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r18
	.word 0xbc340002  ! 1: ORN_R	orn 	%r16, %r2, %r30
        mov 0x16, %r31
thr3_loop_cnt_574:
	.word 0xdedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r15
	.word 0xc6dc2740  ! 1: LDXA_I	ldxa	[%r16, + 0x0740] %asi, %r3
	.word 0xe64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r19
	.word 0xd8c42518  ! 1: LDSWA_I	ldswa	[%r16, + 0x0518] %asi, %r12
	.word 0xc6042238  ! 1: LDUW_I	lduw	[%r16 + 0x0238], %r3
	.word 0xdadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r13
	.word 0xea4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r21
	.word 0xcedc2f28  ! 1: LDXA_I	ldxa	[%r16, + 0x0f28] %asi, %r7
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_574
	dec %r31
	.word 0x860c222c  ! 1: AND_I	and 	%r16, 0x022c, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0xa7, %r31
thr3_loop_cnt_575:
	.word 0xe8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r20
	.word 0xc6442204  ! 1: LDSW_I	ldsw	[%r16 + 0x0204], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xdecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r15
	.word 0xf0442730  ! 1: LDSW_I	ldsw	[%r16 + 0x0730], %r24
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xfa5c2da8  ! 1: LDX_I	ldx	[%r16 + 0x0da8], %r29
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	.word 0xe20c248f  ! 1: LDUB_I	ldub	[%r16 + 0x048f], %r17
	brnz %r31,thr3_loop_cnt_575
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x860c25d1  ! 1: AND_I	and 	%r16, 0x05d1, %r3
	.word 0x8604259e  ! 1: ADD_I	add 	%r16, 0x059e, %r3
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0x94, %r31
thr3_loop_cnt_576:
	.word 0xf0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r24
	.word 0xfc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r30
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf0d4219a  ! 1: LDSHA_I	ldsha	[%r16, + 0x019a] %asi, %r24
	.word 0xc60c2861  ! 1: LDUB_I	ldub	[%r16 + 0x0861], %r3
	.word 0xf04c2284  ! 1: LDSB_I	ldsb	[%r16 + 0x0284], %r24
	.word 0xc6042b44  ! 1: LDUW_I	lduw	[%r16 + 0x0b44], %r3
	.word 0xc69422ee  ! 1: LDUHA_I	lduha	[%r16, + 0x02ee] %asi, %r3
	brnz %r31,thr3_loop_cnt_576
	dec %r31
	.word 0x86342374  ! 1: ORN_I	orn 	%r16, 0x0374, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x33, %r31
thr3_loop_cnt_577:
	.word 0xde941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r15
	.word 0xecdc2398  ! 1: LDXA_I	ldxa	[%r16, + 0x0398] %asi, %r22
	.word 0xfc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r30
	.word 0xda8c27ba  ! 1: LDUBA_I	lduba	[%r16, + 0x07ba] %asi, %r13
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6842f1c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f1c] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r20
	brnz %r31,thr3_loop_cnt_577
	dec %r31
	.word 0x9e2c2366  ! 1: ANDN_I	andn 	%r16, 0x0366, %r15
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x9c, %r31
thr3_loop_cnt_578:
	.word 0xc6cc27e6  ! 1: LDSBA_I	ldsba	[%r16, + 0x07e6] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xda440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r13
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd2042d80  ! 1: LDUW_I	lduw	[%r16 + 0x0d80], %r9
	.word 0xf0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r24
	.word 0xead42ad0  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ad0] %asi, %r21
	.word 0xf2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r25
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc654237c  ! 1: LDSH_I	ldsh	[%r16 + 0x037c], %r3
	.word 0xc64c2cf7  ! 1: LDSB_I	ldsb	[%r16 + 0x0cf7], %r3
	brnz %r31,thr3_loop_cnt_578
	dec %r31
	.word 0x8e340002  ! 1: SUBC_R	orn 	%r16, %r2, %r7
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0x69, %r31
thr3_loop_cnt_579:
	.word 0xd68c2094  ! 1: LDUBA_I	lduba	[%r16, + 0x0094] %asi, %r11
	.word 0xe8542184  ! 1: LDSH_I	ldsh	[%r16 + 0x0184], %r20
	.word 0xc6042118  ! 1: LDUW_I	lduw	[%r16 + 0x0118], %r3
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xc6dc2618  ! 1: LDXA_I	ldxa	[%r16, + 0x0618] %asi, %r3
	.word 0xd0542ee0  ! 1: LDSH_I	ldsh	[%r16 + 0x0ee0], %r8
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xda142222  ! 1: LDUH_I	lduh	[%r16 + 0x0222], %r13
	brnz %r31,thr3_loop_cnt_579
	dec %r31
        mov 0x62, %r31
thr3_loop_cnt_580:
	.word 0xc64c2d59  ! 1: LDSB_I	ldsb	[%r16 + 0x0d59], %r3
	.word 0xf2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r25
	.word 0xc65c2b70  ! 1: LDX_I	ldx	[%r16 + 0x0b70], %r3
	.word 0xf0542f8a  ! 1: LDSH_I	ldsh	[%r16 + 0x0f8a], %r24
	.word 0xc6c421e0  ! 1: LDSWA_I	ldswa	[%r16, + 0x01e0] %asi, %r3
	.word 0xc6942038  ! 1: LDUHA_I	lduha	[%r16, + 0x0038] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc68c250e  ! 1: LDUBA_I	lduba	[%r16, + 0x050e] %asi, %r3
	brnz %r31,thr3_loop_cnt_580
	dec %r31
        mov 0x2e, %r31
thr3_loop_cnt_581:
	.word 0xec0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r22
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd4d42250  ! 1: LDSHA_I	ldsha	[%r16, + 0x0250] %asi, %r10
	.word 0xda4c239d  ! 1: LDSB_I	ldsb	[%r16 + 0x039d], %r13
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xee5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r23
	.word 0xced41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r7
	.word 0xf68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r27
	.word 0xfc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r30
	.word 0xe64c2bb9  ! 1: LDSB_I	ldsb	[%r16 + 0x0bb9], %r19
	.word 0xc60c267f  ! 1: LDUB_I	ldub	[%r16 + 0x067f], %r3
	brnz %r31,thr3_loop_cnt_581
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x9e2c2b04  ! 1: ANDN_I	andn 	%r16, 0x0b04, %r15
	.word 0x98142133  ! 1: OR_I	or 	%r16, 0x0133, %r12
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0x39, %r31
thr3_loop_cnt_582:
	.word 0xc6842fcc  ! 1: LDUWA_I	lduwa	[%r16, + 0x0fcc] %asi, %r3
	.word 0xecd42df8  ! 1: LDSHA_I	ldsha	[%r16, + 0x0df8] %asi, %r22
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xda842fbc  ! 1: LDUWA_I	lduwa	[%r16, + 0x0fbc] %asi, %r13
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xe8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r20
	.word 0xc6542d40  ! 1: LDSH_I	ldsh	[%r16 + 0x0d40], %r3
	.word 0xc68c23f8  ! 1: LDUBA_I	lduba	[%r16, + 0x03f8] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_582
	dec %r31
	.word 0x96042f51  ! 1: ADD_I	add 	%r16, 0x0f51, %r11
        mov 0x20, %r31
thr3_loop_cnt_583:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc60c2b07  ! 1: LDUB_I	ldub	[%r16 + 0x0b07], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c2efa  ! 1: LDSB_I	ldsb	[%r16 + 0x0efa], %r3
	.word 0xc6d423b4  ! 1: LDSHA_I	ldsha	[%r16, + 0x03b4] %asi, %r3
	brnz %r31,thr3_loop_cnt_583
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0xb62c2dcb  ! 1: ANDN_I	andn 	%r16, 0x0dcb, %r27
	.word 0x92240002  ! 1: SUB_R	sub 	%r16, %r2, %r9
        mov 0x83, %r31
thr3_loop_cnt_584:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc60c2ec6  ! 1: LDUB_I	ldub	[%r16 + 0x0ec6], %r3
	.word 0xc6d42dd6  ! 1: LDSHA_I	ldsha	[%r16, + 0x0dd6] %asi, %r3
	.word 0xfacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r29
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6c425fc  ! 1: LDSWA_I	ldswa	[%r16, + 0x05fc] %asi, %r3
	.word 0xee0c2ba9  ! 1: LDUB_I	ldub	[%r16 + 0x0ba9], %r23
	.word 0xc64c223a  ! 1: LDSB_I	ldsb	[%r16 + 0x023a], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_584
	dec %r31
	.word 0x862c2056  ! 1: ANDN_I	andn 	%r16, 0x0056, %r3
	.word 0x904426bf  ! 1: ADDC_I	addc 	%r16, 0x06bf, %r8
        mov 0x6f, %r31
thr3_loop_cnt_585:
	.word 0xc61421b4  ! 1: LDUH_I	lduh	[%r16 + 0x01b4], %r3
	.word 0xc6dc2908  ! 1: LDXA_I	ldxa	[%r16, + 0x0908] %asi, %r3
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	.word 0xc6dc2eb8  ! 1: LDXA_I	ldxa	[%r16, + 0x0eb8] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xce040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r7
	.word 0xc6842738  ! 1: LDUWA_I	lduwa	[%r16, + 0x0738] %asi, %r3
	.word 0xc6c42854  ! 1: LDSWA_I	ldswa	[%r16, + 0x0854] %asi, %r3
	brnz %r31,thr3_loop_cnt_585
	dec %r31
	.word 0xb5343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r26
	.word 0xba340002  ! 1: SUBC_R	orn 	%r16, %r2, %r29
	.word 0x9f342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r15
        mov 0x35, %r31
thr3_loop_cnt_586:
	.word 0xc60424f8  ! 1: LDUW_I	lduw	[%r16 + 0x04f8], %r3
	.word 0xf8d426c8  ! 1: LDSHA_I	ldsha	[%r16, + 0x06c8] %asi, %r28
	.word 0xf4d42230  ! 1: LDSHA_I	ldsha	[%r16, + 0x0230] %asi, %r26
	.word 0xf4942d1c  ! 1: LDUHA_I	lduha	[%r16, + 0x0d1c] %asi, %r26
	.word 0xd0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r8
	.word 0xfc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r30
	.word 0xc6442b88  ! 1: LDSW_I	ldsw	[%r16 + 0x0b88], %r3
	.word 0xd8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r12
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_586
	dec %r31
	.word 0xb12c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r24
	.word 0xa21c0002  ! 1: XOR_R	xor 	%r16, %r2, %r17
	.word 0x9c340002  ! 1: ORN_R	orn 	%r16, %r2, %r14
        mov 0x94, %r31
thr3_loop_cnt_587:
	.word 0xd4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r10
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xfcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r30
	.word 0xf60c2f0d  ! 1: LDUB_I	ldub	[%r16 + 0x0f0d], %r27
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r11
	brnz %r31,thr3_loop_cnt_587
	dec %r31
        mov 0xb3, %r31
thr3_loop_cnt_588:
	.word 0xc6dc2430  ! 1: LDXA_I	ldxa	[%r16, + 0x0430] %asi, %r3
	.word 0xfc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r30
	.word 0xe2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r17
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6d42386  ! 1: LDSHA_I	ldsha	[%r16, + 0x0386] %asi, %r3
	.word 0xc6cc2b2f  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b2f] %asi, %r3
	.word 0xe8842ed8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ed8] %asi, %r20
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6442350  ! 1: LDSW_I	ldsw	[%r16 + 0x0350], %r3
	.word 0xc60424f0  ! 1: LDUW_I	lduw	[%r16 + 0x04f0], %r3
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	brnz %r31,thr3_loop_cnt_588
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0x2a, %r31
thr3_loop_cnt_589:
	.word 0xc64c217d  ! 1: LDSB_I	ldsb	[%r16 + 0x017d], %r3
	.word 0xea841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r21
	.word 0xf85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r28
	.word 0xd25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r9
	.word 0xc65c23e8  ! 1: LDX_I	ldx	[%r16 + 0x03e8], %r3
	.word 0xd85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r12
	.word 0xc6042df8  ! 1: LDUW_I	lduw	[%r16 + 0x0df8], %r3
	.word 0xc6142142  ! 1: LDUH_I	lduh	[%r16 + 0x0142], %r3
	brnz %r31,thr3_loop_cnt_589
	dec %r31
	.word 0x92440002  ! 1: ADDC_R	addc 	%r16, %r2, %r9
	.word 0xab3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r21
	.word 0x993c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r12
        mov 0x2e, %r31
thr3_loop_cnt_590:
	.word 0xc6cc26da  ! 1: LDSBA_I	ldsba	[%r16, + 0x06da] %asi, %r3
	.word 0xe6c42298  ! 1: LDSWA_I	ldswa	[%r16, + 0x0298] %asi, %r19
	.word 0xc68c2fd8  ! 1: LDUBA_I	lduba	[%r16, + 0x0fd8] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc65424e8  ! 1: LDSH_I	ldsh	[%r16 + 0x04e8], %r3
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	.word 0xd2842db4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0db4] %asi, %r9
	.word 0xc6442834  ! 1: LDSW_I	ldsw	[%r16 + 0x0834], %r3
	.word 0xde5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r15
	.word 0xcecc23ae  ! 1: LDSBA_I	ldsba	[%r16, + 0x03ae] %asi, %r7
	brnz %r31,thr3_loop_cnt_590
	dec %r31
	.word 0x8d3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r6
	.word 0x90142afa  ! 1: OR_I	or 	%r16, 0x0afa, %r8
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x4, %r31
thr3_loop_cnt_591:
	.word 0xc60c25da  ! 1: LDUB_I	ldub	[%r16 + 0x05da], %r3
	.word 0xcc8c21a7  ! 1: LDUBA_I	lduba	[%r16, + 0x01a7] %asi, %r6
	.word 0xd08c2f84  ! 1: LDUBA_I	lduba	[%r16, + 0x0f84] %asi, %r8
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc614275e  ! 1: LDUH_I	lduh	[%r16 + 0x075e], %r3
	.word 0xc68c2841  ! 1: LDUBA_I	lduba	[%r16, + 0x0841] %asi, %r3
	.word 0xe2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r17
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xda5c2700  ! 1: LDX_I	ldx	[%r16 + 0x0700], %r13
	.word 0xfc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r30
	brnz %r31,thr3_loop_cnt_591
	dec %r31
	.word 0xa7341002  ! 1: SRLX_R	srlx	%r16, %r2, %r19
	.word 0x8c1c2557  ! 1: XOR_I	xor 	%r16, 0x0557, %r6
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0xa9342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r20
        mov 0x6f, %r31
thr3_loop_cnt_592:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc65c2b40  ! 1: LDX_I	ldx	[%r16 + 0x0b40], %r3
	.word 0xc6542f6e  ! 1: LDSH_I	ldsh	[%r16 + 0x0f6e], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xde842818  ! 1: LDUWA_I	lduwa	[%r16, + 0x0818] %asi, %r15
	.word 0xea14284a  ! 1: LDUH_I	lduh	[%r16 + 0x084a], %r21
	.word 0xea841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r21
	.word 0xc6dc28a0  ! 1: LDXA_I	ldxa	[%r16, + 0x08a0] %asi, %r3
	brnz %r31,thr3_loop_cnt_592
	dec %r31
	.word 0xb1343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r24
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x1c, %r31
thr3_loop_cnt_593:
	.word 0xc60c28d8  ! 1: LDUB_I	ldub	[%r16 + 0x08d8], %r3
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xc64c292b  ! 1: LDSB_I	ldsb	[%r16 + 0x092b], %r3
	.word 0xe25c2290  ! 1: LDX_I	ldx	[%r16 + 0x0290], %r17
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xf2d42200  ! 1: LDSHA_I	ldsha	[%r16, + 0x0200] %asi, %r25
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6d420a0  ! 1: LDSHA_I	ldsha	[%r16, + 0x00a0] %asi, %r3
	brnz %r31,thr3_loop_cnt_593
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0xb844232b  ! 1: ADDC_I	addc 	%r16, 0x032b, %r28
	.word 0xb8042537  ! 1: ADD_I	add 	%r16, 0x0537, %r28
        mov 0x53, %r31
thr3_loop_cnt_594:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xded424f4  ! 1: LDSHA_I	ldsha	[%r16, + 0x04f4] %asi, %r15
	.word 0xcc5c23b0  ! 1: LDX_I	ldx	[%r16 + 0x03b0], %r6
	.word 0xcc5c2260  ! 1: LDX_I	ldx	[%r16 + 0x0260], %r6
	.word 0xf68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r27
	.word 0xd6c42788  ! 1: LDSWA_I	ldswa	[%r16, + 0x0788] %asi, %r11
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6142bc4  ! 1: LDUH_I	lduh	[%r16 + 0x0bc4], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_594
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x86142c95  ! 1: OR_I	or 	%r16, 0x0c95, %r3
	.word 0x96140002  ! 1: OR_R	or 	%r16, %r2, %r11
        mov 0x32, %r31
thr3_loop_cnt_595:
	.word 0xf40c27ff  ! 1: LDUB_I	ldub	[%r16 + 0x07ff], %r26
	.word 0xc6442140  ! 1: LDSW_I	ldsw	[%r16 + 0x0140], %r3
	.word 0xdc94202e  ! 1: LDUHA_I	lduha	[%r16, + 0x002e] %asi, %r14
	.word 0xea142094  ! 1: LDUH_I	lduh	[%r16 + 0x0094], %r21
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r26
	.word 0xf24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r25
	.word 0xea440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r21
	.word 0xc6842738  ! 1: LDUWA_I	lduwa	[%r16, + 0x0738] %asi, %r3
	.word 0xe6442004  ! 1: LDSW_I	ldsw	[%r16 + 0x0004], %r19
	brnz %r31,thr3_loop_cnt_595
	dec %r31
        mov 0x51, %r31
thr3_loop_cnt_596:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6142cee  ! 1: LDUH_I	lduh	[%r16 + 0x0cee], %r3
	.word 0xd2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r9
	.word 0xe6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r19
	.word 0xf8542064  ! 1: LDSH_I	ldsh	[%r16 + 0x0064], %r28
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_596
	dec %r31
	.word 0xbd3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r30
	.word 0xb63c239f  ! 1: XNOR_I	xnor 	%r16, 0x039f, %r27
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0xe, %r31
thr3_loop_cnt_597:
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r27
	.word 0xc64c2bec  ! 1: LDSB_I	ldsb	[%r16 + 0x0bec], %r3
	.word 0xd48423b0  ! 1: LDUWA_I	lduwa	[%r16, + 0x03b0] %asi, %r10
	.word 0xf2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r25
	.word 0xc64c2ec7  ! 1: LDSB_I	ldsb	[%r16 + 0x0ec7], %r3
	.word 0xd2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r9
	.word 0xc6042fd8  ! 1: LDUW_I	lduw	[%r16 + 0x0fd8], %r3
	.word 0xc6d42cb8  ! 1: LDSHA_I	ldsha	[%r16, + 0x0cb8] %asi, %r3
	brnz %r31,thr3_loop_cnt_597
	dec %r31
        mov 0x4d, %r31
thr3_loop_cnt_598:
	.word 0xc6dc2e28  ! 1: LDXA_I	ldxa	[%r16, + 0x0e28] %asi, %r3
	.word 0xf8542464  ! 1: LDSH_I	ldsh	[%r16 + 0x0464], %r28
	.word 0xc6142224  ! 1: LDUH_I	lduh	[%r16 + 0x0224], %r3
	.word 0xded42d04  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d04] %asi, %r15
	.word 0xc64c24cf  ! 1: LDSB_I	ldsb	[%r16 + 0x04cf], %r3
	.word 0xc6d420a8  ! 1: LDSHA_I	ldsha	[%r16, + 0x00a8] %asi, %r3
	.word 0xc6d42dc8  ! 1: LDSHA_I	ldsha	[%r16, + 0x0dc8] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc68c20ca  ! 1: LDUBA_I	lduba	[%r16, + 0x00ca] %asi, %r3
	.word 0xde8422a0  ! 1: LDUWA_I	lduwa	[%r16, + 0x02a0] %asi, %r15
	brnz %r31,thr3_loop_cnt_598
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x15, %r31
thr3_loop_cnt_599:
	.word 0xccdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r6
	.word 0xe6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r19
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd6d42fd2  ! 1: LDSHA_I	ldsha	[%r16, + 0x0fd2] %asi, %r11
	.word 0xce84254c  ! 1: LDUWA_I	lduwa	[%r16, + 0x054c] %asi, %r7
	.word 0xde8c2378  ! 1: LDUBA_I	lduba	[%r16, + 0x0378] %asi, %r15
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc694296c  ! 1: LDUHA_I	lduha	[%r16, + 0x096c] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6dc29b0  ! 1: LDXA_I	ldxa	[%r16, + 0x09b0] %asi, %r3
	brnz %r31,thr3_loop_cnt_599
	dec %r31
	.word 0x8614270e  ! 1: OR_I	or 	%r16, 0x070e, %r3
	.word 0x9a0c0002  ! 1: AND_R	and 	%r16, %r2, %r13
        mov 0x91, %r31
thr3_loop_cnt_600:
	.word 0xc64c2ce3  ! 1: LDSB_I	ldsb	[%r16 + 0x0ce3], %r3
	.word 0xf0442300  ! 1: LDSW_I	ldsw	[%r16 + 0x0300], %r24
	.word 0xecc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r22
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6542004  ! 1: LDSH_I	ldsh	[%r16 + 0x0004], %r3
	.word 0xd4c42624  ! 1: LDSWA_I	ldswa	[%r16, + 0x0624] %asi, %r10
	.word 0xf88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r28
	.word 0xc68c2dbc  ! 1: LDUBA_I	lduba	[%r16, + 0x0dbc] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	brnz %r31,thr3_loop_cnt_600
	dec %r31
	.word 0x90342a0f  ! 1: SUBC_I	orn 	%r16, 0x0a0f, %r8
	.word 0xad340002  ! 1: SRL_R	srl 	%r16, %r2, %r22
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0xa6, %r31
thr3_loop_cnt_601:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r27
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6942182  ! 1: LDUHA_I	lduha	[%r16, + 0x0182] %asi, %r3
	.word 0xc60c2e6c  ! 1: LDUB_I	ldub	[%r16 + 0x0e6c], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6cc2814  ! 1: LDSBA_I	ldsba	[%r16, + 0x0814] %asi, %r3
	.word 0xf0cc2294  ! 1: LDSBA_I	ldsba	[%r16, + 0x0294] %asi, %r24
	.word 0xc6842980  ! 1: LDUWA_I	lduwa	[%r16, + 0x0980] %asi, %r3
	.word 0xc6942602  ! 1: LDUHA_I	lduha	[%r16, + 0x0602] %asi, %r3
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_601
	dec %r31
	.word 0x861c2e94  ! 1: XOR_I	xor 	%r16, 0x0e94, %r3
	.word 0x96342a06  ! 1: SUBC_I	orn 	%r16, 0x0a06, %r11
        mov 0x55, %r31
thr3_loop_cnt_602:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xfc8c2aa4  ! 1: LDUBA_I	lduba	[%r16, + 0x0aa4] %asi, %r30
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6442bd8  ! 1: LDSW_I	ldsw	[%r16 + 0x0bd8], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6142464  ! 1: LDUH_I	lduh	[%r16 + 0x0464], %r3
	.word 0xc6dc22c8  ! 1: LDXA_I	ldxa	[%r16, + 0x02c8] %asi, %r3
	brnz %r31,thr3_loop_cnt_602
	dec %r31
        mov 0x1c, %r31
thr3_loop_cnt_603:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r28
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xecd42d0c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d0c] %asi, %r22
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe8c421a4  ! 1: LDSWA_I	ldswa	[%r16, + 0x01a4] %asi, %r20
	.word 0xdedc2b68  ! 1: LDXA_I	ldxa	[%r16, + 0x0b68] %asi, %r15
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_603
	dec %r31
        mov 0x52, %r31
thr3_loop_cnt_604:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r18
	.word 0xc6dc2910  ! 1: LDXA_I	ldxa	[%r16, + 0x0910] %asi, %r3
	.word 0xfa841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r29
	.word 0xc6942210  ! 1: LDUHA_I	lduha	[%r16, + 0x0210] %asi, %r3
	.word 0xc694257a  ! 1: LDUHA_I	lduha	[%r16, + 0x057a] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf0942550  ! 1: LDUHA_I	lduha	[%r16, + 0x0550] %asi, %r24
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc64c21a3  ! 1: LDSB_I	ldsb	[%r16 + 0x01a3], %r3
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	brnz %r31,thr3_loop_cnt_604
	dec %r31
        mov 0x25, %r31
thr3_loop_cnt_605:
	.word 0xc6dc2a60  ! 1: LDXA_I	ldxa	[%r16, + 0x0a60] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf40c2a40  ! 1: LDUB_I	ldub	[%r16 + 0x0a40], %r26
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	.word 0xdcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r14
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_605
	dec %r31
	.word 0x86442f65  ! 1: ADDC_I	addc 	%r16, 0x0f65, %r3
	.word 0x86142f11  ! 1: OR_I	or 	%r16, 0x0f11, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x5f, %r31
thr3_loop_cnt_606:
	.word 0xc68c24e7  ! 1: LDUBA_I	lduba	[%r16, + 0x04e7] %asi, %r3
	.word 0xd4d42c8a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c8a] %asi, %r10
	.word 0xd4d42ed6  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ed6] %asi, %r10
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	.word 0xf49425bc  ! 1: LDUHA_I	lduha	[%r16, + 0x05bc] %asi, %r26
	.word 0xce8420d0  ! 1: LDUWA_I	lduwa	[%r16, + 0x00d0] %asi, %r7
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xde4c2d22  ! 1: LDSB_I	ldsb	[%r16 + 0x0d22], %r15
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf2dc2920  ! 1: LDXA_I	ldxa	[%r16, + 0x0920] %asi, %r25
	brnz %r31,thr3_loop_cnt_606
	dec %r31
	.word 0x97342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r11
        mov 0xc7, %r31
thr3_loop_cnt_607:
	.word 0xc6542c18  ! 1: LDSH_I	ldsh	[%r16 + 0x0c18], %r3
	.word 0xec540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r22
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd80426f4  ! 1: LDUW_I	lduw	[%r16 + 0x06f4], %r12
	.word 0xc6142f28  ! 1: LDUH_I	lduh	[%r16 + 0x0f28], %r3
	.word 0xee941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r23
	.word 0xec040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r22
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd6042fcc  ! 1: LDUW_I	lduw	[%r16 + 0x0fcc], %r11
	.word 0xd4842980  ! 1: LDUWA_I	lduwa	[%r16, + 0x0980] %asi, %r10
	brnz %r31,thr3_loop_cnt_607
	dec %r31
	.word 0xb92c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r28
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x860c2bc8  ! 1: AND_I	and 	%r16, 0x0bc8, %r3
        mov 0xba, %r31
thr3_loop_cnt_608:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf28c2b62  ! 1: LDUBA_I	lduba	[%r16, + 0x0b62] %asi, %r25
	.word 0xdcc42534  ! 1: LDSWA_I	ldswa	[%r16, + 0x0534] %asi, %r14
	.word 0xce4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r7
	.word 0xc6442fe8  ! 1: LDSW_I	ldsw	[%r16 + 0x0fe8], %r3
	.word 0xc6dc2200  ! 1: LDXA_I	ldxa	[%r16, + 0x0200] %asi, %r3
	.word 0xcc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r6
	.word 0xc6d421b8  ! 1: LDSHA_I	ldsha	[%r16, + 0x01b8] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xe8142728  ! 1: LDUH_I	lduh	[%r16 + 0x0728], %r20
	brnz %r31,thr3_loop_cnt_608
	dec %r31
	.word 0x992c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r12
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x952c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r10
	.word 0x862c2d87  ! 1: ANDN_I	andn 	%r16, 0x0d87, %r3
        mov 0xc7, %r31
thr3_loop_cnt_609:
	.word 0xc6842dc8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0dc8] %asi, %r3
	.word 0xf8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r28
	.word 0xc6542218  ! 1: LDSH_I	ldsh	[%r16 + 0x0218], %r3
	.word 0xc65c20c0  ! 1: LDX_I	ldx	[%r16 + 0x00c0], %r3
	.word 0xde0c2a91  ! 1: LDUB_I	ldub	[%r16 + 0x0a91], %r15
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xdcdc2cf0  ! 1: LDXA_I	ldxa	[%r16, + 0x0cf0] %asi, %r14
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc24e8  ! 1: LDXA_I	ldxa	[%r16, + 0x04e8] %asi, %r3
	.word 0xfa042b50  ! 1: LDUW_I	lduw	[%r16 + 0x0b50], %r29
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xde8425b4  ! 1: LDUWA_I	lduwa	[%r16, + 0x05b4] %asi, %r15
	brnz %r31,thr3_loop_cnt_609
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x9f3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r15
	.word 0xac2c2857  ! 1: ANDN_I	andn 	%r16, 0x0857, %r22
        mov 0x55, %r31
thr3_loop_cnt_610:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc68c2d32  ! 1: LDUBA_I	lduba	[%r16, + 0x0d32] %asi, %r3
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xf68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r27
	.word 0xde5c2ed8  ! 1: LDX_I	ldx	[%r16 + 0x0ed8], %r15
	.word 0xc6442908  ! 1: LDSW_I	ldsw	[%r16 + 0x0908], %r3
	.word 0xc6142a3a  ! 1: LDUH_I	lduh	[%r16 + 0x0a3a], %r3
	.word 0xd014259e  ! 1: LDUH_I	lduh	[%r16 + 0x059e], %r8
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_610
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x86142dd9  ! 1: OR_I	or 	%r16, 0x0dd9, %r3
        mov 0x5, %r31
thr3_loop_cnt_611:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6442ea4  ! 1: LDSW_I	ldsw	[%r16 + 0x0ea4], %r3
	.word 0xd45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r10
	.word 0xde841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r15
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r24
	.word 0xd0942a06  ! 1: LDUHA_I	lduha	[%r16, + 0x0a06] %asi, %r8
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6942526  ! 1: LDUHA_I	lduha	[%r16, + 0x0526] %asi, %r3
	brnz %r31,thr3_loop_cnt_611
	dec %r31
        mov 0x93, %r31
thr3_loop_cnt_612:
	.word 0xc6542454  ! 1: LDSH_I	ldsh	[%r16 + 0x0454], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r20
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xfa841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r29
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	.word 0xf25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r25
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xecd422e6  ! 1: LDSHA_I	ldsha	[%r16, + 0x02e6] %asi, %r22
	brnz %r31,thr3_loop_cnt_612
	dec %r31
        mov 0x8d, %r31
thr3_loop_cnt_613:
	.word 0xc60c2d3e  ! 1: LDUB_I	ldub	[%r16 + 0x0d3e], %r3
	.word 0xe60c2bdc  ! 1: LDUB_I	ldub	[%r16 + 0x0bdc], %r19
	.word 0xe45c27f0  ! 1: LDX_I	ldx	[%r16 + 0x07f0], %r18
	.word 0xc6dc2ab0  ! 1: LDXA_I	ldxa	[%r16, + 0x0ab0] %asi, %r3
	.word 0xc6cc2ef2  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ef2] %asi, %r3
	.word 0xf8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r28
	.word 0xea442af8  ! 1: LDSW_I	ldsw	[%r16 + 0x0af8], %r21
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc65c2e30  ! 1: LDX_I	ldx	[%r16 + 0x0e30], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_613
	dec %r31
	.word 0x862c2ddc  ! 1: ANDN_I	andn 	%r16, 0x0ddc, %r3
        mov 0x78, %r31
thr3_loop_cnt_614:
	.word 0xd44c2e97  ! 1: LDSB_I	ldsb	[%r16 + 0x0e97], %r10
	.word 0xe4cc2cea  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cea] %asi, %r18
	.word 0xd0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r8
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc60423f8  ! 1: LDUW_I	lduw	[%r16 + 0x03f8], %r3
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_614
	dec %r31
        mov 0x73, %r31
thr3_loop_cnt_615:
	.word 0xc6c4248c  ! 1: LDSWA_I	ldswa	[%r16, + 0x048c] %asi, %r3
	.word 0xc60c2fdf  ! 1: LDUB_I	ldub	[%r16 + 0x0fdf], %r3
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xe2d42ba6  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ba6] %asi, %r17
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r18
	.word 0xc64c2442  ! 1: LDSB_I	ldsb	[%r16 + 0x0442], %r3
	.word 0xc644240c  ! 1: LDSW_I	ldsw	[%r16 + 0x040c], %r3
	.word 0xded42150  ! 1: LDSHA_I	ldsha	[%r16, + 0x0150] %asi, %r15
	brnz %r31,thr3_loop_cnt_615
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x86142db5  ! 1: OR_I	or 	%r16, 0x0db5, %r3
	.word 0x93340002  ! 1: SRL_R	srl 	%r16, %r2, %r9
        mov 0xa5, %r31
thr3_loop_cnt_616:
	.word 0xc6942ce8  ! 1: LDUHA_I	lduha	[%r16, + 0x0ce8] %asi, %r3
	.word 0xc6042e28  ! 1: LDUW_I	lduw	[%r16 + 0x0e28], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd6542166  ! 1: LDSH_I	ldsh	[%r16 + 0x0166], %r11
	.word 0xdedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r15
	.word 0xda142fa4  ! 1: LDUH_I	lduh	[%r16 + 0x0fa4], %r13
	.word 0xc69425cc  ! 1: LDUHA_I	lduha	[%r16, + 0x05cc] %asi, %r3
	.word 0xd6d429c0  ! 1: LDSHA_I	ldsha	[%r16, + 0x09c0] %asi, %r11
	brnz %r31,thr3_loop_cnt_616
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x6c, %r31
thr3_loop_cnt_617:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r24
	.word 0xd48c26b8  ! 1: LDUBA_I	lduba	[%r16, + 0x06b8] %asi, %r10
	.word 0xd84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r12
	.word 0xc61426f6  ! 1: LDUH_I	lduh	[%r16 + 0x06f6], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe2442dd0  ! 1: LDSW_I	ldsw	[%r16 + 0x0dd0], %r17
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xead42bd8  ! 1: LDSHA_I	ldsha	[%r16, + 0x0bd8] %asi, %r21
	brnz %r31,thr3_loop_cnt_617
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x940421fa  ! 1: ADD_I	add 	%r16, 0x01fa, %r10
	.word 0x8f3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r7
        mov 0x24, %r31
thr3_loop_cnt_618:
	.word 0xdcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r14
	.word 0xdcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r14
	.word 0xe6042e28  ! 1: LDUW_I	lduw	[%r16 + 0x0e28], %r19
	.word 0xde5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r15
	.word 0xe4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r18
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6c424d4  ! 1: LDSWA_I	ldswa	[%r16, + 0x04d4] %asi, %r3
	.word 0xc6942e5a  ! 1: LDUHA_I	lduha	[%r16, + 0x0e5a] %asi, %r3
	.word 0xf2c4275c  ! 1: LDSWA_I	ldswa	[%r16, + 0x075c] %asi, %r25
	brnz %r31,thr3_loop_cnt_618
	dec %r31
        mov 0xc0, %r31
thr3_loop_cnt_619:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r19
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r28
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6542046  ! 1: LDSH_I	ldsh	[%r16 + 0x0046], %r3
	.word 0xd2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r9
	.word 0xcc042bb8  ! 1: LDUW_I	lduw	[%r16 + 0x0bb8], %r6
	brnz %r31,thr3_loop_cnt_619
	dec %r31
	.word 0xb5343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r26
        mov 0x30, %r31
thr3_loop_cnt_620:
	.word 0xe6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r19
	.word 0xc6cc2992  ! 1: LDSBA_I	ldsba	[%r16, + 0x0992] %asi, %r3
	.word 0xf6842dc0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0dc0] %asi, %r27
	.word 0xc60c2296  ! 1: LDUB_I	ldub	[%r16 + 0x0296], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe6542588  ! 1: LDSH_I	ldsh	[%r16 + 0x0588], %r19
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6c42b58  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b58] %asi, %r3
	.word 0xc60420dc  ! 1: LDUW_I	lduw	[%r16 + 0x00dc], %r3
	brnz %r31,thr3_loop_cnt_620
	dec %r31
	.word 0x941c21d5  ! 1: XOR_I	xor 	%r16, 0x01d5, %r10
        mov 0x3d, %r31
thr3_loop_cnt_621:
	.word 0xd4dc2168  ! 1: LDXA_I	ldxa	[%r16, + 0x0168] %asi, %r10
	.word 0xd8442014  ! 1: LDSW_I	ldsw	[%r16 + 0x0014], %r12
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe80c2480  ! 1: LDUB_I	ldub	[%r16 + 0x0480], %r20
	.word 0xf8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r28
	.word 0xd0cc22fc  ! 1: LDSBA_I	ldsba	[%r16, + 0x02fc] %asi, %r8
	.word 0xf4542dfa  ! 1: LDSH_I	ldsh	[%r16 + 0x0dfa], %r26
	.word 0xe2cc2411  ! 1: LDSBA_I	ldsba	[%r16, + 0x0411] %asi, %r17
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6542dd8  ! 1: LDSH_I	ldsh	[%r16 + 0x0dd8], %r3
	.word 0xc6042088  ! 1: LDUW_I	lduw	[%r16 + 0x0088], %r3
	brnz %r31,thr3_loop_cnt_621
	dec %r31
	.word 0x862c2e7c  ! 1: ANDN_I	andn 	%r16, 0x0e7c, %r3
	.word 0x960c0002  ! 1: AND_R	and 	%r16, %r2, %r11
	.word 0x96142f2c  ! 1: OR_I	or 	%r16, 0x0f2c, %r11
	.word 0x953c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r10
        mov 0x83, %r31
thr3_loop_cnt_622:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xea941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r21
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xdc542078  ! 1: LDSH_I	ldsh	[%r16 + 0x0078], %r14
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6542398  ! 1: LDSH_I	ldsh	[%r16 + 0x0398], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xc68c2bd7  ! 1: LDUBA_I	lduba	[%r16, + 0x0bd7] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xfacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r29
	brnz %r31,thr3_loop_cnt_622
	dec %r31
	.word 0xbd3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r30
	.word 0x941c0002  ! 1: XOR_R	xor 	%r16, %r2, %r10
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0x7b, %r31
thr3_loop_cnt_623:
	.word 0xf8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r28
	.word 0xc6442048  ! 1: LDSW_I	ldsw	[%r16 + 0x0048], %r3
	.word 0xc60c23ce  ! 1: LDUB_I	ldub	[%r16 + 0x03ce], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xcc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r6
	.word 0xd2942c24  ! 1: LDUHA_I	lduha	[%r16, + 0x0c24] %asi, %r9
	.word 0xd08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r8
	.word 0xd85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r12
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc604275c  ! 1: LDUW_I	lduw	[%r16 + 0x075c], %r3
	brnz %r31,thr3_loop_cnt_623
	dec %r31
	.word 0x864426a6  ! 1: ADDC_I	addc 	%r16, 0x06a6, %r3
	.word 0x9d3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r14
	.word 0x96340002  ! 1: SUBC_R	orn 	%r16, %r2, %r11
	.word 0xba1c243a  ! 1: XOR_I	xor 	%r16, 0x043a, %r29
        mov 0x1a, %r31
thr3_loop_cnt_624:
	.word 0xc654284e  ! 1: LDSH_I	ldsh	[%r16 + 0x084e], %r3
	.word 0xf8442ff4  ! 1: LDSW_I	ldsw	[%r16 + 0x0ff4], %r28
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc68c29fc  ! 1: LDUBA_I	lduba	[%r16, + 0x09fc] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2728  ! 1: LDXA_I	ldxa	[%r16, + 0x0728] %asi, %r3
	.word 0xded42ab6  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ab6] %asi, %r15
	brnz %r31,thr3_loop_cnt_624
	dec %r31
	.word 0x86142805  ! 1: OR_I	or 	%r16, 0x0805, %r3
	.word 0xaa3427b4  ! 1: ORN_I	orn 	%r16, 0x07b4, %r21
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0xbf, %r31
thr3_loop_cnt_625:
	.word 0xfa0c246d  ! 1: LDUB_I	ldub	[%r16 + 0x046d], %r29
	.word 0xccdc25f8  ! 1: LDXA_I	ldxa	[%r16, + 0x05f8] %asi, %r6
	.word 0xf25c2208  ! 1: LDX_I	ldx	[%r16 + 0x0208], %r25
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	.word 0xe8dc26f8  ! 1: LDXA_I	ldxa	[%r16, + 0x06f8] %asi, %r20
	.word 0xc6142718  ! 1: LDUH_I	lduh	[%r16 + 0x0718], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6442610  ! 1: LDSW_I	ldsw	[%r16 + 0x0610], %r3
	.word 0xf6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r27
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	.word 0xdcc4211c  ! 1: LDSWA_I	ldswa	[%r16, + 0x011c] %asi, %r14
	brnz %r31,thr3_loop_cnt_625
	dec %r31
        mov 0x7, %r31
thr3_loop_cnt_626:
	.word 0xc60c254a  ! 1: LDUB_I	ldub	[%r16 + 0x054a], %r3
	.word 0xc65c2600  ! 1: LDX_I	ldx	[%r16 + 0x0600], %r3
	.word 0xc64c2845  ! 1: LDSB_I	ldsb	[%r16 + 0x0845], %r3
	.word 0xc6d428aa  ! 1: LDSHA_I	ldsha	[%r16, + 0x08aa] %asi, %r3
	.word 0xf0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r24
	.word 0xc64c2bd3  ! 1: LDSB_I	ldsb	[%r16 + 0x0bd3], %r3
	.word 0xec5c2f78  ! 1: LDX_I	ldx	[%r16 + 0x0f78], %r22
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd6dc26b0  ! 1: LDXA_I	ldxa	[%r16, + 0x06b0] %asi, %r11
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xfac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r29
	brnz %r31,thr3_loop_cnt_626
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0xbc0c0002  ! 1: AND_R	and 	%r16, %r2, %r30
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0x6e, %r31
thr3_loop_cnt_627:
	.word 0xe4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r18
	.word 0xf28428f4  ! 1: LDUWA_I	lduwa	[%r16, + 0x08f4] %asi, %r25
	.word 0xce5c24f8  ! 1: LDX_I	ldx	[%r16 + 0x04f8], %r7
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	.word 0xdacc259f  ! 1: LDSBA_I	ldsba	[%r16, + 0x059f] %asi, %r13
	.word 0xd84c21f5  ! 1: LDSB_I	ldsb	[%r16 + 0x01f5], %r12
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xde14299e  ! 1: LDUH_I	lduh	[%r16 + 0x099e], %r15
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xd8142d4e  ! 1: LDUH_I	lduh	[%r16 + 0x0d4e], %r12
	brnz %r31,thr3_loop_cnt_627
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x86342345  ! 1: SUBC_I	orn 	%r16, 0x0345, %r3
        mov 0x87, %r31
thr3_loop_cnt_628:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xfc842c78  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c78] %asi, %r30
	.word 0xc6942ef4  ! 1: LDUHA_I	lduha	[%r16, + 0x0ef4] %asi, %r3
	.word 0xd84c2627  ! 1: LDSB_I	ldsb	[%r16 + 0x0627], %r12
	.word 0xf00c252c  ! 1: LDUB_I	ldub	[%r16 + 0x052c], %r24
	.word 0xc6cc22b9  ! 1: LDSBA_I	ldsba	[%r16, + 0x02b9] %asi, %r3
	.word 0xc64422f8  ! 1: LDSW_I	ldsw	[%r16 + 0x02f8], %r3
	.word 0xc68c2477  ! 1: LDUBA_I	lduba	[%r16, + 0x0477] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_628
	dec %r31
        mov 0xa, %r31
thr3_loop_cnt_629:
	.word 0xc6142bc0  ! 1: LDUH_I	lduh	[%r16 + 0x0bc0], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xcc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r6
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xfadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r29
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	brnz %r31,thr3_loop_cnt_629
	dec %r31
	.word 0x860c2033  ! 1: AND_I	and 	%r16, 0x0033, %r3
	.word 0x942c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r10
	.word 0x983c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r12
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x96, %r31
thr3_loop_cnt_630:
	.word 0xc61420b2  ! 1: LDUH_I	lduh	[%r16 + 0x00b2], %r3
	.word 0xde8421f0  ! 1: LDUWA_I	lduwa	[%r16, + 0x01f0] %asi, %r15
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r11
	.word 0xc6dc28f8  ! 1: LDXA_I	ldxa	[%r16, + 0x08f8] %asi, %r3
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	.word 0xc6842e48  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e48] %asi, %r3
	.word 0xc60c2c4a  ! 1: LDUB_I	ldub	[%r16 + 0x0c4a], %r3
	brnz %r31,thr3_loop_cnt_630
	dec %r31
	.word 0x922c2add  ! 1: ANDN_I	andn 	%r16, 0x0add, %r9
	.word 0x860c2d25  ! 1: AND_I	and 	%r16, 0x0d25, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0x1a, %r31
thr3_loop_cnt_631:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc60c294f  ! 1: LDUB_I	ldub	[%r16 + 0x094f], %r3
	.word 0xd8cc2b17  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b17] %asi, %r12
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc68c2620  ! 1: LDUBA_I	lduba	[%r16, + 0x0620] %asi, %r3
	.word 0xd8142be2  ! 1: LDUH_I	lduh	[%r16 + 0x0be2], %r12
	.word 0xc65c2f58  ! 1: LDX_I	ldx	[%r16 + 0x0f58], %r3
	.word 0xf0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r24
	.word 0xd0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r8
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_631
	dec %r31
	.word 0xa53c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r18
	.word 0xa4040002  ! 1: ADD_R	add 	%r16, %r2, %r18
        mov 0xc7, %r31
thr3_loop_cnt_632:
	.word 0xda142954  ! 1: LDUH_I	lduh	[%r16 + 0x0954], %r13
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd88c298e  ! 1: LDUBA_I	lduba	[%r16, + 0x098e] %asi, %r12
	.word 0xf0442ea8  ! 1: LDSW_I	ldsw	[%r16 + 0x0ea8], %r24
	.word 0xdcd42e78  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e78] %asi, %r14
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe6442bc0  ! 1: LDSW_I	ldsw	[%r16 + 0x0bc0], %r19
	brnz %r31,thr3_loop_cnt_632
	dec %r31
	.word 0x86442ebf  ! 1: ADDC_I	addc 	%r16, 0x0ebf, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0x82, %r31
thr3_loop_cnt_633:
	.word 0xc6d42be8  ! 1: LDSHA_I	ldsha	[%r16, + 0x0be8] %asi, %r3
	.word 0xc6142dfa  ! 1: LDUH_I	lduh	[%r16 + 0x0dfa], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xfc5c2ef8  ! 1: LDX_I	ldx	[%r16 + 0x0ef8], %r30
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf0c427e8  ! 1: LDSWA_I	ldswa	[%r16, + 0x07e8] %asi, %r24
	.word 0xc6142d72  ! 1: LDUH_I	lduh	[%r16 + 0x0d72], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_633
	dec %r31
        mov 0x18, %r31
thr3_loop_cnt_634:
	.word 0xeac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r21
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xee042abc  ! 1: LDUW_I	lduw	[%r16 + 0x0abc], %r23
	.word 0xe8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r20
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r25
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	.word 0xce040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r7
	.word 0xf4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r26
	.word 0xc65424fa  ! 1: LDSH_I	ldsh	[%r16 + 0x04fa], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_634
	dec %r31
	.word 0xa7340002  ! 1: SRL_R	srl 	%r16, %r2, %r19
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x12, %r31
thr3_loop_cnt_635:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6cc2605  ! 1: LDSBA_I	ldsba	[%r16, + 0x0605] %asi, %r3
	.word 0xc68c2b28  ! 1: LDUBA_I	lduba	[%r16, + 0x0b28] %asi, %r3
	.word 0xf6d42ac0  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ac0] %asi, %r27
	.word 0xc6842bac  ! 1: LDUWA_I	lduwa	[%r16, + 0x0bac] %asi, %r3
	.word 0xe4842cac  ! 1: LDUWA_I	lduwa	[%r16, + 0x0cac] %asi, %r18
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xdc0c2bb0  ! 1: LDUB_I	ldub	[%r16 + 0x0bb0], %r14
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_635
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x86442188  ! 1: ADDC_I	addc 	%r16, 0x0188, %r3
	.word 0xae0c0002  ! 1: AND_R	and 	%r16, %r2, %r23
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0xbf, %r31
thr3_loop_cnt_636:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r25
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6942b50  ! 1: LDUHA_I	lduha	[%r16, + 0x0b50] %asi, %r3
	.word 0xcccc2d4a  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d4a] %asi, %r6
	.word 0xdc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r14
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_636
	dec %r31
        mov 0x2b, %r31
thr3_loop_cnt_637:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xc6cc2efd  ! 1: LDSBA_I	ldsba	[%r16, + 0x0efd] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf2c42d18  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d18] %asi, %r25
	.word 0xdc1426fc  ! 1: LDUH_I	lduh	[%r16 + 0x06fc], %r14
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf88c2068  ! 1: LDUBA_I	lduba	[%r16, + 0x0068] %asi, %r28
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_637
	dec %r31
        mov 0x72, %r31
thr3_loop_cnt_638:
	.word 0xc68c2b27  ! 1: LDUBA_I	lduba	[%r16, + 0x0b27] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xcc4c2670  ! 1: LDSB_I	ldsb	[%r16 + 0x0670], %r6
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc60c2c23  ! 1: LDUB_I	ldub	[%r16 + 0x0c23], %r3
	.word 0xecd4294e  ! 1: LDSHA_I	ldsha	[%r16, + 0x094e] %asi, %r22
	.word 0xc68c2977  ! 1: LDUBA_I	lduba	[%r16, + 0x0977] %asi, %r3
	brnz %r31,thr3_loop_cnt_638
	dec %r31
        mov 0x6f, %r31
thr3_loop_cnt_639:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6442418  ! 1: LDSW_I	ldsw	[%r16 + 0x0418], %r3
	.word 0xf6042d40  ! 1: LDUW_I	lduw	[%r16 + 0x0d40], %r27
	.word 0xce9425a0  ! 1: LDUHA_I	lduha	[%r16, + 0x05a0] %asi, %r7
	.word 0xe4c422e4  ! 1: LDSWA_I	ldswa	[%r16, + 0x02e4] %asi, %r18
	.word 0xe20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r17
	.word 0xc6442c44  ! 1: LDSW_I	ldsw	[%r16 + 0x0c44], %r3
	.word 0xc60c2cc6  ! 1: LDUB_I	ldub	[%r16 + 0x0cc6], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf44c200f  ! 1: LDSB_I	ldsb	[%r16 + 0x000f], %r26
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_639
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0x19, %r31
thr3_loop_cnt_640:
	.word 0xc6c42b54  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b54] %asi, %r3
	.word 0xc68c244f  ! 1: LDUBA_I	lduba	[%r16, + 0x044f] %asi, %r3
	.word 0xe8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r20
	.word 0xd48c2e56  ! 1: LDUBA_I	lduba	[%r16, + 0x0e56] %asi, %r10
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	.word 0xda4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r13
	.word 0xfcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r30
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_640
	dec %r31
        mov 0x61, %r31
thr3_loop_cnt_641:
	.word 0xf4c42320  ! 1: LDSWA_I	ldswa	[%r16, + 0x0320] %asi, %r26
	.word 0xde040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r15
	.word 0xc6d42b1a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b1a] %asi, %r3
	.word 0xd44421d4  ! 1: LDSW_I	ldsw	[%r16 + 0x01d4], %r10
	.word 0xc6542bd6  ! 1: LDSH_I	ldsh	[%r16 + 0x0bd6], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xce042358  ! 1: LDUW_I	lduw	[%r16 + 0x0358], %r7
	.word 0xec941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r22
	.word 0xf2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r25
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_641
	dec %r31
	.word 0xab2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r21
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0xa6440002  ! 1: ADDC_R	addc 	%r16, %r2, %r19
        mov 0x58, %r31
thr3_loop_cnt_642:
	.word 0xc6d4252a  ! 1: LDSHA_I	ldsha	[%r16, + 0x052a] %asi, %r3
	.word 0xc68c2861  ! 1: LDUBA_I	lduba	[%r16, + 0x0861] %asi, %r3
	.word 0xc6d42f42  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f42] %asi, %r3
	.word 0xfa140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r29
	.word 0xf48c2df6  ! 1: LDUBA_I	lduba	[%r16, + 0x0df6] %asi, %r26
	.word 0xc60c2be3  ! 1: LDUB_I	ldub	[%r16 + 0x0be3], %r3
	.word 0xe4c42944  ! 1: LDSWA_I	ldswa	[%r16, + 0x0944] %asi, %r18
	.word 0xc6c4201c  ! 1: LDSWA_I	ldswa	[%r16, + 0x001c] %asi, %r3
	.word 0xe4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r18
	brnz %r31,thr3_loop_cnt_642
	dec %r31
	.word 0x98342a7e  ! 1: SUBC_I	orn 	%r16, 0x0a7e, %r12
	.word 0x8c2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r6
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0x2f, %r31
thr3_loop_cnt_643:
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	.word 0xc6842a8c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a8c] %asi, %r3
	.word 0xe64c2d85  ! 1: LDSB_I	ldsb	[%r16 + 0x0d85], %r19
	.word 0xc6c423e0  ! 1: LDSWA_I	ldswa	[%r16, + 0x03e0] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xfa5c2d30  ! 1: LDX_I	ldx	[%r16 + 0x0d30], %r29
	.word 0xc6842700  ! 1: LDUWA_I	lduwa	[%r16, + 0x0700] %asi, %r3
	.word 0xc68429c0  ! 1: LDUWA_I	lduwa	[%r16, + 0x09c0] %asi, %r3
	.word 0xde540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r15
	.word 0xc64c20ee  ! 1: LDSB_I	ldsb	[%r16 + 0x00ee], %r3
	brnz %r31,thr3_loop_cnt_643
	dec %r31
	.word 0xae342f59  ! 1: SUBC_I	orn 	%r16, 0x0f59, %r23
	.word 0x86142286  ! 1: OR_I	or 	%r16, 0x0286, %r3
	.word 0x952c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r10
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0xa4, %r31
thr3_loop_cnt_644:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xce442cb8  ! 1: LDSW_I	ldsw	[%r16 + 0x0cb8], %r7
	.word 0xe88426fc  ! 1: LDUWA_I	lduwa	[%r16, + 0x06fc] %asi, %r20
	.word 0xdc44210c  ! 1: LDSW_I	ldsw	[%r16 + 0x010c], %r14
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xc6042a24  ! 1: LDUW_I	lduw	[%r16 + 0x0a24], %r3
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2e08  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e08] %asi, %r3
	.word 0xc68c28d8  ! 1: LDUBA_I	lduba	[%r16, + 0x08d8] %asi, %r3
	.word 0xc6942ad6  ! 1: LDUHA_I	lduha	[%r16, + 0x0ad6] %asi, %r3
	brnz %r31,thr3_loop_cnt_644
	dec %r31
	.word 0x863c2553  ! 1: XNOR_I	xnor 	%r16, 0x0553, %r3
	.word 0x9b342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r13
	.word 0x864423ed  ! 1: ADDC_I	addc 	%r16, 0x03ed, %r3
        mov 0x6e, %r31
thr3_loop_cnt_645:
	.word 0xf2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r25
	.word 0xfc042560  ! 1: LDUW_I	lduw	[%r16 + 0x0560], %r30
	.word 0xea140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r21
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6042100  ! 1: LDUW_I	lduw	[%r16 + 0x0100], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	brnz %r31,thr3_loop_cnt_645
	dec %r31
	.word 0xb22c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r25
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x28, %r31
thr3_loop_cnt_646:
	.word 0xfad4277a  ! 1: LDSHA_I	ldsha	[%r16, + 0x077a] %asi, %r29
	.word 0xdccc225c  ! 1: LDSBA_I	ldsba	[%r16, + 0x025c] %asi, %r14
	.word 0xda0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r13
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6142956  ! 1: LDUH_I	lduh	[%r16 + 0x0956], %r3
	.word 0xccc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r6
	.word 0xc6d4213a  ! 1: LDSHA_I	ldsha	[%r16, + 0x013a] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xee140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r23
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xcc4c2c7f  ! 1: LDSB_I	ldsb	[%r16 + 0x0c7f], %r6
	.word 0xdec422e0  ! 1: LDSWA_I	ldswa	[%r16, + 0x02e0] %asi, %r15
	brnz %r31,thr3_loop_cnt_646
	dec %r31
	.word 0x9d2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r14
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0xab2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r21
        mov 0xbf, %r31
thr3_loop_cnt_647:
	.word 0xce8c2cbe  ! 1: LDUBA_I	lduba	[%r16, + 0x0cbe] %asi, %r7
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r24
	.word 0xde54202c  ! 1: LDSH_I	ldsh	[%r16 + 0x002c], %r15
	.word 0xc68c29f3  ! 1: LDUBA_I	lduba	[%r16, + 0x09f3] %asi, %r3
	.word 0xf0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r24
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_647
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x861c2224  ! 1: XOR_I	xor 	%r16, 0x0224, %r3
        mov 0x90, %r31
thr3_loop_cnt_648:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d42456  ! 1: LDSHA_I	ldsha	[%r16, + 0x0456] %asi, %r3
	.word 0xee842848  ! 1: LDUWA_I	lduwa	[%r16, + 0x0848] %asi, %r23
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xe28c2ff5  ! 1: LDUBA_I	lduba	[%r16, + 0x0ff5] %asi, %r17
	.word 0xc6542e60  ! 1: LDSH_I	ldsh	[%r16 + 0x0e60], %r3
	.word 0xf41427de  ! 1: LDUH_I	lduh	[%r16 + 0x07de], %r26
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_648
	dec %r31
        mov 0x68, %r31
thr3_loop_cnt_649:
	.word 0xee8426c0  ! 1: LDUWA_I	lduwa	[%r16, + 0x06c0] %asi, %r23
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc69424f0  ! 1: LDUHA_I	lduha	[%r16, + 0x04f0] %asi, %r3
	.word 0xf2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r25
	.word 0xe2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r17
	.word 0xf4dc2658  ! 1: LDXA_I	ldxa	[%r16, + 0x0658] %asi, %r26
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xdc8c2394  ! 1: LDUBA_I	lduba	[%r16, + 0x0394] %asi, %r14
	brnz %r31,thr3_loop_cnt_649
	dec %r31
        mov 0x5e, %r31
thr3_loop_cnt_650:
	.word 0xc65c2da0  ! 1: LDX_I	ldx	[%r16 + 0x0da0], %r3
	.word 0xce8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r7
	.word 0xc6842878  ! 1: LDUWA_I	lduwa	[%r16, + 0x0878] %asi, %r3
	.word 0xc6542f32  ! 1: LDSH_I	ldsh	[%r16 + 0x0f32], %r3
	.word 0xf6cc2fa5  ! 1: LDSBA_I	ldsba	[%r16, + 0x0fa5] %asi, %r27
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xe6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r19
	.word 0xc6442198  ! 1: LDSW_I	ldsw	[%r16 + 0x0198], %r3
	.word 0xc65c2fe8  ! 1: LDX_I	ldx	[%r16 + 0x0fe8], %r3
	.word 0xfa5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r29
	brnz %r31,thr3_loop_cnt_650
	dec %r31
        mov 0xb5, %r31
thr3_loop_cnt_651:
	.word 0xe8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r20
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	.word 0xe65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r19
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xec540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r22
	.word 0xc6d42bbe  ! 1: LDSHA_I	ldsha	[%r16, + 0x0bbe] %asi, %r3
	.word 0xc65422c8  ! 1: LDSH_I	ldsh	[%r16 + 0x02c8], %r3
	.word 0xea842020  ! 1: LDUWA_I	lduwa	[%r16, + 0x0020] %asi, %r21
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xe4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r18
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_651
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0xa3, %r31
thr3_loop_cnt_652:
	.word 0xc60c29eb  ! 1: LDUB_I	ldub	[%r16 + 0x09eb], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xcc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r6
	.word 0xcc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r6
	.word 0xfcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r30
	.word 0xc64c266f  ! 1: LDSB_I	ldsb	[%r16 + 0x066f], %r3
	.word 0xc6142daa  ! 1: LDUH_I	lduh	[%r16 + 0x0daa], %r3
	.word 0xe4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r18
	.word 0xf08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r24
	.word 0xd2dc22b8  ! 1: LDXA_I	ldxa	[%r16, + 0x02b8] %asi, %r9
	.word 0xfad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r29
	brnz %r31,thr3_loop_cnt_652
	dec %r31
	.word 0x8624268d  ! 1: SUB_I	sub 	%r16, 0x068d, %r3
        mov 0x86, %r31
thr3_loop_cnt_653:
	.word 0xf6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r27
	.word 0xd05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r8
	.word 0xfacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r29
	.word 0xce941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r7
	.word 0xc6dc28e8  ! 1: LDXA_I	ldxa	[%r16, + 0x08e8] %asi, %r3
	.word 0xec4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r22
	.word 0xc61422e6  ! 1: LDUH_I	lduh	[%r16 + 0x02e6], %r3
	.word 0xc68426e0  ! 1: LDUWA_I	lduwa	[%r16, + 0x06e0] %asi, %r3
	.word 0xc68c2e37  ! 1: LDUBA_I	lduba	[%r16, + 0x0e37] %asi, %r3
	.word 0xfc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r30
	.word 0xc65c2f00  ! 1: LDX_I	ldx	[%r16 + 0x0f00], %r3
	.word 0xcec42c7c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c7c] %asi, %r7
	brnz %r31,thr3_loop_cnt_653
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x92340002  ! 1: SUBC_R	orn 	%r16, %r2, %r9
	.word 0xbc3c2573  ! 1: XNOR_I	xnor 	%r16, 0x0573, %r30
        mov 0x75, %r31
thr3_loop_cnt_654:
	.word 0xc65c2090  ! 1: LDX_I	ldx	[%r16 + 0x0090], %r3
	.word 0xea142be0  ! 1: LDUH_I	lduh	[%r16 + 0x0be0], %r21
	.word 0xc6442498  ! 1: LDSW_I	ldsw	[%r16 + 0x0498], %r3
	.word 0xc6042d54  ! 1: LDUW_I	lduw	[%r16 + 0x0d54], %r3
	.word 0xee4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r23
	.word 0xee0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r23
	.word 0xccc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r6
	.word 0xe6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r19
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xfa040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r29
	.word 0xcc94204e  ! 1: LDUHA_I	lduha	[%r16, + 0x004e] %asi, %r6
	.word 0xc6842f20  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f20] %asi, %r3
	brnz %r31,thr3_loop_cnt_654
	dec %r31
        mov 0x42, %r31
thr3_loop_cnt_655:
	.word 0xee5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r23
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe60421fc  ! 1: LDUW_I	lduw	[%r16 + 0x01fc], %r19
	.word 0xe4dc2ee8  ! 1: LDXA_I	ldxa	[%r16, + 0x0ee8] %asi, %r18
	.word 0xf45c2158  ! 1: LDX_I	ldx	[%r16 + 0x0158], %r26
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c425a4  ! 1: LDSWA_I	ldswa	[%r16, + 0x05a4] %asi, %r3
	.word 0xc64c2638  ! 1: LDSB_I	ldsb	[%r16 + 0x0638], %r3
	.word 0xda4c26e3  ! 1: LDSB_I	ldsb	[%r16 + 0x06e3], %r13
	brnz %r31,thr3_loop_cnt_655
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x8d2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r6
	.word 0xa6040002  ! 1: ADD_R	add 	%r16, %r2, %r19
        mov 0x1d, %r31
thr3_loop_cnt_656:
	.word 0xd0042184  ! 1: LDUW_I	lduw	[%r16 + 0x0184], %r8
	.word 0xc604223c  ! 1: LDUW_I	lduw	[%r16 + 0x023c], %r3
	.word 0xee040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r23
	.word 0xea0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r21
	.word 0xf6042530  ! 1: LDUW_I	lduw	[%r16 + 0x0530], %r27
	.word 0xce440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r7
	.word 0xee8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r23
	.word 0xc614208a  ! 1: LDUH_I	lduh	[%r16 + 0x008a], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc69421a4  ! 1: LDUHA_I	lduha	[%r16, + 0x01a4] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xfadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r29
	brnz %r31,thr3_loop_cnt_656
	dec %r31
	.word 0xb42422fb  ! 1: SUB_I	sub 	%r16, 0x02fb, %r26
	.word 0xa7340002  ! 1: SRL_R	srl 	%r16, %r2, %r19
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x22, %r31
thr3_loop_cnt_657:
	.word 0xc6442320  ! 1: LDSW_I	ldsw	[%r16 + 0x0320], %r3
	.word 0xc6042300  ! 1: LDUW_I	lduw	[%r16 + 0x0300], %r3
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xd684298c  ! 1: LDUWA_I	lduwa	[%r16, + 0x098c] %asi, %r11
	.word 0xee542d48  ! 1: LDSH_I	ldsh	[%r16 + 0x0d48], %r23
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6142dee  ! 1: LDUH_I	lduh	[%r16 + 0x0dee], %r3
	.word 0xc64428a0  ! 1: LDSW_I	ldsw	[%r16 + 0x08a0], %r3
	.word 0xe85c2588  ! 1: LDX_I	ldx	[%r16 + 0x0588], %r20
	brnz %r31,thr3_loop_cnt_657
	dec %r31
        mov 0x69, %r31
thr3_loop_cnt_658:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xda540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r13
	.word 0xe8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r20
	.word 0xc6942376  ! 1: LDUHA_I	lduha	[%r16, + 0x0376] %asi, %r3
	.word 0xfc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r30
	.word 0xf0542476  ! 1: LDSH_I	ldsh	[%r16 + 0x0476], %r24
	.word 0xc6142c50  ! 1: LDUH_I	lduh	[%r16 + 0x0c50], %r3
	.word 0xce4c2ff5  ! 1: LDSB_I	ldsb	[%r16 + 0x0ff5], %r7
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xde040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r15
	.word 0xc644268c  ! 1: LDSW_I	ldsw	[%r16 + 0x068c], %r3
	.word 0xd84c2b75  ! 1: LDSB_I	ldsb	[%r16 + 0x0b75], %r12
	brnz %r31,thr3_loop_cnt_658
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x9d2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r14
	.word 0xb32c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r25
        mov 0x60, %r31
thr3_loop_cnt_659:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc65c2358  ! 1: LDX_I	ldx	[%r16 + 0x0358], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc60423c4  ! 1: LDUW_I	lduw	[%r16 + 0x03c4], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xfa941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r29
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	.word 0xc64c28e8  ! 1: LDSB_I	ldsb	[%r16 + 0x08e8], %r3
	.word 0xf6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r27
	.word 0xc6c42530  ! 1: LDSWA_I	ldswa	[%r16, + 0x0530] %asi, %r3
	.word 0xe40c26b9  ! 1: LDUB_I	ldub	[%r16 + 0x06b9], %r18
	brnz %r31,thr3_loop_cnt_659
	dec %r31
	.word 0x99340002  ! 1: SRL_R	srl 	%r16, %r2, %r12
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0xae, %r31
thr3_loop_cnt_660:
	.word 0xf40c2e19  ! 1: LDUB_I	ldub	[%r16 + 0x0e19], %r26
	.word 0xe4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r18
	.word 0xc65c2560  ! 1: LDX_I	ldx	[%r16 + 0x0560], %r3
	.word 0xc6842038  ! 1: LDUWA_I	lduwa	[%r16, + 0x0038] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd8142e48  ! 1: LDUH_I	lduh	[%r16 + 0x0e48], %r12
	.word 0xea4c25f3  ! 1: LDSB_I	ldsb	[%r16 + 0x05f3], %r21
	.word 0xde540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r15
	brnz %r31,thr3_loop_cnt_660
	dec %r31
	.word 0x941426ad  ! 1: OR_I	or 	%r16, 0x06ad, %r10
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0xb32c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r25
        mov 0x93, %r31
thr3_loop_cnt_661:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xee040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r23
	.word 0xc604218c  ! 1: LDUW_I	lduw	[%r16 + 0x018c], %r3
	.word 0xe4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r18
	.word 0xf0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r24
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc65c29d0  ! 1: LDX_I	ldx	[%r16 + 0x09d0], %r3
	.word 0xee0c2def  ! 1: LDUB_I	ldub	[%r16 + 0x0def], %r23
	.word 0xc64c2ea1  ! 1: LDSB_I	ldsb	[%r16 + 0x0ea1], %r3
	brnz %r31,thr3_loop_cnt_661
	dec %r31
	.word 0xa4040002  ! 1: ADD_R	add 	%r16, %r2, %r18
        mov 0xb0, %r31
thr3_loop_cnt_662:
	.word 0xda4c2560  ! 1: LDSB_I	ldsb	[%r16 + 0x0560], %r13
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf6d4288c  ! 1: LDSHA_I	ldsha	[%r16, + 0x088c] %asi, %r27
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xeacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r21
	.word 0xfa54209e  ! 1: LDSH_I	ldsh	[%r16 + 0x009e], %r29
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r12
	.word 0xc60c21c2  ! 1: LDUB_I	ldub	[%r16 + 0x01c2], %r3
	.word 0xde1425d6  ! 1: LDUH_I	lduh	[%r16 + 0x05d6], %r15
	brnz %r31,thr3_loop_cnt_662
	dec %r31
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x8c340002  ! 1: SUBC_R	orn 	%r16, %r2, %r6
	.word 0xa92c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r20
	.word 0xa21c21b3  ! 1: XOR_I	xor 	%r16, 0x01b3, %r17
        mov 0x3d, %r31
thr3_loop_cnt_663:
	.word 0xea5428a0  ! 1: LDSH_I	ldsh	[%r16 + 0x08a0], %r21
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	.word 0xda540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r13
	.word 0xccc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r6
	.word 0xc64c2610  ! 1: LDSB_I	ldsb	[%r16 + 0x0610], %r3
	.word 0xd8442038  ! 1: LDSW_I	ldsw	[%r16 + 0x0038], %r12
	.word 0xe2c428dc  ! 1: LDSWA_I	ldswa	[%r16, + 0x08dc] %asi, %r17
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	.word 0xd644223c  ! 1: LDSW_I	ldsw	[%r16 + 0x023c], %r11
	.word 0xe80c2c92  ! 1: LDUB_I	ldub	[%r16 + 0x0c92], %r20
	.word 0xec5427de  ! 1: LDSH_I	ldsh	[%r16 + 0x07de], %r22
	brnz %r31,thr3_loop_cnt_663
	dec %r31
        mov 0x39, %r31
thr3_loop_cnt_664:
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xecdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r22
	.word 0xc61428e4  ! 1: LDUH_I	lduh	[%r16 + 0x08e4], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe804255c  ! 1: LDUW_I	lduw	[%r16 + 0x055c], %r20
	.word 0xfccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r30
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_664
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0xb8142882  ! 1: OR_I	or 	%r16, 0x0882, %r28
        mov 0x30, %r31
thr3_loop_cnt_665:
	.word 0xc64426c4  ! 1: LDSW_I	ldsw	[%r16 + 0x06c4], %r3
	.word 0xda54294e  ! 1: LDSH_I	ldsh	[%r16 + 0x094e], %r13
	.word 0xe6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r19
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd2c42618  ! 1: LDSWA_I	ldswa	[%r16, + 0x0618] %asi, %r9
	.word 0xf684201c  ! 1: LDUWA_I	lduwa	[%r16, + 0x001c] %asi, %r27
	.word 0xd2c42970  ! 1: LDSWA_I	ldswa	[%r16, + 0x0970] %asi, %r9
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xc64c2a5f  ! 1: LDSB_I	ldsb	[%r16 + 0x0a5f], %r3
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xc6d426c4  ! 1: LDSHA_I	ldsha	[%r16, + 0x06c4] %asi, %r3
	brnz %r31,thr3_loop_cnt_665
	dec %r31
        mov 0x1f, %r31
thr3_loop_cnt_666:
	.word 0xc64426f4  ! 1: LDSW_I	ldsw	[%r16 + 0x06f4], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd84c2043  ! 1: LDSB_I	ldsb	[%r16 + 0x0043], %r12
	.word 0xc6c42f64  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f64] %asi, %r3
	.word 0xd4942ade  ! 1: LDUHA_I	lduha	[%r16, + 0x0ade] %asi, %r10
	.word 0xe20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r17
	.word 0xc60426f4  ! 1: LDUW_I	lduw	[%r16 + 0x06f4], %r3
	.word 0xe20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r17
	.word 0xfc842908  ! 1: LDUWA_I	lduwa	[%r16, + 0x0908] %asi, %r30
	.word 0xde1427a6  ! 1: LDUH_I	lduh	[%r16 + 0x07a6], %r15
	.word 0xee8425b8  ! 1: LDUWA_I	lduwa	[%r16, + 0x05b8] %asi, %r23
	brnz %r31,thr3_loop_cnt_666
	dec %r31
	.word 0x8d343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r6
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0x92, %r31
thr3_loop_cnt_667:
	.word 0xe8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r20
	.word 0xc6c42bdc  ! 1: LDSWA_I	ldswa	[%r16, + 0x0bdc] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r28
	.word 0xce0c2b4b  ! 1: LDUB_I	ldub	[%r16 + 0x0b4b], %r7
	.word 0xe64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r19
	.word 0xce8c2946  ! 1: LDUBA_I	lduba	[%r16, + 0x0946] %asi, %r7
	.word 0xdc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r14
	brnz %r31,thr3_loop_cnt_667
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x71, %r31
thr3_loop_cnt_668:
	.word 0xc65429b6  ! 1: LDSH_I	ldsh	[%r16 + 0x09b6], %r3
	.word 0xf80420f0  ! 1: LDUW_I	lduw	[%r16 + 0x00f0], %r28
	.word 0xe20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r17
	.word 0xd80c23ff  ! 1: LDUB_I	ldub	[%r16 + 0x03ff], %r12
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xeadc2360  ! 1: LDXA_I	ldxa	[%r16, + 0x0360] %asi, %r21
	.word 0xe65c2c48  ! 1: LDX_I	ldx	[%r16 + 0x0c48], %r19
	.word 0xdc042438  ! 1: LDUW_I	lduw	[%r16 + 0x0438], %r14
	.word 0xdcc42c30  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c30] %asi, %r14
	.word 0xd45c2180  ! 1: LDX_I	ldx	[%r16 + 0x0180], %r10
	.word 0xd8142902  ! 1: LDUH_I	lduh	[%r16 + 0x0902], %r12
	.word 0xdccc215f  ! 1: LDSBA_I	ldsba	[%r16, + 0x015f] %asi, %r14
	brnz %r31,thr3_loop_cnt_668
	dec %r31
	.word 0x9a3425d5  ! 1: ORN_I	orn 	%r16, 0x05d5, %r13
        mov 0x97, %r31
thr3_loop_cnt_669:
	.word 0xd854280c  ! 1: LDSH_I	ldsh	[%r16 + 0x080c], %r12
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6142e9a  ! 1: LDUH_I	lduh	[%r16 + 0x0e9a], %r3
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xcc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r6
	.word 0xecdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r22
	.word 0xd4142fa4  ! 1: LDUH_I	lduh	[%r16 + 0x0fa4], %r10
	.word 0xc6842ac4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ac4] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6842c74  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c74] %asi, %r3
	brnz %r31,thr3_loop_cnt_669
	dec %r31
        mov 0xa6, %r31
thr3_loop_cnt_670:
	.word 0xf84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r28
	.word 0xde941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r15
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xd2dc29a0  ! 1: LDXA_I	ldxa	[%r16, + 0x09a0] %asi, %r9
	.word 0xfad4239a  ! 1: LDSHA_I	ldsha	[%r16, + 0x039a] %asi, %r29
	.word 0xd8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r12
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc68428e0  ! 1: LDUWA_I	lduwa	[%r16, + 0x08e0] %asi, %r3
	brnz %r31,thr3_loop_cnt_670
	dec %r31
        mov 0x85, %r31
thr3_loop_cnt_671:
	.word 0xec8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r22
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6042ac0  ! 1: LDUW_I	lduw	[%r16 + 0x0ac0], %r3
	.word 0xc65c2ec8  ! 1: LDX_I	ldx	[%r16 + 0x0ec8], %r3
	.word 0xdac42a44  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a44] %asi, %r13
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r26
	.word 0xe85424a4  ! 1: LDSH_I	ldsh	[%r16 + 0x04a4], %r20
	.word 0xf4dc2b18  ! 1: LDXA_I	ldxa	[%r16, + 0x0b18] %asi, %r26
	.word 0xc6442664  ! 1: LDSW_I	ldsw	[%r16 + 0x0664], %r3
	brnz %r31,thr3_loop_cnt_671
	dec %r31
	.word 0x92340002  ! 1: ORN_R	orn 	%r16, %r2, %r9
        mov 0x9b, %r31
thr3_loop_cnt_672:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r10
	.word 0xe25c2208  ! 1: LDX_I	ldx	[%r16 + 0x0208], %r17
	.word 0xda0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r13
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xc6dc22a8  ! 1: LDXA_I	ldxa	[%r16, + 0x02a8] %asi, %r3
	.word 0xea8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r21
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	.word 0xd2442e58  ! 1: LDSW_I	ldsw	[%r16 + 0x0e58], %r9
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	brnz %r31,thr3_loop_cnt_672
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x8e1c0002  ! 1: XOR_R	xor 	%r16, %r2, %r7
        mov 0x65, %r31
thr3_loop_cnt_673:
	.word 0xe2942456  ! 1: LDUHA_I	lduha	[%r16, + 0x0456] %asi, %r17
	.word 0xf24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r25
	.word 0xcc5c2830  ! 1: LDX_I	ldx	[%r16 + 0x0830], %r6
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xc6cc2453  ! 1: LDSBA_I	ldsba	[%r16, + 0x0453] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc61423ac  ! 1: LDUH_I	lduh	[%r16 + 0x03ac], %r3
	.word 0xc6942c62  ! 1: LDUHA_I	lduha	[%r16, + 0x0c62] %asi, %r3
	.word 0xe4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r18
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_673
	dec %r31
	.word 0x860c22fa  ! 1: AND_I	and 	%r16, 0x02fa, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x9b3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r13
        mov 0x11, %r31
thr3_loop_cnt_674:
	.word 0xcc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r6
	.word 0xc6542fb4  ! 1: LDSH_I	ldsh	[%r16 + 0x0fb4], %r3
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xec4c2216  ! 1: LDSB_I	ldsb	[%r16 + 0x0216], %r22
	.word 0xc68c263e  ! 1: LDUBA_I	lduba	[%r16, + 0x063e] %asi, %r3
	.word 0xc64426b0  ! 1: LDSW_I	ldsw	[%r16 + 0x06b0], %r3
	.word 0xfcd420da  ! 1: LDSHA_I	ldsha	[%r16, + 0x00da] %asi, %r30
	.word 0xde042b48  ! 1: LDUW_I	lduw	[%r16 + 0x0b48], %r15
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_674
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x32, %r31
thr3_loop_cnt_675:
	.word 0xc6842940  ! 1: LDUWA_I	lduwa	[%r16, + 0x0940] %asi, %r3
	.word 0xfa5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r29
	.word 0xc6d42312  ! 1: LDSHA_I	ldsha	[%r16, + 0x0312] %asi, %r3
	.word 0xc6d425ae  ! 1: LDSHA_I	ldsha	[%r16, + 0x05ae] %asi, %r3
	.word 0xdacc2039  ! 1: LDSBA_I	ldsba	[%r16, + 0x0039] %asi, %r13
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r18
	.word 0xc6dc2150  ! 1: LDXA_I	ldxa	[%r16, + 0x0150] %asi, %r3
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_675
	dec %r31
        mov 0x18, %r31
thr3_loop_cnt_676:
	.word 0xf4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r26
	.word 0xce0421d8  ! 1: LDUW_I	lduw	[%r16 + 0x01d8], %r7
	.word 0xdedc21d8  ! 1: LDXA_I	ldxa	[%r16, + 0x01d8] %asi, %r15
	.word 0xfcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r30
	.word 0xfcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r30
	.word 0xfacc2ac6  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ac6] %asi, %r29
	.word 0xc6d42222  ! 1: LDSHA_I	ldsha	[%r16, + 0x0222] %asi, %r3
	.word 0xe4142f2e  ! 1: LDUH_I	lduh	[%r16 + 0x0f2e], %r18
	.word 0xf04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r24
	.word 0xcc442030  ! 1: LDSW_I	ldsw	[%r16 + 0x0030], %r6
	brnz %r31,thr3_loop_cnt_676
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x1e, %r31
thr3_loop_cnt_677:
	.word 0xc694290a  ! 1: LDUHA_I	lduha	[%r16, + 0x090a] %asi, %r3
	.word 0xc6cc2225  ! 1: LDSBA_I	ldsba	[%r16, + 0x0225] %asi, %r3
	.word 0xdecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r15
	.word 0xc6dc2950  ! 1: LDXA_I	ldxa	[%r16, + 0x0950] %asi, %r3
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xd2dc24b8  ! 1: LDXA_I	ldxa	[%r16, + 0x04b8] %asi, %r9
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	brnz %r31,thr3_loop_cnt_677
	dec %r31
        mov 0x5b, %r31
thr3_loop_cnt_678:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xeadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r21
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xc6042234  ! 1: LDUW_I	lduw	[%r16 + 0x0234], %r3
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	.word 0xdacc29c4  ! 1: LDSBA_I	ldsba	[%r16, + 0x09c4] %asi, %r13
	.word 0xe8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r20
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	.word 0xc6042838  ! 1: LDUW_I	lduw	[%r16 + 0x0838], %r3
	brnz %r31,thr3_loop_cnt_678
	dec %r31
        mov 0x52, %r31
thr3_loop_cnt_679:
	.word 0xd45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r10
	.word 0xeedc2ff0  ! 1: LDXA_I	ldxa	[%r16, + 0x0ff0] %asi, %r23
	.word 0xc6c42b38  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b38] %asi, %r3
	.word 0xc684285c  ! 1: LDUWA_I	lduwa	[%r16, + 0x085c] %asi, %r3
	.word 0xe6042294  ! 1: LDUW_I	lduw	[%r16 + 0x0294], %r19
	.word 0xc68c25a4  ! 1: LDUBA_I	lduba	[%r16, + 0x05a4] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6442090  ! 1: LDSW_I	ldsw	[%r16 + 0x0090], %r3
	.word 0xe4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r18
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_679
	dec %r31
	.word 0x921c0002  ! 1: XOR_R	xor 	%r16, %r2, %r9
	.word 0x93343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r9
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x923c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r9
        mov 0x5b, %r31
thr3_loop_cnt_680:
	.word 0xd054214a  ! 1: LDSH_I	ldsh	[%r16 + 0x014a], %r8
	.word 0xda8c2d86  ! 1: LDUBA_I	lduba	[%r16, + 0x0d86] %asi, %r13
	.word 0xda140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r13
	.word 0xeedc29e0  ! 1: LDXA_I	ldxa	[%r16, + 0x09e0] %asi, %r23
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc65c2728  ! 1: LDX_I	ldx	[%r16 + 0x0728], %r3
	.word 0xc60c23e3  ! 1: LDUB_I	ldub	[%r16 + 0x03e3], %r3
	.word 0xd60c2670  ! 1: LDUB_I	ldub	[%r16 + 0x0670], %r11
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_680
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0xb13c1002  ! 1: SRAX_R	srax	%r16, %r2, %r24
        mov 0x8a, %r31
thr3_loop_cnt_681:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc68c2200  ! 1: LDUBA_I	lduba	[%r16, + 0x0200] %asi, %r3
	.word 0xc6cc29d6  ! 1: LDSBA_I	ldsba	[%r16, + 0x09d6] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd2442788  ! 1: LDSW_I	ldsw	[%r16 + 0x0788], %r9
	.word 0xc68425bc  ! 1: LDUWA_I	lduwa	[%r16, + 0x05bc] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r26
	.word 0xc6c42454  ! 1: LDSWA_I	ldswa	[%r16, + 0x0454] %asi, %r3
	.word 0xc6142e42  ! 1: LDUH_I	lduh	[%r16 + 0x0e42], %r3
	brnz %r31,thr3_loop_cnt_681
	dec %r31
	.word 0x862c2f62  ! 1: ANDN_I	andn 	%r16, 0x0f62, %r3
        mov 0x81, %r31
thr3_loop_cnt_682:
	.word 0xd4442a94  ! 1: LDSW_I	ldsw	[%r16 + 0x0a94], %r10
	.word 0xeccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r22
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xeac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r21
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	.word 0xe48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r18
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6442750  ! 1: LDSW_I	ldsw	[%r16 + 0x0750], %r3
	brnz %r31,thr3_loop_cnt_682
	dec %r31
	.word 0xa9343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r20
        mov 0x89, %r31
thr3_loop_cnt_683:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6442728  ! 1: LDSW_I	ldsw	[%r16 + 0x0728], %r3
	.word 0xc60c2d83  ! 1: LDUB_I	ldub	[%r16 + 0x0d83], %r3
	.word 0xc64c298e  ! 1: LDSB_I	ldsb	[%r16 + 0x098e], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xdc142880  ! 1: LDUH_I	lduh	[%r16 + 0x0880], %r14
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc60c2a63  ! 1: LDUB_I	ldub	[%r16 + 0x0a63], %r3
	.word 0xc6c423d8  ! 1: LDSWA_I	ldswa	[%r16, + 0x03d8] %asi, %r3
	.word 0xc6042ed8  ! 1: LDUW_I	lduw	[%r16 + 0x0ed8], %r3
	.word 0xc6dc2658  ! 1: LDXA_I	ldxa	[%r16, + 0x0658] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_683
	dec %r31
        mov 0x44, %r31
thr3_loop_cnt_684:
	.word 0xc6042a3c  ! 1: LDUW_I	lduw	[%r16 + 0x0a3c], %r3
	.word 0xfc4420cc  ! 1: LDSW_I	ldsw	[%r16 + 0x00cc], %r30
	.word 0xd884251c  ! 1: LDUWA_I	lduwa	[%r16, + 0x051c] %asi, %r12
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r26
	.word 0xea8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r21
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_684
	dec %r31
	.word 0x9d3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r14
	.word 0x9e3c26e6  ! 1: XNOR_I	xnor 	%r16, 0x06e6, %r15
        mov 0x6f, %r31
thr3_loop_cnt_685:
	.word 0xec140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r22
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc65c2838  ! 1: LDX_I	ldx	[%r16 + 0x0838], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc60c206d  ! 1: LDUB_I	ldub	[%r16 + 0x006d], %r3
	.word 0xdecc2073  ! 1: LDSBA_I	ldsba	[%r16, + 0x0073] %asi, %r15
	.word 0xf44424a8  ! 1: LDSW_I	ldsw	[%r16 + 0x04a8], %r26
	brnz %r31,thr3_loop_cnt_685
	dec %r31
	.word 0x86342593  ! 1: ORN_I	orn 	%r16, 0x0593, %r3
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0x95, %r31
thr3_loop_cnt_686:
	.word 0xf6cc2efe  ! 1: LDSBA_I	ldsba	[%r16, + 0x0efe] %asi, %r27
	.word 0xda0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r13
	.word 0xe4d42e86  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e86] %asi, %r18
	.word 0xf64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r27
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xccdc2d88  ! 1: LDXA_I	ldxa	[%r16, + 0x0d88] %asi, %r6
	.word 0xc6542f70  ! 1: LDSH_I	ldsh	[%r16 + 0x0f70], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xfa8c269e  ! 1: LDUBA_I	lduba	[%r16, + 0x069e] %asi, %r29
	.word 0xf40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r26
	.word 0xc64c2a26  ! 1: LDSB_I	ldsb	[%r16 + 0x0a26], %r3
	brnz %r31,thr3_loop_cnt_686
	dec %r31
        mov 0x75, %r31
thr3_loop_cnt_687:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r25
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xdcd42f14  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f14] %asi, %r14
	.word 0xc68c2925  ! 1: LDUBA_I	lduba	[%r16, + 0x0925] %asi, %r3
	.word 0xe8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r20
	.word 0xc65423cc  ! 1: LDSH_I	ldsh	[%r16 + 0x03cc], %r3
	.word 0xc60c20c8  ! 1: LDUB_I	ldub	[%r16 + 0x00c8], %r3
	.word 0xfc042ef4  ! 1: LDUW_I	lduw	[%r16 + 0x0ef4], %r30
	.word 0xc6042808  ! 1: LDUW_I	lduw	[%r16 + 0x0808], %r3
	brnz %r31,thr3_loop_cnt_687
	dec %r31
	.word 0x862c2fe4  ! 1: ANDN_I	andn 	%r16, 0x0fe4, %r3
        mov 0x7a, %r31
thr3_loop_cnt_688:
	.word 0xccdc27a8  ! 1: LDXA_I	ldxa	[%r16, + 0x07a8] %asi, %r6
	.word 0xd85c2ca0  ! 1: LDX_I	ldx	[%r16 + 0x0ca0], %r12
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xe45c2ea8  ! 1: LDX_I	ldx	[%r16 + 0x0ea8], %r18
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6dc2950  ! 1: LDXA_I	ldxa	[%r16, + 0x0950] %asi, %r3
	.word 0xeac428ac  ! 1: LDSWA_I	ldswa	[%r16, + 0x08ac] %asi, %r21
	.word 0xec440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r22
	.word 0xe6c4267c  ! 1: LDSWA_I	ldswa	[%r16, + 0x067c] %asi, %r19
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_688
	dec %r31
        mov 0x2e, %r31
thr3_loop_cnt_689:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc65c2f00  ! 1: LDX_I	ldx	[%r16 + 0x0f00], %r3
	.word 0xc654288e  ! 1: LDSH_I	ldsh	[%r16 + 0x088e], %r3
	.word 0xc6d42e4a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e4a] %asi, %r3
	.word 0xfa8c2579  ! 1: LDUBA_I	lduba	[%r16, + 0x0579] %asi, %r29
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	.word 0xea8c2032  ! 1: LDUBA_I	lduba	[%r16, + 0x0032] %asi, %r21
	.word 0xc6942b62  ! 1: LDUHA_I	lduha	[%r16, + 0x0b62] %asi, %r3
	.word 0xc6c42868  ! 1: LDSWA_I	ldswa	[%r16, + 0x0868] %asi, %r3
	.word 0xc65c25c0  ! 1: LDX_I	ldx	[%r16 + 0x05c0], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_689
	dec %r31
        mov 0xc5, %r31
thr3_loop_cnt_690:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xdacc25f2  ! 1: LDSBA_I	ldsba	[%r16, + 0x05f2] %asi, %r13
	.word 0xc6442724  ! 1: LDSW_I	ldsw	[%r16 + 0x0724], %r3
	.word 0xc6542cfc  ! 1: LDSH_I	ldsh	[%r16 + 0x0cfc], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc604286c  ! 1: LDUW_I	lduw	[%r16 + 0x086c], %r3
	.word 0xfcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r30
	.word 0xc6d42dc6  ! 1: LDSHA_I	ldsha	[%r16, + 0x0dc6] %asi, %r3
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	brnz %r31,thr3_loop_cnt_690
	dec %r31
	.word 0x96142377  ! 1: OR_I	or 	%r16, 0x0377, %r11
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0x4f, %r31
thr3_loop_cnt_691:
	.word 0xf4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r26
	.word 0xde0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r15
	.word 0xd85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r12
	.word 0xc6c42718  ! 1: LDSWA_I	ldswa	[%r16, + 0x0718] %asi, %r3
	.word 0xc6d42c80  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c80] %asi, %r3
	.word 0xc6042e40  ! 1: LDUW_I	lduw	[%r16 + 0x0e40], %r3
	.word 0xf8d427a6  ! 1: LDSHA_I	ldsha	[%r16, + 0x07a6] %asi, %r28
	.word 0xda4c2e7b  ! 1: LDSB_I	ldsb	[%r16 + 0x0e7b], %r13
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	brnz %r31,thr3_loop_cnt_691
	dec %r31
	.word 0x932c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r9
	.word 0xac1427c6  ! 1: OR_I	or 	%r16, 0x07c6, %r22
	.word 0xbc1c0002  ! 1: XOR_R	xor 	%r16, %r2, %r30
        mov 0x5d, %r31
thr3_loop_cnt_692:
	.word 0xc6942e6c  ! 1: LDUHA_I	lduha	[%r16, + 0x0e6c] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6842698  ! 1: LDUWA_I	lduwa	[%r16, + 0x0698] %asi, %r3
	.word 0xde8c2e1f  ! 1: LDUBA_I	lduba	[%r16, + 0x0e1f] %asi, %r15
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6dc2f48  ! 1: LDXA_I	ldxa	[%r16, + 0x0f48] %asi, %r3
	.word 0xc6442250  ! 1: LDSW_I	ldsw	[%r16 + 0x0250], %r3
	.word 0xe8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r20
	brnz %r31,thr3_loop_cnt_692
	dec %r31
        mov 0x4b, %r31
thr3_loop_cnt_693:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe25c2f18  ! 1: LDX_I	ldx	[%r16 + 0x0f18], %r17
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe84421c0  ! 1: LDSW_I	ldsw	[%r16 + 0x01c0], %r20
	.word 0xe4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r18
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_693
	dec %r31
        mov 0x7d, %r31
thr3_loop_cnt_694:
	.word 0xc64c215b  ! 1: LDSB_I	ldsb	[%r16 + 0x015b], %r3
	.word 0xda54229c  ! 1: LDSH_I	ldsh	[%r16 + 0x029c], %r13
	.word 0xc6142702  ! 1: LDUH_I	lduh	[%r16 + 0x0702], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xeedc2458  ! 1: LDXA_I	ldxa	[%r16, + 0x0458] %asi, %r23
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6d4260c  ! 1: LDSHA_I	ldsha	[%r16, + 0x060c] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc60c288d  ! 1: LDUB_I	ldub	[%r16 + 0x088d], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r19
	brnz %r31,thr3_loop_cnt_694
	dec %r31
	.word 0x92040002  ! 1: ADD_R	add 	%r16, %r2, %r9
	.word 0x862c22c6  ! 1: ANDN_I	andn 	%r16, 0x02c6, %r3
        mov 0xb4, %r31
thr3_loop_cnt_695:
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xd0142d00  ! 1: LDUH_I	lduh	[%r16 + 0x0d00], %r8
	.word 0xeed42984  ! 1: LDSHA_I	ldsha	[%r16, + 0x0984] %asi, %r23
	.word 0xce040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r7
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	.word 0xc6cc2def  ! 1: LDSBA_I	ldsba	[%r16, + 0x0def] %asi, %r3
	.word 0xce8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r7
	.word 0xec0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r22
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xfad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r29
	brnz %r31,thr3_loop_cnt_695
	dec %r31
        mov 0xbf, %r31
thr3_loop_cnt_696:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r17
	.word 0xc6dc2720  ! 1: LDXA_I	ldxa	[%r16, + 0x0720] %asi, %r3
	.word 0xc64c2bd7  ! 1: LDSB_I	ldsb	[%r16 + 0x0bd7], %r3
	.word 0xe8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r20
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf0d4231e  ! 1: LDSHA_I	ldsha	[%r16, + 0x031e] %asi, %r24
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xec540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r22
	.word 0xc6542b48  ! 1: LDSH_I	ldsh	[%r16 + 0x0b48], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6dc2558  ! 1: LDXA_I	ldxa	[%r16, + 0x0558] %asi, %r3
	brnz %r31,thr3_loop_cnt_696
	dec %r31
        mov 0x28, %r31
thr3_loop_cnt_697:
	.word 0xd84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r12
	.word 0xd0842210  ! 1: LDUWA_I	lduwa	[%r16, + 0x0210] %asi, %r8
	.word 0xc69429e2  ! 1: LDUHA_I	lduha	[%r16, + 0x09e2] %asi, %r3
	.word 0xd64428e8  ! 1: LDSW_I	ldsw	[%r16 + 0x08e8], %r11
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd094292e  ! 1: LDUHA_I	lduha	[%r16, + 0x092e] %asi, %r8
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_697
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x862c2bb5  ! 1: ANDN_I	andn 	%r16, 0x0bb5, %r3
        mov 0x9a, %r31
thr3_loop_cnt_698:
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	.word 0xd4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r10
	.word 0xc6cc202e  ! 1: LDSBA_I	ldsba	[%r16, + 0x002e] %asi, %r3
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xf68c2ed6  ! 1: LDUBA_I	lduba	[%r16, + 0x0ed6] %asi, %r27
	.word 0xc65c2f70  ! 1: LDX_I	ldx	[%r16 + 0x0f70], %r3
	.word 0xc68c20cc  ! 1: LDUBA_I	lduba	[%r16, + 0x00cc] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc64422fc  ! 1: LDSW_I	ldsw	[%r16 + 0x02fc], %r3
	.word 0xfc5c22b0  ! 1: LDX_I	ldx	[%r16 + 0x02b0], %r30
	brnz %r31,thr3_loop_cnt_698
	dec %r31
	.word 0x86142215  ! 1: OR_I	or 	%r16, 0x0215, %r3
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0xb61c0002  ! 1: XOR_R	xor 	%r16, %r2, %r27
        mov 0x36, %r31
thr3_loop_cnt_699:
	.word 0xecc42498  ! 1: LDSWA_I	ldswa	[%r16, + 0x0498] %asi, %r22
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xdcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r14
	.word 0xda841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r13
	.word 0xf68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r27
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf2d42416  ! 1: LDSHA_I	ldsha	[%r16, + 0x0416] %asi, %r25
	brnz %r31,thr3_loop_cnt_699
	dec %r31
	.word 0xb61c0002  ! 1: XOR_R	xor 	%r16, %r2, %r27
        mov 0xa8, %r31
thr3_loop_cnt_700:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc68c2643  ! 1: LDUBA_I	lduba	[%r16, + 0x0643] %asi, %r3
	.word 0xec540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r22
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r28
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xda542c52  ! 1: LDSH_I	ldsh	[%r16 + 0x0c52], %r13
	.word 0xc6dc20d0  ! 1: LDXA_I	ldxa	[%r16, + 0x00d0] %asi, %r3
	.word 0xc694206a  ! 1: LDUHA_I	lduha	[%r16, + 0x006a] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc23b7  ! 1: LDSBA_I	ldsba	[%r16, + 0x03b7] %asi, %r3
	.word 0xc60c2029  ! 1: LDUB_I	ldub	[%r16 + 0x0029], %r3
	brnz %r31,thr3_loop_cnt_700
	dec %r31
	.word 0x8e142786  ! 1: OR_I	or 	%r16, 0x0786, %r7
        mov 0xc7, %r31
thr3_loop_cnt_701:
	.word 0xc6442d68  ! 1: LDSW_I	ldsw	[%r16 + 0x0d68], %r3
	.word 0xc6842a54  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a54] %asi, %r3
	.word 0xdc142376  ! 1: LDUH_I	lduh	[%r16 + 0x0376], %r14
	.word 0xc64423f4  ! 1: LDSW_I	ldsw	[%r16 + 0x03f4], %r3
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	.word 0xc694203a  ! 1: LDUHA_I	lduha	[%r16, + 0x003a] %asi, %r3
	.word 0xdc8425c8  ! 1: LDUWA_I	lduwa	[%r16, + 0x05c8] %asi, %r14
	.word 0xd6cc2cce  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cce] %asi, %r11
	brnz %r31,thr3_loop_cnt_701
	dec %r31
	.word 0xa60c298d  ! 1: AND_I	and 	%r16, 0x098d, %r19
	.word 0x8e240002  ! 1: SUB_R	sub 	%r16, %r2, %r7
	.word 0x981c2e67  ! 1: XOR_I	xor 	%r16, 0x0e67, %r12
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x9c, %r31
thr3_loop_cnt_702:
	.word 0xfc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r30
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc25ad  ! 1: LDSBA_I	ldsba	[%r16, + 0x05ad] %asi, %r3
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xce142cfe  ! 1: LDUH_I	lduh	[%r16 + 0x0cfe], %r7
	.word 0xea0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r21
	.word 0xc6dc2540  ! 1: LDXA_I	ldxa	[%r16, + 0x0540] %asi, %r3
	.word 0xd8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r12
	brnz %r31,thr3_loop_cnt_702
	dec %r31
	.word 0x94440002  ! 1: ADDC_R	addc 	%r16, %r2, %r10
	.word 0x960c0002  ! 1: AND_R	and 	%r16, %r2, %r11
        mov 0xc1, %r31
thr3_loop_cnt_703:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6942a34  ! 1: LDUHA_I	lduha	[%r16, + 0x0a34] %asi, %r3
	.word 0xcc942d06  ! 1: LDUHA_I	lduha	[%r16, + 0x0d06] %asi, %r6
	.word 0xc6cc2b61  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b61] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r26
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xda440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r13
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe4cc2767  ! 1: LDSBA_I	ldsba	[%r16, + 0x0767] %asi, %r18
	.word 0xc6dc2a88  ! 1: LDXA_I	ldxa	[%r16, + 0x0a88] %asi, %r3
	brnz %r31,thr3_loop_cnt_703
	dec %r31
	.word 0x862c2ae5  ! 1: ANDN_I	andn 	%r16, 0x0ae5, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0xa20428e7  ! 1: ADD_I	add 	%r16, 0x08e7, %r17
	.word 0x952c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r10
        mov 0x60, %r31
thr3_loop_cnt_704:
	.word 0xfa8c2e0a  ! 1: LDUBA_I	lduba	[%r16, + 0x0e0a] %asi, %r29
	.word 0xe2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r17
	.word 0xc60c20f9  ! 1: LDUB_I	ldub	[%r16 + 0x00f9], %r3
	.word 0xdad42066  ! 1: LDSHA_I	ldsha	[%r16, + 0x0066] %asi, %r13
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xeec42bec  ! 1: LDSWA_I	ldswa	[%r16, + 0x0bec] %asi, %r23
	.word 0xcec42688  ! 1: LDSWA_I	ldswa	[%r16, + 0x0688] %asi, %r7
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_704
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0xf, %r31
thr3_loop_cnt_705:
	.word 0xccc42630  ! 1: LDSWA_I	ldswa	[%r16, + 0x0630] %asi, %r6
	.word 0xc60c27c2  ! 1: LDUB_I	ldub	[%r16 + 0x07c2], %r3
	.word 0xe68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r19
	.word 0xc60c24c9  ! 1: LDUB_I	ldub	[%r16 + 0x04c9], %r3
	.word 0xc6542236  ! 1: LDSH_I	ldsh	[%r16 + 0x0236], %r3
	.word 0xe684293c  ! 1: LDUWA_I	lduwa	[%r16, + 0x093c] %asi, %r19
	.word 0xd0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r8
	.word 0xc6942c28  ! 1: LDUHA_I	lduha	[%r16, + 0x0c28] %asi, %r3
	.word 0xf0042a80  ! 1: LDUW_I	lduw	[%r16 + 0x0a80], %r24
	brnz %r31,thr3_loop_cnt_705
	dec %r31
	.word 0xab2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r21
	.word 0xbb2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r29
	.word 0x9e0423e4  ! 1: ADD_I	add 	%r16, 0x03e4, %r15
        mov 0x67, %r31
thr3_loop_cnt_706:
	.word 0xdacc2cab  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cab] %asi, %r13
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc65422c8  ! 1: LDSH_I	ldsh	[%r16 + 0x02c8], %r3
	.word 0xdacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r13
	.word 0xf0cc20aa  ! 1: LDSBA_I	ldsba	[%r16, + 0x00aa] %asi, %r24
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xc6042374  ! 1: LDUW_I	lduw	[%r16 + 0x0374], %r3
	brnz %r31,thr3_loop_cnt_706
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x993c1002  ! 1: SRAX_R	srax	%r16, %r2, %r12
	.word 0x98240002  ! 1: SUB_R	sub 	%r16, %r2, %r12
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0x83, %r31
thr3_loop_cnt_707:
	.word 0xc6c42b6c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b6c] %asi, %r3
	.word 0xc60c2bdb  ! 1: LDUB_I	ldub	[%r16 + 0x0bdb], %r3
	.word 0xc694295c  ! 1: LDUHA_I	lduha	[%r16, + 0x095c] %asi, %r3
	.word 0xec8c297f  ! 1: LDUBA_I	lduba	[%r16, + 0x097f] %asi, %r22
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	.word 0xcecc2d69  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d69] %asi, %r7
	.word 0xd2dc2ab8  ! 1: LDXA_I	ldxa	[%r16, + 0x0ab8] %asi, %r9
	.word 0xe25c28e0  ! 1: LDX_I	ldx	[%r16 + 0x08e0], %r17
	.word 0xdacc24ad  ! 1: LDSBA_I	ldsba	[%r16, + 0x04ad] %asi, %r13
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_707
	dec %r31
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x8634272b  ! 1: SUBC_I	orn 	%r16, 0x072b, %r3
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x46, %r31
thr3_loop_cnt_708:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc65c24c0  ! 1: LDX_I	ldx	[%r16 + 0x04c0], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6dc2088  ! 1: LDXA_I	ldxa	[%r16, + 0x0088] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xfa442eb0  ! 1: LDSW_I	ldsw	[%r16 + 0x0eb0], %r29
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xfa8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r29
	.word 0xeedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r23
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	brnz %r31,thr3_loop_cnt_708
	dec %r31
	.word 0x9b2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r13
        mov 0x55, %r31
thr3_loop_cnt_709:
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xfad42670  ! 1: LDSHA_I	ldsha	[%r16, + 0x0670] %asi, %r29
	.word 0xc60420fc  ! 1: LDUW_I	lduw	[%r16 + 0x00fc], %r3
	.word 0xfa842b98  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b98] %asi, %r29
	.word 0xc6d425ae  ! 1: LDSHA_I	ldsha	[%r16, + 0x05ae] %asi, %r3
	.word 0xc6142b38  ! 1: LDUH_I	lduh	[%r16 + 0x0b38], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xec941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r22
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	brnz %r31,thr3_loop_cnt_709
	dec %r31
        mov 0x33, %r31
thr3_loop_cnt_710:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xdc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r14
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xc61422f0  ! 1: LDUH_I	lduh	[%r16 + 0x02f0], %r3
	.word 0xf08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r24
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	.word 0xc65420fa  ! 1: LDSH_I	ldsh	[%r16 + 0x00fa], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_710
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0x74, %r31
thr3_loop_cnt_711:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r24
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc68c2667  ! 1: LDUBA_I	lduba	[%r16, + 0x0667] %asi, %r3
	.word 0xc60c25af  ! 1: LDUB_I	ldub	[%r16 + 0x05af], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe80c2c75  ! 1: LDUB_I	ldub	[%r16 + 0x0c75], %r20
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r19
	.word 0xc61427fe  ! 1: LDUH_I	lduh	[%r16 + 0x07fe], %r3
	.word 0xee5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r23
	.word 0xc6c427cc  ! 1: LDSWA_I	ldswa	[%r16, + 0x07cc] %asi, %r3
	brnz %r31,thr3_loop_cnt_711
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x862421a2  ! 1: SUB_I	sub 	%r16, 0x01a2, %r3
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x8f, %r31
thr3_loop_cnt_712:
	.word 0xd4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r10
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	.word 0xe84c2857  ! 1: LDSB_I	ldsb	[%r16 + 0x0857], %r20
	.word 0xfc0c2881  ! 1: LDUB_I	ldub	[%r16 + 0x0881], %r30
	.word 0xe6942ff0  ! 1: LDUHA_I	lduha	[%r16, + 0x0ff0] %asi, %r19
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xfa142bce  ! 1: LDUH_I	lduh	[%r16 + 0x0bce], %r29
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xd04c2545  ! 1: LDSB_I	ldsb	[%r16 + 0x0545], %r8
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xcc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r6
	brnz %r31,thr3_loop_cnt_712
	dec %r31
	.word 0x992c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r12
	.word 0xb13c1002  ! 1: SRAX_R	srax	%r16, %r2, %r24
	.word 0xac3c2818  ! 1: XNOR_I	xnor 	%r16, 0x0818, %r22
	.word 0xbb340002  ! 1: SRL_R	srl 	%r16, %r2, %r29
        mov 0x61, %r31
thr3_loop_cnt_713:
	.word 0xf4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r26
	.word 0xfadc2608  ! 1: LDXA_I	ldxa	[%r16, + 0x0608] %asi, %r29
	.word 0xd09428b2  ! 1: LDUHA_I	lduha	[%r16, + 0x08b2] %asi, %r8
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf64c20df  ! 1: LDSB_I	ldsb	[%r16 + 0x00df], %r27
	.word 0xc60c266e  ! 1: LDUB_I	ldub	[%r16 + 0x066e], %r3
	.word 0xc60c249b  ! 1: LDUB_I	ldub	[%r16 + 0x049b], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_713
	dec %r31
	.word 0xa8342f5c  ! 1: SUBC_I	orn 	%r16, 0x0f5c, %r20
	.word 0xa73c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r19
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x3f, %r31
thr3_loop_cnt_714:
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	.word 0xea540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r21
	.word 0xee0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r23
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xea440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r21
	.word 0xc604228c  ! 1: LDUW_I	lduw	[%r16 + 0x028c], %r3
	.word 0xd6542a2e  ! 1: LDSH_I	ldsh	[%r16 + 0x0a2e], %r11
	brnz %r31,thr3_loop_cnt_714
	dec %r31
        mov 0x9f, %r31
thr3_loop_cnt_715:
	.word 0xc65424a0  ! 1: LDSH_I	ldsh	[%r16 + 0x04a0], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc654243a  ! 1: LDSH_I	ldsh	[%r16 + 0x043a], %r3
	.word 0xfa440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r29
	.word 0xf8942650  ! 1: LDUHA_I	lduha	[%r16, + 0x0650] %asi, %r28
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xf4cc21dc  ! 1: LDSBA_I	ldsba	[%r16, + 0x01dc] %asi, %r26
	.word 0xde1424a6  ! 1: LDUH_I	lduh	[%r16 + 0x04a6], %r15
	.word 0xc65420b0  ! 1: LDSH_I	ldsh	[%r16 + 0x00b0], %r3
	brnz %r31,thr3_loop_cnt_715
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0xc1, %r31
thr3_loop_cnt_716:
	.word 0xc6142394  ! 1: LDUH_I	lduh	[%r16 + 0x0394], %r3
	.word 0xc6d423fc  ! 1: LDSHA_I	ldsha	[%r16, + 0x03fc] %asi, %r3
	.word 0xc6942e5c  ! 1: LDUHA_I	lduha	[%r16, + 0x0e5c] %asi, %r3
	.word 0xecd42b5c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b5c] %asi, %r22
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xce5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r7
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	.word 0xe8d42c3a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c3a] %asi, %r20
	.word 0xfa440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r29
	.word 0xc68c2251  ! 1: LDUBA_I	lduba	[%r16, + 0x0251] %asi, %r3
	brnz %r31,thr3_loop_cnt_716
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0xa82428fa  ! 1: SUB_I	sub 	%r16, 0x08fa, %r20
        mov 0x2b, %r31
thr3_loop_cnt_717:
	.word 0xc6442204  ! 1: LDSW_I	ldsw	[%r16 + 0x0204], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6942728  ! 1: LDUHA_I	lduha	[%r16, + 0x0728] %asi, %r3
	.word 0xc6142050  ! 1: LDUH_I	lduh	[%r16 + 0x0050], %r3
	.word 0xde841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r15
	.word 0xdc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r14
	.word 0xe25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r17
	.word 0xd8cc2666  ! 1: LDSBA_I	ldsba	[%r16, + 0x0666] %asi, %r12
	.word 0xf4dc24d8  ! 1: LDXA_I	ldxa	[%r16, + 0x04d8] %asi, %r26
	brnz %r31,thr3_loop_cnt_717
	dec %r31
        mov 0x88, %r31
thr3_loop_cnt_718:
	.word 0xc69427a8  ! 1: LDUHA_I	lduha	[%r16, + 0x07a8] %asi, %r3
	.word 0xc69424a4  ! 1: LDUHA_I	lduha	[%r16, + 0x04a4] %asi, %r3
	.word 0xf2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r25
	.word 0xdccc23c2  ! 1: LDSBA_I	ldsba	[%r16, + 0x03c2] %asi, %r14
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r20
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_718
	dec %r31
	.word 0xb8340002  ! 1: SUBC_R	orn 	%r16, %r2, %r28
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0xba340002  ! 1: SUBC_R	orn 	%r16, %r2, %r29
        mov 0x1a, %r31
thr3_loop_cnt_719:
	.word 0xc6042d64  ! 1: LDUW_I	lduw	[%r16 + 0x0d64], %r3
	.word 0xc6d42ade  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ade] %asi, %r3
	.word 0xf4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r26
	.word 0xfa941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r29
	.word 0xc60c253b  ! 1: LDUB_I	ldub	[%r16 + 0x053b], %r3
	.word 0xc6542dce  ! 1: LDSH_I	ldsh	[%r16 + 0x0dce], %r3
	.word 0xc60c23a1  ! 1: LDUB_I	ldub	[%r16 + 0x03a1], %r3
	.word 0xeec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r23
	.word 0xc6042f80  ! 1: LDUW_I	lduw	[%r16 + 0x0f80], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_719
	dec %r31
	.word 0x863c297a  ! 1: XNOR_I	xnor 	%r16, 0x097a, %r3
	.word 0x863c22fa  ! 1: XNOR_I	xnor 	%r16, 0x02fa, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x7f, %r31
thr3_loop_cnt_720:
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xce440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r7
	.word 0xc6542dce  ! 1: LDSH_I	ldsh	[%r16 + 0x0dce], %r3
	.word 0xf4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r26
	.word 0xf6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r27
	.word 0xc6842c80  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c80] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6942786  ! 1: LDUHA_I	lduha	[%r16, + 0x0786] %asi, %r3
	.word 0xd25424fe  ! 1: LDSH_I	ldsh	[%r16 + 0x04fe], %r9
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_720
	dec %r31
	.word 0xa61c2f4e  ! 1: XOR_I	xor 	%r16, 0x0f4e, %r19
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
        mov 0xc0, %r31
thr3_loop_cnt_721:
	.word 0xc6542778  ! 1: LDSH_I	ldsh	[%r16 + 0x0778], %r3
	.word 0xd88423b0  ! 1: LDUWA_I	lduwa	[%r16, + 0x03b0] %asi, %r12
	.word 0xfcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r30
	.word 0xced42ebc  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ebc] %asi, %r7
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	brnz %r31,thr3_loop_cnt_721
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0xc6, %r31
thr3_loop_cnt_722:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xe4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r18
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xee0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r23
	.word 0xe6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r19
	.word 0xfc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r30
	.word 0xc6c42750  ! 1: LDSWA_I	ldswa	[%r16, + 0x0750] %asi, %r3
	brnz %r31,thr3_loop_cnt_722
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x862c2e3c  ! 1: ANDN_I	andn 	%r16, 0x0e3c, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0xaa240002  ! 1: SUB_R	sub 	%r16, %r2, %r21
        mov 0x6c, %r31
thr3_loop_cnt_723:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r26
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xeed4254e  ! 1: LDSHA_I	ldsha	[%r16, + 0x054e] %asi, %r23
	.word 0xc6dc2108  ! 1: LDXA_I	ldxa	[%r16, + 0x0108] %asi, %r3
	.word 0xd61423a0  ! 1: LDUH_I	lduh	[%r16 + 0x03a0], %r11
	.word 0xfc54250c  ! 1: LDSH_I	ldsh	[%r16 + 0x050c], %r30
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xea5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r21
	brnz %r31,thr3_loop_cnt_723
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x86442528  ! 1: ADDC_I	addc 	%r16, 0x0528, %r3
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0x5, %r31
thr3_loop_cnt_724:
	.word 0xc68c2b53  ! 1: LDUBA_I	lduba	[%r16, + 0x0b53] %asi, %r3
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xde0c2fa9  ! 1: LDUB_I	ldub	[%r16 + 0x0fa9], %r15
	.word 0xea841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r21
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6d42aa6  ! 1: LDSHA_I	ldsha	[%r16, + 0x0aa6] %asi, %r3
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc60c2b16  ! 1: LDUB_I	ldub	[%r16 + 0x0b16], %r3
	brnz %r31,thr3_loop_cnt_724
	dec %r31
        mov 0x23, %r31
thr3_loop_cnt_725:
	.word 0xe2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r17
	.word 0xc6dc24b0  ! 1: LDXA_I	ldxa	[%r16, + 0x04b0] %asi, %r3
	.word 0xf4442fa8  ! 1: LDSW_I	ldsw	[%r16 + 0x0fa8], %r26
	.word 0xcc042748  ! 1: LDUW_I	lduw	[%r16 + 0x0748], %r6
	.word 0xc6442274  ! 1: LDSW_I	ldsw	[%r16 + 0x0274], %r3
	.word 0xce440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r7
	.word 0xde5c2680  ! 1: LDX_I	ldx	[%r16 + 0x0680], %r15
	.word 0xc654232e  ! 1: LDSH_I	ldsh	[%r16 + 0x032e], %r3
	.word 0xc6942326  ! 1: LDUHA_I	lduha	[%r16, + 0x0326] %asi, %r3
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	.word 0xc6842dfc  ! 1: LDUWA_I	lduwa	[%r16, + 0x0dfc] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_725
	dec %r31
        mov 0x68, %r31
thr3_loop_cnt_726:
	.word 0xce442ed4  ! 1: LDSW_I	ldsw	[%r16 + 0x0ed4], %r7
	.word 0xf8c42fc8  ! 1: LDSWA_I	ldswa	[%r16, + 0x0fc8] %asi, %r28
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r18
	.word 0xce142f14  ! 1: LDUH_I	lduh	[%r16 + 0x0f14], %r7
	.word 0xe8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r20
	.word 0xe48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r18
	.word 0xc68420dc  ! 1: LDUWA_I	lduwa	[%r16, + 0x00dc] %asi, %r3
	brnz %r31,thr3_loop_cnt_726
	dec %r31
	.word 0x862c21a3  ! 1: ANDN_I	andn 	%r16, 0x01a3, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x25, %r31
thr3_loop_cnt_727:
	.word 0xc6dc2be0  ! 1: LDXA_I	ldxa	[%r16, + 0x0be0] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xce8c2d0b  ! 1: LDUBA_I	lduba	[%r16, + 0x0d0b] %asi, %r7
	.word 0xf2d425c0  ! 1: LDSHA_I	ldsha	[%r16, + 0x05c0] %asi, %r25
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc64c2181  ! 1: LDSB_I	ldsb	[%r16 + 0x0181], %r3
	.word 0xec942854  ! 1: LDUHA_I	lduha	[%r16, + 0x0854] %asi, %r22
	.word 0xc64c243d  ! 1: LDSB_I	ldsb	[%r16 + 0x043d], %r3
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	brnz %r31,thr3_loop_cnt_727
	dec %r31
	.word 0x9a2c28e3  ! 1: ANDN_I	andn 	%r16, 0x08e3, %r13
        mov 0x64, %r31
thr3_loop_cnt_728:
	.word 0xda0c2267  ! 1: LDUB_I	ldub	[%r16 + 0x0267], %r13
	.word 0xc6c4224c  ! 1: LDSWA_I	ldswa	[%r16, + 0x024c] %asi, %r3
	.word 0xc6dc2388  ! 1: LDXA_I	ldxa	[%r16, + 0x0388] %asi, %r3
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xc6dc2c90  ! 1: LDXA_I	ldxa	[%r16, + 0x0c90] %asi, %r3
	.word 0xc65c2e48  ! 1: LDX_I	ldx	[%r16 + 0x0e48], %r3
	.word 0xecc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r22
	.word 0xd65421bc  ! 1: LDSH_I	ldsh	[%r16 + 0x01bc], %r11
	.word 0xc65c2a88  ! 1: LDX_I	ldx	[%r16 + 0x0a88], %r3
	.word 0xe8d42a0c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a0c] %asi, %r20
	brnz %r31,thr3_loop_cnt_728
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x8c040002  ! 1: ADD_R	add 	%r16, %r2, %r6
        mov 0x57, %r31
thr3_loop_cnt_729:
	.word 0xc64c2f1e  ! 1: LDSB_I	ldsb	[%r16 + 0x0f1e], %r3
	.word 0xf4c424e8  ! 1: LDSWA_I	ldswa	[%r16, + 0x04e8] %asi, %r26
	.word 0xc65c26c0  ! 1: LDX_I	ldx	[%r16 + 0x06c0], %r3
	.word 0xd44c22a8  ! 1: LDSB_I	ldsb	[%r16 + 0x02a8], %r10
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6142e74  ! 1: LDUH_I	lduh	[%r16 + 0x0e74], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc68c281e  ! 1: LDUBA_I	lduba	[%r16, + 0x081e] %asi, %r3
	.word 0xc6cc256c  ! 1: LDSBA_I	ldsba	[%r16, + 0x056c] %asi, %r3
	.word 0xdc94245e  ! 1: LDUHA_I	lduha	[%r16, + 0x045e] %asi, %r14
	brnz %r31,thr3_loop_cnt_729
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x9b340002  ! 1: SRL_R	srl 	%r16, %r2, %r13
        mov 0x57, %r31
thr3_loop_cnt_730:
	.word 0xc6d42c5e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c5e] %asi, %r3
	.word 0xc6cc2c10  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c10] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xdec42738  ! 1: LDSWA_I	ldswa	[%r16, + 0x0738] %asi, %r15
	.word 0xd08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r8
	.word 0xc65c2d98  ! 1: LDX_I	ldx	[%r16 + 0x0d98], %r3
	.word 0xf4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r26
	brnz %r31,thr3_loop_cnt_730
	dec %r31
	.word 0x8614296c  ! 1: OR_I	or 	%r16, 0x096c, %r3
	.word 0x86342bc0  ! 1: ORN_I	orn 	%r16, 0x0bc0, %r3
	.word 0xba140002  ! 1: OR_R	or 	%r16, %r2, %r29
	.word 0x9d3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r14
        mov 0x19, %r31
thr3_loop_cnt_731:
	.word 0xc60425b4  ! 1: LDUW_I	lduw	[%r16 + 0x05b4], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc60422d8  ! 1: LDUW_I	lduw	[%r16 + 0x02d8], %r3
	.word 0xfcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r30
	.word 0xc654231a  ! 1: LDSH_I	ldsh	[%r16 + 0x031a], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xea4423b0  ! 1: LDSW_I	ldsw	[%r16 + 0x03b0], %r21
	.word 0xc6042ec4  ! 1: LDUW_I	lduw	[%r16 + 0x0ec4], %r3
	brnz %r31,thr3_loop_cnt_731
	dec %r31
        mov 0x7b, %r31
thr3_loop_cnt_732:
	.word 0xc60c24fb  ! 1: LDUB_I	ldub	[%r16 + 0x04fb], %r3
	.word 0xd0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r8
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xfa5c29b0  ! 1: LDX_I	ldx	[%r16 + 0x09b0], %r29
	.word 0xce440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r7
	.word 0xc68c2620  ! 1: LDUBA_I	lduba	[%r16, + 0x0620] %asi, %r3
	.word 0xc68c20bd  ! 1: LDUBA_I	lduba	[%r16, + 0x00bd] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd6cc2a48  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a48] %asi, %r11
	.word 0xc64c2833  ! 1: LDSB_I	ldsb	[%r16 + 0x0833], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_732
	dec %r31
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x86242398  ! 1: SUB_I	sub 	%r16, 0x0398, %r3
        mov 0xac, %r31
thr3_loop_cnt_733:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6942e4e  ! 1: LDUHA_I	lduha	[%r16, + 0x0e4e] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6c42414  ! 1: LDSWA_I	ldswa	[%r16, + 0x0414] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6442a14  ! 1: LDSW_I	ldsw	[%r16 + 0x0a14], %r3
	.word 0xda142aac  ! 1: LDUH_I	lduh	[%r16 + 0x0aac], %r13
	.word 0xf8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r28
	brnz %r31,thr3_loop_cnt_733
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0xa60c0002  ! 1: AND_R	and 	%r16, %r2, %r19
	.word 0x8614259c  ! 1: OR_I	or 	%r16, 0x059c, %r3
	.word 0x8c240002  ! 1: SUB_R	sub 	%r16, %r2, %r6
        mov 0x93, %r31
thr3_loop_cnt_734:
	.word 0xda442de4  ! 1: LDSW_I	ldsw	[%r16 + 0x0de4], %r13
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xda5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r13
	.word 0xc64420a0  ! 1: LDSW_I	ldsw	[%r16 + 0x00a0], %r3
	.word 0xfac421c8  ! 1: LDSWA_I	ldswa	[%r16, + 0x01c8] %asi, %r29
	.word 0xc64c2a9a  ! 1: LDSB_I	ldsb	[%r16 + 0x0a9a], %r3
	.word 0xc6842a24  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a24] %asi, %r3
	.word 0xc654256a  ! 1: LDSH_I	ldsh	[%r16 + 0x056a], %r3
	.word 0xc6d42de8  ! 1: LDSHA_I	ldsha	[%r16, + 0x0de8] %asi, %r3
	.word 0xd61423cc  ! 1: LDUH_I	lduh	[%r16 + 0x03cc], %r11
	brnz %r31,thr3_loop_cnt_734
	dec %r31
	.word 0x8634242c  ! 1: SUBC_I	orn 	%r16, 0x042c, %r3
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0xc5, %r31
thr3_loop_cnt_735:
	.word 0xe8d4227a  ! 1: LDSHA_I	ldsha	[%r16, + 0x027a] %asi, %r20
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xee5c2b50  ! 1: LDX_I	ldx	[%r16 + 0x0b50], %r23
	.word 0xc6cc24fa  ! 1: LDSBA_I	ldsba	[%r16, + 0x04fa] %asi, %r3
	.word 0xc65c2268  ! 1: LDX_I	ldx	[%r16 + 0x0268], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd4cc2175  ! 1: LDSBA_I	ldsba	[%r16, + 0x0175] %asi, %r10
	.word 0xe4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r18
	brnz %r31,thr3_loop_cnt_735
	dec %r31
	.word 0x86342fb7  ! 1: ORN_I	orn 	%r16, 0x0fb7, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x6a, %r31
thr3_loop_cnt_736:
	.word 0xdc4c267e  ! 1: LDSB_I	ldsb	[%r16 + 0x067e], %r14
	.word 0xf48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r26
	.word 0xc61426d0  ! 1: LDUH_I	lduh	[%r16 + 0x06d0], %r3
	.word 0xce5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r7
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6dc2390  ! 1: LDXA_I	ldxa	[%r16, + 0x0390] %asi, %r3
	.word 0xd2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r9
	.word 0xe60c2642  ! 1: LDUB_I	ldub	[%r16 + 0x0642], %r19
	.word 0xc60c2f9d  ! 1: LDUB_I	ldub	[%r16 + 0x0f9d], %r3
	.word 0xc64c2e67  ! 1: LDSB_I	ldsb	[%r16 + 0x0e67], %r3
	brnz %r31,thr3_loop_cnt_736
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x9d343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r14
        mov 0x6a, %r31
thr3_loop_cnt_737:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r17
	.word 0xd6dc2098  ! 1: LDXA_I	ldxa	[%r16, + 0x0098] %asi, %r11
	.word 0xc6cc2630  ! 1: LDSBA_I	ldsba	[%r16, + 0x0630] %asi, %r3
	.word 0xc694232e  ! 1: LDUHA_I	lduha	[%r16, + 0x032e] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r27
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc64c2430  ! 1: LDSB_I	ldsb	[%r16 + 0x0430], %r3
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_737
	dec %r31
	.word 0xb6342610  ! 1: SUBC_I	orn 	%r16, 0x0610, %r27
	.word 0x862c2155  ! 1: ANDN_I	andn 	%r16, 0x0155, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x932c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r9
        mov 0x64, %r31
thr3_loop_cnt_738:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xe20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r17
	.word 0xd4dc25f0  ! 1: LDXA_I	ldxa	[%r16, + 0x05f0] %asi, %r10
	.word 0xecd42a2c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a2c] %asi, %r22
	.word 0xc6cc25f2  ! 1: LDSBA_I	ldsba	[%r16, + 0x05f2] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xea4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r21
	.word 0xc65c2c00  ! 1: LDX_I	ldx	[%r16 + 0x0c00], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd4dc25c8  ! 1: LDXA_I	ldxa	[%r16, + 0x05c8] %asi, %r10
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	brnz %r31,thr3_loop_cnt_738
	dec %r31
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x1c, %r31
thr3_loop_cnt_739:
	.word 0xc65c2a20  ! 1: LDX_I	ldx	[%r16 + 0x0a20], %r3
	.word 0xc6dc2f28  ! 1: LDXA_I	ldxa	[%r16, + 0x0f28] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc68c2033  ! 1: LDUBA_I	lduba	[%r16, + 0x0033] %asi, %r3
	.word 0xc64c26a8  ! 1: LDSB_I	ldsb	[%r16 + 0x06a8], %r3
	.word 0xeed41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r23
	brnz %r31,thr3_loop_cnt_739
	dec %r31
        mov 0x7e, %r31
thr3_loop_cnt_740:
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xc64429c4  ! 1: LDSW_I	ldsw	[%r16 + 0x09c4], %r3
	.word 0xc64c2a0d  ! 1: LDSB_I	ldsb	[%r16 + 0x0a0d], %r3
	.word 0xd6942a52  ! 1: LDUHA_I	lduha	[%r16, + 0x0a52] %asi, %r11
	.word 0xf68c229d  ! 1: LDUBA_I	lduba	[%r16, + 0x029d] %asi, %r27
	.word 0xf4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r26
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_740
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x861c2324  ! 1: XOR_I	xor 	%r16, 0x0324, %r3
	.word 0x9f343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r15
        mov 0x2, %r31
thr3_loop_cnt_741:
	.word 0xc6142a06  ! 1: LDUH_I	lduh	[%r16 + 0x0a06], %r3
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xcc042f34  ! 1: LDUW_I	lduw	[%r16 + 0x0f34], %r6
	.word 0xf4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r26
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xee841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r23
	.word 0xd8d42420  ! 1: LDSHA_I	ldsha	[%r16, + 0x0420] %asi, %r12
	brnz %r31,thr3_loop_cnt_741
	dec %r31
	.word 0x86242284  ! 1: SUB_I	sub 	%r16, 0x0284, %r3
        mov 0x18, %r31
thr3_loop_cnt_742:
	.word 0xec5427fe  ! 1: LDSH_I	ldsh	[%r16 + 0x07fe], %r22
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xd24c2675  ! 1: LDSB_I	ldsb	[%r16 + 0x0675], %r9
	.word 0xc6dc2160  ! 1: LDXA_I	ldxa	[%r16, + 0x0160] %asi, %r3
	.word 0xc694298a  ! 1: LDUHA_I	lduha	[%r16, + 0x098a] %asi, %r3
	.word 0xd6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r11
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf6c42a7c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a7c] %asi, %r27
	brnz %r31,thr3_loop_cnt_742
	dec %r31
	.word 0x86242b02  ! 1: SUB_I	sub 	%r16, 0x0b02, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x860421dd  ! 1: ADD_I	add 	%r16, 0x01dd, %r3
	.word 0x9b2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r13
        mov 0x4e, %r31
thr3_loop_cnt_743:
	.word 0xd4042f8c  ! 1: LDUW_I	lduw	[%r16 + 0x0f8c], %r10
	.word 0xc6842a08  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a08] %asi, %r3
	.word 0xda8423b8  ! 1: LDUWA_I	lduwa	[%r16, + 0x03b8] %asi, %r13
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xfcc42e6c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e6c] %asi, %r30
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xec5c2350  ! 1: LDX_I	ldx	[%r16 + 0x0350], %r22
	.word 0xf6c42814  ! 1: LDSWA_I	ldswa	[%r16, + 0x0814] %asi, %r27
	.word 0xc68c21c4  ! 1: LDUBA_I	lduba	[%r16, + 0x01c4] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_743
	dec %r31
	.word 0x86342cc4  ! 1: ORN_I	orn 	%r16, 0x0cc4, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x973c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r11
	.word 0x862c2eb1  ! 1: ANDN_I	andn 	%r16, 0x0eb1, %r3
        mov 0x54, %r31
thr3_loop_cnt_744:
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xf60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r27
	.word 0xe64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r19
	.word 0xfa5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r29
	.word 0xc6442ddc  ! 1: LDSW_I	ldsw	[%r16 + 0x0ddc], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc60c22c6  ! 1: LDUB_I	ldub	[%r16 + 0x02c6], %r3
	.word 0xde5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r15
	.word 0xe4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r18
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_744
	dec %r31
	.word 0x96242e76  ! 1: SUB_I	sub 	%r16, 0x0e76, %r11
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x73, %r31
thr3_loop_cnt_745:
	.word 0xfa94258a  ! 1: LDUHA_I	lduha	[%r16, + 0x058a] %asi, %r29
	.word 0xc6142e08  ! 1: LDUH_I	lduh	[%r16 + 0x0e08], %r3
	.word 0xdcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r14
	.word 0xe65c22c8  ! 1: LDX_I	ldx	[%r16 + 0x02c8], %r19
	.word 0xec8c2400  ! 1: LDUBA_I	lduba	[%r16, + 0x0400] %asi, %r22
	.word 0xd68c2f3c  ! 1: LDUBA_I	lduba	[%r16, + 0x0f3c] %asi, %r11
	.word 0xe2c42f0c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f0c] %asi, %r17
	.word 0xdc4427e8  ! 1: LDSW_I	ldsw	[%r16 + 0x07e8], %r14
	.word 0xe8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r20
	.word 0xec8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r22
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_745
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x863c2359  ! 1: XNOR_I	xnor 	%r16, 0x0359, %r3
	.word 0xa5342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r18
	.word 0x96340002  ! 1: ORN_R	orn 	%r16, %r2, %r11
        mov 0xa0, %r31
thr3_loop_cnt_746:
	.word 0xc65c2ae0  ! 1: LDX_I	ldx	[%r16 + 0x0ae0], %r3
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xfa941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r29
	.word 0xf8842acc  ! 1: LDUWA_I	lduwa	[%r16, + 0x0acc] %asi, %r28
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xeacc2ab0  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ab0] %asi, %r21
	.word 0xc68c22d9  ! 1: LDUBA_I	lduba	[%r16, + 0x02d9] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_746
	dec %r31
	.word 0xba3c283d  ! 1: XNOR_I	xnor 	%r16, 0x083d, %r29
	.word 0xb7343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r27
	.word 0xa6042a95  ! 1: ADD_I	add 	%r16, 0x0a95, %r19
	.word 0x861c2a98  ! 1: XOR_I	xor 	%r16, 0x0a98, %r3
        mov 0x10, %r31
thr3_loop_cnt_747:
	.word 0xc6942b34  ! 1: LDUHA_I	lduha	[%r16, + 0x0b34] %asi, %r3
	.word 0xc6442bcc  ! 1: LDSW_I	ldsw	[%r16 + 0x0bcc], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6942a40  ! 1: LDUHA_I	lduha	[%r16, + 0x0a40] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r27
	.word 0xf4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r26
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xcc842c74  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c74] %asi, %r6
	.word 0xc694284e  ! 1: LDUHA_I	lduha	[%r16, + 0x084e] %asi, %r3
	.word 0xe65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r19
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	brnz %r31,thr3_loop_cnt_747
	dec %r31
	.word 0x9d341002  ! 1: SRLX_R	srlx	%r16, %r2, %r14
        mov 0x2a, %r31
thr3_loop_cnt_748:
	.word 0xec440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r22
	.word 0xe6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r19
	.word 0xc6542a64  ! 1: LDSH_I	ldsh	[%r16 + 0x0a64], %r3
	.word 0xd6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r11
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc64c2018  ! 1: LDSB_I	ldsb	[%r16 + 0x0018], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd2dc26e8  ! 1: LDXA_I	ldxa	[%r16, + 0x06e8] %asi, %r9
	brnz %r31,thr3_loop_cnt_748
	dec %r31
	.word 0x952c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r10
	.word 0x8f3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r7
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0xf, %r31
thr3_loop_cnt_749:
	.word 0xc6d421f6  ! 1: LDSHA_I	ldsha	[%r16, + 0x01f6] %asi, %r3
	.word 0xce8c2264  ! 1: LDUBA_I	lduba	[%r16, + 0x0264] %asi, %r7
	.word 0xd2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r9
	.word 0xc6dc2620  ! 1: LDXA_I	ldxa	[%r16, + 0x0620] %asi, %r3
	.word 0xec4c2179  ! 1: LDSB_I	ldsb	[%r16 + 0x0179], %r22
	.word 0xc6d4271e  ! 1: LDSHA_I	ldsha	[%r16, + 0x071e] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe44c2f53  ! 1: LDSB_I	ldsb	[%r16 + 0x0f53], %r18
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xdc0424dc  ! 1: LDUW_I	lduw	[%r16 + 0x04dc], %r14
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6042734  ! 1: LDUW_I	lduw	[%r16 + 0x0734], %r3
	brnz %r31,thr3_loop_cnt_749
	dec %r31
	.word 0xa22c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r17
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0x3d, %r31
thr3_loop_cnt_750:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd0942ff4  ! 1: LDUHA_I	lduha	[%r16, + 0x0ff4] %asi, %r8
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc65c2490  ! 1: LDX_I	ldx	[%r16 + 0x0490], %r3
	.word 0xcecc25e5  ! 1: LDSBA_I	ldsba	[%r16, + 0x05e5] %asi, %r7
	.word 0xd0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r8
	.word 0xce5c2530  ! 1: LDX_I	ldx	[%r16 + 0x0530], %r7
	.word 0xde842038  ! 1: LDUWA_I	lduwa	[%r16, + 0x0038] %asi, %r15
	brnz %r31,thr3_loop_cnt_750
	dec %r31
        mov 0xa8, %r31
thr3_loop_cnt_751:
	.word 0xe2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r17
	.word 0xc6d42318  ! 1: LDSHA_I	ldsha	[%r16, + 0x0318] %asi, %r3
	.word 0xc6142692  ! 1: LDUH_I	lduh	[%r16 + 0x0692], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc25f0  ! 1: LDXA_I	ldxa	[%r16, + 0x05f0] %asi, %r3
	.word 0xd44c2660  ! 1: LDSB_I	ldsb	[%r16 + 0x0660], %r10
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xee5c2f78  ! 1: LDX_I	ldx	[%r16 + 0x0f78], %r23
	.word 0xfccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r30
	.word 0xfc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r30
	brnz %r31,thr3_loop_cnt_751
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x29, %r31
thr3_loop_cnt_752:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xdc8426e4  ! 1: LDUWA_I	lduwa	[%r16, + 0x06e4] %asi, %r14
	.word 0xc6d42c46  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c46] %asi, %r3
	.word 0xeadc2048  ! 1: LDXA_I	ldxa	[%r16, + 0x0048] %asi, %r21
	.word 0xcecc27a5  ! 1: LDSBA_I	ldsba	[%r16, + 0x07a5] %asi, %r7
	.word 0xc6442394  ! 1: LDSW_I	ldsw	[%r16 + 0x0394], %r3
	.word 0xde842b04  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b04] %asi, %r15
	.word 0xfc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r30
	brnz %r31,thr3_loop_cnt_752
	dec %r31
	.word 0x9a1424e9  ! 1: OR_I	or 	%r16, 0x04e9, %r13
        mov 0x98, %r31
thr3_loop_cnt_753:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xdc142b40  ! 1: LDUH_I	lduh	[%r16 + 0x0b40], %r14
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xdecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r15
	.word 0xc6d4201e  ! 1: LDSHA_I	ldsha	[%r16, + 0x001e] %asi, %r3
	.word 0xe2cc23a2  ! 1: LDSBA_I	ldsba	[%r16, + 0x03a2] %asi, %r17
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	brnz %r31,thr3_loop_cnt_753
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x8634204e  ! 1: SUBC_I	orn 	%r16, 0x004e, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x66, %r31
thr3_loop_cnt_754:
	.word 0xe8c42d68  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d68] %asi, %r20
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xfc0c2f42  ! 1: LDUB_I	ldub	[%r16 + 0x0f42], %r30
	.word 0xe8cc2203  ! 1: LDSBA_I	ldsba	[%r16, + 0x0203] %asi, %r20
	.word 0xc6542f48  ! 1: LDSH_I	ldsh	[%r16 + 0x0f48], %r3
	.word 0xdc0421a8  ! 1: LDUW_I	lduw	[%r16 + 0x01a8], %r14
	.word 0xc6dc25a0  ! 1: LDXA_I	ldxa	[%r16, + 0x05a0] %asi, %r3
	.word 0xfa042edc  ! 1: LDUW_I	lduw	[%r16 + 0x0edc], %r29
	.word 0xcc8c2d4c  ! 1: LDUBA_I	lduba	[%r16, + 0x0d4c] %asi, %r6
	.word 0xf2cc24f3  ! 1: LDSBA_I	ldsba	[%r16, + 0x04f3] %asi, %r25
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_754
	dec %r31
	.word 0xa20c2387  ! 1: AND_I	and 	%r16, 0x0387, %r17
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x93342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r9
	.word 0x861c2d6b  ! 1: XOR_I	xor 	%r16, 0x0d6b, %r3
        mov 0x5c, %r31
thr3_loop_cnt_755:
	.word 0xcc8c223d  ! 1: LDUBA_I	lduba	[%r16, + 0x023d] %asi, %r6
	.word 0xdc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r14
	.word 0xde440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r15
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xea0c2d0f  ! 1: LDUB_I	ldub	[%r16 + 0x0d0f], %r21
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xe61424e8  ! 1: LDUH_I	lduh	[%r16 + 0x04e8], %r19
	.word 0xd2042744  ! 1: LDUW_I	lduw	[%r16 + 0x0744], %r9
	.word 0xde542b80  ! 1: LDSH_I	ldsh	[%r16 + 0x0b80], %r15
	.word 0xeedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r23
	brnz %r31,thr3_loop_cnt_755
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x8e342be6  ! 1: SUBC_I	orn 	%r16, 0x0be6, %r7
        mov 0x68, %r31
thr3_loop_cnt_756:
	.word 0xc64c2885  ! 1: LDSB_I	ldsb	[%r16 + 0x0885], %r3
	.word 0xea542710  ! 1: LDSH_I	ldsh	[%r16 + 0x0710], %r21
	.word 0xc60427d0  ! 1: LDUW_I	lduw	[%r16 + 0x07d0], %r3
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	.word 0xd20c248e  ! 1: LDUB_I	ldub	[%r16 + 0x048e], %r9
	.word 0xc64c2b2d  ! 1: LDSB_I	ldsb	[%r16 + 0x0b2d], %r3
	.word 0xc60c27aa  ! 1: LDUB_I	ldub	[%r16 + 0x07aa], %r3
	.word 0xc6842890  ! 1: LDUWA_I	lduwa	[%r16, + 0x0890] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe4142c02  ! 1: LDUH_I	lduh	[%r16 + 0x0c02], %r18
	.word 0xfc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r30
	brnz %r31,thr3_loop_cnt_756
	dec %r31
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x942c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r10
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x15, %r31
thr3_loop_cnt_757:
	.word 0xeac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r21
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r28
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc65c2eb8  ! 1: LDX_I	ldx	[%r16 + 0x0eb8], %r3
	.word 0xc694253a  ! 1: LDUHA_I	lduha	[%r16, + 0x053a] %asi, %r3
	.word 0xc6942b48  ! 1: LDUHA_I	lduha	[%r16, + 0x0b48] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_757
	dec %r31
	.word 0x863c2a29  ! 1: XNOR_I	xnor 	%r16, 0x0a29, %r3
	.word 0xae2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r23
	.word 0x862c270b  ! 1: ANDN_I	andn 	%r16, 0x070b, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0x5a, %r31
thr3_loop_cnt_758:
	.word 0xd6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r11
	.word 0xf6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r27
	.word 0xd4c4224c  ! 1: LDSWA_I	ldswa	[%r16, + 0x024c] %asi, %r10
	.word 0xc61423fa  ! 1: LDUH_I	lduh	[%r16 + 0x03fa], %r3
	.word 0xf05c2b10  ! 1: LDX_I	ldx	[%r16 + 0x0b10], %r24
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xc65421c8  ! 1: LDSH_I	ldsh	[%r16 + 0x01c8], %r3
	.word 0xf054277a  ! 1: LDSH_I	ldsh	[%r16 + 0x077a], %r24
	.word 0xc6042510  ! 1: LDUW_I	lduw	[%r16 + 0x0510], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6042184  ! 1: LDUW_I	lduw	[%r16 + 0x0184], %r3
	.word 0xde440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r15
	brnz %r31,thr3_loop_cnt_758
	dec %r31
	.word 0xaa442108  ! 1: ADDC_I	addc 	%r16, 0x0108, %r21
	.word 0x8c442769  ! 1: ADDC_I	addc 	%r16, 0x0769, %r6
	.word 0x9e1c0002  ! 1: XOR_R	xor 	%r16, %r2, %r15
	.word 0x9c0c2e5f  ! 1: AND_I	and 	%r16, 0x0e5f, %r14
        mov 0x2b, %r31
thr3_loop_cnt_759:
	.word 0xd68420a8  ! 1: LDUWA_I	lduwa	[%r16, + 0x00a8] %asi, %r11
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r24
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe4942522  ! 1: LDUHA_I	lduha	[%r16, + 0x0522] %asi, %r18
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc684285c  ! 1: LDUWA_I	lduwa	[%r16, + 0x085c] %asi, %r3
	brnz %r31,thr3_loop_cnt_759
	dec %r31
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0x6f, %r31
thr3_loop_cnt_760:
	.word 0xec941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r22
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6dc26b8  ! 1: LDXA_I	ldxa	[%r16, + 0x06b8] %asi, %r3
	.word 0xd8842434  ! 1: LDUWA_I	lduwa	[%r16, + 0x0434] %asi, %r12
	.word 0xf68c2d31  ! 1: LDUBA_I	lduba	[%r16, + 0x0d31] %asi, %r27
	.word 0xe2d42f98  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f98] %asi, %r17
	.word 0xc6142a5c  ! 1: LDUH_I	lduh	[%r16 + 0x0a5c], %r3
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	.word 0xe20423fc  ! 1: LDUW_I	lduw	[%r16 + 0x03fc], %r17
	.word 0xc644285c  ! 1: LDSW_I	ldsw	[%r16 + 0x085c], %r3
	.word 0xec841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r22
	brnz %r31,thr3_loop_cnt_760
	dec %r31
	.word 0x86142432  ! 1: OR_I	or 	%r16, 0x0432, %r3
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
        mov 0x6, %r31
thr3_loop_cnt_761:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd40c2c7f  ! 1: LDUB_I	ldub	[%r16 + 0x0c7f], %r10
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc65c28a0  ! 1: LDX_I	ldx	[%r16 + 0x08a0], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6c4234c  ! 1: LDSWA_I	ldswa	[%r16, + 0x034c] %asi, %r3
	.word 0xf8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r28
	.word 0xc6142238  ! 1: LDUH_I	lduh	[%r16 + 0x0238], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_761
	dec %r31
	.word 0x901c0002  ! 1: XOR_R	xor 	%r16, %r2, %r8
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0xae3c2814  ! 1: XNOR_I	xnor 	%r16, 0x0814, %r23
        mov 0x28, %r31
thr3_loop_cnt_762:
	.word 0xc6142452  ! 1: LDUH_I	lduh	[%r16 + 0x0452], %r3
	.word 0xda4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r13
	.word 0xc64423b4  ! 1: LDSW_I	ldsw	[%r16 + 0x03b4], %r3
	.word 0xd00c28bd  ! 1: LDUB_I	ldub	[%r16 + 0x08bd], %r8
	.word 0xc6cc2320  ! 1: LDSBA_I	ldsba	[%r16, + 0x0320] %asi, %r3
	.word 0xc68c262a  ! 1: LDUBA_I	lduba	[%r16, + 0x062a] %asi, %r3
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf88c2506  ! 1: LDUBA_I	lduba	[%r16, + 0x0506] %asi, %r28
	brnz %r31,thr3_loop_cnt_762
	dec %r31
	.word 0x933c1002  ! 1: SRAX_R	srax	%r16, %r2, %r9
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0xa6340002  ! 1: SUBC_R	orn 	%r16, %r2, %r19
        mov 0x28, %r31
thr3_loop_cnt_763:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc65c2410  ! 1: LDX_I	ldx	[%r16 + 0x0410], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xfa8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r29
	.word 0xc6542dee  ! 1: LDSH_I	ldsh	[%r16 + 0x0dee], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xee8c2d89  ! 1: LDUBA_I	lduba	[%r16, + 0x0d89] %asi, %r23
	.word 0xc6042494  ! 1: LDUW_I	lduw	[%r16 + 0x0494], %r3
	.word 0xf0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r24
	brnz %r31,thr3_loop_cnt_763
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x900c0002  ! 1: AND_R	and 	%r16, %r2, %r8
	.word 0x8c14244e  ! 1: OR_I	or 	%r16, 0x044e, %r6
        mov 0x95, %r31
thr3_loop_cnt_764:
	.word 0xf68421bc  ! 1: LDUWA_I	lduwa	[%r16, + 0x01bc] %asi, %r27
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xecd429ea  ! 1: LDSHA_I	ldsha	[%r16, + 0x09ea] %asi, %r22
	.word 0xf6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r27
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2898  ! 1: LDXA_I	ldxa	[%r16, + 0x0898] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6442694  ! 1: LDSW_I	ldsw	[%r16 + 0x0694], %r3
	.word 0xc614248e  ! 1: LDUH_I	lduh	[%r16 + 0x048e], %r3
	brnz %r31,thr3_loop_cnt_764
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x9f2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r15
        mov 0x79, %r31
thr3_loop_cnt_765:
	.word 0xc65c2c68  ! 1: LDX_I	ldx	[%r16 + 0x0c68], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xe60c24ae  ! 1: LDUB_I	ldub	[%r16 + 0x04ae], %r19
	.word 0xd4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r10
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf20c25fe  ! 1: LDUB_I	ldub	[%r16 + 0x05fe], %r25
	.word 0xc6cc270b  ! 1: LDSBA_I	ldsba	[%r16, + 0x070b] %asi, %r3
	.word 0xe4cc24ef  ! 1: LDSBA_I	ldsba	[%r16, + 0x04ef] %asi, %r18
	brnz %r31,thr3_loop_cnt_765
	dec %r31
	.word 0x86042cac  ! 1: ADD_I	add 	%r16, 0x0cac, %r3
        mov 0x6b, %r31
thr3_loop_cnt_766:
	.word 0xc604240c  ! 1: LDUW_I	lduw	[%r16 + 0x040c], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc60c27be  ! 1: LDUB_I	ldub	[%r16 + 0x07be], %r3
	.word 0xeacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r21
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xee542b38  ! 1: LDSH_I	ldsh	[%r16 + 0x0b38], %r23
	.word 0xe2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r17
	.word 0xd8942468  ! 1: LDUHA_I	lduha	[%r16, + 0x0468] %asi, %r12
	.word 0xd6842b8c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b8c] %asi, %r11
	.word 0xfa5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r29
	brnz %r31,thr3_loop_cnt_766
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0xb4, %r31
thr3_loop_cnt_767:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xce8c2e17  ! 1: LDUBA_I	lduba	[%r16, + 0x0e17] %asi, %r7
	.word 0xc6dc2fd8  ! 1: LDXA_I	ldxa	[%r16, + 0x0fd8] %asi, %r3
	.word 0xd4dc26a8  ! 1: LDXA_I	ldxa	[%r16, + 0x06a8] %asi, %r10
	.word 0xf4dc2170  ! 1: LDXA_I	ldxa	[%r16, + 0x0170] %asi, %r26
	.word 0xc60c2877  ! 1: LDUB_I	ldub	[%r16 + 0x0877], %r3
	.word 0xfa142df0  ! 1: LDUH_I	lduh	[%r16 + 0x0df0], %r29
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_767
	dec %r31
        mov 0x85, %r31
thr3_loop_cnt_768:
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xe4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r18
	.word 0xe60c2d89  ! 1: LDUB_I	ldub	[%r16 + 0x0d89], %r19
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6542014  ! 1: LDSH_I	ldsh	[%r16 + 0x0014], %r3
	.word 0xf2842410  ! 1: LDUWA_I	lduwa	[%r16, + 0x0410] %asi, %r25
	.word 0xec140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r22
	brnz %r31,thr3_loop_cnt_768
	dec %r31
	.word 0xb82c2645  ! 1: ANDN_I	andn 	%r16, 0x0645, %r28
	.word 0x86442165  ! 1: ADDC_I	addc 	%r16, 0x0165, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x79, %r31
thr3_loop_cnt_769:
	.word 0xd0842474  ! 1: LDUWA_I	lduwa	[%r16, + 0x0474] %asi, %r8
	.word 0xc6142c14  ! 1: LDUH_I	lduh	[%r16 + 0x0c14], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc68c230b  ! 1: LDUBA_I	lduba	[%r16, + 0x030b] %asi, %r3
	.word 0xee040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r23
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc68c29f2  ! 1: LDUBA_I	lduba	[%r16, + 0x09f2] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_769
	dec %r31
	.word 0x95340002  ! 1: SRL_R	srl 	%r16, %r2, %r10
	.word 0xb414298d  ! 1: OR_I	or 	%r16, 0x098d, %r26
	.word 0xb53c1002  ! 1: SRAX_R	srax	%r16, %r2, %r26
        mov 0xc, %r31
thr3_loop_cnt_770:
	.word 0xc6842eac  ! 1: LDUWA_I	lduwa	[%r16, + 0x0eac] %asi, %r3
	.word 0xd0c42910  ! 1: LDSWA_I	ldswa	[%r16, + 0x0910] %asi, %r8
	.word 0xc65c2f58  ! 1: LDX_I	ldx	[%r16 + 0x0f58], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc694279a  ! 1: LDUHA_I	lduha	[%r16, + 0x079a] %asi, %r3
	.word 0xc64c252f  ! 1: LDSB_I	ldsb	[%r16 + 0x052f], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xda9429ee  ! 1: LDUHA_I	lduha	[%r16, + 0x09ee] %asi, %r13
	.word 0xc6442e64  ! 1: LDSW_I	ldsw	[%r16 + 0x0e64], %r3
	.word 0xc6cc28b6  ! 1: LDSBA_I	ldsba	[%r16, + 0x08b6] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_770
	dec %r31
	.word 0x8e240002  ! 1: SUB_R	sub 	%r16, %r2, %r7
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x86042440  ! 1: ADD_I	add 	%r16, 0x0440, %r3
        mov 0x27, %r31
thr3_loop_cnt_771:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xcccc2a0a  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a0a] %asi, %r6
	.word 0xec140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r22
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r12
	.word 0xd494204e  ! 1: LDUHA_I	lduha	[%r16, + 0x004e] %asi, %r10
	.word 0xde142d50  ! 1: LDUH_I	lduh	[%r16 + 0x0d50], %r15
	.word 0xc6c42114  ! 1: LDSWA_I	ldswa	[%r16, + 0x0114] %asi, %r3
	.word 0xc6042654  ! 1: LDUW_I	lduw	[%r16 + 0x0654], %r3
	.word 0xf4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r26
	.word 0xee8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r23
	brnz %r31,thr3_loop_cnt_771
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0xa5, %r31
thr3_loop_cnt_772:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc68426b0  ! 1: LDUWA_I	lduwa	[%r16, + 0x06b0] %asi, %r3
	.word 0xc6d42c82  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c82] %asi, %r3
	.word 0xee8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r23
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xfc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r30
	.word 0xdedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r15
	.word 0xc6042eb4  ! 1: LDUW_I	lduw	[%r16 + 0x0eb4], %r3
	brnz %r31,thr3_loop_cnt_772
	dec %r31
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
        mov 0x24, %r31
thr3_loop_cnt_773:
	.word 0xfa1420fc  ! 1: LDUH_I	lduh	[%r16 + 0x00fc], %r29
	.word 0xcc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r6
	.word 0xd894232a  ! 1: LDUHA_I	lduha	[%r16, + 0x032a] %asi, %r12
	.word 0xea5c2508  ! 1: LDX_I	ldx	[%r16 + 0x0508], %r21
	.word 0xdc8c2eb1  ! 1: LDUBA_I	lduba	[%r16, + 0x0eb1] %asi, %r14
	.word 0xf6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r27
	.word 0xd0cc2761  ! 1: LDSBA_I	ldsba	[%r16, + 0x0761] %asi, %r8
	.word 0xf0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r24
	.word 0xc6442b4c  ! 1: LDSW_I	ldsw	[%r16 + 0x0b4c], %r3
	brnz %r31,thr3_loop_cnt_773
	dec %r31
        mov 0x9f, %r31
thr3_loop_cnt_774:
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xdad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r13
	.word 0xc604230c  ! 1: LDUW_I	lduw	[%r16 + 0x030c], %r3
	.word 0xc60c2c88  ! 1: LDUB_I	ldub	[%r16 + 0x0c88], %r3
	.word 0xdc042650  ! 1: LDUW_I	lduw	[%r16 + 0x0650], %r14
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc65c2e20  ! 1: LDX_I	ldx	[%r16 + 0x0e20], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r19
	.word 0xc68c2a35  ! 1: LDUBA_I	lduba	[%r16, + 0x0a35] %asi, %r3
	.word 0xeccc2b77  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b77] %asi, %r22
	brnz %r31,thr3_loop_cnt_774
	dec %r31
        mov 0x9f, %r31
thr3_loop_cnt_775:
	.word 0xee941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r23
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xf0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r24
	.word 0xc6442340  ! 1: LDSW_I	ldsw	[%r16 + 0x0340], %r3
	.word 0xd88c268e  ! 1: LDUBA_I	lduba	[%r16, + 0x068e] %asi, %r12
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r24
	.word 0xf0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r24
	.word 0xf2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r25
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	brnz %r31,thr3_loop_cnt_775
	dec %r31
	.word 0x8c442378  ! 1: ADDC_I	addc 	%r16, 0x0378, %r6
	.word 0xb61c0002  ! 1: XOR_R	xor 	%r16, %r2, %r27
        mov 0x68, %r31
thr3_loop_cnt_776:
	.word 0xc6dc2b30  ! 1: LDXA_I	ldxa	[%r16, + 0x0b30] %asi, %r3
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	.word 0xfccc2a3a  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a3a] %asi, %r30
	.word 0xe80c2085  ! 1: LDUB_I	ldub	[%r16 + 0x0085], %r20
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xd0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r8
	.word 0xd04c21b6  ! 1: LDSB_I	ldsb	[%r16 + 0x01b6], %r8
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xc6d423e8  ! 1: LDSHA_I	ldsha	[%r16, + 0x03e8] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_776
	dec %r31
	.word 0x86442fec  ! 1: ADDC_I	addc 	%r16, 0x0fec, %r3
        mov 0x79, %r31
thr3_loop_cnt_777:
	.word 0xe8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r20
	.word 0xde84249c  ! 1: LDUWA_I	lduwa	[%r16, + 0x049c] %asi, %r15
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xded42ef4  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ef4] %asi, %r15
	.word 0xda8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r13
	.word 0xc60c2ecd  ! 1: LDUB_I	ldub	[%r16 + 0x0ecd], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xec140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r22
	.word 0xf85c2090  ! 1: LDX_I	ldx	[%r16 + 0x0090], %r28
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_777
	dec %r31
        mov 0x93, %r31
thr3_loop_cnt_778:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xe6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r19
	.word 0xfc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r30
	.word 0xda8c2d19  ! 1: LDUBA_I	lduba	[%r16, + 0x0d19] %asi, %r13
	.word 0xfc4c2121  ! 1: LDSB_I	ldsb	[%r16 + 0x0121], %r30
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_778
	dec %r31
	.word 0x863c2e0a  ! 1: XNOR_I	xnor 	%r16, 0x0e0a, %r3
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x69, %r31
thr3_loop_cnt_779:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6942472  ! 1: LDUHA_I	lduha	[%r16, + 0x0472] %asi, %r3
	.word 0xec440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r22
	.word 0xdad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r13
	.word 0xeedc23b0  ! 1: LDXA_I	ldxa	[%r16, + 0x03b0] %asi, %r23
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe8c42c10  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c10] %asi, %r20
	.word 0xf40427c8  ! 1: LDUW_I	lduw	[%r16 + 0x07c8], %r26
	.word 0xcc042360  ! 1: LDUW_I	lduw	[%r16 + 0x0360], %r6
	.word 0xfa942a32  ! 1: LDUHA_I	lduha	[%r16, + 0x0a32] %asi, %r29
	brnz %r31,thr3_loop_cnt_779
	dec %r31
	.word 0x860c27ac  ! 1: AND_I	and 	%r16, 0x07ac, %r3
	.word 0xbc3424fb  ! 1: SUBC_I	orn 	%r16, 0x04fb, %r30
        mov 0x9d, %r31
thr3_loop_cnt_780:
	.word 0xde0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r15
	.word 0xd4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r10
	.word 0xc64c2893  ! 1: LDSB_I	ldsb	[%r16 + 0x0893], %r3
	.word 0xde040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r15
	.word 0xc60c22cc  ! 1: LDUB_I	ldub	[%r16 + 0x02cc], %r3
	.word 0xc6dc2430  ! 1: LDXA_I	ldxa	[%r16, + 0x0430] %asi, %r3
	.word 0xc6d42170  ! 1: LDSHA_I	ldsha	[%r16, + 0x0170] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_780
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0xa614260b  ! 1: OR_I	or 	%r16, 0x060b, %r19
	.word 0x862c2a4e  ! 1: ANDN_I	andn 	%r16, 0x0a4e, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0xb2, %r31
thr3_loop_cnt_781:
	.word 0xc6d4218a  ! 1: LDSHA_I	ldsha	[%r16, + 0x018a] %asi, %r3
	.word 0xf08c21b2  ! 1: LDUBA_I	lduba	[%r16, + 0x01b2] %asi, %r24
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe24c242d  ! 1: LDSB_I	ldsb	[%r16 + 0x042d], %r17
	.word 0xe24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r17
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_781
	dec %r31
	.word 0xa52c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r18
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0xbb2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r29
	.word 0x862423e9  ! 1: SUB_I	sub 	%r16, 0x03e9, %r3
        mov 0x9e, %r31
thr3_loop_cnt_782:
	.word 0xc68c22fc  ! 1: LDUBA_I	lduba	[%r16, + 0x02fc] %asi, %r3
	.word 0xc68c284b  ! 1: LDUBA_I	lduba	[%r16, + 0x084b] %asi, %r3
	.word 0xf6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r27
	.word 0xee4c29b8  ! 1: LDSB_I	ldsb	[%r16 + 0x09b8], %r23
	.word 0xd25c25e0  ! 1: LDX_I	ldx	[%r16 + 0x05e0], %r9
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r26
	.word 0xe2cc29bf  ! 1: LDSBA_I	ldsba	[%r16, + 0x09bf] %asi, %r17
	brnz %r31,thr3_loop_cnt_782
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x27, %r31
thr3_loop_cnt_783:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6042784  ! 1: LDUW_I	lduw	[%r16 + 0x0784], %r3
	.word 0xfcd421e4  ! 1: LDSHA_I	ldsha	[%r16, + 0x01e4] %asi, %r30
	.word 0xd88c2983  ! 1: LDUBA_I	lduba	[%r16, + 0x0983] %asi, %r12
	.word 0xd05c24b0  ! 1: LDX_I	ldx	[%r16 + 0x04b0], %r8
	.word 0xc6842b98  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b98] %asi, %r3
	.word 0xc6dc21b8  ! 1: LDXA_I	ldxa	[%r16, + 0x01b8] %asi, %r3
	.word 0xcccc295e  ! 1: LDSBA_I	ldsba	[%r16, + 0x095e] %asi, %r6
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_783
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0xc7, %r31
thr3_loop_cnt_784:
	.word 0xf2d428cc  ! 1: LDSHA_I	ldsha	[%r16, + 0x08cc] %asi, %r25
	.word 0xc6942708  ! 1: LDUHA_I	lduha	[%r16, + 0x0708] %asi, %r3
	.word 0xfa8c2f25  ! 1: LDUBA_I	lduba	[%r16, + 0x0f25] %asi, %r29
	.word 0xc65c2568  ! 1: LDX_I	ldx	[%r16 + 0x0568], %r3
	.word 0xc6cc2ec8  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ec8] %asi, %r3
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	.word 0xcedc2368  ! 1: LDXA_I	ldxa	[%r16, + 0x0368] %asi, %r7
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xfc5421b0  ! 1: LDSH_I	ldsh	[%r16 + 0x01b0], %r30
	.word 0xee8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r23
	brnz %r31,thr3_loop_cnt_784
	dec %r31
	.word 0x98440002  ! 1: ADDC_R	addc 	%r16, %r2, %r12
	.word 0x8644278b  ! 1: ADDC_I	addc 	%r16, 0x078b, %r3
        mov 0x72, %r31
thr3_loop_cnt_785:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xc6542df2  ! 1: LDSH_I	ldsh	[%r16 + 0x0df2], %r3
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	.word 0xc614216e  ! 1: LDUH_I	lduh	[%r16 + 0x016e], %r3
	.word 0xc6442c00  ! 1: LDSW_I	ldsw	[%r16 + 0x0c00], %r3
	.word 0xe4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r18
	.word 0xce0c27ef  ! 1: LDUB_I	ldub	[%r16 + 0x07ef], %r7
	brnz %r31,thr3_loop_cnt_785
	dec %r31
	.word 0xa2340002  ! 1: SUBC_R	orn 	%r16, %r2, %r17
	.word 0xa53c0002  ! 1: SRA_R	sra 	%r16, %r2, %r18
	.word 0xa6342eb6  ! 1: SUBC_I	orn 	%r16, 0x0eb6, %r19
        mov 0x68, %r31
thr3_loop_cnt_786:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe40c24de  ! 1: LDUB_I	ldub	[%r16 + 0x04de], %r18
	.word 0xc6dc28f8  ! 1: LDXA_I	ldxa	[%r16, + 0x08f8] %asi, %r3
	.word 0xc6dc25f0  ! 1: LDXA_I	ldxa	[%r16, + 0x05f0] %asi, %r3
	.word 0xf4c42d88  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d88] %asi, %r26
	.word 0xc604266c  ! 1: LDUW_I	lduw	[%r16 + 0x066c], %r3
	.word 0xc64c299d  ! 1: LDSB_I	ldsb	[%r16 + 0x099d], %r3
	brnz %r31,thr3_loop_cnt_786
	dec %r31
	.word 0x953c1002  ! 1: SRAX_R	srax	%r16, %r2, %r10
	.word 0x96140002  ! 1: OR_R	or 	%r16, %r2, %r11
	.word 0x90240002  ! 1: SUB_R	sub 	%r16, %r2, %r8
        mov 0x5e, %r31
thr3_loop_cnt_787:
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xf85c2598  ! 1: LDX_I	ldx	[%r16 + 0x0598], %r28
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6042070  ! 1: LDUW_I	lduw	[%r16 + 0x0070], %r3
	.word 0xc6dc29c8  ! 1: LDXA_I	ldxa	[%r16, + 0x09c8] %asi, %r3
	.word 0xdac4276c  ! 1: LDSWA_I	ldswa	[%r16, + 0x076c] %asi, %r13
	.word 0xda0c2432  ! 1: LDUB_I	ldub	[%r16 + 0x0432], %r13
	.word 0xdc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r14
	.word 0xea94288e  ! 1: LDUHA_I	lduha	[%r16, + 0x088e] %asi, %r21
	brnz %r31,thr3_loop_cnt_787
	dec %r31
	.word 0xa2142190  ! 1: OR_I	or 	%r16, 0x0190, %r17
        mov 0x4c, %r31
thr3_loop_cnt_788:
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	.word 0xe6d421d4  ! 1: LDSHA_I	ldsha	[%r16, + 0x01d4] %asi, %r19
	.word 0xc614265c  ! 1: LDUH_I	lduh	[%r16 + 0x065c], %r3
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xc61426ea  ! 1: LDUH_I	lduh	[%r16 + 0x06ea], %r3
	.word 0xc6cc2d87  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d87] %asi, %r3
	.word 0xc644283c  ! 1: LDSW_I	ldsw	[%r16 + 0x083c], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_788
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0xb0140002  ! 1: OR_R	or 	%r16, %r2, %r24
        mov 0x3f, %r31
thr3_loop_cnt_789:
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	.word 0xc6dc2190  ! 1: LDXA_I	ldxa	[%r16, + 0x0190] %asi, %r3
	.word 0xc6cc2cb7  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cb7] %asi, %r3
	.word 0xd85c2a08  ! 1: LDX_I	ldx	[%r16 + 0x0a08], %r12
	.word 0xe8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r20
	.word 0xd48c21a4  ! 1: LDUBA_I	lduba	[%r16, + 0x01a4] %asi, %r10
	.word 0xde540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r15
	.word 0xc6cc2cc5  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cc5] %asi, %r3
	.word 0xc68c269e  ! 1: LDUBA_I	lduba	[%r16, + 0x069e] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc68423d4  ! 1: LDUWA_I	lduwa	[%r16, + 0x03d4] %asi, %r3
	.word 0xd8d42788  ! 1: LDSHA_I	ldsha	[%r16, + 0x0788] %asi, %r12
	brnz %r31,thr3_loop_cnt_789
	dec %r31
        mov 0x54, %r31
thr3_loop_cnt_790:
	.word 0xecc42104  ! 1: LDSWA_I	ldswa	[%r16, + 0x0104] %asi, %r22
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xfa440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r29
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xf8c42f94  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f94] %asi, %r28
	.word 0xd8dc2498  ! 1: LDXA_I	ldxa	[%r16, + 0x0498] %asi, %r12
	.word 0xcc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r6
	.word 0xda941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r13
	brnz %r31,thr3_loop_cnt_790
	dec %r31
	.word 0x9c2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r14
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0xc3, %r31
thr3_loop_cnt_791:
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xce442fb8  ! 1: LDSW_I	ldsw	[%r16 + 0x0fb8], %r7
	.word 0xc68425d8  ! 1: LDUWA_I	lduwa	[%r16, + 0x05d8] %asi, %r3
	.word 0xde040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r15
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xce9424da  ! 1: LDUHA_I	lduha	[%r16, + 0x04da] %asi, %r7
	.word 0xc6c42144  ! 1: LDSWA_I	ldswa	[%r16, + 0x0144] %asi, %r3
	brnz %r31,thr3_loop_cnt_791
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0xb13c0002  ! 1: SRA_R	sra 	%r16, %r2, %r24
	.word 0xa4140002  ! 1: OR_R	or 	%r16, %r2, %r18
        mov 0x47, %r31
thr3_loop_cnt_792:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xcecc2221  ! 1: LDSBA_I	ldsba	[%r16, + 0x0221] %asi, %r7
	.word 0xc64c2a47  ! 1: LDSB_I	ldsb	[%r16 + 0x0a47], %r3
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xee842748  ! 1: LDUWA_I	lduwa	[%r16, + 0x0748] %asi, %r23
	.word 0xc6042594  ! 1: LDUW_I	lduw	[%r16 + 0x0594], %r3
	.word 0xfadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r29
	.word 0xc6142fda  ! 1: LDUH_I	lduh	[%r16 + 0x0fda], %r3
	brnz %r31,thr3_loop_cnt_792
	dec %r31
        mov 0x2d, %r31
thr3_loop_cnt_793:
	.word 0xea94212a  ! 1: LDUHA_I	lduha	[%r16, + 0x012a] %asi, %r21
	.word 0xec542190  ! 1: LDSH_I	ldsh	[%r16 + 0x0190], %r22
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xdac42c84  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c84] %asi, %r13
	.word 0xc64c24d4  ! 1: LDSB_I	ldsb	[%r16 + 0x04d4], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xde8426d4  ! 1: LDUWA_I	lduwa	[%r16, + 0x06d4] %asi, %r15
	.word 0xcc0c2cd6  ! 1: LDUB_I	ldub	[%r16 + 0x0cd6], %r6
	.word 0xe29428f2  ! 1: LDUHA_I	lduha	[%r16, + 0x08f2] %asi, %r17
	brnz %r31,thr3_loop_cnt_793
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0xa80c0002  ! 1: AND_R	and 	%r16, %r2, %r20
	.word 0x9e242d4d  ! 1: SUB_I	sub 	%r16, 0x0d4d, %r15
        mov 0x37, %r31
thr3_loop_cnt_794:
	.word 0xce4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r7
	.word 0xc614207e  ! 1: LDUH_I	lduh	[%r16 + 0x007e], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd44c2db5  ! 1: LDSB_I	ldsb	[%r16 + 0x0db5], %r10
	.word 0xc65c2f38  ! 1: LDX_I	ldx	[%r16 + 0x0f38], %r3
	.word 0xd40c2919  ! 1: LDUB_I	ldub	[%r16 + 0x0919], %r10
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe80c2678  ! 1: LDUB_I	ldub	[%r16 + 0x0678], %r20
	.word 0xc64428d8  ! 1: LDSW_I	ldsw	[%r16 + 0x08d8], %r3
	.word 0xc6c428dc  ! 1: LDSWA_I	ldswa	[%r16, + 0x08dc] %asi, %r3
	.word 0xf6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r27
	brnz %r31,thr3_loop_cnt_794
	dec %r31
	.word 0x9a240002  ! 1: SUB_R	sub 	%r16, %r2, %r13
        mov 0xb9, %r31
thr3_loop_cnt_795:
	.word 0xe68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r19
	.word 0xc65c2f40  ! 1: LDX_I	ldx	[%r16 + 0x0f40], %r3
	.word 0xf0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r24
	.word 0xfc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r30
	.word 0xc6dc26d8  ! 1: LDXA_I	ldxa	[%r16, + 0x06d8] %asi, %r3
	.word 0xe2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r17
	.word 0xe25c27d0  ! 1: LDX_I	ldx	[%r16 + 0x07d0], %r17
	.word 0xda5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r13
	.word 0xea5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r21
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_795
	dec %r31
	.word 0x864428a9  ! 1: ADDC_I	addc 	%r16, 0x08a9, %r3
	.word 0x9e342864  ! 1: ORN_I	orn 	%r16, 0x0864, %r15
	.word 0x9e340002  ! 1: SUBC_R	orn 	%r16, %r2, %r15
	.word 0x86242216  ! 1: SUB_I	sub 	%r16, 0x0216, %r3
        mov 0x19, %r31
thr3_loop_cnt_796:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xee4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r23
	.word 0xeed41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r23
	.word 0xd08c28e2  ! 1: LDUBA_I	lduba	[%r16, + 0x08e2] %asi, %r8
	.word 0xc6c42054  ! 1: LDSWA_I	ldswa	[%r16, + 0x0054] %asi, %r3
	.word 0xec0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r22
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc65c2f78  ! 1: LDX_I	ldx	[%r16 + 0x0f78], %r3
	.word 0xe60c21fa  ! 1: LDUB_I	ldub	[%r16 + 0x01fa], %r19
	.word 0xc6542a62  ! 1: LDSH_I	ldsh	[%r16 + 0x0a62], %r3
	.word 0xd01423dc  ! 1: LDUH_I	lduh	[%r16 + 0x03dc], %r8
	.word 0xce542248  ! 1: LDSH_I	ldsh	[%r16 + 0x0248], %r7
	brnz %r31,thr3_loop_cnt_796
	dec %r31
        mov 0x4f, %r31
thr3_loop_cnt_797:
	.word 0xc6442d0c  ! 1: LDSW_I	ldsw	[%r16 + 0x0d0c], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc68c2538  ! 1: LDUBA_I	lduba	[%r16, + 0x0538] %asi, %r3
	.word 0xe2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r17
	.word 0xc68c2390  ! 1: LDUBA_I	lduba	[%r16, + 0x0390] %asi, %r3
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xf8dc2158  ! 1: LDXA_I	ldxa	[%r16, + 0x0158] %asi, %r28
	.word 0xc60c2f2d  ! 1: LDUB_I	ldub	[%r16 + 0x0f2d], %r3
	brnz %r31,thr3_loop_cnt_797
	dec %r31
        mov 0x30, %r31
thr3_loop_cnt_798:
	.word 0xc68c200f  ! 1: LDUBA_I	lduba	[%r16, + 0x000f] %asi, %r3
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	.word 0xc6c42f30  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f30] %asi, %r3
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc644299c  ! 1: LDSW_I	ldsw	[%r16 + 0x099c], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xee4c211a  ! 1: LDSB_I	ldsb	[%r16 + 0x011a], %r23
	.word 0xc68c2ef8  ! 1: LDUBA_I	lduba	[%r16, + 0x0ef8] %asi, %r3
	brnz %r31,thr3_loop_cnt_798
	dec %r31
        mov 0x35, %r31
thr3_loop_cnt_799:
	.word 0xecd42d72  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d72] %asi, %r22
	.word 0xd6cc2909  ! 1: LDSBA_I	ldsba	[%r16, + 0x0909] %asi, %r11
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xded424c2  ! 1: LDSHA_I	ldsha	[%r16, + 0x04c2] %asi, %r15
	.word 0xc60c25a9  ! 1: LDUB_I	ldub	[%r16 + 0x05a9], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc61427d8  ! 1: LDUH_I	lduh	[%r16 + 0x07d8], %r3
	brnz %r31,thr3_loop_cnt_799
	dec %r31
	.word 0xbd2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r30
	.word 0x9a2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r13
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x9d3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r14
        mov 0x21, %r31
thr3_loop_cnt_800:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6c42770  ! 1: LDSWA_I	ldswa	[%r16, + 0x0770] %asi, %r3
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xda4421f8  ! 1: LDSW_I	ldsw	[%r16 + 0x01f8], %r13
	.word 0xc6042940  ! 1: LDUW_I	lduw	[%r16 + 0x0940], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc64c23c8  ! 1: LDSB_I	ldsb	[%r16 + 0x03c8], %r3
	.word 0xf04c2ed4  ! 1: LDSB_I	ldsb	[%r16 + 0x0ed4], %r24
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_800
	dec %r31
	.word 0x8624295f  ! 1: SUB_I	sub 	%r16, 0x095f, %r3
	.word 0xab340002  ! 1: SRL_R	srl 	%r16, %r2, %r21
	.word 0xb13c0002  ! 1: SRA_R	sra 	%r16, %r2, %r24
        mov 0xab, %r31
thr3_loop_cnt_801:
	.word 0xdc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r14
	.word 0xce5c2e80  ! 1: LDX_I	ldx	[%r16 + 0x0e80], %r7
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xc6d423ae  ! 1: LDSHA_I	ldsha	[%r16, + 0x03ae] %asi, %r3
	.word 0xecd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r22
	.word 0xc6142480  ! 1: LDUH_I	lduh	[%r16 + 0x0480], %r3
	.word 0xc6042990  ! 1: LDUW_I	lduw	[%r16 + 0x0990], %r3
	.word 0xd4042478  ! 1: LDUW_I	lduw	[%r16 + 0x0478], %r10
	.word 0xc65c26d0  ! 1: LDX_I	ldx	[%r16 + 0x06d0], %r3
	brnz %r31,thr3_loop_cnt_801
	dec %r31
	.word 0xa40c0002  ! 1: AND_R	and 	%r16, %r2, %r18
	.word 0xbc2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r30
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x92, %r31
thr3_loop_cnt_802:
	.word 0xc6142c0e  ! 1: LDUH_I	lduh	[%r16 + 0x0c0e], %r3
	.word 0xc6142756  ! 1: LDUH_I	lduh	[%r16 + 0x0756], %r3
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xc60c2697  ! 1: LDUB_I	ldub	[%r16 + 0x0697], %r3
	.word 0xe4c428e4  ! 1: LDSWA_I	ldswa	[%r16, + 0x08e4] %asi, %r18
	.word 0xf4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r26
	.word 0xc6142d98  ! 1: LDUH_I	lduh	[%r16 + 0x0d98], %r3
	.word 0xc64c2f59  ! 1: LDSB_I	ldsb	[%r16 + 0x0f59], %r3
	.word 0xdc042b90  ! 1: LDUW_I	lduw	[%r16 + 0x0b90], %r14
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r17
	brnz %r31,thr3_loop_cnt_802
	dec %r31
        mov 0x92, %r31
thr3_loop_cnt_803:
	.word 0xf2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r25
	.word 0xc6c42d00  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d00] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6042538  ! 1: LDUW_I	lduw	[%r16 + 0x0538], %r3
	.word 0xde4c29c6  ! 1: LDSB_I	ldsb	[%r16 + 0x09c6], %r15
	.word 0xe4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r18
	.word 0xc6d42744  ! 1: LDSHA_I	ldsha	[%r16, + 0x0744] %asi, %r3
	.word 0xc644224c  ! 1: LDSW_I	ldsw	[%r16 + 0x024c], %r3
	.word 0xe644252c  ! 1: LDSW_I	ldsw	[%r16 + 0x052c], %r19
	.word 0xd2542dfc  ! 1: LDSH_I	ldsh	[%r16 + 0x0dfc], %r9
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd8d42cac  ! 1: LDSHA_I	ldsha	[%r16, + 0x0cac] %asi, %r12
	brnz %r31,thr3_loop_cnt_803
	dec %r31
	.word 0x8e142cc8  ! 1: OR_I	or 	%r16, 0x0cc8, %r7
	.word 0xa83428ff  ! 1: ORN_I	orn 	%r16, 0x08ff, %r20
	.word 0x8d3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r6
        mov 0x74, %r31
thr3_loop_cnt_804:
	.word 0xcc542d0e  ! 1: LDSH_I	ldsh	[%r16 + 0x0d0e], %r6
	.word 0xc61426e4  ! 1: LDUH_I	lduh	[%r16 + 0x06e4], %r3
	.word 0xc6cc2454  ! 1: LDSBA_I	ldsba	[%r16, + 0x0454] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xeacc2bfe  ! 1: LDSBA_I	ldsba	[%r16, + 0x0bfe] %asi, %r21
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	brnz %r31,thr3_loop_cnt_804
	dec %r31
        mov 0x3a, %r31
thr3_loop_cnt_805:
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc644205c  ! 1: LDSW_I	ldsw	[%r16 + 0x005c], %r3
	.word 0xee4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r23
	.word 0xe2d42978  ! 1: LDSHA_I	ldsha	[%r16, + 0x0978] %asi, %r17
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6d42b0a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b0a] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_805
	dec %r31
        mov 0xba, %r31
thr3_loop_cnt_806:
	.word 0xc6442398  ! 1: LDSW_I	ldsw	[%r16 + 0x0398], %r3
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf60c2555  ! 1: LDUB_I	ldub	[%r16 + 0x0555], %r27
	.word 0xc6cc2b70  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b70] %asi, %r3
	.word 0xee8c27e6  ! 1: LDUBA_I	lduba	[%r16, + 0x07e6] %asi, %r23
	.word 0xe44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r18
	.word 0xd2042300  ! 1: LDUW_I	lduw	[%r16 + 0x0300], %r9
	.word 0xcc8c27fd  ! 1: LDUBA_I	lduba	[%r16, + 0x07fd] %asi, %r6
	.word 0xf6842edc  ! 1: LDUWA_I	lduwa	[%r16, + 0x0edc] %asi, %r27
	.word 0xfa941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r29
	.word 0xc61422de  ! 1: LDUH_I	lduh	[%r16 + 0x02de], %r3
	brnz %r31,thr3_loop_cnt_806
	dec %r31
	.word 0xbc2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r30
	.word 0xb6042f5a  ! 1: ADD_I	add 	%r16, 0x0f5a, %r27
	.word 0x983426b3  ! 1: SUBC_I	orn 	%r16, 0x06b3, %r12
	.word 0x8604215e  ! 1: ADD_I	add 	%r16, 0x015e, %r3
        mov 0xb4, %r31
thr3_loop_cnt_807:
	.word 0xfac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r29
	.word 0xdc8c220e  ! 1: LDUBA_I	lduba	[%r16, + 0x020e] %asi, %r14
	.word 0xce941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r7
	.word 0xee941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r23
	.word 0xc65c2e38  ! 1: LDX_I	ldx	[%r16 + 0x0e38], %r3
	.word 0xf4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r26
	.word 0xf24c2977  ! 1: LDSB_I	ldsb	[%r16 + 0x0977], %r25
	.word 0xf4842440  ! 1: LDUWA_I	lduwa	[%r16, + 0x0440] %asi, %r26
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	.word 0xcc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r6
	.word 0xfc042cfc  ! 1: LDUW_I	lduw	[%r16 + 0x0cfc], %r30
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_807
	dec %r31
	.word 0x9f2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r15
	.word 0xb53c1002  ! 1: SRAX_R	srax	%r16, %r2, %r26
        mov 0xac, %r31
thr3_loop_cnt_808:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r24
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc644240c  ! 1: LDSW_I	ldsw	[%r16 + 0x040c], %r3
	.word 0xc68c2c54  ! 1: LDUBA_I	lduba	[%r16, + 0x0c54] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r27
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc694223a  ! 1: LDUHA_I	lduha	[%r16, + 0x023a] %asi, %r3
	brnz %r31,thr3_loop_cnt_808
	dec %r31
	.word 0xba440002  ! 1: ADDC_R	addc 	%r16, %r2, %r29
        mov 0x1f, %r31
thr3_loop_cnt_809:
	.word 0xf2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r25
	.word 0xc6c42bb4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0bb4] %asi, %r3
	.word 0xc6442490  ! 1: LDSW_I	ldsw	[%r16 + 0x0490], %r3
	.word 0xc6142cce  ! 1: LDUH_I	lduh	[%r16 + 0x0cce], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xe64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r19
	.word 0xec5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r22
	.word 0xc6042100  ! 1: LDUW_I	lduw	[%r16 + 0x0100], %r3
	.word 0xe6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r19
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_809
	dec %r31
	.word 0xaa1c2ce4  ! 1: XOR_I	xor 	%r16, 0x0ce4, %r21
	.word 0x861c2245  ! 1: XOR_I	xor 	%r16, 0x0245, %r3
	.word 0x863422db  ! 1: ORN_I	orn 	%r16, 0x02db, %r3
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0x8, %r31
thr3_loop_cnt_810:
	.word 0xced41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r7
	.word 0xc6142172  ! 1: LDUH_I	lduh	[%r16 + 0x0172], %r3
	.word 0xd2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r9
	.word 0xd4542248  ! 1: LDSH_I	ldsh	[%r16 + 0x0248], %r10
	.word 0xfa4422e0  ! 1: LDSW_I	ldsw	[%r16 + 0x02e0], %r29
	.word 0xcc4c23d6  ! 1: LDSB_I	ldsb	[%r16 + 0x03d6], %r6
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xce941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r7
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_810
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x31, %r31
thr3_loop_cnt_811:
	.word 0xdedc27b8  ! 1: LDXA_I	ldxa	[%r16, + 0x07b8] %asi, %r15
	.word 0xc6d424d0  ! 1: LDSHA_I	ldsha	[%r16, + 0x04d0] %asi, %r3
	.word 0xcc4c2121  ! 1: LDSB_I	ldsb	[%r16 + 0x0121], %r6
	.word 0xda442b0c  ! 1: LDSW_I	ldsw	[%r16 + 0x0b0c], %r13
	.word 0xc6cc2a16  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a16] %asi, %r3
	.word 0xeacc2e70  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e70] %asi, %r21
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc64c2f61  ! 1: LDSB_I	ldsb	[%r16 + 0x0f61], %r3
	.word 0xd4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r10
	brnz %r31,thr3_loop_cnt_811
	dec %r31
	.word 0x860c294f  ! 1: AND_I	and 	%r16, 0x094f, %r3
	.word 0x8e340002  ! 1: SUBC_R	orn 	%r16, %r2, %r7
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x9c, %r31
thr3_loop_cnt_812:
	.word 0xc6dc29a0  ! 1: LDXA_I	ldxa	[%r16, + 0x09a0] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xea8c294c  ! 1: LDUBA_I	lduba	[%r16, + 0x094c] %asi, %r21
	.word 0xc65c28c8  ! 1: LDX_I	ldx	[%r16 + 0x08c8], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r26
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xe6c429e8  ! 1: LDSWA_I	ldswa	[%r16, + 0x09e8] %asi, %r19
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_812
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0xbb2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r29
	.word 0xa80c0002  ! 1: AND_R	and 	%r16, %r2, %r20
        mov 0x50, %r31
thr3_loop_cnt_813:
	.word 0xc6842fa4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0fa4] %asi, %r3
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	.word 0xd2542cdc  ! 1: LDSH_I	ldsh	[%r16 + 0x0cdc], %r9
	.word 0xc65c26b8  ! 1: LDX_I	ldx	[%r16 + 0x06b8], %r3
	.word 0xd0142634  ! 1: LDUH_I	lduh	[%r16 + 0x0634], %r8
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6dc2440  ! 1: LDXA_I	ldxa	[%r16, + 0x0440] %asi, %r3
	.word 0xc6042c9c  ! 1: LDUW_I	lduw	[%r16 + 0x0c9c], %r3
	.word 0xc60c2400  ! 1: LDUB_I	ldub	[%r16 + 0x0400], %r3
	.word 0xc65c21a0  ! 1: LDX_I	ldx	[%r16 + 0x01a0], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_813
	dec %r31
	.word 0xb014204d  ! 1: OR_I	or 	%r16, 0x004d, %r24
	.word 0x86342ddb  ! 1: SUBC_I	orn 	%r16, 0x0ddb, %r3
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x8d341002  ! 1: SRLX_R	srlx	%r16, %r2, %r6
        mov 0x3d, %r31
thr3_loop_cnt_814:
	.word 0xc6cc2c07  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c07] %asi, %r3
	.word 0xfc0c2374  ! 1: LDUB_I	ldub	[%r16 + 0x0374], %r30
	.word 0xe4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r18
	.word 0xea942c78  ! 1: LDUHA_I	lduha	[%r16, + 0x0c78] %asi, %r21
	.word 0xda0c2c7a  ! 1: LDUB_I	ldub	[%r16 + 0x0c7a], %r13
	.word 0xea5c2d48  ! 1: LDX_I	ldx	[%r16 + 0x0d48], %r21
	.word 0xc68423f4  ! 1: LDUWA_I	lduwa	[%r16, + 0x03f4] %asi, %r3
	.word 0xc64c243e  ! 1: LDSB_I	ldsb	[%r16 + 0x043e], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf2442038  ! 1: LDSW_I	ldsw	[%r16 + 0x0038], %r25
	.word 0xc61425b0  ! 1: LDUH_I	lduh	[%r16 + 0x05b0], %r3
	brnz %r31,thr3_loop_cnt_814
	dec %r31
	.word 0xab342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r21
	.word 0x8e0c0002  ! 1: AND_R	and 	%r16, %r2, %r7
        mov 0x2f, %r31
thr3_loop_cnt_815:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe68c25cb  ! 1: LDUBA_I	lduba	[%r16, + 0x05cb] %asi, %r19
	.word 0xc604235c  ! 1: LDUW_I	lduw	[%r16 + 0x035c], %r3
	.word 0xd0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r8
	.word 0xf65428f4  ! 1: LDSH_I	ldsh	[%r16 + 0x08f4], %r27
	.word 0xce842864  ! 1: LDUWA_I	lduwa	[%r16, + 0x0864] %asi, %r7
	.word 0xd4942fd2  ! 1: LDUHA_I	lduha	[%r16, + 0x0fd2] %asi, %r10
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_815
	dec %r31
	.word 0x8644254f  ! 1: ADDC_I	addc 	%r16, 0x054f, %r3
        mov 0x3, %r31
thr3_loop_cnt_816:
	.word 0xda4c2a5f  ! 1: LDSB_I	ldsb	[%r16 + 0x0a5f], %r13
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xc6042788  ! 1: LDUW_I	lduw	[%r16 + 0x0788], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6042160  ! 1: LDUW_I	lduw	[%r16 + 0x0160], %r3
	.word 0xc6cc2035  ! 1: LDSBA_I	ldsba	[%r16, + 0x0035] %asi, %r3
	.word 0xecd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r22
	.word 0xc6142e02  ! 1: LDUH_I	lduh	[%r16 + 0x0e02], %r3
	brnz %r31,thr3_loop_cnt_816
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x863c2e37  ! 1: XNOR_I	xnor 	%r16, 0x0e37, %r3
        mov 0x70, %r31
thr3_loop_cnt_817:
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xda0c2709  ! 1: LDUB_I	ldub	[%r16 + 0x0709], %r13
	.word 0xc65c2ea0  ! 1: LDX_I	ldx	[%r16 + 0x0ea0], %r3
	.word 0xc6042668  ! 1: LDUW_I	lduw	[%r16 + 0x0668], %r3
	.word 0xe4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r18
	.word 0xc6cc2e35  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e35] %asi, %r3
	.word 0xc6c42288  ! 1: LDSWA_I	ldswa	[%r16, + 0x0288] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd0542e2a  ! 1: LDSH_I	ldsh	[%r16 + 0x0e2a], %r8
	.word 0xea4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r21
	brnz %r31,thr3_loop_cnt_817
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0xe, %r31
thr3_loop_cnt_818:
	.word 0xf8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r28
	.word 0xd08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r8
	.word 0xc654208a  ! 1: LDSH_I	ldsh	[%r16 + 0x008a], %r3
	.word 0xe2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r17
	.word 0xd0c42df4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0df4] %asi, %r8
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	.word 0xd80c2ff8  ! 1: LDUB_I	ldub	[%r16 + 0x0ff8], %r12
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6142b86  ! 1: LDUH_I	lduh	[%r16 + 0x0b86], %r3
	.word 0xd48c2714  ! 1: LDUBA_I	lduba	[%r16, + 0x0714] %asi, %r10
	brnz %r31,thr3_loop_cnt_818
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x86142a73  ! 1: OR_I	or 	%r16, 0x0a73, %r3
        mov 0x49, %r31
thr3_loop_cnt_819:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6042300  ! 1: LDUW_I	lduw	[%r16 + 0x0300], %r3
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	.word 0xc60c2357  ! 1: LDUB_I	ldub	[%r16 + 0x0357], %r3
	.word 0xf28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r25
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	.word 0xc6542874  ! 1: LDSH_I	ldsh	[%r16 + 0x0874], %r3
	.word 0xc69421da  ! 1: LDUHA_I	lduha	[%r16, + 0x01da] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6842778  ! 1: LDUWA_I	lduwa	[%r16, + 0x0778] %asi, %r3
	.word 0xc6dc2ff0  ! 1: LDXA_I	ldxa	[%r16, + 0x0ff0] %asi, %r3
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	brnz %r31,thr3_loop_cnt_819
	dec %r31
        mov 0x82, %r31
thr3_loop_cnt_820:
	.word 0xc6c423b0  ! 1: LDSWA_I	ldswa	[%r16, + 0x03b0] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd4dc2220  ! 1: LDXA_I	ldxa	[%r16, + 0x0220] %asi, %r10
	.word 0xda841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r13
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd4842c48  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c48] %asi, %r10
	.word 0xd2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r9
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_820
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x860c2cb3  ! 1: AND_I	and 	%r16, 0x0cb3, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x9b, %r31
thr3_loop_cnt_821:
	.word 0xd2142c8e  ! 1: LDUH_I	lduh	[%r16 + 0x0c8e], %r9
	.word 0xe64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r19
	.word 0xc6c42460  ! 1: LDSWA_I	ldswa	[%r16, + 0x0460] %asi, %r3
	.word 0xc6cc2878  ! 1: LDSBA_I	ldsba	[%r16, + 0x0878] %asi, %r3
	.word 0xfacc2ada  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ada] %asi, %r29
	.word 0xc65c2c78  ! 1: LDX_I	ldx	[%r16 + 0x0c78], %r3
	.word 0xdecc2bb8  ! 1: LDSBA_I	ldsba	[%r16, + 0x0bb8] %asi, %r15
	.word 0xf6942464  ! 1: LDUHA_I	lduha	[%r16, + 0x0464] %asi, %r27
	brnz %r31,thr3_loop_cnt_821
	dec %r31
        mov 0x56, %r31
thr3_loop_cnt_822:
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r12
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xee5c2778  ! 1: LDX_I	ldx	[%r16 + 0x0778], %r23
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6442730  ! 1: LDSW_I	ldsw	[%r16 + 0x0730], %r3
	.word 0xc6542aa0  ! 1: LDSH_I	ldsh	[%r16 + 0x0aa0], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	brnz %r31,thr3_loop_cnt_822
	dec %r31
	.word 0xb7341002  ! 1: SRLX_R	srlx	%r16, %r2, %r27
	.word 0xae140002  ! 1: OR_R	or 	%r16, %r2, %r23
	.word 0xa33c1002  ! 1: SRAX_R	srax	%r16, %r2, %r17
        mov 0x0, %r31
thr3_loop_cnt_823:
	.word 0xf6cc24b8  ! 1: LDSBA_I	ldsba	[%r16, + 0x04b8] %asi, %r27
	.word 0xf8d424e2  ! 1: LDSHA_I	ldsha	[%r16, + 0x04e2] %asi, %r28
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc60c2910  ! 1: LDUB_I	ldub	[%r16 + 0x0910], %r3
	.word 0xc68c245a  ! 1: LDUBA_I	lduba	[%r16, + 0x045a] %asi, %r3
	.word 0xcc142b90  ! 1: LDUH_I	lduh	[%r16 + 0x0b90], %r6
	.word 0xc6442980  ! 1: LDSW_I	ldsw	[%r16 + 0x0980], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf0cc2bc9  ! 1: LDSBA_I	ldsba	[%r16, + 0x0bc9] %asi, %r24
	.word 0xe6942206  ! 1: LDUHA_I	lduha	[%r16, + 0x0206] %asi, %r19
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r27
	brnz %r31,thr3_loop_cnt_823
	dec %r31
	.word 0x97340002  ! 1: SRL_R	srl 	%r16, %r2, %r11
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0xae, %r31
thr3_loop_cnt_824:
	.word 0xdec421e0  ! 1: LDSWA_I	ldswa	[%r16, + 0x01e0] %asi, %r15
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xce142672  ! 1: LDUH_I	lduh	[%r16 + 0x0672], %r7
	.word 0xccc425a8  ! 1: LDSWA_I	ldswa	[%r16, + 0x05a8] %asi, %r6
	.word 0xf64c2594  ! 1: LDSB_I	ldsb	[%r16 + 0x0594], %r27
	.word 0xecc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r22
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd00c2ba8  ! 1: LDUB_I	ldub	[%r16 + 0x0ba8], %r8
	.word 0xc6042620  ! 1: LDUW_I	lduw	[%r16 + 0x0620], %r3
	.word 0xf6dc2540  ! 1: LDXA_I	ldxa	[%r16, + 0x0540] %asi, %r27
	.word 0xce040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r7
	brnz %r31,thr3_loop_cnt_824
	dec %r31
	.word 0x9a240002  ! 1: SUB_R	sub 	%r16, %r2, %r13
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x3, %r31
thr3_loop_cnt_825:
	.word 0xd08c2983  ! 1: LDUBA_I	lduba	[%r16, + 0x0983] %asi, %r8
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xcc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r6
	.word 0xd4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r10
	.word 0xc6942b70  ! 1: LDUHA_I	lduha	[%r16, + 0x0b70] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd0d426f8  ! 1: LDSHA_I	ldsha	[%r16, + 0x06f8] %asi, %r8
	.word 0xc64c2073  ! 1: LDSB_I	ldsb	[%r16 + 0x0073], %r3
	.word 0xeadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r21
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xfa140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r29
	brnz %r31,thr3_loop_cnt_825
	dec %r31
	.word 0xbc2427d1  ! 1: SUB_I	sub 	%r16, 0x07d1, %r30
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0xa72c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r19
        mov 0xc5, %r31
thr3_loop_cnt_826:
	.word 0xc6d4282a  ! 1: LDSHA_I	ldsha	[%r16, + 0x082a] %asi, %r3
	.word 0xd6042b3c  ! 1: LDUW_I	lduw	[%r16 + 0x0b3c], %r11
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xde14271c  ! 1: LDUH_I	lduh	[%r16 + 0x071c], %r15
	.word 0xe2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r17
	.word 0xc60c2b2d  ! 1: LDUB_I	ldub	[%r16 + 0x0b2d], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_826
	dec %r31
	.word 0x860c27f9  ! 1: AND_I	and 	%r16, 0x07f9, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x44, %r31
thr3_loop_cnt_827:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r25
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6c42d94  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d94] %asi, %r3
	.word 0xda841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r13
	.word 0xd2542d3e  ! 1: LDSH_I	ldsh	[%r16 + 0x0d3e], %r9
	.word 0xecdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r22
	.word 0xf214213c  ! 1: LDUH_I	lduh	[%r16 + 0x013c], %r25
	brnz %r31,thr3_loop_cnt_827
	dec %r31
	.word 0x862428d2  ! 1: SUB_I	sub 	%r16, 0x08d2, %r3
	.word 0x940c20ec  ! 1: AND_I	and 	%r16, 0x00ec, %r10
        mov 0x5, %r31
thr3_loop_cnt_828:
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xec140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r22
	.word 0xc6942166  ! 1: LDUHA_I	lduha	[%r16, + 0x0166] %asi, %r3
	.word 0xe68c2b8c  ! 1: LDUBA_I	lduba	[%r16, + 0x0b8c] %asi, %r19
	.word 0xc6dc23a0  ! 1: LDXA_I	ldxa	[%r16, + 0x03a0] %asi, %r3
	.word 0xc64c219a  ! 1: LDSB_I	ldsb	[%r16 + 0x019a], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd8942a50  ! 1: LDUHA_I	lduha	[%r16, + 0x0a50] %asi, %r12
	brnz %r31,thr3_loop_cnt_828
	dec %r31
	.word 0x942c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r10
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x96442d8d  ! 1: ADDC_I	addc 	%r16, 0x0d8d, %r11
        mov 0x99, %r31
thr3_loop_cnt_829:
	.word 0xd85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r12
	.word 0xec540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r22
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe4042100  ! 1: LDUW_I	lduw	[%r16 + 0x0100], %r18
	.word 0xec540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r22
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6442844  ! 1: LDSW_I	ldsw	[%r16 + 0x0844], %r3
	.word 0xc6542fa2  ! 1: LDSH_I	ldsh	[%r16 + 0x0fa2], %r3
	.word 0xe88c2f27  ! 1: LDUBA_I	lduba	[%r16, + 0x0f27] %asi, %r20
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xdad4283a  ! 1: LDSHA_I	ldsha	[%r16, + 0x083a] %asi, %r13
	brnz %r31,thr3_loop_cnt_829
	dec %r31
	.word 0xb2442036  ! 1: ADDC_I	addc 	%r16, 0x0036, %r25
	.word 0x9a440002  ! 1: ADDC_R	addc 	%r16, %r2, %r13
        mov 0x53, %r31
thr3_loop_cnt_830:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c4224c  ! 1: LDSWA_I	ldswa	[%r16, + 0x024c] %asi, %r3
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xee94235e  ! 1: LDUHA_I	lduha	[%r16, + 0x035e] %asi, %r23
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	brnz %r31,thr3_loop_cnt_830
	dec %r31
	.word 0x862c2ab5  ! 1: ANDN_I	andn 	%r16, 0x0ab5, %r3
	.word 0xaf3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r23
        mov 0x11, %r31
thr3_loop_cnt_831:
	.word 0xc6c42774  ! 1: LDSWA_I	ldswa	[%r16, + 0x0774] %asi, %r3
	.word 0xd40c217f  ! 1: LDUB_I	ldub	[%r16 + 0x017f], %r10
	.word 0xf4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r26
	.word 0xfa8c284e  ! 1: LDUBA_I	lduba	[%r16, + 0x084e] %asi, %r29
	.word 0xc6142ade  ! 1: LDUH_I	lduh	[%r16 + 0x0ade], %r3
	.word 0xf0c420e8  ! 1: LDSWA_I	ldswa	[%r16, + 0x00e8] %asi, %r24
	.word 0xfac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r29
	.word 0xd48422d0  ! 1: LDUWA_I	lduwa	[%r16, + 0x02d0] %asi, %r10
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_831
	dec %r31
	.word 0xa7343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r19
        mov 0xb8, %r31
thr3_loop_cnt_832:
	.word 0xccdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r6
	.word 0xf8142e86  ! 1: LDUH_I	lduh	[%r16 + 0x0e86], %r28
	.word 0xfadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r29
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r8
	.word 0xc68425c4  ! 1: LDUWA_I	lduwa	[%r16, + 0x05c4] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6942d50  ! 1: LDUHA_I	lduha	[%r16, + 0x0d50] %asi, %r3
	.word 0xf8dc28c0  ! 1: LDXA_I	ldxa	[%r16, + 0x08c0] %asi, %r28
	.word 0xe84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r20
	.word 0xc64c2198  ! 1: LDSB_I	ldsb	[%r16 + 0x0198], %r3
	brnz %r31,thr3_loop_cnt_832
	dec %r31
        mov 0xb0, %r31
thr3_loop_cnt_833:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xda14238e  ! 1: LDUH_I	lduh	[%r16 + 0x038e], %r13
	.word 0xf80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r28
	.word 0xc64c2f63  ! 1: LDSB_I	ldsb	[%r16 + 0x0f63], %r3
	.word 0xc6dc2f38  ! 1: LDXA_I	ldxa	[%r16, + 0x0f38] %asi, %r3
	.word 0xc6cc2c90  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c90] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xe4d42ee6  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ee6] %asi, %r18
	brnz %r31,thr3_loop_cnt_833
	dec %r31
	.word 0xba1c2b6c  ! 1: XOR_I	xor 	%r16, 0x0b6c, %r29
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x8d343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r6
        mov 0x70, %r31
thr3_loop_cnt_834:
	.word 0xc6d428d4  ! 1: LDSHA_I	ldsha	[%r16, + 0x08d4] %asi, %r3
	.word 0xf64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r27
	.word 0xd2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r9
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf40c2b3f  ! 1: LDUB_I	ldub	[%r16 + 0x0b3f], %r26
	.word 0xda4c266b  ! 1: LDSB_I	ldsb	[%r16 + 0x066b], %r13
	.word 0xec042710  ! 1: LDUW_I	lduw	[%r16 + 0x0710], %r22
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc60c260d  ! 1: LDUB_I	ldub	[%r16 + 0x060d], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xfacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r29
	brnz %r31,thr3_loop_cnt_834
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x86142d4b  ! 1: OR_I	or 	%r16, 0x0d4b, %r3
	.word 0xb7341002  ! 1: SRLX_R	srlx	%r16, %r2, %r27
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0xa1, %r31
thr3_loop_cnt_835:
	.word 0xe8cc27f2  ! 1: LDSBA_I	ldsba	[%r16, + 0x07f2] %asi, %r20
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc65c20e0  ! 1: LDX_I	ldx	[%r16 + 0x00e0], %r3
	.word 0xc65c2e08  ! 1: LDX_I	ldx	[%r16 + 0x0e08], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd6442418  ! 1: LDSW_I	ldsw	[%r16 + 0x0418], %r11
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xc6cc2621  ! 1: LDSBA_I	ldsba	[%r16, + 0x0621] %asi, %r3
	.word 0xc6942f54  ! 1: LDUHA_I	lduha	[%r16, + 0x0f54] %asi, %r3
	brnz %r31,thr3_loop_cnt_835
	dec %r31
        mov 0xf, %r31
thr3_loop_cnt_836:
	.word 0xc69422b4  ! 1: LDUHA_I	lduha	[%r16, + 0x02b4] %asi, %r3
	.word 0xfc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r30
	.word 0xf4c42ff4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ff4] %asi, %r26
	.word 0xeed4281a  ! 1: LDSHA_I	ldsha	[%r16, + 0x081a] %asi, %r23
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6142b1a  ! 1: LDUH_I	lduh	[%r16 + 0x0b1a], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	.word 0xcedc2d18  ! 1: LDXA_I	ldxa	[%r16, + 0x0d18] %asi, %r7
	brnz %r31,thr3_loop_cnt_836
	dec %r31
	.word 0xb93c1002  ! 1: SRAX_R	srax	%r16, %r2, %r28
	.word 0x9f343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r15
	.word 0xad2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r22
        mov 0x8d, %r31
thr3_loop_cnt_837:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xeadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r21
	.word 0xe8c42aec  ! 1: LDSWA_I	ldswa	[%r16, + 0x0aec] %asi, %r20
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xdecc24f3  ! 1: LDSBA_I	ldsba	[%r16, + 0x04f3] %asi, %r15
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_837
	dec %r31
        mov 0x9d, %r31
thr3_loop_cnt_838:
	.word 0xfcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r30
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r26
	.word 0xc6442f6c  ! 1: LDSW_I	ldsw	[%r16 + 0x0f6c], %r3
	.word 0xcc042ac8  ! 1: LDUW_I	lduw	[%r16 + 0x0ac8], %r6
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xda0420dc  ! 1: LDUW_I	lduw	[%r16 + 0x00dc], %r13
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc61422a2  ! 1: LDUH_I	lduh	[%r16 + 0x02a2], %r3
	brnz %r31,thr3_loop_cnt_838
	dec %r31
	.word 0x8d340002  ! 1: SRL_R	srl 	%r16, %r2, %r6
	.word 0xad3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r22
	.word 0xa4342714  ! 1: SUBC_I	orn 	%r16, 0x0714, %r18
        mov 0xb3, %r31
thr3_loop_cnt_839:
	.word 0xce040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r7
	.word 0xccd4259e  ! 1: LDSHA_I	ldsha	[%r16, + 0x059e] %asi, %r6
	.word 0xf44c2de5  ! 1: LDSB_I	ldsb	[%r16 + 0x0de5], %r26
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xda941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r13
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xc60424dc  ! 1: LDUW_I	lduw	[%r16 + 0x04dc], %r3
	.word 0xc65c2298  ! 1: LDX_I	ldx	[%r16 + 0x0298], %r3
	brnz %r31,thr3_loop_cnt_839
	dec %r31
	.word 0xba3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r29
	.word 0xab3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r21
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0x21, %r31
thr3_loop_cnt_840:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xfa842798  ! 1: LDUWA_I	lduwa	[%r16, + 0x0798] %asi, %r29
	.word 0xc6cc2fb6  ! 1: LDSBA_I	ldsba	[%r16, + 0x0fb6] %asi, %r3
	.word 0xf0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r24
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xcc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r6
	.word 0xc6142b60  ! 1: LDUH_I	lduh	[%r16 + 0x0b60], %r3
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r27
	brnz %r31,thr3_loop_cnt_840
	dec %r31
        mov 0x2, %r31
thr3_loop_cnt_841:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe64c24d9  ! 1: LDSB_I	ldsb	[%r16 + 0x04d9], %r19
	.word 0xf4d42c4c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c4c] %asi, %r26
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xced41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r7
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	.word 0xf4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r26
	.word 0xc6042f90  ! 1: LDUW_I	lduw	[%r16 + 0x0f90], %r3
	.word 0xf2942d0c  ! 1: LDUHA_I	lduha	[%r16, + 0x0d0c] %asi, %r25
	.word 0xc6cc2349  ! 1: LDSBA_I	ldsba	[%r16, + 0x0349] %asi, %r3
	.word 0xd2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r9
	brnz %r31,thr3_loop_cnt_841
	dec %r31
	.word 0x860c2238  ! 1: AND_I	and 	%r16, 0x0238, %r3
        mov 0x49, %r31
thr3_loop_cnt_842:
	.word 0xcc042f0c  ! 1: LDUW_I	lduw	[%r16 + 0x0f0c], %r6
	.word 0xc6942346  ! 1: LDUHA_I	lduha	[%r16, + 0x0346] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xdedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r15
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe8442cb4  ! 1: LDSW_I	ldsw	[%r16 + 0x0cb4], %r20
	.word 0xc6842970  ! 1: LDUWA_I	lduwa	[%r16, + 0x0970] %asi, %r3
	.word 0xc68c227f  ! 1: LDUBA_I	lduba	[%r16, + 0x027f] %asi, %r3
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc69429bc  ! 1: LDUHA_I	lduha	[%r16, + 0x09bc] %asi, %r3
	brnz %r31,thr3_loop_cnt_842
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x9c342466  ! 1: ORN_I	orn 	%r16, 0x0466, %r14
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0x9a, %r31
thr3_loop_cnt_843:
	.word 0xc6cc20b0  ! 1: LDSBA_I	ldsba	[%r16, + 0x00b0] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf60c203a  ! 1: LDUB_I	ldub	[%r16 + 0x003a], %r27
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	.word 0xc6142d1e  ! 1: LDUH_I	lduh	[%r16 + 0x0d1e], %r3
	.word 0xe2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r17
	brnz %r31,thr3_loop_cnt_843
	dec %r31
        mov 0x9f, %r31
thr3_loop_cnt_844:
	.word 0xc6942988  ! 1: LDUHA_I	lduha	[%r16, + 0x0988] %asi, %r3
	.word 0xce5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r7
	.word 0xe6442c08  ! 1: LDSW_I	ldsw	[%r16 + 0x0c08], %r19
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6042538  ! 1: LDUW_I	lduw	[%r16 + 0x0538], %r3
	.word 0xe28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r17
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd0c42cf0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0cf0] %asi, %r8
	.word 0xfa440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r29
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_844
	dec %r31
	.word 0xac442d7a  ! 1: ADDC_I	addc 	%r16, 0x0d7a, %r22
        mov 0x51, %r31
thr3_loop_cnt_845:
	.word 0xc6dc2b98  ! 1: LDXA_I	ldxa	[%r16, + 0x0b98] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r19
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r25
	.word 0xc6c4275c  ! 1: LDSWA_I	ldswa	[%r16, + 0x075c] %asi, %r3
	.word 0xd8442f34  ! 1: LDSW_I	ldsw	[%r16 + 0x0f34], %r12
	.word 0xfc5c2918  ! 1: LDX_I	ldx	[%r16 + 0x0918], %r30
	brnz %r31,thr3_loop_cnt_845
	dec %r31
	.word 0x8c2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r6
	.word 0x980c0002  ! 1: AND_R	and 	%r16, %r2, %r12
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0xd, %r31
thr3_loop_cnt_846:
	.word 0xfacc24c2  ! 1: LDSBA_I	ldsba	[%r16, + 0x04c2] %asi, %r29
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xc6dc23e0  ! 1: LDXA_I	ldxa	[%r16, + 0x03e0] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe614284c  ! 1: LDUH_I	lduh	[%r16 + 0x084c], %r19
	.word 0xfad42a7c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a7c] %asi, %r29
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	brnz %r31,thr3_loop_cnt_846
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0xba0c22b4  ! 1: AND_I	and 	%r16, 0x02b4, %r29
	.word 0x8f341002  ! 1: SRLX_R	srlx	%r16, %r2, %r7
	.word 0xb00c0002  ! 1: AND_R	and 	%r16, %r2, %r24
        mov 0x3f, %r31
thr3_loop_cnt_847:
	.word 0xda542e18  ! 1: LDSH_I	ldsh	[%r16 + 0x0e18], %r13
	.word 0xc684287c  ! 1: LDUWA_I	lduwa	[%r16, + 0x087c] %asi, %r3
	.word 0xe28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r17
	.word 0xc6542172  ! 1: LDSH_I	ldsh	[%r16 + 0x0172], %r3
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xc6842264  ! 1: LDUWA_I	lduwa	[%r16, + 0x0264] %asi, %r3
	.word 0xc6542dcc  ! 1: LDSH_I	ldsh	[%r16 + 0x0dcc], %r3
	.word 0xfa841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r29
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xde5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r15
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_847
	dec %r31
	.word 0x861c2a6b  ! 1: XOR_I	xor 	%r16, 0x0a6b, %r3
        mov 0x2d, %r31
thr3_loop_cnt_848:
	.word 0xd45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r10
	.word 0xfc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r30
	.word 0xf6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r27
	.word 0xc6dc25a8  ! 1: LDXA_I	ldxa	[%r16, + 0x05a8] %asi, %r3
	.word 0xc6d42f8c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f8c] %asi, %r3
	.word 0xc6442158  ! 1: LDSW_I	ldsw	[%r16 + 0x0158], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc64c2a30  ! 1: LDSB_I	ldsb	[%r16 + 0x0a30], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_848
	dec %r31
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x86442a86  ! 1: ADDC_I	addc 	%r16, 0x0a86, %r3
	.word 0xb3341002  ! 1: SRLX_R	srlx	%r16, %r2, %r25
        mov 0x2, %r31
thr3_loop_cnt_849:
	.word 0xc65c2a08  ! 1: LDX_I	ldx	[%r16 + 0x0a08], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r26
	.word 0xc6942f1a  ! 1: LDUHA_I	lduha	[%r16, + 0x0f1a] %asi, %r3
	.word 0xe2c423fc  ! 1: LDSWA_I	ldswa	[%r16, + 0x03fc] %asi, %r17
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6442a24  ! 1: LDSW_I	ldsw	[%r16 + 0x0a24], %r3
	.word 0xc6cc270d  ! 1: LDSBA_I	ldsba	[%r16, + 0x070d] %asi, %r3
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	.word 0xfc0c256c  ! 1: LDUB_I	ldub	[%r16 + 0x056c], %r30
	brnz %r31,thr3_loop_cnt_849
	dec %r31
	.word 0xb7341002  ! 1: SRLX_R	srlx	%r16, %r2, %r27
        mov 0x1f, %r31
thr3_loop_cnt_850:
	.word 0xc65428da  ! 1: LDSH_I	ldsh	[%r16 + 0x08da], %r3
	.word 0xfadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r29
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	.word 0xf60c2e1c  ! 1: LDUB_I	ldub	[%r16 + 0x0e1c], %r27
	.word 0xe2dc2f08  ! 1: LDXA_I	ldxa	[%r16, + 0x0f08] %asi, %r17
	.word 0xdc942f16  ! 1: LDUHA_I	lduha	[%r16, + 0x0f16] %asi, %r14
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xc60c2993  ! 1: LDUB_I	ldub	[%r16 + 0x0993], %r3
	.word 0xc614208c  ! 1: LDUH_I	lduh	[%r16 + 0x008c], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd6442f94  ! 1: LDSW_I	ldsw	[%r16 + 0x0f94], %r11
	brnz %r31,thr3_loop_cnt_850
	dec %r31
	.word 0xb4342d26  ! 1: ORN_I	orn 	%r16, 0x0d26, %r26
        mov 0x5b, %r31
thr3_loop_cnt_851:
	.word 0xc6cc275e  ! 1: LDSBA_I	ldsba	[%r16, + 0x075e] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xc65421a0  ! 1: LDSH_I	ldsh	[%r16 + 0x01a0], %r3
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	.word 0xe48c2577  ! 1: LDUBA_I	lduba	[%r16, + 0x0577] %asi, %r18
	.word 0xc6dc22f0  ! 1: LDXA_I	ldxa	[%r16, + 0x02f0] %asi, %r3
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xecdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r22
	brnz %r31,thr3_loop_cnt_851
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0xbd340002  ! 1: SRL_R	srl 	%r16, %r2, %r30
	.word 0xb834220c  ! 1: SUBC_I	orn 	%r16, 0x020c, %r28
	.word 0x99343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r12
        mov 0x81, %r31
thr3_loop_cnt_852:
	.word 0xf4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r26
	.word 0xc6942302  ! 1: LDUHA_I	lduha	[%r16, + 0x0302] %asi, %r3
	.word 0xd08c204b  ! 1: LDUBA_I	lduba	[%r16, + 0x004b] %asi, %r8
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xd85421fc  ! 1: LDSH_I	ldsh	[%r16 + 0x01fc], %r12
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xe4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r18
	.word 0xf8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r28
	.word 0xd0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r8
	brnz %r31,thr3_loop_cnt_852
	dec %r31
	.word 0x86242f2a  ! 1: SUB_I	sub 	%r16, 0x0f2a, %r3
        mov 0x15, %r31
thr3_loop_cnt_853:
	.word 0xc6dc2da8  ! 1: LDXA_I	ldxa	[%r16, + 0x0da8] %asi, %r3
	.word 0xc6cc225d  ! 1: LDSBA_I	ldsba	[%r16, + 0x025d] %asi, %r3
	.word 0xe654266e  ! 1: LDSH_I	ldsh	[%r16 + 0x066e], %r19
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r11
	.word 0xf85c2d88  ! 1: LDX_I	ldx	[%r16 + 0x0d88], %r28
	.word 0xc6842da4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0da4] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_853
	dec %r31
	.word 0xb4240002  ! 1: SUB_R	sub 	%r16, %r2, %r26
        mov 0x4e, %r31
thr3_loop_cnt_854:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc60c27b2  ! 1: LDUB_I	ldub	[%r16 + 0x07b2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd4dc2220  ! 1: LDXA_I	ldxa	[%r16, + 0x0220] %asi, %r10
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf8142ab6  ! 1: LDUH_I	lduh	[%r16 + 0x0ab6], %r28
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	brnz %r31,thr3_loop_cnt_854
	dec %r31
	.word 0xb33c0002  ! 1: SRA_R	sra 	%r16, %r2, %r25
	.word 0x9e0c28d8  ! 1: AND_I	and 	%r16, 0x08d8, %r15
        mov 0x1c, %r31
thr3_loop_cnt_855:
	.word 0xc64c2b5a  ! 1: LDSB_I	ldsb	[%r16 + 0x0b5a], %r3
	.word 0xc6cc2037  ! 1: LDSBA_I	ldsba	[%r16, + 0x0037] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc273e  ! 1: LDSBA_I	ldsba	[%r16, + 0x073e] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xda0c245f  ! 1: LDUB_I	ldub	[%r16 + 0x045f], %r13
	.word 0xe6d42222  ! 1: LDSHA_I	ldsha	[%r16, + 0x0222] %asi, %r19
	.word 0xf68421d8  ! 1: LDUWA_I	lduwa	[%r16, + 0x01d8] %asi, %r27
	.word 0xc64c2d9f  ! 1: LDSB_I	ldsb	[%r16 + 0x0d9f], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_855
	dec %r31
	.word 0x9f342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r15
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x9b3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r13
        mov 0x4d, %r31
thr3_loop_cnt_856:
	.word 0xd2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r9
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	.word 0xe6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r19
	.word 0xccdc2270  ! 1: LDXA_I	ldxa	[%r16, + 0x0270] %asi, %r6
	.word 0xee142b66  ! 1: LDUH_I	lduh	[%r16 + 0x0b66], %r23
	.word 0xea140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r21
	.word 0xee540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r23
	brnz %r31,thr3_loop_cnt_856
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x9a1c22b3  ! 1: XOR_I	xor 	%r16, 0x02b3, %r13
        mov 0x66, %r31
thr3_loop_cnt_857:
	.word 0xc6442fb8  ! 1: LDSW_I	ldsw	[%r16 + 0x0fb8], %r3
	.word 0xced426a0  ! 1: LDSHA_I	ldsha	[%r16, + 0x06a0] %asi, %r7
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r27
	.word 0xda8422e4  ! 1: LDUWA_I	lduwa	[%r16, + 0x02e4] %asi, %r13
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xced42802  ! 1: LDSHA_I	ldsha	[%r16, + 0x0802] %asi, %r7
	.word 0xe28c2320  ! 1: LDUBA_I	lduba	[%r16, + 0x0320] %asi, %r17
	brnz %r31,thr3_loop_cnt_857
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0xb53c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r26
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x863424d0  ! 1: ORN_I	orn 	%r16, 0x04d0, %r3
        mov 0x1, %r31
thr3_loop_cnt_858:
	.word 0xe89421ee  ! 1: LDUHA_I	lduha	[%r16, + 0x01ee] %asi, %r20
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc61420fe  ! 1: LDUH_I	lduh	[%r16 + 0x00fe], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r18
	.word 0xeecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r23
	.word 0xde8c20d0  ! 1: LDUBA_I	lduba	[%r16, + 0x00d0] %asi, %r15
	.word 0xeccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r22
	brnz %r31,thr3_loop_cnt_858
	dec %r31
	.word 0x863c22e9  ! 1: XNOR_I	xnor 	%r16, 0x02e9, %r3
	.word 0xa52c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r18
	.word 0x9f2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r15
	.word 0xba340002  ! 1: SUBC_R	orn 	%r16, %r2, %r29
        mov 0xa8, %r31
thr3_loop_cnt_859:
	.word 0xded424bc  ! 1: LDSHA_I	ldsha	[%r16, + 0x04bc] %asi, %r15
	.word 0xf85c2f60  ! 1: LDX_I	ldx	[%r16 + 0x0f60], %r28
	.word 0xc6cc2beb  ! 1: LDSBA_I	ldsba	[%r16, + 0x0beb] %asi, %r3
	.word 0xc6142f2c  ! 1: LDUH_I	lduh	[%r16 + 0x0f2c], %r3
	.word 0xead42c04  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c04] %asi, %r21
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc64428f0  ! 1: LDSW_I	ldsw	[%r16 + 0x08f0], %r3
	.word 0xc68c2959  ! 1: LDUBA_I	lduba	[%r16, + 0x0959] %asi, %r3
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xf4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r26
	brnz %r31,thr3_loop_cnt_859
	dec %r31
	.word 0xb92c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r28
	.word 0x863c2af5  ! 1: XNOR_I	xnor 	%r16, 0x0af5, %r3
	.word 0xa52c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r18
	.word 0xa93c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r20
        mov 0x56, %r31
thr3_loop_cnt_860:
	.word 0xc6542532  ! 1: LDSH_I	ldsh	[%r16 + 0x0532], %r3
	.word 0xcc0c28ec  ! 1: LDUB_I	ldub	[%r16 + 0x08ec], %r6
	.word 0xf8d42d82  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d82] %asi, %r28
	.word 0xced42e4e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e4e] %asi, %r7
	.word 0xee5c24f0  ! 1: LDX_I	ldx	[%r16 + 0x04f0], %r23
	.word 0xc64c2eee  ! 1: LDSB_I	ldsb	[%r16 + 0x0eee], %r3
	.word 0xc6842a34  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a34] %asi, %r3
	.word 0xe41424b4  ! 1: LDUH_I	lduh	[%r16 + 0x04b4], %r18
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6c42500  ! 1: LDSWA_I	ldswa	[%r16, + 0x0500] %asi, %r3
	.word 0xf2cc2b8a  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b8a] %asi, %r25
	.word 0xc65423c6  ! 1: LDSH_I	ldsh	[%r16 + 0x03c6], %r3
	brnz %r31,thr3_loop_cnt_860
	dec %r31
        mov 0x72, %r31
thr3_loop_cnt_861:
	.word 0xc6542cc4  ! 1: LDSH_I	ldsh	[%r16 + 0x0cc4], %r3
	.word 0xc6042004  ! 1: LDUW_I	lduw	[%r16 + 0x0004], %r3
	.word 0xd2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r9
	.word 0xc6542510  ! 1: LDSH_I	ldsh	[%r16 + 0x0510], %r3
	.word 0xee942252  ! 1: LDUHA_I	lduha	[%r16, + 0x0252] %asi, %r23
	.word 0xe4dc21f0  ! 1: LDXA_I	ldxa	[%r16, + 0x01f0] %asi, %r18
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc684261c  ! 1: LDUWA_I	lduwa	[%r16, + 0x061c] %asi, %r3
	.word 0xf6cc2fa6  ! 1: LDSBA_I	ldsba	[%r16, + 0x0fa6] %asi, %r27
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_861
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0xbb, %r31
thr3_loop_cnt_862:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r11
	.word 0xc64426bc  ! 1: LDSW_I	ldsw	[%r16 + 0x06bc], %r3
	.word 0xd85c2140  ! 1: LDX_I	ldx	[%r16 + 0x0140], %r12
	.word 0xe8cc255e  ! 1: LDSBA_I	ldsba	[%r16, + 0x055e] %asi, %r20
	.word 0xd044267c  ! 1: LDSW_I	ldsw	[%r16 + 0x067c], %r8
	.word 0xf84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r28
	.word 0xf8942e2e  ! 1: LDUHA_I	lduha	[%r16, + 0x0e2e] %asi, %r28
	.word 0xec942dfc  ! 1: LDUHA_I	lduha	[%r16, + 0x0dfc] %asi, %r22
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf0d42876  ! 1: LDSHA_I	ldsha	[%r16, + 0x0876] %asi, %r24
	.word 0xd65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r11
	brnz %r31,thr3_loop_cnt_862
	dec %r31
        mov 0x12, %r31
thr3_loop_cnt_863:
	.word 0xd65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r11
	.word 0xd05c2b88  ! 1: LDX_I	ldx	[%r16 + 0x0b88], %r8
	.word 0xc6cc2590  ! 1: LDSBA_I	ldsba	[%r16, + 0x0590] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc69420ae  ! 1: LDUHA_I	lduha	[%r16, + 0x00ae] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r27
	.word 0xf4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r26
	.word 0xc60c2808  ! 1: LDUB_I	ldub	[%r16 + 0x0808], %r3
	.word 0xdc4c2ca0  ! 1: LDSB_I	ldsb	[%r16 + 0x0ca0], %r14
	brnz %r31,thr3_loop_cnt_863
	dec %r31
	.word 0x91340002  ! 1: SRL_R	srl 	%r16, %r2, %r8
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0xb0342def  ! 1: SUBC_I	orn 	%r16, 0x0def, %r24
        mov 0x87, %r31
thr3_loop_cnt_864:
	.word 0xdcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r14
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xee0c2748  ! 1: LDUB_I	ldub	[%r16 + 0x0748], %r23
	.word 0xfa841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r29
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r18
	.word 0xea841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r21
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	brnz %r31,thr3_loop_cnt_864
	dec %r31
        mov 0xb1, %r31
thr3_loop_cnt_865:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xfa140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r29
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd0c42a08  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a08] %asi, %r8
	.word 0xd6942e38  ! 1: LDUHA_I	lduha	[%r16, + 0x0e38] %asi, %r11
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd814212e  ! 1: LDUH_I	lduh	[%r16 + 0x012e], %r12
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xea542042  ! 1: LDSH_I	ldsh	[%r16 + 0x0042], %r21
	.word 0xc6142ee2  ! 1: LDUH_I	lduh	[%r16 + 0x0ee2], %r3
	brnz %r31,thr3_loop_cnt_865
	dec %r31
        mov 0x26, %r31
thr3_loop_cnt_866:
	.word 0xeecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r23
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xecd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r22
	.word 0xc68c244e  ! 1: LDUBA_I	lduba	[%r16, + 0x044e] %asi, %r3
	.word 0xc60c279b  ! 1: LDUB_I	ldub	[%r16 + 0x079b], %r3
	.word 0xf2942322  ! 1: LDUHA_I	lduha	[%r16, + 0x0322] %asi, %r25
	.word 0xc6d4276a  ! 1: LDSHA_I	ldsha	[%r16, + 0x076a] %asi, %r3
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xc65c2360  ! 1: LDX_I	ldx	[%r16 + 0x0360], %r3
	brnz %r31,thr3_loop_cnt_866
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x9f341002  ! 1: SRLX_R	srlx	%r16, %r2, %r15
	.word 0x97340002  ! 1: SRL_R	srl 	%r16, %r2, %r11
        mov 0x8, %r31
thr3_loop_cnt_867:
	.word 0xe24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r17
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xec54286c  ! 1: LDSH_I	ldsh	[%r16 + 0x086c], %r22
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6442e00  ! 1: LDSW_I	ldsw	[%r16 + 0x0e00], %r3
	.word 0xc61428c6  ! 1: LDUH_I	lduh	[%r16 + 0x08c6], %r3
	.word 0xd60c2a52  ! 1: LDUB_I	ldub	[%r16 + 0x0a52], %r11
	.word 0xc65c2c20  ! 1: LDX_I	ldx	[%r16 + 0x0c20], %r3
	.word 0xf04c2180  ! 1: LDSB_I	ldsb	[%r16 + 0x0180], %r24
	.word 0xeacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r21
	.word 0xc6c4220c  ! 1: LDSWA_I	ldswa	[%r16, + 0x020c] %asi, %r3
	brnz %r31,thr3_loop_cnt_867
	dec %r31
	.word 0x8644292e  ! 1: ADDC_I	addc 	%r16, 0x092e, %r3
        mov 0x60, %r31
thr3_loop_cnt_868:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xde0c2e2e  ! 1: LDUB_I	ldub	[%r16 + 0x0e2e], %r15
	.word 0xfc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r30
	.word 0xe6942e68  ! 1: LDUHA_I	lduha	[%r16, + 0x0e68] %asi, %r19
	.word 0xc61424d4  ! 1: LDUH_I	lduh	[%r16 + 0x04d4], %r3
	.word 0xd6cc274a  ! 1: LDSBA_I	ldsba	[%r16, + 0x074a] %asi, %r11
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	.word 0xc60c28b8  ! 1: LDUB_I	ldub	[%r16 + 0x08b8], %r3
	.word 0xc6442d90  ! 1: LDSW_I	ldsw	[%r16 + 0x0d90], %r3
	brnz %r31,thr3_loop_cnt_868
	dec %r31
	.word 0xae3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r23
	.word 0xb53c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r26
	.word 0x933c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r9
	.word 0x861c23fc  ! 1: XOR_I	xor 	%r16, 0x03fc, %r3
        mov 0xf, %r31
thr3_loop_cnt_869:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xfa142ce0  ! 1: LDUH_I	lduh	[%r16 + 0x0ce0], %r29
	.word 0xeec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r23
	.word 0xc6542b2a  ! 1: LDSH_I	ldsh	[%r16 + 0x0b2a], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r26
	.word 0xd2942dd2  ! 1: LDUHA_I	lduha	[%r16, + 0x0dd2] %asi, %r9
	.word 0xc6442a30  ! 1: LDSW_I	ldsw	[%r16 + 0x0a30], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_869
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x32, %r31
thr3_loop_cnt_870:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r12
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc65c2ad0  ! 1: LDX_I	ldx	[%r16 + 0x0ad0], %r3
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	.word 0xf4d42364  ! 1: LDSHA_I	ldsha	[%r16, + 0x0364] %asi, %r26
	.word 0xee142912  ! 1: LDUH_I	lduh	[%r16 + 0x0912], %r23
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xde040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r15
	brnz %r31,thr3_loop_cnt_870
	dec %r31
	.word 0x862c2151  ! 1: ANDN_I	andn 	%r16, 0x0151, %r3
        mov 0xa1, %r31
thr3_loop_cnt_871:
	.word 0xc6c42020  ! 1: LDSWA_I	ldswa	[%r16, + 0x0020] %asi, %r3
	.word 0xc6dc2bc0  ! 1: LDXA_I	ldxa	[%r16, + 0x0bc0] %asi, %r3
	.word 0xc61422e4  ! 1: LDUH_I	lduh	[%r16 + 0x02e4], %r3
	.word 0xf4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r26
	.word 0xd80422c0  ! 1: LDUW_I	lduw	[%r16 + 0x02c0], %r12
	.word 0xc6942098  ! 1: LDUHA_I	lduha	[%r16, + 0x0098] %asi, %r3
	.word 0xf0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r24
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf60c2171  ! 1: LDUB_I	ldub	[%r16 + 0x0171], %r27
	.word 0xe8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r20
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	brnz %r31,thr3_loop_cnt_871
	dec %r31
	.word 0xa8042c03  ! 1: ADD_I	add 	%r16, 0x0c03, %r20
        mov 0xa4, %r31
thr3_loop_cnt_872:
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xc6442d48  ! 1: LDSW_I	ldsw	[%r16 + 0x0d48], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xc6142bd2  ! 1: LDUH_I	lduh	[%r16 + 0x0bd2], %r3
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	.word 0xd45c2e80  ! 1: LDX_I	ldx	[%r16 + 0x0e80], %r10
	.word 0xf80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r28
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	.word 0xc68c22f9  ! 1: LDUBA_I	lduba	[%r16, + 0x02f9] %asi, %r3
	brnz %r31,thr3_loop_cnt_872
	dec %r31
	.word 0xa62c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r19
	.word 0x993c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r12
	.word 0xa81c0002  ! 1: XOR_R	xor 	%r16, %r2, %r20
	.word 0x8c0425b6  ! 1: ADD_I	add 	%r16, 0x05b6, %r6
        mov 0x34, %r31
thr3_loop_cnt_873:
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xf6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r27
	.word 0xc64c2a92  ! 1: LDSB_I	ldsb	[%r16 + 0x0a92], %r3
	.word 0xc6c42328  ! 1: LDSWA_I	ldswa	[%r16, + 0x0328] %asi, %r3
	.word 0xc68c23d6  ! 1: LDUBA_I	lduba	[%r16, + 0x03d6] %asi, %r3
	.word 0xc6cc2835  ! 1: LDSBA_I	ldsba	[%r16, + 0x0835] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xee941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r23
	.word 0xc6d42fee  ! 1: LDSHA_I	ldsha	[%r16, + 0x0fee] %asi, %r3
	.word 0xc65c2730  ! 1: LDX_I	ldx	[%r16 + 0x0730], %r3
	.word 0xc65428b0  ! 1: LDSH_I	ldsh	[%r16 + 0x08b0], %r3
	.word 0xc6c4255c  ! 1: LDSWA_I	ldswa	[%r16, + 0x055c] %asi, %r3
	brnz %r31,thr3_loop_cnt_873
	dec %r31
	.word 0x861c2ed9  ! 1: XOR_I	xor 	%r16, 0x0ed9, %r3
        mov 0x40, %r31
thr3_loop_cnt_874:
	.word 0xd4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r10
	.word 0xc60c223f  ! 1: LDUB_I	ldub	[%r16 + 0x023f], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd8542010  ! 1: LDSH_I	ldsh	[%r16 + 0x0010], %r12
	.word 0xe2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r17
	.word 0xc64c22ec  ! 1: LDSB_I	ldsb	[%r16 + 0x02ec], %r3
	.word 0xc6042d5c  ! 1: LDUW_I	lduw	[%r16 + 0x0d5c], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc68c27b9  ! 1: LDUBA_I	lduba	[%r16, + 0x07b9] %asi, %r3
	.word 0xd6d42808  ! 1: LDSHA_I	ldsha	[%r16, + 0x0808] %asi, %r11
	.word 0xe4c42144  ! 1: LDSWA_I	ldswa	[%r16, + 0x0144] %asi, %r18
	brnz %r31,thr3_loop_cnt_874
	dec %r31
	.word 0xa33c1002  ! 1: SRAX_R	srax	%r16, %r2, %r17
	.word 0xb4342dbf  ! 1: ORN_I	orn 	%r16, 0x0dbf, %r26
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x9d2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r14
        mov 0x3e, %r31
thr3_loop_cnt_875:
	.word 0xf8cc21b1  ! 1: LDSBA_I	ldsba	[%r16, + 0x01b1] %asi, %r28
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xec540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r22
	.word 0xf8942378  ! 1: LDUHA_I	lduha	[%r16, + 0x0378] %asi, %r28
	.word 0xc60c2adb  ! 1: LDUB_I	ldub	[%r16 + 0x0adb], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r19
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r20
	.word 0xe6942716  ! 1: LDUHA_I	lduha	[%r16, + 0x0716] %asi, %r19
	brnz %r31,thr3_loop_cnt_875
	dec %r31
	.word 0xa20c0002  ! 1: AND_R	and 	%r16, %r2, %r17
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x862c23d3  ! 1: ANDN_I	andn 	%r16, 0x03d3, %r3
        mov 0xc, %r31
thr3_loop_cnt_876:
	.word 0xf4942cda  ! 1: LDUHA_I	lduha	[%r16, + 0x0cda] %asi, %r26
	.word 0xc6842eac  ! 1: LDUWA_I	lduwa	[%r16, + 0x0eac] %asi, %r3
	.word 0xc64429c4  ! 1: LDSW_I	ldsw	[%r16 + 0x09c4], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd60428b0  ! 1: LDUW_I	lduw	[%r16 + 0x08b0], %r11
	.word 0xf45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r26
	.word 0xc654218a  ! 1: LDSH_I	ldsh	[%r16 + 0x018a], %r3
	.word 0xc6542ba8  ! 1: LDSH_I	ldsh	[%r16 + 0x0ba8], %r3
	brnz %r31,thr3_loop_cnt_876
	dec %r31
	.word 0xb6240002  ! 1: SUB_R	sub 	%r16, %r2, %r27
        mov 0x5, %r31
thr3_loop_cnt_877:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc604299c  ! 1: LDUW_I	lduw	[%r16 + 0x099c], %r3
	.word 0xeacc2158  ! 1: LDSBA_I	ldsba	[%r16, + 0x0158] %asi, %r21
	.word 0xc6942710  ! 1: LDUHA_I	lduha	[%r16, + 0x0710] %asi, %r3
	.word 0xe60c28d9  ! 1: LDUB_I	ldub	[%r16 + 0x08d9], %r19
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd8c42be8  ! 1: LDSWA_I	ldswa	[%r16, + 0x0be8] %asi, %r12
	.word 0xf24c2e40  ! 1: LDSB_I	ldsb	[%r16 + 0x0e40], %r25
	brnz %r31,thr3_loop_cnt_877
	dec %r31
	.word 0xa80c2c27  ! 1: AND_I	and 	%r16, 0x0c27, %r20
	.word 0x861c2a2e  ! 1: XOR_I	xor 	%r16, 0x0a2e, %r3
        mov 0x2d, %r31
thr3_loop_cnt_878:
	.word 0xf48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r26
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe6c42210  ! 1: LDSWA_I	ldswa	[%r16, + 0x0210] %asi, %r19
	.word 0xc6dc2b28  ! 1: LDXA_I	ldxa	[%r16, + 0x0b28] %asi, %r3
	.word 0xc6dc21a8  ! 1: LDXA_I	ldxa	[%r16, + 0x01a8] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r26
	.word 0xce0c2d3b  ! 1: LDUB_I	ldub	[%r16 + 0x0d3b], %r7
	.word 0xe8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r20
	.word 0xd0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r8
	.word 0xd25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r9
	.word 0xd0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r8
	brnz %r31,thr3_loop_cnt_878
	dec %r31
        mov 0xc2, %r31
thr3_loop_cnt_879:
	.word 0xe2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r17
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe4dc2790  ! 1: LDXA_I	ldxa	[%r16, + 0x0790] %asi, %r18
	.word 0xf05c29e8  ! 1: LDX_I	ldx	[%r16 + 0x09e8], %r24
	.word 0xcc042f84  ! 1: LDUW_I	lduw	[%r16 + 0x0f84], %r6
	.word 0xc60c2a92  ! 1: LDUB_I	ldub	[%r16 + 0x0a92], %r3
	.word 0xf2442424  ! 1: LDSW_I	ldsw	[%r16 + 0x0424], %r25
	.word 0xc65c2c50  ! 1: LDX_I	ldx	[%r16 + 0x0c50], %r3
	brnz %r31,thr3_loop_cnt_879
	dec %r31
	.word 0xae242e36  ! 1: SUB_I	sub 	%r16, 0x0e36, %r23
	.word 0xb1340002  ! 1: SRL_R	srl 	%r16, %r2, %r24
	.word 0x861c2d26  ! 1: XOR_I	xor 	%r16, 0x0d26, %r3
        mov 0x96, %r31
thr3_loop_cnt_880:
	.word 0xf6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r27
	.word 0xd81426b4  ! 1: LDUH_I	lduh	[%r16 + 0x06b4], %r12
	.word 0xe60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r19
	.word 0xc68c22a5  ! 1: LDUBA_I	lduba	[%r16, + 0x02a5] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6cc2181  ! 1: LDSBA_I	ldsba	[%r16, + 0x0181] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe45c2cc0  ! 1: LDX_I	ldx	[%r16 + 0x0cc0], %r18
	.word 0xf6142d04  ! 1: LDUH_I	lduh	[%r16 + 0x0d04], %r27
	.word 0xc6c42298  ! 1: LDSWA_I	ldswa	[%r16, + 0x0298] %asi, %r3
	brnz %r31,thr3_loop_cnt_880
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0xac242879  ! 1: SUB_I	sub 	%r16, 0x0879, %r22
	.word 0x932c0002  ! 1: SLL_R	sll 	%r16, %r2, %r9
	.word 0x901c2a3a  ! 1: XOR_I	xor 	%r16, 0x0a3a, %r8
        mov 0x8c, %r31
thr3_loop_cnt_881:
	.word 0xdecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r15
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc64c2ad2  ! 1: LDSB_I	ldsb	[%r16 + 0x0ad2], %r3
	.word 0xdc542750  ! 1: LDSH_I	ldsh	[%r16 + 0x0750], %r14
	.word 0xdc442f48  ! 1: LDSW_I	ldsw	[%r16 + 0x0f48], %r14
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc64c2e80  ! 1: LDSB_I	ldsb	[%r16 + 0x0e80], %r3
	.word 0xc65c23c8  ! 1: LDX_I	ldx	[%r16 + 0x03c8], %r3
	brnz %r31,thr3_loop_cnt_881
	dec %r31
	.word 0xba04267d  ! 1: ADD_I	add 	%r16, 0x067d, %r29
        mov 0x52, %r31
thr3_loop_cnt_882:
	.word 0xc6cc2498  ! 1: LDSBA_I	ldsba	[%r16, + 0x0498] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf40425a0  ! 1: LDUW_I	lduw	[%r16 + 0x05a0], %r26
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd65c2040  ! 1: LDX_I	ldx	[%r16 + 0x0040], %r11
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd2dc2650  ! 1: LDXA_I	ldxa	[%r16, + 0x0650] %asi, %r9
	.word 0xc65426a8  ! 1: LDSH_I	ldsh	[%r16 + 0x06a8], %r3
	brnz %r31,thr3_loop_cnt_882
	dec %r31
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x8c140002  ! 1: OR_R	or 	%r16, %r2, %r6
	.word 0x863429c8  ! 1: ORN_I	orn 	%r16, 0x09c8, %r3
        mov 0x3b, %r31
thr3_loop_cnt_883:
	.word 0xee841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r23
	.word 0xc6c421ac  ! 1: LDSWA_I	ldswa	[%r16, + 0x01ac] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6542b16  ! 1: LDSH_I	ldsh	[%r16 + 0x0b16], %r3
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xc65c2818  ! 1: LDX_I	ldx	[%r16 + 0x0818], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6c42b14  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b14] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6cc2622  ! 1: LDSBA_I	ldsba	[%r16, + 0x0622] %asi, %r3
	brnz %r31,thr3_loop_cnt_883
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0xb23428fa  ! 1: ORN_I	orn 	%r16, 0x08fa, %r25
        mov 0x39, %r31
thr3_loop_cnt_884:
	.word 0xdedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r15
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd2c429c0  ! 1: LDSWA_I	ldswa	[%r16, + 0x09c0] %asi, %r9
	.word 0xd60c2752  ! 1: LDUB_I	ldub	[%r16 + 0x0752], %r11
	.word 0xc64c25ce  ! 1: LDSB_I	ldsb	[%r16 + 0x05ce], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc694226e  ! 1: LDUHA_I	lduha	[%r16, + 0x026e] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xdc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r14
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_884
	dec %r31
	.word 0x9424245e  ! 1: SUB_I	sub 	%r16, 0x045e, %r10
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0x77, %r31
thr3_loop_cnt_885:
	.word 0xf6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r27
	.word 0xc68c2118  ! 1: LDUBA_I	lduba	[%r16, + 0x0118] %asi, %r3
	.word 0xc6442fb0  ! 1: LDSW_I	ldsw	[%r16 + 0x0fb0], %r3
	.word 0xd6dc2588  ! 1: LDXA_I	ldxa	[%r16, + 0x0588] %asi, %r11
	.word 0xd0cc2f01  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f01] %asi, %r8
	.word 0xda0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r13
	.word 0xd61429dc  ! 1: LDUH_I	lduh	[%r16 + 0x09dc], %r11
	.word 0xce142970  ! 1: LDUH_I	lduh	[%r16 + 0x0970], %r7
	brnz %r31,thr3_loop_cnt_885
	dec %r31
	.word 0x862c277a  ! 1: ANDN_I	andn 	%r16, 0x077a, %r3
	.word 0x9a3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r13
	.word 0xac0425bd  ! 1: ADD_I	add 	%r16, 0x05bd, %r22
        mov 0xaa, %r31
thr3_loop_cnt_886:
	.word 0xfa8c2f3d  ! 1: LDUBA_I	lduba	[%r16, + 0x0f3d] %asi, %r29
	.word 0xd2dc2e20  ! 1: LDXA_I	ldxa	[%r16, + 0x0e20] %asi, %r9
	.word 0xc644253c  ! 1: LDSW_I	ldsw	[%r16 + 0x053c], %r3
	.word 0xc6d42bb0  ! 1: LDSHA_I	ldsha	[%r16, + 0x0bb0] %asi, %r3
	.word 0xc68c2aac  ! 1: LDUBA_I	lduba	[%r16, + 0x0aac] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6cc2cbf  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cbf] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_886
	dec %r31
	.word 0xa4342e5e  ! 1: ORN_I	orn 	%r16, 0x0e5e, %r18
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0xa6, %r31
thr3_loop_cnt_887:
	.word 0xc64c2afe  ! 1: LDSB_I	ldsb	[%r16 + 0x0afe], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r24
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xd0cc243a  ! 1: LDSBA_I	ldsba	[%r16, + 0x043a] %asi, %r8
	.word 0xc65c2838  ! 1: LDX_I	ldx	[%r16 + 0x0838], %r3
	.word 0xcc5c2fc0  ! 1: LDX_I	ldx	[%r16 + 0x0fc0], %r6
	.word 0xc654252e  ! 1: LDSH_I	ldsh	[%r16 + 0x052e], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_887
	dec %r31
        mov 0xac, %r31
thr3_loop_cnt_888:
	.word 0xda140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r13
	.word 0xce94216c  ! 1: LDUHA_I	lduha	[%r16, + 0x016c] %asi, %r7
	.word 0xc6d422ca  ! 1: LDSHA_I	ldsha	[%r16, + 0x02ca] %asi, %r3
	.word 0xc6842fcc  ! 1: LDUWA_I	lduwa	[%r16, + 0x0fcc] %asi, %r3
	.word 0xc61425e0  ! 1: LDUH_I	lduh	[%r16 + 0x05e0], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r12
	.word 0xf08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r24
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	brnz %r31,thr3_loop_cnt_888
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x68, %r31
thr3_loop_cnt_889:
	.word 0xde941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r15
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe2d42edc  ! 1: LDSHA_I	ldsha	[%r16, + 0x0edc] %asi, %r17
	.word 0xec8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r22
	.word 0xc6142134  ! 1: LDUH_I	lduh	[%r16 + 0x0134], %r3
	.word 0xd0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r8
	.word 0xee5424ee  ! 1: LDSH_I	ldsh	[%r16 + 0x04ee], %r23
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xcc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r6
	brnz %r31,thr3_loop_cnt_889
	dec %r31
	.word 0x9a142e1b  ! 1: OR_I	or 	%r16, 0x0e1b, %r13
	.word 0x92040002  ! 1: ADD_R	add 	%r16, %r2, %r9
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0xa81421b7  ! 1: OR_I	or 	%r16, 0x01b7, %r20
        mov 0xc0, %r31
thr3_loop_cnt_890:
	.word 0xd4442f48  ! 1: LDSW_I	ldsw	[%r16 + 0x0f48], %r10
	.word 0xd48c286d  ! 1: LDUBA_I	lduba	[%r16, + 0x086d] %asi, %r10
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r26
	.word 0xde5c2ca8  ! 1: LDX_I	ldx	[%r16 + 0x0ca8], %r15
	.word 0xf28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r25
	.word 0xe24c2d3c  ! 1: LDSB_I	ldsb	[%r16 + 0x0d3c], %r17
	.word 0xfcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r30
	.word 0xc64c2d44  ! 1: LDSB_I	ldsb	[%r16 + 0x0d44], %r3
	.word 0xc6dc2a08  ! 1: LDXA_I	ldxa	[%r16, + 0x0a08] %asi, %r3
	brnz %r31,thr3_loop_cnt_890
	dec %r31
	.word 0x9e1c2fd2  ! 1: XOR_I	xor 	%r16, 0x0fd2, %r15
	.word 0xb61426bb  ! 1: OR_I	or 	%r16, 0x06bb, %r27
	.word 0x863c2649  ! 1: XNOR_I	xnor 	%r16, 0x0649, %r3
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0xab, %r31
thr3_loop_cnt_891:
	.word 0xc6dc2c20  ! 1: LDXA_I	ldxa	[%r16, + 0x0c20] %asi, %r3
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xf8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r28
	.word 0xc6542620  ! 1: LDSH_I	ldsh	[%r16 + 0x0620], %r3
	.word 0xc684283c  ! 1: LDUWA_I	lduwa	[%r16, + 0x083c] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc60428a0  ! 1: LDUW_I	lduw	[%r16 + 0x08a0], %r3
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xce440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r7
	brnz %r31,thr3_loop_cnt_891
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x94442033  ! 1: ADDC_I	addc 	%r16, 0x0033, %r10
        mov 0x9f, %r31
thr3_loop_cnt_892:
	.word 0xcc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r6
	.word 0xc65c23b0  ! 1: LDX_I	ldx	[%r16 + 0x03b0], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r18
	.word 0xfc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r30
	.word 0xc6442c08  ! 1: LDSW_I	ldsw	[%r16 + 0x0c08], %r3
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_892
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0x39, %r31
thr3_loop_cnt_893:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc68428a4  ! 1: LDUWA_I	lduwa	[%r16, + 0x08a4] %asi, %r3
	.word 0xc65c2e40  ! 1: LDX_I	ldx	[%r16 + 0x0e40], %r3
	.word 0xee842950  ! 1: LDUWA_I	lduwa	[%r16, + 0x0950] %asi, %r23
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd804225c  ! 1: LDUW_I	lduw	[%r16 + 0x025c], %r12
	.word 0xc6542e40  ! 1: LDSH_I	ldsh	[%r16 + 0x0e40], %r3
	.word 0xf4d422fc  ! 1: LDSHA_I	ldsha	[%r16, + 0x02fc] %asi, %r26
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xdad42274  ! 1: LDSHA_I	ldsha	[%r16, + 0x0274] %asi, %r13
	.word 0xeac425d4  ! 1: LDSWA_I	ldswa	[%r16, + 0x05d4] %asi, %r21
	brnz %r31,thr3_loop_cnt_893
	dec %r31
	.word 0x8d343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r6
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x953c0002  ! 1: SRA_R	sra 	%r16, %r2, %r10
        mov 0xbf, %r31
thr3_loop_cnt_894:
	.word 0xe88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r20
	.word 0xfa0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r29
	.word 0xc6542720  ! 1: LDSH_I	ldsh	[%r16 + 0x0720], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xcc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r6
	.word 0xea442e00  ! 1: LDSW_I	ldsw	[%r16 + 0x0e00], %r21
	.word 0xe2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r17
	.word 0xf6842f14  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f14] %asi, %r27
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_894
	dec %r31
	.word 0x912c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r8
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0x3, %r31
thr3_loop_cnt_895:
	.word 0xee440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r23
	.word 0xc6542a82  ! 1: LDSH_I	ldsh	[%r16 + 0x0a82], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6dc27e0  ! 1: LDXA_I	ldxa	[%r16, + 0x07e0] %asi, %r3
	.word 0xf2dc2c00  ! 1: LDXA_I	ldxa	[%r16, + 0x0c00] %asi, %r25
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6942624  ! 1: LDUHA_I	lduha	[%r16, + 0x0624] %asi, %r3
	.word 0xe45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r18
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	brnz %r31,thr3_loop_cnt_895
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x8c0c2d5d  ! 1: AND_I	and 	%r16, 0x0d5d, %r6
        mov 0xc4, %r31
thr3_loop_cnt_896:
	.word 0xce54230a  ! 1: LDSH_I	ldsh	[%r16 + 0x030a], %r7
	.word 0xf0dc2010  ! 1: LDXA_I	ldxa	[%r16, + 0x0010] %asi, %r24
	.word 0xce8c23dd  ! 1: LDUBA_I	lduba	[%r16, + 0x03dd] %asi, %r7
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	.word 0xf05c2288  ! 1: LDX_I	ldx	[%r16 + 0x0288], %r24
	.word 0xfa040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r29
	.word 0xe6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r19
	.word 0xf2d42916  ! 1: LDSHA_I	ldsha	[%r16, + 0x0916] %asi, %r25
	.word 0xc65c2360  ! 1: LDX_I	ldx	[%r16 + 0x0360], %r3
	brnz %r31,thr3_loop_cnt_896
	dec %r31
	.word 0x9c14232d  ! 1: OR_I	or 	%r16, 0x032d, %r14
	.word 0xb1340002  ! 1: SRL_R	srl 	%r16, %r2, %r24
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x93343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r9
        mov 0x23, %r31
thr3_loop_cnt_897:
	.word 0xfa040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r29
	.word 0xd09427d6  ! 1: LDUHA_I	lduha	[%r16, + 0x07d6] %asi, %r8
	.word 0xc65c2810  ! 1: LDX_I	ldx	[%r16 + 0x0810], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xcedc28b0  ! 1: LDXA_I	ldxa	[%r16, + 0x08b0] %asi, %r7
	.word 0xc6cc2750  ! 1: LDSBA_I	ldsba	[%r16, + 0x0750] %asi, %r3
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xc61426b2  ! 1: LDUH_I	lduh	[%r16 + 0x06b2], %r3
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6cc2716  ! 1: LDSBA_I	ldsba	[%r16, + 0x0716] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_897
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x9f2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r15
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x8e, %r31
thr3_loop_cnt_898:
	.word 0xe88424a4  ! 1: LDUWA_I	lduwa	[%r16, + 0x04a4] %asi, %r20
	.word 0xc65c2b48  ! 1: LDX_I	ldx	[%r16 + 0x0b48], %r3
	.word 0xc6d42b04  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b04] %asi, %r3
	.word 0xcc0c2945  ! 1: LDUB_I	ldub	[%r16 + 0x0945], %r6
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc654269c  ! 1: LDSH_I	ldsh	[%r16 + 0x069c], %r3
	.word 0xc68c29d0  ! 1: LDUBA_I	lduba	[%r16, + 0x09d0] %asi, %r3
	.word 0xf05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r24
	.word 0xe6442504  ! 1: LDSW_I	ldsw	[%r16 + 0x0504], %r19
	.word 0xc6dc2330  ! 1: LDXA_I	ldxa	[%r16, + 0x0330] %asi, %r3
	brnz %r31,thr3_loop_cnt_898
	dec %r31
	.word 0xae3c238f  ! 1: XNOR_I	xnor 	%r16, 0x038f, %r23
        mov 0xb9, %r31
thr3_loop_cnt_899:
	.word 0xc6d42256  ! 1: LDSHA_I	ldsha	[%r16, + 0x0256] %asi, %r3
	.word 0xfccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r30
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r27
	.word 0xfacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r29
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	.word 0xc6142328  ! 1: LDUH_I	lduh	[%r16 + 0x0328], %r3
	brnz %r31,thr3_loop_cnt_899
	dec %r31
	.word 0xab343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r21
        mov 0x2d, %r31
thr3_loop_cnt_900:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	.word 0xda5425a4  ! 1: LDSH_I	ldsh	[%r16 + 0x05a4], %r13
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r10
	.word 0xc6dc2320  ! 1: LDXA_I	ldxa	[%r16, + 0x0320] %asi, %r3
	.word 0xe8842140  ! 1: LDUWA_I	lduwa	[%r16, + 0x0140] %asi, %r20
	.word 0xcecc2827  ! 1: LDSBA_I	ldsba	[%r16, + 0x0827] %asi, %r7
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	brnz %r31,thr3_loop_cnt_900
	dec %r31
	.word 0x86442bd5  ! 1: ADDC_I	addc 	%r16, 0x0bd5, %r3
	.word 0x9e0c0002  ! 1: AND_R	and 	%r16, %r2, %r15
        mov 0xa4, %r31
thr3_loop_cnt_901:
	.word 0xc6042570  ! 1: LDUW_I	lduw	[%r16 + 0x0570], %r3
	.word 0xc64c2c72  ! 1: LDSB_I	ldsb	[%r16 + 0x0c72], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xfac42cd0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0cd0] %asi, %r29
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc64422dc  ! 1: LDSW_I	ldsw	[%r16 + 0x02dc], %r3
	brnz %r31,thr3_loop_cnt_901
	dec %r31
	.word 0x861c2dc9  ! 1: XOR_I	xor 	%r16, 0x0dc9, %r3
	.word 0xb4342ef5  ! 1: ORN_I	orn 	%r16, 0x0ef5, %r26
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0xb8242766  ! 1: SUB_I	sub 	%r16, 0x0766, %r28
        mov 0x45, %r31
thr3_loop_cnt_902:
	.word 0xf6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r27
	.word 0xfa5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r29
	.word 0xe48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r18
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xec5c2478  ! 1: LDX_I	ldx	[%r16 + 0x0478], %r22
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xcc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r6
	.word 0xc6dc29e8  ! 1: LDXA_I	ldxa	[%r16, + 0x09e8] %asi, %r3
	brnz %r31,thr3_loop_cnt_902
	dec %r31
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x95341002  ! 1: SRLX_R	srlx	%r16, %r2, %r10
        mov 0x46, %r31
thr3_loop_cnt_903:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc69429d8  ! 1: LDUHA_I	lduha	[%r16, + 0x09d8] %asi, %r3
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xc68c2450  ! 1: LDUBA_I	lduba	[%r16, + 0x0450] %asi, %r3
	.word 0xeed422ca  ! 1: LDSHA_I	ldsha	[%r16, + 0x02ca] %asi, %r23
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_903
	dec %r31
	.word 0x86142244  ! 1: OR_I	or 	%r16, 0x0244, %r3
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0xb5341002  ! 1: SRLX_R	srlx	%r16, %r2, %r26
        mov 0xa9, %r31
thr3_loop_cnt_904:
	.word 0xc6842200  ! 1: LDUWA_I	lduwa	[%r16, + 0x0200] %asi, %r3
	.word 0xc6842b9c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b9c] %asi, %r3
	.word 0xfccc2fc3  ! 1: LDSBA_I	ldsba	[%r16, + 0x0fc3] %asi, %r30
	.word 0xe65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r19
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xc60c2f08  ! 1: LDUB_I	ldub	[%r16 + 0x0f08], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd80c2a20  ! 1: LDUB_I	ldub	[%r16 + 0x0a20], %r12
	.word 0xc6c42cf0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0cf0] %asi, %r3
	brnz %r31,thr3_loop_cnt_904
	dec %r31
	.word 0x8c2c2348  ! 1: ANDN_I	andn 	%r16, 0x0348, %r6
        mov 0x9e, %r31
thr3_loop_cnt_905:
	.word 0xf0dc2990  ! 1: LDXA_I	ldxa	[%r16, + 0x0990] %asi, %r24
	.word 0xcccc2cf7  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cf7] %asi, %r6
	.word 0xc6dc2048  ! 1: LDXA_I	ldxa	[%r16, + 0x0048] %asi, %r3
	.word 0xc65c2ff8  ! 1: LDX_I	ldx	[%r16 + 0x0ff8], %r3
	.word 0xc6942526  ! 1: LDUHA_I	lduha	[%r16, + 0x0526] %asi, %r3
	.word 0xd6542884  ! 1: LDSH_I	ldsh	[%r16 + 0x0884], %r11
	.word 0xf2dc25a8  ! 1: LDXA_I	ldxa	[%r16, + 0x05a8] %asi, %r25
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xc6142e24  ! 1: LDUH_I	lduh	[%r16 + 0x0e24], %r3
	brnz %r31,thr3_loop_cnt_905
	dec %r31
        mov 0x38, %r31
thr3_loop_cnt_906:
	.word 0xe8d42e0e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e0e] %asi, %r20
	.word 0xc6c4267c  ! 1: LDSWA_I	ldswa	[%r16, + 0x067c] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	.word 0xeecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r23
	.word 0xde942c46  ! 1: LDUHA_I	lduha	[%r16, + 0x0c46] %asi, %r15
	.word 0xeac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r21
	.word 0xc68c2683  ! 1: LDUBA_I	lduba	[%r16, + 0x0683] %asi, %r3
	.word 0xde042e50  ! 1: LDUW_I	lduw	[%r16 + 0x0e50], %r15
	.word 0xc6942988  ! 1: LDUHA_I	lduha	[%r16, + 0x0988] %asi, %r3
	.word 0xea4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r21
	.word 0xda442250  ! 1: LDSW_I	ldsw	[%r16 + 0x0250], %r13
	brnz %r31,thr3_loop_cnt_906
	dec %r31
	.word 0x9a3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r13
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x16, %r31
thr3_loop_cnt_907:
	.word 0xc6142ab8  ! 1: LDUH_I	lduh	[%r16 + 0x0ab8], %r3
	.word 0xee042a7c  ! 1: LDUW_I	lduw	[%r16 + 0x0a7c], %r23
	.word 0xc65c2730  ! 1: LDX_I	ldx	[%r16 + 0x0730], %r3
	.word 0xce8c2539  ! 1: LDUBA_I	lduba	[%r16, + 0x0539] %asi, %r7
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc64421b8  ! 1: LDSW_I	ldsw	[%r16 + 0x01b8], %r3
	.word 0xee540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r23
	.word 0xd48428f0  ! 1: LDUWA_I	lduwa	[%r16, + 0x08f0] %asi, %r10
	.word 0xc68c2b4a  ! 1: LDUBA_I	lduba	[%r16, + 0x0b4a] %asi, %r3
	.word 0xe8c427c4  ! 1: LDSWA_I	ldswa	[%r16, + 0x07c4] %asi, %r20
	.word 0xc6042b10  ! 1: LDUW_I	lduw	[%r16 + 0x0b10], %r3
	.word 0xfc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r30
	brnz %r31,thr3_loop_cnt_907
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x21, %r31
thr3_loop_cnt_908:
	.word 0xc6cc2a7e  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a7e] %asi, %r3
	.word 0xd2442d78  ! 1: LDSW_I	ldsw	[%r16 + 0x0d78], %r9
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf45c22a8  ! 1: LDX_I	ldx	[%r16 + 0x02a8], %r26
	.word 0xd4cc2c1e  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c1e] %asi, %r10
	.word 0xd60c20f4  ! 1: LDUB_I	ldub	[%r16 + 0x00f4], %r11
	.word 0xd6042b0c  ! 1: LDUW_I	lduw	[%r16 + 0x0b0c], %r11
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_908
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0x97, %r31
thr3_loop_cnt_909:
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xfc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r30
	.word 0xe8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r20
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r19
	.word 0xea0c216d  ! 1: LDUB_I	ldub	[%r16 + 0x016d], %r21
	.word 0xeac428ac  ! 1: LDSWA_I	ldswa	[%r16, + 0x08ac] %asi, %r21
	.word 0xc6842218  ! 1: LDUWA_I	lduwa	[%r16, + 0x0218] %asi, %r3
	.word 0xc6dc2d98  ! 1: LDXA_I	ldxa	[%r16, + 0x0d98] %asi, %r3
	brnz %r31,thr3_loop_cnt_909
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0x65, %r31
thr3_loop_cnt_910:
	.word 0xc64c219f  ! 1: LDSB_I	ldsb	[%r16 + 0x019f], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xec5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r22
	.word 0xc64c2413  ! 1: LDSB_I	ldsb	[%r16 + 0x0413], %r3
	.word 0xcc4c2e1f  ! 1: LDSB_I	ldsb	[%r16 + 0x0e1f], %r6
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xdc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r14
	.word 0xc65c2b68  ! 1: LDX_I	ldx	[%r16 + 0x0b68], %r3
	.word 0xec140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r22
	.word 0xde942f54  ! 1: LDUHA_I	lduha	[%r16, + 0x0f54] %asi, %r15
	.word 0xea040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r21
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_910
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0xb5, %r31
thr3_loop_cnt_911:
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xce9420b8  ! 1: LDUHA_I	lduha	[%r16, + 0x00b8] %asi, %r7
	.word 0xdcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r14
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xd24c20f6  ! 1: LDSB_I	ldsb	[%r16 + 0x00f6], %r9
	.word 0xd4dc2a30  ! 1: LDXA_I	ldxa	[%r16, + 0x0a30] %asi, %r10
	.word 0xc6842950  ! 1: LDUWA_I	lduwa	[%r16, + 0x0950] %asi, %r3
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	.word 0xc6042484  ! 1: LDUW_I	lduw	[%r16 + 0x0484], %r3
	.word 0xe6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r19
	brnz %r31,thr3_loop_cnt_911
	dec %r31
	.word 0xb0342916  ! 1: ORN_I	orn 	%r16, 0x0916, %r24
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x77, %r31
thr3_loop_cnt_912:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xee842400  ! 1: LDUWA_I	lduwa	[%r16, + 0x0400] %asi, %r23
	.word 0xfcc42638  ! 1: LDSWA_I	ldswa	[%r16, + 0x0638] %asi, %r30
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xc6842d78  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d78] %asi, %r3
	.word 0xd4442c88  ! 1: LDSW_I	ldsw	[%r16 + 0x0c88], %r10
	.word 0xf40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r26
	.word 0xccdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r6
	.word 0xde4c274d  ! 1: LDSB_I	ldsb	[%r16 + 0x074d], %r15
	brnz %r31,thr3_loop_cnt_912
	dec %r31
	.word 0x863425a2  ! 1: SUBC_I	orn 	%r16, 0x05a2, %r3
	.word 0x96142482  ! 1: OR_I	or 	%r16, 0x0482, %r11
	.word 0x921c0002  ! 1: XOR_R	xor 	%r16, %r2, %r9
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x9f, %r31
thr3_loop_cnt_913:
	.word 0xccdc2a28  ! 1: LDXA_I	ldxa	[%r16, + 0x0a28] %asi, %r6
	.word 0xc68c2875  ! 1: LDUBA_I	lduba	[%r16, + 0x0875] %asi, %r3
	.word 0xf4942832  ! 1: LDUHA_I	lduha	[%r16, + 0x0832] %asi, %r26
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xe80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r20
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc68c2cc7  ! 1: LDUBA_I	lduba	[%r16, + 0x0cc7] %asi, %r3
	.word 0xf8dc2950  ! 1: LDXA_I	ldxa	[%r16, + 0x0950] %asi, %r28
	.word 0xce040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r7
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6842ff8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ff8] %asi, %r3
	.word 0xf60420bc  ! 1: LDUW_I	lduw	[%r16 + 0x00bc], %r27
	brnz %r31,thr3_loop_cnt_913
	dec %r31
	.word 0x9444250b  ! 1: ADDC_I	addc 	%r16, 0x050b, %r10
	.word 0x97343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r11
	.word 0x92140002  ! 1: OR_R	or 	%r16, %r2, %r9
        mov 0x52, %r31
thr3_loop_cnt_914:
	.word 0xe6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r19
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2ef8  ! 1: LDXA_I	ldxa	[%r16, + 0x0ef8] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	.word 0xea0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r21
	.word 0xfa8c2f22  ! 1: LDUBA_I	lduba	[%r16, + 0x0f22] %asi, %r29
	.word 0xc6c42c40  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c40] %asi, %r3
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	.word 0xe85c2d20  ! 1: LDX_I	ldx	[%r16 + 0x0d20], %r20
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	brnz %r31,thr3_loop_cnt_914
	dec %r31
        mov 0x22, %r31
thr3_loop_cnt_915:
	.word 0xc60c2d7d  ! 1: LDUB_I	ldub	[%r16 + 0x0d7d], %r3
	.word 0xfc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r30
	.word 0xd8442a14  ! 1: LDSW_I	ldsw	[%r16 + 0x0a14], %r12
	.word 0xf48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r26
	.word 0xea0c2007  ! 1: LDUB_I	ldub	[%r16 + 0x0007], %r21
	.word 0xc64c2494  ! 1: LDSB_I	ldsb	[%r16 + 0x0494], %r3
	.word 0xc6c42860  ! 1: LDSWA_I	ldswa	[%r16, + 0x0860] %asi, %r3
	.word 0xeedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r23
	brnz %r31,thr3_loop_cnt_915
	dec %r31
	.word 0xa43c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r18
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
        mov 0x62, %r31
thr3_loop_cnt_916:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xdadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r13
	.word 0xd40427c8  ! 1: LDUW_I	lduw	[%r16 + 0x07c8], %r10
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc64c2715  ! 1: LDSB_I	ldsb	[%r16 + 0x0715], %r3
	.word 0xc68c2b8f  ! 1: LDUBA_I	lduba	[%r16, + 0x0b8f] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf24c27c9  ! 1: LDSB_I	ldsb	[%r16 + 0x07c9], %r25
	.word 0xd0542244  ! 1: LDSH_I	ldsh	[%r16 + 0x0244], %r8
	.word 0xc6d4224e  ! 1: LDSHA_I	ldsha	[%r16, + 0x024e] %asi, %r3
	brnz %r31,thr3_loop_cnt_916
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x72, %r31
thr3_loop_cnt_917:
	.word 0xec14251e  ! 1: LDUH_I	lduh	[%r16 + 0x051e], %r22
	.word 0xc68c2e09  ! 1: LDUBA_I	lduba	[%r16, + 0x0e09] %asi, %r3
	.word 0xc6d42072  ! 1: LDSHA_I	ldsha	[%r16, + 0x0072] %asi, %r3
	.word 0xc65427ec  ! 1: LDSH_I	ldsh	[%r16 + 0x07ec], %r3
	.word 0xc61420fa  ! 1: LDUH_I	lduh	[%r16 + 0x00fa], %r3
	.word 0xd6dc22c8  ! 1: LDXA_I	ldxa	[%r16, + 0x02c8] %asi, %r11
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xce0c2fc6  ! 1: LDUB_I	ldub	[%r16 + 0x0fc6], %r7
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_917
	dec %r31
	.word 0xa6240002  ! 1: SUB_R	sub 	%r16, %r2, %r19
        mov 0xb8, %r31
thr3_loop_cnt_918:
	.word 0xdedc2ad8  ! 1: LDXA_I	ldxa	[%r16, + 0x0ad8] %asi, %r15
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xfa8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r29
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe20c2084  ! 1: LDUB_I	ldub	[%r16 + 0x0084], %r17
	.word 0xc64422a8  ! 1: LDSW_I	ldsw	[%r16 + 0x02a8], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r27
	brnz %r31,thr3_loop_cnt_918
	dec %r31
	.word 0x860c26f5  ! 1: AND_I	and 	%r16, 0x06f5, %r3
	.word 0xa9341002  ! 1: SRLX_R	srlx	%r16, %r2, %r20
	.word 0x92040002  ! 1: ADD_R	add 	%r16, %r2, %r9
        mov 0x5d, %r31
thr3_loop_cnt_919:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r26
	.word 0xccdc2958  ! 1: LDXA_I	ldxa	[%r16, + 0x0958] %asi, %r6
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r24
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6cc230b  ! 1: LDSBA_I	ldsba	[%r16, + 0x030b] %asi, %r3
	.word 0xd4dc2e60  ! 1: LDXA_I	ldxa	[%r16, + 0x0e60] %asi, %r10
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xea442bd4  ! 1: LDSW_I	ldsw	[%r16 + 0x0bd4], %r21
	.word 0xf6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r27
	.word 0xfad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r29
	brnz %r31,thr3_loop_cnt_919
	dec %r31
	.word 0x860c297f  ! 1: AND_I	and 	%r16, 0x097f, %r3
	.word 0x98240002  ! 1: SUB_R	sub 	%r16, %r2, %r12
        mov 0xb8, %r31
thr3_loop_cnt_920:
	.word 0xc6dc2008  ! 1: LDXA_I	ldxa	[%r16, + 0x0008] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc65c2f40  ! 1: LDX_I	ldx	[%r16 + 0x0f40], %r3
	.word 0xf6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r27
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xded42e7a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e7a] %asi, %r15
	.word 0xf24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r25
	.word 0xd0d42730  ! 1: LDSHA_I	ldsha	[%r16, + 0x0730] %asi, %r8
	brnz %r31,thr3_loop_cnt_920
	dec %r31
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
        mov 0x25, %r31
thr3_loop_cnt_921:
	.word 0xdad42730  ! 1: LDSHA_I	ldsha	[%r16, + 0x0730] %asi, %r13
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd2942a7a  ! 1: LDUHA_I	lduha	[%r16, + 0x0a7a] %asi, %r9
	.word 0xc6442940  ! 1: LDSW_I	ldsw	[%r16 + 0x0940], %r3
	.word 0xc64c24e3  ! 1: LDSB_I	ldsb	[%r16 + 0x04e3], %r3
	.word 0xc6442d64  ! 1: LDSW_I	ldsw	[%r16 + 0x0d64], %r3
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	.word 0xc6dc2070  ! 1: LDXA_I	ldxa	[%r16, + 0x0070] %asi, %r3
	.word 0xc64c20e0  ! 1: LDSB_I	ldsb	[%r16 + 0x00e0], %r3
	.word 0xd8542f76  ! 1: LDSH_I	ldsh	[%r16 + 0x0f76], %r12
	.word 0xc6c42be8  ! 1: LDSWA_I	ldswa	[%r16, + 0x0be8] %asi, %r3
	.word 0xfc4c21db  ! 1: LDSB_I	ldsb	[%r16 + 0x01db], %r30
	brnz %r31,thr3_loop_cnt_921
	dec %r31
	.word 0x9e240002  ! 1: SUB_R	sub 	%r16, %r2, %r15
	.word 0xaa4426bb  ! 1: ADDC_I	addc 	%r16, 0x06bb, %r21
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x16, %r31
thr3_loop_cnt_922:
	.word 0xcc0422e4  ! 1: LDUW_I	lduw	[%r16 + 0x02e4], %r6
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xfc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r30
	.word 0xd8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r12
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf84c27e5  ! 1: LDSB_I	ldsb	[%r16 + 0x07e5], %r28
	.word 0xfacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r29
	.word 0xf2942818  ! 1: LDUHA_I	lduha	[%r16, + 0x0818] %asi, %r25
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_922
	dec %r31
        mov 0xb8, %r31
thr3_loop_cnt_923:
	.word 0xf05c2d00  ! 1: LDX_I	ldx	[%r16 + 0x0d00], %r24
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xec4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r22
	.word 0xfad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r29
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xcc4c27df  ! 1: LDSB_I	ldsb	[%r16 + 0x07df], %r6
	.word 0xd4d4242a  ! 1: LDSHA_I	ldsha	[%r16, + 0x042a] %asi, %r10
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r27
	brnz %r31,thr3_loop_cnt_923
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x860422ec  ! 1: ADD_I	add 	%r16, 0x02ec, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0x55, %r31
thr3_loop_cnt_924:
	.word 0xc6142238  ! 1: LDUH_I	lduh	[%r16 + 0x0238], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc64c2520  ! 1: LDSB_I	ldsb	[%r16 + 0x0520], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6142b84  ! 1: LDUH_I	lduh	[%r16 + 0x0b84], %r3
	.word 0xda5c2e98  ! 1: LDX_I	ldx	[%r16 + 0x0e98], %r13
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xfa942e20  ! 1: LDUHA_I	lduha	[%r16, + 0x0e20] %asi, %r29
	.word 0xe6842fcc  ! 1: LDUWA_I	lduwa	[%r16, + 0x0fcc] %asi, %r19
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xc6542614  ! 1: LDSH_I	ldsh	[%r16 + 0x0614], %r3
	brnz %r31,thr3_loop_cnt_924
	dec %r31
	.word 0xb0040002  ! 1: ADD_R	add 	%r16, %r2, %r24
	.word 0x943c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r10
        mov 0xc0, %r31
thr3_loop_cnt_925:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xda440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r13
	.word 0xc6c42bfc  ! 1: LDSWA_I	ldswa	[%r16, + 0x0bfc] %asi, %r3
	.word 0xf4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r26
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xee4c2563  ! 1: LDSB_I	ldsb	[%r16 + 0x0563], %r23
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf88c267a  ! 1: LDUBA_I	lduba	[%r16, + 0x067a] %asi, %r28
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_925
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0xb2040002  ! 1: ADD_R	add 	%r16, %r2, %r25
	.word 0x8634270f  ! 1: SUBC_I	orn 	%r16, 0x070f, %r3
        mov 0x55, %r31
thr3_loop_cnt_926:
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	.word 0xd65c25a0  ! 1: LDX_I	ldx	[%r16 + 0x05a0], %r11
	.word 0xea4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r21
	.word 0xea440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r21
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd8942d1c  ! 1: LDUHA_I	lduha	[%r16, + 0x0d1c] %asi, %r12
	.word 0xdc542bb4  ! 1: LDSH_I	ldsh	[%r16 + 0x0bb4], %r14
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe20c2dae  ! 1: LDUB_I	ldub	[%r16 + 0x0dae], %r17
	brnz %r31,thr3_loop_cnt_926
	dec %r31
	.word 0xa6040002  ! 1: ADD_R	add 	%r16, %r2, %r19
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0x67, %r31
thr3_loop_cnt_927:
	.word 0xc6142c02  ! 1: LDUH_I	lduh	[%r16 + 0x0c02], %r3
	.word 0xd4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r10
	.word 0xd08423c0  ! 1: LDUWA_I	lduwa	[%r16, + 0x03c0] %asi, %r8
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6542ada  ! 1: LDSH_I	ldsh	[%r16 + 0x0ada], %r3
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	.word 0xf89425e2  ! 1: LDUHA_I	lduha	[%r16, + 0x05e2] %asi, %r28
	.word 0xd8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r12
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6842e38  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e38] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_927
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0xac0c284e  ! 1: AND_I	and 	%r16, 0x084e, %r22
	.word 0x8e040002  ! 1: ADD_R	add 	%r16, %r2, %r7
	.word 0x90040002  ! 1: ADD_R	add 	%r16, %r2, %r8
        mov 0x8b, %r31
thr3_loop_cnt_928:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xea540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r21
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6cc219b  ! 1: LDSBA_I	ldsba	[%r16, + 0x019b] %asi, %r3
	.word 0xda4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r13
	.word 0xeadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r21
	.word 0xc6942764  ! 1: LDUHA_I	lduha	[%r16, + 0x0764] %asi, %r3
	.word 0xe6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r19
	brnz %r31,thr3_loop_cnt_928
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x86142af2  ! 1: OR_I	or 	%r16, 0x0af2, %r3
        mov 0x83, %r31
thr3_loop_cnt_929:
	.word 0xd4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r10
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xcc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r6
	.word 0xd4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r10
	.word 0xce542436  ! 1: LDSH_I	ldsh	[%r16 + 0x0436], %r7
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf4d421b4  ! 1: LDSHA_I	ldsha	[%r16, + 0x01b4] %asi, %r26
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6842720  ! 1: LDUWA_I	lduwa	[%r16, + 0x0720] %asi, %r3
	.word 0xc64425dc  ! 1: LDSW_I	ldsw	[%r16 + 0x05dc], %r3
	.word 0xd4942cd0  ! 1: LDUHA_I	lduha	[%r16, + 0x0cd0] %asi, %r10
	brnz %r31,thr3_loop_cnt_929
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0xae1c2e38  ! 1: XOR_I	xor 	%r16, 0x0e38, %r23
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0x98, %r31
thr3_loop_cnt_930:
	.word 0xcc8c20f2  ! 1: LDUBA_I	lduba	[%r16, + 0x00f2] %asi, %r6
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xfc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r30
	.word 0xfa8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r29
	.word 0xd65c2b60  ! 1: LDX_I	ldx	[%r16 + 0x0b60], %r11
	.word 0xda5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r13
	.word 0xfc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r30
	.word 0xde1421de  ! 1: LDUH_I	lduh	[%r16 + 0x01de], %r15
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc68c2ff2  ! 1: LDUBA_I	lduba	[%r16, + 0x0ff2] %asi, %r3
	brnz %r31,thr3_loop_cnt_930
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0xae142d67  ! 1: OR_I	or 	%r16, 0x0d67, %r23
	.word 0x91342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r8
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x3, %r31
thr3_loop_cnt_931:
	.word 0xea84211c  ! 1: LDUWA_I	lduwa	[%r16, + 0x011c] %asi, %r21
	.word 0xde54209e  ! 1: LDSH_I	ldsh	[%r16 + 0x009e], %r15
	.word 0xc6042b18  ! 1: LDUW_I	lduw	[%r16 + 0x0b18], %r3
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xe20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r17
	.word 0xfc9428d4  ! 1: LDUHA_I	lduha	[%r16, + 0x08d4] %asi, %r30
	.word 0xc6142d48  ! 1: LDUH_I	lduh	[%r16 + 0x0d48], %r3
	.word 0xd6542810  ! 1: LDSH_I	ldsh	[%r16 + 0x0810], %r11
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	.word 0xc6d42708  ! 1: LDSHA_I	ldsha	[%r16, + 0x0708] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_931
	dec %r31
	.word 0xbb343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r29
        mov 0xb3, %r31
thr3_loop_cnt_932:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd28c28c8  ! 1: LDUBA_I	lduba	[%r16, + 0x08c8] %asi, %r9
	.word 0xd8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r12
	.word 0xc6dc2fa8  ! 1: LDXA_I	ldxa	[%r16, + 0x0fa8] %asi, %r3
	.word 0xe8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r20
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xde8c263b  ! 1: LDUBA_I	lduba	[%r16, + 0x063b] %asi, %r15
	.word 0xc60c2370  ! 1: LDUB_I	ldub	[%r16 + 0x0370], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_932
	dec %r31
	.word 0x96240002  ! 1: SUB_R	sub 	%r16, %r2, %r11
        mov 0x9b, %r31
thr3_loop_cnt_933:
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd2c42540  ! 1: LDSWA_I	ldswa	[%r16, + 0x0540] %asi, %r9
	.word 0xc68c2ecc  ! 1: LDUBA_I	lduba	[%r16, + 0x0ecc] %asi, %r3
	.word 0xea841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r21
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6c42e9c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e9c] %asi, %r3
	.word 0xea4c286e  ! 1: LDSB_I	ldsb	[%r16 + 0x086e], %r21
	brnz %r31,thr3_loop_cnt_933
	dec %r31
	.word 0xa5342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r18
        mov 0x6f, %r31
thr3_loop_cnt_934:
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf4942d26  ! 1: LDUHA_I	lduha	[%r16, + 0x0d26] %asi, %r26
	.word 0xe80c2fa1  ! 1: LDUB_I	ldub	[%r16 + 0x0fa1], %r20
	.word 0xc6442b88  ! 1: LDSW_I	ldsw	[%r16 + 0x0b88], %r3
	.word 0xce442158  ! 1: LDSW_I	ldsw	[%r16 + 0x0158], %r7
	.word 0xded42c48  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c48] %asi, %r15
	.word 0xc6cc2ff7  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ff7] %asi, %r3
	.word 0xf8d42520  ! 1: LDSHA_I	ldsha	[%r16, + 0x0520] %asi, %r28
	.word 0xc6dc2360  ! 1: LDXA_I	ldxa	[%r16, + 0x0360] %asi, %r3
	brnz %r31,thr3_loop_cnt_934
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x86342020  ! 1: SUBC_I	orn 	%r16, 0x0020, %r3
	.word 0xab3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r21
        mov 0x60, %r31
thr3_loop_cnt_935:
	.word 0xdacc2370  ! 1: LDSBA_I	ldsba	[%r16, + 0x0370] %asi, %r13
	.word 0xc6dc2c18  ! 1: LDXA_I	ldxa	[%r16, + 0x0c18] %asi, %r3
	.word 0xc60c2d2b  ! 1: LDUB_I	ldub	[%r16 + 0x0d2b], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xfad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r29
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d42db0  ! 1: LDSHA_I	ldsha	[%r16, + 0x0db0] %asi, %r3
	brnz %r31,thr3_loop_cnt_935
	dec %r31
	.word 0xa2442f61  ! 1: ADDC_I	addc 	%r16, 0x0f61, %r17
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x861c2443  ! 1: XOR_I	xor 	%r16, 0x0443, %r3
        mov 0x5f, %r31
thr3_loop_cnt_936:
	.word 0xee040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r23
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xf2cc29bf  ! 1: LDSBA_I	ldsba	[%r16, + 0x09bf] %asi, %r25
	.word 0xecd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r22
	.word 0xc6142bc2  ! 1: LDUH_I	lduh	[%r16 + 0x0bc2], %r3
	.word 0xea4c2867  ! 1: LDSB_I	ldsb	[%r16 + 0x0867], %r21
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd6c42810  ! 1: LDSWA_I	ldswa	[%r16, + 0x0810] %asi, %r11
	.word 0xc64c2505  ! 1: LDSB_I	ldsb	[%r16 + 0x0505], %r3
	.word 0xc65c25c8  ! 1: LDX_I	ldx	[%r16 + 0x05c8], %r3
	.word 0xc68420e0  ! 1: LDUWA_I	lduwa	[%r16, + 0x00e0] %asi, %r3
	brnz %r31,thr3_loop_cnt_936
	dec %r31
	.word 0xae042ebc  ! 1: ADD_I	add 	%r16, 0x0ebc, %r23
	.word 0xae340002  ! 1: ORN_R	orn 	%r16, %r2, %r23
	.word 0xa4440002  ! 1: ADDC_R	addc 	%r16, %r2, %r18
        mov 0x89, %r31
thr3_loop_cnt_937:
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xf2542152  ! 1: LDSH_I	ldsh	[%r16 + 0x0152], %r25
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r11
	.word 0xc60c2078  ! 1: LDUB_I	ldub	[%r16 + 0x0078], %r3
	.word 0xe40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r18
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xc64c2d4f  ! 1: LDSB_I	ldsb	[%r16 + 0x0d4f], %r3
	.word 0xd40c2186  ! 1: LDUB_I	ldub	[%r16 + 0x0186], %r10
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xda9429ce  ! 1: LDUHA_I	lduha	[%r16, + 0x09ce] %asi, %r13
	brnz %r31,thr3_loop_cnt_937
	dec %r31
        mov 0xbc, %r31
thr3_loop_cnt_938:
	.word 0xdad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r13
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc24dd  ! 1: LDSBA_I	ldsba	[%r16, + 0x04dd] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xde841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r15
	.word 0xce0429fc  ! 1: LDUW_I	lduw	[%r16 + 0x09fc], %r7
	.word 0xd0dc2c68  ! 1: LDXA_I	ldxa	[%r16, + 0x0c68] %asi, %r8
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc654276e  ! 1: LDSH_I	ldsh	[%r16 + 0x076e], %r3
	brnz %r31,thr3_loop_cnt_938
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0xb6142112  ! 1: OR_I	or 	%r16, 0x0112, %r27
	.word 0x9d2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r14
        mov 0x98, %r31
thr3_loop_cnt_939:
	.word 0xc6dc2980  ! 1: LDXA_I	ldxa	[%r16, + 0x0980] %asi, %r3
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r17
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r8
	.word 0xf4dc2a80  ! 1: LDXA_I	ldxa	[%r16, + 0x0a80] %asi, %r26
	brnz %r31,thr3_loop_cnt_939
	dec %r31
	.word 0x8f3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r7
	.word 0xa53c1002  ! 1: SRAX_R	srax	%r16, %r2, %r18
	.word 0x8c440002  ! 1: ADDC_R	addc 	%r16, %r2, %r6
	.word 0xae242f63  ! 1: SUB_I	sub 	%r16, 0x0f63, %r23
        mov 0x29, %r31
thr3_loop_cnt_940:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xe8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r20
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xfc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r30
	.word 0xc6cc2c40  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c40] %asi, %r3
	.word 0xec8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r22
	.word 0xc644291c  ! 1: LDSW_I	ldsw	[%r16 + 0x091c], %r3
	.word 0xd0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r8
	.word 0xec0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r22
	.word 0xf6142248  ! 1: LDUH_I	lduh	[%r16 + 0x0248], %r27
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_940
	dec %r31
        mov 0x56, %r31
thr3_loop_cnt_941:
	.word 0xe2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r17
	.word 0xd4842f5c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f5c] %asi, %r10
	.word 0xe2d427d8  ! 1: LDSHA_I	ldsha	[%r16, + 0x07d8] %asi, %r17
	.word 0xeecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r23
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc68c22b7  ! 1: LDUBA_I	lduba	[%r16, + 0x02b7] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd28c2230  ! 1: LDUBA_I	lduba	[%r16, + 0x0230] %asi, %r9
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	brnz %r31,thr3_loop_cnt_941
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x980420d3  ! 1: ADD_I	add 	%r16, 0x00d3, %r12
        mov 0x63, %r31
thr3_loop_cnt_942:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6442c74  ! 1: LDSW_I	ldsw	[%r16 + 0x0c74], %r3
	.word 0xc65c2f98  ! 1: LDX_I	ldx	[%r16 + 0x0f98], %r3
	.word 0xe28c2a3a  ! 1: LDUBA_I	lduba	[%r16, + 0x0a3a] %asi, %r17
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6d4263e  ! 1: LDSHA_I	ldsha	[%r16, + 0x063e] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xda0423ec  ! 1: LDUW_I	lduw	[%r16 + 0x03ec], %r13
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d423c6  ! 1: LDSHA_I	ldsha	[%r16, + 0x03c6] %asi, %r3
	.word 0xc694290a  ! 1: LDUHA_I	lduha	[%r16, + 0x090a] %asi, %r3
	brnz %r31,thr3_loop_cnt_942
	dec %r31
        mov 0x82, %r31
thr3_loop_cnt_943:
	.word 0xe604222c  ! 1: LDUW_I	lduw	[%r16 + 0x022c], %r19
	.word 0xfc442944  ! 1: LDSW_I	ldsw	[%r16 + 0x0944], %r30
	.word 0xd8542a80  ! 1: LDSH_I	ldsh	[%r16 + 0x0a80], %r12
	.word 0xf6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r27
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	.word 0xf6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r27
	.word 0xc69428c0  ! 1: LDUHA_I	lduha	[%r16, + 0x08c0] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_943
	dec %r31
	.word 0x861420d3  ! 1: OR_I	or 	%r16, 0x00d3, %r3
	.word 0x861c233c  ! 1: XOR_I	xor 	%r16, 0x033c, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0x43, %r31
thr3_loop_cnt_944:
	.word 0xe4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r18
	.word 0xe60422ec  ! 1: LDUW_I	lduw	[%r16 + 0x02ec], %r19
	.word 0xe2d42e06  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e06] %asi, %r17
	.word 0xee442ae4  ! 1: LDSW_I	ldsw	[%r16 + 0x0ae4], %r23
	.word 0xf6d4209a  ! 1: LDSHA_I	ldsha	[%r16, + 0x009a] %asi, %r27
	.word 0xf48c2112  ! 1: LDUBA_I	lduba	[%r16, + 0x0112] %asi, %r26
	.word 0xd84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r12
	.word 0xc6c424a4  ! 1: LDSWA_I	ldswa	[%r16, + 0x04a4] %asi, %r3
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xf4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r26
	.word 0xc6d42fc0  ! 1: LDSHA_I	ldsha	[%r16, + 0x0fc0] %asi, %r3
	brnz %r31,thr3_loop_cnt_944
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0xbf, %r31
thr3_loop_cnt_945:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xce0429c4  ! 1: LDUW_I	lduw	[%r16 + 0x09c4], %r7
	.word 0xec941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r22
	.word 0xec5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r22
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xec8c22d2  ! 1: LDUBA_I	lduba	[%r16, + 0x02d2] %asi, %r22
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xde5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r15
	.word 0xe6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r19
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_945
	dec %r31
	.word 0x993c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r12
        mov 0x57, %r31
thr3_loop_cnt_946:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf2442684  ! 1: LDSW_I	ldsw	[%r16 + 0x0684], %r25
	.word 0xce4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r7
	.word 0xea8c288e  ! 1: LDUBA_I	lduba	[%r16, + 0x088e] %asi, %r21
	.word 0xf244276c  ! 1: LDSW_I	ldsw	[%r16 + 0x076c], %r25
	.word 0xe2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r17
	.word 0xf40c2ad3  ! 1: LDUB_I	ldub	[%r16 + 0x0ad3], %r26
	.word 0xc6542c8e  ! 1: LDSH_I	ldsh	[%r16 + 0x0c8e], %r3
	brnz %r31,thr3_loop_cnt_946
	dec %r31
	.word 0x98040002  ! 1: ADD_R	add 	%r16, %r2, %r12
	.word 0x96340002  ! 1: ORN_R	orn 	%r16, %r2, %r11
        mov 0x9a, %r31
thr3_loop_cnt_947:
	.word 0xd2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r9
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6542fc2  ! 1: LDSH_I	ldsh	[%r16 + 0x0fc2], %r3
	.word 0xc65c2380  ! 1: LDX_I	ldx	[%r16 + 0x0380], %r3
	.word 0xe4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r18
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	.word 0xdccc27ae  ! 1: LDSBA_I	ldsba	[%r16, + 0x07ae] %asi, %r14
	brnz %r31,thr3_loop_cnt_947
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x5c, %r31
thr3_loop_cnt_948:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xcc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r6
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xfa5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r29
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xc6d424f6  ! 1: LDSHA_I	ldsha	[%r16, + 0x04f6] %asi, %r3
	.word 0xc6842374  ! 1: LDUWA_I	lduwa	[%r16, + 0x0374] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd4cc2da1  ! 1: LDSBA_I	ldsba	[%r16, + 0x0da1] %asi, %r10
	.word 0xc68c2538  ! 1: LDUBA_I	lduba	[%r16, + 0x0538] %asi, %r3
	brnz %r31,thr3_loop_cnt_948
	dec %r31
	.word 0x9c340002  ! 1: ORN_R	orn 	%r16, %r2, %r14
	.word 0x86442c20  ! 1: ADDC_I	addc 	%r16, 0x0c20, %r3
	.word 0x913c0002  ! 1: SRA_R	sra 	%r16, %r2, %r8
	.word 0x993c0002  ! 1: SRA_R	sra 	%r16, %r2, %r12
        mov 0x17, %r31
thr3_loop_cnt_949:
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xc6cc2ea4  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ea4] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r25
	.word 0xfa0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r29
	.word 0xfc8c2133  ! 1: LDUBA_I	lduba	[%r16, + 0x0133] %asi, %r30
	.word 0xdc042ba8  ! 1: LDUW_I	lduw	[%r16 + 0x0ba8], %r14
	.word 0xc61424de  ! 1: LDUH_I	lduh	[%r16 + 0x04de], %r3
	.word 0xc6dc2568  ! 1: LDXA_I	ldxa	[%r16, + 0x0568] %asi, %r3
	.word 0xc60c2b7a  ! 1: LDUB_I	ldub	[%r16 + 0x0b7a], %r3
	brnz %r31,thr3_loop_cnt_949
	dec %r31
        mov 0xc4, %r31
thr3_loop_cnt_950:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6042c4c  ! 1: LDUW_I	lduw	[%r16 + 0x0c4c], %r3
	.word 0xf6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r27
	.word 0xc6dc21e8  ! 1: LDXA_I	ldxa	[%r16, + 0x01e8] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c2d6a  ! 1: LDSB_I	ldsb	[%r16 + 0x0d6a], %r3
	.word 0xf6942046  ! 1: LDUHA_I	lduha	[%r16, + 0x0046] %asi, %r27
	.word 0xee942f80  ! 1: LDUHA_I	lduha	[%r16, + 0x0f80] %asi, %r23
	.word 0xc6c4291c  ! 1: LDSWA_I	ldswa	[%r16, + 0x091c] %asi, %r3
	.word 0xc6c42bd0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0bd0] %asi, %r3
	.word 0xda140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r13
	.word 0xeedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r23
	brnz %r31,thr3_loop_cnt_950
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0xbb342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r29
        mov 0x25, %r31
thr3_loop_cnt_951:
	.word 0xc6dc2cb0  ! 1: LDXA_I	ldxa	[%r16, + 0x0cb0] %asi, %r3
	.word 0xc6442030  ! 1: LDSW_I	ldsw	[%r16 + 0x0030], %r3
	.word 0xc6842a20  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a20] %asi, %r3
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xe6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r19
	.word 0xe6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r19
	.word 0xf0042198  ! 1: LDUW_I	lduw	[%r16 + 0x0198], %r24
	.word 0xecc420a4  ! 1: LDSWA_I	ldswa	[%r16, + 0x00a4] %asi, %r22
	brnz %r31,thr3_loop_cnt_951
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x863c2af8  ! 1: XNOR_I	xnor 	%r16, 0x0af8, %r3
        mov 0x28, %r31
thr3_loop_cnt_952:
	.word 0xee540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r23
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6d42adc  ! 1: LDSHA_I	ldsha	[%r16, + 0x0adc] %asi, %r3
	.word 0xda4421c8  ! 1: LDSW_I	ldsw	[%r16 + 0x01c8], %r13
	.word 0xd28c2251  ! 1: LDUBA_I	lduba	[%r16, + 0x0251] %asi, %r9
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_952
	dec %r31
        mov 0x57, %r31
thr3_loop_cnt_953:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2d50  ! 1: LDXA_I	ldxa	[%r16, + 0x0d50] %asi, %r3
	.word 0xd20c2f9a  ! 1: LDUB_I	ldub	[%r16 + 0x0f9a], %r9
	.word 0xea042c18  ! 1: LDUW_I	lduw	[%r16 + 0x0c18], %r21
	.word 0xcedc2fb0  ! 1: LDXA_I	ldxa	[%r16, + 0x0fb0] %asi, %r7
	.word 0xf65429b0  ! 1: LDSH_I	ldsh	[%r16 + 0x09b0], %r27
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_953
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0xb43c274a  ! 1: XNOR_I	xnor 	%r16, 0x074a, %r26
        mov 0xb, %r31
thr3_loop_cnt_954:
	.word 0xc64c2b4a  ! 1: LDSB_I	ldsb	[%r16 + 0x0b4a], %r3
	.word 0xc64c27d4  ! 1: LDSB_I	ldsb	[%r16 + 0x07d4], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc61422fc  ! 1: LDUH_I	lduh	[%r16 + 0x02fc], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc64c2bd9  ! 1: LDSB_I	ldsb	[%r16 + 0x0bd9], %r3
	.word 0xe8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r20
	.word 0xc6942cf2  ! 1: LDUHA_I	lduha	[%r16, + 0x0cf2] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_954
	dec %r31
	.word 0xbd340002  ! 1: SRL_R	srl 	%r16, %r2, %r30
        mov 0x16, %r31
thr3_loop_cnt_955:
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	.word 0xc60c2350  ! 1: LDUB_I	ldub	[%r16 + 0x0350], %r3
	.word 0xd4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r10
	.word 0xd0442014  ! 1: LDSW_I	ldsw	[%r16 + 0x0014], %r8
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r28
	.word 0xe84427ac  ! 1: LDSW_I	ldsw	[%r16 + 0x07ac], %r20
	.word 0xc6142120  ! 1: LDUH_I	lduh	[%r16 + 0x0120], %r3
	brnz %r31,thr3_loop_cnt_955
	dec %r31
	.word 0x9f3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r15
        mov 0x7f, %r31
thr3_loop_cnt_956:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd61426ec  ! 1: LDUH_I	lduh	[%r16 + 0x06ec], %r11
	.word 0xf04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r24
	.word 0xc68c2a15  ! 1: LDUBA_I	lduba	[%r16, + 0x0a15] %asi, %r3
	.word 0xe4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r18
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc654231c  ! 1: LDSH_I	ldsh	[%r16 + 0x031c], %r3
	.word 0xd4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r10
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xc6c42c2c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c2c] %asi, %r3
	brnz %r31,thr3_loop_cnt_956
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x4b, %r31
thr3_loop_cnt_957:
	.word 0xc6c424dc  ! 1: LDSWA_I	ldswa	[%r16, + 0x04dc] %asi, %r3
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd6dc22a8  ! 1: LDXA_I	ldxa	[%r16, + 0x02a8] %asi, %r11
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc68c2349  ! 1: LDUBA_I	lduba	[%r16, + 0x0349] %asi, %r3
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	.word 0xd2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r9
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_957
	dec %r31
        mov 0x7b, %r31
thr3_loop_cnt_958:
	.word 0xf4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r26
	.word 0xfa1423ce  ! 1: LDUH_I	lduh	[%r16 + 0x03ce], %r29
	.word 0xe64424f4  ! 1: LDSW_I	ldsw	[%r16 + 0x04f4], %r19
	.word 0xc69423ae  ! 1: LDUHA_I	lduha	[%r16, + 0x03ae] %asi, %r3
	.word 0xe8c422a0  ! 1: LDSWA_I	ldswa	[%r16, + 0x02a0] %asi, %r20
	.word 0xda0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r13
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r28
	.word 0xe2442b04  ! 1: LDSW_I	ldsw	[%r16 + 0x0b04], %r17
	brnz %r31,thr3_loop_cnt_958
	dec %r31
        mov 0x6b, %r31
thr3_loop_cnt_959:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d42118  ! 1: LDSHA_I	ldsha	[%r16, + 0x0118] %asi, %r3
	.word 0xc6142352  ! 1: LDUH_I	lduh	[%r16 + 0x0352], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6cc2c2c  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c2c] %asi, %r3
	.word 0xc60c2314  ! 1: LDUB_I	ldub	[%r16 + 0x0314], %r3
	.word 0xf8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r28
	.word 0xd0dc24c0  ! 1: LDXA_I	ldxa	[%r16, + 0x04c0] %asi, %r8
	.word 0xc65c2758  ! 1: LDX_I	ldx	[%r16 + 0x0758], %r3
	.word 0xc6c42bdc  ! 1: LDSWA_I	ldswa	[%r16, + 0x0bdc] %asi, %r3
	.word 0xce442ec4  ! 1: LDSW_I	ldsw	[%r16 + 0x0ec4], %r7
	brnz %r31,thr3_loop_cnt_959
	dec %r31
	.word 0x861c2715  ! 1: XOR_I	xor 	%r16, 0x0715, %r3
	.word 0x973c0002  ! 1: SRA_R	sra 	%r16, %r2, %r11
        mov 0x42, %r31
thr3_loop_cnt_960:
	.word 0xe8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r20
	.word 0xc68c2b7f  ! 1: LDUBA_I	lduba	[%r16, + 0x0b7f] %asi, %r3
	.word 0xec842d9c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d9c] %asi, %r22
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6542c06  ! 1: LDSH_I	ldsh	[%r16 + 0x0c06], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_960
	dec %r31
        mov 0x5e, %r31
thr3_loop_cnt_961:
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	.word 0xf2942602  ! 1: LDUHA_I	lduha	[%r16, + 0x0602] %asi, %r25
	.word 0xc6942df8  ! 1: LDUHA_I	lduha	[%r16, + 0x0df8] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6142a1c  ! 1: LDUH_I	lduh	[%r16 + 0x0a1c], %r3
	.word 0xf24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r25
	.word 0xd08428f0  ! 1: LDUWA_I	lduwa	[%r16, + 0x08f0] %asi, %r8
	.word 0xe6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r19
	.word 0xccdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r6
	brnz %r31,thr3_loop_cnt_961
	dec %r31
	.word 0x8f2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r7
        mov 0x44, %r31
thr3_loop_cnt_962:
	.word 0xc6dc2b58  ! 1: LDXA_I	ldxa	[%r16, + 0x0b58] %asi, %r3
	.word 0xc64c225b  ! 1: LDSB_I	ldsb	[%r16 + 0x025b], %r3
	.word 0xf80420b4  ! 1: LDUW_I	lduw	[%r16 + 0x00b4], %r28
	.word 0xf0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r24
	.word 0xc65c2938  ! 1: LDX_I	ldx	[%r16 + 0x0938], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xdc8c22d3  ! 1: LDUBA_I	lduba	[%r16, + 0x02d3] %asi, %r14
	.word 0xd4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r10
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf88c2793  ! 1: LDUBA_I	lduba	[%r16, + 0x0793] %asi, %r28
	brnz %r31,thr3_loop_cnt_962
	dec %r31
	.word 0x9e340002  ! 1: ORN_R	orn 	%r16, %r2, %r15
	.word 0x86142626  ! 1: OR_I	or 	%r16, 0x0626, %r3
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x47, %r31
thr3_loop_cnt_963:
	.word 0xc65c2320  ! 1: LDX_I	ldx	[%r16 + 0x0320], %r3
	.word 0xf48c2e0c  ! 1: LDUBA_I	lduba	[%r16, + 0x0e0c] %asi, %r26
	.word 0xc68c2526  ! 1: LDUBA_I	lduba	[%r16, + 0x0526] %asi, %r3
	.word 0xf6442104  ! 1: LDSW_I	ldsw	[%r16 + 0x0104], %r27
	.word 0xc614209c  ! 1: LDUH_I	lduh	[%r16 + 0x009c], %r3
	.word 0xf4542806  ! 1: LDSH_I	ldsh	[%r16 + 0x0806], %r26
	.word 0xc6142b56  ! 1: LDUH_I	lduh	[%r16 + 0x0b56], %r3
	.word 0xc604251c  ! 1: LDUW_I	lduw	[%r16 + 0x051c], %r3
	brnz %r31,thr3_loop_cnt_963
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x941c0002  ! 1: XOR_R	xor 	%r16, %r2, %r10
	.word 0xa82c22f9  ! 1: ANDN_I	andn 	%r16, 0x02f9, %r20
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x26, %r31
thr3_loop_cnt_964:
	.word 0xf04c2692  ! 1: LDSB_I	ldsb	[%r16 + 0x0692], %r24
	.word 0xdc0c201b  ! 1: LDUB_I	ldub	[%r16 + 0x001b], %r14
	.word 0xfa4c2b30  ! 1: LDSB_I	ldsb	[%r16 + 0x0b30], %r29
	.word 0xd25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r9
	.word 0xfa4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r29
	.word 0xc60c2d50  ! 1: LDUB_I	ldub	[%r16 + 0x0d50], %r3
	.word 0xd2042af4  ! 1: LDUW_I	lduw	[%r16 + 0x0af4], %r9
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xd0c42a7c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a7c] %asi, %r8
	.word 0xe6cc287f  ! 1: LDSBA_I	ldsba	[%r16, + 0x087f] %asi, %r19
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	brnz %r31,thr3_loop_cnt_964
	dec %r31
	.word 0x980c0002  ! 1: AND_R	and 	%r16, %r2, %r12
	.word 0xba0c0002  ! 1: AND_R	and 	%r16, %r2, %r29
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0xa60c2778  ! 1: AND_I	and 	%r16, 0x0778, %r19
        mov 0x52, %r31
thr3_loop_cnt_965:
	.word 0xf0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r24
	.word 0xeec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r23
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6042b08  ! 1: LDUW_I	lduw	[%r16 + 0x0b08], %r3
	.word 0xc69422ea  ! 1: LDUHA_I	lduha	[%r16, + 0x02ea] %asi, %r3
	.word 0xda8c2db6  ! 1: LDUBA_I	lduba	[%r16, + 0x0db6] %asi, %r13
	.word 0xe45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r18
	.word 0xc64c2670  ! 1: LDSB_I	ldsb	[%r16 + 0x0670], %r3
	brnz %r31,thr3_loop_cnt_965
	dec %r31
	.word 0xb6140002  ! 1: OR_R	or 	%r16, %r2, %r27
	.word 0x932c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r9
	.word 0x863c29ab  ! 1: XNOR_I	xnor 	%r16, 0x09ab, %r3
        mov 0x91, %r31
thr3_loop_cnt_966:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd40c2824  ! 1: LDUB_I	ldub	[%r16 + 0x0824], %r10
	.word 0xc6c42b00  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b00] %asi, %r3
	.word 0xfa4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r29
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xe6142378  ! 1: LDUH_I	lduh	[%r16 + 0x0378], %r19
	.word 0xe6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r19
	.word 0xc6cc2382  ! 1: LDSBA_I	ldsba	[%r16, + 0x0382] %asi, %r3
	.word 0xc6942e82  ! 1: LDUHA_I	lduha	[%r16, + 0x0e82] %asi, %r3
	.word 0xc69422a2  ! 1: LDUHA_I	lduha	[%r16, + 0x02a2] %asi, %r3
	brnz %r31,thr3_loop_cnt_966
	dec %r31
	.word 0xac1429aa  ! 1: OR_I	or 	%r16, 0x09aa, %r22
	.word 0xb43c2ddf  ! 1: XNOR_I	xnor 	%r16, 0x0ddf, %r26
	.word 0x961c2821  ! 1: XOR_I	xor 	%r16, 0x0821, %r11
        mov 0xe, %r31
thr3_loop_cnt_967:
	.word 0xc6d427c0  ! 1: LDSHA_I	ldsha	[%r16, + 0x07c0] %asi, %r3
	.word 0xc69429ca  ! 1: LDUHA_I	lduha	[%r16, + 0x09ca] %asi, %r3
	.word 0xc6dc27d0  ! 1: LDXA_I	ldxa	[%r16, + 0x07d0] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6d4264a  ! 1: LDSHA_I	ldsha	[%r16, + 0x064a] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc65c2a88  ! 1: LDX_I	ldx	[%r16 + 0x0a88], %r3
	brnz %r31,thr3_loop_cnt_967
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0xb3, %r31
thr3_loop_cnt_968:
	.word 0xcc9427e6  ! 1: LDUHA_I	lduha	[%r16, + 0x07e6] %asi, %r6
	.word 0xcec421a4  ! 1: LDSWA_I	ldswa	[%r16, + 0x01a4] %asi, %r7
	.word 0xc60c2d29  ! 1: LDUB_I	ldub	[%r16 + 0x0d29], %r3
	.word 0xc6142b6c  ! 1: LDUH_I	lduh	[%r16 + 0x0b6c], %r3
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	.word 0xea1429b4  ! 1: LDUH_I	lduh	[%r16 + 0x09b4], %r21
	.word 0xc684292c  ! 1: LDUWA_I	lduwa	[%r16, + 0x092c] %asi, %r3
	.word 0xc6442030  ! 1: LDSW_I	ldsw	[%r16 + 0x0030], %r3
	.word 0xd6cc2f4b  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f4b] %asi, %r11
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_968
	dec %r31
	.word 0x862426b4  ! 1: SUB_I	sub 	%r16, 0x06b4, %r3
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x9b3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r13
	.word 0x94242d20  ! 1: SUB_I	sub 	%r16, 0x0d20, %r10
        mov 0xa4, %r31
thr3_loop_cnt_969:
	.word 0xe6d4280a  ! 1: LDSHA_I	ldsha	[%r16, + 0x080a] %asi, %r19
	.word 0xda140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r13
	.word 0xd2942f20  ! 1: LDUHA_I	lduha	[%r16, + 0x0f20] %asi, %r9
	.word 0xc6c4297c  ! 1: LDSWA_I	ldswa	[%r16, + 0x097c] %asi, %r3
	.word 0xded42236  ! 1: LDSHA_I	ldsha	[%r16, + 0x0236] %asi, %r15
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r19
	.word 0xec8c2035  ! 1: LDUBA_I	lduba	[%r16, + 0x0035] %asi, %r22
	.word 0xdad42c24  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c24] %asi, %r13
	.word 0xd2542ddc  ! 1: LDSH_I	ldsh	[%r16 + 0x0ddc], %r9
	.word 0xc6cc29cd  ! 1: LDSBA_I	ldsba	[%r16, + 0x09cd] %asi, %r3
	.word 0xc6942cc2  ! 1: LDUHA_I	lduha	[%r16, + 0x0cc2] %asi, %r3
	brnz %r31,thr3_loop_cnt_969
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x67, %r31
thr3_loop_cnt_970:
	.word 0xee5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r23
	.word 0xe6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r19
	.word 0xcc8c2401  ! 1: LDUBA_I	lduba	[%r16, + 0x0401] %asi, %r6
	.word 0xee841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r23
	.word 0xcc8c207b  ! 1: LDUBA_I	lduba	[%r16, + 0x007b] %asi, %r6
	.word 0xd0dc2900  ! 1: LDXA_I	ldxa	[%r16, + 0x0900] %asi, %r8
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r12
	.word 0xf2dc2ea8  ! 1: LDXA_I	ldxa	[%r16, + 0x0ea8] %asi, %r25
	.word 0xc6942d3a  ! 1: LDUHA_I	lduha	[%r16, + 0x0d3a] %asi, %r3
	.word 0xe2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r17
	brnz %r31,thr3_loop_cnt_970
	dec %r31
        mov 0xb9, %r31
thr3_loop_cnt_971:
	.word 0xc6842b64  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b64] %asi, %r3
	.word 0xc6d42694  ! 1: LDSHA_I	ldsha	[%r16, + 0x0694] %asi, %r3
	.word 0xc6542a8a  ! 1: LDSH_I	ldsh	[%r16 + 0x0a8a], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xfa0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r29
	.word 0xea4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r21
	.word 0xc6cc29fe  ! 1: LDSBA_I	ldsba	[%r16, + 0x09fe] %asi, %r3
	brnz %r31,thr3_loop_cnt_971
	dec %r31
	.word 0x86342af0  ! 1: SUBC_I	orn 	%r16, 0x0af0, %r3
        mov 0x17, %r31
thr3_loop_cnt_972:
	.word 0xc65c2c68  ! 1: LDX_I	ldx	[%r16 + 0x0c68], %r3
	.word 0xc65424ae  ! 1: LDSH_I	ldsh	[%r16 + 0x04ae], %r3
	.word 0xc6942d2a  ! 1: LDUHA_I	lduha	[%r16, + 0x0d2a] %asi, %r3
	.word 0xcc0425ac  ! 1: LDUW_I	lduw	[%r16 + 0x05ac], %r6
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xde4c2b2c  ! 1: LDSB_I	ldsb	[%r16 + 0x0b2c], %r15
	brnz %r31,thr3_loop_cnt_972
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0xa73c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r19
        mov 0x9a, %r31
thr3_loop_cnt_973:
	.word 0xf4c425e8  ! 1: LDSWA_I	ldswa	[%r16, + 0x05e8] %asi, %r26
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r8
	.word 0xde5c25f8  ! 1: LDX_I	ldx	[%r16 + 0x05f8], %r15
	.word 0xd0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r8
	.word 0xda941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r13
	.word 0xf8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r28
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xf2d42d62  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d62] %asi, %r25
	brnz %r31,thr3_loop_cnt_973
	dec %r31
	.word 0xbb2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r29
	.word 0xaa242511  ! 1: SUB_I	sub 	%r16, 0x0511, %r21
	.word 0x860c228d  ! 1: AND_I	and 	%r16, 0x028d, %r3
	.word 0xaa3c2731  ! 1: XNOR_I	xnor 	%r16, 0x0731, %r21
        mov 0x5e, %r31
thr3_loop_cnt_974:
	.word 0xe24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r17
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2f28  ! 1: LDXA_I	ldxa	[%r16, + 0x0f28] %asi, %r3
	.word 0xea942ef2  ! 1: LDUHA_I	lduha	[%r16, + 0x0ef2] %asi, %r21
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xdc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r14
	.word 0xc64428d8  ! 1: LDSW_I	ldsw	[%r16 + 0x08d8], %r3
	.word 0xe48c21af  ! 1: LDUBA_I	lduba	[%r16, + 0x01af] %asi, %r18
	brnz %r31,thr3_loop_cnt_974
	dec %r31
	.word 0x973c0002  ! 1: SRA_R	sra 	%r16, %r2, %r11
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x86042aed  ! 1: ADD_I	add 	%r16, 0x0aed, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x53, %r31
thr3_loop_cnt_975:
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	.word 0xe2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r17
	.word 0xee140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r23
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	.word 0xc60c2d73  ! 1: LDUB_I	ldub	[%r16 + 0x0d73], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc60423d8  ! 1: LDUW_I	lduw	[%r16 + 0x03d8], %r3
	.word 0xf6442838  ! 1: LDSW_I	ldsw	[%r16 + 0x0838], %r27
	.word 0xf20c2a6f  ! 1: LDUB_I	ldub	[%r16 + 0x0a6f], %r25
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xecdc2a38  ! 1: LDXA_I	ldxa	[%r16, + 0x0a38] %asi, %r22
	brnz %r31,thr3_loop_cnt_975
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x860c2379  ! 1: AND_I	and 	%r16, 0x0379, %r3
	.word 0xa4042f56  ! 1: ADD_I	add 	%r16, 0x0f56, %r18
	.word 0xb9342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r28
        mov 0x60, %r31
thr3_loop_cnt_976:
	.word 0xc65424c4  ! 1: LDSH_I	ldsh	[%r16 + 0x04c4], %r3
	.word 0xc6d42340  ! 1: LDSHA_I	ldsha	[%r16, + 0x0340] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xee0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r23
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xd6442690  ! 1: LDSW_I	ldsw	[%r16 + 0x0690], %r11
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	brnz %r31,thr3_loop_cnt_976
	dec %r31
	.word 0x863420f7  ! 1: ORN_I	orn 	%r16, 0x00f7, %r3
	.word 0x91340002  ! 1: SRL_R	srl 	%r16, %r2, %r8
	.word 0xa73c1002  ! 1: SRAX_R	srax	%r16, %r2, %r19
        mov 0x7e, %r31
thr3_loop_cnt_977:
	.word 0xc6cc217a  ! 1: LDSBA_I	ldsba	[%r16, + 0x017a] %asi, %r3
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	.word 0xd28c2dbf  ! 1: LDUBA_I	lduba	[%r16, + 0x0dbf] %asi, %r9
	.word 0xc6042abc  ! 1: LDUW_I	lduw	[%r16 + 0x0abc], %r3
	.word 0xce4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r7
	.word 0xe8c42668  ! 1: LDSWA_I	ldswa	[%r16, + 0x0668] %asi, %r20
	.word 0xe8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r20
	.word 0xc6042344  ! 1: LDUW_I	lduw	[%r16 + 0x0344], %r3
	.word 0xea942c4c  ! 1: LDUHA_I	lduha	[%r16, + 0x0c4c] %asi, %r21
	.word 0xc6c423f0  ! 1: LDSWA_I	ldswa	[%r16, + 0x03f0] %asi, %r3
	.word 0xd85c21d0  ! 1: LDX_I	ldx	[%r16 + 0x01d0], %r12
	brnz %r31,thr3_loop_cnt_977
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0x52, %r31
thr3_loop_cnt_978:
	.word 0xc6dc2928  ! 1: LDXA_I	ldxa	[%r16, + 0x0928] %asi, %r3
	.word 0xe8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r20
	.word 0xc65c20a0  ! 1: LDX_I	ldx	[%r16 + 0x00a0], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xea5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r21
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2364  ! 1: LDSBA_I	ldsba	[%r16, + 0x0364] %asi, %r3
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	brnz %r31,thr3_loop_cnt_978
	dec %r31
	.word 0xa73c0002  ! 1: SRA_R	sra 	%r16, %r2, %r19
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0xa73c0002  ! 1: SRA_R	sra 	%r16, %r2, %r19
        mov 0x8a, %r31
thr3_loop_cnt_979:
	.word 0xeccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r22
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd0c42b84  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b84] %asi, %r8
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xc64c2cc5  ! 1: LDSB_I	ldsb	[%r16 + 0x0cc5], %r3
	.word 0xde942b84  ! 1: LDUHA_I	lduha	[%r16, + 0x0b84] %asi, %r15
	.word 0xfacc251c  ! 1: LDSBA_I	ldsba	[%r16, + 0x051c] %asi, %r29
	.word 0xc6dc2828  ! 1: LDXA_I	ldxa	[%r16, + 0x0828] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6942b4e  ! 1: LDUHA_I	lduha	[%r16, + 0x0b4e] %asi, %r3
	brnz %r31,thr3_loop_cnt_979
	dec %r31
        mov 0x4a, %r31
thr3_loop_cnt_980:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6c4254c  ! 1: LDSWA_I	ldswa	[%r16, + 0x054c] %asi, %r3
	.word 0xde44266c  ! 1: LDSW_I	ldsw	[%r16 + 0x066c], %r15
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf254281e  ! 1: LDSH_I	ldsh	[%r16 + 0x081e], %r25
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc60428ac  ! 1: LDUW_I	lduw	[%r16 + 0x08ac], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_980
	dec %r31
	.word 0x86042f62  ! 1: ADD_I	add 	%r16, 0x0f62, %r3
	.word 0x860c273f  ! 1: AND_I	and 	%r16, 0x073f, %r3
	.word 0x8c3c2796  ! 1: XNOR_I	xnor 	%r16, 0x0796, %r6
        mov 0x94, %r31
thr3_loop_cnt_981:
	.word 0xfac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r29
	.word 0xc6142bda  ! 1: LDUH_I	lduh	[%r16 + 0x0bda], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc60c231b  ! 1: LDUB_I	ldub	[%r16 + 0x031b], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_981
	dec %r31
	.word 0x860c2fbd  ! 1: AND_I	and 	%r16, 0x0fbd, %r3
	.word 0xa42c218e  ! 1: ANDN_I	andn 	%r16, 0x018e, %r18
        mov 0x86, %r31
thr3_loop_cnt_982:
	.word 0xda842438  ! 1: LDUWA_I	lduwa	[%r16, + 0x0438] %asi, %r13
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xce1426a2  ! 1: LDUH_I	lduh	[%r16 + 0x06a2], %r7
	.word 0xf65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r27
	.word 0xc60c2baa  ! 1: LDUB_I	ldub	[%r16 + 0x0baa], %r3
	.word 0xe8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r20
	.word 0xc68c248c  ! 1: LDUBA_I	lduba	[%r16, + 0x048c] %asi, %r3
	.word 0xc6d42352  ! 1: LDSHA_I	ldsha	[%r16, + 0x0352] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r24
	brnz %r31,thr3_loop_cnt_982
	dec %r31
	.word 0x8e340002  ! 1: SUBC_R	orn 	%r16, %r2, %r7
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x68, %r31
thr3_loop_cnt_983:
	.word 0xde0c2cd0  ! 1: LDUB_I	ldub	[%r16 + 0x0cd0], %r15
	.word 0xced42d2a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d2a] %asi, %r7
	.word 0xf0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r24
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd6c42478  ! 1: LDSWA_I	ldswa	[%r16, + 0x0478] %asi, %r11
	.word 0xf00c2265  ! 1: LDUB_I	ldub	[%r16 + 0x0265], %r24
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc65c2bf8  ! 1: LDX_I	ldx	[%r16 + 0x0bf8], %r3
	.word 0xd64420e8  ! 1: LDSW_I	ldsw	[%r16 + 0x00e8], %r11
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_983
	dec %r31
	.word 0x99340002  ! 1: SRL_R	srl 	%r16, %r2, %r12
        mov 0x9b, %r31
thr3_loop_cnt_984:
	.word 0xc6442d14  ! 1: LDSW_I	ldsw	[%r16 + 0x0d14], %r3
	.word 0xda042d48  ! 1: LDUW_I	lduw	[%r16 + 0x0d48], %r13
	.word 0xc6842304  ! 1: LDUWA_I	lduwa	[%r16, + 0x0304] %asi, %r3
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xda140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r13
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6542e58  ! 1: LDSH_I	ldsh	[%r16 + 0x0e58], %r3
	.word 0xde142c04  ! 1: LDUH_I	lduh	[%r16 + 0x0c04], %r15
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xdc542cfc  ! 1: LDSH_I	ldsh	[%r16 + 0x0cfc], %r14
	brnz %r31,thr3_loop_cnt_984
	dec %r31
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x86342820  ! 1: ORN_I	orn 	%r16, 0x0820, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0x78, %r31
thr3_loop_cnt_985:
	.word 0xc6cc2dee  ! 1: LDSBA_I	ldsba	[%r16, + 0x0dee] %asi, %r3
	.word 0xc6442e88  ! 1: LDSW_I	ldsw	[%r16 + 0x0e88], %r3
	.word 0xe8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r20
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xc6cc22ff  ! 1: LDSBA_I	ldsba	[%r16, + 0x02ff] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xe2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r17
	.word 0xf4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r26
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	brnz %r31,thr3_loop_cnt_985
	dec %r31
	.word 0x8e442a58  ! 1: ADDC_I	addc 	%r16, 0x0a58, %r7
	.word 0x932c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r9
        mov 0x76, %r31
thr3_loop_cnt_986:
	.word 0xc6142c5c  ! 1: LDUH_I	lduh	[%r16 + 0x0c5c], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd24428d0  ! 1: LDSW_I	ldsw	[%r16 + 0x08d0], %r9
	.word 0xe2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r17
	.word 0xc654274c  ! 1: LDSH_I	ldsh	[%r16 + 0x074c], %r3
	.word 0xea142732  ! 1: LDUH_I	lduh	[%r16 + 0x0732], %r21
	.word 0xc6442374  ! 1: LDSW_I	ldsw	[%r16 + 0x0374], %r3
	.word 0xdec4258c  ! 1: LDSWA_I	ldswa	[%r16, + 0x058c] %asi, %r15
	.word 0xce442b98  ! 1: LDSW_I	ldsw	[%r16 + 0x0b98], %r7
	.word 0xc65c2b10  ! 1: LDX_I	ldx	[%r16 + 0x0b10], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_986
	dec %r31
	.word 0x8c2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r6
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x8f343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r7
	.word 0xbc240002  ! 1: SUB_R	sub 	%r16, %r2, %r30
        mov 0x7c, %r31
thr3_loop_cnt_987:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xda94298e  ! 1: LDUHA_I	lduha	[%r16, + 0x098e] %asi, %r13
	.word 0xd0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r8
	.word 0xde140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r15
	.word 0xc6cc2f61  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f61] %asi, %r3
	.word 0xdc442fdc  ! 1: LDSW_I	ldsw	[%r16 + 0x0fdc], %r14
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xdecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r15
	brnz %r31,thr3_loop_cnt_987
	dec %r31
        mov 0x46, %r31
thr3_loop_cnt_988:
	.word 0xc6442538  ! 1: LDSW_I	ldsw	[%r16 + 0x0538], %r3
	.word 0xcc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r6
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd6c425c8  ! 1: LDSWA_I	ldswa	[%r16, + 0x05c8] %asi, %r11
	.word 0xc60c2d51  ! 1: LDUB_I	ldub	[%r16 + 0x0d51], %r3
	.word 0xd0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r8
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6c4292c  ! 1: LDSWA_I	ldswa	[%r16, + 0x092c] %asi, %r3
	brnz %r31,thr3_loop_cnt_988
	dec %r31
	.word 0x94340002  ! 1: ORN_R	orn 	%r16, %r2, %r10
	.word 0x9c0c0002  ! 1: AND_R	and 	%r16, %r2, %r14
        mov 0x5, %r31
thr3_loop_cnt_989:
	.word 0xc64c2cf5  ! 1: LDSB_I	ldsb	[%r16 + 0x0cf5], %r3
	.word 0xc6542150  ! 1: LDSH_I	ldsh	[%r16 + 0x0150], %r3
	.word 0xdcc42410  ! 1: LDSWA_I	ldswa	[%r16, + 0x0410] %asi, %r14
	.word 0xced42c4a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c4a] %asi, %r7
	.word 0xe8842c34  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c34] %asi, %r20
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xd0142fb2  ! 1: LDUH_I	lduh	[%r16 + 0x0fb2], %r8
	.word 0xdadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r13
	.word 0xd0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r8
	.word 0xf8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r28
	brnz %r31,thr3_loop_cnt_989
	dec %r31
	.word 0x97343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r11
        mov 0xa, %r31
thr3_loop_cnt_990:
	.word 0xc6442678  ! 1: LDSW_I	ldsw	[%r16 + 0x0678], %r3
	.word 0xe88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r20
	.word 0xc64c22cc  ! 1: LDSB_I	ldsb	[%r16 + 0x02cc], %r3
	.word 0xe6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r19
	.word 0xdedc23d0  ! 1: LDXA_I	ldxa	[%r16, + 0x03d0] %asi, %r15
	.word 0xe2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r17
	.word 0xda8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r13
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xce040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r7
	.word 0xc69426d4  ! 1: LDUHA_I	lduha	[%r16, + 0x06d4] %asi, %r3
	brnz %r31,thr3_loop_cnt_990
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x92342433  ! 1: SUBC_I	orn 	%r16, 0x0433, %r9
        mov 0x92, %r31
thr3_loop_cnt_991:
	.word 0xc6dc2778  ! 1: LDXA_I	ldxa	[%r16, + 0x0778] %asi, %r3
	.word 0xc6142356  ! 1: LDUH_I	lduh	[%r16 + 0x0356], %r3
	.word 0xce440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r7
	.word 0xc6842878  ! 1: LDUWA_I	lduwa	[%r16, + 0x0878] %asi, %r3
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xda4c21c1  ! 1: LDSB_I	ldsb	[%r16 + 0x01c1], %r13
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6d426b6  ! 1: LDSHA_I	ldsha	[%r16, + 0x06b6] %asi, %r3
	.word 0xc68c29d1  ! 1: LDUBA_I	lduba	[%r16, + 0x09d1] %asi, %r3
	brnz %r31,thr3_loop_cnt_991
	dec %r31
	.word 0x860c2932  ! 1: AND_I	and 	%r16, 0x0932, %r3
	.word 0xb4042ab5  ! 1: ADD_I	add 	%r16, 0x0ab5, %r26
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x97, %r31
thr3_loop_cnt_992:
	.word 0xccdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r6
	.word 0xd8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r12
	.word 0xd6042070  ! 1: LDUW_I	lduw	[%r16 + 0x0070], %r11
	.word 0xf00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r24
	.word 0xd24424c8  ! 1: LDSW_I	ldsw	[%r16 + 0x04c8], %r9
	.word 0xc60c2704  ! 1: LDUB_I	ldub	[%r16 + 0x0704], %r3
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd0c42aa0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0aa0] %asi, %r8
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xfa44204c  ! 1: LDSW_I	ldsw	[%r16 + 0x004c], %r29
	.word 0xd2442708  ! 1: LDSW_I	ldsw	[%r16 + 0x0708], %r9
	brnz %r31,thr3_loop_cnt_992
	dec %r31
	.word 0x993c1002  ! 1: SRAX_R	srax	%r16, %r2, %r12
	.word 0xa60c2214  ! 1: AND_I	and 	%r16, 0x0214, %r19
	.word 0x952c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r10
        mov 0x16, %r31
thr3_loop_cnt_993:
	.word 0xd45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r10
	.word 0xc68c213e  ! 1: LDUBA_I	lduba	[%r16, + 0x013e] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf4cc2f94  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f94] %asi, %r26
	.word 0xfcdc29f8  ! 1: LDXA_I	ldxa	[%r16, + 0x09f8] %asi, %r30
	.word 0xf25c22b8  ! 1: LDX_I	ldx	[%r16 + 0x02b8], %r25
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_993
	dec %r31
	.word 0xa8040002  ! 1: ADD_R	add 	%r16, %r2, %r20
        mov 0x2c, %r31
thr3_loop_cnt_994:
	.word 0xc64c2254  ! 1: LDSB_I	ldsb	[%r16 + 0x0254], %r3
	.word 0xf2d4249c  ! 1: LDSHA_I	ldsha	[%r16, + 0x049c] %asi, %r25
	.word 0xf404266c  ! 1: LDUW_I	lduw	[%r16 + 0x066c], %r26
	.word 0xf45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r26
	.word 0xc6dc2558  ! 1: LDXA_I	ldxa	[%r16, + 0x0558] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r18
	.word 0xdcd42f6e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f6e] %asi, %r14
	brnz %r31,thr3_loop_cnt_994
	dec %r31
	.word 0x863c23a1  ! 1: XNOR_I	xnor 	%r16, 0x03a1, %r3
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x59, %r31
thr3_loop_cnt_995:
	.word 0xe6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r19
	.word 0xc6842f78  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f78] %asi, %r3
	.word 0xc6142086  ! 1: LDUH_I	lduh	[%r16 + 0x0086], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc64c2d00  ! 1: LDSB_I	ldsb	[%r16 + 0x0d00], %r3
	.word 0xea042f38  ! 1: LDUW_I	lduw	[%r16 + 0x0f38], %r21
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	.word 0xe28c2e5c  ! 1: LDUBA_I	lduba	[%r16, + 0x0e5c] %asi, %r17
	.word 0xf6d42c0e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c0e] %asi, %r27
	.word 0xfa4c214f  ! 1: LDSB_I	ldsb	[%r16 + 0x014f], %r29
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_995
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x86242147  ! 1: SUB_I	sub 	%r16, 0x0147, %r3
	.word 0x86342651  ! 1: ORN_I	orn 	%r16, 0x0651, %r3
        mov 0x65, %r31
thr3_loop_cnt_996:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf25c2400  ! 1: LDX_I	ldx	[%r16 + 0x0400], %r25
	.word 0xc6442924  ! 1: LDSW_I	ldsw	[%r16 + 0x0924], %r3
	.word 0xf85c2750  ! 1: LDX_I	ldx	[%r16 + 0x0750], %r28
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc65c29b8  ! 1: LDX_I	ldx	[%r16 + 0x09b8], %r3
	.word 0xde5429b4  ! 1: LDSH_I	ldsh	[%r16 + 0x09b4], %r15
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd6dc23b0  ! 1: LDXA_I	ldxa	[%r16, + 0x03b0] %asi, %r11
	.word 0xc68c2356  ! 1: LDUBA_I	lduba	[%r16, + 0x0356] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_996
	dec %r31
	.word 0x863426c1  ! 1: ORN_I	orn 	%r16, 0x06c1, %r3
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0x57, %r31
thr3_loop_cnt_997:
	.word 0xce5c22e8  ! 1: LDX_I	ldx	[%r16 + 0x02e8], %r7
	.word 0xea841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r21
	.word 0xfc142ff2  ! 1: LDUH_I	lduh	[%r16 + 0x0ff2], %r30
	.word 0xd294247a  ! 1: LDUHA_I	lduha	[%r16, + 0x047a] %asi, %r9
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	.word 0xcc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r6
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r19
	.word 0xe8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r20
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_997
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0xb234279e  ! 1: SUBC_I	orn 	%r16, 0x079e, %r25
        mov 0xae, %r31
thr3_loop_cnt_998:
	.word 0xda140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r13
	.word 0xeccc27e8  ! 1: LDSBA_I	ldsba	[%r16, + 0x07e8] %asi, %r22
	.word 0xc6942916  ! 1: LDUHA_I	lduha	[%r16, + 0x0916] %asi, %r3
	.word 0xc6542388  ! 1: LDSH_I	ldsh	[%r16 + 0x0388], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xea540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r21
	.word 0xf6c42950  ! 1: LDSWA_I	ldswa	[%r16, + 0x0950] %asi, %r27
	.word 0xc68c2a59  ! 1: LDUBA_I	lduba	[%r16, + 0x0a59] %asi, %r3
	brnz %r31,thr3_loop_cnt_998
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x5b, %r31
thr3_loop_cnt_999:
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xfa8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r29
	.word 0xea941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r21
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_999
	dec %r31
	.word 0x86242039  ! 1: SUB_I	sub 	%r16, 0x0039, %r3
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0xb8040002  ! 1: ADD_R	add 	%r16, %r2, %r28
        mov 0x27, %r31
thr3_loop_cnt_1000:
	.word 0xdcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r14
	.word 0xf8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r28
	.word 0xc6142b70  ! 1: LDUH_I	lduh	[%r16 + 0x0b70], %r3
	.word 0xc6442080  ! 1: LDSW_I	ldsw	[%r16 + 0x0080], %r3
	.word 0xc61422b4  ! 1: LDUH_I	lduh	[%r16 + 0x02b4], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc64c26b3  ! 1: LDSB_I	ldsb	[%r16 + 0x06b3], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1000
	dec %r31
	.word 0x91342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r8
        mov 0x8b, %r31
thr3_loop_cnt_1001:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6442248  ! 1: LDSW_I	ldsw	[%r16 + 0x0248], %r3
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xc6542dfa  ! 1: LDSH_I	ldsh	[%r16 + 0x0dfa], %r3
	.word 0xd25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r9
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc68c2cbd  ! 1: LDUBA_I	lduba	[%r16, + 0x0cbd] %asi, %r3
	.word 0xc644291c  ! 1: LDSW_I	ldsw	[%r16 + 0x091c], %r3
	.word 0xe60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r19
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d42e90  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e90] %asi, %r3
	.word 0xe6542092  ! 1: LDSH_I	ldsh	[%r16 + 0x0092], %r19
	brnz %r31,thr3_loop_cnt_1001
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x96240002  ! 1: SUB_R	sub 	%r16, %r2, %r11
	.word 0xa4240002  ! 1: SUB_R	sub 	%r16, %r2, %r18
	.word 0x9e2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r15
        mov 0x3f, %r31
thr3_loop_cnt_1002:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xdadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r13
	.word 0xc6042244  ! 1: LDUW_I	lduw	[%r16 + 0x0244], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xec040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r22
	.word 0xc6842298  ! 1: LDUWA_I	lduwa	[%r16, + 0x0298] %asi, %r3
	.word 0xec941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r22
	.word 0xc64c23c7  ! 1: LDSB_I	ldsb	[%r16 + 0x03c7], %r3
	.word 0xc64429c4  ! 1: LDSW_I	ldsw	[%r16 + 0x09c4], %r3
	.word 0xc65c2b40  ! 1: LDX_I	ldx	[%r16 + 0x0b40], %r3
	.word 0xc684274c  ! 1: LDUWA_I	lduwa	[%r16, + 0x074c] %asi, %r3
	brnz %r31,thr3_loop_cnt_1002
	dec %r31
        mov 0x2f, %r31
thr3_loop_cnt_1003:
	.word 0xc65c2d20  ! 1: LDX_I	ldx	[%r16 + 0x0d20], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xda841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r13
	.word 0xe2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r17
	.word 0xc6842870  ! 1: LDUWA_I	lduwa	[%r16, + 0x0870] %asi, %r3
	.word 0xc6cc2c6b  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c6b] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xccdc2d88  ! 1: LDXA_I	ldxa	[%r16, + 0x0d88] %asi, %r6
	.word 0xc60c2e08  ! 1: LDUB_I	ldub	[%r16 + 0x0e08], %r3
	brnz %r31,thr3_loop_cnt_1003
	dec %r31
	.word 0x942c2da1  ! 1: ANDN_I	andn 	%r16, 0x0da1, %r10
        mov 0x63, %r31
thr3_loop_cnt_1004:
	.word 0xc6042528  ! 1: LDUW_I	lduw	[%r16 + 0x0528], %r3
	.word 0xc6c42560  ! 1: LDSWA_I	ldswa	[%r16, + 0x0560] %asi, %r3
	.word 0xc6c42268  ! 1: LDSWA_I	ldswa	[%r16, + 0x0268] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xfa8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r29
	.word 0xc60421c4  ! 1: LDUW_I	lduw	[%r16 + 0x01c4], %r3
	.word 0xc6dc2178  ! 1: LDXA_I	ldxa	[%r16, + 0x0178] %asi, %r3
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xc64c252d  ! 1: LDSB_I	ldsb	[%r16 + 0x052d], %r3
	.word 0xc694277c  ! 1: LDUHA_I	lduha	[%r16, + 0x077c] %asi, %r3
	brnz %r31,thr3_loop_cnt_1004
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x18, %r31
thr3_loop_cnt_1005:
	.word 0xd8c42c80  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c80] %asi, %r12
	.word 0xf24c2d9a  ! 1: LDSB_I	ldsb	[%r16 + 0x0d9a], %r25
	.word 0xd0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r8
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xccdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r6
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd6842c14  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c14] %asi, %r11
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6c4202c  ! 1: LDSWA_I	ldswa	[%r16, + 0x002c] %asi, %r3
	brnz %r31,thr3_loop_cnt_1005
	dec %r31
	.word 0x86342eda  ! 1: ORN_I	orn 	%r16, 0x0eda, %r3
	.word 0x86142bb3  ! 1: OR_I	or 	%r16, 0x0bb3, %r3
	.word 0x8d343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r6
	.word 0xbc3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r30
        mov 0x9, %r31
thr3_loop_cnt_1006:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xfc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r30
	.word 0xc6d42db6  ! 1: LDSHA_I	ldsha	[%r16, + 0x0db6] %asi, %r3
	.word 0xc604268c  ! 1: LDUW_I	lduw	[%r16 + 0x068c], %r3
	.word 0xf6c426cc  ! 1: LDSWA_I	ldswa	[%r16, + 0x06cc] %asi, %r27
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xc64c2f7a  ! 1: LDSB_I	ldsb	[%r16 + 0x0f7a], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1006
	dec %r31
	.word 0x92140002  ! 1: OR_R	or 	%r16, %r2, %r9
	.word 0x863c2a2b  ! 1: XNOR_I	xnor 	%r16, 0x0a2b, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0x91, %r31
thr3_loop_cnt_1007:
	.word 0xc65c2728  ! 1: LDX_I	ldx	[%r16 + 0x0728], %r3
	.word 0xc68c2a81  ! 1: LDUBA_I	lduba	[%r16, + 0x0a81] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xfac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r29
	.word 0xea4c236e  ! 1: LDSB_I	ldsb	[%r16 + 0x036e], %r21
	.word 0xd6542f9a  ! 1: LDSH_I	ldsh	[%r16 + 0x0f9a], %r11
	.word 0xc6cc248c  ! 1: LDSBA_I	ldsba	[%r16, + 0x048c] %asi, %r3
	brnz %r31,thr3_loop_cnt_1007
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x86342ccc  ! 1: SUBC_I	orn 	%r16, 0x0ccc, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0xb224209b  ! 1: SUB_I	sub 	%r16, 0x009b, %r25
        mov 0xba, %r31
thr3_loop_cnt_1008:
	.word 0xe8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r20
	.word 0xc64c2b82  ! 1: LDSB_I	ldsb	[%r16 + 0x0b82], %r3
	.word 0xf8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r28
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xf644281c  ! 1: LDSW_I	ldsw	[%r16 + 0x081c], %r27
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc64c245c  ! 1: LDSB_I	ldsb	[%r16 + 0x045c], %r3
	brnz %r31,thr3_loop_cnt_1008
	dec %r31
	.word 0x86342002  ! 1: ORN_I	orn 	%r16, 0x0002, %r3
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x860422f0  ! 1: ADD_I	add 	%r16, 0x02f0, %r3
        mov 0x7, %r31
thr3_loop_cnt_1009:
	.word 0xfa0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r29
	.word 0xf8442e48  ! 1: LDSW_I	ldsw	[%r16 + 0x0e48], %r28
	.word 0xee042480  ! 1: LDUW_I	lduw	[%r16 + 0x0480], %r23
	.word 0xc6cc25fc  ! 1: LDSBA_I	ldsba	[%r16, + 0x05fc] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2a00  ! 1: LDXA_I	ldxa	[%r16, + 0x0a00] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xced423f8  ! 1: LDSHA_I	ldsha	[%r16, + 0x03f8] %asi, %r7
	brnz %r31,thr3_loop_cnt_1009
	dec %r31
	.word 0x921c2994  ! 1: XOR_I	xor 	%r16, 0x0994, %r9
        mov 0x42, %r31
thr3_loop_cnt_1010:
	.word 0xea841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r21
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xfac425e4  ! 1: LDSWA_I	ldswa	[%r16, + 0x05e4] %asi, %r29
	.word 0xc64c2848  ! 1: LDSB_I	ldsb	[%r16 + 0x0848], %r3
	.word 0xc6c421d8  ! 1: LDSWA_I	ldswa	[%r16, + 0x01d8] %asi, %r3
	.word 0xd8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r12
	.word 0xc614271e  ! 1: LDUH_I	lduh	[%r16 + 0x071e], %r3
	.word 0xd05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r8
	brnz %r31,thr3_loop_cnt_1010
	dec %r31
	.word 0x861c2d25  ! 1: XOR_I	xor 	%r16, 0x0d25, %r3
        mov 0x8b, %r31
thr3_loop_cnt_1011:
	.word 0xf4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r26
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xce542db4  ! 1: LDSH_I	ldsh	[%r16 + 0x0db4], %r7
	.word 0xc60428e0  ! 1: LDUW_I	lduw	[%r16 + 0x08e0], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd6c42b48  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b48] %asi, %r11
	.word 0xf85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r28
	.word 0xfc542074  ! 1: LDSH_I	ldsh	[%r16 + 0x0074], %r30
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1011
	dec %r31
	.word 0x861c2302  ! 1: XOR_I	xor 	%r16, 0x0302, %r3
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x862c2cf5  ! 1: ANDN_I	andn 	%r16, 0x0cf5, %r3
        mov 0x36, %r31
thr3_loop_cnt_1012:
	.word 0xc6c42cd0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0cd0] %asi, %r3
	.word 0xc60c2c96  ! 1: LDUB_I	ldub	[%r16 + 0x0c96], %r3
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	.word 0xc6042b48  ! 1: LDUW_I	lduw	[%r16 + 0x0b48], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc64425e0  ! 1: LDSW_I	ldsw	[%r16 + 0x05e0], %r3
	.word 0xc684266c  ! 1: LDUWA_I	lduwa	[%r16, + 0x066c] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xc68c2d51  ! 1: LDUBA_I	lduba	[%r16, + 0x0d51] %asi, %r3
	brnz %r31,thr3_loop_cnt_1012
	dec %r31
	.word 0x8d2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r6
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x9b3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r13
	.word 0x862c2afd  ! 1: ANDN_I	andn 	%r16, 0x0afd, %r3
        mov 0x79, %r31
thr3_loop_cnt_1013:
	.word 0xc68c2067  ! 1: LDUBA_I	lduba	[%r16, + 0x0067] %asi, %r3
	.word 0xd6942fce  ! 1: LDUHA_I	lduha	[%r16, + 0x0fce] %asi, %r11
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6cc20d1  ! 1: LDSBA_I	ldsba	[%r16, + 0x00d1] %asi, %r3
	.word 0xd4542c4c  ! 1: LDSH_I	ldsh	[%r16 + 0x0c4c], %r10
	.word 0xc6442ee0  ! 1: LDSW_I	ldsw	[%r16 + 0x0ee0], %r3
	.word 0xd8d4205c  ! 1: LDSHA_I	ldsha	[%r16, + 0x005c] %asi, %r12
	.word 0xe80c254c  ! 1: LDUB_I	ldub	[%r16 + 0x054c], %r20
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1013
	dec %r31
	.word 0xbd3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r30
        mov 0xad, %r31
thr3_loop_cnt_1014:
	.word 0xd4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r10
	.word 0xd0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r8
	.word 0xd654259e  ! 1: LDSH_I	ldsh	[%r16 + 0x059e], %r11
	.word 0xc6cc2e37  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e37] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r25
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6942c00  ! 1: LDUHA_I	lduha	[%r16, + 0x0c00] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1014
	dec %r31
	.word 0xbc3c2014  ! 1: XNOR_I	xnor 	%r16, 0x0014, %r30
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x86242c5f  ! 1: SUB_I	sub 	%r16, 0x0c5f, %r3
	.word 0x861c28b1  ! 1: XOR_I	xor 	%r16, 0x08b1, %r3
        mov 0x3f, %r31
thr3_loop_cnt_1015:
	.word 0xd08c204d  ! 1: LDUBA_I	lduba	[%r16, + 0x004d] %asi, %r8
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6842544  ! 1: LDUWA_I	lduwa	[%r16, + 0x0544] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc25c8  ! 1: LDXA_I	ldxa	[%r16, + 0x05c8] %asi, %r3
	.word 0xc6942b86  ! 1: LDUHA_I	lduha	[%r16, + 0x0b86] %asi, %r3
	brnz %r31,thr3_loop_cnt_1015
	dec %r31
        mov 0x6e, %r31
thr3_loop_cnt_1016:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d42908  ! 1: LDSHA_I	ldsha	[%r16, + 0x0908] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xee4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r23
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r24
	.word 0xc60421bc  ! 1: LDUW_I	lduw	[%r16 + 0x01bc], %r3
	.word 0xf8542f5c  ! 1: LDSH_I	ldsh	[%r16 + 0x0f5c], %r28
	.word 0xf2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r25
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xee540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r23
	brnz %r31,thr3_loop_cnt_1016
	dec %r31
	.word 0x860c2d23  ! 1: AND_I	and 	%r16, 0x0d23, %r3
        mov 0x22, %r31
thr3_loop_cnt_1017:
	.word 0xc6cc282f  ! 1: LDSBA_I	ldsba	[%r16, + 0x082f] %asi, %r3
	.word 0xd60c2cea  ! 1: LDUB_I	ldub	[%r16 + 0x0cea], %r11
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xda140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r13
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6942fd8  ! 1: LDUHA_I	lduha	[%r16, + 0x0fd8] %asi, %r3
	.word 0xc6442908  ! 1: LDSW_I	ldsw	[%r16 + 0x0908], %r3
	.word 0xf2442504  ! 1: LDSW_I	ldsw	[%r16 + 0x0504], %r25
	.word 0xe44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r18
	brnz %r31,thr3_loop_cnt_1017
	dec %r31
	.word 0xa4342086  ! 1: ORN_I	orn 	%r16, 0x0086, %r18
	.word 0xb3341002  ! 1: SRLX_R	srlx	%r16, %r2, %r25
        mov 0x80, %r31
thr3_loop_cnt_1018:
	.word 0xf4d42a28  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a28] %asi, %r26
	.word 0xe60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r19
	.word 0xea1423bc  ! 1: LDUH_I	lduh	[%r16 + 0x03bc], %r21
	.word 0xc6442ab0  ! 1: LDSW_I	ldsw	[%r16 + 0x0ab0], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf8542458  ! 1: LDSH_I	ldsh	[%r16 + 0x0458], %r28
	brnz %r31,thr3_loop_cnt_1018
	dec %r31
        mov 0x93, %r31
thr3_loop_cnt_1019:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r11
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf04c2f2a  ! 1: LDSB_I	ldsb	[%r16 + 0x0f2a], %r24
	.word 0xdec42444  ! 1: LDSWA_I	ldswa	[%r16, + 0x0444] %asi, %r15
	.word 0xf0542340  ! 1: LDSH_I	ldsh	[%r16 + 0x0340], %r24
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1019
	dec %r31
	.word 0x863c24a6  ! 1: XNOR_I	xnor 	%r16, 0x04a6, %r3
        mov 0xb, %r31
thr3_loop_cnt_1020:
	.word 0xd80426f4  ! 1: LDUW_I	lduw	[%r16 + 0x06f4], %r12
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xce8c29bd  ! 1: LDUBA_I	lduba	[%r16, + 0x09bd] %asi, %r7
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6c42218  ! 1: LDSWA_I	ldswa	[%r16, + 0x0218] %asi, %r3
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	.word 0xccdc2b48  ! 1: LDXA_I	ldxa	[%r16, + 0x0b48] %asi, %r6
	.word 0xd0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r8
	.word 0xc6dc25d8  ! 1: LDXA_I	ldxa	[%r16, + 0x05d8] %asi, %r3
	brnz %r31,thr3_loop_cnt_1020
	dec %r31
        mov 0xa8, %r31
thr3_loop_cnt_1021:
	.word 0xda5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r13
	.word 0xdcd42eea  ! 1: LDSHA_I	ldsha	[%r16, + 0x0eea] %asi, %r14
	.word 0xc6542218  ! 1: LDSH_I	ldsh	[%r16 + 0x0218], %r3
	.word 0xc6542a98  ! 1: LDSH_I	ldsh	[%r16 + 0x0a98], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6dc2118  ! 1: LDXA_I	ldxa	[%r16, + 0x0118] %asi, %r3
	.word 0xc69421f0  ! 1: LDUHA_I	lduha	[%r16, + 0x01f0] %asi, %r3
	.word 0xec5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r22
	brnz %r31,thr3_loop_cnt_1021
	dec %r31
	.word 0x941c0002  ! 1: XOR_R	xor 	%r16, %r2, %r10
        mov 0x51, %r31
thr3_loop_cnt_1022:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6842a30  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a30] %asi, %r3
	.word 0xd05c2130  ! 1: LDX_I	ldx	[%r16 + 0x0130], %r8
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r9
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe6cc2d75  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d75] %asi, %r19
	.word 0xe4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r18
	brnz %r31,thr3_loop_cnt_1022
	dec %r31
	.word 0xa20c0002  ! 1: AND_R	and 	%r16, %r2, %r17
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0xa43c222c  ! 1: XNOR_I	xnor 	%r16, 0x022c, %r18
	.word 0x86442e90  ! 1: ADDC_I	addc 	%r16, 0x0e90, %r3
        mov 0x20, %r31
thr3_loop_cnt_1023:
	.word 0xce8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r7
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6cc2ff0  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ff0] %asi, %r3
	.word 0xc65428a4  ! 1: LDSH_I	ldsh	[%r16 + 0x08a4], %r3
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xded42b4c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b4c] %asi, %r15
	.word 0xc60c267d  ! 1: LDUB_I	ldub	[%r16 + 0x067d], %r3
	.word 0xf00427a8  ! 1: LDUW_I	lduw	[%r16 + 0x07a8], %r24
	brnz %r31,thr3_loop_cnt_1023
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0xa72c0002  ! 1: SLL_R	sll 	%r16, %r2, %r19
	.word 0x86242eda  ! 1: SUB_I	sub 	%r16, 0x0eda, %r3
        mov 0x33, %r31
thr3_loop_cnt_1024:
	.word 0xc614265e  ! 1: LDUH_I	lduh	[%r16 + 0x065e], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r24
	.word 0xe2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r17
	.word 0xe29428c8  ! 1: LDUHA_I	lduha	[%r16, + 0x08c8] %asi, %r17
	.word 0xce4423c4  ! 1: LDSW_I	ldsw	[%r16 + 0x03c4], %r7
	.word 0xc64c2317  ! 1: LDSB_I	ldsb	[%r16 + 0x0317], %r3
	.word 0xc6542694  ! 1: LDSH_I	ldsh	[%r16 + 0x0694], %r3
	.word 0xea0c2306  ! 1: LDUB_I	ldub	[%r16 + 0x0306], %r21
	brnz %r31,thr3_loop_cnt_1024
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0xb5342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r26
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x8e, %r31
thr3_loop_cnt_1025:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xfc1425b4  ! 1: LDUH_I	lduh	[%r16 + 0x05b4], %r30
	.word 0xc6942c96  ! 1: LDUHA_I	lduha	[%r16, + 0x0c96] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xdc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r14
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc65426f2  ! 1: LDSH_I	ldsh	[%r16 + 0x06f2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1025
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x864420bc  ! 1: ADDC_I	addc 	%r16, 0x00bc, %r3
        mov 0x7f, %r31
thr3_loop_cnt_1026:
	.word 0xf8442930  ! 1: LDSW_I	ldsw	[%r16 + 0x0930], %r28
	.word 0xe64c2bae  ! 1: LDSB_I	ldsb	[%r16 + 0x0bae], %r19
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6042920  ! 1: LDUW_I	lduw	[%r16 + 0x0920], %r3
	.word 0xc6442630  ! 1: LDSW_I	ldsw	[%r16 + 0x0630], %r3
	.word 0xc60c2354  ! 1: LDUB_I	ldub	[%r16 + 0x0354], %r3
	.word 0xf8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r28
	.word 0xeed42572  ! 1: LDSHA_I	ldsha	[%r16, + 0x0572] %asi, %r23
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6542a7c  ! 1: LDSH_I	ldsh	[%r16 + 0x0a7c], %r3
	brnz %r31,thr3_loop_cnt_1026
	dec %r31
	.word 0x8f3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r7
	.word 0x9e440002  ! 1: ADDC_R	addc 	%r16, %r2, %r15
        mov 0x87, %r31
thr3_loop_cnt_1027:
	.word 0xc64428a0  ! 1: LDSW_I	ldsw	[%r16 + 0x08a0], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xda4c2b0e  ! 1: LDSB_I	ldsb	[%r16 + 0x0b0e], %r13
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6942d10  ! 1: LDUHA_I	lduha	[%r16, + 0x0d10] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd64c2cb3  ! 1: LDSB_I	ldsb	[%r16 + 0x0cb3], %r11
	brnz %r31,thr3_loop_cnt_1027
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x9f, %r31
thr3_loop_cnt_1028:
	.word 0xc6542a7e  ! 1: LDSH_I	ldsh	[%r16 + 0x0a7e], %r3
	.word 0xd2d421c8  ! 1: LDSHA_I	ldsha	[%r16, + 0x01c8] %asi, %r9
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xe8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r20
	.word 0xc6c42058  ! 1: LDSWA_I	ldswa	[%r16, + 0x0058] %asi, %r3
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xda0c212e  ! 1: LDUB_I	ldub	[%r16 + 0x012e], %r13
	brnz %r31,thr3_loop_cnt_1028
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0xbd3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r30
	.word 0x973c1002  ! 1: SRAX_R	srax	%r16, %r2, %r11
        mov 0xc5, %r31
thr3_loop_cnt_1029:
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xc65c2d40  ! 1: LDX_I	ldx	[%r16 + 0x0d40], %r3
	.word 0xd2c42f08  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f08] %asi, %r9
	.word 0xc6042d80  ! 1: LDUW_I	lduw	[%r16 + 0x0d80], %r3
	.word 0xec8c237b  ! 1: LDUBA_I	lduba	[%r16, + 0x037b] %asi, %r22
	.word 0xf45425ea  ! 1: LDSH_I	ldsh	[%r16 + 0x05ea], %r26
	.word 0xf6542bf8  ! 1: LDSH_I	ldsh	[%r16 + 0x0bf8], %r27
	.word 0xc6c424b0  ! 1: LDSWA_I	ldswa	[%r16, + 0x04b0] %asi, %r3
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xd45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r10
	.word 0xcc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r6
	.word 0xcc8421fc  ! 1: LDUWA_I	lduwa	[%r16, + 0x01fc] %asi, %r6
	brnz %r31,thr3_loop_cnt_1029
	dec %r31
        mov 0x8a, %r31
thr3_loop_cnt_1030:
	.word 0xc6942366  ! 1: LDUHA_I	lduha	[%r16, + 0x0366] %asi, %r3
	.word 0xd6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r11
	.word 0xc6442758  ! 1: LDSW_I	ldsw	[%r16 + 0x0758], %r3
	.word 0xc65c2a60  ! 1: LDX_I	ldx	[%r16 + 0x0a60], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc644276c  ! 1: LDSW_I	ldsw	[%r16 + 0x076c], %r3
	.word 0xd4142516  ! 1: LDUH_I	lduh	[%r16 + 0x0516], %r10
	.word 0xd45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r10
	brnz %r31,thr3_loop_cnt_1030
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x993c1002  ! 1: SRAX_R	srax	%r16, %r2, %r12
	.word 0x9d342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r14
        mov 0x13, %r31
thr3_loop_cnt_1031:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r8
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r25
	.word 0xc64c2688  ! 1: LDSB_I	ldsb	[%r16 + 0x0688], %r3
	.word 0xfcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r30
	.word 0xe25c2710  ! 1: LDX_I	ldx	[%r16 + 0x0710], %r17
	.word 0xe2c421f4  ! 1: LDSWA_I	ldswa	[%r16, + 0x01f4] %asi, %r17
	.word 0xd654265c  ! 1: LDSH_I	ldsh	[%r16 + 0x065c], %r11
	.word 0xc6d42158  ! 1: LDSHA_I	ldsha	[%r16, + 0x0158] %asi, %r3
	brnz %r31,thr3_loop_cnt_1031
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0xb13c1002  ! 1: SRAX_R	srax	%r16, %r2, %r24
        mov 0x1b, %r31
thr3_loop_cnt_1032:
	.word 0xc6942782  ! 1: LDUHA_I	lduha	[%r16, + 0x0782] %asi, %r3
	.word 0xc6442694  ! 1: LDSW_I	ldsw	[%r16 + 0x0694], %r3
	.word 0xf85c2240  ! 1: LDX_I	ldx	[%r16 + 0x0240], %r28
	.word 0xee8420f8  ! 1: LDUWA_I	lduwa	[%r16, + 0x00f8] %asi, %r23
	.word 0xe8c42828  ! 1: LDSWA_I	ldswa	[%r16, + 0x0828] %asi, %r20
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd4cc2ad6  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ad6] %asi, %r10
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1032
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x863c2705  ! 1: XNOR_I	xnor 	%r16, 0x0705, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0xc5, %r31
thr3_loop_cnt_1033:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	.word 0xc6d422b4  ! 1: LDSHA_I	ldsha	[%r16, + 0x02b4] %asi, %r3
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd0c42268  ! 1: LDSWA_I	ldswa	[%r16, + 0x0268] %asi, %r8
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xc6442d08  ! 1: LDSW_I	ldsw	[%r16 + 0x0d08], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1033
	dec %r31
	.word 0x8c142ccb  ! 1: OR_I	or 	%r16, 0x0ccb, %r6
	.word 0x86242ac0  ! 1: SUB_I	sub 	%r16, 0x0ac0, %r3
        mov 0x18, %r31
thr3_loop_cnt_1034:
	.word 0xd80c25ac  ! 1: LDUB_I	ldub	[%r16 + 0x05ac], %r12
	.word 0xc604219c  ! 1: LDUW_I	lduw	[%r16 + 0x019c], %r3
	.word 0xc60c2d29  ! 1: LDUB_I	ldub	[%r16 + 0x0d29], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xce5c2f00  ! 1: LDX_I	ldx	[%r16 + 0x0f00], %r7
	.word 0xe24c29d2  ! 1: LDSB_I	ldsb	[%r16 + 0x09d2], %r17
	.word 0xc64c2019  ! 1: LDSB_I	ldsb	[%r16 + 0x0019], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xcecc28e1  ! 1: LDSBA_I	ldsba	[%r16, + 0x08e1] %asi, %r7
	.word 0xe8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r20
	.word 0xf4c42494  ! 1: LDSWA_I	ldswa	[%r16, + 0x0494] %asi, %r26
	.word 0xc6cc2da5  ! 1: LDSBA_I	ldsba	[%r16, + 0x0da5] %asi, %r3
	brnz %r31,thr3_loop_cnt_1034
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x0, %r31
thr3_loop_cnt_1035:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xdc942e5a  ! 1: LDUHA_I	lduha	[%r16, + 0x0e5a] %asi, %r14
	.word 0xf4d42c4e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c4e] %asi, %r26
	.word 0xf8d42402  ! 1: LDSHA_I	ldsha	[%r16, + 0x0402] %asi, %r28
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xecd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r22
	.word 0xc6542c08  ! 1: LDSH_I	ldsh	[%r16 + 0x0c08], %r3
	.word 0xe2442e9c  ! 1: LDSW_I	ldsw	[%r16 + 0x0e9c], %r17
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r27
	brnz %r31,thr3_loop_cnt_1035
	dec %r31
	.word 0x86442a16  ! 1: ADDC_I	addc 	%r16, 0x0a16, %r3
	.word 0x912c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r8
	.word 0x9f341002  ! 1: SRLX_R	srlx	%r16, %r2, %r15
	.word 0xa4240002  ! 1: SUB_R	sub 	%r16, %r2, %r18
        mov 0xc4, %r31
thr3_loop_cnt_1036:
	.word 0xc6842d7c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d7c] %asi, %r3
	.word 0xc61420e2  ! 1: LDUH_I	lduh	[%r16 + 0x00e2], %r3
	.word 0xd8842344  ! 1: LDUWA_I	lduwa	[%r16, + 0x0344] %asi, %r12
	.word 0xfcc42138  ! 1: LDSWA_I	ldswa	[%r16, + 0x0138] %asi, %r30
	.word 0xd25c27e0  ! 1: LDX_I	ldx	[%r16 + 0x07e0], %r9
	.word 0xfc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r30
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc68c2a60  ! 1: LDUBA_I	lduba	[%r16, + 0x0a60] %asi, %r3
	.word 0xc65425a8  ! 1: LDSH_I	ldsh	[%r16 + 0x05a8], %r3
	brnz %r31,thr3_loop_cnt_1036
	dec %r31
	.word 0x9c3c2473  ! 1: XNOR_I	xnor 	%r16, 0x0473, %r14
	.word 0xad2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r22
	.word 0x8e040002  ! 1: ADD_R	add 	%r16, %r2, %r7
        mov 0xb7, %r31
thr3_loop_cnt_1037:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc64420cc  ! 1: LDSW_I	ldsw	[%r16 + 0x00cc], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r28
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xf8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r28
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6042350  ! 1: LDUW_I	lduw	[%r16 + 0x0350], %r3
	.word 0xecc42778  ! 1: LDSWA_I	ldswa	[%r16, + 0x0778] %asi, %r22
	brnz %r31,thr3_loop_cnt_1037
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x8d2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r6
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0x46, %r31
thr3_loop_cnt_1038:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe45428a4  ! 1: LDSH_I	ldsh	[%r16 + 0x08a4], %r18
	.word 0xc60c28ed  ! 1: LDUB_I	ldub	[%r16 + 0x08ed], %r3
	.word 0xfc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r30
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	.word 0xf60426c0  ! 1: LDUW_I	lduw	[%r16 + 0x06c0], %r27
	.word 0xc6cc2cc4  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cc4] %asi, %r3
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xf2c425a4  ! 1: LDSWA_I	ldswa	[%r16, + 0x05a4] %asi, %r25
	.word 0xcc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r6
	brnz %r31,thr3_loop_cnt_1038
	dec %r31
	.word 0x932c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r9
	.word 0x9014259a  ! 1: OR_I	or 	%r16, 0x059a, %r8
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x49, %r31
thr3_loop_cnt_1039:
	.word 0xc6d42896  ! 1: LDSHA_I	ldsha	[%r16, + 0x0896] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6542ef4  ! 1: LDSH_I	ldsh	[%r16 + 0x0ef4], %r3
	.word 0xc6942c82  ! 1: LDUHA_I	lduha	[%r16, + 0x0c82] %asi, %r3
	.word 0xccc426d4  ! 1: LDSWA_I	ldswa	[%r16, + 0x06d4] %asi, %r6
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r24
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1039
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0xa8240002  ! 1: SUB_R	sub 	%r16, %r2, %r20
        mov 0x9, %r31
thr3_loop_cnt_1040:
	.word 0xcc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r6
	.word 0xce842f38  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f38] %asi, %r7
	.word 0xc6842060  ! 1: LDUWA_I	lduwa	[%r16, + 0x0060] %asi, %r3
	.word 0xc64c253f  ! 1: LDSB_I	ldsb	[%r16 + 0x053f], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6dc2860  ! 1: LDXA_I	ldxa	[%r16, + 0x0860] %asi, %r3
	.word 0xf8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r28
	.word 0xc60422cc  ! 1: LDUW_I	lduw	[%r16 + 0x02cc], %r3
	.word 0xc6542938  ! 1: LDSH_I	ldsh	[%r16 + 0x0938], %r3
	.word 0xc6542694  ! 1: LDSH_I	ldsh	[%r16 + 0x0694], %r3
	.word 0xce5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r7
	brnz %r31,thr3_loop_cnt_1040
	dec %r31
	.word 0xa7343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r19
	.word 0x86342fc0  ! 1: ORN_I	orn 	%r16, 0x0fc0, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0x7e, %r31
thr3_loop_cnt_1041:
	.word 0xd8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r12
	.word 0xe6942156  ! 1: LDUHA_I	lduha	[%r16, + 0x0156] %asi, %r19
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	.word 0xde4c2af0  ! 1: LDSB_I	ldsb	[%r16 + 0x0af0], %r15
	.word 0xeedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r23
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc65c2448  ! 1: LDX_I	ldx	[%r16 + 0x0448], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r12
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	brnz %r31,thr3_loop_cnt_1041
	dec %r31
        mov 0x8f, %r31
thr3_loop_cnt_1042:
	.word 0xc6cc2b72  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b72] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc68c2303  ! 1: LDUBA_I	lduba	[%r16, + 0x0303] %asi, %r3
	.word 0xc6d42d8a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d8a] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xfc942032  ! 1: LDUHA_I	lduha	[%r16, + 0x0032] %asi, %r30
	.word 0xee14248c  ! 1: LDUH_I	lduh	[%r16 + 0x048c], %r23
	brnz %r31,thr3_loop_cnt_1042
	dec %r31
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x19, %r31
thr3_loop_cnt_1043:
	.word 0xd8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r12
	.word 0xc6d42a60  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a60] %asi, %r3
	.word 0xe2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r17
	.word 0xd2142594  ! 1: LDUH_I	lduh	[%r16 + 0x0594], %r9
	.word 0xda841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r13
	.word 0xd2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r9
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1043
	dec %r31
	.word 0xa9341002  ! 1: SRLX_R	srlx	%r16, %r2, %r20
        mov 0x5a, %r31
thr3_loop_cnt_1044:
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6d42b3e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b3e] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r25
	.word 0xc6cc26c3  ! 1: LDSBA_I	ldsba	[%r16, + 0x06c3] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1044
	dec %r31
	.word 0x86242aa8  ! 1: SUB_I	sub 	%r16, 0x0aa8, %r3
	.word 0x98142466  ! 1: OR_I	or 	%r16, 0x0466, %r12
	.word 0xbc1c22da  ! 1: XOR_I	xor 	%r16, 0x02da, %r30
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0xd, %r31
thr3_loop_cnt_1045:
	.word 0xe8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r20
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xc6142e0a  ! 1: LDUH_I	lduh	[%r16 + 0x0e0a], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc64c2a05  ! 1: LDSB_I	ldsb	[%r16 + 0x0a05], %r3
	.word 0xe60c2019  ! 1: LDUB_I	ldub	[%r16 + 0x0019], %r19
	.word 0xe24c2cf4  ! 1: LDSB_I	ldsb	[%r16 + 0x0cf4], %r17
	.word 0xfad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r29
	.word 0xea8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r21
	.word 0xf8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r28
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r27
	brnz %r31,thr3_loop_cnt_1045
	dec %r31
	.word 0x860c2aac  ! 1: AND_I	and 	%r16, 0x0aac, %r3
	.word 0x8c1c274c  ! 1: XOR_I	xor 	%r16, 0x074c, %r6
	.word 0xba340002  ! 1: SUBC_R	orn 	%r16, %r2, %r29
        mov 0x17, %r31
thr3_loop_cnt_1046:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6442b8c  ! 1: LDSW_I	ldsw	[%r16 + 0x0b8c], %r3
	.word 0xf8cc2652  ! 1: LDSBA_I	ldsba	[%r16, + 0x0652] %asi, %r28
	.word 0xfa5425e0  ! 1: LDSH_I	ldsh	[%r16 + 0x05e0], %r29
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r27
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf0d422b2  ! 1: LDSHA_I	ldsha	[%r16, + 0x02b2] %asi, %r24
	brnz %r31,thr3_loop_cnt_1046
	dec %r31
	.word 0xab2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r21
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0xb60c23dd  ! 1: AND_I	and 	%r16, 0x03dd, %r27
        mov 0x23, %r31
thr3_loop_cnt_1047:
	.word 0xc6942982  ! 1: LDUHA_I	lduha	[%r16, + 0x0982] %asi, %r3
	.word 0xee442b30  ! 1: LDSW_I	ldsw	[%r16 + 0x0b30], %r23
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xfc942874  ! 1: LDUHA_I	lduha	[%r16, + 0x0874] %asi, %r30
	.word 0xc6942afe  ! 1: LDUHA_I	lduha	[%r16, + 0x0afe] %asi, %r3
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xde1428de  ! 1: LDUH_I	lduh	[%r16 + 0x08de], %r15
	.word 0xfadc2418  ! 1: LDXA_I	ldxa	[%r16, + 0x0418] %asi, %r29
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	.word 0xc65426a0  ! 1: LDSH_I	ldsh	[%r16 + 0x06a0], %r3
	brnz %r31,thr3_loop_cnt_1047
	dec %r31
	.word 0xb8440002  ! 1: ADDC_R	addc 	%r16, %r2, %r28
	.word 0xa41c2663  ! 1: XOR_I	xor 	%r16, 0x0663, %r18
	.word 0xb6340002  ! 1: SUBC_R	orn 	%r16, %r2, %r27
	.word 0xbb2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r29
        mov 0x65, %r31
thr3_loop_cnt_1048:
	.word 0xc6042c70  ! 1: LDUW_I	lduw	[%r16 + 0x0c70], %r3
	.word 0xe24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r17
	.word 0xc6542154  ! 1: LDSH_I	ldsh	[%r16 + 0x0154], %r3
	.word 0xc68c2355  ! 1: LDUBA_I	lduba	[%r16, + 0x0355] %asi, %r3
	.word 0xc64420cc  ! 1: LDSW_I	ldsw	[%r16 + 0x00cc], %r3
	.word 0xd88c24e5  ! 1: LDUBA_I	lduba	[%r16, + 0x04e5] %asi, %r12
	.word 0xc6142a9e  ! 1: LDUH_I	lduh	[%r16 + 0x0a9e], %r3
	.word 0xf4cc26ca  ! 1: LDSBA_I	ldsba	[%r16, + 0x06ca] %asi, %r26
	brnz %r31,thr3_loop_cnt_1048
	dec %r31
	.word 0xb3340002  ! 1: SRL_R	srl 	%r16, %r2, %r25
	.word 0xb6240002  ! 1: SUB_R	sub 	%r16, %r2, %r27
        mov 0x89, %r31
thr3_loop_cnt_1049:
	.word 0xc65c21d0  ! 1: LDX_I	ldx	[%r16 + 0x01d0], %r3
	.word 0xfc4c289d  ! 1: LDSB_I	ldsb	[%r16 + 0x089d], %r30
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xc6142eb6  ! 1: LDUH_I	lduh	[%r16 + 0x0eb6], %r3
	.word 0xc65c2270  ! 1: LDX_I	ldx	[%r16 + 0x0270], %r3
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	.word 0xf05c2910  ! 1: LDX_I	ldx	[%r16 + 0x0910], %r24
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6442f54  ! 1: LDSW_I	ldsw	[%r16 + 0x0f54], %r3
	.word 0xe4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r18
	.word 0xda941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r13
	.word 0xde5c24d0  ! 1: LDX_I	ldx	[%r16 + 0x04d0], %r15
	brnz %r31,thr3_loop_cnt_1049
	dec %r31
	.word 0x9e340002  ! 1: SUBC_R	orn 	%r16, %r2, %r15
        mov 0xc6, %r31
thr3_loop_cnt_1050:
	.word 0xc6842a74  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a74] %asi, %r3
	.word 0xecc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r22
	.word 0xd6dc2e60  ! 1: LDXA_I	ldxa	[%r16, + 0x0e60] %asi, %r11
	.word 0xd6dc2790  ! 1: LDXA_I	ldxa	[%r16, + 0x0790] %asi, %r11
	.word 0xc6142a9e  ! 1: LDUH_I	lduh	[%r16 + 0x0a9e], %r3
	.word 0xf6842324  ! 1: LDUWA_I	lduwa	[%r16, + 0x0324] %asi, %r27
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xee8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r23
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc68c2e6a  ! 1: LDUBA_I	lduba	[%r16, + 0x0e6a] %asi, %r3
	brnz %r31,thr3_loop_cnt_1050
	dec %r31
	.word 0x863c2562  ! 1: XNOR_I	xnor 	%r16, 0x0562, %r3
	.word 0xa80420e1  ! 1: ADD_I	add 	%r16, 0x00e1, %r20
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
        mov 0x99, %r31
thr3_loop_cnt_1051:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xee142422  ! 1: LDUH_I	lduh	[%r16 + 0x0422], %r23
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd28c23b8  ! 1: LDUBA_I	lduba	[%r16, + 0x03b8] %asi, %r9
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xfcd42948  ! 1: LDSHA_I	ldsha	[%r16, + 0x0948] %asi, %r30
	.word 0xc6dc23e8  ! 1: LDXA_I	ldxa	[%r16, + 0x03e8] %asi, %r3
	brnz %r31,thr3_loop_cnt_1051
	dec %r31
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x9e0c0002  ! 1: AND_R	and 	%r16, %r2, %r15
        mov 0x1c, %r31
thr3_loop_cnt_1052:
	.word 0xc68c2517  ! 1: LDUBA_I	lduba	[%r16, + 0x0517] %asi, %r3
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xf25424b0  ! 1: LDSH_I	ldsh	[%r16 + 0x04b0], %r25
	.word 0xeec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r23
	.word 0xe2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r17
	.word 0xc6dc2dd8  ! 1: LDXA_I	ldxa	[%r16, + 0x0dd8] %asi, %r3
	.word 0xc65c2870  ! 1: LDX_I	ldx	[%r16 + 0x0870], %r3
	.word 0xee0c2261  ! 1: LDUB_I	ldub	[%r16 + 0x0261], %r23
	.word 0xc65c26a8  ! 1: LDX_I	ldx	[%r16 + 0x06a8], %r3
	.word 0xf6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r27
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	brnz %r31,thr3_loop_cnt_1052
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0xa3, %r31
thr3_loop_cnt_1053:
	.word 0xf8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r28
	.word 0xfc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r30
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xf2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r25
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xdc5c2430  ! 1: LDX_I	ldx	[%r16 + 0x0430], %r14
	.word 0xf644266c  ! 1: LDSW_I	ldsw	[%r16 + 0x066c], %r27
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xf4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r26
	.word 0xf2d4210a  ! 1: LDSHA_I	ldsha	[%r16, + 0x010a] %asi, %r25
	.word 0xf00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r24
	brnz %r31,thr3_loop_cnt_1053
	dec %r31
	.word 0x921c2bb0  ! 1: XOR_I	xor 	%r16, 0x0bb0, %r9
	.word 0x9b343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r13
	.word 0x863429c8  ! 1: SUBC_I	orn 	%r16, 0x09c8, %r3
	.word 0x9b2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r13
        mov 0x7a, %r31
thr3_loop_cnt_1054:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xee440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r23
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc68c2a65  ! 1: LDUBA_I	lduba	[%r16, + 0x0a65] %asi, %r3
	.word 0xc64422c0  ! 1: LDSW_I	ldsw	[%r16 + 0x02c0], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xfc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r30
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r12
	.word 0xc68c2814  ! 1: LDUBA_I	lduba	[%r16, + 0x0814] %asi, %r3
	brnz %r31,thr3_loop_cnt_1054
	dec %r31
	.word 0x8e242c97  ! 1: SUB_I	sub 	%r16, 0x0c97, %r7
        mov 0x72, %r31
thr3_loop_cnt_1055:
	.word 0xf414250a  ! 1: LDUH_I	lduh	[%r16 + 0x050a], %r26
	.word 0xc6542e00  ! 1: LDSH_I	ldsh	[%r16 + 0x0e00], %r3
	.word 0xf60c24de  ! 1: LDUB_I	ldub	[%r16 + 0x04de], %r27
	.word 0xf814214e  ! 1: LDUH_I	lduh	[%r16 + 0x014e], %r28
	.word 0xc6442cb8  ! 1: LDSW_I	ldsw	[%r16 + 0x0cb8], %r3
	.word 0xc6542ac8  ! 1: LDSH_I	ldsh	[%r16 + 0x0ac8], %r3
	.word 0xc6942990  ! 1: LDUHA_I	lduha	[%r16, + 0x0990] %asi, %r3
	.word 0xe48425f0  ! 1: LDUWA_I	lduwa	[%r16, + 0x05f0] %asi, %r18
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xc6cc2ef3  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ef3] %asi, %r3
	.word 0xfacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r29
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1055
	dec %r31
	.word 0x9f2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r15
        mov 0x2, %r31
thr3_loop_cnt_1056:
	.word 0xc6dc2488  ! 1: LDXA_I	ldxa	[%r16, + 0x0488] %asi, %r3
	.word 0xec9425cc  ! 1: LDUHA_I	lduha	[%r16, + 0x05cc] %asi, %r22
	.word 0xe64427d4  ! 1: LDSW_I	ldsw	[%r16 + 0x07d4], %r19
	.word 0xec4c2915  ! 1: LDSB_I	ldsb	[%r16 + 0x0915], %r22
	.word 0xdcd42b96  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b96] %asi, %r14
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6dc2100  ! 1: LDXA_I	ldxa	[%r16, + 0x0100] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xce5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r7
	.word 0xf8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r28
	.word 0xc6842920  ! 1: LDUWA_I	lduwa	[%r16, + 0x0920] %asi, %r3
	brnz %r31,thr3_loop_cnt_1056
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x1b, %r31
thr3_loop_cnt_1057:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r19
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xde841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r15
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc60c2f2d  ! 1: LDUB_I	ldub	[%r16 + 0x0f2d], %r3
	.word 0xe6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r19
	.word 0xc6442ce8  ! 1: LDSW_I	ldsw	[%r16 + 0x0ce8], %r3
	.word 0xc68426e0  ! 1: LDUWA_I	lduwa	[%r16, + 0x06e0] %asi, %r3
	brnz %r31,thr3_loop_cnt_1057
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0x4f, %r31
thr3_loop_cnt_1058:
	.word 0xc65c2b58  ! 1: LDX_I	ldx	[%r16 + 0x0b58], %r3
	.word 0xd2042d04  ! 1: LDUW_I	lduw	[%r16 + 0x0d04], %r9
	.word 0xcc142cf6  ! 1: LDUH_I	lduh	[%r16 + 0x0cf6], %r6
	.word 0xe48c269c  ! 1: LDUBA_I	lduba	[%r16, + 0x069c] %asi, %r18
	.word 0xc60c206a  ! 1: LDUB_I	ldub	[%r16 + 0x006a], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	.word 0xf8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r28
	.word 0xf0142510  ! 1: LDUH_I	lduh	[%r16 + 0x0510], %r24
	.word 0xc6c42324  ! 1: LDSWA_I	ldswa	[%r16, + 0x0324] %asi, %r3
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	.word 0xcedc2ea0  ! 1: LDXA_I	ldxa	[%r16, + 0x0ea0] %asi, %r7
	brnz %r31,thr3_loop_cnt_1058
	dec %r31
        mov 0x42, %r31
thr3_loop_cnt_1059:
	.word 0xea941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r21
	.word 0xc6142746  ! 1: LDUH_I	lduh	[%r16 + 0x0746], %r3
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xd85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r12
	.word 0xf85c2938  ! 1: LDX_I	ldx	[%r16 + 0x0938], %r28
	.word 0xc69422a4  ! 1: LDUHA_I	lduha	[%r16, + 0x02a4] %asi, %r3
	.word 0xc64c29bd  ! 1: LDSB_I	ldsb	[%r16 + 0x09bd], %r3
	.word 0xdadc2860  ! 1: LDXA_I	ldxa	[%r16, + 0x0860] %asi, %r13
	.word 0xf4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r26
	brnz %r31,thr3_loop_cnt_1059
	dec %r31
	.word 0x860c28a4  ! 1: AND_I	and 	%r16, 0x08a4, %r3
        mov 0x6e, %r31
thr3_loop_cnt_1060:
	.word 0xc6542cfe  ! 1: LDSH_I	ldsh	[%r16 + 0x0cfe], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xdc4428f0  ! 1: LDSW_I	ldsw	[%r16 + 0x08f0], %r14
	.word 0xee440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r23
	.word 0xc60c2362  ! 1: LDUB_I	ldub	[%r16 + 0x0362], %r3
	.word 0xd6142272  ! 1: LDUH_I	lduh	[%r16 + 0x0272], %r11
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc644242c  ! 1: LDSW_I	ldsw	[%r16 + 0x042c], %r3
	.word 0xf4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r26
	brnz %r31,thr3_loop_cnt_1060
	dec %r31
	.word 0x9e1c2bac  ! 1: XOR_I	xor 	%r16, 0x0bac, %r15
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0xa73c0002  ! 1: SRA_R	sra 	%r16, %r2, %r19
	.word 0xbb3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r29
        mov 0x5a, %r31
thr3_loop_cnt_1061:
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	.word 0xc65c2268  ! 1: LDX_I	ldx	[%r16 + 0x0268], %r3
	.word 0xf6dc2058  ! 1: LDXA_I	ldxa	[%r16, + 0x0058] %asi, %r27
	.word 0xec941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r22
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xd6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r11
	.word 0xc60c235e  ! 1: LDUB_I	ldub	[%r16 + 0x035e], %r3
	.word 0xccdc2888  ! 1: LDXA_I	ldxa	[%r16, + 0x0888] %asi, %r6
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xfc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r30
	.word 0xe6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r19
	.word 0xd45c2b80  ! 1: LDX_I	ldx	[%r16 + 0x0b80], %r10
	brnz %r31,thr3_loop_cnt_1061
	dec %r31
	.word 0xbc240002  ! 1: SUB_R	sub 	%r16, %r2, %r30
	.word 0xa23c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r17
	.word 0xb12c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r24
	.word 0x8d3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r6
        mov 0xa9, %r31
thr3_loop_cnt_1062:
	.word 0xc6842824  ! 1: LDUWA_I	lduwa	[%r16, + 0x0824] %asi, %r3
	.word 0xd68c2426  ! 1: LDUBA_I	lduba	[%r16, + 0x0426] %asi, %r11
	.word 0xcedc2530  ! 1: LDXA_I	ldxa	[%r16, + 0x0530] %asi, %r7
	.word 0xe65c2fe8  ! 1: LDX_I	ldx	[%r16 + 0x0fe8], %r19
	.word 0xea440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r21
	.word 0xe48c2b35  ! 1: LDUBA_I	lduba	[%r16, + 0x0b35] %asi, %r18
	.word 0xdcdc2f78  ! 1: LDXA_I	ldxa	[%r16, + 0x0f78] %asi, %r14
	.word 0xe4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r18
	.word 0xd68c2327  ! 1: LDUBA_I	lduba	[%r16, + 0x0327] %asi, %r11
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1062
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x94340002  ! 1: SUBC_R	orn 	%r16, %r2, %r10
	.word 0xac242afb  ! 1: SUB_I	sub 	%r16, 0x0afb, %r22
        mov 0x1c, %r31
thr3_loop_cnt_1063:
	.word 0xe40c2ab1  ! 1: LDUB_I	ldub	[%r16 + 0x0ab1], %r18
	.word 0xf44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r26
	.word 0xccd42922  ! 1: LDSHA_I	ldsha	[%r16, + 0x0922] %asi, %r6
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xd64c2b2c  ! 1: LDSB_I	ldsb	[%r16 + 0x0b2c], %r11
	.word 0xd0d42720  ! 1: LDSHA_I	ldsha	[%r16, + 0x0720] %asi, %r8
	.word 0xcc042b64  ! 1: LDUW_I	lduw	[%r16 + 0x0b64], %r6
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xd4942b30  ! 1: LDUHA_I	lduha	[%r16, + 0x0b30] %asi, %r10
	.word 0xfa5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r29
	brnz %r31,thr3_loop_cnt_1063
	dec %r31
	.word 0x92440002  ! 1: ADDC_R	addc 	%r16, %r2, %r9
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x95, %r31
thr3_loop_cnt_1064:
	.word 0xc60c25b8  ! 1: LDUB_I	ldub	[%r16 + 0x05b8], %r3
	.word 0xc6442c94  ! 1: LDSW_I	ldsw	[%r16 + 0x0c94], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc65c26b0  ! 1: LDX_I	ldx	[%r16 + 0x06b0], %r3
	.word 0xd8cc22fc  ! 1: LDSBA_I	ldsba	[%r16, + 0x02fc] %asi, %r12
	.word 0xd0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r8
	.word 0xe6542366  ! 1: LDSH_I	ldsh	[%r16 + 0x0366], %r19
	.word 0xf0442148  ! 1: LDSW_I	ldsw	[%r16 + 0x0148], %r24
	.word 0xc69421d6  ! 1: LDUHA_I	lduha	[%r16, + 0x01d6] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6442dc4  ! 1: LDSW_I	ldsw	[%r16 + 0x0dc4], %r3
	brnz %r31,thr3_loop_cnt_1064
	dec %r31
	.word 0x860c2f34  ! 1: AND_I	and 	%r16, 0x0f34, %r3
        mov 0xa8, %r31
thr3_loop_cnt_1065:
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	.word 0xc6d42fe8  ! 1: LDSHA_I	ldsha	[%r16, + 0x0fe8] %asi, %r3
	.word 0xe4dc2438  ! 1: LDXA_I	ldxa	[%r16, + 0x0438] %asi, %r18
	.word 0xf40c24fa  ! 1: LDUB_I	ldub	[%r16 + 0x04fa], %r26
	.word 0xdc142c82  ! 1: LDUH_I	lduh	[%r16 + 0x0c82], %r14
	.word 0xc65c2a28  ! 1: LDX_I	ldx	[%r16 + 0x0a28], %r3
	.word 0xfcd42ad8  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ad8] %asi, %r30
	.word 0xdecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r15
	.word 0xc65c2728  ! 1: LDX_I	ldx	[%r16 + 0x0728], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xfac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r29
	brnz %r31,thr3_loop_cnt_1065
	dec %r31
	.word 0x8d343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r6
        mov 0xba, %r31
thr3_loop_cnt_1066:
	.word 0xdecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r15
	.word 0xeecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r23
	.word 0xea140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r21
	.word 0xc684206c  ! 1: LDUWA_I	lduwa	[%r16, + 0x006c] %asi, %r3
	.word 0xc6c42e20  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e20] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd64c2b17  ! 1: LDSB_I	ldsb	[%r16 + 0x0b17], %r11
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1066
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x89, %r31
thr3_loop_cnt_1067:
	.word 0xea542786  ! 1: LDSH_I	ldsh	[%r16 + 0x0786], %r21
	.word 0xd284205c  ! 1: LDUWA_I	lduwa	[%r16, + 0x005c] %asi, %r9
	.word 0xeac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r21
	.word 0xc6c4274c  ! 1: LDSWA_I	ldswa	[%r16, + 0x074c] %asi, %r3
	.word 0xf2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r25
	.word 0xe6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r19
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xdedc2698  ! 1: LDXA_I	ldxa	[%r16, + 0x0698] %asi, %r15
	.word 0xe2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r17
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1067
	dec %r31
	.word 0x90342cc3  ! 1: SUBC_I	orn 	%r16, 0x0cc3, %r8
	.word 0x863423c4  ! 1: SUBC_I	orn 	%r16, 0x03c4, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0x2a, %r31
thr3_loop_cnt_1068:
	.word 0xc6442e4c  ! 1: LDSW_I	ldsw	[%r16 + 0x0e4c], %r3
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	.word 0xc6c42b68  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b68] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xde442958  ! 1: LDSW_I	ldsw	[%r16 + 0x0958], %r15
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc694212a  ! 1: LDUHA_I	lduha	[%r16, + 0x012a] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r26
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1068
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0xab340002  ! 1: SRL_R	srl 	%r16, %r2, %r21
        mov 0x7, %r31
thr3_loop_cnt_1069:
	.word 0xc6c42f34  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f34] %asi, %r3
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6c42378  ! 1: LDSWA_I	ldswa	[%r16, + 0x0378] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xcc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r6
	.word 0xc6d42aba  ! 1: LDSHA_I	ldsha	[%r16, + 0x0aba] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1069
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0xb234280f  ! 1: ORN_I	orn 	%r16, 0x080f, %r25
        mov 0xbf, %r31
thr3_loop_cnt_1070:
	.word 0xd00c2326  ! 1: LDUB_I	ldub	[%r16 + 0x0326], %r8
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xee440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r23
	.word 0xc6c4201c  ! 1: LDSWA_I	ldswa	[%r16, + 0x001c] %asi, %r3
	.word 0xf8d42bbc  ! 1: LDSHA_I	ldsha	[%r16, + 0x0bbc] %asi, %r28
	.word 0xf6c42af4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0af4] %asi, %r27
	.word 0xf2dc2e58  ! 1: LDXA_I	ldxa	[%r16, + 0x0e58] %asi, %r25
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	.word 0xf6042b58  ! 1: LDUW_I	lduw	[%r16 + 0x0b58], %r27
	brnz %r31,thr3_loop_cnt_1070
	dec %r31
	.word 0x973c1002  ! 1: SRAX_R	srax	%r16, %r2, %r11
	.word 0xbc3c25a5  ! 1: XNOR_I	xnor 	%r16, 0x05a5, %r30
        mov 0x1, %r31
thr3_loop_cnt_1071:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd8542122  ! 1: LDSH_I	ldsh	[%r16 + 0x0122], %r12
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xd0dc26d0  ! 1: LDXA_I	ldxa	[%r16, + 0x06d0] %asi, %r8
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xc6dc2908  ! 1: LDXA_I	ldxa	[%r16, + 0x0908] %asi, %r3
	.word 0xc60c2f2e  ! 1: LDUB_I	ldub	[%r16 + 0x0f2e], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1071
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0xa3, %r31
thr3_loop_cnt_1072:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xda140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r13
	.word 0xc6142646  ! 1: LDUH_I	lduh	[%r16 + 0x0646], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r8
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xecd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r22
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1072
	dec %r31
	.word 0xbc0c0002  ! 1: AND_R	and 	%r16, %r2, %r30
	.word 0xac2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r22
        mov 0x80, %r31
thr3_loop_cnt_1073:
	.word 0xc65420c2  ! 1: LDSH_I	ldsh	[%r16 + 0x00c2], %r3
	.word 0xe88422b4  ! 1: LDUWA_I	lduwa	[%r16, + 0x02b4] %asi, %r20
	.word 0xf6d4247a  ! 1: LDSHA_I	ldsha	[%r16, + 0x047a] %asi, %r27
	.word 0xee5c2ea0  ! 1: LDX_I	ldx	[%r16 + 0x0ea0], %r23
	.word 0xc6942af2  ! 1: LDUHA_I	lduha	[%r16, + 0x0af2] %asi, %r3
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1073
	dec %r31
	.word 0x862c2584  ! 1: ANDN_I	andn 	%r16, 0x0584, %r3
        mov 0x79, %r31
thr3_loop_cnt_1074:
	.word 0xf88c24b0  ! 1: LDUBA_I	lduba	[%r16, + 0x04b0] %asi, %r28
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xeec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r23
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r27
	.word 0xd8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r12
	.word 0xc6942ee4  ! 1: LDUHA_I	lduha	[%r16, + 0x0ee4] %asi, %r3
	.word 0xd05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r8
	.word 0xc60c2030  ! 1: LDUB_I	ldub	[%r16 + 0x0030], %r3
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	brnz %r31,thr3_loop_cnt_1074
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x8c0c0002  ! 1: AND_R	and 	%r16, %r2, %r6
	.word 0x86342954  ! 1: SUBC_I	orn 	%r16, 0x0954, %r3
        mov 0x28, %r31
thr3_loop_cnt_1075:
	.word 0xea14284c  ! 1: LDUH_I	lduh	[%r16 + 0x084c], %r21
	.word 0xc65c2768  ! 1: LDX_I	ldx	[%r16 + 0x0768], %r3
	.word 0xf24c2897  ! 1: LDSB_I	ldsb	[%r16 + 0x0897], %r25
	.word 0xf2442950  ! 1: LDSW_I	ldsw	[%r16 + 0x0950], %r25
	.word 0xec442f20  ! 1: LDSW_I	ldsw	[%r16 + 0x0f20], %r22
	.word 0xc6c42d90  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d90] %asi, %r3
	.word 0xde440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r15
	.word 0xc68422b4  ! 1: LDUWA_I	lduwa	[%r16, + 0x02b4] %asi, %r3
	.word 0xc60c25b7  ! 1: LDUB_I	ldub	[%r16 + 0x05b7], %r3
	.word 0xde040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r15
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	brnz %r31,thr3_loop_cnt_1075
	dec %r31
	.word 0x9a340002  ! 1: SUBC_R	orn 	%r16, %r2, %r13
	.word 0xbb341002  ! 1: SRLX_R	srlx	%r16, %r2, %r29
        mov 0xab, %r31
thr3_loop_cnt_1076:
	.word 0xe2842474  ! 1: LDUWA_I	lduwa	[%r16, + 0x0474] %asi, %r17
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xc61428d2  ! 1: LDUH_I	lduh	[%r16 + 0x08d2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc694281a  ! 1: LDUHA_I	lduha	[%r16, + 0x081a] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xcc5c2cf8  ! 1: LDX_I	ldx	[%r16 + 0x0cf8], %r6
	.word 0xc6cc2608  ! 1: LDSBA_I	ldsba	[%r16, + 0x0608] %asi, %r3
	.word 0xc6dc2288  ! 1: LDXA_I	ldxa	[%r16, + 0x0288] %asi, %r3
	.word 0xf64c2363  ! 1: LDSB_I	ldsb	[%r16 + 0x0363], %r27
	brnz %r31,thr3_loop_cnt_1076
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0x85, %r31
thr3_loop_cnt_1077:
	.word 0xf6142f6c  ! 1: LDUH_I	lduh	[%r16 + 0x0f6c], %r27
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd8442f88  ! 1: LDSW_I	ldsw	[%r16 + 0x0f88], %r12
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2ad0  ! 1: LDXA_I	ldxa	[%r16, + 0x0ad0] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xcc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r6
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r27
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1077
	dec %r31
        mov 0xa5, %r31
thr3_loop_cnt_1078:
	.word 0xc6d42248  ! 1: LDSHA_I	ldsha	[%r16, + 0x0248] %asi, %r3
	.word 0xdad425ba  ! 1: LDSHA_I	ldsha	[%r16, + 0x05ba] %asi, %r13
	.word 0xc60427d8  ! 1: LDUW_I	lduw	[%r16 + 0x07d8], %r3
	.word 0xe8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r20
	.word 0xe6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r19
	.word 0xcc942be0  ! 1: LDUHA_I	lduha	[%r16, + 0x0be0] %asi, %r6
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc64c202b  ! 1: LDSB_I	ldsb	[%r16 + 0x002b], %r3
	brnz %r31,thr3_loop_cnt_1078
	dec %r31
	.word 0x86442cfc  ! 1: ADDC_I	addc 	%r16, 0x0cfc, %r3
	.word 0x90442511  ! 1: ADDC_I	addc 	%r16, 0x0511, %r8
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0xba14237e  ! 1: OR_I	or 	%r16, 0x037e, %r29
        mov 0xe, %r31
thr3_loop_cnt_1079:
	.word 0xc6142618  ! 1: LDUH_I	lduh	[%r16 + 0x0618], %r3
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe24c2232  ! 1: LDSB_I	ldsb	[%r16 + 0x0232], %r17
	.word 0xd4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r10
	.word 0xc6142b3a  ! 1: LDUH_I	lduh	[%r16 + 0x0b3a], %r3
	.word 0xc654291e  ! 1: LDSH_I	ldsh	[%r16 + 0x091e], %r3
	.word 0xc6c42d54  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d54] %asi, %r3
	.word 0xc6cc25d1  ! 1: LDSBA_I	ldsba	[%r16, + 0x05d1] %asi, %r3
	brnz %r31,thr3_loop_cnt_1079
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0xa6140002  ! 1: OR_R	or 	%r16, %r2, %r19
	.word 0x90442065  ! 1: ADDC_I	addc 	%r16, 0x0065, %r8
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0xc7, %r31
thr3_loop_cnt_1080:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xfc542a36  ! 1: LDSH_I	ldsh	[%r16 + 0x0a36], %r30
	.word 0xc6942d40  ! 1: LDUHA_I	lduha	[%r16, + 0x0d40] %asi, %r3
	.word 0xc68c2dc2  ! 1: LDUBA_I	lduba	[%r16, + 0x0dc2] %asi, %r3
	.word 0xc6542fbe  ! 1: LDSH_I	ldsh	[%r16 + 0x0fbe], %r3
	.word 0xfacc20af  ! 1: LDSBA_I	ldsba	[%r16, + 0x00af] %asi, %r29
	.word 0xf2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r25
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc60c2b89  ! 1: LDUB_I	ldub	[%r16 + 0x0b89], %r3
	brnz %r31,thr3_loop_cnt_1080
	dec %r31
	.word 0xac440002  ! 1: ADDC_R	addc 	%r16, %r2, %r22
	.word 0x861428ff  ! 1: OR_I	or 	%r16, 0x08ff, %r3
	.word 0x90342d5b  ! 1: SUBC_I	orn 	%r16, 0x0d5b, %r8
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0x39, %r31
thr3_loop_cnt_1081:
	.word 0xf08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r24
	.word 0xc6c424b8  ! 1: LDSWA_I	ldswa	[%r16, + 0x04b8] %asi, %r3
	.word 0xd64c2fdf  ! 1: LDSB_I	ldsb	[%r16 + 0x0fdf], %r11
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc69420c2  ! 1: LDUHA_I	lduha	[%r16, + 0x00c2] %asi, %r3
	.word 0xd2cc2c69  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c69] %asi, %r9
	.word 0xe6dc2730  ! 1: LDXA_I	ldxa	[%r16, + 0x0730] %asi, %r19
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1081
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0xa8, %r31
thr3_loop_cnt_1082:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc65c2c20  ! 1: LDX_I	ldx	[%r16 + 0x0c20], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc60c2699  ! 1: LDUB_I	ldub	[%r16 + 0x0699], %r3
	.word 0xf6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r27
	.word 0xd8842304  ! 1: LDUWA_I	lduwa	[%r16, + 0x0304] %asi, %r12
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xee440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r23
	.word 0xd0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r8
	.word 0xec9420e2  ! 1: LDUHA_I	lduha	[%r16, + 0x00e2] %asi, %r22
	brnz %r31,thr3_loop_cnt_1082
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0x88, %r31
thr3_loop_cnt_1083:
	.word 0xf2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r25
	.word 0xfc442dc8  ! 1: LDSW_I	ldsw	[%r16 + 0x0dc8], %r30
	.word 0xc6c42258  ! 1: LDSWA_I	ldswa	[%r16, + 0x0258] %asi, %r3
	.word 0xc6142352  ! 1: LDUH_I	lduh	[%r16 + 0x0352], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf2dc2988  ! 1: LDXA_I	ldxa	[%r16, + 0x0988] %asi, %r25
	brnz %r31,thr3_loop_cnt_1083
	dec %r31
	.word 0x923c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r9
	.word 0x9e042fc2  ! 1: ADD_I	add 	%r16, 0x0fc2, %r15
        mov 0x7d, %r31
thr3_loop_cnt_1084:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xc614200e  ! 1: LDUH_I	lduh	[%r16 + 0x000e], %r3
	.word 0xf4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r26
	.word 0xf444285c  ! 1: LDSW_I	ldsw	[%r16 + 0x085c], %r26
	.word 0xee0c29ec  ! 1: LDUB_I	ldub	[%r16 + 0x09ec], %r23
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf4cc2ba5  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ba5] %asi, %r26
	.word 0xe24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r17
	brnz %r31,thr3_loop_cnt_1084
	dec %r31
        mov 0x2d, %r31
thr3_loop_cnt_1085:
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xf4142872  ! 1: LDUH_I	lduh	[%r16 + 0x0872], %r26
	.word 0xd29423c8  ! 1: LDUHA_I	lduha	[%r16, + 0x03c8] %asi, %r9
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xce4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r7
	.word 0xfa942d6e  ! 1: LDUHA_I	lduha	[%r16, + 0x0d6e] %asi, %r29
	.word 0xe4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r18
	.word 0xf64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r27
	brnz %r31,thr3_loop_cnt_1085
	dec %r31
	.word 0xb8242476  ! 1: SUB_I	sub 	%r16, 0x0476, %r28
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0xaa0c23e7  ! 1: AND_I	and 	%r16, 0x03e7, %r21
	.word 0x92140002  ! 1: OR_R	or 	%r16, %r2, %r9
        mov 0x93, %r31
thr3_loop_cnt_1086:
	.word 0xe6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r19
	.word 0xf0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r24
	.word 0xfa84217c  ! 1: LDUWA_I	lduwa	[%r16, + 0x017c] %asi, %r29
	.word 0xc6142d92  ! 1: LDUH_I	lduh	[%r16 + 0x0d92], %r3
	.word 0xfa842478  ! 1: LDUWA_I	lduwa	[%r16, + 0x0478] %asi, %r29
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6042b28  ! 1: LDUW_I	lduw	[%r16 + 0x0b28], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1086
	dec %r31
	.word 0x86242d6b  ! 1: SUB_I	sub 	%r16, 0x0d6b, %r3
	.word 0xaf2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r23
	.word 0x90440002  ! 1: ADDC_R	addc 	%r16, %r2, %r8
        mov 0xb2, %r31
thr3_loop_cnt_1087:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd2842090  ! 1: LDUWA_I	lduwa	[%r16, + 0x0090] %asi, %r9
	.word 0xc614245e  ! 1: LDUH_I	lduh	[%r16 + 0x045e], %r3
	.word 0xf0042c9c  ! 1: LDUW_I	lduw	[%r16 + 0x0c9c], %r24
	.word 0xc6dc2d50  ! 1: LDXA_I	ldxa	[%r16, + 0x0d50] %asi, %r3
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xccdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r6
	.word 0xc6142efc  ! 1: LDUH_I	lduh	[%r16 + 0x0efc], %r3
	brnz %r31,thr3_loop_cnt_1087
	dec %r31
        mov 0x88, %r31
thr3_loop_cnt_1088:
	.word 0xd08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r8
	.word 0xc68c28f7  ! 1: LDUBA_I	lduba	[%r16, + 0x08f7] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xfa4c2f40  ! 1: LDSB_I	ldsb	[%r16 + 0x0f40], %r29
	.word 0xd8c42648  ! 1: LDSWA_I	ldswa	[%r16, + 0x0648] %asi, %r12
	.word 0xd0942048  ! 1: LDUHA_I	lduha	[%r16, + 0x0048] %asi, %r8
	.word 0xf8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r28
	.word 0xdadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r13
	.word 0xd6dc2ac8  ! 1: LDXA_I	ldxa	[%r16, + 0x0ac8] %asi, %r11
	.word 0xd8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r12
	.word 0xdc842b5c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b5c] %asi, %r14
	brnz %r31,thr3_loop_cnt_1088
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0xb82c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r28
	.word 0x8e0426ad  ! 1: ADD_I	add 	%r16, 0x06ad, %r7
        mov 0xc2, %r31
thr3_loop_cnt_1089:
	.word 0xc6cc2d6c  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d6c] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xee140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r23
	.word 0xe45c2078  ! 1: LDX_I	ldx	[%r16 + 0x0078], %r18
	.word 0xc6842630  ! 1: LDUWA_I	lduwa	[%r16, + 0x0630] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd6c42c8c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c8c] %asi, %r11
	brnz %r31,thr3_loop_cnt_1089
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x9a, %r31
thr3_loop_cnt_1090:
	.word 0xce4c2dd2  ! 1: LDSB_I	ldsb	[%r16 + 0x0dd2], %r7
	.word 0xc6842604  ! 1: LDUWA_I	lduwa	[%r16, + 0x0604] %asi, %r3
	.word 0xc6042090  ! 1: LDUW_I	lduw	[%r16 + 0x0090], %r3
	.word 0xc60c2225  ! 1: LDUB_I	ldub	[%r16 + 0x0225], %r3
	.word 0xc60421c0  ! 1: LDUW_I	lduw	[%r16 + 0x01c0], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2a08  ! 1: LDXA_I	ldxa	[%r16, + 0x0a08] %asi, %r3
	.word 0xf4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r26
	.word 0xc6d42df6  ! 1: LDSHA_I	ldsha	[%r16, + 0x0df6] %asi, %r3
	.word 0xc65c2a20  ! 1: LDX_I	ldx	[%r16 + 0x0a20], %r3
	.word 0xc6942d76  ! 1: LDUHA_I	lduha	[%r16, + 0x0d76] %asi, %r3
	brnz %r31,thr3_loop_cnt_1090
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0xa92c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r20
	.word 0xaa3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r21
        mov 0xa1, %r31
thr3_loop_cnt_1091:
	.word 0xf0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r24
	.word 0xf4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r26
	.word 0xc65c2d40  ! 1: LDX_I	ldx	[%r16 + 0x0d40], %r3
	.word 0xf2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r25
	.word 0xdc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r14
	.word 0xc6142dec  ! 1: LDUH_I	lduh	[%r16 + 0x0dec], %r3
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	.word 0xc68c2348  ! 1: LDUBA_I	lduba	[%r16, + 0x0348] %asi, %r3
	.word 0xf28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r25
	brnz %r31,thr3_loop_cnt_1091
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x862c208a  ! 1: ANDN_I	andn 	%r16, 0x008a, %r3
        mov 0x7b, %r31
thr3_loop_cnt_1092:
	.word 0xe4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r18
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6842204  ! 1: LDUWA_I	lduwa	[%r16, + 0x0204] %asi, %r3
	.word 0xf8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r28
	.word 0xc68c2797  ! 1: LDUBA_I	lduba	[%r16, + 0x0797] %asi, %r3
	.word 0xf08c20a7  ! 1: LDUBA_I	lduba	[%r16, + 0x00a7] %asi, %r24
	.word 0xc6942384  ! 1: LDUHA_I	lduha	[%r16, + 0x0384] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1092
	dec %r31
	.word 0x973c0002  ! 1: SRA_R	sra 	%r16, %r2, %r11
	.word 0x9a2c259f  ! 1: ANDN_I	andn 	%r16, 0x059f, %r13
	.word 0xad2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r22
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x65, %r31
thr3_loop_cnt_1093:
	.word 0xc68c2230  ! 1: LDUBA_I	lduba	[%r16, + 0x0230] %asi, %r3
	.word 0xc68428b4  ! 1: LDUWA_I	lduwa	[%r16, + 0x08b4] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd6042160  ! 1: LDUW_I	lduw	[%r16 + 0x0160], %r11
	.word 0xfc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r30
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r19
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	brnz %r31,thr3_loop_cnt_1093
	dec %r31
	.word 0xac2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r22
	.word 0x980c0002  ! 1: AND_R	and 	%r16, %r2, %r12
        mov 0x7b, %r31
thr3_loop_cnt_1094:
	.word 0xc6dc28e0  ! 1: LDXA_I	ldxa	[%r16, + 0x08e0] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	.word 0xc60c2dfd  ! 1: LDUB_I	ldub	[%r16 + 0x0dfd], %r3
	.word 0xfa94243c  ! 1: LDUHA_I	lduha	[%r16, + 0x043c] %asi, %r29
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r27
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xd8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r12
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf2142154  ! 1: LDUH_I	lduh	[%r16 + 0x0154], %r25
	brnz %r31,thr3_loop_cnt_1094
	dec %r31
	.word 0x8c24282e  ! 1: SUB_I	sub 	%r16, 0x082e, %r6
	.word 0x8644221d  ! 1: ADDC_I	addc 	%r16, 0x021d, %r3
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0xb8, %r31
thr3_loop_cnt_1095:
	.word 0xfc4c20d9  ! 1: LDSB_I	ldsb	[%r16 + 0x00d9], %r30
	.word 0xde440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r15
	.word 0xdcd42924  ! 1: LDSHA_I	ldsha	[%r16, + 0x0924] %asi, %r14
	.word 0xc6042124  ! 1: LDUW_I	lduw	[%r16 + 0x0124], %r3
	.word 0xd45424a8  ! 1: LDSH_I	ldsh	[%r16 + 0x04a8], %r10
	.word 0xcc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r6
	.word 0xc6c4205c  ! 1: LDSWA_I	ldswa	[%r16, + 0x005c] %asi, %r3
	.word 0xc6942dd8  ! 1: LDUHA_I	lduha	[%r16, + 0x0dd8] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xc64c261f  ! 1: LDSB_I	ldsb	[%r16 + 0x061f], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1095
	dec %r31
	.word 0x862c2de2  ! 1: ANDN_I	andn 	%r16, 0x0de2, %r3
	.word 0x9c040002  ! 1: ADD_R	add 	%r16, %r2, %r14
	.word 0x9e3425f0  ! 1: ORN_I	orn 	%r16, 0x05f0, %r15
	.word 0x862c2731  ! 1: ANDN_I	andn 	%r16, 0x0731, %r3
        mov 0xa6, %r31
thr3_loop_cnt_1096:
	.word 0xe2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r17
	.word 0xe84c2505  ! 1: LDSB_I	ldsb	[%r16 + 0x0505], %r20
	.word 0xc6942d7e  ! 1: LDUHA_I	lduha	[%r16, + 0x0d7e] %asi, %r3
	.word 0xd2c42038  ! 1: LDSWA_I	ldswa	[%r16, + 0x0038] %asi, %r9
	.word 0xf85c26f8  ! 1: LDX_I	ldx	[%r16 + 0x06f8], %r28
	.word 0xe2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r17
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc68c24fb  ! 1: LDUBA_I	lduba	[%r16, + 0x04fb] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xe2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r17
	brnz %r31,thr3_loop_cnt_1096
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x96240002  ! 1: SUB_R	sub 	%r16, %r2, %r11
	.word 0x963c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r11
        mov 0x26, %r31
thr3_loop_cnt_1097:
	.word 0xded42fec  ! 1: LDSHA_I	ldsha	[%r16, + 0x0fec] %asi, %r15
	.word 0xfadc24c0  ! 1: LDXA_I	ldxa	[%r16, + 0x04c0] %asi, %r29
	.word 0xc65c21f8  ! 1: LDX_I	ldx	[%r16 + 0x01f8], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xfc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r30
	.word 0xc6cc21d5  ! 1: LDSBA_I	ldsba	[%r16, + 0x01d5] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe44c2c23  ! 1: LDSB_I	ldsb	[%r16 + 0x0c23], %r18
	brnz %r31,thr3_loop_cnt_1097
	dec %r31
        mov 0x15, %r31
thr3_loop_cnt_1098:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6942886  ! 1: LDUHA_I	lduha	[%r16, + 0x0886] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6442750  ! 1: LDSW_I	ldsw	[%r16 + 0x0750], %r3
	.word 0xc65423f8  ! 1: LDSH_I	ldsh	[%r16 + 0x03f8], %r3
	.word 0xf68c2df9  ! 1: LDUBA_I	lduba	[%r16, + 0x0df9] %asi, %r27
	.word 0xd0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r8
	.word 0xe2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r17
	.word 0xc69425aa  ! 1: LDUHA_I	lduha	[%r16, + 0x05aa] %asi, %r3
	brnz %r31,thr3_loop_cnt_1098
	dec %r31
	.word 0x96242de9  ! 1: SUB_I	sub 	%r16, 0x0de9, %r11
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0xe, %r31
thr3_loop_cnt_1099:
	.word 0xea4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r21
	.word 0xc68c2c5f  ! 1: LDUBA_I	lduba	[%r16, + 0x0c5f] %asi, %r3
	.word 0xe6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r19
	.word 0xec542506  ! 1: LDSH_I	ldsh	[%r16 + 0x0506], %r22
	.word 0xc6842d98  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d98] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xec5c27b8  ! 1: LDX_I	ldx	[%r16 + 0x07b8], %r22
	.word 0xc60c21b6  ! 1: LDUB_I	ldub	[%r16 + 0x01b6], %r3
	.word 0xe44c2f76  ! 1: LDSB_I	ldsb	[%r16 + 0x0f76], %r18
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1099
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0xa6, %r31
thr3_loop_cnt_1100:
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xe4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r18
	.word 0xc6d42934  ! 1: LDSHA_I	ldsha	[%r16, + 0x0934] %asi, %r3
	.word 0xc65c2590  ! 1: LDX_I	ldx	[%r16 + 0x0590], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd28c2540  ! 1: LDUBA_I	lduba	[%r16, + 0x0540] %asi, %r9
	.word 0xf4dc23b8  ! 1: LDXA_I	ldxa	[%r16, + 0x03b8] %asi, %r26
	.word 0xc6cc2b09  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b09] %asi, %r3
	.word 0xf25c2338  ! 1: LDX_I	ldx	[%r16 + 0x0338], %r25
	.word 0xc65c2250  ! 1: LDX_I	ldx	[%r16 + 0x0250], %r3
	brnz %r31,thr3_loop_cnt_1100
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0xa5, %r31
thr3_loop_cnt_1101:
	.word 0xda5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r13
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc64c221e  ! 1: LDSB_I	ldsb	[%r16 + 0x021e], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xfc842678  ! 1: LDUWA_I	lduwa	[%r16, + 0x0678] %asi, %r30
	.word 0xd2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r9
	.word 0xe4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r18
	.word 0xda5424ee  ! 1: LDSH_I	ldsh	[%r16 + 0x04ee], %r13
	.word 0xc65422ce  ! 1: LDSH_I	ldsh	[%r16 + 0x02ce], %r3
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xda440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r13
	brnz %r31,thr3_loop_cnt_1101
	dec %r31
	.word 0x9d341002  ! 1: SRLX_R	srlx	%r16, %r2, %r14
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0xb81c0002  ! 1: XOR_R	xor 	%r16, %r2, %r28
        mov 0xb2, %r31
thr3_loop_cnt_1102:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r10
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r8
	.word 0xd00c21a1  ! 1: LDUB_I	ldub	[%r16 + 0x01a1], %r8
	.word 0xe20c25d2  ! 1: LDUB_I	ldub	[%r16 + 0x05d2], %r17
	.word 0xc684233c  ! 1: LDUWA_I	lduwa	[%r16, + 0x033c] %asi, %r3
	brnz %r31,thr3_loop_cnt_1102
	dec %r31
	.word 0x861c2a92  ! 1: XOR_I	xor 	%r16, 0x0a92, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x26, %r31
thr3_loop_cnt_1103:
	.word 0xdc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r14
	.word 0xcc8c2954  ! 1: LDUBA_I	lduba	[%r16, + 0x0954] %asi, %r6
	.word 0xc65c2950  ! 1: LDX_I	ldx	[%r16 + 0x0950], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc61424d2  ! 1: LDUH_I	lduh	[%r16 + 0x04d2], %r3
	.word 0xec942038  ! 1: LDUHA_I	lduha	[%r16, + 0x0038] %asi, %r22
	.word 0xc6d42b80  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b80] %asi, %r3
	.word 0xd05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r8
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xcccc22c3  ! 1: LDSBA_I	ldsba	[%r16, + 0x02c3] %asi, %r6
	brnz %r31,thr3_loop_cnt_1103
	dec %r31
	.word 0x8f2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r7
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0x35, %r31
thr3_loop_cnt_1104:
	.word 0xea440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r21
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf00c2d64  ! 1: LDUB_I	ldub	[%r16 + 0x0d64], %r24
	.word 0xe80c2258  ! 1: LDUB_I	ldub	[%r16 + 0x0258], %r20
	.word 0xf2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r25
	.word 0xfacc2eb0  ! 1: LDSBA_I	ldsba	[%r16, + 0x0eb0] %asi, %r29
	.word 0xc6542888  ! 1: LDSH_I	ldsh	[%r16 + 0x0888], %r3
	.word 0xf40c29c5  ! 1: LDUB_I	ldub	[%r16 + 0x09c5], %r26
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1104
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x9d2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r14
        mov 0xb1, %r31
thr3_loop_cnt_1105:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd8442ef4  ! 1: LDSW_I	ldsw	[%r16 + 0x0ef4], %r12
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xc6942be0  ! 1: LDUHA_I	lduha	[%r16, + 0x0be0] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xded4271a  ! 1: LDSHA_I	ldsha	[%r16, + 0x071a] %asi, %r15
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1105
	dec %r31
	.word 0x95340002  ! 1: SRL_R	srl 	%r16, %r2, %r10
        mov 0x38, %r31
thr3_loop_cnt_1106:
	.word 0xc64c2445  ! 1: LDSB_I	ldsb	[%r16 + 0x0445], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6942fba  ! 1: LDUHA_I	lduha	[%r16, + 0x0fba] %asi, %r3
	.word 0xe6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r19
	.word 0xd80c2e64  ! 1: LDUB_I	ldub	[%r16 + 0x0e64], %r12
	.word 0xea540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r21
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xdac42abc  ! 1: LDSWA_I	ldswa	[%r16, + 0x0abc] %asi, %r13
	.word 0xc65c28f8  ! 1: LDX_I	ldx	[%r16 + 0x08f8], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1106
	dec %r31
	.word 0x97341002  ! 1: SRLX_R	srlx	%r16, %r2, %r11
	.word 0xb72c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r27
	.word 0x9c3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r14
        mov 0x31, %r31
thr3_loop_cnt_1107:
	.word 0xfc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r30
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	.word 0xdec4273c  ! 1: LDSWA_I	ldswa	[%r16, + 0x073c] %asi, %r15
	.word 0xee142ef4  ! 1: LDUH_I	lduh	[%r16 + 0x0ef4], %r23
	.word 0xc6d42322  ! 1: LDSHA_I	ldsha	[%r16, + 0x0322] %asi, %r3
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xc61422de  ! 1: LDUH_I	lduh	[%r16 + 0x02de], %r3
	.word 0xf04c2fe9  ! 1: LDSB_I	ldsb	[%r16 + 0x0fe9], %r24
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1107
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x9a042c8f  ! 1: ADD_I	add 	%r16, 0x0c8f, %r13
        mov 0x3a, %r31
thr3_loop_cnt_1108:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf04c2851  ! 1: LDSB_I	ldsb	[%r16 + 0x0851], %r24
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6c42ad0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ad0] %asi, %r3
	.word 0xc6dc2320  ! 1: LDXA_I	ldxa	[%r16, + 0x0320] %asi, %r3
	.word 0xe20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r17
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6842a28  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a28] %asi, %r3
	.word 0xfc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r30
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1108
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0x87, %r31
thr3_loop_cnt_1109:
	.word 0xc6542d74  ! 1: LDSH_I	ldsh	[%r16 + 0x0d74], %r3
	.word 0xd45421f0  ! 1: LDSH_I	ldsh	[%r16 + 0x01f0], %r10
	.word 0xc65c2ac8  ! 1: LDX_I	ldx	[%r16 + 0x0ac8], %r3
	.word 0xd4942be4  ! 1: LDUHA_I	lduha	[%r16, + 0x0be4] %asi, %r10
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc64c2b47  ! 1: LDSB_I	ldsb	[%r16 + 0x0b47], %r3
	.word 0xd44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r10
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1109
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x8c340002  ! 1: ORN_R	orn 	%r16, %r2, %r6
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0x44, %r31
thr3_loop_cnt_1110:
	.word 0xe85425e2  ! 1: LDSH_I	ldsh	[%r16 + 0x05e2], %r20
	.word 0xf8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r28
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xde841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r15
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r18
	.word 0xc64c2bdc  ! 1: LDSB_I	ldsb	[%r16 + 0x0bdc], %r3
	.word 0xc6c42614  ! 1: LDSWA_I	ldswa	[%r16, + 0x0614] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1110
	dec %r31
	.word 0x9b343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r13
	.word 0x860c2db6  ! 1: AND_I	and 	%r16, 0x0db6, %r3
        mov 0x38, %r31
thr3_loop_cnt_1111:
	.word 0xfc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r30
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r25
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6c429ac  ! 1: LDSWA_I	ldswa	[%r16, + 0x09ac] %asi, %r3
	.word 0xc65427e6  ! 1: LDSH_I	ldsh	[%r16 + 0x07e6], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xec440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r22
	.word 0xc60c216a  ! 1: LDUB_I	ldub	[%r16 + 0x016a], %r3
	.word 0xd48c2bc2  ! 1: LDUBA_I	lduba	[%r16, + 0x0bc2] %asi, %r10
	brnz %r31,thr3_loop_cnt_1111
	dec %r31
        mov 0x58, %r31
thr3_loop_cnt_1112:
	.word 0xee042408  ! 1: LDUW_I	lduw	[%r16 + 0x0408], %r23
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6cc2db9  ! 1: LDSBA_I	ldsba	[%r16, + 0x0db9] %asi, %r3
	.word 0xc65424a0  ! 1: LDSH_I	ldsh	[%r16 + 0x04a0], %r3
	.word 0xc6442638  ! 1: LDSW_I	ldsw	[%r16 + 0x0638], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xe4842cac  ! 1: LDUWA_I	lduwa	[%r16, + 0x0cac] %asi, %r18
	.word 0xc64c292a  ! 1: LDSB_I	ldsb	[%r16 + 0x092a], %r3
	.word 0xcc8c2100  ! 1: LDUBA_I	lduba	[%r16, + 0x0100] %asi, %r6
	brnz %r31,thr3_loop_cnt_1112
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x973c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r11
        mov 0xbf, %r31
thr3_loop_cnt_1113:
	.word 0xc6542034  ! 1: LDSH_I	ldsh	[%r16 + 0x0034], %r3
	.word 0xd28c28dc  ! 1: LDUBA_I	lduba	[%r16, + 0x08dc] %asi, %r9
	.word 0xc614297a  ! 1: LDUH_I	lduh	[%r16 + 0x097a], %r3
	.word 0xc68427a0  ! 1: LDUWA_I	lduwa	[%r16, + 0x07a0] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xec44259c  ! 1: LDSW_I	ldsw	[%r16 + 0x059c], %r22
	.word 0xd8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r12
	.word 0xce8c2a99  ! 1: LDUBA_I	lduba	[%r16, + 0x0a99] %asi, %r7
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xda4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r13
	brnz %r31,thr3_loop_cnt_1113
	dec %r31
	.word 0x90340002  ! 1: SUBC_R	orn 	%r16, %r2, %r8
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x863c23c0  ! 1: XNOR_I	xnor 	%r16, 0x03c0, %r3
        mov 0x8e, %r31
thr3_loop_cnt_1114:
	.word 0xf84c2e09  ! 1: LDSB_I	ldsb	[%r16 + 0x0e09], %r28
	.word 0xf2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r25
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xc6142c82  ! 1: LDUH_I	lduh	[%r16 + 0x0c82], %r3
	.word 0xc6442dec  ! 1: LDSW_I	ldsw	[%r16 + 0x0dec], %r3
	.word 0xf0842b2c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b2c] %asi, %r24
	.word 0xec440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r22
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1114
	dec %r31
	.word 0x9d2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r14
        mov 0x10, %r31
thr3_loop_cnt_1115:
	.word 0xc694266a  ! 1: LDUHA_I	lduha	[%r16, + 0x066a] %asi, %r3
	.word 0xeecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r23
	.word 0xc6442974  ! 1: LDSW_I	ldsw	[%r16 + 0x0974], %r3
	.word 0xc6d42f9a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f9a] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf60421c8  ! 1: LDUW_I	lduw	[%r16 + 0x01c8], %r27
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xc6142df8  ! 1: LDUH_I	lduh	[%r16 + 0x0df8], %r3
	.word 0xc6842cc4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0cc4] %asi, %r3
	.word 0xdc042810  ! 1: LDUW_I	lduw	[%r16 + 0x0810], %r14
	brnz %r31,thr3_loop_cnt_1115
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x863420fe  ! 1: ORN_I	orn 	%r16, 0x00fe, %r3
        mov 0x6, %r31
thr3_loop_cnt_1116:
	.word 0xcc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r6
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc69426fa  ! 1: LDUHA_I	lduha	[%r16, + 0x06fa] %asi, %r3
	.word 0xe24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r17
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6042b7c  ! 1: LDUW_I	lduw	[%r16 + 0x0b7c], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc65c2c58  ! 1: LDX_I	ldx	[%r16 + 0x0c58], %r3
	.word 0xf8142e3e  ! 1: LDUH_I	lduh	[%r16 + 0x0e3e], %r28
	brnz %r31,thr3_loop_cnt_1116
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0x2f, %r31
thr3_loop_cnt_1117:
	.word 0xf2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r25
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xcc942bd0  ! 1: LDUHA_I	lduha	[%r16, + 0x0bd0] %asi, %r6
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc65c20a8  ! 1: LDX_I	ldx	[%r16 + 0x00a8], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6442968  ! 1: LDSW_I	ldsw	[%r16 + 0x0968], %r3
	.word 0xd4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r10
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1117
	dec %r31
        mov 0x30, %r31
thr3_loop_cnt_1118:
	.word 0xd85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r12
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xfa8c25ba  ! 1: LDUBA_I	lduba	[%r16, + 0x05ba] %asi, %r29
	.word 0xc65c27b0  ! 1: LDX_I	ldx	[%r16 + 0x07b0], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6842d1c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d1c] %asi, %r3
	.word 0xd60c22d1  ! 1: LDUB_I	ldub	[%r16 + 0x02d1], %r11
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc60c2e37  ! 1: LDUB_I	ldub	[%r16 + 0x0e37], %r3
	.word 0xc6dc2f28  ! 1: LDXA_I	ldxa	[%r16, + 0x0f28] %asi, %r3
	brnz %r31,thr3_loop_cnt_1118
	dec %r31
	.word 0xb2040002  ! 1: ADD_R	add 	%r16, %r2, %r25
	.word 0x862c2f13  ! 1: ANDN_I	andn 	%r16, 0x0f13, %r3
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x89, %r31
thr3_loop_cnt_1119:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2815  ! 1: LDSBA_I	ldsba	[%r16, + 0x0815] %asi, %r3
	.word 0xd444206c  ! 1: LDSW_I	ldsw	[%r16 + 0x006c], %r10
	.word 0xc684238c  ! 1: LDUWA_I	lduwa	[%r16, + 0x038c] %asi, %r3
	.word 0xfc5c2308  ! 1: LDX_I	ldx	[%r16 + 0x0308], %r30
	.word 0xd68c2a7d  ! 1: LDUBA_I	lduba	[%r16, + 0x0a7d] %asi, %r11
	.word 0xd4d427ac  ! 1: LDSHA_I	ldsha	[%r16, + 0x07ac] %asi, %r10
	.word 0xc69426e2  ! 1: LDUHA_I	lduha	[%r16, + 0x06e2] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1119
	dec %r31
	.word 0xb32c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r25
	.word 0x9c24251f  ! 1: SUB_I	sub 	%r16, 0x051f, %r14
	.word 0x8c040002  ! 1: ADD_R	add 	%r16, %r2, %r6
        mov 0x74, %r31
thr3_loop_cnt_1120:
	.word 0xc6142274  ! 1: LDUH_I	lduh	[%r16 + 0x0274], %r3
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xec4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r22
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd0442c04  ! 1: LDSW_I	ldsw	[%r16 + 0x0c04], %r8
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xc6542f44  ! 1: LDSH_I	ldsh	[%r16 + 0x0f44], %r3
	.word 0xc68c256b  ! 1: LDUBA_I	lduba	[%r16, + 0x056b] %asi, %r3
	brnz %r31,thr3_loop_cnt_1120
	dec %r31
	.word 0x92140002  ! 1: OR_R	or 	%r16, %r2, %r9
	.word 0x9e342769  ! 1: SUBC_I	orn 	%r16, 0x0769, %r15
        mov 0x38, %r31
thr3_loop_cnt_1121:
	.word 0xc6442e64  ! 1: LDSW_I	ldsw	[%r16 + 0x0e64], %r3
	.word 0xc6cc2c1c  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c1c] %asi, %r3
	.word 0xf04c2da8  ! 1: LDSB_I	ldsb	[%r16 + 0x0da8], %r24
	.word 0xccc42358  ! 1: LDSWA_I	ldswa	[%r16, + 0x0358] %asi, %r6
	.word 0xfcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r30
	.word 0xd6cc2c3f  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c3f] %asi, %r11
	.word 0xd8142ae8  ! 1: LDUH_I	lduh	[%r16 + 0x0ae8], %r12
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1121
	dec %r31
	.word 0x941c0002  ! 1: XOR_R	xor 	%r16, %r2, %r10
	.word 0x86142d2c  ! 1: OR_I	or 	%r16, 0x0d2c, %r3
        mov 0x21, %r31
thr3_loop_cnt_1122:
	.word 0xd6dc2e00  ! 1: LDXA_I	ldxa	[%r16, + 0x0e00] %asi, %r11
	.word 0xced41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r7
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc694234c  ! 1: LDUHA_I	lduha	[%r16, + 0x034c] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xc69429f6  ! 1: LDUHA_I	lduha	[%r16, + 0x09f6] %asi, %r3
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xfa0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r29
	brnz %r31,thr3_loop_cnt_1122
	dec %r31
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x33, %r31
thr3_loop_cnt_1123:
	.word 0xe8dc2970  ! 1: LDXA_I	ldxa	[%r16, + 0x0970] %asi, %r20
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc64c21b6  ! 1: LDSB_I	ldsb	[%r16 + 0x01b6], %r3
	.word 0xd44c25bb  ! 1: LDSB_I	ldsb	[%r16 + 0x05bb], %r10
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6042f88  ! 1: LDUW_I	lduw	[%r16 + 0x0f88], %r3
	.word 0xc6dc2888  ! 1: LDXA_I	ldxa	[%r16, + 0x0888] %asi, %r3
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xc60c2753  ! 1: LDUB_I	ldub	[%r16 + 0x0753], %r3
	brnz %r31,thr3_loop_cnt_1123
	dec %r31
        mov 0x1e, %r31
thr3_loop_cnt_1124:
	.word 0xc6cc2336  ! 1: LDSBA_I	ldsba	[%r16, + 0x0336] %asi, %r3
	.word 0xc6dc2f70  ! 1: LDXA_I	ldxa	[%r16, + 0x0f70] %asi, %r3
	.word 0xf4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r26
	.word 0xc6442d64  ! 1: LDSW_I	ldsw	[%r16 + 0x0d64], %r3
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xce14259e  ! 1: LDUH_I	lduh	[%r16 + 0x059e], %r7
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6442f44  ! 1: LDSW_I	ldsw	[%r16 + 0x0f44], %r3
	brnz %r31,thr3_loop_cnt_1124
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0xbd2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r30
        mov 0x85, %r31
thr3_loop_cnt_1125:
	.word 0xc65c2700  ! 1: LDX_I	ldx	[%r16 + 0x0700], %r3
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xc65c21a0  ! 1: LDX_I	ldx	[%r16 + 0x01a0], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r27
	.word 0xfa040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r29
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xda140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r13
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc65c2998  ! 1: LDX_I	ldx	[%r16 + 0x0998], %r3
	brnz %r31,thr3_loop_cnt_1125
	dec %r31
	.word 0x912c0002  ! 1: SLL_R	sll 	%r16, %r2, %r8
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0xb2440002  ! 1: ADDC_R	addc 	%r16, %r2, %r25
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x3a, %r31
thr3_loop_cnt_1126:
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	.word 0xe45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r18
	.word 0xfa0c2fc5  ! 1: LDUB_I	ldub	[%r16 + 0x0fc5], %r29
	.word 0xf80420d8  ! 1: LDUW_I	lduw	[%r16 + 0x00d8], %r28
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1126
	dec %r31
	.word 0xb2142bd0  ! 1: OR_I	or 	%r16, 0x0bd0, %r25
        mov 0x20, %r31
thr3_loop_cnt_1127:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf4d425bc  ! 1: LDSHA_I	ldsha	[%r16, + 0x05bc] %asi, %r26
	.word 0xe2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r17
	.word 0xc64420cc  ! 1: LDSW_I	ldsw	[%r16 + 0x00cc], %r3
	.word 0xec042f7c  ! 1: LDUW_I	lduw	[%r16 + 0x0f7c], %r22
	brnz %r31,thr3_loop_cnt_1127
	dec %r31
	.word 0xaf2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r23
        mov 0x83, %r31
thr3_loop_cnt_1128:
	.word 0xea042af8  ! 1: LDUW_I	lduw	[%r16 + 0x0af8], %r21
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6442dec  ! 1: LDSW_I	ldsw	[%r16 + 0x0dec], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6dc2308  ! 1: LDXA_I	ldxa	[%r16, + 0x0308] %asi, %r3
	.word 0xda9425e8  ! 1: LDUHA_I	lduha	[%r16, + 0x05e8] %asi, %r13
	.word 0xf6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r27
	.word 0xf64c2b93  ! 1: LDSB_I	ldsb	[%r16 + 0x0b93], %r27
	.word 0xea8c22d7  ! 1: LDUBA_I	lduba	[%r16, + 0x02d7] %asi, %r21
	.word 0xc6cc27e0  ! 1: LDSBA_I	ldsba	[%r16, + 0x07e0] %asi, %r3
	brnz %r31,thr3_loop_cnt_1128
	dec %r31
        mov 0xb3, %r31
thr3_loop_cnt_1129:
	.word 0xe4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r18
	.word 0xe6dc24e0  ! 1: LDXA_I	ldxa	[%r16, + 0x04e0] %asi, %r19
	.word 0xf0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r24
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6942042  ! 1: LDUHA_I	lduha	[%r16, + 0x0042] %asi, %r3
	.word 0xf2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r25
	.word 0xfcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r30
	.word 0xc68c22b2  ! 1: LDUBA_I	lduba	[%r16, + 0x02b2] %asi, %r3
	.word 0xce941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r7
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r25
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1129
	dec %r31
	.word 0xb4240002  ! 1: SUB_R	sub 	%r16, %r2, %r26
	.word 0xb3342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r25
        mov 0x70, %r31
thr3_loop_cnt_1130:
	.word 0xc64c2cc2  ! 1: LDSB_I	ldsb	[%r16 + 0x0cc2], %r3
	.word 0xdc0c20e5  ! 1: LDUB_I	ldub	[%r16 + 0x00e5], %r14
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xd0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r8
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1130
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x9b3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r13
	.word 0x863c2072  ! 1: XNOR_I	xnor 	%r16, 0x0072, %r3
	.word 0x861c2a98  ! 1: XOR_I	xor 	%r16, 0x0a98, %r3
        mov 0xb7, %r31
thr3_loop_cnt_1131:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r25
	.word 0xc64427d4  ! 1: LDSW_I	ldsw	[%r16 + 0x07d4], %r3
	.word 0xf6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r27
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r18
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1131
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x17, %r31
thr3_loop_cnt_1132:
	.word 0xf814210c  ! 1: LDUH_I	lduh	[%r16 + 0x010c], %r28
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r20
	.word 0xe24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r17
	.word 0xd4c42c20  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c20] %asi, %r10
	.word 0xf4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r26
	.word 0xc6cc2975  ! 1: LDSBA_I	ldsba	[%r16, + 0x0975] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xdc4425fc  ! 1: LDSW_I	ldsw	[%r16 + 0x05fc], %r14
	.word 0xc6942490  ! 1: LDUHA_I	lduha	[%r16, + 0x0490] %asi, %r3
	brnz %r31,thr3_loop_cnt_1132
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x9b3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r13
	.word 0x9a1c0002  ! 1: XOR_R	xor 	%r16, %r2, %r13
	.word 0x86342026  ! 1: SUBC_I	orn 	%r16, 0x0026, %r3
        mov 0x25, %r31
thr3_loop_cnt_1133:
	.word 0xde140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r15
	.word 0xdec4271c  ! 1: LDSWA_I	ldswa	[%r16, + 0x071c] %asi, %r15
	.word 0xee8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r23
	.word 0xeed42ea0  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ea0] %asi, %r23
	.word 0xe40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r18
	.word 0xe8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r20
	.word 0xd44c2137  ! 1: LDSB_I	ldsb	[%r16 + 0x0137], %r10
	.word 0xe8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r20
	brnz %r31,thr3_loop_cnt_1133
	dec %r31
	.word 0x9f2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r15
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0x38, %r31
thr3_loop_cnt_1134:
	.word 0xf8cc2d31  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d31] %asi, %r28
	.word 0xf454250a  ! 1: LDSH_I	ldsh	[%r16 + 0x050a], %r26
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xcc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r6
	.word 0xc614292c  ! 1: LDUH_I	lduh	[%r16 + 0x092c], %r3
	.word 0xfc8c2722  ! 1: LDUBA_I	lduba	[%r16, + 0x0722] %asi, %r30
	.word 0xde8c28ce  ! 1: LDUBA_I	lduba	[%r16, + 0x08ce] %asi, %r15
	.word 0xd4942eb4  ! 1: LDUHA_I	lduha	[%r16, + 0x0eb4] %asi, %r10
	.word 0xf2942dc4  ! 1: LDUHA_I	lduha	[%r16, + 0x0dc4] %asi, %r25
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1134
	dec %r31
	.word 0xa6242074  ! 1: SUB_I	sub 	%r16, 0x0074, %r19
	.word 0xba340002  ! 1: SUBC_R	orn 	%r16, %r2, %r29
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x1e, %r31
thr3_loop_cnt_1135:
	.word 0xded42c80  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c80] %asi, %r15
	.word 0xd0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r8
	.word 0xc6d42b1a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b1a] %asi, %r3
	.word 0xea4c203f  ! 1: LDSB_I	ldsb	[%r16 + 0x003f], %r21
	.word 0xe8942698  ! 1: LDUHA_I	lduha	[%r16, + 0x0698] %asi, %r20
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc64c2b79  ! 1: LDSB_I	ldsb	[%r16 + 0x0b79], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1135
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x9b, %r31
thr3_loop_cnt_1136:
	.word 0xc6d42ff2  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ff2] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc60c2cd9  ! 1: LDUB_I	ldub	[%r16 + 0x0cd9], %r3
	.word 0xc69429e4  ! 1: LDUHA_I	lduha	[%r16, + 0x09e4] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6c42920  ! 1: LDSWA_I	ldswa	[%r16, + 0x0920] %asi, %r3
	.word 0xc69420c8  ! 1: LDUHA_I	lduha	[%r16, + 0x00c8] %asi, %r3
	.word 0xd6142d34  ! 1: LDUH_I	lduh	[%r16 + 0x0d34], %r11
	.word 0xd8042560  ! 1: LDUW_I	lduw	[%r16 + 0x0560], %r12
	.word 0xc6542a4a  ! 1: LDSH_I	ldsh	[%r16 + 0x0a4a], %r3
	.word 0xc6442d60  ! 1: LDSW_I	ldsw	[%r16 + 0x0d60], %r3
	brnz %r31,thr3_loop_cnt_1136
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0xbc, %r31
thr3_loop_cnt_1137:
	.word 0xf0cc2a1f  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a1f] %asi, %r24
	.word 0xe25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r17
	.word 0xc64424c8  ! 1: LDSW_I	ldsw	[%r16 + 0x04c8], %r3
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	.word 0xe6942b22  ! 1: LDUHA_I	lduha	[%r16, + 0x0b22] %asi, %r19
	.word 0xee842bbc  ! 1: LDUWA_I	lduwa	[%r16, + 0x0bbc] %asi, %r23
	.word 0xd0542592  ! 1: LDSH_I	ldsh	[%r16 + 0x0592], %r8
	.word 0xc6042580  ! 1: LDUW_I	lduw	[%r16 + 0x0580], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xdc1429dc  ! 1: LDUH_I	lduh	[%r16 + 0x09dc], %r14
	brnz %r31,thr3_loop_cnt_1137
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x86342bac  ! 1: SUBC_I	orn 	%r16, 0x0bac, %r3
	.word 0xab343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r21
        mov 0xb7, %r31
thr3_loop_cnt_1138:
	.word 0xc6442a60  ! 1: LDSW_I	ldsw	[%r16 + 0x0a60], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc68c2f39  ! 1: LDUBA_I	lduba	[%r16, + 0x0f39] %asi, %r3
	.word 0xce0c2adb  ! 1: LDUB_I	ldub	[%r16 + 0x0adb], %r7
	.word 0xe8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r20
	.word 0xc6542898  ! 1: LDSH_I	ldsh	[%r16 + 0x0898], %r3
	.word 0xc644265c  ! 1: LDSW_I	ldsw	[%r16 + 0x065c], %r3
	.word 0xec0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r22
	.word 0xc6042b18  ! 1: LDUW_I	lduw	[%r16 + 0x0b18], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1138
	dec %r31
	.word 0xba440002  ! 1: ADDC_R	addc 	%r16, %r2, %r29
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0xa3, %r31
thr3_loop_cnt_1139:
	.word 0xc6d42c38  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c38] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r25
	.word 0xec8423a8  ! 1: LDUWA_I	lduwa	[%r16, + 0x03a8] %asi, %r22
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xe45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r18
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc64c271a  ! 1: LDSB_I	ldsb	[%r16 + 0x071a], %r3
	.word 0xc6542aa2  ! 1: LDSH_I	ldsh	[%r16 + 0x0aa2], %r3
	.word 0xc69424f2  ! 1: LDUHA_I	lduha	[%r16, + 0x04f2] %asi, %r3
	brnz %r31,thr3_loop_cnt_1139
	dec %r31
	.word 0x8624227d  ! 1: SUB_I	sub 	%r16, 0x027d, %r3
	.word 0x86042db1  ! 1: ADD_I	add 	%r16, 0x0db1, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x9b342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r13
        mov 0x3f, %r31
thr3_loop_cnt_1140:
	.word 0xc68c21a6  ! 1: LDUBA_I	lduba	[%r16, + 0x01a6] %asi, %r3
	.word 0xfc942822  ! 1: LDUHA_I	lduha	[%r16, + 0x0822] %asi, %r30
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6842ca8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ca8] %asi, %r3
	.word 0xe2142d72  ! 1: LDUH_I	lduh	[%r16 + 0x0d72], %r17
	.word 0xee542098  ! 1: LDSH_I	ldsh	[%r16 + 0x0098], %r23
	.word 0xc65429b6  ! 1: LDSH_I	ldsh	[%r16 + 0x09b6], %r3
	.word 0xf88c2379  ! 1: LDUBA_I	lduba	[%r16, + 0x0379] %asi, %r28
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6942302  ! 1: LDUHA_I	lduha	[%r16, + 0x0302] %asi, %r3
	brnz %r31,thr3_loop_cnt_1140
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x900c216b  ! 1: AND_I	and 	%r16, 0x016b, %r8
	.word 0xbc0423ed  ! 1: ADD_I	add 	%r16, 0x03ed, %r30
	.word 0xba340002  ! 1: ORN_R	orn 	%r16, %r2, %r29
        mov 0x3a, %r31
thr3_loop_cnt_1141:
	.word 0xc64c2b96  ! 1: LDSB_I	ldsb	[%r16 + 0x0b96], %r3
	.word 0xf2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r25
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xee9428ce  ! 1: LDUHA_I	lduha	[%r16, + 0x08ce] %asi, %r23
	.word 0xc6842590  ! 1: LDUWA_I	lduwa	[%r16, + 0x0590] %asi, %r3
	.word 0xc644276c  ! 1: LDSW_I	ldsw	[%r16 + 0x076c], %r3
	.word 0xcc0c22ff  ! 1: LDUB_I	ldub	[%r16 + 0x02ff], %r6
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	brnz %r31,thr3_loop_cnt_1141
	dec %r31
	.word 0x9f340002  ! 1: SRL_R	srl 	%r16, %r2, %r15
        mov 0x61, %r31
thr3_loop_cnt_1142:
	.word 0xc614261e  ! 1: LDUH_I	lduh	[%r16 + 0x061e], %r3
	.word 0xda8c2dc4  ! 1: LDUBA_I	lduba	[%r16, + 0x0dc4] %asi, %r13
	.word 0xf4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r26
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xec8c265c  ! 1: LDUBA_I	lduba	[%r16, + 0x065c] %asi, %r22
	.word 0xc60425ac  ! 1: LDUW_I	lduw	[%r16 + 0x05ac], %r3
	.word 0xdc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r14
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xdad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r13
	.word 0xf8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r28
	brnz %r31,thr3_loop_cnt_1142
	dec %r31
        mov 0xb3, %r31
thr3_loop_cnt_1143:
	.word 0xea841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r21
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd8c422c0  ! 1: LDSWA_I	ldswa	[%r16, + 0x02c0] %asi, %r12
	.word 0xee8c2d7f  ! 1: LDUBA_I	lduba	[%r16, + 0x0d7f] %asi, %r23
	.word 0xe2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r17
	.word 0xe6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r19
	.word 0xf6142cb0  ! 1: LDUH_I	lduh	[%r16 + 0x0cb0], %r27
	.word 0xc65c2dc0  ! 1: LDX_I	ldx	[%r16 + 0x0dc0], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1143
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0xa33c1002  ! 1: SRAX_R	srax	%r16, %r2, %r17
        mov 0x64, %r31
thr3_loop_cnt_1144:
	.word 0xee942e48  ! 1: LDUHA_I	lduha	[%r16, + 0x0e48] %asi, %r23
	.word 0xc6842070  ! 1: LDUWA_I	lduwa	[%r16, + 0x0070] %asi, %r3
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xec040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r22
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r10
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe8d42026  ! 1: LDSHA_I	ldsha	[%r16, + 0x0026] %asi, %r20
	.word 0xea9420ce  ! 1: LDUHA_I	lduha	[%r16, + 0x00ce] %asi, %r21
	.word 0xc65c2308  ! 1: LDX_I	ldx	[%r16 + 0x0308], %r3
	brnz %r31,thr3_loop_cnt_1144
	dec %r31
	.word 0x864425a1  ! 1: ADDC_I	addc 	%r16, 0x05a1, %r3
        mov 0x22, %r31
thr3_loop_cnt_1145:
	.word 0xd0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r8
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r20
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf68c2f27  ! 1: LDUBA_I	lduba	[%r16, + 0x0f27] %asi, %r27
	.word 0xc6d4235c  ! 1: LDSHA_I	ldsha	[%r16, + 0x035c] %asi, %r3
	.word 0xc60428fc  ! 1: LDUW_I	lduw	[%r16 + 0x08fc], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc60c2c05  ! 1: LDUB_I	ldub	[%r16 + 0x0c05], %r3
	.word 0xd2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r9
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1145
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0xbe, %r31
thr3_loop_cnt_1146:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2fc3  ! 1: LDSBA_I	ldsba	[%r16, + 0x0fc3] %asi, %r3
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xdc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r14
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	.word 0xd44422d8  ! 1: LDSW_I	ldsw	[%r16 + 0x02d8], %r10
	.word 0xc65c2418  ! 1: LDX_I	ldx	[%r16 + 0x0418], %r3
	brnz %r31,thr3_loop_cnt_1146
	dec %r31
        mov 0xa1, %r31
thr3_loop_cnt_1147:
	.word 0xc60422dc  ! 1: LDUW_I	lduw	[%r16 + 0x02dc], %r3
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xeccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r22
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xee442454  ! 1: LDSW_I	ldsw	[%r16 + 0x0454], %r23
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf8cc2124  ! 1: LDSBA_I	ldsba	[%r16, + 0x0124] %asi, %r28
	brnz %r31,thr3_loop_cnt_1147
	dec %r31
	.word 0x8d342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r6
	.word 0xa2240002  ! 1: SUB_R	sub 	%r16, %r2, %r17
	.word 0x96440002  ! 1: ADDC_R	addc 	%r16, %r2, %r11
        mov 0x7e, %r31
thr3_loop_cnt_1148:
	.word 0xd0942ba0  ! 1: LDUHA_I	lduha	[%r16, + 0x0ba0] %asi, %r8
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc68c281e  ! 1: LDUBA_I	lduba	[%r16, + 0x081e] %asi, %r3
	.word 0xde942930  ! 1: LDUHA_I	lduha	[%r16, + 0x0930] %asi, %r15
	.word 0xf6042104  ! 1: LDUW_I	lduw	[%r16 + 0x0104], %r27
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xce8c2aef  ! 1: LDUBA_I	lduba	[%r16, + 0x0aef] %asi, %r7
	.word 0xd0dc2c60  ! 1: LDXA_I	ldxa	[%r16, + 0x0c60] %asi, %r8
	brnz %r31,thr3_loop_cnt_1148
	dec %r31
        mov 0x71, %r31
thr3_loop_cnt_1149:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc61424d4  ! 1: LDUH_I	lduh	[%r16 + 0x04d4], %r3
	.word 0xf84c2918  ! 1: LDSB_I	ldsb	[%r16 + 0x0918], %r28
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6d42f00  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f00] %asi, %r3
	.word 0xf8142e18  ! 1: LDUH_I	lduh	[%r16 + 0x0e18], %r28
	.word 0xc604245c  ! 1: LDUW_I	lduw	[%r16 + 0x045c], %r3
	.word 0xde1420c8  ! 1: LDUH_I	lduh	[%r16 + 0x00c8], %r15
	brnz %r31,thr3_loop_cnt_1149
	dec %r31
	.word 0x9e3c217c  ! 1: XNOR_I	xnor 	%r16, 0x017c, %r15
        mov 0x4d, %r31
thr3_loop_cnt_1150:
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	.word 0xc61428d6  ! 1: LDUH_I	lduh	[%r16 + 0x08d6], %r3
	.word 0xdec427bc  ! 1: LDSWA_I	ldswa	[%r16, + 0x07bc] %asi, %r15
	.word 0xda4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r13
	.word 0xda842920  ! 1: LDUWA_I	lduwa	[%r16, + 0x0920] %asi, %r13
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6142c34  ! 1: LDUH_I	lduh	[%r16 + 0x0c34], %r3
	.word 0xc6d4276e  ! 1: LDSHA_I	ldsha	[%r16, + 0x076e] %asi, %r3
	.word 0xd45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r10
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1150
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x863426b4  ! 1: ORN_I	orn 	%r16, 0x06b4, %r3
        mov 0x7, %r31
thr3_loop_cnt_1151:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r20
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xee4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r23
	.word 0xc68c2724  ! 1: LDUBA_I	lduba	[%r16, + 0x0724] %asi, %r3
	.word 0xda842ad8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ad8] %asi, %r13
	.word 0xc6142c34  ! 1: LDUH_I	lduh	[%r16 + 0x0c34], %r3
	brnz %r31,thr3_loop_cnt_1151
	dec %r31
        mov 0x77, %r31
thr3_loop_cnt_1152:
	.word 0xf6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r27
	.word 0xc6c427e4  ! 1: LDSWA_I	ldswa	[%r16, + 0x07e4] %asi, %r3
	.word 0xd2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r9
	.word 0xe8842a64  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a64] %asi, %r20
	.word 0xeccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r22
	.word 0xe49420e4  ! 1: LDUHA_I	lduha	[%r16, + 0x00e4] %asi, %r18
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r18
	.word 0xc65c2bd0  ! 1: LDX_I	ldx	[%r16 + 0x0bd0], %r3
	.word 0xe28c2dca  ! 1: LDUBA_I	lduba	[%r16, + 0x0dca] %asi, %r17
	.word 0xcc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r6
	.word 0xfa0c2661  ! 1: LDUB_I	ldub	[%r16 + 0x0661], %r29
	brnz %r31,thr3_loop_cnt_1152
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x8b, %r31
thr3_loop_cnt_1153:
	.word 0xfc5c2838  ! 1: LDX_I	ldx	[%r16 + 0x0838], %r30
	.word 0xea8c22ec  ! 1: LDUBA_I	lduba	[%r16, + 0x02ec] %asi, %r21
	.word 0xd4842dc8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0dc8] %asi, %r10
	.word 0xf6c4266c  ! 1: LDSWA_I	ldswa	[%r16, + 0x066c] %asi, %r27
	.word 0xec842154  ! 1: LDUWA_I	lduwa	[%r16, + 0x0154] %asi, %r22
	.word 0xc6842634  ! 1: LDUWA_I	lduwa	[%r16, + 0x0634] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xec040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r22
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1153
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x92340002  ! 1: ORN_R	orn 	%r16, %r2, %r9
        mov 0x3a, %r31
thr3_loop_cnt_1154:
	.word 0xf05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r24
	.word 0xc644287c  ! 1: LDSW_I	ldsw	[%r16 + 0x087c], %r3
	.word 0xfa4421d8  ! 1: LDSW_I	ldsw	[%r16 + 0x01d8], %r29
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	.word 0xf48c2d3b  ! 1: LDUBA_I	lduba	[%r16, + 0x0d3b] %asi, %r26
	.word 0xfc542f36  ! 1: LDSH_I	ldsh	[%r16 + 0x0f36], %r30
	.word 0xc6cc2e38  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e38] %asi, %r3
	brnz %r31,thr3_loop_cnt_1154
	dec %r31
	.word 0xba240002  ! 1: SUB_R	sub 	%r16, %r2, %r29
	.word 0x8d341002  ! 1: SRLX_R	srlx	%r16, %r2, %r6
        mov 0x48, %r31
thr3_loop_cnt_1155:
	.word 0xd8dc2ad8  ! 1: LDXA_I	ldxa	[%r16, + 0x0ad8] %asi, %r12
	.word 0xc68426a0  ! 1: LDUWA_I	lduwa	[%r16, + 0x06a0] %asi, %r3
	.word 0xcc8c25d4  ! 1: LDUBA_I	lduba	[%r16, + 0x05d4] %asi, %r6
	.word 0xd80c20c3  ! 1: LDUB_I	ldub	[%r16 + 0x00c3], %r12
	.word 0xc61429b6  ! 1: LDUH_I	lduh	[%r16 + 0x09b6], %r3
	.word 0xe2842020  ! 1: LDUWA_I	lduwa	[%r16, + 0x0020] %asi, %r17
	.word 0xf08c2298  ! 1: LDUBA_I	lduba	[%r16, + 0x0298] %asi, %r24
	.word 0xc6042f44  ! 1: LDUW_I	lduw	[%r16 + 0x0f44], %r3
	.word 0xf604292c  ! 1: LDUW_I	lduw	[%r16 + 0x092c], %r27
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1155
	dec %r31
	.word 0x96242a03  ! 1: SUB_I	sub 	%r16, 0x0a03, %r11
        mov 0x69, %r31
thr3_loop_cnt_1156:
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd8c42514  ! 1: LDSWA_I	ldswa	[%r16, + 0x0514] %asi, %r12
	.word 0xc6142f0e  ! 1: LDUH_I	lduh	[%r16 + 0x0f0e], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6142ea8  ! 1: LDUH_I	lduh	[%r16 + 0x0ea8], %r3
	.word 0xe2842538  ! 1: LDUWA_I	lduwa	[%r16, + 0x0538] %asi, %r17
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1156
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x90240002  ! 1: SUB_R	sub 	%r16, %r2, %r8
	.word 0x863c2f2e  ! 1: XNOR_I	xnor 	%r16, 0x0f2e, %r3
        mov 0x1a, %r31
thr3_loop_cnt_1157:
	.word 0xc6dc2fa0  ! 1: LDXA_I	ldxa	[%r16, + 0x0fa0] %asi, %r3
	.word 0xc68c2a34  ! 1: LDUBA_I	lduba	[%r16, + 0x0a34] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xce4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r7
	.word 0xc6442bdc  ! 1: LDSW_I	ldsw	[%r16 + 0x0bdc], %r3
	.word 0xde5c2a40  ! 1: LDX_I	ldx	[%r16 + 0x0a40], %r15
	.word 0xcc4c2c62  ! 1: LDSB_I	ldsb	[%r16 + 0x0c62], %r6
	.word 0xc6042b80  ! 1: LDUW_I	lduw	[%r16 + 0x0b80], %r3
	brnz %r31,thr3_loop_cnt_1157
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x97343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r11
	.word 0xa8440002  ! 1: ADDC_R	addc 	%r16, %r2, %r20
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0xaf, %r31
thr3_loop_cnt_1158:
	.word 0xc6942ab6  ! 1: LDUHA_I	lduha	[%r16, + 0x0ab6] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc64c24b3  ! 1: LDSB_I	ldsb	[%r16 + 0x04b3], %r3
	.word 0xeecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r23
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc60c2543  ! 1: LDUB_I	ldub	[%r16 + 0x0543], %r3
	brnz %r31,thr3_loop_cnt_1158
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x53, %r31
thr3_loop_cnt_1159:
	.word 0xd0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r8
	.word 0xc68c2d46  ! 1: LDUBA_I	lduba	[%r16, + 0x0d46] %asi, %r3
	.word 0xd0dc20d0  ! 1: LDXA_I	ldxa	[%r16, + 0x00d0] %asi, %r8
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r27
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf8dc2008  ! 1: LDXA_I	ldxa	[%r16, + 0x0008] %asi, %r28
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1159
	dec %r31
	.word 0xaa2c2253  ! 1: ANDN_I	andn 	%r16, 0x0253, %r21
        mov 0x88, %r31
thr3_loop_cnt_1160:
	.word 0xc6042bf4  ! 1: LDUW_I	lduw	[%r16 + 0x0bf4], %r3
	.word 0xcecc2003  ! 1: LDSBA_I	ldsba	[%r16, + 0x0003] %asi, %r7
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r19
	.word 0xe2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r17
	.word 0xde042c44  ! 1: LDUW_I	lduw	[%r16 + 0x0c44], %r15
	.word 0xc6942752  ! 1: LDUHA_I	lduha	[%r16, + 0x0752] %asi, %r3
	.word 0xfc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r30
	.word 0xce442de0  ! 1: LDSW_I	ldsw	[%r16 + 0x0de0], %r7
	.word 0xda442e14  ! 1: LDSW_I	ldsw	[%r16 + 0x0e14], %r13
	brnz %r31,thr3_loop_cnt_1160
	dec %r31
	.word 0xa92c0002  ! 1: SLL_R	sll 	%r16, %r2, %r20
	.word 0x861425f0  ! 1: OR_I	or 	%r16, 0x05f0, %r3
        mov 0x97, %r31
thr3_loop_cnt_1161:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6c42634  ! 1: LDSWA_I	ldswa	[%r16, + 0x0634] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r25
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r25
	.word 0xc6042a80  ! 1: LDUW_I	lduw	[%r16 + 0x0a80], %r3
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1161
	dec %r31
	.word 0x861428b9  ! 1: OR_I	or 	%r16, 0x08b9, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0xaa44211c  ! 1: ADDC_I	addc 	%r16, 0x011c, %r21
	.word 0x860c23aa  ! 1: AND_I	and 	%r16, 0x03aa, %r3
        mov 0xae, %r31
thr3_loop_cnt_1162:
	.word 0xe4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r18
	.word 0xce8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r7
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xce040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r7
	.word 0xc6042640  ! 1: LDUW_I	lduw	[%r16 + 0x0640], %r3
	.word 0xf8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r28
	.word 0xea5c2a80  ! 1: LDX_I	ldx	[%r16 + 0x0a80], %r21
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1162
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x9c, %r31
thr3_loop_cnt_1163:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc60c2e8b  ! 1: LDUB_I	ldub	[%r16 + 0x0e8b], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc65c2930  ! 1: LDX_I	ldx	[%r16 + 0x0930], %r3
	.word 0xd65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r11
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xce8c21d3  ! 1: LDUBA_I	lduba	[%r16, + 0x01d3] %asi, %r7
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	.word 0xc6d42fda  ! 1: LDSHA_I	ldsha	[%r16, + 0x0fda] %asi, %r3
	.word 0xfc542ecc  ! 1: LDSH_I	ldsh	[%r16 + 0x0ecc], %r30
	.word 0xd854209e  ! 1: LDSH_I	ldsh	[%r16 + 0x009e], %r12
	brnz %r31,thr3_loop_cnt_1163
	dec %r31
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0xa, %r31
thr3_loop_cnt_1164:
	.word 0xf0cc263a  ! 1: LDSBA_I	ldsba	[%r16, + 0x063a] %asi, %r24
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xe8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r20
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xec4c217b  ! 1: LDSB_I	ldsb	[%r16 + 0x017b], %r22
	.word 0xc6d4226a  ! 1: LDSHA_I	ldsha	[%r16, + 0x026a] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd65c2e18  ! 1: LDX_I	ldx	[%r16 + 0x0e18], %r11
	.word 0xd04c249b  ! 1: LDSB_I	ldsb	[%r16 + 0x049b], %r8
	.word 0xdadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r13
	brnz %r31,thr3_loop_cnt_1164
	dec %r31
	.word 0x8f340002  ! 1: SRL_R	srl 	%r16, %r2, %r7
	.word 0x8634229d  ! 1: ORN_I	orn 	%r16, 0x029d, %r3
	.word 0x8e2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r7
        mov 0x76, %r31
thr3_loop_cnt_1165:
	.word 0xc60c28bb  ! 1: LDUB_I	ldub	[%r16 + 0x08bb], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd044232c  ! 1: LDSW_I	ldsw	[%r16 + 0x032c], %r8
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6842f74  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f74] %asi, %r3
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	.word 0xcc0423a4  ! 1: LDUW_I	lduw	[%r16 + 0x03a4], %r6
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1165
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x863c2bc1  ! 1: XNOR_I	xnor 	%r16, 0x0bc1, %r3
	.word 0x86342b91  ! 1: SUBC_I	orn 	%r16, 0x0b91, %r3
	.word 0xb1343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r24
        mov 0x64, %r31
thr3_loop_cnt_1166:
	.word 0xda941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r13
	.word 0xc68c2801  ! 1: LDUBA_I	lduba	[%r16, + 0x0801] %asi, %r3
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xc68c2da9  ! 1: LDUBA_I	lduba	[%r16, + 0x0da9] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xcc0429c8  ! 1: LDUW_I	lduw	[%r16 + 0x09c8], %r6
	.word 0xc6942074  ! 1: LDUHA_I	lduha	[%r16, + 0x0074] %asi, %r3
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1166
	dec %r31
	.word 0x8e340002  ! 1: SUBC_R	orn 	%r16, %r2, %r7
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0x1e, %r31
thr3_loop_cnt_1167:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r25
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6042268  ! 1: LDUW_I	lduw	[%r16 + 0x0268], %r3
	.word 0xd85c28d0  ! 1: LDX_I	ldx	[%r16 + 0x08d0], %r12
	.word 0xecd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r22
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xc6442308  ! 1: LDSW_I	ldsw	[%r16 + 0x0308], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc614233c  ! 1: LDUH_I	lduh	[%r16 + 0x033c], %r3
	.word 0xd6042bf4  ! 1: LDUW_I	lduw	[%r16 + 0x0bf4], %r11
	.word 0xea4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r21
	brnz %r31,thr3_loop_cnt_1167
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x85, %r31
thr3_loop_cnt_1168:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6d4268a  ! 1: LDSHA_I	ldsha	[%r16, + 0x068a] %asi, %r3
	.word 0xeec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r23
	.word 0xccdc2228  ! 1: LDXA_I	ldxa	[%r16, + 0x0228] %asi, %r6
	.word 0xf4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r26
	brnz %r31,thr3_loop_cnt_1168
	dec %r31
	.word 0x863421a7  ! 1: ORN_I	orn 	%r16, 0x01a7, %r3
	.word 0x9c240002  ! 1: SUB_R	sub 	%r16, %r2, %r14
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0x43, %r31
thr3_loop_cnt_1169:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r20
	.word 0xc6142112  ! 1: LDUH_I	lduh	[%r16 + 0x0112], %r3
	.word 0xde842118  ! 1: LDUWA_I	lduwa	[%r16, + 0x0118] %asi, %r15
	.word 0xc6042f8c  ! 1: LDUW_I	lduw	[%r16 + 0x0f8c], %r3
	.word 0xc6d42266  ! 1: LDSHA_I	ldsha	[%r16, + 0x0266] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xcc5c2330  ! 1: LDX_I	ldx	[%r16 + 0x0330], %r6
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xfa140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r29
	brnz %r31,thr3_loop_cnt_1169
	dec %r31
	.word 0x9c140002  ! 1: OR_R	or 	%r16, %r2, %r14
	.word 0x9c440002  ! 1: ADDC_R	addc 	%r16, %r2, %r14
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x900c2ac1  ! 1: AND_I	and 	%r16, 0x0ac1, %r8
        mov 0x2d, %r31
thr3_loop_cnt_1170:
	.word 0xdc442fb8  ! 1: LDSW_I	ldsw	[%r16 + 0x0fb8], %r14
	.word 0xd4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r10
	.word 0xced42306  ! 1: LDSHA_I	ldsha	[%r16, + 0x0306] %asi, %r7
	.word 0xea8c21d5  ! 1: LDUBA_I	lduba	[%r16, + 0x01d5] %asi, %r21
	.word 0xde9426cc  ! 1: LDUHA_I	lduha	[%r16, + 0x06cc] %asi, %r15
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6542e8e  ! 1: LDSH_I	ldsh	[%r16 + 0x0e8e], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6c42f10  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f10] %asi, %r3
	brnz %r31,thr3_loop_cnt_1170
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x83, %r31
thr3_loop_cnt_1171:
	.word 0xc60c283f  ! 1: LDUB_I	ldub	[%r16 + 0x083f], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xfa8c2d47  ! 1: LDUBA_I	lduba	[%r16, + 0x0d47] %asi, %r29
	.word 0xdedc2a50  ! 1: LDXA_I	ldxa	[%r16, + 0x0a50] %asi, %r15
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6cc2c4c  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c4c] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xfa140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r29
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe8842e68  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e68] %asi, %r20
	brnz %r31,thr3_loop_cnt_1171
	dec %r31
	.word 0x99341002  ! 1: SRLX_R	srlx	%r16, %r2, %r12
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0x7f, %r31
thr3_loop_cnt_1172:
	.word 0xf4442de0  ! 1: LDSW_I	ldsw	[%r16 + 0x0de0], %r26
	.word 0xf60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r27
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xea5c2d50  ! 1: LDX_I	ldx	[%r16 + 0x0d50], %r21
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1172
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0x91, %r31
thr3_loop_cnt_1173:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r28
	.word 0xf00c20f3  ! 1: LDUB_I	ldub	[%r16 + 0x00f3], %r24
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6542cae  ! 1: LDSH_I	ldsh	[%r16 + 0x0cae], %r3
	.word 0xf69429a2  ! 1: LDUHA_I	lduha	[%r16, + 0x09a2] %asi, %r27
	.word 0xc61426ae  ! 1: LDUH_I	lduh	[%r16 + 0x06ae], %r3
	.word 0xccd4242a  ! 1: LDSHA_I	ldsha	[%r16, + 0x042a] %asi, %r6
	.word 0xccdc21c8  ! 1: LDXA_I	ldxa	[%r16, + 0x01c8] %asi, %r6
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6c4262c  ! 1: LDSWA_I	ldswa	[%r16, + 0x062c] %asi, %r3
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	brnz %r31,thr3_loop_cnt_1173
	dec %r31
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0xb8, %r31
thr3_loop_cnt_1174:
	.word 0xc60c2963  ! 1: LDUB_I	ldub	[%r16 + 0x0963], %r3
	.word 0xec0c24f6  ! 1: LDUB_I	ldub	[%r16 + 0x04f6], %r22
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd65c2000  ! 1: LDX_I	ldx	[%r16 + 0x0000], %r11
	.word 0xf80c25b5  ! 1: LDUB_I	ldub	[%r16 + 0x05b5], %r28
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe6542424  ! 1: LDSH_I	ldsh	[%r16 + 0x0424], %r19
	.word 0xc65c2ee0  ! 1: LDX_I	ldx	[%r16 + 0x0ee0], %r3
	.word 0xc644201c  ! 1: LDSW_I	ldsw	[%r16 + 0x001c], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r12
	brnz %r31,thr3_loop_cnt_1174
	dec %r31
	.word 0xac242f40  ! 1: SUB_I	sub 	%r16, 0x0f40, %r22
        mov 0x71, %r31
thr3_loop_cnt_1175:
	.word 0xf80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r28
	.word 0xe8c42300  ! 1: LDSWA_I	ldswa	[%r16, + 0x0300] %asi, %r20
	.word 0xc6842f24  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f24] %asi, %r3
	.word 0xd6cc2c60  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c60] %asi, %r11
	.word 0xdc542be8  ! 1: LDSH_I	ldsh	[%r16 + 0x0be8], %r14
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xdc1422fc  ! 1: LDUH_I	lduh	[%r16 + 0x02fc], %r14
	.word 0xc6542026  ! 1: LDSH_I	ldsh	[%r16 + 0x0026], %r3
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	brnz %r31,thr3_loop_cnt_1175
	dec %r31
        mov 0x4b, %r31
thr3_loop_cnt_1176:
	.word 0xd4c42de4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0de4] %asi, %r10
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc61422a4  ! 1: LDUH_I	lduh	[%r16 + 0x02a4], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xce5423ba  ! 1: LDSH_I	ldsh	[%r16 + 0x03ba], %r7
	.word 0xc60c2994  ! 1: LDUB_I	ldub	[%r16 + 0x0994], %r3
	.word 0xda941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r13
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd654207e  ! 1: LDSH_I	ldsh	[%r16 + 0x007e], %r11
	.word 0xfcdc24b8  ! 1: LDXA_I	ldxa	[%r16, + 0x04b8] %asi, %r30
	.word 0xe8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r20
	brnz %r31,thr3_loop_cnt_1176
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0xa6340002  ! 1: SUBC_R	orn 	%r16, %r2, %r19
        mov 0x15, %r31
thr3_loop_cnt_1177:
	.word 0xc6dc23a8  ! 1: LDXA_I	ldxa	[%r16, + 0x03a8] %asi, %r3
	.word 0xe40426a8  ! 1: LDUW_I	lduw	[%r16 + 0x06a8], %r18
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf81429b8  ! 1: LDUH_I	lduh	[%r16 + 0x09b8], %r28
	.word 0xf2d42688  ! 1: LDSHA_I	ldsha	[%r16, + 0x0688] %asi, %r25
	.word 0xe2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r17
	.word 0xc6dc2b00  ! 1: LDXA_I	ldxa	[%r16, + 0x0b00] %asi, %r3
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xf8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r28
	.word 0xfcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r30
	brnz %r31,thr3_loop_cnt_1177
	dec %r31
	.word 0x960c0002  ! 1: AND_R	and 	%r16, %r2, %r11
        mov 0x16, %r31
thr3_loop_cnt_1178:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6c4245c  ! 1: LDSWA_I	ldswa	[%r16, + 0x045c] %asi, %r3
	.word 0xc68c29c1  ! 1: LDUBA_I	lduba	[%r16, + 0x09c1] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xde5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r15
	.word 0xc6442ccc  ! 1: LDSW_I	ldsw	[%r16 + 0x0ccc], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1178
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0xb0342eeb  ! 1: ORN_I	orn 	%r16, 0x0eeb, %r24
        mov 0x80, %r31
thr3_loop_cnt_1179:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xea540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r21
	.word 0xc6c42f80  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f80] %asi, %r3
	.word 0xfadc2150  ! 1: LDXA_I	ldxa	[%r16, + 0x0150] %asi, %r29
	.word 0xfa841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r29
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	.word 0xccd423ba  ! 1: LDSHA_I	ldsha	[%r16, + 0x03ba] %asi, %r6
	.word 0xe8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r20
	brnz %r31,thr3_loop_cnt_1179
	dec %r31
	.word 0xa5342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r18
        mov 0x7e, %r31
thr3_loop_cnt_1180:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xced41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r7
	.word 0xfa942ed6  ! 1: LDUHA_I	lduha	[%r16, + 0x0ed6] %asi, %r29
	.word 0xce040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r7
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r9
	.word 0xc60424b8  ! 1: LDUW_I	lduw	[%r16 + 0x04b8], %r3
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	.word 0xfa5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r29
	.word 0xc6cc2ed5  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ed5] %asi, %r3
	.word 0xd04c2571  ! 1: LDSB_I	ldsb	[%r16 + 0x0571], %r8
	brnz %r31,thr3_loop_cnt_1180
	dec %r31
	.word 0xa4440002  ! 1: ADDC_R	addc 	%r16, %r2, %r18
	.word 0xb01c2460  ! 1: XOR_I	xor 	%r16, 0x0460, %r24
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0x4c, %r31
thr3_loop_cnt_1181:
	.word 0xf4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r26
	.word 0xec440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r22
	.word 0xe2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r17
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xe4842e24  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e24] %asi, %r18
	.word 0xf68c2f8c  ! 1: LDUBA_I	lduba	[%r16, + 0x0f8c] %asi, %r27
	.word 0xfc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r30
	.word 0xe68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r19
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1181
	dec %r31
	.word 0x96042d79  ! 1: ADD_I	add 	%r16, 0x0d79, %r11
	.word 0x8624278f  ! 1: SUB_I	sub 	%r16, 0x078f, %r3
	.word 0x8f340002  ! 1: SRL_R	srl 	%r16, %r2, %r7
        mov 0x32, %r31
thr3_loop_cnt_1182:
	.word 0xc65420cc  ! 1: LDSH_I	ldsh	[%r16 + 0x00cc], %r3
	.word 0xc6942aa4  ! 1: LDUHA_I	lduha	[%r16, + 0x0aa4] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc614215a  ! 1: LDUH_I	lduh	[%r16 + 0x015a], %r3
	.word 0xda8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r13
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r11
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6942b2e  ! 1: LDUHA_I	lduha	[%r16, + 0x0b2e] %asi, %r3
	.word 0xcc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r6
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xec542d5e  ! 1: LDSH_I	ldsh	[%r16 + 0x0d5e], %r22
	brnz %r31,thr3_loop_cnt_1182
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0xb4442f7a  ! 1: ADDC_I	addc 	%r16, 0x0f7a, %r26
        mov 0x55, %r31
thr3_loop_cnt_1183:
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xc6d42ce4  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ce4] %asi, %r3
	.word 0xc6cc2dfb  ! 1: LDSBA_I	ldsba	[%r16, + 0x0dfb] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf6cc24b7  ! 1: LDSBA_I	ldsba	[%r16, + 0x04b7] %asi, %r27
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc68422ac  ! 1: LDUWA_I	lduwa	[%r16, + 0x02ac] %asi, %r3
	brnz %r31,thr3_loop_cnt_1183
	dec %r31
	.word 0xb73c0002  ! 1: SRA_R	sra 	%r16, %r2, %r27
	.word 0x944421c0  ! 1: ADDC_I	addc 	%r16, 0x01c0, %r10
	.word 0xbc3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r30
        mov 0x34, %r31
thr3_loop_cnt_1184:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd2d421a8  ! 1: LDSHA_I	ldsha	[%r16, + 0x01a8] %asi, %r9
	.word 0xdad427ce  ! 1: LDSHA_I	ldsha	[%r16, + 0x07ce] %asi, %r13
	.word 0xf0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r24
	.word 0xf2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r25
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc64c2562  ! 1: LDSB_I	ldsb	[%r16 + 0x0562], %r3
	brnz %r31,thr3_loop_cnt_1184
	dec %r31
	.word 0x912c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r8
	.word 0xab343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r21
	.word 0x863c2ef6  ! 1: XNOR_I	xnor 	%r16, 0x0ef6, %r3
        mov 0xc2, %r31
thr3_loop_cnt_1185:
	.word 0xc60420b4  ! 1: LDUW_I	lduw	[%r16 + 0x00b4], %r3
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xc69426bc  ! 1: LDUHA_I	lduha	[%r16, + 0x06bc] %asi, %r3
	.word 0xec540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r22
	.word 0xe4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r18
	.word 0xec4c2c20  ! 1: LDSB_I	ldsb	[%r16 + 0x0c20], %r22
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xde842dd0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0dd0] %asi, %r15
	.word 0xdec425cc  ! 1: LDSWA_I	ldswa	[%r16, + 0x05cc] %asi, %r15
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	brnz %r31,thr3_loop_cnt_1185
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x2e, %r31
thr3_loop_cnt_1186:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xc6dc2d60  ! 1: LDXA_I	ldxa	[%r16, + 0x0d60] %asi, %r3
	.word 0xfc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r30
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1186
	dec %r31
	.word 0x86142b0a  ! 1: OR_I	or 	%r16, 0x0b0a, %r3
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
        mov 0x7f, %r31
thr3_loop_cnt_1187:
	.word 0xf08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r24
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6442054  ! 1: LDSW_I	ldsw	[%r16 + 0x0054], %r3
	.word 0xdc542e50  ! 1: LDSH_I	ldsh	[%r16 + 0x0e50], %r14
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xccd422b4  ! 1: LDSHA_I	ldsha	[%r16, + 0x02b4] %asi, %r6
	brnz %r31,thr3_loop_cnt_1187
	dec %r31
	.word 0xb5343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r26
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x9f, %r31
thr3_loop_cnt_1188:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf84c2adf  ! 1: LDSB_I	ldsb	[%r16 + 0x0adf], %r28
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6042224  ! 1: LDUW_I	lduw	[%r16 + 0x0224], %r3
	.word 0xc64422f0  ! 1: LDSW_I	ldsw	[%r16 + 0x02f0], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc68c27a2  ! 1: LDUBA_I	lduba	[%r16, + 0x07a2] %asi, %r3
	.word 0xc6d42cce  ! 1: LDSHA_I	ldsha	[%r16, + 0x0cce] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd4c420d0  ! 1: LDSWA_I	ldswa	[%r16, + 0x00d0] %asi, %r10
	brnz %r31,thr3_loop_cnt_1188
	dec %r31
	.word 0x9c1c0002  ! 1: XOR_R	xor 	%r16, %r2, %r14
	.word 0x94440002  ! 1: ADDC_R	addc 	%r16, %r2, %r10
	.word 0xb73c1002  ! 1: SRAX_R	srax	%r16, %r2, %r27
        mov 0x93, %r31
thr3_loop_cnt_1189:
	.word 0xf4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r26
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r26
	.word 0xfc5427a8  ! 1: LDSH_I	ldsh	[%r16 + 0x07a8], %r30
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xd64c2db0  ! 1: LDSB_I	ldsb	[%r16 + 0x0db0], %r11
	.word 0xc64421d8  ! 1: LDSW_I	ldsw	[%r16 + 0x01d8], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xee0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r23
	.word 0xdc842088  ! 1: LDUWA_I	lduwa	[%r16, + 0x0088] %asi, %r14
	.word 0xc65c2760  ! 1: LDX_I	ldx	[%r16 + 0x0760], %r3
	brnz %r31,thr3_loop_cnt_1189
	dec %r31
	.word 0xa83c2f55  ! 1: XNOR_I	xnor 	%r16, 0x0f55, %r20
	.word 0x96240002  ! 1: SUB_R	sub 	%r16, %r2, %r11
        mov 0x64, %r31
thr3_loop_cnt_1190:
	.word 0xd0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r8
	.word 0xdccc2ac7  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ac7] %asi, %r14
	.word 0xc6942c34  ! 1: LDUHA_I	lduha	[%r16, + 0x0c34] %asi, %r3
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	.word 0xf4c42070  ! 1: LDSWA_I	ldswa	[%r16, + 0x0070] %asi, %r26
	.word 0xdc04250c  ! 1: LDUW_I	lduw	[%r16 + 0x050c], %r14
	.word 0xd64c2bad  ! 1: LDSB_I	ldsb	[%r16 + 0x0bad], %r11
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd04c2b1c  ! 1: LDSB_I	ldsb	[%r16 + 0x0b1c], %r8
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6d42e24  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e24] %asi, %r3
	brnz %r31,thr3_loop_cnt_1190
	dec %r31
        mov 0x6f, %r31
thr3_loop_cnt_1191:
	.word 0xcc4c2ef9  ! 1: LDSB_I	ldsb	[%r16 + 0x0ef9], %r6
	.word 0xc6542a44  ! 1: LDSH_I	ldsh	[%r16 + 0x0a44], %r3
	.word 0xfc4c2f39  ! 1: LDSB_I	ldsb	[%r16 + 0x0f39], %r30
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2da8  ! 1: LDXA_I	ldxa	[%r16, + 0x0da8] %asi, %r3
	.word 0xc68428bc  ! 1: LDUWA_I	lduwa	[%r16, + 0x08bc] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xf8c42344  ! 1: LDSWA_I	ldswa	[%r16, + 0x0344] %asi, %r28
	.word 0xccdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r6
	brnz %r31,thr3_loop_cnt_1191
	dec %r31
	.word 0x96040002  ! 1: ADD_R	add 	%r16, %r2, %r11
	.word 0xa23425fd  ! 1: SUBC_I	orn 	%r16, 0x05fd, %r17
	.word 0xb61c0002  ! 1: XOR_R	xor 	%r16, %r2, %r27
	.word 0xa93c0002  ! 1: SRA_R	sra 	%r16, %r2, %r20
        mov 0xb8, %r31
thr3_loop_cnt_1192:
	.word 0xc6d4273a  ! 1: LDSHA_I	ldsha	[%r16, + 0x073a] %asi, %r3
	.word 0xc61420f2  ! 1: LDUH_I	lduh	[%r16 + 0x00f2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd2542070  ! 1: LDSH_I	ldsh	[%r16 + 0x0070], %r9
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6542a3a  ! 1: LDSH_I	ldsh	[%r16 + 0x0a3a], %r3
	.word 0xce8426c0  ! 1: LDUWA_I	lduwa	[%r16, + 0x06c0] %asi, %r7
	.word 0xf4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r26
	brnz %r31,thr3_loop_cnt_1192
	dec %r31
	.word 0xb72c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r27
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x59, %r31
thr3_loop_cnt_1193:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd8042c90  ! 1: LDUW_I	lduw	[%r16 + 0x0c90], %r12
	.word 0xec941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r22
	.word 0xe44c2df2  ! 1: LDSB_I	ldsb	[%r16 + 0x0df2], %r18
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf20c2220  ! 1: LDUB_I	ldub	[%r16 + 0x0220], %r25
	.word 0xe8d42fb2  ! 1: LDSHA_I	ldsha	[%r16, + 0x0fb2] %asi, %r20
	brnz %r31,thr3_loop_cnt_1193
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x91340002  ! 1: SRL_R	srl 	%r16, %r2, %r8
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0x58, %r31
thr3_loop_cnt_1194:
	.word 0xc6842d24  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d24] %asi, %r3
	.word 0xe4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r18
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	.word 0xd4442d84  ! 1: LDSW_I	ldsw	[%r16 + 0x0d84], %r10
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xea0c20fa  ! 1: LDUB_I	ldub	[%r16 + 0x00fa], %r21
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r8
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1194
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x40, %r31
thr3_loop_cnt_1195:
	.word 0xe64c255f  ! 1: LDSB_I	ldsb	[%r16 + 0x055f], %r19
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xc60c249d  ! 1: LDUB_I	ldub	[%r16 + 0x049d], %r3
	.word 0xc6442f78  ! 1: LDSW_I	ldsw	[%r16 + 0x0f78], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xdecc2fb8  ! 1: LDSBA_I	ldsba	[%r16, + 0x0fb8] %asi, %r15
	.word 0xd4842c88  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c88] %asi, %r10
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xee841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r23
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	brnz %r31,thr3_loop_cnt_1195
	dec %r31
	.word 0xa53c1002  ! 1: SRAX_R	srax	%r16, %r2, %r18
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x9e1c0002  ! 1: XOR_R	xor 	%r16, %r2, %r15
        mov 0x0, %r31
thr3_loop_cnt_1196:
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xd88c29ce  ! 1: LDUBA_I	lduba	[%r16, + 0x09ce] %asi, %r12
	.word 0xc6942020  ! 1: LDUHA_I	lduha	[%r16, + 0x0020] %asi, %r3
	.word 0xe6442ed4  ! 1: LDSW_I	ldsw	[%r16 + 0x0ed4], %r19
	.word 0xc61426ce  ! 1: LDUH_I	lduh	[%r16 + 0x06ce], %r3
	.word 0xee4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r23
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1196
	dec %r31
	.word 0x941c0002  ! 1: XOR_R	xor 	%r16, %r2, %r10
	.word 0xb6040002  ! 1: ADD_R	add 	%r16, %r2, %r27
        mov 0x42, %r31
thr3_loop_cnt_1197:
	.word 0xe2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r17
	.word 0xd8c42470  ! 1: LDSWA_I	ldswa	[%r16, + 0x0470] %asi, %r12
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd2cc267f  ! 1: LDSBA_I	ldsba	[%r16, + 0x067f] %asi, %r9
	.word 0xea841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r21
	.word 0xd4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r10
	.word 0xc68426b0  ! 1: LDUWA_I	lduwa	[%r16, + 0x06b0] %asi, %r3
	.word 0xf45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r26
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xfa042adc  ! 1: LDUW_I	lduw	[%r16 + 0x0adc], %r29
	brnz %r31,thr3_loop_cnt_1197
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x9a, %r31
thr3_loop_cnt_1198:
	.word 0xd4042500  ! 1: LDUW_I	lduw	[%r16 + 0x0500], %r10
	.word 0xc65429d6  ! 1: LDSH_I	ldsh	[%r16 + 0x09d6], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf8d42644  ! 1: LDSHA_I	ldsha	[%r16, + 0x0644] %asi, %r28
	.word 0xc694245c  ! 1: LDUHA_I	lduha	[%r16, + 0x045c] %asi, %r3
	.word 0xde84263c  ! 1: LDUWA_I	lduwa	[%r16, + 0x063c] %asi, %r15
	.word 0xc65427f2  ! 1: LDSH_I	ldsh	[%r16 + 0x07f2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1198
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x963c2ff1  ! 1: XNOR_I	xnor 	%r16, 0x0ff1, %r11
	.word 0x863425e5  ! 1: SUBC_I	orn 	%r16, 0x05e5, %r3
	.word 0xbd2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r30
        mov 0x2e, %r31
thr3_loop_cnt_1199:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc68c2e15  ! 1: LDUBA_I	lduba	[%r16, + 0x0e15] %asi, %r3
	.word 0xc60c2797  ! 1: LDUB_I	ldub	[%r16 + 0x0797], %r3
	.word 0xf8942bc4  ! 1: LDUHA_I	lduha	[%r16, + 0x0bc4] %asi, %r28
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xdac42c44  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c44] %asi, %r13
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xde440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r15
	brnz %r31,thr3_loop_cnt_1199
	dec %r31
	.word 0x8634293f  ! 1: SUBC_I	orn 	%r16, 0x093f, %r3
	.word 0x861c2d67  ! 1: XOR_I	xor 	%r16, 0x0d67, %r3
        mov 0x13, %r31
thr3_loop_cnt_1200:
	.word 0xc6542f7c  ! 1: LDSH_I	ldsh	[%r16 + 0x0f7c], %r3
	.word 0xdcdc20f8  ! 1: LDXA_I	ldxa	[%r16, + 0x00f8] %asi, %r14
	.word 0xd8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r12
	.word 0xc6542600  ! 1: LDSH_I	ldsh	[%r16 + 0x0600], %r3
	.word 0xc6942a94  ! 1: LDUHA_I	lduha	[%r16, + 0x0a94] %asi, %r3
	.word 0xd8842c9c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c9c] %asi, %r12
	.word 0xdedc2b48  ! 1: LDXA_I	ldxa	[%r16, + 0x0b48] %asi, %r15
	.word 0xc6442270  ! 1: LDSW_I	ldsw	[%r16 + 0x0270], %r3
	.word 0xc6cc25ca  ! 1: LDSBA_I	ldsba	[%r16, + 0x05ca] %asi, %r3
	.word 0xc6042ba0  ! 1: LDUW_I	lduw	[%r16 + 0x0ba0], %r3
	brnz %r31,thr3_loop_cnt_1200
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x1a, %r31
thr3_loop_cnt_1201:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc684211c  ! 1: LDUWA_I	lduwa	[%r16, + 0x011c] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc68c2953  ! 1: LDUBA_I	lduba	[%r16, + 0x0953] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xdc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r14
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1201
	dec %r31
	.word 0x9a0c0002  ! 1: AND_R	and 	%r16, %r2, %r13
	.word 0xaa040002  ! 1: ADD_R	add 	%r16, %r2, %r21
	.word 0xa634281c  ! 1: SUBC_I	orn 	%r16, 0x081c, %r19
        mov 0xaa, %r31
thr3_loop_cnt_1202:
	.word 0xc6d42160  ! 1: LDSHA_I	ldsha	[%r16, + 0x0160] %asi, %r3
	.word 0xc6542724  ! 1: LDSH_I	ldsh	[%r16 + 0x0724], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xccc4230c  ! 1: LDSWA_I	ldswa	[%r16, + 0x030c] %asi, %r6
	.word 0xde842694  ! 1: LDUWA_I	lduwa	[%r16, + 0x0694] %asi, %r15
	brnz %r31,thr3_loop_cnt_1202
	dec %r31
	.word 0xac442b2c  ! 1: ADDC_I	addc 	%r16, 0x0b2c, %r22
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0x9e, %r31
thr3_loop_cnt_1203:
	.word 0xcc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r6
	.word 0xf85c2d80  ! 1: LDX_I	ldx	[%r16 + 0x0d80], %r28
	.word 0xc694214e  ! 1: LDUHA_I	lduha	[%r16, + 0x014e] %asi, %r3
	.word 0xf2442358  ! 1: LDSW_I	ldsw	[%r16 + 0x0358], %r25
	.word 0xec542eb2  ! 1: LDSH_I	ldsh	[%r16 + 0x0eb2], %r22
	.word 0xced41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r7
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xce0c2a7c  ! 1: LDUB_I	ldub	[%r16 + 0x0a7c], %r7
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1203
	dec %r31
	.word 0xb0342b58  ! 1: ORN_I	orn 	%r16, 0x0b58, %r24
        mov 0xad, %r31
thr3_loop_cnt_1204:
	.word 0xc64c2d0d  ! 1: LDSB_I	ldsb	[%r16 + 0x0d0d], %r3
	.word 0xdccc203f  ! 1: LDSBA_I	ldsba	[%r16, + 0x003f] %asi, %r14
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xec8c2688  ! 1: LDUBA_I	lduba	[%r16, + 0x0688] %asi, %r22
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xfad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r29
	.word 0xf0c42ec8  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ec8] %asi, %r24
	brnz %r31,thr3_loop_cnt_1204
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0xc2, %r31
thr3_loop_cnt_1205:
	.word 0xc6042d2c  ! 1: LDUW_I	lduw	[%r16 + 0x0d2c], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r8
	.word 0xdad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r13
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6042df8  ! 1: LDUW_I	lduw	[%r16 + 0x0df8], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1205
	dec %r31
        mov 0x2d, %r31
thr3_loop_cnt_1206:
	.word 0xee4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r23
	.word 0xe4d42c5c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c5c] %asi, %r18
	.word 0xda842d2c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d2c] %asi, %r13
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xc60c26d9  ! 1: LDUB_I	ldub	[%r16 + 0x06d9], %r3
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r26
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1206
	dec %r31
	.word 0x863425b5  ! 1: SUBC_I	orn 	%r16, 0x05b5, %r3
	.word 0x9f341002  ! 1: SRLX_R	srlx	%r16, %r2, %r15
        mov 0x89, %r31
thr3_loop_cnt_1207:
	.word 0xc6442924  ! 1: LDSW_I	ldsw	[%r16 + 0x0924], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r11
	.word 0xd88c2d55  ! 1: LDUBA_I	lduba	[%r16, + 0x0d55] %asi, %r12
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd4dc2510  ! 1: LDXA_I	ldxa	[%r16, + 0x0510] %asi, %r10
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xd2442734  ! 1: LDSW_I	ldsw	[%r16 + 0x0734], %r9
	.word 0xe2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r17
	brnz %r31,thr3_loop_cnt_1207
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x8c3423d2  ! 1: SUBC_I	orn 	%r16, 0x03d2, %r6
	.word 0xac440002  ! 1: ADDC_R	addc 	%r16, %r2, %r22
        mov 0x8b, %r31
thr3_loop_cnt_1208:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc65c2e28  ! 1: LDX_I	ldx	[%r16 + 0x0e28], %r3
	.word 0xe6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r19
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r17
	.word 0xd25c24a0  ! 1: LDX_I	ldx	[%r16 + 0x04a0], %r9
	.word 0xe2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r17
	.word 0xec8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r22
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc61421ac  ! 1: LDUH_I	lduh	[%r16 + 0x01ac], %r3
	brnz %r31,thr3_loop_cnt_1208
	dec %r31
	.word 0xbc24200f  ! 1: SUB_I	sub 	%r16, 0x000f, %r30
	.word 0x86042ee4  ! 1: ADD_I	add 	%r16, 0x0ee4, %r3
	.word 0x9d2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r14
        mov 0x33, %r31
thr3_loop_cnt_1209:
	.word 0xd2442400  ! 1: LDSW_I	ldsw	[%r16 + 0x0400], %r9
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc694256c  ! 1: LDUHA_I	lduha	[%r16, + 0x056c] %asi, %r3
	.word 0xde540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r15
	.word 0xc6dc29e0  ! 1: LDXA_I	ldxa	[%r16, + 0x09e0] %asi, %r3
	.word 0xe28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r17
	.word 0xc68c2428  ! 1: LDUBA_I	lduba	[%r16, + 0x0428] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	.word 0xd6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r11
	brnz %r31,thr3_loop_cnt_1209
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x913c1002  ! 1: SRAX_R	srax	%r16, %r2, %r8
	.word 0xaa1c0002  ! 1: XOR_R	xor 	%r16, %r2, %r21
        mov 0x4a, %r31
thr3_loop_cnt_1210:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6542734  ! 1: LDSH_I	ldsh	[%r16 + 0x0734], %r3
	.word 0xd84c266e  ! 1: LDSB_I	ldsb	[%r16 + 0x066e], %r12
	.word 0xc6042f88  ! 1: LDUW_I	lduw	[%r16 + 0x0f88], %r3
	.word 0xc6d42d06  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d06] %asi, %r3
	.word 0xc6542e78  ! 1: LDSH_I	ldsh	[%r16 + 0x0e78], %r3
	.word 0xeccc2fb6  ! 1: LDSBA_I	ldsba	[%r16, + 0x0fb6] %asi, %r22
	.word 0xc6142714  ! 1: LDUH_I	lduh	[%r16 + 0x0714], %r3
	.word 0xd2942fd2  ! 1: LDUHA_I	lduha	[%r16, + 0x0fd2] %asi, %r9
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1210
	dec %r31
	.word 0x8624244b  ! 1: SUB_I	sub 	%r16, 0x044b, %r3
	.word 0x8e2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r7
        mov 0x38, %r31
thr3_loop_cnt_1211:
	.word 0xd68c29dc  ! 1: LDUBA_I	lduba	[%r16, + 0x09dc] %asi, %r11
	.word 0xda5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r13
	.word 0xf48c2a94  ! 1: LDUBA_I	lduba	[%r16, + 0x0a94] %asi, %r26
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc68c24a8  ! 1: LDUBA_I	lduba	[%r16, + 0x04a8] %asi, %r3
	.word 0xc6d42ed8  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ed8] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6d4238a  ! 1: LDSHA_I	ldsha	[%r16, + 0x038a] %asi, %r3
	.word 0xdc942a1c  ! 1: LDUHA_I	lduha	[%r16, + 0x0a1c] %asi, %r14
	.word 0xd88c27e0  ! 1: LDUBA_I	lduba	[%r16, + 0x07e0] %asi, %r12
	brnz %r31,thr3_loop_cnt_1211
	dec %r31
	.word 0xb0442e6b  ! 1: ADDC_I	addc 	%r16, 0x0e6b, %r24
	.word 0x9a242f7c  ! 1: SUB_I	sub 	%r16, 0x0f7c, %r13
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0x93, %r31
thr3_loop_cnt_1212:
	.word 0xfac429f4  ! 1: LDSWA_I	ldswa	[%r16, + 0x09f4] %asi, %r29
	.word 0xee040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r23
	.word 0xe2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r17
	.word 0xc60c21ae  ! 1: LDUB_I	ldub	[%r16 + 0x01ae], %r3
	.word 0xc64c2c6a  ! 1: LDSB_I	ldsb	[%r16 + 0x0c6a], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	.word 0xc6842360  ! 1: LDUWA_I	lduwa	[%r16, + 0x0360] %asi, %r3
	.word 0xfa8c2e95  ! 1: LDUBA_I	lduba	[%r16, + 0x0e95] %asi, %r29
	brnz %r31,thr3_loop_cnt_1212
	dec %r31
        mov 0x64, %r31
thr3_loop_cnt_1213:
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	.word 0xf85424ec  ! 1: LDSH_I	ldsh	[%r16 + 0x04ec], %r28
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r18
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r8
	brnz %r31,thr3_loop_cnt_1213
	dec %r31
	.word 0xaa2c222f  ! 1: ANDN_I	andn 	%r16, 0x022f, %r21
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x9a1c2b51  ! 1: XOR_I	xor 	%r16, 0x0b51, %r13
        mov 0xc, %r31
thr3_loop_cnt_1214:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd2d42442  ! 1: LDSHA_I	ldsha	[%r16, + 0x0442] %asi, %r9
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6cc241b  ! 1: LDSBA_I	ldsba	[%r16, + 0x041b] %asi, %r3
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	.word 0xc6442a8c  ! 1: LDSW_I	ldsw	[%r16 + 0x0a8c], %r3
	.word 0xe4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r18
	.word 0xd4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r10
	brnz %r31,thr3_loop_cnt_1214
	dec %r31
	.word 0x861427c9  ! 1: OR_I	or 	%r16, 0x07c9, %r3
	.word 0xb00c0002  ! 1: AND_R	and 	%r16, %r2, %r24
        mov 0x5b, %r31
thr3_loop_cnt_1215:
	.word 0xdc942272  ! 1: LDUHA_I	lduha	[%r16, + 0x0272] %asi, %r14
	.word 0xc6142606  ! 1: LDUH_I	lduh	[%r16 + 0x0606], %r3
	.word 0xdc042190  ! 1: LDUW_I	lduw	[%r16 + 0x0190], %r14
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe68c2f3a  ! 1: LDUBA_I	lduba	[%r16, + 0x0f3a] %asi, %r19
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf444299c  ! 1: LDSW_I	ldsw	[%r16 + 0x099c], %r26
	brnz %r31,thr3_loop_cnt_1215
	dec %r31
	.word 0x862c2098  ! 1: ANDN_I	andn 	%r16, 0x0098, %r3
	.word 0x8c342bc5  ! 1: SUBC_I	orn 	%r16, 0x0bc5, %r6
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0x3e, %r31
thr3_loop_cnt_1216:
	.word 0xc68c2671  ! 1: LDUBA_I	lduba	[%r16, + 0x0671] %asi, %r3
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	.word 0xf04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r24
	.word 0xd2442bd8  ! 1: LDSW_I	ldsw	[%r16 + 0x0bd8], %r9
	.word 0xd0cc26c3  ! 1: LDSBA_I	ldsba	[%r16, + 0x06c3] %asi, %r8
	.word 0xf44c2976  ! 1: LDSB_I	ldsb	[%r16 + 0x0976], %r26
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r17
	.word 0xec841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r22
	.word 0xfac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r29
	brnz %r31,thr3_loop_cnt_1216
	dec %r31
        mov 0x3, %r31
thr3_loop_cnt_1217:
	.word 0xc6142530  ! 1: LDUH_I	lduh	[%r16 + 0x0530], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xce4c25c4  ! 1: LDSB_I	ldsb	[%r16 + 0x05c4], %r7
	.word 0xc6142ee0  ! 1: LDUH_I	lduh	[%r16 + 0x0ee0], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6c426b0  ! 1: LDSWA_I	ldswa	[%r16, + 0x06b0] %asi, %r3
	brnz %r31,thr3_loop_cnt_1217
	dec %r31
	.word 0x9a240002  ! 1: SUB_R	sub 	%r16, %r2, %r13
        mov 0x56, %r31
thr3_loop_cnt_1218:
	.word 0xc64c220c  ! 1: LDSB_I	ldsb	[%r16 + 0x020c], %r3
	.word 0xd0942884  ! 1: LDUHA_I	lduha	[%r16, + 0x0884] %asi, %r8
	.word 0xea841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r21
	.word 0xea8c2b39  ! 1: LDUBA_I	lduba	[%r16, + 0x0b39] %asi, %r21
	.word 0xd65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r11
	.word 0xc654211e  ! 1: LDSH_I	ldsh	[%r16 + 0x011e], %r3
	.word 0xc6842d44  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d44] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf4cc2c90  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c90] %asi, %r26
	.word 0xc64c2d0a  ! 1: LDSB_I	ldsb	[%r16 + 0x0d0a], %r3
	.word 0xc68c289b  ! 1: LDUBA_I	lduba	[%r16, + 0x089b] %asi, %r3
	.word 0xd0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r8
	brnz %r31,thr3_loop_cnt_1218
	dec %r31
	.word 0x940c0002  ! 1: AND_R	and 	%r16, %r2, %r10
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x7a, %r31
thr3_loop_cnt_1219:
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xd2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r9
	.word 0xc6442f10  ! 1: LDSW_I	ldsw	[%r16 + 0x0f10], %r3
	.word 0xd2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r9
	.word 0xc60429d0  ! 1: LDUW_I	lduw	[%r16 + 0x09d0], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xc69427ca  ! 1: LDUHA_I	lduha	[%r16, + 0x07ca] %asi, %r3
	.word 0xc6142bf6  ! 1: LDUH_I	lduh	[%r16 + 0x0bf6], %r3
	brnz %r31,thr3_loop_cnt_1219
	dec %r31
	.word 0xad2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r22
	.word 0xb7340002  ! 1: SRL_R	srl 	%r16, %r2, %r27
	.word 0x86042940  ! 1: ADD_I	add 	%r16, 0x0940, %r3
        mov 0x93, %r31
thr3_loop_cnt_1220:
	.word 0xd8d42bdc  ! 1: LDSHA_I	ldsha	[%r16, + 0x0bdc] %asi, %r12
	.word 0xf84c2f57  ! 1: LDSB_I	ldsb	[%r16 + 0x0f57], %r28
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc65c2ec8  ! 1: LDX_I	ldx	[%r16 + 0x0ec8], %r3
	.word 0xc6542c2a  ! 1: LDSH_I	ldsh	[%r16 + 0x0c2a], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc61424cc  ! 1: LDUH_I	lduh	[%r16 + 0x04cc], %r3
	.word 0xf4142d8a  ! 1: LDUH_I	lduh	[%r16 + 0x0d8a], %r26
	.word 0xc6442f44  ! 1: LDSW_I	ldsw	[%r16 + 0x0f44], %r3
	brnz %r31,thr3_loop_cnt_1220
	dec %r31
	.word 0x96442ea3  ! 1: ADDC_I	addc 	%r16, 0x0ea3, %r11
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x863c2d34  ! 1: XNOR_I	xnor 	%r16, 0x0d34, %r3
        mov 0x7c, %r31
thr3_loop_cnt_1221:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6942c58  ! 1: LDUHA_I	lduha	[%r16, + 0x0c58] %asi, %r3
	.word 0xe4442898  ! 1: LDSW_I	ldsw	[%r16 + 0x0898], %r18
	.word 0xfa540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r29
	.word 0xc6d421b8  ! 1: LDSHA_I	ldsha	[%r16, + 0x01b8] %asi, %r3
	.word 0xec542e4a  ! 1: LDSH_I	ldsh	[%r16 + 0x0e4a], %r22
	.word 0xf2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r25
	.word 0xc68420c8  ! 1: LDUWA_I	lduwa	[%r16, + 0x00c8] %asi, %r3
	.word 0xc60c234f  ! 1: LDUB_I	ldub	[%r16 + 0x034f], %r3
	.word 0xd6442a10  ! 1: LDSW_I	ldsw	[%r16 + 0x0a10], %r11
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	brnz %r31,thr3_loop_cnt_1221
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0x84, %r31
thr3_loop_cnt_1222:
	.word 0xfc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r30
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r24
	.word 0xfc842b0c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b0c] %asi, %r30
	.word 0xfc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r30
	.word 0xd4d42ffc  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ffc] %asi, %r10
	.word 0xd8dc2710  ! 1: LDXA_I	ldxa	[%r16, + 0x0710] %asi, %r12
	.word 0xd60c2225  ! 1: LDUB_I	ldub	[%r16 + 0x0225], %r11
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1222
	dec %r31
        mov 0x5, %r31
thr3_loop_cnt_1223:
	.word 0xecc42dfc  ! 1: LDSWA_I	ldswa	[%r16, + 0x0dfc] %asi, %r22
	.word 0xf8dc2be8  ! 1: LDXA_I	ldxa	[%r16, + 0x0be8] %asi, %r28
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xc6c42868  ! 1: LDSWA_I	ldswa	[%r16, + 0x0868] %asi, %r3
	.word 0xc60c2e07  ! 1: LDUB_I	ldub	[%r16 + 0x0e07], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r26
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1223
	dec %r31
        mov 0x6d, %r31
thr3_loop_cnt_1224:
	.word 0xc64c2bfd  ! 1: LDSB_I	ldsb	[%r16 + 0x0bfd], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc65c2510  ! 1: LDX_I	ldx	[%r16 + 0x0510], %r3
	.word 0xd6dc2200  ! 1: LDXA_I	ldxa	[%r16, + 0x0200] %asi, %r11
	.word 0xc6142c72  ! 1: LDUH_I	lduh	[%r16 + 0x0c72], %r3
	.word 0xc6542132  ! 1: LDSH_I	ldsh	[%r16 + 0x0132], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r28
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r10
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1224
	dec %r31
	.word 0xab2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r21
        mov 0xab, %r31
thr3_loop_cnt_1225:
	.word 0xe2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r17
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6142922  ! 1: LDUH_I	lduh	[%r16 + 0x0922], %r3
	.word 0xea0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r21
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc64c242e  ! 1: LDSB_I	ldsb	[%r16 + 0x042e], %r3
	.word 0xc6542d6e  ! 1: LDSH_I	ldsh	[%r16 + 0x0d6e], %r3
	.word 0xe68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r19
	brnz %r31,thr3_loop_cnt_1225
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x9e142825  ! 1: OR_I	or 	%r16, 0x0825, %r15
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x79, %r31
thr3_loop_cnt_1226:
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xc6442e18  ! 1: LDSW_I	ldsw	[%r16 + 0x0e18], %r3
	.word 0xf6442ee8  ! 1: LDSW_I	ldsw	[%r16 + 0x0ee8], %r27
	.word 0xf20427c0  ! 1: LDUW_I	lduw	[%r16 + 0x07c0], %r25
	.word 0xc6d42c72  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c72] %asi, %r3
	.word 0xe24c2315  ! 1: LDSB_I	ldsb	[%r16 + 0x0315], %r17
	.word 0xd8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r12
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xec5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r22
	.word 0xe60c2f84  ! 1: LDUB_I	ldub	[%r16 + 0x0f84], %r19
	.word 0xe29426fa  ! 1: LDUHA_I	lduha	[%r16, + 0x06fa] %asi, %r17
	brnz %r31,thr3_loop_cnt_1226
	dec %r31
	.word 0x863c2f11  ! 1: XNOR_I	xnor 	%r16, 0x0f11, %r3
	.word 0xb63c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r27
	.word 0x861c2904  ! 1: XOR_I	xor 	%r16, 0x0904, %r3
        mov 0x3f, %r31
thr3_loop_cnt_1227:
	.word 0xe4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r18
	.word 0xf04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r24
	.word 0xc6c4299c  ! 1: LDSWA_I	ldswa	[%r16, + 0x099c] %asi, %r3
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xec842f74  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f74] %asi, %r22
	.word 0xc6142318  ! 1: LDUH_I	lduh	[%r16 + 0x0318], %r3
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	.word 0xc64c258f  ! 1: LDSB_I	ldsb	[%r16 + 0x058f], %r3
	.word 0xd2dc2f70  ! 1: LDXA_I	ldxa	[%r16, + 0x0f70] %asi, %r9
	brnz %r31,thr3_loop_cnt_1227
	dec %r31
	.word 0x9a1425bb  ! 1: OR_I	or 	%r16, 0x05bb, %r13
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x42, %r31
thr3_loop_cnt_1228:
	.word 0xee4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r23
	.word 0xe8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r20
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r27
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc61422ca  ! 1: LDUH_I	lduh	[%r16 + 0x02ca], %r3
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xf68c2333  ! 1: LDUBA_I	lduba	[%r16, + 0x0333] %asi, %r27
	.word 0xc64424ac  ! 1: LDSW_I	ldsw	[%r16 + 0x04ac], %r3
	.word 0xd4d42d0c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d0c] %asi, %r10
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1228
	dec %r31
        mov 0x18, %r31
thr3_loop_cnt_1229:
	.word 0xf4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r26
	.word 0xc6942bca  ! 1: LDUHA_I	lduha	[%r16, + 0x0bca] %asi, %r3
	.word 0xf2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r25
	.word 0xc6542190  ! 1: LDSH_I	ldsh	[%r16 + 0x0190], %r3
	.word 0xfccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r30
	.word 0xc6042374  ! 1: LDUW_I	lduw	[%r16 + 0x0374], %r3
	.word 0xda4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r13
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xf6942908  ! 1: LDUHA_I	lduha	[%r16, + 0x0908] %asi, %r27
	brnz %r31,thr3_loop_cnt_1229
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x9014254e  ! 1: OR_I	or 	%r16, 0x054e, %r8
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0x8d, %r31
thr3_loop_cnt_1230:
	.word 0xc6c42974  ! 1: LDSWA_I	ldswa	[%r16, + 0x0974] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xde841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r15
	.word 0xe8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r20
	.word 0xd84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r12
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xde842214  ! 1: LDUWA_I	lduwa	[%r16, + 0x0214] %asi, %r15
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xea5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r21
	brnz %r31,thr3_loop_cnt_1230
	dec %r31
	.word 0x862c29a7  ! 1: ANDN_I	andn 	%r16, 0x09a7, %r3
        mov 0x5f, %r31
thr3_loop_cnt_1231:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf2042f80  ! 1: LDUW_I	lduw	[%r16 + 0x0f80], %r25
	.word 0xc60c2d82  ! 1: LDUB_I	ldub	[%r16 + 0x0d82], %r3
	.word 0xdcd42cce  ! 1: LDSHA_I	ldsha	[%r16, + 0x0cce] %asi, %r14
	.word 0xc6842350  ! 1: LDUWA_I	lduwa	[%r16, + 0x0350] %asi, %r3
	.word 0xfcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r30
	.word 0xce5c2688  ! 1: LDX_I	ldx	[%r16 + 0x0688], %r7
	.word 0xea0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r21
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1231
	dec %r31
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0x20, %r31
thr3_loop_cnt_1232:
	.word 0xeadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r21
	.word 0xf25c2ee8  ! 1: LDX_I	ldx	[%r16 + 0x0ee8], %r25
	.word 0xc64c2967  ! 1: LDSB_I	ldsb	[%r16 + 0x0967], %r3
	.word 0xe25421be  ! 1: LDSH_I	ldsh	[%r16 + 0x01be], %r17
	.word 0xc6cc234d  ! 1: LDSBA_I	ldsba	[%r16, + 0x034d] %asi, %r3
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6d4245c  ! 1: LDSHA_I	ldsha	[%r16, + 0x045c] %asi, %r3
	.word 0xd6c42c30  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c30] %asi, %r11
	brnz %r31,thr3_loop_cnt_1232
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x93, %r31
thr3_loop_cnt_1233:
	.word 0xc6042f78  ! 1: LDUW_I	lduw	[%r16 + 0x0f78], %r3
	.word 0xc6942fd2  ! 1: LDUHA_I	lduha	[%r16, + 0x0fd2] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc614237e  ! 1: LDUH_I	lduh	[%r16 + 0x037e], %r3
	.word 0xc6dc2be8  ! 1: LDXA_I	ldxa	[%r16, + 0x0be8] %asi, %r3
	.word 0xc68c2ae9  ! 1: LDUBA_I	lduba	[%r16, + 0x0ae9] %asi, %r3
	.word 0xf4142034  ! 1: LDUH_I	lduh	[%r16 + 0x0034], %r26
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xeecc2729  ! 1: LDSBA_I	ldsba	[%r16, + 0x0729] %asi, %r23
	brnz %r31,thr3_loop_cnt_1233
	dec %r31
	.word 0xa73c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r19
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x36, %r31
thr3_loop_cnt_1234:
	.word 0xc6d4282c  ! 1: LDSHA_I	ldsha	[%r16, + 0x082c] %asi, %r3
	.word 0xe45c2028  ! 1: LDX_I	ldx	[%r16 + 0x0028], %r18
	.word 0xda84201c  ! 1: LDUWA_I	lduwa	[%r16, + 0x001c] %asi, %r13
	.word 0xf6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r27
	.word 0xee4c2595  ! 1: LDSB_I	ldsb	[%r16 + 0x0595], %r23
	.word 0xd4442890  ! 1: LDSW_I	ldsw	[%r16 + 0x0890], %r10
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xc6142f8e  ! 1: LDUH_I	lduh	[%r16 + 0x0f8e], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1234
	dec %r31
        mov 0x3e, %r31
thr3_loop_cnt_1235:
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r18
	.word 0xc64c2371  ! 1: LDSB_I	ldsb	[%r16 + 0x0371], %r3
	.word 0xd8c428a4  ! 1: LDSWA_I	ldswa	[%r16, + 0x08a4] %asi, %r12
	.word 0xd4442f00  ! 1: LDSW_I	ldsw	[%r16 + 0x0f00], %r10
	.word 0xde8c2ee0  ! 1: LDUBA_I	lduba	[%r16, + 0x0ee0] %asi, %r15
	.word 0xdc8429d8  ! 1: LDUWA_I	lduwa	[%r16, + 0x09d8] %asi, %r14
	brnz %r31,thr3_loop_cnt_1235
	dec %r31
        mov 0x43, %r31
thr3_loop_cnt_1236:
	.word 0xc65c26f8  ! 1: LDX_I	ldx	[%r16 + 0x06f8], %r3
	.word 0xf88c279a  ! 1: LDUBA_I	lduba	[%r16, + 0x079a] %asi, %r28
	.word 0xea442d78  ! 1: LDSW_I	ldsw	[%r16 + 0x0d78], %r21
	.word 0xc6142f12  ! 1: LDUH_I	lduh	[%r16 + 0x0f12], %r3
	.word 0xe4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r18
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xda941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r13
	.word 0xc6942ab0  ! 1: LDUHA_I	lduha	[%r16, + 0x0ab0] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1236
	dec %r31
	.word 0x863c289c  ! 1: XNOR_I	xnor 	%r16, 0x089c, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0xa3, %r31
thr3_loop_cnt_1237:
	.word 0xc6d4284c  ! 1: LDSHA_I	ldsha	[%r16, + 0x084c] %asi, %r3
	.word 0xc6542e14  ! 1: LDSH_I	ldsh	[%r16 + 0x0e14], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf60c2125  ! 1: LDUB_I	ldub	[%r16 + 0x0125], %r27
	.word 0xd8c42d78  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d78] %asi, %r12
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6042a74  ! 1: LDUW_I	lduw	[%r16 + 0x0a74], %r3
	.word 0xe4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r18
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1237
	dec %r31
	.word 0xa53c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r18
        mov 0x69, %r31
thr3_loop_cnt_1238:
	.word 0xc6942e66  ! 1: LDUHA_I	lduha	[%r16, + 0x0e66] %asi, %r3
	.word 0xf2dc2ff0  ! 1: LDXA_I	ldxa	[%r16, + 0x0ff0] %asi, %r25
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xe4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r18
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xe2c420a4  ! 1: LDSWA_I	ldswa	[%r16, + 0x00a4] %asi, %r17
	.word 0xdc5c2560  ! 1: LDX_I	ldx	[%r16 + 0x0560], %r14
	.word 0xe8142b1e  ! 1: LDUH_I	lduh	[%r16 + 0x0b1e], %r20
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xdacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r13
	brnz %r31,thr3_loop_cnt_1238
	dec %r31
	.word 0x9e340002  ! 1: ORN_R	orn 	%r16, %r2, %r15
        mov 0x25, %r31
thr3_loop_cnt_1239:
	.word 0xf00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r24
	.word 0xfa442d88  ! 1: LDSW_I	ldsw	[%r16 + 0x0d88], %r29
	.word 0xc6042330  ! 1: LDUW_I	lduw	[%r16 + 0x0330], %r3
	.word 0xfc54213a  ! 1: LDSH_I	ldsh	[%r16 + 0x013a], %r30
	.word 0xc6142c74  ! 1: LDUH_I	lduh	[%r16 + 0x0c74], %r3
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	.word 0xf45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r26
	.word 0xfc8c203d  ! 1: LDUBA_I	lduba	[%r16, + 0x003d] %asi, %r30
	brnz %r31,thr3_loop_cnt_1239
	dec %r31
	.word 0xbd3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r30
	.word 0xa33c1002  ! 1: SRAX_R	srax	%r16, %r2, %r17
	.word 0x9e442030  ! 1: ADDC_I	addc 	%r16, 0x0030, %r15
	.word 0x8634288f  ! 1: ORN_I	orn 	%r16, 0x088f, %r3
        mov 0xa4, %r31
thr3_loop_cnt_1240:
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	.word 0xc6442854  ! 1: LDSW_I	ldsw	[%r16 + 0x0854], %r3
	.word 0xe6dc2f68  ! 1: LDXA_I	ldxa	[%r16, + 0x0f68] %asi, %r19
	.word 0xd4cc251d  ! 1: LDSBA_I	ldsba	[%r16, + 0x051d] %asi, %r10
	.word 0xc64c2827  ! 1: LDSB_I	ldsb	[%r16 + 0x0827], %r3
	.word 0xc68c2a2e  ! 1: LDUBA_I	lduba	[%r16, + 0x0a2e] %asi, %r3
	.word 0xde442dc0  ! 1: LDSW_I	ldsw	[%r16 + 0x0dc0], %r15
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xee8c2d67  ! 1: LDUBA_I	lduba	[%r16, + 0x0d67] %asi, %r23
	.word 0xc69421d6  ! 1: LDUHA_I	lduha	[%r16, + 0x01d6] %asi, %r3
	.word 0xc64428fc  ! 1: LDSW_I	ldsw	[%r16 + 0x08fc], %r3
	brnz %r31,thr3_loop_cnt_1240
	dec %r31
	.word 0x86342304  ! 1: SUBC_I	orn 	%r16, 0x0304, %r3
        mov 0xb4, %r31
thr3_loop_cnt_1241:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xfc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r30
	.word 0xe2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r17
	.word 0xf2cc2d15  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d15] %asi, %r25
	.word 0xc6142efc  ! 1: LDUH_I	lduh	[%r16 + 0x0efc], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xdc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r14
	.word 0xd80421d8  ! 1: LDUW_I	lduw	[%r16 + 0x01d8], %r12
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc69424f4  ! 1: LDUHA_I	lduha	[%r16, + 0x04f4] %asi, %r3
	.word 0xe4442694  ! 1: LDSW_I	ldsw	[%r16 + 0x0694], %r18
	brnz %r31,thr3_loop_cnt_1241
	dec %r31
        mov 0x8c, %r31
thr3_loop_cnt_1242:
	.word 0xc6042270  ! 1: LDUW_I	lduw	[%r16 + 0x0270], %r3
	.word 0xf2442b64  ! 1: LDSW_I	ldsw	[%r16 + 0x0b64], %r25
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xee941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r23
	.word 0xc6d4298a  ! 1: LDSHA_I	ldsha	[%r16, + 0x098a] %asi, %r3
	.word 0xec8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r22
	.word 0xc6142c5e  ! 1: LDUH_I	lduh	[%r16 + 0x0c5e], %r3
	.word 0xc6c42a88  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a88] %asi, %r3
	.word 0xd644278c  ! 1: LDSW_I	ldsw	[%r16 + 0x078c], %r11
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1242
	dec %r31
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x86342acf  ! 1: ORN_I	orn 	%r16, 0x0acf, %r3
        mov 0x6c, %r31
thr3_loop_cnt_1243:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc60c2985  ! 1: LDUB_I	ldub	[%r16 + 0x0985], %r3
	.word 0xec0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r22
	.word 0xd44428c8  ! 1: LDSW_I	ldsw	[%r16 + 0x08c8], %r10
	.word 0xfa14210c  ! 1: LDUH_I	lduh	[%r16 + 0x010c], %r29
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6942550  ! 1: LDUHA_I	lduha	[%r16, + 0x0550] %asi, %r3
	.word 0xd8542fce  ! 1: LDSH_I	ldsh	[%r16 + 0x0fce], %r12
	brnz %r31,thr3_loop_cnt_1243
	dec %r31
	.word 0xaf3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r23
	.word 0xaf2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r23
	.word 0x92340002  ! 1: ORN_R	orn 	%r16, %r2, %r9
        mov 0x23, %r31
thr3_loop_cnt_1244:
	.word 0xe80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r20
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xec5c2448  ! 1: LDX_I	ldx	[%r16 + 0x0448], %r22
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc60427b4  ! 1: LDUW_I	lduw	[%r16 + 0x07b4], %r3
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xd0c429d8  ! 1: LDSWA_I	ldswa	[%r16, + 0x09d8] %asi, %r8
	.word 0xec842900  ! 1: LDUWA_I	lduwa	[%r16, + 0x0900] %asi, %r22
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xd48424d0  ! 1: LDUWA_I	lduwa	[%r16, + 0x04d0] %asi, %r10
	brnz %r31,thr3_loop_cnt_1244
	dec %r31
	.word 0x8614241c  ! 1: OR_I	or 	%r16, 0x041c, %r3
	.word 0xb9340002  ! 1: SRL_R	srl 	%r16, %r2, %r28
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x8634236c  ! 1: ORN_I	orn 	%r16, 0x036c, %r3
        mov 0x42, %r31
thr3_loop_cnt_1245:
	.word 0xea0c2d05  ! 1: LDUB_I	ldub	[%r16 + 0x0d05], %r21
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6842f3c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f3c] %asi, %r3
	.word 0xd45c2850  ! 1: LDX_I	ldx	[%r16 + 0x0850], %r10
	.word 0xc64c2ee3  ! 1: LDSB_I	ldsb	[%r16 + 0x0ee3], %r3
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xfc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r30
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1245
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0xc7, %r31
thr3_loop_cnt_1246:
	.word 0xde4c2068  ! 1: LDSB_I	ldsb	[%r16 + 0x0068], %r15
	.word 0xf25c2da0  ! 1: LDX_I	ldx	[%r16 + 0x0da0], %r25
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xce4c2aaf  ! 1: LDSB_I	ldsb	[%r16 + 0x0aaf], %r7
	.word 0xcccc2282  ! 1: LDSBA_I	ldsba	[%r16, + 0x0282] %asi, %r6
	.word 0xea842d3c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d3c] %asi, %r21
	brnz %r31,thr3_loop_cnt_1246
	dec %r31
	.word 0xb43c266f  ! 1: XNOR_I	xnor 	%r16, 0x066f, %r26
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0x25, %r31
thr3_loop_cnt_1247:
	.word 0xccd423ea  ! 1: LDSHA_I	ldsha	[%r16, + 0x03ea] %asi, %r6
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r25
	.word 0xf6142392  ! 1: LDUH_I	lduh	[%r16 + 0x0392], %r27
	.word 0xd41425b4  ! 1: LDUH_I	lduh	[%r16 + 0x05b4], %r10
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xf44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r26
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	brnz %r31,thr3_loop_cnt_1247
	dec %r31
	.word 0x8c34287f  ! 1: ORN_I	orn 	%r16, 0x087f, %r6
        mov 0x77, %r31
thr3_loop_cnt_1248:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf2042f5c  ! 1: LDUW_I	lduw	[%r16 + 0x0f5c], %r25
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc65c2d80  ! 1: LDX_I	ldx	[%r16 + 0x0d80], %r3
	.word 0xfcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r30
	.word 0xf4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r26
	.word 0xc6d42a62  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a62] %asi, %r3
	.word 0xd4142576  ! 1: LDUH_I	lduh	[%r16 + 0x0576], %r10
	.word 0xe894261a  ! 1: LDUHA_I	lduha	[%r16, + 0x061a] %asi, %r20
	.word 0xec44253c  ! 1: LDSW_I	ldsw	[%r16 + 0x053c], %r22
	brnz %r31,thr3_loop_cnt_1248
	dec %r31
	.word 0x993c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r12
	.word 0x861c2f33  ! 1: XOR_I	xor 	%r16, 0x0f33, %r3
        mov 0x77, %r31
thr3_loop_cnt_1249:
	.word 0xd0cc26b6  ! 1: LDSBA_I	ldsba	[%r16, + 0x06b6] %asi, %r8
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc61426d2  ! 1: LDUH_I	lduh	[%r16 + 0x06d2], %r3
	.word 0xc65c2eb8  ! 1: LDX_I	ldx	[%r16 + 0x0eb8], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6942d58  ! 1: LDUHA_I	lduha	[%r16, + 0x0d58] %asi, %r3
	brnz %r31,thr3_loop_cnt_1249
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0xb42c2ae2  ! 1: ANDN_I	andn 	%r16, 0x0ae2, %r26
	.word 0xa73c0002  ! 1: SRA_R	sra 	%r16, %r2, %r19
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0x44, %r31
thr3_loop_cnt_1250:
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc64c2842  ! 1: LDSB_I	ldsb	[%r16 + 0x0842], %r3
	.word 0xf28c25a1  ! 1: LDUBA_I	lduba	[%r16, + 0x05a1] %asi, %r25
	.word 0xc64c2668  ! 1: LDSB_I	ldsb	[%r16 + 0x0668], %r3
	.word 0xd04c27b5  ! 1: LDSB_I	ldsb	[%r16 + 0x07b5], %r8
	.word 0xc6d42f86  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f86] %asi, %r3
	.word 0xf8cc22ee  ! 1: LDSBA_I	ldsba	[%r16, + 0x02ee] %asi, %r28
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xda542088  ! 1: LDSH_I	ldsh	[%r16 + 0x0088], %r13
	brnz %r31,thr3_loop_cnt_1250
	dec %r31
	.word 0x86442372  ! 1: ADDC_I	addc 	%r16, 0x0372, %r3
	.word 0x993c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r12
	.word 0x992c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r12
        mov 0x12, %r31
thr3_loop_cnt_1251:
	.word 0xe88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r20
	.word 0xdedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r15
	.word 0xdedc2950  ! 1: LDXA_I	ldxa	[%r16, + 0x0950] %asi, %r15
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf6142f96  ! 1: LDUH_I	lduh	[%r16 + 0x0f96], %r27
	.word 0xe40422d0  ! 1: LDUW_I	lduw	[%r16 + 0x02d0], %r18
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xc6442148  ! 1: LDSW_I	ldsw	[%r16 + 0x0148], %r3
	brnz %r31,thr3_loop_cnt_1251
	dec %r31
	.word 0xa224216e  ! 1: SUB_I	sub 	%r16, 0x016e, %r17
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0xa2, %r31
thr3_loop_cnt_1252:
	.word 0xd0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r8
	.word 0xc65c2e28  ! 1: LDX_I	ldx	[%r16 + 0x0e28], %r3
	.word 0xdc9429b8  ! 1: LDUHA_I	lduha	[%r16, + 0x09b8] %asi, %r14
	.word 0xf4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r26
	.word 0xfa442124  ! 1: LDSW_I	ldsw	[%r16 + 0x0124], %r29
	.word 0xd28c2821  ! 1: LDUBA_I	lduba	[%r16, + 0x0821] %asi, %r9
	.word 0xc68427f8  ! 1: LDUWA_I	lduwa	[%r16, + 0x07f8] %asi, %r3
	.word 0xf85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r28
	.word 0xf0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r24
	.word 0xc6dc2a10  ! 1: LDXA_I	ldxa	[%r16, + 0x0a10] %asi, %r3
	.word 0xdcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r14
	.word 0xc68c25ca  ! 1: LDUBA_I	lduba	[%r16, + 0x05ca] %asi, %r3
	brnz %r31,thr3_loop_cnt_1252
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x97340002  ! 1: SRL_R	srl 	%r16, %r2, %r11
        mov 0x16, %r31
thr3_loop_cnt_1253:
	.word 0xc69420ae  ! 1: LDUHA_I	lduha	[%r16, + 0x00ae] %asi, %r3
	.word 0xc6c42284  ! 1: LDSWA_I	ldswa	[%r16, + 0x0284] %asi, %r3
	.word 0xc6842928  ! 1: LDUWA_I	lduwa	[%r16, + 0x0928] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xea842964  ! 1: LDUWA_I	lduwa	[%r16, + 0x0964] %asi, %r21
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc60c281a  ! 1: LDUB_I	ldub	[%r16 + 0x081a], %r3
	.word 0xfa942ac6  ! 1: LDUHA_I	lduha	[%r16, + 0x0ac6] %asi, %r29
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	brnz %r31,thr3_loop_cnt_1253
	dec %r31
        mov 0x8c, %r31
thr3_loop_cnt_1254:
	.word 0xc6dc2430  ! 1: LDXA_I	ldxa	[%r16, + 0x0430] %asi, %r3
	.word 0xf4d42ff6  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ff6] %asi, %r26
	.word 0xc60427c8  ! 1: LDUW_I	lduw	[%r16 + 0x07c8], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc68c2473  ! 1: LDUBA_I	lduba	[%r16, + 0x0473] %asi, %r3
	.word 0xe4d4239e  ! 1: LDSHA_I	ldsha	[%r16, + 0x039e] %asi, %r18
	.word 0xc6d42cf4  ! 1: LDSHA_I	ldsha	[%r16, + 0x0cf4] %asi, %r3
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xe4cc296c  ! 1: LDSBA_I	ldsba	[%r16, + 0x096c] %asi, %r18
	brnz %r31,thr3_loop_cnt_1254
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x84, %r31
thr3_loop_cnt_1255:
	.word 0xde942718  ! 1: LDUHA_I	lduha	[%r16, + 0x0718] %asi, %r15
	.word 0xc6842e78  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e78] %asi, %r3
	.word 0xc6c42324  ! 1: LDSWA_I	ldswa	[%r16, + 0x0324] %asi, %r3
	.word 0xda942a46  ! 1: LDUHA_I	lduha	[%r16, + 0x0a46] %asi, %r13
	.word 0xe8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r20
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r26
	brnz %r31,thr3_loop_cnt_1255
	dec %r31
	.word 0x95342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r10
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0x60, %r31
thr3_loop_cnt_1256:
	.word 0xd29423d6  ! 1: LDUHA_I	lduha	[%r16, + 0x03d6] %asi, %r9
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc64c2d75  ! 1: LDSB_I	ldsb	[%r16 + 0x0d75], %r3
	.word 0xd4c421e0  ! 1: LDSWA_I	ldswa	[%r16, + 0x01e0] %asi, %r10
	.word 0xc6dc22f0  ! 1: LDXA_I	ldxa	[%r16, + 0x02f0] %asi, %r3
	.word 0xc68c2324  ! 1: LDUBA_I	lduba	[%r16, + 0x0324] %asi, %r3
	.word 0xfcd42bb0  ! 1: LDSHA_I	ldsha	[%r16, + 0x0bb0] %asi, %r30
	.word 0xec0c20c3  ! 1: LDUB_I	ldub	[%r16 + 0x00c3], %r22
	.word 0xc6942c20  ! 1: LDUHA_I	lduha	[%r16, + 0x0c20] %asi, %r3
	brnz %r31,thr3_loop_cnt_1256
	dec %r31
	.word 0xaa14211c  ! 1: OR_I	or 	%r16, 0x011c, %r21
	.word 0x933c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r9
        mov 0x3f, %r31
thr3_loop_cnt_1257:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xdc842170  ! 1: LDUWA_I	lduwa	[%r16, + 0x0170] %asi, %r14
	.word 0xc68c2f41  ! 1: LDUBA_I	lduba	[%r16, + 0x0f41] %asi, %r3
	.word 0xcc5c28e8  ! 1: LDX_I	ldx	[%r16 + 0x08e8], %r6
	.word 0xda941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r13
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe6542ad2  ! 1: LDSH_I	ldsh	[%r16 + 0x0ad2], %r19
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	.word 0xc69422fa  ! 1: LDUHA_I	lduha	[%r16, + 0x02fa] %asi, %r3
	brnz %r31,thr3_loop_cnt_1257
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x8644272e  ! 1: ADDC_I	addc 	%r16, 0x072e, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0xa20c0002  ! 1: AND_R	and 	%r16, %r2, %r17
        mov 0x26, %r31
thr3_loop_cnt_1258:
	.word 0xc60c2cb1  ! 1: LDUB_I	ldub	[%r16 + 0x0cb1], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xda841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r13
	.word 0xd2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r9
	.word 0xc6842b3c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b3c] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	.word 0xd6442460  ! 1: LDSW_I	ldsw	[%r16 + 0x0460], %r11
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xc69425d4  ! 1: LDUHA_I	lduha	[%r16, + 0x05d4] %asi, %r3
	.word 0xd6dc29d8  ! 1: LDXA_I	ldxa	[%r16, + 0x09d8] %asi, %r11
	.word 0xdcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r14
	brnz %r31,thr3_loop_cnt_1258
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0xa3341002  ! 1: SRLX_R	srlx	%r16, %r2, %r17
	.word 0x992c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r12
	.word 0x86342c38  ! 1: ORN_I	orn 	%r16, 0x0c38, %r3
        mov 0x54, %r31
thr3_loop_cnt_1259:
	.word 0xd85c2bb0  ! 1: LDX_I	ldx	[%r16 + 0x0bb0], %r12
	.word 0xde8c2a98  ! 1: LDUBA_I	lduba	[%r16, + 0x0a98] %asi, %r15
	.word 0xc614211c  ! 1: LDUH_I	lduh	[%r16 + 0x011c], %r3
	.word 0xf8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r28
	.word 0xce042528  ! 1: LDUW_I	lduw	[%r16 + 0x0528], %r7
	.word 0xe6542ef2  ! 1: LDSH_I	ldsh	[%r16 + 0x0ef2], %r19
	.word 0xc60c201b  ! 1: LDUB_I	ldub	[%r16 + 0x001b], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc68c252d  ! 1: LDUBA_I	lduba	[%r16, + 0x052d] %asi, %r3
	.word 0xfc142380  ! 1: LDUH_I	lduh	[%r16 + 0x0380], %r30
	.word 0xc65c2418  ! 1: LDX_I	ldx	[%r16 + 0x0418], %r3
	brnz %r31,thr3_loop_cnt_1259
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x8f3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r7
	.word 0x952c0002  ! 1: SLL_R	sll 	%r16, %r2, %r10
        mov 0x6c, %r31
thr3_loop_cnt_1260:
	.word 0xd20c2398  ! 1: LDUB_I	ldub	[%r16 + 0x0398], %r9
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xfc84227c  ! 1: LDUWA_I	lduwa	[%r16, + 0x027c] %asi, %r30
	.word 0xc65c2e20  ! 1: LDX_I	ldx	[%r16 + 0x0e20], %r3
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	.word 0xd45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r10
	.word 0xe4542fac  ! 1: LDSH_I	ldsh	[%r16 + 0x0fac], %r18
	.word 0xd6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r11
	.word 0xe6c427c8  ! 1: LDSWA_I	ldswa	[%r16, + 0x07c8] %asi, %r19
	.word 0xf44429b0  ! 1: LDSW_I	ldsw	[%r16 + 0x09b0], %r26
	.word 0xc68c2631  ! 1: LDUBA_I	lduba	[%r16, + 0x0631] %asi, %r3
	.word 0xf6dc2a08  ! 1: LDXA_I	ldxa	[%r16, + 0x0a08] %asi, %r27
	brnz %r31,thr3_loop_cnt_1260
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0xa93c0002  ! 1: SRA_R	sra 	%r16, %r2, %r20
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x932c0002  ! 1: SLL_R	sll 	%r16, %r2, %r9
        mov 0x88, %r31
thr3_loop_cnt_1261:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xdc8c2029  ! 1: LDUBA_I	lduba	[%r16, + 0x0029] %asi, %r14
	.word 0xf24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r25
	.word 0xc6042490  ! 1: LDUW_I	lduw	[%r16 + 0x0490], %r3
	.word 0xce8c2a43  ! 1: LDUBA_I	lduba	[%r16, + 0x0a43] %asi, %r7
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xe4142400  ! 1: LDUH_I	lduh	[%r16 + 0x0400], %r18
	.word 0xd48c2a35  ! 1: LDUBA_I	lduba	[%r16, + 0x0a35] %asi, %r10
	.word 0xda5c23b0  ! 1: LDX_I	ldx	[%r16 + 0x03b0], %r13
	.word 0xc65c2388  ! 1: LDX_I	ldx	[%r16 + 0x0388], %r3
	brnz %r31,thr3_loop_cnt_1261
	dec %r31
	.word 0x92042d04  ! 1: ADD_I	add 	%r16, 0x0d04, %r9
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0xb53c1002  ! 1: SRAX_R	srax	%r16, %r2, %r26
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0x3f, %r31
thr3_loop_cnt_1262:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xeec423dc  ! 1: LDSWA_I	ldswa	[%r16, + 0x03dc] %asi, %r23
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc69422d4  ! 1: LDUHA_I	lduha	[%r16, + 0x02d4] %asi, %r3
	.word 0xc6cc287f  ! 1: LDSBA_I	ldsba	[%r16, + 0x087f] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc694217e  ! 1: LDUHA_I	lduha	[%r16, + 0x017e] %asi, %r3
	.word 0xc68426b8  ! 1: LDUWA_I	lduwa	[%r16, + 0x06b8] %asi, %r3
	brnz %r31,thr3_loop_cnt_1262
	dec %r31
	.word 0x941c2259  ! 1: XOR_I	xor 	%r16, 0x0259, %r10
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x8614229e  ! 1: OR_I	or 	%r16, 0x029e, %r3
	.word 0x8d2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r6
        mov 0xb9, %r31
thr3_loop_cnt_1263:
	.word 0xfa942ec6  ! 1: LDUHA_I	lduha	[%r16, + 0x0ec6] %asi, %r29
	.word 0xead42866  ! 1: LDSHA_I	ldsha	[%r16, + 0x0866] %asi, %r21
	.word 0xc6442ff8  ! 1: LDSW_I	ldsw	[%r16 + 0x0ff8], %r3
	.word 0xf0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r24
	.word 0xcc0428dc  ! 1: LDUW_I	lduw	[%r16 + 0x08dc], %r6
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xfa040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r29
	.word 0xeacc2614  ! 1: LDSBA_I	ldsba	[%r16, + 0x0614] %asi, %r21
	.word 0xc64c2484  ! 1: LDSB_I	ldsb	[%r16 + 0x0484], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xdc4421ec  ! 1: LDSW_I	ldsw	[%r16 + 0x01ec], %r14
	brnz %r31,thr3_loop_cnt_1263
	dec %r31
	.word 0xb92c0002  ! 1: SLL_R	sll 	%r16, %r2, %r28
	.word 0xb62c227c  ! 1: ANDN_I	andn 	%r16, 0x027c, %r27
        mov 0xb3, %r31
thr3_loop_cnt_1264:
	.word 0xfc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r30
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf04c25ca  ! 1: LDSB_I	ldsb	[%r16 + 0x05ca], %r24
	.word 0xc6142be6  ! 1: LDUH_I	lduh	[%r16 + 0x0be6], %r3
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r26
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2d60  ! 1: LDXA_I	ldxa	[%r16, + 0x0d60] %asi, %r3
	brnz %r31,thr3_loop_cnt_1264
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0x5c, %r31
thr3_loop_cnt_1265:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd45c2230  ! 1: LDX_I	ldx	[%r16 + 0x0230], %r10
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2540  ! 1: LDXA_I	ldxa	[%r16, + 0x0540] %asi, %r3
	.word 0xc6d42b28  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b28] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r24
	.word 0xda542366  ! 1: LDSH_I	ldsh	[%r16 + 0x0366], %r13
	brnz %r31,thr3_loop_cnt_1265
	dec %r31
        mov 0x7e, %r31
thr3_loop_cnt_1266:
	.word 0xda9426f2  ! 1: LDUHA_I	lduha	[%r16, + 0x06f2] %asi, %r13
	.word 0xd8c42800  ! 1: LDSWA_I	ldswa	[%r16, + 0x0800] %asi, %r12
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc68c2c48  ! 1: LDUBA_I	lduba	[%r16, + 0x0c48] %asi, %r3
	.word 0xe2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r17
	.word 0xc6842ac0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ac0] %asi, %r3
	.word 0xc60c2612  ! 1: LDUB_I	ldub	[%r16 + 0x0612], %r3
	brnz %r31,thr3_loop_cnt_1266
	dec %r31
        mov 0x1d, %r31
thr3_loop_cnt_1267:
	.word 0xc65c2148  ! 1: LDX_I	ldx	[%r16 + 0x0148], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xfa4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r29
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf2d4299c  ! 1: LDSHA_I	ldsha	[%r16, + 0x099c] %asi, %r25
	.word 0xf4842cb4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0cb4] %asi, %r26
	.word 0xc6142302  ! 1: LDUH_I	lduh	[%r16 + 0x0302], %r3
	.word 0xd05c29c0  ! 1: LDX_I	ldx	[%r16 + 0x09c0], %r8
	.word 0xee941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r23
	.word 0xdc442024  ! 1: LDSW_I	ldsw	[%r16 + 0x0024], %r14
	brnz %r31,thr3_loop_cnt_1267
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x933c1002  ! 1: SRAX_R	srax	%r16, %r2, %r9
	.word 0xba340002  ! 1: ORN_R	orn 	%r16, %r2, %r29
        mov 0x2d, %r31
thr3_loop_cnt_1268:
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	.word 0xde442378  ! 1: LDSW_I	ldsw	[%r16 + 0x0378], %r15
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xf6dc2938  ! 1: LDXA_I	ldxa	[%r16, + 0x0938] %asi, %r27
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xc69421fe  ! 1: LDUHA_I	lduha	[%r16, + 0x01fe] %asi, %r3
	.word 0xe60c2064  ! 1: LDUB_I	ldub	[%r16 + 0x0064], %r19
	.word 0xc6142410  ! 1: LDUH_I	lduh	[%r16 + 0x0410], %r3
	.word 0xf84c2424  ! 1: LDSB_I	ldsb	[%r16 + 0x0424], %r28
	.word 0xc68421c8  ! 1: LDUWA_I	lduwa	[%r16, + 0x01c8] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1268
	dec %r31
	.word 0x8e0423c4  ! 1: ADD_I	add 	%r16, 0x03c4, %r7
        mov 0x39, %r31
thr3_loop_cnt_1269:
	.word 0xda5c2df8  ! 1: LDX_I	ldx	[%r16 + 0x0df8], %r13
	.word 0xf28c2978  ! 1: LDUBA_I	lduba	[%r16, + 0x0978] %asi, %r25
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xc6cc2f6b  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f6b] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd4942a90  ! 1: LDUHA_I	lduha	[%r16, + 0x0a90] %asi, %r10
	.word 0xd4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r10
	.word 0xd2d4275a  ! 1: LDSHA_I	ldsha	[%r16, + 0x075a] %asi, %r9
	.word 0xea8c2820  ! 1: LDUBA_I	lduba	[%r16, + 0x0820] %asi, %r21
	.word 0xc61425de  ! 1: LDUH_I	lduh	[%r16 + 0x05de], %r3
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	brnz %r31,thr3_loop_cnt_1269
	dec %r31
        mov 0x7d, %r31
thr3_loop_cnt_1270:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe8c425bc  ! 1: LDSWA_I	ldswa	[%r16, + 0x05bc] %asi, %r20
	.word 0xe25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r17
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf4c421a8  ! 1: LDSWA_I	ldswa	[%r16, + 0x01a8] %asi, %r26
	.word 0xec040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r22
	.word 0xf6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r27
	brnz %r31,thr3_loop_cnt_1270
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x983c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r12
	.word 0xaf2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r23
        mov 0x80, %r31
thr3_loop_cnt_1271:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xea5428a4  ! 1: LDSH_I	ldsh	[%r16 + 0x08a4], %r21
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc65c2c28  ! 1: LDX_I	ldx	[%r16 + 0x0c28], %r3
	.word 0xcc4c2e20  ! 1: LDSB_I	ldsb	[%r16 + 0x0e20], %r6
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	brnz %r31,thr3_loop_cnt_1271
	dec %r31
	.word 0xb12c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r24
        mov 0xa0, %r31
thr3_loop_cnt_1272:
	.word 0xc6cc20c3  ! 1: LDSBA_I	ldsba	[%r16, + 0x00c3] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xeac422b4  ! 1: LDSWA_I	ldswa	[%r16, + 0x02b4] %asi, %r21
	.word 0xf24c24d5  ! 1: LDSB_I	ldsb	[%r16 + 0x04d5], %r25
	.word 0xc6c42494  ! 1: LDSWA_I	ldswa	[%r16, + 0x0494] %asi, %r3
	.word 0xc68c28cb  ! 1: LDUBA_I	lduba	[%r16, + 0x08cb] %asi, %r3
	.word 0xd6dc28c0  ! 1: LDXA_I	ldxa	[%r16, + 0x08c0] %asi, %r11
	.word 0xfad42c0e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c0e] %asi, %r29
	brnz %r31,thr3_loop_cnt_1272
	dec %r31
	.word 0xb20c0002  ! 1: AND_R	and 	%r16, %r2, %r25
	.word 0xaa0422fe  ! 1: ADD_I	add 	%r16, 0x02fe, %r21
	.word 0xb52c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r26
        mov 0xbc, %r31
thr3_loop_cnt_1273:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6dc2010  ! 1: LDXA_I	ldxa	[%r16, + 0x0010] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xfad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r29
	.word 0xce5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r7
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xec442704  ! 1: LDSW_I	ldsw	[%r16 + 0x0704], %r22
	.word 0xea440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r21
	.word 0xc6d42086  ! 1: LDSHA_I	ldsha	[%r16, + 0x0086] %asi, %r3
	brnz %r31,thr3_loop_cnt_1273
	dec %r31
	.word 0x861c2165  ! 1: XOR_I	xor 	%r16, 0x0165, %r3
	.word 0x9e2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r15
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0xae, %r31
thr3_loop_cnt_1274:
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xc60424bc  ! 1: LDUW_I	lduw	[%r16 + 0x04bc], %r3
	.word 0xf4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r26
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd4cc225f  ! 1: LDSBA_I	ldsba	[%r16, + 0x025f] %asi, %r10
	.word 0xc65428ae  ! 1: LDSH_I	ldsh	[%r16 + 0x08ae], %r3
	.word 0xc68423a0  ! 1: LDUWA_I	lduwa	[%r16, + 0x03a0] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1274
	dec %r31
	.word 0xa2040002  ! 1: ADD_R	add 	%r16, %r2, %r17
	.word 0xaa442d0d  ! 1: ADDC_I	addc 	%r16, 0x0d0d, %r21
        mov 0x21, %r31
thr3_loop_cnt_1275:
	.word 0xfc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r30
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xce8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r7
	.word 0xc6842a18  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a18] %asi, %r3
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xf4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r26
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xda5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r13
	brnz %r31,thr3_loop_cnt_1275
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0xb32c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r25
	.word 0x8e2c2141  ! 1: ANDN_I	andn 	%r16, 0x0141, %r7
	.word 0x9e2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r15
        mov 0xc5, %r31
thr3_loop_cnt_1276:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6142ab0  ! 1: LDUH_I	lduh	[%r16 + 0x0ab0], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc694246a  ! 1: LDUHA_I	lduha	[%r16, + 0x046a] %asi, %r3
	.word 0xc6142ab6  ! 1: LDUH_I	lduh	[%r16 + 0x0ab6], %r3
	.word 0xd0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r8
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xda140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r13
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1276
	dec %r31
	.word 0xa5342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r18
	.word 0xae3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r23
        mov 0xa8, %r31
thr3_loop_cnt_1277:
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xeec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r23
	.word 0xc6cc231f  ! 1: LDSBA_I	ldsba	[%r16, + 0x031f] %asi, %r3
	.word 0xc6d42d78  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d78] %asi, %r3
	.word 0xf85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r28
	.word 0xccc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r6
	.word 0xe84421c8  ! 1: LDSW_I	ldsw	[%r16 + 0x01c8], %r20
	.word 0xc60429f8  ! 1: LDUW_I	lduw	[%r16 + 0x09f8], %r3
	.word 0xee540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r23
	.word 0xda8c2240  ! 1: LDUBA_I	lduba	[%r16, + 0x0240] %asi, %r13
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xc65c28f8  ! 1: LDX_I	ldx	[%r16 + 0x08f8], %r3
	brnz %r31,thr3_loop_cnt_1277
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x861c20ed  ! 1: XOR_I	xor 	%r16, 0x00ed, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0x7, %r31
thr3_loop_cnt_1278:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc65c2d08  ! 1: LDX_I	ldx	[%r16 + 0x0d08], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xfccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r30
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	.word 0xf4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r26
	.word 0xc68c2fde  ! 1: LDUBA_I	lduba	[%r16, + 0x0fde] %asi, %r3
	.word 0xf00422c8  ! 1: LDUW_I	lduw	[%r16 + 0x02c8], %r24
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf84423ec  ! 1: LDSW_I	ldsw	[%r16 + 0x03ec], %r28
	.word 0xced426a2  ! 1: LDSHA_I	ldsha	[%r16, + 0x06a2] %asi, %r7
	brnz %r31,thr3_loop_cnt_1278
	dec %r31
        mov 0x1e, %r31
thr3_loop_cnt_1279:
	.word 0xc6cc2b3c  ! 1: LDSBA_I	ldsba	[%