// Modified by Princeton University on June 9th, 2015
/*
* ========== Copyright Header Begin ==========================================
* 
* OpenSPARC T1 Processor File: tlu_asi_access_mt_1_rand_25_s2.s
* Copyright (c) 2006 Sun Microsystems, Inc.  All Rights Reserved.
* DO NOT ALTER OR REMOVE COPYRIGHT NOTICES.
* 
* The above named program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License version 2 as published by the Free Software Foundation.
* 
* The above named program is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
* 
* You should have received a copy of the GNU General Public
* License along with this work; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
* 
* ========== Copyright Header End ============================================
*/
/*
********************************************************************************
   random seed:	204283889
   Jal tlu_asi_access_mt_1.j:	
********************************************************************************/



#define PCONTEXT	0x10
#define SCONTEXT	0x10

#define MAIN_PAGE_NUCLEUS_ALSO
#define MAIN_PAGE_HV_ALSO

#define ALL_MY_INTR_HANDLERS
#include "my_intr_handlers.s"
#include "my_trap_handlers.s"
#include "tlu_custom_trap_handlers.s"

#include "enable_traps.h"
#include "boot.s"

.text
.global main

main:

	ta 	%icc, T_CHANGE_HPRIV
	mov	0x123, %g1
	wr	%g0, 0x20, %asi
	stxa	%g1, [0x00] %asi
	stxa	%g1, [0x08] %asi
	stxa	%g1, [0x10] %asi
	stxa	%g1, [0x18] %asi
	stxa	%g1, [0x20] %asi
	stxa	%g1, [0x28] %asi
	stxa	%g1, [0x30] %asi
	stxa	%g1, [0x38] %asi
	ta 	%icc, T_CHANGE_NONHPRIV

! Register init code

	setx 0xa31777b8000001ea, %g1, %g0
	setx 0x7e3ade2b000062fb, %g1, %g1
	setx 0x711d4f9400004178, %g1, %g2
	setx 0x2a2f09380000821e, %g1, %g3
	setx 0x67bcafe8000023b6, %g1, %g4
	setx 0x0f8d0f930000e07b, %g1, %g5
	setx 0xaf1ce67300002160, %g1, %g6
	setx 0xdc9683ac0000a27a, %g1, %g7
	setx 0xeb33a753000020e3, %g1, %r16
	setx 0xbcd7308b0000630d, %g1, %r17
	setx 0x4d4377e2000041cd, %g1, %r18
	setx 0x0f4d483f0000c041, %g1, %r19
	setx 0x927f8b670000e08e, %g1, %r20
	setx 0x670c6df10000c22c, %g1, %r21
	setx 0x6005a9720000a262, %g1, %r22
	setx 0x78d206f3000023a3, %g1, %r23
	setx 0x8f29adac00006227, %g1, %r24
	setx 0xe141576c0000e35a, %g1, %r25
	setx 0x405c45a60000c301, %g1, %r26
	setx 0xbc4e4e090000a293, %g1, %r27
	setx 0xe4ea54d8000082d0, %g1, %r28
	setx 0xf43c4841000000d3, %g1, %r29
	setx 0x3dc6826100004392, %g1, %r30
	setx 0xd81023a60000832e, %g1, %r31
	save
	setx 0xfa84887e000023a2, %g1, %r16
	setx 0x431581a20000006a, %g1, %r17
	setx 0xd3175b38000022a6, %g1, %r18
	setx 0xf78442710000c2e1, %g1, %r19
	setx 0xccc636d5000001d9, %g1, %r20
	setx 0x1e36086c0000632e, %g1, %r21
	setx 0x1e67ad7d00006135, %g1, %r22
	setx 0x9ec64cd10000417c, %g1, %r23
	setx 0x0c6de492000060c6, %g1, %r24
	setx 0x94df77fc0000827a, %g1, %r25
	setx 0x75037da1000063b8, %g1, %r26
	setx 0xcafdbbd500006320, %g1, %r27
	setx 0xc759a2920000c155, %g1, %r28
	setx 0x367264c300006138, %g1, %r29
	setx 0xf71251ea00006322, %g1, %r30
	setx 0x2cdd2f630000c34c, %g1, %r31
	restore
#ifdef PORTABLE_CORE
	mov	PORTABLE_CORE, %g1
	sllx	%g1, 10, %g1
	or	%r8, %g1, %r8
	or	%r9, %g1, %r9
	or	%r10, %g1, %r10
	or	%r11, %g1, %r11
	or	%r12, %g1, %r12
	or	%r13, %g1, %r13
	or	%r14, %g1, %r14
	or	%r15, %g1, %r15
#endif
	mov	0x10, %r16
	mov	0x68, %r17
	mov	0x60, %r18
	mov	0x30, %r19
	mov	0x3d8, %r20
	mov	0x7c0, %r21
	mov	0x3e0, %r22
	mov	0x3c8, %r23
	mov	0x50, %r24
	mov	0x8, %r25
	mov	0x50, %r26
	mov	0x18, %r27
	mov	0, %r28
	mov	0, %r29
	mov	0, %r30
	mov	0, %r31
	ta	%icc, T_CHANGE_HPRIV
	wr	%g0, 0x25, %asi
	stxa	%g0, [%g0] 0x42
	mov	0x38, %g1
	stxa	%g0, [%g1] 0x58
	ta	%icc, T_RD_THID
! fork: source strm = 0xffffffff; target strm = 0x2
	cmp	%o1, 1
	setx	fork_lbl_0_1, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x4
	cmp	%o1, 2
	setx	fork_lbl_0_2, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x8
	cmp	%o1, 3
	setx	fork_lbl_0_3, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
	.word 0xd2a52000  ! 1: STWA_I	stwa	%r9, [%r20 + 0x0000] %asi
	.word 0xd2dd6000  ! 2: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r9
	.word 0xdef504a0  ! 3: STXA_R	stxa	%r15, [%r20 + %r0] 0x25
	mov	0x7c8, %r20
	mov	0x68, %r18
	mov	0x70, %r18
	.word 0xd8d609e0  ! 7: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r12
	.word 0xd2b7ce80  ! 8: STHA_R	stha	%r9, [%r31 + %r0] 0x74
	.word 0xd08f4e60  ! 9: LDUBA_R	lduba	[%r29, %r0] 0x73, %r8
	.word 0xd89ec9e0  ! 10: LDDA_R	ldda	[%r27, %r0] 0x4f, %r12
	.word 0xd88f4e80  ! 11: LDUBA_R	lduba	[%r29, %r0] 0x74, %r12
	mov	0x10, %r24
	.word 0xdeac8400  ! 13: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xda9cc400  ! 14: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	.word 0x87802025  ! 15: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 16: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd09d04a0  ! 17: LDDA_R	ldda	[%r20, %r0] 0x25, %r8
	mov	0x48, %r25
	.word 0x87802073  ! 19: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0dc8400  ! 20: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0xd6acc400  ! 21: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xd8c74e60  ! 22: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r12
	.word 0x87802073  ! 23: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0f44400  ! 24: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0x87802020  ! 25: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc974e40  ! 26: LDUHA_R	lduha	[%r29, %r0] 0x72, %r14
	.word 0xdcaca000  ! 27: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 28: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r25
	ta	T_CHANGE_PRIV	! macro
	mov	0x18, %r26
	.word 0xd2f48400  ! 32: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0xdc8fce40  ! 33: LDUBA_R	lduba	[%r31, %r0] 0x72, %r14
	.word 0x87802025  ! 34: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbde000  ! 35: STDA_I	stda	%r14, [%r23 + 0x0000] %asi
	.word 0xd2a48400  ! 36: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0x87802074  ! 37: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 38: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 39: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b40400  ! 40: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0xdc8f0e80  ! 41: LDUBA_R	lduba	[%r28, %r0] 0x74, %r14
	.word 0xdcbce000  ! 42: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 43: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc85e000  ! 44: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r14
	.word 0xdc9da000  ! 45: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r14
	.word 0xdc8d6000  ! 46: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r14
	mov	0x58, %r24
	.word 0xdcc52000  ! 48: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r14
	.word 0xd6b78e40  ! 49: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	.word 0xd8ac0400  ! 50: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xd8bda000  ! 51: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	.word 0xd8b5a000  ! 52: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	.word 0xd8d56000  ! 53: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r12
	mov	0x40, %r18
	.word 0xd0dc4400  ! 55: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	.word 0xd0952000  ! 56: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r8
	.word 0xd294c400  ! 57: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	.word 0x87802072  ! 58: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2df2000  ! 59: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd08c0400  ! 60: LDUBA_R	lduba	[%r16, %r0] 0x20, %r8
	mov	0x3c0, %r23
	.word 0xd2f70e40  ! 62: STXA_R	stxa	%r9, [%r28 + %r0] 0x72
	.word 0xd2872000  ! 63: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	.word 0xdc97ce80  ! 64: LDUHA_R	lduha	[%r31, %r0] 0x74, %r14
	.word 0x87802020  ! 65: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcd78e60  ! 66: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r14
	.word 0xdcd42000  ! 67: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2af0e80  ! 69: STBA_R	stba	%r9, [%r28 + %r0] 0x74
	.word 0xdca5c4a0  ! 70: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	.word 0x87802073  ! 71: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb7a000  ! 72: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0xdc976000  ! 74: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	mov	0x70, %r26
	.word 0x87802072  ! 76: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 77: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r18
	.word 0xdc872000  ! 79: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcdf2000  ! 80: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcafa000  ! 81: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xd4840400  ! 82: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	.word 0xde8f8e40  ! 83: LDUBA_R	lduba	[%r30, %r0] 0x72, %r15
	.word 0xdebfa000  ! 84: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xded76000  ! 85: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	mov	0x7e8, %r21
	.word 0xdebfe000  ! 87: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xd6a78e60  ! 88: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0xd6f7a000  ! 89: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6dfe000  ! 90: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 91: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde96c9e0  ! 92: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r15
	.word 0xdeb62000  ! 93: STHA_I	stha	%r15, [%r24 + 0x0000] %asi
	.word 0xd49fce80  ! 94: LDDA_R	ldda	[%r31, %r0] 0x74, %r10
	.word 0xd2b74e80  ! 95: STHA_R	stha	%r9, [%r29 + %r0] 0x74
	.word 0xd8bc4400  ! 96: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xd8c66000  ! 97: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r12
	.word 0xd2a44400  ! 98: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xd2a6a000  ! 99: STWA_I	stwa	%r9, [%r26 + 0x0000] %asi
	mov	0x10, %r17
	.word 0xda9d84a0  ! 101: LDDA_R	ldda	[%r22, %r0] 0x25, %r13
	mov	0x0, %r19
	.word 0xdaf62000  ! 103: STXA_I	stxa	%r13, [%r24 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xd68c8400  ! 105: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	.word 0xdcccc400  ! 106: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	.word 0x87802074  ! 107: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdccf2000  ! 108: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xdaf48400  ! 109: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xdadf2000  ! 110: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	mov	0x3d8, %r22
	.word 0xdaa72000  ! 112: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xdab7e000  ! 113: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xdaf76000  ! 114: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xd8a74e80  ! 115: STWA_R	stwa	%r12, [%r29 + %r0] 0x74
	mov	0x60, %r17
	mov	0x3f8, %r23
	.word 0xd6a70e60  ! 118: STWA_R	stwa	%r11, [%r28 + %r0] 0x73
	mov	0x7d0, %r23
	.word 0xd0c70e60  ! 120: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r8
	mov	0x3f8, %r22
	.word 0xd0ccc400  ! 122: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	mov	0x3f0, %r23
	.word 0xd0dfce60  ! 124: LDXA_R	ldxa	[%r31, %r0] 0x73, %r8
	.word 0xd0bf2000  ! 125: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xdca4c400  ! 126: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0x87802020  ! 127: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcc46000  ! 128: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r14
	.word 0xdccce000  ! 129: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r14
	.word 0xdc8ca000  ! 130: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r14
	mov	0x18, %r19
	mov	0x68, %r19
	mov	0x8, %r16
	.word 0xdc846000  ! 134: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	.word 0xdccca000  ! 135: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	.word 0xdcf4e000  ! 136: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcb4a000  ! 137: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xdca42000  ! 138: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xdcf46000  ! 139: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	mov	0x7c0, %r22
	.word 0xdcd4e000  ! 141: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	.word 0xd2a5c4a0  ! 142: STWA_R	stwa	%r9, [%r23 + %r0] 0x25
	.word 0xd0d70e60  ! 143: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r8
	mov	0x38, %r16
	.word 0xd0f4e000  ! 145: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xd2dcc400  ! 146: LDXA_R	ldxa	[%r19, %r0] 0x20, %r9
	mov	0x58, %r19
	.word 0xd6dc0400  ! 148: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	.word 0xd68c0400  ! 149: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	.word 0xd6ace000  ! 150: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0xd6c46000  ! 151: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r11
	.word 0xd6bc2000  ! 152: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0xd6a4a000  ! 153: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	.word 0xd68c6000  ! 154: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r11
	.word 0xdccf0e80  ! 155: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r14
	.word 0xdc8c0400  ! 156: LDUBA_R	lduba	[%r16, %r0] 0x20, %r14
	.word 0xdc84a000  ! 157: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	.word 0xdc9ce000  ! 158: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r14
	.word 0xdc94e000  ! 159: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	.word 0x87802025  ! 160: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcad6000  ! 161: STBA_I	stba	%r14, [%r21 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xdca56000  ! 163: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	.word 0x87802025  ! 164: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc8d6000  ! 165: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r14
	.word 0xdeb48400  ! 166: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xd8ac4400  ! 167: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xd895a000  ! 168: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r12
	.word 0xd8f52000  ! 169: STXA_I	stxa	%r12, [%r20 + 0x0000] %asi
	.word 0x8780204f  ! 170: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8dea000  ! 171: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r12
	.word 0xd88d84a0  ! 172: LDUBA_R	lduba	[%r22, %r0] 0x25, %r12
	.word 0xd8f6e000  ! 173: STXA_I	stxa	%r12, [%r27 + 0x0000] %asi
	.word 0x87802025  ! 174: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcccc400  ! 175: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	.word 0x87802074  ! 176: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcc7e000  ! 177: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0xdebf0e60  ! 178: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	.word 0xd8aec9e0  ! 179: STBA_R	stba	%r12, [%r27 + %r0] 0x4f
	.word 0xded78e80  ! 180: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r15
	.word 0xdea72000  ! 181: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xd08f4e60  ! 182: LDUBA_R	lduba	[%r29, %r0] 0x73, %r8
	.word 0xde8c0400  ! 183: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0x87802020  ! 184: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb46000  ! 185: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0xdeb4e000  ! 186: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0xdaa649e0  ! 187: STWA_R	stwa	%r13, [%r25 + %r0] 0x4f
	.word 0xdadca000  ! 188: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0xdacc2000  ! 189: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xd6dfce80  ! 190: LDXA_R	ldxa	[%r31, %r0] 0x74, %r11
	.word 0x87802072  ! 191: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6bf2000  ! 192: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xdcb70e40  ! 193: STHA_R	stha	%r14, [%r28 + %r0] 0x72
	mov	0x60, %r18
	mov	0x70, %r27
	.word 0xdcb72000  ! 196: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xd2cf4e40  ! 197: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r9
	.word 0xd2d72000  ! 198: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xdc8f4e60  ! 199: LDUBA_R	lduba	[%r29, %r0] 0x73, %r14
	mov	0x40, %r26
	mov	0x0, %r16
	.word 0x87802025  ! 202: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc85e000  ! 203: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r14
	.word 0xdcbd2000  ! 204: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 205: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r27
	.word 0xdca76000  ! 207: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdadf8e40  ! 208: LDXA_R	ldxa	[%r30, %r0] 0x72, %r13
	.word 0xdab76000  ! 209: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdab48400  ! 210: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0xd2cf4e40  ! 211: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r9
	.word 0xdab504a0  ! 212: STHA_R	stha	%r13, [%r20 + %r0] 0x25
	mov	0x50, %r19
	.word 0xdaa74e80  ! 214: STWA_R	stwa	%r13, [%r29 + %r0] 0x74
	.word 0xdaf7e000  ! 215: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xda9f2000  ! 216: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xdab7e000  ! 217: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xda8f6000  ! 219: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xdaf72000  ! 220: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xd28f8e40  ! 222: LDUBA_R	lduba	[%r30, %r0] 0x72, %r9
	.word 0xd2a72000  ! 223: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	mov	0x10, %r17
	.word 0xd2d7a000  ! 225: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	mov	0x60, %r17
	.word 0xdc878e40  ! 227: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r14
	.word 0xdcf7a000  ! 228: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 229: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r26
	.word 0xdadfce40  ! 231: LDXA_R	ldxa	[%r31, %r0] 0x72, %r13
	.word 0xdecd44a0  ! 232: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r15
	.word 0x87802020  ! 233: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68504a0  ! 234: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r11
	.word 0x87802074  ! 235: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0d74e80  ! 236: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r8
	.word 0x87802020  ! 237: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r21
	.word 0xd0b7ce80  ! 239: STHA_R	stha	%r8, [%r31 + %r0] 0x74
	.word 0xd0c4a000  ! 240: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0a40400  ! 241: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0x87802020  ! 242: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0846000  ! 243: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0xd6bfce60  ! 244: STDA_R	stda	%r11, [%r31 + %r0] 0x73
	.word 0x87802073  ! 245: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f7e000  ! 246: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	mov	0x60, %r26
	.word 0xd6a7a000  ! 248: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6b76000  ! 249: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd6bf6000  ! 250: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 251: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca5c4a0  ! 252: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	.word 0xdacc0400  ! 253: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r13
	.word 0xdacc6000  ! 254: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	.word 0xdaa42000  ! 255: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 256: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 257: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf7a000  ! 258: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 259: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r21
	.word 0xdcf48400  ! 261: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xdeadc4a0  ! 262: STBA_R	stba	%r15, [%r23 + %r0] 0x25
	.word 0xd4f44400  ! 263: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0x87802074  ! 264: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4cfe000  ! 265: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0xd4976000  ! 266: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r10
	.word 0xdadc4400  ! 267: LDXA_R	ldxa	[%r17, %r0] 0x20, %r13
	.word 0xda97a000  ! 268: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	mov	0x8, %r18
	mov	0x7f0, %r20
	.word 0xda87a000  ! 271: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	mov	0x38, %r24
	.word 0xdaaf2000  ! 273: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	mov	0x28, %r19
	.word 0x87802020  ! 275: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4dd44a0  ! 276: LDXA_R	ldxa	[%r21, %r0] 0x25, %r10
	.word 0xd4dce000  ! 277: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	.word 0xd6ae09e0  ! 278: STBA_R	stba	%r11, [%r24 + %r0] 0x4f
	.word 0xd0b78e60  ! 279: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	.word 0xd0f46000  ! 280: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 281: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 282: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0872000  ! 283: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0bf2000  ! 284: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 285: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r25
	mov	0x58, %r24
	.word 0xd0b4a000  ! 288: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xd08c2000  ! 289: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0xd0d46000  ! 290: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r8
	mov	0x40, %r19
	mov	0x7c0, %r22
	.word 0xd0cca000  ! 293: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	.word 0xd0cce000  ! 294: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0xdef7ce80  ! 295: STXA_R	stxa	%r15, [%r31 + %r0] 0x74
	.word 0xdedce000  ! 296: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r15
	.word 0xd6c74e80  ! 297: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r11
	.word 0xdac74e80  ! 298: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r13
	mov	0x28, %r27
	.word 0xdc8689e0  ! 300: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r14
	mov	0x30, %r18
	mov	0x10, %r16
	.word 0xdcb42000  ! 303: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xdca78e80  ! 304: STWA_R	stwa	%r14, [%r30 + %r0] 0x74
	.word 0xdca4e000  ! 305: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcbc6000  ! 306: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xdcaca000  ! 307: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xd4b544a0  ! 308: STHA_R	stha	%r10, [%r21 + %r0] 0x25
	.word 0xd484a000  ! 309: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r10
	mov	0x7f0, %r20
	.word 0xd4b46000  ! 311: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xd28f8e60  ! 312: LDUBA_R	lduba	[%r30, %r0] 0x73, %r9
	.word 0xd2ac2000  ! 313: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xda978e40  ! 314: LDUHA_R	lduha	[%r30, %r0] 0x72, %r13
	.word 0xdadf4e80  ! 315: LDXA_R	ldxa	[%r29, %r0] 0x74, %r13
	mov	0x20, %r26
	mov	0x38, %r25
	mov	0x18, %r16
	.word 0xd0bc4400  ! 319: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	mov	0x78, %r19
	.word 0xd48c4400  ! 321: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0xd4cc2000  ! 322: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	.word 0xd484e000  ! 323: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r10
	.word 0xd4bca000  ! 324: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xd6dc4400  ! 326: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xd69c2000  ! 327: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r11
	.word 0xd68ce000  ! 328: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 329: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b6a000  ! 330: STHA_I	stha	%r11, [%r26 + 0x0000] %asi
	.word 0xd6b62000  ! 331: STHA_I	stha	%r11, [%r24 + 0x0000] %asi
	.word 0xd6bee000  ! 332: STDA_I	stda	%r11, [%r27 + 0x0000] %asi
	.word 0xdaa74e40  ! 333: STWA_R	stwa	%r13, [%r29 + %r0] 0x72
	mov	0x50, %r18
	.word 0xdebdc4a0  ! 335: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	.word 0xdea62000  ! 336: STWA_I	stwa	%r15, [%r24 + 0x0000] %asi
	mov	0x50, %r24
	.word 0xde8ee000  ! 338: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r15
	mov	0x18, %r24
	.word 0x8780204f  ! 340: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f78e80  ! 341: STXA_R	stxa	%r9, [%r30 + %r0] 0x74
	.word 0xd29e2000  ! 342: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r9
	.word 0x87802074  ! 343: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 344: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 345: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r24
	.word 0xd8b4c400  ! 347: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	mov	0x48, %r16
	.word 0xdccf8e60  ! 349: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r14
	.word 0xd6c48400  ! 350: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	.word 0xd6cfa000  ! 351: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0xd6d7e000  ! 352: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	mov	0x3c0, %r20
	.word 0x87802074  ! 354: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r19
	.word 0xd8d689e0  ! 356: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r12
	.word 0xd88f2000  ! 357: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 358: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6d7ce80  ! 359: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r11
	.word 0xdc970e40  ! 360: LDUHA_R	lduha	[%r28, %r0] 0x72, %r14
	.word 0xdcaee000  ! 361: STBA_I	stba	%r14, [%r27 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xdccee000  ! 363: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r14
	.word 0xda8f4e80  ! 364: LDUBA_R	lduba	[%r29, %r0] 0x74, %r13
	.word 0xdac6e000  ! 365: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r13
	.word 0xdab66000  ! 366: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0xd0a78e60  ! 367: STWA_R	stwa	%r8, [%r30 + %r0] 0x73
	.word 0xd0ce6000  ! 368: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r8
	mov	0x0, %r26
	.word 0xdcc649e0  ! 370: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r14
	.word 0xd8f78e60  ! 371: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	.word 0xd8cee000  ! 372: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r12
	.word 0xd8c62000  ! 373: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r12
	.word 0x87802020  ! 374: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f5c4a0  ! 375: STXA_R	stxa	%r9, [%r23 + %r0] 0x25
	mov	0x3d0, %r22
	.word 0xd89d84a0  ! 377: LDDA_R	ldda	[%r22, %r0] 0x25, %r12
	.word 0xd8a42000  ! 378: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8b4e000  ! 379: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	mov	0x60, %r18
	.word 0x87802025  ! 381: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4a70e60  ! 382: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	.word 0xd48da000  ! 383: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r10
	.word 0xdcc74e40  ! 384: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r14
	.word 0xdedf4e80  ! 385: LDXA_R	ldxa	[%r29, %r0] 0x74, %r15
	.word 0xd4a504a0  ! 386: STWA_R	stwa	%r10, [%r20 + %r0] 0x25
	.word 0xd4cde000  ! 387: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r10
	.word 0xd0aec9e0  ! 388: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	mov	0x30, %r24
	mov	0x38, %r18
	.word 0xd6ae89e0  ! 391: STBA_R	stba	%r11, [%r26 + %r0] 0x4f
	.word 0xd68da000  ! 392: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r11
	mov	0x30, %r26
	.word 0x87802073  ! 394: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f8, %r22
	.word 0xd6df6000  ! 396: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6cf2000  ! 397: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0xd0bf8e80  ! 398: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	.word 0x87802074  ! 399: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0974e60  ! 400: LDUHA_R	lduha	[%r29, %r0] 0x73, %r8
	.word 0x87802025  ! 401: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 402: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 403: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r24
	.word 0xd0f72000  ! 405: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	mov	0x58, %r24
	.word 0xd8dc8400  ! 407: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xd8f72000  ! 408: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0x87802074  ! 410: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeb74e60  ! 411: STHA_R	stha	%r15, [%r29 + %r0] 0x73
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802074  ! 413: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d8, %r23
	.word 0xd6cdc4a0  ! 415: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r11
	mov	0x3f8, %r23
	mov	0x3c8, %r20
	.word 0xdea74e40  ! 418: STWA_R	stwa	%r15, [%r29 + %r0] 0x72
	.word 0x87802072  ! 419: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r18
	.word 0x87802074  ! 421: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r16
	.word 0xdecf6000  ! 423: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0x87802073  ! 424: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 425: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef46000  ! 426: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xd6d7ce60  ! 427: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r11
	mov	0x18, %r24
	.word 0xd6f4e000  ! 429: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	.word 0xd4cf0e80  ! 430: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r10
	.word 0x87802020  ! 431: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9f4e40  ! 432: LDDA_R	ldda	[%r29, %r0] 0x72, %r13
	mov	0x7d0, %r20
	.word 0xd4bf4e80  ! 434: STDA_R	stda	%r10, [%r29 + %r0] 0x74
	.word 0xd4a4e000  ! 435: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	mov	0x18, %r25
	mov	0x28, %r27
	.word 0xd4d4a000  ! 438: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0xd6cf0e60  ! 439: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r11
	.word 0xdebd84a0  ! 440: STDA_R	stda	%r15, [%r22 + %r0] 0x25
	.word 0xd8a4c400  ! 441: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xd8cc2000  ! 442: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r12
	mov	0x7f8, %r20
	.word 0x87802020  ! 444: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9f4e40  ! 445: LDDA_R	ldda	[%r29, %r0] 0x72, %r14
	.word 0xdcd4c400  ! 446: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	.word 0xd4a74e60  ! 447: STWA_R	stwa	%r10, [%r29 + %r0] 0x73
	mov	0x3e0, %r20
	.word 0x87802073  ! 449: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcd504a0  ! 450: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r14
	.word 0xd6a70e60  ! 451: STWA_R	stwa	%r11, [%r28 + %r0] 0x73
	.word 0xd697e000  ! 452: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0xd2b74e80  ! 453: STHA_R	stha	%r9, [%r29 + %r0] 0x74
	.word 0xd6bd84a0  ! 454: STDA_R	stda	%r11, [%r22 + %r0] 0x25
	mov	0x48, %r17
	.word 0xd6972000  ! 456: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	mov	0x48, %r25
	.word 0xd6a7a000  ! 458: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6a72000  ! 459: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	mov	0x7c0, %r20
	.word 0xd4af4e40  ! 461: STBA_R	stba	%r10, [%r29 + %r0] 0x72
	.word 0xd4ac0400  ! 462: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xd6974e60  ! 463: LDUHA_R	lduha	[%r29, %r0] 0x73, %r11
	.word 0xd68f4e40  ! 464: LDUBA_R	lduba	[%r29, %r0] 0x72, %r11
	.word 0xd8d689e0  ! 465: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r12
	.word 0xd0adc4a0  ! 466: STBA_R	stba	%r8, [%r23 + %r0] 0x25
	.word 0xd6dfce60  ! 467: LDXA_R	ldxa	[%r31, %r0] 0x73, %r11
	.word 0x87802072  ! 468: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 469: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda848400  ! 470: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r13
	mov	0x48, %r17
	.word 0xdcb4c400  ! 472: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0x87802072  ! 473: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4970e60  ! 474: LDUHA_R	lduha	[%r28, %r0] 0x73, %r10
	mov	0x7e0, %r21
	.word 0xd4a72000  ! 476: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4bfa000  ! 477: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd6c609e0  ! 478: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r11
	.word 0x87802073  ! 479: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r25
	.word 0xd69fa000  ! 481: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0xdab584a0  ! 482: STHA_R	stha	%r13, [%r22 + %r0] 0x25
	.word 0x87802020  ! 483: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b4c400  ! 484: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0xd884a000  ! 485: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r12
	.word 0xd8a42000  ! 486: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd68f4e80  ! 487: LDUBA_R	lduba	[%r29, %r0] 0x74, %r11
	mov	0x70, %r26
	.word 0xd4bfce60  ! 489: STDA_R	stda	%r10, [%r31 + %r0] 0x73
	.word 0xdaa5c4a0  ! 490: STWA_R	stwa	%r13, [%r23 + %r0] 0x25
	.word 0x8780204f  ! 491: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bdc4a0  ! 492: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	.word 0x8780204f  ! 493: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a62000  ! 494: STWA_I	stwa	%r12, [%r24 + 0x0000] %asi
	mov	0x18, %r19
	.word 0xd8970e80  ! 496: LDUHA_R	lduha	[%r28, %r0] 0x74, %r12
	.word 0xd4dc8400  ! 497: LDXA_R	ldxa	[%r18, %r0] 0x20, %r10
	.word 0xd2b40400  ! 498: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	mov	0x7f8, %r21
	mov	0x7c0, %r23
	mov	0x3d0, %r21
	.word 0xd2c6a000  ! 502: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r9
	.word 0xd2a6e000  ! 503: STWA_I	stwa	%r9, [%r27 + 0x0000] %asi
	mov	0x60, %r18
	mov	0x7f0, %r23
	.word 0x87802074  ! 506: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdea7ce40  ! 507: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	.word 0xdebfa000  ! 508: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xdebfe000  ! 509: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xde87e000  ! 510: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdacf8e60  ! 511: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r13
	.word 0xdaafa000  ! 512: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdaafe000  ! 513: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0xdaa76000  ! 515: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	mov	0x3f0, %r20
	.word 0x87802072  ! 517: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x8, %r16
	.word 0xdcf78e60  ! 520: STXA_R	stxa	%r14, [%r30 + %r0] 0x73
	.word 0xdcdf6000  ! 521: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xd6b78e60  ! 522: STHA_R	stha	%r11, [%r30 + %r0] 0x73
	.word 0xd6840400  ! 523: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	mov	0x7f0, %r23
	.word 0xdec504a0  ! 525: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r15
	.word 0xde86c9e0  ! 526: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r15
	mov	0x58, %r26
	mov	0x68, %r26
	mov	0x20, %r25
	.word 0xdeb72000  ! 530: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xdebf2000  ! 531: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 532: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f40400  ! 533: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0x87802073  ! 534: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f7a000  ! 535: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	mov	0x18, %r17
	.word 0xd29f6000  ! 537: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0x87802072  ! 538: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7c0, %r20
	mov	0x20, %r16
	.word 0xd2f7e000  ! 541: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd8a40400  ! 542: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0xd2aec9e0  ! 543: STBA_R	stba	%r9, [%r27 + %r0] 0x4f
	.word 0x87802073  ! 544: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 545: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 546: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2ad6000  ! 547: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xd2dde000  ! 549: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 550: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd884c400  ! 551: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	.word 0xd89609e0  ! 552: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r12
	.word 0x87802025  ! 553: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabe89e0  ! 554: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	.word 0xd09f4e60  ! 555: LDDA_R	ldda	[%r29, %r0] 0x73, %r8
	mov	0x50, %r26
	.word 0xd0a5a000  ! 557: STWA_I	stwa	%r8, [%r22 + 0x0000] %asi
	.word 0xd0cde000  ! 558: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r8
	mov	0x50, %r26
	.word 0x87802020  ! 560: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r17
	mov	0x7c8, %r23
	.word 0x87802020  ! 563: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a5c4a0  ! 564: STWA_R	stwa	%r11, [%r23 + %r0] 0x25
	.word 0xd6bca000  ! 565: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	mov	0x7c0, %r22
	.word 0xd2b40400  ! 567: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0xd2842000  ! 568: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r9
	mov	0x7f0, %r22
	mov	0x7f8, %r21
	.word 0xd2846000  ! 571: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r9
	.word 0xd2846000  ! 572: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r9
	mov	0x3d8, %r22
	.word 0xd4df4e40  ! 574: LDXA_R	ldxa	[%r29, %r0] 0x72, %r10
	.word 0xd48c6000  ! 575: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r10
	mov	0x10, %r18
	.word 0x87802020  ! 577: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaac0400  ! 578: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xdaf70e80  ! 579: STXA_R	stxa	%r13, [%r28 + %r0] 0x74
	.word 0xde8e09e0  ! 580: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r15
	mov	0x70, %r27
	.word 0xdece49e0  ! 582: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r15
	.word 0xdebc2000  ! 583: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	mov	0x40, %r17
	.word 0xdaf4c400  ! 585: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xdadce000  ! 586: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xdaf4e000  ! 587: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xdaace000  ! 588: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	mov	0x38, %r19
	mov	0x60, %r16
	.word 0xdacca000  ! 591: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	.word 0xdede89e0  ! 592: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r15
	.word 0xd6d48400  ! 593: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0xd6b4a000  ! 594: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 595: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 596: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ace000  ! 597: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 598: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 599: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c8, %r20
	.word 0xd6b7a000  ! 601: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd68f2000  ! 602: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xdeaf8e40  ! 603: STBA_R	stba	%r15, [%r30 + %r0] 0x72
	.word 0x87802020  ! 604: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeaca000  ! 605: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xdea4a000  ! 606: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xdacdc4a0  ! 607: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r13
	.word 0x87802074  ! 608: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 609: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda9de000  ! 610: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r13
	.word 0xd4af4e40  ! 611: STBA_R	stba	%r10, [%r29 + %r0] 0x72
	.word 0xd4f56000  ! 612: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	.word 0xd69504a0  ! 613: LDUHA_R	lduha	[%r20, %r0] 0x25, %r11
	.word 0x87802072  ! 614: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6c72000  ! 615: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6f7a000  ! 616: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xdabfce40  ! 617: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	.word 0x87802074  ! 618: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d0, %r23
	.word 0xdadf0e80  ! 620: LDXA_R	ldxa	[%r28, %r0] 0x74, %r13
	mov	0x68, %r18
	.word 0xdaf7e000  ! 622: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xda9fa000  ! 623: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xd4bc4400  ! 624: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 625: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4ae2000  ! 626: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 627: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b42000  ! 628: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	.word 0xd4f42000  ! 629: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	mov	0x58, %r19
	mov	0x7d8, %r23
	.word 0x87802072  ! 632: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8f7ce80  ! 633: STXA_R	stxa	%r12, [%r31 + %r0] 0x74
	.word 0x87802020  ! 634: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r22
	.word 0xd8f4a000  ! 636: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xdedf0e60  ! 637: LDXA_R	ldxa	[%r28, %r0] 0x73, %r15
	.word 0xde9ce000  ! 638: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0x87802020  ! 639: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb46000  ! 640: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 641: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcdf4e80  ! 642: LDXA_R	ldxa	[%r29, %r0] 0x74, %r14
	.word 0xd8df8e80  ! 643: LDXA_R	ldxa	[%r30, %r0] 0x74, %r12
	.word 0xd0bcc400  ! 644: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	mov	0x0, %r26
	.word 0xd0afa000  ! 646: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd2b70e80  ! 647: STHA_R	stha	%r9, [%r28 + %r0] 0x74
	.word 0xd8a504a0  ! 648: STWA_R	stwa	%r12, [%r20 + %r0] 0x25
	.word 0xd8dfa000  ! 649: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8f72000  ! 650: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd2b609e0  ! 651: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	.word 0xdaf5c4a0  ! 652: STXA_R	stxa	%r13, [%r23 + %r0] 0x25
	.word 0xde874e60  ! 653: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r15
	.word 0xd6ae09e0  ! 654: STBA_R	stba	%r11, [%r24 + %r0] 0x4f
	.word 0xd09dc4a0  ! 655: LDDA_R	ldda	[%r23, %r0] 0x25, %r8
	.word 0x87802072  ! 656: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0bfa000  ! 657: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 658: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0af8e80  ! 659: STBA_R	stba	%r8, [%r30 + %r0] 0x74
	.word 0xdaf4c400  ! 660: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xdab7a000  ! 661: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	mov	0x0, %r25
	.word 0xd2f7ce80  ! 663: STXA_R	stxa	%r9, [%r31 + %r0] 0x74
	.word 0xd6d689e0  ! 664: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r11
	mov	0x10, %r25
	.word 0xdca44400  ! 666: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0xdedf4e60  ! 667: LDXA_R	ldxa	[%r29, %r0] 0x73, %r15
	mov	0x30, %r17
	.word 0xdeb7e000  ! 669: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xde97e000  ! 670: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0xdef72000  ! 671: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	mov	0x10, %r19
	mov	0x78, %r24
	.word 0xd4cfce60  ! 674: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r10
	.word 0x87802020  ! 675: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r22
	.word 0xd494e000  ! 677: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	mov	0x28, %r18
	.word 0xd8bd44a0  ! 679: STDA_R	stda	%r12, [%r21 + %r0] 0x25
	.word 0xd89ce000  ! 680: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	.word 0x87802025  ! 681: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f74e60  ! 682: STXA_R	stxa	%r8, [%r29 + %r0] 0x73
	mov	0x58, %r18
	.word 0x8780204f  ! 684: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b62000  ! 685: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0xd6a6c9e0  ! 686: STWA_R	stwa	%r11, [%r27 + %r0] 0x4f
	.word 0x8780204f  ! 687: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdecc0400  ! 688: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r15
	.word 0x87802025  ! 689: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeade000  ! 690: STBA_I	stba	%r15, [%r23 + 0x0000] %asi
	.word 0xd2afce60  ! 691: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	.word 0xd2ac8400  ! 692: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xd0a48400  ! 693: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	mov	0x7d0, %r20
	.word 0xd0856000  ! 695: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r8
	.word 0xd0f5e000  ! 696: STXA_I	stxa	%r8, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 697: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f78e60  ! 698: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	.word 0xde9ec9e0  ! 699: LDDA_R	ldda	[%r27, %r0] 0x4f, %r15
	.word 0xd4844400  ! 700: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0xd89ec9e0  ! 701: LDDA_R	ldda	[%r27, %r0] 0x4f, %r12
	.word 0xd29f0e40  ! 702: LDDA_R	ldda	[%r28, %r0] 0x72, %r9
	.word 0x8780204f  ! 703: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0be89e0  ! 704: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 705: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d48400  ! 706: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	.word 0xdec48400  ! 707: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	mov	0x60, %r16
	mov	0x20, %r26
	.word 0xdec4e000  ! 710: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	mov	0x7e0, %r21
	.word 0xde94e000  ! 712: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	.word 0xdea4e000  ! 713: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xd2bc4400  ! 714: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	mov	0x48, %r18
	.word 0xd2f46000  ! 716: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2f4e000  ! 717: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	mov	0x68, %r18
	.word 0x8780204f  ! 719: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bee000  ! 720: STDA_I	stda	%r9, [%r27 + 0x0000] %asi
	.word 0xd2a6e000  ! 721: STWA_I	stwa	%r9, [%r27 + 0x0000] %asi
	.word 0xd2f6a000  ! 722: STXA_I	stxa	%r9, [%r26 + 0x0000] %asi
	.word 0x87802074  ! 723: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde95c4a0  ! 724: LDUHA_R	lduha	[%r23, %r0] 0x25, %r15
	.word 0xdebfce40  ! 725: STDA_R	stda	%r15, [%r31 + %r0] 0x72
	.word 0xdecfce80  ! 726: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r15
	.word 0xdebfa000  ! 727: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 728: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r25
	.word 0x8780204f  ! 730: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebc4400  ! 731: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	mov	0x7e8, %r23
	.word 0xdede2000  ! 733: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r15
	.word 0xd89fce60  ! 734: LDDA_R	ldda	[%r31, %r0] 0x73, %r12
	.word 0xdcbfce40  ! 735: STDA_R	stda	%r14, [%r31 + %r0] 0x72
	.word 0xd6d5c4a0  ! 736: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r11
	.word 0xd6be6000  ! 737: STDA_I	stda	%r11, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 738: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r20
	mov	0x0, %r24
	ta	T_CHANGE_PRIV	! macro
	mov	0x7c8, %r20
	.word 0xd6dc6000  ! 743: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r11
	mov	0x3d8, %r21
	mov	0x7e0, %r23
	.word 0xd6b4a000  ! 746: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd2bfce40  ! 747: STDA_R	stda	%r9, [%r31 + %r0] 0x72
	mov	0x3c0, %r23
	.word 0xd2b4a000  ! 749: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0xd2aca000  ! 750: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0xde9f0e80  ! 751: LDDA_R	ldda	[%r28, %r0] 0x74, %r15
	.word 0xd29e09e0  ! 752: LDDA_R	ldda	[%r24, %r0] 0x4f, %r9
	mov	0x78, %r24
	.word 0x87802025  ! 754: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 755: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b584a0  ! 756: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	mov	0x58, %r26
	mov	0x7f8, %r23
	.word 0xd2df6000  ! 759: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2bf6000  ! 760: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 761: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a46000  ! 762: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	mov	0x7f8, %r23
	.word 0x87802020  ! 764: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f46000  ! 765: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd4870e80  ! 766: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r10
	.word 0xd4c4a000  ! 767: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	.word 0xd4a46000  ! 768: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	mov	0x48, %r18
	.word 0x87802025  ! 770: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4f56000  ! 771: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	.word 0xd8f78e60  ! 772: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	.word 0xd2d78e60  ! 773: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r9
	.word 0xd8f70e80  ! 774: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	.word 0xd8a5e000  ! 775: STWA_I	stwa	%r12, [%r23 + 0x0000] %asi
	mov	0x30, %r26
	mov	0x50, %r16
	mov	0x28, %r24
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802074  ! 780: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd8bfe000  ! 782: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 783: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r18
	mov	0x20, %r26
	.word 0xdcf7ce60  ! 786: STXA_R	stxa	%r14, [%r31 + %r0] 0x73
	mov	0x38, %r16
	.word 0x87802074  ! 788: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0bf8e80  ! 789: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	.word 0xd0872000  ! 790: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xd2b7ce40  ! 791: STHA_R	stha	%r9, [%r31 + %r0] 0x72
	mov	0x60, %r26
	.word 0xd29f2000  ! 793: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	mov	0x3e0, %r21
	.word 0xdaaf0e40  ! 795: STBA_R	stba	%r13, [%r28 + %r0] 0x72
	.word 0xda8f6000  ! 796: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xdab7a000  ! 797: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdaf7a000  ! 798: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdac7a000  ! 799: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0x87802020  ! 800: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r18
	mov	0x7f8, %r23
	.word 0x87802072  ! 803: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda9fa000  ! 804: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xdab72000  ! 805: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdac7a000  ! 806: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xd6a74e40  ! 807: STWA_R	stwa	%r11, [%r29 + %r0] 0x72
	mov	0x0, %r16
	mov	0x0, %r17
	.word 0xd6af6000  ! 810: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x7c0, %r22
	.word 0xd6a7e000  ! 812: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6f7a000  ! 813: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd08fce80  ! 814: LDUBA_R	lduba	[%r31, %r0] 0x74, %r8
	.word 0x87802072  ! 815: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f0, %r21
	.word 0xd4f4c400  ! 817: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd4f7a000  ! 818: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd48cc400  ! 819: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	mov	0x48, %r18
	.word 0x87802020  ! 821: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4dce000  ! 822: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	.word 0xd08dc4a0  ! 823: LDUBA_R	lduba	[%r23, %r0] 0x25, %r8
	mov	0x7c8, %r22
	mov	0x3f0, %r23
	.word 0xd0a46000  ! 826: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 827: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r26
	.word 0xd6d74e60  ! 829: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r11
	.word 0xd0f6c9e0  ! 830: STXA_R	stxa	%r8, [%r27 + %r0] 0x4f
	.word 0x8780204f  ! 831: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 832: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcd40400  ! 833: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	.word 0xdcacc400  ! 834: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	mov	0x68, %r16
	.word 0xde8f8e40  ! 836: LDUBA_R	lduba	[%r30, %r0] 0x72, %r15
	.word 0xdc84c400  ! 837: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	.word 0xdcf7e000  ! 838: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x58, %r26
	mov	0x60, %r24
	.word 0xdccf2000  ! 841: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xdca7a000  ! 842: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcbf6000  ! 843: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 844: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0ccc400  ! 846: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	.word 0x87802020  ! 847: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4de49e0  ! 848: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r10
	.word 0x87802072  ! 849: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4af6000  ! 850: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd4a72000  ! 851: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 852: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d0, %r23
	.word 0xd4f7e000  ! 854: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xd2d70e60  ! 855: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r9
	.word 0xdc9c4400  ! 856: LDDA_R	ldda	[%r17, %r0] 0x20, %r14
	.word 0xdca7a000  ! 857: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 858: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r19
	mov	0x70, %r26
	.word 0xd8f78e40  ! 861: STXA_R	stxa	%r12, [%r30 + %r0] 0x72
	.word 0xd8bf2000  ! 862: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xdadc0400  ! 863: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	.word 0xd2cc8400  ! 864: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0xd2c7e000  ! 865: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2cf2000  ! 866: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r9
	mov	0x48, %r27
	.word 0xd2af8e40  ! 868: STBA_R	stba	%r9, [%r30 + %r0] 0x72
	mov	0x3f8, %r20
	.word 0x87802020  ! 870: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 871: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d0, %r22
	mov	0x50, %r18
	.word 0xdcbcc400  ! 874: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xdeb584a0  ! 875: STHA_R	stha	%r15, [%r22 + %r0] 0x25
	.word 0x87802020  ! 876: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedce000  ! 877: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r15
	.word 0xde8c6000  ! 878: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0xd2a4c400  ! 879: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	mov	0x20, %r16
	mov	0x60, %r18
	.word 0xd2bc2000  ! 882: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xd2c44400  ! 883: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	.word 0x87802072  ! 884: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 885: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r16
	.word 0x87802020  ! 887: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2aca000  ! 888: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0xdad40400  ! 889: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	.word 0xdacca000  ! 890: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	mov	0x3c8, %r20
	mov	0x38, %r24
	.word 0x87802072  ! 893: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabf6000  ! 894: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xdeaf4e40  ! 895: STBA_R	stba	%r15, [%r29 + %r0] 0x72
	mov	0x68, %r18
	.word 0xd2d40400  ! 897: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	.word 0xd287e000  ! 898: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2a584a0  ! 899: STWA_R	stwa	%r9, [%r22 + %r0] 0x25
	.word 0xd28f6000  ! 900: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	mov	0x58, %r17
	.word 0x87802020  ! 902: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2af4e40  ! 904: STBA_R	stba	%r9, [%r29 + %r0] 0x72
	.word 0x87802073  ! 905: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2af2000  ! 906: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd2b7a000  ! 907: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 908: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2876000  ! 909: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2cf6000  ! 910: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2f76000  ! 912: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xdaafce40  ! 913: STBA_R	stba	%r13, [%r31 + %r0] 0x72
	mov	0x60, %r26
	.word 0x87802073  ! 915: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeac0400  ! 916: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xde9f8e60  ! 917: LDDA_R	ldda	[%r30, %r0] 0x73, %r15
	.word 0x87802020  ! 918: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r25
	.word 0x87802073  ! 920: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r26
	.word 0xde8f2000  ! 922: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xde8689e0  ! 923: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r15
	mov	0x8, %r18
	mov	0x3c8, %r21
	.word 0xdef76000  ! 926: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdedfa000  ! 927: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xde8f2000  ! 928: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xde9f2000  ! 929: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	mov	0x40, %r24
	.word 0xd0ac4400  ! 931: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0xde978e40  ! 932: LDUHA_R	lduha	[%r30, %r0] 0x72, %r15
	.word 0x87802074  ! 933: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde840400  ! 934: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	.word 0xdeb7a000  ! 935: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 936: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 937: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd08f4e40  ! 938: LDUBA_R	lduba	[%r29, %r0] 0x72, %r8
	mov	0x18, %r25
	mov	0x58, %r18
	mov	0x68, %r17
	mov	0x7e0, %r21
	.word 0xd8bd44a0  ! 943: STDA_R	stda	%r12, [%r21 + %r0] 0x25
	.word 0xd8a72000  ! 944: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xdeaec9e0  ! 945: STBA_R	stba	%r15, [%r27 + %r0] 0x4f
	.word 0xdcccc400  ! 946: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	mov	0x50, %r27
	.word 0xdcf7a000  ! 948: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xd2a78e80  ! 949: STWA_R	stwa	%r9, [%r30 + %r0] 0x74
	.word 0x87802025  ! 950: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb5c4a0  ! 951: STHA_R	stha	%r14, [%r23 + %r0] 0x25
	.word 0xdaafce40  ! 952: STBA_R	stba	%r13, [%r31 + %r0] 0x72
	mov	0x3e0, %r23
	.word 0xd89f0e40  ! 954: LDDA_R	ldda	[%r28, %r0] 0x72, %r12
	.word 0xd88de000  ! 955: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r12
	.word 0xd087ce40  ! 956: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r8
	.word 0xd0dd2000  ! 957: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0xd2d40400  ! 958: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	.word 0x87802074  ! 959: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdece09e0  ! 960: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r15
	.word 0xdeb72000  ! 961: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 962: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8ca000  ! 963: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0x87802074  ! 964: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b609e0  ! 965: STHA_R	stha	%r8, [%r24 + %r0] 0x4f
	.word 0xd0afe000  ! 966: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0cf2000  ! 967: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 968: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2d7ce40  ! 969: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r9
	.word 0xd2bea000  ! 970: STDA_I	stda	%r9, [%r26 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0xd4f4c400  ! 972: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd49ea000  ! 973: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	.word 0xd4b6a000  ! 974: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	.word 0xda970e40  ! 975: LDUHA_R	lduha	[%r28, %r0] 0x72, %r13
	.word 0xda9e6000  ! 976: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r13
	.word 0xdaaea000  ! 977: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 978: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 979: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r26
	.word 0x87802020  ! 981: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaac8400  ! 982: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0xdabca000  ! 983: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdaac2000  ! 984: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	mov	0x28, %r16
	mov	0x60, %r16
	.word 0xdacf0e60  ! 987: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r13
	.word 0x87802020  ! 988: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabca000  ! 989: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 990: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab7a000  ! 991: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	mov	0x38, %r24
	.word 0xd08e09e0  ! 993: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r8
	mov	0x7d0, %r21
	mov	0x7d8, %r23
	.word 0x87802073  ! 996: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0f7e000  ! 997: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0a7ce60  ! 998: STWA_R	stwa	%r8, [%r31 + %r0] 0x73
	mov	0x3f0, %r20
	.word 0xd6b4c400  ! 1000: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0x87802072  ! 1001: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a70e40  ! 1002: STWA_R	stwa	%r12, [%r28 + %r0] 0x72
	.word 0xd0df8e60  ! 1003: LDXA_R	ldxa	[%r30, %r0] 0x73, %r8
	mov	0x3e8, %r22
	.word 0xd894c400  ! 1005: LDUHA_R	lduha	[%r19, %r0] 0x20, %r12
	mov	0x10, %r18
	.word 0xd89f4e40  ! 1007: LDDA_R	ldda	[%r29, %r0] 0x72, %r12
	.word 0xd8c72000  ! 1008: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	mov	0x28, %r24
	.word 0xd8f76000  ! 1010: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xdcbc8400  ! 1012: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0x87802020  ! 1013: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b649e0  ! 1014: STHA_R	stha	%r11, [%r25 + %r0] 0x4f
	.word 0xdc8584a0  ! 1015: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r14
	.word 0xd2f48400  ! 1016: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0xd6f78e80  ! 1017: STXA_R	stxa	%r11, [%r30 + %r0] 0x74
	.word 0xdcf7ce60  ! 1018: STXA_R	stxa	%r14, [%r31 + %r0] 0x73
	.word 0xdec44400  ! 1019: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0xdec4a000  ! 1020: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xdeb4e000  ! 1021: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0xdeb4a000  ! 1022: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 1023: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef7a000  ! 1024: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdaccc400  ! 1025: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r13
	.word 0xd2b7ce80  ! 1026: STHA_R	stha	%r9, [%r31 + %r0] 0x74
	.word 0xd2c72000  ! 1027: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2afe000  ! 1028: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd08f8e40  ! 1029: LDUBA_R	lduba	[%r30, %r0] 0x72, %r8
	mov	0x7c8, %r21
	.word 0xd0b72000  ! 1031: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xdcbe49e0  ! 1032: STDA_R	stda	%r14, [%r25 + %r0] 0x4f
	.word 0xdcaf2000  ! 1033: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdcdf8e60  ! 1034: LDXA_R	ldxa	[%r30, %r0] 0x73, %r14
	.word 0xdccfa000  ! 1035: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	mov	0x78, %r19
	.word 0xd4af4e40  ! 1037: STBA_R	stba	%r10, [%r29 + %r0] 0x72
	.word 0xd287ce40  ! 1038: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r9
	.word 0xd0f40400  ! 1039: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	mov	0x20, %r17
	mov	0x0, %r27
	.word 0xd6948400  ! 1042: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	.word 0x87802025  ! 1043: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f0, %r21
	.word 0xd68d2000  ! 1045: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r11
	.word 0xd6bda000  ! 1046: STDA_I	stda	%r11, [%r22 + 0x0000] %asi
	.word 0xd6f56000  ! 1047: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	mov	0x3f0, %r23
	.word 0xdeb74e80  ! 1049: STHA_R	stha	%r15, [%r29 + %r0] 0x74
	.word 0xd6b44400  ! 1050: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xd68d2000  ! 1051: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r11
	.word 0xd6c56000  ! 1052: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r11
	.word 0xd687ce60  ! 1053: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r11
	mov	0x40, %r24
	.word 0xd6a5e000  ! 1055: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	.word 0xd0cc8400  ! 1056: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0xd0cde000  ! 1057: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r8
	.word 0xd2978e40  ! 1058: LDUHA_R	lduha	[%r30, %r0] 0x72, %r9
	.word 0xd2d5a000  ! 1059: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r9
	.word 0xd295e000  ! 1060: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r9
	.word 0x87802072  ! 1061: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1062: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc978e80  ! 1063: LDUHA_R	lduha	[%r30, %r0] 0x74, %r14
	mov	0x3d8, %r20
	.word 0x8780204f  ! 1065: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r16
	.word 0x87802020  ! 1067: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa74e60  ! 1068: STWA_R	stwa	%r13, [%r29 + %r0] 0x73
	mov	0x40, %r18
	.word 0x87802020  ! 1070: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1071: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r18
	.word 0xd8f4c400  ! 1073: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0x87802073  ! 1074: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r25
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd88f2000  ! 1077: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0xd8c7a000  ! 1078: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xd6a584a0  ! 1079: STWA_R	stwa	%r11, [%r22 + %r0] 0x25
	.word 0x87802025  ! 1080: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b48400  ! 1081: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	mov	0x78, %r24
	mov	0x3f0, %r21
	.word 0xde948400  ! 1084: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	.word 0xdebd6000  ! 1085: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	.word 0xd4af4e80  ! 1086: STBA_R	stba	%r10, [%r29 + %r0] 0x74
	.word 0xd4f649e0  ! 1087: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	mov	0x0, %r27
	.word 0xdcbfce40  ! 1089: STDA_R	stda	%r14, [%r31 + %r0] 0x72
	.word 0xd6b5c4a0  ! 1090: STHA_R	stha	%r11, [%r23 + %r0] 0x25
	mov	0x50, %r16
	.word 0xd6a5e000  ! 1092: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	mov	0x8, %r17
	.word 0xd6bd6000  ! 1094: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	mov	0x7c0, %r22
	.word 0xd2af4e60  ! 1096: STBA_R	stba	%r9, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 1097: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e0, %r23
	mov	0x3e8, %r20
	.word 0xd28c8400  ! 1100: LDUBA_R	lduba	[%r18, %r0] 0x20, %r9
	.word 0xd49e49e0  ! 1101: LDDA_R	ldda	[%r25, %r0] 0x4f, %r10
	.word 0xd4be2000  ! 1102: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	.word 0xdcb7ce80  ! 1103: STHA_R	stha	%r14, [%r31 + %r0] 0x74
	.word 0xdcd6a000  ! 1104: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r14
	.word 0xdcf66000  ! 1105: STXA_I	stxa	%r14, [%r25 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0x87802073  ! 1107: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdea584a0  ! 1108: STWA_R	stwa	%r15, [%r22 + %r0] 0x25
	.word 0xde972000  ! 1109: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0xde9fa000  ! 1110: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	mov	0x3c8, %r22
	.word 0xde97a000  ! 1112: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	.word 0xd6844400  ! 1113: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r11
	.word 0xd6a72000  ! 1114: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6a7e000  ! 1115: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	mov	0x18, %r17
	mov	0x60, %r17
	.word 0xdc848400  ! 1118: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	.word 0xdcc40400  ! 1119: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	.word 0xdcf689e0  ! 1120: STXA_R	stxa	%r14, [%r26 + %r0] 0x4f
	.word 0xdcaf2000  ! 1121: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xdc87a000  ! 1123: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcac8400  ! 1124: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xd0a4c400  ! 1125: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xd0af8e80  ! 1126: STBA_R	stba	%r8, [%r30 + %r0] 0x74
	.word 0xdcac0400  ! 1127: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xdcbf6000  ! 1128: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdc9fe000  ! 1129: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xdabdc4a0  ! 1130: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	.word 0xd8ae09e0  ! 1131: STBA_R	stba	%r12, [%r24 + %r0] 0x4f
	mov	0x7c8, %r21
	.word 0xdcb7ce60  ! 1133: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	mov	0x3c8, %r21
	.word 0xdc97e000  ! 1135: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xd0b7ce60  ! 1136: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	.word 0xd0af2000  ! 1137: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 1138: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 1139: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r24
	mov	0x50, %r24
	.word 0xd087e000  ! 1142: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	mov	0x58, %r25
	mov	0x70, %r25
	.word 0x87802072  ! 1145: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f8, %r21
	.word 0xd0c76000  ! 1147: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	mov	0x7f0, %r22
	.word 0xd0a7a000  ! 1149: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd087e000  ! 1150: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0xdabe49e0  ! 1151: STDA_R	stda	%r13, [%r25 + %r0] 0x4f
	.word 0xdeb609e0  ! 1152: STHA_R	stha	%r15, [%r24 + %r0] 0x4f
	.word 0xde872000  ! 1153: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	mov	0x78, %r18
	.word 0xd0bc8400  ! 1155: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0xd0976000  ! 1156: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd2b7ce80  ! 1157: STHA_R	stha	%r9, [%r31 + %r0] 0x74
	.word 0xd28fa000  ! 1158: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	mov	0x60, %r24
	mov	0x7c0, %r20
	.word 0xd2b7e000  ! 1161: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 1162: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f5c4a0  ! 1163: STXA_R	stxa	%r10, [%r23 + %r0] 0x25
	mov	0x8, %r27
	.word 0x87802073  ! 1165: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f7e000  ! 1166: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 1167: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f7e000  ! 1168: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xdaaf0e60  ! 1169: STBA_R	stba	%r13, [%r28 + %r0] 0x73
	mov	0x10, %r27
	.word 0xda87a000  ! 1171: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0xda876000  ! 1172: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	mov	0x10, %r17
	mov	0x3c0, %r23
	mov	0x28, %r24
	.word 0xda8f6000  ! 1176: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xdabfa000  ! 1177: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xda9fa000  ! 1178: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xdac72000  ! 1179: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0xdaaf8e40  ! 1180: STBA_R	stba	%r13, [%r30 + %r0] 0x72
	mov	0x8, %r17
	.word 0x87802025  ! 1182: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad5e000  ! 1183: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r13
	mov	0x10, %r24
	.word 0x87802025  ! 1185: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r24
	.word 0x87802073  ! 1187: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 1188: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r24
	mov	0x7e0, %r20
	.word 0x87802020  ! 1191: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r17
	mov	0x70, %r16
	.word 0xda8c6000  ! 1194: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1195: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r20
	mov	0x3d0, %r20
	mov	0x7c8, %r21
	.word 0xdaa7ce60  ! 1199: STWA_R	stwa	%r13, [%r31 + %r0] 0x73
	mov	0x7e0, %r23
	.word 0xd4978e60  ! 1201: LDUHA_R	lduha	[%r30, %r0] 0x73, %r10
	mov	0x30, %r19
	.word 0xdeb74e80  ! 1203: STHA_R	stha	%r15, [%r29 + %r0] 0x74
	.word 0xd4ad84a0  ! 1204: STBA_R	stba	%r10, [%r22 + %r0] 0x25
	.word 0x87802072  ! 1205: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b7ce40  ! 1206: STHA_R	stha	%r9, [%r31 + %r0] 0x72
	mov	0x48, %r24
	.word 0xd2b7e000  ! 1208: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2f76000  ! 1209: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xdaa7ce80  ! 1210: STWA_R	stwa	%r13, [%r31 + %r0] 0x74
	.word 0xdaf76000  ! 1211: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 1212: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9e6000  ! 1213: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r13
	.word 0xdade2000  ! 1214: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r13
	.word 0xd68f8e40  ! 1215: LDUBA_R	lduba	[%r30, %r0] 0x72, %r11
	.word 0xdcd609e0  ! 1216: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r14
	.word 0xdcc62000  ! 1217: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r14
	.word 0x87802020  ! 1218: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bfce40  ! 1219: STDA_R	stda	%r8, [%r31 + %r0] 0x72
	mov	0x70, %r19
	.word 0x87802020  ! 1221: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r26
	.word 0xdc974e80  ! 1223: LDUHA_R	lduha	[%r29, %r0] 0x74, %r14
	.word 0x87802072  ! 1224: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb76000  ! 1225: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 1226: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd88f4e40  ! 1227: LDUBA_R	lduba	[%r29, %r0] 0x72, %r12
	.word 0xdcce49e0  ! 1228: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r14
	mov	0x7f8, %r20
	.word 0x87802020  ! 1230: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r20
	mov	0x7e0, %r23
	.word 0xdca4a000  ! 1233: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	mov	0x8, %r27
	mov	0x3d8, %r23
	mov	0x7e0, %r21
	.word 0xde8504a0  ! 1237: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r15
	mov	0x18, %r18
	mov	0x3d0, %r23
	.word 0xd4940400  ! 1240: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	.word 0xd8bdc4a0  ! 1241: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	.word 0xd6870e80  ! 1242: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r11
	.word 0xd69d44a0  ! 1243: LDDA_R	ldda	[%r21, %r0] 0x25, %r11
	.word 0xd6b46000  ! 1244: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd6f48400  ! 1245: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xd6dca000  ! 1246: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r11
	mov	0x58, %r24
	.word 0xd0ae09e0  ! 1248: STBA_R	stba	%r8, [%r24 + %r0] 0x4f
	.word 0xdc9fce80  ! 1249: LDDA_R	ldda	[%r31, %r0] 0x74, %r14
	.word 0xdcb46000  ! 1250: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	mov	0x78, %r27
	mov	0x50, %r19
	mov	0x20, %r18
	.word 0xde878e60  ! 1254: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r15
	mov	0x10, %r24
	.word 0xd2c78e60  ! 1256: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r9
	mov	0x50, %r25
	.word 0xd2f46000  ! 1258: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	mov	0x0, %r18
	mov	0x28, %r24
	.word 0x87802074  ! 1261: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0dc8400  ! 1262: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	mov	0x38, %r19
	.word 0xdcadc4a0  ! 1264: STBA_R	stba	%r14, [%r23 + %r0] 0x25
	mov	0x7c8, %r22
	.word 0xdca7a000  ! 1266: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdca7a000  ! 1267: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcaf6000  ! 1268: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdcd72000  ! 1269: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	mov	0x48, %r25
	mov	0x58, %r26
	.word 0xdcbf2000  ! 1272: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 1273: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 1274: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda940400  ! 1275: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	.word 0xdabd84a0  ! 1276: STDA_R	stda	%r13, [%r22 + %r0] 0x25
	.word 0xdaacc400  ! 1277: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0xdab7a000  ! 1278: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdac584a0  ! 1279: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r13
	.word 0xd8c649e0  ! 1280: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r12
	.word 0xd8c76000  ! 1281: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8bfa000  ! 1282: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1283: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d4a000  ! 1284: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	mov	0x7e0, %r22
	mov	0x10, %r24
	.word 0xde8c4400  ! 1287: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	.word 0xdecca000  ! 1288: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	mov	0x3d8, %r20
	mov	0x7f8, %r21
	.word 0xd2f544a0  ! 1291: STXA_R	stxa	%r9, [%r21 + %r0] 0x25
	.word 0xd2dc2000  ! 1292: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r9
	mov	0x7f8, %r22
	.word 0xdc9c8400  ! 1294: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0xd0b70e80  ! 1295: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	mov	0x58, %r17
	mov	0x58, %r26
	.word 0xd0d4c400  ! 1298: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	.word 0xd0c4e000  ! 1299: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	.word 0xd0a4e000  ! 1300: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xdcbfce60  ! 1301: STDA_R	stda	%r14, [%r31 + %r0] 0x73
	.word 0xdabf4e60  ! 1302: STDA_R	stda	%r13, [%r29 + %r0] 0x73
	mov	0x3f8, %r21
	.word 0xdaa4a000  ! 1304: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	mov	0x30, %r24
	.word 0xdac46000  ! 1306: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r13
	mov	0x20, %r16
	.word 0xdaac2000  ! 1308: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0xd6dc4400  ! 1309: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xdcae89e0  ! 1310: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	mov	0x10, %r27
	.word 0xdef4c400  ! 1312: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0x87802072  ! 1313: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd69544a0  ! 1314: LDUHA_R	lduha	[%r21, %r0] 0x25, %r11
	.word 0x8780204f  ! 1315: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f6e000  ! 1316: STXA_I	stxa	%r11, [%r27 + 0x0000] %asi
	mov	0x10, %r25
	.word 0xdac4c400  ! 1318: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r13
	.word 0x8780204f  ! 1319: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 1320: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab72000  ! 1321: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdaf7a000  ! 1322: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdab76000  ! 1323: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 1324: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabde000  ! 1325: STDA_I	stda	%r13, [%r23 + 0x0000] %asi
	.word 0xdac5a000  ! 1326: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r13
	.word 0xd8ae49e0  ! 1327: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0xd6d70e60  ! 1328: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r11
	.word 0xd68d6000  ! 1329: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r11
	.word 0xd6b78e40  ! 1330: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	.word 0xd6a52000  ! 1331: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	.word 0xd687ce80  ! 1332: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r11
	.word 0xdaaf4e60  ! 1333: STBA_R	stba	%r13, [%r29 + %r0] 0x73
	.word 0xdaf5a000  ! 1334: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xda852000  ! 1335: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r13
	.word 0xda956000  ! 1336: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r13
	.word 0xd2bf8e40  ! 1337: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	.word 0xd2cde000  ! 1338: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r9
	.word 0xdcbf4e80  ! 1339: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	.word 0xdad70e40  ! 1340: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r13
	.word 0x87802072  ! 1341: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabf6000  ! 1342: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	mov	0x50, %r17
	.word 0xdadf6000  ! 1344: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xdeb7ce40  ! 1345: STHA_R	stha	%r15, [%r31 + %r0] 0x72
	.word 0xde97e000  ! 1346: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0xdaa70e60  ! 1347: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	.word 0x87802074  ! 1348: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabf2000  ! 1349: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	mov	0x3c8, %r21
	mov	0x60, %r25
	.word 0xdaaf6000  ! 1352: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 1353: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r25
	.word 0x87802072  ! 1355: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda8fe000  ! 1356: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	mov	0x68, %r26
	.word 0xdeacc400  ! 1358: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xdef76000  ! 1359: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdef7e000  ! 1360: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xd685c4a0  ! 1361: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r11
	.word 0xd487ce40  ! 1362: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r10
	mov	0x58, %r25
	mov	0x3c0, %r21
	.word 0xd4a7e000  ! 1365: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 1366: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r19
	mov	0x58, %r27
	.word 0x8780204f  ! 1369: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f40400  ! 1370: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0x87802020  ! 1371: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r22
	mov	0x70, %r25
	.word 0xdaae89e0  ! 1374: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	mov	0x3d8, %r23
	.word 0xdabe89e0  ! 1376: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	.word 0xd69cc400  ! 1377: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	.word 0xd6a4a000  ! 1378: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	.word 0xd6b42000  ! 1379: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0xd6a4e000  ! 1380: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0xd6cce000  ! 1381: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r11
	.word 0x87802072  ! 1382: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6c76000  ! 1383: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xdcc70e40  ! 1384: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r14
	mov	0x8, %r18
	.word 0xd6a7ce80  ! 1386: STWA_R	stwa	%r11, [%r31 + %r0] 0x74
	.word 0x87802025  ! 1387: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c8, %r20
	.word 0xdc9f0e80  ! 1389: LDDA_R	ldda	[%r28, %r0] 0x74, %r14
	.word 0xdccd6000  ! 1390: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r14
	mov	0x3c0, %r20
	.word 0xd8a78e40  ! 1392: STWA_R	stwa	%r12, [%r30 + %r0] 0x72
	.word 0xd88d6000  ! 1393: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r12
	.word 0x87802074  ! 1394: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd88f2000  ! 1395: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0xd8af0e80  ! 1396: STBA_R	stba	%r12, [%r28 + %r0] 0x74
	.word 0xd08ec9e0  ! 1397: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r8
	.word 0xdeae09e0  ! 1398: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	.word 0xdeafa000  ! 1399: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xd8a584a0  ! 1400: STWA_R	stwa	%r12, [%r22 + %r0] 0x25
	.word 0xd0f78e40  ! 1401: STXA_R	stxa	%r8, [%r30 + %r0] 0x72
	.word 0xd6bf4e60  ! 1402: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	.word 0x87802073  ! 1403: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f76000  ! 1404: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0xd6f76000  ! 1406: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6df2000  ! 1407: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	mov	0x60, %r24
	.word 0x87802074  ! 1409: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6bfe000  ! 1410: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 1411: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f52000  ! 1412: STXA_I	stxa	%r11, [%r20 + 0x0000] %asi
	.word 0xd2b7ce60  ! 1413: STHA_R	stha	%r9, [%r31 + %r0] 0x73
	.word 0xd4b689e0  ! 1414: STHA_R	stha	%r10, [%r26 + %r0] 0x4f
	mov	0x18, %r24
	.word 0xd4a52000  ! 1416: STWA_I	stwa	%r10, [%r20 + 0x0000] %asi
	.word 0xd0d44400  ! 1417: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r8
	.word 0xd6ccc400  ! 1418: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	mov	0x0, %r19
	mov	0x28, %r16
	.word 0xdacf4e40  ! 1421: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r13
	.word 0xda8d84a0  ! 1422: LDUBA_R	lduba	[%r22, %r0] 0x25, %r13
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x30, %r18
	.word 0x87802072  ! 1425: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa76000  ! 1426: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xda972000  ! 1427: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0xdcafce60  ! 1428: STBA_R	stba	%r14, [%r31 + %r0] 0x73
	.word 0xdaa48400  ! 1429: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	mov	0x18, %r19
	mov	0x70, %r16
	.word 0xda87a000  ! 1432: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0xdea584a0  ! 1433: STWA_R	stwa	%r15, [%r22 + %r0] 0x25
	.word 0xd0dfce80  ! 1434: LDXA_R	ldxa	[%r31, %r0] 0x74, %r8
	.word 0x87802020  ! 1435: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r26
	.word 0x87802072  ! 1437: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r24
	.word 0xd08f2000  ! 1439: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	.word 0xd0afa000  ! 1440: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xda8dc4a0  ! 1441: LDUBA_R	lduba	[%r23, %r0] 0x25, %r13
	.word 0xdad7e000  ! 1442: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xdaf7e000  ! 1443: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	mov	0x10, %r24
	mov	0x7f8, %r21
	mov	0x68, %r16
	.word 0xda876000  ! 1447: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	mov	0x0, %r27
	.word 0x87802074  ! 1449: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc8e89e0  ! 1450: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r14
	.word 0xdcafa000  ! 1451: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xd29f8e60  ! 1452: LDDA_R	ldda	[%r30, %r0] 0x73, %r9
	.word 0x8780204f  ! 1453: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6948400  ! 1454: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	.word 0xd6bee000  ! 1455: STDA_I	stda	%r11, [%r27 + 0x0000] %asi
	.word 0xda974e60  ! 1456: LDUHA_R	lduha	[%r29, %r0] 0x73, %r13
	.word 0xda8ee000  ! 1457: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r13
	.word 0xdac62000  ! 1458: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r13
	.word 0xda862000  ! 1459: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r13
	.word 0xda8ee000  ! 1460: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r13
	.word 0xdaf6a000  ! 1461: STXA_I	stxa	%r13, [%r26 + 0x0000] %asi
	.word 0xdadea000  ! 1462: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r13
	mov	0x3c0, %r23
	mov	0x58, %r17
	mov	0x30, %r27
	.word 0x87802025  ! 1466: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdab52000  ! 1467: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xdabd2000  ! 1469: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	.word 0xda8de000  ! 1470: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r13
	.word 0x87802074  ! 1471: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r18
	.word 0x87802020  ! 1473: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r26
	.word 0xd8a689e0  ! 1475: STWA_R	stwa	%r12, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 1476: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r24
	.word 0x87802025  ! 1478: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8df0e40  ! 1479: LDXA_R	ldxa	[%r28, %r0] 0x72, %r12
	.word 0xd8dd2000  ! 1480: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r12
	mov	0x50, %r24
	mov	0x3c0, %r20
	.word 0xd08f0e60  ! 1483: LDUBA_R	lduba	[%r28, %r0] 0x73, %r8
	ta	T_CHANGE_HPRIV	! macro
	mov	0x10, %r19
	mov	0x58, %r24
	.word 0x87802020  ! 1487: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r23
	.word 0xdaf5c4a0  ! 1489: STXA_R	stxa	%r13, [%r23 + %r0] 0x25
	.word 0xdaa4a000  ! 1490: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xdac42000  ! 1491: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0xdcc78e40  ! 1492: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r14
	.word 0xdaa48400  ! 1493: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0x87802074  ! 1494: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda9f6000  ! 1495: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xdaac0400  ! 1496: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xdaf72000  ! 1497: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1498: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r20
	mov	0x7c0, %r22
	.word 0xdc848400  ! 1501: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	mov	0x8, %r27
	.word 0x87802073  ! 1503: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f8, %r20
	mov	0x7c8, %r21
	.word 0xdaa6c9e0  ! 1506: STWA_R	stwa	%r13, [%r27 + %r0] 0x4f
	mov	0x10, %r25
	.word 0xdaf72000  ! 1508: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdca48400  ! 1509: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0x87802074  ! 1510: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1511: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r27
	.word 0xd0f74e80  ! 1513: STXA_R	stxa	%r8, [%r29 + %r0] 0x74
	mov	0x3e8, %r22
	.word 0xd0dc2000  ! 1515: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1516: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09ce000  ! 1517: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r8
	.word 0xd6ad44a0  ! 1518: STBA_R	stba	%r11, [%r21 + %r0] 0x25
	.word 0x87802020  ! 1519: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bcc400  ! 1520: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	mov	0x8, %r16
	.word 0xd69e89e0  ! 1522: LDDA_R	ldda	[%r26, %r0] 0x4f, %r11
	.word 0xd6f78e60  ! 1523: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	mov	0x78, %r17
	.word 0x8780204f  ! 1525: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 1526: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd68f6000  ! 1527: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xdef44400  ! 1528: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	mov	0x7c8, %r23
	.word 0xd8cf4e60  ! 1530: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r12
	mov	0x8, %r16
	.word 0xd8b7a000  ! 1532: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xde9fce80  ! 1533: LDDA_R	ldda	[%r31, %r0] 0x74, %r15
	mov	0x7d8, %r23
	mov	0x3c0, %r23
	.word 0xd8b649e0  ! 1536: STHA_R	stha	%r12, [%r25 + %r0] 0x4f
	.word 0x87802072  ! 1537: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r25
	.word 0xd8d7a000  ! 1539: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0xdec504a0  ! 1540: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r15
	.word 0xdca44400  ! 1541: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	mov	0x48, %r27
	.word 0xd8bd04a0  ! 1543: STDA_R	stda	%r12, [%r20 + %r0] 0x25
	mov	0x70, %r26
	.word 0x87802074  ! 1545: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd88fe000  ! 1546: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8f72000  ! 1547: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	mov	0x3e0, %r21
	.word 0x87802020  ! 1549: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1550: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8976000  ! 1551: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0xd6c78e80  ! 1552: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r11
	.word 0xdabd84a0  ! 1553: STDA_R	stda	%r13, [%r22 + %r0] 0x25
	mov	0x68, %r25
	.word 0xd49544a0  ! 1555: LDUHA_R	lduha	[%r21, %r0] 0x25, %r10
	.word 0x87802074  ! 1556: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a78e80  ! 1557: STWA_R	stwa	%r8, [%r30 + %r0] 0x74
	.word 0xd0f7e000  ! 1558: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xda9cc400  ! 1559: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	mov	0x10, %r19
	mov	0x38, %r16
	.word 0x87802073  ! 1562: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdacfa000  ! 1563: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	mov	0x20, %r19
	.word 0xdaa7e000  ! 1565: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xd0d7ce80  ! 1566: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r8
	.word 0x8780204f  ! 1567: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0af8e80  ! 1568: STBA_R	stba	%r8, [%r30 + %r0] 0x74
	.word 0x87802072  ! 1569: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r26
	.word 0xd087a000  ! 1571: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0x87802073  ! 1572: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd09f6000  ! 1573: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	mov	0x7f8, %r21
	mov	0x10, %r24
	mov	0x7c0, %r22
	.word 0xd097e000  ! 1577: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	mov	0x8, %r25
	.word 0xde974e60  ! 1579: LDUHA_R	lduha	[%r29, %r0] 0x73, %r15
	.word 0xdecf6000  ! 1580: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0xde9f6000  ! 1581: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0xdeb7a000  ! 1582: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 1583: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r27
	.word 0xdab48400  ! 1585: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0xdc8f8e40  ! 1586: LDUBA_R	lduba	[%r30, %r0] 0x72, %r14
	mov	0x70, %r18
	.word 0x87802020  ! 1588: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r23
	.word 0xdcd544a0  ! 1590: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r14
	.word 0x8780204f  ! 1591: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r27
	.word 0xdc9e6000  ! 1593: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r14
	.word 0xd8c4c400  ! 1594: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r12
	.word 0xdece49e0  ! 1595: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r15
	.word 0x87802073  ! 1596: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde87e000  ! 1597: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdab78e60  ! 1598: STHA_R	stha	%r13, [%r30 + %r0] 0x73
	mov	0x58, %r16
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2cc0400  ! 1601: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r9
	.word 0xd2bf2000  ! 1602: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 1603: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2cfce60  ! 1604: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r9
	.word 0x8780204f  ! 1605: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f6e000  ! 1606: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	.word 0xd2dee000  ! 1607: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r9
	mov	0x7e8, %r20
	.word 0xd2de2000  ! 1609: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r9
	mov	0x3f8, %r20
	.word 0x87802020  ! 1611: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1612: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad4c400  ! 1613: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0x87802020  ! 1614: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r23
	.word 0xdaac2000  ! 1616: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0xd4bc8400  ! 1617: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	mov	0x48, %r16
	.word 0x8780204f  ! 1619: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r24
	.word 0x8780204f  ! 1621: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd496a000  ! 1622: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r10
	mov	0x40, %r16
	.word 0xd49ea000  ! 1624: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1625: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf44400  ! 1626: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	mov	0x18, %r25
	.word 0xdea7ce40  ! 1628: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	.word 0xd49f4e60  ! 1629: LDDA_R	ldda	[%r29, %r0] 0x73, %r10
	.word 0xd4b42000  ! 1630: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	.word 0xd6bec9e0  ! 1631: STDA_R	stda	%r11, [%r27 + %r0] 0x4f
	.word 0xd6aca000  ! 1632: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802074  ! 1634: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f7e000  ! 1635: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	mov	0x20, %r24
	mov	0x3e8, %r21
	.word 0xd6a48400  ! 1638: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0xd6a76000  ! 1639: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xdadfce80  ! 1640: LDXA_R	ldxa	[%r31, %r0] 0x74, %r13
	.word 0xdcce49e0  ! 1641: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r14
	.word 0xdcb7a000  ! 1642: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xd6af8e60  ! 1643: STBA_R	stba	%r11, [%r30 + %r0] 0x73
	.word 0xd08f8e40  ! 1644: LDUBA_R	lduba	[%r30, %r0] 0x72, %r8
	.word 0xd09fa000  ! 1645: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 1646: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0d62000  ! 1647: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r8
	mov	0x20, %r25
	.word 0xd08544a0  ! 1649: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r8
	.word 0xd0cea000  ! 1650: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r8
	.word 0xd0a6a000  ! 1651: STWA_I	stwa	%r8, [%r26 + 0x0000] %asi
	mov	0x48, %r19
	.word 0xd0b6e000  ! 1653: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	mov	0x7c0, %r20
	mov	0x50, %r19
	.word 0xd0bee000  ! 1656: STDA_I	stda	%r8, [%r27 + 0x0000] %asi
	.word 0xd0dee000  ! 1657: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r8
	.word 0xdea74e40  ! 1658: STWA_R	stwa	%r15, [%r29 + %r0] 0x72
	.word 0xde8ee000  ! 1659: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r15
	mov	0x8, %r16
	.word 0xd6c44400  ! 1661: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r11
	.word 0xd68e2000  ! 1662: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r11
	mov	0x40, %r24
	mov	0x3c0, %r23
	.word 0xd69e6000  ! 1665: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r11
	.word 0x87802072  ! 1666: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x7d8, %r22
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6a76000  ! 1670: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6cf6000  ! 1671: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	mov	0x38, %r16
	mov	0x50, %r27
	.word 0xd6b7a000  ! 1674: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xdccf4e80  ! 1675: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r14
	.word 0xdca7e000  ! 1676: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xd6b44400  ! 1677: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xd4dc8400  ! 1678: LDXA_R	ldxa	[%r18, %r0] 0x20, %r10
	mov	0x78, %r17
	.word 0xde9ec9e0  ! 1680: LDDA_R	ldda	[%r27, %r0] 0x4f, %r15
	mov	0x3d8, %r23
	.word 0xde9f6000  ! 1682: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0xde876000  ! 1683: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xdef7a000  ! 1684: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xd0de09e0  ! 1685: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r8
	mov	0x8, %r24
	.word 0xd6bd44a0  ! 1687: STDA_R	stda	%r11, [%r21 + %r0] 0x25
	.word 0xd0f44400  ! 1688: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd08fe000  ! 1689: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	.word 0xd0d7a000  ! 1690: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0xd0f7e000  ! 1691: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	mov	0x70, %r18
	.word 0xd2c70e60  ! 1693: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r9
	.word 0x87802020  ! 1694: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b46000  ! 1695: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0xd2aca000  ! 1696: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0xd2d46000  ! 1697: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	mov	0x68, %r18
	.word 0xd2a46000  ! 1699: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd284a000  ! 1700: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	.word 0xd2bc2000  ! 1701: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xd2d4e000  ! 1702: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0xd2b42000  ! 1703: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0xd2a46000  ! 1704: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 1705: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2dfa000  ! 1706: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xdcb40400  ! 1707: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xdca76000  ! 1708: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xd8ad04a0  ! 1709: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	.word 0xdcb6c9e0  ! 1710: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	.word 0xde9c8400  ! 1711: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	.word 0xde8f6000  ! 1712: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	.word 0xde8f2000  ! 1713: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xdac40400  ! 1714: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	mov	0x20, %r27
	.word 0xd0ddc4a0  ! 1716: LDXA_R	ldxa	[%r23, %r0] 0x25, %r8
	.word 0x87802020  ! 1717: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f4a000  ! 1718: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xd0d504a0  ! 1719: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r8
	.word 0xd2ac4400  ! 1720: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xdea544a0  ! 1721: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	mov	0x7f0, %r20
	.word 0x87802025  ! 1723: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde8c4400  ! 1724: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	.word 0xde8d6000  ! 1725: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r15
	.word 0xdeb78e40  ! 1726: STHA_R	stha	%r15, [%r30 + %r0] 0x72
	mov	0x48, %r25
	mov	0x8, %r27
	.word 0xdeada000  ! 1729: STBA_I	stba	%r15, [%r22 + 0x0000] %asi
	.word 0xd2bc8400  ! 1730: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	.word 0xd2f52000  ! 1731: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 1732: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 1733: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea48400  ! 1734: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xde942000  ! 1735: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	.word 0xd8974e80  ! 1736: LDUHA_R	lduha	[%r29, %r0] 0x74, %r12
	.word 0xd8846000  ! 1737: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	.word 0xd6afce40  ! 1738: STBA_R	stba	%r11, [%r31 + %r0] 0x72
	mov	0x18, %r27
	mov	0x3d8, %r22
	.word 0xd6ac2000  ! 1741: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	.word 0xdace49e0  ! 1742: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r13
	.word 0xdec584a0  ! 1743: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r15
	ta	T_CHANGE_PRIV	! macro
	.word 0xd6f4c400  ! 1745: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	mov	0x68, %r18
	mov	0x58, %r16
	.word 0xd0d74e80  ! 1748: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r8
	mov	0x70, %r26
	.word 0x87802074  ! 1750: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef544a0  ! 1751: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	.word 0xd4b48400  ! 1752: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd4cf6000  ! 1753: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0xd4872000  ! 1754: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4a7a000  ! 1755: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	mov	0x3e0, %r21
	.word 0x87802074  ! 1757: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 1758: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bcc400  ! 1759: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xd2a6a000  ! 1760: STWA_I	stwa	%r9, [%r26 + 0x0000] %asi
	.word 0xdebc0400  ! 1761: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0xdef6e000  ! 1762: STXA_I	stxa	%r15, [%r27 + 0x0000] %asi
	mov	0x18, %r18
	.word 0xded62000  ! 1764: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r15
	mov	0x60, %r25
	.word 0xd6a70e60  ! 1766: STWA_R	stwa	%r11, [%r28 + %r0] 0x73
	mov	0x7d8, %r20
	.word 0xdad584a0  ! 1768: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r13
	.word 0xd2b7ce40  ! 1769: STHA_R	stha	%r9, [%r31 + %r0] 0x72
	.word 0xdabd44a0  ! 1770: STDA_R	stda	%r13, [%r21 + %r0] 0x25
	mov	0x38, %r19
	.word 0xdabee000  ! 1772: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	.word 0xd0c70e80  ! 1773: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r8
	mov	0x50, %r18
	.word 0x87802072  ! 1775: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6df8e40  ! 1776: LDXA_R	ldxa	[%r30, %r0] 0x72, %r11
	.word 0xd6bfe000  ! 1777: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd68f6000  ! 1778: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xd28f8e60  ! 1779: LDUBA_R	lduba	[%r30, %r0] 0x73, %r9
	.word 0xd0f584a0  ! 1780: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	.word 0xd2bec9e0  ! 1781: STDA_R	stda	%r9, [%r27 + %r0] 0x4f
	.word 0xd287e000  ! 1782: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	mov	0x3e8, %r22
	.word 0xd2944400  ! 1784: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	.word 0x8780204f  ! 1785: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a6e000  ! 1786: STWA_I	stwa	%r9, [%r27 + 0x0000] %asi
	mov	0x28, %r19
	.word 0xd2b66000  ! 1788: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	mov	0x70, %r26
	.word 0xd2a66000  ! 1790: STWA_I	stwa	%r9, [%r25 + 0x0000] %asi
	mov	0x50, %r24
	.word 0x87802074  ! 1792: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2c7e000  ! 1793: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	mov	0x7d8, %r23
	.word 0xd2a76000  ! 1795: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd2b76000  ! 1796: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xdedf0e80  ! 1797: LDXA_R	ldxa	[%r28, %r0] 0x74, %r15
	.word 0xde8f2000  ! 1798: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xd4d4c400  ! 1799: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	mov	0x70, %r24
	.word 0xd4d689e0  ! 1801: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r10
	.word 0xd8cfce80  ! 1802: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r12
	.word 0xd2b7ce40  ! 1803: STHA_R	stha	%r9, [%r31 + %r0] 0x72
	.word 0xd2df2000  ! 1804: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1805: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1806: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1807: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde874e40  ! 1808: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r15
	.word 0xdab48400  ! 1809: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	mov	0x60, %r17
	mov	0x3d8, %r22
	.word 0xdccc8400  ! 1812: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	.word 0xd2ae49e0  ! 1813: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	.word 0xd2aca000  ! 1814: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0xd29e49e0  ! 1815: LDDA_R	ldda	[%r25, %r0] 0x4f, %r9
	.word 0xd2f649e0  ! 1816: STXA_R	stxa	%r9, [%r25 + %r0] 0x4f
	mov	0x3c0, %r23
	.word 0xd2ace000  ! 1818: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0xd2a4e000  ! 1819: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 1820: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 1821: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c8, %r20
	.word 0x87802020  ! 1823: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08f8e80  ! 1824: LDUBA_R	lduba	[%r30, %r0] 0x74, %r8
	.word 0xd0a42000  ! 1825: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	mov	0x48, %r19
	mov	0x28, %r24
	.word 0xd8cc0400  ! 1828: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	.word 0xdadfce40  ! 1829: LDXA_R	ldxa	[%r31, %r0] 0x72, %r13
	mov	0x70, %r27
	mov	0x7c8, %r21
	.word 0xd6ac4400  ! 1832: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0x87802073  ! 1833: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e8, %r21
	mov	0x7f8, %r22
	.word 0xd68fe000  ! 1836: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xd0a70e80  ! 1837: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0xd6c544a0  ! 1838: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r11
	.word 0xdcbc8400  ! 1839: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0x87802072  ! 1840: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdccfa000  ! 1841: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0x87802074  ! 1842: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1843: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r27
	.word 0xd6f6c9e0  ! 1845: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	.word 0xd6cc2000  ! 1846: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	.word 0xdabf4e40  ! 1847: STDA_R	stda	%r13, [%r29 + %r0] 0x72
	.word 0xda9c2000  ! 1848: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	.word 0xdaf46000  ! 1849: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 1850: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r16
	.word 0xd29609e0  ! 1852: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r9
	mov	0x7f8, %r23
	mov	0x48, %r27
	.word 0xd294a000  ! 1855: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r9
	.word 0xd2ace000  ! 1856: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0xd28c6000  ! 1857: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0xd2a46000  ! 1858: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2bce000  ! 1859: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 1860: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a7ce60  ! 1861: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	.word 0xdeaf0e80  ! 1862: STBA_R	stba	%r15, [%r28 + %r0] 0x74
	mov	0x8, %r19
	.word 0xde87a000  ! 1864: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xdc9f8e60  ! 1865: LDDA_R	ldda	[%r30, %r0] 0x73, %r14
	.word 0xdcafa000  ! 1866: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 1867: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb72000  ! 1868: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xdcb76000  ! 1870: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xdcafa000  ! 1871: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xdcf72000  ! 1872: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcdf2000  ! 1873: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	mov	0x7f0, %r23
	.word 0xdcf7a000  ! 1875: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x8, %r17
	mov	0x7c0, %r22
	mov	0x38, %r17
	.word 0xdca7e000  ! 1879: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcde09e0  ! 1880: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r14
	.word 0x87802072  ! 1881: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7c8, %r21
	.word 0xdca76000  ! 1883: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdacc0400  ! 1884: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r13
	mov	0x18, %r19
	mov	0x0, %r26
	.word 0xdaf7e000  ! 1887: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xd4f40400  ! 1888: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0x87802020  ! 1889: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cc6000  ! 1890: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	.word 0xdac40400  ! 1891: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	.word 0x87802020  ! 1892: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeae49e0  ! 1893: STBA_R	stba	%r15, [%r25 + %r0] 0x4f
	.word 0x87802072  ! 1894: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdac584a0  ! 1895: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r13
	.word 0xdaa7a000  ! 1896: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	mov	0x60, %r27
	.word 0x8780204f  ! 1898: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc9f0e80  ! 1899: LDDA_R	ldda	[%r28, %r0] 0x74, %r14
	.word 0xdadf0e80  ! 1900: LDXA_R	ldxa	[%r28, %r0] 0x74, %r13
	.word 0xd8bd04a0  ! 1901: STDA_R	stda	%r12, [%r20 + %r0] 0x25
	.word 0xd89649e0  ! 1902: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r12
	.word 0xd6dc4400  ! 1903: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xd2b48400  ! 1904: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd4a4c400  ! 1905: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0x87802073  ! 1906: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e8, %r21
	.word 0xd4af2000  ! 1908: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xdc8f0e80  ! 1909: LDUBA_R	lduba	[%r28, %r0] 0x74, %r14
	.word 0x87802073  ! 1910: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 1911: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbea000  ! 1912: STDA_I	stda	%r14, [%r26 + 0x0000] %asi
	.word 0xdc9ea000  ! 1913: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r14
	.word 0xdcde6000  ! 1914: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r14
	.word 0x87802025  ! 1915: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdab544a0  ! 1916: STHA_R	stha	%r13, [%r21 + %r0] 0x25
	mov	0x7d0, %r22
	.word 0xdac5e000  ! 1918: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r13
	mov	0x7e0, %r22
	.word 0xdccf0e40  ! 1920: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r14
	.word 0xd4978e40  ! 1921: LDUHA_R	lduha	[%r30, %r0] 0x72, %r10
	.word 0x87802073  ! 1922: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8870e60  ! 1923: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r12
	mov	0x30, %r27
	.word 0xd8dfa000  ! 1925: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	mov	0x18, %r16
	.word 0xd8a7a000  ! 1927: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	mov	0x18, %r26
	mov	0x3c8, %r20
	.word 0xd8afe000  ! 1930: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd8cf2000  ! 1931: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0xd8b76000  ! 1932: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1933: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8dc6000  ! 1935: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	mov	0x38, %r18
	mov	0x38, %r24
	.word 0xd4cc4400  ! 1938: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r10
	.word 0xd0ce49e0  ! 1939: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r8
	.word 0xdcf504a0  ! 1940: STXA_R	stxa	%r14, [%r20 + %r0] 0x25
	.word 0xdcd4a000  ! 1941: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	.word 0xdcf4e000  ! 1942: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	mov	0x7e0, %r21
	mov	0x68, %r27
	.word 0xd0cf4e60  ! 1945: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r8
	.word 0x87802074  ! 1946: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 1947: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0aea000  ! 1948: STBA_I	stba	%r8, [%r26 + 0x0000] %asi
	.word 0xd88e89e0  ! 1949: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r12
	.word 0x8780204f  ! 1950: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbc8400  ! 1951: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xdcbee000  ! 1952: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	.word 0xdcd6a000  ! 1953: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r14
	.word 0xded78e40  ! 1954: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r15
	.word 0xdec6a000  ! 1955: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r15
	.word 0xdec6a000  ! 1956: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r15
	.word 0xde9e2000  ! 1957: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r15
	.word 0xdec48400  ! 1958: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	.word 0xdede6000  ! 1959: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r15
	.word 0xd6bcc400  ! 1960: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0xd6f66000  ! 1961: STXA_I	stxa	%r11, [%r25 + 0x0000] %asi
	mov	0x3c0, %r21
	mov	0x58, %r24
	mov	0x48, %r24
	.word 0xd2f6c9e0  ! 1965: STXA_R	stxa	%r9, [%r27 + %r0] 0x4f
	.word 0xd2af4e60  ! 1966: STBA_R	stba	%r9, [%r29 + %r0] 0x73
	mov	0x10, %r24
	mov	0x7c0, %r21
	mov	0x20, %r16
	mov	0x20, %r16
	mov	0x60, %r27
	.word 0xd2962000  ! 1972: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r9
	mov	0x28, %r18
	.word 0xd096c9e0  ! 1974: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r8
	.word 0x87802074  ! 1975: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0df6000  ! 1976: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	mov	0x78, %r18
	.word 0xdebc4400  ! 1978: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0xd8d4c400  ! 1979: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0xd2af0e60  ! 1980: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	.word 0x87802073  ! 1981: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r18
	mov	0x50, %r17
	.word 0xdcd78e80  ! 1984: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r14
	.word 0xdcbfce80  ! 1985: STDA_R	stda	%r14, [%r31 + %r0] 0x74
	.word 0xdcb76000  ! 1986: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 1987: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca5a000  ! 1988: STWA_I	stwa	%r14, [%r22 + 0x0000] %asi
	mov	0x7f0, %r23
	mov	0x30, %r19
	.word 0xdedcc400  ! 1991: LDXA_R	ldxa	[%r19, %r0] 0x20, %r15
	mov	0x0, %r24
	.word 0x87802020  ! 1993: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded46000  ! 1994: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	.word 0xdccd04a0  ! 1995: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r14
	.word 0xdcdce000  ! 1996: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r14
	.word 0xd4848400  ! 1997: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r10
	.word 0xd4942000  ! 1998: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r10
	.word 0xdebe89e0  ! 1999: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	.word 0xdea4e000  ! 2000: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xde842000  ! 2001: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	.word 0xd0acc400  ! 2002: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd6b48400  ! 2003: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0x87802073  ! 2004: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd49d84a0  ! 2005: LDDA_R	ldda	[%r22, %r0] 0x25, %r10
	.word 0xd4dfa000  ! 2006: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4af2000  ! 2007: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd2f78e60  ! 2008: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0x87802074  ! 2009: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d8, %r21
	.word 0x87802020  ! 2011: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a4e000  ! 2012: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	mov	0x7c0, %r20
	.word 0xd29ca000  ! 2014: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	mov	0x7c0, %r21
	mov	0x70, %r25
	mov	0x10, %r19
	.word 0xd2a42000  ! 2018: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	mov	0x58, %r18
	.word 0xd8c48400  ! 2020: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	.word 0xd2bf8e40  ! 2021: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	mov	0x10, %r26
	.word 0xd2c46000  ! 2023: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2024: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28f6000  ! 2025: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd2a544a0  ! 2026: STWA_R	stwa	%r9, [%r21 + %r0] 0x25
	.word 0xd48f4e80  ! 2027: LDUBA_R	lduba	[%r29, %r0] 0x74, %r10
	.word 0xd4bfa000  ! 2028: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	mov	0x50, %r19
	mov	0x7f0, %r23
	mov	0x8, %r25
	.word 0xd8c70e60  ! 2032: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r12
	mov	0x28, %r18
	.word 0x87802073  ! 2034: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8bfa000  ! 2035: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	mov	0x78, %r16
	.word 0xd8bfa000  ! 2037: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xd8872000  ! 2039: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8c72000  ! 2040: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802074  ! 2042: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r16
	.word 0xd8df2000  ! 2044: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8af0e40  ! 2045: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	.word 0xd8a7a000  ! 2046: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	mov	0x0, %r16
	.word 0x87802073  ! 2048: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 2049: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e0, %r22
	mov	0x20, %r24
	.word 0xd8a6a000  ! 2052: STWA_I	stwa	%r12, [%r26 + 0x0000] %asi
	.word 0xd8b66000  ! 2053: STHA_I	stha	%r12, [%r25 + 0x0000] %asi
	mov	0x3d8, %r20
	mov	0x68, %r26
	.word 0xd8f78e60  ! 2056: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	.word 0xd4f70e40  ! 2057: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	mov	0x10, %r26
	.word 0xd88ec9e0  ! 2059: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r12
	.word 0xdccfce40  ! 2060: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r14
	.word 0xd2bdc4a0  ! 2061: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	.word 0x87802025  ! 2062: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc848400  ! 2063: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	.word 0xdcf5e000  ! 2064: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 2065: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb5e000  ! 2066: STHA_I	stha	%r14, [%r23 + 0x0000] %asi
	.word 0xdcf78e40  ! 2067: STXA_R	stxa	%r14, [%r30 + %r0] 0x72
	.word 0x87802072  ! 2068: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcaf6000  ! 2069: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdcf72000  ! 2070: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcd7e000  ! 2071: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xd0a40400  ! 2072: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0xd6cc4400  ! 2073: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	.word 0xd697a000  ! 2074: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	mov	0x3d8, %r22
	mov	0x10, %r27
	.word 0xd6df0e40  ! 2077: LDXA_R	ldxa	[%r28, %r0] 0x72, %r11
	.word 0xd6b72000  ! 2078: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd2f44400  ! 2079: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	.word 0xd2976000  ! 2080: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0xd2df6000  ! 2081: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	mov	0x7f8, %r22
	mov	0x78, %r16
	.word 0xd2a7e000  ! 2084: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xd2d76000  ! 2085: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0xd2af6000  ! 2086: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd2bfa000  ! 2087: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd8bf4e60  ! 2088: STDA_R	stda	%r12, [%r29 + %r0] 0x73
	.word 0xd8bf6000  ! 2089: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 2090: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2bf8e60  ! 2091: STDA_R	stda	%r9, [%r30 + %r0] 0x73
	.word 0xd0afce40  ! 2092: STBA_R	stba	%r8, [%r31 + %r0] 0x72
	mov	0x50, %r16
	.word 0x87802025  ! 2094: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4a78e80  ! 2095: STWA_R	stwa	%r10, [%r30 + %r0] 0x74
	.word 0xd6dec9e0  ! 2096: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r11
	.word 0xd0f40400  ! 2097: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xd0f52000  ! 2098: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	.word 0xdec4c400  ! 2099: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	.word 0xda8e89e0  ! 2100: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r13
	.word 0xd6aec9e0  ! 2101: STBA_R	stba	%r11, [%r27 + %r0] 0x4f
	.word 0xd08e89e0  ! 2102: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r8
	.word 0x87802072  ! 2103: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 2104: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f62000  ! 2105: STXA_I	stxa	%r8, [%r24 + 0x0000] %asi
	mov	0x38, %r16
	.word 0xd0aea000  ! 2107: STBA_I	stba	%r8, [%r26 + 0x0000] %asi
	.word 0xda9c4400  ! 2108: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	.word 0xdcf4c400  ! 2109: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xd89649e0  ! 2110: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r12
	.word 0xd8c62000  ! 2111: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r12
	.word 0x87802025  ! 2112: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r24
	.word 0xd8d5e000  ! 2114: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r12
	mov	0x48, %r24
	.word 0xd8d5a000  ! 2116: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2117: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d42000  ! 2118: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 2119: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8f6a000  ! 2120: STXA_I	stxa	%r12, [%r26 + 0x0000] %asi
	mov	0x60, %r17
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0bd44a0  ! 2123: STDA_R	stda	%r8, [%r21 + %r0] 0x25
	.word 0xdc94c400  ! 2124: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	mov	0x7c0, %r20
	.word 0x8780204f  ! 2126: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdca6a000  ! 2127: STWA_I	stwa	%r14, [%r26 + 0x0000] %asi
	.word 0xd0f609e0  ! 2128: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	.word 0xd0a66000  ! 2129: STWA_I	stwa	%r8, [%r25 + 0x0000] %asi
	mov	0x3e0, %r23
	mov	0x38, %r25
	.word 0xd0c66000  ! 2132: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r8
	.word 0xd0dea000  ! 2133: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r8
	.word 0xd0ce09e0  ! 2134: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r8
	.word 0x87802025  ! 2135: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0cd2000  ! 2136: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r8
	.word 0xd0f5a000  ! 2137: STXA_I	stxa	%r8, [%r22 + 0x0000] %asi
	.word 0xdcac8400  ! 2138: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xd68d04a0  ! 2139: LDUBA_R	lduba	[%r20, %r0] 0x25, %r11
	mov	0x50, %r26
	.word 0xd68d6000  ! 2141: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r11
	mov	0x40, %r18
	.word 0xd29c8400  ! 2143: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	.word 0xd8bfce60  ! 2144: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	.word 0xd8a56000  ! 2145: STWA_I	stwa	%r12, [%r21 + 0x0000] %asi
	.word 0xdebf4e80  ! 2146: STDA_R	stda	%r15, [%r29 + %r0] 0x74
	.word 0xd8f4c400  ! 2147: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xd8cde000  ! 2148: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r12
	mov	0x3d8, %r23
	.word 0xd8c56000  ! 2150: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r12
	.word 0xd8f5e000  ! 2151: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	.word 0xd8852000  ! 2152: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r12
	mov	0x50, %r25
	mov	0x7c0, %r23
	.word 0x87802020  ! 2155: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c4e000  ! 2156: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	.word 0xd8a4e000  ! 2157: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xd8ace000  ! 2158: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0xda978e60  ! 2159: LDUHA_R	lduha	[%r30, %r0] 0x73, %r13
	.word 0xdaace000  ! 2160: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 2161: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa42000  ! 2162: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0xdab4e000  ! 2163: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xdca689e0  ! 2164: STWA_R	stwa	%r14, [%r26 + %r0] 0x4f
	.word 0xda974e80  ! 2165: LDUHA_R	lduha	[%r29, %r0] 0x74, %r13
	.word 0x87802074  ! 2166: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r17
	.word 0xdaafa000  ! 2168: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	mov	0x58, %r16
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdabfe000  ! 2171: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xd4944400  ! 2172: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	mov	0x18, %r17
	mov	0x7e0, %r22
	mov	0x7e8, %r20
	.word 0x87802074  ! 2176: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f7a000  ! 2177: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xde8c8400  ! 2178: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	.word 0xd8d78e80  ! 2179: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r12
	.word 0xd88fa000  ! 2180: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	mov	0x3d8, %r20
	.word 0xdcbec9e0  ! 2182: STDA_R	stda	%r14, [%r27 + %r0] 0x4f
	.word 0xdcb76000  ! 2183: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0x8780204f  ! 2185: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 2186: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcdfe000  ! 2187: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcbfe000  ! 2188: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdca7ce80  ! 2189: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	mov	0x28, %r24
	.word 0x87802072  ! 2191: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbf2000  ! 2192: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 2193: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde9649e0  ! 2194: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r15
	.word 0xdeb6a000  ! 2195: STHA_I	stha	%r15, [%r26 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0x8780204f  ! 2197: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r18
	mov	0x7c0, %r21
	mov	0x7e8, %r23
	.word 0xd0ad04a0  ! 2201: STBA_R	stba	%r8, [%r20 + %r0] 0x25
	mov	0x3e8, %r20
	.word 0xd0f62000  ! 2203: STXA_I	stxa	%r8, [%r24 + 0x0000] %asi
	mov	0x18, %r19
	.word 0x87802025  ! 2205: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabf0e60  ! 2206: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	.word 0xdaf5e000  ! 2207: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0xd8940400  ! 2208: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	mov	0x18, %r24
	.word 0x8780204f  ! 2210: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8962000  ! 2211: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2212: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccd84a0  ! 2213: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r14
	.word 0x87802020  ! 2214: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2215: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa584a0  ! 2216: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	.word 0x87802073  ! 2217: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r18
	.word 0xdab72000  ! 2219: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xd885c4a0  ! 2220: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r12
	.word 0xd6ce89e0  ! 2221: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r11
	.word 0x87802020  ! 2222: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0c78e80  ! 2223: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r8
	.word 0xd4cf4e40  ! 2224: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r10
	.word 0xd4a44400  ! 2225: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xd4cce000  ! 2226: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	.word 0xd4ac2000  ! 2227: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0xd0f78e80  ! 2228: STXA_R	stxa	%r8, [%r30 + %r0] 0x74
	.word 0x87802025  ! 2229: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd095a000  ! 2230: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r8
	mov	0x10, %r25
	mov	0x78, %r27
	.word 0xdac40400  ! 2233: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	mov	0x78, %r27
	.word 0xd4bf0e80  ! 2235: STDA_R	stda	%r10, [%r28 + %r0] 0x74
	.word 0x87802025  ! 2236: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4f5a000  ! 2237: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xd4ada000  ! 2239: STBA_I	stba	%r10, [%r22 + 0x0000] %asi
	.word 0xd4c5e000  ! 2240: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r10
	.word 0xd4ada000  ! 2241: STBA_I	stba	%r10, [%r22 + 0x0000] %asi
	mov	0x28, %r16
	mov	0x78, %r26
	.word 0xd49da000  ! 2244: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r10
	.word 0xd485e000  ! 2245: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r10
	.word 0xd6f6c9e0  ! 2246: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	.word 0x87802072  ! 2247: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca4c400  ! 2248: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	mov	0x0, %r26
	mov	0x0, %r24
	mov	0x0, %r25
	.word 0xd0af0e80  ! 2252: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	.word 0x87802020  ! 2253: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bf0e40  ! 2254: STDA_R	stda	%r12, [%r28 + %r0] 0x72
	.word 0xd2970e60  ! 2255: LDUHA_R	lduha	[%r28, %r0] 0x73, %r9
	.word 0xd2bc2000  ! 2256: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	mov	0x20, %r26
	.word 0x87802025  ! 2258: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2d5a000  ! 2259: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r9
	.word 0xd285a000  ! 2260: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r9
	.word 0xd8c48400  ! 2261: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	.word 0xd8856000  ! 2262: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	.word 0xd8af8e80  ! 2263: STBA_R	stba	%r12, [%r30 + %r0] 0x74
	.word 0xd8b5e000  ! 2264: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	.word 0xd8a48400  ! 2265: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	mov	0x3e8, %r20
	.word 0xd8bd6000  ! 2267: STDA_I	stda	%r12, [%r21 + 0x0000] %asi
	.word 0xd89da000  ! 2268: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r12
	.word 0xd8d56000  ! 2269: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r12
	.word 0xdcc40400  ! 2270: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	.word 0xdcade000  ! 2271: STBA_I	stba	%r14, [%r23 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0x8780204f  ! 2273: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r17
	.word 0xdabc0400  ! 2275: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xd6acc400  ! 2276: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xd686e000  ! 2277: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r11
	.word 0xd6ae2000  ! 2278: STBA_I	stba	%r11, [%r24 + 0x0000] %asi
	.word 0xd6a66000  ! 2279: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	mov	0x48, %r25
	.word 0xd09d44a0  ! 2281: LDDA_R	ldda	[%r21, %r0] 0x25, %r8
	.word 0xd0c6e000  ! 2282: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r8
	mov	0x68, %r18
	.word 0xd0b70e60  ! 2284: STHA_R	stha	%r8, [%r28 + %r0] 0x73
	.word 0xd086a000  ! 2285: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r8
	.word 0x87802025  ! 2286: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 2287: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c8, %r20
	.word 0xd6f609e0  ! 2289: STXA_R	stxa	%r11, [%r24 + %r0] 0x4f
	.word 0xd4df0e80  ! 2290: LDXA_R	ldxa	[%r28, %r0] 0x74, %r10
	.word 0xd4a66000  ! 2291: STWA_I	stwa	%r10, [%r25 + 0x0000] %asi
	.word 0xd4ce6000  ! 2292: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r10
	.word 0xd89584a0  ! 2293: LDUHA_R	lduha	[%r22, %r0] 0x25, %r12
	.word 0xdadf0e60  ! 2294: LDXA_R	ldxa	[%r28, %r0] 0x73, %r13
	.word 0x87802025  ! 2295: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc8cc400  ! 2296: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	.word 0xdc944400  ! 2297: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	mov	0x28, %r27
	mov	0x58, %r27
	.word 0xd6974e40  ! 2300: LDUHA_R	lduha	[%r29, %r0] 0x72, %r11
	.word 0xd49f8e80  ! 2301: LDDA_R	ldda	[%r30, %r0] 0x74, %r10
	.word 0xd4b5e000  ! 2302: STHA_I	stha	%r10, [%r23 + 0x0000] %asi
	.word 0xd4ade000  ! 2303: STBA_I	stba	%r10, [%r23 + 0x0000] %asi
	.word 0xd4956000  ! 2304: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r10
	.word 0xd6bec9e0  ! 2305: STDA_R	stda	%r11, [%r27 + %r0] 0x4f
	.word 0xd6b5e000  ! 2306: STHA_I	stha	%r11, [%r23 + 0x0000] %asi
	.word 0xd6956000  ! 2307: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r11
	.word 0xd0a74e60  ! 2308: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	.word 0xd0cde000  ! 2309: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r8
	.word 0x87802073  ! 2310: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f78e60  ! 2311: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	.word 0xd28f0e80  ! 2312: LDUBA_R	lduba	[%r28, %r0] 0x74, %r9
	.word 0xd6c504a0  ! 2313: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r11
	.word 0xd6b7e000  ! 2314: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd487ce40  ! 2315: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r10
	.word 0xdea544a0  ! 2316: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	.word 0xdea7a000  ! 2317: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xdecfe000  ! 2318: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	mov	0x68, %r27
	.word 0xd8ac8400  ! 2320: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0xd8872000  ! 2321: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	mov	0x10, %r17
	.word 0xd0dd44a0  ! 2323: LDXA_R	ldxa	[%r21, %r0] 0x25, %r8
	.word 0x87802025  ! 2324: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f56000  ! 2325: STXA_I	stxa	%r8, [%r21 + 0x0000] %asi
	.word 0xd0b56000  ! 2326: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	.word 0xd0f52000  ! 2327: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	mov	0x7c8, %r22
	.word 0xde9e89e0  ! 2329: LDDA_R	ldda	[%r26, %r0] 0x4f, %r15
	mov	0x7f0, %r21
	.word 0x87802072  ! 2331: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r18
	mov	0x3e0, %r23
	.word 0xdedf2000  ! 2334: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xdef7e000  ! 2335: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xd2bd44a0  ! 2336: STDA_R	stda	%r9, [%r21 + %r0] 0x25
	mov	0x3e0, %r20
	mov	0x78, %r19
	.word 0xd2af2000  ! 2339: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd2a7a000  ! 2340: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	mov	0x3e0, %r20
	mov	0x3f0, %r22
	.word 0xd0a584a0  ! 2343: STWA_R	stwa	%r8, [%r22 + %r0] 0x25
	.word 0xd0872000  ! 2344: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	mov	0x58, %r16
	mov	0x7f8, %r23
	.word 0xd6844400  ! 2347: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r11
	.word 0xded70e60  ! 2348: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r15
	.word 0xdec76000  ! 2349: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0x87802073  ! 2350: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 2351: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2352: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebce000  ! 2353: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xd0b78e80  ! 2354: STHA_R	stha	%r8, [%r30 + %r0] 0x74
	.word 0xdaaf0e40  ! 2355: STBA_R	stba	%r13, [%r28 + %r0] 0x72
	.word 0x87802072  ! 2356: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcafce40  ! 2357: STBA_R	stba	%r14, [%r31 + %r0] 0x72
	.word 0xd0f48400  ! 2358: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	mov	0x40, %r27
	.word 0xd4bc0400  ! 2360: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xd48f2000  ! 2361: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd497a000  ! 2362: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	mov	0x40, %r24
	mov	0x7f0, %r22
	.word 0xdecc0400  ! 2365: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r15
	.word 0x87802072  ! 2366: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r24
	.word 0x87802074  ! 2368: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeb7e000  ! 2369: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xd88fce40  ! 2370: LDUBA_R	lduba	[%r31, %r0] 0x72, %r12
	.word 0xd89f2000  ! 2371: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0xd89f2000  ! 2372: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2373: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r18
	.word 0xd8b4e000  ! 2375: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0xda9fce80  ! 2376: LDDA_R	ldda	[%r31, %r0] 0x74, %r13
	.word 0xdaaca000  ! 2377: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0xd4bc4400  ! 2378: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	mov	0x40, %r19
	.word 0xd4b4a000  ! 2380: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0xd4f4e000  ! 2381: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0xde8c8400  ! 2382: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	.word 0xd28f4e40  ! 2383: LDUBA_R	lduba	[%r29, %r0] 0x72, %r9
	mov	0x3e8, %r22
	.word 0xd69fce40  ! 2385: LDDA_R	ldda	[%r31, %r0] 0x72, %r11
	mov	0x7d0, %r21
	mov	0x0, %r27
	.word 0xd4848400  ! 2388: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r10
	.word 0x87802020  ! 2389: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r20
	.word 0x87802072  ! 2391: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3e0, %r20
	mov	0x28, %r18
	.word 0xd4df2000  ! 2394: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0xd2b584a0  ! 2395: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0x8780204f  ! 2396: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 2397: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b7e000  ! 2398: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 2399: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bde000  ! 2400: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd285a000  ! 2402: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r9
	.word 0xd0f70e80  ! 2403: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	mov	0x38, %r25
	.word 0xd08d2000  ! 2405: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r8
	.word 0xdcc78e80  ! 2406: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r14
	mov	0x70, %r25
	.word 0xd4ac4400  ! 2408: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xd8af4e80  ! 2409: STBA_R	stba	%r12, [%r29 + %r0] 0x74
	.word 0xd88d2000  ! 2410: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r12
	.word 0xdecfce40  ! 2411: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r15
	mov	0x78, %r26
	.word 0xdea52000  ! 2413: STWA_I	stwa	%r15, [%r20 + 0x0000] %asi
	mov	0x78, %r27
	.word 0xd6ad04a0  ! 2415: STBA_R	stba	%r11, [%r20 + %r0] 0x25
	.word 0xd2a78e80  ! 2416: STWA_R	stwa	%r9, [%r30 + %r0] 0x74
	mov	0x58, %r24
	.word 0x87802020  ! 2418: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r17
	.word 0xdead84a0  ! 2420: STBA_R	stba	%r15, [%r22 + %r0] 0x25
	mov	0x38, %r16
	.word 0xde94a000  ! 2422: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0xdeaca000  ! 2423: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xdab78e60  ! 2424: STHA_R	stha	%r13, [%r30 + %r0] 0x73
	.word 0x87802020  ! 2425: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r21
	.word 0xdac42000  ! 2427: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0x87802073  ! 2428: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c8, %r22
	mov	0x3d8, %r21
	.word 0xde9fce40  ! 2431: LDDA_R	ldda	[%r31, %r0] 0x72, %r15
	.word 0xdebf2000  ! 2432: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xdef7e000  ! 2433: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 2434: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 2435: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r19
	.word 0x87802073  ! 2437: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2438: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r27
	.word 0x87802074  ! 2440: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdebf6000  ! 2441: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xd6a6c9e0  ! 2442: STWA_R	stwa	%r11, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 2443: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r26
	.word 0xde9f4e80  ! 2445: LDDA_R	ldda	[%r29, %r0] 0x74, %r15
	.word 0xdeac6000  ! 2446: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xdadd04a0  ! 2447: LDXA_R	ldxa	[%r20, %r0] 0x25, %r13
	.word 0xd8848400  ! 2448: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r12
	.word 0xd8bca000  ! 2449: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd2b649e0  ! 2450: STHA_R	stha	%r9, [%r25 + %r0] 0x4f
	mov	0x68, %r27
	mov	0x70, %r24
	.word 0xd2b42000  ! 2453: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 2454: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2455: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r26
	.word 0x87802020  ! 2457: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2458: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2d72000  ! 2459: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xdc8f0e80  ! 2460: LDUBA_R	lduba	[%r28, %r0] 0x74, %r14
	.word 0xdaacc400  ! 2461: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0xda87a000  ! 2462: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	mov	0x60, %r24
	.word 0xdab7e000  ! 2464: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xdab70e80  ! 2465: STHA_R	stha	%r13, [%r28 + %r0] 0x74
	mov	0x7d0, %r21
	mov	0x58, %r16
	.word 0x87802025  ! 2468: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8d2000  ! 2469: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r13
	.word 0xd2b78e80  ! 2470: STHA_R	stha	%r9, [%r30 + %r0] 0x74
	.word 0xd29d6000  ! 2471: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r9
	.word 0xd8acc400  ! 2472: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0xdadcc400  ! 2473: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xd2ac4400  ! 2474: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xdc844400  ! 2475: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	.word 0x8780204f  ! 2476: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 2477: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b7ce60  ! 2478: STHA_R	stha	%r10, [%r31 + %r0] 0x73
	.word 0xd4d7e000  ! 2479: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	mov	0x60, %r26
	mov	0x0, %r19
	.word 0xdacfce40  ! 2482: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r13
	.word 0xda97e000  ! 2483: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	.word 0xdaf504a0  ! 2484: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	.word 0xdabf2000  ! 2485: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2486: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bc4400  ! 2487: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0xd4dc2000  ! 2488: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	.word 0xd4a42000  ! 2489: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0xdab74e40  ! 2490: STHA_R	stha	%r13, [%r29 + %r0] 0x72
	mov	0x40, %r17
	.word 0xd0c48400  ! 2492: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r8
	mov	0x18, %r18
	.word 0xd084e000  ! 2494: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	.word 0xdad504a0  ! 2495: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r13
	.word 0xdeac0400  ! 2496: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xde8ce000  ! 2497: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	.word 0xd2d74e80  ! 2498: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r9
	mov	0x10, %r18
	.word 0x87802072  ! 2500: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r19
	.word 0xd2df2000  ! 2502: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2503: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2c76000  ! 2504: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0x87802025  ! 2505: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcdf0e60  ! 2506: LDXA_R	ldxa	[%r28, %r0] 0x73, %r14
	.word 0xdcd74e40  ! 2507: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r14
	mov	0x28, %r27
	.word 0xdca5a000  ! 2509: STWA_I	stwa	%r14, [%r22 + 0x0000] %asi
	mov	0x7d0, %r22
	.word 0xdedd04a0  ! 2511: LDXA_R	ldxa	[%r20, %r0] 0x25, %r15
	.word 0x8780204f  ! 2512: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r16
	.word 0xdeb62000  ! 2514: STHA_I	stha	%r15, [%r24 + 0x0000] %asi
	mov	0x48, %r27
	.word 0xdcf74e80  ! 2516: STXA_R	stxa	%r14, [%r29 + %r0] 0x74
	mov	0x10, %r25
	.word 0xdcbea000  ! 2518: STDA_I	stda	%r14, [%r26 + 0x0000] %asi
	.word 0xdcb6c9e0  ! 2519: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	.word 0xd8b6c9e0  ! 2520: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	mov	0x78, %r19
	.word 0xde97ce80  ! 2522: LDUHA_R	lduha	[%r31, %r0] 0x74, %r15
	.word 0xdcb74e60  ! 2523: STHA_R	stha	%r14, [%r29 + %r0] 0x73
	mov	0x50, %r24
	mov	0x7d0, %r23
	.word 0x87802072  ! 2526: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca76000  ! 2527: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdccf2000  ! 2528: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xdca72000  ! 2529: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcbf2000  ! 2530: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	mov	0x28, %r17
	.word 0x87802020  ! 2532: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2533: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6c649e0  ! 2534: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r11
	.word 0x87802020  ! 2535: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2536: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6dca000  ! 2537: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r11
	.word 0xd6a4a000  ! 2538: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	.word 0xda94c400  ! 2539: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	.word 0xdaa4a000  ! 2540: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 2541: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf74e60  ! 2542: STXA_R	stxa	%r13, [%r29 + %r0] 0x73
	.word 0xda9f2000  ! 2543: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xd8bfce40  ! 2544: STDA_R	stda	%r12, [%r31 + %r0] 0x72
	mov	0x48, %r26
	.word 0x87802020  ! 2546: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc8f4e40  ! 2547: LDUBA_R	lduba	[%r29, %r0] 0x72, %r14
	.word 0xdcdca000  ! 2548: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xdcb4e000  ! 2549: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xd295c4a0  ! 2550: LDUHA_R	lduha	[%r23, %r0] 0x25, %r9
	.word 0xd2d4e000  ! 2551: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2552: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88d84a0  ! 2553: LDUBA_R	lduba	[%r22, %r0] 0x25, %r12
	.word 0xd8840400  ! 2554: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r12
	.word 0xd8be89e0  ! 2555: STDA_R	stda	%r12, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 2556: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f7a000  ! 2557: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd2bf4e60  ! 2558: STDA_R	stda	%r9, [%r29 + %r0] 0x73
	.word 0xd6944400  ! 2559: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	.word 0xd6afa000  ! 2560: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 2561: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 2562: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 2563: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f649e0  ! 2564: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	.word 0xd0f584a0  ! 2565: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	.word 0x87802074  ! 2566: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r17
	.word 0xd0c7e000  ! 2568: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0xd4b7ce80  ! 2569: STHA_R	stha	%r10, [%r31 + %r0] 0x74
	.word 0xd4d7e000  ! 2570: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	.word 0xd2ccc400  ! 2571: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	.word 0xd2dfa000  ! 2572: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2b76000  ! 2573: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd0cfce40  ! 2574: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r8
	.word 0xd0b7a000  ! 2575: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 2576: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0856000  ! 2577: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r8
	mov	0x3e0, %r23
	mov	0x78, %r16
	mov	0x10, %r24
	.word 0xd0852000  ! 2581: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r8
	.word 0xd08d6000  ! 2582: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r8
	.word 0xd8a78e60  ! 2583: STWA_R	stwa	%r12, [%r30 + %r0] 0x73
	.word 0xd2f78e80  ! 2584: STXA_R	stxa	%r9, [%r30 + %r0] 0x74
	.word 0xd6b44400  ! 2585: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	mov	0x3f8, %r23
	.word 0xd8d4c400  ! 2587: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0xd8f56000  ! 2588: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	.word 0xdebd44a0  ! 2589: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	.word 0x87802074  ! 2590: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r19
	.word 0x87802074  ! 2592: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde8fa000  ! 2593: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 2594: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2595: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2596: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r17
	.word 0x8780204f  ! 2598: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2cf4e40  ! 2599: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r9
	.word 0xd2b6e000  ! 2600: STHA_I	stha	%r9, [%r27 + 0x0000] %asi
	.word 0x87802074  ! 2601: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2602: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4be49e0  ! 2603: STDA_R	stda	%r10, [%r25 + %r0] 0x4f
	.word 0xdcf78e40  ! 2604: STXA_R	stxa	%r14, [%r30 + %r0] 0x72
	mov	0x78, %r24
	mov	0x10, %r24
	.word 0xdcf7a000  ! 2607: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x7c8, %r21
	.word 0xdcc7e000  ! 2609: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcc7a000  ! 2610: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	mov	0x7f0, %r20
	.word 0xd2a48400  ! 2612: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0xd2f7a000  ! 2613: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 2614: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f0, %r21
	mov	0x7f8, %r20
	.word 0xd6f7ce60  ! 2617: STXA_R	stxa	%r11, [%r31 + %r0] 0x73
	.word 0xd6a7ce60  ! 2618: STWA_R	stwa	%r11, [%r31 + %r0] 0x73
	mov	0x8, %r24
	.word 0xd6aee000  ! 2620: STBA_I	stba	%r11, [%r27 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x28, %r18
	.word 0xd6aea000  ! 2623: STBA_I	stba	%r11, [%r26 + 0x0000] %asi
	.word 0xd6966000  ! 2624: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r11
	.word 0xd6f66000  ! 2625: STXA_I	stxa	%r11, [%r25 + 0x0000] %asi
	.word 0xd29f4e80  ! 2626: LDDA_R	ldda	[%r29, %r0] 0x74, %r9
	.word 0xd2aea000  ! 2627: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0xd88f8e40  ! 2628: LDUBA_R	lduba	[%r30, %r0] 0x72, %r12
	.word 0xd8f6e000  ! 2629: STXA_I	stxa	%r12, [%r27 + 0x0000] %asi
	.word 0xd0844400  ! 2630: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r8
	mov	0x78, %r16
	.word 0xdaa4c400  ! 2632: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0x87802073  ! 2633: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r26
	mov	0x3e8, %r20
	.word 0x8780204f  ! 2636: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8cf4e40  ! 2637: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r12
	.word 0xd8aea000  ! 2638: STBA_I	stba	%r12, [%r26 + 0x0000] %asi
	.word 0xd8b6a000  ! 2639: STHA_I	stha	%r12, [%r26 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xdcaf8e40  ! 2641: STBA_R	stba	%r14, [%r30 + %r0] 0x72
	.word 0xdc86a000  ! 2642: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2643: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc94a000  ! 2644: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xd6a70e60  ! 2645: STWA_R	stwa	%r11, [%r28 + %r0] 0x73
	.word 0xdedf8e80  ! 2646: LDXA_R	ldxa	[%r30, %r0] 0x74, %r15
	.word 0x87802020  ! 2647: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebca000  ! 2648: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xdea42000  ! 2649: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xd4a584a0  ! 2650: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	.word 0xd2a6c9e0  ! 2651: STWA_R	stwa	%r9, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 2652: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d42000  ! 2653: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0xd88fce80  ! 2654: LDUBA_R	lduba	[%r31, %r0] 0x74, %r12
	mov	0x7f8, %r23
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd4d44400  ! 2657: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6d40400  ! 2659: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	.word 0xd6ac6000  ! 2660: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xdcb544a0  ! 2661: STHA_R	stha	%r14, [%r21 + %r0] 0x25
	.word 0xdc9f8e40  ! 2662: LDDA_R	ldda	[%r30, %r0] 0x72, %r14
	.word 0xdcf46000  ! 2663: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xd0a7ce80  ! 2664: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	mov	0x60, %r25
	.word 0xd08ce000  ! 2666: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xdcf70e60  ! 2667: STXA_R	stxa	%r14, [%r28 + %r0] 0x73
	.word 0xdc946000  ! 2668: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r14
	mov	0x20, %r18
	.word 0xd49f4e80  ! 2670: LDDA_R	ldda	[%r29, %r0] 0x74, %r10
	.word 0xd48ca000  ! 2671: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r10
	.word 0xd6a7ce80  ! 2672: STWA_R	stwa	%r11, [%r31 + %r0] 0x74
	.word 0xd8b74e60  ! 2673: STHA_R	stha	%r12, [%r29 + %r0] 0x73
	.word 0x87802020  ! 2674: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09609e0  ! 2675: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r8
	.word 0x87802025  ! 2676: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf584a0  ! 2677: STXA_R	stxa	%r14, [%r22 + %r0] 0x25
	.word 0xd0d70e40  ! 2678: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r8
	.word 0xda8c4400  ! 2679: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0x87802020  ! 2680: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad4a000  ! 2681: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	mov	0x78, %r24
	.word 0xdad74e80  ! 2683: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r13
	.word 0xdad42000  ! 2684: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2685: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda94e000  ! 2686: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r13
	.word 0xdad4a000  ! 2687: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	mov	0x7d8, %r23
	.word 0xdabc6000  ! 2689: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	mov	0x78, %r18
	mov	0x50, %r27
	mov	0x68, %r16
	.word 0x87802072  ! 2693: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdadfa000  ! 2694: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xd087ce60  ! 2695: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r8
	.word 0xd0872000  ! 2696: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xd097e000  ! 2697: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0d72000  ! 2698: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0x87802020  ! 2699: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r27
	mov	0x3e8, %r23
	mov	0x8, %r18
	.word 0xd0bc2000  ! 2703: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	.word 0xd0bc6000  ! 2704: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	mov	0x58, %r19
	.word 0xd0f4a000  ! 2706: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0xd0bc6000  ! 2708: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	mov	0x58, %r24
	.word 0xd0a42000  ! 2710: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xdc870e40  ! 2711: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r14
	mov	0x38, %r27
	.word 0xdcf4e000  ! 2713: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 2714: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7e0, %r22
	mov	0x28, %r16
	.word 0x87802074  ! 2717: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 2718: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r19
	mov	0x58, %r17
	.word 0x8780204f  ! 2721: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2722: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadd44a0  ! 2723: LDXA_R	ldxa	[%r21, %r0] 0x25, %r13
	.word 0xdab4e000  ! 2724: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xdef78e80  ! 2725: STXA_R	stxa	%r15, [%r30 + %r0] 0x74
	.word 0xdac74e80  ! 2726: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r13
	mov	0x60, %r19
	.word 0x87802073  ! 2728: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c8, %r22
	.word 0xdaf7a000  ! 2730: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdac7a000  ! 2731: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	mov	0x3d0, %r20
	mov	0x38, %r19
	.word 0xdacf2000  ! 2734: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0x87802074  ! 2735: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r26
	.word 0x87802020  ! 2737: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r21
	.word 0xd08f8e40  ! 2739: LDUBA_R	lduba	[%r30, %r0] 0x72, %r8
	.word 0xd0940400  ! 2740: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	.word 0xd0b42000  ! 2741: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xd0ace000  ! 2743: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	mov	0x18, %r24
	.word 0x87802074  ! 2745: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd09f6000  ! 2746: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	mov	0x3e8, %r21
	.word 0xd0c7a000  ! 2748: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	mov	0x48, %r25
	.word 0xd6b7ce40  ! 2750: STHA_R	stha	%r11, [%r31 + %r0] 0x72
	mov	0x20, %r19
	.word 0xd69fa000  ! 2752: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0xd6a70e40  ! 2753: STWA_R	stwa	%r11, [%r28 + %r0] 0x72
	mov	0x58, %r17
	.word 0xd2bc4400  ! 2755: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0x87802074  ! 2756: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b7a000  ! 2757: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xdcaec9e0  ! 2758: STBA_R	stba	%r14, [%r27 + %r0] 0x4f
	.word 0xdc8f6000  ! 2759: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdccfe000  ! 2760: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xdcdfa000  ! 2761: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	.word 0xda848400  ! 2762: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r13
	mov	0x3f0, %r20
	.word 0xdab76000  ! 2764: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdab76000  ! 2765: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 2766: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 2767: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2768: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r26
	.word 0xd2a78e80  ! 2770: STWA_R	stwa	%r9, [%r30 + %r0] 0x74
	mov	0x70, %r16
	.word 0xd2afa000  ! 2772: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 2773: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r17
	.word 0xd2ac2000  ! 2775: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0xdaf5c4a0  ! 2777: STXA_R	stxa	%r13, [%r23 + %r0] 0x25
	mov	0x48, %r18
	.word 0x87802074  ! 2779: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 2780: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdad66000  ! 2781: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r13
	.word 0xdabea000  ! 2782: STDA_I	stda	%r13, [%r26 + 0x0000] %asi
	.word 0xdaf6a000  ! 2783: STXA_I	stxa	%r13, [%r26 + 0x0000] %asi
	mov	0x68, %r24
	.word 0xda9ee000  ! 2785: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r13
	.word 0x87802025  ! 2786: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 2787: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda966000  ! 2788: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r13
	.word 0xda9e2000  ! 2789: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r13
	mov	0x20, %r25
	mov	0x7c8, %r23
	.word 0xdeafce80  ! 2792: STBA_R	stba	%r15, [%r31 + %r0] 0x74
	mov	0x3c0, %r22
	mov	0x20, %r24
	.word 0xdedea000  ! 2795: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r15
	.word 0xd68d04a0  ! 2796: LDUBA_R	lduba	[%r20, %r0] 0x25, %r11
	mov	0x3f8, %r23
	.word 0xd6d40400  ! 2798: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	.word 0xd6cea000  ! 2799: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	mov	0x60, %r18
	.word 0x87802025  ! 2801: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b56000  ! 2802: STHA_I	stha	%r11, [%r21 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xd8b7ce60  ! 2804: STHA_R	stha	%r12, [%r31 + %r0] 0x73
	.word 0xd895e000  ! 2805: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r12
	.word 0xd8c56000  ! 2806: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 2807: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f0, %r20
	.word 0xdaac4400  ! 2809: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	.word 0xdaae6000  ! 2810: STBA_I	stba	%r13, [%r25 + 0x0000] %asi
	mov	0x20, %r24
	.word 0xdabe6000  ! 2812: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	mov	0x3e0, %r21
	.word 0x87802020  ! 2814: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac42000  ! 2815: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0xd8bc4400  ! 2816: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xd4874e80  ! 2817: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r10
	.word 0xd2a40400  ! 2818: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0x87802073  ! 2819: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r16
	.word 0xd2b7a000  ! 2821: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd2d76000  ! 2822: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0xd09c4400  ! 2823: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	.word 0xda9504a0  ! 2824: LDUHA_R	lduha	[%r20, %r0] 0x25, %r13
	.word 0xd2f4c400  ! 2825: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xd8bcc400  ! 2826: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0xd8dfa000  ! 2827: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8c72000  ! 2828: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xdea74e40  ! 2829: STWA_R	stwa	%r15, [%r29 + %r0] 0x72
	.word 0xdeafa000  ! 2830: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xdef7e000  ! 2831: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xdec7a000  ! 2832: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xd8ac0400  ! 2833: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xda8e09e0  ! 2834: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r13
	.word 0xdacf2000  ! 2835: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	mov	0x70, %r16
	.word 0xdc8dc4a0  ! 2837: LDUBA_R	lduba	[%r23, %r0] 0x25, %r14
	mov	0x70, %r17
	.word 0xdeb70e80  ! 2839: STHA_R	stha	%r15, [%r28 + %r0] 0x74
	.word 0xdef76000  ! 2840: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xde972000  ! 2841: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0xd0dd44a0  ! 2842: LDXA_R	ldxa	[%r21, %r0] 0x25, %r8
	mov	0x10, %r19
	.word 0xdab44400  ! 2844: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	mov	0x3d0, %r21
	.word 0xda8fe000  ! 2846: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xdc978e40  ! 2847: LDUHA_R	lduha	[%r30, %r0] 0x72, %r14
	mov	0x48, %r18
	.word 0xd2b74e60  ! 2849: STHA_R	stha	%r9, [%r29 + %r0] 0x73
	mov	0x8, %r18
	.word 0xdea40400  ! 2851: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xded7a000  ! 2852: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	mov	0x40, %r19
	.word 0xdec7ce60  ! 2854: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r15
	.word 0xdef7e000  ! 2855: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	mov	0x7e0, %r22
	mov	0x40, %r26
	.word 0xd28f8e80  ! 2858: LDUBA_R	lduba	[%r30, %r0] 0x74, %r9
	.word 0xd4afce80  ! 2859: STBA_R	stba	%r10, [%r31 + %r0] 0x74
	mov	0x7d8, %r20
	.word 0xd4bfe000  ! 2861: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd4f7a000  ! 2862: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd89f4e80  ! 2863: LDDA_R	ldda	[%r29, %r0] 0x74, %r12
	.word 0xd8df6000  ! 2864: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	mov	0x7e0, %r21
	.word 0xda840400  ! 2866: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	.word 0xda8fa000  ! 2867: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	mov	0x50, %r26
	.word 0xdaafe000  ! 2869: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	mov	0x68, %r24
	.word 0xdaf76000  ! 2871: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdac72000  ! 2872: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	mov	0x3c8, %r20
	.word 0xd4b70e80  ! 2874: STHA_R	stha	%r10, [%r28 + %r0] 0x74
	mov	0x68, %r26
	.word 0xd4bfe000  ! 2876: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd2ae49e0  ! 2877: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	mov	0x70, %r24
	.word 0x87802020  ! 2879: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b42000  ! 2880: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0xd0af0e80  ! 2881: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	.word 0x87802020  ! 2882: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0c42000  ! 2883: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r8
	.word 0xd8bd04a0  ! 2884: STDA_R	stda	%r12, [%r20 + %r0] 0x25
	mov	0x30, %r18
	.word 0xd8b42000  ! 2886: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	.word 0xdeb609e0  ! 2887: STHA_R	stha	%r15, [%r24 + %r0] 0x4f
	.word 0xd49d44a0  ! 2888: LDDA_R	ldda	[%r21, %r0] 0x25, %r10
	.word 0xd484c400  ! 2889: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	.word 0x87802073  ! 2890: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4c7e000  ! 2891: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	.word 0xd2a70e80  ! 2892: STWA_R	stwa	%r9, [%r28 + %r0] 0x74
	.word 0x87802020  ! 2893: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2894: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc9649e0  ! 2895: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r14
	.word 0x87802020  ! 2896: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2897: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbc2000  ! 2898: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xdc8ca000  ! 2899: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r14
	.word 0x87802073  ! 2900: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f8, %r20
	.word 0xdeb504a0  ! 2902: STHA_R	stha	%r15, [%r20 + %r0] 0x25
	mov	0x7e8, %r20
	mov	0x58, %r27
	.word 0x87802020  ! 2905: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeac2000  ! 2906: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xdca40400  ! 2907: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xdc9c6000  ! 2908: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r14
	mov	0x30, %r27
	.word 0x8780204f  ! 2910: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c0, %r21
	.word 0xdcd6e000  ! 2912: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r14
	.word 0xdcae6000  ! 2913: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	.word 0x8780204f  ! 2914: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f78e80  ! 2915: STXA_R	stxa	%r9, [%r30 + %r0] 0x74
	.word 0xd2d62000  ! 2916: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r9
	.word 0xd28ea000  ! 2917: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r9
	.word 0xd2f6e000  ! 2918: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	.word 0xd2cea000  ! 2919: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2920: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r17
	.word 0x87802074  ! 2922: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd287a000  ! 2923: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2924: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2af8e60  ! 2925: STBA_R	stba	%r9, [%r30 + %r0] 0x73
	.word 0xdcac8400  ! 2926: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xdcf4a000  ! 2927: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdef7ce60  ! 2928: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0xd88f0e40  ! 2929: LDUBA_R	lduba	[%r28, %r0] 0x72, %r12
	mov	0x28, %r19
	.word 0xd2a7ce60  ! 2931: STWA_R	stwa	%r9, [%r31 + %r0] 0x73
	mov	0x30, %r17
	.word 0x87802072  ! 2933: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b7e000  ! 2934: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	mov	0x3f0, %r20
	.word 0xd2f72000  ! 2936: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	mov	0x18, %r18
	mov	0x7c8, %r21
	.word 0x87802074  ! 2939: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf44400  ! 2940: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	mov	0x10, %r25
	mov	0x7d8, %r20
	mov	0x40, %r24
	.word 0x87802025  ! 2944: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d0, %r22
	.word 0xdc8d2000  ! 2946: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r14
	.word 0xd6870e80  ! 2947: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r11
	.word 0xd6c52000  ! 2948: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r11
	.word 0xd4a44400  ! 2949: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xd4dd2000  ! 2950: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r10
	.word 0xd0d7ce80  ! 2951: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r8
	mov	0x58, %r24
	.word 0xd6b78e40  ! 2953: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	mov	0x20, %r18
	.word 0xd2d6c9e0  ! 2955: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r9
	.word 0xd2b5a000  ! 2956: STHA_I	stha	%r9, [%r22 + 0x0000] %asi
	mov	0x28, %r26
	.word 0x8780204f  ! 2958: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea78e40  ! 2959: STWA_R	stwa	%r15, [%r30 + %r0] 0x72
	.word 0xd88cc400  ! 2960: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	.word 0xdeafce60  ! 2961: STBA_R	stba	%r15, [%r31 + %r0] 0x73
	.word 0xdeaee000  ! 2962: STBA_I	stba	%r15, [%r27 + 0x0000] %asi
	.word 0xd29c0400  ! 2963: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	.word 0xd2b6e000  ! 2964: STHA_I	stha	%r9, [%r27 + 0x0000] %asi
	.word 0xd2dee000  ! 2965: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r9
	.word 0xd29e2000  ! 2966: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r9
	.word 0x87802025  ! 2967: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f0, %r22
	.word 0xd2a52000  ! 2969: STWA_I	stwa	%r9, [%r20 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2acc400  ! 2971: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0xd8f44400  ! 2972: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xd8b56000  ! 2973: STHA_I	stha	%r12, [%r21 + 0x0000] %asi
	.word 0xd89d2000  ! 2974: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r12
	mov	0x28, %r27
	.word 0xd8b5e000  ! 2976: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	mov	0x3d8, %r21
	mov	0x8, %r17
	.word 0x87802020  ! 2979: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd89c2000  ! 2980: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	.word 0xd8aca000  ! 2981: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0xd8b4a000  ! 2982: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 2983: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 2984: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8f74e40  ! 2985: STXA_R	stxa	%r12, [%r29 + %r0] 0x72
	mov	0x7c8, %r22
	.word 0xd8c52000  ! 2987: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r12
	.word 0xd0cd84a0  ! 2988: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r8
	.word 0xdcf504a0  ! 2989: STXA_R	stxa	%r14, [%r20 + %r0] 0x25
	mov	0x3c8, %r20
	.word 0xdc8d2000  ! 2991: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r14
	.word 0xdcbd2000  ! 2992: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	.word 0xd4df0e80  ! 2993: LDXA_R	ldxa	[%r28, %r0] 0x74, %r10
	mov	0x7e8, %r22
	.word 0xdaf40400  ! 2995: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0x87802072  ! 2996: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab72000  ! 2997: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdab7a000  ! 2998: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdaa7a000  ! 2999: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xd6c78e40  ! 3000: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	.word 0xd6dfa000  ! 3001: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0xd68f2000  ! 3002: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0x87802073  ! 3003: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdedd84a0  ! 3004: LDXA_R	ldxa	[%r22, %r0] 0x25, %r15
	.word 0xdef76000  ! 3005: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xde8fa000  ! 3007: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	mov	0x3e0, %r21
	.word 0xdef7a000  ! 3009: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdea72000  ! 3010: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	mov	0x30, %r17
	.word 0x87802025  ! 3012: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb70e60  ! 3013: STHA_R	stha	%r14, [%r28 + %r0] 0x73
	.word 0x87802074  ! 3014: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r26
	.word 0xdcbf2000  ! 3016: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 3017: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8f5c4a0  ! 3018: STXA_R	stxa	%r12, [%r23 + %r0] 0x25
	.word 0xdece89e0  ! 3019: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r15
	mov	0x68, %r24
	.word 0xdcf74e40  ! 3021: STXA_R	stxa	%r14, [%r29 + %r0] 0x72
	.word 0x87802074  ! 3022: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb7a000  ! 3023: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xdc972000  ! 3024: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	mov	0x48, %r25
	.word 0xd0dc0400  ! 3026: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0x87802020  ! 3027: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ac6000  ! 3028: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0xd49f4e40  ! 3029: LDDA_R	ldda	[%r29, %r0] 0x72, %r10
	.word 0xd0f649e0  ! 3030: STXA_R	stxa	%r8, [%r25 + %r0] 0x4f
	mov	0x68, %r18
	.word 0xd4bf8e60  ! 3032: STDA_R	stda	%r10, [%r30 + %r0] 0x73
	.word 0xd4846000  ! 3033: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r10
	mov	0x10, %r17
	.word 0xdabd04a0  ! 3035: STDA_R	stda	%r13, [%r20 + %r0] 0x25
	.word 0xd0874e40  ! 3036: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r8
	.word 0xd094a000  ! 3037: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	.word 0x87802020  ! 3038: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r24
	.word 0xdeb4c400  ! 3040: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	mov	0x3f8, %r23
	.word 0xd4874e60  ! 3042: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r10
	.word 0x87802073  ! 3043: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4d7a000  ! 3044: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	.word 0xd8c48400  ! 3045: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	mov	0x48, %r19
	mov	0x28, %r18
	mov	0x7f0, %r21
	.word 0x87802072  ! 3049: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8bf2000  ! 3050: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd8bf6000  ! 3051: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd8b72000  ! 3052: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	mov	0x50, %r17
	.word 0xd69cc400  ! 3054: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	.word 0xd6bfa000  ! 3055: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3056: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r18
	mov	0x38, %r27
	.word 0xd6aca000  ! 3059: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 3060: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 3061: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d0, %r20
	.word 0xd4bc0400  ! 3063: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xdcb649e0  ! 3064: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	.word 0xd0b70e60  ! 3065: STHA_R	stha	%r8, [%r28 + %r0] 0x73
	.word 0xdebf8e40  ! 3066: STDA_R	stda	%r15, [%r30 + %r0] 0x72
	.word 0x8780204f  ! 3067: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3068: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bc4400  ! 3069: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0xdabc4400  ! 3070: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xdaf46000  ! 3071: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 3072: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2ad84a0  ! 3073: STBA_R	stba	%r9, [%r22 + %r0] 0x25
	.word 0xd6b504a0  ! 3074: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	.word 0xd2de89e0  ! 3075: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r9
	.word 0xdeb74e80  ! 3076: STHA_R	stha	%r15, [%r29 + %r0] 0x74
	.word 0xdaf70e60  ! 3077: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	.word 0x8780204f  ! 3078: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2c649e0  ! 3079: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r9
	.word 0xd286e000  ! 3080: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r9
	mov	0x3d8, %r20
	.word 0xd2a6e000  ! 3082: STWA_I	stwa	%r9, [%r27 + 0x0000] %asi
	.word 0xd0d78e80  ! 3083: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r8
	.word 0xd0dee000  ! 3084: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r8
	.word 0x87802025  ! 3085: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c8, %r22
	.word 0xda970e60  ! 3087: LDUHA_R	lduha	[%r28, %r0] 0x73, %r13
	.word 0xdaf5e000  ! 3088: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	mov	0x58, %r24
	.word 0xda8de000  ! 3090: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r13
	.word 0xd8d5c4a0  ! 3091: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r12
	.word 0xd8a44400  ! 3092: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xd8b5a000  ! 3093: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	.word 0xd88da000  ! 3094: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r12
	.word 0xd4dcc400  ! 3095: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0xd0a78e60  ! 3096: STWA_R	stwa	%r8, [%r30 + %r0] 0x73
	.word 0xdadd44a0  ! 3097: LDXA_R	ldxa	[%r21, %r0] 0x25, %r13
	.word 0xd6ae09e0  ! 3098: STBA_R	stba	%r11, [%r24 + %r0] 0x4f
	.word 0xd6f5a000  ! 3099: STXA_I	stxa	%r11, [%r22 + 0x0000] %asi
	.word 0xdc8e49e0  ! 3100: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r14
	mov	0x3d0, %r20
	mov	0x10, %r26
	.word 0xde8cc400  ! 3103: LDUBA_R	lduba	[%r19, %r0] 0x20, %r15
	.word 0xdacc4400  ! 3104: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	.word 0xdca689e0  ! 3105: STWA_R	stwa	%r14, [%r26 + %r0] 0x4f
	mov	0x38, %r19
	mov	0x7f0, %r21
	.word 0xd2b78e80  ! 3108: STHA_R	stha	%r9, [%r30 + %r0] 0x74
	.word 0xd2a5e000  ! 3109: STWA_I	stwa	%r9, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 3110: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r24
	.word 0xd8de89e0  ! 3112: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r12
	mov	0x3c0, %r21
	.word 0xd0b78e60  ! 3114: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	.word 0xd08d6000  ! 3115: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r8
	.word 0xdedc8400  ! 3116: LDXA_R	ldxa	[%r18, %r0] 0x20, %r15
	.word 0x87802020  ! 3117: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6af4e80  ! 3118: STBA_R	stba	%r11, [%r29 + %r0] 0x74
	.word 0xd6f4a000  ! 3119: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 3120: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bfa000  ! 3121: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd6c7e000  ! 3122: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6b72000  ! 3123: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 3124: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c5c4a0  ! 3125: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r9
	.word 0xd28c2000  ! 3126: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xd2cca000  ! 3127: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	.word 0xdef609e0  ! 3128: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x10, %r26
	mov	0x48, %r27
	.word 0xde9ce000  ! 3132: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	mov	0x18, %r17
	.word 0xd09c4400  ! 3134: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	mov	0x58, %r17
	mov	0x3e8, %r20
	mov	0x3d8, %r21
	.word 0xd0f4a000  ! 3138: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xdebf4e40  ! 3139: STDA_R	stda	%r15, [%r29 + %r0] 0x72
	.word 0x87802020  ! 3140: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8dfce80  ! 3141: LDXA_R	ldxa	[%r31, %r0] 0x74, %r12
	.word 0xd88544a0  ! 3142: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r12
	.word 0xd8bce000  ! 3143: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd8ace000  ! 3144: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	mov	0x3d8, %r21
	.word 0xdead44a0  ! 3146: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	mov	0x20, %r17
	.word 0xdecc2000  ! 3148: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	.word 0xde8ca000  ! 3149: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0x87802074  ! 3150: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 3151: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebec9e0  ! 3152: STDA_R	stda	%r15, [%r27 + %r0] 0x4f
	.word 0xda8cc400  ! 3153: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	mov	0x7e0, %r22
	.word 0xd4df4e40  ! 3155: LDXA_R	ldxa	[%r29, %r0] 0x72, %r10
	.word 0x8780204f  ! 3156: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c0, %r20
	.word 0xd4ce6000  ! 3158: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r10
	.word 0xdecc8400  ! 3159: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	.word 0xdeae6000  ! 3160: STBA_I	stba	%r15, [%r25 + 0x0000] %asi
	.word 0xde9e2000  ! 3161: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r15
	.word 0xdec6e000  ! 3162: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r15
	.word 0xdeae6000  ! 3163: STBA_I	stba	%r15, [%r25 + 0x0000] %asi
	.word 0xd4df0e40  ! 3164: LDXA_R	ldxa	[%r28, %r0] 0x72, %r10
	mov	0x50, %r16
	.word 0xd49ee000  ! 3166: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r10
	mov	0x7d0, %r21
	mov	0x7d0, %r20
	.word 0xd48e2000  ! 3169: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r10
	.word 0xd4aea000  ! 3170: STBA_I	stba	%r10, [%r26 + 0x0000] %asi
	mov	0x30, %r27
	.word 0x87802020  ! 3172: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3173: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r18
	.word 0xd4cc2000  ! 3175: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	.word 0xd49d44a0  ! 3176: LDDA_R	ldda	[%r21, %r0] 0x25, %r10
	.word 0xd4cc6000  ! 3177: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	mov	0x7e8, %r20
	.word 0x87802020  ! 3179: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3180: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdad649e0  ! 3181: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r13
	mov	0x48, %r19
	.word 0xdadfe000  ! 3183: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0xde8fce60  ! 3184: LDUBA_R	lduba	[%r31, %r0] 0x73, %r15
	.word 0xd8b74e80  ! 3185: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	.word 0x87802073  ! 3186: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f78e60  ! 3187: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	mov	0x7d0, %r22
	.word 0xd8bfa000  ! 3189: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 3190: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdacf4e80  ! 3192: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r13
	mov	0x10, %r24
	.word 0xd69609e0  ! 3194: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r11
	.word 0xdcaf8e80  ! 3195: STBA_R	stba	%r14, [%r30 + %r0] 0x74
	.word 0xdc8e2000  ! 3196: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r14
	.word 0xd2c70e80  ! 3197: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r9
	.word 0x87802073  ! 3198: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d0, %r21
	mov	0x60, %r27
	.word 0xd2b76000  ! 3201: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2bdc4a0  ! 3202: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	.word 0x87802025  ! 3203: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b5e000  ! 3204: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xded70e80  ! 3206: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r15
	mov	0x50, %r25
	.word 0x87802073  ! 3208: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdebf6000  ! 3209: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	mov	0x3f8, %r22
	.word 0xde9fe000  ! 3211: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0xda9c4400  ! 3212: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	.word 0xdc9d44a0  ! 3213: LDDA_R	ldda	[%r21, %r0] 0x25, %r14
	mov	0x3f8, %r22
	.word 0xd28fce80  ! 3215: LDUBA_R	lduba	[%r31, %r0] 0x74, %r9
	.word 0xd6a74e60  ! 3216: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	.word 0xdac6c9e0  ! 3217: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r13
	.word 0x87802020  ! 3218: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r22
	mov	0x7d8, %r21
	.word 0xd2d609e0  ! 3221: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r9
	.word 0xd2bc6000  ! 3222: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0xd2a42000  ! 3223: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	mov	0x3c8, %r22
	.word 0xd2f4e000  ! 3225: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd6acc400  ! 3226: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xd2df0e60  ! 3227: LDXA_R	ldxa	[%r28, %r0] 0x73, %r9
	.word 0xd2a46000  ! 3228: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	mov	0x68, %r16
	.word 0xdca504a0  ! 3230: STWA_R	stwa	%r14, [%r20 + %r0] 0x25
	mov	0x38, %r27
	.word 0xdccce000  ! 3232: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r14
	.word 0xd4974e40  ! 3233: LDUHA_R	lduha	[%r29, %r0] 0x72, %r10
	.word 0xd48ca000  ! 3234: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r10
	.word 0xd4d46000  ! 3235: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r10
	.word 0xdc9c0400  ! 3236: LDDA_R	ldda	[%r16, %r0] 0x20, %r14
	.word 0x87802025  ! 3237: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r17
	mov	0x78, %r24
	.word 0xd2b6c9e0  ! 3240: STHA_R	stha	%r9, [%r27 + %r0] 0x4f
	.word 0xd29de000  ! 3241: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r9
	.word 0xd2b52000  ! 3242: STHA_I	stha	%r9, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 3243: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 3244: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0c70e40  ! 3245: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r8
	.word 0xd8b74e40  ! 3246: STHA_R	stha	%r12, [%r29 + %r0] 0x72
	.word 0x87802025  ! 3247: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0b40400  ! 3248: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0xdcdfce40  ! 3249: LDXA_R	ldxa	[%r31, %r0] 0x72, %r14
	mov	0x7f0, %r20
	mov	0x3f8, %r20
	.word 0xd8d70e40  ! 3252: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r12
	.word 0xdac70e40  ! 3253: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r13
	.word 0xd2d6c9e0  ! 3254: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r9
	mov	0x3f0, %r22
	.word 0xd28d2000  ! 3256: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r9
	.word 0x87802073  ! 3257: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 3258: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3259: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r17
	.word 0xdcdfce60  ! 3261: LDXA_R	ldxa	[%r31, %r0] 0x73, %r14
	.word 0xdc9e89e0  ! 3262: LDDA_R	ldda	[%r26, %r0] 0x4f, %r14
	.word 0xdc9ca000  ! 3263: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r14
	.word 0xdca4a000  ! 3264: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 3265: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r19
	.word 0xdcb4a000  ! 3267: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 3268: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3269: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca46000  ! 3270: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0xd0ad44a0  ! 3272: STBA_R	stba	%r8, [%r21 + %r0] 0x25
	mov	0x58, %r16
	.word 0xd0aca000  ! 3274: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xd0a42000  ! 3275: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xd4df4e60  ! 3276: LDXA_R	ldxa	[%r29, %r0] 0x73, %r10
	.word 0xdeb74e40  ! 3277: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	.word 0xd6af8e60  ! 3278: STBA_R	stba	%r11, [%r30 + %r0] 0x73
	.word 0xd6dc2000  ! 3279: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r11
	mov	0x3f0, %r20
	.word 0xd6c42000  ! 3281: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r11
	.word 0xd2de89e0  ! 3282: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r9
	.word 0xd2f40400  ! 3283: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0x87802074  ! 3284: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 3285: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r17
	.word 0x87802072  ! 3287: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b7a000  ! 3288: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd08e49e0  ! 3289: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r8
	.word 0xd0972000  ! 3290: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xded4c400  ! 3291: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r15
	.word 0xde9e49e0  ! 3292: LDDA_R	ldda	[%r25, %r0] 0x4f, %r15
	.word 0xdef72000  ! 3293: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 3294: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6afce40  ! 3295: STBA_R	stba	%r11, [%r31 + %r0] 0x72
	.word 0xd4b6c9e0  ! 3296: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0x8780204f  ! 3297: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd29f8e60  ! 3298: LDDA_R	ldda	[%r30, %r0] 0x73, %r9
	mov	0x7e0, %r20
	.word 0xd6af4e60  ! 3300: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	mov	0x3f8, %r20
	.word 0x87802073  ! 3302: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef70e80  ! 3303: STXA_R	stxa	%r15, [%r28 + %r0] 0x74
	.word 0x87802073  ! 3304: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdecf2000  ! 3305: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xdebfe000  ! 3306: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xded76000  ! 3307: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	mov	0x60, %r27
	.word 0xde8f2000  ! 3309: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0x87802073  ! 3310: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r24
	.word 0xd6f78e60  ! 3312: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	.word 0xd6ad04a0  ! 3313: STBA_R	stba	%r11, [%r20 + %r0] 0x25
	.word 0xd4af8e40  ! 3314: STBA_R	stba	%r10, [%r30 + %r0] 0x72
	mov	0x3c0, %r21
	.word 0xd4b6c9e0  ! 3316: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	mov	0x18, %r18
	.word 0x8780204f  ! 3318: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3319: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r23
	.word 0xdca78e40  ! 3321: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	.word 0xdef609e0  ! 3322: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	mov	0x3e8, %r23
	mov	0x28, %r25
	.word 0xdecca000  ! 3325: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	.word 0xde9ce000  ! 3326: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0xda8c4400  ! 3327: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0x87802072  ! 3328: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa7e000  ! 3329: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xda8fa000  ! 3330: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3331: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 3332: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdadda000  ! 3333: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r13
	.word 0xde970e60  ! 3334: LDUHA_R	lduha	[%r28, %r0] 0x73, %r15
	mov	0x10, %r17
	mov	0x20, %r26
	.word 0x87802072  ! 3337: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb72000  ! 3338: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xdea76000  ! 3339: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xdec7a000  ! 3340: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	mov	0x20, %r19
	.word 0xdeb76000  ! 3342: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	mov	0x7f0, %r22
	.word 0xd2bfce80  ! 3344: STDA_R	stda	%r9, [%r31 + %r0] 0x74
	mov	0x18, %r27
	.word 0xd297e000  ! 3346: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	.word 0xd0f44400  ! 3347: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd0b7a000  ! 3348: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	mov	0x78, %r27
	.word 0xdc9dc4a0  ! 3350: LDDA_R	ldda	[%r23, %r0] 0x25, %r14
	.word 0xdccfe000  ! 3351: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xd8b544a0  ! 3352: STHA_R	stha	%r12, [%r21 + %r0] 0x25
	mov	0x7e0, %r23
	.word 0x87802020  ! 3354: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d4e000  ! 3355: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0xd8c46000  ! 3356: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r12
	mov	0x7f8, %r20
	mov	0x7e8, %r21
	mov	0x60, %r19
	mov	0x18, %r24
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd8c4e000  ! 3362: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	.word 0xd89c2000  ! 3363: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	.word 0x87802072  ! 3364: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a7e000  ! 3365: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8c584a0  ! 3366: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r12
	.word 0x87802072  ! 3367: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd89f4e60  ! 3368: LDDA_R	ldda	[%r29, %r0] 0x73, %r12
	.word 0xd2c649e0  ! 3369: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r9
	mov	0x28, %r18
	mov	0x78, %r26
	mov	0x7e8, %r23
	mov	0x0, %r26
	.word 0xd29fe000  ! 3374: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd2a72000  ! 3375: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0xdcb4c400  ! 3376: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xd0870e40  ! 3377: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r8
	.word 0xd0b4c400  ! 3378: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0xd0a76000  ! 3379: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	mov	0x60, %r25
	.word 0xd0874e60  ! 3381: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r8
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd8c584a0  ! 3383: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r12
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd8b76000  ! 3385: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xdaa4c400  ! 3386: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	mov	0x0, %r26
	mov	0x40, %r27
	.word 0x87802025  ! 3389: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaf5a000  ! 3390: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xdaada000  ! 3391: STBA_I	stba	%r13, [%r22 + 0x0000] %asi
	mov	0x48, %r24
	.word 0x87802025  ! 3393: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r18
	.word 0xda8de000  ! 3395: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r13
	.word 0xd8a40400  ! 3396: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	mov	0x7d8, %r23
	.word 0x8780204f  ! 3398: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd89e6000  ! 3399: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r12
	.word 0x87802025  ! 3400: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2844400  ! 3401: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	.word 0xd2bd2000  ! 3402: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	.word 0xdea78e40  ! 3403: STWA_R	stwa	%r15, [%r30 + %r0] 0x72
	.word 0xd6974e60  ! 3404: LDUHA_R	lduha	[%r29, %r0] 0x73, %r11
	.word 0xd6b5e000  ! 3405: STHA_I	stha	%r11, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 3406: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f7ce80  ! 3407: STXA_R	stxa	%r11, [%r31 + %r0] 0x74
	.word 0xd6f5a000  ! 3408: STXA_I	stxa	%r11, [%r22 + 0x0000] %asi
	.word 0xdca44400  ! 3409: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	mov	0x7c0, %r22
	.word 0xdca4c400  ! 3411: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xd2bec9e0  ! 3412: STDA_R	stda	%r9, [%r27 + %r0] 0x4f
	mov	0x68, %r18
	.word 0xd2ad2000  ! 3414: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xdc9fce80  ! 3415: LDDA_R	ldda	[%r31, %r0] 0x74, %r14
	.word 0xdc852000  ! 3416: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r14
	mov	0x8, %r19
	.word 0xdcf5a000  ! 3418: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	.word 0xdcdd6000  ! 3419: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r14
	mov	0x30, %r19
	.word 0xdcb5e000  ! 3421: STHA_I	stha	%r14, [%r23 + 0x0000] %asi
	.word 0xd0bf4e40  ! 3422: STDA_R	stda	%r8, [%r29 + %r0] 0x72
	mov	0x28, %r27
	.word 0xdad689e0  ! 3424: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r13
	.word 0xdc848400  ! 3425: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	.word 0xd8840400  ! 3426: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r12
	.word 0xd8b52000  ! 3427: STHA_I	stha	%r12, [%r20 + 0x0000] %asi
	.word 0xd8f5a000  ! 3428: STXA_I	stxa	%r12, [%r22 + 0x0000] %asi
	.word 0x87802073  ! 3429: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2c4c400  ! 3430: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0xd2b7a000  ! 3431: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd2f76000  ! 3432: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xd28f6000  ! 3434: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	mov	0x58, %r19
	.word 0xdea44400  ! 3436: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xdc948400  ! 3437: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	.word 0xdcbfa000  ! 3438: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdcd7a000  ! 3439: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0xdca76000  ! 3440: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcbf2000  ! 3441: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	mov	0x3e8, %r20
	mov	0x68, %r16
	.word 0xdcc7a000  ! 3444: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	mov	0x10, %r25
	.word 0xdcbf2000  ! 3446: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 3447: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa544a0  ! 3448: STWA_R	stwa	%r13, [%r21 + %r0] 0x25
	mov	0x28, %r18
	.word 0xd8c78e40  ! 3450: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r12
	.word 0xda94c400  ! 3451: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	.word 0xda9fa000  ! 3452: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xdacf6000  ! 3453: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xdab72000  ! 3454: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	mov	0x0, %r27
	.word 0xd68e49e0  ! 3456: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r11
	.word 0xdcf70e40  ! 3457: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	mov	0x78, %r27
	.word 0xdcf72000  ! 3459: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	mov	0x3f0, %r20
	.word 0x87802020  ! 3461: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r27
	mov	0x3f8, %r21
	.word 0x87802020  ! 3464: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r17
	.word 0x87802025  ! 3466: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r17
	.word 0xd297ce40  ! 3468: LDUHA_R	lduha	[%r31, %r0] 0x72, %r9
	.word 0x87802072  ! 3469: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2afa000  ! 3470: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	mov	0x38, %r25
	.word 0xd2cfce60  ! 3472: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r9
	.word 0x87802020  ! 3473: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c4e000  ! 3474: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	mov	0x38, %r19
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2c4a000  ! 3477: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	.word 0xd2f4a000  ! 3478: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xd2d42000  ! 3480: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0xd29c6000  ! 3481: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	.word 0xdaac0400  ! 3482: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	mov	0x18, %r19
	.word 0xda8ce000  ! 3484: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3485: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadf0e40  ! 3486: LDXA_R	ldxa	[%r28, %r0] 0x72, %r13
	.word 0xd8a74e60  ! 3487: STWA_R	stwa	%r12, [%r29 + %r0] 0x73
	.word 0xd6d70e80  ! 3488: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r11
	.word 0xd88c4400  ! 3489: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	mov	0x30, %r19
	.word 0xdac40400  ! 3491: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	.word 0xd6a70e60  ! 3492: STWA_R	stwa	%r11, [%r28 + %r0] 0x73
	mov	0x3e8, %r23
	mov	0x78, %r26
	.word 0xd4b584a0  ! 3495: STHA_R	stha	%r10, [%r22 + %r0] 0x25
	mov	0x50, %r26
	.word 0xd4c42000  ! 3497: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r10
	.word 0xd4aca000  ! 3498: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0xd4ac2000  ! 3499: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0xd4dc6000  ! 3500: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	.word 0xd4944400  ! 3501: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	.word 0xd8a74e60  ! 3502: STWA_R	stwa	%r12, [%r29 + %r0] 0x73
	.word 0x87802025  ! 3503: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdac6c9e0  ! 3504: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r13
	mov	0x28, %r27
	.word 0xdadd2000  ! 3506: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r13
	mov	0x8, %r19
	.word 0xdaf609e0  ! 3508: STXA_R	stxa	%r13, [%r24 + %r0] 0x4f
	.word 0xd6a48400  ! 3509: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	ta	T_CHANGE_PRIV	! macro
	.word 0xd6a5e000  ! 3511: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	mov	0x40, %r24
	mov	0x28, %r16
	.word 0xdcd74e60  ! 3514: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r14
	mov	0x50, %r19
	mov	0x38, %r17
	mov	0x28, %r16
	mov	0x7d8, %r21
	.word 0xd2d609e0  ! 3519: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r9
	.word 0xdcae09e0  ! 3520: STBA_R	stba	%r14, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 3521: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf7e000  ! 3522: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x3c8, %r20
	mov	0x48, %r17
	.word 0xdc9fa000  ! 3525: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	mov	0x40, %r27
	.word 0xdef7ce40  ! 3527: STXA_R	stxa	%r15, [%r31 + %r0] 0x72
	.word 0xdedf6000  ! 3528: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xdea72000  ! 3529: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xd0f7ce60  ! 3530: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	.word 0xd0d7a000  ! 3531: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0xd2a609e0  ! 3532: STWA_R	stwa	%r9, [%r24 + %r0] 0x4f
	mov	0x60, %r17
	.word 0x87802073  ! 3534: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b7e000  ! 3535: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2c76000  ! 3536: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0xd28fe000  ! 3537: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	.word 0xd6bc8400  ! 3538: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xdcc5c4a0  ! 3539: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r14
	.word 0x87802025  ! 3540: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e8, %r23
	.word 0xd2c7ce80  ! 3542: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r9
	mov	0x20, %r27
	.word 0xd29d6000  ! 3544: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r9
	mov	0x7f0, %r22
	mov	0x0, %r25
	.word 0xd2bde000  ! 3547: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	mov	0x30, %r19
	mov	0x7c8, %r22
	.word 0x8780204f  ! 3550: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2866000  ! 3551: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r9
	mov	0x20, %r19
	.word 0xd2ce6000  ! 3553: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r9
	.word 0xd2cfce60  ! 3554: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r9
	.word 0xded7ce40  ! 3555: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r15
	.word 0xd2f544a0  ! 3556: STXA_R	stxa	%r9, [%r21 + %r0] 0x25
	.word 0xd2962000  ! 3557: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r9
	.word 0xd2f62000  ! 3558: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	.word 0xd2962000  ! 3559: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r9
	.word 0xdede09e0  ! 3560: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r15
	.word 0x87802020  ! 3561: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r22
	.word 0x87802020  ! 3563: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cec9e0  ! 3564: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r8
	.word 0xdacfce80  ! 3565: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r13
	.word 0xdacc2000  ! 3566: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xdaac6000  ! 3567: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	.word 0xd4a689e0  ! 3568: STWA_R	stwa	%r10, [%r26 + %r0] 0x4f
	.word 0xd2d74e60  ! 3569: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r9
	.word 0xdecf8e80  ! 3570: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r15
	mov	0x30, %r25
	.word 0xdeaca000  ! 3572: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	mov	0x20, %r26
	.word 0x87802072  ! 3574: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef72000  ! 3575: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xde87e000  ! 3576: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xd28f4e60  ! 3577: LDUBA_R	lduba	[%r29, %r0] 0x73, %r9
	mov	0x0, %r26
	.word 0xdab5c4a0  ! 3579: STHA_R	stha	%r13, [%r23 + %r0] 0x25
	.word 0x87802074  ! 3580: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r17
	.word 0xdeb44400  ! 3582: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	mov	0x7f0, %r20
	.word 0xd6878e40  ! 3584: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r11
	.word 0xd6872000  ! 3585: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd68fa000  ! 3586: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0xd6af2000  ! 3587: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x50, %r18
	.word 0x87802020  ! 3589: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3590: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r24
	.word 0x8780204f  ! 3592: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f4c400  ! 3593: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0xd6c62000  ! 3594: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r11
	.word 0xd696a000  ! 3595: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r11
	.word 0xd0a48400  ! 3596: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0xd0a6a000  ! 3597: STWA_I	stwa	%r8, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 3598: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cce000  ! 3599: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0f4a000  ! 3600: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xd0ace000  ! 3601: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	mov	0x3e8, %r21
	mov	0x68, %r18
	.word 0xdeaf8e40  ! 3604: STBA_R	stba	%r15, [%r30 + %r0] 0x72
	mov	0x40, %r26
	mov	0x40, %r18
	.word 0xdeb4a000  ! 3607: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0xdedca000  ! 3608: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3609: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r18
	.word 0x87802020  ! 3611: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde842000  ! 3612: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	.word 0x87802073  ! 3613: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeaf6000  ! 3614: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xde8fe000  ! 3615: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0xdedf6000  ! 3616: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xde8fe000  ! 3617: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	mov	0x3f0, %r22
	.word 0xde9f6000  ! 3619: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0x87802073  ! 3620: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4ad84a0  ! 3621: STBA_R	stba	%r10, [%r22 + %r0] 0x25
	mov	0x7e0, %r20
	.word 0xd4bfe000  ! 3623: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xd487a000  ! 3625: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	mov	0x60, %r24
	.word 0xd2af4e60  ! 3627: STBA_R	stba	%r9, [%r29 + %r0] 0x73
	.word 0xd2a7e000  ! 3628: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xd0c40400  ! 3629: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	.word 0x87802020  ! 3630: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9504a0  ! 3631: LDUHA_R	lduha	[%r20, %r0] 0x25, %r15
	.word 0xdedc6000  ! 3632: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r15
	.word 0xdeb5c4a0  ! 3633: STHA_R	stha	%r15, [%r23 + %r0] 0x25
	.word 0xdea4a000  ! 3634: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xd6f74e40  ! 3635: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	.word 0xd6946000  ! 3636: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r11
	.word 0xdc9fce60  ! 3637: LDDA_R	ldda	[%r31, %r0] 0x73, %r14
	.word 0xdc8544a0  ! 3638: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r14
	mov	0x38, %r24
	mov	0x3c0, %r21
	.word 0xdcd4a000  ! 3641: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	.word 0xdcc46000  ! 3642: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r14
	.word 0xdc846000  ! 3643: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802020  ! 3645: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r27
	.word 0x87802072  ! 3647: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3648: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd09dc4a0  ! 3649: LDDA_R	ldda	[%r23, %r0] 0x25, %r8
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd4a78e60  ! 3651: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	.word 0xd4dea000  ! 3652: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	.word 0xd4be6000  ! 3653: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0xdca78e40  ! 3654: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	.word 0xda940400  ! 3655: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	.word 0x87802020  ! 3656: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac46000  ! 3657: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3658: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab46000  ! 3659: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0x87802072  ! 3661: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 3662: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda972000  ! 3663: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0xdeafce80  ! 3664: STBA_R	stba	%r15, [%r31 + %r0] 0x74
	mov	0x38, %r16
	.word 0xdecc4400  ! 3666: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r15
	.word 0xdebfa000  ! 3667: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xd0d504a0  ! 3668: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r8
	.word 0xd0bfe000  ! 3669: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xda9c4400  ! 3670: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	mov	0x30, %r25
	mov	0x18, %r16
	.word 0xd6d6c9e0  ! 3673: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r11
	.word 0xd6b72000  ! 3674: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd6bfe000  ! 3675: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd6bf2000  ! 3676: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 3677: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r18
	mov	0x3c0, %r21
	mov	0x7f8, %r20
	.word 0xd68f2000  ! 3681: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xdabf0e80  ! 3682: STDA_R	stda	%r13, [%r28 + %r0] 0x74
	.word 0xda9f6000  ! 3683: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	mov	0x0, %r16
	.word 0xd0f78e40  ! 3685: STXA_R	stxa	%r8, [%r30 + %r0] 0x72
	.word 0xd8be49e0  ! 3686: STDA_R	stda	%r12, [%r25 + %r0] 0x4f
	.word 0xd887a000  ! 3687: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8b5c4a0  ! 3688: STHA_R	stha	%r12, [%r23 + %r0] 0x25
	.word 0xd8b4c400  ! 3689: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	mov	0x7e0, %r22
	.word 0xd8a7a000  ! 3691: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0x87802074  ! 3693: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8a76000  ! 3694: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xda9f4e80  ! 3695: LDDA_R	ldda	[%r29, %r0] 0x74, %r13
	.word 0x87802020  ! 3696: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad46000  ! 3697: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	.word 0xdc8c4400  ! 3698: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	mov	0x48, %r25
	.word 0x87802025  ! 3700: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca56000  ! 3701: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	.word 0x87802074  ! 3702: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcaf2000  ! 3703: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdcbf2000  ! 3704: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xd2b78e40  ! 3705: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	mov	0x70, %r17
	.word 0x87802025  ! 3707: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a70e60  ! 3708: STWA_R	stwa	%r8, [%r28 + %r0] 0x73
	.word 0xd0de49e0  ! 3709: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r8
	mov	0x40, %r26
	.word 0xdabd84a0  ! 3711: STDA_R	stda	%r13, [%r22 + %r0] 0x25
	.word 0x87802020  ! 3712: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde878e40  ! 3713: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r15
	.word 0xde8c6000  ! 3714: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	mov	0x10, %r16
	.word 0xdeac8400  ! 3716: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0x87802020  ! 3717: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3718: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabc4400  ! 3719: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xdaa4a000  ! 3720: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xd0d48400  ! 3721: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	.word 0xdcadc4a0  ! 3722: STBA_R	stba	%r14, [%r23 + %r0] 0x25
	.word 0x87802020  ! 3723: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3724: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd09e09e0  ! 3725: LDDA_R	ldda	[%r24, %r0] 0x4f, %r8
	.word 0xd0c7e000  ! 3726: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0xd8ce89e0  ! 3727: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r12
	.word 0xd0bf4e40  ! 3728: STDA_R	stda	%r8, [%r29 + %r0] 0x72
	.word 0xd0dfe000  ! 3729: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0c76000  ! 3730: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0xd08f2000  ! 3731: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	.word 0xd0df6000  ! 3732: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0xd09f8e80  ! 3733: LDDA_R	ldda	[%r30, %r0] 0x74, %r8
	.word 0xd0af2000  ! 3734: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd0df6000  ! 3736: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	mov	0x3d8, %r23
	mov	0x7c8, %r21
	mov	0x3c8, %r23
	.word 0xded40400  ! 3740: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	.word 0xd0f44400  ! 3741: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xdacc0400  ! 3742: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r13
	.word 0xdacfa000  ! 3743: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	mov	0x60, %r17
	.word 0x87802072  ! 3745: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf7e000  ! 3746: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xd0a689e0  ! 3747: STWA_R	stwa	%r8, [%r26 + %r0] 0x4f
	.word 0xd0c72000  ! 3748: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	mov	0x7d0, %r20
	.word 0xd6b7ce80  ! 3750: STHA_R	stha	%r11, [%r31 + %r0] 0x74
	.word 0xd6c72000  ! 3751: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3752: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r25
	mov	0x38, %r25
	.word 0xd2b689e0  ! 3755: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	mov	0x7f0, %r20
	.word 0xdaf70e60  ! 3757: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	.word 0xdabc6000  ! 3758: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xda878e60  ! 3759: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r13
	.word 0x87802072  ! 3760: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdac504a0  ! 3761: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r13
	.word 0xde848400  ! 3762: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	.word 0xd2ac8400  ! 3763: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	mov	0x70, %r27
	.word 0xd2bfe000  ! 3765: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	mov	0x30, %r16
	.word 0xd287e000  ! 3767: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802072  ! 3769: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6cd44a0  ! 3770: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r11
	.word 0xdea7ce40  ! 3771: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	.word 0xdebfa000  ! 3772: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3773: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dcc400  ! 3774: LDXA_R	ldxa	[%r19, %r0] 0x20, %r9
	.word 0xd284e000  ! 3775: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r9
	.word 0xdaafce60  ! 3776: STBA_R	stba	%r13, [%r31 + %r0] 0x73
	.word 0xdea44400  ! 3777: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	mov	0x3f0, %r23
	mov	0x60, %r17
	mov	0x60, %r19
	mov	0x40, %r16
	.word 0xde9ce000  ! 3782: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	mov	0x38, %r26
	.word 0xdebfce80  ! 3784: STDA_R	stda	%r15, [%r31 + %r0] 0x74
	.word 0xdacd44a0  ! 3785: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r13
	.word 0x87802020  ! 3786: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3787: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa76000  ! 3788: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	mov	0x40, %r16
	mov	0x7e0, %r21
	.word 0x87802073  ! 3791: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda9fe000  ! 3792: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xd89649e0  ! 3793: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r12
	.word 0xd2b74e40  ! 3794: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	.word 0xd2f76000  ! 3795: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xdeac4400  ! 3796: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0xdecfa000  ! 3797: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xd0970e40  ! 3798: LDUHA_R	lduha	[%r28, %r0] 0x72, %r8
	.word 0xd0c7e000  ! 3799: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0xd097a000  ! 3800: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	mov	0x48, %r24
	.word 0xd48f4e40  ! 3802: LDUBA_R	lduba	[%r29, %r0] 0x72, %r10
	.word 0xd6b48400  ! 3803: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd6c7a000  ! 3804: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	.word 0xdcbec9e0  ! 3805: STDA_R	stda	%r14, [%r27 + %r0] 0x4f
	mov	0x68, %r18
	.word 0x87802072  ! 3807: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcafe000  ! 3808: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xd89c8400  ! 3809: LDDA_R	ldda	[%r18, %r0] 0x20, %r12
	mov	0x3e8, %r23
	.word 0xd89f6000  ! 3811: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	.word 0xd48cc400  ! 3812: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	.word 0xd4b7e000  ! 3813: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd8f7ce40  ! 3814: STXA_R	stxa	%r12, [%r31 + %r0] 0x72
	.word 0xd8adc4a0  ! 3815: STBA_R	stba	%r12, [%r23 + %r0] 0x25
	.word 0xdab40400  ! 3816: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 3817: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea4c400  ! 3818: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 3819: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea78e80  ! 3820: STWA_R	stwa	%r15, [%r30 + %r0] 0x74
	mov	0x48, %r24
	.word 0xdcbc4400  ! 3822: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	mov	0x3f0, %r22
	mov	0x28, %r19
	.word 0xdc9584a0  ! 3825: LDUHA_R	lduha	[%r22, %r0] 0x25, %r14
	.word 0xdeb78e60  ! 3826: STHA_R	stha	%r15, [%r30 + %r0] 0x73
	.word 0xd2970e40  ! 3827: LDUHA_R	lduha	[%r28, %r0] 0x72, %r9
	.word 0xd4cec9e0  ! 3828: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r10
	.word 0xde978e40  ! 3829: LDUHA_R	lduha	[%r30, %r0] 0x72, %r15
	.word 0xdea62000  ! 3830: STWA_I	stwa	%r15, [%r24 + 0x0000] %asi
	.word 0xd29dc4a0  ! 3831: LDDA_R	ldda	[%r23, %r0] 0x25, %r9
	.word 0xd28e2000  ! 3832: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	mov	0x58, %r25
	.word 0x87802072  ! 3834: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c8, %r20
	mov	0x58, %r18
	.word 0x87802020  ! 3837: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cca000  ! 3838: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2a4a000  ! 3839: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0xd2b46000  ! 3840: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	mov	0x8, %r24
	.word 0xd2b42000  ! 3842: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0xd2c46000  ! 3844: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3845: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcafce80  ! 3846: STBA_R	stba	%r14, [%r31 + %r0] 0x74
	.word 0xdcf70e60  ! 3847: STXA_R	stxa	%r14, [%r28 + %r0] 0x73
	.word 0xdcaca000  ! 3848: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xd687ce60  ! 3849: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r11
	.word 0xd48dc4a0  ! 3850: LDUBA_R	lduba	[%r23, %r0] 0x25, %r10
	.word 0xd2dc8400  ! 3851: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	mov	0x68, %r19
	mov	0x58, %r17
	.word 0xd2bc6000  ! 3854: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0xd2ace000  ! 3855: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0xd896c9e0  ! 3856: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r12
	.word 0xd4ad44a0  ! 3857: STBA_R	stba	%r10, [%r21 + %r0] 0x25
	.word 0xd4bce000  ! 3858: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 3859: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcc44400  ! 3860: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xd6b70e80  ! 3861: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	.word 0x87802072  ! 3862: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0bfce60  ! 3863: STDA_R	stda	%r8, [%r31 + %r0] 0x73
	mov	0x8, %r24
	.word 0xd0df2000  ! 3865: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0a7e000  ! 3866: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 3867: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b72000  ! 3868: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd0a72000  ! 3869: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 3870: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6870e40  ! 3871: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r11
	mov	0x28, %r26
	.word 0xd0b6c9e0  ! 3873: STHA_R	stha	%r8, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 3874: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r23
	.word 0xd0ace000  ! 3876: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	mov	0x7c8, %r23
	mov	0x3e0, %r21
	.word 0xd08ce000  ! 3879: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0x87802025  ! 3880: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcc40400  ! 3881: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	.word 0xdcb5a000  ! 3882: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0xdcf52000  ! 3883: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	.word 0xd685c4a0  ! 3884: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r11
	.word 0xdeac8400  ! 3885: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xda95c4a0  ! 3886: LDUHA_R	lduha	[%r23, %r0] 0x25, %r13
	.word 0xd6df4e60  ! 3887: LDXA_R	ldxa	[%r29, %r0] 0x73, %r11
	.word 0xd6cd6000  ! 3888: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r11
	.word 0xdcd70e40  ! 3889: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r14
	.word 0x87802072  ! 3890: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3891: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 3892: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r24
	mov	0x38, %r19
	.word 0xdca5a000  ! 3895: STWA_I	stwa	%r14, [%r22 + 0x0000] %asi
	mov	0x7f0, %r20
	mov	0x20, %r16
	.word 0xdca52000  ! 3898: STWA_I	stwa	%r14, [%r20 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0xdabf8e40  ! 3900: STDA_R	stda	%r13, [%r30 + %r0] 0x72
	.word 0xda9de000  ! 3901: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r13
	.word 0xd8cf8e60  ! 3902: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r12
	.word 0xd69d04a0  ! 3903: LDDA_R	ldda	[%r20, %r0] 0x25, %r11
	.word 0xd6bd2000  ! 3904: STDA_I	stda	%r11, [%r20 + 0x0000] %asi
	.word 0xdcf48400  ! 3905: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	mov	0x7c8, %r23
	.word 0xdc85a000  ! 3907: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r14
	.word 0xdecd84a0  ! 3908: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r15
	.word 0xd4bc4400  ! 3909: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	mov	0x58, %r18
	.word 0xd4c52000  ! 3911: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r10
	.word 0xd4d78e60  ! 3912: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r10
	.word 0xd4bd2000  ! 3913: STDA_I	stda	%r10, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 3914: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f544a0  ! 3915: STXA_R	stxa	%r10, [%r21 + %r0] 0x25
	.word 0xd4afe000  ! 3916: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd2bc0400  ! 3917: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xda874e60  ! 3918: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r13
	mov	0x7e0, %r21
	mov	0x38, %r25
	mov	0x20, %r25
	.word 0xdeb48400  ! 3922: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xda8fce60  ! 3923: LDUBA_R	lduba	[%r31, %r0] 0x73, %r13
	mov	0x7c8, %r23
	.word 0x87802025  ! 3925: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad56000  ! 3926: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r13
	mov	0x28, %r27
	mov	0x3d0, %r22
	.word 0xdac78e60  ! 3929: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r13
	mov	0x7d8, %r21
	.word 0xd8bc4400  ! 3931: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xde9fce60  ! 3932: LDDA_R	ldda	[%r31, %r0] 0x73, %r15
	mov	0x3c0, %r23
	.word 0xdedde000  ! 3934: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r15
	mov	0x7d8, %r21
	.word 0x87802073  ! 3936: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd48544a0  ! 3937: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r10
	.word 0xdec70e80  ! 3938: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r15
	.word 0x87802074  ! 3939: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 3940: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2a44400  ! 3941: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xd2dfe000  ! 3942: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2c72000  ! 3943: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd4a584a0  ! 3944: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	.word 0xd4cfe000  ! 3945: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 3946: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd29f8e60  ! 3947: LDDA_R	ldda	[%r30, %r0] 0x73, %r9
	.word 0xd4a70e80  ! 3948: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	.word 0xdad4c400  ! 3949: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xdaae6000  ! 3950: STBA_I	stba	%r13, [%r25 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xda8ee000  ! 3952: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r13
	.word 0xda9e2000  ! 3953: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r13
	.word 0xd4a504a0  ! 3954: STWA_R	stwa	%r10, [%r20 + %r0] 0x25
	.word 0xd4a62000  ! 3955: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	mov	0x10, %r25
	.word 0xd6f78e60  ! 3957: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	mov	0x68, %r27
	mov	0x0, %r17
	.word 0xdef74e60  ! 3960: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	.word 0xd48cc400  ! 3961: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	.word 0xd4dee000  ! 3962: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r10
	.word 0xd4aee000  ! 3963: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	mov	0x70, %r16
	.word 0xd88e89e0  ! 3965: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r12
	.word 0xd8f62000  ! 3966: STXA_I	stxa	%r12, [%r24 + 0x0000] %asi
	.word 0xd8bea000  ! 3967: STDA_I	stda	%r12, [%r26 + 0x0000] %asi
	.word 0xdaf689e0  ! 3968: STXA_R	stxa	%r13, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 3969: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8cfce40  ! 3970: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r12
	mov	0x8, %r18
	mov	0x48, %r27
	.word 0x87802073  ! 3973: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r16
	.word 0xde8c8400  ! 3975: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	.word 0xdebfe000  ! 3976: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xd0d70e80  ! 3977: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r8
	.word 0xd69f4e60  ! 3978: LDDA_R	ldda	[%r29, %r0] 0x73, %r11
	mov	0x3f0, %r23
	.word 0xdecc0400  ! 3980: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r15
	.word 0xdecfe000  ! 3981: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0x87802073  ! 3982: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaaf4e40  ! 3983: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	.word 0xdac72000  ! 3984: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	mov	0x3c0, %r20
	.word 0xdaaf2000  ! 3986: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xd4b40400  ! 3987: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0xd6f544a0  ! 3988: STXA_R	stxa	%r11, [%r21 + %r0] 0x25
	.word 0x8780204f  ! 3989: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r17
	.word 0xdcb70e80  ! 3991: STHA_R	stha	%r14, [%r28 + %r0] 0x74
	.word 0xdcd66000  ! 3992: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r14
	.word 0xdcd74e80  ! 3993: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r14
	.word 0x8780204f  ! 3994: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 3995: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r27
	.word 0xd88dc4a0  ! 3997: LDUBA_R	lduba	[%r23, %r0] 0x25, %r12
	mov	0x18, %r27
	.word 0x87802020  ! 3999: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r25
	.word 0xd8bce000  ! 4001: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	mov	0x58, %r17
	.word 0x87802025  ! 4003: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r25
	.word 0xdef689e0  ! 4005: STXA_R	stxa	%r15, [%r26 + %r0] 0x4f
	mov	0x48, %r24
	.word 0xdebd2000  ! 4007: STDA_I	stda	%r15, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 4008: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2874e80  ! 4009: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r9
	.word 0xd28e89e0  ! 4010: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r9
	.word 0xd4be49e0  ! 4011: STDA_R	stda	%r10, [%r25 + %r0] 0x4f
	.word 0xdcc40400  ! 4012: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	.word 0xd6bc8400  ! 4013: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0x87802074  ! 4014: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 4015: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6a7a000  ! 4016: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd68f6000  ! 4017: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6872000  ! 4018: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6f7a000  ! 4019: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd0f7ce60  ! 4020: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	mov	0x40, %r24
	.word 0xd6b7ce60  ! 4022: STHA_R	stha	%r11, [%r31 + %r0] 0x73
	mov	0x3d8, %r20
	.word 0xd2de89e0  ! 4024: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r9
	.word 0xd2bfe000  ! 4025: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd2a7a000  ! 4026: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xd4a78e60  ! 4027: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	.word 0x87802073  ! 4028: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca48400  ! 4029: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xdcb76000  ! 4030: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xdcbfa000  ! 4031: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xd4d504a0  ! 4032: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r10
	.word 0xd4f72000  ! 4033: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4d7e000  ! 4034: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	.word 0xd0bfce80  ! 4035: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	.word 0xd6cf4e40  ! 4036: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r11
	.word 0xd4cf8e40  ! 4037: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r10
	mov	0x7f0, %r21
	.word 0xdcf4c400  ! 4039: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	mov	0x0, %r16
	.word 0xd28cc400  ! 4041: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	mov	0x30, %r18
	mov	0x40, %r19
	.word 0xd6ce09e0  ! 4044: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r11
	mov	0x20, %r27
	.word 0xd4f649e0  ! 4046: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	mov	0x3d8, %r22
	.word 0x87802025  ! 4048: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 4049: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 4050: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde8d44a0  ! 4051: LDUBA_R	lduba	[%r21, %r0] 0x25, %r15
	.word 0x87802072  ! 4052: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf584a0  ! 4053: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	.word 0x87802025  ! 4054: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r24
	.word 0xda856000  ! 4056: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r13
	mov	0x70, %r19
	.word 0xd4c40400  ! 4058: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	.word 0xd4856000  ! 4059: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r10
	.word 0xd49de000  ! 4060: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r10
	.word 0xd4dd84a0  ! 4061: LDXA_R	ldxa	[%r22, %r0] 0x25, %r10
	.word 0xd49d6000  ! 4062: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r10
	mov	0x40, %r18
	.word 0xd4ad2000  ! 4064: STBA_I	stba	%r10, [%r20 + 0x0000] %asi
	mov	0x38, %r25
	.word 0xd8f48400  ! 4066: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xd4b70e40  ! 4067: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	.word 0x87802072  ! 4068: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4c48400  ! 4069: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r10
	.word 0xd487e000  ! 4070: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xdef48400  ! 4071: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xdef72000  ! 4072: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 4073: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde872000  ! 4074: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xdacd84a0  ! 4075: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r13
	.word 0xda9f2000  ! 4076: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xdaa7e000  ! 4077: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	mov	0x30, %r24
	mov	0x7f8, %r22
	.word 0x87802072  ! 4080: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabfa000  ! 4081: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdab7e000  ! 4082: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xdaaf6000  ! 4083: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0xda8f2000  ! 4085: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0x87802072  ! 4086: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r25
	.word 0xda9fce80  ! 4088: LDDA_R	ldda	[%r31, %r0] 0x74, %r13
	.word 0xdacf2000  ! 4089: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0x87802072  ! 4090: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabf6000  ! 4091: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xdac72000  ! 4092: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0xdaafe000  ! 4093: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 4094: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r24
	.word 0xd08e89e0  ! 4096: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r8
	mov	0x28, %r18
	.word 0xd0bc0400  ! 4098: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	mov	0x30, %r18
	.word 0xd0d76000  ! 4100: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xd08f6000  ! 4101: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r8
	.word 0xd0af2000  ! 4102: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0bfe000  ! 4103: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd0afe000  ! 4104: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0f7a000  ! 4105: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	mov	0x10, %r18
	mov	0x3d0, %r21
	mov	0x8, %r18
	.word 0xd0cf6000  ! 4109: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0x87802073  ! 4110: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4111: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d504a0  ! 4112: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r11
	.word 0xd6bc2000  ! 4113: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0xd6a4a000  ! 4114: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	.word 0xd6bce000  ! 4115: STDA_I	stda	%r11, [%r19 + 0x0000] %asi
	.word 0xd68c2000  ! 4116: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r11
	mov	0x7c0, %r23
	mov	0x0, %r16
	.word 0xd897ce40  ! 4119: LDUHA_R	lduha	[%r31, %r0] 0x72, %r12
	mov	0x20, %r17
	.word 0xd2df8e60  ! 4121: LDXA_R	ldxa	[%r30, %r0] 0x73, %r9
	.word 0xd887ce60  ! 4122: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r12
	.word 0xdcacc400  ! 4123: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0xd6b7ce80  ! 4124: STHA_R	stha	%r11, [%r31 + %r0] 0x74
	.word 0xd48649e0  ! 4125: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r10
	.word 0xdaac0400  ! 4126: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xd49504a0  ! 4127: LDUHA_R	lduha	[%r20, %r0] 0x25, %r10
	.word 0xd2af0e60  ! 4128: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	.word 0xd28ca000  ! 4129: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0x87802073  ! 4130: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f7a000  ! 4131: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xd294c400  ! 4132: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	.word 0xde9689e0  ! 4133: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r15
	.word 0xd8d4c400  ! 4134: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0xd8df2000  ! 4135: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xd6c44400  ! 4136: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r11
	.word 0xdc9c4400  ! 4137: LDDA_R	ldda	[%r17, %r0] 0x20, %r14
	.word 0x87802025  ! 4138: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8a6c9e0  ! 4139: STWA_R	stwa	%r12, [%r27 + %r0] 0x4f
	mov	0x38, %r27
	.word 0xd8ad6000  ! 4141: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	.word 0xd8ac8400  ! 4142: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0xd8856000  ! 4143: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4144: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ace000  ! 4145: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 4146: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4147: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4148: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r26
	.word 0xd8946000  ! 4150: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	.word 0xd8d42000  ! 4151: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0xda8e09e0  ! 4152: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r13
	mov	0x20, %r19
	.word 0xdaf42000  ! 4154: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0xd2940400  ! 4155: LDUHA_R	lduha	[%r16, %r0] 0x20, %r9
	.word 0x87802072  ! 4156: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b72000  ! 4157: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd2afe000  ! 4158: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0xd2876000  ! 4160: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	mov	0x50, %r26
	.word 0xd4d44400  ! 4162: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	mov	0x3d8, %r22
	mov	0x20, %r19
	.word 0x87802025  ! 4165: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 4166: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4c7a000  ! 4167: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	.word 0xd2a48400  ! 4168: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0x87802020  ! 4169: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4170: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r26
	.word 0xd2a7a000  ! 4172: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xd6af0e60  ! 4173: STBA_R	stba	%r11, [%r28 + %r0] 0x73
	mov	0x48, %r24
	.word 0xda8f4e80  ! 4175: LDUBA_R	lduba	[%r29, %r0] 0x74, %r13
	.word 0x87802073  ! 4176: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r19
	.word 0xdab76000  ! 4178: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xd8b78e40  ! 4179: STHA_R	stha	%r12, [%r30 + %r0] 0x72
	.word 0xd6d70e60  ! 4180: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r11
	.word 0xdef70e80  ! 4181: STXA_R	stxa	%r15, [%r28 + %r0] 0x74
	.word 0xd09584a0  ! 4182: LDUHA_R	lduha	[%r22, %r0] 0x25, %r8
	.word 0xd0a76000  ! 4183: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0d72000  ! 4184: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0af2000  ! 4185: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	mov	0x60, %r17
	.word 0xd0b7e000  ! 4187: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0xd0dfe000  ! 4188: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	mov	0x58, %r26
	mov	0x3e8, %r22
	.word 0xdab4c400  ! 4191: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xd0d48400  ! 4192: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	.word 0xd6df0e40  ! 4193: LDXA_R	ldxa	[%r28, %r0] 0x72, %r11
	.word 0xde978e40  ! 4194: LDUHA_R	lduha	[%r30, %r0] 0x72, %r15
	.word 0xde944400  ! 4195: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	.word 0x87802072  ! 4196: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r16
	.word 0xdecfe000  ! 4198: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	mov	0x7c8, %r23
	.word 0x87802020  ! 4200: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08f0e80  ! 4201: LDUBA_R	lduba	[%r28, %r0] 0x74, %r8
	.word 0xd4b40400  ! 4202: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0xd4f4a000  ! 4203: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0xd2dd04a0  ! 4204: LDXA_R	ldxa	[%r20, %r0] 0x25, %r9
	.word 0xd2a4e000  ! 4205: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2b46000  ! 4206: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 4207: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2ad2000  ! 4208: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xd29d6000  ! 4209: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r9
	.word 0xd2f56000  ! 4210: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	.word 0xdccfce80  ! 4211: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r14
	.word 0xdcc52000  ! 4212: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r14
	.word 0xdcd52000  ! 4213: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r14
	.word 0xdcb56000  ! 4214: STHA_I	stha	%r14, [%r21 + 0x0000] %asi
	mov	0x38, %r25
	.word 0xdccd6000  ! 4216: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r14
	.word 0xdcf5a000  ! 4217: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	.word 0xda874e40  ! 4218: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r13
	.word 0xd09ec9e0  ! 4219: LDDA_R	ldda	[%r27, %r0] 0x4f, %r8
	.word 0xd09de000  ! 4220: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r8
	.word 0x87802025  ! 4221: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bec9e0  ! 4222: STDA_R	stda	%r9, [%r27 + %r0] 0x4f
	.word 0xdebf8e60  ! 4223: STDA_R	stda	%r15, [%r30 + %r0] 0x73
	mov	0x68, %r26
	.word 0x87802020  ! 4225: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c44400  ! 4226: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r10
	.word 0xd4b48400  ! 4227: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd4f649e0  ! 4228: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	mov	0x3c0, %r23
	.word 0xd4f504a0  ! 4230: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0x87802073  ! 4231: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c0, %r23
	.word 0xdebf0e60  ! 4233: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	.word 0xd69f4e80  ! 4234: LDDA_R	ldda	[%r29, %r0] 0x74, %r11
	mov	0x78, %r25
	.word 0xd8adc4a0  ! 4236: STBA_R	stba	%r12, [%r23 + %r0] 0x25
	.word 0xd6cf8e80  ! 4237: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r11
	.word 0xda9d04a0  ! 4238: LDDA_R	ldda	[%r20, %r0] 0x25, %r13
	.word 0xd69fce60  ! 4239: LDDA_R	ldda	[%r31, %r0] 0x73, %r11
	mov	0x7c8, %r21
	mov	0x3d8, %r21
	mov	0x68, %r19
	.word 0xd6f7e000  ! 4243: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6c72000  ! 4244: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	mov	0x50, %r18
	.word 0x8780204f  ! 4246: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 4247: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a5a000  ! 4248: STWA_I	stwa	%r11, [%r22 + 0x0000] %asi
	.word 0xd6cd2000  ! 4249: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r11
	.word 0x87802020  ! 4250: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c689e0  ! 4251: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r12
	.word 0xd0d584a0  ! 4252: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r8
	.word 0xdcf78e80  ! 4253: STXA_R	stxa	%r14, [%r30 + %r0] 0x74
	.word 0xdcbc8400  ! 4254: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	mov	0x70, %r17
	.word 0xdcf4e000  ! 4256: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xd48dc4a0  ! 4257: LDUBA_R	lduba	[%r23, %r0] 0x25, %r10
	.word 0xd4f46000  ! 4258: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0xdea78e40  ! 4259: STWA_R	stwa	%r15, [%r30 + %r0] 0x72
	mov	0x78, %r18
	mov	0x8, %r26
	.word 0xdebca000  ! 4262: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xd296c9e0  ! 4263: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r9
	.word 0xda9f0e60  ! 4264: LDDA_R	ldda	[%r28, %r0] 0x73, %r13
	mov	0x7c0, %r21
	.word 0xdeaf4e60  ! 4266: STBA_R	stba	%r15, [%r29 + %r0] 0x73
	.word 0xdeace000  ! 4267: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xdebce000  ! 4268: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xd4f6c9e0  ! 4269: STXA_R	stxa	%r10, [%r27 + %r0] 0x4f
	.word 0xd29609e0  ! 4270: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r9
	.word 0xd0f544a0  ! 4271: STXA_R	stxa	%r8, [%r21 + %r0] 0x25
	.word 0xdaafce60  ! 4272: STBA_R	stba	%r13, [%r31 + %r0] 0x73
	.word 0x87802025  ! 4273: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4f70e40  ! 4274: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	.word 0xd4f5a000  ! 4275: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	.word 0xdecc8400  ! 4276: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	.word 0xd2acc400  ! 4277: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0xd6f70e80  ! 4278: STXA_R	stxa	%r11, [%r28 + %r0] 0x74
	mov	0x48, %r19
	.word 0xd2b40400  ! 4280: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0xda9544a0  ! 4281: LDUHA_R	lduha	[%r21, %r0] 0x25, %r13
	.word 0xd4c48400  ! 4282: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r10
	.word 0x8780204f  ! 4283: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r18
	mov	0x50, %r16
	.word 0xd4a6a000  ! 4286: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	.word 0xd4862000  ! 4287: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r10
	mov	0x7c0, %r21
	.word 0x87802074  ! 4289: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4290: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bc0400  ! 4291: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xdaac0400  ! 4292: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xdabc2000  ! 4293: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 4294: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 4295: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 4296: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 4297: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 4298: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r25
	.word 0xdab72000  ! 4300: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 4301: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r25
	.word 0xd4a78e40  ! 4303: STWA_R	stwa	%r10, [%r30 + %r0] 0x72
	.word 0x87802020  ! 4304: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r21
	.word 0xd4bc2000  ! 4306: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0xda970e80  ! 4307: LDUHA_R	lduha	[%r28, %r0] 0x74, %r13
	mov	0x20, %r17
	.word 0xdaaca000  ! 4309: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	mov	0x28, %r26
	mov	0x30, %r17
	mov	0x3d8, %r20
	mov	0x60, %r25
	.word 0xdacce000  ! 4314: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r13
	mov	0x70, %r17
	.word 0xdcd7ce80  ! 4316: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r14
	mov	0x7d0, %r21
	.word 0x87802020  ! 4318: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcc4a000  ! 4319: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r14
	mov	0x7e8, %r21
	mov	0x28, %r27
	.word 0xdea5c4a0  ! 4322: STWA_R	stwa	%r15, [%r23 + %r0] 0x25
	.word 0xdad48400  ! 4323: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0xdac4a000  ! 4324: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	.word 0xdab70e80  ! 4325: STHA_R	stha	%r13, [%r28 + %r0] 0x74
	.word 0x87802020  ! 4326: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdacc2000  ! 4327: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xd2f609e0  ! 4328: STXA_R	stxa	%r9, [%r24 + %r0] 0x4f
	.word 0x87802025  ! 4329: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2c5a000  ! 4330: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r9
	.word 0xd2ada000  ! 4331: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xd2856000  ! 4332: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r9
	.word 0xd2ad2000  ! 4333: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xd2b5a000  ! 4334: STHA_I	stha	%r9, [%r22 + 0x0000] %asi
	.word 0xd4f544a0  ! 4335: STXA_R	stxa	%r10, [%r21 + %r0] 0x25
	mov	0x40, %r18
	.word 0x87802073  ! 4337: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f8, %r20
	.word 0xd4afe000  ! 4339: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd4d76000  ! 4340: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	mov	0x40, %r26
	mov	0x28, %r16
	mov	0x18, %r19
	.word 0xdef78e40  ! 4344: STXA_R	stxa	%r15, [%r30 + %r0] 0x72
	.word 0xd2970e40  ! 4345: LDUHA_R	lduha	[%r28, %r0] 0x72, %r9
	mov	0x58, %r18
	.word 0xd4c40400  ! 4347: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	.word 0xd4844400  ! 4348: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0xd4af2000  ! 4349: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	mov	0x3c8, %r21
	mov	0x8, %r25
	.word 0x87802020  ! 4352: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f42000  ! 4353: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd4ac6000  ! 4354: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	.word 0xd89cc400  ! 4355: LDDA_R	ldda	[%r19, %r0] 0x20, %r12
	.word 0xd8842000  ! 4356: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	.word 0xd08f4e60  ! 4357: LDUBA_R	lduba	[%r29, %r0] 0x73, %r8
	.word 0xd0cce000  ! 4358: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0xd09ce000  ! 4359: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r8
	.word 0xde9e49e0  ! 4360: LDDA_R	ldda	[%r25, %r0] 0x4f, %r15
	.word 0xdc85c4a0  ! 4361: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r14
	.word 0x87802073  ! 4362: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf72000  ! 4363: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	mov	0x58, %r19
	.word 0xdad5c4a0  ! 4365: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r13
	.word 0xda8fa000  ! 4366: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	mov	0x50, %r17
	.word 0x8780204f  ! 4368: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r27
	.word 0xd8af0e80  ! 4370: STBA_R	stba	%r12, [%r28 + %r0] 0x74
	mov	0x3c0, %r22
	.word 0xd89ea000  ! 4372: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r12
	mov	0x3e0, %r23
	.word 0xd0df8e80  ! 4374: LDXA_R	ldxa	[%r30, %r0] 0x74, %r8
	.word 0xd0bea000  ! 4375: STDA_I	stda	%r8, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 4376: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bc2000  ! 4377: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 4378: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 4379: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0df6000  ! 4380: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	mov	0x60, %r26
	.word 0xd0a76000  ! 4382: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 4383: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cdc4a0  ! 4384: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r9
	.word 0x87802020  ! 4385: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r19
	mov	0x28, %r16
	.word 0xd2dca000  ! 4388: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r9
	.word 0xdaa649e0  ! 4389: STWA_R	stwa	%r13, [%r25 + %r0] 0x4f
	mov	0x78, %r27
	.word 0xdabca000  ! 4391: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdeb74e80  ! 4392: STHA_R	stha	%r15, [%r29 + %r0] 0x74
	mov	0x40, %r27
	mov	0x70, %r24
	.word 0xde9c2000  ! 4395: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	mov	0x68, %r27
	.word 0xded4a000  ! 4397: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 4398: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8870e40  ! 4399: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r12
	.word 0x8780204f  ! 4400: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r18
	.word 0xd88ee000  ! 4402: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r12
	.word 0xd8a62000  ! 4403: STWA_I	stwa	%r12, [%r24 + 0x0000] %asi
	.word 0xd8f66000  ! 4404: STXA_I	stxa	%r12, [%r25 + 0x0000] %asi
	.word 0xd8b62000  ! 4405: STHA_I	stha	%r12, [%r24 + 0x0000] %asi
	mov	0x10, %r26
	mov	0x50, %r19
	.word 0xd8a44400  ! 4408: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0x87802073  ! 4409: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8bf2000  ! 4410: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xdebe49e0  ! 4412: STDA_R	stda	%r15, [%r25 + %r0] 0x4f
	.word 0xd0bfce60  ! 4413: STDA_R	stda	%r8, [%r31 + %r0] 0x73
	.word 0xd6de89e0  ! 4414: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r11
	mov	0x3e8, %r23
	.word 0xdac6c9e0  ! 4416: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r13
	.word 0xd6b70e80  ! 4417: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	.word 0xd2844400  ! 4418: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	.word 0xd2f72000  ! 4419: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd29fe000  ! 4420: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd2b7e000  ! 4421: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2f72000  ! 4422: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd287ce60  ! 4423: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r9
	.word 0xd2cfe000  ! 4424: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	.word 0xd2f72000  ! 4425: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	mov	0x20, %r16
	.word 0x87802072  ! 4427: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r19
	mov	0x68, %r25
	.word 0xd2b72000  ! 4430: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd09d44a0  ! 4431: LDDA_R	ldda	[%r21, %r0] 0x25, %r8
	.word 0xd4d44400  ! 4432: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0xd4afe000  ! 4433: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 4434: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r18
	.word 0xd4aca000  ! 4436: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 4437: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f7e000  ! 4438: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 4439: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xded70e60  ! 4440: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r15
	.word 0xdeaee000  ! 4441: STBA_I	stba	%r15, [%r27 + 0x0000] %asi
	.word 0xdea62000  ! 4442: STWA_I	stwa	%r15, [%r24 + 0x0000] %asi
	mov	0x48, %r26
	mov	0x0, %r26
	.word 0xd6ae89e0  ! 4445: STBA_R	stba	%r11, [%r26 + %r0] 0x4f
	.word 0xdaf609e0  ! 4446: STXA_R	stxa	%r13, [%r24 + %r0] 0x4f
	.word 0xda962000  ! 4447: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r13
	.word 0xd4adc4a0  ! 4448: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0xd4b6a000  ! 4449: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	.word 0xd8bc4400  ! 4450: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xd8a6e000  ! 4451: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	.word 0xd88ea000  ! 4452: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r12
	mov	0x7c0, %r22
	.word 0xd8b6a000  ! 4454: STHA_I	stha	%r12, [%r26 + 0x0000] %asi
	.word 0xd68dc4a0  ! 4455: LDUBA_R	lduba	[%r23, %r0] 0x25, %r11
	.word 0xd696e000  ! 4456: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	.word 0xd6d78e80  ! 4457: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r11
	mov	0x3f8, %r21
	.word 0xd88649e0  ! 4459: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r12
	.word 0xd4cd84a0  ! 4460: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r10
	.word 0xd4ae2000  ! 4461: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	mov	0x7c0, %r20
	.word 0x87802020  ! 4463: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a4e000  ! 4464: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xd8de09e0  ! 4465: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r12
	.word 0xdc9c4400  ! 4466: LDDA_R	ldda	[%r17, %r0] 0x20, %r14
	.word 0x87802020  ! 4467: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r23
	.word 0xdc874e60  ! 4469: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r14
	mov	0x7d8, %r22
	.word 0xdcd46000  ! 4471: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	.word 0xdad74e80  ! 4472: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r13
	.word 0xdabca000  ! 4473: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdad46000  ! 4474: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	.word 0xdca7ce60  ! 4475: STWA_R	stwa	%r14, [%r31 + %r0] 0x73
	.word 0xdcb42000  ! 4476: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xdccc2000  ! 4477: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r14
	.word 0xd2c70e40  ! 4478: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r9
	.word 0xd2b4e000  ! 4479: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 4480: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd88584a0  ! 4481: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r12
	.word 0x87802020  ! 4482: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8dc2000  ! 4483: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0xd4b7ce40  ! 4484: STHA_R	stha	%r10, [%r31 + %r0] 0x72
	.word 0xd4a4e000  ! 4485: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 4486: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d4a000  ! 4487: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0xdab40400  ! 4488: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xda8ca000  ! 4489: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r13
	mov	0x20, %r25
	.word 0x8780204f  ! 4491: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 4492: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r16
	.word 0xda8f6000  ! 4494: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4495: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa48400  ! 4496: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0xdcdf4e80  ! 4497: LDXA_R	ldxa	[%r29, %r0] 0x74, %r14
	.word 0xdcbc2000  ! 4498: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 4499: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcc72000  ! 4500: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0x87802073  ! 4501: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r25
	.word 0xdcf76000  ! 4503: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdca7e000  ! 4504: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcbf0e60  ! 4505: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	.word 0x87802020  ! 4506: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4507: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcc72000  ! 4508: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xdc87a000  ! 4509: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	mov	0x7e8, %r20
	.word 0x87802020  ! 4511: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbc6000  ! 4512: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xdc842000  ! 4513: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4514: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccc2000  ! 4515: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r14
	mov	0x7c8, %r20
	.word 0xdcace000  ! 4517: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0xd6ac8400  ! 4518: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	mov	0x7c8, %r20
	.word 0xd69c2000  ! 4520: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r11
	.word 0xd684a000  ! 4521: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r11
	.word 0xdaf44400  ! 4522: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0xd2d4c400  ! 4523: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r9
	.word 0xd8f7ce60  ! 4524: STXA_R	stxa	%r12, [%r31 + %r0] 0x73
	.word 0x87802025  ! 4525: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f0, %r21
	.word 0xd0aec9e0  ! 4527: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	.word 0xd085e000  ! 4528: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r8
	.word 0xd8c649e0  ! 4529: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r12
	.word 0xd8ad6000  ! 4530: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	.word 0xd8a52000  ! 4531: STWA_I	stwa	%r12, [%r20 + 0x0000] %asi
	mov	0x8, %r16
	mov	0x7c0, %r21
	.word 0xdcacc400  ! 4534: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0xdcbda000  ! 4535: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	.word 0x87802025  ! 4536: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc952000  ! 4537: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r14
	.word 0xdcf52000  ! 4538: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	.word 0xd8d649e0  ! 4539: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r12
	.word 0xd0c544a0  ! 4540: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r8
	mov	0x70, %r27
	.word 0x87802025  ! 4542: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cc0400  ! 4543: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r10
	.word 0xd4cde000  ! 4544: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r10
	mov	0x3d0, %r23
	.word 0xd495e000  ! 4546: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r10
	.word 0x87802073  ! 4547: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f72000  ! 4548: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4adc4a0  ! 4549: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0x87802020  ! 4550: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8cf4e80  ! 4551: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r12
	.word 0xd8d649e0  ! 4552: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r12
	mov	0x7e8, %r20
	mov	0x3c0, %r23
	.word 0xd697ce60  ! 4555: LDUHA_R	lduha	[%r31, %r0] 0x73, %r11
	.word 0x87802025  ! 4556: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4557: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdecdc4a0  ! 4558: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r15
	.word 0xdec4a000  ! 4559: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xdecc2000  ! 4560: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 4561: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde8e2000  ! 4562: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r15
	.word 0x87802020  ! 4563: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09649e0  ! 4564: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r8
	.word 0xd0aca000  ! 4565: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	mov	0x40, %r24
	.word 0x87802072  ! 4567: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0df2000  ! 4568: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0xd8ce09e0  ! 4569: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r12
	.word 0x87802025  ! 4570: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b74e60  ! 4571: STHA_R	stha	%r11, [%r29 + %r0] 0x73
	.word 0xd49fce60  ! 4572: LDDA_R	ldda	[%r31, %r0] 0x73, %r10
	.word 0x8780204f  ! 4573: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 4574: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4972000  ! 4575: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0xd0bf8e60  ! 4576: STDA_R	stda	%r8, [%r30 + %r0] 0x73
	.word 0xd0afe000  ! 4577: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0f544a0  ! 4578: STXA_R	stxa	%r8, [%r21 + %r0] 0x25
	.word 0xd0c76000  ! 4579: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0xdcd7ce60  ! 4580: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r14
	.word 0xd2d78e40  ! 4581: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r9
	.word 0x87802020  ! 4582: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2940400  ! 4583: LDUHA_R	lduha	[%r16, %r0] 0x20, %r9
	.word 0x87802073  ! 4584: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4585: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r16
	.word 0x87802072  ! 4587: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb4c400  ! 4588: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0x87802073  ! 4589: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c0, %r21
	.word 0xdc876000  ! 4591: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0xdcc7e000  ! 4592: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0xdc8fa000  ! 4593: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdcaf2000  ! 4594: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xdc9f2000  ! 4596: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xdcafe000  ! 4597: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xd2cc8400  ! 4598: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0x87802020  ! 4599: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4600: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f609e0  ! 4601: STXA_R	stxa	%r9, [%r24 + %r0] 0x4f
	.word 0xd2aea000  ! 4602: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0xd2c66000  ! 4603: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r9
	mov	0x7d8, %r22
	.word 0xd88dc4a0  ! 4605: LDUBA_R	lduba	[%r23, %r0] 0x25, %r12
	mov	0x30, %r17
	.word 0xd8bea000  ! 4607: STDA_I	stda	%r12, [%r26 + 0x0000] %asi
	.word 0xd886a000  ! 4608: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r12
	.word 0xd8af8e80  ! 4609: STBA_R	stba	%r12, [%r30 + %r0] 0x74
	mov	0x18, %r17
	.word 0xd8b40400  ! 4611: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xdebf8e80  ! 4612: STDA_R	stda	%r15, [%r30 + %r0] 0x74
	.word 0x87802073  ! 4613: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4614: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r25
	.word 0xdef46000  ! 4616: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xd89d44a0  ! 4617: LDDA_R	ldda	[%r21, %r0] 0x25, %r12
	mov	0x68, %r18
	mov	0x58, %r26
	.word 0x87802020  ! 4620: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4621: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd89e6000  ! 4622: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r12
	.word 0xd0bfce60  ! 4623: STDA_R	stda	%r8, [%r31 + %r0] 0x73
	.word 0xd8cf8e40  ! 4624: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r12
	.word 0xd8a6a000  ! 4625: STWA_I	stwa	%r12, [%r26 + 0x0000] %asi
	.word 0xd8b62000  ! 4626: STHA_I	stha	%r12, [%r24 + 0x0000] %asi
	.word 0xd89584a0  ! 4627: LDUHA_R	lduha	[%r22, %r0] 0x25, %r12
	.word 0x87802020  ! 4628: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r22
	.word 0x87802074  ! 4630: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd897a000  ! 4631: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4632: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4633: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd08c8400  ! 4634: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0xd0b7a000  ! 4635: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd0afa000  ! 4636: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd0c72000  ! 4637: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	mov	0x68, %r27
	.word 0x87802073  ! 4639: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0df8e60  ! 4640: LDXA_R	ldxa	[%r30, %r0] 0x73, %r8
	.word 0x87802025  ! 4641: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r26
	.word 0xd8af4e80  ! 4643: STBA_R	stba	%r12, [%r29 + %r0] 0x74
	.word 0xd8f52000  ! 4644: STXA_I	stxa	%r12, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 4645: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8584a0  ! 4646: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r15
	mov	0x10, %r17
	.word 0xdca74e80  ! 4648: STWA_R	stwa	%r14, [%r29 + %r0] 0x74
	.word 0x87802073  ! 4649: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca72000  ! 4650: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xd4dc8400  ! 4651: LDXA_R	ldxa	[%r18, %r0] 0x20, %r10
	.word 0xd4a7e000  ! 4652: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd2874e40  ! 4653: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r9
	mov	0x0, %r18
	.word 0x8780204f  ! 4655: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 4656: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r27
	.word 0xd6b504a0  ! 4658: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	.word 0xd2d5c4a0  ! 4659: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r9
	.word 0x87802025  ! 4660: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 4661: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4662: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a4a000  ! 4663: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0xd8af4e60  ! 4664: STBA_R	stba	%r12, [%r29 + %r0] 0x73
	mov	0x58, %r19
	.word 0xd4c584a0  ! 4666: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r10
	.word 0xda8fce80  ! 4667: LDUBA_R	lduba	[%r31, %r0] 0x74, %r13
	.word 0xde878e40  ! 4668: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r15
	.word 0xdea48400  ! 4669: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xdec4a000  ! 4670: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xde9ca000  ! 4671: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	.word 0x87802072  ! 4672: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r17
	.word 0xd2cf4e40  ! 4674: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r9
	.word 0xd2f7e000  ! 4675: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd2df2000  ! 4676: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd0c689e0  ! 4677: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r8
	.word 0xd0c72000  ! 4678: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0x87802020  ! 4679: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bc6000  ! 4680: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	.word 0xdecf8e80  ! 4681: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r15
	mov	0x0, %r24
	.word 0x87802020  ! 4683: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r19
	.word 0xd8bc8400  ! 4685: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xda8f8e80  ! 4686: LDUBA_R	lduba	[%r30, %r0] 0x74, %r13
	.word 0x87802074  ! 4687: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4ac8400  ! 4688: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0xd4972000  ! 4689: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0xdc8584a0  ! 4690: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r14
	.word 0xd0840400  ! 4691: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	mov	0x38, %r24
	.word 0xd0c76000  ! 4693: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0af6000  ! 4694: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	mov	0x78, %r27
	mov	0x3c8, %r21
	.word 0xd4b4c400  ! 4697: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	mov	0x58, %r17
	.word 0xd49fe000  ! 4699: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	mov	0x70, %r26
	mov	0x70, %r17
	.word 0xd4876000  ! 4702: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xd49f2000  ! 4703: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd4b70e80  ! 4704: STHA_R	stha	%r10, [%r28 + %r0] 0x74
	mov	0x8, %r17
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdef584a0  ! 4707: STXA_R	stxa	%r15, [%r22 + %r0] 0x25
	mov	0x7f0, %r23
	.word 0xdef74e80  ! 4709: STXA_R	stxa	%r15, [%r29 + %r0] 0x74
	.word 0xdeb70e40  ! 4710: STHA_R	stha	%r15, [%r28 + %r0] 0x72
	mov	0x10, %r19
	.word 0xdadf0e40  ! 4712: LDXA_R	ldxa	[%r28, %r0] 0x72, %r13
	.word 0xdac48400  ! 4713: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	.word 0xdad74e80  ! 4714: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r13
	.word 0xdc8544a0  ! 4715: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r14
	.word 0xd4840400  ! 4716: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	.word 0xd8970e40  ! 4717: LDUHA_R	lduha	[%r28, %r0] 0x72, %r12
	mov	0x8, %r18
	.word 0xd8df2000  ! 4719: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8f5c4a0  ! 4720: STXA_R	stxa	%r12, [%r23 + %r0] 0x25
	.word 0x8780204f  ! 4721: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x48, %r25
	mov	0x7d0, %r21
	.word 0x87802073  ! 4724: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc96c9e0  ! 4725: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r14
	.word 0xdcbf2000  ! 4726: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	mov	0x7f8, %r20
	mov	0x70, %r19
	.word 0xdcc7a000  ! 4729: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdcf72000  ! 4731: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xd2a584a0  ! 4732: STWA_R	stwa	%r9, [%r22 + %r0] 0x25
	.word 0x87802073  ! 4733: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r26
	.word 0xd4af4e60  ! 4735: STBA_R	stba	%r10, [%r29 + %r0] 0x73
	.word 0xd0ae49e0  ! 4736: STBA_R	stba	%r8, [%r25 + %r0] 0x4f
	.word 0x8780204f  ! 4737: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 4738: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf544a0  ! 4739: STXA_R	stxa	%r14, [%r21 + %r0] 0x25
	.word 0xd4bcc400  ! 4740: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0xd4bf6000  ! 4741: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd8d689e0  ! 4742: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r12
	mov	0x20, %r18
	.word 0xd8f76000  ! 4744: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd69f4e40  ! 4745: LDDA_R	ldda	[%r29, %r0] 0x72, %r11
	mov	0x7d8, %r22
	.word 0xd8af4e60  ! 4747: STBA_R	stba	%r12, [%r29 + %r0] 0x73
	.word 0x87802073  ! 4748: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4bec9e0  ! 4749: STDA_R	stda	%r10, [%r27 + %r0] 0x4f
	mov	0x68, %r17
	.word 0xd0a6c9e0  ! 4751: STWA_R	stwa	%r8, [%r27 + %r0] 0x4f
	.word 0xd0d76000  ! 4752: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0c72000  ! 4753: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	mov	0x8, %r26
	.word 0xdad74e40  ! 4755: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r13
	.word 0xdaf72000  ! 4756: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 4757: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 4758: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xded584a0  ! 4759: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r15
	.word 0x87802020  ! 4760: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r25
	.word 0x8780204f  ! 4762: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 4763: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeaf2000  ! 4764: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xded76000  ! 4765: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0xda8584a0  ! 4766: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r13
	mov	0x68, %r18
	mov	0x3e0, %r21
	.word 0xdadcc400  ! 4769: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xd6a74e80  ! 4770: STWA_R	stwa	%r11, [%r29 + %r0] 0x74
	.word 0xdef689e0  ! 4771: STXA_R	stxa	%r15, [%r26 + %r0] 0x4f
	mov	0x8, %r17
	mov	0x7f8, %r22
	mov	0x70, %r27
	.word 0xded76000  ! 4775: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0x87802020  ! 4776: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8978e80  ! 4777: LDUHA_R	lduha	[%r30, %r0] 0x74, %r12
	.word 0x87802025  ! 4778: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r19
	mov	0x7f0, %r21
	.word 0x87802025  ! 4781: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6af0e40  ! 4782: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	.word 0xd4d40400  ! 4783: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	mov	0x68, %r16
	mov	0x7c0, %r21
	.word 0xd4a5a000  ! 4786: STWA_I	stwa	%r10, [%r22 + 0x0000] %asi
	mov	0x3f0, %r20
	.word 0xdcb78e40  ! 4788: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xd284c400  ! 4789: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r9
	mov	0x7e8, %r23
	.word 0x87802073  ! 4791: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f8, %r21
	.word 0xd2cf2000  ! 4793: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r9
	.word 0xd2bf6000  ! 4794: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd28f2000  ! 4795: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	.word 0xd2b76000  ! 4796: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd6b584a0  ! 4797: STHA_R	stha	%r11, [%r22 + %r0] 0x25
	.word 0x87802074  ! 4798: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 4799: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r17
	.word 0xda94c400  ! 4801: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	.word 0xda9fe000  ! 4802: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdaf72000  ! 4804: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 4805: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r26
	mov	0x3f8, %r21
	.word 0x87802072  ! 4808: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd69e09e0  ! 4809: LDDA_R	ldda	[%r24, %r0] 0x4f, %r11
	mov	0x20, %r27
	mov	0x0, %r25
	.word 0xd6afa000  ! 4812: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd295c4a0  ! 4813: LDUHA_R	lduha	[%r23, %r0] 0x25, %r9
	.word 0xd2bf2000  ! 4814: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd8f609e0  ! 4815: STXA_R	stxa	%r12, [%r24 + %r0] 0x4f
	.word 0xdadf4e60  ! 4816: LDXA_R	ldxa	[%r29, %r0] 0x73, %r13
	.word 0xdac7a000  ! 4817: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xd4c7ce80  ! 4818: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r10
	.word 0xdaa5c4a0  ! 4819: STWA_R	stwa	%r13, [%r23 + %r0] 0x25
	mov	0x7f8, %r23
	.word 0xdabfe000  ! 4821: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xdacf6000  ! 4822: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xd4940400  ! 4823: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	.word 0x87802020  ! 4824: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef70e60  ! 4825: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	.word 0xd4dfce40  ! 4826: LDXA_R	ldxa	[%r31, %r0] 0x72, %r10
	.word 0x87802020  ! 4827: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r23
	.word 0x87802073  ! 4829: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd48fce80  ! 4830: LDUBA_R	lduba	[%r31, %r0] 0x74, %r10
	.word 0xd2d689e0  ! 4831: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r9
	mov	0x20, %r25
	.word 0x87802072  ! 4833: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8bf4e60  ! 4834: STDA_R	stda	%r12, [%r29 + %r0] 0x73
	.word 0xd2f4c400  ! 4835: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xd2a7a000  ! 4836: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	mov	0x48, %r19
	.word 0xd287a000  ! 4838: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0xdaf4c400  ! 4839: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xda848400  ! 4840: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r13
	.word 0xda972000  ! 4841: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0xdab72000  ! 4842: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	mov	0x70, %r26
	.word 0xdaaf2000  ! 4844: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdadf6000  ! 4845: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xdaaf6000  ! 4846: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xda8f2000  ! 4847: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xda972000  ! 4848: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0xdab76000  ! 4849: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xda970e80  ! 4850: LDUHA_R	lduha	[%r28, %r0] 0x74, %r13
	.word 0xd8bc4400  ! 4851: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	mov	0x3d8, %r23
	.word 0xde8d44a0  ! 4853: LDUBA_R	lduba	[%r21, %r0] 0x25, %r15
	.word 0x87802074  ! 4854: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeafa000  ! 4855: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xdaa544a0  ! 4856: STWA_R	stwa	%r13, [%r21 + %r0] 0x25
	.word 0xd0ac8400  ! 4857: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xd0a7a000  ! 4858: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd097e000  ! 4859: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	mov	0x40, %r26
	.word 0xd0f689e0  ! 4861: STXA_R	stxa	%r8, [%r26 + %r0] 0x4f
	mov	0x20, %r24
	.word 0xd4ac8400  ! 4863: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0x87802020  ! 4864: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f4e000  ! 4865: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0xdabf8e80  ! 4866: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	.word 0xdcf78e40  ! 4867: STXA_R	stxa	%r14, [%r30 + %r0] 0x72
	.word 0xd4cf8e60  ! 4868: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r10
	.word 0x8780204f  ! 4869: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a66000  ! 4870: STWA_I	stwa	%r10, [%r25 + 0x0000] %asi
	.word 0xdcf40400  ! 4871: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	mov	0x18, %r16
	.word 0xdc9ea000  ! 4873: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r14
	mov	0x18, %r27
	.word 0xd6944400  ! 4875: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	.word 0xd6d66000  ! 4876: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r11
	.word 0xd6862000  ! 4877: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r11
	.word 0xd0bfce80  ! 4878: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	mov	0x0, %r27
	mov	0x20, %r16
	mov	0x7c8, %r22
	.word 0xd0862000  ! 4882: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r8
	.word 0x87802020  ! 4883: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r23
	mov	0x20, %r17
	.word 0xd0ac6000  ! 4886: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0xd2cf0e40  ! 4887: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r9
	.word 0xd28ce000  ! 4888: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	mov	0x48, %r16
	.word 0x8780204f  ! 4890: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 4891: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d0, %r22
	mov	0x18, %r24
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd29f2000  ! 4895: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	mov	0x3e8, %r21
	mov	0x60, %r24
	.word 0xd2df6000  ! 4898: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	mov	0x30, %r16
	.word 0xd28fe000  ! 4900: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 4901: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8f74e60  ! 4902: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	mov	0x8, %r17
	.word 0xd8b7ce80  ! 4904: STHA_R	stha	%r12, [%r31 + %r0] 0x74
	.word 0xd4844400  ! 4905: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0x87802074  ! 4906: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4c7a000  ! 4907: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	mov	0x70, %r18
	.word 0xd4bf2000  ! 4909: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	mov	0x20, %r19
	.word 0xd4afe000  ! 4911: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd487a000  ! 4912: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	.word 0xdcd74e40  ! 4913: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r14
	.word 0xd29504a0  ! 4914: LDUHA_R	lduha	[%r20, %r0] 0x25, %r9
	.word 0x87802072  ! 4915: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2af6000  ! 4916: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd2bfa000  ! 4917: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd2972000  ! 4918: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xd0a74e80  ! 4919: STWA_R	stwa	%r8, [%r29 + %r0] 0x74
	mov	0x50, %r25
	.word 0xd0a76000  ! 4921: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0afe000  ! 4922: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0a7e000  ! 4923: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xdaa649e0  ! 4924: STWA_R	stwa	%r13, [%r25 + %r0] 0x4f
	mov	0x3d8, %r23
	mov	0x68, %r16
	mov	0x0, %r16
	mov	0x10, %r27
	.word 0xd6d40400  ! 4929: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	.word 0x87802073  ! 4930: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r26
	.word 0x87802020  ! 4932: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88d04a0  ! 4933: LDUBA_R	lduba	[%r20, %r0] 0x25, %r12
	.word 0xdcf649e0  ! 4934: STXA_R	stxa	%r14, [%r25 + %r0] 0x4f
	.word 0xdcd46000  ! 4935: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	.word 0xdcbc2000  ! 4936: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xdcbca000  ! 4937: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	mov	0x40, %r17
	.word 0xdcaca000  ! 4939: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xdc9c2000  ! 4940: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4941: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r18
	mov	0x70, %r19
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802025  ! 4945: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc956000  ! 4946: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r14
	mov	0x50, %r24
	.word 0xd8bd04a0  ! 4948: STDA_R	stda	%r12, [%r20 + %r0] 0x25
	.word 0xdca44400  ! 4949: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0xdccd6000  ! 4950: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r14
	mov	0x18, %r18
	.word 0xdab7ce60  ! 4952: STHA_R	stha	%r13, [%r31 + %r0] 0x73
	mov	0x18, %r26
	.word 0xdcac8400  ! 4954: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xdc9d6000  ! 4955: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r14
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x70, %r16
	.word 0xdcb56000  ! 4958: STHA_I	stha	%r14, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 4959: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf4a000  ! 4960: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xdecd04a0  ! 4962: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r15
	.word 0x87802020  ! 4963: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedca000  ! 4964: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xdef46000  ! 4965: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xded4e000  ! 4966: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	.word 0xdeb4e000  ! 4967: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0xd4a7ce40  ! 4968: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	.word 0xd8a5c4a0  ! 4969: STWA_R	stwa	%r12, [%r23 + %r0] 0x25
	mov	0x10, %r18
	.word 0xd8f4a000  ! 4971: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xdad40400  ! 4972: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	.word 0xdaa42000  ! 4973: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	mov	0x8, %r17
	.word 0xdab4e000  ! 4975: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 4976: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdadea000  ! 4977: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r13
	.word 0xd8a44400  ! 4978: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	mov	0x20, %r16
	.word 0xd8a6a000  ! 4980: STWA_I	stwa	%r12, [%r26 + 0x0000] %asi
	.word 0xd8ce6000  ! 4981: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r12
	.word 0x87802074  ! 4982: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r26
	mov	0x7c0, %r23
	.word 0xd8b4c400  ! 4985: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0xd8bf6000  ! 4986: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	mov	0x28, %r25
	mov	0x70, %r24
	.word 0xd087ce60  ! 4989: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r8
	.word 0xd0dfe000  ! 4990: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	mov	0x3d8, %r22
	.word 0xdecf8e60  ! 4992: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r15
	.word 0xdeaf2000  ! 4993: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xd0a78e40  ! 4995: STWA_R	stwa	%r8, [%r30 + %r0] 0x72
	mov	0x0, %r17
	.word 0xd0af6000  ! 4997: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd0a7a000  ! 4998: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	mov	0x78, %r26
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_3:
	.word 0xd2a56000  ! 1: STWA_I	stwa	%r9, [%r21 + 0x0000] %asi
	.word 0xd2dd6000  ! 2: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r9
	.word 0xd8f649e0  ! 3: STXA_R	stxa	%r12, [%r25 + %r0] 0x4f
	mov	0x3f0, %r23
	mov	0x50, %r16
	mov	0x68, %r16
	.word 0xdad649e0  ! 7: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r13
	.word 0xd6b7ce40  ! 8: STHA_R	stha	%r11, [%r31 + %r0] 0x72
	.word 0xde8f0e60  ! 9: LDUBA_R	lduba	[%r28, %r0] 0x73, %r15
	.word 0xd09c4400  ! 10: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	.word 0xdc8fce60  ! 11: LDUBA_R	lduba	[%r31, %r0] 0x73, %r14
	mov	0x10, %r27
	.word 0xd4ac0400  ! 13: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xd09f4e80  ! 14: LDDA_R	ldda	[%r29, %r0] 0x74, %r8
	.word 0x87802074  ! 15: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 16: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde9e09e0  ! 17: LDDA_R	ldda	[%r24, %r0] 0x4f, %r15
	mov	0x60, %r25
	.word 0x87802020  ! 19: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8de49e0  ! 20: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r12
	.word 0xd0af0e80  ! 21: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	.word 0xd0c74e80  ! 22: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r8
	.word 0x87802073  ! 23: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f504a0  ! 24: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	.word 0x87802020  ! 25: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd496c9e0  ! 26: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r10
	.word 0xdcaca000  ! 27: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 28: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r25
	ta	T_CHANGE_PRIV	! macro
	mov	0x30, %r26
	.word 0xd2f78e40  ! 32: STXA_R	stxa	%r9, [%r30 + %r0] 0x72
	.word 0xd08f0e60  ! 33: LDUBA_R	lduba	[%r28, %r0] 0x73, %r8
	.word 0x87802025  ! 34: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbda000  ! 35: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	.word 0xdea48400  ! 36: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0x87802020  ! 37: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 38: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 39: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b48400  ! 40: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xd88c4400  ! 41: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0xdcbc6000  ! 42: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 43: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc85e000  ! 44: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r14
	.word 0xdc9da000  ! 45: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r14
	.word 0xdc8d2000  ! 46: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r14
	mov	0x60, %r25
	.word 0xdcc52000  ! 48: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r14
	.word 0xd8b70e40  ! 49: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0xd8ac8400  ! 50: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0xd8bde000  ! 51: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0xd8b5e000  ! 52: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	.word 0xd8d5e000  ! 53: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r12
	mov	0x30, %r17
	.word 0xd2df4e40  ! 55: LDXA_R	ldxa	[%r29, %r0] 0x72, %r9
	.word 0xd095a000  ! 56: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r8
	.word 0xdc974e60  ! 57: LDUHA_R	lduha	[%r29, %r0] 0x73, %r14
	.word 0x87802073  ! 58: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2df2000  ! 59: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xda8fce40  ! 60: LDUBA_R	lduba	[%r31, %r0] 0x72, %r13
	mov	0x7c0, %r21
	.word 0xdcf504a0  ! 62: STXA_R	stxa	%r14, [%r20 + %r0] 0x25
	.word 0xd287a000  ! 63: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2974e80  ! 64: LDUHA_R	lduha	[%r29, %r0] 0x74, %r9
	.word 0x87802074  ! 65: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2d70e80  ! 66: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r9
	.word 0xdcd4a000  ! 67: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	ta	T_CHANGE_PRIV	! macro
	.word 0xdeacc400  ! 69: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xd8a649e0  ! 70: STWA_R	stwa	%r12, [%r25 + %r0] 0x4f
	.word 0x8780204f  ! 71: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcb7e000  ! 72: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	mov	0x7e0, %r21
	.word 0xdc97a000  ! 74: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	mov	0x30, %r26
	.word 0x87802072  ! 76: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 77: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r18
	.word 0xdc872000  ! 79: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcdf2000  ! 80: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcaf6000  ! 81: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xd28649e0  ! 82: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r9
	.word 0xd88f4e40  ! 83: LDUBA_R	lduba	[%r29, %r0] 0x72, %r12
	.word 0xdebf2000  ! 84: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xded7e000  ! 85: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	mov	0x3e8, %r22
	.word 0xdebfa000  ! 87: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xd6a74e40  ! 88: STWA_R	stwa	%r11, [%r29 + %r0] 0x72
	.word 0xd6f7a000  ! 89: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6df6000  ! 90: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0x87802020  ! 91: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd697ce60  ! 92: LDUHA_R	lduha	[%r31, %r0] 0x73, %r11
	.word 0xdeb66000  ! 93: STHA_I	stha	%r15, [%r25 + 0x0000] %asi
	.word 0xd69f4e80  ! 94: LDDA_R	ldda	[%r29, %r0] 0x74, %r11
	.word 0xd2b6c9e0  ! 95: STHA_R	stha	%r9, [%r27 + %r0] 0x4f
	.word 0xd8bcc400  ! 96: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0xd8c6a000  ! 97: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r12
	.word 0xdea544a0  ! 98: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	.word 0xd2a6a000  ! 99: STWA_I	stwa	%r9, [%r26 + 0x0000] %asi
	mov	0x10, %r17
	.word 0xd49f0e40  ! 101: LDDA_R	ldda	[%r28, %r0] 0x72, %r10
	mov	0x48, %r16
	.word 0xdaf6a000  ! 103: STXA_I	stxa	%r13, [%r26 + 0x0000] %asi
	mov	0x3c0, %r23
	.word 0xd28e09e0  ! 105: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r9
	.word 0xd0cf4e40  ! 106: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	.word 0x87802020  ! 107: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccf6000  ! 108: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xd2f78e80  ! 109: STXA_R	stxa	%r9, [%r30 + %r0] 0x74
	.word 0xdadfa000  ! 110: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	mov	0x7c8, %r21
	.word 0xdaa72000  ! 112: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xdab7e000  ! 113: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xdaf72000  ! 114: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xd6a7ce60  ! 115: STWA_R	stwa	%r11, [%r31 + %r0] 0x73
	mov	0x48, %r18
	mov	0x3f0, %r22
	.word 0xdca44400  ! 118: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	mov	0x7c0, %r20
	.word 0xd8c7ce60  ! 120: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r12
	mov	0x7d8, %r23
	.word 0xdecc8400  ! 122: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	mov	0x7f8, %r23
	.word 0xd2df0e40  ! 124: LDXA_R	ldxa	[%r28, %r0] 0x72, %r9
	.word 0xd0bf6000  ! 125: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd8a74e60  ! 126: STWA_R	stwa	%r12, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 127: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcc42000  ! 128: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r14
	.word 0xdccca000  ! 129: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	.word 0xdc8c6000  ! 130: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r14
	mov	0x28, %r17
	mov	0x48, %r18
	mov	0x68, %r19
	.word 0xdc84a000  ! 134: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	.word 0xdccce000  ! 135: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r14
	.word 0xdcf4a000  ! 136: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcb4a000  ! 137: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xdca42000  ! 138: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xdcf46000  ! 139: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0xdcd46000  ! 141: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	.word 0xd8a5c4a0  ! 142: STWA_R	stwa	%r12, [%r23 + %r0] 0x25
	.word 0xd6d7ce60  ! 143: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r11
	mov	0x48, %r17
	.word 0xd0f4e000  ! 145: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xdede09e0  ! 146: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r15
	mov	0x50, %r16
	.word 0xd4df8e60  ! 148: LDXA_R	ldxa	[%r30, %r0] 0x73, %r10
	.word 0xde8ec9e0  ! 149: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r15
	.word 0xd6ac2000  ! 150: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	.word 0xd6c4a000  ! 151: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r11
	.word 0xd6bc2000  ! 152: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0xd6a4e000  ! 153: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0xd68c6000  ! 154: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r11
	.word 0xdace89e0  ! 155: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r13
	.word 0xdc8fce40  ! 156: LDUBA_R	lduba	[%r31, %r0] 0x72, %r14
	.word 0xdc84a000  ! 157: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	.word 0xdc9ce000  ! 158: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r14
	.word 0xdc94a000  ! 159: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0x87802025  ! 160: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcade000  ! 161: STBA_I	stba	%r14, [%r23 + 0x0000] %asi
	mov	0x7f8, %r20
	.word 0xdca5e000  ! 163: STWA_I	stwa	%r14, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 164: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc8d2000  ! 165: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r14
	.word 0xd2b5c4a0  ! 166: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	.word 0xd6ae49e0  ! 167: STBA_R	stba	%r11, [%r25 + %r0] 0x4f
	.word 0xd895a000  ! 168: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r12
	.word 0xd8f5e000  ! 169: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	.word 0x87802073  ! 170: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8dea000  ! 171: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r12
	.word 0xde8cc400  ! 172: LDUBA_R	lduba	[%r19, %r0] 0x20, %r15
	.word 0xd8f62000  ! 173: STXA_I	stxa	%r12, [%r24 + 0x0000] %asi
	.word 0x8780204f  ! 174: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6cd84a0  ! 175: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r11
	.word 0x87802025  ! 176: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcc76000  ! 177: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xdabfce60  ! 178: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	.word 0xd0af0e80  ! 179: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	.word 0xd6d70e40  ! 180: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r11
	.word 0xdea7a000  ! 181: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xde8d44a0  ! 182: LDUBA_R	lduba	[%r21, %r0] 0x25, %r15
	.word 0xd68c4400  ! 183: LDUBA_R	lduba	[%r17, %r0] 0x20, %r11
	.word 0x87802025  ! 184: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb42000  ! 185: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0xdeb42000  ! 186: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0xd0a7ce40  ! 187: STWA_R	stwa	%r8, [%r31 + %r0] 0x72
	.word 0xdadca000  ! 188: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0xdacc2000  ! 189: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xd4dfce80  ! 190: LDXA_R	ldxa	[%r31, %r0] 0x74, %r10
	.word 0x87802072  ! 191: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6bf6000  ! 192: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xdcb544a0  ! 193: STHA_R	stha	%r14, [%r21 + %r0] 0x25
	mov	0x50, %r16
	mov	0x50, %r26
	.word 0xdcb7e000  ! 196: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xdece49e0  ! 197: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r15
	.word 0xd2d7e000  ! 198: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xd08cc400  ! 199: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	mov	0x38, %r24
	mov	0x78, %r18
	.word 0x8780204f  ! 202: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc85e000  ! 203: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r14
	.word 0xdcbd2000  ! 204: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 205: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r25
	.word 0xdca76000  ! 207: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xd2dfce60  ! 208: LDXA_R	ldxa	[%r31, %r0] 0x73, %r9
	.word 0xdab7a000  ! 209: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xd8b78e60  ! 210: STHA_R	stha	%r12, [%r30 + %r0] 0x73
	.word 0xdacf8e40  ! 211: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r13
	.word 0xd0b78e40  ! 212: STHA_R	stha	%r8, [%r30 + %r0] 0x72
	mov	0x70, %r16
	.word 0xd2a44400  ! 214: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xdaf72000  ! 215: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xda9f2000  ! 216: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xdab72000  ! 217: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	mov	0x18, %r18
	.word 0xda8f2000  ! 219: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xdaf72000  ! 220: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	mov	0x0, %r16
	.word 0xd88d84a0  ! 222: LDUBA_R	lduba	[%r22, %r0] 0x25, %r12
	.word 0xd2a7e000  ! 223: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	mov	0x20, %r18
	.word 0xd2d7a000  ! 225: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	mov	0x18, %r19
	.word 0xdc8609e0  ! 227: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r14
	.word 0xdcf76000  ! 228: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 229: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r27
	.word 0xdcdd84a0  ! 231: LDXA_R	ldxa	[%r22, %r0] 0x25, %r14
	.word 0xd0cf4e80  ! 232: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r8
	.word 0x87802074  ! 233: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd484c400  ! 234: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	.word 0x87802073  ! 235: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0d48400  ! 236: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	.word 0x8780204f  ! 237: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r21
	.word 0xd2b70e40  ! 239: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	.word 0xd0c46000  ! 240: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r8
	.word 0xdea7ce60  ! 241: STWA_R	stwa	%r15, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 242: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd084a000  ! 243: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0bec9e0  ! 244: STDA_R	stda	%r8, [%r27 + %r0] 0x4f
	.word 0x87802072  ! 245: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f7e000  ! 246: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	mov	0x70, %r26
	.word 0xd6a7a000  ! 248: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6b7e000  ! 249: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd6bf2000  ! 250: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 251: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a504a0  ! 252: STWA_R	stwa	%r10, [%r20 + %r0] 0x25
	.word 0xdccc8400  ! 253: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	.word 0xdacc2000  ! 254: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xdaa46000  ! 255: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 256: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 257: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaf7a000  ! 258: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 259: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c8, %r22
	.word 0xd6f74e40  ! 261: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	.word 0xdaad44a0  ! 262: STBA_R	stba	%r13, [%r21 + %r0] 0x25
	.word 0xd8f74e80  ! 263: STXA_R	stxa	%r12, [%r29 + %r0] 0x74
	.word 0x87802025  ! 264: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cfe000  ! 265: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0xd4976000  ! 266: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r10
	.word 0xdadfce80  ! 267: LDXA_R	ldxa	[%r31, %r0] 0x74, %r13
	.word 0xda97a000  ! 268: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	mov	0x10, %r18
	mov	0x7c0, %r20
	.word 0xda876000  ! 271: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	mov	0x20, %r27
	.word 0xdaafe000  ! 273: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	mov	0x78, %r19
	.word 0x87802074  ! 275: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0df0e80  ! 276: LDXA_R	ldxa	[%r28, %r0] 0x74, %r8
	.word 0xd4dc2000  ! 277: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	.word 0xd2ac8400  ! 278: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xdcb78e60  ! 279: STHA_R	stha	%r14, [%r30 + %r0] 0x73
	.word 0xd0f46000  ! 280: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 281: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 282: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd087e000  ! 283: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0bfa000  ! 284: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 285: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r27
	mov	0x0, %r24
	.word 0xd0b4e000  ! 288: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xd08c2000  ! 289: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0xd0d4e000  ! 290: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	mov	0x28, %r19
	mov	0x7e0, %r21
	.word 0xd0cc2000  ! 293: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	.word 0xd0cc2000  ! 294: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	.word 0xd6f649e0  ! 295: STXA_R	stxa	%r11, [%r25 + %r0] 0x4f
	.word 0xdedce000  ! 296: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r15
	.word 0xdec78e60  ! 297: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r15
	.word 0xdec689e0  ! 298: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r15
	mov	0x68, %r27
	.word 0xde844400  ! 300: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	mov	0x0, %r18
	mov	0x78, %r18
	.word 0xdcb4e000  ! 303: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xd8a7ce40  ! 304: STWA_R	stwa	%r12, [%r31 + %r0] 0x72
	.word 0xdca46000  ! 305: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xdcbca000  ! 306: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdcac2000  ! 307: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0xdcb5c4a0  ! 308: STHA_R	stha	%r14, [%r23 + %r0] 0x25
	.word 0xd4842000  ! 309: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	mov	0x3f0, %r23
	.word 0xd4b42000  ! 311: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	.word 0xda8f4e40  ! 312: LDUBA_R	lduba	[%r29, %r0] 0x72, %r13
	.word 0xd2ac6000  ! 313: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xdc94c400  ! 314: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	.word 0xdcdc0400  ! 315: LDXA_R	ldxa	[%r16, %r0] 0x20, %r14
	mov	0x38, %r25
	mov	0x38, %r24
	mov	0x8, %r19
	.word 0xd2bc8400  ! 319: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	mov	0x48, %r19
	.word 0xdc8f8e60  ! 321: LDUBA_R	lduba	[%r30, %r0] 0x73, %r14
	.word 0xd4cce000  ! 322: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	.word 0xd484e000  ! 323: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r10
	.word 0xd4bc2000  ! 324: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	mov	0x58, %r24
	.word 0xdedf0e80  ! 326: LDXA_R	ldxa	[%r28, %r0] 0x74, %r15
	.word 0xd69ca000  ! 327: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r11
	.word 0xd68ca000  ! 328: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r11
	.word 0x87802073  ! 329: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6b6a000  ! 330: STHA_I	stha	%r11, [%r26 + 0x0000] %asi
	.word 0xd6b6e000  ! 331: STHA_I	stha	%r11, [%r27 + 0x0000] %asi
	.word 0xd6be6000  ! 332: STDA_I	stda	%r11, [%r25 + 0x0000] %asi
	.word 0xdea78e40  ! 333: STWA_R	stwa	%r15, [%r30 + %r0] 0x72
	mov	0x10, %r18
	.word 0xdebf0e60  ! 335: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	.word 0xdea66000  ! 336: STWA_I	stwa	%r15, [%r25 + 0x0000] %asi
	mov	0x20, %r24
	.word 0xde8e6000  ! 338: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r15
	mov	0x70, %r27
	.word 0x8780204f  ! 340: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f7ce40  ! 341: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	.word 0xd29ee000  ! 342: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r9
	.word 0x87802072  ! 343: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 344: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 345: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r25
	.word 0xd0b504a0  ! 347: STHA_R	stha	%r8, [%r20 + %r0] 0x25
	mov	0x70, %r19
	.word 0xdecd44a0  ! 349: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r15
	.word 0xdac70e80  ! 350: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r13
	.word 0xd6cf2000  ! 351: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0xd6d7e000  ! 352: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	mov	0x7e8, %r23
	.word 0x87802020  ! 354: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r19
	.word 0xd4d584a0  ! 356: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r10
	.word 0xd88f2000  ! 357: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0x87802073  ! 358: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8d78e60  ! 359: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r12
	.word 0xd69689e0  ! 360: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r11
	.word 0xdcae6000  ! 361: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0xdccee000  ! 363: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r14
	.word 0xd48f8e80  ! 364: LDUBA_R	lduba	[%r30, %r0] 0x74, %r10
	.word 0xdac62000  ! 365: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r13
	.word 0xdab66000  ! 366: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0xd0a44400  ! 367: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xd0cee000  ! 368: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r8
	mov	0x28, %r25
	.word 0xd6c70e60  ! 370: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r11
	.word 0xdef544a0  ! 371: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	.word 0xd8cea000  ! 372: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r12
	.word 0xd8c62000  ! 373: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r12
	.word 0x87802020  ! 374: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f78e80  ! 375: STXA_R	stxa	%r8, [%r30 + %r0] 0x74
	mov	0x3e8, %r22
	.word 0xd49f8e80  ! 377: LDDA_R	ldda	[%r30, %r0] 0x74, %r10
	.word 0xd8a4a000  ! 378: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8b4e000  ! 379: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	mov	0x0, %r19
	.word 0x87802074  ! 381: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdea44400  ! 382: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xd48d2000  ! 383: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0xd0c78e60  ! 384: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r8
	.word 0xd8dcc400  ! 385: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	.word 0xd2a44400  ! 386: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xd4cde000  ! 387: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r10
	.word 0xd4af4e40  ! 388: STBA_R	stba	%r10, [%r29 + %r0] 0x72
	mov	0x10, %r25
	mov	0x48, %r19
	.word 0xd0ac4400  ! 391: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0xd68d2000  ! 392: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r11
	mov	0x50, %r27
	.word 0x8780204f  ! 394: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r23
	.word 0xd6df2000  ! 396: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6cfa000  ! 397: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0xd4bf4e40  ! 398: STDA_R	stda	%r10, [%r29 + %r0] 0x72
	.word 0x87802020  ! 399: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6944400  ! 400: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	.word 0x87802074  ! 401: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 402: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 403: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r24
	.word 0xd0f7a000  ! 405: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	mov	0x10, %r27
	.word 0xdcdc8400  ! 407: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	.word 0xd8f7a000  ! 408: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	mov	0x7d0, %r20
	.word 0x8780204f  ! 410: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeb40400  ! 411: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802020  ! 413: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r22
	.word 0xd0ccc400  ! 415: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	mov	0x7c0, %r22
	mov	0x7e0, %r23
	.word 0xd0a7ce80  ! 418: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	.word 0x87802020  ! 419: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r16
	.word 0x87802072  ! 421: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r17
	.word 0xdecf6000  ! 423: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 424: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 425: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef46000  ! 426: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xd4d609e0  ! 427: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r10
	mov	0x60, %r26
	.word 0xd6f42000  ! 429: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	.word 0xd2cdc4a0  ! 430: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r9
	.word 0x87802073  ! 431: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd49c4400  ! 432: LDDA_R	ldda	[%r17, %r0] 0x20, %r10
	mov	0x7c0, %r21
	.word 0xd6bec9e0  ! 434: STDA_R	stda	%r11, [%r27 + %r0] 0x4f
	.word 0xd4a4e000  ! 435: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	mov	0x48, %r27
	mov	0x30, %r26
	.word 0xd4d42000  ! 438: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	.word 0xd6cf4e40  ! 439: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r11
	.word 0xd0bc8400  ! 440: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0xdea74e40  ! 441: STWA_R	stwa	%r15, [%r29 + %r0] 0x72
	.word 0xd8cc2000  ! 442: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r12
	mov	0x3d0, %r23
	.word 0x87802074  ! 444: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd69cc400  ! 445: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	.word 0xdcd649e0  ! 446: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r14
	.word 0xd0a5c4a0  ! 447: STWA_R	stwa	%r8, [%r23 + %r0] 0x25
	mov	0x7d8, %r21
	.word 0x87802025  ! 449: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8d7ce60  ! 450: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r12
	.word 0xd6a44400  ! 451: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0xd697e000  ! 452: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0xd4b70e40  ! 453: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	.word 0xd4bf8e60  ! 454: STDA_R	stda	%r10, [%r30 + %r0] 0x73
	mov	0x30, %r19
	.word 0xd6972000  ! 456: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	mov	0x38, %r25
	.word 0xd6a72000  ! 458: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6a72000  ! 459: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	mov	0x7f8, %r23
	.word 0xdaae49e0  ! 461: STBA_R	stba	%r13, [%r25 + %r0] 0x4f
	.word 0xd4ae09e0  ! 462: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0xd295c4a0  ! 463: LDUHA_R	lduha	[%r23, %r0] 0x25, %r9
	.word 0xde8c4400  ! 464: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	.word 0xd6d48400  ! 465: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0xd8ac0400  ! 466: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xd6dd44a0  ! 467: LDXA_R	ldxa	[%r21, %r0] 0x25, %r11
	.word 0x8780204f  ! 468: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 469: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc844400  ! 470: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	mov	0x70, %r18
	.word 0xd2b7ce80  ! 472: STHA_R	stha	%r9, [%r31 + %r0] 0x74
	.word 0x87802025  ! 473: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd09584a0  ! 474: LDUHA_R	lduha	[%r22, %r0] 0x25, %r8
	mov	0x3e8, %r22
	.word 0xd4a7a000  ! 476: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4bf6000  ! 477: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xdcc70e80  ! 478: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r14
	.word 0x8780204f  ! 479: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r27
	.word 0xd69f2000  ! 481: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xdcb40400  ! 482: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0x87802073  ! 483: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b44400  ! 484: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xd8846000  ! 485: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	.word 0xd8a42000  ! 486: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xdc8e89e0  ! 487: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r14
	mov	0x20, %r26
	.word 0xd0be89e0  ! 489: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	.word 0xdca44400  ! 490: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0x87802074  ! 491: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4bf4e80  ! 492: STDA_R	stda	%r10, [%r29 + %r0] 0x74
	.word 0x87802025  ! 493: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8a6a000  ! 494: STWA_I	stwa	%r12, [%r26 + 0x0000] %asi
	mov	0x0, %r16
	.word 0xd89584a0  ! 496: LDUHA_R	lduha	[%r22, %r0] 0x25, %r12
	.word 0xd6dfce60  ! 497: LDXA_R	ldxa	[%r31, %r0] 0x73, %r11
	.word 0xd0b78e40  ! 498: STHA_R	stha	%r8, [%r30 + %r0] 0x72
	mov	0x7d0, %r22
	mov	0x3f8, %r22
	mov	0x7f0, %r22
	.word 0xd2c66000  ! 502: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r9
	.word 0xd2a6e000  ! 503: STWA_I	stwa	%r9, [%r27 + 0x0000] %asi
	mov	0x10, %r17
	mov	0x7f0, %r22
	.word 0x87802072  ! 506: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a48400  ! 507: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xdebf6000  ! 508: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xdebfa000  ! 509: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xde87a000  ! 510: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xdccf4e80  ! 511: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r14
	.word 0xdaafe000  ! 512: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xdaaf6000  ! 513: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	mov	0x7d0, %r20
	.word 0xdaa72000  ! 515: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0x87802072  ! 517: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x58, %r18
	.word 0xd0f48400  ! 520: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xdcdf6000  ! 521: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xdcb40400  ! 522: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xd2848400  ! 523: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r9
	mov	0x7e8, %r23
	.word 0xdcc504a0  ! 525: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r14
	.word 0xd8848400  ! 526: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r12
	mov	0x38, %r26
	mov	0x38, %r27
	mov	0x20, %r27
	.word 0xdeb76000  ! 530: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xdebf2000  ! 531: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 532: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f4c400  ! 533: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0x87802020  ! 534: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f7a000  ! 535: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	mov	0x10, %r19
	.word 0xd29fe000  ! 537: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0x87802025  ! 538: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f8, %r20
	mov	0x10, %r19
	.word 0xd2f7a000  ! 541: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xdca7ce60  ! 542: STWA_R	stwa	%r14, [%r31 + %r0] 0x73
	.word 0xdeafce40  ! 543: STBA_R	stba	%r15, [%r31 + %r0] 0x72
	.word 0x87802072  ! 544: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 545: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 546: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2ade000  ! 547: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	mov	0x20, %r25
	.word 0xd2dda000  ! 549: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r9
	.word 0x87802020  ! 550: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc844400  ! 551: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	.word 0xd4970e60  ! 552: LDUHA_R	lduha	[%r28, %r0] 0x73, %r10
	.word 0x8780204f  ! 553: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bfce80  ! 554: STDA_R	stda	%r12, [%r31 + %r0] 0x74
	.word 0xd29f8e60  ! 555: LDDA_R	ldda	[%r30, %r0] 0x73, %r9
	mov	0x70, %r27
	.word 0xd0a5e000  ! 557: STWA_I	stwa	%r8, [%r23 + 0x0000] %asi
	.word 0xd0cd2000  ! 558: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r8
	mov	0x60, %r25
	.word 0x87802025  ! 560: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r16
	mov	0x3e8, %r23
	.word 0x87802072  ! 563: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa78e60  ! 564: STWA_R	stwa	%r13, [%r30 + %r0] 0x73
	.word 0xd6bca000  ! 565: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0xdcb7ce60  ! 567: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	.word 0xd284a000  ! 568: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	mov	0x7e0, %r22
	mov	0x3f8, %r20
	.word 0xd284e000  ! 571: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r9
	.word 0xd2846000  ! 572: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r9
	mov	0x3d0, %r23
	.word 0xdcdf4e60  ! 574: LDXA_R	ldxa	[%r29, %r0] 0x73, %r14
	.word 0xd48ce000  ! 575: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r10
	mov	0x8, %r16
	.word 0x8780204f  ! 577: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4ae09e0  ! 578: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0xdef48400  ! 579: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xda8c8400  ! 580: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	mov	0x40, %r24
	.word 0xd8cc0400  ! 582: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	.word 0xdebc2000  ! 583: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xd2f7ce80  ! 585: STXA_R	stxa	%r9, [%r31 + %r0] 0x74
	.word 0xdadca000  ! 586: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0xdaf46000  ! 587: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0xdaaca000  ! 588: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	mov	0x0, %r17
	mov	0x20, %r16
	.word 0xdacca000  ! 591: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	.word 0xd8dc8400  ! 592: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xdcd609e0  ! 593: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r14
	.word 0xd6b4e000  ! 594: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 595: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 596: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ac6000  ! 597: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 598: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 599: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r23
	.word 0xd6b7e000  ! 601: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd68f6000  ! 602: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xd2afce60  ! 603: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	.word 0x87802020  ! 604: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeac6000  ! 605: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xdea42000  ! 606: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xd2cc8400  ! 607: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0x8780204f  ! 608: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 609: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda9d2000  ! 610: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r13
	.word 0xd6af4e60  ! 611: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	.word 0xd4f52000  ! 612: STXA_I	stxa	%r10, [%r20 + 0x0000] %asi
	.word 0xde970e40  ! 613: LDUHA_R	lduha	[%r28, %r0] 0x72, %r15
	.word 0x87802072  ! 614: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6c7e000  ! 615: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6f72000  ! 616: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd2bf4e60  ! 617: STDA_R	stda	%r9, [%r29 + %r0] 0x73
	.word 0x87802072  ! 618: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3e8, %r22
	.word 0xdadc8400  ! 620: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	mov	0x60, %r17
	.word 0xdaf7a000  ! 622: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xda9f6000  ! 623: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xd8bfce40  ! 624: STDA_R	stda	%r12, [%r31 + %r0] 0x72
	.word 0x87802073  ! 625: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4aee000  ! 626: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	.word 0x87802073  ! 627: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b4a000  ! 628: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0xd4f4e000  ! 629: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	mov	0x70, %r18
	mov	0x3d0, %r22
	.word 0x87802074  ! 632: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f78e40  ! 633: STXA_R	stxa	%r8, [%r30 + %r0] 0x72
	.word 0x87802074  ! 634: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c0, %r23
	.word 0xd8f4e000  ! 636: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xd2ddc4a0  ! 637: LDXA_R	ldxa	[%r23, %r0] 0x25, %r9
	.word 0xde9ce000  ! 638: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0x87802020  ! 639: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb4a000  ! 640: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 641: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4df4e40  ! 642: LDXA_R	ldxa	[%r29, %r0] 0x72, %r10
	.word 0xd0dcc400  ! 643: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0xdcbc8400  ! 644: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	mov	0x8, %r24
	.word 0xd0afa000  ! 646: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xdab584a0  ! 647: STHA_R	stha	%r13, [%r22 + %r0] 0x25
	.word 0xdaa7ce40  ! 648: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	.word 0xd8df2000  ! 649: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8f72000  ! 650: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xdcb649e0  ! 651: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	.word 0xd0f78e80  ! 652: STXA_R	stxa	%r8, [%r30 + %r0] 0x74
	.word 0xd2840400  ! 653: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r9
	.word 0xdeac0400  ! 654: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xd89d04a0  ! 655: LDDA_R	ldda	[%r20, %r0] 0x25, %r12
	.word 0x87802020  ! 656: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bfe000  ! 657: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 658: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcad84a0  ! 659: STBA_R	stba	%r14, [%r22 + %r0] 0x25
	.word 0xdcf44400  ! 660: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xdab76000  ! 661: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xdcf4c400  ! 663: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xd4d40400  ! 664: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	mov	0x68, %r24
	.word 0xd8a584a0  ! 666: STWA_R	stwa	%r12, [%r22 + %r0] 0x25
	.word 0xd6df8e60  ! 667: LDXA_R	ldxa	[%r30, %r0] 0x73, %r11
	mov	0x60, %r16
	.word 0xdeb76000  ! 669: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xde97a000  ! 670: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	.word 0xdef72000  ! 671: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	mov	0x48, %r16
	mov	0x28, %r27
	.word 0xd2cf8e60  ! 674: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r9
	.word 0x87802020  ! 675: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r21
	.word 0xd494e000  ! 677: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	mov	0x50, %r18
	.word 0xdabf0e60  ! 679: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	.word 0xd89c2000  ! 680: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	.word 0x87802025  ! 681: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8f78e40  ! 682: STXA_R	stxa	%r12, [%r30 + %r0] 0x72
	mov	0x8, %r18
	.word 0x87802074  ! 684: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b66000  ! 685: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	.word 0xd0a44400  ! 686: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0x87802074  ! 687: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0cc4400  ! 688: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	.word 0x87802020  ! 689: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeade000  ! 690: STBA_I	stba	%r15, [%r23 + 0x0000] %asi
	.word 0xdeae89e0  ! 691: STBA_R	stba	%r15, [%r26 + %r0] 0x4f
	.word 0xd8ad84a0  ! 692: STBA_R	stba	%r12, [%r22 + %r0] 0x25
	.word 0xd8a78e60  ! 693: STWA_R	stwa	%r12, [%r30 + %r0] 0x73
	mov	0x3d0, %r23
	.word 0xd0856000  ! 695: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r8
	.word 0xd0f52000  ! 696: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 697: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f4c400  ! 698: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xde9fce60  ! 699: LDDA_R	ldda	[%r31, %r0] 0x73, %r15
	.word 0xda874e40  ! 700: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r13
	.word 0xd89c8400  ! 701: LDDA_R	ldda	[%r18, %r0] 0x20, %r12
	.word 0xd69fce80  ! 702: LDDA_R	ldda	[%r31, %r0] 0x74, %r11
	.word 0x87802020  ! 703: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bd04a0  ! 704: STDA_R	stda	%r11, [%r20 + %r0] 0x25
	.word 0x87802072  ! 705: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6d70e40  ! 706: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r11
	.word 0xd4c689e0  ! 707: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r10
	mov	0x28, %r17
	mov	0x68, %r25
	.word 0xdec42000  ! 710: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	mov	0x7d0, %r22
	.word 0xde946000  ! 712: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r15
	.word 0xdea4e000  ! 713: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xdabf8e80  ! 714: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	mov	0x30, %r19
	.word 0xd2f4a000  ! 716: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0xd2f4a000  ! 717: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	mov	0x30, %r16
	.word 0x87802074  ! 719: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2be6000  ! 720: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	.word 0xd2a6a000  ! 721: STWA_I	stwa	%r9, [%r26 + 0x0000] %asi
	.word 0xd2f6e000  ! 722: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	.word 0x87802072  ! 723: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6970e80  ! 724: LDUHA_R	lduha	[%r28, %r0] 0x74, %r11
	.word 0xd0bf4e40  ! 725: STDA_R	stda	%r8, [%r29 + %r0] 0x72
	.word 0xd2cfce80  ! 726: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r9
	.word 0xdebf6000  ! 727: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 728: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r25
	.word 0x8780204f  ! 730: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabfce60  ! 731: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	mov	0x7f8, %r22
	.word 0xdede2000  ! 733: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r15
	.word 0xd09f0e80  ! 734: LDDA_R	ldda	[%r28, %r0] 0x74, %r8
	.word 0xd0be49e0  ! 735: STDA_R	stda	%r8, [%r25 + %r0] 0x4f
	.word 0xd8d48400  ! 736: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0xd6bee000  ! 737: STDA_I	stda	%r11, [%r27 + 0x0000] %asi
	.word 0x87802025  ! 738: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c8, %r23
	mov	0x0, %r27
	ta	T_CHANGE_PRIV	! macro
	mov	0x7c0, %r21
	.word 0xd6dc2000  ! 743: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r11
	mov	0x3d0, %r20
	mov	0x3e0, %r22
	.word 0xd6b4a000  ! 746: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd2bf4e80  ! 747: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	mov	0x7c8, %r22
	.word 0xd2b4e000  ! 749: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0xd2ac6000  ! 750: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd29e49e0  ! 751: LDDA_R	ldda	[%r25, %r0] 0x4f, %r9
	.word 0xd49f8e80  ! 752: LDDA_R	ldda	[%r30, %r0] 0x74, %r10
	mov	0x78, %r27
	.word 0x87802074  ! 754: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 755: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b7ce40  ! 756: STHA_R	stha	%r8, [%r31 + %r0] 0x72
	mov	0x28, %r24
	mov	0x3e0, %r23
	.word 0xd2dfa000  ! 759: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2bf6000  ! 760: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 761: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a46000  ! 762: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	mov	0x7e0, %r21
	.word 0x87802072  ! 764: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f4a000  ! 765: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0xd28649e0  ! 766: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r9
	.word 0xd4c46000  ! 767: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r10
	.word 0xd4a4a000  ! 768: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	mov	0x38, %r18
	.word 0x87802073  ! 770: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f5e000  ! 771: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	.word 0xdcf48400  ! 772: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xd4d4c400  ! 773: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0xd0f504a0  ! 774: STXA_R	stxa	%r8, [%r20 + %r0] 0x25
	.word 0xd8a5a000  ! 775: STWA_I	stwa	%r12, [%r22 + 0x0000] %asi
	mov	0x0, %r27
	mov	0x8, %r19
	mov	0x0, %r25
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802020  ! 780: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd8bf2000  ! 782: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 783: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r17
	mov	0x20, %r25
	.word 0xd8f78e60  ! 786: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	mov	0x28, %r17
	.word 0x87802020  ! 788: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabe89e0  ! 789: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	.word 0xd0872000  ! 790: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xdcb74e60  ! 791: STHA_R	stha	%r14, [%r29 + %r0] 0x73
	mov	0x68, %r25
	.word 0xd29fa000  ! 793: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	mov	0x7c0, %r20
	.word 0xd2ac0400  ! 795: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0xda8f6000  ! 796: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xdab72000  ! 797: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdaf72000  ! 798: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdac76000  ! 799: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0x87802073  ! 800: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r18
	mov	0x3c8, %r22
	.word 0x87802020  ! 803: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9f2000  ! 804: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xdab76000  ! 805: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdac72000  ! 806: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0xd6a40400  ! 807: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	mov	0x60, %r19
	mov	0x10, %r17
	.word 0xd6afa000  ! 810: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0xd6a72000  ! 812: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6f7e000  ! 813: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd68d44a0  ! 814: LDUBA_R	lduba	[%r21, %r0] 0x25, %r11
	.word 0x87802020  ! 815: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r20
	.word 0xdaf7ce40  ! 817: STXA_R	stxa	%r13, [%r31 + %r0] 0x72
	.word 0xd4f76000  ! 818: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd28cc400  ! 819: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	mov	0x78, %r16
	.word 0x87802025  ! 821: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4dc6000  ! 822: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	.word 0xd48f0e60  ! 823: LDUBA_R	lduba	[%r28, %r0] 0x73, %r10
	mov	0x3e8, %r20
	mov	0x3e8, %r22
	.word 0xd0a4a000  ! 826: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 827: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r27
	.word 0xd8d40400  ! 829: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	.word 0xdef544a0  ! 830: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	.word 0x87802025  ! 831: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 832: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcd7ce80  ! 833: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r14
	.word 0xd6ac8400  ! 834: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	mov	0x18, %r18
	.word 0xdc8e09e0  ! 836: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r14
	.word 0xd284c400  ! 837: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r9
	.word 0xdcf72000  ! 838: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	mov	0x10, %r24
	mov	0x20, %r27
	.word 0xdccfe000  ! 841: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xdca76000  ! 842: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcbf6000  ! 843: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 844: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2cc0400  ! 846: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r9
	.word 0x8780204f  ! 847: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8dc4400  ! 848: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0x87802074  ! 849: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4af2000  ! 850: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd4a72000  ! 851: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 852: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e8, %r23
	.word 0xd4f7a000  ! 854: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd0d4c400  ! 855: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	.word 0xd09f8e80  ! 856: LDDA_R	ldda	[%r30, %r0] 0x74, %r8
	.word 0xdca76000  ! 857: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 858: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r17
	mov	0x70, %r24
	.word 0xdcf609e0  ! 861: STXA_R	stxa	%r14, [%r24 + %r0] 0x4f
	.word 0xd8bf6000  ! 862: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xdadec9e0  ! 863: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r13
	.word 0xdccf8e40  ! 864: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r14
	.word 0xd2c76000  ! 865: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2cfe000  ! 866: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	mov	0x0, %r27
	.word 0xd8ae09e0  ! 868: STBA_R	stba	%r12, [%r24 + %r0] 0x4f
	mov	0x3d0, %r21
	.word 0x8780204f  ! 870: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 871: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e0, %r23
	mov	0x60, %r18
	.word 0xd6bf0e40  ! 874: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	.word 0xd4b584a0  ! 875: STHA_R	stha	%r10, [%r22 + %r0] 0x25
	.word 0x87802073  ! 876: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdedca000  ! 877: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xde8ca000  ! 878: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0xdca74e80  ! 879: STWA_R	stwa	%r14, [%r29 + %r0] 0x74
	mov	0x60, %r16
	mov	0x60, %r19
	.word 0xd2bc2000  ! 882: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xd0c70e80  ! 883: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r8
	.word 0x87802073  ! 884: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 885: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r19
	.word 0x87802073  ! 887: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2ace000  ! 888: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0xd0d504a0  ! 889: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r8
	.word 0xdacca000  ! 890: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	mov	0x3d8, %r22
	mov	0x68, %r25
	.word 0x87802072  ! 893: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabf2000  ! 894: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xd4ae09e0  ! 895: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	mov	0x0, %r19
	.word 0xd6d649e0  ! 897: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r11
	.word 0xd2872000  ! 898: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	.word 0xd4a4c400  ! 899: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0xd28fa000  ! 900: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	mov	0x58, %r16
	.word 0x87802020  ! 902: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd8af8e80  ! 904: STBA_R	stba	%r12, [%r30 + %r0] 0x74
	.word 0x87802073  ! 905: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2af2000  ! 906: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd2b76000  ! 907: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 908: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd287a000  ! 909: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2cfe000  ! 910: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2f7a000  ! 912: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xd8ae49e0  ! 913: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	mov	0x58, %r24
	.word 0x87802020  ! 915: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ac4400  ! 916: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xde9f4e60  ! 917: LDDA_R	ldda	[%r29, %r0] 0x73, %r15
	.word 0x87802025  ! 918: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r24
	.word 0x87802074  ! 920: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r25
	.word 0xde8f2000  ! 922: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xd68584a0  ! 923: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r11
	mov	0x18, %r16
	mov	0x7e0, %r23
	.word 0xdef76000  ! 926: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdedfe000  ! 927: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xde8fe000  ! 928: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0xde9f6000  ! 929: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	mov	0x20, %r25
	.word 0xd8af0e60  ! 931: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	.word 0xde97ce80  ! 932: LDUHA_R	lduha	[%r31, %r0] 0x74, %r15
	.word 0x87802074  ! 933: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda840400  ! 934: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	.word 0xdeb7e000  ! 935: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 936: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 937: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd08d84a0  ! 938: LDUBA_R	lduba	[%r22, %r0] 0x25, %r8
	mov	0x20, %r27
	mov	0x28, %r16
	mov	0x40, %r17
	mov	0x7e0, %r22
	.word 0xdebfce80  ! 943: STDA_R	stda	%r15, [%r31 + %r0] 0x74
	.word 0xd8a7a000  ! 944: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xdaac8400  ! 945: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0xd8cd04a0  ! 946: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r12
	mov	0x28, %r24
	.word 0xdcf72000  ! 948: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xd2a7ce80  ! 949: STWA_R	stwa	%r9, [%r31 + %r0] 0x74
	.word 0x87802020  ! 950: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b78e40  ! 951: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	.word 0xd4ac0400  ! 952: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	mov	0x7d0, %r22
	.word 0xdc9d04a0  ! 954: LDDA_R	ldda	[%r20, %r0] 0x25, %r14
	.word 0xd88de000  ! 955: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r12
	.word 0xda840400  ! 956: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	.word 0xd0dd6000  ! 957: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r8
	.word 0xd0d70e80  ! 958: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r8
	.word 0x87802025  ! 959: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdecfce80  ! 960: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r15
	.word 0xdeb7a000  ! 961: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 962: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8c6000  ! 963: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0x87802072  ! 964: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b7ce80  ! 965: STHA_R	stha	%r8, [%r31 + %r0] 0x74
	.word 0xd0af2000  ! 966: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0cf2000  ! 967: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0x87802020  ! 968: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcd7ce80  ! 969: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r14
	.word 0xd2bee000  ! 970: STDA_I	stda	%r9, [%r27 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0xd6f544a0  ! 972: STXA_R	stxa	%r11, [%r21 + %r0] 0x25
	.word 0xd49e6000  ! 973: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r10
	.word 0xd4b62000  ! 974: STHA_I	stha	%r10, [%r24 + 0x0000] %asi
	.word 0xde970e60  ! 975: LDUHA_R	lduha	[%r28, %r0] 0x73, %r15
	.word 0xda9ea000  ! 976: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r13
	.word 0xdaaea000  ! 977: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	.word 0x87802073  ! 978: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 979: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r27
	.word 0x87802020  ! 981: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ac4400  ! 982: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xdabc2000  ! 983: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xdaace000  ! 984: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	mov	0x18, %r18
	mov	0x8, %r19
	.word 0xd2cc4400  ! 987: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r9
	.word 0x87802072  ! 988: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabce000  ! 989: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 990: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdab72000  ! 991: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	mov	0x48, %r26
	.word 0xd88c4400  ! 993: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	mov	0x7c8, %r21
	mov	0x3d0, %r23
	.word 0x87802072  ! 996: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0f72000  ! 997: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xd8a7ce40  ! 998: STWA_R	stwa	%r12, [%r31 + %r0] 0x72
	mov	0x7f8, %r23
	.word 0xd4b7ce80  ! 1000: STHA_R	stha	%r10, [%r31 + %r0] 0x74
	.word 0x87802020  ! 1001: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca7ce60  ! 1002: STWA_R	stwa	%r14, [%r31 + %r0] 0x73
	.word 0xd8dcc400  ! 1003: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	mov	0x3d8, %r20
	.word 0xda94c400  ! 1005: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	mov	0x58, %r18
	.word 0xda9dc4a0  ! 1007: LDDA_R	ldda	[%r23, %r0] 0x25, %r13
	.word 0xd8c7a000  ! 1008: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	mov	0x38, %r27
	.word 0xd8f76000  ! 1010: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xd4bdc4a0  ! 1012: STDA_R	stda	%r10, [%r23 + %r0] 0x25
	.word 0x87802025  ! 1013: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0b44400  ! 1014: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xd08689e0  ! 1015: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r8
	.word 0xd8f74e80  ! 1016: STXA_R	stxa	%r12, [%r29 + %r0] 0x74
	.word 0xd0f609e0  ! 1017: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	.word 0xdaf7ce40  ! 1018: STXA_R	stxa	%r13, [%r31 + %r0] 0x72
	.word 0xd2c4c400  ! 1019: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0xdec42000  ! 1020: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0xdeb42000  ! 1021: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0xdeb46000  ! 1022: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 1023: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef7a000  ! 1024: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xd0cdc4a0  ! 1025: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r8
	.word 0xd6b504a0  ! 1026: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	.word 0xd2c72000  ! 1027: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2afe000  ! 1028: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd88e89e0  ! 1029: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r12
	mov	0x3f0, %r23
	.word 0xd0b7a000  ! 1031: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd2bcc400  ! 1032: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xdcafe000  ! 1033: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xd4dd44a0  ! 1034: LDXA_R	ldxa	[%r21, %r0] 0x25, %r10
	.word 0xdccf6000  ! 1035: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	mov	0x18, %r19
	.word 0xd4ac4400  ! 1037: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xd08689e0  ! 1038: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r8
	.word 0xd4f74e80  ! 1039: STXA_R	stxa	%r10, [%r29 + %r0] 0x74
	mov	0x58, %r19
	mov	0x8, %r24
	.word 0xd4974e60  ! 1042: LDUHA_R	lduha	[%r29, %r0] 0x73, %r10
	.word 0x87802020  ! 1043: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r23
	.word 0xd68d2000  ! 1045: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r11
	.word 0xd6bde000  ! 1046: STDA_I	stda	%r11, [%r23 + 0x0000] %asi
	.word 0xd6f5e000  ! 1047: STXA_I	stxa	%r11, [%r23 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xdcb649e0  ! 1049: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	.word 0xd2b78e60  ! 1050: STHA_R	stha	%r9, [%r30 + %r0] 0x73
	.word 0xd68d6000  ! 1051: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r11
	.word 0xd6c56000  ! 1052: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r11
	.word 0xdc8544a0  ! 1053: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r14
	mov	0x78, %r27
	.word 0xd6a5a000  ! 1055: STWA_I	stwa	%r11, [%r22 + 0x0000] %asi
	.word 0xd4cdc4a0  ! 1056: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r10
	.word 0xd0cda000  ! 1057: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r8
	.word 0xde974e80  ! 1058: LDUHA_R	lduha	[%r29, %r0] 0x74, %r15
	.word 0xd2d52000  ! 1059: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r9
	.word 0xd295e000  ! 1060: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r9
	.word 0x87802073  ! 1061: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 1062: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc9584a0  ! 1063: LDUHA_R	lduha	[%r22, %r0] 0x25, %r14
	mov	0x3c0, %r21
	.word 0x8780204f  ! 1065: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r19
	.word 0x87802074  ! 1067: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a78e80  ! 1068: STWA_R	stwa	%r10, [%r30 + %r0] 0x74
	mov	0x18, %r18
	.word 0x87802020  ! 1070: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1071: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r17
	.word 0xd4f78e40  ! 1073: STXA_R	stxa	%r10, [%r30 + %r0] 0x72
	.word 0x8780204f  ! 1074: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r24
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd88f6000  ! 1077: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xd8c7e000  ! 1078: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0xdaa7ce80  ! 1079: STWA_R	stwa	%r13, [%r31 + %r0] 0x74
	.word 0x87802020  ! 1080: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb48400  ! 1081: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	mov	0x30, %r25
	mov	0x3f8, %r20
	.word 0xd6940400  ! 1084: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	.word 0xdebd6000  ! 1085: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	.word 0xd6af0e40  ! 1086: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	.word 0xdef4c400  ! 1087: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	mov	0x70, %r26
	.word 0xd4bdc4a0  ! 1089: STDA_R	stda	%r10, [%r23 + %r0] 0x25
	.word 0xdeb689e0  ! 1090: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	mov	0x18, %r18
	.word 0xd6a52000  ! 1092: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	mov	0x10, %r17
	.word 0xd6bd6000  ! 1094: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0xd2af4e40  ! 1096: STBA_R	stba	%r9, [%r29 + %r0] 0x72
	.word 0x87802073  ! 1097: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d8, %r20
	mov	0x3c8, %r22
	.word 0xda8fce60  ! 1100: LDUBA_R	lduba	[%r31, %r0] 0x73, %r13
	.word 0xdc9f0e40  ! 1101: LDDA_R	ldda	[%r28, %r0] 0x72, %r14
	.word 0xd4be2000  ! 1102: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	.word 0xd6b48400  ! 1103: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xdcd6a000  ! 1104: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r14
	.word 0xdcf6a000  ! 1105: STXA_I	stxa	%r14, [%r26 + 0x0000] %asi
	mov	0x3e0, %r20
	.word 0x87802072  ! 1107: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6a544a0  ! 1108: STWA_R	stwa	%r11, [%r21 + %r0] 0x25
	.word 0xde976000  ! 1109: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	.word 0xde9f2000  ! 1110: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	mov	0x7c0, %r21
	.word 0xde97e000  ! 1112: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0xd8874e80  ! 1113: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r12
	.word 0xd6a7a000  ! 1114: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6a7a000  ! 1115: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	mov	0x8, %r18
	mov	0x58, %r19
	.word 0xde870e80  ! 1118: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r15
	.word 0xd0c7ce80  ! 1119: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r8
	.word 0xd6f584a0  ! 1120: STXA_R	stxa	%r11, [%r22 + %r0] 0x25
	.word 0xdcaf6000  ! 1121: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	mov	0x50, %r16
	.word 0xdc87a000  ! 1123: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xd6af4e80  ! 1124: STBA_R	stba	%r11, [%r29 + %r0] 0x74
	.word 0xd2a689e0  ! 1125: STWA_R	stwa	%r9, [%r26 + %r0] 0x4f
	.word 0xd6ac0400  ! 1126: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0xd6af8e60  ! 1127: STBA_R	stba	%r11, [%r30 + %r0] 0x73
	.word 0xdcbfa000  ! 1128: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdc9f2000  ! 1129: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xd4bc0400  ! 1130: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xdcaf4e80  ! 1131: STBA_R	stba	%r14, [%r29 + %r0] 0x74
	mov	0x3d0, %r21
	.word 0xd8b74e80  ! 1133: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	mov	0x3d0, %r22
	.word 0xdc976000  ! 1135: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	.word 0xd0b74e60  ! 1136: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	.word 0xd0af2000  ! 1137: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1138: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1139: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r26
	mov	0x48, %r26
	.word 0xd0876000  ! 1142: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	mov	0x68, %r26
	mov	0x30, %r26
	.word 0x87802020  ! 1145: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r23
	.word 0xd0c7e000  ! 1147: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	mov	0x7c0, %r22
	.word 0xd0a7e000  ! 1149: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xd087e000  ! 1150: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0xd2bf4e80  ! 1151: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	.word 0xdcb74e80  ! 1152: STHA_R	stha	%r14, [%r29 + %r0] 0x74
	.word 0xde876000  ! 1153: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	mov	0x58, %r19
	.word 0xdabc0400  ! 1155: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xd097a000  ! 1156: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	.word 0xd2b504a0  ! 1157: STHA_R	stha	%r9, [%r20 + %r0] 0x25
	.word 0xd28f2000  ! 1158: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	mov	0x78, %r27
	mov	0x7c0, %r22
	.word 0xd2b72000  ! 1161: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 1162: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdef4c400  ! 1163: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	mov	0x18, %r27
	.word 0x87802020  ! 1165: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f76000  ! 1166: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1167: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f7a000  ! 1168: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd2af4e40  ! 1169: STBA_R	stba	%r9, [%r29 + %r0] 0x72
	mov	0x58, %r24
	.word 0xda87a000  ! 1171: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0xda87e000  ! 1172: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	mov	0x18, %r18
	mov	0x7f0, %r21
	mov	0x60, %r26
	.word 0xda8fe000  ! 1176: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xdabfa000  ! 1177: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xda9fe000  ! 1178: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xdac72000  ! 1179: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0xd0af0e40  ! 1180: STBA_R	stba	%r8, [%r28 + %r0] 0x72
	mov	0x78, %r16
	.word 0x87802020  ! 1182: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad5a000  ! 1183: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r13
	mov	0x58, %r26
	.word 0x87802074  ! 1185: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r25
	.word 0x87802020  ! 1187: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1188: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r26
	mov	0x7d8, %r20
	.word 0x87802025  ! 1191: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r18
	mov	0x20, %r19
	.word 0xda8c2000  ! 1194: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1195: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r21
	mov	0x3d8, %r23
	mov	0x7c8, %r21
	.word 0xd6a40400  ! 1199: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	mov	0x3e0, %r23
	.word 0xda95c4a0  ! 1201: LDUHA_R	lduha	[%r23, %r0] 0x25, %r13
	mov	0x18, %r16
	.word 0xdcb6c9e0  ! 1203: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	.word 0xd6acc400  ! 1204: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0x87802074  ! 1205: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b48400  ! 1206: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	mov	0x78, %r26
	.word 0xd2b72000  ! 1208: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd2f7a000  ! 1209: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xd2a7ce80  ! 1210: STWA_R	stwa	%r9, [%r31 + %r0] 0x74
	.word 0xdaf7e000  ! 1211: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 1212: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda9ee000  ! 1213: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r13
	.word 0xdade6000  ! 1214: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r13
	.word 0xda8f0e80  ! 1215: LDUBA_R	lduba	[%r28, %r0] 0x74, %r13
	.word 0xd2d7ce40  ! 1216: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r9
	.word 0xdcc66000  ! 1217: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	.word 0x87802020  ! 1218: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bf8e40  ! 1219: STDA_R	stda	%r8, [%r30 + %r0] 0x72
	mov	0x58, %r19
	.word 0x87802025  ! 1221: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r25
	.word 0xd497ce60  ! 1223: LDUHA_R	lduha	[%r31, %r0] 0x73, %r10
	.word 0x87802073  ! 1224: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb76000  ! 1225: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 1226: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd68fce80  ! 1227: LDUBA_R	lduba	[%r31, %r0] 0x74, %r11
	.word 0xd4ce09e0  ! 1228: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r10
	mov	0x7f8, %r23
	.word 0x87802020  ! 1230: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r22
	mov	0x3e0, %r21
	.word 0xdca42000  ! 1233: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	mov	0x70, %r25
	mov	0x3d0, %r23
	mov	0x3d0, %r21
	.word 0xde8544a0  ! 1237: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r15
	mov	0x70, %r16
	mov	0x7e8, %r22
	.word 0xde9504a0  ! 1240: LDUHA_R	lduha	[%r20, %r0] 0x25, %r15
	.word 0xdebfce60  ! 1241: STDA_R	stda	%r15, [%r31 + %r0] 0x73
	.word 0xde87ce60  ! 1242: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r15
	.word 0xd29c8400  ! 1243: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	.word 0xd6b4a000  ! 1244: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xdaf48400  ! 1245: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xd6dc2000  ! 1246: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r11
	mov	0x50, %r24
	.word 0xdaaf4e80  ! 1248: STBA_R	stba	%r13, [%r29 + %r0] 0x74
	.word 0xd29f4e80  ! 1249: LDDA_R	ldda	[%r29, %r0] 0x74, %r9
	.word 0xdcb46000  ! 1250: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	mov	0x70, %r25
	mov	0x38, %r18
	mov	0x40, %r19
	.word 0xd684c400  ! 1254: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	mov	0x78, %r25
	.word 0xdec609e0  ! 1256: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r15
	mov	0x18, %r26
	.word 0xd2f4a000  ! 1258: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	mov	0x40, %r18
	mov	0x0, %r25
	.word 0x87802073  ! 1261: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4dcc400  ! 1262: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	mov	0x8, %r17
	.word 0xd2af4e60  ! 1264: STBA_R	stba	%r9, [%r29 + %r0] 0x73
	mov	0x3f8, %r22
	.word 0xdca7e000  ! 1266: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdca7a000  ! 1267: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcaf2000  ! 1268: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdcd76000  ! 1269: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	mov	0x8, %r27
	mov	0x20, %r24
	.word 0xdcbfa000  ! 1272: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 1273: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 1274: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda940400  ! 1275: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	.word 0xd0bc8400  ! 1276: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0xd8adc4a0  ! 1277: STBA_R	stba	%r12, [%r23 + %r0] 0x25
	.word 0xdab7e000  ! 1278: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xdec78e80  ! 1279: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r15
	.word 0xd8c544a0  ! 1280: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r12
	.word 0xd8c76000  ! 1281: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8bf2000  ! 1282: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1283: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d4a000  ! 1284: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	mov	0x7e0, %r20
	mov	0x68, %r26
	.word 0xd28dc4a0  ! 1287: LDUBA_R	lduba	[%r23, %r0] 0x25, %r9
	.word 0xdecc2000  ! 1288: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	mov	0x7f8, %r20
	mov	0x3f0, %r23
	.word 0xd8f7ce80  ! 1291: STXA_R	stxa	%r12, [%r31 + %r0] 0x74
	.word 0xd2dc2000  ! 1292: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r9
	mov	0x3d8, %r20
	.word 0xd69e49e0  ! 1294: LDDA_R	ldda	[%r25, %r0] 0x4f, %r11
	.word 0xd6b48400  ! 1295: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	mov	0x48, %r17
	mov	0x40, %r25
	.word 0xd6d74e40  ! 1298: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r11
	.word 0xd0c42000  ! 1299: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r8
	.word 0xd0a42000  ! 1300: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xdebec9e0  ! 1301: STDA_R	stda	%r15, [%r27 + %r0] 0x4f
	.word 0xdcbf8e40  ! 1302: STDA_R	stda	%r14, [%r30 + %r0] 0x72
	mov	0x3d8, %r22
	.word 0xdaa4a000  ! 1304: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	mov	0x18, %r27
	.word 0xdac46000  ! 1306: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r13
	mov	0x60, %r18
	.word 0xdaac2000  ! 1308: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0xdcdec9e0  ! 1309: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r14
	.word 0xd6ad04a0  ! 1310: STBA_R	stba	%r11, [%r20 + %r0] 0x25
	mov	0x60, %r27
	.word 0xdcf689e0  ! 1312: STXA_R	stxa	%r14, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 1313: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda974e60  ! 1314: LDUHA_R	lduha	[%r29, %r0] 0x73, %r13
	.word 0x8780204f  ! 1315: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f6a000  ! 1316: STXA_I	stxa	%r11, [%r26 + 0x0000] %asi
	mov	0x78, %r25
	.word 0xd8c44400  ! 1318: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r12
	.word 0x87802073  ! 1319: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 1320: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab76000  ! 1321: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdaf72000  ! 1322: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdab72000  ! 1323: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 1324: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabde000  ! 1325: STDA_I	stda	%r13, [%r23 + 0x0000] %asi
	.word 0xdac5e000  ! 1326: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r13
	.word 0xd8afce40  ! 1327: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	.word 0xd0d78e60  ! 1328: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r8
	.word 0xd68da000  ! 1329: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r11
	.word 0xd2b44400  ! 1330: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0xd6a5e000  ! 1331: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	.word 0xd285c4a0  ! 1332: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r9
	.word 0xd6ac8400  ! 1333: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xdaf56000  ! 1334: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	.word 0xda85e000  ! 1335: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	.word 0xda95a000  ! 1336: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r13
	.word 0xdabe09e0  ! 1337: STDA_R	stda	%r13, [%r24 + %r0] 0x4f
	.word 0xd2cd2000  ! 1338: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r9
	.word 0xd6bc8400  ! 1339: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xd8d70e80  ! 1340: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r12
	.word 0x87802025  ! 1341: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabf2000  ! 1342: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xdadfa000  ! 1344: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xd8b40400  ! 1345: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xde97e000  ! 1346: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0xd0a5c4a0  ! 1347: STWA_R	stwa	%r8, [%r23 + %r0] 0x25
	.word 0x87802074  ! 1348: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabfe000  ! 1349: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	mov	0x3c8, %r21
	mov	0x20, %r25
	.word 0xdaaf2000  ! 1352: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1353: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r24
	.word 0x87802020  ! 1355: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8fe000  ! 1356: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	mov	0x28, %r26
	.word 0xd0ae89e0  ! 1358: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	.word 0xdef76000  ! 1359: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdef76000  ! 1360: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xde8584a0  ! 1361: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r15
	.word 0xd087ce80  ! 1362: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r8
	mov	0x78, %r24
	mov	0x3c0, %r20
	.word 0xd4a7a000  ! 1365: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1366: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r16
	mov	0x78, %r27
	.word 0x87802072  ! 1369: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf78e40  ! 1370: STXA_R	stxa	%r14, [%r30 + %r0] 0x72
	.word 0x87802073  ! 1371: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c0, %r21
	mov	0x58, %r24
	.word 0xdcac8400  ! 1374: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	mov	0x3f8, %r22
	.word 0xd4bcc400  ! 1376: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0xd49f0e60  ! 1377: LDDA_R	ldda	[%r28, %r0] 0x73, %r10
	.word 0xd6a4a000  ! 1378: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	.word 0xd6b46000  ! 1379: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd6a42000  ! 1380: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xd6cca000  ! 1381: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r11
	.word 0x87802073  ! 1382: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6c7a000  ! 1383: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	.word 0xd0c504a0  ! 1384: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r8
	mov	0x70, %r18
	.word 0xdca70e80  ! 1386: STWA_R	stwa	%r14, [%r28 + %r0] 0x74
	.word 0x8780204f  ! 1387: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d8, %r21
	.word 0xd49e49e0  ! 1389: LDDA_R	ldda	[%r25, %r0] 0x4f, %r10
	.word 0xdccd6000  ! 1390: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r14
	mov	0x3c0, %r23
	.word 0xd2a74e60  ! 1392: STWA_R	stwa	%r9, [%r29 + %r0] 0x73
	.word 0xd88de000  ! 1393: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1394: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88f6000  ! 1395: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xd4ac4400  ! 1396: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xd28d04a0  ! 1397: LDUBA_R	lduba	[%r20, %r0] 0x25, %r9
	.word 0xd8ac0400  ! 1398: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xdeafa000  ! 1399: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xd4a5c4a0  ! 1400: STWA_R	stwa	%r10, [%r23 + %r0] 0x25
	.word 0xd4f544a0  ! 1401: STXA_R	stxa	%r10, [%r21 + %r0] 0x25
	.word 0xdabf0e60  ! 1402: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	.word 0x87802074  ! 1403: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f72000  ! 1404: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	mov	0x3c8, %r20
	.word 0xd6f7a000  ! 1406: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6dfa000  ! 1407: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	mov	0x20, %r24
	.word 0x87802020  ! 1409: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bf2000  ! 1410: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 1411: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f52000  ! 1412: STXA_I	stxa	%r11, [%r20 + 0x0000] %asi
	.word 0xd4b70e60  ! 1413: STHA_R	stha	%r10, [%r28 + %r0] 0x73
	.word 0xdeb70e40  ! 1414: STHA_R	stha	%r15, [%r28 + %r0] 0x72
	mov	0x28, %r24
	.word 0xd4a5e000  ! 1416: STWA_I	stwa	%r10, [%r23 + 0x0000] %asi
	.word 0xd0d74e60  ! 1417: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r8
	.word 0xdccf4e60  ! 1418: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r14
	mov	0x30, %r19
	mov	0x0, %r17
	.word 0xdacf0e40  ! 1421: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r13
	.word 0xdc8fce80  ! 1422: LDUBA_R	lduba	[%r31, %r0] 0x74, %r14
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x10, %r19
	.word 0x87802020  ! 1425: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa72000  ! 1426: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xda976000  ! 1427: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	.word 0xd6af0e60  ! 1428: STBA_R	stba	%r11, [%r28 + %r0] 0x73
	.word 0xd4a584a0  ! 1429: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	mov	0x38, %r18
	mov	0x78, %r17
	.word 0xda87a000  ! 1432: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0xd4a74e60  ! 1433: STWA_R	stwa	%r10, [%r29 + %r0] 0x73
	.word 0xd6dcc400  ! 1434: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	.word 0x87802074  ! 1435: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r27
	.word 0x87802020  ! 1437: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r26
	.word 0xd08fa000  ! 1439: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0xd0afe000  ! 1440: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd48c4400  ! 1441: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0xdad7a000  ! 1442: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0xdaf76000  ! 1443: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	mov	0x28, %r27
	mov	0x7f8, %r21
	mov	0x0, %r16
	.word 0xda87e000  ! 1447: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	mov	0x68, %r26
	.word 0x87802020  ! 1449: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48d84a0  ! 1450: LDUBA_R	lduba	[%r22, %r0] 0x25, %r10
	.word 0xdcaf6000  ! 1451: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xde9ec9e0  ! 1452: LDDA_R	ldda	[%r27, %r0] 0x4f, %r15
	.word 0x87802020  ! 1453: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde970e40  ! 1454: LDUHA_R	lduha	[%r28, %r0] 0x72, %r15
	.word 0xd6be2000  ! 1455: STDA_I	stda	%r11, [%r24 + 0x0000] %asi
	.word 0xd49544a0  ! 1456: LDUHA_R	lduha	[%r21, %r0] 0x25, %r10
	.word 0xda8e6000  ! 1457: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r13
	.word 0xdac6a000  ! 1458: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r13
	.word 0xda862000  ! 1459: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r13
	.word 0xda8e6000  ! 1460: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r13
	.word 0xdaf66000  ! 1461: STXA_I	stxa	%r13, [%r25 + 0x0000] %asi
	.word 0xdadee000  ! 1462: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r13
	mov	0x7f8, %r20
	mov	0x28, %r19
	mov	0x8, %r26
	.word 0x87802025  ! 1466: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdab56000  ! 1467: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	mov	0x60, %r27
	.word 0xdabd6000  ! 1469: STDA_I	stda	%r13, [%r21 + 0x0000] %asi
	.word 0xda8d2000  ! 1470: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1471: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r17
	.word 0x87802025  ! 1473: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r27
	.word 0xd8a504a0  ! 1475: STWA_R	stwa	%r12, [%r20 + %r0] 0x25
	.word 0x87802072  ! 1476: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r25
	.word 0x87802020  ! 1478: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdf0e40  ! 1479: LDXA_R	ldxa	[%r28, %r0] 0x72, %r14
	.word 0xd8dda000  ! 1480: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r12
	mov	0x20, %r26
	mov	0x7d0, %r22
	.word 0xde8fce40  ! 1483: LDUBA_R	lduba	[%r31, %r0] 0x72, %r15
	ta	T_CHANGE_HPRIV	! macro
	mov	0x18, %r19
	mov	0x30, %r24
	.word 0x87802025  ! 1487: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f0, %r21
	.word 0xdaf7ce80  ! 1489: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	.word 0xdaa46000  ! 1490: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	.word 0xdac42000  ! 1491: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0xd4c7ce80  ! 1492: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r10
	.word 0xd8a78e80  ! 1493: STWA_R	stwa	%r12, [%r30 + %r0] 0x74
	.word 0x87802073  ! 1494: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda9fa000  ! 1495: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xd6afce80  ! 1496: STBA_R	stba	%r11, [%r31 + %r0] 0x74
	.word 0xdaf72000  ! 1497: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 1498: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d0, %r22
	mov	0x3c8, %r22
	.word 0xde8584a0  ! 1501: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r15
	mov	0x58, %r27
	.word 0x87802020  ! 1503: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r20
	mov	0x3f0, %r21
	.word 0xdca40400  ! 1506: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	mov	0x10, %r25
	.word 0xdaf72000  ! 1508: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xd8a48400  ! 1509: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	.word 0x87802020  ! 1510: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1511: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r27
	.word 0xdcf70e40  ! 1513: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	mov	0x7f0, %r22
	.word 0xd0dce000  ! 1515: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1516: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09c6000  ! 1517: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r8
	.word 0xd4aec9e0  ! 1518: STBA_R	stba	%r10, [%r27 + %r0] 0x4f
	.word 0x87802072  ! 1519: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0be09e0  ! 1520: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	mov	0x58, %r18
	.word 0xde9d44a0  ! 1522: LDDA_R	ldda	[%r21, %r0] 0x25, %r15
	.word 0xd4f7ce60  ! 1523: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	mov	0x78, %r19
	.word 0x87802020  ! 1525: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1526: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd68f2000  ! 1527: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xd8f48400  ! 1528: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	mov	0x7c8, %r21
	.word 0xd0cc8400  ! 1530: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	mov	0x18, %r19
	.word 0xd8b7e000  ! 1532: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0xd29f0e40  ! 1533: LDDA_R	ldda	[%r28, %r0] 0x72, %r9
	mov	0x3d0, %r22
	mov	0x7f8, %r20
	.word 0xd0b40400  ! 1536: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 1537: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r26
	.word 0xd8d76000  ! 1539: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xd8c6c9e0  ! 1540: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r12
	.word 0xd0a7ce80  ! 1541: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	mov	0x40, %r25
	.word 0xd4bf4e40  ! 1543: STDA_R	stda	%r10, [%r29 + %r0] 0x72
	mov	0x58, %r25
	.word 0x87802072  ! 1545: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd88fa000  ! 1546: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0xd8f72000  ! 1547: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	mov	0x3d0, %r23
	.word 0x87802073  ! 1549: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 1550: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd897a000  ! 1551: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0xd0c48400  ! 1552: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r8
	.word 0xd4be89e0  ! 1553: STDA_R	stda	%r10, [%r26 + %r0] 0x4f
	mov	0x10, %r27
	.word 0xd6940400  ! 1555: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	.word 0x87802025  ! 1556: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2a7ce80  ! 1557: STWA_R	stwa	%r9, [%r31 + %r0] 0x74
	.word 0xd0f7a000  ! 1558: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xda9d04a0  ! 1559: LDDA_R	ldda	[%r20, %r0] 0x25, %r13
	mov	0x20, %r17
	mov	0x78, %r16
	.word 0x87802020  ! 1562: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdacfa000  ! 1563: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	mov	0x48, %r16
	.word 0xdaa7e000  ! 1565: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xd0d7ce40  ! 1566: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r8
	.word 0x87802025  ! 1567: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0af0e80  ! 1568: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	.word 0x87802073  ! 1569: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r27
	.word 0xd087e000  ! 1571: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0x87802074  ! 1572: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd09f6000  ! 1573: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	mov	0x3f8, %r22
	mov	0x48, %r26
	mov	0x7c0, %r23
	.word 0xd097a000  ! 1577: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	mov	0x70, %r24
	.word 0xda96c9e0  ! 1579: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r13
	.word 0xdecfa000  ! 1580: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xde9fe000  ! 1581: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0xdeb7a000  ! 1582: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 1583: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r27
	.word 0xd4b40400  ! 1585: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0xdc8cc400  ! 1586: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	mov	0x48, %r18
	.word 0x87802074  ! 1588: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d8, %r23
	.word 0xd8d48400  ! 1590: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0x87802072  ! 1591: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r26
	.word 0xdc9e6000  ! 1593: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r14
	.word 0xdac584a0  ! 1594: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r13
	.word 0xd8cc8400  ! 1595: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0x87802074  ! 1596: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde872000  ! 1597: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xdeb70e80  ! 1598: STHA_R	stha	%r15, [%r28 + %r0] 0x74
	mov	0x30, %r16
	ta	T_CHANGE_PRIV	! macro
	.word 0xd4cd04a0  ! 1601: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r10
	.word 0xd2bfa000  ! 1602: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 1603: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdece49e0  ! 1604: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r15
	.word 0x87802020  ! 1605: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f62000  ! 1606: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	.word 0xd2de6000  ! 1607: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r9
	mov	0x7f8, %r21
	.word 0xd2dee000  ! 1609: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r9
	mov	0x3d0, %r22
	.word 0x87802020  ! 1611: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1612: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d78e60  ! 1613: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r12
	.word 0x87802073  ! 1614: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d8, %r20
	.word 0xdaace000  ! 1616: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0xd2bcc400  ! 1617: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	mov	0x40, %r16
	.word 0x87802072  ! 1619: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r26
	.word 0x87802020  ! 1621: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd496a000  ! 1622: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r10
	mov	0x50, %r17
	.word 0xd49e2000  ! 1624: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r10
	.word 0x87802025  ! 1625: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaf649e0  ! 1626: STXA_R	stxa	%r13, [%r25 + %r0] 0x4f
	mov	0x70, %r25
	.word 0xdca689e0  ! 1628: STWA_R	stwa	%r14, [%r26 + %r0] 0x4f
	.word 0xde9f0e40  ! 1629: LDDA_R	ldda	[%r28, %r0] 0x72, %r15
	.word 0xd4b46000  ! 1630: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xdebe09e0  ! 1631: STDA_R	stda	%r15, [%r24 + %r0] 0x4f
	.word 0xd6ace000  ! 1632: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802072  ! 1634: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f7e000  ! 1635: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	mov	0x0, %r27
	mov	0x3c8, %r23
	.word 0xdaa48400  ! 1638: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0xd6a76000  ! 1639: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd8dc4400  ! 1640: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0xd0cd04a0  ! 1641: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r8
	.word 0xdcb7a000  ! 1642: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xdcac0400  ! 1643: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xd28cc400  ! 1644: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	.word 0xd09f6000  ! 1645: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1646: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0d62000  ! 1647: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r8
	mov	0x70, %r27
	.word 0xdc8544a0  ! 1649: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r14
	.word 0xd0ce2000  ! 1650: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r8
	.word 0xd0a62000  ! 1651: STWA_I	stwa	%r8, [%r24 + 0x0000] %asi
	mov	0x20, %r18
	.word 0xd0b62000  ! 1653: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	mov	0x3f0, %r20
	mov	0x30, %r17
	.word 0xd0be6000  ! 1656: STDA_I	stda	%r8, [%r25 + 0x0000] %asi
	.word 0xd0de2000  ! 1657: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r8
	.word 0xdaa78e60  ! 1658: STWA_R	stwa	%r13, [%r30 + %r0] 0x73
	.word 0xde8ea000  ! 1659: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r15
	mov	0x60, %r16
	.word 0xd6c44400  ! 1661: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r11
	.word 0xd68e2000  ! 1662: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r11
	mov	0x68, %r27
	mov	0x3e0, %r20
	.word 0xd69ea000  ! 1665: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r11
	.word 0x87802072  ! 1666: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x7d0, %r20
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6a76000  ! 1670: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6cf2000  ! 1671: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	mov	0x70, %r16
	mov	0x30, %r26
	.word 0xd6b7a000  ! 1674: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xdecdc4a0  ! 1675: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r15
	.word 0xdca7a000  ! 1676: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xd8b4c400  ! 1677: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0xd8df8e40  ! 1678: LDXA_R	ldxa	[%r30, %r0] 0x72, %r12
	mov	0x0, %r18
	.word 0xd89f0e60  ! 1680: LDDA_R	ldda	[%r28, %r0] 0x73, %r12
	mov	0x3e8, %r23
	.word 0xde9fa000  ! 1682: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	.word 0xde876000  ! 1683: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xdef76000  ! 1684: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xd2dc4400  ! 1685: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	mov	0x78, %r25
	.word 0xdcbc8400  ! 1687: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xdef5c4a0  ! 1688: STXA_R	stxa	%r15, [%r23 + %r0] 0x25
	.word 0xd08fa000  ! 1689: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0xd0d76000  ! 1690: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0f76000  ! 1691: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	mov	0x0, %r16
	.word 0xd0c70e80  ! 1693: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r8
	.word 0x87802020  ! 1694: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b46000  ! 1695: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0xd2ac2000  ! 1696: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd2d4e000  ! 1697: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	mov	0x78, %r19
	.word 0xd2a42000  ! 1699: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	.word 0xd2842000  ! 1700: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r9
	.word 0xd2bce000  ! 1701: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xd2d4a000  ! 1702: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	.word 0xd2b4a000  ! 1703: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0xd2a4a000  ! 1704: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 1705: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dfe000  ! 1706: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0xd8b584a0  ! 1707: STHA_R	stha	%r12, [%r22 + %r0] 0x25
	.word 0xdca7e000  ! 1708: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdaad84a0  ! 1709: STBA_R	stba	%r13, [%r22 + %r0] 0x25
	.word 0xd6b689e0  ! 1710: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	.word 0xd09f8e80  ! 1711: LDDA_R	ldda	[%r30, %r0] 0x74, %r8
	.word 0xde8fe000  ! 1712: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0xde8fe000  ! 1713: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0xdac48400  ! 1714: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	mov	0x10, %r25
	.word 0xd8df0e60  ! 1716: LDXA_R	ldxa	[%r28, %r0] 0x73, %r12
	.word 0x87802073  ! 1717: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0f46000  ! 1718: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xdad78e40  ! 1719: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r13
	.word 0xdaae89e0  ! 1720: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	.word 0xd8a40400  ! 1721: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	mov	0x7c8, %r22
	.word 0x87802072  ! 1723: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde8f4e80  ! 1724: LDUBA_R	lduba	[%r29, %r0] 0x74, %r15
	.word 0xde8da000  ! 1725: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r15
	.word 0xd0b7ce40  ! 1726: STHA_R	stha	%r8, [%r31 + %r0] 0x72
	mov	0x78, %r24
	mov	0x18, %r27
	.word 0xdead6000  ! 1729: STBA_I	stba	%r15, [%r21 + 0x0000] %asi
	.word 0xdebf4e40  ! 1730: STDA_R	stda	%r15, [%r29 + %r0] 0x72
	.word 0xd2f5a000  ! 1731: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	.word 0x87802025  ! 1732: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 1733: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a44400  ! 1734: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xde94e000  ! 1735: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	.word 0xdc948400  ! 1736: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	.word 0xd8842000  ! 1737: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	.word 0xdaafce60  ! 1738: STBA_R	stba	%r13, [%r31 + %r0] 0x73
	mov	0x38, %r24
	mov	0x7f8, %r20
	.word 0xd6ace000  ! 1741: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0xd8cec9e0  ! 1742: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r12
	.word 0xd4c48400  ! 1743: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r10
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2f7ce40  ! 1745: STXA_R	stxa	%r9, [%r31 + %r0] 0x72
	mov	0x0, %r19
	mov	0x20, %r16
	.word 0xdad70e40  ! 1748: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r13
	mov	0x0, %r26
	.word 0x87802020  ! 1750: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f7ce40  ! 1751: STXA_R	stxa	%r8, [%r31 + %r0] 0x72
	.word 0xd6b544a0  ! 1752: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	.word 0xd4cfe000  ! 1753: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0xd487e000  ! 1754: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4a72000  ! 1755: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	mov	0x3d8, %r22
	.word 0x87802025  ! 1757: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 1758: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabfce40  ! 1759: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	.word 0xd2a62000  ! 1760: STWA_I	stwa	%r9, [%r24 + 0x0000] %asi
	.word 0xd8bc4400  ! 1761: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xdef66000  ! 1762: STXA_I	stxa	%r15, [%r25 + 0x0000] %asi
	mov	0x30, %r19
	.word 0xded6e000  ! 1764: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r15
	mov	0x70, %r27
	.word 0xd8a44400  ! 1766: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	mov	0x3c8, %r20
	.word 0xdad40400  ! 1768: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	.word 0xd2b48400  ! 1769: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd6bcc400  ! 1770: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	mov	0x30, %r17
	.word 0xdabe6000  ! 1772: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	.word 0xdec70e40  ! 1773: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r15
	mov	0x58, %r17
	.word 0x87802072  ! 1775: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6df0e80  ! 1776: LDXA_R	ldxa	[%r28, %r0] 0x74, %r11
	.word 0xd6bf6000  ! 1777: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd68fe000  ! 1778: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xd88c8400  ! 1779: LDUBA_R	lduba	[%r18, %r0] 0x20, %r12
	.word 0xd0f584a0  ! 1780: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	.word 0xdabf0e80  ! 1781: STDA_R	stda	%r13, [%r28 + %r0] 0x74
	.word 0xd287a000  ! 1782: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	mov	0x7c8, %r21
	.word 0xd497ce80  ! 1784: LDUHA_R	lduha	[%r31, %r0] 0x74, %r10
	.word 0x87802020  ! 1785: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a62000  ! 1786: STWA_I	stwa	%r9, [%r24 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xd2b62000  ! 1788: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	mov	0x30, %r24
	.word 0xd2a66000  ! 1790: STWA_I	stwa	%r9, [%r25 + 0x0000] %asi
	mov	0x68, %r27
	.word 0x87802074  ! 1792: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2c7a000  ! 1793: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	mov	0x7d0, %r21
	.word 0xd2a76000  ! 1795: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd2b72000  ! 1796: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xdadf4e40  ! 1797: LDXA_R	ldxa	[%r29, %r0] 0x72, %r13
	.word 0xde8fe000  ! 1798: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0xd8d40400  ! 1799: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	mov	0x48, %r25
	.word 0xd6d74e60  ! 1801: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r11
	.word 0xd6cc0400  ! 1802: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r11
	.word 0xd2b504a0  ! 1803: STHA_R	stha	%r9, [%r20 + %r0] 0x25
	.word 0xd2dfe000  ! 1804: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 1805: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 1806: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1807: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc844400  ! 1808: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	.word 0xd2b48400  ! 1809: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	mov	0x30, %r17
	mov	0x3d0, %r21
	.word 0xdacf4e60  ! 1812: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r13
	.word 0xdcaf0e60  ! 1813: STBA_R	stba	%r14, [%r28 + %r0] 0x73
	.word 0xd2ace000  ! 1814: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0xdc9f0e60  ! 1815: LDDA_R	ldda	[%r28, %r0] 0x73, %r14
	.word 0xdef74e80  ! 1816: STXA_R	stxa	%r15, [%r29 + %r0] 0x74
	mov	0x7e0, %r21
	.word 0xd2ac6000  ! 1818: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd2a4e000  ! 1819: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 1820: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 1821: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e0, %r22
	.word 0x8780204f  ! 1823: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd68d04a0  ! 1824: LDUBA_R	lduba	[%r20, %r0] 0x25, %r11
	.word 0xd0a46000  ! 1825: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	mov	0x8, %r16
	mov	0x20, %r24
	.word 0xdccfce80  ! 1828: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r14
	.word 0xd6df8e60  ! 1829: LDXA_R	ldxa	[%r30, %r0] 0x73, %r11
	mov	0x68, %r25
	mov	0x3f8, %r20
	.word 0xd0ac8400  ! 1832: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0x87802020  ! 1833: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r20
	mov	0x3e0, %r22
	.word 0xd68fe000  ! 1836: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xd2a48400  ! 1837: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0xdcc40400  ! 1838: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	.word 0xdcbfce80  ! 1839: STDA_R	stda	%r14, [%r31 + %r0] 0x74
	.word 0x8780204f  ! 1840: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdccf2000  ! 1841: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0x87802020  ! 1842: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1843: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r27
	.word 0xd0f7ce80  ! 1845: STXA_R	stxa	%r8, [%r31 + %r0] 0x74
	.word 0xd6cc2000  ! 1846: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	.word 0xd0bf4e80  ! 1847: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	.word 0xda9c2000  ! 1848: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	.word 0xdaf46000  ! 1849: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 1850: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r18
	.word 0xd8940400  ! 1852: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	mov	0x3d8, %r21
	mov	0x0, %r25
	.word 0xd294e000  ! 1855: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	.word 0xd2ac6000  ! 1856: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd28ca000  ! 1857: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2a4e000  ! 1858: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2bce000  ! 1859: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 1860: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdca7ce60  ! 1861: STWA_R	stwa	%r14, [%r31 + %r0] 0x73
	.word 0xd4afce60  ! 1862: STBA_R	stba	%r10, [%r31 + %r0] 0x73
	mov	0x48, %r16
	.word 0xde876000  ! 1864: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xd29d44a0  ! 1865: LDDA_R	ldda	[%r21, %r0] 0x25, %r9
	.word 0xdcafe000  ! 1866: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 1867: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb7e000  ! 1868: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	mov	0x78, %r17
	.word 0xdcb72000  ! 1870: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xdcaf2000  ! 1871: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdcf72000  ! 1872: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcdf2000  ! 1873: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	mov	0x7e8, %r20
	.word 0xdcf7a000  ! 1875: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x10, %r18
	mov	0x7c8, %r22
	mov	0x48, %r17
	.word 0xdca7e000  ! 1879: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xd0dc0400  ! 1880: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0x87802072  ! 1881: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d0, %r22
	.word 0xdca7e000  ! 1883: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xd0ccc400  ! 1884: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	mov	0x8, %r17
	mov	0x20, %r27
	.word 0xdaf7e000  ! 1887: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xd8f5c4a0  ! 1888: STXA_R	stxa	%r12, [%r23 + %r0] 0x25
	.word 0x87802073  ! 1889: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4cce000  ! 1890: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	.word 0xdec584a0  ! 1891: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r15
	.word 0x87802074  ! 1892: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaad84a0  ! 1893: STBA_R	stba	%r13, [%r22 + %r0] 0x25
	.word 0x87802074  ! 1894: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4c609e0  ! 1895: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r10
	.word 0xdaa72000  ! 1896: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	mov	0x38, %r26
	.word 0x87802072  ! 1898: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49c4400  ! 1899: LDDA_R	ldda	[%r17, %r0] 0x20, %r10
	.word 0xd6df4e80  ! 1900: LDXA_R	ldxa	[%r29, %r0] 0x74, %r11
	.word 0xdcbe09e0  ! 1901: STDA_R	stda	%r14, [%r24 + %r0] 0x4f
	.word 0xda944400  ! 1902: LDUHA_R	lduha	[%r17, %r0] 0x20, %r13
	.word 0xd0dc0400  ! 1903: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xd4b70e40  ! 1904: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	.word 0xd2a7ce40  ! 1905: STWA_R	stwa	%r9, [%r31 + %r0] 0x72
	.word 0x87802025  ! 1906: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f8, %r21
	.word 0xd4afa000  ! 1908: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xde8d04a0  ! 1909: LDUBA_R	lduba	[%r20, %r0] 0x25, %r15
	.word 0x87802020  ! 1910: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1911: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbea000  ! 1912: STDA_I	stda	%r14, [%r26 + 0x0000] %asi
	.word 0xdc9ea000  ! 1913: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r14
	.word 0xdcde6000  ! 1914: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r14
	.word 0x87802025  ! 1915: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0b649e0  ! 1916: STHA_R	stha	%r8, [%r25 + %r0] 0x4f
	mov	0x3c8, %r23
	.word 0xdac5a000  ! 1918: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r13
	mov	0x3c0, %r21
	.word 0xd2cf4e60  ! 1920: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r9
	.word 0xde948400  ! 1921: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	.word 0x87802020  ! 1922: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc878e60  ! 1923: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r14
	mov	0x28, %r24
	.word 0xd8df6000  ! 1925: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	mov	0x78, %r18
	.word 0xd8a7a000  ! 1927: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	mov	0x0, %r26
	mov	0x7e8, %r21
	.word 0xd8af2000  ! 1930: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xd8cf2000  ! 1931: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0xd8b7e000  ! 1932: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1933: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8dce000  ! 1935: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	mov	0x78, %r17
	mov	0x20, %r26
	.word 0xd2ce49e0  ! 1938: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r9
	.word 0xd2cf4e80  ! 1939: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r9
	.word 0xdaf48400  ! 1940: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xdcd4a000  ! 1941: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	.word 0xdcf4a000  ! 1942: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	mov	0x3d8, %r22
	mov	0x60, %r25
	.word 0xd0cd44a0  ! 1945: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r8
	.word 0x87802020  ! 1946: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1947: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0aee000  ! 1948: STBA_I	stba	%r8, [%r27 + 0x0000] %asi
	.word 0xd68f8e40  ! 1949: LDUBA_R	lduba	[%r30, %r0] 0x72, %r11
	.word 0x87802020  ! 1950: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebf0e60  ! 1951: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	.word 0xdcbee000  ! 1952: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	.word 0xdcd62000  ! 1953: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r14
	.word 0xd6d4c400  ! 1954: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	.word 0xdec6a000  ! 1955: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r15
	.word 0xdec66000  ! 1956: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r15
	.word 0xde9ee000  ! 1957: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r15
	.word 0xd8c48400  ! 1958: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	.word 0xdede2000  ! 1959: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r15
	.word 0xdabf0e60  ! 1960: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	.word 0xd6f62000  ! 1961: STXA_I	stxa	%r11, [%r24 + 0x0000] %asi
	mov	0x3f8, %r20
	mov	0x50, %r24
	mov	0x50, %r24
	.word 0xdaf40400  ! 1965: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xd6af0e40  ! 1966: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	mov	0x10, %r24
	mov	0x3d0, %r22
	mov	0x68, %r18
	mov	0x28, %r16
	mov	0x68, %r26
	.word 0xd2962000  ! 1972: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r9
	mov	0x30, %r16
	.word 0xd697ce60  ! 1974: LDUHA_R	lduha	[%r31, %r0] 0x73, %r11
	.word 0x87802020  ! 1975: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0dfe000  ! 1976: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	mov	0x58, %r19
	.word 0xd4bfce60  ! 1978: STDA_R	stda	%r10, [%r31 + %r0] 0x73
	.word 0xdcd44400  ! 1979: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	.word 0xd8adc4a0  ! 1980: STBA_R	stba	%r12, [%r23 + %r0] 0x25
	.word 0x87802073  ! 1981: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r19
	mov	0x18, %r17
	.word 0xd0d584a0  ! 1984: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r8
	.word 0xd0bcc400  ! 1985: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0xdcb72000  ! 1986: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1987: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca5e000  ! 1988: STWA_I	stwa	%r14, [%r23 + 0x0000] %asi
	mov	0x7d0, %r22
	mov	0x20, %r18
	.word 0xd4dc4400  ! 1991: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	mov	0x28, %r26
	.word 0x87802072  ! 1993: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xded4a000  ! 1994: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	.word 0xdecc4400  ! 1995: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r15
	.word 0xdcdc2000  ! 1996: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r14
	.word 0xd0844400  ! 1997: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r8
	.word 0xd4946000  ! 1998: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r10
	.word 0xdebd04a0  ! 1999: STDA_R	stda	%r15, [%r20 + %r0] 0x25
	.word 0xdea4a000  ! 2000: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xde842000  ! 2001: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	.word 0xd6acc400  ! 2002: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xd0b7ce60  ! 2003: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	.word 0x87802072  ! 2004: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29f4e80  ! 2005: LDDA_R	ldda	[%r29, %r0] 0x74, %r9
	.word 0xd4dfe000  ! 2006: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4af6000  ! 2007: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xdcf504a0  ! 2008: STXA_R	stxa	%r14, [%r20 + %r0] 0x25
	.word 0x87802073  ! 2009: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f0, %r20
	.word 0x8780204f  ! 2011: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a46000  ! 2012: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	mov	0x7c8, %r21
	.word 0xd29ca000  ! 2014: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	mov	0x7d8, %r21
	mov	0x28, %r24
	mov	0x20, %r19
	.word 0xd2a4a000  ! 2018: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xd0c78e40  ! 2020: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r8
	.word 0xdebf4e40  ! 2021: STDA_R	stda	%r15, [%r29 + %r0] 0x72
	mov	0x70, %r27
	.word 0xd2c4e000  ! 2023: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 2024: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd28fe000  ! 2025: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	.word 0xd2a74e80  ! 2026: STWA_R	stwa	%r9, [%r29 + %r0] 0x74
	.word 0xda8ec9e0  ! 2027: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r13
	.word 0xd4bf2000  ! 2028: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	mov	0x20, %r19
	mov	0x7d0, %r22
	mov	0x38, %r25
	.word 0xd0c7ce40  ! 2032: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r8
	mov	0x60, %r19
	.word 0x87802020  ! 2034: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bf6000  ! 2035: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	mov	0x30, %r19
	.word 0xd8bf6000  ! 2037: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	mov	0x10, %r19
	.word 0xd887a000  ! 2039: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8c7a000  ! 2040: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	ta	T_CHANGE_HPRIV	! macro
	.word 0x8780204f  ! 2042: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r16
	.word 0xd8df6000  ! 2044: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0xd6ad44a0  ! 2045: STBA_R	stba	%r11, [%r21 + %r0] 0x25
	.word 0xd8a7e000  ! 2046: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	mov	0x40, %r19
	.word 0x87802072  ! 2048: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2049: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r20
	mov	0x70, %r25
	.word 0xd8a62000  ! 2052: STWA_I	stwa	%r12, [%r24 + 0x0000] %asi
	.word 0xd8b66000  ! 2053: STHA_I	stha	%r12, [%r25 + 0x0000] %asi
	mov	0x3c0, %r20
	mov	0x8, %r27
	.word 0xdef7ce80  ! 2056: STXA_R	stxa	%r15, [%r31 + %r0] 0x74
	.word 0xd6f74e40  ! 2057: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	mov	0x50, %r24
	.word 0xdc8dc4a0  ! 2059: LDUBA_R	lduba	[%r23, %r0] 0x25, %r14
	.word 0xdccd44a0  ! 2060: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r14
	.word 0xd6bf0e40  ! 2061: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	.word 0x87802020  ! 2062: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8870e80  ! 2063: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r12
	.word 0xdcf5a000  ! 2064: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 2065: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb56000  ! 2066: STHA_I	stha	%r14, [%r21 + 0x0000] %asi
	.word 0xdaf44400  ! 2067: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0x87802025  ! 2068: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcafe000  ! 2069: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdcf72000  ! 2070: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcd72000  ! 2071: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xd2a4c400  ! 2072: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0xd8cfce80  ! 2073: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r12
	.word 0xd697e000  ! 2074: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	mov	0x7c8, %r20
	mov	0x70, %r27
	.word 0xdadf8e40  ! 2077: LDXA_R	ldxa	[%r30, %r0] 0x72, %r13
	.word 0xd6b7a000  ! 2078: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xdaf689e0  ! 2079: STXA_R	stxa	%r13, [%r26 + %r0] 0x4f
	.word 0xd2976000  ! 2080: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0xd2dfa000  ! 2081: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	mov	0x3d0, %r21
	mov	0x48, %r19
	.word 0xd2a7a000  ! 2084: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xd2d7e000  ! 2085: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xd2afe000  ! 2086: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd2bfa000  ! 2087: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xdebfce40  ! 2088: STDA_R	stda	%r15, [%r31 + %r0] 0x72
	.word 0xd8bfa000  ! 2089: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 2090: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebe49e0  ! 2091: STDA_R	stda	%r15, [%r25 + %r0] 0x4f
	.word 0xdaaf4e40  ! 2092: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	mov	0x68, %r19
	.word 0x87802020  ! 2094: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa44400  ! 2095: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0xd0dd04a0  ! 2096: LDXA_R	ldxa	[%r20, %r0] 0x25, %r8
	.word 0xd2f74e60  ! 2097: STXA_R	stxa	%r9, [%r29 + %r0] 0x73
	.word 0xd0f5e000  ! 2098: STXA_I	stxa	%r8, [%r23 + 0x0000] %asi
	.word 0xdec74e40  ! 2099: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r15
	.word 0xd48f4e40  ! 2100: LDUBA_R	lduba	[%r29, %r0] 0x72, %r10
	.word 0xdeac0400  ! 2101: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xda8c4400  ! 2102: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0x8780204f  ! 2103: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 2104: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f6e000  ! 2105: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	mov	0x10, %r18
	.word 0xd0ae2000  ! 2107: STBA_I	stba	%r8, [%r24 + 0x0000] %asi
	.word 0xda9d44a0  ! 2108: LDDA_R	ldda	[%r21, %r0] 0x25, %r13
	.word 0xd8f48400  ! 2109: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xdc97ce40  ! 2110: LDUHA_R	lduha	[%r31, %r0] 0x72, %r14
	.word 0xd8c6a000  ! 2111: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r12
	.word 0x87802073  ! 2112: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r25
	.word 0xd8d52000  ! 2114: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r12
	mov	0x60, %r26
	.word 0xd8d52000  ! 2116: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r12
	.word 0x87802025  ! 2117: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8d42000  ! 2118: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0x87802072  ! 2119: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8f6e000  ! 2120: STXA_I	stxa	%r12, [%r27 + 0x0000] %asi
	mov	0x60, %r16
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2bfce40  ! 2123: STDA_R	stda	%r9, [%r31 + %r0] 0x72
	.word 0xd6944400  ! 2124: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	mov	0x7e0, %r20
	.word 0x87802020  ! 2126: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca6e000  ! 2127: STWA_I	stwa	%r14, [%r27 + 0x0000] %asi
	.word 0xd8f74e40  ! 2128: STXA_R	stxa	%r12, [%r29 + %r0] 0x72
	.word 0xd0a66000  ! 2129: STWA_I	stwa	%r8, [%r25 + 0x0000] %asi
	mov	0x7e0, %r23
	mov	0x68, %r24
	.word 0xd0c62000  ! 2132: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r8
	.word 0xd0dee000  ! 2133: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r8
	.word 0xdcccc400  ! 2134: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	.word 0x87802020  ! 2135: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cd2000  ! 2136: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r8
	.word 0xd0f56000  ! 2137: STXA_I	stxa	%r8, [%r21 + 0x0000] %asi
	.word 0xdeac4400  ! 2138: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0xda8c0400  ! 2139: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	mov	0x28, %r26
	.word 0xd68d6000  ! 2141: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r11
	mov	0x0, %r17
	.word 0xd69cc400  ! 2143: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	.word 0xd6be89e0  ! 2144: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	.word 0xd8a5e000  ! 2145: STWA_I	stwa	%r12, [%r23 + 0x0000] %asi
	.word 0xd6bec9e0  ! 2146: STDA_R	stda	%r11, [%r27 + %r0] 0x4f
	.word 0xdaf78e60  ! 2147: STXA_R	stxa	%r13, [%r30 + %r0] 0x73
	.word 0xd8cda000  ! 2148: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r12
	mov	0x7f8, %r22
	.word 0xd8c5e000  ! 2150: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r12
	.word 0xd8f5a000  ! 2151: STXA_I	stxa	%r12, [%r22 + 0x0000] %asi
	.word 0xd8852000  ! 2152: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r12
	mov	0x10, %r26
	mov	0x7f8, %r21
	.word 0x87802072  ! 2155: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8c4a000  ! 2156: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r12
	.word 0xd8a4a000  ! 2157: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8ac2000  ! 2158: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0xdc96c9e0  ! 2159: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r14
	.word 0xdaac2000  ! 2160: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 2161: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa4a000  ! 2162: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xdab42000  ! 2163: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xdea609e0  ! 2164: STWA_R	stwa	%r15, [%r24 + %r0] 0x4f
	.word 0xd6974e80  ! 2165: LDUHA_R	lduha	[%r29, %r0] 0x74, %r11
	.word 0x87802072  ! 2166: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r18
	.word 0xdaafa000  ! 2168: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	mov	0x8, %r16
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdabf6000  ! 2171: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xdc940400  ! 2172: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	mov	0x18, %r17
	mov	0x7c0, %r21
	mov	0x7d8, %r23
	.word 0x87802072  ! 2176: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f72000  ! 2177: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd68f4e60  ! 2178: LDUBA_R	lduba	[%r29, %r0] 0x73, %r11
	.word 0xded649e0  ! 2179: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r15
	.word 0xd88f2000  ! 2180: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	mov	0x7d0, %r21
	.word 0xd8be09e0  ! 2182: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	.word 0xdcb7e000  ! 2183: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0x8780204f  ! 2185: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 2186: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcdf2000  ! 2187: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcbf2000  ! 2188: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xd4a4c400  ! 2189: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	mov	0x50, %r26
	.word 0x87802072  ! 2191: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbf6000  ! 2192: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 2193: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0970e40  ! 2194: LDUHA_R	lduha	[%r28, %r0] 0x72, %r8
	.word 0xdeb6e000  ! 2195: STHA_I	stha	%r15, [%r27 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0x87802020  ! 2197: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r19
	mov	0x7c8, %r22
	mov	0x3f0, %r23
	.word 0xd4adc4a0  ! 2201: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	mov	0x3e8, %r23
	.word 0xd0f66000  ! 2203: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	mov	0x18, %r16
	.word 0x87802072  ! 2205: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbfce40  ! 2206: STDA_R	stda	%r14, [%r31 + %r0] 0x72
	.word 0xdaf5e000  ! 2207: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0xd4944400  ! 2208: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	mov	0x10, %r25
	.word 0x87802025  ! 2210: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd896a000  ! 2211: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r12
	.word 0x87802025  ! 2212: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6cf8e80  ! 2213: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r11
	.word 0x8780204f  ! 2214: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 2215: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca649e0  ! 2216: STWA_R	stwa	%r14, [%r25 + %r0] 0x4f
	.word 0x8780204f  ! 2217: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r18
	.word 0xdab7e000  ! 2219: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xd88584a0  ! 2220: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r12
	.word 0xd2cf0e60  ! 2221: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r9
	.word 0x87802072  ! 2222: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0c70e60  ! 2223: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r8
	.word 0xd0cdc4a0  ! 2224: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r8
	.word 0xd0a40400  ! 2225: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0xd4cc2000  ! 2226: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	.word 0xd4aca000  ! 2227: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0xdaf44400  ! 2228: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0x87802025  ! 2229: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0952000  ! 2230: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r8
	mov	0x0, %r27
	mov	0x28, %r26
	.word 0xd0c78e40  ! 2233: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r8
	mov	0x40, %r24
	.word 0xd4bd84a0  ! 2235: STDA_R	stda	%r10, [%r22 + %r0] 0x25
	.word 0x87802020  ! 2236: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f5e000  ! 2237: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	mov	0x38, %r18
	.word 0xd4ad6000  ! 2239: STBA_I	stba	%r10, [%r21 + 0x0000] %asi
	.word 0xd4c52000  ! 2240: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r10
	.word 0xd4ada000  ! 2241: STBA_I	stba	%r10, [%r22 + 0x0000] %asi
	mov	0x40, %r16
	mov	0x18, %r26
	.word 0xd49d6000  ! 2244: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r10
	.word 0xd4852000  ! 2245: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r10
	.word 0xdaf504a0  ! 2246: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	.word 0x87802025  ! 2247: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2a70e60  ! 2248: STWA_R	stwa	%r9, [%r28 + %r0] 0x73
	mov	0x20, %r26
	mov	0x70, %r26
	mov	0x10, %r25
	.word 0xd4aec9e0  ! 2252: STBA_R	stba	%r10, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 2253: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bc4400  ! 2254: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xd0970e40  ! 2255: LDUHA_R	lduha	[%r28, %r0] 0x72, %r8
	.word 0xd2bc6000  ! 2256: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	mov	0x50, %r25
	.word 0x87802020  ! 2258: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d5a000  ! 2259: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r9
	.word 0xd2852000  ! 2260: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r9
	.word 0xd0c7ce60  ! 2261: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r8
	.word 0xd885a000  ! 2262: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r12
	.word 0xdaaf8e40  ! 2263: STBA_R	stba	%r13, [%r30 + %r0] 0x72
	.word 0xd8b5a000  ! 2264: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	.word 0xd4a584a0  ! 2265: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	mov	0x7e8, %r20
	.word 0xd8bde000  ! 2267: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0xd89de000  ! 2268: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r12
	.word 0xd8d5a000  ! 2269: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r12
	.word 0xd4c7ce40  ! 2270: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r10
	.word 0xdcad2000  ! 2271: STBA_I	stba	%r14, [%r20 + 0x0000] %asi
	mov	0x7e0, %r20
	.word 0x8780204f  ! 2273: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r17
	.word 0xd0bf8e60  ! 2275: STDA_R	stda	%r8, [%r30 + %r0] 0x73
	.word 0xd0ac4400  ! 2276: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0xd6862000  ! 2277: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r11
	.word 0xd6ae6000  ! 2278: STBA_I	stba	%r11, [%r25 + 0x0000] %asi
	.word 0xd6a6a000  ! 2279: STWA_I	stwa	%r11, [%r26 + 0x0000] %asi
	mov	0x68, %r24
	.word 0xd89f8e40  ! 2281: LDDA_R	ldda	[%r30, %r0] 0x72, %r12
	.word 0xd0c6e000  ! 2282: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r8
	mov	0x70, %r16
	.word 0xd8b7ce80  ! 2284: STHA_R	stha	%r12, [%r31 + %r0] 0x74
	.word 0xd086e000  ! 2285: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 2286: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2287: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r21
	.word 0xdcf6c9e0  ! 2289: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	.word 0xdcdd84a0  ! 2290: LDXA_R	ldxa	[%r22, %r0] 0x25, %r14
	.word 0xd4a62000  ! 2291: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	.word 0xd4ce6000  ! 2292: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r10
	.word 0xd6948400  ! 2293: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	.word 0xd2dfce40  ! 2294: LDXA_R	ldxa	[%r31, %r0] 0x72, %r9
	.word 0x87802020  ! 2295: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc8f0e40  ! 2296: LDUBA_R	lduba	[%r28, %r0] 0x72, %r14
	.word 0xd4944400  ! 2297: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	mov	0x0, %r25
	mov	0x60, %r26
	.word 0xd4970e60  ! 2300: LDUHA_R	lduha	[%r28, %r0] 0x73, %r10
	.word 0xda9f4e80  ! 2301: LDDA_R	ldda	[%r29, %r0] 0x74, %r13
	.word 0xd4b5a000  ! 2302: STHA_I	stha	%r10, [%r22 + 0x0000] %asi
	.word 0xd4ad6000  ! 2303: STBA_I	stba	%r10, [%r21 + 0x0000] %asi
	.word 0xd495e000  ! 2304: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r10
	.word 0xd0be09e0  ! 2305: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0xd6b5e000  ! 2306: STHA_I	stha	%r11, [%r23 + 0x0000] %asi
	.word 0xd6956000  ! 2307: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r11
	.word 0xdca649e0  ! 2308: STWA_R	stwa	%r14, [%r25 + %r0] 0x4f
	.word 0xd0cd2000  ! 2309: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r8
	.word 0x87802072  ! 2310: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0f74e40  ! 2311: STXA_R	stxa	%r8, [%r29 + %r0] 0x72
	.word 0xd28d44a0  ! 2312: LDUBA_R	lduba	[%r21, %r0] 0x25, %r9
	.word 0xd2c7ce80  ! 2313: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r9
	.word 0xd6b76000  ! 2314: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xde870e80  ! 2315: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r15
	.word 0xd6a40400  ! 2316: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0xdea7a000  ! 2317: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xdecfe000  ! 2318: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	mov	0x8, %r26
	.word 0xdaac0400  ! 2320: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xd887a000  ! 2321: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	mov	0x60, %r17
	.word 0xdedf8e60  ! 2323: LDXA_R	ldxa	[%r30, %r0] 0x73, %r15
	.word 0x87802074  ! 2324: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f5a000  ! 2325: STXA_I	stxa	%r8, [%r22 + 0x0000] %asi
	.word 0xd0b52000  ! 2326: STHA_I	stha	%r8, [%r20 + 0x0000] %asi
	.word 0xd0f5a000  ! 2327: STXA_I	stxa	%r8, [%r22 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xd89cc400  ! 2329: LDDA_R	ldda	[%r19, %r0] 0x20, %r12
	mov	0x3e8, %r22
	.word 0x87802020  ! 2331: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r16
	mov	0x7f8, %r22
	.word 0xdedf2000  ! 2334: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xdef76000  ! 2335: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xd0bf4e60  ! 2336: STDA_R	stda	%r8, [%r29 + %r0] 0x73
	mov	0x7d8, %r20
	mov	0x78, %r17
	.word 0xd2af6000  ! 2339: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd2a7e000  ! 2340: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	mov	0x7f8, %r22
	mov	0x3e0, %r21
	.word 0xdca7ce40  ! 2343: STWA_R	stwa	%r14, [%r31 + %r0] 0x72
	.word 0xd0872000  ! 2344: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	mov	0x28, %r16
	mov	0x7e8, %r20
	.word 0xd8848400  ! 2347: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r12
	.word 0xded7ce40  ! 2348: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r15
	.word 0xdec76000  ! 2349: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0x87802020  ! 2350: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2351: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2352: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebca000  ! 2353: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xdab78e40  ! 2354: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	.word 0xdaae89e0  ! 2355: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 2356: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2ac8400  ! 2357: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xdcf7ce80  ! 2358: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	mov	0x58, %r25
	.word 0xd4bdc4a0  ! 2360: STDA_R	stda	%r10, [%r23 + %r0] 0x25
	.word 0xd48fa000  ! 2361: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xd4972000  ! 2362: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	mov	0x40, %r25
	mov	0x7f8, %r21
	.word 0xdecf0e60  ! 2365: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r15
	.word 0x87802025  ! 2366: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r26
	.word 0x87802025  ! 2368: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb7e000  ! 2369: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xdc8f8e60  ! 2370: LDUBA_R	lduba	[%r30, %r0] 0x73, %r14
	.word 0xd89fe000  ! 2371: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0xd89fe000  ! 2372: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0x87802025  ! 2373: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r18
	.word 0xd8b46000  ! 2375: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0xd69e89e0  ! 2376: LDDA_R	ldda	[%r26, %r0] 0x4f, %r11
	.word 0xdaaca000  ! 2377: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0xd0bf8e80  ! 2378: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	mov	0x48, %r18
	.word 0xd4b4e000  ! 2380: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xd4f4a000  ! 2381: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0xde8f4e80  ! 2382: LDUBA_R	lduba	[%r29, %r0] 0x74, %r15
	.word 0xd68f8e40  ! 2383: LDUBA_R	lduba	[%r30, %r0] 0x72, %r11
	mov	0x3e0, %r23
	.word 0xd29f8e80  ! 2385: LDDA_R	ldda	[%r30, %r0] 0x74, %r9
	mov	0x3e8, %r22
	mov	0x68, %r26
	.word 0xd88609e0  ! 2388: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r12
	.word 0x87802072  ! 2389: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f8, %r23
	.word 0x87802020  ! 2391: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r21
	mov	0x0, %r19
	.word 0xd4dfa000  ! 2394: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4b689e0  ! 2395: STHA_R	stha	%r10, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 2396: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 2397: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b7a000  ! 2398: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 2399: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bd6000  ! 2400: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd285e000  ! 2402: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r9
	.word 0xd4f70e80  ! 2403: STXA_R	stxa	%r10, [%r28 + %r0] 0x74
	mov	0x70, %r27
	.word 0xd08de000  ! 2405: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r8
	.word 0xdac4c400  ! 2406: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r13
	mov	0x20, %r26
	.word 0xdaacc400  ! 2408: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0xd6ac8400  ! 2409: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xd88da000  ! 2410: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r12
	.word 0xd6cd44a0  ! 2411: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r11
	mov	0x38, %r27
	.word 0xdea56000  ! 2413: STWA_I	stwa	%r15, [%r21 + 0x0000] %asi
	mov	0x20, %r24
	.word 0xd0af0e60  ! 2415: STBA_R	stba	%r8, [%r28 + %r0] 0x73
	.word 0xd8a4c400  ! 2416: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	mov	0x58, %r27
	.word 0x87802020  ! 2418: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r18
	.word 0xd6afce60  ! 2420: STBA_R	stba	%r11, [%r31 + %r0] 0x73
	mov	0x60, %r18
	.word 0xde942000  ! 2422: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	.word 0xdeac2000  ! 2423: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xdeb7ce40  ! 2424: STHA_R	stha	%r15, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 2425: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c8, %r22
	.word 0xdac4a000  ! 2427: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	.word 0x87802025  ! 2428: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d0, %r23
	mov	0x3f0, %r23
	.word 0xdc9cc400  ! 2431: LDDA_R	ldda	[%r19, %r0] 0x20, %r14
	.word 0xdebfe000  ! 2432: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xdef72000  ! 2433: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 2434: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 2435: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r16
	.word 0x87802072  ! 2437: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 2438: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r27
	.word 0x87802073  ! 2440: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdebfe000  ! 2441: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xd2a70e60  ! 2442: STWA_R	stwa	%r9, [%r28 + %r0] 0x73
	.word 0x87802072  ! 2443: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r26
	.word 0xd69f0e80  ! 2445: LDDA_R	ldda	[%r28, %r0] 0x74, %r11
	.word 0xdeace000  ! 2446: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xd2dcc400  ! 2447: LDXA_R	ldxa	[%r19, %r0] 0x20, %r9
	.word 0xd48584a0  ! 2448: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r10
	.word 0xd8bce000  ! 2449: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd2b40400  ! 2450: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	mov	0x70, %r25
	mov	0x78, %r26
	.word 0xd2b4a000  ! 2453: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 2454: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2455: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r25
	.word 0x87802072  ! 2457: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 2458: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2d7e000  ! 2459: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xde8c8400  ! 2460: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	.word 0xd4ac0400  ! 2461: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xda87e000  ! 2462: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	mov	0x0, %r24
	.word 0xdab7a000  ! 2464: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xd8b649e0  ! 2465: STHA_R	stha	%r12, [%r25 + %r0] 0x4f
	mov	0x7c8, %r20
	mov	0x18, %r17
	.word 0x87802073  ! 2468: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda8de000  ! 2469: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r13
	.word 0xdeb649e0  ! 2470: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	.word 0xd29de000  ! 2471: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r9
	.word 0xdcaf0e80  ! 2472: STBA_R	stba	%r14, [%r28 + %r0] 0x74
	.word 0xdadc0400  ! 2473: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	.word 0xdcac8400  ! 2474: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xd2874e60  ! 2475: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r9
	.word 0x87802025  ! 2476: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2477: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b74e80  ! 2478: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	.word 0xd4d76000  ! 2479: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	mov	0x0, %r24
	mov	0x60, %r17
	.word 0xd6cc4400  ! 2482: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	.word 0xda972000  ! 2483: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0xdcf78e60  ! 2484: STXA_R	stxa	%r14, [%r30 + %r0] 0x73
	.word 0xdabf6000  ! 2485: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 2486: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6bf4e40  ! 2487: STDA_R	stda	%r11, [%r29 + %r0] 0x72
	.word 0xd4dc6000  ! 2488: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	.word 0xd4a4a000  ! 2489: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xd4b74e40  ! 2490: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	mov	0x18, %r18
	.word 0xd0c7ce80  ! 2492: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r8
	mov	0x40, %r19
	.word 0xd0842000  ! 2494: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r8
	.word 0xdcd609e0  ! 2495: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r14
	.word 0xd2ae89e0  ! 2496: STBA_R	stba	%r9, [%r26 + %r0] 0x4f
	.word 0xde8ce000  ! 2497: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	.word 0xd8d40400  ! 2498: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	mov	0x20, %r17
	.word 0x87802073  ! 2500: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r18
	.word 0xd2df2000  ! 2502: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2503: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c72000  ! 2504: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2505: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcdcc400  ! 2506: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	.word 0xd6d689e0  ! 2507: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r11
	mov	0x58, %r24
	.word 0xdca5a000  ! 2509: STWA_I	stwa	%r14, [%r22 + 0x0000] %asi
	mov	0x7e0, %r22
	.word 0xd0dcc400  ! 2511: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0x87802073  ! 2512: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r16
	.word 0xdeb66000  ! 2514: STHA_I	stha	%r15, [%r25 + 0x0000] %asi
	mov	0x70, %r27
	.word 0xd2f70e80  ! 2516: STXA_R	stxa	%r9, [%r28 + %r0] 0x74
	mov	0x78, %r26
	.word 0xdcbee000  ! 2518: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	.word 0xd6b504a0  ! 2519: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	.word 0xdcb5c4a0  ! 2520: STHA_R	stha	%r14, [%r23 + %r0] 0x25
	mov	0x78, %r16
	.word 0xd89649e0  ! 2522: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r12
	.word 0xdab48400  ! 2523: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	mov	0x0, %r26
	mov	0x7c0, %r22
	.word 0x87802025  ! 2526: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca72000  ! 2527: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdccf2000  ! 2528: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xdca7a000  ! 2529: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcbfa000  ! 2530: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	mov	0x60, %r17
	.word 0x87802074  ! 2532: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2533: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0c6c9e0  ! 2534: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r8
	.word 0x87802074  ! 2535: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2536: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6dca000  ! 2537: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r11
	.word 0xd6a46000  ! 2538: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0xd6978e80  ! 2539: LDUHA_R	lduha	[%r30, %r0] 0x74, %r11
	.word 0xdaa4a000  ! 2540: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 2541: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef74e40  ! 2542: STXA_R	stxa	%r15, [%r29 + %r0] 0x72
	.word 0xda9f2000  ! 2543: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xdebc8400  ! 2544: STDA_R	stda	%r15, [%r18 + %r0] 0x20
	mov	0x30, %r27
	.word 0x87802025  ! 2546: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd48cc400  ! 2547: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	.word 0xdcdce000  ! 2548: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r14
	.word 0xdcb4e000  ! 2549: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xd095c4a0  ! 2550: LDUHA_R	lduha	[%r23, %r0] 0x25, %r8
	.word 0xd2d4a000  ! 2551: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2552: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda8c0400  ! 2553: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	.word 0xd2848400  ! 2554: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r9
	.word 0xd0bc4400  ! 2555: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 2556: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8f72000  ! 2557: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8bec9e0  ! 2558: STDA_R	stda	%r12, [%r27 + %r0] 0x4f
	.word 0xd496c9e0  ! 2559: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r10
	.word 0xd6af2000  ! 2560: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 2561: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 2562: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2563: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f7ce40  ! 2564: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	.word 0xdef70e40  ! 2565: STXA_R	stxa	%r15, [%r28 + %r0] 0x72
	.word 0x87802020  ! 2566: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r19
	.word 0xd0c7e000  ! 2568: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0xd8b78e40  ! 2569: STHA_R	stha	%r12, [%r30 + %r0] 0x72
	.word 0xd4d76000  ! 2570: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0xdace09e0  ! 2571: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r13
	.word 0xd2df6000  ! 2572: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2b76000  ! 2573: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xdecc4400  ! 2574: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r15
	.word 0xd0b7e000  ! 2575: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 2576: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0852000  ! 2577: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r8
	mov	0x3d0, %r22
	mov	0x60, %r16
	mov	0x10, %r26
	.word 0xd0852000  ! 2581: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r8
	.word 0xd08d6000  ! 2582: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r8
	.word 0xdaa584a0  ! 2583: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	.word 0xd2f70e80  ! 2584: STXA_R	stxa	%r9, [%r28 + %r0] 0x74
	.word 0xdcb48400  ! 2585: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	mov	0x7d0, %r22
	.word 0xdcd5c4a0  ! 2587: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r14
	.word 0xd8f52000  ! 2588: STXA_I	stxa	%r12, [%r20 + 0x0000] %asi
	.word 0xd8bc4400  ! 2589: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0x87802074  ! 2590: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r19
	.word 0x8780204f  ! 2592: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde8f2000  ! 2593: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0x87802020  ! 2594: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2595: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2596: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r19
	.word 0x87802025  ! 2598: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6cfce40  ! 2599: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r11
	.word 0xd2b62000  ! 2600: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 2601: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2602: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdebd44a0  ! 2603: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	.word 0xd2f7ce60  ! 2604: STXA_R	stxa	%r9, [%r31 + %r0] 0x73
	mov	0x28, %r26
	mov	0x48, %r25
	.word 0xdcf7a000  ! 2607: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x3d8, %r21
	.word 0xdcc76000  ! 2609: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xdcc72000  ! 2610: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	mov	0x3d8, %r22
	.word 0xd6a78e60  ! 2612: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0xd2f7e000  ! 2613: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2614: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r22
	mov	0x7d0, %r21
	.word 0xd4f504a0  ! 2617: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0xd0a74e40  ! 2618: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	mov	0x30, %r25
	.word 0xd6ae2000  ! 2620: STBA_I	stba	%r11, [%r24 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x70, %r16
	.word 0xd6ae2000  ! 2623: STBA_I	stba	%r11, [%r24 + 0x0000] %asi
	.word 0xd6962000  ! 2624: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r11
	.word 0xd6f6a000  ! 2625: STXA_I	stxa	%r11, [%r26 + 0x0000] %asi
	.word 0xd89c0400  ! 2626: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	.word 0xd2ae2000  ! 2627: STBA_I	stba	%r9, [%r24 + 0x0000] %asi
	.word 0xd88f8e60  ! 2628: LDUBA_R	lduba	[%r30, %r0] 0x73, %r12
	.word 0xd8f66000  ! 2629: STXA_I	stxa	%r12, [%r25 + 0x0000] %asi
	.word 0xd28609e0  ! 2630: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r9
	mov	0x50, %r16
	.word 0xd8a40400  ! 2632: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0x87802020  ! 2633: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r26
	mov	0x7d8, %r22
	.word 0x8780204f  ! 2636: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdccec9e0  ! 2637: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r14
	.word 0xd8aee000  ! 2638: STBA_I	stba	%r12, [%r27 + 0x0000] %asi
	.word 0xd8b66000  ! 2639: STHA_I	stha	%r12, [%r25 + 0x0000] %asi
	mov	0x3f8, %r23
	.word 0xd2af4e60  ! 2641: STBA_R	stba	%r9, [%r29 + %r0] 0x73
	.word 0xdc86e000  ! 2642: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 2643: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc942000  ! 2644: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	.word 0xd0a44400  ! 2645: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xd4dd84a0  ! 2646: LDXA_R	ldxa	[%r22, %r0] 0x25, %r10
	.word 0x87802020  ! 2647: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebc2000  ! 2648: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xdea42000  ! 2649: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xdaa4c400  ! 2650: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0xd6a74e60  ! 2651: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	.word 0x87802025  ! 2652: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2d46000  ! 2653: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	.word 0xd48e89e0  ! 2654: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r10
	mov	0x3c8, %r23
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0d6c9e0  ! 2657: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r8
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdcd544a0  ! 2659: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r14
	.word 0xd6ace000  ! 2660: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0xd2b7ce80  ! 2661: STHA_R	stha	%r9, [%r31 + %r0] 0x74
	.word 0xdc9f4e80  ! 2662: LDDA_R	ldda	[%r29, %r0] 0x74, %r14
	.word 0xdcf4e000  ! 2663: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xdca504a0  ! 2664: STWA_R	stwa	%r14, [%r20 + %r0] 0x25
	mov	0x28, %r26
	.word 0xd08ce000  ! 2666: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xdef44400  ! 2667: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xdc942000  ! 2668: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	mov	0x70, %r19
	.word 0xd49d04a0  ! 2670: LDDA_R	ldda	[%r20, %r0] 0x25, %r10
	.word 0xd48ca000  ! 2671: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r10
	.word 0xdea5c4a0  ! 2672: STWA_R	stwa	%r15, [%r23 + %r0] 0x25
	.word 0xd6b4c400  ! 2673: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0x87802020  ! 2674: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49609e0  ! 2675: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r10
	.word 0x87802020  ! 2676: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f5c4a0  ! 2677: STXA_R	stxa	%r9, [%r23 + %r0] 0x25
	.word 0xd8d6c9e0  ! 2678: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r12
	.word 0xd68f0e80  ! 2679: LDUBA_R	lduba	[%r28, %r0] 0x74, %r11
	.word 0x87802020  ! 2680: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad46000  ! 2681: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	mov	0x58, %r27
	.word 0xd2d44400  ! 2683: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r9
	.word 0xdad46000  ! 2684: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 2685: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda942000  ! 2686: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0xdad4e000  ! 2687: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r13
	mov	0x7d0, %r21
	.word 0xdabc2000  ! 2689: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	mov	0x18, %r16
	mov	0x30, %r27
	mov	0x8, %r17
	.word 0x87802074  ! 2693: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdadfa000  ! 2694: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xd0878e60  ! 2695: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r8
	.word 0xd0876000  ! 2696: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0972000  ! 2697: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0d7a000  ! 2698: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 2699: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x0, %r24
	mov	0x7f8, %r23
	mov	0x8, %r17
	.word 0xd0bce000  ! 2703: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0xd0bc2000  ! 2704: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	mov	0x50, %r16
	.word 0xd0f42000  ! 2706: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	mov	0x7f0, %r21
	.word 0xd0bc2000  ! 2708: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	mov	0x10, %r26
	.word 0xd0a4e000  ! 2710: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xda8609e0  ! 2711: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r13
	mov	0x40, %r25
	.word 0xdcf4a000  ! 2713: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 2714: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f0, %r20
	mov	0x60, %r19
	.word 0x87802025  ! 2717: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 2718: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r18
	mov	0x50, %r16
	.word 0x87802020  ! 2721: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2722: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6dd44a0  ! 2723: LDXA_R	ldxa	[%r21, %r0] 0x25, %r11
	.word 0xdab4a000  ! 2724: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0xd8f7ce40  ! 2725: STXA_R	stxa	%r12, [%r31 + %r0] 0x72
	.word 0xd6c78e60  ! 2726: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r11
	mov	0x10, %r19
	.word 0x87802072  ! 2728: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c8, %r21
	.word 0xdaf72000  ! 2730: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdac76000  ! 2731: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	mov	0x7e0, %r22
	mov	0x8, %r17
	.word 0xdacf6000  ! 2734: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0x87802072  ! 2735: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r26
	.word 0x87802020  ! 2737: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r22
	.word 0xde8f8e40  ! 2739: LDUBA_R	lduba	[%r30, %r0] 0x72, %r15
	.word 0xd4978e60  ! 2740: LDUHA_R	lduha	[%r30, %r0] 0x73, %r10
	.word 0xd0b46000  ! 2741: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	mov	0x38, %r26
	.word 0xd0aca000  ! 2743: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	mov	0x20, %r27
	.word 0x87802020  ! 2745: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09fe000  ! 2746: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	mov	0x3d8, %r20
	.word 0xd0c72000  ! 2748: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	mov	0x40, %r24
	.word 0xd6b4c400  ! 2750: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	mov	0x58, %r16
	.word 0xd69fe000  ! 2752: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	.word 0xd8a70e80  ! 2753: STWA_R	stwa	%r12, [%r28 + %r0] 0x74
	mov	0x60, %r17
	.word 0xd6bc8400  ! 2755: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0x87802074  ! 2756: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b7e000  ! 2757: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xdeae89e0  ! 2758: STBA_R	stba	%r15, [%r26 + %r0] 0x4f
	.word 0xdc8fa000  ! 2759: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdccf2000  ! 2760: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xdcdf2000  ! 2761: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xd68609e0  ! 2762: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r11
	mov	0x3e0, %r23
	.word 0xdab72000  ! 2764: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdab76000  ! 2765: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 2766: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2767: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2768: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r25
	.word 0xd4a649e0  ! 2770: STWA_R	stwa	%r10, [%r25 + %r0] 0x4f
	mov	0x60, %r17
	.word 0xd2af6000  ! 2772: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 2773: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r19
	.word 0xd2ace000  ! 2775: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0xdcf6c9e0  ! 2777: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	mov	0x0, %r16
	.word 0x87802020  ! 2779: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2780: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad62000  ! 2781: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r13
	.word 0xdabe6000  ! 2782: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	.word 0xdaf66000  ! 2783: STXA_I	stxa	%r13, [%r25 + 0x0000] %asi
	mov	0x50, %r27
	.word 0xda9e6000  ! 2785: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 2786: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 2787: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda96e000  ! 2788: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r13
	.word 0xda9e2000  ! 2789: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r13
	mov	0x60, %r24
	mov	0x3f8, %r21
	.word 0xdaaf8e60  ! 2792: STBA_R	stba	%r13, [%r30 + %r0] 0x73
	mov	0x3d0, %r20
	mov	0x10, %r25
	.word 0xdedea000  ! 2795: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r15
	.word 0xd88d44a0  ! 2796: LDUBA_R	lduba	[%r21, %r0] 0x25, %r12
	mov	0x3e0, %r21
	.word 0xdcd609e0  ! 2798: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r14
	.word 0xd6ce2000  ! 2799: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	mov	0x28, %r16
	.word 0x87802072  ! 2801: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b5e000  ! 2802: STHA_I	stha	%r11, [%r23 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xdeb6c9e0  ! 2804: STHA_R	stha	%r15, [%r27 + %r0] 0x4f
	.word 0xd8956000  ! 2805: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r12
	.word 0xd8c5e000  ! 2806: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 2807: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e0, %r23
	.word 0xdaaf4e40  ! 2809: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	.word 0xdaaea000  ! 2810: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	mov	0x58, %r24
	.word 0xdabee000  ! 2812: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0x87802020  ! 2814: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac4e000  ! 2815: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r13
	.word 0xdabe09e0  ! 2816: STDA_R	stda	%r13, [%r24 + %r0] 0x4f
	.word 0xd6874e40  ! 2817: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r11
	.word 0xd8a4c400  ! 2818: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0x87802020  ! 2819: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r16
	.word 0xd2b72000  ! 2821: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd2d7e000  ! 2822: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xd29cc400  ! 2823: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	.word 0xd2974e60  ! 2824: LDUHA_R	lduha	[%r29, %r0] 0x73, %r9
	.word 0xd0f584a0  ! 2825: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	.word 0xd6be49e0  ! 2826: STDA_R	stda	%r11, [%r25 + %r0] 0x4f
	.word 0xd8dfa000  ! 2827: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8c7e000  ! 2828: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0xd0a689e0  ! 2829: STWA_R	stwa	%r8, [%r26 + %r0] 0x4f
	.word 0xdeaf2000  ! 2830: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xdef72000  ! 2831: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xdec76000  ! 2832: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xd8acc400  ! 2833: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0xd48d04a0  ! 2834: LDUBA_R	lduba	[%r20, %r0] 0x25, %r10
	.word 0xdacfa000  ! 2835: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	mov	0x58, %r18
	.word 0xda8c4400  ! 2837: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	mov	0x78, %r18
	.word 0xd4b7ce60  ! 2839: STHA_R	stha	%r10, [%r31 + %r0] 0x73
	.word 0xdef7e000  ! 2840: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xde97e000  ! 2841: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0xdedd44a0  ! 2842: LDXA_R	ldxa	[%r21, %r0] 0x25, %r15
	mov	0x10, %r17
	.word 0xd0b649e0  ! 2844: STHA_R	stha	%r8, [%r25 + %r0] 0x4f
	mov	0x3c0, %r23
	.word 0xda8f2000  ! 2846: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xd097ce60  ! 2847: LDUHA_R	lduha	[%r31, %r0] 0x73, %r8
	mov	0x58, %r19
	.word 0xdcb70e80  ! 2849: STHA_R	stha	%r14, [%r28 + %r0] 0x74
	mov	0x78, %r16
	.word 0xdaa44400  ! 2851: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0xded7a000  ! 2852: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	mov	0x28, %r19
	.word 0xdcc7ce60  ! 2854: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r14
	.word 0xdef7a000  ! 2855: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	mov	0x7e8, %r22
	mov	0x38, %r26
	.word 0xd08d04a0  ! 2858: LDUBA_R	lduba	[%r20, %r0] 0x25, %r8
	.word 0xdead44a0  ! 2859: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	mov	0x3c0, %r22
	.word 0xd4bf2000  ! 2861: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd4f7e000  ! 2862: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xd29f4e80  ! 2863: LDDA_R	ldda	[%r29, %r0] 0x74, %r9
	.word 0xd8df2000  ! 2864: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	mov	0x7c0, %r21
	.word 0xde840400  ! 2866: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	.word 0xda8fa000  ! 2867: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	mov	0x8, %r27
	.word 0xdaaf2000  ! 2869: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	mov	0x78, %r25
	.word 0xdaf7a000  ! 2871: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdac7a000  ! 2872: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	mov	0x3c8, %r21
	.word 0xd8b689e0  ! 2874: STHA_R	stha	%r12, [%r26 + %r0] 0x4f
	mov	0x78, %r24
	.word 0xd4bfe000  ! 2876: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd4ac8400  ! 2877: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	mov	0x10, %r24
	.word 0x87802020  ! 2879: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b4e000  ! 2880: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0xd8afce40  ! 2881: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	.word 0x87802073  ! 2882: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0c4a000  ! 2883: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	.word 0xdebf4e60  ! 2884: STDA_R	stda	%r15, [%r29 + %r0] 0x73
	mov	0x30, %r16
	.word 0xd8b4a000  ! 2886: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0xdab44400  ! 2887: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0xd49e89e0  ! 2888: LDDA_R	ldda	[%r26, %r0] 0x4f, %r10
	.word 0xdc848400  ! 2889: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	.word 0x8780204f  ! 2890: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4c76000  ! 2891: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	.word 0xd8a74e80  ! 2892: STWA_R	stwa	%r12, [%r29 + %r0] 0x74
	.word 0x87802020  ! 2893: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2894: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0974e40  ! 2895: LDUHA_R	lduha	[%r29, %r0] 0x72, %r8
	.word 0x87802072  ! 2896: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 2897: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbca000  ! 2898: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdc8c6000  ! 2899: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r14
	.word 0x87802072  ! 2900: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d0, %r22
	.word 0xd2b48400  ! 2902: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	mov	0x3c8, %r20
	mov	0x78, %r27
	.word 0x87802020  ! 2905: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeaca000  ! 2906: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xd2a649e0  ! 2907: STWA_R	stwa	%r9, [%r25 + %r0] 0x4f
	.word 0xdc9c2000  ! 2908: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r14
	mov	0x30, %r24
	.word 0x87802073  ! 2910: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d8, %r23
	.word 0xdcd62000  ! 2912: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r14
	.word 0xdcae6000  ! 2913: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	.word 0x8780204f  ! 2914: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f78e40  ! 2915: STXA_R	stxa	%r8, [%r30 + %r0] 0x72
	.word 0xd2d6a000  ! 2916: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r9
	.word 0xd28e2000  ! 2917: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	.word 0xd2f66000  ! 2918: STXA_I	stxa	%r9, [%r25 + 0x0000] %asi
	.word 0xd2cea000  ! 2919: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r9
	.word 0x87802073  ! 2920: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r16
	.word 0x87802020  ! 2922: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd287e000  ! 2923: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 2924: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeaec9e0  ! 2925: STBA_R	stba	%r15, [%r27 + %r0] 0x4f
	.word 0xd2ac8400  ! 2926: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xdcf42000  ! 2927: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0xd8f7ce80  ! 2928: STXA_R	stxa	%r12, [%r31 + %r0] 0x74
	.word 0xdc8f8e60  ! 2929: LDUBA_R	lduba	[%r30, %r0] 0x73, %r14
	mov	0x48, %r18
	.word 0xd0a74e60  ! 2931: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	mov	0x20, %r17
	.word 0x87802020  ! 2933: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b76000  ! 2934: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0xd2f72000  ! 2936: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	mov	0x30, %r16
	mov	0x3c0, %r23
	.word 0x87802074  ! 2939: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f78e40  ! 2940: STXA_R	stxa	%r10, [%r30 + %r0] 0x72
	mov	0x20, %r27
	mov	0x7e8, %r20
	mov	0x40, %r25
	.word 0x87802074  ! 2944: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c8, %r20
	.word 0xdc8d2000  ! 2946: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r14
	.word 0xd0874e80  ! 2947: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r8
	.word 0xd6c5a000  ! 2948: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r11
	.word 0xd6a544a0  ! 2949: STWA_R	stwa	%r11, [%r21 + %r0] 0x25
	.word 0xd4dd6000  ! 2950: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r10
	.word 0xd6d74e80  ! 2951: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r11
	mov	0x18, %r26
	.word 0xdcb504a0  ! 2953: STHA_R	stha	%r14, [%r20 + %r0] 0x25
	mov	0x50, %r19
	.word 0xd6d40400  ! 2955: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	.word 0xd2b5e000  ! 2956: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	mov	0x20, %r27
	.word 0x87802020  ! 2958: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a7ce40  ! 2959: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	.word 0xd08ec9e0  ! 2960: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r8
	.word 0xd4ac4400  ! 2961: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xdeae6000  ! 2962: STBA_I	stba	%r15, [%r25 + 0x0000] %asi
	.word 0xdc9d84a0  ! 2963: LDDA_R	ldda	[%r22, %r0] 0x25, %r14
	.word 0xd2b66000  ! 2964: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	.word 0xd2de2000  ! 2965: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r9
	.word 0xd29e6000  ! 2966: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2967: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c0, %r21
	.word 0xd2a52000  ! 2969: STWA_I	stwa	%r9, [%r20 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd4af4e60  ! 2971: STBA_R	stba	%r10, [%r29 + %r0] 0x73
	.word 0xdaf7ce60  ! 2972: STXA_R	stxa	%r13, [%r31 + %r0] 0x73
	.word 0xd8b56000  ! 2973: STHA_I	stha	%r12, [%r21 + 0x0000] %asi
	.word 0xd89d6000  ! 2974: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r12
	mov	0x10, %r24
	.word 0xd8b56000  ! 2976: STHA_I	stha	%r12, [%r21 + 0x0000] %asi
	mov	0x3d8, %r20
	mov	0x0, %r18
	.word 0x87802025  ! 2979: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd89ce000  ! 2980: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	.word 0xd8aca000  ! 2981: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0xd8b42000  ! 2982: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 2983: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2984: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf40400  ! 2985: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	mov	0x3e0, %r23
	.word 0xd8c56000  ! 2987: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r12
	.word 0xd2cf0e40  ! 2988: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r9
	.word 0xd6f78e60  ! 2989: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	mov	0x3e0, %r21
	.word 0xdc8d2000  ! 2991: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r14
	.word 0xdcbda000  ! 2992: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	.word 0xd4dfce40  ! 2993: LDXA_R	ldxa	[%r31, %r0] 0x72, %r10
	mov	0x7f0, %r20
	.word 0xdaf78e80  ! 2995: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	.word 0x8780204f  ! 2996: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdab72000  ! 2997: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdab72000  ! 2998: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdaa76000  ! 2999: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xdec70e60  ! 3000: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r15
	.word 0xd6df6000  ! 3001: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0xd68fe000  ! 3002: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3003: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdede09e0  ! 3004: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r15
	.word 0xdef7a000  ! 3005: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	mov	0x10, %r27
	.word 0xde8fe000  ! 3007: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	mov	0x7e0, %r22
	.word 0xdef76000  ! 3009: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdea7e000  ! 3010: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	mov	0x38, %r17
	.word 0x8780204f  ! 3012: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdab584a0  ! 3013: STHA_R	stha	%r13, [%r22 + %r0] 0x25
	.word 0x87802020  ! 3014: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r24
	.word 0xdcbfe000  ! 3016: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 3017: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf74e60  ! 3018: STXA_R	stxa	%r13, [%r29 + %r0] 0x73
	.word 0xdccf0e60  ! 3019: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r14
	mov	0x68, %r25
	.word 0xd2f44400  ! 3021: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	.word 0x87802020  ! 3022: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb76000  ! 3023: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xdc976000  ! 3024: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	mov	0x60, %r24
	.word 0xd0dc8400  ! 3026: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0x87802074  ! 3027: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0ac6000  ! 3028: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0xde9cc400  ! 3029: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	.word 0xd2f78e60  ! 3030: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	mov	0x20, %r18
	.word 0xdcbfce60  ! 3032: STDA_R	stda	%r14, [%r31 + %r0] 0x73
	.word 0xd4846000  ! 3033: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r10
	mov	0x68, %r16
	.word 0xd2bfce60  ! 3035: STDA_R	stda	%r9, [%r31 + %r0] 0x73
	.word 0xd8848400  ! 3036: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r12
	.word 0xd094e000  ! 3037: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 3038: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x48, %r25
	.word 0xdab44400  ! 3040: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	mov	0x3f8, %r23
	.word 0xd88689e0  ! 3042: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r12
	.word 0x87802020  ! 3043: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d7e000  ! 3044: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	.word 0xdec44400  ! 3045: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	mov	0x28, %r18
	mov	0x68, %r17
	mov	0x3e0, %r20
	.word 0x87802020  ! 3049: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bfe000  ! 3050: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd8bf6000  ! 3051: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd8b76000  ! 3052: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	mov	0x50, %r18
	.word 0xd09f8e80  ! 3054: LDDA_R	ldda	[%r30, %r0] 0x74, %r8
	.word 0xd6bfa000  ! 3055: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3056: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r19
	mov	0x78, %r27
	.word 0xd6ac6000  ! 3059: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 3060: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 3061: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d8, %r20
	.word 0xd2be09e0  ! 3063: STDA_R	stda	%r9, [%r24 + %r0] 0x4f
	.word 0xdab40400  ! 3064: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xdab70e80  ! 3065: STHA_R	stha	%r13, [%r28 + %r0] 0x74
	.word 0xdabf0e60  ! 3066: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	.word 0x87802072  ! 3067: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3068: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bc4400  ! 3069: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0xd8bcc400  ! 3070: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0xdaf4a000  ! 3071: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 3072: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcaf0e60  ! 3073: STBA_R	stba	%r14, [%r28 + %r0] 0x73
	.word 0xdeb44400  ! 3074: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0xd6dc4400  ! 3075: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xd8b70e80  ! 3076: STHA_R	stha	%r12, [%r28 + %r0] 0x74
	.word 0xdef4c400  ! 3077: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0x87802020  ! 3078: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c44400  ! 3079: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r10
	.word 0xd2866000  ! 3080: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r9
	mov	0x3d0, %r23
	.word 0xd2a62000  ! 3082: STWA_I	stwa	%r9, [%r24 + 0x0000] %asi
	.word 0xdad4c400  ! 3083: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xd0de6000  ! 3084: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 3085: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d0, %r20
	.word 0xdc944400  ! 3087: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	.word 0xdaf52000  ! 3088: STXA_I	stxa	%r13, [%r20 + 0x0000] %asi
	mov	0x70, %r25
	.word 0xda8d2000  ! 3090: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r13
	.word 0xded584a0  ! 3091: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r15
	.word 0xdaa584a0  ! 3092: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	.word 0xd8b5a000  ! 3093: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	.word 0xd88da000  ! 3094: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r12
	.word 0xd2de09e0  ! 3095: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r9
	.word 0xd4a48400  ! 3096: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xdcdfce60  ! 3097: LDXA_R	ldxa	[%r31, %r0] 0x73, %r14
	.word 0xd2afce60  ! 3098: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	.word 0xd6f5a000  ! 3099: STXA_I	stxa	%r11, [%r22 + 0x0000] %asi
	.word 0xd68f8e80  ! 3100: LDUBA_R	lduba	[%r30, %r0] 0x74, %r11
	mov	0x3d0, %r22
	mov	0x30, %r25
	.word 0xda8c8400  ! 3103: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	.word 0xd0cc0400  ! 3104: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xdca649e0  ! 3105: STWA_R	stwa	%r14, [%r25 + %r0] 0x4f
	mov	0x68, %r18
	mov	0x3d8, %r20
	.word 0xd6b4c400  ! 3108: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xd2a56000  ! 3109: STWA_I	stwa	%r9, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 3110: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r25
	.word 0xd8df4e80  ! 3112: LDXA_R	ldxa	[%r29, %r0] 0x74, %r12
	mov	0x7d0, %r21
	.word 0xd2b78e40  ! 3114: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	.word 0xd08d2000  ! 3115: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r8
	.word 0xdadc8400  ! 3116: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	.word 0x87802025  ! 3117: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6ac0400  ! 3118: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0xd6f4e000  ! 3119: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 3120: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6bf6000  ! 3121: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd6c76000  ! 3122: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6b76000  ! 3123: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 3124: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4c7ce80  ! 3125: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r10
	.word 0xd28ce000  ! 3126: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	.word 0xd2cce000  ! 3127: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	.word 0xdcf544a0  ! 3128: STXA_R	stxa	%r14, [%r21 + %r0] 0x25
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x60, %r24
	mov	0x8, %r27
	.word 0xde9ce000  ! 3132: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	mov	0x38, %r17
	.word 0xdc9f0e80  ! 3134: LDDA_R	ldda	[%r28, %r0] 0x74, %r14
	mov	0x68, %r18
	mov	0x7f8, %r23
	mov	0x3e0, %r20
	.word 0xd0f4a000  ! 3138: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xdcbf8e80  ! 3139: STDA_R	stda	%r14, [%r30 + %r0] 0x74
	.word 0x87802020  ! 3140: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadfce60  ! 3141: LDXA_R	ldxa	[%r31, %r0] 0x73, %r13
	.word 0xd885c4a0  ! 3142: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r12
	.word 0xd8bc6000  ! 3143: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0xd8ac6000  ! 3144: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	mov	0x3c0, %r20
	.word 0xdcaf4e80  ! 3146: STBA_R	stba	%r14, [%r29 + %r0] 0x74
	mov	0x28, %r19
	.word 0xdecca000  ! 3148: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	.word 0xde8ca000  ! 3149: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0x87802072  ! 3150: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3151: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bf4e80  ! 3152: STDA_R	stda	%r12, [%r29 + %r0] 0x74
	.word 0xd28c8400  ! 3153: LDUBA_R	lduba	[%r18, %r0] 0x20, %r9
	mov	0x7c0, %r20
	.word 0xd2dfce40  ! 3155: LDXA_R	ldxa	[%r31, %r0] 0x72, %r9
	.word 0x8780204f  ! 3156: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e0, %r22
	.word 0xd4cee000  ! 3158: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r10
	.word 0xdccf0e80  ! 3159: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r14
	.word 0xdeae6000  ! 3160: STBA_I	stba	%r15, [%r25 + 0x0000] %asi
	.word 0xde9ea000  ! 3161: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r15
	.word 0xdec6a000  ! 3162: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r15
	.word 0xdeaea000  ! 3163: STBA_I	stba	%r15, [%r26 + 0x0000] %asi
	.word 0xd2df8e40  ! 3164: LDXA_R	ldxa	[%r30, %r0] 0x72, %r9
	mov	0x20, %r19
	.word 0xd49ea000  ! 3166: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	mov	0x3d8, %r23
	mov	0x3d8, %r22
	.word 0xd48ea000  ! 3169: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r10
	.word 0xd4ae6000  ! 3170: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	mov	0x68, %r26
	.word 0x87802073  ! 3172: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 3173: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r17
	.word 0xd4cc6000  ! 3175: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	.word 0xdc9e89e0  ! 3176: LDDA_R	ldda	[%r26, %r0] 0x4f, %r14
	.word 0xd4cc2000  ! 3177: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	mov	0x7d8, %r21
	.word 0x87802073  ! 3179: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 3180: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2d78e80  ! 3181: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r9
	mov	0x8, %r19
	.word 0xdadfe000  ! 3183: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0xd88ec9e0  ! 3184: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r12
	.word 0xd0b40400  ! 3185: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0x87802025  ! 3186: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f78e40  ! 3187: STXA_R	stxa	%r8, [%r30 + %r0] 0x72
	mov	0x7f0, %r23
	.word 0xd8bfa000  ! 3189: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 3190: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0cfce40  ! 3192: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r8
	mov	0x58, %r27
	.word 0xd697ce40  ! 3194: LDUHA_R	lduha	[%r31, %r0] 0x72, %r11
	.word 0xdeaf8e60  ! 3195: STBA_R	stba	%r15, [%r30 + %r0] 0x73
	.word 0xdc8e2000  ! 3196: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r14
	.word 0xdcc584a0  ! 3197: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r14
	.word 0x87802025  ! 3198: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e8, %r23
	mov	0x0, %r24
	.word 0xd2b72000  ! 3201: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd4bf8e60  ! 3202: STDA_R	stda	%r10, [%r30 + %r0] 0x73
	.word 0x87802020  ! 3203: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b56000  ! 3204: STHA_I	stha	%r9, [%r21 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xd8d74e80  ! 3206: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r12
	mov	0x50, %r27
	.word 0x87802025  ! 3208: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebf6000  ! 3209: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0xde9fa000  ! 3211: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	.word 0xd09ec9e0  ! 3212: LDDA_R	ldda	[%r27, %r0] 0x4f, %r8
	.word 0xd09fce40  ! 3213: LDDA_R	ldda	[%r31, %r0] 0x72, %r8
	mov	0x7c8, %r23
	.word 0xd88c4400  ! 3215: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0xd4a44400  ! 3216: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xd8c7ce40  ! 3217: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r12
	.word 0x87802072  ! 3218: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f0, %r22
	mov	0x3c0, %r22
	.word 0xd2d584a0  ! 3221: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r9
	.word 0xd2bc2000  ! 3222: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xd2a4a000  ! 3223: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	mov	0x3c8, %r20
	.word 0xd2f4a000  ! 3225: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0xd8ad04a0  ! 3226: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	.word 0xd8df0e40  ! 3227: LDXA_R	ldxa	[%r28, %r0] 0x72, %r12
	.word 0xd2a42000  ! 3228: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	mov	0x10, %r19
	.word 0xdea44400  ! 3230: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	mov	0x48, %r27
	.word 0xdccca000  ! 3232: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	.word 0xd2978e80  ! 3233: LDUHA_R	lduha	[%r30, %r0] 0x74, %r9
	.word 0xd48c6000  ! 3234: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r10
	.word 0xd4d42000  ! 3235: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	.word 0xd09d44a0  ! 3236: LDDA_R	ldda	[%r21, %r0] 0x25, %r8
	.word 0x87802073  ! 3237: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r16
	mov	0x20, %r25
	.word 0xd4b6c9e0  ! 3240: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0xd29d6000  ! 3241: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r9
	.word 0xd2b5a000  ! 3242: STHA_I	stha	%r9, [%r22 + 0x0000] %asi
	.word 0x87802074  ! 3243: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 3244: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcc4c400  ! 3245: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	.word 0xdab649e0  ! 3246: STHA_R	stha	%r13, [%r25 + %r0] 0x4f
	.word 0x8780204f  ! 3247: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcb6c9e0  ! 3248: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	.word 0xd4dc0400  ! 3249: LDXA_R	ldxa	[%r16, %r0] 0x20, %r10
	mov	0x3d0, %r21
	mov	0x3f0, %r21
	.word 0xd0d689e0  ! 3252: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r8
	.word 0xd0c78e60  ! 3253: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r8
	.word 0xd2d7ce60  ! 3254: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r9
	mov	0x3e0, %r23
	.word 0xd28de000  ! 3256: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r9
	.word 0x87802025  ! 3257: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 3258: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 3259: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r17
	.word 0xdedf0e80  ! 3261: LDXA_R	ldxa	[%r28, %r0] 0x74, %r15
	.word 0xd89e89e0  ! 3262: LDDA_R	ldda	[%r26, %r0] 0x4f, %r12
	.word 0xdc9ce000  ! 3263: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r14
	.word 0xdca46000  ! 3264: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3265: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r17
	.word 0xdcb46000  ! 3267: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 3268: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 3269: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca46000  ! 3270: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xd2ac8400  ! 3272: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	mov	0x60, %r19
	.word 0xd0ac6000  ! 3274: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0xd0a4a000  ! 3275: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0xd6df8e80  ! 3276: LDXA_R	ldxa	[%r30, %r0] 0x74, %r11
	.word 0xd8b7ce40  ! 3277: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0xd8ac0400  ! 3278: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xd6dc6000  ! 3279: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r11
	mov	0x3e0, %r22
	.word 0xd6c4a000  ! 3281: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r11
	.word 0xd4dcc400  ! 3282: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0xd0f78e80  ! 3283: STXA_R	stxa	%r8, [%r30 + %r0] 0x74
	.word 0x87802025  ! 3284: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 3285: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r18
	.word 0x87802025  ! 3287: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b7a000  ! 3288: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xde8c0400  ! 3289: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0xd097a000  ! 3290: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	.word 0xdcd4c400  ! 3291: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	.word 0xda9f0e60  ! 3292: LDDA_R	ldda	[%r28, %r0] 0x73, %r13
	.word 0xdef7a000  ! 3293: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3294: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeafce60  ! 3295: STBA_R	stba	%r15, [%r31 + %r0] 0x73
	.word 0xdeb78e80  ! 3296: STHA_R	stha	%r15, [%r30 + %r0] 0x74
	.word 0x87802073  ! 3297: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde9f8e40  ! 3298: LDDA_R	ldda	[%r30, %r0] 0x72, %r15
	mov	0x3c8, %r22
	.word 0xdcafce80  ! 3300: STBA_R	stba	%r14, [%r31 + %r0] 0x74
	mov	0x7c8, %r21
	.word 0x87802020  ! 3302: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f649e0  ! 3303: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	.word 0x8780204f  ! 3304: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdecfa000  ! 3305: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xdebfa000  ! 3306: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xded7e000  ! 3307: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	mov	0x40, %r24
	.word 0xde8fe000  ! 3309: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0x87802074  ! 3310: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r24
	.word 0xd6f4c400  ! 3312: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0xd4af0e80  ! 3313: STBA_R	stba	%r10, [%r28 + %r0] 0x74
	.word 0xd2af8e60  ! 3314: STBA_R	stba	%r9, [%r30 + %r0] 0x73
	mov	0x7f0, %r20
	.word 0xd4b44400  ! 3316: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	mov	0x60, %r16
	.word 0x87802072  ! 3318: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 3319: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e0, %r22
	.word 0xd6a78e80  ! 3321: STWA_R	stwa	%r11, [%r30 + %r0] 0x74
	.word 0xd0f4c400  ! 3322: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	mov	0x3f0, %r23
	mov	0x48, %r25
	.word 0xdecca000  ! 3325: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	.word 0xde9c2000  ! 3326: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xd28c0400  ! 3327: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	.word 0x87802074  ! 3328: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa7a000  ! 3329: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xda8f6000  ! 3330: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0x87802074  ! 3331: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 3332: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdadda000  ! 3333: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r13
	.word 0xda97ce80  ! 3334: LDUHA_R	lduha	[%r31, %r0] 0x74, %r13
	mov	0x0, %r18
	mov	0x28, %r26
	.word 0x87802073  ! 3337: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb7e000  ! 3338: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xdea7e000  ! 3339: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xdec76000  ! 3340: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	mov	0x60, %r18
	.word 0xdeb7e000  ! 3342: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	mov	0x7f8, %r23
	.word 0xdcbf0e40  ! 3344: STDA_R	stda	%r14, [%r28 + %r0] 0x72
	mov	0x28, %r27
	.word 0xd297a000  ! 3346: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	.word 0xd4f584a0  ! 3347: STXA_R	stxa	%r10, [%r22 + %r0] 0x25
	.word 0xd0b7e000  ! 3348: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	mov	0x70, %r27
	.word 0xd49c8400  ! 3350: LDDA_R	ldda	[%r18, %r0] 0x20, %r10
	.word 0xdccf2000  ! 3351: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xd0b689e0  ! 3352: STHA_R	stha	%r8, [%r26 + %r0] 0x4f
	mov	0x7c8, %r23
	.word 0x8780204f  ! 3354: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8d4a000  ! 3355: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xd8c4e000  ! 3356: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	mov	0x7d0, %r21
	mov	0x7e8, %r21
	mov	0x20, %r17
	mov	0x8, %r26
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd8c42000  ! 3362: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r12
	.word 0xd89c2000  ! 3363: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 3364: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a76000  ! 3365: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xd4c78e40  ! 3366: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r10
	.word 0x87802025  ! 3367: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd69d44a0  ! 3368: LDDA_R	ldda	[%r21, %r0] 0x25, %r11
	.word 0xdcc7ce80  ! 3369: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r14
	mov	0x78, %r16
	mov	0x78, %r26
	mov	0x7f8, %r23
	mov	0x18, %r26
	.word 0xd29fe000  ! 3374: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd2a76000  ! 3375: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xdcb78e40  ! 3376: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xd0874e60  ! 3377: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r8
	.word 0xd6b584a0  ! 3378: STHA_R	stha	%r11, [%r22 + %r0] 0x25
	.word 0xd0a76000  ! 3379: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	mov	0x18, %r25
	.word 0xd08504a0  ! 3381: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r8
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2c4c400  ! 3383: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd8b72000  ! 3385: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xdea7ce40  ! 3386: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	mov	0x38, %r27
	mov	0x28, %r24
	.word 0x87802020  ! 3389: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf5e000  ! 3390: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0xdaade000  ! 3391: STBA_I	stba	%r13, [%r23 + 0x0000] %asi
	mov	0x48, %r26
	.word 0x87802074  ! 3393: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r17
	.word 0xda8d6000  ! 3395: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r13
	.word 0xd0a689e0  ! 3396: STWA_R	stwa	%r8, [%r26 + %r0] 0x4f
	mov	0x3f0, %r23
	.word 0x87802073  ! 3398: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd89e2000  ! 3399: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r12
	.word 0x87802020  ! 3400: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8870e40  ! 3401: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r12
	.word 0xd2bde000  ! 3402: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	.word 0xdca74e80  ! 3403: STWA_R	stwa	%r14, [%r29 + %r0] 0x74
	.word 0xde97ce60  ! 3404: LDUHA_R	lduha	[%r31, %r0] 0x73, %r15
	.word 0xd6b5a000  ! 3405: STHA_I	stha	%r11, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 3406: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8f584a0  ! 3407: STXA_R	stxa	%r12, [%r22 + %r0] 0x25
	.word 0xd6f5a000  ! 3408: STXA_I	stxa	%r11, [%r22 + 0x0000] %asi
	.word 0xd0a5c4a0  ! 3409: STWA_R	stwa	%r8, [%r23 + %r0] 0x25
	mov	0x7c8, %r20
	.word 0xd8a78e40  ! 3411: STWA_R	stwa	%r12, [%r30 + %r0] 0x72
	.word 0xd2bfce80  ! 3412: STDA_R	stda	%r9, [%r31 + %r0] 0x74
	mov	0x0, %r18
	.word 0xd2ada000  ! 3414: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xda9f4e80  ! 3415: LDDA_R	ldda	[%r29, %r0] 0x74, %r13
	.word 0xdc852000  ! 3416: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r14
	mov	0x18, %r16
	.word 0xdcf5a000  ! 3418: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	.word 0xdcdde000  ! 3419: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	mov	0x70, %r16
	.word 0xdcb5a000  ! 3421: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0xdebf4e80  ! 3422: STDA_R	stda	%r15, [%r29 + %r0] 0x74
	mov	0x0, %r26
	.word 0xd2d4c400  ! 3424: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r9
	.word 0xd684c400  ! 3425: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	.word 0xdc840400  ! 3426: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	.word 0xd8b5a000  ! 3427: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	.word 0xd8f52000  ! 3428: STXA_I	stxa	%r12, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 3429: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcc544a0  ! 3430: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r14
	.word 0xd2b7e000  ! 3431: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2f7a000  ! 3432: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	mov	0x50, %r17
	.word 0xd28f2000  ! 3434: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	mov	0x58, %r19
	.word 0xdca74e40  ! 3436: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	.word 0xd6970e80  ! 3437: LDUHA_R	lduha	[%r28, %r0] 0x74, %r11
	.word 0xdcbfe000  ! 3438: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdcd7a000  ! 3439: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0xdca76000  ! 3440: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcbfe000  ! 3441: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	mov	0x3e8, %r21
	mov	0x58, %r16
	.word 0xdcc7e000  ! 3444: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	mov	0x18, %r26
	.word 0xdcbfa000  ! 3446: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 3447: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2a78e60  ! 3448: STWA_R	stwa	%r9, [%r30 + %r0] 0x73
	mov	0x40, %r18
	.word 0xd6c584a0  ! 3450: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r11
	.word 0xd295c4a0  ! 3451: LDUHA_R	lduha	[%r23, %r0] 0x25, %r9
	.word 0xda9f6000  ! 3452: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xdacfe000  ! 3453: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0xdab7e000  ! 3454: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	mov	0x40, %r25
	.word 0xd08ec9e0  ! 3456: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r8
	.word 0xd4f74e60  ! 3457: STXA_R	stxa	%r10, [%r29 + %r0] 0x73
	mov	0x0, %r24
	.word 0xdcf72000  ! 3459: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	mov	0x3c8, %r20
	.word 0x87802072  ! 3461: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r24
	mov	0x3e0, %r22
	.word 0x87802073  ! 3464: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r17
	.word 0x8780204f  ! 3466: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r19
	.word 0xd6970e40  ! 3468: LDUHA_R	lduha	[%r28, %r0] 0x72, %r11
	.word 0x87802073  ! 3469: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2afe000  ! 3470: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xdccf8e80  ! 3472: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r14
	.word 0x87802020  ! 3473: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c4e000  ! 3474: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	mov	0x8, %r16
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2c4a000  ! 3477: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	.word 0xd2f46000  ! 3478: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	mov	0x3c0, %r23
	.word 0xd2d4a000  ! 3480: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	.word 0xd29ca000  ! 3481: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	.word 0xdcaf4e40  ! 3482: STBA_R	stba	%r14, [%r29 + %r0] 0x72
	mov	0x68, %r19
	.word 0xda8ce000  ! 3484: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	.word 0x87802074  ! 3485: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcdcc400  ! 3486: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	.word 0xdaa609e0  ! 3487: STWA_R	stwa	%r13, [%r24 + %r0] 0x4f
	.word 0xdad48400  ! 3488: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0xd68fce80  ! 3489: LDUBA_R	lduba	[%r31, %r0] 0x74, %r11
	mov	0x38, %r16
	.word 0xd6c44400  ! 3491: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r11
	.word 0xd4a78e60  ! 3492: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	mov	0x7f0, %r22
	mov	0x78, %r27
	.word 0xdcb78e80  ! 3495: STHA_R	stha	%r14, [%r30 + %r0] 0x74
	mov	0x60, %r25
	.word 0xd4c42000  ! 3497: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r10
	.word 0xd4ac6000  ! 3498: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	.word 0xd4ac2000  ! 3499: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0xd4dce000  ! 3500: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	.word 0xd0974e40  ! 3501: LDUHA_R	lduha	[%r29, %r0] 0x72, %r8
	.word 0xd4a70e80  ! 3502: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	.word 0x87802020  ! 3503: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0c40400  ! 3504: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	mov	0x50, %r25
	.word 0xdadde000  ! 3506: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r13
	mov	0x28, %r19
	.word 0xd2f7ce40  ! 3508: STXA_R	stxa	%r9, [%r31 + %r0] 0x72
	.word 0xd8a78e40  ! 3509: STWA_R	stwa	%r12, [%r30 + %r0] 0x72
	ta	T_CHANGE_PRIV	! macro
	.word 0xd6a5a000  ! 3511: STWA_I	stwa	%r11, [%r22 + 0x0000] %asi
	mov	0x78, %r25
	mov	0x50, %r16
	.word 0xd6d544a0  ! 3514: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r11
	mov	0x60, %r19
	mov	0x28, %r17
	mov	0x60, %r18
	mov	0x7f8, %r22
	.word 0xd2d48400  ! 3519: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	.word 0xdcac0400  ! 3520: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0x87802072  ! 3521: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf76000  ! 3522: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x3e0, %r22
	mov	0x20, %r19
	.word 0xdc9fa000  ! 3525: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	mov	0x8, %r26
	.word 0xd2f74e80  ! 3527: STXA_R	stxa	%r9, [%r29 + %r0] 0x74
	.word 0xdedf6000  ! 3528: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xdea76000  ! 3529: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xd0f70e80  ! 3530: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0xd0d7a000  ! 3531: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0xd2a689e0  ! 3532: STWA_R	stwa	%r9, [%r26 + %r0] 0x4f
	mov	0x70, %r17
	.word 0x87802020  ! 3534: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b76000  ! 3535: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2c7a000  ! 3536: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	.word 0xd28f2000  ! 3537: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	.word 0xdabfce40  ! 3538: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	.word 0xd0c4c400  ! 3539: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	.word 0x87802073  ! 3540: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d0, %r22
	.word 0xd8c40400  ! 3542: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	mov	0x8, %r27
	.word 0xd29de000  ! 3544: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r9
	mov	0x7f0, %r23
	mov	0x78, %r25
	.word 0xd2bde000  ! 3547: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	mov	0x10, %r19
	mov	0x3f8, %r21
	.word 0x87802020  ! 3550: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd286a000  ! 3551: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r9
	mov	0x78, %r16
	.word 0xd2ce2000  ! 3553: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r9
	.word 0xd0ce89e0  ! 3554: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r8
	.word 0xd0d689e0  ! 3555: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r8
	.word 0xd6f78e40  ! 3556: STXA_R	stxa	%r11, [%r30 + %r0] 0x72
	.word 0xd2962000  ! 3557: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r9
	.word 0xd2f6e000  ! 3558: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	.word 0xd296a000  ! 3559: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r9
	.word 0xd8de09e0  ! 3560: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r12
	.word 0x87802074  ! 3561: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r20
	.word 0x87802025  ! 3563: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6cc4400  ! 3564: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	.word 0xd2cf4e40  ! 3565: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r9
	.word 0xdacc2000  ! 3566: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xdaac6000  ! 3567: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	.word 0xd0a74e40  ! 3568: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	.word 0xdad40400  ! 3569: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	.word 0xdecc8400  ! 3570: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	mov	0x38, %r27
	.word 0xdeac6000  ! 3572: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	mov	0x18, %r27
	.word 0x87802074  ! 3574: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef72000  ! 3575: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xde876000  ! 3576: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xdc8c4400  ! 3577: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	mov	0x30, %r26
	.word 0xdcb584a0  ! 3579: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	.word 0x87802072  ! 3580: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r16
	.word 0xdcb584a0  ! 3582: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	mov	0x7f8, %r23
	.word 0xd684c400  ! 3584: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	.word 0xd687e000  ! 3585: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xd68fa000  ! 3586: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0xd6af2000  ! 3587: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x18, %r16
	.word 0x87802020  ! 3589: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3590: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r25
	.word 0x87802020  ! 3592: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef609e0  ! 3593: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	.word 0xd6c66000  ! 3594: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r11
	.word 0xd696a000  ! 3595: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r11
	.word 0xd2a5c4a0  ! 3596: STWA_R	stwa	%r9, [%r23 + %r0] 0x25
	.word 0xd0a6e000  ! 3597: STWA_I	stwa	%r8, [%r27 + 0x0000] %asi
	.word 0x87802025  ! 3598: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0cce000  ! 3599: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0f46000  ! 3600: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0ace000  ! 3601: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	mov	0x7e0, %r23
	mov	0x8, %r19
	.word 0xdeac8400  ! 3604: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	mov	0x70, %r25
	mov	0x40, %r18
	.word 0xdeb4a000  ! 3607: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0xdedc6000  ! 3608: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3609: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r19
	.word 0x87802073  ! 3611: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde842000  ! 3612: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3613: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeafa000  ! 3614: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xde8fa000  ! 3615: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0xdedfa000  ! 3616: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xde8f6000  ! 3617: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	mov	0x3d8, %r22
	.word 0xde9f6000  ! 3619: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3620: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ac4400  ! 3621: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	mov	0x3e0, %r20
	.word 0xd4bfe000  ! 3623: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x38, %r27
	.word 0xd487a000  ! 3625: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	mov	0x28, %r25
	.word 0xd4ae89e0  ! 3627: STBA_R	stba	%r10, [%r26 + %r0] 0x4f
	.word 0xd2a76000  ! 3628: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd2c74e40  ! 3629: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r9
	.word 0x87802020  ! 3630: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4944400  ! 3631: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	.word 0xdedc6000  ! 3632: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r15
	.word 0xd8b7ce80  ! 3633: STHA_R	stha	%r12, [%r31 + %r0] 0x74
	.word 0xdea4a000  ! 3634: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xdef48400  ! 3635: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xd694e000  ! 3636: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r11
	.word 0xd29c4400  ! 3637: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	.word 0xd88584a0  ! 3638: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r12
	mov	0x78, %r27
	mov	0x3e8, %r20
	.word 0xdcd46000  ! 3641: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	.word 0xdcc4a000  ! 3642: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r14
	.word 0xdc842000  ! 3643: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802074  ! 3645: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r24
	.word 0x87802025  ! 3647: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 3648: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde9dc4a0  ! 3649: LDDA_R	ldda	[%r23, %r0] 0x25, %r15
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdea5c4a0  ! 3651: STWA_R	stwa	%r15, [%r23 + %r0] 0x25
	.word 0xd4dee000  ! 3652: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r10
	.word 0xd4be6000  ! 3653: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0xdca74e60  ! 3654: STWA_R	stwa	%r14, [%r29 + %r0] 0x73
	.word 0xde944400  ! 3655: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	.word 0x87802025  ! 3656: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdac42000  ! 3657: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3658: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab42000  ! 3659: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0x87802072  ! 3661: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 3662: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda97a000  ! 3663: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xd8af4e40  ! 3664: STBA_R	stba	%r12, [%r29 + %r0] 0x72
	mov	0x40, %r19
	.word 0xd0cd04a0  ! 3666: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r8
	.word 0xdebfe000  ! 3667: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xdcd689e0  ! 3668: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r14
	.word 0xd0bfe000  ! 3669: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd89f8e60  ! 3670: LDDA_R	ldda	[%r30, %r0] 0x73, %r12
	mov	0x58, %r25
	mov	0x50, %r16
	.word 0xdcd4c400  ! 3673: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	.word 0xd6b7a000  ! 3674: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd6bf6000  ! 3675: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd6bfa000  ! 3676: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 3677: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r18
	mov	0x3d8, %r20
	mov	0x7d0, %r22
	.word 0xd68fe000  ! 3681: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xd8be09e0  ! 3682: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	.word 0xda9f2000  ! 3683: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	mov	0x58, %r16
	.word 0xd8f70e80  ! 3685: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	.word 0xd8bfce80  ! 3686: STDA_R	stda	%r12, [%r31 + %r0] 0x74
	.word 0xd8876000  ! 3687: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0xd6b7ce60  ! 3688: STHA_R	stha	%r11, [%r31 + %r0] 0x73
	.word 0xdeb44400  ! 3689: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	mov	0x3c8, %r20
	.word 0xd8a7e000  ! 3691: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	mov	0x3c8, %r22
	.word 0x87802025  ! 3693: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8a7e000  ! 3694: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd49e89e0  ! 3695: LDDA_R	ldda	[%r26, %r0] 0x4f, %r10
	.word 0x87802020  ! 3696: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad4e000  ! 3697: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r13
	.word 0xdc8f8e40  ! 3698: LDUBA_R	lduba	[%r30, %r0] 0x72, %r14
	mov	0x60, %r26
	.word 0x87802073  ! 3700: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca5a000  ! 3701: STWA_I	stwa	%r14, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 3702: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcaf6000  ! 3703: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdcbf2000  ! 3704: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xd6b70e60  ! 3705: STHA_R	stha	%r11, [%r28 + %r0] 0x73
	mov	0x60, %r18
	.word 0x8780204f  ! 3707: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea48400  ! 3708: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xdcde89e0  ! 3709: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r14
	mov	0x28, %r27
	.word 0xdcbc0400  ! 3711: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0x87802020  ! 3712: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd486c9e0  ! 3713: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r10
	.word 0xde8c2000  ! 3714: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	mov	0x68, %r16
	.word 0xd2ad84a0  ! 3716: STBA_R	stba	%r9, [%r22 + %r0] 0x25
	.word 0x87802020  ! 3717: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 3718: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabfce60  ! 3719: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	.word 0xdaa4a000  ! 3720: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xd2d78e80  ! 3721: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r9
	.word 0xd4ae09e0  ! 3722: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 3723: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 3724: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd09c8400  ! 3725: LDDA_R	ldda	[%r18, %r0] 0x20, %r8
	.word 0xd0c72000  ! 3726: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xd6cf4e60  ! 3727: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r11
	.word 0xd0bfce60  ! 3728: STDA_R	stda	%r8, [%r31 + %r0] 0x73
	.word 0xd0df6000  ! 3729: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0c7e000  ! 3730: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0xd08f2000  ! 3731: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	.word 0xd0dfe000  ! 3732: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xde9f4e60  ! 3733: LDDA_R	ldda	[%r29, %r0] 0x73, %r15
	.word 0xd0af2000  ! 3734: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd0dfe000  ! 3736: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	mov	0x3e0, %r22
	mov	0x7e8, %r20
	mov	0x7e8, %r20
	.word 0xdad4c400  ! 3740: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xdaf689e0  ! 3741: STXA_R	stxa	%r13, [%r26 + %r0] 0x4f
	.word 0xdccc4400  ! 3742: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r14
	.word 0xdacf2000  ! 3743: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	mov	0x68, %r19
	.word 0x87802072  ! 3745: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf72000  ! 3746: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdca7ce80  ! 3747: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	.word 0xd0c76000  ! 3748: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	mov	0x7c8, %r22
	.word 0xd0b74e40  ! 3750: STHA_R	stha	%r8, [%r29 + %r0] 0x72
	.word 0xd6c72000  ! 3751: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0x87802072  ! 3752: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r27
	mov	0x48, %r26
	.word 0xd2b544a0  ! 3755: STHA_R	stha	%r9, [%r21 + %r0] 0x25
	mov	0x7d0, %r20
	.word 0xd4f6c9e0  ! 3757: STXA_R	stxa	%r10, [%r27 + %r0] 0x4f
	.word 0xdabc2000  ! 3758: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xde870e40  ! 3759: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r15
	.word 0x87802073  ! 3760: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdec7ce40  ! 3761: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r15
	.word 0xd287ce60  ! 3762: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r9
	.word 0xd4ad44a0  ! 3763: STBA_R	stba	%r10, [%r21 + %r0] 0x25
	mov	0x40, %r25
	.word 0xd2bfe000  ! 3765: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	mov	0x10, %r17
	.word 0xd287a000  ! 3767: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802025  ! 3769: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdacfce80  ! 3770: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r13
	.word 0xd4a70e40  ! 3771: STWA_R	stwa	%r10, [%r28 + %r0] 0x72
	.word 0xdebfa000  ! 3772: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 3773: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8dc8400  ! 3774: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xd284a000  ! 3775: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	.word 0xdeafce40  ! 3776: STBA_R	stba	%r15, [%r31 + %r0] 0x72
	.word 0xd0a48400  ! 3777: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	mov	0x3f0, %r20
	mov	0x10, %r18
	mov	0x28, %r16
	mov	0x60, %r18
	.word 0xde9ca000  ! 3782: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	mov	0x20, %r27
	.word 0xd0bf0e80  ! 3784: STDA_R	stda	%r8, [%r28 + %r0] 0x74
	.word 0xdacd44a0  ! 3785: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r13
	.word 0x87802074  ! 3786: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 3787: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa72000  ! 3788: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	mov	0x50, %r19
	mov	0x7d8, %r20
	.word 0x87802025  ! 3791: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda9f6000  ! 3792: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xd8974e60  ! 3793: LDUHA_R	lduha	[%r29, %r0] 0x73, %r12
	.word 0xd2b544a0  ! 3794: STHA_R	stha	%r9, [%r21 + %r0] 0x25
	.word 0xd2f72000  ! 3795: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd8ac4400  ! 3796: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xdecfe000  ! 3797: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xdc940400  ! 3798: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0xd0c7a000  ! 3799: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0972000  ! 3800: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	mov	0x38, %r24
	.word 0xda8c4400  ! 3802: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0xdab48400  ! 3803: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0xd6c7a000  ! 3804: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	.word 0xd0be49e0  ! 3805: STDA_R	stda	%r8, [%r25 + %r0] 0x4f
	mov	0x48, %r18
	.word 0x87802072  ! 3807: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcafa000  ! 3808: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xd49fce40  ! 3809: LDDA_R	ldda	[%r31, %r0] 0x72, %r10
	mov	0x7c8, %r20
	.word 0xd89f2000  ! 3811: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0xd88f0e80  ! 3812: LDUBA_R	lduba	[%r28, %r0] 0x74, %r12
	.word 0xd4b7e000  ! 3813: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd6f4c400  ! 3814: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0xd8ae49e0  ! 3815: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0xd4b70e80  ! 3816: STHA_R	stha	%r10, [%r28 + %r0] 0x74
	.word 0x87802072  ! 3817: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca74e60  ! 3818: STWA_R	stwa	%r14, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 3819: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a7ce60  ! 3820: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	mov	0x48, %r27
	.word 0xdabc0400  ! 3822: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	mov	0x3c8, %r23
	mov	0x50, %r19
	.word 0xd6940400  ! 3825: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	.word 0xd6b4c400  ! 3826: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xde9689e0  ! 3827: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r15
	.word 0xdecfce60  ! 3828: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r15
	.word 0xda970e60  ! 3829: LDUHA_R	lduha	[%r28, %r0] 0x73, %r13
	.word 0xdea6a000  ! 3830: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	.word 0xda9c4400  ! 3831: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	.word 0xd28ee000  ! 3832: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r9
	mov	0x10, %r26
	.word 0x87802072  ! 3834: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f0, %r20
	mov	0x70, %r16
	.word 0x87802074  ! 3837: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2cce000  ! 3838: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	.word 0xd2a4e000  ! 3839: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2b4e000  ! 3840: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	mov	0x8, %r27
	.word 0xd2b42000  ! 3842: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	mov	0x7f8, %r20
	.word 0xd2c42000  ! 3844: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3845: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ae09e0  ! 3846: STBA_R	stba	%r8, [%r24 + %r0] 0x4f
	.word 0xd6f40400  ! 3847: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	.word 0xdcaca000  ! 3848: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xd88504a0  ! 3849: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r12
	.word 0xd68f8e60  ! 3850: LDUBA_R	lduba	[%r30, %r0] 0x73, %r11
	.word 0xd4dcc400  ! 3851: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	mov	0x40, %r17
	mov	0x18, %r16
	.word 0xd2bc2000  ! 3854: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xd2ac6000  ! 3855: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xde970e40  ! 3856: LDUHA_R	lduha	[%r28, %r0] 0x72, %r15
	.word 0xdeae49e0  ! 3857: STBA_R	stba	%r15, [%r25 + %r0] 0x4f
	.word 0xd4bce000  ! 3858: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 3859: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcc609e0  ! 3860: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r14
	.word 0xd0b7ce60  ! 3861: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	.word 0x87802020  ! 3862: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bf0e80  ! 3863: STDA_R	stda	%r9, [%r28 + %r0] 0x74
	mov	0x8, %r26
	.word 0xd0dfe000  ! 3865: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0a7a000  ! 3866: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 3867: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0b7a000  ! 3868: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd0a76000  ! 3869: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 3870: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde878e60  ! 3871: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r15
	mov	0x48, %r24
	.word 0xd4b74e80  ! 3873: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	.word 0x87802072  ! 3874: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d8, %r21
	.word 0xd0ace000  ! 3876: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	mov	0x3f0, %r20
	mov	0x3f8, %r23
	.word 0xd08c6000  ! 3879: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0x87802020  ! 3880: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c504a0  ! 3881: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r9
	.word 0xdcb5e000  ! 3882: STHA_I	stha	%r14, [%r23 + 0x0000] %asi
	.word 0xdcf5e000  ! 3883: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0xde848400  ! 3884: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	.word 0xd4acc400  ! 3885: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xd095c4a0  ! 3886: LDUHA_R	lduha	[%r23, %r0] 0x25, %r8
	.word 0xdadd44a0  ! 3887: LDXA_R	ldxa	[%r21, %r0] 0x25, %r13
	.word 0xd6cda000  ! 3888: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r11
	.word 0xd2d504a0  ! 3889: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r9
	.word 0x87802020  ! 3890: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3891: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 3892: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r26
	mov	0x68, %r18
	.word 0xdca5a000  ! 3895: STWA_I	stwa	%r14, [%r22 + 0x0000] %asi
	mov	0x7d8, %r21
	mov	0x38, %r19
	.word 0xdca5a000  ! 3898: STWA_I	stwa	%r14, [%r22 + 0x0000] %asi
	mov	0x7f8, %r22
	.word 0xdebf8e80  ! 3900: STDA_R	stda	%r15, [%r30 + %r0] 0x74
	.word 0xda9de000  ! 3901: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r13
	.word 0xdecf4e40  ! 3902: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r15
	.word 0xda9d44a0  ! 3903: LDDA_R	ldda	[%r21, %r0] 0x25, %r13
	.word 0xd6bd6000  ! 3904: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0xdcf44400  ! 3905: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	mov	0x3d0, %r23
	.word 0xdc852000  ! 3907: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r14
	.word 0xd2cf4e60  ! 3908: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r9
	.word 0xd0bf8e80  ! 3909: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	mov	0x18, %r19
	.word 0xd4c56000  ! 3911: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r10
	.word 0xded4c400  ! 3912: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r15
	.word 0xd4bd6000  ! 3913: STDA_I	stda	%r10, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 3914: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f6c9e0  ! 3915: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	.word 0xd4afa000  ! 3916: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd2bf0e60  ! 3917: STDA_R	stda	%r9, [%r28 + %r0] 0x73
	.word 0xd68544a0  ! 3918: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r11
	mov	0x7e8, %r22
	mov	0x30, %r25
	mov	0x18, %r25
	.word 0xdcb70e60  ! 3922: STHA_R	stha	%r14, [%r28 + %r0] 0x73
	.word 0xd48fce40  ! 3923: LDUBA_R	lduba	[%r31, %r0] 0x72, %r10
	mov	0x3e8, %r23
	.word 0x87802020  ! 3925: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad5e000  ! 3926: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r13
	mov	0x50, %r27
	mov	0x3d0, %r22
	.word 0xd0c4c400  ! 3929: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	mov	0x3c0, %r23
	.word 0xdcbdc4a0  ! 3931: STDA_R	stda	%r14, [%r23 + %r0] 0x25
	.word 0xd29fce80  ! 3932: LDDA_R	ldda	[%r31, %r0] 0x74, %r9
	mov	0x3f0, %r22
	.word 0xdedd2000  ! 3934: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r15
	mov	0x7d0, %r22
	.word 0x87802072  ! 3936: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6874e60  ! 3937: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r11
	.word 0xd6c4c400  ! 3938: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r11
	.word 0x87802020  ! 3939: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3940: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6a70e40  ! 3941: STWA_R	stwa	%r11, [%r28 + %r0] 0x72
	.word 0xd2dfe000  ! 3942: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2c72000  ! 3943: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2a44400  ! 3944: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xd4cf6000  ! 3945: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0x87802020  ! 3946: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9fce60  ! 3947: LDDA_R	ldda	[%r31, %r0] 0x73, %r14
	.word 0xdaa48400  ! 3948: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0xdad48400  ! 3949: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0xdaaea000  ! 3950: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xda8e6000  ! 3952: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r13
	.word 0xda9ee000  ! 3953: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r13
	.word 0xdaa7ce40  ! 3954: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	.word 0xd4a62000  ! 3955: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	mov	0x60, %r24
	.word 0xdaf7ce80  ! 3957: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	mov	0x10, %r24
	mov	0x38, %r18
	.word 0xdaf609e0  ! 3960: STXA_R	stxa	%r13, [%r24 + %r0] 0x4f
	.word 0xda8f8e40  ! 3961: LDUBA_R	lduba	[%r30, %r0] 0x72, %r13
	.word 0xd4dee000  ! 3962: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r10
	.word 0xd4aee000  ! 3963: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	mov	0x18, %r17
	.word 0xde8fce60  ! 3965: LDUBA_R	lduba	[%r31, %r0] 0x73, %r15
	.word 0xd8f62000  ! 3966: STXA_I	stxa	%r12, [%r24 + 0x0000] %asi
	.word 0xd8be6000  ! 3967: STDA_I	stda	%r12, [%r25 + 0x0000] %asi
	.word 0xd8f504a0  ! 3968: STXA_R	stxa	%r12, [%r20 + %r0] 0x25
	.word 0x87802025  ! 3969: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6cf8e60  ! 3970: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r11
	mov	0x58, %r19
	mov	0x58, %r27
	.word 0x87802074  ! 3973: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r16
	.word 0xd68f4e60  ! 3975: LDUBA_R	lduba	[%r29, %r0] 0x73, %r11
	.word 0xdebfe000  ! 3976: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xd0d649e0  ! 3977: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r8
	.word 0xdc9f4e60  ! 3978: LDDA_R	ldda	[%r29, %r0] 0x73, %r14
	mov	0x3e0, %r20
	.word 0xd6cdc4a0  ! 3980: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r11
	.word 0xdecfa000  ! 3981: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0x87802025  ! 3982: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaad04a0  ! 3983: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	.word 0xdac76000  ! 3984: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	mov	0x3d8, %r20
	.word 0xdaafa000  ! 3986: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdcb649e0  ! 3987: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	.word 0xdaf74e40  ! 3988: STXA_R	stxa	%r13, [%r29 + %r0] 0x72
	.word 0x87802020  ! 3989: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r17
	.word 0xd8b7ce40  ! 3991: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0xdcd66000  ! 3992: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r14
	.word 0xdad40400  ! 3993: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	.word 0x8780204f  ! 3994: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 3995: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r24
	.word 0xd68fce80  ! 3997: LDUBA_R	lduba	[%r31, %r0] 0x74, %r11
	mov	0x0, %r24
	.word 0x87802025  ! 3999: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r25
	.word 0xd8bce000  ! 4001: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	mov	0x20, %r16
	.word 0x87802020  ! 4003: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r25
	.word 0xdef5c4a0  ! 4005: STXA_R	stxa	%r15, [%r23 + %r0] 0x25
	mov	0x68, %r26
	.word 0xdebde000  ! 4007: STDA_I	stda	%r15, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 4008: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4870e60  ! 4009: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r10
	.word 0xd88c8400  ! 4010: LDUBA_R	lduba	[%r18, %r0] 0x20, %r12
	.word 0xd2be09e0  ! 4011: STDA_R	stda	%r9, [%r24 + %r0] 0x4f
	.word 0xd4c74e80  ! 4012: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r10
	.word 0xd0bfce80  ! 4013: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	.word 0x8780204f  ! 4014: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 4015: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6a7a000  ! 4016: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd68fa000  ! 4017: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0xd687e000  ! 4018: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6f7a000  ! 4019: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6f4c400  ! 4020: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	mov	0x38, %r27
	.word 0xdeb78e40  ! 4022: STHA_R	stha	%r15, [%r30 + %r0] 0x72
	mov	0x3e8, %r23
	.word 0xd8dc4400  ! 4024: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0xd2bf6000  ! 4025: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd2a72000  ! 4026: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0xd4a78e80  ! 4027: STWA_R	stwa	%r10, [%r30 + %r0] 0x74
	.word 0x8780204f  ! 4028: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6a48400  ! 4029: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0xdcb7a000  ! 4030: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xdcbfe000  ! 4031: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xd2d74e60  ! 4032: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r9
	.word 0xd4f7a000  ! 4033: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4d7e000  ! 4034: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	.word 0xdabf0e80  ! 4035: STDA_R	stda	%r13, [%r28 + %r0] 0x74
	.word 0xdacd04a0  ! 4036: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r13
	.word 0xdecfce80  ! 4037: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r15
	mov	0x7f0, %r23
	.word 0xdaf584a0  ! 4039: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	mov	0x58, %r19
	.word 0xde8c8400  ! 4041: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	mov	0x8, %r19
	mov	0x40, %r19
	.word 0xdaccc400  ! 4044: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r13
	mov	0x20, %r25
	.word 0xd8f5c4a0  ! 4046: STXA_R	stxa	%r12, [%r23 + %r0] 0x25
	mov	0x3c0, %r21
	.word 0x87802072  ! 4048: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 4049: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 4050: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd48ec9e0  ! 4051: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r10
	.word 0x87802074  ! 4052: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f504a0  ! 4053: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	.word 0x87802072  ! 4054: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r25
	.word 0xda85a000  ! 4056: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r13
	mov	0x40, %r18
	.word 0xd2c504a0  ! 4058: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r9
	.word 0xd4856000  ! 4059: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r10
	.word 0xd49de000  ! 4060: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r10
	.word 0xd2dd04a0  ! 4061: LDXA_R	ldxa	[%r20, %r0] 0x25, %r9
	.word 0xd49de000  ! 4062: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r10
	mov	0x20, %r16
	.word 0xd4ada000  ! 4064: STBA_I	stba	%r10, [%r22 + 0x0000] %asi
	mov	0x50, %r25
	.word 0xdaf4c400  ! 4066: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xd0b48400  ! 4067: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0x87802020  ! 4068: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdec40400  ! 4069: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xd487e000  ! 4070: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd0f7ce40  ! 4071: STXA_R	stxa	%r8, [%r31 + %r0] 0x72
	.word 0xdef7a000  ! 4072: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 4073: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde87e000  ! 4074: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xd0ce89e0  ! 4075: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r8
	.word 0xda9fe000  ! 4076: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xdaa76000  ! 4077: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	mov	0x50, %r25
	mov	0x3f8, %r22
	.word 0x87802074  ! 4080: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabf6000  ! 4081: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xdab7a000  ! 4082: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdaaf2000  ! 4083: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	mov	0x3f0, %r23
	.word 0xda8f2000  ! 4085: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4086: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r25
	.word 0xd69d04a0  ! 4088: LDDA_R	ldda	[%r20, %r0] 0x25, %r11
	.word 0xdacf2000  ! 4089: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 4090: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabf6000  ! 4091: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xdac76000  ! 4092: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0xdaaf6000  ! 4093: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 4094: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r27
	.word 0xd68f0e40  ! 4096: LDUBA_R	lduba	[%r28, %r0] 0x72, %r11
	mov	0x10, %r16
	.word 0xd8bc8400  ! 4098: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	mov	0x50, %r19
	.word 0xd0d72000  ! 4100: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd08f2000  ! 4101: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	.word 0xd0af6000  ! 4102: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd0bf2000  ! 4103: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xd0af2000  ! 4104: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0f7a000  ! 4105: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	mov	0x70, %r19
	mov	0x7c8, %r23
	mov	0x48, %r16
	.word 0xd0cf6000  ! 4109: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0x87802074  ! 4110: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 4111: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4d40400  ! 4112: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	.word 0xd6bc2000  ! 4113: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0xd6a4a000  ! 4114: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	.word 0xd6bca000  ! 4115: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	.word 0xd68c2000  ! 4116: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r11
	mov	0x7f8, %r21
	mov	0x18, %r19
	.word 0xd6948400  ! 4119: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	mov	0x68, %r16
	.word 0xd0df0e60  ! 4121: LDXA_R	ldxa	[%r28, %r0] 0x73, %r8
	.word 0xde870e80  ! 4122: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r15
	.word 0xdaaf4e40  ! 4123: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	.word 0xd8b4c400  ! 4124: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0xda848400  ! 4125: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r13
	.word 0xd4ad84a0  ! 4126: STBA_R	stba	%r10, [%r22 + %r0] 0x25
	.word 0xd294c400  ! 4127: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	.word 0xd8af0e40  ! 4128: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	.word 0xd28ce000  ! 4129: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	.word 0x87802072  ! 4130: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f72000  ! 4131: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xda94c400  ! 4132: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	.word 0xd4974e40  ! 4133: LDUHA_R	lduha	[%r29, %r0] 0x72, %r10
	.word 0xd2d7ce40  ! 4134: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r9
	.word 0xd8dfe000  ! 4135: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xd6c40400  ! 4136: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r11
	.word 0xd69c0400  ! 4137: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	.word 0x87802020  ! 4138: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea544a0  ! 4139: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	mov	0x70, %r27
	.word 0xd8ade000  ! 4141: STBA_I	stba	%r12, [%r23 + 0x0000] %asi
	.word 0xd2af8e80  ! 4142: STBA_R	stba	%r9, [%r30 + %r0] 0x74
	.word 0xd8856000  ! 4143: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	.word 0x87802025  ! 4144: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8ac2000  ! 4145: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4146: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4147: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 4148: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r24
	.word 0xd8942000  ! 4150: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r12
	.word 0xd8d4e000  ! 4151: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0xd68f4e80  ! 4152: LDUBA_R	lduba	[%r29, %r0] 0x74, %r11
	mov	0x78, %r17
	.word 0xdaf46000  ! 4154: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0xd2944400  ! 4155: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	.word 0x87802020  ! 4156: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b7e000  ! 4157: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2afa000  ! 4158: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	mov	0x3f8, %r23
	.word 0xd287e000  ! 4160: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	mov	0x70, %r25
	.word 0xd0d504a0  ! 4162: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r8
	mov	0x3d0, %r21
	mov	0x48, %r17
	.word 0x87802025  ! 4165: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 4166: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4c7e000  ! 4167: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	.word 0xd6a78e60  ! 4168: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0x87802074  ! 4169: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 4170: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r27
	.word 0xd2a76000  ! 4172: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd6afce40  ! 4173: STBA_R	stba	%r11, [%r31 + %r0] 0x72
	mov	0x8, %r25
	.word 0xd88d04a0  ! 4175: LDUBA_R	lduba	[%r20, %r0] 0x25, %r12
	.word 0x8780204f  ! 4176: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r18
	.word 0xdab7e000  ! 4178: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xd2b70e80  ! 4179: STHA_R	stha	%r9, [%r28 + %r0] 0x74
	.word 0xd4d78e80  ! 4180: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r10
	.word 0xd6f7ce80  ! 4181: STXA_R	stxa	%r11, [%r31 + %r0] 0x74
	.word 0xde9649e0  ! 4182: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r15
	.word 0xd0a76000  ! 4183: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0d7a000  ! 4184: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0xd0af2000  ! 4185: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xd0b76000  ! 4187: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd0dfe000  ! 4188: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	mov	0x58, %r24
	mov	0x7f0, %r21
	.word 0xd8b70e40  ! 4191: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0xd6d70e60  ! 4192: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r11
	.word 0xd2dd04a0  ! 4193: LDXA_R	ldxa	[%r20, %r0] 0x25, %r9
	.word 0xd497ce80  ! 4194: LDUHA_R	lduha	[%r31, %r0] 0x74, %r10
	.word 0xd4948400  ! 4195: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	.word 0x87802072  ! 4196: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r16
	.word 0xdecfa000  ! 4198: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	mov	0x3f0, %r21
	.word 0x87802074  ! 4200: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd48d04a0  ! 4201: LDUBA_R	lduba	[%r20, %r0] 0x25, %r10
	.word 0xd2b4c400  ! 4202: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xd4f4e000  ! 4203: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0xdcdc4400  ! 4204: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	.word 0xd2a4e000  ! 4205: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2b42000  ! 4206: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 4207: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2ada000  ! 4208: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xd29de000  ! 4209: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r9
	.word 0xd2f52000  ! 4210: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	.word 0xd4cf8e60  ! 4211: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r10
	.word 0xdcc52000  ! 4212: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r14
	.word 0xdcd5a000  ! 4213: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r14
	.word 0xdcb56000  ! 4214: STHA_I	stha	%r14, [%r21 + 0x0000] %asi
	mov	0x70, %r26
	.word 0xdccd6000  ! 4216: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r14
	.word 0xdcf5a000  ! 4217: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	.word 0xd287ce60  ! 4218: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r9
	.word 0xda9d84a0  ! 4219: LDDA_R	ldda	[%r22, %r0] 0x25, %r13
	.word 0xd09da000  ! 4220: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r8
	.word 0x87802074  ! 4221: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbf8e80  ! 4222: STDA_R	stda	%r14, [%r30 + %r0] 0x74
	.word 0xdabf8e40  ! 4223: STDA_R	stda	%r13, [%r30 + %r0] 0x72
	mov	0x68, %r24
	.word 0x87802072  ! 4225: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8c7ce60  ! 4226: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r12
	.word 0xd4b48400  ! 4227: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd4f5c4a0  ! 4228: STXA_R	stxa	%r10, [%r23 + %r0] 0x25
	mov	0x3f8, %r20
	.word 0xd6f609e0  ! 4230: STXA_R	stxa	%r11, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 4231: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r23
	.word 0xd0bf4e80  ! 4233: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	.word 0xd49f4e40  ! 4234: LDDA_R	ldda	[%r29, %r0] 0x72, %r10
	mov	0x10, %r25
	.word 0xdeaf4e40  ! 4236: STBA_R	stba	%r15, [%r29 + %r0] 0x72
	.word 0xd0cfce60  ! 4237: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r8
	.word 0xdc9cc400  ! 4238: LDDA_R	ldda	[%r19, %r0] 0x20, %r14
	.word 0xd89e49e0  ! 4239: LDDA_R	ldda	[%r25, %r0] 0x4f, %r12
	mov	0x7f0, %r22
	mov	0x7e8, %r20
	mov	0x48, %r19
	.word 0xd6f72000  ! 4243: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6c7a000  ! 4244: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	mov	0x20, %r16
	.word 0x87802074  ! 4246: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 4247: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a5e000  ! 4248: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	.word 0xd6cde000  ! 4249: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r11
	.word 0x87802074  ! 4250: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdec4c400  ! 4251: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	.word 0xdcd70e40  ! 4252: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r14
	.word 0xd4f609e0  ! 4253: STXA_R	stxa	%r10, [%r24 + %r0] 0x4f
	.word 0xd2bf0e80  ! 4254: STDA_R	stda	%r9, [%r28 + %r0] 0x74
	mov	0x10, %r17
	.word 0xdcf42000  ! 4256: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0xd28fce40  ! 4257: LDUBA_R	lduba	[%r31, %r0] 0x72, %r9
	.word 0xd4f4a000  ! 4258: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0xd0a70e40  ! 4259: STWA_R	stwa	%r8, [%r28 + %r0] 0x72
	mov	0x60, %r18
	mov	0x60, %r27
	.word 0xdebce000  ! 4262: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xdc978e60  ! 4263: LDUHA_R	lduha	[%r30, %r0] 0x73, %r14
	.word 0xd09d84a0  ! 4264: LDDA_R	ldda	[%r22, %r0] 0x25, %r8
	mov	0x3f0, %r23
	.word 0xd0af8e40  ! 4266: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0xdeac2000  ! 4267: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xdebc2000  ! 4268: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xd2f78e60  ! 4269: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0xda948400  ! 4270: LDUHA_R	lduha	[%r18, %r0] 0x20, %r13
	.word 0xd4f48400  ! 4271: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xdaafce80  ! 4272: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	.word 0x8780204f  ! 4273: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f649e0  ! 4274: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	.word 0xd4f5e000  ! 4275: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	.word 0xdecc0400  ! 4276: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r15
	.word 0xd4af8e80  ! 4277: STBA_R	stba	%r10, [%r30 + %r0] 0x74
	.word 0xd8f7ce60  ! 4278: STXA_R	stxa	%r12, [%r31 + %r0] 0x73
	mov	0x30, %r16
	.word 0xd2b7ce60  ! 4280: STHA_R	stha	%r9, [%r31 + %r0] 0x73
	.word 0xd89504a0  ! 4281: LDUHA_R	lduha	[%r20, %r0] 0x25, %r12
	.word 0xdac4c400  ! 4282: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r13
	.word 0x87802025  ! 4283: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r19
	mov	0x70, %r19
	.word 0xd4a6a000  ! 4286: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	.word 0xd4862000  ! 4287: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r10
	mov	0x7d8, %r22
	.word 0x87802020  ! 4289: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 4290: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2bc4400  ! 4291: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0xd4aec9e0  ! 4292: STBA_R	stba	%r10, [%r27 + %r0] 0x4f
	.word 0xdabc2000  ! 4293: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4294: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 4295: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 4296: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4297: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4298: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x0, %r27
	.word 0xdab7a000  ! 4300: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 4301: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r27
	.word 0xdea5c4a0  ! 4303: STWA_R	stwa	%r15, [%r23 + %r0] 0x25
	.word 0x87802074  ! 4304: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3f8, %r23
	.word 0xd4bc6000  ! 4306: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xd0974e40  ! 4307: LDUHA_R	lduha	[%r29, %r0] 0x72, %r8
	mov	0x78, %r16
	.word 0xdaaca000  ! 4309: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	mov	0x60, %r27
	mov	0x68, %r18
	mov	0x7d0, %r20
	mov	0x30, %r27
	.word 0xdacca000  ! 4314: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	mov	0x0, %r16
	.word 0xd6d4c400  ! 4316: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	mov	0x3c0, %r22
	.word 0x87802025  ! 4318: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcc42000  ! 4319: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r14
	mov	0x3e8, %r22
	mov	0x18, %r26
	.word 0xd4a70e60  ! 4322: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	.word 0xd0d74e60  ! 4323: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r8
	.word 0xdac46000  ! 4324: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r13
	.word 0xdeb74e60  ! 4325: STHA_R	stha	%r15, [%r29 + %r0] 0x73
	.word 0x87802020  ! 4326: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdacc2000  ! 4327: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xdef7ce60  ! 4328: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 4329: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2c56000  ! 4330: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r9
	.word 0xd2ad6000  ! 4331: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0xd285a000  ! 4332: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r9
	.word 0xd2ad2000  ! 4333: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xd2b5e000  ! 4334: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	.word 0xd8f544a0  ! 4335: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	mov	0x48, %r17
	.word 0x87802025  ! 4337: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d8, %r22
	.word 0xd4afa000  ! 4339: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd4d72000  ! 4340: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	mov	0x60, %r26
	mov	0x20, %r16
	mov	0x50, %r18
	.word 0xd4f44400  ! 4344: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0xde944400  ! 4345: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	mov	0x68, %r19
	.word 0xdcc40400  ! 4347: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	.word 0xda87ce80  ! 4348: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r13
	.word 0xd4af2000  ! 4349: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	mov	0x3c0, %r20
	mov	0x8, %r24
	.word 0x87802074  ! 4352: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f42000  ! 4353: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd4ac2000  ! 4354: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0xd89c4400  ! 4355: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	.word 0xd884e000  ! 4356: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r12
	.word 0xda8fce40  ! 4357: LDUBA_R	lduba	[%r31, %r0] 0x72, %r13
	.word 0xd0cce000  ! 4358: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0xd09ca000  ! 4359: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	.word 0xd69ec9e0  ! 4360: LDDA_R	ldda	[%r27, %r0] 0x4f, %r11
	.word 0xd28609e0  ! 4361: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r9
	.word 0x8780204f  ! 4362: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf7a000  ! 4363: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x48, %r19
	.word 0xd8d48400  ! 4365: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0xda8f2000  ! 4366: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	mov	0x30, %r17
	.word 0x87802073  ! 4368: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r25
	.word 0xd8afce80  ! 4370: STBA_R	stba	%r12, [%r31 + %r0] 0x74
	mov	0x3f8, %r20
	.word 0xd89e6000  ! 4372: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r12
	mov	0x3d0, %r23
	.word 0xd4df4e40  ! 4374: LDXA_R	ldxa	[%r29, %r0] 0x72, %r10
	.word 0xd0be6000  ! 4375: STDA_I	stda	%r8, [%r25 + 0x0000] %asi
	.word 0x87802073  ! 4376: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0bce000  ! 4377: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 4378: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4379: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0dfa000  ! 4380: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	mov	0x8, %r24
	.word 0xd0a76000  ! 4382: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 4383: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcccc400  ! 4384: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	.word 0x87802020  ! 4385: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r16
	mov	0x20, %r18
	.word 0xd2dc6000  ! 4388: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r9
	.word 0xd4a5c4a0  ! 4389: STWA_R	stwa	%r10, [%r23 + %r0] 0x25
	mov	0x28, %r24
	.word 0xdabc2000  ! 4391: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xd2b78e40  ! 4392: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	mov	0x70, %r25
	mov	0x28, %r26
	.word 0xde9ce000  ! 4395: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	mov	0x30, %r25
	.word 0xded4e000  ! 4397: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	.word 0x87802072  ! 4398: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc844400  ! 4399: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	.word 0x87802020  ! 4400: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r17
	.word 0xd88e2000  ! 4402: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r12
	.word 0xd8a62000  ! 4403: STWA_I	stwa	%r12, [%r24 + 0x0000] %asi
	.word 0xd8f6e000  ! 4404: STXA_I	stxa	%r12, [%r27 + 0x0000] %asi
	.word 0xd8b62000  ! 4405: STHA_I	stha	%r12, [%r24 + 0x0000] %asi
	mov	0x70, %r24
	mov	0x48, %r17
	.word 0xd4a584a0  ! 4408: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	.word 0x87802025  ! 4409: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bfa000  ! 4410: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	mov	0x30, %r25
	.word 0xd6bfce60  ! 4412: STDA_R	stda	%r11, [%r31 + %r0] 0x73
	.word 0xd8bf8e60  ! 4413: STDA_R	stda	%r12, [%r30 + %r0] 0x73
	.word 0xd2dfce40  ! 4414: LDXA_R	ldxa	[%r31, %r0] 0x72, %r9
	mov	0x3c8, %r20
	.word 0xdcc504a0  ! 4416: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r14
	.word 0xdab609e0  ! 4417: STHA_R	stha	%r13, [%r24 + %r0] 0x4f
	.word 0xde85c4a0  ! 4418: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r15
	.word 0xd2f76000  ! 4419: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xd29f6000  ! 4420: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xd2b76000  ! 4421: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2f72000  ! 4422: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xda8609e0  ! 4423: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r13
	.word 0xd2cf6000  ! 4424: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	.word 0xd2f7a000  ! 4425: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	mov	0x10, %r16
	.word 0x8780204f  ! 4427: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r16
	mov	0x50, %r27
	.word 0xd2b76000  ! 4430: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd29ec9e0  ! 4431: LDDA_R	ldda	[%r27, %r0] 0x4f, %r9
	.word 0xdad48400  ! 4432: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0xd4af6000  ! 4433: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 4434: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r19
	.word 0xd4ace000  ! 4436: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 4437: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f72000  ! 4438: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 4439: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdad44400  ! 4440: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0xdeaea000  ! 4441: STBA_I	stba	%r15, [%r26 + 0x0000] %asi
	.word 0xdea62000  ! 4442: STWA_I	stwa	%r15, [%r24 + 0x0000] %asi
	mov	0x18, %r24
	mov	0x40, %r26
	.word 0xd6ac8400  ! 4445: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xd6f78e60  ! 4446: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	.word 0xda966000  ! 4447: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r13
	.word 0xd0af4e80  ! 4448: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	.word 0xd4b62000  ! 4449: STHA_I	stha	%r10, [%r24 + 0x0000] %asi
	.word 0xdabd04a0  ! 4450: STDA_R	stda	%r13, [%r20 + %r0] 0x25
	.word 0xd8a62000  ! 4451: STWA_I	stwa	%r12, [%r24 + 0x0000] %asi
	.word 0xd88ea000  ! 4452: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r12
	mov	0x3c0, %r23
	.word 0xd8b6e000  ! 4454: STHA_I	stha	%r12, [%r27 + 0x0000] %asi
	.word 0xda8fce60  ! 4455: LDUBA_R	lduba	[%r31, %r0] 0x73, %r13
	.word 0xd696e000  ! 4456: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	.word 0xd4d584a0  ! 4457: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r10
	mov	0x7d0, %r20
	.word 0xd0848400  ! 4459: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r8
	.word 0xd8ccc400  ! 4460: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r12
	.word 0xd4aee000  ! 4461: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	mov	0x7f0, %r21
	.word 0x87802020  ! 4463: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a42000  ! 4464: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0xdcdc4400  ! 4465: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	.word 0xde9e89e0  ! 4466: LDDA_R	ldda	[%r26, %r0] 0x4f, %r15
	.word 0x87802020  ! 4467: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r23
	.word 0xda8544a0  ! 4469: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r13
	mov	0x3f8, %r21
	.word 0xdcd4a000  ! 4471: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	.word 0xdad78e40  ! 4472: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r13
	.word 0xdabc6000  ! 4473: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xdad46000  ! 4474: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	.word 0xd6a78e80  ! 4475: STWA_R	stwa	%r11, [%r30 + %r0] 0x74
	.word 0xdcb4e000  ! 4476: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xdccca000  ! 4477: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	.word 0xdcc78e60  ! 4478: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r14
	.word 0xd2b46000  ! 4479: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 4480: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2848400  ! 4481: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r9
	.word 0x87802020  ! 4482: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8dc2000  ! 4483: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0xdab48400  ! 4484: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0xd4a4e000  ! 4485: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 4486: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4d4a000  ! 4487: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0xdcb44400  ! 4488: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0xda8ce000  ! 4489: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	mov	0x28, %r26
	.word 0x87802025  ! 4491: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4492: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r16
	.word 0xda8fa000  ! 4494: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0x87802072  ! 4495: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a609e0  ! 4496: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	.word 0xd2df0e60  ! 4497: LDXA_R	ldxa	[%r28, %r0] 0x73, %r9
	.word 0xdcbce000  ! 4498: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 4499: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcc7e000  ! 4500: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0x87802025  ! 4501: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r26
	.word 0xdcf7e000  ! 4503: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdca7a000  ! 4504: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xd2bcc400  ! 4505: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0x87802074  ! 4506: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 4507: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcc72000  ! 4508: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xdc87a000  ! 4509: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	mov	0x3f8, %r21
	.word 0x87802072  ! 4511: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbc2000  ! 4512: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xdc846000  ! 4513: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4514: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccc6000  ! 4515: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	mov	0x7d8, %r22
	.word 0xdcace000  ! 4517: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0xd2aec9e0  ! 4518: STBA_R	stba	%r9, [%r27 + %r0] 0x4f
	mov	0x3e0, %r23
	.word 0xd69c6000  ! 4520: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r11
	.word 0xd6842000  ! 4521: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r11
	.word 0xdef7ce40  ! 4522: STXA_R	stxa	%r15, [%r31 + %r0] 0x72
	.word 0xd4d7ce40  ! 4523: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r10
	.word 0xd2f78e80  ! 4524: STXA_R	stxa	%r9, [%r30 + %r0] 0x74
	.word 0x87802073  ! 4525: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f8, %r20
	.word 0xd0af8e80  ! 4527: STBA_R	stba	%r8, [%r30 + %r0] 0x74
	.word 0xd0856000  ! 4528: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r8
	.word 0xd0c78e80  ! 4529: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r8
	.word 0xd8ada000  ! 4530: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0xd8a5a000  ! 4531: STWA_I	stwa	%r12, [%r22 + 0x0000] %asi
	mov	0x78, %r16
	mov	0x7c0, %r21
	.word 0xd0ac8400  ! 4534: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xdcbd6000  ! 4535: STDA_I	stda	%r14, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 4536: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc95e000  ! 4537: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r14
	.word 0xdcf5a000  ! 4538: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	.word 0xd0d584a0  ! 4539: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r8
	.word 0xdac78e80  ! 4540: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r13
	mov	0x68, %r24
	.word 0x87802025  ! 4542: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cf8e60  ! 4543: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r10
	.word 0xd4cda000  ! 4544: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r10
	mov	0x7d0, %r23
	.word 0xd4956000  ! 4546: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r10
	.word 0x87802020  ! 4547: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f7e000  ! 4548: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4ae49e0  ! 4549: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0x87802074  ! 4550: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacd04a0  ! 4551: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r13
	.word 0xdcd48400  ! 4552: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	mov	0x7f0, %r20
	mov	0x3e0, %r23
	.word 0xd6944400  ! 4555: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	.word 0x87802072  ! 4556: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4557: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cc4400  ! 4558: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	.word 0xdec4e000  ! 4559: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	.word 0xdecc2000  ! 4560: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	.word 0x87802073  ! 4561: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde8ee000  ! 4562: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r15
	.word 0x87802025  ! 4563: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2944400  ! 4564: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	.word 0xd0ac6000  ! 4565: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	mov	0x50, %r24
	.word 0x87802072  ! 4567: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0df6000  ! 4568: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0xdacc4400  ! 4569: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	.word 0x87802072  ! 4570: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b78e80  ! 4571: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	.word 0xdc9d84a0  ! 4572: LDDA_R	ldda	[%r22, %r0] 0x25, %r14
	.word 0x87802073  ! 4573: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 4574: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd497e000  ! 4575: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	.word 0xd2bd44a0  ! 4576: STDA_R	stda	%r9, [%r21 + %r0] 0x25
	.word 0xd0afe000  ! 4577: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0f504a0  ! 4578: STXA_R	stxa	%r8, [%r20 + %r0] 0x25
	.word 0xd0c7a000  ! 4579: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xd8d74e60  ! 4580: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r12
	.word 0xd2d544a0  ! 4581: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r9
	.word 0x8780204f  ! 4582: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda970e40  ! 4583: LDUHA_R	lduha	[%r28, %r0] 0x72, %r13
	.word 0x87802072  ! 4584: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 4585: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r18
	.word 0x87802074  ! 4587: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b44400  ! 4588: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0x87802020  ! 4589: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r22
	.word 0xdc872000  ! 4591: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcc7a000  ! 4592: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xdc8fe000  ! 4593: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xdcaf6000  ! 4594: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	mov	0x40, %r25
	.word 0xdc9f6000  ! 4596: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xdcafe000  ! 4597: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xd0cf0e40  ! 4598: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r8
	.word 0x87802072  ! 4599: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 4600: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f70e80  ! 4601: STXA_R	stxa	%r10, [%r28 + %r0] 0x74
	.word 0xd2aee000  ! 4602: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	.word 0xd2c62000  ! 4603: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r9
	mov	0x7e0, %r21
	.word 0xd88f8e80  ! 4605: LDUBA_R	lduba	[%r30, %r0] 0x74, %r12
	mov	0x40, %r16
	.word 0xd8bea000  ! 4607: STDA_I	stda	%r12, [%r26 + 0x0000] %asi
	.word 0xd8862000  ! 4608: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r12
	.word 0xd0af8e80  ! 4609: STBA_R	stba	%r8, [%r30 + %r0] 0x74
	mov	0x58, %r18
	.word 0xdcb504a0  ! 4611: STHA_R	stha	%r14, [%r20 + %r0] 0x25
	.word 0xd4bf8e60  ! 4612: STDA_R	stda	%r10, [%r30 + %r0] 0x73
	.word 0x87802020  ! 4613: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 4614: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r24
	.word 0xdef42000  ! 4616: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xd09c4400  ! 4617: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	mov	0x40, %r18
	mov	0x30, %r26
	.word 0x87802072  ! 4620: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 4621: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd89e2000  ! 4622: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r12
	.word 0xdabfce60  ! 4623: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	.word 0xdecc4400  ! 4624: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r15
	.word 0xd8a66000  ! 4625: STWA_I	stwa	%r12, [%r25 + 0x0000] %asi
	.word 0xd8b6e000  ! 4626: STHA_I	stha	%r12, [%r27 + 0x0000] %asi
	.word 0xdc940400  ! 4627: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0x87802074  ! 4628: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c8, %r20
	.word 0x87802074  ! 4630: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8976000  ! 4631: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0x87802072  ! 4632: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 4633: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc8f0e40  ! 4634: LDUBA_R	lduba	[%r28, %r0] 0x72, %r14
	.word 0xd0b76000  ! 4635: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd0af2000  ! 4636: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0c7a000  ! 4637: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	mov	0x40, %r25
	.word 0x87802025  ! 4639: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2df0e40  ! 4640: LDXA_R	ldxa	[%r28, %r0] 0x72, %r9
	.word 0x87802072  ! 4641: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r26
	.word 0xd4af8e80  ! 4643: STBA_R	stba	%r10, [%r30 + %r0] 0x74
	.word 0xd8f5e000  ! 4644: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 4645: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc840400  ! 4646: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	mov	0x28, %r16
	.word 0xd2a48400  ! 4648: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0x87802073  ! 4649: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca7a000  ! 4650: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xd4dcc400  ! 4651: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0xd4a7e000  ! 4652: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd087ce60  ! 4653: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r8
	mov	0x70, %r17
	.word 0x87802073  ! 4655: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 4656: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x0, %r27
	.word 0xdcb70e60  ! 4658: STHA_R	stha	%r14, [%r28 + %r0] 0x73
	.word 0xded44400  ! 4659: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	.word 0x8780204f  ! 4660: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 4661: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4662: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a46000  ! 4663: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd6adc4a0  ! 4664: STBA_R	stba	%r11, [%r23 + %r0] 0x25
	mov	0x38, %r18
	.word 0xdac74e40  ! 4666: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r13
	.word 0xde8f0e80  ! 4667: LDUBA_R	lduba	[%r28, %r0] 0x74, %r15
	.word 0xd6844400  ! 4668: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r11
	.word 0xdea40400  ! 4669: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xdec4a000  ! 4670: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xde9ce000  ! 4671: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0x87802072  ! 4672: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r16
	.word 0xdece09e0  ! 4674: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r15
	.word 0xd2f7a000  ! 4675: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xd2df6000  ! 4676: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0xdec44400  ! 4677: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0xd0c7a000  ! 4678: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0x87802072  ! 4679: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0bca000  ! 4680: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0xd0cd44a0  ! 4681: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r8
	mov	0x0, %r25
	.word 0x87802074  ! 4683: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r17
	.word 0xd6bec9e0  ! 4685: STDA_R	stda	%r11, [%r27 + %r0] 0x4f
	.word 0xd08f4e80  ! 4686: LDUBA_R	lduba	[%r29, %r0] 0x74, %r8
	.word 0x87802025  ! 4687: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcac8400  ! 4688: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xd497a000  ! 4689: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0xd28609e0  ! 4690: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r9
	.word 0xda878e80  ! 4691: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r13
	mov	0x70, %r26
	.word 0xd0c76000  ! 4693: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0afa000  ! 4694: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	mov	0x70, %r24
	mov	0x7e0, %r20
	.word 0xdcb70e80  ! 4697: STHA_R	stha	%r14, [%r28 + %r0] 0x74
	mov	0x8, %r19
	.word 0xd49f6000  ! 4699: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	mov	0x38, %r24
	mov	0x20, %r18
	.word 0xd487e000  ! 4702: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd49f6000  ! 4703: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0xd8b40400  ! 4704: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	mov	0x38, %r18
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdef584a0  ! 4707: STXA_R	stxa	%r15, [%r22 + %r0] 0x25
	mov	0x7f8, %r21
	.word 0xd2f78e40  ! 4709: STXA_R	stxa	%r9, [%r30 + %r0] 0x72
	.word 0xd0b70e40  ! 4710: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	mov	0x28, %r16
	.word 0xd4de89e0  ! 4712: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r10
	.word 0xd4c5c4a0  ! 4713: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r10
	.word 0xdcd504a0  ! 4714: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r14
	.word 0xd4874e80  ! 4715: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r10
	.word 0xd0844400  ! 4716: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r8
	.word 0xdc974e80  ! 4717: LDUHA_R	lduha	[%r29, %r0] 0x74, %r14
	mov	0x30, %r18
	.word 0xd8df2000  ! 4719: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xd0f70e60  ! 4720: STXA_R	stxa	%r8, [%r28 + %r0] 0x73
	.word 0x87802020  ! 4721: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r25
	mov	0x3d8, %r20
	.word 0x87802020  ! 4724: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2974e60  ! 4725: LDUHA_R	lduha	[%r29, %r0] 0x73, %r9
	.word 0xdcbf2000  ! 4726: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	mov	0x3c0, %r22
	mov	0x20, %r18
	.word 0xdcc7e000  ! 4729: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdcf72000  ! 4731: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xd2a74e60  ! 4732: STWA_R	stwa	%r9, [%r29 + %r0] 0x73
	.word 0x87802020  ! 4733: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r25
	.word 0xd6afce60  ! 4735: STBA_R	stba	%r11, [%r31 + %r0] 0x73
	.word 0xdcafce60  ! 4736: STBA_R	stba	%r14, [%r31 + %r0] 0x73
	.word 0x87802020  ! 4737: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4738: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf584a0  ! 4739: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	.word 0xd6be89e0  ! 4740: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	.word 0xd4bfe000  ! 4741: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd6d7ce40  ! 4742: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r11
	mov	0x8, %r18
	.word 0xd8f7e000  ! 4744: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xde9f0e40  ! 4745: LDDA_R	ldda	[%r28, %r0] 0x72, %r15
	mov	0x3d0, %r20
	.word 0xdcaf8e80  ! 4747: STBA_R	stba	%r14, [%r30 + %r0] 0x74
	.word 0x87802074  ! 4748: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0bd44a0  ! 4749: STDA_R	stda	%r8, [%r21 + %r0] 0x25
	mov	0x10, %r16
	.word 0xd0a7ce80  ! 4751: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	.word 0xd0d7a000  ! 4752: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0xd0c7e000  ! 4753: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	mov	0x48, %r25
	.word 0xd2d40400  ! 4755: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	.word 0xdaf76000  ! 4756: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 4757: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4758: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d44400  ! 4759: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0x87802073  ! 4760: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r25
	.word 0x87802020  ! 4762: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 4763: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeaf6000  ! 4764: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xded76000  ! 4765: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0xdc878e40  ! 4766: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r14
	mov	0x70, %r18
	mov	0x3e8, %r21
	.word 0xd8dc8400  ! 4769: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xd4a74e60  ! 4770: STWA_R	stwa	%r10, [%r29 + %r0] 0x73
	.word 0xdcf544a0  ! 4771: STXA_R	stxa	%r14, [%r21 + %r0] 0x25
	mov	0x20, %r16
	mov	0x3e8, %r21
	mov	0x30, %r27
	.word 0xded72000  ! 4775: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0x87802025  ! 4776: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0944400  ! 4777: LDUHA_R	lduha	[%r17, %r0] 0x20, %r8
	.word 0x87802020  ! 4778: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r17
	mov	0x7e8, %r20
	.word 0x87802073  ! 4781: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdead84a0  ! 4782: STBA_R	stba	%r15, [%r22 + %r0] 0x25
	.word 0xdcd70e40  ! 4783: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r14
	mov	0x18, %r17
	mov	0x7f8, %r21
	.word 0xd4a5e000  ! 4786: STWA_I	stwa	%r10, [%r23 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0xdcb74e80  ! 4788: STHA_R	stha	%r14, [%r29 + %r0] 0x74
	.word 0xd6874e80  ! 4789: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r11
	mov	0x3c8, %r21
	.word 0x87802072  ! 4791: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d8, %r22
	.word 0xd2cfa000  ! 4793: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	.word 0xd2bfe000  ! 4794: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd28fa000  ! 4795: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	.word 0xd2b76000  ! 4796: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xdeb544a0  ! 4797: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	.word 0x87802025  ! 4798: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4799: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r19
	.word 0xd294c400  ! 4801: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	.word 0xda9f6000  ! 4802: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdaf7e000  ! 4804: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 4805: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r25
	mov	0x3d0, %r22
	.word 0x8780204f  ! 4808: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc9fce80  ! 4809: LDDA_R	ldda	[%r31, %r0] 0x74, %r14
	mov	0x68, %r26
	mov	0x8, %r24
	.word 0xd6af2000  ! 4812: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xdc94c400  ! 4813: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	.word 0xd2bf2000  ! 4814: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xdcf609e0  ! 4815: STXA_R	stxa	%r14, [%r24 + %r0] 0x4f
	.word 0xd8dd44a0  ! 4816: LDXA_R	ldxa	[%r21, %r0] 0x25, %r12
	.word 0xdac76000  ! 4817: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0xdec44400  ! 4818: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0xd4a609e0  ! 4819: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	mov	0x3d0, %r22
	.word 0xdabfe000  ! 4821: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xdacf2000  ! 4822: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xde940400  ! 4823: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0x87802020  ! 4824: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f649e0  ! 4825: STXA_R	stxa	%r12, [%r25 + %r0] 0x4f
	.word 0xd2de49e0  ! 4826: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r9
	.word 0x8780204f  ! 4827: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e0, %r23
	.word 0x87802074  ! 4829: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd68f0e80  ! 4830: LDUBA_R	lduba	[%r28, %r0] 0x74, %r11
	.word 0xdad4c400  ! 4831: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	mov	0x70, %r25
	.word 0x87802072  ! 4833: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2bfce40  ! 4834: STDA_R	stda	%r9, [%r31 + %r0] 0x72
	.word 0xdcf44400  ! 4835: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xd2a7e000  ! 4836: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	mov	0x50, %r17
	.word 0xd287e000  ! 4838: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0xd4f649e0  ! 4839: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	.word 0xd8870e60  ! 4840: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r12
	.word 0xda972000  ! 4841: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0xdab72000  ! 4842: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xdaafa000  ! 4844: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdadf2000  ! 4845: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0xdaaf2000  ! 4846: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xda8fa000  ! 4847: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xda976000  ! 4848: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	.word 0xdab7e000  ! 4849: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xd09609e0  ! 4850: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r8
	.word 0xd8bf8e60  ! 4851: STDA_R	stda	%r12, [%r30 + %r0] 0x73
	mov	0x7e0, %r21
	.word 0xd48e09e0  ! 4853: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r10
	.word 0x87802020  ! 4854: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeaf2000  ! 4855: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xd4a7ce60  ! 4856: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	.word 0xdcac4400  ! 4857: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	.word 0xd0a7e000  ! 4858: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0976000  ! 4859: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	mov	0x0, %r24
	.word 0xdcf74e80  ! 4861: STXA_R	stxa	%r14, [%r29 + %r0] 0x74
	mov	0x28, %r27
	.word 0xd0ac8400  ! 4863: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0x87802020  ! 4864: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f4a000  ! 4865: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0xd0bf8e80  ! 4866: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	.word 0xd4f544a0  ! 4867: STXA_R	stxa	%r10, [%r21 + %r0] 0x25
	.word 0xdecf4e80  ! 4868: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r15
	.word 0x87802072  ! 4869: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a6e000  ! 4870: STWA_I	stwa	%r10, [%r27 + 0x0000] %asi
	.word 0xd2f649e0  ! 4871: STXA_R	stxa	%r9, [%r25 + %r0] 0x4f
	mov	0x50, %r17
	.word 0xdc9e2000  ! 4873: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r14
	mov	0x58, %r27
	.word 0xd8974e80  ! 4875: LDUHA_R	lduha	[%r29, %r0] 0x74, %r12
	.word 0xd6d62000  ! 4876: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r11
	.word 0xd686a000  ! 4877: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r11
	.word 0xd4bfce60  ! 4878: STDA_R	stda	%r10, [%r31 + %r0] 0x73
	mov	0x38, %r25
	mov	0x48, %r18
	mov	0x7d0, %r22
	.word 0xd0866000  ! 4882: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 4883: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d8, %r21
	mov	0x30, %r18
	.word 0xd0aca000  ! 4886: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xd8cf8e60  ! 4887: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r12
	.word 0xd28ce000  ! 4888: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	mov	0x30, %r17
	.word 0x87802020  ! 4890: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4891: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r23
	mov	0x30, %r24
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd29fe000  ! 4895: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	mov	0x3c0, %r23
	mov	0x18, %r24
	.word 0xd2dfe000  ! 4898: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	mov	0x8, %r16
	.word 0xd28f6000  ! 4900: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0x87802073  ! 4901: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f6c9e0  ! 4902: STXA_R	stxa	%r9, [%r27 + %r0] 0x4f
	mov	0x20, %r17
	.word 0xdcb48400  ! 4904: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xde870e60  ! 4905: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r15
	.word 0x87802020  ! 4906: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c76000  ! 4907: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	mov	0x58, %r16
	.word 0xd4bf2000  ! 4909: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	mov	0x40, %r19
	.word 0xd4af2000  ! 4911: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd487a000  ! 4912: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4d44400  ! 4913: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0xdc9504a0  ! 4914: LDUHA_R	lduha	[%r20, %r0] 0x25, %r14
	.word 0x87802020  ! 4915: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2afe000  ! 4916: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd2bf6000  ! 4917: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd297e000  ! 4918: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	.word 0xd4a70e40  ! 4919: STWA_R	stwa	%r10, [%r28 + %r0] 0x72
	mov	0x28, %r25
	.word 0xd0a72000  ! 4921: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xd0afa000  ! 4922: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd0a7e000  ! 4923: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xdaa44400  ! 4924: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	mov	0x3e8, %r23
	mov	0x0, %r18
	mov	0x0, %r16
	mov	0x20, %r24
	.word 0xd6d689e0  ! 4929: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r11
	.word 0x87802073  ! 4930: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r26
	.word 0x87802020  ! 4932: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8f0e60  ! 4933: LDUBA_R	lduba	[%r28, %r0] 0x73, %r15
	.word 0xdef584a0  ! 4934: STXA_R	stxa	%r15, [%r22 + %r0] 0x25
	.word 0xdcd46000  ! 4935: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	.word 0xdcbca000  ! 4936: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdcbc2000  ! 4937: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	mov	0x40, %r18
	.word 0xdcace000  ! 4939: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0xdc9ce000  ! 4940: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4941: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r18
	mov	0x70, %r18
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802072  ! 4945: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc956000  ! 4946: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r14
	mov	0x78, %r27
	.word 0xd2bf4e60  ! 4948: STDA_R	stda	%r9, [%r29 + %r0] 0x73
	.word 0xd8a7ce80  ! 4949: STWA_R	stwa	%r12, [%r31 + %r0] 0x74
	.word 0xdccd2000  ! 4950: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r14
	mov	0x48, %r17
	.word 0xd6b689e0  ! 4952: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	mov	0x28, %r24
	.word 0xd2ae49e0  ! 4954: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	.word 0xdc9d6000  ! 4955: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r14
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x50, %r18
	.word 0xdcb5e000  ! 4958: STHA_I	stha	%r14, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 4959: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf4e000  ! 4960: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	mov	0x7f0, %r22
	.word 0xdccf0e40  ! 4962: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r14
	.word 0x87802074  ! 4963: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdedc6000  ! 4964: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r15
	.word 0xdef46000  ! 4965: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xded4a000  ! 4966: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	.word 0xdeb4e000  ! 4967: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0xd6a70e60  ! 4968: STWA_R	stwa	%r11, [%r28 + %r0] 0x73
	.word 0xd2a649e0  ! 4969: STWA_R	stwa	%r9, [%r25 + %r0] 0x4f
	mov	0x70, %r16
	.word 0xd8f4a000  ! 4971: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xd0d40400  ! 4972: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	.word 0xdaa4a000  ! 4973: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xdab4a000  ! 4975: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 4976: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdade6000  ! 4977: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r13
	.word 0xd0a4c400  ! 4978: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	mov	0x50, %r17
	.word 0xd8a6e000  ! 4980: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	.word 0xd8ce2000  ! 4981: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4982: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r25
	mov	0x7c0, %r23
	.word 0xd8b584a0  ! 4985: STHA_R	stha	%r12, [%r22 + %r0] 0x25
	.word 0xd8bf6000  ! 4986: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	mov	0x70, %r25
	mov	0x60, %r24
	.word 0xde8649e0  ! 4989: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r15
	.word 0xd0dfa000  ! 4990: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	mov	0x7f0, %r22
	.word 0xd6cfce40  ! 4992: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r11
	.word 0xdeaf2000  ! 4993: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	mov	0x20, %r18
	.word 0xd8a44400  ! 4995: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	mov	0x0, %r19
	.word 0xd0af2000  ! 4997: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0a72000  ! 4998: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x70, %r24
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_2:
	.word 0xd2a5e000  ! 1: STWA_I	stwa	%r9, [%r23 + 0x0000] %asi
	.word 0xd2dd2000  ! 2: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r9
	.word 0xd4f649e0  ! 3: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	mov	0x7f8, %r20
	mov	0x30, %r19
	mov	0x18, %r19
	.word 0xdcd44400  ! 7: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	.word 0xd2b48400  ! 8: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xda8f4e80  ! 9: LDUBA_R	lduba	[%r29, %r0] 0x74, %r13
	.word 0xd89ec9e0  ! 10: LDDA_R	ldda	[%r27, %r0] 0x4f, %r12
	.word 0xda8f0e40  ! 11: LDUBA_R	lduba	[%r28, %r0] 0x72, %r13
	mov	0x0, %r27
	.word 0xd4af0e40  ! 13: STBA_R	stba	%r10, [%r28 + %r0] 0x72
	.word 0xd29ec9e0  ! 14: LDDA_R	ldda	[%r27, %r0] 0x4f, %r9
	.word 0x87802072  ! 15: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 16: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd29c8400  ! 17: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	mov	0x8, %r25
	.word 0x87802020  ! 19: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0dc0400  ! 20: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xd4af0e60  ! 21: STBA_R	stba	%r10, [%r28 + %r0] 0x73
	.word 0xd0c7ce40  ! 22: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r8
	.word 0x87802025  ! 23: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf48400  ! 24: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0x87802020  ! 25: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda94c400  ! 26: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	.word 0xdcac6000  ! 27: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 28: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r27
	ta	T_CHANGE_PRIV	! macro
	mov	0x50, %r27
	.word 0xdaf74e80  ! 32: STXA_R	stxa	%r13, [%r29 + %r0] 0x74
	.word 0xde8ec9e0  ! 33: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r15
	.word 0x87802072  ! 34: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbda000  ! 35: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	.word 0xd8a649e0  ! 36: STWA_R	stwa	%r12, [%r25 + %r0] 0x4f
	.word 0x87802025  ! 37: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 38: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 39: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdab70e40  ! 40: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	.word 0xd28f4e40  ! 41: LDUBA_R	lduba	[%r29, %r0] 0x72, %r9
	.word 0xdcbc6000  ! 42: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 43: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc85e000  ! 44: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r14
	.word 0xdc9da000  ! 45: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r14
	.word 0xdc8d6000  ! 46: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r14
	mov	0x40, %r26
	.word 0xdcc5e000  ! 48: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r14
	.word 0xd4b70e60  ! 49: STHA_R	stha	%r10, [%r28 + %r0] 0x73
	.word 0xd0aec9e0  ! 50: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	.word 0xd8bde000  ! 51: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0xd8b52000  ! 52: STHA_I	stha	%r12, [%r20 + 0x0000] %asi
	.word 0xd8d5a000  ! 53: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r12
	mov	0x28, %r17
	.word 0xd4dd84a0  ! 55: LDXA_R	ldxa	[%r22, %r0] 0x25, %r10
	.word 0xd0956000  ! 56: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r8
	.word 0xd0974e60  ! 57: LDUHA_R	lduha	[%r29, %r0] 0x73, %r8
	.word 0x87802025  ! 58: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2df2000  ! 59: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd88d44a0  ! 60: LDUBA_R	lduba	[%r21, %r0] 0x25, %r12
	mov	0x3f8, %r21
	.word 0xd4f78e80  ! 62: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	.word 0xd2872000  ! 63: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	.word 0xd8944400  ! 64: LDUHA_R	lduha	[%r17, %r0] 0x20, %r12
	.word 0x87802020  ! 65: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded70e60  ! 66: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r15
	.word 0xdcd4a000  ! 67: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	ta	T_CHANGE_PRIV	! macro
	.word 0xd6acc400  ! 69: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xdca44400  ! 70: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0x87802025  ! 71: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb76000  ! 72: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0xdc976000  ! 74: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	mov	0x10, %r27
	.word 0x87802025  ! 76: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 77: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r17
	.word 0xdc87a000  ! 79: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcdf6000  ! 80: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xdcaf6000  ! 81: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xd0878e40  ! 82: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r8
	.word 0xd08d44a0  ! 83: LDUBA_R	lduba	[%r21, %r0] 0x25, %r8
	.word 0xdebf2000  ! 84: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xded72000  ! 85: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	mov	0x7d0, %r23
	.word 0xdebfa000  ! 87: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xd8a70e80  ! 88: STWA_R	stwa	%r12, [%r28 + %r0] 0x74
	.word 0xd6f72000  ! 89: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6df2000  ! 90: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0x87802025  ! 91: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4944400  ! 92: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	.word 0xdeb62000  ! 93: STHA_I	stha	%r15, [%r24 + 0x0000] %asi
	.word 0xd49fce80  ! 94: LDDA_R	ldda	[%r31, %r0] 0x74, %r10
	.word 0xd4b4c400  ! 95: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0xd4bec9e0  ! 96: STDA_R	stda	%r10, [%r27 + %r0] 0x4f
	.word 0xd8c66000  ! 97: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r12
	.word 0xdca6c9e0  ! 98: STWA_R	stwa	%r14, [%r27 + %r0] 0x4f
	.word 0xd2a66000  ! 99: STWA_I	stwa	%r9, [%r25 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xd29c4400  ! 101: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	mov	0x38, %r18
	.word 0xdaf62000  ! 103: STXA_I	stxa	%r13, [%r24 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0xde8d04a0  ! 105: LDUBA_R	lduba	[%r20, %r0] 0x25, %r15
	.word 0xd8cf8e80  ! 106: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r12
	.word 0x87802072  ! 107: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdccf6000  ! 108: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xd4f78e80  ! 109: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	.word 0xdadf6000  ! 110: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	mov	0x3c0, %r22
	.word 0xdaa7a000  ! 112: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xdab7a000  ! 113: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdaf7e000  ! 114: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xd4a40400  ! 115: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	mov	0x78, %r16
	mov	0x7f0, %r22
	.word 0xd6a78e60  ! 118: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	mov	0x7d0, %r22
	.word 0xd8c609e0  ! 120: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r12
	mov	0x3c0, %r20
	.word 0xdcce89e0  ! 122: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r14
	mov	0x3f8, %r21
	.word 0xdcdfce40  ! 124: LDXA_R	ldxa	[%r31, %r0] 0x72, %r14
	.word 0xd0bf6000  ! 125: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd4a48400  ! 126: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0x87802073  ! 127: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcc46000  ! 128: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r14
	.word 0xdccc2000  ! 129: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r14
	.word 0xdc8c2000  ! 130: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r14
	mov	0x8, %r17
	mov	0x30, %r17
	mov	0x8, %r16
	.word 0xdc846000  ! 134: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	.word 0xdccc6000  ! 135: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	.word 0xdcf42000  ! 136: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0xdcb42000  ! 137: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xdca42000  ! 138: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xdcf4e000  ! 139: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	mov	0x3f0, %r23
	.word 0xdcd42000  ! 141: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	.word 0xdea7ce80  ! 142: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	.word 0xd2d70e60  ! 143: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r9
	mov	0x70, %r19
	.word 0xd0f4e000  ! 145: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xd6df0e80  ! 146: LDXA_R	ldxa	[%r28, %r0] 0x74, %r11
	mov	0x50, %r17
	.word 0xd0dcc400  ! 148: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0xd48f8e80  ! 149: LDUBA_R	lduba	[%r30, %r0] 0x74, %r10
	.word 0xd6ace000  ! 150: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0xd6c42000  ! 151: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r11
	.word 0xd6bca000  ! 152: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	.word 0xd6a42000  ! 153: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xd68c2000  ! 154: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r11
	.word 0xd8cc0400  ! 155: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	.word 0xde8c0400  ! 156: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0xdc84e000  ! 157: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r14
	.word 0xdc9c6000  ! 158: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r14
	.word 0xdc94e000  ! 159: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	.word 0x87802020  ! 160: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcad2000  ! 161: STBA_I	stba	%r14, [%r20 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0xdca52000  ! 163: STWA_I	stwa	%r14, [%r20 + 0x0000] %asi
	.word 0x8780204f  ! 164: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc8d6000  ! 165: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r14
	.word 0xd2b44400  ! 166: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0xdeaf8e60  ! 167: STBA_R	stba	%r15, [%r30 + %r0] 0x73
	.word 0xd8952000  ! 168: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r12
	.word 0xd8f5a000  ! 169: STXA_I	stxa	%r12, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 170: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8de2000  ! 171: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r12
	.word 0xde8dc4a0  ! 172: LDUBA_R	lduba	[%r23, %r0] 0x25, %r15
	.word 0xd8f62000  ! 173: STXA_I	stxa	%r12, [%r24 + 0x0000] %asi
	.word 0x8780204f  ! 174: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdecf4e80  ! 175: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r15
	.word 0x87802025  ! 176: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcc76000  ! 177: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xd4bf4e80  ! 178: STDA_R	stda	%r10, [%r29 + %r0] 0x74
	.word 0xd8afce40  ! 179: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	.word 0xdad78e60  ! 180: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r13
	.word 0xdea76000  ! 181: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xd08e49e0  ! 182: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r8
	.word 0xde8f0e80  ! 183: LDUBA_R	lduba	[%r28, %r0] 0x74, %r15
	.word 0x87802074  ! 184: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeb46000  ! 185: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0xdeb46000  ! 186: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0xd0a7ce40  ! 187: STWA_R	stwa	%r8, [%r31 + %r0] 0x72
	.word 0xdadce000  ! 188: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xdacce000  ! 189: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r13
	.word 0xdadfce80  ! 190: LDXA_R	ldxa	[%r31, %r0] 0x74, %r13
	.word 0x87802073  ! 191: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bfe000  ! 192: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xdab70e40  ! 193: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	mov	0x78, %r17
	mov	0x18, %r27
	.word 0xdcb7a000  ! 196: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xd0cf4e60  ! 197: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r8
	.word 0xd2d7e000  ! 198: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xda8fce40  ! 199: LDUBA_R	lduba	[%r31, %r0] 0x72, %r13
	mov	0x8, %r25
	mov	0x48, %r17
	.word 0x8780204f  ! 202: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc85e000  ! 203: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r14
	.word 0xdcbde000  ! 204: STDA_I	stda	%r14, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 205: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r26
	.word 0xdca72000  ! 207: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xd8de49e0  ! 208: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r12
	.word 0xdab72000  ! 209: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xd4b6c9e0  ! 210: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0xdecd44a0  ! 211: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r15
	.word 0xdeb7ce80  ! 212: STHA_R	stha	%r15, [%r31 + %r0] 0x74
	mov	0x40, %r16
	.word 0xdaa40400  ! 214: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0xdaf7a000  ! 215: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xda9f6000  ! 216: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xdab72000  ! 217: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xda8fe000  ! 219: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xdaf76000  ! 220: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	mov	0x48, %r18
	.word 0xd08f8e40  ! 222: LDUBA_R	lduba	[%r30, %r0] 0x72, %r8
	.word 0xd2a72000  ! 223: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	mov	0x20, %r19
	.word 0xd2d7e000  ! 225: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	mov	0x68, %r19
	.word 0xd88504a0  ! 227: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r12
	.word 0xdcf7a000  ! 228: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 229: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r27
	.word 0xd4df8e60  ! 231: LDXA_R	ldxa	[%r30, %r0] 0x73, %r10
	.word 0xd8cf8e80  ! 232: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r12
	.word 0x87802020  ! 233: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd484c400  ! 234: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	.word 0x87802073  ! 235: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6d44400  ! 236: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r11
	.word 0x8780204f  ! 237: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c8, %r22
	.word 0xd2b44400  ! 239: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0xd0c42000  ! 240: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r8
	.word 0xd2a5c4a0  ! 241: STWA_R	stwa	%r9, [%r23 + %r0] 0x25
	.word 0x87802020  ! 242: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd084a000  ! 243: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	.word 0xd2bf4e80  ! 244: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	.word 0x87802020  ! 245: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f72000  ! 246: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xd6a76000  ! 248: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6b76000  ! 249: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd6bf6000  ! 250: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 251: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a44400  ! 252: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xd6ce49e0  ! 253: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r11
	.word 0xdacc6000  ! 254: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	.word 0xdaa4e000  ! 255: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 256: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 257: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf72000  ! 258: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 259: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d8, %r22
	.word 0xd2f70e80  ! 261: STXA_R	stxa	%r9, [%r28 + %r0] 0x74
	.word 0xd2ae89e0  ! 262: STBA_R	stba	%r9, [%r26 + %r0] 0x4f
	.word 0xd0f40400  ! 263: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 264: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4cfe000  ! 265: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0xd497a000  ! 266: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0xdcdf4e60  ! 267: LDXA_R	ldxa	[%r29, %r0] 0x73, %r14
	.word 0xda972000  ! 268: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	mov	0x30, %r19
	mov	0x7e8, %r21
	.word 0xda87e000  ! 271: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	mov	0x8, %r24
	.word 0xdaaf6000  ! 273: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	mov	0x70, %r16
	.word 0x87802020  ! 275: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedf0e80  ! 276: LDXA_R	ldxa	[%r28, %r0] 0x74, %r15
	.word 0xd4dc6000  ! 277: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	.word 0xd4af8e40  ! 278: STBA_R	stba	%r10, [%r30 + %r0] 0x72
	.word 0xd8b584a0  ! 279: STHA_R	stha	%r12, [%r22 + %r0] 0x25
	.word 0xd0f4a000  ! 280: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 281: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 282: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0876000  ! 283: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0bf2000  ! 284: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 285: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r27
	mov	0x68, %r26
	.word 0xd0b4a000  ! 288: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xd08ce000  ! 289: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0d42000  ! 290: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r8
	mov	0x8, %r19
	mov	0x3c0, %r23
	.word 0xd0cce000  ! 293: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0cc6000  ! 294: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	.word 0xd6f584a0  ! 295: STXA_R	stxa	%r11, [%r22 + %r0] 0x25
	.word 0xdedce000  ! 296: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r15
	.word 0xd8c504a0  ! 297: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r12
	.word 0xdac74e60  ! 298: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r13
	mov	0x0, %r24
	.word 0xde84c400  ! 300: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	mov	0x50, %r17
	mov	0x28, %r19
	.word 0xdcb42000  ! 303: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xd4a4c400  ! 304: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0xdca4e000  ! 305: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcbca000  ! 306: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdcac6000  ! 307: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xdab4c400  ! 308: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xd484e000  ! 309: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r10
	mov	0x3c0, %r20
	.word 0xd4b4e000  ! 311: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xda8f4e80  ! 312: LDUBA_R	lduba	[%r29, %r0] 0x74, %r13
	.word 0xd2ac6000  ! 313: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd69689e0  ! 314: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r11
	.word 0xd6dd44a0  ! 315: LDXA_R	ldxa	[%r21, %r0] 0x25, %r11
	mov	0x30, %r27
	mov	0x8, %r26
	mov	0x0, %r17
	.word 0xd2bcc400  ! 319: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	mov	0x40, %r16
	.word 0xd88f0e60  ! 321: LDUBA_R	lduba	[%r28, %r0] 0x73, %r12
	.word 0xd4cce000  ! 322: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	.word 0xd484e000  ! 323: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r10
	.word 0xd4bca000  ! 324: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xd2df0e40  ! 326: LDXA_R	ldxa	[%r28, %r0] 0x72, %r9
	.word 0xd69c6000  ! 327: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r11
	.word 0xd68ce000  ! 328: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 329: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b6a000  ! 330: STHA_I	stha	%r11, [%r26 + 0x0000] %asi
	.word 0xd6b66000  ! 331: STHA_I	stha	%r11, [%r25 + 0x0000] %asi
	.word 0xd6bee000  ! 332: STDA_I	stda	%r11, [%r27 + 0x0000] %asi
	.word 0xd0a74e60  ! 333: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	mov	0x38, %r17
	.word 0xd0bc4400  ! 335: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xdea66000  ! 336: STWA_I	stwa	%r15, [%r25 + 0x0000] %asi
	mov	0x58, %r24
	.word 0xde8ee000  ! 338: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r15
	mov	0x48, %r27
	.word 0x87802073  ! 340: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf70e60  ! 341: STXA_R	stxa	%r14, [%r28 + %r0] 0x73
	.word 0xd29e6000  ! 342: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r9
	.word 0x87802073  ! 343: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 344: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 345: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r26
	.word 0xd2b649e0  ! 347: STHA_R	stha	%r9, [%r25 + %r0] 0x4f
	mov	0x58, %r17
	.word 0xd4cd44a0  ! 349: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r10
	.word 0xdac78e80  ! 350: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r13
	.word 0xd6cfa000  ! 351: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0xd6d76000  ! 352: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	mov	0x7f0, %r20
	.word 0x87802074  ! 354: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r18
	.word 0xdcd48400  ! 356: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	.word 0xd88fa000  ! 357: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0x87802073  ! 358: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6d7ce60  ! 359: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r11
	.word 0xdc940400  ! 360: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0xdcaea000  ! 361: STBA_I	stba	%r14, [%r26 + 0x0000] %asi
	mov	0x3e8, %r23
	.word 0xdcce2000  ! 363: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r14
	.word 0xd88cc400  ! 364: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	.word 0xdac66000  ! 365: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r13
	.word 0xdab6a000  ! 366: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	.word 0xdea70e40  ! 367: STWA_R	stwa	%r15, [%r28 + %r0] 0x72
	.word 0xd0ce6000  ! 368: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r8
	mov	0x60, %r24
	.word 0xd8c40400  ! 370: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	.word 0xd4f6c9e0  ! 371: STXA_R	stxa	%r10, [%r27 + %r0] 0x4f
	.word 0xd8cee000  ! 372: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r12
	.word 0xd8c66000  ! 373: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 374: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f48400  ! 375: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	mov	0x7e8, %r20
	.word 0xd69e09e0  ! 377: LDDA_R	ldda	[%r24, %r0] 0x4f, %r11
	.word 0xd8a4e000  ! 378: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xd8b42000  ! 379: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	mov	0x40, %r16
	.word 0x87802073  ! 381: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8a78e60  ! 382: STWA_R	stwa	%r12, [%r30 + %r0] 0x73
	.word 0xd48de000  ! 383: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r10
	.word 0xd2c44400  ! 384: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	.word 0xd2dc4400  ! 385: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xd2a48400  ! 386: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0xd4cd2000  ! 387: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r10
	.word 0xd0af8e40  ! 388: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	mov	0x58, %r27
	mov	0x20, %r17
	.word 0xdcad04a0  ! 391: STBA_R	stba	%r14, [%r20 + %r0] 0x25
	.word 0xd68de000  ! 392: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r11
	mov	0x20, %r25
	.word 0x87802072  ! 394: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f8, %r22
	.word 0xd6dfe000  ! 396: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6cf2000  ! 397: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0xdabd04a0  ! 398: STDA_R	stda	%r13, [%r20 + %r0] 0x25
	.word 0x8780204f  ! 399: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde970e60  ! 400: LDUHA_R	lduha	[%r28, %r0] 0x73, %r15
	.word 0x87802074  ! 401: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 402: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 403: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r26
	.word 0xd0f76000  ! 405: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	mov	0x48, %r25
	.word 0xd2dd04a0  ! 407: LDXA_R	ldxa	[%r20, %r0] 0x25, %r9
	.word 0xd8f7a000  ! 408: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	mov	0x3e0, %r20
	.word 0x87802072  ! 410: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4b40400  ! 411: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x8780204f  ! 413: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c0, %r21
	.word 0xdecf0e80  ! 415: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r15
	mov	0x7f0, %r23
	mov	0x3c0, %r20
	.word 0xd8a4c400  ! 418: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 419: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r16
	.word 0x87802072  ! 421: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r16
	.word 0xdecf6000  ! 423: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0x87802072  ! 424: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 425: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef46000  ! 426: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xd0d74e60  ! 427: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r8
	mov	0x50, %r24
	.word 0xd6f46000  ! 429: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0xd0ce49e0  ! 430: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r8
	.word 0x87802025  ! 431: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd49c0400  ! 432: LDDA_R	ldda	[%r16, %r0] 0x20, %r10
	mov	0x3c8, %r20
	.word 0xd6bf8e60  ! 434: STDA_R	stda	%r11, [%r30 + %r0] 0x73
	.word 0xd4a46000  ! 435: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	mov	0x50, %r26
	mov	0x10, %r26
	.word 0xd4d4a000  ! 438: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0xd6cf4e80  ! 439: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r11
	.word 0xdcbd84a0  ! 440: STDA_R	stda	%r14, [%r22 + %r0] 0x25
	.word 0xd0a74e40  ! 441: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	.word 0xd8cce000  ! 442: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r12
	mov	0x3c0, %r20
	.word 0x87802072  ! 444: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49c4400  ! 445: LDDA_R	ldda	[%r17, %r0] 0x20, %r10
	.word 0xd2d78e80  ! 446: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r9
	.word 0xd4a504a0  ! 447: STWA_R	stwa	%r10, [%r20 + %r0] 0x25
	mov	0x7c0, %r20
	.word 0x8780204f  ! 449: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0d48400  ! 450: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	.word 0xd2a70e40  ! 451: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	.word 0xd6976000  ! 452: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	.word 0xdcb78e60  ! 453: STHA_R	stha	%r14, [%r30 + %r0] 0x73
	.word 0xdabc0400  ! 454: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	mov	0x68, %r16
	.word 0xd697a000  ! 456: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	mov	0x38, %r27
	.word 0xd6a7e000  ! 458: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6a76000  ! 459: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	mov	0x3e0, %r21
	.word 0xd4ac0400  ! 461: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xdeaf8e60  ! 462: STBA_R	stba	%r15, [%r30 + %r0] 0x73
	.word 0xda970e80  ! 463: LDUHA_R	lduha	[%r28, %r0] 0x74, %r13
	.word 0xde8c8400  ! 464: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	.word 0xd2d689e0  ! 465: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r9
	.word 0xd8aec9e0  ! 466: STBA_R	stba	%r12, [%r27 + %r0] 0x4f
	.word 0xdedc0400  ! 467: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	.word 0x87802020  ! 468: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 469: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4844400  ! 470: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	mov	0x30, %r18
	.word 0xd0b44400  ! 472: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0x87802072  ! 473: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd496c9e0  ! 474: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r10
	mov	0x3d0, %r20
	.word 0xd4a76000  ! 476: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4bfe000  ! 477: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd6c649e0  ! 478: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r11
	.word 0x8780204f  ! 479: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r27
	.word 0xd69f2000  ! 481: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xd4b70e60  ! 482: STHA_R	stha	%r10, [%r28 + %r0] 0x73
	.word 0x87802072  ! 483: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab70e40  ! 484: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	.word 0xd8846000  ! 485: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	.word 0xd8a46000  ! 486: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xda8c4400  ! 487: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	mov	0x38, %r24
	.word 0xdebe89e0  ! 489: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	.word 0xd0a6c9e0  ! 490: STWA_R	stwa	%r8, [%r27 + %r0] 0x4f
	.word 0x87802073  ! 491: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbf4e40  ! 492: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	.word 0x87802025  ! 493: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8a66000  ! 494: STWA_I	stwa	%r12, [%r25 + 0x0000] %asi
	mov	0x68, %r17
	.word 0xdc978e60  ! 496: LDUHA_R	lduha	[%r30, %r0] 0x73, %r14
	.word 0xd4dfce40  ! 497: LDXA_R	ldxa	[%r31, %r0] 0x72, %r10
	.word 0xd2b649e0  ! 498: STHA_R	stha	%r9, [%r25 + %r0] 0x4f
	mov	0x3e0, %r21
	mov	0x7e8, %r21
	mov	0x7c8, %r20
	.word 0xd2c66000  ! 502: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r9
	.word 0xd2a66000  ! 503: STWA_I	stwa	%r9, [%r25 + 0x0000] %asi
	mov	0x30, %r17
	mov	0x3e0, %r21
	.word 0x87802020  ! 506: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a48400  ! 507: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0xdebfe000  ! 508: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xdebf2000  ! 509: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xde87e000  ! 510: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdccfce40  ! 511: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r14
	.word 0xdaaf2000  ! 512: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdaaf2000  ! 513: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0xdaa7e000  ! 515: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	mov	0x7c0, %r22
	.word 0x8780204f  ! 517: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x60, %r19
	.word 0xd8f5c4a0  ! 520: STXA_R	stxa	%r12, [%r23 + %r0] 0x25
	.word 0xdcdf6000  ! 521: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xdab7ce60  ! 522: STHA_R	stha	%r13, [%r31 + %r0] 0x73
	.word 0xd2848400  ! 523: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r9
	mov	0x3f0, %r21
	.word 0xd2c44400  ! 525: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	.word 0xd087ce40  ! 526: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r8
	mov	0x78, %r24
	mov	0x0, %r24
	mov	0x38, %r24
	.word 0xdeb7e000  ! 530: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xdebf2000  ! 531: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 532: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef7ce80  ! 533: STXA_R	stxa	%r15, [%r31 + %r0] 0x74
	.word 0x87802020  ! 534: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f7a000  ! 535: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	mov	0x50, %r19
	.word 0xd29f6000  ! 537: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 538: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c8, %r20
	mov	0x68, %r17
	.word 0xd2f7e000  ! 541: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xdca504a0  ! 542: STWA_R	stwa	%r14, [%r20 + %r0] 0x25
	.word 0xd4af8e60  ! 543: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	.word 0x87802025  ! 544: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 545: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 546: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ade000  ! 547: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	mov	0x40, %r27
	.word 0xd2dde000  ! 549: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r9
	.word 0x87802073  ! 550: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc8504a0  ! 551: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r14
	.word 0xdc948400  ! 552: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	.word 0x87802072  ! 553: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4bc4400  ! 554: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0xd69f8e60  ! 555: LDDA_R	ldda	[%r30, %r0] 0x73, %r11
	mov	0x30, %r27
	.word 0xd0a52000  ! 557: STWA_I	stwa	%r8, [%r20 + 0x0000] %asi
	.word 0xd0cd2000  ! 558: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r8
	mov	0x50, %r25
	.word 0x87802020  ! 560: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r19
	mov	0x3d0, %r21
	.word 0x87802072  ! 563: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a689e0  ! 564: STWA_R	stwa	%r10, [%r26 + %r0] 0x4f
	.word 0xd6bc2000  ! 565: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0xdcb7ce80  ! 567: STHA_R	stha	%r14, [%r31 + %r0] 0x74
	.word 0xd284e000  ! 568: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r9
	mov	0x3d0, %r23
	mov	0x3c0, %r22
	.word 0xd284a000  ! 571: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	.word 0xd284a000  ! 572: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	mov	0x7c0, %r21
	.word 0xd2df0e80  ! 574: LDXA_R	ldxa	[%r28, %r0] 0x74, %r9
	.word 0xd48c6000  ! 575: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r10
	mov	0x60, %r18
	.word 0x87802025  ! 577: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2ac4400  ! 578: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xdef40400  ! 579: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0xda8c4400  ! 580: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	mov	0x50, %r26
	.word 0xd8cc8400  ! 582: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0xdebce000  ! 583: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	mov	0x40, %r18
	.word 0xdef48400  ! 585: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xdadca000  ! 586: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0xdaf42000  ! 587: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0xdaace000  ! 588: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	mov	0x58, %r19
	mov	0x68, %r18
	.word 0xdacca000  ! 591: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	.word 0xd2df0e60  ! 592: LDXA_R	ldxa	[%r28, %r0] 0x73, %r9
	.word 0xdcd74e80  ! 593: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r14
	.word 0xd6b46000  ! 594: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 595: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 596: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6ace000  ! 597: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 598: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 599: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d0, %r20
	.word 0xd6b72000  ! 601: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd68fe000  ! 602: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xd2af8e80  ! 603: STBA_R	stba	%r9, [%r30 + %r0] 0x74
	.word 0x87802020  ! 604: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeac6000  ! 605: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xdea4a000  ! 606: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xd4cd84a0  ! 607: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r10
	.word 0x8780204f  ! 608: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 609: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda9da000  ! 610: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r13
	.word 0xd6ae09e0  ! 611: STBA_R	stba	%r11, [%r24 + %r0] 0x4f
	.word 0xd4f56000  ! 612: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	.word 0xd4974e80  ! 613: LDUHA_R	lduha	[%r29, %r0] 0x74, %r10
	.word 0x87802020  ! 614: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c7a000  ! 615: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6f76000  ! 616: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd8bc4400  ! 617: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 618: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e8, %r22
	.word 0xdedf4e40  ! 620: LDXA_R	ldxa	[%r29, %r0] 0x72, %r15
	mov	0x58, %r17
	.word 0xdaf7e000  ! 622: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xda9fe000  ! 623: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xd0bcc400  ! 624: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0x87802073  ! 625: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4ae6000  ! 626: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0x87802073  ! 627: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b4e000  ! 628: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xd4f4a000  ! 629: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	mov	0x28, %r16
	mov	0x3f8, %r21
	.word 0x87802020  ! 632: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef70e80  ! 633: STXA_R	stxa	%r15, [%r28 + %r0] 0x74
	.word 0x87802074  ! 634: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r21
	.word 0xd8f42000  ! 636: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xd0de09e0  ! 637: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r8
	.word 0xde9ce000  ! 638: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 639: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeb4a000  ! 640: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 641: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcddc4a0  ! 642: LDXA_R	ldxa	[%r23, %r0] 0x25, %r14
	.word 0xd0df8e60  ! 643: LDXA_R	ldxa	[%r30, %r0] 0x73, %r8
	.word 0xdebfce40  ! 644: STDA_R	stda	%r15, [%r31 + %r0] 0x72
	mov	0x70, %r24
	.word 0xd0afe000  ! 646: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xdeb40400  ! 647: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0xdaa7ce80  ! 648: STWA_R	stwa	%r13, [%r31 + %r0] 0x74
	.word 0xd8df6000  ! 649: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8f72000  ! 650: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd0b4c400  ! 651: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0xd8f78e80  ! 652: STXA_R	stxa	%r12, [%r30 + %r0] 0x74
	.word 0xdc848400  ! 653: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	.word 0xd6ac4400  ! 654: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xd49d04a0  ! 655: LDDA_R	ldda	[%r20, %r0] 0x25, %r10
	.word 0x87802020  ! 656: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bf2000  ! 657: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 658: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0afce40  ! 659: STBA_R	stba	%r8, [%r31 + %r0] 0x72
	.word 0xdaf44400  ! 660: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0xdab72000  ! 661: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	mov	0x50, %r27
	.word 0xdaf7ce60  ! 663: STXA_R	stxa	%r13, [%r31 + %r0] 0x73
	.word 0xd4d7ce80  ! 664: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r10
	mov	0x70, %r25
	.word 0xd2a78e40  ! 666: STWA_R	stwa	%r9, [%r30 + %r0] 0x72
	.word 0xd8df4e40  ! 667: LDXA_R	ldxa	[%r29, %r0] 0x72, %r12
	mov	0x78, %r17
	.word 0xdeb7e000  ! 669: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xde976000  ! 670: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	.word 0xdef72000  ! 671: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	mov	0x38, %r19
	mov	0x8, %r26
	.word 0xdccfce80  ! 674: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r14
	.word 0x87802073  ! 675: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f0, %r20
	.word 0xd4942000  ! 677: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r10
	mov	0x58, %r17
	.word 0xd2bd44a0  ! 679: STDA_R	stda	%r9, [%r21 + %r0] 0x25
	.word 0xd89c2000  ! 680: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	.word 0x87802025  ! 681: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf70e80  ! 682: STXA_R	stxa	%r14, [%r28 + %r0] 0x74
	mov	0x70, %r17
	.word 0x8780204f  ! 684: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b66000  ! 685: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	.word 0xdea44400  ! 686: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0x87802025  ! 687: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdacc4400  ! 688: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	.word 0x87802073  ! 689: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeada000  ! 690: STBA_I	stba	%r15, [%r22 + 0x0000] %asi
	.word 0xdcacc400  ! 691: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0xd4ac0400  ! 692: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xd0a48400  ! 693: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	mov	0x7c0, %r21
	.word 0xd085e000  ! 695: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r8
	.word 0xd0f56000  ! 696: STXA_I	stxa	%r8, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 697: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf40400  ! 698: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xd49e09e0  ! 699: LDDA_R	ldda	[%r24, %r0] 0x4f, %r10
	.word 0xdc870e80  ! 700: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r14
	.word 0xd89fce40  ! 701: LDDA_R	ldda	[%r31, %r0] 0x72, %r12
	.word 0xd29fce80  ! 702: LDDA_R	ldda	[%r31, %r0] 0x74, %r9
	.word 0x87802020  ! 703: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bc8400  ! 704: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0x87802074  ! 705: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0d78e80  ! 706: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r8
	.word 0xd2c74e80  ! 707: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r9
	mov	0x78, %r17
	mov	0x50, %r27
	.word 0xdec46000  ! 710: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	mov	0x3d0, %r21
	.word 0xde94a000  ! 712: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0xdea46000  ! 713: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xd6bd44a0  ! 714: STDA_R	stda	%r11, [%r21 + %r0] 0x25
	mov	0x8, %r17
	.word 0xd2f4a000  ! 716: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0xd2f4e000  ! 717: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	mov	0x0, %r17
	.word 0x87802020  ! 719: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2be6000  ! 720: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	.word 0xd2a6e000  ! 721: STWA_I	stwa	%r9, [%r27 + 0x0000] %asi
	.word 0xd2f66000  ! 722: STXA_I	stxa	%r9, [%r25 + 0x0000] %asi
	.word 0x87802025  ! 723: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda9544a0  ! 724: LDUHA_R	lduha	[%r21, %r0] 0x25, %r13
	.word 0xdcbdc4a0  ! 725: STDA_R	stda	%r14, [%r23 + %r0] 0x25
	.word 0xd4cf4e80  ! 726: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r10
	.word 0xdebf2000  ! 727: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 728: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r26
	.word 0x87802072  ! 730: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabe89e0  ! 731: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	mov	0x7e0, %r23
	.word 0xdedea000  ! 733: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r15
	.word 0xd49c0400  ! 734: LDDA_R	ldda	[%r16, %r0] 0x20, %r10
	.word 0xd6bcc400  ! 735: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0xdad74e60  ! 736: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r13
	.word 0xd6be6000  ! 737: STDA_I	stda	%r11, [%r25 + 0x0000] %asi
	.word 0x8780204f  ! 738: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d8, %r21
	mov	0x78, %r25
	ta	T_CHANGE_PRIV	! macro
	mov	0x7c8, %r21
	.word 0xd6dce000  ! 743: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	mov	0x7c0, %r23
	mov	0x3d8, %r23
	.word 0xd6b4e000  ! 746: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xd8be09e0  ! 747: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	mov	0x3d8, %r22
	.word 0xd2b4e000  ! 749: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0xd2ac2000  ! 750: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xda9f8e80  ! 751: LDDA_R	ldda	[%r30, %r0] 0x74, %r13
	.word 0xde9ec9e0  ! 752: LDDA_R	ldda	[%r27, %r0] 0x4f, %r15
	mov	0x78, %r25
	.word 0x87802074  ! 754: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 755: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb6c9e0  ! 756: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	mov	0x8, %r25
	mov	0x3d8, %r23
	.word 0xd2dfa000  ! 759: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2bfa000  ! 760: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 761: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a42000  ! 762: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	mov	0x7c0, %r21
	.word 0x8780204f  ! 764: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f4a000  ! 765: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0xd6840400  ! 766: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0xd4c46000  ! 767: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r10
	.word 0xd4a46000  ! 768: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	mov	0x28, %r19
	.word 0x87802072  ! 770: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f56000  ! 771: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	.word 0xd8f74e60  ! 772: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	.word 0xded584a0  ! 773: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r15
	.word 0xd4f48400  ! 774: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xd8a5e000  ! 775: STWA_I	stwa	%r12, [%r23 + 0x0000] %asi
	mov	0x8, %r24
	mov	0x68, %r19
	mov	0x50, %r25
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802025  ! 780: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd8bf6000  ! 782: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 783: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r16
	mov	0x28, %r26
	.word 0xdcf6c9e0  ! 786: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	mov	0x20, %r18
	.word 0x87802073  ! 788: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbd04a0  ! 789: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	.word 0xd087a000  ! 790: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0xdeb78e80  ! 791: STHA_R	stha	%r15, [%r30 + %r0] 0x74
	mov	0x70, %r24
	.word 0xd29fa000  ! 793: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	mov	0x3e8, %r22
	.word 0xd6ae49e0  ! 795: STBA_R	stba	%r11, [%r25 + %r0] 0x4f
	.word 0xda8fe000  ! 796: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xdab7e000  ! 797: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xdaf76000  ! 798: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdac7e000  ! 799: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0x87802074  ! 800: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r19
	mov	0x3d8, %r21
	.word 0x87802020  ! 803: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9fe000  ! 804: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xdab7a000  ! 805: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdac76000  ! 806: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0xd0a44400  ! 807: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	mov	0x0, %r19
	mov	0x70, %r17
	.word 0xd6af6000  ! 810: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xd6a76000  ! 812: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6f76000  ! 813: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd28f4e60  ! 814: LDUBA_R	lduba	[%r29, %r0] 0x73, %r9
	.word 0x87802020  ! 815: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r22
	.word 0xd8f609e0  ! 817: STXA_R	stxa	%r12, [%r24 + %r0] 0x4f
	.word 0xd4f76000  ! 818: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd08c8400  ! 819: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	mov	0x40, %r19
	.word 0x87802020  ! 821: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4dc2000  ! 822: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	.word 0xd08d44a0  ! 823: LDUBA_R	lduba	[%r21, %r0] 0x25, %r8
	mov	0x3f0, %r23
	mov	0x3f8, %r21
	.word 0xd0a4a000  ! 826: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 827: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r26
	.word 0xdcd44400  ! 829: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	.word 0xdcf4c400  ! 830: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0x87802073  ! 831: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 832: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded689e0  ! 833: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r15
	.word 0xdcae09e0  ! 834: STBA_R	stba	%r14, [%r24 + %r0] 0x4f
	mov	0x8, %r17
	.word 0xd88f4e60  ! 836: LDUBA_R	lduba	[%r29, %r0] 0x73, %r12
	.word 0xd88544a0  ! 837: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r12
	.word 0xdcf76000  ! 838: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x38, %r25
	mov	0x48, %r27
	.word 0xdccf2000  ! 841: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xdca76000  ! 842: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcbf6000  ! 843: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 844: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6cc8400  ! 846: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	.word 0x87802074  ! 847: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4dc4400  ! 848: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	.word 0x87802074  ! 849: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4afa000  ! 850: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd4a76000  ! 851: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 852: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d0, %r23
	.word 0xd4f7e000  ! 854: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xd6d48400  ! 855: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0xd69f4e40  ! 856: LDDA_R	ldda	[%r29, %r0] 0x72, %r11
	.word 0xdca7e000  ! 857: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 858: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r17
	mov	0x58, %r24
	.word 0xd4f5c4a0  ! 861: STXA_R	stxa	%r10, [%r23 + %r0] 0x25
	.word 0xd8bf6000  ! 862: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd0df8e80  ! 863: LDXA_R	ldxa	[%r30, %r0] 0x74, %r8
	.word 0xd4cf0e80  ! 864: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r10
	.word 0xd2c72000  ! 865: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2cf6000  ! 866: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	mov	0x8, %r27
	.word 0xd0af8e60  ! 868: STBA_R	stba	%r8, [%r30 + %r0] 0x73
	mov	0x3d0, %r21
	.word 0x87802073  ! 870: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 871: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d0, %r21
	mov	0x50, %r18
	.word 0xdabc4400  ! 874: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xd8b44400  ! 875: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0x87802073  ! 876: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdedc6000  ! 877: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r15
	.word 0xde8c6000  ! 878: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0xd0a7ce60  ! 879: STWA_R	stwa	%r8, [%r31 + %r0] 0x73
	mov	0x18, %r17
	mov	0x50, %r18
	.word 0xd2bc6000  ! 882: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0xd0c5c4a0  ! 883: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r8
	.word 0x87802072  ! 884: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 885: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r18
	.word 0x87802025  ! 887: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2ace000  ! 888: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0xd8d70e60  ! 889: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r12
	.word 0xdacc2000  ! 890: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	mov	0x3d0, %r20
	mov	0x20, %r24
	.word 0x87802025  ! 893: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabf2000  ! 894: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xd4afce80  ! 895: STBA_R	stba	%r10, [%r31 + %r0] 0x74
	mov	0x8, %r19
	.word 0xd8d40400  ! 897: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	.word 0xd287a000  ! 898: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0xd8a78e40  ! 899: STWA_R	stwa	%r12, [%r30 + %r0] 0x72
	.word 0xd28fa000  ! 900: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	mov	0x20, %r16
	.word 0x87802020  ! 902: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdaaf8e80  ! 904: STBA_R	stba	%r13, [%r30 + %r0] 0x74
	.word 0x87802073  ! 905: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2afe000  ! 906: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd2b76000  ! 907: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 908: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd287a000  ! 909: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2cf6000  ! 910: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2f7e000  ! 912: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd4adc4a0  ! 913: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	mov	0x70, %r26
	.word 0x87802020  ! 915: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ac4400  ! 916: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xda9ec9e0  ! 917: LDDA_R	ldda	[%r27, %r0] 0x4f, %r13
	.word 0x87802025  ! 918: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r25
	.word 0x87802074  ! 920: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r27
	.word 0xde8fe000  ! 922: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0xde840400  ! 923: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	mov	0x30, %r19
	mov	0x3c8, %r23
	.word 0xdef72000  ! 926: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xdedf2000  ! 927: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xde8f6000  ! 928: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	.word 0xde9f2000  ! 929: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	mov	0x0, %r24
	.word 0xd6aec9e0  ! 931: STBA_R	stba	%r11, [%r27 + %r0] 0x4f
	.word 0xda9689e0  ! 932: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r13
	.word 0x87802072  ! 933: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8874e60  ! 934: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r12
	.word 0xdeb72000  ! 935: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 936: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 937: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd88d04a0  ! 938: LDUBA_R	lduba	[%r20, %r0] 0x25, %r12
	mov	0x30, %r24
	mov	0x70, %r16
	mov	0x68, %r19
	mov	0x7f0, %r22
	.word 0xdebc8400  ! 943: STDA_R	stda	%r15, [%r18 + %r0] 0x20
	.word 0xd8a72000  ! 944: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd2ac4400  ! 945: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xd0ce09e0  ! 946: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r8
	mov	0x50, %r25
	.word 0xdcf7e000  ! 948: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xd6a609e0  ! 949: STWA_R	stwa	%r11, [%r24 + %r0] 0x4f
	.word 0x87802074  ! 950: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb78e80  ! 951: STHA_R	stha	%r14, [%r30 + %r0] 0x74
	.word 0xdcad04a0  ! 952: STBA_R	stba	%r14, [%r20 + %r0] 0x25
	mov	0x7f0, %r22
	.word 0xd09e09e0  ! 954: LDDA_R	ldda	[%r24, %r0] 0x4f, %r8
	.word 0xd88d6000  ! 955: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r12
	.word 0xd484c400  ! 956: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	.word 0xd0dde000  ! 957: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r8
	.word 0xdad78e40  ! 958: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r13
	.word 0x87802020  ! 959: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cfce80  ! 960: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r8
	.word 0xdeb7e000  ! 961: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 962: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde8ca000  ! 963: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0x87802020  ! 964: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab70e40  ! 965: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	.word 0xd0afe000  ! 966: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0cfa000  ! 967: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0x87802072  ! 968: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6d7ce80  ! 969: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r11
	.word 0xd2be6000  ! 970: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	mov	0x7c0, %r20
	.word 0xdef649e0  ! 972: STXA_R	stxa	%r15, [%r25 + %r0] 0x4f
	.word 0xd49ea000  ! 973: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	.word 0xd4b6a000  ! 974: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	.word 0xd8978e80  ! 975: LDUHA_R	lduha	[%r30, %r0] 0x74, %r12
	.word 0xda9e2000  ! 976: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r13
	.word 0xdaae2000  ! 977: STBA_I	stba	%r13, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 978: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 979: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r25
	.word 0x87802020  ! 981: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4acc400  ! 982: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xdabc6000  ! 983: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xdaac6000  ! 984: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	mov	0x48, %r17
	mov	0x18, %r16
	.word 0xd0ce49e0  ! 987: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r8
	.word 0x87802020  ! 988: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabc6000  ! 989: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 990: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdab7e000  ! 991: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	mov	0x20, %r25
	.word 0xdc8d84a0  ! 993: LDUBA_R	lduba	[%r22, %r0] 0x25, %r14
	mov	0x3f8, %r23
	mov	0x7f0, %r22
	.word 0x87802025  ! 996: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f76000  ! 997: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xdea4c400  ! 998: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	mov	0x3e0, %r23
	.word 0xd0b7ce40  ! 1000: STHA_R	stha	%r8, [%r31 + %r0] 0x72
	.word 0x87802073  ! 1001: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4a78e60  ! 1002: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	.word 0xdcdc8400  ! 1003: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	mov	0x3f8, %r21
	.word 0xd6944400  ! 1005: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	mov	0x60, %r19
	.word 0xda9cc400  ! 1007: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	.word 0xd8c76000  ! 1008: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	mov	0x0, %r27
	.word 0xd8f7a000  ! 1010: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	mov	0x8, %r17
	.word 0xdcbf0e80  ! 1012: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	.word 0x87802025  ! 1013: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb649e0  ! 1014: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	.word 0xd68689e0  ! 1015: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r11
	.word 0xdcf74e40  ! 1016: STXA_R	stxa	%r14, [%r29 + %r0] 0x72
	.word 0xd0f70e80  ! 1017: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0xd6f70e60  ! 1018: STXA_R	stxa	%r11, [%r28 + %r0] 0x73
	.word 0xd0c7ce40  ! 1019: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r8
	.word 0xdec46000  ! 1020: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	.word 0xdeb4a000  ! 1021: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0xdeb4e000  ! 1022: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 1023: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef7e000  ! 1024: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xd8cfce40  ! 1025: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r12
	.word 0xd6b40400  ! 1026: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xd2c76000  ! 1027: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2afe000  ! 1028: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd28dc4a0  ! 1029: LDUBA_R	lduba	[%r23, %r0] 0x25, %r9
	mov	0x7f0, %r21
	.word 0xd0b76000  ! 1031: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xdabcc400  ! 1032: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	.word 0xdcaf2000  ! 1033: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xd0dc8400  ! 1034: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0xdccfe000  ! 1035: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	mov	0x28, %r18
	.word 0xdcacc400  ! 1037: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0xd2844400  ! 1038: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	.word 0xdaf7ce80  ! 1039: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	mov	0x38, %r19
	mov	0x60, %r26
	.word 0xd4970e80  ! 1042: LDUHA_R	lduha	[%r28, %r0] 0x74, %r10
	.word 0x87802073  ! 1043: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d8, %r21
	.word 0xd68de000  ! 1045: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r11
	.word 0xd6bd2000  ! 1046: STDA_I	stda	%r11, [%r20 + 0x0000] %asi
	.word 0xd6f52000  ! 1047: STXA_I	stxa	%r11, [%r20 + 0x0000] %asi
	mov	0x3e0, %r23
	.word 0xdcb504a0  ! 1049: STHA_R	stha	%r14, [%r20 + %r0] 0x25
	.word 0xdcb78e80  ! 1050: STHA_R	stha	%r14, [%r30 + %r0] 0x74
	.word 0xd68da000  ! 1051: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r11
	.word 0xd6c52000  ! 1052: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r11
	.word 0xde848400  ! 1053: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	mov	0x50, %r25
	.word 0xd6a5a000  ! 1055: STWA_I	stwa	%r11, [%r22 + 0x0000] %asi
	.word 0xd2cf0e40  ! 1056: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r9
	.word 0xd0cde000  ! 1057: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r8
	.word 0xd6974e80  ! 1058: LDUHA_R	lduha	[%r29, %r0] 0x74, %r11
	.word 0xd2d5e000  ! 1059: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r9
	.word 0xd295a000  ! 1060: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r9
	.word 0x87802074  ! 1061: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 1062: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2948400  ! 1063: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	mov	0x7f0, %r20
	.word 0x87802025  ! 1065: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r17
	.word 0x87802073  ! 1067: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6a70e40  ! 1068: STWA_R	stwa	%r11, [%r28 + %r0] 0x72
	mov	0x38, %r18
	.word 0x87802025  ! 1070: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 1071: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r16
	.word 0xd6f40400  ! 1073: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	.word 0x87802072  ! 1074: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r26
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd88fa000  ! 1077: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0xd8c7a000  ! 1078: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xdea7ce60  ! 1079: STWA_R	stwa	%r15, [%r31 + %r0] 0x73
	.word 0x87802074  ! 1080: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeb74e80  ! 1081: STHA_R	stha	%r15, [%r29 + %r0] 0x74
	mov	0x20, %r24
	mov	0x3d8, %r23
	.word 0xdc95c4a0  ! 1084: LDUHA_R	lduha	[%r23, %r0] 0x25, %r14
	.word 0xdebd2000  ! 1085: STDA_I	stda	%r15, [%r20 + 0x0000] %asi
	.word 0xd0acc400  ! 1086: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd8f4c400  ! 1087: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	mov	0x60, %r27
	.word 0xd8bd44a0  ! 1089: STDA_R	stda	%r12, [%r21 + %r0] 0x25
	.word 0xdcb504a0  ! 1090: STHA_R	stha	%r14, [%r20 + %r0] 0x25
	mov	0x8, %r17
	.word 0xd6a56000  ! 1092: STWA_I	stwa	%r11, [%r21 + 0x0000] %asi
	mov	0x38, %r18
	.word 0xd6bd2000  ! 1094: STDA_I	stda	%r11, [%r20 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0xd0af4e60  ! 1096: STBA_R	stba	%r8, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 1097: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f8, %r21
	mov	0x3f0, %r23
	.word 0xd08c4400  ! 1100: LDUBA_R	lduba	[%r17, %r0] 0x20, %r8
	.word 0xde9f4e60  ! 1101: LDDA_R	ldda	[%r29, %r0] 0x73, %r15
	.word 0xd4be2000  ! 1102: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	.word 0xd6b7ce80  ! 1103: STHA_R	stha	%r11, [%r31 + %r0] 0x74
	.word 0xdcd66000  ! 1104: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r14
	.word 0xdcf62000  ! 1105: STXA_I	stxa	%r14, [%r24 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0x87802020  ! 1107: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a70e80  ! 1108: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	.word 0xde97a000  ! 1109: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	.word 0xde9f6000  ! 1110: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	mov	0x7d0, %r21
	.word 0xde976000  ! 1112: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	.word 0xd88649e0  ! 1113: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r12
	.word 0xd6a76000  ! 1114: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6a7a000  ! 1115: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	mov	0x58, %r16
	mov	0x78, %r19
	.word 0xd2878e80  ! 1118: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r9
	.word 0xd8c609e0  ! 1119: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r12
	.word 0xd6f7ce80  ! 1120: STXA_R	stxa	%r11, [%r31 + %r0] 0x74
	.word 0xdcafa000  ! 1121: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	mov	0x38, %r17
	.word 0xdc87a000  ! 1123: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xd0afce40  ! 1124: STBA_R	stba	%r8, [%r31 + %r0] 0x72
	.word 0xd6a7ce80  ! 1125: STWA_R	stwa	%r11, [%r31 + %r0] 0x74
	.word 0xd2ac8400  ! 1126: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xd8af0e60  ! 1127: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	.word 0xdcbf2000  ! 1128: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdc9fa000  ! 1129: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0xd6bfce80  ! 1130: STDA_R	stda	%r11, [%r31 + %r0] 0x74
	.word 0xd6afce60  ! 1131: STBA_R	stba	%r11, [%r31 + %r0] 0x73
	mov	0x3e0, %r20
	.word 0xd6b4c400  ! 1133: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	mov	0x7e8, %r22
	.word 0xdc97e000  ! 1135: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xd0b4c400  ! 1136: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0xd0afa000  ! 1137: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 1138: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 1139: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r25
	mov	0x68, %r26
	.word 0xd0872000  ! 1142: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	mov	0x58, %r25
	mov	0x60, %r24
	.word 0x87802025  ! 1145: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f8, %r23
	.word 0xd0c7a000  ! 1147: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	mov	0x7e8, %r23
	.word 0xd0a7a000  ! 1149: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd087a000  ! 1150: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0xdebd04a0  ! 1151: STDA_R	stda	%r15, [%r20 + %r0] 0x25
	.word 0xdeb78e80  ! 1152: STHA_R	stha	%r15, [%r30 + %r0] 0x74
	.word 0xde872000  ! 1153: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	mov	0x50, %r19
	.word 0xdebf4e40  ! 1155: STDA_R	stda	%r15, [%r29 + %r0] 0x72
	.word 0xd0972000  ! 1156: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0b74e60  ! 1157: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	.word 0xd28fa000  ! 1158: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	mov	0x20, %r26
	mov	0x7c0, %r21
	.word 0xd2b7a000  ! 1161: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 1162: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf7ce80  ! 1163: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	mov	0x58, %r27
	.word 0x87802020  ! 1165: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f76000  ! 1166: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 1167: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f76000  ! 1168: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd6ac4400  ! 1169: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	mov	0x78, %r26
	.word 0xda872000  ! 1171: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0xda876000  ! 1172: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	mov	0x78, %r17
	mov	0x3e8, %r22
	mov	0x28, %r26
	.word 0xda8f6000  ! 1176: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xdabf6000  ! 1177: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xda9fe000  ! 1178: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xdac72000  ! 1179: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0xdcadc4a0  ! 1180: STBA_R	stba	%r14, [%r23 + %r0] 0x25
	mov	0x20, %r19
	.word 0x87802074  ! 1182: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdad56000  ! 1183: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r13
	mov	0x10, %r26
	.word 0x87802025  ! 1185: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r24
	.word 0x87802072  ! 1187: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1188: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r25
	mov	0x3f8, %r22
	.word 0x87802025  ! 1191: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r19
	mov	0x68, %r17
	.word 0xda8c6000  ! 1194: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r13
	.word 0x87802074  ! 1195: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r23
	mov	0x3d8, %r22
	mov	0x3d0, %r22
	.word 0xdaa44400  ! 1199: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	mov	0x7d8, %r21
	.word 0xd0970e60  ! 1201: LDUHA_R	lduha	[%r28, %r0] 0x73, %r8
	mov	0x70, %r19
	.word 0xdcb5c4a0  ! 1203: STHA_R	stha	%r14, [%r23 + %r0] 0x25
	.word 0xd4ae49e0  ! 1204: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 1205: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb649e0  ! 1206: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	mov	0x70, %r24
	.word 0xd2b76000  ! 1208: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2f72000  ! 1209: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd6a44400  ! 1210: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0xdaf7e000  ! 1211: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1212: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9ee000  ! 1213: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r13
	.word 0xdade2000  ! 1214: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r13
	.word 0xdc8cc400  ! 1215: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	.word 0xd2d40400  ! 1216: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	.word 0xdcc6e000  ! 1217: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r14
	.word 0x87802025  ! 1218: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bf8e40  ! 1219: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	mov	0x68, %r19
	.word 0x87802074  ! 1221: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r25
	.word 0xda974e60  ! 1223: LDUHA_R	lduha	[%r29, %r0] 0x73, %r13
	.word 0x87802074  ! 1224: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb7a000  ! 1225: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1226: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8f4e40  ! 1227: LDUBA_R	lduba	[%r29, %r0] 0x72, %r13
	.word 0xd8cf8e40  ! 1228: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r12
	mov	0x7d0, %r21
	.word 0x87802025  ! 1230: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c0, %r22
	mov	0x3d0, %r20
	.word 0xdca42000  ! 1233: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	mov	0x28, %r27
	mov	0x3c8, %r23
	mov	0x7e0, %r20
	.word 0xdc8584a0  ! 1237: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r14
	mov	0x38, %r18
	mov	0x3c8, %r21
	.word 0xd49649e0  ! 1240: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r10
	.word 0xd2bc0400  ! 1241: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xd6874e40  ! 1242: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r11
	.word 0xda9e09e0  ! 1243: LDDA_R	ldda	[%r24, %r0] 0x4f, %r13
	.word 0xd6b46000  ! 1244: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd4f44400  ! 1245: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0xd6dca000  ! 1246: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r11
	mov	0x28, %r27
	.word 0xdeaf4e80  ! 1248: STBA_R	stba	%r15, [%r29 + %r0] 0x74
	.word 0xda9f0e60  ! 1249: LDDA_R	ldda	[%r28, %r0] 0x73, %r13
	.word 0xdcb42000  ! 1250: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	mov	0x40, %r27
	mov	0x78, %r16
	mov	0x8, %r18
	.word 0xd6870e60  ! 1254: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r11
	mov	0x70, %r26
	.word 0xdcc584a0  ! 1256: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r14
	mov	0x58, %r27
	.word 0xd2f42000  ! 1258: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	mov	0x28, %r18
	mov	0x8, %r27
	.word 0x87802072  ! 1261: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdedc4400  ! 1262: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	mov	0x40, %r19
	.word 0xdaacc400  ! 1264: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	mov	0x3e8, %r23
	.word 0xdca72000  ! 1266: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdca7a000  ! 1267: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcafe000  ! 1268: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdcd76000  ! 1269: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	mov	0x48, %r25
	mov	0x70, %r25
	.word 0xdcbf2000  ! 1272: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 1273: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 1274: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda9584a0  ! 1275: LDUHA_R	lduha	[%r22, %r0] 0x25, %r13
	.word 0xd8bd44a0  ! 1276: STDA_R	stda	%r12, [%r21 + %r0] 0x25
	.word 0xdaaf8e80  ! 1277: STBA_R	stba	%r13, [%r30 + %r0] 0x74
	.word 0xdab76000  ! 1278: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xd4c584a0  ! 1279: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r10
	.word 0xd0c7ce80  ! 1280: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r8
	.word 0xd8c7e000  ! 1281: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8bf2000  ! 1282: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 1283: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8d46000  ! 1284: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	mov	0x7e0, %r23
	mov	0x38, %r26
	.word 0xd68c0400  ! 1287: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	.word 0xdecca000  ! 1288: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	mov	0x3c8, %r22
	mov	0x7c8, %r23
	.word 0xd0f74e60  ! 1291: STXA_R	stxa	%r8, [%r29 + %r0] 0x73
	.word 0xd2dc6000  ! 1292: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r9
	mov	0x7c8, %r22
	.word 0xd29cc400  ! 1294: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	.word 0xdcb74e40  ! 1295: STHA_R	stha	%r14, [%r29 + %r0] 0x72
	mov	0x48, %r19
	mov	0x30, %r26
	.word 0xdcd74e80  ! 1298: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r14
	.word 0xd0c4e000  ! 1299: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	.word 0xd0a46000  ! 1300: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xd4bf4e60  ! 1301: STDA_R	stda	%r10, [%r29 + %r0] 0x73
	.word 0xd0bc8400  ! 1302: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	mov	0x7c8, %r23
	.word 0xdaa42000  ! 1304: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	mov	0x30, %r26
	.word 0xdac4e000  ! 1306: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r13
	mov	0x18, %r16
	.word 0xdaace000  ! 1308: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0xdedf4e40  ! 1309: LDXA_R	ldxa	[%r29, %r0] 0x72, %r15
	.word 0xdead44a0  ! 1310: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	mov	0x38, %r27
	.word 0xdef504a0  ! 1312: STXA_R	stxa	%r15, [%r20 + %r0] 0x25
	.word 0x87802073  ! 1313: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2944400  ! 1314: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	.word 0x87802074  ! 1315: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f62000  ! 1316: STXA_I	stxa	%r11, [%r24 + 0x0000] %asi
	mov	0x50, %r26
	.word 0xd0c44400  ! 1318: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r8
	.word 0x87802020  ! 1319: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1320: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdab72000  ! 1321: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdaf7a000  ! 1322: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdab72000  ! 1323: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1324: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabd6000  ! 1325: STDA_I	stda	%r13, [%r21 + 0x0000] %asi
	.word 0xdac56000  ! 1326: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r13
	.word 0xdcae49e0  ! 1327: STBA_R	stba	%r14, [%r25 + %r0] 0x4f
	.word 0xded78e80  ! 1328: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r15
	.word 0xd68d2000  ! 1329: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r11
	.word 0xd2b689e0  ! 1330: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	.word 0xd6a5e000  ! 1331: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	.word 0xd4874e80  ! 1332: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r10
	.word 0xd0ac4400  ! 1333: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0xdaf56000  ! 1334: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	.word 0xda85a000  ! 1335: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r13
	.word 0xda95e000  ! 1336: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r13
	.word 0xdcbfce40  ! 1337: STDA_R	stda	%r14, [%r31 + %r0] 0x72
	.word 0xd2cd2000  ! 1338: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r9
	.word 0xdabd44a0  ! 1339: STDA_R	stda	%r13, [%r21 + %r0] 0x25
	.word 0xded6c9e0  ! 1340: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r15
	.word 0x87802020  ! 1341: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabfe000  ! 1342: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	mov	0x50, %r19
	.word 0xdadf2000  ! 1344: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0xd8b40400  ! 1345: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xde97e000  ! 1346: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0xd2a7ce60  ! 1347: STWA_R	stwa	%r9, [%r31 + %r0] 0x73
	.word 0x87802020  ! 1348: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabfe000  ! 1349: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	mov	0x3e0, %r20
	mov	0x40, %r25
	.word 0xdaafe000  ! 1352: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 1353: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r26
	.word 0x87802074  ! 1355: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda8fa000  ! 1356: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	mov	0x70, %r27
	.word 0xdeaf0e60  ! 1358: STBA_R	stba	%r15, [%r28 + %r0] 0x73
	.word 0xdef76000  ! 1359: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdef7e000  ! 1360: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xd684c400  ! 1361: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	.word 0xd68689e0  ! 1362: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r11
	mov	0x10, %r24
	mov	0x7e0, %r21
	.word 0xd4a7a000  ! 1365: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 1366: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r18
	mov	0x0, %r26
	.word 0x87802074  ! 1369: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f74e80  ! 1370: STXA_R	stxa	%r8, [%r29 + %r0] 0x74
	.word 0x87802025  ! 1371: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e0, %r23
	mov	0x48, %r26
	.word 0xdcaf4e40  ! 1374: STBA_R	stba	%r14, [%r29 + %r0] 0x72
	mov	0x3e8, %r23
	.word 0xdebfce40  ! 1376: STDA_R	stda	%r15, [%r31 + %r0] 0x72
	.word 0xde9f0e40  ! 1377: LDDA_R	ldda	[%r28, %r0] 0x72, %r15
	.word 0xd6a42000  ! 1378: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xd6b4a000  ! 1379: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd6a42000  ! 1380: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xd6cc6000  ! 1381: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r11
	.word 0x87802020  ! 1382: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c7e000  ! 1383: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xdec4c400  ! 1384: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	mov	0x40, %r19
	.word 0xd0a78e80  ! 1386: STWA_R	stwa	%r8, [%r30 + %r0] 0x74
	.word 0x8780204f  ! 1387: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d0, %r23
	.word 0xdc9c4400  ! 1389: LDDA_R	ldda	[%r17, %r0] 0x20, %r14
	.word 0xdccd6000  ! 1390: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r14
	mov	0x7f0, %r21
	.word 0xdca689e0  ! 1392: STWA_R	stwa	%r14, [%r26 + %r0] 0x4f
	.word 0xd88d6000  ! 1393: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1394: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88f2000  ! 1395: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0xdeae09e0  ! 1396: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	.word 0xd68e09e0  ! 1397: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r11
	.word 0xdaae89e0  ! 1398: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	.word 0xdeafe000  ! 1399: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xdea40400  ! 1400: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xdaf689e0  ! 1401: STXA_R	stxa	%r13, [%r26 + %r0] 0x4f
	.word 0xd0bfce60  ! 1402: STDA_R	stda	%r8, [%r31 + %r0] 0x73
	.word 0x87802025  ! 1403: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f7e000  ! 1404: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xd6f76000  ! 1406: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6df2000  ! 1407: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	mov	0x78, %r25
	.word 0x87802020  ! 1409: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bf6000  ! 1410: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 1411: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f5e000  ! 1412: STXA_I	stxa	%r11, [%r23 + 0x0000] %asi
	.word 0xd0b70e40  ! 1413: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	.word 0xd4b70e40  ! 1414: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	mov	0x60, %r24
	.word 0xd4a5e000  ! 1416: STWA_I	stwa	%r10, [%r23 + 0x0000] %asi
	.word 0xd4d78e80  ! 1417: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r10
	.word 0xd0cf4e40  ! 1418: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	mov	0x68, %r18
	mov	0x68, %r16
	.word 0xd0cc0400  ! 1421: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xde8f0e40  ! 1422: LDUBA_R	lduba	[%r28, %r0] 0x72, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x40, %r17
	.word 0x8780204f  ! 1425: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa72000  ! 1426: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xda972000  ! 1427: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0xd4ac8400  ! 1428: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0xd6a44400  ! 1429: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	mov	0x20, %r16
	mov	0x58, %r19
	.word 0xda87e000  ! 1432: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0xd0a5c4a0  ! 1433: STWA_R	stwa	%r8, [%r23 + %r0] 0x25
	.word 0xdedf8e80  ! 1434: LDXA_R	ldxa	[%r30, %r0] 0x74, %r15
	.word 0x87802074  ! 1435: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r27
	.word 0x87802020  ! 1437: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r26
	.word 0xd08fa000  ! 1439: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0xd0af2000  ! 1440: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd48f4e40  ! 1441: LDUBA_R	lduba	[%r29, %r0] 0x72, %r10
	.word 0xdad7e000  ! 1442: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xdaf7e000  ! 1443: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	mov	0x68, %r27
	mov	0x3d0, %r22
	mov	0x50, %r19
	.word 0xda87e000  ! 1447: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	mov	0x38, %r24
	.word 0x87802072  ! 1449: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd48d84a0  ! 1450: LDUBA_R	lduba	[%r22, %r0] 0x25, %r10
	.word 0xdcafa000  ! 1451: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xd49d84a0  ! 1452: LDDA_R	ldda	[%r22, %r0] 0x25, %r10
	.word 0x87802025  ! 1453: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6948400  ! 1454: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	.word 0xd6be2000  ! 1455: STDA_I	stda	%r11, [%r24 + 0x0000] %asi
	.word 0xd69584a0  ! 1456: LDUHA_R	lduha	[%r22, %r0] 0x25, %r11
	.word 0xda8ea000  ! 1457: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r13
	.word 0xdac6a000  ! 1458: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r13
	.word 0xda86e000  ! 1459: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r13
	.word 0xda8e2000  ! 1460: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r13
	.word 0xdaf6a000  ! 1461: STXA_I	stxa	%r13, [%r26 + 0x0000] %asi
	.word 0xdadee000  ! 1462: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r13
	mov	0x7f0, %r20
	mov	0x60, %r16
	mov	0x78, %r24
	.word 0x87802025  ! 1466: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdab5e000  ! 1467: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	mov	0x10, %r26
	.word 0xdabde000  ! 1469: STDA_I	stda	%r13, [%r23 + 0x0000] %asi
	.word 0xda8d6000  ! 1470: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r13
	.word 0x87802025  ! 1471: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r19
	.word 0x87802020  ! 1473: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r26
	.word 0xd0a5c4a0  ! 1475: STWA_R	stwa	%r8, [%r23 + %r0] 0x25
	.word 0x87802020  ! 1476: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r26
	.word 0x87802073  ! 1478: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0df0e60  ! 1479: LDXA_R	ldxa	[%r28, %r0] 0x73, %r8
	.word 0xd8dde000  ! 1480: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r12
	mov	0x28, %r26
	mov	0x3e0, %r23
	.word 0xd48d44a0  ! 1483: LDUBA_R	lduba	[%r21, %r0] 0x25, %r10
	ta	T_CHANGE_HPRIV	! macro
	mov	0x10, %r18
	mov	0x48, %r27
	.word 0x87802074  ! 1487: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d0, %r22
	.word 0xdef689e0  ! 1489: STXA_R	stxa	%r15, [%r26 + %r0] 0x4f
	.word 0xdaa42000  ! 1490: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0xdac4a000  ! 1491: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	.word 0xd0c70e80  ! 1492: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r8
	.word 0xd8a78e40  ! 1493: STWA_R	stwa	%r12, [%r30 + %r0] 0x72
	.word 0x87802072  ! 1494: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda9fa000  ! 1495: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xd6af4e40  ! 1496: STBA_R	stba	%r11, [%r29 + %r0] 0x72
	.word 0xdaf7a000  ! 1497: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1498: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r20
	mov	0x7e8, %r23
	.word 0xd486c9e0  ! 1501: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r10
	mov	0x40, %r27
	.word 0x87802025  ! 1503: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c8, %r21
	mov	0x7c8, %r20
	.word 0xd8a44400  ! 1506: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	mov	0x0, %r25
	.word 0xdaf72000  ! 1508: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xd6a70e60  ! 1509: STWA_R	stwa	%r11, [%r28 + %r0] 0x73
	.word 0x87802020  ! 1510: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1511: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r26
	.word 0xd8f40400  ! 1513: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	mov	0x3f8, %r23
	.word 0xd0dca000  ! 1515: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 1516: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd09ce000  ! 1517: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r8
	.word 0xd2afce80  ! 1518: STBA_R	stba	%r9, [%r31 + %r0] 0x74
	.word 0x87802020  ! 1519: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bd84a0  ! 1520: STDA_R	stda	%r11, [%r22 + %r0] 0x25
	mov	0x58, %r19
	.word 0xdc9d04a0  ! 1522: LDDA_R	ldda	[%r20, %r0] 0x25, %r14
	.word 0xdcf70e80  ! 1523: STXA_R	stxa	%r14, [%r28 + %r0] 0x74
	mov	0x20, %r16
	.word 0x8780204f  ! 1525: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 1526: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd68fe000  ! 1527: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xd8f44400  ! 1528: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	mov	0x7c8, %r21
	.word 0xd2cd44a0  ! 1530: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r9
	mov	0x38, %r18
	.word 0xd8b7a000  ! 1532: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xd49f0e80  ! 1533: LDDA_R	ldda	[%r28, %r0] 0x74, %r10
	mov	0x3c8, %r23
	mov	0x7e0, %r23
	.word 0xdeb4c400  ! 1536: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0x87802073  ! 1537: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r27
	.word 0xd8d7e000  ! 1539: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0xd8c78e80  ! 1540: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r12
	.word 0xdaa584a0  ! 1541: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	mov	0x60, %r25
	.word 0xd6bf4e60  ! 1543: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	mov	0x40, %r27
	.word 0x87802073  ! 1545: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd88fa000  ! 1546: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0xd8f7e000  ! 1547: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	mov	0x3f0, %r21
	.word 0x87802074  ! 1549: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 1550: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd897a000  ! 1551: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0xd4c70e40  ! 1552: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r10
	.word 0xd6bdc4a0  ! 1553: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	mov	0x18, %r25
	.word 0xd89504a0  ! 1555: LDUHA_R	lduha	[%r20, %r0] 0x25, %r12
	.word 0x87802020  ! 1556: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca70e40  ! 1557: STWA_R	stwa	%r14, [%r28 + %r0] 0x72
	.word 0xd0f7a000  ! 1558: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd09d84a0  ! 1559: LDDA_R	ldda	[%r22, %r0] 0x25, %r8
	mov	0x10, %r16
	mov	0x28, %r16
	.word 0x87802020  ! 1562: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdacfa000  ! 1563: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	mov	0x50, %r17
	.word 0xdaa7a000  ! 1565: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xdcd4c400  ! 1566: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	.word 0x87802073  ! 1567: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6ad04a0  ! 1568: STBA_R	stba	%r11, [%r20 + %r0] 0x25
	.word 0x8780204f  ! 1569: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r24
	.word 0xd087e000  ! 1571: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1572: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09fa000  ! 1573: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	mov	0x7c0, %r20
	mov	0x58, %r26
	mov	0x7f0, %r23
	.word 0xd0972000  ! 1577: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	mov	0x40, %r24
	.word 0xda94c400  ! 1579: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	.word 0xdecf6000  ! 1580: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0xde9fa000  ! 1581: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	.word 0xdeb76000  ! 1582: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1583: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r26
	.word 0xd0b609e0  ! 1585: STHA_R	stha	%r8, [%r24 + %r0] 0x4f
	.word 0xd08c0400  ! 1586: LDUBA_R	lduba	[%r16, %r0] 0x20, %r8
	mov	0x38, %r16
	.word 0x87802074  ! 1588: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c8, %r21
	.word 0xd0d48400  ! 1590: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	.word 0x87802020  ! 1591: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r24
	.word 0xdc9ea000  ! 1593: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r14
	.word 0xd2c4c400  ! 1594: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0xdacf8e40  ! 1595: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r13
	.word 0x87802073  ! 1596: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde87a000  ! 1597: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xdcb4c400  ! 1598: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	mov	0x10, %r17
	ta	T_CHANGE_PRIV	! macro
	.word 0xd0ccc400  ! 1601: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	.word 0xd2bfe000  ! 1602: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 1603: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6ccc400  ! 1604: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	.word 0x87802020  ! 1605: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f6e000  ! 1606: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	.word 0xd2de2000  ! 1607: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r9
	mov	0x7d0, %r23
	.word 0xd2de6000  ! 1609: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r9
	mov	0x3f8, %r20
	.word 0x87802073  ! 1611: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 1612: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d78e40  ! 1613: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r9
	.word 0x87802025  ! 1614: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d0, %r21
	.word 0xdaac6000  ! 1616: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	.word 0xd8bc8400  ! 1617: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	mov	0x70, %r17
	.word 0x87802020  ! 1619: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r26
	.word 0x87802073  ! 1621: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4966000  ! 1622: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r10
	mov	0x28, %r17
	.word 0xd49ea000  ! 1624: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1625: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f504a0  ! 1626: STXA_R	stxa	%r11, [%r20 + %r0] 0x25
	mov	0x10, %r24
	.word 0xd2a544a0  ! 1628: STWA_R	stwa	%r9, [%r21 + %r0] 0x25
	.word 0xd29d04a0  ! 1629: LDDA_R	ldda	[%r20, %r0] 0x25, %r9
	.word 0xd4b46000  ! 1630: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xd2bc8400  ! 1631: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	.word 0xd6ace000  ! 1632: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802025  ! 1634: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f7a000  ! 1635: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	mov	0x20, %r25
	mov	0x3d0, %r22
	.word 0xd8a44400  ! 1638: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xd6a7a000  ! 1639: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xdcdf8e60  ! 1640: LDXA_R	ldxa	[%r30, %r0] 0x73, %r14
	.word 0xdacf0e80  ! 1641: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r13
	.word 0xdcb72000  ! 1642: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xd0ad44a0  ! 1643: STBA_R	stba	%r8, [%r21 + %r0] 0x25
	.word 0xd68c0400  ! 1644: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	.word 0xd09f6000  ! 1645: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	.word 0x87802072  ! 1646: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0d62000  ! 1647: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r8
	mov	0x60, %r26
	.word 0xde848400  ! 1649: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	.word 0xd0ce6000  ! 1650: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r8
	.word 0xd0a62000  ! 1651: STWA_I	stwa	%r8, [%r24 + 0x0000] %asi
	mov	0x38, %r18
	.word 0xd0b66000  ! 1653: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	mov	0x3e0, %r21
	mov	0x20, %r17
	.word 0xd0bea000  ! 1656: STDA_I	stda	%r8, [%r26 + 0x0000] %asi
	.word 0xd0dee000  ! 1657: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r8
	.word 0xdaa44400  ! 1658: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0xde8ea000  ! 1659: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r15
	mov	0x60, %r17
	.word 0xd8c78e60  ! 1661: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r12
	.word 0xd68ea000  ! 1662: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r11
	mov	0x20, %r24
	mov	0x7e0, %r20
	.word 0xd69e2000  ! 1665: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r11
	.word 0x87802025  ! 1666: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x3e0, %r21
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6a76000  ! 1670: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6cfe000  ! 1671: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	mov	0x18, %r19
	mov	0x0, %r27
	.word 0xd6b76000  ! 1674: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd8cd04a0  ! 1675: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r12
	.word 0xdca72000  ! 1676: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xd4b40400  ! 1677: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0xd8dfce80  ! 1678: LDXA_R	ldxa	[%r31, %r0] 0x74, %r12
	mov	0x20, %r17
	.word 0xd89fce40  ! 1680: LDDA_R	ldda	[%r31, %r0] 0x72, %r12
	mov	0x3c0, %r20
	.word 0xde9f2000  ! 1682: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xde87a000  ! 1683: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xdef72000  ! 1684: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xd4df8e60  ! 1685: LDXA_R	ldxa	[%r30, %r0] 0x73, %r10
	mov	0x20, %r27
	.word 0xdabf0e60  ! 1687: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	.word 0xd4f78e40  ! 1688: STXA_R	stxa	%r10, [%r30 + %r0] 0x72
	.word 0xd08f6000  ! 1689: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r8
	.word 0xd0d72000  ! 1690: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0f76000  ! 1691: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	mov	0x48, %r16
	.word 0xdec4c400  ! 1693: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	.word 0x87802073  ! 1694: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b4e000  ! 1695: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0xd2aca000  ! 1696: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0xd2d4a000  ! 1697: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	mov	0x48, %r18
	.word 0xd2a4a000  ! 1699: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0xd284a000  ! 1700: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	.word 0xd2bca000  ! 1701: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	.word 0xd2d4e000  ! 1702: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0xd2b46000  ! 1703: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0xd2a4a000  ! 1704: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 1705: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2dfe000  ! 1706: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0xd8b544a0  ! 1707: STHA_R	stha	%r12, [%r21 + %r0] 0x25
	.word 0xdca7e000  ! 1708: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcaf4e40  ! 1709: STBA_R	stba	%r14, [%r29 + %r0] 0x72
	.word 0xd4b5c4a0  ! 1710: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	.word 0xd69fce40  ! 1711: LDDA_R	ldda	[%r31, %r0] 0x72, %r11
	.word 0xde8f2000  ! 1712: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xde8fe000  ! 1713: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0xd6c78e60  ! 1714: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r11
	mov	0x28, %r25
	.word 0xd2df8e40  ! 1716: LDXA_R	ldxa	[%r30, %r0] 0x72, %r9
	.word 0x87802074  ! 1717: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f46000  ! 1718: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xdad4c400  ! 1719: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xd2af8e40  ! 1720: STBA_R	stba	%r9, [%r30 + %r0] 0x72
	.word 0xdaa44400  ! 1721: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	mov	0x7d8, %r22
	.word 0x87802073  ! 1723: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd08f4e60  ! 1724: LDUBA_R	lduba	[%r29, %r0] 0x73, %r8
	.word 0xde8d2000  ! 1725: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r15
	.word 0xd6b48400  ! 1726: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	mov	0x18, %r27
	mov	0x28, %r26
	.word 0xdead6000  ! 1729: STBA_I	stba	%r15, [%r21 + 0x0000] %asi
	.word 0xd6bf4e60  ! 1730: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	.word 0xd2f5a000  ! 1731: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	.word 0x87802073  ! 1732: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 1733: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6a48400  ! 1734: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0xde946000  ! 1735: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r15
	.word 0xd29584a0  ! 1736: LDUHA_R	lduha	[%r22, %r0] 0x25, %r9
	.word 0xd8842000  ! 1737: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	.word 0xd4afce40  ! 1738: STBA_R	stba	%r10, [%r31 + %r0] 0x72
	mov	0x28, %r27
	mov	0x3c8, %r20
	.word 0xd6aca000  ! 1741: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xd6cc8400  ! 1742: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	.word 0xd6c74e40  ! 1743: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r11
	ta	T_CHANGE_PRIV	! macro
	.word 0xdef4c400  ! 1745: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	mov	0x30, %r17
	mov	0x10, %r16
	.word 0xd0d40400  ! 1748: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	mov	0x48, %r25
	.word 0x87802020  ! 1750: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f70e80  ! 1751: STXA_R	stxa	%r9, [%r28 + %r0] 0x74
	.word 0xd6b649e0  ! 1752: STHA_R	stha	%r11, [%r25 + %r0] 0x4f
	.word 0xd4cfa000  ! 1753: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0xd4876000  ! 1754: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4a7a000  ! 1755: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	mov	0x7d0, %r20
	.word 0x87802073  ! 1757: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 1758: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6bf0e60  ! 1759: STDA_R	stda	%r11, [%r28 + %r0] 0x73
	.word 0xd2a66000  ! 1760: STWA_I	stwa	%r9, [%r25 + 0x0000] %asi
	.word 0xd6bc8400  ! 1761: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xdef66000  ! 1762: STXA_I	stxa	%r15, [%r25 + 0x0000] %asi
	mov	0x48, %r17
	.word 0xded66000  ! 1764: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r15
	mov	0x38, %r27
	.word 0xd0a70e40  ! 1766: STWA_R	stwa	%r8, [%r28 + %r0] 0x72
	mov	0x3c8, %r20
	.word 0xd8d74e60  ! 1768: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r12
	.word 0xdeb74e80  ! 1769: STHA_R	stha	%r15, [%r29 + %r0] 0x74
	.word 0xd0bf4e80  ! 1770: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	mov	0x60, %r17
	.word 0xdabe2000  ! 1772: STDA_I	stda	%r13, [%r24 + 0x0000] %asi
	.word 0xd2c78e60  ! 1773: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r9
	mov	0x30, %r16
	.word 0x87802025  ! 1775: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdedf4e60  ! 1776: LDXA_R	ldxa	[%r29, %r0] 0x73, %r15
	.word 0xd6bf2000  ! 1777: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd68fa000  ! 1778: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0xd88fce60  ! 1779: LDUBA_R	lduba	[%r31, %r0] 0x73, %r12
	.word 0xd4f7ce60  ! 1780: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	.word 0xd0bf4e40  ! 1781: STDA_R	stda	%r8, [%r29 + %r0] 0x72
	.word 0xd2872000  ! 1782: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	mov	0x3d0, %r20
	.word 0xde95c4a0  ! 1784: LDUHA_R	lduha	[%r23, %r0] 0x25, %r15
	.word 0x87802074  ! 1785: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2a6a000  ! 1786: STWA_I	stwa	%r9, [%r26 + 0x0000] %asi
	mov	0x78, %r19
	.word 0xd2b62000  ! 1788: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	mov	0x28, %r24
	.word 0xd2a6e000  ! 1790: STWA_I	stwa	%r9, [%r27 + 0x0000] %asi
	mov	0x18, %r26
	.word 0x87802020  ! 1792: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c7e000  ! 1793: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	mov	0x3c0, %r22
	.word 0xd2a76000  ! 1795: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd2b72000  ! 1796: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd4dc8400  ! 1797: LDXA_R	ldxa	[%r18, %r0] 0x20, %r10
	.word 0xde8fa000  ! 1798: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0xd0d504a0  ! 1799: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r8
	mov	0x48, %r27
	.word 0xded7ce40  ! 1801: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r15
	.word 0xd6cfce40  ! 1802: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r11
	.word 0xd8b44400  ! 1803: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0xd2dfa000  ! 1804: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1805: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1806: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 1807: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda870e80  ! 1808: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r13
	.word 0xdab74e40  ! 1809: STHA_R	stha	%r13, [%r29 + %r0] 0x72
	mov	0x58, %r19
	mov	0x7c0, %r22
	.word 0xd4cfce60  ! 1812: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r10
	.word 0xdcac8400  ! 1813: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xd2ac6000  ! 1814: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd89cc400  ! 1815: LDDA_R	ldda	[%r19, %r0] 0x20, %r12
	.word 0xdcf74e60  ! 1816: STXA_R	stxa	%r14, [%r29 + %r0] 0x73
	mov	0x3d8, %r21
	.word 0xd2ac2000  ! 1818: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd2a46000  ! 1819: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 1820: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 1821: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e8, %r22
	.word 0x87802072  ! 1823: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd88fce60  ! 1824: LDUBA_R	lduba	[%r31, %r0] 0x73, %r12
	.word 0xd0a46000  ! 1825: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	mov	0x50, %r17
	mov	0x8, %r27
	.word 0xd8cfce60  ! 1828: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r12
	.word 0xd8dfce80  ! 1829: LDXA_R	ldxa	[%r31, %r0] 0x74, %r12
	mov	0x48, %r26
	mov	0x3c0, %r20
	.word 0xd0ad04a0  ! 1832: STBA_R	stba	%r8, [%r20 + %r0] 0x25
	.word 0x87802025  ! 1833: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d8, %r20
	mov	0x7e0, %r20
	.word 0xd68fe000  ! 1836: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xdea544a0  ! 1837: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	.word 0xd6c584a0  ! 1838: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r11
	.word 0xd6bf0e80  ! 1839: STDA_R	stda	%r11, [%r28 + %r0] 0x74
	.word 0x87802025  ! 1840: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdccfe000  ! 1841: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0x87802025  ! 1842: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 1843: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r26
	.word 0xdef78e80  ! 1845: STXA_R	stxa	%r15, [%r30 + %r0] 0x74
	.word 0xd6cca000  ! 1846: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r11
	.word 0xd2bdc4a0  ! 1847: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	.word 0xda9c2000  ! 1848: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	.word 0xdaf4e000  ! 1849: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 1850: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r16
	.word 0xda978e80  ! 1852: LDUHA_R	lduha	[%r30, %r0] 0x74, %r13
	mov	0x3f8, %r20
	mov	0x20, %r25
	.word 0xd294a000  ! 1855: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r9
	.word 0xd2ac6000  ! 1856: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd28c2000  ! 1857: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xd2a4e000  ! 1858: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2bce000  ! 1859: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 1860: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca48400  ! 1861: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xdead04a0  ! 1862: STBA_R	stba	%r15, [%r20 + %r0] 0x25
	mov	0x48, %r16
	.word 0xde876000  ! 1864: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xdc9e49e0  ! 1865: LDDA_R	ldda	[%r25, %r0] 0x4f, %r14
	.word 0xdcafa000  ! 1866: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1867: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb72000  ! 1868: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	mov	0x70, %r18
	.word 0xdcb76000  ! 1870: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xdcafe000  ! 1871: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdcf72000  ! 1872: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcdf2000  ! 1873: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	mov	0x7f8, %r23
	.word 0xdcf7e000  ! 1875: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x18, %r17
	mov	0x7c0, %r23
	mov	0x38, %r19
	.word 0xdca7e000  ! 1879: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdadfce80  ! 1880: LDXA_R	ldxa	[%r31, %r0] 0x74, %r13
	.word 0x87802020  ! 1881: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r22
	.word 0xdca72000  ! 1883: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdecc8400  ! 1884: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	mov	0x78, %r16
	mov	0x40, %r24
	.word 0xdaf76000  ! 1887: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xd0f7ce80  ! 1888: STXA_R	stxa	%r8, [%r31 + %r0] 0x74
	.word 0x87802073  ! 1889: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4cc6000  ! 1890: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	.word 0xd8c78e60  ! 1891: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r12
	.word 0x87802020  ! 1892: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaae89e0  ! 1893: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 1894: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4c609e0  ! 1895: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r10
	.word 0xdaa7a000  ! 1896: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	mov	0x78, %r24
	.word 0x87802020  ! 1898: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29f4e60  ! 1899: LDDA_R	ldda	[%r29, %r0] 0x73, %r9
	.word 0xdedf4e40  ! 1900: LDXA_R	ldxa	[%r29, %r0] 0x72, %r15
	.word 0xdebf0e40  ! 1901: STDA_R	stda	%r15, [%r28 + %r0] 0x72
	.word 0xd8974e80  ! 1902: LDUHA_R	lduha	[%r29, %r0] 0x74, %r12
	.word 0xd4dc8400  ! 1903: LDXA_R	ldxa	[%r18, %r0] 0x20, %r10
	.word 0xd8b7ce80  ! 1904: STHA_R	stha	%r12, [%r31 + %r0] 0x74
	.word 0xd0a649e0  ! 1905: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	.word 0x8780204f  ! 1906: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f0, %r22
	.word 0xd4af6000  ! 1908: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd88d04a0  ! 1909: LDUBA_R	lduba	[%r20, %r0] 0x25, %r12
	.word 0x8780204f  ! 1910: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 1911: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbee000  ! 1912: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	.word 0xdc9e6000  ! 1913: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r14
	.word 0xdcdea000  ! 1914: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r14
	.word 0x87802074  ! 1915: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb78e40  ! 1916: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	mov	0x7e0, %r21
	.word 0xdac5e000  ! 1918: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r13
	mov	0x7c8, %r22
	.word 0xd6cf8e80  ! 1920: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r11
	.word 0xd097ce60  ! 1921: LDUHA_R	lduha	[%r31, %r0] 0x73, %r8
	.word 0x87802025  ! 1922: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde874e80  ! 1923: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r15
	mov	0x28, %r25
	.word 0xd8dfe000  ! 1925: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	mov	0x38, %r16
	.word 0xd8a72000  ! 1927: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	mov	0x18, %r26
	mov	0x7d0, %r23
	.word 0xd8afe000  ! 1930: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd8cfe000  ! 1931: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8b76000  ! 1932: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 1933: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8dce000  ! 1935: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	mov	0x50, %r18
	mov	0x20, %r25
	.word 0xdacc8400  ! 1938: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r13
	.word 0xd0cf4e80  ! 1939: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r8
	.word 0xd8f40400  ! 1940: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xdcd4a000  ! 1941: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	.word 0xdcf4e000  ! 1942: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	mov	0x3c0, %r20
	mov	0x28, %r25
	.word 0xd4ccc400  ! 1945: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0x87802020  ! 1946: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1947: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0aee000  ! 1948: STBA_I	stba	%r8, [%r27 + 0x0000] %asi
	.word 0xd88f4e80  ! 1949: LDUBA_R	lduba	[%r29, %r0] 0x74, %r12
	.word 0x87802073  ! 1950: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdabe89e0  ! 1951: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	.word 0xdcbee000  ! 1952: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	.word 0xdcd66000  ! 1953: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r14
	.word 0xded504a0  ! 1954: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r15
	.word 0xdec6a000  ! 1955: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r15
	.word 0xdec66000  ! 1956: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r15
	.word 0xde9ee000  ! 1957: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r15
	.word 0xd6c544a0  ! 1958: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r11
	.word 0xdedea000  ! 1959: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r15
	.word 0xdabc8400  ! 1960: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	.word 0xd6f62000  ! 1961: STXA_I	stxa	%r11, [%r24 + 0x0000] %asi
	mov	0x3d0, %r21
	mov	0x48, %r24
	mov	0x18, %r27
	.word 0xd8f4c400  ! 1965: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xdeaf4e60  ! 1966: STBA_R	stba	%r15, [%r29 + %r0] 0x73
	mov	0x38, %r26
	mov	0x3f0, %r20
	mov	0x48, %r18
	mov	0x28, %r19
	mov	0x40, %r24
	.word 0xd296e000  ! 1972: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r9
	mov	0x8, %r16
	.word 0xd89504a0  ! 1974: LDUHA_R	lduha	[%r20, %r0] 0x25, %r12
	.word 0x87802025  ! 1975: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0dfe000  ! 1976: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	mov	0x30, %r16
	.word 0xd4bc8400  ! 1978: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	.word 0xd4d74e80  ! 1979: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r10
	.word 0xdeaf0e40  ! 1980: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	.word 0x87802073  ! 1981: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r16
	mov	0x38, %r19
	.word 0xd8d70e80  ! 1984: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r12
	.word 0xdabf8e60  ! 1985: STDA_R	stda	%r13, [%r30 + %r0] 0x73
	.word 0xdcb72000  ! 1986: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 1987: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca56000  ! 1988: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	mov	0x7f8, %r23
	mov	0x0, %r17
	.word 0xd6dcc400  ! 1991: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	mov	0x8, %r27
	.word 0x87802020  ! 1993: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded46000  ! 1994: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	.word 0xd4ce49e0  ! 1995: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r10
	.word 0xdcdce000  ! 1996: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r14
	.word 0xd285c4a0  ! 1997: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r9
	.word 0xd494e000  ! 1998: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	.word 0xd2bec9e0  ! 1999: STDA_R	stda	%r9, [%r27 + %r0] 0x4f
	.word 0xdea42000  ! 2000: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xde84a000  ! 2001: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	.word 0xd0af4e60  ! 2002: STBA_R	stba	%r8, [%r29 + %r0] 0x73
	.word 0xd0b544a0  ! 2003: STHA_R	stha	%r8, [%r21 + %r0] 0x25
	.word 0x87802073  ! 2004: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd49f8e40  ! 2005: LDDA_R	ldda	[%r30, %r0] 0x72, %r10
	.word 0xd4df6000  ! 2006: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4afe000  ! 2007: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd0f40400  ! 2008: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0x87802020  ! 2009: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r21
	.word 0x8780204f  ! 2011: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a42000  ! 2012: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0xd29ce000  ! 2014: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	mov	0x7e8, %r21
	mov	0x48, %r27
	mov	0x48, %r18
	.word 0xd2a4a000  ! 2018: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	mov	0x68, %r18
	.word 0xdec5c4a0  ! 2020: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r15
	.word 0xdebc0400  ! 2021: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	mov	0x28, %r25
	.word 0xd2c42000  ! 2023: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	.word 0x87802072  ! 2024: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd28f6000  ! 2025: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd6a70e80  ! 2026: STWA_R	stwa	%r11, [%r28 + %r0] 0x74
	.word 0xde8fce40  ! 2027: LDUBA_R	lduba	[%r31, %r0] 0x72, %r15
	.word 0xd4bf6000  ! 2028: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	mov	0x78, %r16
	mov	0x3f8, %r22
	mov	0x40, %r27
	.word 0xdec78e40  ! 2032: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r15
	mov	0x10, %r17
	.word 0x87802025  ! 2034: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bfe000  ! 2035: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xd8bf6000  ! 2037: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	mov	0x48, %r19
	.word 0xd887a000  ! 2039: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8c72000  ! 2040: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802074  ! 2042: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r19
	.word 0xd8df6000  ! 2044: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0xdaae09e0  ! 2045: STBA_R	stba	%r13, [%r24 + %r0] 0x4f
	.word 0xd8a72000  ! 2046: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	mov	0x38, %r16
	.word 0x8780204f  ! 2048: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 2049: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c0, %r21
	mov	0x18, %r26
	.word 0xd8a6a000  ! 2052: STWA_I	stwa	%r12, [%r26 + 0x0000] %asi
	.word 0xd8b6a000  ! 2053: STHA_I	stha	%r12, [%r26 + 0x0000] %asi
	mov	0x3c0, %r22
	mov	0x60, %r25
	.word 0xdcf78e40  ! 2056: STXA_R	stxa	%r14, [%r30 + %r0] 0x72
	.word 0xd8f70e60  ! 2057: STXA_R	stxa	%r12, [%r28 + %r0] 0x73
	mov	0x48, %r25
	.word 0xdc8e49e0  ! 2059: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r14
	.word 0xd4cd04a0  ! 2060: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r10
	.word 0xdcbf4e40  ! 2061: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	.word 0x87802025  ! 2062: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc874e40  ! 2063: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r14
	.word 0xdcf5e000  ! 2064: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 2065: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb52000  ! 2066: STHA_I	stha	%r14, [%r20 + 0x0000] %asi
	.word 0xd4f40400  ! 2067: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0x87802020  ! 2068: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcafe000  ! 2069: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdcf76000  ! 2070: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcd7e000  ! 2071: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xdaa584a0  ! 2072: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	.word 0xd2ce09e0  ! 2073: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r9
	.word 0xd6972000  ! 2074: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	mov	0x7c0, %r21
	mov	0x18, %r26
	.word 0xdedd04a0  ! 2077: LDXA_R	ldxa	[%r20, %r0] 0x25, %r15
	.word 0xd6b7e000  ! 2078: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd6f74e60  ! 2079: STXA_R	stxa	%r11, [%r29 + %r0] 0x73
	.word 0xd2972000  ! 2080: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xd2df2000  ! 2081: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	mov	0x3c8, %r22
	mov	0x68, %r16
	.word 0xd2a72000  ! 2084: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0xd2d7a000  ! 2085: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0xd2afa000  ! 2086: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xd2bf2000  ! 2087: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd6bf4e80  ! 2088: STDA_R	stda	%r11, [%r29 + %r0] 0x74
	.word 0xd8bf2000  ! 2089: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2090: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bc4400  ! 2091: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xd6acc400  ! 2092: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	mov	0x40, %r17
	.word 0x87802020  ! 2094: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca7ce40  ! 2095: STWA_R	stwa	%r14, [%r31 + %r0] 0x72
	.word 0xd8dc0400  ! 2096: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0xd4f40400  ! 2097: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xd0f52000  ! 2098: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	.word 0xd0c4c400  ! 2099: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	.word 0xd68f4e60  ! 2100: LDUBA_R	lduba	[%r29, %r0] 0x73, %r11
	.word 0xdaaf0e40  ! 2101: STBA_R	stba	%r13, [%r28 + %r0] 0x72
	.word 0xd08ec9e0  ! 2102: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r8
	.word 0x87802073  ! 2103: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2104: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f66000  ! 2105: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	mov	0x38, %r18
	.word 0xd0aea000  ! 2107: STBA_I	stba	%r8, [%r26 + 0x0000] %asi
	.word 0xda9d44a0  ! 2108: LDDA_R	ldda	[%r21, %r0] 0x25, %r13
	.word 0xdef70e80  ! 2109: STXA_R	stxa	%r15, [%r28 + %r0] 0x74
	.word 0xd4970e60  ! 2110: LDUHA_R	lduha	[%r28, %r0] 0x73, %r10
	.word 0xd8c6e000  ! 2111: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2112: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r25
	.word 0xd8d5e000  ! 2114: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r12
	mov	0x78, %r24
	.word 0xd8d52000  ! 2116: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r12
	.word 0x87802072  ! 2117: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8d46000  ! 2118: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	.word 0x87802074  ! 2119: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f6e000  ! 2120: STXA_I	stxa	%r12, [%r27 + 0x0000] %asi
	mov	0x70, %r16
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdebf0e80  ! 2123: STDA_R	stda	%r15, [%r28 + %r0] 0x74
	.word 0xde948400  ! 2124: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	mov	0x7e0, %r22
	.word 0x87802074  ! 2126: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca6e000  ! 2127: STWA_I	stwa	%r14, [%r27 + 0x0000] %asi
	.word 0xd0f70e40  ! 2128: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	.word 0xd0a62000  ! 2129: STWA_I	stwa	%r8, [%r24 + 0x0000] %asi
	mov	0x7e8, %r21
	mov	0x58, %r27
	.word 0xd0c62000  ! 2132: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r8
	.word 0xd0de6000  ! 2133: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r8
	.word 0xdacc0400  ! 2134: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r13
	.word 0x8780204f  ! 2135: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0cde000  ! 2136: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r8
	.word 0xd0f5a000  ! 2137: STXA_I	stxa	%r8, [%r22 + 0x0000] %asi
	.word 0xd4ac0400  ! 2138: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xd08f4e60  ! 2139: LDUBA_R	lduba	[%r29, %r0] 0x73, %r8
	mov	0x50, %r25
	.word 0xd68d6000  ! 2141: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r11
	mov	0x10, %r17
	.word 0xde9f4e60  ! 2143: LDDA_R	ldda	[%r29, %r0] 0x73, %r15
	.word 0xd6bfce60  ! 2144: STDA_R	stda	%r11, [%r31 + %r0] 0x73
	.word 0xd8a52000  ! 2145: STWA_I	stwa	%r12, [%r20 + 0x0000] %asi
	.word 0xd2bcc400  ! 2146: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xd0f78e80  ! 2147: STXA_R	stxa	%r8, [%r30 + %r0] 0x74
	.word 0xd8cd2000  ! 2148: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r12
	mov	0x3c8, %r21
	.word 0xd8c56000  ! 2150: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r12
	.word 0xd8f5a000  ! 2151: STXA_I	stxa	%r12, [%r22 + 0x0000] %asi
	.word 0xd8856000  ! 2152: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	mov	0x38, %r24
	mov	0x7f8, %r23
	.word 0x87802074  ! 2155: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8c4a000  ! 2156: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r12
	.word 0xd8a46000  ! 2157: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8ac2000  ! 2158: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0xd2978e40  ! 2159: LDUHA_R	lduha	[%r30, %r0] 0x72, %r9
	.word 0xdaace000  ! 2160: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 2161: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa46000  ! 2162: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	.word 0xdab42000  ! 2163: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xd4a5c4a0  ! 2164: STWA_R	stwa	%r10, [%r23 + %r0] 0x25
	.word 0xd0974e80  ! 2165: LDUHA_R	lduha	[%r29, %r0] 0x74, %r8
	.word 0x87802074  ! 2166: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r19
	.word 0xdaaf2000  ! 2168: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	mov	0x60, %r16
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdabf6000  ! 2171: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xd2970e80  ! 2172: LDUHA_R	lduha	[%r28, %r0] 0x74, %r9
	mov	0x8, %r17
	mov	0x7f8, %r22
	mov	0x3f8, %r20
	.word 0x87802072  ! 2176: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f7a000  ! 2177: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd48c8400  ! 2178: LDUBA_R	lduba	[%r18, %r0] 0x20, %r10
	.word 0xd2d74e40  ! 2179: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r9
	.word 0xd88f2000  ! 2180: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	mov	0x3d0, %r20
	.word 0xd6bf4e60  ! 2182: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	.word 0xdcb7e000  ! 2183: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0x87802073  ! 2185: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 2186: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcdfe000  ! 2187: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcbfe000  ! 2188: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xd8a48400  ! 2189: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	mov	0x40, %r27
	.word 0x87802074  ! 2191: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbfe000  ! 2192: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 2193: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda944400  ! 2194: LDUHA_R	lduha	[%r17, %r0] 0x20, %r13
	.word 0xdeb6a000  ! 2195: STHA_I	stha	%r15, [%r26 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0x87802074  ! 2197: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r19
	mov	0x3e0, %r21
	mov	0x3d0, %r20
	.word 0xd6afce40  ! 2201: STBA_R	stba	%r11, [%r31 + %r0] 0x72
	mov	0x7d8, %r20
	.word 0xd0f66000  ! 2203: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	mov	0x78, %r19
	.word 0x87802020  ! 2205: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bd84a0  ! 2206: STDA_R	stda	%r10, [%r22 + %r0] 0x25
	.word 0xdaf56000  ! 2207: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	.word 0xde970e60  ! 2208: LDUHA_R	lduha	[%r28, %r0] 0x73, %r15
	mov	0x40, %r26
	.word 0x8780204f  ! 2210: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8962000  ! 2211: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r12
	.word 0x87802074  ! 2212: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacfce60  ! 2213: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r13
	.word 0x87802025  ! 2214: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 2215: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca78e60  ! 2216: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	.word 0x87802020  ! 2217: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r18
	.word 0xdab72000  ! 2219: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xd4848400  ! 2220: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r10
	.word 0xd6cf4e40  ! 2221: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r11
	.word 0x87802072  ! 2222: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcc78e60  ! 2223: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r14
	.word 0xdecf0e60  ! 2224: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r15
	.word 0xdca70e60  ! 2225: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	.word 0xd4cc6000  ! 2226: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	.word 0xd4ac6000  ! 2227: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	.word 0xd0f70e40  ! 2228: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	.word 0x87802020  ! 2229: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0956000  ! 2230: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r8
	mov	0x58, %r25
	mov	0x60, %r24
	.word 0xd0c7ce40  ! 2233: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r8
	mov	0x78, %r26
	.word 0xd4bf4e80  ! 2235: STDA_R	stda	%r10, [%r29 + %r0] 0x74
	.word 0x87802072  ! 2236: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f5a000  ! 2237: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	mov	0x8, %r17
	.word 0xd4ada000  ! 2239: STBA_I	stba	%r10, [%r22 + 0x0000] %asi
	.word 0xd4c5e000  ! 2240: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r10
	.word 0xd4ade000  ! 2241: STBA_I	stba	%r10, [%r23 + 0x0000] %asi
	mov	0x60, %r19
	mov	0x78, %r24
	.word 0xd49de000  ! 2244: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r10
	.word 0xd485a000  ! 2245: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r10
	.word 0xd6f7ce40  ! 2246: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 2247: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea70e40  ! 2248: STWA_R	stwa	%r15, [%r28 + %r0] 0x72
	mov	0x0, %r25
	mov	0x38, %r26
	mov	0x0, %r24
	.word 0xd2af4e80  ! 2252: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	.word 0x87802020  ! 2253: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bc0400  ! 2254: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xd8944400  ! 2255: LDUHA_R	lduha	[%r17, %r0] 0x20, %r12
	.word 0xd2bc2000  ! 2256: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	mov	0x20, %r25
	.word 0x87802073  ! 2258: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2d52000  ! 2259: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r9
	.word 0xd285a000  ! 2260: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r9
	.word 0xd0c48400  ! 2261: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r8
	.word 0xd8852000  ! 2262: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r12
	.word 0xdaaf4e80  ! 2263: STBA_R	stba	%r13, [%r29 + %r0] 0x74
	.word 0xd8b52000  ! 2264: STHA_I	stha	%r12, [%r20 + 0x0000] %asi
	.word 0xd0a544a0  ! 2265: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	mov	0x3d8, %r21
	.word 0xd8bde000  ! 2267: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0xd89de000  ! 2268: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r12
	.word 0xd8d5e000  ! 2269: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r12
	.word 0xd4c609e0  ! 2270: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r10
	.word 0xdcada000  ! 2271: STBA_I	stba	%r14, [%r22 + 0x0000] %asi
	mov	0x3d0, %r21
	.word 0x87802020  ! 2273: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r17
	.word 0xdabc0400  ! 2275: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xdaad44a0  ! 2276: STBA_R	stba	%r13, [%r21 + %r0] 0x25
	.word 0xd686a000  ! 2277: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r11
	.word 0xd6aea000  ! 2278: STBA_I	stba	%r11, [%r26 + 0x0000] %asi
	.word 0xd6a62000  ! 2279: STWA_I	stwa	%r11, [%r24 + 0x0000] %asi
	mov	0x8, %r26
	.word 0xd09fce80  ! 2281: LDDA_R	ldda	[%r31, %r0] 0x74, %r8
	.word 0xd0c6e000  ! 2282: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r8
	mov	0x50, %r16
	.word 0xdcb649e0  ! 2284: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	.word 0xd0862000  ! 2285: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r8
	.word 0x87802020  ! 2286: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2287: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d8, %r20
	.word 0xd8f609e0  ! 2289: STXA_R	stxa	%r12, [%r24 + %r0] 0x4f
	.word 0xdcdec9e0  ! 2290: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r14
	.word 0xd4a62000  ! 2291: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	.word 0xd4ce6000  ! 2292: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r10
	.word 0xdc948400  ! 2293: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	.word 0xd0df0e40  ! 2294: LDXA_R	ldxa	[%r28, %r0] 0x72, %r8
	.word 0x8780204f  ! 2295: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda8d44a0  ! 2296: LDUBA_R	lduba	[%r21, %r0] 0x25, %r13
	.word 0xd694c400  ! 2297: LDUHA_R	lduha	[%r19, %r0] 0x20, %r11
	mov	0x8, %r26
	mov	0x78, %r25
	.word 0xdc97ce80  ! 2300: LDUHA_R	lduha	[%r31, %r0] 0x74, %r14
	.word 0xd49f0e60  ! 2301: LDDA_R	ldda	[%r28, %r0] 0x73, %r10
	.word 0xd4b5a000  ! 2302: STHA_I	stha	%r10, [%r22 + 0x0000] %asi
	.word 0xd4ada000  ! 2303: STBA_I	stba	%r10, [%r22 + 0x0000] %asi
	.word 0xd4956000  ! 2304: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r10
	.word 0xdebc4400  ! 2305: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0xd6b52000  ! 2306: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	.word 0xd6956000  ! 2307: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r11
	.word 0xdea70e40  ! 2308: STWA_R	stwa	%r15, [%r28 + %r0] 0x72
	.word 0xd0cda000  ! 2309: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r8
	.word 0x87802072  ! 2310: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8f78e40  ! 2311: STXA_R	stxa	%r12, [%r30 + %r0] 0x72
	.word 0xd08c8400  ! 2312: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0xd2c544a0  ! 2313: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r9
	.word 0xd6b72000  ! 2314: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd4878e80  ! 2315: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r10
	.word 0xdaa504a0  ! 2316: STWA_R	stwa	%r13, [%r20 + %r0] 0x25
	.word 0xdea7e000  ! 2317: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xdecfa000  ! 2318: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	mov	0x48, %r25
	.word 0xd0af8e40  ! 2320: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0xd8876000  ! 2321: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	mov	0x8, %r18
	.word 0xd0dd04a0  ! 2323: LDXA_R	ldxa	[%r20, %r0] 0x25, %r8
	.word 0x8780204f  ! 2324: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f5a000  ! 2325: STXA_I	stxa	%r8, [%r22 + 0x0000] %asi
	.word 0xd0b52000  ! 2326: STHA_I	stha	%r8, [%r20 + 0x0000] %asi
	.word 0xd0f56000  ! 2327: STXA_I	stxa	%r8, [%r21 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0xd89cc400  ! 2329: LDDA_R	ldda	[%r19, %r0] 0x20, %r12
	mov	0x7d8, %r21
	.word 0x8780204f  ! 2331: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r16
	mov	0x3f0, %r22
	.word 0xdedfa000  ! 2334: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xdef7e000  ! 2335: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xd4bf4e60  ! 2336: STDA_R	stda	%r10, [%r29 + %r0] 0x73
	mov	0x3c0, %r22
	mov	0x18, %r19
	.word 0xd2afe000  ! 2339: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd2a7e000  ! 2340: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	mov	0x3f8, %r21
	mov	0x7d0, %r22
	.word 0xdea504a0  ! 2343: STWA_R	stwa	%r15, [%r20 + %r0] 0x25
	.word 0xd0876000  ! 2344: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	mov	0x8, %r19
	mov	0x3c8, %r22
	.word 0xde844400  ! 2347: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	.word 0xded6c9e0  ! 2348: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r15
	.word 0xdec76000  ! 2349: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 2350: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2351: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2352: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebca000  ! 2353: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xd2b5c4a0  ! 2354: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	.word 0xd2ae49e0  ! 2355: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	.word 0x8780204f  ! 2356: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4af4e80  ! 2357: STBA_R	stba	%r10, [%r29 + %r0] 0x74
	.word 0xd6f544a0  ! 2358: STXA_R	stxa	%r11, [%r21 + %r0] 0x25
	mov	0x48, %r25
	.word 0xd2bc4400  ! 2360: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0xd48f2000  ! 2361: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4972000  ! 2362: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	mov	0x70, %r27
	mov	0x7c8, %r21
	.word 0xd6ce49e0  ! 2365: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r11
	.word 0x8780204f  ! 2366: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r24
	.word 0x87802073  ! 2368: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb72000  ! 2369: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xd88c0400  ! 2370: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	.word 0xd89fa000  ! 2371: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	.word 0xd89fa000  ! 2372: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	.word 0x87802074  ! 2373: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r16
	.word 0xd8b42000  ! 2375: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	.word 0xde9c8400  ! 2376: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	.word 0xdaac2000  ! 2377: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0xdcbf8e60  ! 2378: STDA_R	stda	%r14, [%r30 + %r0] 0x73
	mov	0x28, %r16
	.word 0xd4b4a000  ! 2380: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0xd4f42000  ! 2381: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd48c4400  ! 2382: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0xd08cc400  ! 2383: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	mov	0x7f8, %r22
	.word 0xda9f8e80  ! 2385: LDDA_R	ldda	[%r30, %r0] 0x74, %r13
	mov	0x3f8, %r20
	mov	0x60, %r24
	.word 0xd08649e0  ! 2388: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r8
	.word 0x87802072  ! 2389: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f8, %r22
	.word 0x87802020  ! 2391: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r21
	mov	0x50, %r17
	.word 0xd4dfe000  ! 2394: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4b649e0  ! 2395: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	.word 0x87802074  ! 2396: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2397: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b72000  ! 2398: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2399: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bde000  ! 2400: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd285e000  ! 2402: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r9
	.word 0xd4f44400  ! 2403: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	mov	0x60, %r25
	.word 0xd08de000  ! 2405: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r8
	.word 0xdcc44400  ! 2406: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	mov	0x70, %r27
	.word 0xd8af0e60  ! 2408: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	.word 0xdeac4400  ! 2409: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0xd88d2000  ! 2410: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r12
	.word 0xd2cf8e40  ! 2411: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r9
	mov	0x10, %r25
	.word 0xdea5e000  ! 2413: STWA_I	stwa	%r15, [%r23 + 0x0000] %asi
	mov	0x0, %r27
	.word 0xdaae89e0  ! 2415: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	.word 0xdea7ce80  ! 2416: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	mov	0x20, %r24
	.word 0x87802025  ! 2418: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r19
	.word 0xd0afce40  ! 2420: STBA_R	stba	%r8, [%r31 + %r0] 0x72
	mov	0x78, %r18
	.word 0xde946000  ! 2422: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r15
	.word 0xdeaca000  ! 2423: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xdeb78e60  ! 2424: STHA_R	stha	%r15, [%r30 + %r0] 0x73
	.word 0x8780204f  ! 2425: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c0, %r20
	.word 0xdac46000  ! 2427: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r13
	.word 0x87802072  ! 2428: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f0, %r23
	mov	0x7d8, %r22
	.word 0xd89dc4a0  ! 2431: LDDA_R	ldda	[%r23, %r0] 0x25, %r12
	.word 0xdebfe000  ! 2432: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xdef7e000  ! 2433: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 2434: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2435: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r18
	.word 0x87802020  ! 2437: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2438: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r25
	.word 0x87802074  ! 2440: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdebf2000  ! 2441: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xdaa70e60  ! 2442: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	.word 0x87802020  ! 2443: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r26
	.word 0xd09f0e40  ! 2445: LDDA_R	ldda	[%r28, %r0] 0x72, %r8
	.word 0xdeac6000  ! 2446: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xdade09e0  ! 2447: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r13
	.word 0xd2844400  ! 2448: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	.word 0xd8bca000  ! 2449: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd4b44400  ! 2450: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	mov	0x50, %r25
	mov	0x70, %r27
	.word 0xd2b42000  ! 2453: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 2454: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2455: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r26
	.word 0x87802073  ! 2457: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 2458: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2d7a000  ! 2459: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0xd88d44a0  ! 2460: LDUBA_R	lduba	[%r21, %r0] 0x25, %r12
	.word 0xd4afce80  ! 2461: STBA_R	stba	%r10, [%r31 + %r0] 0x74
	.word 0xda876000  ! 2462: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	mov	0x30, %r24
	.word 0xdab7e000  ! 2464: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xd8b40400  ! 2465: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	mov	0x7c8, %r20
	mov	0x58, %r18
	.word 0x8780204f  ! 2468: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda8da000  ! 2469: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r13
	.word 0xd2b689e0  ! 2470: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	.word 0xd29de000  ! 2471: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r9
	.word 0xd2ae89e0  ! 2472: STBA_R	stba	%r9, [%r26 + %r0] 0x4f
	.word 0xd6dc4400  ! 2473: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xd4ae89e0  ! 2474: STBA_R	stba	%r10, [%r26 + %r0] 0x4f
	.word 0xdc874e40  ! 2475: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r14
	.word 0x87802072  ! 2476: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 2477: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4b78e60  ! 2478: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	.word 0xd4d7a000  ! 2479: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	mov	0x10, %r24
	mov	0x18, %r17
	.word 0xd4cdc4a0  ! 2482: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r10
	.word 0xda972000  ! 2483: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0xd0f78e60  ! 2484: STXA_R	stxa	%r8, [%r30 + %r0] 0x73
	.word 0xdabfa000  ! 2485: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 2486: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebf8e40  ! 2487: STDA_R	stda	%r15, [%r30 + %r0] 0x72
	.word 0xd4dc2000  ! 2488: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	.word 0xd4a42000  ! 2489: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0xd8b7ce80  ! 2490: STHA_R	stha	%r12, [%r31 + %r0] 0x74
	mov	0x30, %r18
	.word 0xdac649e0  ! 2492: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r13
	mov	0x38, %r16
	.word 0xd084e000  ! 2494: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	.word 0xdcd4c400  ! 2495: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	.word 0xd8ac0400  ! 2496: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xde8ce000  ! 2497: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	.word 0xdad48400  ! 2498: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	mov	0x70, %r18
	.word 0x87802074  ! 2500: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r19
	.word 0xd2df2000  ! 2502: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2503: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2c76000  ! 2504: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0x87802025  ! 2505: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdadcc400  ! 2506: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xd6d78e60  ! 2507: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r11
	mov	0x58, %r27
	.word 0xdca5a000  ! 2509: STWA_I	stwa	%r14, [%r22 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0xdcdc4400  ! 2511: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	.word 0x87802073  ! 2512: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r16
	.word 0xdeb6e000  ! 2514: STHA_I	stha	%r15, [%r27 + 0x0000] %asi
	mov	0x78, %r27
	.word 0xd0f70e60  ! 2516: STXA_R	stxa	%r8, [%r28 + %r0] 0x73
	mov	0x50, %r24
	.word 0xdcbe2000  ! 2518: STDA_I	stda	%r14, [%r24 + 0x0000] %asi
	.word 0xd6b44400  ! 2519: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xd2b689e0  ! 2520: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	mov	0x48, %r16
	.word 0xd496c9e0  ! 2522: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r10
	.word 0xdcb44400  ! 2523: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	mov	0x28, %r27
	mov	0x3e0, %r21
	.word 0x87802074  ! 2526: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca7a000  ! 2527: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdccf2000  ! 2528: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xdca72000  ! 2529: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcbfe000  ! 2530: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	mov	0x30, %r16
	.word 0x87802074  ! 2532: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 2533: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdec584a0  ! 2534: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r15
	.word 0x87802074  ! 2535: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2536: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6dc6000  ! 2537: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r11
	.word 0xd6a42000  ! 2538: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xda97ce40  ! 2539: LDUHA_R	lduha	[%r31, %r0] 0x72, %r13
	.word 0xdaa4e000  ! 2540: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 2541: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f7ce80  ! 2542: STXA_R	stxa	%r8, [%r31 + %r0] 0x74
	.word 0xda9fa000  ! 2543: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xdabec9e0  ! 2544: STDA_R	stda	%r13, [%r27 + %r0] 0x4f
	mov	0x68, %r25
	.word 0x8780204f  ! 2546: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc8f8e60  ! 2547: LDUBA_R	lduba	[%r30, %r0] 0x73, %r14
	.word 0xdcdc6000  ! 2548: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	.word 0xdcb46000  ! 2549: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xda94c400  ! 2550: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	.word 0xd2d46000  ! 2551: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	.word 0x87802025  ! 2552: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd48c0400  ! 2553: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	.word 0xda84c400  ! 2554: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r13
	.word 0xd6bc0400  ! 2555: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0x87802072  ! 2556: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8f76000  ! 2557: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd0bf8e80  ! 2558: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	.word 0xd09544a0  ! 2559: LDUHA_R	lduha	[%r21, %r0] 0x25, %r8
	.word 0xd6afa000  ! 2560: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 2561: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2562: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2563: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f7ce60  ! 2564: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	.word 0xdaf584a0  ! 2565: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	.word 0x87802074  ! 2566: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r17
	.word 0xd0c72000  ! 2568: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xdcb70e60  ! 2569: STHA_R	stha	%r14, [%r28 + %r0] 0x73
	.word 0xd4d7e000  ! 2570: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	.word 0xd6cc4400  ! 2571: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	.word 0xd2df2000  ! 2572: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2b7a000  ! 2573: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd0cc0400  ! 2574: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xd0b7e000  ! 2575: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 2576: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0856000  ! 2577: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r8
	mov	0x3d8, %r23
	mov	0x30, %r17
	mov	0x0, %r25
	.word 0xd0856000  ! 2581: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r8
	.word 0xd08d2000  ! 2582: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r8
	.word 0xd2a78e40  ! 2583: STWA_R	stwa	%r9, [%r30 + %r0] 0x72
	.word 0xd8f78e80  ! 2584: STXA_R	stxa	%r12, [%r30 + %r0] 0x74
	.word 0xdab44400  ! 2585: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	mov	0x7d8, %r20
	.word 0xded40400  ! 2587: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	.word 0xd8f52000  ! 2588: STXA_I	stxa	%r12, [%r20 + 0x0000] %asi
	.word 0xd0bfce60  ! 2589: STDA_R	stda	%r8, [%r31 + %r0] 0x73
	.word 0x87802020  ! 2590: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r18
	.word 0x87802072  ! 2592: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde8fa000  ! 2593: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0x87802020  ! 2594: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2595: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2596: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r17
	.word 0x8780204f  ! 2598: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ce09e0  ! 2599: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r12
	.word 0xd2b6e000  ! 2600: STHA_I	stha	%r9, [%r27 + 0x0000] %asi
	.word 0x87802074  ! 2601: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2602: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabf8e80  ! 2603: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	.word 0xd6f48400  ! 2604: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	mov	0x30, %r25
	mov	0x30, %r27
	.word 0xdcf7e000  ! 2607: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x3d0, %r21
	.word 0xdcc76000  ! 2609: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xdcc7a000  ! 2610: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	mov	0x3f8, %r23
	.word 0xdea40400  ! 2612: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xd2f72000  ! 2613: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2614: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r20
	mov	0x3f8, %r20
	.word 0xdaf7ce40  ! 2617: STXA_R	stxa	%r13, [%r31 + %r0] 0x72
	.word 0xdea78e80  ! 2618: STWA_R	stwa	%r15, [%r30 + %r0] 0x74
	mov	0x40, %r25
	.word 0xd6ae6000  ! 2620: STBA_I	stba	%r11, [%r25 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x40, %r19
	.word 0xd6aee000  ! 2623: STBA_I	stba	%r11, [%r27 + 0x0000] %asi
	.word 0xd6966000  ! 2624: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r11
	.word 0xd6f6e000  ! 2625: STXA_I	stxa	%r11, [%r27 + 0x0000] %asi
	.word 0xd09f8e40  ! 2626: LDDA_R	ldda	[%r30, %r0] 0x72, %r8
	.word 0xd2aee000  ! 2627: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	.word 0xda8f8e60  ! 2628: LDUBA_R	lduba	[%r30, %r0] 0x73, %r13
	.word 0xd8f6a000  ! 2629: STXA_I	stxa	%r12, [%r26 + 0x0000] %asi
	.word 0xd687ce40  ! 2630: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r11
	mov	0x50, %r18
	.word 0xdca70e40  ! 2632: STWA_R	stwa	%r14, [%r28 + %r0] 0x72
	.word 0x87802072  ! 2633: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r26
	mov	0x3f0, %r20
	.word 0x87802073  ! 2636: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8cf0e40  ! 2637: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r12
	.word 0xd8aea000  ! 2638: STBA_I	stba	%r12, [%r26 + 0x0000] %asi
	.word 0xd8b62000  ! 2639: STHA_I	stha	%r12, [%r24 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0xdeae09e0  ! 2641: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	.word 0xdc86a000  ! 2642: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r14
	.word 0x87802025  ! 2643: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc94a000  ! 2644: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xdca584a0  ! 2645: STWA_R	stwa	%r14, [%r22 + %r0] 0x25
	.word 0xd0dc4400  ! 2646: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	.word 0x87802025  ! 2647: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebce000  ! 2648: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xdea4e000  ! 2649: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xd6a7ce60  ! 2650: STWA_R	stwa	%r11, [%r31 + %r0] 0x73
	.word 0xdea40400  ! 2651: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0x87802072  ! 2652: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2d46000  ! 2653: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	.word 0xd68f8e60  ! 2654: LDUBA_R	lduba	[%r30, %r0] 0x73, %r11
	mov	0x3f0, %r22
	ta	T_CHANGE_HPRIV	! macro
	.word 0xded70e60  ! 2657: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r15
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2d544a0  ! 2659: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r9
	.word 0xd6ac2000  ! 2660: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	.word 0xd4b4c400  ! 2661: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0xd89f0e40  ! 2662: LDDA_R	ldda	[%r28, %r0] 0x72, %r12
	.word 0xdcf46000  ! 2663: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdea44400  ! 2664: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	mov	0x28, %r24
	.word 0xd08c2000  ! 2666: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0xd4f7ce80  ! 2667: STXA_R	stxa	%r10, [%r31 + %r0] 0x74
	.word 0xdc94e000  ! 2668: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	mov	0x10, %r19
	.word 0xd89f4e60  ! 2670: LDDA_R	ldda	[%r29, %r0] 0x73, %r12
	.word 0xd48c6000  ! 2671: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r10
	.word 0xd6a4c400  ! 2672: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0xd4b5c4a0  ! 2673: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	.word 0x8780204f  ! 2674: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd09649e0  ! 2675: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r8
	.word 0x87802073  ! 2676: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf4c400  ! 2677: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xd0d609e0  ! 2678: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r8
	.word 0xda8e09e0  ! 2679: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r13
	.word 0x87802020  ! 2680: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad4e000  ! 2681: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r13
	mov	0x60, %r24
	.word 0xd2d649e0  ! 2683: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r9
	.word 0xdad46000  ! 2684: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	.word 0x87802073  ! 2685: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda946000  ! 2686: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	.word 0xdad4e000  ! 2687: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r13
	mov	0x3d8, %r23
	.word 0xdabca000  ! 2689: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	mov	0x50, %r18
	mov	0x18, %r24
	mov	0x40, %r19
	.word 0x87802020  ! 2693: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadfa000  ! 2694: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xde874e80  ! 2695: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r15
	.word 0xd0872000  ! 2696: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0972000  ! 2697: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0d76000  ! 2698: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 2699: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r24
	mov	0x7e0, %r23
	mov	0x30, %r17
	.word 0xd0bca000  ! 2703: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0xd0bca000  ! 2704: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xd0f4a000  ! 2706: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	mov	0x3e0, %r20
	.word 0xd0bce000  ! 2708: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	mov	0x40, %r27
	.word 0xd0a42000  ! 2710: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xd4848400  ! 2711: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r10
	mov	0x40, %r25
	.word 0xdcf42000  ! 2713: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 2714: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f8, %r21
	mov	0x38, %r18
	.word 0x87802074  ! 2717: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2718: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r16
	mov	0x48, %r16
	.word 0x87802020  ! 2721: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2722: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2de49e0  ! 2723: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r9
	.word 0xdab4a000  ! 2724: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0xd4f504a0  ! 2725: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0xd2c7ce80  ! 2726: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r9
	mov	0x30, %r19
	.word 0x87802025  ! 2728: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d8, %r21
	.word 0xdaf7e000  ! 2730: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xdac7a000  ! 2731: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	mov	0x3e8, %r20
	mov	0x68, %r18
	.word 0xdacf6000  ! 2734: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0x87802025  ! 2735: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r24
	.word 0x87802020  ! 2737: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r21
	.word 0xd68fce40  ! 2739: LDUBA_R	lduba	[%r31, %r0] 0x72, %r11
	.word 0xd0970e40  ! 2740: LDUHA_R	lduha	[%r28, %r0] 0x72, %r8
	.word 0xd0b46000  ! 2741: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	mov	0x38, %r24
	.word 0xd0aca000  ! 2743: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	mov	0x70, %r25
	.word 0x8780204f  ! 2745: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd09f2000  ! 2746: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	mov	0x3f8, %r21
	.word 0xd0c7a000  ! 2748: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	mov	0x10, %r24
	.word 0xd4b4c400  ! 2750: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	mov	0x28, %r16
	.word 0xd69fa000  ! 2752: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0xd6a504a0  ! 2753: STWA_R	stwa	%r11, [%r20 + %r0] 0x25
	mov	0x68, %r16
	.word 0xdcbe49e0  ! 2755: STDA_R	stda	%r14, [%r25 + %r0] 0x4f
	.word 0x87802074  ! 2756: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b7e000  ! 2757: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd4ad04a0  ! 2758: STBA_R	stba	%r10, [%r20 + %r0] 0x25
	.word 0xdc8f6000  ! 2759: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdccf6000  ! 2760: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcdf2000  ! 2761: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xde874e40  ! 2762: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r15
	mov	0x3e0, %r22
	.word 0xdab76000  ! 2764: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdab72000  ! 2765: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 2766: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 2767: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 2768: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r27
	.word 0xd8a74e80  ! 2770: STWA_R	stwa	%r12, [%r29 + %r0] 0x74
	mov	0x78, %r18
	.word 0xd2af6000  ! 2772: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 2773: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r16
	.word 0xd2aca000  ! 2775: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0xd0f44400  ! 2777: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	mov	0x8, %r18
	.word 0x87802020  ! 2779: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2780: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdad66000  ! 2781: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r13
	.word 0xdabee000  ! 2782: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	.word 0xdaf6e000  ! 2783: STXA_I	stxa	%r13, [%r27 + 0x0000] %asi
	mov	0x30, %r24
	.word 0xda9ee000  ! 2785: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2786: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2787: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda96a000  ! 2788: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r13
	.word 0xda9ea000  ! 2789: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r13
	mov	0x20, %r25
	mov	0x3e8, %r23
	.word 0xdaafce80  ! 2792: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	mov	0x3e0, %r20
	mov	0x30, %r25
	.word 0xdedea000  ! 2795: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r15
	.word 0xd28cc400  ! 2796: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	mov	0x7c8, %r21
	.word 0xd8d7ce40  ! 2798: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r12
	.word 0xd6cee000  ! 2799: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r11
	mov	0x48, %r17
	.word 0x8780204f  ! 2801: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b56000  ! 2802: STHA_I	stha	%r11, [%r21 + 0x0000] %asi
	mov	0x8, %r18
	.word 0xdab78e80  ! 2804: STHA_R	stha	%r13, [%r30 + %r0] 0x74
	.word 0xd8952000  ! 2805: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r12
	.word 0xd8c56000  ! 2806: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 2807: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c8, %r23
	.word 0xd0af8e80  ! 2809: STBA_R	stba	%r8, [%r30 + %r0] 0x74
	.word 0xdaaea000  ! 2810: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	mov	0x20, %r24
	.word 0xdabe2000  ! 2812: STDA_I	stda	%r13, [%r24 + 0x0000] %asi
	mov	0x3f0, %r21
	.word 0x8780204f  ! 2814: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdac4e000  ! 2815: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r13
	.word 0xd4bfce40  ! 2816: STDA_R	stda	%r10, [%r31 + %r0] 0x72
	.word 0xde85c4a0  ! 2817: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r15
	.word 0xd4a70e40  ! 2818: STWA_R	stwa	%r10, [%r28 + %r0] 0x72
	.word 0x8780204f  ! 2819: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r19
	.word 0xd2b72000  ! 2821: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd2d72000  ! 2822: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xd29fce60  ! 2823: LDDA_R	ldda	[%r31, %r0] 0x73, %r9
	.word 0xd29689e0  ! 2824: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r9
	.word 0xdcf609e0  ! 2825: STXA_R	stxa	%r14, [%r24 + %r0] 0x4f
	.word 0xd8bf4e40  ! 2826: STDA_R	stda	%r12, [%r29 + %r0] 0x72
	.word 0xd8df2000  ! 2827: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8c7a000  ! 2828: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xdaa4c400  ! 2829: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0xdeafa000  ! 2830: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xdef72000  ! 2831: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xdec72000  ! 2832: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xdeaf0e60  ! 2833: STBA_R	stba	%r15, [%r28 + %r0] 0x73
	.word 0xd48c4400  ! 2834: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0xdacfa000  ! 2835: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	mov	0x60, %r19
	.word 0xd68f0e40  ! 2837: LDUBA_R	lduba	[%r28, %r0] 0x72, %r11
	mov	0x78, %r17
	.word 0xd8b4c400  ! 2839: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0xdef72000  ! 2840: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xde97a000  ! 2841: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	.word 0xdcdd04a0  ! 2842: LDXA_R	ldxa	[%r20, %r0] 0x25, %r14
	mov	0x40, %r18
	.word 0xd0b48400  ! 2844: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	mov	0x7e8, %r20
	.word 0xda8fa000  ! 2846: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xd0974e40  ! 2847: LDUHA_R	lduha	[%r29, %r0] 0x72, %r8
	mov	0x58, %r19
	.word 0xd6b70e80  ! 2849: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	mov	0x20, %r18
	.word 0xd6a6c9e0  ! 2851: STWA_R	stwa	%r11, [%r27 + %r0] 0x4f
	.word 0xded7a000  ! 2852: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	mov	0x0, %r19
	.word 0xdcc44400  ! 2854: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xdef7e000  ! 2855: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	mov	0x7e0, %r21
	mov	0x40, %r25
	.word 0xd48f0e80  ! 2858: LDUBA_R	lduba	[%r28, %r0] 0x74, %r10
	.word 0xd6afce60  ! 2859: STBA_R	stba	%r11, [%r31 + %r0] 0x73
	mov	0x7f8, %r23
	.word 0xd4bf2000  ! 2861: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd4f7a000  ! 2862: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xdc9e49e0  ! 2863: LDDA_R	ldda	[%r25, %r0] 0x4f, %r14
	.word 0xd8dfe000  ! 2864: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	mov	0x3e0, %r23
	.word 0xd485c4a0  ! 2866: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r10
	.word 0xda8fe000  ! 2867: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	mov	0x38, %r27
	.word 0xdaaf6000  ! 2869: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	mov	0x38, %r27
	.word 0xdaf7a000  ! 2871: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdac76000  ! 2872: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	mov	0x7f8, %r21
	.word 0xdeb44400  ! 2874: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	mov	0x70, %r26
	.word 0xd4bf6000  ! 2876: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd2ac4400  ! 2877: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	mov	0x78, %r25
	.word 0x87802073  ! 2879: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b4a000  ! 2880: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0xd6ac8400  ! 2881: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0x87802073  ! 2882: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0c4e000  ! 2883: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	.word 0xdabf0e80  ! 2884: STDA_R	stda	%r13, [%r28 + %r0] 0x74
	mov	0x48, %r17
	.word 0xd8b4e000  ! 2886: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0xd6b78e40  ! 2887: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	.word 0xd49f0e80  ! 2888: LDDA_R	ldda	[%r28, %r0] 0x74, %r10
	.word 0xd68544a0  ! 2889: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r11
	.word 0x8780204f  ! 2890: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4c7a000  ! 2891: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	.word 0xdaa6c9e0  ! 2892: STWA_R	stwa	%r13, [%r27 + %r0] 0x4f
	.word 0x8780204f  ! 2893: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 2894: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda978e40  ! 2895: LDUHA_R	lduha	[%r30, %r0] 0x72, %r13
	.word 0x87802074  ! 2896: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 2897: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbce000  ! 2898: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xdc8c2000  ! 2899: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r14
	.word 0x87802025  ! 2900: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c0, %r21
	.word 0xd4b74e80  ! 2902: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	mov	0x3c0, %r21
	mov	0x28, %r27
	.word 0x87802020  ! 2905: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeaca000  ! 2906: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xd8a5c4a0  ! 2907: STWA_R	stwa	%r12, [%r23 + %r0] 0x25
	.word 0xdc9ce000  ! 2908: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r14
	mov	0x30, %r27
	.word 0x87802025  ! 2910: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c8, %r22
	.word 0xdcd6e000  ! 2912: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r14
	.word 0xdcae2000  ! 2913: STBA_I	stba	%r14, [%r24 + 0x0000] %asi
	.word 0x87802025  ! 2914: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf44400  ! 2915: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xd2d6e000  ! 2916: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r9
	.word 0xd28ee000  ! 2917: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r9
	.word 0xd2f6e000  ! 2918: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	.word 0xd2ce2000  ! 2919: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r9
	.word 0x87802072  ! 2920: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r18
	.word 0x87802073  ! 2922: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2876000  ! 2923: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2924: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2af4e80  ! 2925: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	.word 0xd6ac8400  ! 2926: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xdcf46000  ! 2927: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdcf4c400  ! 2928: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xd48fce40  ! 2929: LDUBA_R	lduba	[%r31, %r0] 0x72, %r10
	mov	0x70, %r16
	.word 0xdca6c9e0  ! 2931: STWA_R	stwa	%r14, [%r27 + %r0] 0x4f
	mov	0x20, %r17
	.word 0x87802072  ! 2933: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b7a000  ! 2934: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0xd2f7a000  ! 2936: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	mov	0x40, %r18
	mov	0x3e0, %r22
	.word 0x87802074  ! 2939: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f78e60  ! 2940: STXA_R	stxa	%r8, [%r30 + %r0] 0x73
	mov	0x30, %r25
	mov	0x3f8, %r23
	mov	0x38, %r27
	.word 0x87802020  ! 2944: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r21
	.word 0xdc8d2000  ! 2946: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r14
	.word 0xde870e80  ! 2947: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r15
	.word 0xd6c56000  ! 2948: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r11
	.word 0xdea78e40  ! 2949: STWA_R	stwa	%r15, [%r30 + %r0] 0x72
	.word 0xd4dda000  ! 2950: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r10
	.word 0xd2d48400  ! 2951: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	mov	0x38, %r27
	.word 0xd2b504a0  ! 2953: STHA_R	stha	%r9, [%r20 + %r0] 0x25
	mov	0x0, %r17
	.word 0xd8d504a0  ! 2955: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r12
	.word 0xd2b5a000  ! 2956: STHA_I	stha	%r9, [%r22 + 0x0000] %asi
	mov	0x50, %r26
	.word 0x87802025  ! 2958: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a584a0  ! 2959: STWA_R	stwa	%r11, [%r22 + %r0] 0x25
	.word 0xde8f0e60  ! 2960: LDUBA_R	lduba	[%r28, %r0] 0x73, %r15
	.word 0xd8af4e60  ! 2961: STBA_R	stba	%r12, [%r29 + %r0] 0x73
	.word 0xdeae6000  ! 2962: STBA_I	stba	%r15, [%r25 + 0x0000] %asi
	.word 0xda9f0e80  ! 2963: LDDA_R	ldda	[%r28, %r0] 0x74, %r13
	.word 0xd2b66000  ! 2964: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	.word 0xd2de2000  ! 2965: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r9
	.word 0xd29e2000  ! 2966: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r9
	.word 0x87802073  ! 2967: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f8, %r21
	.word 0xd2a56000  ! 2969: STWA_I	stwa	%r9, [%r21 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xdcaf0e80  ! 2971: STBA_R	stba	%r14, [%r28 + %r0] 0x74
	.word 0xd8f4c400  ! 2972: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xd8b5a000  ! 2973: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	.word 0xd89d6000  ! 2974: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r12
	mov	0x78, %r25
	.word 0xd8b5e000  ! 2976: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	mov	0x7e0, %r23
	mov	0x60, %r19
	.word 0x8780204f  ! 2979: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd89c2000  ! 2980: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	.word 0xd8ac6000  ! 2981: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xd8b46000  ! 2982: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 2983: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2984: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf44400  ! 2985: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	mov	0x3f8, %r23
	.word 0xd8c52000  ! 2987: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r12
	.word 0xd2cd44a0  ! 2988: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r9
	.word 0xd2f544a0  ! 2989: STXA_R	stxa	%r9, [%r21 + %r0] 0x25
	mov	0x3f0, %r21
	.word 0xdc8de000  ! 2991: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r14
	.word 0xdcbda000  ! 2992: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	.word 0xdcdf0e40  ! 2993: LDXA_R	ldxa	[%r28, %r0] 0x72, %r14
	mov	0x3c8, %r23
	.word 0xd2f78e40  ! 2995: STXA_R	stxa	%r9, [%r30 + %r0] 0x72
	.word 0x87802020  ! 2996: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab7a000  ! 2997: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdab7e000  ! 2998: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xdaa72000  ! 2999: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xdec74e80  ! 3000: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r15
	.word 0xd6dfa000  ! 3001: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0xd68fe000  ! 3002: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3003: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0dcc400  ! 3004: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0xdef72000  ! 3005: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xde8fe000  ! 3007: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	mov	0x7c0, %r21
	.word 0xdef76000  ! 3009: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdea7e000  ! 3010: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	mov	0x58, %r16
	.word 0x87802020  ! 3012: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb649e0  ! 3013: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	.word 0x87802073  ! 3014: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r25
	.word 0xdcbfa000  ! 3016: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 3017: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8f544a0  ! 3018: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	.word 0xdecf4e40  ! 3019: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r15
	mov	0x20, %r25
	.word 0xdaf7ce80  ! 3021: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	.word 0x87802020  ! 3022: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb7e000  ! 3023: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xdc976000  ! 3024: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	mov	0x70, %r27
	.word 0xd8dc4400  ! 3026: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0x87802020  ! 3027: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ac6000  ! 3028: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0xd09c8400  ! 3029: LDDA_R	ldda	[%r18, %r0] 0x20, %r8
	.word 0xd8f7ce40  ! 3030: STXA_R	stxa	%r12, [%r31 + %r0] 0x72
	mov	0x48, %r18
	.word 0xd2bcc400  ! 3032: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xd4846000  ! 3033: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r10
	mov	0x58, %r19
	.word 0xdcbc8400  ! 3035: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xd4870e40  ! 3036: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r10
	.word 0xd0946000  ! 3037: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0x87802020  ! 3038: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r24
	.word 0xd8b504a0  ! 3040: STHA_R	stha	%r12, [%r20 + %r0] 0x25
	mov	0x3f0, %r23
	.word 0xd28609e0  ! 3042: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r9
	.word 0x8780204f  ! 3043: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4d7a000  ! 3044: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	.word 0xd0c74e80  ! 3045: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r8
	mov	0x18, %r19
	mov	0x20, %r18
	mov	0x3f8, %r21
	.word 0x87802020  ! 3049: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bf6000  ! 3050: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd8bfe000  ! 3051: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd8b72000  ! 3052: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	mov	0x20, %r17
	.word 0xdc9d84a0  ! 3054: LDDA_R	ldda	[%r22, %r0] 0x25, %r14
	.word 0xd6bfa000  ! 3055: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 3056: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r16
	mov	0x58, %r24
	.word 0xd6ace000  ! 3059: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 3060: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3061: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r22
	.word 0xd4bcc400  ! 3063: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0xdcb44400  ! 3064: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0xd6b504a0  ! 3065: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	.word 0xd4bfce40  ! 3066: STDA_R	stda	%r10, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 3067: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 3068: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabc8400  ! 3069: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	.word 0xdebd04a0  ! 3070: STDA_R	stda	%r15, [%r20 + %r0] 0x25
	.word 0xdaf42000  ! 3071: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 3072: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeac8400  ! 3073: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xd2b48400  ! 3074: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd6dc8400  ! 3075: LDXA_R	ldxa	[%r18, %r0] 0x20, %r11
	.word 0xd6b649e0  ! 3076: STHA_R	stha	%r11, [%r25 + %r0] 0x4f
	.word 0xdef78e60  ! 3077: STXA_R	stxa	%r15, [%r30 + %r0] 0x73
	.word 0x87802074  ! 3078: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6c609e0  ! 3079: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r11
	.word 0xd2866000  ! 3080: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r9
	mov	0x3f0, %r21
	.word 0xd2a62000  ! 3082: STWA_I	stwa	%r9, [%r24 + 0x0000] %asi
	.word 0xd6d689e0  ! 3083: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r11
	.word 0xd0dea000  ! 3084: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r8
	.word 0x87802074  ! 3085: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c8, %r21
	.word 0xd495c4a0  ! 3087: LDUHA_R	lduha	[%r23, %r0] 0x25, %r10
	.word 0xdaf56000  ! 3088: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	mov	0x40, %r26
	.word 0xda8da000  ! 3090: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r13
	.word 0xdad6c9e0  ! 3091: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r13
	.word 0xdaa5c4a0  ! 3092: STWA_R	stwa	%r13, [%r23 + %r0] 0x25
	.word 0xd8b5a000  ! 3093: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	.word 0xd88d6000  ! 3094: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r12
	.word 0xd8df0e60  ! 3095: LDXA_R	ldxa	[%r28, %r0] 0x73, %r12
	.word 0xdca5c4a0  ! 3096: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	.word 0xd8de49e0  ! 3097: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r12
	.word 0xd2ac4400  ! 3098: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xd6f56000  ! 3099: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	.word 0xd68f4e80  ! 3100: LDUBA_R	lduba	[%r29, %r0] 0x74, %r11
	mov	0x7d0, %r21
	mov	0x18, %r25
	.word 0xd08cc400  ! 3103: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	.word 0xd6cfce80  ! 3104: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r11
	.word 0xd0a70e80  ! 3105: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	mov	0x20, %r17
	mov	0x7f8, %r23
	.word 0xdcb40400  ! 3108: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xd2a5e000  ! 3109: STWA_I	stwa	%r9, [%r23 + 0x0000] %asi
	.word 0x87802073  ! 3110: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r27
	.word 0xd8dcc400  ! 3112: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	mov	0x3c8, %r23
	.word 0xd2b7ce60  ! 3114: STHA_R	stha	%r9, [%r31 + %r0] 0x73
	.word 0xd08da000  ! 3115: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r8
	.word 0xd4dc4400  ! 3116: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	.word 0x87802020  ! 3117: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaac4400  ! 3118: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	.word 0xd6f4e000  ! 3119: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 3120: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6bf2000  ! 3121: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd6c7e000  ! 3122: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6b72000  ! 3123: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 3124: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdac74e80  ! 3125: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r13
	.word 0xd28ca000  ! 3126: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2cca000  ! 3127: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	.word 0xdcf649e0  ! 3128: STXA_R	stxa	%r14, [%r25 + %r0] 0x4f
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x60, %r26
	mov	0x38, %r26
	.word 0xde9ce000  ! 3132: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	mov	0x18, %r19
	.word 0xd89c8400  ! 3134: LDDA_R	ldda	[%r18, %r0] 0x20, %r12
	mov	0x8, %r17
	mov	0x3f0, %r22
	mov	0x3f0, %r21
	.word 0xd0f46000  ! 3138: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0bf4e60  ! 3139: STDA_R	stda	%r8, [%r29 + %r0] 0x73
	.word 0x87802020  ! 3140: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4df8e80  ! 3141: LDXA_R	ldxa	[%r30, %r0] 0x74, %r10
	.word 0xd8870e80  ! 3142: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r12
	.word 0xd8bc2000  ! 3143: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd8aca000  ! 3144: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	mov	0x7d0, %r20
	.word 0xd6ae09e0  ! 3146: STBA_R	stba	%r11, [%r24 + %r0] 0x4f
	mov	0x50, %r16
	.word 0xdecca000  ! 3148: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	.word 0xde8ca000  ! 3149: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 3150: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3151: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bf4e60  ! 3152: STDA_R	stda	%r10, [%r29 + %r0] 0x73
	.word 0xda8e09e0  ! 3153: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r13
	mov	0x3e0, %r22
	.word 0xd6dd84a0  ! 3155: LDXA_R	ldxa	[%r22, %r0] 0x25, %r11
	.word 0x8780204f  ! 3156: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e8, %r22
	.word 0xd4cea000  ! 3158: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r10
	.word 0xd4cc4400  ! 3159: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r10
	.word 0xdeae6000  ! 3160: STBA_I	stba	%r15, [%r25 + 0x0000] %asi
	.word 0xde9e6000  ! 3161: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r15
	.word 0xdec6a000  ! 3162: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r15
	.word 0xdeae6000  ! 3163: STBA_I	stba	%r15, [%r25 + 0x0000] %asi
	.word 0xdcdf8e80  ! 3164: LDXA_R	ldxa	[%r30, %r0] 0x74, %r14
	mov	0x38, %r18
	.word 0xd49e6000  ! 3166: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r10
	mov	0x3d8, %r22
	mov	0x3f0, %r21
	.word 0xd48e6000  ! 3169: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r10
	.word 0xd4ae2000  ! 3170: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	mov	0x18, %r25
	.word 0x87802025  ! 3172: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 3173: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r18
	.word 0xd4cc2000  ! 3175: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	.word 0xd49c8400  ! 3176: LDDA_R	ldda	[%r18, %r0] 0x20, %r10
	.word 0xd4cce000  ! 3177: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	mov	0x7e0, %r21
	.word 0x8780204f  ! 3179: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 3180: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcd74e60  ! 3181: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r14
	mov	0x0, %r17
	.word 0xdadf6000  ! 3183: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xd88f4e40  ! 3184: LDUBA_R	lduba	[%r29, %r0] 0x72, %r12
	.word 0xdeb74e40  ! 3185: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	.word 0x87802020  ! 3186: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf74e80  ! 3187: STXA_R	stxa	%r14, [%r29 + %r0] 0x74
	mov	0x7f0, %r21
	.word 0xd8bfa000  ! 3189: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 3190: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2cd44a0  ! 3192: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r9
	mov	0x60, %r25
	.word 0xd295c4a0  ! 3194: LDUHA_R	lduha	[%r23, %r0] 0x25, %r9
	.word 0xd0af0e60  ! 3195: STBA_R	stba	%r8, [%r28 + %r0] 0x73
	.word 0xdc8ea000  ! 3196: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r14
	.word 0xd6c544a0  ! 3197: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r11
	.word 0x8780204f  ! 3198: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d0, %r22
	mov	0x58, %r27
	.word 0xd2b72000  ! 3201: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd4bcc400  ! 3202: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0x87802073  ! 3203: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b52000  ! 3204: STHA_I	stha	%r9, [%r20 + 0x0000] %asi
	mov	0x70, %r16
	.word 0xded78e80  ! 3206: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r15
	mov	0x0, %r26
	.word 0x87802020  ! 3208: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebfa000  ! 3209: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xde9f2000  ! 3211: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xd69c0400  ! 3212: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	.word 0xd49cc400  ! 3213: LDDA_R	ldda	[%r19, %r0] 0x20, %r10
	mov	0x7d8, %r20
	.word 0xd08f4e60  ! 3215: LDUBA_R	lduba	[%r29, %r0] 0x73, %r8
	.word 0xdea74e80  ! 3216: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	.word 0xd0c5c4a0  ! 3217: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r8
	.word 0x87802025  ! 3218: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f8, %r20
	mov	0x3d8, %r23
	.word 0xd4d584a0  ! 3221: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r10
	.word 0xd2bce000  ! 3222: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xd2a46000  ! 3223: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	mov	0x3f0, %r20
	.word 0xd2f4a000  ! 3225: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0xdeac0400  ! 3226: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xdedec9e0  ! 3227: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r15
	.word 0xd2a4a000  ! 3228: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	mov	0x78, %r19
	.word 0xd8a70e40  ! 3230: STWA_R	stwa	%r12, [%r28 + %r0] 0x72
	mov	0x18, %r25
	.word 0xdccca000  ! 3232: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	.word 0xd4978e80  ! 3233: LDUHA_R	lduha	[%r30, %r0] 0x74, %r10
	.word 0xd48ca000  ! 3234: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r10
	.word 0xd4d4e000  ! 3235: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0xd89fce60  ! 3236: LDDA_R	ldda	[%r31, %r0] 0x73, %r12
	.word 0x87802020  ! 3237: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r16
	mov	0x8, %r25
	.word 0xd2b504a0  ! 3240: STHA_R	stha	%r9, [%r20 + %r0] 0x25
	.word 0xd29d2000  ! 3241: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r9
	.word 0xd2b5e000  ! 3242: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 3243: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3244: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c544a0  ! 3245: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r12
	.word 0xd6b4c400  ! 3246: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0x87802072  ! 3247: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb689e0  ! 3248: STHA_R	stha	%r14, [%r26 + %r0] 0x4f
	.word 0xdcdd04a0  ! 3249: LDXA_R	ldxa	[%r20, %r0] 0x25, %r14
	mov	0x7f8, %r20
	mov	0x3f0, %r21
	.word 0xdcd584a0  ! 3252: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r14
	.word 0xdcc4c400  ! 3253: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	.word 0xd6d689e0  ! 3254: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r11
	mov	0x3e8, %r22
	.word 0xd28da000  ! 3256: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r9
	.word 0x87802073  ! 3257: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 3258: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3259: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r17
	.word 0xd0dd04a0  ! 3261: LDXA_R	ldxa	[%r20, %r0] 0x25, %r8
	.word 0xd09dc4a0  ! 3262: LDDA_R	ldda	[%r23, %r0] 0x25, %r8
	.word 0xdc9ca000  ! 3263: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r14
	.word 0xdca4e000  ! 3264: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 3265: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r16
	.word 0xdcb4a000  ! 3267: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 3268: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 3269: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca4a000  ! 3270: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	mov	0x3f0, %r23
	.word 0xd4af8e40  ! 3272: STBA_R	stba	%r10, [%r30 + %r0] 0x72
	mov	0x18, %r18
	.word 0xd0ac6000  ! 3274: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0xd0a42000  ! 3275: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xdede89e0  ! 3276: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r15
	.word 0xd4b48400  ! 3277: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xdeacc400  ! 3278: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xd6dc2000  ! 3279: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r11
	mov	0x7d0, %r22
	.word 0xd6c4e000  ! 3281: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r11
	.word 0xdede09e0  ! 3282: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r15
	.word 0xdaf7ce40  ! 3283: STXA_R	stxa	%r13, [%r31 + %r0] 0x72
	.word 0x87802025  ! 3284: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 3285: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r18
	.word 0x87802020  ! 3287: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b72000  ! 3288: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xda8f8e60  ! 3289: LDUBA_R	lduba	[%r30, %r0] 0x73, %r13
	.word 0xd097e000  ! 3290: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xd6d689e0  ! 3291: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r11
	.word 0xdc9f0e80  ! 3292: LDDA_R	ldda	[%r28, %r0] 0x74, %r14
	.word 0xdef7a000  ! 3293: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 3294: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4ac0400  ! 3295: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xd0b504a0  ! 3296: STHA_R	stha	%r8, [%r20 + %r0] 0x25
	.word 0x87802073  ! 3297: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd49c0400  ! 3298: LDDA_R	ldda	[%r16, %r0] 0x20, %r10
	mov	0x7c8, %r23
	.word 0xdaae89e0  ! 3300: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	mov	0x7f0, %r21
	.word 0x87802020  ! 3302: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f4c400  ! 3303: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0x87802020  ! 3304: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdecf2000  ! 3305: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xdebfe000  ! 3306: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xded72000  ! 3307: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	mov	0x18, %r24
	.word 0xde8fa000  ! 3309: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3310: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r25
	.word 0xd8f584a0  ! 3312: STXA_R	stxa	%r12, [%r22 + %r0] 0x25
	.word 0xd8ac0400  ! 3313: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xdaafce40  ! 3314: STBA_R	stba	%r13, [%r31 + %r0] 0x72
	mov	0x3f0, %r21
	.word 0xd4b70e80  ! 3316: STHA_R	stha	%r10, [%r28 + %r0] 0x74
	mov	0x28, %r17
	.word 0x8780204f  ! 3318: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 3319: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f8, %r23
	.word 0xd6a74e40  ! 3321: STWA_R	stwa	%r11, [%r29 + %r0] 0x72
	.word 0xd0f74e40  ! 3322: STXA_R	stxa	%r8, [%r29 + %r0] 0x72
	mov	0x3f0, %r20
	mov	0x18, %r26
	.word 0xdecc6000  ! 3325: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r15
	.word 0xde9c2000  ! 3326: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xd28f4e60  ! 3327: LDUBA_R	lduba	[%r29, %r0] 0x73, %r9
	.word 0x87802073  ! 3328: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa76000  ! 3329: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xda8fe000  ! 3330: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3331: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3332: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadd2000  ! 3333: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r13
	.word 0xd2944400  ! 3334: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	mov	0x70, %r19
	mov	0x0, %r27
	.word 0x87802020  ! 3337: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb7a000  ! 3338: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xdea72000  ! 3339: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xdec72000  ! 3340: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	mov	0x0, %r18
	.word 0xdeb7e000  ! 3342: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0xdebdc4a0  ! 3344: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	mov	0x60, %r26
	.word 0xd2976000  ! 3346: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0xd0f609e0  ! 3347: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	.word 0xd0b7a000  ! 3348: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	mov	0x10, %r26
	.word 0xda9ec9e0  ! 3350: LDDA_R	ldda	[%r27, %r0] 0x4f, %r13
	.word 0xdccf2000  ! 3351: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xd0b40400  ! 3352: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	mov	0x7d8, %r22
	.word 0x87802072  ! 3354: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8d46000  ! 3355: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	.word 0xd8c4a000  ! 3356: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r12
	mov	0x7e8, %r21
	mov	0x3d8, %r20
	mov	0x28, %r19
	mov	0x0, %r27
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd8c46000  ! 3362: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r12
	.word 0xd89ca000  ! 3363: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r12
	.word 0x87802074  ! 3364: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8a7e000  ! 3365: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd4c74e80  ! 3366: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r10
	.word 0x87802025  ! 3367: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc9dc4a0  ! 3368: LDDA_R	ldda	[%r23, %r0] 0x25, %r14
	.word 0xdec48400  ! 3369: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	mov	0x58, %r18
	mov	0x50, %r24
	mov	0x7d8, %r22
	mov	0x38, %r24
	.word 0xd29fa000  ! 3374: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd2a72000  ! 3375: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0xdcb78e40  ! 3376: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xdc848400  ! 3377: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	.word 0xd6b44400  ! 3378: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xd0a72000  ! 3379: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x48, %r27
	.word 0xd285c4a0  ! 3381: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r9
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdac48400  ! 3383: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd8b7a000  ! 3385: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xd4a584a0  ! 3386: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	mov	0x50, %r25
	mov	0x78, %r27
	.word 0x87802073  ! 3389: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf5a000  ! 3390: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xdaada000  ! 3391: STBA_I	stba	%r13, [%r22 + 0x0000] %asi
	mov	0x60, %r24
	.word 0x87802073  ! 3393: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r18
	.word 0xda8da000  ! 3395: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r13
	.word 0xd8a48400  ! 3396: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	mov	0x7e8, %r20
	.word 0x87802072  ! 3398: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd89e6000  ! 3399: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 3400: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2870e80  ! 3401: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r9
	.word 0xd2bd6000  ! 3402: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	.word 0xdca609e0  ! 3403: STWA_R	stwa	%r14, [%r24 + %r0] 0x4f
	.word 0xda95c4a0  ! 3404: LDUHA_R	lduha	[%r23, %r0] 0x25, %r13
	.word 0xd6b56000  ! 3405: STHA_I	stha	%r11, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 3406: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf4c400  ! 3407: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xd6f5e000  ! 3408: STXA_I	stxa	%r11, [%r23 + 0x0000] %asi
	.word 0xd2a649e0  ! 3409: STWA_R	stwa	%r9, [%r25 + %r0] 0x4f
	mov	0x3f0, %r20
	.word 0xdca544a0  ! 3411: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0xdcbd44a0  ! 3412: STDA_R	stda	%r14, [%r21 + %r0] 0x25
	mov	0x30, %r17
	.word 0xd2ad6000  ! 3414: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0xda9d44a0  ! 3415: LDDA_R	ldda	[%r21, %r0] 0x25, %r13
	.word 0xdc852000  ! 3416: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r14
	mov	0x40, %r16
	.word 0xdcf56000  ! 3418: STXA_I	stxa	%r14, [%r21 + 0x0000] %asi
	.word 0xdcdd2000  ! 3419: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r14
	mov	0x10, %r19
	.word 0xdcb5a000  ! 3421: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0xdabfce40  ! 3422: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	mov	0x58, %r25
	.word 0xd6d4c400  ! 3424: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	.word 0xd887ce60  ! 3425: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r12
	.word 0xdc878e80  ! 3426: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r14
	.word 0xd8b5a000  ! 3427: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	.word 0xd8f5a000  ! 3428: STXA_I	stxa	%r12, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 3429: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcc40400  ! 3430: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	.word 0xd2b7a000  ! 3431: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd2f7a000  ! 3432: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xd28fe000  ! 3434: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	mov	0x50, %r17
	.word 0xd6a5c4a0  ! 3436: STWA_R	stwa	%r11, [%r23 + %r0] 0x25
	.word 0xdc978e60  ! 3437: LDUHA_R	lduha	[%r30, %r0] 0x73, %r14
	.word 0xdcbfa000  ! 3438: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdcd76000  ! 3439: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	.word 0xdca7e000  ! 3440: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcbfe000  ! 3441: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	mov	0x7d0, %r21
	mov	0x50, %r17
	.word 0xdcc72000  ! 3444: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	mov	0x28, %r25
	.word 0xdcbf2000  ! 3446: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 3447: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa6c9e0  ! 3448: STWA_R	stwa	%r13, [%r27 + %r0] 0x4f
	mov	0x8, %r16
	.word 0xd2c584a0  ! 3450: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r9
	.word 0xd0944400  ! 3451: LDUHA_R	lduha	[%r17, %r0] 0x20, %r8
	.word 0xda9fa000  ! 3452: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xdacfe000  ! 3453: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0xdab7e000  ! 3454: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xde8e49e0  ! 3456: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r15
	.word 0xd0f70e40  ! 3457: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	mov	0x10, %r26
	.word 0xdcf72000  ! 3459: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	mov	0x3c0, %r20
	.word 0x87802020  ! 3461: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r27
	mov	0x7e8, %r20
	.word 0x87802020  ! 3464: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r19
	.word 0x87802074  ! 3466: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r19
	.word 0xd89689e0  ! 3468: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r12
	.word 0x87802025  ! 3469: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2af2000  ! 3470: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	mov	0x40, %r25
	.word 0xd2ce09e0  ! 3472: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r9
	.word 0x87802072  ! 3473: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2c4a000  ! 3474: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	mov	0x68, %r16
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2c46000  ! 3477: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0xd2f4e000  ! 3478: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0xd2d46000  ! 3480: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	.word 0xd29ce000  ! 3481: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xdcaf0e80  ! 3482: STBA_R	stba	%r14, [%r28 + %r0] 0x74
	mov	0x60, %r16
	.word 0xda8c6000  ! 3484: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r13
	.word 0x87802073  ! 3485: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdedc8400  ! 3486: LDXA_R	ldxa	[%r18, %r0] 0x20, %r15
	.word 0xdea78e60  ! 3487: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	.word 0xdcd70e80  ! 3488: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r14
	.word 0xde8d04a0  ! 3489: LDUBA_R	lduba	[%r20, %r0] 0x25, %r15
	mov	0x10, %r16
	.word 0xd2c70e80  ! 3491: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r9
	.word 0xd2a7ce60  ! 3492: STWA_R	stwa	%r9, [%r31 + %r0] 0x73
	mov	0x7c0, %r20
	mov	0x78, %r25
	.word 0xdab649e0  ! 3495: STHA_R	stha	%r13, [%r25 + %r0] 0x4f
	mov	0x60, %r24
	.word 0xd4c4a000  ! 3497: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	.word 0xd4ac6000  ! 3498: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	.word 0xd4ac2000  ! 3499: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0xd4dc2000  ! 3500: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	.word 0xd49649e0  ! 3501: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r10
	.word 0xd2a78e40  ! 3502: STWA_R	stwa	%r9, [%r30 + %r0] 0x72
	.word 0x87802072  ! 3503: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2c44400  ! 3504: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	mov	0x60, %r26
	.word 0xdadd6000  ! 3506: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r13
	mov	0x40, %r16
	.word 0xd8f44400  ! 3508: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xdca5c4a0  ! 3509: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	ta	T_CHANGE_PRIV	! macro
	.word 0xd6a5e000  ! 3511: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	mov	0x20, %r26
	mov	0x0, %r17
	.word 0xdad70e80  ! 3514: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r13
	mov	0x30, %r16
	mov	0x30, %r18
	mov	0x10, %r18
	mov	0x7f0, %r20
	.word 0xd4d44400  ! 3519: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0xd4adc4a0  ! 3520: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0x87802020  ! 3521: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf7a000  ! 3522: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x7f8, %r20
	mov	0x0, %r16
	.word 0xdc9f6000  ! 3525: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	mov	0x50, %r27
	.word 0xd2f7ce40  ! 3527: STXA_R	stxa	%r9, [%r31 + %r0] 0x72
	.word 0xdedfe000  ! 3528: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xdea72000  ! 3529: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xd6f6c9e0  ! 3530: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	.word 0xd0d72000  ! 3531: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0a649e0  ! 3532: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	mov	0x60, %r19
	.word 0x87802025  ! 3534: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b7a000  ! 3535: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd2c7e000  ! 3536: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0xd28f6000  ! 3537: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd8be49e0  ! 3538: STDA_R	stda	%r12, [%r25 + %r0] 0x4f
	.word 0xdcc74e40  ! 3539: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r14
	.word 0x8780204f  ! 3540: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d8, %r22
	.word 0xd0c48400  ! 3542: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r8
	mov	0x8, %r25
	.word 0xd29de000  ! 3544: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r9
	mov	0x7c0, %r23
	mov	0x18, %r24
	.word 0xd2bd6000  ! 3547: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	mov	0x30, %r19
	mov	0x3e8, %r21
	.word 0x87802073  ! 3550: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2866000  ! 3551: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r9
	mov	0x48, %r19
	.word 0xd2cee000  ! 3553: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	.word 0xd2cc8400  ! 3554: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0xded44400  ! 3555: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	.word 0xd0f44400  ! 3556: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd2966000  ! 3557: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r9
	.word 0xd2f66000  ! 3558: STXA_I	stxa	%r9, [%r25 + 0x0000] %asi
	.word 0xd2962000  ! 3559: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r9
	.word 0xd6dec9e0  ! 3560: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r11
	.word 0x87802074  ! 3561: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3f0, %r20
	.word 0x87802020  ! 3563: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ce89e0  ! 3564: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r12
	.word 0xd6cf8e40  ! 3565: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r11
	.word 0xdacc2000  ! 3566: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xdaace000  ! 3567: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0xdaa78e60  ! 3568: STWA_R	stwa	%r13, [%r30 + %r0] 0x73
	.word 0xd2d544a0  ! 3569: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r9
	.word 0xd4cc8400  ! 3570: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	mov	0x50, %r26
	.word 0xdeac2000  ! 3572: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	mov	0x78, %r25
	.word 0x8780204f  ! 3574: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdef72000  ! 3575: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xde87a000  ! 3576: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xde8f8e80  ! 3577: LDUBA_R	lduba	[%r30, %r0] 0x74, %r15
	mov	0x10, %r26
	.word 0xd2b74e60  ! 3579: STHA_R	stha	%r9, [%r29 + %r0] 0x73
	.word 0x87802020  ! 3580: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r18
	.word 0xd8b70e60  ! 3582: STHA_R	stha	%r12, [%r28 + %r0] 0x73
	mov	0x7c0, %r22
	.word 0xd48649e0  ! 3584: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r10
	.word 0xd6876000  ! 3585: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	.word 0xd68fa000  ! 3586: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0xd6af6000  ! 3587: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x48, %r19
	.word 0x8780204f  ! 3589: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 3590: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r25
	.word 0x87802073  ! 3592: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf78e80  ! 3593: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	.word 0xd6c66000  ! 3594: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r11
	.word 0xd6962000  ! 3595: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r11
	.word 0xdaa44400  ! 3596: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0xd0a6a000  ! 3597: STWA_I	stwa	%r8, [%r26 + 0x0000] %asi
	.word 0x8780204f  ! 3598: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0cca000  ! 3599: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	.word 0xd0f4a000  ! 3600: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xd0ace000  ! 3601: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	mov	0x3e8, %r23
	mov	0x78, %r16
	.word 0xdaad04a0  ! 3604: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	mov	0x20, %r27
	mov	0x18, %r18
	.word 0xdeb42000  ! 3607: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0xdedca000  ! 3608: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0x87802074  ! 3609: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r19
	.word 0x87802073  ! 3611: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde846000  ! 3612: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3613: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeaf6000  ! 3614: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xde8f6000  ! 3615: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	.word 0xdedf6000  ! 3616: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xde8f2000  ! 3617: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	mov	0x3d0, %r21
	.word 0xde9fa000  ! 3619: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3620: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcae89e0  ! 3621: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	mov	0x3d8, %r22
	.word 0xd4bfa000  ! 3623: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	mov	0x38, %r24
	.word 0xd487e000  ! 3625: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	mov	0x40, %r26
	.word 0xdcae89e0  ! 3627: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	.word 0xd2a7e000  ! 3628: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xdac48400  ! 3629: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	.word 0x87802025  ! 3630: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde94c400  ! 3631: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	.word 0xdedc2000  ! 3632: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r15
	.word 0xd6b70e80  ! 3633: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	.word 0xdea42000  ! 3634: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xd6f7ce80  ! 3635: STXA_R	stxa	%r11, [%r31 + %r0] 0x74
	.word 0xd6946000  ! 3636: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r11
	.word 0xd89f0e60  ! 3637: LDDA_R	ldda	[%r28, %r0] 0x73, %r12
	.word 0xd2844400  ! 3638: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	mov	0x10, %r27
	mov	0x7e8, %r20
	.word 0xdcd4a000  ! 3641: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	.word 0xdcc4a000  ! 3642: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r14
	.word 0xdc846000  ! 3643: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802020  ! 3645: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r24
	.word 0x87802020  ! 3647: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3648: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd29f8e40  ! 3649: LDDA_R	ldda	[%r30, %r0] 0x72, %r9
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0a78e60  ! 3651: STWA_R	stwa	%r8, [%r30 + %r0] 0x73
	.word 0xd4de2000  ! 3652: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r10
	.word 0xd4be6000  ! 3653: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0xd4a78e60  ! 3654: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	.word 0xd0978e80  ! 3655: LDUHA_R	lduha	[%r30, %r0] 0x74, %r8
	.word 0x87802020  ! 3656: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac42000  ! 3657: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 3658: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdab4a000  ! 3659: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0x87802025  ! 3661: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 3662: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda97e000  ! 3663: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	.word 0xd0ac0400  ! 3664: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	mov	0x30, %r17
	.word 0xd2ce49e0  ! 3666: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r9
	.word 0xdebf2000  ! 3667: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xded70e40  ! 3668: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r15
	.word 0xd0bf2000  ! 3669: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xda9f4e40  ! 3670: LDDA_R	ldda	[%r29, %r0] 0x72, %r13
	mov	0x10, %r27
	mov	0x30, %r16
	.word 0xd2d6c9e0  ! 3673: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r9
	.word 0xd6b72000  ! 3674: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd6bfa000  ! 3675: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd6bf2000  ! 3676: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 3677: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r16
	mov	0x3d0, %r21
	mov	0x3d0, %r23
	.word 0xd68f2000  ! 3681: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xd0bf0e40  ! 3682: STDA_R	stda	%r8, [%r28 + %r0] 0x72
	.word 0xda9fe000  ! 3683: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	mov	0x68, %r18
	.word 0xdcf6c9e0  ! 3685: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	.word 0xd6bfce80  ! 3686: STDA_R	stda	%r11, [%r31 + %r0] 0x74
	.word 0xd8872000  ! 3687: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	.word 0xd4b689e0  ! 3688: STHA_R	stha	%r10, [%r26 + %r0] 0x4f
	.word 0xd4b40400  ! 3689: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	mov	0x3c8, %r21
	.word 0xd8a7a000  ! 3691: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0x87802073  ! 3693: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8a7e000  ! 3694: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xdc9c8400  ! 3695: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0x87802025  ! 3696: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad4e000  ! 3697: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r13
	.word 0xdc8c8400  ! 3698: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	mov	0x68, %r25
	.word 0x87802020  ! 3700: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca56000  ! 3701: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	.word 0x87802025  ! 3702: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcaf6000  ! 3703: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdcbfa000  ! 3704: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdeb48400  ! 3705: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	mov	0x0, %r19
	.word 0x87802020  ! 3707: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a70e80  ! 3708: STWA_R	stwa	%r11, [%r28 + %r0] 0x74
	.word 0xdcdcc400  ! 3709: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	mov	0x0, %r25
	.word 0xd8bd44a0  ! 3711: STDA_R	stda	%r12, [%r21 + %r0] 0x25
	.word 0x87802074  ! 3712: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28689e0  ! 3713: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r9
	.word 0xde8ca000  ! 3714: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	mov	0x38, %r19
	.word 0xdaaf4e60  ! 3716: STBA_R	stba	%r13, [%r29 + %r0] 0x73
	.word 0x87802072  ! 3717: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 3718: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebd44a0  ! 3719: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	.word 0xdaa4a000  ! 3720: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xd2d40400  ! 3721: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	.word 0xd2ae49e0  ! 3722: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	.word 0x87802025  ! 3723: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 3724: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda9c4400  ! 3725: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	.word 0xd0c72000  ! 3726: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0cc8400  ! 3727: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0xd8bc4400  ! 3728: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xd0df2000  ! 3729: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0c72000  ! 3730: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xd08fa000  ! 3731: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0xd0df6000  ! 3732: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0xde9c8400  ! 3733: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	.word 0xd0afe000  ! 3734: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd0df2000  ! 3736: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	mov	0x3c8, %r21
	mov	0x7c8, %r23
	mov	0x7f0, %r22
	.word 0xd8d649e0  ! 3740: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r12
	.word 0xdcf44400  ! 3741: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xd2cf4e60  ! 3742: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r9
	.word 0xdacf6000  ! 3743: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	mov	0x30, %r19
	.word 0x87802074  ! 3745: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf72000  ! 3746: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xd2a5c4a0  ! 3747: STWA_R	stwa	%r9, [%r23 + %r0] 0x25
	.word 0xd0c7e000  ! 3748: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	mov	0x3d0, %r21
	.word 0xdeb4c400  ! 3750: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xd6c76000  ! 3751: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0x87802073  ! 3752: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r24
	mov	0x20, %r26
	.word 0xd8b78e80  ! 3755: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	mov	0x3d0, %r20
	.word 0xd0f7ce60  ! 3757: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	.word 0xdabc2000  ! 3758: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xd88504a0  ! 3759: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r12
	.word 0x8780204f  ! 3760: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2c7ce80  ! 3761: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r9
	.word 0xd0870e60  ! 3762: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r8
	.word 0xd0af0e60  ! 3763: STBA_R	stba	%r8, [%r28 + %r0] 0x73
	mov	0x38, %r26
	.word 0xd2bf2000  ! 3765: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	mov	0x58, %r19
	.word 0xd287e000  ! 3767: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802074  ! 3769: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6cec9e0  ! 3770: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r11
	.word 0xd4a44400  ! 3771: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xdebf6000  ! 3772: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 3773: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdedd04a0  ! 3774: LDXA_R	ldxa	[%r20, %r0] 0x25, %r15
	.word 0xd2846000  ! 3775: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r9
	.word 0xd6af4e40  ! 3776: STBA_R	stba	%r11, [%r29 + %r0] 0x72
	.word 0xdea74e80  ! 3777: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	mov	0x7c8, %r20
	mov	0x70, %r16
	mov	0x78, %r16
	mov	0x20, %r16
	.word 0xde9c2000  ! 3782: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	mov	0x50, %r24
	.word 0xdcbf0e60  ! 3784: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	.word 0xdacf8e60  ! 3785: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r13
	.word 0x87802072  ! 3786: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3787: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa72000  ! 3788: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	mov	0x40, %r18
	mov	0x3f0, %r23
	.word 0x87802074  ! 3791: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda9f2000  ! 3792: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xd096c9e0  ! 3793: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r8
	.word 0xdab70e40  ! 3794: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	.word 0xd2f7e000  ! 3795: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd8ac4400  ! 3796: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xdecfa000  ! 3797: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xd494c400  ! 3798: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	.word 0xd0c72000  ! 3799: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0976000  ! 3800: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	mov	0x30, %r27
	.word 0xdc8dc4a0  ! 3802: LDUBA_R	lduba	[%r23, %r0] 0x25, %r14
	.word 0xd2b584a0  ! 3803: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0xd6c7e000  ! 3804: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xd4bd84a0  ! 3805: STDA_R	stda	%r10, [%r22 + %r0] 0x25
	mov	0x50, %r19
	.word 0x87802020  ! 3807: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcaf6000  ! 3808: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xd89fce40  ! 3809: LDDA_R	ldda	[%r31, %r0] 0x72, %r12
	mov	0x3c8, %r22
	.word 0xd89fa000  ! 3811: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	.word 0xd28d44a0  ! 3812: LDUBA_R	lduba	[%r21, %r0] 0x25, %r9
	.word 0xd4b7e000  ! 3813: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd0f44400  ! 3814: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd6ae89e0  ! 3815: STBA_R	stba	%r11, [%r26 + %r0] 0x4f
	.word 0xd2b7ce60  ! 3816: STHA_R	stha	%r9, [%r31 + %r0] 0x73
	.word 0x87802074  ! 3817: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2a70e60  ! 3818: STWA_R	stwa	%r9, [%r28 + %r0] 0x73
	.word 0x87802073  ! 3819: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a78e40  ! 3820: STWA_R	stwa	%r8, [%r30 + %r0] 0x72
	mov	0x28, %r25
	.word 0xd0bf8e60  ! 3822: STDA_R	stda	%r8, [%r30 + %r0] 0x73
	mov	0x3d8, %r22
	mov	0x8, %r16
	.word 0xd8970e40  ! 3825: LDUHA_R	lduha	[%r28, %r0] 0x72, %r12
	.word 0xd2b7ce60  ! 3826: STHA_R	stha	%r9, [%r31 + %r0] 0x73
	.word 0xde94c400  ! 3827: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	.word 0xd0cc0400  ! 3828: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xdc9689e0  ! 3829: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r14
	.word 0xdea66000  ! 3830: STWA_I	stwa	%r15, [%r25 + 0x0000] %asi
	.word 0xd49dc4a0  ! 3831: LDDA_R	ldda	[%r23, %r0] 0x25, %r10
	.word 0xd28ee000  ! 3832: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r9
	mov	0x8, %r27
	.word 0x8780204f  ! 3834: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f8, %r21
	mov	0x20, %r18
	.word 0x87802020  ! 3837: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cc6000  ! 3838: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	.word 0xd2a42000  ! 3839: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	.word 0xd2b42000  ! 3840: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	mov	0x78, %r27
	.word 0xd2b42000  ! 3842: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xd2c46000  ! 3844: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0x87802072  ! 3845: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcae49e0  ! 3846: STBA_R	stba	%r14, [%r25 + %r0] 0x4f
	.word 0xd8f44400  ! 3847: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xdcaca000  ! 3848: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xd48609e0  ! 3849: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r10
	.word 0xd48e89e0  ! 3850: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r10
	.word 0xd8de89e0  ! 3851: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r12
	mov	0x40, %r18
	mov	0x18, %r19
	.word 0xd2bce000  ! 3854: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xd2ac2000  ! 3855: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xdc978e60  ! 3856: LDUHA_R	lduha	[%r30, %r0] 0x73, %r14
	.word 0xd6af4e80  ! 3857: STBA_R	stba	%r11, [%r29 + %r0] 0x74
	.word 0xd4bc6000  ! 3858: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3859: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c5c4a0  ! 3860: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r10
	.word 0xdeb48400  ! 3861: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0x87802073  ! 3862: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4be49e0  ! 3863: STDA_R	stda	%r10, [%r25 + %r0] 0x4f
	mov	0x0, %r27
	.word 0xd0df6000  ! 3865: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0a72000  ! 3866: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 3867: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b76000  ! 3868: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd0a76000  ! 3869: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 3870: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd48609e0  ! 3871: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r10
	mov	0x60, %r24
	.word 0xd4b40400  ! 3873: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0x87802020  ! 3874: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r22
	.word 0xd0ace000  ! 3876: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	mov	0x7f8, %r21
	mov	0x7d0, %r20
	.word 0xd08ce000  ! 3879: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0x87802025  ! 3880: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4c609e0  ! 3881: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r10
	.word 0xdcb52000  ! 3882: STHA_I	stha	%r14, [%r20 + 0x0000] %asi
	.word 0xdcf56000  ! 3883: STXA_I	stxa	%r14, [%r21 + 0x0000] %asi
	.word 0xda840400  ! 3884: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	.word 0xdaad84a0  ! 3885: STBA_R	stba	%r13, [%r22 + %r0] 0x25
	.word 0xd6944400  ! 3886: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	.word 0xdcdfce80  ! 3887: LDXA_R	ldxa	[%r31, %r0] 0x74, %r14
	.word 0xd6cd2000  ! 3888: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r11
	.word 0xd8d544a0  ! 3889: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r12
	.word 0x87802020  ! 3890: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3891: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 3892: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r26
	mov	0x58, %r17
	.word 0xdca5e000  ! 3895: STWA_I	stwa	%r14, [%r23 + 0x0000] %asi
	mov	0x3e8, %r21
	mov	0x68, %r19
	.word 0xdca5a000  ! 3898: STWA_I	stwa	%r14, [%r22 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0xdcbec9e0  ! 3900: STDA_R	stda	%r14, [%r27 + %r0] 0x4f
	.word 0xda9d2000  ! 3901: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r13
	.word 0xdcccc400  ! 3902: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	.word 0xd89dc4a0  ! 3903: LDDA_R	ldda	[%r23, %r0] 0x25, %r12
	.word 0xd6bde000  ! 3904: STDA_I	stda	%r11, [%r23 + 0x0000] %asi
	.word 0xdaf544a0  ! 3905: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	mov	0x7f8, %r23
	.word 0xdc85e000  ! 3907: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r14
	.word 0xd0cc0400  ! 3908: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xd4bfce80  ! 3909: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	mov	0x70, %r18
	.word 0xd4c56000  ! 3911: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r10
	.word 0xd2d48400  ! 3912: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	.word 0xd4bd6000  ! 3913: STDA_I	stda	%r10, [%r21 + 0x0000] %asi
	.word 0x87802074  ! 3914: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf584a0  ! 3915: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	.word 0xd4af6000  ! 3916: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xdcbf4e80  ! 3917: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	.word 0xdc86c9e0  ! 3918: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r14
	mov	0x3e8, %r23
	mov	0x70, %r25
	mov	0x8, %r27
	.word 0xd6b74e60  ! 3922: STHA_R	stha	%r11, [%r29 + %r0] 0x73
	.word 0xd88fce80  ! 3923: LDUBA_R	lduba	[%r31, %r0] 0x74, %r12
	mov	0x7f8, %r21
	.word 0x87802072  ! 3925: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdad5a000  ! 3926: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r13
	mov	0x20, %r24
	mov	0x7e0, %r23
	.word 0xdec48400  ! 3929: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	mov	0x3e8, %r21
	.word 0xd2be09e0  ! 3931: STDA_R	stda	%r9, [%r24 + %r0] 0x4f
	.word 0xda9d84a0  ! 3932: LDDA_R	ldda	[%r22, %r0] 0x25, %r13
	mov	0x7f0, %r21
	.word 0xdedd2000  ! 3934: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r15
	mov	0x7f0, %r23
	.word 0x87802020  ! 3936: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde87ce80  ! 3937: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r15
	.word 0xd0c78e40  ! 3938: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r8
	.word 0x87802025  ! 3939: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 3940: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6a4c400  ! 3941: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0xd2dfa000  ! 3942: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2c72000  ! 3943: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xdea40400  ! 3944: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xd4cfa000  ! 3945: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0x87802025  ! 3946: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd09c4400  ! 3947: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	.word 0xdaa78e60  ! 3948: STWA_R	stwa	%r13, [%r30 + %r0] 0x73
	.word 0xd8d4c400  ! 3949: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0xdaae2000  ! 3950: STBA_I	stba	%r13, [%r24 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xda8e2000  ! 3952: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r13
	.word 0xda9e2000  ! 3953: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r13
	.word 0xd0a584a0  ! 3954: STWA_R	stwa	%r8, [%r22 + %r0] 0x25
	.word 0xd4a6a000  ! 3955: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	mov	0x60, %r25
	.word 0xdef78e60  ! 3957: STXA_R	stxa	%r15, [%r30 + %r0] 0x73
	mov	0x10, %r27
	mov	0x40, %r16
	.word 0xd4f40400  ! 3960: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xd28d44a0  ! 3961: LDUBA_R	lduba	[%r21, %r0] 0x25, %r9
	.word 0xd4dee000  ! 3962: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r10
	.word 0xd4ae6000  ! 3963: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xda8f8e60  ! 3965: LDUBA_R	lduba	[%r30, %r0] 0x73, %r13
	.word 0xd8f6a000  ! 3966: STXA_I	stxa	%r12, [%r26 + 0x0000] %asi
	.word 0xd8bee000  ! 3967: STDA_I	stda	%r12, [%r27 + 0x0000] %asi
	.word 0xd8f48400  ! 3968: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0x87802073  ! 3969: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdccf8e80  ! 3970: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r14
	mov	0x18, %r18
	mov	0x50, %r27
	.word 0x87802073  ! 3973: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r19
	.word 0xd28e89e0  ! 3975: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r9
	.word 0xdebfe000  ! 3976: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xdad78e60  ! 3977: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r13
	.word 0xd89f0e60  ! 3978: LDDA_R	ldda	[%r28, %r0] 0x73, %r12
	mov	0x3e8, %r20
	.word 0xdecf0e60  ! 3980: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r15
	.word 0xdecfa000  ! 3981: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3982: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeaf8e80  ! 3983: STBA_R	stba	%r15, [%r30 + %r0] 0x74
	.word 0xdac7a000  ! 3984: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	mov	0x7f8, %r21
	.word 0xdaaf2000  ! 3986: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdcb44400  ! 3987: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0xd8f5c4a0  ! 3988: STXA_R	stxa	%r12, [%r23 + %r0] 0x25
	.word 0x87802072  ! 3989: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r16
	.word 0xd6b70e60  ! 3991: STHA_R	stha	%r11, [%r28 + %r0] 0x73
	.word 0xdcd6e000  ! 3992: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r14
	.word 0xd0d40400  ! 3993: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	.word 0x87802025  ! 3994: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 3995: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r26
	.word 0xdc8c4400  ! 3997: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	mov	0x28, %r24
	.word 0x87802025  ! 3999: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r25
	.word 0xd8bce000  ! 4001: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	mov	0x68, %r18
	.word 0x87802025  ! 4003: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r25
	.word 0xd8f78e40  ! 4005: STXA_R	stxa	%r12, [%r30 + %r0] 0x72
	mov	0x30, %r26
	.word 0xdebda000  ! 4007: STDA_I	stda	%r15, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 4008: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0874e60  ! 4009: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r8
	.word 0xd08f8e80  ! 4010: LDUBA_R	lduba	[%r30, %r0] 0x74, %r8
	.word 0xdebe49e0  ! 4011: STDA_R	stda	%r15, [%r25 + %r0] 0x4f
	.word 0xdec74e80  ! 4012: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r15
	.word 0xd6bc0400  ! 4013: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0x87802074  ! 4014: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 4015: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6a72000  ! 4016: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd68f2000  ! 4017: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xd687e000  ! 4018: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6f76000  ! 4019: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6f4c400  ! 4020: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	mov	0x58, %r24
	.word 0xd0b6c9e0  ! 4022: STHA_R	stha	%r8, [%r27 + %r0] 0x4f
	mov	0x3d0, %r22
	.word 0xd0dec9e0  ! 4024: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r8
	.word 0xd2bf6000  ! 4025: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd2a72000  ! 4026: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0xdaa4c400  ! 4027: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0x87802074  ! 4028: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a4c400  ! 4029: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xdcb72000  ! 4030: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xdcbf2000  ! 4031: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdad7ce40  ! 4032: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r13
	.word 0xd4f7a000  ! 4033: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4d72000  ! 4034: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	.word 0xdebfce60  ! 4035: STDA_R	stda	%r15, [%r31 + %r0] 0x73
	.word 0xdccec9e0  ! 4036: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r14
	.word 0xd6cf4e60  ! 4037: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r11
	mov	0x7e8, %r23
	.word 0xd6f7ce60  ! 4039: STXA_R	stxa	%r11, [%r31 + %r0] 0x73
	mov	0x10, %r16
	.word 0xde8f4e80  ! 4041: LDUBA_R	lduba	[%r29, %r0] 0x74, %r15
	mov	0x68, %r17
	mov	0x18, %r17
	.word 0xd8cf8e60  ! 4044: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r12
	mov	0x48, %r24
	.word 0xd2f7ce80  ! 4046: STXA_R	stxa	%r9, [%r31 + %r0] 0x74
	mov	0x7d0, %r20
	.word 0x87802072  ! 4048: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4049: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4050: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde8e89e0  ! 4051: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r15
	.word 0x87802074  ! 4052: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf7ce60  ! 4053: STXA_R	stxa	%r13, [%r31 + %r0] 0x73
	.word 0x87802020  ! 4054: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r24
	.word 0xda85e000  ! 4056: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	mov	0x68, %r16
	.word 0xd4c689e0  ! 4058: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r10
	.word 0xd4856000  ! 4059: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r10
	.word 0xd49da000  ! 4060: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r10
	.word 0xdedf0e40  ! 4061: LDXA_R	ldxa	[%r28, %r0] 0x72, %r15
	.word 0xd49d6000  ! 4062: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r10
	mov	0x20, %r17
	.word 0xd4ad2000  ! 4064: STBA_I	stba	%r10, [%r20 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xdaf74e80  ! 4066: STXA_R	stxa	%r13, [%r29 + %r0] 0x74
	.word 0xd0b70e40  ! 4067: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	.word 0x87802072  ! 4068: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2c74e40  ! 4069: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r9
	.word 0xd487a000  ! 4070: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	.word 0xd2f584a0  ! 4071: STXA_R	stxa	%r9, [%r22 + %r0] 0x25
	.word 0xdef72000  ! 4072: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 4073: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde87e000  ! 4074: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xd2ce89e0  ! 4075: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r9
	.word 0xda9fe000  ! 4076: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xdaa72000  ! 4077: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	mov	0x30, %r24
	mov	0x3e0, %r21
	.word 0x87802074  ! 4080: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabf2000  ! 4081: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xdab72000  ! 4082: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdaaf6000  ! 4083: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0xda8f6000  ! 4085: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4086: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r24
	.word 0xd29e49e0  ! 4088: LDDA_R	ldda	[%r25, %r0] 0x4f, %r9
	.word 0xdacfe000  ! 4089: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4090: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabf6000  ! 4091: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xdac76000  ! 4092: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0xdaaf2000  ! 4093: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 4094: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r25
	.word 0xdc8e49e0  ! 4096: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r14
	mov	0x68, %r19
	.word 0xdcbfce60  ! 4098: STDA_R	stda	%r14, [%r31 + %r0] 0x73
	mov	0x28, %r17
	.word 0xd0d76000  ! 4100: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xd08fe000  ! 4101: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	.word 0xd0af2000  ! 4102: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0bfe000  ! 4103: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd0af6000  ! 4104: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd0f72000  ! 4105: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	mov	0x20, %r18
	mov	0x3f0, %r22
	mov	0x30, %r17
	.word 0xd0cf6000  ! 4109: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0x87802025  ! 4110: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 4111: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad40400  ! 4112: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	.word 0xd6bc2000  ! 4113: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0xd6a42000  ! 4114: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xd6bce000  ! 4115: STDA_I	stda	%r11, [%r19 + 0x0000] %asi
	.word 0xd68ce000  ! 4116: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	mov	0x3f0, %r23
	mov	0x48, %r19
	.word 0xd897ce40  ! 4119: LDUHA_R	lduha	[%r31, %r0] 0x72, %r12
	mov	0x58, %r16
	.word 0xd8df8e80  ! 4121: LDXA_R	ldxa	[%r30, %r0] 0x74, %r12
	.word 0xd88544a0  ! 4122: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r12
	.word 0xd8ac4400  ! 4123: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xdab504a0  ! 4124: STHA_R	stha	%r13, [%r20 + %r0] 0x25
	.word 0xdc8544a0  ! 4125: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r14
	.word 0xd0acc400  ! 4126: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd6940400  ! 4127: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	.word 0xdcaf8e60  ! 4128: STBA_R	stba	%r14, [%r30 + %r0] 0x73
	.word 0xd28ce000  ! 4129: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 4130: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f7a000  ! 4131: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xdc9689e0  ! 4132: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r14
	.word 0xd0978e40  ! 4133: LDUHA_R	lduha	[%r30, %r0] 0x72, %r8
	.word 0xd6d74e60  ! 4134: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r11
	.word 0xd8df2000  ! 4135: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xdec7ce60  ! 4136: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r15
	.word 0xd29c4400  ! 4137: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	.word 0x87802073  ! 4138: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6a40400  ! 4139: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	mov	0x8, %r26
	.word 0xd8ad6000  ! 4141: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	.word 0xdeaf8e80  ! 4142: STBA_R	stba	%r15, [%r30 + %r0] 0x74
	.word 0xd885e000  ! 4143: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r12
	.word 0x87802074  ! 4144: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8ac2000  ! 4145: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4146: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 4147: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 4148: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r26
	.word 0xd8942000  ! 4150: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r12
	.word 0xd8d42000  ! 4151: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0xda8f4e80  ! 4152: LDUBA_R	lduba	[%r29, %r0] 0x74, %r13
	mov	0x10, %r16
	.word 0xdaf42000  ! 4154: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0xd6978e40  ! 4155: LDUHA_R	lduha	[%r30, %r0] 0x72, %r11
	.word 0x87802025  ! 4156: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b72000  ! 4157: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd2af6000  ! 4158: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0xd287a000  ! 4160: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	mov	0x18, %r26
	.word 0xded649e0  ! 4162: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r15
	mov	0x7f0, %r22
	mov	0x60, %r16
	.word 0x8780204f  ! 4165: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4166: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c7e000  ! 4167: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4a504a0  ! 4168: STWA_R	stwa	%r10, [%r20 + %r0] 0x25
	.word 0x87802020  ! 4169: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4170: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r25
	.word 0xd2a76000  ! 4172: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd0ad04a0  ! 4173: STBA_R	stba	%r8, [%r20 + %r0] 0x25
	mov	0x30, %r26
	.word 0xda8d84a0  ! 4175: LDUBA_R	lduba	[%r22, %r0] 0x25, %r13
	.word 0x87802020  ! 4176: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r19
	.word 0xdab76000  ! 4178: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xd6b48400  ! 4179: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd8d4c400  ! 4180: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0xdef4c400  ! 4181: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xd89584a0  ! 4182: LDUHA_R	lduha	[%r22, %r0] 0x25, %r12
	.word 0xd0a76000  ! 4183: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0d7e000  ! 4184: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0afe000  ! 4185: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	mov	0x8, %r16
	.word 0xd0b7a000  ! 4187: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd0df6000  ! 4188: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	mov	0x58, %r27
	mov	0x3d8, %r20
	.word 0xd2b70e80  ! 4191: STHA_R	stha	%r9, [%r28 + %r0] 0x74
	.word 0xdcd5c4a0  ! 4192: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r14
	.word 0xd0df0e80  ! 4193: LDXA_R	ldxa	[%r28, %r0] 0x74, %r8
	.word 0xda97ce60  ! 4194: LDUHA_R	lduha	[%r31, %r0] 0x73, %r13
	.word 0xda9544a0  ! 4195: LDUHA_R	lduha	[%r21, %r0] 0x25, %r13
	.word 0x87802072  ! 4196: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r16
	.word 0xdecfa000  ! 4198: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	mov	0x7f8, %r23
	.word 0x87802025  ! 4200: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd28cc400  ! 4201: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	.word 0xdcb6c9e0  ! 4202: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	.word 0xd4f46000  ! 4203: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0xdcdd84a0  ! 4204: LDXA_R	ldxa	[%r22, %r0] 0x25, %r14
	.word 0xd2a46000  ! 4205: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2b4e000  ! 4206: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 4207: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2ad2000  ! 4208: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xd29d2000  ! 4209: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r9
	.word 0xd2f52000  ! 4210: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	.word 0xd4cc4400  ! 4211: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r10
	.word 0xdcc5a000  ! 4212: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r14
	.word 0xdcd5a000  ! 4213: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r14
	.word 0xdcb52000  ! 4214: STHA_I	stha	%r14, [%r20 + 0x0000] %asi
	mov	0x18, %r27
	.word 0xdccda000  ! 4216: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r14
	.word 0xdcf52000  ! 4217: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	.word 0xd4870e40  ! 4218: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r10
	.word 0xd29fce80  ! 4219: LDDA_R	ldda	[%r31, %r0] 0x74, %r9
	.word 0xd09da000  ! 4220: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r8
	.word 0x87802025  ! 4221: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4bfce80  ! 4222: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	.word 0xdebc8400  ! 4223: STDA_R	stda	%r15, [%r18 + %r0] 0x20
	mov	0x0, %r25
	.word 0x87802025  ! 4225: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4c544a0  ! 4226: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r10
	.word 0xdab48400  ! 4227: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0xd2f44400  ! 4228: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	mov	0x7f8, %r22
	.word 0xd6f4c400  ! 4230: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0x87802025  ! 4231: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e0, %r20
	.word 0xd6bc8400  ! 4233: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xde9c8400  ! 4234: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	mov	0x40, %r27
	.word 0xd8afce40  ! 4236: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	.word 0xd2cfce80  ! 4237: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r9
	.word 0xd69f4e80  ! 4238: LDDA_R	ldda	[%r29, %r0] 0x74, %r11
	.word 0xdc9d04a0  ! 4239: LDDA_R	ldda	[%r20, %r0] 0x25, %r14
	mov	0x3d8, %r22
	mov	0x3c0, %r22
	mov	0x78, %r18
	.word 0xd6f7a000  ! 4243: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6c72000  ! 4244: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	mov	0x30, %r18
	.word 0x87802074  ! 4246: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 4247: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a5a000  ! 4248: STWA_I	stwa	%r11, [%r22 + 0x0000] %asi
	.word 0xd6cd6000  ! 4249: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r11
	.word 0x87802072  ! 4250: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdec40400  ! 4251: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xd8d544a0  ! 4252: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r12
	.word 0xd0f4c400  ! 4253: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0xd0bf8e80  ! 4254: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	mov	0x30, %r16
	.word 0xdcf4e000  ! 4256: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xd48d84a0  ! 4257: LDUBA_R	lduba	[%r22, %r0] 0x25, %r10
	.word 0xd4f46000  ! 4258: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0xd6a70e40  ! 4259: STWA_R	stwa	%r11, [%r28 + %r0] 0x72
	mov	0x60, %r19
	mov	0x38, %r26
	.word 0xdebca000  ! 4262: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xd0944400  ! 4263: LDUHA_R	lduha	[%r17, %r0] 0x20, %r8
	.word 0xdc9f8e80  ! 4264: LDDA_R	ldda	[%r30, %r0] 0x74, %r14
	mov	0x3e0, %r22
	.word 0xdeac8400  ! 4266: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xdeac6000  ! 4267: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xdebca000  ! 4268: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xdcf649e0  ! 4269: STXA_R	stxa	%r14, [%r25 + %r0] 0x4f
	.word 0xd2948400  ! 4270: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	.word 0xdcf44400  ! 4271: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xd2ae89e0  ! 4272: STBA_R	stba	%r9, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 4273: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f74e60  ! 4274: STXA_R	stxa	%r9, [%r29 + %r0] 0x73
	.word 0xd4f5a000  ! 4275: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	.word 0xd4cf0e40  ! 4276: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r10
	.word 0xd0ac8400  ! 4277: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xd6f70e80  ! 4278: STXA_R	stxa	%r11, [%r28 + %r0] 0x74
	mov	0x50, %r19
	.word 0xdcb7ce60  ! 4280: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	.word 0xd0978e80  ! 4281: LDUHA_R	lduha	[%r30, %r0] 0x74, %r8
	.word 0xdac7ce60  ! 4282: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r13
	.word 0x8780204f  ! 4283: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r17
	mov	0x50, %r19
	.word 0xd4a66000  ! 4286: STWA_I	stwa	%r10, [%r25 + 0x0000] %asi
	.word 0xd486e000  ! 4287: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	mov	0x7c8, %r21
	.word 0x87802020  ! 4289: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4290: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabf8e80  ! 4291: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	.word 0xd4af8e40  ! 4292: STBA_R	stba	%r10, [%r30 + %r0] 0x72
	.word 0xdabc6000  ! 4293: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 4294: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 4295: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4296: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 4297: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 4298: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r24
	.word 0xdab7a000  ! 4300: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 4301: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r26
	.word 0xd0a40400  ! 4303: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0x87802020  ! 4304: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r20
	.word 0xd4bce000  ! 4306: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0xda944400  ! 4307: LDUHA_R	lduha	[%r17, %r0] 0x20, %r13
	mov	0x20, %r16
	.word 0xdaace000  ! 4309: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	mov	0x40, %r27
	mov	0x18, %r17
	mov	0x7c0, %r22
	mov	0x58, %r26
	.word 0xdacca000  ! 4314: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	mov	0x18, %r16
	.word 0xd6d70e80  ! 4316: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r11
	mov	0x7d0, %r20
	.word 0x87802020  ! 4318: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcc4a000  ! 4319: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r14
	mov	0x7c8, %r20
	mov	0x0, %r26
	.word 0xd0a78e60  ! 4322: STWA_R	stwa	%r8, [%r30 + %r0] 0x73
	.word 0xd0d5c4a0  ! 4323: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r8
	.word 0xdac42000  ! 4324: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0xd0b4c400  ! 4325: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0x87802074  ! 4326: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacc2000  ! 4327: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xd6f74e80  ! 4328: STXA_R	stxa	%r11, [%r29 + %r0] 0x74
	.word 0x87802020  ! 4329: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c5e000  ! 4330: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r9
	.word 0xd2ade000  ! 4331: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0xd2856000  ! 4332: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r9
	.word 0xd2ada000  ! 4333: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xd2b56000  ! 4334: STHA_I	stha	%r9, [%r21 + 0x0000] %asi
	.word 0xd0f5c4a0  ! 4335: STXA_R	stxa	%r8, [%r23 + %r0] 0x25
	mov	0x40, %r19
	.word 0x87802020  ! 4337: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r21
	.word 0xd4af6000  ! 4339: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd4d7a000  ! 4340: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	mov	0x68, %r25
	mov	0x48, %r17
	mov	0x28, %r17
	.word 0xd8f4c400  ! 4344: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xd6970e60  ! 4345: LDUHA_R	lduha	[%r28, %r0] 0x73, %r11
	mov	0x18, %r16
	.word 0xd4c74e80  ! 4347: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r10
	.word 0xd4870e60  ! 4348: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r10
	.word 0xd4afe000  ! 4349: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	mov	0x7f8, %r21
	mov	0x60, %r27
	.word 0x8780204f  ! 4352: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f42000  ! 4353: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd4ace000  ! 4354: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0xd49f8e80  ! 4355: LDDA_R	ldda	[%r30, %r0] 0x74, %r10
	.word 0xd8842000  ! 4356: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	.word 0xda8fce40  ! 4357: LDUBA_R	lduba	[%r31, %r0] 0x72, %r13
	.word 0xd0cc6000  ! 4358: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	.word 0xd09ce000  ! 4359: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r8
	.word 0xde9ec9e0  ! 4360: LDDA_R	ldda	[%r27, %r0] 0x4f, %r15
	.word 0xde840400  ! 4361: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	.word 0x87802073  ! 4362: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf7a000  ! 4363: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xd6d74e40  ! 4365: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r11
	.word 0xda8fe000  ! 4366: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	mov	0x30, %r18
	.word 0x87802074  ! 4368: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r24
	.word 0xdaad44a0  ! 4370: STBA_R	stba	%r13, [%r21 + %r0] 0x25
	mov	0x7f8, %r23
	.word 0xd89e2000  ! 4372: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r12
	mov	0x7f8, %r22
	.word 0xd6ddc4a0  ! 4374: LDXA_R	ldxa	[%r23, %r0] 0x25, %r11
	.word 0xd0be2000  ! 4375: STDA_I	stda	%r8, [%r24 + 0x0000] %asi
	.word 0x87802072  ! 4376: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0bc2000  ! 4377: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 4378: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4379: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0df6000  ! 4380: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	mov	0x50, %r27
	.word 0xd0a7a000  ! 4382: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 4383: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8cd44a0  ! 4384: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r12
	.word 0x87802072  ! 4385: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r16
	mov	0x0, %r17
	.word 0xd2dca000  ! 4388: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r9
	.word 0xd6a689e0  ! 4389: STWA_R	stwa	%r11, [%r26 + %r0] 0x4f
	mov	0x20, %r25
	.word 0xdabca000  ! 4391: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdeb44400  ! 4392: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	mov	0x48, %r24
	mov	0x20, %r25
	.word 0xde9ca000  ! 4395: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	mov	0x70, %r24
	.word 0xded4e000  ! 4397: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	.word 0x87802074  ! 4398: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda874e80  ! 4399: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r13
	.word 0x87802074  ! 4400: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r17
	.word 0xd88e6000  ! 4402: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r12
	.word 0xd8a6e000  ! 4403: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	.word 0xd8f66000  ! 4404: STXA_I	stxa	%r12, [%r25 + 0x0000] %asi
	.word 0xd8b6e000  ! 4405: STHA_I	stha	%r12, [%r27 + 0x0000] %asi
	mov	0x58, %r26
	mov	0x78, %r16
	.word 0xdea649e0  ! 4408: STWA_R	stwa	%r15, [%r25 + %r0] 0x4f
	.word 0x87802073  ! 4409: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8bf2000  ! 4410: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	mov	0x50, %r27
	.word 0xd2bfce60  ! 4412: STDA_R	stda	%r9, [%r31 + %r0] 0x73
	.word 0xdcbf8e80  ! 4413: STDA_R	stda	%r14, [%r30 + %r0] 0x74
	.word 0xd2dcc400  ! 4414: LDXA_R	ldxa	[%r19, %r0] 0x20, %r9
	mov	0x7d0, %r20
	.word 0xdcc74e80  ! 4416: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r14
	.word 0xd8b40400  ! 4417: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xdc87ce80  ! 4418: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r14
	.word 0xd2f76000  ! 4419: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xd29fe000  ! 4420: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd2b76000  ! 4421: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2f7e000  ! 4422: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd8870e40  ! 4423: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r12
	.word 0xd2cfa000  ! 4424: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	.word 0xd2f7e000  ! 4425: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	mov	0x68, %r17
	.word 0x8780204f  ! 4427: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r16
	mov	0x20, %r26
	.word 0xd2b76000  ! 4430: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xdc9ec9e0  ! 4431: LDDA_R	ldda	[%r27, %r0] 0x4f, %r14
	.word 0xd8d74e80  ! 4432: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r12
	.word 0xd4af6000  ! 4433: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 4434: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r18
	.word 0xd4ac2000  ! 4436: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4437: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f7a000  ! 4438: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 4439: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d78e40  ! 4440: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r12
	.word 0xdeaee000  ! 4441: STBA_I	stba	%r15, [%r27 + 0x0000] %asi
	.word 0xdea66000  ! 4442: STWA_I	stwa	%r15, [%r25 + 0x0000] %asi
	mov	0x10, %r24
	mov	0x40, %r26
	.word 0xdaacc400  ! 4445: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0xdaf689e0  ! 4446: STXA_R	stxa	%r13, [%r26 + %r0] 0x4f
	.word 0xda96e000  ! 4447: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r13
	.word 0xd2aec9e0  ! 4448: STBA_R	stba	%r9, [%r27 + %r0] 0x4f
	.word 0xd4b6a000  ! 4449: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	.word 0xd2bf4e80  ! 4450: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	.word 0xd8a6e000  ! 4451: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	.word 0xd88e6000  ! 4452: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r12
	mov	0x7f8, %r20
	.word 0xd8b66000  ! 4454: STHA_I	stha	%r12, [%r25 + 0x0000] %asi
	.word 0xdc8f0e80  ! 4455: LDUBA_R	lduba	[%r28, %r0] 0x74, %r14
	.word 0xd6966000  ! 4456: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r11
	.word 0xd2d78e40  ! 4457: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r9
	mov	0x3f8, %r22
	.word 0xd6840400  ! 4459: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0xd8cc0400  ! 4460: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	.word 0xd4aee000  ! 4461: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0x87802072  ! 4463: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a46000  ! 4464: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xdcdc4400  ! 4465: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	.word 0xda9f0e40  ! 4466: LDDA_R	ldda	[%r28, %r0] 0x72, %r13
	.word 0x8780204f  ! 4467: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f8, %r22
	.word 0xde8544a0  ! 4469: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r15
	mov	0x3c8, %r22
	.word 0xdcd42000  ! 4471: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	.word 0xd2d6c9e0  ! 4472: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r9
	.word 0xdabca000  ! 4473: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdad46000  ! 4474: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	.word 0xdea7ce80  ! 4475: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	.word 0xdcb42000  ! 4476: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xdccc2000  ! 4477: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r14
	.word 0xd2c544a0  ! 4478: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r9
	.word 0xd2b4e000  ! 4479: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 4480: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda87ce40  ! 4481: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r13
	.word 0x87802020  ! 4482: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8dca000  ! 4483: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	.word 0xd4b6c9e0  ! 4484: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0xd4a4e000  ! 4485: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 4486: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d4a000  ! 4487: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0xd8b44400  ! 4488: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0xda8ce000  ! 4489: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	mov	0x40, %r27
	.word 0x87802072  ! 4491: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 4492: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r17
	.word 0xda8f6000  ! 4494: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0x87802073  ! 4495: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8a504a0  ! 4496: STWA_R	stwa	%r12, [%r20 + %r0] 0x25
	.word 0xd8df4e40  ! 4497: LDXA_R	ldxa	[%r29, %r0] 0x72, %r12
	.word 0xdcbc6000  ! 4498: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 4499: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcc76000  ! 4500: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4501: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r27
	.word 0xdcf76000  ! 4503: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdca76000  ! 4504: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdabd04a0  ! 4505: STDA_R	stda	%r13, [%r20 + %r0] 0x25
	.word 0x87802025  ! 4506: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 4507: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcc72000  ! 4508: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xdc876000  ! 4509: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	mov	0x7e8, %r22
	.word 0x8780204f  ! 4511: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbc6000  ! 4512: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xdc84e000  ! 4513: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4514: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccca000  ! 4515: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	mov	0x7f0, %r23
	.word 0xdcaca000  ! 4517: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xd2ae89e0  ! 4518: STBA_R	stba	%r9, [%r26 + %r0] 0x4f
	mov	0x3e0, %r23
	.word 0xd69ce000  ! 4520: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r11
	.word 0xd684e000  ! 4521: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r11
	.word 0xd4f609e0  ! 4522: STXA_R	stxa	%r10, [%r24 + %r0] 0x4f
	.word 0xd6d40400  ! 4523: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	.word 0xdcf44400  ! 4524: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0x87802020  ! 4525: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r20
	.word 0xd4af8e80  ! 4527: STBA_R	stba	%r10, [%r30 + %r0] 0x74
	.word 0xd0856000  ! 4528: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r8
	.word 0xd8c78e40  ! 4529: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r12
	.word 0xd8ad2000  ! 4530: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	.word 0xd8a5e000  ! 4531: STWA_I	stwa	%r12, [%r23 + 0x0000] %asi
	mov	0x8, %r19
	mov	0x3f0, %r21
	.word 0xd4ae89e0  ! 4534: STBA_R	stba	%r10, [%r26 + %r0] 0x4f
	.word 0xdcbd6000  ! 4535: STDA_I	stda	%r14, [%r21 + 0x0000] %asi
	.word 0x87802072  ! 4536: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc95a000  ! 4537: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r14
	.word 0xdcf5a000  ! 4538: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	.word 0xdad48400  ! 4539: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0xdec74e40  ! 4540: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r15
	mov	0x50, %r25
	.word 0x87802025  ! 4542: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdacfce60  ! 4543: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r13
	.word 0xd4cd6000  ! 4544: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r10
	mov	0x3d0, %r23
	.word 0xd4952000  ! 4546: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r10
	.word 0x87802073  ! 4547: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f7a000  ! 4548: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd6ae89e0  ! 4549: STBA_R	stba	%r11, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 4550: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdccf8e80  ! 4551: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r14
	.word 0xdcd504a0  ! 4552: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r14
	mov	0x3d8, %r23
	mov	0x7d8, %r23
	.word 0xd29504a0  ! 4555: LDUHA_R	lduha	[%r20, %r0] 0x25, %r9
	.word 0x8780204f  ! 4556: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 4557: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4cfce60  ! 4558: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r10
	.word 0xdec4a000  ! 4559: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xdecc2000  ! 4560: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 4561: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde8ee000  ! 4562: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r15
	.word 0x87802074  ! 4563: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0970e60  ! 4564: LDUHA_R	lduha	[%r28, %r0] 0x73, %r8
	.word 0xd0ac6000  ! 4565: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	mov	0x38, %r25
	.word 0x87802025  ! 4567: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0dfa000  ! 4568: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0xd6cf8e40  ! 4569: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r11
	.word 0x87802025  ! 4570: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb70e40  ! 4571: STHA_R	stha	%r15, [%r28 + %r0] 0x72
	.word 0xd89c0400  ! 4572: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	.word 0x87802020  ! 4573: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4574: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd497e000  ! 4575: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	.word 0xdebf0e80  ! 4576: STDA_R	stda	%r15, [%r28 + %r0] 0x74
	.word 0xd0afa000  ! 4577: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd6f44400  ! 4578: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0xd0c7e000  ! 4579: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0xd8d7ce80  ! 4580: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r12
	.word 0xded78e60  ! 4581: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r15
	.word 0x87802074  ! 4582: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd09689e0  ! 4583: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r8
	.word 0x87802073  ! 4584: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 4585: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r17
	.word 0x87802020  ! 4587: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b74e80  ! 4588: STHA_R	stha	%r9, [%r29 + %r0] 0x74
	.word 0x87802074  ! 4589: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d8, %r20
	.word 0xdc87a000  ! 4591: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcc7e000  ! 4592: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0xdc8f6000  ! 4593: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcafe000  ! 4594: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	mov	0x60, %r27
	.word 0xdc9f6000  ! 4596: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xdcaf6000  ! 4597: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xd0cc8400  ! 4598: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0x87802020  ! 4599: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4600: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf40400  ! 4601: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xd2ae2000  ! 4602: STBA_I	stba	%r9, [%r24 + 0x0000] %asi
	.word 0xd2c66000  ! 4603: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r9
	mov	0x3c0, %r20
	.word 0xd88c0400  ! 4605: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	mov	0x70, %r19
	.word 0xd8bee000  ! 4607: STDA_I	stda	%r12, [%r27 + 0x0000] %asi
	.word 0xd886a000  ! 4608: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r12
	.word 0xd6ad84a0  ! 4609: STBA_R	stba	%r11, [%r22 + %r0] 0x25
	mov	0x70, %r17
	.word 0xdab74e60  ! 4611: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	.word 0xd2be09e0  ! 4612: STDA_R	stda	%r9, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 4613: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4614: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r27
	.word 0xdef46000  ! 4616: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xda9f4e40  ! 4617: LDDA_R	ldda	[%r29, %r0] 0x72, %r13
	mov	0x58, %r18
	mov	0x68, %r25
	.word 0x87802073  ! 4620: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 4621: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd89ea000  ! 4622: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r12
	.word 0xd0be89e0  ! 4623: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	.word 0xd0ccc400  ! 4624: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	.word 0xd8a6e000  ! 4625: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	.word 0xd8b6e000  ! 4626: STHA_I	stha	%r12, [%r27 + 0x0000] %asi
	.word 0xde97ce60  ! 4627: LDUHA_R	lduha	[%r31, %r0] 0x73, %r15
	.word 0x87802020  ! 4628: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r22
	.word 0x87802072  ! 4630: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8972000  ! 4631: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4632: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4633: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08c8400  ! 4634: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0xd0b7e000  ! 4635: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0xd0af2000  ! 4636: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0c7e000  ! 4637: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	mov	0x60, %r25
	.word 0x87802073  ! 4639: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdadc0400  ! 4640: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	.word 0x87802074  ! 4641: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r24
	.word 0xd0ae89e0  ! 4643: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	.word 0xd8f5a000  ! 4644: STXA_I	stxa	%r12, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 4645: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6874e80  ! 4646: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r11
	mov	0x60, %r19
	.word 0xd6a48400  ! 4648: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0x87802073  ! 4649: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca7a000  ! 4650: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xd2df0e80  ! 4651: LDXA_R	ldxa	[%r28, %r0] 0x74, %r9
	.word 0xd4a76000  ! 4652: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd0874e60  ! 4653: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r8
	mov	0x10, %r19
	.word 0x87802074  ! 4655: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4656: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r27
	.word 0xd0b70e80  ! 4658: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	.word 0xd4d689e0  ! 4659: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r10
	.word 0x87802020  ! 4660: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4661: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4662: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a46000  ! 4663: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd4acc400  ! 4664: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	mov	0x70, %r17
	.word 0xdcc74e80  ! 4666: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r14
	.word 0xd88c0400  ! 4667: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	.word 0xd0870e40  ! 4668: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r8
	.word 0xd4a504a0  ! 4669: STWA_R	stwa	%r10, [%r20 + %r0] 0x25
	.word 0xdec46000  ! 4670: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	.word 0xde9c2000  ! 4671: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0x87802072  ! 4672: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r18
	.word 0xdccf8e80  ! 4674: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r14
	.word 0xd2f7e000  ! 4675: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd2df2000  ! 4676: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd6c7ce40  ! 4677: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r11
	.word 0xd0c7e000  ! 4678: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0x87802072  ! 4679: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0bce000  ! 4680: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0xdacf4e80  ! 4681: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r13
	mov	0x70, %r24
	.word 0x8780204f  ! 4683: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r19
	.word 0xd2bd84a0  ! 4685: STDA_R	stda	%r9, [%r22 + %r0] 0x25
	.word 0xd28f4e60  ! 4686: LDUBA_R	lduba	[%r29, %r0] 0x73, %r9
	.word 0x87802020  ! 4687: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4af0e80  ! 4688: STBA_R	stba	%r10, [%r28 + %r0] 0x74
	.word 0xd497a000  ! 4689: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0xd4878e80  ! 4690: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r10
	.word 0xd487ce60  ! 4691: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r10
	mov	0x78, %r27
	.word 0xd0c72000  ! 4693: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0afa000  ! 4694: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	mov	0x60, %r26
	mov	0x7e8, %r20
	.word 0xd6b7ce40  ! 4697: STHA_R	stha	%r11, [%r31 + %r0] 0x72
	mov	0x28, %r18
	.word 0xd49f6000  ! 4699: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	mov	0x58, %r25
	mov	0x40, %r18
	.word 0xd4876000  ! 4702: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xd49f2000  ! 4703: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd6b544a0  ! 4704: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	mov	0x30, %r17
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdaf4c400  ! 4707: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	mov	0x7c0, %r20
	.word 0xdef649e0  ! 4709: STXA_R	stxa	%r15, [%r25 + %r0] 0x4f
	.word 0xd6b6c9e0  ! 4710: STHA_R	stha	%r11, [%r27 + %r0] 0x4f
	mov	0x58, %r18
	.word 0xd6dc4400  ! 4712: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xdec70e40  ! 4713: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r15
	.word 0xd0d504a0  ! 4714: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r8
	.word 0xd4840400  ! 4715: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	.word 0xd8848400  ! 4716: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r12
	.word 0xd2978e60  ! 4717: LDUHA_R	lduha	[%r30, %r0] 0x73, %r9
	mov	0x78, %r19
	.word 0xd8dfe000  ! 4719: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xdcf584a0  ! 4720: STXA_R	stxa	%r14, [%r22 + %r0] 0x25
	.word 0x87802025  ! 4721: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r25
	mov	0x3e0, %r20
	.word 0x87802072  ! 4724: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6970e80  ! 4725: LDUHA_R	lduha	[%r28, %r0] 0x74, %r11
	.word 0xdcbf6000  ! 4726: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	mov	0x7e0, %r22
	mov	0x0, %r18
	.word 0xdcc7a000  ! 4729: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdcf76000  ! 4731: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xd6a40400  ! 4732: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0x87802025  ! 4733: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r25
	.word 0xdcafce40  ! 4735: STBA_R	stba	%r14, [%r31 + %r0] 0x72
	.word 0xdaaf4e80  ! 4736: STBA_R	stba	%r13, [%r29 + %r0] 0x74
	.word 0x87802073  ! 4737: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4738: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf74e40  ! 4739: STXA_R	stxa	%r13, [%r29 + %r0] 0x72
	.word 0xd4bdc4a0  ! 4740: STDA_R	stda	%r10, [%r23 + %r0] 0x25
	.word 0xd4bfe000  ! 4741: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd8d4c400  ! 4742: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	mov	0x38, %r17
	.word 0xd8f7e000  ! 4744: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd69d84a0  ! 4745: LDDA_R	ldda	[%r22, %r0] 0x25, %r11
	mov	0x7e0, %r21
	.word 0xdcac8400  ! 4747: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0x87802072  ! 4748: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebe89e0  ! 4749: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	mov	0x70, %r17
	.word 0xdaa70e40  ! 4751: STWA_R	stwa	%r13, [%r28 + %r0] 0x72
	.word 0xd0d72000  ! 4752: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0c7a000  ! 4753: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	mov	0x28, %r27
	.word 0xd6d40400  ! 4755: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	.word 0xdaf76000  ! 4756: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 4757: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 4758: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcd7ce40  ! 4759: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r14
	.word 0x8780204f  ! 4760: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r27
	.word 0x87802025  ! 4762: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 4763: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeafa000  ! 4764: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xded72000  ! 4765: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xd6870e80  ! 4766: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r11
	mov	0x10, %r19
	mov	0x3f0, %r21
	.word 0xdcdc8400  ! 4769: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	.word 0xdea70e40  ! 4770: STWA_R	stwa	%r15, [%r28 + %r0] 0x72
	.word 0xd4f4c400  ! 4771: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	mov	0x40, %r18
	mov	0x3c8, %r20
	mov	0x38, %r24
	.word 0xded7e000  ! 4775: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0x87802025  ! 4776: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2974e80  ! 4777: LDUHA_R	lduha	[%r29, %r0] 0x74, %r9
	.word 0x8780204f  ! 4778: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r17
	mov	0x7f0, %r22
	.word 0x87802025  ! 4781: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcac0400  ! 4782: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xd8d70e80  ! 4783: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r12
	mov	0x28, %r18
	mov	0x7f0, %r23
	.word 0xd4a56000  ! 4786: STWA_I	stwa	%r10, [%r21 + 0x0000] %asi
	mov	0x3c0, %r20
	.word 0xd2b74e80  ! 4788: STHA_R	stha	%r9, [%r29 + %r0] 0x74
	.word 0xd6870e60  ! 4789: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r11
	mov	0x7f8, %r21
	.word 0x87802020  ! 4791: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r21
	.word 0xd2cfe000  ! 4793: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	.word 0xd2bfa000  ! 4794: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd28f6000  ! 4795: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd2b7e000  ! 4796: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd4b74e60  ! 4797: STHA_R	stha	%r10, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 4798: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4799: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r17
	.word 0xdc9609e0  ! 4801: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r14
	.word 0xda9fe000  ! 4802: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdaf7e000  ! 4804: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 4805: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r27
	mov	0x7d8, %r23
	.word 0x87802020  ! 4808: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69f0e40  ! 4809: LDDA_R	ldda	[%r28, %r0] 0x72, %r11
	mov	0x70, %r24
	mov	0x0, %r27
	.word 0xd6af2000  ! 4812: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd0948400  ! 4813: LDUHA_R	lduha	[%r18, %r0] 0x20, %r8
	.word 0xd2bf2000  ! 4814: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd4f4c400  ! 4815: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd8dc8400  ! 4816: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xdac76000  ! 4817: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0xd8c78e80  ! 4818: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r12
	.word 0xd2a74e60  ! 4819: STWA_R	stwa	%r9, [%r29 + %r0] 0x73
	mov	0x7e8, %r23
	.word 0xdabfa000  ! 4821: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdacf6000  ! 4822: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xda970e80  ! 4823: LDUHA_R	lduha	[%r28, %r0] 0x74, %r13
	.word 0x87802025  ! 4824: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f4c400  ! 4825: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0xd2dfce60  ! 4826: LDXA_R	ldxa	[%r31, %r0] 0x73, %r9
	.word 0x87802073  ! 4827: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e0, %r23
	.word 0x87802074  ! 4829: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde8f0e40  ! 4830: LDUBA_R	lduba	[%r28, %r0] 0x72, %r15
	.word 0xdcd44400  ! 4831: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	mov	0x48, %r24
	.word 0x87802020  ! 4833: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabfce40  ! 4834: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	.word 0xdaf7ce60  ! 4835: STXA_R	stxa	%r13, [%r31 + %r0] 0x73
	.word 0xd2a76000  ! 4836: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xd2872000  ! 4838: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	.word 0xd4f78e40  ! 4839: STXA_R	stxa	%r10, [%r30 + %r0] 0x72
	.word 0xd8844400  ! 4840: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r12
	.word 0xda97e000  ! 4841: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	.word 0xdab76000  ! 4842: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	mov	0x0, %r27
	.word 0xdaaf6000  ! 4844: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xdadfa000  ! 4845: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xdaaf6000  ! 4846: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xda8f6000  ! 4847: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xda97e000  ! 4848: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	.word 0xdab7e000  ! 4849: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xd6940400  ! 4850: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	.word 0xdcbf8e40  ! 4851: STDA_R	stda	%r14, [%r30 + %r0] 0x72
	mov	0x3d0, %r21
	.word 0xd28c8400  ! 4853: LDUBA_R	lduba	[%r18, %r0] 0x20, %r9
	.word 0x8780204f  ! 4854: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeaf6000  ! 4855: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xd0a74e40  ! 4856: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	.word 0xd0af0e40  ! 4857: STBA_R	stba	%r8, [%r28 + %r0] 0x72
	.word 0xd0a76000  ! 4858: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd097a000  ! 4859: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	mov	0x40, %r25
	.word 0xd0f689e0  ! 4861: STXA_R	stxa	%r8, [%r26 + %r0] 0x4f
	mov	0x68, %r25
	.word 0xd2ac8400  ! 4863: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0x87802074  ! 4864: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f46000  ! 4865: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0xd4bc0400  ! 4866: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xd0f584a0  ! 4867: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	.word 0xd4ce49e0  ! 4868: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r10
	.word 0x87802072  ! 4869: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a62000  ! 4870: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	.word 0xdef504a0  ! 4871: STXA_R	stxa	%r15, [%r20 + %r0] 0x25
	mov	0x40, %r16
	.word 0xdc9ea000  ! 4873: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r14
	mov	0x0, %r25
	.word 0xdc970e60  ! 4875: LDUHA_R	lduha	[%r28, %r0] 0x73, %r14
	.word 0xd6d6e000  ! 4876: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r11
	.word 0xd686e000  ! 4877: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r11
	.word 0xd0bcc400  ! 4878: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	mov	0x50, %r26
	mov	0x0, %r18
	mov	0x3d0, %r21
	.word 0xd086e000  ! 4882: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r8
	.word 0x87802073  ! 4883: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d8, %r23
	mov	0x70, %r17
	.word 0xd0aca000  ! 4886: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xd6cf0e80  ! 4887: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r11
	.word 0xd28c6000  ! 4888: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	mov	0x60, %r16
	.word 0x87802020  ! 4890: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4891: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d0, %r22
	mov	0x8, %r26
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd29fe000  ! 4895: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	mov	0x7e8, %r21
	mov	0x38, %r26
	.word 0xd2df6000  ! 4898: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	mov	0x50, %r16
	.word 0xd28fe000  ! 4900: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	.word 0x87802020  ! 4901: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f48400  ! 4902: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	mov	0x40, %r17
	.word 0xd0b584a0  ! 4904: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	.word 0xd6844400  ! 4905: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r11
	.word 0x87802072  ! 4906: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4c76000  ! 4907: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	mov	0x50, %r17
	.word 0xd4bfe000  ! 4909: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xd4af6000  ! 4911: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd4872000  ! 4912: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4d74e80  ! 4913: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r10
	.word 0xde9504a0  ! 4914: LDUHA_R	lduha	[%r20, %r0] 0x25, %r15
	.word 0x8780204f  ! 4915: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2afe000  ! 4916: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd2bf2000  ! 4917: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd2972000  ! 4918: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xdea6c9e0  ! 4919: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	mov	0x78, %r25
	.word 0xd0a7e000  ! 4921: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0af2000  ! 4922: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0a7e000  ! 4923: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xdaa4c400  ! 4924: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	mov	0x7c8, %r21
	mov	0x58, %r19
	mov	0x60, %r19
	mov	0x70, %r27
	.word 0xdcd584a0  ! 4929: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r14
	.word 0x87802073  ! 4930: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r25
	.word 0x87802025  ! 4932: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc8c0400  ! 4933: LDUBA_R	lduba	[%r16, %r0] 0x20, %r14
	.word 0xdcf44400  ! 4934: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xdcd46000  ! 4935: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	.word 0xdcbc2000  ! 4936: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xdcbc6000  ! 4937: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	mov	0x20, %r16
	.word 0xdcace000  ! 4939: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0xdc9c2000  ! 4940: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r14
	.word 0x87802025  ! 4941: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r17
	mov	0x50, %r19
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802025  ! 4945: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc95e000  ! 4946: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r14
	mov	0x8, %r24
	.word 0xdebfce60  ! 4948: STDA_R	stda	%r15, [%r31 + %r0] 0x73
	.word 0xd4a48400  ! 4949: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xdccde000  ! 4950: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r14
	mov	0x40, %r19
	.word 0xdcb44400  ! 4952: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	mov	0x58, %r24
	.word 0xd2ac8400  ! 4954: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xdc9d2000  ! 4955: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r14
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x28, %r17
	.word 0xdcb52000  ! 4958: STHA_I	stha	%r14, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 4959: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf42000  ! 4960: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	mov	0x7d0, %r20
	.word 0xdecf4e60  ! 4962: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r15
	.word 0x87802020  ! 4963: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedca000  ! 4964: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xdef42000  ! 4965: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xded4a000  ! 4966: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	.word 0xdeb4a000  ! 4967: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0xd8a48400  ! 4968: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	.word 0xd8a78e60  ! 4969: STWA_R	stwa	%r12, [%r30 + %r0] 0x73
	mov	0x60, %r18
	.word 0xd8f4e000  ! 4971: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xd4d544a0  ! 4972: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r10
	.word 0xdaa46000  ! 4973: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	mov	0x48, %r16
	.word 0xdab42000  ! 4975: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 4976: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdade2000  ! 4977: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r13
	.word 0xd2a48400  ! 4978: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	mov	0x50, %r16
	.word 0xd8a6a000  ! 4980: STWA_I	stwa	%r12, [%r26 + 0x0000] %asi
	.word 0xd8cea000  ! 4981: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4982: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r26
	mov	0x7f0, %r20
	.word 0xd0b78e40  ! 4985: STHA_R	stha	%r8, [%r30 + %r0] 0x72
	.word 0xd8bf2000  ! 4986: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	mov	0x10, %r26
	mov	0x40, %r27
	.word 0xd2844400  ! 4989: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	.word 0xd0dfe000  ! 4990: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	mov	0x7f0, %r23
	.word 0xd0ccc400  ! 4992: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	.word 0xdeafa000  ! 4993: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	mov	0x20, %r19
	.word 0xd2a48400  ! 4995: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	mov	0x30, %r19
	.word 0xd0af6000  ! 4997: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd0a72000  ! 4998: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x0, %r24
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_1:
	.word 0xd2a5e000  ! 1: STWA_I	stwa	%r9, [%r23 + 0x0000] %asi
	.word 0xd2dd6000  ! 2: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r9
	.word 0xd0f70e40  ! 3: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	mov	0x3f0, %r23
	mov	0x70, %r19
	mov	0x78, %r19
	.word 0xd2d70e60  ! 7: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r9
	.word 0xd8b74e80  ! 8: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	.word 0xdc8ec9e0  ! 9: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r14
	.word 0xd29f8e40  ! 10: LDDA_R	ldda	[%r30, %r0] 0x72, %r9
	.word 0xd48c0400  ! 11: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	mov	0x48, %r24
	.word 0xdeaf0e80  ! 13: STBA_R	stba	%r15, [%r28 + %r0] 0x74
	.word 0xdc9e09e0  ! 14: LDDA_R	ldda	[%r24, %r0] 0x4f, %r14
	.word 0x87802025  ! 15: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 16: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd29c0400  ! 17: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	mov	0x58, %r26
	.word 0x87802025  ! 19: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdadc8400  ! 20: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	.word 0xdcae89e0  ! 21: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	.word 0xd6c78e60  ! 22: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r11
	.word 0x87802074  ! 23: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf74e60  ! 24: STXA_R	stxa	%r14, [%r29 + %r0] 0x73
	.word 0x87802074  ! 25: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd694c400  ! 26: LDUHA_R	lduha	[%r19, %r0] 0x20, %r11
	.word 0xdcac2000  ! 27: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 28: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r25
	ta	T_CHANGE_PRIV	! macro
	mov	0x38, %r27
	.word 0xd4f4c400  ! 32: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd28e09e0  ! 33: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r9
	.word 0x87802073  ! 34: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbde000  ! 35: STDA_I	stda	%r14, [%r23 + 0x0000] %asi
	.word 0xd0a689e0  ! 36: STWA_R	stwa	%r8, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 37: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 38: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 39: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4b5c4a0  ! 40: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	.word 0xd88f8e40  ! 41: LDUBA_R	lduba	[%r30, %r0] 0x72, %r12
	.word 0xdcbca000  ! 42: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 43: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc852000  ! 44: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r14
	.word 0xdc9da000  ! 45: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r14
	.word 0xdc8d6000  ! 46: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r14
	mov	0x0, %r24
	.word 0xdcc52000  ! 48: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r14
	.word 0xd4b44400  ! 49: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	.word 0xd0afce80  ! 50: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	.word 0xd8bda000  ! 51: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	.word 0xd8b5a000  ! 52: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	.word 0xd8d5a000  ! 53: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r12
	mov	0x50, %r18
	.word 0xd8df8e60  ! 55: LDXA_R	ldxa	[%r30, %r0] 0x73, %r12
	.word 0xd0956000  ! 56: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r8
	.word 0xde948400  ! 57: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	.word 0x8780204f  ! 58: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2df6000  ! 59: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0xd28cc400  ! 60: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	mov	0x3d8, %r22
	.word 0xd8f40400  ! 62: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xd2872000  ! 63: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	.word 0xd6978e40  ! 64: LDUHA_R	lduha	[%r30, %r0] 0x72, %r11
	.word 0x8780204f  ! 65: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xded5c4a0  ! 66: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r15
	.word 0xdcd4e000  ! 67: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8afce60  ! 69: STBA_R	stba	%r12, [%r31 + %r0] 0x73
	.word 0xd4a4c400  ! 70: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0x87802072  ! 71: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb76000  ! 72: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	mov	0x3f0, %r23
	.word 0xdc972000  ! 74: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	mov	0x68, %r26
	.word 0x87802020  ! 76: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 77: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r16
	.word 0xdc876000  ! 79: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0xdcdf2000  ! 80: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcafa000  ! 81: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xd08544a0  ! 82: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r8
	.word 0xd08d44a0  ! 83: LDUBA_R	lduba	[%r21, %r0] 0x25, %r8
	.word 0xdebf2000  ! 84: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xded7e000  ! 85: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	mov	0x7e0, %r21
	.word 0xdebfe000  ! 87: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xd4a74e80  ! 88: STWA_R	stwa	%r10, [%r29 + %r0] 0x74
	.word 0xd6f76000  ! 89: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6df6000  ! 90: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 91: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4944400  ! 92: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	.word 0xdeb66000  ! 93: STHA_I	stha	%r15, [%r25 + 0x0000] %asi
	.word 0xda9e89e0  ! 94: LDDA_R	ldda	[%r26, %r0] 0x4f, %r13
	.word 0xdcb5c4a0  ! 95: STHA_R	stha	%r14, [%r23 + %r0] 0x25
	.word 0xdcbc4400  ! 96: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0xd8c62000  ! 97: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r12
	.word 0xdaa40400  ! 98: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0xd2a6a000  ! 99: STWA_I	stwa	%r9, [%r26 + 0x0000] %asi
	mov	0x48, %r19
	.word 0xde9c4400  ! 101: LDDA_R	ldda	[%r17, %r0] 0x20, %r15
	mov	0x68, %r16
	.word 0xdaf66000  ! 103: STXA_I	stxa	%r13, [%r25 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xda8e09e0  ! 105: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r13
	.word 0xd0cfce40  ! 106: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r8
	.word 0x87802074  ! 107: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdccf2000  ! 108: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xd8f7ce80  ! 109: STXA_R	stxa	%r12, [%r31 + %r0] 0x74
	.word 0xdadfa000  ! 110: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	mov	0x7f8, %r21
	.word 0xdaa7e000  ! 112: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xdab7a000  ! 113: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdaf7e000  ! 114: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xd4a584a0  ! 115: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	mov	0x70, %r17
	mov	0x7d8, %r21
	.word 0xdaa689e0  ! 118: STWA_R	stwa	%r13, [%r26 + %r0] 0x4f
	mov	0x7f8, %r21
	.word 0xd2c74e80  ! 120: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r9
	mov	0x7c8, %r20
	.word 0xd4cf0e60  ! 122: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r10
	mov	0x3d0, %r22
	.word 0xd2df0e60  ! 124: LDXA_R	ldxa	[%r28, %r0] 0x73, %r9
	.word 0xd0bf6000  ! 125: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd6a4c400  ! 126: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0x87802072  ! 127: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcc46000  ! 128: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r14
	.word 0xdccc2000  ! 129: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r14
	.word 0xdc8c2000  ! 130: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r14
	mov	0x70, %r16
	mov	0x30, %r16
	mov	0x0, %r19
	.word 0xdc84e000  ! 134: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r14
	.word 0xdccca000  ! 135: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	.word 0xdcf4a000  ! 136: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcb46000  ! 137: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xdca42000  ! 138: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xdcf4e000  ! 139: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	mov	0x7d0, %r20
	.word 0xdcd4e000  ! 141: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	.word 0xd8a6c9e0  ! 142: STWA_R	stwa	%r12, [%r27 + %r0] 0x4f
	.word 0xdad74e80  ! 143: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r13
	mov	0x0, %r19
	.word 0xd0f46000  ! 145: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xdedc8400  ! 146: LDXA_R	ldxa	[%r18, %r0] 0x20, %r15
	mov	0x30, %r19
	.word 0xd4de89e0  ! 148: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r10
	.word 0xd28c4400  ! 149: LDUBA_R	lduba	[%r17, %r0] 0x20, %r9
	.word 0xd6ac6000  ! 150: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xd6c46000  ! 151: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r11
	.word 0xd6bc2000  ! 152: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0xd6a42000  ! 153: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xd68ce000  ! 154: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	.word 0xd0cc4400  ! 155: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	.word 0xd48f4e40  ! 156: LDUBA_R	lduba	[%r29, %r0] 0x72, %r10
	.word 0xdc84a000  ! 157: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	.word 0xdc9ca000  ! 158: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r14
	.word 0xdc946000  ! 159: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r14
	.word 0x87802072  ! 160: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcade000  ! 161: STBA_I	stba	%r14, [%r23 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xdca5e000  ! 163: STWA_I	stwa	%r14, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 164: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc8d6000  ! 165: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r14
	.word 0xd8b78e40  ! 166: STHA_R	stha	%r12, [%r30 + %r0] 0x72
	.word 0xd2ac8400  ! 167: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xd895a000  ! 168: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r12
	.word 0xd8f5e000  ! 169: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 170: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8dea000  ! 171: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r12
	.word 0xd88d04a0  ! 172: LDUBA_R	lduba	[%r20, %r0] 0x25, %r12
	.word 0xd8f62000  ! 173: STXA_I	stxa	%r12, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 174: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cf0e60  ! 175: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r11
	.word 0x87802072  ! 176: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcc7a000  ! 177: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xd2bf4e80  ! 178: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	.word 0xd0af8e80  ! 179: STBA_R	stba	%r8, [%r30 + %r0] 0x74
	.word 0xd4d4c400  ! 180: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0xdea76000  ! 181: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xd68f0e40  ! 182: LDUBA_R	lduba	[%r28, %r0] 0x72, %r11
	.word 0xdc8f0e80  ! 183: LDUBA_R	lduba	[%r28, %r0] 0x74, %r14
	.word 0x87802025  ! 184: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb42000  ! 185: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0xdeb4e000  ! 186: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0xdea7ce40  ! 187: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	.word 0xdadce000  ! 188: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xdacc2000  ! 189: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xd8df8e80  ! 190: LDXA_R	ldxa	[%r30, %r0] 0x74, %r12
	.word 0x87802073  ! 191: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bfe000  ! 192: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd8b48400  ! 193: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	mov	0x18, %r19
	mov	0x50, %r25
	.word 0xdcb7e000  ! 196: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xdcce09e0  ! 197: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r14
	.word 0xd2d76000  ! 198: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0xda8c8400  ! 199: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	mov	0x58, %r25
	mov	0x0, %r16
	.word 0x87802020  ! 202: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc852000  ! 203: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r14
	.word 0xdcbd2000  ! 204: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 205: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r25
	.word 0xdca7a000  ! 207: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdedfce40  ! 208: LDXA_R	ldxa	[%r31, %r0] 0x72, %r15
	.word 0xdab7a000  ! 209: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xd4b40400  ! 210: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0xd4cfce60  ! 211: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r10
	.word 0xd2b7ce40  ! 212: STHA_R	stha	%r9, [%r31 + %r0] 0x72
	mov	0x38, %r18
	.word 0xd6a44400  ! 214: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0xdaf7a000  ! 215: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xda9fe000  ! 216: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xdab7a000  ! 217: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xda8f6000  ! 219: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xdaf7e000  ! 220: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	mov	0x68, %r16
	.word 0xd48dc4a0  ! 222: LDUBA_R	lduba	[%r23, %r0] 0x25, %r10
	.word 0xd2a72000  ! 223: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	mov	0x20, %r16
	.word 0xd2d7a000  ! 225: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	mov	0x48, %r19
	.word 0xd2874e60  ! 227: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r9
	.word 0xdcf7a000  ! 228: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 229: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r27
	.word 0xd4de49e0  ! 231: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r10
	.word 0xdecd04a0  ! 232: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r15
	.word 0x87802073  ! 233: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd68544a0  ! 234: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r11
	.word 0x87802020  ! 235: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcd74e60  ! 236: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r14
	.word 0x87802072  ! 237: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d8, %r22
	.word 0xd4b78e40  ! 239: STHA_R	stha	%r10, [%r30 + %r0] 0x72
	.word 0xd0c42000  ! 240: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r8
	.word 0xdca609e0  ! 241: STWA_R	stwa	%r14, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 242: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0846000  ! 243: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0xdabd44a0  ! 244: STDA_R	stda	%r13, [%r21 + %r0] 0x25
	.word 0x87802020  ! 245: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f7a000  ! 246: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	mov	0x50, %r26
	.word 0xd6a76000  ! 248: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6b76000  ! 249: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd6bf6000  ! 250: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 251: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a544a0  ! 252: STWA_R	stwa	%r10, [%r21 + %r0] 0x25
	.word 0xd4cfce80  ! 253: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r10
	.word 0xdacca000  ! 254: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	.word 0xdaa4a000  ! 255: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 256: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 257: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaf76000  ! 258: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 259: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r20
	.word 0xdaf78e80  ! 261: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	.word 0xd4ac0400  ! 262: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xdef70e60  ! 263: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	.word 0x87802074  ! 264: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4cfe000  ! 265: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0xd497e000  ! 266: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	.word 0xdedfce80  ! 267: LDXA_R	ldxa	[%r31, %r0] 0x74, %r15
	.word 0xda976000  ! 268: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	mov	0x70, %r18
	mov	0x7e0, %r21
	.word 0xda876000  ! 271: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	mov	0x10, %r24
	.word 0xdaaf6000  ! 273: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	mov	0x20, %r18
	.word 0x87802020  ! 275: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadc8400  ! 276: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	.word 0xd4dca000  ! 277: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	.word 0xd6af0e40  ! 278: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	.word 0xd8b584a0  ! 279: STHA_R	stha	%r12, [%r22 + %r0] 0x25
	.word 0xd0f46000  ! 280: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 281: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 282: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0876000  ! 283: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0bfa000  ! 284: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 285: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x0, %r27
	mov	0x68, %r24
	.word 0xd0b4e000  ! 288: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xd08c2000  ! 289: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0xd0d4e000  ! 290: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	mov	0x8, %r17
	mov	0x7f0, %r21
	.word 0xd0cc2000  ! 293: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	.word 0xd0cca000  ! 294: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	.word 0xd2f74e60  ! 295: STXA_R	stxa	%r9, [%r29 + %r0] 0x73
	.word 0xdedc2000  ! 296: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r15
	.word 0xdac70e40  ! 297: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r13
	.word 0xdcc5c4a0  ! 298: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r14
	mov	0x78, %r27
	.word 0xd4874e40  ! 300: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r10
	mov	0x50, %r17
	mov	0x8, %r19
	.word 0xdcb42000  ! 303: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xd0a48400  ! 304: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0xdca46000  ! 305: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xdcbc6000  ! 306: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xdcace000  ! 307: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0xd8b649e0  ! 308: STHA_R	stha	%r12, [%r25 + %r0] 0x4f
	.word 0xd484e000  ! 309: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r10
	mov	0x3e0, %r22
	.word 0xd4b42000  ! 311: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	.word 0xda8d84a0  ! 312: LDUBA_R	lduba	[%r22, %r0] 0x25, %r13
	.word 0xd2aca000  ! 313: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0xdc978e60  ! 314: LDUHA_R	lduha	[%r30, %r0] 0x73, %r14
	.word 0xd8df8e80  ! 315: LDXA_R	ldxa	[%r30, %r0] 0x74, %r12
	mov	0x0, %r24
	mov	0x20, %r27
	mov	0x68, %r18
	.word 0xdebf4e80  ! 319: STDA_R	stda	%r15, [%r29 + %r0] 0x74
	mov	0x50, %r17
	.word 0xd88c4400  ! 321: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0xd4cc6000  ! 322: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	.word 0xd484e000  ! 323: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r10
	.word 0xd4bca000  ! 324: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	mov	0x20, %r26
	.word 0xd8dc4400  ! 326: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0xd69c6000  ! 327: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r11
	.word 0xd68ce000  ! 328: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	.word 0x87802072  ! 329: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b62000  ! 330: STHA_I	stha	%r11, [%r24 + 0x0000] %asi
	.word 0xd6b6a000  ! 331: STHA_I	stha	%r11, [%r26 + 0x0000] %asi
	.word 0xd6bea000  ! 332: STDA_I	stda	%r11, [%r26 + 0x0000] %asi
	.word 0xdaa7ce40  ! 333: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	mov	0x48, %r17
	.word 0xdcbf4e60  ! 335: STDA_R	stda	%r14, [%r29 + %r0] 0x73
	.word 0xdea62000  ! 336: STWA_I	stwa	%r15, [%r24 + 0x0000] %asi
	mov	0x58, %r24
	.word 0xde8ee000  ! 338: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r15
	mov	0x70, %r24
	.word 0x87802020  ! 340: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f74e60  ! 341: STXA_R	stxa	%r8, [%r29 + %r0] 0x73
	.word 0xd29e6000  ! 342: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r9
	.word 0x87802020  ! 343: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 344: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 345: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r24
	.word 0xd0b78e80  ! 347: STHA_R	stha	%r8, [%r30 + %r0] 0x74
	mov	0x48, %r19
	.word 0xd6cd84a0  ! 349: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r11
	.word 0xdec40400  ! 350: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xd6cfa000  ! 351: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0xd6d7e000  ! 352: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	mov	0x7d0, %r21
	.word 0x87802072  ! 354: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r17
	.word 0xd4d7ce80  ! 356: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r10
	.word 0xd88fe000  ! 357: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0x87802072  ! 358: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6d44400  ! 359: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r11
	.word 0xd0974e60  ! 360: LDUHA_R	lduha	[%r29, %r0] 0x73, %r8
	.word 0xdcaee000  ! 361: STBA_I	stba	%r14, [%r27 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xdccea000  ! 363: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r14
	.word 0xd08e49e0  ! 364: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r8
	.word 0xdac6e000  ! 365: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r13
	.word 0xdab62000  ! 366: STHA_I	stha	%r13, [%r24 + 0x0000] %asi
	.word 0xd8a70e60  ! 367: STWA_R	stwa	%r12, [%r28 + %r0] 0x73
	.word 0xd0cee000  ! 368: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r8
	mov	0x48, %r26
	.word 0xdac78e60  ! 370: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r13
	.word 0xdcf78e80  ! 371: STXA_R	stxa	%r14, [%r30 + %r0] 0x74
	.word 0xd8cee000  ! 372: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r12
	.word 0xd8c62000  ! 373: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r12
	.word 0x87802074  ! 374: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf544a0  ! 375: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	mov	0x7c8, %r20
	.word 0xda9f4e60  ! 377: LDDA_R	ldda	[%r29, %r0] 0x73, %r13
	.word 0xd8a46000  ! 378: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8b46000  ! 379: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	mov	0x70, %r19
	.word 0x87802072  ! 381: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6a78e40  ! 382: STWA_R	stwa	%r11, [%r30 + %r0] 0x72
	.word 0xd48d2000  ! 383: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0xdec70e60  ! 384: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r15
	.word 0xd8dfce40  ! 385: LDXA_R	ldxa	[%r31, %r0] 0x72, %r12
	.word 0xdea609e0  ! 386: STWA_R	stwa	%r15, [%r24 + %r0] 0x4f
	.word 0xd4cde000  ! 387: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r10
	.word 0xd4acc400  ! 388: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	mov	0x50, %r25
	mov	0x50, %r18
	.word 0xdaafce80  ! 391: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	.word 0xd68d2000  ! 392: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r11
	mov	0x28, %r25
	.word 0x87802072  ! 394: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f8, %r23
	.word 0xd6df6000  ! 396: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6cf6000  ! 397: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd4be09e0  ! 398: STDA_R	stda	%r10, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 399: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd69649e0  ! 400: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r11
	.word 0x87802073  ! 401: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 402: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 403: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r24
	.word 0xd0f7e000  ! 405: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	mov	0x58, %r24
	.word 0xd0df4e80  ! 407: LDXA_R	ldxa	[%r29, %r0] 0x74, %r8
	.word 0xd8f7e000  ! 408: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	mov	0x3f0, %r23
	.word 0x87802020  ! 410: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb584a0  ! 411: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802074  ! 413: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r20
	.word 0xd4cd44a0  ! 415: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r10
	mov	0x7d8, %r22
	mov	0x3f0, %r21
	.word 0xd2a40400  ! 418: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0x87802073  ! 419: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r16
	.word 0x87802025  ! 421: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r19
	.word 0xdecf6000  ! 423: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0x87802020  ! 424: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 425: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef4a000  ! 426: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0xded74e60  ! 427: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r15
	mov	0x68, %r27
	.word 0xd6f46000  ! 429: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0xd6cc0400  ! 430: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r11
	.word 0x87802020  ! 431: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9ec9e0  ! 432: LDDA_R	ldda	[%r27, %r0] 0x4f, %r13
	mov	0x3e8, %r21
	.word 0xdabf0e40  ! 434: STDA_R	stda	%r13, [%r28 + %r0] 0x72
	.word 0xd4a42000  ! 435: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	mov	0x38, %r24
	mov	0x0, %r25
	.word 0xd4d46000  ! 438: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r10
	.word 0xd4cc8400  ! 439: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	.word 0xd6bc0400  ! 440: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xdea70e40  ! 441: STWA_R	stwa	%r15, [%r28 + %r0] 0x72
	.word 0xd8cc6000  ! 442: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r12
	mov	0x3c8, %r23
	.word 0x87802074  ! 444: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd89f0e80  ! 445: LDDA_R	ldda	[%r28, %r0] 0x74, %r12
	.word 0xd8d44400  ! 446: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	.word 0xdca78e40  ! 447: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	mov	0x7c0, %r23
	.word 0x8780204f  ! 449: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xded544a0  ! 450: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r15
	.word 0xd4a44400  ! 451: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xd697a000  ! 452: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0xd4b544a0  ! 453: STHA_R	stha	%r10, [%r21 + %r0] 0x25
	.word 0xd8bcc400  ! 454: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	mov	0x58, %r18
	.word 0xd697e000  ! 456: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	mov	0x70, %r25
	.word 0xd6a7e000  ! 458: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6a7a000  ! 459: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0xdeaf4e60  ! 461: STBA_R	stba	%r15, [%r29 + %r0] 0x73
	.word 0xd8af0e60  ! 462: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	.word 0xda9544a0  ! 463: LDUHA_R	lduha	[%r21, %r0] 0x25, %r13
	.word 0xde8fce40  ! 464: LDUBA_R	lduba	[%r31, %r0] 0x72, %r15
	.word 0xd2d649e0  ! 465: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r9
	.word 0xd8ad84a0  ! 466: STBA_R	stba	%r12, [%r22 + %r0] 0x25
	.word 0xdede09e0  ! 467: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r15
	.word 0x8780204f  ! 468: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 469: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde844400  ! 470: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	mov	0x30, %r19
	.word 0xd4b7ce80  ! 472: STHA_R	stha	%r10, [%r31 + %r0] 0x74
	.word 0x87802072  ! 473: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8948400  ! 474: LDUHA_R	lduha	[%r18, %r0] 0x20, %r12
	mov	0x3e8, %r22
	.word 0xd4a7a000  ! 476: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4bfa000  ! 477: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd4c78e60  ! 478: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r10
	.word 0x87802073  ! 479: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r24
	.word 0xd69f2000  ! 481: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xdeb4c400  ! 482: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0x87802073  ! 483: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb74e40  ! 484: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	.word 0xd8842000  ! 485: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	.word 0xd8a4a000  ! 486: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd88f0e60  ! 487: LDUBA_R	lduba	[%r28, %r0] 0x73, %r12
	mov	0x18, %r27
	.word 0xdcbe09e0  ! 489: STDA_R	stda	%r14, [%r24 + %r0] 0x4f
	.word 0xdaa78e40  ! 490: STWA_R	stwa	%r13, [%r30 + %r0] 0x72
	.word 0x8780204f  ! 491: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bd44a0  ! 492: STDA_R	stda	%r10, [%r21 + %r0] 0x25
	.word 0x87802074  ! 493: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8a6e000  ! 494: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	mov	0x10, %r17
	.word 0xdc9689e0  ! 496: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r14
	.word 0xd0df8e80  ! 497: LDXA_R	ldxa	[%r30, %r0] 0x74, %r8
	.word 0xdcb70e60  ! 498: STHA_R	stha	%r14, [%r28 + %r0] 0x73
	mov	0x3e8, %r23
	mov	0x7e0, %r20
	mov	0x7e8, %r20
	.word 0xd2c62000  ! 502: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r9
	.word 0xd2a6a000  ! 503: STWA_I	stwa	%r9, [%r26 + 0x0000] %asi
	mov	0x58, %r17
	mov	0x3c8, %r20
	.word 0x87802074  ! 506: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdea74e80  ! 507: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	.word 0xdebfe000  ! 508: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xdebf6000  ! 509: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xde87a000  ! 510: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xd2cfce80  ! 511: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r9
	.word 0xdaaf6000  ! 512: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xdaaf2000  ! 513: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0xdaa7e000  ! 515: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0x87802020  ! 517: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x10, %r16
	.word 0xd0f7ce60  ! 520: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	.word 0xdcdf6000  ! 521: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xd4b649e0  ! 522: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	.word 0xd884c400  ! 523: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	mov	0x3f0, %r23
	.word 0xd4c70e80  ! 525: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r10
	.word 0xd0840400  ! 526: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	mov	0x60, %r26
	mov	0x50, %r26
	mov	0x38, %r26
	.word 0xdeb7a000  ! 530: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xdebf2000  ! 531: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 532: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf4c400  ! 533: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0x87802072  ! 534: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f72000  ! 535: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	mov	0x40, %r18
	.word 0xd29f6000  ! 537: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0x87802072  ! 538: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c8, %r23
	mov	0x30, %r19
	.word 0xd2f7a000  ! 541: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xd0a78e80  ! 542: STWA_R	stwa	%r8, [%r30 + %r0] 0x74
	.word 0xdcaf4e40  ! 543: STBA_R	stba	%r14, [%r29 + %r0] 0x72
	.word 0x87802073  ! 544: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 545: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 546: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2ade000  ! 547: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	mov	0x20, %r24
	.word 0xd2dde000  ! 549: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 550: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd08689e0  ! 551: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r8
	.word 0xda978e40  ! 552: LDUHA_R	lduha	[%r30, %r0] 0x72, %r13
	.word 0x87802072  ! 553: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4bf8e40  ! 554: STDA_R	stda	%r10, [%r30 + %r0] 0x72
	.word 0xdc9cc400  ! 555: LDDA_R	ldda	[%r19, %r0] 0x20, %r14
	mov	0x70, %r26
	.word 0xd0a5e000  ! 557: STWA_I	stwa	%r8, [%r23 + 0x0000] %asi
	.word 0xd0cd6000  ! 558: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r8
	mov	0x0, %r25
	.word 0x87802020  ! 560: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r19
	mov	0x7d0, %r22
	.word 0x8780204f  ! 563: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa4c400  ! 564: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0xd6bc2000  ! 565: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0xd6b5c4a0  ! 567: STHA_R	stha	%r11, [%r23 + %r0] 0x25
	.word 0xd284e000  ! 568: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r9
	mov	0x7d0, %r22
	mov	0x7e0, %r20
	.word 0xd2846000  ! 571: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r9
	.word 0xd2842000  ! 572: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r9
	mov	0x3c8, %r20
	.word 0xd0dc8400  ! 574: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0xd48c2000  ! 575: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r10
	mov	0x0, %r19
	.word 0x87802073  ! 577: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2af4e40  ! 578: STBA_R	stba	%r9, [%r29 + %r0] 0x72
	.word 0xd6f70e80  ! 579: STXA_R	stxa	%r11, [%r28 + %r0] 0x74
	.word 0xde8fce80  ! 580: LDUBA_R	lduba	[%r31, %r0] 0x74, %r15
	mov	0x50, %r26
	.word 0xd0cd04a0  ! 582: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r8
	.word 0xdebce000  ! 583: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	mov	0x50, %r19
	.word 0xd8f44400  ! 585: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xdadc2000  ! 586: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r13
	.word 0xdaf4a000  ! 587: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0xdaac2000  ! 588: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	mov	0x60, %r19
	mov	0x68, %r17
	.word 0xdacc2000  ! 591: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xd2dfce80  ! 592: LDXA_R	ldxa	[%r31, %r0] 0x74, %r9
	.word 0xdcd4c400  ! 593: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	.word 0xd6b46000  ! 594: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 595: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 596: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6aca000  ! 597: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 598: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 599: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f0, %r21
	.word 0xd6b7e000  ! 601: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd68f6000  ! 602: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xd2ac0400  ! 603: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0x87802020  ! 604: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeace000  ! 605: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xdea4a000  ! 606: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xd0cc8400  ! 607: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0x87802020  ! 608: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 609: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9d2000  ! 610: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r13
	.word 0xd0afce60  ! 611: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	.word 0xd4f5e000  ! 612: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	.word 0xd29609e0  ! 613: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r9
	.word 0x87802020  ! 614: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c72000  ! 615: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6f7a000  ! 616: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xdcbc8400  ! 617: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0x87802025  ! 618: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c8, %r20
	.word 0xdadc8400  ! 620: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	mov	0x8, %r19
	.word 0xdaf7a000  ! 622: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xda9f2000  ! 623: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xdebfce60  ! 624: STDA_R	stda	%r15, [%r31 + %r0] 0x73
	.word 0x87802020  ! 625: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ae6000  ! 626: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0x8780204f  ! 627: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b46000  ! 628: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xd4f4e000  ! 629: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	mov	0x30, %r18
	mov	0x7c0, %r20
	.word 0x87802073  ! 632: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef584a0  ! 633: STXA_R	stxa	%r15, [%r22 + %r0] 0x25
	.word 0x87802072  ! 634: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3e0, %r23
	.word 0xd8f4a000  ! 636: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8dcc400  ! 637: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	.word 0xde9ca000  ! 638: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	.word 0x87802073  ! 639: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb42000  ! 640: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 641: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2df4e60  ! 642: LDXA_R	ldxa	[%r29, %r0] 0x73, %r9
	.word 0xd8dc4400  ! 643: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0xd8bc8400  ! 644: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	mov	0x38, %r26
	.word 0xd0afa000  ! 646: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd6b74e80  ! 647: STHA_R	stha	%r11, [%r29 + %r0] 0x74
	.word 0xdea649e0  ! 648: STWA_R	stwa	%r15, [%r25 + %r0] 0x4f
	.word 0xd8df6000  ! 649: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8f76000  ! 650: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd4b7ce40  ! 651: STHA_R	stha	%r10, [%r31 + %r0] 0x72
	.word 0xdef48400  ! 652: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xd88584a0  ! 653: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r12
	.word 0xd0af0e80  ! 654: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	.word 0xdc9cc400  ! 655: LDDA_R	ldda	[%r19, %r0] 0x20, %r14
	.word 0x87802074  ! 656: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0bf6000  ! 657: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 658: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdead84a0  ! 659: STBA_R	stba	%r15, [%r22 + %r0] 0x25
	.word 0xd8f70e80  ! 660: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	.word 0xdab7e000  ! 661: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	mov	0x78, %r25
	.word 0xd2f48400  ! 663: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0xded5c4a0  ! 664: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r15
	mov	0x18, %r26
	.word 0xdaa74e60  ! 666: STWA_R	stwa	%r13, [%r29 + %r0] 0x73
	.word 0xd4df8e60  ! 667: LDXA_R	ldxa	[%r30, %r0] 0x73, %r10
	mov	0x20, %r18
	.word 0xdeb76000  ! 669: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xde972000  ! 670: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0xdef72000  ! 671: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	mov	0x28, %r17
	mov	0x18, %r27
	.word 0xd6cf8e40  ! 674: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r11
	.word 0x87802020  ! 675: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r23
	.word 0xd4946000  ! 677: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r10
	mov	0x18, %r18
	.word 0xd8bf0e40  ! 679: STDA_R	stda	%r12, [%r28 + %r0] 0x72
	.word 0xd89ca000  ! 680: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r12
	.word 0x87802072  ! 681: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8f4c400  ! 682: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	mov	0x30, %r19
	.word 0x87802074  ! 684: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b6a000  ! 685: STHA_I	stha	%r8, [%r26 + 0x0000] %asi
	.word 0xdea649e0  ! 686: STWA_R	stwa	%r15, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 687: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdacc4400  ! 688: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	.word 0x87802074  ! 689: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeada000  ! 690: STBA_I	stba	%r15, [%r22 + 0x0000] %asi
	.word 0xdcac0400  ! 691: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xd4ac8400  ! 692: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0xdca78e80  ! 693: STWA_R	stwa	%r14, [%r30 + %r0] 0x74
	mov	0x3f0, %r23
	.word 0xd0856000  ! 695: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r8
	.word 0xd0f52000  ! 696: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	.word 0x87802025  ! 697: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f40400  ! 698: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	.word 0xd69c4400  ! 699: LDDA_R	ldda	[%r17, %r0] 0x20, %r11
	.word 0xd0874e80  ! 700: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r8
	.word 0xd69f4e40  ! 701: LDDA_R	ldda	[%r29, %r0] 0x72, %r11
	.word 0xda9e09e0  ! 702: LDDA_R	ldda	[%r24, %r0] 0x4f, %r13
	.word 0x87802074  ! 703: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabd44a0  ! 704: STDA_R	stda	%r13, [%r21 + %r0] 0x25
	.word 0x87802072  ! 705: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4d40400  ! 706: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	.word 0xd6c78e40  ! 707: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	mov	0x60, %r18
	mov	0x50, %r24
	.word 0xdec42000  ! 710: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	mov	0x3f8, %r23
	.word 0xde946000  ! 712: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r15
	.word 0xdea4a000  ! 713: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xdabc0400  ! 714: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	mov	0x20, %r18
	.word 0xd2f42000  ! 716: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0xd2f4a000  ! 717: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	mov	0x20, %r16
	.word 0x87802072  ! 719: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2be6000  ! 720: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	.word 0xd2a66000  ! 721: STWA_I	stwa	%r9, [%r25 + 0x0000] %asi
	.word 0xd2f66000  ! 722: STXA_I	stxa	%r9, [%r25 + 0x0000] %asi
	.word 0x8780204f  ! 723: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4970e40  ! 724: LDUHA_R	lduha	[%r28, %r0] 0x72, %r10
	.word 0xd4bdc4a0  ! 725: STDA_R	stda	%r10, [%r23 + %r0] 0x25
	.word 0xd6cfce80  ! 726: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r11
	.word 0xdebfa000  ! 727: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 728: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r27
	.word 0x87802073  ! 730: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2be89e0  ! 731: STDA_R	stda	%r9, [%r26 + %r0] 0x4f
	mov	0x3f0, %r20
	.word 0xdede2000  ! 733: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r15
	.word 0xd89ec9e0  ! 734: LDDA_R	ldda	[%r27, %r0] 0x4f, %r12
	.word 0xd8bc4400  ! 735: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xd6d7ce60  ! 736: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r11
	.word 0xd6bee000  ! 737: STDA_I	stda	%r11, [%r27 + 0x0000] %asi
	.word 0x87802072  ! 738: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c8, %r23
	mov	0x0, %r26
	ta	T_CHANGE_PRIV	! macro
	mov	0x7c8, %r22
	.word 0xd6dc6000  ! 743: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r11
	mov	0x7e0, %r23
	mov	0x3c0, %r22
	.word 0xd6b4e000  ! 746: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xd2bfce40  ! 747: STDA_R	stda	%r9, [%r31 + %r0] 0x72
	mov	0x7c0, %r20
	.word 0xd2b42000  ! 749: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0xd2ac2000  ! 750: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xdc9d84a0  ! 751: LDDA_R	ldda	[%r22, %r0] 0x25, %r14
	.word 0xd89ec9e0  ! 752: LDDA_R	ldda	[%r27, %r0] 0x4f, %r12
	mov	0x10, %r27
	.word 0x87802073  ! 754: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 755: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8b4c400  ! 756: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	mov	0x0, %r24
	mov	0x7d0, %r22
	.word 0xd2df2000  ! 759: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2bf6000  ! 760: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 761: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a42000  ! 762: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0x87802020  ! 764: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f46000  ! 765: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd28649e0  ! 766: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r9
	.word 0xd4c4e000  ! 767: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r10
	.word 0xd4a4a000  ! 768: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	mov	0x78, %r18
	.word 0x87802020  ! 770: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f5e000  ! 771: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	.word 0xdaf689e0  ! 772: STXA_R	stxa	%r13, [%r26 + %r0] 0x4f
	.word 0xd6d70e80  ! 773: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r11
	.word 0xd0f70e80  ! 774: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0xd8a52000  ! 775: STWA_I	stwa	%r12, [%r20 + 0x0000] %asi
	mov	0x8, %r26
	mov	0x48, %r18
	mov	0x28, %r25
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802020  ! 780: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd8bfe000  ! 782: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 783: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r16
	mov	0x8, %r25
	.word 0xd6f78e40  ! 786: STXA_R	stxa	%r11, [%r30 + %r0] 0x72
	mov	0x70, %r17
	.word 0x8780204f  ! 788: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6be89e0  ! 789: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	.word 0xd0872000  ! 790: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xdab609e0  ! 791: STHA_R	stha	%r13, [%r24 + %r0] 0x4f
	mov	0x0, %r25
	.word 0xd29fe000  ! 793: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	mov	0x7d0, %r23
	.word 0xd8ac0400  ! 795: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xda8f6000  ! 796: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xdab7e000  ! 797: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xdaf72000  ! 798: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdac7e000  ! 799: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0x87802020  ! 800: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r19
	mov	0x3e8, %r23
	.word 0x87802020  ! 803: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9f2000  ! 804: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xdab72000  ! 805: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdac72000  ! 806: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0xdca78e60  ! 807: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	mov	0x20, %r16
	mov	0x8, %r18
	.word 0xd6afe000  ! 810: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xd6a76000  ! 812: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6f7a000  ! 813: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd48fce40  ! 814: LDUBA_R	lduba	[%r31, %r0] 0x72, %r10
	.word 0x87802073  ! 815: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e0, %r22
	.word 0xd6f4c400  ! 817: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0xd4f76000  ! 818: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd68c0400  ! 819: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	mov	0x58, %r16
	.word 0x87802074  ! 821: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4dca000  ! 822: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	.word 0xd08f8e80  ! 823: LDUBA_R	lduba	[%r30, %r0] 0x74, %r8
	mov	0x3f0, %r22
	mov	0x3c8, %r23
	.word 0xd0a4e000  ! 826: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 827: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r27
	.word 0xd6d7ce60  ! 829: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r11
	.word 0xd8f44400  ! 830: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0x87802020  ! 831: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 832: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcd5c4a0  ! 833: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r14
	.word 0xd6aec9e0  ! 834: STBA_R	stba	%r11, [%r27 + %r0] 0x4f
	mov	0x0, %r19
	.word 0xd28f0e40  ! 836: LDUBA_R	lduba	[%r28, %r0] 0x72, %r9
	.word 0xd0874e80  ! 837: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r8
	.word 0xdcf7a000  ! 838: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x68, %r27
	mov	0x50, %r27
	.word 0xdccfa000  ! 841: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xdca76000  ! 842: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcbfe000  ! 843: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 844: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2cf8e40  ! 846: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r9
	.word 0x8780204f  ! 847: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdedfce80  ! 848: LDXA_R	ldxa	[%r31, %r0] 0x74, %r15
	.word 0x87802020  ! 849: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4afe000  ! 850: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd4a72000  ! 851: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 852: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e8, %r21
	.word 0xd4f76000  ! 854: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd8d6c9e0  ! 855: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r12
	.word 0xd09c8400  ! 856: LDDA_R	ldda	[%r18, %r0] 0x20, %r8
	.word 0xdca7e000  ! 857: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 858: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r17
	mov	0x50, %r26
	.word 0xd0f5c4a0  ! 861: STXA_R	stxa	%r8, [%r23 + %r0] 0x25
	.word 0xd8bf2000  ! 862: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xdade09e0  ! 863: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r13
	.word 0xd6cf8e40  ! 864: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r11
	.word 0xd2c72000  ! 865: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2cfe000  ! 866: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	mov	0x38, %r27
	.word 0xd8ac0400  ! 868: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	mov	0x3f8, %r22
	.word 0x87802020  ! 870: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 871: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f8, %r20
	mov	0x68, %r18
	.word 0xd6bcc400  ! 874: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0xd6b78e80  ! 875: STHA_R	stha	%r11, [%r30 + %r0] 0x74
	.word 0x87802020  ! 876: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedc6000  ! 877: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r15
	.word 0xde8c6000  ! 878: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0xd4a7ce60  ! 879: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	mov	0x78, %r16
	mov	0x20, %r17
	.word 0xd2bc6000  ! 882: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0xd0c78e40  ! 883: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r8
	.word 0x87802073  ! 884: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 885: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r16
	.word 0x87802020  ! 887: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ac6000  ! 888: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd4d78e40  ! 889: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r10
	.word 0xdacc2000  ! 890: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	mov	0x3d0, %r20
	mov	0x38, %r26
	.word 0x8780204f  ! 893: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabfa000  ! 894: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdaaf0e60  ! 895: STBA_R	stba	%r13, [%r28 + %r0] 0x73
	mov	0x0, %r18
	.word 0xd8d48400  ! 897: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0xd2872000  ! 898: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	.word 0xdea40400  ! 899: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xd28fa000  ! 900: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	mov	0x78, %r19
	.word 0x87802073  ! 902: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd8ae49e0  ! 904: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 905: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2afa000  ! 906: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xd2b72000  ! 907: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 908: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2872000  ! 909: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2cf6000  ! 910: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2f7e000  ! 912: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd6ac8400  ! 913: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	mov	0x40, %r24
	.word 0x87802072  ! 915: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeacc400  ! 916: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xd49fce60  ! 917: LDDA_R	ldda	[%r31, %r0] 0x73, %r10
	.word 0x87802020  ! 918: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r24
	.word 0x87802020  ! 920: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r25
	.word 0xde8fa000  ! 922: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0xd486c9e0  ! 923: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r10
	mov	0x78, %r17
	mov	0x3f0, %r21
	.word 0xdef72000  ! 926: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xdedfe000  ! 927: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xde8fa000  ! 928: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0xde9fe000  ! 929: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	mov	0x20, %r24
	.word 0xd2af0e80  ! 931: STBA_R	stba	%r9, [%r28 + %r0] 0x74
	.word 0xd49504a0  ! 932: LDUHA_R	lduha	[%r20, %r0] 0x25, %r10
	.word 0x87802074  ! 933: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd88584a0  ! 934: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r12
	.word 0xdeb7e000  ! 935: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 936: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 937: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8e09e0  ! 938: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r15
	mov	0x38, %r26
	mov	0x10, %r17
	mov	0x38, %r18
	mov	0x3d0, %r21
	.word 0xd0bf4e80  ! 943: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	.word 0xd8a7e000  ! 944: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd0ac4400  ! 945: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0xd4cd04a0  ! 946: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r10
	mov	0x20, %r27
	.word 0xdcf72000  ! 948: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdca7ce80  ! 949: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	.word 0x87802025  ! 950: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4b5c4a0  ! 951: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	.word 0xd6ae09e0  ! 952: STBA_R	stba	%r11, [%r24 + %r0] 0x4f
	mov	0x3e0, %r21
	.word 0xd49fce60  ! 954: LDDA_R	ldda	[%r31, %r0] 0x73, %r10
	.word 0xd88de000  ! 955: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r12
	.word 0xde848400  ! 956: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	.word 0xd0dde000  ! 957: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r8
	.word 0xd0d609e0  ! 958: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r8
	.word 0x87802020  ! 959: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccf0e80  ! 960: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r14
	.word 0xdeb72000  ! 961: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 962: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8c6000  ! 963: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0x87802020  ! 964: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb504a0  ! 965: STHA_R	stha	%r14, [%r20 + %r0] 0x25
	.word 0xd0afa000  ! 966: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd0cf2000  ! 967: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0x87802020  ! 968: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad74e80  ! 969: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r13
	.word 0xd2bea000  ! 970: STDA_I	stda	%r9, [%r26 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xd0f78e60  ! 972: STXA_R	stxa	%r8, [%r30 + %r0] 0x73
	.word 0xd49ee000  ! 973: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r10
	.word 0xd4b62000  ! 974: STHA_I	stha	%r10, [%r24 + 0x0000] %asi
	.word 0xd297ce40  ! 975: LDUHA_R	lduha	[%r31, %r0] 0x72, %r9
	.word 0xda9e6000  ! 976: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r13
	.word 0xdaaea000  ! 977: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	.word 0x87802072  ! 978: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 979: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r25
	.word 0x87802020  ! 981: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8af4e60  ! 982: STBA_R	stba	%r12, [%r29 + %r0] 0x73
	.word 0xdabce000  ! 983: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0xdaac2000  ! 984: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	mov	0x60, %r18
	mov	0x38, %r19
	.word 0xd6ce09e0  ! 987: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r11
	.word 0x87802073  ! 988: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdabca000  ! 989: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 990: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab7e000  ! 991: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	mov	0x78, %r27
	.word 0xd08dc4a0  ! 993: LDUBA_R	lduba	[%r23, %r0] 0x25, %r8
	mov	0x7d8, %r23
	mov	0x3e0, %r22
	.word 0x87802020  ! 996: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f72000  ! 997: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xd2a4c400  ! 998: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	mov	0x3c8, %r21
	.word 0xdeb74e40  ! 1000: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	.word 0x87802074  ! 1001: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a7ce80  ! 1002: STWA_R	stwa	%r10, [%r31 + %r0] 0x74
	.word 0xd2dc4400  ! 1003: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	mov	0x7d0, %r20
	.word 0xd69584a0  ! 1005: LDUHA_R	lduha	[%r22, %r0] 0x25, %r11
	mov	0x38, %r19
	.word 0xd49f0e80  ! 1007: LDDA_R	ldda	[%r28, %r0] 0x74, %r10
	.word 0xd8c76000  ! 1008: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	mov	0x18, %r27
	.word 0xd8f76000  ! 1010: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xd0bc4400  ! 1012: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0x87802073  ! 1013: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b7ce60  ! 1014: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	.word 0xd28689e0  ! 1015: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r9
	.word 0xd0f544a0  ! 1016: STXA_R	stxa	%r8, [%r21 + %r0] 0x25
	.word 0xd0f7ce60  ! 1017: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	.word 0xdcf40400  ! 1018: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xdcc74e40  ! 1019: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r14
	.word 0xdec4e000  ! 1020: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	.word 0xdeb46000  ! 1021: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0xdeb46000  ! 1022: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 1023: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdef7e000  ! 1024: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xd2cc0400  ! 1025: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r9
	.word 0xdcb584a0  ! 1026: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	.word 0xd2c72000  ! 1027: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2af2000  ! 1028: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd28f8e40  ! 1029: LDUBA_R	lduba	[%r30, %r0] 0x72, %r9
	mov	0x7d0, %r21
	.word 0xd0b76000  ! 1031: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xdabd84a0  ! 1032: STDA_R	stda	%r13, [%r22 + %r0] 0x25
	.word 0xdcaf2000  ! 1033: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xd8de49e0  ! 1034: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r12
	.word 0xdccfa000  ! 1035: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	mov	0x50, %r17
	.word 0xd8adc4a0  ! 1037: STBA_R	stba	%r12, [%r23 + %r0] 0x25
	.word 0xdc874e40  ! 1038: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r14
	.word 0xd8f44400  ! 1039: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	mov	0x60, %r16
	mov	0x70, %r27
	.word 0xd4940400  ! 1042: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	.word 0x87802025  ! 1043: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d8, %r23
	.word 0xd68da000  ! 1045: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r11
	.word 0xd6bde000  ! 1046: STDA_I	stda	%r11, [%r23 + 0x0000] %asi
	.word 0xd6f5e000  ! 1047: STXA_I	stxa	%r11, [%r23 + 0x0000] %asi
	mov	0x3e8, %r23
	.word 0xdab5c4a0  ! 1049: STHA_R	stha	%r13, [%r23 + %r0] 0x25
	.word 0xd6b78e60  ! 1050: STHA_R	stha	%r11, [%r30 + %r0] 0x73
	.word 0xd68da000  ! 1051: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r11
	.word 0xd6c56000  ! 1052: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r11
	.word 0xda87ce80  ! 1053: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r13
	mov	0x8, %r24
	.word 0xd6a52000  ! 1055: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	.word 0xdacd84a0  ! 1056: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r13
	.word 0xd0cd6000  ! 1057: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r8
	.word 0xd294c400  ! 1058: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	.word 0xd2d52000  ! 1059: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r9
	.word 0xd295a000  ! 1060: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1061: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1062: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4974e80  ! 1063: LDUHA_R	lduha	[%r29, %r0] 0x74, %r10
	mov	0x3c0, %r21
	.word 0x87802020  ! 1065: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r19
	.word 0x8780204f  ! 1067: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa504a0  ! 1068: STWA_R	stwa	%r13, [%r20 + %r0] 0x25
	mov	0x70, %r16
	.word 0x87802020  ! 1070: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1071: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r17
	.word 0xdcf7ce80  ! 1073: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	.word 0x87802020  ! 1074: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r26
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd88fe000  ! 1077: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8c76000  ! 1078: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	.word 0xdea70e40  ! 1079: STWA_R	stwa	%r15, [%r28 + %r0] 0x72
	.word 0x87802020  ! 1080: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b40400  ! 1081: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	mov	0x8, %r25
	mov	0x3d0, %r20
	.word 0xd09544a0  ! 1084: LDUHA_R	lduha	[%r21, %r0] 0x25, %r8
	.word 0xdebde000  ! 1085: STDA_I	stda	%r15, [%r23 + 0x0000] %asi
	.word 0xd0afce80  ! 1086: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	.word 0xdcf544a0  ! 1087: STXA_R	stxa	%r14, [%r21 + %r0] 0x25
	mov	0x10, %r25
	.word 0xdebfce80  ! 1089: STDA_R	stda	%r15, [%r31 + %r0] 0x74
	.word 0xd4b504a0  ! 1090: STHA_R	stha	%r10, [%r20 + %r0] 0x25
	mov	0x10, %r19
	.word 0xd6a5e000  ! 1092: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	mov	0x10, %r16
	.word 0xd6bd6000  ! 1094: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	mov	0x3d0, %r23
	.word 0xd8ac8400  ! 1096: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0x87802073  ! 1097: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d0, %r21
	mov	0x3f0, %r21
	.word 0xda8e49e0  ! 1100: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r13
	.word 0xda9c4400  ! 1101: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	.word 0xd4bea000  ! 1102: STDA_I	stda	%r10, [%r26 + 0x0000] %asi
	.word 0xd8b40400  ! 1103: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xdcd6a000  ! 1104: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r14
	.word 0xdcf6a000  ! 1105: STXA_I	stxa	%r14, [%r26 + 0x0000] %asi
	mov	0x7e0, %r21
	.word 0x87802073  ! 1107: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2a70e40  ! 1108: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	.word 0xde97a000  ! 1109: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	.word 0xde9fe000  ! 1110: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	mov	0x3e0, %r23
	.word 0xde97a000  ! 1112: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	.word 0xd6870e60  ! 1113: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r11
	.word 0xd6a7a000  ! 1114: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6a72000  ! 1115: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	mov	0x70, %r16
	mov	0x38, %r17
	.word 0xd6848400  ! 1118: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	.word 0xdcc78e40  ! 1119: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r14
	.word 0xd6f6c9e0  ! 1120: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	.word 0xdcafe000  ! 1121: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xdc87e000  ! 1123: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xdeaf0e40  ! 1124: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	.word 0xdaa48400  ! 1125: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0xd0adc4a0  ! 1126: STBA_R	stba	%r8, [%r23 + %r0] 0x25
	.word 0xd4ae09e0  ! 1127: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0xdcbfe000  ! 1128: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdc9f6000  ! 1129: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xd8bc0400  ! 1130: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xdcadc4a0  ! 1131: STBA_R	stba	%r14, [%r23 + %r0] 0x25
	mov	0x7c0, %r21
	.word 0xdcb7ce40  ! 1133: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	mov	0x3f8, %r20
	.word 0xdc972000  ! 1135: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	.word 0xd8b544a0  ! 1136: STHA_R	stha	%r12, [%r21 + %r0] 0x25
	.word 0xd0af6000  ! 1137: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 1138: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 1139: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r27
	mov	0x48, %r26
	.word 0xd087a000  ! 1142: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	mov	0x60, %r24
	mov	0x58, %r27
	.word 0x8780204f  ! 1145: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c8, %r22
	.word 0xd0c7a000  ! 1147: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	mov	0x7d8, %r20
	.word 0xd0a7a000  ! 1149: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd087e000  ! 1150: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0bfce80  ! 1151: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	.word 0xd4b78e60  ! 1152: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	.word 0xde87e000  ! 1153: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	mov	0x58, %r18
	.word 0xd4bf0e80  ! 1155: STDA_R	stda	%r10, [%r28 + %r0] 0x74
	.word 0xd097e000  ! 1156: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xd2b7ce40  ! 1157: STHA_R	stha	%r9, [%r31 + %r0] 0x72
	.word 0xd28f2000  ! 1158: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	mov	0x58, %r24
	mov	0x7c0, %r22
	.word 0xd2b7e000  ! 1161: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 1162: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef504a0  ! 1163: STXA_R	stxa	%r15, [%r20 + %r0] 0x25
	mov	0x60, %r27
	.word 0x8780204f  ! 1165: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f72000  ! 1166: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 1167: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f76000  ! 1168: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd8afce80  ! 1169: STBA_R	stba	%r12, [%r31 + %r0] 0x74
	mov	0x38, %r24
	.word 0xda876000  ! 1171: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0xda87a000  ! 1172: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	mov	0x70, %r18
	mov	0x7e8, %r22
	mov	0x78, %r27
	.word 0xda8fe000  ! 1176: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xdabfa000  ! 1177: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xda9fe000  ! 1178: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xdac7e000  ! 1179: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xd4ae09e0  ! 1180: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	mov	0x40, %r19
	.word 0x87802025  ! 1182: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad5a000  ! 1183: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r13
	mov	0x0, %r24
	.word 0x87802072  ! 1185: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r25
	.word 0x8780204f  ! 1187: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1188: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r26
	mov	0x7d8, %r22
	.word 0x8780204f  ! 1191: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r18
	mov	0x68, %r16
	.word 0xda8ce000  ! 1194: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	.word 0x87802072  ! 1195: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f0, %r23
	mov	0x3e8, %r21
	mov	0x3d0, %r20
	.word 0xdea78e80  ! 1199: STWA_R	stwa	%r15, [%r30 + %r0] 0x74
	mov	0x7e8, %r20
	.word 0xd297ce60  ! 1201: LDUHA_R	lduha	[%r31, %r0] 0x73, %r9
	mov	0x20, %r19
	.word 0xd2b649e0  ! 1203: STHA_R	stha	%r9, [%r25 + %r0] 0x4f
	.word 0xdaac8400  ! 1204: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 1205: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b78e80  ! 1206: STHA_R	stha	%r10, [%r30 + %r0] 0x74
	mov	0x28, %r26
	.word 0xd2b7e000  ! 1208: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2f7a000  ! 1209: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xd0a70e80  ! 1210: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0xdaf72000  ! 1211: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 1212: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda9e2000  ! 1213: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r13
	.word 0xdadea000  ! 1214: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r13
	.word 0xd48f8e40  ! 1215: LDUBA_R	lduba	[%r30, %r0] 0x72, %r10
	.word 0xdad609e0  ! 1216: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r13
	.word 0xdcc6a000  ! 1217: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r14
	.word 0x87802020  ! 1218: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bc0400  ! 1219: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	mov	0x0, %r16
	.word 0x87802025  ! 1221: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r27
	.word 0xdc978e80  ! 1223: LDUHA_R	lduha	[%r30, %r0] 0x74, %r14
	.word 0x8780204f  ! 1224: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcb7a000  ! 1225: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1226: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28c8400  ! 1227: LDUBA_R	lduba	[%r18, %r0] 0x20, %r9
	.word 0xdecf8e80  ! 1228: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r15
	mov	0x3d0, %r20
	.word 0x87802025  ! 1230: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c0, %r21
	mov	0x7c8, %r20
	.word 0xdca4a000  ! 1233: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	mov	0x40, %r24
	mov	0x3d8, %r21
	mov	0x7d0, %r21
	.word 0xd08649e0  ! 1237: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r8
	mov	0x78, %r18
	mov	0x3f0, %r20
	.word 0xd49544a0  ! 1240: LDUHA_R	lduha	[%r21, %r0] 0x25, %r10
	.word 0xd0be49e0  ! 1241: STDA_R	stda	%r8, [%r25 + %r0] 0x4f
	.word 0xda84c400  ! 1242: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r13
	.word 0xd89c4400  ! 1243: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	.word 0xd6b42000  ! 1244: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0xdef689e0  ! 1245: STXA_R	stxa	%r15, [%r26 + %r0] 0x4f
	.word 0xd6dc2000  ! 1246: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r11
	mov	0x10, %r26
	.word 0xd8af4e60  ! 1248: STBA_R	stba	%r12, [%r29 + %r0] 0x73
	.word 0xd29f8e40  ! 1249: LDDA_R	ldda	[%r30, %r0] 0x72, %r9
	.word 0xdcb4a000  ! 1250: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	mov	0x10, %r26
	mov	0x78, %r19
	mov	0x0, %r19
	.word 0xdc874e80  ! 1254: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r14
	mov	0x68, %r27
	.word 0xd6c504a0  ! 1256: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r11
	mov	0x50, %r25
	.word 0xd2f46000  ! 1258: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	mov	0x48, %r18
	mov	0x38, %r25
	.word 0x87802020  ! 1261: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8df0e40  ! 1262: LDXA_R	ldxa	[%r28, %r0] 0x72, %r12
	mov	0x10, %r18
	.word 0xdeac8400  ! 1264: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	mov	0x7d8, %r22
	.word 0xdca7a000  ! 1266: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdca76000  ! 1267: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcaf2000  ! 1268: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdcd72000  ! 1269: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	mov	0x28, %r26
	mov	0x38, %r27
	.word 0xdcbf2000  ! 1272: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1273: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1274: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda970e40  ! 1275: LDUHA_R	lduha	[%r28, %r0] 0x72, %r13
	.word 0xd8bf0e40  ! 1276: STDA_R	stda	%r12, [%r28 + %r0] 0x72
	.word 0xd6ad44a0  ! 1277: STBA_R	stba	%r11, [%r21 + %r0] 0x25
	.word 0xdab72000  ! 1278: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xd8c40400  ! 1279: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	.word 0xd2c48400  ! 1280: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0xd8c72000  ! 1281: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8bf2000  ! 1282: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1283: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d4a000  ! 1284: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	mov	0x3e8, %r20
	mov	0x28, %r27
	.word 0xda8f4e40  ! 1287: LDUBA_R	lduba	[%r29, %r0] 0x72, %r13
	.word 0xdecca000  ! 1288: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	mov	0x7e0, %r22
	mov	0x3e0, %r22
	.word 0xd6f609e0  ! 1291: STXA_R	stxa	%r11, [%r24 + %r0] 0x4f
	.word 0xd2dca000  ! 1292: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r9
	mov	0x3d8, %r22
	.word 0xd89fce40  ! 1294: LDDA_R	ldda	[%r31, %r0] 0x72, %r12
	.word 0xd8b78e40  ! 1295: STHA_R	stha	%r12, [%r30 + %r0] 0x72
	mov	0x50, %r19
	mov	0x70, %r26
	.word 0xdad44400  ! 1298: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0xd0c4e000  ! 1299: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	.word 0xd0a46000  ! 1300: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0bec9e0  ! 1301: STDA_R	stda	%r8, [%r27 + %r0] 0x4f
	.word 0xd0bf4e60  ! 1302: STDA_R	stda	%r8, [%r29 + %r0] 0x73
	mov	0x7c0, %r21
	.word 0xdaa42000  ! 1304: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	mov	0x68, %r27
	.word 0xdac42000  ! 1306: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	mov	0x48, %r18
	.word 0xdaac2000  ! 1308: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0xd4dfce80  ! 1309: LDXA_R	ldxa	[%r31, %r0] 0x74, %r10
	.word 0xd6acc400  ! 1310: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	mov	0x20, %r24
	.word 0xd2f44400  ! 1312: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	.word 0x87802020  ! 1313: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc978e80  ! 1314: LDUHA_R	lduha	[%r30, %r0] 0x74, %r14
	.word 0x87802025  ! 1315: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f6e000  ! 1316: STXA_I	stxa	%r11, [%r27 + 0x0000] %asi
	mov	0x20, %r25
	.word 0xdec78e60  ! 1318: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r15
	.word 0x87802074  ! 1319: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 1320: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdab7e000  ! 1321: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xdaf7e000  ! 1322: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xdab7e000  ! 1323: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 1324: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabda000  ! 1325: STDA_I	stda	%r13, [%r22 + 0x0000] %asi
	.word 0xdac5a000  ! 1326: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r13
	.word 0xdcaec9e0  ! 1327: STBA_R	stba	%r14, [%r27 + %r0] 0x4f
	.word 0xd0d78e60  ! 1328: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r8
	.word 0xd68de000  ! 1329: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r11
	.word 0xd4b6c9e0  ! 1330: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0xd6a56000  ! 1331: STWA_I	stwa	%r11, [%r21 + 0x0000] %asi
	.word 0xdc87ce80  ! 1332: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r14
	.word 0xd0ae89e0  ! 1333: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	.word 0xdaf52000  ! 1334: STXA_I	stxa	%r13, [%r20 + 0x0000] %asi
	.word 0xda856000  ! 1335: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r13
	.word 0xda95a000  ! 1336: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r13
	.word 0xdebc4400  ! 1337: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0xd2cde000  ! 1338: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r9
	.word 0xd4be09e0  ! 1339: STDA_R	stda	%r10, [%r24 + %r0] 0x4f
	.word 0xd4d584a0  ! 1340: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r10
	.word 0x8780204f  ! 1341: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabf2000  ! 1342: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	mov	0x50, %r18
	.word 0xdadf6000  ! 1344: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xd6b74e40  ! 1345: STHA_R	stha	%r11, [%r29 + %r0] 0x72
	.word 0xde976000  ! 1346: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	.word 0xd2a78e40  ! 1347: STWA_R	stwa	%r9, [%r30 + %r0] 0x72
	.word 0x8780204f  ! 1348: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabfe000  ! 1349: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	mov	0x7e8, %r20
	mov	0x38, %r24
	.word 0xdaafa000  ! 1352: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 1353: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r26
	.word 0x87802020  ! 1355: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8fe000  ! 1356: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	mov	0x50, %r25
	.word 0xdcaf0e40  ! 1358: STBA_R	stba	%r14, [%r28 + %r0] 0x72
	.word 0xdef72000  ! 1359: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xdef76000  ! 1360: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xd0870e80  ! 1361: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r8
	.word 0xd28584a0  ! 1362: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r9
	mov	0x40, %r25
	mov	0x3d8, %r23
	.word 0xd4a7e000  ! 1365: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 1366: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r19
	mov	0x70, %r25
	.word 0x87802074  ! 1369: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f4c400  ! 1370: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0x87802020  ! 1371: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r23
	mov	0x68, %r26
	.word 0xd6ac0400  ! 1374: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	mov	0x3c8, %r20
	.word 0xd4bcc400  ! 1376: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0xde9f8e60  ! 1377: LDDA_R	ldda	[%r30, %r0] 0x73, %r15
	.word 0xd6a42000  ! 1378: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xd6b42000  ! 1379: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0xd6a4e000  ! 1380: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0xd6cca000  ! 1381: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r11
	.word 0x87802020  ! 1382: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c76000  ! 1383: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd2c584a0  ! 1384: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r9
	mov	0x50, %r19
	.word 0xd0a70e80  ! 1386: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0x87802073  ! 1387: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f8, %r23
	.word 0xda9f0e40  ! 1389: LDDA_R	ldda	[%r28, %r0] 0x72, %r13
	.word 0xdccde000  ! 1390: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r14
	mov	0x3f8, %r21
	.word 0xdca74e40  ! 1392: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	.word 0xd88d2000  ! 1393: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r12
	.word 0x87802073  ! 1394: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd88f6000  ! 1395: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xd0af0e40  ! 1396: STBA_R	stba	%r8, [%r28 + %r0] 0x72
	.word 0xde8c8400  ! 1397: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	.word 0xdeac0400  ! 1398: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xdeafa000  ! 1399: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xd8a44400  ! 1400: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xdaf7ce40  ! 1401: STXA_R	stxa	%r13, [%r31 + %r0] 0x72
	.word 0xd6bf0e40  ! 1402: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	.word 0x87802073  ! 1403: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f7a000  ! 1404: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	mov	0x7f0, %r22
	.word 0xd6f72000  ! 1406: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6dfe000  ! 1407: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	mov	0x78, %r27
	.word 0x87802025  ! 1409: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6bfa000  ! 1410: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 1411: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f5a000  ! 1412: STXA_I	stxa	%r11, [%r22 + 0x0000] %asi
	.word 0xdab70e40  ! 1413: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	.word 0xd8b5c4a0  ! 1414: STHA_R	stha	%r12, [%r23 + %r0] 0x25
	mov	0x40, %r24
	.word 0xd4a5e000  ! 1416: STWA_I	stwa	%r10, [%r23 + 0x0000] %asi
	.word 0xdad40400  ! 1417: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	.word 0xd2cd04a0  ! 1418: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r9
	mov	0x50, %r18
	mov	0x28, %r16
	.word 0xdacf8e60  ! 1421: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r13
	.word 0xd48c4400  ! 1422: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x10, %r19
	.word 0x8780204f  ! 1425: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa76000  ! 1426: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xda97a000  ! 1427: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xd8af0e60  ! 1428: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	.word 0xdca4c400  ! 1429: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	mov	0x20, %r16
	mov	0x50, %r16
	.word 0xda87a000  ! 1432: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0xd6a7ce80  ! 1433: STWA_R	stwa	%r11, [%r31 + %r0] 0x74
	.word 0xdedf8e80  ! 1434: LDXA_R	ldxa	[%r30, %r0] 0x74, %r15
	.word 0x87802072  ! 1435: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r24
	.word 0x87802072  ! 1437: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r26
	.word 0xd08fa000  ! 1439: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0xd0af2000  ! 1440: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xdc8d44a0  ! 1441: LDUBA_R	lduba	[%r21, %r0] 0x25, %r14
	.word 0xdad7e000  ! 1442: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xdaf7a000  ! 1443: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	mov	0x48, %r25
	mov	0x7c8, %r22
	mov	0x40, %r16
	.word 0xda872000  ! 1447: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	mov	0x70, %r27
	.word 0x87802020  ! 1449: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8f0e60  ! 1450: LDUBA_R	lduba	[%r28, %r0] 0x73, %r15
	.word 0xdcaf6000  ! 1451: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xda9fce60  ! 1452: LDDA_R	ldda	[%r31, %r0] 0x73, %r13
	.word 0x87802020  ! 1453: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8948400  ! 1454: LDUHA_R	lduha	[%r18, %r0] 0x20, %r12
	.word 0xd6be2000  ! 1455: STDA_I	stda	%r11, [%r24 + 0x0000] %asi
	.word 0xdc9609e0  ! 1456: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r14
	.word 0xda8e2000  ! 1457: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r13
	.word 0xdac62000  ! 1458: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r13
	.word 0xda866000  ! 1459: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r13
	.word 0xda8ea000  ! 1460: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r13
	.word 0xdaf6a000  ! 1461: STXA_I	stxa	%r13, [%r26 + 0x0000] %asi
	.word 0xdade2000  ! 1462: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r13
	mov	0x3f8, %r23
	mov	0x10, %r19
	mov	0x10, %r26
	.word 0x87802074  ! 1466: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdab56000  ! 1467: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xdabde000  ! 1469: STDA_I	stda	%r13, [%r23 + 0x0000] %asi
	.word 0xda8d6000  ! 1470: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1471: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r19
	.word 0x87802072  ! 1473: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r27
	.word 0xd2a4c400  ! 1475: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0x87802074  ! 1476: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r26
	.word 0x87802072  ! 1478: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6dc4400  ! 1479: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xd8dd6000  ! 1480: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r12
	mov	0x28, %r24
	mov	0x3d8, %r23
	.word 0xd48f0e60  ! 1483: LDUBA_R	lduba	[%r28, %r0] 0x73, %r10
	ta	T_CHANGE_HPRIV	! macro
	mov	0x38, %r16
	mov	0x78, %r26
	.word 0x87802020  ! 1487: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r22
	.word 0xd4f74e60  ! 1489: STXA_R	stxa	%r10, [%r29 + %r0] 0x73
	.word 0xdaa4a000  ! 1490: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xdac46000  ! 1491: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r13
	.word 0xdcc609e0  ! 1492: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r14
	.word 0xd8a6c9e0  ! 1493: STWA_R	stwa	%r12, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 1494: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda9f6000  ! 1495: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xd8ad04a0  ! 1496: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	.word 0xdaf7a000  ! 1497: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 1498: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d0, %r22
	mov	0x7e8, %r22
	.word 0xda87ce80  ! 1501: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r13
	mov	0x10, %r24
	.word 0x87802020  ! 1503: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r22
	mov	0x3e0, %r23
	.word 0xd0a70e80  ! 1506: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	mov	0x38, %r27
	.word 0xdaf72000  ! 1508: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdca7ce80  ! 1509: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	.word 0x87802073  ! 1510: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 1511: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r25
	.word 0xdef40400  ! 1513: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	mov	0x3f0, %r20
	.word 0xd0dce000  ! 1515: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r8
	.word 0x87802072  ! 1516: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd09ce000  ! 1517: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r8
	.word 0xdeae49e0  ! 1518: STBA_R	stba	%r15, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 1519: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bf4e80  ! 1520: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	mov	0x58, %r16
	.word 0xd09c8400  ! 1522: LDDA_R	ldda	[%r18, %r0] 0x20, %r8
	.word 0xd4f74e40  ! 1523: STXA_R	stxa	%r10, [%r29 + %r0] 0x72
	mov	0x48, %r17
	.word 0x87802020  ! 1525: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1526: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd68fa000  ! 1527: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0xd0f40400  ! 1528: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	mov	0x7c8, %r22
	.word 0xdecd84a0  ! 1530: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r15
	mov	0x20, %r19
	.word 0xd8b76000  ! 1532: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xde9cc400  ! 1533: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	mov	0x7f8, %r23
	mov	0x7c8, %r23
	.word 0xd8b7ce40  ! 1536: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0x87802072  ! 1537: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r25
	.word 0xd8d7a000  ! 1539: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0xdcc44400  ! 1540: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xd0a544a0  ! 1541: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	mov	0x38, %r24
	.word 0xd8bf8e80  ! 1543: STDA_R	stda	%r12, [%r30 + %r0] 0x74
	mov	0x8, %r26
	.word 0x87802020  ! 1545: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88f2000  ! 1546: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0xd8f7a000  ! 1547: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0x87802020  ! 1549: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1550: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd897a000  ! 1551: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0xd8c70e60  ! 1552: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r12
	.word 0xd6bf4e60  ! 1553: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	mov	0x18, %r26
	.word 0xd89544a0  ! 1555: LDUHA_R	lduha	[%r21, %r0] 0x25, %r12
	.word 0x87802020  ! 1556: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a74e60  ! 1557: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	.word 0xd0f7a000  ! 1558: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd89f8e80  ! 1559: LDDA_R	ldda	[%r30, %r0] 0x74, %r12
	mov	0x68, %r19
	mov	0x38, %r18
	.word 0x87802074  ! 1562: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacfa000  ! 1563: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	mov	0x18, %r16
	.word 0xdaa76000  ! 1565: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xdad48400  ! 1566: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0x8780204f  ! 1567: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0af4e80  ! 1568: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	.word 0x87802072  ! 1569: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r24
	.word 0xd0872000  ! 1571: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 1572: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd09fa000  ! 1573: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	mov	0x7e8, %r22
	mov	0x78, %r25
	mov	0x3c0, %r21
	.word 0xd097e000  ! 1577: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	mov	0x70, %r24
	.word 0xd09689e0  ! 1579: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r8
	.word 0xdecf2000  ! 1580: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xde9f2000  ! 1581: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xdeb76000  ! 1582: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1583: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r24
	.word 0xd2b74e40  ! 1585: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	.word 0xd28fce80  ! 1586: LDUBA_R	lduba	[%r31, %r0] 0x74, %r9
	mov	0x30, %r17
	.word 0x87802072  ! 1588: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f0, %r21
	.word 0xdcd48400  ! 1590: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	.word 0x87802073  ! 1591: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r25
	.word 0xdc9e2000  ! 1593: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r14
	.word 0xdcc70e60  ! 1594: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r14
	.word 0xdccf4e80  ! 1595: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r14
	.word 0x87802072  ! 1596: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde876000  ! 1597: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xd0b70e40  ! 1598: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	mov	0x40, %r17
	ta	T_CHANGE_PRIV	! macro
	.word 0xdecfce60  ! 1601: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r15
	.word 0xd2bfe000  ! 1602: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1603: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ce89e0  ! 1604: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r12
	.word 0x8780204f  ! 1605: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f62000  ! 1606: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	.word 0xd2dee000  ! 1607: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r9
	mov	0x3e8, %r21
	.word 0xd2de6000  ! 1609: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r9
	mov	0x7d8, %r23
	.word 0x8780204f  ! 1611: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1612: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d48400  ! 1613: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	.word 0x87802020  ! 1614: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r22
	.word 0xdaac2000  ! 1616: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0xdcbc4400  ! 1617: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	mov	0x40, %r19
	.word 0x8780204f  ! 1619: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x48, %r24
	.word 0x87802020  ! 1621: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd496e000  ! 1622: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r10
	mov	0x58, %r18
	.word 0xd49e2000  ! 1624: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r10
	.word 0x87802072  ! 1625: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f40400  ! 1626: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	mov	0x48, %r27
	.word 0xd6a70e40  ! 1628: STWA_R	stwa	%r11, [%r28 + %r0] 0x72
	.word 0xde9c4400  ! 1629: LDDA_R	ldda	[%r17, %r0] 0x20, %r15
	.word 0xd4b46000  ! 1630: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xd0bf4e40  ! 1631: STDA_R	stda	%r8, [%r29 + %r0] 0x72
	.word 0xd6ac6000  ! 1632: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802074  ! 1634: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f72000  ! 1635: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	mov	0x18, %r24
	mov	0x3c0, %r21
	.word 0xd6a70e40  ! 1638: STWA_R	stwa	%r11, [%r28 + %r0] 0x72
	.word 0xd6a72000  ! 1639: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd8dc8400  ! 1640: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xd2cc8400  ! 1641: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0xdcb7a000  ! 1642: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xdaaf4e40  ! 1643: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	.word 0xd88fce40  ! 1644: LDUBA_R	lduba	[%r31, %r0] 0x72, %r12
	.word 0xd09fe000  ! 1645: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 1646: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0d62000  ! 1647: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r8
	mov	0x38, %r25
	.word 0xd687ce40  ! 1649: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r11
	.word 0xd0cee000  ! 1650: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r8
	.word 0xd0a66000  ! 1651: STWA_I	stwa	%r8, [%r25 + 0x0000] %asi
	mov	0x50, %r19
	.word 0xd0b6e000  ! 1653: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	mov	0x7e8, %r21
	mov	0x8, %r18
	.word 0xd0be2000  ! 1656: STDA_I	stda	%r8, [%r24 + 0x0000] %asi
	.word 0xd0dee000  ! 1657: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r8
	.word 0xdea78e60  ! 1658: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	.word 0xde8ee000  ! 1659: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r15
	mov	0x40, %r17
	.word 0xdec649e0  ! 1661: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r15
	.word 0xd68ea000  ! 1662: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r11
	mov	0x70, %r26
	mov	0x7e0, %r20
	.word 0xd69e2000  ! 1665: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r11
	.word 0x87802020  ! 1666: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x7c0, %r20
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6a7e000  ! 1670: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6cf6000  ! 1671: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	mov	0x68, %r18
	mov	0x60, %r26
	.word 0xd6b7e000  ! 1674: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xdacfce60  ! 1675: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r13
	.word 0xdca72000  ! 1676: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xd8b5c4a0  ! 1677: STHA_R	stha	%r12, [%r23 + %r0] 0x25
	.word 0xd2de09e0  ! 1678: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r9
	mov	0x40, %r17
	.word 0xd29c4400  ! 1680: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	mov	0x3f8, %r21
	.word 0xde9f6000  ! 1682: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0xde87e000  ! 1683: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdef7e000  ! 1684: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xd2dc4400  ! 1685: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	mov	0x58, %r26
	.word 0xdabf0e40  ! 1687: STDA_R	stda	%r13, [%r28 + %r0] 0x72
	.word 0xdaf74e40  ! 1688: STXA_R	stxa	%r13, [%r29 + %r0] 0x72
	.word 0xd08fe000  ! 1689: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	.word 0xd0d7a000  ! 1690: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0xd0f76000  ! 1691: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	mov	0x78, %r16
	.word 0xd2c5c4a0  ! 1693: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r9
	.word 0x8780204f  ! 1694: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2b4a000  ! 1695: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0xd2ac6000  ! 1696: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd2d4a000  ! 1697: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	mov	0x58, %r18
	.word 0xd2a4e000  ! 1699: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2842000  ! 1700: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r9
	.word 0xd2bca000  ! 1701: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	.word 0xd2d4e000  ! 1702: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0xd2b46000  ! 1703: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0xd2a4a000  ! 1704: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 1705: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2df2000  ! 1706: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd6b544a0  ! 1707: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	.word 0xdca76000  ! 1708: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdeafce60  ! 1709: STBA_R	stba	%r15, [%r31 + %r0] 0x73
	.word 0xdab48400  ! 1710: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0xd89fce80  ! 1711: LDDA_R	ldda	[%r31, %r0] 0x74, %r12
	.word 0xde8f2000  ! 1712: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xde8f6000  ! 1713: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	.word 0xd2c609e0  ! 1714: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r9
	mov	0x60, %r26
	.word 0xd8dfce40  ! 1716: LDXA_R	ldxa	[%r31, %r0] 0x72, %r12
	.word 0x87802020  ! 1717: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f4e000  ! 1718: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xd6d44400  ! 1719: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r11
	.word 0xd2af4e80  ! 1720: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	.word 0xd6a504a0  ! 1721: STWA_R	stwa	%r11, [%r20 + %r0] 0x25
	mov	0x7e8, %r22
	.word 0x87802072  ! 1723: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc8f8e60  ! 1724: LDUBA_R	lduba	[%r30, %r0] 0x73, %r14
	.word 0xde8d6000  ! 1725: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r15
	.word 0xd0b649e0  ! 1726: STHA_R	stha	%r8, [%r25 + %r0] 0x4f
	mov	0x68, %r26
	mov	0x30, %r26
	.word 0xdead2000  ! 1729: STBA_I	stba	%r15, [%r20 + 0x0000] %asi
	.word 0xd8bf4e40  ! 1730: STDA_R	stda	%r12, [%r29 + %r0] 0x72
	.word 0xd2f52000  ! 1731: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	.word 0x8780204f  ! 1732: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 1733: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a5c4a0  ! 1734: STWA_R	stwa	%r12, [%r23 + %r0] 0x25
	.word 0xde942000  ! 1735: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	.word 0xd2978e80  ! 1736: LDUHA_R	lduha	[%r30, %r0] 0x74, %r9
	.word 0xd884e000  ! 1737: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r12
	.word 0xdaad44a0  ! 1738: STBA_R	stba	%r13, [%r21 + %r0] 0x25
	mov	0x58, %r27
	mov	0x7e0, %r23
	.word 0xd6aca000  ! 1741: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xd6cc8400  ! 1742: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	.word 0xdcc40400  ! 1743: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	ta	T_CHANGE_PRIV	! macro
	.word 0xdef78e40  ! 1745: STXA_R	stxa	%r15, [%r30 + %r0] 0x72
	mov	0x50, %r16
	mov	0x48, %r17
	.word 0xded44400  ! 1748: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	mov	0x20, %r27
	.word 0x87802025  ! 1750: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f70e80  ! 1751: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0xd0b7ce80  ! 1752: STHA_R	stha	%r8, [%r31 + %r0] 0x74
	.word 0xd4cfa000  ! 1753: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0xd4872000  ! 1754: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4a7a000  ! 1755: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	mov	0x7c0, %r22
	.word 0x87802073  ! 1757: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 1758: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2bfce60  ! 1759: STDA_R	stda	%r9, [%r31 + %r0] 0x73
	.word 0xd2a66000  ! 1760: STWA_I	stwa	%r9, [%r25 + 0x0000] %asi
	.word 0xdcbf0e80  ! 1761: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	.word 0xdef62000  ! 1762: STXA_I	stxa	%r15, [%r24 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xded66000  ! 1764: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r15
	mov	0x50, %r26
	.word 0xdaa74e60  ! 1766: STWA_R	stwa	%r13, [%r29 + %r0] 0x73
	mov	0x7f0, %r22
	.word 0xded74e60  ! 1768: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r15
	.word 0xdcb504a0  ! 1769: STHA_R	stha	%r14, [%r20 + %r0] 0x25
	.word 0xdebd84a0  ! 1770: STDA_R	stda	%r15, [%r22 + %r0] 0x25
	mov	0x30, %r16
	.word 0xdabe2000  ! 1772: STDA_I	stda	%r13, [%r24 + 0x0000] %asi
	.word 0xd4c70e60  ! 1773: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r10
	mov	0x8, %r18
	.word 0x87802020  ! 1775: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadd84a0  ! 1776: LDXA_R	ldxa	[%r22, %r0] 0x25, %r13
	.word 0xd6bf6000  ! 1777: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd68fe000  ! 1778: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xd48dc4a0  ! 1779: LDUBA_R	lduba	[%r23, %r0] 0x25, %r10
	.word 0xdcf584a0  ! 1780: STXA_R	stxa	%r14, [%r22 + %r0] 0x25
	.word 0xd8bf8e40  ! 1781: STDA_R	stda	%r12, [%r30 + %r0] 0x72
	.word 0xd2872000  ! 1782: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	mov	0x7e0, %r21
	.word 0xdc940400  ! 1784: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0x8780204f  ! 1785: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a66000  ! 1786: STWA_I	stwa	%r9, [%r25 + 0x0000] %asi
	mov	0x30, %r16
	.word 0xd2b62000  ! 1788: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	mov	0x8, %r26
	.word 0xd2a62000  ! 1790: STWA_I	stwa	%r9, [%r24 + 0x0000] %asi
	mov	0x8, %r27
	.word 0x87802074  ! 1792: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2c7e000  ! 1793: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	mov	0x7c8, %r21
	.word 0xd2a76000  ! 1795: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd2b72000  ! 1796: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd0dc8400  ! 1797: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0xde8fa000  ! 1798: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0xdcd7ce60  ! 1799: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r14
	mov	0x30, %r27
	.word 0xd0d504a0  ! 1801: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r8
	.word 0xdecc4400  ! 1802: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r15
	.word 0xd0b544a0  ! 1803: STHA_R	stha	%r8, [%r21 + %r0] 0x25
	.word 0xd2dfa000  ! 1804: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0x87802074  ! 1805: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 1806: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 1807: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6844400  ! 1808: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r11
	.word 0xd0b74e60  ! 1809: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	mov	0x28, %r17
	mov	0x7d8, %r23
	.word 0xd6cf4e40  ! 1812: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r11
	.word 0xd0ac4400  ! 1813: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0xd2aca000  ! 1814: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0xd49cc400  ! 1815: LDDA_R	ldda	[%r19, %r0] 0x20, %r10
	.word 0xd4f689e0  ! 1816: STXA_R	stxa	%r10, [%r26 + %r0] 0x4f
	mov	0x3e0, %r23
	.word 0xd2ac2000  ! 1818: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd2a4e000  ! 1819: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 1820: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1821: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r21
	.word 0x87802072  ! 1823: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd68f0e40  ! 1824: LDUBA_R	lduba	[%r28, %r0] 0x72, %r11
	.word 0xd0a46000  ! 1825: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	mov	0x28, %r17
	mov	0x38, %r24
	.word 0xd6cc8400  ! 1828: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	.word 0xd8df4e80  ! 1829: LDXA_R	ldxa	[%r29, %r0] 0x74, %r12
	mov	0x38, %r27
	mov	0x3e0, %r22
	.word 0xdaaf4e40  ! 1832: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	.word 0x87802020  ! 1833: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r23
	mov	0x3d0, %r20
	.word 0xd68f6000  ! 1836: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6a78e60  ! 1837: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0xd0c7ce40  ! 1838: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r8
	.word 0xd2bf8e80  ! 1839: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	.word 0x87802025  ! 1840: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdccfa000  ! 1841: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0x87802072  ! 1842: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1843: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r26
	.word 0xd8f70e80  ! 1845: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	.word 0xd6cce000  ! 1846: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r11
	.word 0xdabc4400  ! 1847: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xda9ca000  ! 1848: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	.word 0xdaf42000  ! 1849: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 1850: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r17
	.word 0xd2940400  ! 1852: LDUHA_R	lduha	[%r16, %r0] 0x20, %r9
	mov	0x7e0, %r22
	mov	0x38, %r27
	.word 0xd294e000  ! 1855: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	.word 0xd2ace000  ! 1856: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0xd28c6000  ! 1857: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0xd2a4e000  ! 1858: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2bce000  ! 1859: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 1860: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdea70e80  ! 1861: STWA_R	stwa	%r15, [%r28 + %r0] 0x74
	.word 0xdead44a0  ! 1862: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	mov	0x68, %r18
	.word 0xde87a000  ! 1864: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xde9d04a0  ! 1865: LDDA_R	ldda	[%r20, %r0] 0x25, %r15
	.word 0xdcaf6000  ! 1866: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 1867: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb72000  ! 1868: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	mov	0x18, %r16
	.word 0xdcb72000  ! 1870: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xdcaf6000  ! 1871: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdcf76000  ! 1872: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcdf2000  ! 1873: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	mov	0x7c0, %r22
	.word 0xdcf7e000  ! 1875: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x48, %r16
	mov	0x7d8, %r20
	mov	0x40, %r18
	.word 0xdca72000  ! 1879: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xd2df0e40  ! 1880: LDXA_R	ldxa	[%r28, %r0] 0x72, %r9
	.word 0x87802025  ! 1881: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f8, %r20
	.word 0xdca72000  ! 1883: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdccf0e60  ! 1884: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r14
	mov	0x68, %r18
	mov	0x10, %r25
	.word 0xdaf7a000  ! 1887: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xd2f70e80  ! 1888: STXA_R	stxa	%r9, [%r28 + %r0] 0x74
	.word 0x87802073  ! 1889: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4cca000  ! 1890: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r10
	.word 0xd6c48400  ! 1891: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	.word 0x87802020  ! 1892: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4afce60  ! 1893: STBA_R	stba	%r10, [%r31 + %r0] 0x73
	.word 0x87802073  ! 1894: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdac74e40  ! 1895: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r13
	.word 0xdaa76000  ! 1896: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	mov	0x48, %r26
	.word 0x87802025  ! 1898: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd29e09e0  ! 1899: LDDA_R	ldda	[%r24, %r0] 0x4f, %r9
	.word 0xdedd04a0  ! 1900: LDXA_R	ldxa	[%r20, %r0] 0x25, %r15
	.word 0xd6be09e0  ! 1901: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	.word 0xd0978e40  ! 1902: LDUHA_R	lduha	[%r30, %r0] 0x72, %r8
	.word 0xd4dd44a0  ! 1903: LDXA_R	ldxa	[%r21, %r0] 0x25, %r10
	.word 0xdab504a0  ! 1904: STHA_R	stha	%r13, [%r20 + %r0] 0x25
	.word 0xd0a4c400  ! 1905: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0x87802020  ! 1906: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r23
	.word 0xd4afe000  ! 1908: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xdc8e09e0  ! 1909: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r14
	.word 0x8780204f  ! 1910: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1911: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbe2000  ! 1912: STDA_I	stda	%r14, [%r24 + 0x0000] %asi
	.word 0xdc9ee000  ! 1913: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r14
	.word 0xdcdee000  ! 1914: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r14
	.word 0x87802074  ! 1915: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b40400  ! 1916: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	mov	0x7e8, %r20
	.word 0xdac5a000  ! 1918: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r13
	mov	0x7c8, %r20
	.word 0xd6cd84a0  ! 1920: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r11
	.word 0xda940400  ! 1921: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	.word 0x87802020  ! 1922: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0874e60  ! 1923: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r8
	mov	0x18, %r26
	.word 0xd8df2000  ! 1925: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	mov	0x48, %r17
	.word 0xd8a72000  ! 1927: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	mov	0x10, %r26
	mov	0x3f0, %r23
	.word 0xd8afe000  ! 1930: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd8cfe000  ! 1931: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8b7a000  ! 1932: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1933: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8dc6000  ! 1935: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	mov	0x20, %r16
	mov	0x70, %r27
	.word 0xd0cc8400  ! 1938: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0xd0cc4400  ! 1939: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	.word 0xd6f649e0  ! 1940: STXA_R	stxa	%r11, [%r25 + %r0] 0x4f
	.word 0xdcd4e000  ! 1941: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	.word 0xdcf46000  ! 1942: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	mov	0x3d8, %r20
	mov	0x28, %r26
	.word 0xd6ccc400  ! 1945: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	.word 0x87802025  ! 1946: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 1947: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0aea000  ! 1948: STBA_I	stba	%r8, [%r26 + 0x0000] %asi
	.word 0xd88f4e80  ! 1949: LDUBA_R	lduba	[%r29, %r0] 0x74, %r12
	.word 0x87802072  ! 1950: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebf0e60  ! 1951: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	.word 0xdcbea000  ! 1952: STDA_I	stda	%r14, [%r26 + 0x0000] %asi
	.word 0xdcd62000  ! 1953: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r14
	.word 0xd8d584a0  ! 1954: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r12
	.word 0xdec66000  ! 1955: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r15
	.word 0xdec66000  ! 1956: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r15
	.word 0xde9ea000  ! 1957: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r15
	.word 0xd8c6c9e0  ! 1958: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r12
	.word 0xdede2000  ! 1959: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r15
	.word 0xd4bf0e60  ! 1960: STDA_R	stda	%r10, [%r28 + %r0] 0x73
	.word 0xd6f66000  ! 1961: STXA_I	stxa	%r11, [%r25 + 0x0000] %asi
	mov	0x7d8, %r23
	mov	0x58, %r25
	mov	0x68, %r26
	.word 0xdef78e40  ! 1965: STXA_R	stxa	%r15, [%r30 + %r0] 0x72
	.word 0xd4ae89e0  ! 1966: STBA_R	stba	%r10, [%r26 + %r0] 0x4f
	mov	0x78, %r27
	mov	0x3d8, %r20
	mov	0x40, %r17
	mov	0x68, %r18
	mov	0x10, %r25
	.word 0xd2962000  ! 1972: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r9
	mov	0x50, %r17
	.word 0xd6974e80  ! 1974: LDUHA_R	lduha	[%r29, %r0] 0x74, %r11
	.word 0x87802025  ! 1975: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0df2000  ! 1976: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	mov	0x0, %r16
	.word 0xd8bc0400  ! 1978: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xded78e60  ! 1979: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r15
	.word 0xd2ac8400  ! 1980: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0x87802020  ! 1981: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r18
	mov	0x60, %r19
	.word 0xded78e80  ! 1984: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r15
	.word 0xd6be49e0  ! 1985: STDA_R	stda	%r11, [%r25 + %r0] 0x4f
	.word 0xdcb7e000  ! 1986: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 1987: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca52000  ! 1988: STWA_I	stwa	%r14, [%r20 + 0x0000] %asi
	mov	0x3f0, %r21
	mov	0x20, %r17
	.word 0xd4dfce60  ! 1991: LDXA_R	ldxa	[%r31, %r0] 0x73, %r10
	mov	0x30, %r25
	.word 0x87802073  ! 1993: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xded4a000  ! 1994: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	.word 0xd4cc8400  ! 1995: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	.word 0xdcdca000  ! 1996: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xdc844400  ! 1997: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	.word 0xd494e000  ! 1998: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	.word 0xdebfce40  ! 1999: STDA_R	stda	%r15, [%r31 + %r0] 0x72
	.word 0xdea4e000  ! 2000: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xde842000  ! 2001: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	.word 0xd4ac4400  ! 2002: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xd0b40400  ! 2003: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0x87802074  ! 2004: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd29f4e80  ! 2005: LDDA_R	ldda	[%r29, %r0] 0x74, %r9
	.word 0xd4dfe000  ! 2006: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4afe000  ! 2007: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xdcf70e80  ! 2008: STXA_R	stxa	%r14, [%r28 + %r0] 0x74
	.word 0x87802025  ! 2009: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e8, %r22
	.word 0x8780204f  ! 2011: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a46000  ! 2012: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	mov	0x7c0, %r20
	.word 0xd29ca000  ! 2014: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	mov	0x3c0, %r22
	mov	0x0, %r26
	mov	0x30, %r17
	.word 0xd2a4e000  ! 2018: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	mov	0x48, %r19
	.word 0xd2c5c4a0  ! 2020: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r9
	.word 0xd6bf4e40  ! 2021: STDA_R	stda	%r11, [%r29 + %r0] 0x72
	mov	0x68, %r25
	.word 0xd2c42000  ! 2023: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2024: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28f6000  ! 2025: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd4a78e40  ! 2026: STWA_R	stwa	%r10, [%r30 + %r0] 0x72
	.word 0xdc8fce60  ! 2027: LDUBA_R	lduba	[%r31, %r0] 0x73, %r14
	.word 0xd4bf2000  ! 2028: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	mov	0x78, %r16
	mov	0x7e8, %r22
	mov	0x58, %r24
	.word 0xd4c504a0  ! 2032: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r10
	mov	0x30, %r18
	.word 0x87802020  ! 2034: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bfe000  ! 2035: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xd8bfe000  ! 2037: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	mov	0x8, %r18
	.word 0xd887a000  ! 2039: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8c7e000  ! 2040: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	ta	T_CHANGE_HPRIV	! macro
	.word 0x8780204f  ! 2042: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r18
	.word 0xd8df6000  ! 2044: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8afce80  ! 2045: STBA_R	stba	%r12, [%r31 + %r0] 0x74
	.word 0xd8a72000  ! 2046: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	mov	0x30, %r18
	.word 0x87802072  ! 2048: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 2049: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f0, %r20
	mov	0x40, %r27
	.word 0xd8a6a000  ! 2052: STWA_I	stwa	%r12, [%r26 + 0x0000] %asi
	.word 0xd8b66000  ! 2053: STHA_I	stha	%r12, [%r25 + 0x0000] %asi
	mov	0x3f8, %r21
	mov	0x8, %r24
	.word 0xdaf48400  ! 2056: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xd2f689e0  ! 2057: STXA_R	stxa	%r9, [%r26 + %r0] 0x4f
	mov	0x48, %r26
	.word 0xd48dc4a0  ! 2059: LDUBA_R	lduba	[%r23, %r0] 0x25, %r10
	.word 0xd4ce09e0  ! 2060: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r10
	.word 0xdabc8400  ! 2061: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	.word 0x87802020  ! 2062: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc870e80  ! 2063: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r14
	.word 0xdcf56000  ! 2064: STXA_I	stxa	%r14, [%r21 + 0x0000] %asi
	.word 0x87802074  ! 2065: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb52000  ! 2066: STHA_I	stha	%r14, [%r20 + 0x0000] %asi
	.word 0xd0f544a0  ! 2067: STXA_R	stxa	%r8, [%r21 + %r0] 0x25
	.word 0x87802020  ! 2068: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcafa000  ! 2069: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xdcf7e000  ! 2070: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcd7e000  ! 2071: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xdca689e0  ! 2072: STWA_R	stwa	%r14, [%r26 + %r0] 0x4f
	.word 0xdccc0400  ! 2073: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r14
	.word 0xd6976000  ! 2074: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	mov	0x3c0, %r23
	mov	0x78, %r27
	.word 0xdedf4e80  ! 2077: LDXA_R	ldxa	[%r29, %r0] 0x74, %r15
	.word 0xd6b72000  ! 2078: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xdcf78e60  ! 2079: STXA_R	stxa	%r14, [%r30 + %r0] 0x73
	.word 0xd2972000  ! 2080: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xd2dfe000  ! 2081: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	mov	0x7d8, %r20
	mov	0x58, %r16
	.word 0xd2a7e000  ! 2084: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xd2d7e000  ! 2085: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xd2af6000  ! 2086: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd2bfa000  ! 2087: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd2bc0400  ! 2088: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xd8bfe000  ! 2089: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 2090: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbc8400  ! 2091: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xdaadc4a0  ! 2092: STBA_R	stba	%r13, [%r23 + %r0] 0x25
	mov	0x0, %r18
	.word 0x87802020  ! 2094: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a74e40  ! 2095: STWA_R	stwa	%r12, [%r29 + %r0] 0x72
	.word 0xd0dfce40  ! 2096: LDXA_R	ldxa	[%r31, %r0] 0x72, %r8
	.word 0xd0f70e40  ! 2097: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	.word 0xd0f5a000  ! 2098: STXA_I	stxa	%r8, [%r22 + 0x0000] %asi
	.word 0xdac78e40  ! 2099: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r13
	.word 0xd28f4e80  ! 2100: LDUBA_R	lduba	[%r29, %r0] 0x74, %r9
	.word 0xd8af8e80  ! 2101: STBA_R	stba	%r12, [%r30 + %r0] 0x74
	.word 0xda8c4400  ! 2102: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0x87802072  ! 2103: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2104: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f62000  ! 2105: STXA_I	stxa	%r8, [%r24 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xd0aee000  ! 2107: STBA_I	stba	%r8, [%r27 + 0x0000] %asi
	.word 0xd29dc4a0  ! 2108: LDDA_R	ldda	[%r23, %r0] 0x25, %r9
	.word 0xdcf6c9e0  ! 2109: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	.word 0xd69584a0  ! 2110: LDUHA_R	lduha	[%r22, %r0] 0x25, %r11
	.word 0xd8c6e000  ! 2111: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2112: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r25
	.word 0xd8d5e000  ! 2114: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r12
	mov	0x28, %r24
	.word 0xd8d56000  ! 2116: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 2117: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8d4a000  ! 2118: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0x87802025  ! 2119: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8f6a000  ! 2120: STXA_I	stxa	%r12, [%r26 + 0x0000] %asi
	mov	0x60, %r19
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdebdc4a0  ! 2123: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	.word 0xd6970e80  ! 2124: LDUHA_R	lduha	[%r28, %r0] 0x74, %r11
	mov	0x7d8, %r21
	.word 0x8780204f  ! 2126: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdca6e000  ! 2127: STWA_I	stwa	%r14, [%r27 + 0x0000] %asi
	.word 0xd0f649e0  ! 2128: STXA_R	stxa	%r8, [%r25 + %r0] 0x4f
	.word 0xd0a6a000  ! 2129: STWA_I	stwa	%r8, [%r26 + 0x0000] %asi
	mov	0x7d8, %r22
	mov	0x30, %r24
	.word 0xd0c62000  ! 2132: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r8
	.word 0xd0de6000  ! 2133: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r8
	.word 0xd0cc0400  ! 2134: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0x87802074  ! 2135: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0cd6000  ! 2136: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r8
	.word 0xd0f5e000  ! 2137: STXA_I	stxa	%r8, [%r23 + 0x0000] %asi
	.word 0xd0af0e40  ! 2138: STBA_R	stba	%r8, [%r28 + %r0] 0x72
	.word 0xd08c4400  ! 2139: LDUBA_R	lduba	[%r17, %r0] 0x20, %r8
	mov	0x40, %r26
	.word 0xd68da000  ! 2141: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r11
	mov	0x40, %r16
	.word 0xde9e49e0  ! 2143: LDDA_R	ldda	[%r25, %r0] 0x4f, %r15
	.word 0xd2bd04a0  ! 2144: STDA_R	stda	%r9, [%r20 + %r0] 0x25
	.word 0xd8a5e000  ! 2145: STWA_I	stwa	%r12, [%r23 + 0x0000] %asi
	.word 0xdcbcc400  ! 2146: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xdef74e80  ! 2147: STXA_R	stxa	%r15, [%r29 + %r0] 0x74
	.word 0xd8cd2000  ! 2148: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r12
	mov	0x7f8, %r20
	.word 0xd8c5a000  ! 2150: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r12
	.word 0xd8f56000  ! 2151: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	.word 0xd8852000  ! 2152: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r12
	mov	0x30, %r24
	mov	0x3e8, %r22
	.word 0x8780204f  ! 2155: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8c4e000  ! 2156: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	.word 0xd8a4e000  ! 2157: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xd8ac2000  ! 2158: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0xde978e40  ! 2159: LDUHA_R	lduha	[%r30, %r0] 0x72, %r15
	.word 0xdaace000  ! 2160: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 2161: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa4a000  ! 2162: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xdab42000  ! 2163: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xdaa48400  ! 2164: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0xd297ce40  ! 2165: LDUHA_R	lduha	[%r31, %r0] 0x72, %r9
	.word 0x8780204f  ! 2166: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r17
	.word 0xdaaf2000  ! 2168: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	mov	0x68, %r19
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdabfe000  ! 2171: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xde95c4a0  ! 2172: LDUHA_R	lduha	[%r23, %r0] 0x25, %r15
	mov	0x68, %r17
	mov	0x3d0, %r20
	mov	0x3f8, %r21
	.word 0x87802025  ! 2176: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4f7e000  ! 2177: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xd88e09e0  ! 2178: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r12
	.word 0xd6d48400  ! 2179: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0xd88fa000  ! 2180: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	mov	0x3f8, %r20
	.word 0xd8bfce60  ! 2182: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	.word 0xdcb7a000  ! 2183: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0x87802074  ! 2185: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2186: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcdfe000  ! 2187: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcbfa000  ! 2188: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xd4a7ce40  ! 2189: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	mov	0x78, %r24
	.word 0x87802025  ! 2191: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbfe000  ! 2192: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 2193: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc974e40  ! 2194: LDUHA_R	lduha	[%r29, %r0] 0x72, %r14
	.word 0xdeb6e000  ! 2195: STHA_I	stha	%r15, [%r27 + 0x0000] %asi
	mov	0x7e0, %r20
	.word 0x87802072  ! 2197: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r17
	mov	0x3e8, %r23
	mov	0x7f8, %r20
	.word 0xdcadc4a0  ! 2201: STBA_R	stba	%r14, [%r23 + %r0] 0x25
	mov	0x3d0, %r23
	.word 0xd0f6a000  ! 2203: STXA_I	stxa	%r8, [%r26 + 0x0000] %asi
	mov	0x30, %r19
	.word 0x87802074  ! 2205: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8be09e0  ! 2206: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	.word 0xdaf56000  ! 2207: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	.word 0xd2940400  ! 2208: LDUHA_R	lduha	[%r16, %r0] 0x20, %r9
	mov	0x18, %r25
	.word 0x87802020  ! 2210: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd896e000  ! 2211: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r12
	.word 0x87802074  ! 2212: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0cf0e60  ! 2213: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r8
	.word 0x87802020  ! 2214: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2215: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6a5c4a0  ! 2216: STWA_R	stwa	%r11, [%r23 + %r0] 0x25
	.word 0x87802073  ! 2217: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r18
	.word 0xdab7a000  ! 2219: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xd68689e0  ! 2220: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r11
	.word 0xd2cfce40  ! 2221: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r9
	.word 0x87802072  ! 2222: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2c70e60  ! 2223: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r9
	.word 0xd0cd84a0  ! 2224: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r8
	.word 0xd4a504a0  ! 2225: STWA_R	stwa	%r10, [%r20 + %r0] 0x25
	.word 0xd4cc6000  ! 2226: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	.word 0xd4aca000  ! 2227: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0xd0f70e40  ! 2228: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	.word 0x87802074  ! 2229: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0952000  ! 2230: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r8
	mov	0x38, %r24
	mov	0x10, %r24
	.word 0xdac609e0  ! 2233: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r13
	mov	0x60, %r25
	.word 0xdebec9e0  ! 2235: STDA_R	stda	%r15, [%r27 + %r0] 0x4f
	.word 0x87802073  ! 2236: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f5e000  ! 2237: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	mov	0x38, %r16
	.word 0xd4ad2000  ! 2239: STBA_I	stba	%r10, [%r20 + 0x0000] %asi
	.word 0xd4c56000  ! 2240: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r10
	.word 0xd4ad2000  ! 2241: STBA_I	stba	%r10, [%r20 + 0x0000] %asi
	mov	0x8, %r18
	mov	0x50, %r25
	.word 0xd49d2000  ! 2244: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r10
	.word 0xd485a000  ! 2245: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r10
	.word 0xdef70e40  ! 2246: STXA_R	stxa	%r15, [%r28 + %r0] 0x72
	.word 0x8780204f  ! 2247: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a44400  ! 2248: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	mov	0x40, %r27
	mov	0x38, %r24
	mov	0x50, %r27
	.word 0xd0afce60  ! 2252: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 2253: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabd44a0  ! 2254: STDA_R	stda	%r13, [%r21 + %r0] 0x25
	.word 0xde948400  ! 2255: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	.word 0xd2bc2000  ! 2256: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	mov	0x60, %r27
	.word 0x87802025  ! 2258: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2d56000  ! 2259: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r9
	.word 0xd285e000  ! 2260: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r9
	.word 0xdac48400  ! 2261: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	.word 0xd885a000  ! 2262: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r12
	.word 0xdeaf4e80  ! 2263: STBA_R	stba	%r15, [%r29 + %r0] 0x74
	.word 0xd8b52000  ! 2264: STHA_I	stha	%r12, [%r20 + 0x0000] %asi
	.word 0xd4a74e80  ! 2265: STWA_R	stwa	%r10, [%r29 + %r0] 0x74
	mov	0x7f0, %r22
	.word 0xd8bda000  ! 2267: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	.word 0xd89de000  ! 2268: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r12
	.word 0xd8d5e000  ! 2269: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r12
	.word 0xd2c504a0  ! 2270: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r9
	.word 0xdcada000  ! 2271: STBA_I	stba	%r14, [%r22 + 0x0000] %asi
	mov	0x3f8, %r22
	.word 0x8780204f  ! 2273: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r19
	.word 0xd4bf4e80  ! 2275: STDA_R	stda	%r10, [%r29 + %r0] 0x74
	.word 0xd6ac4400  ! 2276: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xd686e000  ! 2277: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r11
	.word 0xd6aee000  ! 2278: STBA_I	stba	%r11, [%r27 + 0x0000] %asi
	.word 0xd6a66000  ! 2279: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	mov	0x28, %r25
	.word 0xd89f8e80  ! 2281: LDDA_R	ldda	[%r30, %r0] 0x74, %r12
	.word 0xd0c66000  ! 2282: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r8
	mov	0x30, %r16
	.word 0xd8b7ce80  ! 2284: STHA_R	stha	%r12, [%r31 + %r0] 0x74
	.word 0xd0866000  ! 2285: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r8
	.word 0x87802072  ! 2286: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 2287: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c0, %r21
	.word 0xd8f70e80  ! 2289: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	.word 0xd6df4e40  ! 2290: LDXA_R	ldxa	[%r29, %r0] 0x72, %r11
	.word 0xd4a6a000  ! 2291: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	.word 0xd4ce2000  ! 2292: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r10
	.word 0xd497ce60  ! 2293: LDUHA_R	lduha	[%r31, %r0] 0x73, %r10
	.word 0xdadc0400  ! 2294: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	.word 0x87802020  ! 2295: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8c8400  ! 2296: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	.word 0xdc9584a0  ! 2297: LDUHA_R	lduha	[%r22, %r0] 0x25, %r14
	mov	0x8, %r25
	mov	0x38, %r25
	.word 0xdc9649e0  ! 2300: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r14
	.word 0xd29ec9e0  ! 2301: LDDA_R	ldda	[%r27, %r0] 0x4f, %r9
	.word 0xd4b5e000  ! 2302: STHA_I	stha	%r10, [%r23 + 0x0000] %asi
	.word 0xd4ada000  ! 2303: STBA_I	stba	%r10, [%r22 + 0x0000] %asi
	.word 0xd495e000  ! 2304: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r10
	.word 0xd2bf8e40  ! 2305: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	.word 0xd6b5a000  ! 2306: STHA_I	stha	%r11, [%r22 + 0x0000] %asi
	.word 0xd695a000  ! 2307: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r11
	.word 0xd8a78e40  ! 2308: STWA_R	stwa	%r12, [%r30 + %r0] 0x72
	.word 0xd0cd2000  ! 2309: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r8
	.word 0x87802025  ! 2310: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8f40400  ! 2311: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xd88f4e60  ! 2312: LDUBA_R	lduba	[%r29, %r0] 0x73, %r12
	.word 0xdcc7ce60  ! 2313: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r14
	.word 0xd6b76000  ! 2314: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd2840400  ! 2315: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r9
	.word 0xd4a78e80  ! 2316: STWA_R	stwa	%r10, [%r30 + %r0] 0x74
	.word 0xdea7a000  ! 2317: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xdecf6000  ! 2318: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	mov	0x70, %r24
	.word 0xd6af8e60  ! 2320: STBA_R	stba	%r11, [%r30 + %r0] 0x73
	.word 0xd8876000  ! 2321: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	mov	0x28, %r17
	.word 0xd0dfce80  ! 2323: LDXA_R	ldxa	[%r31, %r0] 0x74, %r8
	.word 0x87802020  ! 2324: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f56000  ! 2325: STXA_I	stxa	%r8, [%r21 + 0x0000] %asi
	.word 0xd0b5e000  ! 2326: STHA_I	stha	%r8, [%r23 + 0x0000] %asi
	.word 0xd0f5a000  ! 2327: STXA_I	stxa	%r8, [%r22 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xda9dc4a0  ! 2329: LDDA_R	ldda	[%r23, %r0] 0x25, %r13
	mov	0x3f8, %r20
	.word 0x87802073  ! 2331: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r16
	mov	0x7d8, %r22
	.word 0xdedf6000  ! 2334: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xdef7a000  ! 2335: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdabec9e0  ! 2336: STDA_R	stda	%r13, [%r27 + %r0] 0x4f
	mov	0x3d8, %r22
	mov	0x70, %r19
	.word 0xd2af2000  ! 2339: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd2a7a000  ! 2340: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	mov	0x3e8, %r22
	mov	0x7c8, %r20
	.word 0xd0a74e40  ! 2343: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	.word 0xd0876000  ! 2344: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	mov	0x78, %r19
	mov	0x3d0, %r20
	.word 0xde878e60  ! 2347: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r15
	.word 0xded74e60  ! 2348: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r15
	.word 0xdec76000  ! 2349: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0x87802025  ! 2350: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2351: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2352: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdebc6000  ! 2353: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xdcb504a0  ! 2354: STHA_R	stha	%r14, [%r20 + %r0] 0x25
	.word 0xdaaf4e40  ! 2355: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	.word 0x87802072  ! 2356: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8af4e80  ! 2357: STBA_R	stba	%r12, [%r29 + %r0] 0x74
	.word 0xd0f4c400  ! 2358: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	mov	0x30, %r24
	.word 0xd4bc8400  ! 2360: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	.word 0xd48f2000  ! 2361: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd497a000  ! 2362: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	mov	0x0, %r24
	mov	0x7e8, %r22
	.word 0xd0cfce80  ! 2365: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r8
	.word 0x87802025  ! 2366: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r27
	.word 0x8780204f  ! 2368: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeb72000  ! 2369: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xda8f4e40  ! 2370: LDUBA_R	lduba	[%r29, %r0] 0x72, %r13
	.word 0xd89fe000  ! 2371: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0xd89f2000  ! 2372: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0x87802072  ! 2373: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r19
	.word 0xd8b4e000  ! 2375: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0xd89fce80  ! 2376: LDDA_R	ldda	[%r31, %r0] 0x74, %r12
	.word 0xdaaca000  ! 2377: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0xd4bd84a0  ! 2378: STDA_R	stda	%r10, [%r22 + %r0] 0x25
	mov	0x78, %r19
	.word 0xd4b46000  ! 2380: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xd4f4e000  ! 2381: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0xdc8c4400  ! 2382: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0xd28c8400  ! 2383: LDUBA_R	lduba	[%r18, %r0] 0x20, %r9
	mov	0x3c0, %r21
	.word 0xd69ec9e0  ! 2385: LDDA_R	ldda	[%r27, %r0] 0x4f, %r11
	mov	0x7d0, %r22
	mov	0x70, %r24
	.word 0xd285c4a0  ! 2388: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r9
	.word 0x87802073  ! 2389: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c0, %r23
	.word 0x87802072  ! 2391: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c8, %r20
	mov	0x38, %r16
	.word 0xd4df2000  ! 2394: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0xdeb70e80  ! 2395: STHA_R	stha	%r15, [%r28 + %r0] 0x74
	.word 0x87802074  ! 2396: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2397: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b7a000  ! 2398: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 2399: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bd2000  ! 2400: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2852000  ! 2402: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r9
	.word 0xdcf7ce80  ! 2403: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	mov	0x78, %r24
	.word 0xd08d2000  ! 2405: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r8
	.word 0xdec6c9e0  ! 2406: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r15
	mov	0x28, %r26
	.word 0xd0aec9e0  ! 2408: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	.word 0xdaac4400  ! 2409: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	.word 0xd88da000  ! 2410: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r12
	.word 0xdccfce60  ! 2411: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r14
	mov	0x18, %r26
	.word 0xdea5a000  ! 2413: STWA_I	stwa	%r15, [%r22 + 0x0000] %asi
	mov	0x68, %r24
	.word 0xd8af0e40  ! 2415: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	.word 0xdaa6c9e0  ! 2416: STWA_R	stwa	%r13, [%r27 + %r0] 0x4f
	mov	0x20, %r26
	.word 0x8780204f  ! 2418: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r17
	.word 0xd8ac8400  ! 2420: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	mov	0x40, %r18
	.word 0xde94a000  ! 2422: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0xdeac6000  ! 2423: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xd4b689e0  ! 2424: STHA_R	stha	%r10, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 2425: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r23
	.word 0xdac46000  ! 2427: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r13
	.word 0x87802072  ! 2428: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c0, %r23
	mov	0x7c8, %r22
	.word 0xd89f0e40  ! 2431: LDDA_R	ldda	[%r28, %r0] 0x72, %r12
	.word 0xdebf2000  ! 2432: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xdef72000  ! 2433: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 2434: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 2435: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r17
	.word 0x87802020  ! 2437: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2438: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r27
	.word 0x8780204f  ! 2440: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebfa000  ! 2441: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xdaa6c9e0  ! 2442: STWA_R	stwa	%r13, [%r27 + %r0] 0x4f
	.word 0x87802025  ! 2443: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r25
	.word 0xd49f8e60  ! 2445: LDDA_R	ldda	[%r30, %r0] 0x73, %r10
	.word 0xdeac2000  ! 2446: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xd2dfce40  ! 2447: LDXA_R	ldxa	[%r31, %r0] 0x72, %r9
	.word 0xd087ce40  ! 2448: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r8
	.word 0xd8bca000  ! 2449: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd2b544a0  ! 2450: STHA_R	stha	%r9, [%r21 + %r0] 0x25
	mov	0x30, %r25
	mov	0x78, %r25
	.word 0xd2b46000  ! 2453: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 2454: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 2455: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r26
	.word 0x87802073  ! 2457: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 2458: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2d7a000  ! 2459: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0xdc8dc4a0  ! 2460: LDUBA_R	lduba	[%r23, %r0] 0x25, %r14
	.word 0xd8af0e80  ! 2461: STBA_R	stba	%r12, [%r28 + %r0] 0x74
	.word 0xda87e000  ! 2462: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	mov	0x28, %r25
	.word 0xdab76000  ! 2464: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xd2b74e40  ! 2465: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	mov	0x7f0, %r22
	mov	0x58, %r16
	.word 0x87802020  ! 2468: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8de000  ! 2469: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r13
	.word 0xd2b7ce80  ! 2470: STHA_R	stha	%r9, [%r31 + %r0] 0x74
	.word 0xd29d6000  ! 2471: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r9
	.word 0xd6ac0400  ! 2472: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0xd2dc4400  ! 2473: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xdcaec9e0  ! 2474: STBA_R	stba	%r14, [%r27 + %r0] 0x4f
	.word 0xda870e60  ! 2475: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r13
	.word 0x87802074  ! 2476: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 2477: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b7ce40  ! 2478: STHA_R	stha	%r9, [%r31 + %r0] 0x72
	.word 0xd4d7e000  ! 2479: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	mov	0x0, %r26
	mov	0x58, %r16
	.word 0xd8ce09e0  ! 2482: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r12
	.word 0xda97e000  ! 2483: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	.word 0xdcf609e0  ! 2484: STXA_R	stxa	%r14, [%r24 + %r0] 0x4f
	.word 0xdabfa000  ! 2485: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 2486: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bf8e80  ! 2487: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	.word 0xd4dca000  ! 2488: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	.word 0xd4a4a000  ! 2489: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xd6b584a0  ! 2490: STHA_R	stha	%r11, [%r22 + %r0] 0x25
	mov	0x20, %r16
	.word 0xd4c78e60  ! 2492: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r10
	mov	0x60, %r17
	.word 0xd0846000  ! 2494: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0xd2d7ce80  ! 2495: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r9
	.word 0xd8af8e60  ! 2496: STBA_R	stba	%r12, [%r30 + %r0] 0x73
	.word 0xde8ca000  ! 2497: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0xd8d649e0  ! 2498: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r12
	mov	0x18, %r19
	.word 0x8780204f  ! 2500: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r18
	.word 0xd2dfe000  ! 2502: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2503: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c76000  ! 2504: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0x87802025  ! 2505: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2df8e80  ! 2506: LDXA_R	ldxa	[%r30, %r0] 0x74, %r9
	.word 0xd6d70e40  ! 2507: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r11
	mov	0x10, %r26
	.word 0xdca5a000  ! 2509: STWA_I	stwa	%r14, [%r22 + 0x0000] %asi
	mov	0x7f8, %r22
	.word 0xdadfce60  ! 2511: LDXA_R	ldxa	[%r31, %r0] 0x73, %r13
	.word 0x87802074  ! 2512: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r19
	.word 0xdeb66000  ! 2514: STHA_I	stha	%r15, [%r25 + 0x0000] %asi
	mov	0x38, %r27
	.word 0xdcf5c4a0  ! 2516: STXA_R	stxa	%r14, [%r23 + %r0] 0x25
	mov	0x78, %r24
	.word 0xdcbe2000  ! 2518: STDA_I	stda	%r14, [%r24 + 0x0000] %asi
	.word 0xdcb689e0  ! 2519: STHA_R	stha	%r14, [%r26 + %r0] 0x4f
	.word 0xdcb584a0  ! 2520: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	mov	0x8, %r17
	.word 0xd8944400  ! 2522: LDUHA_R	lduha	[%r17, %r0] 0x20, %r12
	.word 0xdcb78e60  ! 2523: STHA_R	stha	%r14, [%r30 + %r0] 0x73
	mov	0x40, %r27
	mov	0x3c8, %r22
	.word 0x87802072  ! 2526: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca7e000  ! 2527: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdccfe000  ! 2528: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xdca72000  ! 2529: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcbfe000  ! 2530: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	mov	0x28, %r16
	.word 0x87802074  ! 2532: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2533: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2c48400  ! 2534: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0x8780204f  ! 2535: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 2536: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6dc6000  ! 2537: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r11
	.word 0xd6a42000  ! 2538: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xd49504a0  ! 2539: LDUHA_R	lduha	[%r20, %r0] 0x25, %r10
	.word 0xdaa42000  ! 2540: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 2541: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f44400  ! 2542: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xda9f2000  ! 2543: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xdabfce80  ! 2544: STDA_R	stda	%r13, [%r31 + %r0] 0x74
	mov	0x78, %r27
	.word 0x87802020  ! 2546: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8f4e60  ! 2547: LDUBA_R	lduba	[%r29, %r0] 0x73, %r13
	.word 0xdcdca000  ! 2548: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xdcb4e000  ! 2549: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xd8970e80  ! 2550: LDUHA_R	lduha	[%r28, %r0] 0x74, %r12
	.word 0xd2d42000  ! 2551: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0x87802072  ! 2552: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd68f8e60  ! 2553: LDUBA_R	lduba	[%r30, %r0] 0x73, %r11
	.word 0xd88609e0  ! 2554: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r12
	.word 0xd0bcc400  ! 2555: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0x87802072  ! 2556: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8f7a000  ! 2557: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8be09e0  ! 2558: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	.word 0xde94c400  ! 2559: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	.word 0xd6af2000  ! 2560: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2561: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2562: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2563: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f48400  ! 2564: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xdcf584a0  ! 2565: STXA_R	stxa	%r14, [%r22 + %r0] 0x25
	.word 0x87802073  ! 2566: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r19
	.word 0xd0c76000  ! 2568: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0xd6b78e40  ! 2569: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	.word 0xd4d76000  ! 2570: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0xd2cfce80  ! 2571: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r9
	.word 0xd2df2000  ! 2572: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2b7a000  ! 2573: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd6cc0400  ! 2574: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r11
	.word 0xd0b7a000  ! 2575: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 2576: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd085a000  ! 2577: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r8
	mov	0x3c8, %r23
	mov	0x10, %r17
	mov	0x8, %r25
	.word 0xd085e000  ! 2581: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r8
	.word 0xd08d6000  ! 2582: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r8
	.word 0xd2a70e80  ! 2583: STWA_R	stwa	%r9, [%r28 + %r0] 0x74
	.word 0xdef40400  ! 2584: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0xdeb70e60  ! 2585: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	mov	0x7f8, %r21
	.word 0xded40400  ! 2587: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	.word 0xd8f56000  ! 2588: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	.word 0xdcbd44a0  ! 2589: STDA_R	stda	%r14, [%r21 + %r0] 0x25
	.word 0x87802074  ! 2590: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r17
	.word 0x87802074  ! 2592: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde8fe000  ! 2593: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0x87802025  ! 2594: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 2595: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 2596: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r18
	.word 0x87802073  ! 2598: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0ce49e0  ! 2599: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r8
	.word 0xd2b62000  ! 2600: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 2601: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2602: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbd84a0  ! 2603: STDA_R	stda	%r14, [%r22 + %r0] 0x25
	.word 0xd6f6c9e0  ! 2604: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	mov	0x68, %r27
	mov	0x0, %r24
	.word 0xdcf72000  ! 2607: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	mov	0x3e0, %r23
	.word 0xdcc72000  ! 2609: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcc7a000  ! 2610: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	mov	0x3e8, %r21
	.word 0xd8a48400  ! 2612: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	.word 0xd2f72000  ! 2613: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 2614: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e0, %r23
	mov	0x7e0, %r21
	.word 0xd4f6c9e0  ! 2617: STXA_R	stxa	%r10, [%r27 + %r0] 0x4f
	.word 0xd0a70e40  ! 2618: STWA_R	stwa	%r8, [%r28 + %r0] 0x72
	mov	0x70, %r24
	.word 0xd6aee000  ! 2620: STBA_I	stba	%r11, [%r27 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x0, %r16
	.word 0xd6aee000  ! 2623: STBA_I	stba	%r11, [%r27 + 0x0000] %asi
	.word 0xd6966000  ! 2624: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r11
	.word 0xd6f66000  ! 2625: STXA_I	stxa	%r11, [%r25 + 0x0000] %asi
	.word 0xd49fce40  ! 2626: LDDA_R	ldda	[%r31, %r0] 0x72, %r10
	.word 0xd2ae2000  ! 2627: STBA_I	stba	%r9, [%r24 + 0x0000] %asi
	.word 0xda8f0e80  ! 2628: LDUBA_R	lduba	[%r28, %r0] 0x74, %r13
	.word 0xd8f66000  ! 2629: STXA_I	stxa	%r12, [%r25 + 0x0000] %asi
	.word 0xd68504a0  ! 2630: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r11
	mov	0x60, %r19
	.word 0xd6a70e80  ! 2632: STWA_R	stwa	%r11, [%r28 + %r0] 0x74
	.word 0x87802020  ! 2633: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r26
	mov	0x7f8, %r21
	.word 0x87802020  ! 2636: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccc4400  ! 2637: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r14
	.word 0xd8aee000  ! 2638: STBA_I	stba	%r12, [%r27 + 0x0000] %asi
	.word 0xd8b6a000  ! 2639: STHA_I	stha	%r12, [%r26 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0xd8ad04a0  ! 2641: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	.word 0xdc86a000  ! 2642: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r14
	.word 0x87802074  ! 2643: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc94a000  ! 2644: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xdea40400  ! 2645: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xd6dec9e0  ! 2646: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r11
	.word 0x87802025  ! 2647: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebc2000  ! 2648: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xdea4a000  ! 2649: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xd2a7ce40  ! 2650: STWA_R	stwa	%r9, [%r31 + %r0] 0x72
	.word 0xd0a609e0  ! 2651: STWA_R	stwa	%r8, [%r24 + %r0] 0x4f
	.word 0x87802072  ! 2652: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2d4e000  ! 2653: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0xd08f8e60  ! 2654: LDUBA_R	lduba	[%r30, %r0] 0x73, %r8
	mov	0x7d8, %r22
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdad7ce80  ! 2657: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r13
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2d74e80  ! 2659: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r9
	.word 0xd6ac6000  ! 2660: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xdcb70e40  ! 2661: STHA_R	stha	%r14, [%r28 + %r0] 0x72
	.word 0xd29e09e0  ! 2662: LDDA_R	ldda	[%r24, %r0] 0x4f, %r9
	.word 0xdcf46000  ! 2663: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xd8a40400  ! 2664: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	mov	0x18, %r25
	.word 0xd08c6000  ! 2666: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0xd4f48400  ! 2667: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xdc942000  ! 2668: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	mov	0x20, %r17
	.word 0xd49ec9e0  ! 2670: LDDA_R	ldda	[%r27, %r0] 0x4f, %r10
	.word 0xd48c2000  ! 2671: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r10
	.word 0xdca74e40  ! 2672: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	.word 0xd6b609e0  ! 2673: STHA_R	stha	%r11, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 2674: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd69504a0  ! 2675: LDUHA_R	lduha	[%r20, %r0] 0x25, %r11
	.word 0x87802073  ! 2676: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f74e60  ! 2677: STXA_R	stxa	%r11, [%r29 + %r0] 0x73
	.word 0xded78e80  ! 2678: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r15
	.word 0xd08e09e0  ! 2679: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r8
	.word 0x87802074  ! 2680: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdad4e000  ! 2681: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r13
	mov	0x10, %r24
	.word 0xd8d544a0  ! 2683: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r12
	.word 0xdad42000  ! 2684: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2685: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda942000  ! 2686: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0xdad46000  ! 2687: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	mov	0x7d8, %r21
	.word 0xdabce000  ! 2689: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	mov	0x20, %r18
	mov	0x8, %r26
	mov	0x38, %r19
	.word 0x87802073  ! 2693: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdadfa000  ! 2694: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xd284c400  ! 2695: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r9
	.word 0xd087e000  ! 2696: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0976000  ! 2697: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0d7a000  ! 2698: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0x87802020  ! 2699: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r25
	mov	0x3d0, %r23
	mov	0x50, %r17
	.word 0xd0bca000  ! 2703: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0xd0bca000  ! 2704: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	mov	0x18, %r19
	.word 0xd0f4a000  ! 2706: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	mov	0x7f0, %r22
	.word 0xd0bce000  ! 2708: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	mov	0x50, %r24
	.word 0xd0a42000  ! 2710: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xd084c400  ! 2711: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r8
	mov	0x68, %r26
	.word 0xdcf42000  ! 2713: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 2714: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f0, %r23
	mov	0x0, %r17
	.word 0x87802020  ! 2717: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2718: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r19
	mov	0x30, %r16
	.word 0x87802020  ! 2721: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2722: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdade49e0  ! 2723: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r13
	.word 0xdab4a000  ! 2724: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0xdaf48400  ! 2725: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xd4c70e80  ! 2726: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r10
	mov	0x68, %r19
	.word 0x87802074  ! 2728: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3f0, %r22
	.word 0xdaf7a000  ! 2730: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdac76000  ! 2731: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	mov	0x7f8, %r20
	mov	0x48, %r19
	.word 0xdacf6000  ! 2734: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 2735: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r24
	.word 0x8780204f  ! 2737: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e0, %r23
	.word 0xd08d04a0  ! 2739: LDUBA_R	lduba	[%r20, %r0] 0x25, %r8
	.word 0xd294c400  ! 2740: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	.word 0xd0b42000  ! 2741: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	mov	0x18, %r25
	.word 0xd0ace000  ! 2743: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	mov	0x60, %r25
	.word 0x8780204f  ! 2745: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd09fe000  ! 2746: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	mov	0x3d8, %r21
	.word 0xd0c76000  ! 2748: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	mov	0x60, %r24
	.word 0xd0b4c400  ! 2750: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	mov	0x18, %r16
	.word 0xd69f6000  ! 2752: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	.word 0xdca74e60  ! 2753: STWA_R	stwa	%r14, [%r29 + %r0] 0x73
	mov	0x10, %r18
	.word 0xd6bdc4a0  ! 2755: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	.word 0x87802020  ! 2756: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b76000  ! 2757: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2ac4400  ! 2758: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xdc8f6000  ! 2759: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdccf2000  ! 2760: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xdcdf2000  ! 2761: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdc8504a0  ! 2762: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r14
	mov	0x3c0, %r22
	.word 0xdab72000  ! 2764: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdab7a000  ! 2765: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 2766: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 2767: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 2768: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r25
	.word 0xd8a40400  ! 2770: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	mov	0x70, %r19
	.word 0xd2afe000  ! 2772: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 2773: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r19
	.word 0xd2ac2000  ! 2775: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0xd6f70e80  ! 2777: STXA_R	stxa	%r11, [%r28 + %r0] 0x74
	mov	0x68, %r16
	.word 0x87802074  ! 2779: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2780: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdad62000  ! 2781: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r13
	.word 0xdabee000  ! 2782: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	.word 0xdaf62000  ! 2783: STXA_I	stxa	%r13, [%r24 + 0x0000] %asi
	mov	0x58, %r26
	.word 0xda9e6000  ! 2785: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r13
	.word 0x87802074  ! 2786: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 2787: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda962000  ! 2788: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r13
	.word 0xda9ea000  ! 2789: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r13
	mov	0x78, %r27
	mov	0x7c8, %r21
	.word 0xd8ac0400  ! 2792: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	mov	0x7e8, %r21
	mov	0x18, %r26
	.word 0xdedee000  ! 2795: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r15
	.word 0xd28e09e0  ! 2796: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r9
	mov	0x3d0, %r22
	.word 0xdcd4c400  ! 2798: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	.word 0xd6cea000  ! 2799: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	mov	0x58, %r19
	.word 0x87802073  ! 2801: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6b52000  ! 2802: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	mov	0x38, %r18
	.word 0xdeb70e40  ! 2804: STHA_R	stha	%r15, [%r28 + %r0] 0x72
	.word 0xd8952000  ! 2805: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r12
	.word 0xd8c5a000  ! 2806: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2807: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r20
	.word 0xd0af8e40  ! 2809: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0xdaaee000  ! 2810: STBA_I	stba	%r13, [%r27 + 0x0000] %asi
	mov	0x58, %r26
	.word 0xdabea000  ! 2812: STDA_I	stda	%r13, [%r26 + 0x0000] %asi
	mov	0x7f0, %r21
	.word 0x87802020  ! 2814: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac46000  ! 2815: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r13
	.word 0xd8bc8400  ! 2816: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xde848400  ! 2817: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	.word 0xd8a544a0  ! 2818: STWA_R	stwa	%r12, [%r21 + %r0] 0x25
	.word 0x87802020  ! 2819: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r17
	.word 0xd2b72000  ! 2821: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd2d7e000  ! 2822: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xd09c0400  ! 2823: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	.word 0xde9689e0  ! 2824: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r15
	.word 0xd8f74e60  ! 2825: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	.word 0xd4bf4e40  ! 2826: STDA_R	stda	%r10, [%r29 + %r0] 0x72
	.word 0xd8dfe000  ! 2827: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8c7e000  ! 2828: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8a584a0  ! 2829: STWA_R	stwa	%r12, [%r22 + %r0] 0x25
	.word 0xdeafe000  ! 2830: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xdef7e000  ! 2831: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xdec72000  ! 2832: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xd0af0e40  ! 2833: STBA_R	stba	%r8, [%r28 + %r0] 0x72
	.word 0xdc8e09e0  ! 2834: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r14
	.word 0xdacf6000  ! 2835: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	mov	0x20, %r16
	.word 0xda8d44a0  ! 2837: LDUBA_R	lduba	[%r21, %r0] 0x25, %r13
	mov	0x68, %r19
	.word 0xd6b5c4a0  ! 2839: STHA_R	stha	%r11, [%r23 + %r0] 0x25
	.word 0xdef7a000  ! 2840: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xde972000  ! 2841: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0xd0de49e0  ! 2842: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r8
	mov	0x70, %r16
	.word 0xd4b5c4a0  ! 2844: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	mov	0x3e8, %r23
	.word 0xda8f6000  ! 2846: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xd2974e40  ! 2847: LDUHA_R	lduha	[%r29, %r0] 0x72, %r9
	mov	0x18, %r18
	.word 0xd2b544a0  ! 2849: STHA_R	stha	%r9, [%r21 + %r0] 0x25
	mov	0x8, %r17
	.word 0xdaa4c400  ! 2851: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0xded7e000  ! 2852: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	mov	0x78, %r19
	.word 0xd4c544a0  ! 2854: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r10
	.word 0xdef72000  ! 2855: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	mov	0x3c0, %r23
	mov	0x50, %r27
	.word 0xd68f0e80  ! 2858: LDUBA_R	lduba	[%r28, %r0] 0x74, %r11
	.word 0xdcaf4e80  ! 2859: STBA_R	stba	%r14, [%r29 + %r0] 0x74
	mov	0x7d8, %r21
	.word 0xd4bf2000  ! 2861: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd4f72000  ! 2862: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xda9f8e60  ! 2863: LDDA_R	ldda	[%r30, %r0] 0x73, %r13
	.word 0xd8dfa000  ! 2864: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	mov	0x3c0, %r23
	.word 0xdc86c9e0  ! 2866: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r14
	.word 0xda8f2000  ! 2867: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	mov	0x8, %r24
	.word 0xdaafa000  ! 2869: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	mov	0x48, %r26
	.word 0xdaf7a000  ! 2871: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdac7e000  ! 2872: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	mov	0x7c8, %r21
	.word 0xdeb544a0  ! 2874: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	mov	0x8, %r25
	.word 0xd4bfe000  ! 2876: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd6af0e80  ! 2877: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	mov	0x58, %r27
	.word 0x87802025  ! 2879: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b4a000  ! 2880: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0xdeae09e0  ! 2881: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 2882: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0c42000  ! 2883: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r8
	.word 0xdabe49e0  ! 2884: STDA_R	stda	%r13, [%r25 + %r0] 0x4f
	mov	0x0, %r19
	.word 0xd8b4a000  ! 2886: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0xd0b74e40  ! 2887: STHA_R	stha	%r8, [%r29 + %r0] 0x72
	.word 0xdc9f8e60  ! 2888: LDDA_R	ldda	[%r30, %r0] 0x73, %r14
	.word 0xd2878e80  ! 2889: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r9
	.word 0x87802072  ! 2890: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4c7a000  ! 2891: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	.word 0xd0a544a0  ! 2892: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	.word 0x87802020  ! 2893: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2894: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0970e40  ! 2895: LDUHA_R	lduha	[%r28, %r0] 0x72, %r8
	.word 0x87802020  ! 2896: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2897: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbce000  ! 2898: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xdc8ca000  ! 2899: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2900: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r20
	.word 0xd2b609e0  ! 2902: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	mov	0x7e8, %r21
	mov	0x68, %r25
	.word 0x87802025  ! 2905: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeaca000  ! 2906: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xd2a40400  ! 2907: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xdc9c2000  ! 2908: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r14
	mov	0x0, %r25
	.word 0x87802073  ! 2910: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f0, %r20
	.word 0xdcd6a000  ! 2912: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r14
	.word 0xdcaea000  ! 2913: STBA_I	stba	%r14, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 2914: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f48400  ! 2915: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xd2d66000  ! 2916: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r9
	.word 0xd28e6000  ! 2917: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r9
	.word 0xd2f62000  ! 2918: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	.word 0xd2cee000  ! 2919: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2920: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r19
	.word 0x87802074  ! 2922: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd287a000  ! 2923: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0x87802073  ! 2924: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaadc4a0  ! 2925: STBA_R	stba	%r13, [%r23 + %r0] 0x25
	.word 0xd6af0e80  ! 2926: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	.word 0xdcf4a000  ! 2927: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xd0f48400  ! 2928: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xdc8cc400  ! 2929: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	mov	0x48, %r17
	.word 0xd0a44400  ! 2931: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	mov	0x38, %r16
	.word 0x87802020  ! 2933: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b7e000  ! 2934: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	mov	0x7c0, %r22
	.word 0xd2f7e000  ! 2936: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	mov	0x10, %r18
	mov	0x3f8, %r21
	.word 0x87802025  ! 2939: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8f78e60  ! 2940: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	mov	0x30, %r25
	mov	0x3d0, %r22
	mov	0x48, %r25
	.word 0x87802073  ! 2944: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e0, %r21
	.word 0xdc8de000  ! 2946: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r14
	.word 0xd28504a0  ! 2947: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r9
	.word 0xd6c56000  ! 2948: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r11
	.word 0xd6a74e40  ! 2949: STWA_R	stwa	%r11, [%r29 + %r0] 0x72
	.word 0xd4dde000  ! 2950: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r10
	.word 0xded74e40  ! 2951: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r15
	mov	0x48, %r26
	.word 0xd4b74e40  ! 2953: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	mov	0x68, %r18
	.word 0xded78e80  ! 2955: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r15
	.word 0xd2b5e000  ! 2956: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	mov	0x50, %r26
	.word 0x87802074  ! 2958: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a5c4a0  ! 2959: STWA_R	stwa	%r8, [%r23 + %r0] 0x25
	.word 0xd28cc400  ! 2960: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	.word 0xdcac0400  ! 2961: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xdeae6000  ! 2962: STBA_I	stba	%r15, [%r25 + 0x0000] %asi
	.word 0xd69e89e0  ! 2963: LDDA_R	ldda	[%r26, %r0] 0x4f, %r11
	.word 0xd2b6e000  ! 2964: STHA_I	stha	%r9, [%r27 + 0x0000] %asi
	.word 0xd2dea000  ! 2965: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r9
	.word 0xd29e2000  ! 2966: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 2967: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f8, %r23
	.word 0xd2a5a000  ! 2969: STWA_I	stwa	%r9, [%r22 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2acc400  ! 2971: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0xd6f44400  ! 2972: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0xd8b52000  ! 2973: STHA_I	stha	%r12, [%r20 + 0x0000] %asi
	.word 0xd89d6000  ! 2974: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r12
	mov	0x68, %r27
	.word 0xd8b52000  ! 2976: STHA_I	stha	%r12, [%r20 + 0x0000] %asi
	mov	0x7c8, %r22
	mov	0x68, %r19
	.word 0x87802025  ! 2979: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd89ce000  ! 2980: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	.word 0xd8ac2000  ! 2981: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0xd8b42000  ! 2982: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 2983: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 2984: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8f78e80  ! 2985: STXA_R	stxa	%r12, [%r30 + %r0] 0x74
	mov	0x7d8, %r23
	.word 0xd8c52000  ! 2987: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r12
	.word 0xd0cdc4a0  ! 2988: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r8
	.word 0xdef609e0  ! 2989: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	mov	0x3f8, %r23
	.word 0xdc8d2000  ! 2991: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r14
	.word 0xdcbda000  ! 2992: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	.word 0xd4df0e40  ! 2993: LDXA_R	ldxa	[%r28, %r0] 0x72, %r10
	mov	0x3f8, %r23
	.word 0xdef6c9e0  ! 2995: STXA_R	stxa	%r15, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 2996: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab76000  ! 2997: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdab76000  ! 2998: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdaa7a000  ! 2999: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xd6c78e40  ! 3000: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	.word 0xd6dfa000  ! 3001: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0xd68f2000  ! 3002: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3003: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dec9e0  ! 3004: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r9
	.word 0xdef7a000  ! 3005: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xde8f6000  ! 3007: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	mov	0x3c0, %r21
	.word 0xdef72000  ! 3009: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xdea7e000  ! 3010: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	mov	0x10, %r17
	.word 0x87802025  ! 3012: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb504a0  ! 3013: STHA_R	stha	%r14, [%r20 + %r0] 0x25
	.word 0x87802020  ! 3014: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r26
	.word 0xdcbf2000  ! 3016: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 3017: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf4c400  ! 3018: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xdacc4400  ! 3019: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	mov	0x60, %r26
	.word 0xdaf40400  ! 3021: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0x87802020  ! 3022: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb72000  ! 3023: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xdc97e000  ! 3024: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	mov	0x58, %r27
	.word 0xdadc0400  ! 3026: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	.word 0x87802020  ! 3027: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0aca000  ! 3028: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xde9f8e80  ! 3029: LDDA_R	ldda	[%r30, %r0] 0x74, %r15
	.word 0xdaf74e80  ! 3030: STXA_R	stxa	%r13, [%r29 + %r0] 0x74
	mov	0x78, %r18
	.word 0xd4bc0400  ! 3032: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xd484a000  ! 3033: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r10
	mov	0x30, %r18
	.word 0xdebf8e80  ! 3035: STDA_R	stda	%r15, [%r30 + %r0] 0x74
	.word 0xd685c4a0  ! 3036: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r11
	.word 0xd094a000  ! 3037: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	.word 0x87802074  ! 3038: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r25
	.word 0xd4b78e80  ! 3040: STHA_R	stha	%r10, [%r30 + %r0] 0x74
	mov	0x3c0, %r21
	.word 0xda84c400  ! 3042: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r13
	.word 0x87802073  ! 3043: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4d76000  ! 3044: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0xdac7ce40  ! 3045: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r13
	mov	0x48, %r16
	mov	0x18, %r19
	mov	0x7d0, %r21
	.word 0x8780204f  ! 3049: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bfe000  ! 3050: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd8bf6000  ! 3051: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd8b7e000  ! 3052: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	mov	0x8, %r18
	.word 0xd29f0e60  ! 3054: LDDA_R	ldda	[%r28, %r0] 0x73, %r9
	.word 0xd6bf2000  ! 3055: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 3056: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r18
	mov	0x78, %r25
	.word 0xd6aca000  ! 3059: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 3060: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3061: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d0, %r21
	.word 0xdabf0e60  ! 3063: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	.word 0xdcb78e40  ! 3064: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xd2b40400  ! 3065: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0xdcbf0e80  ! 3066: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	.word 0x87802020  ! 3067: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3068: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebe49e0  ! 3069: STDA_R	stda	%r15, [%r25 + %r0] 0x4f
	.word 0xd0bf8e40  ! 3070: STDA_R	stda	%r8, [%r30 + %r0] 0x72
	.word 0xdaf42000  ! 3071: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 3072: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2afce60  ! 3073: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	.word 0xdeb689e0  ! 3074: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	.word 0xd8df8e60  ! 3075: LDXA_R	ldxa	[%r30, %r0] 0x73, %r12
	.word 0xd4b7ce60  ! 3076: STHA_R	stha	%r10, [%r31 + %r0] 0x73
	.word 0xdaf78e60  ! 3077: STXA_R	stxa	%r13, [%r30 + %r0] 0x73
	.word 0x87802020  ! 3078: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c74e80  ! 3079: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r9
	.word 0xd286e000  ! 3080: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r9
	mov	0x7c0, %r21
	.word 0xd2a62000  ! 3082: STWA_I	stwa	%r9, [%r24 + 0x0000] %asi
	.word 0xd4d70e40  ! 3083: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r10
	.word 0xd0de2000  ! 3084: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r8
	.word 0x87802020  ! 3085: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r22
	.word 0xde978e40  ! 3087: LDUHA_R	lduha	[%r30, %r0] 0x72, %r15
	.word 0xdaf52000  ! 3088: STXA_I	stxa	%r13, [%r20 + 0x0000] %asi
	mov	0x78, %r25
	.word 0xda8d2000  ! 3090: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r13
	.word 0xd0d40400  ! 3091: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	.word 0xdea584a0  ! 3092: STWA_R	stwa	%r15, [%r22 + %r0] 0x25
	.word 0xd8b5e000  ! 3093: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	.word 0xd88de000  ! 3094: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r12
	.word 0xdcdc0400  ! 3095: LDXA_R	ldxa	[%r16, %r0] 0x20, %r14
	.word 0xd4a7ce80  ! 3096: STWA_R	stwa	%r10, [%r31 + %r0] 0x74
	.word 0xd8df4e60  ! 3097: LDXA_R	ldxa	[%r29, %r0] 0x73, %r12
	.word 0xdcaf8e60  ! 3098: STBA_R	stba	%r14, [%r30 + %r0] 0x73
	.word 0xd6f5e000  ! 3099: STXA_I	stxa	%r11, [%r23 + 0x0000] %asi
	.word 0xd08f4e60  ! 3100: LDUBA_R	lduba	[%r29, %r0] 0x73, %r8
	mov	0x7e0, %r21
	mov	0x60, %r24
	.word 0xdc8d44a0  ! 3103: LDUBA_R	lduba	[%r21, %r0] 0x25, %r14
	.word 0xdccfce40  ! 3104: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r14
	.word 0xd2a7ce40  ! 3105: STWA_R	stwa	%r9, [%r31 + %r0] 0x72
	mov	0x58, %r19
	mov	0x7c0, %r21
	.word 0xdcb7ce80  ! 3108: STHA_R	stha	%r14, [%r31 + %r0] 0x74
	.word 0xd2a5e000  ! 3109: STWA_I	stwa	%r9, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 3110: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r24
	.word 0xd6ddc4a0  ! 3112: LDXA_R	ldxa	[%r23, %r0] 0x25, %r11
	mov	0x3d8, %r20
	.word 0xd8b78e80  ! 3114: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	.word 0xd08da000  ! 3115: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r8
	.word 0xd8dc8400  ! 3116: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0x87802072  ! 3117: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0ad04a0  ! 3118: STBA_R	stba	%r8, [%r20 + %r0] 0x25
	.word 0xd6f46000  ! 3119: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 3120: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6bf2000  ! 3121: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd6c76000  ! 3122: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6b72000  ! 3123: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 3124: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6c544a0  ! 3125: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r11
	.word 0xd28c2000  ! 3126: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xd2cca000  ! 3127: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2f4c400  ! 3128: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x28, %r26
	mov	0x70, %r27
	.word 0xde9c2000  ! 3132: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	mov	0x48, %r16
	.word 0xd29c4400  ! 3134: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	mov	0x40, %r16
	mov	0x7f8, %r20
	mov	0x7d0, %r21
	.word 0xd0f46000  ! 3138: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xd8bc4400  ! 3139: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0x87802073  ! 3140: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdadf4e60  ! 3141: LDXA_R	ldxa	[%r29, %r0] 0x73, %r13
	.word 0xde874e40  ! 3142: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r15
	.word 0xd8bca000  ! 3143: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd8aca000  ! 3144: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	mov	0x3c0, %r20
	.word 0xdaafce60  ! 3146: STBA_R	stba	%r13, [%r31 + %r0] 0x73
	mov	0x8, %r17
	.word 0xdecce000  ! 3148: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	.word 0xde8ce000  ! 3149: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 3150: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 3151: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4bf4e40  ! 3152: STDA_R	stda	%r10, [%r29 + %r0] 0x72
	.word 0xd28c8400  ! 3153: LDUBA_R	lduba	[%r18, %r0] 0x20, %r9
	mov	0x3c8, %r23
	.word 0xdcde89e0  ! 3155: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r14
	.word 0x87802074  ! 3156: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r21
	.word 0xd4cee000  ! 3158: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r10
	.word 0xdecf4e60  ! 3159: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r15
	.word 0xdeaee000  ! 3160: STBA_I	stba	%r15, [%r27 + 0x0000] %asi
	.word 0xde9e2000  ! 3161: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r15
	.word 0xdec62000  ! 3162: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r15
	.word 0xdeaea000  ! 3163: STBA_I	stba	%r15, [%r26 + 0x0000] %asi
	.word 0xdedcc400  ! 3164: LDXA_R	ldxa	[%r19, %r0] 0x20, %r15
	mov	0x50, %r18
	.word 0xd49e2000  ! 3166: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r10
	mov	0x3d0, %r21
	mov	0x3c0, %r23
	.word 0xd48ea000  ! 3169: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r10
	.word 0xd4aea000  ! 3170: STBA_I	stba	%r10, [%r26 + 0x0000] %asi
	mov	0x10, %r25
	.word 0x8780204f  ! 3172: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 3173: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r17
	.word 0xd4cc6000  ! 3175: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	.word 0xd89c8400  ! 3176: LDDA_R	ldda	[%r18, %r0] 0x20, %r12
	.word 0xd4cce000  ! 3177: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	mov	0x7d0, %r20
	.word 0x8780204f  ! 3179: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 3180: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4d6c9e0  ! 3181: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r10
	mov	0x18, %r18
	.word 0xdadf2000  ! 3183: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0xdc8f8e40  ! 3184: LDUBA_R	lduba	[%r30, %r0] 0x72, %r14
	.word 0xdcb70e60  ! 3185: STHA_R	stha	%r14, [%r28 + %r0] 0x73
	.word 0x87802020  ! 3186: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f4c400  ! 3187: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	mov	0x7f0, %r23
	.word 0xd8bf2000  ! 3189: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 3190: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd8cec9e0  ! 3192: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r12
	mov	0x30, %r27
	.word 0xd09609e0  ! 3194: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r8
	.word 0xdcad84a0  ! 3195: STBA_R	stba	%r14, [%r22 + %r0] 0x25
	.word 0xdc8e2000  ! 3196: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r14
	.word 0xdac5c4a0  ! 3197: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r13
	.word 0x87802025  ! 3198: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c8, %r20
	mov	0x58, %r27
	.word 0xd2b72000  ! 3201: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xdcbe49e0  ! 3202: STDA_R	stda	%r14, [%r25 + %r0] 0x4f
	.word 0x87802073  ! 3203: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b5a000  ! 3204: STHA_I	stha	%r9, [%r22 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xdad48400  ! 3206: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	mov	0x8, %r27
	.word 0x87802020  ! 3208: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebfe000  ! 3209: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	mov	0x7f8, %r20
	.word 0xde9f2000  ! 3211: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xd69fce40  ! 3212: LDDA_R	ldda	[%r31, %r0] 0x72, %r11
	.word 0xde9c0400  ! 3213: LDDA_R	ldda	[%r16, %r0] 0x20, %r15
	mov	0x7c8, %r20
	.word 0xd68f4e40  ! 3215: LDUBA_R	lduba	[%r29, %r0] 0x72, %r11
	.word 0xd8a504a0  ! 3216: STWA_R	stwa	%r12, [%r20 + %r0] 0x25
	.word 0xd2c78e80  ! 3217: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r9
	.word 0x87802020  ! 3218: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r22
	mov	0x7f8, %r21
	.word 0xdcd48400  ! 3221: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	.word 0xd2bce000  ! 3222: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xd2a4a000  ! 3223: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xd2f46000  ! 3225: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xdaac4400  ! 3226: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	.word 0xdcdcc400  ! 3227: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	.word 0xd2a42000  ! 3228: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	mov	0x68, %r17
	.word 0xd0a78e40  ! 3230: STWA_R	stwa	%r8, [%r30 + %r0] 0x72
	mov	0x68, %r25
	.word 0xdccce000  ! 3232: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r14
	.word 0xd095c4a0  ! 3233: LDUHA_R	lduha	[%r23, %r0] 0x25, %r8
	.word 0xd48c2000  ! 3234: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r10
	.word 0xd4d42000  ! 3235: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	.word 0xd89c4400  ! 3236: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	.word 0x87802020  ! 3237: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r18
	mov	0x30, %r26
	.word 0xdcb70e60  ! 3240: STHA_R	stha	%r14, [%r28 + %r0] 0x73
	.word 0xd29de000  ! 3241: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r9
	.word 0xd2b56000  ! 3242: STHA_I	stha	%r9, [%r21 + 0x0000] %asi
	.word 0x87802074  ! 3243: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 3244: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0c504a0  ! 3245: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r8
	.word 0xd2b48400  ! 3246: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 3247: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b40400  ! 3248: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xd4df4e80  ! 3249: LDXA_R	ldxa	[%r29, %r0] 0x74, %r10
	mov	0x7c0, %r23
	mov	0x3e0, %r21
	.word 0xd0d4c400  ! 3252: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	.word 0xd6c6c9e0  ! 3253: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r11
	.word 0xd6d74e80  ! 3254: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r11
	mov	0x7c0, %r22
	.word 0xd28da000  ! 3256: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r9
	.word 0x87802072  ! 3257: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 3258: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 3259: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r16
	.word 0xd8dcc400  ! 3261: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	.word 0xd09f4e60  ! 3262: LDDA_R	ldda	[%r29, %r0] 0x73, %r8
	.word 0xdc9c2000  ! 3263: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r14
	.word 0xdca4a000  ! 3264: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 3265: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r19
	.word 0xdcb4a000  ! 3267: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 3268: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 3269: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca42000  ! 3270: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	mov	0x3e0, %r23
	.word 0xdeae09e0  ! 3272: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	mov	0x0, %r17
	.word 0xd0ac6000  ! 3274: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0xd0a4e000  ! 3275: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd2de49e0  ! 3276: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r9
	.word 0xd6b4c400  ! 3277: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xd8af0e80  ! 3278: STBA_R	stba	%r12, [%r28 + %r0] 0x74
	.word 0xd6dce000  ! 3279: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	mov	0x3d8, %r21
	.word 0xd6c4e000  ! 3281: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r11
	.word 0xd8de49e0  ! 3282: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r12
	.word 0xdef649e0  ! 3283: STXA_R	stxa	%r15, [%r25 + %r0] 0x4f
	.word 0x8780204f  ! 3284: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 3285: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r18
	.word 0x87802074  ! 3287: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b76000  ! 3288: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xda8f4e80  ! 3289: LDUBA_R	lduba	[%r29, %r0] 0x74, %r13
	.word 0xd0976000  ! 3290: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd4d78e40  ! 3291: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r10
	.word 0xd09fce60  ! 3292: LDDA_R	ldda	[%r31, %r0] 0x73, %r8
	.word 0xdef72000  ! 3293: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 3294: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ae09e0  ! 3295: STBA_R	stba	%r11, [%r24 + %r0] 0x4f
	.word 0xd8b504a0  ! 3296: STHA_R	stha	%r12, [%r20 + %r0] 0x25
	.word 0x8780204f  ! 3297: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc9e89e0  ! 3298: LDDA_R	ldda	[%r26, %r0] 0x4f, %r14
	mov	0x3c0, %r21
	.word 0xdeafce80  ! 3300: STBA_R	stba	%r15, [%r31 + %r0] 0x74
	mov	0x7e0, %r23
	.word 0x87802072  ! 3302: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8f40400  ! 3303: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0x87802072  ! 3304: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdecf2000  ! 3305: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xdebfe000  ! 3306: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xded7a000  ! 3307: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	mov	0x0, %r25
	.word 0xde8fe000  ! 3309: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3310: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r26
	.word 0xdaf48400  ! 3312: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xdeaf8e80  ! 3313: STBA_R	stba	%r15, [%r30 + %r0] 0x74
	.word 0xd6af0e40  ! 3314: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	mov	0x7c8, %r23
	.word 0xdab649e0  ! 3316: STHA_R	stha	%r13, [%r25 + %r0] 0x4f
	mov	0x38, %r19
	.word 0x87802025  ! 3318: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 3319: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d8, %r20
	.word 0xd2a609e0  ! 3321: STWA_R	stwa	%r9, [%r24 + %r0] 0x4f
	.word 0xd6f4c400  ! 3322: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	mov	0x7d0, %r20
	mov	0x40, %r27
	.word 0xdecc2000  ! 3325: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	.word 0xde9ca000  ! 3326: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	.word 0xdc8c8400  ! 3327: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0x87802072  ! 3328: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa7a000  ! 3329: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xda8f6000  ! 3330: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0x87802072  ! 3331: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 3332: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdadd2000  ! 3333: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r13
	.word 0xde970e60  ! 3334: LDUHA_R	lduha	[%r28, %r0] 0x73, %r15
	mov	0x28, %r16
	mov	0x8, %r27
	.word 0x87802073  ! 3337: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb72000  ! 3338: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xdea7a000  ! 3339: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xdec72000  ! 3340: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	mov	0x48, %r16
	.word 0xdeb72000  ! 3342: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0xdcbd84a0  ! 3344: STDA_R	stda	%r14, [%r22 + %r0] 0x25
	mov	0x28, %r25
	.word 0xd297a000  ! 3346: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	.word 0xdaf48400  ! 3347: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xd0b7a000  ! 3348: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	mov	0x58, %r27
	.word 0xdc9d44a0  ! 3350: LDDA_R	ldda	[%r21, %r0] 0x25, %r14
	.word 0xdccf2000  ! 3351: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xd8b4c400  ! 3352: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	mov	0x3d8, %r23
	.word 0x87802020  ! 3354: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d4a000  ! 3355: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xd8c4a000  ! 3356: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r12
	mov	0x7e8, %r20
	mov	0x7d8, %r20
	mov	0x58, %r16
	mov	0x78, %r26
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd8c4e000  ! 3362: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	.word 0xd89c6000  ! 3363: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r12
	.word 0x87802072  ! 3364: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a72000  ! 3365: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd6c5c4a0  ! 3366: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r11
	.word 0x87802074  ! 3367: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc9c8400  ! 3368: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0xd0c44400  ! 3369: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r8
	mov	0x50, %r17
	mov	0x20, %r27
	mov	0x7d0, %r21
	mov	0x10, %r27
	.word 0xd29f6000  ! 3374: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xd2a76000  ! 3375: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd8b7ce40  ! 3376: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0xde86c9e0  ! 3377: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r15
	.word 0xd2b609e0  ! 3378: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	.word 0xd0a7a000  ! 3379: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	mov	0x58, %r26
	.word 0xd6840400  ! 3381: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdec40400  ! 3383: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd8b72000  ! 3385: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd4a74e60  ! 3386: STWA_R	stwa	%r10, [%r29 + %r0] 0x73
	mov	0x18, %r27
	mov	0x30, %r25
	.word 0x87802072  ! 3389: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf5a000  ! 3390: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xdaad2000  ! 3391: STBA_I	stba	%r13, [%r20 + 0x0000] %asi
	mov	0x8, %r25
	.word 0x87802072  ! 3393: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r17
	.word 0xda8de000  ! 3395: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r13
	.word 0xdca70e60  ! 3396: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	mov	0x7e0, %r22
	.word 0x87802025  ! 3398: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd89ee000  ! 3399: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r12
	.word 0x87802073  ! 3400: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc8649e0  ! 3401: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r14
	.word 0xd2bde000  ! 3402: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	.word 0xd8a40400  ! 3403: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0xda978e40  ! 3404: LDUHA_R	lduha	[%r30, %r0] 0x72, %r13
	.word 0xd6b5a000  ! 3405: STHA_I	stha	%r11, [%r22 + 0x0000] %asi
	.word 0x87802073  ! 3406: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f649e0  ! 3407: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	.word 0xd6f56000  ! 3408: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	.word 0xd0a40400  ! 3409: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	mov	0x7c8, %r21
	.word 0xd8a4c400  ! 3411: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xdcbd44a0  ! 3412: STDA_R	stda	%r14, [%r21 + %r0] 0x25
	mov	0x70, %r19
	.word 0xd2ade000  ! 3414: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0xd09cc400  ! 3415: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	.word 0xdc852000  ! 3416: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r14
	mov	0x78, %r16
	.word 0xdcf56000  ! 3418: STXA_I	stxa	%r14, [%r21 + 0x0000] %asi
	.word 0xdcdda000  ! 3419: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r14
	mov	0x8, %r16
	.word 0xdcb5a000  ! 3421: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0xd2bf8e80  ! 3422: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	mov	0x28, %r24
	.word 0xd8d70e60  ! 3424: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r12
	.word 0xd6844400  ! 3425: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r11
	.word 0xd48649e0  ! 3426: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r10
	.word 0xd8b56000  ! 3427: STHA_I	stha	%r12, [%r21 + 0x0000] %asi
	.word 0xd8f56000  ! 3428: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	.word 0x87802025  ! 3429: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcc5c4a0  ! 3430: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r14
	.word 0xd2b7e000  ! 3431: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2f7a000  ! 3432: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xd28fa000  ! 3434: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	mov	0x50, %r18
	.word 0xd4a70e80  ! 3436: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	.word 0xd0978e40  ! 3437: LDUHA_R	lduha	[%r30, %r0] 0x72, %r8
	.word 0xdcbf2000  ! 3438: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdcd72000  ! 3439: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xdca7e000  ! 3440: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcbf2000  ! 3441: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	mov	0x7f0, %r22
	mov	0x68, %r18
	.word 0xdcc72000  ! 3444: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	mov	0x20, %r26
	.word 0xdcbfe000  ! 3446: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 3447: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8a74e60  ! 3448: STWA_R	stwa	%r12, [%r29 + %r0] 0x73
	mov	0x8, %r17
	.word 0xdac649e0  ! 3450: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r13
	.word 0xde97ce60  ! 3451: LDUHA_R	lduha	[%r31, %r0] 0x73, %r15
	.word 0xda9fe000  ! 3452: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xdacf2000  ! 3453: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xdab76000  ! 3454: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	mov	0x38, %r25
	.word 0xd68f4e60  ! 3456: LDUBA_R	lduba	[%r29, %r0] 0x73, %r11
	.word 0xd6f74e40  ! 3457: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	mov	0x8, %r25
	.word 0xdcf72000  ! 3459: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0x87802020  ! 3461: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r26
	mov	0x3c0, %r23
	.word 0x87802020  ! 3464: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r16
	.word 0x87802020  ! 3466: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r16
	.word 0xd8978e60  ! 3468: LDUHA_R	lduha	[%r30, %r0] 0x73, %r12
	.word 0x8780204f  ! 3469: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2af2000  ! 3470: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	mov	0x30, %r27
	.word 0xdccec9e0  ! 3472: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r14
	.word 0x87802073  ! 3473: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2c42000  ! 3474: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	mov	0x10, %r16
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2c4a000  ! 3477: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	.word 0xd2f4a000  ! 3478: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	mov	0x7f8, %r22
	.word 0xd2d46000  ! 3480: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	.word 0xd29ce000  ! 3481: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xd4ac0400  ! 3482: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	mov	0x50, %r16
	.word 0xda8c2000  ! 3484: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r13
	.word 0x87802073  ! 3485: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6dfce40  ! 3486: LDXA_R	ldxa	[%r31, %r0] 0x72, %r11
	.word 0xd8a4c400  ! 3487: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xdad5c4a0  ! 3488: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r13
	.word 0xde8c0400  ! 3489: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	mov	0x20, %r19
	.word 0xd8c44400  ! 3491: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r12
	.word 0xdea74e80  ! 3492: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	mov	0x3c0, %r23
	mov	0x78, %r26
	.word 0xd6b5c4a0  ! 3495: STHA_R	stha	%r11, [%r23 + %r0] 0x25
	mov	0x78, %r26
	.word 0xd4c46000  ! 3497: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r10
	.word 0xd4ace000  ! 3498: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0xd4ace000  ! 3499: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0xd4dc2000  ! 3500: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	.word 0xd8940400  ! 3501: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	.word 0xdaa7ce40  ! 3502: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	.word 0x87802073  ! 3503: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0c609e0  ! 3504: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r8
	mov	0x30, %r25
	.word 0xdadde000  ! 3506: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r13
	mov	0x10, %r19
	.word 0xdcf78e60  ! 3508: STXA_R	stxa	%r14, [%r30 + %r0] 0x73
	.word 0xd6a78e40  ! 3509: STWA_R	stwa	%r11, [%r30 + %r0] 0x72
	ta	T_CHANGE_PRIV	! macro
	.word 0xd6a52000  ! 3511: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	mov	0x48, %r27
	mov	0x58, %r19
	.word 0xdad44400  ! 3514: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	mov	0x40, %r17
	mov	0x68, %r19
	mov	0x68, %r17
	mov	0x7d0, %r21
	.word 0xd6d4c400  ! 3519: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	.word 0xdaafce60  ! 3520: STBA_R	stba	%r13, [%r31 + %r0] 0x73
	.word 0x87802072  ! 3521: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf76000  ! 3522: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x7c0, %r23
	mov	0x8, %r17
	.word 0xdc9f2000  ! 3525: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	mov	0x10, %r26
	.word 0xd6f689e0  ! 3527: STXA_R	stxa	%r11, [%r26 + %r0] 0x4f
	.word 0xdedfa000  ! 3528: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xdea7e000  ! 3529: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xdaf504a0  ! 3530: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	.word 0xd0d7e000  ! 3531: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0a74e80  ! 3532: STWA_R	stwa	%r8, [%r29 + %r0] 0x74
	mov	0x70, %r16
	.word 0x87802072  ! 3534: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b7e000  ! 3535: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2c76000  ! 3536: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0xd28fe000  ! 3537: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	.word 0xd2bec9e0  ! 3538: STDA_R	stda	%r9, [%r27 + %r0] 0x4f
	.word 0xdac4c400  ! 3539: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r13
	.word 0x87802074  ! 3540: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d8, %r21
	.word 0xdcc44400  ! 3542: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	mov	0x50, %r25
	.word 0xd29de000  ! 3544: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r9
	mov	0x3e8, %r22
	mov	0x10, %r24
	.word 0xd2bda000  ! 3547: STDA_I	stda	%r9, [%r22 + 0x0000] %asi
	mov	0x30, %r18
	mov	0x7f8, %r22
	.word 0x8780204f  ! 3550: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd286e000  ! 3551: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r9
	mov	0x58, %r19
	.word 0xd2ce6000  ! 3553: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r9
	.word 0xdacf4e40  ! 3554: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r13
	.word 0xdcd7ce80  ! 3555: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r14
	.word 0xdaf74e40  ! 3556: STXA_R	stxa	%r13, [%r29 + %r0] 0x72
	.word 0xd2962000  ! 3557: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r9
	.word 0xd2f6e000  ! 3558: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	.word 0xd2962000  ! 3559: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r9
	.word 0xd8dd84a0  ! 3560: LDXA_R	ldxa	[%r22, %r0] 0x25, %r12
	.word 0x87802074  ! 3561: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e8, %r21
	.word 0x87802073  ! 3563: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8cfce80  ! 3564: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r12
	.word 0xd8cc4400  ! 3565: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r12
	.word 0xdacce000  ! 3566: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r13
	.word 0xdaaca000  ! 3567: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0xdca544a0  ! 3568: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0xdad78e40  ! 3569: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r13
	.word 0xdacf0e60  ! 3570: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r13
	mov	0x30, %r27
	.word 0xdeace000  ! 3572: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	mov	0x10, %r27
	.word 0x8780204f  ! 3574: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdef7e000  ! 3575: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xde872000  ! 3576: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xd48f8e60  ! 3577: LDUBA_R	lduba	[%r30, %r0] 0x73, %r10
	mov	0x20, %r27
	.word 0xdab74e80  ! 3579: STHA_R	stha	%r13, [%r29 + %r0] 0x74
	.word 0x87802073  ! 3580: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r17
	.word 0xd6b689e0  ! 3582: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	mov	0x3f8, %r23
	.word 0xd6870e80  ! 3584: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r11
	.word 0xd6876000  ! 3585: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	.word 0xd68f2000  ! 3586: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xd6afa000  ! 3587: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x68, %r18
	.word 0x87802020  ! 3589: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3590: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r24
	.word 0x87802073  ! 3592: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f70e60  ! 3593: STXA_R	stxa	%r9, [%r28 + %r0] 0x73
	.word 0xd6c6a000  ! 3594: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r11
	.word 0xd696e000  ! 3595: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	.word 0xdca74e60  ! 3596: STWA_R	stwa	%r14, [%r29 + %r0] 0x73
	.word 0xd0a6e000  ! 3597: STWA_I	stwa	%r8, [%r27 + 0x0000] %asi
	.word 0x8780204f  ! 3598: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0cce000  ! 3599: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0f46000  ! 3600: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0ac2000  ! 3601: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	mov	0x3d0, %r22
	mov	0x58, %r18
	.word 0xd2ac0400  ! 3604: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	mov	0x70, %r24
	mov	0x8, %r17
	.word 0xdeb4a000  ! 3607: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0xdedc2000  ! 3608: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3609: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r17
	.word 0x87802025  ! 3611: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde84a000  ! 3612: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 3613: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeafa000  ! 3614: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xde8f2000  ! 3615: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xdedf2000  ! 3616: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xde8f2000  ! 3617: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	mov	0x3d0, %r23
	.word 0xde9fa000  ! 3619: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	.word 0x87802072  ! 3620: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6af4e80  ! 3621: STBA_R	stba	%r11, [%r29 + %r0] 0x74
	mov	0x3f8, %r22
	.word 0xd4bfa000  ! 3623: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	mov	0x68, %r24
	.word 0xd487e000  ! 3625: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	mov	0x50, %r26
	.word 0xdaadc4a0  ! 3627: STBA_R	stba	%r13, [%r23 + %r0] 0x25
	.word 0xd2a7e000  ! 3628: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xd6c5c4a0  ! 3629: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r11
	.word 0x87802020  ! 3630: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69649e0  ! 3631: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r11
	.word 0xdedc6000  ! 3632: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r15
	.word 0xd4b504a0  ! 3633: STHA_R	stha	%r10, [%r20 + %r0] 0x25
	.word 0xdea42000  ! 3634: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xd2f44400  ! 3635: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	.word 0xd6942000  ! 3636: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r11
	.word 0xda9e49e0  ! 3637: LDDA_R	ldda	[%r25, %r0] 0x4f, %r13
	.word 0xd487ce40  ! 3638: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r10
	mov	0x50, %r25
	mov	0x3c0, %r20
	.word 0xdcd4e000  ! 3641: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	.word 0xdcc46000  ! 3642: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r14
	.word 0xdc84e000  ! 3643: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r14
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802025  ! 3645: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r26
	.word 0x87802072  ! 3647: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3648: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69f0e60  ! 3649: LDDA_R	ldda	[%r28, %r0] 0x73, %r11
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6a44400  ! 3651: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0xd4de6000  ! 3652: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r10
	.word 0xd4bea000  ! 3653: STDA_I	stda	%r10, [%r26 + 0x0000] %asi
	.word 0xd0a649e0  ! 3654: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	.word 0xde970e80  ! 3655: LDUHA_R	lduha	[%r28, %r0] 0x74, %r15
	.word 0x87802073  ! 3656: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdac4a000  ! 3657: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	.word 0x87802073  ! 3658: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdab42000  ! 3659: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0x87802020  ! 3661: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 3662: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda97a000  ! 3663: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xd4ae49e0  ! 3664: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	mov	0x60, %r17
	.word 0xd6ce09e0  ! 3666: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r11
	.word 0xdebfa000  ! 3667: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xded70e40  ! 3668: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r15
	.word 0xd0bf2000  ! 3669: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xda9c4400  ! 3670: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	mov	0x58, %r27
	mov	0x10, %r18
	.word 0xdad7ce80  ! 3673: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r13
	.word 0xd6b7a000  ! 3674: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd6bfa000  ! 3675: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd6bfe000  ! 3676: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 3677: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r17
	mov	0x7f8, %r22
	mov	0x3f8, %r23
	.word 0xd68fe000  ! 3681: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xd2bc0400  ! 3682: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xda9fe000  ! 3683: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	mov	0x10, %r19
	.word 0xdcf584a0  ! 3685: STXA_R	stxa	%r14, [%r22 + %r0] 0x25
	.word 0xdcbcc400  ! 3686: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xd887e000  ! 3687: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0xdab7ce60  ! 3688: STHA_R	stha	%r13, [%r31 + %r0] 0x73
	.word 0xd8b48400  ! 3689: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	mov	0x3f0, %r21
	.word 0xd8a7a000  ! 3691: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	mov	0x3e0, %r23
	.word 0x87802072  ! 3693: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a72000  ! 3694: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd09dc4a0  ! 3695: LDDA_R	ldda	[%r23, %r0] 0x25, %r8
	.word 0x8780204f  ! 3696: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdad4a000  ! 3697: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0xdc8d84a0  ! 3698: LDUBA_R	lduba	[%r22, %r0] 0x25, %r14
	mov	0x38, %r26
	.word 0x87802074  ! 3700: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca52000  ! 3701: STWA_I	stwa	%r14, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 3702: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcaf2000  ! 3703: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdcbfa000  ! 3704: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdcb70e80  ! 3705: STHA_R	stha	%r14, [%r28 + %r0] 0x74
	mov	0x50, %r19
	.word 0x87802020  ! 3707: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a5c4a0  ! 3708: STWA_R	stwa	%r9, [%r23 + %r0] 0x25
	.word 0xd6de89e0  ! 3709: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r11
	mov	0x70, %r27
	.word 0xd8bc4400  ! 3711: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 3712: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2870e40  ! 3713: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r9
	.word 0xde8ca000  ! 3714: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	mov	0x30, %r16
	.word 0xd0af8e40  ! 3716: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0x87802020  ! 3717: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3718: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebd04a0  ! 3719: STDA_R	stda	%r15, [%r20 + %r0] 0x25
	.word 0xdaa46000  ! 3720: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	.word 0xdad70e60  ! 3721: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r13
	.word 0xdeac4400  ! 3722: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0x87802073  ! 3723: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 3724: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd49d84a0  ! 3725: LDDA_R	ldda	[%r22, %r0] 0x25, %r10
	.word 0xd0c7a000  ! 3726: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xd6cd44a0  ! 3727: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r11
	.word 0xdebf8e80  ! 3728: STDA_R	stda	%r15, [%r30 + %r0] 0x74
	.word 0xd0dfe000  ! 3729: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0c7a000  ! 3730: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xd08f6000  ! 3731: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r8
	.word 0xd0dfe000  ! 3732: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xd09cc400  ! 3733: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	.word 0xd0af6000  ! 3734: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd0df2000  ! 3736: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	mov	0x3d8, %r22
	mov	0x3c8, %r22
	mov	0x3c8, %r22
	.word 0xd8d74e60  ! 3740: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r12
	.word 0xd0f4c400  ! 3741: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0xdccf4e80  ! 3742: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r14
	.word 0xdacfe000  ! 3743: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	mov	0x8, %r17
	.word 0x87802072  ! 3745: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf76000  ! 3746: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xd6a40400  ! 3747: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0xd0c7a000  ! 3748: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	mov	0x3e8, %r20
	.word 0xd0b44400  ! 3750: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xd6c7a000  ! 3751: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3752: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r24
	mov	0x40, %r27
	.word 0xdcb74e80  ! 3755: STHA_R	stha	%r14, [%r29 + %r0] 0x74
	mov	0x3c0, %r22
	.word 0xd0f74e40  ! 3757: STXA_R	stxa	%r8, [%r29 + %r0] 0x72
	.word 0xdabc2000  ! 3758: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xd4844400  ! 3759: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0x87802025  ! 3760: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdac40400  ! 3761: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	.word 0xdc870e60  ! 3762: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r14
	.word 0xd4af8e60  ! 3763: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	mov	0x0, %r24
	.word 0xd2bf2000  ! 3765: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xd2872000  ! 3767: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802020  ! 3769: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdecd04a0  ! 3770: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r15
	.word 0xd2a689e0  ! 3771: STWA_R	stwa	%r9, [%r26 + %r0] 0x4f
	.word 0xdebf6000  ! 3772: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 3773: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdadfce40  ! 3774: LDXA_R	ldxa	[%r31, %r0] 0x72, %r13
	.word 0xd284e000  ! 3775: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r9
	.word 0xd8afce80  ! 3776: STBA_R	stba	%r12, [%r31 + %r0] 0x74
	.word 0xdaa5c4a0  ! 3777: STWA_R	stwa	%r13, [%r23 + %r0] 0x25
	mov	0x3c0, %r21
	mov	0x18, %r19
	mov	0x30, %r19
	mov	0x40, %r17
	.word 0xde9ce000  ! 3782: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	mov	0x20, %r24
	.word 0xdabe89e0  ! 3784: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	.word 0xd6ce49e0  ! 3785: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r11
	.word 0x87802020  ! 3786: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3787: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa76000  ! 3788: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	mov	0x48, %r16
	mov	0x7c0, %r20
	.word 0x87802020  ! 3791: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9f2000  ! 3792: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xd495c4a0  ! 3793: LDUHA_R	lduha	[%r23, %r0] 0x25, %r10
	.word 0xd0b44400  ! 3794: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xd2f7e000  ! 3795: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd0ae09e0  ! 3796: STBA_R	stba	%r8, [%r24 + %r0] 0x4f
	.word 0xdecfa000  ! 3797: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xda948400  ! 3798: LDUHA_R	lduha	[%r18, %r0] 0x20, %r13
	.word 0xd0c72000  ! 3799: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xd097a000  ! 3800: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	mov	0x0, %r25
	.word 0xda8d84a0  ! 3802: LDUBA_R	lduba	[%r22, %r0] 0x25, %r13
	.word 0xdab4c400  ! 3803: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xd6c72000  ! 3804: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6bf0e60  ! 3805: STDA_R	stda	%r11, [%r28 + %r0] 0x73
	mov	0x30, %r17
	.word 0x87802072  ! 3807: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcafe000  ! 3808: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xd89c4400  ! 3809: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	mov	0x3e0, %r21
	.word 0xd89fa000  ! 3811: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	.word 0xd68d44a0  ! 3812: LDUBA_R	lduba	[%r21, %r0] 0x25, %r11
	.word 0xd4b76000  ! 3813: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xdaf48400  ! 3814: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xd8ae09e0  ! 3815: STBA_R	stba	%r12, [%r24 + %r0] 0x4f
	.word 0xdeb70e60  ! 3816: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	.word 0x87802072  ! 3817: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa584a0  ! 3818: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	.word 0x87802020  ! 3819: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a544a0  ! 3820: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	mov	0x48, %r27
	.word 0xd0bf8e40  ! 3822: STDA_R	stda	%r8, [%r30 + %r0] 0x72
	mov	0x7e8, %r21
	mov	0x58, %r17
	.word 0xdc948400  ! 3825: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	.word 0xd0b5c4a0  ! 3826: STHA_R	stha	%r8, [%r23 + %r0] 0x25
	.word 0xd894c400  ! 3827: LDUHA_R	lduha	[%r19, %r0] 0x20, %r12
	.word 0xdccec9e0  ! 3828: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r14
	.word 0xde978e80  ! 3829: LDUHA_R	lduha	[%r30, %r0] 0x74, %r15
	.word 0xdea62000  ! 3830: STWA_I	stwa	%r15, [%r24 + 0x0000] %asi
	.word 0xde9d04a0  ! 3831: LDDA_R	ldda	[%r20, %r0] 0x25, %r15
	.word 0xd28ea000  ! 3832: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r9
	mov	0x78, %r24
	.word 0x87802025  ! 3834: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e8, %r22
	mov	0x58, %r17
	.word 0x8780204f  ! 3837: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2cc6000  ! 3838: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	.word 0xd2a46000  ! 3839: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2b4a000  ! 3840: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	mov	0x20, %r26
	.word 0xd2b42000  ! 3842: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xd2c42000  ! 3844: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3845: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ac8400  ! 3846: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xd2f40400  ! 3847: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xdcac2000  ! 3848: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0xd6874e60  ! 3849: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r11
	.word 0xd08f8e60  ! 3850: LDUBA_R	lduba	[%r30, %r0] 0x73, %r8
	.word 0xd8dfce60  ! 3851: LDXA_R	ldxa	[%r31, %r0] 0x73, %r12
	mov	0x40, %r17
	mov	0x20, %r16
	.word 0xd2bce000  ! 3854: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xd2ac2000  ! 3855: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd89689e0  ! 3856: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r12
	.word 0xdaaf8e80  ! 3857: STBA_R	stba	%r13, [%r30 + %r0] 0x74
	.word 0xd4bca000  ! 3858: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 3859: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdac48400  ! 3860: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	.word 0xd4b649e0  ! 3861: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	.word 0x87802074  ! 3862: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bf8e60  ! 3863: STDA_R	stda	%r12, [%r30 + %r0] 0x73
	mov	0x50, %r26
	.word 0xd0df2000  ! 3865: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0a7a000  ! 3866: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3867: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b7e000  ! 3868: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0xd0a72000  ! 3869: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 3870: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda848400  ! 3871: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r13
	mov	0x8, %r25
	.word 0xd8b4c400  ! 3873: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0x87802074  ! 3874: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e8, %r20
	.word 0xd0ace000  ! 3876: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	mov	0x3e8, %r21
	mov	0x7d0, %r20
	.word 0xd08c6000  ! 3879: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0x87802074  ! 3880: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6c70e40  ! 3881: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r11
	.word 0xdcb5a000  ! 3882: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0xdcf5e000  ! 3883: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0xda848400  ! 3884: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r13
	.word 0xd8ac0400  ! 3885: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xdc940400  ! 3886: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0xd4df0e80  ! 3887: LDXA_R	ldxa	[%r28, %r0] 0x74, %r10
	.word 0xd6cde000  ! 3888: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r11
	.word 0xd4d74e80  ! 3889: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r10
	.word 0x87802073  ! 3890: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 3891: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 3892: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r26
	mov	0x68, %r19
	.word 0xdca56000  ! 3895: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	mov	0x3d8, %r22
	mov	0x48, %r16
	.word 0xdca5a000  ! 3898: STWA_I	stwa	%r14, [%r22 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0xd0bc4400  ! 3900: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xda9d2000  ! 3901: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r13
	.word 0xd8ce49e0  ! 3902: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r12
	.word 0xde9f0e40  ! 3903: LDDA_R	ldda	[%r28, %r0] 0x72, %r15
	.word 0xd6bde000  ! 3904: STDA_I	stda	%r11, [%r23 + 0x0000] %asi
	.word 0xd8f609e0  ! 3905: STXA_R	stxa	%r12, [%r24 + %r0] 0x4f
	mov	0x3d0, %r23
	.word 0xdc85a000  ! 3907: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r14
	.word 0xd0cfce40  ! 3908: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r8
	.word 0xd0bcc400  ! 3909: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	mov	0x78, %r19
	.word 0xd4c5e000  ! 3911: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r10
	.word 0xd6d74e60  ! 3912: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r11
	.word 0xd4bde000  ! 3913: STDA_I	stda	%r10, [%r23 + 0x0000] %asi
	.word 0x87802073  ! 3914: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf74e40  ! 3915: STXA_R	stxa	%r13, [%r29 + %r0] 0x72
	.word 0xd4af6000  ! 3916: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xdcbec9e0  ! 3917: STDA_R	stda	%r14, [%r27 + %r0] 0x4f
	.word 0xd4848400  ! 3918: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r10
	mov	0x3f0, %r21
	mov	0x48, %r26
	mov	0x70, %r25
	.word 0xd6b689e0  ! 3922: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	.word 0xd88fce40  ! 3923: LDUBA_R	lduba	[%r31, %r0] 0x72, %r12
	mov	0x3e0, %r22
	.word 0x87802072  ! 3925: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdad56000  ! 3926: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r13
	mov	0x8, %r26
	mov	0x3d8, %r20
	.word 0xdcc40400  ! 3929: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	mov	0x3d0, %r23
	.word 0xd0bd84a0  ! 3931: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0xd49f4e40  ! 3932: LDDA_R	ldda	[%r29, %r0] 0x72, %r10
	mov	0x7c8, %r21
	.word 0xdedde000  ! 3934: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r15
	mov	0x7e0, %r20
	.word 0x8780204f  ! 3936: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd48689e0  ! 3937: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r10
	.word 0xd2c584a0  ! 3938: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r9
	.word 0x87802073  ! 3939: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3940: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a609e0  ! 3941: STWA_R	stwa	%r8, [%r24 + %r0] 0x4f
	.word 0xd2dfe000  ! 3942: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2c72000  ! 3943: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd4a689e0  ! 3944: STWA_R	stwa	%r10, [%r26 + %r0] 0x4f
	.word 0xd4cfa000  ! 3945: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0x87802074  ! 3946: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd89f4e60  ! 3947: LDDA_R	ldda	[%r29, %r0] 0x73, %r12
	.word 0xdca544a0  ! 3948: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0xd2d48400  ! 3949: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	.word 0xdaae2000  ! 3950: STBA_I	stba	%r13, [%r24 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xda8ee000  ! 3952: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r13
	.word 0xda9ea000  ! 3953: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r13
	.word 0xd4a6c9e0  ! 3954: STWA_R	stwa	%r10, [%r27 + %r0] 0x4f
	.word 0xd4a66000  ! 3955: STWA_I	stwa	%r10, [%r25 + 0x0000] %asi
	mov	0x78, %r27
	.word 0xd0f7ce40  ! 3957: STXA_R	stxa	%r8, [%r31 + %r0] 0x72
	mov	0x50, %r25
	mov	0x60, %r19
	.word 0xd8f6c9e0  ! 3960: STXA_R	stxa	%r12, [%r27 + %r0] 0x4f
	.word 0xdc8d84a0  ! 3961: LDUBA_R	lduba	[%r22, %r0] 0x25, %r14
	.word 0xd4de6000  ! 3962: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r10
	.word 0xd4aee000  ! 3963: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	mov	0x20, %r16
	.word 0xd48f4e80  ! 3965: LDUBA_R	lduba	[%r29, %r0] 0x74, %r10
	.word 0xd8f62000  ! 3966: STXA_I	stxa	%r12, [%r24 + 0x0000] %asi
	.word 0xd8be2000  ! 3967: STDA_I	stda	%r12, [%r24 + 0x0000] %asi
	.word 0xd0f7ce40  ! 3968: STXA_R	stxa	%r8, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 3969: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6cf8e60  ! 3970: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r11
	mov	0x28, %r16
	mov	0x38, %r25
	.word 0x87802074  ! 3973: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r16
	.word 0xdc8c4400  ! 3975: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0xdebf2000  ! 3976: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xd4d544a0  ! 3977: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r10
	.word 0xd89c0400  ! 3978: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	mov	0x3c8, %r20
	.word 0xdecf8e80  ! 3980: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r15
	.word 0xdecfe000  ! 3981: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0x87802072  ! 3982: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeaf0e40  ! 3983: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	.word 0xdac7e000  ! 3984: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	mov	0x7c0, %r21
	.word 0xdaafe000  ! 3986: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xd2b48400  ! 3987: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd6f544a0  ! 3988: STXA_R	stxa	%r11, [%r21 + %r0] 0x25
	.word 0x87802020  ! 3989: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r18
	.word 0xd2b4c400  ! 3991: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xdcd66000  ! 3992: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r14
	.word 0xd8d48400  ! 3993: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0x87802072  ! 3994: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3995: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r26
	.word 0xda8fce40  ! 3997: LDUBA_R	lduba	[%r31, %r0] 0x72, %r13
	mov	0x10, %r27
	.word 0x87802073  ! 3999: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r27
	.word 0xd8bc6000  ! 4001: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	mov	0x48, %r17
	.word 0x87802074  ! 4003: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r25
	.word 0xd6f74e40  ! 4005: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	mov	0x8, %r25
	.word 0xdebd6000  ! 4007: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 4008: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc840400  ! 4009: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	.word 0xd88f4e60  ! 4010: LDUBA_R	lduba	[%r29, %r0] 0x73, %r12
	.word 0xd2bf4e60  ! 4011: STDA_R	stda	%r9, [%r29 + %r0] 0x73
	.word 0xdcc504a0  ! 4012: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r14
	.word 0xdabfce60  ! 4013: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	.word 0x87802020  ! 4014: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4015: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a72000  ! 4016: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd68fe000  ! 4017: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xd687a000  ! 4018: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6f76000  ! 4019: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd2f504a0  ! 4020: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	mov	0x40, %r26
	.word 0xd8b74e40  ! 4022: STHA_R	stha	%r12, [%r29 + %r0] 0x72
	mov	0x7d8, %r21
	.word 0xd0dfce80  ! 4024: LDXA_R	ldxa	[%r31, %r0] 0x74, %r8
	.word 0xd2bf6000  ! 4025: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd2a7a000  ! 4026: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xd0a70e80  ! 4027: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0x87802072  ! 4028: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca609e0  ! 4029: STWA_R	stwa	%r14, [%r24 + %r0] 0x4f
	.word 0xdcb76000  ! 4030: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xdcbf2000  ! 4031: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdcd74e60  ! 4032: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r14
	.word 0xd4f7a000  ! 4033: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4d76000  ! 4034: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0xd2bf0e60  ! 4035: STDA_R	stda	%r9, [%r28 + %r0] 0x73
	.word 0xd6cc8400  ! 4036: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	.word 0xdacc8400  ! 4037: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r13
	mov	0x7d0, %r22
	.word 0xd6f78e40  ! 4039: STXA_R	stxa	%r11, [%r30 + %r0] 0x72
	mov	0x28, %r17
	.word 0xd88d44a0  ! 4041: LDUBA_R	lduba	[%r21, %r0] 0x25, %r12
	mov	0x68, %r18
	mov	0x60, %r17
	.word 0xd6cc8400  ! 4044: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	mov	0x38, %r27
	.word 0xd8f78e60  ! 4046: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	mov	0x3e0, %r20
	.word 0x87802025  ! 4048: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 4049: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4050: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28c8400  ! 4051: LDUBA_R	lduba	[%r18, %r0] 0x20, %r9
	.word 0x87802072  ! 4052: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf44400  ! 4053: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0x87802020  ! 4054: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r26
	.word 0xda85e000  ! 4056: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	mov	0x50, %r16
	.word 0xdec5c4a0  ! 4058: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r15
	.word 0xd4852000  ! 4059: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r10
	.word 0xd49d2000  ! 4060: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r10
	.word 0xd2df0e40  ! 4061: LDXA_R	ldxa	[%r28, %r0] 0x72, %r9
	.word 0xd49da000  ! 4062: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r10
	mov	0x28, %r19
	.word 0xd4ade000  ! 4064: STBA_I	stba	%r10, [%r23 + 0x0000] %asi
	mov	0x78, %r24
	.word 0xdef4c400  ! 4066: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xd6b78e80  ! 4067: STHA_R	stha	%r11, [%r30 + %r0] 0x74
	.word 0x87802020  ! 4068: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac78e60  ! 4069: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r13
	.word 0xd4872000  ! 4070: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0xdcf689e0  ! 4071: STXA_R	stxa	%r14, [%r26 + %r0] 0x4f
	.word 0xdef7e000  ! 4072: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 4073: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde872000  ! 4074: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xd8cc0400  ! 4075: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	.word 0xda9f2000  ! 4076: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xdaa7e000  ! 4077: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	mov	0x20, %r25
	mov	0x3f8, %r22
	.word 0x87802072  ! 4080: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabfa000  ! 4081: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdab7e000  ! 4082: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xdaafe000  ! 4083: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xda8fa000  ! 4085: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 4086: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r25
	.word 0xd49d44a0  ! 4088: LDDA_R	ldda	[%r21, %r0] 0x25, %r10
	.word 0xdacfa000  ! 4089: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0x87802074  ! 4090: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabfe000  ! 4091: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xdac7e000  ! 4092: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xdaaf6000  ! 4093: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 4094: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r26
	.word 0xd28c8400  ! 4096: LDUBA_R	lduba	[%r18, %r0] 0x20, %r9
	mov	0x58, %r17
	.word 0xdabdc4a0  ! 4098: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	mov	0x70, %r18
	.word 0xd0d72000  ! 4100: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd08fe000  ! 4101: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	.word 0xd0af6000  ! 4102: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd0bfe000  ! 4103: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd0af6000  ! 4104: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd0f7e000  ! 4105: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	mov	0x40, %r17
	mov	0x3e8, %r23
	mov	0x8, %r19
	.word 0xd0cf2000  ! 4109: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0x87802073  ! 4110: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 4111: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4d78e80  ! 4112: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r10
	.word 0xd6bce000  ! 4113: STDA_I	stda	%r11, [%r19 + 0x0000] %asi
	.word 0xd6a46000  ! 4114: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0xd6bc2000  ! 4115: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0xd68c2000  ! 4116: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r11
	mov	0x7d0, %r20
	mov	0x58, %r18
	.word 0xd89609e0  ! 4119: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r12
	mov	0x78, %r16
	.word 0xd4df4e40  ! 4121: LDXA_R	ldxa	[%r29, %r0] 0x72, %r10
	.word 0xd6840400  ! 4122: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0xdcaec9e0  ! 4123: STBA_R	stba	%r14, [%r27 + %r0] 0x4f
	.word 0xd6b70e60  ! 4124: STHA_R	stha	%r11, [%r28 + %r0] 0x73
	.word 0xda844400  ! 4125: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r13
	.word 0xd2ad44a0  ! 4126: STBA_R	stba	%r9, [%r21 + %r0] 0x25
	.word 0xd8944400  ! 4127: LDUHA_R	lduha	[%r17, %r0] 0x20, %r12
	.word 0xdcae49e0  ! 4128: STBA_R	stba	%r14, [%r25 + %r0] 0x4f
	.word 0xd28ca000  ! 4129: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0x87802073  ! 4130: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f72000  ! 4131: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xde970e60  ! 4132: LDUHA_R	lduha	[%r28, %r0] 0x73, %r15
	.word 0xda940400  ! 4133: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	.word 0xded70e40  ! 4134: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r15
	.word 0xd8dfe000  ! 4135: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xd0c6c9e0  ! 4136: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r8
	.word 0xd09f0e40  ! 4137: LDDA_R	ldda	[%r28, %r0] 0x72, %r8
	.word 0x8780204f  ! 4138: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a4c400  ! 4139: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	mov	0x20, %r25
	.word 0xd8ada000  ! 4141: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0xdaac0400  ! 4142: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xd8852000  ! 4143: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r12
	.word 0x87802025  ! 4144: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8ac6000  ! 4145: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 4146: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4147: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4148: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r24
	.word 0xd8946000  ! 4150: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	.word 0xd8d42000  ! 4151: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0xd08c0400  ! 4152: LDUBA_R	lduba	[%r16, %r0] 0x20, %r8
	mov	0x28, %r17
	.word 0xdaf4a000  ! 4154: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0xd6970e80  ! 4155: LDUHA_R	lduha	[%r28, %r0] 0x74, %r11
	.word 0x87802073  ! 4156: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b72000  ! 4157: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd2afa000  ! 4158: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xd2876000  ! 4160: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	mov	0x50, %r27
	.word 0xdcd74e60  ! 4162: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r14
	mov	0x7d0, %r23
	mov	0x48, %r17
	.word 0x87802072  ! 4165: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 4166: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4c76000  ! 4167: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	.word 0xdea7ce60  ! 4168: STWA_R	stwa	%r15, [%r31 + %r0] 0x73
	.word 0x87802072  ! 4169: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4170: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r26
	.word 0xd2a7e000  ! 4172: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xd4af0e80  ! 4173: STBA_R	stba	%r10, [%r28 + %r0] 0x74
	mov	0x38, %r24
	.word 0xd88f4e60  ! 4175: LDUBA_R	lduba	[%r29, %r0] 0x73, %r12
	.word 0x87802072  ! 4176: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r17
	.word 0xdab7e000  ! 4178: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xd8b6c9e0  ! 4179: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	.word 0xded7ce60  ! 4180: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r15
	.word 0xdcf40400  ! 4181: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xd0978e60  ! 4182: LDUHA_R	lduha	[%r30, %r0] 0x73, %r8
	.word 0xd0a7a000  ! 4183: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0d7a000  ! 4184: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0xd0af6000  ! 4185: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	mov	0x68, %r16
	.word 0xd0b7a000  ! 4187: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd0dfe000  ! 4188: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	mov	0x60, %r26
	mov	0x3e8, %r20
	.word 0xdeb70e40  ! 4191: STHA_R	stha	%r15, [%r28 + %r0] 0x72
	.word 0xd2d40400  ! 4192: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	.word 0xd8de09e0  ! 4193: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r12
	.word 0xd2974e40  ! 4194: LDUHA_R	lduha	[%r29, %r0] 0x72, %r9
	.word 0xd8948400  ! 4195: LDUHA_R	lduha	[%r18, %r0] 0x20, %r12
	.word 0x87802074  ! 4196: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r18
	.word 0xdecfa000  ! 4198: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	mov	0x3e0, %r21
	.word 0x87802074  ! 4200: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28f0e40  ! 4201: LDUBA_R	lduba	[%r28, %r0] 0x72, %r9
	.word 0xd4b504a0  ! 4202: STHA_R	stha	%r10, [%r20 + %r0] 0x25
	.word 0xd4f4a000  ! 4203: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0xd8df4e40  ! 4204: LDXA_R	ldxa	[%r29, %r0] 0x72, %r12
	.word 0xd2a46000  ! 4205: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2b46000  ! 4206: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 4207: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2ad2000  ! 4208: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xd29de000  ! 4209: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r9
	.word 0xd2f5a000  ! 4210: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	.word 0xdacfce40  ! 4211: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r13
	.word 0xdcc5a000  ! 4212: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r14
	.word 0xdcd52000  ! 4213: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r14
	.word 0xdcb5e000  ! 4214: STHA_I	stha	%r14, [%r23 + 0x0000] %asi
	mov	0x50, %r27
	.word 0xdccd2000  ! 4216: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r14
	.word 0xdcf5e000  ! 4217: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0xd0840400  ! 4218: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	.word 0xde9c0400  ! 4219: LDDA_R	ldda	[%r16, %r0] 0x20, %r15
	.word 0xd09d2000  ! 4220: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r8
	.word 0x87802020  ! 4221: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bc8400  ! 4222: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xdebe09e0  ! 4223: STDA_R	stda	%r15, [%r24 + %r0] 0x4f
	mov	0x30, %r26
	.word 0x87802073  ! 4225: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4c5c4a0  ! 4226: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r10
	.word 0xd8b544a0  ! 4227: STHA_R	stha	%r12, [%r21 + %r0] 0x25
	.word 0xd0f70e40  ! 4228: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	mov	0x7f8, %r20
	.word 0xd0f6c9e0  ! 4230: STXA_R	stxa	%r8, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 4231: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d8, %r20
	.word 0xdabfce40  ! 4233: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	.word 0xd69c8400  ! 4234: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	mov	0x68, %r27
	.word 0xd4af0e80  ! 4236: STBA_R	stba	%r10, [%r28 + %r0] 0x74
	.word 0xd6cd44a0  ! 4237: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r11
	.word 0xd49f4e40  ! 4238: LDDA_R	ldda	[%r29, %r0] 0x72, %r10
	.word 0xd69f4e60  ! 4239: LDDA_R	ldda	[%r29, %r0] 0x73, %r11
	mov	0x3e8, %r23
	mov	0x3d0, %r23
	mov	0x0, %r17
	.word 0xd6f7e000  ! 4243: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6c72000  ! 4244: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	mov	0x0, %r16
	.word 0x87802020  ! 4246: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4247: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6a5e000  ! 4248: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	.word 0xd6cde000  ! 4249: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r11
	.word 0x87802020  ! 4250: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcc70e60  ! 4251: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r14
	.word 0xdad4c400  ! 4252: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xd4f649e0  ! 4253: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	.word 0xd4bc4400  ! 4254: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	mov	0x58, %r17
	.word 0xdcf4a000  ! 4256: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdc8fce80  ! 4257: LDUBA_R	lduba	[%r31, %r0] 0x74, %r14
	.word 0xd4f4e000  ! 4258: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0xdea609e0  ! 4259: STWA_R	stwa	%r15, [%r24 + %r0] 0x4f
	mov	0x20, %r19
	mov	0x0, %r24
	.word 0xdebc6000  ! 4262: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xd4970e60  ! 4263: LDUHA_R	lduha	[%r28, %r0] 0x73, %r10
	.word 0xdc9f0e60  ! 4264: LDDA_R	ldda	[%r28, %r0] 0x73, %r14
	mov	0x7d8, %r22
	.word 0xd4af8e80  ! 4266: STBA_R	stba	%r10, [%r30 + %r0] 0x74
	.word 0xdeaca000  ! 4267: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xdebce000  ! 4268: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xd6f7ce80  ! 4269: STXA_R	stxa	%r11, [%r31 + %r0] 0x74
	.word 0xd6970e80  ! 4270: LDUHA_R	lduha	[%r28, %r0] 0x74, %r11
	.word 0xdaf40400  ! 4271: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xd8ae89e0  ! 4272: STBA_R	stba	%r12, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 4273: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f70e40  ! 4274: STXA_R	stxa	%r11, [%r28 + %r0] 0x72
	.word 0xd4f5e000  ! 4275: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	.word 0xdecf8e40  ! 4276: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r15
	.word 0xdeac8400  ! 4277: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xd0f70e40  ! 4278: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	mov	0x8, %r18
	.word 0xd8b4c400  ! 4280: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0xd49609e0  ! 4281: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r10
	.word 0xd2c74e40  ! 4282: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r9
	.word 0x87802025  ! 4283: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r17
	mov	0x28, %r16
	.word 0xd4a66000  ! 4286: STWA_I	stwa	%r10, [%r25 + 0x0000] %asi
	.word 0xd486a000  ! 4287: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r10
	mov	0x3c0, %r20
	.word 0x87802020  ! 4289: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4290: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bd44a0  ! 4291: STDA_R	stda	%r9, [%r21 + %r0] 0x25
	.word 0xd4afce80  ! 4292: STBA_R	stba	%r10, [%r31 + %r0] 0x74
	.word 0xdabc2000  ! 4293: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 4294: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 4295: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 4296: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4297: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4298: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r26
	.word 0xdab72000  ! 4300: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 4301: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r26
	.word 0xd0a4c400  ! 4303: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0x87802072  ! 4304: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3e0, %r21
	.word 0xd4bc2000  ! 4306: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0xda9544a0  ! 4307: LDUHA_R	lduha	[%r21, %r0] 0x25, %r13
	mov	0x28, %r18
	.word 0xdaace000  ! 4309: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	mov	0x60, %r27
	mov	0x48, %r16
	mov	0x3f8, %r22
	mov	0x20, %r26
	.word 0xdacca000  ! 4314: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	mov	0x78, %r18
	.word 0xd4d78e40  ! 4316: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r10
	mov	0x7d0, %r20
	.word 0x87802025  ! 4318: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcc4a000  ! 4319: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r14
	mov	0x3e8, %r22
	mov	0x28, %r27
	.word 0xd2a40400  ! 4322: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xded7ce80  ! 4323: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r15
	.word 0xdac4a000  ! 4324: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	.word 0xd8b74e40  ! 4325: STHA_R	stha	%r12, [%r29 + %r0] 0x72
	.word 0x8780204f  ! 4326: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdacce000  ! 4327: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r13
	.word 0xdaf689e0  ! 43