// Modified by Princeton University on June 9th, 2015
/*
* ========== Copyright Header Begin ==========================================
* 
* OpenSPARC T1 Processor File: tlu_asi_access_mt_2_rand_34_s2.s
* Copyright (c) 2006 Sun Microsystems, Inc.  All Rights Reserved.
* DO NOT ALTER OR REMOVE COPYRIGHT NOTICES.
* 
* The above named program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License version 2 as published by the Free Software Foundation.
* 
* The above named program is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
* 
* You should have received a copy of the GNU General Public
* License along with this work; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
* 
* ========== Copyright Header End ============================================
*/
/*
********************************************************************************
   random seed:	720894978
   Jal tlu_asi_access_mt_2.j:	
********************************************************************************/



#define PCONTEXT	0x10
#define SCONTEXT	0x10

#define MAIN_PAGE_NUCLEUS_ALSO
#define MAIN_PAGE_HV_ALSO

#define ALL_MY_INTR_HANDLERS
#include "my_intr_handlers.s"
#include "my_trap_handlers.s"
#include "tlu_custom_trap_handlers.s"

#include "enable_traps.h"
#include "boot.s"

.text
.global main

main:

	ta 	%icc, T_CHANGE_HPRIV
	mov	0x123, %g1
	wr	%g0, 0x20, %asi
	stxa	%g1, [0x00] %asi
	stxa	%g1, [0x08] %asi
	stxa	%g1, [0x10] %asi
	stxa	%g1, [0x18] %asi
	stxa	%g1, [0x20] %asi
	stxa	%g1, [0x28] %asi
	stxa	%g1, [0x30] %asi
	stxa	%g1, [0x38] %asi
	ta 	%icc, T_CHANGE_NONHPRIV

! Register init code

	setx 0x3013aa210000212c, %g1, %g0
	setx 0xc4e5a3b1000063b3, %g1, %g1
	setx 0xd92e50fc000001d2, %g1, %g2
	setx 0x3b9a15f6000043f9, %g1, %g3
	setx 0xe92421d9000061cd, %g1, %g4
	setx 0x508285270000a173, %g1, %g5
	setx 0x1108f38d000083f8, %g1, %g6
	setx 0xe002cd4a0000810b, %g1, %g7
	setx 0x2595bb6d00002280, %g1, %r16
	setx 0xafd9f39b000063a2, %g1, %r17
	setx 0x7905aac10000c300, %g1, %r18
	setx 0xd4b9ae260000a3f7, %g1, %r19
	setx 0x64ade5d5000063de, %g1, %r20
	setx 0xbe059dca0000424d, %g1, %r21
	setx 0x0f723f7c000003a2, %g1, %r22
	setx 0xc2628bb80000e1d1, %g1, %r23
	setx 0x580b01cd0000004f, %g1, %r24
	setx 0x09e6b22b0000e170, %g1, %r25
	setx 0x1e44580000008226, %g1, %r26
	setx 0x0f6179770000a09b, %g1, %r27
	setx 0xa8e0b3b00000c1db, %g1, %r28
	setx 0xcb6272b00000436a, %g1, %r29
	setx 0x4a7e2a900000e3c1, %g1, %r30
	setx 0x72931a300000e3a8, %g1, %r31
	save
	setx 0x12ee777d0000c394, %g1, %r16
	setx 0xc58486ff00000303, %g1, %r17
	setx 0x0e73046000000215, %g1, %r18
	setx 0x04a9c0d200002040, %g1, %r19
	setx 0x868e601a000042c7, %g1, %r20
	setx 0x455a6b570000e0f9, %g1, %r21
	setx 0x8bcd49440000a044, %g1, %r22
	setx 0xc79ae17e000000ce, %g1, %r23
	setx 0x47104ecf0000a153, %g1, %r24
	setx 0xd7150b98000081d6, %g1, %r25
	setx 0x7b5f2dfc00004168, %g1, %r26
	setx 0xb12ba99b00000135, %g1, %r27
	setx 0x51e851bf000042e1, %g1, %r28
	setx 0xfe3f52bb00008298, %g1, %r29
	setx 0x5ff2cf650000c247, %g1, %r30
	setx 0x2aa6b0b30000e384, %g1, %r31
	save
	setx 0xed70585b000061a7, %g1, %r16
	setx 0x7df024e20000e098, %g1, %r17
	setx 0x341bcc530000a36c, %g1, %r18
	setx 0xb9c14273000082e0, %g1, %r19
	setx 0x604312bf0000c0b1, %g1, %r20
	setx 0x554357730000c217, %g1, %r21
	setx 0xfc0477820000c2a1, %g1, %r22
	setx 0xe79e18710000e2c5, %g1, %r23
	setx 0x953132bd0000a3bd, %g1, %r24
	setx 0x664d92aa0000a06a, %g1, %r25
	setx 0x3784292e0000c06d, %g1, %r26
	setx 0x132b7f6600006183, %g1, %r27
	setx 0xd6bdccbd0000c1bc, %g1, %r28
	setx 0x95f86bdf0000625b, %g1, %r29
	setx 0x7fc87a9900006258, %g1, %r30
	setx 0x16124b9c00002251, %g1, %r31
	restore
#ifdef PORTABLE_CORE
	mov	PORTABLE_CORE, %g1
	sllx	%g1, 10, %g1
	or	%r8, %g1, %r8
	or	%r9, %g1, %r9
	or	%r10, %g1, %r10
	or	%r11, %g1, %r11
	or	%r12, %g1, %r12
	or	%r13, %g1, %r13
	or	%r14, %g1, %r14
	or	%r15, %g1, %r15
#endif
	mov	0x68, %r16
	mov	0x8, %r17
	mov	0x50, %r18
	mov	0x70, %r19
	mov	0x7c8, %r20
	mov	0x3d0, %r21
	mov	0x7c0, %r22
	mov	0x7e8, %r23
	mov	0x8, %r24
	mov	0x0, %r25
	mov	0x0, %r26
	mov	0x10, %r27
	mov	0, %r28
	mov	0, %r29
	mov	0, %r30
	mov	0, %r31
	ta	%icc, T_CHANGE_HPRIV
	wr	%g0, 0x74, %asi
	stxa	%g0, [%g0] 0x42
	mov	0x38, %g1
	stxa	%g0, [%g1] 0x58
	ta	%icc, T_RD_THID
! fork: source strm = 0xffffffff; target strm = 0x2
	cmp	%o1, 1
	setx	fork_lbl_0_1, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x4
	cmp	%o1, 2
	setx	fork_lbl_0_2, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x8
	cmp	%o1, 3
	setx	fork_lbl_0_3, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
	wr_tick_cmpr_0_0:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf0, %g2
	or	%g4, 0xbd, %g4
	or	%g6, 0x85, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdacf2000  ! 1: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xd0ccc400  ! 2: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	mov	0x28, %r26
	.word 0xd0b72000  ! 4: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 5: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4940400  ! 6: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	.word 0x87802072  ! 7: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 8: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r16
	.word 0xd4f42000  ! 10: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd49c6000  ! 11: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0xd494a000  ! 12: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r10
	.word 0xd4bc2000  ! 13: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	mov	0x38, %r19
	.word 0xd4cc2000  ! 15: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	.word 0xdc8f4e40  ! 16: LDUBA_R	lduba	[%r29, %r0] 0x72, %r14
	.word 0xd8b689e0  ! 17: STHA_R	stha	%r12, [%r26 + %r0] 0x4f
	.word 0xd884a000  ! 18: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r12
	.word 0xd29f4e40  ! 19: LDDA_R	ldda	[%r29, %r0] 0x72, %r9
	.word 0xd6cc0400  ! 20: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r11
	.word 0xd6b4a000  ! 21: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xdcc74e60  ! 22: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r14
	mov	0x18, %r19
	mov	0x48, %r19
	.word 0xdaf70e60  ! 25: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	mov	0x3c8, %r22
	.word 0xd6b78e40  ! 27: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	.word 0xd6f4a000  ! 28: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	.word 0xdaac0400  ! 29: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	mov	0x8, %r19
	.word 0xdad4a000  ! 31: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	mov	0x60, %r27
	.word 0xdabce000  ! 33: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0xdaf42000  ! 34: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	mov	0x50, %r17
	.word 0xd2a74e80  ! 36: STWA_R	stwa	%r9, [%r29 + %r0] 0x74
	.word 0xd2a4a000  ! 37: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	mov	0x38, %r17
	.word 0xd2b46000  ! 39: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0xd4c7ce80  ! 40: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r10
	.word 0xd4bce000  ! 41: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0xd4b4e000  ! 42: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	mov	0x7c0, %r20
	mov	0x50, %r19
	.word 0xd4a4a000  ! 45: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 46: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad4c400  ! 47: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xde94c400  ! 48: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	.word 0xd0b689e0  ! 49: STHA_R	stha	%r8, [%r26 + %r0] 0x4f
	.word 0xd8af4e40  ! 50: STBA_R	stba	%r12, [%r29 + %r0] 0x72
	mov	0x8, %r27
	.word 0xd4f44400  ! 52: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0xdadfce80  ! 53: LDXA_R	ldxa	[%r31, %r0] 0x74, %r13
	mov	0x48, %r19
	.word 0xdaa5a000  ! 55: STWA_I	stwa	%r13, [%r22 + 0x0000] %asi
	.word 0xdaf52000  ! 56: STXA_I	stxa	%r13, [%r20 + 0x0000] %asi
	.word 0xdabda000  ! 57: STDA_I	stda	%r13, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 58: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdadfa000  ! 59: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xdab7a000  ! 60: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xd29649e0  ! 61: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r9
	.word 0xd8a48400  ! 62: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	.word 0xd6f74e80  ! 63: STXA_R	stxa	%r11, [%r29 + %r0] 0x74
	.word 0xd6df2000  ! 64: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6afa000  ! 65: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x7f8, %r23
	mov	0x7e0, %r21
	.word 0xd8f70e80  ! 68: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	mov	0x7f0, %r20
	.word 0xd8972000  ! 70: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	mov	0x3d8, %r20
	.word 0xd8f72000  ! 72: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8cf6000  ! 73: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0xd89fe000  ! 74: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	mov	0x7d8, %r21
	.word 0x87802025  ! 76: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r26
	.word 0xd8d5a000  ! 78: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r12
	.word 0xd48fce40  ! 79: LDUBA_R	lduba	[%r31, %r0] 0x72, %r10
	mov	0x8, %r19
	.word 0x8780204f  ! 81: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r24
	.word 0xd4be6000  ! 83: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0x87802074  ! 84: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r18
	mov	0x38, %r19
	.word 0xd6a4c400  ! 87: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0xdaf74e80  ! 88: STXA_R	stxa	%r13, [%r29 + %r0] 0x74
	.word 0x87802072  ! 89: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca78e80  ! 90: STWA_R	stwa	%r14, [%r30 + %r0] 0x74
	.word 0xd69d04a0  ! 91: LDDA_R	ldda	[%r20, %r0] 0x25, %r11
	mov	0x8, %r16
	.word 0xd6cf2000  ! 93: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	wr_tick_cmpr_0_1:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xaa, %g2
	or	%g4, 0x93, %g4
	or	%g6, 0x8c, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 95: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f4e000  ! 96: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	.word 0xd6cc2000  ! 97: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	.word 0xd4dc4400  ! 98: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	.word 0xdea7ce40  ! 99: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	mov	0x7c8, %r20
	.word 0xde94e000  ! 101: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	.word 0xdeace000  ! 102: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xdcf74e40  ! 103: STXA_R	stxa	%r14, [%r29 + %r0] 0x72
	mov	0x3c8, %r20
	.word 0xd08649e0  ! 105: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r8
	.word 0xd0ac2000  ! 106: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 107: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r26
	.word 0x87802072  ! 109: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b5c4a0  ! 110: STHA_R	stha	%r8, [%r23 + %r0] 0x25
	.word 0xd2f74e60  ! 111: STXA_R	stxa	%r9, [%r29 + %r0] 0x73
	.word 0xd8c5c4a0  ! 112: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r12
	.word 0xdecc8400  ! 113: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	.word 0x87802074  ! 114: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 115: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde8fe000  ! 116: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	mov	0x8, %r19
	.word 0xd4b44400  ! 118: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	mov	0x3e0, %r22
	mov	0x18, %r16
	.word 0xd48fa000  ! 121: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xd2d78e40  ! 122: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r9
	.word 0xd2cfe000  ! 123: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	mov	0x18, %r16
	.word 0xd4dc4400  ! 125: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	.word 0xd4b44400  ! 126: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	.word 0xd4f7a000  ! 127: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4b76000  ! 128: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd4b7e000  ! 130: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd8bf8e60  ! 131: STDA_R	stda	%r12, [%r30 + %r0] 0x73
	.word 0xd6cd44a0  ! 132: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r11
	.word 0x87802072  ! 133: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd284c400  ! 134: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r9
	.word 0xd2f7e000  ! 135: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd4f74e60  ! 136: STXA_R	stxa	%r10, [%r29 + %r0] 0x73
	.word 0xd8bf8e60  ! 137: STDA_R	stda	%r12, [%r30 + %r0] 0x73
	mov	0x7f8, %r21
	.word 0xd8c7a000  ! 139: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8a72000  ! 140: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 141: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8af2000  ! 142: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xd8afe000  ! 143: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	mov	0x78, %r26
	.word 0xdc8f0e60  ! 145: LDUBA_R	lduba	[%r28, %r0] 0x73, %r14
	.word 0xd6bf0e80  ! 146: STDA_R	stda	%r11, [%r28 + %r0] 0x74
	.word 0xd2a7ce60  ! 147: STWA_R	stwa	%r9, [%r31 + %r0] 0x73
	.word 0xd097ce40  ! 148: LDUHA_R	lduha	[%r31, %r0] 0x72, %r8
	.word 0x87802025  ! 149: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 150: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b72000  ! 151: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 152: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0bda000  ! 153: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 154: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 155: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f4e000  ! 156: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xd28d04a0  ! 157: LDUBA_R	lduba	[%r20, %r0] 0x25, %r9
	.word 0xd2cc2000  ! 158: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r9
	.word 0xdcb609e0  ! 159: STHA_R	stha	%r14, [%r24 + %r0] 0x4f
	mov	0x48, %r25
	mov	0x3e0, %r23
	.word 0xd8afce80  ! 162: STBA_R	stba	%r12, [%r31 + %r0] 0x74
	.word 0xd69d44a0  ! 163: LDDA_R	ldda	[%r21, %r0] 0x25, %r11
	.word 0x87802073  ! 164: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 165: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 166: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6a7a000  ! 167: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	mov	0x50, %r16
	mov	0x38, %r25
	mov	0x50, %r19
	.word 0x87802025  ! 171: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r16
	mov	0x58, %r16
	.word 0xd4b48400  ! 174: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd084c400  ! 175: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r8
	.word 0xd0cd2000  ! 176: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r8
	.word 0xd0bd6000  ! 177: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0x87802072  ! 178: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b76000  ! 179: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	mov	0x70, %r24
	.word 0x87802074  ! 181: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2aec9e0  ! 182: STBA_R	stba	%r9, [%r27 + %r0] 0x4f
	.word 0xd4bfce80  ! 183: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	.word 0x87802020  ! 184: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r17
	.word 0x8780204f  ! 186: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4dea000  ! 187: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	.word 0xd4d62000  ! 188: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r10
	.word 0xd2c48400  ! 189: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	mov	0x3f8, %r21
	.word 0x87802073  ! 191: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f7e000  ! 192: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 193: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f0, %r23
	.word 0xd6b70e40  ! 195: STHA_R	stha	%r11, [%r28 + %r0] 0x72
	.word 0x8780204f  ! 196: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdedcc400  ! 197: LDXA_R	ldxa	[%r19, %r0] 0x20, %r15
	.word 0xdef66000  ! 198: STXA_I	stxa	%r15, [%r25 + 0x0000] %asi
	.word 0xd4dfce60  ! 199: LDXA_R	ldxa	[%r31, %r0] 0x73, %r10
	.word 0xdecf4e60  ! 200: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r15
	.word 0xdcc40400  ! 201: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	.word 0xdc8e2000  ! 202: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r14
	.word 0x87802072  ! 203: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcdf6000  ! 204: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xdc872000  ! 205: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0x87802020  ! 206: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r18
	.word 0xdef584a0  ! 208: STXA_R	stxa	%r15, [%r22 + %r0] 0x25
	.word 0xd2d40400  ! 209: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	.word 0x87802020  ! 210: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4adc4a0  ! 211: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0xda870e60  ! 212: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r13
	.word 0xdad48400  ! 213: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0x87802074  ! 214: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8c504a0  ! 215: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r12
	.word 0x8780204f  ! 216: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8c66000  ! 217: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r12
	.word 0xdab6c9e0  ! 218: STHA_R	stha	%r13, [%r27 + %r0] 0x4f
	.word 0x87802073  ! 219: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 220: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad42000  ! 221: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r13
	.word 0x87802072  ! 222: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r17
	.word 0xdac7e000  ! 224: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xd6cc8400  ! 225: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	.word 0xd4f7ce40  ! 226: STXA_R	stxa	%r10, [%r31 + %r0] 0x72
	.word 0xd4f76000  ! 227: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	mov	0x3d0, %r21
	.word 0xd8df4e60  ! 229: LDXA_R	ldxa	[%r29, %r0] 0x73, %r12
	.word 0xd4bf4e60  ! 230: STDA_R	stda	%r10, [%r29 + %r0] 0x73
	.word 0xd4dfa000  ! 231: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd2944400  ! 232: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	.word 0xd2b76000  ! 233: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 234: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r24
	.word 0xd0df8e60  ! 236: LDXA_R	ldxa	[%r30, %r0] 0x73, %r8
	.word 0xdcd70e40  ! 237: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r14
	.word 0xdc9fa000  ! 238: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0x87802073  ! 239: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r27
	mov	0x7e8, %r20
	mov	0x7c0, %r21
	.word 0xdccfa000  ! 243: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xdcf72000  ! 244: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xd895c4a0  ! 245: LDUHA_R	lduha	[%r23, %r0] 0x25, %r12
	.word 0xd887e000  ! 246: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	mov	0x18, %r16
	.word 0xd8d76000  ! 248: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xd8dfe000  ! 249: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	mov	0x3f0, %r21
	.word 0x87802074  ! 251: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 252: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ae2000  ! 253: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	.word 0xd8de6000  ! 254: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r12
	mov	0x48, %r16
	.word 0xd0a44400  ! 256: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xdcbd04a0  ! 257: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	.word 0x87802072  ! 258: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcaf8e80  ! 259: STBA_R	stba	%r14, [%r30 + %r0] 0x74
	mov	0x7e0, %r22
	.word 0xdcbfe000  ! 261: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdcf649e0  ! 262: STXA_R	stxa	%r14, [%r25 + %r0] 0x4f
	.word 0xdccf2000  ! 263: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xd6de09e0  ! 264: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r11
	mov	0x70, %r25
	.word 0x87802020  ! 266: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r21
	mov	0x40, %r16
	.word 0xd6cc2000  ! 269: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	.word 0xd2bc8400  ! 270: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	.word 0x87802020  ! 271: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f74e80  ! 272: STXA_R	stxa	%r11, [%r29 + %r0] 0x74
	mov	0x68, %r19
	.word 0x87802020  ! 274: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 275: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd69f2000  ! 276: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xd6afa000  ! 277: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x0, %r27
	.word 0xd6dc0400  ! 279: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	.word 0xd6cf0e80  ! 280: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r11
	.word 0xd68f6000  ! 281: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xd89f8e60  ! 282: LDDA_R	ldda	[%r30, %r0] 0x73, %r12
	.word 0xd8dfa000  ! 283: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0x87802072  ! 284: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a7a000  ! 285: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8df6000  ! 286: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8d7a000  ! 287: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	mov	0x7f8, %r21
	wr_tick_cmpr_0_2:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe1, %g2
	or	%g4, 0xf9, %g4
	or	%g6, 0xbe, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8b72000  ! 290: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 291: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8dea000  ! 292: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r12
	.word 0x87802073  ! 293: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xded44400  ! 294: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	.word 0x8780204f  ! 295: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebc4400  ! 296: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0xdcb4c400  ! 297: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xd0b4c400  ! 298: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0xd2b5c4a0  ! 299: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	.word 0x87802073  ! 300: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b70e80  ! 301: STHA_R	stha	%r10, [%r28 + %r0] 0x74
	.word 0xd4b76000  ! 302: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd4cf2000  ! 303: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd497a000  ! 304: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0xd6a70e40  ! 305: STWA_R	stwa	%r11, [%r28 + %r0] 0x72
	mov	0x78, %r18
	.word 0xd6a7a000  ! 307: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	mov	0x18, %r27
	.word 0xde944400  ! 309: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	.word 0xda87ce40  ! 310: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r13
	.word 0x8780204f  ! 311: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 312: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf584a0  ! 313: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	.word 0xdad7a000  ! 314: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0xda872000  ! 315: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0xd4b689e0  ! 316: STHA_R	stha	%r10, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 317: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdadfce40  ! 318: LDXA_R	ldxa	[%r31, %r0] 0x72, %r13
	.word 0x87802073  ! 319: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r18
	.word 0xdec40400  ! 321: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xdea76000  ! 322: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 323: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde94a000  ! 324: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	mov	0x7e0, %r20
	mov	0x48, %r18
	mov	0x30, %r25
	mov	0x7c0, %r21
	.word 0xd0cc4400  ! 329: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	.word 0x87802025  ! 330: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd09da000  ! 331: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r8
	.word 0xd6b4c400  ! 332: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xd6b5a000  ! 333: STHA_I	stha	%r11, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 334: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c46000  ! 335: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r11
	.word 0xd8f4c400  ! 336: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0x87802073  ! 337: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8afe000  ! 338: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd8b72000  ! 339: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	mov	0x7f8, %r23
	.word 0x87802020  ! 341: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r26
	mov	0x7e0, %r22
	.word 0xd8dce000  ! 344: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	.word 0xd8dc8400  ! 345: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xd8aca000  ! 346: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	mov	0x7c8, %r21
	.word 0xd68d84a0  ! 348: LDUBA_R	lduba	[%r22, %r0] 0x25, %r11
	.word 0xd6a4e000  ! 349: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0xd6bce000  ! 350: STDA_I	stda	%r11, [%r19 + 0x0000] %asi
	.word 0xdabc0400  ! 351: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0x87802073  ! 352: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa72000  ! 353: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0x87802073  ! 355: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r26
	.word 0xd6bdc4a0  ! 357: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	.word 0xd6de89e0  ! 358: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r11
	.word 0x87802020  ! 359: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r25
	mov	0x28, %r18
	mov	0x3f0, %r23
	.word 0xdab70e60  ! 363: STHA_R	stha	%r13, [%r28 + %r0] 0x73
	.word 0xda9ca000  ! 364: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	mov	0x7f8, %r23
	mov	0x7f8, %r22
	.word 0x87802025  ! 367: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4b689e0  ! 368: STHA_R	stha	%r10, [%r26 + %r0] 0x4f
	.word 0xd8ac0400  ! 369: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xdabf0e40  ! 370: STDA_R	stda	%r13, [%r28 + %r0] 0x72
	.word 0xd6bd84a0  ! 371: STDA_R	stda	%r11, [%r22 + %r0] 0x25
	mov	0x3f8, %r21
	.word 0xd6a5a000  ! 373: STWA_I	stwa	%r11, [%r22 + 0x0000] %asi
	.word 0xdacec9e0  ! 374: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r13
	.word 0xd4dfce40  ! 375: LDXA_R	ldxa	[%r31, %r0] 0x72, %r10
	.word 0xd2ccc400  ! 376: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	.word 0xd2cd6000  ! 377: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r9
	mov	0x10, %r26
	.word 0xd2ada000  ! 379: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	mov	0x58, %r24
	.word 0xdc8c8400  ! 381: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0xda9dc4a0  ! 382: LDDA_R	ldda	[%r23, %r0] 0x25, %r13
	mov	0x18, %r16
	ta	T_CHANGE_NONPRIV	! macro
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdaf5e000  ! 386: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0xdadde000  ! 387: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r13
	.word 0x87802073  ! 388: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2878e80  ! 389: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r9
	.word 0x87802073  ! 390: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2dfe000  ! 391: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2bfa000  ! 392: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	mov	0x8, %r17
	.word 0xd2cfa000  ! 394: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	wr_tick_cmpr_0_3:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x9c, %g2
	or	%g4, 0xad, %g4
	or	%g6, 0x8c, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 396: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f72000  ! 397: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd6848400  ! 398: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	mov	0x0, %r25
	mov	0x50, %r18
	.word 0xd6af6000  ! 401: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd08f8e40  ! 402: LDUBA_R	lduba	[%r30, %r0] 0x72, %r8
	.word 0xdef78e60  ! 403: STXA_R	stxa	%r15, [%r30 + %r0] 0x73
	mov	0x3f8, %r20
	.word 0xdebf2000  ! 405: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xdc870e80  ! 406: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r14
	mov	0x3d8, %r21
	mov	0x7e8, %r20
	.word 0xdc97e000  ! 409: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xde94c400  ! 410: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	.word 0x87802025  ! 411: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebdc4a0  ! 412: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	.word 0xd89cc400  ! 413: LDDA_R	ldda	[%r19, %r0] 0x20, %r12
	mov	0x0, %r16
	mov	0x38, %r24
	mov	0x3d0, %r21
	mov	0x48, %r16
	.word 0x87802025  ! 418: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 419: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4a649e0  ! 420: STWA_R	stwa	%r10, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 421: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c42000  ! 422: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r10
	.word 0xdabe89e0  ! 423: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	.word 0xd4cd44a0  ! 424: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r10
	.word 0xd4a4a000  ! 425: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xdaa78e60  ! 426: STWA_R	stwa	%r13, [%r30 + %r0] 0x73
	.word 0x87802073  ! 427: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e0, %r20
	.word 0xd8f4c400  ! 429: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xd8afa000  ! 430: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 431: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r16
	.word 0x87802025  ! 433: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r16
	.word 0xd8ad2000  ! 435: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 436: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r17
	.word 0xd8b72000  ! 438: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	mov	0x30, %r24
	.word 0xd8972000  ! 440: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	.word 0xdcdfce40  ! 441: LDXA_R	ldxa	[%r31, %r0] 0x72, %r14
	.word 0x87802025  ! 442: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbd2000  ! 443: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	.word 0xdc8de000  ! 444: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r14
	.word 0xd8afce40  ! 445: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	.word 0xd88d2000  ! 446: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r12
	.word 0xd8cda000  ! 447: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r12
	mov	0x3c8, %r22
	.word 0xdcbf8e80  ! 449: STDA_R	stda	%r14, [%r30 + %r0] 0x74
	.word 0xd0a74e60  ! 450: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	.word 0xdaf70e80  ! 451: STXA_R	stxa	%r13, [%r28 + %r0] 0x74
	mov	0x7d8, %r22
	.word 0x87802073  ! 453: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdabf6000  ! 454: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xda8d84a0  ! 455: LDUBA_R	lduba	[%r22, %r0] 0x25, %r13
	.word 0xd6d40400  ! 456: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	.word 0xd6b7e000  ! 457: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd2b5c4a0  ! 458: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	.word 0xd4cf4e60  ! 459: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r10
	.word 0xd49f4e40  ! 460: LDDA_R	ldda	[%r29, %r0] 0x72, %r10
	mov	0x68, %r27
	.word 0xd4f7a000  ! 462: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 463: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a72000  ! 464: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4a76000  ! 465: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd49f2000  ! 466: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd4a7a000  ! 467: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4d72000  ! 468: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	.word 0xdc9c0400  ! 469: LDDA_R	ldda	[%r16, %r0] 0x20, %r14
	.word 0x87802074  ! 470: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd68cc400  ! 471: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	.word 0xd6a7e000  ! 472: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xd2cf8e80  ! 473: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r9
	mov	0x40, %r26
	.word 0xd2bf2000  ! 475: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd28fa000  ! 477: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	.word 0xda874e80  ! 478: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r13
	.word 0xda87a000  ! 479: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	mov	0x30, %r19
	.word 0xdab74e80  ! 481: STHA_R	stha	%r13, [%r29 + %r0] 0x74
	.word 0xdadfa000  ! 482: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	mov	0x40, %r24
	.word 0xda876000  ! 484: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0xd8a4c400  ! 485: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	mov	0x20, %r16
	.word 0xd8c72000  ! 487: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd2ae49e0  ! 488: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	.word 0xd8f7ce80  ! 489: STXA_R	stxa	%r12, [%r31 + %r0] 0x74
	.word 0xd8a7a000  ! 490: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 491: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 492: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r19
	.word 0xd8bf2000  ! 494: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd8c76000  ! 495: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	.word 0xdec689e0  ! 496: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r15
	.word 0xdea7e000  ! 497: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xdedf2000  ! 498: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xd2c584a0  ! 499: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r9
	.word 0xd29f2000  ! 500: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd2dfa000  ! 501: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0x87802025  ! 502: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r26
	.word 0xd2ad2000  ! 504: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xd8df4e80  ! 505: LDXA_R	ldxa	[%r29, %r0] 0x74, %r12
	.word 0xd8a5e000  ! 506: STWA_I	stwa	%r12, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 507: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 508: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a46000  ! 509: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 510: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b74e80  ! 511: STHA_R	stha	%r8, [%r29 + %r0] 0x74
	.word 0xd0d4a000  ! 512: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	.word 0xd0d4e000  ! 513: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	.word 0xd09ca000  ! 514: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	.word 0x87802020  ! 515: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f42000  ! 516: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0xd0d46000  ! 517: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r8
	.word 0xd88e09e0  ! 518: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r12
	mov	0x7c8, %r22
	.word 0xd89e09e0  ! 520: LDDA_R	ldda	[%r24, %r0] 0x4f, %r12
	mov	0x10, %r17
	.word 0xde8544a0  ! 522: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r15
	.word 0x87802073  ! 523: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde872000  ! 524: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	mov	0x7c8, %r21
	.word 0xdea7e000  ! 526: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xd2b40400  ! 527: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0xd8f544a0  ! 528: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	.word 0x87802074  ! 529: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a74e60  ! 530: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	.word 0xda87ce80  ! 531: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r13
	.word 0xda97a000  ! 532: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xda872000  ! 533: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0xde940400  ! 534: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	mov	0x38, %r19
	.word 0xdebf4e60  ! 536: STDA_R	stda	%r15, [%r29 + %r0] 0x73
	.word 0xdeb72000  ! 537: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	mov	0x3d8, %r21
	mov	0x28, %r16
	.word 0xd0c74e80  ! 540: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r8
	.word 0xd6c504a0  ! 541: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r11
	mov	0x58, %r26
	.word 0xd6c7a000  ! 543: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	.word 0xdabf4e80  ! 544: STDA_R	stda	%r13, [%r29 + %r0] 0x74
	.word 0x87802020  ! 545: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 546: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 547: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r24
	mov	0x50, %r16
	.word 0xdad5e000  ! 550: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r13
	ta	T_CHANGE_PRIV	! macro
	.word 0xd4d5c4a0  ! 552: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r10
	mov	0x7c8, %r20
	wr_tick_cmpr_0_4:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x9b, %g2
	or	%g4, 0x9c, %g4
	or	%g6, 0xdc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802025  ! 555: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r24
	.word 0xd495e000  ! 557: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r10
	.word 0x87802072  ! 558: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r16
	.word 0xdca44400  ! 560: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0xdc876000  ! 561: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0xd4d649e0  ! 562: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r10
	.word 0xd6d4c400  ! 563: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	mov	0x60, %r25
	.word 0xd6b76000  ! 565: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0xd6cf0e80  ! 567: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r11
	.word 0xd4f544a0  ! 568: STXA_R	stxa	%r10, [%r21 + %r0] 0x25
	.word 0xd8d40400  ! 569: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	mov	0x3d0, %r23
	.word 0x87802020  ! 571: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r23
	.word 0xdcbe09e0  ! 573: STDA_R	stda	%r14, [%r24 + %r0] 0x4f
	mov	0x40, %r18
	.word 0x87802020  ! 575: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcac6000  ! 576: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 577: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 578: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaddc4a0  ! 579: LDXA_R	ldxa	[%r23, %r0] 0x25, %r13
	.word 0xd2c40400  ! 580: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r9
	.word 0x87802020  ! 581: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2842000  ! 582: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r9
	.word 0xd2cc6000  ! 583: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	.word 0x87802020  ! 584: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 585: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2dfa000  ! 586: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xd0be49e0  ! 587: STDA_R	stda	%r8, [%r25 + %r0] 0x4f
	.word 0xd8af8e60  ! 588: STBA_R	stba	%r12, [%r30 + %r0] 0x73
	.word 0xdaf609e0  ! 589: STXA_R	stxa	%r13, [%r24 + %r0] 0x4f
	.word 0xdabf2000  ! 590: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xda8f6000  ! 591: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xdec40400  ! 592: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0x87802074  ! 593: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6bf0e40  ! 594: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	.word 0xd6c7e000  ! 595: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xd2b649e0  ! 596: STHA_R	stha	%r9, [%r25 + %r0] 0x4f
	.word 0xd29fa000  ! 597: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd0bfce40  ! 598: STDA_R	stda	%r8, [%r31 + %r0] 0x72
	mov	0x7f8, %r22
	.word 0xd0afe000  ! 600: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xd0f7a000  ! 602: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0d72000  ! 603: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd2b4c400  ! 604: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	mov	0x3d0, %r21
	.word 0x87802020  ! 606: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r16
	.word 0xd29fce40  ! 608: LDDA_R	ldda	[%r31, %r0] 0x72, %r9
	.word 0x8780204f  ! 609: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a62000  ! 610: STWA_I	stwa	%r9, [%r24 + 0x0000] %asi
	mov	0x50, %r26
	.word 0xd0af4e80  ! 612: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	.word 0xd8a7ce40  ! 613: STWA_R	stwa	%r12, [%r31 + %r0] 0x72
	.word 0xd88e2000  ! 614: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r12
	.word 0xd8bee000  ! 615: STDA_I	stda	%r12, [%r27 + 0x0000] %asi
	.word 0xd2d544a0  ! 616: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r9
	.word 0x8780204f  ! 617: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda940400  ! 618: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	mov	0x70, %r19
	.word 0x8780204f  ! 620: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4dd04a0  ! 621: LDXA_R	ldxa	[%r20, %r0] 0x25, %r10
	.word 0xd4a6a000  ! 622: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	.word 0x87802073  ! 623: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4bf6000  ! 624: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd8af0e60  ! 625: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	.word 0xd8c72000  ! 626: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	mov	0x3c0, %r22
	mov	0x58, %r18
	mov	0x70, %r19
	.word 0xd8a649e0  ! 630: STWA_R	stwa	%r12, [%r25 + %r0] 0x4f
	mov	0x78, %r27
	mov	0x3d0, %r21
	mov	0x7f8, %r22
	.word 0x87802073  ! 634: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r26
	mov	0x48, %r19
	.word 0xdecfce80  ! 637: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r15
	mov	0x3e0, %r20
	.word 0x87802020  ! 639: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f504a0  ! 640: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0xd6acc400  ! 641: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xd6f46000  ! 642: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0xd6f46000  ! 643: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 644: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6dce000  ! 645: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0xd69c6000  ! 646: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r11
	.word 0x87802020  ! 647: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b609e0  ! 648: STHA_R	stha	%r12, [%r24 + %r0] 0x4f
	mov	0x10, %r19
	.word 0xdcbf0e80  ! 650: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	.word 0xdaf78e60  ! 651: STXA_R	stxa	%r13, [%r30 + %r0] 0x73
	.word 0xda9ca000  ! 652: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	mov	0x68, %r17
	.word 0xda9c6000  ! 654: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xda9c6000  ! 655: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xda94e000  ! 656: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r13
	mov	0x3c0, %r23
	.word 0x87802072  ! 658: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdad76000  ! 659: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0xd0b78e40  ! 660: STHA_R	stha	%r8, [%r30 + %r0] 0x72
	.word 0xdcf7ce80  ! 661: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	.word 0xd6bf4e80  ! 662: STDA_R	stda	%r11, [%r29 + %r0] 0x74
	.word 0xd6a74e60  ! 663: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	mov	0x78, %r25
	.word 0x87802025  ! 665: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6956000  ! 666: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r11
	.word 0xd6f5e000  ! 667: STXA_I	stxa	%r11, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 668: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4cfce80  ! 669: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r10
	.word 0xd4c6e000  ! 670: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r10
	.word 0xd087ce80  ! 671: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r8
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0ce2000  ! 673: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r8
	.word 0xd2b4c400  ! 674: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0x87802020  ! 675: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r23
	.word 0xd2b4a000  ! 677: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0xd8dfce40  ! 678: LDXA_R	ldxa	[%r31, %r0] 0x72, %r12
	.word 0xdea5c4a0  ! 679: STWA_R	stwa	%r15, [%r23 + %r0] 0x25
	.word 0x8780204f  ! 680: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c8, %r20
	.word 0x87802072  ! 682: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r25
	mov	0x28, %r17
	mov	0x30, %r25
	.word 0xdef76000  ! 686: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xde87ce80  ! 687: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r15
	.word 0xdebfe000  ! 688: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0xda9e49e0  ! 690: LDDA_R	ldda	[%r25, %r0] 0x4f, %r13
	.word 0xd0cf8e60  ! 691: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r8
	.word 0x87802074  ! 692: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r24
	.word 0xd6c7ce80  ! 694: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r11
	.word 0xd6bf6000  ! 695: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd6976000  ! 696: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	.word 0x87802020  ! 697: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6846000  ! 698: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r11
	.word 0x87802025  ! 699: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd48f0e60  ! 700: LDUBA_R	lduba	[%r28, %r0] 0x73, %r10
	mov	0x7d0, %r22
	.word 0xd4b5a000  ! 702: STHA_I	stha	%r10, [%r22 + 0x0000] %asi
	mov	0x68, %r19
	.word 0xdcbf8e40  ! 704: STDA_R	stda	%r14, [%r30 + %r0] 0x72
	mov	0x60, %r26
	.word 0xde8cc400  ! 706: LDUBA_R	lduba	[%r19, %r0] 0x20, %r15
	mov	0x70, %r19
	.word 0xda9cc400  ! 708: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	.word 0x87802074  ! 709: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c0, %r23
	.word 0x87802025  ! 711: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad5e000  ! 712: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r13
	.word 0xda8d6000  ! 713: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r13
	.word 0xda856000  ! 714: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r13
	.word 0xdab56000  ! 715: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	.word 0xda956000  ! 716: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r13
	.word 0xdebd44a0  ! 717: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	mov	0x28, %r16
	mov	0x3d8, %r22
	.word 0xd69dc4a0  ! 720: LDDA_R	ldda	[%r23, %r0] 0x25, %r11
	mov	0x3f8, %r22
	.word 0xd2f7ce60  ! 722: STXA_R	stxa	%r9, [%r31 + %r0] 0x73
	mov	0x30, %r25
	.word 0x8780204f  ! 724: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r24
	mov	0x8, %r18
	mov	0x68, %r19
	.word 0xd4bfce60  ! 728: STDA_R	stda	%r10, [%r31 + %r0] 0x73
	.word 0x87802073  ! 729: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b7a000  ! 730: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd0a74e80  ! 731: STWA_R	stwa	%r8, [%r29 + %r0] 0x74
	.word 0xd0976000  ! 732: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0a7e000  ! 733: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0a7e000  ! 734: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	mov	0x40, %r18
	.word 0xdcdec9e0  ! 736: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r14
	.word 0x87802020  ! 737: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r21
	mov	0x68, %r19
	.word 0xd2b48400  ! 740: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd68609e0  ! 741: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r11
	.word 0xd6d4e000  ! 742: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r11
	.word 0xd69f4e60  ! 743: LDDA_R	ldda	[%r29, %r0] 0x73, %r11
	.word 0x87802074  ! 744: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 745: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r25
	.word 0x87802074  ! 747: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d8, %r20
	mov	0x0, %r25
	.word 0xd6f76000  ! 750: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 751: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 752: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6a66000  ! 753: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	.word 0xd6ce2000  ! 754: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	.word 0xd6b6e000  ! 755: STHA_I	stha	%r11, [%r27 + 0x0000] %asi
	mov	0x78, %r27
	.word 0x87802074  ! 757: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6a76000  ! 758: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xdabf0e40  ! 759: STDA_R	stda	%r13, [%r28 + %r0] 0x72
	mov	0x60, %r24
	.word 0xdaafa000  ! 761: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdc8649e0  ! 762: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r14
	.word 0x87802020  ! 763: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf46000  ! 764: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	mov	0x3d0, %r21
	.word 0xd0bfce80  ! 766: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	.word 0x87802072  ! 767: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b7a000  ! 768: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd0d7e000  ! 769: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0c76000  ! 770: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0xdebf0e60  ! 771: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	.word 0xdebf2000  ! 772: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 773: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdecce000  ! 774: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	.word 0xd4b504a0  ! 775: STHA_R	stha	%r10, [%r20 + %r0] 0x25
	mov	0x30, %r24
	.word 0x87802074  ! 777: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd49fe000  ! 778: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd2de49e0  ! 779: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r9
	.word 0xd2bfe000  ! 780: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 781: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2ad2000  ! 782: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xd2bf0e80  ! 783: STDA_R	stda	%r9, [%r28 + %r0] 0x74
	.word 0xd0b609e0  ! 784: STHA_R	stha	%r8, [%r24 + %r0] 0x4f
	.word 0xd0dd2000  ! 785: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0x87802025  ! 786: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0ad6000  ! 787: STBA_I	stba	%r8, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 788: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 789: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c8, %r22
	.word 0xd0b4c400  ! 791: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0x87802072  ! 792: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r19
	.word 0xd0d7e000  ! 794: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xd2c7ce40  ! 795: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r9
	.word 0xd2c689e0  ! 796: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r9
	.word 0xd8d6c9e0  ! 797: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r12
	.word 0xd8df6000  ! 798: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0xdef70e60  ! 799: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	.word 0xdcb649e0  ! 800: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	mov	0x3c0, %r22
	.word 0xda9e09e0  ! 802: LDDA_R	ldda	[%r24, %r0] 0x4f, %r13
	mov	0x7c8, %r20
	.word 0xdaaf2000  ! 804: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdaa76000  ! 805: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xd4f48400  ! 806: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xdcbfce80  ! 807: STDA_R	stda	%r14, [%r31 + %r0] 0x74
	.word 0xdcf76000  ! 808: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x3c0, %r23
	mov	0x7f8, %r21
	.word 0xd2c44400  ! 811: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	.word 0x8780204f  ! 812: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8cf4e60  ! 813: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r12
	.word 0xd8b66000  ! 814: STHA_I	stha	%r12, [%r25 + 0x0000] %asi
	.word 0xd8ae6000  ! 815: STBA_I	stba	%r12, [%r25 + 0x0000] %asi
	wr_tick_cmpr_0_5:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xda, %g2
	or	%g4, 0xa3, %g4
	or	%g6, 0x97, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x78, %r18
	.word 0xdec74e80  ! 818: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r15
	mov	0x7d0, %r20
	.word 0xd48c4400  ! 820: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0xd4a6a000  ! 821: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	.word 0xd4de2000  ! 822: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r10
	.word 0xdaf78e60  ! 823: STXA_R	stxa	%r13, [%r30 + %r0] 0x73
	.word 0xdcd70e40  ! 824: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r14
	.word 0xdcae6000  ! 825: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	.word 0xdcde6000  ! 826: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r14
	.word 0xdcf62000  ! 827: STXA_I	stxa	%r14, [%r24 + 0x0000] %asi
	.word 0xdcc70e40  ! 828: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r14
	.word 0x87802020  ! 829: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc846000  ! 830: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	.word 0x87802072  ! 831: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 832: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6df4e40  ! 833: LDXA_R	ldxa	[%r29, %r0] 0x72, %r11
	.word 0xd6942000  ! 834: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r11
	ta	T_CHANGE_PRIV	! macro
	mov	0x3e8, %r20
	.word 0xd6f42000  ! 837: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	.word 0xdedf4e40  ! 838: LDXA_R	ldxa	[%r29, %r0] 0x72, %r15
	.word 0xd0970e60  ! 839: LDUHA_R	lduha	[%r28, %r0] 0x73, %r8
	.word 0xd0ace000  ! 840: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	mov	0x10, %r18
	.word 0xd0dca000  ! 842: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	mov	0x70, %r26
	mov	0x10, %r26
	.word 0xd6be89e0  ! 845: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	.word 0xd6b70e60  ! 846: STHA_R	stha	%r11, [%r28 + %r0] 0x73
	.word 0x87802074  ! 847: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6bf4e60  ! 848: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	mov	0x78, %r27
	mov	0x28, %r25
	.word 0x87802072  ! 851: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6afa000  ! 852: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 853: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 854: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b76000  ! 855: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd6cf6000  ! 856: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd0f689e0  ! 857: STXA_R	stxa	%r8, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 858: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r17
	.word 0xd0b52000  ! 860: STHA_I	stha	%r8, [%r20 + 0x0000] %asi
	.word 0xdaf649e0  ! 861: STXA_R	stxa	%r13, [%r25 + %r0] 0x4f
	.word 0xdaf5a000  ! 862: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xd0f48400  ! 863: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xd2bf0e80  ! 864: STDA_R	stda	%r9, [%r28 + %r0] 0x74
	.word 0xd295e000  ! 865: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r9
	mov	0x8, %r25
	mov	0x50, %r18
	.word 0xd6b609e0  ! 868: STHA_R	stha	%r11, [%r24 + %r0] 0x4f
	.word 0x87802072  ! 869: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b504a0  ! 870: STHA_R	stha	%r9, [%r20 + %r0] 0x25
	.word 0xdecf4e80  ! 871: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r15
	mov	0x40, %r24
	mov	0x18, %r18
	.word 0xdef7e000  ! 874: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 875: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 876: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 877: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef7e000  ! 878: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xdcf6c9e0  ! 879: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	.word 0xdcf44400  ! 880: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xdca72000  ! 881: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	mov	0x18, %r19
	mov	0x3d8, %r20
	mov	0x18, %r19
	.word 0xdc972000  ! 885: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	.word 0x87802072  ! 886: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 887: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf4a000  ! 888: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdeae49e0  ! 889: STBA_R	stba	%r15, [%r25 + %r0] 0x4f
	.word 0xdea4e000  ! 890: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	wr_tick_cmpr_0_6:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe4, %g2
	or	%g4, 0x97, %g4
	or	%g6, 0xa3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdeac6000  ! 892: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xdca504a0  ! 893: STWA_R	stwa	%r14, [%r20 + %r0] 0x25
	.word 0x87802025  ! 894: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda94c400  ! 895: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	.word 0xda8d2000  ! 896: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r13
	wr_tick_cmpr_0_7:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xfe, %g2
	or	%g4, 0xbd, %g4
	or	%g6, 0xfb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x78, %r27
	mov	0x58, %r26
	.word 0xd6d40400  ! 900: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	.word 0xdecec9e0  ! 901: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r15
	.word 0xd0bc0400  ! 902: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0x87802020  ! 903: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 904: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d8, %r20
	.word 0xdab70e60  ! 906: STHA_R	stha	%r13, [%r28 + %r0] 0x73
	.word 0x87802020  ! 907: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r20
	mov	0x70, %r27
	.word 0x87802020  ! 910: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac42000  ! 911: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0xda94a000  ! 912: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	.word 0xdabc6000  ! 913: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xda942000  ! 914: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0x87802074  ! 915: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda8f2000  ! 916: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0x87802020  ! 917: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9c8400  ! 918: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0xdccce000  ! 919: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r14
	mov	0x18, %r27
	mov	0x7c8, %r22
	.word 0x87802025  ! 922: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaadc4a0  ! 923: STBA_R	stba	%r13, [%r23 + %r0] 0x25
	.word 0xd88689e0  ! 924: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r12
	mov	0x7c8, %r20
	mov	0x18, %r24
	.word 0x87802020  ! 927: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r24
	.word 0xd8b4a000  ! 929: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xd8ace000  ! 931: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 932: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8942000  ! 933: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r12
	mov	0x10, %r17
	mov	0x20, %r26
	.word 0xd88ca000  ! 936: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	.word 0xd8bc0400  ! 937: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xd8bce000  ! 938: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd8f4e000  ! 939: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xdacf4e80  ! 940: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r13
	mov	0x8, %r18
	.word 0xd0bf0e80  ! 942: STDA_R	stda	%r8, [%r28 + %r0] 0x74
	.word 0xd08ca000  ! 943: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xd0846000  ! 944: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0xd0b4a000  ! 945: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xd0b46000  ! 946: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	mov	0x78, %r26
	.word 0x87802072  ! 948: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb649e0  ! 949: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	mov	0x7e8, %r20
	mov	0x8, %r16
	.word 0xdcdfe000  ! 952: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	mov	0x78, %r24
	.word 0xde978e40  ! 954: LDUHA_R	lduha	[%r30, %r0] 0x72, %r15
	mov	0x0, %r16
	.word 0xde8c8400  ! 956: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	mov	0x30, %r18
	.word 0xde9f2000  ! 958: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xdedfe000  ! 959: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xdedfa000  ! 960: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xde972000  ! 961: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0xd0b7ce60  ! 962: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	.word 0xd0b7a000  ! 963: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	mov	0x0, %r27
	.word 0xd0f76000  ! 965: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd2b689e0  ! 966: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	.word 0xd0f44400  ! 967: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0x87802073  ! 968: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa48400  ! 969: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	mov	0x20, %r25
	.word 0xd2f74e40  ! 971: STXA_R	stxa	%r9, [%r29 + %r0] 0x72
	.word 0xdede89e0  ! 972: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r15
	.word 0xde9f2000  ! 973: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0x87802074  ! 974: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 975: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e0, %r22
	.word 0xdcb40400  ! 977: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xdcc6e000  ! 978: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r14
	.word 0x87802020  ! 979: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49c0400  ! 980: LDDA_R	ldda	[%r16, %r0] 0x20, %r10
	.word 0xd4dc2000  ! 981: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	wr_tick_cmpr_0_8:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xdf, %g2
	or	%g4, 0xb1, %g4
	or	%g6, 0xfe, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2948400  ! 983: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	mov	0x40, %r25
	.word 0xd48d04a0  ! 985: LDUBA_R	lduba	[%r20, %r0] 0x25, %r10
	.word 0xd4942000  ! 986: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r10
	.word 0xd4dce000  ! 987: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	mov	0x7d8, %r23
	.word 0xd4bc6000  ! 989: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 990: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdef74e60  ! 991: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	mov	0x7d0, %r23
	.word 0xdede89e0  ! 993: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r15
	mov	0x7c0, %r23
	.word 0x87802020  ! 995: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r21
	.word 0xd4af8e40  ! 997: STBA_R	stba	%r10, [%r30 + %r0] 0x72
	mov	0x0, %r18
	.word 0xdaccc400  ! 999: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r13
	.word 0xd48c0400  ! 1000: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	.word 0xd4bca000  ! 1001: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0xd494a000  ! 1002: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r10
	mov	0x3c0, %r20
	.word 0xd6dcc400  ! 1004: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	.word 0x87802074  ! 1005: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6976000  ! 1006: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	.word 0xd4a48400  ! 1007: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xded44400  ! 1008: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	mov	0x18, %r17
	.word 0xd29609e0  ! 1010: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r9
	mov	0x3c0, %r22
	.word 0x87802025  ! 1012: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 1013: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaf40400  ! 1014: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8ae49e0  ! 1016: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0xd8d52000  ! 1017: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r12
	.word 0xd8a5e000  ! 1018: STWA_I	stwa	%r12, [%r23 + 0x0000] %asi
	.word 0xd8f56000  ! 1019: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	mov	0x7f8, %r20
	mov	0x18, %r17
	.word 0xdca74e80  ! 1022: STWA_R	stwa	%r14, [%r29 + %r0] 0x74
	.word 0x87802074  ! 1023: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcd76000  ! 1024: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	.word 0xdab609e0  ! 1025: STHA_R	stha	%r13, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 1026: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabc2000  ! 1027: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	mov	0x20, %r24
	mov	0x70, %r18
	.word 0x87802025  ! 1030: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r27
	.word 0xd0a78e80  ! 1032: STWA_R	stwa	%r8, [%r30 + %r0] 0x74
	.word 0xdca70e80  ! 1033: STWA_R	stwa	%r14, [%r28 + %r0] 0x74
	.word 0xdc95e000  ! 1034: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r14
	.word 0xd08e89e0  ! 1035: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r8
	.word 0x87802074  ! 1036: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd696c9e0  ! 1037: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r11
	.word 0xd8c78e80  ! 1038: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r12
	mov	0x50, %r17
	.word 0xd8a72000  ! 1040: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd6dd04a0  ! 1041: LDXA_R	ldxa	[%r20, %r0] 0x25, %r11
	.word 0xd6872000  ! 1042: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6a76000  ! 1043: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	mov	0x60, %r25
	.word 0xd4ccc400  ! 1045: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0xd4972000  ! 1046: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	mov	0x3e0, %r22
	.word 0xd48fe000  ! 1048: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	mov	0x18, %r19
	mov	0x3c8, %r21
	mov	0x50, %r25
	.word 0xd0a5c4a0  ! 1052: STWA_R	stwa	%r8, [%r23 + %r0] 0x25
	mov	0x68, %r17
	.word 0xd097e000  ! 1054: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xd4d48400  ! 1055: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	.word 0xd2df8e80  ! 1056: LDXA_R	ldxa	[%r30, %r0] 0x74, %r9
	.word 0xd2870e80  ! 1057: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r9
	.word 0xd6dfce40  ! 1058: LDXA_R	ldxa	[%r31, %r0] 0x72, %r11
	.word 0xd485c4a0  ! 1059: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r10
	.word 0xd4876000  ! 1060: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xd487ce80  ! 1061: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r10
	.word 0xd4c72000  ! 1062: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4afa000  ! 1063: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd084c400  ! 1064: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r8
	.word 0xdeaf8e80  ! 1065: STBA_R	stba	%r15, [%r30 + %r0] 0x74
	.word 0x8780204f  ! 1066: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r26
	.word 0xdebe2000  ! 1068: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	.word 0x87802072  ! 1069: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 1070: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdea7e000  ! 1071: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	mov	0x10, %r27
	.word 0xda8fce40  ! 1073: LDUBA_R	lduba	[%r31, %r0] 0x72, %r13
	.word 0xd4948400  ! 1074: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	.word 0xd4bfa000  ! 1075: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd4bf2000  ! 1076: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1077: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b689e0  ! 1078: STHA_R	stha	%r10, [%r26 + %r0] 0x4f
	mov	0x10, %r16
	mov	0x48, %r19
	.word 0xdeac4400  ! 1081: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0xde8ca000  ! 1082: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0x87802072  ! 1083: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r27
	.word 0xdedf2000  ! 1085: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xdedfa000  ! 1086: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xdec72000  ! 1087: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 1088: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 1089: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 1090: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 1091: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca70e60  ! 1092: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	.word 0xdc87a000  ! 1093: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	mov	0x8, %r18
	.word 0xd0970e60  ! 1095: LDUHA_R	lduha	[%r28, %r0] 0x73, %r8
	.word 0xd0af6000  ! 1096: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd0bfe000  ! 1097: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1098: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a4e000  ! 1099: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd6c48400  ! 1100: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	.word 0xd6dc2000  ! 1101: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r11
	.word 0x87802074  ! 1102: WRASI_I	wr	%r0, 0x0074, %asi
	wr_tick_cmpr_0_9:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xef, %g2
	or	%g4, 0xcf, %g4
	or	%g6, 0xc2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd6f40400  ! 1104: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	.word 0xd2c48400  ! 1105: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0xd89c8400  ! 1106: LDDA_R	ldda	[%r18, %r0] 0x20, %r12
	.word 0x87802074  ! 1107: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd88f6000  ! 1108: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	mov	0x58, %r25
	mov	0x58, %r27
	.word 0x87802020  ! 1111: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68fce60  ! 1112: LDUBA_R	lduba	[%r31, %r0] 0x73, %r11
	mov	0x7d0, %r21
	.word 0xd2f649e0  ! 1114: STXA_R	stxa	%r9, [%r25 + %r0] 0x4f
	.word 0xd09f0e60  ! 1115: LDDA_R	ldda	[%r28, %r0] 0x73, %r8
	.word 0xdaf609e0  ! 1116: STXA_R	stxa	%r13, [%r24 + %r0] 0x4f
	.word 0xdad4e000  ! 1117: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r13
	.word 0xda94a000  ! 1118: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	.word 0xd6bc8400  ! 1119: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xd6a42000  ! 1120: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xd6b46000  ! 1121: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd0cc4400  ! 1122: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	mov	0x3d8, %r22
	.word 0xd0b4e000  ! 1124: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	mov	0x7d8, %r23
	mov	0x58, %r24
	mov	0x48, %r26
	mov	0x7c8, %r21
	.word 0x8780204f  ! 1129: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0cee000  ! 1130: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r8
	mov	0x8, %r27
	.word 0xd2878e80  ! 1132: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r9
	.word 0xdaac0400  ! 1133: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	mov	0x7c8, %r21
	mov	0x78, %r18
	.word 0xdcdc8400  ! 1136: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	.word 0xdcc6e000  ! 1137: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r14
	mov	0x48, %r18
	.word 0xd68f4e40  ! 1139: LDUBA_R	lduba	[%r29, %r0] 0x72, %r11
	.word 0x87802073  ! 1140: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6b7e000  ! 1141: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 1142: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6ae6000  ! 1143: STBA_I	stba	%r11, [%r25 + 0x0000] %asi
	mov	0x38, %r27
	wr_tick_cmpr_0_10:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x94, %g2
	or	%g4, 0xda, %g4
	or	%g6, 0xdd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd6948400  ! 1146: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	.word 0xd6a62000  ! 1147: STWA_I	stwa	%r11, [%r24 + 0x0000] %asi
	.word 0xdead44a0  ! 1148: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	mov	0x48, %r19
	.word 0xd2b74e40  ! 1150: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	.word 0xd2ae2000  ! 1151: STBA_I	stba	%r9, [%r24 + 0x0000] %asi
	wr_tick_cmpr_0_11:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc7, %g2
	or	%g4, 0x98, %g4
	or	%g6, 0x85, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd286a000  ! 1153: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1154: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dc2000  ! 1155: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r9
	.word 0xd8b6c9e0  ! 1156: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 1157: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r25
	.word 0xd88c6000  ! 1159: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	.word 0xdcb504a0  ! 1160: STHA_R	stha	%r14, [%r20 + %r0] 0x25
	mov	0x58, %r25
	.word 0xd8a40400  ! 1162: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	mov	0x48, %r26
	.word 0xd2ad04a0  ! 1164: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	.word 0xd4a7ce40  ! 1165: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	.word 0xd49ce000  ! 1166: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 1167: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2b7ce80  ! 1168: STHA_R	stha	%r9, [%r31 + %r0] 0x74
	.word 0xd6d78e80  ! 1169: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r11
	.word 0xd69e2000  ! 1170: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r11
	.word 0x87802020  ! 1171: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bca000  ! 1172: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	.word 0xdabf0e80  ! 1173: STDA_R	stda	%r13, [%r28 + %r0] 0x74
	.word 0xd2d74e60  ! 1174: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r9
	.word 0x87802074  ! 1175: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d0, %r23
	.word 0xd29f0e80  ! 1177: LDDA_R	ldda	[%r28, %r0] 0x74, %r9
	.word 0xd0f70e40  ! 1178: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	.word 0xd0afa000  ! 1179: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd087e000  ! 1180: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	mov	0x3c0, %r23
	.word 0xd09f2000  ! 1182: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0xd8c689e0  ! 1183: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r12
	mov	0x10, %r19
	.word 0x8780204f  ! 1185: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9cc400  ! 1186: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	mov	0x7d8, %r22
	.word 0xda86a000  ! 1188: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r13
	.word 0xdac6a000  ! 1189: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r13
	.word 0xd4f78e80  ! 1190: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	.word 0x87802025  ! 1191: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4f5e000  ! 1192: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 1193: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r24
	.word 0xd4f76000  ! 1195: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 1196: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4afa000  ! 1197: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd0f4c400  ! 1198: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0xd0976000  ! 1199: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0x87802072  ! 1200: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 1201: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd48dc4a0  ! 1202: LDUBA_R	lduba	[%r23, %r0] 0x25, %r10
	.word 0x87802020  ! 1203: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bc2000  ! 1204: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0xd4f4e000  ! 1205: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0xd4f4a000  ! 1206: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0xd0a40400  ! 1207: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	mov	0x18, %r18
	.word 0xd0dc2000  ! 1209: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	.word 0xd0bce000  ! 1210: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	mov	0x3e0, %r23
	.word 0xdcad04a0  ! 1212: STBA_R	stba	%r14, [%r20 + %r0] 0x25
	mov	0x3c0, %r20
	mov	0x30, %r24
	.word 0xd2af0e80  ! 1215: STBA_R	stba	%r9, [%r28 + %r0] 0x74
	.word 0xdef74e40  ! 1216: STXA_R	stxa	%r15, [%r29 + %r0] 0x72
	.word 0xd6f40400  ! 1217: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	.word 0x87802020  ! 1218: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1219: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6dc2000  ! 1220: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r11
	mov	0x40, %r26
	.word 0x87802020  ! 1222: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r18
	.word 0xd6f4a000  ! 1224: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	.word 0xd6942000  ! 1225: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r11
	.word 0x87802072  ! 1226: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdea544a0  ! 1227: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	.word 0xde9fa000  ! 1228: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x20, %r25
	.word 0x87802020  ! 1231: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r19
	mov	0x50, %r16
	.word 0xd88c4400  ! 1234: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0x87802025  ! 1235: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r25
	.word 0xd8ada000  ! 1237: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0xd08c8400  ! 1238: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0xdcbd04a0  ! 1239: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	mov	0x0, %r25
	.word 0xdcf5e000  ! 1241: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 1242: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc848400  ! 1243: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	.word 0xdcd7a000  ! 1244: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0xdcf72000  ! 1245: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcadc4a0  ! 1246: STBA_R	stba	%r14, [%r23 + %r0] 0x25
	mov	0x78, %r27
	.word 0xdcdf2000  ! 1248: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcf48400  ! 1249: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xdedc4400  ! 1250: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	mov	0x7f8, %r22
	.word 0xd6f584a0  ! 1252: STXA_R	stxa	%r11, [%r22 + %r0] 0x25
	.word 0xd6bfe000  ! 1253: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 1254: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e0, %r23
	.word 0x87802020  ! 1256: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0878e80  ! 1257: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r8
	.word 0xd094e000  ! 1258: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0xd084a000  ! 1259: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	.word 0xd8b74e80  ! 1260: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	.word 0xd8f4a000  ! 1261: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8d4e000  ! 1262: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0xd89c6000  ! 1263: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r12
	.word 0xd0df0e60  ! 1264: LDXA_R	ldxa	[%r28, %r0] 0x73, %r8
	.word 0x87802025  ! 1265: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r27
	.word 0xd0f56000  ! 1267: STXA_I	stxa	%r8, [%r21 + 0x0000] %asi
	mov	0x48, %r16
	.word 0xd0852000  ! 1269: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r8
	.word 0xd48f0e80  ! 1270: LDUBA_R	lduba	[%r28, %r0] 0x74, %r10
	.word 0xd4bd6000  ! 1271: STDA_I	stda	%r10, [%r21 + 0x0000] %asi
	.word 0xd4bda000  ! 1272: STDA_I	stda	%r10, [%r22 + 0x0000] %asi
	.word 0xd0f74e80  ! 1273: STXA_R	stxa	%r8, [%r29 + %r0] 0x74
	.word 0xd0d5a000  ! 1274: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r8
	.word 0x87802074  ! 1275: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0976000  ! 1276: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0af6000  ! 1277: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xdabd44a0  ! 1278: STDA_R	stda	%r13, [%r21 + %r0] 0x25
	.word 0xdaa70e40  ! 1279: STWA_R	stwa	%r13, [%r28 + %r0] 0x72
	.word 0xdaaf2000  ! 1280: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xde878e60  ! 1281: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r15
	mov	0x3e0, %r23
	mov	0x7f8, %r21
	mov	0x48, %r16
	.word 0xdebf2000  ! 1285: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xd0cc8400  ! 1286: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0x87802020  ! 1287: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r20
	.word 0xd2c544a0  ! 1289: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r9
	.word 0xd6b504a0  ! 1290: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	.word 0xdc8544a0  ! 1291: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r14
	.word 0x87802073  ! 1292: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 1293: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 1294: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc9d6000  ! 1295: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r14
	.word 0x87802020  ! 1296: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc8c2000  ! 1297: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r14
	mov	0x40, %r19
	.word 0x87802073  ! 1299: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r16
	mov	0x18, %r16
	.word 0xda8dc4a0  ! 1302: LDUBA_R	lduba	[%r23, %r0] 0x25, %r13
	.word 0xda8fa000  ! 1303: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	mov	0x3d8, %r20
	.word 0x87802025  ! 1305: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 1306: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdacf6000  ! 1307: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0x87802025  ! 1308: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 1309: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9e6000  ! 1310: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r13
	.word 0xd6cc4400  ! 1311: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	mov	0x3d8, %r23
	mov	0x7d0, %r21
	.word 0xd6f6a000  ! 1314: STXA_I	stxa	%r11, [%r26 + 0x0000] %asi
	mov	0x0, %r16
	.word 0xdeacc400  ! 1316: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xdef544a0  ! 1317: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	.word 0x87802020  ! 1318: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r16
	mov	0x20, %r18
	.word 0xdef7ce60  ! 1321: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	mov	0x70, %r24
	.word 0xdea42000  ! 1323: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xdea48400  ! 1324: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xd68c0400  ! 1325: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	mov	0x7c0, %r23
	mov	0x7c8, %r23
	.word 0xd6b4a000  ! 1328: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd69ce000  ! 1329: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r11
	.word 0x87802072  ! 1330: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49c4400  ! 1331: LDDA_R	ldda	[%r17, %r0] 0x20, %r10
	.word 0xd48f8e40  ! 1332: LDUBA_R	lduba	[%r30, %r0] 0x72, %r10
	mov	0x20, %r18
	.word 0xdccf4e80  ! 1334: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r14
	.word 0xdab48400  ! 1335: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0xdadf2000  ! 1336: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0xdcddc4a0  ! 1337: LDXA_R	ldxa	[%r23, %r0] 0x25, %r14
	.word 0xdef4c400  ! 1338: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xda9fce80  ! 1339: LDDA_R	ldda	[%r31, %r0] 0x74, %r13
	.word 0xdacf2000  ! 1340: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xdeb544a0  ! 1341: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	mov	0x7d0, %r23
	.word 0xdeb7e000  ! 1343: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	mov	0x78, %r26
	.word 0xd8b40400  ! 1345: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xd0b70e80  ! 1346: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	mov	0x3f8, %r22
	mov	0x3e8, %r22
	mov	0x18, %r25
	mov	0x3c8, %r23
	.word 0xd0d72000  ! 1351: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0afe000  ! 1352: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	mov	0x0, %r24
	mov	0x7c8, %r22
	.word 0xdca70e60  ! 1355: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	.word 0xdeb7ce60  ! 1356: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	.word 0xdebf6000  ! 1357: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xd2dc4400  ! 1358: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0x87802074  ! 1359: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd685c4a0  ! 1360: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r11
	.word 0x87802020  ! 1361: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1362: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4d44400  ! 1363: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0x87802020  ! 1364: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1365: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r27
	mov	0x20, %r24
	.word 0x87802020  ! 1368: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ac6000  ! 1369: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	.word 0xd4c4e000  ! 1370: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r10
	.word 0xd4bc6000  ! 1371: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	mov	0x0, %r17
	.word 0x87802073  ! 1373: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r18
	.word 0xd6f74e80  ! 1375: STXA_R	stxa	%r11, [%r29 + %r0] 0x74
	.word 0xd6af6000  ! 1376: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd6afa000  ! 1377: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xd6d7e000  ! 1379: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	mov	0x3d8, %r20
	.word 0xd6a76000  ! 1381: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6b7e000  ! 1382: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd0a4c400  ! 1383: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xd0a72000  ! 1384: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xd0b72000  ! 1385: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd09f4e40  ! 1386: LDDA_R	ldda	[%r29, %r0] 0x72, %r8
	.word 0xdaf504a0  ! 1387: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	mov	0x38, %r16
	.word 0xdec584a0  ! 1389: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r15
	mov	0x48, %r16
	.word 0xd4b70e60  ! 1391: STHA_R	stha	%r10, [%r28 + %r0] 0x73
	ta	T_CHANGE_PRIV	! macro
	mov	0x58, %r18
	mov	0x20, %r26
	mov	0x68, %r26
	mov	0x38, %r26
	mov	0x30, %r18
	.word 0xd8f584a0  ! 1398: STXA_R	stxa	%r12, [%r22 + %r0] 0x25
	mov	0x48, %r27
	mov	0x28, %r16
	.word 0xd8a76000  ! 1401: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 1402: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r19
	.word 0xde97ce80  ! 1404: LDUHA_R	lduha	[%r31, %r0] 0x74, %r15
	.word 0x87802073  ! 1405: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r17
	.word 0xd4bc4400  ! 1407: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0xd4dfce80  ! 1408: LDXA_R	ldxa	[%r31, %r0] 0x74, %r10
	mov	0x30, %r19
	.word 0xdeb70e40  ! 1410: STHA_R	stha	%r15, [%r28 + %r0] 0x72
	.word 0xd6ac0400  ! 1411: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0xd6dfe000  ! 1412: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	.word 0xd68f6000  ! 1413: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	mov	0x7d8, %r23
	mov	0x8, %r27
	.word 0xd6a609e0  ! 1416: STWA_R	stwa	%r11, [%r24 + %r0] 0x4f
	mov	0x38, %r24
	mov	0x20, %r26
	.word 0x87802025  ! 1419: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 1420: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd69f6000  ! 1421: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	mov	0x3d0, %r22
	.word 0xd6dfe000  ! 1423: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	.word 0x87802020  ! 1424: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r19
	.word 0xd6a4e000  ! 1426: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0xd6d4e000  ! 1427: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r11
	.word 0xd8b584a0  ! 1428: STHA_R	stha	%r12, [%r22 + %r0] 0x25
	.word 0xd8bce000  ! 1429: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xdeb44400  ! 1431: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0xded4e000  ! 1432: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	.word 0x87802073  ! 1433: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0bf8e60  ! 1434: STDA_R	stda	%r8, [%r30 + %r0] 0x73
	mov	0x10, %r25
	mov	0x70, %r24
	.word 0xd09f2000  ! 1437: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0xd08fe000  ! 1438: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	ta	T_CHANGE_PRIV	! macro
	.word 0xd6a78e60  ! 1440: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0xdacc4400  ! 1441: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	.word 0xd8b504a0  ! 1442: STHA_R	stha	%r12, [%r20 + %r0] 0x25
	.word 0x87802073  ! 1443: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 1444: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8f76000  ! 1445: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd4a74e80  ! 1446: STWA_R	stwa	%r10, [%r29 + %r0] 0x74
	.word 0xd4cfa000  ! 1447: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	mov	0x3e8, %r21
	.word 0xd4b76000  ! 1449: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd0ae89e0  ! 1450: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	.word 0xd0cf4e60  ! 1451: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r8
	.word 0xd0df6000  ! 1452: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0c7e000  ! 1453: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0x87802073  ! 1454: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8ac0400  ! 1455: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 1456: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a6e000  ! 1457: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	.word 0xda870e80  ! 1458: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r13
	mov	0x68, %r26
	mov	0x10, %r18
	mov	0x7d8, %r20
	.word 0xdace6000  ! 1462: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r13
	.word 0xd8878e40  ! 1463: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r12
	.word 0xdcbe49e0  ! 1464: STDA_R	stda	%r14, [%r25 + %r0] 0x4f
	.word 0xdcb62000  ! 1465: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	.word 0x87802025  ! 1466: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a74e60  ! 1467: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	.word 0xd0cc4400  ! 1468: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	mov	0x48, %r27
	mov	0x8, %r27
	.word 0xd0a52000  ! 1471: STWA_I	stwa	%r8, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 1472: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b40400  ! 1473: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	mov	0x8, %r24
	.word 0xd6aca000  ! 1475: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xd8a504a0  ! 1476: STWA_R	stwa	%r12, [%r20 + %r0] 0x25
	.word 0xd89ce000  ! 1477: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	.word 0xd6aec9e0  ! 1478: STBA_R	stba	%r11, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 1479: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1480: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdea74e40  ! 1481: STWA_R	stwa	%r15, [%r29 + %r0] 0x72
	.word 0x87802020  ! 1482: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8ca000  ! 1483: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0xde84e000  ! 1484: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	.word 0xd29c4400  ! 1485: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	.word 0xdabf4e60  ! 1486: STDA_R	stda	%r13, [%r29 + %r0] 0x73
	.word 0xdab46000  ! 1487: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0xdac4e000  ! 1488: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r13
	.word 0xd2d7ce60  ! 1489: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r9
	.word 0x87802073  ! 1490: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2d7a000  ! 1491: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0xd2972000  ! 1492: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	mov	0x7c0, %r22
	mov	0x7f0, %r22
	.word 0xd2cf2000  ! 1495: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r9
	mov	0x7c8, %r20
	.word 0x8780204f  ! 1497: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c0, %r23
	.word 0xd2de2000  ! 1499: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r9
	.word 0xd2bee000  ! 1500: STDA_I	stda	%r9, [%r27 + 0x0000] %asi
	.word 0xd2afce80  ! 1501: STBA_R	stba	%r9, [%r31 + %r0] 0x74
	.word 0xdac48400  ! 1502: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	.word 0xd2a689e0  ! 1503: STWA_R	stwa	%r9, [%r26 + %r0] 0x4f
	.word 0xd2b62000  ! 1504: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xd2f6a000  ! 1506: STXA_I	stxa	%r9, [%r26 + 0x0000] %asi
	.word 0xd6844400  ! 1507: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r11
	.word 0xd6cee000  ! 1508: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r11
	.word 0xd6b74e80  ! 1509: STHA_R	stha	%r11, [%r29 + %r0] 0x74
	.word 0xdebf4e80  ! 1510: STDA_R	stda	%r15, [%r29 + %r0] 0x74
	wr_tick_cmpr_0_12:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe8, %g2
	or	%g4, 0x90, %g4
	or	%g6, 0xdf, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdeaee000  ! 1512: STBA_I	stba	%r15, [%r27 + 0x0000] %asi
	mov	0x28, %r25
	.word 0xd4bf8e40  ! 1514: STDA_R	stda	%r10, [%r30 + %r0] 0x72
	.word 0xd4dea000  ! 1515: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	.word 0xd6f6c9e0  ! 1516: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	.word 0xdcdf4e40  ! 1517: LDXA_R	ldxa	[%r29, %r0] 0x72, %r14
	.word 0xdcde2000  ! 1518: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r14
	mov	0x48, %r19
	.word 0x87802073  ! 1520: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c8, %r21
	mov	0x0, %r17
	mov	0x68, %r27
	.word 0x87802020  ! 1524: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1525: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8c48400  ! 1526: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	.word 0xd8a7e000  ! 1527: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd88f2000  ! 1528: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1529: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f46000  ! 1530: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 1531: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8cfce40  ! 1532: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r12
	.word 0xd8afe000  ! 1533: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd8874e40  ! 1534: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r12
	.word 0xd8d7a000  ! 1535: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	mov	0x7d0, %r23
	mov	0x3e8, %r21
	.word 0xd8cfa000  ! 1538: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xdecf0e60  ! 1539: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r15
	.word 0xdedfa000  ! 1540: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xdea7a000  ! 1541: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	mov	0x50, %r26
	.word 0x87802020  ! 1543: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebc2000  ! 1544: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xd8ac4400  ! 1545: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xd0a504a0  ! 1546: STWA_R	stwa	%r8, [%r20 + %r0] 0x25
	mov	0x7d0, %r20
	.word 0xd08c6000  ! 1548: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0xd0f42000  ! 1549: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 1550: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1551: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r16
	.word 0xd4b649e0  ! 1553: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	.word 0xd49c6000  ! 1554: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0xda9f8e40  ! 1555: LDDA_R	ldda	[%r30, %r0] 0x72, %r13
	.word 0xd8de49e0  ! 1556: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r12
	.word 0x87802020  ! 1557: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r21
	.word 0xdacfce60  ! 1559: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r13
	.word 0x87802020  ! 1560: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9c2000  ! 1561: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1562: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadca000  ! 1563: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0xd2844400  ! 1564: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	.word 0xdef74e60  ! 1565: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	.word 0xd4a7ce60  ! 1566: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 1567: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4d62000  ! 1568: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r10
	.word 0xd8ae89e0  ! 1569: STBA_R	stba	%r12, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 1570: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r24
	.word 0xd2b584a0  ! 1572: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0xdca44400  ! 1573: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0xdcc5e000  ! 1574: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r14
	.word 0xd0d4c400  ! 1575: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	.word 0x87802074  ! 1576: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 1577: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8adc4a0  ! 1578: STBA_R	stba	%r12, [%r23 + %r0] 0x25
	mov	0x28, %r16
	.word 0x87802020  ! 1580: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bf0e60  ! 1581: STDA_R	stda	%r8, [%r28 + %r0] 0x73
	.word 0xd0f4e000  ! 1582: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0aca000  ! 1583: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 1584: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0cfe000  ! 1585: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0bf2000  ! 1587: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xd28c8400  ! 1588: LDUBA_R	lduba	[%r18, %r0] 0x20, %r9
	.word 0xd2afa000  ! 1589: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xd2dfe000  ! 1590: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2c76000  ! 1591: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2c76000  ! 1592: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0x87802073  ! 1593: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 1594: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2af6000  ! 1595: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd2b7e000  ! 1596: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 1597: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeb4c400  ! 1598: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xdef62000  ! 1599: STXA_I	stxa	%r15, [%r24 + 0x0000] %asi
	wr_tick_cmpr_0_13:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x8f, %g2
	or	%g4, 0xe9, %g4
	or	%g6, 0xb0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xde9ea000  ! 1601: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r15
	.word 0xde9e6000  ! 1602: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r15
	.word 0xdeb6a000  ! 1603: STHA_I	stha	%r15, [%r26 + 0x0000] %asi
	.word 0xded6e000  ! 1604: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r15
	mov	0x48, %r17
	mov	0x8, %r26
	.word 0xd4f609e0  ! 1607: STXA_R	stxa	%r10, [%r24 + %r0] 0x4f
	mov	0x18, %r25
	.word 0xd68c8400  ! 1609: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	.word 0xd4b504a0  ! 1610: STHA_R	stha	%r10, [%r20 + %r0] 0x25
	mov	0x18, %r24
	wr_tick_cmpr_0_14:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x96, %g2
	or	%g4, 0xe9, %g4
	or	%g6, 0xf9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7e0, %r23
	.word 0xd4ce2000  ! 1614: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r10
	.word 0x87802025  ! 1615: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 1616: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4d7a000  ! 1617: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	.word 0x87802073  ! 1618: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r17
	.word 0xd48fe000  ! 1620: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xd4bf2000  ! 1621: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xdea74e40  ! 1622: STWA_R	stwa	%r15, [%r29 + %r0] 0x72
	.word 0xd4d74e40  ! 1623: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r10
	.word 0xd0df8e80  ! 1624: LDXA_R	ldxa	[%r30, %r0] 0x74, %r8
	.word 0x87802025  ! 1625: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r27
	mov	0x78, %r26
	.word 0xd0dd2000  ! 1628: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0xdab544a0  ! 1629: STHA_R	stha	%r13, [%r21 + %r0] 0x25
	.word 0x87802074  ! 1630: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2848400  ! 1631: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r9
	.word 0xd087ce80  ! 1632: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r8
	.word 0xdcb5c4a0  ! 1633: STHA_R	stha	%r14, [%r23 + %r0] 0x25
	.word 0x87802020  ! 1634: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf70e60  ! 1635: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	mov	0x30, %r26
	.word 0x8780204f  ! 1637: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabe6000  ! 1638: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	.word 0xdcc70e80  ! 1639: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r14
	.word 0xdc86e000  ! 1640: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r14
	.word 0xdcc6e000  ! 1641: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r14
	.word 0x87802073  ! 1642: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdad6c9e0  ! 1643: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r13
	.word 0xd2b78e80  ! 1644: STHA_R	stha	%r9, [%r30 + %r0] 0x74
	mov	0x70, %r25
	mov	0x10, %r25
	.word 0x8780204f  ! 1647: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b584a0  ! 1648: STHA_R	stha	%r11, [%r22 + %r0] 0x25
	wr_tick_cmpr_0_15:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe8, %g2
	or	%g4, 0xf8, %g4
	or	%g6, 0xa7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd6c6a000  ! 1650: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r11
	.word 0xd6f48400  ! 1651: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xd6a6e000  ! 1652: STWA_I	stwa	%r11, [%r27 + 0x0000] %asi
	.word 0x87802025  ! 1653: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1654: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r17
	.word 0xd0cf8e40  ! 1656: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r8
	mov	0x3f8, %r21
	.word 0x87802020  ! 1658: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ac2000  ! 1659: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xdade09e0  ! 1660: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r13
	.word 0xdeaf4e40  ! 1661: STBA_R	stba	%r15, [%r29 + %r0] 0x72
	mov	0x7f8, %r21
	.word 0xdeb42000  ! 1663: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xdab70e40  ! 1665: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	mov	0x68, %r18
	.word 0xd6dcc400  ! 1667: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	mov	0x7d8, %r23
	.word 0xd6c4e000  ! 1669: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r11
	.word 0xd68d04a0  ! 1670: LDUBA_R	lduba	[%r20, %r0] 0x25, %r11
	mov	0x20, %r24
	mov	0x28, %r27
	.word 0xd8bec9e0  ! 1673: STDA_R	stda	%r12, [%r27 + %r0] 0x4f
	.word 0xd69d84a0  ! 1674: LDDA_R	ldda	[%r22, %r0] 0x25, %r11
	.word 0x87802073  ! 1675: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2bc4400  ! 1676: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 1677: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r25
	.word 0xd0df0e80  ! 1679: LDXA_R	ldxa	[%r28, %r0] 0x74, %r8
	.word 0xd0ce6000  ! 1680: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r8
	.word 0xd2a70e60  ! 1681: STWA_R	stwa	%r9, [%r28 + %r0] 0x73
	mov	0x38, %r19
	mov	0x50, %r25
	.word 0xd296a000  ! 1684: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r9
	.word 0xde8fce80  ! 1685: LDUBA_R	lduba	[%r31, %r0] 0x74, %r15
	.word 0xd2b44400  ! 1686: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0x87802072  ! 1687: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 1688: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2972000  ! 1689: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xd2976000  ! 1690: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0xdc8dc4a0  ! 1691: LDUBA_R	lduba	[%r23, %r0] 0x25, %r14
	.word 0x8780204f  ! 1692: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r19
	.word 0xd096c9e0  ! 1694: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r8
	.word 0xd09ee000  ! 1695: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r8
	mov	0x68, %r18
	.word 0xd6af4e80  ! 1697: STBA_R	stba	%r11, [%r29 + %r0] 0x74
	.word 0xd2944400  ! 1698: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	.word 0xd2ce2000  ! 1699: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r9
	.word 0x87802074  ! 1700: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2afa000  ! 1701: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xd28fa000  ! 1702: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	.word 0xd2876000  ! 1703: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xdeafce80  ! 1704: STBA_R	stba	%r15, [%r31 + %r0] 0x74
	.word 0xd4aec9e0  ! 1705: STBA_R	stba	%r10, [%r27 + %r0] 0x4f
	.word 0xd4bfe000  ! 1706: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xd4aec9e0  ! 1708: STBA_R	stba	%r10, [%r27 + %r0] 0x4f
	.word 0xd0c48400  ! 1709: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r8
	.word 0xdcc6c9e0  ! 1710: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r14
	.word 0x87802073  ! 1711: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6944400  ! 1712: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	.word 0xd6af6000  ! 1713: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd6afe000  ! 1714: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd4b649e0  ! 1715: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	mov	0x7f8, %r21
	mov	0x8, %r24
	mov	0x40, %r19
	.word 0xd09c4400  ! 1719: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	mov	0x30, %r19
	.word 0x87802072  ! 1721: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0cfe000  ! 1722: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1723: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca40400  ! 1724: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xdcbc2000  ! 1725: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	mov	0x68, %r18
	.word 0xded78e80  ! 1727: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r15
	.word 0xdeac4400  ! 1728: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0xdeaf8e80  ! 1729: STBA_R	stba	%r15, [%r30 + %r0] 0x74
	.word 0xdea4a000  ! 1730: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xdea42000  ! 1731: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	mov	0x10, %r26
	.word 0xded46000  ! 1733: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	mov	0x0, %r27
	.word 0xde9c6000  ! 1735: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0xdec4e000  ! 1736: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	.word 0xdeb46000  ! 1737: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0xde84a000  ! 1738: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	.word 0xde9ce000  ! 1739: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0xd2cf0e40  ! 1740: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r9
	.word 0xd2b42000  ! 1741: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 1742: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r19
	.word 0xd2b4e000  ! 1744: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0xd2d4e000  ! 1745: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0xd2f4e000  ! 1746: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd0b689e0  ! 1747: STHA_R	stha	%r8, [%r26 + %r0] 0x4f
	.word 0xd0aca000  ! 1748: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 1749: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 1750: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 1751: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r24
	mov	0x78, %r27
	.word 0xdc9e89e0  ! 1754: LDDA_R	ldda	[%r26, %r0] 0x4f, %r14
	.word 0xdca76000  ! 1755: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcbf2000  ! 1756: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdc872000  ! 1757: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xd6ae89e0  ! 1758: STBA_R	stba	%r11, [%r26 + %r0] 0x4f
	.word 0xd687e000  ! 1759: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xda95c4a0  ! 1760: LDUHA_R	lduha	[%r23, %r0] 0x25, %r13
	mov	0x50, %r17
	.word 0xda8fe000  ! 1762: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xdab7a000  ! 1763: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdaafe000  ! 1764: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xdacf2000  ! 1765: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0x87802073  ! 1766: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 1767: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r24
	.word 0xd2f544a0  ! 1769: STXA_R	stxa	%r9, [%r21 + %r0] 0x25
	.word 0xd2a7a000  ! 1770: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xdcdf8e60  ! 1771: LDXA_R	ldxa	[%r30, %r0] 0x73, %r14
	.word 0xdcc7e000  ! 1772: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcb7a000  ! 1773: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xd2dc8400  ! 1774: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	mov	0x40, %r27
	.word 0x87802020  ! 1776: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1777: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ac6000  ! 1778: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 1779: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1780: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 1781: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 1782: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f62000  ! 1783: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	.word 0xd48f4e80  ! 1784: LDUBA_R	lduba	[%r29, %r0] 0x74, %r10
	.word 0xd09f8e80  ! 1785: LDDA_R	ldda	[%r30, %r0] 0x74, %r8
	.word 0xd0de6000  ! 1786: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r8
	.word 0xdcbc0400  ! 1787: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0x87802020  ! 1788: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b74e80  ! 1789: STHA_R	stha	%r11, [%r29 + %r0] 0x74
	mov	0x7d0, %r23
	mov	0x18, %r17
	.word 0x87802020  ! 1792: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbfce40  ! 1793: STDA_R	stda	%r14, [%r31 + %r0] 0x72
	.word 0xdcbc6000  ! 1794: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xdede09e0  ! 1795: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r15
	.word 0xdec46000  ! 1796: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	.word 0xdef46000  ! 1797: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 1798: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2f5c4a0  ! 1799: STXA_R	stxa	%r9, [%r23 + %r0] 0x25
	.word 0x87802073  ! 1800: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2976000  ! 1802: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0xd2a7e000  ! 1803: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xdec48400  ! 1804: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	mov	0x18, %r19
	mov	0x0, %r25
	.word 0x8780204f  ! 1807: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b649e0  ! 1808: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	.word 0xd4de6000  ! 1809: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r10
	mov	0x28, %r24
	.word 0x87802025  ! 1811: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 1812: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a7ce60  ! 1813: STWA_R	stwa	%r8, [%r31 + %r0] 0x73
	.word 0xd0dfa000  ! 1814: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0cf6000  ! 1815: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1816: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0cda000  ! 1817: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r8
	.word 0xdea4c400  ! 1818: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	mov	0x7c8, %r23
	.word 0xdea5e000  ! 1820: STWA_I	stwa	%r15, [%r23 + 0x0000] %asi
	.word 0xdead6000  ! 1821: STBA_I	stba	%r15, [%r21 + 0x0000] %asi
	.word 0xdad70e80  ! 1822: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r13
	mov	0x10, %r25
	.word 0xd8bd44a0  ! 1824: STDA_R	stda	%r12, [%r21 + %r0] 0x25
	.word 0xd2ce09e0  ! 1825: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r9
	.word 0xdedf4e80  ! 1826: LDXA_R	ldxa	[%r29, %r0] 0x74, %r15
	mov	0x3f0, %r22
	mov	0x10, %r24
	.word 0x87802020  ! 1829: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef4a000  ! 1830: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0xd4f78e40  ! 1831: STXA_R	stxa	%r10, [%r30 + %r0] 0x72
	.word 0xd4c4a000  ! 1832: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	.word 0xd4dce000  ! 1833: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	.word 0xd4c4a000  ! 1834: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	.word 0xd8a78e80  ! 1835: STWA_R	stwa	%r12, [%r30 + %r0] 0x74
	.word 0xd8cc2000  ! 1836: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r12
	.word 0xde970e40  ! 1837: LDUHA_R	lduha	[%r28, %r0] 0x72, %r15
	.word 0xdeb4e000  ! 1838: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0xdec42000  ! 1839: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0xd08544a0  ! 1840: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r8
	.word 0xd4974e60  ! 1841: LDUHA_R	lduha	[%r29, %r0] 0x73, %r10
	mov	0x3f0, %r22
	.word 0x87802020  ! 1843: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ccc400  ! 1844: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r12
	.word 0x87802074  ! 1845: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8a7a000  ! 1846: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	mov	0x10, %r27
	.word 0x87802025  ! 1848: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8b52000  ! 1849: STHA_I	stha	%r12, [%r20 + 0x0000] %asi
	.word 0xd8f5e000  ! 1850: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	.word 0xdad4c400  ! 1851: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xdca4c400  ! 1852: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xd4b44400  ! 1853: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	.word 0xd4ade000  ! 1854: STBA_I	stba	%r10, [%r23 + 0x0000] %asi
	.word 0xde974e60  ! 1855: LDUHA_R	lduha	[%r29, %r0] 0x73, %r15
	.word 0xdedd04a0  ! 1856: LDXA_R	ldxa	[%r20, %r0] 0x25, %r15
	.word 0xde856000  ! 1857: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r15
	.word 0x87802072  ! 1858: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 1859: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 1860: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdedf6000  ! 1861: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	mov	0x3f0, %r20
	.word 0xded7e000  ! 1863: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	mov	0x7d8, %r20
	.word 0xde9f2000  ! 1865: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 1866: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd28504a0  ! 1867: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r9
	.word 0xdaa4c400  ! 1868: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0xdaa62000  ! 1869: STWA_I	stwa	%r13, [%r24 + 0x0000] %asi
	.word 0x87802072  ! 1870: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdacfe000  ! 1871: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0xd4ac8400  ! 1872: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0xd4d7e000  ! 1873: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	mov	0x68, %r17
	.word 0x87802072  ! 1875: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a7e000  ! 1876: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd48f2000  ! 1877: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4af0e60  ! 1878: STBA_R	stba	%r10, [%r28 + %r0] 0x73
	.word 0x87802020  ! 1879: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1880: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r27
	.word 0xd487a000  ! 1882: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	mov	0x30, %r26
	.word 0xd6f70e80  ! 1884: STXA_R	stxa	%r11, [%r28 + %r0] 0x74
	mov	0x10, %r24
	mov	0x40, %r24
	.word 0xd6cf2000  ! 1887: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0xd6bfe000  ! 1888: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xdef609e0  ! 1889: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	.word 0x87802072  ! 1890: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49504a0  ! 1891: LDUHA_R	lduha	[%r20, %r0] 0x25, %r10
	.word 0xd8df4e80  ! 1892: LDXA_R	ldxa	[%r29, %r0] 0x74, %r12
	mov	0x78, %r16
	mov	0x3c8, %r22
	mov	0x40, %r27
	.word 0x87802073  ! 1896: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d8, %r21
	mov	0x48, %r26
	.word 0xd8bfe000  ! 1899: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	mov	0x70, %r27
	mov	0x38, %r26
	.word 0xd6dfce40  ! 1902: LDXA_R	ldxa	[%r31, %r0] 0x72, %r11
	.word 0xd68fe000  ! 1903: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xd6af2000  ! 1904: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x70, %r27
	mov	0x48, %r26
	.word 0xd6b649e0  ! 1907: STHA_R	stha	%r11, [%r25 + %r0] 0x4f
	.word 0xd6f7a000  ! 1908: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6a7a000  ! 1909: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6d44400  ! 1910: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r11
	.word 0xd4cf4e40  ! 1911: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r10
	mov	0x50, %r17
	.word 0x8780204f  ! 1913: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0c504a0  ! 1914: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r8
	.word 0xd2844400  ! 1915: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	.word 0xdeafce80  ! 1916: STBA_R	stba	%r15, [%r31 + %r0] 0x74
	mov	0x68, %r24
	.word 0xdea6e000  ! 1918: STWA_I	stwa	%r15, [%r27 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xdea6a000  ! 1920: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	.word 0xd0ae49e0  ! 1921: STBA_R	stba	%r8, [%r25 + %r0] 0x4f
	.word 0xd29f4e40  ! 1922: LDDA_R	ldda	[%r29, %r0] 0x72, %r9
	.word 0xde95c4a0  ! 1923: LDUHA_R	lduha	[%r23, %r0] 0x25, %r15
	.word 0xd0dd84a0  ! 1924: LDXA_R	ldxa	[%r22, %r0] 0x25, %r8
	.word 0xd0be6000  ! 1925: STDA_I	stda	%r8, [%r25 + 0x0000] %asi
	.word 0xd09ea000  ! 1926: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r8
	.word 0xd0af4e60  ! 1927: STBA_R	stba	%r8, [%r29 + %r0] 0x73
	.word 0xde8f8e60  ! 1928: LDUBA_R	lduba	[%r30, %r0] 0x73, %r15
	.word 0xdebea000  ! 1929: STDA_I	stda	%r15, [%r26 + 0x0000] %asi
	.word 0xde9e2000  ! 1930: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r15
	mov	0x7c0, %r22
	.word 0xd4a5c4a0  ! 1932: STWA_R	stwa	%r10, [%r23 + %r0] 0x25
	.word 0xd6c74e60  ! 1933: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r11
	.word 0xd6c66000  ! 1934: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r11
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x10, %r16
	.word 0xdecc0400  ! 1937: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r15
	.word 0xde8e6000  ! 1938: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r15
	.word 0xdef62000  ! 1939: STXA_I	stxa	%r15, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 1940: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r17
	.word 0xd694c400  ! 1942: LDUHA_R	lduha	[%r19, %r0] 0x20, %r11
	.word 0x87802025  ! 1943: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f5e000  ! 1944: STXA_I	stxa	%r11, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 1945: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0df4e40  ! 1946: LDXA_R	ldxa	[%r29, %r0] 0x72, %r8
	mov	0x3f8, %r23
	wr_tick_cmpr_0_16:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc9, %g2
	or	%g4, 0xd2, %g4
	or	%g6, 0xc9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3d8, %r21
	.word 0xd4b74e60  ! 1950: STHA_R	stha	%r10, [%r29 + %r0] 0x73
	.word 0xd4dc6000  ! 1951: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	.word 0xd4bca000  ! 1952: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	mov	0x60, %r25
	.word 0xdab48400  ! 1954: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0x87802025  ! 1955: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8f7ce40  ! 1956: STXA_R	stxa	%r12, [%r31 + %r0] 0x72
	mov	0x20, %r18
	.word 0xd8dda000  ! 1958: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r12
	.word 0xd0ce09e0  ! 1959: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r8
	.word 0x87802025  ! 1960: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1961: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaacc400  ! 1962: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0xdaf46000  ! 1963: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	mov	0x58, %r18
	.word 0x8780204f  ! 1965: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r19
	.word 0xdaf70e60  ! 1967: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	.word 0xd2970e80  ! 1968: LDUHA_R	lduha	[%r28, %r0] 0x74, %r9
	.word 0xd286e000  ! 1969: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r9
	mov	0x10, %r17
	mov	0x30, %r17
	.word 0xd2b6e000  ! 1972: STHA_I	stha	%r9, [%r27 + 0x0000] %asi
	.word 0xd2de2000  ! 1973: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r9
	mov	0x30, %r19
	.word 0x87802020  ! 1975: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r19
	.word 0xd2dca000  ! 1977: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r9
	.word 0x87802074  ! 1978: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2874e40  ! 1979: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r9
	mov	0x30, %r24
	.word 0xd2df6000  ! 1981: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0xd087ce80  ! 1982: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r8
	.word 0x87802020  ! 1983: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9544a0  ! 1984: LDUHA_R	lduha	[%r21, %r0] 0x25, %r13
	.word 0x87802072  ! 1985: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdadfe000  ! 1986: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0xd0bc4400  ! 1987: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xd6de89e0  ! 1988: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r11
	mov	0x20, %r27
	.word 0xd6bc4400  ! 1990: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	mov	0x68, %r16
	.word 0xd6afe000  ! 1992: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd8bc4400  ! 1993: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0x87802073  ! 1994: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 1995: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd885a000  ! 1996: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r12
	.word 0xd8d5a000  ! 1997: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r12
	.word 0x87802074  ! 1998: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r26
	.word 0xd8f74e60  ! 2000: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	.word 0x87802072  ! 2001: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0d40400  ! 2002: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	.word 0x87802020  ! 2003: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b4a000  ! 2004: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xde9f0e60  ! 2005: LDDA_R	ldda	[%r28, %r0] 0x73, %r15
	mov	0x3e8, %r23
	mov	0x40, %r26
	.word 0xde94a000  ! 2008: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0xd4f649e0  ! 2009: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	.word 0xd49c6000  ! 2010: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0x87802025  ! 2011: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4bd6000  ! 2012: STDA_I	stda	%r10, [%r21 + 0x0000] %asi
	.word 0xdc94c400  ! 2013: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	.word 0x87802025  ! 2014: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 2015: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2016: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde974e40  ! 2017: LDUHA_R	lduha	[%r29, %r0] 0x72, %r15
	.word 0xde8c2000  ! 2018: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	mov	0x40, %r19
	.word 0xde9c2000  ! 2020: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	mov	0x18, %r25
	mov	0x78, %r17
	.word 0xd88cc400  ! 2023: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	mov	0x10, %r25
	.word 0xd8942000  ! 2025: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r12
	mov	0x20, %r19
	.word 0x87802072  ! 2027: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8cf2000  ! 2028: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0xdcac4400  ! 2029: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	.word 0x87802072  ! 2030: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcafe000  ! 2031: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdaa78e60  ! 2032: STWA_R	stwa	%r13, [%r30 + %r0] 0x73
	mov	0x48, %r24
	.word 0xdaf76000  ! 2034: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xd4f70e40  ! 2035: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	.word 0x8780204f  ! 2036: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d8, %r22
	.word 0x87802074  ! 2038: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdead04a0  ! 2039: STBA_R	stba	%r15, [%r20 + %r0] 0x25
	.word 0xdeb76000  ! 2040: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	mov	0x10, %r26
	.word 0xded72000  ! 2042: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xd4d74e40  ! 2043: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r10
	.word 0x87802020  ! 2044: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r22
	.word 0xd2bfce60  ! 2046: STDA_R	stda	%r9, [%r31 + %r0] 0x73
	mov	0x28, %r18
	mov	0x28, %r17
	.word 0xd29ce000  ! 2049: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	mov	0x70, %r18
	.word 0xd2ace000  ! 2051: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	mov	0x10, %r24
	.word 0xd2f42000  ! 2053: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 2054: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r16
	mov	0x3e8, %r22
	.word 0xd2d76000  ! 2057: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2058: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b42000  ! 2059: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 2060: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bfa000  ! 2061: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 2062: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2946000  ! 2063: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r9
	.word 0xd2aca000  ! 2064: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 2065: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebf4e80  ! 2066: STDA_R	stda	%r15, [%r29 + %r0] 0x74
	.word 0xd0dec9e0  ! 2067: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r8
	.word 0xd2af0e80  ! 2068: STBA_R	stba	%r9, [%r28 + %r0] 0x74
	.word 0xd2ade000  ! 2069: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	wr_tick_cmpr_0_17:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x92, %g2
	or	%g4, 0x9a, %g4
	or	%g6, 0xcd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x70, %r27
	.word 0x87802020  ! 2072: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r24
	.word 0xd29ce000  ! 2074: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xd2ace000  ! 2075: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0xd2a4c400  ! 2076: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	mov	0x7c8, %r21
	.word 0xd2ace000  ! 2078: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0xdcb544a0  ! 2079: STHA_R	stha	%r14, [%r21 + %r0] 0x25
	.word 0xdc9c2000  ! 2080: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r14
	.word 0xdcaca000  ! 2081: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xdcbc6000  ! 2082: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xdca4a000  ! 2083: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0xd4870e60  ! 2084: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r10
	mov	0x7c8, %r21
	mov	0x68, %r25
	.word 0xdacc8400  ! 2087: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r13
	.word 0xdaf46000  ! 2088: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	mov	0x78, %r27
	.word 0xd2a7ce80  ! 2090: STWA_R	stwa	%r9, [%r31 + %r0] 0x74
	.word 0xdaf649e0  ! 2091: STXA_R	stxa	%r13, [%r25 + %r0] 0x4f
	.word 0xdaa46000  ! 2092: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	.word 0xdabca000  ! 2093: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xda8c2000  ! 2094: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r13
	.word 0xd8c40400  ! 2095: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	.word 0x87802074  ! 2096: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 2097: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd89fa000  ! 2098: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	.word 0xd8878e80  ! 2099: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r12
	mov	0x3f8, %r22
	.word 0xd8a72000  ! 2101: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd0bfce40  ! 2102: STDA_R	stda	%r8, [%r31 + %r0] 0x72
	.word 0x87802020  ! 2103: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b46000  ! 2104: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0xdaaf4e40  ! 2105: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	.word 0xdc870e80  ! 2106: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r14
	mov	0x7c0, %r23
	.word 0xdcace000  ! 2108: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0xdcc42000  ! 2109: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2110: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r23
	mov	0x3f8, %r23
	.word 0xde97ce60  ! 2113: LDUHA_R	lduha	[%r31, %r0] 0x73, %r15
	wr_tick_cmpr_0_18:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xed, %g2
	or	%g4, 0xe3, %g4
	or	%g6, 0xef, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x58, %r16
	mov	0x28, %r26
	.word 0xdea46000  ! 2117: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 2118: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 2119: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a609e0  ! 2120: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	mov	0x3e8, %r23
	.word 0xd4a6a000  ! 2122: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	.word 0xd0dc0400  ! 2123: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xd2ac4400  ! 2124: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xd2be2000  ! 2125: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	mov	0x20, %r24
	.word 0xd6b48400  ! 2127: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd4a4c400  ! 2128: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0x87802074  ! 2129: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2af0e80  ! 2130: STBA_R	stba	%r9, [%r28 + %r0] 0x74
	.word 0xd48d04a0  ! 2131: LDUBA_R	lduba	[%r20, %r0] 0x25, %r10
	mov	0x8, %r16
	.word 0x8780204f  ! 2133: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f504a0  ! 2134: STXA_R	stxa	%r8, [%r20 + %r0] 0x25
	.word 0xdab649e0  ! 2135: STHA_R	stha	%r13, [%r25 + %r0] 0x4f
	.word 0xdabea000  ! 2136: STDA_I	stda	%r13, [%r26 + 0x0000] %asi
	.word 0xdace2000  ! 2137: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r13
	.word 0xda86a000  ! 2138: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r13
	.word 0xdaa6a000  ! 2139: STWA_I	stwa	%r13, [%r26 + 0x0000] %asi
	mov	0x58, %r24
	.word 0xdaaf8e40  ! 2141: STBA_R	stba	%r13, [%r30 + %r0] 0x72
	.word 0xd8b7ce80  ! 2142: STHA_R	stha	%r12, [%r31 + %r0] 0x74
	mov	0x78, %r19
	mov	0x68, %r18
	.word 0xd8f62000  ! 2145: STXA_I	stxa	%r12, [%r24 + 0x0000] %asi
	.word 0xd8b62000  ! 2146: STHA_I	stha	%r12, [%r24 + 0x0000] %asi
	.word 0xd2c4c400  ! 2147: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0xd2a6e000  ! 2148: STWA_I	stwa	%r9, [%r27 + 0x0000] %asi
	.word 0xd2bee000  ! 2149: STDA_I	stda	%r9, [%r27 + 0x0000] %asi
	.word 0xd2ce2000  ! 2150: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r9
	.word 0xd286e000  ! 2151: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r9
	.word 0xd6840400  ! 2152: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0xd6d62000  ! 2153: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r11
	mov	0x28, %r25
	.word 0xd69e2000  ! 2155: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r11
	mov	0x58, %r24
	.word 0xd0f7ce40  ! 2157: STXA_R	stxa	%r8, [%r31 + %r0] 0x72
	.word 0x87802020  ! 2158: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r22
	.word 0xd0f42000  ! 2160: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 2161: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2162: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r26
	.word 0xdad6c9e0  ! 2164: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r13
	.word 0xdab649e0  ! 2165: STHA_R	stha	%r13, [%r25 + %r0] 0x4f
	.word 0x87802073  ! 2166: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r26
	.word 0xdad72000  ! 2168: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	mov	0x68, %r27
	.word 0xdab7a000  ! 2170: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdaafce80  ! 2171: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	.word 0x87802074  ! 2172: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r27
	.word 0xdabf2000  ! 2174: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	mov	0x38, %r17
	mov	0x3e0, %r21
	mov	0x7d8, %r22
	.word 0xdaf76000  ! 2178: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 2179: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2180: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabc6000  ! 2181: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xdacca000  ! 2182: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	.word 0xdadc2000  ! 2183: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r13
	.word 0xdaf4e000  ! 2184: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xd68f8e80  ! 2185: LDUBA_R	lduba	[%r30, %r0] 0x74, %r11
	mov	0x3d0, %r23
	.word 0x8780204f  ! 2187: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2188: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf74e60  ! 2189: STXA_R	stxa	%r14, [%r29 + %r0] 0x73
	.word 0xdcf4a000  ! 2190: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xd8a649e0  ! 2191: STWA_R	stwa	%r12, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 2192: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc870e80  ! 2193: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r14
	.word 0x87802025  ! 2194: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f0, %r20
	.word 0xdcad2000  ! 2196: STBA_I	stba	%r14, [%r20 + 0x0000] %asi
	mov	0x50, %r19
	.word 0xd68504a0  ! 2198: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r11
	mov	0x78, %r27
	.word 0xd0a74e40  ! 2200: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	.word 0x87802073  ! 2201: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2202: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r26
	.word 0xd08ce000  ! 2204: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xd2f7ce60  ! 2205: STXA_R	stxa	%r9, [%r31 + %r0] 0x73
	.word 0x87802073  ! 2206: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a4c400  ! 2207: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xd0df6000  ! 2208: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0b76000  ! 2210: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd08fe000  ! 2211: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	mov	0x3c0, %r23
	.word 0xdeb584a0  ! 2213: STHA_R	stha	%r15, [%r22 + %r0] 0x25
	.word 0xdef7e000  ! 2214: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xd2afce40  ! 2216: STBA_R	stba	%r9, [%r31 + %r0] 0x72
	.word 0xd2872000  ! 2217: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	mov	0x68, %r24
	mov	0x18, %r18
	.word 0xd2b7e000  ! 2220: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd29f2000  ! 2221: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	mov	0x3e0, %r20
	.word 0xdc87ce80  ! 2223: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r14
	.word 0xde8dc4a0  ! 2224: LDUBA_R	lduba	[%r23, %r0] 0x25, %r15
	.word 0xdeb76000  ! 2225: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xdeafa000  ! 2226: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xd484c400  ! 2227: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	mov	0x3c8, %r21
	.word 0xd4f544a0  ! 2229: STXA_R	stxa	%r10, [%r21 + %r0] 0x25
	.word 0xd4cfe000  ! 2230: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0xd49f6000  ! 2231: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0x87802020  ! 2232: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd494e000  ! 2233: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	.word 0xd4f46000  ! 2234: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	wr_tick_cmpr_0_19:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe7, %g2
	or	%g4, 0xa9, %g4
	or	%g6, 0xb7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 2236: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cd84a0  ! 2237: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r9
	mov	0x8, %r25
	.word 0xda8f0e60  ! 2239: LDUBA_R	lduba	[%r28, %r0] 0x73, %r13
	.word 0xd8af8e60  ! 2240: STBA_R	stba	%r12, [%r30 + %r0] 0x73
	.word 0xd8cf4e40  ! 2241: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r12
	.word 0xd894e000  ! 2242: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r12
	.word 0xd8c46000  ! 2243: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r12
	mov	0x40, %r17
	.word 0xdcd70e60  ! 2245: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r14
	.word 0xdcc4a000  ! 2246: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r14
	.word 0xd88e09e0  ! 2247: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r12
	.word 0xdc8c4400  ! 2248: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0xdc8ca000  ! 2249: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r14
	.word 0xd4b544a0  ! 2250: STHA_R	stha	%r10, [%r21 + %r0] 0x25
	.word 0xd6acc400  ! 2251: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xdedf4e40  ! 2252: LDXA_R	ldxa	[%r29, %r0] 0x72, %r15
	.word 0xde8ce000  ! 2253: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 2254: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebea000  ! 2255: STDA_I	stda	%r15, [%r26 + 0x0000] %asi
	.word 0x87802025  ! 2256: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde9f8e40  ! 2257: LDDA_R	ldda	[%r30, %r0] 0x72, %r15
	.word 0xd2de89e0  ! 2258: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r9
	.word 0xd2f56000  ! 2259: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	.word 0xd2ade000  ! 2260: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 2261: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r27
	.word 0xd2c72000  ! 2263: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	wr_tick_cmpr_0_20:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x9a, %g2
	or	%g4, 0xd8, %g4
	or	%g6, 0xab, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	wr_tick_cmpr_0_21:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xcd, %g2
	or	%g4, 0xe2, %g4
	or	%g6, 0xfd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2876000  ! 2266: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0x87802072  ! 2267: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2bf6000  ! 2268: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 2269: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f0, %r22
	.word 0xd88c0400  ! 2271: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	.word 0xd885a000  ! 2272: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r12
	.word 0xd09544a0  ! 2273: LDUHA_R	lduha	[%r21, %r0] 0x25, %r8
	.word 0xd0d5a000  ! 2274: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r8
	.word 0x87802020  ! 2275: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdecc8400  ! 2276: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	.word 0xdebc6000  ! 2277: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xdedca000  ! 2278: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xde842000  ! 2279: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	.word 0x87802025  ! 2280: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6af0e40  ! 2281: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	mov	0x20, %r26
	.word 0xd6d5a000  ! 2283: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r11
	mov	0x20, %r18
	.word 0xd685a000  ! 2285: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r11
	.word 0x87802025  ! 2286: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd68de000  ! 2287: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r11
	.word 0xd6bd6000  ! 2288: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0x87802025  ! 2289: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r19
	.word 0xd6bd6000  ! 2291: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 2292: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdedcc400  ! 2293: LDXA_R	ldxa	[%r19, %r0] 0x20, %r15
	mov	0x10, %r17
	.word 0xd6bf4e60  ! 2295: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	.word 0xd6a6e000  ! 2296: STWA_I	stwa	%r11, [%r27 + 0x0000] %asi
	mov	0x50, %r16
	.word 0x87802072  ! 2298: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdad40400  ! 2299: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	.word 0xdab72000  ! 2300: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdab74e40  ! 2301: STHA_R	stha	%r13, [%r29 + %r0] 0x72
	.word 0xdab72000  ! 2302: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2303: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r26
	.word 0xdabc6000  ! 2305: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xdabca000  ! 2306: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdadce000  ! 2307: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xdacc6000  ! 2308: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	.word 0xd6d74e80  ! 2309: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r11
	.word 0xd6dca000  ! 2310: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r11
	mov	0x48, %r17
	mov	0x28, %r27
	.word 0xd6bc2000  ! 2313: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0xd4844400  ! 2314: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0xd8b74e60  ! 2315: STHA_R	stha	%r12, [%r29 + %r0] 0x73
	.word 0xd8a4e000  ! 2316: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xd8c4e000  ! 2317: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	mov	0x0, %r27
	.word 0xd8a46000  ! 2319: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	mov	0x0, %r27
	.word 0xdead04a0  ! 2321: STBA_R	stba	%r15, [%r20 + %r0] 0x25
	.word 0xdeb4a000  ! 2322: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0xd6f78e80  ! 2323: STXA_R	stxa	%r11, [%r30 + %r0] 0x74
	.word 0xd49e89e0  ! 2324: LDDA_R	ldda	[%r26, %r0] 0x4f, %r10
	.word 0xd4aca000  ! 2325: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0xd4dc6000  ! 2326: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	mov	0x20, %r24
	.word 0xd0f44400  ! 2328: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd08ca000  ! 2329: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xd08c6000  ! 2330: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0xd895c4a0  ! 2331: LDUHA_R	lduha	[%r23, %r0] 0x25, %r12
	.word 0xd28f4e40  ! 2332: LDUBA_R	lduba	[%r29, %r0] 0x72, %r9
	.word 0xd2d48400  ! 2333: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	mov	0x3d0, %r22
	.word 0xd6a70e60  ! 2335: STWA_R	stwa	%r11, [%r28 + %r0] 0x73
	.word 0xd8f40400  ! 2336: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	mov	0x60, %r16
	.word 0x87802020  ! 2338: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r16
	.word 0xd8a4a000  ! 2340: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8b42000  ! 2341: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	.word 0xd89ca000  ! 2342: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r12
	.word 0xd8f46000  ! 2343: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8ace000  ! 2344: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0xd8842000  ! 2345: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	.word 0x87802072  ! 2346: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4840400  ! 2347: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	.word 0xd8c74e60  ! 2348: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r12
	.word 0xdeb78e60  ! 2349: STHA_R	stha	%r15, [%r30 + %r0] 0x73
	.word 0xdeb76000  ! 2350: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xdec7a000  ! 2351: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xdacfce40  ! 2352: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r13
	mov	0x60, %r27
	.word 0xd4a48400  ! 2354: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	mov	0x40, %r17
	mov	0x60, %r24
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x8780204f  ! 2358: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d0, %r21
	.word 0x87802025  ! 2360: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4d5a000  ! 2361: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r10
	.word 0xdccf8e60  ! 2362: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r14
	.word 0xdc8da000  ! 2363: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r14
	.word 0x87802072  ! 2364: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r16
	.word 0xdc876000  ! 2366: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	mov	0x3f0, %r21
	.word 0xdc8dc4a0  ! 2368: LDUBA_R	lduba	[%r23, %r0] 0x25, %r14
	.word 0xde8f4e40  ! 2369: LDUBA_R	lduba	[%r29, %r0] 0x72, %r15
	.word 0xdeb7a000  ! 2370: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xdac649e0  ! 2371: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r13
	.word 0xdadfa000  ! 2372: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	mov	0x3c0, %r20
	.word 0xdaafe000  ! 2374: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xdaf7e000  ! 2375: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xda9fe000  ! 2377: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2378: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09f8e80  ! 2379: LDDA_R	ldda	[%r30, %r0] 0x74, %r8
	.word 0xd88c0400  ! 2380: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	mov	0x40, %r18
	mov	0x60, %r16
	mov	0x38, %r16
	.word 0xd8d4e000  ! 2384: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0xdab689e0  ! 2385: STHA_R	stha	%r13, [%r26 + %r0] 0x4f
	.word 0x8780204f  ! 2386: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda866000  ! 2387: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r13
	.word 0xdabf4e40  ! 2388: STDA_R	stda	%r13, [%r29 + %r0] 0x72
	.word 0xdca7ce80  ! 2389: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	.word 0x8780204f  ! 2390: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6cf0e40  ! 2391: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r11
	wr_tick_cmpr_0_22:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xff, %g2
	or	%g4, 0xd6, %g4
	or	%g6, 0xde, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2978e80  ! 2393: LDUHA_R	lduha	[%r30, %r0] 0x74, %r9
	.word 0xd2dea000  ! 2394: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r9
	.word 0xd2f6a000  ! 2395: STXA_I	stxa	%r9, [%r26 + 0x0000] %asi
	.word 0xdaae49e0  ! 2396: STBA_R	stba	%r13, [%r25 + %r0] 0x4f
	.word 0x8780204f  ! 2397: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdac62000  ! 2398: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r13
	.word 0x87802073  ! 2399: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2cf8e40  ! 2400: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r9
	.word 0x87802074  ! 2401: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2402: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f70e80  ! 2403: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	.word 0xd8a72000  ! 2404: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd49609e0  ! 2405: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r10
	.word 0x87802020  ! 2406: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f4e000  ! 2407: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	mov	0x68, %r18
	mov	0x3e0, %r21
	.word 0xd09cc400  ! 2410: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	.word 0xd0bc6000  ! 2411: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	mov	0x70, %r16
	.word 0xd0f42000  ! 2413: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0xdcae09e0  ! 2414: STBA_R	stba	%r14, [%r24 + %r0] 0x4f
	.word 0xdccc2000  ! 2415: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r14
	.word 0xdebf0e80  ! 2416: STDA_R	stda	%r15, [%r28 + %r0] 0x74
	.word 0xdaf584a0  ! 2417: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	.word 0x8780204f  ! 2418: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r17
	.word 0xd4bec9e0  ! 2420: STDA_R	stda	%r10, [%r27 + %r0] 0x4f
	.word 0xd4bee000  ! 2421: STDA_I	stda	%r10, [%r27 + 0x0000] %asi
	.word 0xd0ac4400  ! 2422: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0xd0f62000  ! 2423: STXA_I	stxa	%r8, [%r24 + 0x0000] %asi
	.word 0xd4bf4e60  ! 2424: STDA_R	stda	%r10, [%r29 + %r0] 0x73
	.word 0xd4ae6000  ! 2425: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0x8780204f  ! 2426: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2427: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r26
	mov	0x7d8, %r20
	mov	0x28, %r26
	mov	0x28, %r17
	mov	0x7e0, %r23
	.word 0xde9d04a0  ! 2433: LDDA_R	ldda	[%r20, %r0] 0x25, %r15
	.word 0xde8ca000  ! 2434: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 2435: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xded66000  ! 2436: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r15
	.word 0xdea6a000  ! 2437: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	.word 0xd0dc4400  ! 2438: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	.word 0xda9e89e0  ! 2439: LDDA_R	ldda	[%r26, %r0] 0x4f, %r13
	mov	0x20, %r25
	mov	0x8, %r27
	.word 0x8780204f  ! 2442: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2b4c400  ! 2443: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	mov	0x50, %r18
	mov	0x28, %r18
	mov	0x58, %r27
	mov	0x3e8, %r21
	.word 0xd2966000  ! 2448: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r9
	.word 0xd0840400  ! 2449: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	.word 0xdaa48400  ! 2450: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0xdacea000  ! 2451: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r13
	wr_tick_cmpr_0_23:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd2, %g2
	or	%g4, 0xc4, %g4
	or	%g6, 0xb3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4b6c9e0  ! 2453: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0xd48e6000  ! 2454: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r10
	.word 0x87802073  ! 2455: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2456: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bc2000  ! 2457: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0xdad544a0  ! 2458: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r13
	.word 0xdabc6000  ! 2459: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 2460: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdacd2000  ! 2461: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r13
	.word 0xd6f44400  ! 2462: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0xd6dde000  ! 2463: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r11
	.word 0xd6b5a000  ! 2464: STHA_I	stha	%r11, [%r22 + 0x0000] %asi
	.word 0xd6dd6000  ! 2465: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r11
	.word 0xd6d78e40  ! 2466: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r11
	.word 0xdc9689e0  ! 2467: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r14
	.word 0xdc8da000  ! 2468: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r14
	.word 0xd6cf8e80  ! 2469: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r11
	.word 0x87802025  ! 2470: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e8, %r23
	.word 0x87802020  ! 2472: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde870e40  ! 2473: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r15
	mov	0x3d8, %r22
	.word 0xdef46000  ! 2475: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xd6cc8400  ! 2476: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	.word 0xd2a7ce60  ! 2477: STWA_R	stwa	%r9, [%r31 + %r0] 0x73
	mov	0x8, %r26
	.word 0xdc844400  ! 2479: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	.word 0xdcf4a000  ! 2480: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcb4e000  ! 2481: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xdca42000  ! 2482: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xda9f4e40  ! 2483: LDDA_R	ldda	[%r29, %r0] 0x72, %r13
	.word 0xd8a40400  ! 2484: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	mov	0x7d8, %r22
	.word 0xd8f42000  ! 2486: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xdeae89e0  ! 2487: STBA_R	stba	%r15, [%r26 + %r0] 0x4f
	.word 0x87802073  ! 2488: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 2489: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb52000  ! 2490: STHA_I	stha	%r15, [%r20 + 0x0000] %asi
	.word 0xda9c4400  ! 2491: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	.word 0x87802020  ! 2492: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r26
	.word 0xda84e000  ! 2494: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r13
	.word 0xdab4a000  ! 2495: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0xd2844400  ! 2496: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	.word 0xd8844400  ! 2497: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r12
	.word 0xd49fce80  ! 2498: LDDA_R	ldda	[%r31, %r0] 0x74, %r10
	mov	0x3f0, %r23
	mov	0x3f0, %r23
	mov	0x7f8, %r23
	.word 0xd4870e80  ! 2502: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r10
	.word 0xd6f78e60  ! 2503: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	.word 0xdc9fce60  ! 2504: LDDA_R	ldda	[%r31, %r0] 0x73, %r14
	.word 0xdcac6000  ! 2505: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xd0870e60  ! 2506: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r8
	.word 0xd48f8e40  ! 2507: LDUBA_R	lduba	[%r30, %r0] 0x72, %r10
	.word 0x87802020  ! 2508: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0840400  ! 2509: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	.word 0xd0cc2000  ! 2510: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	mov	0x18, %r17
	.word 0xd494c400  ! 2512: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	.word 0xd49c2000  ! 2513: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	.word 0xd4d42000  ! 2514: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	.word 0xd4bec9e0  ! 2515: STDA_R	stda	%r10, [%r27 + %r0] 0x4f
	.word 0xd4a46000  ! 2516: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xd4b78e60  ! 2517: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	.word 0xd4c42000  ! 2518: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r10
	.word 0xd4942000  ! 2519: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r10
	.word 0xd4cca000  ! 2520: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r10
	mov	0x3e8, %r21
	.word 0xda8f4e40  ! 2522: LDUBA_R	lduba	[%r29, %r0] 0x72, %r13
	.word 0xdeccc400  ! 2523: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r15
	.word 0xdebca000  ! 2524: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xde84e000  ! 2525: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	mov	0x3c0, %r20
	.word 0xdec42000  ! 2527: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0xdeac6000  ! 2528: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	mov	0x20, %r18
	.word 0xdecc6000  ! 2530: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r15
	.word 0x87802020  ! 2531: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde942000  ! 2532: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	.word 0xd6b7ce40  ! 2533: STHA_R	stha	%r11, [%r31 + %r0] 0x72
	.word 0xd6f40400  ! 2534: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	.word 0xd68ca000  ! 2535: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2536: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b46000  ! 2537: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 2538: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8c70e80  ! 2539: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r12
	.word 0xd0dcc400  ! 2540: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0xdabfce80  ! 2541: STDA_R	stda	%r13, [%r31 + %r0] 0x74
	.word 0xd6d74e60  ! 2542: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r11
	.word 0xdec44400  ! 2543: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	mov	0x3c0, %r22
	.word 0x87802073  ! 2545: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeaf6000  ! 2546: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xd8f70e80  ! 2547: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	mov	0x50, %r27
	.word 0xd8b72000  ! 2549: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd8f7e000  ! 2550: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	mov	0x40, %r18
	.word 0xd88fe000  ! 2552: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8b7a000  ! 2553: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xd2cf4e40  ! 2554: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r9
	.word 0xd2af2000  ! 2555: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xdcf78e80  ! 2556: STXA_R	stxa	%r14, [%r30 + %r0] 0x74
	.word 0xdca72000  ! 2557: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xd6d6c9e0  ! 2558: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r11
	.word 0xd4b74e40  ! 2559: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	.word 0xd6d74e60  ! 2560: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r11
	mov	0x3e0, %r21
	mov	0x48, %r16
	mov	0x7e0, %r20
	.word 0xdcbe49e0  ! 2564: STDA_R	stda	%r14, [%r25 + %r0] 0x4f
	mov	0x70, %r19
	mov	0x3c0, %r23
	.word 0x87802025  ! 2567: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcdd2000  ! 2568: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r14
	.word 0xdc9d6000  ! 2569: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r14
	.word 0xd2a74e60  ! 2570: STWA_R	stwa	%r9, [%r29 + %r0] 0x73
	.word 0xd8dc8400  ! 2571: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	mov	0x78, %r26
	.word 0xd8b5a000  ! 2573: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	.word 0xd8dd6000  ! 2574: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r12
	.word 0xdeb78e80  ! 2575: STHA_R	stha	%r15, [%r30 + %r0] 0x74
	.word 0xdcae89e0  ! 2576: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	.word 0xda8f0e80  ! 2577: LDUBA_R	lduba	[%r28, %r0] 0x74, %r13
	.word 0xda95a000  ! 2578: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r13
	.word 0xdaf5a000  ! 2579: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xda9de000  ! 2580: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r13
	.word 0xd8afce40  ! 2581: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	.word 0xd8ad2000  ! 2582: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	.word 0xdecd84a0  ! 2583: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r15
	.word 0xdec52000  ! 2584: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r15
	.word 0xdea52000  ! 2585: STWA_I	stwa	%r15, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 2586: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 2587: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4ae09e0  ! 2588: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0xd4d56000  ! 2589: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r10
	.word 0x87802025  ! 2590: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r25
	.word 0xdeb609e0  ! 2592: STHA_R	stha	%r15, [%r24 + %r0] 0x4f
	.word 0xd2cc0400  ! 2593: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r9
	mov	0x7f0, %r22
	.word 0xd4a4c400  ! 2595: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0xd4ad2000  ! 2596: STBA_I	stba	%r10, [%r20 + 0x0000] %asi
	.word 0xd4ada000  ! 2597: STBA_I	stba	%r10, [%r22 + 0x0000] %asi
	.word 0xd495a000  ! 2598: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r10
	wr_tick_cmpr_0_24:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x83, %g2
	or	%g4, 0xf9, %g4
	or	%g6, 0xc1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8bc8400  ! 2600: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0x87802072  ! 2601: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2602: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bf8e60  ! 2603: STDA_R	stda	%r11, [%r30 + %r0] 0x73
	.word 0xda8f0e60  ! 2604: LDUBA_R	lduba	[%r28, %r0] 0x73, %r13
	.word 0xd2c70e80  ! 2605: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r9
	.word 0xd2cca000  ! 2606: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2c4e000  ! 2607: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	mov	0x48, %r18
	mov	0x40, %r27
	.word 0xdeb584a0  ! 2610: STHA_R	stha	%r15, [%r22 + %r0] 0x25
	.word 0x87802072  ! 2611: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0f44400  ! 2612: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0x87802074  ! 2613: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 2614: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 2615: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0d76000  ! 2616: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 2617: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a6a000  ! 2618: STWA_I	stwa	%r8, [%r26 + 0x0000] %asi
	.word 0x8780204f  ! 2619: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a7ce40  ! 2620: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	mov	0x58, %r19
	.word 0x8780204f  ! 2622: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e0, %r23
	mov	0x30, %r17
	.word 0xd4c66000  ! 2625: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r10
	.word 0xd48ee000  ! 2626: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r10
	.word 0xd49ee000  ! 2627: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r10
	.word 0xd4ce6000  ! 2628: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r10
	.word 0x87802020  ! 2629: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c4a000  ! 2630: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	.word 0xd4f4a000  ! 2631: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0xd8d70e80  ! 2632: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r12
	.word 0xd8dca000  ! 2633: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	wr_tick_cmpr_0_25:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xea, %g2
	or	%g4, 0xa3, %g4
	or	%g6, 0x97, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7d8, %r20
	.word 0xd8f46000  ! 2636: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 2637: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8cc400  ! 2638: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	.word 0x8780204f  ! 2639: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x48, %r27
	.word 0xd6a7ce40  ! 2641: STWA_R	stwa	%r11, [%r31 + %r0] 0x72
	.word 0xd686a000  ! 2642: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r11
	.word 0xd6de6000  ! 2643: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r11
	.word 0xd68ea000  ! 2644: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r11
	.word 0xd6a6e000  ! 2645: STWA_I	stwa	%r11, [%r27 + 0x0000] %asi
	mov	0x10, %r17
	mov	0x7d0, %r21
	.word 0x87802020  ! 2648: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f4a000  ! 2649: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 2650: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6d7a000  ! 2651: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	.word 0xd6cfa000  ! 2652: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0xd6b7a000  ! 2653: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd6df2000  ! 2654: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xde9689e0  ! 2655: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r15
	.word 0xde876000  ! 2656: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0x87802072  ! 2657: WRASI_I	wr	%r0, 0x0072, %asi
	wr_tick_cmpr_0_26:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x98, %g2
	or	%g4, 0xd6, %g4
	or	%g6, 0xa5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdecf6000  ! 2659: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0x87802073  ! 2660: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 2661: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r16
	.word 0xdecf4e60  ! 2663: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r15
	.word 0xde956000  ! 2664: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r15
	.word 0xd0af0e60  ! 2665: STBA_R	stba	%r8, [%r28 + %r0] 0x73
	.word 0xd09d2000  ! 2666: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r8
	.word 0xd2d48400  ! 2667: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	.word 0xd6be49e0  ! 2668: STDA_R	stda	%r11, [%r25 + %r0] 0x4f
	mov	0x0, %r17
	.word 0xd4f6c9e0  ! 2670: STXA_R	stxa	%r10, [%r27 + %r0] 0x4f
	.word 0xd4952000  ! 2671: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r10
	.word 0xd4f5a000  ! 2672: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	.word 0xd4d56000  ! 2673: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r10
	.word 0xd4f52000  ! 2674: STXA_I	stxa	%r10, [%r20 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0x87802020  ! 2676: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c7ce80  ! 2677: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r12
	.word 0xd8bc6000  ! 2678: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0xd4d649e0  ! 2679: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r10
	.word 0xd4a42000  ! 2680: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 2681: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r19
	.word 0xd4cce000  ! 2683: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	.word 0xd4dc2000  ! 2684: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	mov	0x78, %r17
	.word 0xd0f40400  ! 2686: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 2687: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b504a0  ! 2688: STHA_R	stha	%r12, [%r20 + %r0] 0x25
	.word 0x87802072  ! 2689: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8cfa000  ! 2690: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd8a7a000  ! 2691: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd08f8e80  ! 2692: LDUBA_R	lduba	[%r30, %r0] 0x74, %r8
	mov	0x68, %r18
	.word 0xdc8c4400  ! 2694: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	mov	0x50, %r18
	mov	0x7c0, %r23
	.word 0x87802020  ! 2697: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdce000  ! 2698: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r14
	mov	0x78, %r25
	.word 0xdca4e000  ! 2700: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcb42000  ! 2701: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xde9609e0  ! 2702: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r15
	.word 0x87802073  ! 2703: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 2704: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeafa000  ! 2705: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xde8fe000  ! 2707: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	mov	0x7d8, %r21
	.word 0xdebf6000  ! 2709: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xdca40400  ! 2710: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xdcbfa000  ! 2711: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdcdf6000  ! 2712: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xdc9fa000  ! 2713: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0xdcf544a0  ! 2714: STXA_R	stxa	%r14, [%r21 + %r0] 0x25
	.word 0xdaa40400  ! 2715: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0x87802020  ! 2716: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r27
	.word 0xdab46000  ! 2718: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0xda9c2000  ! 2719: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	.word 0xd8f584a0  ! 2720: STXA_R	stxa	%r12, [%r22 + %r0] 0x25
	.word 0xd8842000  ! 2721: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	.word 0x87802025  ! 2722: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd49fce80  ! 2723: LDDA_R	ldda	[%r31, %r0] 0x74, %r10
	.word 0xd4852000  ! 2724: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r10
	.word 0xd2bf8e80  ! 2725: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	.word 0xd685c4a0  ! 2726: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r11
	.word 0xd6b74e60  ! 2727: STHA_R	stha	%r11, [%r29 + %r0] 0x73
	.word 0xd8ad44a0  ! 2728: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	.word 0x87802025  ! 2729: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8ad6000  ! 2730: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	.word 0xd8b56000  ! 2731: STHA_I	stha	%r12, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 2732: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r20
	.word 0xd0870e60  ! 2734: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r8
	.word 0xd6f78e60  ! 2735: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	mov	0x68, %r25
	.word 0xd8c5c4a0  ! 2737: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r12
	.word 0xd8b584a0  ! 2738: STHA_R	stha	%r12, [%r22 + %r0] 0x25
	.word 0x87802020  ! 2739: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c7ce40  ! 2740: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r10
	.word 0xd6bc8400  ! 2741: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	mov	0x3e8, %r21
	.word 0xd6cc6000  ! 2743: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r11
	mov	0x3f8, %r21
	.word 0xd6cc2000  ! 2745: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	mov	0x7d8, %r22
	mov	0x18, %r17
	.word 0xd6bca000  ! 2748: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xd0ce89e0  ! 2750: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r8
	.word 0xd0ac0400  ! 2751: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	ta	T_CHANGE_PRIV	! macro
	mov	0x8, %r24
	mov	0x78, %r16
	mov	0x0, %r24
	mov	0x28, %r27
	.word 0xd0bce000  ! 2757: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0xd0cc2000  ! 2758: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	.word 0xd0f4e000  ! 2759: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xd8f649e0  ! 2760: STXA_R	stxa	%r12, [%r25 + %r0] 0x4f
	mov	0x3c8, %r22
	.word 0xdac544a0  ! 2762: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r13
	.word 0xd0c6c9e0  ! 2763: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r8
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0dca000  ! 2765: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0f4a000  ! 2766: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xd0846000  ! 2767: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	mov	0x70, %r16
	mov	0x40, %r16
	mov	0x7c8, %r21
	.word 0xd0bce000  ! 2771: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 2772: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd084a000  ! 2773: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0b4e000  ! 2774: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	mov	0x7f0, %r22
	mov	0x3f0, %r21
	mov	0x40, %r25
	mov	0x58, %r16
	.word 0xd694c400  ! 2779: LDUHA_R	lduha	[%r19, %r0] 0x20, %r11
	.word 0xd6af0e80  ! 2780: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	.word 0x87802020  ! 2781: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6dce000  ! 2782: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0xd6ac6000  ! 2783: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xdad70e60  ! 2784: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r13
	.word 0x87802074  ! 2785: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r25
	.word 0xd2948400  ! 2787: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	.word 0x87802025  ! 2788: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8a584a0  ! 2789: STWA_R	stwa	%r12, [%r22 + %r0] 0x25
	.word 0xd2cc0400  ! 2790: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r9
	.word 0xdcbd44a0  ! 2791: STDA_R	stda	%r14, [%r21 + %r0] 0x25
	.word 0xd4df0e80  ! 2792: LDXA_R	ldxa	[%r28, %r0] 0x74, %r10
	.word 0xd48d2000  ! 2793: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0x87802072  ! 2794: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda94c400  ! 2795: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	.word 0x87802073  ! 2796: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2797: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda942000  ! 2798: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0xd4948400  ! 2799: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	.word 0xd6970e60  ! 2800: LDUHA_R	lduha	[%r28, %r0] 0x73, %r11
	.word 0x87802025  ! 2801: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r16
	.word 0xd4d544a0  ! 2803: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r10
	.word 0xd09cc400  ! 2804: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	.word 0x87802074  ! 2805: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 2806: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d8, %r23
	mov	0x28, %r19
	.word 0x87802025  ! 2809: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb70e40  ! 2810: STHA_R	stha	%r14, [%r28 + %r0] 0x72
	.word 0xd8cf4e60  ! 2811: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r12
	.word 0xd8cd2000  ! 2812: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r12
	mov	0x0, %r19
	.word 0x87802025  ! 2814: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2815: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2816: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabf8e40  ! 2817: STDA_R	stda	%r13, [%r30 + %r0] 0x72
	.word 0xdab62000  ! 2818: STHA_I	stha	%r13, [%r24 + 0x0000] %asi
	.word 0xda9ee000  ! 2819: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r13
	mov	0x3e8, %r23
	.word 0xdecf8e60  ! 2821: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r15
	.word 0x87802072  ! 2822: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r25
	.word 0xd0b74e80  ! 2824: STHA_R	stha	%r8, [%r29 + %r0] 0x74
	mov	0x8, %r18
	mov	0x68, %r27
	mov	0x38, %r25
	.word 0xd6a4c400  ! 2828: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0xdaf7ce80  ! 2829: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	wr_tick_cmpr_0_27:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe4, %g2
	or	%g4, 0xbd, %g4
	or	%g6, 0xa3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdabf2000  ! 2831: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xda872000  ! 2832: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0xd48649e0  ! 2833: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r10
	.word 0xd48fe000  ! 2834: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	mov	0x78, %r17
	mov	0x78, %r18
	.word 0xd2af4e40  ! 2837: STBA_R	stba	%r9, [%r29 + %r0] 0x72
	.word 0xd2a7e000  ! 2838: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xdaa48400  ! 2839: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 2840: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r26
	.word 0xdab6e000  ! 2842: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	.word 0xdeb7ce80  ! 2843: STHA_R	stha	%r15, [%r31 + %r0] 0x74
	.word 0xdecee000  ! 2844: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r15
	.word 0xd0d70e40  ! 2845: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r8
	.word 0xdad70e80  ! 2846: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r13
	.word 0x87802074  ! 2847: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacf2000  ! 2848: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0x87802074  ! 2849: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdad7a000  ! 2850: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0xdab7a000  ! 2851: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdab72000  ! 2852: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xd8844400  ! 2853: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r12
	.word 0xd0978e40  ! 2854: LDUHA_R	lduha	[%r30, %r0] 0x72, %r8
	mov	0x3f0, %r20
	.word 0x87802020  ! 2856: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_0_28:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xad, %g2
	or	%g4, 0xc7, %g4
	or	%g6, 0xc8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3d0, %r21
	.word 0x87802025  ! 2859: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f52000  ! 2860: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	.word 0xd4b70e80  ! 2861: STHA_R	stha	%r10, [%r28 + %r0] 0x74
	mov	0x3e8, %r23
	.word 0xd0a7ce80  ! 2863: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	mov	0x50, %r18
	.word 0xd0f4c400  ! 2865: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0xd08d6000  ! 2866: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r8
	.word 0xd0f5e000  ! 2867: STXA_I	stxa	%r8, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 2868: WRASI_I	wr	%r0, 0x004f, %asi
	wr_tick_cmpr_0_29:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xd6, %g2
	or	%g4, 0xc8, %g4
	or	%g6, 0xbe, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3e8, %r21
	.word 0xd0cea000  ! 2871: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r8
	mov	0x3f8, %r22
	.word 0xde844400  ! 2873: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	mov	0x48, %r16
	mov	0x60, %r27
	.word 0xde8ea000  ! 2876: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r15
	.word 0xd2948400  ! 2877: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	.word 0xd28e2000  ! 2878: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	.word 0xded584a0  ! 2879: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r15
	.word 0xdeb5c4a0  ! 2880: STHA_R	stha	%r15, [%r23 + %r0] 0x25
	.word 0x87802025  ! 2881: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2882: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a6c9e0  ! 2883: STWA_R	stwa	%r11, [%r27 + %r0] 0x4f
	mov	0x70, %r16
	.word 0xd6cce000  ! 2885: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r11
	.word 0xd0cc4400  ! 2886: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	mov	0x68, %r27
	.word 0xd08f4e80  ! 2888: LDUBA_R	lduba	[%r29, %r0] 0x74, %r8
	.word 0xd0cce000  ! 2889: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0x87802025  ! 2890: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r26
	mov	0x10, %r18
	.word 0xd095a000  ! 2893: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r8
	.word 0x87802072  ! 2894: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2895: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea44400  ! 2896: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xd0f78e80  ! 2897: STXA_R	stxa	%r8, [%r30 + %r0] 0x74
	.word 0x87802072  ! 2898: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda87ce80  ! 2899: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r13
	.word 0x87802072  ! 2900: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r25
	.word 0xdadf2000  ! 2902: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2903: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4adc4a0  ! 2904: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0x87802072  ! 2905: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4972000  ! 2906: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0xd4a7e000  ! 2907: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd28504a0  ! 2908: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r9
	.word 0xdeaf8e80  ! 2909: STBA_R	stba	%r15, [%r30 + %r0] 0x74
	.word 0xdaa70e40  ! 2910: STWA_R	stwa	%r13, [%r28 + %r0] 0x72
	mov	0x7d0, %r21
	.word 0xdacf6000  ! 2912: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xda87e000  ! 2913: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0x87802073  ! 2914: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8d40400  ! 2915: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	.word 0xd8d7a000  ! 2916: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	mov	0x20, %r24
	mov	0x30, %r27
	mov	0x3c0, %r20
	.word 0xd08dc4a0  ! 2920: LDUBA_R	lduba	[%r23, %r0] 0x25, %r8
	.word 0x87802073  ! 2921: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r19
	mov	0x38, %r24
	.word 0x87802020  ! 2924: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a46000  ! 2925: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0f46000  ! 2926: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 2927: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef44400  ! 2928: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	mov	0x7d8, %r21
	mov	0x7c0, %r21
	.word 0xde87e000  ! 2931: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	mov	0x3c8, %r20
	.word 0xdeafa000  ! 2933: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xdedfe000  ! 2934: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	mov	0x3d8, %r22
	.word 0xdc8d04a0  ! 2936: LDUBA_R	lduba	[%r20, %r0] 0x25, %r14
	.word 0xdcbfce60  ! 2937: STDA_R	stda	%r14, [%r31 + %r0] 0x73
	.word 0xdca72000  ! 2938: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	mov	0x50, %r17
	.word 0xdcaf6000  ! 2940: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 2941: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2942: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ce89e0  ! 2943: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r10
	.word 0xd8bf4e60  ! 2944: STDA_R	stda	%r12, [%r29 + %r0] 0x73
	mov	0x0, %r26
	.word 0xd8bca000  ! 2946: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xde8c4400  ! 2947: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	.word 0x87802020  ! 2948: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r21
	.word 0xdebce000  ! 2950: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xde846000  ! 2951: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	mov	0x3f8, %r20
	.word 0xdeb42000  ! 2953: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 2954: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea4a000  ! 2955: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 2956: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdedd6000  ! 2957: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r15
	.word 0xd6840400  ! 2958: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0xd09c0400  ! 2959: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	mov	0x20, %r18
	.word 0xd0b52000  ! 2961: STHA_I	stha	%r8, [%r20 + 0x0000] %asi
	.word 0xd09d6000  ! 2962: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r8
	.word 0xd0d56000  ! 2963: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r8
	.word 0x87802020  ! 2964: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d48400  ! 2965: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0xdaacc400  ! 2966: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0xdaaca000  ! 2967: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0xdaf4e000  ! 2968: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	mov	0x10, %r25
	mov	0x20, %r27
	.word 0x87802025  ! 2971: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdab5e000  ! 2972: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0xdaa56000  ! 2973: STWA_I	stwa	%r13, [%r21 + 0x0000] %asi
	.word 0xdebc0400  ! 2974: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	mov	0x68, %r25
	mov	0x48, %r24
	.word 0xded52000  ! 2977: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r15
	.word 0xd6de49e0  ! 2978: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r11
	.word 0xd6f56000  ! 2979: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0xd6bde000  ! 2981: STDA_I	stda	%r11, [%r23 + 0x0000] %asi
	.word 0xd2af4e80  ! 2982: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	mov	0x38, %r25
	.word 0xd2dd6000  ! 2984: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 2985: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeb584a0  ! 2986: STHA_R	stha	%r15, [%r22 + %r0] 0x25
	.word 0x87802074  ! 2987: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde972000  ! 2988: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0xd4dc4400  ! 2989: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	.word 0xd6970e80  ! 2990: LDUHA_R	lduha	[%r28, %r0] 0x74, %r11
	.word 0xd6a7a000  ! 2991: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6ce49e0  ! 2992: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r11
	.word 0xd2878e40  ! 2993: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r9
	.word 0xd2872000  ! 2994: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	.word 0xdaf5c4a0  ! 2995: STXA_R	stxa	%r13, [%r23 + %r0] 0x25
	.word 0xd8f6c9e0  ! 2996: STXA_R	stxa	%r12, [%r27 + %r0] 0x4f
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8afe000  ! 2998: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xd8dfa000  ! 3000: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8f7e000  ! 3001: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xdcd609e0  ! 3002: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r14
	mov	0x7c0, %r23
	.word 0xd0ad44a0  ! 3004: STBA_R	stba	%r8, [%r21 + %r0] 0x25
	.word 0xd4d584a0  ! 3005: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r10
	mov	0x7c8, %r22
	.word 0x87802020  ! 3007: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cf4e60  ! 3008: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r11
	.word 0xd8dcc400  ! 3009: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	mov	0x18, %r19
	mov	0x3e0, %r23
	.word 0x87802025  ! 3012: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd48d84a0  ! 3013: LDUBA_R	lduba	[%r22, %r0] 0x25, %r10
	.word 0xd4c56000  ! 3014: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r10
	.word 0xd8d544a0  ! 3015: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r12
	mov	0x10, %r26
	.word 0xdef649e0  ! 3017: STXA_R	stxa	%r15, [%r25 + %r0] 0x4f
	.word 0xd0bc8400  ! 3018: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0xdaad04a0  ! 3019: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	wr_tick_cmpr_0_30:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xab, %g2
	or	%g4, 0xa3, %g4
	or	%g6, 0xb8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7d8, %r23
	.word 0xdabd2000  ! 3022: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	.word 0xd8cc0400  ! 3023: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	.word 0x87802073  ! 3024: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd897e000  ! 3025: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	.word 0xd8cf4e60  ! 3026: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r12
	mov	0x3f0, %r20
	.word 0xdcbe89e0  ! 3028: STDA_R	stda	%r14, [%r26 + %r0] 0x4f
	.word 0xdcf76000  ! 3029: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdca76000  ! 3030: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	mov	0x0, %r26
	.word 0x8780204f  ! 3032: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f8, %r22
	.word 0xd0cf0e60  ! 3034: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r8
	.word 0xd0c62000  ! 3035: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r8
	mov	0x70, %r27
	.word 0x87802072  ! 3037: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r24
	.word 0xd2af4e80  ! 3039: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	.word 0x87802073  ! 3040: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r18
	.word 0xd4bc0400  ! 3042: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xd0cc4400  ! 3043: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	.word 0xd8874e80  ! 3044: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r12
	.word 0xd8afa000  ! 3045: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xdacc8400  ! 3046: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r13
	.word 0x8780204f  ! 3047: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c8, %r21
	.word 0xdaaea000  ! 3049: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	.word 0xda8ee000  ! 3050: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r13
	mov	0x10, %r26
	.word 0xda8e6000  ! 3052: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r13
	.word 0xd4d4c400  ! 3053: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	mov	0x7f0, %r22
	.word 0x87802072  ! 3055: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r25
	.word 0xd4a72000  ! 3057: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4cf2000  ! 3058: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd2dc8400  ! 3059: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0x87802020  ! 3060: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a70e60  ! 3061: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	.word 0xd4a42000  ! 3062: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0xd08fce80  ! 3063: LDUBA_R	lduba	[%r31, %r0] 0x74, %r8
	.word 0xd0cc2000  ! 3064: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	mov	0x3e8, %r22
	mov	0x50, %r26
	.word 0xdc874e80  ! 3067: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r14
	.word 0xdef78e60  ! 3068: STXA_R	stxa	%r15, [%r30 + %r0] 0x73
	.word 0x87802020  ! 3069: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde94e000  ! 3070: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	mov	0x48, %r19
	.word 0x87802073  ! 3072: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdab40400  ! 3073: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xdcbf8e60  ! 3074: STDA_R	stda	%r14, [%r30 + %r0] 0x73
	.word 0xdc970e60  ! 3075: LDUHA_R	lduha	[%r28, %r0] 0x73, %r14
	.word 0xdcaf2000  ! 3076: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xd4afce60  ! 3077: STBA_R	stba	%r10, [%r31 + %r0] 0x73
	.word 0xd4f7a000  ! 3078: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4c72000  ! 3079: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r10
	.word 0x87802074  ! 3080: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4dfa000  ! 3081: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	mov	0x18, %r24
	.word 0xd4f7a000  ! 3083: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	mov	0x38, %r17
	.word 0xd2ac8400  ! 3085: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xd29649e0  ! 3086: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r9
	.word 0xd2f76000  ! 3087: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xd6af0e40  ! 3088: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	.word 0x87802020  ! 3089: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r19
	.word 0xd68ca000  ! 3091: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r11
	.word 0xd68c6000  ! 3092: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r11
	mov	0x50, %r16
	mov	0x7e0, %r20
	.word 0xd6bf4e40  ! 3095: STDA_R	stda	%r11, [%r29 + %r0] 0x72
	mov	0x10, %r25
	.word 0x87802020  ! 3097: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r19
	.word 0xdcbf0e40  ! 3099: STDA_R	stda	%r14, [%r28 + %r0] 0x72
	.word 0xdcdf4e60  ! 3100: LDXA_R	ldxa	[%r29, %r0] 0x73, %r14
	.word 0xdcace000  ! 3101: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	mov	0x28, %r19
	.word 0xdef40400  ! 3103: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0xde946000  ! 3104: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r15
	mov	0x78, %r17
	.word 0x87802073  ! 3106: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bc0400  ! 3107: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xdeb7ce60  ! 3108: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 3109: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 3110: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2afce80  ! 3111: STBA_R	stba	%r9, [%r31 + %r0] 0x74
	.word 0xda97ce40  ! 3112: LDUHA_R	lduha	[%r31, %r0] 0x72, %r13
	mov	0x3e0, %r21
	.word 0xdadc4400  ! 3114: LDXA_R	ldxa	[%r17, %r0] 0x20, %r13
	.word 0xdaf7e000  ! 3115: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xdad48400  ! 3116: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	mov	0x70, %r26
	.word 0xd8b70e40  ! 3118: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	mov	0x20, %r27
	.word 0xd8d76000  ! 3120: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	mov	0x58, %r18
	.word 0xd8a72000  ! 3122: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 3123: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bee000  ! 3124: STDA_I	stda	%r12, [%r27 + 0x0000] %asi
	wr_tick_cmpr_0_31:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xde, %g2
	or	%g4, 0xd5, %g4
	or	%g6, 0xa3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd886a000  ! 3126: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r12
	.word 0xdeacc400  ! 3127: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	mov	0x58, %r26
	mov	0x7c0, %r21
	mov	0x7d0, %r21
	.word 0x87802020  ! 3131: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedca000  ! 3132: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	mov	0x7e8, %r20
	.word 0xd2d6c9e0  ! 3134: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r9
	.word 0x87802073  ! 3135: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c0, %r20
	mov	0x7e0, %r20
	.word 0xd0df8e60  ! 3138: LDXA_R	ldxa	[%r30, %r0] 0x73, %r8
	.word 0xdecfce40  ! 3139: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r15
	.word 0xd8d70e60  ! 3140: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r12
	.word 0xd8bf2000  ! 3141: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 3142: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r23
	.word 0xd8cce000  ! 3144: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r12
	.word 0x87802072  ! 3145: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r26
	mov	0x3f8, %r22
	mov	0x18, %r27
	.word 0xd8afe000  ! 3149: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd89f6000  ! 3150: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	.word 0x87802020  ! 3151: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bf4e80  ! 3152: STDA_R	stda	%r12, [%r29 + %r0] 0x74
	.word 0xd0ac0400  ! 3153: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	mov	0x60, %r26
	.word 0xd0a42000  ! 3155: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xd0bce000  ! 3156: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0xd4a40400  ! 3157: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	mov	0x7c8, %r20
	.word 0xd4842000  ! 3159: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	mov	0x48, %r18
	.word 0xd4cc2000  ! 3161: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	.word 0xd8ad44a0  ! 3162: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	.word 0xd0d6c9e0  ! 3163: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r8
	.word 0xd08c6000  ! 3164: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	mov	0x60, %r19
	.word 0xdad544a0  ! 3166: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r13
	.word 0xde8c8400  ! 3167: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	mov	0x3e8, %r21
	.word 0x87802073  ! 3169: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xded7a000  ! 3170: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xdef72000  ! 3171: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 3172: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde85a000  ! 3173: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3174: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeaca000  ! 3175: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xde942000  ! 3176: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	.word 0xd0cf4e40  ! 3177: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	.word 0xd0bc6000  ! 3178: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	.word 0xd0aca000  ! 3179: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xd0bf0e80  ! 3180: STDA_R	stda	%r8, [%r28 + %r0] 0x74
	.word 0xd48fce60  ! 3181: LDUBA_R	lduba	[%r31, %r0] 0x73, %r10
	mov	0x0, %r18
	.word 0xd2f7ce60  ! 3183: STXA_R	stxa	%r9, [%r31 + %r0] 0x73
	.word 0xd49f4e60  ! 3184: LDDA_R	ldda	[%r29, %r0] 0x73, %r10
	wr_tick_cmpr_0_32:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe1, %g2
	or	%g4, 0xbd, %g4
	or	%g6, 0xd7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdcb609e0  ! 3186: STHA_R	stha	%r14, [%r24 + %r0] 0x4f
	.word 0xd6ccc400  ! 3187: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	.word 0xdcd78e60  ! 3188: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r14
	.word 0x87802025  ! 3189: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8c609e0  ! 3190: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r12
	.word 0xd895e000  ! 3191: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r12
	.word 0xd8b56000  ! 3192: STHA_I	stha	%r12, [%r21 + 0x0000] %asi
	mov	0x60, %r18
	.word 0x87802073  ! 3194: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r24
	.word 0xd6b689e0  ! 3196: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	.word 0xd6bfa000  ! 3197: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd6bfe000  ! 3198: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xd0b78e60  ! 3200: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	mov	0x7c8, %r20
	.word 0x87802073  ! 3202: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r16
	.word 0x87802020  ! 3204: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0dce000  ! 3205: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r8
	.word 0x87802073  ! 3206: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b76000  ! 3207: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd4f48400  ! 3208: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	mov	0x78, %r25
	.word 0xd4972000  ! 3210: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	mov	0x10, %r16
	.word 0xd48f6000  ! 3212: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xd4872000  ! 3213: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0xd88584a0  ! 3214: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r12
	.word 0xd8872000  ! 3215: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	.word 0xdef74e80  ! 3216: STXA_R	stxa	%r15, [%r29 + %r0] 0x74
	.word 0xd4a609e0  ! 3217: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	.word 0xd4bfe000  ! 3218: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x28, %r18
	.word 0x87802025  ! 3220: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6adc4a0  ! 3221: STBA_R	stba	%r11, [%r23 + %r0] 0x25
	mov	0x7d8, %r20
	.word 0xd6dd2000  ! 3223: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r11
	.word 0xd685e000  ! 3224: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r11
	.word 0xd6b5a000  ! 3225: STHA_I	stha	%r11, [%r22 + 0x0000] %asi
	.word 0xd8d70e80  ! 3226: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r12
	.word 0xd8a5e000  ! 3227: STWA_I	stwa	%r12, [%r23 + 0x0000] %asi
	mov	0x3c8, %r20
	mov	0x20, %r24
	.word 0xd8ad2000  ! 3230: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	.word 0xd4f7ce60  ! 3231: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	.word 0xd68649e0  ! 3232: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r11
	.word 0xd6f56000  ! 3233: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	.word 0xd6cd2000  ! 3234: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r11
	.word 0xd6bd6000  ! 3235: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xd2ac4400  ! 3237: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xd2856000  ! 3238: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r9
	mov	0x20, %r17
	.word 0xdcbfce80  ! 3240: STDA_R	stda	%r14, [%r31 + %r0] 0x74
	.word 0xdcbd6000  ! 3241: STDA_I	stda	%r14, [%r21 + 0x0000] %asi
	mov	0x48, %r16
	.word 0xdedc0400  ! 3243: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	wr_tick_cmpr_0_33:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xdf, %g2
	or	%g4, 0xfc, %g4
	or	%g6, 0x86, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdecde000  ! 3245: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r15
	.word 0xded56000  ! 3246: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r15
	.word 0xdaf689e0  ! 3247: STXA_R	stxa	%r13, [%r26 + %r0] 0x4f
	.word 0xdabda000  ! 3248: STDA_I	stda	%r13, [%r22 + 0x0000] %asi
	.word 0xda95a000  ! 3249: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r13
	.word 0xdab5e000  ! 3250: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0xdabd6000  ! 3251: STDA_I	stda	%r13, [%r21 + 0x0000] %asi
	.word 0xd8974e40  ! 3252: LDUHA_R	lduha	[%r29, %r0] 0x72, %r12
	.word 0xd0ae09e0  ! 3253: STBA_R	stba	%r8, [%r24 + %r0] 0x4f
	.word 0xd0cd2000  ! 3254: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r8
	.word 0xd28e89e0  ! 3255: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r9
	.word 0xd8ad04a0  ! 3256: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	.word 0xd8f56000  ! 3257: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	.word 0x87802072  ! 3258: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 3259: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd087ce40  ! 3260: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r8
	.word 0x87802020  ! 3261: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f584a0  ! 3262: STXA_R	stxa	%r9, [%r22 + %r0] 0x25
	.word 0xd2a46000  ! 3263: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2d4a000  ! 3264: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	.word 0xd8a649e0  ! 3265: STWA_R	stwa	%r12, [%r25 + %r0] 0x4f
	.word 0xd8a4e000  ! 3266: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xd2ad84a0  ! 3267: STBA_R	stba	%r9, [%r22 + %r0] 0x25
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2946000  ! 3269: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r9
	mov	0x8, %r17
	.word 0xd2b4e000  ! 3271: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0xd2f46000  ! 3272: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 3273: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdccec9e0  ! 3274: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r14
	.word 0xd8df4e80  ! 3275: LDXA_R	ldxa	[%r29, %r0] 0x74, %r12
	.word 0xd8b72000  ! 3276: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd6c74e80  ! 3277: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r11
	.word 0xd6d7ce40  ! 3278: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r11
	mov	0x0, %r16
	.word 0xd6af2000  ! 3280: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd6a72000  ! 3281: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd6af4e80  ! 3283: STBA_R	stba	%r11, [%r29 + %r0] 0x74
	.word 0xd6f72000  ! 3284: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xde97ce40  ! 3285: LDUHA_R	lduha	[%r31, %r0] 0x72, %r15
	.word 0xdeafa000  ! 3286: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	mov	0x50, %r18
	.word 0xdeaf6000  ! 3288: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xde97a000  ! 3289: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	mov	0x3c8, %r21
	.word 0xded7a000  ! 3291: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xd6c70e80  ! 3292: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r11
	.word 0xdebec9e0  ! 3293: STDA_R	stda	%r15, [%r27 + %r0] 0x4f
	mov	0x28, %r16
	.word 0xd2a7ce40  ! 3295: STWA_R	stwa	%r9, [%r31 + %r0] 0x72
	.word 0xd28d44a0  ! 3296: LDUBA_R	lduba	[%r21, %r0] 0x25, %r9
	.word 0xd2acc400  ! 3297: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 3298: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2b62000  ! 3299: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0x87802020  ! 3301: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cca000  ! 3302: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	.word 0xdcb4c400  ! 3303: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xd29c0400  ! 3304: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	.word 0xd2bca000  ! 3305: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	.word 0xdead44a0  ! 3306: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	.word 0xd2acc400  ! 3307: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0xd2f6c9e0  ! 3308: STXA_R	stxa	%r9, [%r27 + %r0] 0x4f
	.word 0xdca7ce80  ! 3309: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	.word 0xdcbce000  ! 3310: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xd89fce80  ! 3311: LDDA_R	ldda	[%r31, %r0] 0x74, %r12
	.word 0xd8bca000  ! 3312: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd8842000  ! 3313: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	.word 0xd884a000  ! 3314: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r12
	mov	0x3e0, %r20
	.word 0xdcd48400  ! 3316: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	.word 0xd0b74e60  ! 3317: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	.word 0xd0c46000  ! 3318: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r8
	.word 0xd0f42000  ! 3319: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0xd2bf0e40  ! 3320: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	.word 0xd2ac6000  ! 3321: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 3322: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2ce2000  ! 3323: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r9
	.word 0xd2aea000  ! 3324: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0xd4f44400  ! 3325: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0xd4bea000  ! 3326: STDA_I	stda	%r10, [%r26 + 0x0000] %asi
	.word 0x8780204f  ! 3327: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a6e000  ! 3328: STWA_I	stwa	%r10, [%r27 + 0x0000] %asi
	mov	0x58, %r24
	.word 0x87802074  ! 3330: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r25
	.word 0x8780204f  ! 3332: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdab48400  ! 3334: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0xdaaea000  ! 3335: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	.word 0xda86e000  ! 3336: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r13
	.word 0xda86a000  ! 3337: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r13
	.word 0xdab6a000  ! 3338: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	mov	0x10, %r27
	.word 0xd6a6c9e0  ! 3340: STWA_R	stwa	%r11, [%r27 + %r0] 0x4f
	.word 0xd6ce2000  ! 3341: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	.word 0xdaf609e0  ! 3342: STXA_R	stxa	%r13, [%r24 + %r0] 0x4f
	.word 0xd8dec9e0  ! 3343: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r12
	mov	0x38, %r27
	.word 0x87802020  ! 3345: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r26
	.word 0x87802074  ! 3347: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r16
	.word 0x87802073  ! 3349: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r26
	mov	0x8, %r26
	mov	0x50, %r18
	mov	0x48, %r16
	.word 0xd4978e60  ! 3354: LDUHA_R	lduha	[%r30, %r0] 0x73, %r10
	mov	0x18, %r18
	.word 0xd6f40400  ! 3356: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdac70e60  ! 3358: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r13
	.word 0xdaa40400  ! 3359: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	mov	0x38, %r24
	mov	0x78, %r19
	.word 0xda972000  ! 3362: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	ta	T_CHANGE_HPRIV	! macro
	.word 0xde9cc400  ! 3364: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	mov	0x20, %r19
	.word 0xde97a000  ! 3366: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	.word 0x87802073  ! 3367: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6b44400  ! 3368: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xd8a7ce60  ! 3369: STWA_R	stwa	%r12, [%r31 + %r0] 0x73
	.word 0xd8afe000  ! 3370: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 3371: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a4a000  ! 3372: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	mov	0x78, %r24
	.word 0x87802020  ! 3374: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8aca000  ! 3375: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0xd4afce60  ! 3376: STBA_R	stba	%r10, [%r31 + %r0] 0x73
	.word 0x87802025  ! 3377: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c0, %r22
	.word 0xd4bd6000  ! 3379: STDA_I	stda	%r10, [%r21 + 0x0000] %asi
	mov	0x70, %r24
	.word 0xd4cde000  ! 3381: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r10
	mov	0x30, %r16
	.word 0xd4f52000  ! 3383: STXA_I	stxa	%r10, [%r20 + 0x0000] %asi
	.word 0xd6a4c400  ! 3384: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0xd685e000  ! 3385: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r11
	.word 0xd6c56000  ! 3386: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r11
	.word 0xdc9544a0  ! 3387: LDUHA_R	lduha	[%r21, %r0] 0x25, %r14
	.word 0xd6d78e60  ! 3388: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r11
	.word 0xd6d56000  ! 3389: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r11
	.word 0xd6952000  ! 3390: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3391: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bc8400  ! 3392: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	.word 0xd2a4e000  ! 3393: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2bc2000  ! 3394: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xd2bc6000  ! 3395: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0xd08d84a0  ! 3396: LDUBA_R	lduba	[%r22, %r0] 0x25, %r8
	.word 0x87802020  ! 3397: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0946000  ! 3398: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0xd2dfce40  ! 3399: LDXA_R	ldxa	[%r31, %r0] 0x72, %r9
	.word 0xd29c6000  ! 3400: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	mov	0x28, %r18
	.word 0x87802074  ! 3402: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r24
	.word 0xd2f7a000  ! 3404: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 3405: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc878e80  ! 3406: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r14
	mov	0x48, %r19
	mov	0x3e8, %r22
	.word 0x87802072  ! 3409: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r16
	.word 0x87802074  ! 3411: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3412: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r25
	.word 0xd8c544a0  ! 3414: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r12
	.word 0xd6b4c400  ! 3415: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	mov	0x3e8, %r23
	.word 0xd6a4a000  ! 3417: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	.word 0xd09c4400  ! 3418: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	.word 0xd0df8e80  ! 3419: LDXA_R	ldxa	[%r30, %r0] 0x74, %r8
	.word 0xd6b544a0  ! 3420: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	.word 0x87802073  ! 3421: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6b7a000  ! 3422: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd6af0e80  ! 3423: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	.word 0x87802020  ! 3424: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd684e000  ! 3425: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r11
	.word 0xd6b46000  ! 3426: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd2b609e0  ! 3427: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 3428: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 3429: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f62000  ! 3430: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	.word 0xd2cea000  ! 3431: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r9
	mov	0x7c0, %r22
	.word 0xdccf4e40  ! 3433: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r14
	ta	T_CHANGE_PRIV	! macro
	mov	0x28, %r19
	.word 0xd69fce80  ! 3436: LDDA_R	ldda	[%r31, %r0] 0x74, %r11
	.word 0x87802020  ! 3437: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69ce000  ! 3438: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r11
	.word 0xd0940400  ! 3439: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	mov	0x7d0, %r21
	.word 0xd0a42000  ! 3441: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	mov	0x68, %r24
	.word 0xd6be49e0  ! 3443: STDA_R	stda	%r11, [%r25 + %r0] 0x4f
	.word 0xd6bc6000  ! 3444: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 3445: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b74e60  ! 3446: STHA_R	stha	%r10, [%r29 + %r0] 0x73
	.word 0xdabe09e0  ! 3447: STDA_R	stda	%r13, [%r24 + %r0] 0x4f
	wr_tick_cmpr_0_34:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xef, %g2
	or	%g4, 0x8d, %g4
	or	%g6, 0xc2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xda974e40  ! 3450: LDUHA_R	lduha	[%r29, %r0] 0x72, %r13
	.word 0xdac7e000  ! 3451: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xdcc649e0  ! 3452: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r14
	.word 0xda840400  ! 3453: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	.word 0xdadfa000  ! 3454: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xdad7e000  ! 3455: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xdaafa000  ! 3456: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdaafa000  ! 3457: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdc948400  ! 3458: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	.word 0xd8ac0400  ! 3459: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xd6f44400  ! 3460: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	mov	0x18, %r19
	.word 0x87802072  ! 3462: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd6d5c4a0  ! 3464: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r11
	mov	0x48, %r19
	.word 0xd29f8e80  ! 3466: LDDA_R	ldda	[%r30, %r0] 0x74, %r9
	.word 0xd2c7e000  ! 3467: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2b72000  ! 3468: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 3469: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3470: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49c4400  ! 3471: LDDA_R	ldda	[%r17, %r0] 0x20, %r10
	.word 0xd4b46000  ! 3472: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xd4b46000  ! 3473: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	mov	0x8, %r27
	.word 0xd4d4e000  ! 3475: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0xd4c40400  ! 3476: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	.word 0x87802072  ! 3477: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3478: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a6a000  ! 3479: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	.word 0xd486e000  ! 3480: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	.word 0xd4f74e60  ! 3481: STXA_R	stxa	%r10, [%r29 + %r0] 0x73
	.word 0xdcf74e80  ! 3482: STXA_R	stxa	%r14, [%r29 + %r0] 0x74
	.word 0x87802020  ! 3483: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 3484: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde9c0400  ! 3485: LDDA_R	ldda	[%r16, %r0] 0x20, %r15
	.word 0x8780204f  ! 3486: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r26
	.word 0x87802073  ! 3488: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde9f2000  ! 3489: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xde9f6000  ! 3490: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0xde8fe000  ! 3491: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0xdec7a000  ! 3492: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xdedf2000  ! 3493: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xded76000  ! 3494: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0xdeb7a000  ! 3495: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xdef76000  ! 3496: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xd0b584a0  ! 3497: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	.word 0x87802020  ! 3498: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda874e80  ! 3499: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r13
	mov	0x7e8, %r20
	.word 0xd4974e60  ! 3501: LDUHA_R	lduha	[%r29, %r0] 0x73, %r10
	.word 0xdcc70e60  ! 3502: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r14
	.word 0xd2a78e80  ! 3503: STWA_R	stwa	%r9, [%r30 + %r0] 0x74
	.word 0xd28c6000  ! 3504: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0xdeafce80  ! 3505: STBA_R	stba	%r15, [%r31 + %r0] 0x74
	.word 0xdedce000  ! 3506: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r15
	mov	0x48, %r26
	.word 0x87802072  ! 3508: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda9f4e40  ! 3509: LDDA_R	ldda	[%r29, %r0] 0x72, %r13
	.word 0xda97e000  ! 3510: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	.word 0xd8d44400  ! 3511: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	.word 0xd4a70e80  ! 3512: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	.word 0xd6be09e0  ! 3513: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	mov	0x3e0, %r22
	.word 0x87802025  ! 3515: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a5e000  ! 3516: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 3517: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r27
	.word 0xd6f66000  ! 3519: STXA_I	stxa	%r11, [%r25 + 0x0000] %asi
	.word 0xd68ea000  ! 3520: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3521: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cca000  ! 3522: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r11
	.word 0xd6cc2000  ! 3523: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	.word 0xd0df4e60  ! 3524: LDXA_R	ldxa	[%r29, %r0] 0x73, %r8
	.word 0x87802072  ! 3525: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 3526: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8cf4e80  ! 3527: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r12
	.word 0xd887e000  ! 3528: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0xd08649e0  ! 3529: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r8
	.word 0x87802073  ! 3530: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd88f8e80  ! 3531: LDUBA_R	lduba	[%r30, %r0] 0x74, %r12
	.word 0xd8d72000  ! 3532: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xd8df6000  ! 3533: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	mov	0x7e8, %r23
	.word 0xd88f6000  ! 3535: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xd897e000  ! 3536: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	.word 0xd0b70e80  ! 3537: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	.word 0xd0bf2000  ! 3538: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	mov	0x38, %r24
	.word 0x87802020  ! 3540: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ccc400  ! 3541: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r12
	mov	0x58, %r26
	mov	0x3d0, %r23
	.word 0xd8dc2000  ! 3544: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	mov	0x48, %r24
	.word 0x87802020  ! 3546: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f4e000  ! 3547: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xd0a7ce80  ! 3548: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	mov	0x3c8, %r21
	.word 0x87802025  ! 3550: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd085e000  ! 3551: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r8
	.word 0x87802020  ! 3552: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0844400  ! 3553: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r8
	.word 0xd896c9e0  ! 3554: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r12
	.word 0x87802074  ! 3555: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b4c400  ! 3556: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xd4bc4400  ! 3557: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0xd0ac4400  ! 3558: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0xd0dfa000  ! 3559: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0xd097e000  ! 3560: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0afe000  ! 3561: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd09f6000  ! 3562: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	mov	0x28, %r25
	.word 0xdcaf4e40  ! 3564: STBA_R	stba	%r14, [%r29 + %r0] 0x72
	.word 0xdcc72000  ! 3565: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xdc9f2000  ! 3566: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xd09e89e0  ! 3567: LDDA_R	ldda	[%r26, %r0] 0x4f, %r8
	.word 0xdebf4e40  ! 3568: STDA_R	stda	%r15, [%r29 + %r0] 0x72
	.word 0xd6b6c9e0  ! 3569: STHA_R	stha	%r11, [%r27 + %r0] 0x4f
	.word 0x87802025  ! 3570: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4b78e80  ! 3571: STHA_R	stha	%r10, [%r30 + %r0] 0x74
	.word 0xd4d56000  ! 3572: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r10
	.word 0xd0874e80  ! 3573: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r8
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0ad2000  ! 3575: STBA_I	stba	%r8, [%r20 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xd0b52000  ! 3577: STHA_I	stha	%r8, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 3578: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d8, %r21
	.word 0xd0cfa000  ! 3580: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0xd0a7a000  ! 3581: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xdcdf8e40  ! 3582: LDXA_R	ldxa	[%r30, %r0] 0x72, %r14
	.word 0xdca72000  ! 3583: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcc7a000  ! 3584: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xda9504a0  ! 3585: LDUHA_R	lduha	[%r20, %r0] 0x25, %r13
	.word 0xdac76000  ! 3586: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0xdab76000  ! 3587: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdab76000  ! 3588: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xda8fa000  ! 3589: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xdaa7e000  ! 3590: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xda8f2000  ! 3591: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3592: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3593: WRASI_I	wr	%r0, 0x0074, %asi
	wr_tick_cmpr_0_35:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xeb, %g2
	or	%g4, 0xfd, %g4
	or	%g6, 0xec, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdaf72000  ! 3595: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdaaf6000  ! 3596: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xdaa78e80  ! 3597: STWA_R	stwa	%r13, [%r30 + %r0] 0x74
	.word 0xda8fa000  ! 3598: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xdadf2000  ! 3599: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	mov	0x20, %r19
	mov	0x3c8, %r23
	.word 0xdaafa000  ! 3602: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	mov	0x28, %r19
	mov	0x7e0, %r22
	.word 0xdabfe000  ! 3605: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	mov	0x8, %r24
	.word 0xd4de89e0  ! 3607: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r10
	.word 0xd487e000  ! 3608: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802020  ! 3609: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f689e0  ! 3610: STXA_R	stxa	%r11, [%r26 + %r0] 0x4f
	.word 0xd69ce000  ! 3611: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r11
	.word 0xd684a000  ! 3612: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r11
	mov	0x3f0, %r20
	.word 0xd6bc6000  ! 3614: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0xd6ac6000  ! 3615: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 3616: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b76000  ! 3617: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	mov	0x7c0, %r22
	.word 0xd0c78e40  ! 3619: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r8
	mov	0x40, %r17
	mov	0x7d0, %r21
	.word 0xd0b584a0  ! 3622: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	mov	0x30, %r26
	mov	0x58, %r26
	.word 0xd0bf2000  ! 3625: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xd0b76000  ! 3626: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 3627: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r25
	wr_tick_cmpr_0_36:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb4, %g2
	or	%g4, 0xfc, %g4
	or	%g6, 0xbd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0d4a000  ! 3630: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	mov	0x3c8, %r20
	.word 0xd08c2000  ! 3632: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0xd0dc6000  ! 3633: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	.word 0xd0d7ce60  ! 3634: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r8
	.word 0xd4a4c400  ! 3635: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0xd2970e60  ! 3636: LDUHA_R	lduha	[%r28, %r0] 0x73, %r9
	.word 0xd6b48400  ! 3637: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd6f46000  ! 3638: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0xd2f70e40  ! 3639: STXA_R	stxa	%r9, [%r28 + %r0] 0x72
	mov	0x58, %r18
	.word 0x87802020  ! 3641: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r18
	.word 0xde948400  ! 3643: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	.word 0x8780204f  ! 3644: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6de09e0  ! 3645: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r11
	mov	0x48, %r18
	.word 0xd6be2000  ! 3647: STDA_I	stda	%r11, [%r24 + 0x0000] %asi
	mov	0x7f0, %r21
	mov	0x10, %r26
	.word 0x87802073  ! 3650: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bf6000  ! 3651: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd69f2000  ! 3652: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	mov	0x78, %r16
	.word 0xdcaec9e0  ! 3654: STBA_R	stba	%r14, [%r27 + %r0] 0x4f
	.word 0xdcf7ce80  ! 3655: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	.word 0x8780204f  ! 3656: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdca78e60  ! 3657: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	.word 0xdcae6000  ! 3658: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	mov	0x40, %r17
	mov	0x3d0, %r21
	.word 0xdc9e2000  ! 3661: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r14
	.word 0xdca7ce80  ! 3662: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	mov	0x3d8, %r20
	mov	0x7d0, %r20
	.word 0xde978e60  ! 3665: LDUHA_R	lduha	[%r30, %r0] 0x73, %r15
	.word 0xdede2000  ! 3666: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r15
	.word 0xded6e000  ! 3667: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r15
	.word 0xd49f8e80  ! 3668: LDDA_R	ldda	[%r30, %r0] 0x74, %r10
	.word 0x87802073  ! 3669: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd08e49e0  ! 3670: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r8
	.word 0xd0af8e40  ! 3671: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0xd4c74e40  ! 3672: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r10
	.word 0xdaafce80  ! 3673: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	.word 0xda8f2000  ! 3674: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xd6a70e60  ! 3675: STWA_R	stwa	%r11, [%r28 + %r0] 0x73
	mov	0x8, %r18
	.word 0xd6cf6000  ! 3677: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6bf2000  ! 3678: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 3679: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd89c0400  ! 3680: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	.word 0x87802020  ! 3681: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r24
	.word 0xdcdf0e80  ! 3683: LDXA_R	ldxa	[%r28, %r0] 0x74, %r14
	.word 0xda8584a0  ! 3684: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r13
	.word 0xdec7ce60  ! 3685: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r15
	mov	0x78, %r17
	.word 0xdecc2000  ! 3687: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	.word 0x87802073  ! 3688: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3689: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3690: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88f4e60  ! 3691: LDUBA_R	lduba	[%r29, %r0] 0x73, %r12
	.word 0x87802072  ! 3692: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r24
	mov	0x7f0, %r23
	.word 0xd897e000  ! 3695: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	.word 0xd8b7e000  ! 3696: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0xd2c6c9e0  ! 3697: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r9
	.word 0xd2cf2000  ! 3698: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r9
	.word 0x87802074  ! 3699: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6cf8e80  ! 3700: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r11
	.word 0xd6f76000  ! 3701: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6cfe000  ! 3702: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0x87802025  ! 3703: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f5e000  ! 3704: STXA_I	stxa	%r11, [%r23 + 0x0000] %asi
	.word 0xd4b48400  ! 3705: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0x87802020  ! 3706: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c4a000  ! 3707: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	.word 0x87802072  ! 3708: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcac0400  ! 3710: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xd0f48400  ! 3711: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xd0c72000  ! 3712: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0af2000  ! 3713: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	mov	0x30, %r19
	.word 0xd0afe000  ! 3715: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 3716: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r20
	.word 0xd89c4400  ! 3718: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	mov	0x58, %r17
	.word 0xd0970e40  ! 3720: LDUHA_R	lduha	[%r28, %r0] 0x72, %r8
	.word 0xdeb584a0  ! 3721: STHA_R	stha	%r15, [%r22 + %r0] 0x25
	mov	0x48, %r16
	mov	0x3e0, %r23
	.word 0xdadd84a0  ! 3724: LDXA_R	ldxa	[%r22, %r0] 0x25, %r13
	mov	0x38, %r26
	.word 0x87802025  ! 3726: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bf4e60  ! 3727: STDA_R	stda	%r12, [%r29 + %r0] 0x73
	.word 0xd8bda000  ! 3728: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	.word 0xd0cf4e40  ! 3729: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	.word 0xd08de000  ! 3730: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r8
	.word 0xd0b5a000  ! 3731: STHA_I	stha	%r8, [%r22 + 0x0000] %asi
	mov	0x28, %r24
	.word 0xd0d584a0  ! 3733: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r8
	.word 0xd0ad6000  ! 3734: STBA_I	stba	%r8, [%r21 + 0x0000] %asi
	.word 0xd0f52000  ! 3735: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	.word 0xd09d6000  ! 3736: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r8
	.word 0x87802074  ! 3737: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3738: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6df8e80  ! 3739: LDXA_R	ldxa	[%r30, %r0] 0x74, %r11
	mov	0x0, %r25
	.word 0xd6a78e60  ! 3741: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0xdaa40400  ! 3742: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 3743: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda8ea000  ! 3744: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r13
	.word 0xdab66000  ! 3745: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0xd4f4c400  ! 3746: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd49ea000  ! 3747: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd4bfce80  ! 3749: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd4f62000  ! 3751: STXA_I	stxa	%r10, [%r24 + 0x0000] %asi
	.word 0xd4b62000  ! 3752: STHA_I	stha	%r10, [%r24 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xd4bea000  ! 3754: STDA_I	stda	%r10, [%r26 + 0x0000] %asi
	.word 0xd4cee000  ! 3755: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r10
	.word 0xd4c62000  ! 3756: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r10
	mov	0x50, %r19
	.word 0xdc9f0e80  ! 3758: LDDA_R	ldda	[%r28, %r0] 0x74, %r14
	.word 0xdaf70e60  ! 3759: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	.word 0xded78e40  ! 3760: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r15
	.word 0xdebe2000  ! 3761: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	.word 0x87802073  ! 3762: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde8fe000  ! 3763: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0xd6a70e40  ! 3764: STWA_R	stwa	%r11, [%r28 + %r0] 0x72
	mov	0x3c0, %r20
	.word 0x87802072  ! 3766: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6afa000  ! 3767: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xdc9c8400  ! 3768: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0x87802025  ! 3769: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 3770: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e0, %r20
	.word 0x87802020  ! 3772: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3773: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29dc4a0  ! 3774: LDDA_R	ldda	[%r23, %r0] 0x25, %r9
	.word 0x87802074  ! 3775: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3f8, %r20
	.word 0xd88649e0  ! 3777: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r12
	.word 0xd8b72000  ! 3778: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd8f7e000  ! 3779: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xdec504a0  ! 3780: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r15
	mov	0x3d8, %r20
	.word 0xdeb72000  ! 3782: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xdef72000  ! 3783: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xdedf6000  ! 3784: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xdea76000  ! 3785: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xde8f4e60  ! 3786: LDUBA_R	lduba	[%r29, %r0] 0x73, %r15
	.word 0xd4dd44a0  ! 3787: LDXA_R	ldxa	[%r21, %r0] 0x25, %r10
	mov	0x0, %r17
	mov	0x60, %r18
	mov	0x3e8, %r20
	.word 0xdedf8e80  ! 3791: LDXA_R	ldxa	[%r30, %r0] 0x74, %r15
	.word 0x8780204f  ! 3792: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde9e2000  ! 3793: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r15
	.word 0xdc948400  ! 3794: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	.word 0x87802073  ! 3795: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 3796: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb7e000  ! 3797: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	mov	0x30, %r24
	.word 0xdc9f6000  ! 3799: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xd8b7ce40  ! 3800: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0xdeb544a0  ! 3801: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	.word 0x87802025  ! 3802: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r24
	mov	0x78, %r24
	.word 0xded52000  ! 3805: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r15
	.word 0xde95a000  ! 3806: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r15
	mov	0x70, %r25
	.word 0xd6f44400  ! 3808: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	mov	0x3c0, %r21
	.word 0xdabf0e80  ! 3810: STDA_R	stda	%r13, [%r28 + %r0] 0x74
	.word 0x87802074  ! 3811: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf76000  ! 3812: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xd0b44400  ! 3813: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xd4ac4400  ! 3814: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xd4bf2000  ! 3815: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	wr_tick_cmpr_0_37:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xbe, %g2
	or	%g4, 0xef, %g4
	or	%g6, 0xfd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4d7a000  ! 3817: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	.word 0xd4a76000  ! 3818: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd497e000  ! 3819: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 3820: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4cee000  ! 3821: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r10
	.word 0x87802073  ! 3822: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4df2000  ! 3823: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	mov	0x20, %r16
	.word 0x87802025  ! 3825: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdef584a0  ! 3826: STXA_R	stxa	%r15, [%r22 + %r0] 0x25
	.word 0x87802074  ! 3827: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdea7e000  ! 3828: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xd8cf8e40  ! 3829: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r12
	.word 0xd8dfa000  ! 3830: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8a76000  ! 3831: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xd49609e0  ! 3832: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r10
	.word 0xd0978e80  ! 3833: LDUHA_R	lduha	[%r30, %r0] 0x74, %r8
	.word 0xd4848400  ! 3834: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r10
	.word 0xd6f48400  ! 3835: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	mov	0x3c0, %r20
	.word 0xd6d504a0  ! 3837: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r11
	.word 0xd0a70e60  ! 3838: STWA_R	stwa	%r8, [%r28 + %r0] 0x73
	.word 0xd0bfe000  ! 3839: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd0976000  ! 3840: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0d72000  ! 3841: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd2b48400  ! 3842: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd29fa000  ! 3843: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd2a7e000  ! 3844: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xd4a74e40  ! 3845: STWA_R	stwa	%r10, [%r29 + %r0] 0x72
	mov	0x7f0, %r21
	mov	0x68, %r26
	.word 0xdad544a0  ! 3848: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r13
	.word 0xdaa7a000  ! 3849: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0xdab7a000  ! 3851: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdabfa000  ! 3852: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 3853: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4cfce80  ! 3854: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r10
	mov	0x38, %r16
	wr_tick_cmpr_0_38:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf0, %g2
	or	%g4, 0xdd, %g4
	or	%g6, 0xf3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4cfa000  ! 3857: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0xd497a000  ! 3858: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0xd8f78e40  ! 3859: STXA_R	stxa	%r12, [%r30 + %r0] 0x72
	.word 0xd8c78e40  ! 3860: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r12
	mov	0x30, %r25
	.word 0xdea689e0  ! 3862: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 3863: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r22
	.word 0xdab74e40  ! 3865: STHA_R	stha	%r13, [%r29 + %r0] 0x72
	.word 0xdadc2000  ! 3866: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r13
	mov	0x8, %r16
	.word 0xd8bcc400  ! 3868: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0xd8cce000  ! 3869: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r12
	.word 0xd0b44400  ! 3870: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	mov	0x20, %r26
	mov	0x20, %r25
	.word 0xde8c0400  ! 3873: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0xd8dd84a0  ! 3874: LDXA_R	ldxa	[%r22, %r0] 0x25, %r12
	.word 0xdc97ce40  ! 3875: LDUHA_R	lduha	[%r31, %r0] 0x72, %r14
	mov	0x70, %r18
	mov	0x18, %r17
	.word 0xdeadc4a0  ! 3878: STBA_R	stba	%r15, [%r23 + %r0] 0x25
	.word 0xdea46000  ! 3879: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xd0a6c9e0  ! 3880: STWA_R	stwa	%r8, [%r27 + %r0] 0x4f
	.word 0xd0b46000  ! 3881: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0xd0ace000  ! 3882: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0xd0df4e60  ! 3883: LDXA_R	ldxa	[%r29, %r0] 0x73, %r8
	.word 0xd094a000  ! 3884: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	mov	0x28, %r26
	.word 0x87802074  ! 3886: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd09fe000  ! 3887: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	.word 0x87802020  ! 3888: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r17
	.word 0xd6afce60  ! 3890: STBA_R	stba	%r11, [%r31 + %r0] 0x73
	.word 0xd4a78e80  ! 3891: STWA_R	stwa	%r10, [%r30 + %r0] 0x74
	.word 0xd094c400  ! 3892: LDUHA_R	lduha	[%r19, %r0] 0x20, %r8
	.word 0xd8c7ce40  ! 3893: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r12
	.word 0xdeac8400  ! 3894: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xde8ca000  ! 3895: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0xd0b70e80  ! 3896: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	.word 0xd0a4a000  ! 3897: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0xd0bce000  ! 3898: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	mov	0x7f0, %r21
	.word 0xdcbf4e80  ! 3900: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	.word 0x8780204f  ! 3901: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f8, %r22
	mov	0x7e0, %r21
	.word 0xd6b584a0  ! 3904: STHA_R	stha	%r11, [%r22 + %r0] 0x25
	.word 0xd6b62000  ! 3905: STHA_I	stha	%r11, [%r24 + 0x0000] %asi
	mov	0x20, %r19
	.word 0xd69ee000  ! 3907: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r11
	mov	0x3c8, %r21
	.word 0xdef44400  ! 3909: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xd68fce80  ! 3910: LDUBA_R	lduba	[%r31, %r0] 0x74, %r11
	mov	0x7f8, %r21
	.word 0xd6cee000  ! 3912: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r11
	mov	0x40, %r18
	.word 0xd6cea000  ! 3914: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	.word 0xdc9fce80  ! 3915: LDDA_R	ldda	[%r31, %r0] 0x74, %r14
	.word 0xd0b5c4a0  ! 3916: STHA_R	stha	%r8, [%r23 + %r0] 0x25
	.word 0xd0b6a000  ! 3917: STHA_I	stha	%r8, [%r26 + 0x0000] %asi
	.word 0xdaf40400  ! 3918: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0x87802020  ! 3919: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_0_39:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x93, %g2
	or	%g4, 0xba, %g4
	or	%g6, 0xb6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdcbd44a0  ! 3921: STDA_R	stda	%r14, [%r21 + %r0] 0x25
	mov	0x60, %r25
	.word 0x87802073  ! 3923: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r27
	.word 0xdc87e000  ! 3925: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xd8b70e40  ! 3926: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0x87802020  ! 3927: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bc2000  ! 3928: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd8bc2000  ! 3929: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xdcb6c9e0  ! 3930: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	.word 0xdc94e000  ! 3931: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	.word 0xdcf4e000  ! 3932: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	mov	0x40, %r24
	mov	0x78, %r16
	.word 0xdcb4a000  ! 3935: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xdcac2000  ! 3936: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0xdcbce000  ! 3937: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xdebf4e60  ! 3938: STDA_R	stda	%r15, [%r29 + %r0] 0x73
	mov	0x20, %r19
	.word 0xdeb46000  ! 3940: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0xd4a7ce80  ! 3941: STWA_R	stwa	%r10, [%r31 + %r0] 0x74
	mov	0x38, %r27
	mov	0x3c0, %r22
	.word 0xd48fce80  ! 3944: LDUBA_R	lduba	[%r31, %r0] 0x74, %r10
	.word 0xd4a42000  ! 3945: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0xd4c46000  ! 3946: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r10
	.word 0xd4d4e000  ! 3947: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0xd4b4e000  ! 3948: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xd49c6000  ! 3949: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0x87802074  ! 3950: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4bfa000  ! 3951: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd2bd04a0  ! 3952: STDA_R	stda	%r9, [%r20 + %r0] 0x25
	.word 0xd2f7ce60  ! 3953: STXA_R	stxa	%r9, [%r31 + %r0] 0x73
	.word 0xd2b7a000  ! 3954: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd2af6000  ! 3955: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xdc874e80  ! 3956: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r14
	.word 0xd2dfce60  ! 3957: LDXA_R	ldxa	[%r31, %r0] 0x73, %r9
	mov	0x7f0, %r21
	.word 0x87802074  ! 3959: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r22
	.word 0xdcaf8e40  ! 3961: STBA_R	stba	%r14, [%r30 + %r0] 0x72
	.word 0xdcf7e000  ! 3962: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x7c0, %r22
	.word 0x8780204f  ! 3964: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdca66000  ! 3965: STWA_I	stwa	%r14, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 3966: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcaca000  ! 3967: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xdec689e0  ! 3968: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r15
	.word 0x87802074  ! 3969: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b5c4a0  ! 3970: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	.word 0xd4a7e000  ! 3971: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xdea40400  ! 3972: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	wr_tick_cmpr_0_40:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb5, %g2
	or	%g4, 0x93, %g4
	or	%g6, 0xf1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802074  ! 3974: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r25
	mov	0x8, %r18
	.word 0xded7e000  ! 3977: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0xdebfe000  ! 3978: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xdecc4400  ! 3979: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r15
	.word 0x87802072  ! 3980: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef7e000  ! 3981: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xdabe89e0  ! 3982: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcbdc4a0  ! 3984: STDA_R	stda	%r14, [%r23 + %r0] 0x25
	.word 0x87802073  ! 3985: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc97e000  ! 3986: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xd4f7ce80  ! 3987: STXA_R	stxa	%r10, [%r31 + %r0] 0x74
	.word 0xd4bf6000  ! 3988: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xde978e60  ! 3989: LDUHA_R	lduha	[%r30, %r0] 0x73, %r15
	.word 0xdaf504a0  ! 3990: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	.word 0xdabf2000  ! 3991: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 3992: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r18
	.word 0xda87e000  ! 3994: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0xdab7e000  ! 3995: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xd8f40400  ! 3996: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xd2a48400  ! 3997: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	mov	0x78, %r17
	.word 0xd2bfa000  ! 3999: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd29fe000  ! 4000: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0x87802020  ! 4001: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_0_41:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xd4, %g2
	or	%g4, 0x8b, %g4
	or	%g6, 0xec, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x8780204f  ! 4003: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r19
	.word 0xd2bea000  ! 4005: STDA_I	stda	%r9, [%r26 + 0x0000] %asi
	.word 0xd0bf4e40  ! 4006: STDA_R	stda	%r8, [%r29 + %r0] 0x72
	.word 0xd0de2000  ! 4007: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r8
	mov	0x20, %r16
	mov	0x48, %r19
	mov	0x7f0, %r21
	mov	0x3f0, %r20
	.word 0xd2cc8400  ! 4012: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0xd2d6e000  ! 4013: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r9
	mov	0x7e8, %r23
	.word 0xdcac4400  ! 4015: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	.word 0xd89f4e80  ! 4016: LDDA_R	ldda	[%r29, %r0] 0x74, %r12
	.word 0xd886e000  ! 4017: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r12
	.word 0xd8be2000  ! 4018: STDA_I	stda	%r12, [%r24 + 0x0000] %asi
	.word 0x87802072  ! 4019: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b7a000  ! 4020: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xdaad84a0  ! 4021: STBA_R	stba	%r13, [%r22 + %r0] 0x25
	.word 0xdabc4400  ! 4022: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xd4a78e80  ! 4023: STWA_R	stwa	%r10, [%r30 + %r0] 0x74
	.word 0xd497a000  ! 4024: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0xdccc0400  ! 4025: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r14
	.word 0xdc9f6000  ! 4026: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xd4b44400  ! 4027: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	.word 0xdedf8e40  ! 4028: LDXA_R	ldxa	[%r30, %r0] 0x72, %r15
	.word 0xdebf6000  ! 4029: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	mov	0x58, %r24
	.word 0xdedc4400  ! 4031: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	.word 0xde87e000  ! 4032: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdef7e000  ! 4033: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xdca70e60  ! 4034: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	.word 0xd0a44400  ! 4035: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0x87802074  ! 4036: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 4037: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 4038: WRASI_I	wr	%r0, 0x004f, %asi
	wr_tick_cmpr_0_42:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe6, %g2
	or	%g4, 0xbf, %g4
	or	%g6, 0xf9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd09f8e60  ! 4040: LDDA_R	ldda	[%r30, %r0] 0x73, %r8
	.word 0xd0bea000  ! 4041: STDA_I	stda	%r8, [%r26 + 0x0000] %asi
	.word 0x8780204f  ! 4042: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa544a0  ! 4043: STWA_R	stwa	%r13, [%r21 + %r0] 0x25
	.word 0xdab62000  ! 4044: STHA_I	stha	%r13, [%r24 + 0x0000] %asi
	mov	0x18, %r27
	.word 0xda9ee000  ! 4046: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r13
	.word 0xdabe2000  ! 4047: STDA_I	stda	%r13, [%r24 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd29f4e60  ! 4049: LDDA_R	ldda	[%r29, %r0] 0x73, %r9
	mov	0x3c0, %r20
	.word 0xd2b6e000  ! 4051: STHA_I	stha	%r9, [%r27 + 0x0000] %asi
	.word 0xd2966000  ! 4052: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r9
	mov	0x3f8, %r20
	mov	0x3d8, %r21
	mov	0x50, %r25
	.word 0x8780204f  ! 4056: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd29e2000  ! 4057: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r9
	.word 0xd2f6a000  ! 4058: STXA_I	stxa	%r9, [%r26 + 0x0000] %asi
	.word 0xd4844400  ! 4059: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0xd4cee000  ! 4060: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r10
	.word 0xdcdf8e80  ! 4061: LDXA_R	ldxa	[%r30, %r0] 0x74, %r14
	.word 0xd6ad44a0  ! 4062: STBA_R	stba	%r11, [%r21 + %r0] 0x25
	.word 0xd6862000  ! 4063: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 4064: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r16
	mov	0x3d8, %r22
	mov	0x40, %r16
	mov	0x48, %r16
	mov	0x28, %r17
	mov	0x0, %r27
	.word 0x87802020  ! 4071: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r22
	.word 0xdc87ce60  ! 4073: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r14
	.word 0xd8f70e60  ! 4074: STXA_R	stxa	%r12, [%r28 + %r0] 0x73
	mov	0x58, %r25
	.word 0x87802020  ! 4076: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 4077: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r25
	.word 0xd8b5e000  ! 4079: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	mov	0x18, %r18
	.word 0xd0a70e80  ! 4081: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	mov	0x3f0, %r23
	.word 0xd0bd2000  ! 4083: STDA_I	stda	%r8, [%r20 + 0x0000] %asi
	.word 0xd48689e0  ! 4084: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r10
	.word 0xdef70e40  ! 4085: STXA_R	stxa	%r15, [%r28 + %r0] 0x72
	mov	0x7f8, %r21
	.word 0x87802073  ! 4087: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdebec9e0  ! 4088: STDA_R	stda	%r15, [%r27 + %r0] 0x4f
	.word 0xd2acc400  ! 4089: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	mov	0x10, %r18
	.word 0x87802073  ! 4091: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a40400  ! 4092: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0xd08f6000  ! 4093: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r8
	.word 0x87802025  ! 4094: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8f44400  ! 4095: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xd8a52000  ! 4096: STWA_I	stwa	%r12, [%r20 + 0x0000] %asi
	.word 0xd8cd6000  ! 4097: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r12
	.word 0xd8f5e000  ! 4098: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	.word 0xd8bd2000  ! 4099: STDA_I	stda	%r12, [%r20 + 0x0000] %asi
	.word 0xd8956000  ! 4100: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r12
	.word 0xd4a48400  ! 4101: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xd8be49e0  ! 4102: STDA_R	stda	%r12, [%r25 + %r0] 0x4f
	.word 0xdaad44a0  ! 4103: STBA_R	stba	%r13, [%r21 + %r0] 0x25
	.word 0xd08d04a0  ! 4104: LDUBA_R	lduba	[%r20, %r0] 0x25, %r8
	.word 0xdacd44a0  ! 4105: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r13
	mov	0x3d0, %r22
	.word 0xdaf5a000  ! 4107: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xdacda000  ! 4108: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r13
	.word 0xd0b74e60  ! 4109: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	.word 0xd08da000  ! 4110: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r8
	.word 0xd8bc0400  ! 4111: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	mov	0x3e8, %r21
	.word 0xdedf0e40  ! 4113: LDXA_R	ldxa	[%r28, %r0] 0x72, %r15
	mov	0x38, %r16
	.word 0xdea609e0  ! 4115: STWA_R	stwa	%r15, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 4116: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdedfa000  ! 4117: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xd2df0e60  ! 4118: LDXA_R	ldxa	[%r28, %r0] 0x73, %r9
	.word 0x87802073  ! 4119: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbe09e0  ! 4120: STDA_R	stda	%r14, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 4121: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdccf2000  ! 4122: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xdcf76000  ! 4123: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x70, %r26
	.word 0xdef78e60  ! 4125: STXA_R	stxa	%r15, [%r30 + %r0] 0x73
	.word 0xdeaf2000  ! 4126: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xd0ac8400  ! 4127: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xd0f7e000  ! 4128: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xd0d4c400  ! 4130: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	.word 0xd0cfa000  ! 4131: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	mov	0x60, %r17
	mov	0x50, %r19
	.word 0xd097a000  ! 4134: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	.word 0xd6f74e40  ! 4135: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	.word 0xd687e000  ! 4136: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xd4f44400  ! 4137: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 4138: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdade09e0  ! 4139: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r13
	.word 0x87802073  ! 4140: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r25
	.word 0xdabfa000  ! 4142: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdcb44400  ! 4143: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	mov	0x58, %r25
	.word 0xdeccc400  ! 4145: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r15
	.word 0xd8f78e80  ! 4146: STXA_R	stxa	%r12, [%r30 + %r0] 0x74
	.word 0x87802073  ! 4147: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 4148: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e8, %r23
	.word 0xd8b52000  ! 4150: STHA_I	stha	%r12, [%r20 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xd8d649e0  ! 4152: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r12
	mov	0x3f0, %r20
	.word 0xd8a56000  ! 4154: STWA_I	stwa	%r12, [%r21 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0x87802020  ! 4156: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd897ce80  ! 4157: LDUHA_R	lduha	[%r31, %r0] 0x74, %r12
	mov	0x48, %r17
	.word 0x87802020  ! 4159: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cc8400  ! 4160: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0xd69c8400  ! 4161: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	.word 0x87802073  ! 4162: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0cc8400  ! 4163: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0xd09fa000  ! 4164: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	.word 0xd0afa000  ! 4165: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	mov	0x38, %r19
	.word 0xd0b7e000  ! 4167: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0xd0972000  ! 4168: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xdcc70e40  ! 4169: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r14
	mov	0x3e0, %r23
	mov	0x0, %r19
	mov	0x38, %r18
	.word 0xdcdf6000  ! 4173: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xd4f4c400  ! 4174: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd0bcc400  ! 4175: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0x87802020  ! 4176: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8adc4a0  ! 4177: STBA_R	stba	%r12, [%r23 + %r0] 0x25
	.word 0xd8f4a000  ! 4178: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	mov	0x68, %r18
	.word 0xd8a42000  ! 4180: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8ac6000  ! 4181: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	mov	0x60, %r27
	.word 0xdacf4e40  ! 4183: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r13
	mov	0x40, %r19
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd295c4a0  ! 4186: LDUHA_R	lduha	[%r23, %r0] 0x25, %r9
	.word 0xd29c2000  ! 4187: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	.word 0xd6bcc400  ! 4188: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0xd6f46000  ! 4189: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xd6974e60  ! 4191: LDUHA_R	lduha	[%r29, %r0] 0x73, %r11
	.word 0xd0bc8400  ! 4192: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 4193: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd08ee000  ! 4194: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r8
	.word 0xd0a62000  ! 4195: STWA_I	stwa	%r8, [%r24 + 0x0000] %asi
	.word 0xd0948400  ! 4196: LDUHA_R	lduha	[%r18, %r0] 0x20, %r8
	mov	0x3e0, %r23
	.word 0xdc8fce80  ! 4198: LDUBA_R	lduba	[%r31, %r0] 0x74, %r14
	.word 0xdecfce80  ! 4199: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r15
	.word 0x87802020  ! 4200: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 4201: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdea76000  ! 4202: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xdcbe89e0  ! 4203: STDA_R	stda	%r14, [%r26 + %r0] 0x4f
	mov	0x8, %r17
	.word 0xd086c9e0  ! 4205: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r8
	.word 0xd8c48400  ! 4206: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	.word 0x87802025  ! 4207: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bd2000  ! 4208: STDA_I	stda	%r12, [%r20 + 0x0000] %asi
	.word 0xd8c52000  ! 4209: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r12
	.word 0xd8bd2000  ! 4210: STDA_I	stda	%r12, [%r20 + 0x0000] %asi
	.word 0xd8c52000  ! 4211: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r12
	.word 0xd8bde000  ! 4212: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 4213: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r26
	.word 0xd8de49e0  ! 4215: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r12
	mov	0x60, %r25
	.word 0xd8d42000  ! 4217: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0xd2d504a0  ! 4218: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r9
	.word 0xd8d48400  ! 4219: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	mov	0x30, %r18
	.word 0xd4940400  ! 4221: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	.word 0xd4942000  ! 4222: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r10
	.word 0xdccf8e60  ! 4223: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r14
	.word 0xdcb4a000  ! 4224: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	mov	0x7e0, %r22
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802020  ! 4227: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc846000  ! 4228: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	.word 0xdcf42000  ! 4229: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4230: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcace000  ! 4231: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0xd4bf0e60  ! 4232: STDA_R	stda	%r10, [%r28 + %r0] 0x73
	.word 0x87802020  ! 4233: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8c0400  ! 4234: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	.word 0xdab4a000  ! 4235: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0xd2ccc400  ! 4236: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	.word 0xd8d74e60  ! 4237: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r12
	.word 0xd4cfce80  ! 4238: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r10
	.word 0xd4c42000  ! 4239: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r10
	.word 0xd4946000  ! 4240: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r10
	.word 0xdc9504a0  ! 4241: LDUHA_R	lduha	[%r20, %r0] 0x25, %r14
	.word 0xdcdc2000  ! 4242: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r14
	.word 0xd8c48400  ! 4243: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	mov	0x50, %r27
	.word 0xd8d46000  ! 4245: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	.word 0xdaa7ce80  ! 4246: STWA_R	stwa	%r13, [%r31 + %r0] 0x74
	mov	0x20, %r19
	mov	0x8, %r17
	.word 0xd2be09e0  ! 4249: STDA_R	stda	%r9, [%r24 + %r0] 0x4f
	.word 0x87802072  ! 4250: WRASI_I	wr	%r0, 0x0072, %asi
	wr_tick_cmpr_0_43:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x92, %g2
	or	%g4, 0xa4, %g4
	or	%g6, 0xd0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd69e09e0  ! 4252: LDDA_R	ldda	[%r24, %r0] 0x4f, %r11
	mov	0x7d8, %r20
	.word 0xd6b7a000  ! 4254: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd4a74e60  ! 4255: STWA_R	stwa	%r10, [%r29 + %r0] 0x73
	.word 0xde874e60  ! 4256: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r15
	.word 0x87802074  ! 4257: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 4258: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r17
	wr_tick_cmpr_0_44:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb1, %g2
	or	%g4, 0xd6, %g4
	or	%g6, 0x82, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xde8ea000  ! 4261: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r15
	.word 0xd4f689e0  ! 4262: STXA_R	stxa	%r10, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 4263: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r19
	.word 0xd89d84a0  ! 4265: LDDA_R	ldda	[%r22, %r0] 0x25, %r12
	.word 0xd8f52000  ! 4266: STXA_I	stxa	%r12, [%r20 + 0x0000] %asi
	wr_tick_cmpr_0_45:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x9a, %g2
	or	%g4, 0xe9, %g4
	or	%g6, 0x9a, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802025  ! 4268: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd69fce40  ! 4269: LDDA_R	ldda	[%r31, %r0] 0x72, %r11
	mov	0x78, %r24
	.word 0xd6cda000  ! 4271: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r11
	.word 0xdacf4e60  ! 4272: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r13
	mov	0x30, %r26
	.word 0xdaa56000  ! 4274: STWA_I	stwa	%r13, [%r21 + 0x0000] %asi
	.word 0x87802073  ! 4275: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2af4e80  ! 4276: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	.word 0xd2cf2000  ! 4277: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r9
	mov	0x0, %r18
	.word 0xd28f6000  ! 4279: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xda8f8e60  ! 4280: LDUBA_R	lduba	[%r30, %r0] 0x73, %r13
	.word 0x87802025  ! 4281: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebc4400  ! 4282: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0xd8bcc400  ! 4283: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0xd8856000  ! 4284: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4285: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8dc8400  ! 4286: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	mov	0x60, %r25
	.word 0xd8bc6000  ! 4288: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0xd2afce60  ! 4289: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	.word 0xd2a4e000  ! 4290: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	mov	0x38, %r24
	.word 0xd49e09e0  ! 4292: LDDA_R	ldda	[%r24, %r0] 0x4f, %r10
	mov	0x30, %r19
	mov	0x3d0, %r21
	.word 0xd6a40400  ! 4295: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0xda974e60  ! 4296: LDUHA_R	lduha	[%r29, %r0] 0x73, %r13
	mov	0x7c8, %r23
	mov	0x40, %r18
	wr_tick_cmpr_0_46:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xaf, %g2
	or	%g4, 0xf3, %g4
	or	%g6, 0xc5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x8780204f  ! 4300: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r23
	.word 0xd88f4e40  ! 4302: LDUBA_R	lduba	[%r29, %r0] 0x72, %r12
	.word 0xd69c0400  ! 4303: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	.word 0xd8a504a0  ! 4304: STWA_R	stwa	%r12, [%r20 + %r0] 0x25
	mov	0x68, %r16
	mov	0x68, %r26
	.word 0xd896a000  ! 4307: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r12
	mov	0x7f0, %r23
	.word 0x87802020  ! 4309: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4310: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r17
	.word 0xdaa7ce60  ! 4312: STWA_R	stwa	%r13, [%r31 + %r0] 0x73
	mov	0x78, %r26
	.word 0x87802025  ! 4314: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda9d6000  ! 4315: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r13
	.word 0xd6f6c9e0  ! 4316: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	mov	0x50, %r24
	mov	0x38, %r16
	mov	0x3c8, %r23
	mov	0x60, %r27
	.word 0x87802020  ! 4321: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea40400  ! 4322: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xd4a7ce60  ! 4323: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	.word 0xdabe09e0  ! 4324: STDA_R	stda	%r13, [%r24 + %r0] 0x4f
	.word 0xda8c6000  ! 4325: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r13
	mov	0x7c0, %r23
	.word 0xdac4a000  ! 4327: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	.word 0xd2aec9e0  ! 4328: STBA_R	stba	%r9, [%r27 + %r0] 0x4f
	.word 0xde870e60  ! 4329: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r15
	.word 0xd4bfce80  ! 4330: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	.word 0xd4a42000  ! 4331: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4332: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4333: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4d66000  ! 4334: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r10
	.word 0x87802020  ! 4335: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd897ce80  ! 4336: LDUHA_R	lduha	[%r31, %r0] 0x74, %r12
	.word 0x87802020  ! 4337: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r21
	.word 0xd8c6c9e0  ! 4339: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r12
	.word 0xd8a48400  ! 4340: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	mov	0x40, %r27
	.word 0xd89fce80  ! 4342: LDDA_R	ldda	[%r31, %r0] 0x74, %r12
	.word 0xd0f74e60  ! 4343: STXA_R	stxa	%r8, [%r29 + %r0] 0x73
	mov	0x3f8, %r22
	.word 0xdeb544a0  ! 4345: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	mov	0x50, %r26
	.word 0xd6d78e80  ! 4347: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r11
	.word 0xd8b584a0  ! 4348: STHA_R	stha	%r12, [%r22 + %r0] 0x25
	.word 0xdaf78e80  ! 4349: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	.word 0xd68649e0  ! 4350: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r11
	.word 0xdef6c9e0  ! 4351: STXA_R	stxa	%r15, [%r27 + %r0] 0x4f
	.word 0xdea42000  ! 4352: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4353: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeace000  ! 4354: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xd2ac8400  ! 4355: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xd2d4e000  ! 4356: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0xd0bfce40  ! 4357: STDA_R	stda	%r8, [%r31 + %r0] 0x72
	.word 0xd0a4a000  ! 4358: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 4359: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7e8, %r23
	.word 0xd0a689e0  ! 4361: STWA_R	stwa	%r8, [%r26 + %r0] 0x4f
	.word 0xd2a44400  ! 4362: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xdaafce60  ! 4363: STBA_R	stba	%r13, [%r31 + %r0] 0x73
	ta	T_CHANGE_PRIV	! macro
	.word 0xd89e89e0  ! 4365: LDDA_R	ldda	[%r26, %r0] 0x4f, %r12
	.word 0xdcf48400  ! 4366: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	mov	0x7f0, %r20
	.word 0x87802072  ! 4368: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda97ce60  ! 4369: LDUHA_R	lduha	[%r31, %r0] 0x73, %r13
	.word 0xd4a48400  ! 4370: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	mov	0x7c8, %r22
	.word 0xd4d7a000  ! 4372: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	mov	0x7e0, %r22
	mov	0x3e0, %r23
	.word 0xd4b7e000  ! 4375: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 4376: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 4377: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r19
	.word 0xd48cc400  ! 4379: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	.word 0x87802072  ! 4380: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r18
	mov	0x60, %r25
	.word 0xd6af8e80  ! 4383: STBA_R	stba	%r11, [%r30 + %r0] 0x74
	.word 0xd69f2000  ! 4384: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xd494c400  ! 4385: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	.word 0xd4b7a000  ! 4386: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 4387: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdec48400  ! 4388: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	.word 0xdef76000  ! 4389: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	mov	0x40, %r25
	mov	0x38, %r16
	mov	0x20, %r19
	mov	0x3c8, %r21
	.word 0xdef76000  ! 4394: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xd8ad04a0  ! 4395: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	.word 0x87802025  ! 4396: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8cde000  ! 4397: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r12
	mov	0x7d8, %r23
	.word 0xd8f56000  ! 4399: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	.word 0xd8f5a000  ! 4400: STXA_I	stxa	%r12, [%r22 + 0x0000] %asi
	.word 0xd8956000  ! 4401: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r12
	.word 0xd4a7ce40  ! 4402: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	.word 0xdad74e40  ! 4403: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r13
	.word 0x87802020  ! 4404: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r27
	.word 0xdac74e80  ! 4406: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r13
	.word 0xdadce000  ! 4407: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xdab42000  ! 4408: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xd4cd04a0  ! 4409: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r10
	mov	0x0, %r17
	.word 0xd08c0400  ! 4411: LDUBA_R	lduba	[%r16, %r0] 0x20, %r8
	.word 0xd2bc4400  ! 4412: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	mov	0x7d8, %r22
	.word 0xd2d4a000  ! 4414: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	mov	0x50, %r19
	.word 0xd2b78e80  ! 4416: STHA_R	stha	%r9, [%r30 + %r0] 0x74
	.word 0xd2aca000  ! 4417: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	mov	0x38, %r19
	.word 0xda944400  ! 4419: LDUHA_R	lduha	[%r17, %r0] 0x20, %r13
	.word 0xdab74e60  ! 4420: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	mov	0x3f8, %r23
	.word 0x87802073  ! 4422: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaafe000  ! 4423: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	mov	0x7f0, %r22
	mov	0x10, %r19
	.word 0x87802025  ! 4426: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaf5a000  ! 4427: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xdabda000  ! 4428: STDA_I	stda	%r13, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 4429: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4430: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 4431: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabd2000  ! 4432: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	.word 0xde840400  ! 4433: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	.word 0xdebd6000  ! 4434: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	mov	0x30, %r27
	mov	0x68, %r18
	.word 0xded56000  ! 4437: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r15
	mov	0x28, %r27
	.word 0x87802020  ! 4439: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4440: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeafce60  ! 4441: STBA_R	stba	%r15, [%r31 + %r0] 0x73
	.word 0xd297ce60  ! 4442: LDUHA_R	lduha	[%r31, %r0] 0x73, %r9
	mov	0x0, %r26
	.word 0xd6c544a0  ! 4444: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r11
	.word 0xd6c4e000  ! 4445: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r11
	.word 0xd4c70e80  ! 4446: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r10
	.word 0xd4cca000  ! 4447: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r10
	.word 0xd4f4e000  ! 4448: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 4449: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbcc400  ! 4450: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xd2c74e60  ! 4451: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r9
	.word 0xd6bdc4a0  ! 4452: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	.word 0xd68cc400  ! 4453: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	.word 0xd0b78e40  ! 4454: STHA_R	stha	%r8, [%r30 + %r0] 0x72
	.word 0xd0b7a000  ! 4455: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xdac44400  ! 4456: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r13
	.word 0xd4ad04a0  ! 4457: STBA_R	stba	%r10, [%r20 + %r0] 0x25
	.word 0xdcd78e80  ! 4458: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r14
	mov	0x78, %r17
	.word 0x87802020  ! 4460: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc946000  ! 4461: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r14
	mov	0x8, %r27
	mov	0x7d0, %r22
	.word 0xd8f40400  ! 4464: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	mov	0x38, %r18
	.word 0x87802020  ! 4466: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8946000  ! 4467: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	.word 0xd89c6000  ! 4468: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4469: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r21
	mov	0x40, %r26
	.word 0xd88ce000  ! 4472: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	.word 0xd8ac6000  ! 4473: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xd8f42000  ! 4474: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	mov	0x48, %r26
	.word 0xdc8ec9e0  ! 4476: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r14
	.word 0xdcdca000  ! 4477: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xdcd7ce40  ! 4478: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r14
	mov	0x3f8, %r22
	.word 0xdc9c2000  ! 4480: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4481: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4482: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r19
	.word 0xdecd84a0  ! 4484: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r15
	mov	0x7d8, %r20
	mov	0x40, %r19
	.word 0xde846000  ! 4487: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0xd49c0400  ! 4488: LDDA_R	ldda	[%r16, %r0] 0x20, %r10
	.word 0xd49c6000  ! 4489: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0xd4f4a000  ! 4490: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	wr_tick_cmpr_0_47:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc9, %g2
	or	%g4, 0xb1, %g4
	or	%g6, 0xb7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 4492: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd097ce60  ! 4493: LDUHA_R	lduha	[%r31, %r0] 0x73, %r8
	.word 0xdaa78e60  ! 4494: STWA_R	stwa	%r13, [%r30 + %r0] 0x73
	.word 0x87802020  ! 4495: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab4e000  ! 4496: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xdaace000  ! 4497: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 4498: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabfe000  ! 4499: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xdaf76000  ! 4500: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xd49544a0  ! 4501: LDUHA_R	lduha	[%r21, %r0] 0x25, %r10
	mov	0x38, %r16
	.word 0xdcafce80  ! 4503: STBA_R	stba	%r14, [%r31 + %r0] 0x74
	wr_tick_cmpr_0_48:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xbd, %g2
	or	%g4, 0xe7, %g4
	or	%g6, 0xb0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdccfa000  ! 4505: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xd6f78e60  ! 4506: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	.word 0x87802025  ! 4507: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 4508: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6ae6000  ! 4509: STBA_I	stba	%r11, [%r25 + 0x0000] %asi
	.word 0xd4b70e80  ! 4510: STHA_R	stha	%r10, [%r28 + %r0] 0x74
	.word 0xd6d4c400  ! 4511: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	mov	0x10, %r18
	mov	0x68, %r19
	.word 0xd6b6e000  ! 4514: STHA_I	stha	%r11, [%r27 + 0x0000] %asi
	.word 0xd6cea000  ! 4515: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	mov	0x78, %r17
	.word 0xdca44400  ! 4517: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0xd4a4c400  ! 4518: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 4519: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 4520: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4521: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8c8400  ! 4522: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	mov	0x50, %r26
	.word 0xdabca000  ! 4524: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 4525: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4cf4e60  ! 4526: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r10
	.word 0x87802020  ! 4527: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b46000  ! 4528: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xdc9fce60  ! 4529: LDDA_R	ldda	[%r31, %r0] 0x73, %r14
	mov	0x30, %r18
	.word 0xd0c74e40  ! 4531: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r8
	mov	0x3e0, %r22
	.word 0xdcd5c4a0  ! 4533: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r14
	.word 0xdc846000  ! 4534: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	.word 0xdcde49e0  ! 4535: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r14
	.word 0xdcd46000  ! 4536: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	mov	0x28, %r18
	.word 0xdcb4e000  ! 4538: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 4539: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde9dc4a0  ! 4540: LDDA_R	ldda	[%r23, %r0] 0x25, %r15
	.word 0xd0a4c400  ! 4541: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xd6df8e80  ! 4542: LDXA_R	ldxa	[%r30, %r0] 0x74, %r11
	.word 0xdea649e0  ! 4543: STWA_R	stwa	%r15, [%r25 + %r0] 0x4f
	.word 0xd68c8400  ! 4544: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	.word 0xd695a000  ! 4545: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r11
	.word 0xdc9f0e80  ! 4546: LDDA_R	ldda	[%r28, %r0] 0x74, %r14
	.word 0xde8f8e40  ! 4547: LDUBA_R	lduba	[%r30, %r0] 0x72, %r15
	.word 0xdef52000  ! 4548: STXA_I	stxa	%r15, [%r20 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x38, %r25
	mov	0x60, %r25
	.word 0xdef56000  ! 4552: STXA_I	stxa	%r15, [%r21 + 0x0000] %asi
	mov	0x3d0, %r23
	.word 0xde9d2000  ! 4554: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r15
	.word 0xdecde000  ! 4555: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r15
	mov	0x40, %r17
	.word 0x87802025  ! 4557: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4558: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebce000  ! 4559: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xdef4a000  ! 4560: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0xdebf8e40  ! 4561: STDA_R	stda	%r15, [%r30 + %r0] 0x72
	wr_tick_cmpr_0_49:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xc9, %g2
	or	%g4, 0xe4, %g4
	or	%g6, 0xd8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x8780204f  ! 4563: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebea000  ! 4564: STDA_I	stda	%r15, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 4565: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r24
	.word 0xd6a44400  ! 4567: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0xd6ace000  ! 4568: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0xdca7ce60  ! 4569: STWA_R	stwa	%r14, [%r31 + %r0] 0x73
	.word 0xd69f4e40  ! 4570: LDDA_R	ldda	[%r29, %r0] 0x72, %r11
	mov	0x3c0, %r22
	.word 0x87802025  ! 4572: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a5e000  ! 4573: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	.word 0xd695e000  ! 4574: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 4575: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd696a000  ! 4576: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r11
	.word 0xd696a000  ! 4577: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r11
	.word 0xd6ce2000  ! 4578: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	.word 0xd4f649e0  ! 4579: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	.word 0x8780204f  ! 4580: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdab584a0  ! 4581: STHA_R	stha	%r13, [%r22 + %r0] 0x25
	.word 0x87802073  ! 4582: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdab72000  ! 4583: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdaa7a000  ! 4584: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xdab72000  ! 4585: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdacf2000  ! 4586: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4587: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c40400  ! 4588: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r9
	.word 0xd29ce000  ! 4589: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xd4ce49e0  ! 4590: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r10
	mov	0x3f8, %r23
	.word 0x87802072  ! 4592: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a7a000  ! 4593: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	mov	0x70, %r19
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802073  ! 4596: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r26
	mov	0x40, %r16
	.word 0xd487e000  ! 4599: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	mov	0x60, %r25
	.word 0xd4b76000  ! 4601: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xd0afce40  ! 4603: STBA_R	stba	%r8, [%r31 + %r0] 0x72
	.word 0xd2bc0400  ! 4604: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xdaa4c400  ! 4605: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	mov	0x48, %r16
	.word 0x87802020  ! 4607: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6dc8400  ! 4608: LDXA_R	ldxa	[%r18, %r0] 0x20, %r11
	.word 0xd2cc8400  ! 4609: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0xd2cc6000  ! 4610: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	.word 0xd2942000  ! 4611: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd4af4e80  ! 4612: STBA_R	stba	%r10, [%r29 + %r0] 0x74
	.word 0x87802020  ! 4613: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa74e60  ! 4614: STWA_R	stwa	%r13, [%r29 + %r0] 0x73
	.word 0xdaa42000  ! 4615: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0xd4a40400  ! 4616: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	mov	0x48, %r25
	.word 0xd4f42000  ! 4618: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd4dc6000  ! 4619: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	.word 0xd6f5c4a0  ! 4620: STXA_R	stxa	%r11, [%r23 + %r0] 0x25
	mov	0x3d0, %r21
	.word 0xd2d74e80  ! 4622: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r9
	.word 0xd6f6c9e0  ! 4623: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	mov	0x3e0, %r23
	.word 0xd2a7ce60  ! 4625: STWA_R	stwa	%r9, [%r31 + %r0] 0x73
	.word 0xd09f0e80  ! 4626: LDDA_R	ldda	[%r28, %r0] 0x74, %r8
	mov	0x70, %r16
	.word 0xd09ce000  ! 4628: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r8
	.word 0xd4af8e60  ! 4629: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	.word 0xd4b4a000  ! 4630: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 4631: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c8, %r22
	mov	0x20, %r16
	mov	0x3d0, %r21
	.word 0xd4f62000  ! 4635: STXA_I	stxa	%r10, [%r24 + 0x0000] %asi
	mov	0x50, %r17
	.word 0xd49ee000  ! 4637: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r10
	.word 0xd4b62000  ! 4638: STHA_I	stha	%r10, [%r24 + 0x0000] %asi
	.word 0xd4ae6000  ! 4639: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0xd4b6a000  ! 4640: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	.word 0xd4b66000  ! 4641: STHA_I	stha	%r10, [%r25 + 0x0000] %asi
	.word 0xd4d62000  ! 4642: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r10
	.word 0xdebc8400  ! 4643: STDA_R	stda	%r15, [%r18 + %r0] 0x20
	mov	0x70, %r16
	mov	0x40, %r26
	.word 0xdea6a000  ! 4646: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	.word 0xdeac8400  ! 4647: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0x87802072  ! 4648: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebf2000  ! 4649: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xd4df0e60  ! 4650: LDXA_R	ldxa	[%r28, %r0] 0x73, %r10
	.word 0x8780204f  ! 4651: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdede49e0  ! 4652: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r15
	mov	0x28, %r26
	.word 0xdea6e000  ! 4654: STWA_I	stwa	%r15, [%r27 + 0x0000] %asi
	.word 0xde9e2000  ! 4655: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r15
	.word 0xdebea000  ! 4656: STDA_I	stda	%r15, [%r26 + 0x0000] %asi
	.word 0xd69e49e0  ! 4657: LDDA_R	ldda	[%r25, %r0] 0x4f, %r11
	.word 0xdef689e0  ! 4658: STXA_R	stxa	%r15, [%r26 + %r0] 0x4f
	mov	0x18, %r24
	.word 0x87802074  ! 4660: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8ac8400  ! 4661: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	mov	0x68, %r24
	mov	0x7f8, %r22
	.word 0x87802072  ! 4664: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r19
	mov	0x0, %r26
	.word 0x87802073  ! 4667: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 4668: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ce2000  ! 4669: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r12
	mov	0x7f0, %r20
	mov	0x60, %r16
	mov	0x8, %r27
	mov	0x28, %r19
	mov	0x18, %r25
	.word 0xd8f62000  ! 4675: STXA_I	stxa	%r12, [%r24 + 0x0000] %asi
	.word 0xd8c6a000  ! 4676: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r12
	.word 0xdebcc400  ! 4677: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	.word 0xdeae6000  ! 4678: STBA_I	stba	%r15, [%r25 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xdecea000  ! 4680: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r15
	.word 0xdec6e000  ! 4681: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r15
	.word 0xdedee000  ! 4682: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r15
	.word 0xdeb6e000  ! 4683: STHA_I	stha	%r15, [%r27 + 0x0000] %asi
	mov	0x8, %r26
	.word 0x87802020  ! 4685: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcc48400  ! 4686: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r14
	mov	0x3d8, %r22
	.word 0xdc8ce000  ! 4688: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4689: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r17
	mov	0x60, %r25
	.word 0xdcbce000  ! 4692: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	mov	0x48, %r16
	.word 0xdca4e000  ! 4694: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xdcd46000  ! 4696: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	mov	0x38, %r18
	.word 0xd49ec9e0  ! 4698: LDDA_R	ldda	[%r27, %r0] 0x4f, %r10
	.word 0xd4f4e000  ! 4699: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0xd4dc6000  ! 4700: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	.word 0xd49c6000  ! 4701: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0x87802074  ! 4702: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4c72000  ! 4703: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r10
	.word 0xd8ac8400  ! 4704: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0xd8a76000  ! 4705: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	mov	0x50, %r19
	.word 0x87802020  ! 4707: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4708: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r16
	mov	0x70, %r16
	mov	0x7f0, %r21
	.word 0xd2ac0400  ! 4712: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	mov	0x3f8, %r21
	.word 0xdcb7ce60  ! 4714: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	.word 0xdc84a000  ! 4715: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4716: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r16
	.word 0xd0a48400  ! 4718: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0xd4a689e0  ! 4719: STWA_R	stwa	%r10, [%r26 + %r0] 0x4f
	.word 0xd4d46000  ! 4720: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r10
	mov	0x0, %r16
	.word 0xdc944400  ! 4722: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	.word 0xdcf4e000  ! 4723: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcf42000  ! 4724: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0xd6a44400  ! 4725: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	mov	0x68, %r25
	.word 0xd2b74e40  ! 4727: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	mov	0x3d8, %r22
	.word 0xde874e80  ! 4729: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r15
	.word 0xded4e000  ! 4730: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	.word 0xd49e49e0  ! 4731: LDDA_R	ldda	[%r25, %r0] 0x4f, %r10
	.word 0xdca7ce40  ! 4732: STWA_R	stwa	%r14, [%r31 + %r0] 0x72
	.word 0xded544a0  ! 4733: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r15
	.word 0xdef4e000  ! 4734: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xd6bd04a0  ! 4735: STDA_R	stda	%r11, [%r20 + %r0] 0x25
	mov	0x78, %r19
	.word 0xd6d4e000  ! 4737: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r11
	.word 0xd6aca000  ! 4738: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xd4d4c400  ! 4739: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0xd2b70e80  ! 4740: STHA_R	stha	%r9, [%r28 + %r0] 0x74
	mov	0x60, %r19
	.word 0xd484c400  ! 4742: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	.word 0xd4d42000  ! 4743: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	mov	0x50, %r17
	.word 0xd4a46000  ! 4745: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xde870e60  ! 4746: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r15
	.word 0xdea42000  ! 4747: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	mov	0x0, %r17
	.word 0xde9c6000  ! 4749: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0xd8c7ce60  ! 4750: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r12
	.word 0xd8d42000  ! 4751: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	mov	0x30, %r26
	mov	0x7f0, %r21
	.word 0xd8c4e000  ! 4754: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	.word 0xd8ac6000  ! 4755: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xde9c8400  ! 4756: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	.word 0xde9ce000  ! 4757: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0x87802020  ! 4758: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a544a0  ! 4759: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	.word 0xd0a46000  ! 4760: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xd89c4400  ! 4761: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	mov	0x3f0, %r21
	mov	0x58, %r18
	mov	0x20, %r19
	.word 0xd8aca000  ! 4765: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0xd8d4e000  ! 4766: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0xda9c0400  ! 4767: LDDA_R	ldda	[%r16, %r0] 0x20, %r13
	mov	0x8, %r19
	.word 0xdacce000  ! 4769: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r13
	.word 0xda8ce000  ! 4770: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	.word 0xdabca000  ! 4771: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 4772: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2a544a0  ! 4773: STWA_R	stwa	%r9, [%r21 + %r0] 0x25
	.word 0xd2af2000  ! 4774: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 4775: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2972000  ! 4776: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xd2f72000  ! 4777: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd2f7a000  ! 4778: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 4779: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bea000  ! 4780: STDA_I	stda	%r9, [%r26 + 0x0000] %asi
	.word 0xd2b66000  ! 4781: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	mov	0x18, %r19
	.word 0x87802020  ! 4783: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bce000  ! 4784: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0xd8b74e40  ! 4786: STHA_R	stha	%r12, [%r29 + %r0] 0x72
	.word 0xd8946000  ! 4787: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	.word 0xd8b46000  ! 4788: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0xdca4c400  ! 4789: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xd496c9e0  ! 4790: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r10
	.word 0xd497ce40  ! 4791: LDUHA_R	lduha	[%r31, %r0] 0x72, %r10
	.word 0x87802020  ! 4792: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6be49e0  ! 4793: STDA_R	stda	%r11, [%r25 + %r0] 0x4f
	.word 0xd49d04a0  ! 4794: LDDA_R	ldda	[%r20, %r0] 0x25, %r10
	.word 0xdaa70e60  ! 4795: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	.word 0xda974e80  ! 4796: LDUHA_R	lduha	[%r29, %r0] 0x74, %r13
	mov	0x3e0, %r23
	.word 0xdaf46000  ! 4798: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xd0a70e60  ! 4800: STWA_R	stwa	%r8, [%r28 + %r0] 0x73
	mov	0x7f8, %r21
	mov	0x3d0, %r22
	.word 0xd0c4a000  ! 4803: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	mov	0x3c8, %r20
	.word 0xd0bc6000  ! 4805: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 4806: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bd84a0  ! 4807: STDA_R	stda	%r9, [%r22 + %r0] 0x25
	.word 0xd48d84a0  ! 4808: LDUBA_R	lduba	[%r22, %r0] 0x25, %r10
	.word 0xd4cd6000  ! 4809: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r10
	.word 0xd4a56000  ! 4810: STWA_I	stwa	%r10, [%r21 + 0x0000] %asi
	.word 0xde8ec9e0  ! 4811: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r15
	.word 0x87802020  ! 4812: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8c6000  ! 4813: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	mov	0x50, %r25
	.word 0xd88f0e60  ! 4815: LDUBA_R	lduba	[%r28, %r0] 0x73, %r12
	.word 0xd8946000  ! 4816: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	mov	0x7d8, %r21
	.word 0xd8cf4e60  ! 4818: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r12
	.word 0xd8ac2000  ! 4819: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0xdef40400  ! 4820: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	mov	0x3c0, %r23
	mov	0x58, %r17
	mov	0x70, %r16
	.word 0xde94a000  ! 4824: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0x87802020  ! 4825: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ac8400  ! 4826: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0xd4f78e60  ! 4827: STXA_R	stxa	%r10, [%r30 + %r0] 0x73
	mov	0x7f0, %r20
	.word 0x87802072  ! 4829: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf48400  ! 4830: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xdab74e80  ! 4831: STHA_R	stha	%r13, [%r29 + %r0] 0x74
	.word 0x87802020  ! 4832: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 4833: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 4834: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r17
	.word 0x8780204f  ! 4836: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f48400  ! 4837: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	mov	0x38, %r24
	.word 0xd487ce60  ! 4839: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r10
	mov	0x28, %r24
	.word 0x8780204f  ! 4841: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 4842: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6dc0400  ! 4843: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	.word 0xd2ac8400  ! 4844: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xd2ac4400  ! 4845: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xd297a000  ! 4846: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	.word 0x87802074  ! 4847: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bf2000  ! 4848: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd0a40400  ! 4849: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0x87802072  ! 4850: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6c74e60  ! 4851: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r11
	.word 0xd6f7e000  ! 4852: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd4f689e0  ! 4853: STXA_R	stxa	%r10, [%r26 + %r0] 0x4f
	mov	0x3d8, %r20
	.word 0x87802025  ! 4855: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4d5e000  ! 4856: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r10
	.word 0xd4856000  ! 4857: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r10
	mov	0x58, %r18
	mov	0x58, %r25
	.word 0xd4f52000  ! 4860: STXA_I	stxa	%r10, [%r20 + 0x0000] %asi
	.word 0xd4a5e000  ! 4861: STWA_I	stwa	%r10, [%r23 + 0x0000] %asi
	.word 0xd2a74e60  ! 4862: STWA_R	stwa	%r9, [%r29 + %r0] 0x73
	.word 0xd2bda000  ! 4863: STDA_I	stda	%r9, [%r22 + 0x0000] %asi
	.word 0x87802074  ! 4864: WRASI_I	wr	%r0, 0x0074, %asi
	wr_tick_cmpr_0_50:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x8f, %g2
	or	%g4, 0xf8, %g4
	or	%g6, 0x95, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4f6c9e0  ! 4866: STXA_R	stxa	%r10, [%r27 + %r0] 0x4f
	.word 0xd4dfa000  ! 4867: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	mov	0x0, %r17
	.word 0xd49e09e0  ! 4869: LDDA_R	ldda	[%r24, %r0] 0x4f, %r10
	.word 0xda848400  ! 4870: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r13
	mov	0x30, %r27
	.word 0xdea44400  ! 4872: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0x87802020  ! 4873: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2944400  ! 4874: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	.word 0xd284a000  ! 4875: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	.word 0xd6b6c9e0  ! 4876: STHA_R	stha	%r11, [%r27 + %r0] 0x4f
	.word 0xd6b46000  ! 4877: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd0f78e60  ! 4878: STXA_R	stxa	%r8, [%r30 + %r0] 0x73
	.word 0xd0c46000  ! 4879: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r8
	.word 0xd6b7ce80  ! 4880: STHA_R	stha	%r11, [%r31 + %r0] 0x74
	.word 0x87802073  ! 4881: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f72000  ! 4882: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 4883: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4884: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ac4400  ! 4885: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xdabe09e0  ! 4886: STDA_R	stda	%r13, [%r24 + %r0] 0x4f
	.word 0xdadca000  ! 4887: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0xdaac6000  ! 4888: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	.word 0xda84a000  ! 4889: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	.word 0xda9c2000  ! 4890: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	.word 0xdaf4a000  ! 4891: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0xdab42000  ! 4892: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0x87802074  ! 4894: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2dfce60  ! 4895: LDXA_R	ldxa	[%r31, %r0] 0x73, %r9
	.word 0x8780204f  ! 4896: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f62000  ! 4897: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	.word 0xd2aea000  ! 4898: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 4899: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r16
	mov	0x3f8, %r21
	.word 0xd8f48400  ! 4902: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0x87802074  ! 4903: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8a7e000  ! 4904: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd4ae49e0  ! 4905: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0xd4976000  ! 4906: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r10
	.word 0xd0ccc400  ! 4907: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	.word 0x8780204f  ! 4908: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd29fce60  ! 4909: LDDA_R	ldda	[%r31, %r0] 0x73, %r9
	.word 0xd4af4e60  ! 4910: STBA_R	stba	%r10, [%r29 + %r0] 0x73
	.word 0x87802072  ! 4911: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 4912: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4c5a000  ! 4913: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r10
	mov	0x7f0, %r20
	.word 0xd2cc8400  ! 4915: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0xd49c8400  ! 4916: LDDA_R	ldda	[%r18, %r0] 0x20, %r10
	.word 0x87802020  ! 4917: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4942000  ! 4918: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r10
	.word 0xde874e80  ! 4919: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r15
	mov	0x40, %r25
	.word 0xded42000  ! 4921: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	.word 0xd4dfce60  ! 4922: LDXA_R	ldxa	[%r31, %r0] 0x73, %r10
	.word 0xd4d4e000  ! 4923: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0xd484e000  ! 4924: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r10
	.word 0xdcbf4e40  ! 4925: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	mov	0x3c8, %r21
	mov	0x48, %r16
	mov	0x0, %r17
	mov	0x3c8, %r21
	wr_tick_cmpr_0_51:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x8b, %g2
	or	%g4, 0xf6, %g4
	or	%g6, 0xce, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	wr_tick_cmpr_0_52:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xaf, %g2
	or	%g4, 0xb4, %g4
	or	%g6, 0xc8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7d0, %r21
	.word 0xdcb4a000  ! 4933: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xdc94e000  ! 4934: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	mov	0x0, %r27
	.word 0xdcf4e000  ! 4936: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcf4e000  ! 4937: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcf42000  ! 4938: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xd8df0e80  ! 4940: LDXA_R	ldxa	[%r28, %r0] 0x74, %r12
	.word 0xd8bce000  ! 4941: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 4942: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4943: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd89c0400  ! 4944: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	mov	0x30, %r18
	.word 0xd8b7e000  ! 4946: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 4947: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f584a0  ! 4948: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	mov	0x3e0, %r21
	mov	0x70, %r24
	.word 0xd0c42000  ! 4951: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r8
	.word 0xd0dc6000  ! 4952: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	mov	0x7c8, %r21
	mov	0x38, %r18
	.word 0xd4c544a0  ! 4955: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r10
	.word 0x87802072  ! 4956: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4dfe000  ! 4957: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4c7a000  ! 4958: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	mov	0x28, %r18
	.word 0xdcdf4e40  ! 4960: LDXA_R	ldxa	[%r29, %r0] 0x72, %r14
	.word 0x87802020  ! 4961: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdec4c400  ! 4962: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	.word 0xd4ad44a0  ! 4963: STBA_R	stba	%r10, [%r21 + %r0] 0x25
	mov	0x3e0, %r20
	.word 0x87802020  ! 4965: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a46000  ! 4966: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xd0848400  ! 4967: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r8
	mov	0x70, %r17
	.word 0xd0b4e000  ! 4969: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xd0d42000  ! 4970: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r8
	.word 0x87802020  ! 4971: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ccc400  ! 4972: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0xd4d4a000  ! 4973: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0xd0be09e0  ! 4974: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0xd0a42000  ! 4975: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 4976: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf584a0  ! 4977: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	.word 0xdaafe000  ! 4978: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xdabfe000  ! 4979: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xdaaf2000  ! 4980: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0xdcb609e0  ! 4982: STHA_R	stha	%r14, [%r24 + %r0] 0x4f
	.word 0xdcaf6000  ! 4983: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdca7ce80  ! 4984: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	.word 0xdecfce40  ! 4985: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r15
	.word 0xdaaf8e80  ! 4986: STBA_R	stba	%r13, [%r30 + %r0] 0x74
	.word 0xdabfa000  ! 4987: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	mov	0x58, %r18
	mov	0x40, %r25
	.word 0x87802074  ! 4990: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r16
	.word 0xda9fa000  ! 4992: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xdab7a000  ! 4993: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 4994: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9ce000  ! 4995: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r13
	mov	0x8, %r27
	.word 0x8780204f  ! 4997: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0874e80  ! 4998: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r8
	mov	0x50, %r16
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_3:
	wr_tick_cmpr_3_0:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe6, %g2
	or	%g4, 0xf4, %g4
	or	%g6, 0xa6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdacfe000  ! 1: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0xdacd44a0  ! 2: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r13
	mov	0x50, %r26
	.word 0xd0b76000  ! 4: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 5: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd89504a0  ! 6: LDUHA_R	lduha	[%r20, %r0] 0x25, %r12
	.word 0x87802020  ! 7: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 8: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r17
	.word 0xd4f42000  ! 10: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd49c6000  ! 11: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0xd494e000  ! 12: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	.word 0xd4bca000  ! 13: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	mov	0x38, %r17
	.word 0xd4cce000  ! 15: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	.word 0xd28d04a0  ! 16: LDUBA_R	lduba	[%r20, %r0] 0x25, %r9
	.word 0xd2b70e40  ! 17: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	.word 0xd8842000  ! 18: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	.word 0xd89e89e0  ! 19: LDDA_R	ldda	[%r26, %r0] 0x4f, %r12
	.word 0xdcce49e0  ! 20: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r14
	.word 0xd6b4a000  ! 21: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xdac7ce60  ! 22: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r13
	mov	0x50, %r18
	mov	0x68, %r19
	.word 0xdcf7ce80  ! 25: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	mov	0x3c0, %r23
	.word 0xd8b584a0  ! 27: STHA_R	stha	%r12, [%r22 + %r0] 0x25
	.word 0xd6f42000  ! 28: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	.word 0xdcac4400  ! 29: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	mov	0x68, %r16
	.word 0xdad4a000  ! 31: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	mov	0x10, %r25
	.word 0xdabca000  ! 33: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdaf4e000  ! 34: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	mov	0x10, %r17
	.word 0xd2a4c400  ! 36: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0xd2a42000  ! 37: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	mov	0x28, %r16
	.word 0xd2b4e000  ! 39: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0xdcc78e40  ! 40: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r14
	.word 0xd4bce000  ! 41: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0xd4b46000  ! 42: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	mov	0x3e0, %r20
	mov	0x48, %r16
	.word 0xd4a4a000  ! 45: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 46: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0d70e40  ! 47: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r8
	.word 0xd0944400  ! 48: LDUHA_R	lduha	[%r17, %r0] 0x20, %r8
	.word 0xd0b7ce80  ! 49: STHA_R	stha	%r8, [%r31 + %r0] 0x74
	.word 0xd2af4e60  ! 50: STBA_R	stba	%r9, [%r29 + %r0] 0x73
	mov	0x38, %r24
	.word 0xd0f544a0  ! 52: STXA_R	stxa	%r8, [%r21 + %r0] 0x25
	.word 0xdadc0400  ! 53: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	mov	0x48, %r17
	.word 0xdaa5a000  ! 55: STWA_I	stwa	%r13, [%r22 + 0x0000] %asi
	.word 0xdaf52000  ! 56: STXA_I	stxa	%r13, [%r20 + 0x0000] %asi
	.word 0xdabda000  ! 57: STDA_I	stda	%r13, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 58: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadfa000  ! 59: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xdab7a000  ! 60: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdc940400  ! 61: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0xdea40400  ! 62: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xd8f6c9e0  ! 63: STXA_R	stxa	%r12, [%r27 + %r0] 0x4f
	.word 0xd6df6000  ! 64: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6af6000  ! 65: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x3f0, %r21
	mov	0x7e0, %r22
	.word 0xd0f78e40  ! 68: STXA_R	stxa	%r8, [%r30 + %r0] 0x72
	mov	0x3c8, %r22
	.word 0xd8972000  ! 70: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	mov	0x3c0, %r23
	.word 0xd8f72000  ! 72: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8cfa000  ! 73: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd89f2000  ! 74: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	mov	0x3e0, %r21
	.word 0x87802020  ! 76: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r24
	.word 0xd8d52000  ! 78: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r12
	.word 0xde8d44a0  ! 79: LDUBA_R	lduba	[%r21, %r0] 0x25, %r15
	mov	0x0, %r17
	.word 0x87802074  ! 81: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r24
	.word 0xd4bee000  ! 83: STDA_I	stda	%r10, [%r27 + 0x0000] %asi
	.word 0x87802072  ! 84: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r16
	mov	0x48, %r19
	.word 0xd4a40400  ! 87: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	.word 0xd6f4c400  ! 88: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 89: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a70e40  ! 90: STWA_R	stwa	%r12, [%r28 + %r0] 0x72
	.word 0xd49d44a0  ! 91: LDDA_R	ldda	[%r21, %r0] 0x25, %r10
	mov	0x28, %r17
	.word 0xd6cf6000  ! 93: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	wr_tick_cmpr_3_1:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xa3, %g2
	or	%g4, 0xa0, %g4
	or	%g6, 0xfe, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 95: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f46000  ! 96: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0xd6cc6000  ! 97: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r11
	.word 0xd2dc4400  ! 98: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xd2a44400  ! 99: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	mov	0x7f8, %r22
	.word 0xde94a000  ! 101: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0xdeaca000  ! 102: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xdaf48400  ! 103: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	mov	0x3e0, %r21
	.word 0xde840400  ! 105: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	.word 0xd0aca000  ! 106: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 107: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r25
	.word 0x87802074  ! 109: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeb78e60  ! 110: STHA_R	stha	%r15, [%r30 + %r0] 0x73
	.word 0xdef40400  ! 111: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0xdac7ce40  ! 112: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r13
	.word 0xd0cf4e60  ! 113: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r8
	.word 0x87802020  ! 114: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 115: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde8fe000  ! 116: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	mov	0x10, %r17
	.word 0xdcb7ce40  ! 118: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	mov	0x3e0, %r23
	mov	0x58, %r16
	.word 0xd48fe000  ! 121: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xdad4c400  ! 122: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xd2cfe000  ! 123: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	mov	0x20, %r18
	.word 0xd8dd04a0  ! 125: LDXA_R	ldxa	[%r20, %r0] 0x25, %r12
	.word 0xdcb584a0  ! 126: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	.word 0xd4f72000  ! 127: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4b7e000  ! 128: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd4b7a000  ! 130: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd2bfce40  ! 131: STDA_R	stda	%r9, [%r31 + %r0] 0x72
	.word 0xd4cc8400  ! 132: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	.word 0x87802020  ! 133: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88649e0  ! 134: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r12
	.word 0xd2f7a000  ! 135: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xd6f40400  ! 136: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	.word 0xd6bf8e40  ! 137: STDA_R	stda	%r11, [%r30 + %r0] 0x72
	mov	0x7c0, %r20
	.word 0xd8c7a000  ! 139: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8a76000  ! 140: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 141: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8afa000  ! 142: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xd8af2000  ! 143: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xdc8f8e60  ! 145: LDUBA_R	lduba	[%r30, %r0] 0x73, %r14
	.word 0xdabf8e60  ! 146: STDA_R	stda	%r13, [%r30 + %r0] 0x73
	.word 0xd2a78e60  ! 147: STWA_R	stwa	%r9, [%r30 + %r0] 0x73
	.word 0xd8974e60  ! 148: LDUHA_R	lduha	[%r29, %r0] 0x73, %r12
	.word 0x8780204f  ! 149: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 150: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b72000  ! 151: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 152: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bda000  ! 153: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 154: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 155: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f42000  ! 156: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0xd08f4e40  ! 157: LDUBA_R	lduba	[%r29, %r0] 0x72, %r8
	.word 0xd2cce000  ! 158: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	.word 0xd0b40400  ! 159: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	mov	0x50, %r25
	mov	0x7f8, %r20
	.word 0xdcae89e0  ! 162: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	.word 0xda9f8e80  ! 163: LDDA_R	ldda	[%r30, %r0] 0x74, %r13
	.word 0x87802073  ! 164: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 165: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 166: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a7a000  ! 167: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	mov	0x0, %r17
	mov	0x38, %r25
	mov	0x0, %r17
	.word 0x87802074  ! 171: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r19
	mov	0x78, %r18
	.word 0xd0b4c400  ! 174: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0xd0878e80  ! 175: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r8
	.word 0xd0cd2000  ! 176: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r8
	.word 0xd0bd6000  ! 177: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 178: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b7e000  ! 179: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	mov	0x20, %r27
	.word 0x87802025  ! 181: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeafce40  ! 182: STBA_R	stba	%r15, [%r31 + %r0] 0x72
	.word 0xdcbf8e60  ! 183: STDA_R	stda	%r14, [%r30 + %r0] 0x73
	.word 0x87802020  ! 184: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r19
	.word 0x87802073  ! 186: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4de2000  ! 187: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r10
	.word 0xd4d66000  ! 188: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r10
	.word 0xdec78e40  ! 189: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r15
	mov	0x3c0, %r21
	.word 0x8780204f  ! 191: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f76000  ! 192: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 193: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r21
	.word 0xd4b7ce40  ! 195: STHA_R	stha	%r10, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 196: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4dc4400  ! 197: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	.word 0xdef62000  ! 198: STXA_I	stxa	%r15, [%r24 + 0x0000] %asi
	.word 0xd6ddc4a0  ! 199: LDXA_R	ldxa	[%r23, %r0] 0x25, %r11
	.word 0xd8ce09e0  ! 200: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r12
	.word 0xd2c70e60  ! 201: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r9
	.word 0xdc8ee000  ! 202: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r14
	.word 0x87802074  ! 203: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcdf2000  ! 204: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdc876000  ! 205: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0x87802074  ! 206: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r19
	.word 0xd8f7ce60  ! 208: STXA_R	stxa	%r12, [%r31 + %r0] 0x73
	.word 0xded649e0  ! 209: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r15
	.word 0x87802074  ! 210: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaaf0e80  ! 211: STBA_R	stba	%r13, [%r28 + %r0] 0x74
	.word 0xd48504a0  ! 212: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r10
	.word 0xded649e0  ! 213: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r15
	.word 0x8780204f  ! 214: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdec7ce40  ! 215: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r15
	.word 0x87802020  ! 216: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c6a000  ! 217: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r12
	.word 0xdab6c9e0  ! 218: STHA_R	stha	%r13, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 219: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 220: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdad42000  ! 221: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 222: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r16
	.word 0xdac76000  ! 224: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0xdacec9e0  ! 225: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r13
	.word 0xd8f70e80  ! 226: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	.word 0xd4f7e000  ! 227: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	mov	0x3e0, %r23
	.word 0xdedcc400  ! 229: LDXA_R	ldxa	[%r19, %r0] 0x20, %r15
	.word 0xd4bf4e40  ! 230: STDA_R	stda	%r10, [%r29 + %r0] 0x72
	.word 0xd4df2000  ! 231: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0xd6948400  ! 232: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	.word 0xd2b7e000  ! 233: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 234: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r27
	.word 0xdadf8e80  ! 236: LDXA_R	ldxa	[%r30, %r0] 0x74, %r13
	.word 0xd4d70e40  ! 237: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r10
	.word 0xdc9fe000  ! 238: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0x87802020  ! 239: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r24
	mov	0x3f8, %r21
	mov	0x3d8, %r22
	.word 0xdccfe000  ! 243: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xdcf72000  ! 244: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xd295c4a0  ! 245: LDUHA_R	lduha	[%r23, %r0] 0x25, %r9
	.word 0xd887e000  ! 246: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	mov	0x40, %r18
	.word 0xd8d76000  ! 248: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xd8dfa000  ! 249: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	mov	0x3d8, %r20
	.word 0x8780204f  ! 251: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 252: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8ae6000  ! 253: STBA_I	stba	%r12, [%r25 + 0x0000] %asi
	.word 0xd8dee000  ! 254: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r12
	mov	0x68, %r16
	.word 0xd6a504a0  ! 256: STWA_R	stwa	%r11, [%r20 + %r0] 0x25
	.word 0xd0bec9e0  ! 257: STDA_R	stda	%r8, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 258: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6acc400  ! 259: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	mov	0x3c0, %r22
	.word 0xdcbf2000  ! 261: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xd4f7ce40  ! 262: STXA_R	stxa	%r10, [%r31 + %r0] 0x72
	.word 0xdccf6000  ! 263: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdedf0e60  ! 264: LDXA_R	ldxa	[%r28, %r0] 0x73, %r15
	mov	0x10, %r24
	.word 0x87802073  ! 266: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e8, %r22
	mov	0x20, %r17
	.word 0xd6cca000  ! 269: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r11
	.word 0xdebd84a0  ! 270: STDA_R	stda	%r15, [%r22 + %r0] 0x25
	.word 0x87802025  ! 271: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f78e80  ! 272: STXA_R	stxa	%r11, [%r30 + %r0] 0x74
	mov	0x78, %r18
	.word 0x8780204f  ! 274: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 275: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69f2000  ! 276: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xd6af6000  ! 277: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x20, %r27
	.word 0xd6df8e40  ! 279: LDXA_R	ldxa	[%r30, %r0] 0x72, %r11
	.word 0xd8ccc400  ! 280: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r12
	.word 0xd68fa000  ! 281: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0xd69f4e80  ! 282: LDDA_R	ldda	[%r29, %r0] 0x74, %r11
	.word 0xd8df6000  ! 283: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0x87802073  ! 284: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8a7e000  ! 285: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8df6000  ! 286: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8d76000  ! 287: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	mov	0x3d0, %r21
	wr_tick_cmpr_3_2:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x97, %g2
	or	%g4, 0x9a, %g4
	or	%g6, 0xe5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8b72000  ! 290: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 291: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8de6000  ! 292: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r12
	.word 0x87802072  ! 293: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8d7ce80  ! 294: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r12
	.word 0x87802072  ! 295: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbe89e0  ! 296: STDA_R	stda	%r14, [%r26 + %r0] 0x4f
	.word 0xd4b584a0  ! 297: STHA_R	stha	%r10, [%r22 + %r0] 0x25
	.word 0xd0b74e40  ! 298: STHA_R	stha	%r8, [%r29 + %r0] 0x72
	.word 0xdeb74e60  ! 299: STHA_R	stha	%r15, [%r29 + %r0] 0x73
	.word 0x87802020  ! 300: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb649e0  ! 301: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	.word 0xd4b7a000  ! 302: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd4cf6000  ! 303: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0xd4972000  ! 304: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0xd4a4c400  ! 305: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	mov	0x78, %r17
	.word 0xd6a7e000  ! 307: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	mov	0x58, %r26
	.word 0xd4948400  ! 309: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	.word 0xd68689e0  ! 310: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r11
	.word 0x87802073  ! 311: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 312: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8f44400  ! 313: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xdad7a000  ! 314: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0xda872000  ! 315: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0xd6b504a0  ! 316: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	.word 0x87802073  ! 317: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdadf4e80  ! 318: LDXA_R	ldxa	[%r29, %r0] 0x74, %r13
	.word 0x8780204f  ! 319: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r16
	.word 0xdac40400  ! 321: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	.word 0xdea7a000  ! 322: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 323: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde94a000  ! 324: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	mov	0x3f8, %r21
	mov	0x20, %r17
	mov	0x40, %r26
	mov	0x7c0, %r20
	.word 0xdccf0e40  ! 329: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r14
	.word 0x87802072  ! 330: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd09da000  ! 331: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r8
	.word 0xd8b78e60  ! 332: STHA_R	stha	%r12, [%r30 + %r0] 0x73
	.word 0xd6b56000  ! 333: STHA_I	stha	%r11, [%r21 + 0x0000] %asi
	.word 0x87802072  ! 334: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6c4a000  ! 335: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r11
	.word 0xdcf4c400  ! 336: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0x87802072  ! 337: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8af2000  ! 338: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xd8b7e000  ! 339: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	mov	0x7c8, %r22
	.word 0x87802072  ! 341: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r25
	mov	0x7c0, %r21
	.word 0xd8dca000  ! 344: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	.word 0xd2dc4400  ! 345: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xd8aca000  ! 346: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xdc8c8400  ! 348: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0xd6a4e000  ! 349: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0xd6bca000  ! 350: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	.word 0xd6bf8e60  ! 351: STDA_R	stda	%r11, [%r30 + %r0] 0x73
	.word 0x8780204f  ! 352: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa7a000  ! 353: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	mov	0x7c0, %r20
	.word 0x87802072  ! 355: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r26
	.word 0xdabf4e60  ! 357: STDA_R	stda	%r13, [%r29 + %r0] 0x73
	.word 0xd0ddc4a0  ! 358: LDXA_R	ldxa	[%r23, %r0] 0x25, %r8
	.word 0x87802020  ! 359: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r27
	mov	0x78, %r17
	mov	0x7d0, %r23
	.word 0xdeb7ce60  ! 363: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	.word 0xda9ca000  ! 364: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	mov	0x7c8, %r21
	mov	0x7f0, %r23
	.word 0x87802025  ! 367: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b70e60  ! 368: STHA_R	stha	%r11, [%r28 + %r0] 0x73
	.word 0xdaadc4a0  ! 369: STBA_R	stba	%r13, [%r23 + %r0] 0x25
	.word 0xdabe49e0  ! 370: STDA_R	stda	%r13, [%r25 + %r0] 0x4f
	.word 0xd6bf0e80  ! 371: STDA_R	stda	%r11, [%r28 + %r0] 0x74
	mov	0x7e0, %r22
	.word 0xd6a5a000  ! 373: STWA_I	stwa	%r11, [%r22 + 0x0000] %asi
	.word 0xd0cec9e0  ! 374: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r8
	.word 0xdedf0e80  ! 375: LDXA_R	ldxa	[%r28, %r0] 0x74, %r15
	.word 0xd8cc4400  ! 376: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r12
	.word 0xd2cde000  ! 377: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r9
	mov	0x40, %r25
	.word 0xd2ade000  ! 379: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	mov	0x48, %r25
	.word 0xde8c4400  ! 381: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	.word 0xd49cc400  ! 382: LDDA_R	ldda	[%r19, %r0] 0x20, %r10
	mov	0x10, %r19
	ta	T_CHANGE_NONPRIV	! macro
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdaf5a000  ! 386: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xdadde000  ! 387: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r13
	.word 0x87802073  ! 388: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8874e60  ! 389: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r12
	.word 0x87802025  ! 390: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2dfa000  ! 391: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2bfe000  ! 392: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	mov	0x38, %r17
	.word 0xd2cfa000  ! 394: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	wr_tick_cmpr_3_3:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf8, %g2
	or	%g4, 0xba, %g4
	or	%g6, 0xad, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802025  ! 396: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2f7e000  ! 397: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd4840400  ! 398: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	mov	0x38, %r24
	mov	0x0, %r19
	.word 0xd6af2000  ! 401: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd08d04a0  ! 402: LDUBA_R	lduba	[%r20, %r0] 0x25, %r8
	.word 0xd8f40400  ! 403: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	mov	0x7e8, %r23
	.word 0xdebf6000  ! 405: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xd0870e80  ! 406: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r8
	mov	0x7c8, %r21
	mov	0x3e0, %r20
	.word 0xdc976000  ! 409: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	.word 0xd695c4a0  ! 410: LDUHA_R	lduha	[%r23, %r0] 0x25, %r11
	.word 0x87802025  ! 411: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbfce60  ! 412: STDA_R	stda	%r14, [%r31 + %r0] 0x73
	.word 0xd09f8e60  ! 413: LDDA_R	ldda	[%r30, %r0] 0x73, %r8
	mov	0x10, %r17
	mov	0x18, %r27
	mov	0x7c8, %r23
	mov	0x68, %r18
	.word 0x87802074  ! 418: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 419: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca7ce40  ! 420: STWA_R	stwa	%r14, [%r31 + %r0] 0x72
	.word 0x87802073  ! 421: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4c4e000  ! 422: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r10
	.word 0xdabc4400  ! 423: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xd4cf8e80  ! 424: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r10
	.word 0xd4a4a000  ! 425: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xd8a7ce80  ! 426: STWA_R	stwa	%r12, [%r31 + %r0] 0x74
	.word 0x87802072  ! 427: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c0, %r20
	.word 0xdcf70e80  ! 429: STXA_R	stxa	%r14, [%r28 + %r0] 0x74
	.word 0xd8af6000  ! 430: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 431: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r19
	.word 0x87802073  ! 433: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r17
	.word 0xd8ad2000  ! 435: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 436: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r17
	.word 0xd8b76000  ! 438: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	mov	0x20, %r25
	.word 0xd8976000  ! 440: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0xd4dcc400  ! 441: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0x87802025  ! 442: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbd2000  ! 443: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	.word 0xdc8d2000  ! 444: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r14
	.word 0xdeaf0e60  ! 445: STBA_R	stba	%r15, [%r28 + %r0] 0x73
	.word 0xd88da000  ! 446: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r12
	.word 0xd8cd2000  ! 447: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r12
	mov	0x7c8, %r21
	.word 0xdabd44a0  ! 449: STDA_R	stda	%r13, [%r21 + %r0] 0x25
	.word 0xd8a649e0  ! 450: STWA_R	stwa	%r12, [%r25 + %r0] 0x4f
	.word 0xd0f609e0  ! 451: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	mov	0x3c8, %r23
	.word 0x87802074  ! 453: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabf6000  ! 454: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xd88c8400  ! 455: LDUBA_R	lduba	[%r18, %r0] 0x20, %r12
	.word 0xd6d78e60  ! 456: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r11
	.word 0xd6b72000  ! 457: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd8b48400  ! 458: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0xd8cf0e60  ! 459: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r12
	.word 0xd09f4e40  ! 460: LDDA_R	ldda	[%r29, %r0] 0x72, %r8
	mov	0x20, %r26
	.word 0xd4f7e000  ! 462: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 463: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a7a000  ! 464: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4a7e000  ! 465: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd49f6000  ! 466: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0xd4a7e000  ! 467: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4d7e000  ! 468: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	.word 0xda9e09e0  ! 469: LDDA_R	ldda	[%r24, %r0] 0x4f, %r13
	.word 0x87802020  ! 470: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48fce40  ! 471: LDUBA_R	lduba	[%r31, %r0] 0x72, %r10
	.word 0xd6a76000  ! 472: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6cd44a0  ! 473: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r11
	mov	0x20, %r27
	.word 0xd2bf6000  ! 475: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd28fe000  ! 477: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	.word 0xd0870e60  ! 478: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r8
	.word 0xda872000  ! 479: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	mov	0x70, %r16
	.word 0xd8b609e0  ! 481: STHA_R	stha	%r12, [%r24 + %r0] 0x4f
	.word 0xdadfa000  ! 482: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	mov	0x78, %r24
	.word 0xda87e000  ! 484: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0xdea70e60  ! 485: STWA_R	stwa	%r15, [%r28 + %r0] 0x73
	mov	0x68, %r16
	.word 0xd8c76000  ! 487: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	.word 0xd6ad84a0  ! 488: STBA_R	stba	%r11, [%r22 + %r0] 0x25
	.word 0xdcf78e40  ! 489: STXA_R	stxa	%r14, [%r30 + %r0] 0x72
	.word 0xd8a76000  ! 490: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 491: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 492: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r17
	.word 0xd8bfa000  ! 494: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd8c72000  ! 495: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xdec609e0  ! 496: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r15
	.word 0xdea7a000  ! 497: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xdedfe000  ! 498: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xd8c40400  ! 499: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	.word 0xd29fa000  ! 500: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd2df2000  ! 501: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0x87802020  ! 502: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r24
	.word 0xd2ad2000  ! 504: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xdeddc4a0  ! 505: LDXA_R	ldxa	[%r23, %r0] 0x25, %r15
	.word 0xd8a52000  ! 506: STWA_I	stwa	%r12, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 507: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 508: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8a46000  ! 509: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 510: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeb4c400  ! 511: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xd0d4a000  ! 512: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	.word 0xd0d4e000  ! 513: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	.word 0xd09c2000  ! 514: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r8
	.word 0x87802074  ! 515: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f4e000  ! 516: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0d4e000  ! 517: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	.word 0xd48fce60  ! 518: LDUBA_R	lduba	[%r31, %r0] 0x73, %r10
	mov	0x7d0, %r20
	.word 0xd89c8400  ! 520: LDDA_R	ldda	[%r18, %r0] 0x20, %r12
	mov	0x8, %r16
	.word 0xdc87ce80  ! 522: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r14
	.word 0x87802020  ! 523: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde87a000  ! 524: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	mov	0x3c8, %r23
	.word 0xdea72000  ! 526: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xd0b70e60  ! 527: STHA_R	stha	%r8, [%r28 + %r0] 0x73
	.word 0xd8f544a0  ! 528: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	.word 0x87802073  ! 529: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2a649e0  ! 530: STWA_R	stwa	%r9, [%r25 + %r0] 0x4f
	.word 0xd0874e80  ! 531: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r8
	.word 0xda972000  ! 532: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0xda87a000  ! 533: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0xd69649e0  ! 534: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r11
	mov	0x38, %r16
	.word 0xd8be49e0  ! 536: STDA_R	stda	%r12, [%r25 + %r0] 0x4f
	.word 0xdeb7e000  ! 537: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	mov	0x7e0, %r22
	mov	0x48, %r17
	.word 0xd6c74e40  ! 540: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r11
	.word 0xdcc44400  ! 541: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	mov	0x50, %r27
	.word 0xd6c7a000  ! 543: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	.word 0xd8bd84a0  ! 544: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	.word 0x87802074  ! 545: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 546: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 547: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r26
	mov	0x58, %r19
	.word 0xdad52000  ! 550: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r13
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8d4c400  ! 552: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	mov	0x3c8, %r20
	wr_tick_cmpr_3_4:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x89, %g2
	or	%g4, 0xd7, %g4
	or	%g6, 0xc9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 555: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r24
	.word 0xd4956000  ! 557: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r10
	.word 0x87802072  ! 558: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r16
	.word 0xd0a70e40  ! 560: STWA_R	stwa	%r8, [%r28 + %r0] 0x72
	.word 0xdc87a000  ! 561: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcd78e40  ! 562: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r14
	.word 0xd0d78e40  ! 563: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r8
	mov	0x10, %r24
	.word 0xd6b76000  ! 565: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	mov	0x3f8, %r23
	.word 0xd6cfce40  ! 567: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r11
	.word 0xd2f6c9e0  ! 568: STXA_R	stxa	%r9, [%r27 + %r0] 0x4f
	.word 0xded44400  ! 569: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	mov	0x3c0, %r20
	.word 0x8780204f  ! 571: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d8, %r20
	.word 0xdabe49e0  ! 573: STDA_R	stda	%r13, [%r25 + %r0] 0x4f
	mov	0x8, %r19
	.word 0x8780204f  ! 575: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcace000  ! 576: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 577: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 578: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8df8e40  ! 579: LDXA_R	ldxa	[%r30, %r0] 0x72, %r12
	.word 0xd2c504a0  ! 580: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r9
	.word 0x8780204f  ! 581: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd284e000  ! 582: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r9
	.word 0xd2cca000  ! 583: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	.word 0x87802073  ! 584: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 585: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2df2000  ! 586: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd6bcc400  ! 587: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0xd0afce80  ! 588: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	.word 0xd8f44400  ! 589: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xdabfa000  ! 590: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xda8f2000  ! 591: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xd0c78e60  ! 592: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r8
	.word 0x87802072  ! 593: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebe89e0  ! 594: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	.word 0xd6c7e000  ! 595: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xdcb40400  ! 596: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xd29f6000  ! 597: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xd2bf4e80  ! 598: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	mov	0x3f0, %r21
	.word 0xd0af2000  ! 600: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	mov	0x10, %r24
	.word 0xd0f76000  ! 602: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0d76000  ! 603: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xd8b4c400  ! 604: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	mov	0x7d8, %r20
	.word 0x8780204f  ! 606: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r19
	.word 0xd69f0e40  ! 608: LDDA_R	ldda	[%r28, %r0] 0x72, %r11
	.word 0x87802074  ! 609: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2a6a000  ! 610: STWA_I	stwa	%r9, [%r26 + 0x0000] %asi
	mov	0x60, %r24
	.word 0xdeaf4e40  ! 612: STBA_R	stba	%r15, [%r29 + %r0] 0x72
	.word 0xd2a7ce80  ! 613: STWA_R	stwa	%r9, [%r31 + %r0] 0x74
	.word 0xd88e6000  ! 614: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r12
	.word 0xd8be2000  ! 615: STDA_I	stda	%r12, [%r24 + 0x0000] %asi
	.word 0xd2d4c400  ! 616: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r9
	.word 0x87802020  ! 617: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc970e40  ! 618: LDUHA_R	lduha	[%r28, %r0] 0x72, %r14
	mov	0x40, %r16
	.word 0x87802025  ! 620: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdadd04a0  ! 621: LDXA_R	ldxa	[%r20, %r0] 0x25, %r13
	.word 0xd4a62000  ! 622: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 623: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bf2000  ! 624: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd8ae49e0  ! 625: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0xd8c7e000  ! 626: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	mov	0x3e8, %r22
	mov	0x0, %r18
	mov	0x58, %r17
	.word 0xd2a649e0  ! 630: STWA_R	stwa	%r9, [%r25 + %r0] 0x4f
	mov	0x48, %r27
	mov	0x3c0, %r22
	mov	0x7f8, %r23
	.word 0x87802025  ! 634: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r26
	mov	0x48, %r16
	.word 0xdccf4e60  ! 637: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r14
	mov	0x3d0, %r21
	.word 0x87802025  ! 639: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdef74e60  ! 640: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	.word 0xdcae49e0  ! 641: STBA_R	stba	%r14, [%r25 + %r0] 0x4f
	.word 0xd6f46000  ! 642: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0xd6f42000  ! 643: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 644: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6dce000  ! 645: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0xd69ce000  ! 646: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r11
	.word 0x87802020  ! 647: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b7ce60  ! 648: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	mov	0x0, %r16
	.word 0xd0bcc400  ! 650: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0xd8f78e80  ! 651: STXA_R	stxa	%r12, [%r30 + %r0] 0x74
	.word 0xda9ca000  ! 652: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	mov	0x20, %r16
	.word 0xda9ca000  ! 654: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	.word 0xda9ce000  ! 655: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r13
	.word 0xda946000  ! 656: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	mov	0x7c0, %r23
	.word 0x87802073  ! 658: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdad7e000  ! 659: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xd8b544a0  ! 660: STHA_R	stha	%r12, [%r21 + %r0] 0x25
	.word 0xdcf6c9e0  ! 661: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	.word 0xd4bfce80  ! 662: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	.word 0xdca48400  ! 663: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	mov	0x0, %r25
	.word 0x87802074  ! 665: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6956000  ! 666: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r11
	.word 0xd6f56000  ! 667: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 668: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ce49e0  ! 669: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r10
	.word 0xd4c66000  ! 670: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r10
	.word 0xd087ce80  ! 671: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r8
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0ce2000  ! 673: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r8
	.word 0xd4b78e60  ! 674: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	.word 0x87802020  ! 675: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r23
	.word 0xd2b46000  ! 677: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0xd6df4e80  ! 678: LDXA_R	ldxa	[%r29, %r0] 0x74, %r11
	.word 0xdca584a0  ! 679: STWA_R	stwa	%r14, [%r22 + %r0] 0x25
	.word 0x87802020  ! 680: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r21
	.word 0x87802072  ! 682: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r27
	mov	0x60, %r16
	mov	0x10, %r27
	.word 0xdef7e000  ! 686: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xdc86c9e0  ! 687: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r14
	.word 0xdebf2000  ! 688: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0xd49dc4a0  ! 690: LDDA_R	ldda	[%r23, %r0] 0x25, %r10
	.word 0xd0cfce80  ! 691: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r8
	.word 0x87802073  ! 692: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r26
	.word 0xdec78e60  ! 694: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r15
	.word 0xd6bf2000  ! 695: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd6972000  ! 696: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	.word 0x87802074  ! 697: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6846000  ! 698: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r11
	.word 0x87802020  ! 699: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88f8e40  ! 700: LDUBA_R	lduba	[%r30, %r0] 0x72, %r12
	mov	0x7d8, %r21
	.word 0xd4b56000  ! 702: STHA_I	stha	%r10, [%r21 + 0x0000] %asi
	mov	0x20, %r17
	.word 0xd6bd04a0  ! 704: STDA_R	stda	%r11, [%r20 + %r0] 0x25
	mov	0x20, %r24
	.word 0xd88c8400  ! 706: LDUBA_R	lduba	[%r18, %r0] 0x20, %r12
	mov	0x20, %r17
	.word 0xd09fce80  ! 708: LDDA_R	ldda	[%r31, %r0] 0x74, %r8
	.word 0x87802020  ! 709: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r20
	.word 0x87802072  ! 711: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdad5e000  ! 712: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r13
	.word 0xda8d6000  ! 713: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r13
	.word 0xda85e000  ! 714: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	.word 0xdab56000  ! 715: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	.word 0xda952000  ! 716: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r13
	.word 0xd8bc8400  ! 717: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	mov	0x38, %r16
	mov	0x7f8, %r21
	.word 0xd49c0400  ! 720: LDDA_R	ldda	[%r16, %r0] 0x20, %r10
	mov	0x7f0, %r21
	.word 0xd2f74e40  ! 722: STXA_R	stxa	%r9, [%r29 + %r0] 0x72
	mov	0x60, %r25
	.word 0x87802073  ! 724: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r26
	mov	0x50, %r19
	mov	0x10, %r16
	.word 0xd0bf0e40  ! 728: STDA_R	stda	%r8, [%r28 + %r0] 0x72
	.word 0x87802073  ! 729: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b72000  ! 730: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xdaa74e40  ! 731: STWA_R	stwa	%r13, [%r29 + %r0] 0x72
	.word 0xd097e000  ! 732: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0a7a000  ! 733: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0a72000  ! 734: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x70, %r18
	.word 0xdeddc4a0  ! 736: LDXA_R	ldxa	[%r23, %r0] 0x25, %r15
	.word 0x87802073  ! 737: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c8, %r21
	mov	0x40, %r17
	.word 0xd2b48400  ! 740: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xdc874e60  ! 741: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r14
	.word 0xd6d42000  ! 742: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r11
	.word 0xd09fce60  ! 743: LDDA_R	ldda	[%r31, %r0] 0x73, %r8
	.word 0x87802020  ! 744: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 745: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r25
	.word 0x87802020  ! 747: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r23
	mov	0x58, %r24
	.word 0xd6f7e000  ! 750: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 751: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 752: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6a6a000  ! 753: STWA_I	stwa	%r11, [%r26 + 0x0000] %asi
	.word 0xd6cea000  ! 754: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	.word 0xd6b62000  ! 755: STHA_I	stha	%r11, [%r24 + 0x0000] %asi
	mov	0x28, %r24
	.word 0x87802020  ! 757: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a76000  ! 758: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6bc4400  ! 759: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	mov	0x28, %r24
	.word 0xdaafe000  ! 761: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xd2844400  ! 762: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	.word 0x87802073  ! 763: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf46000  ! 764: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	mov	0x7c8, %r23
	.word 0xdcbc8400  ! 766: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0x87802020  ! 767: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b7a000  ! 768: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd0d7a000  ! 769: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0xd0c72000  ! 770: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xd8bf8e80  ! 771: STDA_R	stda	%r12, [%r30 + %r0] 0x74
	.word 0xdebf2000  ! 772: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 773: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdecce000  ! 774: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	.word 0xdab70e40  ! 775: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	mov	0x38, %r27
	.word 0x87802074  ! 777: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd49fe000  ! 778: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd6ddc4a0  ! 779: LDXA_R	ldxa	[%r23, %r0] 0x25, %r11
	.word 0xd2bf2000  ! 780: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 781: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2ada000  ! 782: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xd6bf8e80  ! 783: STDA_R	stda	%r11, [%r30 + %r0] 0x74
	.word 0xdeb7ce60  ! 784: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	.word 0xd0dd6000  ! 785: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r8
	.word 0x87802025  ! 786: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0ade000  ! 787: STBA_I	stba	%r8, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 788: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 789: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r22
	.word 0xd8b4c400  ! 791: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0x87802020  ! 792: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r18
	.word 0xd0d7e000  ! 794: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xdac48400  ! 795: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	.word 0xd6c504a0  ! 796: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r11
	.word 0xd4d74e40  ! 797: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r10
	.word 0xd8df2000  ! 798: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xd2f7ce40  ! 799: STXA_R	stxa	%r9, [%r31 + %r0] 0x72
	.word 0xd2b78e60  ! 800: STHA_R	stha	%r9, [%r30 + %r0] 0x73
	mov	0x7d0, %r21
	.word 0xd29c4400  ! 802: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	mov	0x3f8, %r20
	.word 0xdaaf6000  ! 804: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xdaa7a000  ! 805: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xd8f504a0  ! 806: STXA_R	stxa	%r12, [%r20 + %r0] 0x25
	.word 0xdabd84a0  ! 807: STDA_R	stda	%r13, [%r22 + %r0] 0x25
	.word 0xdcf76000  ! 808: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x3c0, %r20
	mov	0x7f8, %r21
	.word 0xd2c584a0  ! 811: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r9
	.word 0x87802074  ! 812: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2cd44a0  ! 813: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r9
	.word 0xd8b62000  ! 814: STHA_I	stha	%r12, [%r24 + 0x0000] %asi
	.word 0xd8ae2000  ! 815: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	wr_tick_cmpr_3_5:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xc0, %g2
	or	%g4, 0xad, %g4
	or	%g6, 0xa3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x28, %r19
	.word 0xd8c40400  ! 818: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	mov	0x7f0, %r23
	.word 0xd28e89e0  ! 820: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r9
	.word 0xd4a62000  ! 821: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	.word 0xd4de6000  ! 822: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r10
	.word 0xd8f544a0  ! 823: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	.word 0xdad74e60  ! 824: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r13
	.word 0xdcaee000  ! 825: STBA_I	stba	%r14, [%r27 + 0x0000] %asi
	.word 0xdcdee000  ! 826: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r14
	.word 0xdcf62000  ! 827: STXA_I	stxa	%r14, [%r24 + 0x0000] %asi
	.word 0xdec44400  ! 828: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0x87802073  ! 829: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc842000  ! 830: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	.word 0x87802074  ! 831: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 832: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2de89e0  ! 833: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r9
	.word 0xd6946000  ! 834: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r11
	ta	T_CHANGE_PRIV	! macro
	mov	0x3c0, %r21
	.word 0xd6f42000  ! 837: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	.word 0xdadf0e80  ! 838: LDXA_R	ldxa	[%r28, %r0] 0x74, %r13
	.word 0xda970e80  ! 839: LDUHA_R	lduha	[%r28, %r0] 0x74, %r13
	.word 0xd0ac6000  ! 840: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	mov	0x50, %r17
	.word 0xd0dc2000  ! 842: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	mov	0x28, %r24
	mov	0x68, %r26
	.word 0xdabd84a0  ! 845: STDA_R	stda	%r13, [%r22 + %r0] 0x25
	.word 0xd6b40400  ! 846: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 847: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bd44a0  ! 848: STDA_R	stda	%r10, [%r21 + %r0] 0x25
	mov	0x38, %r24
	mov	0x78, %r27
	.word 0x87802025  ! 851: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6af2000  ! 852: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 853: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 854: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b7e000  ! 855: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd6cfa000  ! 856: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0xd0f584a0  ! 857: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	.word 0x87802074  ! 858: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r18
	.word 0xd0b5e000  ! 860: STHA_I	stha	%r8, [%r23 + 0x0000] %asi
	.word 0xd0f649e0  ! 861: STXA_R	stxa	%r8, [%r25 + %r0] 0x4f
	.word 0xdaf5e000  ! 862: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0xd4f584a0  ! 863: STXA_R	stxa	%r10, [%r22 + %r0] 0x25
	.word 0xd2bc0400  ! 864: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xd295e000  ! 865: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r9
	mov	0x78, %r27
	mov	0x48, %r16
	.word 0xd0b544a0  ! 868: STHA_R	stha	%r8, [%r21 + %r0] 0x25
	.word 0x87802072  ! 869: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb5c4a0  ! 870: STHA_R	stha	%r14, [%r23 + %r0] 0x25
	.word 0xdacc4400  ! 871: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	mov	0x20, %r26
	mov	0x28, %r17
	.word 0xdef72000  ! 874: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 875: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 876: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 877: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef72000  ! 878: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xd0f48400  ! 879: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xd2f48400  ! 880: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0xdca7e000  ! 881: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	mov	0x48, %r17
	mov	0x3e0, %r23
	mov	0x40, %r18
	.word 0xdc97e000  ! 885: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0x87802020  ! 886: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 887: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf4a000  ! 888: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdaafce40  ! 889: STBA_R	stba	%r13, [%r31 + %r0] 0x72
	.word 0xdea4a000  ! 890: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	wr_tick_cmpr_3_6:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x96, %g2
	or	%g4, 0xfd, %g4
	or	%g6, 0xfb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdeaca000  ! 892: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xdca48400  ! 893: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0x87802025  ! 894: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde970e40  ! 895: LDUHA_R	lduha	[%r28, %r0] 0x72, %r15
	.word 0xda8d2000  ! 896: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r13
	wr_tick_cmpr_3_7:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xc2, %g2
	or	%g4, 0xec, %g4
	or	%g6, 0xcb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x50, %r26
	mov	0x60, %r25
	.word 0xd0d40400  ! 900: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	.word 0xd0cfce60  ! 901: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r8
	.word 0xd6bd04a0  ! 902: STDA_R	stda	%r11, [%r20 + %r0] 0x25
	.word 0x87802074  ! 903: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 904: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d0, %r20
	.word 0xdeb7ce60  ! 906: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	.word 0x87802072  ! 907: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f0, %r23
	mov	0x28, %r25
	.word 0x87802020  ! 910: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac4e000  ! 911: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r13
	.word 0xda946000  ! 912: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	.word 0xdabc6000  ! 913: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xda94e000  ! 914: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r13
	.word 0x87802025  ! 915: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8fe000  ! 916: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0x87802025  ! 917: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd29fce40  ! 918: LDDA_R	ldda	[%r31, %r0] 0x72, %r9
	.word 0xdccca000  ! 919: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	mov	0x0, %r24
	mov	0x7d0, %r23
	.word 0x87802074  ! 922: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeac4400  ! 923: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0xd4870e60  ! 924: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r10
	mov	0x3f8, %r20
	mov	0x10, %r27
	.word 0x8780204f  ! 927: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r26
	.word 0xd8b4e000  ! 929: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0xd8ac6000  ! 931: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 932: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8946000  ! 933: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	mov	0x30, %r18
	mov	0x68, %r26
	.word 0xd88c6000  ! 936: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	.word 0xd0bd84a0  ! 937: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0xd8bca000  ! 938: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd8f46000  ! 939: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xdcce89e0  ! 940: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r14
	mov	0x50, %r17
	.word 0xd8bc8400  ! 942: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xd08c2000  ! 943: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0xd0842000  ! 944: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r8
	.word 0xd0b4a000  ! 945: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xd0b4e000  ! 946: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	mov	0x70, %r24
	.word 0x87802072  ! 948: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b649e0  ! 949: STHA_R	stha	%r11, [%r25 + %r0] 0x4f
	mov	0x3d0, %r21
	mov	0x50, %r16
	.word 0xdcdf2000  ! 952: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	mov	0x48, %r26
	.word 0xd2974e60  ! 954: LDUHA_R	lduha	[%r29, %r0] 0x73, %r9
	mov	0x8, %r18
	.word 0xd68f0e40  ! 956: LDUBA_R	lduba	[%r28, %r0] 0x72, %r11
	mov	0x70, %r16
	.word 0xde9f2000  ! 958: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xdedf6000  ! 959: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xdedfa000  ! 960: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xde976000  ! 961: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	.word 0xd4b584a0  ! 962: STHA_R	stha	%r10, [%r22 + %r0] 0x25
	.word 0xd0b76000  ! 963: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	mov	0x8, %r25
	.word 0xd0f72000  ! 965: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xd4b4c400  ! 966: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0xdef78e60  ! 967: STXA_R	stxa	%r15, [%r30 + %r0] 0x73
	.word 0x87802025  ! 968: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaa6c9e0  ! 969: STWA_R	stwa	%r13, [%r27 + %r0] 0x4f
	mov	0x28, %r27
	.word 0xd0f7ce80  ! 971: STXA_R	stxa	%r8, [%r31 + %r0] 0x74
	.word 0xd6dc0400  ! 972: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	.word 0xde9fa000  ! 973: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	.word 0x87802020  ! 974: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 975: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f0, %r22
	.word 0xd8b40400  ! 977: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xdcc6a000  ! 978: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r14
	.word 0x87802025  ! 979: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd89d44a0  ! 980: LDDA_R	ldda	[%r21, %r0] 0x25, %r12
	.word 0xd4dc2000  ! 981: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	wr_tick_cmpr_3_8:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd0, %g2
	or	%g4, 0x8f, %g4
	or	%g6, 0xaf, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2944400  ! 983: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	mov	0x38, %r25
	.word 0xdc8c8400  ! 985: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0xd4942000  ! 986: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r10
	.word 0xd4dca000  ! 987: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	mov	0x7e0, %r21
	.word 0xd4bc2000  ! 989: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 990: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f48400  ! 991: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	mov	0x3d8, %r23
	.word 0xd6de89e0  ! 993: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r11
	mov	0x7d8, %r22
	.word 0x87802020  ! 995: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r21
	.word 0xdcafce80  ! 997: STBA_R	stba	%r14, [%r31 + %r0] 0x74
	mov	0x30, %r16
	.word 0xd4cd44a0  ! 999: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r10
	.word 0xdc8c0400  ! 1000: LDUBA_R	lduba	[%r16, %r0] 0x20, %r14
	.word 0xd4bce000  ! 1001: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0xd4942000  ! 1002: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r10
	mov	0x7f8, %r21
	.word 0xd6de09e0  ! 1004: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r11
	.word 0x87802072  ! 1005: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6976000  ! 1006: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	.word 0xdaa74e60  ! 1007: STWA_R	stwa	%r13, [%r29 + %r0] 0x73
	.word 0xd8d44400  ! 1008: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	mov	0x70, %r18
	.word 0xd494c400  ! 1010: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	mov	0x7d0, %r20
	.word 0x87802020  ! 1012: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1013: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f4c400  ! 1014: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	ta	T_CHANGE_PRIV	! macro
	.word 0xd4acc400  ! 1016: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xd8d52000  ! 1017: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r12
	.word 0xd8a52000  ! 1018: STWA_I	stwa	%r12, [%r20 + 0x0000] %asi
	.word 0xd8f5e000  ! 1019: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	mov	0x3c0, %r20
	mov	0x28, %r18
	.word 0xd0a609e0  ! 1022: STWA_R	stwa	%r8, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 1023: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcd7e000  ! 1024: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xdab504a0  ! 1025: STHA_R	stha	%r13, [%r20 + %r0] 0x25
	.word 0x87802025  ! 1026: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabc6000  ! 1027: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	mov	0x20, %r25
	mov	0x20, %r16
	.word 0x87802074  ! 1030: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r25
	.word 0xd2a78e40  ! 1032: STWA_R	stwa	%r9, [%r30 + %r0] 0x72
	.word 0xdea74e80  ! 1033: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	.word 0xdc95a000  ! 1034: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r14
	.word 0xd48cc400  ! 1035: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	.word 0x87802020  ! 1036: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6978e80  ! 1037: LDUHA_R	lduha	[%r30, %r0] 0x74, %r11
	.word 0xdac6c9e0  ! 1038: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r13
	mov	0x40, %r18
	.word 0xd8a72000  ! 1040: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd2df8e80  ! 1041: LDXA_R	ldxa	[%r30, %r0] 0x74, %r9
	.word 0xd6872000  ! 1042: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6a7a000  ! 1043: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	mov	0x28, %r24
	.word 0xd8cc8400  ! 1045: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0xd4972000  ! 1046: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	mov	0x7f0, %r21
	.word 0xd48fe000  ! 1048: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	mov	0x8, %r16
	mov	0x3c8, %r20
	mov	0x78, %r25
	.word 0xd8a70e80  ! 1052: STWA_R	stwa	%r12, [%r28 + %r0] 0x74
	mov	0x48, %r17
	.word 0xd097e000  ! 1054: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xd2d78e80  ! 1055: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r9
	.word 0xdcdf8e40  ! 1056: LDXA_R	ldxa	[%r30, %r0] 0x72, %r14
	.word 0xd4844400  ! 1057: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0xd0dd44a0  ! 1058: LDXA_R	ldxa	[%r21, %r0] 0x25, %r8
	.word 0xdc87ce40  ! 1059: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r14
	.word 0xd487a000  ! 1060: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	.word 0xd48649e0  ! 1061: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r10
	.word 0xd4c7e000  ! 1062: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4afa000  ! 1063: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xdc8584a0  ! 1064: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r14
	.word 0xdcaf8e60  ! 1065: STBA_R	stba	%r14, [%r30 + %r0] 0x73
	.word 0x87802025  ! 1066: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r24
	.word 0xdebe2000  ! 1068: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 1069: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1070: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdea7a000  ! 1071: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	mov	0x10, %r26
	.word 0xde8c8400  ! 1073: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	.word 0xd2944400  ! 1074: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	.word 0xd4bfa000  ! 1075: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd4bf6000  ! 1076: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 1077: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b609e0  ! 1078: STHA_R	stha	%r8, [%r24 + %r0] 0x4f
	mov	0x58, %r18
	mov	0x40, %r16
	.word 0xdaacc400  ! 1081: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0xde8ca000  ! 1082: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0x87802074  ! 1083: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r25
	.word 0xdedfa000  ! 1085: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xdedfa000  ! 1086: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xdec7e000  ! 1087: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0x87802073  ! 1088: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 1089: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1090: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1091: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca74e80  ! 1092: STWA_R	stwa	%r14, [%r29 + %r0] 0x74
	.word 0xdc876000  ! 1093: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	mov	0x20, %r18
	.word 0xd4948400  ! 1095: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	.word 0xd0af2000  ! 1096: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0bfa000  ! 1097: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 1098: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a42000  ! 1099: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xdcc5c4a0  ! 1100: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r14
	.word 0xd6dce000  ! 1101: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0x87802074  ! 1102: WRASI_I	wr	%r0, 0x0074, %asi
	wr_tick_cmpr_3_9:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd2, %g2
	or	%g4, 0x9e, %g4
	or	%g6, 0xac, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0f7ce60  ! 1104: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	.word 0xd4c74e60  ! 1105: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r10
	.word 0xdc9d04a0  ! 1106: LDDA_R	ldda	[%r20, %r0] 0x25, %r14
	.word 0x87802020  ! 1107: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88f2000  ! 1108: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	mov	0x18, %r26
	mov	0x60, %r24
	.word 0x87802020  ! 1111: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68d84a0  ! 1112: LDUBA_R	lduba	[%r22, %r0] 0x25, %r11
	mov	0x7e8, %r23
	.word 0xdef44400  ! 1114: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xd89fce60  ! 1115: LDDA_R	ldda	[%r31, %r0] 0x73, %r12
	.word 0xdaf48400  ! 1116: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xdad46000  ! 1117: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	.word 0xda946000  ! 1118: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	.word 0xd2bc4400  ! 1119: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0xd6a42000  ! 1120: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xd6b4a000  ! 1121: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd4cfce80  ! 1122: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r10
	mov	0x3f8, %r23
	.word 0xd0b4e000  ! 1124: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	mov	0x7c8, %r21
	mov	0x10, %r27
	mov	0x28, %r24
	mov	0x3e8, %r22
	.word 0x87802072  ! 1129: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0cea000  ! 1130: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r8
	mov	0x68, %r24
	.word 0xd48689e0  ! 1132: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r10
	.word 0xd4af8e40  ! 1133: STBA_R	stba	%r10, [%r30 + %r0] 0x72
	mov	0x7f8, %r23
	mov	0x40, %r18
	.word 0xd6df0e40  ! 1136: LDXA_R	ldxa	[%r28, %r0] 0x72, %r11
	.word 0xdcc66000  ! 1137: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	mov	0x48, %r16
	.word 0xda8c4400  ! 1139: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0x8780204f  ! 1140: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b7a000  ! 1141: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 1142: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6aea000  ! 1143: STBA_I	stba	%r11, [%r26 + 0x0000] %asi
	mov	0x20, %r26
	wr_tick_cmpr_3_10:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf8, %g2
	or	%g4, 0x91, %g4
	or	%g6, 0xde, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd6948400  ! 1146: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	.word 0xd6a6a000  ! 1147: STWA_I	stwa	%r11, [%r26 + 0x0000] %asi
	.word 0xd6af4e80  ! 1148: STBA_R	stba	%r11, [%r29 + %r0] 0x74
	mov	0x38, %r17
	.word 0xd6b6c9e0  ! 1150: STHA_R	stha	%r11, [%r27 + %r0] 0x4f
	.word 0xd2ae6000  ! 1151: STBA_I	stba	%r9, [%r25 + 0x0000] %asi
	wr_tick_cmpr_3_11:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x9c, %g2
	or	%g4, 0xf3, %g4
	or	%g6, 0xf0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd286a000  ! 1153: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r9
	.word 0x87802073  ! 1154: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2dc6000  ! 1155: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r9
	.word 0xd6b7ce80  ! 1156: STHA_R	stha	%r11, [%r31 + %r0] 0x74
	.word 0x87802074  ! 1157: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r25
	.word 0xd88ce000  ! 1159: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	.word 0xd4b7ce40  ! 1160: STHA_R	stha	%r10, [%r31 + %r0] 0x72
	mov	0x0, %r27
	.word 0xd8a4c400  ! 1162: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	mov	0x30, %r24
	.word 0xd2ae49e0  ! 1164: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	.word 0xd6a74e80  ! 1165: STWA_R	stwa	%r11, [%r29 + %r0] 0x74
	.word 0xd49c2000  ! 1166: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1167: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb78e40  ! 1168: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xd6d74e80  ! 1169: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r11
	.word 0xd69e6000  ! 1170: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r11
	.word 0x87802020  ! 1171: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bce000  ! 1172: STDA_I	stda	%r11, [%r19 + 0x0000] %asi
	.word 0xd0bcc400  ! 1173: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0xded44400  ! 1174: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	.word 0x87802072  ! 1175: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f8, %r22
	.word 0xd89f0e40  ! 1177: LDDA_R	ldda	[%r28, %r0] 0x72, %r12
	.word 0xdef70e60  ! 1178: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	.word 0xd0af2000  ! 1179: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0872000  ! 1180: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	mov	0x7c8, %r22
	.word 0xd09fa000  ! 1182: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	.word 0xd8c40400  ! 1183: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	mov	0x48, %r16
	.word 0x87802072  ! 1185: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd09f0e60  ! 1186: LDDA_R	ldda	[%r28, %r0] 0x73, %r8
	mov	0x3e8, %r21
	.word 0xda862000  ! 1188: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r13
	.word 0xdac62000  ! 1189: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r13
	.word 0xdcf70e60  ! 1190: STXA_R	stxa	%r14, [%r28 + %r0] 0x73
	.word 0x87802072  ! 1191: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f56000  ! 1192: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 1193: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r27
	.word 0xd4f7e000  ! 1195: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1196: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4afa000  ! 1197: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd2f609e0  ! 1198: STXA_R	stxa	%r9, [%r24 + %r0] 0x4f
	.word 0xd0976000  ! 1199: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 1200: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 1201: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd08c0400  ! 1202: LDUBA_R	lduba	[%r16, %r0] 0x20, %r8
	.word 0x87802074  ! 1203: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4bc6000  ! 1204: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xd4f4e000  ! 1205: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0xd4f46000  ! 1206: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0xd2a544a0  ! 1207: STWA_R	stwa	%r9, [%r21 + %r0] 0x25
	mov	0x48, %r17
	.word 0xd0dca000  ! 1209: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0bca000  ! 1210: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0xd8ae09e0  ! 1212: STBA_R	stba	%r12, [%r24 + %r0] 0x4f
	mov	0x3e0, %r20
	mov	0x38, %r24
	.word 0xdcac0400  ! 1215: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xd0f5c4a0  ! 1216: STXA_R	stxa	%r8, [%r23 + %r0] 0x25
	.word 0xdcf48400  ! 1217: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0x87802072  ! 1218: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 1219: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6dca000  ! 1220: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r11
	mov	0x20, %r24
	.word 0x87802020  ! 1222: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r19
	.word 0xd6f46000  ! 1224: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0xd6942000  ! 1225: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r11
	.word 0x87802074  ! 1226: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8a689e0  ! 1227: STWA_R	stwa	%r12, [%r26 + %r0] 0x4f
	.word 0xde9fe000  ! 1228: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x60, %r24
	.word 0x87802025  ! 1231: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r19
	mov	0x70, %r17
	.word 0xdc8e09e0  ! 1234: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r14
	.word 0x87802020  ! 1235: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r27
	.word 0xd8ade000  ! 1237: STBA_I	stba	%r12, [%r23 + 0x0000] %asi
	.word 0xda8f4e40  ! 1238: LDUBA_R	lduba	[%r29, %r0] 0x72, %r13
	.word 0xd4be89e0  ! 1239: STDA_R	stda	%r10, [%r26 + %r0] 0x4f
	mov	0x40, %r24
	.word 0xdcf52000  ! 1241: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 1242: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4874e40  ! 1243: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r10
	.word 0xdcd7e000  ! 1244: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xdcf76000  ! 1245: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xd6ac0400  ! 1246: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	mov	0x10, %r26
	.word 0xdcdf6000  ! 1248: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xd6f74e80  ! 1249: STXA_R	stxa	%r11, [%r29 + %r0] 0x74
	.word 0xd8df4e60  ! 1250: LDXA_R	ldxa	[%r29, %r0] 0x73, %r12
	mov	0x3e0, %r20
	.word 0xd8f74e60  ! 1252: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	.word 0xd6bf6000  ! 1253: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1254: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r23
	.word 0x87802025  ! 1256: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde878e40  ! 1257: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r15
	.word 0xd094e000  ! 1258: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0xd084e000  ! 1259: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	.word 0xdcb70e60  ! 1260: STHA_R	stha	%r14, [%r28 + %r0] 0x73
	.word 0xd8f4e000  ! 1261: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xd8d46000  ! 1262: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	.word 0xd89c2000  ! 1263: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	.word 0xd6df0e40  ! 1264: LDXA_R	ldxa	[%r28, %r0] 0x72, %r11
	.word 0x87802073  ! 1265: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r25
	.word 0xd0f52000  ! 1267: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xd0852000  ! 1269: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r8
	.word 0xd28c0400  ! 1270: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	.word 0xd4bde000  ! 1271: STDA_I	stda	%r10, [%r23 + 0x0000] %asi
	.word 0xd4bd2000  ! 1272: STDA_I	stda	%r10, [%r20 + 0x0000] %asi
	.word 0xdef44400  ! 1273: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xd0d5e000  ! 1274: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1275: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0972000  ! 1276: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0af2000  ! 1277: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd4bc0400  ! 1278: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xd6a7ce80  ! 1279: STWA_R	stwa	%r11, [%r31 + %r0] 0x74
	.word 0xdaafa000  ! 1280: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xd08649e0  ! 1281: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r8
	mov	0x3f0, %r23
	mov	0x3c0, %r21
	mov	0x48, %r16
	.word 0xdebf2000  ! 1285: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xd6cec9e0  ! 1286: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r11
	.word 0x87802072  ! 1287: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f0, %r20
	.word 0xd0c74e80  ! 1289: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r8
	.word 0xdeb689e0  ! 1290: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	.word 0xd48689e0  ! 1291: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r10
	.word 0x87802020  ! 1292: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1293: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1294: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc9da000  ! 1295: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r14
	.word 0x87802073  ! 1296: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc8c2000  ! 1297: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r14
	mov	0x20, %r17
	.word 0x8780204f  ! 1299: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r17
	mov	0x0, %r18
	.word 0xde8f0e80  ! 1302: LDUBA_R	lduba	[%r28, %r0] 0x74, %r15
	.word 0xda8fa000  ! 1303: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	mov	0x7d8, %r23
	.word 0x87802074  ! 1305: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 1306: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdacfa000  ! 1307: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0x87802074  ! 1308: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 1309: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda9e2000  ! 1310: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r13
	.word 0xdacd44a0  ! 1311: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r13
	mov	0x7e0, %r20
	mov	0x3f0, %r23
	.word 0xd6f6a000  ! 1314: STXA_I	stxa	%r11, [%r26 + 0x0000] %asi
	mov	0x28, %r17
	.word 0xd4af4e60  ! 1316: STBA_R	stba	%r10, [%r29 + %r0] 0x73
	.word 0xd0f44400  ! 1317: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0x87802073  ! 1318: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r19
	mov	0x10, %r17
	.word 0xdef40400  ! 1321: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	mov	0x0, %r26
	.word 0xdea4a000  ! 1323: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xdca7ce80  ! 1324: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	.word 0xd28ec9e0  ! 1325: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r9
	mov	0x7d8, %r22
	mov	0x3f8, %r21
	.word 0xd6b4e000  ! 1328: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xd69c2000  ! 1329: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r11
	.word 0x87802020  ! 1330: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29cc400  ! 1331: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	.word 0xd08f8e40  ! 1332: LDUBA_R	lduba	[%r30, %r0] 0x72, %r8
	mov	0x0, %r18
	.word 0xdecd04a0  ! 1334: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r15
	.word 0xd6b584a0  ! 1335: STHA_R	stha	%r11, [%r22 + %r0] 0x25
	.word 0xdadfa000  ! 1336: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xd8df4e60  ! 1337: LDXA_R	ldxa	[%r29, %r0] 0x73, %r12
	.word 0xdef74e40  ! 1338: STXA_R	stxa	%r15, [%r29 + %r0] 0x72
	.word 0xda9fce40  ! 1339: LDDA_R	ldda	[%r31, %r0] 0x72, %r13
	.word 0xdacf2000  ! 1340: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xd0b44400  ! 1341: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	mov	0x3f8, %r22
	.word 0xdeb7e000  ! 1343: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	mov	0x40, %r26
	.word 0xd8b48400  ! 1345: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0xd0b78e40  ! 1346: STHA_R	stha	%r8, [%r30 + %r0] 0x72
	mov	0x7f0, %r23
	mov	0x3c8, %r20
	mov	0x18, %r27
	mov	0x3f8, %r21
	.word 0xd0d76000  ! 1351: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0af6000  ! 1352: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	mov	0x60, %r24
	mov	0x7d8, %r20
	.word 0xd0a584a0  ! 1355: STWA_R	stwa	%r8, [%r22 + %r0] 0x25
	.word 0xd4b74e80  ! 1356: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	.word 0xdebfe000  ! 1357: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xdcdd04a0  ! 1358: LDXA_R	ldxa	[%r20, %r0] 0x25, %r14
	.word 0x87802025  ! 1359: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd487ce60  ! 1360: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r10
	.word 0x87802020  ! 1361: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1362: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xded44400  ! 1363: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	.word 0x87802072  ! 1364: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 1365: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r27
	mov	0x58, %r26
	.word 0x87802020  ! 1368: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ac6000  ! 1369: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	.word 0xd4c46000  ! 1370: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r10
	.word 0xd4bc6000  ! 1371: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	mov	0x28, %r17
	.word 0x87802020  ! 1373: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r19
	.word 0xd2f48400  ! 1375: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0xd6afa000  ! 1376: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6af2000  ! 1377: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x38, %r26
	.word 0xd6d72000  ! 1379: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r11
	mov	0x3f0, %r21
	.word 0xd6a7e000  ! 1381: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6b7a000  ! 1382: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xdaa689e0  ! 1383: STWA_R	stwa	%r13, [%r26 + %r0] 0x4f
	.word 0xd0a7e000  ! 1384: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0b7e000  ! 1385: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0xde9c4400  ! 1386: LDDA_R	ldda	[%r17, %r0] 0x20, %r15
	.word 0xd6f7ce40  ! 1387: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	mov	0x58, %r19
	.word 0xd4c70e60  ! 1389: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r10
	mov	0x78, %r16
	.word 0xdab74e80  ! 1391: STHA_R	stha	%r13, [%r29 + %r0] 0x74
	ta	T_CHANGE_PRIV	! macro
	mov	0x70, %r18
	mov	0x10, %r24
	mov	0x50, %r26
	mov	0x60, %r24
	mov	0x40, %r18
	.word 0xd2f44400  ! 1398: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	mov	0x18, %r24
	mov	0x10, %r19
	.word 0xd8a72000  ! 1401: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1402: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r16
	.word 0xd6940400  ! 1404: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	.word 0x87802020  ! 1405: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r17
	.word 0xdcbfce80  ! 1407: STDA_R	stda	%r14, [%r31 + %r0] 0x74
	.word 0xd4dc8400  ! 1408: LDXA_R	ldxa	[%r18, %r0] 0x20, %r10
	mov	0x50, %r19
	.word 0xd4b48400  ! 1410: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd8af4e80  ! 1411: STBA_R	stba	%r12, [%r29 + %r0] 0x74
	.word 0xd6df2000  ! 1412: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd68f2000  ! 1413: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	mov	0x7c0, %r23
	mov	0x48, %r25
	.word 0xd2a504a0  ! 1416: STWA_R	stwa	%r9, [%r20 + %r0] 0x25
	mov	0x58, %r24
	mov	0x10, %r27
	.word 0x87802025  ! 1419: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 1420: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd69f2000  ! 1421: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	mov	0x3c0, %r22
	.word 0xd6dfe000  ! 1423: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	.word 0x87802025  ! 1424: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r19
	.word 0xd6a46000  ! 1426: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0xd6d4a000  ! 1427: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r11
	.word 0xdeb5c4a0  ! 1428: STHA_R	stha	%r15, [%r23 + %r0] 0x25
	.word 0xd8bc6000  ! 1429: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	mov	0x3f0, %r23
	.word 0xdcb78e40  ! 1431: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xded4e000  ! 1432: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	.word 0x87802073  ! 1433: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2bcc400  ! 1434: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	mov	0x68, %r24
	mov	0x78, %r27
	.word 0xd09f2000  ! 1437: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0xd08fe000  ! 1438: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	ta	T_CHANGE_PRIV	! macro
	.word 0xdca584a0  ! 1440: STWA_R	stwa	%r14, [%r22 + %r0] 0x25
	.word 0xd0cc0400  ! 1441: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xdcb7ce40  ! 1442: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	.word 0x87802020  ! 1443: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1444: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8f7a000  ! 1445: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd6a48400  ! 1446: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0xd4cf2000  ! 1447: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	mov	0x3f0, %r20
	.word 0xd4b7e000  ! 1449: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xdeac8400  ! 1450: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xd4cf4e80  ! 1451: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r10
	.word 0xd0dfe000  ! 1452: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0c7e000  ! 1453: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 1454: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0ac0400  ! 1455: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	.word 0x87802020  ! 1456: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a6e000  ! 1457: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	.word 0xdc870e40  ! 1458: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r14
	mov	0x50, %r24
	mov	0x78, %r19
	mov	0x3d8, %r21
	.word 0xdace6000  ! 1462: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r13
	.word 0xda848400  ! 1463: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r13
	.word 0xd6bd84a0  ! 1464: STDA_R	stda	%r11, [%r22 + %r0] 0x25
	.word 0xdcb62000  ! 1465: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	.word 0x87802025  ! 1466: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a70e80  ! 1467: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0xd0cf0e80  ! 1468: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r8
	mov	0x0, %r25
	mov	0x28, %r25
	.word 0xd0a5e000  ! 1471: STWA_I	stwa	%r8, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 1472: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b48400  ! 1473: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	mov	0x18, %r27
	.word 0xd6aca000  ! 1475: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xd2a70e60  ! 1476: STWA_R	stwa	%r9, [%r28 + %r0] 0x73
	.word 0xd89c2000  ! 1477: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	.word 0xd2af0e40  ! 1478: STBA_R	stba	%r9, [%r28 + %r0] 0x72
	.word 0x87802020  ! 1479: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1480: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea44400  ! 1481: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0x87802074  ! 1482: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde8ca000  ! 1483: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0xde84e000  ! 1484: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	.word 0xd09c4400  ! 1485: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	.word 0xdebdc4a0  ! 1486: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	.word 0xdab46000  ! 1487: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0xdac4e000  ! 1488: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r13
	.word 0xd6d48400  ! 1489: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0x87802020  ! 1490: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d76000  ! 1491: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0xd297a000  ! 1492: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	mov	0x3e0, %r20
	mov	0x3f0, %r22
	.word 0xd2cfa000  ! 1495: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	mov	0x3c8, %r23
	.word 0x87802072  ! 1497: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f8, %r21
	.word 0xd2de6000  ! 1499: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r9
	.word 0xd2bee000  ! 1500: STDA_I	stda	%r9, [%r27 + 0x0000] %asi
	.word 0xd2ac0400  ! 1501: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0xdac74e80  ! 1502: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r13
	.word 0xd4a48400  ! 1503: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xd2b6e000  ! 1504: STHA_I	stha	%r9, [%r27 + 0x0000] %asi
	mov	0x40, %r26
	.word 0xd2f62000  ! 1506: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	.word 0xd6840400  ! 1507: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0xd6ce6000  ! 1508: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r11
	.word 0xd4b609e0  ! 1509: STHA_R	stha	%r10, [%r24 + %r0] 0x4f
	.word 0xdabf0e40  ! 1510: STDA_R	stda	%r13, [%r28 + %r0] 0x72
	wr_tick_cmpr_3_12:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf7, %g2
	or	%g4, 0x92, %g4
	or	%g6, 0xa1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdeaea000  ! 1512: STBA_I	stba	%r15, [%r26 + 0x0000] %asi
	mov	0x20, %r24
	.word 0xd8bc4400  ! 1514: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xd4dea000  ! 1515: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	.word 0xdef78e80  ! 1516: STXA_R	stxa	%r15, [%r30 + %r0] 0x74
	.word 0xd8dd84a0  ! 1517: LDXA_R	ldxa	[%r22, %r0] 0x25, %r12
	.word 0xdcde2000  ! 1518: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r14
	mov	0x50, %r16
	.word 0x87802020  ! 1520: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r23
	mov	0x50, %r18
	mov	0x0, %r24
	.word 0x87802072  ! 1524: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 1525: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdac40400  ! 1526: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	.word 0xd8a72000  ! 1527: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd88f2000  ! 1528: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0x87802073  ! 1529: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f4e000  ! 1530: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 1531: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8ce89e0  ! 1532: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r12
	.word 0xd8af6000  ! 1533: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd08544a0  ! 1534: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r8
	.word 0xd8d72000  ! 1535: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	mov	0x7c0, %r23
	mov	0x3e8, %r23
	.word 0xd8cfa000  ! 1538: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xdacfce60  ! 1539: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r13
	.word 0xdedf2000  ! 1540: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xdea72000  ! 1541: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	mov	0x0, %r24
	.word 0x87802020  ! 1543: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebc6000  ! 1544: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xd2acc400  ! 1545: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0xd8a584a0  ! 1546: STWA_R	stwa	%r12, [%r22 + %r0] 0x25
	mov	0x3d8, %r23
	.word 0xd08c6000  ! 1548: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0xd0f46000  ! 1549: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 1550: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 1551: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r16
	.word 0xd6b544a0  ! 1553: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	.word 0xd49ca000  ! 1554: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xdc9d04a0  ! 1555: LDDA_R	ldda	[%r20, %r0] 0x25, %r14
	.word 0xd8dc0400  ! 1556: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0x87802020  ! 1557: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r23
	.word 0xdccec9e0  ! 1559: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r14
	.word 0x87802020  ! 1560: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9c2000  ! 1561: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 1562: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdadce000  ! 1563: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xd885c4a0  ! 1564: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r12
	.word 0xd6f7ce80  ! 1565: STXA_R	stxa	%r11, [%r31 + %r0] 0x74
	.word 0xd8a44400  ! 1566: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0x87802020  ! 1567: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d62000  ! 1568: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r10
	.word 0xd8afce60  ! 1569: STBA_R	stba	%r12, [%r31 + %r0] 0x73
	.word 0x87802020  ! 1570: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r27
	.word 0xd2b70e40  ! 1572: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	.word 0xd8a544a0  ! 1573: STWA_R	stwa	%r12, [%r21 + %r0] 0x25
	.word 0xdcc5e000  ! 1574: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r14
	.word 0xded48400  ! 1575: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	.word 0x87802025  ! 1576: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 1577: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2aec9e0  ! 1578: STBA_R	stba	%r9, [%r27 + %r0] 0x4f
	mov	0x68, %r17
	.word 0x87802073  ! 1580: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0bfce60  ! 1581: STDA_R	stda	%r8, [%r31 + %r0] 0x73
	.word 0xd0f4e000  ! 1582: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0ace000  ! 1583: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 1584: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0cfe000  ! 1585: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0bfe000  ! 1587: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd68c8400  ! 1588: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	.word 0xd2af2000  ! 1589: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd2dfa000  ! 1590: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2c76000  ! 1591: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2c72000  ! 1592: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0x87802072  ! 1593: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 1594: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2af2000  ! 1595: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd2b7e000  ! 1596: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1597: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab5c4a0  ! 1598: STHA_R	stha	%r13, [%r23 + %r0] 0x25
	.word 0xdef66000  ! 1599: STXA_I	stxa	%r15, [%r25 + 0x0000] %asi
	wr_tick_cmpr_3_13:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xab, %g2
	or	%g4, 0xaf, %g4
	or	%g6, 0x94, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xde9ee000  ! 1601: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r15
	.word 0xde9e6000  ! 1602: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r15
	.word 0xdeb66000  ! 1603: STHA_I	stha	%r15, [%r25 + 0x0000] %asi
	.word 0xded66000  ! 1604: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r15
	mov	0x0, %r17
	mov	0x60, %r24
	.word 0xd0f5c4a0  ! 1607: STXA_R	stxa	%r8, [%r23 + %r0] 0x25
	mov	0x50, %r25
	.word 0xd88d84a0  ! 1609: LDUBA_R	lduba	[%r22, %r0] 0x25, %r12
	.word 0xd0b5c4a0  ! 1610: STHA_R	stha	%r8, [%r23 + %r0] 0x25
	mov	0x70, %r27
	wr_tick_cmpr_3_14:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe1, %g2
	or	%g4, 0xb0, %g4
	or	%g6, 0xe4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3e0, %r23
	.word 0xd4cea000  ! 1614: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r10
	.word 0x87802072  ! 1615: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 1616: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4d76000  ! 1617: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 1618: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r16
	.word 0xd48f2000  ! 1620: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4bf6000  ! 1621: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd8a74e40  ! 1622: STWA_R	stwa	%r12, [%r29 + %r0] 0x72
	.word 0xd6d70e80  ! 1623: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r11
	.word 0xd2dc0400  ! 1624: LDXA_R	ldxa	[%r16, %r0] 0x20, %r9
	.word 0x87802074  ! 1625: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r25
	mov	0x18, %r25
	.word 0xd0dd6000  ! 1628: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r8
	.word 0xdeb689e0  ! 1629: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 1630: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4848400  ! 1631: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r10
	.word 0xd28504a0  ! 1632: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r9
	.word 0xdcb78e60  ! 1633: STHA_R	stha	%r14, [%r30 + %r0] 0x73
	.word 0x87802073  ! 1634: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef7ce60  ! 1635: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	mov	0x30, %r25
	.word 0x87802025  ! 1637: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabee000  ! 1638: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	.word 0xd4c6c9e0  ! 1639: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r10
	.word 0xdc86e000  ! 1640: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r14
	.word 0xdcc6a000  ! 1641: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r14
	.word 0x87802073  ! 1642: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xded609e0  ! 1643: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r15
	.word 0xd2b7ce80  ! 1644: STHA_R	stha	%r9, [%r31 + %r0] 0x74
	mov	0x40, %r24
	mov	0x38, %r25
	.word 0x87802072  ! 1647: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b44400  ! 1648: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	wr_tick_cmpr_3_15:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x95, %g2
	or	%g4, 0xab, %g4
	or	%g6, 0xe7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd6c6e000  ! 1650: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r11
	.word 0xd4f4c400  ! 1651: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd6a66000  ! 1652: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	.word 0x87802072  ! 1653: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 1654: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r16
	.word 0xdecf0e80  ! 1656: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r15
	mov	0x3e8, %r22
	.word 0x87802074  ! 1658: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0ac6000  ! 1659: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0xdade89e0  ! 1660: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r13
	.word 0xdaaf4e60  ! 1661: STBA_R	stba	%r13, [%r29 + %r0] 0x73
	mov	0x3e8, %r20
	.word 0xdeb4a000  ! 1663: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xdab48400  ! 1665: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	mov	0x30, %r16
	.word 0xd8dc4400  ! 1667: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	mov	0x7e8, %r21
	.word 0xd6c4a000  ! 1669: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r11
	.word 0xd88f4e80  ! 1670: LDUBA_R	lduba	[%r29, %r0] 0x74, %r12
	mov	0x70, %r25
	mov	0x28, %r27
	.word 0xd0bf8e80  ! 1673: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	.word 0xd89f4e60  ! 1674: LDDA_R	ldda	[%r29, %r0] 0x73, %r12
	.word 0x87802074  ! 1675: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bf4e60  ! 1676: STDA_R	stda	%r12, [%r29 + %r0] 0x73
	.word 0x87802074  ! 1677: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r26
	.word 0xd4de89e0  ! 1679: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r10
	.word 0xd0cee000  ! 1680: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r8
	.word 0xdea40400  ! 1681: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	mov	0x60, %r19
	mov	0x30, %r27
	.word 0xd2966000  ! 1684: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r9
	.word 0xda8f0e60  ! 1685: LDUBA_R	lduba	[%r28, %r0] 0x73, %r13
	.word 0xd4b78e60  ! 1686: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	.word 0x87802074  ! 1687: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 1688: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd297e000  ! 1689: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	.word 0xd2976000  ! 1690: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0xde8e89e0  ! 1691: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r15
	.word 0x87802020  ! 1692: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r17
	.word 0xd69544a0  ! 1694: LDUHA_R	lduha	[%r21, %r0] 0x25, %r11
	.word 0xd09ea000  ! 1695: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r8
	mov	0x60, %r19
	.word 0xdeacc400  ! 1697: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xd8974e40  ! 1698: LDUHA_R	lduha	[%r29, %r0] 0x72, %r12
	.word 0xd2ce6000  ! 1699: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r9
	.word 0x87802073  ! 1700: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2af6000  ! 1701: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd28f6000  ! 1702: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd287e000  ! 1703: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0xd8ad04a0  ! 1704: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	.word 0xd2afce40  ! 1705: STBA_R	stba	%r9, [%r31 + %r0] 0x72
	.word 0xd4bfa000  ! 1706: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	mov	0x30, %r18
	.word 0xdaac8400  ! 1708: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0xd6c44400  ! 1709: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r11
	.word 0xdec78e60  ! 1710: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r15
	.word 0x87802020  ! 1711: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2974e60  ! 1712: LDUHA_R	lduha	[%r29, %r0] 0x73, %r9
	.word 0xd6af6000  ! 1713: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd6afa000  ! 1714: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd2b48400  ! 1715: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	mov	0x7c8, %r22
	mov	0x68, %r25
	mov	0x0, %r19
	.word 0xd69f8e60  ! 1719: LDDA_R	ldda	[%r30, %r0] 0x73, %r11
	mov	0x38, %r19
	.word 0x8780204f  ! 1721: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0cf6000  ! 1722: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 1723: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6a70e60  ! 1724: STWA_R	stwa	%r11, [%r28 + %r0] 0x73
	.word 0xdcbc6000  ! 1725: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xd0d70e80  ! 1727: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r8
	.word 0xdaac0400  ! 1728: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xd0ac4400  ! 1729: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0xdea46000  ! 1730: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xdea4a000  ! 1731: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	mov	0x68, %r27
	.word 0xded4a000  ! 1733: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	mov	0x0, %r26
	.word 0xde9c2000  ! 1735: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xdec46000  ! 1736: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	.word 0xdeb4e000  ! 1737: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0xde84e000  ! 1738: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	.word 0xde9c6000  ! 1739: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0xd6ce89e0  ! 1740: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r11
	.word 0xd2b4a000  ! 1741: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 1742: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r17
	.word 0xd2b46000  ! 1744: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0xd2d4a000  ! 1745: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	.word 0xd2f4e000  ! 1746: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2b44400  ! 1747: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0xd0ac2000  ! 1748: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 1749: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1750: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 1751: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r24
	mov	0x20, %r26
	.word 0xdc9f8e80  ! 1754: LDDA_R	ldda	[%r30, %r0] 0x74, %r14
	.word 0xdca76000  ! 1755: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcbfa000  ! 1756: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdc876000  ! 1757: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0xd6af8e40  ! 1758: STBA_R	stba	%r11, [%r30 + %r0] 0x72
	.word 0xd6872000  ! 1759: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd69544a0  ! 1760: LDUHA_R	lduha	[%r21, %r0] 0x25, %r11
	mov	0x28, %r18
	.word 0xda8fe000  ! 1762: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xdab7a000  ! 1763: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdaaf6000  ! 1764: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xdacf6000  ! 1765: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0x87802072  ! 1766: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1767: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r25
	.word 0xdaf584a0  ! 1769: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	.word 0xd2a7e000  ! 1770: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xdedd44a0  ! 1771: LDXA_R	ldxa	[%r21, %r0] 0x25, %r15
	.word 0xdcc76000  ! 1772: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xdcb72000  ! 1773: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xd2de09e0  ! 1774: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r9
	mov	0x20, %r26
	.word 0x87802074  ! 1776: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 1777: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2ace000  ! 1778: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 1779: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1780: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1781: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1782: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f6a000  ! 1783: STXA_I	stxa	%r9, [%r26 + 0x0000] %asi
	.word 0xd48c8400  ! 1784: LDUBA_R	lduba	[%r18, %r0] 0x20, %r10
	.word 0xde9f0e60  ! 1785: LDDA_R	ldda	[%r28, %r0] 0x73, %r15
	.word 0xd0dea000  ! 1786: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r8
	.word 0xdabf0e80  ! 1787: STDA_R	stda	%r13, [%r28 + %r0] 0x74
	.word 0x87802025  ! 1788: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb4c400  ! 1789: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	mov	0x3c8, %r20
	mov	0x68, %r17
	.word 0x87802074  ! 1792: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bc0400  ! 1793: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xdcbca000  ! 1794: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xd0dd04a0  ! 1795: LDXA_R	ldxa	[%r20, %r0] 0x25, %r8
	.word 0xdec46000  ! 1796: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	.word 0xdef46000  ! 1797: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 1798: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f48400  ! 1799: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0x87802073  ! 1800: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd297a000  ! 1802: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	.word 0xd2a76000  ! 1803: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xdcc78e40  ! 1804: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r14
	mov	0x48, %r17
	mov	0x20, %r25
	.word 0x8780204f  ! 1807: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b70e40  ! 1808: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	.word 0xd4de6000  ! 1809: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r10
	mov	0x0, %r26
	.word 0x87802025  ! 1811: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 1812: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa689e0  ! 1813: STWA_R	stwa	%r13, [%r26 + %r0] 0x4f
	.word 0xd0dfe000  ! 1814: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0cf2000  ! 1815: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0x87802073  ! 1816: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0cde000  ! 1817: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r8
	.word 0xdea7ce80  ! 1818: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	mov	0x3f8, %r21
	.word 0xdea52000  ! 1820: STWA_I	stwa	%r15, [%r20 + 0x0000] %asi
	.word 0xdeada000  ! 1821: STBA_I	stba	%r15, [%r22 + 0x0000] %asi
	.word 0xdad609e0  ! 1822: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r13
	mov	0x20, %r27
	.word 0xd8bc4400  ! 1824: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xdece89e0  ! 1825: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r15
	.word 0xd4dcc400  ! 1826: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	mov	0x3e0, %r21
	mov	0x58, %r26
	.word 0x87802074  ! 1829: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef4a000  ! 1830: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0xd0f70e40  ! 1831: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	.word 0xd4c42000  ! 1832: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r10
	.word 0xd4dca000  ! 1833: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	.word 0xd4c42000  ! 1834: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r10
	.word 0xdca78e60  ! 1835: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	.word 0xd8cce000  ! 1836: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r12
	.word 0xd494c400  ! 1837: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	.word 0xdeb4e000  ! 1838: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0xdec42000  ! 1839: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0xd6874e40  ! 1840: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r11
	.word 0xd29504a0  ! 1841: LDUHA_R	lduha	[%r20, %r0] 0x25, %r9
	mov	0x3c8, %r21
	.word 0x87802025  ! 1843: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cc8400  ! 1844: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	.word 0x8780204f  ! 1845: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a76000  ! 1846: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	mov	0x30, %r24
	.word 0x87802025  ! 1848: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8b5e000  ! 1849: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	.word 0xd8f5e000  ! 1850: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	.word 0xd0d649e0  ! 1851: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r8
	.word 0xdca689e0  ! 1852: STWA_R	stwa	%r14, [%r26 + %r0] 0x4f
	.word 0xd4b44400  ! 1853: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	.word 0xd4ade000  ! 1854: STBA_I	stba	%r10, [%r23 + 0x0000] %asi
	.word 0xd4970e60  ! 1855: LDUHA_R	lduha	[%r28, %r0] 0x73, %r10
	.word 0xd2dfce60  ! 1856: LDXA_R	ldxa	[%r31, %r0] 0x73, %r9
	.word 0xde85a000  ! 1857: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r15
	.word 0x87802072  ! 1858: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 1859: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 1860: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdedf6000  ! 1861: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	mov	0x7f8, %r20
	.word 0xded76000  ! 1863: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	mov	0x7e0, %r21
	.word 0xde9fe000  ! 1865: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 1866: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde878e60  ! 1867: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r15
	.word 0xdea4c400  ! 1868: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	.word 0xdaa66000  ! 1869: STWA_I	stwa	%r13, [%r25 + 0x0000] %asi
	.word 0x87802073  ! 1870: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdacfe000  ! 1871: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0xd2afce60  ! 1872: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	.word 0xd4d7e000  ! 1873: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	mov	0x18, %r18
	.word 0x87802072  ! 1875: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a7a000  ! 1876: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd48f6000  ! 1877: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xd2af0e40  ! 1878: STBA_R	stba	%r9, [%r28 + %r0] 0x72
	.word 0x87802025  ! 1879: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 1880: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r26
	.word 0xd487e000  ! 1882: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	mov	0x48, %r25
	.word 0xd0f78e80  ! 1884: STXA_R	stxa	%r8, [%r30 + %r0] 0x74
	mov	0x50, %r27
	mov	0x38, %r24
	.word 0xd6cf6000  ! 1887: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6bfe000  ! 1888: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xdef78e80  ! 1889: STXA_R	stxa	%r15, [%r30 + %r0] 0x74
	.word 0x87802074  ! 1890: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc94c400  ! 1891: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	.word 0xd0df0e60  ! 1892: LDXA_R	ldxa	[%r28, %r0] 0x73, %r8
	mov	0x30, %r16
	mov	0x3c8, %r23
	mov	0x50, %r27
	.word 0x87802074  ! 1896: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r22
	mov	0x58, %r27
	.word 0xd8bfe000  ! 1899: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	mov	0x70, %r26
	mov	0x48, %r25
	.word 0xd8de49e0  ! 1902: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r12
	.word 0xd68f6000  ! 1903: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6afe000  ! 1904: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x70, %r26
	mov	0x60, %r26
	.word 0xdcb689e0  ! 1907: STHA_R	stha	%r14, [%r26 + %r0] 0x4f
	.word 0xd6f76000  ! 1908: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6a72000  ! 1909: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd2d689e0  ! 1910: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r9
	.word 0xdacd44a0  ! 1911: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r13
	mov	0x18, %r18
	.word 0x87802074  ! 1913: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdec78e40  ! 1914: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r15
	.word 0xde878e60  ! 1915: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r15
	.word 0xd2ac4400  ! 1916: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	mov	0x60, %r26
	.word 0xdea62000  ! 1918: STWA_I	stwa	%r15, [%r24 + 0x0000] %asi
	mov	0x7f0, %r22
	.word 0xdea6a000  ! 1920: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	.word 0xd0afce60  ! 1921: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	.word 0xd69dc4a0  ! 1922: LDDA_R	ldda	[%r23, %r0] 0x25, %r11
	.word 0xde97ce40  ! 1923: LDUHA_R	lduha	[%r31, %r0] 0x72, %r15
	.word 0xdcdf0e80  ! 1924: LDXA_R	ldxa	[%r28, %r0] 0x74, %r14
	.word 0xd0be6000  ! 1925: STDA_I	stda	%r8, [%r25 + 0x0000] %asi
	.word 0xd09e6000  ! 1926: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r8
	.word 0xd6acc400  ! 1927: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xd88f8e40  ! 1928: LDUBA_R	lduba	[%r30, %r0] 0x72, %r12
	.word 0xdebee000  ! 1929: STDA_I	stda	%r15, [%r27 + 0x0000] %asi
	.word 0xde9e6000  ! 1930: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r15
	mov	0x7d8, %r22
	.word 0xd8a70e60  ! 1932: STWA_R	stwa	%r12, [%r28 + %r0] 0x73
	.word 0xd0c40400  ! 1933: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	.word 0xd6c6e000  ! 1934: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r11
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x58, %r16
	.word 0xd2cf0e80  ! 1937: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r9
	.word 0xde8e6000  ! 1938: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r15
	.word 0xdef6a000  ! 1939: STXA_I	stxa	%r15, [%r26 + 0x0000] %asi
	.word 0x87802073  ! 1940: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r16
	.word 0xdc9649e0  ! 1942: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r14
	.word 0x87802073  ! 1943: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f52000  ! 1944: STXA_I	stxa	%r11, [%r20 + 0x0000] %asi
	.word 0x87802072  ! 1945: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdede09e0  ! 1946: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r15
	mov	0x3d8, %r22
	wr_tick_cmpr_3_16:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf0, %g2
	or	%g4, 0xfd, %g4
	or	%g6, 0xd3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3f0, %r20
	.word 0xd0b7ce60  ! 1950: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	.word 0xd4dc2000  ! 1951: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	.word 0xd4bc2000  ! 1952: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	mov	0x28, %r25
	.word 0xd8b7ce80  ! 1954: STHA_R	stha	%r12, [%r31 + %r0] 0x74
	.word 0x87802073  ! 1955: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f78e40  ! 1956: STXA_R	stxa	%r11, [%r30 + %r0] 0x72
	mov	0x30, %r18
	.word 0xd8dde000  ! 1958: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r12
	.word 0xdccc0400  ! 1959: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r14
	.word 0x87802020  ! 1960: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1961: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeaf0e80  ! 1962: STBA_R	stba	%r15, [%r28 + %r0] 0x74
	.word 0xdaf46000  ! 1963: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	mov	0x48, %r17
	.word 0x87802074  ! 1965: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r19
	.word 0xd6f48400  ! 1967: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xd695c4a0  ! 1968: LDUHA_R	lduha	[%r23, %r0] 0x25, %r11
	.word 0xd286a000  ! 1969: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r9
	mov	0x18, %r17
	mov	0x30, %r18
	.word 0xd2b62000  ! 1972: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	.word 0xd2de6000  ! 1973: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r9
	mov	0x10, %r16
	.word 0x8780204f  ! 1975: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r18
	.word 0xd2dc2000  ! 1977: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r9
	.word 0x87802025  ! 1978: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0874e60  ! 1979: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r8
	mov	0x68, %r24
	.word 0xd2dfe000  ! 1981: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0xd286c9e0  ! 1982: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r9
	.word 0x87802020  ! 1983: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde970e60  ! 1984: LDUHA_R	lduha	[%r28, %r0] 0x73, %r15
	.word 0x87802020  ! 1985: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadf2000  ! 1986: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0xd8bf4e80  ! 1987: STDA_R	stda	%r12, [%r29 + %r0] 0x74
	.word 0xdaddc4a0  ! 1988: LDXA_R	ldxa	[%r23, %r0] 0x25, %r13
	mov	0x20, %r27
	.word 0xd6bc4400  ! 1990: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	mov	0x48, %r19
	.word 0xd6afa000  ! 1992: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6bc8400  ! 1993: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0x87802074  ! 1994: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1995: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8852000  ! 1996: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r12
	.word 0xd8d56000  ! 1997: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r12
	.word 0x87802025  ! 1998: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r27
	.word 0xd2f40400  ! 2000: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0x87802025  ! 2001: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6d44400  ! 2002: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r11
	.word 0x8780204f  ! 2003: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b4a000  ! 2004: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xd69c4400  ! 2005: LDDA_R	ldda	[%r17, %r0] 0x20, %r11
	mov	0x3d8, %r22
	mov	0x30, %r26
	.word 0xde946000  ! 2008: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r15
	.word 0xdaf649e0  ! 2009: STXA_R	stxa	%r13, [%r25 + %r0] 0x4f
	.word 0xd49ca000  ! 2010: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0x87802020  ! 2011: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bd6000  ! 2012: STDA_I	stda	%r10, [%r21 + 0x0000] %asi
	.word 0xd2978e40  ! 2013: LDUHA_R	lduha	[%r30, %r0] 0x72, %r9
	.word 0x8780204f  ! 2014: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 2015: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 2016: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2970e40  ! 2017: LDUHA_R	lduha	[%r28, %r0] 0x72, %r9
	.word 0xde8c2000  ! 2018: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	mov	0x50, %r18
	.word 0xde9ca000  ! 2020: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	mov	0x38, %r26
	mov	0x48, %r17
	.word 0xd08e49e0  ! 2023: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r8
	mov	0x68, %r26
	.word 0xd894e000  ! 2025: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r12
	mov	0x78, %r18
	.word 0x87802074  ! 2027: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8cfe000  ! 2028: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xd6ac8400  ! 2029: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0x87802072  ! 2030: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcaf2000  ! 2031: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdea7ce60  ! 2032: STWA_R	stwa	%r15, [%r31 + %r0] 0x73
	mov	0x50, %r24
	.word 0xdaf7a000  ! 2034: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdaf689e0  ! 2035: STXA_R	stxa	%r13, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 2036: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c8, %r23
	.word 0x87802025  ! 2038: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2af4e80  ! 2039: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	.word 0xdeb76000  ! 2040: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	mov	0x30, %r27
	.word 0xded76000  ! 2042: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0xd0d689e0  ! 2043: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r8
	.word 0x87802020  ! 2044: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r20
	.word 0xd4bec9e0  ! 2046: STDA_R	stda	%r10, [%r27 + %r0] 0x4f
	mov	0x20, %r17
	mov	0x38, %r17
	.word 0xd29ca000  ! 2049: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	mov	0x58, %r17
	.word 0xd2aca000  ! 2051: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	mov	0x60, %r27
	.word 0xd2f46000  ! 2053: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 2054: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r19
	mov	0x7f8, %r21
	.word 0xd2d7a000  ! 2057: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0x87802025  ! 2058: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b42000  ! 2059: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 2060: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2bfe000  ! 2061: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 2062: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd294e000  ! 2063: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	.word 0xd2ac2000  ! 2064: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 2065: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4bfce40  ! 2066: STDA_R	stda	%r10, [%r31 + %r0] 0x72
	.word 0xd8df0e40  ! 2067: LDXA_R	ldxa	[%r28, %r0] 0x72, %r12
	.word 0xdcacc400  ! 2068: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0xd2ade000  ! 2069: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	wr_tick_cmpr_3_17:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x8e, %g2
	or	%g4, 0x98, %g4
	or	%g6, 0xc6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x8, %r25
	.word 0x87802020  ! 2072: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r24
	.word 0xd29ca000  ! 2074: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	.word 0xd2ac6000  ! 2075: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd6a74e80  ! 2076: STWA_R	stwa	%r11, [%r29 + %r0] 0x74
	mov	0x3f0, %r23
	.word 0xd2ace000  ! 2078: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0xdcb7ce80  ! 2079: STHA_R	stha	%r14, [%r31 + %r0] 0x74
	.word 0xdc9c2000  ! 2080: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r14
	.word 0xdcaca000  ! 2081: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xdcbce000  ! 2082: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xdca46000  ! 2083: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xd08649e0  ! 2084: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r8
	mov	0x3f0, %r23
	mov	0x20, %r27
	.word 0xd2cdc4a0  ! 2087: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r9
	.word 0xdaf42000  ! 2088: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	mov	0x10, %r27
	.word 0xdca4c400  ! 2090: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xd6f609e0  ! 2091: STXA_R	stxa	%r11, [%r24 + %r0] 0x4f
	.word 0xdaa42000  ! 2092: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0xdabca000  ! 2093: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xda8c2000  ! 2094: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r13
	.word 0xd2c44400  ! 2095: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	.word 0x87802074  ! 2096: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 2097: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd89fe000  ! 2098: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0xd6848400  ! 2099: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	mov	0x7f8, %r21
	.word 0xd8a7a000  ! 2101: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd2bf0e80  ! 2102: STDA_R	stda	%r9, [%r28 + %r0] 0x74
	.word 0x87802074  ! 2103: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b42000  ! 2104: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xdcacc400  ! 2105: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0xde870e60  ! 2106: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r15
	mov	0x7c8, %r22
	.word 0xdcaca000  ! 2108: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xdcc46000  ! 2109: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2110: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r22
	mov	0x3d8, %r20
	.word 0xdc97ce60  ! 2113: LDUHA_R	lduha	[%r31, %r0] 0x73, %r14
	wr_tick_cmpr_3_18:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xac, %g2
	or	%g4, 0xc9, %g4
	or	%g6, 0xfc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x60, %r17
	mov	0x58, %r26
	.word 0xdea4a000  ! 2117: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 2118: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2119: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2a78e40  ! 2120: STWA_R	stwa	%r9, [%r30 + %r0] 0x72
	mov	0x3e0, %r20
	.word 0xd4a6e000  ! 2122: STWA_I	stwa	%r10, [%r27 + 0x0000] %asi
	.word 0xdadc4400  ! 2123: LDXA_R	ldxa	[%r17, %r0] 0x20, %r13
	.word 0xdeac4400  ! 2124: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0xd2bea000  ! 2125: STDA_I	stda	%r9, [%r26 + 0x0000] %asi
	mov	0x50, %r26
	.word 0xd8b7ce40  ! 2127: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0xd0a649e0  ! 2128: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	.word 0x87802073  ! 2129: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2ae49e0  ! 2130: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	.word 0xd08c4400  ! 2131: LDUBA_R	lduba	[%r17, %r0] 0x20, %r8
	mov	0x8, %r16
	.word 0x87802072  ! 2133: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf40400  ! 2134: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xd8b48400  ! 2135: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0xdabe6000  ! 2136: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	.word 0xdacea000  ! 2137: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r13
	.word 0xda86a000  ! 2138: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r13
	.word 0xdaa62000  ! 2139: STWA_I	stwa	%r13, [%r24 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xd8af8e60  ! 2141: STBA_R	stba	%r12, [%r30 + %r0] 0x73
	.word 0xdab40400  ! 2142: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	mov	0x60, %r18
	mov	0x0, %r19
	.word 0xd8f6a000  ! 2145: STXA_I	stxa	%r12, [%r26 + 0x0000] %asi
	.word 0xd8b66000  ! 2146: STHA_I	stha	%r12, [%r25 + 0x0000] %asi
	.word 0xd2c584a0  ! 2147: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r9
	.word 0xd2a6e000  ! 2148: STWA_I	stwa	%r9, [%r27 + 0x0000] %asi
	.word 0xd2be2000  ! 2149: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	.word 0xd2ce2000  ! 2150: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r9
	.word 0xd286e000  ! 2151: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r9
	.word 0xd4870e40  ! 2152: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r10
	.word 0xd6d6a000  ! 2153: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r11
	mov	0x8, %r27
	.word 0xd69e2000  ! 2155: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r11
	mov	0x10, %r27
	.word 0xd2f689e0  ! 2157: STXA_R	stxa	%r9, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 2158: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r23
	.word 0xd0f46000  ! 2160: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 2161: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2162: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r25
	.word 0xd0d44400  ! 2164: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r8
	.word 0xd4b40400  ! 2165: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0x87802073  ! 2166: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r25
	.word 0xdad72000  ! 2168: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	mov	0x18, %r24
	.word 0xdab7e000  ! 2170: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xd4afce40  ! 2171: STBA_R	stba	%r10, [%r31 + %r0] 0x72
	.word 0x87802073  ! 2172: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r27
	.word 0xdabf2000  ! 2174: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	mov	0x60, %r19
	mov	0x3f0, %r22
	mov	0x7d8, %r23
	.word 0xdaf76000  ! 2178: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 2179: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2180: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabca000  ! 2181: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdacca000  ! 2182: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	.word 0xdadca000  ! 2183: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0xdaf42000  ! 2184: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0xd88e89e0  ! 2185: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r12
	mov	0x3d0, %r20
	.word 0x87802020  ! 2187: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2188: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf70e80  ! 2189: STXA_R	stxa	%r14, [%r28 + %r0] 0x74
	.word 0xdcf42000  ! 2190: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0xdea48400  ! 2191: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0x87802074  ! 2192: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde844400  ! 2193: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	.word 0x87802025  ! 2194: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c0, %r23
	.word 0xdcada000  ! 2196: STBA_I	stba	%r14, [%r22 + 0x0000] %asi
	mov	0x60, %r18
	.word 0xd2844400  ! 2198: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	mov	0x40, %r26
	.word 0xd0a584a0  ! 2200: STWA_R	stwa	%r8, [%r22 + %r0] 0x25
	.word 0x87802025  ! 2201: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2202: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r24
	.word 0xd08ca000  ! 2204: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xd2f7ce60  ! 2205: STXA_R	stxa	%r9, [%r31 + %r0] 0x73
	.word 0x87802020  ! 2206: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a689e0  ! 2207: STWA_R	stwa	%r12, [%r26 + %r0] 0x4f
	.word 0xd0df6000  ! 2208: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0b76000  ! 2210: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd08fe000  ! 2211: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	mov	0x3c0, %r21
	.word 0xd0b74e60  ! 2213: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	.word 0xdef7a000  ! 2214: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	mov	0x7c0, %r21
	.word 0xdaae09e0  ! 2216: STBA_R	stba	%r13, [%r24 + %r0] 0x4f
	.word 0xd287e000  ! 2217: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	mov	0x78, %r24
	mov	0x60, %r17
	.word 0xd2b7a000  ! 2220: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd29f6000  ! 2221: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	mov	0x3d0, %r23
	.word 0xd48689e0  ! 2223: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r10
	.word 0xd68d44a0  ! 2224: LDUBA_R	lduba	[%r21, %r0] 0x25, %r11
	.word 0xdeb72000  ! 2225: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xdeafe000  ! 2226: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xde844400  ! 2227: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	mov	0x7e8, %r23
	.word 0xd6f7ce80  ! 2229: STXA_R	stxa	%r11, [%r31 + %r0] 0x74
	.word 0xd4cf2000  ! 2230: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd49f2000  ! 2231: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 2232: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd494a000  ! 2233: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r10
	.word 0xd4f4a000  ! 2234: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	wr_tick_cmpr_3_19:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd1, %g2
	or	%g4, 0xf1, %g4
	or	%g6, 0x9b, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802025  ! 2236: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0cf8e40  ! 2237: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r8
	mov	0x8, %r27
	.word 0xd88e89e0  ! 2239: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r12
	.word 0xd4af8e80  ! 2240: STBA_R	stba	%r10, [%r30 + %r0] 0x74
	.word 0xd4cec9e0  ! 2241: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r10
	.word 0xd894a000  ! 2242: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r12
	.word 0xd8c4e000  ! 2243: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	mov	0x48, %r16
	.word 0xd4d44400  ! 2245: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0xdcc4e000  ! 2246: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r14
	.word 0xde8d44a0  ! 2247: LDUBA_R	lduba	[%r21, %r0] 0x25, %r15
	.word 0xd48c0400  ! 2248: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	.word 0xdc8c2000  ! 2249: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r14
	.word 0xd0b74e80  ! 2250: STHA_R	stha	%r8, [%r29 + %r0] 0x74
	.word 0xd6ac4400  ! 2251: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xd8dd44a0  ! 2252: LDXA_R	ldxa	[%r21, %r0] 0x25, %r12
	.word 0xde8c6000  ! 2253: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0x87802020  ! 2254: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebe2000  ! 2255: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	.word 0x8780204f  ! 2256: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd69f0e60  ! 2257: LDDA_R	ldda	[%r28, %r0] 0x73, %r11
	.word 0xdedcc400  ! 2258: LDXA_R	ldxa	[%r19, %r0] 0x20, %r15
	.word 0xd2f56000  ! 2259: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	.word 0xd2ad6000  ! 2260: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0x87802074  ! 2261: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r25
	.word 0xd2c7a000  ! 2263: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	wr_tick_cmpr_3_20:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xab, %g2
	or	%g4, 0x8f, %g4
	or	%g6, 0xc5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	wr_tick_cmpr_3_21:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xee, %g2
	or	%g4, 0xd8, %g4
	or	%g6, 0xfb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2876000  ! 2266: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2267: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bf6000  ! 2268: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 2269: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f8, %r23
	.word 0xd08f8e40  ! 2271: LDUBA_R	lduba	[%r30, %r0] 0x72, %r8
	.word 0xd885e000  ! 2272: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r12
	.word 0xda940400  ! 2273: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	.word 0xd0d56000  ! 2274: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r8
	.word 0x87802020  ! 2275: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdecf8e60  ! 2276: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r15
	.word 0xdebc6000  ! 2277: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xdedc6000  ! 2278: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r15
	.word 0xde846000  ! 2279: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0x87802020  ! 2280: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2af0e60  ! 2281: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	mov	0x8, %r26
	.word 0xd6d5a000  ! 2283: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r11
	mov	0x50, %r17
	.word 0xd685a000  ! 2285: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r11
	.word 0x87802072  ! 2286: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd68d2000  ! 2287: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r11
	.word 0xd6bda000  ! 2288: STDA_I	stda	%r11, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 2289: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r17
	.word 0xd6bd2000  ! 2291: STDA_I	stda	%r11, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 2292: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedfce40  ! 2293: LDXA_R	ldxa	[%r31, %r0] 0x72, %r15
	mov	0x0, %r18
	.word 0xd4bf0e80  ! 2295: STDA_R	stda	%r10, [%r28 + %r0] 0x74
	.word 0xd6a62000  ! 2296: STWA_I	stwa	%r11, [%r24 + 0x0000] %asi
	mov	0x20, %r18
	.word 0x8780204f  ! 2298: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xded74e60  ! 2299: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r15
	.word 0xdab72000  ! 2300: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xd2b78e80  ! 2301: STHA_R	stha	%r9, [%r30 + %r0] 0x74
	.word 0xdab72000  ! 2302: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 2303: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r24
	.word 0xdabc6000  ! 2305: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xdabc2000  ! 2306: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xdadca000  ! 2307: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0xdacce000  ! 2308: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r13
	.word 0xd2d6c9e0  ! 2309: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r9
	.word 0xd6dc6000  ! 2310: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r11
	mov	0x38, %r16
	mov	0x68, %r26
	.word 0xd6bce000  ! 2313: STDA_I	stda	%r11, [%r19 + 0x0000] %asi
	.word 0xde8609e0  ! 2314: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r15
	.word 0xd6b7ce40  ! 2315: STHA_R	stha	%r11, [%r31 + %r0] 0x72
	.word 0xd8a42000  ! 2316: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8c46000  ! 2317: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r12
	mov	0x50, %r25
	.word 0xd8a4e000  ! 2319: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	mov	0x10, %r25
	.word 0xd4af8e60  ! 2321: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	.word 0xdeb46000  ! 2322: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0xd8f70e40  ! 2323: STXA_R	stxa	%r12, [%r28 + %r0] 0x72
	.word 0xd89fce40  ! 2324: LDDA_R	ldda	[%r31, %r0] 0x72, %r12
	.word 0xd4ace000  ! 2325: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0xd4dc6000  ! 2326: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	mov	0x60, %r26
	.word 0xd2f4c400  ! 2328: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xd08ca000  ! 2329: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xd08ce000  ! 2330: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xde9544a0  ! 2331: LDUHA_R	lduha	[%r21, %r0] 0x25, %r15
	.word 0xd88c4400  ! 2332: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0xdcd70e40  ! 2333: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r14
	mov	0x7f0, %r20
	.word 0xdea74e80  ! 2335: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	.word 0xd2f78e40  ! 2336: STXA_R	stxa	%r9, [%r30 + %r0] 0x72
	mov	0x10, %r18
	.word 0x8780204f  ! 2338: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r19
	.word 0xd8a46000  ! 2340: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8b4a000  ! 2341: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0xd89ca000  ! 2342: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r12
	.word 0xd8f42000  ! 2343: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8ace000  ! 2344: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0xd8842000  ! 2345: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2346: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8544a0  ! 2347: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r15
	.word 0xd2c689e0  ! 2348: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r9
	.word 0xd8b78e60  ! 2349: STHA_R	stha	%r12, [%r30 + %r0] 0x73
	.word 0xdeb7e000  ! 2350: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xdec7e000  ! 2351: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xd8cf0e80  ! 2352: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r12
	mov	0x70, %r27
	.word 0xd8a74e40  ! 2354: STWA_R	stwa	%r12, [%r29 + %r0] 0x72
	mov	0x68, %r17
	mov	0x30, %r27
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802020  ! 2358: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r23
	.word 0x87802072  ! 2360: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4d5a000  ! 2361: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r10
	.word 0xd6ce49e0  ! 2362: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r11
	.word 0xdc8d2000  ! 2363: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 2364: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r19
	.word 0xdc872000  ! 2366: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	mov	0x3f0, %r22
	.word 0xdc8f4e40  ! 2368: LDUBA_R	lduba	[%r29, %r0] 0x72, %r14
	.word 0xd88c4400  ! 2369: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0xdeb72000  ! 2370: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xdec4c400  ! 2371: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	.word 0xdadfa000  ! 2372: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	mov	0x7f0, %r20
	.word 0xdaaf2000  ! 2374: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdaf76000  ! 2375: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	mov	0x8, %r26
	.word 0xda9f6000  ! 2377: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2378: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29d84a0  ! 2379: LDDA_R	ldda	[%r22, %r0] 0x25, %r9
	.word 0xd48c8400  ! 2380: LDUBA_R	lduba	[%r18, %r0] 0x20, %r10
	mov	0x0, %r17
	mov	0x30, %r19
	mov	0x68, %r18
	.word 0xd8d46000  ! 2384: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	.word 0xd4b48400  ! 2385: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0x87802020  ! 2386: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda86e000  ! 2387: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r13
	.word 0xd6bdc4a0  ! 2388: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	.word 0xd4a48400  ! 2389: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0x87802072  ! 2390: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8cf8e60  ! 2391: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r12
	wr_tick_cmpr_3_22:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x9b, %g2
	or	%g4, 0xdd, %g4
	or	%g6, 0xba, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd094c400  ! 2393: LDUHA_R	lduha	[%r19, %r0] 0x20, %r8
	.word 0xd2de6000  ! 2394: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r9
	.word 0xd2f6e000  ! 2395: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	.word 0xdaad84a0  ! 2396: STBA_R	stba	%r13, [%r22 + %r0] 0x25
	.word 0x8780204f  ! 2397: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdac6e000  ! 2398: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 2399: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdacc4400  ! 2400: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	.word 0x87802072  ! 2401: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2402: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f78e60  ! 2403: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	.word 0xd8a7e000  ! 2404: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd6974e40  ! 2405: LDUHA_R	lduha	[%r29, %r0] 0x72, %r11
	.word 0x87802072  ! 2406: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f42000  ! 2407: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	mov	0x8, %r19
	mov	0x3e8, %r20
	.word 0xd49f8e40  ! 2410: LDDA_R	ldda	[%r30, %r0] 0x72, %r10
	.word 0xd0bc2000  ! 2411: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	mov	0x20, %r17
	.word 0xd0f4e000  ! 2413: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xdaad04a0  ! 2414: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	.word 0xdccca000  ! 2415: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	.word 0xd6bfce60  ! 2416: STDA_R	stda	%r11, [%r31 + %r0] 0x73
	.word 0xdaf689e0  ! 2417: STXA_R	stxa	%r13, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 2418: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r17
	.word 0xd0bd84a0  ! 2420: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0xd4bea000  ! 2421: STDA_I	stda	%r10, [%r26 + 0x0000] %asi
	.word 0xd6af8e60  ! 2422: STBA_R	stba	%r11, [%r30 + %r0] 0x73
	.word 0xd0f62000  ! 2423: STXA_I	stxa	%r8, [%r24 + 0x0000] %asi
	.word 0xd4bfce40  ! 2424: STDA_R	stda	%r10, [%r31 + %r0] 0x72
	.word 0xd4ae6000  ! 2425: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0x8780204f  ! 2426: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2427: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r24
	mov	0x7c8, %r20
	mov	0x8, %r27
	mov	0x18, %r17
	mov	0x7c0, %r21
	.word 0xd69f8e60  ! 2433: LDDA_R	ldda	[%r30, %r0] 0x73, %r11
	.word 0xde8c2000  ! 2434: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	.word 0x87802072  ! 2435: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xded66000  ! 2436: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r15
	.word 0xdea62000  ! 2437: STWA_I	stwa	%r15, [%r24 + 0x0000] %asi
	.word 0xd4dc0400  ! 2438: LDXA_R	ldxa	[%r16, %r0] 0x20, %r10
	.word 0xd29f0e40  ! 2439: LDDA_R	ldda	[%r28, %r0] 0x72, %r9
	mov	0x18, %r27
	mov	0x68, %r26
	.word 0x87802073  ! 2442: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b44400  ! 2443: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	mov	0x20, %r19
	mov	0x0, %r18
	mov	0x58, %r26
	mov	0x7e8, %r22
	.word 0xd296a000  ! 2448: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r9
	.word 0xd887ce40  ! 2449: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r12
	.word 0xdca40400  ! 2450: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xdacea000  ! 2451: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r13
	wr_tick_cmpr_3_23:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe7, %g2
	or	%g4, 0x88, %g4
	or	%g6, 0xf4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4b6c9e0  ! 2453: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0xd48e6000  ! 2454: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r10
	.word 0x87802020  ! 2455: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2456: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4bca000  ! 2457: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0xd8d689e0  ! 2458: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r12
	.word 0xdabca000  ! 2459: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 2460: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdacd6000  ! 2461: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r13
	.word 0xd0f44400  ! 2462: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd6dd2000  ! 2463: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r11
	.word 0xd6b5a000  ! 2464: STHA_I	stha	%r11, [%r22 + 0x0000] %asi
	.word 0xd6dde000  ! 2465: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r11
	.word 0xd4d40400  ! 2466: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	.word 0xdc9609e0  ! 2467: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r14
	.word 0xdc8d2000  ! 2468: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r14
	.word 0xdace09e0  ! 2469: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r13
	.word 0x87802020  ! 2470: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r21
	.word 0x87802020  ! 2472: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8848400  ! 2473: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r12
	mov	0x7e0, %r20
	.word 0xdef4e000  ! 2475: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xd6cd84a0  ! 2476: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r11
	.word 0xdca40400  ! 2477: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	mov	0x20, %r27
	.word 0xd6844400  ! 2479: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r11
	.word 0xdcf4a000  ! 2480: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcb42000  ! 2481: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xdca4e000  ! 2482: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0xdc9f4e60  ! 2483: LDDA_R	ldda	[%r29, %r0] 0x73, %r14
	.word 0xdaa7ce40  ! 2484: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	mov	0x7f0, %r22
	.word 0xd8f42000  ! 2486: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xd4ac0400  ! 2487: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0x87802025  ! 2488: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 2489: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb5a000  ! 2490: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	.word 0xd09c0400  ! 2491: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	.word 0x8780204f  ! 2492: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r27
	.word 0xda846000  ! 2494: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r13
	.word 0xdab46000  ! 2495: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0xd8878e60  ! 2496: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r12
	.word 0xd8878e80  ! 2497: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r12
	.word 0xd49fce80  ! 2498: LDDA_R	ldda	[%r31, %r0] 0x74, %r10
	mov	0x7d8, %r20
	mov	0x7f8, %r21
	mov	0x7e8, %r21
	.word 0xde87ce60  ! 2502: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r15
	.word 0xdef7ce60  ! 2503: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0xdc9d44a0  ! 2504: LDDA_R	ldda	[%r21, %r0] 0x25, %r14
	.word 0xdcac6000  ! 2505: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xdc87ce60  ! 2506: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r14
	.word 0xd28f8e60  ! 2507: LDUBA_R	lduba	[%r30, %r0] 0x73, %r9
	.word 0x87802020  ! 2508: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8584a0  ! 2509: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r15
	.word 0xd0cca000  ! 2510: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	mov	0x40, %r16
	.word 0xda970e80  ! 2512: LDUHA_R	lduha	[%r28, %r0] 0x74, %r13
	.word 0xd49ca000  ! 2513: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd4d4e000  ! 2514: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0xdabf8e80  ! 2515: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	.word 0xd4a4e000  ! 2516: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xd4b78e80  ! 2517: STHA_R	stha	%r10, [%r30 + %r0] 0x74
	.word 0xd4c42000  ! 2518: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r10
	.word 0xd494a000  ! 2519: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r10
	.word 0xd4cc2000  ! 2520: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	mov	0x3d8, %r21
	.word 0xda8c4400  ! 2522: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0xdecf8e60  ! 2523: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r15
	.word 0xdebc2000  ! 2524: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xde84a000  ! 2525: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	mov	0x3c0, %r23
	.word 0xdec46000  ! 2527: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	.word 0xdeac2000  ! 2528: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xdecc6000  ! 2530: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r15
	.word 0x87802020  ! 2531: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde942000  ! 2532: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	.word 0xd6b4c400  ! 2533: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xdcf4c400  ! 2534: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xd68ce000  ! 2535: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2536: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b4e000  ! 2537: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 2538: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4c48400  ! 2539: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r10
	.word 0xd4dcc400  ! 2540: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0xdebc0400  ! 2541: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0xd8d7ce40  ! 2542: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r12
	.word 0xd0c7ce80  ! 2543: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r8
	mov	0x7e8, %r23
	.word 0x87802020  ! 2545: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeafa000  ! 2546: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xd8f584a0  ! 2547: STXA_R	stxa	%r12, [%r22 + %r0] 0x25
	mov	0x48, %r25
	.word 0xd8b7a000  ! 2549: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xd8f7e000  ! 2550: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xd88fe000  ! 2552: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8b72000  ! 2553: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd6cc4400  ! 2554: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	.word 0xd2afe000  ! 2555: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd2f7ce60  ! 2556: STXA_R	stxa	%r9, [%r31 + %r0] 0x73
	.word 0xdca72000  ! 2557: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xd6d44400  ! 2558: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r11
	.word 0xd4b74e40  ! 2559: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	.word 0xdad7ce80  ! 2560: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r13
	mov	0x7d8, %r23
	mov	0x78, %r16
	mov	0x7d8, %r23
	.word 0xd4bf4e80  ! 2564: STDA_R	stda	%r10, [%r29 + %r0] 0x74
	mov	0x70, %r17
	mov	0x3f8, %r22
	.word 0x8780204f  ! 2567: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcdde000  ! 2568: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	.word 0xdc9d6000  ! 2569: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r14
	.word 0xd2a504a0  ! 2570: STWA_R	stwa	%r9, [%r20 + %r0] 0x25
	.word 0xdedc4400  ! 2571: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	mov	0x70, %r24
	.word 0xd8b5e000  ! 2573: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	.word 0xd8dde000  ! 2574: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r12
	.word 0xdeb649e0  ! 2575: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	.word 0xd8ae89e0  ! 2576: STBA_R	stba	%r12, [%r26 + %r0] 0x4f
	.word 0xde8f8e60  ! 2577: LDUBA_R	lduba	[%r30, %r0] 0x73, %r15
	.word 0xda95e000  ! 2578: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r13
	.word 0xdaf56000  ! 2579: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	.word 0xda9d6000  ! 2580: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r13
	.word 0xd4afce80  ! 2581: STBA_R	stba	%r10, [%r31 + %r0] 0x74
	.word 0xd8ad6000  ! 2582: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	.word 0xd8cf8e60  ! 2583: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r12
	.word 0xdec5e000  ! 2584: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r15
	.word 0xdea56000  ! 2585: STWA_I	stwa	%r15, [%r21 + 0x0000] %asi
	.word 0x87802025  ! 2586: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 2587: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6af8e40  ! 2588: STBA_R	stba	%r11, [%r30 + %r0] 0x72
	.word 0xd4d5e000  ! 2589: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r10
	.word 0x87802020  ! 2590: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r25
	.word 0xd6b4c400  ! 2592: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xd8cfce60  ! 2593: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r12
	mov	0x7c0, %r20
	.word 0xdaa6c9e0  ! 2595: STWA_R	stwa	%r13, [%r27 + %r0] 0x4f
	.word 0xd4ade000  ! 2596: STBA_I	stba	%r10, [%r23 + 0x0000] %asi
	.word 0xd4ade000  ! 2597: STBA_I	stba	%r10, [%r23 + 0x0000] %asi
	.word 0xd4956000  ! 2598: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r10
	wr_tick_cmpr_3_24:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x9b, %g2
	or	%g4, 0xe3, %g4
	or	%g6, 0x8d, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4bf4e40  ! 2600: STDA_R	stda	%r10, [%r29 + %r0] 0x72
	.word 0x87802020  ! 2601: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2602: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bd04a0  ! 2603: STDA_R	stda	%r12, [%r20 + %r0] 0x25
	.word 0xd88e09e0  ! 2604: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r12
	.word 0xd2c4c400  ! 2605: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0xd2cc6000  ! 2606: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	.word 0xd2c4a000  ! 2607: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	mov	0x30, %r16
	mov	0x38, %r26
	.word 0xdab5c4a0  ! 2610: STHA_R	stha	%r13, [%r23 + %r0] 0x25
	.word 0x87802072  ! 2611: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef544a0  ! 2612: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	.word 0x87802020  ! 2613: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2614: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2615: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0d7a000  ! 2616: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0x87802020  ! 2617: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a6a000  ! 2618: STWA_I	stwa	%r8, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 2619: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a689e0  ! 2620: STWA_R	stwa	%r11, [%r26 + %r0] 0x4f
	mov	0x10, %r18
	.word 0x87802025  ! 2622: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c8, %r23
	mov	0x40, %r17
	.word 0xd4c62000  ! 2625: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r10
	.word 0xd48e2000  ! 2626: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r10
	.word 0xd49ea000  ! 2627: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	.word 0xd4cee000  ! 2628: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r10
	.word 0x87802025  ! 2629: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4c46000  ! 2630: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r10
	.word 0xd4f46000  ! 2631: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0xd0d70e40  ! 2632: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r8
	.word 0xd8dc2000  ! 2633: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	wr_tick_cmpr_3_25:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf2, %g2
	or	%g4, 0xe0, %g4
	or	%g6, 0xe2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7d8, %r22
	.word 0xd8f46000  ! 2636: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 2637: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd28d44a0  ! 2638: LDUBA_R	lduba	[%r21, %r0] 0x25, %r9
	.word 0x87802072  ! 2639: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r26
	.word 0xdaa74e40  ! 2641: STWA_R	stwa	%r13, [%r29 + %r0] 0x72
	.word 0xd686e000  ! 2642: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r11
	.word 0xd6de6000  ! 2643: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r11
	.word 0xd68ea000  ! 2644: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r11
	.word 0xd6a6a000  ! 2645: STWA_I	stwa	%r11, [%r26 + 0x0000] %asi
	mov	0x0, %r18
	mov	0x3f8, %r22
	.word 0x87802074  ! 2648: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f4a000  ! 2649: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 2650: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d7e000  ! 2651: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	.word 0xd6cfe000  ! 2652: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0xd6b7a000  ! 2653: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd6df2000  ! 2654: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6978e80  ! 2655: LDUHA_R	lduha	[%r30, %r0] 0x74, %r11
	.word 0xde876000  ! 2656: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0x87802072  ! 2657: WRASI_I	wr	%r0, 0x0072, %asi
	wr_tick_cmpr_3_26:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x99, %g2
	or	%g4, 0xc3, %g4
	or	%g6, 0xee, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdecfe000  ! 2659: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 2660: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 2661: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r19
	.word 0xd6cfce80  ! 2663: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r11
	.word 0xde95a000  ! 2664: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r15
	.word 0xdcac0400  ! 2665: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xd09da000  ! 2666: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r8
	.word 0xd6d5c4a0  ! 2667: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r11
	.word 0xd2bf4e60  ! 2668: STDA_R	stda	%r9, [%r29 + %r0] 0x73
	mov	0x0, %r19
	.word 0xdef70e60  ! 2670: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	.word 0xd495e000  ! 2671: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r10
	.word 0xd4f5a000  ! 2672: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	.word 0xd4d52000  ! 2673: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r10
	.word 0xd4f52000  ! 2674: STXA_I	stxa	%r10, [%r20 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0x87802020  ! 2676: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c74e40  ! 2677: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r10
	.word 0xd8bce000  ! 2678: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd4d48400  ! 2679: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	.word 0xd4a46000  ! 2680: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 2681: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r19
	.word 0xd4cc2000  ! 2683: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	.word 0xd4dce000  ! 2684: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	mov	0x18, %r19
	.word 0xd6f74e80  ! 2686: STXA_R	stxa	%r11, [%r29 + %r0] 0x74
	.word 0x87802020  ! 2687: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b74e40  ! 2688: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	.word 0x87802073  ! 2689: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8cf6000  ! 2690: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0xd8a7e000  ! 2691: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xde8fce40  ! 2692: LDUBA_R	lduba	[%r31, %r0] 0x72, %r15
	mov	0x48, %r16
	.word 0xde8c8400  ! 2694: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	mov	0x20, %r16
	mov	0x3f8, %r23
	.word 0x87802020  ! 2697: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdce000  ! 2698: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r14
	mov	0x40, %r24
	.word 0xdca4e000  ! 2700: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcb4e000  ! 2701: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xda978e40  ! 2702: LDUHA_R	lduha	[%r30, %r0] 0x72, %r13
	.word 0x87802020  ! 2703: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2704: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeafe000  ! 2705: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	mov	0x60, %r19
	.word 0xde8fa000  ! 2707: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	mov	0x3c0, %r20
	.word 0xdebf2000  ! 2709: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xd0a584a0  ! 2710: STWA_R	stwa	%r8, [%r22 + %r0] 0x25
	.word 0xdcbf6000  ! 2711: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdcdf2000  ! 2712: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdc9fe000  ! 2713: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xdef4c400  ! 2714: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xd4a70e60  ! 2715: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	.word 0x87802025  ! 2716: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r27
	.word 0xdab46000  ! 2718: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0xda9ce000  ! 2719: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r13
	.word 0xd8f48400  ! 2720: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xd8846000  ! 2721: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2722: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd89f4e40  ! 2723: LDDA_R	ldda	[%r29, %r0] 0x72, %r12
	.word 0xd485e000  ! 2724: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r10
	.word 0xd6bfce60  ! 2725: STDA_R	stda	%r11, [%r31 + %r0] 0x73
	.word 0xdc840400  ! 2726: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	.word 0xd2b74e60  ! 2727: STHA_R	stha	%r9, [%r29 + %r0] 0x73
	.word 0xd0af8e40  ! 2728: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0x87802073  ! 2729: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8ad6000  ! 2730: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	.word 0xd8b52000  ! 2731: STHA_I	stha	%r12, [%r20 + 0x0000] %asi
	.word 0x87802025  ! 2732: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f0, %r20
	.word 0xd8874e80  ! 2734: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r12
	.word 0xd2f40400  ! 2735: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	mov	0x58, %r26
	.word 0xd8c78e80  ! 2737: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r12
	.word 0xd4b78e80  ! 2738: STHA_R	stha	%r10, [%r30 + %r0] 0x74
	.word 0x87802074  ! 2739: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8c609e0  ! 2740: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r12
	.word 0xd2bfce60  ! 2741: STDA_R	stda	%r9, [%r31 + %r0] 0x73
	mov	0x3c0, %r22
	.word 0xd6cce000  ! 2743: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r11
	mov	0x3d8, %r22
	.word 0xd6cc2000  ! 2745: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	mov	0x3e0, %r21
	mov	0x10, %r16
	.word 0xd6bc2000  ! 2748: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	mov	0x10, %r25
	.word 0xdcce49e0  ! 2750: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r14
	.word 0xd0ac4400  ! 2751: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	ta	T_CHANGE_PRIV	! macro
	mov	0x58, %r27
	mov	0x78, %r16
	mov	0x8, %r25
	mov	0x48, %r25
	.word 0xd0bce000  ! 2757: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0xd0cc6000  ! 2758: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	.word 0xd0f46000  ! 2759: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0f74e40  ! 2760: STXA_R	stxa	%r8, [%r29 + %r0] 0x72
	mov	0x7f8, %r21
	.word 0xdec74e60  ! 2762: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r15
	.word 0xd2c48400  ! 2763: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0dc2000  ! 2765: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	.word 0xd0f46000  ! 2766: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0846000  ! 2767: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	mov	0x8, %r17
	mov	0x18, %r16
	mov	0x7e8, %r23
	.word 0xd0bca000  ! 2771: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 2772: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd084e000  ! 2773: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	.word 0xd0b46000  ! 2774: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	mov	0x7f0, %r21
	mov	0x7e8, %r20
	mov	0x60, %r24
	mov	0x20, %r17
	.word 0xde9504a0  ! 2779: LDUHA_R	lduha	[%r20, %r0] 0x25, %r15
	.word 0xd6af0e60  ! 2780: STBA_R	stba	%r11, [%r28 + %r0] 0x73
	.word 0x87802072  ! 2781: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6dce000  ! 2782: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0xd6ac6000  ! 2783: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xd0d689e0  ! 2784: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r8
	.word 0x87802020  ! 2785: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r24
	.word 0xd4978e60  ! 2787: LDUHA_R	lduha	[%r30, %r0] 0x73, %r10
	.word 0x87802020  ! 2788: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a40400  ! 2789: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	.word 0xd4cc0400  ! 2790: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r10
	.word 0xdabfce80  ! 2791: STDA_R	stda	%r13, [%r31 + %r0] 0x74
	.word 0xd0dcc400  ! 2792: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0xd48d2000  ! 2793: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0x87802072  ! 2794: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde944400  ! 2795: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	.word 0x87802020  ! 2796: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2797: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda94e000  ! 2798: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r13
	.word 0xdc978e40  ! 2799: LDUHA_R	lduha	[%r30, %r0] 0x72, %r14
	.word 0xd49689e0  ! 2800: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r10
	.word 0x87802073  ! 2801: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r19
	.word 0xdad7ce40  ! 2803: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r13
	.word 0xd29f4e60  ! 2804: LDDA_R	ldda	[%r29, %r0] 0x73, %r9
	.word 0x87802020  ! 2805: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2806: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f8, %r23
	mov	0x8, %r17
	.word 0x87802074  ! 2809: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb78e40  ! 2810: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xd4cc8400  ! 2811: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	.word 0xd8cd2000  ! 2812: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r12
	mov	0x28, %r17
	.word 0x87802074  ! 2814: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2815: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 2816: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4bfce80  ! 2817: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	.word 0xdab6e000  ! 2818: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	.word 0xda9e2000  ! 2819: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r13
	mov	0x3e0, %r22
	.word 0xd6cd44a0  ! 2821: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r11
	.word 0x8780204f  ! 2822: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r27
	.word 0xd6b584a0  ! 2824: STHA_R	stha	%r11, [%r22 + %r0] 0x25
	mov	0x68, %r18
	mov	0x38, %r27
	mov	0x48, %r27
	.word 0xdaa7ce40  ! 2828: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	.word 0xdcf70e60  ! 2829: STXA_R	stxa	%r14, [%r28 + %r0] 0x73
	wr_tick_cmpr_3_27:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc1, %g2
	or	%g4, 0xe3, %g4
	or	%g6, 0xc7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdabfe000  ! 2831: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xda872000  ! 2832: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0xde870e40  ! 2833: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r15
	.word 0xd48fa000  ! 2834: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	mov	0x30, %r17
	mov	0x60, %r17
	.word 0xd2af8e60  ! 2837: STBA_R	stba	%r9, [%r30 + %r0] 0x73
	.word 0xd2a7e000  ! 2838: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xdea48400  ! 2839: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0x87802020  ! 2840: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r26
	.word 0xdab6e000  ! 2842: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	.word 0xdeb609e0  ! 2843: STHA_R	stha	%r15, [%r24 + %r0] 0x4f
	.word 0xdecee000  ! 2844: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r15
	.word 0xdad78e40  ! 2845: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r13
	.word 0xd2d649e0  ! 2846: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r9
	.word 0x87802074  ! 2847: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacfa000  ! 2848: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0x87802072  ! 2849: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdad7a000  ! 2850: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0xdab76000  ! 2851: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdab72000  ! 2852: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xd48649e0  ! 2853: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r10
	.word 0xd29584a0  ! 2854: LDUHA_R	lduha	[%r22, %r0] 0x25, %r9
	mov	0x3e8, %r20
	.word 0x87802020  ! 2856: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_3_28:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xaa, %g2
	or	%g4, 0xc8, %g4
	or	%g6, 0xf1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7e0, %r23
	.word 0x87802072  ! 2859: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0f5e000  ! 2860: STXA_I	stxa	%r8, [%r23 + 0x0000] %asi
	.word 0xdcb44400  ! 2861: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	mov	0x3e0, %r22
	.word 0xdaa6c9e0  ! 2863: STWA_R	stwa	%r13, [%r27 + %r0] 0x4f
	mov	0x60, %r16
	.word 0xdef689e0  ! 2865: STXA_R	stxa	%r15, [%r26 + %r0] 0x4f
	.word 0xd08d2000  ! 2866: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r8
	.word 0xd0f5e000  ! 2867: STXA_I	stxa	%r8, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 2868: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_3_29:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xfb, %g2
	or	%g4, 0xc9, %g4
	or	%g6, 0xf5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7e8, %r22
	.word 0xd0ce6000  ! 2871: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r8
	mov	0x7d0, %r20
	.word 0xdc844400  ! 2873: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	mov	0x30, %r16
	mov	0x58, %r25
	.word 0xde8e2000  ! 2876: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r15
	.word 0xde97ce80  ! 2877: LDUHA_R	lduha	[%r31, %r0] 0x74, %r15
	.word 0xd28e2000  ! 2878: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	.word 0xdcd44400  ! 2879: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	.word 0xdcb609e0  ! 2880: STHA_R	stha	%r14, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 2881: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 2882: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a689e0  ! 2883: STWA_R	stwa	%r8, [%r26 + %r0] 0x4f
	mov	0x38, %r17
	.word 0xd6cc2000  ! 2885: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	.word 0xdccc4400  ! 2886: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r14
	mov	0x40, %r24
	.word 0xd48fce40  ! 2888: LDUBA_R	lduba	[%r31, %r0] 0x72, %r10
	.word 0xd0cce000  ! 2889: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 2890: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x0, %r24
	mov	0x38, %r17
	.word 0xd0952000  ! 2893: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 2894: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 2895: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2a4c400  ! 2896: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0xd0f48400  ! 2897: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0x87802074  ! 2898: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4848400  ! 2899: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r10
	.word 0x8780204f  ! 2900: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r25
	.word 0xdadfe000  ! 2902: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0x87802025  ! 2903: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2ac8400  ! 2904: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0x87802020  ! 2905: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd497e000  ! 2906: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	.word 0xd4a7e000  ! 2907: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd6844400  ! 2908: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r11
	.word 0xdaac8400  ! 2909: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0xdca74e80  ! 2910: STWA_R	stwa	%r14, [%r29 + %r0] 0x74
	mov	0x3c0, %r22
	.word 0xdacf2000  ! 2912: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xda876000  ! 2913: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0x87802072  ! 2914: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcd649e0  ! 2915: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r14
	.word 0xd8d76000  ! 2916: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	mov	0x10, %r26
	mov	0x18, %r27
	mov	0x3c0, %r23
	.word 0xd88f4e40  ! 2920: LDUBA_R	lduba	[%r29, %r0] 0x72, %r12
	.word 0x87802020  ! 2921: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r18
	mov	0x68, %r25
	.word 0x87802073  ! 2924: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a4e000  ! 2925: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0f4e000  ! 2926: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 2927: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf4c400  ! 2928: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	mov	0x3d8, %r21
	mov	0x7c0, %r23
	.word 0xde87e000  ! 2931: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	mov	0x7d0, %r20
	.word 0xdeafe000  ! 2933: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xdedf6000  ! 2934: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	mov	0x3c8, %r21
	.word 0xdc8ec9e0  ! 2936: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r14
	.word 0xd8bd84a0  ! 2937: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	.word 0xdca7a000  ! 2938: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	mov	0x68, %r18
	.word 0xdcafe000  ! 2940: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2941: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2942: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdecfce60  ! 2943: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r15
	.word 0xdcbf4e60  ! 2944: STDA_R	stda	%r14, [%r29 + %r0] 0x73
	mov	0x18, %r24
	.word 0xd8bce000  ! 2946: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xdc8f0e60  ! 2947: LDUBA_R	lduba	[%r28, %r0] 0x73, %r14
	.word 0x87802073  ! 2948: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c0, %r22
	.word 0xdebc2000  ! 2950: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xde84a000  ! 2951: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	mov	0x3c0, %r20
	.word 0xdeb4a000  ! 2953: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 2954: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea4a000  ! 2955: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 2956: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdedda000  ! 2957: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r15
	.word 0xda840400  ! 2958: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	.word 0xd29f8e40  ! 2959: LDDA_R	ldda	[%r30, %r0] 0x72, %r9
	mov	0x38, %r18
	.word 0xd0b56000  ! 2961: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	.word 0xd09d6000  ! 2962: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r8
	.word 0xd0d5a000  ! 2963: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r8
	.word 0x87802020  ! 2964: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d4c400  ! 2965: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0xdeaf4e60  ! 2966: STBA_R	stba	%r15, [%r29 + %r0] 0x73
	.word 0xdaaca000  ! 2967: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0xdaf4e000  ! 2968: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	mov	0x10, %r26
	mov	0x28, %r26
	.word 0x87802020  ! 2971: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab52000  ! 2972: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	.word 0xdaa56000  ! 2973: STWA_I	stwa	%r13, [%r21 + 0x0000] %asi
	.word 0xdcbd44a0  ! 2974: STDA_R	stda	%r14, [%r21 + %r0] 0x25
	mov	0x78, %r27
	mov	0x40, %r27
	.word 0xded52000  ! 2977: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r15
	.word 0xd6dc0400  ! 2978: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	.word 0xd6f5a000  ! 2979: STXA_I	stxa	%r11, [%r22 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xd6bd6000  ! 2981: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0xd0af4e80  ! 2982: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	mov	0x10, %r26
	.word 0xd2dda000  ! 2984: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2985: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b70e80  ! 2986: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	.word 0x8780204f  ! 2987: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde97a000  ! 2988: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	.word 0xd6df8e60  ! 2989: LDXA_R	ldxa	[%r30, %r0] 0x73, %r11
	.word 0xd29584a0  ! 2990: LDUHA_R	lduha	[%r22, %r0] 0x25, %r9
	.word 0xd6a7e000  ! 2991: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xd0cf4e40  ! 2992: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	.word 0xd4848400  ! 2993: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r10
	.word 0xd2872000  ! 2994: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	.word 0xd4f48400  ! 2995: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xd4f48400  ! 2996: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8afa000  ! 2998: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0xd8df2000  ! 3000: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8f76000  ! 3001: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd0d4c400  ! 3002: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	mov	0x7c8, %r22
	.word 0xd2aec9e0  ! 3004: STBA_R	stba	%r9, [%r27 + %r0] 0x4f
	.word 0xd6d44400  ! 3005: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r11
	mov	0x3d8, %r21
	.word 0x8780204f  ! 3007: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0cf8e40  ! 3008: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r8
	.word 0xdedcc400  ! 3009: LDXA_R	ldxa	[%r19, %r0] 0x20, %r15
	mov	0x68, %r18
	mov	0x3e0, %r22
	.word 0x87802074  ! 3012: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd08f0e60  ! 3013: LDUBA_R	lduba	[%r28, %r0] 0x73, %r8
	.word 0xd4c5e000  ! 3014: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r10
	.word 0xdad44400  ! 3015: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	mov	0x60, %r24
	.word 0xd0f44400  ! 3017: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd4bc8400  ! 3018: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	.word 0xd0af8e80  ! 3019: STBA_R	stba	%r8, [%r30 + %r0] 0x74
	wr_tick_cmpr_3_30:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb6, %g2
	or	%g4, 0xca, %g4
	or	%g6, 0xec, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3e0, %r21
	.word 0xdabda000  ! 3022: STDA_I	stda	%r13, [%r22 + 0x0000] %asi
	.word 0xdccc0400  ! 3023: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r14
	.word 0x87802072  ! 3024: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd897a000  ! 3025: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0xd6cc8400  ! 3026: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	mov	0x7c8, %r23
	.word 0xd2bc0400  ! 3028: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xdcf7e000  ! 3029: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdca7e000  ! 3030: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	mov	0x28, %r27
	.word 0x87802020  ! 3032: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r23
	.word 0xd6cf8e40  ! 3034: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r11
	.word 0xd0c62000  ! 3035: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r8
	mov	0x60, %r24
	.word 0x87802025  ! 3037: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r25
	.word 0xd6ad84a0  ! 3039: STBA_R	stba	%r11, [%r22 + %r0] 0x25
	.word 0x87802073  ! 3040: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r18
	.word 0xdebd84a0  ! 3042: STDA_R	stda	%r15, [%r22 + %r0] 0x25
	.word 0xd2cf8e80  ! 3043: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r9
	.word 0xde840400  ! 3044: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	.word 0xd8af6000  ! 3045: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd2cf8e80  ! 3046: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r9
	.word 0x87802025  ! 3047: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c0, %r20
	.word 0xdaaea000  ! 3049: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	.word 0xda8e2000  ! 3050: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r13
	mov	0x78, %r25
	.word 0xda8ee000  ! 3052: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r13
	.word 0xdcd70e80  ! 3053: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r14
	mov	0x7e0, %r23
	.word 0x87802072  ! 3055: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r26
	.word 0xd4a7e000  ! 3057: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4cfa000  ! 3058: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0xdadc4400  ! 3059: LDXA_R	ldxa	[%r17, %r0] 0x20, %r13
	.word 0x87802073  ! 3060: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a44400  ! 3061: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xd4a46000  ! 3062: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xd28f0e40  ! 3063: LDUBA_R	lduba	[%r28, %r0] 0x72, %r9
	.word 0xd0cce000  ! 3064: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	mov	0x3f8, %r22
	mov	0x68, %r27
	.word 0xd286c9e0  ! 3067: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r9
	.word 0xd8f649e0  ! 3068: STXA_R	stxa	%r12, [%r25 + %r0] 0x4f
	.word 0x87802074  ! 3069: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde942000  ! 3070: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	mov	0x68, %r19
	.word 0x8780204f  ! 3072: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b74e80  ! 3073: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	.word 0xdebf4e80  ! 3074: STDA_R	stda	%r15, [%r29 + %r0] 0x74
	.word 0xd0974e60  ! 3075: LDUHA_R	lduha	[%r29, %r0] 0x73, %r8
	.word 0xdcafa000  ! 3076: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xd4ac4400  ! 3077: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xd4f7a000  ! 3078: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4c76000  ! 3079: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	.word 0x87802072  ! 3080: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4df6000  ! 3081: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	mov	0x58, %r25
	.word 0xd4f72000  ! 3083: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	mov	0x68, %r19
	.word 0xd8ae49e0  ! 3085: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0xd49584a0  ! 3086: LDUHA_R	lduha	[%r22, %r0] 0x25, %r10
	.word 0xd2f7e000  ! 3087: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd6acc400  ! 3088: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0x87802073  ! 3089: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r17
	.word 0xd68c6000  ! 3091: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r11
	.word 0xd68ce000  ! 3092: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	mov	0x58, %r17
	mov	0x3c0, %r23
	.word 0xd8bc8400  ! 3095: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	mov	0x40, %r26
	.word 0x87802072  ! 3097: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r16
	.word 0xd4bf4e80  ! 3099: STDA_R	stda	%r10, [%r29 + %r0] 0x74
	.word 0xd4df8e80  ! 3100: LDXA_R	ldxa	[%r30, %r0] 0x74, %r10
	.word 0xdcac2000  ! 3101: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xd2f7ce80  ! 3103: STXA_R	stxa	%r9, [%r31 + %r0] 0x74
	.word 0xde94e000  ! 3104: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	mov	0x78, %r16
	.word 0x87802074  ! 3106: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0bf4e40  ! 3107: STDA_R	stda	%r8, [%r29 + %r0] 0x72
	.word 0xdeb649e0  ! 3108: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	.word 0x87802073  ! 3109: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 3110: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8af8e80  ! 3111: STBA_R	stba	%r12, [%r30 + %r0] 0x74
	.word 0xde9544a0  ! 3112: LDUHA_R	lduha	[%r21, %r0] 0x25, %r15
	mov	0x3e8, %r20
	.word 0xd2dec9e0  ! 3114: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r9
	.word 0xdaf72000  ! 3115: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xd2d689e0  ! 3116: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r9
	mov	0x78, %r25
	.word 0xdab7ce40  ! 3118: STHA_R	stha	%r13, [%r31 + %r0] 0x72
	mov	0x0, %r27
	.word 0xd8d7e000  ! 3120: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	mov	0x0, %r16
	.word 0xd8a72000  ! 3122: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 3123: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8be2000  ! 3124: STDA_I	stda	%r12, [%r24 + 0x0000] %asi
	wr_tick_cmpr_3_31:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc1, %g2
	or	%g4, 0x9e, %g4
	or	%g6, 0x8a, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd886a000  ! 3126: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r12
	.word 0xd8ac4400  ! 3127: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	mov	0x8, %r27
	mov	0x7d8, %r22
	mov	0x3d0, %r20
	.word 0x87802025  ! 3131: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdedc6000  ! 3132: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r15
	mov	0x3f0, %r23
	.word 0xd6d7ce40  ! 3134: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r11
	.word 0x87802025  ! 3135: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c0, %r23
	mov	0x3e8, %r22
	.word 0xd6df8e60  ! 3138: LDXA_R	ldxa	[%r30, %r0] 0x73, %r11
	.word 0xd0cfce60  ! 3139: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r8
	.word 0xd6d74e80  ! 3140: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r11
	.word 0xd8bfe000  ! 3141: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 3142: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c8, %r23
	.word 0xd8cc2000  ! 3144: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 3145: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r27
	mov	0x3f8, %r22
	mov	0x70, %r24
	.word 0xd8afe000  ! 3149: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd89f6000  ! 3150: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	.word 0x87802073  ! 3151: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bfce60  ! 3152: STDA_R	stda	%r11, [%r31 + %r0] 0x73
	.word 0xdaac0400  ! 3153: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	mov	0x18, %r27
	.word 0xd0a42000  ! 3155: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xd0bc2000  ! 3156: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	.word 0xdea70e60  ! 3157: STWA_R	stwa	%r15, [%r28 + %r0] 0x73
	mov	0x3f8, %r21
	.word 0xd484a000  ! 3159: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r10
	mov	0x70, %r19
	.word 0xd4cc2000  ! 3161: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	.word 0xd6ac4400  ! 3162: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xd4d44400  ! 3163: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0xd08ce000  ! 3164: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	mov	0x70, %r16
	.word 0xd8d78e80  ! 3166: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r12
	.word 0xd68c8400  ! 3167: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	mov	0x3e0, %r23
	.word 0x87802074  ! 3169: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xded72000  ! 3170: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xdef7e000  ! 3171: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 3172: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde852000  ! 3173: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r15
	.word 0x87802074  ! 3174: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeac2000  ! 3175: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xde94a000  ! 3176: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0xdccc4400  ! 3177: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r14
	.word 0xd0bce000  ! 3178: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0xd0ace000  ! 3179: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0xd8bf4e80  ! 3180: STDA_R	stda	%r12, [%r29 + %r0] 0x74
	.word 0xd28fce80  ! 3181: LDUBA_R	lduba	[%r31, %r0] 0x74, %r9
	mov	0x0, %r18
	.word 0xd0f48400  ! 3183: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xd09f8e80  ! 3184: LDDA_R	ldda	[%r30, %r0] 0x74, %r8
	wr_tick_cmpr_3_32:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xdd, %g2
	or	%g4, 0xef, %g4
	or	%g6, 0xf4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8b70e40  ! 3186: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0xd4cd44a0  ! 3187: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r10
	.word 0xdcd7ce60  ! 3188: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r14
	.word 0x8780204f  ! 3189: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0c70e80  ! 3190: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r8
	.word 0xd8952000  ! 3191: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r12
	.word 0xd8b5e000  ! 3192: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	mov	0x70, %r17
	.word 0x87802073  ! 3194: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r25
	.word 0xd0b48400  ! 3196: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xd6bfe000  ! 3197: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd6bf6000  ! 3198: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	mov	0x3c0, %r23
	.word 0xdcb584a0  ! 3200: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	mov	0x3d0, %r22
	.word 0x87802074  ! 3202: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r17
	.word 0x87802072  ! 3204: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0dce000  ! 3205: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r8
	.word 0x87802072  ! 3206: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b76000  ! 3207: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd6f48400  ! 3208: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	mov	0x30, %r25
	.word 0xd497e000  ! 3210: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	mov	0x70, %r19
	.word 0xd48fe000  ! 3212: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xd487e000  ! 3213: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd2870e40  ! 3214: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r9
	.word 0xd887e000  ! 3215: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8f5c4a0  ! 3216: STXA_R	stxa	%r12, [%r23 + %r0] 0x25
	.word 0xd8a649e0  ! 3217: STWA_R	stwa	%r12, [%r25 + %r0] 0x4f
	.word 0xd4bfe000  ! 3218: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x18, %r17
	.word 0x87802025  ! 3220: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6af4e40  ! 3221: STBA_R	stba	%r11, [%r29 + %r0] 0x72
	mov	0x7c0, %r21
	.word 0xd6dda000  ! 3223: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r11
	.word 0xd685e000  ! 3224: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r11
	.word 0xd6b52000  ! 3225: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	.word 0xd8d584a0  ! 3226: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r12
	.word 0xd8a5a000  ! 3227: STWA_I	stwa	%r12, [%r22 + 0x0000] %asi
	mov	0x7c0, %r20
	mov	0x68, %r25
	.word 0xd8ada000  ! 3230: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0xdef609e0  ! 3231: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	.word 0xd0878e40  ! 3232: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r8
	.word 0xd6f5a000  ! 3233: STXA_I	stxa	%r11, [%r22 + 0x0000] %asi
	.word 0xd6cd2000  ! 3234: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r11
	.word 0xd6bd2000  ! 3235: STDA_I	stda	%r11, [%r20 + 0x0000] %asi
	mov	0x7f8, %r23
	.word 0xdaac8400  ! 3237: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0xd285e000  ! 3238: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r9
	mov	0x60, %r18
	.word 0xd6bdc4a0  ! 3240: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	.word 0xdcbde000  ! 3241: STDA_I	stda	%r14, [%r23 + 0x0000] %asi
	mov	0x38, %r18
	.word 0xd6de49e0  ! 3243: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r11
	wr_tick_cmpr_3_33:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe0, %g2
	or	%g4, 0xb0, %g4
	or	%g6, 0xcd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdecd2000  ! 3245: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r15
	.word 0xded5e000  ! 3246: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r15
	.word 0xdcf40400  ! 3247: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xdabd2000  ! 3248: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	.word 0xda956000  ! 3249: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r13
	.word 0xdab5e000  ! 3250: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0xdabd2000  ! 3251: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	.word 0xde970e80  ! 3252: LDUHA_R	lduha	[%r28, %r0] 0x74, %r15
	.word 0xdeac0400  ! 3253: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xd0cde000  ! 3254: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r8
	.word 0xd88e49e0  ! 3255: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r12
	.word 0xd0ac0400  ! 3256: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	.word 0xd8f5e000  ! 3257: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 3258: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 3259: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd886c9e0  ! 3260: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r12
	.word 0x87802020  ! 3261: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf78e40  ! 3262: STXA_R	stxa	%r14, [%r30 + %r0] 0x72
	.word 0xd2a4e000  ! 3263: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2d4e000  ! 3264: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0xdea7ce60  ! 3265: STWA_R	stwa	%r15, [%r31 + %r0] 0x73
	.word 0xd8a42000  ! 3266: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8af0e40  ! 3267: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	ta	T_CHANGE_PRIV	! macro
	.word 0xd294e000  ! 3269: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	mov	0x18, %r18
	.word 0xd2b42000  ! 3271: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0xd2f4e000  ! 3272: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 3273: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8cf4e40  ! 3274: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r12
	.word 0xd0dfce40  ! 3275: LDXA_R	ldxa	[%r31, %r0] 0x72, %r8
	.word 0xd8b7e000  ! 3276: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0xd6c74e80  ! 3277: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r11
	.word 0xdcd504a0  ! 3278: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r14
	mov	0x58, %r17
	.word 0xd6af2000  ! 3280: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd6a72000  ! 3281: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdeae09e0  ! 3283: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	.word 0xd6f76000  ! 3284: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd89609e0  ! 3285: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r12
	.word 0xdeafa000  ! 3286: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	mov	0x10, %r16
	.word 0xdeafa000  ! 3288: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xde97a000  ! 3289: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	mov	0x7c8, %r23
	.word 0xded72000  ! 3291: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xdec48400  ! 3292: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	.word 0xdcbf0e80  ! 3293: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	mov	0x48, %r19
	.word 0xdaa44400  ! 3295: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0xd28f4e60  ! 3296: LDUBA_R	lduba	[%r29, %r0] 0x73, %r9
	.word 0xd2af4e80  ! 3297: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	.word 0x87802020  ! 3298: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b6e000  ! 3299: STHA_I	stha	%r9, [%r27 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0x87802020  ! 3301: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cca000  ! 3302: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	.word 0xd0b78e80  ! 3303: STHA_R	stha	%r8, [%r30 + %r0] 0x74
	.word 0xd89e89e0  ! 3304: LDDA_R	ldda	[%r26, %r0] 0x4f, %r12
	.word 0xd2bc6000  ! 3305: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0xd6ac0400  ! 3306: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0xdaacc400  ! 3307: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0xdcf6c9e0  ! 3308: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	.word 0xdaa44400  ! 3309: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0xdcbca000  ! 3310: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdc9f0e40  ! 3311: LDDA_R	ldda	[%r28, %r0] 0x72, %r14
	.word 0xd8bc6000  ! 3312: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0xd884e000  ! 3313: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r12
	.word 0xd884e000  ! 3314: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r12
	mov	0x7f0, %r21
	.word 0xdcd70e80  ! 3316: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r14
	.word 0xd4b7ce60  ! 3317: STHA_R	stha	%r10, [%r31 + %r0] 0x73
	.word 0xd0c4e000  ! 3318: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	.word 0xd0f42000  ! 3319: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0xdabc4400  ! 3320: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xd2ac6000  ! 3321: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3322: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ce6000  ! 3323: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r9
	.word 0xd2ae6000  ! 3324: STBA_I	stba	%r9, [%r25 + 0x0000] %asi
	.word 0xd2f78e40  ! 3325: STXA_R	stxa	%r9, [%r30 + %r0] 0x72
	.word 0xd4be6000  ! 3326: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0x87802072  ! 3327: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a66000  ! 3328: STWA_I	stwa	%r10, [%r25 + 0x0000] %asi
	mov	0x38, %r27
	.word 0x8780204f  ! 3330: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r24
	.word 0x87802020  ! 3332: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdab544a0  ! 3334: STHA_R	stha	%r13, [%r21 + %r0] 0x25
	.word 0xdaaea000  ! 3335: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	.word 0xda86a000  ! 3336: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r13
	.word 0xda86a000  ! 3337: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r13
	.word 0xdab66000  ! 3338: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	mov	0x30, %r26
	.word 0xd2a40400  ! 3340: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xd6cee000  ! 3341: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r11
	.word 0xd6f6c9e0  ! 3342: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	.word 0xdcdc4400  ! 3343: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	mov	0x0, %r24
	.word 0x87802072  ! 3345: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r24
	.word 0x87802074  ! 3347: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r19
	.word 0x87802074  ! 3349: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r25
	mov	0x68, %r25
	mov	0x20, %r18
	mov	0x68, %r19
	.word 0xde970e60  ! 3354: LDUHA_R	lduha	[%r28, %r0] 0x73, %r15
	mov	0x58, %r19
	.word 0xd2f7ce60  ! 3356: STXA_R	stxa	%r9, [%r31 + %r0] 0x73
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0c74e40  ! 3358: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r8
	.word 0xdea4c400  ! 3359: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	mov	0x60, %r26
	mov	0x8, %r18
	.word 0xda97e000  ! 3362: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd49c0400  ! 3364: LDDA_R	ldda	[%r16, %r0] 0x20, %r10
	mov	0x18, %r18
	.word 0xde97e000  ! 3366: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3367: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b74e40  ! 3368: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	.word 0xd2a7ce80  ! 3369: STWA_R	stwa	%r9, [%r31 + %r0] 0x74
	.word 0xd8afa000  ! 3370: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 3371: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8a42000  ! 3372: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	mov	0x58, %r27
	.word 0x87802073  ! 3374: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8ace000  ! 3375: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0xdaac4400  ! 3376: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	.word 0x87802074  ! 3377: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3f8, %r23
	.word 0xd4bda000  ! 3379: STDA_I	stda	%r10, [%r22 + 0x0000] %asi
	mov	0x70, %r24
	.word 0xd4cd2000  ! 3381: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r10
	mov	0x60, %r18
	.word 0xd4f5e000  ! 3383: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	.word 0xd0a78e60  ! 3384: STWA_R	stwa	%r8, [%r30 + %r0] 0x73
	.word 0xd6856000  ! 3385: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r11
	.word 0xd6c5e000  ! 3386: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r11
	.word 0xd895c4a0  ! 3387: LDUHA_R	lduha	[%r23, %r0] 0x25, %r12
	.word 0xd0d40400  ! 3388: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	.word 0xd6d5a000  ! 3389: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r11
	.word 0xd695a000  ! 3390: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3391: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bfce80  ! 3392: STDA_R	stda	%r12, [%r31 + %r0] 0x74
	.word 0xd2a4e000  ! 3393: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2bc2000  ! 3394: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xd2bc2000  ! 3395: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xda8dc4a0  ! 3396: LDUBA_R	lduba	[%r23, %r0] 0x25, %r13
	.word 0x87802020  ! 3397: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd094e000  ! 3398: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0xd4dfce60  ! 3399: LDXA_R	ldxa	[%r31, %r0] 0x73, %r10
	.word 0xd29ce000  ! 3400: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	mov	0x58, %r17
	.word 0x87802020  ! 3402: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r27
	.word 0xd2f7a000  ! 3404: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 3405: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd685c4a0  ! 3406: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r11
	mov	0x18, %r18
	mov	0x7d0, %r21
	.word 0x87802074  ! 3409: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r19
	.word 0x87802020  ! 3411: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3412: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r24
	.word 0xd0c544a0  ! 3414: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r8
	.word 0xd0b6c9e0  ! 3415: STHA_R	stha	%r8, [%r27 + %r0] 0x4f
	mov	0x3d8, %r23
	.word 0xd6a4a000  ! 3417: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	.word 0xd89e49e0  ! 3418: LDDA_R	ldda	[%r25, %r0] 0x4f, %r12
	.word 0xd0df4e80  ! 3419: LDXA_R	ldxa	[%r29, %r0] 0x74, %r8
	.word 0xdab504a0  ! 3420: STHA_R	stha	%r13, [%r20 + %r0] 0x25
	.word 0x87802073  ! 3421: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6b76000  ! 3422: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xdaaf0e80  ! 3423: STBA_R	stba	%r13, [%r28 + %r0] 0x74
	.word 0x8780204f  ! 3424: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd684a000  ! 3425: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r11
	.word 0xd6b4e000  ! 3426: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xdab70e60  ! 3427: STHA_R	stha	%r13, [%r28 + %r0] 0x73
	.word 0x8780204f  ! 3428: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 3429: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f6e000  ! 3430: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	.word 0xd2cee000  ! 3431: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	mov	0x3c0, %r22
	.word 0xdacc4400  ! 3433: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	ta	T_CHANGE_PRIV	! macro
	mov	0x30, %r16
	.word 0xde9d04a0  ! 3436: LDDA_R	ldda	[%r20, %r0] 0x25, %r15
	.word 0x87802074  ! 3437: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd69c6000  ! 3438: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r11
	.word 0xd6940400  ! 3439: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	mov	0x7d0, %r21
	.word 0xd0a46000  ! 3441: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	mov	0x60, %r26
	.word 0xd8be49e0  ! 3443: STDA_R	stda	%r12, [%r25 + %r0] 0x4f
	.word 0xd6bc2000  ! 3444: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 3445: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb544a0  ! 3446: STHA_R	stha	%r14, [%r21 + %r0] 0x25
	.word 0xd4bf0e40  ! 3447: STDA_R	stda	%r10, [%r28 + %r0] 0x72
	wr_tick_cmpr_3_34:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xd0, %g2
	or	%g4, 0x82, %g4
	or	%g6, 0xd3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd69649e0  ! 3450: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r11
	.word 0xdac7e000  ! 3451: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xd4c74e60  ! 3452: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r10
	.word 0xd6870e40  ! 3453: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r11
	.word 0xdadf2000  ! 3454: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0xdad76000  ! 3455: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0xdaafe000  ! 3456: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xdaafa000  ! 3457: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xd896c9e0  ! 3458: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r12
	.word 0xdeaf8e40  ! 3459: STBA_R	stba	%r15, [%r30 + %r0] 0x72
	.word 0xdef74e40  ! 3460: STXA_R	stxa	%r15, [%r29 + %r0] 0x72
	mov	0x10, %r16
	.word 0x87802072  ! 3462: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcd48400  ! 3464: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	mov	0x40, %r18
	.word 0xd89e89e0  ! 3466: LDDA_R	ldda	[%r26, %r0] 0x4f, %r12
	.word 0xd2c7e000  ! 3467: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2b7a000  ! 3468: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 3469: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3470: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09d44a0  ! 3471: LDDA_R	ldda	[%r21, %r0] 0x25, %r8
	.word 0xd4b4e000  ! 3472: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xd4b42000  ! 3473: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	mov	0x68, %r25
	.word 0xd4d4a000  ! 3475: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0xdcc78e60  ! 3476: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r14
	.word 0x87802073  ! 3477: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 3478: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4a6e000  ! 3479: STWA_I	stwa	%r10, [%r27 + 0x0000] %asi
	.word 0xd486e000  ! 3480: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	.word 0xd8f70e40  ! 3481: STXA_R	stxa	%r12, [%r28 + %r0] 0x72
	.word 0xd2f40400  ! 3482: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0x87802025  ! 3483: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3484: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9d04a0  ! 3485: LDDA_R	ldda	[%r20, %r0] 0x25, %r13
	.word 0x87802020  ! 3486: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r27
	.word 0x87802020  ! 3488: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9f2000  ! 3489: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xde9f6000  ! 3490: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0xde8fe000  ! 3491: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0xdec76000  ! 3492: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xdedfe000  ! 3493: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xded7e000  ! 3494: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0xdeb7e000  ! 3495: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xdef7e000  ! 3496: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xd0b74e40  ! 3497: STHA_R	stha	%r8, [%r29 + %r0] 0x72
	.word 0x87802072  ! 3498: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2870e60  ! 3499: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r9
	mov	0x3e0, %r23
	.word 0xd29689e0  ! 3501: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r9
	.word 0xdec74e40  ! 3502: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r15
	.word 0xd8a584a0  ! 3503: STWA_R	stwa	%r12, [%r22 + %r0] 0x25
	.word 0xd28c2000  ! 3504: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xdaaf0e60  ! 3505: STBA_R	stba	%r13, [%r28 + %r0] 0x73
	.word 0xdedc6000  ! 3506: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r15
	mov	0x68, %r25
	.word 0x87802072  ! 3508: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd69f0e40  ! 3509: LDDA_R	ldda	[%r28, %r0] 0x72, %r11
	.word 0xda972000  ! 3510: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0xd6d7ce60  ! 3511: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r11
	.word 0xdca5c4a0  ! 3512: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	.word 0xdabd44a0  ! 3513: STDA_R	stda	%r13, [%r21 + %r0] 0x25
	mov	0x3f8, %r20
	.word 0x87802020  ! 3515: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a52000  ! 3516: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	.word 0x87802025  ! 3517: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r26
	.word 0xd6f62000  ! 3519: STXA_I	stxa	%r11, [%r24 + 0x0000] %asi
	.word 0xd68ea000  ! 3520: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r11
	.word 0x87802072  ! 3521: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6cc6000  ! 3522: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r11
	.word 0xd6cce000  ! 3523: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r11
	.word 0xd4dc0400  ! 3524: LDXA_R	ldxa	[%r16, %r0] 0x20, %r10
	.word 0x87802072  ! 3525: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 3526: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cf0e60  ! 3527: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r10
	.word 0xd887a000  ! 3528: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xd48649e0  ! 3529: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r10
	.word 0x87802072  ! 3530: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd08cc400  ! 3531: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	.word 0xd8d7e000  ! 3532: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0xd8dfe000  ! 3533: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	mov	0x3f8, %r20
	.word 0xd88fe000  ! 3535: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8976000  ! 3536: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0xd2b70e80  ! 3537: STHA_R	stha	%r9, [%r28 + %r0] 0x74
	.word 0xd0bf6000  ! 3538: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	mov	0x40, %r25
	.word 0x87802073  ! 3540: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdccc8400  ! 3541: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	mov	0x68, %r25
	mov	0x3f8, %r20
	.word 0xd8dc2000  ! 3544: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	mov	0x70, %r27
	.word 0x87802020  ! 3546: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f4e000  ! 3547: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xd6a78e40  ! 3548: STWA_R	stwa	%r11, [%r30 + %r0] 0x72
	mov	0x7f8, %r23
	.word 0x8780204f  ! 3550: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd085a000  ! 3551: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r8
	.word 0x87802074  ! 3552: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd085c4a0  ! 3553: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r8
	.word 0xde944400  ! 3554: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	.word 0x87802020  ! 3555: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b74e80  ! 3556: STHA_R	stha	%r8, [%r29 + %r0] 0x74
	.word 0xdabf8e60  ! 3557: STDA_R	stda	%r13, [%r30 + %r0] 0x73
	.word 0xd6af4e40  ! 3558: STBA_R	stba	%r11, [%r29 + %r0] 0x72
	.word 0xd0dfe000  ! 3559: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xd097e000  ! 3560: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0af6000  ! 3561: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd09fe000  ! 3562: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	mov	0x60, %r25
	.word 0xdcafce80  ! 3564: STBA_R	stba	%r14, [%r31 + %r0] 0x74
	.word 0xdcc76000  ! 3565: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xdc9fe000  ! 3566: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xda9f4e40  ! 3567: LDDA_R	ldda	[%r29, %r0] 0x72, %r13
	.word 0xdebec9e0  ! 3568: STDA_R	stda	%r15, [%r27 + %r0] 0x4f
	.word 0xdcb78e80  ! 3569: STHA_R	stha	%r14, [%r30 + %r0] 0x74
	.word 0x87802073  ! 3570: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b78e40  ! 3571: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	.word 0xd4d56000  ! 3572: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r10
	.word 0xd8878e80  ! 3573: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r12
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0ade000  ! 3575: STBA_I	stba	%r8, [%r23 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0xd0b5e000  ! 3577: STHA_I	stha	%r8, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 3578: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f8, %r20
	.word 0xd0cfe000  ! 3580: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xd0a7a000  ! 3581: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xdadf8e60  ! 3582: LDXA_R	ldxa	[%r30, %r0] 0x73, %r13
	.word 0xdca7e000  ! 3583: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcc7e000  ! 3584: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0xd494c400  ! 3585: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	.word 0xdac72000  ! 3586: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0xdab7a000  ! 3587: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdab76000  ! 3588: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xda8f6000  ! 3589: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xdaa76000  ! 3590: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xda8fa000  ! 3591: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0x87802025  ! 3592: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 3593: WRASI_I	wr	%r0, 0x004f, %asi
	wr_tick_cmpr_3_35:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x8d, %g2
	or	%g4, 0xeb, %g4
	or	%g6, 0xf6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdaf7a000  ! 3595: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdaaf6000  ! 3596: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xdaa4c400  ! 3597: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0xda8f6000  ! 3598: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xdadf6000  ! 3599: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	mov	0x50, %r16
	mov	0x7c8, %r22
	.word 0xdaafe000  ! 3602: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	mov	0x0, %r17
	mov	0x3d0, %r20
	.word 0xdabf6000  ! 3605: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	mov	0x8, %r27
	.word 0xd8dcc400  ! 3607: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	.word 0xd4872000  ! 3608: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 3609: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf4c400  ! 3610: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xd69ce000  ! 3611: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r11
	.word 0xd6842000  ! 3612: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r11
	mov	0x7c0, %r23
	.word 0xd6bc2000  ! 3614: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0xd6aca000  ! 3615: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 3616: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b76000  ! 3617: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	mov	0x3e0, %r20
	.word 0xd8c609e0  ! 3619: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r12
	mov	0x30, %r18
	mov	0x7e0, %r22
	.word 0xd8b48400  ! 3622: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	mov	0x8, %r27
	mov	0x48, %r27
	.word 0xd0bfa000  ! 3625: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0xd0b7e000  ! 3626: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 3627: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r25
	wr_tick_cmpr_3_36:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xef, %g2
	or	%g4, 0xcb, %g4
	or	%g6, 0xcb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0d4e000  ! 3630: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	mov	0x7d0, %r22
	.word 0xd08c2000  ! 3632: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0xd0dca000  ! 3633: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	.word 0xdad40400  ! 3634: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	.word 0xdea689e0  ! 3635: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	.word 0xd4970e40  ! 3636: LDUHA_R	lduha	[%r28, %r0] 0x72, %r10
	.word 0xdeb40400  ! 3637: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0xd6f46000  ! 3638: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0xd8f78e80  ! 3639: STXA_R	stxa	%r12, [%r30 + %r0] 0x74
	mov	0x58, %r16
	.word 0x87802074  ! 3641: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r19
	.word 0xd09649e0  ! 3643: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r8
	.word 0x87802072  ! 3644: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6df0e60  ! 3645: LDXA_R	ldxa	[%r28, %r0] 0x73, %r11
	mov	0x58, %r19
	.word 0xd6be2000  ! 3647: STDA_I	stda	%r11, [%r24 + 0x0000] %asi
	mov	0x3f8, %r21
	mov	0x18, %r27
	.word 0x87802074  ! 3650: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6bf2000  ! 3651: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd69fe000  ! 3652: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	mov	0x60, %r17
	.word 0xd6afce40  ! 3654: STBA_R	stba	%r11, [%r31 + %r0] 0x72
	.word 0xdaf584a0  ! 3655: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	.word 0x87802073  ! 3656: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a649e0  ! 3657: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	.word 0xdcae2000  ! 3658: STBA_I	stba	%r14, [%r24 + 0x0000] %asi
	mov	0x30, %r17
	mov	0x3e8, %r23
	.word 0xdc9e2000  ! 3661: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r14
	.word 0xd0a7ce60  ! 3662: STWA_R	stwa	%r8, [%r31 + %r0] 0x73
	mov	0x7d8, %r23
	mov	0x7f8, %r23
	.word 0xd4974e40  ! 3665: LDUHA_R	lduha	[%r29, %r0] 0x72, %r10
	.word 0xdedea000  ! 3666: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r15
	.word 0xded62000  ! 3667: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r15
	.word 0xdc9fce60  ! 3668: LDDA_R	ldda	[%r31, %r0] 0x73, %r14
	.word 0x8780204f  ! 3669: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd68e09e0  ! 3670: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r11
	.word 0xdeaf4e80  ! 3671: STBA_R	stba	%r15, [%r29 + %r0] 0x74
	.word 0xdec7ce60  ! 3672: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r15
	.word 0xdeaf8e60  ! 3673: STBA_R	stba	%r15, [%r30 + %r0] 0x73
	.word 0xda8f2000  ! 3674: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xd4a4c400  ! 3675: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	mov	0x50, %r18
	.word 0xd6cfe000  ! 3677: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0xd6bfe000  ! 3678: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 3679: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde9c0400  ! 3680: LDDA_R	ldda	[%r16, %r0] 0x20, %r15
	.word 0x87802020  ! 3681: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r25
	.word 0xdedc0400  ! 3683: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	.word 0xd6874e40  ! 3684: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r11
	.word 0xd4c74e80  ! 3685: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r10
	mov	0x0, %r18
	.word 0xdecc2000  ! 3687: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	.word 0x87802074  ! 3688: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3689: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3690: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd48f4e80  ! 3691: LDUBA_R	lduba	[%r29, %r0] 0x74, %r10
	.word 0x87802025  ! 3692: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r26
	mov	0x7d0, %r23
	.word 0xd897a000  ! 3695: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0xd8b76000  ! 3696: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd6c78e60  ! 3697: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r11
	.word 0xd2cfa000  ! 3698: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	.word 0x87802074  ! 3699: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacc8400  ! 3700: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r13
	.word 0xd6f76000  ! 3701: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6cf6000  ! 3702: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0x87802025  ! 3703: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f5e000  ! 3704: STXA_I	stxa	%r11, [%r23 + 0x0000] %asi
	.word 0xdcb78e40  ! 3705: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0x87802020  ! 3706: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c4a000  ! 3707: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 3708: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2acc400  ! 3710: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0xd8f48400  ! 3711: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xd0c76000  ! 3712: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0af2000  ! 3713: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xd0af2000  ! 3715: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 3716: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r22
	.word 0xda9f4e60  ! 3718: LDDA_R	ldda	[%r29, %r0] 0x73, %r13
	mov	0x10, %r19
	.word 0xde974e60  ! 3720: LDUHA_R	lduha	[%r29, %r0] 0x73, %r15
	.word 0xd6b78e80  ! 3721: STHA_R	stha	%r11, [%r30 + %r0] 0x74
	mov	0x18, %r19
	mov	0x7c0, %r22
	.word 0xd4df0e60  ! 3724: LDXA_R	ldxa	[%r28, %r0] 0x73, %r10
	mov	0x38, %r24
	.word 0x87802073  ! 3726: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bdc4a0  ! 3727: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	.word 0xd8bd6000  ! 3728: STDA_I	stda	%r12, [%r21 + 0x0000] %asi
	.word 0xd0cc4400  ! 3729: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	.word 0xd08d2000  ! 3730: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r8
	.word 0xd0b5e000  ! 3731: STHA_I	stha	%r8, [%r23 + 0x0000] %asi
	mov	0x30, %r24
	.word 0xdad44400  ! 3733: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0xd0ad2000  ! 3734: STBA_I	stba	%r8, [%r20 + 0x0000] %asi
	.word 0xd0f5a000  ! 3735: STXA_I	stxa	%r8, [%r22 + 0x0000] %asi
	.word 0xd09da000  ! 3736: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r8
	.word 0x87802074  ! 3737: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 3738: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4df4e80  ! 3739: LDXA_R	ldxa	[%r29, %r0] 0x74, %r10
	mov	0x60, %r26
	.word 0xdaa78e60  ! 3741: STWA_R	stwa	%r13, [%r30 + %r0] 0x73
	.word 0xdca74e40  ! 3742: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	.word 0x87802073  ! 3743: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda8ea000  ! 3744: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r13
	.word 0xdab6e000  ! 3745: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	.word 0xdcf44400  ! 3746: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xd49e2000  ! 3747: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r10
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdabe89e0  ! 3749: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd4f6e000  ! 3751: STXA_I	stxa	%r10, [%r27 + 0x0000] %asi
	.word 0xd4b6e000  ! 3752: STHA_I	stha	%r10, [%r27 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xd4bee000  ! 3754: STDA_I	stda	%r10, [%r27 + 0x0000] %asi
	.word 0xd4cea000  ! 3755: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r10
	.word 0xd4c66000  ! 3756: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r10
	mov	0x10, %r16
	.word 0xd69e89e0  ! 3758: LDDA_R	ldda	[%r26, %r0] 0x4f, %r11
	.word 0xd2f40400  ! 3759: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xd0d4c400  ! 3760: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	.word 0xdebe2000  ! 3761: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	.word 0x87802073  ! 3762: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde8fa000  ! 3763: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0xdea4c400  ! 3764: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	mov	0x3e0, %r23
	.word 0x87802073  ! 3766: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6afe000  ! 3767: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd89d04a0  ! 3768: LDDA_R	ldda	[%r20, %r0] 0x25, %r12
	.word 0x8780204f  ! 3769: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 3770: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d8, %r22
	.word 0x87802072  ! 3772: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3773: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29f4e60  ! 3774: LDDA_R	ldda	[%r29, %r0] 0x73, %r9
	.word 0x87802020  ! 3775: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r23
	.word 0xd88689e0  ! 3777: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r12
	.word 0xd8b72000  ! 3778: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd8f76000  ! 3779: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xdcc609e0  ! 3780: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r14
	mov	0x7e8, %r21
	.word 0xdeb7e000  ! 3782: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xdef7e000  ! 3783: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xdedfe000  ! 3784: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xdea7e000  ! 3785: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xde8f4e60  ! 3786: LDUBA_R	lduba	[%r29, %r0] 0x73, %r15
	.word 0xdedf4e60  ! 3787: LDXA_R	ldxa	[%r29, %r0] 0x73, %r15
	mov	0x70, %r19
	mov	0x0, %r19
	mov	0x7d0, %r21
	.word 0xd4dcc400  ! 3791: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0x87802020  ! 3792: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9ee000  ! 3793: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r15
	.word 0xdc970e60  ! 3794: LDUHA_R	lduha	[%r28, %r0] 0x73, %r14
	.word 0x87802074  ! 3795: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 3796: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb76000  ! 3797: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	mov	0x70, %r24
	.word 0xdc9f2000  ! 3799: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xd0b6c9e0  ! 3800: STHA_R	stha	%r8, [%r27 + %r0] 0x4f
	.word 0xd2b78e40  ! 3801: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	.word 0x87802073  ! 3802: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r24
	mov	0x40, %r24
	.word 0xded5a000  ! 3805: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r15
	.word 0xde95e000  ! 3806: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r15
	mov	0x0, %r25
	.word 0xdef4c400  ! 3808: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	mov	0x7f8, %r20
	.word 0xd2bcc400  ! 3810: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0x87802074  ! 3811: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf72000  ! 3812: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdab584a0  ! 3813: STHA_R	stha	%r13, [%r22 + %r0] 0x25
	.word 0xd0ae89e0  ! 3814: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	.word 0xd4bf6000  ! 3815: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	wr_tick_cmpr_3_37:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xaf, %g2
	or	%g4, 0xce, %g4
	or	%g6, 0xb8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4d76000  ! 3817: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0xd4a72000  ! 3818: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4972000  ! 3819: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0x87802025  ! 3820: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cee000  ! 3821: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r10
	.word 0x87802072  ! 3822: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4df6000  ! 3823: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	mov	0x58, %r16
	.word 0x87802020  ! 3825: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f40400  ! 3826: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0x87802074  ! 3827: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdea7a000  ! 3828: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xd8cf0e60  ! 3829: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r12
	.word 0xd8df6000  ! 3830: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8a7e000  ! 3831: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd6978e80  ! 3832: LDUHA_R	lduha	[%r30, %r0] 0x74, %r11
	.word 0xdc974e80  ! 3833: LDUHA_R	lduha	[%r29, %r0] 0x74, %r14
	.word 0xd0874e40  ! 3834: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r8
	.word 0xd8f4c400  ! 3835: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	mov	0x3e8, %r21
	.word 0xdad6c9e0  ! 3837: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r13
	.word 0xd8a44400  ! 3838: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xd0bf2000  ! 3839: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xd0972000  ! 3840: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0d76000  ! 3841: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xd2b584a0  ! 3842: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0xd29f6000  ! 3843: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xd2a72000  ! 3844: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0xd8a689e0  ! 3845: STWA_R	stwa	%r12, [%r26 + %r0] 0x4f
	mov	0x7f0, %r23
	mov	0x30, %r27
	.word 0xd4d70e80  ! 3848: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r10
	.word 0xdaa7e000  ! 3849: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0xdab76000  ! 3851: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdabf6000  ! 3852: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 3853: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cf0e80  ! 3854: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r10
	mov	0x0, %r18
	wr_tick_cmpr_3_38:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe8, %g2
	or	%g4, 0xa7, %g4
	or	%g6, 0x92, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4cf2000  ! 3857: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4972000  ! 3858: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0xdcf4c400  ! 3859: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xd8c70e40  ! 3860: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r12
	mov	0x40, %r26
	.word 0xd0a7ce80  ! 3862: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	.word 0x87802073  ! 3863: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e8, %r22
	.word 0xd2b689e0  ! 3865: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	.word 0xdadca000  ! 3866: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	mov	0x20, %r16
	.word 0xd6bd84a0  ! 3868: STDA_R	stda	%r11, [%r22 + %r0] 0x25
	.word 0xd8cc2000  ! 3869: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r12
	.word 0xdeb70e80  ! 3870: STHA_R	stha	%r15, [%r28 + %r0] 0x74
	mov	0x60, %r26
	mov	0x68, %r26
	.word 0xd48f4e60  ! 3873: LDUBA_R	lduba	[%r29, %r0] 0x73, %r10
	.word 0xdedf0e80  ! 3874: LDXA_R	ldxa	[%r28, %r0] 0x74, %r15
	.word 0xd8944400  ! 3875: LDUHA_R	lduha	[%r17, %r0] 0x20, %r12
	mov	0x38, %r18
	mov	0x68, %r17
	.word 0xdaac4400  ! 3878: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	.word 0xdea46000  ! 3879: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xdaa7ce40  ! 3880: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	.word 0xd0b42000  ! 3881: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xd0aca000  ! 3882: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xd4df8e80  ! 3883: LDXA_R	ldxa	[%r30, %r0] 0x74, %r10
	.word 0xd094a000  ! 3884: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	mov	0x38, %r27
	.word 0x87802025  ! 3886: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd09fa000  ! 3887: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	.word 0x87802073  ! 3888: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r17
	.word 0xdcacc400  ! 3890: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0xdaa78e80  ! 3891: STWA_R	stwa	%r13, [%r30 + %r0] 0x74
	.word 0xd295c4a0  ! 3892: LDUHA_R	lduha	[%r23, %r0] 0x25, %r9
	.word 0xd2c7ce40  ! 3893: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r9
	.word 0xd2ac8400  ! 3894: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xde8ca000  ! 3895: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0xdab74e80  ! 3896: STHA_R	stha	%r13, [%r29 + %r0] 0x74
	.word 0xd0a46000  ! 3897: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0bce000  ! 3898: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0xd0bf4e60  ! 3900: STDA_R	stda	%r8, [%r29 + %r0] 0x73
	.word 0x87802073  ! 3901: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d8, %r21
	mov	0x3e8, %r20
	.word 0xdcb78e40  ! 3904: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xd6b62000  ! 3905: STHA_I	stha	%r11, [%r24 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xd69e2000  ! 3907: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r11
	mov	0x7e0, %r22
	.word 0xdef649e0  ! 3909: STXA_R	stxa	%r15, [%r25 + %r0] 0x4f
	.word 0xd08dc4a0  ! 3910: LDUBA_R	lduba	[%r23, %r0] 0x25, %r8
	mov	0x3d8, %r21
	.word 0xd6ce2000  ! 3912: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	mov	0x48, %r16
	.word 0xd6cee000  ! 3914: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r11
	.word 0xda9dc4a0  ! 3915: LDDA_R	ldda	[%r23, %r0] 0x25, %r13
	.word 0xd2b70e40  ! 3916: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	.word 0xd0b6e000  ! 3917: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	.word 0xd4f70e40  ! 3918: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	.word 0x87802074  ! 3919: WRASI_I	wr	%r0, 0x0074, %asi
	wr_tick_cmpr_3_39:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x8e, %g2
	or	%g4, 0xb6, %g4
	or	%g6, 0xe6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4bc0400  ! 3921: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	mov	0x10, %r25
	.word 0x87802020  ! 3923: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r25
	.word 0xdc876000  ! 3925: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0xd6b44400  ! 3926: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 3927: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bc2000  ! 3928: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd8bce000  ! 3929: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd8b74e40  ! 3930: STHA_R	stha	%r12, [%r29 + %r0] 0x72
	.word 0xdc94a000  ! 3931: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xdcf46000  ! 3932: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	mov	0x40, %r26
	mov	0x18, %r17
	.word 0xdcb4e000  ! 3935: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xdcac6000  ! 3936: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xdcbce000  ! 3937: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xd0bd44a0  ! 3938: STDA_R	stda	%r8, [%r21 + %r0] 0x25
	mov	0x78, %r19
	.word 0xdeb42000  ! 3940: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0xd4a78e60  ! 3941: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	mov	0x38, %r27
	mov	0x7c8, %r21
	.word 0xd28dc4a0  ! 3944: LDUBA_R	lduba	[%r23, %r0] 0x25, %r9
	.word 0xd4a42000  ! 3945: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0xd4c4a000  ! 3946: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	.word 0xd4d46000  ! 3947: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r10
	.word 0xd4b4a000  ! 3948: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0xd49c2000  ! 3949: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	.word 0x87802073  ! 3950: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4bf2000  ! 3951: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xdebd04a0  ! 3952: STDA_R	stda	%r15, [%r20 + %r0] 0x25
	.word 0xd0f48400  ! 3953: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xd2b7a000  ! 3954: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd2afa000  ! 3955: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xda874e60  ! 3956: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r13
	.word 0xd8df4e80  ! 3957: LDXA_R	ldxa	[%r29, %r0] 0x74, %r12
	mov	0x7d8, %r21
	.word 0x87802020  ! 3959: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r20
	.word 0xdcafce40  ! 3961: STBA_R	stba	%r14, [%r31 + %r0] 0x72
	.word 0xdcf72000  ! 3962: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0x87802074  ! 3964: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca6e000  ! 3965: STWA_I	stwa	%r14, [%r27 + 0x0000] %asi
	.word 0x8780204f  ! 3966: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcaca000  ! 3967: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xd0c74e60  ! 3968: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r8
	.word 0x87802020  ! 3969: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb504a0  ! 3970: STHA_R	stha	%r15, [%r20 + %r0] 0x25
	.word 0xd4a72000  ! 3971: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd0a78e80  ! 3972: STWA_R	stwa	%r8, [%r30 + %r0] 0x74
	wr_tick_cmpr_3_40:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xa4, %g2
	or	%g4, 0x90, %g4
	or	%g6, 0xc0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x8780204f  ! 3974: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r24
	mov	0x20, %r16
	.word 0xded72000  ! 3977: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xdebfa000  ! 3978: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xdecc4400  ! 3979: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r15
	.word 0x8780204f  ! 3980: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdef72000  ! 3981: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xd4bfce60  ! 3982: STDA_R	stda	%r10, [%r31 + %r0] 0x73
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd6bc4400  ! 3984: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	.word 0x87802074  ! 3985: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc976000  ! 3986: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	.word 0xdcf7ce80  ! 3987: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	.word 0xd4bf2000  ! 3988: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd69689e0  ! 3989: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r11
	.word 0xd8f78e40  ! 3990: STXA_R	stxa	%r12, [%r30 + %r0] 0x72
	.word 0xdabf6000  ! 3991: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 3992: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r17
	.word 0xda876000  ! 3994: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0xdab72000  ! 3995: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdaf7ce40  ! 3996: STXA_R	stxa	%r13, [%r31 + %r0] 0x72
	.word 0xd2a74e40  ! 3997: STWA_R	stwa	%r9, [%r29 + %r0] 0x72
	mov	0x68, %r16
	.word 0xd2bf2000  ! 3999: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd29f2000  ! 4000: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0x87802020  ! 4001: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_3_41:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe0, %g2
	or	%g4, 0xe4, %g4
	or	%g6, 0xc1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 4003: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r19
	.word 0xd2be6000  ! 4005: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	.word 0xdebf8e60  ! 4006: STDA_R	stda	%r15, [%r30 + %r0] 0x73
	.word 0xd0dea000  ! 4007: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r8
	mov	0x20, %r17
	mov	0x28, %r18
	mov	0x3f0, %r23
	mov	0x3e8, %r23
	.word 0xd2ce49e0  ! 4012: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r9
	.word 0xd2d6e000  ! 4013: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r9
	mov	0x7c8, %r22
	.word 0xdcaf8e40  ! 4015: STBA_R	stba	%r14, [%r30 + %r0] 0x72
	.word 0xd69fce80  ! 4016: LDDA_R	ldda	[%r31, %r0] 0x74, %r11
	.word 0xd8866000  ! 4017: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r12
	.word 0xd8be6000  ! 4018: STDA_I	stda	%r12, [%r25 + 0x0000] %asi
	.word 0x87802073  ! 4019: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8b76000  ! 4020: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd0ad44a0  ! 4021: STBA_R	stba	%r8, [%r21 + %r0] 0x25
	.word 0xd4bfce80  ! 4022: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	.word 0xd2a584a0  ! 4023: STWA_R	stwa	%r9, [%r22 + %r0] 0x25
	.word 0xd497e000  ! 4024: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	.word 0xd0cc8400  ! 4025: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0xdc9fa000  ! 4026: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0xdcb70e80  ! 4027: STHA_R	stha	%r14, [%r28 + %r0] 0x74
	.word 0xdcddc4a0  ! 4028: LDXA_R	ldxa	[%r23, %r0] 0x25, %r14
	.word 0xdebf2000  ! 4029: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	mov	0x20, %r27
	.word 0xdcdf4e40  ! 4031: LDXA_R	ldxa	[%r29, %r0] 0x72, %r14
	.word 0xde876000  ! 4032: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xdef72000  ! 4033: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xd6a78e60  ! 4034: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0xd2a7ce60  ! 4035: STWA_R	stwa	%r9, [%r31 + %r0] 0x73
	.word 0x87802025  ! 4036: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 4037: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 4038: WRASI_I	wr	%r0, 0x004f, %asi
	wr_tick_cmpr_3_42:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa2, %g2
	or	%g4, 0xcd, %g4
	or	%g6, 0xfe, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdc9fce80  ! 4040: LDDA_R	ldda	[%r31, %r0] 0x74, %r14
	.word 0xd0be2000  ! 4041: STDA_I	stda	%r8, [%r24 + 0x0000] %asi
	.word 0x87802073  ! 4042: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8a6c9e0  ! 4043: STWA_R	stwa	%r12, [%r27 + %r0] 0x4f
	.word 0xdab62000  ! 4044: STHA_I	stha	%r13, [%r24 + 0x0000] %asi
	mov	0x18, %r27
	.word 0xda9ea000  ! 4046: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r13
	.word 0xdabee000  ! 4047: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd29c4400  ! 4049: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	mov	0x3e8, %r21
	.word 0xd2b6a000  ! 4051: STHA_I	stha	%r9, [%r26 + 0x0000] %asi
	.word 0xd296a000  ! 4052: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r9
	mov	0x3f0, %r22
	mov	0x3c8, %r23
	mov	0x78, %r26
	.word 0x87802025  ! 4056: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd29e6000  ! 4057: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r9
	.word 0xd2f66000  ! 4058: STXA_I	stxa	%r9, [%r25 + 0x0000] %asi
	.word 0xde8609e0  ! 4059: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r15
	.word 0xd4cee000  ! 4060: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r10
	.word 0xd4df4e60  ! 4061: LDXA_R	ldxa	[%r29, %r0] 0x73, %r10
	.word 0xd6ac4400  ! 4062: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xd6866000  ! 4063: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r11
	.word 0x87802025  ! 4064: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r16
	mov	0x7c8, %r22
	mov	0x58, %r16
	mov	0x38, %r19
	mov	0x28, %r17
	mov	0x78, %r25
	.word 0x87802074  ! 4071: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d8, %r21
	.word 0xd28584a0  ! 4073: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r9
	.word 0xdef4c400  ! 4074: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	mov	0x48, %r27
	.word 0x87802020  ! 4076: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4077: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r24
	.word 0xd8b56000  ! 4079: STHA_I	stha	%r12, [%r21 + 0x0000] %asi
	mov	0x18, %r17
	.word 0xdca5c4a0  ! 4081: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	mov	0x7e8, %r22
	.word 0xd0bd2000  ! 4083: STDA_I	stda	%r8, [%r20 + 0x0000] %asi
	.word 0xd8874e80  ! 4084: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r12
	.word 0xdef40400  ! 4085: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	mov	0x7f8, %r20
	.word 0x87802074  ! 4087: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbcc400  ! 4088: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xdcacc400  ! 4089: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	mov	0x60, %r18
	.word 0x87802020  ! 4091: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea78e60  ! 4092: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	.word 0xd08fa000  ! 4093: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0x87802074  ! 4094: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f4c400  ! 4095: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xd8a52000  ! 4096: STWA_I	stwa	%r12, [%r20 + 0x0000] %asi
	.word 0xd8cd2000  ! 4097: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r12
	.word 0xd8f5a000  ! 4098: STXA_I	stxa	%r12, [%r22 + 0x0000] %asi
	.word 0xd8bde000  ! 4099: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0xd895a000  ! 4100: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r12
	.word 0xd6a544a0  ! 4101: STWA_R	stwa	%r11, [%r21 + %r0] 0x25
	.word 0xd2bf0e40  ! 4102: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	.word 0xd0af0e60  ! 4103: STBA_R	stba	%r8, [%r28 + %r0] 0x73
	.word 0xd88f0e60  ! 4104: LDUBA_R	lduba	[%r28, %r0] 0x73, %r12
	.word 0xd8cf4e80  ! 4105: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r12
	mov	0x3c8, %r22
	.word 0xdaf5a000  ! 4107: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xdacda000  ! 4108: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r13
	.word 0xd2b70e40  ! 4109: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	.word 0xd08d2000  ! 4110: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r8
	.word 0xd6be89e0  ! 4111: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	mov	0x7c8, %r20
	.word 0xd4dfce60  ! 4113: LDXA_R	ldxa	[%r31, %r0] 0x73, %r10
	mov	0x18, %r17
	.word 0xdea649e0  ! 4115: STWA_R	stwa	%r15, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 4116: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedfe000  ! 4117: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xd4df0e40  ! 4118: LDXA_R	ldxa	[%r28, %r0] 0x72, %r10
	.word 0x87802074  ! 4119: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbd44a0  ! 4120: STDA_R	stda	%r14, [%r21 + %r0] 0x25
	.word 0x87802073  ! 4121: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdccfe000  ! 4122: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xdcf7e000  ! 4123: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x0, %r27
	.word 0xd8f48400  ! 4125: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xdeaf6000  ! 4126: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xd0af8e60  ! 4127: STBA_R	stba	%r8, [%r30 + %r0] 0x73
	.word 0xd0f76000  ! 4128: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0xd2d44400  ! 4130: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r9
	.word 0xd0cf6000  ! 4131: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	mov	0x20, %r19
	mov	0x8, %r18
	.word 0xd0976000  ! 4134: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd6f78e40  ! 4135: STXA_R	stxa	%r11, [%r30 + %r0] 0x72
	.word 0xd687e000  ! 4136: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6f70e40  ! 4137: STXA_R	stxa	%r11, [%r28 + %r0] 0x72
	.word 0x87802073  ! 4138: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcdfce60  ! 4139: LDXA_R	ldxa	[%r31, %r0] 0x73, %r14
	.word 0x8780204f  ! 4140: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r25
	.word 0xdabfe000  ! 4142: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xd8b40400  ! 4143: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	mov	0x18, %r27
	.word 0xd4cc8400  ! 4145: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	.word 0xd6f504a0  ! 4146: STXA_R	stxa	%r11, [%r20 + %r0] 0x25
	.word 0x87802025  ! 4147: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 4148: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c0, %r22
	.word 0xd8b56000  ! 4150: STHA_I	stha	%r12, [%r21 + 0x0000] %asi
	mov	0x7f8, %r20
	.word 0xd4d609e0  ! 4152: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r10
	mov	0x3e8, %r21
	.word 0xd8a5a000  ! 4154: STWA_I	stwa	%r12, [%r22 + 0x0000] %asi
	mov	0x3c8, %r22
	.word 0x87802073  ! 4156: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda9649e0  ! 4157: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r13
	mov	0x40, %r18
	.word 0x87802074  ! 4159: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdecfce60  ! 4160: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r15
	.word 0xde9f4e80  ! 4161: LDDA_R	ldda	[%r29, %r0] 0x74, %r15
	.word 0x87802072  ! 4162: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdecc4400  ! 4163: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r15
	.word 0xd09f2000  ! 4164: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0xd0afa000  ! 4165: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	mov	0x10, %r19
	.word 0xd0b7a000  ! 4167: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd0976000  ! 4168: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd6c7ce60  ! 4169: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r11
	mov	0x3d0, %r20
	mov	0x50, %r19
	mov	0x78, %r19
	.word 0xdcdfe000  ! 4173: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xd6f78e80  ! 4174: STXA_R	stxa	%r11, [%r30 + %r0] 0x74
	.word 0xdabfce40  ! 4175: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	.word 0x87802020  ! 4176: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ae49e0  ! 4177: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0xd8f4a000  ! 4178: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	mov	0x48, %r18
	.word 0xd8a46000  ! 4180: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8ac2000  ! 4181: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	mov	0x68, %r25
	.word 0xdacf4e60  ! 4183: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r13
	mov	0x68, %r18
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0944400  ! 4186: LDUHA_R	lduha	[%r17, %r0] 0x20, %r8
	.word 0xd29c6000  ! 4187: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	.word 0xd4bf4e40  ! 4188: STDA_R	stda	%r10, [%r29 + %r0] 0x72
	.word 0xd6f46000  ! 4189: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0xd8978e40  ! 4191: LDUHA_R	lduha	[%r30, %r0] 0x72, %r12
	.word 0xdebc4400  ! 4192: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0x87802074  ! 4193: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd08e6000  ! 4194: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r8
	.word 0xd0a6e000  ! 4195: STWA_I	stwa	%r8, [%r27 + 0x0000] %asi
	.word 0xd0948400  ! 4196: LDUHA_R	lduha	[%r18, %r0] 0x20, %r8
	mov	0x7c0, %r23
	.word 0xd88cc400  ! 4198: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	.word 0xdacc4400  ! 4199: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	.word 0x8780204f  ! 4200: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 4201: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdea72000  ! 4202: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xdcbcc400  ! 4203: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	mov	0x30, %r16
	.word 0xde874e60  ! 4205: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r15
	.word 0xd6c44400  ! 4206: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r11
	.word 0x87802025  ! 4207: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bd2000  ! 4208: STDA_I	stda	%r12, [%r20 + 0x0000] %asi
	.word 0xd8c5a000  ! 4209: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r12
	.word 0xd8bde000  ! 4210: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0xd8c56000  ! 4211: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r12
	.word 0xd8bd6000  ! 4212: STDA_I	stda	%r12, [%r21 + 0x0000] %asi
	.word 0x87802072  ! 4213: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r24
	.word 0xdcdc0400  ! 4215: LDXA_R	ldxa	[%r16, %r0] 0x20, %r14
	mov	0x58, %r26
	.word 0xd8d4a000  ! 4217: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xdcd504a0  ! 4218: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r14
	.word 0xded584a0  ! 4219: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r15
	mov	0x28, %r19
	.word 0xdc940400  ! 4221: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0xd4942000  ! 4222: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r10
	.word 0xdccc8400  ! 4223: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	.word 0xdcb4e000  ! 4224: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	mov	0x3c8, %r21
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802074  ! 4227: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc84a000  ! 4228: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	.word 0xdcf4e000  ! 4229: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 4230: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcac6000  ! 4231: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xd4bc0400  ! 4232: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0x87802073  ! 4233: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd28ec9e0  ! 4234: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r9
	.word 0xdab4a000  ! 4235: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0xd4cf4e60  ! 4236: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r10
	.word 0xd0d40400  ! 4237: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	.word 0xdccf0e40  ! 4238: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r14
	.word 0xd4c4a000  ! 4239: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	.word 0xd494e000  ! 4240: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	.word 0xd69544a0  ! 4241: LDUHA_R	lduha	[%r21, %r0] 0x25, %r11
	.word 0xdcdc6000  ! 4242: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	.word 0xdcc649e0  ! 4243: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r14
	mov	0x18, %r27
	.word 0xd8d4a000  ! 4245: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xdca44400  ! 4246: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	mov	0x70, %r18
	mov	0x10, %r18
	.word 0xd6bf4e60  ! 4249: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 4250: WRASI_I	wr	%r0, 0x004f, %asi
	wr_tick_cmpr_3_43:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xbc, %g2
	or	%g4, 0xe9, %g4
	or	%g6, 0x83, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd09ec9e0  ! 4252: LDDA_R	ldda	[%r27, %r0] 0x4f, %r8
	mov	0x7d0, %r22
	.word 0xd6b7e000  ! 4254: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xdca7ce60  ! 4255: STWA_R	stwa	%r14, [%r31 + %r0] 0x73
	.word 0xda870e40  ! 4256: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r13
	.word 0x87802020  ! 4257: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 4258: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r18
	wr_tick_cmpr_3_44:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb6, %g2
	or	%g4, 0x8e, %g4
	or	%g6, 0xe5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xde8e2000  ! 4261: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r15
	.word 0xd0f44400  ! 4262: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0x87802073  ! 4263: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r17
	.word 0xd49f0e60  ! 4265: LDDA_R	ldda	[%r28, %r0] 0x73, %r10
	.word 0xd8f5e000  ! 4266: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	wr_tick_cmpr_3_45:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x8e, %g2
	or	%g4, 0xe3, %g4
	or	%g6, 0xa3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802025  ! 4268: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd69fce80  ! 4269: LDDA_R	ldda	[%r31, %r0] 0x74, %r11
	mov	0x50, %r25
	.word 0xd6cd6000  ! 4271: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r11
	.word 0xd2cf0e40  ! 4272: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r9
	mov	0x60, %r24
	.word 0xdaa5e000  ! 4274: STWA_I	stwa	%r13, [%r23 + 0x0000] %asi
	.word 0x87802073  ! 4275: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0ae09e0  ! 4276: STBA_R	stba	%r8, [%r24 + %r0] 0x4f
	.word 0xd2cfe000  ! 4277: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	mov	0x38, %r19
	.word 0xd28f6000  ! 4279: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd88f0e60  ! 4280: LDUBA_R	lduba	[%r28, %r0] 0x73, %r12
	.word 0x87802020  ! 4281: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bdc4a0  ! 4282: STDA_R	stda	%r8, [%r23 + %r0] 0x25
	.word 0xdebe89e0  ! 4283: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	.word 0xd8856000  ! 4284: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	.word 0x87802073  ! 4285: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4df4e80  ! 4286: LDXA_R	ldxa	[%r29, %r0] 0x74, %r10
	mov	0x48, %r24
	.word 0xd8bce000  ! 4288: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xdaae89e0  ! 4289: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	.word 0xd2a4a000  ! 4290: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	mov	0x68, %r27
	.word 0xd69c8400  ! 4292: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	mov	0x0, %r17
	mov	0x7d8, %r23
	.word 0xdca7ce40  ! 4295: STWA_R	stwa	%r14, [%r31 + %r0] 0x72
	.word 0xda97ce80  ! 4296: LDUHA_R	lduha	[%r31, %r0] 0x74, %r13
	mov	0x7f8, %r22
	mov	0x38, %r18
	wr_tick_cmpr_3_46:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x91, %g2
	or	%g4, 0xa5, %g4
	or	%g6, 0xfc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 4300: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c8, %r22
	.word 0xd28fce60  ! 4302: LDUBA_R	lduba	[%r31, %r0] 0x73, %r9
	.word 0xd89c0400  ! 4303: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	.word 0xdaa70e80  ! 4304: STWA_R	stwa	%r13, [%r28 + %r0] 0x74
	mov	0x48, %r17
	mov	0x60, %r27
	.word 0xd8962000  ! 4307: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r12
	mov	0x7f8, %r21
	.word 0x87802025  ! 4309: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4310: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r19
	.word 0xd0a44400  ! 4312: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	mov	0x68, %r24
	.word 0x87802025  ! 4314: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda9de000  ! 4315: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r13
	.word 0xdcf544a0  ! 4316: STXA_R	stxa	%r14, [%r21 + %r0] 0x25
	mov	0x68, %r27
	mov	0x50, %r17
	mov	0x3e8, %r22
	mov	0x60, %r24
	.word 0x8780204f  ! 4321: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a7ce80  ! 4322: STWA_R	stwa	%r10, [%r31 + %r0] 0x74
	.word 0xd0a70e80  ! 4323: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0xdcbd44a0  ! 4324: STDA_R	stda	%r14, [%r21 + %r0] 0x25
	.word 0xda8ce000  ! 4325: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	mov	0x7c0, %r22
	.word 0xdac42000  ! 4327: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0xdaacc400  ! 4328: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0xd487ce40  ! 4329: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r10
	.word 0xdebfce40  ! 4330: STDA_R	stda	%r15, [%r31 + %r0] 0x72
	.word 0xd4a42000  ! 4331: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 4332: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 4333: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4d6a000  ! 4334: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r10
	.word 0x87802020  ! 4335: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4944400  ! 4336: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	.word 0x87802074  ! 4337: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e0, %r21
	.word 0xd4c78e80  ! 4339: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r10
	.word 0xdea44400  ! 4340: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	mov	0x0, %r27
	.word 0xde9f4e60  ! 4342: LDDA_R	ldda	[%r29, %r0] 0x73, %r15
	.word 0xd0f689e0  ! 4343: STXA_R	stxa	%r8, [%r26 + %r0] 0x4f
	mov	0x3c0, %r22
	.word 0xd4b40400  ! 4345: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	mov	0x50, %r26
	.word 0xd0d78e80  ! 4347: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r8
	.word 0xdeb504a0  ! 4348: STHA_R	stha	%r15, [%r20 + %r0] 0x25
	.word 0xd4f40400  ! 4349: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xd2844400  ! 4350: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	.word 0xdcf78e80  ! 4351: STXA_R	stxa	%r14, [%r30 + %r0] 0x74
	.word 0xdea46000  ! 4352: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 4353: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeaca000  ! 4354: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xdeac8400  ! 4355: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xd2d42000  ! 4356: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2bd84a0  ! 4357: STDA_R	stda	%r9, [%r22 + %r0] 0x25
	.word 0xd0a4a000  ! 4358: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 4359: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f0, %r23
	.word 0xd6a70e40  ! 4361: STWA_R	stwa	%r11, [%r28 + %r0] 0x72
	.word 0xd0a649e0  ! 4362: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	.word 0xd0af0e80  ! 4363: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	ta	T_CHANGE_PRIV	! macro
	.word 0xd29fce80  ! 4365: LDDA_R	ldda	[%r31, %r0] 0x74, %r9
	.word 0xd4f74e60  ! 4366: STXA_R	stxa	%r10, [%r29 + %r0] 0x73
	mov	0x3d8, %r20
	.word 0x87802073  ! 4368: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd69544a0  ! 4369: LDUHA_R	lduha	[%r21, %r0] 0x25, %r11
	.word 0xd8a78e40  ! 4370: STWA_R	stwa	%r12, [%r30 + %r0] 0x72
	mov	0x3e0, %r22
	.word 0xd4d72000  ! 4372: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	mov	0x7c0, %r20
	mov	0x7e0, %r21
	.word 0xd4b7e000  ! 4375: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 4376: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4377: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r18
	.word 0xd28f0e60  ! 4379: LDUBA_R	lduba	[%r28, %r0] 0x73, %r9
	.word 0x87802072  ! 4380: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r17
	mov	0x70, %r24
	.word 0xdcad04a0  ! 4383: STBA_R	stba	%r14, [%r20 + %r0] 0x25
	.word 0xd69fe000  ! 4384: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	.word 0xda97ce80  ! 4385: LDUHA_R	lduha	[%r31, %r0] 0x74, %r13
	.word 0xd4b7e000  ! 4386: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 4387: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4c649e0  ! 4388: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r10
	.word 0xdef7e000  ! 4389: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	mov	0x28, %r26
	mov	0x60, %r17
	mov	0x38, %r19
	mov	0x7f8, %r20
	.word 0xdef76000  ! 4394: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xd4ae89e0  ! 4395: STBA_R	stba	%r10, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 4396: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8cd2000  ! 4397: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r12
	mov	0x7c8, %r22
	.word 0xd8f56000  ! 4399: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	.word 0xd8f52000  ! 4400: STXA_I	stxa	%r12, [%r20 + 0x0000] %asi
	.word 0xd895a000  ! 4401: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r12
	.word 0xd6a78e40  ! 4402: STWA_R	stwa	%r11, [%r30 + %r0] 0x72
	.word 0xdcd5c4a0  ! 4403: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r14
	.word 0x87802074  ! 4404: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r26
	.word 0xd4c44400  ! 4406: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r10
	.word 0xdadce000  ! 4407: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xdab4a000  ! 4408: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0xd4cd44a0  ! 4409: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r10
	mov	0x70, %r16
	.word 0xd68fce80  ! 4411: LDUBA_R	lduba	[%r31, %r0] 0x74, %r11
	.word 0xd6bfce80  ! 4412: STDA_R	stda	%r11, [%r31 + %r0] 0x74
	mov	0x3c8, %r20
	.word 0xd2d4a000  ! 4414: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	mov	0x78, %r16
	.word 0xdeb6c9e0  ! 4416: STHA_R	stha	%r15, [%r27 + %r0] 0x4f
	.word 0xd2ac6000  ! 4417: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	mov	0x68, %r16
	.word 0xd0944400  ! 4419: LDUHA_R	lduha	[%r17, %r0] 0x20, %r8
	.word 0xd6b584a0  ! 4420: STHA_R	stha	%r11, [%r22 + %r0] 0x25
	mov	0x3f8, %r22
	.word 0x87802072  ! 4422: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaaf6000  ! 4423: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	mov	0x3d8, %r21
	mov	0x60, %r18
	.word 0x87802073  ! 4426: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf5a000  ! 4427: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xdabde000  ! 4428: STDA_I	stda	%r13, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 4429: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 4430: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 4431: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabd6000  ! 4432: STDA_I	stda	%r13, [%r21 + 0x0000] %asi
	.word 0xd086c9e0  ! 4433: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r8
	.word 0xdebde000  ! 4434: STDA_I	stda	%r15, [%r23 + 0x0000] %asi
	mov	0x0, %r25
	mov	0x70, %r16
	.word 0xded5e000  ! 4437: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r15
	mov	0x0, %r24
	.word 0x87802025  ! 4439: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 4440: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4af0e60  ! 4441: STBA_R	stba	%r10, [%r28 + %r0] 0x73
	.word 0xd895c4a0  ! 4442: LDUHA_R	lduha	[%r23, %r0] 0x25, %r12
	mov	0x28, %r24
	.word 0xd8c689e0  ! 4444: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r12
	.word 0xd6c4a000  ! 4445: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r11
	.word 0xd2c78e40  ! 4446: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r9
	.word 0xd4cc6000  ! 4447: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	.word 0xd4f4e000  ! 4448: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 4449: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bfce60  ! 4450: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	.word 0xd0c504a0  ! 4451: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r8
	.word 0xdebf0e40  ! 4452: STDA_R	stda	%r15, [%r28 + %r0] 0x72
	.word 0xdc8fce60  ! 4453: LDUBA_R	lduba	[%r31, %r0] 0x73, %r14
	.word 0xd2b7ce40  ! 4454: STHA_R	stha	%r9, [%r31 + %r0] 0x72
	.word 0xd0b76000  ! 4455: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd0c504a0  ! 4456: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r8
	.word 0xdcae89e0  ! 4457: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	.word 0xd0d70e40  ! 4458: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r8
	mov	0x18, %r19
	.word 0x87802025  ! 4460: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc942000  ! 4461: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	mov	0x60, %r26
	mov	0x3e0, %r22
	.word 0xdaf74e40  ! 4464: STXA_R	stxa	%r13, [%r29 + %r0] 0x72
	mov	0x58, %r16
	.word 0x87802072  ! 4466: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd894e000  ! 4467: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r12
	.word 0xd89ce000  ! 4468: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4469: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r21
	mov	0x38, %r26
	.word 0xd88ca000  ! 4472: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	.word 0xd8ac2000  ! 4473: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0xd8f4e000  ! 4474: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	mov	0x30, %r24
	.word 0xda8c8400  ! 4476: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	.word 0xdcdce000  ! 4477: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r14
	.word 0xd8d7ce80  ! 4478: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r12
	mov	0x7c8, %r20
	.word 0xdc9c2000  ! 4480: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r14
	.word 0x87802025  ! 4481: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 4482: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r17
	.word 0xd8cf8e60  ! 4484: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r12
	mov	0x3d0, %r21
	mov	0x0, %r16
	.word 0xde84a000  ! 4487: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	.word 0xdc9cc400  ! 4488: LDDA_R	ldda	[%r19, %r0] 0x20, %r14
	.word 0xd49ca000  ! 4489: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd4f4e000  ! 4490: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	wr_tick_cmpr_3_47:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc6, %g2
	or	%g4, 0x8c, %g4
	or	%g6, 0xd8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 4492: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8978e40  ! 4493: LDUHA_R	lduha	[%r30, %r0] 0x72, %r12
	.word 0xd2a4c400  ! 4494: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0x87802074  ! 4495: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdab42000  ! 4496: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xdaac2000  ! 4497: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 4498: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabfa000  ! 4499: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdaf72000  ! 4500: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xd2970e40  ! 4501: LDUHA_R	lduha	[%r28, %r0] 0x72, %r9
	mov	0x70, %r17
	.word 0xdeaf0e60  ! 4503: STBA_R	stba	%r15, [%r28 + %r0] 0x73
	wr_tick_cmpr_3_48:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xde, %g2
	or	%g4, 0xb6, %g4
	or	%g6, 0xe1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdccfa000  ! 4505: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xd4f544a0  ! 4506: STXA_R	stxa	%r10, [%r21 + %r0] 0x25
	.word 0x87802020  ! 4507: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 4508: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6aee000  ! 4509: STBA_I	stba	%r11, [%r27 + 0x0000] %asi
	.word 0xd8b74e60  ! 4510: STHA_R	stha	%r12, [%r29 + %r0] 0x73
	.word 0xdad649e0  ! 4511: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r13
	mov	0x50, %r17
	mov	0x20, %r18
	.word 0xd6b62000  ! 4514: STHA_I	stha	%r11, [%r24 + 0x0000] %asi
	.word 0xd6ce6000  ! 4515: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r11
	mov	0x0, %r18
	.word 0xdca70e40  ! 4517: STWA_R	stwa	%r14, [%r28 + %r0] 0x72
	.word 0xd6a44400  ! 4518: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0x87802074  ! 4519: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 4520: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 4521: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda8f8e60  ! 4522: LDUBA_R	lduba	[%r30, %r0] 0x73, %r13
	mov	0x70, %r26
	.word 0xdabc2000  ! 4524: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4525: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cf0e40  ! 4526: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r9
	.word 0x87802020  ! 4527: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b46000  ! 4528: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xde9c0400  ! 4529: LDDA_R	ldda	[%r16, %r0] 0x20, %r15
	mov	0x10, %r17
	.word 0xd6c4c400  ! 4531: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r11
	mov	0x3d0, %r21
	.word 0xd4d4c400  ! 4533: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0xdc842000  ! 4534: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	.word 0xd0dd44a0  ! 4535: LDXA_R	ldxa	[%r21, %r0] 0x25, %r8
	.word 0xdcd46000  ! 4536: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	mov	0x30, %r18
	.word 0xdcb42000  ! 4538: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 4539: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9c8400  ! 4540: LDDA_R	ldda	[%r18, %r0] 0x20, %r13
	.word 0xdea74e80  ! 4541: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	.word 0xd4dc4400  ! 4542: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	.word 0xdea544a0  ! 4543: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	.word 0xd48e49e0  ! 4544: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r10
	.word 0xd6952000  ! 4545: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r11
	.word 0xdc9f8e40  ! 4546: LDDA_R	ldda	[%r30, %r0] 0x72, %r14
	.word 0xd48f4e60  ! 4547: LDUBA_R	lduba	[%r29, %r0] 0x73, %r10
	.word 0xdef52000  ! 4548: STXA_I	stxa	%r15, [%r20 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x50, %r27
	mov	0x78, %r24
	.word 0xdef56000  ! 4552: STXA_I	stxa	%r15, [%r21 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0xde9d6000  ! 4554: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r15
	.word 0xdecda000  ! 4555: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r15
	mov	0x48, %r19
	.word 0x87802072  ! 4557: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 4558: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebc6000  ! 4559: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xdef46000  ! 4560: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xd4be49e0  ! 4561: STDA_R	stda	%r10, [%r25 + %r0] 0x4f
	wr_tick_cmpr_3_49:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf2, %g2
	or	%g4, 0x8b, %g4
	or	%g6, 0xf0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802072  ! 4563: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebea000  ! 4564: STDA_I	stda	%r15, [%r26 + 0x0000] %asi
	.word 0x87802073  ! 4565: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r24
	.word 0xd4a649e0  ! 4567: STWA_R	stwa	%r10, [%r25 + %r0] 0x4f
	.word 0xd6aca000  ! 4568: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xdca78e40  ! 4569: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	.word 0xd69cc400  ! 4570: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	mov	0x7c8, %r22
	.word 0x87802072  ! 4572: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6a5e000  ! 4573: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	.word 0xd6956000  ! 4574: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r11
	.word 0x87802073  ! 4575: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd696e000  ! 4576: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	.word 0xd696a000  ! 4577: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r11
	.word 0xd6ce2000  ! 4578: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	.word 0xdef78e80  ! 4579: STXA_R	stxa	%r15, [%r30 + %r0] 0x74
	.word 0x87802072  ! 4580: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b40400  ! 4581: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0x87802020  ! 4582: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab76000  ! 4583: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdaa7e000  ! 4584: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xdab76000  ! 4585: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdacfa000  ! 4586: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 4587: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0c584a0  ! 4588: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r8
	.word 0xd29ce000  ! 4589: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xdccc4400  ! 4590: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r14
	mov	0x7c8, %r22
	.word 0x8780204f  ! 4592: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a72000  ! 4593: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	mov	0x60, %r18
	ta	T_CHANGE_HPRIV	! macro
	.word 0x8780204f  ! 4596: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r26
	mov	0x58, %r16
	.word 0xd4876000  ! 4599: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	mov	0x38, %r27
	.word 0xd4b72000  ! 4601: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xd4af4e40  ! 4603: STBA_R	stba	%r10, [%r29 + %r0] 0x72
	.word 0xd0be09e0  ! 4604: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0xd0a74e80  ! 4605: STWA_R	stwa	%r8, [%r29 + %r0] 0x74
	mov	0x50, %r19
	.word 0x87802072  ! 4607: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2dd44a0  ! 4608: LDXA_R	ldxa	[%r21, %r0] 0x25, %r9
	.word 0xd8cc0400  ! 4609: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	.word 0xd2cc2000  ! 4610: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r9
	.word 0xd294a000  ! 4611: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r9
	.word 0xdcac0400  ! 4612: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0x87802073  ! 4613: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6a74e80  ! 4614: STWA_R	stwa	%r11, [%r29 + %r0] 0x74
	.word 0xdaa4a000  ! 4615: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xd2a44400  ! 4616: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	mov	0x70, %r27
	.word 0xd4f4a000  ! 4618: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0xd4dc2000  ! 4619: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	.word 0xd2f44400  ! 4620: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	mov	0x7f8, %r21
	.word 0xd0d44400  ! 4622: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r8
	.word 0xd0f48400  ! 4623: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	mov	0x7f8, %r22
	.word 0xd4a78e60  ! 4625: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	.word 0xde9f0e80  ! 4626: LDDA_R	ldda	[%r28, %r0] 0x74, %r15
	mov	0x40, %r16
	.word 0xd09ce000  ! 4628: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r8
	.word 0xd4ae89e0  ! 4629: STBA_R	stba	%r10, [%r26 + %r0] 0x4f
	.word 0xd4b4e000  ! 4630: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 4631: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r20
	mov	0x60, %r17
	mov	0x3d0, %r21
	.word 0xd4f6a000  ! 4635: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	mov	0x10, %r18
	.word 0xd49ea000  ! 4637: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	.word 0xd4b66000  ! 4638: STHA_I	stha	%r10, [%r25 + 0x0000] %asi
	.word 0xd4aee000  ! 4639: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	.word 0xd4b6a000  ! 4640: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	.word 0xd4b6e000  ! 4641: STHA_I	stha	%r10, [%r27 + 0x0000] %asi
	.word 0xd4d6e000  ! 4642: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r10
	.word 0xd2be89e0  ! 4643: STDA_R	stda	%r9, [%r26 + %r0] 0x4f
	mov	0x40, %r17
	mov	0x18, %r24
	.word 0xdea66000  ! 4646: STWA_I	stwa	%r15, [%r25 + 0x0000] %asi
	.word 0xd4ac0400  ! 4647: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0x87802025  ! 4648: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebfa000  ! 4649: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xd0dc8400  ! 4650: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0x87802073  ! 4651: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2df4e40  ! 4652: LDXA_R	ldxa	[%r29, %r0] 0x72, %r9
	mov	0x30, %r24
	.word 0xdea62000  ! 4654: STWA_I	stwa	%r15, [%r24 + 0x0000] %asi
	.word 0xde9ea000  ! 4655: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r15
	.word 0xdebe2000  ! 4656: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	.word 0xd49c4400  ! 4657: LDDA_R	ldda	[%r17, %r0] 0x20, %r10
	.word 0xd8f70e80  ! 4658: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	mov	0x50, %r26
	.word 0x87802020  ! 4660: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8af0e60  ! 4661: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	mov	0x78, %r25
	mov	0x7f0, %r22
	.word 0x87802025  ! 4664: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r19
	mov	0x50, %r24
	.word 0x87802025  ! 4667: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 4668: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8ce6000  ! 4669: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r12
	mov	0x3e0, %r22
	mov	0x78, %r18
	mov	0x8, %r26
	mov	0x30, %r17
	mov	0x48, %r24
	.word 0xd8f6a000  ! 4675: STXA_I	stxa	%r12, [%r26 + 0x0000] %asi
	.word 0xd8c62000  ! 4676: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r12
	.word 0xdcbf0e40  ! 4677: STDA_R	stda	%r14, [%r28 + %r0] 0x72
	.word 0xdeae6000  ! 4678: STBA_I	stba	%r15, [%r25 + 0x0000] %asi
	mov	0x18, %r19
	.word 0xdecea000  ! 4680: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r15
	.word 0xdec6a000  ! 4681: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r15
	.word 0xdedea000  ! 4682: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r15
	.word 0xdeb62000  ! 4683: STHA_I	stha	%r15, [%r24 + 0x0000] %asi
	mov	0x8, %r26
	.word 0x87802072  ! 4685: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0c7ce40  ! 4686: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r8
	mov	0x7c0, %r21
	.word 0xdc8c2000  ! 4688: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 4689: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r19
	mov	0x10, %r27
	.word 0xdcbca000  ! 4692: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	mov	0x50, %r16
	.word 0xdca4a000  ! 4694: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	mov	0x68, %r16
	.word 0xdcd4a000  ! 4696: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	mov	0x0, %r18
	.word 0xdc9dc4a0  ! 4698: LDDA_R	ldda	[%r23, %r0] 0x25, %r14
	.word 0xd4f4a000  ! 4699: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0xd4dca000  ! 4700: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	.word 0xd49c2000  ! 4701: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	.word 0x87802020  ! 4702: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c76000  ! 4703: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	.word 0xdeacc400  ! 4704: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xd8a72000  ! 4705: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	mov	0x20, %r16
	.word 0x87802073  ! 4707: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4708: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r18
	mov	0x70, %r16
	mov	0x3d8, %r20
	.word 0xd6af0e40  ! 4712: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	mov	0x7d8, %r22
	.word 0xd2b504a0  ! 4714: STHA_R	stha	%r9, [%r20 + %r0] 0x25
	.word 0xdc84a000  ! 4715: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	.word 0x87802072  ! 4716: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r16
	.word 0xdca44400  ! 4718: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0xdea78e60  ! 4719: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	.word 0xd4d42000  ! 4720: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	mov	0x10, %r17
	.word 0xd097ce60  ! 4722: LDUHA_R	lduha	[%r31, %r0] 0x73, %r8
	.word 0xdcf46000  ! 4723: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdcf4a000  ! 4724: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xd6a4c400  ! 4725: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	mov	0x60, %r25
	.word 0xd2b544a0  ! 4727: STHA_R	stha	%r9, [%r21 + %r0] 0x25
	mov	0x3e0, %r20
	.word 0xd6874e40  ! 4729: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r11
	.word 0xded46000  ! 4730: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	.word 0xda9c8400  ! 4731: LDDA_R	ldda	[%r18, %r0] 0x20, %r13
	.word 0xdca48400  ! 4732: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xdcd7ce80  ! 4733: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r14
	.word 0xdef4e000  ! 4734: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xd0bfce40  ! 4735: STDA_R	stda	%r8, [%r31 + %r0] 0x72
	mov	0x8, %r16
	.word 0xd6d42000  ! 4737: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r11
	.word 0xd6aca000  ! 4738: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xdad74e40  ! 4739: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r13
	.word 0xd6b504a0  ! 4740: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	mov	0x70, %r19
	.word 0xdc86c9e0  ! 4742: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r14
	.word 0xd4d4e000  ! 4743: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	mov	0x10, %r17
	.word 0xd4a4a000  ! 4745: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xdc87ce60  ! 4746: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r14
	.word 0xdea4a000  ! 4747: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	mov	0x10, %r19
	.word 0xde9c6000  ! 4749: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0xd8c649e0  ! 4750: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r12
	.word 0xd8d4a000  ! 4751: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	mov	0x78, %r26
	mov	0x3e8, %r21
	.word 0xd8c42000  ! 4754: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r12
	.word 0xd8ace000  ! 4755: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0xd09dc4a0  ! 4756: LDDA_R	ldda	[%r23, %r0] 0x25, %r8
	.word 0xde9c6000  ! 4757: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0x87802020  ! 4758: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca7ce60  ! 4759: STWA_R	stwa	%r14, [%r31 + %r0] 0x73
	.word 0xd0a46000  ! 4760: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xd69d04a0  ! 4761: LDDA_R	ldda	[%r20, %r0] 0x25, %r11
	mov	0x7c8, %r21
	mov	0x50, %r19
	mov	0x38, %r16
	.word 0xd8ac6000  ! 4765: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xd8d46000  ! 4766: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	.word 0xd09e89e0  ! 4767: LDDA_R	ldda	[%r26, %r0] 0x4f, %r8
	mov	0x58, %r19
	.word 0xdacca000  ! 4769: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	.word 0xda8ca000  ! 4770: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r13
	.word 0xdabca000  ! 4771: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 4772: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa48400  ! 4773: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0xd2afa000  ! 4774: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 4775: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2976000  ! 4776: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0xd2f72000  ! 4777: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd2f7e000  ! 4778: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 4779: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bea000  ! 4780: STDA_I	stda	%r9, [%r26 + 0x0000] %asi
	.word 0xd2b66000  ! 4781: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	mov	0x68, %r17
	.word 0x87802074  ! 4783: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bc6000  ! 4784: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	mov	0x7e0, %r20
	.word 0xdcb70e80  ! 4786: STHA_R	stha	%r14, [%r28 + %r0] 0x74
	.word 0xd8942000  ! 4787: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r12
	.word 0xd8b42000  ! 4788: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	.word 0xdea78e40  ! 4789: STWA_R	stwa	%r15, [%r30 + %r0] 0x72
	.word 0xd895c4a0  ! 4790: LDUHA_R	lduha	[%r23, %r0] 0x25, %r12
	.word 0xde94c400  ! 4791: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	.word 0x8780204f  ! 4792: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bf0e60  ! 4793: STDA_R	stda	%r10, [%r28 + %r0] 0x73
	.word 0xd09c8400  ! 4794: LDDA_R	ldda	[%r18, %r0] 0x20, %r8
	.word 0xd4a70e80  ! 4795: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	.word 0xde95c4a0  ! 4796: LDUHA_R	lduha	[%r23, %r0] 0x25, %r15
	mov	0x3c8, %r23
	.word 0xdaf4a000  ! 4798: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0xd4a78e80  ! 4800: STWA_R	stwa	%r10, [%r30 + %r0] 0x74
	mov	0x7e8, %r22
	mov	0x3e8, %r23
	.word 0xd0c42000  ! 4803: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r8
	mov	0x3c8, %r20
	.word 0xd0bc2000  ! 4805: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4806: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bc4400  ! 4807: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xd08cc400  ! 4808: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	.word 0xd4cde000  ! 4809: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r10
	.word 0xd4a56000  ! 4810: STWA_I	stwa	%r10, [%r21 + 0x0000] %asi
	.word 0xd88c8400  ! 4811: LDUBA_R	lduba	[%r18, %r0] 0x20, %r12
	.word 0x87802072  ! 4812: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde8c2000  ! 4813: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	mov	0x48, %r26
	.word 0xdc8fce40  ! 4815: LDUBA_R	lduba	[%r31, %r0] 0x72, %r14
	.word 0xd8946000  ! 4816: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	mov	0x3d0, %r20
	.word 0xd0ce09e0  ! 4818: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r8
	.word 0xd8ac6000  ! 4819: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xdcf44400  ! 4820: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	mov	0x3f0, %r23
	mov	0x70, %r18
	mov	0x8, %r19
	.word 0xde94a000  ! 4824: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0x87802074  ! 4825: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeac8400  ! 4826: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xd6f544a0  ! 4827: STXA_R	stxa	%r11, [%r21 + %r0] 0x25
	mov	0x7c8, %r22
	.word 0x87802074  ! 4829: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f78e60  ! 4830: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	.word 0xdab4c400  ! 4831: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0x87802072  ! 4832: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 4833: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 4834: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r17
	.word 0x87802020  ! 4836: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f70e60  ! 4837: STXA_R	stxa	%r11, [%r28 + %r0] 0x73
	mov	0x18, %r24
	.word 0xd28689e0  ! 4839: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r9
	mov	0x20, %r24
	.word 0x87802020  ! 4841: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4842: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8df0e60  ! 4843: LDXA_R	ldxa	[%r28, %r0] 0x73, %r12
	.word 0xd0ad84a0  ! 4844: STBA_R	stba	%r8, [%r22 + %r0] 0x25
	.word 0xd8ac0400  ! 4845: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xd2972000  ! 4846: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0x87802073  ! 4847: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2bf2000  ! 4848: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xdea44400  ! 4849: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0x87802074  ! 4850: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2c6c9e0  ! 4851: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r9
	.word 0xd6f7a000  ! 4852: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd4f44400  ! 4853: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	mov	0x3c0, %r22
	.word 0x87802020  ! 4855: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d52000  ! 4856: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r10
	.word 0xd485a000  ! 4857: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r10
	mov	0x30, %r17
	mov	0x20, %r27
	.word 0xd4f5a000  ! 4860: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	.word 0xd4a52000  ! 4861: STWA_I	stwa	%r10, [%r20 + 0x0000] %asi
	.word 0xd6a5c4a0  ! 4862: STWA_R	stwa	%r11, [%r23 + %r0] 0x25
	.word 0xd2bde000  ! 4863: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 4864: WRASI_I	wr	%r0, 0x004f, %asi
	wr_tick_cmpr_3_50:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xcf, %g2
	or	%g4, 0xd0, %g4
	or	%g6, 0xd3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd6f584a0  ! 4866: STXA_R	stxa	%r11, [%r22 + %r0] 0x25
	.word 0xd4dfe000  ! 4867: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	mov	0x58, %r16
	.word 0xdc9fce80  ! 4869: LDDA_R	ldda	[%r31, %r0] 0x74, %r14
	.word 0xd68504a0  ! 4870: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r11
	mov	0x58, %r24
	.word 0xd8a5c4a0  ! 4872: STWA_R	stwa	%r12, [%r23 + %r0] 0x25
	.word 0x87802072  ! 4873: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8974e40  ! 4874: LDUHA_R	lduha	[%r29, %r0] 0x72, %r12
	.word 0xd2846000  ! 4875: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r9
	.word 0xdab6c9e0  ! 4876: STHA_R	stha	%r13, [%r27 + %r0] 0x4f
	.word 0xd6b4a000  ! 4877: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd2f74e80  ! 4878: STXA_R	stxa	%r9, [%r29 + %r0] 0x74
	.word 0xd0c4e000  ! 4879: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	.word 0xd4b74e60  ! 4880: STHA_R	stha	%r10, [%r29 + %r0] 0x73
	.word 0x87802020  ! 4881: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f7a000  ! 4882: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 4883: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 4884: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4ac4400  ! 4885: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xd0bc0400  ! 4886: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0xdadc6000  ! 4887: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xdaac2000  ! 4888: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0xda84a000  ! 4889: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	.word 0xda9ca000  ! 4890: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	.word 0xdaf42000  ! 4891: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0xdab42000  ! 4892: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	mov	0x3e8, %r23
	.word 0x8780204f  ! 4894: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4dc4400  ! 4895: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	.word 0x87802072  ! 4896: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f6e000  ! 4897: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	.word 0xd2aee000  ! 4898: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	.word 0x87802073  ! 4899: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r18
	mov	0x7c8, %r20
	.word 0xd4f544a0  ! 4902: STXA_R	stxa	%r10, [%r21 + %r0] 0x25
	.word 0x8780204f  ! 4903: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a72000  ! 4904: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd0ae89e0  ! 4905: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	.word 0xd4976000  ! 4906: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r10
	.word 0xd8cc8400  ! 4907: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0x87802072  ! 4908: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc9f0e80  ! 4909: LDDA_R	ldda	[%r28, %r0] 0x74, %r14
	.word 0xd2afce80  ! 4910: STBA_R	stba	%r9, [%r31 + %r0] 0x74
	.word 0x87802020  ! 4911: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4912: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4c5a000  ! 4913: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r10
	mov	0x7c8, %r23
	.word 0xd8cec9e0  ! 4915: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r12
	.word 0xd69d04a0  ! 4916: LDDA_R	ldda	[%r20, %r0] 0x25, %r11
	.word 0x8780204f  ! 4917: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4946000  ! 4918: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r10
	.word 0xd08584a0  ! 4919: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r8
	mov	0x20, %r25
	.word 0xded4a000  ! 4921: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	.word 0xd0df8e60  ! 4922: LDXA_R	ldxa	[%r30, %r0] 0x73, %r8
	.word 0xd4d4a000  ! 4923: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0xd4846000  ! 4924: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r10
	.word 0xd2bdc4a0  ! 4925: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	mov	0x3f0, %r22
	mov	0x18, %r16
	mov	0x18, %r16
	mov	0x3e0, %r22
	wr_tick_cmpr_3_51:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x98, %g2
	or	%g4, 0x90, %g4
	or	%g6, 0xc0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	wr_tick_cmpr_3_52:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x8b, %g2
	or	%g4, 0xc1, %g4
	or	%g6, 0xc1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7f8, %r21
	.word 0xdcb46000  ! 4933: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xdc94a000  ! 4934: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	mov	0x30, %r27
	.word 0xdcf4a000  ! 4936: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcf46000  ! 4937: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdcf4a000  ! 4938: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0xd6dec9e0  ! 4940: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r11
	.word 0xd8bc2000  ! 4941: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 4942: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 4943: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd69dc4a0  ! 4944: LDDA_R	ldda	[%r23, %r0] 0x25, %r11
	mov	0x70, %r17
	.word 0xd8b7e000  ! 4946: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 4947: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef7ce40  ! 4948: STXA_R	stxa	%r15, [%r31 + %r0] 0x72
	mov	0x3e0, %r22
	mov	0x18, %r27
	.word 0xd0c4a000  ! 4951: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0dc6000  ! 4952: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	mov	0x7c0, %r22
	mov	0x20, %r17
	.word 0xdcc609e0  ! 4955: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r14
	.word 0x87802072  ! 4956: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4dfe000  ! 4957: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4c72000  ! 4958: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r10
	mov	0x58, %r19
	.word 0xd6dec9e0  ! 4960: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r11
	.word 0x87802020  ! 4961: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0c74e80  ! 4962: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r8
	.word 0xdaaf0e40  ! 4963: STBA_R	stba	%r13, [%r28 + %r0] 0x72
	mov	0x3e8, %r20
	.word 0x87802072  ! 4965: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a4a000  ! 4966: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xd884c400  ! 4967: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	mov	0x50, %r16
	.word 0xd0b4a000  ! 4969: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xd0d46000  ! 4970: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r8
	.word 0x87802020  ! 4971: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdecfce60  ! 4972: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r15
	.word 0xd4d42000  ! 4973: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	.word 0xd2bcc400  ! 4974: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xd0a4e000  ! 4975: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 4976: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf70e40  ! 4977: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	.word 0xdaafa000  ! 4978: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdabfe000  ! 4979: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xdaaf2000  ! 4980: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	mov	0x3c8, %r20
	.word 0xd8b4c400  ! 4982: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0xdcafa000  ! 4983: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xd8a7ce60  ! 4984: STWA_R	stwa	%r12, [%r31 + %r0] 0x73
	.word 0xd0cf4e40  ! 4985: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	.word 0xd8ac8400  ! 4986: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0xdabf6000  ! 4987: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	mov	0x40, %r19
	mov	0x18, %r24
	.word 0x87802073  ! 4990: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r16
	.word 0xda9f6000  ! 4992: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xdab72000  ! 4993: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 4994: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda9ca000  ! 4995: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	mov	0x18, %r26
	.word 0x87802072  ! 4997: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc878e60  ! 4998: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r14
	mov	0x28, %r18
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_2:
	wr_tick_cmpr_2_0:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xdf, %g2
	or	%g4, 0xbd, %g4
	or	%g6, 0x93, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdacfe000  ! 1: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0xdccf0e60  ! 2: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r14
	mov	0x50, %r27
	.word 0xd0b7e000  ! 4: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 5: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0944400  ! 6: LDUHA_R	lduha	[%r17, %r0] 0x20, %r8
	.word 0x87802025  ! 7: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 8: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r17
	.word 0xd4f46000  ! 10: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0xd49ca000  ! 11: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd4942000  ! 12: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r10
	.word 0xd4bce000  ! 13: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	mov	0x48, %r16
	.word 0xd4cce000  ! 15: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	.word 0xdc8c8400  ! 16: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0xd6b78e40  ! 17: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	.word 0xd884a000  ! 18: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r12
	.word 0xde9c8400  ! 19: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	.word 0xd8cf8e60  ! 20: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r12
	.word 0xd6b42000  ! 21: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0xdac48400  ! 22: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	mov	0x58, %r18
	mov	0x48, %r19
	.word 0xd4f544a0  ! 25: STXA_R	stxa	%r10, [%r21 + %r0] 0x25
	mov	0x3f8, %r20
	.word 0xdeb40400  ! 27: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0xd6f4a000  ! 28: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	.word 0xd6ae89e0  ! 29: STBA_R	stba	%r11, [%r26 + %r0] 0x4f
	mov	0x28, %r19
	.word 0xdad46000  ! 31: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	mov	0x68, %r26
	.word 0xdabc6000  ! 33: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xdaf4e000  ! 34: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	mov	0x70, %r18
	.word 0xd2a504a0  ! 36: STWA_R	stwa	%r9, [%r20 + %r0] 0x25
	.word 0xd2a4e000  ! 37: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	mov	0x0, %r16
	.word 0xd2b4a000  ! 39: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0xdec7ce60  ! 40: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r15
	.word 0xd4bc2000  ! 41: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0xd4b4a000  ! 42: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	mov	0x3f0, %r21
	mov	0x40, %r16
	.word 0xd4a4a000  ! 45: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 46: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0d78e80  ! 47: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r8
	.word 0xd09649e0  ! 48: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r8
	.word 0xd4b7ce40  ! 49: STHA_R	stha	%r10, [%r31 + %r0] 0x72
	.word 0xdaaf8e60  ! 50: STBA_R	stba	%r13, [%r30 + %r0] 0x73
	mov	0x78, %r24
	.word 0xdcf4c400  ! 52: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xdedd84a0  ! 53: LDXA_R	ldxa	[%r22, %r0] 0x25, %r15
	mov	0x50, %r18
	.word 0xdaa5e000  ! 55: STWA_I	stwa	%r13, [%r23 + 0x0000] %asi
	.word 0xdaf5a000  ! 56: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xdabd2000  ! 57: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 58: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdadfa000  ! 59: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xdab7e000  ! 60: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xd897ce60  ! 61: LDUHA_R	lduha	[%r31, %r0] 0x73, %r12
	.word 0xd8a74e80  ! 62: STWA_R	stwa	%r12, [%r29 + %r0] 0x74
	.word 0xd8f649e0  ! 63: STXA_R	stxa	%r12, [%r25 + %r0] 0x4f
	.word 0xd6df2000  ! 64: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6af2000  ! 65: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x7c0, %r21
	mov	0x7e8, %r22
	.word 0xd4f78e40  ! 68: STXA_R	stxa	%r10, [%r30 + %r0] 0x72
	mov	0x3c0, %r20
	.word 0xd8976000  ! 70: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	mov	0x3d0, %r22
	.word 0xd8f7e000  ! 72: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8cfa000  ! 73: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd89fe000  ! 74: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	mov	0x3d0, %r21
	.word 0x87802020  ! 76: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r26
	.word 0xd8d5e000  ! 78: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r12
	.word 0xde8f0e80  ! 79: LDUBA_R	lduba	[%r28, %r0] 0x74, %r15
	mov	0x68, %r16
	.word 0x87802025  ! 81: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r25
	.word 0xd4be6000  ! 83: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0x8780204f  ! 84: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r17
	mov	0x20, %r17
	.word 0xd6a544a0  ! 87: STWA_R	stwa	%r11, [%r21 + %r0] 0x25
	.word 0xd0f78e40  ! 88: STXA_R	stxa	%r8, [%r30 + %r0] 0x72
	.word 0x87802020  ! 89: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa609e0  ! 90: STWA_R	stwa	%r13, [%r24 + %r0] 0x4f
	.word 0xd29f4e60  ! 91: LDDA_R	ldda	[%r29, %r0] 0x73, %r9
	mov	0x58, %r17
	.word 0xd6cfe000  ! 93: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	wr_tick_cmpr_2_1:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xbf, %g2
	or	%g4, 0xdf, %g4
	or	%g6, 0xcd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 95: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f4a000  ! 96: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	.word 0xd6cca000  ! 97: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r11
	.word 0xd6dc0400  ! 98: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	.word 0xd2a584a0  ! 99: STWA_R	stwa	%r9, [%r22 + %r0] 0x25
	mov	0x7d8, %r22
	.word 0xde942000  ! 101: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	.word 0xdeac2000  ! 102: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xdcf44400  ! 103: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	mov	0x3e0, %r23
	.word 0xdc840400  ! 105: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	.word 0xd0ac6000  ! 106: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 107: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r24
	.word 0x87802073  ! 109: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b4c400  ! 110: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0xd4f70e60  ! 111: STXA_R	stxa	%r10, [%r28 + %r0] 0x73
	.word 0xd8c40400  ! 112: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	.word 0xdeccc400  ! 113: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r15
	.word 0x8780204f  ! 114: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 115: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8f2000  ! 116: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	mov	0x18, %r19
	.word 0xdab78e40  ! 118: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	mov	0x7d0, %r22
	mov	0x70, %r18
	.word 0xd48f6000  ! 121: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xdad70e80  ! 122: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r13
	.word 0xd2cfe000  ! 123: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	mov	0x10, %r17
	.word 0xdedf8e40  ! 125: LDXA_R	ldxa	[%r30, %r0] 0x72, %r15
	.word 0xd0b70e80  ! 126: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	.word 0xd4f76000  ! 127: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4b76000  ! 128: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd4b72000  ! 130: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xdcbec9e0  ! 131: STDA_R	stda	%r14, [%r27 + %r0] 0x4f
	.word 0xdeccc400  ! 132: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r15
	.word 0x87802025  ! 133: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0844400  ! 134: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r8
	.word 0xd2f72000  ! 135: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd4f78e40  ! 136: STXA_R	stxa	%r10, [%r30 + %r0] 0x72
	.word 0xd2bf4e80  ! 137: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	mov	0x7d8, %r21
	.word 0xd8c76000  ! 139: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8a76000  ! 140: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 141: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8afe000  ! 142: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd8af6000  ! 143: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	mov	0x50, %r27
	.word 0xda8f4e60  ! 145: LDUBA_R	lduba	[%r29, %r0] 0x73, %r13
	.word 0xd2bf4e80  ! 146: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	.word 0xd6a40400  ! 147: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0xdc944400  ! 148: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	.word 0x8780204f  ! 149: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 150: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0b76000  ! 151: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 152: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0bde000  ! 153: STDA_I	stda	%r8, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 154: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 155: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f42000  ! 156: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0xde8f0e40  ! 157: LDUBA_R	lduba	[%r28, %r0] 0x72, %r15
	.word 0xd2cce000  ! 158: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	.word 0xdcb78e40  ! 159: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	mov	0x20, %r24
	mov	0x3f8, %r21
	.word 0xdaaf8e40  ! 162: STBA_R	stba	%r13, [%r30 + %r0] 0x72
	.word 0xdc9cc400  ! 163: LDDA_R	ldda	[%r19, %r0] 0x20, %r14
	.word 0x87802073  ! 164: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 165: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 166: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6a72000  ! 167: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	mov	0x48, %r19
	mov	0x70, %r25
	mov	0x60, %r16
	.word 0x87802073  ! 171: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r19
	mov	0x10, %r17
	.word 0xd2b44400  ! 174: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0xd087ce40  ! 175: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r8
	.word 0xd0cda000  ! 176: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r8
	.word 0xd0bd6000  ! 177: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 178: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b7a000  ! 179: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	mov	0x40, %r24
	.word 0x87802073  ! 181: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6af4e40  ! 182: STBA_R	stba	%r11, [%r29 + %r0] 0x72
	.word 0xd0bc8400  ! 183: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 184: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r19
	.word 0x87802072  ! 186: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4dea000  ! 187: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	.word 0xd4d6e000  ! 188: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r10
	.word 0xdec5c4a0  ! 189: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r15
	mov	0x3e0, %r23
	.word 0x87802073  ! 191: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f7e000  ! 192: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 193: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d8, %r22
	.word 0xd6b649e0  ! 195: STHA_R	stha	%r11, [%r25 + %r0] 0x4f
	.word 0x8780204f  ! 196: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdadd44a0  ! 197: LDXA_R	ldxa	[%r21, %r0] 0x25, %r13
	.word 0xdef6e000  ! 198: STXA_I	stxa	%r15, [%r27 + 0x0000] %asi
	.word 0xdedf8e80  ! 199: LDXA_R	ldxa	[%r30, %r0] 0x74, %r15
	.word 0xd4ce49e0  ! 200: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r10
	.word 0xd0c7ce80  ! 201: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r8
	.word 0xdc8ea000  ! 202: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r14
	.word 0x87802072  ! 203: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcdf6000  ! 204: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xdc87a000  ! 205: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0x87802073  ! 206: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r16
	.word 0xdef44400  ! 208: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xd4d5c4a0  ! 209: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r10
	.word 0x87802020  ! 210: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ac8400  ! 211: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xd885c4a0  ! 212: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r12
	.word 0xded4c400  ! 213: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r15
	.word 0x87802020  ! 214: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac609e0  ! 215: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r13
	.word 0x87802074  ! 216: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8c6a000  ! 217: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r12
	.word 0xd4b4c400  ! 218: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0x87802072  ! 219: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 220: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdad42000  ! 221: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r13
	.word 0x87802025  ! 222: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r17
	.word 0xdac7a000  ! 224: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xd8cfce80  ! 225: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r12
	.word 0xd0f70e80  ! 226: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0xd4f72000  ! 227: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0xd8de89e0  ! 229: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r12
	.word 0xdcbf0e60  ! 230: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	.word 0xd4dfe000  ! 231: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xdc9689e0  ! 232: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r14
	.word 0xd2b76000  ! 233: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 234: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r25
	.word 0xd8dd44a0  ! 236: LDXA_R	ldxa	[%r21, %r0] 0x25, %r12
	.word 0xdad7ce60  ! 237: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r13
	.word 0xdc9fa000  ! 238: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 239: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r27
	mov	0x3f0, %r20
	mov	0x7c8, %r23
	.word 0xdccfe000  ! 243: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xdcf76000  ! 244: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdc94c400  ! 245: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	.word 0xd887e000  ! 246: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	mov	0x10, %r16
	.word 0xd8d76000  ! 248: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xd8dfe000  ! 249: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	mov	0x3c8, %r22
	.word 0x87802020  ! 251: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 252: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8ae2000  ! 253: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	.word 0xd8de2000  ! 254: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r12
	mov	0x48, %r18
	.word 0xd0a504a0  ! 256: STWA_R	stwa	%r8, [%r20 + %r0] 0x25
	.word 0xd8bc0400  ! 257: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0x87802020  ! 258: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcac4400  ! 259: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	mov	0x7d8, %r20
	.word 0xdcbfe000  ! 261: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdcf504a0  ! 262: STXA_R	stxa	%r14, [%r20 + %r0] 0x25
	.word 0xdccfe000  ! 263: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xd0dd84a0  ! 264: LDXA_R	ldxa	[%r22, %r0] 0x25, %r8
	mov	0x8, %r27
	.word 0x87802074  ! 266: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f0, %r22
	mov	0x0, %r17
	.word 0xd6cc2000  ! 269: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	.word 0xdabc4400  ! 270: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 271: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f649e0  ! 272: STXA_R	stxa	%r9, [%r25 + %r0] 0x4f
	mov	0x58, %r16
	.word 0x87802020  ! 274: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 275: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69fa000  ! 276: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0xd6afa000  ! 277: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xd4dd44a0  ! 279: LDXA_R	ldxa	[%r21, %r0] 0x25, %r10
	.word 0xd6cc4400  ! 280: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	.word 0xd68fe000  ! 281: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xda9cc400  ! 282: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	.word 0xd8dfa000  ! 283: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0x87802074  ! 284: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8a7e000  ! 285: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8dfe000  ! 286: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8d76000  ! 287: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	mov	0x3c0, %r21
	wr_tick_cmpr_2_2:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xed, %g2
	or	%g4, 0x9f, %g4
	or	%g6, 0xe6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8b7a000  ! 290: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 291: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8dee000  ! 292: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r12
	.word 0x87802072  ! 293: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6d7ce40  ! 294: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r11
	.word 0x87802020  ! 295: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6be89e0  ! 296: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	.word 0xd6b504a0  ! 297: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	.word 0xd6b7ce80  ! 298: STHA_R	stha	%r11, [%r31 + %r0] 0x74
	.word 0xdab7ce40  ! 299: STHA_R	stha	%r13, [%r31 + %r0] 0x72
	.word 0x87802020  ! 300: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b74e60  ! 301: STHA_R	stha	%r10, [%r29 + %r0] 0x73
	.word 0xd4b7e000  ! 302: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd4cf2000  ! 303: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd497a000  ! 304: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0xd8a4c400  ! 305: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	mov	0x30, %r17
	.word 0xd6a76000  ! 307: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	mov	0x68, %r24
	.word 0xd8944400  ! 309: LDUHA_R	lduha	[%r17, %r0] 0x20, %r12
	.word 0xd284c400  ! 310: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r9
	.word 0x87802074  ! 311: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 312: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf40400  ! 313: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xdad7a000  ! 314: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0xda87e000  ! 315: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0xd2b44400  ! 316: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0x87802025  ! 317: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0dc4400  ! 318: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	.word 0x87802020  ! 319: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r19
	.word 0xd4c48400  ! 321: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r10
	.word 0xdea7a000  ! 322: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 323: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde942000  ! 324: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	mov	0x3d0, %r23
	mov	0x60, %r16
	mov	0x8, %r26
	mov	0x7e0, %r22
	.word 0xd2cf4e80  ! 329: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r9
	.word 0x87802072  ! 330: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd09da000  ! 331: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r8
	.word 0xdab544a0  ! 332: STHA_R	stha	%r13, [%r21 + %r0] 0x25
	.word 0xd6b5a000  ! 333: STHA_I	stha	%r11, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 334: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c42000  ! 335: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r11
	.word 0xdcf70e60  ! 336: STXA_R	stxa	%r14, [%r28 + %r0] 0x73
	.word 0x87802020  ! 337: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8af6000  ! 338: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd8b7e000  ! 339: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0x87802025  ! 341: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r24
	mov	0x3c8, %r20
	.word 0xd8dca000  ! 344: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	.word 0xd2dd44a0  ! 345: LDXA_R	ldxa	[%r21, %r0] 0x25, %r9
	.word 0xd8ace000  ! 346: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	mov	0x3f8, %r22
	.word 0xd08cc400  ! 348: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	.word 0xd6a46000  ! 349: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0xd6bc6000  ! 350: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0xdcbcc400  ! 351: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0x87802072  ! 352: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa72000  ! 353: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	mov	0x3e0, %r20
	.word 0x87802072  ! 355: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r27
	.word 0xdabe89e0  ! 357: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	.word 0xd2dc0400  ! 358: LDXA_R	ldxa	[%r16, %r0] 0x20, %r9
	.word 0x8780204f  ! 359: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r25
	mov	0x50, %r17
	mov	0x7e8, %r21
	.word 0xd6b74e80  ! 363: STHA_R	stha	%r11, [%r29 + %r0] 0x74
	.word 0xda9ca000  ! 364: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	mov	0x3d0, %r21
	mov	0x3c8, %r20
	.word 0x87802074  ! 367: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb6c9e0  ! 368: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	.word 0xd8ad44a0  ! 369: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	.word 0xd4bc0400  ! 370: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xdebf4e80  ! 371: STDA_R	stda	%r15, [%r29 + %r0] 0x74
	mov	0x7d0, %r23
	.word 0xd6a5e000  ! 373: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	.word 0xd2cf0e40  ! 374: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r9
	.word 0xd0df4e60  ! 375: LDXA_R	ldxa	[%r29, %r0] 0x73, %r8
	.word 0xdacc0400  ! 376: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r13
	.word 0xd2cde000  ! 377: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r9
	mov	0x58, %r26
	.word 0xd2ad6000  ! 379: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	mov	0x40, %r24
	.word 0xd08cc400  ! 381: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	.word 0xd49f4e40  ! 382: LDDA_R	ldda	[%r29, %r0] 0x72, %r10
	mov	0x60, %r19
	ta	T_CHANGE_NONPRIV	! macro
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdaf56000  ! 386: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	.word 0xdadd6000  ! 387: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r13
	.word 0x87802020  ! 388: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6878e60  ! 389: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r11
	.word 0x8780204f  ! 390: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2df2000  ! 391: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2bfa000  ! 392: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	mov	0x78, %r19
	.word 0xd2cfa000  ! 394: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	wr_tick_cmpr_2_3:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xba, %g2
	or	%g4, 0x99, %g4
	or	%g6, 0xfc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 396: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f76000  ! 397: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xdc878e40  ! 398: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r14
	mov	0x38, %r24
	mov	0x30, %r16
	.word 0xd6afe000  ! 401: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd48f4e60  ! 402: LDUBA_R	lduba	[%r29, %r0] 0x73, %r10
	.word 0xd8f504a0  ! 403: STXA_R	stxa	%r12, [%r20 + %r0] 0x25
	mov	0x3d8, %r23
	.word 0xdebfa000  ! 405: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xd2878e60  ! 406: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r9
	mov	0x7e8, %r22
	mov	0x3c8, %r20
	.word 0xdc972000  ! 409: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	.word 0xdc948400  ! 410: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	.word 0x87802073  ! 411: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8be49e0  ! 412: STDA_R	stda	%r12, [%r25 + %r0] 0x4f
	.word 0xd89cc400  ! 413: LDDA_R	ldda	[%r19, %r0] 0x20, %r12
	mov	0x18, %r16
	mov	0x0, %r26
	mov	0x7e8, %r21
	mov	0x28, %r19
	.word 0x87802074  ! 418: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 419: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a44400  ! 420: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0x87802020  ! 421: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c4e000  ! 422: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r10
	.word 0xd2bc4400  ! 423: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0xd4ce89e0  ! 424: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r10
	.word 0xd4a4a000  ! 425: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xd2a7ce60  ! 426: STWA_R	stwa	%r9, [%r31 + %r0] 0x73
	.word 0x87802020  ! 427: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r20
	.word 0xd0f609e0  ! 429: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	.word 0xd8afe000  ! 430: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 431: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r16
	.word 0x87802020  ! 433: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r16
	.word 0xd8ad2000  ! 435: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	.word 0x87802025  ! 436: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r16
	.word 0xd8b76000  ! 438: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	mov	0x38, %r24
	.word 0xd8976000  ! 440: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0xd4dec9e0  ! 441: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r10
	.word 0x87802074  ! 442: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbde000  ! 443: STDA_I	stda	%r14, [%r23 + 0x0000] %asi
	.word 0xdc8d2000  ! 444: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r14
	.word 0xd6af8e80  ! 445: STBA_R	stba	%r11, [%r30 + %r0] 0x74
	.word 0xd88d6000  ! 446: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r12
	.word 0xd8cd2000  ! 447: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r12
	mov	0x7d0, %r20
	.word 0xdebfce80  ! 449: STDA_R	stda	%r15, [%r31 + %r0] 0x74
	.word 0xd2a44400  ! 450: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xdef44400  ! 451: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	mov	0x7c0, %r20
	.word 0x87802020  ! 453: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabf6000  ! 454: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xda8cc400  ! 455: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	.word 0xd6d40400  ! 456: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	.word 0xd6b7a000  ! 457: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xdeb5c4a0  ! 458: STHA_R	stha	%r15, [%r23 + %r0] 0x25
	.word 0xd6cd84a0  ! 459: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r11
	.word 0xde9f4e40  ! 460: LDDA_R	ldda	[%r29, %r0] 0x72, %r15
	mov	0x28, %r27
	.word 0xd4f76000  ! 462: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 463: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a7a000  ! 464: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4a76000  ! 465: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd49f6000  ! 466: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0xd4a7e000  ! 467: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4d7e000  ! 468: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	.word 0xd89fce40  ! 469: LDDA_R	ldda	[%r31, %r0] 0x72, %r12
	.word 0x8780204f  ! 470: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda8d84a0  ! 471: LDUBA_R	lduba	[%r22, %r0] 0x25, %r13
	.word 0xd6a7a000  ! 472: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xdecf8e40  ! 473: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r15
	mov	0x58, %r25
	.word 0xd2bfe000  ! 475: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd28f2000  ! 477: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	.word 0xd8848400  ! 478: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r12
	.word 0xda87a000  ! 479: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	mov	0x68, %r17
	.word 0xdab70e40  ! 481: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	.word 0xdadf2000  ! 482: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	mov	0x78, %r27
	.word 0xda87e000  ! 484: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0xd2a48400  ! 485: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	mov	0x10, %r17
	.word 0xd8c7a000  ! 487: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8acc400  ! 488: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0xdcf4c400  ! 489: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xd8a7a000  ! 490: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 491: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 492: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r17
	.word 0xd8bf6000  ! 494: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd8c72000  ! 495: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8c40400  ! 496: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	.word 0xdea7a000  ! 497: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xdedf6000  ! 498: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xd4c78e60  ! 499: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r10
	.word 0xd29f6000  ! 500: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xd2dfe000  ! 501: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0x87802074  ! 502: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r26
	.word 0xd2ade000  ! 504: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0xd6de49e0  ! 505: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r11
	.word 0xd8a5e000  ! 506: STWA_I	stwa	%r12, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 507: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 508: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8a46000  ! 509: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 510: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb78e40  ! 511: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xd0d42000  ! 512: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r8
	.word 0xd0d46000  ! 513: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r8
	.word 0xd09ce000  ! 514: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r8
	.word 0x87802020  ! 515: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f42000  ! 516: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0xd0d4e000  ! 517: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	.word 0xd28f0e60  ! 518: LDUBA_R	lduba	[%r28, %r0] 0x73, %r9
	mov	0x7d8, %r23
	.word 0xd49e89e0  ! 520: LDDA_R	ldda	[%r26, %r0] 0x4f, %r10
	mov	0x78, %r17
	.word 0xd08504a0  ! 522: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r8
	.word 0x87802074  ! 523: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde872000  ! 524: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	mov	0x3f8, %r23
	.word 0xdea7e000  ! 526: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xd2b4c400  ! 527: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xd0f40400  ! 528: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0x87802020  ! 529: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a40400  ! 530: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	.word 0xd28584a0  ! 531: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r9
	.word 0xda972000  ! 532: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0xda876000  ! 533: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0xde9544a0  ! 534: LDUHA_R	lduha	[%r21, %r0] 0x25, %r15
	mov	0x30, %r17
	.word 0xd4bd84a0  ! 536: STDA_R	stda	%r10, [%r22 + %r0] 0x25
	.word 0xdeb76000  ! 537: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	mov	0x3f8, %r20
	mov	0x18, %r18
	.word 0xdec44400  ! 540: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0xd0c78e40  ! 541: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r8
	mov	0x0, %r26
	.word 0xd6c72000  ! 543: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0xd4bf0e40  ! 544: STDA_R	stda	%r10, [%r28 + %r0] 0x72
	.word 0x87802025  ! 545: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 546: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 547: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r24
	mov	0x8, %r17
	.word 0xdad5e000  ! 550: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r13
	ta	T_CHANGE_PRIV	! macro
	.word 0xdad609e0  ! 552: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r13
	mov	0x3e0, %r20
	wr_tick_cmpr_2_4:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xef, %g2
	or	%g4, 0xe1, %g4
	or	%g6, 0xd0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802074  ! 555: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r26
	.word 0xd4956000  ! 557: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r10
	.word 0x87802025  ! 558: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r18
	.word 0xd0a48400  ! 560: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0xdc87a000  ! 561: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xd6d70e40  ! 562: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r11
	.word 0xdcd544a0  ! 563: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r14
	mov	0x60, %r27
	.word 0xd6b76000  ! 565: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0xdaccc400  ! 567: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r13
	.word 0xd8f5c4a0  ! 568: STXA_R	stxa	%r12, [%r23 + %r0] 0x25
	.word 0xd0d40400  ! 569: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	mov	0x7e0, %r21
	.word 0x8780204f  ! 571: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c0, %r22
	.word 0xd2be49e0  ! 573: STDA_R	stda	%r9, [%r25 + %r0] 0x4f
	mov	0x8, %r19
	.word 0x87802072  ! 575: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcac6000  ! 576: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 577: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 578: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4df0e60  ! 579: LDXA_R	ldxa	[%r28, %r0] 0x73, %r10
	.word 0xd2c4c400  ! 580: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0x87802073  ! 581: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2846000  ! 582: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r9
	.word 0xd2cca000  ! 583: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	.word 0x87802073  ! 584: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 585: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2df2000  ! 586: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xdcbc8400  ! 587: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xd0acc400  ! 588: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd0f609e0  ! 589: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	.word 0xdabf2000  ! 590: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xda8fe000  ! 591: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xd8c544a0  ! 592: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r12
	.word 0x87802020  ! 593: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bf4e80  ! 594: STDA_R	stda	%r11, [%r29 + %r0] 0x74
	.word 0xd6c7a000  ! 595: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	.word 0xd8b70e60  ! 596: STHA_R	stha	%r12, [%r28 + %r0] 0x73
	.word 0xd29f6000  ! 597: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xd8bfce40  ! 598: STDA_R	stda	%r12, [%r31 + %r0] 0x72
	mov	0x7e0, %r20
	.word 0xd0af2000  ! 600: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xd0f7a000  ! 602: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0d7a000  ! 603: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0xd2b44400  ! 604: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	mov	0x3c0, %r22
	.word 0x87802074  ! 606: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r16
	.word 0xda9e49e0  ! 608: LDDA_R	ldda	[%r25, %r0] 0x4f, %r13
	.word 0x87802020  ! 609: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a6a000  ! 610: STWA_I	stwa	%r9, [%r26 + 0x0000] %asi
	mov	0x50, %r25
	.word 0xd8ac0400  ! 612: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xdaa74e40  ! 613: STWA_R	stwa	%r13, [%r29 + %r0] 0x72
	.word 0xd88e6000  ! 614: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r12
	.word 0xd8bee000  ! 615: STDA_I	stda	%r12, [%r27 + 0x0000] %asi
	.word 0xdcd74e40  ! 616: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r14
	.word 0x87802020  ! 617: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda978e40  ! 618: LDUHA_R	lduha	[%r30, %r0] 0x72, %r13
	mov	0x70, %r17
	.word 0x87802020  ! 620: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dc8400  ! 621: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0xd4a66000  ! 622: STWA_I	stwa	%r10, [%r25 + 0x0000] %asi
	.word 0x87802072  ! 623: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4bfe000  ! 624: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xdeac0400  ! 625: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xd8c72000  ! 626: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	mov	0x7e0, %r23
	mov	0x0, %r19
	mov	0x0, %r16
	.word 0xd4a74e40  ! 630: STWA_R	stwa	%r10, [%r29 + %r0] 0x72
	mov	0x60, %r27
	mov	0x3c0, %r23
	mov	0x7e0, %r21
	.word 0x87802025  ! 634: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r25
	mov	0x48, %r17
	.word 0xd0cd04a0  ! 637: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r8
	mov	0x7e0, %r21
	.word 0x87802073  ! 639: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f7ce80  ! 640: STXA_R	stxa	%r11, [%r31 + %r0] 0x74
	.word 0xd2adc4a0  ! 641: STBA_R	stba	%r9, [%r23 + %r0] 0x25
	.word 0xd6f4e000  ! 642: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	.word 0xd6f46000  ! 643: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 644: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6dc6000  ! 645: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r11
	.word 0xd69ce000  ! 646: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r11
	.word 0x87802020  ! 647: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b78e60  ! 648: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	mov	0x30, %r17
	.word 0xd0bd44a0  ! 650: STDA_R	stda	%r8, [%r21 + %r0] 0x25
	.word 0xd8f48400  ! 651: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xda9ce000  ! 652: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r13
	mov	0x20, %r17
	.word 0xda9c6000  ! 654: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xda9ce000  ! 655: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r13
	.word 0xda942000  ! 656: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	mov	0x3d8, %r23
	.word 0x87802020  ! 658: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad72000  ! 659: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0xd6b44400  ! 660: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xdef78e40  ! 661: STXA_R	stxa	%r15, [%r30 + %r0] 0x72
	.word 0xdabf0e60  ! 662: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	.word 0xd2a609e0  ! 663: STWA_R	stwa	%r9, [%r24 + %r0] 0x4f
	mov	0x78, %r25
	.word 0x87802020  ! 665: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6952000  ! 666: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r11
	.word 0xd6f5a000  ! 667: STXA_I	stxa	%r11, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 668: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccf4e40  ! 669: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r14
	.word 0xd4c66000  ! 670: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r10
	.word 0xd4874e40  ! 671: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r10
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0cee000  ! 673: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r8
	.word 0xd8b40400  ! 674: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0x87802072  ! 675: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f8, %r22
	.word 0xd2b46000  ! 677: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0xd8df4e40  ! 678: LDXA_R	ldxa	[%r29, %r0] 0x72, %r12
	.word 0xdea689e0  ! 679: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	.word 0x87802073  ! 680: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d8, %r20
	.word 0x87802074  ! 682: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r25
	mov	0x58, %r18
	mov	0x20, %r26
	.word 0xdef7a000  ! 686: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xd8878e60  ! 687: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r12
	.word 0xdebf2000  ! 688: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0xdc9c8400  ! 690: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0xdecfce80  ! 691: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r15
	.word 0x87802020  ! 692: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r27
	.word 0xd4c649e0  ! 694: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r10
	.word 0xd6bf6000  ! 695: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd6972000  ! 696: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	.word 0x87802020  ! 697: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6842000  ! 698: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r11
	.word 0x87802025  ! 699: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc8fce80  ! 700: LDUBA_R	lduba	[%r31, %r0] 0x74, %r14
	mov	0x3d8, %r21
	.word 0xd4b5e000  ! 702: STHA_I	stha	%r10, [%r23 + 0x0000] %asi
	mov	0x60, %r18
	.word 0xd2bcc400  ! 704: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	mov	0x70, %r26
	.word 0xd48f8e60  ! 706: LDUBA_R	lduba	[%r30, %r0] 0x73, %r10
	mov	0x10, %r19
	.word 0xd69fce60  ! 708: LDDA_R	ldda	[%r31, %r0] 0x73, %r11
	.word 0x87802020  ! 709: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r20
	.word 0x87802072  ! 711: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdad56000  ! 712: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r13
	.word 0xda8de000  ! 713: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r13
	.word 0xda85e000  ! 714: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	.word 0xdab5e000  ! 715: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0xda95e000  ! 716: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r13
	.word 0xdabf4e40  ! 717: STDA_R	stda	%r13, [%r29 + %r0] 0x72
	mov	0x68, %r18
	mov	0x3f8, %r20
	.word 0xd49d84a0  ! 720: LDDA_R	ldda	[%r22, %r0] 0x25, %r10
	mov	0x3f8, %r23
	.word 0xdaf6c9e0  ! 722: STXA_R	stxa	%r13, [%r27 + %r0] 0x4f
	mov	0x28, %r25
	.word 0x87802020  ! 724: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r24
	mov	0x30, %r16
	mov	0x28, %r19
	.word 0xd2bf0e40  ! 728: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	.word 0x87802025  ! 729: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4b7a000  ! 730: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xdea70e40  ! 731: STWA_R	stwa	%r15, [%r28 + %r0] 0x72
	.word 0xd0976000  ! 732: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0a72000  ! 733: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xd0a76000  ! 734: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	mov	0x68, %r16
	.word 0xd4df4e60  ! 736: LDXA_R	ldxa	[%r29, %r0] 0x73, %r10
	.word 0x87802020  ! 737: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r20
	mov	0x50, %r17
	.word 0xd4b70e60  ! 740: STHA_R	stha	%r10, [%r28 + %r0] 0x73
	.word 0xd8870e80  ! 741: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r12
	.word 0xd6d42000  ! 742: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r11
	.word 0xde9f4e60  ! 743: LDDA_R	ldda	[%r29, %r0] 0x73, %r15
	.word 0x87802074  ! 744: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 745: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r27
	.word 0x87802073  ! 747: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c8, %r22
	mov	0x0, %r24
	.word 0xd6f72000  ! 750: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 751: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 752: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a6a000  ! 753: STWA_I	stwa	%r11, [%r26 + 0x0000] %asi
	.word 0xd6ce2000  ! 754: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	.word 0xd6b62000  ! 755: STHA_I	stha	%r11, [%r24 + 0x0000] %asi
	mov	0x60, %r25
	.word 0x87802073  ! 757: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6a72000  ! 758: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd8bd84a0  ! 759: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	mov	0x50, %r26
	.word 0xdaaf6000  ! 761: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xd6878e80  ! 762: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r11
	.word 0x87802072  ! 763: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf4a000  ! 764: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	mov	0x7e0, %r22
	.word 0xd2bcc400  ! 766: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0x87802020  ! 767: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b76000  ! 768: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd0d72000  ! 769: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0c76000  ! 770: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0xd2bcc400  ! 771: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xdebf6000  ! 772: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 773: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdecce000  ! 774: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	.word 0xd8b7ce80  ! 775: STHA_R	stha	%r12, [%r31 + %r0] 0x74
	mov	0x40, %r24
	.word 0x8780204f  ! 777: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd49f6000  ! 778: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0xdcdfce60  ! 779: LDXA_R	ldxa	[%r31, %r0] 0x73, %r14
	.word 0xd2bfa000  ! 780: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 781: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2ade000  ! 782: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0xd0bc0400  ! 783: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0xd0b649e0  ! 784: STHA_R	stha	%r8, [%r25 + %r0] 0x4f
	.word 0xd0dd6000  ! 785: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r8
	.word 0x87802073  ! 786: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0ad6000  ! 787: STBA_I	stba	%r8, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 788: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 789: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d8, %r22
	.word 0xdeb584a0  ! 791: STHA_R	stha	%r15, [%r22 + %r0] 0x25
	.word 0x87802020  ! 792: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r17
	.word 0xd0d76000  ! 794: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xd8c70e80  ! 795: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r12
	.word 0xd2c609e0  ! 796: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r9
	.word 0xdad48400  ! 797: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0xd8dfe000  ! 798: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8f504a0  ! 799: STXA_R	stxa	%r12, [%r20 + %r0] 0x25
	.word 0xdeb44400  ! 800: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	mov	0x7e8, %r21
	.word 0xd89f0e40  ! 802: LDDA_R	ldda	[%r28, %r0] 0x72, %r12
	mov	0x7e8, %r21
	.word 0xdaafe000  ! 804: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xdaa72000  ! 805: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xdcf5c4a0  ! 806: STXA_R	stxa	%r14, [%r23 + %r0] 0x25
	.word 0xdcbfce40  ! 807: STDA_R	stda	%r14, [%r31 + %r0] 0x72
	.word 0xdcf72000  ! 808: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	mov	0x7f8, %r22
	mov	0x3c0, %r23
	.word 0xd8c609e0  ! 811: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r12
	.word 0x87802074  ! 812: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6cc4400  ! 813: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	.word 0xd8b62000  ! 814: STHA_I	stha	%r12, [%r24 + 0x0000] %asi
	.word 0xd8ae2000  ! 815: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	wr_tick_cmpr_2_5:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa8, %g2
	or	%g4, 0xcc, %g4
	or	%g6, 0x80, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x18, %r19
	.word 0xdac504a0  ! 818: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r13
	mov	0x3d0, %r20
	.word 0xd48d84a0  ! 820: LDUBA_R	lduba	[%r22, %r0] 0x25, %r10
	.word 0xd4a6a000  ! 821: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	.word 0xd4dee000  ! 822: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r10
	.word 0xdcf4c400  ! 823: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xded70e80  ! 824: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r15
	.word 0xdcaea000  ! 825: STBA_I	stba	%r14, [%r26 + 0x0000] %asi
	.word 0xdcdee000  ! 826: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r14
	.word 0xdcf66000  ! 827: STXA_I	stxa	%r14, [%r25 + 0x0000] %asi
	.word 0xd8c74e60  ! 828: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r12
	.word 0x87802074  ! 829: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc842000  ! 830: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	.word 0x87802073  ! 831: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 832: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6de89e0  ! 833: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r11
	.word 0xd694e000  ! 834: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r11
	ta	T_CHANGE_PRIV	! macro
	mov	0x7e0, %r21
	.word 0xd6f4e000  ! 837: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	.word 0xd2dd44a0  ! 838: LDXA_R	ldxa	[%r21, %r0] 0x25, %r9
	.word 0xd8948400  ! 839: LDUHA_R	lduha	[%r18, %r0] 0x20, %r12
	.word 0xd0aca000  ! 840: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	mov	0x48, %r19
	.word 0xd0dc6000  ! 842: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	mov	0x20, %r25
	mov	0x78, %r24
	.word 0xd6bc8400  ! 845: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xd2b74e40  ! 846: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	.word 0x87802025  ! 847: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4be89e0  ! 848: STDA_R	stda	%r10, [%r26 + %r0] 0x4f
	mov	0x48, %r24
	mov	0x60, %r27
	.word 0x87802072  ! 851: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6af2000  ! 852: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 853: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 854: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b7e000  ! 855: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd6cf6000  ! 856: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xdcf70e40  ! 857: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	.word 0x87802025  ! 858: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r17
	.word 0xd0b52000  ! 860: STHA_I	stha	%r8, [%r20 + 0x0000] %asi
	.word 0xd0f70e80  ! 861: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0xdaf5a000  ! 862: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xdef74e40  ! 863: STXA_R	stxa	%r15, [%r29 + %r0] 0x72
	.word 0xdebdc4a0  ! 864: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	.word 0xd2956000  ! 865: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r9
	mov	0x40, %r24
	mov	0x8, %r19
	.word 0xd4b40400  ! 868: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0x87802073  ! 869: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8b78e60  ! 870: STHA_R	stha	%r12, [%r30 + %r0] 0x73
	.word 0xdacfce60  ! 871: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r13
	mov	0x8, %r25
	mov	0x18, %r19
	.word 0xdef72000  ! 874: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 875: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 876: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 877: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef7e000  ! 878: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xd6f70e40  ! 879: STXA_R	stxa	%r11, [%r28 + %r0] 0x72
	.word 0xdef74e60  ! 880: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	.word 0xdca7a000  ! 881: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	mov	0x40, %r18
	mov	0x3f8, %r22
	mov	0x38, %r18
	.word 0xdc97a000  ! 885: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	.word 0x87802074  ! 886: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 887: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf46000  ! 888: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xd4acc400  ! 889: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xdea4e000  ! 890: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	wr_tick_cmpr_2_6:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xad, %g2
	or	%g4, 0xe2, %g4
	or	%g6, 0x9f, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdeaca000  ! 892: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xdea609e0  ! 893: STWA_R	stwa	%r15, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 894: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd495c4a0  ! 895: LDUHA_R	lduha	[%r23, %r0] 0x25, %r10
	.word 0xda8da000  ! 896: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r13
	wr_tick_cmpr_2_7:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xfa, %g2
	or	%g4, 0xf6, %g4
	or	%g6, 0xbd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x40, %r26
	mov	0x60, %r25
	.word 0xd2d7ce40  ! 900: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r9
	.word 0xd2cd84a0  ! 901: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r9
	.word 0xd8be09e0  ! 902: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 903: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 904: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r21
	.word 0xd8b74e80  ! 906: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	.word 0x87802073  ! 907: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f0, %r21
	mov	0x20, %r26
	.word 0x87802025  ! 910: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdac42000  ! 911: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0xda942000  ! 912: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0xdabce000  ! 913: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0xda94a000  ! 914: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	.word 0x87802072  ! 915: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda8f2000  ! 916: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0x87802074  ! 917: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd69c4400  ! 918: LDDA_R	ldda	[%r17, %r0] 0x20, %r11
	.word 0xdccca000  ! 919: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	mov	0x48, %r25
	mov	0x7e0, %r20
	.word 0x87802074  ! 922: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0ae89e0  ! 923: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	.word 0xd8840400  ! 924: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r12
	mov	0x3f8, %r22
	mov	0x38, %r24
	.word 0x87802020  ! 927: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r27
	.word 0xd8b42000  ! 929: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0xd8aca000  ! 931: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 932: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd894a000  ! 933: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r12
	mov	0x48, %r16
	mov	0x70, %r26
	.word 0xd88c6000  ! 936: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	.word 0xdabf0e40  ! 937: STDA_R	stda	%r13, [%r28 + %r0] 0x72
	.word 0xd8bce000  ! 938: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd8f42000  ! 939: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xd6cf4e40  ! 940: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r11
	mov	0x40, %r16
	.word 0xdebf8e80  ! 942: STDA_R	stda	%r15, [%r30 + %r0] 0x74
	.word 0xd08c2000  ! 943: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0xd084e000  ! 944: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	.word 0xd0b46000  ! 945: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0xd0b4e000  ! 946: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	mov	0x0, %r25
	.word 0x87802074  ! 948: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb6c9e0  ! 949: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	mov	0x3c8, %r21
	mov	0x70, %r16
	.word 0xdcdfe000  ! 952: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	mov	0x8, %r26
	.word 0xd2970e60  ! 954: LDUHA_R	lduha	[%r28, %r0] 0x73, %r9
	mov	0x68, %r16
	.word 0xd48d84a0  ! 956: LDUBA_R	lduba	[%r22, %r0] 0x25, %r10
	mov	0x8, %r17
	.word 0xde9fe000  ! 958: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0xdedfa000  ! 959: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xdedf6000  ! 960: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xde976000  ! 961: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	.word 0xdab609e0  ! 962: STHA_R	stha	%r13, [%r24 + %r0] 0x4f
	.word 0xd0b76000  ! 963: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	mov	0x8, %r24
	.word 0xd0f72000  ! 965: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xdcb70e80  ! 966: STHA_R	stha	%r14, [%r28 + %r0] 0x74
	.word 0xdcf649e0  ! 967: STXA_R	stxa	%r14, [%r25 + %r0] 0x4f
	.word 0x87802073  ! 968: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca5c4a0  ! 969: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	mov	0x0, %r24
	.word 0xd8f6c9e0  ! 971: STXA_R	stxa	%r12, [%r27 + %r0] 0x4f
	.word 0xd0df8e60  ! 972: LDXA_R	ldxa	[%r30, %r0] 0x73, %r8
	.word 0xde9fa000  ! 973: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	.word 0x87802073  ! 974: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 975: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r23
	.word 0xdcb5c4a0  ! 977: STHA_R	stha	%r14, [%r23 + %r0] 0x25
	.word 0xdcc66000  ! 978: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	.word 0x87802073  ! 979: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda9d44a0  ! 980: LDDA_R	ldda	[%r21, %r0] 0x25, %r13
	.word 0xd4dca000  ! 981: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	wr_tick_cmpr_2_8:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa1, %g2
	or	%g4, 0xc3, %g4
	or	%g6, 0xf9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0940400  ! 983: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	mov	0x48, %r25
	.word 0xd08f0e60  ! 985: LDUBA_R	lduba	[%r28, %r0] 0x73, %r8
	.word 0xd494e000  ! 986: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	.word 0xd4dca000  ! 987: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	mov	0x3f0, %r20
	.word 0xd4bc6000  ! 989: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 990: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f649e0  ! 991: STXA_R	stxa	%r12, [%r25 + %r0] 0x4f
	mov	0x3f0, %r20
	.word 0xd0dcc400  ! 993: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	mov	0x3c8, %r23
	.word 0x87802072  ! 995: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f0, %r21
	.word 0xd4ae89e0  ! 997: STBA_R	stba	%r10, [%r26 + %r0] 0x4f
	mov	0x0, %r16
	.word 0xd6cf0e40  ! 999: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r11
	.word 0xde8f0e40  ! 1000: LDUBA_R	lduba	[%r28, %r0] 0x72, %r15
	.word 0xd4bc2000  ! 1001: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0xd4946000  ! 1002: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r10
	mov	0x3e8, %r23
	.word 0xd0dd84a0  ! 1004: LDXA_R	ldxa	[%r22, %r0] 0x25, %r8
	.word 0x87802020  ! 1005: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd697a000  ! 1006: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0xdea78e40  ! 1007: STWA_R	stwa	%r15, [%r30 + %r0] 0x72
	.word 0xd8d504a0  ! 1008: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r12
	mov	0x20, %r17
	.word 0xd8974e40  ! 1010: LDUHA_R	lduha	[%r29, %r0] 0x72, %r12
	mov	0x7d0, %r22
	.word 0x87802020  ! 1012: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1013: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f5c4a0  ! 1014: STXA_R	stxa	%r11, [%r23 + %r0] 0x25
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2ae89e0  ! 1016: STBA_R	stba	%r9, [%r26 + %r0] 0x4f
	.word 0xd8d5e000  ! 1017: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r12
	.word 0xd8a52000  ! 1018: STWA_I	stwa	%r12, [%r20 + 0x0000] %asi
	.word 0xd8f56000  ! 1019: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	mov	0x7f8, %r21
	mov	0x48, %r16
	.word 0xdca4c400  ! 1022: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0x87802074  ! 1023: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcd7e000  ! 1024: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xd2b74e40  ! 1025: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	.word 0x87802072  ! 1026: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabce000  ! 1027: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	mov	0x60, %r25
	mov	0x38, %r19
	.word 0x87802074  ! 1030: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r24
	.word 0xdaa74e60  ! 1032: STWA_R	stwa	%r13, [%r29 + %r0] 0x73
	.word 0xd2a4c400  ! 1033: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0xdc95a000  ! 1034: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r14
	.word 0xda8c8400  ! 1035: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	.word 0x87802025  ! 1036: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda948400  ! 1037: LDUHA_R	lduha	[%r18, %r0] 0x20, %r13
	.word 0xdcc40400  ! 1038: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	mov	0x78, %r18
	.word 0xd8a7a000  ! 1040: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd2dc4400  ! 1041: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xd6872000  ! 1042: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6a7a000  ! 1043: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	mov	0x48, %r26
	.word 0xd8cc0400  ! 1045: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	.word 0xd4972000  ! 1046: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	mov	0x7e0, %r20
	.word 0xd48fe000  ! 1048: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	mov	0x68, %r18
	mov	0x3d0, %r21
	mov	0x28, %r24
	.word 0xd4a7ce60  ! 1052: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	mov	0x0, %r19
	.word 0xd0972000  ! 1054: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xded6c9e0  ! 1055: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r15
	.word 0xd6df0e80  ! 1056: LDXA_R	ldxa	[%r28, %r0] 0x74, %r11
	.word 0xd487ce40  ! 1057: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r10
	.word 0xd0dd84a0  ! 1058: LDXA_R	ldxa	[%r22, %r0] 0x25, %r8
	.word 0xdc8649e0  ! 1059: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r14
	.word 0xd487a000  ! 1060: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	.word 0xd08584a0  ! 1061: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r8
	.word 0xd4c7a000  ! 1062: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4af6000  ! 1063: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xda870e60  ! 1064: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r13
	.word 0xd6af8e60  ! 1065: STBA_R	stba	%r11, [%r30 + %r0] 0x73
	.word 0x87802074  ! 1066: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r25
	.word 0xdebe6000  ! 1068: STDA_I	stda	%r15, [%r25 + 0x0000] %asi
	.word 0x87802074  ! 1069: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 1070: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea7e000  ! 1071: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	mov	0x70, %r26
	.word 0xd48f0e40  ! 1073: LDUBA_R	lduba	[%r28, %r0] 0x72, %r10
	.word 0xd497ce60  ! 1074: LDUHA_R	lduha	[%r31, %r0] 0x73, %r10
	.word 0xd4bf6000  ! 1075: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd4bfa000  ! 1076: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 1077: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b40400  ! 1078: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	mov	0x8, %r17
	mov	0x68, %r17
	.word 0xdcac8400  ! 1081: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xde8c6000  ! 1082: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0x87802025  ! 1083: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r25
	.word 0xdedfe000  ! 1085: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xdedf6000  ! 1086: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xdec72000  ! 1087: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0x87802020  ! 1088: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1089: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1090: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 1091: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa48400  ! 1092: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0xdc872000  ! 1093: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	mov	0x78, %r19
	.word 0xde970e60  ! 1095: LDUHA_R	lduha	[%r28, %r0] 0x73, %r15
	.word 0xd0afa000  ! 1096: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd0bfa000  ! 1097: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 1098: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a46000  ! 1099: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xd2c4c400  ! 1100: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0xd6dc2000  ! 1101: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r11
	.word 0x87802072  ! 1102: WRASI_I	wr	%r0, 0x0072, %asi
	wr_tick_cmpr_2_9:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf4, %g2
	or	%g4, 0xb2, %g4
	or	%g6, 0xba, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd6f44400  ! 1104: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0xd0c48400  ! 1105: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r8
	.word 0xd29dc4a0  ! 1106: LDDA_R	ldda	[%r23, %r0] 0x25, %r9
	.word 0x87802072  ! 1107: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd88f2000  ! 1108: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	mov	0x50, %r24
	mov	0x20, %r26
	.word 0x87802073  ! 1111: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde8f0e80  ! 1112: LDUBA_R	lduba	[%r28, %r0] 0x74, %r15
	mov	0x7d0, %r21
	.word 0xd2f78e60  ! 1114: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0xd69c0400  ! 1115: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	.word 0xdcf649e0  ! 1116: STXA_R	stxa	%r14, [%r25 + %r0] 0x4f
	.word 0xdad46000  ! 1117: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	.word 0xda942000  ! 1118: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0xd8bfce80  ! 1119: STDA_R	stda	%r12, [%r31 + %r0] 0x74
	.word 0xd6a42000  ! 1120: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xd6b46000  ! 1121: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd4cf4e80  ! 1122: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r10
	mov	0x3f0, %r23
	.word 0xd0b4a000  ! 1124: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	mov	0x7e0, %r21
	mov	0x50, %r24
	mov	0x10, %r25
	mov	0x7c8, %r21
	.word 0x87802020  ! 1129: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cee000  ! 1130: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r8
	mov	0x58, %r24
	.word 0xde878e80  ! 1132: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r15
	.word 0xd8af4e60  ! 1133: STBA_R	stba	%r12, [%r29 + %r0] 0x73
	mov	0x3f0, %r23
	mov	0x50, %r19
	.word 0xd4df4e80  ! 1136: LDXA_R	ldxa	[%r29, %r0] 0x74, %r10
	.word 0xdcc62000  ! 1137: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r14
	mov	0x48, %r16
	.word 0xd68fce60  ! 1139: LDUBA_R	lduba	[%r31, %r0] 0x73, %r11
	.word 0x87802025  ! 1140: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b7a000  ! 1141: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1142: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6aea000  ! 1143: STBA_I	stba	%r11, [%r26 + 0x0000] %asi
	mov	0x18, %r24
	wr_tick_cmpr_2_10:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe1, %g2
	or	%g4, 0xda, %g4
	or	%g6, 0xff, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xde940400  ! 1146: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0xd6a6a000  ! 1147: STWA_I	stwa	%r11, [%r26 + 0x0000] %asi
	.word 0xd6ae09e0  ! 1148: STBA_R	stba	%r11, [%r24 + %r0] 0x4f
	mov	0x68, %r19
	.word 0xd6b4c400  ! 1150: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xd2ae6000  ! 1151: STBA_I	stba	%r9, [%r25 + 0x0000] %asi
	wr_tick_cmpr_2_11:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd7, %g2
	or	%g4, 0xee, %g4
	or	%g6, 0xb2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd286e000  ! 1153: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1154: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dc2000  ! 1155: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r9
	.word 0xd2b609e0  ! 1156: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	.word 0x87802072  ! 1157: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r26
	.word 0xd88c6000  ! 1159: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	.word 0xdeb44400  ! 1160: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	mov	0x48, %r24
	.word 0xd4a70e40  ! 1162: STWA_R	stwa	%r10, [%r28 + %r0] 0x72
	mov	0x50, %r26
	.word 0xd4acc400  ! 1164: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xdaa544a0  ! 1165: STWA_R	stwa	%r13, [%r21 + %r0] 0x25
	.word 0xd49c6000  ! 1166: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0x87802025  ! 1167: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b689e0  ! 1168: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	.word 0xded6c9e0  ! 1169: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r15
	.word 0xd69e6000  ! 1170: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r11
	.word 0x87802073  ! 1171: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bc6000  ! 1172: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0xdabc8400  ! 1173: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	.word 0xd0d40400  ! 1174: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	.word 0x87802020  ! 1175: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r22
	.word 0xd29f4e40  ! 1177: LDDA_R	ldda	[%r29, %r0] 0x72, %r9
	.word 0xd2f7ce80  ! 1178: STXA_R	stxa	%r9, [%r31 + %r0] 0x74
	.word 0xd0af6000  ! 1179: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd087e000  ! 1180: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	mov	0x3d8, %r21
	.word 0xd09f6000  ! 1182: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	.word 0xdec78e80  ! 1183: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r15
	mov	0x8, %r17
	.word 0x87802072  ! 1185: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd89d84a0  ! 1186: LDDA_R	ldda	[%r22, %r0] 0x25, %r12
	mov	0x3f0, %r23
	.word 0xda866000  ! 1188: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r13
	.word 0xdac62000  ! 1189: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r13
	.word 0xd2f78e60  ! 1190: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0x8780204f  ! 1191: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f5e000  ! 1192: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 1193: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r24
	.word 0xd4f76000  ! 1195: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 1196: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4afa000  ! 1197: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd0f78e80  ! 1198: STXA_R	stxa	%r8, [%r30 + %r0] 0x74
	.word 0xd097a000  ! 1199: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	.word 0x87802072  ! 1200: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 1201: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd48e09e0  ! 1202: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r10
	.word 0x87802020  ! 1203: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bc6000  ! 1204: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xd4f46000  ! 1205: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0xd4f4e000  ! 1206: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0xdea70e60  ! 1207: STWA_R	stwa	%r15, [%r28 + %r0] 0x73
	mov	0x40, %r19
	.word 0xd0dce000  ! 1209: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r8
	.word 0xd0bc6000  ! 1210: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	mov	0x7f8, %r20
	.word 0xdead84a0  ! 1212: STBA_R	stba	%r15, [%r22 + %r0] 0x25
	mov	0x7c0, %r23
	mov	0x78, %r25
	.word 0xdcad04a0  ! 1215: STBA_R	stba	%r14, [%r20 + %r0] 0x25
	.word 0xd2f504a0  ! 1216: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	.word 0xd6f6c9e0  ! 1217: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 1218: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1219: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6dc2000  ! 1220: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r11
	mov	0x40, %r24
	.word 0x87802074  ! 1222: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r16
	.word 0xd6f46000  ! 1224: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0xd694e000  ! 1225: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r11
	.word 0x87802025  ! 1226: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdea44400  ! 1227: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xde9fa000  ! 1228: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x38, %r27
	.word 0x8780204f  ! 1231: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r16
	mov	0x50, %r17
	.word 0xdc8cc400  ! 1234: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	.word 0x87802020  ! 1235: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r24
	.word 0xd8ad2000  ! 1237: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	.word 0xd08fce80  ! 1238: LDUBA_R	lduba	[%r31, %r0] 0x74, %r8
	.word 0xd4bd84a0  ! 1239: STDA_R	stda	%r10, [%r22 + %r0] 0x25
	mov	0x50, %r27
	.word 0xdcf5a000  ! 1241: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	.word 0x87802025  ! 1242: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8844400  ! 1243: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r12
	.word 0xdcd76000  ! 1244: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	.word 0xdcf7a000  ! 1245: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xd8ac0400  ! 1246: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	mov	0x10, %r24
	.word 0xdcdf2000  ! 1248: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcf74e80  ! 1249: STXA_R	stxa	%r14, [%r29 + %r0] 0x74
	.word 0xd6dec9e0  ! 1250: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r11
	mov	0x3c0, %r22
	.word 0xdef48400  ! 1252: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xd6bf2000  ! 1253: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 1254: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c8, %r23
	.word 0x87802074  ! 1256: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd487ce40  ! 1257: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r10
	.word 0xd0946000  ! 1258: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0xd0846000  ! 1259: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0xd2b689e0  ! 1260: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	.word 0xd8f4a000  ! 1261: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8d4a000  ! 1262: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xd89c2000  ! 1263: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	.word 0xdedf4e80  ! 1264: LDXA_R	ldxa	[%r29, %r0] 0x74, %r15
	.word 0x87802073  ! 1265: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r26
	.word 0xd0f52000  ! 1267: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	mov	0x48, %r16
	.word 0xd0852000  ! 1269: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r8
	.word 0xd08c4400  ! 1270: LDUBA_R	lduba	[%r17, %r0] 0x20, %r8
	.word 0xd4bde000  ! 1271: STDA_I	stda	%r10, [%r23 + 0x0000] %asi
	.word 0xd4bd6000  ! 1272: STDA_I	stda	%r10, [%r21 + 0x0000] %asi
	.word 0xd4f44400  ! 1273: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0xd0d56000  ! 1274: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1275: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd097e000  ! 1276: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0afa000  ! 1277: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xdabd44a0  ! 1278: STDA_R	stda	%r13, [%r21 + %r0] 0x25
	.word 0xd4a7ce80  ! 1279: STWA_R	stwa	%r10, [%r31 + %r0] 0x74
	.word 0xdaaf6000  ! 1280: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xd6840400  ! 1281: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	mov	0x7d8, %r22
	mov	0x7e8, %r21
	mov	0x0, %r16
	.word 0xdebfe000  ! 1285: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xd0cc0400  ! 1286: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0x8780204f  ! 1287: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d0, %r23
	.word 0xdcc44400  ! 1289: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xdab70e40  ! 1290: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	.word 0xda878e80  ! 1291: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r13
	.word 0x87802020  ! 1292: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1293: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1294: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9d2000  ! 1295: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r14
	.word 0x87802074  ! 1296: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc8ca000  ! 1297: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r14
	mov	0x20, %r17
	.word 0x8780204f  ! 1299: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r19
	mov	0x18, %r19
	.word 0xd08c4400  ! 1302: LDUBA_R	lduba	[%r17, %r0] 0x20, %r8
	.word 0xda8fa000  ! 1303: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	mov	0x7c0, %r22
	.word 0x87802072  ! 1305: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 1306: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdacf2000  ! 1307: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0x87802074  ! 1308: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1309: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9e2000  ! 1310: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r13
	.word 0xdccf0e60  ! 1311: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r14
	mov	0x3f8, %r23
	mov	0x7e0, %r21
	.word 0xd6f6a000  ! 1314: STXA_I	stxa	%r11, [%r26 + 0x0000] %asi
	mov	0x8, %r17
	.word 0xdeaf4e40  ! 1316: STBA_R	stba	%r15, [%r29 + %r0] 0x72
	.word 0xd8f689e0  ! 1317: STXA_R	stxa	%r12, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 1318: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r16
	mov	0x40, %r17
	.word 0xd4f689e0  ! 1321: STXA_R	stxa	%r10, [%r26 + %r0] 0x4f
	mov	0x28, %r25
	.word 0xdea42000  ! 1323: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xd0a649e0  ! 1324: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	.word 0xd28dc4a0  ! 1325: LDUBA_R	lduba	[%r23, %r0] 0x25, %r9
	mov	0x3c0, %r23
	mov	0x3c8, %r22
	.word 0xd6b42000  ! 1328: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0xd69ce000  ! 1329: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 1330: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc9c0400  ! 1331: LDDA_R	ldda	[%r16, %r0] 0x20, %r14
	.word 0xd28f4e40  ! 1332: LDUBA_R	lduba	[%r29, %r0] 0x72, %r9
	mov	0x40, %r19
	.word 0xd0cf0e40  ! 1334: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r8
	.word 0xd4b609e0  ! 1335: STHA_R	stha	%r10, [%r24 + %r0] 0x4f
	.word 0xdadf6000  ! 1336: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xdedc0400  ! 1337: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	.word 0xd2f504a0  ! 1338: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	.word 0xde9f4e60  ! 1339: LDDA_R	ldda	[%r29, %r0] 0x73, %r15
	.word 0xdacf2000  ! 1340: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xd2b649e0  ! 1341: STHA_R	stha	%r9, [%r25 + %r0] 0x4f
	mov	0x3f8, %r23
	.word 0xdeb7e000  ! 1343: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	mov	0x28, %r24
	.word 0xd4b6c9e0  ! 1345: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0xdcb74e80  ! 1346: STHA_R	stha	%r14, [%r29 + %r0] 0x74
	mov	0x3c8, %r21
	mov	0x7d8, %r21
	mov	0x60, %r24
	mov	0x7e0, %r22
	.word 0xd0d7e000  ! 1351: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0af6000  ! 1352: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	mov	0x18, %r26
	mov	0x3d8, %r21
	.word 0xd2a7ce80  ! 1355: STWA_R	stwa	%r9, [%r31 + %r0] 0x74
	.word 0xd6b44400  ! 1356: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xdebfe000  ! 1357: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xd8de49e0  ! 1358: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r12
	.word 0x87802020  ! 1359: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68609e0  ! 1360: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r11
	.word 0x87802020  ! 1361: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1362: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6d40400  ! 1363: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	.word 0x87802025  ! 1364: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 1365: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r27
	mov	0x78, %r24
	.word 0x87802072  ! 1368: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4aca000  ! 1369: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0xd4c46000  ! 1370: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r10
	.word 0xd4bce000  ! 1371: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	mov	0x28, %r19
	.word 0x87802020  ! 1373: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r19
	.word 0xd6f4c400  ! 1375: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0xd6af6000  ! 1376: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd6afa000  ! 1377: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x18, %r25
	.word 0xd6d76000  ! 1379: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	mov	0x3d0, %r23
	.word 0xd6a76000  ! 1381: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6b72000  ! 1382: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd8a544a0  ! 1383: STWA_R	stwa	%r12, [%r21 + %r0] 0x25
	.word 0xd0a72000  ! 1384: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xd0b72000  ! 1385: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd89c0400  ! 1386: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	.word 0xd8f7ce40  ! 1387: STXA_R	stxa	%r12, [%r31 + %r0] 0x72
	mov	0x78, %r17
	.word 0xdcc48400  ! 1389: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r14
	mov	0x58, %r17
	.word 0xdcb7ce60  ! 1391: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	ta	T_CHANGE_PRIV	! macro
	mov	0x78, %r19
	mov	0x58, %r27
	mov	0x18, %r27
	mov	0x10, %r26
	mov	0x20, %r17
	.word 0xdcf7ce60  ! 1398: STXA_R	stxa	%r14, [%r31 + %r0] 0x73
	mov	0x38, %r27
	mov	0x60, %r18
	.word 0xd8a7e000  ! 1401: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 1402: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r19
	.word 0xd2948400  ! 1404: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	.word 0x87802073  ! 1405: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r17
	.word 0xdabf8e80  ! 1407: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	.word 0xdede89e0  ! 1408: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r15
	mov	0x70, %r16
	.word 0xdab4c400  ! 1410: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xd6ad04a0  ! 1411: STBA_R	stba	%r11, [%r20 + %r0] 0x25
	.word 0xd6df2000  ! 1412: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd68fa000  ! 1413: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	mov	0x3c0, %r23
	mov	0x10, %r25
	.word 0xdea6c9e0  ! 1416: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	mov	0x28, %r27
	mov	0x18, %r27
	.word 0x87802020  ! 1419: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1420: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69f6000  ! 1421: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	mov	0x3c8, %r22
	.word 0xd6dfe000  ! 1423: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 1424: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r16
	.word 0xd6a4e000  ! 1426: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0xd6d4a000  ! 1427: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r11
	.word 0xd2b78e40  ! 1428: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	.word 0xd8bc6000  ! 1429: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xdeb70e60  ! 1431: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	.word 0xded4e000  ! 1432: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	.word 0x87802025  ! 1433: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbe89e0  ! 1434: STDA_R	stda	%r14, [%r26 + %r0] 0x4f
	mov	0x78, %r26
	mov	0x50, %r26
	.word 0xd09f2000  ! 1437: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0xd08fa000  ! 1438: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	ta	T_CHANGE_PRIV	! macro
	.word 0xd6a689e0  ! 1440: STWA_R	stwa	%r11, [%r26 + %r0] 0x4f
	.word 0xd4cc4400  ! 1441: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r10
	.word 0xd2b584a0  ! 1442: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0x87802074  ! 1443: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 1444: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8f7a000  ! 1445: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd4a544a0  ! 1446: STWA_R	stwa	%r10, [%r21 + %r0] 0x25
	.word 0xd4cf2000  ! 1447: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	mov	0x7d8, %r21
	.word 0xd4b72000  ! 1449: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xdcac0400  ! 1450: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xdccfce80  ! 1451: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r14
	.word 0xd0dfe000  ! 1452: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0c76000  ! 1453: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1454: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6af4e60  ! 1455: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	.word 0x87802074  ! 1456: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8a62000  ! 1457: STWA_I	stwa	%r12, [%r24 + 0x0000] %asi
	.word 0xd08649e0  ! 1458: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r8
	mov	0x50, %r25
	mov	0x70, %r17
	mov	0x7e8, %r22
	.word 0xdace6000  ! 1462: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r13
	.word 0xd087ce80  ! 1463: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r8
	.word 0xd0bf0e40  ! 1464: STDA_R	stda	%r8, [%r28 + %r0] 0x72
	.word 0xdcb66000  ! 1465: STHA_I	stha	%r14, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 1466: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a40400  ! 1467: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xd8cc4400  ! 1468: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r12
	mov	0x0, %r25
	mov	0x40, %r25
	.word 0xd0a52000  ! 1471: STWA_I	stwa	%r8, [%r20 + 0x0000] %asi
	.word 0x87802072  ! 1472: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b5c4a0  ! 1473: STHA_R	stha	%r8, [%r23 + %r0] 0x25
	mov	0x0, %r24
	.word 0xd6ac6000  ! 1475: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xd4a40400  ! 1476: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	.word 0xd89ce000  ! 1477: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	.word 0xdcac0400  ! 1478: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0x87802020  ! 1479: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1480: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca78e60  ! 1481: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	.word 0x87802074  ! 1482: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde8c2000  ! 1483: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	.word 0xde846000  ! 1484: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0xda9ec9e0  ! 1485: LDDA_R	ldda	[%r27, %r0] 0x4f, %r13
	.word 0xd6bf8e80  ! 1486: STDA_R	stda	%r11, [%r30 + %r0] 0x74
	.word 0xdab46000  ! 1487: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0xdac4e000  ! 1488: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r13
	.word 0xd0d7ce80  ! 1489: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r8
	.word 0x87802074  ! 1490: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2d7e000  ! 1491: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xd2972000  ! 1492: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	mov	0x7e0, %r23
	mov	0x3d0, %r20
	.word 0xd2cf6000  ! 1495: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	mov	0x7d0, %r21
	.word 0x87802074  ! 1497: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c8, %r22
	.word 0xd2de2000  ! 1499: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r9
	.word 0xd2bea000  ! 1500: STDA_I	stda	%r9, [%r26 + 0x0000] %asi
	.word 0xd8ac0400  ! 1501: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xdac40400  ! 1502: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	.word 0xdca74e80  ! 1503: STWA_R	stwa	%r14, [%r29 + %r0] 0x74
	.word 0xd2b6e000  ! 1504: STHA_I	stha	%r9, [%r27 + 0x0000] %asi
	mov	0x68, %r27
	.word 0xd2f66000  ! 1506: STXA_I	stxa	%r9, [%r25 + 0x0000] %asi
	.word 0xd0874e60  ! 1507: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r8
	.word 0xd6cee000  ! 1508: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r11
	.word 0xd6b4c400  ! 1509: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xd0bf0e80  ! 1510: STDA_R	stda	%r8, [%r28 + %r0] 0x74
	wr_tick_cmpr_2_12:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x8c, %g2
	or	%g4, 0x91, %g4
	or	%g6, 0x8d, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdeae2000  ! 1512: STBA_I	stba	%r15, [%r24 + 0x0000] %asi
	mov	0x50, %r25
	.word 0xd2bd04a0  ! 1514: STDA_R	stda	%r9, [%r20 + %r0] 0x25
	.word 0xd4dea000  ! 1515: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	.word 0xdcf44400  ! 1516: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xd4dcc400  ! 1517: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0xdcde2000  ! 1518: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r14
	mov	0x68, %r18
	.word 0x87802020  ! 1520: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r20
	mov	0x70, %r16
	mov	0x10, %r25
	.word 0x87802020  ! 1524: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1525: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4c48400  ! 1526: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r10
	.word 0xd8a7a000  ! 1527: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd88fe000  ! 1528: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1529: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f42000  ! 1530: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 1531: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2cc4400  ! 1532: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r9
	.word 0xd8afe000  ! 1533: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xda878e40  ! 1534: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r13
	.word 0xd8d7e000  ! 1535: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	mov	0x7f0, %r21
	mov	0x7d0, %r23
	.word 0xd8cf6000  ! 1538: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0xdccc8400  ! 1539: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	.word 0xdedf2000  ! 1540: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xdea7e000  ! 1541: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	mov	0x20, %r24
	.word 0x87802020  ! 1543: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebce000  ! 1544: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xdeacc400  ! 1545: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xd8a649e0  ! 1546: STWA_R	stwa	%r12, [%r25 + %r0] 0x4f
	mov	0x7c8, %r21
	.word 0xd08c6000  ! 1548: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0xd0f4e000  ! 1549: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 1550: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 1551: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r18
	.word 0xd4b40400  ! 1553: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0xd49ca000  ! 1554: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd29f8e80  ! 1555: LDDA_R	ldda	[%r30, %r0] 0x74, %r9
	.word 0xdadc4400  ! 1556: LDXA_R	ldxa	[%r17, %r0] 0x20, %r13
	.word 0x87802020  ! 1557: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r21
	.word 0xd6ce89e0  ! 1559: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r11
	.word 0x87802073  ! 1560: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda9ce000  ! 1561: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r13
	.word 0x87802073  ! 1562: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdadca000  ! 1563: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0xdc878e80  ! 1564: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r14
	.word 0xd8f74e80  ! 1565: STXA_R	stxa	%r12, [%r29 + %r0] 0x74
	.word 0xdea74e80  ! 1566: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	.word 0x87802073  ! 1567: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4d62000  ! 1568: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r10
	.word 0xd6ac8400  ! 1569: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0x87802072  ! 1570: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r24
	.word 0xd6b544a0  ! 1572: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	.word 0xdca7ce40  ! 1573: STWA_R	stwa	%r14, [%r31 + %r0] 0x72
	.word 0xdcc56000  ! 1574: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r14
	.word 0xd8d6c9e0  ! 1575: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r12
	.word 0x87802025  ! 1576: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 1577: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcacc400  ! 1578: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	mov	0x8, %r19
	.word 0x8780204f  ! 1580: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6bf0e80  ! 1581: STDA_R	stda	%r11, [%r28 + %r0] 0x74
	.word 0xd0f4e000  ! 1582: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0ace000  ! 1583: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 1584: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0cf6000  ! 1585: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0bf6000  ! 1587: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd48d84a0  ! 1588: LDUBA_R	lduba	[%r22, %r0] 0x25, %r10
	.word 0xd2af2000  ! 1589: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd2dfe000  ! 1590: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2c7a000  ! 1591: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2c72000  ! 1592: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 1593: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 1594: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2afe000  ! 1595: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd2b72000  ! 1596: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1597: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b48400  ! 1598: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xdef6a000  ! 1599: STXA_I	stxa	%r15, [%r26 + 0x0000] %asi
	wr_tick_cmpr_2_13:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xca, %g2
	or	%g4, 0xa0, %g4
	or	%g6, 0x97, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xde9e2000  ! 1601: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r15
	.word 0xde9ee000  ! 1602: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r15
	.word 0xdeb6e000  ! 1603: STHA_I	stha	%r15, [%r27 + 0x0000] %asi
	.word 0xded6a000  ! 1604: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r15
	mov	0x30, %r18
	mov	0x58, %r24
	.word 0xd4f40400  ! 1607: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	mov	0x58, %r27
	.word 0xd28d84a0  ! 1609: LDUBA_R	lduba	[%r22, %r0] 0x25, %r9
	.word 0xd8b44400  ! 1610: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	mov	0x20, %r25
	wr_tick_cmpr_2_14:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xed, %g2
	or	%g4, 0x85, %g4
	or	%g6, 0xf3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7f8, %r23
	.word 0xd4cee000  ! 1614: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 1615: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 1616: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4d7e000  ! 1617: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 1618: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r16
	.word 0xd48f2000  ! 1620: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4bf6000  ! 1621: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd6a689e0  ! 1622: STWA_R	stwa	%r11, [%r26 + %r0] 0x4f
	.word 0xd4d40400  ! 1623: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	.word 0xd0dc4400  ! 1624: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	.word 0x87802020  ! 1625: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r24
	mov	0x10, %r24
	.word 0xd0dde000  ! 1628: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r8
	.word 0xdab70e60  ! 1629: STHA_R	stha	%r13, [%r28 + %r0] 0x73
	.word 0x87802025  ! 1630: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda848400  ! 1631: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r13
	.word 0xda878e40  ! 1632: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r13
	.word 0xd2b70e40  ! 1633: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	.word 0x87802025  ! 1634: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f544a0  ! 1635: STXA_R	stxa	%r8, [%r21 + %r0] 0x25
	mov	0x48, %r24
	.word 0x87802020  ! 1637: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabe6000  ! 1638: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	.word 0xdcc70e40  ! 1639: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r14
	.word 0xdc86e000  ! 1640: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r14
	.word 0xdcc6e000  ! 1641: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r14
	.word 0x87802020  ! 1642: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d649e0  ! 1643: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r12
	.word 0xd4b649e0  ! 1644: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	mov	0x48, %r25
	mov	0x0, %r26
	.word 0x87802020  ! 1647: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b40400  ! 1648: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	wr_tick_cmpr_2_15:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe8, %g2
	or	%g4, 0xbb, %g4
	or	%g6, 0xe0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd6c6e000  ! 1650: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r11
	.word 0xd6f6c9e0  ! 1651: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	.word 0xd6a62000  ! 1652: STWA_I	stwa	%r11, [%r24 + 0x0000] %asi
	.word 0x87802073  ! 1653: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 1654: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r17
	.word 0xdccdc4a0  ! 1656: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r14
	mov	0x3c8, %r21
	.word 0x87802025  ! 1658: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0ac6000  ! 1659: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0xd4df4e60  ! 1660: LDXA_R	ldxa	[%r29, %r0] 0x73, %r10
	.word 0xd4acc400  ! 1661: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	mov	0x3f0, %r20
	.word 0xdeb42000  ! 1663: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	mov	0x28, %r16
	.word 0xd6b649e0  ! 1665: STHA_R	stha	%r11, [%r25 + %r0] 0x4f
	mov	0x70, %r19
	.word 0xdcdfce60  ! 1667: LDXA_R	ldxa	[%r31, %r0] 0x73, %r14
	mov	0x3c0, %r21
	.word 0xd6c4e000  ! 1669: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r11
	.word 0xda8c4400  ! 1670: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	mov	0x40, %r27
	mov	0x10, %r26
	.word 0xd8bcc400  ! 1673: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0xd89c0400  ! 1674: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	.word 0x87802073  ! 1675: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbec9e0  ! 1676: STDA_R	stda	%r14, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 1677: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r27
	.word 0xdeddc4a0  ! 1679: LDXA_R	ldxa	[%r23, %r0] 0x25, %r15
	.word 0xd0ce6000  ! 1680: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r8
	.word 0xd4a70e80  ! 1681: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	mov	0x8, %r17
	mov	0x60, %r27
	.word 0xd2966000  ! 1684: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r9
	.word 0xd28e89e0  ! 1685: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r9
	.word 0xdeb44400  ! 1686: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 1687: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 1688: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2976000  ! 1689: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0xd2972000  ! 1690: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xd88c8400  ! 1691: LDUBA_R	lduba	[%r18, %r0] 0x20, %r12
	.word 0x87802074  ! 1692: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r17
	.word 0xd09689e0  ! 1694: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r8
	.word 0xd09e2000  ! 1695: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r8
	mov	0x10, %r16
	.word 0xd2adc4a0  ! 1697: STBA_R	stba	%r9, [%r23 + %r0] 0x25
	.word 0xde9504a0  ! 1698: LDUHA_R	lduha	[%r20, %r0] 0x25, %r15
	.word 0xd2cee000  ! 1699: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	.word 0x87802073  ! 1700: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2afe000  ! 1701: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd28f2000  ! 1702: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	.word 0xd2876000  ! 1703: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xdeac0400  ! 1704: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xd6af0e40  ! 1705: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	.word 0xd4bfe000  ! 1706: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xd4adc4a0  ! 1708: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0xd4c48400  ! 1709: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r10
	.word 0xd8c6c9e0  ! 1710: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r12
	.word 0x87802074  ! 1711: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4974e80  ! 1712: LDUHA_R	lduha	[%r29, %r0] 0x74, %r10
	.word 0xd6af2000  ! 1713: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd6af6000  ! 1714: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd4b48400  ! 1715: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	mov	0x7e8, %r20
	mov	0x30, %r24
	mov	0x70, %r16
	.word 0xd29f8e40  ! 1719: LDDA_R	ldda	[%r30, %r0] 0x72, %r9
	mov	0x48, %r18
	.word 0x87802020  ! 1721: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cf2000  ! 1722: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1723: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2a544a0  ! 1724: STWA_R	stwa	%r9, [%r21 + %r0] 0x25
	.word 0xdcbc2000  ! 1725: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xd4d78e80  ! 1727: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r10
	.word 0xdaad84a0  ! 1728: STBA_R	stba	%r13, [%r22 + %r0] 0x25
	.word 0xd0ae89e0  ! 1729: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	.word 0xdea46000  ! 1730: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xdea46000  ! 1731: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	mov	0x48, %r26
	.word 0xded4e000  ! 1733: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	mov	0x8, %r25
	.word 0xde9ca000  ! 1735: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	.word 0xdec46000  ! 1736: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	.word 0xdeb46000  ! 1737: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0xde84e000  ! 1738: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	.word 0xde9c6000  ! 1739: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0xd4cdc4a0  ! 1740: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r10
	.word 0xd2b46000  ! 1741: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 1742: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r18
	.word 0xd2b4e000  ! 1744: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0xd2d42000  ! 1745: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2f4e000  ! 1746: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd4b689e0  ! 1747: STHA_R	stha	%r10, [%r26 + %r0] 0x4f
	.word 0xd0ace000  ! 1748: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 1749: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1750: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1751: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x0, %r26
	mov	0x50, %r26
	.word 0xd29c8400  ! 1754: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	.word 0xdca7a000  ! 1755: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcbfe000  ! 1756: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdc87a000  ! 1757: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xdaac4400  ! 1758: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	.word 0xd687e000  ! 1759: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xd4948400  ! 1760: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	mov	0x28, %r16
	.word 0xda8fa000  ! 1762: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xdab72000  ! 1763: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdaafa000  ! 1764: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdacfe000  ! 1765: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1766: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1767: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r25
	.word 0xd8f48400  ! 1769: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xd2a72000  ! 1770: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0xd4de89e0  ! 1771: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r10
	.word 0xdcc7a000  ! 1772: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcb72000  ! 1773: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xdedf8e80  ! 1774: LDXA_R	ldxa	[%r30, %r0] 0x74, %r15
	mov	0x40, %r25
	.word 0x87802072  ! 1776: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 1777: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2ac6000  ! 1778: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 1779: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1780: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1781: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1782: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f62000  ! 1783: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	.word 0xd08c0400  ! 1784: LDUBA_R	lduba	[%r16, %r0] 0x20, %r8
	.word 0xd49f4e80  ! 1785: LDDA_R	ldda	[%r29, %r0] 0x74, %r10
	.word 0xd0dee000  ! 1786: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r8
	.word 0xd0bcc400  ! 1787: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0x87802020  ! 1788: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b40400  ! 1789: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	mov	0x7e0, %r23
	mov	0x10, %r18
	.word 0x8780204f  ! 1792: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabf4e80  ! 1793: STDA_R	stda	%r13, [%r29 + %r0] 0x74
	.word 0xdcbce000  ! 1794: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xd0dfce60  ! 1795: LDXA_R	ldxa	[%r31, %r0] 0x73, %r8
	.word 0xdec4a000  ! 1796: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xdef46000  ! 1797: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 1798: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf70e40  ! 1799: STXA_R	stxa	%r13, [%r28 + %r0] 0x72
	.word 0x87802074  ! 1800: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2972000  ! 1802: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xd2a76000  ! 1803: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd0c4c400  ! 1804: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	mov	0x28, %r19
	mov	0x70, %r26
	.word 0x87802073  ! 1807: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8b74e40  ! 1808: STHA_R	stha	%r12, [%r29 + %r0] 0x72
	.word 0xd4de2000  ! 1809: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r10
	mov	0x10, %r26
	.word 0x87802074  ! 1811: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 1812: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6a7ce40  ! 1813: STWA_R	stwa	%r11, [%r31 + %r0] 0x72
	.word 0xd0df6000  ! 1814: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0cf2000  ! 1815: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1816: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0cde000  ! 1817: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r8
	.word 0xd4a44400  ! 1818: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	mov	0x3f0, %r23
	.word 0xdea5a000  ! 1820: STWA_I	stwa	%r15, [%r22 + 0x0000] %asi
	.word 0xdead6000  ! 1821: STBA_I	stba	%r15, [%r21 + 0x0000] %asi
	.word 0xded5c4a0  ! 1822: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r15
	mov	0x38, %r24
	.word 0xdebf0e80  ! 1824: STDA_R	stda	%r15, [%r28 + %r0] 0x74
	.word 0xd0cf8e40  ! 1825: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r8
	.word 0xd0dc8400  ! 1826: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	mov	0x3f8, %r23
	mov	0x50, %r24
	.word 0x8780204f  ! 1829: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdef42000  ! 1830: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xd6f44400  ! 1831: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0xd4c4a000  ! 1832: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	.word 0xd4dca000  ! 1833: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	.word 0xd4c46000  ! 1834: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r10
	.word 0xd2a7ce40  ! 1835: STWA_R	stwa	%r9, [%r31 + %r0] 0x72
	.word 0xd8cca000  ! 1836: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r12
	.word 0xd69544a0  ! 1837: LDUHA_R	lduha	[%r21, %r0] 0x25, %r11
	.word 0xdeb4a000  ! 1838: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0xdec4a000  ! 1839: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xda878e40  ! 1840: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r13
	.word 0xd89544a0  ! 1841: LDUHA_R	lduha	[%r21, %r0] 0x25, %r12
	mov	0x7d8, %r22
	.word 0x87802025  ! 1843: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4ce89e0  ! 1844: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r10
	.word 0x8780204f  ! 1845: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a72000  ! 1846: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	mov	0x78, %r24
	.word 0x8780204f  ! 1848: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b5e000  ! 1849: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	.word 0xd8f5e000  ! 1850: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	.word 0xd2d689e0  ! 1851: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r9
	.word 0xd2a70e40  ! 1852: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	.word 0xd2b609e0  ! 1853: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	.word 0xd4ad6000  ! 1854: STBA_I	stba	%r10, [%r21 + 0x0000] %asi
	.word 0xd6970e60  ! 1855: LDUHA_R	lduha	[%r28, %r0] 0x73, %r11
	.word 0xd0dfce80  ! 1856: LDXA_R	ldxa	[%r31, %r0] 0x74, %r8
	.word 0xde856000  ! 1857: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r15
	.word 0x87802020  ! 1858: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1859: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 1860: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdedf6000  ! 1861: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	mov	0x7c0, %r23
	.word 0xded76000  ! 1863: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	mov	0x3d8, %r21
	.word 0xde9f6000  ! 1865: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 1866: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd087ce60  ! 1867: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r8
	.word 0xd6a70e40  ! 1868: STWA_R	stwa	%r11, [%r28 + %r0] 0x72
	.word 0xdaa6a000  ! 1869: STWA_I	stwa	%r13, [%r26 + 0x0000] %asi
	.word 0x87802025  ! 1870: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdacf6000  ! 1871: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xd2afce40  ! 1872: STBA_R	stba	%r9, [%r31 + %r0] 0x72
	.word 0xd4d72000  ! 1873: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	mov	0x48, %r17
	.word 0x8780204f  ! 1875: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a76000  ! 1876: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd48f2000  ! 1877: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd6af0e60  ! 1878: STBA_R	stba	%r11, [%r28 + %r0] 0x73
	.word 0x87802020  ! 1879: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1880: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r26
	.word 0xd487a000  ! 1882: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	mov	0x48, %r25
	.word 0xd0f40400  ! 1884: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	mov	0x40, %r25
	mov	0x48, %r26
	.word 0xd6cf2000  ! 1887: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0xd6bf6000  ! 1888: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xdaf689e0  ! 1889: STXA_R	stxa	%r13, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 1890: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4978e60  ! 1891: LDUHA_R	lduha	[%r30, %r0] 0x73, %r10
	.word 0xdedfce40  ! 1892: LDXA_R	ldxa	[%r31, %r0] 0x72, %r15
	mov	0x68, %r17
	mov	0x3f0, %r23
	mov	0x30, %r26
	.word 0x87802025  ! 1896: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c0, %r20
	mov	0x58, %r27
	.word 0xd8bf2000  ! 1899: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	mov	0x8, %r27
	mov	0x28, %r24
	.word 0xd0de49e0  ! 1902: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r8
	.word 0xd68fe000  ! 1903: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xd6af2000  ! 1904: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x48, %r27
	mov	0x60, %r25
	.word 0xdcb74e60  ! 1907: STHA_R	stha	%r14, [%r29 + %r0] 0x73
	.word 0xd6f7e000  ! 1908: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6a7a000  ! 1909: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xded70e40  ! 1910: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r15
	.word 0xd6cd04a0  ! 1911: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r11
	mov	0x28, %r16
	.word 0x87802072  ! 1913: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdac4c400  ! 1914: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r13
	.word 0xde874e60  ! 1915: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r15
	.word 0xdeac8400  ! 1916: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	mov	0x30, %r27
	.word 0xdea6a000  ! 1918: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	mov	0x7e0, %r21
	.word 0xdea6a000  ! 1920: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	.word 0xd0acc400  ! 1921: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xda9f0e60  ! 1922: LDDA_R	ldda	[%r28, %r0] 0x73, %r13
	.word 0xde948400  ! 1923: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	.word 0xd2dc4400  ! 1924: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xd0bea000  ! 1925: STDA_I	stda	%r8, [%r26 + 0x0000] %asi
	.word 0xd09e6000  ! 1926: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r8
	.word 0xd0ac8400  ! 1927: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xd08d04a0  ! 1928: LDUBA_R	lduba	[%r20, %r0] 0x25, %r8
	.word 0xdebe2000  ! 1929: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	.word 0xde9e6000  ! 1930: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r15
	mov	0x7d8, %r23
	.word 0xd8a78e80  ! 1932: STWA_R	stwa	%r12, [%r30 + %r0] 0x74
	.word 0xd2c44400  ! 1933: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	.word 0xd6c62000  ! 1934: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r11
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x48, %r19
	.word 0xdacf8e60  ! 1937: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r13
	.word 0xde8e6000  ! 1938: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r15
	.word 0xdef6e000  ! 1939: STXA_I	stxa	%r15, [%r27 + 0x0000] %asi
	.word 0x87802074  ! 1940: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r18
	.word 0xd4974e40  ! 1942: LDUHA_R	lduha	[%r29, %r0] 0x72, %r10
	.word 0x87802074  ! 1943: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f56000  ! 1944: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 1945: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6df0e60  ! 1946: LDXA_R	ldxa	[%r28, %r0] 0x73, %r11
	mov	0x7e8, %r20
	wr_tick_cmpr_2_16:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xcb, %g2
	or	%g4, 0xa0, %g4
	or	%g6, 0xe8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7d0, %r23
	.word 0xd4b74e80  ! 1950: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	.word 0xd4dc6000  ! 1951: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	.word 0xd4bc2000  ! 1952: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	mov	0x10, %r24
	.word 0xd2b74e80  ! 1954: STHA_R	stha	%r9, [%r29 + %r0] 0x74
	.word 0x87802073  ! 1955: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef4c400  ! 1956: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	mov	0x70, %r17
	.word 0xd8dd2000  ! 1958: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r12
	.word 0xd6cd84a0  ! 1959: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r11
	.word 0x87802020  ! 1960: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1961: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6af4e80  ! 1962: STBA_R	stba	%r11, [%r29 + %r0] 0x74
	.word 0xdaf4a000  ! 1963: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	mov	0x0, %r19
	.word 0x87802072  ! 1965: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r19
	.word 0xd6f40400  ! 1967: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	.word 0xdc978e60  ! 1968: LDUHA_R	lduha	[%r30, %r0] 0x73, %r14
	.word 0xd286a000  ! 1969: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r9
	mov	0x60, %r19
	mov	0x8, %r19
	.word 0xd2b6e000  ! 1972: STHA_I	stha	%r9, [%r27 + 0x0000] %asi
	.word 0xd2de6000  ! 1973: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r9
	mov	0x10, %r19
	.word 0x87802020  ! 1975: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r18
	.word 0xd2dce000  ! 1977: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r9
	.word 0x87802073  ! 1978: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0878e80  ! 1979: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r8
	mov	0x60, %r26
	.word 0xd2df6000  ! 1981: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0xde844400  ! 1982: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	.word 0x87802072  ! 1983: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2978e40  ! 1984: LDUHA_R	lduha	[%r30, %r0] 0x72, %r9
	.word 0x87802074  ! 1985: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdadf6000  ! 1986: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xd2bc8400  ! 1987: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	.word 0xd0dfce80  ! 1988: LDXA_R	ldxa	[%r31, %r0] 0x74, %r8
	mov	0x48, %r24
	.word 0xd2bc0400  ! 1990: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	mov	0x0, %r19
	.word 0xd6afa000  ! 1992: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6bcc400  ! 1993: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0x87802020  ! 1994: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1995: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8856000  ! 1996: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	.word 0xd8d52000  ! 1997: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r12
	.word 0x87802073  ! 1998: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r25
	.word 0xd6f44400  ! 2000: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0x87802025  ! 2001: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2d74e40  ! 2002: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r9
	.word 0x87802020  ! 2003: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b46000  ! 2004: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0xd29f0e60  ! 2005: LDDA_R	ldda	[%r28, %r0] 0x73, %r9
	mov	0x3d8, %r23
	mov	0x68, %r24
	.word 0xde94a000  ! 2008: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0xdcf74e80  ! 2009: STXA_R	stxa	%r14, [%r29 + %r0] 0x74
	.word 0xd49ca000  ! 2010: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 2011: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bd6000  ! 2012: STDA_I	stda	%r10, [%r21 + 0x0000] %asi
	.word 0xde940400  ! 2013: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0x87802073  ! 2014: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 2015: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 2016: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4974e60  ! 2017: LDUHA_R	lduha	[%r29, %r0] 0x73, %r10
	.word 0xde8c6000  ! 2018: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	mov	0x30, %r19
	.word 0xde9ce000  ! 2020: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	mov	0x70, %r27
	mov	0x58, %r19
	.word 0xde8f8e80  ! 2023: LDUBA_R	lduba	[%r30, %r0] 0x74, %r15
	mov	0x58, %r26
	.word 0xd8946000  ! 2025: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	mov	0x50, %r18
	.word 0x8780204f  ! 2027: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8cfa000  ! 2028: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd6af8e60  ! 2029: STBA_R	stba	%r11, [%r30 + %r0] 0x73
	.word 0x87802074  ! 2030: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcaf2000  ! 2031: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xd6a44400  ! 2032: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	mov	0x68, %r27
	.word 0xdaf7a000  ! 2034: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xd4f609e0  ! 2035: STXA_R	stxa	%r10, [%r24 + %r0] 0x4f
	.word 0x87802072  ! 2036: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d0, %r22
	.word 0x87802025  ! 2038: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8acc400  ! 2039: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0xdeb76000  ! 2040: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	mov	0x0, %r25
	.word 0xded72000  ! 2042: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xd6d584a0  ! 2043: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r11
	.word 0x87802073  ! 2044: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e0, %r20
	.word 0xdabf8e40  ! 2046: STDA_R	stda	%r13, [%r30 + %r0] 0x72
	mov	0x30, %r18
	mov	0x70, %r19
	.word 0xd29c6000  ! 2049: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	mov	0x20, %r17
	.word 0xd2ac2000  ! 2051: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	mov	0x10, %r27
	.word 0xd2f4e000  ! 2053: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 2054: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r17
	mov	0x7e8, %r21
	.word 0xd2d72000  ! 2057: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2058: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b42000  ! 2059: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 2060: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bfe000  ! 2061: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2062: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2946000  ! 2063: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r9
	.word 0xd2ac6000  ! 2064: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 2065: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0bc0400  ! 2066: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0xd6dcc400  ! 2067: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	.word 0xd4af4e40  ! 2068: STBA_R	stba	%r10, [%r29 + %r0] 0x72
	.word 0xd2ad2000  ! 2069: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	wr_tick_cmpr_2_17:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x99, %g2
	or	%g4, 0xfd, %g4
	or	%g6, 0xe8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x78, %r25
	.word 0x87802020  ! 2072: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r24
	.word 0xd29ce000  ! 2074: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xd2ac6000  ! 2075: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xdaa689e0  ! 2076: STWA_R	stwa	%r13, [%r26 + %r0] 0x4f
	mov	0x3e8, %r20
	.word 0xd2aca000  ! 2078: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0xd8b74e80  ! 2079: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	.word 0xdc9ca000  ! 2080: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r14
	.word 0xdcac2000  ! 2081: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0xdcbce000  ! 2082: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xdca4e000  ! 2083: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0xd0844400  ! 2084: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r8
	mov	0x3e0, %r21
	mov	0x70, %r24
	.word 0xdacec9e0  ! 2087: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r13
	.word 0xdaf46000  ! 2088: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xd4a70e60  ! 2090: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	.word 0xdef5c4a0  ! 2091: STXA_R	stxa	%r15, [%r23 + %r0] 0x25
	.word 0xdaa4a000  ! 2092: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xdabc2000  ! 2093: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xda8ca000  ! 2094: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r13
	.word 0xdac70e80  ! 2095: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r13
	.word 0x87802020  ! 2096: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2097: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd89f2000  ! 2098: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0xde874e40  ! 2099: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r15
	mov	0x7d0, %r23
	.word 0xd8a7e000  ! 2101: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xdcbf4e60  ! 2102: STDA_R	stda	%r14, [%r29 + %r0] 0x73
	.word 0x87802072  ! 2103: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b46000  ! 2104: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0xd2acc400  ! 2105: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0xda840400  ! 2106: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	mov	0x7e0, %r20
	.word 0xdcac6000  ! 2108: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xdcc42000  ! 2109: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r14
	.word 0x87802025  ! 2110: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e0, %r20
	mov	0x7e8, %r23
	.word 0xd495c4a0  ! 2113: LDUHA_R	lduha	[%r23, %r0] 0x25, %r10
	wr_tick_cmpr_2_18:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf2, %g2
	or	%g4, 0xc8, %g4
	or	%g6, 0xf1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x68, %r18
	mov	0x18, %r27
	.word 0xdea42000  ! 2117: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 2118: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2119: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa74e60  ! 2120: STWA_R	stwa	%r13, [%r29 + %r0] 0x73
	mov	0x3c0, %r21
	.word 0xd4a66000  ! 2122: STWA_I	stwa	%r10, [%r25 + 0x0000] %asi
	.word 0xdadfce60  ! 2123: LDXA_R	ldxa	[%r31, %r0] 0x73, %r13
	.word 0xd8acc400  ! 2124: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0xd2be6000  ! 2125: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	mov	0x0, %r24
	.word 0xdab504a0  ! 2127: STHA_R	stha	%r13, [%r20 + %r0] 0x25
	.word 0xd0a74e40  ! 2128: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	.word 0x87802074  ! 2129: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2aec9e0  ! 2130: STBA_R	stba	%r9, [%r27 + %r0] 0x4f
	.word 0xd48f0e40  ! 2131: LDUBA_R	lduba	[%r28, %r0] 0x72, %r10
	mov	0x40, %r16
	.word 0x87802020  ! 2133: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef40400  ! 2134: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0xd0b609e0  ! 2135: STHA_R	stha	%r8, [%r24 + %r0] 0x4f
	.word 0xdabe2000  ! 2136: STDA_I	stda	%r13, [%r24 + 0x0000] %asi
	.word 0xdacee000  ! 2137: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r13
	.word 0xda866000  ! 2138: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r13
	.word 0xdaa66000  ! 2139: STWA_I	stwa	%r13, [%r25 + 0x0000] %asi
	mov	0x50, %r27
	.word 0xdeacc400  ! 2141: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xd8b689e0  ! 2142: STHA_R	stha	%r12, [%r26 + %r0] 0x4f
	mov	0x0, %r16
	mov	0x68, %r16
	.word 0xd8f66000  ! 2145: STXA_I	stxa	%r12, [%r25 + 0x0000] %asi
	.word 0xd8b6a000  ! 2146: STHA_I	stha	%r12, [%r26 + 0x0000] %asi
	.word 0xd4c70e80  ! 2147: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r10
	.word 0xd2a6a000  ! 2148: STWA_I	stwa	%r9, [%r26 + 0x0000] %asi
	.word 0xd2bee000  ! 2149: STDA_I	stda	%r9, [%r27 + 0x0000] %asi
	.word 0xd2ce6000  ! 2150: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r9
	.word 0xd286a000  ! 2151: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r9
	.word 0xd0878e80  ! 2152: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r8
	.word 0xd6d66000  ! 2153: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r11
	mov	0x30, %r26
	.word 0xd69e2000  ! 2155: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r11
	mov	0x58, %r27
	.word 0xdcf544a0  ! 2157: STXA_R	stxa	%r14, [%r21 + %r0] 0x25
	.word 0x87802073  ! 2158: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f0, %r21
	.word 0xd0f4a000  ! 2160: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 2161: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 2162: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r27
	.word 0xd2d6c9e0  ! 2164: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r9
	.word 0xd6b74e40  ! 2165: STHA_R	stha	%r11, [%r29 + %r0] 0x72
	.word 0x87802072  ! 2166: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r25
	.word 0xdad7e000  ! 2168: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	mov	0x18, %r24
	.word 0xdab76000  ! 2170: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdcad44a0  ! 2171: STBA_R	stba	%r14, [%r21 + %r0] 0x25
	.word 0x87802025  ! 2172: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r26
	.word 0xdabf2000  ! 2174: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	mov	0x50, %r17
	mov	0x7c0, %r23
	mov	0x3c0, %r21
	.word 0xdaf76000  ! 2178: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 2179: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 2180: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabc6000  ! 2181: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xdacca000  ! 2182: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	.word 0xdadc6000  ! 2183: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xdaf4a000  ! 2184: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0xda8f8e60  ! 2185: LDUBA_R	lduba	[%r30, %r0] 0x73, %r13
	mov	0x7f8, %r22
	.word 0x87802025  ! 2187: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 2188: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaf7ce80  ! 2189: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	.word 0xdcf46000  ! 2190: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xd8a74e40  ! 2191: STWA_R	stwa	%r12, [%r29 + %r0] 0x72
	.word 0x8780204f  ! 2192: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde8649e0  ! 2193: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r15
	.word 0x8780204f  ! 2194: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d8, %r22
	.word 0xdcad6000  ! 2196: STBA_I	stba	%r14, [%r21 + 0x0000] %asi
	mov	0x60, %r18
	.word 0xdc878e40  ! 2198: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r14
	mov	0x68, %r25
	.word 0xd2a6c9e0  ! 2200: STWA_R	stwa	%r9, [%r27 + %r0] 0x4f
	.word 0x87802073  ! 2201: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 2202: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r25
	.word 0xd08ca000  ! 2204: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xd6f4c400  ! 2205: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0x87802072  ! 2206: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca5c4a0  ! 2207: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	.word 0xd0df6000  ! 2208: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0b72000  ! 2210: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd08fe000  ! 2211: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	mov	0x3d8, %r21
	.word 0xd0b5c4a0  ! 2213: STHA_R	stha	%r8, [%r23 + %r0] 0x25
	.word 0xdef72000  ! 2214: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0xd8afce40  ! 2216: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	.word 0xd287e000  ! 2217: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	mov	0x48, %r25
	mov	0x78, %r17
	.word 0xd2b7e000  ! 2220: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd29f2000  ! 2221: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	mov	0x7d0, %r20
	.word 0xd087ce80  ! 2223: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r8
	.word 0xde8c0400  ! 2224: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0xdeb7e000  ! 2225: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xdeafe000  ! 2226: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xda870e40  ! 2227: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r13
	mov	0x7e8, %r23
	.word 0xdcf609e0  ! 2229: STXA_R	stxa	%r14, [%r24 + %r0] 0x4f
	.word 0xd4cfa000  ! 2230: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0xd49f6000  ! 2231: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0x87802074  ! 2232: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd494e000  ! 2233: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	.word 0xd4f42000  ! 2234: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	wr_tick_cmpr_2_19:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb0, %g2
	or	%g4, 0x8f, %g4
	or	%g6, 0xf8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802025  ! 2236: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0cf4e40  ! 2237: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	mov	0x20, %r25
	.word 0xd88c4400  ! 2239: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0xd0af8e80  ! 2240: STBA_R	stba	%r8, [%r30 + %r0] 0x74
	.word 0xd2cc0400  ! 2241: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r9
	.word 0xd894e000  ! 2242: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r12
	.word 0xd8c4e000  ! 2243: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	mov	0x68, %r17
	.word 0xdcd44400  ! 2245: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	.word 0xdcc4e000  ! 2246: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r14
	.word 0xd88e49e0  ! 2247: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r12
	.word 0xd48c4400  ! 2248: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0xdc8c6000  ! 2249: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r14
	.word 0xd0b4c400  ! 2250: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0xdeaf4e60  ! 2251: STBA_R	stba	%r15, [%r29 + %r0] 0x73
	.word 0xd6dfce40  ! 2252: LDXA_R	ldxa	[%r31, %r0] 0x72, %r11
	.word 0xde8c6000  ! 2253: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 2254: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebea000  ! 2255: STDA_I	stda	%r15, [%r26 + 0x0000] %asi
	.word 0x8780204f  ! 2256: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd69d04a0  ! 2257: LDDA_R	ldda	[%r20, %r0] 0x25, %r11
	.word 0xd6dfce60  ! 2258: LDXA_R	ldxa	[%r31, %r0] 0x73, %r11
	.word 0xd2f5e000  ! 2259: STXA_I	stxa	%r9, [%r23 + 0x0000] %asi
	.word 0xd2ada000  ! 2260: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0x87802074  ! 2261: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r26
	.word 0xd2c7a000  ! 2263: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	wr_tick_cmpr_2_20:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb0, %g2
	or	%g4, 0xdd, %g4
	or	%g6, 0xb8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	wr_tick_cmpr_2_21:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb7, %g2
	or	%g4, 0xe2, %g4
	or	%g6, 0x98, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd287a000  ! 2266: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2267: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bfe000  ! 2268: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 2269: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d8, %r23
	.word 0xd28c4400  ! 2271: LDUBA_R	lduba	[%r17, %r0] 0x20, %r9
	.word 0xd8856000  ! 2272: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	.word 0xda94c400  ! 2273: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	.word 0xd0d56000  ! 2274: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r8
	.word 0x87802073  ! 2275: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcccc400  ! 2276: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	.word 0xdebc6000  ! 2277: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xdedc2000  ! 2278: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r15
	.word 0xde846000  ! 2279: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0x87802073  ! 2280: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaafce80  ! 2281: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	mov	0x28, %r24
	.word 0xd6d52000  ! 2283: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r11
	mov	0x38, %r18
	.word 0xd6856000  ! 2285: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r11
	.word 0x87802025  ! 2286: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd68da000  ! 2287: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r11
	.word 0xd6bd6000  ! 2288: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 2289: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r18
	.word 0xd6bda000  ! 2291: STDA_I	stda	%r11, [%r22 + 0x0000] %asi
	.word 0x87802074  ! 2292: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcde89e0  ! 2293: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r14
	mov	0x78, %r17
	.word 0xd4bc0400  ! 2295: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xd6a62000  ! 2296: STWA_I	stwa	%r11, [%r24 + 0x0000] %asi
	mov	0x68, %r19
	.word 0x8780204f  ! 2298: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0d78e40  ! 2299: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r8
	.word 0xdab76000  ! 2300: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xd6b40400  ! 2301: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xdab7a000  ! 2302: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 2303: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r25
	.word 0xdabc2000  ! 2305: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xdabca000  ! 2306: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdadca000  ! 2307: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0xdacc2000  ! 2308: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xd6d70e80  ! 2309: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r11
	.word 0xd6dc2000  ! 2310: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r11
	mov	0x10, %r18
	mov	0x50, %r24
	.word 0xd6bc6000  ! 2313: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0xda878e60  ! 2314: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r13
	.word 0xd6b74e40  ! 2315: STHA_R	stha	%r11, [%r29 + %r0] 0x72
	.word 0xd8a4e000  ! 2316: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xd8c4e000  ! 2317: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	mov	0x8, %r24
	.word 0xd8a4e000  ! 2319: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xd4ae09e0  ! 2321: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0xdeb4a000  ! 2322: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0xdcf78e80  ! 2323: STXA_R	stxa	%r14, [%r30 + %r0] 0x74
	.word 0xd29f4e40  ! 2324: LDDA_R	ldda	[%r29, %r0] 0x72, %r9
	.word 0xd4aca000  ! 2325: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0xd4dc2000  ! 2326: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	mov	0x20, %r24
	.word 0xd6f504a0  ! 2328: STXA_R	stxa	%r11, [%r20 + %r0] 0x25
	.word 0xd08ca000  ! 2329: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xd08ce000  ! 2330: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xd2970e60  ! 2331: LDUHA_R	lduha	[%r28, %r0] 0x73, %r9
	.word 0xda8d44a0  ! 2332: LDUBA_R	lduba	[%r21, %r0] 0x25, %r13
	.word 0xd4d504a0  ! 2333: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r10
	mov	0x3c8, %r21
	.word 0xd2a504a0  ! 2335: STWA_R	stwa	%r9, [%r20 + %r0] 0x25
	.word 0xdaf7ce40  ! 2336: STXA_R	stxa	%r13, [%r31 + %r0] 0x72
	mov	0x78, %r18
	.word 0x87802074  ! 2338: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r16
	.word 0xd8a46000  ! 2340: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8b46000  ! 2341: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0xd89c6000  ! 2342: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r12
	.word 0xd8f4a000  ! 2343: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8ace000  ! 2344: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0xd8842000  ! 2345: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	.word 0x87802074  ! 2346: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda840400  ! 2347: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	.word 0xd8c40400  ! 2348: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	.word 0xdab5c4a0  ! 2349: STHA_R	stha	%r13, [%r23 + %r0] 0x25
	.word 0xdeb72000  ! 2350: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xdec72000  ! 2351: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xd0ce09e0  ! 2352: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r8
	mov	0x60, %r27
	.word 0xd4a74e40  ! 2354: STWA_R	stwa	%r10, [%r29 + %r0] 0x72
	mov	0x68, %r18
	mov	0x28, %r25
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802025  ! 2358: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f8, %r22
	.word 0x87802020  ! 2360: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d5e000  ! 2361: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r10
	.word 0xdacf0e80  ! 2362: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r13
	.word 0xdc8d6000  ! 2363: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2364: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r18
	.word 0xdc87e000  ! 2366: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	mov	0x3c8, %r22
	.word 0xda8c4400  ! 2368: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0xd28f8e80  ! 2369: LDUBA_R	lduba	[%r30, %r0] 0x74, %r9
	.word 0xdeb72000  ! 2370: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xd0c689e0  ! 2371: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r8
	.word 0xdadfa000  ! 2372: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	mov	0x7d0, %r21
	.word 0xdaafa000  ! 2374: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdaf72000  ! 2375: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	mov	0x40, %r26
	.word 0xda9f6000  ! 2377: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 2378: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd09c4400  ! 2379: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	.word 0xd68c8400  ! 2380: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	mov	0x0, %r18
	mov	0x48, %r17
	mov	0x18, %r19
	.word 0xd8d42000  ! 2384: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0xd8b70e40  ! 2385: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0x87802025  ! 2386: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda86a000  ! 2387: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r13
	.word 0xd4bfce80  ! 2388: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	.word 0xdea70e80  ! 2389: STWA_R	stwa	%r15, [%r28 + %r0] 0x74
	.word 0x87802072  ! 2390: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cdc4a0  ! 2391: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r10
	wr_tick_cmpr_2_22:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc7, %g2
	or	%g4, 0xfa, %g4
	or	%g6, 0xaf, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd69504a0  ! 2393: LDUHA_R	lduha	[%r20, %r0] 0x25, %r11
	.word 0xd2dee000  ! 2394: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r9
	.word 0xd2f62000  ! 2395: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	.word 0xdcae09e0  ! 2396: STBA_R	stba	%r14, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 2397: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdac62000  ! 2398: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2399: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cc0400  ! 2400: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0x87802072  ! 2401: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 2402: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf7ce80  ! 2403: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	.word 0xd8a7a000  ! 2404: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd894c400  ! 2405: LDUHA_R	lduha	[%r19, %r0] 0x20, %r12
	.word 0x87802073  ! 2406: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f4e000  ! 2407: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	mov	0x68, %r19
	mov	0x7c8, %r20
	.word 0xda9f8e60  ! 2410: LDDA_R	ldda	[%r30, %r0] 0x73, %r13
	.word 0xd0bce000  ! 2411: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xd0f4a000  ! 2413: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xd6aec9e0  ! 2414: STBA_R	stba	%r11, [%r27 + %r0] 0x4f
	.word 0xdccce000  ! 2415: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r14
	.word 0xdcbf0e60  ! 2416: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	.word 0xd8f44400  ! 2417: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0x87802025  ! 2418: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r19
	.word 0xdebfce40  ! 2420: STDA_R	stda	%r15, [%r31 + %r0] 0x72
	.word 0xd4bea000  ! 2421: STDA_I	stda	%r10, [%r26 + 0x0000] %asi
	.word 0xd2afce40  ! 2422: STBA_R	stba	%r9, [%r31 + %r0] 0x72
	.word 0xd0f66000  ! 2423: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	.word 0xd6bf8e60  ! 2424: STDA_R	stda	%r11, [%r30 + %r0] 0x73
	.word 0xd4ae6000  ! 2425: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 2426: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2427: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r24
	mov	0x7d8, %r21
	mov	0x58, %r26
	mov	0x30, %r18
	mov	0x3f8, %r22
	.word 0xdc9dc4a0  ! 2433: LDDA_R	ldda	[%r23, %r0] 0x25, %r14
	.word 0xde8c2000  ! 2434: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	.word 0x87802025  ! 2435: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xded6a000  ! 2436: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r15
	.word 0xdea62000  ! 2437: STWA_I	stwa	%r15, [%r24 + 0x0000] %asi
	.word 0xd8dc0400  ! 2438: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0xd69dc4a0  ! 2439: LDDA_R	ldda	[%r23, %r0] 0x25, %r11
	mov	0x20, %r26
	mov	0x48, %r25
	.word 0x87802073  ! 2442: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb504a0  ! 2443: STHA_R	stha	%r14, [%r20 + %r0] 0x25
	mov	0x38, %r18
	mov	0x30, %r19
	mov	0x28, %r26
	mov	0x7e8, %r22
	.word 0xd296a000  ! 2448: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r9
	.word 0xdc86c9e0  ! 2449: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r14
	.word 0xdca609e0  ! 2450: STWA_R	stwa	%r14, [%r24 + %r0] 0x4f
	.word 0xdace2000  ! 2451: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r13
	wr_tick_cmpr_2_23:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xad, %g2
	or	%g4, 0xfc, %g4
	or	%g6, 0x87, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0b74e80  ! 2453: STHA_R	stha	%r8, [%r29 + %r0] 0x74
	.word 0xd48e2000  ! 2454: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 2455: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2456: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bce000  ! 2457: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0xd8d4c400  ! 2458: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0xdabc6000  ! 2459: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 2460: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacd6000  ! 2461: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r13
	.word 0xd2f6c9e0  ! 2462: STXA_R	stxa	%r9, [%r27 + %r0] 0x4f
	.word 0xd6dd6000  ! 2463: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r11
	.word 0xd6b52000  ! 2464: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	.word 0xd6dda000  ! 2465: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r11
	.word 0xded78e60  ! 2466: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r15
	.word 0xd09584a0  ! 2467: LDUHA_R	lduha	[%r22, %r0] 0x25, %r8
	.word 0xdc8da000  ! 2468: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r14
	.word 0xd8cf0e60  ! 2469: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r12
	.word 0x87802073  ! 2470: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c0, %r20
	.word 0x87802020  ! 2472: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8504a0  ! 2473: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r13
	mov	0x3e0, %r22
	.word 0xdef46000  ! 2475: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xdece09e0  ! 2476: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r15
	.word 0xdaa70e80  ! 2477: STWA_R	stwa	%r13, [%r28 + %r0] 0x74
	mov	0x58, %r26
	.word 0xd6878e40  ! 2479: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r11
	.word 0xdcf4a000  ! 2480: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcb42000  ! 2481: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xdca46000  ! 2482: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xd89f0e60  ! 2483: LDDA_R	ldda	[%r28, %r0] 0x73, %r12
	.word 0xd0a74e60  ! 2484: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	mov	0x7c8, %r20
	.word 0xd8f4e000  ! 2486: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xd6ac0400  ! 2487: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 2488: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2489: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb5a000  ! 2490: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	.word 0xda9fce60  ! 2491: LDDA_R	ldda	[%r31, %r0] 0x73, %r13
	.word 0x87802020  ! 2492: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r26
	.word 0xda846000  ! 2494: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r13
	.word 0xdab4e000  ! 2495: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xdc85c4a0  ! 2496: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r14
	.word 0xde848400  ! 2497: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	.word 0xdc9c8400  ! 2498: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	mov	0x3f8, %r23
	mov	0x3c8, %r21
	mov	0x7f0, %r21
	.word 0xd88544a0  ! 2502: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r12
	.word 0xd2f70e60  ! 2503: STXA_R	stxa	%r9, [%r28 + %r0] 0x73
	.word 0xda9fce80  ! 2504: LDDA_R	ldda	[%r31, %r0] 0x74, %r13
	.word 0xdcaca000  ! 2505: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xde878e80  ! 2506: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r15
	.word 0xde8f4e60  ! 2507: LDUBA_R	lduba	[%r29, %r0] 0x73, %r15
	.word 0x87802072  ! 2508: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd28544a0  ! 2509: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r9
	.word 0xd0cca000  ! 2510: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	mov	0x10, %r17
	.word 0xdc97ce40  ! 2512: LDUHA_R	lduha	[%r31, %r0] 0x72, %r14
	.word 0xd49c6000  ! 2513: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0xd4d4a000  ! 2514: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0xd8bf4e40  ! 2515: STDA_R	stda	%r12, [%r29 + %r0] 0x72
	.word 0xd4a4a000  ! 2516: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xdab689e0  ! 2517: STHA_R	stha	%r13, [%r26 + %r0] 0x4f
	.word 0xd4c4a000  ! 2518: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	.word 0xd494a000  ! 2519: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r10
	.word 0xd4cce000  ! 2520: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	mov	0x7d0, %r21
	.word 0xd88c8400  ! 2522: LDUBA_R	lduba	[%r18, %r0] 0x20, %r12
	.word 0xd0cc0400  ! 2523: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xdebce000  ! 2524: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xde846000  ! 2525: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	mov	0x3c0, %r20
	.word 0xdec4a000  ! 2527: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xdeaca000  ! 2528: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xdecc6000  ! 2530: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r15
	.word 0x87802020  ! 2531: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde94a000  ! 2532: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0xd4b70e40  ! 2533: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	.word 0xd8f544a0  ! 2534: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	.word 0xd68c6000  ! 2535: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2536: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b42000  ! 2537: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 2538: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0c4c400  ! 2539: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	.word 0xdcdd44a0  ! 2540: LDXA_R	ldxa	[%r21, %r0] 0x25, %r14
	.word 0xd2be49e0  ! 2541: STDA_R	stda	%r9, [%r25 + %r0] 0x4f
	.word 0xd4d48400  ! 2542: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	.word 0xd2c6c9e0  ! 2543: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r9
	mov	0x7c0, %r20
	.word 0x87802072  ! 2545: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeafa000  ! 2546: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xd2f4c400  ! 2547: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	mov	0x20, %r24
	.word 0xd8b7e000  ! 2549: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0xd8f76000  ! 2550: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	mov	0x10, %r19
	.word 0xd88fe000  ! 2552: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8b72000  ! 2553: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd0cc8400  ! 2554: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0xd2af2000  ! 2555: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xdcf584a0  ! 2556: STXA_R	stxa	%r14, [%r22 + %r0] 0x25
	.word 0xdca7a000  ! 2557: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xd0d74e80  ! 2558: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r8
	.word 0xd8b7ce40  ! 2559: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0xd2d78e40  ! 2560: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r9
	mov	0x7d0, %r21
	mov	0x30, %r19
	mov	0x3f8, %r21
	.word 0xdabc4400  ! 2564: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	mov	0x68, %r16
	mov	0x7d8, %r21
	.word 0x8780204f  ! 2567: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcdda000  ! 2568: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r14
	.word 0xdc9de000  ! 2569: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r14
	.word 0xdea544a0  ! 2570: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	.word 0xd8dcc400  ! 2571: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	mov	0x8, %r26
	.word 0xd8b56000  ! 2573: STHA_I	stha	%r12, [%r21 + 0x0000] %asi
	.word 0xd8dd6000  ! 2574: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r12
	.word 0xdab74e80  ! 2575: STHA_R	stha	%r13, [%r29 + %r0] 0x74
	.word 0xd0ac4400  ! 2576: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0xd88cc400  ! 2577: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	.word 0xda952000  ! 2578: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r13
	.word 0xdaf5a000  ! 2579: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xda9de000  ! 2580: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r13
	.word 0xd8af4e40  ! 2581: STBA_R	stba	%r12, [%r29 + %r0] 0x72
	.word 0xd8ad2000  ! 2582: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	.word 0xd4cfce80  ! 2583: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r10
	.word 0xdec5e000  ! 2584: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r15
	.word 0xdea56000  ! 2585: STWA_I	stwa	%r15, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 2586: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2587: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4acc400  ! 2588: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xd4d56000  ! 2589: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r10
	.word 0x87802073  ! 2590: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r24
	.word 0xdeb70e60  ! 2592: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	.word 0xd8cec9e0  ! 2593: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r12
	mov	0x3e8, %r22
	.word 0xd6a78e60  ! 2595: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0xd4ada000  ! 2596: STBA_I	stba	%r10, [%r22 + 0x0000] %asi
	.word 0xd4ada000  ! 2597: STBA_I	stba	%r10, [%r22 + 0x0000] %asi
	.word 0xd495e000  ! 2598: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r10
	wr_tick_cmpr_2_24:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xbf, %g2
	or	%g4, 0xa8, %g4
	or	%g6, 0xdd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0bd04a0  ! 2600: STDA_R	stda	%r8, [%r20 + %r0] 0x25
	.word 0x87802074  ! 2601: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2602: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbcc400  ! 2603: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xde8f8e40  ! 2604: LDUBA_R	lduba	[%r30, %r0] 0x72, %r15
	.word 0xd2c544a0  ! 2605: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r9
	.word 0xd2cc6000  ! 2606: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	.word 0xd2c46000  ! 2607: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	mov	0x8, %r16
	mov	0x8, %r24
	.word 0xd4b44400  ! 2610: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	.word 0x87802073  ! 2611: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f7ce80  ! 2612: STXA_R	stxa	%r11, [%r31 + %r0] 0x74
	.word 0x87802020  ! 2613: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2614: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 2615: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0d7a000  ! 2616: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0x87802025  ! 2617: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a6a000  ! 2618: STWA_I	stwa	%r8, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 2619: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa4c400  ! 2620: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	mov	0x20, %r16
	.word 0x87802074  ! 2622: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c0, %r23
	mov	0x60, %r19
	.word 0xd4c6a000  ! 2625: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r10
	.word 0xd48e6000  ! 2626: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r10
	.word 0xd49ee000  ! 2627: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r10
	.word 0xd4cea000  ! 2628: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r10
	.word 0x87802020  ! 2629: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c4a000  ! 2630: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	.word 0xd4f4a000  ! 2631: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0xd6d40400  ! 2632: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	.word 0xd8dc6000  ! 2633: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	wr_tick_cmpr_2_25:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xaf, %g2
	or	%g4, 0xbe, %g4
	or	%g6, 0x9b, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7d8, %r23
	.word 0xd8f4e000  ! 2636: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 2637: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd28f4e60  ! 2638: LDUBA_R	lduba	[%r29, %r0] 0x73, %r9
	.word 0x8780204f  ! 2639: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x48, %r27
	.word 0xd6a4c400  ! 2641: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0xd6866000  ! 2642: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r11
	.word 0xd6de2000  ! 2643: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r11
	.word 0xd68e6000  ! 2644: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r11
	.word 0xd6a62000  ! 2645: STWA_I	stwa	%r11, [%r24 + 0x0000] %asi
	mov	0x38, %r18
	mov	0x3c0, %r20
	.word 0x87802020  ! 2648: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f4a000  ! 2649: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 2650: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6d7e000  ! 2651: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	.word 0xd6cfe000  ! 2652: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0xd6b7a000  ! 2653: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd6df6000  ! 2654: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0xde974e40  ! 2655: LDUHA_R	lduha	[%r29, %r0] 0x72, %r15
	.word 0xde87e000  ! 2656: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0x87802072  ! 2657: WRASI_I	wr	%r0, 0x0072, %asi
	wr_tick_cmpr_2_26:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xcc, %g2
	or	%g4, 0x99, %g4
	or	%g6, 0x8f, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdecf2000  ! 2659: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0x87802020  ! 2660: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2661: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r19
	.word 0xdccc0400  ! 2663: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r14
	.word 0xde956000  ! 2664: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r15
	.word 0xdaae49e0  ! 2665: STBA_R	stba	%r13, [%r25 + %r0] 0x4f
	.word 0xd09d6000  ! 2666: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r8
	.word 0xded78e40  ! 2667: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r15
	.word 0xd8be89e0  ! 2668: STDA_R	stda	%r12, [%r26 + %r0] 0x4f
	mov	0x38, %r16
	.word 0xd8f70e60  ! 2670: STXA_R	stxa	%r12, [%r28 + %r0] 0x73
	.word 0xd495a000  ! 2671: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r10
	.word 0xd4f5e000  ! 2672: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	.word 0xd4d52000  ! 2673: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r10
	.word 0xd4f52000  ! 2674: STXA_I	stxa	%r10, [%r20 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0x87802072  ! 2676: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcc5c4a0  ! 2677: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r14
	.word 0xd8bc2000  ! 2678: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd8d70e40  ! 2679: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r12
	.word 0xd4a4a000  ! 2680: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 2681: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r16
	.word 0xd4cc2000  ! 2683: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	.word 0xd4dce000  ! 2684: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	mov	0x18, %r16
	.word 0xdef78e40  ! 2686: STXA_R	stxa	%r15, [%r30 + %r0] 0x72
	.word 0x87802025  ! 2687: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b6c9e0  ! 2688: STHA_R	stha	%r11, [%r27 + %r0] 0x4f
	.word 0x87802072  ! 2689: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8cf6000  ! 2690: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0xd8a7a000  ! 2691: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd88c8400  ! 2692: LDUBA_R	lduba	[%r18, %r0] 0x20, %r12
	mov	0x38, %r18
	.word 0xdc8e09e0  ! 2694: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r14
	mov	0x38, %r18
	mov	0x3e0, %r20
	.word 0x87802020  ! 2697: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdca000  ! 2698: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	mov	0x68, %r25
	.word 0xdca4e000  ! 2700: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcb4a000  ! 2701: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xda9609e0  ! 2702: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r13
	.word 0x87802020  ! 2703: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2704: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeaf6000  ! 2705: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	mov	0x8, %r19
	.word 0xde8fa000  ! 2707: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	mov	0x3f8, %r22
	.word 0xdebfa000  ! 2709: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xdca689e0  ! 2710: STWA_R	stwa	%r14, [%r26 + %r0] 0x4f
	.word 0xdcbf2000  ! 2711: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdcdf2000  ! 2712: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdc9fe000  ! 2713: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xd6f504a0  ! 2714: STXA_R	stxa	%r11, [%r20 + %r0] 0x25
	.word 0xd0a689e0  ! 2715: STWA_R	stwa	%r8, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 2716: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r25
	.word 0xdab46000  ! 2718: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0xda9c6000  ! 2719: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xd8f78e60  ! 2720: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	.word 0xd8846000  ! 2721: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2722: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9cc400  ! 2723: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	.word 0xd4856000  ! 2724: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r10
	.word 0xdabcc400  ! 2725: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	.word 0xdc87ce40  ! 2726: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r14
	.word 0xd8b44400  ! 2727: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0xd8acc400  ! 2728: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 2729: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ad6000  ! 2730: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	.word 0xd8b5a000  ! 2731: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	.word 0x87802073  ! 2732: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c8, %r22
	.word 0xdc844400  ! 2734: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	.word 0xdaf7ce60  ! 2735: STXA_R	stxa	%r13, [%r31 + %r0] 0x73
	mov	0x28, %r25
	.word 0xdcc44400  ! 2737: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xd6b40400  ! 2738: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0x87802073  ! 2739: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdac689e0  ! 2740: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r13
	.word 0xd4bc0400  ! 2741: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	mov	0x3f0, %r20
	.word 0xd6cc2000  ! 2743: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	mov	0x7c8, %r23
	.word 0xd6cce000  ! 2745: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r11
	mov	0x3f0, %r21
	mov	0x70, %r19
	.word 0xd6bc6000  ! 2748: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	mov	0x20, %r24
	.word 0xdacc0400  ! 2750: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r13
	.word 0xd6ac4400  ! 2751: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	ta	T_CHANGE_PRIV	! macro
	mov	0x38, %r24
	mov	0x10, %r16
	mov	0x40, %r27
	mov	0x20, %r24
	.word 0xd0bca000  ! 2757: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0xd0cca000  ! 2758: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	.word 0xd0f4e000  ! 2759: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xdcf40400  ! 2760: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	mov	0x3d8, %r21
	.word 0xd4c74e80  ! 2762: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r10
	.word 0xdac649e0  ! 2763: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r13
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0dc2000  ! 2765: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	.word 0xd0f42000  ! 2766: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0xd0846000  ! 2767: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	mov	0x68, %r17
	mov	0x18, %r17
	mov	0x7d0, %r21
	.word 0xd0bca000  ! 2771: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 2772: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0846000  ! 2773: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0xd0b4e000  ! 2774: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	mov	0x7d0, %r21
	mov	0x3f0, %r21
	mov	0x58, %r25
	mov	0x60, %r18
	.word 0xd09689e0  ! 2779: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r8
	.word 0xd6ad44a0  ! 2780: STBA_R	stba	%r11, [%r21 + %r0] 0x25
	.word 0x8780204f  ! 2781: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6dc2000  ! 2782: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r11
	.word 0xd6ac6000  ! 2783: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xd2d70e60  ! 2784: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r9
	.word 0x87802072  ! 2785: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r27
	.word 0xd694c400  ! 2787: LDUHA_R	lduha	[%r19, %r0] 0x20, %r11
	.word 0x8780204f  ! 2788: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a40400  ! 2789: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0xd0cfce60  ! 2790: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r8
	.word 0xdebfce80  ! 2791: STDA_R	stda	%r15, [%r31 + %r0] 0x74
	.word 0xd4df4e40  ! 2792: LDXA_R	ldxa	[%r29, %r0] 0x72, %r10
	.word 0xd48d2000  ! 2793: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 2794: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4978e80  ! 2795: LDUHA_R	lduha	[%r30, %r0] 0x74, %r10
	.word 0x8780204f  ! 2796: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 2797: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda94a000  ! 2798: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	.word 0xdc9584a0  ! 2799: LDUHA_R	lduha	[%r22, %r0] 0x25, %r14
	.word 0xd2978e40  ! 2800: LDUHA_R	lduha	[%r30, %r0] 0x72, %r9
	.word 0x87802073  ! 2801: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r19
	.word 0xd4d544a0  ! 2803: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r10
	.word 0xd49c8400  ! 2804: LDDA_R	ldda	[%r18, %r0] 0x20, %r10
	.word 0x87802020  ! 2805: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2806: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r20
	mov	0x78, %r16
	.word 0x87802020  ! 2809: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb7ce40  ! 2810: STHA_R	stha	%r15, [%r31 + %r0] 0x72
	.word 0xdccec9e0  ! 2811: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r14
	.word 0xd8cda000  ! 2812: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r12
	mov	0x78, %r17
	.word 0x87802074  ! 2814: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2815: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 2816: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6be89e0  ! 2817: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	.word 0xdab66000  ! 2818: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0xda9e6000  ! 2819: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r13
	mov	0x7c8, %r22
	.word 0xdccf0e40  ! 2821: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r14
	.word 0x8780204f  ! 2822: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r25
	.word 0xd2b6c9e0  ! 2824: STHA_R	stha	%r9, [%r27 + %r0] 0x4f
	mov	0x18, %r16
	mov	0x8, %r25
	mov	0x18, %r25
	.word 0xd6a74e60  ! 2828: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	.word 0xd8f7ce80  ! 2829: STXA_R	stxa	%r12, [%r31 + %r0] 0x74
	wr_tick_cmpr_2_27:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa3, %g2
	or	%g4, 0xce, %g4
	or	%g6, 0xa3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdabfe000  ! 2831: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xda87a000  ! 2832: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0xdc878e40  ! 2833: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r14
	.word 0xd48f2000  ! 2834: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	mov	0x60, %r19
	mov	0x68, %r16
	.word 0xd6ae49e0  ! 2837: STBA_R	stba	%r11, [%r25 + %r0] 0x4f
	.word 0xd2a7e000  ! 2838: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xd4a40400  ! 2839: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	.word 0x87802020  ! 2840: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r27
	.word 0xdab66000  ! 2842: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0xdcb504a0  ! 2843: STHA_R	stha	%r14, [%r20 + %r0] 0x25
	.word 0xdece2000  ! 2844: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r15
	.word 0xded74e80  ! 2845: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r15
	.word 0xd6d70e40  ! 2846: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r11
	.word 0x87802025  ! 2847: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdacf2000  ! 2848: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0x87802073  ! 2849: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdad72000  ! 2850: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0xdab7e000  ! 2851: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xdab76000  ! 2852: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xda870e40  ! 2853: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r13
	.word 0xde948400  ! 2854: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	mov	0x7c0, %r21
	.word 0x87802020  ! 2856: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_2_28:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb0, %g2
	or	%g4, 0xff, %g4
	or	%g6, 0xff, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7c0, %r22
	.word 0x87802020  ! 2859: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f56000  ! 2860: STXA_I	stxa	%r8, [%r21 + 0x0000] %asi
	.word 0xdcb48400  ! 2861: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	mov	0x7f8, %r23
	.word 0xdaa7ce80  ! 2863: STWA_R	stwa	%r13, [%r31 + %r0] 0x74
	mov	0x78, %r16
	.word 0xd0f44400  ! 2865: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd08d6000  ! 2866: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r8
	.word 0xd0f52000  ! 2867: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 2868: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_2_29:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xdd, %g2
	or	%g4, 0x89, %g4
	or	%g6, 0x9a, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3d8, %r21
	.word 0xd0cee000  ! 2871: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r8
	mov	0x3d0, %r20
	.word 0xd28504a0  ! 2873: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r9
	mov	0x18, %r17
	mov	0x58, %r24
	.word 0xde8e2000  ! 2876: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r15
	.word 0xd4978e40  ! 2877: LDUHA_R	lduha	[%r30, %r0] 0x72, %r10
	.word 0xd28e2000  ! 2878: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	.word 0xd2d48400  ! 2879: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	.word 0xdeb70e60  ! 2880: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	.word 0x87802020  ! 2881: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2882: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaa70e60  ! 2883: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	mov	0x18, %r18
	.word 0xd6cc2000  ! 2885: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	.word 0xdccc8400  ! 2886: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	mov	0x38, %r26
	.word 0xdc8dc4a0  ! 2888: LDUBA_R	lduba	[%r23, %r0] 0x25, %r14
	.word 0xd0cc2000  ! 2889: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 2890: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r27
	mov	0x48, %r18
	.word 0xd095e000  ! 2893: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r8
	.word 0x87802020  ! 2894: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2895: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdea4c400  ! 2896: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	.word 0xdaf609e0  ! 2897: STXA_R	stxa	%r13, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 2898: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda8584a0  ! 2899: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r13
	.word 0x87802020  ! 2900: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r25
	.word 0xdadf2000  ! 2902: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0x87802072  ! 2903: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6acc400  ! 2904: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0x87802020  ! 2905: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd497e000  ! 2906: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	.word 0xd4a7a000  ! 2907: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xdc8649e0  ! 2908: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r14
	.word 0xd4ae49e0  ! 2909: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0xd4a70e40  ! 2910: STWA_R	stwa	%r10, [%r28 + %r0] 0x72
	mov	0x7c8, %r20
	.word 0xdacf6000  ! 2912: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xda876000  ! 2913: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2914: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d44400  ! 2915: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	.word 0xd8d72000  ! 2916: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	mov	0x68, %r27
	mov	0x58, %r24
	mov	0x3f0, %r22
	.word 0xd68c8400  ! 2920: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	.word 0x87802073  ! 2921: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r16
	mov	0x30, %r25
	.word 0x87802073  ! 2924: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a4a000  ! 2925: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0xd0f4a000  ! 2926: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 2927: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf649e0  ! 2928: STXA_R	stxa	%r14, [%r25 + %r0] 0x4f
	mov	0x7e8, %r21
	mov	0x7e0, %r22
	.word 0xde872000  ! 2931: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	mov	0x7c0, %r23
	.word 0xdeafe000  ! 2933: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xdedfe000  ! 2934: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	mov	0x7e0, %r21
	.word 0xd28dc4a0  ! 2936: LDUBA_R	lduba	[%r23, %r0] 0x25, %r9
	.word 0xd8bf8e40  ! 2937: STDA_R	stda	%r12, [%r30 + %r0] 0x72
	.word 0xdca72000  ! 2938: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	mov	0x18, %r16
	.word 0xdcaf6000  ! 2940: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 2941: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 2942: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4ccc400  ! 2943: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0xd0bcc400  ! 2944: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	mov	0x68, %r24
	.word 0xd8bc2000  ! 2946: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xde8c8400  ! 2947: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	.word 0x8780204f  ! 2948: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r22
	.word 0xdebc2000  ! 2950: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xde84a000  ! 2951: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	mov	0x3e8, %r23
	.word 0xdeb46000  ! 2953: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 2954: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea42000  ! 2955: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 2956: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedd2000  ! 2957: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r15
	.word 0xda848400  ! 2958: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r13
	.word 0xdc9dc4a0  ! 2959: LDDA_R	ldda	[%r23, %r0] 0x25, %r14
	mov	0x78, %r17
	.word 0xd0b56000  ! 2961: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	.word 0xd09d2000  ! 2962: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r8
	.word 0xd0d52000  ! 2963: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r8
	.word 0x87802074  ! 2964: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdad40400  ! 2965: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	.word 0xd4af0e80  ! 2966: STBA_R	stba	%r10, [%r28 + %r0] 0x74
	.word 0xdaac2000  ! 2967: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0xdaf4e000  ! 2968: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	mov	0x38, %r27
	mov	0x0, %r26
	.word 0x87802020  ! 2971: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab5e000  ! 2972: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0xdaa5a000  ! 2973: STWA_I	stwa	%r13, [%r22 + 0x0000] %asi
	.word 0xd0bc4400  ! 2974: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	mov	0x68, %r25
	mov	0x40, %r24
	.word 0xded52000  ! 2977: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r15
	.word 0xdadcc400  ! 2978: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xd6f52000  ! 2979: STXA_I	stxa	%r11, [%r20 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0xd6bde000  ! 2981: STDA_I	stda	%r11, [%r23 + 0x0000] %asi
	.word 0xdeac4400  ! 2982: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	mov	0x68, %r24
	.word 0xd2dd2000  ! 2984: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r9
	.word 0x87802072  ! 2985: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab78e80  ! 2986: STHA_R	stha	%r13, [%r30 + %r0] 0x74
	.word 0x87802072  ! 2987: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde972000  ! 2988: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0xdadf4e60  ! 2989: LDXA_R	ldxa	[%r29, %r0] 0x73, %r13
	.word 0xd894c400  ! 2990: LDUHA_R	lduha	[%r19, %r0] 0x20, %r12
	.word 0xd6a72000  ! 2991: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6cd04a0  ! 2992: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r11
	.word 0xd08609e0  ! 2993: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r8
	.word 0xd287e000  ! 2994: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0xd4f4c400  ! 2995: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xdef7ce40  ! 2996: STXA_R	stxa	%r15, [%r31 + %r0] 0x72
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8afa000  ! 2998: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	mov	0x3d8, %r22
	.word 0xd8dfe000  ! 3000: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8f72000  ! 3001: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd4d609e0  ! 3002: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r10
	mov	0x3f8, %r21
	.word 0xdcaf4e40  ! 3004: STBA_R	stba	%r14, [%r29 + %r0] 0x72
	.word 0xd8d40400  ! 3005: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	mov	0x3f8, %r22
	.word 0x87802074  ! 3007: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6cf0e80  ! 3008: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r11
	.word 0xd4df8e60  ! 3009: LDXA_R	ldxa	[%r30, %r0] 0x73, %r10
	mov	0x50, %r19
	mov	0x7c8, %r21
	.word 0x8780204f  ! 3012: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd08fce80  ! 3013: LDUBA_R	lduba	[%r31, %r0] 0x74, %r8
	.word 0xd4c52000  ! 3014: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r10
	.word 0xd6d48400  ! 3015: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	mov	0x38, %r25
	.word 0xd2f609e0  ! 3017: STXA_R	stxa	%r9, [%r24 + %r0] 0x4f
	.word 0xd0bf8e60  ! 3018: STDA_R	stda	%r8, [%r30 + %r0] 0x73
	.word 0xdaafce40  ! 3019: STBA_R	stba	%r13, [%r31 + %r0] 0x72
	wr_tick_cmpr_2_30:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xa8, %g2
	or	%g4, 0xac, %g4
	or	%g6, 0xee, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3e0, %r23
	.word 0xdabda000  ! 3022: STDA_I	stda	%r13, [%r22 + 0x0000] %asi
	.word 0xdecf0e80  ! 3023: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r15
	.word 0x87802073  ! 3024: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8972000  ! 3025: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	.word 0xd6cc4400  ! 3026: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	mov	0x3e0, %r22
	.word 0xdebe49e0  ! 3028: STDA_R	stda	%r15, [%r25 + %r0] 0x4f
	.word 0xdcf76000  ! 3029: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdca7a000  ! 3030: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	mov	0x28, %r27
	.word 0x87802073  ! 3032: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d0, %r20
	.word 0xdccc0400  ! 3034: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r14
	.word 0xd0c6a000  ! 3035: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r8
	mov	0x20, %r25
	.word 0x87802072  ! 3037: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r26
	.word 0xd2af0e40  ! 3039: STBA_R	stba	%r9, [%r28 + %r0] 0x72
	.word 0x8780204f  ! 3040: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r18
	.word 0xdebfce60  ! 3042: STDA_R	stda	%r15, [%r31 + %r0] 0x73
	.word 0xd2cfce60  ! 3043: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r9
	.word 0xd886c9e0  ! 3044: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r12
	.word 0xd8af6000  ! 3045: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd0ce09e0  ! 3046: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r8
	.word 0x87802073  ! 3047: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e0, %r23
	.word 0xdaaea000  ! 3049: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	.word 0xda8ee000  ! 3050: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r13
	mov	0x58, %r25
	.word 0xda8ee000  ! 3052: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r13
	.word 0xdad7ce40  ! 3053: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r13
	mov	0x3f0, %r20
	.word 0x87802020  ! 3055: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r25
	.word 0xd4a7a000  ! 3057: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4cfa000  ! 3058: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0xdade89e0  ! 3059: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r13
	.word 0x8780204f  ! 3060: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdca609e0  ! 3061: STWA_R	stwa	%r14, [%r24 + %r0] 0x4f
	.word 0xd4a4e000  ! 3062: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xdc8f8e60  ! 3063: LDUBA_R	lduba	[%r30, %r0] 0x73, %r14
	.word 0xd0cca000  ! 3064: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	mov	0x3d8, %r20
	mov	0x40, %r26
	.word 0xd0844400  ! 3067: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r8
	.word 0xd2f44400  ! 3068: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	.word 0x87802072  ! 3069: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde946000  ! 3070: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r15
	mov	0x28, %r19
	.word 0x87802072  ! 3072: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b78e40  ! 3073: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	.word 0xdabf8e40  ! 3074: STDA_R	stda	%r13, [%r30 + %r0] 0x72
	.word 0xdc94c400  ! 3075: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	.word 0xdcaf6000  ! 3076: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdeaf4e80  ! 3077: STBA_R	stba	%r15, [%r29 + %r0] 0x74
	.word 0xd4f72000  ! 3078: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4c7a000  ! 3079: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	.word 0x87802025  ! 3080: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4dfa000  ! 3081: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	mov	0x68, %r25
	.word 0xd4f76000  ! 3083: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	mov	0x78, %r17
	.word 0xd6acc400  ! 3085: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xd6970e40  ! 3086: LDUHA_R	lduha	[%r28, %r0] 0x72, %r11
	.word 0xd2f7a000  ! 3087: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xdeaec9e0  ! 3088: STBA_R	stba	%r15, [%r27 + %r0] 0x4f
	.word 0x87802025  ! 3089: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r17
	.word 0xd68c6000  ! 3091: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r11
	.word 0xd68c6000  ! 3092: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r11
	mov	0x58, %r16
	mov	0x3e0, %r23
	.word 0xd4bfce60  ! 3095: STDA_R	stda	%r10, [%r31 + %r0] 0x73
	mov	0x8, %r24
	.word 0x87802074  ! 3097: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r19
	.word 0xdcbe49e0  ! 3099: STDA_R	stda	%r14, [%r25 + %r0] 0x4f
	.word 0xdadd84a0  ! 3100: LDXA_R	ldxa	[%r22, %r0] 0x25, %r13
	.word 0xdcac2000  ! 3101: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xd6f44400  ! 3103: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0xde94a000  ! 3104: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	mov	0x70, %r17
	.word 0x87802020  ! 3106: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bfce80  ! 3107: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	.word 0xdeb4c400  ! 3108: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0x87802073  ! 3109: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 3110: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeaf4e40  ! 3111: STBA_R	stba	%r15, [%r29 + %r0] 0x72
	.word 0xde948400  ! 3112: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	mov	0x7e0, %r21
	.word 0xd8de09e0  ! 3114: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r12
	.word 0xdaf7a000  ! 3115: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xd8d7ce60  ! 3116: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r12
	mov	0x18, %r26
	.word 0xd2b609e0  ! 3118: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	mov	0x18, %r25
	.word 0xd8d7a000  ! 3120: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	mov	0x18, %r18
	.word 0xd8a76000  ! 3122: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 3123: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8be2000  ! 3124: STDA_I	stda	%r12, [%r24 + 0x0000] %asi
	wr_tick_cmpr_2_31:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe6, %g2
	or	%g4, 0xcf, %g4
	or	%g6, 0x85, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8866000  ! 3126: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r12
	.word 0xdaaf4e80  ! 3127: STBA_R	stba	%r13, [%r29 + %r0] 0x74
	mov	0x70, %r27
	mov	0x3d8, %r22
	mov	0x3c0, %r21
	.word 0x87802020  ! 3131: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedc6000  ! 3132: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r15
	mov	0x7f8, %r22
	.word 0xd0d4c400  ! 3134: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	.word 0x87802073  ! 3135: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d0, %r23
	mov	0x3d0, %r20
	.word 0xdcde09e0  ! 3138: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r14
	.word 0xdece49e0  ! 3139: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r15
	.word 0xd6d48400  ! 3140: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0xd8bf6000  ! 3141: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 3142: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d0, %r21
	.word 0xd8cc2000  ! 3144: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 3145: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r27
	mov	0x7d0, %r21
	mov	0x18, %r24
	.word 0xd8afe000  ! 3149: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd89f2000  ! 3150: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0x87802074  ! 3151: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0bfce60  ! 3152: STDA_R	stda	%r8, [%r31 + %r0] 0x73
	.word 0xdaaf4e80  ! 3153: STBA_R	stba	%r13, [%r29 + %r0] 0x74
	mov	0x0, %r26
	.word 0xd0a4a000  ! 3155: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0xd0bca000  ! 3156: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0xdea44400  ! 3157: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	mov	0x7f0, %r20
	.word 0xd4842000  ! 3159: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	mov	0x28, %r17
	.word 0xd4cc6000  ! 3161: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	.word 0xd0adc4a0  ! 3162: STBA_R	stba	%r8, [%r23 + %r0] 0x25
	.word 0xd6d4c400  ! 3163: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	.word 0xd08ce000  ! 3164: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	mov	0x50, %r18
	.word 0xd6d74e60  ! 3166: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r11
	.word 0xd28f8e40  ! 3167: LDUBA_R	lduba	[%r30, %r0] 0x72, %r9
	mov	0x3c8, %r21
	.word 0x87802020  ! 3169: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded72000  ! 3170: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xdef7a000  ! 3171: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3172: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde852000  ! 3173: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r15
	.word 0x87802025  ! 3174: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeace000  ! 3175: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xde946000  ! 3176: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r15
	.word 0xd6cc4400  ! 3177: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	.word 0xd0bca000  ! 3178: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0xd0aca000  ! 3179: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xdabe89e0  ! 3180: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	.word 0xd68f4e40  ! 3181: LDUBA_R	lduba	[%r29, %r0] 0x72, %r11
	mov	0x10, %r16
	.word 0xdcf48400  ! 3183: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xd49f8e40  ! 3184: LDDA_R	ldda	[%r30, %r0] 0x72, %r10
	wr_tick_cmpr_2_32:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe9, %g2
	or	%g4, 0xae, %g4
	or	%g6, 0xc7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4b40400  ! 3186: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0xd6cd84a0  ! 3187: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r11
	.word 0xded5c4a0  ! 3188: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r15
	.word 0x8780204f  ! 3189: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4c74e60  ! 3190: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r10
	.word 0xd8956000  ! 3191: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r12
	.word 0xd8b5a000  ! 3192: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	mov	0x28, %r17
	.word 0x87802020  ! 3194: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r24
	.word 0xdeb74e80  ! 3196: STHA_R	stha	%r15, [%r29 + %r0] 0x74
	.word 0xd6bf2000  ! 3197: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd6bf2000  ! 3198: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xd0b70e40  ! 3200: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	mov	0x7c8, %r21
	.word 0x8780204f  ! 3202: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r17
	.word 0x87802020  ! 3204: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0dc6000  ! 3205: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	.word 0x87802020  ! 3206: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b72000  ! 3207: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xdaf74e40  ! 3208: STXA_R	stxa	%r13, [%r29 + %r0] 0x72
	mov	0x18, %r26
	.word 0xd497a000  ! 3210: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	mov	0x70, %r17
	.word 0xd48fa000  ! 3212: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xd487e000  ! 3213: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xda844400  ! 3214: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r13
	.word 0xd887e000  ! 3215: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0xdaf70e80  ! 3216: STXA_R	stxa	%r13, [%r28 + %r0] 0x74
	.word 0xd6a74e40  ! 3217: STWA_R	stwa	%r11, [%r29 + %r0] 0x72
	.word 0xd4bfa000  ! 3218: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	mov	0x10, %r19
	.word 0x87802025  ! 3220: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0acc400  ! 3221: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	mov	0x7f8, %r20
	.word 0xd6dde000  ! 3223: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r11
	.word 0xd6856000  ! 3224: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r11
	.word 0xd6b52000  ! 3225: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	.word 0xd8d544a0  ! 3226: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r12
	.word 0xd8a56000  ! 3227: STWA_I	stwa	%r12, [%r21 + 0x0000] %asi
	mov	0x3f8, %r20
	mov	0x18, %r26
	.word 0xd8ada000  ! 3230: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0xdaf544a0  ! 3231: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	.word 0xd88649e0  ! 3232: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r12
	.word 0xd6f5a000  ! 3233: STXA_I	stxa	%r11, [%r22 + 0x0000] %asi
	.word 0xd6cd6000  ! 3234: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r11
	.word 0xd6bd6000  ! 3235: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	mov	0x3e0, %r20
	.word 0xd6af0e80  ! 3237: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	.word 0xd285e000  ! 3238: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r9
	mov	0x48, %r17
	.word 0xdabcc400  ! 3240: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	.word 0xdcbd2000  ! 3241: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	mov	0x20, %r17
	.word 0xd0ddc4a0  ! 3243: LDXA_R	ldxa	[%r23, %r0] 0x25, %r8
	wr_tick_cmpr_2_33:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf7, %g2
	or	%g4, 0xe5, %g4
	or	%g6, 0x92, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdecd2000  ! 3245: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r15
	.word 0xded5e000  ! 3246: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r15
	.word 0xd0f48400  ! 3247: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xdabde000  ! 3248: STDA_I	stda	%r13, [%r23 + 0x0000] %asi
	.word 0xda95e000  ! 3249: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r13
	.word 0xdab52000  ! 3250: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	.word 0xdabde000  ! 3251: STDA_I	stda	%r13, [%r23 + 0x0000] %asi
	.word 0xd297ce60  ! 3252: LDUHA_R	lduha	[%r31, %r0] 0x73, %r9
	.word 0xdaac0400  ! 3253: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xd0cd6000  ! 3254: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r8
	.word 0xd48f4e40  ! 3255: LDUBA_R	lduba	[%r29, %r0] 0x72, %r10
	.word 0xd8ad84a0  ! 3256: STBA_R	stba	%r12, [%r22 + %r0] 0x25
	.word 0xd8f56000  ! 3257: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 3258: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3259: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2878e40  ! 3260: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r9
	.word 0x87802020  ! 3261: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f70e40  ! 3262: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	.word 0xd2a46000  ! 3263: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2d4e000  ! 3264: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0xdca70e60  ! 3265: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	.word 0xd8a46000  ! 3266: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xdeac0400  ! 3267: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2946000  ! 3269: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r9
	mov	0x38, %r17
	.word 0xd2b4e000  ! 3271: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0xd2f4e000  ! 3272: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 3273: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdecf4e60  ! 3274: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r15
	.word 0xdedc4400  ! 3275: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	.word 0xd8b72000  ! 3276: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd2c74e80  ! 3277: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r9
	.word 0xded7ce40  ! 3278: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r15
	mov	0x68, %r17
	.word 0xd6af6000  ! 3280: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd6a76000  ! 3281: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdcae09e0  ! 3283: STBA_R	stba	%r14, [%r24 + %r0] 0x4f
	.word 0xd6f7e000  ! 3284: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xde944400  ! 3285: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	.word 0xdeaf6000  ! 3286: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	mov	0x60, %r19
	.word 0xdeafa000  ! 3288: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xde972000  ! 3289: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	mov	0x3c0, %r22
	.word 0xded76000  ! 3291: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0xd4c70e40  ! 3292: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r10
	.word 0xdcbfce80  ! 3293: STDA_R	stda	%r14, [%r31 + %r0] 0x74
	mov	0x78, %r16
	.word 0xdca70e60  ! 3295: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	.word 0xde8c4400  ! 3296: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	.word 0xd8ac0400  ! 3297: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0x87802025  ! 3298: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b66000  ! 3299: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	mov	0x3f0, %r21
	.word 0x8780204f  ! 3301: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2cc6000  ! 3302: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	.word 0xd2b504a0  ! 3303: STHA_R	stha	%r9, [%r20 + %r0] 0x25
	.word 0xd09f8e80  ! 3304: LDDA_R	ldda	[%r30, %r0] 0x74, %r8
	.word 0xd2bce000  ! 3305: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xd6acc400  ! 3306: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xdcad04a0  ! 3307: STBA_R	stba	%r14, [%r20 + %r0] 0x25
	.word 0xd6f74e80  ! 3308: STXA_R	stxa	%r11, [%r29 + %r0] 0x74
	.word 0xd8a74e80  ! 3309: STWA_R	stwa	%r12, [%r29 + %r0] 0x74
	.word 0xdcbc2000  ! 3310: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xd89cc400  ! 3311: LDDA_R	ldda	[%r19, %r0] 0x20, %r12
	.word 0xd8bce000  ! 3312: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd8846000  ! 3313: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	.word 0xd8846000  ! 3314: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	mov	0x3f0, %r22
	.word 0xd0d7ce80  ! 3316: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r8
	.word 0xd4b4c400  ! 3317: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0xd0c4a000  ! 3318: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0f42000  ! 3319: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0xd2bc0400  ! 3320: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xd2ac2000  ! 3321: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 3322: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ce2000  ! 3323: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r9
	.word 0xd2ae2000  ! 3324: STBA_I	stba	%r9, [%r24 + 0x0000] %asi
	.word 0xd6f7ce60  ! 3325: STXA_R	stxa	%r11, [%r31 + %r0] 0x73
	.word 0xd4be6000  ! 3326: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0x87802025  ! 3327: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4a6e000  ! 3328: STWA_I	stwa	%r10, [%r27 + 0x0000] %asi
	mov	0x0, %r24
	.word 0x87802020  ! 3330: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r25
	.word 0x8780204f  ! 3332: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdcb74e60  ! 3334: STHA_R	stha	%r14, [%r29 + %r0] 0x73
	.word 0xdaaee000  ! 3335: STBA_I	stba	%r13, [%r27 + 0x0000] %asi
	.word 0xda86a000  ! 3336: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r13
	.word 0xda86a000  ! 3337: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r13
	.word 0xdab66000  ! 3338: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xdca4c400  ! 3340: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xd6ce2000  ! 3341: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	.word 0xd4f4c400  ! 3342: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xdadd84a0  ! 3343: LDXA_R	ldxa	[%r22, %r0] 0x25, %r13
	mov	0x8, %r25
	.word 0x87802025  ! 3345: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r26
	.word 0x87802074  ! 3347: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r16
	.word 0x87802020  ! 3349: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r26
	mov	0x10, %r26
	mov	0x0, %r17
	mov	0x58, %r19
	.word 0xd6944400  ! 3354: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	mov	0x50, %r17
	.word 0xd8f78e80  ! 3356: STXA_R	stxa	%r12, [%r30 + %r0] 0x74
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd8c44400  ! 3358: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r12
	.word 0xd0a74e60  ! 3359: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	mov	0x20, %r25
	mov	0x20, %r19
	.word 0xda972000  ! 3362: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	ta	T_CHANGE_HPRIV	! macro
	.word 0xde9ec9e0  ! 3364: LDDA_R	ldda	[%r27, %r0] 0x4f, %r15
	mov	0x60, %r18
	.word 0xde972000  ! 3366: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 3367: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcb7ce40  ! 3368: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	.word 0xd2a74e80  ! 3369: STWA_R	stwa	%r9, [%r29 + %r0] 0x74
	.word 0xd8af6000  ! 3370: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 3371: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8a42000  ! 3372: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	mov	0x70, %r25
	.word 0x87802072  ! 3374: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8ac2000  ! 3375: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0xd4aec9e0  ! 3376: STBA_R	stba	%r10, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 3377: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c0, %r20
	.word 0xd4bde000  ! 3379: STDA_I	stda	%r10, [%r23 + 0x0000] %asi
	mov	0x40, %r24
	.word 0xd4cd6000  ! 3381: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r10
	mov	0x60, %r16
	.word 0xd4f5a000  ! 3383: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	.word 0xd2a4c400  ! 3384: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0xd685a000  ! 3385: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r11
	.word 0xd6c5e000  ! 3386: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r11
	.word 0xd097ce80  ! 3387: LDUHA_R	lduha	[%r31, %r0] 0x74, %r8
	.word 0xd0d70e80  ! 3388: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r8
	.word 0xd6d56000  ! 3389: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r11
	.word 0xd6952000  ! 3390: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r11
	.word 0x87802072  ! 3391: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbd44a0  ! 3392: STDA_R	stda	%r14, [%r21 + %r0] 0x25
	.word 0xd2a4a000  ! 3393: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0xd2bc6000  ! 3394: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0xd2bc6000  ! 3395: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0xd28e09e0  ! 3396: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r9
	.word 0x8780204f  ! 3397: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0946000  ! 3398: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0xdedf8e80  ! 3399: LDXA_R	ldxa	[%r30, %r0] 0x74, %r15
	.word 0xd29c2000  ! 3400: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	mov	0x48, %r18
	.word 0x87802025  ! 3402: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r24
	.word 0xd2f7a000  ! 3404: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 3405: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0874e40  ! 3406: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r8
	mov	0x50, %r18
	mov	0x3e8, %r21
	.word 0x87802020  ! 3409: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r16
	.word 0x87802025  ! 3411: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3412: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r24
	.word 0xdec44400  ! 3414: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0xd8b44400  ! 3415: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	mov	0x7f8, %r21
	.word 0xd6a46000  ! 3417: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0xd69c4400  ! 3418: LDDA_R	ldda	[%r17, %r0] 0x20, %r11
	.word 0xd0dd44a0  ! 3419: LDXA_R	ldxa	[%r21, %r0] 0x25, %r8
	.word 0xd2b70e40  ! 3420: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	.word 0x87802020  ! 3421: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b76000  ! 3422: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xdaafce60  ! 3423: STBA_R	stba	%r13, [%r31 + %r0] 0x73
	.word 0x87802020  ! 3424: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd684a000  ! 3425: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r11
	.word 0xd6b4a000  ! 3426: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd4b7ce80  ! 3427: STHA_R	stha	%r10, [%r31 + %r0] 0x74
	.word 0x87802020  ! 3428: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3429: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f66000  ! 3430: STXA_I	stxa	%r9, [%r25 + 0x0000] %asi
	.word 0xd2ce2000  ! 3431: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r9
	mov	0x3e8, %r23
	.word 0xd2cd04a0  ! 3433: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r9
	ta	T_CHANGE_PRIV	! macro
	mov	0x30, %r17
	.word 0xd09dc4a0  ! 3436: LDDA_R	ldda	[%r23, %r0] 0x25, %r8
	.word 0x87802020  ! 3437: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69ce000  ! 3438: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r11
	.word 0xd29649e0  ! 3439: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r9
	mov	0x7d8, %r23
	.word 0xd0a4e000  ! 3441: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	mov	0x8, %r26
	.word 0xd6bc0400  ! 3443: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xd6bca000  ! 3444: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 3445: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb78e80  ! 3446: STHA_R	stha	%r15, [%r30 + %r0] 0x74
	.word 0xdebfce60  ! 3447: STDA_R	stda	%r15, [%r31 + %r0] 0x73
	wr_tick_cmpr_2_34:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd3, %g2
	or	%g4, 0xac, %g4
	or	%g6, 0x93, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0970e80  ! 3450: LDUHA_R	lduha	[%r28, %r0] 0x74, %r8
	.word 0xdac7e000  ! 3451: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xd6c70e40  ! 3452: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r11
	.word 0xd4878e80  ! 3453: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r10
	.word 0xdadfe000  ! 3454: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0xdad7e000  ! 3455: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xdaafe000  ! 3456: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xdaafe000  ! 3457: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xda978e80  ! 3458: LDUHA_R	lduha	[%r30, %r0] 0x74, %r13
	.word 0xd4ae89e0  ! 3459: STBA_R	stba	%r10, [%r26 + %r0] 0x4f
	.word 0xd6f70e80  ! 3460: STXA_R	stxa	%r11, [%r28 + %r0] 0x74
	mov	0x38, %r17
	.word 0x87802020  ! 3462: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdad70e60  ! 3464: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r13
	mov	0x18, %r19
	.word 0xda9d44a0  ! 3466: LDDA_R	ldda	[%r21, %r0] 0x25, %r13
	.word 0xd2c72000  ! 3467: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2b72000  ! 3468: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 3469: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 3470: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde9d84a0  ! 3471: LDDA_R	ldda	[%r22, %r0] 0x25, %r15
	.word 0xd4b4e000  ! 3472: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xd4b4e000  ! 3473: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xd4d4e000  ! 3475: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0xdcc584a0  ! 3476: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r14
	.word 0x87802020  ! 3477: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3478: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a6e000  ! 3479: STWA_I	stwa	%r10, [%r27 + 0x0000] %asi
	.word 0xd4862000  ! 3480: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r10
	.word 0xd6f649e0  ! 3481: STXA_R	stxa	%r11, [%r25 + %r0] 0x4f
	.word 0xd2f5c4a0  ! 3482: STXA_R	stxa	%r9, [%r23 + %r0] 0x25
	.word 0x8780204f  ! 3483: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 3484: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd69c4400  ! 3485: LDDA_R	ldda	[%r17, %r0] 0x20, %r11
	.word 0x87802074  ! 3486: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r24
	.word 0x87802025  ! 3488: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde9f2000  ! 3489: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xde9fa000  ! 3490: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	.word 0xde8fa000  ! 3491: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0xdec76000  ! 3492: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xdedf6000  ! 3493: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xded7e000  ! 3494: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0xdeb72000  ! 3495: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xdef76000  ! 3496: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdcb609e0  ! 3497: STHA_R	stha	%r14, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 3498: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2870e60  ! 3499: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r9
	mov	0x3e8, %r21
	.word 0xd6978e80  ! 3501: LDUHA_R	lduha	[%r30, %r0] 0x74, %r11
	.word 0xd0c40400  ! 3502: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	.word 0xd6a44400  ! 3503: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0xd28c2000  ! 3504: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xd8af8e80  ! 3505: STBA_R	stba	%r12, [%r30 + %r0] 0x74
	.word 0xdedca000  ! 3506: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	mov	0x20, %r24
	.word 0x87802072  ! 3508: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29d84a0  ! 3509: LDDA_R	ldda	[%r22, %r0] 0x25, %r9
	.word 0xda976000  ! 3510: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	.word 0xd0d5c4a0  ! 3511: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r8
	.word 0xdaa40400  ! 3512: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0xdcbcc400  ! 3513: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	mov	0x7d0, %r23
	.word 0x87802020  ! 3515: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a52000  ! 3516: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	.word 0x87802025  ! 3517: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r27
	.word 0xd6f6e000  ! 3519: STXA_I	stxa	%r11, [%r27 + 0x0000] %asi
	.word 0xd68e2000  ! 3520: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3521: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cca000  ! 3522: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r11
	.word 0xd6cc2000  ! 3523: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	.word 0xd8dd44a0  ! 3524: LDXA_R	ldxa	[%r21, %r0] 0x25, %r12
	.word 0x87802074  ! 3525: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 3526: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdccf8e40  ! 3527: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r14
	.word 0xd8872000  ! 3528: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	.word 0xd684c400  ! 3529: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	.word 0x87802025  ! 3530: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8f4e40  ! 3531: LDUBA_R	lduba	[%r29, %r0] 0x72, %r13
	.word 0xd8d72000  ! 3532: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xd8df6000  ! 3533: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	mov	0x3e8, %r23
	.word 0xd88fa000  ! 3535: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0xd8976000  ! 3536: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0xdcb504a0  ! 3537: STHA_R	stha	%r14, [%r20 + %r0] 0x25
	.word 0xd0bf2000  ! 3538: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	mov	0x58, %r25
	.word 0x87802074  ! 3540: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4ce49e0  ! 3541: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r10
	mov	0x68, %r24
	mov	0x3f8, %r22
	.word 0xd8dc6000  ! 3544: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	mov	0x50, %r24
	.word 0x87802020  ! 3546: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f46000  ! 3547: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8a4c400  ! 3548: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	mov	0x7f8, %r21
	.word 0x87802073  ! 3550: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd085e000  ! 3551: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r8
	.word 0x87802074  ! 3552: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc840400  ! 3553: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	.word 0xd49504a0  ! 3554: LDUHA_R	lduha	[%r20, %r0] 0x25, %r10
	.word 0x87802073  ! 3555: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b584a0  ! 3556: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	.word 0xdcbf4e80  ! 3557: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	.word 0xdeaf0e60  ! 3558: STBA_R	stba	%r15, [%r28 + %r0] 0x73
	.word 0xd0dfa000  ! 3559: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0xd097e000  ! 3560: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0af2000  ! 3561: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd09fa000  ! 3562: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	mov	0x8, %r25
	.word 0xd8ad04a0  ! 3564: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	.word 0xdcc7a000  ! 3565: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xdc9f2000  ! 3566: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xd09f8e60  ! 3567: LDDA_R	ldda	[%r30, %r0] 0x73, %r8
	.word 0xd4bfce80  ! 3568: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	.word 0xd2b6c9e0  ! 3569: STHA_R	stha	%r9, [%r27 + %r0] 0x4f
	.word 0x8780204f  ! 3570: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b4c400  ! 3571: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0xd4d5e000  ! 3572: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r10
	.word 0xd4878e60  ! 3573: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r10
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0ad6000  ! 3575: STBA_I	stba	%r8, [%r21 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xd0b5a000  ! 3577: STHA_I	stha	%r8, [%r22 + 0x0000] %asi
	.word 0x87802074  ! 3578: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e0, %r21
	.word 0xd0cfa000  ! 3580: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0xd0a76000  ! 3581: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xdadd04a0  ! 3582: LDXA_R	ldxa	[%r20, %r0] 0x25, %r13
	.word 0xdca76000  ! 3583: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcc72000  ! 3584: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xd495c4a0  ! 3585: LDUHA_R	lduha	[%r23, %r0] 0x25, %r10
	.word 0xdac7e000  ! 3586: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xdab7a000  ! 3587: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdab72000  ! 3588: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xda8fa000  ! 3589: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xdaa7a000  ! 3590: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xda8f6000  ! 3591: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0x87802072  ! 3592: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 3593: WRASI_I	wr	%r0, 0x0025, %asi
	wr_tick_cmpr_2_35:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xcd, %g2
	or	%g4, 0xb7, %g4
	or	%g6, 0xd1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdaf7a000  ! 3595: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdaaf6000  ! 3596: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xdca48400  ! 3597: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xda8fa000  ! 3598: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xdadf2000  ! 3599: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	mov	0x50, %r16
	mov	0x3f8, %r22
	.word 0xdaafa000  ! 3602: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	mov	0x38, %r18
	mov	0x7d0, %r23
	.word 0xdabfe000  ! 3605: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	mov	0x70, %r26
	.word 0xd0de49e0  ! 3607: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r8
	.word 0xd487e000  ! 3608: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 3609: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8f44400  ! 3610: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xd69ce000  ! 3611: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r11
	.word 0xd684a000  ! 3612: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r11
	mov	0x3c0, %r21
	.word 0xd6bc6000  ! 3614: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0xd6ace000  ! 3615: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 3616: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b7a000  ! 3617: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	mov	0x3c0, %r23
	.word 0xd6c78e80  ! 3619: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r11
	mov	0x38, %r18
	mov	0x3d8, %r21
	.word 0xdcb74e80  ! 3622: STHA_R	stha	%r14, [%r29 + %r0] 0x74
	mov	0x18, %r26
	mov	0x30, %r26
	.word 0xd0bf6000  ! 3625: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd0b7e000  ! 3626: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 3627: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r26
	wr_tick_cmpr_2_36:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb4, %g2
	or	%g4, 0x8e, %g4
	or	%g6, 0xc9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0d42000  ! 3630: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r8
	mov	0x7f8, %r20
	.word 0xd08c6000  ! 3632: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0xd0dce000  ! 3633: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r8
	.word 0xdcd74e60  ! 3634: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r14
	.word 0xdea649e0  ! 3635: STWA_R	stwa	%r15, [%r25 + %r0] 0x4f
	.word 0xd0940400  ! 3636: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	.word 0xdcb689e0  ! 3637: STHA_R	stha	%r14, [%r26 + %r0] 0x4f
	.word 0xd6f4e000  ! 3638: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	.word 0xd8f609e0  ! 3639: STXA_R	stxa	%r12, [%r24 + %r0] 0x4f
	mov	0x78, %r17
	.word 0x87802020  ! 3641: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r18
	.word 0xd89504a0  ! 3643: LDUHA_R	lduha	[%r20, %r0] 0x25, %r12
	.word 0x8780204f  ! 3644: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8dc8400  ! 3645: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	mov	0x18, %r17
	.word 0xd6be6000  ! 3647: STDA_I	stda	%r11, [%r25 + 0x0000] %asi
	mov	0x7d0, %r22
	mov	0x28, %r27
	.word 0x87802020  ! 3650: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bfe000  ! 3651: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd69fe000  ! 3652: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	mov	0x40, %r17
	.word 0xd6adc4a0  ! 3654: STBA_R	stba	%r11, [%r23 + %r0] 0x25
	.word 0xd0f74e60  ! 3655: STXA_R	stxa	%r8, [%r29 + %r0] 0x73
	.word 0x87802020  ! 3656: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a40400  ! 3657: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xdcae2000  ! 3658: STBA_I	stba	%r14, [%r24 + 0x0000] %asi
	mov	0x70, %r16
	mov	0x7f0, %r20
	.word 0xdc9e2000  ! 3661: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r14
	.word 0xd2a5c4a0  ! 3662: STWA_R	stwa	%r9, [%r23 + %r0] 0x25
	mov	0x3f0, %r21
	mov	0x7f8, %r23
	.word 0xdc974e80  ! 3665: LDUHA_R	lduha	[%r29, %r0] 0x74, %r14
	.word 0xdedea000  ! 3666: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r15
	.word 0xded62000  ! 3667: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r15
	.word 0xd69f0e60  ! 3668: LDDA_R	ldda	[%r28, %r0] 0x73, %r11
	.word 0x87802073  ! 3669: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc8c0400  ! 3670: LDUBA_R	lduba	[%r16, %r0] 0x20, %r14
	.word 0xd8ad44a0  ! 3671: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	.word 0xd6c74e40  ! 3672: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r11
	.word 0xd0acc400  ! 3673: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xda8fe000  ! 3674: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xd8a40400  ! 3675: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	mov	0x28, %r16
	.word 0xd6cf6000  ! 3677: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6bf6000  ! 3678: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 3679: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde9f8e40  ! 3680: LDDA_R	ldda	[%r30, %r0] 0x72, %r15
	.word 0x87802025  ! 3681: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r24
	.word 0xdedd04a0  ! 3683: LDXA_R	ldxa	[%r20, %r0] 0x25, %r15
	.word 0xde87ce40  ! 3684: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r15
	.word 0xd8c5c4a0  ! 3685: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r12
	mov	0x68, %r16
	.word 0xdecce000  ! 3687: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 3688: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3689: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 3690: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd68fce80  ! 3691: LDUBA_R	lduba	[%r31, %r0] 0x74, %r11
	.word 0x87802020  ! 3692: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r27
	mov	0x7c8, %r21
	.word 0xd8972000  ! 3695: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	.word 0xd8b7a000  ! 3696: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xd0c7ce80  ! 3697: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r8
	.word 0xd2cf2000  ! 3698: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r9
	.word 0x87802072  ! 3699: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2cc4400  ! 3700: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r9
	.word 0xd6f7e000  ! 3701: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6cfa000  ! 3702: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3703: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f52000  ! 3704: STXA_I	stxa	%r11, [%r20 + 0x0000] %asi
	.word 0xd6b48400  ! 3705: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0x87802020  ! 3706: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c4e000  ! 3707: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 3708: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd8afce40  ! 3710: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	.word 0xd0f74e40  ! 3711: STXA_R	stxa	%r8, [%r29 + %r0] 0x72
	.word 0xd0c76000  ! 3712: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0af2000  ! 3713: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	mov	0x10, %r18
	.word 0xd0afa000  ! 3715: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 3716: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3f0, %r23
	.word 0xd69e89e0  ! 3718: LDDA_R	ldda	[%r26, %r0] 0x4f, %r11
	mov	0x20, %r17
	.word 0xd2978e40  ! 3720: LDUHA_R	lduha	[%r30, %r0] 0x72, %r9
	.word 0xdcb544a0  ! 3721: STHA_R	stha	%r14, [%r21 + %r0] 0x25
	mov	0x8, %r19
	mov	0x3c8, %r21
	.word 0xd8dd44a0  ! 3724: LDXA_R	ldxa	[%r21, %r0] 0x25, %r12
	mov	0x78, %r25
	.word 0x87802020  ! 3726: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bd04a0  ! 3727: STDA_R	stda	%r12, [%r20 + %r0] 0x25
	.word 0xd8bd6000  ! 3728: STDA_I	stda	%r12, [%r21 + 0x0000] %asi
	.word 0xd8cfce60  ! 3729: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r12
	.word 0xd08da000  ! 3730: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r8
	.word 0xd0b56000  ! 3731: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	mov	0x10, %r27
	.word 0xd8d584a0  ! 3733: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r12
	.word 0xd0ada000  ! 3734: STBA_I	stba	%r8, [%r22 + 0x0000] %asi
	.word 0xd0f52000  ! 3735: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	.word 0xd09d6000  ! 3736: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 3737: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3738: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdc8400  ! 3739: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	mov	0x18, %r24
	.word 0xdea74e40  ! 3741: STWA_R	stwa	%r15, [%r29 + %r0] 0x72
	.word 0xd0a5c4a0  ! 3742: STWA_R	stwa	%r8, [%r23 + %r0] 0x25
	.word 0x87802025  ! 3743: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8e2000  ! 3744: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r13
	.word 0xdab62000  ! 3745: STHA_I	stha	%r13, [%r24 + 0x0000] %asi
	.word 0xd6f5c4a0  ! 3746: STXA_R	stxa	%r11, [%r23 + %r0] 0x25
	.word 0xd49ee000  ! 3747: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r10
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0bd04a0  ! 3749: STDA_R	stda	%r8, [%r20 + %r0] 0x25
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd4f66000  ! 3751: STXA_I	stxa	%r10, [%r25 + 0x0000] %asi
	.word 0xd4b66000  ! 3752: STHA_I	stha	%r10, [%r25 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xd4be6000  ! 3754: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0xd4ce2000  ! 3755: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r10
	.word 0xd4c66000  ! 3756: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r10
	mov	0x30, %r17
	.word 0xdc9d04a0  ! 3758: LDDA_R	ldda	[%r20, %r0] 0x25, %r14
	.word 0xdaf40400  ! 3759: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xd2d4c400  ! 3760: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r9
	.word 0xdebe2000  ! 3761: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	.word 0x87802025  ! 3762: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde8f2000  ! 3763: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xd0a7ce80  ! 3764: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	mov	0x7d8, %r20
	.word 0x87802072  ! 3766: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6af6000  ! 3767: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd09fce80  ! 3768: LDDA_R	ldda	[%r31, %r0] 0x74, %r8
	.word 0x87802072  ! 3769: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3770: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f0, %r22
	.word 0x8780204f  ! 3772: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 3773: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd69cc400  ! 3774: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	.word 0x87802020  ! 3775: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r20
	.word 0xdc840400  ! 3777: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	.word 0xd8b76000  ! 3778: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd8f7e000  ! 3779: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xdec7ce60  ! 3780: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r15
	mov	0x3e8, %r21
	.word 0xdeb72000  ! 3782: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xdef76000  ! 3783: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdedf6000  ! 3784: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xdea76000  ! 3785: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xda8c4400  ! 3786: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0xd6df8e40  ! 3787: LDXA_R	ldxa	[%r30, %r0] 0x72, %r11
	mov	0x8, %r17
	mov	0x10, %r16
	mov	0x7f8, %r22
	.word 0xd4dcc400  ! 3791: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0x87802073  ! 3792: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde9ee000  ! 3793: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r15
	.word 0xda978e40  ! 3794: LDUHA_R	lduha	[%r30, %r0] 0x72, %r13
	.word 0x87802020  ! 3795: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3796: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb72000  ! 3797: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	mov	0x78, %r27
	.word 0xdc9fa000  ! 3799: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0xdcb649e0  ! 3800: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	.word 0xdab4c400  ! 3801: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0x87802073  ! 3802: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r26
	mov	0x8, %r25
	.word 0xded5e000  ! 3805: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r15
	.word 0xde956000  ! 3806: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r15
	mov	0x40, %r24
	.word 0xd2f7ce40  ! 3808: STXA_R	stxa	%r9, [%r31 + %r0] 0x72
	mov	0x3d0, %r23
	.word 0xdcbf0e60  ! 3810: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	.word 0x87802073  ! 3811: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf72000  ! 3812: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xd6b70e60  ! 3813: STHA_R	stha	%r11, [%r28 + %r0] 0x73
	.word 0xd0ad44a0  ! 3814: STBA_R	stba	%r8, [%r21 + %r0] 0x25
	.word 0xd4bf2000  ! 3815: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	wr_tick_cmpr_2_37:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf4, %g2
	or	%g4, 0xa4, %g4
	or	%g6, 0xbc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4d76000  ! 3817: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0xd4a7e000  ! 3818: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd497a000  ! 3819: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 3820: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4cee000  ! 3821: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r10
	.word 0x87802074  ! 3822: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4dfe000  ! 3823: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	mov	0x30, %r16
	.word 0x87802073  ! 3825: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef544a0  ! 3826: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	.word 0x87802074  ! 3827: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdea76000  ! 3828: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xdacdc4a0  ! 3829: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r13
	.word 0xd8dfa000  ! 3830: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8a7e000  ! 3831: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd097ce60  ! 3832: LDUHA_R	lduha	[%r31, %r0] 0x73, %r8
	.word 0xda978e80  ! 3833: LDUHA_R	lduha	[%r30, %r0] 0x74, %r13
	.word 0xd8840400  ! 3834: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r12
	.word 0xd0f48400  ! 3835: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	mov	0x7c8, %r20
	.word 0xd6d70e60  ! 3837: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r11
	.word 0xd6a44400  ! 3838: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0xd0bf2000  ! 3839: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xd097a000  ! 3840: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	.word 0xd0d76000  ! 3841: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0b7ce60  ! 3842: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	.word 0xd29fe000  ! 3843: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd2a76000  ! 3844: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd8a7ce80  ! 3845: STWA_R	stwa	%r12, [%r31 + %r0] 0x74
	mov	0x3d8, %r22
	mov	0x18, %r24
	.word 0xded78e80  ! 3848: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r15
	.word 0xdaa72000  ! 3849: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	mov	0x7d0, %r22
	.word 0xdab7a000  ! 3851: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdabfa000  ! 3852: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 3853: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4cf4e80  ! 3854: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r10
	mov	0x58, %r19
	wr_tick_cmpr_2_38:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xfe, %g2
	or	%g4, 0xf3, %g4
	or	%g6, 0xfc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4cf2000  ! 3857: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd497e000  ! 3858: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	.word 0xd0f48400  ! 3859: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xd0c5c4a0  ! 3860: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r8
	mov	0x28, %r27
	.word 0xdaa48400  ! 3862: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0x87802020  ! 3863: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r22
	.word 0xd8b74e60  ! 3865: STHA_R	stha	%r12, [%r29 + %r0] 0x73
	.word 0xdadca000  ! 3866: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	mov	0x40, %r19
	.word 0xdcbc4400  ! 3868: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0xd8cca000  ! 3869: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r12
	.word 0xdeb48400  ! 3870: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	mov	0x50, %r24
	mov	0x40, %r24
	.word 0xd28c4400  ! 3873: LDUBA_R	lduba	[%r17, %r0] 0x20, %r9
	.word 0xdadf4e80  ! 3874: LDXA_R	ldxa	[%r29, %r0] 0x74, %r13
	.word 0xd896c9e0  ! 3875: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r12
	mov	0x40, %r19
	mov	0x50, %r16
	.word 0xd8acc400  ! 3878: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0xdea46000  ! 3879: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xdea74e60  ! 3880: STWA_R	stwa	%r15, [%r29 + %r0] 0x73
	.word 0xd0b42000  ! 3881: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xd0aca000  ! 3882: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xd2dd04a0  ! 3883: LDXA_R	ldxa	[%r20, %r0] 0x25, %r9
	.word 0xd094e000  ! 3884: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	mov	0x50, %r26
	.word 0x87802072  ! 3886: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd09fa000  ! 3887: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	.word 0x87802073  ! 3888: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r16
	.word 0xd0aec9e0  ! 3890: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	.word 0xdea70e60  ! 3891: STWA_R	stwa	%r15, [%r28 + %r0] 0x73
	.word 0xda9544a0  ! 3892: LDUHA_R	lduha	[%r21, %r0] 0x25, %r13
	.word 0xd4c70e60  ! 3893: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r10
	.word 0xdcafce40  ! 3894: STBA_R	stba	%r14, [%r31 + %r0] 0x72
	.word 0xde8ca000  ! 3895: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0xdeb4c400  ! 3896: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xd0a46000  ! 3897: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0bc2000  ! 3898: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0xdabfce40  ! 3900: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	.word 0x87802074  ! 3901: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d0, %r20
	mov	0x3d0, %r20
	.word 0xdcb74e60  ! 3904: STHA_R	stha	%r14, [%r29 + %r0] 0x73
	.word 0xd6b6a000  ! 3905: STHA_I	stha	%r11, [%r26 + 0x0000] %asi
	mov	0x0, %r17
	.word 0xd69ea000  ! 3907: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r11
	mov	0x7c8, %r23
	.word 0xd2f4c400  ! 3909: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xda8d04a0  ! 3910: LDUBA_R	lduba	[%r20, %r0] 0x25, %r13
	mov	0x3d0, %r22
	.word 0xd6cea000  ! 3912: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	mov	0x68, %r16
	.word 0xd6ce6000  ! 3914: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r11
	.word 0xd49d04a0  ! 3915: LDDA_R	ldda	[%r20, %r0] 0x25, %r10
	.word 0xd8b7ce80  ! 3916: STHA_R	stha	%r12, [%r31 + %r0] 0x74
	.word 0xd0b6e000  ! 3917: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	.word 0xd0f649e0  ! 3918: STXA_R	stxa	%r8, [%r25 + %r0] 0x4f
	.word 0x87802074  ! 3919: WRASI_I	wr	%r0, 0x0074, %asi
	wr_tick_cmpr_2_39:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xdc, %g2
	or	%g4, 0xe3, %g4
	or	%g6, 0xb4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdabf8e40  ! 3921: STDA_R	stda	%r13, [%r30 + %r0] 0x72
	mov	0x60, %r26
	.word 0x87802020  ! 3923: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r24
	.word 0xdc87e000  ! 3925: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xd2b74e80  ! 3926: STHA_R	stha	%r9, [%r29 + %r0] 0x74
	.word 0x87802020  ! 3927: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bca000  ! 3928: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd8bca000  ! 3929: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd8b78e40  ! 3930: STHA_R	stha	%r12, [%r30 + %r0] 0x72
	.word 0xdc942000  ! 3931: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	.word 0xdcf42000  ! 3932: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	mov	0x68, %r25
	mov	0x58, %r17
	.word 0xdcb42000  ! 3935: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xdcac6000  ! 3936: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xdcbc6000  ! 3937: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xdebec9e0  ! 3938: STDA_R	stda	%r15, [%r27 + %r0] 0x4f
	mov	0x68, %r16
	.word 0xdeb46000  ! 3940: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0xd8a78e40  ! 3941: STWA_R	stwa	%r12, [%r30 + %r0] 0x72
	mov	0x58, %r27
	mov	0x3c8, %r21
	.word 0xd28f4e60  ! 3944: LDUBA_R	lduba	[%r29, %r0] 0x73, %r9
	.word 0xd4a4e000  ! 3945: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xd4c4a000  ! 3946: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	.word 0xd4d4e000  ! 3947: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0xd4b42000  ! 3948: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	.word 0xd49ca000  ! 3949: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0x87802073  ! 3950: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4bfe000  ! 3951: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd4be49e0  ! 3952: STDA_R	stda	%r10, [%r25 + %r0] 0x4f
	.word 0xd4f78e80  ! 3953: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	.word 0xd2b7e000  ! 3954: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2af2000  ! 3955: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd4844400  ! 3956: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0xd8dcc400  ! 3957: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	mov	0x7c8, %r23
	.word 0x8780204f  ! 3959: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e8, %r21
	.word 0xdaac8400  ! 3961: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0xdcf7a000  ! 3962: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0x87802072  ! 3964: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca6e000  ! 3965: STWA_I	stwa	%r14, [%r27 + 0x0000] %asi
	.word 0x87802073  ! 3966: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcaca000  ! 3967: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xd2c78e80  ! 3968: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r9
	.word 0x87802020  ! 3969: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b78e80  ! 3970: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	.word 0xd4a7e000  ! 3971: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd0a78e80  ! 3972: STWA_R	stwa	%r8, [%r30 + %r0] 0x74
	wr_tick_cmpr_2_40:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf6, %g2
	or	%g4, 0xe0, %g4
	or	%g6, 0x85, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 3974: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r24
	mov	0x40, %r17
	.word 0xded7e000  ! 3977: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0xdebf6000  ! 3978: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xd0cf4e80  ! 3979: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r8
	.word 0x87802020  ! 3980: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef72000  ! 3981: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xdebf0e80  ! 3982: STDA_R	stda	%r15, [%r28 + %r0] 0x74
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd4bc8400  ! 3984: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	.word 0x87802020  ! 3985: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc976000  ! 3986: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	.word 0xd2f78e40  ! 3987: STXA_R	stxa	%r9, [%r30 + %r0] 0x72
	.word 0xd4bf2000  ! 3988: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xda97ce80  ! 3989: LDUHA_R	lduha	[%r31, %r0] 0x74, %r13
	.word 0xdcf74e40  ! 3990: STXA_R	stxa	%r14, [%r29 + %r0] 0x72
	.word 0xdabfe000  ! 3991: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 3992: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r19
	.word 0xda876000  ! 3994: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0xdab7a000  ! 3995: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdaf7ce40  ! 3996: STXA_R	stxa	%r13, [%r31 + %r0] 0x72
	.word 0xd0a74e80  ! 3997: STWA_R	stwa	%r8, [%r29 + %r0] 0x74
	mov	0x50, %r19
	.word 0xd2bfe000  ! 3999: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd29fa000  ! 4000: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0x87802020  ! 4001: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_2_41:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x93, %g2
	or	%g4, 0xcd, %g4
	or	%g6, 0xe8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 4003: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r16
	.word 0xd2be2000  ! 4005: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	.word 0xd8bf8e80  ! 4006: STDA_R	stda	%r12, [%r30 + %r0] 0x74
	.word 0xd0de2000  ! 4007: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r8
	mov	0x18, %r16
	mov	0x18, %r18
	mov	0x3c8, %r20
	mov	0x3f8, %r20
	.word 0xdecdc4a0  ! 4012: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r15
	.word 0xd2d62000  ! 4013: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r9
	mov	0x7e8, %r20
	.word 0xd8afce60  ! 4015: STBA_R	stba	%r12, [%r31 + %r0] 0x73
	.word 0xde9f4e40  ! 4016: LDDA_R	ldda	[%r29, %r0] 0x72, %r15
	.word 0xd8866000  ! 4017: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r12
	.word 0xd8bea000  ! 4018: STDA_I	stda	%r12, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 4019: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b7a000  ! 4020: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xd6ac0400  ! 4021: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0xd6bcc400  ! 4022: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0xdea584a0  ! 4023: STWA_R	stwa	%r15, [%r22 + %r0] 0x25
	.word 0xd4976000  ! 4024: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r10
	.word 0xd0ce49e0  ! 4025: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r8
	.word 0xdc9fa000  ! 4026: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0xdeb4c400  ! 4027: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xd4df0e80  ! 4028: LDXA_R	ldxa	[%r28, %r0] 0x74, %r10
	.word 0xdebfe000  ! 4029: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xdade49e0  ! 4031: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r13
	.word 0xde87e000  ! 4032: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdef72000  ! 4033: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xd8a504a0  ! 4034: STWA_R	stwa	%r12, [%r20 + %r0] 0x25
	.word 0xd6a7ce80  ! 4035: STWA_R	stwa	%r11, [%r31 + %r0] 0x74
	.word 0x87802072  ! 4036: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 4037: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 4038: WRASI_I	wr	%r0, 0x0074, %asi
	wr_tick_cmpr_2_42:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xfa, %g2
	or	%g4, 0xd7, %g4
	or	%g6, 0xef, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xda9c8400  ! 4040: LDDA_R	ldda	[%r18, %r0] 0x20, %r13
	.word 0xd0bea000  ! 4041: STDA_I	stda	%r8, [%r26 + 0x0000] %asi
	.word 0x87802072  ! 4042: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a7ce40  ! 4043: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	.word 0xdab6a000  ! 4044: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	mov	0x18, %r27
	.word 0xda9ee000  ! 4046: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r13
	.word 0xdabe2000  ! 4047: STDA_I	stda	%r13, [%r24 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd69ec9e0  ! 4049: LDDA_R	ldda	[%r27, %r0] 0x4f, %r11
	mov	0x7e8, %r22
	.word 0xd2b6e000  ! 4051: STHA_I	stha	%r9, [%r27 + 0x0000] %asi
	.word 0xd2966000  ! 4052: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r9
	mov	0x3f0, %r23
	mov	0x7e8, %r21
	mov	0x58, %r27
	.word 0x87802073  ! 4056: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd29ee000  ! 4057: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r9
	.word 0xd2f62000  ! 4058: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	.word 0xde840400  ! 4059: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	.word 0xd4cea000  ! 4060: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r10
	.word 0xd4dcc400  ! 4061: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0xd4ac4400  ! 4062: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xd686a000  ! 4063: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r11
	.word 0x87802073  ! 4064: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r16
	mov	0x3c0, %r21
	mov	0x38, %r19
	mov	0x30, %r17
	mov	0x68, %r16
	mov	0x68, %r26
	.word 0x87802025  ! 4071: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f8, %r22
	.word 0xde8609e0  ! 4073: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r15
	.word 0xd6f689e0  ! 4074: STXA_R	stxa	%r11, [%r26 + %r0] 0x4f
	mov	0x60, %r25
	.word 0x87802020  ! 4076: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4077: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r26
	.word 0xd8b5a000  ! 4079: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	mov	0x18, %r18
	.word 0xd8a78e80  ! 4081: STWA_R	stwa	%r12, [%r30 + %r0] 0x74
	mov	0x7d8, %r23
	.word 0xd0bd2000  ! 4083: STDA_I	stda	%r8, [%r20 + 0x0000] %asi
	.word 0xde878e80  ! 4084: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r15
	.word 0xdcf70e40  ! 4085: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	mov	0x3f0, %r23
	.word 0x87802020  ! 4087: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbd04a0  ! 4088: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	.word 0xdcaf4e60  ! 4089: STBA_R	stba	%r14, [%r29 + %r0] 0x73
	mov	0x48, %r16
	.word 0x87802020  ! 4091: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca74e40  ! 4092: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	.word 0xd08fa000  ! 4093: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 4094: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f544a0  ! 4095: STXA_R	stxa	%r9, [%r21 + %r0] 0x25
	.word 0xd8a5a000  ! 4096: STWA_I	stwa	%r12, [%r22 + 0x0000] %asi
	.word 0xd8cd6000  ! 4097: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r12
	.word 0xd8f5e000  ! 4098: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	.word 0xd8bd6000  ! 4099: STDA_I	stda	%r12, [%r21 + 0x0000] %asi
	.word 0xd8956000  ! 4100: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r12
	.word 0xdaa74e40  ! 4101: STWA_R	stwa	%r13, [%r29 + %r0] 0x72
	.word 0xd8bfce80  ! 4102: STDA_R	stda	%r12, [%r31 + %r0] 0x74
	.word 0xdeae49e0  ! 4103: STBA_R	stba	%r15, [%r25 + %r0] 0x4f
	.word 0xd48e09e0  ! 4104: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r10
	.word 0xd8ce49e0  ! 4105: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r12
	mov	0x7d8, %r23
	.word 0xdaf52000  ! 4107: STXA_I	stxa	%r13, [%r20 + 0x0000] %asi
	.word 0xdacda000  ! 4108: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r13
	.word 0xd2b78e80  ! 4109: STHA_R	stha	%r9, [%r30 + %r0] 0x74
	.word 0xd08d6000  ! 4110: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r8
	.word 0xd6bfce60  ! 4111: STDA_R	stda	%r11, [%r31 + %r0] 0x73
	mov	0x3c8, %r23
	.word 0xd4de49e0  ! 4113: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r10
	mov	0x38, %r17
	.word 0xd8a689e0  ! 4115: STWA_R	stwa	%r12, [%r26 + %r0] 0x4f
	.word 0x8780204f  ! 4116: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdedfe000  ! 4117: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xd6df8e40  ! 4118: LDXA_R	ldxa	[%r30, %r0] 0x72, %r11
	.word 0x87802020  ! 4119: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbf0e60  ! 4120: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	.word 0x87802072  ! 4121: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdccfe000  ! 4122: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xdcf7e000  ! 4123: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x38, %r25
	.word 0xd0f6c9e0  ! 4125: STXA_R	stxa	%r8, [%r27 + %r0] 0x4f
	.word 0xdeaf6000  ! 4126: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xd6acc400  ! 4127: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xd0f7a000  ! 4128: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	mov	0x7e0, %r21
	.word 0xdcd78e80  ! 4130: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r14
	.word 0xd0cfa000  ! 4131: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	mov	0x38, %r19
	mov	0x60, %r17
	.word 0xd0972000  ! 4134: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xd2f44400  ! 4135: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	.word 0xd687e000  ! 4136: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xdaf78e80  ! 4137: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	.word 0x87802020  ! 4138: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaddc4a0  ! 4139: LDXA_R	ldxa	[%r23, %r0] 0x25, %r13
	.word 0x87802020  ! 4140: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r24
	.word 0xdabf6000  ! 4142: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xdcb544a0  ! 4143: STHA_R	stha	%r14, [%r21 + %r0] 0x25
	mov	0x28, %r25
	.word 0xd8ce89e0  ! 4145: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r12
	.word 0xdaf70e60  ! 4146: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	.word 0x8780204f  ! 4147: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 4148: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e0, %r22
	.word 0xd8b52000  ! 4150: STHA_I	stha	%r12, [%r20 + 0x0000] %asi
	mov	0x7f8, %r20
	.word 0xd6d48400  ! 4152: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	mov	0x3e8, %r23
	.word 0xd8a56000  ! 4154: STWA_I	stwa	%r12, [%r21 + 0x0000] %asi
	mov	0x3d8, %r21
	.word 0x87802025  ! 4156: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2978e80  ! 4157: LDUHA_R	lduha	[%r30, %r0] 0x74, %r9
	mov	0x58, %r16
	.word 0x87802074  ! 4159: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacc8400  ! 4160: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r13
	.word 0xde9dc4a0  ! 4161: LDDA_R	ldda	[%r23, %r0] 0x25, %r15
	.word 0x87802020  ! 4162: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cd04a0  ! 4163: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r9
	.word 0xd09f6000  ! 4164: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	.word 0xd0afa000  ! 4165: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	mov	0x78, %r19
	.word 0xd0b7e000  ! 4167: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0xd0976000  ! 4168: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0c78e60  ! 4169: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r8
	mov	0x7c0, %r21
	mov	0x8, %r19
	mov	0x18, %r19
	.word 0xdcdfe000  ! 4173: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xdaf504a0  ! 4174: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	.word 0xdcbf4e40  ! 4175: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	.word 0x8780204f  ! 4176: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0af8e80  ! 4177: STBA_R	stba	%r8, [%r30 + %r0] 0x74
	.word 0xd8f42000  ! 4178: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	mov	0x28, %r16
	.word 0xd8a42000  ! 4180: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8ac6000  ! 4181: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	mov	0x68, %r26
	.word 0xdacf8e80  ! 4183: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r13
	mov	0x70, %r19
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd8940400  ! 4186: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	.word 0xd29c2000  ! 4187: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	.word 0xd4be89e0  ! 4188: STDA_R	stda	%r10, [%r26 + %r0] 0x4f
	.word 0xd6f42000  ! 4189: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	mov	0x7f8, %r22
	.word 0xd494c400  ! 4191: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	.word 0xd2bf0e60  ! 4192: STDA_R	stda	%r9, [%r28 + %r0] 0x73
	.word 0x87802020  ! 4193: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08ee000  ! 4194: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r8
	.word 0xd0a66000  ! 4195: STWA_I	stwa	%r8, [%r25 + 0x0000] %asi
	.word 0xda9584a0  ! 4196: LDUHA_R	lduha	[%r22, %r0] 0x25, %r13
	mov	0x7e8, %r23
	.word 0xd68d44a0  ! 4198: LDUBA_R	lduba	[%r21, %r0] 0x25, %r11
	.word 0xdccfce40  ! 4199: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r14
	.word 0x87802025  ! 4200: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 4201: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdea76000  ! 4202: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xdcbf0e80  ! 4203: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	mov	0x20, %r17
	.word 0xd4844400  ! 4205: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0xd0c584a0  ! 4206: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r8
	.word 0x87802074  ! 4207: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bde000  ! 4208: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0xd8c5e000  ! 4209: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r12
	.word 0xd8bda000  ! 4210: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	.word 0xd8c56000  ! 4211: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r12
	.word 0xd8bde000  ! 4212: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 4213: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r24
	.word 0xd0df4e60  ! 4215: LDXA_R	ldxa	[%r29, %r0] 0x73, %r8
	mov	0x8, %r27
	.word 0xd8d4e000  ! 4217: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0xd6d609e0  ! 4218: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r11
	.word 0xdad44400  ! 4219: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	mov	0x38, %r19
	.word 0xd09584a0  ! 4221: LDUHA_R	lduha	[%r22, %r0] 0x25, %r8
	.word 0xd4942000  ! 4222: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r10
	.word 0xd0cf8e80  ! 4223: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r8
	.word 0xdcb42000  ! 4224: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	mov	0x3e8, %r21
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802020  ! 4227: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc84a000  ! 4228: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	.word 0xdcf4a000  ! 4229: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 4230: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcac2000  ! 4231: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0xd8bcc400  ! 4232: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 4233: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd68f8e80  ! 4234: LDUBA_R	lduba	[%r30, %r0] 0x74, %r11
	.word 0xdab4a000  ! 4235: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0xd8cc8400  ! 4236: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0xdcd70e40  ! 4237: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r14
	.word 0xd0cf0e80  ! 4238: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r8
	.word 0xd4c4a000  ! 4239: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	.word 0xd494a000  ! 4240: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r10
	.word 0xd4948400  ! 4241: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	.word 0xdcdc2000  ! 4242: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r14
	.word 0xd0c40400  ! 4243: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	mov	0x0, %r24
	.word 0xd8d4e000  ! 4245: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0xd0a44400  ! 4246: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	mov	0x8, %r18
	mov	0x50, %r19
	.word 0xdebf0e80  ! 4249: STDA_R	stda	%r15, [%r28 + %r0] 0x74
	.word 0x8780204f  ! 4250: WRASI_I	wr	%r0, 0x004f, %asi
	wr_tick_cmpr_2_43:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xdc, %g2
	or	%g4, 0xa7, %g4
	or	%g6, 0xe0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd89f8e60  ! 4252: LDDA_R	ldda	[%r30, %r0] 0x73, %r12
	mov	0x7f0, %r23
	.word 0xd6b72000  ! 4254: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd0a584a0  ! 4255: STWA_R	stwa	%r8, [%r22 + %r0] 0x25
	.word 0xd8878e60  ! 4256: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r12
	.word 0x87802074  ! 4257: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 4258: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r19
	wr_tick_cmpr_2_44:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xab, %g2
	or	%g4, 0xcf, %g4
	or	%g6, 0xcc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xde8e6000  ! 4261: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r15
	.word 0xd0f609e0  ! 4262: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 4263: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r17
	.word 0xd89c0400  ! 4265: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	.word 0xd8f56000  ! 4266: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	wr_tick_cmpr_2_45:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf6, %g2
	or	%g4, 0xe8, %g4
	or	%g6, 0xfd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802074  ! 4268: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd49ec9e0  ! 4269: LDDA_R	ldda	[%r27, %r0] 0x4f, %r10
	mov	0x50, %r25
	.word 0xd6cd2000  ! 4271: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r11
	.word 0xd0cf4e40  ! 4272: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	mov	0x28, %r27
	.word 0xdaa56000  ! 4274: STWA_I	stwa	%r13, [%r21 + 0x0000] %asi
	.word 0x87802072  ! 4275: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2afce60  ! 4276: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	.word 0xd2cf6000  ! 4277: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	mov	0x68, %r16
	.word 0xd28f6000  ! 4279: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xde8f4e80  ! 4280: LDUBA_R	lduba	[%r29, %r0] 0x74, %r15
	.word 0x87802073  ! 4281: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdebd44a0  ! 4282: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	.word 0xd6be09e0  ! 4283: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	.word 0xd8856000  ! 4284: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	.word 0x87802072  ! 4285: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeddc4a0  ! 4286: LDXA_R	ldxa	[%r23, %r0] 0x25, %r15
	mov	0x78, %r25
	.word 0xd8bce000  ! 4288: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xdaaf4e40  ! 4289: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	.word 0xd2a4a000  ! 4290: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	mov	0x28, %r25
	.word 0xd69c0400  ! 4292: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	mov	0x68, %r17
	mov	0x3f8, %r21
	.word 0xdaa78e60  ! 4295: STWA_R	stwa	%r13, [%r30 + %r0] 0x73
	.word 0xdc97ce80  ! 4296: LDUHA_R	lduha	[%r31, %r0] 0x74, %r14
	mov	0x7e8, %r22
	mov	0x28, %r19
	wr_tick_cmpr_2_46:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa3, %g2
	or	%g4, 0xfa, %g4
	or	%g6, 0xe7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 4300: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r23
	.word 0xda8f4e60  ! 4302: LDUBA_R	lduba	[%r29, %r0] 0x73, %r13
	.word 0xda9ec9e0  ! 4303: LDDA_R	ldda	[%r27, %r0] 0x4f, %r13
	.word 0xd8a48400  ! 4304: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	mov	0x58, %r16
	mov	0x50, %r26
	.word 0xd896e000  ! 4307: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r12
	mov	0x7f8, %r23
	.word 0x87802072  ! 4309: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4310: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r17
	.word 0xdca40400  ! 4312: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	mov	0x60, %r25
	.word 0x87802025  ! 4314: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda9da000  ! 4315: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r13
	.word 0xd6f48400  ! 4316: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	mov	0x10, %r27
	mov	0x8, %r16
	mov	0x7c8, %r23
	mov	0x38, %r25
	.word 0x87802020  ! 4321: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca7ce60  ! 4322: STWA_R	stwa	%r14, [%r31 + %r0] 0x73
	.word 0xd2a78e60  ! 4323: STWA_R	stwa	%r9, [%r30 + %r0] 0x73
	.word 0xdcbd44a0  ! 4324: STDA_R	stda	%r14, [%r21 + %r0] 0x25
	.word 0xda8ce000  ! 4325: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	mov	0x3f0, %r23
	.word 0xdac46000  ! 4327: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r13
	.word 0xd6af8e40  ! 4328: STBA_R	stba	%r11, [%r30 + %r0] 0x72
	.word 0xd884c400  ! 4329: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	.word 0xd8bec9e0  ! 4330: STDA_R	stda	%r12, [%r27 + %r0] 0x4f
	.word 0xd4a42000  ! 4331: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 4332: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4333: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d62000  ! 4334: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r10
	.word 0x87802025  ! 4335: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde970e40  ! 4336: LDUHA_R	lduha	[%r28, %r0] 0x72, %r15
	.word 0x87802020  ! 4337: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r22
	.word 0xdec74e80  ! 4339: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r15
	.word 0xdca48400  ! 4340: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	mov	0x48, %r26
	.word 0xd69c8400  ! 4342: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	.word 0xd0f78e40  ! 4343: STXA_R	stxa	%r8, [%r30 + %r0] 0x72
	mov	0x3f0, %r22
	.word 0xdab544a0  ! 4345: STHA_R	stha	%r13, [%r21 + %r0] 0x25
	mov	0x68, %r25
	.word 0xd4d544a0  ! 4347: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r10
	.word 0xd0b689e0  ! 4348: STHA_R	stha	%r8, [%r26 + %r0] 0x4f
	.word 0xdef7ce80  ! 4349: STXA_R	stxa	%r15, [%r31 + %r0] 0x74
	.word 0xd4848400  ! 4350: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r10
	.word 0xd4f7ce60  ! 4351: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	.word 0xdea46000  ! 4352: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 4353: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeaca000  ! 4354: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xdaaf8e60  ! 4355: STBA_R	stba	%r13, [%r30 + %r0] 0x73
	.word 0xd2d42000  ! 4356: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0xd4bc4400  ! 4357: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0xd0a42000  ! 4358: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4359: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r23
	.word 0xd0a504a0  ! 4361: STWA_R	stwa	%r8, [%r20 + %r0] 0x25
	.word 0xd6a74e80  ! 4362: STWA_R	stwa	%r11, [%r29 + %r0] 0x74
	.word 0xdeaf0e40  ! 4363: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	ta	T_CHANGE_PRIV	! macro
	.word 0xd29c8400  ! 4365: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	.word 0xdef44400  ! 4366: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	mov	0x3d0, %r21
	.word 0x87802073  ! 4368: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc97ce60  ! 4369: LDUHA_R	lduha	[%r31, %r0] 0x73, %r14
	.word 0xd4a48400  ! 4370: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	mov	0x7c8, %r23
	.word 0xd4d72000  ! 4372: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	mov	0x7d0, %r20
	mov	0x7d8, %r22
	.word 0xd4b7a000  ! 4375: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 4376: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 4377: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r18
	.word 0xd28c4400  ! 4379: LDUBA_R	lduba	[%r17, %r0] 0x20, %r9
	.word 0x87802072  ! 4380: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r18
	mov	0x28, %r24
	.word 0xd2ad84a0  ! 4383: STBA_R	stba	%r9, [%r22 + %r0] 0x25
	.word 0xd69fa000  ! 4384: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0xdc970e40  ! 4385: LDUHA_R	lduha	[%r28, %r0] 0x72, %r14
	.word 0xd4b76000  ! 4386: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 4387: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcc5c4a0  ! 4388: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r14
	.word 0xdef7e000  ! 4389: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	mov	0x18, %r27
	mov	0x48, %r18
	mov	0x8, %r17
	mov	0x7d8, %r21
	.word 0xdef72000  ! 4394: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xdeaf4e60  ! 4395: STBA_R	stba	%r15, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 4396: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8cde000  ! 4397: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r12
	mov	0x7e0, %r20
	.word 0xd8f5a000  ! 4399: STXA_I	stxa	%r12, [%r22 + 0x0000] %asi
	.word 0xd8f5a000  ! 4400: STXA_I	stxa	%r12, [%r22 + 0x0000] %asi
	.word 0xd895e000  ! 4401: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r12
	.word 0xd2a649e0  ! 4402: STWA_R	stwa	%r9, [%r25 + %r0] 0x4f
	.word 0xdcd649e0  ! 4403: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r14
	.word 0x87802025  ! 4404: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r26
	.word 0xdac609e0  ! 4406: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r13
	.word 0xdadce000  ! 4407: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xdab42000  ! 4408: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xd6cf4e40  ! 4409: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r11
	mov	0x48, %r19
	.word 0xd48fce60  ! 4411: LDUBA_R	lduba	[%r31, %r0] 0x73, %r10
	.word 0xdcbc8400  ! 4412: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	mov	0x7e8, %r22
	.word 0xd2d4e000  ! 4414: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	mov	0x30, %r16
	.word 0xd4b6c9e0  ! 4416: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0xd2ac6000  ! 4417: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xda974e60  ! 4419: LDUHA_R	lduha	[%r29, %r0] 0x73, %r13
	.word 0xd2b4c400  ! 4420: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	mov	0x3e8, %r23
	.word 0x8780204f  ! 4422: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaaf2000  ! 4423: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	mov	0x3e8, %r20
	mov	0x48, %r16
	.word 0x87802074  ! 4426: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf52000  ! 4427: STXA_I	stxa	%r13, [%r20 + 0x0000] %asi
	.word 0xdabd2000  ! 4428: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	.word 0x87802025  ! 4429: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 4430: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 4431: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdabd2000  ! 4432: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	.word 0xd0878e40  ! 4433: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r8
	.word 0xdebd2000  ! 4434: STDA_I	stda	%r15, [%r20 + 0x0000] %asi
	mov	0x30, %r25
	mov	0x28, %r18
	.word 0xded5a000  ! 4437: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r15
	mov	0x20, %r25
	.word 0x87802072  ! 4439: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 4440: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4afce60  ! 4441: STBA_R	stba	%r10, [%r31 + %r0] 0x73
	.word 0xda94c400  ! 4442: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	mov	0x10, %r25
	.word 0xdcc5c4a0  ! 4444: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r14
	.word 0xd6c4a000  ! 4445: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r11
	.word 0xdec7ce80  ! 4446: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r15
	.word 0xd4cc6000  ! 4447: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	.word 0xd4f46000  ! 4448: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 4449: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebd04a0  ! 4450: STDA_R	stda	%r15, [%r20 + %r0] 0x25
	.word 0xdec44400  ! 4451: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0xd8bc4400  ! 4452: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xd08e09e0  ! 4453: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r8
	.word 0xdeb78e60  ! 4454: STHA_R	stha	%r15, [%r30 + %r0] 0x73
	.word 0xd0b72000  ! 4455: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd6c70e80  ! 4456: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r11
	.word 0xd8af4e40  ! 4457: STBA_R	stba	%r12, [%r29 + %r0] 0x72
	.word 0xd0d48400  ! 4458: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	mov	0x38, %r19
	.word 0x87802074  ! 4460: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc94e000  ! 4461: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	mov	0x0, %r25
	mov	0x3d0, %r21
	.word 0xd4f584a0  ! 4464: STXA_R	stxa	%r10, [%r22 + %r0] 0x25
	mov	0x8, %r17
	.word 0x87802025  ! 4466: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8946000  ! 4467: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	.word 0xd89ca000  ! 4468: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r12
	.word 0x87802025  ! 4469: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d0, %r21
	mov	0x18, %r26
	.word 0xd88c2000  ! 4472: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	.word 0xd8ac6000  ! 4473: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xd8f46000  ! 4474: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	mov	0x10, %r24
	.word 0xd48f4e60  ! 4476: LDUBA_R	lduba	[%r29, %r0] 0x73, %r10
	.word 0xdcdca000  ! 4477: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xded584a0  ! 4478: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r15
	mov	0x3c8, %r21
	.word 0xdc9c2000  ! 4480: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r14
	.word 0x87802074  ! 4481: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4482: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r16
	.word 0xdccf0e60  ! 4484: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r14
	mov	0x3e8, %r23
	mov	0x58, %r19
	.word 0xde84a000  ! 4487: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	.word 0xdc9fce80  ! 4488: LDDA_R	ldda	[%r31, %r0] 0x74, %r14
	.word 0xd49c6000  ! 4489: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0xd4f4a000  ! 4490: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	wr_tick_cmpr_2_47:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf3, %g2
	or	%g4, 0xad, %g4
	or	%g6, 0xae, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802072  ! 4492: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49584a0  ! 4493: LDUHA_R	lduha	[%r22, %r0] 0x25, %r10
	.word 0xd0a78e40  ! 4494: STWA_R	stwa	%r8, [%r30 + %r0] 0x72
	.word 0x87802025  ! 4495: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdab4a000  ! 4496: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0xdaace000  ! 4497: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 4498: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabfa000  ! 4499: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdaf7e000  ! 4500: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xda9609e0  ! 4501: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r13
	mov	0x0, %r19
	.word 0xd8af0e40  ! 4503: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	wr_tick_cmpr_2_48:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc1, %g2
	or	%g4, 0xfb, %g4
	or	%g6, 0xf9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdccf6000  ! 4505: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xd8f7ce60  ! 4506: STXA_R	stxa	%r12, [%r31 + %r0] 0x73
	.word 0x87802020  ! 4507: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4508: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ae2000  ! 4509: STBA_I	stba	%r11, [%r24 + 0x0000] %asi
	.word 0xd2b70e80  ! 4510: STHA_R	stha	%r9, [%r28 + %r0] 0x74
	.word 0xdcd44400  ! 4511: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	mov	0x50, %r16
	mov	0x28, %r16
	.word 0xd6b66000  ! 4514: STHA_I	stha	%r11, [%r25 + 0x0000] %asi
	.word 0xd6ce6000  ! 4515: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r11
	mov	0x28, %r17
	.word 0xdea6c9e0  ! 4517: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	.word 0xd4a7ce60  ! 4518: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	.word 0x87802020  ! 4519: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4520: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4521: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8e89e0  ! 4522: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r15
	mov	0x20, %r24
	.word 0xdabc6000  ! 4524: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 4525: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2cd84a0  ! 4526: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r9
	.word 0x87802073  ! 4527: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b42000  ! 4528: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	.word 0xd49dc4a0  ! 4529: LDDA_R	ldda	[%r23, %r0] 0x25, %r10
	mov	0x68, %r18
	.word 0xd4c689e0  ! 4531: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r10
	mov	0x3c8, %r22
	.word 0xd8d5c4a0  ! 4533: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r12
	.word 0xdc842000  ! 4534: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	.word 0xdadcc400  ! 4535: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xdcd4a000  ! 4536: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	mov	0x50, %r17
	.word 0xdcb46000  ! 4538: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 4539: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9f4e80  ! 4540: LDDA_R	ldda	[%r29, %r0] 0x74, %r13
	.word 0xd8a78e60  ! 4541: STWA_R	stwa	%r12, [%r30 + %r0] 0x73
	.word 0xd4dec9e0  ! 4542: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r10
	.word 0xd8a584a0  ! 4543: STWA_R	stwa	%r12, [%r22 + %r0] 0x25
	.word 0xd68c8400  ! 4544: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	.word 0xd6956000  ! 4545: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r11
	.word 0xd29c0400  ! 4546: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	.word 0xd48f4e40  ! 4547: LDUBA_R	lduba	[%r29, %r0] 0x72, %r10
	.word 0xdef5e000  ! 4548: STXA_I	stxa	%r15, [%r23 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x48, %r24
	mov	0x18, %r25
	.word 0xdef5a000  ! 4552: STXA_I	stxa	%r15, [%r22 + 0x0000] %asi
	mov	0x3e8, %r23
	.word 0xde9d2000  ! 4554: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r15
	.word 0xdecda000  ! 4555: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r15
	mov	0x8, %r18
	.word 0x87802074  ! 4557: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 4558: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdebc2000  ! 4559: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xdef46000  ! 4560: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xdcbe09e0  ! 4561: STDA_R	stda	%r14, [%r24 + %r0] 0x4f
	wr_tick_cmpr_2_49:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xbb, %g2
	or	%g4, 0xd5, %g4
	or	%g6, 0x98, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x8780204f  ! 4563: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebe2000  ! 4564: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	.word 0x87802025  ! 4565: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r26
	.word 0xd2a78e80  ! 4567: STWA_R	stwa	%r9, [%r30 + %r0] 0x74
	.word 0xd6ace000  ! 4568: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0xd0a48400  ! 4569: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0xdc9fce40  ! 4570: LDDA_R	ldda	[%r31, %r0] 0x72, %r14
	mov	0x3c8, %r21
	.word 0x87802025  ! 4572: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a52000  ! 4573: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	.word 0xd6952000  ! 4574: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r11
	.word 0x87802073  ! 4575: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6962000  ! 4576: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r11
	.word 0xd6966000  ! 4577: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r11
	.word 0xd6cea000  ! 4578: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	.word 0xd8f48400  ! 4579: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0x87802072  ! 4580: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b7ce40  ! 4581: STHA_R	stha	%r11, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 4582: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdab76000  ! 4583: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdaa7e000  ! 4584: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xdab76000  ! 4585: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdacf6000  ! 4586: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0x87802072  ! 4587: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2c7ce40  ! 4588: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r9
	.word 0xd29c2000  ! 4589: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	.word 0xd8ce49e0  ! 4590: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r12
	mov	0x3f0, %r21
	.word 0x87802073  ! 4592: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4a7a000  ! 4593: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	mov	0x70, %r19
	ta	T_CHANGE_HPRIV	! macro
	.word 0x8780204f  ! 4596: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r27
	mov	0x28, %r17
	.word 0xd4876000  ! 4599: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	mov	0x68, %r25
	.word 0xd4b76000  ! 4601: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xd8ac0400  ! 4603: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xd4bf0e60  ! 4604: STDA_R	stda	%r10, [%r28 + %r0] 0x73
	.word 0xdea74e80  ! 4605: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	mov	0x50, %r16
	.word 0x87802020  ! 4607: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dfce60  ! 4608: LDXA_R	ldxa	[%r31, %r0] 0x73, %r9
	.word 0xdaccc400  ! 4609: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r13
	.word 0xd2cca000  ! 4610: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	.word 0xd294e000  ! 4611: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	.word 0xdeaf0e40  ! 4612: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	.word 0x87802074  ! 4613: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a78e40  ! 4614: STWA_R	stwa	%r8, [%r30 + %r0] 0x72
	.word 0xdaa42000  ! 4615: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0xdca70e60  ! 4616: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	mov	0x60, %r27
	.word 0xd4f42000  ! 4618: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd4dca000  ! 4619: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	.word 0xd6f48400  ! 4620: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	mov	0x7f0, %r22
	.word 0xd4d6c9e0  ! 4622: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r10
	.word 0xdef7ce80  ! 4623: STXA_R	stxa	%r15, [%r31 + %r0] 0x74
	mov	0x7e0, %r23
	.word 0xd6a7ce80  ! 4625: STWA_R	stwa	%r11, [%r31 + %r0] 0x74
	.word 0xda9d04a0  ! 4626: LDDA_R	ldda	[%r20, %r0] 0x25, %r13
	mov	0x10, %r17
	.word 0xd09c2000  ! 4628: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r8
	.word 0xdaaf0e60  ! 4629: STBA_R	stba	%r13, [%r28 + %r0] 0x73
	.word 0xd4b42000  ! 4630: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4631: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r22
	mov	0x10, %r17
	mov	0x3d8, %r20
	.word 0xd4f66000  ! 4635: STXA_I	stxa	%r10, [%r25 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xd49e2000  ! 4637: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r10
	.word 0xd4b62000  ! 4638: STHA_I	stha	%r10, [%r24 + 0x0000] %asi
	.word 0xd4aee000  ! 4639: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	.word 0xd4b6e000  ! 4640: STHA_I	stha	%r10, [%r27 + 0x0000] %asi
	.word 0xd4b62000  ! 4641: STHA_I	stha	%r10, [%r24 + 0x0000] %asi
	.word 0xd4d6a000  ! 4642: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r10
	.word 0xdcbf8e40  ! 4643: STDA_R	stda	%r14, [%r30 + %r0] 0x72
	mov	0x30, %r18
	mov	0x8, %r25
	.word 0xdea62000  ! 4646: STWA_I	stwa	%r15, [%r24 + 0x0000] %asi
	.word 0xd4af8e60  ! 4647: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	.word 0x87802072  ! 4648: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebfa000  ! 4649: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xdadf0e40  ! 4650: LDXA_R	ldxa	[%r28, %r0] 0x72, %r13
	.word 0x87802074  ! 4651: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcdf4e60  ! 4652: LDXA_R	ldxa	[%r29, %r0] 0x73, %r14
	mov	0x48, %r25
	.word 0xdea6a000  ! 4654: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	.word 0xde9ea000  ! 4655: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r15
	.word 0xdebee000  ! 4656: STDA_I	stda	%r15, [%r27 + 0x0000] %asi
	.word 0xda9ec9e0  ! 4657: LDDA_R	ldda	[%r27, %r0] 0x4f, %r13
	.word 0xd2f4c400  ! 4658: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	mov	0x70, %r25
	.word 0x87802074  ! 4660: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6ac8400  ! 4661: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	mov	0x78, %r25
	mov	0x3c8, %r23
	.word 0x87802072  ! 4664: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r19
	mov	0x60, %r24
	.word 0x8780204f  ! 4667: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 4668: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8ce6000  ! 4669: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r12
	mov	0x7e8, %r22
	mov	0x40, %r18
	mov	0x40, %r25
	mov	0x38, %r16
	mov	0x28, %r26
	.word 0xd8f62000  ! 4675: STXA_I	stxa	%r12, [%r24 + 0x0000] %asi
	.word 0xd8c66000  ! 4676: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r12
	.word 0xd2be09e0  ! 4677: STDA_R	stda	%r9, [%r24 + %r0] 0x4f
	.word 0xdeae2000  ! 4678: STBA_I	stba	%r15, [%r24 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xdece2000  ! 4680: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r15
	.word 0xdec62000  ! 4681: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r15
	.word 0xdedea000  ! 4682: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r15
	.word 0xdeb6e000  ! 4683: STHA_I	stha	%r15, [%r27 + 0x0000] %asi
	mov	0x10, %r26
	.word 0x87802074  ! 4685: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdec7ce40  ! 4686: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r15
	mov	0x7d8, %r20
	.word 0xdc8c6000  ! 4688: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r14
	.word 0x87802072  ! 4689: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r19
	mov	0x50, %r24
	.word 0xdcbc6000  ! 4692: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	mov	0x8, %r19
	.word 0xdca42000  ! 4694: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	mov	0x28, %r19
	.word 0xdcd4e000  ! 4696: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	mov	0x50, %r19
	.word 0xda9e09e0  ! 4698: LDDA_R	ldda	[%r24, %r0] 0x4f, %r13
	.word 0xd4f4e000  ! 4699: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0xd4dc2000  ! 4700: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	.word 0xd49ca000  ! 4701: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 4702: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4c7a000  ! 4703: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	.word 0xdeac0400  ! 4704: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xd8a76000  ! 4705: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	mov	0x50, %r16
	.word 0x8780204f  ! 4707: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 4708: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r16
	mov	0x60, %r16
	mov	0x3f8, %r22
	.word 0xdeaf0e40  ! 4712: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	mov	0x3f8, %r20
	.word 0xd2b74e80  ! 4714: STHA_R	stha	%r9, [%r29 + %r0] 0x74
	.word 0xdc84a000  ! 4715: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	.word 0x87802074  ! 4716: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r16
	.word 0xd0a40400  ! 4718: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0xdaa544a0  ! 4719: STWA_R	stwa	%r13, [%r21 + %r0] 0x25
	.word 0xd4d46000  ! 4720: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r10
	mov	0x50, %r17
	.word 0xd8974e60  ! 4722: LDUHA_R	lduha	[%r29, %r0] 0x73, %r12
	.word 0xdcf4e000  ! 4723: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcf4e000  ! 4724: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xd2a70e40  ! 4725: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	mov	0x40, %r24
	.word 0xd4b74e40  ! 4727: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	mov	0x3c8, %r23
	.word 0xde870e40  ! 4729: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r15
	.word 0xded42000  ! 4730: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	.word 0xd89f8e80  ! 4731: LDDA_R	ldda	[%r30, %r0] 0x74, %r12
	.word 0xd2a649e0  ! 4732: STWA_R	stwa	%r9, [%r25 + %r0] 0x4f
	.word 0xd8d78e60  ! 4733: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r12
	.word 0xdef4e000  ! 4734: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xd6bec9e0  ! 4735: STDA_R	stda	%r11, [%r27 + %r0] 0x4f
	mov	0x20, %r17
	.word 0xd6d4e000  ! 4737: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r11
	.word 0xd6ac6000  ! 4738: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xd0d504a0  ! 4739: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r8
	.word 0xd2b74e60  ! 4740: STHA_R	stha	%r9, [%r29 + %r0] 0x73
	mov	0x78, %r16
	.word 0xdc840400  ! 4742: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	.word 0xd4d42000  ! 4743: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	mov	0x10, %r17
	.word 0xd4a46000  ! 4745: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xd4840400  ! 4746: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	.word 0xdea4e000  ! 4747: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	mov	0x18, %r19
	.word 0xde9c2000  ! 4749: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xd6c689e0  ! 4750: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r11
	.word 0xd8d4a000  ! 4751: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	mov	0x60, %r26
	mov	0x3d8, %r21
	.word 0xd8c46000  ! 4754: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r12
	.word 0xd8aca000  ! 4755: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0xde9c0400  ! 4756: LDDA_R	ldda	[%r16, %r0] 0x20, %r15
	.word 0xde9ce000  ! 4757: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0x87802073  ! 4758: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a4c400  ! 4759: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xd0a46000  ! 4760: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xd69fce60  ! 4761: LDDA_R	ldda	[%r31, %r0] 0x73, %r11
	mov	0x7f0, %r22
	mov	0x50, %r17
	mov	0x70, %r19
	.word 0xd8ac6000  ! 4765: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xd8d4a000  ! 4766: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xd09c0400  ! 4767: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	mov	0x20, %r18
	.word 0xdacce000  ! 4769: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r13
	.word 0xda8c2000  ! 4770: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r13
	.word 0xdabc2000  ! 4771: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4772: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea609e0  ! 4773: STWA_R	stwa	%r15, [%r24 + %r0] 0x4f
	.word 0xd2afe000  ! 4774: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 4775: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd297e000  ! 4776: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	.word 0xd2f76000  ! 4777: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xd2f7a000  ! 4778: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 4779: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2be6000  ! 4780: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	.word 0xd2b62000  ! 4781: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	mov	0x48, %r16
	.word 0x87802074  ! 4783: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bce000  ! 4784: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	mov	0x3d0, %r21
	.word 0xd0b7ce60  ! 4786: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	.word 0xd894e000  ! 4787: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r12
	.word 0xd8b4e000  ! 4788: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0xd2a70e60  ! 4789: STWA_R	stwa	%r9, [%r28 + %r0] 0x73
	.word 0xd494c400  ! 4790: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	.word 0xdc9584a0  ! 4791: LDUHA_R	lduha	[%r22, %r0] 0x25, %r14
	.word 0x87802025  ! 4792: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebcc400  ! 4793: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	.word 0xd29e49e0  ! 4794: LDDA_R	ldda	[%r25, %r0] 0x4f, %r9
	.word 0xd6a584a0  ! 4795: STWA_R	stwa	%r11, [%r22 + %r0] 0x25
	.word 0xdc974e80  ! 4796: LDUHA_R	lduha	[%r29, %r0] 0x74, %r14
	mov	0x7c8, %r20
	.word 0xdaf4e000  ! 4798: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	mov	0x7c0, %r21
	.word 0xd2a48400  ! 4800: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	mov	0x3d0, %r23
	mov	0x7d0, %r23
	.word 0xd0c4a000  ! 4803: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	mov	0x3c0, %r23
	.word 0xd0bc6000  ! 4805: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 4806: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bf0e60  ! 4807: STDA_R	stda	%r10, [%r28 + %r0] 0x73
	.word 0xd48f8e40  ! 4808: LDUBA_R	lduba	[%r30, %r0] 0x72, %r10
	.word 0xd4cda000  ! 4809: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r10
	.word 0xd4a5e000  ! 4810: STWA_I	stwa	%r10, [%r23 + 0x0000] %asi
	.word 0xda8dc4a0  ! 4811: LDUBA_R	lduba	[%r23, %r0] 0x25, %r13
	.word 0x87802020  ! 4812: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8ce000  ! 4813: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	mov	0x58, %r26
	.word 0xd68f0e40  ! 4815: LDUBA_R	lduba	[%r28, %r0] 0x72, %r11
	.word 0xd8946000  ! 4816: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	mov	0x7e8, %r20
	.word 0xd4cec9e0  ! 4818: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r10
	.word 0xd8aca000  ! 4819: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0xdcf78e80  ! 4820: STXA_R	stxa	%r14, [%r30 + %r0] 0x74
	mov	0x7f0, %r20
	mov	0x18, %r16
	mov	0x48, %r16
	.word 0xde94a000  ! 4824: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0x87802074  ! 4825: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6acc400  ! 4826: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xd8f70e40  ! 4827: STXA_R	stxa	%r12, [%r28 + %r0] 0x72
	mov	0x7c0, %r23
	.word 0x87802025  ! 4829: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2f584a0  ! 4830: STXA_R	stxa	%r9, [%r22 + %r0] 0x25
	.word 0xd4b78e40  ! 4831: STHA_R	stha	%r10, [%r30 + %r0] 0x72
	.word 0x87802072  ! 4832: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 4833: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 4834: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r17
	.word 0x87802073  ! 4836: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f5c4a0  ! 4837: STXA_R	stxa	%r12, [%r23 + %r0] 0x25
	mov	0x68, %r25
	.word 0xd484c400  ! 4839: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	mov	0x70, %r27
	.word 0x87802074  ! 4841: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 4842: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0dcc400  ! 4843: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0xd8afce80  ! 4844: STBA_R	stba	%r12, [%r31 + %r0] 0x74
	.word 0xdeaf8e60  ! 4845: STBA_R	stba	%r15, [%r30 + %r0] 0x73
	.word 0xd297e000  ! 4846: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 4847: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bf6000  ! 4848: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd0a504a0  ! 4849: STWA_R	stwa	%r8, [%r20 + %r0] 0x25
	.word 0x87802074  ! 4850: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0c5c4a0  ! 4851: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r8
	.word 0xd6f7e000  ! 4852: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd8f78e60  ! 4853: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	mov	0x3f8, %r20
	.word 0x87802020  ! 4855: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d56000  ! 4856: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r10
	.word 0xd4856000  ! 4857: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r10
	mov	0x0, %r16
	mov	0x48, %r24
	.word 0xd4f5a000  ! 4860: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	.word 0xd4a5e000  ! 4861: STWA_I	stwa	%r10, [%r23 + 0x0000] %asi
	.word 0xd0a689e0  ! 4862: STWA_R	stwa	%r8, [%r26 + %r0] 0x4f
	.word 0xd2bd2000  ! 4863: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 4864: WRASI_I	wr	%r0, 0x0073, %asi
	wr_tick_cmpr_2_50:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xce, %g2
	or	%g4, 0xc4, %g4
	or	%g6, 0xbd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8f48400  ! 4866: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xd4df2000  ! 4867: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	mov	0x10, %r16
	.word 0xd89f0e80  ! 4869: LDDA_R	ldda	[%r28, %r0] 0x74, %r12
	.word 0xde870e40  ! 4870: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r15
	mov	0x18, %r25
	.word 0xdea5c4a0  ! 4872: STWA_R	stwa	%r15, [%r23 + %r0] 0x25
	.word 0x87802020  ! 4873: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2948400  ! 4874: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	.word 0xd284a000  ! 4875: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	.word 0xdab7ce80  ! 4876: STHA_R	stha	%r13, [%r31 + %r0] 0x74
	.word 0xd6b46000  ! 4877: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xdef544a0  ! 4878: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	.word 0xd0c4a000  ! 4879: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	.word 0xdab70e40  ! 4880: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	.word 0x87802025  ! 4881: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f7e000  ! 4882: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 4883: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 4884: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ac4400  ! 4885: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xdcbf4e80  ! 4886: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	.word 0xdadc6000  ! 4887: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xdaace000  ! 4888: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0xda84a000  ! 4889: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	.word 0xda9c2000  ! 4890: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	.word 0xdaf42000  ! 4891: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0xdab42000  ! 4892: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0x87802073  ! 4894: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6dc0400  ! 4895: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	.word 0x87802073  ! 4896: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f66000  ! 4897: STXA_I	stxa	%r9, [%r25 + 0x0000] %asi
	.word 0xd2aea000  ! 4898: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0x87802073  ! 4899: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r19
	mov	0x3c8, %r22
	.word 0xdcf78e40  ! 4902: STXA_R	stxa	%r14, [%r30 + %r0] 0x72
	.word 0x87802020  ! 4903: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a7a000  ! 4904: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xdcad44a0  ! 4905: STBA_R	stba	%r14, [%r21 + %r0] 0x25
	.word 0xd497e000  ! 4906: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	.word 0xdecd44a0  ! 4907: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r15
	.word 0x87802025  ! 4908: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd69c4400  ! 4909: LDDA_R	ldda	[%r17, %r0] 0x20, %r11
	.word 0xdaaf4e80  ! 4910: STBA_R	stba	%r13, [%r29 + %r0] 0x74
	.word 0x87802073  ! 4911: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 4912: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4c5e000  ! 4913: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r10
	mov	0x3f0, %r23
	.word 0xd2ccc400  ! 4915: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	.word 0xd89f0e40  ! 4916: LDDA_R	ldda	[%r28, %r0] 0x72, %r12
	.word 0x87802072  ! 4917: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd494e000  ! 4918: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	.word 0xda8609e0  ! 4919: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r13
	mov	0x0, %r27
	.word 0xded4a000  ! 4921: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	.word 0xd8dc0400  ! 4922: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0xd4d4a000  ! 4923: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0xd4842000  ! 4924: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	.word 0xd6bec9e0  ! 4925: STDA_R	stda	%r11, [%r27 + %r0] 0x4f
	mov	0x3e0, %r21
	mov	0x50, %r18
	mov	0x30, %r16
	mov	0x3f8, %r22
	wr_tick_cmpr_2_51:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xcf, %g2
	or	%g4, 0xeb, %g4
	or	%g6, 0x86, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	wr_tick_cmpr_2_52:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x9c, %g2
	or	%g4, 0xb3, %g4
	or	%g6, 0xe4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7f8, %r21
	.word 0xdcb4a000  ! 4933: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xdc942000  ! 4934: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	mov	0x40, %r26
	.word 0xdcf4e000  ! 4936: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcf4a000  ! 4937: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcf4e000  ! 4938: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0xdcddc4a0  ! 4940: LDXA_R	ldxa	[%r23, %r0] 0x25, %r14
	.word 0xd8bce000  ! 4941: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 4942: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 4943: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd09e09e0  ! 4944: LDDA_R	ldda	[%r24, %r0] 0x4f, %r8
	mov	0x18, %r19
	.word 0xd8b7e000  ! 4946: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 4947: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef689e0  ! 4948: STXA_R	stxa	%r15, [%r26 + %r0] 0x4f
	mov	0x7d8, %r20
	mov	0x8, %r25
	.word 0xd0c4e000  ! 4951: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	.word 0xd0dc2000  ! 4952: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	mov	0x7c0, %r21
	mov	0x68, %r16
	.word 0xd4c689e0  ! 4955: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r10
	.word 0x87802074  ! 4956: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4df6000  ! 4957: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4c7e000  ! 4958: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	mov	0x48, %r17
	.word 0xd0dd84a0  ! 4960: LDXA_R	ldxa	[%r22, %r0] 0x25, %r8
	.word 0x87802020  ! 4961: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0c74e40  ! 4962: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r8
	.word 0xdaaf0e60  ! 4963: STBA_R	stba	%r13, [%r28 + %r0] 0x73
	mov	0x3e8, %r22
	.word 0x87802020  ! 4965: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a4e000  ! 4966: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xda8649e0  ! 4967: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r13
	mov	0x50, %r18
	.word 0xd0b4e000  ! 4969: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xd0d46000  ! 4970: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r8
	.word 0x87802074  ! 4971: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0cc0400  ! 4972: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xd4d42000  ! 4973: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	.word 0xd2bfce40  ! 4974: STDA_R	stda	%r9, [%r31 + %r0] 0x72
	.word 0xd0a4e000  ! 4975: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 4976: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f44400  ! 4977: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xdaafe000  ! 4978: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xdabfe000  ! 4979: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xdaafe000  ! 4980: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	mov	0x7f8, %r22
	.word 0xdeb544a0  ! 4982: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	.word 0xdcaf2000  ! 4983: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdca544a0  ! 4984: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0xd6cf4e40  ! 4985: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r11
	.word 0xd6ac0400  ! 4986: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0xdabfe000  ! 4987: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	mov	0x78, %r18
	mov	0x50, %r26
	.word 0x8780204f  ! 4990: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r18
	.word 0xda9fa000  ! 4992: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xdab7a000  ! 4993: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 4994: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda9c2000  ! 4995: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	mov	0x18, %r25
	.word 0x87802072  ! 4997: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc848400  ! 4998: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	mov	0x50, %r18
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_1:
	wr_tick_cmpr_1_0:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc6, %g2
	or	%g4, 0xfe, %g4
	or	%g6, 0x9b, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdacfa000  ! 1: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xd8cc0400  ! 2: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	mov	0x0, %r24
	.word 0xd0b7e000  ! 4: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 5: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4974e40  ! 6: LDUHA_R	lduha	[%r29, %r0] 0x72, %r10
	.word 0x87802074  ! 7: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 8: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r17
	.word 0xd4f4e000  ! 10: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0xd49ce000  ! 11: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0xd4946000  ! 12: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r10
	.word 0xd4bca000  ! 13: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	mov	0x10, %r19
	.word 0xd4cca000  ! 15: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r10
	.word 0xd68dc4a0  ! 16: LDUBA_R	lduba	[%r23, %r0] 0x25, %r11
	.word 0xd2b48400  ! 17: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd8846000  ! 18: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	.word 0xda9fce60  ! 19: LDDA_R	ldda	[%r31, %r0] 0x73, %r13
	.word 0xd0cec9e0  ! 20: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r8
	.word 0xd6b4a000  ! 21: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd8c504a0  ! 22: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r12
	mov	0x70, %r18
	mov	0x28, %r16
	.word 0xd0f7ce60  ! 25: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	mov	0x3d0, %r20
	.word 0xd4b74e80  ! 27: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	.word 0xd6f4e000  ! 28: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	.word 0xdaaec9e0  ! 29: STBA_R	stba	%r13, [%r27 + %r0] 0x4f
	mov	0x28, %r16
	.word 0xdad4e000  ! 31: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r13
	mov	0x58, %r27
	.word 0xdabc2000  ! 33: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xdaf42000  ! 34: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xd0a7ce60  ! 36: STWA_R	stwa	%r8, [%r31 + %r0] 0x73
	.word 0xd2a4e000  ! 37: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	mov	0x18, %r18
	.word 0xd2b4e000  ! 39: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0xd6c5c4a0  ! 40: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r11
	.word 0xd4bce000  ! 41: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0xd4b42000  ! 42: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	mov	0x7f8, %r20
	mov	0x78, %r16
	.word 0xd4a4e000  ! 45: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 46: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdad44400  ! 47: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0xd0940400  ! 48: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	.word 0xd6b78e60  ! 49: STHA_R	stha	%r11, [%r30 + %r0] 0x73
	.word 0xd8af4e80  ! 50: STBA_R	stba	%r12, [%r29 + %r0] 0x74
	mov	0x50, %r25
	.word 0xd8f40400  ! 52: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xd4df0e60  ! 53: LDXA_R	ldxa	[%r28, %r0] 0x73, %r10
	mov	0x10, %r16
	.word 0xdaa52000  ! 55: STWA_I	stwa	%r13, [%r20 + 0x0000] %asi
	.word 0xdaf52000  ! 56: STXA_I	stxa	%r13, [%r20 + 0x0000] %asi
	.word 0xdabd2000  ! 57: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 58: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdadfe000  ! 59: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0xdab7e000  ! 60: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xd6974e80  ! 61: LDUHA_R	lduha	[%r29, %r0] 0x74, %r11
	.word 0xd6a78e40  ! 62: STWA_R	stwa	%r11, [%r30 + %r0] 0x72
	.word 0xd4f48400  ! 63: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xd6dfe000  ! 64: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6afe000  ! 65: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x7c8, %r23
	mov	0x3c0, %r23
	.word 0xd4f74e40  ! 68: STXA_R	stxa	%r10, [%r29 + %r0] 0x72
	mov	0x3e8, %r22
	.word 0xd8972000  ! 70: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	mov	0x7e0, %r22
	.word 0xd8f7a000  ! 72: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8cfe000  ! 73: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xd89fe000  ! 74: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	mov	0x3e0, %r20
	.word 0x87802073  ! 76: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r26
	.word 0xd8d5a000  ! 78: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r12
	.word 0xd48f0e60  ! 79: LDUBA_R	lduba	[%r28, %r0] 0x73, %r10
	mov	0x10, %r19
	.word 0x87802020  ! 81: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r24
	.word 0xd4be6000  ! 83: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0x87802074  ! 84: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r16
	mov	0x0, %r18
	.word 0xd8a649e0  ! 87: STWA_R	stwa	%r12, [%r25 + %r0] 0x4f
	.word 0xd2f4c400  ! 88: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0x87802073  ! 89: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8a544a0  ! 90: STWA_R	stwa	%r12, [%r21 + %r0] 0x25
	.word 0xd09e09e0  ! 91: LDDA_R	ldda	[%r24, %r0] 0x4f, %r8
	mov	0x30, %r18
	.word 0xd6cf2000  ! 93: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	wr_tick_cmpr_1_1:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xad, %g2
	or	%g4, 0xcf, %g4
	or	%g6, 0xeb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x8780204f  ! 95: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f46000  ! 96: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0xd6cc6000  ! 97: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r11
	.word 0xd0dcc400  ! 98: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0xd2a40400  ! 99: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	mov	0x7e0, %r22
	.word 0xde94e000  ! 101: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	.word 0xdeace000  ! 102: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xd2f74e60  ! 103: STXA_R	stxa	%r9, [%r29 + %r0] 0x73
	mov	0x7c0, %r23
	.word 0xdc87ce60  ! 105: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r14
	.word 0xd0ac2000  ! 106: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 107: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r25
	.word 0x87802020  ! 109: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b70e40  ! 110: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	.word 0xd2f74e80  ! 111: STXA_R	stxa	%r9, [%r29 + %r0] 0x74
	.word 0xd8c74e60  ! 112: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r12
	.word 0xd8cf0e60  ! 113: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r12
	.word 0x87802073  ! 114: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 115: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8fa000  ! 116: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	mov	0x70, %r19
	.word 0xdab689e0  ! 118: STHA_R	stha	%r13, [%r26 + %r0] 0x4f
	mov	0x3d0, %r21
	mov	0x18, %r19
	.word 0xd48fa000  ! 121: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xded70e40  ! 122: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r15
	.word 0xd2cfa000  ! 123: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	mov	0x58, %r18
	.word 0xd8ddc4a0  ! 125: LDXA_R	ldxa	[%r23, %r0] 0x25, %r12
	.word 0xdcb48400  ! 126: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xd4f7e000  ! 127: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4b72000  ! 128: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd4b7a000  ! 130: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd6bf0e40  ! 131: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	.word 0xd4ce09e0  ! 132: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r10
	.word 0x87802020  ! 133: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48649e0  ! 134: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r10
	.word 0xd2f72000  ! 135: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd0f4c400  ! 136: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0xd8bc4400  ! 137: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	mov	0x3f0, %r20
	.word 0xd8c76000  ! 139: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8a7a000  ! 140: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 141: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8afe000  ! 142: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd8afa000  ! 143: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	mov	0x70, %r27
	.word 0xda8cc400  ! 145: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	.word 0xd6bc4400  ! 146: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	.word 0xd2a70e60  ! 147: STWA_R	stwa	%r9, [%r28 + %r0] 0x73
	.word 0xdc940400  ! 148: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0x87802073  ! 149: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 150: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b72000  ! 151: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 152: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bde000  ! 153: STDA_I	stda	%r8, [%r23 + 0x0000] %asi
	.word 0x87802073  ! 154: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 155: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f4a000  ! 156: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xd48f4e80  ! 157: LDUBA_R	lduba	[%r29, %r0] 0x74, %r10
	.word 0xd2cc2000  ! 158: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r9
	.word 0xd8b74e40  ! 159: STHA_R	stha	%r12, [%r29 + %r0] 0x72
	mov	0x20, %r24
	mov	0x3c8, %r20
	.word 0xdcac4400  ! 162: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	.word 0xdc9e49e0  ! 163: LDDA_R	ldda	[%r25, %r0] 0x4f, %r14
	.word 0x87802020  ! 164: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 165: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 166: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a72000  ! 167: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	mov	0x58, %r17
	mov	0x30, %r24
	mov	0x20, %r17
	.word 0x87802074  ! 171: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r18
	mov	0x18, %r19
	.word 0xdab6c9e0  ! 174: STHA_R	stha	%r13, [%r27 + %r0] 0x4f
	.word 0xda878e40  ! 175: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r13
	.word 0xd0cd6000  ! 176: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r8
	.word 0xd0bde000  ! 177: STDA_I	stda	%r8, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 178: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b72000  ! 179: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	mov	0x58, %r27
	.word 0x87802020  ! 181: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8afce60  ! 182: STBA_R	stba	%r12, [%r31 + %r0] 0x73
	.word 0xd6bfce60  ! 183: STDA_R	stda	%r11, [%r31 + %r0] 0x73
	.word 0x87802020  ! 184: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r18
	.word 0x8780204f  ! 186: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4dee000  ! 187: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r10
	.word 0xd4d6a000  ! 188: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r10
	.word 0xd6c609e0  ! 189: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r11
	mov	0x7e8, %r22
	.word 0x87802020  ! 191: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f7a000  ! 192: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 193: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d8, %r22
	.word 0xd4b7ce80  ! 195: STHA_R	stha	%r10, [%r31 + %r0] 0x74
	.word 0x87802020  ! 196: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8df8e60  ! 197: LDXA_R	ldxa	[%r30, %r0] 0x73, %r12
	.word 0xdef6e000  ! 198: STXA_I	stxa	%r15, [%r27 + 0x0000] %asi
	.word 0xd8dfce60  ! 199: LDXA_R	ldxa	[%r31, %r0] 0x73, %r12
	.word 0xd6cf8e40  ! 200: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r11
	.word 0xd2c70e80  ! 201: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r9
	.word 0xdc8ea000  ! 202: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r14
	.word 0x87802074  ! 203: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcdf6000  ! 204: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xdc872000  ! 205: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0x87802073  ! 206: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r19
	.word 0xdcf40400  ! 208: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xd8d609e0  ! 209: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r12
	.word 0x87802073  ! 210: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4afce40  ! 211: STBA_R	stba	%r10, [%r31 + %r0] 0x72
	.word 0xd684c400  ! 212: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	.word 0xdcd649e0  ! 213: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r14
	.word 0x87802020  ! 214: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c48400  ! 215: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r10
	.word 0x87802025  ! 216: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8c6a000  ! 217: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r12
	.word 0xdab78e60  ! 218: STHA_R	stha	%r13, [%r30 + %r0] 0x73
	.word 0x87802074  ! 219: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 220: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdad4a000  ! 221: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0x87802025  ! 222: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r17
	.word 0xdac7a000  ! 224: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xd8ccc400  ! 225: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r12
	.word 0xdaf4c400  ! 226: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xd4f7e000  ! 227: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	mov	0x7e0, %r22
	.word 0xdedf4e40  ! 229: LDXA_R	ldxa	[%r29, %r0] 0x72, %r15
	.word 0xd6bcc400  ! 230: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0xd4dfa000  ! 231: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd6948400  ! 232: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	.word 0xd2b72000  ! 233: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 234: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r25
	.word 0xd6dc0400  ! 236: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	.word 0xd4d7ce60  ! 237: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r10
	.word 0xdc9fa000  ! 238: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 239: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r26
	mov	0x7d0, %r20
	mov	0x7e0, %r21
	.word 0xdccf6000  ! 243: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcf7e000  ! 244: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xd0974e40  ! 245: LDUHA_R	lduha	[%r29, %r0] 0x72, %r8
	.word 0xd8872000  ! 246: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	mov	0x78, %r19
	.word 0xd8d7a000  ! 248: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0xd8dfe000  ! 249: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	mov	0x7e0, %r23
	.word 0x8780204f  ! 251: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 252: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8aee000  ! 253: STBA_I	stba	%r12, [%r27 + 0x0000] %asi
	.word 0xd8de6000  ! 254: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r12
	mov	0x28, %r16
	.word 0xd6a5c4a0  ! 256: STWA_R	stwa	%r11, [%r23 + %r0] 0x25
	.word 0xdcbf0e80  ! 257: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	.word 0x87802020  ! 258: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ac0400  ! 259: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	mov	0x7c0, %r22
	.word 0xdcbf6000  ! 261: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xd6f7ce40  ! 262: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	.word 0xdccf6000  ! 263: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdedc8400  ! 264: LDXA_R	ldxa	[%r18, %r0] 0x20, %r15
	mov	0x40, %r24
	.word 0x87802025  ! 266: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d8, %r20
	mov	0x48, %r19
	.word 0xd6cc6000  ! 269: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r11
	.word 0xd2be49e0  ! 270: STDA_R	stda	%r9, [%r25 + %r0] 0x4f
	.word 0x87802072  ! 271: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f504a0  ! 272: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	mov	0x60, %r16
	.word 0x87802025  ! 274: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 275: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69fa000  ! 276: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0xd6af2000  ! 277: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xd4df8e60  ! 279: LDXA_R	ldxa	[%r30, %r0] 0x73, %r10
	.word 0xd2cf0e60  ! 280: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r9
	.word 0xd68f2000  ! 281: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xda9d04a0  ! 282: LDDA_R	ldda	[%r20, %r0] 0x25, %r13
	.word 0xd8df6000  ! 283: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 284: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a76000  ! 285: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8dfa000  ! 286: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8d76000  ! 287: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	mov	0x3f8, %r20
	wr_tick_cmpr_1_2:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xfa, %g2
	or	%g4, 0xa2, %g4
	or	%g6, 0xfc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8b7e000  ! 290: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 291: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8dea000  ! 292: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r12
	.word 0x87802020  ! 293: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d78e80  ! 294: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r9
	.word 0x87802073  ! 295: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdebc0400  ! 296: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0xdcb70e60  ! 297: STHA_R	stha	%r14, [%r28 + %r0] 0x73
	.word 0xd6b70e40  ! 298: STHA_R	stha	%r11, [%r28 + %r0] 0x72
	.word 0xd8b689e0  ! 299: STHA_R	stha	%r12, [%r26 + %r0] 0x4f
	.word 0x87802072  ! 300: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b48400  ! 301: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd4b7e000  ! 302: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd4cf2000  ! 303: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4976000  ! 304: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r10
	.word 0xdca78e80  ! 305: STWA_R	stwa	%r14, [%r30 + %r0] 0x74
	mov	0x18, %r18
	.word 0xd6a72000  ! 307: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	mov	0x0, %r24
	.word 0xd29689e0  ! 309: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r9
	.word 0xd487ce40  ! 310: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r10
	.word 0x87802020  ! 311: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 312: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdef48400  ! 313: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xdad76000  ! 314: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0xda872000  ! 315: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0xd2b4c400  ! 316: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0x87802025  ! 317: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcdfce60  ! 318: LDXA_R	ldxa	[%r31, %r0] 0x73, %r14
	.word 0x87802020  ! 319: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r19
	.word 0xdcc649e0  ! 321: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r14
	.word 0xdea76000  ! 322: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 323: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde94e000  ! 324: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	mov	0x3d8, %r23
	mov	0x50, %r19
	mov	0x8, %r26
	mov	0x3e8, %r20
	.word 0xdccf8e60  ! 329: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r14
	.word 0x87802073  ! 330: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd09d6000  ! 331: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r8
	.word 0xd2b689e0  ! 332: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	.word 0xd6b5e000  ! 333: STHA_I	stha	%r11, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 334: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6c4a000  ! 335: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r11
	.word 0xdcf44400  ! 336: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0x87802073  ! 337: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8af2000  ! 338: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xd8b72000  ! 339: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0x87802073  ! 341: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r26
	mov	0x3c0, %r23
	.word 0xd8dc2000  ! 344: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0xdedc4400  ! 345: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	.word 0xd8ace000  ! 346: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0xd08dc4a0  ! 348: LDUBA_R	lduba	[%r23, %r0] 0x25, %r8
	.word 0xd6a46000  ! 349: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0xd6bc6000  ! 350: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0xd4bec9e0  ! 351: STDA_R	stda	%r10, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 352: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa76000  ! 353: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	mov	0x3d0, %r21
	.word 0x87802074  ! 355: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r27
	.word 0xdabc4400  ! 357: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xdedf8e40  ! 358: LDXA_R	ldxa	[%r30, %r0] 0x72, %r15
	.word 0x87802072  ! 359: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r25
	mov	0x28, %r19
	mov	0x7c0, %r20
	.word 0xdcb649e0  ! 363: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	.word 0xda9c6000  ! 364: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	mov	0x3f0, %r22
	mov	0x3f8, %r21
	.word 0x87802020  ! 367: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b48400  ! 368: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd0af4e80  ! 369: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	.word 0xd0bf4e60  ! 370: STDA_R	stda	%r8, [%r29 + %r0] 0x73
	.word 0xd4bd04a0  ! 371: STDA_R	stda	%r10, [%r20 + %r0] 0x25
	mov	0x7f0, %r21
	.word 0xd6a56000  ! 373: STWA_I	stwa	%r11, [%r21 + 0x0000] %asi
	.word 0xd8cd44a0  ! 374: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r12
	.word 0xd0dd44a0  ! 375: LDXA_R	ldxa	[%r21, %r0] 0x25, %r8
	.word 0xd2cc0400  ! 376: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r9
	.word 0xd2cda000  ! 377: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r9
	mov	0x30, %r24
	.word 0xd2ad6000  ! 379: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	mov	0x0, %r24
	.word 0xd48c0400  ! 381: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	.word 0xd09d04a0  ! 382: LDDA_R	ldda	[%r20, %r0] 0x25, %r8
	mov	0x38, %r18
	ta	T_CHANGE_NONPRIV	! macro
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdaf5a000  ! 386: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xdadda000  ! 387: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r13
	.word 0x87802072  ! 388: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc8544a0  ! 389: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r14
	.word 0x87802073  ! 390: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2df2000  ! 391: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2bfe000  ! 392: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	mov	0x8, %r16
	.word 0xd2cf6000  ! 394: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	wr_tick_cmpr_1_3:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf7, %g2
	or	%g4, 0xcc, %g4
	or	%g6, 0xff, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 396: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f7e000  ! 397: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xde84c400  ! 398: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	mov	0x48, %r24
	mov	0x18, %r17
	.word 0xd6af6000  ! 401: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd68f8e40  ! 402: LDUBA_R	lduba	[%r30, %r0] 0x72, %r11
	.word 0xdef78e80  ! 403: STXA_R	stxa	%r15, [%r30 + %r0] 0x74
	mov	0x3f8, %r21
	.word 0xdebfe000  ! 405: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xd48649e0  ! 406: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r10
	mov	0x7d0, %r20
	mov	0x7f8, %r20
	.word 0xdc97a000  ! 409: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	.word 0xdc96c9e0  ! 410: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r14
	.word 0x87802073  ! 411: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2bd44a0  ! 412: STDA_R	stda	%r9, [%r21 + %r0] 0x25
	.word 0xda9f0e80  ! 413: LDDA_R	ldda	[%r28, %r0] 0x74, %r13
	mov	0x18, %r16
	mov	0x78, %r26
	mov	0x7d8, %r20
	mov	0x48, %r17
	.word 0x87802074  ! 418: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 419: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa7ce40  ! 420: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	.word 0x87802072  ! 421: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4c4e000  ! 422: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r10
	.word 0xd2bc4400  ! 423: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0xd4cf0e80  ! 424: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r10
	.word 0xd4a46000  ! 425: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xd0a504a0  ! 426: STWA_R	stwa	%r8, [%r20 + %r0] 0x25
	.word 0x87802020  ! 427: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r23
	.word 0xd2f544a0  ! 429: STXA_R	stxa	%r9, [%r21 + %r0] 0x25
	.word 0xd8af2000  ! 430: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 431: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r16
	.word 0x87802020  ! 433: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r18
	.word 0xd8ad6000  ! 435: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	.word 0x87802025  ! 436: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r17
	.word 0xd8b7a000  ! 438: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	mov	0x38, %r26
	.word 0xd897a000  ! 440: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0xdedd04a0  ! 441: LDXA_R	ldxa	[%r20, %r0] 0x25, %r15
	.word 0x87802073  ! 442: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbde000  ! 443: STDA_I	stda	%r14, [%r23 + 0x0000] %asi
	.word 0xdc8da000  ! 444: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r14
	.word 0xd4ae49e0  ! 445: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0xd88de000  ! 446: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r12
	.word 0xd8cda000  ! 447: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r12
	mov	0x7e0, %r23
	.word 0xd0bdc4a0  ! 449: STDA_R	stda	%r8, [%r23 + %r0] 0x25
	.word 0xdca40400  ! 450: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xd2f7ce40  ! 451: STXA_R	stxa	%r9, [%r31 + %r0] 0x72
	mov	0x7d8, %r23
	.word 0x87802074  ! 453: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabfa000  ! 454: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xd88f4e40  ! 455: LDUBA_R	lduba	[%r29, %r0] 0x72, %r12
	.word 0xdcd44400  ! 456: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	.word 0xd6b72000  ! 457: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xdeb544a0  ! 458: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	.word 0xdacd84a0  ! 459: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r13
	.word 0xda9f8e60  ! 460: LDDA_R	ldda	[%r30, %r0] 0x73, %r13
	mov	0x40, %r27
	.word 0xd4f7e000  ! 462: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 463: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a7a000  ! 464: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4a7e000  ! 465: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd49fa000  ! 466: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0xd4a76000  ! 467: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4d72000  ! 468: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	.word 0xde9dc4a0  ! 469: LDDA_R	ldda	[%r23, %r0] 0x25, %r15
	.word 0x87802025  ! 470: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd68f8e80  ! 471: LDUBA_R	lduba	[%r30, %r0] 0x74, %r11
	.word 0xd6a7a000  ! 472: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd2cc4400  ! 473: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r9
	mov	0x70, %r24
	.word 0xd2bfe000  ! 475: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd28f2000  ! 477: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	.word 0xd68609e0  ! 478: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r11
	.word 0xda87a000  ! 479: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	mov	0x50, %r16
	.word 0xd8b544a0  ! 481: STHA_R	stha	%r12, [%r21 + %r0] 0x25
	.word 0xdadf6000  ! 482: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	mov	0x30, %r25
	.word 0xda87a000  ! 484: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0xd2a7ce80  ! 485: STWA_R	stwa	%r9, [%r31 + %r0] 0x74
	mov	0x50, %r19
	.word 0xd8c7a000  ! 487: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xdcad04a0  ! 488: STBA_R	stba	%r14, [%r20 + %r0] 0x25
	.word 0xdef584a0  ! 489: STXA_R	stxa	%r15, [%r22 + %r0] 0x25
	.word 0xd8a72000  ! 490: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 491: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 492: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r17
	.word 0xd8bf6000  ! 494: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd8c72000  ! 495: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd6c609e0  ! 496: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r11
	.word 0xdea7a000  ! 497: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xdedf2000  ! 498: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xd4c74e40  ! 499: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r10
	.word 0xd29f2000  ! 500: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd2dfa000  ! 501: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0x87802072  ! 502: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r26
	.word 0xd2ade000  ! 504: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0xdeddc4a0  ! 505: LDXA_R	ldxa	[%r23, %r0] 0x25, %r15
	.word 0xd8a56000  ! 506: STWA_I	stwa	%r12, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 507: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 508: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8a4a000  ! 509: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 510: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8b689e0  ! 511: STHA_R	stha	%r12, [%r26 + %r0] 0x4f
	.word 0xd0d4e000  ! 512: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	.word 0xd0d42000  ! 513: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r8
	.word 0xd09ca000  ! 514: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	.word 0x87802073  ! 515: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0f4a000  ! 516: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xd0d4a000  ! 517: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	.word 0xd68cc400  ! 518: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	mov	0x7e8, %r22
	.word 0xd49d04a0  ! 520: LDDA_R	ldda	[%r20, %r0] 0x25, %r10
	mov	0x30, %r16
	.word 0xde878e80  ! 522: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r15
	.word 0x87802072  ! 523: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde87a000  ! 524: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	mov	0x7c0, %r21
	.word 0xdea7a000  ! 526: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xdeb78e40  ! 527: STHA_R	stha	%r15, [%r30 + %r0] 0x72
	.word 0xd6f4c400  ! 528: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0x87802020  ! 529: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa74e40  ! 530: STWA_R	stwa	%r13, [%r29 + %r0] 0x72
	.word 0xdc8544a0  ! 531: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r14
	.word 0xda97e000  ! 532: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	.word 0xda876000  ! 533: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0xde9689e0  ! 534: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r15
	mov	0x68, %r16
	.word 0xd4bd84a0  ! 536: STDA_R	stda	%r10, [%r22 + %r0] 0x25
	.word 0xdeb76000  ! 537: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	mov	0x7f0, %r22
	mov	0x8, %r17
	.word 0xd6c689e0  ! 540: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r11
	.word 0xdcc44400  ! 541: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	mov	0x68, %r24
	.word 0xd6c76000  ! 543: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd8be89e0  ! 544: STDA_R	stda	%r12, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 545: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 546: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 547: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r24
	mov	0x30, %r16
	.word 0xdad56000  ! 550: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r13
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8d689e0  ! 552: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r12
	mov	0x3d8, %r23
	wr_tick_cmpr_1_4:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb9, %g2
	or	%g4, 0xe5, %g4
	or	%g6, 0xbd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802072  ! 555: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r24
	.word 0xd495e000  ! 557: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 558: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r16
	.word 0xdaa74e80  ! 560: STWA_R	stwa	%r13, [%r29 + %r0] 0x74
	.word 0xdc872000  ! 561: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcd609e0  ! 562: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r14
	.word 0xd2d609e0  ! 563: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r9
	mov	0x10, %r25
	.word 0xd6b72000  ! 565: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	mov	0x3d8, %r21
	.word 0xdccd44a0  ! 567: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r14
	.word 0xd8f544a0  ! 568: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	.word 0xdcd40400  ! 569: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	mov	0x7d0, %r22
	.word 0x87802074  ! 571: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3f0, %r23
	.word 0xdebf0e60  ! 573: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	mov	0x10, %r19
	.word 0x87802020  ! 575: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcac6000  ! 576: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 577: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 578: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4dc0400  ! 579: LDXA_R	ldxa	[%r16, %r0] 0x20, %r10
	.word 0xd0c584a0  ! 580: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r8
	.word 0x87802020  ! 581: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd284a000  ! 582: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	.word 0xd2cca000  ! 583: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 584: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 585: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2dfa000  ! 586: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xdebe89e0  ! 587: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	.word 0xd0adc4a0  ! 588: STBA_R	stba	%r8, [%r23 + %r0] 0x25
	.word 0xd4f40400  ! 589: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xdabf2000  ! 590: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xda8fe000  ! 591: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xd2c74e40  ! 592: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r9
	.word 0x87802020  ! 593: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0be09e0  ! 594: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0xd6c7a000  ! 595: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	.word 0xd0b7ce80  ! 596: STHA_R	stha	%r8, [%r31 + %r0] 0x74
	.word 0xd29fe000  ! 597: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd0bdc4a0  ! 598: STDA_R	stda	%r8, [%r23 + %r0] 0x25
	mov	0x7d8, %r20
	.word 0xd0afe000  ! 600: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	mov	0x20, %r26
	.word 0xd0f7a000  ! 602: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0d76000  ! 603: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xdcb70e40  ! 604: STHA_R	stha	%r14, [%r28 + %r0] 0x72
	mov	0x7e0, %r20
	.word 0x87802020  ! 606: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r16
	.word 0xd29f8e60  ! 608: LDDA_R	ldda	[%r30, %r0] 0x73, %r9
	.word 0x87802073  ! 609: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2a66000  ! 610: STWA_I	stwa	%r9, [%r25 + 0x0000] %asi
	mov	0x38, %r24
	.word 0xd4ac0400  ! 612: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xdea689e0  ! 613: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	.word 0xd88ee000  ! 614: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r12
	.word 0xd8bea000  ! 615: STDA_I	stda	%r12, [%r26 + 0x0000] %asi
	.word 0xd4d6c9e0  ! 616: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r10
	.word 0x87802073  ! 617: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc97ce40  ! 618: LDUHA_R	lduha	[%r31, %r0] 0x72, %r14
	mov	0x20, %r17
	.word 0x87802020  ! 620: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6dcc400  ! 621: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	.word 0xd4a62000  ! 622: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 623: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bf6000  ! 624: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd8acc400  ! 625: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0xd8c72000  ! 626: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	mov	0x3f0, %r23
	mov	0x50, %r17
	mov	0x10, %r17
	.word 0xd4a5c4a0  ! 630: STWA_R	stwa	%r10, [%r23 + %r0] 0x25
	mov	0x20, %r24
	mov	0x3f8, %r20
	mov	0x3d8, %r22
	.word 0x8780204f  ! 634: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r27
	mov	0x28, %r16
	.word 0xdace09e0  ! 637: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r13
	mov	0x3c0, %r21
	.word 0x87802072  ! 639: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f74e80  ! 640: STXA_R	stxa	%r10, [%r29 + %r0] 0x74
	.word 0xd2acc400  ! 641: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0xd6f46000  ! 642: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0xd6f4e000  ! 643: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 644: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6dc2000  ! 645: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r11
	.word 0xd69c6000  ! 646: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r11
	.word 0x87802074  ! 647: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b7ce80  ! 648: STHA_R	stha	%r8, [%r31 + %r0] 0x74
	mov	0x48, %r18
	.word 0xdebdc4a0  ! 650: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	.word 0xdcf78e60  ! 651: STXA_R	stxa	%r14, [%r30 + %r0] 0x73
	.word 0xda9c6000  ! 652: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	mov	0x0, %r18
	.word 0xda9ca000  ! 654: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	.word 0xda9ce000  ! 655: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r13
	.word 0xda942000  ! 656: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	mov	0x3f8, %r20
	.word 0x87802020  ! 658: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad72000  ! 659: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0xdcb78e60  ! 660: STHA_R	stha	%r14, [%r30 + %r0] 0x73
	.word 0xdcf7ce40  ! 661: STXA_R	stxa	%r14, [%r31 + %r0] 0x72
	.word 0xdebd44a0  ! 662: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	.word 0xd6a544a0  ! 663: STWA_R	stwa	%r11, [%r21 + %r0] 0x25
	mov	0x30, %r25
	.word 0x87802072  ! 665: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd695e000  ! 666: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r11
	.word 0xd6f5a000  ! 667: STXA_I	stxa	%r11, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 668: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdacd44a0  ! 669: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r13
	.word 0xd4c6e000  ! 670: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r10
	.word 0xd886c9e0  ! 671: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r12
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0ce6000  ! 673: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r8
	.word 0xd2b74e60  ! 674: STHA_R	stha	%r9, [%r29 + %r0] 0x73
	.word 0x87802020  ! 675: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r22
	.word 0xd2b46000  ! 677: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0xdcdc4400  ! 678: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	.word 0xd0a609e0  ! 679: STWA_R	stwa	%r8, [%r24 + %r0] 0x4f
	.word 0x87802074  ! 680: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r23
	.word 0x87802025  ! 682: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r25
	mov	0x38, %r16
	mov	0x30, %r24
	.word 0xdef76000  ! 686: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xd48609e0  ! 687: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r10
	.word 0xdebfe000  ! 688: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	mov	0x3f0, %r20
	.word 0xd09e49e0  ! 690: LDDA_R	ldda	[%r25, %r0] 0x4f, %r8
	.word 0xdecc8400  ! 691: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	.word 0x87802073  ! 692: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r25
	.word 0xdac584a0  ! 694: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r13
	.word 0xd6bfe000  ! 695: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd6976000  ! 696: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 697: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6846000  ! 698: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r11
	.word 0x87802073  ! 699: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd48d44a0  ! 700: LDUBA_R	lduba	[%r21, %r0] 0x25, %r10
	mov	0x7c0, %r20
	.word 0xd4b56000  ! 702: STHA_I	stha	%r10, [%r21 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xd8bc4400  ! 704: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	mov	0x38, %r26
	.word 0xd08f0e40  ! 706: LDUBA_R	lduba	[%r28, %r0] 0x72, %r8
	mov	0x18, %r19
	.word 0xd09c4400  ! 708: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	.word 0x87802073  ! 709: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f0, %r23
	.word 0x87802074  ! 711: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdad56000  ! 712: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r13
	.word 0xda8da000  ! 713: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r13
	.word 0xda85e000  ! 714: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	.word 0xdab5e000  ! 715: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0xda95e000  ! 716: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r13
	.word 0xd0bdc4a0  ! 717: STDA_R	stda	%r8, [%r23 + %r0] 0x25
	mov	0x10, %r17
	mov	0x3c0, %r22
	.word 0xd29f8e80  ! 720: LDDA_R	ldda	[%r30, %r0] 0x74, %r9
	mov	0x7d0, %r22
	.word 0xd0f5c4a0  ! 722: STXA_R	stxa	%r8, [%r23 + %r0] 0x25
	mov	0x78, %r24
	.word 0x87802020  ! 724: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r24
	mov	0x78, %r17
	mov	0x0, %r18
	.word 0xd8bc4400  ! 728: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0x87802020  ! 729: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b72000  ! 730: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xdaa504a0  ! 731: STWA_R	stwa	%r13, [%r20 + %r0] 0x25
	.word 0xd0976000  ! 732: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0a76000  ! 733: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0a72000  ! 734: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xd8ddc4a0  ! 736: LDXA_R	ldxa	[%r23, %r0] 0x25, %r12
	.word 0x87802020  ! 737: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r23
	mov	0x30, %r16
	.word 0xd0b74e80  ! 740: STHA_R	stha	%r8, [%r29 + %r0] 0x74
	.word 0xd0878e60  ! 741: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r8
	.word 0xd6d42000  ! 742: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r11
	.word 0xda9f4e80  ! 743: LDDA_R	ldda	[%r29, %r0] 0x74, %r13
	.word 0x87802025  ! 744: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 745: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r27
	.word 0x87802020  ! 747: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r21
	mov	0x50, %r27
	.word 0xd6f7e000  ! 750: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 751: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 752: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a62000  ! 753: STWA_I	stwa	%r11, [%r24 + 0x0000] %asi
	.word 0xd6ce2000  ! 754: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	.word 0xd6b6a000  ! 755: STHA_I	stha	%r11, [%r26 + 0x0000] %asi
	mov	0x28, %r24
	.word 0x87802072  ! 757: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6a7e000  ! 758: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xd4bd44a0  ! 759: STDA_R	stda	%r10, [%r21 + %r0] 0x25
	mov	0x28, %r25
	.word 0xdaafa000  ! 761: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xd8844400  ! 762: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r12
	.word 0x8780204f  ! 763: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf42000  ! 764: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0xdebe09e0  ! 766: STDA_R	stda	%r15, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 767: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b7a000  ! 768: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd0d76000  ! 769: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0c7e000  ! 770: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0xd6bf4e60  ! 771: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	.word 0xdebfe000  ! 772: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 773: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdecca000  ! 774: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	.word 0xd0b4c400  ! 775: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	mov	0x50, %r25
	.word 0x87802020  ! 777: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49fe000  ! 778: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xdedd44a0  ! 779: LDXA_R	ldxa	[%r21, %r0] 0x25, %r15
	.word 0xd2bfa000  ! 780: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 781: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2ad6000  ! 782: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0xd0bf0e80  ! 783: STDA_R	stda	%r8, [%r28 + %r0] 0x74
	.word 0xd8b504a0  ! 784: STHA_R	stha	%r12, [%r20 + %r0] 0x25
	.word 0xd0dd2000  ! 785: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0x87802072  ! 786: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0ada000  ! 787: STBA_I	stba	%r8, [%r22 + 0x0000] %asi
	.word 0x87802025  ! 788: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 789: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c0, %r20
	.word 0xdeb504a0  ! 791: STHA_R	stha	%r15, [%r20 + %r0] 0x25
	.word 0x87802073  ! 792: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r19
	.word 0xd0d76000  ! 794: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xdec689e0  ! 795: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r15
	.word 0xd4c48400  ! 796: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r10
	.word 0xdcd7ce80  ! 797: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r14
	.word 0xd8df6000  ! 798: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0xdef7ce40  ! 799: STXA_R	stxa	%r15, [%r31 + %r0] 0x72
	.word 0xd4b74e60  ! 800: STHA_R	stha	%r10, [%r29 + %r0] 0x73
	mov	0x7f8, %r22
	.word 0xd29c8400  ! 802: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	mov	0x3c0, %r23
	.word 0xdaaf2000  ! 804: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdaa72000  ! 805: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xdef74e60  ! 806: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	.word 0xdcbf0e60  ! 807: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	.word 0xdcf72000  ! 808: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	mov	0x7f8, %r23
	mov	0x7c0, %r23
	.word 0xd4c70e40  ! 811: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r10
	.word 0x87802025  ! 812: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6ccc400  ! 813: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	.word 0xd8b62000  ! 814: STHA_I	stha	%r12, [%r24 + 0x0000] %asi
	.word 0xd8aee000  ! 815: STBA_I	stba	%r12, [%r27 + 0x0000] %asi
	wr_tick_cmpr_1_5:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xd9, %g2
	or	%g4, 0xec, %g4
	or	%g6, 0xc2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x40, %r18
	.word 0xdac40400  ! 818: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	mov	0x7e8, %r22
	.word 0xd08c0400  ! 820: LDUBA_R	lduba	[%r16, %r0] 0x20, %r8
	.word 0xd4a6e000  ! 821: STWA_I	stwa	%r10, [%r27 + 0x0000] %asi
	.word 0xd4dea000  ! 822: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	.word 0xd2f44400  ! 823: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	.word 0xd8d609e0  ! 824: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r12
	.word 0xdcaee000  ! 825: STBA_I	stba	%r14, [%r27 + 0x0000] %asi
	.word 0xdcdee000  ! 826: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r14
	.word 0xdcf62000  ! 827: STXA_I	stxa	%r14, [%r24 + 0x0000] %asi
	.word 0xdec70e40  ! 828: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r15
	.word 0x87802074  ! 829: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc842000  ! 830: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	.word 0x87802020  ! 831: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 832: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdedd84a0  ! 833: LDXA_R	ldxa	[%r22, %r0] 0x25, %r15
	.word 0xd6942000  ! 834: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r11
	ta	T_CHANGE_PRIV	! macro
	mov	0x3e8, %r22
	.word 0xd6f4a000  ! 837: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	.word 0xd0df4e40  ! 838: LDXA_R	ldxa	[%r29, %r0] 0x72, %r8
	.word 0xda9689e0  ! 839: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r13
	.word 0xd0ac6000  ! 840: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	mov	0x58, %r18
	.word 0xd0dca000  ! 842: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	mov	0x30, %r26
	mov	0x50, %r25
	.word 0xd6bc8400  ! 845: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xd0b74e60  ! 846: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	.word 0x87802073  ! 847: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0bf0e80  ! 848: STDA_R	stda	%r8, [%r28 + %r0] 0x74
	mov	0x60, %r26
	mov	0x78, %r25
	.word 0x87802020  ! 851: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6afa000  ! 852: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 853: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 854: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b76000  ! 855: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd6cfa000  ! 856: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0xd6f649e0  ! 857: STXA_R	stxa	%r11, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 858: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r17
	.word 0xd0b56000  ! 860: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	.word 0xdaf70e60  ! 861: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	.word 0xdaf52000  ! 862: STXA_I	stxa	%r13, [%r20 + 0x0000] %asi
	.word 0xd6f44400  ! 863: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0xd8bf4e60  ! 864: STDA_R	stda	%r12, [%r29 + %r0] 0x73
	.word 0xd295e000  ! 865: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r9
	mov	0x20, %r24
	mov	0x68, %r19
	.word 0xd0b74e60  ! 868: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	.word 0x87802020  ! 869: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b70e80  ! 870: STHA_R	stha	%r10, [%r28 + %r0] 0x74
	.word 0xd8ce09e0  ! 871: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r12
	mov	0x50, %r26
	mov	0x38, %r17
	.word 0xdef7a000  ! 874: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 875: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 876: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 877: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef76000  ! 878: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xd4f40400  ! 879: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xd6f78e40  ! 880: STXA_R	stxa	%r11, [%r30 + %r0] 0x72
	.word 0xdca72000  ! 881: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	mov	0x78, %r16
	mov	0x7d8, %r23
	mov	0x0, %r17
	.word 0xdc97e000  ! 885: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 886: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 887: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf46000  ! 888: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xd4ad84a0  ! 889: STBA_R	stba	%r10, [%r22 + %r0] 0x25
	.word 0xdea42000  ! 890: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	wr_tick_cmpr_1_6:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xac, %g2
	or	%g4, 0xbf, %g4
	or	%g6, 0x89, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdeac2000  ! 892: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xd8a7ce40  ! 893: STWA_R	stwa	%r12, [%r31 + %r0] 0x72
	.word 0x87802072  ! 894: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde97ce60  ! 895: LDUHA_R	lduha	[%r31, %r0] 0x73, %r15
	.word 0xda8d6000  ! 896: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r13
	wr_tick_cmpr_1_7:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc0, %g2
	or	%g4, 0x8a, %g4
	or	%g6, 0xa2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x60, %r26
	mov	0x48, %r26
	.word 0xd2d7ce60  ! 900: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r9
	.word 0xd4ce09e0  ! 901: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r10
	.word 0xd2bf8e40  ! 902: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	.word 0x87802073  ! 903: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 904: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e8, %r22
	.word 0xdeb40400  ! 906: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0x87802020  ! 907: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r20
	mov	0x78, %r24
	.word 0x87802020  ! 910: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac4a000  ! 911: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	.word 0xda942000  ! 912: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0xdabc6000  ! 913: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xda94a000  ! 914: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	.word 0x87802072  ! 915: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda8f6000  ! 916: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0x87802025  ! 917: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde9f0e60  ! 918: LDDA_R	ldda	[%r28, %r0] 0x73, %r15
	.word 0xdccc6000  ! 919: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	mov	0x70, %r26
	mov	0x7e8, %r20
	.word 0x87802073  ! 922: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4acc400  ! 923: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xde8584a0  ! 924: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r15
	mov	0x3f8, %r22
	mov	0x50, %r26
	.word 0x87802073  ! 927: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r27
	.word 0xd8b46000  ! 929: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xd8ace000  ! 931: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 932: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd894a000  ! 933: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r12
	mov	0x18, %r17
	mov	0x10, %r26
	.word 0xd88c2000  ! 936: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	.word 0xd8bf0e40  ! 937: STDA_R	stda	%r12, [%r28 + %r0] 0x72
	.word 0xd8bc6000  ! 938: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0xd8f46000  ! 939: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xdecf8e80  ! 940: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r15
	mov	0x30, %r16
	.word 0xdcbf4e80  ! 942: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	.word 0xd08c6000  ! 943: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0xd084e000  ! 944: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	.word 0xd0b4a000  ! 945: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xd0b46000  ! 946: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	mov	0x10, %r24
	.word 0x87802020  ! 948: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b78e60  ! 949: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	mov	0x7e8, %r20
	mov	0x18, %r19
	.word 0xdcdf2000  ! 952: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	mov	0x38, %r24
	.word 0xd2944400  ! 954: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	mov	0x40, %r18
	.word 0xd48cc400  ! 956: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	mov	0x70, %r18
	.word 0xde9f2000  ! 958: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xdedfa000  ! 959: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xdedf2000  ! 960: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xde97a000  ! 961: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	.word 0xdeb48400  ! 962: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xd0b72000  ! 963: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	mov	0x48, %r26
	.word 0xd0f72000  ! 965: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xdab70e40  ! 966: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	.word 0xdcf4c400  ! 967: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0x87802073  ! 968: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a584a0  ! 969: STWA_R	stwa	%r8, [%r22 + %r0] 0x25
	mov	0x58, %r24
	.word 0xd2f48400  ! 971: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0xdadfce60  ! 972: LDXA_R	ldxa	[%r31, %r0] 0x73, %r13
	.word 0xde9fa000  ! 973: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	.word 0x87802074  ! 974: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 975: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e8, %r21
	.word 0xd2b44400  ! 977: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0xdcc6a000  ! 978: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 979: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd49c4400  ! 980: LDDA_R	ldda	[%r17, %r0] 0x20, %r10
	.word 0xd4dc2000  ! 981: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	wr_tick_cmpr_1_8:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xeb, %g2
	or	%g4, 0xbf, %g4
	or	%g6, 0xaa, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xda95c4a0  ! 983: LDUHA_R	lduha	[%r23, %r0] 0x25, %r13
	mov	0x8, %r27
	.word 0xd28c4400  ! 985: LDUBA_R	lduba	[%r17, %r0] 0x20, %r9
	.word 0xd4946000  ! 986: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r10
	.word 0xd4dc6000  ! 987: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	mov	0x7c0, %r22
	.word 0xd4bce000  ! 989: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 990: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f44400  ! 991: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	mov	0x3c8, %r21
	.word 0xdcdcc400  ! 993: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	mov	0x3c0, %r21
	.word 0x8780204f  ! 995: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e0, %r21
	.word 0xd2af0e40  ! 997: STBA_R	stba	%r9, [%r28 + %r0] 0x72
	mov	0x28, %r16
	.word 0xd8cdc4a0  ! 999: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r12
	.word 0xd08d44a0  ! 1000: LDUBA_R	lduba	[%r21, %r0] 0x25, %r8
	.word 0xd4bc6000  ! 1001: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xd494e000  ! 1002: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	mov	0x7f8, %r22
	.word 0xd0dd04a0  ! 1004: LDXA_R	ldxa	[%r20, %r0] 0x25, %r8
	.word 0x87802025  ! 1005: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd697e000  ! 1006: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0xd0a78e40  ! 1007: STWA_R	stwa	%r8, [%r30 + %r0] 0x72
	.word 0xd4d504a0  ! 1008: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r10
	mov	0x20, %r16
	.word 0xdc970e60  ! 1010: LDUHA_R	lduha	[%r28, %r0] 0x73, %r14
	mov	0x7f0, %r20
	.word 0x87802072  ! 1012: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 1013: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f4c400  ! 1014: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	ta	T_CHANGE_PRIV	! macro
	.word 0xdaaf4e40  ! 1016: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	.word 0xd8d5a000  ! 1017: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r12
	.word 0xd8a5e000  ! 1018: STWA_I	stwa	%r12, [%r23 + 0x0000] %asi
	.word 0xd8f52000  ! 1019: STXA_I	stxa	%r12, [%r20 + 0x0000] %asi
	mov	0x3f8, %r20
	mov	0x10, %r16
	.word 0xd8a70e80  ! 1022: STWA_R	stwa	%r12, [%r28 + %r0] 0x74
	.word 0x87802073  ! 1023: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcd7a000  ! 1024: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0xdab78e40  ! 1025: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	.word 0x87802020  ! 1026: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabc2000  ! 1027: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	mov	0x10, %r27
	mov	0x50, %r18
	.word 0x8780204f  ! 1030: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r27
	.word 0xdea689e0  ! 1032: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	.word 0xd6a44400  ! 1033: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0xdc952000  ! 1034: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r14
	.word 0xd48c4400  ! 1035: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0x87802020  ! 1036: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc94c400  ! 1037: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	.word 0xd2c649e0  ! 1038: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r9
	mov	0x48, %r16
	.word 0xd8a7e000  ! 1040: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xdadc4400  ! 1041: LDXA_R	ldxa	[%r17, %r0] 0x20, %r13
	.word 0xd6872000  ! 1042: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6a7a000  ! 1043: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	mov	0x18, %r27
	.word 0xd0cf4e40  ! 1045: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	.word 0xd497e000  ! 1046: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	mov	0x7c8, %r23
	.word 0xd48fe000  ! 1048: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	mov	0x30, %r19
	mov	0x7c0, %r22
	mov	0x48, %r26
	.word 0xdca649e0  ! 1052: STWA_R	stwa	%r14, [%r25 + %r0] 0x4f
	mov	0x38, %r19
	.word 0xd097e000  ! 1054: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xd4d4c400  ! 1055: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0xdcdd84a0  ! 1056: LDXA_R	ldxa	[%r22, %r0] 0x25, %r14
	.word 0xde874e60  ! 1057: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r15
	.word 0xd4df4e60  ! 1058: LDXA_R	ldxa	[%r29, %r0] 0x73, %r10
	.word 0xd887ce80  ! 1059: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r12
	.word 0xd4876000  ! 1060: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xd887ce60  ! 1061: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r12
	.word 0xd4c72000  ! 1062: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4af6000  ! 1063: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xde85c4a0  ! 1064: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r15
	.word 0xd6ac8400  ! 1065: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0x87802025  ! 1066: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r24
	.word 0xdebe2000  ! 1068: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	.word 0x87802025  ! 1069: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 1070: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea76000  ! 1071: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	mov	0x40, %r24
	.word 0xd68d84a0  ! 1073: LDUBA_R	lduba	[%r22, %r0] 0x25, %r11
	.word 0xda970e60  ! 1074: LDUHA_R	lduha	[%r28, %r0] 0x73, %r13
	.word 0xd4bf2000  ! 1075: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd4bf6000  ! 1076: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 1077: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb7ce60  ! 1078: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	mov	0x78, %r16
	mov	0x58, %r16
	.word 0xdeafce80  ! 1081: STBA_R	stba	%r15, [%r31 + %r0] 0x74
	.word 0xde8ca000  ! 1082: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0x87802020  ! 1083: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r26
	.word 0xdedf2000  ! 1085: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xdedf6000  ! 1086: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xdec72000  ! 1087: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0x87802020  ! 1088: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1089: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1090: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1091: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6a78e60  ! 1092: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0xdc876000  ! 1093: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	mov	0x60, %r19
	.word 0xde9689e0  ! 1095: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r15
	.word 0xd0af2000  ! 1096: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0bfa000  ! 1097: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 1098: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a4e000  ! 1099: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd8c44400  ! 1100: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r12
	.word 0xd6dce000  ! 1101: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0x87802074  ! 1102: WRASI_I	wr	%r0, 0x0074, %asi
	wr_tick_cmpr_1_9:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xda, %g2
	or	%g4, 0xb0, %g4
	or	%g6, 0xa3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdaf78e60  ! 1104: STXA_R	stxa	%r13, [%r30 + %r0] 0x73
	.word 0xd8c70e40  ! 1105: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r12
	.word 0xd29fce80  ! 1106: LDDA_R	ldda	[%r31, %r0] 0x74, %r9
	.word 0x87802072  ! 1107: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd88f2000  ! 1108: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	mov	0x10, %r27
	mov	0x78, %r24
	.word 0x87802020  ! 1111: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8f0e60  ! 1112: LDUBA_R	lduba	[%r28, %r0] 0x73, %r15
	mov	0x7d0, %r21
	.word 0xdef48400  ! 1114: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xdc9f8e40  ! 1115: LDDA_R	ldda	[%r30, %r0] 0x72, %r14
	.word 0xd8f74e60  ! 1116: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	.word 0xdad4e000  ! 1117: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r13
	.word 0xda942000  ! 1118: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0xdabe09e0  ! 1119: STDA_R	stda	%r13, [%r24 + %r0] 0x4f
	.word 0xd6a46000  ! 1120: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0xd6b4a000  ! 1121: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd8cfce40  ! 1122: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r12
	mov	0x7e0, %r22
	.word 0xd0b42000  ! 1124: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	mov	0x3d0, %r20
	mov	0x8, %r25
	mov	0x30, %r24
	mov	0x7e0, %r22
	.word 0x87802074  ! 1129: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0ce6000  ! 1130: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r8
	mov	0x28, %r25
	.word 0xdc878e40  ! 1132: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r14
	.word 0xd6af4e60  ! 1133: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	mov	0x3d0, %r23
	mov	0x28, %r16
	.word 0xdadc4400  ! 1136: LDXA_R	ldxa	[%r17, %r0] 0x20, %r13
	.word 0xdcc66000  ! 1137: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	mov	0x8, %r19
	.word 0xdc8e49e0  ! 1139: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r14
	.word 0x87802025  ! 1140: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b72000  ! 1141: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 1142: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6ae2000  ! 1143: STBA_I	stba	%r11, [%r24 + 0x0000] %asi
	mov	0x58, %r24
	wr_tick_cmpr_1_10:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xdc, %g2
	or	%g4, 0xa8, %g4
	or	%g6, 0xb0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xda974e80  ! 1146: LDUHA_R	lduha	[%r29, %r0] 0x74, %r13
	.word 0xd6a66000  ! 1147: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	.word 0xdeac0400  ! 1148: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	mov	0x8, %r16
	.word 0xd8b74e80  ! 1150: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	.word 0xd2aee000  ! 1151: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	wr_tick_cmpr_1_11:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xd2, %g2
	or	%g4, 0xde, %g4
	or	%g6, 0x9f, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd286a000  ! 1153: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r9
	.word 0x87802072  ! 1154: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2dca000  ! 1155: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r9
	.word 0xdab74e60  ! 1156: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	.word 0x87802074  ! 1157: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r24
	.word 0xd88ce000  ! 1159: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	.word 0xd8b7ce60  ! 1160: STHA_R	stha	%r12, [%r31 + %r0] 0x73
	mov	0x10, %r27
	.word 0xdaa5c4a0  ! 1162: STWA_R	stwa	%r13, [%r23 + %r0] 0x25
	mov	0x38, %r25
	.word 0xd8ae09e0  ! 1164: STBA_R	stba	%r12, [%r24 + %r0] 0x4f
	.word 0xdea609e0  ! 1165: STWA_R	stwa	%r15, [%r24 + %r0] 0x4f
	.word 0xd49c6000  ! 1166: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1167: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b7ce80  ! 1168: STHA_R	stha	%r11, [%r31 + %r0] 0x74
	.word 0xdad48400  ! 1169: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0xd69ea000  ! 1170: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r11
	.word 0x87802020  ! 1171: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bc2000  ! 1172: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0xd0bdc4a0  ! 1173: STDA_R	stda	%r8, [%r23 + %r0] 0x25
	.word 0xded48400  ! 1174: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	.word 0x87802073  ! 1175: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e0, %r20
	.word 0xd69f4e40  ! 1177: LDDA_R	ldda	[%r29, %r0] 0x72, %r11
	.word 0xd8f44400  ! 1178: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xd0af6000  ! 1179: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd0872000  ! 1180: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	mov	0x3d0, %r20
	.word 0xd09fe000  ! 1182: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	.word 0xd4c74e80  ! 1183: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r10
	mov	0x28, %r17
	.word 0x87802073  ! 1185: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc9d84a0  ! 1186: LDDA_R	ldda	[%r22, %r0] 0x25, %r14
	mov	0x3f0, %r21
	.word 0xda862000  ! 1188: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r13
	.word 0xdac66000  ! 1189: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r13
	.word 0xdaf40400  ! 1190: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0x87802074  ! 1191: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f5a000  ! 1192: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 1193: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r25
	.word 0xd4f7e000  ! 1195: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1196: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4afa000  ! 1197: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd4f70e80  ! 1198: STXA_R	stxa	%r10, [%r28 + %r0] 0x74
	.word 0xd0976000  ! 1199: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1200: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1201: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd28cc400  ! 1202: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	.word 0x8780204f  ! 1203: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bca000  ! 1204: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0xd4f4e000  ! 1205: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0xd4f46000  ! 1206: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0xd2a544a0  ! 1207: STWA_R	stwa	%r9, [%r21 + %r0] 0x25
	mov	0x48, %r17
	.word 0xd0dc6000  ! 1209: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	.word 0xd0bca000  ! 1210: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xdcac0400  ! 1212: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	mov	0x3e0, %r23
	mov	0x30, %r26
	.word 0xd0afce40  ! 1215: STBA_R	stba	%r8, [%r31 + %r0] 0x72
	.word 0xdef7ce80  ! 1216: STXA_R	stxa	%r15, [%r31 + %r0] 0x74
	.word 0xd4f44400  ! 1217: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 1218: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 1219: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6dca000  ! 1220: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r11
	mov	0x70, %r26
	.word 0x87802020  ! 1222: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r17
	.word 0xd6f46000  ! 1224: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0xd694a000  ! 1225: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r11
	.word 0x87802020  ! 1226: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca70e40  ! 1227: STWA_R	stwa	%r14, [%r28 + %r0] 0x72
	.word 0xde9f6000  ! 1228: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x0, %r26
	.word 0x87802025  ! 1231: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r16
	mov	0x78, %r17
	.word 0xde8ec9e0  ! 1234: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r15
	.word 0x87802025  ! 1235: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r25
	.word 0xd8ada000  ! 1237: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0xde8d04a0  ! 1238: LDUBA_R	lduba	[%r20, %r0] 0x25, %r15
	.word 0xd4bf4e60  ! 1239: STDA_R	stda	%r10, [%r29 + %r0] 0x73
	mov	0x70, %r24
	.word 0xdcf52000  ! 1241: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	.word 0x87802025  ! 1242: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8878e40  ! 1243: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r12
	.word 0xdcd7a000  ! 1244: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0xdcf72000  ! 1245: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdaac0400  ! 1246: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	mov	0x38, %r24
	.word 0xdcdfe000  ! 1248: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xdaf7ce60  ! 1249: STXA_R	stxa	%r13, [%r31 + %r0] 0x73
	.word 0xd2dc0400  ! 1250: LDXA_R	ldxa	[%r16, %r0] 0x20, %r9
	mov	0x3c0, %r20
	.word 0xdaf78e60  ! 1252: STXA_R	stxa	%r13, [%r30 + %r0] 0x73
	.word 0xd6bf2000  ! 1253: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 1254: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e0, %r22
	.word 0x87802074  ! 1256: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2874e40  ! 1257: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r9
	.word 0xd094a000  ! 1258: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	.word 0xd084a000  ! 1259: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	.word 0xdcb78e40  ! 1260: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xd8f4a000  ! 1261: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8d4a000  ! 1262: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xd89c6000  ! 1263: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r12
	.word 0xdadcc400  ! 1264: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0x87802072  ! 1265: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r24
	.word 0xd0f5a000  ! 1267: STXA_I	stxa	%r8, [%r22 + 0x0000] %asi
	mov	0x68, %r18
	.word 0xd0856000  ! 1269: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r8
	.word 0xd28fce60  ! 1270: LDUBA_R	lduba	[%r31, %r0] 0x73, %r9
	.word 0xd4bd6000  ! 1271: STDA_I	stda	%r10, [%r21 + 0x0000] %asi
	.word 0xd4bd6000  ! 1272: STDA_I	stda	%r10, [%r21 + 0x0000] %asi
	.word 0xdaf649e0  ! 1273: STXA_R	stxa	%r13, [%r25 + %r0] 0x4f
	.word 0xd0d5e000  ! 1274: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 1275: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0976000  ! 1276: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0af2000  ! 1277: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0bf0e60  ! 1278: STDA_R	stda	%r8, [%r28 + %r0] 0x73
	.word 0xd0a4c400  ! 1279: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xdaaf6000  ! 1280: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xd0874e60  ! 1281: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r8
	mov	0x7d8, %r22
	mov	0x7d0, %r21
	mov	0x50, %r17
	.word 0xdebf6000  ! 1285: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xd4cc0400  ! 1286: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r10
	.word 0x87802020  ! 1287: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r22
	.word 0xd0c584a0  ! 1289: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r8
	.word 0xd0b70e60  ! 1290: STHA_R	stha	%r8, [%r28 + %r0] 0x73
	.word 0xd6844400  ! 1291: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r11
	.word 0x87802074  ! 1292: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1293: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1294: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc9de000  ! 1295: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r14
	.word 0x87802073  ! 1296: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc8c6000  ! 1297: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r14
	mov	0x60, %r16
	.word 0x8780204f  ! 1299: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r18
	mov	0x50, %r19
	.word 0xde8c4400  ! 1302: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	.word 0xda8fe000  ! 1303: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	mov	0x3f8, %r22
	.word 0x87802073  ! 1305: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 1306: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdacfe000  ! 1307: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 1308: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 1309: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9e6000  ! 1310: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r13
	.word 0xdccec9e0  ! 1311: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r14
	mov	0x3e0, %r21
	mov	0x7f8, %r23
	.word 0xd6f6e000  ! 1314: STXA_I	stxa	%r11, [%r27 + 0x0000] %asi
	mov	0x18, %r16
	.word 0xdaad84a0  ! 1316: STBA_R	stba	%r13, [%r22 + %r0] 0x25
	.word 0xd8f44400  ! 1317: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0x87802074  ! 1318: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r19
	mov	0x50, %r19
	.word 0xd0f649e0  ! 1321: STXA_R	stxa	%r8, [%r25 + %r0] 0x4f
	mov	0x78, %r27
	.word 0xdea46000  ! 1323: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xd2a70e60  ! 1324: STWA_R	stwa	%r9, [%r28 + %r0] 0x73
	.word 0xdc8e09e0  ! 1325: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r14
	mov	0x3f8, %r22
	mov	0x3d8, %r20
	.word 0xd6b46000  ! 1328: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd69c2000  ! 1329: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r11
	.word 0x87802020  ! 1330: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69c0400  ! 1331: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	.word 0xd28e89e0  ! 1332: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r9
	mov	0x40, %r18
	.word 0xd8cd04a0  ! 1334: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r12
	.word 0xd2b4c400  ! 1335: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xdadf6000  ! 1336: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xd2de49e0  ! 1337: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r9
	.word 0xd4f74e80  ! 1338: STXA_R	stxa	%r10, [%r29 + %r0] 0x74
	.word 0xd69c0400  ! 1339: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	.word 0xdacfa000  ! 1340: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xdcb7ce60  ! 1341: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	mov	0x7e0, %r22
	.word 0xdeb72000  ! 1343: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	mov	0x50, %r24
	.word 0xdab74e60  ! 1345: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	.word 0xdeb504a0  ! 1346: STHA_R	stha	%r15, [%r20 + %r0] 0x25
	mov	0x3f0, %r23
	mov	0x3e8, %r23
	mov	0x58, %r27
	mov	0x7d0, %r20
	.word 0xd0d76000  ! 1351: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0af2000  ! 1352: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	mov	0x78, %r26
	mov	0x7e0, %r21
	.word 0xdca7ce60  ! 1355: STWA_R	stwa	%r14, [%r31 + %r0] 0x73
	.word 0xd4b74e40  ! 1356: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	.word 0xdebfe000  ! 1357: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xd4df8e40  ! 1358: LDXA_R	ldxa	[%r30, %r0] 0x72, %r10
	.word 0x87802072  ! 1359: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd48584a0  ! 1360: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r10
	.word 0x87802073  ! 1361: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 1362: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcd70e80  ! 1363: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r14
	.word 0x8780204f  ! 1364: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1365: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r24
	mov	0x50, %r27
	.word 0x87802025  ! 1368: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4ac2000  ! 1369: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0xd4c4a000  ! 1370: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	.word 0xd4bce000  ! 1371: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	mov	0x38, %r17
	.word 0x87802074  ! 1373: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r16
	.word 0xd4f44400  ! 1375: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0xd6afe000  ! 1376: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd6af6000  ! 1377: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xd6d72000  ! 1379: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r11
	mov	0x3d0, %r23
	.word 0xd6a7e000  ! 1381: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6b7e000  ! 1382: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd4a649e0  ! 1383: STWA_R	stwa	%r10, [%r25 + %r0] 0x4f
	.word 0xd0a7e000  ! 1384: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0b7a000  ! 1385: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xdc9fce60  ! 1386: LDDA_R	ldda	[%r31, %r0] 0x73, %r14
	.word 0xd0f4c400  ! 1387: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	mov	0x50, %r17
	.word 0xdac7ce40  ! 1389: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r13
	mov	0x18, %r17
	.word 0xd6b48400  ! 1391: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	ta	T_CHANGE_PRIV	! macro
	mov	0x68, %r16
	mov	0x8, %r27
	mov	0x30, %r27
	mov	0x30, %r26
	mov	0x10, %r19
	.word 0xdef4c400  ! 1398: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	mov	0x70, %r26
	mov	0x58, %r16
	.word 0xd8a7a000  ! 1401: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 1402: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r18
	.word 0xd8944400  ! 1404: LDUHA_R	lduha	[%r17, %r0] 0x20, %r12
	.word 0x87802020  ! 1405: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r16
	.word 0xd8bf0e60  ! 1407: STDA_R	stda	%r12, [%r28 + %r0] 0x73
	.word 0xd6dd84a0  ! 1408: LDXA_R	ldxa	[%r22, %r0] 0x25, %r11
	mov	0x50, %r18
	.word 0xdab5c4a0  ! 1410: STHA_R	stha	%r13, [%r23 + %r0] 0x25
	.word 0xdcae09e0  ! 1411: STBA_R	stba	%r14, [%r24 + %r0] 0x4f
	.word 0xd6dfa000  ! 1412: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0xd68fa000  ! 1413: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	mov	0x3c8, %r21
	mov	0x78, %r24
	.word 0xd0a544a0  ! 1416: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	mov	0x68, %r26
	mov	0x78, %r25
	.word 0x8780204f  ! 1419: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 1420: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd69f6000  ! 1421: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	mov	0x3c8, %r21
	.word 0xd6dfa000  ! 1423: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 1424: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r17
	.word 0xd6a4e000  ! 1426: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0xd6d42000  ! 1427: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r11
	.word 0xdab70e40  ! 1428: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	.word 0xd8bca000  ! 1429: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0xd6b78e80  ! 1431: STHA_R	stha	%r11, [%r30 + %r0] 0x74
	.word 0xded4e000  ! 1432: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	.word 0x87802020  ! 1433: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bfce40  ! 1434: STDA_R	stda	%r12, [%r31 + %r0] 0x72
	mov	0x18, %r25
	mov	0x18, %r26
	.word 0xd09f2000  ! 1437: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0xd08fa000  ! 1438: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	ta	T_CHANGE_PRIV	! macro
	.word 0xd0a5c4a0  ! 1440: STWA_R	stwa	%r8, [%r23 + %r0] 0x25
	.word 0xdccc0400  ! 1441: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r14
	.word 0xd6b70e80  ! 1442: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	.word 0x87802020  ! 1443: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1444: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8f76000  ! 1445: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xdaa7ce40  ! 1446: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	.word 0xd4cf6000  ! 1447: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	mov	0x3c8, %r22
	.word 0xd4b7a000  ! 1449: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd2afce40  ! 1450: STBA_R	stba	%r9, [%r31 + %r0] 0x72
	.word 0xdaccc400  ! 1451: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r13
	.word 0xd0dfe000  ! 1452: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0c7a000  ! 1453: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0x87802072  ! 1454: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4af0e40  ! 1455: STBA_R	stba	%r10, [%r28 + %r0] 0x72
	.word 0x87802073  ! 1456: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8a62000  ! 1457: STWA_I	stwa	%r12, [%r24 + 0x0000] %asi
	.word 0xda840400  ! 1458: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	mov	0x30, %r25
	mov	0x40, %r16
	mov	0x7f8, %r22
	.word 0xdace2000  ! 1462: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r13
	.word 0xd0874e40  ! 1463: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r8
	.word 0xd4bcc400  ! 1464: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0xdcb66000  ! 1465: STHA_I	stha	%r14, [%r25 + 0x0000] %asi
	.word 0x87802025  ! 1466: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdea504a0  ! 1467: STWA_R	stwa	%r15, [%r20 + %r0] 0x25
	.word 0xd6cc4400  ! 1468: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	mov	0x8, %r24
	mov	0x0, %r25
	.word 0xd0a5e000  ! 1471: STWA_I	stwa	%r8, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 1472: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeb544a0  ! 1473: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	mov	0x38, %r26
	.word 0xd6aca000  ! 1475: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xdca44400  ! 1476: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0xd89c6000  ! 1477: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r12
	.word 0xdaaf4e80  ! 1478: STBA_R	stba	%r13, [%r29 + %r0] 0x74
	.word 0x87802020  ! 1479: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1480: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa70e80  ! 1481: STWA_R	stwa	%r13, [%r28 + %r0] 0x74
	.word 0x87802020  ! 1482: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8c6000  ! 1483: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0xde84a000  ! 1484: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	.word 0xd29f0e80  ! 1485: LDDA_R	ldda	[%r28, %r0] 0x74, %r9
	.word 0xd4bf4e40  ! 1486: STDA_R	stda	%r10, [%r29 + %r0] 0x72
	.word 0xdab46000  ! 1487: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0xdac4a000  ! 1488: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	.word 0xd2d74e40  ! 1489: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r9
	.word 0x87802025  ! 1490: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2d7e000  ! 1491: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xd297e000  ! 1492: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	mov	0x3c0, %r20
	mov	0x7c0, %r20
	.word 0xd2cfe000  ! 1495: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	mov	0x7e8, %r23
	.word 0x87802073  ! 1497: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e8, %r20
	.word 0xd2de6000  ! 1499: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r9
	.word 0xd2be6000  ! 1500: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	.word 0xd0afce60  ! 1501: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	.word 0xdcc74e80  ! 1502: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r14
	.word 0xd0a40400  ! 1503: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0xd2b6e000  ! 1504: STHA_I	stha	%r9, [%r27 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xd2f6a000  ! 1506: STXA_I	stxa	%r9, [%r26 + 0x0000] %asi
	.word 0xdc8689e0  ! 1507: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r14
	.word 0xd6ce2000  ! 1508: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	.word 0xd2b70e60  ! 1509: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	.word 0xdcbe89e0  ! 1510: STDA_R	stda	%r14, [%r26 + %r0] 0x4f
	wr_tick_cmpr_1_12:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x83, %g2
	or	%g4, 0x9a, %g4
	or	%g6, 0xb3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdeae2000  ! 1512: STBA_I	stba	%r15, [%r24 + 0x0000] %asi
	mov	0x38, %r25
	.word 0xd8bd04a0  ! 1514: STDA_R	stda	%r12, [%r20 + %r0] 0x25
	.word 0xd4de2000  ! 1515: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r10
	.word 0xd4f74e80  ! 1516: STXA_R	stxa	%r10, [%r29 + %r0] 0x74
	.word 0xd0dc0400  ! 1517: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xdcde2000  ! 1518: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r14
	mov	0x0, %r16
	.word 0x87802020  ! 1520: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r21
	mov	0x10, %r17
	mov	0x38, %r27
	.word 0x87802020  ! 1524: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1525: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c649e0  ! 1526: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r9
	.word 0xd8a7e000  ! 1527: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd88f2000  ! 1528: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 1529: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8f4e000  ! 1530: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 1531: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacd04a0  ! 1532: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r13
	.word 0xd8af6000  ! 1533: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd48584a0  ! 1534: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r10
	.word 0xd8d7e000  ! 1535: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	mov	0x3d0, %r20
	mov	0x3c8, %r20
	.word 0xd8cfe000  ! 1538: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xd6cfce60  ! 1539: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r11
	.word 0xdedf2000  ! 1540: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xdea76000  ! 1541: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	mov	0x28, %r25
	.word 0x87802020  ! 1543: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebce000  ! 1544: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xd2af8e60  ! 1545: STBA_R	stba	%r9, [%r30 + %r0] 0x73
	.word 0xd4a78e60  ! 1546: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	mov	0x7f8, %r21
	.word 0xd08ca000  ! 1548: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xd0f4e000  ! 1549: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 1550: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1551: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r16
	.word 0xd4b5c4a0  ! 1553: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	.word 0xd49c6000  ! 1554: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0xdc9f8e60  ! 1555: LDDA_R	ldda	[%r30, %r0] 0x73, %r14
	.word 0xd4de09e0  ! 1556: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r10
	.word 0x87802072  ! 1557: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3e0, %r21
	.word 0xd8cf8e40  ! 1559: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r12
	.word 0x8780204f  ! 1560: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9ce000  ! 1561: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r13
	.word 0x87802025  ! 1562: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdadca000  ! 1563: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0xde844400  ! 1564: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	.word 0xd6f4c400  ! 1565: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0xdaa40400  ! 1566: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0x87802074  ! 1567: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4d62000  ! 1568: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r10
	.word 0xd0ac4400  ! 1569: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0x87802074  ! 1570: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r26
	.word 0xd6b504a0  ! 1572: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	.word 0xdca70e80  ! 1573: STWA_R	stwa	%r14, [%r28 + %r0] 0x74
	.word 0xdcc56000  ! 1574: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r14
	.word 0xd6d74e40  ! 1575: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r11
	.word 0x87802072  ! 1576: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 1577: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2ac8400  ! 1578: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	mov	0x0, %r16
	.word 0x87802072  ! 1580: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2bf0e40  ! 1581: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	.word 0xd0f42000  ! 1582: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0xd0ac2000  ! 1583: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 1584: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0cf2000  ! 1585: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0bf2000  ! 1587: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xd08f8e60  ! 1588: LDUBA_R	lduba	[%r30, %r0] 0x73, %r8
	.word 0xd2af2000  ! 1589: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd2dfa000  ! 1590: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2c7e000  ! 1591: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2c7e000  ! 1592: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0x87802074  ! 1593: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 1594: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2afe000  ! 1595: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd2b7a000  ! 1596: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 1597: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb44400  ! 1598: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0xdef6e000  ! 1599: STXA_I	stxa	%r15, [%r27 + 0x0000] %asi
	wr_tick_cmpr_1_13:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe6, %g2
	or	%g4, 0x83, %g4
	or	%g6, 0xd2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xde9e6000  ! 1601: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r15
	.word 0xde9ea000  ! 1602: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r15
	.word 0xdeb62000  ! 1603: STHA_I	stha	%r15, [%r24 + 0x0000] %asi
	.word 0xded62000  ! 1604: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r15
	mov	0x40, %r16
	mov	0x38, %r27
	.word 0xd2f584a0  ! 1607: STXA_R	stxa	%r9, [%r22 + %r0] 0x25
	mov	0x28, %r27
	.word 0xd88e09e0  ! 1609: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r12
	.word 0xdab74e80  ! 1610: STHA_R	stha	%r13, [%r29 + %r0] 0x74
	mov	0x10, %r25
	wr_tick_cmpr_1_14:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xc7, %g2
	or	%g4, 0xb3, %g4
	or	%g6, 0xb5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3c8, %r21
	.word 0xd4cee000  ! 1614: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r10
	.word 0x87802074  ! 1615: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1616: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d72000  ! 1617: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1618: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r19
	.word 0xd48fa000  ! 1620: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xd4bf2000  ! 1621: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd8a7ce40  ! 1622: STWA_R	stwa	%r12, [%r31 + %r0] 0x72
	.word 0xd8d584a0  ! 1623: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r12
	.word 0xd0df8e60  ! 1624: LDXA_R	ldxa	[%r30, %r0] 0x73, %r8
	.word 0x8780204f  ! 1625: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r24
	mov	0x0, %r24
	.word 0xd0dd2000  ! 1628: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0xd2b4c400  ! 1629: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0x87802020  ! 1630: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48689e0  ! 1631: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r10
	.word 0xd8878e40  ! 1632: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r12
	.word 0xd8b4c400  ! 1633: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0x87802025  ! 1634: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8f40400  ! 1635: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	mov	0x0, %r27
	.word 0x87802020  ! 1637: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabee000  ! 1638: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	.word 0xdcc544a0  ! 1639: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r14
	.word 0xdc86e000  ! 1640: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r14
	.word 0xdcc66000  ! 1641: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	.word 0x87802072  ! 1642: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4d44400  ! 1643: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0xd2b70e40  ! 1644: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	mov	0x10, %r24
	mov	0x40, %r25
	.word 0x87802020  ! 1647: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb584a0  ! 1648: STHA_R	stha	%r15, [%r22 + %r0] 0x25
	wr_tick_cmpr_1_15:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x82, %g2
	or	%g4, 0x87, %g4
	or	%g6, 0xd7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd6c6e000  ! 1650: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r11
	.word 0xdaf7ce60  ! 1651: STXA_R	stxa	%r13, [%r31 + %r0] 0x73
	.word 0xd6a6e000  ! 1652: STWA_I	stwa	%r11, [%r27 + 0x0000] %asi
	.word 0x87802074  ! 1653: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 1654: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r19
	.word 0xd8cfce80  ! 1656: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r12
	mov	0x7c8, %r23
	.word 0x8780204f  ! 1658: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0ace000  ! 1659: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0xdedfce80  ! 1660: LDXA_R	ldxa	[%r31, %r0] 0x74, %r15
	.word 0xd6af0e40  ! 1661: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	mov	0x7e0, %r23
	.word 0xdeb4a000  ! 1663: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	mov	0x10, %r16
	.word 0xdcb78e40  ! 1665: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	mov	0x60, %r16
	.word 0xdedf0e60  ! 1667: LDXA_R	ldxa	[%r28, %r0] 0x73, %r15
	mov	0x3e0, %r23
	.word 0xd6c4a000  ! 1669: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r11
	.word 0xdc8f4e60  ! 1670: LDUBA_R	lduba	[%r29, %r0] 0x73, %r14
	mov	0x60, %r27
	mov	0x40, %r25
	.word 0xd8be89e0  ! 1673: STDA_R	stda	%r12, [%r26 + %r0] 0x4f
	.word 0xd09f4e60  ! 1674: LDDA_R	ldda	[%r29, %r0] 0x73, %r8
	.word 0x87802020  ! 1675: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bd04a0  ! 1676: STDA_R	stda	%r10, [%r20 + %r0] 0x25
	.word 0x87802020  ! 1677: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r25
	.word 0xdedf8e60  ! 1679: LDXA_R	ldxa	[%r30, %r0] 0x73, %r15
	.word 0xd0cee000  ! 1680: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r8
	.word 0xdea689e0  ! 1681: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	mov	0x78, %r16
	mov	0x50, %r26
	.word 0xd296e000  ! 1684: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r9
	.word 0xd88f4e80  ! 1685: LDUBA_R	lduba	[%r29, %r0] 0x74, %r12
	.word 0xdab40400  ! 1686: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0x87802072  ! 1687: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1688: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2972000  ! 1689: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xd2976000  ! 1690: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0xd48c4400  ! 1691: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0x8780204f  ! 1692: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r16
	.word 0xda940400  ! 1694: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	.word 0xd09ee000  ! 1695: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r8
	mov	0x28, %r19
	.word 0xdcaf8e80  ! 1697: STBA_R	stba	%r14, [%r30 + %r0] 0x74
	.word 0xda944400  ! 1698: LDUHA_R	lduha	[%r17, %r0] 0x20, %r13
	.word 0xd2cea000  ! 1699: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r9
	.word 0x87802074  ! 1700: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2af6000  ! 1701: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd28f6000  ! 1702: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd287a000  ! 1703: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0xdcaf8e40  ! 1704: STBA_R	stba	%r14, [%r30 + %r0] 0x72
	.word 0xd0ad84a0  ! 1705: STBA_R	stba	%r8, [%r22 + %r0] 0x25
	.word 0xd4bfe000  ! 1706: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xd4af4e60  ! 1708: STBA_R	stba	%r10, [%r29 + %r0] 0x73
	.word 0xdac649e0  ! 1709: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r13
	.word 0xdac74e80  ! 1710: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r13
	.word 0x8780204f  ! 1711: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd697ce40  ! 1712: LDUHA_R	lduha	[%r31, %r0] 0x72, %r11
	.word 0xd6af2000  ! 1713: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd6afe000  ! 1714: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd4b74e80  ! 1715: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	mov	0x3f0, %r23
	mov	0x50, %r25
	mov	0x10, %r17
	.word 0xda9fce40  ! 1719: LDDA_R	ldda	[%r31, %r0] 0x72, %r13
	mov	0x30, %r17
	.word 0x87802073  ! 1721: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0cf2000  ! 1722: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0x87802072  ! 1723: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca70e80  ! 1724: STWA_R	stwa	%r14, [%r28 + %r0] 0x74
	.word 0xdcbc6000  ! 1725: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	mov	0x50, %r17
	.word 0xd8d44400  ! 1727: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	.word 0xd8afce60  ! 1728: STBA_R	stba	%r12, [%r31 + %r0] 0x73
	.word 0xd2ae09e0  ! 1729: STBA_R	stba	%r9, [%r24 + %r0] 0x4f
	.word 0xdea4a000  ! 1730: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xdea4a000  ! 1731: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	mov	0x10, %r24
	.word 0xded4a000  ! 1733: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	mov	0x68, %r24
	.word 0xde9c6000  ! 1735: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0xdec4a000  ! 1736: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xdeb4a000  ! 1737: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0xde84a000  ! 1738: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	.word 0xde9ce000  ! 1739: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0xdace09e0  ! 1740: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r13
	.word 0xd2b4a000  ! 1741: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 1742: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r16
	.word 0xd2b4a000  ! 1744: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0xd2d46000  ! 1745: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	.word 0xd2f4e000  ! 1746: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd0b70e80  ! 1747: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	.word 0xd0aca000  ! 1748: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 1749: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 1750: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 1751: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r26
	mov	0x30, %r25
	.word 0xd09d44a0  ! 1754: LDDA_R	ldda	[%r21, %r0] 0x25, %r8
	.word 0xdca7a000  ! 1755: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcbfa000  ! 1756: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdc872000  ! 1757: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcac4400  ! 1758: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	.word 0xd687a000  ! 1759: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0xdc940400  ! 1760: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	mov	0x78, %r17
	.word 0xda8fa000  ! 1762: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xdab7a000  ! 1763: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdaafa000  ! 1764: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdacfa000  ! 1765: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0x87802074  ! 1766: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 1767: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r27
	.word 0xd8f544a0  ! 1769: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	.word 0xd2a7e000  ! 1770: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xdedf4e80  ! 1771: LDXA_R	ldxa	[%r29, %r0] 0x74, %r15
	.word 0xdcc7a000  ! 1772: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcb72000  ! 1773: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xd2dc8400  ! 1774: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	mov	0x78, %r25
	.word 0x87802020  ! 1776: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1777: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2ace000  ! 1778: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 1779: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 1780: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1781: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1782: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f66000  ! 1783: STXA_I	stxa	%r9, [%r25 + 0x0000] %asi
	.word 0xd88f4e60  ! 1784: LDUBA_R	lduba	[%r29, %r0] 0x73, %r12
	.word 0xd49f4e40  ! 1785: LDDA_R	ldda	[%r29, %r0] 0x72, %r10
	.word 0xd0dea000  ! 1786: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r8
	.word 0xd0bfce40  ! 1787: STDA_R	stda	%r8, [%r31 + %r0] 0x72
	.word 0x87802020  ! 1788: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b44400  ! 1789: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	mov	0x7f8, %r21
	mov	0x60, %r18
	.word 0x8780204f  ! 1792: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bcc400  ! 1793: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0xdcbc2000  ! 1794: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xdade49e0  ! 1795: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r13
	.word 0xdec4e000  ! 1796: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	.word 0xdef4a000  ! 1797: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 1798: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f7ce60  ! 1799: STXA_R	stxa	%r9, [%r31 + %r0] 0x73
	.word 0x87802073  ! 1800: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd297e000  ! 1802: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	.word 0xd2a7e000  ! 1803: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xd2c4c400  ! 1804: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	mov	0x0, %r17
	mov	0x8, %r24
	.word 0x87802072  ! 1807: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb78e60  ! 1808: STHA_R	stha	%r15, [%r30 + %r0] 0x73
	.word 0xd4dea000  ! 1809: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	mov	0x60, %r25
	.word 0x87802020  ! 1811: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1812: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a44400  ! 1813: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xd0dfe000  ! 1814: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0cf2000  ! 1815: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 1816: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0cd2000  ! 1817: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r8
	.word 0xd2a7ce60  ! 1818: STWA_R	stwa	%r9, [%r31 + %r0] 0x73
	mov	0x7f8, %r21
	.word 0xdea5e000  ! 1820: STWA_I	stwa	%r15, [%r23 + 0x0000] %asi
	.word 0xdead2000  ! 1821: STBA_I	stba	%r15, [%r20 + 0x0000] %asi
	.word 0xdcd48400  ! 1822: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	mov	0x28, %r26
	.word 0xd0bf4e40  ! 1824: STDA_R	stda	%r8, [%r29 + %r0] 0x72
	.word 0xdccf8e60  ! 1825: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r14
	.word 0xdcdd84a0  ! 1826: LDXA_R	ldxa	[%r22, %r0] 0x25, %r14
	mov	0x7e0, %r23
	mov	0x70, %r24
	.word 0x87802020  ! 1829: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef4a000  ! 1830: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0xdaf649e0  ! 1831: STXA_R	stxa	%r13, [%r25 + %r0] 0x4f
	.word 0xd4c4e000  ! 1832: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r10
	.word 0xd4dca000  ! 1833: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	.word 0xd4c46000  ! 1834: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r10
	.word 0xdaa78e40  ! 1835: STWA_R	stwa	%r13, [%r30 + %r0] 0x72
	.word 0xd8cce000  ! 1836: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r12
	.word 0xde9584a0  ! 1837: LDUHA_R	lduha	[%r22, %r0] 0x25, %r15
	.word 0xdeb42000  ! 1838: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0xdec4e000  ! 1839: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	.word 0xde870e40  ! 1840: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r15
	.word 0xd49649e0  ! 1841: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r10
	mov	0x3e8, %r22
	.word 0x87802025  ! 1843: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cfce80  ! 1844: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r10
	.word 0x87802074  ! 1845: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8a72000  ! 1846: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	mov	0x0, %r25
	.word 0x87802074  ! 1848: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8b5a000  ! 1849: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	.word 0xd8f5e000  ! 1850: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	.word 0xded44400  ! 1851: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	.word 0xd8a74e40  ! 1852: STWA_R	stwa	%r12, [%r29 + %r0] 0x72
	.word 0xd6b609e0  ! 1853: STHA_R	stha	%r11, [%r24 + %r0] 0x4f
	.word 0xd4ad6000  ! 1854: STBA_I	stba	%r10, [%r21 + 0x0000] %asi
	.word 0xd0970e40  ! 1855: LDUHA_R	lduha	[%r28, %r0] 0x72, %r8
	.word 0xd0dc0400  ! 1856: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xde85e000  ! 1857: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r15
	.word 0x87802074  ! 1858: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 1859: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 1860: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdedfe000  ! 1861: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	mov	0x7c8, %r22
	.word 0xded76000  ! 1863: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	mov	0x7e0, %r21
	.word 0xde9fa000  ! 1865: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	.word 0x87802074  ! 1866: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc870e60  ! 1867: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r14
	.word 0xd0a40400  ! 1868: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0xdaa6e000  ! 1869: STWA_I	stwa	%r13, [%r27 + 0x0000] %asi
	.word 0x87802073  ! 1870: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdacf2000  ! 1871: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xdcafce60  ! 1872: STBA_R	stba	%r14, [%r31 + %r0] 0x73
	.word 0xd4d72000  ! 1873: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	mov	0x50, %r17
	.word 0x87802020  ! 1875: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a76000  ! 1876: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd48fa000  ! 1877: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xd8af0e60  ! 1878: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	.word 0x87802074  ! 1879: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1880: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r27
	.word 0xd4872000  ! 1882: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	mov	0x0, %r25
	.word 0xdef74e40  ! 1884: STXA_R	stxa	%r15, [%r29 + %r0] 0x72
	mov	0x20, %r24
	mov	0x48, %r26
	.word 0xd6cfe000  ! 1887: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0xd6bfe000  ! 1888: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xdaf44400  ! 1889: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0x87802020  ! 1890: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6970e60  ! 1891: LDUHA_R	lduha	[%r28, %r0] 0x73, %r11
	.word 0xdadfce40  ! 1892: LDXA_R	ldxa	[%r31, %r0] 0x72, %r13
	mov	0x8, %r16
	mov	0x7f0, %r23
	mov	0x18, %r25
	.word 0x87802020  ! 1896: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r21
	mov	0x30, %r27
	.word 0xd8bf2000  ! 1899: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	mov	0x50, %r24
	mov	0x30, %r27
	.word 0xd8dd44a0  ! 1902: LDXA_R	ldxa	[%r21, %r0] 0x25, %r12
	.word 0xd68fa000  ! 1903: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0xd6afa000  ! 1904: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x38, %r26
	mov	0x10, %r24
	.word 0xdeb44400  ! 1907: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0xd6f72000  ! 1908: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6a72000  ! 1909: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xdad70e40  ! 1910: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r13
	.word 0xdecf8e60  ! 1911: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r15
	mov	0x68, %r19
	.word 0x87802020  ! 1913: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c689e0  ! 1914: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r10
	.word 0xda840400  ! 1915: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	.word 0xdeaec9e0  ! 1916: STBA_R	stba	%r15, [%r27 + %r0] 0x4f
	mov	0x70, %r25
	.word 0xdea6a000  ! 1918: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xdea6a000  ! 1920: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	.word 0xd4af8e80  ! 1921: STBA_R	stba	%r10, [%r30 + %r0] 0x74
	.word 0xd29f0e60  ! 1922: LDDA_R	ldda	[%r28, %r0] 0x73, %r9
	.word 0xdc9649e0  ! 1923: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r14
	.word 0xd6dfce60  ! 1924: LDXA_R	ldxa	[%r31, %r0] 0x73, %r11
	.word 0xd0be2000  ! 1925: STDA_I	stda	%r8, [%r24 + 0x0000] %asi
	.word 0xd09e6000  ! 1926: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r8
	.word 0xd4ad84a0  ! 1927: STBA_R	stba	%r10, [%r22 + %r0] 0x25
	.word 0xda8d84a0  ! 1928: LDUBA_R	lduba	[%r22, %r0] 0x25, %r13
	.word 0xdebea000  ! 1929: STDA_I	stda	%r15, [%r26 + 0x0000] %asi
	.word 0xde9e2000  ! 1930: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r15
	mov	0x7e0, %r22
	.word 0xd8a70e40  ! 1932: STWA_R	stwa	%r12, [%r28 + %r0] 0x72
	.word 0xd2c609e0  ! 1933: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r9
	.word 0xd6c62000  ! 1934: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r11
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x30, %r17
	.word 0xd8cf0e80  ! 1937: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r12
	.word 0xde8e6000  ! 1938: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r15
	.word 0xdef6a000  ! 1939: STXA_I	stxa	%r15, [%r26 + 0x0000] %asi
	.word 0x87802074  ! 1940: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r17
	.word 0xd89649e0  ! 1942: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r12
	.word 0x87802020  ! 1943: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f5a000  ! 1944: STXA_I	stxa	%r11, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 1945: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdede49e0  ! 1946: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r15
	mov	0x7c8, %r23
	wr_tick_cmpr_1_16:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf6, %g2
	or	%g4, 0xf1, %g4
	or	%g6, 0x89, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3f0, %r20
	.word 0xd0b689e0  ! 1950: STHA_R	stha	%r8, [%r26 + %r0] 0x4f
	.word 0xd4dc2000  ! 1951: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	.word 0xd4bc6000  ! 1952: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	mov	0x48, %r25
	.word 0xd6b70e60  ! 1954: STHA_R	stha	%r11, [%r28 + %r0] 0x73
	.word 0x87802073  ! 1955: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f7ce80  ! 1956: STXA_R	stxa	%r12, [%r31 + %r0] 0x74
	mov	0x48, %r16
	.word 0xd8dda000  ! 1958: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r12
	.word 0xd8cd04a0  ! 1959: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r12
	.word 0x87802072  ! 1960: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 1961: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2aec9e0  ! 1962: STBA_R	stba	%r9, [%r27 + %r0] 0x4f
	.word 0xdaf4a000  ! 1963: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	mov	0x58, %r16
	.word 0x87802020  ! 1965: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r17
	.word 0xd4f609e0  ! 1967: STXA_R	stxa	%r10, [%r24 + %r0] 0x4f
	.word 0xd29689e0  ! 1968: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r9
	.word 0xd286e000  ! 1969: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r9
	mov	0x28, %r16
	mov	0x58, %r19
	.word 0xd2b6a000  ! 1972: STHA_I	stha	%r9, [%r26 + 0x0000] %asi
	.word 0xd2dee000  ! 1973: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r9
	mov	0x70, %r18
	.word 0x87802074  ! 1975: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r18
	.word 0xd2dce000  ! 1977: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1978: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28544a0  ! 1979: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r9
	mov	0x38, %r25
	.word 0xd2dfa000  ! 1981: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xd6848400  ! 1982: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	.word 0x87802073  ! 1983: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda944400  ! 1984: LDUHA_R	lduha	[%r17, %r0] 0x20, %r13
	.word 0x8780204f  ! 1985: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdadfa000  ! 1986: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xd4bc0400  ! 1987: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xdcdf8e60  ! 1988: LDXA_R	ldxa	[%r30, %r0] 0x73, %r14
	mov	0x10, %r25
	.word 0xd8bf0e80  ! 1990: STDA_R	stda	%r12, [%r28 + %r0] 0x74
	mov	0x8, %r18
	.word 0xd6af6000  ! 1992: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xdebf8e60  ! 1993: STDA_R	stda	%r15, [%r30 + %r0] 0x73
	.word 0x87802020  ! 1994: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1995: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8852000  ! 1996: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r12
	.word 0xd8d52000  ! 1997: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1998: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r26
	.word 0xd8f4c400  ! 2000: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0x87802020  ! 2001: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0d609e0  ! 2002: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r8
	.word 0x8780204f  ! 2003: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b42000  ! 2004: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xd49f0e80  ! 2005: LDDA_R	ldda	[%r28, %r0] 0x74, %r10
	mov	0x3c0, %r20
	mov	0x40, %r25
	.word 0xde942000  ! 2008: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	.word 0xdaf44400  ! 2009: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0xd49c2000  ! 2010: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	.word 0x87802073  ! 2011: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4bda000  ! 2012: STDA_I	stda	%r10, [%r22 + 0x0000] %asi
	.word 0xd6978e80  ! 2013: LDUHA_R	lduha	[%r30, %r0] 0x74, %r11
	.word 0x87802072  ! 2014: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 2015: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 2016: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc96c9e0  ! 2017: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r14
	.word 0xde8c2000  ! 2018: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	mov	0x68, %r18
	.word 0xde9c6000  ! 2020: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	mov	0x78, %r26
	mov	0x50, %r17
	.word 0xde8f8e40  ! 2023: LDUBA_R	lduba	[%r30, %r0] 0x72, %r15
	mov	0x60, %r26
	.word 0xd894e000  ! 2025: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r12
	mov	0x28, %r18
	.word 0x87802020  ! 2027: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8cfe000  ! 2028: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xd2ae49e0  ! 2029: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 2030: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcafa000  ! 2031: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xdca74e40  ! 2032: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	mov	0x38, %r27
	.word 0xdaf76000  ! 2034: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdcf6c9e0  ! 2035: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	.word 0x8780204f  ! 2036: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d8, %r21
	.word 0x87802025  ! 2038: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaae09e0  ! 2039: STBA_R	stba	%r13, [%r24 + %r0] 0x4f
	.word 0xdeb7a000  ! 2040: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	mov	0x58, %r27
	.word 0xded7a000  ! 2042: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xded584a0  ! 2043: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r15
	.word 0x87802020  ! 2044: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r21
	.word 0xdabc8400  ! 2046: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	mov	0x70, %r19
	mov	0x30, %r16
	.word 0xd29c6000  ! 2049: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	mov	0x68, %r18
	.word 0xd2aca000  ! 2051: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	mov	0x50, %r27
	.word 0xd2f4a000  ! 2053: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 2054: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r16
	mov	0x3c8, %r22
	.word 0xd2d7a000  ! 2057: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2058: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b46000  ! 2059: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 2060: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bfa000  ! 2061: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 2062: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2942000  ! 2063: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2ac6000  ! 2064: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 2065: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bc0400  ! 2066: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xd4dc4400  ! 2067: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	.word 0xd0af0e80  ! 2068: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	.word 0xd2ade000  ! 2069: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	wr_tick_cmpr_1_17:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xd6, %g2
	or	%g4, 0xfe, %g4
	or	%g6, 0x86, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x70, %r25
	.word 0x87802074  ! 2072: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r25
	.word 0xd29c6000  ! 2074: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	.word 0xd2ac2000  ! 2075: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd8a78e80  ! 2076: STWA_R	stwa	%r12, [%r30 + %r0] 0x74
	mov	0x3f0, %r21
	.word 0xd2ac2000  ! 2078: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd0b7ce60  ! 2079: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	.word 0xdc9ce000  ! 2080: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r14
	.word 0xdcac6000  ! 2081: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xdcbca000  ! 2082: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdca46000  ! 2083: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xd28689e0  ! 2084: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r9
	mov	0x3e0, %r21
	mov	0x40, %r27
	.word 0xdacc0400  ! 2087: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r13
	.word 0xdaf46000  ! 2088: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	mov	0x70, %r27
	.word 0xdca4c400  ! 2090: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xd6f7ce40  ! 2091: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	.word 0xdaa46000  ! 2092: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	.word 0xdabce000  ! 2093: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0xda8c2000  ! 2094: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r13
	.word 0xdcc78e80  ! 2095: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r14
	.word 0x87802020  ! 2096: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2097: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd89fe000  ! 2098: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0xd087ce60  ! 2099: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r8
	mov	0x3d0, %r20
	.word 0xd8a7e000  ! 2101: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd4bf0e60  ! 2102: STDA_R	stda	%r10, [%r28 + %r0] 0x73
	.word 0x8780204f  ! 2103: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b4e000  ! 2104: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xd8ac0400  ! 2105: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xd487ce60  ! 2106: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r10
	mov	0x3c8, %r20
	.word 0xdcaca000  ! 2108: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xdcc46000  ! 2109: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r14
	.word 0x87802074  ! 2110: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d0, %r23
	mov	0x3f8, %r23
	.word 0xd4978e80  ! 2113: LDUHA_R	lduha	[%r30, %r0] 0x74, %r10
	wr_tick_cmpr_1_18:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe9, %g2
	or	%g4, 0xd9, %g4
	or	%g6, 0xab, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x30, %r18
	mov	0x60, %r25
	.word 0xdea4a000  ! 2117: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 2118: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2119: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a70e40  ! 2120: STWA_R	stwa	%r11, [%r28 + %r0] 0x72
	mov	0x3f0, %r22
	.word 0xd4a6e000  ! 2122: STWA_I	stwa	%r10, [%r27 + 0x0000] %asi
	.word 0xd0df0e40  ! 2123: LDXA_R	ldxa	[%r28, %r0] 0x72, %r8
	.word 0xd4ad44a0  ! 2124: STBA_R	stba	%r10, [%r21 + %r0] 0x25
	.word 0xd2be2000  ! 2125: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	mov	0x70, %r27
	.word 0xdeb40400  ! 2127: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0xd0a6c9e0  ! 2128: STWA_R	stwa	%r8, [%r27 + %r0] 0x4f
	.word 0x8780204f  ! 2129: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0ae09e0  ! 2130: STBA_R	stba	%r8, [%r24 + %r0] 0x4f
	.word 0xdc8e49e0  ! 2131: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r14
	mov	0x20, %r19
	.word 0x87802074  ! 2133: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f5c4a0  ! 2134: STXA_R	stxa	%r11, [%r23 + %r0] 0x25
	.word 0xd2b504a0  ! 2135: STHA_R	stha	%r9, [%r20 + %r0] 0x25
	.word 0xdabee000  ! 2136: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	.word 0xdace6000  ! 2137: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r13
	.word 0xda86a000  ! 2138: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r13
	.word 0xdaa6e000  ! 2139: STWA_I	stwa	%r13, [%r27 + 0x0000] %asi
	mov	0x8, %r24
	.word 0xd6ad84a0  ! 2141: STBA_R	stba	%r11, [%r22 + %r0] 0x25
	.word 0xdab4c400  ! 2142: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	mov	0x18, %r17
	mov	0x70, %r18
	.word 0xd8f62000  ! 2145: STXA_I	stxa	%r12, [%r24 + 0x0000] %asi
	.word 0xd8b6e000  ! 2146: STHA_I	stha	%r12, [%r27 + 0x0000] %asi
	.word 0xd2c5c4a0  ! 2147: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r9
	.word 0xd2a62000  ! 2148: STWA_I	stwa	%r9, [%r24 + 0x0000] %asi
	.word 0xd2be2000  ! 2149: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	.word 0xd2cea000  ! 2150: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r9
	.word 0xd286a000  ! 2151: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r9
	.word 0xde874e60  ! 2152: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r15
	.word 0xd6d66000  ! 2153: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r11
	mov	0x78, %r25
	.word 0xd69ea000  ! 2155: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r11
	mov	0x38, %r24
	.word 0xd6f78e80  ! 2157: STXA_R	stxa	%r11, [%r30 + %r0] 0x74
	.word 0x87802025  ! 2158: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c0, %r22
	.word 0xd0f42000  ! 2160: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 2161: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 2162: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r25
	.word 0xd4d4c400  ! 2164: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0xd8b6c9e0  ! 2165: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 2166: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r27
	.word 0xdad7e000  ! 2168: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	mov	0x60, %r24
	.word 0xdab72000  ! 2170: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdaae49e0  ! 2171: STBA_R	stba	%r13, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 2172: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r26
	.word 0xdabfa000  ! 2174: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	mov	0x18, %r19
	mov	0x7d0, %r22
	mov	0x3d8, %r21
	.word 0xdaf76000  ! 2178: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 2179: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 2180: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabc6000  ! 2181: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xdacc2000  ! 2182: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xdadca000  ! 2183: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0xdaf46000  ! 2184: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0xd68c8400  ! 2185: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	mov	0x7d0, %r22
	.word 0x87802020  ! 2187: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2188: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f70e40  ! 2189: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	.word 0xdcf46000  ! 2190: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xd8a609e0  ! 2191: STWA_R	stwa	%r12, [%r24 + %r0] 0x4f
	.word 0x87802074  ! 2192: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda8689e0  ! 2193: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r13
	.word 0x87802020  ! 2194: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r22
	.word 0xdcad2000  ! 2196: STBA_I	stba	%r14, [%r20 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xd4844400  ! 2198: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	mov	0x78, %r27
	.word 0xd8a609e0  ! 2200: STWA_R	stwa	%r12, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 2201: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2202: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r24
	.word 0xd08c6000  ! 2204: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0xd6f4c400  ! 2205: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0x87802074  ! 2206: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8a609e0  ! 2207: STWA_R	stwa	%r12, [%r24 + %r0] 0x4f
	.word 0xd0dfe000  ! 2208: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0b76000  ! 2210: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd08f6000  ! 2211: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r8
	mov	0x7c0, %r21
	.word 0xd0b7ce40  ! 2213: STHA_R	stha	%r8, [%r31 + %r0] 0x72
	.word 0xdef76000  ! 2214: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0xdeaf0e40  ! 2216: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	.word 0xd287a000  ! 2217: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	mov	0x38, %r26
	mov	0x20, %r17
	.word 0xd2b76000  ! 2220: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd29fe000  ! 2221: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	mov	0x7c0, %r21
	.word 0xd484c400  ! 2223: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	.word 0xd08ec9e0  ! 2224: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r8
	.word 0xdeb7e000  ! 2225: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xdeafa000  ! 2226: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xde8649e0  ! 2227: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r15
	mov	0x7f0, %r20
	.word 0xd8f74e80  ! 2229: STXA_R	stxa	%r12, [%r29 + %r0] 0x74
	.word 0xd4cf2000  ! 2230: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd49fa000  ! 2231: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0x87802074  ! 2232: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd494e000  ! 2233: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	.word 0xd4f46000  ! 2234: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	wr_tick_cmpr_1_19:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xfb, %g2
	or	%g4, 0xc9, %g4
	or	%g6, 0xf5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802025  ! 2236: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdacd44a0  ! 2237: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r13
	mov	0x50, %r27
	.word 0xde8fce40  ! 2239: LDUBA_R	lduba	[%r31, %r0] 0x72, %r15
	.word 0xd6acc400  ! 2240: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xdecc0400  ! 2241: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r15
	.word 0xd894a000  ! 2242: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r12
	.word 0xd8c46000  ! 2243: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r12
	mov	0x68, %r16
	.word 0xd6d78e80  ! 2245: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r11
	.word 0xdcc4e000  ! 2246: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r14
	.word 0xda8cc400  ! 2247: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	.word 0xd28c0400  ! 2248: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	.word 0xdc8c6000  ! 2249: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r14
	.word 0xd8b78e80  ! 2250: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	.word 0xdeacc400  ! 2251: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xd4dc0400  ! 2252: LDXA_R	ldxa	[%r16, %r0] 0x20, %r10
	.word 0xde8c2000  ! 2253: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	.word 0x87802020  ! 2254: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebe2000  ! 2255: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	.word 0x8780204f  ! 2256: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd89dc4a0  ! 2257: LDDA_R	ldda	[%r23, %r0] 0x25, %r12
	.word 0xdadc8400  ! 2258: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	.word 0xd2f56000  ! 2259: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	.word 0xd2ad6000  ! 2260: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0x87802074  ! 2261: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r24
	.word 0xd2c76000  ! 2263: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	wr_tick_cmpr_1_20:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x93, %g2
	or	%g4, 0xad, %g4
	or	%g6, 0xaa, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	wr_tick_cmpr_1_21:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x8e, %g2
	or	%g4, 0xe1, %g4
	or	%g6, 0xc3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd287e000  ! 2266: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2267: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bfe000  ! 2268: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2269: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r22
	.word 0xd68f0e80  ! 2271: LDUBA_R	lduba	[%r28, %r0] 0x74, %r11
	.word 0xd885a000  ! 2272: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r12
	.word 0xde940400  ! 2273: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0xd0d52000  ! 2274: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r8
	.word 0x87802025  ! 2275: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0ccc400  ! 2276: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	.word 0xdebc2000  ! 2277: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xdedca000  ! 2278: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xde846000  ! 2279: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0x87802074  ! 2280: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8ad04a0  ! 2281: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	mov	0x48, %r25
	.word 0xd6d5e000  ! 2283: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r11
	mov	0x10, %r19
	.word 0xd685a000  ! 2285: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 2286: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd68d2000  ! 2287: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r11
	.word 0xd6bda000  ! 2288: STDA_I	stda	%r11, [%r22 + 0x0000] %asi
	.word 0x87802025  ! 2289: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r16
	.word 0xd6bd6000  ! 2291: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0x87802025  ! 2292: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0dd84a0  ! 2293: LDXA_R	ldxa	[%r22, %r0] 0x25, %r8
	mov	0x40, %r19
	.word 0xd2be89e0  ! 2295: STDA_R	stda	%r9, [%r26 + %r0] 0x4f
	.word 0xd6a66000  ! 2296: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	mov	0x70, %r18
	.word 0x87802074  ! 2298: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4d74e80  ! 2299: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r10
	.word 0xdab7a000  ! 2300: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xd8b70e40  ! 2301: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0xdab7a000  ! 2302: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 2303: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r26
	.word 0xdabce000  ! 2305: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0xdabc2000  ! 2306: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xdadc6000  ! 2307: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xdacc6000  ! 2308: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	.word 0xd6d78e60  ! 2309: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r11
	.word 0xd6dce000  ! 2310: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	mov	0x70, %r19
	mov	0x8, %r27
	.word 0xd6bc6000  ! 2313: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0xda87ce40  ! 2314: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r13
	.word 0xdab584a0  ! 2315: STHA_R	stha	%r13, [%r22 + %r0] 0x25
	.word 0xd8a4a000  ! 2316: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8c42000  ! 2317: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r12
	mov	0x0, %r27
	.word 0xd8a42000  ! 2319: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	mov	0x8, %r24
	.word 0xd8af0e40  ! 2321: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	.word 0xdeb4e000  ! 2322: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0xd8f584a0  ! 2323: STXA_R	stxa	%r12, [%r22 + %r0] 0x25
	.word 0xd29c8400  ! 2324: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	.word 0xd4ace000  ! 2325: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0xd4dce000  ! 2326: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	mov	0x30, %r24
	.word 0xd6f544a0  ! 2328: STXA_R	stxa	%r11, [%r21 + %r0] 0x25
	.word 0xd08c2000  ! 2329: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0xd08ce000  ! 2330: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xd4978e40  ! 2331: LDUHA_R	lduha	[%r30, %r0] 0x72, %r10
	.word 0xde8f0e80  ! 2332: LDUBA_R	lduba	[%r28, %r0] 0x74, %r15
	.word 0xd0d74e80  ! 2333: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r8
	mov	0x3d0, %r21
	.word 0xd2a7ce60  ! 2335: STWA_R	stwa	%r9, [%r31 + %r0] 0x73
	.word 0xdaf40400  ! 2336: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	mov	0x38, %r17
	.word 0x87802020  ! 2338: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r19
	.word 0xd8a42000  ! 2340: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8b4e000  ! 2341: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0xd89c2000  ! 2342: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	.word 0xd8f42000  ! 2343: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8ace000  ! 2344: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0xd884e000  ! 2345: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r12
	.word 0x87802025  ! 2346: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde878e60  ! 2347: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r15
	.word 0xd2c544a0  ! 2348: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r9
	.word 0xd2b5c4a0  ! 2349: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	.word 0xdeb7a000  ! 2350: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xdec76000  ! 2351: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xd0ce89e0  ! 2352: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r8
	mov	0x58, %r25
	.word 0xdca40400  ! 2354: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	mov	0x8, %r17
	mov	0x78, %r25
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802020  ! 2358: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r20
	.word 0x87802025  ! 2360: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4d5a000  ! 2361: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r10
	.word 0xd2cf8e80  ! 2362: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r9
	.word 0xdc8d2000  ! 2363: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r14
	.word 0x87802074  ! 2364: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r16
	.word 0xdc872000  ! 2366: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	mov	0x3c0, %r20
	.word 0xdc8fce60  ! 2368: LDUBA_R	lduba	[%r31, %r0] 0x73, %r14
	.word 0xd08d04a0  ! 2369: LDUBA_R	lduba	[%r20, %r0] 0x25, %r8
	.word 0xdeb76000  ! 2370: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xd8c6c9e0  ! 2371: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r12
	.word 0xdadfa000  ! 2372: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	mov	0x7c8, %r20
	.word 0xdaafa000  ! 2374: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdaf76000  ! 2375: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	mov	0x8, %r27
	.word 0xda9f2000  ! 2377: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0x87802072  ! 2378: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49fce40  ! 2379: LDDA_R	ldda	[%r31, %r0] 0x72, %r10
	.word 0xd28e89e0  ! 2380: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r9
	mov	0x28, %r16
	mov	0x38, %r18
	mov	0x58, %r19
	.word 0xd8d4a000  ! 2384: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xdab7ce40  ! 2385: STHA_R	stha	%r13, [%r31 + %r0] 0x72
	.word 0x87802073  ! 2386: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda866000  ! 2387: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r13
	.word 0xd2bd44a0  ! 2388: STDA_R	stda	%r9, [%r21 + %r0] 0x25
	.word 0xd0a649e0  ! 2389: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	.word 0x87802073  ! 2390: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2cf8e80  ! 2391: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r9
	wr_tick_cmpr_1_22:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb3, %g2
	or	%g4, 0xa2, %g4
	or	%g6, 0xeb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2974e40  ! 2393: LDUHA_R	lduha	[%r29, %r0] 0x72, %r9
	.word 0xd2dea000  ! 2394: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r9
	.word 0xd2f6a000  ! 2395: STXA_I	stxa	%r9, [%r26 + 0x0000] %asi
	.word 0xd8adc4a0  ! 2396: STBA_R	stba	%r12, [%r23 + %r0] 0x25
	.word 0x87802072  ! 2397: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdac66000  ! 2398: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2399: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8cd84a0  ! 2400: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r12
	.word 0x87802074  ! 2401: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 2402: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf689e0  ! 2403: STXA_R	stxa	%r14, [%r26 + %r0] 0x4f
	.word 0xd8a7a000  ! 2404: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xde978e40  ! 2405: LDUHA_R	lduha	[%r30, %r0] 0x72, %r15
	.word 0x87802073  ! 2406: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f42000  ! 2407: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	mov	0x68, %r17
	mov	0x7c0, %r21
	.word 0xd49f0e80  ! 2410: LDDA_R	ldda	[%r28, %r0] 0x74, %r10
	.word 0xd0bce000  ! 2411: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	mov	0x10, %r16
	.word 0xd0f46000  ! 2413: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xdeafce80  ! 2414: STBA_R	stba	%r15, [%r31 + %r0] 0x74
	.word 0xdccc6000  ! 2415: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	.word 0xd4bf8e60  ! 2416: STDA_R	stda	%r10, [%r30 + %r0] 0x73
	.word 0xdaf609e0  ! 2417: STXA_R	stxa	%r13, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 2418: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r18
	.word 0xd2bdc4a0  ! 2420: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	.word 0xd4be6000  ! 2421: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0xd4ac4400  ! 2422: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xd0f6e000  ! 2423: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	.word 0xd0bc0400  ! 2424: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0xd4aea000  ! 2425: STBA_I	stba	%r10, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 2426: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2427: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r26
	mov	0x3c8, %r22
	mov	0x48, %r24
	mov	0x70, %r18
	mov	0x7e8, %r20
	.word 0xd29c0400  ! 2433: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	.word 0xde8c2000  ! 2434: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	.word 0x87802074  ! 2435: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xded6a000  ! 2436: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r15
	.word 0xdea6e000  ! 2437: STWA_I	stwa	%r15, [%r27 + 0x0000] %asi
	.word 0xdadc8400  ! 2438: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	.word 0xdc9dc4a0  ! 2439: LDDA_R	ldda	[%r23, %r0] 0x25, %r14
	mov	0x78, %r26
	mov	0x78, %r25
	.word 0x87802020  ! 2442: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b584a0  ! 2443: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	mov	0x60, %r18
	mov	0x20, %r18
	mov	0x0, %r25
	mov	0x7f8, %r23
	.word 0xd296e000  ! 2448: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r9
	.word 0xda8609e0  ! 2449: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r13
	.word 0xd4a504a0  ! 2450: STWA_R	stwa	%r10, [%r20 + %r0] 0x25
	.word 0xdacee000  ! 2451: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r13
	wr_tick_cmpr_1_23:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe6, %g2
	or	%g4, 0x97, %g4
	or	%g6, 0xd1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdab40400  ! 2453: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xd48ea000  ! 2454: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r10
	.word 0x87802073  ! 2455: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2456: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bc6000  ! 2457: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xd6d44400  ! 2458: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r11
	.word 0xdabce000  ! 2459: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 2460: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdacd6000  ! 2461: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r13
	.word 0xd0f78e40  ! 2462: STXA_R	stxa	%r8, [%r30 + %r0] 0x72
	.word 0xd6dd6000  ! 2463: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r11
	.word 0xd6b52000  ! 2464: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	.word 0xd6dd6000  ! 2465: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r11
	.word 0xd6d78e80  ! 2466: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r11
	.word 0xd29689e0  ! 2467: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r9
	.word 0xdc8d6000  ! 2468: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r14
	.word 0xdeccc400  ! 2469: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r15
	.word 0x87802020  ! 2470: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r21
	.word 0x87802020  ! 2472: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde848400  ! 2473: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	mov	0x7e0, %r23
	.word 0xdef46000  ! 2475: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xd8cf8e40  ! 2476: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r12
	.word 0xd0a609e0  ! 2477: STWA_R	stwa	%r8, [%r24 + %r0] 0x4f
	mov	0x68, %r25
	.word 0xd4878e40  ! 2479: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r10
	.word 0xdcf4e000  ! 2480: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcb4a000  ! 2481: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xdca42000  ! 2482: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xd09f0e80  ! 2483: LDDA_R	ldda	[%r28, %r0] 0x74, %r8
	.word 0xd4a74e60  ! 2484: STWA_R	stwa	%r10, [%r29 + %r0] 0x73
	mov	0x7d8, %r21
	.word 0xd8f46000  ! 2486: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xdeac4400  ! 2487: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0x87802020  ! 2488: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2489: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeb5a000  ! 2490: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	.word 0xda9fce40  ! 2491: LDDA_R	ldda	[%r31, %r0] 0x72, %r13
	.word 0x87802020  ! 2492: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r26
	.word 0xda842000  ! 2494: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r13
	.word 0xdab4e000  ! 2495: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xd4874e60  ! 2496: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r10
	.word 0xdc87ce40  ! 2497: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r14
	.word 0xdc9dc4a0  ! 2498: LDDA_R	ldda	[%r23, %r0] 0x25, %r14
	mov	0x3f0, %r23
	mov	0x3f8, %r23
	mov	0x7c0, %r20
	.word 0xd08609e0  ! 2502: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r8
	.word 0xd0f74e80  ! 2503: STXA_R	stxa	%r8, [%r29 + %r0] 0x74
	.word 0xd69d04a0  ! 2504: LDDA_R	ldda	[%r20, %r0] 0x25, %r11
	.word 0xdcaca000  ! 2505: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xde840400  ! 2506: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	.word 0xd28d84a0  ! 2507: LDUBA_R	lduba	[%r22, %r0] 0x25, %r9
	.word 0x87802025  ! 2508: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd884c400  ! 2509: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	.word 0xd0cce000  ! 2510: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	mov	0x58, %r16
	.word 0xd497ce80  ! 2512: LDUHA_R	lduha	[%r31, %r0] 0x74, %r10
	.word 0xd49ce000  ! 2513: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0xd4d4e000  ! 2514: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0xd6bf0e60  ! 2515: STDA_R	stda	%r11, [%r28 + %r0] 0x73
	.word 0xd4a46000  ! 2516: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xdeb7ce60  ! 2517: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	.word 0xd4c4a000  ! 2518: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	.word 0xd494a000  ! 2519: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r10
	.word 0xd4cc6000  ! 2520: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	mov	0x7e8, %r20
	.word 0xdc8c8400  ! 2522: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0xd6cd44a0  ! 2523: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r11
	.word 0xdebc2000  ! 2524: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xde84a000  ! 2525: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	mov	0x3f0, %r23
	.word 0xdec42000  ! 2527: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0xdeac2000  ! 2528: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	mov	0x20, %r18
	.word 0xdecc6000  ! 2530: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r15
	.word 0x87802020  ! 2531: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde942000  ! 2532: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	.word 0xd4b44400  ! 2533: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	.word 0xd8f48400  ! 2534: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xd68ce000  ! 2535: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2536: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b4a000  ! 2537: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 2538: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdac48400  ! 2539: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	.word 0xd4de89e0  ! 2540: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r10
	.word 0xd4bc8400  ! 2541: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	.word 0xd0d7ce40  ! 2542: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r8
	.word 0xd4c44400  ! 2543: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r10
	mov	0x3f0, %r23
	.word 0x87802073  ! 2545: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeafa000  ! 2546: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xd2f609e0  ! 2547: STXA_R	stxa	%r9, [%r24 + %r0] 0x4f
	mov	0x58, %r25
	.word 0xd8b72000  ! 2549: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd8f7e000  ! 2550: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	mov	0x0, %r17
	.word 0xd88f6000  ! 2552: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xd8b7e000  ! 2553: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0xd2cc8400  ! 2554: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0xd2afe000  ! 2555: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd6f48400  ! 2556: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xdca7e000  ! 2557: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcd70e60  ! 2558: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r14
	.word 0xdab6c9e0  ! 2559: STHA_R	stha	%r13, [%r27 + %r0] 0x4f
	.word 0xd4d6c9e0  ! 2560: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r10
	mov	0x3d8, %r20
	mov	0x48, %r18
	mov	0x3c0, %r20
	.word 0xdabc8400  ! 2564: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	mov	0x48, %r17
	mov	0x3f8, %r22
	.word 0x87802073  ! 2567: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcdde000  ! 2568: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	.word 0xdc9d2000  ! 2569: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r14
	.word 0xdaa544a0  ! 2570: STWA_R	stwa	%r13, [%r21 + %r0] 0x25
	.word 0xdede49e0  ! 2571: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r15
	mov	0x40, %r25
	.word 0xd8b52000  ! 2573: STHA_I	stha	%r12, [%r20 + 0x0000] %asi
	.word 0xd8dda000  ! 2574: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r12
	.word 0xdcb7ce60  ! 2575: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	.word 0xd0ac4400  ! 2576: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0xd08c8400  ! 2577: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0xda952000  ! 2578: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r13
	.word 0xdaf5a000  ! 2579: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xda9d6000  ! 2580: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r13
	.word 0xd4acc400  ! 2581: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xd8ada000  ! 2582: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0xdecc8400  ! 2583: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	.word 0xdec52000  ! 2584: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r15
	.word 0xdea52000  ! 2585: STWA_I	stwa	%r15, [%r20 + 0x0000] %asi
	.word 0x87802025  ! 2586: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 2587: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaaf4e80  ! 2588: STBA_R	stba	%r13, [%r29 + %r0] 0x74
	.word 0xd4d52000  ! 2589: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r10
	.word 0x87802073  ! 2590: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r24
	.word 0xd2b40400  ! 2592: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0xdacd44a0  ! 2593: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r13
	mov	0x7e8, %r22
	.word 0xd4a40400  ! 2595: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	.word 0xd4ada000  ! 2596: STBA_I	stba	%r10, [%r22 + 0x0000] %asi
	.word 0xd4ade000  ! 2597: STBA_I	stba	%r10, [%r23 + 0x0000] %asi
	.word 0xd4952000  ! 2598: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r10
	wr_tick_cmpr_1_24:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb9, %g2
	or	%g4, 0xfb, %g4
	or	%g6, 0xaf, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8bcc400  ! 2600: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 2601: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2602: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabc8400  ! 2603: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	.word 0xd08f8e60  ! 2604: LDUBA_R	lduba	[%r30, %r0] 0x73, %r8
	.word 0xdac649e0  ! 2605: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r13
	.word 0xd2cc2000  ! 2606: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r9
	.word 0xd2c4e000  ! 2607: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	mov	0x10, %r16
	mov	0x78, %r26
	.word 0xd4b48400  ! 2610: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0x87802074  ! 2611: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf7ce40  ! 2612: STXA_R	stxa	%r14, [%r31 + %r0] 0x72
	.word 0x87802020  ! 2613: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2614: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2615: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0d7e000  ! 2616: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0x87802073  ! 2617: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a66000  ! 2618: STWA_I	stwa	%r8, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 2619: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea40400  ! 2620: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	mov	0x10, %r19
	.word 0x87802020  ! 2622: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r22
	mov	0x58, %r17
	.word 0xd4c6e000  ! 2625: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r10
	.word 0xd48e6000  ! 2626: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r10
	.word 0xd49ea000  ! 2627: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	.word 0xd4cea000  ! 2628: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r10
	.word 0x87802020  ! 2629: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c4e000  ! 2630: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r10
	.word 0xd4f46000  ! 2631: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0xdad7ce60  ! 2632: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r13
	.word 0xd8dc6000  ! 2633: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	wr_tick_cmpr_1_25:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd6, %g2
	or	%g4, 0xa5, %g4
	or	%g6, 0xe3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7f8, %r21
	.word 0xd8f46000  ! 2636: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 2637: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48f0e60  ! 2638: LDUBA_R	lduba	[%r28, %r0] 0x73, %r10
	.word 0x8780204f  ! 2639: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r24
	.word 0xdca5c4a0  ! 2641: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	.word 0xd6862000  ! 2642: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r11
	.word 0xd6dea000  ! 2643: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r11
	.word 0xd68ea000  ! 2644: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r11
	.word 0xd6a6a000  ! 2645: STWA_I	stwa	%r11, [%r26 + 0x0000] %asi
	mov	0x0, %r17
	mov	0x3e0, %r21
	.word 0x87802073  ! 2648: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f4a000  ! 2649: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 2650: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6d7e000  ! 2651: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	.word 0xd6cf2000  ! 2652: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0xd6b7a000  ! 2653: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd6dfa000  ! 2654: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0xdc970e80  ! 2655: LDUHA_R	lduha	[%r28, %r0] 0x74, %r14
	.word 0xde87a000  ! 2656: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0x87802025  ! 2657: WRASI_I	wr	%r0, 0x0025, %asi
	wr_tick_cmpr_1_26:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe9, %g2
	or	%g4, 0xa6, %g4
	or	%g6, 0xef, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdecfa000  ! 2659: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0x87802074  ! 2660: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2661: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r18
	.word 0xd6cf8e60  ! 2663: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r11
	.word 0xde95e000  ! 2664: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r15
	.word 0xdeac8400  ! 2665: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xd09d2000  ! 2666: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r8
	.word 0xd8d48400  ! 2667: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0xdebdc4a0  ! 2668: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	mov	0x20, %r16
	.word 0xdcf689e0  ! 2670: STXA_R	stxa	%r14, [%r26 + %r0] 0x4f
	.word 0xd4956000  ! 2671: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r10
	.word 0xd4f5e000  ! 2672: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	.word 0xd4d5a000  ! 2673: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r10
	.word 0xd4f5e000  ! 2674: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0x87802073  ! 2676: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcc44400  ! 2677: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xd8bce000  ! 2678: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd0d649e0  ! 2679: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r8
	.word 0xd4a42000  ! 2680: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 2681: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r19
	.word 0xd4cce000  ! 2683: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	.word 0xd4dc2000  ! 2684: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	mov	0x30, %r18
	.word 0xdcf649e0  ! 2686: STXA_R	stxa	%r14, [%r25 + %r0] 0x4f
	.word 0x87802074  ! 2687: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeb78e60  ! 2688: STHA_R	stha	%r15, [%r30 + %r0] 0x73
	.word 0x8780204f  ! 2689: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8cfe000  ! 2690: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8a72000  ! 2691: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd28fce60  ! 2692: LDUBA_R	lduba	[%r31, %r0] 0x73, %r9
	mov	0x78, %r17
	.word 0xd68f4e40  ! 2694: LDUBA_R	lduba	[%r29, %r0] 0x72, %r11
	mov	0x8, %r18
	mov	0x7d8, %r20
	.word 0x87802020  ! 2697: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdca000  ! 2698: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	mov	0x70, %r26
	.word 0xdca4e000  ! 2700: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcb42000  ! 2701: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xde974e80  ! 2702: LDUHA_R	lduha	[%r29, %r0] 0x74, %r15
	.word 0x87802072  ! 2703: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2704: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeafa000  ! 2705: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xde8fe000  ! 2707: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	mov	0x7c0, %r21
	.word 0xdebfe000  ! 2709: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xdaa44400  ! 2710: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0xdcbf2000  ! 2711: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdcdfa000  ! 2712: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	.word 0xdc9fe000  ! 2713: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xdef7ce60  ! 2714: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0xd6a584a0  ! 2715: STWA_R	stwa	%r11, [%r22 + %r0] 0x25
	.word 0x87802020  ! 2716: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r24
	.word 0xdab42000  ! 2718: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xda9c6000  ! 2719: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xd0f44400  ! 2720: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd8846000  ! 2721: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 2722: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd29f4e40  ! 2723: LDDA_R	ldda	[%r29, %r0] 0x72, %r9
	.word 0xd485e000  ! 2724: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r10
	.word 0xd6bd44a0  ! 2725: STDA_R	stda	%r11, [%r21 + %r0] 0x25
	.word 0xda840400  ! 2726: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	.word 0xdab44400  ! 2727: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0xd2ad04a0  ! 2728: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	.word 0x87802025  ! 2729: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8ada000  ! 2730: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0xd8b56000  ! 2731: STHA_I	stha	%r12, [%r21 + 0x0000] %asi
	.word 0x87802025  ! 2732: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c8, %r22
	.word 0xda85c4a0  ! 2734: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r13
	.word 0xd8f689e0  ! 2735: STXA_R	stxa	%r12, [%r26 + %r0] 0x4f
	mov	0x0, %r26
	.word 0xd8c609e0  ! 2737: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r12
	.word 0xd2b48400  ! 2738: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0x87802025  ! 2739: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0c74e60  ! 2740: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r8
	.word 0xd6be89e0  ! 2741: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	mov	0x3c8, %r20
	.word 0xd6cc6000  ! 2743: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r11
	mov	0x3d8, %r21
	.word 0xd6cc2000  ! 2745: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	mov	0x7c8, %r20
	mov	0x10, %r18
	.word 0xd6bc2000  ! 2748: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xd2cf0e60  ! 2750: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r9
	.word 0xd2afce80  ! 2751: STBA_R	stba	%r9, [%r31 + %r0] 0x74
	ta	T_CHANGE_PRIV	! macro
	mov	0x38, %r25
	mov	0x38, %r16
	mov	0x8, %r27
	mov	0x0, %r27
	.word 0xd0bc6000  ! 2757: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	.word 0xd0cca000  ! 2758: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	.word 0xd0f4a000  ! 2759: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xd4f44400  ! 2760: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	mov	0x3d8, %r23
	.word 0xdcc44400  ! 2762: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xdec70e40  ! 2763: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r15
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0dc2000  ! 2765: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	.word 0xd0f4a000  ! 2766: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xd084a000  ! 2767: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	mov	0x58, %r18
	mov	0x20, %r17
	mov	0x3c8, %r20
	.word 0xd0bca000  ! 2771: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 2772: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0846000  ! 2773: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0xd0b4a000  ! 2774: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	mov	0x7e8, %r21
	mov	0x7d0, %r21
	mov	0x50, %r24
	mov	0x20, %r19
	.word 0xdc974e80  ! 2779: LDUHA_R	lduha	[%r29, %r0] 0x74, %r14
	.word 0xdeaf0e80  ! 2780: STBA_R	stba	%r15, [%r28 + %r0] 0x74
	.word 0x87802020  ! 2781: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6dce000  ! 2782: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0xd6aca000  ! 2783: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xd2d40400  ! 2784: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	.word 0x87802074  ! 2785: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r24
	.word 0xd89584a0  ! 2787: LDUHA_R	lduha	[%r22, %r0] 0x25, %r12
	.word 0x87802073  ! 2788: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdea74e60  ! 2789: STWA_R	stwa	%r15, [%r29 + %r0] 0x73
	.word 0xd8cfce60  ! 2790: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r12
	.word 0xdebcc400  ! 2791: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	.word 0xd8df8e80  ! 2792: LDXA_R	ldxa	[%r30, %r0] 0x74, %r12
	.word 0xd48da000  ! 2793: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r10
	.word 0x87802073  ! 2794: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd094c400  ! 2795: LDUHA_R	lduha	[%r19, %r0] 0x20, %r8
	.word 0x87802073  ! 2796: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 2797: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda942000  ! 2798: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0xd897ce80  ! 2799: LDUHA_R	lduha	[%r31, %r0] 0x74, %r12
	.word 0xd697ce40  ! 2800: LDUHA_R	lduha	[%r31, %r0] 0x72, %r11
	.word 0x87802073  ! 2801: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r17
	.word 0xd0d70e60  ! 2803: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r8
	.word 0xde9c0400  ! 2804: LDDA_R	ldda	[%r16, %r0] 0x20, %r15
	.word 0x87802025  ! 2805: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 2806: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e8, %r20
	mov	0x58, %r19
	.word 0x87802020  ! 2809: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb78e80  ! 2810: STHA_R	stha	%r15, [%r30 + %r0] 0x74
	.word 0xdecf8e60  ! 2811: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r15
	.word 0xd8cd2000  ! 2812: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r12
	mov	0x38, %r17
	.word 0x8780204f  ! 2814: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 2815: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2816: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bf0e60  ! 2817: STDA_R	stda	%r12, [%r28 + %r0] 0x73
	.word 0xdab66000  ! 2818: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0xda9e2000  ! 2819: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r13
	mov	0x3e8, %r21
	.word 0xdacf0e40  ! 2821: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r13
	.word 0x87802025  ! 2822: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r27
	.word 0xd8b48400  ! 2824: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	mov	0x30, %r17
	mov	0x58, %r26
	mov	0x68, %r27
	.word 0xdca78e60  ! 2828: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	.word 0xdaf44400  ! 2829: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	wr_tick_cmpr_1_27:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x84, %g2
	or	%g4, 0x9d, %g4
	or	%g6, 0xf7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdabf2000  ! 2831: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xda87a000  ! 2832: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0xd48544a0  ! 2833: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r10
	.word 0xd48f6000  ! 2834: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	mov	0x70, %r17
	mov	0x60, %r16
	.word 0xd4ae49e0  ! 2837: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0xd2a72000  ! 2838: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0xd6a78e60  ! 2839: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0x87802073  ! 2840: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r24
	.word 0xdab66000  ! 2842: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0xdcb44400  ! 2843: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0xdecee000  ! 2844: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r15
	.word 0xd4d4c400  ! 2845: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0xd4d689e0  ! 2846: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r10
	.word 0x87802074  ! 2847: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacf2000  ! 2848: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0x87802025  ! 2849: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad76000  ! 2850: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0xdab76000  ! 2851: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdab7e000  ! 2852: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xd8870e80  ! 2853: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r12
	.word 0xdc97ce80  ! 2854: LDUHA_R	lduha	[%r31, %r0] 0x74, %r14
	mov	0x7c0, %r23
	.word 0x87802073  ! 2856: WRASI_I	wr	%r0, 0x0073, %asi
	wr_tick_cmpr_1_28:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf4, %g2
	or	%g4, 0x91, %g4
	or	%g6, 0x97, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7c8, %r23
	.word 0x87802073  ! 2859: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0f56000  ! 2860: STXA_I	stxa	%r8, [%r21 + 0x0000] %asi
	.word 0xd0b44400  ! 2861: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	mov	0x3f0, %r21
	.word 0xdca70e80  ! 2863: STWA_R	stwa	%r14, [%r28 + %r0] 0x74
	mov	0x68, %r19
	.word 0xdaf584a0  ! 2865: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	.word 0xd08d2000  ! 2866: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r8
	.word 0xd0f5e000  ! 2867: STXA_I	stxa	%r8, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 2868: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_1_29:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xed, %g2
	or	%g4, 0xfd, %g4
	or	%g6, 0xad, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3f0, %r23
	.word 0xd0ce6000  ! 2871: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r8
	mov	0x7d0, %r22
	.word 0xdc848400  ! 2873: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	mov	0x8, %r16
	mov	0x58, %r24
	.word 0xde8e2000  ! 2876: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r15
	.word 0xda978e80  ! 2877: LDUHA_R	lduha	[%r30, %r0] 0x74, %r13
	.word 0xd28ee000  ! 2878: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r9
	.word 0xdcd48400  ! 2879: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	.word 0xd0b649e0  ! 2880: STHA_R	stha	%r8, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 2881: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2882: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa78e80  ! 2883: STWA_R	stwa	%r13, [%r30 + %r0] 0x74
	mov	0x8, %r18
	.word 0xd6cc6000  ! 2885: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r11
	.word 0xd4cc0400  ! 2886: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r10
	mov	0x20, %r25
	.word 0xda8f0e80  ! 2888: LDUBA_R	lduba	[%r28, %r0] 0x74, %r13
	.word 0xd0cc2000  ! 2889: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	.word 0x87802073  ! 2890: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r27
	mov	0x10, %r16
	.word 0xd095a000  ! 2893: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r8
	.word 0x87802073  ! 2894: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 2895: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a7ce40  ! 2896: STWA_R	stwa	%r8, [%r31 + %r0] 0x72
	.word 0xd0f584a0  ! 2897: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	.word 0x87802074  ! 2898: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc85c4a0  ! 2899: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r14
	.word 0x87802025  ! 2900: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r27
	.word 0xdadf2000  ! 2902: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0x87802073  ! 2903: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaae09e0  ! 2904: STBA_R	stba	%r13, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 2905: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd497e000  ! 2906: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	.word 0xd4a72000  ! 2907: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4874e40  ! 2908: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r10
	.word 0xd4ac0400  ! 2909: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xdaa40400  ! 2910: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	mov	0x7e0, %r22
	.word 0xdacf6000  ! 2912: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xda876000  ! 2913: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0x87802072  ! 2914: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2d74e60  ! 2915: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r9
	.word 0xd8d76000  ! 2916: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	mov	0x68, %r24
	mov	0x20, %r24
	mov	0x7c0, %r20
	.word 0xde8fce80  ! 2920: LDUBA_R	lduba	[%r31, %r0] 0x74, %r15
	.word 0x87802074  ! 2921: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r17
	mov	0x68, %r24
	.word 0x87802020  ! 2924: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a46000  ! 2925: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0f42000  ! 2926: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 2927: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f504a0  ! 2928: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	mov	0x7e0, %r21
	mov	0x3e0, %r20
	.word 0xde876000  ! 2931: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	mov	0x7f0, %r21
	.word 0xdeaf6000  ! 2933: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xdedfa000  ! 2934: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x7e0, %r21
	.word 0xd88f8e40  ! 2936: LDUBA_R	lduba	[%r30, %r0] 0x72, %r12
	.word 0xd4bf0e80  ! 2937: STDA_R	stda	%r10, [%r28 + %r0] 0x74
	.word 0xdca7e000  ! 2938: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xdcaf2000  ! 2940: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 2941: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2942: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4cc0400  ! 2943: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r10
	.word 0xdcbcc400  ! 2944: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	mov	0x8, %r26
	.word 0xd8bce000  ! 2946: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd48f8e60  ! 2947: LDUBA_R	lduba	[%r30, %r0] 0x73, %r10
	.word 0x87802072  ! 2948: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d8, %r21
	.word 0xdebca000  ! 2950: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xde842000  ! 2951: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	mov	0x3f8, %r22
	.word 0xdeb4e000  ! 2953: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 2954: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdea46000  ! 2955: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 2956: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdedda000  ! 2957: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r15
	.word 0xd28649e0  ! 2958: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r9
	.word 0xd49c0400  ! 2959: LDDA_R	ldda	[%r16, %r0] 0x20, %r10
	mov	0x38, %r18
	.word 0xd0b52000  ! 2961: STHA_I	stha	%r8, [%r20 + 0x0000] %asi
	.word 0xd09d6000  ! 2962: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r8
	.word 0xd0d52000  ! 2963: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r8
	.word 0x87802020  ! 2964: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcd689e0  ! 2965: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r14
	.word 0xdcac8400  ! 2966: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xdaaca000  ! 2967: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0xdaf4a000  ! 2968: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	mov	0x28, %r25
	mov	0x60, %r26
	.word 0x87802020  ! 2971: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab52000  ! 2972: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	.word 0xdaa5e000  ! 2973: STWA_I	stwa	%r13, [%r23 + 0x0000] %asi
	.word 0xd6bcc400  ! 2974: STDA_R