// Copyright (c) 2015 Princeton University
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Princeton University nor the
//       names of its contributors may be used to endorse or promote products
//       derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY PRINCETON UNIVERSITY "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL PRINCETON UNIVERSITY BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// Wraps the IFU to tie unused signals when no SPU is present

`include "sys.h"
`include "iop.h"
`include "ifu.tmp.h"
`include "lsu.tmp.h"
`include "define.vh"

module sparc_ifu_nospu_wrap 
(
    input [2:0] 	  exu_tlu_wsr_data_m,

    output         ifu_exu_addr_mask_d,


    output         ifu_tlu_inst_vld_w,
    output         ifu_tlu_flush_w,
    output         ifu_lsu_alt_space_e,
    output         ifu_tlu_ttype_vld_m,
    output [4:0]   ifu_exu_muldivop_d,
    output [1:0]   ifu_lsu_thrid_s,

    input [58:0]   tlu_itlb_tte_tag_w2,
    input [42:0]   tlu_itlb_tte_data_w2,
    input          tlu_itlb_rw_index_vld_g,
    input [5:0]    tlu_itlb_rw_index_g,
    input [40:0]   tlu_idtlb_dmp_key_g,
    input          tlu_itlb_dmp_all_g,


    input [62:0]           tlu_sscan_data,
    input [15:0]           lsu_sscan_data,


    input                arst_l,
    // input [3:0]          const_cpuid,
    // input [7:0]          const_maskid,
    // input                ctu_tck,
    input [47:0]         exu_ifu_brpc_e,
    input [7:0]          exu_ifu_cc_d,
    input                exu_ifu_ecc_ce_m,
    input                exu_ifu_ecc_ue_m,
    input [7:0]          exu_ifu_err_reg_m,
    input [7:0]          exu_ifu_err_synd_m,
    input                exu_ifu_inj_ack,
    input [3:0]          exu_ifu_longop_done_g,
    input [3:0]          exu_ifu_oddwin_s,
    input                exu_ifu_regn_e,
    input                exu_ifu_regz_e,
    input                exu_ifu_spill_e,
    input                exu_ifu_va_oor_m,
    input [1:0]          ffu_ifu_cc_vld_w2,
    input [7:0]          ffu_ifu_cc_w2,
    input                ffu_ifu_ecc_ce_w2,
    input                ffu_ifu_ecc_ue_w2,
    input [5:0]          ffu_ifu_err_reg_w2,
    input [13:0]         ffu_ifu_err_synd_w2,
    input                ffu_ifu_fpop_done_w2,
    input                ffu_ifu_fst_ce_w,
    input                ffu_ifu_inj_ack,
    input                ffu_ifu_stallreq,
    input [1:0]          ffu_ifu_tid_w2,
    input                gdbginit_l,
    input                grst_l,
    input [3:0]          lsu_ifu_addr_real_l,
    input [17:0]         lsu_ifu_asi_addr,
    input                lsu_ifu_asi_load,
    input [7:0]          lsu_ifu_asi_state,
    input [1:0]          lsu_ifu_asi_thrid,
    input                lsu_ifu_asi_vld,
    input [`CPX_WIDTH-1:130]lsu_ifu_cpxpkt_i1_144_130,
    input [127:0]        lsu_ifu_cpxpkt_i1_127_0,
    input                lsu_ifu_dc_parity_error_w2,
    input                lsu_ifu_dcache_data_perror,
    input                lsu_ifu_dcache_tag_perror,
    input                lsu_ifu_direct_map_l1,
    input                lsu_ifu_dtlb_data_su,
    input                lsu_ifu_dtlb_data_ue,
    input                lsu_ifu_dtlb_tag_ue,
    input [47:4]         lsu_ifu_err_addr,
    input [1:0]          lsu_ifu_error_tid,
    input [3:0]          lsu_ifu_icache_en,
    input [3:0]          lsu_ifu_inj_ack,
    input                lsu_ifu_io_error,
    input                lsu_ifu_l2_corr_error,
    input                lsu_ifu_l2_unc_error,
    input [`IC_IDX_HI:5] lsu_ifu_ld_icache_index,
    input [1:0]          lsu_ifu_ld_pcxpkt_tid,
    input                lsu_ifu_ld_pcxpkt_vld,
    input [1:0]          lsu_ifu_ldst_cmplt,
    input                lsu_ifu_ldst_miss_g,
    input                lsu_ifu_ldsta_internal_e,
    input                lsu_ifu_pcxpkt_ack_d,
    input                lsu_ifu_stallreq,
    input [3:0]          lsu_ifu_stbcnt0,
    input [3:0]          lsu_ifu_stbcnt1,
    input [3:0]          lsu_ifu_stbcnt2,
    input [3:0]          lsu_ifu_stbcnt3,
    input [47:0]         lsu_ifu_stxa_data,
    input                lsu_ifu_t0_tlz,
    input                lsu_ifu_t1_tlz,
    input                lsu_ifu_t2_tlz,
    input                lsu_ifu_t3_tlz,
    input [2:0]          lsu_pid_state0,
    input [2:0]          lsu_pid_state1,
    input [2:0]          lsu_pid_state2,
    input [2:0]          lsu_pid_state3,
    input [12:0]         lsu_t0_pctxt_state,
    input [12:0]         lsu_t1_pctxt_state,
    input                rclk,
    input [3:0]          tlu_hpstate_enb,
    input [3:0]          tlu_hpstate_ibe,
    input [3:0]          tlu_hpstate_priv,
    input [1:0]          tlu_idtlb_dmp_thrid_g,
    input                tlu_ifu_flush_pipe_w,
    input [3:0]          tlu_ifu_hintp_vld,
    input [3:0]          tlu_ifu_hwint_i3,
    input                tlu_ifu_nukeint_i2,
    input [1:0]          tlu_ifu_pstate_ie,
    input [3:0]          tlu_ifu_pstate_pef,
    input [1:0]          tlu_ifu_rerr_vld,
    input                tlu_ifu_resumint_i2,
    input                tlu_ifu_rstint_i2,
    input [3:0]          tlu_ifu_rstthr_i2,
    input [1:0]          tlu_ifu_sftint_vld,
    input [1:0]          tlu_ifu_trap_tid_w1,
    input                tlu_ifu_trapnpc_vld_w1,
    input [48:0]         tlu_ifu_trapnpc_w2,
    input                tlu_ifu_trappc_vld_w1,
    input [48:0]         tlu_ifu_trappc_w2,
    input                tlu_itlb_data_rd_g,
    input                tlu_itlb_dmp_actxt_g,
    input                tlu_itlb_dmp_nctxt_g,
    input                tlu_itlb_dmp_vld_g,
    input                tlu_itlb_invalidate_all_g,
    input                tlu_itlb_tag_rd_g,
    input                tlu_itlb_wr_vld_g,
    input [3:0]          tlu_lsu_pstate_am,
    input [3:0]          tlu_lsu_pstate_priv,
    input [3:0]          tlu_lsu_redmode,
    `ifndef NO_RTL_CSM
    input                tlu_itlb_csm_rd_g,
    input [`TLB_CSM_LOCAL] tlu_itlb_tte_csm_w2,
    input                tlu_itlb_wr_csm_sel_g,

    input [`CFG_CSM_STATE_WIDTH-1:0]   cfg_ifu_csm_itlb_state,
    input [`NOC_CHIPID_WIDTH-1:0]      cfg_ifu_csm_itlb_chipid,
    input [`NOC_X_WIDTH-1:0]           cfg_ifu_csm_itlb_x,
    input [`NOC_Y_WIDTH-1:0]           cfg_ifu_csm_itlb_y,
    input [`MSG_HDID_WIDTH-1:0]        cfg_ifu_csm_itlb_hdid,
    input [`MSG_LHID_WIDTH-1:0]        cfg_ifu_csm_itlb_hd_size,
    input [`MSG_SDID_WIDTH-1:0]        cfg_ifu_csm_itlb_sdid,
    input [`MSG_LSID_WIDTH-1:0]        cfg_ifu_csm_itlb_lsid,

    `endif


    input                config_dtu_esl_en,
    input [1:0]          config_dtu_esl_sync_method,
    input [15:0]         config_esl_lfsr_seed,
    input                config_esl_lfsr_ld,
    input [49:0]         config_esl_pc_diff_thresh,
    input [15:0]         config_esl_counter_timeout,

    // jtag

    output [2:0]         ifu_exu_aluop_d,
    output               ifu_exu_casa_d,
    output               ifu_exu_dbrinst_d,
    output               ifu_exu_disable_ce_e,
    output               ifu_exu_dontmv_regz0_e,
    output               ifu_exu_dontmv_regz1_e,
    output [7:0]         ifu_exu_ecc_mask,
    output               ifu_exu_enshift_d,
    output               ifu_exu_flushw_e,
    output               ifu_exu_ialign_d,
    output [31:0]        ifu_exu_imm_data_d,
    output               ifu_exu_inj_irferr,
    output               ifu_exu_inst_vld_e,
    output               ifu_exu_inst_vld_w,
    output               ifu_exu_invert_d,
    output               ifu_exu_kill_e,
    output               ifu_exu_muls_d,
    output               ifu_exu_nceen_e,
    output [47:0]        ifu_exu_pc_d,
    output [63:0]        ifu_exu_pcver_e,
    output               ifu_exu_range_check_jlret_d,
    output               ifu_exu_range_check_other_d,
    output [4:0]         ifu_exu_rd_d,
    output               ifu_exu_rd_exusr_e,
    output               ifu_exu_rd_ffusr_e,
    output               ifu_exu_rd_ifusr_e,
    output               ifu_exu_ren1_s,
    output               ifu_exu_ren2_s,
    output               ifu_exu_ren3_s,
    output               ifu_exu_restore_d,
    output               ifu_exu_restored_e,
    output               ifu_exu_return_d,
    output [4:0]         ifu_exu_rs1_s,
    output               ifu_exu_rs1_vld_d,
    output [4:0]         ifu_exu_rs2_s,
    output               ifu_exu_rs2_vld_d,
    output [4:0]         ifu_exu_rs3_s,
    output               ifu_exu_rs3e_vld_d,
    output               ifu_exu_rs3o_vld_d,
    output               ifu_exu_save_d,
    output               ifu_exu_saved_e,
    output               ifu_exu_setcc_d,
    output               ifu_exu_sethi_inst_d,
    output [2:0]         ifu_exu_shiftop_d,
    output               ifu_exu_tagop_d,
    output               ifu_exu_tcc_e,
    output [1:0]         ifu_exu_tid_s2,
    output               ifu_exu_ttype_vld_m,
    output               ifu_exu_tv_d,
    output               ifu_exu_use_rsr_e_l,
    output               ifu_exu_usecin_d,
    output               ifu_exu_useimm_d,
    output               ifu_exu_wen_d,
    output               ifu_exu_wsr_inst_d,
    output [1:0]         ifu_ffu_fcc_num_d,
    output               ifu_ffu_fld_d,
    output               ifu_ffu_fpop1_d,
    output               ifu_ffu_fpop2_d,
    output [8:0]         ifu_ffu_fpopcode_d,
    output [4:0]         ifu_ffu_frd_d,
    output [4:0]         ifu_ffu_frs1_d,
    output [4:0]         ifu_ffu_frs2_d,
    output               ifu_ffu_fst_d,
    output               ifu_ffu_inj_frferr,
    output               ifu_ffu_ldfsr_d,
    output               ifu_ffu_ldst_size_d,
    output               ifu_ffu_ldxfsr_d,
    output               ifu_ffu_mvcnd_m,
    output               ifu_ffu_quad_op_e,
    output               ifu_ffu_stfsr_d,
    output               ifu_ffu_visop_d,
    output               ifu_lsu_alt_space_d,
    output               ifu_lsu_asi_ack,
    output               ifu_lsu_asi_rd_unc,
    output               ifu_lsu_casa_e,
    output [2:0]         ifu_lsu_destid_s,
    output [3:0]         ifu_lsu_error_inj,
    output               ifu_lsu_fwd_data_vld,
    output               ifu_lsu_fwd_wr_ack,
    output               ifu_lsu_ibuf_busy,
    output [7:0]         ifu_lsu_imm_asi_d,
    output               ifu_lsu_imm_asi_vld_d,
    output               ifu_lsu_inv_clear,
    output               ifu_lsu_ld_inst_e,
    output               ifu_lsu_ldst_dbl_e,
    output               ifu_lsu_ldst_fp_e,
    output [1:0]         ifu_lsu_ldst_size_e,
    output               ifu_lsu_ldstub_e,
    output               ifu_lsu_ldxa_data_vld_w2,
    output [63:0]        ifu_lsu_ldxa_data_w2,
    output               ifu_lsu_ldxa_illgl_va_w2,
    output [1:0]         ifu_lsu_ldxa_tid_w2,
    output               ifu_lsu_memref_d,
    output [3:0]         ifu_lsu_nceen,
    output [51:0]        ifu_lsu_pcxpkt_e,
    output               ifu_lsu_pcxreq_d,
    output               ifu_lsu_pref_inst_e,
    output [4:0]         ifu_lsu_rd_e,
    output               ifu_lsu_sign_ext_e,
    output               ifu_lsu_st_inst_e,
    output               ifu_lsu_swap_e,
    output               ifu_lsu_wsr_inst_d,
    output               ifu_mmu_trap_m,
    output               ifu_tlu_alt_space_d,
    output               ifu_tlu_done_inst_d,
    output               ifu_tlu_flsh_inst_e,
    output               ifu_tlu_flush_m,
    output               ifu_tlu_hwint_m,
    output               ifu_tlu_icmiss_e,
    output [8:0]         ifu_tlu_imm_asi_d,
    output               ifu_tlu_immu_miss_m,
    output               ifu_tlu_inst_vld_m,
    output               ifu_tlu_itlb_done,
    output [3:0]         ifu_tlu_l2imiss,
    output               ifu_tlu_mb_inst_e,
    output [48:0]        ifu_tlu_npc_m,
    output [48:0]        ifu_tlu_pc_m,
    output               ifu_tlu_pc_oor_e,
    output               ifu_tlu_priv_violtn_m,
    output               ifu_tlu_retry_inst_d,
    output               ifu_tlu_rsr_inst_d,
    output               ifu_tlu_rstint_m,
    output               ifu_tlu_sftint_m,
    output               ifu_tlu_sir_inst_m,
    output [6:0]         ifu_tlu_sraddr_d,
    output [6:0]         ifu_tlu_sraddr_d_v2,
    output [1:0]         ifu_tlu_thrid_d,
    output [1:0]         ifu_tlu_thrid_e,
    output               ifu_tlu_trap_m,
    output [8:0]         ifu_tlu_ttype_m,

    `ifndef NO_RTL_CSM
    output [`TLB_CSM]     ifu_lsu_pcxcsm_e,
    `endif

    // jtag debug
    output wire [`CORE_JTAG_BUS_WIDTH-1:0] core_rtap_data,
    input wire rtap_core_val,
    input wire [1:0] rtap_core_threadid,
    input wire [`JTAG_CORE_ID_WIDTH-1:0]  rtap_core_id,
    input wire [47:0] rtap_core_data_47_0,

    // sram interface
    output wire [`SRAM_WRAPPER_BUS_WIDTH-1:0] srams_rtap_data,
    input wire  [`BIST_OP_WIDTH-1:0] rtap_srams_bist_command,
    input wire  [`SRAM_WRAPPER_BUS_WIDTH-1:0] rtap_srams_bist_data
);

// trin: removing useless input/outp
// wire mux_drive_disable = ~grst_l;
// wire mem_write_disable = ~grst_l;
wire mux_drive_disable = 1'b0;
wire mem_write_disable = 1'b0;
// wire efc_spc_fuse_clk1 = 1'b0;
// wire efc_spc_fuse_clk2 = 1'b0;
// wire efc_spc_ifuse_ashift = 1'b0;
// wire efc_spc_ifuse_data = 1'b0;
// wire efc_spc_ifuse_dshift = 1'b0;
// wire spc_efc_ifuse_data;
wire [3:0]  const_cpuid = 4'b0;
wire [7:0]  const_maskid = 8'b0;           // To ifu of sparc_ifu.v

    sparc_ifu ifu(
                 // scan
                 // .short_si0              (1'bx),
                 // .short_si1              (1'bx),
                 // .short_so0              (),
                 // .short_so1              (),
                 // .si0                    (1'bx),
                 // .so0                    (),
                 
                 .grst_l                 (grst_l),
                 .arst_l                 (arst_l),
                 .gdbginit_l             (gdbginit_l),
                 
                 .lsu_ifu_quad_asi_e    (1'b0),

                 .lsu_ifu_addr_real_l  (lsu_ifu_addr_real_l),
                 
                 .lsu_ifu_dtlb_data_ue  (lsu_ifu_dtlb_data_ue),
                 .lsu_ifu_dtlb_tag_ue   (lsu_ifu_dtlb_tag_ue),
                 .lsu_ifu_dtlb_data_su  (lsu_ifu_dtlb_data_su),

                 .tlu_ifu_hintp_vld       (tlu_ifu_hintp_vld),
                 .tlu_ifu_rerr_vld        ({2'bx, tlu_ifu_rerr_vld}),

                 .lsu_ifu_t0_tlz        (lsu_ifu_t0_tlz),
                 .lsu_ifu_t1_tlz        (lsu_ifu_t1_tlz),
                 .lsu_ifu_t2_tlz        (lsu_ifu_t2_tlz),
                 .lsu_ifu_t3_tlz        (lsu_ifu_t3_tlz),
                 
                 .lsu_ifu_ldst_miss_g   (lsu_ifu_ldst_miss_g),
                 .tlu_ifu_flush_pipe_w  (tlu_ifu_flush_pipe_w),

                 .lsu_idtlb_mrgn        (8'bx),

                 // .mbist_loop_on_address (mbist_loop_on_address),
                 
                 .ifu_tlu_imm_asi_d     (ifu_tlu_imm_asi_d),

                 // bus width difference
                 .lsu_ifu_cpxpkt_i1     ({lsu_ifu_cpxpkt_i1_144_130, 2'bx, lsu_ifu_cpxpkt_i1_127_0}),
                     /*AUTOINST*/
                 // Outputs

                 `ifndef NO_RTL_CSM
                 .ifu_lsu_pcxcsm_e       (ifu_lsu_pcxcsm_e), 
                 `endif
                 .ifu_exu_addr_mask_d   (ifu_exu_addr_mask_d),
                 .ifu_tlu_inst_vld_w    (ifu_tlu_inst_vld_w),
                 .ifu_tlu_flush_w       (ifu_tlu_flush_w),
                 .ifu_lsu_alt_space_e   (ifu_lsu_alt_space_e),
                 .ifu_tlu_ttype_vld_m   (ifu_tlu_ttype_vld_m),
                 .ifu_exu_muldivop_d    (ifu_exu_muldivop_d),
                 .ifu_lsu_thrid_s       (ifu_lsu_thrid_s),
                 // .mbist_write_data      (mbist_write_data),
                 .ifu_exu_aluop_d       (ifu_exu_aluop_d),
                 .ifu_exu_casa_d        (ifu_exu_casa_d),
                 .ifu_exu_dbrinst_d     (ifu_exu_dbrinst_d),
                 .ifu_exu_disable_ce_e  (ifu_exu_disable_ce_e),
                 .ifu_exu_dontmv_regz0_e(ifu_exu_dontmv_regz0_e),
                 .ifu_exu_dontmv_regz1_e(ifu_exu_dontmv_regz1_e),
                 .ifu_exu_ecc_mask      (ifu_exu_ecc_mask),
                 .ifu_exu_enshift_d     (ifu_exu_enshift_d),
                 .ifu_exu_flushw_e      (ifu_exu_flushw_e),
                 .ifu_exu_ialign_d      (ifu_exu_ialign_d),
                 .ifu_exu_imm_data_d    (ifu_exu_imm_data_d),
                 .ifu_exu_inj_irferr    (ifu_exu_inj_irferr),
                 .ifu_exu_inst_vld_e    (ifu_exu_inst_vld_e),
                 .ifu_exu_inst_vld_w    (ifu_exu_inst_vld_w),
                 .ifu_exu_invert_d      (ifu_exu_invert_d),
                 .ifu_exu_kill_e        (ifu_exu_kill_e),
                 .ifu_exu_muls_d        (ifu_exu_muls_d),
                 .ifu_exu_nceen_e       (ifu_exu_nceen_e),
                 .ifu_exu_pc_d          (ifu_exu_pc_d),
                 .ifu_exu_pcver_e       (ifu_exu_pcver_e),
                 .ifu_exu_range_check_jlret_d(ifu_exu_range_check_jlret_d),
                 .ifu_exu_range_check_other_d(ifu_exu_range_check_other_d),
                 .ifu_exu_rd_d          (ifu_exu_rd_d),
                 .ifu_exu_rd_exusr_e    (ifu_exu_rd_exusr_e),
                 .ifu_exu_rd_ffusr_e    (ifu_exu_rd_ffusr_e),
                 .ifu_exu_rd_ifusr_e    (ifu_exu_rd_ifusr_e),
                 .ifu_exu_ren1_s        (ifu_exu_ren1_s),
                 .ifu_exu_ren2_s        (ifu_exu_ren2_s),
                 .ifu_exu_ren3_s        (ifu_exu_ren3_s),
                 .ifu_exu_restore_d     (ifu_exu_restore_d),
                 .ifu_exu_restored_e    (ifu_exu_restored_e),
                 .ifu_exu_return_d      (ifu_exu_return_d),
                 .ifu_exu_rs1_s         (ifu_exu_rs1_s),
                 .ifu_exu_rs1_vld_d     (ifu_exu_rs1_vld_d),
                 .ifu_exu_rs2_s         (ifu_exu_rs2_s),
                 .ifu_exu_rs2_vld_d     (ifu_exu_rs2_vld_d),
                 .ifu_exu_rs3_s         (ifu_exu_rs3_s),
                 .ifu_exu_rs3e_vld_d    (ifu_exu_rs3e_vld_d),
                 .ifu_exu_rs3o_vld_d    (ifu_exu_rs3o_vld_d),
                 .ifu_exu_save_d        (ifu_exu_save_d),
                 .ifu_exu_saved_e       (ifu_exu_saved_e),
                 .ifu_exu_setcc_d       (ifu_exu_setcc_d),
                 .ifu_exu_sethi_inst_d  (ifu_exu_sethi_inst_d),
                 .ifu_exu_shiftop_d     (ifu_exu_shiftop_d),
                 .ifu_exu_tagop_d       (ifu_exu_tagop_d),
                 .ifu_exu_tcc_e         (ifu_exu_tcc_e),
                 .ifu_exu_tid_s2        (ifu_exu_tid_s2),
                 .ifu_exu_ttype_vld_m   (ifu_exu_ttype_vld_m),
                 .ifu_exu_tv_d          (ifu_exu_tv_d),
                 .ifu_exu_use_rsr_e_l   (ifu_exu_use_rsr_e_l),
                 .ifu_exu_usecin_d      (ifu_exu_usecin_d),
                 .ifu_exu_useimm_d      (ifu_exu_useimm_d),
                 .ifu_exu_wen_d         (ifu_exu_wen_d),
                 .ifu_exu_wsr_inst_d    (ifu_exu_wsr_inst_d),
                 .ifu_ffu_fcc_num_d     (ifu_ffu_fcc_num_d),
                 .ifu_ffu_fld_d         (ifu_ffu_fld_d),
                 .ifu_ffu_fpop1_d       (ifu_ffu_fpop1_d),
                 .ifu_ffu_fpop2_d       (ifu_ffu_fpop2_d),
                 .ifu_ffu_fpopcode_d    (ifu_ffu_fpopcode_d),
                 .ifu_ffu_frd_d         (ifu_ffu_frd_d),
                 .ifu_ffu_frs1_d        (ifu_ffu_frs1_d),
                 .ifu_ffu_frs2_d        (ifu_ffu_frs2_d),
                 .ifu_ffu_fst_d         (ifu_ffu_fst_d),
                 .ifu_ffu_inj_frferr    (ifu_ffu_inj_frferr),
                 .ifu_ffu_ldfsr_d       (ifu_ffu_ldfsr_d),
                 .ifu_ffu_ldst_size_d   (ifu_ffu_ldst_size_d),
                 .ifu_ffu_ldxfsr_d      (ifu_ffu_ldxfsr_d),
                 .ifu_ffu_mvcnd_m       (ifu_ffu_mvcnd_m),
                 .ifu_ffu_quad_op_e     (ifu_ffu_quad_op_e),
                 .ifu_ffu_stfsr_d       (ifu_ffu_stfsr_d),
                 .ifu_ffu_visop_d       (ifu_ffu_visop_d),
                 .ifu_lsu_alt_space_d   (ifu_lsu_alt_space_d),
                 .ifu_lsu_asi_ack       (ifu_lsu_asi_ack),
                 .ifu_lsu_asi_rd_unc    (ifu_lsu_asi_rd_unc),
                 .ifu_lsu_casa_e        (ifu_lsu_casa_e),
                 .ifu_lsu_destid_s      (ifu_lsu_destid_s),
                 .ifu_lsu_error_inj     (ifu_lsu_error_inj),
                 .ifu_lsu_fwd_data_vld  (ifu_lsu_fwd_data_vld),
                 .ifu_lsu_fwd_wr_ack    (ifu_lsu_fwd_wr_ack),
                 .ifu_lsu_ibuf_busy     (ifu_lsu_ibuf_busy),
                 .ifu_lsu_imm_asi_d     (ifu_lsu_imm_asi_d),
                 .ifu_lsu_imm_asi_vld_d (ifu_lsu_imm_asi_vld_d),
                 .ifu_lsu_inv_clear     (ifu_lsu_inv_clear),
                 .ifu_lsu_ld_inst_e     (ifu_lsu_ld_inst_e),
                 .ifu_lsu_ldst_dbl_e    (ifu_lsu_ldst_dbl_e),
                 .ifu_lsu_ldst_fp_e     (ifu_lsu_ldst_fp_e),
                 .ifu_lsu_ldst_size_e   (ifu_lsu_ldst_size_e),
                 .ifu_lsu_ldstub_e      (ifu_lsu_ldstub_e),
                 .ifu_lsu_ldxa_data_vld_w2(ifu_lsu_ldxa_data_vld_w2),
                 .ifu_lsu_ldxa_data_w2  (ifu_lsu_ldxa_data_w2),
                 .ifu_lsu_ldxa_illgl_va_w2(ifu_lsu_ldxa_illgl_va_w2),
                 .ifu_lsu_ldxa_tid_w2   (ifu_lsu_ldxa_tid_w2),
                 .ifu_lsu_memref_d      (ifu_lsu_memref_d),
                 .ifu_lsu_nceen         (ifu_lsu_nceen),
                 .ifu_lsu_pcxpkt_e      (ifu_lsu_pcxpkt_e),
                 .ifu_lsu_pcxreq_d      (ifu_lsu_pcxreq_d),
                 .ifu_lsu_pref_inst_e   (ifu_lsu_pref_inst_e),
                 .ifu_lsu_rd_e          (ifu_lsu_rd_e),
                 .ifu_lsu_sign_ext_e    (ifu_lsu_sign_ext_e),
                 .ifu_lsu_st_inst_e     (ifu_lsu_st_inst_e),
                 .ifu_lsu_swap_e        (ifu_lsu_swap_e),
                 .ifu_lsu_wsr_inst_d    (ifu_lsu_wsr_inst_d),
                 .ifu_mmu_trap_m        (ifu_mmu_trap_m),
                 .ifu_spu_inst_vld_w    (),
                 .ifu_spu_nceen         (),
                 .ifu_spu_trap_ack      (),
                 .ifu_tlu_alt_space_d   (ifu_tlu_alt_space_d),
                 .ifu_tlu_done_inst_d   (ifu_tlu_done_inst_d),
                 .ifu_tlu_flsh_inst_e   (ifu_tlu_flsh_inst_e),
                 .ifu_tlu_flush_m       (ifu_tlu_flush_m),
                 .ifu_tlu_hwint_m       (ifu_tlu_hwint_m),
                 .ifu_tlu_icmiss_e      (ifu_tlu_icmiss_e),
                 .ifu_tlu_immu_miss_m   (ifu_tlu_immu_miss_m),
                 .ifu_tlu_inst_vld_m    (ifu_tlu_inst_vld_m),
                 .ifu_tlu_itlb_done     (ifu_tlu_itlb_done),
                 .ifu_tlu_l2imiss       (ifu_tlu_l2imiss),
                 .ifu_tlu_mb_inst_e     (ifu_tlu_mb_inst_e),
                 .ifu_tlu_npc_m         (ifu_tlu_npc_m),
                 .ifu_tlu_pc_m          (ifu_tlu_pc_m),
                 .ifu_tlu_pc_oor_e      (ifu_tlu_pc_oor_e),
                 .ifu_tlu_priv_violtn_m (ifu_tlu_priv_violtn_m),
                 .ifu_tlu_retry_inst_d  (ifu_tlu_retry_inst_d),
                 .ifu_tlu_rsr_inst_d    (ifu_tlu_rsr_inst_d),
                 .ifu_tlu_rstint_m      (ifu_tlu_rstint_m),
                 .ifu_tlu_sftint_m      (ifu_tlu_sftint_m),
                 .ifu_tlu_sir_inst_m    (ifu_tlu_sir_inst_m),
                 .ifu_tlu_sraddr_d      (ifu_tlu_sraddr_d),
                 .ifu_tlu_sraddr_d_v2   (ifu_tlu_sraddr_d_v2),
                 .ifu_tlu_thrid_d       (ifu_tlu_thrid_d),
                 .ifu_tlu_thrid_e       (ifu_tlu_thrid_e),
                 .ifu_tlu_trap_m        (ifu_tlu_trap_m),
                 .ifu_tlu_ttype_m       (ifu_tlu_ttype_m),
                 .spc_efc_ifuse_data    (),
                 // .spc_efc_ifuse_data    (spc_efc_ifuse_data),
                 // Inputs

                 `ifndef NO_RTL_CSM
                 .tlu_itlb_csm_rd_g     (tlu_itlb_csm_rd_g), 
                 .tlu_itlb_tte_csm_w2   ({1'bx, tlu_itlb_tte_csm_w2}),
                 .tlu_itlb_wr_csm_sel_g (tlu_itlb_wr_csm_sel_g), 

                 .cfg_ifu_csm_itlb_state       (cfg_ifu_csm_itlb_state),
                 .cfg_ifu_csm_itlb_chipid      (cfg_ifu_csm_itlb_chipid),
                 .cfg_ifu_csm_itlb_x           (cfg_ifu_csm_itlb_x),
                 .cfg_ifu_csm_itlb_y           (cfg_ifu_csm_itlb_y),
                 .cfg_ifu_csm_itlb_hdid        (cfg_ifu_csm_itlb_hdid),
                 .cfg_ifu_csm_itlb_hd_size     (cfg_ifu_csm_itlb_hd_size),
                 .cfg_ifu_csm_itlb_sdid        (cfg_ifu_csm_itlb_sdid),
                 .cfg_ifu_csm_itlb_lsid        (cfg_ifu_csm_itlb_lsid),

                 `endif
                 .exu_tlu_wsr_data_m    (exu_tlu_wsr_data_m),
                 .lsu_ictag_mrgn        (4'bx),
                 .tlu_itlb_tte_tag_w2   (tlu_itlb_tte_tag_w2),
                 .tlu_itlb_tte_data_w2  (tlu_itlb_tte_data_w2),
                 .tlu_itlb_rw_index_vld_g(tlu_itlb_rw_index_vld_g),
                 .tlu_itlb_rw_index_g   (tlu_itlb_rw_index_g),
                 .tlu_idtlb_dmp_key_g   (tlu_idtlb_dmp_key_g),
                 .tlu_itlb_dmp_all_g    (tlu_itlb_dmp_all_g),
                 .const_cpuid           (const_cpuid),
                 .const_maskid          (const_maskid),
                 // .ctu_tck               (ctu_tck),
                 .exu_ifu_brpc_e        (exu_ifu_brpc_e),
                 .exu_ifu_cc_d          (exu_ifu_cc_d),
                 .exu_ifu_ecc_ce_m      (exu_ifu_ecc_ce_m),
                 .exu_ifu_ecc_ue_m      (exu_ifu_ecc_ue_m),
                 .exu_ifu_err_reg_m     (exu_ifu_err_reg_m),
                 .exu_ifu_err_synd_m    (exu_ifu_err_synd_m),
                 .exu_ifu_inj_ack       (exu_ifu_inj_ack),
                 .exu_ifu_longop_done_g (exu_ifu_longop_done_g),
                 .exu_ifu_oddwin_s      (exu_ifu_oddwin_s),
                 .exu_ifu_regn_e        (exu_ifu_regn_e),
                 .exu_ifu_regz_e        (exu_ifu_regz_e),
                 .exu_ifu_spill_e       (exu_ifu_spill_e),
                 .exu_ifu_va_oor_m      (exu_ifu_va_oor_m),
                 .ffu_ifu_cc_vld_w2     ({2'bx, ffu_ifu_cc_vld_w2}),
                 .ffu_ifu_cc_w2         (ffu_ifu_cc_w2),
                 .ffu_ifu_ecc_ce_w2     (ffu_ifu_ecc_ce_w2),
                 .ffu_ifu_ecc_ue_w2     (ffu_ifu_ecc_ue_w2),
                 .ffu_ifu_err_reg_w2    (ffu_ifu_err_reg_w2),
                 .ffu_ifu_err_synd_w2   (ffu_ifu_err_synd_w2),
                 .ffu_ifu_fpop_done_w2  (ffu_ifu_fpop_done_w2),
                 .ffu_ifu_fst_ce_w      (ffu_ifu_fst_ce_w),
                 .ffu_ifu_inj_ack       (ffu_ifu_inj_ack),
                 .ffu_ifu_stallreq      (ffu_ifu_stallreq),
                 .ffu_ifu_tid_w2        (ffu_ifu_tid_w2),
                 .lsu_ifu_asi_addr      (lsu_ifu_asi_addr),
                 .lsu_ifu_asi_load      (lsu_ifu_asi_load),
                 .lsu_ifu_asi_state     (lsu_ifu_asi_state),
                 .lsu_ifu_asi_thrid     (lsu_ifu_asi_thrid),
                 .lsu_ifu_asi_vld       (lsu_ifu_asi_vld),
                 .lsu_ifu_dc_parity_error_w2(lsu_ifu_dc_parity_error_w2),
                 .lsu_ifu_dcache_data_perror(lsu_ifu_dcache_data_perror),
                 .lsu_ifu_dcache_tag_perror(lsu_ifu_dcache_tag_perror),
                 .lsu_ifu_direct_map_l1 (lsu_ifu_direct_map_l1),
                 .lsu_ifu_err_addr      (lsu_ifu_err_addr),
                 .lsu_ifu_error_tid     (lsu_ifu_error_tid),
                 .lsu_ifu_icache_en     (lsu_ifu_icache_en),
                 .lsu_ifu_inj_ack       (lsu_ifu_inj_ack),
                 .lsu_ifu_io_error      (lsu_ifu_io_error),
                 .lsu_ifu_l2_corr_error (lsu_ifu_l2_corr_error),
                 .lsu_ifu_l2_unc_error  (lsu_ifu_l2_unc_error),
                 .lsu_ifu_ld_icache_index(lsu_ifu_ld_icache_index),
                 .lsu_ifu_ld_pcxpkt_tid (lsu_ifu_ld_pcxpkt_tid),
                 .lsu_ifu_ld_pcxpkt_vld (lsu_ifu_ld_pcxpkt_vld),
                 .lsu_ifu_ldst_cmplt    ({2'bx, lsu_ifu_ldst_cmplt}),
                 .lsu_ifu_ldsta_internal_e(lsu_ifu_ldsta_internal_e),
                 .lsu_ifu_pcxpkt_ack_d  (lsu_ifu_pcxpkt_ack_d),
                 .lsu_ifu_stallreq      (lsu_ifu_stallreq),
                 .lsu_ifu_stbcnt0       (lsu_ifu_stbcnt0),
                 .lsu_ifu_stbcnt1       (lsu_ifu_stbcnt1),
                 .lsu_ifu_stbcnt2       (lsu_ifu_stbcnt2),
                 .lsu_ifu_stbcnt3       (lsu_ifu_stbcnt3),
                 .lsu_ifu_stxa_data     (lsu_ifu_stxa_data),
                 .lsu_pid_state0        (lsu_pid_state0),
                 .lsu_pid_state1        (lsu_pid_state1),
                 .lsu_pid_state2        (lsu_pid_state2),
                 .lsu_pid_state3        (lsu_pid_state3),
                 .lsu_t0_pctxt_state    (lsu_t0_pctxt_state),
                 .lsu_t1_pctxt_state    (lsu_t1_pctxt_state),
                 .lsu_t2_pctxt_state    (13'bx),
                 .lsu_t3_pctxt_state    (13'bx),
                 // .mbist_bisi_mode       (mbist_bisi_mode),
                 // .mbist_dcache_data_in  (mbist_dcache_data_in),
                 // .mbist_loop_mode       (mbist_loop_mode),
                 // .mbist_start           (mbist_start),
                 // .mbist_stop_on_fail    (mbist_stop_on_fail),
                 // .mbist_stop_on_next_fail(mbist_stop_on_next_fail),
                 // .mbist_userdata_mode   (mbist_userdata_mode),
                 .rclk                  (rclk),
                 .se                    (1'b0),
                 .sehold                (1'b0),
                 .spu_ifu_corr_err_w2   (1'b0),
                 .spu_ifu_err_addr_w2   (36'h000000000),
                 .spu_ifu_int_w2        (1'b0),
                 .spu_ifu_mamem_err_w1  (1'b0),
                 .spu_ifu_ttype_tid_w2  (2'b00),
                 .spu_ifu_ttype_vld_w2  (1'b0),
                 .spu_ifu_ttype_w2      (1'b0),
                 .spu_ifu_unc_err_w1    (1'b0),
                 // .testmode_l            (1'bx),
                 .tlu_hpstate_enb       (tlu_hpstate_enb),
                 .tlu_hpstate_ibe       (tlu_hpstate_ibe),
                 .tlu_hpstate_priv      (tlu_hpstate_priv),
                 .tlu_idtlb_dmp_thrid_g (tlu_idtlb_dmp_thrid_g),
                 .tlu_ifu_hwint_i3      (tlu_ifu_hwint_i3),
                 .tlu_ifu_nukeint_i2    (tlu_ifu_nukeint_i2),
                 .tlu_ifu_pstate_ie     ({2'bx, tlu_ifu_pstate_ie}),
                 .tlu_ifu_pstate_pef    (tlu_ifu_pstate_pef),
                 .tlu_ifu_resumint_i2   (tlu_ifu_resumint_i2),
                 .tlu_ifu_rstint_i2     (tlu_ifu_rstint_i2),
                 .tlu_ifu_rstthr_i2     (tlu_ifu_rstthr_i2),
                 .tlu_ifu_sftint_vld    ({2'bx, tlu_ifu_sftint_vld}),
                 .tlu_ifu_trap_tid_w1   (tlu_ifu_trap_tid_w1),
                 .tlu_ifu_trapnpc_vld_w1(tlu_ifu_trapnpc_vld_w1),
                 .tlu_ifu_trapnpc_w2    (tlu_ifu_trapnpc_w2),
                 .tlu_ifu_trappc_vld_w1 (tlu_ifu_trappc_vld_w1),
                 .tlu_ifu_trappc_w2     (tlu_ifu_trappc_w2),
                 .tlu_itlb_data_rd_g    (tlu_itlb_data_rd_g),
                 .tlu_itlb_dmp_actxt_g  (tlu_itlb_dmp_actxt_g),
                 .tlu_itlb_dmp_nctxt_g  (tlu_itlb_dmp_nctxt_g),
                 .tlu_itlb_dmp_vld_g    (tlu_itlb_dmp_vld_g),
                 .tlu_itlb_invalidate_all_g(tlu_itlb_invalidate_all_g),
                 .tlu_itlb_tag_rd_g     (tlu_itlb_tag_rd_g),
                 .tlu_itlb_wr_vld_g     (tlu_itlb_wr_vld_g),
                 .tlu_lsu_pstate_am     (tlu_lsu_pstate_am),
                 .tlu_lsu_pstate_priv   (tlu_lsu_pstate_priv),
                 .tlu_lsu_redmode       (tlu_lsu_redmode),

                 // .efc_spc_ifuse_dshift       (efc_spc_ifuse_dshift),
                 // .efc_spc_ifuse_data       (efc_spc_ifuse_data),
                 // .efc_spc_ifuse_ashift       (efc_spc_ifuse_ashift),
                 // .efc_spc_fuse_clk2       (efc_spc_fuse_clk2),
                 // .efc_spc_fuse_clk1       (efc_spc_fuse_clk1),
                 .mem_write_disable       (mem_write_disable),
                 .mux_drive_disable       (mux_drive_disable),

                 .tlu_sscan_data    (tlu_sscan_data),
                 .lsu_sscan_data    (lsu_sscan_data),

                 // interface to srams
                 .srams_rtap_data (srams_rtap_data),
                 .rtap_srams_bist_command (rtap_srams_bist_command),
                 .rtap_srams_bist_data (rtap_srams_bist_data),

                 .config_dtu_esl_en     (config_dtu_esl_en),
                 .config_dtu_esl_sync_method (config_dtu_esl_sync_method),
                 .config_esl_lfsr_seed (config_esl_lfsr_seed),
                 .config_esl_lfsr_ld (config_esl_lfsr_ld),
                 .config_esl_pc_diff_thresh (config_esl_pc_diff_thresh),
                 .config_esl_counter_timeout (config_esl_counter_timeout),

    .core_rtap_data          (core_rtap_data),
    .rtap_core_val         (rtap_core_val),
    .rtap_core_threadid         (rtap_core_threadid),
    .rtap_core_id         (rtap_core_id),
    .rtap_core_data         ({{(`CORE_JTAG_BUS_WIDTH-48){1'bx}}, rtap_core_data_47_0})


                 ); 

endmodule
