// Copyright (c) 2015 Princeton University
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Princeton University nor the
//       names of its contributors may be used to endorse or promote products
//       derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY PRINCETON UNIVERSITY "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL PRINCETON UNIVERSITY BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// Wraps the LSU to tie unused signals

`include "sys.h"
`include "iop.h"
`include "ifu.tmp.h"
`include "lsu.tmp.h"
`include "define.vh"

module lsu_nospu_wrap
(
    input                   arst_l,
    input [`L1D_ADDRESS_HI:0]            bist_ctl_reg_out,
    input                   clk,
    input [2:0]             const_cpuid,
    input [63:0]            exu_lsu_rs2_data_e,
    input [63:0]            exu_lsu_rs3_data_e,
    input                   exu_tlu_misalign_addr_jmpl_rtn_m,
    input                   exu_tlu_va_oor_m,
    input                   ffu_lsu_blk_st_e,
    input [5:3]             ffu_lsu_blk_st_va_e,
    input                   ffu_lsu_fpop_rq_vld,
    input                   ffu_lsu_kill_fst_w,
    input                   gdbginit_l,
    input                   grst_l,
    input                   ifu_lsu_alt_space_d,
    input                   ifu_lsu_alt_space_e,
    input                   ifu_lsu_asi_ack,
    input                   ifu_lsu_asi_rd_unc,
    input                   ifu_lsu_casa_e,
    input [2:0]             ifu_lsu_destid_s,
    input                   ifu_lsu_fwd_data_vld,
    input                   ifu_lsu_fwd_wr_ack,
    input                   ifu_lsu_ibuf_busy,
    input [7:0]             ifu_lsu_imm_asi_d,
    input                   ifu_lsu_imm_asi_vld_d,
    input                   ifu_lsu_inv_clear,
    input                   ifu_lsu_ld_inst_e,
    input                   ifu_lsu_ldst_dbl_e,
    input                   ifu_lsu_ldst_fp_e,
    input [1:0]             ifu_lsu_ldst_size_e,
    input                   ifu_lsu_ldstub_e,
    input                   ifu_lsu_ldxa_data_vld_w2,
    input [63:0]            ifu_lsu_ldxa_data_w2,
    input                   ifu_lsu_ldxa_illgl_va_w2,
    input [1:0]             ifu_lsu_ldxa_tid_w2,
    input                   ifu_lsu_memref_d,
    input [3:0]             ifu_lsu_nceen,
    input [51:0]            ifu_lsu_pcxpkt_e,
    input                   ifu_lsu_pcxreq_d,
    input                   ifu_lsu_pref_inst_e,
    input [4:0]             ifu_lsu_rd_e,
    input                   ifu_lsu_sign_ext_e,
    input                   ifu_lsu_st_inst_e,
    input                   ifu_lsu_swap_e,
    input [1:0]             ifu_lsu_thrid_s,
    input                   ifu_tlu_flsh_inst_e,
    input                   ifu_tlu_flush_m,
    input                   ifu_tlu_inst_vld_m,
    input                   ifu_tlu_mb_inst_e,
    input [6:0]             ifu_tlu_sraddr_d,
    input [1:0]             ifu_tlu_thrid_e,
    input                   ifu_tlu_wsr_inst_d,
    input                   pcx_spc_grant_px0,
    input [3:0]             tlu_dsfsr_flt_vld,
    input                   tlu_dtlb_data_rd_g,
    input                   tlu_dtlb_dmp_actxt_g,
    input                   tlu_dtlb_dmp_all_g,
    input                   tlu_dtlb_dmp_nctxt_g,
    input                   tlu_dtlb_dmp_pctxt_g,
    input                   tlu_dtlb_dmp_sctxt_g,
    input                   tlu_dtlb_dmp_vld_g,
    input                   tlu_dtlb_invalidate_all_g,
    input [5:0]             tlu_dtlb_rw_index_g,
    input                   tlu_dtlb_rw_index_vld_g,
    input                   tlu_dtlb_tag_rd_g,
    input [42:0]            tlu_dtlb_tte_data_w2,
    input [58:0]            tlu_dtlb_tte_tag_w2,
    input                   tlu_early_flush_pipe2_w,
    input                   tlu_early_flush_pipe_w,
    input                   tlu_exu_early_flush_pipe_w,
    input [40:0]            tlu_idtlb_dmp_key_g,
    input [1:0]             tlu_idtlb_dmp_thrid_g,
    input [7:0]             tlu_lsu_asi_m,
    input                   tlu_lsu_asi_update_m,
    input [3:0]             tlu_lsu_hpstate_en,
    input [3:0]             tlu_lsu_hpv_priv,
    input                   tlu_lsu_int_ld_ill_va_w2,
    input [63:0]            tlu_lsu_int_ldxa_data_w2,
    input                   tlu_lsu_int_ldxa_vld_w2,
    input                   tlu_lsu_ldxa_async_data_vld,
    input [1:0]             tlu_lsu_ldxa_tid_w2,
    input [25:0]            tlu_lsu_pcxpkt,
    input                   tlu_lsu_priv_trap_m,
    input [3:0]             tlu_lsu_pstate_am,
    input [3:0]             tlu_lsu_pstate_cle,
    input [3:0]             tlu_lsu_pstate_priv,
    input [1:0]             tlu_lsu_redmode,
    input [3:0]             tlu_lsu_redmode_rst_d1,
    input                   tlu_lsu_stxa_ack,
    input [1:0]             tlu_lsu_stxa_ack_tid,
    input [1:0]             tlu_lsu_tid_m,
    input [3:0]             tlu_lsu_tl_zero,
    `ifndef NO_RTL_CSM
    input                   tlu_dtlb_csm_rd_g,
    input [`TLB_CSM_LOCAL]  tlu_dtlb_tte_csm_w2,
    input [`TLB_CSM]        ifu_lsu_pcxcsm_e,
    input                   tlu_dtlb_wr_csm_sel_g,
    
    input [`CFG_CSM_STATE_WIDTH-1:0]   cfg_lsu_csm_dtlb_state,
    input [`NOC_CHIPID_WIDTH-1:0]      cfg_lsu_csm_dtlb_chipid,
    input [`NOC_X_WIDTH-1:0]           cfg_lsu_csm_dtlb_x,
    input [`NOC_Y_WIDTH-1:0]           cfg_lsu_csm_dtlb_y,
    input [`MSG_HDID_WIDTH-1:0]        cfg_lsu_csm_dtlb_hdid,
    input [`MSG_LHID_WIDTH-1:0]        cfg_lsu_csm_dtlb_hd_size,
    input [`MSG_SDID_WIDTH-1:0]        cfg_lsu_csm_dtlb_sdid,
    input [`MSG_LSID_WIDTH-1:0]        cfg_lsu_csm_dtlb_lsid,
    `endif
    input                   cfg_asi_lsu_ldxa_vld_w2,
    input [1:0]             cfg_asi_lsu_ldxa_tid_w2,
    input [63:0]            cfg_asi_lsu_ldxa_data_w2,
   
    // jtag debug
    // output wire [`CORE_JTAG_BUS_WIDTH-1:0] core_rtap_data,
    input wire rtap_core_val,
    input wire [1:0] rtap_core_threadid,
    input wire [`JTAG_CORE_ID_WIDTH-1:0]  rtap_core_id,
    input wire [13:0] rtap_core_data_13_0, 
    // sram wrapper interface
    output [`SRAM_WRAPPER_BUS_WIDTH-1:0] srams_rtap_data,
    input  [`BIST_OP_WIDTH-1:0] rtap_srams_bist_command,
    input  [`SRAM_WRAPPER_BUS_WIDTH-1:0] rtap_srams_bist_data,
    
    output                  ifu_tlu_flush_fd2_w,
    output                  ifu_tlu_flush_fd3_w,
    output                  ifu_tlu_flush_fd_w,
    output [7:0]            lsu_asi_reg0,
    output [7:0]            lsu_asi_reg1,
    output [7:0]            lsu_asi_reg2,
    output [7:0]            lsu_asi_reg3,
    output [3:0]            lsu_dmmu_sfsr_trp_wr,
    output [23:0]           lsu_dsfsr_din_g,
    output [63:0]           lsu_exu_dfill_data_w2,
    output                  lsu_exu_dfill_vld_w2,
    output                  lsu_exu_flush_pipe_w,
    output                  lsu_exu_ldst_miss_w2,
    output [4:0]            lsu_exu_rd_m,
    output                  lsu_exu_st_dtlb_perr_g,
    output [1:0]            lsu_exu_thr_m,
    output                  lsu_ffu_ack,
    output                  lsu_ffu_blk_asi_e,
    output                  lsu_ffu_flush_pipe_w,
    output [63:0]           lsu_ffu_ld_data,
    output                  lsu_ffu_ld_vld,
    output                  lsu_ffu_st_dtlb_perr_g,
    output                  lsu_ffu_stb_full0,
    output                  lsu_ffu_stb_full1,
    output                  lsu_ffu_stb_full2,
    output                  lsu_ffu_stb_full3,
    output [3:0]            lsu_ictag_mrgn,
    output [17:0]           lsu_ifu_asi_addr,
    output                  lsu_ifu_asi_load,
    output [7:0]            lsu_ifu_asi_state,
    output [1:0]            lsu_ifu_asi_thrid,
    output                  lsu_ifu_asi_vld,
    output [`CPX_VLD-1:0]   lsu_ifu_cpxpkt_i1,
    output                  lsu_ifu_cpxpkt_vld_i1,
    output                  lsu_ifu_dc_parity_error_w2,
    output                  lsu_ifu_dcache_data_perror,
    output                  lsu_ifu_dcache_tag_perror,
    output                  lsu_ifu_direct_map_l1,
    output [1:0]            lsu_ifu_error_tid,
    output                  lsu_ifu_flush_pipe_w,
    output [3:0]            lsu_ifu_icache_en,
    output                  lsu_ifu_io_error,
    output [3:0]            lsu_ifu_itlb_en,
    output                  lsu_ifu_l2_corr_error,
    output                  lsu_ifu_l2_unc_error,
    output [`IC_IDX_HI:5]           lsu_ifu_ld_icache_index,
    output [1:0]            lsu_ifu_ld_pcxpkt_tid,
    output                  lsu_ifu_ld_pcxpkt_vld,
    output [3:0]            lsu_ifu_ldst_cmplt,
    output                  lsu_ifu_ldst_miss_w,
    output                  lsu_ifu_ldsta_internal_e,
    output                  lsu_ifu_pcxpkt_ack_d,
    output                  lsu_ifu_stallreq,
    output [3:0]            lsu_ifu_stbcnt0,
    output [3:0]            lsu_ifu_stbcnt1,
    output [3:0]            lsu_ifu_stbcnt2,
    output [3:0]            lsu_ifu_stbcnt3,
    output [47:0]           lsu_ifu_stxa_data,
    output                  lsu_ifu_tlb_data_su,
    output                  lsu_ifu_tlb_data_ue,
    output                  lsu_ifu_tlb_tag_ue,
    output [7:0]            lsu_itlb_mrgn,
    output                  lsu_mmu_defr_trp_taken_g,
    output                  lsu_mmu_flush_pipe_w,
    output [63:0]           lsu_mmu_rs3_data_g,
    output [2:0]            lsu_pid_state0,
    output [2:0]            lsu_pid_state1,
    output [2:0]            lsu_pid_state2,
    output [2:0]            lsu_pid_state3,
    output [7:0]            lsu_spu_asi_state_e,
    output [12:0]           lsu_t0_pctxt_state,
    output [12:0]           lsu_t1_pctxt_state,
    output [12:0]           lsu_t2_pctxt_state,
    output [12:0]           lsu_t3_pctxt_state,
    output [1:0]            lsu_tlu_async_tid_w2,
    output                  lsu_tlu_async_ttype_vld_w2,
    output [6:0]            lsu_tlu_async_ttype_w2,
    output [3:0]            lsu_tlu_cpx_req,
    output                  lsu_tlu_cpx_vld,
    output                  lsu_tlu_daccess_excptn_g,
    output [3:0]            lsu_tlu_dcache_miss_w2,
    output                  lsu_tlu_defr_trp_taken_g,
    output                  lsu_tlu_dmmu_miss_g,
    output [12:0]           lsu_tlu_dside_ctxt_m,
    output                  lsu_tlu_dtlb_done,
    output                  lsu_tlu_early_flush2_w,
    output                  lsu_tlu_early_flush_w,
    output [17:0]           lsu_tlu_intpkt,
    output [3:0]            lsu_tlu_l2_dmiss,
    output [9:0]            lsu_tlu_ldst_va_m,
    output                  lsu_tlu_misalign_addr_ldst_atm_m,
    output [12:0]           lsu_tlu_pctxt_m,
    output                  lsu_tlu_pcxpkt_ack,
    output [63:0]           lsu_tlu_rs3_data_g,
    output [7:0]            lsu_tlu_rsr_data_e,
    output [3:0]            lsu_tlu_stb_full_w2,
    output [1:0]            lsu_tlu_thrid_d,
    output [1:0]            lsu_tlu_tlb_access_tid_m,
    output [7:0]            lsu_tlu_tlb_asi_state_m,
    output [47:13]          lsu_tlu_tlb_dmp_va_m,
    output                  lsu_tlu_tlb_ld_inst_m,
    output [`L1D_ADDRESS_HI:0]           lsu_tlu_tlb_ldst_va_m,
    output                  lsu_tlu_tlb_st_inst_m,
    output [8:0]            lsu_tlu_ttype_m2,
    output                  lsu_tlu_ttype_vld_m2,
    output                  lsu_tlu_wsr_inst_e,
    output                  spc_pcx_atom_pq,
    output [`PCX_WIDTH-1:0] spc_pcx_data_pa,
    output [4:0]            spc_pcx_req_pq,
    `ifndef NO_RTL_CSM
    output [`TLB_CSM]       spc_pcx_csm_pa,
    `endif

    input [`CPX_WIDTH-1:0]  cpx_spc_data_cx,
    input [47:0]            exu_lsu_ldst_va_e,
    input [`L1D_ADDRESS_HI:3]            exu_lsu_early_va_e,
    input   [80:0]          ffu_lsu_data ,


    output [7:0]            lsu_asi_state,
    output [47:4]           lsu_ifu_err_addr,
    output [15:0]           lsu_sscan_data ,
    // output                  ifu_tlu_inst_vld_m_bf1,
    output [2:0]            lsu_ffu_bld_cnt_w,

    input [7:0]             exu_tlu_wsr_data_m,
    output                  lsu_tlu_nucleus_ctxt_m ,
    output  [2:0]           lsu_tlu_tte_pg_sz_g ,
    output                  lsu_tlu_squash_va_oor_m,
    output                  lsu_tlu_wtchpt_trp_g,
    output                  lsu_tlu_daccess_prot_g,
    output                  lsu_tlu_priv_action_g
);
wire [`CORE_JTAG_BUS_WIDTH-1:0] core_rtap_data;
wire                  ifu_tlu_inst_vld_m_bf1; // trin: not needed

    lsu lsu(
       .ifu_tlu_wsr_inst_d          (ifu_tlu_wsr_inst_d),
       .lsu_ffu_st_dtlb_perr_g      (lsu_ffu_st_dtlb_perr_g),
       .tlu_lsu_priv_trap_m         (tlu_lsu_priv_trap_m),
       .short_si0                   (1'bx),
       .short_si1                   (1'bx),
       .short_so0                   (),
       .short_so1                   (),
       .si0                         (1'bx),
       .si1                         (1'bx),
       .so0                         (),
       .so1                         (),
       // reset stuff
       .grst_l                      (grst_l),
       .arst_l                      (arst_l),
       .clk                         (clk),
       .lsu_exu_dfill_data_w2       (lsu_exu_dfill_data_w2),
       .lsu_exu_dfill_vld_w2        (lsu_exu_dfill_vld_w2),
       .lsu_exu_ldst_miss_w2        (lsu_exu_ldst_miss_w2),
       .cpx_spc_data_cx             (cpx_spc_data_cx),
       .exu_tlu_wsr_data_m          (exu_tlu_wsr_data_m),
       .tlu_lsu_hpv_priv            (tlu_lsu_hpv_priv),
       .tlu_lsu_hpstate_en          (tlu_lsu_hpstate_en),

       .spu_lsu_int_w2              (1'b0),
       .gdbginit_l                  (gdbginit_l),
       `ifndef NO_RTL_CSM
       .spc_pcx_csm_pa              (spc_pcx_csm_pa),
       `endif
       .ifu_tlu_flush_fd2_w         (ifu_tlu_flush_fd2_w),
       .ifu_tlu_flush_fd3_w         (ifu_tlu_flush_fd3_w),
       .ifu_tlu_flush_fd_w          (ifu_tlu_flush_fd_w),
       .lsu_asi_reg0                (lsu_asi_reg0),
       .lsu_asi_reg1                (lsu_asi_reg1),
       .lsu_asi_reg2                (lsu_asi_reg2),
       .lsu_asi_reg3                (lsu_asi_reg3),
       .lsu_dmmu_sfsr_trp_wr        (lsu_dmmu_sfsr_trp_wr),
       .lsu_dsfsr_din_g             (lsu_dsfsr_din_g),
       .lsu_exu_flush_pipe_w        (lsu_exu_flush_pipe_w),
       .lsu_exu_rd_m                (lsu_exu_rd_m),
       .lsu_exu_st_dtlb_perr_g      (lsu_exu_st_dtlb_perr_g),
       .lsu_exu_thr_m               (lsu_exu_thr_m),
       .lsu_ffu_ack                 (lsu_ffu_ack),
       .lsu_ffu_blk_asi_e           (lsu_ffu_blk_asi_e),
       .lsu_ffu_flush_pipe_w        (lsu_ffu_flush_pipe_w),
       .lsu_ffu_ld_data             (lsu_ffu_ld_data),
       .lsu_ffu_ld_vld              (lsu_ffu_ld_vld),
       .lsu_ffu_stb_full0           (lsu_ffu_stb_full0),
       .lsu_ffu_stb_full1           (lsu_ffu_stb_full1),
       .lsu_ffu_stb_full2           (lsu_ffu_stb_full2),
       .lsu_ffu_stb_full3           (lsu_ffu_stb_full3),
       .lsu_ictag_mrgn              (lsu_ictag_mrgn),
       .lsu_ifu_asi_addr            (lsu_ifu_asi_addr),
       .lsu_ifu_asi_load            (lsu_ifu_asi_load),
       .lsu_ifu_asi_state           (lsu_ifu_asi_state),
       .lsu_ifu_asi_thrid           (lsu_ifu_asi_thrid),
       .lsu_ifu_asi_vld             (lsu_ifu_asi_vld),
       .lsu_ifu_cpxpkt_i1           (lsu_ifu_cpxpkt_i1),
       .lsu_ifu_cpxpkt_vld_i1       (lsu_ifu_cpxpkt_vld_i1),
       .lsu_ifu_dc_parity_error_w2  (lsu_ifu_dc_parity_error_w2),
       .lsu_ifu_dcache_data_perror  (lsu_ifu_dcache_data_perror),
       .lsu_ifu_dcache_tag_perror   (lsu_ifu_dcache_tag_perror),
       .lsu_ifu_direct_map_l1       (lsu_ifu_direct_map_l1),
       .lsu_ifu_error_tid           (lsu_ifu_error_tid),
       .lsu_ifu_flush_pipe_w        (lsu_ifu_flush_pipe_w),
       .lsu_ifu_icache_en           (lsu_ifu_icache_en),
       .lsu_ifu_io_error            (lsu_ifu_io_error),
       .lsu_ifu_itlb_en             (lsu_ifu_itlb_en),
       .lsu_ifu_l2_corr_error       (lsu_ifu_l2_corr_error),
       .lsu_ifu_l2_unc_error        (lsu_ifu_l2_unc_error),
       .lsu_ifu_ld_icache_index     (lsu_ifu_ld_icache_index),
       .lsu_ifu_ld_pcxpkt_tid       (lsu_ifu_ld_pcxpkt_tid),
       .lsu_ifu_ld_pcxpkt_vld       (lsu_ifu_ld_pcxpkt_vld),
       .lsu_ifu_ldst_cmplt          (lsu_ifu_ldst_cmplt),
       .lsu_ifu_ldst_miss_w         (lsu_ifu_ldst_miss_w),
       .lsu_ifu_ldsta_internal_e    (lsu_ifu_ldsta_internal_e),
       .lsu_ifu_pcxpkt_ack_d        (lsu_ifu_pcxpkt_ack_d),
       .lsu_ifu_stallreq            (lsu_ifu_stallreq),
       .lsu_ifu_stbcnt0             (lsu_ifu_stbcnt0),
       .lsu_ifu_stbcnt1             (lsu_ifu_stbcnt1),
       .lsu_ifu_stbcnt2             (lsu_ifu_stbcnt2),
       .lsu_ifu_stbcnt3             (lsu_ifu_stbcnt3),
       .lsu_ifu_stxa_data           (lsu_ifu_stxa_data),
       .lsu_ifu_tlb_data_su         (lsu_ifu_tlb_data_su),
       .lsu_ifu_tlb_data_ue         (lsu_ifu_tlb_data_ue),
       .lsu_ifu_tlb_tag_ue          (lsu_ifu_tlb_tag_ue),
       .lsu_itlb_mrgn               (lsu_itlb_mrgn),
       .lsu_mamem_mrgn              (),
       .lsu_mmu_defr_trp_taken_g    (lsu_mmu_defr_trp_taken_g),
       .lsu_mmu_flush_pipe_w        (lsu_mmu_flush_pipe_w),
       .lsu_mmu_rs3_data_g          (lsu_mmu_rs3_data_g),
       .lsu_pid_state0              (lsu_pid_state0),
       .lsu_pid_state1              (lsu_pid_state1),
       .lsu_pid_state2              (lsu_pid_state2),
       .lsu_pid_state3              (lsu_pid_state3),
       .lsu_spu_asi_state_e         (lsu_spu_asi_state_e),
       .lsu_spu_early_flush_g       (),
       .lsu_spu_ldst_ack            (),
       .lsu_spu_stb_empty           (),
       .lsu_spu_strm_ack_cmplt      (),
       .lsu_t0_pctxt_state          (lsu_t0_pctxt_state),
       .lsu_t1_pctxt_state          (lsu_t1_pctxt_state),
       .lsu_t2_pctxt_state          (lsu_t2_pctxt_state),
       .lsu_t3_pctxt_state          (lsu_t3_pctxt_state),
       .lsu_tlu_async_tid_w2        (lsu_tlu_async_tid_w2),
       .lsu_tlu_async_ttype_vld_w2  (lsu_tlu_async_ttype_vld_w2),
       .lsu_tlu_async_ttype_w2      (lsu_tlu_async_ttype_w2),
       .lsu_tlu_cpx_req             (lsu_tlu_cpx_req),
       .lsu_tlu_cpx_vld             (lsu_tlu_cpx_vld),
       .lsu_tlu_daccess_excptn_g    (lsu_tlu_daccess_excptn_g),
       .lsu_tlu_dcache_miss_w2      (lsu_tlu_dcache_miss_w2),
       .lsu_tlu_defr_trp_taken_g    (lsu_tlu_defr_trp_taken_g),
       .lsu_tlu_dmmu_miss_g         (lsu_tlu_dmmu_miss_g),
       .lsu_tlu_dside_ctxt_m        (lsu_tlu_dside_ctxt_m),
       .lsu_tlu_dtlb_done           (lsu_tlu_dtlb_done),
       .lsu_tlu_early_flush2_w      (lsu_tlu_early_flush2_w),
       .lsu_tlu_early_flush_w       (lsu_tlu_early_flush_w),
       .lsu_tlu_intpkt              (lsu_tlu_intpkt),
       .lsu_tlu_l2_dmiss            (lsu_tlu_l2_dmiss),
       .lsu_tlu_ldst_va_m           (lsu_tlu_ldst_va_m),
       .lsu_tlu_misalign_addr_ldst_atm_m(lsu_tlu_misalign_addr_ldst_atm_m),
       .lsu_tlu_pctxt_m             (lsu_tlu_pctxt_m),
       .lsu_tlu_pcxpkt_ack          (lsu_tlu_pcxpkt_ack),
       .lsu_tlu_rs3_data_g          (lsu_tlu_rs3_data_g),
       .lsu_tlu_rsr_data_e          (lsu_tlu_rsr_data_e),
       .lsu_tlu_stb_full_w2         (lsu_tlu_stb_full_w2),
       .lsu_tlu_thrid_d             (lsu_tlu_thrid_d),
       .lsu_tlu_tlb_access_tid_m    (lsu_tlu_tlb_access_tid_m),
       .lsu_tlu_tlb_asi_state_m     (lsu_tlu_tlb_asi_state_m),
       .lsu_tlu_tlb_dmp_va_m        (lsu_tlu_tlb_dmp_va_m),
       .lsu_tlu_tlb_ld_inst_m       (lsu_tlu_tlb_ld_inst_m),
       .lsu_tlu_tlb_ldst_va_m       (lsu_tlu_tlb_ldst_va_m),
       .lsu_tlu_tlb_st_inst_m       (lsu_tlu_tlb_st_inst_m),
       .lsu_tlu_ttype_m2            (lsu_tlu_ttype_m2),
       .lsu_tlu_ttype_vld_m2        (lsu_tlu_ttype_vld_m2),
       .lsu_tlu_wsr_inst_e          (lsu_tlu_wsr_inst_e),
       .spc_pcx_atom_pq             (spc_pcx_atom_pq),
       .spc_pcx_data_pa             (spc_pcx_data_pa),
       .spc_pcx_req_pq              (spc_pcx_req_pq),
       .lsu_asi_state               (lsu_asi_state),
       .lsu_ifu_err_addr            (lsu_ifu_err_addr),
       .lsu_sscan_data              (lsu_sscan_data),
       .ifu_tlu_inst_vld_m_bf1      (ifu_tlu_inst_vld_m_bf1),
       .lsu_ffu_bld_cnt_w           (lsu_ffu_bld_cnt_w),
       .lsu_tlu_nucleus_ctxt_m      (lsu_tlu_nucleus_ctxt_m),
       .lsu_tlu_tte_pg_sz_g         (lsu_tlu_tte_pg_sz_g),
       .lsu_tlu_squash_va_oor_m     (lsu_tlu_squash_va_oor_m),
       .lsu_tlu_wtchpt_trp_g        (lsu_tlu_wtchpt_trp_g),
       .lsu_tlu_daccess_prot_g      (lsu_tlu_daccess_prot_g),
       .lsu_tlu_priv_action_g       (lsu_tlu_priv_action_g),
       `ifndef NO_RTL_CSM
       .tlu_dtlb_csm_rd_g           (tlu_dtlb_csm_rd_g), 
       .tlu_dtlb_tte_csm_w2         ({1'bx, tlu_dtlb_tte_csm_w2}), 
       .ifu_lsu_pcxcsm_e            (ifu_lsu_pcxcsm_e), 
       .tlu_dtlb_wr_csm_sel_g       (tlu_dtlb_wr_csm_sel_g),

       .cfg_lsu_csm_dtlb_state      (cfg_lsu_csm_dtlb_state),
       .cfg_lsu_csm_dtlb_chipid     (cfg_lsu_csm_dtlb_chipid),
       .cfg_lsu_csm_dtlb_x          (cfg_lsu_csm_dtlb_x),
       .cfg_lsu_csm_dtlb_y          (cfg_lsu_csm_dtlb_y),
       .cfg_lsu_csm_dtlb_hdid       (cfg_lsu_csm_dtlb_hdid),
       .cfg_lsu_csm_dtlb_hd_size    (cfg_lsu_csm_dtlb_hd_size),
       .cfg_lsu_csm_dtlb_sdid       (cfg_lsu_csm_dtlb_sdid),
       .cfg_lsu_csm_dtlb_lsid       (cfg_lsu_csm_dtlb_lsid),

       `endif
       .bist_ctl_reg_out            (bist_ctl_reg_out),
       .const_cpuid                 (const_cpuid),
       .exu_lsu_rs2_data_e          (exu_lsu_rs2_data_e),
       .exu_lsu_rs3_data_e          (exu_lsu_rs3_data_e),
       .exu_tlu_misalign_addr_jmpl_rtn_m(exu_tlu_misalign_addr_jmpl_rtn_m),
       .exu_tlu_va_oor_m            (exu_tlu_va_oor_m),
       .ffu_lsu_blk_st_e            (ffu_lsu_blk_st_e),
       .ffu_lsu_blk_st_va_e         (ffu_lsu_blk_st_va_e),
       .ffu_lsu_fpop_rq_vld         (ffu_lsu_fpop_rq_vld),
       .ffu_lsu_kill_fst_w          (ffu_lsu_kill_fst_w),
       .ifu_lsu_alt_space_d         (ifu_lsu_alt_space_d),
       .ifu_lsu_alt_space_e         (ifu_lsu_alt_space_e),
       .ifu_lsu_asi_ack             (ifu_lsu_asi_ack),
       .ifu_lsu_asi_rd_unc          (ifu_lsu_asi_rd_unc),
       .ifu_lsu_casa_e              (ifu_lsu_casa_e),
       .ifu_lsu_destid_s            (ifu_lsu_destid_s),
       .ifu_lsu_fwd_data_vld        (ifu_lsu_fwd_data_vld),
       .ifu_lsu_fwd_wr_ack          (ifu_lsu_fwd_wr_ack),
       .ifu_lsu_ibuf_busy           (ifu_lsu_ibuf_busy),
       .ifu_lsu_imm_asi_d           (ifu_lsu_imm_asi_d),
       .ifu_lsu_imm_asi_vld_d       (ifu_lsu_imm_asi_vld_d),
       .ifu_lsu_inv_clear           (ifu_lsu_inv_clear),
       .ifu_lsu_ld_inst_e           (ifu_lsu_ld_inst_e),
       .ifu_lsu_ldst_dbl_e          (ifu_lsu_ldst_dbl_e),
       .ifu_lsu_ldst_fp_e           (ifu_lsu_ldst_fp_e),
       .ifu_lsu_ldst_size_e         (ifu_lsu_ldst_size_e),
       .ifu_lsu_ldstub_e            (ifu_lsu_ldstub_e),
       .ifu_lsu_ldxa_data_vld_w2    (ifu_lsu_ldxa_data_vld_w2),
       .ifu_lsu_ldxa_data_w2        (ifu_lsu_ldxa_data_w2),
       .ifu_lsu_ldxa_illgl_va_w2    (ifu_lsu_ldxa_illgl_va_w2),
       .ifu_lsu_ldxa_tid_w2         (ifu_lsu_ldxa_tid_w2),
       .ifu_lsu_memref_d            (ifu_lsu_memref_d),
       .ifu_lsu_nceen               (ifu_lsu_nceen),
       .ifu_lsu_pcxpkt_e            (ifu_lsu_pcxpkt_e),
       .ifu_lsu_pcxreq_d            (ifu_lsu_pcxreq_d),
       .ifu_lsu_pref_inst_e         (ifu_lsu_pref_inst_e),
       .ifu_lsu_rd_e                (ifu_lsu_rd_e),
       .ifu_lsu_sign_ext_e          (ifu_lsu_sign_ext_e),
       .ifu_lsu_st_inst_e           (ifu_lsu_st_inst_e),
       .ifu_lsu_swap_e              (ifu_lsu_swap_e),
       .ifu_lsu_thrid_s             (ifu_lsu_thrid_s),
       .ifu_tlu_flsh_inst_e         (ifu_tlu_flsh_inst_e),
       .ifu_tlu_flush_m             (ifu_tlu_flush_m),
       .ifu_tlu_inst_vld_m          (ifu_tlu_inst_vld_m),
       .ifu_tlu_mb_inst_e           (ifu_tlu_mb_inst_e),
       .ifu_tlu_sraddr_d            (ifu_tlu_sraddr_d),
       .ifu_tlu_thrid_e             (ifu_tlu_thrid_e),
       .pcx_spc_grant_px            ({4'bx, pcx_spc_grant_px0}),
       .se                          (1'b0),
       .sehold                      (1'b0),
       .spu_lsu_ldxa_data_vld_w2    (1'b0),
       .spu_lsu_ldxa_data_w2        (64'h0000000000000000),
       .spu_lsu_ldxa_illgl_va_w2    (1'b0),
       .spu_lsu_ldxa_tid_w2         (2'b00),
       .spu_lsu_stxa_ack            (1'b0),
       .spu_lsu_stxa_ack_tid        (2'b00),
       .spu_lsu_unc_error_w2        (1'b0),
       // .testmode_l                  (1'bx),
       .tlu_dsfsr_flt_vld           (tlu_dsfsr_flt_vld),
       .tlu_dtlb_data_rd_g          (tlu_dtlb_data_rd_g),
       .tlu_dtlb_dmp_actxt_g        (tlu_dtlb_dmp_actxt_g),
       .tlu_dtlb_dmp_all_g          (tlu_dtlb_dmp_all_g),
       .tlu_dtlb_dmp_nctxt_g        (tlu_dtlb_dmp_nctxt_g),
       .tlu_dtlb_dmp_pctxt_g        (tlu_dtlb_dmp_pctxt_g),
       .tlu_dtlb_dmp_sctxt_g        (tlu_dtlb_dmp_sctxt_g),
       .tlu_dtlb_dmp_vld_g          (tlu_dtlb_dmp_vld_g),
       .tlu_dtlb_invalidate_all_g   (tlu_dtlb_invalidate_all_g),
       .tlu_dtlb_rw_index_g         (tlu_dtlb_rw_index_g),
       .tlu_dtlb_rw_index_vld_g     (tlu_dtlb_rw_index_vld_g),
       .tlu_dtlb_tag_rd_g           (tlu_dtlb_tag_rd_g),
       .tlu_dtlb_tte_data_w2        (tlu_dtlb_tte_data_w2),
       .tlu_dtlb_tte_tag_w2         (tlu_dtlb_tte_tag_w2),
       .tlu_early_flush_pipe2_w     (tlu_early_flush_pipe2_w),
       .tlu_early_flush_pipe_w      (tlu_early_flush_pipe_w),
       .tlu_exu_early_flush_pipe_w  (tlu_exu_early_flush_pipe_w),
       .tlu_idtlb_dmp_key_g         (tlu_idtlb_dmp_key_g),
       .tlu_idtlb_dmp_thrid_g       (tlu_idtlb_dmp_thrid_g),
       .tlu_lsu_asi_m               (tlu_lsu_asi_m),
       .tlu_lsu_asi_update_m        (tlu_lsu_asi_update_m),
       .tlu_lsu_int_ld_ill_va_w2    (tlu_lsu_int_ld_ill_va_w2),
       .tlu_lsu_int_ldxa_data_w2    (tlu_lsu_int_ldxa_data_w2),
       .tlu_lsu_int_ldxa_vld_w2     (tlu_lsu_int_ldxa_vld_w2),
       .tlu_lsu_ldxa_async_data_vld (tlu_lsu_ldxa_async_data_vld),
       .tlu_lsu_ldxa_tid_w2         (tlu_lsu_ldxa_tid_w2),
       .tlu_lsu_pcxpkt              (tlu_lsu_pcxpkt),
       .tlu_lsu_pstate_am           (tlu_lsu_pstate_am),
       .tlu_lsu_pstate_cle          (tlu_lsu_pstate_cle),
       .tlu_lsu_pstate_priv         (tlu_lsu_pstate_priv),
       .tlu_lsu_redmode             ({2'bx, tlu_lsu_redmode}),
       .tlu_lsu_redmode_rst_d1      (tlu_lsu_redmode_rst_d1),
       .tlu_lsu_stxa_ack            (tlu_lsu_stxa_ack),
       .tlu_lsu_stxa_ack_tid        (tlu_lsu_stxa_ack_tid),
       .tlu_lsu_tid_m               (tlu_lsu_tid_m),
       .tlu_lsu_tl_zero             (tlu_lsu_tl_zero),
       .spu_lsu_ldst_pckt           (124'h0000000000000000000000000000000),
       .exu_lsu_ldst_va_e           (exu_lsu_ldst_va_e),
       .exu_lsu_early_va_e          (exu_lsu_early_va_e),
       .ffu_lsu_data                (ffu_lsu_data),
       .cfg_asi_lsu_ldxa_vld_w2     (cfg_asi_lsu_ldxa_vld_w2),
       .cfg_asi_lsu_ldxa_tid_w2     (cfg_asi_lsu_ldxa_tid_w2),
       .cfg_asi_lsu_ldxa_data_w2    (cfg_asi_lsu_ldxa_data_w2),
       // interface to srams
       .srams_rtap_data (srams_rtap_data),
       .rtap_srams_bist_command (rtap_srams_bist_command),
       .rtap_srams_bist_data (rtap_srams_bist_data),
    .core_rtap_data          (core_rtap_data),
    .rtap_core_val         (rtap_core_val),
    .rtap_core_threadid         (rtap_core_threadid),
    .rtap_core_id         (rtap_core_id),
    .rtap_core_data         ({{(`CORE_JTAG_BUS_WIDTH-14){1'bx}}, rtap_core_data_13_0})
    );
endmodule
