// Modified by Princeton University on June 9th, 2015
/*
* ========== Copyright Header Begin ==========================================
* 
* OpenSPARC T1 Processor File: tlu_asi_access_mt_1_rand_8_s2.s
* Copyright (c) 2006 Sun Microsystems, Inc.  All Rights Reserved.
* DO NOT ALTER OR REMOVE COPYRIGHT NOTICES.
* 
* The above named program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License version 2 as published by the Free Software Foundation.
* 
* The above named program is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
* 
* You should have received a copy of the GNU General Public
* License along with this work; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
* 
* ========== Copyright Header End ============================================
*/
/*
********************************************************************************
   random seed:	895973572
   Jal tlu_asi_access_mt_1.j:	
********************************************************************************/



#define PCONTEXT	0x10
#define SCONTEXT	0x10

#define MAIN_PAGE_NUCLEUS_ALSO
#define MAIN_PAGE_HV_ALSO

#define ALL_MY_INTR_HANDLERS
#include "my_intr_handlers.s"
#include "my_trap_handlers.s"
#include "tlu_custom_trap_handlers.s"

#include "enable_traps.h"
#include "boot.s"

.text
.global main

main:

	ta 	%icc, T_CHANGE_HPRIV
	mov	0x123, %g1
	wr	%g0, 0x20, %asi
	stxa	%g1, [0x00] %asi
	stxa	%g1, [0x08] %asi
	stxa	%g1, [0x10] %asi
	stxa	%g1, [0x18] %asi
	stxa	%g1, [0x20] %asi
	stxa	%g1, [0x28] %asi
	stxa	%g1, [0x30] %asi
	stxa	%g1, [0x38] %asi
	ta 	%icc, T_CHANGE_NONHPRIV

! Register init code

	setx 0x2da8a9de0000a2ac, %g1, %g0
	setx 0x0420d5e70000a0b0, %g1, %g1
	setx 0x1956357a000083b9, %g1, %g2
	setx 0x5f110e84000081e1, %g1, %g3
	setx 0xe27181e70000a34f, %g1, %g4
	setx 0x7616c3ee00004030, %g1, %g5
	setx 0x4e3c3a1b0000607a, %g1, %g6
	setx 0xef52b1c30000e1f2, %g1, %g7
	setx 0x2cd893fe00008052, %g1, %r16
	setx 0x6e888db00000c29e, %g1, %r17
	setx 0xf83b8cfb00000216, %g1, %r18
	setx 0xdfd0a1890000e3de, %g1, %r19
	setx 0xd27444b3000040ba, %g1, %r20
	setx 0xa8f07c610000c029, %g1, %r21
	setx 0x77326bad0000a130, %g1, %r22
	setx 0x4401fba80000e2f4, %g1, %r23
	setx 0x395668460000e33a, %g1, %r24
	setx 0xb23c9a6c000023c3, %g1, %r25
	setx 0x05f55f5c000021f1, %g1, %r26
	setx 0xce76be450000c0c7, %g1, %r27
	setx 0x801b36110000a0b0, %g1, %r28
	setx 0x88d4b4fe000061ed, %g1, %r29
	setx 0xbf333302000062dd, %g1, %r30
	setx 0x13c7bfb3000042a6, %g1, %r31
	save
	setx 0x2a8941450000801b, %g1, %r16
	setx 0xb10cf3ec0000a0cf, %g1, %r17
	setx 0x98d3d0500000636c, %g1, %r18
	setx 0xb7d53bc50000c18a, %g1, %r19
	setx 0x7ddef4b200000238, %g1, %r20
	setx 0xa92006c800004284, %g1, %r21
	setx 0x2066915c0000c1a5, %g1, %r22
	setx 0x9d9ec65c000042fe, %g1, %r23
	setx 0xfa4a5d910000e30f, %g1, %r24
	setx 0xb8f5dda50000e179, %g1, %r25
	setx 0x60b0acd80000204a, %g1, %r26
	setx 0x8e208d330000212a, %g1, %r27
	setx 0x519cb3d300000089, %g1, %r28
	setx 0xe7af43cf00000349, %g1, %r29
	setx 0xcb04319d0000436b, %g1, %r30
	setx 0xb3f4e3370000219b, %g1, %r31
	restore
#ifdef PORTABLE_CORE
	mov	PORTABLE_CORE, %g1
	sllx	%g1, 10, %g1
	or	%r8, %g1, %r8
	or	%r9, %g1, %r9
	or	%r10, %g1, %r10
	or	%r11, %g1, %r11
	or	%r12, %g1, %r12
	or	%r13, %g1, %r13
	or	%r14, %g1, %r14
	or	%r15, %g1, %r15
#endif
	mov	0x20, %r16
	mov	0x78, %r17
	mov	0x40, %r18
	mov	0x40, %r19
	mov	0x7c0, %r20
	mov	0x7f8, %r21
	mov	0x3e0, %r22
	mov	0x7c8, %r23
	mov	0x50, %r24
	mov	0x40, %r25
	mov	0x28, %r26
	mov	0x50, %r27
	mov	0, %r28
	mov	0, %r29
	mov	0, %r30
	mov	0, %r31
	ta	%icc, T_CHANGE_HPRIV
	wr	%g0, 0x73, %asi
	stxa	%g0, [%g0] 0x42
	mov	0x38, %g1
	stxa	%g0, [%g1] 0x58
	ta	%icc, T_RD_THID
! fork: source strm = 0xffffffff; target strm = 0x2
	cmp	%o1, 1
	setx	fork_lbl_0_1, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x4
	cmp	%o1, 2
	setx	fork_lbl_0_2, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x8
	cmp	%o1, 3
	setx	fork_lbl_0_3, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
	.word 0xd0b76000  ! 1: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd0cf2000  ! 2: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0xd08f2000  ! 3: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	.word 0xdc870e80  ! 4: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r14
	mov	0x48, %r25
	.word 0x87802020  ! 6: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 7: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b689e0  ! 8: STHA_R	stha	%r10, [%r26 + %r0] 0x4f
	.word 0xd4afe000  ! 9: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	mov	0x3d0, %r23
	.word 0xd487e000  ! 11: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	ta	T_CHANGE_PRIV	! macro
	.word 0xd4bd04a0  ! 13: STDA_R	stda	%r10, [%r20 + %r0] 0x25
	.word 0x87802072  ! 14: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c0, %r20
	.word 0x87802020  ! 16: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a42000  ! 17: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 18: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4bf6000  ! 19: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd4b72000  ! 20: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd4cfa000  ! 21: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	mov	0x40, %r19
	.word 0xd4bf6000  ! 23: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd4af2000  ! 24: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd49f6000  ! 25: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0xd4dfe000  ! 26: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802072  ! 27: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a7a000  ! 28: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xdacc4400  ! 29: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	.word 0xdaafa000  ! 30: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdab7a000  ! 31: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xd2d584a0  ! 32: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r9
	.word 0x87802020  ! 33: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 34: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 35: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r18
	mov	0x18, %r24
	mov	0x7d8, %r23
	mov	0x20, %r24
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2a4e000  ! 41: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 42: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2bf6000  ! 43: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd2df6000  ! 44: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2bfe000  ! 45: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd2a44400  ! 46: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xd2d72000  ! 47: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xd2dfa000  ! 48: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xded7ce80  ! 49: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r15
	mov	0x68, %r18
	.word 0xdaae89e0  ! 51: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 52: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb78e80  ! 53: STHA_R	stha	%r15, [%r30 + %r0] 0x74
	.word 0xdaf48400  ! 54: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	mov	0x3e0, %r20
	.word 0xdacc2000  ! 56: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xdabf0e80  ! 57: STDA_R	stda	%r13, [%r28 + %r0] 0x74
	.word 0xdec74e40  ! 58: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r15
	mov	0x20, %r27
	.word 0xd495c4a0  ! 60: LDUHA_R	lduha	[%r23, %r0] 0x25, %r10
	.word 0x87802020  ! 61: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8cc8400  ! 62: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0xdab4c400  ! 63: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xd8d5c4a0  ! 64: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r12
	.word 0xdc870e40  ! 65: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r14
	.word 0x87802072  ! 66: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 67: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdccf2000  ! 68: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xd0878e80  ! 69: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r8
	.word 0xd0d7e000  ! 70: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	mov	0x7f8, %r20
	.word 0xd8a44400  ! 72: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xde9fce80  ! 73: LDDA_R	ldda	[%r31, %r0] 0x74, %r15
	.word 0xdecf6000  ! 74: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0xdcf40400  ! 75: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xdcf7a000  ! 76: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcafa000  ! 77: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xd6b70e80  ! 78: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	mov	0x3c8, %r21
	mov	0x20, %r19
	.word 0xd6af6000  ! 81: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xde9e09e0  ! 82: LDDA_R	ldda	[%r24, %r0] 0x4f, %r15
	.word 0x87802073  ! 83: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde872000  ! 84: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xdef76000  ! 85: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdebf2000  ! 86: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	mov	0x30, %r16
	.word 0xdef7a000  ! 88: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 89: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a5c4a0  ! 90: STWA_R	stwa	%r10, [%r23 + %r0] 0x25
	.word 0xdedc0400  ! 91: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	.word 0x8780204f  ! 92: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda8f0e80  ! 93: LDUBA_R	lduba	[%r28, %r0] 0x74, %r13
	.word 0xdad62000  ! 94: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r13
	.word 0xd0cf4e40  ! 95: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	.word 0xd0bea000  ! 96: STDA_I	stda	%r8, [%r26 + 0x0000] %asi
	.word 0xd0d6e000  ! 97: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r8
	mov	0x68, %r17
	mov	0x3e0, %r23
	.word 0xda9f4e80  ! 100: LDDA_R	ldda	[%r29, %r0] 0x74, %r13
	.word 0xd28c0400  ! 101: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	.word 0xd4f689e0  ! 102: STXA_R	stxa	%r10, [%r26 + %r0] 0x4f
	.word 0xd8b544a0  ! 103: STHA_R	stha	%r12, [%r21 + %r0] 0x25
	.word 0xd2970e80  ! 104: LDUHA_R	lduha	[%r28, %r0] 0x74, %r9
	.word 0xdc840400  ! 105: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	.word 0x87802073  ! 106: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdea649e0  ! 107: STWA_R	stwa	%r15, [%r25 + %r0] 0x4f
	mov	0x7e0, %r20
	.word 0xdebf6000  ! 109: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xd2cf0e40  ! 110: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r9
	mov	0x3d0, %r22
	.word 0x87802072  ! 112: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f72000  ! 113: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 114: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd89d44a0  ! 115: LDDA_R	ldda	[%r21, %r0] 0x25, %r12
	.word 0xd8846000  ! 116: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	.word 0xdcdc8400  ! 117: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	.word 0xdc94e000  ! 118: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	.word 0xd69f8e80  ! 119: LDDA_R	ldda	[%r30, %r0] 0x74, %r11
	.word 0xdc8544a0  ! 120: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r14
	.word 0x87802020  ! 121: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccc6000  ! 122: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	.word 0xdebc4400  ! 123: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0x87802020  ! 124: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9ca000  ! 125: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	.word 0xde846000  ! 126: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0xdebc2000  ! 127: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0x87802020  ! 129: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 130: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e8, %r20
	.word 0xdac70e80  ! 132: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r13
	.word 0xdaafa000  ! 133: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 134: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d8, %r23
	.word 0xdaafe000  ! 136: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 137: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda972000  ! 138: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	mov	0x28, %r25
	.word 0x87802025  ! 140: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8da000  ! 141: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r13
	.word 0xdaad2000  ! 142: STBA_I	stba	%r13, [%r20 + 0x0000] %asi
	.word 0xdaa52000  ! 143: STWA_I	stwa	%r13, [%r20 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xda9d6000  ! 145: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r13
	.word 0xd4afce60  ! 146: STBA_R	stba	%r10, [%r31 + %r0] 0x73
	.word 0xd68e89e0  ! 147: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r11
	.word 0xd6a5e000  ! 148: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	.word 0xd0f40400  ! 149: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xd6bcc400  ! 150: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	mov	0x7d0, %r22
	.word 0xd4a70e40  ! 152: STWA_R	stwa	%r10, [%r28 + %r0] 0x72
	.word 0xd2a4c400  ! 153: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	mov	0x3d8, %r23
	.word 0xdeaf0e40  ! 155: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	.word 0xd6dc0400  ! 156: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	.word 0xd6f5a000  ! 157: STXA_I	stxa	%r11, [%r22 + 0x0000] %asi
	.word 0xd6ad6000  ! 158: STBA_I	stba	%r11, [%r21 + 0x0000] %asi
	mov	0x68, %r24
	.word 0xd8a5c4a0  ! 160: STWA_R	stwa	%r12, [%r23 + %r0] 0x25
	mov	0x70, %r16
	.word 0x87802020  ! 162: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bca000  ! 163: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd294c400  ! 164: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	.word 0xded70e40  ! 165: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r15
	mov	0x40, %r25
	mov	0x18, %r16
	mov	0x38, %r18
	.word 0x87802020  ! 169: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r24
	mov	0x70, %r24
	.word 0xd2a4c400  ! 172: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0x87802020  ! 173: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r16
	.word 0xd68d84a0  ! 175: LDUBA_R	lduba	[%r22, %r0] 0x25, %r11
	.word 0xd2b5c4a0  ! 176: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	mov	0x7d0, %r23
	.word 0x87802020  ! 178: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 179: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r22
	.word 0xd68649e0  ! 181: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r11
	.word 0xd687ce40  ! 182: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r11
	mov	0x3f8, %r22
	.word 0x87802020  ! 184: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a78e60  ! 185: STWA_R	stwa	%r8, [%r30 + %r0] 0x73
	.word 0xd0b40400  ! 186: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0xdcc74e40  ! 187: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r14
	.word 0xd0a44400  ! 188: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xd0cc2000  ! 189: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 190: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 191: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0d504a0  ! 192: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r8
	.word 0x87802020  ! 193: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r21
	.word 0xd094e000  ! 195: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0x87802072  ! 196: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd095c4a0  ! 197: LDUHA_R	lduha	[%r23, %r0] 0x25, %r8
	mov	0x0, %r24
	.word 0x87802020  ! 199: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdcb74e40  ! 201: STHA_R	stha	%r14, [%r29 + %r0] 0x72
	.word 0xdcf4a000  ! 202: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdc942000  ! 203: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	.word 0xda9fce40  ! 204: LDDA_R	ldda	[%r31, %r0] 0x72, %r13
	.word 0xdad42000  ! 205: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r13
	.word 0xdabca000  ! 206: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdab4a000  ! 207: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0xdaa42000  ! 208: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0xdecc0400  ! 209: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r15
	.word 0xdcdfce80  ! 210: LDXA_R	ldxa	[%r31, %r0] 0x74, %r14
	mov	0x60, %r26
	.word 0x87802025  ! 212: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc9d6000  ! 213: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r14
	.word 0xdccda000  ! 214: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r14
	mov	0x48, %r17
	.word 0xd8bf8e60  ! 216: STDA_R	stda	%r12, [%r30 + %r0] 0x73
	.word 0x87802074  ! 217: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdac74e40  ! 218: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r13
	.word 0xdcd74e40  ! 219: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r14
	mov	0x3e0, %r21
	.word 0xdad44400  ! 221: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0xdac7a000  ! 222: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0x87802020  ! 223: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ce89e0  ! 224: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r11
	.word 0xd6bca000  ! 225: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	mov	0x70, %r27
	.word 0x87802074  ! 227: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6af2000  ! 228: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd6bfe000  ! 229: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd49584a0  ! 230: LDUHA_R	lduha	[%r22, %r0] 0x25, %r10
	mov	0x78, %r24
	mov	0x7d8, %r22
	.word 0xd6de09e0  ! 233: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r11
	mov	0x8, %r16
	.word 0x87802074  ! 235: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b76000  ! 236: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 237: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef609e0  ! 238: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 239: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb72000  ! 240: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xd4d4c400  ! 241: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0x87802074  ! 242: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde8504a0  ! 243: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r15
	.word 0xd0b504a0  ! 244: STHA_R	stha	%r8, [%r20 + %r0] 0x25
	mov	0x58, %r25
	.word 0x87802073  ! 246: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd29e09e0  ! 247: LDDA_R	ldda	[%r24, %r0] 0x4f, %r9
	.word 0xdcf70e40  ! 248: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	.word 0xdc97e000  ! 249: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	mov	0x38, %r24
	.word 0xdcdf6000  ! 251: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xdca72000  ! 252: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcbf6000  ! 253: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdc872000  ! 254: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xdc8fa000  ! 255: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0x87802020  ! 256: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 257: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r20
	.word 0xd09fce40  ! 259: LDDA_R	ldda	[%r31, %r0] 0x72, %r8
	.word 0xd0c46000  ! 260: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r8
	mov	0x30, %r16
	.word 0xd8b40400  ! 262: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xde9e89e0  ! 263: LDDA_R	ldda	[%r26, %r0] 0x4f, %r15
	mov	0x50, %r18
	.word 0xdebc2000  ! 265: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xd4a40400  ! 266: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	mov	0x60, %r17
	mov	0x3c0, %r22
	.word 0xd4bc8400  ! 269: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	mov	0x70, %r17
	.word 0xdadc0400  ! 271: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	mov	0x3d0, %r23
	.word 0xdabc2000  ! 273: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xdab46000  ! 274: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 275: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdecf4e40  ! 276: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r15
	.word 0xdeb5e000  ! 277: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 278: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde96a000  ! 279: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r15
	.word 0xde9ec9e0  ! 280: LDDA_R	ldda	[%r27, %r0] 0x4f, %r15
	.word 0x87802020  ! 281: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb78e60  ! 282: STHA_R	stha	%r14, [%r30 + %r0] 0x73
	.word 0xdcdc6000  ! 283: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	.word 0xd0af8e80  ! 284: STBA_R	stba	%r8, [%r30 + %r0] 0x74
	.word 0xde8e49e0  ! 285: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r15
	.word 0xdef74e40  ! 286: STXA_R	stxa	%r15, [%r29 + %r0] 0x72
	.word 0xdef42000  ! 287: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xd694c400  ! 288: LDUHA_R	lduha	[%r19, %r0] 0x20, %r11
	.word 0x87802073  ! 289: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8cf0e40  ! 290: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r12
	.word 0xdcafce80  ! 291: STBA_R	stba	%r14, [%r31 + %r0] 0x74
	.word 0x87802020  ! 292: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r18
	.word 0xd09544a0  ! 294: LDUHA_R	lduha	[%r21, %r0] 0x25, %r8
	.word 0xdcf6c9e0  ! 295: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	.word 0x87802072  ! 296: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdccfe000  ! 297: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xd0c74e80  ! 298: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r8
	ta	T_CHANGE_HPRIV	! macro
	mov	0x3d0, %r20
	.word 0xdcc74e60  ! 301: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r14
	.word 0xdcdfe000  ! 302: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xdc8fe000  ! 303: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xdcaf2000  ! 304: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xd0c5c4a0  ! 305: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r8
	mov	0x3f0, %r22
	mov	0x20, %r16
	.word 0x87802073  ! 308: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r19
	.word 0xdcbcc400  ! 310: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xdcccc400  ! 311: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	.word 0x8780204f  ! 312: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde9fce80  ! 313: LDDA_R	ldda	[%r31, %r0] 0x74, %r15
	mov	0x7e0, %r23
	.word 0xdece6000  ! 315: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r15
	.word 0xdec6e000  ! 316: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r15
	mov	0x68, %r27
	mov	0x28, %r18
	.word 0x87802073  ! 319: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r26
	mov	0x3f0, %r20
	mov	0x10, %r25
	mov	0x78, %r19
	mov	0x7f8, %r20
	.word 0xdeb7a000  ! 325: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xde848400  ! 326: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	mov	0x60, %r17
	mov	0x38, %r26
	.word 0x87802072  ! 329: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3e0, %r23
	.word 0xd2970e40  ! 331: LDUHA_R	lduha	[%r28, %r0] 0x72, %r9
	.word 0xd4a78e40  ! 332: STWA_R	stwa	%r10, [%r30 + %r0] 0x72
	.word 0xd2a44400  ! 333: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	mov	0x78, %r24
	.word 0xdaf5c4a0  ! 335: STXA_R	stxa	%r13, [%r23 + %r0] 0x25
	mov	0x3d0, %r20
	.word 0x87802020  ! 337: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d649e0  ! 338: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r12
	mov	0x10, %r27
	mov	0x10, %r26
	mov	0x3c0, %r20
	.word 0x87802020  ! 342: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd884a000  ! 343: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r12
	.word 0xd8b4e000  ! 344: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0xdead44a0  ! 345: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	.word 0x87802072  ! 346: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r27
	.word 0x8780204f  ! 348: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r20
	mov	0x60, %r26
	.word 0xde8c0400  ! 351: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0xdebee000  ! 352: STDA_I	stda	%r15, [%r27 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xdeaee000  ! 354: STBA_I	stba	%r15, [%r27 + 0x0000] %asi
	.word 0xde870e80  ! 355: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r15
	.word 0xdecee000  ! 356: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r15
	mov	0x30, %r17
	.word 0xdece6000  ! 358: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r15
	.word 0xde9e6000  ! 359: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r15
	.word 0xd8cc8400  ! 360: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0x87802025  ! 361: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaa4c400  ! 362: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0xda85e000  ! 363: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	mov	0x58, %r18
	.word 0xd2cf4e40  ! 365: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r9
	.word 0xd0f78e40  ! 366: STXA_R	stxa	%r8, [%r30 + %r0] 0x72
	.word 0xd6d40400  ! 367: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	.word 0xda9c8400  ! 368: LDDA_R	ldda	[%r18, %r0] 0x20, %r13
	.word 0x87802020  ! 369: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf4a000  ! 370: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	mov	0x3f8, %r22
	.word 0xde870e80  ! 372: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r15
	.word 0xde94e000  ! 373: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	.word 0xdef46000  ! 374: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xdea42000  ! 375: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x10, %r17
	.word 0xdec4a000  ! 378: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xd8c74e80  ! 379: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r12
	.word 0xd88c6000  ! 380: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	mov	0x7e8, %r23
	.word 0xd8bce000  ! 382: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd8d46000  ! 383: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	.word 0xd8946000  ! 384: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	.word 0xd8a46000  ! 385: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xd4d5c4a0  ! 387: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r10
	.word 0xd4f4a000  ! 388: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0xd4bce000  ! 389: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0xd4a46000  ! 390: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xd4bc6000  ! 391: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xd8f7ce40  ! 392: STXA_R	stxa	%r12, [%r31 + %r0] 0x72
	.word 0xd8bc2000  ! 393: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd89c2000  ! 395: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	.word 0xd89fce80  ! 396: LDDA_R	ldda	[%r31, %r0] 0x74, %r12
	.word 0xde8f8e40  ! 397: LDUBA_R	lduba	[%r30, %r0] 0x72, %r15
	.word 0x87802074  ! 398: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeafe000  ! 399: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 400: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd68f8e40  ! 401: LDUBA_R	lduba	[%r30, %r0] 0x72, %r11
	.word 0xd6afe000  ! 402: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd6afa000  ! 403: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x7d8, %r22
	mov	0x28, %r18
	mov	0x10, %r26
	.word 0xd8af4e60  ! 407: STBA_R	stba	%r12, [%r29 + %r0] 0x73
	.word 0xd8f72000  ! 408: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8c72000  ! 409: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd2bfce80  ! 410: STDA_R	stda	%r9, [%r31 + %r0] 0x74
	.word 0x87802072  ! 411: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d8, %r20
	.word 0xd287a000  ! 413: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	mov	0x38, %r18
	.word 0xd8a4c400  ! 415: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	mov	0x7c8, %r20
	.word 0xd6cc8400  ! 417: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	.word 0xd6b72000  ! 418: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd8f689e0  ! 419: STXA_R	stxa	%r12, [%r26 + %r0] 0x4f
	.word 0xd8cf2000  ! 420: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	mov	0x3c8, %r20
	mov	0x0, %r18
	.word 0xd8cf6000  ! 423: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0xdac70e60  ! 424: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r13
	mov	0x70, %r17
	mov	0x40, %r17
	mov	0x3d8, %r21
	mov	0x7f0, %r21
	mov	0x60, %r27
	mov	0x40, %r24
	.word 0xd48c0400  ! 431: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	.word 0xdebc0400  ! 432: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	mov	0x68, %r16
	.word 0xda9e89e0  ! 434: LDDA_R	ldda	[%r26, %r0] 0x4f, %r13
	.word 0xdaa48400  ! 435: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0xda8f6000  ! 436: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xdad76000  ! 437: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0xd2f584a0  ! 438: STXA_R	stxa	%r9, [%r22 + %r0] 0x25
	.word 0xd2a72000  ! 439: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0xd2afa000  ! 440: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	mov	0x70, %r16
	.word 0xd29f2000  ! 442: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	mov	0x3d8, %r20
	.word 0x87802020  ! 444: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29ca000  ! 445: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd8b44400  ! 447: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	mov	0x78, %r17
	.word 0x87802074  ! 449: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2978e60  ! 450: LDUHA_R	lduha	[%r30, %r0] 0x73, %r9
	.word 0xd48dc4a0  ! 451: LDUBA_R	lduba	[%r23, %r0] 0x25, %r10
	mov	0x7d8, %r22
	mov	0x28, %r24
	.word 0xd4c7a000  ! 454: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	mov	0x3d8, %r20
	.word 0xdcbcc400  ! 456: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xdcbf6000  ! 457: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 458: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde978e60  ! 459: LDUHA_R	lduha	[%r30, %r0] 0x73, %r15
	.word 0x87802020  ! 460: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9ce000  ! 461: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0xde8ca000  ! 462: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	mov	0x3c8, %r21
	.word 0x87802020  ! 464: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea46000  ! 465: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xdecc2000  ! 466: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	.word 0xda86c9e0  ! 467: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r13
	.word 0xde9609e0  ! 468: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r15
	.word 0x87802020  ! 469: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a5c4a0  ! 470: STWA_R	stwa	%r11, [%r23 + %r0] 0x25
	.word 0x87802073  ! 471: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd69fe000  ! 472: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	.word 0xd4bf8e60  ! 473: STDA_R	stda	%r10, [%r30 + %r0] 0x73
	.word 0xd497a000  ! 474: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0xd4f7a000  ! 475: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	mov	0x38, %r19
	mov	0x18, %r25
	.word 0xd6a78e60  ! 478: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	mov	0x3e8, %r22
	mov	0x20, %r16
	mov	0x7f0, %r22
	mov	0x3e8, %r23
	.word 0xd6c76000  ! 483: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6cf6000  ! 484: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 485: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r17
	.word 0xd6cea000  ! 487: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	.word 0xdaa649e0  ! 488: STWA_R	stwa	%r13, [%r25 + %r0] 0x4f
	.word 0xdcbcc400  ! 489: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	mov	0x20, %r24
	.word 0xdcbe2000  ! 491: STDA_I	stda	%r14, [%r24 + 0x0000] %asi
	.word 0xdccf8e80  ! 492: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r14
	.word 0x87802073  ! 493: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc876000  ! 494: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0xdcd76000  ! 495: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	mov	0x3e8, %r23
	mov	0x0, %r16
	.word 0xdc9f6000  ! 498: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	mov	0x7e8, %r20
	.word 0xd0afce60  ! 500: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	.word 0xdcb44400  ! 501: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0x87802074  ! 502: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b4c400  ! 503: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0xd89c4400  ! 504: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	.word 0xd4f504a0  ! 505: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0xd4df2000  ! 506: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0xd88d44a0  ! 507: LDUBA_R	lduba	[%r21, %r0] 0x25, %r12
	mov	0x3e8, %r20
	.word 0xd8d72000  ! 509: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xd8bf2000  ! 510: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 511: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r21
	.word 0xd88c2000  ! 513: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	.word 0x87802025  ! 514: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r27
	.word 0xdaae09e0  ! 516: STBA_R	stba	%r13, [%r24 + %r0] 0x4f
	mov	0x3f0, %r21
	mov	0x0, %r27
	.word 0xd0bf8e40  ! 519: STDA_R	stda	%r8, [%r30 + %r0] 0x72
	.word 0xd0ade000  ! 520: STBA_I	stba	%r8, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 521: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0876000  ! 522: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd8cd84a0  ! 524: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r12
	.word 0xd6f70e80  ! 525: STXA_R	stxa	%r11, [%r28 + %r0] 0x74
	.word 0xd6bf6000  ! 526: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	mov	0x10, %r25
	mov	0x40, %r17
	mov	0x0, %r26
	.word 0xdacf4e80  ! 530: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r13
	.word 0xdaf7e000  ! 531: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xd2dc4400  ! 532: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	mov	0x50, %r17
	.word 0xd2cf6000  ! 534: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	mov	0x3f0, %r23
	mov	0x3e8, %r21
	.word 0xdaf48400  ! 537: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xd2b4c400  ! 538: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xd8cf4e40  ! 539: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r12
	.word 0xd8cf2000  ! 540: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x78, %r17
	.word 0xd88f6000  ! 543: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xd4ac8400  ! 544: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0xdac544a0  ! 545: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r13
	.word 0xda96c9e0  ! 546: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r13
	.word 0xd2948400  ! 547: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	.word 0xd29fa000  ! 548: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd2df2000  ! 549: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2c48400  ! 550: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	mov	0x28, %r25
	.word 0xd8f44400  ! 552: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xdca78e40  ! 553: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	.word 0xdaadc4a0  ! 554: STBA_R	stba	%r13, [%r23 + %r0] 0x25
	.word 0x8780204f  ! 555: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdece49e0  ! 556: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r15
	.word 0xd8cf8e80  ! 557: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r12
	.word 0xd6bfce40  ! 558: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	.word 0xd8a48400  ! 559: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	mov	0x0, %r24
	.word 0xd8aee000  ! 561: STBA_I	stba	%r12, [%r27 + 0x0000] %asi
	.word 0xd2df0e80  ! 562: LDXA_R	ldxa	[%r28, %r0] 0x74, %r9
	.word 0xd2f66000  ! 563: STXA_I	stxa	%r9, [%r25 + 0x0000] %asi
	.word 0xd8d74e80  ! 564: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r12
	mov	0x38, %r17
	.word 0xd4cfce80  ! 566: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r10
	.word 0xd0874e40  ! 567: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r8
	.word 0xd096e000  ! 568: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r8
	.word 0xde8649e0  ! 569: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r15
	.word 0xd2948400  ! 570: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	mov	0x20, %r24
	.word 0x8780204f  ! 572: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 573: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r18
	.word 0xd2bde000  ! 575: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 576: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d4a000  ! 577: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	.word 0xd2b4a000  ! 578: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0xded504a0  ! 580: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r15
	.word 0xdea4e000  ! 581: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xd8f4c400  ! 582: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xd2f6c9e0  ! 583: STXA_R	stxa	%r9, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 584: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd897ce80  ! 585: LDUHA_R	lduha	[%r31, %r0] 0x74, %r12
	mov	0x8, %r16
	.word 0xd4d78e40  ! 587: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r10
	mov	0x18, %r19
	.word 0xd8c48400  ! 589: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	mov	0x3f0, %r23
	.word 0x87802073  ! 591: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r26
	.word 0xd8a7e000  ! 593: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	mov	0x50, %r18
	mov	0x60, %r18
	.word 0x87802074  ! 596: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b5c4a0  ! 597: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	.word 0xd2af6000  ! 598: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	mov	0x48, %r26
	.word 0xd2c72000  ! 600: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	mov	0x18, %r27
	.word 0xd2bfa000  ! 602: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd2f7a000  ! 603: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 604: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c78e80  ! 605: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r11
	mov	0x58, %r16
	.word 0xd6c46000  ! 607: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r11
	mov	0x7c0, %r23
	.word 0xd6ac2000  ! 609: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	.word 0xdebf8e40  ! 610: STDA_R	stda	%r15, [%r30 + %r0] 0x72
	.word 0xd48fce60  ! 611: LDUBA_R	lduba	[%r31, %r0] 0x73, %r10
	.word 0xd89f0e60  ! 612: LDDA_R	ldda	[%r28, %r0] 0x73, %r12
	mov	0x60, %r16
	.word 0xd2dcc400  ! 614: LDXA_R	ldxa	[%r19, %r0] 0x20, %r9
	.word 0xd2c42000  ! 615: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	mov	0x60, %r18
	.word 0xd2cc6000  ! 617: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	.word 0x87802025  ! 618: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdef7ce60  ! 619: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0xdea5e000  ! 620: STWA_I	stwa	%r15, [%r23 + 0x0000] %asi
	.word 0xdead6000  ! 621: STBA_I	stba	%r15, [%r21 + 0x0000] %asi
	.word 0xd89d44a0  ! 622: LDDA_R	ldda	[%r21, %r0] 0x25, %r12
	.word 0xd28584a0  ! 623: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r9
	.word 0xdac689e0  ! 624: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r13
	mov	0x20, %r16
	.word 0xd0a649e0  ! 626: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	.word 0xd0a5e000  ! 627: STWA_I	stwa	%r8, [%r23 + 0x0000] %asi
	.word 0xd0bd2000  ! 628: STDA_I	stda	%r8, [%r20 + 0x0000] %asi
	.word 0xd286c9e0  ! 629: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r9
	mov	0x10, %r16
	.word 0xd28d2000  ! 631: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r9
	mov	0x70, %r17
	mov	0x7e0, %r21
	.word 0x8780204f  ! 634: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 635: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2976000  ! 636: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 637: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2962000  ! 638: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r9
	mov	0x78, %r24
	.word 0xd2c66000  ! 640: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r9
	.word 0x87802072  ! 641: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2afa000  ! 642: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 643: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaad84a0  ! 644: STBA_R	stba	%r13, [%r22 + %r0] 0x25
	mov	0x8, %r26
	mov	0x40, %r19
	.word 0xda9f6000  ! 647: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	mov	0x58, %r24
	.word 0xdabf6000  ! 649: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 650: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeddc4a0  ! 651: LDXA_R	ldxa	[%r23, %r0] 0x25, %r15
	.word 0xda8c4400  ! 652: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0xd68fce80  ! 653: LDUBA_R	lduba	[%r31, %r0] 0x74, %r11
	.word 0x87802025  ! 654: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6856000  ! 655: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 656: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd68e2000  ! 657: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r11
	.word 0xd2f7ce60  ! 658: STXA_R	stxa	%r9, [%r31 + %r0] 0x73
	.word 0xdac48400  ! 659: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	.word 0xded48400  ! 660: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	mov	0x18, %r18
	.word 0xd6f4c400  ! 662: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0xd6b6c9e0  ! 663: STHA_R	stha	%r11, [%r27 + %r0] 0x4f
	.word 0xd686a000  ! 664: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r11
	mov	0x68, %r18
	.word 0x87802074  ! 666: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb44400  ! 667: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	mov	0x7d8, %r23
	.word 0xdcafe000  ! 669: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 670: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2d70e80  ! 671: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r9
	.word 0x87802025  ! 672: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2ade000  ! 673: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0xd28da000  ! 674: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r9
	mov	0x18, %r25
	.word 0xd2bd2000  ! 676: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	.word 0xd0d544a0  ! 677: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r8
	.word 0xdc8f4e40  ! 678: LDUBA_R	lduba	[%r29, %r0] 0x72, %r14
	.word 0xd0a48400  ! 679: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0xdedfce60  ! 680: LDXA_R	ldxa	[%r31, %r0] 0x73, %r15
	.word 0xd48d84a0  ! 681: LDUBA_R	lduba	[%r22, %r0] 0x25, %r10
	.word 0xd4b5e000  ! 682: STHA_I	stha	%r10, [%r23 + 0x0000] %asi
	.word 0xd48d2000  ! 683: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	mov	0x78, %r18
	.word 0x87802025  ! 685: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd884c400  ! 686: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	mov	0x10, %r19
	.word 0xde8584a0  ! 688: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r15
	.word 0x87802025  ! 689: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 690: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r26
	.word 0xdeafa000  ! 692: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xd09544a0  ! 693: LDUHA_R	lduha	[%r21, %r0] 0x25, %r8
	.word 0xd0a76000  ! 694: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	mov	0x18, %r24
	.word 0x87802072  ! 696: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdec78e40  ! 697: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r15
	.word 0xdc9544a0  ! 698: LDUHA_R	lduha	[%r21, %r0] 0x25, %r14
	.word 0xdcf76000  ! 699: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xd28ec9e0  ! 700: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r9
	mov	0x7c0, %r20
	.word 0xd2b7e000  ! 702: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	mov	0x78, %r17
	mov	0x48, %r19
	.word 0x87802020  ! 705: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bd84a0  ! 706: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	mov	0x60, %r19
	.word 0xdaa74e40  ! 708: STWA_R	stwa	%r13, [%r29 + %r0] 0x72
	.word 0xd6b70e40  ! 709: STHA_R	stha	%r11, [%r28 + %r0] 0x72
	.word 0xd6cc2000  ! 710: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	.word 0x87802025  ! 711: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc9ec9e0  ! 712: LDDA_R	ldda	[%r27, %r0] 0x4f, %r14
	.word 0xdc8d2000  ! 713: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r14
	.word 0xdc95e000  ! 714: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r14
	.word 0xd6dc8400  ! 715: LDXA_R	ldxa	[%r18, %r0] 0x20, %r11
	.word 0xde9f0e40  ! 716: LDDA_R	ldda	[%r28, %r0] 0x72, %r15
	.word 0xd0f70e60  ! 717: STXA_R	stxa	%r8, [%r28 + %r0] 0x73
	mov	0x28, %r25
	.word 0xd2af4e40  ! 719: STBA_R	stba	%r9, [%r29 + %r0] 0x72
	.word 0xdac78e60  ! 720: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r13
	.word 0xdaada000  ! 721: STBA_I	stba	%r13, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 722: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdf0e80  ! 723: LDXA_R	ldxa	[%r28, %r0] 0x74, %r14
	.word 0xdca42000  ! 724: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	mov	0x3e0, %r23
	.word 0x87802072  ! 726: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6d74e80  ! 727: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r11
	.word 0xd6a7e000  ! 728: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6c76000  ! 729: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	mov	0x3e8, %r21
	.word 0xd6972000  ! 731: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	.word 0xd6b7e000  ! 732: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	mov	0x3f8, %r20
	mov	0x7f0, %r21
	.word 0xd6d7a000  ! 735: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	mov	0x3c0, %r22
	.word 0xdc8c4400  ! 737: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0xdcaf6000  ! 738: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdcaf8e40  ! 739: STBA_R	stba	%r14, [%r30 + %r0] 0x72
	mov	0x7d8, %r22
	.word 0xdc8fa000  ! 741: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdca72000  ! 742: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdccfa000  ! 743: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xdcafa000  ! 744: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xdcdf6000  ! 745: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xdcbfa000  ! 746: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdcb7e000  ! 747: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xdea48400  ! 748: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	mov	0x60, %r26
	.word 0xd8bc4400  ! 750: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xd8cdc4a0  ! 751: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r12
	.word 0xd28c4400  ! 752: LDUBA_R	lduba	[%r17, %r0] 0x20, %r9
	.word 0xd2dfe000  ! 753: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	mov	0x78, %r16
	.word 0xd2bf2000  ! 755: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd2bf6000  ! 756: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	mov	0x78, %r19
	mov	0x40, %r17
	.word 0xd297e000  ! 759: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	mov	0x58, %r24
	.word 0xded70e40  ! 761: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r15
	.word 0xd48d84a0  ! 762: LDUBA_R	lduba	[%r22, %r0] 0x25, %r10
	.word 0xdad7ce40  ! 763: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r13
	mov	0x7f8, %r23
	.word 0xd8d40400  ! 765: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	.word 0x87802074  ! 766: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8b7e000  ! 767: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	mov	0x68, %r19
	.word 0xd8a7a000  ! 769: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd2d78e80  ! 770: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r9
	.word 0xd2bfe000  ! 771: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd29fe000  ! 772: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd2af2000  ! 773: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd6ccc400  ! 774: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	.word 0xd6a76000  ! 775: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd2a74e80  ! 776: STWA_R	stwa	%r9, [%r29 + %r0] 0x74
	.word 0xd29f6000  ! 777: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	mov	0x3f0, %r23
	mov	0x3e0, %r22
	.word 0xd2c7e000  ! 780: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	mov	0x7c0, %r21
	mov	0x18, %r27
	mov	0x3f8, %r23
	.word 0x87802020  ! 784: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b70e60  ! 785: STHA_R	stha	%r10, [%r28 + %r0] 0x73
	.word 0x87802020  ! 786: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ac0400  ! 787: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0xd2cce000  ! 788: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	.word 0xd284e000  ! 789: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r9
	mov	0x30, %r19
	.word 0xd8ac0400  ! 791: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xd8a4c400  ! 792: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0x87802025  ! 793: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd88da000  ! 794: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r12
	.word 0xd8d5e000  ! 795: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r12
	.word 0xd8dd6000  ! 796: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r12
	mov	0x18, %r26
	.word 0x87802025  ! 798: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8ada000  ! 799: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0xd8bda000  ! 800: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	mov	0x60, %r27
	.word 0xd8ade000  ! 802: STBA_I	stba	%r12, [%r23 + 0x0000] %asi
	.word 0xd09c4400  ! 803: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	.word 0xd2bc0400  ! 804: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	mov	0x58, %r24
	.word 0xda8c8400  ! 806: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	.word 0xdaf5e000  ! 807: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0xda8da000  ! 808: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r13
	.word 0xdcaf4e80  ! 809: STBA_R	stba	%r14, [%r29 + %r0] 0x74
	.word 0xdcbfce40  ! 810: STDA_R	stda	%r14, [%r31 + %r0] 0x72
	.word 0xdcc5e000  ! 811: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r14
	.word 0xdc85e000  ! 812: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r14
	mov	0x70, %r25
	.word 0xd6cfce60  ! 814: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r11
	.word 0xd0f504a0  ! 815: STXA_R	stxa	%r8, [%r20 + %r0] 0x25
	.word 0xdc85c4a0  ! 816: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r14
	.word 0xdc9da000  ! 817: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r14
	.word 0xdcbd6000  ! 818: STDA_I	stda	%r14, [%r21 + 0x0000] %asi
	.word 0xd2ac8400  ! 819: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xd2a5a000  ! 820: STWA_I	stwa	%r9, [%r22 + 0x0000] %asi
	.word 0xdcc74e40  ! 821: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r14
	mov	0x68, %r24
	.word 0xdca5e000  ! 823: STWA_I	stwa	%r14, [%r23 + 0x0000] %asi
	.word 0x87802073  ! 824: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc976000  ! 825: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	.word 0xdcdfa000  ! 826: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	mov	0x40, %r19
	.word 0x87802025  ! 828: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 829: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r25
	.word 0xdcdfe000  ! 831: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xd2cf4e60  ! 832: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r9
	.word 0xd0a74e40  ! 833: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	.word 0xd0b7e000  ! 834: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 835: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r25
	mov	0x40, %r18
	mov	0x40, %r19
	.word 0x8780204f  ! 839: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0962000  ! 840: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r8
	mov	0x7e8, %r22
	.word 0xd6878e40  ! 842: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r11
	.word 0xd6dee000  ! 843: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r11
	.word 0xd4b44400  ! 844: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	.word 0xd0d584a0  ! 845: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r8
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x7c8, %r23
	mov	0x30, %r24
	mov	0x48, %r25
	.word 0x8780204f  ! 850: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd08ea000  ! 851: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r8
	.word 0x87802020  ! 852: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ace000  ! 853: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0xdcbe09e0  ! 854: STDA_R	stda	%r14, [%r24 + %r0] 0x4f
	.word 0xdcdc6000  ! 855: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	.word 0xdca46000  ! 856: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xdc84a000  ! 857: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	mov	0x3d8, %r21
	.word 0xda8f4e80  ! 859: LDUBA_R	lduba	[%r29, %r0] 0x74, %r13
	.word 0xd8cf8e80  ! 860: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r12
	.word 0xd8c46000  ! 861: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r12
	.word 0xd6978e80  ! 862: LDUHA_R	lduha	[%r30, %r0] 0x74, %r11
	.word 0xd6b4e000  ! 863: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	mov	0x8, %r18
	.word 0xd68ca000  ! 865: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r11
	.word 0xd0a7ce60  ! 866: STWA_R	stwa	%r8, [%r31 + %r0] 0x73
	.word 0xd2ad44a0  ! 867: STBA_R	stba	%r9, [%r21 + %r0] 0x25
	mov	0x40, %r26
	.word 0xd6af0e40  ! 869: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	.word 0xd8bf8e40  ! 870: STDA_R	stda	%r12, [%r30 + %r0] 0x72
	.word 0x87802074  ! 871: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacc8400  ! 872: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r13
	.word 0xdacf2000  ! 873: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	mov	0x70, %r16
	.word 0xd08e49e0  ! 875: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r8
	mov	0x3f0, %r23
	.word 0x87802073  ! 877: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0afe000  ! 878: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	mov	0x0, %r24
	.word 0xdcc584a0  ! 880: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r14
	.word 0xdcf7e000  ! 881: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x40, %r25
	.word 0xd6cfce40  ! 883: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r11
	.word 0xd6f72000  ! 884: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd2af4e40  ! 885: STBA_R	stba	%r9, [%r29 + %r0] 0x72
	.word 0xd2b7e000  ! 886: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd29fa000  ! 887: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xdccc4400  ! 888: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r14
	.word 0x87802073  ! 889: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 890: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b544a0  ! 891: STHA_R	stha	%r8, [%r21 + %r0] 0x25
	.word 0xd0b4e000  ! 892: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xd0be89e0  ! 893: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	mov	0x48, %r25
	.word 0xd0b46000  ! 895: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0xd0cce000  ! 896: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	mov	0x7d0, %r21
	mov	0x7c8, %r20
	.word 0xd0f42000  ! 899: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0xd0c4a000  ! 900: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	.word 0x87802020  ! 901: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 902: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b78e40  ! 903: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	.word 0xd6d78e60  ! 904: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r11
	mov	0x30, %r25
	.word 0xd6b7a000  ! 906: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	mov	0x3e8, %r20
	mov	0x8, %r25
	.word 0xd2f74e60  ! 909: STXA_R	stxa	%r9, [%r29 + %r0] 0x73
	.word 0xd28fe000  ! 910: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	mov	0x50, %r17
	.word 0xd2bfce40  ! 912: STDA_R	stda	%r9, [%r31 + %r0] 0x72
	.word 0xd2f78e40  ! 913: STXA_R	stxa	%r9, [%r30 + %r0] 0x72
	mov	0x60, %r16
	.word 0x87802073  ! 915: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 916: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r17
	.word 0xd2c46000  ! 918: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0x87802072  ! 919: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r17
	.word 0xd2d72000  ! 921: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xd287e000  ! 922: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0xdef7ce40  ! 923: STXA_R	stxa	%r15, [%r31 + %r0] 0x72
	mov	0x50, %r25
	mov	0x48, %r27
	.word 0xd0bc8400  ! 926: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0xd6bf8e40  ! 927: STDA_R	stda	%r11, [%r30 + %r0] 0x72
	.word 0xd6b72000  ! 928: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 929: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcd78e60  ! 930: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r14
	.word 0x87802020  ! 931: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc842000  ! 932: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	.word 0xdccc2000  ! 933: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r14
	.word 0xdc9c2000  ! 934: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r14
	.word 0xdc870e60  ! 935: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r14
	mov	0x68, %r26
	.word 0xd29c8400  ! 937: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	.word 0x87802025  ! 938: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2d5e000  ! 939: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r9
	mov	0x58, %r19
	.word 0xdc9f0e40  ! 941: LDDA_R	ldda	[%r28, %r0] 0x72, %r14
	mov	0x30, %r25
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcd5e000  ! 944: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r14
	.word 0x87802074  ! 945: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacfce60  ! 946: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r13
	.word 0xdaf7a000  ! 947: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xde9e09e0  ! 948: LDDA_R	ldda	[%r24, %r0] 0x4f, %r15
	.word 0xdebf6000  ! 949: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xdea7a000  ! 950: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 951: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 952: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd89f0e40  ! 953: LDDA_R	ldda	[%r28, %r0] 0x72, %r12
	.word 0xd88e2000  ! 954: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r12
	mov	0x50, %r24
	.word 0xd0cf4e40  ! 956: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	.word 0xd2874e40  ! 957: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r9
	mov	0x7d0, %r23
	.word 0xd2b62000  ! 959: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	.word 0xd286a000  ! 960: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r9
	mov	0x7e8, %r23
	mov	0x7c8, %r20
	.word 0xd2f62000  ! 963: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	mov	0x10, %r27
	.word 0x87802074  ! 965: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r16
	.word 0xd48f8e80  ! 967: LDUBA_R	lduba	[%r30, %r0] 0x74, %r10
	mov	0x3d8, %r23
	.word 0xd88f8e80  ! 969: LDUBA_R	lduba	[%r30, %r0] 0x74, %r12
	mov	0x40, %r16
	.word 0xd8c72000  ! 971: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8a70e80  ! 972: STWA_R	stwa	%r12, [%r28 + %r0] 0x74
	.word 0xd0c40400  ! 973: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	.word 0xd0872000  ! 974: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xd6b74e60  ! 975: STHA_R	stha	%r11, [%r29 + %r0] 0x73
	.word 0xd8d504a0  ! 976: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r12
	mov	0x58, %r26
	.word 0xdcae09e0  ! 978: STBA_R	stba	%r14, [%r24 + %r0] 0x4f
	mov	0x7d0, %r23
	.word 0xdcf7a000  ! 980: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xdccfe000  ! 981: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xd2c6c9e0  ! 982: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r9
	.word 0x87802020  ! 983: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab40400  ! 984: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xdeac8400  ! 985: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xdecc6000  ! 986: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r15
	.word 0xd4be09e0  ! 987: STDA_R	stda	%r10, [%r24 + %r0] 0x4f
	mov	0x68, %r19
	.word 0xd4b46000  ! 989: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xd69c4400  ! 990: LDDA_R	ldda	[%r17, %r0] 0x20, %r11
	.word 0xd684e000  ! 991: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r11
	.word 0x87802020  ! 992: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ac2000  ! 993: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	.word 0xd6d42000  ! 994: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r11
	mov	0x30, %r19
	.word 0x87802025  ! 996: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6ad2000  ! 997: STBA_I	stba	%r11, [%r20 + 0x0000] %asi
	.word 0x87802025  ! 998: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8f4e60  ! 999: LDUBA_R	lduba	[%r29, %r0] 0x73, %r13
	.word 0xdabda000  ! 1000: STDA_I	stda	%r13, [%r22 + 0x0000] %asi
	mov	0x7e0, %r22
	mov	0x20, %r16
	mov	0x30, %r16
	.word 0xdcae09e0  ! 1004: STBA_R	stba	%r14, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 1005: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r24
	.word 0xdedd84a0  ! 1007: LDXA_R	ldxa	[%r22, %r0] 0x25, %r15
	.word 0xd6bf8e40  ! 1008: STDA_R	stda	%r11, [%r30 + %r0] 0x72
	.word 0xd2b48400  ! 1009: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd2b66000  ! 1010: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	.word 0xd29ea000  ! 1011: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r9
	.word 0xdabf8e80  ! 1012: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	.word 0x87802072  ! 1013: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa40400  ! 1014: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0xd2974e80  ! 1015: LDUHA_R	lduha	[%r29, %r0] 0x74, %r9
	mov	0x3c8, %r23
	.word 0xd69f8e40  ! 1017: LDDA_R	ldda	[%r30, %r0] 0x72, %r11
	.word 0xd6c72000  ! 1018: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0xd69fe000  ! 1019: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	.word 0xd6a76000  ! 1020: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xdc85c4a0  ! 1021: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r14
	.word 0xd0c689e0  ! 1022: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r8
	.word 0x8780204f  ! 1023: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f78e60  ! 1024: STXA_R	stxa	%r8, [%r30 + %r0] 0x73
	.word 0xdabc8400  ! 1025: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	mov	0x7f8, %r23
	.word 0xdacf4e60  ! 1027: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r13
	.word 0xdac66000  ! 1028: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r13
	.word 0xd6b4c400  ! 1029: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 1030: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8dc0400  ! 1031: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	mov	0x3f0, %r20
	.word 0xd8f66000  ! 1033: STXA_I	stxa	%r12, [%r25 + 0x0000] %asi
	.word 0xd8b6a000  ! 1034: STHA_I	stha	%r12, [%r26 + 0x0000] %asi
	.word 0xd89c4400  ! 1035: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	.word 0xd8cea000  ! 1036: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r12
	.word 0xd8d66000  ! 1037: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r12
	mov	0x58, %r18
	mov	0x78, %r25
	.word 0xd8de2000  ! 1040: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r12
	.word 0xdcd44400  ! 1041: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	.word 0x87802025  ! 1042: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r26
	.word 0xdca52000  ! 1044: STWA_I	stwa	%r14, [%r20 + 0x0000] %asi
	.word 0xdc8da000  ! 1045: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r14
	.word 0xdc9d2000  ! 1046: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r14
	.word 0xdca5e000  ! 1047: STWA_I	stwa	%r14, [%r23 + 0x0000] %asi
	.word 0xdc8de000  ! 1048: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r14
	.word 0xdab74e80  ! 1049: STHA_R	stha	%r13, [%r29 + %r0] 0x74
	.word 0x87802072  ! 1050: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 1051: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2dfce60  ! 1052: LDXA_R	ldxa	[%r31, %r0] 0x73, %r9
	.word 0xd2bfe000  ! 1053: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd297e000  ! 1054: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	mov	0x60, %r19
	.word 0xd2d7e000  ! 1056: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xdc8c8400  ! 1057: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0xd0f6c9e0  ! 1058: STXA_R	stxa	%r8, [%r27 + %r0] 0x4f
	.word 0x87802025  ! 1059: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r17
	.word 0x87802020  ! 1061: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f609e0  ! 1062: STXA_R	stxa	%r9, [%r24 + %r0] 0x4f
	.word 0x87802025  ! 1063: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e8, %r22
	.word 0xd2f56000  ! 1065: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	.word 0xd2cde000  ! 1066: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r9
	.word 0xd28da000  ! 1067: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r9
	.word 0xd8bcc400  ! 1068: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0xd8f5e000  ! 1069: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	mov	0x10, %r16
	mov	0x78, %r19
	.word 0xd2f4c400  ! 1072: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xd2ad2000  ! 1073: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	mov	0x30, %r27
	.word 0xd2c649e0  ! 1075: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r9
	mov	0x3d8, %r20
	.word 0x87802073  ! 1077: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r16
	.word 0x8780204f  ! 1079: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2cee000  ! 1080: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	.word 0x87802072  ! 1081: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4944400  ! 1082: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	.word 0x87802020  ! 1083: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2af4e80  ! 1084: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	.word 0xd29c2000  ! 1085: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	.word 0xd2b46000  ! 1086: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 1087: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2bd2000  ! 1089: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	mov	0x60, %r17
	.word 0x87802073  ! 1091: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 1092: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bf2000  ! 1093: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd2c72000  ! 1094: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xdadf0e80  ! 1095: LDXA_R	ldxa	[%r28, %r0] 0x74, %r13
	.word 0xdaa72000  ! 1096: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xda8fe000  ! 1097: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xdaf7a000  ! 1098: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 1099: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 1100: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4940400  ! 1101: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	.word 0xd4dfe000  ! 1102: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4f76000  ! 1103: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 1104: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f74e60  ! 1105: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	.word 0xd89f2000  ! 1106: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0xd8dfa000  ! 1107: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	mov	0x50, %r25
	.word 0xd8976000  ! 1109: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	mov	0x48, %r19
	mov	0x58, %r17
	mov	0x28, %r16
	.word 0xd8afe000  ! 1113: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	mov	0x3e0, %r20
	mov	0x3e8, %r22
	.word 0xd8a7a000  ! 1116: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xdeb74e80  ! 1117: STHA_R	stha	%r15, [%r29 + %r0] 0x74
	mov	0x3c8, %r22
	mov	0x70, %r16
	mov	0x3d8, %r22
	.word 0x87802025  ! 1121: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r24
	.word 0x87802025  ! 1123: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebd6000  ! 1124: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 1125: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8ca000  ! 1126: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0xdeac6000  ! 1127: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xd4d78e60  ! 1128: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r10
	.word 0xd2b609e0  ! 1129: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdcccc400  ! 1131: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	.word 0xd684c400  ! 1132: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	.word 0xd6f46000  ! 1133: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0xd6ac2000  ! 1134: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	mov	0x78, %r17
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6d4a000  ! 1137: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r11
	.word 0xd694e000  ! 1138: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r11
	.word 0xd6cc6000  ! 1139: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r11
	mov	0x7c8, %r23
	.word 0xd8b44400  ! 1141: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0xd8aec9e0  ! 1142: STBA_R	stba	%r12, [%r27 + %r0] 0x4f
	.word 0xd4970e80  ! 1143: LDUHA_R	lduha	[%r28, %r0] 0x74, %r10
	.word 0xd4cc6000  ! 1144: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	.word 0xd6bc8400  ! 1145: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	mov	0x50, %r27
	.word 0x87802025  ! 1147: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d8, %r22
	.word 0xd6bd2000  ! 1149: STDA_I	stda	%r11, [%r20 + 0x0000] %asi
	.word 0xd6dd6000  ! 1150: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r11
	.word 0xdc978e40  ! 1151: LDUHA_R	lduha	[%r30, %r0] 0x72, %r14
	.word 0xd0a74e40  ! 1152: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	.word 0xd0b5e000  ! 1153: STHA_I	stha	%r8, [%r23 + 0x0000] %asi
	.word 0xd0ada000  ! 1154: STBA_I	stba	%r8, [%r22 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x3d8, %r20
	.word 0xd4ad84a0  ! 1157: STBA_R	stba	%r10, [%r22 + %r0] 0x25
	.word 0xdaa4c400  ! 1158: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	mov	0x0, %r24
	mov	0x70, %r25
	.word 0xdadd6000  ! 1161: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r13
	.word 0x87802025  ! 1162: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde8689e0  ! 1163: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r15
	.word 0x87802020  ! 1164: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f74e80  ! 1165: STXA_R	stxa	%r8, [%r29 + %r0] 0x74
	.word 0xd084a000  ! 1166: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	ta	T_CHANGE_PRIV	! macro
	.word 0xd4ac8400  ! 1168: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	mov	0x38, %r19
	.word 0xd4bf8e60  ! 1170: STDA_R	stda	%r10, [%r30 + %r0] 0x73
	mov	0x10, %r16
	.word 0xd4bc2000  ! 1172: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 1173: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4d76000  ! 1174: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	mov	0x7d0, %r22
	.word 0xd8be09e0  ! 1176: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	mov	0x28, %r24
	mov	0x40, %r17
	.word 0xd89f6000  ! 1179: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	.word 0xd8876000  ! 1180: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8dfe000  ! 1181: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xd89fe000  ! 1182: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	mov	0x7d8, %r23
	.word 0x8780204f  ! 1184: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d8, %r20
	.word 0xdecc4400  ! 1186: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r15
	.word 0x87802073  ! 1187: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r24
	.word 0xd28c8400  ! 1189: LDUBA_R	lduba	[%r18, %r0] 0x20, %r9
	.word 0xd2874e80  ! 1190: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r9
	.word 0x87802072  ! 1191: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8be89e0  ! 1192: STDA_R	stda	%r12, [%r26 + %r0] 0x4f
	.word 0xd8976000  ! 1193: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	mov	0x3c8, %r23
	mov	0x7c8, %r20
	.word 0xd8d6c9e0  ! 1196: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r12
	.word 0xd8b7e000  ! 1197: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	mov	0x70, %r16
	.word 0x87802020  ! 1199: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d42000  ! 1200: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	mov	0x7d0, %r22
	mov	0x50, %r27
	.word 0xd8d4a000  ! 1203: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0x87802073  ! 1204: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8d7e000  ! 1205: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0x87802073  ! 1206: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r17
	.word 0x87802020  ! 1208: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b6c9e0  ! 1209: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	.word 0xd8ac6000  ! 1210: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 1211: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf689e0  ! 1212: STXA_R	stxa	%r14, [%r26 + %r0] 0x4f
	.word 0xd4ae49e0  ! 1213: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0xd4bf2000  ! 1214: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd4afe000  ! 1215: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	mov	0x68, %r25
	.word 0xd4dfe000  ! 1217: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd48f2000  ! 1218: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0x87802074  ! 1219: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4bf2000  ! 1220: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd4cfa000  ! 1221: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	mov	0x38, %r27
	.word 0xd6dfce60  ! 1223: LDXA_R	ldxa	[%r31, %r0] 0x73, %r11
	.word 0xdadf4e40  ! 1224: LDXA_R	ldxa	[%r29, %r0] 0x72, %r13
	.word 0xd2bf8e60  ! 1225: STDA_R	stda	%r9, [%r30 + %r0] 0x73
	mov	0x7c0, %r22
	.word 0xd2b7a000  ! 1227: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd48f4e40  ! 1228: LDUBA_R	lduba	[%r29, %r0] 0x72, %r10
	mov	0x68, %r16
	mov	0x0, %r27
	.word 0xd4876000  ! 1231: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4afa000  ! 1232: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xdeaf4e80  ! 1233: STBA_R	stba	%r15, [%r29 + %r0] 0x74
	.word 0xdedfa000  ! 1234: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x3f8, %r23
	mov	0x70, %r25
	.word 0xd09d84a0  ! 1237: LDDA_R	ldda	[%r22, %r0] 0x25, %r8
	mov	0x7c8, %r23
	.word 0xd8f44400  ! 1239: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xd0acc400  ! 1240: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd0dfa000  ! 1241: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0b44400  ! 1243: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xdab7ce60  ! 1244: STHA_R	stha	%r13, [%r31 + %r0] 0x73
	.word 0xd4f584a0  ! 1245: STXA_R	stxa	%r10, [%r22 + %r0] 0x25
	.word 0xd4bfa000  ! 1246: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 1247: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r25
	.word 0xde8fce60  ! 1249: LDUBA_R	lduba	[%r31, %r0] 0x73, %r15
	mov	0x0, %r25
	.word 0xd2ce09e0  ! 1251: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r9
	mov	0x7f8, %r20
	.word 0xdc940400  ! 1253: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0xdcf5a000  ! 1254: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	.word 0xdcd5e000  ! 1255: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r14
	.word 0xd0a544a0  ! 1256: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	.word 0x87802020  ! 1257: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bc2000  ! 1258: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	.word 0xd4c70e80  ! 1259: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r10
	.word 0xd4b4e000  ! 1260: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xd4846000  ! 1261: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r10
	.word 0xd0878e40  ! 1262: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r8
	.word 0xdef6c9e0  ! 1263: STXA_R	stxa	%r15, [%r27 + %r0] 0x4f
	mov	0x7f0, %r20
	.word 0x87802073  ! 1265: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0f609e0  ! 1266: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	mov	0x3d8, %r21
	.word 0xd0df6000  ! 1268: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 1269: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0966000  ! 1270: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r8
	mov	0x3e8, %r21
	.word 0xd0962000  ! 1272: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r8
	.word 0xd0b66000  ! 1273: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	.word 0x87802074  ! 1274: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8d7ce60  ! 1275: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r12
	.word 0xdabf4e60  ! 1276: STDA_R	stda	%r13, [%r29 + %r0] 0x73
	mov	0x30, %r16
	mov	0x0, %r27
	.word 0x87802020  ! 1279: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1280: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r25
	mov	0x7d8, %r23
	.word 0x87802074  ! 1283: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdad76000  ! 1284: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 1285: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdad40400  ! 1286: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	.word 0xdaf6e000  ! 1287: STXA_I	stxa	%r13, [%r27 + 0x0000] %asi
	.word 0xd8bcc400  ! 1288: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0xdc84c400  ! 1289: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	.word 0xd89d84a0  ! 1290: LDDA_R	ldda	[%r22, %r0] 0x25, %r12
	.word 0xd2b48400  ! 1291: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd6f74e60  ! 1292: STXA_R	stxa	%r11, [%r29 + %r0] 0x73
	mov	0x3e8, %r23
	mov	0x78, %r16
	.word 0xdcbf0e40  ! 1295: STDA_R	stda	%r14, [%r28 + %r0] 0x72
	.word 0x87802020  ! 1296: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r17
	.word 0xd29f8e40  ! 1298: LDDA_R	ldda	[%r30, %r0] 0x72, %r9
	.word 0xd2a42000  ! 1299: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	.word 0xdadf8e60  ! 1300: LDXA_R	ldxa	[%r30, %r0] 0x73, %r13
	.word 0x87802020  ! 1301: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r18
	.word 0xd6f44400  ! 1303: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	mov	0x30, %r26
	.word 0xd6cc6000  ! 1305: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r11
	.word 0xd6b42000  ! 1306: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xdacc4400  ! 1308: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	mov	0x58, %r19
	.word 0xdab46000  ! 1310: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0xdacc6000  ! 1311: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1312: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r20
	.word 0xdad4e000  ! 1314: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r13
	.word 0xd886c9e0  ! 1315: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r12
	.word 0x87802074  ! 1316: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd887e000  ! 1317: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0x87802073  ! 1318: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8bfa000  ! 1319: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd0f44400  ! 1320: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd0f7a000  ! 1321: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xdabf8e80  ! 1322: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	.word 0xda9f2000  ! 1323: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xdea4c400  ! 1324: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	.word 0xde97e000  ! 1325: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	mov	0x7e0, %r22
	.word 0xdac40400  ! 1327: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	.word 0xd0b7ce40  ! 1328: STHA_R	stha	%r8, [%r31 + %r0] 0x72
	.word 0xd0df2000  ! 1329: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	mov	0x3c0, %r22
	.word 0xd2df8e40  ! 1331: LDXA_R	ldxa	[%r30, %r0] 0x72, %r9
	.word 0xd0c74e60  ! 1332: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r8
	mov	0x60, %r19
	.word 0x8780204f  ! 1334: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 1335: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd68e49e0  ! 1336: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r11
	.word 0xd6f52000  ! 1337: STXA_I	stxa	%r11, [%r20 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0xd6cde000  ! 1339: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r11
	mov	0x3e8, %r21
	.word 0xd8840400  ! 1341: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r12
	.word 0xd8b5a000  ! 1342: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	.word 0xd8ad2000  ! 1343: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 1344: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1345: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8cf6000  ! 1346: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	mov	0x7e0, %r23
	.word 0xd2f504a0  ! 1348: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	.word 0xd8d48400  ! 1349: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0xd8cc0400  ! 1350: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	mov	0x78, %r17
	mov	0x38, %r16
	.word 0xd8f76000  ! 1353: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd4a689e0  ! 1354: STWA_R	stwa	%r10, [%r26 + %r0] 0x4f
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x3c8, %r20
	mov	0x8, %r19
	mov	0x68, %r27
	.word 0xd4dfe000  ! 1359: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802072  ! 1360: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r26
	mov	0x20, %r27
	.word 0xd48f2000  ! 1363: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd4b78e60  ! 1365: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	.word 0xd09c4400  ! 1366: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	.word 0xdeac8400  ! 1367: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xdecf2000  ! 1368: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xda85c4a0  ! 1369: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r13
	mov	0x3c8, %r23
	.word 0xdabf2000  ! 1371: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	mov	0x30, %r27
	.word 0xda9f2000  ! 1373: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xd8d5c4a0  ! 1374: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r12
	.word 0xd6b40400  ! 1375: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0x87802020  ! 1376: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cdc4a0  ! 1377: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r10
	mov	0x50, %r27
	mov	0x10, %r18
	.word 0x87802074  ! 1380: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b74e60  ! 1381: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	.word 0xdc8f8e60  ! 1382: LDUBA_R	lduba	[%r30, %r0] 0x73, %r14
	.word 0xd6cf8e80  ! 1383: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r11
	.word 0xd6cd44a0  ! 1384: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r11
	.word 0x87802074  ! 1385: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 1386: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 1387: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8944400  ! 1388: LDUHA_R	lduha	[%r17, %r0] 0x20, %r12
	.word 0x87802020  ! 1389: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab48400  ! 1390: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	mov	0x20, %r24
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdaf4e000  ! 1393: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xdab46000  ! 1394: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xd6b689e0  ! 1396: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	.word 0x87802072  ! 1397: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8cf0e40  ! 1398: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r12
	mov	0x40, %r26
	mov	0x48, %r19
	.word 0xde8609e0  ! 1401: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r15
	.word 0xdecfa000  ! 1402: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xdad44400  ! 1403: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0x87802073  ! 1404: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdacf6000  ! 1405: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xdab72000  ! 1406: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdead44a0  ! 1407: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	mov	0x3e0, %r22
	.word 0x87802073  ! 1409: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde8f8e80  ! 1410: LDUBA_R	lduba	[%r30, %r0] 0x74, %r15
	.word 0xd6c649e0  ! 1411: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r11
	mov	0x58, %r26
	.word 0xdac70e80  ! 1413: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r13
	mov	0x28, %r19
	.word 0xda872000  ! 1415: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0xdad7e000  ! 1416: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xda876000  ! 1417: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0xdabf6000  ! 1418: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xda9f2000  ! 1419: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xdab7a000  ! 1420: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xd8d44400  ! 1422: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	.word 0xd8b7a000  ! 1423: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	mov	0x68, %r17
	mov	0x48, %r26
	.word 0xd8972000  ! 1426: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	.word 0xd8dfa000  ! 1427: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8f7e000  ! 1428: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	mov	0x20, %r16
	.word 0xd8d72000  ! 1430: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1431: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bc2000  ! 1432: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 1433: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 1434: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd89d2000  ! 1435: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r12
	.word 0xdedc0400  ! 1436: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	.word 0x87802074  ! 1437: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2cc0400  ! 1438: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r9
	.word 0xd0cdc4a0  ! 1439: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r8
	.word 0xd0af2000  ! 1440: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0d7a000  ! 1441: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1442: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0952000  ! 1443: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r8
	.word 0xd6b689e0  ! 1444: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	.word 0xd4a74e40  ! 1445: STWA_R	stwa	%r10, [%r29 + %r0] 0x72
	mov	0x40, %r16
	.word 0xd48d2000  ! 1447: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0xd0cf8e80  ! 1448: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r8
	.word 0xd0dd2000  ! 1449: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0xdaae09e0  ! 1450: STBA_R	stba	%r13, [%r24 + %r0] 0x4f
	mov	0x60, %r25
	.word 0xdaad6000  ! 1452: STBA_I	stba	%r13, [%r21 + 0x0000] %asi
	mov	0x7e0, %r21
	.word 0xd6bfce60  ! 1454: STDA_R	stda	%r11, [%r31 + %r0] 0x73
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd695a000  ! 1456: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r11
	.word 0xd6f56000  ! 1457: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	.word 0xdea504a0  ! 1458: STWA_R	stwa	%r15, [%r20 + %r0] 0x25
	.word 0xdaf78e60  ! 1459: STXA_R	stxa	%r13, [%r30 + %r0] 0x73
	.word 0xd2f44400  ! 1460: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 1461: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd29e2000  ! 1462: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r9
	.word 0xdcd74e80  ! 1463: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r14
	mov	0x20, %r24
	.word 0xdcaee000  ! 1465: STBA_I	stba	%r14, [%r27 + 0x0000] %asi
	.word 0x87802073  ! 1466: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcaf2000  ! 1467: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xd2c74e80  ! 1468: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r9
	mov	0x7f8, %r22
	.word 0xda8f8e60  ! 1470: LDUBA_R	lduba	[%r30, %r0] 0x73, %r13
	.word 0xdac7a000  ! 1471: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xd8d4c400  ! 1472: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	mov	0x3f8, %r21
	.word 0x87802020  ! 1474: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f7ce60  ! 1475: STXA_R	stxa	%r12, [%r31 + %r0] 0x73
	mov	0x40, %r24
	mov	0x3f8, %r22
	.word 0x87802020  ! 1478: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1479: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd88f2000  ! 1480: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0xd8f76000  ! 1481: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd09f8e80  ! 1482: LDDA_R	ldda	[%r30, %r0] 0x74, %r8
	.word 0xd09f6000  ! 1483: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	.word 0xd0df6000  ! 1484: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	mov	0x0, %r25
	.word 0xd0cfe000  ! 1486: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xd8b74e80  ! 1487: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	.word 0xd8f76000  ! 1488: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd0f70e80  ! 1489: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0xd29584a0  ! 1490: LDUHA_R	lduha	[%r22, %r0] 0x25, %r9
	.word 0x87802074  ! 1491: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b4c400  ! 1492: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 1493: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r25
	.word 0xdadfce80  ! 1495: LDXA_R	ldxa	[%r31, %r0] 0x74, %r13
	.word 0xdcd78e80  ! 1496: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r14
	.word 0xdc9e2000  ! 1497: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r14
	.word 0xd0b7ce80  ! 1498: STHA_R	stha	%r8, [%r31 + %r0] 0x74
	.word 0xd096e000  ! 1499: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r8
	.word 0xdacd04a0  ! 1500: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r13
	mov	0x10, %r18
	.word 0xdaa6a000  ! 1502: STWA_I	stwa	%r13, [%r26 + 0x0000] %asi
	.word 0xdaa6a000  ! 1503: STWA_I	stwa	%r13, [%r26 + 0x0000] %asi
	.word 0xdaf62000  ! 1504: STXA_I	stxa	%r13, [%r24 + 0x0000] %asi
	.word 0xd09ec9e0  ! 1505: LDDA_R	ldda	[%r27, %r0] 0x4f, %r8
	.word 0xd0b78e60  ! 1506: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	.word 0xd0be6000  ! 1507: STDA_I	stda	%r8, [%r25 + 0x0000] %asi
	.word 0x87802072  ! 1508: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0cfa000  ! 1509: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	mov	0x78, %r18
	.word 0xd2be89e0  ! 1511: STDA_R	stda	%r9, [%r26 + %r0] 0x4f
	.word 0xd2d7e000  ! 1512: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xdcac8400  ! 1513: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xdc8f6000  ! 1514: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdc87a000  ! 1515: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcaf6000  ! 1516: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdc97a000  ! 1517: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	mov	0x3f8, %r23
	.word 0xdcc7a000  ! 1519: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcbfe000  ! 1520: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1521: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbca000  ! 1522: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 1523: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r25
	.word 0xdc9f6000  ! 1525: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xdca5c4a0  ! 1526: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	.word 0xdcdfa000  ! 1527: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	.word 0xd8d609e0  ! 1528: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r12
	.word 0xd8b7e000  ! 1529: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 1530: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r25
	.word 0xd8b56000  ! 1532: STHA_I	stha	%r12, [%r21 + 0x0000] %asi
	.word 0xd88de000  ! 1533: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r12
	.word 0xd885e000  ! 1534: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r12
	.word 0xd885e000  ! 1535: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r12
	.word 0xd8b5e000  ! 1536: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	.word 0xd8f5e000  ! 1537: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	.word 0xd8dde000  ! 1538: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r12
	mov	0x40, %r18
	.word 0xd6a689e0  ! 1540: STWA_R	stwa	%r11, [%r26 + %r0] 0x4f
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x48, %r26
	.word 0xd49689e0  ! 1543: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r10
	.word 0xdc8dc4a0  ! 1544: LDUBA_R	lduba	[%r23, %r0] 0x25, %r14
	.word 0xd09649e0  ! 1545: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r8
	.word 0xd0c74e60  ! 1546: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r8
	.word 0xd09da000  ! 1547: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r8
	mov	0x30, %r25
	.word 0xd095a000  ! 1549: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r8
	.word 0xd0bd6000  ! 1550: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0xd0c56000  ! 1551: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1552: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r21
	mov	0x3c8, %r21
	.word 0xd0ace000  ! 1555: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0xd6ce89e0  ! 1556: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r11
	.word 0xd6bc2000  ! 1557: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0xd28504a0  ! 1559: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r9
	mov	0x3e8, %r22
	.word 0xd2dfce80  ! 1561: LDXA_R	ldxa	[%r31, %r0] 0x74, %r9
	.word 0xd48e89e0  ! 1562: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r10
	.word 0xd6a70e40  ! 1563: STWA_R	stwa	%r11, [%r28 + %r0] 0x72
	.word 0xd6bca000  ! 1564: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	.word 0xd6a649e0  ! 1565: STWA_R	stwa	%r11, [%r25 + %r0] 0x4f
	.word 0xd4b74e80  ! 1566: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	.word 0xd4dc2000  ! 1567: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	.word 0xdca40400  ! 1568: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0x87802073  ! 1569: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0af0e40  ! 1570: STBA_R	stba	%r8, [%r28 + %r0] 0x72
	.word 0xdcd649e0  ! 1571: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r14
	.word 0xdc976000  ! 1572: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	.word 0xdcf7e000  ! 1573: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0xdccfe000  ! 1575: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xd09f0e60  ! 1576: LDDA_R	ldda	[%r28, %r0] 0x73, %r8
	.word 0xd0c7a000  ! 1577: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xd087a000  ! 1578: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	mov	0x3f0, %r23
	mov	0x58, %r27
	.word 0x87802020  ! 1581: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cf0e40  ! 1582: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r8
	.word 0xd0f689e0  ! 1583: STXA_R	stxa	%r8, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 1584: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f4c400  ! 1585: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 1586: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2c6e000  ! 1587: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r9
	.word 0xdcf70e80  ! 1588: STXA_R	stxa	%r14, [%r28 + %r0] 0x74
	.word 0xda948400  ! 1589: LDUHA_R	lduha	[%r18, %r0] 0x20, %r13
	.word 0x87802020  ! 1590: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1591: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f0, %r21
	.word 0xd6dc8400  ! 1593: LDXA_R	ldxa	[%r18, %r0] 0x20, %r11
	.word 0xd6c62000  ! 1594: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r11
	.word 0xd2b78e40  ! 1595: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	.word 0xd4a74e40  ! 1596: STWA_R	stwa	%r10, [%r29 + %r0] 0x72
	.word 0xd8f4c400  ! 1597: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xd2948400  ! 1598: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	.word 0xdebf8e60  ! 1599: STDA_R	stda	%r15, [%r30 + %r0] 0x73
	.word 0xde86a000  ! 1600: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r15
	.word 0xdca7ce40  ! 1601: STWA_R	stwa	%r14, [%r31 + %r0] 0x72
	.word 0xd4af8e40  ! 1602: STBA_R	stba	%r10, [%r30 + %r0] 0x72
	.word 0xd4d62000  ! 1603: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r10
	.word 0xd4a6a000  ! 1604: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	mov	0x68, %r25
	.word 0xd48e6000  ! 1606: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r10
	mov	0x18, %r18
	.word 0x87802074  ! 1608: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd48fa000  ! 1609: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1610: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd494a000  ! 1611: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r10
	.word 0xd4b42000  ! 1612: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xd4f42000  ! 1614: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 1615: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4df8e60  ! 1616: LDXA_R	ldxa	[%r30, %r0] 0x73, %r10
	mov	0x7c8, %r23
	.word 0xd0acc400  ! 1618: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xdcb48400  ! 1619: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0x87802072  ! 1620: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc97a000  ! 1621: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	mov	0x48, %r27
	mov	0x3e8, %r21
	.word 0xd8bc4400  ! 1624: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	mov	0x40, %r25
	.word 0xd8c76000  ! 1626: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	mov	0x10, %r18
	.word 0xd887e000  ! 1628: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0x87802073  ! 1629: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8af6000  ! 1630: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8dfa000  ! 1632: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8bfa000  ! 1633: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd8af6000  ! 1634: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xdeaf4e60  ! 1635: STBA_R	stba	%r15, [%r29 + %r0] 0x73
	.word 0xdea4c400  ! 1636: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	.word 0xdea76000  ! 1637: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xdaf70e40  ! 1638: STXA_R	stxa	%r13, [%r28 + %r0] 0x72
	.word 0xdacf2000  ! 1639: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xd4a70e80  ! 1640: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	.word 0x87802020  ! 1641: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r22
	.word 0x8780204f  ! 1643: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f62000  ! 1644: STXA_I	stxa	%r10, [%r24 + 0x0000] %asi
	.word 0xd4f6a000  ! 1645: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	.word 0xdcafce40  ! 1646: STBA_R	stba	%r14, [%r31 + %r0] 0x72
	mov	0x7c0, %r20
	.word 0xd4f70e80  ! 1648: STXA_R	stxa	%r10, [%r28 + %r0] 0x74
	.word 0xd48e2000  ! 1649: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r10
	.word 0xd48ea000  ! 1650: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1651: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd494e000  ! 1652: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	.word 0xd0dd84a0  ! 1653: LDXA_R	ldxa	[%r22, %r0] 0x25, %r8
	.word 0xd0f4a000  ! 1654: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	mov	0x78, %r19
	.word 0xd494c400  ! 1656: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	.word 0xdeacc400  ! 1657: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0x87802073  ! 1658: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde8f2000  ! 1659: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0x87802073  ! 1660: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 1661: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde8fe000  ! 1662: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0xd8a78e80  ! 1663: STWA_R	stwa	%r12, [%r30 + %r0] 0x74
	mov	0x70, %r26
	.word 0xd887a000  ! 1665: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xd0b7ce80  ! 1666: STHA_R	stha	%r8, [%r31 + %r0] 0x74
	mov	0x68, %r25
	.word 0xd0dfa000  ! 1668: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0xd2f70e40  ! 1669: STXA_R	stxa	%r9, [%r28 + %r0] 0x72
	.word 0xde9f0e60  ! 1670: LDDA_R	ldda	[%r28, %r0] 0x73, %r15
	mov	0x50, %r17
	mov	0x28, %r17
	.word 0x8780204f  ! 1673: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6cf0e40  ! 1674: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r11
	mov	0x28, %r27
	mov	0x3f0, %r23
	.word 0xdaa78e80  ! 1677: STWA_R	stwa	%r13, [%r30 + %r0] 0x74
	.word 0x87802025  ! 1678: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 1679: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4af0e80  ! 1680: STBA_R	stba	%r10, [%r28 + %r0] 0x74
	.word 0x87802020  ! 1681: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bf0e80  ! 1682: STDA_R	stda	%r8, [%r28 + %r0] 0x74
	.word 0xd0bca000  ! 1683: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 1684: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a56000  ! 1685: STWA_I	stwa	%r8, [%r21 + 0x0000] %asi
	.word 0xd0f52000  ! 1686: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 1687: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0c42000  ! 1688: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r8
	.word 0xdab649e0  ! 1689: STHA_R	stha	%r13, [%r25 + %r0] 0x4f
	.word 0x87802072  ! 1690: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda9f2000  ! 1691: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xdcaf4e80  ! 1692: STBA_R	stba	%r14, [%r29 + %r0] 0x74
	mov	0x0, %r24
	.word 0xdca72000  ! 1694: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xd6b5c4a0  ! 1695: STHA_R	stha	%r11, [%r23 + %r0] 0x25
	mov	0x40, %r24
	.word 0xdc8689e0  ! 1697: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r14
	mov	0x70, %r17
	.word 0xd29f0e80  ! 1699: LDDA_R	ldda	[%r28, %r0] 0x74, %r9
	.word 0xd2af2000  ! 1700: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2cf4e40  ! 1702: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r9
	.word 0xd2d7a000  ! 1703: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0x87802073  ! 1704: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2bf8e40  ! 1705: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	.word 0xd2afe000  ! 1706: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	mov	0x58, %r26
	.word 0xd2a7a000  ! 1708: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 1709: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 1710: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2dd2000  ! 1711: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 1712: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6840400  ! 1713: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0xd6b6e000  ! 1714: STHA_I	stha	%r11, [%r27 + 0x0000] %asi
	mov	0x28, %r16
	.word 0xd696a000  ! 1716: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r11
	.word 0xd6be09e0  ! 1717: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	.word 0xd6dea000  ! 1718: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r11
	.word 0xd4cf8e80  ! 1719: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r10
	.word 0x8780204f  ! 1720: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2970e60  ! 1721: LDUHA_R	lduha	[%r28, %r0] 0x73, %r9
	.word 0xd2aee000  ! 1722: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	.word 0xdcf74e60  ! 1723: STXA_R	stxa	%r14, [%r29 + %r0] 0x73
	mov	0x0, %r26
	.word 0xd6af0e60  ! 1725: STBA_R	stba	%r11, [%r28 + %r0] 0x73
	.word 0xd4f649e0  ! 1726: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	.word 0x87802074  ! 1727: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4bfa000  ! 1728: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	mov	0x18, %r18
	mov	0x3f0, %r21
	.word 0xd4a72000  ! 1731: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd8c48400  ! 1732: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	.word 0x87802020  ! 1733: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bdc4a0  ! 1734: STDA_R	stda	%r8, [%r23 + %r0] 0x25
	.word 0xd08ca000  ! 1735: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xd8a48400  ! 1736: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	mov	0x28, %r17
	.word 0xdab609e0  ! 1738: STHA_R	stha	%r13, [%r24 + %r0] 0x4f
	mov	0x60, %r25
	.word 0xda9c6000  ! 1740: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	mov	0x8, %r18
	.word 0xd4a74e60  ! 1742: STWA_R	stwa	%r10, [%r29 + %r0] 0x73
	.word 0xd4b42000  ! 1743: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	.word 0xd4dc2000  ! 1744: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	mov	0x3e0, %r20
	mov	0x70, %r24
	.word 0xd8c7ce40  ! 1747: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r12
	.word 0xd29e89e0  ! 1748: LDDA_R	ldda	[%r26, %r0] 0x4f, %r9
	.word 0x87802020  ! 1749: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49f0e80  ! 1750: LDDA_R	ldda	[%r28, %r0] 0x74, %r10
	.word 0xdcaf0e40  ! 1751: STBA_R	stba	%r14, [%r28 + %r0] 0x72
	.word 0xdcf46000  ! 1752: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0xdcbca000  ! 1754: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 1755: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcde2000  ! 1756: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r14
	.word 0xdcbe2000  ! 1757: STDA_I	stda	%r14, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 1758: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b4c400  ! 1759: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	mov	0x40, %r17
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0ad04a0  ! 1762: STBA_R	stba	%r8, [%r20 + %r0] 0x25
	.word 0x87802020  ! 1763: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a4a000  ! 1764: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0x87802073  ! 1766: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0afe000  ! 1767: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0df6000  ! 1768: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0bfa000  ! 1769: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	mov	0x10, %r24
	mov	0x0, %r25
	mov	0x7c0, %r22
	.word 0xd29c8400  ! 1773: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	mov	0x60, %r18
	mov	0x78, %r25
	.word 0xd2cf6000  ! 1776: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 1777: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d0, %r21
	.word 0x87802074  ! 1779: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r19
	.word 0xd4a70e40  ! 1781: STWA_R	stwa	%r10, [%r28 + %r0] 0x72
	.word 0x87802020  ! 1782: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r18
	.word 0x87802072  ! 1784: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f0, %r23
	.word 0xd2f70e60  ! 1786: STXA_R	stxa	%r9, [%r28 + %r0] 0x73
	.word 0xd2c7a000  ! 1787: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2a76000  ! 1788: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd2bf8e60  ! 1789: STDA_R	stda	%r9, [%r30 + %r0] 0x73
	mov	0x7c0, %r23
	.word 0x87802020  ! 1791: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd284a000  ! 1792: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	.word 0xd2b4e000  ! 1793: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0xd8a7ce60  ! 1794: STWA_R	stwa	%r12, [%r31 + %r0] 0x73
	mov	0x38, %r24
	.word 0xd8aca000  ! 1796: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0xd894a000  ! 1797: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r12
	.word 0xd8a4a000  ! 1798: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8a42000  ! 1799: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	mov	0x8, %r19
	mov	0x7e8, %r20
	.word 0xd4ce49e0  ! 1802: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r10
	.word 0xd4f4e000  ! 1803: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	mov	0x40, %r19
	mov	0x3e0, %r23
	.word 0xd4df4e40  ! 1806: LDXA_R	ldxa	[%r29, %r0] 0x72, %r10
	.word 0xd4ace000  ! 1807: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	mov	0x60, %r18
	mov	0x20, %r16
	mov	0x60, %r19
	mov	0x30, %r25
	.word 0xd4bc2000  ! 1812: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0xd8b74e60  ! 1813: STHA_R	stha	%r12, [%r29 + %r0] 0x73
	.word 0xdcdf4e80  ! 1814: LDXA_R	ldxa	[%r29, %r0] 0x74, %r14
	.word 0x87802073  ! 1815: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r27
	.word 0xdcf78e40  ! 1817: STXA_R	stxa	%r14, [%r30 + %r0] 0x72
	.word 0x87802074  ! 1818: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcafa000  ! 1819: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 1820: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c0, %r20
	.word 0x87802073  ! 1822: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4978e40  ! 1823: LDUHA_R	lduha	[%r30, %r0] 0x72, %r10
	.word 0x87802073  ! 1824: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4dc4400  ! 1825: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	.word 0xd4dfa000  ! 1826: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4af6000  ! 1827: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd6af4e80  ! 1828: STBA_R	stba	%r11, [%r29 + %r0] 0x74
	.word 0xd6df6000  ! 1829: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	mov	0x7c0, %r23
	.word 0xd6afe000  ! 1831: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x48, %r26
	.word 0xd6ce49e0  ! 1833: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r11
	.word 0xdaf544a0  ! 1834: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	.word 0xdacf6000  ! 1835: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xdaafe000  ! 1836: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xd4d504a0  ! 1837: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r10
	.word 0xd4afa000  ! 1838: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xde8e09e0  ! 1839: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r15
	.word 0xdcccc400  ! 1840: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	.word 0x8780204f  ! 1841: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcdee000  ! 1842: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r14
	mov	0x70, %r27
	.word 0x8780204f  ! 1844: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r25
	.word 0xdcc66000  ! 1846: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 1847: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4c504a0  ! 1848: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r10
	.word 0xd2d40400  ! 1849: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	.word 0x87802020  ! 1850: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0c78e40  ! 1851: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r8
	.word 0xd2bfce40  ! 1852: STDA_R	stda	%r9, [%r31 + %r0] 0x72
	.word 0xd8df4e80  ! 1853: LDXA_R	ldxa	[%r29, %r0] 0x74, %r12
	.word 0x87802073  ! 1854: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 1855: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f4c400  ! 1856: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xdaa584a0  ! 1857: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	.word 0xd0c40400  ! 1858: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	.word 0x87802073  ! 1859: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 1860: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1861: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r26
	.word 0xd0c4e000  ! 1863: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	.word 0x87802073  ! 1864: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0af2000  ! 1865: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 1866: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f609e0  ! 1867: STXA_R	stxa	%r9, [%r24 + %r0] 0x4f
	.word 0xd2a44400  ! 1868: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 1869: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeb74e40  ! 1870: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	.word 0xdede2000  ! 1871: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r15
	mov	0x60, %r16
	.word 0xdea74e60  ! 1873: STWA_R	stwa	%r15, [%r29 + %r0] 0x73
	.word 0xdca74e40  ! 1874: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	.word 0x87802073  ! 1875: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb7a000  ! 1876: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	mov	0x68, %r26
	.word 0xd8ce89e0  ! 1878: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r12
	.word 0xd8af2000  ! 1879: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	mov	0x70, %r26
	.word 0xd887e000  ! 1881: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0x87802074  ! 1882: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6978e80  ! 1883: LDUHA_R	lduha	[%r30, %r0] 0x74, %r11
	.word 0xdcf6c9e0  ! 1884: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	.word 0xdcbfe000  ! 1885: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	mov	0x28, %r16
	.word 0xdcb76000  ! 1887: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1888: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08649e0  ! 1889: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r8
	mov	0x3c8, %r22
	mov	0x8, %r19
	.word 0x87802073  ! 1892: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a649e0  ! 1893: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	.word 0xdab44400  ! 1894: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	mov	0x48, %r19
	.word 0xdac7a000  ! 1896: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1897: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4de89e0  ! 1898: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r10
	.word 0xd484e000  ! 1899: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r10
	.word 0x87802025  ! 1900: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 1901: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f0, %r20
	.word 0xd4be6000  ! 1903: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	mov	0x30, %r26
	.word 0xdc8f8e40  ! 1905: LDUBA_R	lduba	[%r30, %r0] 0x72, %r14
	.word 0xdca62000  ! 1906: STWA_I	stwa	%r14, [%r24 + 0x0000] %asi
	.word 0xdc866000  ! 1907: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r14
	.word 0x87802074  ! 1908: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6940400  ! 1909: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	.word 0x8780204f  ! 1910: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf70e40  ! 1911: STXA_R	stxa	%r13, [%r28 + %r0] 0x72
	mov	0x7d8, %r20
	.word 0xdad40400  ! 1913: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	mov	0x20, %r16
	.word 0xdab66000  ! 1915: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0xdab6e000  ! 1916: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	.word 0x87802073  ! 1917: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0f504a0  ! 1918: STXA_R	stxa	%r8, [%r20 + %r0] 0x25
	mov	0x7e0, %r22
	.word 0xd0d7a000  ! 1920: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	mov	0x30, %r17
	.word 0x87802073  ! 1922: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf544a0  ! 1923: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	.word 0x8780204f  ! 1924: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda8e6000  ! 1925: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r13
	.word 0xd48f8e40  ! 1926: LDUBA_R	lduba	[%r30, %r0] 0x72, %r10
	.word 0xd49e6000  ! 1927: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r10
	.word 0xdc9f8e40  ! 1928: LDDA_R	ldda	[%r30, %r0] 0x72, %r14
	.word 0xdcdea000  ! 1929: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r14
	mov	0x8, %r17
	.word 0x87802020  ! 1931: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b48400  ! 1932: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xd69e89e0  ! 1933: LDDA_R	ldda	[%r26, %r0] 0x4f, %r11
	mov	0x70, %r19
	.word 0xde8f4e60  ! 1935: LDUBA_R	lduba	[%r29, %r0] 0x73, %r15
	.word 0xded4a000  ! 1936: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	.word 0xdc9fce40  ! 1937: LDDA_R	ldda	[%r31, %r0] 0x72, %r14
	.word 0x87802073  ! 1938: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 1939: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1940: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccce000  ! 1941: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r14
	.word 0xdcf46000  ! 1942: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdcbce000  ! 1943: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xd4af4e40  ! 1944: STBA_R	stba	%r10, [%r29 + %r0] 0x72
	mov	0x38, %r24
	.word 0xdec7ce40  ! 1946: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r15
	.word 0xdcbc0400  ! 1947: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0x87802074  ! 1948: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd09e09e0  ! 1949: LDDA_R	ldda	[%r24, %r0] 0x4f, %r8
	.word 0xd08fe000  ! 1950: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	.word 0xd0f7a000  ! 1951: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0a7e000  ! 1952: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xd89dc4a0  ! 1953: LDDA_R	ldda	[%r23, %r0] 0x25, %r12
	.word 0xd8c7a000  ! 1954: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	mov	0x28, %r18
	.word 0xd8b76000  ! 1956: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xdcb40400  ! 1957: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	mov	0x48, %r16
	.word 0xdca76000  ! 1959: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdc872000  ! 1960: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	mov	0x50, %r24
	mov	0x40, %r18
	.word 0xdcaf2000  ! 1963: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdcc74e40  ! 1964: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r14
	.word 0xd2f74e80  ! 1965: STXA_R	stxa	%r9, [%r29 + %r0] 0x74
	.word 0xd2df6000  ! 1966: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2c609e0  ! 1967: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r9
	.word 0xdaa649e0  ! 1968: STWA_R	stwa	%r13, [%r25 + %r0] 0x4f
	.word 0xda9f6000  ! 1969: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xdaa72000  ! 1970: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xd696c9e0  ! 1971: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r11
	.word 0x87802020  ! 1972: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r17
	.word 0xd694c400  ! 1974: LDUHA_R	lduha	[%r19, %r0] 0x20, %r11
	.word 0xd8bc8400  ! 1975: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xd0874e60  ! 1976: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r8
	mov	0x38, %r25
	.word 0xd6b649e0  ! 1978: STHA_R	stha	%r11, [%r25 + %r0] 0x4f
	.word 0xdcd584a0  ! 1979: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r14
	.word 0xdcd4e000  ! 1980: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	.word 0xd2af0e60  ! 1981: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	mov	0x8, %r26
	.word 0xd2c4e000  ! 1983: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	mov	0x28, %r17
	.word 0xd8b649e0  ! 1985: STHA_R	stha	%r12, [%r25 + %r0] 0x4f
	mov	0x10, %r18
	.word 0xd8bc2000  ! 1987: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xdcaf0e80  ! 1988: STBA_R	stba	%r14, [%r28 + %r0] 0x74
	.word 0x87802020  ! 1989: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc84a000  ! 1990: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	mov	0x3f0, %r20
	.word 0xdccc6000  ! 1992: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	.word 0xda944400  ! 1993: LDUHA_R	lduha	[%r17, %r0] 0x20, %r13
	.word 0xdad4a000  ! 1994: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1995: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r20
	.word 0xd49c0400  ! 1997: LDDA_R	ldda	[%r16, %r0] 0x20, %r10
	.word 0xd4bce000  ! 1998: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0xd8d7ce80  ! 1999: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r12
	.word 0x87802073  ! 2000: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d0, %r21
	.word 0xd88fa000  ! 2002: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0xd8a76000  ! 2003: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8cf2000  ! 2004: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0xd8afa000  ! 2005: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xd0bd84a0  ! 2006: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0xdabf8e40  ! 2007: STDA_R	stda	%r13, [%r30 + %r0] 0x72
	.word 0xda872000  ! 2008: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2009: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ad04a0  ! 2010: STBA_R	stba	%r11, [%r20 + %r0] 0x25
	mov	0x18, %r18
	.word 0xd6bcc400  ! 2012: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0x87802025  ! 2013: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde8c8400  ! 2014: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	mov	0x7e8, %r21
	.word 0xde9d6000  ! 2016: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r15
	.word 0xdcaf4e80  ! 2017: STBA_R	stba	%r14, [%r29 + %r0] 0x74
	.word 0xdcd5e000  ! 2018: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r14
	.word 0xd4c78e80  ! 2019: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r10
	.word 0x87802020  ! 2020: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2af8e80  ! 2021: STBA_R	stba	%r9, [%r30 + %r0] 0x74
	.word 0xded70e80  ! 2022: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r15
	mov	0x7c0, %r20
	.word 0xdca40400  ! 2024: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xdca4e000  ! 2025: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 2026: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca42000  ! 2027: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xd8b40400  ! 2028: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xd8f42000  ! 2029: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xd2a40400  ! 2030: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0x87802072  ! 2031: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r19
	.word 0x87802020  ! 2033: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b78e80  ! 2034: STHA_R	stha	%r9, [%r30 + %r0] 0x74
	.word 0xd29c6000  ! 2035: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	.word 0xdac544a0  ! 2036: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r13
	.word 0xda8c2000  ! 2037: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r13
	.word 0xdaf4e000  ! 2038: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xda970e60  ! 2039: LDUHA_R	lduha	[%r28, %r0] 0x73, %r13
	.word 0xdac42000  ! 2040: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2041: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2042: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabde000  ! 2043: STDA_I	stda	%r13, [%r23 + 0x0000] %asi
	.word 0xda856000  ! 2044: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r13
	.word 0xda956000  ! 2045: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 2046: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa6e000  ! 2047: STWA_I	stwa	%r13, [%r27 + 0x0000] %asi
	.word 0xd8bf0e80  ! 2048: STDA_R	stda	%r12, [%r28 + %r0] 0x74
	.word 0xd89ee000  ! 2049: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r12
	.word 0xd8ce6000  ! 2050: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r12
	.word 0xd8f6a000  ! 2051: STXA_I	stxa	%r12, [%r26 + 0x0000] %asi
	.word 0xd8b62000  ! 2052: STHA_I	stha	%r12, [%r24 + 0x0000] %asi
	mov	0x7c0, %r21
	.word 0x87802072  ! 2054: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r27
	mov	0x7f0, %r23
	.word 0xdcc609e0  ! 2057: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r14
	mov	0x8, %r27
	.word 0xda948400  ! 2059: LDUHA_R	lduha	[%r18, %r0] 0x20, %r13
	mov	0x10, %r24
	mov	0x28, %r24
	mov	0x78, %r16
	.word 0xdab7a000  ! 2063: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	mov	0x3e8, %r20
	mov	0x3d0, %r23
	.word 0x87802073  ! 2066: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d0, %r23
	.word 0xd09e09e0  ! 2068: LDDA_R	ldda	[%r24, %r0] 0x4f, %r8
	.word 0xd0b4c400  ! 2069: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0x87802073  ! 2070: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b72000  ! 2071: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	mov	0x28, %r24
	.word 0xd0afe000  ! 2073: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0cfa000  ! 2074: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	mov	0x38, %r27
	.word 0xd68d44a0  ! 2076: LDUBA_R	lduba	[%r21, %r0] 0x25, %r11
	.word 0xd6b72000  ! 2077: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd6af6000  ! 2078: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd6a7a000  ! 2079: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	mov	0x20, %r17
	.word 0xd6c7a000  ! 2081: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	.word 0x87802025  ! 2082: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b56000  ! 2083: STHA_I	stha	%r11, [%r21 + 0x0000] %asi
	.word 0xdeaf8e40  ! 2084: STBA_R	stba	%r15, [%r30 + %r0] 0x72
	.word 0xdea56000  ! 2085: STWA_I	stwa	%r15, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 2086: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r19
	.word 0xded66000  ! 2088: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r15
	.word 0xdaa70e40  ! 2089: STWA_R	stwa	%r13, [%r28 + %r0] 0x72
	.word 0xd0a48400  ! 2090: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	mov	0x40, %r18
	.word 0xd0f62000  ! 2092: STXA_I	stxa	%r8, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 2093: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b42000  ! 2094: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xdcdec9e0  ! 2095: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r14
	.word 0x87802072  ! 2096: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r17
	.word 0xdca7a000  ! 2098: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcf7a000  ! 2099: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xdc9fe000  ! 2100: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xda948400  ! 2101: LDUHA_R	lduha	[%r18, %r0] 0x20, %r13
	.word 0xd4cf4e60  ! 2102: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r10
	.word 0xdeb689e0  ! 2103: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	mov	0x10, %r17
	mov	0x30, %r17
	.word 0x87802020  ! 2106: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f609e0  ! 2107: STXA_R	stxa	%r9, [%r24 + %r0] 0x4f
	.word 0x87802072  ! 2108: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29f2000  ! 2109: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2110: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r21
	.word 0x87802074  ! 2112: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd297a000  ! 2113: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	.word 0xd0978e80  ! 2114: LDUHA_R	lduha	[%r30, %r0] 0x74, %r8
	.word 0xd2c70e60  ! 2115: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r9
	.word 0xd2d7a000  ! 2116: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 2117: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bea000  ! 2118: STDA_I	stda	%r9, [%r26 + 0x0000] %asi
	.word 0xd286a000  ! 2119: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r9
	.word 0xd8a7ce80  ! 2120: STWA_R	stwa	%r12, [%r31 + %r0] 0x74
	.word 0xd8ae6000  ! 2121: STBA_I	stba	%r12, [%r25 + 0x0000] %asi
	.word 0xd4b40400  ! 2122: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0xd4d6a000  ! 2123: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r10
	mov	0x7c0, %r20
	.word 0xd8a48400  ! 2125: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	.word 0xd8f6e000  ! 2126: STXA_I	stxa	%r12, [%r27 + 0x0000] %asi
	.word 0xd4a6c9e0  ! 2127: STWA_R	stwa	%r10, [%r27 + %r0] 0x4f
	.word 0x87802072  ! 2128: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4c7a000  ! 2129: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	mov	0x7c8, %r22
	.word 0xd4cf6000  ! 2131: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	mov	0x3c0, %r23
	mov	0x7e8, %r21
	.word 0x87802025  ! 2134: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r16
	.word 0xdcac4400  ! 2136: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	.word 0xdc9d2000  ! 2137: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r14
	.word 0xd6878e60  ! 2138: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r11
	.word 0xd6d56000  ! 2139: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r11
	mov	0x20, %r18
	mov	0x10, %r26
	mov	0x8, %r17
	.word 0xd6a544a0  ! 2143: STWA_R	stwa	%r11, [%r21 + %r0] 0x25
	mov	0x8, %r17
	mov	0x20, %r24
	.word 0xd2b7ce80  ! 2146: STHA_R	stha	%r9, [%r31 + %r0] 0x74
	.word 0xdcc40400  ! 2147: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	mov	0x48, %r27
	.word 0xd0970e80  ! 2149: LDUHA_R	lduha	[%r28, %r0] 0x74, %r8
	.word 0xd0f52000  ! 2150: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	.word 0xdab7ce40  ! 2151: STHA_R	stha	%r13, [%r31 + %r0] 0x72
	mov	0x7f0, %r22
	mov	0x3e8, %r22
	.word 0x8780204f  ! 2154: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r19
	.word 0xdaf6e000  ! 2156: STXA_I	stxa	%r13, [%r27 + 0x0000] %asi
	.word 0xd2948400  ! 2157: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	.word 0xdeac4400  ! 2158: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0xdeaee000  ! 2159: STBA_I	stba	%r15, [%r27 + 0x0000] %asi
	mov	0x8, %r24
	.word 0xde8ea000  ! 2161: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r15
	mov	0x3f0, %r22
	.word 0xdeb6e000  ! 2163: STHA_I	stha	%r15, [%r27 + 0x0000] %asi
	.word 0xd086c9e0  ! 2164: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r8
	.word 0xdc97ce80  ! 2165: LDUHA_R	lduha	[%r31, %r0] 0x74, %r14
	mov	0x18, %r26
	.word 0xdcdee000  ! 2167: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r14
	.word 0xdcbea000  ! 2168: STDA_I	stda	%r14, [%r26 + 0x0000] %asi
	.word 0xdcaee000  ! 2169: STBA_I	stba	%r14, [%r27 + 0x0000] %asi
	mov	0x3c8, %r21
	mov	0x38, %r18
	.word 0xdcb62000  ! 2172: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	mov	0x60, %r26
	.word 0xdcb66000  ! 2174: STHA_I	stha	%r14, [%r25 + 0x0000] %asi
	.word 0xd28f8e40  ! 2175: LDUBA_R	lduba	[%r30, %r0] 0x72, %r9
	.word 0xd294c400  ! 2176: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	.word 0xd2962000  ! 2177: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r9
	.word 0xdea7ce60  ! 2178: STWA_R	stwa	%r15, [%r31 + %r0] 0x73
	mov	0x8, %r25
	.word 0xd89f0e80  ! 2180: LDDA_R	ldda	[%r28, %r0] 0x74, %r12
	.word 0x87802074  ! 2181: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a689e0  ! 2182: STWA_R	stwa	%r10, [%r26 + %r0] 0x4f
	mov	0x8, %r16
	.word 0xd4c7a000  ! 2184: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 2185: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0bf8e40  ! 2186: STDA_R	stda	%r8, [%r30 + %r0] 0x72
	.word 0xdca7ce80  ! 2187: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	.word 0xdca6e000  ! 2188: STWA_I	stwa	%r14, [%r27 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xdcae2000  ! 2190: STBA_I	stba	%r14, [%r24 + 0x0000] %asi
	.word 0xdca6e000  ! 2191: STWA_I	stwa	%r14, [%r27 + 0x0000] %asi
	.word 0xdcbe6000  ! 2192: STDA_I	stda	%r14, [%r25 + 0x0000] %asi
	.word 0xdc9ee000  ! 2193: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r14
	mov	0x3c0, %r20
	mov	0x58, %r16
	mov	0x48, %r26
	.word 0xd09f8e80  ! 2197: LDDA_R	ldda	[%r30, %r0] 0x74, %r8
	mov	0x3c0, %r20
	mov	0x40, %r26
	mov	0x3c0, %r20
	.word 0xd6bc4400  ! 2201: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	.word 0xd68f8e40  ! 2202: LDUBA_R	lduba	[%r30, %r0] 0x72, %r11
	.word 0x87802074  ! 2203: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdecd44a0  ! 2204: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r15
	.word 0xde87e000  ! 2205: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xd2c7ce60  ! 2206: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r9
	.word 0x87802074  ! 2207: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8a78e60  ! 2208: STWA_R	stwa	%r12, [%r30 + %r0] 0x73
	.word 0xd897e000  ! 2209: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	.word 0x87802072  ! 2210: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c0, %r20
	.word 0xdc8f4e80  ! 2212: LDUBA_R	lduba	[%r29, %r0] 0x74, %r14
	.word 0xdeb74e60  ! 2213: STHA_R	stha	%r15, [%r29 + %r0] 0x73
	.word 0xd686c9e0  ! 2214: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r11
	.word 0xdadcc400  ! 2215: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	mov	0x70, %r27
	.word 0xdadf6000  ! 2217: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xd4b5c4a0  ! 2218: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	.word 0xd4f72000  ! 2219: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 2220: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cfa000  ! 2221: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0xd0f78e80  ! 2222: STXA_R	stxa	%r8, [%r30 + %r0] 0x74
	mov	0x58, %r19
	.word 0x87802073  ! 2224: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0c48400  ! 2225: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r8
	mov	0x3f0, %r23
	.word 0xd4b70e60  ! 2227: STHA_R	stha	%r10, [%r28 + %r0] 0x73
	.word 0xd4cf2000  ! 2228: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4bf2000  ! 2229: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd4bf2000  ! 2230: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	mov	0x28, %r24
	.word 0xd6970e60  ! 2232: LDUHA_R	lduha	[%r28, %r0] 0x73, %r11
	mov	0x30, %r19
	.word 0xd48f8e80  ! 2234: LDUBA_R	lduba	[%r30, %r0] 0x74, %r10
	.word 0xd6b4c400  ! 2235: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xd6bf2000  ! 2236: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xdabf0e40  ! 2237: STDA_R	stda	%r13, [%r28 + %r0] 0x72
	.word 0xdaaf2000  ! 2238: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdacfe000  ! 2239: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0xd4dcc400  ! 2240: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0x8780204f  ! 2241: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd4d66000  ! 2243: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r10
	mov	0x60, %r19
	.word 0xdcd4c400  ! 2245: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	.word 0x87802073  ! 2246: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b48400  ! 2247: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xdacf4e40  ! 2248: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r13
	.word 0x8780204f  ! 2249: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2878e80  ! 2250: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r9
	.word 0xd8cd84a0  ! 2251: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r12
	.word 0xd8de6000  ! 2252: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r12
	.word 0xd886a000  ! 2253: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r12
	.word 0xd8cf4e40  ! 2254: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r12
	.word 0xd8ce6000  ! 2255: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r12
	.word 0xd8a66000  ! 2256: STWA_I	stwa	%r12, [%r25 + 0x0000] %asi
	.word 0xd0b70e80  ! 2257: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	mov	0x68, %r25
	mov	0x3f0, %r21
	mov	0x48, %r16
	.word 0xd0cea000  ! 2261: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r8
	.word 0xd2f70e60  ! 2262: STXA_R	stxa	%r9, [%r28 + %r0] 0x73
	.word 0xdea649e0  ! 2263: STWA_R	stwa	%r15, [%r25 + %r0] 0x4f
	.word 0xdec609e0  ! 2264: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r15
	.word 0xdeae6000  ! 2265: STBA_I	stba	%r15, [%r25 + 0x0000] %asi
	.word 0xdaacc400  ! 2266: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0xdaa66000  ! 2267: STWA_I	stwa	%r13, [%r25 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xdad66000  ! 2269: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r13
	.word 0xdabe2000  ! 2270: STDA_I	stda	%r13, [%r24 + 0x0000] %asi
	.word 0xdac62000  ! 2271: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r13
	.word 0xdaac8400  ! 2272: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0x87802073  ! 2273: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdab7e000  ! 2274: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xdcac0400  ! 2275: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0x87802020  ! 2276: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b689e0  ! 2277: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	.word 0xd0ad04a0  ! 2278: STBA_R	stba	%r8, [%r20 + %r0] 0x25
	.word 0xd0dca000  ! 2279: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	.word 0xd6af4e40  ! 2280: STBA_R	stba	%r11, [%r29 + %r0] 0x72
	mov	0x7c8, %r22
	.word 0xd2d70e80  ! 2282: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r9
	mov	0x38, %r26
	mov	0x10, %r18
	.word 0xd6b4c400  ! 2285: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xd89584a0  ! 2286: LDUHA_R	lduha	[%r22, %r0] 0x25, %r12
	.word 0xd8ac2000  ! 2287: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	mov	0x3c0, %r20
	mov	0x58, %r24
	.word 0xd8f4a000  ! 2290: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xdebd04a0  ! 2291: STDA_R	stda	%r15, [%r20 + %r0] 0x25
	.word 0xd0b70e40  ! 2292: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	mov	0x7d0, %r22
	.word 0xd0a46000  ! 2294: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 2295: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0972000  ! 2296: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xdccfce40  ! 2297: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r14
	.word 0xdccf8e40  ! 2298: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r14
	.word 0xdca7e000  ! 2299: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0xdaafce40  ! 2301: STBA_R	stba	%r13, [%r31 + %r0] 0x72
	.word 0xdaafe000  ! 2302: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xd0bdc4a0  ! 2303: STDA_R	stda	%r8, [%r23 + %r0] 0x25
	.word 0xdaa78e80  ! 2304: STWA_R	stwa	%r13, [%r30 + %r0] 0x74
	.word 0x87802072  ! 2305: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 2306: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4a48400  ! 2307: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xd097ce40  ! 2308: LDUHA_R	lduha	[%r31, %r0] 0x72, %r8
	mov	0x3e0, %r22
	.word 0xd0f5e000  ! 2310: STXA_I	stxa	%r8, [%r23 + 0x0000] %asi
	mov	0x40, %r26
	.word 0x87802073  ! 2312: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a7e000  ! 2313: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0972000  ! 2314: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	mov	0x7e0, %r22
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0f76000  ! 2317: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 2318: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaaf4e80  ! 2319: STBA_R	stba	%r13, [%r29 + %r0] 0x74
	.word 0x87802020  ! 2320: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad46000  ! 2321: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	.word 0xdacca000  ! 2322: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	mov	0x48, %r25
	mov	0x40, %r19
	.word 0xda942000  ! 2325: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0xdca44400  ! 2326: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0xdc84a000  ! 2327: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdaf609e0  ! 2329: STXA_R	stxa	%r13, [%r24 + %r0] 0x4f
	mov	0x60, %r27
	.word 0xdeb7ce60  ! 2331: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	.word 0xde9ca000  ! 2332: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	mov	0x7d0, %r20
	.word 0xdec42000  ! 2334: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0x87802020  ! 2335: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2336: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 2337: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd68f4e80  ! 2338: LDUBA_R	lduba	[%r29, %r0] 0x74, %r11
	.word 0xd6bf6000  ! 2339: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 2340: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r24
	.word 0xd6b76000  ! 2342: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd0b6c9e0  ! 2343: STHA_R	stha	%r8, [%r27 + %r0] 0x4f
	mov	0x3c8, %r21
	mov	0x3c0, %r21
	.word 0xd08fa000  ! 2346: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0xdcdfce40  ! 2347: LDXA_R	ldxa	[%r31, %r0] 0x72, %r14
	mov	0x50, %r19
	.word 0xdcb544a0  ! 2349: STHA_R	stha	%r14, [%r21 + %r0] 0x25
	.word 0xdcdfe000  ! 2350: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	mov	0x7f0, %r20
	.word 0xd8878e40  ! 2352: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r12
	.word 0xd88fa000  ! 2353: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0x87802073  ! 2354: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8bf6000  ! 2355: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xd8bfe000  ! 2357: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	mov	0x58, %r24
	.word 0xd88f2000  ! 2359: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0x87802025  ! 2360: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2c504a0  ! 2361: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r9
	.word 0xdc9fce80  ! 2362: LDDA_R	ldda	[%r31, %r0] 0x74, %r14
	mov	0x48, %r17
	.word 0x8780204f  ! 2364: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r16
	.word 0xd4bd44a0  ! 2366: STDA_R	stda	%r10, [%r21 + %r0] 0x25
	mov	0x7f0, %r22
	.word 0xd2d48400  ! 2368: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	mov	0x3f8, %r23
	mov	0x7e8, %r22
	.word 0xd2866000  ! 2371: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r9
	.word 0xd2dea000  ! 2372: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2f62000  ! 2374: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	.word 0xd2cee000  ! 2375: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	.word 0x87802073  ! 2376: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2976000  ! 2377: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	mov	0x8, %r16
	.word 0xd2bfa000  ! 2379: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd2dfa000  ! 2380: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	mov	0x30, %r16
	.word 0xd08cc400  ! 2382: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	.word 0xd8bf4e40  ! 2383: STDA_R	stda	%r12, [%r29 + %r0] 0x72
	.word 0xd8d76000  ! 2384: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	mov	0x68, %r27
	.word 0xd0a78e40  ! 2386: STWA_R	stwa	%r8, [%r30 + %r0] 0x72
	mov	0x50, %r19
	.word 0xd0b7a000  ! 2388: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	mov	0x30, %r16
	.word 0x87802020  ! 2390: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r16
	mov	0x3c8, %r23
	mov	0x10, %r25
	.word 0xd0f4a000  ! 2394: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 2395: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d0, %r22
	.word 0x87802020  ! 2397: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2398: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0afce40  ! 2399: STBA_R	stba	%r8, [%r31 + %r0] 0x72
	mov	0x7f8, %r21
	mov	0x48, %r26
	mov	0x7d8, %r21
	.word 0xd8d4c400  ! 2403: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0x87802074  ! 2404: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e0, %r23
	.word 0xd0df0e40  ! 2406: LDXA_R	ldxa	[%r28, %r0] 0x72, %r8
	.word 0x87802025  ! 2407: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2408: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0c7e000  ! 2409: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0a48400  ! 2410: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0xda8fce60  ! 2411: LDUBA_R	lduba	[%r31, %r0] 0x73, %r13
	.word 0x87802074  ! 2412: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd09e49e0  ! 2413: LDDA_R	ldda	[%r25, %r0] 0x4f, %r8
	.word 0xd0c76000  ! 2414: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	mov	0x30, %r19
	mov	0x40, %r26
	.word 0xd0c7e000  ! 2417: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0xd2d649e0  ! 2418: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r9
	.word 0x87802020  ! 2419: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb78e40  ! 2420: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xdcd42000  ! 2421: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	.word 0x87802072  ! 2422: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf7e000  ! 2423: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdc87a000  ! 2424: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcb72000  ! 2425: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0xdc872000  ! 2427: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	mov	0x60, %r17
	.word 0xdcc7e000  ! 2429: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0x87802073  ! 2430: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdccfe000  ! 2431: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xd4848400  ! 2432: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r10
	.word 0xded5c4a0  ! 2433: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r15
	.word 0xd2f70e60  ! 2434: STXA_R	stxa	%r9, [%r28 + %r0] 0x73
	.word 0x87802074  ! 2435: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xded584a0  ! 2436: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r15
	.word 0xdef72000  ! 2437: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xde87a000  ! 2438: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xd6f74e60  ! 2439: STXA_R	stxa	%r11, [%r29 + %r0] 0x73
	mov	0x7c0, %r22
	mov	0x0, %r25
	.word 0xd6b7e000  ! 2442: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd6f76000  ! 2443: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 2444: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r26
	mov	0x78, %r27
	.word 0xdeb7ce40  ! 2447: STHA_R	stha	%r15, [%r31 + %r0] 0x72
	.word 0xde97e000  ! 2448: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	mov	0x7e8, %r20
	mov	0x7c0, %r23
	.word 0xdeddc4a0  ! 2451: LDXA_R	ldxa	[%r23, %r0] 0x25, %r15
	.word 0x87802020  ! 2452: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeafce60  ! 2453: STBA_R	stba	%r15, [%r31 + %r0] 0x73
	.word 0x87802073  ! 2454: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f4c400  ! 2455: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xd8afe000  ! 2456: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd295c4a0  ! 2457: LDUHA_R	lduha	[%r23, %r0] 0x25, %r9
	mov	0x8, %r24
	.word 0xd88f0e60  ! 2459: LDUBA_R	lduba	[%r28, %r0] 0x73, %r12
	.word 0xd89f2000  ! 2460: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0xd4970e60  ! 2461: LDUHA_R	lduha	[%r28, %r0] 0x73, %r10
	.word 0xd4f72000  ! 2462: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	mov	0x3e0, %r21
	mov	0x70, %r19
	mov	0x3c0, %r22
	.word 0xd89f0e40  ! 2466: LDDA_R	ldda	[%r28, %r0] 0x72, %r12
	.word 0xd28f8e60  ! 2467: LDUBA_R	lduba	[%r30, %r0] 0x73, %r9
	.word 0xd2dfa000  ! 2468: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xd297a000  ! 2469: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2470: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ace000  ! 2471: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0xdabfce40  ! 2472: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	mov	0x28, %r18
	.word 0xdabce000  ! 2474: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0xdc9cc400  ! 2475: LDDA_R	ldda	[%r19, %r0] 0x20, %r14
	.word 0xd0dc0400  ! 2476: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xd0f4a000  ! 2477: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	mov	0x3f0, %r21
	.word 0xd08c6000  ! 2479: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0xd0a4e000  ! 2480: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0aca000  ! 2481: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xd09c6000  ! 2482: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r8
	.word 0xd0a42000  ! 2483: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	mov	0x48, %r27
	.word 0xd8878e40  ! 2485: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r12
	.word 0x87802020  ! 2486: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0878e80  ! 2487: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r8
	.word 0x87802020  ! 2488: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r25
	.word 0xdad544a0  ! 2490: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r13
	.word 0xdabca000  ! 2491: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdc8504a0  ! 2492: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r14
	.word 0xd4f70e60  ! 2493: STXA_R	stxa	%r10, [%r28 + %r0] 0x73
	mov	0x78, %r16
	.word 0xd6c689e0  ! 2495: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r11
	.word 0xd694e000  ! 2496: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r11
	.word 0x87802074  ! 2497: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f7ce40  ! 2498: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	.word 0xdebc4400  ! 2499: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	mov	0x60, %r24
	.word 0x87802074  ! 2501: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2502: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2503: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f70e60  ! 2504: STXA_R	stxa	%r10, [%r28 + %r0] 0x73
	.word 0xdad504a0  ! 2505: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r13
	mov	0x18, %r27
	mov	0x7f8, %r20
	.word 0xdad4a000  ! 2508: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	mov	0x3e8, %r23
	.word 0xdc8544a0  ! 2510: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r14
	.word 0xd2bc0400  ! 2511: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0x87802020  ! 2512: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bca000  ! 2513: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	.word 0xd2ac8400  ! 2514: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xd2b70e80  ! 2515: STHA_R	stha	%r9, [%r28 + %r0] 0x74
	.word 0xdedf8e80  ! 2516: LDXA_R	ldxa	[%r30, %r0] 0x74, %r15
	.word 0xdec4a000  ! 2517: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0x87802074  ! 2518: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2519: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2520: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xdea4e000  ! 2522: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xdeace000  ! 2523: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xdeb4e000  ! 2524: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0xd6f48400  ! 2525: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0x87802072  ! 2526: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6dfa000  ! 2527: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6a7a000  ! 2528: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 2529: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bc4400  ! 2530: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xdcb40400  ! 2531: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xdcac6000  ! 2532: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xd2be89e0  ! 2533: STDA_R	stda	%r9, [%r26 + %r0] 0x4f
	.word 0xd2cc6000  ! 2534: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	mov	0x7e8, %r21
	mov	0x28, %r16
	.word 0xdab44400  ! 2537: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 2538: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda8ee000  ! 2539: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r13
	.word 0xd4c5c4a0  ! 2540: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r10
	mov	0x3d0, %r23
	.word 0xd4dea000  ! 2542: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	.word 0xded78e80  ! 2543: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r15
	.word 0xd497ce40  ! 2544: LDUHA_R	lduha	[%r31, %r0] 0x72, %r10
	.word 0xd4cea000  ! 2545: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r10
	.word 0xd4d6e000  ! 2546: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r10
	.word 0xd88544a0  ! 2547: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r12
	.word 0x87802025  ! 2548: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8cc4400  ! 2549: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r12
	.word 0xda9c8400  ! 2550: LDDA_R	ldda	[%r18, %r0] 0x20, %r13
	ta	T_CHANGE_PRIV	! macro
	mov	0x7c0, %r23
	mov	0x38, %r16
	.word 0xda952000  ! 2554: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r13
	.word 0xda952000  ! 2555: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r13
	.word 0xd6af4e80  ! 2556: STBA_R	stba	%r11, [%r29 + %r0] 0x74
	mov	0x3f0, %r21
	.word 0xd6cd6000  ! 2558: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r11
	.word 0xd6f5e000  ! 2559: STXA_I	stxa	%r11, [%r23 + 0x0000] %asi
	.word 0xd4bf8e80  ! 2560: STDA_R	stda	%r10, [%r30 + %r0] 0x74
	.word 0x87802072  ! 2561: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29dc4a0  ! 2562: LDDA_R	ldda	[%r23, %r0] 0x25, %r9
	.word 0xd08e09e0  ! 2563: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r8
	.word 0x87802020  ! 2564: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bce000  ! 2565: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 2566: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0cf2000  ! 2567: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0xd0f72000  ! 2568: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xd0876000  ! 2569: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	.word 0xd4adc4a0  ! 2570: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0x8780204f  ! 2571: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8cdc4a0  ! 2572: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r12
	.word 0xd6cf0e60  ! 2573: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r11
	.word 0xd0cf8e40  ! 2574: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r8
	mov	0x10, %r25
	.word 0xd0d66000  ! 2576: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r8
	.word 0xdeb689e0  ! 2577: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	.word 0xd0be09e0  ! 2578: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0xd0ce2000  ! 2579: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r8
	mov	0x78, %r18
	.word 0xd2f70e80  ! 2581: STXA_R	stxa	%r9, [%r28 + %r0] 0x74
	mov	0x7c8, %r22
	.word 0xd2dee000  ! 2583: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r9
	.word 0xd88689e0  ! 2584: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r12
	.word 0xd8c6a000  ! 2585: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r12
	.word 0xd4a70e60  ! 2586: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	mov	0x40, %r18
	.word 0xd4862000  ! 2588: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r10
	mov	0x60, %r25
	.word 0xd4ae6000  ! 2590: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0xd4f6a000  ! 2591: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	.word 0xd49e6000  ! 2592: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r10
	mov	0x40, %r17
	mov	0x48, %r17
	mov	0x7e8, %r20
	.word 0xded504a0  ! 2596: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r15
	.word 0x87802073  ! 2597: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 2598: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef74e80  ! 2599: STXA_R	stxa	%r15, [%r29 + %r0] 0x74
	.word 0xd2b74e40  ! 2600: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	.word 0xd29f2000  ! 2601: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd2bfa000  ! 2602: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 2603: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a4a000  ! 2604: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 2605: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 2606: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 2607: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b689e0  ! 2608: STHA_R	stha	%r12, [%r26 + %r0] 0x4f
	.word 0xd8866000  ! 2609: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r12
	.word 0xd88ea000  ! 2610: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r12
	.word 0xd89e6000  ! 2611: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r12
	.word 0xd896e000  ! 2612: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r12
	.word 0xd8b78e80  ! 2613: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	.word 0xd8bee000  ! 2614: STDA_I	stda	%r12, [%r27 + 0x0000] %asi
	.word 0xd8ce6000  ! 2615: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r12
	mov	0x58, %r18
	mov	0x28, %r26
	.word 0x8780204f  ! 2618: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r17
	.word 0xd4ccc400  ! 2620: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0xd4a6e000  ! 2621: STWA_I	stwa	%r10, [%r27 + 0x0000] %asi
	.word 0xd8c544a0  ! 2622: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r12
	mov	0x78, %r17
	.word 0xd4d4c400  ! 2624: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0x8780204f  ! 2625: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a78e60  ! 2626: STWA_R	stwa	%r12, [%r30 + %r0] 0x73
	mov	0x18, %r19
	mov	0x10, %r16
	.word 0xd8966000  ! 2629: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r12
	.word 0xd8d62000  ! 2630: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r12
	mov	0x7d0, %r20
	.word 0xd8b6e000  ! 2632: STHA_I	stha	%r12, [%r27 + 0x0000] %asi
	.word 0xd0c7ce60  ! 2633: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r8
	mov	0x20, %r18
	mov	0x7c8, %r20
	.word 0xd2840400  ! 2636: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r9
	.word 0x87802073  ! 2637: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r18
	mov	0x18, %r17
	mov	0x70, %r25
	mov	0x50, %r27
	.word 0x87802025  ! 2642: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r17
	.word 0xd0d44400  ! 2644: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r8
	mov	0x10, %r18
	mov	0x78, %r24
	mov	0x3f0, %r23
	.word 0xd6c78e40  ! 2648: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	.word 0xdadec9e0  ! 2649: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r13
	.word 0xd0870e80  ! 2650: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r8
	mov	0x38, %r27
	.word 0xd6f78e80  ! 2652: STXA_R	stxa	%r11, [%r30 + %r0] 0x74
	.word 0xd6dde000  ! 2653: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r11
	.word 0x87802073  ! 2654: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r16
	.word 0xd6f7e000  ! 2656: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd69fa000  ! 2657: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0xd0a40400  ! 2658: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0xd0c7e000  ! 2659: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0xdadc4400  ! 2660: LDXA_R	ldxa	[%r17, %r0] 0x20, %r13
	.word 0xd2cd04a0  ! 2661: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r9
	.word 0xdccfce80  ! 2662: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r14
	.word 0xd4844400  ! 2663: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0xd48f2000  ! 2664: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	mov	0x20, %r19
	.word 0x87802072  ! 2666: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 2667: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b7e000  ! 2668: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0xdaf78e60  ! 2670: STXA_R	stxa	%r13, [%r30 + %r0] 0x73
	.word 0x87802074  ! 2671: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r26
	.word 0xd8cfce40  ! 2673: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r12
	.word 0xdab504a0  ! 2674: STHA_R	stha	%r13, [%r20 + %r0] 0x25
	.word 0xd087ce60  ! 2675: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r8
	.word 0x87802074  ! 2676: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca70e60  ! 2677: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	.word 0xdc9f2000  ! 2678: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xd2c40400  ! 2679: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r9
	.word 0x87802073  ! 2680: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f7e000  ! 2681: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 2682: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf40400  ! 2683: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xdcf76000  ! 2684: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x8, %r26
	mov	0x3d0, %r20
	mov	0x3d0, %r20
	.word 0x87802073  ! 2688: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc9cc400  ! 2689: LDDA_R	ldda	[%r19, %r0] 0x20, %r14
	.word 0xdc97ce80  ! 2690: LDUHA_R	lduha	[%r31, %r0] 0x74, %r14
	.word 0xdcdfa000  ! 2691: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcaf6000  ! 2693: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdcf76000  ! 2694: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x68, %r25
	.word 0xdcd504a0  ! 2696: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r14
	mov	0x40, %r18
	.word 0xdcf7a000  ! 2698: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xdca76000  ! 2699: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xd2b4c400  ! 2701: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0x87802025  ! 2702: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bde000  ! 2703: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	.word 0xdecfce60  ! 2704: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r15
	.word 0xdeb5a000  ! 2705: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	.word 0xdeac4400  ! 2706: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0x87802074  ! 2707: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef76000  ! 2708: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdaf4c400  ! 2709: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xd4970e60  ! 2710: LDUHA_R	lduha	[%r28, %r0] 0x73, %r10
	.word 0xd4bf2000  ! 2711: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd4d76000  ! 2712: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0xdcdc8400  ! 2713: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	.word 0xdcbfa000  ! 2714: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdcd7e000  ! 2715: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xdc8f6000  ! 2716: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	mov	0x7d8, %r22
	.word 0xdaf40400  ! 2718: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	mov	0x0, %r27
	.word 0xdaa7e000  ! 2720: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	mov	0x18, %r17
	.word 0xd28c8400  ! 2722: LDUBA_R	lduba	[%r18, %r0] 0x20, %r9
	mov	0x20, %r18
	.word 0xd2f7a000  ! 2724: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xd29fa000  ! 2725: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd2bf2000  ! 2726: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd6a649e0  ! 2727: STWA_R	stwa	%r11, [%r25 + %r0] 0x4f
	.word 0x87802072  ! 2728: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 2729: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f66000  ! 2730: STXA_I	stxa	%r11, [%r25 + 0x0000] %asi
	.word 0xd6866000  ! 2731: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r11
	mov	0x7d0, %r21
	.word 0xd6966000  ! 2733: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r11
	.word 0xd6a6a000  ! 2734: STWA_I	stwa	%r11, [%r26 + 0x0000] %asi
	.word 0xd6a62000  ! 2735: STWA_I	stwa	%r11, [%r24 + 0x0000] %asi
	.word 0x8780204f  ! 2736: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 2737: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca544a0  ! 2738: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0xdc872000  ! 2739: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0x87802072  ! 2740: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2741: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4940400  ! 2742: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	mov	0x3e8, %r20
	.word 0xdef40400  ! 2744: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0xdecca000  ! 2745: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	.word 0xd2b7ce80  ! 2746: STHA_R	stha	%r9, [%r31 + %r0] 0x74
	.word 0xd28f8e80  ! 2747: LDUBA_R	lduba	[%r30, %r0] 0x74, %r9
	.word 0x87802072  ! 2748: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r17
	.word 0xdab74e40  ! 2750: STHA_R	stha	%r13, [%r29 + %r0] 0x72
	.word 0xdcdc0400  ! 2751: LDXA_R	ldxa	[%r16, %r0] 0x20, %r14
	.word 0xdcbf6000  ! 2752: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdaa74e60  ! 2753: STWA_R	stwa	%r13, [%r29 + %r0] 0x73
	.word 0xdca48400  ! 2754: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xdc8f2000  ! 2755: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	mov	0x20, %r25
	mov	0x40, %r27
	.word 0xdcf7e000  ! 2758: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x3e8, %r21
	mov	0x3f8, %r22
	.word 0xd2bf0e40  ! 2761: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	.word 0xd4ad84a0  ! 2762: STBA_R	stba	%r10, [%r22 + %r0] 0x25
	.word 0x87802020  ! 2763: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bcc400  ! 2764: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0xd094a000  ! 2765: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	.word 0xdab78e80  ! 2766: STHA_R	stha	%r13, [%r30 + %r0] 0x74
	.word 0xd89689e0  ! 2767: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r12
	.word 0xd88c6000  ! 2768: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	.word 0xd2af4e60  ! 2769: STBA_R	stba	%r9, [%r29 + %r0] 0x73
	.word 0x87802073  ! 2770: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r24
	.word 0xd2b72000  ! 2772: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	mov	0x3d8, %r22
	mov	0x18, %r17
	.word 0xd6a44400  ! 2775: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0xd6876000  ! 2776: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	.word 0xd28f8e40  ! 2777: LDUBA_R	lduba	[%r30, %r0] 0x72, %r9
	.word 0x87802020  ! 2778: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2779: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 2780: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c0, %r23
	.word 0xd4b649e0  ! 2782: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	.word 0xd4c4c400  ! 2783: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r10
	.word 0xd4b72000  ! 2784: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xdeb40400  ! 2785: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	mov	0x10, %r25
	mov	0x28, %r19
	mov	0x70, %r25
	.word 0xd29d84a0  ! 2789: LDDA_R	ldda	[%r22, %r0] 0x25, %r9
	.word 0x87802020  ! 2790: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28c2000  ! 2791: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xd28c2000  ! 2792: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xd2c42000  ! 2793: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	.word 0xd0d544a0  ! 2794: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r8
	.word 0xd0d4a000  ! 2795: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	.word 0xd0f4a000  ! 2796: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xd094e000  ! 2797: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0x87802074  ! 2798: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf44400  ! 2799: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0xd29f8e40  ! 2800: LDDA_R	ldda	[%r30, %r0] 0x72, %r9
	.word 0xd2bfe000  ! 2801: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd2b76000  ! 2802: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2b7a000  ! 2803: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd8b44400  ! 2804: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0xd8df2000  ! 2805: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8f7e000  ! 2806: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xded6c9e0  ! 2807: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r15
	.word 0xd4cc4400  ! 2808: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r10
	.word 0x87802020  ! 2809: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a689e0  ! 2810: STWA_R	stwa	%r11, [%r26 + %r0] 0x4f
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802020  ! 2812: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2813: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bf0e80  ! 2814: STDA_R	stda	%r9, [%r28 + %r0] 0x74
	.word 0xd2aea000  ! 2815: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0xd2f6e000  ! 2816: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	mov	0x38, %r16
	mov	0x0, %r27
	.word 0xdedc8400  ! 2819: LDXA_R	ldxa	[%r18, %r0] 0x20, %r15
	.word 0xd0f689e0  ! 2820: STXA_R	stxa	%r8, [%r26 + %r0] 0x4f
	.word 0xd0bee000  ! 2821: STDA_I	stda	%r8, [%r27 + 0x0000] %asi
	.word 0xd0b6e000  ! 2822: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	.word 0xdcdfce40  ! 2823: LDXA_R	ldxa	[%r31, %r0] 0x72, %r14
	.word 0xd4af8e80  ! 2824: STBA_R	stba	%r10, [%r30 + %r0] 0x74
	.word 0xd88c4400  ! 2825: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	mov	0x8, %r17
	.word 0xdece09e0  ! 2827: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r15
	mov	0x58, %r27
	.word 0xd6ac4400  ! 2829: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	mov	0x7c8, %r20
	.word 0xd6d66000  ! 2831: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r11
	mov	0x30, %r25
	.word 0xd686a000  ! 2833: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2834: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadf8e40  ! 2835: LDXA_R	ldxa	[%r30, %r0] 0x72, %r13
	.word 0xdabc2000  ! 2836: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	mov	0x20, %r18
	.word 0xdab42000  ! 2838: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xda8c6000  ! 2839: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r13
	.word 0xdab46000  ! 2840: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 2841: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb4c400  ! 2842: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	mov	0x40, %r18
	.word 0x87802074  ! 2844: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdccf2000  ! 2845: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xd0a44400  ! 2846: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xd0a76000  ! 2847: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	mov	0x0, %r25
	.word 0x8780204f  ! 2849: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd49f4e80  ! 2850: LDDA_R	ldda	[%r29, %r0] 0x74, %r10
	mov	0x18, %r19
	.word 0x87802020  ! 2852: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4dc2000  ! 2853: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	.word 0xd4f46000  ! 2854: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0xd0a78e60  ! 2855: STWA_R	stwa	%r8, [%r30 + %r0] 0x73
	mov	0x48, %r18
	.word 0x87802072  ! 2857: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2858: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bf0e40  ! 2859: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	mov	0x7d0, %r21
	.word 0xd2c42000  ! 2861: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	mov	0x10, %r25
	.word 0xd2f46000  ! 2863: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd89d04a0  ! 2864: LDDA_R	ldda	[%r20, %r0] 0x25, %r12
	mov	0x3c8, %r23
	.word 0xd6f40400  ! 2866: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	.word 0xd0ac0400  ! 2867: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	.word 0xd0c4e000  ! 2868: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	.word 0xdcbc0400  ! 2869: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802020  ! 2871: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a5c4a0  ! 2872: STWA_R	stwa	%r12, [%r23 + %r0] 0x25
	mov	0x78, %r24
	.word 0xd6f6c9e0  ! 2874: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	.word 0xd69ce000  ! 2875: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r11
	.word 0xd6ace000  ! 2876: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0xd6ace000  ! 2877: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	mov	0x10, %r18
	.word 0xd8b584a0  ! 2879: STHA_R	stha	%r12, [%r22 + %r0] 0x25
	.word 0xd297ce40  ! 2880: LDUHA_R	lduha	[%r31, %r0] 0x72, %r9
	.word 0xdef78e80  ! 2881: STXA_R	stxa	%r15, [%r30 + %r0] 0x74
	.word 0xdeac6000  ! 2882: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xdedc4400  ! 2883: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	mov	0x28, %r19
	.word 0xd4bf4e40  ! 2885: STDA_R	stda	%r10, [%r29 + %r0] 0x72
	.word 0x87802073  ! 2886: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4bfe000  ! 2887: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd4afa000  ! 2888: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd8b6c9e0  ! 2889: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	mov	0x10, %r17
	.word 0xd887e000  ! 2891: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8dfe000  ! 2892: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	mov	0x60, %r26
	.word 0xd8cf6000  ! 2894: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	mov	0x30, %r26
	.word 0xd6af0e80  ! 2896: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	.word 0xd08d44a0  ! 2897: LDUBA_R	lduba	[%r21, %r0] 0x25, %r8
	.word 0xdca544a0  ! 2898: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0xdc8f6000  ! 2899: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcd7e000  ! 2900: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xdca7e000  ! 2901: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xd8acc400  ! 2902: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0x87802020  ! 2903: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd487ce40  ! 2904: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r10
	.word 0xd4cce000  ! 2905: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	.word 0xdef70e80  ! 2906: STXA_R	stxa	%r15, [%r28 + %r0] 0x74
	.word 0xd6bdc4a0  ! 2907: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	.word 0xd68ca000  ! 2908: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r11
	.word 0xd6dca000  ! 2909: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r11
	.word 0x87802073  ! 2910: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6af6000  ! 2911: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0xd2af4e40  ! 2913: STBA_R	stba	%r9, [%r29 + %r0] 0x72
	mov	0x58, %r16
	mov	0x8, %r16
	.word 0xdcbf4e40  ! 2916: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	.word 0xdcc7e000  ! 2917: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0x87802025  ! 2918: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a584a0  ! 2919: STWA_R	stwa	%r11, [%r22 + %r0] 0x25
	.word 0xdc9f8e80  ! 2920: LDDA_R	ldda	[%r30, %r0] 0x74, %r14
	.word 0xd8b7ce40  ! 2921: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	mov	0x40, %r18
	.word 0xd0dec9e0  ! 2923: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r8
	mov	0x7f8, %r23
	.word 0x87802072  ! 2925: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0c7e000  ! 2926: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0xdcdf4e80  ! 2927: LDXA_R	ldxa	[%r29, %r0] 0x74, %r14
	.word 0xda8f8e40  ! 2928: LDUBA_R	lduba	[%r30, %r0] 0x72, %r13
	mov	0x8, %r26
	.word 0x87802073  ! 2930: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 2931: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r22
	.word 0xd09f8e80  ! 2933: LDDA_R	ldda	[%r30, %r0] 0x74, %r8
	mov	0x3f0, %r23
	.word 0x87802073  ! 2935: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0af6000  ! 2936: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd0bf2000  ! 2937: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xd2b78e80  ! 2938: STHA_R	stha	%r9, [%r30 + %r0] 0x74
	.word 0xd8bec9e0  ! 2939: STDA_R	stda	%r12, [%r27 + %r0] 0x4f
	mov	0x7e8, %r21
	.word 0x87802020  ! 2941: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b4e000  ! 2942: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 2943: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a70e60  ! 2944: STWA_R	stwa	%r12, [%r28 + %r0] 0x73
	.word 0xdabe49e0  ! 2945: STDA_R	stda	%r13, [%r25 + %r0] 0x4f
	.word 0x87802025  ! 2946: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r27
	mov	0x7f0, %r21
	.word 0xd68fce80  ! 2949: LDUBA_R	lduba	[%r31, %r0] 0x74, %r11
	.word 0xd0cc8400  ! 2950: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0xd4af0e40  ! 2951: STBA_R	stba	%r10, [%r28 + %r0] 0x72
	.word 0xd0d504a0  ! 2952: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r8
	mov	0x7e0, %r23
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802025  ! 2955: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8be89e0  ! 2956: STDA_R	stda	%r12, [%r26 + %r0] 0x4f
	mov	0x18, %r16
	mov	0x38, %r25
	.word 0xd2c44400  ! 2959: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	mov	0x48, %r24
	.word 0xd8d609e0  ! 2961: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r12
	mov	0x20, %r24
	.word 0xd2bcc400  ! 2963: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xd0a4c400  ! 2964: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xd29fce40  ! 2965: LDDA_R	ldda	[%r31, %r0] 0x72, %r9
	.word 0xd88c4400  ! 2966: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	mov	0x20, %r27
	mov	0x3e0, %r21
	.word 0xd8a78e60  ! 2969: STWA_R	stwa	%r12, [%r30 + %r0] 0x73
	mov	0x0, %r24
	.word 0x87802020  ! 2971: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca4c400  ! 2972: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 2973: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r18
	.word 0xd0c44400  ! 2975: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r8
	mov	0x48, %r16
	.word 0xd0ce2000  ! 2977: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r8
	.word 0xd0966000  ! 2978: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r8
	.word 0xded40400  ! 2979: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	mov	0x3f8, %r21
	.word 0xd8bcc400  ! 2981: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0x87802025  ! 2982: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2983: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r17
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd8bca000  ! 2986: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd28fce80  ! 2987: LDUBA_R	lduba	[%r31, %r0] 0x74, %r9
	.word 0xd2a46000  ! 2988: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd29ca000  ! 2989: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2990: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8a7ce80  ! 2991: STWA_R	stwa	%r12, [%r31 + %r0] 0x74
	.word 0xd4f74e40  ! 2992: STXA_R	stxa	%r10, [%r29 + %r0] 0x72
	.word 0x87802025  ! 2993: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4a52000  ! 2994: STWA_I	stwa	%r10, [%r20 + 0x0000] %asi
	mov	0x0, %r25
	.word 0x87802072  ! 2996: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49fe000  ! 2997: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	mov	0x7d0, %r22
	mov	0x3c8, %r20
	.word 0xd48fe000  ! 3000: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	mov	0x18, %r27
	mov	0x7e8, %r21
	.word 0xd6f48400  ! 3003: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xd6f7e000  ! 3004: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 3005: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab584a0  ! 3006: STHA_R	stha	%r13, [%r22 + %r0] 0x25
	mov	0x58, %r19
	.word 0xdaafe000  ! 3008: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 3009: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaf52000  ! 3010: STXA_I	stxa	%r13, [%r20 + 0x0000] %asi
	.word 0xdaa5c4a0  ! 3011: STWA_R	stwa	%r13, [%r23 + %r0] 0x25
	mov	0x58, %r18
	mov	0x7f8, %r22
	.word 0xdabd2000  ! 3014: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	.word 0xda9de000  ! 3015: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r13
	.word 0x87802073  ! 3016: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda9fe000  ! 3017: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xdacfe000  ! 3018: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0xd4bf0e80  ! 3019: STDA_R	stda	%r10, [%r28 + %r0] 0x74
	mov	0x70, %r25
	mov	0x7d0, %r21
	.word 0xd8b6c9e0  ! 3022: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 3023: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcccc400  ! 3024: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	mov	0x60, %r24
	mov	0x7c8, %r21
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802072  ! 3028: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r27
	.word 0xd28f4e40  ! 3030: LDUBA_R	lduba	[%r29, %r0] 0x72, %r9
	.word 0xd2b76000  ! 3031: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 3032: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 3033: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2bf2000  ! 3034: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd2972000  ! 3035: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xd2a7a000  ! 3036: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	mov	0x68, %r18
	.word 0xd2bfe000  ! 3038: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	mov	0x20, %r25
	mov	0x7e8, %r21
	.word 0xd6af0e80  ! 3041: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	.word 0xd6afa000  ! 3042: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6f7e000  ! 3043: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 3044: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6c6a000  ! 3045: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r11
	.word 0xd6862000  ! 3046: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r11
	mov	0x7f8, %r20
	.word 0xd68e2000  ! 3048: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r11
	.word 0xd0c40400  ! 3049: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	mov	0x3e8, %r20
	mov	0x70, %r24
	.word 0xd0de49e0  ! 3052: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r8
	.word 0xd88504a0  ! 3053: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r12
	.word 0xd6c689e0  ! 3054: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r11
	.word 0xd6f62000  ! 3055: STXA_I	stxa	%r11, [%r24 + 0x0000] %asi
	.word 0xd0b70e40  ! 3056: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	.word 0xd6840400  ! 3057: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0xd69f4e60  ! 3058: LDDA_R	ldda	[%r29, %r0] 0x73, %r11
	.word 0xd48f0e40  ! 3059: LDUBA_R	lduba	[%r28, %r0] 0x72, %r10
	.word 0x87802074  ! 3060: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd48f2000  ! 3061: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4c7a000  ! 3062: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	.word 0xd2af4e40  ! 3063: STBA_R	stba	%r9, [%r29 + %r0] 0x72
	mov	0x68, %r26
	.word 0xd2872000  ! 3065: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	mov	0x0, %r19
	.word 0xd2b76000  ! 3067: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2f7e000  ! 3068: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	mov	0x8, %r26
	.word 0xd2bfa000  ! 3070: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xd2b78e40  ! 3072: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	.word 0xd2a76000  ! 3073: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd4b70e80  ! 3074: STHA_R	stha	%r10, [%r28 + %r0] 0x74
	.word 0xd0a70e80  ! 3075: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0xdc85c4a0  ! 3076: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r14
	.word 0xdc9f6000  ! 3077: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xdc97e000  ! 3078: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xdcb72000  ! 3079: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	mov	0x68, %r25
	.word 0xdcc72000  ! 3081: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xd0ae89e0  ! 3082: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	.word 0xdcdc8400  ! 3083: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	.word 0xdc8fa000  ! 3084: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xd4a544a0  ! 3085: STWA_R	stwa	%r10, [%r21 + %r0] 0x25
	.word 0xd4b76000  ! 3086: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd4ac4400  ! 3087: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0x87802073  ! 3088: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdebe89e0  ! 3089: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	mov	0x68, %r25
	mov	0x30, %r24
	mov	0x70, %r27
	.word 0xdeb7e000  ! 3093: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	mov	0x38, %r24
	.word 0xdecfe000  ! 3095: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xd0acc400  ! 3096: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd4ac4400  ! 3097: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xd0bc0400  ! 3098: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0xd0f7ce80  ! 3099: STXA_R	stxa	%r8, [%r31 + %r0] 0x74
	mov	0x3e8, %r21
	.word 0xd0df6000  ! 3101: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	mov	0x30, %r18
	.word 0xd6f70e60  ! 3103: STXA_R	stxa	%r11, [%r28 + %r0] 0x73
	mov	0x58, %r26
	mov	0x68, %r18
	mov	0x18, %r18
	mov	0x48, %r25
	mov	0x50, %r27
	.word 0xdcf40400  ! 3109: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	mov	0x3f0, %r23
	.word 0xdc8f2000  ! 3111: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	mov	0x20, %r16
	.word 0x87802074  ! 3113: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc9f6000  ! 3114: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xda9f8e60  ! 3115: LDDA_R	ldda	[%r30, %r0] 0x73, %r13
	.word 0x87802020  ! 3116: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c70e60  ! 3117: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r10
	.word 0xd4ace000  ! 3118: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	mov	0x68, %r17
	mov	0x68, %r16
	mov	0x78, %r25
	mov	0x7f0, %r21
	.word 0xd48c2000  ! 3123: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r10
	.word 0xde8ec9e0  ! 3124: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r15
	.word 0xde846000  ! 3125: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0xd6f48400  ! 3126: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xd6a46000  ! 3127: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 3128: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f8, %r21
	.word 0xd6a7e000  ! 3130: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 3131: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f544a0  ! 3132: STXA_R	stxa	%r9, [%r21 + %r0] 0x25
	mov	0x48, %r18
	.word 0xd6f5c4a0  ! 3134: STXA_R	stxa	%r11, [%r23 + %r0] 0x25
	.word 0xd69fce80  ! 3135: LDDA_R	ldda	[%r31, %r0] 0x74, %r11
	.word 0xd6cf2000  ! 3136: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0xd8a70e80  ! 3137: STWA_R	stwa	%r12, [%r28 + %r0] 0x74
	.word 0xd8dfe000  ! 3138: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0x87802072  ! 3139: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r24
	.word 0xd8d72000  ! 3141: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xd6ad44a0  ! 3142: STBA_R	stba	%r11, [%r21 + %r0] 0x25
	.word 0xdad70e60  ! 3143: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r13
	mov	0x58, %r18
	mov	0x28, %r25
	.word 0xdc970e80  ! 3146: LDUHA_R	lduha	[%r28, %r0] 0x74, %r14
	.word 0x87802073  ! 3147: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802072  ! 3149: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f609e0  ! 3150: STXA_R	stxa	%r11, [%r24 + %r0] 0x4f
	.word 0xd6c7ce60  ! 3151: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r11
	.word 0xd6afe000  ! 3152: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd6d7a000  ! 3153: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	.word 0xd687e000  ! 3154: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6f72000  ! 3155: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	mov	0x8, %r25
	.word 0xd2a40400  ! 3157: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xd28fa000  ! 3158: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	mov	0x7f0, %r23
	.word 0xd2b7a000  ! 3160: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xdca78e60  ! 3161: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	.word 0xdea544a0  ! 3162: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	.word 0xded7a000  ! 3163: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xde872000  ! 3164: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xde9fa000  ! 3165: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	.word 0xdef7a000  ! 3166: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdedfe000  ! 3167: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	mov	0x3f8, %r20
	.word 0xdeafe000  ! 3169: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xdea7a000  ! 3170: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	mov	0x18, %r25
	mov	0x7d8, %r23
	.word 0xdec7e000  ! 3173: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xd8f40400  ! 3174: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0x87802074  ! 3175: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa40400  ! 3176: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0xdcac8400  ! 3177: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xdcf7a000  ! 3178: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x40, %r27
	.word 0xd2c44400  ! 3180: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	.word 0xd2f7e000  ! 3181: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	mov	0x48, %r25
	.word 0xdc9ec9e0  ! 3183: LDDA_R	ldda	[%r27, %r0] 0x4f, %r14
	.word 0x87802020  ! 3184: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcac2000  ! 3185: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 3186: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcd56000  ! 3187: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r14
	.word 0x87802072  ! 3188: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r16
	.word 0xdcd7a000  ! 3190: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0xdaac0400  ! 3191: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	mov	0x8, %r19
	mov	0x40, %r24
	mov	0x7c8, %r20
	.word 0xd8978e40  ! 3195: LDUHA_R	lduha	[%r30, %r0] 0x72, %r12
	.word 0xd8f7a000  ! 3196: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	mov	0x3f8, %r22
	.word 0x87802020  ! 3198: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd884e000  ! 3199: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r12
	mov	0x50, %r25
	mov	0x3f8, %r23
	.word 0xdebd84a0  ! 3202: STDA_R	stda	%r15, [%r22 + %r0] 0x25
	.word 0x87802020  ! 3203: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r20
	.word 0xd8c584a0  ! 3205: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r12
	.word 0xd2d40400  ! 3206: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	.word 0xd2d46000  ! 3207: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	.word 0x87802072  ! 3208: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca5c4a0  ! 3209: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	.word 0xdcd7e000  ! 3210: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xdc844400  ! 3211: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	mov	0x68, %r25
	.word 0xdcf76000  ! 3213: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xdcf76000  ! 3215: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 3216: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcac2000  ! 3217: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	mov	0x50, %r26
	.word 0xd8978e60  ! 3219: LDUHA_R	lduha	[%r30, %r0] 0x73, %r12
	.word 0xd8d42000  ! 3220: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0x87802025  ! 3221: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8ada000  ! 3222: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0xd8dd2000  ! 3223: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r12
	.word 0x87802072  ! 3224: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f78e80  ! 3225: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	mov	0x38, %r17
	.word 0x87802072  ! 3227: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49f4e80  ! 3228: LDDA_R	ldda	[%r29, %r0] 0x74, %r10
	mov	0x38, %r25
	mov	0x48, %r18
	mov	0x8, %r24
	mov	0x40, %r25
	.word 0xd4dfa000  ! 3233: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0x87802020  ! 3234: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4aca000  ! 3235: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	mov	0x50, %r24
	.word 0xd295c4a0  ! 3237: LDUHA_R	lduha	[%r23, %r0] 0x25, %r9
	.word 0xda874e60  ! 3238: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r13
	.word 0xdef44400  ! 3239: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	mov	0x60, %r24
	mov	0x40, %r16
	.word 0x87802072  ! 3242: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c0, %r23
	mov	0x7f0, %r22
	.word 0xde87a000  ! 3245: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xd6848400  ! 3246: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	.word 0xd6bf2000  ! 3247: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd8a70e40  ! 3248: STWA_R	stwa	%r12, [%r28 + %r0] 0x72
	.word 0xd0cc4400  ! 3249: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	.word 0x87802020  ! 3250: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdd04a0  ! 3251: LDXA_R	ldxa	[%r20, %r0] 0x25, %r14
	.word 0x87802025  ! 3252: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 3253: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c8, %r21
	.word 0xd0b78e60  ! 3255: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	.word 0xd2af0e80  ! 3256: STBA_R	stba	%r9, [%r28 + %r0] 0x74
	mov	0x7f8, %r21
	.word 0xd2dd6000  ! 3258: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r9
	mov	0x7f0, %r21
	.word 0xdaaf0e40  ! 3260: STBA_R	stba	%r13, [%r28 + %r0] 0x72
	mov	0x3c0, %r22
	.word 0xda9d6000  ! 3262: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r13
	.word 0xdaa5a000  ! 3263: STWA_I	stwa	%r13, [%r22 + 0x0000] %asi
	.word 0xdaa5a000  ! 3264: STWA_I	stwa	%r13, [%r22 + 0x0000] %asi
	.word 0xdac5a000  ! 3265: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r13
	mov	0x7d8, %r23
	.word 0xde9c8400  ! 3267: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	.word 0xdef5a000  ! 3268: STXA_I	stxa	%r15, [%r22 + 0x0000] %asi
	.word 0xdebde000  ! 3269: STDA_I	stda	%r15, [%r23 + 0x0000] %asi
	mov	0x40, %r25
	.word 0xde870e80  ! 3271: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r15
	.word 0xdecd2000  ! 3272: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r15
	mov	0x10, %r19
	mov	0x8, %r17
	mov	0x60, %r19
	.word 0xde8de000  ! 3276: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r15
	.word 0xdaaf8e60  ! 3277: STBA_R	stba	%r13, [%r30 + %r0] 0x73
	.word 0xdaa52000  ! 3278: STWA_I	stwa	%r13, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 3279: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacf6000  ! 3280: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xda97a000  ! 3281: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xdaf7e000  ! 3282: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 3283: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8aec9e0  ! 3284: STBA_R	stba	%r12, [%r27 + %r0] 0x4f
	.word 0xd2a44400  ! 3285: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xd2be6000  ! 3286: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	.word 0xd2be2000  ! 3287: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	.word 0xdcce09e0  ! 3288: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r14
	.word 0xd6bfce40  ! 3289: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	.word 0xd686a000  ! 3290: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r11
	mov	0x7f8, %r21
	.word 0xda94c400  ! 3292: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	mov	0x70, %r25
	.word 0xdaa62000  ! 3294: STWA_I	stwa	%r13, [%r24 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0xdabea000  ! 3296: STDA_I	stda	%r13, [%r26 + 0x0000] %asi
	.word 0xdabe6000  ! 3297: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	.word 0xda962000  ! 3298: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r13
	.word 0xda86e000  ! 3299: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r13
	mov	0x58, %r26
	.word 0xd0a4c400  ! 3301: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xd0f6e000  ! 3302: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	.word 0xd0962000  ! 3303: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r8
	.word 0xd8b7ce40  ! 3304: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0xdcb40400  ! 3305: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	mov	0x7f0, %r21
	.word 0x87802072  ! 3307: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcc70e80  ! 3308: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r14
	mov	0x20, %r26
	.word 0xdccf6000  ! 3310: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdc8f2000  ! 3311: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0x87802074  ! 3312: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d8, %r23
	mov	0x58, %r25
	.word 0xd6cc8400  ! 3315: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	.word 0xda870e40  ! 3316: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r13
	.word 0xdab72000  ! 3317: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdabcc400  ! 3318: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	.word 0xda9fa000  ! 3319: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	mov	0x50, %r24
	mov	0x3f8, %r21
	.word 0xdcbf8e60  ! 3322: STDA_R	stda	%r14, [%r30 + %r0] 0x73
	.word 0xd4bf8e40  ! 3323: STDA_R	stda	%r10, [%r30 + %r0] 0x72
	.word 0xd0f584a0  ! 3324: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	.word 0xd6c5c4a0  ! 3325: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r11
	.word 0xd6b7e000  ! 3326: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd6872000  ! 3327: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd2bd04a0  ! 3328: STDA_R	stda	%r9, [%r20 + %r0] 0x25
	.word 0x87802025  ! 3329: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2cd2000  ! 3330: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r9
	.word 0xd2dd6000  ! 3331: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r9
	.word 0xdcad84a0  ! 3332: STBA_R	stba	%r14, [%r22 + %r0] 0x25
	.word 0xdc9d2000  ! 3333: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r14
	.word 0x87802073  ! 3334: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd09cc400  ! 3335: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	.word 0xd0df6000  ! 3336: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0bf6000  ! 3337: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd087a000  ! 3338: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0xdc844400  ! 3339: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	.word 0xdcf7e000  ! 3340: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 3341: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r26
	.word 0xd6a70e80  ! 3343: STWA_R	stwa	%r11, [%r28 + %r0] 0x74
	.word 0xd6846000  ! 3344: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r11
	.word 0xd6942000  ! 3345: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r11
	.word 0xd6dd84a0  ! 3346: LDXA_R	ldxa	[%r22, %r0] 0x25, %r11
	.word 0xdad44400  ! 3347: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0xdef649e0  ! 3348: STXA_R	stxa	%r15, [%r25 + %r0] 0x4f
	.word 0xde874e40  ! 3349: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r15
	.word 0xdebca000  ! 3350: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 3351: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0dfce40  ! 3352: LDXA_R	ldxa	[%r31, %r0] 0x72, %r8
	.word 0xde878e80  ! 3353: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r15
	.word 0xd6a44400  ! 3354: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0x87802074  ! 3355: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6a72000  ! 3356: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 3357: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r17
	.word 0x8780204f  ! 3359: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcd504a0  ! 3360: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r14
	.word 0xdc8649e0  ! 3361: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r14
	mov	0x7d8, %r20
	mov	0x7f0, %r23
	.word 0xdec544a0  ! 3364: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r15
	.word 0x87802025  ! 3365: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c0, %r23
	.word 0xd6840400  ! 3367: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0xd4a4c400  ! 3368: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 3369: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4862000  ! 3370: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r10
	.word 0xd4a66000  ! 3371: STWA_I	stwa	%r10, [%r25 + 0x0000] %asi
	.word 0xd4c44400  ! 3372: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r10
	.word 0xd48e6000  ! 3373: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r10
	.word 0xd2b40400  ! 3374: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0xd4af4e80  ! 3375: STBA_R	stba	%r10, [%r29 + %r0] 0x74
	.word 0xd4be6000  ! 3376: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0xd4a6a000  ! 3377: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	mov	0x60, %r25
	.word 0xd4de6000  ! 3379: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r10
	.word 0xd4862000  ! 3380: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r10
	.word 0xd496e000  ! 3381: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r10
	.word 0xdef4c400  ! 3382: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	mov	0x58, %r17
	.word 0xdebe6000  ! 3384: STDA_I	stda	%r15, [%r25 + 0x0000] %asi
	.word 0xdef6a000  ! 3385: STXA_I	stxa	%r15, [%r26 + 0x0000] %asi
	.word 0xde966000  ! 3386: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r15
	.word 0xd2a74e80  ! 3387: STWA_R	stwa	%r9, [%r29 + %r0] 0x74
	mov	0x28, %r17
	.word 0x87802025  ! 3389: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bde000  ! 3390: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 3391: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd294a000  ! 3392: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r9
	mov	0x7f0, %r22
	.word 0xd2f42000  ! 3394: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	mov	0x3d0, %r21
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2d4a000  ! 3397: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	mov	0x78, %r27
	.word 0xd2946000  ! 3399: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r9
	.word 0xd2ace000  ! 3400: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	mov	0x60, %r18
	.word 0xd0dcc400  ! 3402: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0xd0846000  ! 3403: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0xd0b4e000  ! 3404: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xded4c400  ! 3405: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r15
	.word 0x87802073  ! 3406: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde976000  ! 3407: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	.word 0xdebf6000  ! 3408: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xdea7a000  ! 3409: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xd2d4c400  ! 3410: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r9
	.word 0xd2bfa000  ! 3411: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 3412: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2ce89e0  ! 3413: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r9
	.word 0xd29c0400  ! 3414: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	mov	0x7e8, %r20
	.word 0xd4bf0e60  ! 3416: STDA_R	stda	%r10, [%r28 + %r0] 0x73
	.word 0xd496a000  ! 3417: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r10
	.word 0xd2c70e80  ! 3418: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r9
	.word 0xd28e2000  ! 3419: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	.word 0xd2c66000  ! 3420: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r9
	.word 0xdadfce60  ! 3421: LDXA_R	ldxa	[%r31, %r0] 0x73, %r13
	.word 0xdaae6000  ! 3422: STBA_I	stba	%r13, [%r25 + 0x0000] %asi
	.word 0xdadea000  ! 3423: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r13
	.word 0xdade6000  ! 3424: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r13
	mov	0x3c0, %r20
	mov	0x70, %r17
	.word 0xdcf5c4a0  ! 3427: STXA_R	stxa	%r14, [%r23 + %r0] 0x25
	.word 0xdeac4400  ! 3428: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	mov	0x7f0, %r23
	.word 0xdedee000  ! 3430: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r15
	.word 0xd0a74e60  ! 3431: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	mov	0x3c8, %r21
	.word 0xd2c74e60  ! 3433: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r9
	.word 0xd2a6a000  ! 3434: STWA_I	stwa	%r9, [%r26 + 0x0000] %asi
	.word 0x87802073  ! 3435: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8dc0400  ! 3436: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0x8780204f  ! 3437: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ae6000  ! 3438: STBA_I	stba	%r12, [%r25 + 0x0000] %asi
	.word 0xd2de49e0  ! 3439: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r9
	.word 0x87802020  ! 3440: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f4e000  ! 3441: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 3442: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b7a000  ! 3443: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	mov	0x0, %r19
	.word 0x87802020  ! 3445: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b6c9e0  ! 3446: STHA_R	stha	%r9, [%r27 + %r0] 0x4f
	.word 0xd68d04a0  ! 3447: LDUBA_R	lduba	[%r20, %r0] 0x25, %r11
	.word 0xda9689e0  ! 3448: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r13
	.word 0xdacc2000  ! 3449: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xdaae89e0  ! 3450: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	.word 0xdab42000  ! 3451: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	mov	0x18, %r26
	.word 0x87802073  ! 3453: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda872000  ! 3454: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3455: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeadc4a0  ! 3456: STBA_R	stba	%r15, [%r23 + %r0] 0x25
	.word 0xdebc6000  ! 3457: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xdedcc400  ! 3458: LDXA_R	ldxa	[%r19, %r0] 0x20, %r15
	mov	0x7e8, %r22
	mov	0x18, %r16
	mov	0x7e0, %r21
	.word 0xdedce000  ! 3462: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r15
	.word 0xd0b48400  ! 3463: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xd29cc400  ! 3464: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	.word 0xdcde49e0  ! 3465: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r14
	.word 0xdad78e40  ! 3466: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r13
	.word 0xd48e09e0  ! 3467: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r10
	.word 0xd0bf8e80  ! 3468: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	mov	0x3e8, %r21
	.word 0xd0cce000  ! 3470: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0946000  ! 3471: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	mov	0x3c0, %r21
	.word 0xdcce49e0  ! 3473: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r14
	.word 0x87802074  ! 3474: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc97e000  ! 3475: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xdcb7a000  ! 3476: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xded544a0  ! 3477: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r15
	.word 0xdef72000  ! 3478: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xdef72000  ! 3479: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	mov	0x7c8, %r22
	mov	0x8, %r16
	.word 0xdeb7a000  ! 3482: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	mov	0x78, %r24
	mov	0x78, %r27
	.word 0xdcde09e0  ! 3485: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r14
	.word 0xdcdf8e40  ! 3486: LDXA_R	ldxa	[%r30, %r0] 0x72, %r14
	.word 0xdca72000  ! 3487: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xd4d689e0  ! 3488: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r10
	.word 0xd2f7ce40  ! 3489: STXA_R	stxa	%r9, [%r31 + %r0] 0x72
	.word 0xd0a40400  ! 3490: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0x87802073  ! 3491: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b7e000  ! 3492: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0xdedf8e60  ! 3493: LDXA_R	ldxa	[%r30, %r0] 0x73, %r15
	.word 0xdef7e000  ! 3494: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xd6b544a0  ! 3495: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	.word 0x87802025  ! 3496: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6cd6000  ! 3497: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r11
	.word 0xd8b609e0  ! 3498: STHA_R	stha	%r12, [%r24 + %r0] 0x4f
	.word 0xd8dde000  ! 3499: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r12
	.word 0xd89de000  ! 3500: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r12
	mov	0x28, %r19
	.word 0xd885e000  ! 3502: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r12
	.word 0x87802072  ! 3503: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd88f6000  ! 3504: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	mov	0x8, %r16
	mov	0x38, %r27
	.word 0xd8c7e000  ! 3507: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 3508: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 3509: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d8, %r21
	.word 0xd8b72000  ! 3511: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd8afe000  ! 3512: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd2bc4400  ! 3513: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0xd4bf0e40  ! 3514: STDA_R	stda	%r10, [%r28 + %r0] 0x72
	.word 0xdcd40400  ! 3515: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	.word 0xdcdf2000  ! 3516: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcdfe000  ! 3517: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xd4940400  ! 3518: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	.word 0xd4d7a000  ! 3519: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	.word 0xd0af4e60  ! 3520: STBA_R	stba	%r8, [%r29 + %r0] 0x73
	.word 0x87802020  ! 3521: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc944400  ! 3522: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	.word 0xde8e09e0  ! 3523: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r15
	.word 0xd8c44400  ! 3524: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r12
	.word 0x87802074  ! 3525: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 3526: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde85c4a0  ! 3527: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r15
	.word 0xd8a40400  ! 3528: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0xded689e0  ! 3529: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r15
	mov	0x38, %r24
	.word 0x87802073  ! 3531: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 3532: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef7e000  ! 3533: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xdeb72000  ! 3534: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xd2ccc400  ! 3535: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	.word 0xd28f2000  ! 3536: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	.word 0xde95c4a0  ! 3537: LDUHA_R	lduha	[%r23, %r0] 0x25, %r15
	.word 0xdedfa000  ! 3538: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x0, %r25
	.word 0x87802025  ! 3540: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbd44a0  ! 3541: STDA_R	stda	%r14, [%r21 + %r0] 0x25
	mov	0x70, %r18
	.word 0x87802025  ! 3543: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r16
	.word 0x87802025  ! 3545: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc952000  ! 3546: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r14
	mov	0x3e0, %r20
	.word 0xd4ce09e0  ! 3548: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r10
	mov	0x7f0, %r20
	mov	0x8, %r16
	.word 0xd4f5a000  ! 3551: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	.word 0x87802073  ! 3552: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdabe49e0  ! 3553: STDA_R	stda	%r13, [%r25 + %r0] 0x4f
	.word 0xdaa76000  ! 3554: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xdadf4e40  ! 3555: LDXA_R	ldxa	[%r29, %r0] 0x72, %r13
	mov	0x78, %r18
	mov	0x20, %r26
	.word 0xda8fa000  ! 3558: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xd08e49e0  ! 3559: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r8
	.word 0xd0f76000  ! 3560: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0f7a000  ! 3561: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xdc9c0400  ! 3563: LDDA_R	ldda	[%r16, %r0] 0x20, %r14
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcf7a000  ! 3565: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x38, %r18
	.word 0xdc8f2000  ! 3567: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0xd4d544a0  ! 3568: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r10
	.word 0xd487a000  ! 3569: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	.word 0x87802073  ! 3570: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd89d44a0  ! 3571: LDDA_R	ldda	[%r21, %r0] 0x25, %r12
	.word 0x8780204f  ! 3572: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8c62000  ! 3573: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r12
	mov	0x3c0, %r22
	.word 0xd8de2000  ! 3575: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r12
	.word 0xd8bdc4a0  ! 3576: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	.word 0xdccfce60  ! 3577: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r14
	.word 0x87802073  ! 3578: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8ac4400  ! 3579: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xd897a000  ! 3580: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	mov	0x7d0, %r21
	.word 0xd49cc400  ! 3582: LDDA_R	ldda	[%r19, %r0] 0x20, %r10
	.word 0xd8bf4e80  ! 3583: STDA_R	stda	%r12, [%r29 + %r0] 0x74
	mov	0x70, %r16
	.word 0xd8bfa000  ! 3585: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0xde978e80  ! 3587: LDUHA_R	lduha	[%r30, %r0] 0x74, %r15
	.word 0xdedfa000  ! 3588: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xdea40400  ! 3589: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xded7a000  ! 3590: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3591: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88dc4a0  ! 3592: LDUBA_R	lduba	[%r23, %r0] 0x25, %r12
	.word 0xd88c2000  ! 3593: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	.word 0xd0d70e40  ! 3594: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r8
	.word 0xdeb74e80  ! 3595: STHA_R	stha	%r15, [%r29 + %r0] 0x74
	.word 0xdeac2000  ! 3596: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 3597: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bf0e40  ! 3598: STDA_R	stda	%r12, [%r28 + %r0] 0x72
	.word 0x87802020  ! 3599: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c4e000  ! 3600: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	.word 0x87802072  ! 3601: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd897e000  ! 3602: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	.word 0xd8afa000  ! 3603: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xded7ce40  ! 3604: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r15
	.word 0x87802025  ! 3605: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 3606: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r17
	mov	0x50, %r24
	.word 0xded7a000  ! 3609: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xdaf544a0  ! 3610: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	.word 0x87802020  ! 3611: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r24
	mov	0x20, %r17
	.word 0xdabca000  ! 3614: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdacca000  ! 3615: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	mov	0x40, %r19
	.word 0x87802020  ! 3617: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa4a000  ! 3618: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xdead44a0  ! 3619: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	.word 0xdea4e000  ! 3620: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xd4a7ce40  ! 3622: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	.word 0xd2adc4a0  ! 3623: STBA_R	stba	%r9, [%r23 + %r0] 0x25
	.word 0xd2f4e000  ! 3624: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd8cc0400  ! 3625: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	mov	0x78, %r17
	.word 0xd8cca000  ! 3627: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r12
	.word 0xd0a70e80  ! 3628: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0x87802074  ! 3629: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0972000  ! 3630: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xd2f5c4a0  ! 3631: STXA_R	stxa	%r9, [%r23 + %r0] 0x25
	.word 0xdaaec9e0  ! 3632: STBA_R	stba	%r13, [%r27 + %r0] 0x4f
	.word 0xd4ae09e0  ! 3633: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0xd4afa000  ! 3634: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 3635: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4876000  ! 3636: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4bf2000  ! 3637: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd4c74e40  ! 3638: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r10
	.word 0xd69f4e60  ! 3639: LDDA_R	ldda	[%r29, %r0] 0x73, %r11
	.word 0xd6afa000  ! 3640: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd68fe000  ! 3641: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xdcf70e40  ! 3642: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	.word 0xd4d70e60  ! 3643: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r10
	.word 0xd49f2000  ! 3644: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd2bec9e0  ! 3645: STDA_R	stda	%r9, [%r27 + %r0] 0x4f
	.word 0x87802025  ! 3646: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8c48400  ! 3647: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	mov	0x8, %r26
	.word 0x87802020  ! 3649: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 3650: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0b40400  ! 3651: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 3652: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b62000  ! 3653: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0xd89584a0  ! 3654: LDUHA_R	lduha	[%r22, %r0] 0x25, %r12
	.word 0x87802020  ! 3655: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bc2000  ! 3656: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	mov	0x3f8, %r23
	.word 0x87802020  ! 3658: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r22
	.word 0x87802073  ! 3660: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3661: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f689e0  ! 3662: STXA_R	stxa	%r9, [%r26 + %r0] 0x4f
	.word 0x8780204f  ! 3663: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 3664: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r18
	.word 0xd28f2000  ! 3666: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	.word 0xd2afe000  ! 3667: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd2cfa000  ! 3668: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	.word 0xd2f7a000  ! 3669: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xd2976000  ! 3670: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0xd29f2000  ! 3671: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3672: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab44400  ! 3673: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0xda84e000  ! 3674: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r13
	mov	0x7d8, %r22
	mov	0x78, %r27
	.word 0xdaace000  ! 3677: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0xdacf0e40  ! 3678: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r13
	.word 0xdaf4a000  ! 3679: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0xded74e60  ! 3680: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r15
	.word 0xdea42000  ! 3681: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xdef4c400  ! 3682: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xde8c2000  ! 3683: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	mov	0x30, %r25
	.word 0xdcbfce60  ! 3685: STDA_R	stda	%r14, [%r31 + %r0] 0x73
	.word 0xdcf4e000  ! 3686: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xd2d689e0  ! 3687: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r9
	.word 0xd4b689e0  ! 3688: STHA_R	stha	%r10, [%r26 + %r0] 0x4f
	.word 0xd4b46000  ! 3689: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xdc9fce80  ! 3690: LDDA_R	ldda	[%r31, %r0] 0x74, %r14
	.word 0xdca4e000  ! 3691: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0xd8a40400  ! 3692: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0xd8cc6000  ! 3693: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r12
	.word 0xd09c4400  ! 3694: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	mov	0x68, %r19
	.word 0xd0afce40  ! 3696: STBA_R	stba	%r8, [%r31 + %r0] 0x72
	.word 0xd08c2000  ! 3697: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0xd0842000  ! 3698: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r8
	.word 0xd49ec9e0  ! 3699: LDDA_R	ldda	[%r27, %r0] 0x4f, %r10
	.word 0x87802025  ! 3700: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e8, %r21
	mov	0x78, %r18
	.word 0xd4a52000  ! 3703: STWA_I	stwa	%r10, [%r20 + 0x0000] %asi
	.word 0xd48da000  ! 3704: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r10
	.word 0xd4dd6000  ! 3705: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r10
	.word 0xd6f689e0  ! 3706: STXA_R	stxa	%r11, [%r26 + %r0] 0x4f
	.word 0xd6dd6000  ! 3707: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3708: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3709: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c8, %r20
	.word 0xdef544a0  ! 3711: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	mov	0x30, %r19
	mov	0x7d0, %r20
	.word 0xdeafce40  ! 3714: STBA_R	stba	%r15, [%r31 + %r0] 0x72
	.word 0xde9fa000  ! 3715: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	.word 0x87802025  ! 3716: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde9d2000  ! 3717: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r15
	mov	0x48, %r19
	.word 0xded56000  ! 3719: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r15
	.word 0xdeb5e000  ! 3720: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	mov	0x40, %r24
	mov	0x68, %r25
	.word 0xde856000  ! 3723: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r15
	.word 0xdcae09e0  ! 3724: STBA_R	stba	%r14, [%r24 + %r0] 0x4f
	mov	0x3c0, %r21
	.word 0xdc856000  ! 3726: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r14
	.word 0xdca56000  ! 3727: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	.word 0xd6a6c9e0  ! 3728: STWA_R	stwa	%r11, [%r27 + %r0] 0x4f
	.word 0x8780204f  ! 3729: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd08f8e80  ! 3730: LDUBA_R	lduba	[%r30, %r0] 0x74, %r8
	mov	0x18, %r18
	.word 0xd0f62000  ! 3732: STXA_I	stxa	%r8, [%r24 + 0x0000] %asi
	.word 0xd0866000  ! 3733: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r8
	.word 0xd4f504a0  ! 3734: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0xd4aee000  ! 3735: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	.word 0xdcdf4e40  ! 3736: LDXA_R	ldxa	[%r29, %r0] 0x72, %r14
	.word 0xdaaf0e60  ! 3737: STBA_R	stba	%r13, [%r28 + %r0] 0x73
	.word 0xdac66000  ! 3738: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3739: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3740: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 3741: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdadf6000  ! 3742: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xde944400  ! 3743: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	.word 0x87802074  ! 3744: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0bd04a0  ! 3745: STDA_R	stda	%r8, [%r20 + %r0] 0x25
	.word 0xd6a5c4a0  ! 3746: STWA_R	stwa	%r11, [%r23 + %r0] 0x25
	.word 0xda9f8e40  ! 3747: LDDA_R	ldda	[%r30, %r0] 0x72, %r13
	.word 0xda87e000  ! 3748: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0xdca544a0  ! 3749: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0x87802074  ! 3750: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb76000  ! 3751: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0xdcbfa000  ! 3753: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xd4cf4e60  ! 3754: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r10
	.word 0x87802020  ! 3755: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 3756: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2f4c400  ! 3757: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xd2f5a000  ! 3758: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	.word 0xd2a52000  ! 3759: STWA_I	stwa	%r9, [%r20 + 0x0000] %asi
	.word 0xd2d52000  ! 3760: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r9
	.word 0x87802072  ! 3761: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd297e000  ! 3762: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	.word 0xd4c70e80  ! 3763: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r10
	mov	0x18, %r26
	.word 0xd6d504a0  ! 3765: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r11
	.word 0xda9d84a0  ! 3766: LDDA_R	ldda	[%r22, %r0] 0x25, %r13
	.word 0xdacf2000  ! 3767: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	mov	0x0, %r19
	.word 0xdacfa000  ! 3769: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xd0f584a0  ! 3770: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	.word 0xd087e000  ! 3771: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0bfe000  ! 3772: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd0f72000  ! 3773: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xd0afe000  ! 3774: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xdca44400  ! 3775: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x7f8, %r23
	.word 0x87802025  ! 3778: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdecf0e80  ! 3779: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r15
	.word 0xd28584a0  ! 3780: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r9
	.word 0xd2b5e000  ! 3781: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xdc840400  ! 3783: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcad6000  ! 3785: STBA_I	stba	%r14, [%r21 + 0x0000] %asi
	.word 0xdaa40400  ! 3786: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0xdaf5a000  ! 3787: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xdeaec9e0  ! 3788: STBA_R	stba	%r15, [%r27 + %r0] 0x4f
	.word 0x87802073  ! 3789: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf48400  ! 3790: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0x87802072  ! 3791: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbf2000  ! 3792: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xd4cf0e40  ! 3793: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r10
	.word 0xd4872000  ! 3794: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0x87802020  ! 3795: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bc2000  ! 3796: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 3797: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a6e000  ! 3798: STWA_I	stwa	%r10, [%r27 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x3d8, %r22
	.word 0xd49e6000  ! 3801: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 3802: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4866000  ! 3803: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r10
	.word 0xd8a74e60  ! 3804: STWA_R	stwa	%r12, [%r29 + %r0] 0x73
	.word 0x87802073  ! 3805: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8afce40  ! 3806: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	.word 0xdc8cc400  ! 3807: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	mov	0x68, %r16
	.word 0xd4c78e40  ! 3809: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r10
	.word 0xd4b7a000  ! 3810: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd4aec9e0  ! 3811: STBA_R	stba	%r10, [%r27 + %r0] 0x4f
	.word 0xd4a76000  ! 3812: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	mov	0x18, %r16
	mov	0x20, %r25
	mov	0x3d0, %r21
	.word 0xd4afe000  ! 3816: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd29f4e40  ! 3817: LDDA_R	ldda	[%r29, %r0] 0x72, %r9
	.word 0x87802073  ! 3818: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8cd44a0  ! 3819: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r12
	mov	0x7f8, %r23
	.word 0xd08f4e60  ! 3821: LDUBA_R	lduba	[%r29, %r0] 0x73, %r8
	mov	0x7e8, %r20
	.word 0xd0cf2000  ! 3823: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0xd0a72000  ! 3824: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x7c8, %r22
	.word 0xd0d7a000  ! 3826: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0x87802073  ! 3827: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r19
	.word 0xd0d76000  ! 3829: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xdede49e0  ! 3830: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r15
	.word 0xd4ac8400  ! 3831: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	mov	0x20, %r19
	.word 0xd4a72000  ! 3833: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 3834: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd49f8e60  ! 3835: LDDA_R	ldda	[%r30, %r0] 0x73, %r10
	.word 0x87802072  ! 3836: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49fe000  ! 3837: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xda9609e0  ! 3838: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r13
	.word 0xd6874e60  ! 3839: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r11
	.word 0xde8609e0  ! 3840: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r15
	.word 0xded7a000  ! 3841: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xd2c44400  ! 3842: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	.word 0xd2dfe000  ! 3843: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2df2000  ! 3844: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2b7a000  ! 3845: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd2d504a0  ! 3846: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r9
	.word 0xd2b7e000  ! 3847: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 3848: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8aec9e0  ! 3849: STBA_R	stba	%r12, [%r27 + %r0] 0x4f
	.word 0xd8f76000  ! 3850: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8cf2000  ! 3851: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0xd8f76000  ! 3852: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd897e000  ! 3853: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	.word 0xd8af6000  ! 3854: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd0af4e40  ! 3855: STBA_R	stba	%r8, [%r29 + %r0] 0x72
	.word 0xdca7ce80  ! 3856: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	.word 0xd2f4c400  ! 3857: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdeb649e0  ! 3859: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	.word 0xdeaf2000  ! 3860: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xdeb76000  ! 3861: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	mov	0x8, %r25
	.word 0xdea7a000  ! 3863: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xdef7a000  ! 3864: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdabcc400  ! 3865: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	.word 0xd0b6c9e0  ! 3866: STHA_R	stha	%r8, [%r27 + %r0] 0x4f
	mov	0x7c8, %r21
	.word 0xd0a72000  ! 3868: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 3869: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a72000  ! 3870: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xd09fa000  ! 3871: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	mov	0x58, %r19
	mov	0x78, %r17
	mov	0x40, %r26
	.word 0xdebf0e40  ! 3875: STDA_R	stda	%r15, [%r28 + %r0] 0x72
	.word 0xdedfa000  ! 3876: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xdea76000  ! 3877: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xdebf2000  ! 3878: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 3879: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 3880: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 3881: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeaf6000  ! 3882: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xde8f2000  ! 3883: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xdea76000  ! 3884: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xdedfe000  ! 3886: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xd685c4a0  ! 3887: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r11
	.word 0x87802073  ! 3888: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3889: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69c2000  ! 3890: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r11
	.word 0xd6b4e000  ! 3891: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	mov	0x48, %r18
	.word 0xd8b70e40  ! 3893: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0xd0844400  ! 3894: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r8
	.word 0xd0bce000  ! 3895: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0xd0bc8400  ! 3896: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	mov	0x60, %r17
	.word 0xd0942000  ! 3898: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r8
	.word 0xd0b4a000  ! 3899: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 3900: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0df2000  ! 3901: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	mov	0x30, %r25
	.word 0x87802020  ! 3903: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0dc2000  ! 3904: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	.word 0xd0846000  ! 3905: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0x87802074  ! 3906: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde9d44a0  ! 3907: LDDA_R	ldda	[%r21, %r0] 0x25, %r15
	.word 0xd6bc0400  ! 3908: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0x87802025  ! 3909: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r25
	.word 0x87802074  ! 3911: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c8, %r21
	.word 0xd6df2000  ! 3913: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6c76000  ! 3914: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6c76000  ! 3915: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	mov	0x7d8, %r22
	.word 0xd4c7ce80  ! 3917: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r10
	.word 0xd4dfa000  ! 3918: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4af2000  ! 3919: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd4c72000  ! 3920: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4b72000  ! 3921: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xdc9fce40  ! 3922: LDDA_R	ldda	[%r31, %r0] 0x72, %r14
	.word 0xdcb689e0  ! 3923: STHA_R	stha	%r14, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 3924: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc8f2000  ! 3925: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0x87802072  ! 3926: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3927: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf62000  ! 3928: STXA_I	stxa	%r14, [%r24 + 0x0000] %asi
	.word 0xdc8ea000  ! 3929: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r14
	mov	0x7e8, %r21
	mov	0x3f8, %r20
	mov	0x78, %r24
	mov	0x70, %r17
	.word 0xdca6e000  ! 3934: STWA_I	stwa	%r14, [%r27 + 0x0000] %asi
	.word 0xdc9e2000  ! 3935: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r14
	mov	0x70, %r18
	.word 0xdcce2000  ! 3937: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r14
	.word 0xdc86e000  ! 3938: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r14
	.word 0xdcb6e000  ! 3939: STHA_I	stha	%r14, [%r27 + 0x0000] %asi
	.word 0xd2d5c4a0  ! 3940: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r9
	.word 0xd28e6000  ! 3941: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r9
	.word 0xd2d66000  ! 3942: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r9
	.word 0xd28e2000  ! 3943: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	.word 0xd2bf8e80  ! 3944: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	.word 0xd2a62000  ! 3945: STWA_I	stwa	%r9, [%r24 + 0x0000] %asi
	.word 0xd4cd84a0  ! 3946: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r10
	.word 0xd4d504a0  ! 3947: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r10
	.word 0xdcdec9e0  ! 3948: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r14
	.word 0xdef689e0  ! 3949: STXA_R	stxa	%r15, [%r26 + %r0] 0x4f
	mov	0x0, %r18
	mov	0x78, %r17
	.word 0xdad78e40  ! 3952: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r13
	.word 0xd4cd84a0  ! 3953: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r10
	mov	0x0, %r17
	.word 0xdeb4c400  ! 3955: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xdef6a000  ! 3956: STXA_I	stxa	%r15, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 3957: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeace000  ! 3958: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xd4b7ce80  ! 3959: STHA_R	stha	%r10, [%r31 + %r0] 0x74
	.word 0x87802074  ! 3960: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a7a000  ! 3961: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	mov	0x68, %r26
	.word 0xdedc4400  ! 3963: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	.word 0xdea72000  ! 3964: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 3965: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bfce80  ! 3966: STDA_R	stda	%r12, [%r31 + %r0] 0x74
	.word 0xd88ca000  ! 3967: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	mov	0x38, %r17
	.word 0xd884a000  ! 3969: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r12
	.word 0xd0b44400  ! 3970: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0x87802074  ! 3971: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdebf4e60  ! 3972: STDA_R	stda	%r15, [%r29 + %r0] 0x73
	mov	0x3e0, %r22
	.word 0xdcf70e80  ! 3974: STXA_R	stxa	%r14, [%r28 + %r0] 0x74
	mov	0x3e8, %r22
	.word 0xd2974e80  ! 3976: LDUHA_R	lduha	[%r29, %r0] 0x74, %r9
	.word 0xd69f8e80  ! 3977: LDDA_R	ldda	[%r30, %r0] 0x74, %r11
	.word 0xdccd44a0  ! 3978: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r14
	mov	0x10, %r16
	.word 0x87802025  ! 3980: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r25
	mov	0x48, %r26
	.word 0xdcb5a000  ! 3983: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdc8d6000  ! 3985: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r14
	mov	0x40, %r25
	.word 0xd08504a0  ! 3987: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r8
	.word 0x87802020  ! 3988: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bca000  ! 3989: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0xd0bc6000  ! 3990: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	.word 0xd0a6c9e0  ! 3991: STWA_R	stwa	%r8, [%r27 + %r0] 0x4f
	.word 0x87802025  ! 3992: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaa584a0  ! 3993: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	.word 0xdac56000  ! 3994: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r13
	.word 0xdad5e000  ! 3995: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r13
	.word 0xdadd04a0  ! 3996: LDXA_R	ldxa	[%r20, %r0] 0x25, %r13
	.word 0x87802020  ! 3997: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf4a000  ! 3998: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0xd28cc400  ! 3999: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	.word 0xd2cc6000  ! 4000: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	.word 0xd2d4e000  ! 4001: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0xdebec9e0  ! 4002: STDA_R	stda	%r15, [%r27 + %r0] 0x4f
	.word 0xdea4a000  ! 4003: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xde846000  ! 4004: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0xd4bcc400  ! 4005: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0xd4ac2000  ! 4006: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0xd4b42000  ! 4007: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 4008: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8a584a0  ! 4009: STWA_R	stwa	%r12, [%r22 + %r0] 0x25
	.word 0xd08e49e0  ! 4010: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r8
	.word 0xd2c689e0  ! 4011: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r9
	.word 0xd2df6000  ! 4012: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	mov	0x60, %r17
	.word 0xd2b70e60  ! 4014: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	.word 0xd2972000  ! 4015: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	mov	0x68, %r24
	.word 0xd2b7a000  ! 4017: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd2b7a000  ! 4018: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd2c72000  ! 4019: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2bf2000  ! 4020: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	mov	0x48, %r27
	.word 0xd2af2000  ! 4022: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	mov	0x8, %r17
	.word 0x87802025  ! 4024: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bd2000  ! 4025: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	.word 0x87802072  ! 4026: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 4027: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd29f2000  ! 4028: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd2af6000  ! 4029: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd2afe000  ! 4030: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd2b7e000  ! 4031: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd8a7ce80  ! 4032: STWA_R	stwa	%r12, [%r31 + %r0] 0x74
	.word 0x8780204f  ! 4033: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 4034: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8bf4e60  ! 4035: STDA_R	stda	%r12, [%r29 + %r0] 0x73
	.word 0x87802020  ! 4036: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd89ca000  ! 4037: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r12
	.word 0xd6dfce40  ! 4038: LDXA_R	ldxa	[%r31, %r0] 0x72, %r11
	mov	0x7f8, %r21
	mov	0x50, %r26
	.word 0xd4940400  ! 4041: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	mov	0x68, %r16
	.word 0x87802025  ! 4043: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d8, %r20
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0ae89e0  ! 4046: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	mov	0x20, %r18
	.word 0x87802072  ! 4048: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4049: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbe09e0  ! 4050: STDA_R	stda	%r14, [%r24 + %r0] 0x4f
	.word 0xdcc689e0  ! 4051: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r14
	.word 0xd0afce80  ! 4052: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	.word 0xd0d4a000  ! 4053: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	.word 0xd484c400  ! 4054: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	.word 0xd2a70e80  ! 4055: STWA_R	stwa	%r9, [%r28 + %r0] 0x74
	.word 0x87802025  ! 4056: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bf4e40  ! 4057: STDA_R	stda	%r9, [%r29 + %r0] 0x72
	.word 0xdcaf0e40  ! 4058: STBA_R	stba	%r14, [%r28 + %r0] 0x72
	.word 0x87802020  ! 4059: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf46000  ! 4060: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	mov	0x7d8, %r20
	mov	0x3d8, %r21
	.word 0xdab609e0  ! 4063: STHA_R	stha	%r13, [%r24 + %r0] 0x4f
	mov	0x70, %r26
	.word 0xdab42000  ! 4065: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4066: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4067: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69f8e40  ! 4068: LDDA_R	ldda	[%r30, %r0] 0x72, %r11
	.word 0xdea78e60  ! 4069: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	.word 0x87802020  ! 4070: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r16
	.word 0xdef46000  ! 4072: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xd08c0400  ! 4073: LDUBA_R	lduba	[%r16, %r0] 0x20, %r8
	.word 0xdedd04a0  ! 4074: LDXA_R	ldxa	[%r20, %r0] 0x25, %r15
	.word 0xdcac8400  ! 4075: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	mov	0x20, %r26
	.word 0x87802072  ! 4077: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcafa000  ! 4078: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xdcf76000  ! 4079: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdca76000  ! 4080: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 4081: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2848400  ! 4082: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r9
	.word 0x8780204f  ! 4083: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f8, %r22
	mov	0x0, %r18
	.word 0xd2862000  ! 4086: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r9
	mov	0x7f0, %r20
	.word 0xd2b6a000  ! 4088: STHA_I	stha	%r9, [%r26 + 0x0000] %asi
	.word 0xd2b6a000  ! 4089: STHA_I	stha	%r9, [%r26 + 0x0000] %asi
	.word 0xd2aee000  ! 4090: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	.word 0xd2cea000  ! 4091: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r9
	.word 0xdec48400  ! 4092: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	.word 0xde940400  ! 4093: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0xd8bf4e60  ! 4094: STDA_R	stda	%r12, [%r29 + %r0] 0x73
	.word 0xd8cea000  ! 4095: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r12
	.word 0xdabfce40  ! 4096: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	.word 0xdaf6a000  ! 4097: STXA_I	stxa	%r13, [%r26 + 0x0000] %asi
	mov	0x28, %r17
	.word 0xde9c4400  ! 4099: LDDA_R	ldda	[%r17, %r0] 0x20, %r15
	mov	0x3e8, %r20
	mov	0x7e8, %r22
	.word 0xde86a000  ! 4102: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r15
	mov	0x78, %r16
	.word 0xd2dd84a0  ! 4104: LDXA_R	ldxa	[%r22, %r0] 0x25, %r9
	mov	0x10, %r18
	.word 0x87802025  ! 4106: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e8, %r23
	.word 0xd2bde000  ! 4108: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	.word 0xdcad44a0  ! 4109: STBA_R	stba	%r14, [%r21 + %r0] 0x25
	mov	0x60, %r27
	mov	0x70, %r25
	.word 0xdc95a000  ! 4112: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r14
	.word 0xda970e60  ! 4113: LDUHA_R	lduha	[%r28, %r0] 0x73, %r13
	mov	0x70, %r25
	.word 0x87802020  ! 4115: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b584a0  ! 4116: STHA_R	stha	%r11, [%r22 + %r0] 0x25
	mov	0x3c8, %r20
	.word 0x8780204f  ! 4118: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6a66000  ! 4119: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	.word 0xdcac0400  ! 4120: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xdcbee000  ! 4121: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	.word 0xdab7ce60  ! 4122: STHA_R	stha	%r13, [%r31 + %r0] 0x73
	.word 0xdad66000  ! 4123: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r13
	.word 0xdac6a000  ! 4124: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r13
	.word 0xdebcc400  ! 4125: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	.word 0xde9ea000  ! 4126: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r15
	.word 0xdebe2000  ! 4127: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	.word 0xd08c0400  ! 4128: LDUBA_R	lduba	[%r16, %r0] 0x20, %r8
	.word 0xd0f6a000  ! 4129: STXA_I	stxa	%r8, [%r26 + 0x0000] %asi
	mov	0x70, %r18
	.word 0xd4ac0400  ! 4131: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xd4966000  ! 4132: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r10
	.word 0xd48e2000  ! 4133: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r10
	.word 0xd49e6000  ! 4134: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r10
	.word 0xd48d04a0  ! 4135: LDUBA_R	lduba	[%r20, %r0] 0x25, %r10
	.word 0xd8af0e60  ! 4136: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	.word 0xd09d44a0  ! 4137: LDDA_R	ldda	[%r21, %r0] 0x25, %r8
	mov	0x38, %r24
	.word 0xd4a44400  ! 4139: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xd4ae6000  ! 4140: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0xdcf7ce80  ! 4141: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	.word 0xdcb66000  ! 4142: STHA_I	stha	%r14, [%r25 + 0x0000] %asi
	mov	0x7f0, %r21
	.word 0xde948400  ! 4144: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	.word 0xdacf8e40  ! 4145: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r13
	.word 0xd2a649e0  ! 4146: STWA_R	stwa	%r9, [%r25 + %r0] 0x4f
	mov	0x0, %r27
	.word 0xd2ae6000  ! 4148: STBA_I	stba	%r9, [%r25 + 0x0000] %asi
	mov	0x7c0, %r21
	.word 0x87802025  ! 4150: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2d5a000  ! 4151: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r9
	.word 0xd2b56000  ! 4152: STHA_I	stha	%r9, [%r21 + 0x0000] %asi
	.word 0xd8a649e0  ! 4153: STWA_R	stwa	%r12, [%r25 + %r0] 0x4f
	.word 0xd0948400  ! 4154: LDUHA_R	lduha	[%r18, %r0] 0x20, %r8
	.word 0xd0dd2000  ! 4155: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0xdead44a0  ! 4156: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	.word 0xd4cc0400  ! 4157: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r10
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7f8, %r23
	mov	0x30, %r25
	.word 0xd4bda000  ! 4161: STDA_I	stda	%r10, [%r22 + 0x0000] %asi
	.word 0x87802025  ! 4162: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdab609e0  ! 4163: STHA_R	stha	%r13, [%r24 + %r0] 0x4f
	mov	0x3f0, %r20
	mov	0x3c8, %r22
	mov	0x7d8, %r22
	mov	0x30, %r27
	.word 0xdac5a000  ! 4168: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r13
	mov	0x3f0, %r22
	mov	0x38, %r26
	.word 0xd0d74e80  ! 4171: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r8
	mov	0x7f8, %r22
	.word 0xdea78e60  ! 4173: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	mov	0x40, %r26
	.word 0xdac7ce60  ! 4175: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r13
	.word 0xd6dc4400  ! 4176: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xded4c400  ! 4177: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r15
	.word 0xd2b6c9e0  ! 4178: STHA_R	stha	%r9, [%r27 + %r0] 0x4f
	mov	0x60, %r19
	.word 0xd2bda000  ! 4180: STDA_I	stda	%r9, [%r22 + 0x0000] %asi
	mov	0x78, %r26
	.word 0x8780204f  ! 4182: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a6a000  ! 4183: STWA_I	stwa	%r9, [%r26 + 0x0000] %asi
	.word 0xdec689e0  ! 4184: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r15
	.word 0xd48504a0  ! 4185: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r10
	.word 0xd4d62000  ! 4186: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r10
	mov	0x3d0, %r20
	mov	0x38, %r27
	mov	0x7c0, %r23
	.word 0x87802072  ! 4190: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4b72000  ! 4191: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	mov	0x68, %r27
	mov	0x3d8, %r20
	mov	0x68, %r17
	.word 0xd6a7ce80  ! 4195: STWA_R	stwa	%r11, [%r31 + %r0] 0x74
	.word 0xd0be89e0  ! 4196: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	.word 0xdeae09e0  ! 4197: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 4198: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9c6000  ! 4199: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0xded46000  ! 4200: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xde94a000  ! 4202: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0xdea4a000  ! 4203: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xde84e000  ! 4204: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	.word 0xdcccc400  ! 4205: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	.word 0x8780204f  ! 4206: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r17
	.word 0xdebf0e80  ! 4208: STDA_R	stda	%r15, [%r28 + %r0] 0x74
	mov	0x50, %r27
	mov	0x20, %r17
	.word 0xd4cc0400  ! 4211: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r10
	.word 0xd4b62000  ! 4212: STHA_I	stha	%r10, [%r24 + 0x0000] %asi
	.word 0xd4f6e000  ! 4213: STXA_I	stxa	%r10, [%r27 + 0x0000] %asi
	.word 0xd4cea000  ! 4214: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r10
	mov	0x3e0, %r21
	mov	0x68, %r25
	.word 0xd4de6000  ! 4217: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r10
	mov	0x50, %r27
	.word 0xde874e60  ! 4219: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r15
	.word 0xd0c70e80  ! 4220: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r8
	.word 0xd086a000  ! 4221: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r8
	mov	0x7c8, %r21
	.word 0xd4c504a0  ! 4223: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r10
	mov	0x30, %r17
	.word 0xd4de6000  ! 4225: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r10
	.word 0xd4dea000  ! 4226: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	.word 0xd8f609e0  ! 4227: STXA_R	stxa	%r12, [%r24 + %r0] 0x4f
	.word 0xd6bc0400  ! 4228: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xd6ae2000  ! 4229: STBA_I	stba	%r11, [%r24 + 0x0000] %asi
	.word 0xdac6c9e0  ! 4230: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r13
	mov	0x28, %r17
	.word 0xda96e000  ! 4232: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r13
	.word 0xdaaf0e60  ! 4233: STBA_R	stba	%r13, [%r28 + %r0] 0x73
	.word 0xdec78e80  ! 4234: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r15
	.word 0xd89f4e80  ! 4235: LDDA_R	ldda	[%r29, %r0] 0x74, %r12
	.word 0xd4b4c400  ! 4236: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0xd0cf4e60  ! 4237: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r8
	.word 0x87802020  ! 4238: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r16
	.word 0xd0b42000  ! 4240: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4241: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08c2000  ! 4242: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0xdaaec9e0  ! 4243: STBA_R	stba	%r13, [%r27 + %r0] 0x4f
	mov	0x7e0, %r23
	.word 0x87802072  ! 4245: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xded70e60  ! 4246: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r15
	.word 0x87802025  ! 4247: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdecda000  ! 4248: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r15
	mov	0x60, %r25
	.word 0xdebf0e60  ! 4250: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	.word 0xd48d84a0  ! 4251: LDUBA_R	lduba	[%r22, %r0] 0x25, %r10
	.word 0xd4a56000  ! 4252: STWA_I	stwa	%r10, [%r21 + 0x0000] %asi
	mov	0x70, %r27
	.word 0x8780204f  ! 4254: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f0, %r20
	.word 0xd4aee000  ! 4256: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0xd48e6000  ! 4258: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r10
	.word 0xd4ae2000  ! 4259: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	.word 0xdabdc4a0  ! 4260: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	.word 0xda9ee000  ! 4261: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r13
	.word 0xdcf544a0  ! 4262: STXA_R	stxa	%r14, [%r21 + %r0] 0x25
	.word 0x87802025  ! 4263: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc9584a0  ! 4264: LDUHA_R	lduha	[%r22, %r0] 0x25, %r14
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x68, %r19
	.word 0xd4bf8e40  ! 4267: STDA_R	stda	%r10, [%r30 + %r0] 0x72
	.word 0xd4ad6000  ! 4268: STBA_I	stba	%r10, [%r21 + 0x0000] %asi
	.word 0xd4f5e000  ! 4269: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	mov	0x70, %r17
	.word 0x87802074  ! 4271: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a76000  ! 4272: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 4273: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd494a000  ! 4274: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r10
	.word 0xdcdc0400  ! 4275: LDXA_R	ldxa	[%r16, %r0] 0x20, %r14
	.word 0x8780204f  ! 4276: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4af0e60  ! 4277: STBA_R	stba	%r10, [%r28 + %r0] 0x73
	.word 0xd4f66000  ! 4278: STXA_I	stxa	%r10, [%r25 + 0x0000] %asi
	.word 0xd4bee000  ! 4279: STDA_I	stda	%r10, [%r27 + 0x0000] %asi
	.word 0x87802072  ! 4280: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cf6000  ! 4281: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0xd2f7ce60  ! 4282: STXA_R	stxa	%r9, [%r31 + %r0] 0x73
	.word 0xd2f7ce40  ! 4283: STXA_R	stxa	%r9, [%r31 + %r0] 0x72
	.word 0x87802020  ! 4284: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdc0400  ! 4285: LDXA_R	ldxa	[%r16, %r0] 0x20, %r14
	mov	0x10, %r25
	mov	0x60, %r19
	mov	0x0, %r27
	.word 0xdcac4400  ! 4289: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	.word 0xdcc4e000  ! 4290: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r14
	.word 0xdca4e000  ! 4291: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcd4e000  ! 4292: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	.word 0xdab609e0  ! 4293: STHA_R	stha	%r13, [%r24 + %r0] 0x4f
	.word 0xdab46000  ! 4294: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0xdadc6000  ! 4296: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xd28544a0  ! 4297: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r9
	.word 0xd2aca000  ! 4298: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	mov	0x10, %r17
	.word 0xdabcc400  ! 4300: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	.word 0xd0b74e40  ! 4301: STHA_R	stha	%r8, [%r29 + %r0] 0x72
	.word 0xd0f4a000  ! 4302: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 4303: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbfce60  ! 4304: STDA_R	stda	%r14, [%r31 + %r0] 0x73
	mov	0x3f8, %r22
	.word 0xde8649e0  ! 4306: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r15
	.word 0xde9544a0  ! 4307: LDUHA_R	lduha	[%r21, %r0] 0x25, %r15
	.word 0xdef72000  ! 4308: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	mov	0x60, %r19
	.word 0x87802025  ! 4310: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb5e000  ! 4311: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	.word 0xdcbfce80  ! 4312: STDA_R	stda	%r14, [%r31 + %r0] 0x74
	.word 0x87802020  ! 4313: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r19
	.word 0xdcdca000  ! 4315: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xd2878e60  ! 4316: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r9
	.word 0xd2a46000  ! 4317: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd8a44400  ! 4318: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xd6b74e40  ! 4319: STHA_R	stha	%r11, [%r29 + %r0] 0x72
	.word 0xd6b42000  ! 4320: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 4321: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r19
	mov	0x20, %r18
	mov	0x60, %r25
	.word 0x87802020  ! 4325: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ac6000  ! 4326: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xd8b4c400  ! 4327: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 4328: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda8504a0  ! 4329: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r13
	mov	0x7e0, %r23
	.word 0xdef78e60  ! 4331: STXA_R	stxa	%r15, [%r30 + %r0] 0x73
	mov	0x3d8, %r22
	.word 0xdc874e80  ! 4333: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r14
	mov	0x7d0, %r21
	.word 0xdccea000  ! 4335: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r14
	.word 0xdcae2000  ! 4336: STBA_I	stba	%r14, [%r24 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdcb6a000  ! 4338: STHA_I	stha	%r14, [%r26 + 0x0000] %asi
	mov	0x60, %r26
	mov	0x48, %r27
	mov	0x7e8, %r21
	.word 0xd0bf8e60  ! 4342: STDA_R	stda	%r8, [%r30 + %r0] 0x73
	.word 0x87802020  ! 4343: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r20
	.word 0xdca44400  ! 4345: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0x87802074  ! 4346: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6dc0400  ! 4347: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	.word 0xd6afe000  ! 4348: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd6df6000  ! 4349: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	mov	0x10, %r25
	.word 0xd6afa000  ! 4351: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x60, %r17
	.word 0xd2bf0e40  ! 4353: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	.word 0xd8c74e40  ! 4354: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r12
	.word 0xd8f76000  ! 4355: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xda94c400  ! 4356: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	.word 0xdaafa000  ! 4357: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xda8f2000  ! 4358: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xd8a48400  ! 4359: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	.word 0xdcbf4e40  ! 4360: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	.word 0xdcbf6000  ! 4361: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 4362: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4363: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r25
	.word 0xd6c5c4a0  ! 4365: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r11
	mov	0x7d8, %r21
	.word 0x87802073  ! 4367: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4ad44a0  ! 4368: STBA_R	stba	%r10, [%r21 + %r0] 0x25
	.word 0x87802020  ! 4369: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4370: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 4371: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cd2000  ! 4372: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r10
	.word 0xdc8e09e0  ! 4373: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r14
	.word 0xd0970e60  ! 4374: LDUHA_R	lduha	[%r28, %r0] 0x73, %r8
	.word 0xd0a52000  ! 4375: STWA_I	stwa	%r8, [%r20 + 0x0000] %asi
	mov	0x3c8, %r20
	mov	0x3f0, %r21
	mov	0x7e0, %r20
	mov	0x28, %r26
	.word 0xd6b78e80  ! 4380: STHA_R	stha	%r11, [%r30 + %r0] 0x74
	.word 0x87802020  ! 4381: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bc6000  ! 4382: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 4383: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6cf6000  ! 4384: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0x87802020  ! 4385: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29c0400  ! 4386: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	.word 0xd2f4a000  ! 4387: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0xd48d84a0  ! 4388: LDUBA_R	lduba	[%r22, %r0] 0x25, %r10
	.word 0x87802073  ! 4389: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c0, %r22
	mov	0x48, %r26
	.word 0xda9f0e80  ! 4392: LDDA_R	ldda	[%r28, %r0] 0x74, %r13
	.word 0xdaafa000  ! 4393: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdaafa000  ! 4394: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 4395: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaa52000  ! 4396: STWA_I	stwa	%r13, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 4397: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 4398: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2c4c400  ! 4399: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0xd69c4400  ! 4400: LDDA_R	ldda	[%r17, %r0] 0x20, %r11
	.word 0xdaac8400  ! 4401: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	mov	0x38, %r19
	.word 0x87802020  ! 4403: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa4e000  ! 4404: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0xdab4e000  ! 4405: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xdaac6000  ! 4406: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 4407: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4408: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdacf6000  ! 4409: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xd0978e80  ! 4410: LDUHA_R	lduha	[%r30, %r0] 0x74, %r8
	.word 0xdca78e80  ! 4411: STWA_R	stwa	%r14, [%r30 + %r0] 0x74
	mov	0x58, %r19
	.word 0xdca72000  ! 4413: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcb7e000  ! 4414: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xd49fce60  ! 4415: LDDA_R	ldda	[%r31, %r0] 0x73, %r10
	mov	0x3f0, %r20
	.word 0xd48f6000  ! 4417: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xd68f0e80  ! 4418: LDUBA_R	lduba	[%r28, %r0] 0x74, %r11
	.word 0xd6a7e000  ! 4419: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 4420: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r27
	.word 0xda8f0e40  ! 4422: LDUBA_R	lduba	[%r28, %r0] 0x72, %r13
	.word 0x87802020  ! 4423: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4424: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 4425: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaad6000  ! 4426: STBA_I	stba	%r13, [%r21 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xdac5a000  ! 4428: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r13
	.word 0xdaf56000  ! 4429: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 4430: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabc2000  ! 4431: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 4432: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 4433: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r24
	.word 0xdad5a000  ! 4435: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r13
	mov	0x10, %r18
	.word 0x87802074  ! 4437: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf7a000  ! 4438: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdabfa000  ! 4439: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdeb74e80  ! 4440: STHA_R	stha	%r15, [%r29 + %r0] 0x74
	.word 0xd8878e80  ! 4441: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r12
	.word 0x87802073  ! 4442: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4443: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r24
	.word 0xd0f48400  ! 4445: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0x87802025  ! 4446: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r26
	.word 0xd09d6000  ! 4448: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 4449: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0aea000  ! 4450: STBA_I	stba	%r8, [%r26 + 0x0000] %asi
	.word 0xdad40400  ! 4451: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	.word 0xdc9f4e60  ! 4452: LDDA_R	ldda	[%r29, %r0] 0x73, %r14
	.word 0x87802025  ! 4453: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc8e49e0  ! 4454: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r14
	.word 0x8780204f  ! 4455: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 4456: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xded544a0  ! 4457: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r15
	.word 0x87802073  ! 4458: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d0, %r23
	.word 0xdea48400  ! 4460: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xd6dfce80  ! 4461: LDXA_R	ldxa	[%r31, %r0] 0x74, %r11
	.word 0x8780204f  ! 4462: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6862000  ! 4463: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r11
	.word 0x87802020  ! 4464: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r21
	.word 0xdec44400  ! 4466: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0xdeac2000  ! 4467: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xde9ce000  ! 4468: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	mov	0x7e0, %r23
	mov	0x30, %r18
	.word 0xdeb42000  ! 4471: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0xdcbc8400  ! 4472: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	mov	0x40, %r17
	.word 0xd4c40400  ! 4474: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	.word 0xdaaf4e40  ! 4475: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	.word 0xda94a000  ! 4476: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	.word 0xda942000  ! 4477: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0xdadca000  ! 4478: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0xd2878e80  ! 4479: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r9
	.word 0xd2c46000  ! 4480: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0x87802020  ! 4481: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28ca000  ! 4482: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	mov	0x78, %r19
	mov	0x18, %r26
	.word 0xd0ccc400  ! 4485: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	.word 0x87802072  ! 4486: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4dc0400  ! 4487: LDXA_R	ldxa	[%r16, %r0] 0x20, %r10
	mov	0x7d0, %r21
	.word 0xd6cd84a0  ! 4489: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r11
	.word 0xd6872000  ! 4490: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xdca48400  ! 4491: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xdccfe000  ! 4492: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xd2b70e40  ! 4493: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	.word 0xd2df6000  ! 4494: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0xdebec9e0  ! 4495: STDA_R	stda	%r15, [%r27 + %r0] 0x4f
	.word 0xdc8f0e80  ! 4496: LDUBA_R	lduba	[%r28, %r0] 0x74, %r14
	.word 0xdc9f2000  ! 4497: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	mov	0x28, %r27
	.word 0x8780204f  ! 4499: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd085c4a0  ! 4500: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r8
	mov	0x28, %r18
	mov	0x40, %r17
	.word 0xd08ea000  ! 4503: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r8
	.word 0xd09ea000  ! 4504: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r8
	mov	0x3d8, %r20
	.word 0xdaf78e40  ! 4506: STXA_R	stxa	%r13, [%r30 + %r0] 0x72
	mov	0x60, %r25
	.word 0xdab6e000  ! 4508: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	mov	0x3f8, %r23
	.word 0xd69d44a0  ! 4510: LDDA_R	ldda	[%r21, %r0] 0x25, %r11
	.word 0xd6f66000  ! 4511: STXA_I	stxa	%r11, [%r25 + 0x0000] %asi
	.word 0xd6a6a000  ! 4512: STWA_I	stwa	%r11, [%r26 + 0x0000] %asi
	.word 0xd6b66000  ! 4513: STHA_I	stha	%r11, [%r25 + 0x0000] %asi
	.word 0xd6dea000  ! 4514: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r11
	mov	0x0, %r16
	.word 0xd2948400  ! 4516: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	.word 0xd2de2000  ! 4517: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r9
	.word 0x87802073  ! 4518: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2d7e000  ! 4519: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xd28f6000  ! 4520: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd2df6000  ! 4521: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	mov	0x7e0, %r20
	.word 0xd8c74e40  ! 4523: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r12
	mov	0x7c8, %r21
	mov	0x7f8, %r21
	mov	0x30, %r24
	.word 0xd4a74e80  ! 4527: STWA_R	stwa	%r10, [%r29 + %r0] 0x74
	.word 0x87802020  ! 4528: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bca000  ! 4529: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0xd4cca000  ! 4530: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r10
	mov	0x7c0, %r20
	.word 0xd49c6000  ! 4532: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0xd0dc8400  ! 4533: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	mov	0x48, %r16
	.word 0xded4c400  ! 4535: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r15
	.word 0xdc874e60  ! 4536: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r14
	.word 0xdcf4a000  ! 4537: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdaa649e0  ! 4538: STWA_R	stwa	%r13, [%r25 + %r0] 0x4f
	.word 0xd2af4e40  ! 4539: STBA_R	stba	%r9, [%r29 + %r0] 0x72
	.word 0xd2bc6000  ! 4540: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0xd2c46000  ! 4541: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0xd2c4e000  ! 4542: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xd0b4c400  ! 4543: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0xd0c4a000  ! 4544: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	mov	0x60, %r26
	.word 0xd48f0e80  ! 4546: LDUBA_R	lduba	[%r28, %r0] 0x74, %r10
	.word 0x87802074  ! 4547: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a72000  ! 4548: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd2f78e60  ! 4549: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0xdaa78e40  ! 4550: STWA_R	stwa	%r13, [%r30 + %r0] 0x72
	mov	0x18, %r25
	.word 0xd6cf4e60  ! 4552: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r11
	.word 0xd68f2000  ! 4553: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xd6bf2000  ! 4554: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd6870e60  ! 4555: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r11
	.word 0xd0cfce40  ! 4556: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r8
	.word 0x87802074  ! 4557: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4bcc400  ! 4558: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0xd4cf2000  ! 4559: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	mov	0x70, %r26
	.word 0xdaf4c400  ! 4561: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 4562: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6878e40  ! 4563: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r11
	.word 0xd6cfce40  ! 4564: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r11
	.word 0xd6b6a000  ! 4565: STHA_I	stha	%r11, [%r26 + 0x0000] %asi
	.word 0xd6c62000  ! 4566: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r11
	.word 0xd2cc0400  ! 4567: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r9
	.word 0xdcb504a0  ! 4568: STHA_R	stha	%r14, [%r20 + %r0] 0x25
	mov	0x48, %r27
	.word 0x8780204f  ! 4570: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 4571: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4572: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4573: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8ad04a0  ! 4574: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	.word 0xd8f76000  ! 4575: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd4a4c400  ! 4576: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0xd2dd44a0  ! 4577: LDXA_R	ldxa	[%r21, %r0] 0x25, %r9
	.word 0x87802020  ! 4578: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a649e0  ! 4579: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	.word 0xd0c584a0  ! 4580: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r8
	mov	0x7c0, %r20
	.word 0x87802020  ! 4582: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r18
	.word 0x87802074  ! 4584: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbf4e40  ! 4585: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	.word 0x87802074  ! 4586: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r27
	.word 0xdecec9e0  ! 4588: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r15
	mov	0x7e0, %r20
	.word 0x87802020  ! 4590: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9d84a0  ! 4591: LDDA_R	ldda	[%r22, %r0] 0x25, %r15
	.word 0xde94a000  ! 4592: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0xdaf74e80  ! 4593: STXA_R	stxa	%r13, [%r29 + %r0] 0x74
	mov	0x7c0, %r21
	mov	0x68, %r27
	.word 0x87802020  ! 4596: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 4597: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad5a000  ! 4598: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r13
	.word 0xd4a7ce80  ! 4599: STWA_R	stwa	%r10, [%r31 + %r0] 0x74
	.word 0xd4dd2000  ! 4600: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r10
	.word 0x87802072  ! 4601: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r17
	mov	0x48, %r16
	mov	0x48, %r24
	.word 0xdc8fce80  ! 4605: LDUBA_R	lduba	[%r31, %r0] 0x74, %r14
	.word 0xdeac0400  ! 4606: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 4607: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2c4c400  ! 4608: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0xd296a000  ! 4609: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r9
	.word 0xd2d6e000  ! 4610: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r9
	mov	0x40, %r24
	.word 0xd2966000  ! 4612: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r9
	mov	0x7d8, %r20
	mov	0x30, %r19
	.word 0xd4bcc400  ! 4615: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0xd4dee000  ! 4616: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r10
	.word 0xd2c544a0  ! 4617: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r9
	.word 0xdebf4e40  ! 4618: STDA_R	stda	%r15, [%r29 + %r0] 0x72
	mov	0x0, %r19
	.word 0xd2f7ce40  ! 4620: STXA_R	stxa	%r9, [%r31 + %r0] 0x72
	.word 0xdabfce40  ! 4621: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	.word 0xda974e80  ! 4622: LDUHA_R	lduha	[%r29, %r0] 0x74, %r13
	.word 0xda962000  ! 4623: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4624: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda842000  ! 4625: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r13
	.word 0xd6a7ce80  ! 4626: STWA_R	stwa	%r11, [%r31 + %r0] 0x74
	mov	0x3c8, %r20
	.word 0xd6af4e60  ! 4628: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	.word 0xd0dc4400  ! 4629: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	.word 0x87802074  ! 4630: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0d76000  ! 4631: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	mov	0x50, %r16
	mov	0x7f0, %r22
	.word 0xd4bc0400  ! 4634: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xd4afa000  ! 4635: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd8b70e40  ! 4636: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0x87802025  ! 4637: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcd74e80  ! 4638: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r14
	.word 0x8780204f  ! 4639: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc862000  ! 4640: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4641: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4642: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdadc0400  ! 4643: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	.word 0xdacee000  ! 4644: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r13
	.word 0xd8b689e0  ! 4645: STHA_R	stha	%r12, [%r26 + %r0] 0x4f
	.word 0x87802072  ! 4646: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8bf6000  ! 4647: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	mov	0x10, %r17
	.word 0xd8bf2000  ! 4649: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	mov	0x48, %r26
	.word 0xd8a7e000  ! 4651: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8876000  ! 4652: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4653: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r19
	.word 0x8780204f  ! 4655: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4656: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8dc2000  ! 4657: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0xd8c649e0  ! 4658: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r12
	.word 0xd0f504a0  ! 4659: STXA_R	stxa	%r8, [%r20 + %r0] 0x25
	.word 0xd2f7ce60  ! 4660: STXA_R	stxa	%r9, [%r31 + %r0] 0x73
	.word 0xdc9c4400  ! 4661: LDDA_R	ldda	[%r17, %r0] 0x20, %r14
	.word 0x87802073  ! 4662: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 4663: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4664: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r27
	mov	0x58, %r25
	.word 0xd48504a0  ! 4667: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r10
	.word 0xde8f4e80  ! 4668: LDUBA_R	lduba	[%r29, %r0] 0x74, %r15
	mov	0x60, %r18
	mov	0x7c8, %r21
	.word 0x8780204f  ! 4671: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f78e40  ! 4672: STXA_R	stxa	%r11, [%r30 + %r0] 0x72
	.word 0xd6ce6000  ! 4673: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r11
	mov	0x8, %r26
	.word 0x87802072  ! 4675: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6cc0400  ! 4676: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r11
	.word 0xd6c7e000  ! 4677: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	mov	0x7c8, %r21
	.word 0xd697a000  ! 4679: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0xd6af2000  ! 4680: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xda870e40  ! 4681: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r13
	.word 0x87802072  ! 4682: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda976000  ! 4683: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	.word 0xdadf2000  ! 4684: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0x87802072  ! 4685: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab76000  ! 4686: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xd49f4e60  ! 4687: LDDA_R	ldda	[%r29, %r0] 0x73, %r10
	.word 0xd4df2000  ! 4688: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	mov	0x3f0, %r21
	.word 0xd2d4c400  ! 4690: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r9
	mov	0x18, %r18
	.word 0x87802073  ! 4692: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2d7a000  ! 4693: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0xd2f72000  ! 4694: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	mov	0x8, %r18
	mov	0x40, %r18
	.word 0xd885c4a0  ! 4697: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r12
	.word 0x87802074  ! 4698: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8b7e000  ! 4699: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0xd0acc400  ! 4700: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd29fce40  ! 4701: LDDA_R	ldda	[%r31, %r0] 0x72, %r9
	.word 0xdaa70e60  ! 4702: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	.word 0xd88c0400  ! 4703: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	.word 0xd6d504a0  ! 4704: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r11
	.word 0x8780204f  ! 4705: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f66000  ! 4706: STXA_I	stxa	%r11, [%r25 + 0x0000] %asi
	.word 0xd6a649e0  ! 4707: STWA_R	stwa	%r11, [%r25 + %r0] 0x4f
	.word 0xd6b66000  ! 4708: STHA_I	stha	%r11, [%r25 + 0x0000] %asi
	.word 0xd6aea000  ! 4709: STBA_I	stba	%r11, [%r26 + 0x0000] %asi
	.word 0xd6aee000  ! 4710: STBA_I	stba	%r11, [%r27 + 0x0000] %asi
	mov	0x10, %r26
	.word 0xdcd5c4a0  ! 4712: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r14
	.word 0x87802072  ! 4713: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4714: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca4e000  ! 4715: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0xd2878e60  ! 4716: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r9
	.word 0x87802072  ! 4717: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7c0, %r23
	.word 0x87802025  ! 4719: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r25
	.word 0xd2a5a000  ! 4721: STWA_I	stwa	%r9, [%r22 + 0x0000] %asi
	.word 0xd28da000  ! 4722: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r9
	.word 0xd8a7ce60  ! 4723: STWA_R	stwa	%r12, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 4724: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde8c8400  ! 4725: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	mov	0x7c8, %r23
	.word 0x87802072  ! 4727: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb76000  ! 4728: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 4729: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 4730: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeaf2000  ! 4731: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xd8b6c9e0  ! 4732: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	.word 0xd8af2000  ! 4733: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xdea44400  ! 4734: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xdad584a0  ! 4735: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r13
	.word 0xdadfa000  ! 4736: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	mov	0x3f0, %r23
	.word 0xdaf72000  ! 4738: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xd4f78e60  ! 4739: STXA_R	stxa	%r10, [%r30 + %r0] 0x73
	.word 0xd48fa000  ! 4740: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xdabfce60  ! 4741: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	.word 0xda97a000  ! 4742: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xdeb649e0  ! 4743: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	.word 0x87802072  ! 4744: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f609e0  ! 4745: STXA_R	stxa	%r10, [%r24 + %r0] 0x4f
	.word 0xd2b44400  ! 4746: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	mov	0x28, %r24
	.word 0xdea78e80  ! 4748: STWA_R	stwa	%r15, [%r30 + %r0] 0x74
	.word 0xd8c70e40  ! 4749: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r12
	.word 0xd49f8e60  ! 4750: LDDA_R	ldda	[%r30, %r0] 0x73, %r10
	.word 0xd6f74e80  ! 4751: STXA_R	stxa	%r11, [%r29 + %r0] 0x74
	.word 0xdebd44a0  ! 4752: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	.word 0xd0a44400  ! 4753: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xd0afa000  ! 4754: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd4a7ce80  ! 4755: STWA_R	stwa	%r10, [%r31 + %r0] 0x74
	.word 0xd4a76000  ! 4756: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xdcd584a0  ! 4757: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r14
	mov	0x58, %r16
	.word 0xde87ce40  ! 4759: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r15
	mov	0x70, %r25
	.word 0xdea7e000  ! 4761: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xd2bf8e40  ! 4762: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	mov	0x18, %r17
	.word 0xd2dfe000  ! 4764: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2b7e000  ! 4765: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2a7a000  ! 4766: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xd29f2000  ! 4767: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd2a76000  ! 4768: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xdcf48400  ! 4769: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xd0b78e60  ! 4770: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	mov	0x7d0, %r23
	mov	0x30, %r24
	.word 0x87802020  ! 4773: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4df4e40  ! 4774: LDXA_R	ldxa	[%r29, %r0] 0x72, %r10
	mov	0x60, %r16
	.word 0x87802073  ! 4776: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b72000  ! 4777: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd4b7a000  ! 4778: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd68fce80  ! 4779: LDUBA_R	lduba	[%r31, %r0] 0x74, %r11
	.word 0xd6f7e000  ! 4780: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6876000  ! 4781: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6afa000  ! 4782: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd68f2000  ! 4783: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xdcadc4a0  ! 4784: STBA_R	stba	%r14, [%r23 + %r0] 0x25
	mov	0x68, %r19
	.word 0xdca76000  ! 4786: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdc87e000  ! 4787: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 4788: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r19
	mov	0x20, %r17
	.word 0xdead04a0  ! 4791: STBA_R	stba	%r15, [%r20 + %r0] 0x25
	.word 0xdece2000  ! 4792: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r15
	.word 0xdebee000  ! 4793: STDA_I	stda	%r15, [%r27 + 0x0000] %asi
	.word 0xde862000  ! 4794: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r15
	.word 0xdea6a000  ! 4795: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	.word 0xdeb62000  ! 4796: STHA_I	stha	%r15, [%r24 + 0x0000] %asi
	mov	0x60, %r25
	.word 0xdcae89e0  ! 4798: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	mov	0x38, %r27
	.word 0xdab70e60  ! 4800: STHA_R	stha	%r13, [%r28 + %r0] 0x73
	mov	0x78, %r19
	.word 0xdeae89e0  ! 4802: STBA_R	stba	%r15, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 4803: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a74e60  ! 4804: STWA_R	stwa	%r10, [%r29 + %r0] 0x73
	.word 0xd4c46000  ! 4805: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r10
	.word 0xd4ac2000  ! 4806: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0xd6974e80  ! 4807: LDUHA_R	lduha	[%r29, %r0] 0x74, %r11
	.word 0xd6a4a000  ! 4808: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	mov	0x8, %r27
	.word 0xd69ca000  ! 4810: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r11
	mov	0x48, %r25
	.word 0xdacfce40  ! 4812: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r13
	mov	0x8, %r16
	.word 0xd0adc4a0  ! 4814: STBA_R	stba	%r8, [%r23 + %r0] 0x25
	.word 0xdaf70e40  ! 4815: STXA_R	stxa	%r13, [%r28 + %r0] 0x72
	.word 0xd694c400  ! 4816: LDUHA_R	lduha	[%r19, %r0] 0x20, %r11
	.word 0xd6d4a000  ! 4817: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r11
	.word 0xd69c6000  ! 4818: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r11
	.word 0xd6c42000  ! 4819: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r11
	.word 0xd6dce000  ! 4820: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0xd6a4e000  ! 4821: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0xda8e49e0  ! 4822: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r13
	mov	0x68, %r18
	.word 0x87802020  ! 4824: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8c6000  ! 4825: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r13
	.word 0xda942000  ! 4826: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0xdaa4a000  ! 4827: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xdaaca000  ! 4828: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0xdabd84a0  ! 4829: STDA_R	stda	%r13, [%r22 + %r0] 0x25
	mov	0x28, %r16
	.word 0xdab7ce40  ! 4831: STHA_R	stha	%r13, [%r31 + %r0] 0x72
	mov	0x3e8, %r21
	.word 0xd8a48400  ! 4833: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	.word 0xdebd04a0  ! 4834: STDA_R	stda	%r15, [%r20 + %r0] 0x25
	mov	0x58, %r17
	.word 0x87802073  ! 4836: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0f5c4a0  ! 4837: STXA_R	stxa	%r8, [%r23 + %r0] 0x25
	.word 0xd0f72000  ! 4838: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 4839: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaaf8e40  ! 4840: STBA_R	stba	%r13, [%r30 + %r0] 0x72
	.word 0x87802020  ! 4841: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4842: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab4e000  ! 4843: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xd0dc0400  ! 4844: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0x87802074  ! 4845: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b7e000  ! 4846: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0xd0f72000  ! 4847: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xdcb44400  ! 4848: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0xdcd76000  ! 4849: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	mov	0x30, %r24
	.word 0xdcf7a000  ! 4851: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 4852: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcace000  ! 4853: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0xdc846000  ! 4854: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	mov	0x40, %r19
	.word 0xdcd4e000  ! 4856: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	.word 0xd6de09e0  ! 4857: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r11
	.word 0xdabc4400  ! 4858: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	mov	0x50, %r19
	.word 0xdaa4a000  ! 4860: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0x8780204f  ! 4862: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a609e0  ! 4863: STWA_R	stwa	%r12, [%r24 + %r0] 0x4f
	.word 0xd0874e80  ! 4864: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r8
	.word 0x87802072  ! 4865: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda9c4400  ! 4866: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	mov	0x40, %r24
	.word 0xdad72000  ! 4868: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0xd0d544a0  ! 4869: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r8
	.word 0xdacc8400  ! 4870: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r13
	.word 0xdab7a000  ! 4871: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xd0a48400  ! 4872: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0xd6d78e40  ! 4873: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r11
	.word 0x87802020  ! 4874: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebf8e40  ! 4875: STDA_R	stda	%r15, [%r30 + %r0] 0x72
	.word 0xdeb42000  ! 4876: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	mov	0x28, %r25
	mov	0x3e0, %r22
	.word 0xd8bd44a0  ! 4879: STDA_R	stda	%r12, [%r21 + %r0] 0x25
	.word 0xd89c6000  ! 4880: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r12
	.word 0xd8a46000  ! 4881: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8cc2000  ! 4882: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r12
	.word 0xd8f42000  ! 4883: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8bc6000  ! 4884: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 4885: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d40400  ! 4886: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	.word 0xd2af0e60  ! 4887: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	.word 0xd0c44400  ! 4888: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r8
	.word 0xd0946000  ! 4889: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0xd0dce000  ! 4890: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r8
	.word 0xd0f4a000  ! 4891: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 4892: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdedd84a0  ! 4893: LDXA_R	ldxa	[%r22, %r0] 0x25, %r15
	mov	0x7d8, %r21
	.word 0xdebfa000  ! 4895: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xdecfa000  ! 4896: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	ta	T_CHANGE_PRIV	! macro
	.word 0xd89cc400  ! 4898: LDDA_R	ldda	[%r19, %r0] 0x20, %r12
	mov	0x0, %r17
	mov	0x20, %r27
	.word 0xd8afe000  ! 4901: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd897e000  ! 4902: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	mov	0x7e8, %r20
	mov	0x18, %r25
	.word 0xd8bf2000  ! 4905: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd8cfe000  ! 4906: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8d7e000  ! 4907: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0xd4a44400  ! 4908: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xd4a76000  ! 4909: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4df6000  ! 4910: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0x87802020  ! 4911: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4df0e40  ! 4912: LDXA_R	ldxa	[%r28, %r0] 0x72, %r10
	.word 0xd6bf4e60  ! 4913: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	.word 0xd4f584a0  ! 4914: STXA_R	stxa	%r10, [%r22 + %r0] 0x25
	.word 0x87802020  ! 4915: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4970e40  ! 4916: LDUHA_R	lduha	[%r28, %r0] 0x72, %r10
	.word 0xd49ca000  ! 4917: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd49ca000  ! 4918: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xde9fce80  ! 4919: LDDA_R	ldda	[%r31, %r0] 0x74, %r15
	.word 0xde9c2000  ! 4920: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xdec46000  ! 4921: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	.word 0xdeb42000  ! 4922: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0xdea42000  ! 4923: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	mov	0x68, %r25
	mov	0x78, %r24
	.word 0x87802073  ! 4926: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2bf0e80  ! 4927: STDA_R	stda	%r9, [%r28 + %r0] 0x74
	.word 0xd2bf2000  ! 4928: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd2f7e000  ! 4929: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 4930: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2f56000  ! 4932: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	.word 0xd6adc4a0  ! 4933: STBA_R	stba	%r11, [%r23 + %r0] 0x25
	.word 0x87802074  ! 4934: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4935: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r17
	.word 0x87802072  ! 4937: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6cf6000  ! 4938: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd68dc4a0  ! 4939: LDUBA_R	lduba	[%r23, %r0] 0x25, %r11
	mov	0x28, %r18
	.word 0xd0bf8e40  ! 4941: STDA_R	stda	%r8, [%r30 + %r0] 0x72
	.word 0xda940400  ! 4942: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	.word 0xdab7a000  ! 4943: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdcd70e40  ! 4944: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r14
	mov	0x3d0, %r21
	.word 0xd6aec9e0  ! 4946: STBA_R	stba	%r11, [%r27 + %r0] 0x4f
	.word 0xd0b5c4a0  ! 4947: STHA_R	stha	%r8, [%r23 + %r0] 0x25
	.word 0x87802073  ! 4948: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2acc400  ! 4949: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0xdcd78e60  ! 4950: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r14
	.word 0xdcc76000  ! 4951: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	mov	0x3d8, %r20
	.word 0xd0ac8400  ! 4953: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xd0f76000  ! 4954: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd4bc4400  ! 4955: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0xdabfce60  ! 4956: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	.word 0xdabfe000  ! 4957: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 4958: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda872000  ! 4959: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0x87802074  ! 4960: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabe09e0  ! 4961: STDA_R	stda	%r13, [%r24 + %r0] 0x4f
	mov	0x70, %r25
	.word 0xdabfe000  ! 4963: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 4964: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c0, %r22
	mov	0x60, %r16
	mov	0x20, %r25
	.word 0xda96a000  ! 4968: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r13
	.word 0xd8ce09e0  ! 4969: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r12
	.word 0xd8be2000  ! 4970: STDA_I	stda	%r12, [%r24 + 0x0000] %asi
	.word 0x87802025  ! 4971: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdedfce60  ! 4972: LDXA_R	ldxa	[%r31, %r0] 0x73, %r15
	.word 0xdebc4400  ! 4973: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0xded5e000  ! 4974: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r15
	.word 0xdc8f4e40  ! 4975: LDUBA_R	lduba	[%r29, %r0] 0x72, %r14
	mov	0x58, %r24
	mov	0x50, %r17
	mov	0x7c0, %r22
	mov	0x68, %r19
	mov	0x50, %r19
	mov	0x30, %r18
	.word 0xd8cf4e40  ! 4982: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r12
	.word 0x87802025  ! 4983: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8cc4400  ! 4984: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r12
	mov	0x7d0, %r21
	.word 0x87802020  ! 4986: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cf0e80  ! 4987: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r8
	.word 0xd0d46000  ! 4988: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r8
	.word 0xd2a7ce60  ! 4989: STWA_R	stwa	%r9, [%r31 + %r0] 0x73
	.word 0xd8cfce60  ! 4990: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r12
	.word 0xd8a46000  ! 4991: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xd687ce40  ! 4992: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r11
	mov	0x7e8, %r20
	.word 0xded689e0  ! 4994: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r15
	.word 0x87802072  ! 4995: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabf4e60  ! 4996: STDA_R	stda	%r13, [%r29 + %r0] 0x73
	.word 0xd897ce40  ! 4997: LDUHA_R	lduha	[%r31, %r0] 0x72, %r12
	mov	0x78, %r18
	mov	0x38, %r24
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_3:
	.word 0xd0b72000  ! 1: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd0cfa000  ! 2: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0xd08fa000  ! 3: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0xdc85c4a0  ! 4: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r14
	mov	0x78, %r26
	.word 0x87802074  ! 6: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 7: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb4c400  ! 8: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xd4af6000  ! 9: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	mov	0x7e0, %r21
	.word 0xd4876000  ! 11: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2bc0400  ! 13: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0x87802074  ! 14: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e0, %r21
	.word 0x87802073  ! 16: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4a4e000  ! 17: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 18: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4bfe000  ! 19: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd4b7a000  ! 20: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd4cfa000  ! 21: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	mov	0x40, %r19
	.word 0xd4bfa000  ! 23: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd4af6000  ! 24: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd49f2000  ! 25: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd4df2000  ! 26: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0x87802025  ! 27: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4a7e000  ! 28: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd2ce89e0  ! 29: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r9
	.word 0xdaafe000  ! 30: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xdab7a000  ! 31: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xded48400  ! 32: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	.word 0x87802020  ! 33: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 34: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 35: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r18
	mov	0x30, %r26
	mov	0x3e0, %r20
	mov	0x60, %r24
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2a42000  ! 41: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 42: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bfe000  ! 43: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd2df2000  ! 44: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2bf6000  ! 45: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd4a609e0  ! 46: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	.word 0xd2d76000  ! 47: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0xd2df6000  ! 48: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0xd0d70e80  ! 49: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r8
	mov	0x58, %r18
	.word 0xd0af8e40  ! 51: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0x87802073  ! 52: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b74e80  ! 53: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	.word 0xdaf649e0  ! 54: STXA_R	stxa	%r13, [%r25 + %r0] 0x4f
	mov	0x3e8, %r22
	.word 0xdacc6000  ! 56: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	.word 0xd4bd04a0  ! 57: STDA_R	stda	%r10, [%r20 + %r0] 0x25
	.word 0xd0c544a0  ! 58: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r8
	mov	0x28, %r24
	.word 0xd6978e40  ! 60: LDUHA_R	lduha	[%r30, %r0] 0x72, %r11
	.word 0x8780204f  ! 61: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4cf0e60  ! 62: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r10
	.word 0xdeb70e60  ! 63: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	.word 0xd0d544a0  ! 64: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r8
	.word 0xd8874e80  ! 65: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r12
	.word 0x87802020  ! 66: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 67: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccfe000  ! 68: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xd2874e80  ! 69: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r9
	.word 0xd0d7e000  ! 70: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	mov	0x7d8, %r21
	.word 0xdca74e40  ! 72: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	.word 0xd29c8400  ! 73: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	.word 0xdecfa000  ! 74: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xd8f70e60  ! 75: STXA_R	stxa	%r12, [%r28 + %r0] 0x73
	.word 0xdcf7e000  ! 76: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcafa000  ! 77: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xd6b5c4a0  ! 78: STHA_R	stha	%r11, [%r23 + %r0] 0x25
	mov	0x3f0, %r22
	mov	0x50, %r16
	.word 0xd6afa000  ! 81: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xdc9f4e80  ! 82: LDDA_R	ldda	[%r29, %r0] 0x74, %r14
	.word 0x87802074  ! 83: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde876000  ! 84: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xdef7a000  ! 85: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdebfe000  ! 86: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	mov	0x8, %r19
	.word 0xdef7a000  ! 88: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 89: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa544a0  ! 90: STWA_R	stwa	%r13, [%r21 + %r0] 0x25
	.word 0xd6dfce80  ! 91: LDXA_R	ldxa	[%r31, %r0] 0x74, %r11
	.word 0x87802020  ! 92: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc8c0400  ! 93: LDUBA_R	lduba	[%r16, %r0] 0x20, %r14
	.word 0xdad6e000  ! 94: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r13
	.word 0xd2cc8400  ! 95: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0xd0bee000  ! 96: STDA_I	stda	%r8, [%r27 + 0x0000] %asi
	.word 0xd0d66000  ! 97: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r8
	mov	0x60, %r18
	mov	0x7f0, %r22
	.word 0xd49d44a0  ! 100: LDDA_R	ldda	[%r21, %r0] 0x25, %r10
	.word 0xdc8c8400  ! 101: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0xdaf689e0  ! 102: STXA_R	stxa	%r13, [%r26 + %r0] 0x4f
	.word 0xd4b5c4a0  ! 103: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	.word 0xd2970e60  ! 104: LDUHA_R	lduha	[%r28, %r0] 0x73, %r9
	.word 0xd2840400  ! 105: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r9
	.word 0x87802020  ! 106: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca544a0  ! 107: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	mov	0x7e0, %r20
	.word 0xdebfa000  ! 109: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xd2cc8400  ! 110: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	mov	0x3f8, %r23
	.word 0x87802020  ! 112: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f72000  ! 113: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 114: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc9c4400  ! 115: LDDA_R	ldda	[%r17, %r0] 0x20, %r14
	.word 0xd8846000  ! 116: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	.word 0xd2df4e60  ! 117: LDXA_R	ldxa	[%r29, %r0] 0x73, %r9
	.word 0xdc946000  ! 118: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r14
	.word 0xd69dc4a0  ! 119: LDDA_R	ldda	[%r23, %r0] 0x25, %r11
	.word 0xdc840400  ! 120: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	.word 0x8780204f  ! 121: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdccc6000  ! 122: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	.word 0xd6be89e0  ! 123: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	.word 0x8780204f  ! 124: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde9ca000  ! 125: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	.word 0xde84e000  ! 126: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	.word 0xdebc6000  ! 127: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	mov	0x7c8, %r23
	.word 0x87802020  ! 129: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 130: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f0, %r20
	.word 0xd4c70e60  ! 132: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r10
	.word 0xdaafe000  ! 133: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 134: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f8, %r22
	.word 0xdaafe000  ! 136: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 137: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda972000  ! 138: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	mov	0x40, %r24
	.word 0x87802025  ! 140: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8de000  ! 141: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r13
	.word 0xdaad2000  ! 142: STBA_I	stba	%r13, [%r20 + 0x0000] %asi
	.word 0xdaa5a000  ! 143: STWA_I	stwa	%r13, [%r22 + 0x0000] %asi
	mov	0x3f8, %r22
	.word 0xda9de000  ! 145: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r13
	.word 0xd2ac8400  ! 146: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xd88fce40  ! 147: LDUBA_R	lduba	[%r31, %r0] 0x72, %r12
	.word 0xd6a52000  ! 148: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	.word 0xd8f70e40  ! 149: STXA_R	stxa	%r12, [%r28 + %r0] 0x72
	.word 0xdcbf8e80  ! 150: STDA_R	stda	%r14, [%r30 + %r0] 0x74
	mov	0x7c8, %r20
	.word 0xdca4c400  ! 152: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xd4a7ce60  ! 153: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	mov	0x3e0, %r21
	.word 0xdeac4400  ! 155: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0xd2ddc4a0  ! 156: LDXA_R	ldxa	[%r23, %r0] 0x25, %r9
	.word 0xd6f52000  ! 157: STXA_I	stxa	%r11, [%r20 + 0x0000] %asi
	.word 0xd6ad6000  ! 158: STBA_I	stba	%r11, [%r21 + 0x0000] %asi
	mov	0x10, %r25
	.word 0xdea78e40  ! 160: STWA_R	stwa	%r15, [%r30 + %r0] 0x72
	mov	0x40, %r17
	.word 0x87802025  ! 162: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bce000  ! 163: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd6940400  ! 164: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	.word 0xd4d74e60  ! 165: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r10
	mov	0x20, %r25
	mov	0x78, %r19
	mov	0x8, %r19
	.word 0x8780204f  ! 169: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r25
	mov	0x18, %r24
	.word 0xd2a4c400  ! 172: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0x87802074  ! 173: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r18
	.word 0xd08c8400  ! 175: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0xdeb649e0  ! 176: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	mov	0x7f8, %r23
	.word 0x87802074  ! 178: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 179: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3f8, %r20
	.word 0xd0874e40  ! 181: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r8
	.word 0xda84c400  ! 182: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r13
	mov	0x7c0, %r20
	.word 0x8780204f  ! 184: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a7ce80  ! 185: STWA_R	stwa	%r10, [%r31 + %r0] 0x74
	.word 0xdcb6c9e0  ! 186: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	.word 0xd0c7ce80  ! 187: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r8
	.word 0xdea504a0  ! 188: STWA_R	stwa	%r15, [%r20 + %r0] 0x25
	.word 0xd0cc6000  ! 189: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	.word 0x87802020  ! 190: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 191: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xded4c400  ! 192: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r15
	.word 0x87802074  ! 193: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c0, %r21
	.word 0xd0942000  ! 195: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r8
	.word 0x87802073  ! 196: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4948400  ! 197: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	mov	0x48, %r26
	.word 0x87802074  ! 199: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2b689e0  ! 201: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	.word 0xdcf46000  ! 202: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdc942000  ! 203: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	.word 0xda9cc400  ! 204: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	.word 0xdad4a000  ! 205: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0xdabc2000  ! 206: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xdab46000  ! 207: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0xdaa4a000  ! 208: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xd2cc0400  ! 209: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r9
	.word 0xd0dfce80  ! 210: LDXA_R	ldxa	[%r31, %r0] 0x74, %r8
	mov	0x58, %r25
	.word 0x8780204f  ! 212: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc9da000  ! 213: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r14
	.word 0xdccd2000  ! 214: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r14
	mov	0x78, %r17
	.word 0xd6bf8e40  ! 216: STDA_R	stda	%r11, [%r30 + %r0] 0x72
	.word 0x87802020  ! 217: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdec649e0  ! 218: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r15
	.word 0xd6d48400  ! 219: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	mov	0x3e8, %r21
	.word 0xd0d78e80  ! 221: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r8
	.word 0xdac72000  ! 222: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0x87802072  ! 223: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0cfce40  ! 224: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r8
	.word 0xd6bce000  ! 225: STDA_I	stda	%r11, [%r19 + 0x0000] %asi
	mov	0x0, %r24
	.word 0x87802025  ! 227: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6af2000  ! 228: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd6bf2000  ! 229: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd69544a0  ! 230: LDUHA_R	lduha	[%r21, %r0] 0x25, %r11
	mov	0x8, %r25
	mov	0x3c0, %r22
	.word 0xd4de89e0  ! 233: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r10
	mov	0x40, %r16
	.word 0x87802074  ! 235: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b76000  ! 236: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 237: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf40400  ! 238: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 239: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeb7a000  ! 240: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xd4d7ce60  ! 241: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r10
	.word 0x87802020  ! 242: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde84c400  ! 243: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0xdab78e40  ! 244: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	mov	0x20, %r26
	.word 0x87802074  ! 246: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc9cc400  ! 247: LDDA_R	ldda	[%r19, %r0] 0x20, %r14
	.word 0xd0f40400  ! 248: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xdc972000  ! 249: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	mov	0x0, %r25
	.word 0xdcdf2000  ! 251: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdca76000  ! 252: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcbf6000  ! 253: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdc872000  ! 254: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xdc8f2000  ! 255: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0x87802020  ! 256: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 257: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r21
	.word 0xdc9ec9e0  ! 259: LDDA_R	ldda	[%r27, %r0] 0x4f, %r14
	.word 0xd0c4a000  ! 260: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	mov	0x18, %r16
	.word 0xd4b6c9e0  ! 262: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0xd09cc400  ! 263: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	mov	0x78, %r16
	.word 0xdebc6000  ! 265: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xd6a74e60  ! 266: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	mov	0x8, %r18
	mov	0x7c0, %r22
	.word 0xdabc8400  ! 269: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	mov	0x50, %r17
	.word 0xdcdec9e0  ! 271: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r14
	mov	0x3c8, %r22
	.word 0xdabca000  ! 273: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdab4e000  ! 274: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 275: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6cf8e60  ! 276: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r11
	.word 0xdeb52000  ! 277: STHA_I	stha	%r15, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 278: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde962000  ! 279: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r15
	.word 0xda9dc4a0  ! 280: LDDA_R	ldda	[%r23, %r0] 0x25, %r13
	.word 0x87802074  ! 281: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b78e80  ! 282: STHA_R	stha	%r9, [%r30 + %r0] 0x74
	.word 0xdcdca000  ! 283: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xdcaf4e60  ! 284: STBA_R	stba	%r14, [%r29 + %r0] 0x73
	.word 0xda8f0e80  ! 285: LDUBA_R	lduba	[%r28, %r0] 0x74, %r13
	.word 0xd4f504a0  ! 286: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0xdef46000  ! 287: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xd8970e80  ! 288: LDUHA_R	lduha	[%r28, %r0] 0x74, %r12
	.word 0x87802073  ! 289: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6cc4400  ! 290: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	.word 0xd6ac4400  ! 291: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0x87802074  ! 292: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r17
	.word 0xda978e60  ! 294: LDUHA_R	lduha	[%r30, %r0] 0x73, %r13
	.word 0xd4f504a0  ! 295: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0x87802074  ! 296: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdccf2000  ! 297: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xd6c40400  ! 298: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r11
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7f0, %r20
	.word 0xd2c7ce40  ! 301: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r9
	.word 0xdcdf6000  ! 302: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xdc8fe000  ! 303: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xdcafe000  ! 304: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xd4c70e80  ! 305: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r10
	mov	0x3d8, %r22
	mov	0x50, %r17
	.word 0x8780204f  ! 308: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r19
	.word 0xd0be49e0  ! 310: STDA_R	stda	%r8, [%r25 + %r0] 0x4f
	.word 0xdacc0400  ! 311: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r13
	.word 0x8780204f  ! 312: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd89cc400  ! 313: LDDA_R	ldda	[%r19, %r0] 0x20, %r12
	mov	0x7c8, %r23
	.word 0xdece6000  ! 315: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r15
	.word 0xdec6a000  ! 316: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r15
	mov	0x60, %r25
	mov	0x28, %r16
	.word 0x87802073  ! 319: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r24
	mov	0x7e8, %r22
	mov	0x38, %r27
	mov	0x8, %r19
	mov	0x3c0, %r21
	.word 0xdeb7e000  ! 325: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xde848400  ! 326: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	mov	0x0, %r18
	mov	0x48, %r26
	.word 0x87802074  ! 329: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e0, %r22
	.word 0xda95c4a0  ! 331: LDUHA_R	lduha	[%r23, %r0] 0x25, %r13
	.word 0xd6a689e0  ! 332: STWA_R	stwa	%r11, [%r26 + %r0] 0x4f
	.word 0xdca4c400  ! 333: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	mov	0x58, %r25
	.word 0xd2f44400  ! 335: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	mov	0x3f0, %r21
	.word 0x8780204f  ! 337: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xded544a0  ! 338: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r15
	mov	0x0, %r25
	mov	0x60, %r27
	mov	0x7c0, %r23
	.word 0x8780204f  ! 342: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8842000  ! 343: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	.word 0xd8b46000  ! 344: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0xd4ae09e0  ! 345: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 346: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r24
	.word 0x87802074  ! 348: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d0, %r23
	mov	0x70, %r25
	.word 0xd28c4400  ! 351: LDUBA_R	lduba	[%r17, %r0] 0x20, %r9
	.word 0xdebea000  ! 352: STDA_I	stda	%r15, [%r26 + 0x0000] %asi
	mov	0x28, %r16
	.word 0xdeae2000  ! 354: STBA_I	stba	%r15, [%r24 + 0x0000] %asi
	.word 0xd2848400  ! 355: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r9
	.word 0xdecea000  ! 356: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r15
	mov	0x30, %r16
	.word 0xdece2000  ! 358: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r15
	.word 0xde9e2000  ! 359: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r15
	.word 0xd4ccc400  ! 360: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0x87802025  ! 361: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8a70e40  ! 362: STWA_R	stwa	%r12, [%r28 + %r0] 0x72
	.word 0xda85a000  ! 363: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r13
	mov	0x50, %r19
	.word 0xdccc0400  ! 365: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r14
	.word 0xd4f44400  ! 366: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0xd4d70e40  ! 367: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r10
	.word 0xd49d84a0  ! 368: LDDA_R	ldda	[%r22, %r0] 0x25, %r10
	.word 0x8780204f  ! 369: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf4e000  ! 370: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0xd0878e40  ! 372: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r8
	.word 0xde94a000  ! 373: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0xdef46000  ! 374: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xdea42000  ! 375: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x60, %r19
	.word 0xdec4a000  ! 378: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xd8c74e40  ! 379: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r12
	.word 0xd88c6000  ! 380: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	mov	0x3f8, %r20
	.word 0xd8bc6000  ! 382: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0xd8d4a000  ! 383: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xd8942000  ! 384: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r12
	.word 0xd8a4e000  ! 385: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	mov	0x8, %r19
	.word 0xd6d70e80  ! 387: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r11
	.word 0xd4f42000  ! 388: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd4bc2000  ! 389: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0xd4a4e000  ! 390: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xd4bce000  ! 391: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0xdcf689e0  ! 392: STXA_R	stxa	%r14, [%r26 + %r0] 0x4f
	.word 0xd8bc2000  ! 393: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd89c2000  ! 395: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	.word 0xd69f0e80  ! 396: LDDA_R	ldda	[%r28, %r0] 0x74, %r11
	.word 0xdc8fce40  ! 397: LDUBA_R	lduba	[%r31, %r0] 0x72, %r14
	.word 0x87802020  ! 398: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeaf2000  ! 399: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 400: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc8fce80  ! 401: LDUBA_R	lduba	[%r31, %r0] 0x74, %r14
	.word 0xd6af6000  ! 402: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd6af6000  ! 403: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x7e0, %r21
	mov	0x68, %r16
	mov	0x78, %r24
	.word 0xdeadc4a0  ! 407: STBA_R	stba	%r15, [%r23 + %r0] 0x25
	.word 0xd8f7a000  ! 408: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8c7a000  ! 409: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xdcbc8400  ! 410: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0x87802025  ! 411: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f0, %r20
	.word 0xd2876000  ! 413: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	mov	0x38, %r19
	.word 0xdea609e0  ! 415: STWA_R	stwa	%r15, [%r24 + %r0] 0x4f
	mov	0x3e8, %r21
	.word 0xd8cdc4a0  ! 417: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r12
	.word 0xd6b76000  ! 418: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd2f7ce80  ! 419: STXA_R	stxa	%r9, [%r31 + %r0] 0x74
	.word 0xd8cfe000  ! 420: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	mov	0x7c0, %r21
	mov	0x40, %r16
	.word 0xd8cf6000  ! 423: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0xd0c4c400  ! 424: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	mov	0x10, %r18
	mov	0x8, %r19
	mov	0x3f8, %r23
	mov	0x3c0, %r22
	mov	0x38, %r24
	mov	0x48, %r27
	.word 0xd48c4400  ! 431: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0xd0bcc400  ! 432: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	mov	0x50, %r19
	.word 0xd49f8e40  ! 434: LDDA_R	ldda	[%r30, %r0] 0x72, %r10
	.word 0xdca609e0  ! 435: STWA_R	stwa	%r14, [%r24 + %r0] 0x4f
	.word 0xda8f2000  ! 436: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xdad72000  ! 437: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0xd0f649e0  ! 438: STXA_R	stxa	%r8, [%r25 + %r0] 0x4f
	.word 0xd2a72000  ! 439: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0xd2afe000  ! 440: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	mov	0x18, %r19
	.word 0xd29f6000  ! 442: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	mov	0x7d0, %r22
	.word 0x87802025  ! 444: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd29c2000  ! 445: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd8b504a0  ! 447: STHA_R	stha	%r12, [%r20 + %r0] 0x25
	mov	0x20, %r17
	.word 0x87802074  ! 449: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd89544a0  ! 450: LDUHA_R	lduha	[%r21, %r0] 0x25, %r12
	.word 0xd28c0400  ! 451: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	mov	0x3c8, %r20
	mov	0x10, %r26
	.word 0xd4c76000  ! 454: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	mov	0x3e8, %r20
	.word 0xd8bf4e80  ! 456: STDA_R	stda	%r12, [%r29 + %r0] 0x74
	.word 0xdcbfa000  ! 457: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 458: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0940400  ! 459: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	.word 0x87802020  ! 460: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9ce000  ! 461: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0xde8ce000  ! 462: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	mov	0x3c8, %r21
	.word 0x8780204f  ! 464: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea4a000  ! 465: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xdecca000  ! 466: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	.word 0xd6878e40  ! 467: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r11
	.word 0xda970e60  ! 468: LDUHA_R	lduha	[%r28, %r0] 0x73, %r13
	.word 0x87802020  ! 469: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a40400  ! 470: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0x87802020  ! 471: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69f6000  ! 472: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	.word 0xd4bc4400  ! 473: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0xd497a000  ! 474: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0xd4f7a000  ! 475: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	mov	0x78, %r17
	mov	0x78, %r24
	.word 0xdaa78e80  ! 478: STWA_R	stwa	%r13, [%r30 + %r0] 0x74
	mov	0x7e8, %r22
	mov	0x20, %r17
	mov	0x7c8, %r23
	mov	0x3d8, %r23
	.word 0xd6c72000  ! 483: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6cf2000  ! 484: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0x87802025  ! 485: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r17
	.word 0xd6ce6000  ! 487: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r11
	.word 0xd2a74e80  ! 488: STWA_R	stwa	%r9, [%r29 + %r0] 0x74
	.word 0xdcbc4400  ! 489: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	mov	0x60, %r25
	.word 0xdcbe2000  ! 491: STDA_I	stda	%r14, [%r24 + 0x0000] %asi
	.word 0xdccd04a0  ! 492: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r14
	.word 0x87802020  ! 493: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc87e000  ! 494: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcd7e000  ! 495: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	mov	0x3f0, %r22
	mov	0x18, %r18
	.word 0xdc9fe000  ! 498: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	mov	0x7f0, %r21
	.word 0xdead44a0  ! 500: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	.word 0xd6b78e60  ! 501: STHA_R	stha	%r11, [%r30 + %r0] 0x73
	.word 0x87802073  ! 502: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b504a0  ! 503: STHA_R	stha	%r9, [%r20 + %r0] 0x25
	.word 0xd29f8e40  ! 504: LDDA_R	ldda	[%r30, %r0] 0x72, %r9
	.word 0xd4f504a0  ! 505: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0xd4df2000  ! 506: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0xd68f8e80  ! 507: LDUBA_R	lduba	[%r30, %r0] 0x74, %r11
	mov	0x3d0, %r20
	.word 0xd8d7e000  ! 509: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0xd8bf6000  ! 510: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 511: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d8, %r22
	.word 0xd88ca000  ! 513: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	.word 0x87802020  ! 514: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r27
	.word 0xd2ad84a0  ! 516: STBA_R	stba	%r9, [%r22 + %r0] 0x25
	mov	0x7f8, %r21
	mov	0x68, %r26
	.word 0xdcbf8e60  ! 519: STDA_R	stda	%r14, [%r30 + %r0] 0x73
	.word 0xd0ad6000  ! 520: STBA_I	stba	%r8, [%r21 + 0x0000] %asi
	.word 0x87802073  ! 521: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0876000  ! 522: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd4cfce80  ! 524: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r10
	.word 0xdcf6c9e0  ! 525: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	.word 0xd6bf2000  ! 526: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	mov	0x0, %r25
	mov	0x58, %r18
	mov	0x78, %r24
	.word 0xd6cc4400  ! 530: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	.word 0xdaf7a000  ! 531: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdadfce40  ! 532: LDXA_R	ldxa	[%r31, %r0] 0x72, %r13
	mov	0x58, %r16
	.word 0xd2cfa000  ! 534: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	mov	0x3d0, %r21
	mov	0x7c8, %r21
	.word 0xdcf6c9e0  ! 537: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	.word 0xd4b74e60  ! 538: STHA_R	stha	%r10, [%r29 + %r0] 0x73
	.word 0xd0cd84a0  ! 539: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r8
	.word 0xd8cf6000  ! 540: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x50, %r17
	.word 0xd88fa000  ! 543: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0xdaaf8e40  ! 544: STBA_R	stba	%r13, [%r30 + %r0] 0x72
	.word 0xdec7ce80  ! 545: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r15
	.word 0xdc9689e0  ! 546: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r14
	.word 0xde97ce60  ! 547: LDUHA_R	lduha	[%r31, %r0] 0x73, %r15
	.word 0xd29f6000  ! 548: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xd2dfe000  ! 549: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0xd0c44400  ! 550: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r8
	mov	0x58, %r24
	.word 0xd8f74e60  ! 552: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	.word 0xd6a584a0  ! 553: STWA_R	stwa	%r11, [%r22 + %r0] 0x25
	.word 0xd8af8e60  ! 554: STBA_R	stba	%r12, [%r30 + %r0] 0x73
	.word 0x87802020  ! 555: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cf4e40  ! 556: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r10
	.word 0xd2cf8e40  ! 557: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r9
	.word 0xd6bf0e80  ! 558: STDA_R	stda	%r11, [%r28 + %r0] 0x74
	.word 0xdca689e0  ! 559: STWA_R	stwa	%r14, [%r26 + %r0] 0x4f
	mov	0x78, %r24
	.word 0xd8aea000  ! 561: STBA_I	stba	%r12, [%r26 + 0x0000] %asi
	.word 0xd2dfce40  ! 562: LDXA_R	ldxa	[%r31, %r0] 0x72, %r9
	.word 0xd2f6e000  ! 563: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	.word 0xdcd649e0  ! 564: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r14
	mov	0x48, %r18
	.word 0xd8cd04a0  ! 566: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r12
	.word 0xd6848400  ! 567: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	.word 0xd0962000  ! 568: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r8
	.word 0xd08544a0  ! 569: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r8
	.word 0xd6970e80  ! 570: LDUHA_R	lduha	[%r28, %r0] 0x74, %r11
	mov	0x18, %r25
	.word 0x87802074  ! 572: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 573: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r16
	.word 0xd2bd2000  ! 575: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 576: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d42000  ! 577: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2b42000  ! 578: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0xd4d74e80  ! 580: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r10
	.word 0xdea4e000  ! 581: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xd4f40400  ! 582: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xd4f4c400  ! 583: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0x87802025  ! 584: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd49609e0  ! 585: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r10
	mov	0x70, %r16
	.word 0xd6d7ce60  ! 587: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r11
	mov	0x0, %r18
	.word 0xdec74e60  ! 589: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r15
	mov	0x3c8, %r21
	.word 0x87802020  ! 591: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r25
	.word 0xd8a76000  ! 593: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	mov	0x50, %r19
	mov	0x50, %r18
	.word 0x87802020  ! 596: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab70e40  ! 597: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	.word 0xd2afe000  ! 598: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	mov	0x30, %r27
	.word 0xd2c7a000  ! 600: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	mov	0x68, %r27
	.word 0xd2bf2000  ! 602: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd2f7e000  ! 603: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 604: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6c7ce60  ! 605: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r11
	mov	0x20, %r16
	.word 0xd6c46000  ! 607: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r11
	mov	0x3f8, %r23
	.word 0xd6ace000  ! 609: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0xd2bf0e40  ! 610: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	.word 0xda8f0e60  ! 611: LDUBA_R	lduba	[%r28, %r0] 0x73, %r13
	.word 0xd89d04a0  ! 612: LDDA_R	ldda	[%r20, %r0] 0x25, %r12
	mov	0x78, %r19
	.word 0xd8dc8400  ! 614: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xd2c4e000  ! 615: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	mov	0x18, %r17
	.word 0xd2cc2000  ! 617: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r9
	.word 0x87802073  ! 618: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf7ce60  ! 619: STXA_R	stxa	%r14, [%r31 + %r0] 0x73
	.word 0xdea5e000  ! 620: STWA_I	stwa	%r15, [%r23 + 0x0000] %asi
	.word 0xdead2000  ! 621: STBA_I	stba	%r15, [%r20 + 0x0000] %asi
	.word 0xda9cc400  ! 622: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	.word 0xd88584a0  ! 623: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r12
	.word 0xd4c70e80  ! 624: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r10
	mov	0x68, %r17
	.word 0xdea7ce40  ! 626: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	.word 0xd0a5a000  ! 627: STWA_I	stwa	%r8, [%r22 + 0x0000] %asi
	.word 0xd0bda000  ! 628: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	.word 0xd08544a0  ! 629: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r8
	mov	0x10, %r16
	.word 0xd28d2000  ! 631: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r9
	mov	0x48, %r19
	mov	0x3e8, %r20
	.word 0x87802073  ! 634: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 635: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd297a000  ! 636: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	.word 0x87802074  ! 637: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd296a000  ! 638: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r9
	mov	0x68, %r24
	.word 0xd2c6a000  ! 640: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r9
	.word 0x87802020  ! 641: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2af6000  ! 642: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 643: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeae89e0  ! 644: STBA_R	stba	%r15, [%r26 + %r0] 0x4f
	mov	0x58, %r24
	mov	0x28, %r17
	.word 0xda9fe000  ! 647: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	mov	0x20, %r24
	.word 0xdabfa000  ! 649: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 650: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdadf4e40  ! 651: LDXA_R	ldxa	[%r29, %r0] 0x72, %r13
	.word 0xda8e09e0  ! 652: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r13
	.word 0xdc8c4400  ! 653: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0x87802072  ! 654: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6856000  ! 655: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r11
	.word 0x87802025  ! 656: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd68ea000  ! 657: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r11
	.word 0xd4f70e40  ! 658: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	.word 0xdec544a0  ! 659: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r15
	.word 0xd0d78e60  ! 660: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r8
	mov	0x20, %r17
	.word 0xd8f78e60  ! 662: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	.word 0xd2b78e80  ! 663: STHA_R	stha	%r9, [%r30 + %r0] 0x74
	.word 0xd6866000  ! 664: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r11
	mov	0x78, %r18
	.word 0x8780204f  ! 666: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcb584a0  ! 667: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	mov	0x3c0, %r21
	.word 0xdcaf2000  ! 669: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 670: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4d4c400  ! 671: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0x87802020  ! 672: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ade000  ! 673: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0xd28d2000  ! 674: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r9
	mov	0x0, %r24
	.word 0xd2bd2000  ! 676: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	.word 0xdad4c400  ! 677: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xd28fce40  ! 678: LDUBA_R	lduba	[%r31, %r0] 0x72, %r9
	.word 0xdea5c4a0  ! 679: STWA_R	stwa	%r15, [%r23 + %r0] 0x25
	.word 0xdedd04a0  ! 680: LDXA_R	ldxa	[%r20, %r0] 0x25, %r15
	.word 0xd68cc400  ! 681: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	.word 0xd4b5e000  ! 682: STHA_I	stha	%r10, [%r23 + 0x0000] %asi
	.word 0xd48d6000  ! 683: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r10
	mov	0x30, %r16
	.word 0x8780204f  ! 685: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4874e80  ! 686: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r10
	mov	0x10, %r18
	.word 0xd0844400  ! 688: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r8
	.word 0x87802072  ! 689: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 690: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r26
	.word 0xdeafa000  ! 692: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xd6970e40  ! 693: LDUHA_R	lduha	[%r28, %r0] 0x72, %r11
	.word 0xd0a7e000  ! 694: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	mov	0x50, %r26
	.word 0x87802074  ! 696: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcc544a0  ! 697: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r14
	.word 0xd2948400  ! 698: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	.word 0xdcf76000  ! 699: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xd08c4400  ! 700: LDUBA_R	lduba	[%r17, %r0] 0x20, %r8
	mov	0x3c8, %r23
	.word 0xd2b76000  ! 702: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	mov	0x28, %r18
	mov	0x28, %r16
	.word 0x87802020  ! 705: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bd44a0  ! 706: STDA_R	stda	%r10, [%r21 + %r0] 0x25
	mov	0x10, %r19
	.word 0xdca6c9e0  ! 708: STWA_R	stwa	%r14, [%r27 + %r0] 0x4f
	.word 0xd0b70e40  ! 709: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	.word 0xd6cce000  ! 710: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r11
	.word 0x87802072  ! 711: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda9f8e40  ! 712: LDDA_R	ldda	[%r30, %r0] 0x72, %r13
	.word 0xdc8da000  ! 713: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r14
	.word 0xdc95a000  ! 714: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r14
	.word 0xdadc0400  ! 715: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	.word 0xdc9c8400  ! 716: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0xd8f4c400  ! 717: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	mov	0x50, %r25
	.word 0xdcadc4a0  ! 719: STBA_R	stba	%r14, [%r23 + %r0] 0x25
	.word 0xd8c649e0  ! 720: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r12
	.word 0xdaade000  ! 721: STBA_I	stba	%r13, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 722: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2dec9e0  ! 723: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r9
	.word 0xdca46000  ! 724: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	mov	0x3c8, %r20
	.word 0x87802020  ! 726: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded48400  ! 727: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	.word 0xd6a7a000  ! 728: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6c7e000  ! 729: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	mov	0x7f0, %r20
	.word 0xd697e000  ! 731: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0xd6b76000  ! 732: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	mov	0x3f0, %r22
	mov	0x7d0, %r20
	.word 0xd6d72000  ! 735: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r11
	mov	0x3f8, %r20
	.word 0xda8c8400  ! 737: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	.word 0xdcafe000  ! 738: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xd6af4e60  ! 739: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	mov	0x7f8, %r21
	.word 0xdc8fe000  ! 741: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xdca7e000  ! 742: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdccf6000  ! 743: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcaf6000  ! 744: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdcdfe000  ! 745: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcbf6000  ! 746: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdcb72000  ! 747: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xdaa4c400  ! 748: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	mov	0x0, %r27
	.word 0xd6bf0e60  ! 750: STDA_R	stda	%r11, [%r28 + %r0] 0x73
	.word 0xdacf4e40  ! 751: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r13
	.word 0xd68fce40  ! 752: LDUBA_R	lduba	[%r31, %r0] 0x72, %r11
	.word 0xd2dfa000  ! 753: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	mov	0x58, %r17
	.word 0xd2bf2000  ! 755: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd2bfe000  ! 756: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	mov	0x38, %r16
	mov	0x8, %r18
	.word 0xd297a000  ! 759: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	mov	0x28, %r24
	.word 0xdcd70e80  ! 761: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r14
	.word 0xd28cc400  ! 762: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	.word 0xd6d649e0  ! 763: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r11
	mov	0x3c0, %r22
	.word 0xd4d44400  ! 765: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0x87802020  ! 766: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b76000  ! 767: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xd8a72000  ! 769: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8d609e0  ! 770: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r12
	.word 0xd2bf6000  ! 771: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd29fe000  ! 772: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd2afe000  ! 773: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xdccfce80  ! 774: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r14
	.word 0xd6a7a000  ! 775: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd0a40400  ! 776: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0xd29fa000  ! 777: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	mov	0x3e8, %r23
	mov	0x7e0, %r20
	.word 0xd2c72000  ! 780: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	mov	0x3f0, %r21
	mov	0x48, %r26
	mov	0x3d8, %r21
	.word 0x87802020  ! 784: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b70e80  ! 785: STHA_R	stha	%r12, [%r28 + %r0] 0x74
	.word 0x87802025  ! 786: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8af0e80  ! 787: STBA_R	stba	%r12, [%r28 + %r0] 0x74
	.word 0xd2cc2000  ! 788: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r9
	.word 0xd284a000  ! 789: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	mov	0x78, %r16
	.word 0xdaadc4a0  ! 791: STBA_R	stba	%r13, [%r23 + %r0] 0x25
	.word 0xd0a78e40  ! 792: STWA_R	stwa	%r8, [%r30 + %r0] 0x72
	.word 0x8780204f  ! 793: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd88da000  ! 794: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r12
	.word 0xd8d5e000  ! 795: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r12
	.word 0xd8dd2000  ! 796: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r12
	mov	0x48, %r26
	.word 0x87802025  ! 798: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8ad6000  ! 799: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	.word 0xd8bd2000  ! 800: STDA_I	stda	%r12, [%r20 + 0x0000] %asi
	mov	0x48, %r25
	.word 0xd8ad2000  ! 802: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	.word 0xd69f4e60  ! 803: LDDA_R	ldda	[%r29, %r0] 0x73, %r11
	.word 0xd2bfce60  ! 804: STDA_R	stda	%r9, [%r31 + %r0] 0x73
	mov	0x60, %r24
	.word 0xda8c0400  ! 806: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	.word 0xdaf5a000  ! 807: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xda8d2000  ! 808: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r13
	.word 0xd6ae09e0  ! 809: STBA_R	stba	%r11, [%r24 + %r0] 0x4f
	.word 0xd6bf4e60  ! 810: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	.word 0xdcc5a000  ! 811: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r14
	.word 0xdc856000  ! 812: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r14
	mov	0x70, %r26
	.word 0xdccdc4a0  ! 814: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r14
	.word 0xdef6c9e0  ! 815: STXA_R	stxa	%r15, [%r27 + %r0] 0x4f
	.word 0xd8848400  ! 816: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r12
	.word 0xdc9d2000  ! 817: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r14
	.word 0xdcbd6000  ! 818: STDA_I	stda	%r14, [%r21 + 0x0000] %asi
	.word 0xd0af8e60  ! 819: STBA_R	stba	%r8, [%r30 + %r0] 0x73
	.word 0xd2a5a000  ! 820: STWA_I	stwa	%r9, [%r22 + 0x0000] %asi
	.word 0xdec44400  ! 821: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	mov	0x48, %r25
	.word 0xdca56000  ! 823: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	.word 0x87802072  ! 824: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc976000  ! 825: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	.word 0xdcdf6000  ! 826: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	mov	0x58, %r16
	.word 0x87802074  ! 828: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 829: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r26
	.word 0xdcdf2000  ! 831: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xd0cc0400  ! 832: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xd2a40400  ! 833: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xd0b7a000  ! 834: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 835: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r24
	mov	0x38, %r18
	mov	0x68, %r19
	.word 0x87802020  ! 839: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd096a000  ! 840: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r8
	mov	0x3c0, %r22
	.word 0xd88689e0  ! 842: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r12
	.word 0xd6dea000  ! 843: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r11
	.word 0xd4b70e80  ! 844: STHA_R	stha	%r10, [%r28 + %r0] 0x74
	.word 0xd2d44400  ! 845: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r9
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x7d0, %r20
	mov	0x10, %r26
	mov	0x70, %r27
	.word 0x87802020  ! 850: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08e6000  ! 851: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r8
	.word 0x87802072  ! 852: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0ac2000  ! 853: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xd4bc4400  ! 854: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0xdcdc6000  ! 855: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	.word 0xdca42000  ! 856: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xdc846000  ! 857: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	mov	0x3e8, %r22
	.word 0xd48c0400  ! 859: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	.word 0xd0cd44a0  ! 860: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r8
	.word 0xd8c4e000  ! 861: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	.word 0xdc9689e0  ! 862: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r14
	.word 0xd6b4a000  ! 863: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	mov	0x68, %r18
	.word 0xd68ca000  ! 865: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r11
	.word 0xd4a70e60  ! 866: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	.word 0xdaadc4a0  ! 867: STBA_R	stba	%r13, [%r23 + %r0] 0x25
	mov	0x38, %r26
	.word 0xd0afce80  ! 869: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	.word 0xd8be89e0  ! 870: STDA_R	stda	%r12, [%r26 + %r0] 0x4f
	.word 0x87802072  ! 871: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cf8e40  ! 872: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r10
	.word 0xdacf6000  ! 873: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	mov	0x58, %r16
	.word 0xd68f4e40  ! 875: LDUBA_R	lduba	[%r29, %r0] 0x72, %r11
	mov	0x3e8, %r21
	.word 0x87802073  ! 877: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0afa000  ! 878: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	mov	0x28, %r24
	.word 0xdcc78e80  ! 880: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r14
	.word 0xdcf7e000  ! 881: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xd4ce49e0  ! 883: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r10
	.word 0xd6f7e000  ! 884: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6af4e80  ! 885: STBA_R	stba	%r11, [%r29 + %r0] 0x74
	.word 0xd2b72000  ! 886: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd29fe000  ! 887: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd4cf4e40  ! 888: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r10
	.word 0x87802020  ! 889: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 890: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdab584a0  ! 891: STHA_R	stha	%r13, [%r22 + %r0] 0x25
	.word 0xd0b42000  ! 892: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xd2be09e0  ! 893: STDA_R	stda	%r9, [%r24 + %r0] 0x4f
	mov	0x48, %r26
	.word 0xd0b46000  ! 895: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0xd0cce000  ! 896: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	mov	0x7f8, %r21
	mov	0x3c0, %r23
	.word 0xd0f4e000  ! 899: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0c4e000  ! 900: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	.word 0x87802072  ! 901: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 902: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b74e40  ! 903: STHA_R	stha	%r11, [%r29 + %r0] 0x72
	.word 0xd8d6c9e0  ! 904: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r12
	mov	0x10, %r27
	.word 0xd6b76000  ! 906: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	mov	0x3f0, %r22
	mov	0x18, %r25
	.word 0xd8f504a0  ! 909: STXA_R	stxa	%r12, [%r20 + %r0] 0x25
	.word 0xd28f2000  ! 910: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	mov	0x60, %r18
	.word 0xdabe89e0  ! 912: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	.word 0xdcf504a0  ! 913: STXA_R	stxa	%r14, [%r20 + %r0] 0x25
	mov	0x28, %r17
	.word 0x8780204f  ! 915: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 916: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r18
	.word 0xd2c46000  ! 918: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0x87802072  ! 919: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r19
	.word 0xd2d7e000  ! 921: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xd287a000  ! 922: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2f4c400  ! 923: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	mov	0x40, %r26
	mov	0x18, %r27
	.word 0xd2be09e0  ! 926: STDA_R	stda	%r9, [%r24 + %r0] 0x4f
	.word 0xdcbf8e80  ! 927: STDA_R	stda	%r14, [%r30 + %r0] 0x74
	.word 0xd6b7e000  ! 928: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 929: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4d6c9e0  ! 930: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r10
	.word 0x87802072  ! 931: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc842000  ! 932: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	.word 0xdccc6000  ! 933: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	.word 0xdc9c6000  ! 934: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r14
	.word 0xd8840400  ! 935: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r12
	mov	0x48, %r24
	.word 0xd29ec9e0  ! 937: LDDA_R	ldda	[%r27, %r0] 0x4f, %r9
	.word 0x87802020  ! 938: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d52000  ! 939: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r9
	mov	0x48, %r17
	.word 0xd89fce40  ! 941: LDDA_R	ldda	[%r31, %r0] 0x72, %r12
	mov	0x68, %r25
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcd5a000  ! 944: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r14
	.word 0x87802020  ! 945: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cc8400  ! 946: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0xdaf72000  ! 947: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xd09f4e60  ! 948: LDDA_R	ldda	[%r29, %r0] 0x73, %r8
	.word 0xdebfe000  ! 949: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xdea72000  ! 950: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 951: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 952: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc9dc4a0  ! 953: LDDA_R	ldda	[%r23, %r0] 0x25, %r14
	.word 0xd88e2000  ! 954: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r12
	mov	0x48, %r27
	.word 0xd4cdc4a0  ! 956: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r10
	.word 0xd4870e80  ! 957: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r10
	mov	0x7f0, %r23
	.word 0xd2b66000  ! 959: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	.word 0xd286a000  ! 960: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r9
	mov	0x3d8, %r21
	mov	0x3d0, %r20
	.word 0xd2f66000  ! 963: STXA_I	stxa	%r9, [%r25 + 0x0000] %asi
	mov	0x28, %r24
	.word 0x87802072  ! 965: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r18
	.word 0xde8fce40  ! 967: LDUBA_R	lduba	[%r31, %r0] 0x72, %r15
	mov	0x3c8, %r20
	.word 0xd08fce60  ! 969: LDUBA_R	lduba	[%r31, %r0] 0x73, %r8
	mov	0x28, %r17
	.word 0xd8c76000  ! 971: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8a7ce40  ! 972: STWA_R	stwa	%r12, [%r31 + %r0] 0x72
	.word 0xd4c7ce60  ! 973: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r10
	.word 0xd0872000  ! 974: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xdab584a0  ! 975: STHA_R	stha	%r13, [%r22 + %r0] 0x25
	.word 0xdcd609e0  ! 976: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r14
	mov	0x68, %r24
	.word 0xd8ac4400  ! 978: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	mov	0x7f8, %r22
	.word 0xdcf72000  ! 980: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdccf6000  ! 981: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdec544a0  ! 982: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r15
	.word 0x87802025  ! 983: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b584a0  ! 984: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0xd8af4e40  ! 985: STBA_R	stba	%r12, [%r29 + %r0] 0x72
	.word 0xdecce000  ! 986: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	.word 0xdabe09e0  ! 987: STDA_R	stda	%r13, [%r24 + %r0] 0x4f
	mov	0x30, %r17
	.word 0xd4b42000  ! 989: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	.word 0xd29cc400  ! 990: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	.word 0xd6842000  ! 991: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r11
	.word 0x87802073  ! 992: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6ac6000  ! 993: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xd6d42000  ! 994: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r11
	mov	0x40, %r17
	.word 0x87802025  ! 996: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6ade000  ! 997: STBA_I	stba	%r11, [%r23 + 0x0000] %asi
	.word 0x87802073  ! 998: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd08c8400  ! 999: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0xdabda000  ! 1000: STDA_I	stda	%r13, [%r22 + 0x0000] %asi
	mov	0x7c8, %r22
	mov	0x38, %r18
	mov	0x38, %r17
	.word 0xd0ae89e0  ! 1004: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	.word 0x8780204f  ! 1005: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r26
	.word 0xdedfce40  ! 1007: LDXA_R	ldxa	[%r31, %r0] 0x72, %r15
	.word 0xd6bc8400  ! 1008: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xd0b6c9e0  ! 1009: STHA_R	stha	%r8, [%r27 + %r0] 0x4f
	.word 0xd2b6e000  ! 1010: STHA_I	stha	%r9, [%r27 + 0x0000] %asi
	.word 0xd29ee000  ! 1011: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r9
	.word 0xdabf0e40  ! 1012: STDA_R	stda	%r13, [%r28 + %r0] 0x72
	.word 0x87802025  ! 1013: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca74e40  ! 1014: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	.word 0xda974e40  ! 1015: LDUHA_R	lduha	[%r29, %r0] 0x72, %r13
	mov	0x7d0, %r23
	.word 0xd09cc400  ! 1017: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	.word 0xd6c72000  ! 1018: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0xd69fa000  ! 1019: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0xd6a7a000  ! 1020: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd487ce60  ! 1021: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r10
	.word 0xdcc7ce40  ! 1022: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r14
	.word 0x8780204f  ! 1023: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf44400  ! 1024: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0xd4bf8e80  ! 1025: STDA_R	stda	%r10, [%r30 + %r0] 0x74
	mov	0x3d0, %r22
	.word 0xd6cf8e80  ! 1027: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r11
	.word 0xdac6a000  ! 1028: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r13
	.word 0xd0b70e60  ! 1029: STHA_R	stha	%r8, [%r28 + %r0] 0x73
	.word 0x8780204f  ! 1030: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdadc8400  ! 1031: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	mov	0x3c8, %r20
	.word 0xd8f62000  ! 1033: STXA_I	stxa	%r12, [%r24 + 0x0000] %asi
	.word 0xd8b62000  ! 1034: STHA_I	stha	%r12, [%r24 + 0x0000] %asi
	.word 0xd29c0400  ! 1035: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	.word 0xd8cee000  ! 1036: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r12
	.word 0xd8d62000  ! 1037: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r12
	mov	0x28, %r19
	mov	0x50, %r27
	.word 0xd8de6000  ! 1040: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r12
	.word 0xdad40400  ! 1041: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	.word 0x87802072  ! 1042: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r24
	.word 0xdca52000  ! 1044: STWA_I	stwa	%r14, [%r20 + 0x0000] %asi
	.word 0xdc8d6000  ! 1045: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r14
	.word 0xdc9de000  ! 1046: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r14
	.word 0xdca5a000  ! 1047: STWA_I	stwa	%r14, [%r22 + 0x0000] %asi
	.word 0xdc8d6000  ! 1048: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r14
	.word 0xd8b4c400  ! 1049: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 1050: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 1051: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0dc8400  ! 1052: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0xd2bf6000  ! 1053: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd297e000  ! 1054: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	mov	0x40, %r17
	.word 0xd2d7a000  ! 1056: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0xd08f0e40  ! 1057: LDUBA_R	lduba	[%r28, %r0] 0x72, %r8
	.word 0xd0f44400  ! 1058: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0x87802025  ! 1059: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r18
	.word 0x87802020  ! 1061: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef74e60  ! 1062: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	.word 0x87802020  ! 1063: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r20
	.word 0xd2f56000  ! 1065: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	.word 0xd2cda000  ! 1066: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r9
	.word 0xd28d2000  ! 1067: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r9
	.word 0xd0bc4400  ! 1068: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xd8f56000  ! 1069: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	mov	0x28, %r18
	mov	0x60, %r16
	.word 0xd8f70e40  ! 1072: STXA_R	stxa	%r12, [%r28 + %r0] 0x72
	.word 0xd2ad6000  ! 1073: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	mov	0x60, %r27
	.word 0xd4c40400  ! 1075: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	mov	0x3e0, %r20
	.word 0x87802020  ! 1077: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r18
	.word 0x87802073  ! 1079: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2ce2000  ! 1080: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r9
	.word 0x87802073  ! 1081: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd29689e0  ! 1082: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r9
	.word 0x8780204f  ! 1083: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcaf8e80  ! 1084: STBA_R	stba	%r14, [%r30 + %r0] 0x74
	.word 0xd29ce000  ! 1085: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xd2b4e000  ! 1086: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 1087: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2bd6000  ! 1089: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	mov	0x58, %r17
	.word 0x87802020  ! 1091: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1092: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bfa000  ! 1093: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd2c72000  ! 1094: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd6df0e80  ! 1095: LDXA_R	ldxa	[%r28, %r0] 0x74, %r11
	.word 0xdaa7a000  ! 1096: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xda8f2000  ! 1097: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xdaf72000  ! 1098: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 1099: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 1100: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6940400  ! 1101: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	.word 0xd4df2000  ! 1102: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4f7a000  ! 1103: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 1104: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f4c400  ! 1105: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd89f2000  ! 1106: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0xd8dfa000  ! 1107: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	mov	0x78, %r24
	.word 0xd897e000  ! 1109: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	mov	0x58, %r17
	mov	0x78, %r19
	mov	0x28, %r18
	.word 0xd8afe000  ! 1113: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	mov	0x7d8, %r20
	mov	0x7f8, %r21
	.word 0xd8a7a000  ! 1116: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8b504a0  ! 1117: STHA_R	stha	%r12, [%r20 + %r0] 0x25
	mov	0x3d8, %r23
	mov	0x20, %r19
	mov	0x7d8, %r21
	.word 0x87802020  ! 1121: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r24
	.word 0x87802072  ! 1123: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebd2000  ! 1124: STDA_I	stda	%r15, [%r20 + 0x0000] %asi
	.word 0x87802025  ! 1125: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde8c6000  ! 1126: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0xdeac6000  ! 1127: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xd0d689e0  ! 1128: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r8
	.word 0xd8b74e60  ! 1129: STHA_R	stha	%r12, [%r29 + %r0] 0x73
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdccdc4a0  ! 1131: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r14
	.word 0xde848400  ! 1132: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	.word 0xd6f46000  ! 1133: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0xd6ac2000  ! 1134: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	mov	0x60, %r19
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6d4e000  ! 1137: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r11
	.word 0xd694e000  ! 1138: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r11
	.word 0xd6cce000  ! 1139: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r11
	mov	0x7e8, %r20
	.word 0xd6b48400  ! 1141: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd2ad44a0  ! 1142: STBA_R	stba	%r9, [%r21 + %r0] 0x25
	.word 0xd6948400  ! 1143: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	.word 0xd4cce000  ! 1144: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	.word 0xdabdc4a0  ! 1145: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	mov	0x48, %r25
	.word 0x87802020  ! 1147: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r21
	.word 0xd6bde000  ! 1149: STDA_I	stda	%r11, [%r23 + 0x0000] %asi
	.word 0xd6dd2000  ! 1150: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r11
	.word 0xd4944400  ! 1151: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	.word 0xd6a78e40  ! 1152: STWA_R	stwa	%r11, [%r30 + %r0] 0x72
	.word 0xd0b56000  ! 1153: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	.word 0xd0ada000  ! 1154: STBA_I	stba	%r8, [%r22 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x7d0, %r23
	.word 0xd0af4e80  ! 1157: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	.word 0xd2a584a0  ! 1158: STWA_R	stwa	%r9, [%r22 + %r0] 0x25
	mov	0x58, %r26
	mov	0x0, %r26
	.word 0xdadd2000  ! 1161: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r13
	.word 0x87802074  ! 1162: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8878e60  ! 1163: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r12
	.word 0x87802072  ! 1164: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f70e60  ! 1165: STXA_R	stxa	%r10, [%r28 + %r0] 0x73
	.word 0xd0842000  ! 1166: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r8
	ta	T_CHANGE_PRIV	! macro
	.word 0xdaaf0e60  ! 1168: STBA_R	stba	%r13, [%r28 + %r0] 0x73
	mov	0x58, %r19
	.word 0xdabd04a0  ! 1170: STDA_R	stda	%r13, [%r20 + %r0] 0x25
	mov	0x8, %r18
	.word 0xd4bce000  ! 1172: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 1173: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d72000  ! 1174: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	mov	0x7d8, %r21
	.word 0xdabfce60  ! 1176: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	mov	0x38, %r27
	mov	0x48, %r18
	.word 0xd89f2000  ! 1179: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0xd887a000  ! 1180: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8df2000  ! 1181: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xd89fe000  ! 1182: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	mov	0x3f0, %r23
	.word 0x87802020  ! 1184: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r22
	.word 0xdccdc4a0  ! 1186: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r14
	.word 0x87802074  ! 1187: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r25
	.word 0xd08cc400  ! 1189: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	.word 0xde870e40  ! 1190: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r15
	.word 0x87802025  ! 1191: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabc8400  ! 1192: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	.word 0xd897a000  ! 1193: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	mov	0x3d0, %r20
	mov	0x3e0, %r21
	.word 0xd4d7ce60  ! 1196: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r10
	.word 0xd8b72000  ! 1197: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	mov	0x10, %r19
	.word 0x87802025  ! 1199: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8d4a000  ! 1200: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	mov	0x7d0, %r22
	mov	0x50, %r25
	.word 0xd8d4e000  ! 1203: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0x87802072  ! 1204: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8d72000  ! 1205: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1206: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r17
	.word 0x87802020  ! 1208: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b70e80  ! 1209: STHA_R	stha	%r9, [%r28 + %r0] 0x74
	.word 0xd8ace000  ! 1210: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 1211: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f70e80  ! 1212: STXA_R	stxa	%r9, [%r28 + %r0] 0x74
	.word 0xdaafce80  ! 1213: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	.word 0xd4bf2000  ! 1214: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd4afe000  ! 1215: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	mov	0x8, %r27
	.word 0xd4dfe000  ! 1217: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd48fa000  ! 1218: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1219: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bf2000  ! 1220: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd4cf2000  ! 1221: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	mov	0x68, %r27
	.word 0xd8dd04a0  ! 1223: LDXA_R	ldxa	[%r20, %r0] 0x25, %r12
	.word 0xd8dc4400  ! 1224: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0xd2be09e0  ! 1225: STDA_R	stda	%r9, [%r24 + %r0] 0x4f
	mov	0x7f0, %r21
	.word 0xd2b76000  ! 1227: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xda8f8e80  ! 1228: LDUBA_R	lduba	[%r30, %r0] 0x74, %r13
	mov	0x78, %r18
	mov	0x38, %r24
	.word 0xd487a000  ! 1231: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4af6000  ! 1232: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd0ad44a0  ! 1233: STBA_R	stba	%r8, [%r21 + %r0] 0x25
	.word 0xdedf2000  ! 1234: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	mov	0x3d8, %r20
	mov	0x48, %r25
	.word 0xd69f4e40  ! 1237: LDDA_R	ldda	[%r29, %r0] 0x72, %r11
	mov	0x7e0, %r22
	.word 0xd0f7ce80  ! 1239: STXA_R	stxa	%r8, [%r31 + %r0] 0x74
	.word 0xd8ad84a0  ! 1240: STBA_R	stba	%r12, [%r22 + %r0] 0x25
	.word 0xd0dfa000  ! 1241: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdeb584a0  ! 1243: STHA_R	stha	%r15, [%r22 + %r0] 0x25
	.word 0xdab70e60  ! 1244: STHA_R	stha	%r13, [%r28 + %r0] 0x73
	.word 0xd0f7ce80  ! 1245: STXA_R	stxa	%r8, [%r31 + %r0] 0x74
	.word 0xd4bfe000  ! 1246: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1247: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r27
	.word 0xd08f0e80  ! 1249: LDUBA_R	lduba	[%r28, %r0] 0x74, %r8
	mov	0x8, %r26
	.word 0xdccec9e0  ! 1251: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r14
	mov	0x7d8, %r21
	.word 0xd89504a0  ! 1253: LDUHA_R	lduha	[%r20, %r0] 0x25, %r12
	.word 0xdcf52000  ! 1254: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	.word 0xdcd52000  ! 1255: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r14
	.word 0xd0a70e40  ! 1256: STWA_R	stwa	%r8, [%r28 + %r0] 0x72
	.word 0x87802020  ! 1257: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bc2000  ! 1258: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	.word 0xdcc48400  ! 1259: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r14
	.word 0xd4b4a000  ! 1260: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0xd484a000  ! 1261: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r10
	.word 0xd8848400  ! 1262: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r12
	.word 0xdcf4c400  ! 1263: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	mov	0x7e8, %r22
	.word 0x87802020  ! 1265: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f44400  ! 1266: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	mov	0x3c0, %r23
	.word 0xd0dfa000  ! 1268: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 1269: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0966000  ! 1270: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r8
	mov	0x3d0, %r20
	.word 0xd0962000  ! 1272: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r8
	.word 0xd0b66000  ! 1273: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	.word 0x87802074  ! 1274: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4d70e40  ! 1275: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r10
	.word 0xd0bfce60  ! 1276: STDA_R	stda	%r8, [%r31 + %r0] 0x73
	mov	0x50, %r19
	mov	0x38, %r26
	.word 0x87802073  ! 1279: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 1280: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r25
	mov	0x3e8, %r23
	.word 0x87802025  ! 1283: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad7a000  ! 1284: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 1285: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdad6c9e0  ! 1286: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r13
	.word 0xdaf6e000  ! 1287: STXA_I	stxa	%r13, [%r27 + 0x0000] %asi
	.word 0xd4be89e0  ! 1288: STDA_R	stda	%r10, [%r26 + %r0] 0x4f
	.word 0xd88584a0  ! 1289: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r12
	.word 0xde9c0400  ! 1290: LDDA_R	ldda	[%r16, %r0] 0x20, %r15
	.word 0xd2b504a0  ! 1291: STHA_R	stha	%r9, [%r20 + %r0] 0x25
	.word 0xd0f70e80  ! 1292: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	mov	0x7e0, %r20
	mov	0x40, %r18
	.word 0xd8bd84a0  ! 1295: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	.word 0x87802020  ! 1296: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r17
	.word 0xd89f0e80  ! 1298: LDDA_R	ldda	[%r28, %r0] 0x74, %r12
	.word 0xd2a46000  ! 1299: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd8dd44a0  ! 1300: LDXA_R	ldxa	[%r21, %r0] 0x25, %r12
	.word 0x87802073  ! 1301: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r18
	.word 0xdef70e80  ! 1303: STXA_R	stxa	%r15, [%r28 + %r0] 0x74
	mov	0x10, %r24
	.word 0xd6cce000  ! 1305: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r11
	.word 0xd6b46000  ! 1306: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	mov	0x70, %r26
	.word 0xdacdc4a0  ! 1308: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r13
	mov	0x18, %r16
	.word 0xdab4a000  ! 1310: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0xdacc6000  ! 1311: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	.word 0x87802073  ! 1312: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e0, %r23
	.word 0xdad4a000  ! 1314: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0xd8878e80  ! 1315: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r12
	.word 0x87802020  ! 1316: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd887a000  ! 1317: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0x87802074  ! 1318: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bfe000  ! 1319: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xdcf649e0  ! 1320: STXA_R	stxa	%r14, [%r25 + %r0] 0x4f
	.word 0xd0f7a000  ! 1321: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xdebf0e40  ! 1322: STDA_R	stda	%r15, [%r28 + %r0] 0x72
	.word 0xda9fa000  ! 1323: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xdaa504a0  ! 1324: STWA_R	stwa	%r13, [%r20 + %r0] 0x25
	.word 0xde97a000  ! 1325: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	mov	0x3d0, %r23
	.word 0xdec5c4a0  ! 1327: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r15
	.word 0xdcb544a0  ! 1328: STHA_R	stha	%r14, [%r21 + %r0] 0x25
	.word 0xd0dfa000  ! 1329: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	mov	0x3e8, %r22
	.word 0xdedc4400  ! 1331: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	.word 0xd0c78e40  ! 1332: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r8
	mov	0x18, %r19
	.word 0x87802072  ! 1334: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 1335: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc8c8400  ! 1336: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0xd6f5a000  ! 1337: STXA_I	stxa	%r11, [%r22 + 0x0000] %asi
	mov	0x7d0, %r20
	.word 0xd6cda000  ! 1339: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r11
	mov	0x3f0, %r23
	.word 0xd4874e60  ! 1341: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r10
	.word 0xd8b52000  ! 1342: STHA_I	stha	%r12, [%r20 + 0x0000] %asi
	.word 0xd8ade000  ! 1343: STBA_I	stba	%r12, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 1344: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 1345: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8cfa000  ! 1346: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	mov	0x7d8, %r20
	.word 0xd0f584a0  ! 1348: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	.word 0xdad48400  ! 1349: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0xd6cc0400  ! 1350: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r11
	mov	0x40, %r16
	mov	0x28, %r16
	.word 0xd8f7e000  ! 1353: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd0a48400  ! 1354: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x3e0, %r22
	mov	0x0, %r18
	mov	0x70, %r26
	.word 0xd4df6000  ! 1359: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1360: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r27
	mov	0x60, %r27
	.word 0xd48f6000  ! 1363: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd6b74e80  ! 1365: STHA_R	stha	%r11, [%r29 + %r0] 0x74
	.word 0xde9cc400  ! 1366: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	.word 0xd4ae09e0  ! 1367: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0xdecfe000  ! 1368: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xdc874e80  ! 1369: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r14
	mov	0x7c8, %r23
	.word 0xdabfe000  ! 1371: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	mov	0x48, %r25
	.word 0xda9f6000  ! 1373: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xded74e80  ! 1374: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r15
	.word 0xd4b4c400  ! 1375: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0x87802020  ! 1376: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cd44a0  ! 1377: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r9
	mov	0x48, %r26
	mov	0x70, %r17
	.word 0x87802025  ! 1380: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0b7ce40  ! 1381: STHA_R	stha	%r8, [%r31 + %r0] 0x72
	.word 0xda8dc4a0  ! 1382: LDUBA_R	lduba	[%r23, %r0] 0x25, %r13
	.word 0xd0cf0e40  ! 1383: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r8
	.word 0xd2cfce80  ! 1384: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r9
	.word 0x8780204f  ! 1385: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 1386: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1387: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49584a0  ! 1388: LDUHA_R	lduha	[%r22, %r0] 0x25, %r10
	.word 0x87802020  ! 1389: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b74e80  ! 1390: STHA_R	stha	%r8, [%r29 + %r0] 0x74
	mov	0x68, %r26
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdaf46000  ! 1393: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0xdab4e000  ! 1394: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	mov	0x58, %r27
	.word 0xd2b40400  ! 1396: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0x87802072  ! 1397: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2cd44a0  ! 1398: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r9
	mov	0x18, %r25
	mov	0x58, %r18
	.word 0xd484c400  ! 1401: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	.word 0xdecfa000  ! 1402: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xd4d4c400  ! 1403: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0x87802072  ! 1404: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdacf2000  ! 1405: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xdab7e000  ! 1406: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xdcae09e0  ! 1407: STBA_R	stba	%r14, [%r24 + %r0] 0x4f
	mov	0x3c0, %r23
	.word 0x87802073  ! 1409: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd48ec9e0  ! 1410: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r10
	.word 0xdec4c400  ! 1411: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	mov	0x58, %r26
	.word 0xd8c74e80  ! 1413: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r12
	mov	0x38, %r17
	.word 0xda87a000  ! 1415: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0xdad7e000  ! 1416: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xda876000  ! 1417: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0xdabfe000  ! 1418: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xda9fa000  ! 1419: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xdab72000  ! 1420: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xd0d5c4a0  ! 1422: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r8
	.word 0xd8b72000  ! 1423: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	mov	0x30, %r16
	mov	0x30, %r25
	.word 0xd897e000  ! 1426: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	.word 0xd8dfa000  ! 1427: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8f7a000  ! 1428: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	mov	0x0, %r18
	.word 0xd8d76000  ! 1430: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1431: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bc6000  ! 1432: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 1433: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1434: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd89d2000  ! 1435: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r12
	.word 0xd4dd44a0  ! 1436: LDXA_R	ldxa	[%r21, %r0] 0x25, %r10
	.word 0x87802025  ! 1437: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0cd84a0  ! 1438: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r8
	.word 0xdeccc400  ! 1439: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r15
	.word 0xd0af6000  ! 1440: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd0d7a000  ! 1441: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1442: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd095a000  ! 1443: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r8
	.word 0xdab40400  ! 1444: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xdea689e0  ! 1445: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	mov	0x0, %r18
	.word 0xd48d2000  ! 1447: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0xd6cdc4a0  ! 1448: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r11
	.word 0xd0dda000  ! 1449: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r8
	.word 0xdeaf8e80  ! 1450: STBA_R	stba	%r15, [%r30 + %r0] 0x74
	mov	0x8, %r25
	.word 0xdaada000  ! 1452: STBA_I	stba	%r13, [%r22 + 0x0000] %asi
	mov	0x3e0, %r23
	.word 0xd2bf4e80  ! 1454: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd6952000  ! 1456: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r11
	.word 0xd6f56000  ! 1457: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	.word 0xdea70e60  ! 1458: STWA_R	stwa	%r15, [%r28 + %r0] 0x73
	.word 0xd0f48400  ! 1459: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xdcf44400  ! 1460: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0x87802025  ! 1461: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd29ea000  ! 1462: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r9
	.word 0xdad5c4a0  ! 1463: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r13
	mov	0x20, %r25
	.word 0xdcaee000  ! 1465: STBA_I	stba	%r14, [%r27 + 0x0000] %asi
	.word 0x87802073  ! 1466: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcafa000  ! 1467: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xdcc70e80  ! 1468: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r14
	mov	0x7f8, %r22
	.word 0xda8dc4a0  ! 1470: LDUBA_R	lduba	[%r23, %r0] 0x25, %r13
	.word 0xdac7e000  ! 1471: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xdcd689e0  ! 1472: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r14
	mov	0x3f8, %r23
	.word 0x87802020  ! 1474: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f70e60  ! 1475: STXA_R	stxa	%r8, [%r28 + %r0] 0x73
	mov	0x8, %r27
	mov	0x7d8, %r23
	.word 0x8780204f  ! 1478: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1479: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88fe000  ! 1480: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8f76000  ! 1481: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd69ec9e0  ! 1482: LDDA_R	ldda	[%r27, %r0] 0x4f, %r11
	.word 0xd09f2000  ! 1483: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0xd0dfa000  ! 1484: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	mov	0x20, %r27
	.word 0xd0cfe000  ! 1486: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xd8b7ce40  ! 1487: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0xd8f7e000  ! 1488: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xdcf78e40  ! 1489: STXA_R	stxa	%r14, [%r30 + %r0] 0x72
	.word 0xdc940400  ! 1490: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0x87802020  ! 1491: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb40400  ! 1492: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0x87802025  ! 1493: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r27
	.word 0xd8dec9e0  ! 1495: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r12
	.word 0xd6d504a0  ! 1496: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r11
	.word 0xdc9ee000  ! 1497: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r14
	.word 0xdeb74e60  ! 1498: STHA_R	stha	%r15, [%r29 + %r0] 0x73
	.word 0xd096a000  ! 1499: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r8
	.word 0xdecd44a0  ! 1500: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r15
	mov	0x0, %r19
	.word 0xdaa62000  ! 1502: STWA_I	stwa	%r13, [%r24 + 0x0000] %asi
	.word 0xdaa66000  ! 1503: STWA_I	stwa	%r13, [%r25 + 0x0000] %asi
	.word 0xdaf6e000  ! 1504: STXA_I	stxa	%r13, [%r27 + 0x0000] %asi
	.word 0xd49fce60  ! 1505: LDDA_R	ldda	[%r31, %r0] 0x73, %r10
	.word 0xdab6c9e0  ! 1506: STHA_R	stha	%r13, [%r27 + %r0] 0x4f
	.word 0xd0bee000  ! 1507: STDA_I	stda	%r8, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 1508: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cf2000  ! 1509: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	mov	0x40, %r19
	.word 0xd0be89e0  ! 1511: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	.word 0xd2d76000  ! 1512: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0xd6ae09e0  ! 1513: STBA_R	stba	%r11, [%r24 + %r0] 0x4f
	.word 0xdc8fe000  ! 1514: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xdc876000  ! 1515: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0xdcafa000  ! 1516: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xdc97e000  ! 1517: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	mov	0x3c0, %r21
	.word 0xdcc72000  ! 1519: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcbfa000  ! 1520: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 1521: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbc6000  ! 1522: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 1523: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r25
	.word 0xdc9f6000  ! 1525: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xdca74e40  ! 1526: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	.word 0xdcdfa000  ! 1527: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	.word 0xd6d7ce60  ! 1528: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r11
	.word 0xd8b72000  ! 1529: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 1530: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r27
	.word 0xd8b5e000  ! 1532: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	.word 0xd88d6000  ! 1533: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r12
	.word 0xd8856000  ! 1534: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	.word 0xd8852000  ! 1535: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r12
	.word 0xd8b5a000  ! 1536: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	.word 0xd8f52000  ! 1537: STXA_I	stxa	%r12, [%r20 + 0x0000] %asi
	.word 0xd8dde000  ! 1538: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r12
	mov	0x28, %r18
	.word 0xd2a78e40  ! 1540: STWA_R	stwa	%r9, [%r30 + %r0] 0x72
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x20, %r25
	.word 0xde974e60  ! 1543: LDUHA_R	lduha	[%r29, %r0] 0x73, %r15
	.word 0xd48d84a0  ! 1544: LDUBA_R	lduba	[%r22, %r0] 0x25, %r10
	.word 0xd29609e0  ! 1545: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r9
	.word 0xdec504a0  ! 1546: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r15
	.word 0xd09de000  ! 1547: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r8
	mov	0x40, %r27
	.word 0xd095e000  ! 1549: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r8
	.word 0xd0bde000  ! 1550: STDA_I	stda	%r8, [%r23 + 0x0000] %asi
	.word 0xd0c56000  ! 1551: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1552: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r22
	mov	0x3f8, %r22
	.word 0xd0ace000  ! 1555: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0xd0cf4e80  ! 1556: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r8
	.word 0xd6bc6000  ! 1557: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xd68609e0  ! 1559: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r11
	mov	0x3d8, %r22
	.word 0xdedcc400  ! 1561: LDXA_R	ldxa	[%r19, %r0] 0x20, %r15
	.word 0xd08e89e0  ! 1562: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r8
	.word 0xd4a74e80  ! 1563: STWA_R	stwa	%r10, [%r29 + %r0] 0x74
	.word 0xd6bca000  ! 1564: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	.word 0xdaa4c400  ! 1565: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0xdcb74e60  ! 1566: STHA_R	stha	%r14, [%r29 + %r0] 0x73
	.word 0xd4dce000  ! 1567: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	.word 0xd2a4c400  ! 1568: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0x87802025  ! 1569: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcaf4e60  ! 1570: STBA_R	stba	%r14, [%r29 + %r0] 0x73
	.word 0xd8d78e80  ! 1571: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r12
	.word 0xdc97a000  ! 1572: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	.word 0xdcf72000  ! 1573: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xdccfa000  ! 1575: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xd89f0e40  ! 1576: LDDA_R	ldda	[%r28, %r0] 0x72, %r12
	.word 0xd0c76000  ! 1577: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0872000  ! 1578: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	mov	0x3c0, %r20
	mov	0x40, %r27
	.word 0x8780204f  ! 1581: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdece89e0  ! 1582: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r15
	.word 0xdef649e0  ! 1583: STXA_R	stxa	%r15, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 1584: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f5c4a0  ! 1585: STXA_R	stxa	%r12, [%r23 + %r0] 0x25
	.word 0x87802025  ! 1586: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2c6a000  ! 1587: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r9
	.word 0xdcf504a0  ! 1588: STXA_R	stxa	%r14, [%r20 + %r0] 0x25
	.word 0xdc974e60  ! 1589: LDUHA_R	lduha	[%r29, %r0] 0x73, %r14
	.word 0x87802020  ! 1590: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1591: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3e0, %r22
	.word 0xd6dd84a0  ! 1593: LDXA_R	ldxa	[%r22, %r0] 0x25, %r11
	.word 0xd6c6e000  ! 1594: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r11
	.word 0xd2b74e60  ! 1595: STHA_R	stha	%r9, [%r29 + %r0] 0x73
	.word 0xd8a70e80  ! 1596: STWA_R	stwa	%r12, [%r28 + %r0] 0x74
	.word 0xdaf40400  ! 1597: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xda948400  ! 1598: LDUHA_R	lduha	[%r18, %r0] 0x20, %r13
	.word 0xd2bcc400  ! 1599: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xde86a000  ! 1600: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r15
	.word 0xd6a70e80  ! 1601: STWA_R	stwa	%r11, [%r28 + %r0] 0x74
	.word 0xd0acc400  ! 1602: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd4d66000  ! 1603: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r10
	.word 0xd4a62000  ! 1604: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	mov	0x38, %r27
	.word 0xd48e2000  ! 1606: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r10
	mov	0x40, %r18
	.word 0x87802020  ! 1608: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48fa000  ! 1609: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1610: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4942000  ! 1611: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r10
	.word 0xd4b42000  ! 1612: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	mov	0x8, %r27
	.word 0xd4f4a000  ! 1614: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 1615: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0df8e60  ! 1616: LDXA_R	ldxa	[%r30, %r0] 0x73, %r8
	mov	0x7d8, %r22
	.word 0xd6ae49e0  ! 1618: STBA_R	stba	%r11, [%r25 + %r0] 0x4f
	.word 0xd8b544a0  ! 1619: STHA_R	stha	%r12, [%r21 + %r0] 0x25
	.word 0x87802072  ! 1620: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc976000  ! 1621: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	mov	0x18, %r25
	mov	0x7c0, %r22
	.word 0xd8bd84a0  ! 1624: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	mov	0x38, %r24
	.word 0xd8c7a000  ! 1626: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	mov	0x0, %r19
	.word 0xd887e000  ! 1628: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 1629: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8af2000  ! 1630: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8df2000  ! 1632: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8bfe000  ! 1633: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd8afe000  ! 1634: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd8af0e60  ! 1635: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	.word 0xdaa6c9e0  ! 1636: STWA_R	stwa	%r13, [%r27 + %r0] 0x4f
	.word 0xdea72000  ! 1637: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xd2f70e60  ! 1638: STXA_R	stxa	%r9, [%r28 + %r0] 0x73
	.word 0xdacfa000  ! 1639: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xd6a74e80  ! 1640: STWA_R	stwa	%r11, [%r29 + %r0] 0x74
	.word 0x8780204f  ! 1641: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r20
	.word 0x87802072  ! 1643: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f6a000  ! 1644: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	.word 0xd4f62000  ! 1645: STXA_I	stxa	%r10, [%r24 + 0x0000] %asi
	.word 0xdcac4400  ! 1646: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	mov	0x3e0, %r22
	.word 0xd4f40400  ! 1648: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xd48ea000  ! 1649: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r10
	.word 0xd48ee000  ! 1650: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r10
	.word 0x87802025  ! 1651: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4946000  ! 1652: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r10
	.word 0xdedf4e80  ! 1653: LDXA_R	ldxa	[%r29, %r0] 0x74, %r15
	.word 0xd0f4a000  ! 1654: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xd2944400  ! 1656: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	.word 0xd4af0e40  ! 1657: STBA_R	stba	%r10, [%r28 + %r0] 0x72
	.word 0x8780204f  ! 1658: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde8fe000  ! 1659: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0x87802072  ! 1660: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 1661: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde8f2000  ! 1662: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xd2a44400  ! 1663: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	mov	0x28, %r25
	.word 0xd8872000  ! 1665: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	.word 0xdeb649e0  ! 1666: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	mov	0x70, %r26
	.word 0xd0dfe000  ! 1668: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xd4f74e80  ! 1669: STXA_R	stxa	%r10, [%r29 + %r0] 0x74
	.word 0xd89c4400  ! 1670: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	mov	0x30, %r18
	mov	0x38, %r18
	.word 0x87802020  ! 1673: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdace89e0  ! 1674: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r13
	mov	0x10, %r27
	mov	0x3c8, %r20
	.word 0xdea74e60  ! 1677: STWA_R	stwa	%r15, [%r29 + %r0] 0x73
	.word 0x87802025  ! 1678: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 1679: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeaf8e80  ! 1680: STBA_R	stba	%r15, [%r30 + %r0] 0x74
	.word 0x87802020  ! 1681: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bd84a0  ! 1682: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0xd0bce000  ! 1683: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 1684: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0a56000  ! 1685: STWA_I	stwa	%r8, [%r21 + 0x0000] %asi
	.word 0xd0f5a000  ! 1686: STXA_I	stxa	%r8, [%r22 + 0x0000] %asi
	.word 0x8780204f  ! 1687: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0c4a000  ! 1688: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0b609e0  ! 1689: STHA_R	stha	%r8, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 1690: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9f6000  ! 1691: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xd4af8e40  ! 1692: STBA_R	stba	%r10, [%r30 + %r0] 0x72
	mov	0x20, %r24
	.word 0xdca72000  ! 1694: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdab4c400  ! 1695: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	mov	0x68, %r25
	.word 0xd88584a0  ! 1697: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r12
	mov	0x0, %r19
	.word 0xde9ec9e0  ! 1699: LDDA_R	ldda	[%r27, %r0] 0x4f, %r15
	.word 0xd2afe000  ! 1700: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd4cfce40  ! 1702: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r10
	.word 0xd2d76000  ! 1703: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1704: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bdc4a0  ! 1705: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	.word 0xd2af6000  ! 1706: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	mov	0x78, %r25
	.word 0xd2a76000  ! 1708: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 1709: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 1710: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2dd2000  ! 1711: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r9
	.word 0x87802074  ! 1712: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc8649e0  ! 1713: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r14
	.word 0xd6b6a000  ! 1714: STHA_I	stha	%r11, [%r26 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xd696e000  ! 1716: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	.word 0xdabf0e80  ! 1717: STDA_R	stda	%r13, [%r28 + %r0] 0x74
	.word 0xd6de2000  ! 1718: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r11
	.word 0xdccf4e80  ! 1719: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r14
	.word 0x87802025  ! 1720: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde978e60  ! 1721: LDUHA_R	lduha	[%r30, %r0] 0x73, %r15
	.word 0xd2ae6000  ! 1722: STBA_I	stba	%r9, [%r25 + 0x0000] %asi
	.word 0xd4f40400  ! 1723: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	mov	0x20, %r26
	.word 0xd4ac0400  ! 1725: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xd2f4c400  ! 1726: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 1727: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bfe000  ! 1728: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x18, %r16
	mov	0x3d8, %r23
	.word 0xd4a72000  ! 1731: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd6c78e40  ! 1732: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	.word 0x87802020  ! 1733: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebfce80  ! 1734: STDA_R	stda	%r15, [%r31 + %r0] 0x74
	.word 0xd08ca000  ! 1735: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xd0a4c400  ! 1736: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	mov	0x50, %r18
	.word 0xdcb44400  ! 1738: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	mov	0x28, %r24
	.word 0xda9c2000  ! 1740: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	mov	0x8, %r18
	.word 0xdca74e60  ! 1742: STWA_R	stwa	%r14, [%r29 + %r0] 0x73
	.word 0xd4b4a000  ! 1743: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0xd4dc2000  ! 1744: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	mov	0x3d8, %r20
	mov	0x20, %r24
	.word 0xd0c7ce40  ! 1747: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r8
	.word 0xde9f4e60  ! 1748: LDDA_R	ldda	[%r29, %r0] 0x73, %r15
	.word 0x87802074  ! 1749: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd29e89e0  ! 1750: LDDA_R	ldda	[%r26, %r0] 0x4f, %r9
	.word 0xdeafce60  ! 1751: STBA_R	stba	%r15, [%r31 + %r0] 0x73
	.word 0xdcf4e000  ! 1752: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xdcbce000  ! 1754: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 1755: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcde6000  ! 1756: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r14
	.word 0xdcbe2000  ! 1757: STDA_I	stda	%r14, [%r24 + 0x0000] %asi
	.word 0x8780204f  ! 1758: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b74e40  ! 1759: STHA_R	stha	%r8, [%r29 + %r0] 0x72
	mov	0x0, %r17
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0ac0400  ! 1762: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 1763: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a4e000  ! 1764: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	mov	0x3c0, %r20
	.word 0x87802020  ! 1766: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0af2000  ! 1767: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0dfe000  ! 1768: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0bf2000  ! 1769: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	mov	0x68, %r27
	mov	0x60, %r24
	mov	0x3f8, %r20
	.word 0xd29f8e40  ! 1773: LDDA_R	ldda	[%r30, %r0] 0x72, %r9
	mov	0x60, %r19
	mov	0x70, %r25
	.word 0xd2cf6000  ! 1776: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1777: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r23
	.word 0x87802074  ! 1779: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r18
	.word 0xdea584a0  ! 1781: STWA_R	stwa	%r15, [%r22 + %r0] 0x25
	.word 0x87802073  ! 1782: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r18
	.word 0x87802074  ! 1784: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f0, %r22
	.word 0xd4f504a0  ! 1786: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0xd2c7e000  ! 1787: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2a72000  ! 1788: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0xdcbf0e60  ! 1789: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	mov	0x7f0, %r23
	.word 0x87802020  ! 1791: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2846000  ! 1792: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r9
	.word 0xd2b46000  ! 1793: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0xdca4c400  ! 1794: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	mov	0x70, %r27
	.word 0xd8ac6000  ! 1796: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xd894a000  ! 1797: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r12
	.word 0xd8a4a000  ! 1798: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8a4a000  ! 1799: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	mov	0x48, %r16
	mov	0x3f8, %r21
	.word 0xd8ce49e0  ! 1802: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r12
	.word 0xd4f4e000  ! 1803: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	mov	0x58, %r19
	mov	0x3c8, %r20
	.word 0xd6de89e0  ! 1806: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r11
	.word 0xd4ac2000  ! 1807: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	mov	0x8, %r19
	mov	0x18, %r17
	mov	0x28, %r19
	mov	0x8, %r26
	.word 0xd4bc2000  ! 1812: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0xd0b70e80  ! 1813: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	.word 0xdadf0e60  ! 1814: LDXA_R	ldxa	[%r28, %r0] 0x73, %r13
	.word 0x87802020  ! 1815: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r26
	.word 0xd0f74e80  ! 1817: STXA_R	stxa	%r8, [%r29 + %r0] 0x74
	.word 0x87802025  ! 1818: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcaf2000  ! 1819: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1820: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r21
	.word 0x87802025  ! 1822: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda96c9e0  ! 1823: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r13
	.word 0x87802020  ! 1824: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0df4e40  ! 1825: LDXA_R	ldxa	[%r29, %r0] 0x72, %r8
	.word 0xd4dfe000  ! 1826: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4afa000  ! 1827: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd4adc4a0  ! 1828: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0xd6df6000  ! 1829: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	mov	0x7e8, %r20
	.word 0xd6afa000  ! 1831: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xdacf4e40  ! 1833: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r13
	.word 0xdaf74e40  ! 1834: STXA_R	stxa	%r13, [%r29 + %r0] 0x72
	.word 0xdacfa000  ! 1835: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xdaaf6000  ! 1836: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xded40400  ! 1837: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	.word 0xd4afe000  ! 1838: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xda8f8e80  ! 1839: LDUBA_R	lduba	[%r30, %r0] 0x74, %r13
	.word 0xd2cf4e60  ! 1840: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r9
	.word 0x87802074  ! 1841: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcdea000  ! 1842: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r14
	mov	0x50, %r25
	.word 0x87802072  ! 1844: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r24
	.word 0xdcc62000  ! 1846: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r14
	.word 0x87802072  ! 1847: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4c6c9e0  ! 1848: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r10
	.word 0xd6d48400  ! 1849: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0x87802020  ! 1850: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c504a0  ! 1851: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r9
	.word 0xd6bd84a0  ! 1852: STDA_R	stda	%r11, [%r22 + %r0] 0x25
	.word 0xdadfce80  ! 1853: LDXA_R	ldxa	[%r31, %r0] 0x74, %r13
	.word 0x87802025  ! 1854: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 1855: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2f74e80  ! 1856: STXA_R	stxa	%r9, [%r29 + %r0] 0x74
	.word 0xd8a74e40  ! 1857: STWA_R	stwa	%r12, [%r29 + %r0] 0x72
	.word 0xd2c584a0  ! 1858: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r9
	.word 0x87802073  ! 1859: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 1860: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1861: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r25
	.word 0xd0c42000  ! 1863: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r8
	.word 0x87802072  ! 1864: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0af6000  ! 1865: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 1866: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2f584a0  ! 1867: STXA_R	stxa	%r9, [%r22 + %r0] 0x25
	.word 0xd2a78e60  ! 1868: STWA_R	stwa	%r9, [%r30 + %r0] 0x73
	.word 0x87802074  ! 1869: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8b584a0  ! 1870: STHA_R	stha	%r12, [%r22 + %r0] 0x25
	.word 0xdedee000  ! 1871: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r15
	mov	0x30, %r19
	.word 0xd4a6c9e0  ! 1873: STWA_R	stwa	%r10, [%r27 + %r0] 0x4f
	.word 0xd6a74e80  ! 1874: STWA_R	stwa	%r11, [%r29 + %r0] 0x74
	.word 0x87802020  ! 1875: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb72000  ! 1876: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xd6cf4e40  ! 1878: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r11
	.word 0xd8afa000  ! 1879: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	mov	0x60, %r25
	.word 0xd8872000  ! 1881: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	.word 0x87802074  ! 1882: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc978e40  ! 1883: LDUHA_R	lduha	[%r30, %r0] 0x72, %r14
	.word 0xd2f7ce40  ! 1884: STXA_R	stxa	%r9, [%r31 + %r0] 0x72
	.word 0xdcbf6000  ! 1885: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	mov	0x70, %r18
	.word 0xdcb7a000  ! 1887: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 1888: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde844400  ! 1889: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	mov	0x3e0, %r20
	mov	0x78, %r17
	.word 0x8780204f  ! 1892: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea78e60  ! 1893: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	.word 0xd8b5c4a0  ! 1894: STHA_R	stha	%r12, [%r23 + %r0] 0x25
	mov	0x20, %r18
	.word 0xdac7a000  ! 1896: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0x87802073  ! 1897: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdedfce60  ! 1898: LDXA_R	ldxa	[%r31, %r0] 0x73, %r15
	.word 0xd4842000  ! 1899: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	.word 0x87802025  ! 1900: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 1901: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c8, %r22
	.word 0xd4bea000  ! 1903: STDA_I	stda	%r10, [%r26 + 0x0000] %asi
	mov	0x18, %r25
	.word 0xd68fce80  ! 1905: LDUBA_R	lduba	[%r31, %r0] 0x74, %r11
	.word 0xdca66000  ! 1906: STWA_I	stwa	%r14, [%r25 + 0x0000] %asi
	.word 0xdc86a000  ! 1907: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 1908: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8978e80  ! 1909: LDUHA_R	lduha	[%r30, %r0] 0x74, %r12
	.word 0x8780204f  ! 1910: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f70e60  ! 1911: STXA_R	stxa	%r11, [%r28 + %r0] 0x73
	mov	0x7f0, %r20
	.word 0xdcd74e40  ! 1913: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r14
	mov	0x70, %r18
	.word 0xdab62000  ! 1915: STHA_I	stha	%r13, [%r24 + 0x0000] %asi
	.word 0xdab6e000  ! 1916: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	.word 0x87802025  ! 1917: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f649e0  ! 1918: STXA_R	stxa	%r11, [%r25 + %r0] 0x4f
	mov	0x7f0, %r23
	.word 0xd0d7a000  ! 1920: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	mov	0x18, %r19
	.word 0x87802025  ! 1922: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4f48400  ! 1923: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0x87802072  ! 1924: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda8ea000  ! 1925: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r13
	.word 0xd08e89e0  ! 1926: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r8
	.word 0xd49e6000  ! 1927: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r10
	.word 0xd09fce60  ! 1928: LDDA_R	ldda	[%r31, %r0] 0x73, %r8
	.word 0xdcdee000  ! 1929: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r14
	mov	0x30, %r17
	.word 0x87802025  ! 1931: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8b7ce80  ! 1932: STHA_R	stha	%r12, [%r31 + %r0] 0x74
	.word 0xd29c4400  ! 1933: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	mov	0x68, %r16
	.word 0xd08d44a0  ! 1935: LDUBA_R	lduba	[%r21, %r0] 0x25, %r8
	.word 0xded42000  ! 1936: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	.word 0xd49f4e60  ! 1937: LDDA_R	ldda	[%r29, %r0] 0x73, %r10
	.word 0x87802073  ! 1938: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 1939: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 1940: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdccca000  ! 1941: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	.word 0xdcf4a000  ! 1942: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcbce000  ! 1943: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xd2ac8400  ! 1944: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	mov	0x78, %r24
	.word 0xdac48400  ! 1946: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	.word 0xd8bf4e80  ! 1947: STDA_R	stda	%r12, [%r29 + %r0] 0x74
	.word 0x87802025  ! 1948: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd69f0e60  ! 1949: LDDA_R	ldda	[%r28, %r0] 0x73, %r11
	.word 0xd08fa000  ! 1950: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0xd0f7e000  ! 1951: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0a76000  ! 1952: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xda9d84a0  ! 1953: LDDA_R	ldda	[%r22, %r0] 0x25, %r13
	.word 0xd8c72000  ! 1954: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	mov	0x70, %r16
	.word 0xd8b76000  ! 1956: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd6b544a0  ! 1957: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	mov	0x70, %r16
	.word 0xdca7a000  ! 1959: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdc876000  ! 1960: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	mov	0x58, %r27
	mov	0x28, %r18
	.word 0xdcafa000  ! 1963: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xd4c609e0  ! 1964: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r10
	.word 0xd2f6c9e0  ! 1965: STXA_R	stxa	%r9, [%r27 + %r0] 0x4f
	.word 0xd2dfe000  ! 1966: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0xd8c74e40  ! 1967: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r12
	.word 0xdaa5c4a0  ! 1968: STWA_R	stwa	%r13, [%r23 + %r0] 0x25
	.word 0xda9f2000  ! 1969: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xdaa7a000  ! 1970: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xd29609e0  ! 1971: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r9
	.word 0x87802025  ! 1972: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r19
	.word 0xd496c9e0  ! 1974: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r10
	.word 0xd4bdc4a0  ! 1975: STDA_R	stda	%r10, [%r23 + %r0] 0x25
	.word 0xd8874e60  ! 1976: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r12
	mov	0x48, %r27
	.word 0xd2b504a0  ! 1978: STHA_R	stha	%r9, [%r20 + %r0] 0x25
	.word 0xd0d74e80  ! 1979: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r8
	.word 0xdcd4a000  ! 1980: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	.word 0xdaac8400  ! 1981: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	mov	0x18, %r25
	.word 0xd2c46000  ! 1983: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	mov	0x58, %r17
	.word 0xd8b4c400  ! 1985: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	mov	0x38, %r18
	.word 0xd8bc6000  ! 1987: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0xd6ac0400  ! 1988: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0x87802072  ! 1989: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc846000  ! 1990: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	mov	0x3d8, %r20
	.word 0xdccce000  ! 1992: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r14
	.word 0xd294c400  ! 1993: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	.word 0xdad42000  ! 1994: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r13
	.word 0x87802025  ! 1995: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d0, %r20
	.word 0xd89dc4a0  ! 1997: LDDA_R	ldda	[%r23, %r0] 0x25, %r12
	.word 0xd4bc2000  ! 1998: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0xd2d78e40  ! 1999: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r9
	.word 0x87802025  ! 2000: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c8, %r20
	.word 0xd88fe000  ! 2002: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8a72000  ! 2003: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8cf2000  ! 2004: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0xd8afa000  ! 2005: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xd6bc8400  ! 2006: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xdcbf0e60  ! 2007: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	.word 0xda87a000  ! 2008: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2009: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8af4e60  ! 2010: STBA_R	stba	%r12, [%r29 + %r0] 0x73
	mov	0x68, %r17
	.word 0xd6bf8e80  ! 2012: STDA_R	stda	%r11, [%r30 + %r0] 0x74
	.word 0x87802025  ! 2013: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd08fce40  ! 2014: LDUBA_R	lduba	[%r31, %r0] 0x72, %r8
	mov	0x3d8, %r21
	.word 0xde9d2000  ! 2016: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r15
	.word 0xd2acc400  ! 2017: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0xdcd56000  ! 2018: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r14
	.word 0xdec4c400  ! 2019: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	.word 0x87802025  ! 2020: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcad84a0  ! 2021: STBA_R	stba	%r14, [%r22 + %r0] 0x25
	.word 0xdcd40400  ! 2022: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	mov	0x7d0, %r22
	.word 0xd4a7ce40  ! 2024: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	.word 0xdca42000  ! 2025: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 2026: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca42000  ! 2027: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xd2b4c400  ! 2028: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xd8f42000  ! 2029: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xdaa7ce80  ! 2030: STWA_R	stwa	%r13, [%r31 + %r0] 0x74
	.word 0x87802025  ! 2031: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r18
	.word 0x8780204f  ! 2033: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b5c4a0  ! 2034: STHA_R	stha	%r12, [%r23 + %r0] 0x25
	.word 0xd29c2000  ! 2035: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	.word 0xdcc70e40  ! 2036: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r14
	.word 0xda8ca000  ! 2037: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r13
	.word 0xdaf46000  ! 2038: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0xd09584a0  ! 2039: LDUHA_R	lduha	[%r22, %r0] 0x25, %r8
	.word 0xdac42000  ! 2040: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0x87802025  ! 2041: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 2042: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabd2000  ! 2043: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	.word 0xda852000  ! 2044: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r13
	.word 0xda95e000  ! 2045: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2046: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa6e000  ! 2047: STWA_I	stwa	%r13, [%r27 + 0x0000] %asi
	.word 0xd6bf8e80  ! 2048: STDA_R	stda	%r11, [%r30 + %r0] 0x74
	.word 0xd89e2000  ! 2049: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r12
	.word 0xd8ce6000  ! 2050: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r12
	.word 0xd8f6a000  ! 2051: STXA_I	stxa	%r12, [%r26 + 0x0000] %asi
	.word 0xd8b66000  ! 2052: STHA_I	stha	%r12, [%r25 + 0x0000] %asi
	mov	0x3d0, %r23
	.word 0x87802074  ! 2054: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r25
	mov	0x3d0, %r23
	.word 0xdec4c400  ! 2057: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	mov	0x40, %r26
	.word 0xd09544a0  ! 2059: LDUHA_R	lduha	[%r21, %r0] 0x25, %r8
	mov	0x38, %r27
	mov	0x38, %r24
	mov	0x50, %r18
	.word 0xdab76000  ! 2063: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	mov	0x3f8, %r22
	mov	0x3d0, %r20
	.word 0x87802073  ! 2066: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e8, %r20
	.word 0xd49d04a0  ! 2068: LDDA_R	ldda	[%r20, %r0] 0x25, %r10
	.word 0xd8b544a0  ! 2069: STHA_R	stha	%r12, [%r21 + %r0] 0x25
	.word 0x8780204f  ! 2070: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b72000  ! 2071: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	mov	0x8, %r27
	.word 0xd0afe000  ! 2073: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0cfa000  ! 2074: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	mov	0x58, %r24
	.word 0xd48f4e40  ! 2076: LDUBA_R	lduba	[%r29, %r0] 0x72, %r10
	.word 0xd6b76000  ! 2077: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd6afa000  ! 2078: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6a72000  ! 2079: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	mov	0x58, %r18
	.word 0xd6c72000  ! 2081: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0x87802074  ! 2082: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b56000  ! 2083: STHA_I	stha	%r11, [%r21 + 0x0000] %asi
	.word 0xd4ae89e0  ! 2084: STBA_R	stba	%r10, [%r26 + %r0] 0x4f
	.word 0xdea56000  ! 2085: STWA_I	stwa	%r15, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 2086: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r19
	.word 0xded6e000  ! 2088: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r15
	.word 0xd8a44400  ! 2089: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xd0a649e0  ! 2090: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	mov	0x48, %r18
	.word 0xd0f62000  ! 2092: STXA_I	stxa	%r8, [%r24 + 0x0000] %asi
	.word 0x8780204f  ! 2093: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b46000  ! 2094: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0xdadf0e40  ! 2095: LDXA_R	ldxa	[%r28, %r0] 0x72, %r13
	.word 0x87802020  ! 2096: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r18
	.word 0xdca72000  ! 2098: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcf76000  ! 2099: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdc9f2000  ! 2100: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xde974e80  ! 2101: LDUHA_R	lduha	[%r29, %r0] 0x74, %r15
	.word 0xd0cf0e60  ! 2102: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r8
	.word 0xdeb70e60  ! 2103: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	mov	0x68, %r18
	mov	0x40, %r16
	.word 0x87802020  ! 2106: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f78e40  ! 2107: STXA_R	stxa	%r12, [%r30 + %r0] 0x72
	.word 0x8780204f  ! 2108: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd29fe000  ! 2109: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0x87802025  ! 2110: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c8, %r22
	.word 0x87802025  ! 2112: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2976000  ! 2113: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0xda94c400  ! 2114: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	.word 0xdec40400  ! 2115: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xd2d7a000  ! 2116: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2117: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bee000  ! 2118: STDA_I	stda	%r9, [%r27 + 0x0000] %asi
	.word 0xd2862000  ! 2119: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r9
	.word 0xd4a504a0  ! 2120: STWA_R	stwa	%r10, [%r20 + %r0] 0x25
	.word 0xd8ae2000  ! 2121: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	.word 0xd2b7ce40  ! 2122: STHA_R	stha	%r9, [%r31 + %r0] 0x72
	.word 0xd4d6e000  ! 2123: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r10
	mov	0x7c0, %r21
	.word 0xd4a70e60  ! 2125: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	.word 0xd8f66000  ! 2126: STXA_I	stxa	%r12, [%r25 + 0x0000] %asi
	.word 0xd2a689e0  ! 2127: STWA_R	stwa	%r9, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 2128: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c76000  ! 2129: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	mov	0x7c0, %r20
	.word 0xd4cfa000  ! 2131: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	mov	0x3c8, %r22
	mov	0x3f0, %r21
	.word 0x87802020  ! 2134: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r18
	.word 0xd0acc400  ! 2136: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xdc9d2000  ! 2137: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r14
	.word 0xd0878e40  ! 2138: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r8
	.word 0xd6d5a000  ! 2139: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r11
	mov	0x30, %r18
	mov	0x78, %r26
	mov	0x68, %r17
	.word 0xdea4c400  ! 2143: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	mov	0x30, %r19
	mov	0x30, %r27
	.word 0xd8b48400  ! 2146: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0xdcc48400  ! 2147: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r14
	mov	0x10, %r24
	.word 0xd69504a0  ! 2149: LDUHA_R	lduha	[%r20, %r0] 0x25, %r11
	.word 0xd0f56000  ! 2150: STXA_I	stxa	%r8, [%r21 + 0x0000] %asi
	.word 0xd0b70e40  ! 2151: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	mov	0x7e8, %r21
	mov	0x7f8, %r23
	.word 0x87802074  ! 2154: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r16
	.word 0xdaf6a000  ! 2156: STXA_I	stxa	%r13, [%r26 + 0x0000] %asi
	.word 0xd2944400  ! 2157: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	.word 0xd0af8e40  ! 2158: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0xdeae2000  ! 2159: STBA_I	stba	%r15, [%r24 + 0x0000] %asi
	mov	0x40, %r27
	.word 0xde8ee000  ! 2161: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r15
	mov	0x7e0, %r21
	.word 0xdeb6e000  ! 2163: STHA_I	stha	%r15, [%r27 + 0x0000] %asi
	.word 0xd2874e60  ! 2164: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r9
	.word 0xd6970e40  ! 2165: LDUHA_R	lduha	[%r28, %r0] 0x72, %r11
	mov	0x10, %r27
	.word 0xdcde2000  ! 2167: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r14
	.word 0xdcbe2000  ! 2168: STDA_I	stda	%r14, [%r24 + 0x0000] %asi
	.word 0xdcae2000  ! 2169: STBA_I	stba	%r14, [%r24 + 0x0000] %asi
	mov	0x7d8, %r20
	mov	0x78, %r19
	.word 0xdcb66000  ! 2172: STHA_I	stha	%r14, [%r25 + 0x0000] %asi
	mov	0x48, %r25
	.word 0xdcb6e000  ! 2174: STHA_I	stha	%r14, [%r27 + 0x0000] %asi
	.word 0xd88fce40  ! 2175: LDUBA_R	lduba	[%r31, %r0] 0x72, %r12
	.word 0xd69504a0  ! 2176: LDUHA_R	lduha	[%r20, %r0] 0x25, %r11
	.word 0xd296a000  ! 2177: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r9
	.word 0xd6a70e80  ! 2178: STWA_R	stwa	%r11, [%r28 + %r0] 0x74
	mov	0x30, %r24
	.word 0xd49ec9e0  ! 2180: LDDA_R	ldda	[%r27, %r0] 0x4f, %r10
	.word 0x87802025  ! 2181: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a5c4a0  ! 2182: STWA_R	stwa	%r11, [%r23 + %r0] 0x25
	mov	0x10, %r17
	.word 0xd4c7e000  ! 2184: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802020  ! 2185: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bfce40  ! 2186: STDA_R	stda	%r8, [%r31 + %r0] 0x72
	.word 0xd0a5c4a0  ! 2187: STWA_R	stwa	%r8, [%r23 + %r0] 0x25
	.word 0xdca62000  ! 2188: STWA_I	stwa	%r14, [%r24 + 0x0000] %asi
	mov	0x20, %r19
	.word 0xdcae6000  ! 2190: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	.word 0xdca62000  ! 2191: STWA_I	stwa	%r14, [%r24 + 0x0000] %asi
	.word 0xdcbe6000  ! 2192: STDA_I	stda	%r14, [%r25 + 0x0000] %asi
	.word 0xdc9e2000  ! 2193: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r14
	mov	0x3c8, %r22
	mov	0x8, %r18
	mov	0x60, %r25
	.word 0xd69d44a0  ! 2197: LDDA_R	ldda	[%r21, %r0] 0x25, %r11
	mov	0x7e0, %r22
	mov	0x78, %r24
	mov	0x7e0, %r21
	.word 0xd4bf0e60  ! 2201: STDA_R	stda	%r10, [%r28 + %r0] 0x73
	.word 0xd88f8e60  ! 2202: LDUBA_R	lduba	[%r30, %r0] 0x73, %r12
	.word 0x87802074  ! 2203: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4cec9e0  ! 2204: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r10
	.word 0xde872000  ! 2205: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xd2c4c400  ! 2206: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0x87802020  ! 2207: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa5c4a0  ! 2208: STWA_R	stwa	%r13, [%r23 + %r0] 0x25
	.word 0xd897e000  ! 2209: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 2210: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c0, %r22
	.word 0xde8e09e0  ! 2212: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r15
	.word 0xdeb584a0  ! 2213: STHA_R	stha	%r15, [%r22 + %r0] 0x25
	.word 0xd4874e80  ! 2214: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r10
	.word 0xd8df0e80  ! 2215: LDXA_R	ldxa	[%r28, %r0] 0x74, %r12
	mov	0x8, %r27
	.word 0xdadfa000  ! 2217: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xdcb78e60  ! 2218: STHA_R	stha	%r14, [%r30 + %r0] 0x73
	.word 0xd4f7a000  ! 2219: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 2220: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cf2000  ! 2221: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd2f74e80  ! 2222: STXA_R	stxa	%r9, [%r29 + %r0] 0x74
	mov	0x0, %r16
	.word 0x8780204f  ! 2224: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6c40400  ! 2225: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r11
	mov	0x3e0, %r21
	.word 0xdeb70e60  ! 2227: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	.word 0xd4cf6000  ! 2228: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0xd4bf2000  ! 2229: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd4bf6000  ! 2230: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	mov	0x30, %r26
	.word 0xd6974e60  ! 2232: LDUHA_R	lduha	[%r29, %r0] 0x73, %r11
	mov	0x20, %r19
	.word 0xd68f0e40  ! 2234: LDUBA_R	lduba	[%r28, %r0] 0x72, %r11
	.word 0xdab78e80  ! 2235: STHA_R	stha	%r13, [%r30 + %r0] 0x74
	.word 0xd6bf6000  ! 2236: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd6bd04a0  ! 2237: STDA_R	stda	%r11, [%r20 + %r0] 0x25
	.word 0xdaaf2000  ! 2238: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdacf2000  ! 2239: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xd4dd04a0  ! 2240: LDXA_R	ldxa	[%r20, %r0] 0x25, %r10
	.word 0x87802073  ! 2241: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd4d66000  ! 2243: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r10
	mov	0x70, %r16
	.word 0xdcd74e80  ! 2245: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r14
	.word 0x87802074  ! 2246: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdab544a0  ! 2247: STHA_R	stha	%r13, [%r21 + %r0] 0x25
	.word 0xd0cf0e40  ! 2248: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r8
	.word 0x87802025  ! 2249: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd687ce80  ! 2250: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r11
	.word 0xd4cf8e40  ! 2251: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r10
	.word 0xd8dea000  ! 2252: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r12
	.word 0xd8862000  ! 2253: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r12
	.word 0xdccfce60  ! 2254: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r14
	.word 0xd8ce2000  ! 2255: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r12
	.word 0xd8a6e000  ! 2256: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	.word 0xdeb7ce80  ! 2257: STHA_R	stha	%r15, [%r31 + %r0] 0x74
	mov	0x0, %r27
	mov	0x7d8, %r22
	mov	0x40, %r16
	.word 0xd0ce2000  ! 2261: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r8
	.word 0xdaf504a0  ! 2262: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	.word 0xd4a48400  ! 2263: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xd6c48400  ! 2264: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	.word 0xdeaee000  ! 2265: STBA_I	stba	%r15, [%r27 + 0x0000] %asi
	.word 0xd2af4e60  ! 2266: STBA_R	stba	%r9, [%r29 + %r0] 0x73
	.word 0xdaa6e000  ! 2267: STWA_I	stwa	%r13, [%r27 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0xdad62000  ! 2269: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r13
	.word 0xdabea000  ! 2270: STDA_I	stda	%r13, [%r26 + 0x0000] %asi
	.word 0xdac6e000  ! 2271: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r13
	.word 0xd0af8e60  ! 2272: STBA_R	stba	%r8, [%r30 + %r0] 0x73
	.word 0x87802072  ! 2273: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab7e000  ! 2274: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xdcaf8e60  ! 2275: STBA_R	stba	%r14, [%r30 + %r0] 0x73
	.word 0x87802072  ! 2276: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb7ce60  ! 2277: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	.word 0xdeae09e0  ! 2278: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	.word 0xd0dc2000  ! 2279: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	.word 0xdaad84a0  ! 2280: STBA_R	stba	%r13, [%r22 + %r0] 0x25
	mov	0x3e8, %r21
	.word 0xd0d584a0  ! 2282: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r8
	mov	0x0, %r25
	mov	0x70, %r16
	.word 0xdeb78e60  ! 2285: STHA_R	stha	%r15, [%r30 + %r0] 0x73
	.word 0xd096c9e0  ! 2286: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r8
	.word 0xd8aca000  ! 2287: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	mov	0x7c0, %r20
	mov	0x30, %r24
	.word 0xd8f4e000  ! 2290: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xd4bf4e40  ! 2291: STDA_R	stda	%r10, [%r29 + %r0] 0x72
	.word 0xdcb689e0  ! 2292: STHA_R	stha	%r14, [%r26 + %r0] 0x4f
	mov	0x3f0, %r21
	.word 0xd0a4e000  ! 2294: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 2295: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0972000  ! 2296: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xd2cf8e40  ! 2297: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r9
	.word 0xd4cd04a0  ! 2298: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r10
	.word 0xdca7a000  ! 2299: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xdcaf4e80  ! 2301: STBA_R	stba	%r14, [%r29 + %r0] 0x74
	.word 0xdaafe000  ! 2302: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xd2be49e0  ! 2303: STDA_R	stda	%r9, [%r25 + %r0] 0x4f
	.word 0xd6a7ce60  ! 2304: STWA_R	stwa	%r11, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 2305: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 2306: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca7ce80  ! 2307: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	.word 0xd8978e80  ! 2308: LDUHA_R	lduha	[%r30, %r0] 0x74, %r12
	mov	0x3c8, %r23
	.word 0xd0f56000  ! 2310: STXA_I	stxa	%r8, [%r21 + 0x0000] %asi
	mov	0x68, %r24
	.word 0x8780204f  ! 2312: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a7a000  ! 2313: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd097e000  ! 2314: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	mov	0x7d8, %r23
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0f7a000  ! 2317: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 2318: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0adc4a0  ! 2319: STBA_R	stba	%r8, [%r23 + %r0] 0x25
	.word 0x87802074  ! 2320: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdad4e000  ! 2321: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r13
	.word 0xdacca000  ! 2322: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	mov	0x78, %r27
	mov	0x0, %r19
	.word 0xda946000  ! 2325: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	.word 0xdca44400  ! 2326: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0xdc842000  ! 2327: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcf649e0  ! 2329: STXA_R	stxa	%r14, [%r25 + %r0] 0x4f
	mov	0x78, %r24
	.word 0xd4b649e0  ! 2331: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	.word 0xde9ce000  ! 2332: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	mov	0x3d0, %r23
	.word 0xdec42000  ! 2334: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0x87802020  ! 2335: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2336: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 2337: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd88d44a0  ! 2338: LDUBA_R	lduba	[%r21, %r0] 0x25, %r12
	.word 0xd6bfe000  ! 2339: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 2340: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r25
	.word 0xd6b72000  ! 2342: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd8b7ce80  ! 2343: STHA_R	stha	%r12, [%r31 + %r0] 0x74
	mov	0x3d0, %r21
	mov	0x3d0, %r22
	.word 0xd08f6000  ! 2346: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r8
	.word 0xdedf0e40  ! 2347: LDXA_R	ldxa	[%r28, %r0] 0x72, %r15
	mov	0x70, %r17
	.word 0xdcb74e60  ! 2349: STHA_R	stha	%r14, [%r29 + %r0] 0x73
	.word 0xdcdfe000  ! 2350: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	mov	0x3c0, %r22
	.word 0xd887ce80  ! 2352: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r12
	.word 0xd88f6000  ! 2353: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 2354: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bfa000  ! 2355: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	mov	0x58, %r18
	.word 0xd8bf2000  ! 2357: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xd88f2000  ! 2359: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0x87802073  ! 2360: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0c48400  ! 2361: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r8
	.word 0xd89fce80  ! 2362: LDDA_R	ldda	[%r31, %r0] 0x74, %r12
	mov	0x18, %r17
	.word 0x87802073  ! 2364: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r17
	.word 0xd8bf4e40  ! 2366: STDA_R	stda	%r12, [%r29 + %r0] 0x72
	mov	0x3d8, %r20
	.word 0xd0d40400  ! 2368: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	mov	0x7e0, %r23
	mov	0x3d8, %r23
	.word 0xd2862000  ! 2371: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r9
	.word 0xd2de2000  ! 2372: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2f6a000  ! 2374: STXA_I	stxa	%r9, [%r26 + 0x0000] %asi
	.word 0xd2ce6000  ! 2375: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r9
	.word 0x87802072  ! 2376: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2976000  ! 2377: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	mov	0x38, %r18
	.word 0xd2bfa000  ! 2379: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd2dfe000  ! 2380: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	mov	0x20, %r16
	.word 0xd28cc400  ! 2382: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	.word 0xdcbec9e0  ! 2383: STDA_R	stda	%r14, [%r27 + %r0] 0x4f
	.word 0xd8d7a000  ! 2384: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	mov	0x40, %r26
	.word 0xd4a5c4a0  ! 2386: STWA_R	stwa	%r10, [%r23 + %r0] 0x25
	mov	0x58, %r19
	.word 0xd0b72000  ! 2388: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	mov	0x58, %r17
	.word 0x87802020  ! 2390: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r17
	mov	0x3d0, %r20
	mov	0x0, %r24
	.word 0xd0f42000  ! 2394: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 2395: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e0, %r23
	.word 0x87802074  ! 2397: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 2398: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaac8400  ! 2399: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	mov	0x7c0, %r20
	mov	0x68, %r24
	mov	0x7e0, %r23
	.word 0xd2d544a0  ! 2403: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r9
	.word 0x8780204f  ! 2404: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c8, %r21
	.word 0xd4dd44a0  ! 2406: LDXA_R	ldxa	[%r21, %r0] 0x25, %r10
	.word 0x87802025  ! 2407: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 2408: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0c76000  ! 2409: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0xdca584a0  ! 2410: STWA_R	stwa	%r14, [%r22 + %r0] 0x25
	.word 0xd08d04a0  ! 2411: LDUBA_R	lduba	[%r20, %r0] 0x25, %r8
	.word 0x8780204f  ! 2412: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd09d44a0  ! 2413: LDDA_R	ldda	[%r21, %r0] 0x25, %r8
	.word 0xd0c7e000  ! 2414: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	mov	0x0, %r16
	mov	0x38, %r24
	.word 0xd0c76000  ! 2417: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0xd4d504a0  ! 2418: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r10
	.word 0x87802074  ! 2419: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8b78e80  ! 2420: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	.word 0xdcd42000  ! 2421: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	.word 0x87802074  ! 2422: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf7e000  ! 2423: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdc87a000  ! 2424: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcb7a000  ! 2425: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0xdc872000  ! 2427: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	mov	0x20, %r18
	.word 0xdcc76000  ! 2429: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0x87802074  ! 2430: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdccfe000  ! 2431: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xde878e60  ! 2432: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r15
	.word 0xd6d6c9e0  ! 2433: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r11
	.word 0xdcf4c400  ! 2434: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0x87802072  ! 2435: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcd649e0  ! 2436: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r14
	.word 0xdef72000  ! 2437: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xde876000  ! 2438: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xdaf7ce80  ! 2439: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	mov	0x7c8, %r21
	mov	0x10, %r25
	.word 0xd6b7e000  ! 2442: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd6f7e000  ! 2443: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2444: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r27
	mov	0x0, %r27
	.word 0xd0b70e40  ! 2447: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	.word 0xde972000  ! 2448: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	mov	0x7e0, %r23
	mov	0x3c0, %r22
	.word 0xd2dc4400  ! 2451: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0x87802072  ! 2452: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6afce80  ! 2453: STBA_R	stba	%r11, [%r31 + %r0] 0x74
	.word 0x8780204f  ! 2454: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f5c4a0  ! 2455: STXA_R	stxa	%r10, [%r23 + %r0] 0x25
	.word 0xd8afa000  ! 2456: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xde95c4a0  ! 2457: LDUHA_R	lduha	[%r23, %r0] 0x25, %r15
	mov	0x48, %r27
	.word 0xd88f8e60  ! 2459: LDUBA_R	lduba	[%r30, %r0] 0x73, %r12
	.word 0xd89fe000  ! 2460: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0xda9609e0  ! 2461: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r13
	.word 0xd4f72000  ! 2462: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	mov	0x7f0, %r21
	mov	0x28, %r16
	mov	0x7d8, %r21
	.word 0xd09f0e60  ! 2466: LDDA_R	ldda	[%r28, %r0] 0x73, %r8
	.word 0xd88f8e40  ! 2467: LDUBA_R	lduba	[%r30, %r0] 0x72, %r12
	.word 0xd2df6000  ! 2468: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0xd297a000  ! 2469: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	.word 0x87802073  ! 2470: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2aca000  ! 2471: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0xd8be89e0  ! 2472: STDA_R	stda	%r12, [%r26 + %r0] 0x4f
	mov	0x8, %r17
	.word 0xdabca000  ! 2474: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xd69f0e40  ! 2475: LDDA_R	ldda	[%r28, %r0] 0x72, %r11
	.word 0xdadec9e0  ! 2476: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r13
	.word 0xd0f46000  ! 2477: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	mov	0x7e0, %r21
	.word 0xd08c6000  ! 2479: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0xd0a42000  ! 2480: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xd0ace000  ! 2481: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0xd09ca000  ! 2482: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	.word 0xd0a42000  ! 2483: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	mov	0x70, %r24
	.word 0xd0870e40  ! 2485: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r8
	.word 0x87802073  ! 2486: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda840400  ! 2487: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	.word 0x87802020  ! 2488: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r25
	.word 0xd8d48400  ! 2490: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0xdabca000  ! 2491: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xde84c400  ! 2492: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0xdef74e60  ! 2493: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	mov	0x0, %r19
	.word 0xdec7ce60  ! 2495: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r15
	.word 0xd694a000  ! 2496: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r11
	.word 0x87802072  ! 2497: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f70e60  ! 2498: STXA_R	stxa	%r10, [%r28 + %r0] 0x73
	.word 0xd8bf8e80  ! 2499: STDA_R	stda	%r12, [%r30 + %r0] 0x74
	mov	0x78, %r24
	.word 0x87802072  ! 2501: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 2502: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2503: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf44400  ! 2504: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xdad78e80  ! 2505: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r13
	mov	0x20, %r26
	mov	0x7e0, %r20
	.word 0xdad46000  ! 2508: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	mov	0x7f8, %r22
	.word 0xda86c9e0  ! 2510: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r13
	.word 0xdabf8e40  ! 2511: STDA_R	stda	%r13, [%r30 + %r0] 0x72
	.word 0x8780204f  ! 2512: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bce000  ! 2513: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xdeac0400  ! 2514: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xdeb74e80  ! 2515: STHA_R	stha	%r15, [%r29 + %r0] 0x74
	.word 0xdedc0400  ! 2516: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	.word 0xdec46000  ! 2517: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	.word 0x87802025  ! 2518: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 2519: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 2520: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xdea42000  ! 2522: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xdeace000  ! 2523: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xdeb4e000  ! 2524: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0xdaf544a0  ! 2525: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	.word 0x87802073  ! 2526: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6df6000  ! 2527: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6a72000  ! 2528: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 2529: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdebcc400  ! 2530: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	.word 0xdeb78e40  ! 2531: STHA_R	stha	%r15, [%r30 + %r0] 0x72
	.word 0xdcac2000  ! 2532: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0xdebec9e0  ! 2533: STDA_R	stda	%r15, [%r27 + %r0] 0x4f
	.word 0xd2cca000  ! 2534: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	mov	0x7d8, %r21
	mov	0x28, %r19
	.word 0xdeb78e40  ! 2537: STHA_R	stha	%r15, [%r30 + %r0] 0x72
	.word 0x87802074  ! 2538: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda8ee000  ! 2539: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r13
	.word 0xdcc4c400  ! 2540: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	mov	0x7c8, %r22
	.word 0xd4de6000  ! 2542: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r10
	.word 0xdad48400  ! 2543: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0xd896c9e0  ! 2544: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r12
	.word 0xd4ce6000  ! 2545: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r10
	.word 0xd4d66000  ! 2546: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r10
	.word 0xd2878e60  ! 2547: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r9
	.word 0x87802020  ! 2548: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cec9e0  ! 2549: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r11
	.word 0xde9fce60  ! 2550: LDDA_R	ldda	[%r31, %r0] 0x73, %r15
	ta	T_CHANGE_PRIV	! macro
	mov	0x7f0, %r22
	mov	0x68, %r16
	.word 0xda956000  ! 2554: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r13
	.word 0xda95a000  ! 2555: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r13
	.word 0xd6ad84a0  ! 2556: STBA_R	stba	%r11, [%r22 + %r0] 0x25
	mov	0x3f0, %r21
	.word 0xd6cde000  ! 2558: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r11
	.word 0xd6f56000  ! 2559: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	.word 0xd0be89e0  ! 2560: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 2561: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29d84a0  ! 2562: LDDA_R	ldda	[%r22, %r0] 0x25, %r9
	.word 0xdc8d04a0  ! 2563: LDUBA_R	lduba	[%r20, %r0] 0x25, %r14
	.word 0x87802073  ! 2564: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0bca000  ! 2565: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 2566: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cf2000  ! 2567: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0xd0f76000  ! 2568: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0876000  ! 2569: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	.word 0xd6af8e40  ! 2570: STBA_R	stba	%r11, [%r30 + %r0] 0x72
	.word 0x87802025  ! 2571: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0ce09e0  ! 2572: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r8
	.word 0xd8cfce40  ! 2573: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r12
	.word 0xd8cd04a0  ! 2574: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r12
	mov	0x48, %r25
	.word 0xd0d62000  ! 2576: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r8
	.word 0xd8b504a0  ! 2577: STHA_R	stha	%r12, [%r20 + %r0] 0x25
	.word 0xd0bfce80  ! 2578: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	.word 0xd0ce6000  ! 2579: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r8
	mov	0x10, %r19
	.word 0xd6f70e80  ! 2581: STXA_R	stxa	%r11, [%r28 + %r0] 0x74
	mov	0x3f8, %r23
	.word 0xd2de2000  ! 2583: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r9
	.word 0xd487ce80  ! 2584: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r10
	.word 0xd8c6e000  ! 2585: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r12
	.word 0xd0a44400  ! 2586: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	mov	0x60, %r18
	.word 0xd486a000  ! 2588: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r10
	mov	0x40, %r26
	.word 0xd4ae6000  ! 2590: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0xd4f62000  ! 2591: STXA_I	stxa	%r10, [%r24 + 0x0000] %asi
	.word 0xd49e6000  ! 2592: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r10
	mov	0x30, %r17
	mov	0x68, %r18
	mov	0x7f0, %r22
	.word 0xd2d74e60  ! 2596: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r9
	.word 0x87802073  ! 2597: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 2598: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0f40400  ! 2599: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xd4b609e0  ! 2600: STHA_R	stha	%r10, [%r24 + %r0] 0x4f
	.word 0xd29fe000  ! 2601: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd2bfe000  ! 2602: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2603: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a42000  ! 2604: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 2605: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2606: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2607: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb48400  ! 2608: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xd8862000  ! 2609: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r12
	.word 0xd88ee000  ! 2610: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r12
	.word 0xd89ea000  ! 2611: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r12
	.word 0xd896e000  ! 2612: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r12
	.word 0xdeb48400  ! 2613: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xd8bee000  ! 2614: STDA_I	stda	%r12, [%r27 + 0x0000] %asi
	.word 0xd8ce2000  ! 2615: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r12
	mov	0x10, %r18
	mov	0x78, %r24
	.word 0x87802072  ! 2618: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r16
	.word 0xd0cd44a0  ! 2620: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r8
	.word 0xd4a6e000  ! 2621: STWA_I	stwa	%r10, [%r27 + 0x0000] %asi
	.word 0xd4c40400  ! 2622: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	mov	0x58, %r18
	.word 0xdcd649e0  ! 2624: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r14
	.word 0x87802020  ! 2625: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca40400  ! 2626: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	mov	0x28, %r19
	mov	0x50, %r18
	.word 0xd896a000  ! 2629: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r12
	.word 0xd8d6a000  ! 2630: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r12
	mov	0x3d8, %r23
	.word 0xd8b66000  ! 2632: STHA_I	stha	%r12, [%r25 + 0x0000] %asi
	.word 0xdec74e40  ! 2633: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r15
	mov	0x48, %r19
	mov	0x7e8, %r23
	.word 0xd687ce80  ! 2636: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r11
	.word 0x8780204f  ! 2637: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r19
	mov	0x0, %r18
	mov	0x18, %r25
	mov	0x18, %r24
	.word 0x87802072  ! 2642: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r16
	.word 0xd0d74e40  ! 2644: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r8
	mov	0x0, %r19
	mov	0x40, %r26
	mov	0x3c8, %r21
	.word 0xd4c70e80  ! 2648: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r10
	.word 0xdcdc4400  ! 2649: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	.word 0xd8870e80  ! 2650: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r12
	mov	0x48, %r25
	.word 0xd8f44400  ! 2652: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xd6dd2000  ! 2653: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r11
	.word 0x87802073  ! 2654: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r19
	.word 0xd6f7a000  ! 2656: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd69f2000  ! 2657: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xd8a78e40  ! 2658: STWA_R	stwa	%r12, [%r30 + %r0] 0x72
	.word 0xd0c7a000  ! 2659: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xd2dfce40  ! 2660: LDXA_R	ldxa	[%r31, %r0] 0x72, %r9
	.word 0xd8cd04a0  ! 2661: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r12
	.word 0xd2cf0e40  ! 2662: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r9
	.word 0xd8874e60  ! 2663: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r12
	.word 0xd48f6000  ! 2664: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	mov	0x0, %r18
	.word 0x87802020  ! 2666: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2667: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b72000  ! 2668: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	mov	0x3f8, %r23
	.word 0xd4f70e40  ! 2670: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	.word 0x87802072  ! 2671: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r26
	.word 0xdecf8e60  ! 2673: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r15
	.word 0xdab48400  ! 2674: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0xd6848400  ! 2675: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	.word 0x87802073  ! 2676: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6a70e60  ! 2677: STWA_R	stwa	%r11, [%r28 + %r0] 0x73
	.word 0xdc9fa000  ! 2678: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0xd8c48400  ! 2679: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	.word 0x87802025  ! 2680: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2f7e000  ! 2681: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2682: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f70e80  ! 2683: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0xdcf76000  ! 2684: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x10, %r24
	mov	0x3e0, %r20
	mov	0x3e8, %r21
	.word 0x87802073  ! 2688: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd29c8400  ! 2689: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	.word 0xdc94c400  ! 2690: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	.word 0xdcdf6000  ! 2691: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcafe000  ! 2693: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdcf7e000  ! 2694: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x68, %r26
	.word 0xdcd74e60  ! 2696: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r14
	mov	0x70, %r17
	.word 0xdcf76000  ! 2698: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdca72000  ! 2699: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xdab584a0  ! 2701: STHA_R	stha	%r13, [%r22 + %r0] 0x25
	.word 0x87802074  ! 2702: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bd6000  ! 2703: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	.word 0xd6cfce60  ! 2704: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r11
	.word 0xdeb52000  ! 2705: STHA_I	stha	%r15, [%r20 + 0x0000] %asi
	.word 0xd0af4e40  ! 2706: STBA_R	stba	%r8, [%r29 + %r0] 0x72
	.word 0x87802073  ! 2707: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef76000  ! 2708: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xd2f689e0  ! 2709: STXA_R	stxa	%r9, [%r26 + %r0] 0x4f
	.word 0xde948400  ! 2710: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	.word 0xd4bf2000  ! 2711: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd4d7a000  ! 2712: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	.word 0xd2de09e0  ! 2713: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r9
	.word 0xdcbf2000  ! 2714: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdcd76000  ! 2715: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	.word 0xdc8fe000  ! 2716: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	mov	0x7d0, %r23
	.word 0xdcf78e60  ! 2718: STXA_R	stxa	%r14, [%r30 + %r0] 0x73
	mov	0x78, %r24
	.word 0xdaa7e000  ! 2720: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	mov	0x70, %r16
	.word 0xd48c0400  ! 2722: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	mov	0x28, %r18
	.word 0xd2f7e000  ! 2724: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd29fa000  ! 2725: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd2bfa000  ! 2726: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xdea649e0  ! 2727: STWA_R	stwa	%r15, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 2728: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2729: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f6a000  ! 2730: STXA_I	stxa	%r11, [%r26 + 0x0000] %asi
	.word 0xd6862000  ! 2731: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r11
	mov	0x7e8, %r21
	.word 0xd696e000  ! 2733: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	.word 0xd6a6a000  ! 2734: STWA_I	stwa	%r11, [%r26 + 0x0000] %asi
	.word 0xd6a62000  ! 2735: STWA_I	stwa	%r11, [%r24 + 0x0000] %asi
	.word 0x87802072  ! 2736: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 2737: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a70e80  ! 2738: STWA_R	stwa	%r12, [%r28 + %r0] 0x74
	.word 0xdc87a000  ! 2739: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0x87802074  ! 2740: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2741: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4978e40  ! 2742: LDUHA_R	lduha	[%r30, %r0] 0x72, %r10
	mov	0x3f8, %r22
	.word 0xd0f48400  ! 2744: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xdecc2000  ! 2745: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	.word 0xd2b70e60  ! 2746: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	.word 0xda8f4e40  ! 2747: LDUBA_R	lduba	[%r29, %r0] 0x72, %r13
	.word 0x8780204f  ! 2748: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r19
	.word 0xdeb74e60  ! 2750: STHA_R	stha	%r15, [%r29 + %r0] 0x73
	.word 0xdade09e0  ! 2751: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r13
	.word 0xdcbf6000  ! 2752: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xd0a584a0  ! 2753: STWA_R	stwa	%r8, [%r22 + %r0] 0x25
	.word 0xd0a689e0  ! 2754: STWA_R	stwa	%r8, [%r26 + %r0] 0x4f
	.word 0xdc8f2000  ! 2755: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	mov	0x78, %r27
	mov	0x68, %r25
	.word 0xdcf7e000  ! 2758: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x3d8, %r22
	mov	0x3d8, %r22
	.word 0xd4be49e0  ! 2761: STDA_R	stda	%r10, [%r25 + %r0] 0x4f
	.word 0xd0ac4400  ! 2762: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0x87802072  ! 2763: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebdc4a0  ! 2764: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	.word 0xd094e000  ! 2765: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0xdeb4c400  ! 2766: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xde970e60  ! 2767: LDUHA_R	lduha	[%r28, %r0] 0x73, %r15
	.word 0xd88c2000  ! 2768: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	.word 0xdaaf0e80  ! 2769: STBA_R	stba	%r13, [%r28 + %r0] 0x74
	.word 0x87802020  ! 2770: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r24
	.word 0xd2b7a000  ! 2772: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	mov	0x7f8, %r21
	mov	0x78, %r18
	.word 0xdaa504a0  ! 2775: STWA_R	stwa	%r13, [%r20 + %r0] 0x25
	.word 0xd687a000  ! 2776: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0xde8f4e80  ! 2777: LDUBA_R	lduba	[%r29, %r0] 0x74, %r15
	.word 0x87802072  ! 2778: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 2779: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 2780: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f0, %r23
	.word 0xd2b5c4a0  ! 2782: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	.word 0xd4c78e60  ! 2783: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r10
	.word 0xd4b76000  ! 2784: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd6b5c4a0  ! 2785: STHA_R	stha	%r11, [%r23 + %r0] 0x25
	mov	0x38, %r25
	mov	0x30, %r19
	mov	0x70, %r25
	.word 0xdc9f0e80  ! 2789: LDDA_R	ldda	[%r28, %r0] 0x74, %r14
	.word 0x87802020  ! 2790: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28c6000  ! 2791: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0xd28ca000  ! 2792: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2c46000  ! 2793: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0xd6d78e60  ! 2794: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r11
	.word 0xd0d46000  ! 2795: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r8
	.word 0xd0f46000  ! 2796: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0942000  ! 2797: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r8
	.word 0x87802025  ! 2798: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaf7ce80  ! 2799: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	.word 0xde9c8400  ! 2800: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	.word 0xd2bf6000  ! 2801: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd2b72000  ! 2802: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd2b7e000  ! 2803: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xdcb78e80  ! 2804: STHA_R	stha	%r14, [%r30 + %r0] 0x74
	.word 0xd8dfa000  ! 2805: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8f7e000  ! 2806: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xdcd40400  ! 2807: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	.word 0xdecec9e0  ! 2808: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r15
	.word 0x87802025  ! 2809: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4a7ce80  ! 2810: STWA_R	stwa	%r10, [%r31 + %r0] 0x74
	ta	T_CHANGE_HPRIV	! macro
	.word 0x8780204f  ! 2812: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 2813: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0be89e0  ! 2814: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	.word 0xd2aee000  ! 2815: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	.word 0xd2f6a000  ! 2816: STXA_I	stxa	%r9, [%r26 + 0x0000] %asi
	mov	0x58, %r18
	mov	0x50, %r26
	.word 0xd6dcc400  ! 2819: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	.word 0xd2f70e40  ! 2820: STXA_R	stxa	%r9, [%r28 + %r0] 0x72
	.word 0xd0bea000  ! 2821: STDA_I	stda	%r8, [%r26 + 0x0000] %asi
	.word 0xd0b6e000  ! 2822: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	.word 0xdcdf4e80  ! 2823: LDXA_R	ldxa	[%r29, %r0] 0x74, %r14
	.word 0xdeaf0e40  ! 2824: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	.word 0xd48fce60  ! 2825: LDUBA_R	lduba	[%r31, %r0] 0x73, %r10
	mov	0x8, %r19
	.word 0xd0ce89e0  ! 2827: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r8
	mov	0x40, %r24
	.word 0xdaafce80  ! 2829: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	mov	0x7d8, %r20
	.word 0xd6d6e000  ! 2831: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r11
	mov	0x8, %r25
	.word 0xd686a000  ! 2833: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r11
	.word 0x87802073  ! 2834: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4ddc4a0  ! 2835: LDXA_R	ldxa	[%r23, %r0] 0x25, %r10
	.word 0xdabc6000  ! 2836: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	mov	0x58, %r19
	.word 0xdab46000  ! 2838: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0xda8ce000  ! 2839: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	.word 0xdab42000  ! 2840: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 2841: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab78e80  ! 2842: STHA_R	stha	%r13, [%r30 + %r0] 0x74
	mov	0x20, %r16
	.word 0x87802020  ! 2844: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccfa000  ! 2845: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xdea649e0  ! 2846: STWA_R	stwa	%r15, [%r25 + %r0] 0x4f
	.word 0xd0a72000  ! 2847: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x28, %r24
	.word 0x87802073  ! 2849: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd29f4e60  ! 2850: LDDA_R	ldda	[%r29, %r0] 0x73, %r9
	mov	0x30, %r17
	.word 0x87802025  ! 2852: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4dce000  ! 2853: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	.word 0xd4f4e000  ! 2854: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0xd8a4c400  ! 2855: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	mov	0x50, %r16
	.word 0x87802074  ! 2857: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2858: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdabf4e60  ! 2859: STDA_R	stda	%r13, [%r29 + %r0] 0x73
	mov	0x7c8, %r22
	.word 0xd2c4a000  ! 2861: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	mov	0x20, %r26
	.word 0xd2f46000  ! 2863: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd29f4e80  ! 2864: LDDA_R	ldda	[%r29, %r0] 0x74, %r9
	mov	0x3f0, %r22
	.word 0xdcf78e60  ! 2866: STXA_R	stxa	%r14, [%r30 + %r0] 0x73
	.word 0xdcaf8e80  ! 2867: STBA_R	stba	%r14, [%r30 + %r0] 0x74
	.word 0xd0c4a000  ! 2868: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0bcc400  ! 2869: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802025  ! 2871: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdea74e40  ! 2872: STWA_R	stwa	%r15, [%r29 + %r0] 0x72
	mov	0x20, %r27
	.word 0xd4f78e80  ! 2874: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	.word 0xd69ca000  ! 2875: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r11
	.word 0xd6aca000  ! 2876: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xd6aca000  ! 2877: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	mov	0x60, %r18
	.word 0xd4b44400  ! 2879: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	.word 0xd2974e40  ! 2880: LDUHA_R	lduha	[%r29, %r0] 0x72, %r9
	.word 0xd4f78e80  ! 2881: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	.word 0xdeace000  ! 2882: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xd2dfce40  ! 2883: LDXA_R	ldxa	[%r31, %r0] 0x72, %r9
	mov	0x0, %r18
	.word 0xdebf8e80  ! 2885: STDA_R	stda	%r15, [%r30 + %r0] 0x74
	.word 0x87802073  ! 2886: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4bfe000  ! 2887: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd4af2000  ! 2888: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xdcb74e60  ! 2889: STHA_R	stha	%r14, [%r29 + %r0] 0x73
	mov	0x28, %r19
	.word 0xd8876000  ! 2891: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8dfa000  ! 2892: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	mov	0x38, %r27
	.word 0xd8cfa000  ! 2894: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	mov	0x30, %r26
	.word 0xd4ae09e0  ! 2896: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0xd68d44a0  ! 2897: LDUBA_R	lduba	[%r21, %r0] 0x25, %r11
	.word 0xd8a584a0  ! 2898: STWA_R	stwa	%r12, [%r22 + %r0] 0x25
	.word 0xdc8fa000  ! 2899: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdcd7e000  ! 2900: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xdca72000  ! 2901: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xd8ae49e0  ! 2902: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0x8780204f  ! 2903: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd08609e0  ! 2904: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r8
	.word 0xd4cce000  ! 2905: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	.word 0xd0f4c400  ! 2906: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0xdcbf4e80  ! 2907: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	.word 0xd68c2000  ! 2908: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r11
	.word 0xd6dc2000  ! 2909: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r11
	.word 0x87802072  ! 2910: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6afa000  ! 2911: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xd2afce60  ! 2913: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	mov	0x20, %r16
	mov	0x58, %r18
	.word 0xd8bf4e80  ! 2916: STDA_R	stda	%r12, [%r29 + %r0] 0x74
	.word 0xdcc7e000  ! 2917: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0x87802025  ! 2918: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdea6c9e0  ! 2919: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	.word 0xd89c8400  ! 2920: LDDA_R	ldda	[%r18, %r0] 0x20, %r12
	.word 0xd2b78e60  ! 2921: STHA_R	stha	%r9, [%r30 + %r0] 0x73
	mov	0x40, %r19
	.word 0xd0df4e60  ! 2923: LDXA_R	ldxa	[%r29, %r0] 0x73, %r8
	mov	0x7c0, %r20
	.word 0x87802020  ! 2925: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0c72000  ! 2926: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0dcc400  ! 2927: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0xd28fce40  ! 2928: LDUBA_R	lduba	[%r31, %r0] 0x72, %r9
	mov	0x78, %r27
	.word 0x87802074  ! 2930: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2931: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e0, %r23
	.word 0xde9d84a0  ! 2933: LDDA_R	ldda	[%r22, %r0] 0x25, %r15
	mov	0x7d8, %r21
	.word 0x87802072  ! 2935: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0afe000  ! 2936: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0bf6000  ! 2937: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xdcb78e60  ! 2938: STHA_R	stha	%r14, [%r30 + %r0] 0x73
	.word 0xd0bec9e0  ! 2939: STDA_R	stda	%r8, [%r27 + %r0] 0x4f
	mov	0x3f0, %r22
	.word 0x87802073  ! 2941: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8b46000  ! 2942: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 2943: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2a78e40  ! 2944: STWA_R	stwa	%r9, [%r30 + %r0] 0x72
	.word 0xdabcc400  ! 2945: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	.word 0x87802074  ! 2946: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r24
	mov	0x3d8, %r23
	.word 0xd68fce60  ! 2949: LDUBA_R	lduba	[%r31, %r0] 0x73, %r11
	.word 0xd4ccc400  ! 2950: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0xd8afce60  ! 2951: STBA_R	stba	%r12, [%r31 + %r0] 0x73
	.word 0xd4d584a0  ! 2952: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r10
	mov	0x7d0, %r22
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802020  ! 2955: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabc0400  ! 2956: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	mov	0x60, %r19
	mov	0x28, %r27
	.word 0xd6c78e40  ! 2959: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	mov	0x68, %r26
	.word 0xd8d48400  ! 2961: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	mov	0x20, %r26
	.word 0xd0bc8400  ! 2963: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0xd2a504a0  ! 2964: STWA_R	stwa	%r9, [%r20 + %r0] 0x25
	.word 0xdc9c4400  ! 2965: LDDA_R	ldda	[%r17, %r0] 0x20, %r14
	.word 0xd68f8e60  ! 2966: LDUBA_R	lduba	[%r30, %r0] 0x73, %r11
	mov	0x68, %r26
	mov	0x7d0, %r21
	.word 0xdaa70e80  ! 2969: STWA_R	stwa	%r13, [%r28 + %r0] 0x74
	mov	0x78, %r24
	.word 0x8780204f  ! 2971: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdca4c400  ! 2972: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0x87802025  ! 2973: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r18
	.word 0xdec5c4a0  ! 2975: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r15
	mov	0x28, %r19
	.word 0xd0cea000  ! 2977: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r8
	.word 0xd096e000  ! 2978: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r8
	.word 0xd2d5c4a0  ! 2979: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r9
	mov	0x3e0, %r22
	.word 0xd2bd04a0  ! 2981: STDA_R	stda	%r9, [%r20 + %r0] 0x25
	.word 0x87802025  ! 2982: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 2983: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r17
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd8bc6000  ! 2986: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0xde8f4e80  ! 2987: LDUBA_R	lduba	[%r29, %r0] 0x74, %r15
	.word 0xd2a42000  ! 2988: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	.word 0xd29ce000  ! 2989: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0x87802073  ! 2990: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4a70e40  ! 2991: STWA_R	stwa	%r10, [%r28 + %r0] 0x72
	.word 0xd6f74e80  ! 2992: STXA_R	stxa	%r11, [%r29 + %r0] 0x74
	.word 0x87802020  ! 2993: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a52000  ! 2994: STWA_I	stwa	%r10, [%r20 + 0x0000] %asi
	mov	0x78, %r25
	.word 0x87802073  ! 2996: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd49f6000  ! 2997: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	mov	0x7f0, %r23
	mov	0x7f0, %r21
	.word 0xd48f6000  ! 3000: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	mov	0x58, %r25
	mov	0x3e0, %r21
	.word 0xdcf70e80  ! 3003: STXA_R	stxa	%r14, [%r28 + %r0] 0x74
	.word 0xd6f76000  ! 3004: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 3005: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b78e40  ! 3006: STHA_R	stha	%r10, [%r30 + %r0] 0x72
	mov	0x10, %r16
	.word 0xdaaf6000  ! 3008: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 3009: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf5a000  ! 3010: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xd4a4c400  ! 3011: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	mov	0x58, %r19
	mov	0x3f0, %r22
	.word 0xdabd2000  ! 3014: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	.word 0xda9de000  ! 3015: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3016: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9f6000  ! 3017: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xdacf6000  ! 3018: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xdcbf4e80  ! 3019: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	mov	0x58, %r24
	mov	0x7c0, %r20
	.word 0xd4b649e0  ! 3022: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	.word 0x8780204f  ! 3023: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4cf0e60  ! 3024: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r10
	mov	0x18, %r24
	mov	0x3d8, %r21
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802020  ! 3028: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r26
	.word 0xd68f0e40  ! 3030: LDUBA_R	lduba	[%r28, %r0] 0x72, %r11
	.word 0xd2b76000  ! 3031: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 3032: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 3033: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bf2000  ! 3034: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd2972000  ! 3035: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xd2a7a000  ! 3036: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	mov	0x10, %r17
	.word 0xd2bf2000  ! 3038: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	mov	0x10, %r25
	mov	0x7f8, %r21
	.word 0xd0acc400  ! 3041: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd6af6000  ! 3042: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd6f72000  ! 3043: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 3044: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6c66000  ! 3045: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r11
	.word 0xd686e000  ! 3046: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r11
	mov	0x3d8, %r20
	.word 0xd68e2000  ! 3048: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r11
	.word 0xd0c74e60  ! 3049: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r8
	mov	0x7c8, %r23
	mov	0x38, %r26
	.word 0xd0dd84a0  ! 3052: LDXA_R	ldxa	[%r22, %r0] 0x25, %r8
	.word 0xd8878e40  ! 3053: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r12
	.word 0xdac48400  ! 3054: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	.word 0xd6f6e000  ! 3055: STXA_I	stxa	%r11, [%r27 + 0x0000] %asi
	.word 0xd0b5c4a0  ! 3056: STHA_R	stha	%r8, [%r23 + %r0] 0x25
	.word 0xdc870e80  ! 3057: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r14
	.word 0xd49f8e40  ! 3058: LDDA_R	ldda	[%r30, %r0] 0x72, %r10
	.word 0xde8f4e80  ! 3059: LDUBA_R	lduba	[%r29, %r0] 0x74, %r15
	.word 0x87802072  ! 3060: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd48f6000  ! 3061: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xd4c7e000  ! 3062: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	.word 0xdeac8400  ! 3063: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	mov	0x40, %r27
	.word 0xd2872000  ! 3065: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	mov	0x50, %r18
	.word 0xd2b76000  ! 3067: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2f76000  ! 3068: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	mov	0x68, %r24
	.word 0xd2bfa000  ! 3070: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	mov	0x30, %r24
	.word 0xdcb7ce80  ! 3072: STHA_R	stha	%r14, [%r31 + %r0] 0x74
	.word 0xd2a7a000  ! 3073: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xd8b70e40  ! 3074: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0xd0a584a0  ! 3075: STWA_R	stwa	%r8, [%r22 + %r0] 0x25
	.word 0xd684c400  ! 3076: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	.word 0xdc9f2000  ! 3077: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xdc972000  ! 3078: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	.word 0xdcb76000  ! 3079: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	mov	0x40, %r27
	.word 0xdcc7e000  ! 3081: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0xdeae09e0  ! 3082: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	.word 0xd2dc4400  ! 3083: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xdc8f6000  ! 3084: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xd4a584a0  ! 3085: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	.word 0xd4b72000  ! 3086: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd4af4e80  ! 3087: STBA_R	stba	%r10, [%r29 + %r0] 0x74
	.word 0x87802074  ! 3088: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8be89e0  ! 3089: STDA_R	stda	%r12, [%r26 + %r0] 0x4f
	mov	0x68, %r26
	mov	0x28, %r25
	mov	0x8, %r24
	.word 0xdeb7e000  ! 3093: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	mov	0x38, %r24
	.word 0xdecfa000  ! 3095: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xdaaf0e60  ! 3096: STBA_R	stba	%r13, [%r28 + %r0] 0x73
	.word 0xd0af4e80  ! 3097: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	.word 0xdabf0e80  ! 3098: STDA_R	stda	%r13, [%r28 + %r0] 0x74
	.word 0xd8f6c9e0  ! 3099: STXA_R	stxa	%r12, [%r27 + %r0] 0x4f
	mov	0x3c0, %r22
	.word 0xd0df2000  ! 3101: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	mov	0x30, %r19
	.word 0xd0f7ce40  ! 3103: STXA_R	stxa	%r8, [%r31 + %r0] 0x72
	mov	0x68, %r27
	mov	0x50, %r19
	mov	0x50, %r18
	mov	0x60, %r24
	mov	0x20, %r27
	.word 0xd2f70e80  ! 3109: STXA_R	stxa	%r9, [%r28 + %r0] 0x74
	mov	0x3f8, %r21
	.word 0xdc8fe000  ! 3111: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	mov	0x68, %r17
	.word 0x87802073  ! 3113: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc9f6000  ! 3114: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xda9f4e80  ! 3115: LDDA_R	ldda	[%r29, %r0] 0x74, %r13
	.word 0x87802020  ! 3116: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcc649e0  ! 3117: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r14
	.word 0xd4ace000  ! 3118: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	mov	0x60, %r17
	mov	0x8, %r18
	mov	0x0, %r27
	mov	0x7c0, %r21
	.word 0xd48c6000  ! 3123: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r10
	.word 0xdc8fce60  ! 3124: LDUBA_R	lduba	[%r31, %r0] 0x73, %r14
	.word 0xde84a000  ! 3125: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	.word 0xd4f78e60  ! 3126: STXA_R	stxa	%r10, [%r30 + %r0] 0x73
	.word 0xd6a46000  ! 3127: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3128: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r20
	.word 0xd6a72000  ! 3130: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 3131: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf4c400  ! 3132: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	mov	0x50, %r19
	.word 0xd2f689e0  ! 3134: STXA_R	stxa	%r9, [%r26 + %r0] 0x4f
	.word 0xdc9d44a0  ! 3135: LDDA_R	ldda	[%r21, %r0] 0x25, %r14
	.word 0xd6cfa000  ! 3136: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0xd0a6c9e0  ! 3137: STWA_R	stwa	%r8, [%r27 + %r0] 0x4f
	.word 0xd8df6000  ! 3138: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0x87802020  ! 3139: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r24
	.word 0xd8d72000  ! 3141: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xd8af4e40  ! 3142: STBA_R	stba	%r12, [%r29 + %r0] 0x72
	.word 0xd0d78e40  ! 3143: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r8
	mov	0x20, %r16
	mov	0x10, %r27
	.word 0xda948400  ! 3146: LDUHA_R	lduha	[%r18, %r0] 0x20, %r13
	.word 0x87802025  ! 3147: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802074  ! 3149: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef44400  ! 3150: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xd6c7ce80  ! 3151: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r11
	.word 0xd6afa000  ! 3152: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6d72000  ! 3153: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r11
	.word 0xd687a000  ! 3154: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6f76000  ! 3155: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	mov	0x8, %r27
	.word 0xd2a74e80  ! 3157: STWA_R	stwa	%r9, [%r29 + %r0] 0x74
	.word 0xd28f2000  ! 3158: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	mov	0x7f0, %r20
	.word 0xd2b76000  ! 3160: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd6a48400  ! 3161: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0xd8a74e80  ! 3162: STWA_R	stwa	%r12, [%r29 + %r0] 0x74
	.word 0xded72000  ! 3163: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xde872000  ! 3164: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xde9f2000  ! 3165: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xdef76000  ! 3166: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdedf2000  ! 3167: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	mov	0x7d8, %r21
	.word 0xdeafa000  ! 3169: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xdea72000  ! 3170: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	mov	0x50, %r27
	mov	0x7d0, %r23
	.word 0xdec76000  ! 3173: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xd4f584a0  ! 3174: STXA_R	stxa	%r10, [%r22 + %r0] 0x25
	.word 0x87802020  ! 3175: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea70e80  ! 3176: STWA_R	stwa	%r15, [%r28 + %r0] 0x74
	.word 0xdeaf0e80  ! 3177: STBA_R	stba	%r15, [%r28 + %r0] 0x74
	.word 0xdcf7a000  ! 3178: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x50, %r24
	.word 0xd8c48400  ! 3180: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	.word 0xd2f72000  ! 3181: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	mov	0x58, %r24
	.word 0xd29f0e60  ! 3183: LDDA_R	ldda	[%r28, %r0] 0x73, %r9
	.word 0x87802072  ! 3184: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcace000  ! 3185: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 3186: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcd56000  ! 3187: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r14
	.word 0x87802073  ! 3188: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r17
	.word 0xdcd72000  ! 3190: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xd6adc4a0  ! 3191: STBA_R	stba	%r11, [%r23 + %r0] 0x25
	mov	0x30, %r19
	mov	0x20, %r25
	mov	0x3d0, %r20
	.word 0xd296c9e0  ! 3195: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r9
	.word 0xd8f7a000  ! 3196: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	mov	0x3c8, %r22
	.word 0x87802020  ! 3198: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8842000  ! 3199: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	mov	0x68, %r24
	mov	0x7c8, %r20
	.word 0xd4bf0e60  ! 3202: STDA_R	stda	%r10, [%r28 + %r0] 0x73
	.word 0x8780204f  ! 3203: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c8, %r23
	.word 0xd2c649e0  ! 3205: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r9
	.word 0xded609e0  ! 3206: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r15
	.word 0xd2d46000  ! 3207: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	.word 0x87802025  ! 3208: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca7ce40  ! 3209: STWA_R	stwa	%r14, [%r31 + %r0] 0x72
	.word 0xdcd7e000  ! 3210: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xd6840400  ! 3211: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	mov	0x18, %r24
	.word 0xdcf72000  ! 3213: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xdcf72000  ! 3215: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 3216: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcac2000  ! 3217: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xda95c4a0  ! 3219: LDUHA_R	lduha	[%r23, %r0] 0x25, %r13
	.word 0xd8d42000  ! 3220: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0x87802073  ! 3221: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8ad6000  ! 3222: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	.word 0xd8dda000  ! 3223: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r12
	.word 0x87802072  ! 3224: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0f78e80  ! 3225: STXA_R	stxa	%r8, [%r30 + %r0] 0x74
	mov	0x40, %r17
	.word 0x8780204f  ! 3227: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde9dc4a0  ! 3228: LDDA_R	ldda	[%r23, %r0] 0x25, %r15
	mov	0x50, %r25
	mov	0x70, %r19
	mov	0x78, %r25
	mov	0x18, %r24
	.word 0xd4df2000  ! 3233: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0x87802020  ! 3234: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4aca000  ! 3235: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	mov	0x70, %r24
	.word 0xdc944400  ! 3237: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	.word 0xda844400  ! 3238: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r13
	.word 0xd0f7ce60  ! 3239: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	mov	0x30, %r24
	mov	0x28, %r19
	.word 0x87802025  ! 3242: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f0, %r23
	mov	0x7c0, %r23
	.word 0xde87a000  ! 3245: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xd28609e0  ! 3246: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r9
	.word 0xd6bf6000  ! 3247: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd8a44400  ! 3248: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xd6cdc4a0  ! 3249: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r11
	.word 0x87802074  ! 3250: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6df4e60  ! 3251: LDXA_R	ldxa	[%r29, %r0] 0x73, %r11
	.word 0x87802020  ! 3252: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3253: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r20
	.word 0xdab6c9e0  ! 3255: STHA_R	stha	%r13, [%r27 + %r0] 0x4f
	.word 0xd6af0e40  ! 3256: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	mov	0x7d0, %r21
	.word 0xd2dd2000  ! 3258: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r9
	mov	0x7c0, %r23
	.word 0xdaaf8e40  ! 3260: STBA_R	stba	%r13, [%r30 + %r0] 0x72
	mov	0x7e0, %r20
	.word 0xda9d6000  ! 3262: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r13
	.word 0xdaa5e000  ! 3263: STWA_I	stwa	%r13, [%r23 + 0x0000] %asi
	.word 0xdaa5e000  ! 3264: STWA_I	stwa	%r13, [%r23 + 0x0000] %asi
	.word 0xdac56000  ! 3265: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r13
	mov	0x7f8, %r22
	.word 0xd49e09e0  ! 3267: LDDA_R	ldda	[%r24, %r0] 0x4f, %r10
	.word 0xdef56000  ! 3268: STXA_I	stxa	%r15, [%r21 + 0x0000] %asi
	.word 0xdebde000  ! 3269: STDA_I	stda	%r15, [%r23 + 0x0000] %asi
	mov	0x8, %r26
	.word 0xd2870e80  ! 3271: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r9
	.word 0xdecde000  ! 3272: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r15
	mov	0x28, %r17
	mov	0x68, %r18
	mov	0x48, %r16
	.word 0xde8da000  ! 3276: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r15
	.word 0xd2ad44a0  ! 3277: STBA_R	stba	%r9, [%r21 + %r0] 0x25
	.word 0xdaa5e000  ! 3278: STWA_I	stwa	%r13, [%r23 + 0x0000] %asi
	.word 0x87802073  ! 3279: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdacfa000  ! 3280: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xda972000  ! 3281: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0xdaf7a000  ! 3282: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 3283: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4acc400  ! 3284: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xd2a70e40  ! 3285: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	.word 0xd2be2000  ! 3286: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	.word 0xd2be2000  ! 3287: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	.word 0xd2cf4e40  ! 3288: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r9
	.word 0xdabf0e40  ! 3289: STDA_R	stda	%r13, [%r28 + %r0] 0x72
	.word 0xd6866000  ! 3290: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r11
	mov	0x7f8, %r20
	.word 0xd6978e60  ! 3292: LDUHA_R	lduha	[%r30, %r0] 0x73, %r11
	mov	0x8, %r26
	.word 0xdaa6e000  ! 3294: STWA_I	stwa	%r13, [%r27 + 0x0000] %asi
	mov	0x7f8, %r23
	.word 0xdabee000  ! 3296: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	.word 0xdabe2000  ! 3297: STDA_I	stda	%r13, [%r24 + 0x0000] %asi
	.word 0xda962000  ! 3298: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r13
	.word 0xda86e000  ! 3299: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r13
	mov	0x58, %r25
	.word 0xd2a7ce80  ! 3301: STWA_R	stwa	%r9, [%r31 + %r0] 0x74
	.word 0xd0f6e000  ! 3302: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	.word 0xd0962000  ! 3303: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r8
	.word 0xd6b70e40  ! 3304: STHA_R	stha	%r11, [%r28 + %r0] 0x72
	.word 0xdeb48400  ! 3305: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	mov	0x3d0, %r23
	.word 0x87802072  ! 3307: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8c48400  ! 3308: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	mov	0x18, %r27
	.word 0xdccfa000  ! 3310: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xdc8f2000  ! 3311: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0x87802020  ! 3312: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r22
	mov	0x70, %r24
	.word 0xdccd44a0  ! 3315: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r14
	.word 0xda8649e0  ! 3316: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r13
	.word 0xdab72000  ! 3317: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xd4bc0400  ! 3318: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xda9f6000  ! 3319: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	mov	0x40, %r27
	mov	0x7e0, %r20
	.word 0xd4bec9e0  ! 3322: STDA_R	stda	%r10, [%r27 + %r0] 0x4f
	.word 0xd2bec9e0  ! 3323: STDA_R	stda	%r9, [%r27 + %r0] 0x4f
	.word 0xd6f649e0  ! 3324: STXA_R	stxa	%r11, [%r25 + %r0] 0x4f
	.word 0xd6c7ce40  ! 3325: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r11
	.word 0xd6b7a000  ! 3326: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd6876000  ! 3327: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	.word 0xdcbc4400  ! 3328: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0x87802020  ! 3329: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cd6000  ! 3330: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r9
	.word 0xd2dd6000  ! 3331: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r9
	.word 0xd8afce40  ! 3332: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	.word 0xdc9da000  ! 3333: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 3334: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde9f8e40  ! 3335: LDDA_R	ldda	[%r30, %r0] 0x72, %r15
	.word 0xd0dfa000  ! 3336: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0bf2000  ! 3337: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xd087e000  ! 3338: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0xd68544a0  ! 3339: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r11
	.word 0xdcf76000  ! 3340: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 3341: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r24
	.word 0xd2a74e80  ! 3343: STWA_R	stwa	%r9, [%r29 + %r0] 0x74
	.word 0xd6842000  ! 3344: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r11
	.word 0xd694e000  ! 3345: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r11
	.word 0xd4dcc400  ! 3346: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0xd8d6c9e0  ! 3347: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r12
	.word 0xdef74e80  ! 3348: STXA_R	stxa	%r15, [%r29 + %r0] 0x74
	.word 0xd4874e40  ! 3349: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r10
	.word 0xdebce000  ! 3350: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 3351: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6de49e0  ! 3352: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r11
	.word 0xd8878e80  ! 3353: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r12
	.word 0xdea7ce40  ! 3354: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 3355: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6a76000  ! 3356: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 3357: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r16
	.word 0x87802020  ! 3359: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcd689e0  ! 3360: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r14
	.word 0xd88609e0  ! 3361: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r12
	mov	0x3f8, %r23
	mov	0x7d0, %r22
	.word 0xd0c40400  ! 3364: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	.word 0x8780204f  ! 3365: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f8, %r22
	.word 0xdc870e80  ! 3367: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r14
	.word 0xdea44400  ! 3368: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0x87802072  ! 3369: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd486e000  ! 3370: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	.word 0xd4a6e000  ! 3371: STWA_I	stwa	%r10, [%r27 + 0x0000] %asi
	.word 0xd0c74e80  ! 3372: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r8
	.word 0xd48ee000  ! 3373: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r10
	.word 0xd6b7ce40  ! 3374: STHA_R	stha	%r11, [%r31 + %r0] 0x72
	.word 0xd8ad84a0  ! 3375: STBA_R	stba	%r12, [%r22 + %r0] 0x25
	.word 0xd4be2000  ! 3376: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	.word 0xd4a6a000  ! 3377: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	mov	0x8, %r25
	.word 0xd4dee000  ! 3379: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r10
	.word 0xd486a000  ! 3380: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r10
	.word 0xd496e000  ! 3381: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r10
	.word 0xd8f70e80  ! 3382: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	mov	0x10, %r19
	.word 0xdebea000  ! 3384: STDA_I	stda	%r15, [%r26 + 0x0000] %asi
	.word 0xdef6e000  ! 3385: STXA_I	stxa	%r15, [%r27 + 0x0000] %asi
	.word 0xde96a000  ! 3386: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r15
	.word 0xdea6c9e0  ! 3387: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	mov	0x20, %r16
	.word 0x87802074  ! 3389: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bde000  ! 3390: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 3391: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2946000  ! 3392: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r9
	mov	0x3e0, %r21
	.word 0xd2f42000  ! 3394: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	mov	0x3d0, %r23
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2d4e000  ! 3397: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	mov	0x18, %r24
	.word 0xd2942000  ! 3399: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2ace000  ! 3400: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	mov	0x70, %r18
	.word 0xd6df0e80  ! 3402: LDXA_R	ldxa	[%r28, %r0] 0x74, %r11
	.word 0xd0842000  ! 3403: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r8
	.word 0xd0b4e000  ! 3404: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xd8d48400  ! 3405: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0x87802073  ! 3406: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde97e000  ! 3407: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0xdebf6000  ! 3408: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xdea76000  ! 3409: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xdad504a0  ! 3410: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r13
	.word 0xd2bf6000  ! 3411: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 3412: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4cf4e60  ! 3413: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r10
	.word 0xd29fce80  ! 3414: LDDA_R	ldda	[%r31, %r0] 0x74, %r9
	mov	0x3f8, %r21
	.word 0xd6bf8e60  ! 3416: STDA_R	stda	%r11, [%r30 + %r0] 0x73
	.word 0xd496a000  ! 3417: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r10
	.word 0xdac74e60  ! 3418: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r13
	.word 0xd28ee000  ! 3419: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r9
	.word 0xd2c66000  ! 3420: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r9
	.word 0xd8ddc4a0  ! 3421: LDXA_R	ldxa	[%r23, %r0] 0x25, %r12
	.word 0xdaae6000  ! 3422: STBA_I	stba	%r13, [%r25 + 0x0000] %asi
	.word 0xdadee000  ! 3423: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r13
	.word 0xdadee000  ! 3424: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r13
	mov	0x7e0, %r21
	mov	0x8, %r16
	.word 0xd2f689e0  ! 3427: STXA_R	stxa	%r9, [%r26 + %r0] 0x4f
	.word 0xd0aec9e0  ! 3428: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	mov	0x3e8, %r21
	.word 0xdedea000  ! 3430: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r15
	.word 0xd8a78e80  ! 3431: STWA_R	stwa	%r12, [%r30 + %r0] 0x74
	mov	0x7d8, %r20
	.word 0xdac7ce80  ! 3433: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r13
	.word 0xd2a62000  ! 3434: STWA_I	stwa	%r9, [%r24 + 0x0000] %asi
	.word 0x8780204f  ! 3435: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2dc0400  ! 3436: LDXA_R	ldxa	[%r16, %r0] 0x20, %r9
	.word 0x87802073  ! 3437: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8ae2000  ! 3438: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	.word 0xd0df4e80  ! 3439: LDXA_R	ldxa	[%r29, %r0] 0x74, %r8
	.word 0x87802074  ! 3440: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f4e000  ! 3441: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 3442: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2b72000  ! 3443: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	mov	0x50, %r17
	.word 0x87802020  ! 3445: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b74e80  ! 3446: STHA_R	stha	%r11, [%r29 + %r0] 0x74
	.word 0xd48f0e60  ! 3447: LDUBA_R	lduba	[%r28, %r0] 0x73, %r10
	.word 0xd0974e40  ! 3448: LDUHA_R	lduha	[%r29, %r0] 0x72, %r8
	.word 0xdacc6000  ! 3449: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	.word 0xdcaf4e60  ! 3450: STBA_R	stba	%r14, [%r29 + %r0] 0x73
	.word 0xdab42000  ! 3451: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	mov	0x28, %r25
	.word 0x87802025  ! 3453: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda876000  ! 3454: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3455: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0af8e40  ! 3456: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0xdebce000  ! 3457: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xdcdf8e60  ! 3458: LDXA_R	ldxa	[%r30, %r0] 0x73, %r14
	mov	0x3e8, %r22
	mov	0x8, %r19
	mov	0x7d8, %r21
	.word 0xdedc6000  ! 3462: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r15
	.word 0xd4b7ce80  ! 3463: STHA_R	stha	%r10, [%r31 + %r0] 0x74
	.word 0xd09fce40  ! 3464: LDDA_R	ldda	[%r31, %r0] 0x72, %r8
	.word 0xd6df8e40  ! 3465: LDXA_R	ldxa	[%r30, %r0] 0x72, %r11
	.word 0xdcd609e0  ! 3466: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r14
	.word 0xde8c0400  ! 3467: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0xdabc0400  ! 3468: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	mov	0x7e0, %r22
	.word 0xd0cca000  ! 3470: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	.word 0xd0942000  ! 3471: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r8
	mov	0x7d8, %r21
	.word 0xdccd84a0  ! 3473: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r14
	.word 0x87802072  ! 3474: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc97e000  ! 3475: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xdcb7e000  ! 3476: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xd4d48400  ! 3477: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	.word 0xdef76000  ! 3478: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdef7a000  ! 3479: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	mov	0x3d8, %r22
	mov	0x30, %r18
	.word 0xdeb7a000  ! 3482: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	mov	0x78, %r24
	mov	0x0, %r24
	.word 0xdcdf0e60  ! 3485: LDXA_R	ldxa	[%r28, %r0] 0x73, %r14
	.word 0xdedd04a0  ! 3486: LDXA_R	ldxa	[%r20, %r0] 0x25, %r15
	.word 0xdca7a000  ! 3487: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xd2d649e0  ! 3488: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r9
	.word 0xdcf40400  ! 3489: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xd4a78e80  ! 3490: STWA_R	stwa	%r10, [%r30 + %r0] 0x74
	.word 0x87802073  ! 3491: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b72000  ! 3492: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd2dc0400  ! 3493: LDXA_R	ldxa	[%r16, %r0] 0x20, %r9
	.word 0xdef76000  ! 3494: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xd6b7ce80  ! 3495: STHA_R	stha	%r11, [%r31 + %r0] 0x74
	.word 0x87802020  ! 3496: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cda000  ! 3497: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r11
	.word 0xd6b44400  ! 3498: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xd8dd2000  ! 3499: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r12
	.word 0xd89da000  ! 3500: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r12
	mov	0x10, %r16
	.word 0xd885e000  ! 3502: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r12
	.word 0x87802073  ! 3503: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd88f2000  ! 3504: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	mov	0x38, %r19
	mov	0x28, %r27
	.word 0xd8c72000  ! 3507: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0x87802074  ! 3508: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3509: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r23
	.word 0xd8b7e000  ! 3511: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0xd8af6000  ! 3512: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xdabf4e40  ! 3513: STDA_R	stda	%r13, [%r29 + %r0] 0x72
	.word 0xdabcc400  ! 3514: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	.word 0xd8d44400  ! 3515: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	.word 0xdcdfa000  ! 3516: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcdfa000  ! 3517: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	.word 0xde94c400  ! 3518: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	.word 0xd4d76000  ! 3519: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0xd6af0e60  ! 3520: STBA_R	stba	%r11, [%r28 + %r0] 0x73
	.word 0x87802020  ! 3521: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4940400  ! 3522: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	.word 0xd68c4400  ! 3523: LDUBA_R	lduba	[%r17, %r0] 0x20, %r11
	.word 0xd8c7ce60  ! 3524: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r12
	.word 0x87802073  ! 3525: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3526: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc870e60  ! 3527: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r14
	.word 0xdea4c400  ! 3528: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	.word 0xd4d48400  ! 3529: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	mov	0x38, %r26
	.word 0x87802074  ! 3531: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3532: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef72000  ! 3533: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xdeb7a000  ! 3534: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xd8cf4e60  ! 3535: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r12
	.word 0xd28f6000  ! 3536: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd297ce40  ! 3537: LDUHA_R	lduha	[%r31, %r0] 0x72, %r9
	.word 0xdedfa000  ! 3538: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x18, %r27
	.word 0x8780204f  ! 3540: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bdc4a0  ! 3541: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	mov	0x68, %r17
	.word 0x87802020  ! 3543: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r18
	.word 0x87802073  ! 3545: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc952000  ! 3546: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r14
	mov	0x3d0, %r20
	.word 0xd0cf4e80  ! 3548: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r8
	mov	0x7f8, %r23
	mov	0x8, %r19
	.word 0xd4f52000  ! 3551: STXA_I	stxa	%r10, [%r20 + 0x0000] %asi
	.word 0x87802025  ! 3552: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbc0400  ! 3553: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0xdaa7e000  ! 3554: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xdcdfce80  ! 3555: LDXA_R	ldxa	[%r31, %r0] 0x74, %r14
	mov	0x18, %r16
	mov	0x38, %r25
	.word 0xda8fa000  ! 3558: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xd88e49e0  ! 3559: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r12
	.word 0xd0f76000  ! 3560: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0f76000  ! 3561: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xd09d84a0  ! 3563: LDDA_R	ldda	[%r22, %r0] 0x25, %r8
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcf76000  ! 3565: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x8, %r18
	.word 0xdc8f6000  ! 3567: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xd2d78e40  ! 3568: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r9
	.word 0xd487e000  ! 3569: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 3570: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd89f0e60  ! 3571: LDDA_R	ldda	[%r28, %r0] 0x73, %r12
	.word 0x87802020  ! 3572: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c6a000  ! 3573: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r12
	mov	0x7e8, %r21
	.word 0xd8de6000  ! 3575: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r12
	.word 0xd0bdc4a0  ! 3576: STDA_R	stda	%r8, [%r23 + %r0] 0x25
	.word 0xd0ccc400  ! 3577: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	.word 0x87802073  ! 3578: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8ae89e0  ! 3579: STBA_R	stba	%r12, [%r26 + %r0] 0x4f
	.word 0xd8976000  ! 3580: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	mov	0x3c8, %r23
	.word 0xd69c8400  ! 3582: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	.word 0xdcbec9e0  ! 3583: STDA_R	stda	%r14, [%r27 + %r0] 0x4f
	mov	0x20, %r18
	.word 0xd8bf2000  ! 3585: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	mov	0x3e0, %r21
	.word 0xdc948400  ! 3587: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	.word 0xdedfe000  ! 3588: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xdca44400  ! 3589: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0xded76000  ! 3590: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 3591: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde8d04a0  ! 3592: LDUBA_R	lduba	[%r20, %r0] 0x25, %r15
	.word 0xd88ca000  ! 3593: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	.word 0xd4d70e60  ! 3594: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r10
	.word 0xd8b40400  ! 3595: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xdeac2000  ! 3596: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 3597: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6be89e0  ! 3598: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	.word 0x87802073  ! 3599: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8c4e000  ! 3600: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	.word 0x87802020  ! 3601: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8976000  ! 3602: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0xd8af6000  ! 3603: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xded5c4a0  ! 3604: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r15
	.word 0x87802074  ! 3605: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 3606: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x48, %r18
	mov	0x48, %r25
	.word 0xded76000  ! 3609: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0xd4f70e40  ! 3610: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	.word 0x8780204f  ! 3611: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r24
	mov	0x60, %r18
	.word 0xdabc2000  ! 3614: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xdacc2000  ! 3615: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	mov	0x0, %r16
	.word 0x8780204f  ! 3617: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa4a000  ! 3618: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xdeaec9e0  ! 3619: STBA_R	stba	%r15, [%r27 + %r0] 0x4f
	.word 0xdea46000  ! 3620: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	mov	0x78, %r19
	.word 0xdea40400  ! 3622: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xdcaf0e60  ! 3623: STBA_R	stba	%r14, [%r28 + %r0] 0x73
	.word 0xd2f4e000  ! 3624: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xdace09e0  ! 3625: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r13
	mov	0x50, %r17
	.word 0xd8cca000  ! 3627: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r12
	.word 0xd2a5c4a0  ! 3628: STWA_R	stwa	%r9, [%r23 + %r0] 0x25
	.word 0x87802025  ! 3629: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0972000  ! 3630: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0f44400  ! 3631: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd2aec9e0  ! 3632: STBA_R	stba	%r9, [%r27 + %r0] 0x4f
	.word 0xd0ae09e0  ! 3633: STBA_R	stba	%r8, [%r24 + %r0] 0x4f
	.word 0xd4afe000  ! 3634: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 3635: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4876000  ! 3636: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4bfa000  ! 3637: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd0c649e0  ! 3638: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r8
	.word 0xde9d84a0  ! 3639: LDDA_R	ldda	[%r22, %r0] 0x25, %r15
	.word 0xd6af6000  ! 3640: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd68fa000  ! 3641: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0xdaf7ce60  ! 3642: STXA_R	stxa	%r13, [%r31 + %r0] 0x73
	.word 0xd0d609e0  ! 3643: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r8
	.word 0xd49fe000  ! 3644: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd0be49e0  ! 3645: STDA_R	stda	%r8, [%r25 + %r0] 0x4f
	.word 0x87802072  ! 3646: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdec74e40  ! 3647: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r15
	mov	0x40, %r26
	.word 0x8780204f  ! 3649: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 3650: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b649e0  ! 3651: STHA_R	stha	%r9, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 3652: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b6e000  ! 3653: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	.word 0xde944400  ! 3654: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	.word 0x87802073  ! 3655: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8bce000  ! 3656: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	mov	0x7f8, %r23
	.word 0x87802020  ! 3658: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r23
	.word 0x87802074  ! 3660: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 3661: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf7ce40  ! 3662: STXA_R	stxa	%r14, [%r31 + %r0] 0x72
	.word 0x87802020  ! 3663: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3664: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r19
	.word 0xd28fa000  ! 3666: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	.word 0xd2afe000  ! 3667: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd2cfe000  ! 3668: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	.word 0xd2f76000  ! 3669: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xd297e000  ! 3670: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	.word 0xd29f6000  ! 3671: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3672: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b78e60  ! 3673: STHA_R	stha	%r9, [%r30 + %r0] 0x73
	.word 0xda846000  ! 3674: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r13
	mov	0x3c0, %r23
	mov	0x28, %r25
	.word 0xdaace000  ! 3677: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0xd8ce49e0  ! 3678: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r12
	.word 0xdaf46000  ! 3679: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0xdad609e0  ! 3680: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r13
	.word 0xdea42000  ! 3681: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xd8f70e80  ! 3682: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	.word 0xde8ca000  ! 3683: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	mov	0x20, %r24
	.word 0xd6bfce60  ! 3685: STDA_R	stda	%r11, [%r31 + %r0] 0x73
	.word 0xdcf46000  ! 3686: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xd2d70e60  ! 3687: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r9
	.word 0xdcb4c400  ! 3688: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xd4b46000  ! 3689: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xde9fce40  ! 3690: LDDA_R	ldda	[%r31, %r0] 0x72, %r15
	.word 0xdca42000  ! 3691: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xd0a70e80  ! 3692: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0xd8cc2000  ! 3693: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r12
	.word 0xd49c4400  ! 3694: LDDA_R	ldda	[%r17, %r0] 0x20, %r10
	mov	0x8, %r16
	.word 0xdcad84a0  ! 3696: STBA_R	stba	%r14, [%r22 + %r0] 0x25
	.word 0xd08ca000  ! 3697: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xd084e000  ! 3698: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	.word 0xd49f8e40  ! 3699: LDDA_R	ldda	[%r30, %r0] 0x72, %r10
	.word 0x87802074  ! 3700: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r22
	mov	0x18, %r18
	.word 0xd4a5e000  ! 3703: STWA_I	stwa	%r10, [%r23 + 0x0000] %asi
	.word 0xd48da000  ! 3704: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r10
	.word 0xd4dde000  ! 3705: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r10
	.word 0xd2f78e60  ! 3706: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0xd6dde000  ! 3707: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3708: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3709: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r21
	.word 0xdef649e0  ! 3711: STXA_R	stxa	%r15, [%r25 + %r0] 0x4f
	mov	0x40, %r18
	mov	0x7d8, %r21
	.word 0xd4af8e60  ! 3714: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	.word 0xde9fa000  ! 3715: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3716: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9de000  ! 3717: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r15
	mov	0x78, %r16
	.word 0xded5e000  ! 3719: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r15
	.word 0xdeb5a000  ! 3720: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	mov	0x38, %r27
	mov	0x40, %r25
	.word 0xde856000  ! 3723: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r15
	.word 0xdaaf8e80  ! 3724: STBA_R	stba	%r13, [%r30 + %r0] 0x74
	mov	0x3d8, %r20
	.word 0xdc852000  ! 3726: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r14
	.word 0xdca5e000  ! 3727: STWA_I	stwa	%r14, [%r23 + 0x0000] %asi
	.word 0xd0a74e60  ! 3728: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	.word 0x87802020  ! 3729: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68f4e80  ! 3730: LDUBA_R	lduba	[%r29, %r0] 0x74, %r11
	mov	0x8, %r17
	.word 0xd0f66000  ! 3732: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	.word 0xd086e000  ! 3733: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r8
	.word 0xd2f7ce60  ! 3734: STXA_R	stxa	%r9, [%r31 + %r0] 0x73
	.word 0xd4ae6000  ! 3735: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0xd6ddc4a0  ! 3736: LDXA_R	ldxa	[%r23, %r0] 0x25, %r11
	.word 0xdeafce80  ! 3737: STBA_R	stba	%r15, [%r31 + %r0] 0x74
	.word 0xdac66000  ! 3738: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r13
	.word 0x87802073  ! 3739: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 3740: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 3741: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdadfe000  ! 3742: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0xd094c400  ! 3743: LDUHA_R	lduha	[%r19, %r0] 0x20, %r8
	.word 0x87802072  ! 3744: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6bec9e0  ! 3745: STDA_R	stda	%r11, [%r27 + %r0] 0x4f
	.word 0xdca44400  ! 3746: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0xda9d04a0  ! 3747: LDDA_R	ldda	[%r20, %r0] 0x25, %r13
	.word 0xda87e000  ! 3748: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0xd2a48400  ! 3749: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0x87802020  ! 3750: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb72000  ! 3751: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	mov	0x7d0, %r20
	.word 0xdcbf6000  ! 3753: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdacd44a0  ! 3754: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r13
	.word 0x87802074  ! 3755: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 3756: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f40400  ! 3757: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xd2f5a000  ! 3758: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	.word 0xd2a5a000  ! 3759: STWA_I	stwa	%r9, [%r22 + 0x0000] %asi
	.word 0xd2d52000  ! 3760: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r9
	.word 0x87802074  ! 3761: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd297e000  ! 3762: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	.word 0xd0c40400  ! 3763: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	mov	0x0, %r24
	.word 0xd2d78e80  ! 3765: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r9
	.word 0xd09f0e40  ! 3766: LDDA_R	ldda	[%r28, %r0] 0x72, %r8
	.word 0xdacfa000  ! 3767: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	mov	0x20, %r16
	.word 0xdacfa000  ! 3769: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xd8f5c4a0  ! 3770: STXA_R	stxa	%r12, [%r23 + %r0] 0x25
	.word 0xd0872000  ! 3771: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0bfe000  ! 3772: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd0f72000  ! 3773: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xd0afa000  ! 3774: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd8a4c400  ! 3775: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x7f0, %r23
	.word 0x87802073  ! 3778: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2cf0e80  ! 3779: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r9
	.word 0xdc878e40  ! 3780: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r14
	.word 0xd2b56000  ! 3781: STHA_I	stha	%r9, [%r21 + 0x0000] %asi
	mov	0x3d8, %r22
	.word 0xde878e40  ! 3783: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcad6000  ! 3785: STBA_I	stba	%r14, [%r21 + 0x0000] %asi
	.word 0xd2a74e60  ! 3786: STWA_R	stwa	%r9, [%r29 + %r0] 0x73
	.word 0xdaf5e000  ! 3787: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0xd6af0e60  ! 3788: STBA_R	stba	%r11, [%r28 + %r0] 0x73
	.word 0x87802074  ! 3789: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f48400  ! 3790: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0x87802020  ! 3791: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbfa000  ! 3792: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xd6ccc400  ! 3793: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	.word 0xd487e000  ! 3794: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802025  ! 3795: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4bc6000  ! 3796: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 3797: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4a66000  ! 3798: STWA_I	stwa	%r10, [%r25 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x7c8, %r22
	.word 0xd49e6000  ! 3801: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r10
	.word 0x87802074  ! 3802: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4866000  ! 3803: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r10
	.word 0xd4a48400  ! 3804: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0x87802020  ! 3805: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6af4e60  ! 3806: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	.word 0xd08c4400  ! 3807: LDUBA_R	lduba	[%r17, %r0] 0x20, %r8
	mov	0x10, %r16
	.word 0xd0c74e60  ! 3809: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r8
	.word 0xd4b76000  ! 3810: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xdeaec9e0  ! 3811: STBA_R	stba	%r15, [%r27 + %r0] 0x4f
	.word 0xd4a7e000  ! 3812: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	mov	0x18, %r16
	mov	0x50, %r24
	mov	0x7d0, %r20
	.word 0xd4afe000  ! 3816: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd09ec9e0  ! 3817: LDDA_R	ldda	[%r27, %r0] 0x4f, %r8
	.word 0x87802073  ! 3818: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdacf0e60  ! 3819: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r13
	mov	0x3f0, %r20
	.word 0xdc8e09e0  ! 3821: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r14
	mov	0x7e8, %r21
	.word 0xd0cf6000  ! 3823: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd0a76000  ! 3824: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	mov	0x3d8, %r22
	.word 0xd0d7e000  ! 3826: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0x87802074  ! 3827: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r18
	.word 0xd0d72000  ! 3829: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd6df0e40  ! 3830: LDXA_R	ldxa	[%r28, %r0] 0x72, %r11
	.word 0xdcaf4e40  ! 3831: STBA_R	stba	%r14, [%r29 + %r0] 0x72
	mov	0x10, %r19
	.word 0xd4a7a000  ! 3833: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3834: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69e09e0  ! 3835: LDDA_R	ldda	[%r24, %r0] 0x4f, %r11
	.word 0x8780204f  ! 3836: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd49f2000  ! 3837: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd295c4a0  ! 3838: LDUHA_R	lduha	[%r23, %r0] 0x25, %r9
	.word 0xd48689e0  ! 3839: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r10
	.word 0xd28544a0  ! 3840: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r9
	.word 0xded7e000  ! 3841: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0xd2c649e0  ! 3842: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r9
	.word 0xd2df2000  ! 3843: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2dfe000  ! 3844: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2b7e000  ! 3845: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2d70e80  ! 3846: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r9
	.word 0xd2b72000  ! 3847: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 3848: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ad44a0  ! 3849: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	.word 0xd8f7e000  ! 3850: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8cfa000  ! 3851: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd8f7e000  ! 3852: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd897e000  ! 3853: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	.word 0xd8afa000  ! 3854: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xd0acc400  ! 3855: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd6a48400  ! 3856: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0xd6f7ce40  ! 3857: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6b689e0  ! 3859: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	.word 0xdeaf2000  ! 3860: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xdeb7a000  ! 3861: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	mov	0x20, %r27
	.word 0xdea76000  ! 3863: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xdef7e000  ! 3864: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xd0bdc4a0  ! 3865: STDA_R	stda	%r8, [%r23 + %r0] 0x25
	.word 0xd8b44400  ! 3866: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	mov	0x7d8, %r21
	.word 0xd0a76000  ! 3868: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 3869: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a7a000  ! 3870: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd09f6000  ! 3871: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	mov	0x68, %r18
	mov	0x70, %r17
	mov	0x38, %r26
	.word 0xd4bf4e40  ! 3875: STDA_R	stda	%r10, [%r29 + %r0] 0x72
	.word 0xdedfe000  ! 3876: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xdea7e000  ! 3877: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xdebfa000  ! 3878: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 3879: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 3880: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3881: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeaf6000  ! 3882: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xde8f2000  ! 3883: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xdea7a000  ! 3884: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	mov	0x7f8, %r22
	.word 0xdedf6000  ! 3886: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xd685c4a0  ! 3887: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r11
	.word 0x87802072  ! 3888: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3889: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69c6000  ! 3890: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r11
	.word 0xd6b42000  ! 3891: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xd4b6c9e0  ! 3893: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0xd4874e60  ! 3894: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r10
	.word 0xd0bc6000  ! 3895: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	.word 0xd2bfce80  ! 3896: STDA_R	stda	%r9, [%r31 + %r0] 0x74
	mov	0x70, %r17
	.word 0xd0946000  ! 3898: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0xd0b4a000  ! 3899: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 3900: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0dfe000  ! 3901: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	mov	0x70, %r25
	.word 0x87802020  ! 3903: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0dc6000  ! 3904: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	.word 0xd084e000  ! 3905: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	.word 0x87802020  ! 3906: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9c0400  ! 3907: LDDA_R	ldda	[%r16, %r0] 0x20, %r14
	.word 0xd0bdc4a0  ! 3908: STDA_R	stda	%r8, [%r23 + %r0] 0x25
	.word 0x87802020  ! 3909: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r27
	.word 0x87802074  ! 3911: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c0, %r20
	.word 0xd6dfe000  ! 3913: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6c7a000  ! 3914: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6c7a000  ! 3915: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	mov	0x7e8, %r21
	.word 0xd2c70e80  ! 3917: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r9
	.word 0xd4dfe000  ! 3918: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4afa000  ! 3919: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd4c7a000  ! 3920: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4b76000  ! 3921: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd09e09e0  ! 3922: LDDA_R	ldda	[%r24, %r0] 0x4f, %r8
	.word 0xdeb48400  ! 3923: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 3924: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc8f2000  ! 3925: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 3926: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 3927: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf62000  ! 3928: STXA_I	stxa	%r14, [%r24 + 0x0000] %asi
	.word 0xdc8e6000  ! 3929: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r14
	mov	0x3e0, %r22
	mov	0x3e0, %r20
	mov	0x58, %r26
	mov	0x50, %r17
	.word 0xdca6a000  ! 3934: STWA_I	stwa	%r14, [%r26 + 0x0000] %asi
	.word 0xdc9e6000  ! 3935: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r14
	mov	0x48, %r19
	.word 0xdccea000  ! 3937: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r14
	.word 0xdc866000  ! 3938: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r14
	.word 0xdcb62000  ! 3939: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	.word 0xd8d40400  ! 3940: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	.word 0xd28e2000  ! 3941: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	.word 0xd2d6e000  ! 3942: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r9
	.word 0xd28e2000  ! 3943: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	.word 0xd0be89e0  ! 3944: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	.word 0xd2a66000  ! 3945: STWA_I	stwa	%r9, [%r25 + 0x0000] %asi
	.word 0xdecec9e0  ! 3946: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r15
	.word 0xd4d4c400  ! 3947: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0xd2df0e80  ! 3948: LDXA_R	ldxa	[%r28, %r0] 0x74, %r9
	.word 0xd2f6c9e0  ! 3949: STXA_R	stxa	%r9, [%r27 + %r0] 0x4f
	mov	0x10, %r18
	mov	0x10, %r18
	.word 0xd4d78e80  ! 3952: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r10
	.word 0xd0ccc400  ! 3953: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	mov	0x8, %r18
	.word 0xd0b4c400  ! 3955: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0xdef6a000  ! 3956: STXA_I	stxa	%r15, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 3957: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeaca000  ! 3958: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xdcb48400  ! 3959: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0x87802020  ! 3960: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a7a000  ! 3961: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	mov	0x20, %r27
	.word 0xd2de09e0  ! 3963: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r9
	.word 0xdea7e000  ! 3964: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 3965: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6bd84a0  ! 3966: STDA_R	stda	%r11, [%r22 + %r0] 0x25
	.word 0xd88ca000  ! 3967: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	mov	0x40, %r18
	.word 0xd8846000  ! 3969: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	.word 0xd8b74e80  ! 3970: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	.word 0x87802072  ! 3971: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0bfce60  ! 3972: STDA_R	stda	%r8, [%r31 + %r0] 0x73
	mov	0x7f8, %r23
	.word 0xd8f504a0  ! 3974: STXA_R	stxa	%r12, [%r20 + %r0] 0x25
	mov	0x7e8, %r22
	.word 0xde97ce80  ! 3976: LDUHA_R	lduha	[%r31, %r0] 0x74, %r15
	.word 0xda9c4400  ! 3977: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	.word 0xd2ccc400  ! 3978: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	mov	0x8, %r19
	.word 0x87802074  ! 3980: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r27
	mov	0x40, %r25
	.word 0xdcb5e000  ! 3983: STHA_I	stha	%r14, [%r23 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdc8d6000  ! 3985: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r14
	mov	0x68, %r27
	.word 0xd6840400  ! 3987: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0x87802020  ! 3988: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bca000  ! 3989: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0xd0bce000  ! 3990: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0xd2a504a0  ! 3991: STWA_R	stwa	%r9, [%r20 + %r0] 0x25
	.word 0x87802020  ! 3992: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea7ce60  ! 3993: STWA_R	stwa	%r15, [%r31 + %r0] 0x73
	.word 0xdac52000  ! 3994: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r13
	.word 0xdad5e000  ! 3995: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r13
	.word 0xd4dc8400  ! 3996: LDXA_R	ldxa	[%r18, %r0] 0x20, %r10
	.word 0x87802020  ! 3997: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf4a000  ! 3998: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0xdc8c0400  ! 3999: LDUBA_R	lduba	[%r16, %r0] 0x20, %r14
	.word 0xd2cc2000  ! 4000: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r9
	.word 0xd2d4a000  ! 4001: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	.word 0xdebf0e80  ! 4002: STDA_R	stda	%r15, [%r28 + %r0] 0x74
	.word 0xdea42000  ! 4003: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xde84a000  ! 4004: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	.word 0xdcbc8400  ! 4005: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xd4ace000  ! 4006: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0xd4b46000  ! 4007: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 4008: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2a40400  ! 4009: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xde8d84a0  ! 4010: LDUBA_R	lduba	[%r22, %r0] 0x25, %r15
	.word 0xdcc5c4a0  ! 4011: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r14
	.word 0xd2dfa000  ! 4012: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	mov	0x60, %r18
	.word 0xdcb609e0  ! 4014: STHA_R	stha	%r14, [%r24 + %r0] 0x4f
	.word 0xd2972000  ! 4015: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	mov	0x30, %r27
	.word 0xd2b72000  ! 4017: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd2b7a000  ! 4018: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd2c76000  ! 4019: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2bfe000  ! 4020: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	mov	0x40, %r25
	.word 0xd2af2000  ! 4022: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	mov	0x60, %r17
	.word 0x87802074  ! 4024: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bd6000  ! 4025: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 4026: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4027: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd29fe000  ! 4028: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd2afe000  ! 4029: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd2afe000  ! 4030: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd2b76000  ! 4031: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd6a74e60  ! 4032: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 4033: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 4034: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4be49e0  ! 4035: STDA_R	stda	%r10, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 4036: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd89ca000  ! 4037: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r12
	.word 0xdcdc8400  ! 4038: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	mov	0x3c8, %r23
	mov	0x78, %r26
	.word 0xd2970e40  ! 4041: LDUHA_R	lduha	[%r28, %r0] 0x72, %r9
	mov	0x18, %r18
	.word 0x8780204f  ! 4043: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c8, %r22
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd8af0e60  ! 4046: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	mov	0x60, %r18
	.word 0x87802073  ! 4048: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4049: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbe09e0  ! 4050: STDA_R	stda	%r14, [%r24 + %r0] 0x4f
	.word 0xd4c70e60  ! 4051: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r10
	.word 0xdeafce60  ! 4052: STBA_R	stba	%r15, [%r31 + %r0] 0x73
	.word 0xd0d46000  ! 4053: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r8
	.word 0xd2870e40  ! 4054: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r9
	.word 0xd8a6c9e0  ! 4055: STWA_R	stwa	%r12, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 4056: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bec9e0  ! 4057: STDA_R	stda	%r9, [%r27 + %r0] 0x4f
	.word 0xdaad44a0  ! 4058: STBA_R	stba	%r13, [%r21 + %r0] 0x25
	.word 0x87802072  ! 4059: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf46000  ! 4060: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	mov	0x7e8, %r23
	mov	0x7d0, %r23
	.word 0xdeb7ce60  ! 4063: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	mov	0x78, %r26
	.word 0xdab4a000  ! 4065: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 4066: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 4067: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde9fce80  ! 4068: LDDA_R	ldda	[%r31, %r0] 0x74, %r15
	.word 0xd6a74e60  ! 4069: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	.word 0x87802025  ! 4070: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r17
	.word 0xdef4e000  ! 4072: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xd68f0e80  ! 4073: LDUBA_R	lduba	[%r28, %r0] 0x74, %r11
	.word 0xd8df8e80  ! 4074: LDXA_R	ldxa	[%r30, %r0] 0x74, %r12
	.word 0xd8ac4400  ! 4075: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	mov	0x58, %r25
	.word 0x87802025  ! 4077: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcaf2000  ! 4078: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdcf72000  ! 4079: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdca76000  ! 4080: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 4081: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2870e60  ! 4082: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r9
	.word 0x87802074  ! 4083: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d8, %r20
	mov	0x68, %r18
	.word 0xd286a000  ! 4086: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r9
	mov	0x3f0, %r22
	.word 0xd2b62000  ! 4088: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	.word 0xd2b6e000  ! 4089: STHA_I	stha	%r9, [%r27 + 0x0000] %asi
	.word 0xd2ae6000  ! 4090: STBA_I	stba	%r9, [%r25 + 0x0000] %asi
	.word 0xd2ce2000  ! 4091: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r9
	.word 0xd0c504a0  ! 4092: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r8
	.word 0xd8974e40  ! 4093: LDUHA_R	lduha	[%r29, %r0] 0x72, %r12
	.word 0xdebf0e60  ! 4094: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	.word 0xd8ce6000  ! 4095: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r12
	.word 0xd2bdc4a0  ! 4096: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	.word 0xdaf6a000  ! 4097: STXA_I	stxa	%r13, [%r26 + 0x0000] %asi
	mov	0x10, %r18
	.word 0xd69f8e40  ! 4099: LDDA_R	ldda	[%r30, %r0] 0x72, %r11
	mov	0x7e8, %r21
	mov	0x7e0, %r20
	.word 0xde86a000  ! 4102: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r15
	mov	0x8, %r17
	.word 0xdedc8400  ! 4104: LDXA_R	ldxa	[%r18, %r0] 0x20, %r15
	mov	0x38, %r18
	.word 0x87802072  ! 4106: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3e8, %r23
	.word 0xd2bd6000  ! 4108: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	.word 0xdcacc400  ! 4109: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	mov	0x28, %r27
	mov	0x50, %r26
	.word 0xdc956000  ! 4112: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r14
	.word 0xd8978e60  ! 4113: LDUHA_R	lduha	[%r30, %r0] 0x73, %r12
	mov	0x10, %r24
	.word 0x87802020  ! 4115: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b7ce40  ! 4116: STHA_R	stha	%r9, [%r31 + %r0] 0x72
	mov	0x3c0, %r20
	.word 0x8780204f  ! 4118: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6a62000  ! 4119: STWA_I	stwa	%r11, [%r24 + 0x0000] %asi
	.word 0xd0ac0400  ! 4120: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	.word 0xdcbea000  ! 4121: STDA_I	stda	%r14, [%r26 + 0x0000] %asi
	.word 0xd6b7ce80  ! 4122: STHA_R	stha	%r11, [%r31 + %r0] 0x74
	.word 0xdad6a000  ! 4123: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r13
	.word 0xdac66000  ! 4124: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r13
	.word 0xd6bf0e40  ! 4125: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	.word 0xde9e2000  ! 4126: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r15
	.word 0xdebee000  ! 4127: STDA_I	stda	%r15, [%r27 + 0x0000] %asi
	.word 0xdc8f4e40  ! 4128: LDUBA_R	lduba	[%r29, %r0] 0x72, %r14
	.word 0xd0f66000  ! 4129: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	mov	0x50, %r17
	.word 0xdcaf4e60  ! 4131: STBA_R	stba	%r14, [%r29 + %r0] 0x73
	.word 0xd496e000  ! 4132: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r10
	.word 0xd48ee000  ! 4133: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r10
	.word 0xd49ea000  ! 4134: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	.word 0xd48fce80  ! 4135: LDUBA_R	lduba	[%r31, %r0] 0x74, %r10
	.word 0xd8acc400  ! 4136: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0xde9cc400  ! 4137: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	mov	0x38, %r25
	.word 0xd4a78e40  ! 4139: STWA_R	stwa	%r10, [%r30 + %r0] 0x72
	.word 0xd4aee000  ! 4140: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	.word 0xdaf7ce40  ! 4141: STXA_R	stxa	%r13, [%r31 + %r0] 0x72
	.word 0xdcb6e000  ! 4142: STHA_I	stha	%r14, [%r27 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xd2970e60  ! 4144: LDUHA_R	lduha	[%r28, %r0] 0x73, %r9
	.word 0xdccc0400  ! 4145: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r14
	.word 0xd8a689e0  ! 4146: STWA_R	stwa	%r12, [%r26 + %r0] 0x4f
	mov	0x70, %r24
	.word 0xd2ae6000  ! 4148: STBA_I	stba	%r9, [%r25 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0x87802020  ! 4150: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d52000  ! 4151: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r9
	.word 0xd2b5e000  ! 4152: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	.word 0xd2a74e80  ! 4153: STWA_R	stwa	%r9, [%r29 + %r0] 0x74
	.word 0xd8974e60  ! 4154: LDUHA_R	lduha	[%r29, %r0] 0x73, %r12
	.word 0xd0dda000  ! 4155: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r8
	.word 0xd4acc400  ! 4156: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xd2cc0400  ! 4157: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r9
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7e0, %r23
	mov	0x70, %r24
	.word 0xd4bda000  ! 4161: STDA_I	stda	%r10, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 4162: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b78e40  ! 4163: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	mov	0x3e0, %r20
	mov	0x7e0, %r22
	mov	0x3d8, %r20
	mov	0x30, %r25
	.word 0xdac5a000  ! 4168: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r13
	mov	0x7d0, %r23
	mov	0x40, %r26
	.word 0xd6d5c4a0  ! 4171: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r11
	mov	0x7c0, %r20
	.word 0xdca6c9e0  ! 4173: STWA_R	stwa	%r14, [%r27 + %r0] 0x4f
	mov	0x78, %r27
	.word 0xdac649e0  ! 4175: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r13
	.word 0xd6dd04a0  ! 4176: LDXA_R	ldxa	[%r20, %r0] 0x25, %r11
	.word 0xd0d649e0  ! 4177: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r8
	.word 0xd6b74e60  ! 4178: STHA_R	stha	%r11, [%r29 + %r0] 0x73
	mov	0x60, %r16
	.word 0xd2bd6000  ! 4180: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	mov	0x68, %r27
	.word 0x87802025  ! 4182: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2a6e000  ! 4183: STWA_I	stwa	%r9, [%r27 + 0x0000] %asi
	.word 0xdac74e80  ! 4184: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r13
	.word 0xd48544a0  ! 4185: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r10
	.word 0xd4d62000  ! 4186: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r10
	mov	0x3c0, %r22
	mov	0x30, %r24
	mov	0x3e8, %r22
	.word 0x87802072  ! 4190: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4b7a000  ! 4191: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	mov	0x0, %r27
	mov	0x3d0, %r21
	mov	0x10, %r17
	.word 0xdea78e40  ! 4195: STWA_R	stwa	%r15, [%r30 + %r0] 0x72
	.word 0xd4bc0400  ! 4196: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xd4adc4a0  ! 4197: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0x87802072  ! 4198: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde9c6000  ! 4199: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0xded46000  ! 4200: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xde946000  ! 4202: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r15
	.word 0xdea4e000  ! 4203: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xde84a000  ! 4204: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	.word 0xd2cc8400  ! 4205: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0x87802020  ! 4206: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r17
	.word 0xdebc0400  ! 4208: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	mov	0x60, %r24
	mov	0x38, %r18
	.word 0xdecf0e80  ! 4211: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r15
	.word 0xd4b62000  ! 4212: STHA_I	stha	%r10, [%r24 + 0x0000] %asi
	.word 0xd4f66000  ! 4213: STXA_I	stxa	%r10, [%r25 + 0x0000] %asi
	.word 0xd4cea000  ! 4214: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r10
	mov	0x3d8, %r23
	mov	0x48, %r25
	.word 0xd4dea000  ! 4217: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	mov	0x30, %r27
	.word 0xd884c400  ! 4219: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	.word 0xd6c78e40  ! 4220: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	.word 0xd086a000  ! 4221: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r8
	mov	0x3c0, %r20
	.word 0xd2c70e40  ! 4223: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r9
	mov	0x28, %r16
	.word 0xd4de2000  ! 4225: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r10
	.word 0xd4de2000  ! 4226: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r10
	.word 0xd6f7ce80  ! 4227: STXA_R	stxa	%r11, [%r31 + %r0] 0x74
	.word 0xd8bc4400  ! 4228: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xd6ae6000  ! 4229: STBA_I	stba	%r11, [%r25 + 0x0000] %asi
	.word 0xdac74e80  ! 4230: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r13
	mov	0x8, %r19
	.word 0xda96a000  ! 4232: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r13
	.word 0xdcae49e0  ! 4233: STBA_R	stba	%r14, [%r25 + %r0] 0x4f
	.word 0xdac689e0  ! 4234: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r13
	.word 0xd49f8e80  ! 4235: LDDA_R	ldda	[%r30, %r0] 0x74, %r10
	.word 0xd2b40400  ! 4236: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0xdacc8400  ! 4237: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r13
	.word 0x87802074  ! 4238: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r16
	.word 0xd0b4e000  ! 4240: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 4241: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd08ca000  ! 4242: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xdaad04a0  ! 4243: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	mov	0x3c8, %r22
	.word 0x87802025  ! 4245: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4d5c4a0  ! 4246: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r10
	.word 0x87802025  ! 4247: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdecda000  ! 4248: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r15
	mov	0x60, %r24
	.word 0xdabfce40  ! 4250: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	.word 0xd28c4400  ! 4251: LDUBA_R	lduba	[%r17, %r0] 0x20, %r9
	.word 0xd4a52000  ! 4252: STWA_I	stwa	%r10, [%r20 + 0x0000] %asi
	mov	0x38, %r24
	.word 0x87802020  ! 4254: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r22
	.word 0xd4aea000  ! 4256: STBA_I	stba	%r10, [%r26 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0xd48e2000  ! 4258: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r10
	.word 0xd4aee000  ! 4259: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	.word 0xd4bf0e40  ! 4260: STDA_R	stda	%r10, [%r28 + %r0] 0x72
	.word 0xda9ee000  ! 4261: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r13
	.word 0xdaf5c4a0  ! 4262: STXA_R	stxa	%r13, [%r23 + %r0] 0x25
	.word 0x8780204f  ! 4263: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc97ce60  ! 4264: LDUHA_R	lduha	[%r31, %r0] 0x73, %r14
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x70, %r17
	.word 0xdabf4e80  ! 4267: STDA_R	stda	%r13, [%r29 + %r0] 0x74
	.word 0xd4ada000  ! 4268: STBA_I	stba	%r10, [%r22 + 0x0000] %asi
	.word 0xd4f5e000  ! 4269: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	mov	0x38, %r16
	.word 0x87802020  ! 4271: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a7e000  ! 4272: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 4273: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd494a000  ! 4274: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r10
	.word 0xd6dd44a0  ! 4275: LDXA_R	ldxa	[%r21, %r0] 0x25, %r11
	.word 0x8780204f  ! 4276: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2af4e80  ! 4277: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	.word 0xd4f6a000  ! 4278: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	.word 0xd4be2000  ! 4279: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	.word 0x8780204f  ! 4280: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4cfe000  ! 4281: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0xd0f4c400  ! 4282: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0xdcf74e60  ! 4283: STXA_R	stxa	%r14, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 4284: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdadc0400  ! 4285: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	mov	0x0, %r25
	mov	0x60, %r19
	mov	0x30, %r25
	.word 0xd6ac4400  ! 4289: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xdcc46000  ! 4290: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r14
	.word 0xdca4e000  ! 4291: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcd46000  ! 4292: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	.word 0xdcb7ce40  ! 4293: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	.word 0xdab4e000  ! 4294: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0xdadc6000  ! 4296: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xd2878e40  ! 4297: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r9
	.word 0xd2aca000  ! 4298: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	mov	0x40, %r19
	.word 0xd6bc0400  ! 4300: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xd6b4c400  ! 4301: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xd0f4e000  ! 4302: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 4303: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bf0e60  ! 4304: STDA_R	stda	%r12, [%r28 + %r0] 0x73
	mov	0x3f0, %r22
	.word 0xde84c400  ! 4306: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0xd09689e0  ! 4307: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r8
	.word 0xdef72000  ! 4308: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	mov	0x78, %r16
	.word 0x87802073  ! 4310: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb56000  ! 4311: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	.word 0xd2bcc400  ! 4312: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0x87802020  ! 4313: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r18
	.word 0xdcdca000  ! 4315: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xd08689e0  ! 4316: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r8
	.word 0xd2a4a000  ! 4317: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0xd8a74e80  ! 4318: STWA_R	stwa	%r12, [%r29 + %r0] 0x74
	.word 0xd8b70e60  ! 4319: STHA_R	stha	%r12, [%r28 + %r0] 0x73
	.word 0xd6b42000  ! 4320: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 4321: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r19
	mov	0x38, %r16
	mov	0x18, %r24
	.word 0x87802025  ! 4325: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6aca000  ! 4326: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xd6b44400  ! 4327: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0x87802073  ! 4328: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd08649e0  ! 4329: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r8
	mov	0x3f8, %r22
	.word 0xd2f74e60  ! 4331: STXA_R	stxa	%r9, [%r29 + %r0] 0x73
	mov	0x7f8, %r21
	.word 0xd2870e40  ! 4333: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r9
	mov	0x3f0, %r20
	.word 0xdccea000  ! 4335: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r14
	.word 0xdcaee000  ! 4336: STBA_I	stba	%r14, [%r27 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdcb62000  ! 4338: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	mov	0x58, %r26
	mov	0x0, %r26
	mov	0x7f0, %r21
	.word 0xd0bf8e40  ! 4342: STDA_R	stda	%r8, [%r30 + %r0] 0x72
	.word 0x87802072  ! 4343: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c0, %r23
	.word 0xd8a40400  ! 4345: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0x87802072  ! 4346: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdedc8400  ! 4347: LDXA_R	ldxa	[%r18, %r0] 0x20, %r15
	.word 0xd6afa000  ! 4348: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6dfa000  ! 4349: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	mov	0x58, %r25
	.word 0xd6afa000  ! 4351: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xd2bec9e0  ! 4353: STDA_R	stda	%r9, [%r27 + %r0] 0x4f
	.word 0xd0c44400  ! 4354: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r8
	.word 0xd8f7a000  ! 4355: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd2974e60  ! 4356: LDUHA_R	lduha	[%r29, %r0] 0x73, %r9
	.word 0xdaaf6000  ! 4357: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xda8f2000  ! 4358: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xd0a48400  ! 4359: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0xdebd04a0  ! 4360: STDA_R	stda	%r15, [%r20 + %r0] 0x25
	.word 0xdcbf2000  ! 4361: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 4362: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 4363: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r27
	.word 0xdcc504a0  ! 4365: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r14
	mov	0x3f8, %r22
	.word 0x87802020  ! 4367: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ae49e0  ! 4368: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0x87802072  ! 4369: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 4370: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 4371: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4cd2000  ! 4372: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r10
	.word 0xde8cc400  ! 4373: LDUBA_R	lduba	[%r19, %r0] 0x20, %r15
	.word 0xd09504a0  ! 4374: LDUHA_R	lduha	[%r20, %r0] 0x25, %r8
	.word 0xd0a5a000  ! 4375: STWA_I	stwa	%r8, [%r22 + 0x0000] %asi
	mov	0x3c8, %r22
	mov	0x7f8, %r23
	mov	0x7c8, %r20
	mov	0x20, %r27
	.word 0xdab4c400  ! 4380: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0x87802073  ! 4381: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bc6000  ! 4382: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 4383: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6cf2000  ! 4384: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0x87802020  ! 4385: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9f4e40  ! 4386: LDDA_R	ldda	[%r29, %r0] 0x72, %r15
	.word 0xd2f42000  ! 4387: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0xde8c0400  ! 4388: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0x87802072  ! 4389: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3e0, %r23
	mov	0x50, %r26
	.word 0xdc9d04a0  ! 4392: LDDA_R	ldda	[%r20, %r0] 0x25, %r14
	.word 0xdaafe000  ! 4393: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xdaafa000  ! 4394: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 4395: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa5e000  ! 4396: STWA_I	stwa	%r13, [%r23 + 0x0000] %asi
	.word 0x87802073  ! 4397: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 4398: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6c584a0  ! 4399: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r11
	.word 0xd89fce80  ! 4400: LDDA_R	ldda	[%r31, %r0] 0x74, %r12
	.word 0xd4ad84a0  ! 4401: STBA_R	stba	%r10, [%r22 + %r0] 0x25
	mov	0x18, %r16
	.word 0x8780204f  ! 4403: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa42000  ! 4404: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0xdab42000  ! 4405: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xdaace000  ! 4406: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 4407: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 4408: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdacf6000  ! 4409: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xd8970e80  ! 4410: LDUHA_R	lduha	[%r28, %r0] 0x74, %r12
	.word 0xd0a70e60  ! 4411: STWA_R	stwa	%r8, [%r28 + %r0] 0x73
	mov	0x8, %r19
	.word 0xdca7e000  ! 4413: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcb7a000  ! 4414: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xd29d04a0  ! 4415: LDDA_R	ldda	[%r20, %r0] 0x25, %r9
	mov	0x3e0, %r22
	.word 0xd48f2000  ! 4417: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd68c8400  ! 4418: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	.word 0xd6a76000  ! 4419: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 4420: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r26
	.word 0xd48e89e0  ! 4422: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r10
	.word 0x8780204f  ! 4423: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 4424: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 4425: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaada000  ! 4426: STBA_I	stba	%r13, [%r22 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xdac52000  ! 4428: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r13
	.word 0xdaf52000  ! 4429: STXA_I	stxa	%r13, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 4430: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabc2000  ! 4431: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4432: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4433: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r26
	.word 0xdad5a000  ! 4435: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r13
	mov	0x38, %r17
	.word 0x87802072  ! 4437: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf76000  ! 4438: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdabf2000  ! 4439: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xdeb48400  ! 4440: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xd2870e40  ! 4441: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r9
	.word 0x87802025  ! 4442: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4443: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r27
	.word 0xdaf7ce60  ! 4445: STXA_R	stxa	%r13, [%r31 + %r0] 0x73
	.word 0x87802020  ! 4446: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r24
	.word 0xd09da000  ! 4448: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r8
	.word 0x87802020  ! 4449: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ae6000  ! 4450: STBA_I	stba	%r8, [%r25 + 0x0000] %asi
	.word 0xdad48400  ! 4451: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0xda9fce40  ! 4452: LDDA_R	ldda	[%r31, %r0] 0x72, %r13
	.word 0x87802073  ! 4453: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd08cc400  ! 4454: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	.word 0x87802020  ! 4455: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4456: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0d48400  ! 4457: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	.word 0x87802073  ! 4458: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f0, %r22
	.word 0xd0a70e60  ! 4460: STWA_R	stwa	%r8, [%r28 + %r0] 0x73
	.word 0xd2df0e80  ! 4461: LDXA_R	ldxa	[%r28, %r0] 0x74, %r9
	.word 0x87802074  ! 4462: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd686a000  ! 4463: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r11
	.word 0x87802074  ! 4464: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3f8, %r23
	.word 0xd4c7ce80  ! 4466: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r10
	.word 0xdeac6000  ! 4467: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xde9ce000  ! 4468: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	mov	0x3d8, %r22
	mov	0x60, %r16
	.word 0xdeb4a000  ! 4471: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0xd8bfce60  ! 4472: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	mov	0x50, %r16
	.word 0xd0c689e0  ! 4474: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r8
	.word 0xd4ac4400  ! 4475: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xda94a000  ! 4476: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	.word 0xda94a000  ! 4477: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	.word 0xdadce000  ! 4478: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xd2878e80  ! 4479: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r9
	.word 0xd2c46000  ! 4480: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0x87802020  ! 4481: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28c2000  ! 4482: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	mov	0x8, %r16
	mov	0x50, %r25
	.word 0xdccc8400  ! 4485: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	.word 0x87802073  ! 4486: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4dd84a0  ! 4487: LDXA_R	ldxa	[%r22, %r0] 0x25, %r10
	mov	0x7f8, %r22
	.word 0xd4cdc4a0  ! 4489: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r10
	.word 0xd687a000  ! 4490: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0xdea74e40  ! 4491: STWA_R	stwa	%r15, [%r29 + %r0] 0x72
	.word 0xdccf6000  ! 4492: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xd6b609e0  ! 4493: STHA_R	stha	%r11, [%r24 + %r0] 0x4f
	.word 0xd2dfa000  ! 4494: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xd0bc4400  ! 4495: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xdc8f0e60  ! 4496: LDUBA_R	lduba	[%r28, %r0] 0x73, %r14
	.word 0xdc9f6000  ! 4497: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	mov	0x40, %r27
	.word 0x8780204f  ! 4499: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda844400  ! 4500: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r13
	mov	0x58, %r16
	mov	0x30, %r18
	.word 0xd08e2000  ! 4503: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r8
	.word 0xd09e6000  ! 4504: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r8
	mov	0x7d0, %r21
	.word 0xd4f5c4a0  ! 4506: STXA_R	stxa	%r10, [%r23 + %r0] 0x25
	mov	0x8, %r24
	.word 0xdab62000  ! 4508: STHA_I	stha	%r13, [%r24 + 0x0000] %asi
	mov	0x3c8, %r22
	.word 0xd29cc400  ! 4510: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	.word 0xd6f62000  ! 4511: STXA_I	stxa	%r11, [%r24 + 0x0000] %asi
	.word 0xd6a62000  ! 4512: STWA_I	stwa	%r11, [%r24 + 0x0000] %asi
	.word 0xd6b62000  ! 4513: STHA_I	stha	%r11, [%r24 + 0x0000] %asi
	.word 0xd6de6000  ! 4514: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r11
	mov	0x68, %r17
	.word 0xd8970e80  ! 4516: LDUHA_R	lduha	[%r28, %r0] 0x74, %r12
	.word 0xd2de6000  ! 4517: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r9
	.word 0x87802074  ! 4518: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2d72000  ! 4519: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xd28f2000  ! 4520: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	.word 0xd2dfe000  ! 4521: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	mov	0x3c0, %r20
	.word 0xd8c40400  ! 4523: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	mov	0x7f8, %r20
	mov	0x3e8, %r21
	mov	0x28, %r25
	.word 0xdaa48400  ! 4527: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0x87802020  ! 4528: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bce000  ! 4529: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0xd4cc2000  ! 4530: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	mov	0x3d8, %r23
	.word 0xd49c6000  ! 4532: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0xdadf8e40  ! 4533: LDXA_R	ldxa	[%r30, %r0] 0x72, %r13
	mov	0x0, %r18
	.word 0xd8d544a0  ! 4535: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r12
	.word 0xd8840400  ! 4536: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r12
	.word 0xdcf4e000  ! 4537: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xd8a78e80  ! 4538: STWA_R	stwa	%r12, [%r30 + %r0] 0x74
	.word 0xd2afce60  ! 4539: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	.word 0xd2bc6000  ! 4540: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0xd2c4e000  ! 4541: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xd2c4a000  ! 4542: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	.word 0xd6b7ce60  ! 4543: STHA_R	stha	%r11, [%r31 + %r0] 0x73
	.word 0xd0c4e000  ! 4544: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	mov	0x8, %r25
	.word 0xda8f8e60  ! 4546: LDUBA_R	lduba	[%r30, %r0] 0x73, %r13
	.word 0x8780204f  ! 4547: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a76000  ! 4548: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4f48400  ! 4549: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xdea5c4a0  ! 4550: STWA_R	stwa	%r15, [%r23 + %r0] 0x25
	mov	0x30, %r26
	.word 0xdacd44a0  ! 4552: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r13
	.word 0xd68fa000  ! 4553: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0xd6bf6000  ! 4554: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd884c400  ! 4555: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	.word 0xdaccc400  ! 4556: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r13
	.word 0x87802072  ! 4557: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabd04a0  ! 4558: STDA_R	stda	%r13, [%r20 + %r0] 0x25
	.word 0xd4cf2000  ! 4559: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	mov	0x28, %r25
	.word 0xdef74e80  ! 4561: STXA_R	stxa	%r15, [%r29 + %r0] 0x74
	.word 0x87802074  ! 4562: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0878e40  ! 4563: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r8
	.word 0xd6cd04a0  ! 4564: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r11
	.word 0xd6b6a000  ! 4565: STHA_I	stha	%r11, [%r26 + 0x0000] %asi
	.word 0xd6c6e000  ! 4566: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r11
	.word 0xd2cf0e60  ! 4567: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r9
	.word 0xdcb40400  ! 4568: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	mov	0x50, %r24
	.word 0x8780204f  ! 4570: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4571: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4572: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 4573: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeaec9e0  ! 4574: STBA_R	stba	%r15, [%r27 + %r0] 0x4f
	.word 0xd8f7a000  ! 4575: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd4a40400  ! 4576: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	.word 0xd6df0e80  ! 4577: LDXA_R	ldxa	[%r28, %r0] 0x74, %r11
	.word 0x87802074  ! 4578: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca70e40  ! 4579: STWA_R	stwa	%r14, [%r28 + %r0] 0x72
	.word 0xdcc74e40  ! 4580: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r14
	mov	0x7d0, %r22
	.word 0x87802025  ! 4582: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r17
	.word 0x8780204f  ! 4584: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bf4e80  ! 4585: STDA_R	stda	%r10, [%r29 + %r0] 0x74
	.word 0x87802025  ! 4586: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r26
	.word 0xd8cc8400  ! 4588: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	mov	0x7f8, %r21
	.word 0x87802073  ! 4590: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd89ec9e0  ! 4591: LDDA_R	ldda	[%r27, %r0] 0x4f, %r12
	.word 0xde94e000  ! 4592: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	.word 0xdcf4c400  ! 4593: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	mov	0x3f8, %r22
	mov	0x60, %r26
	.word 0x87802072  ! 4596: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 4597: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdad56000  ! 4598: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r13
	.word 0xdaa689e0  ! 4599: STWA_R	stwa	%r13, [%r26 + %r0] 0x4f
	.word 0xd4dde000  ! 4600: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r10
	.word 0x87802074  ! 4601: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r17
	mov	0x20, %r16
	mov	0x10, %r24
	.word 0xd88fce80  ! 4605: LDUBA_R	lduba	[%r31, %r0] 0x74, %r12
	.word 0xd6af4e40  ! 4606: STBA_R	stba	%r11, [%r29 + %r0] 0x72
	.word 0x87802072  ! 4607: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6c78e40  ! 4608: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	.word 0xd296e000  ! 4609: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r9
	.word 0xd2d62000  ! 4610: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r9
	mov	0x40, %r26
	.word 0xd2966000  ! 4612: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r9
	mov	0x7c0, %r21
	mov	0x58, %r16
	.word 0xd8bc8400  ! 4615: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xd4dee000  ! 4616: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r10
	.word 0xd6c70e80  ! 4617: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r11
	.word 0xd6bd04a0  ! 4618: STDA_R	stda	%r11, [%r20 + %r0] 0x25
	mov	0x58, %r16
	.word 0xdef70e40  ! 4620: STXA_R	stxa	%r15, [%r28 + %r0] 0x72
	.word 0xd6be89e0  ! 4621: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	.word 0xd0948400  ! 4622: LDUHA_R	lduha	[%r18, %r0] 0x20, %r8
	.word 0xda962000  ! 4623: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 4624: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda84a000  ! 4625: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	.word 0xd8a40400  ! 4626: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	mov	0x7f8, %r22
	.word 0xd4af4e60  ! 4628: STBA_R	stba	%r10, [%r29 + %r0] 0x73
	.word 0xd6de49e0  ! 4629: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r11
	.word 0x8780204f  ! 4630: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0d7a000  ! 4631: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	mov	0x48, %r19
	mov	0x3f0, %r20
	.word 0xd4bdc4a0  ! 4634: STDA_R	stda	%r10, [%r23 + %r0] 0x25
	.word 0xd4af6000  ! 4635: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd2b4c400  ! 4636: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0x87802074  ! 4637: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6d7ce40  ! 4638: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r11
	.word 0x87802025  ! 4639: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc86e000  ! 4640: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4641: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4642: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4dc4400  ! 4643: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	.word 0xdacea000  ! 4644: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r13
	.word 0xdeb609e0  ! 4645: STHA_R	stha	%r15, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 4646: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bf2000  ! 4647: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xd8bfe000  ! 4649: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	mov	0x38, %r24
	.word 0xd8a76000  ! 4651: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8876000  ! 4652: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4653: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r18
	.word 0x87802025  ! 4655: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4656: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8dce000  ! 4657: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	.word 0xd0c4c400  ! 4658: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	.word 0xd0f7ce40  ! 4659: STXA_R	stxa	%r8, [%r31 + %r0] 0x72
	.word 0xdef7ce40  ! 4660: STXA_R	stxa	%r15, [%r31 + %r0] 0x72
	.word 0xde9c8400  ! 4661: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	.word 0x8780204f  ! 4662: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 4663: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4664: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r25
	mov	0x68, %r27
	.word 0xd6874e60  ! 4667: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r11
	.word 0xd08dc4a0  ! 4668: LDUBA_R	lduba	[%r23, %r0] 0x25, %r8
	mov	0x18, %r18
	mov	0x7e8, %r22
	.word 0x8780204f  ! 4671: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f48400  ! 4672: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xd6cea000  ! 4673: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	mov	0x18, %r25
	.word 0x8780204f  ! 4675: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdacc0400  ! 4676: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r13
	.word 0xd6c76000  ! 4677: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	mov	0x3d8, %r21
	.word 0xd697e000  ! 4679: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0xd6afa000  ! 4680: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd68689e0  ! 4681: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r11
	.word 0x87802020  ! 4682: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda976000  ! 4683: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	.word 0xdadfa000  ! 4684: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0x87802073  ! 4685: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdab76000  ! 4686: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xd69f4e40  ! 4687: LDDA_R	ldda	[%r29, %r0] 0x72, %r11
	.word 0xd4dfa000  ! 4688: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	mov	0x7f0, %r20
	.word 0xd2d649e0  ! 4690: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r9
	mov	0x0, %r17
	.word 0x87802025  ! 4692: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2d7a000  ! 4693: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0xd2f7e000  ! 4694: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	mov	0x18, %r16
	mov	0x58, %r16
	.word 0xd88544a0  ! 4697: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r12
	.word 0x87802074  ! 4698: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8b7a000  ! 4699: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xd6ad04a0  ! 4700: STBA_R	stba	%r11, [%r20 + %r0] 0x25
	.word 0xd69cc400  ! 4701: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	.word 0xdea609e0  ! 4702: STWA_R	stwa	%r15, [%r24 + %r0] 0x4f
	.word 0xd28e49e0  ! 4703: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r9
	.word 0xd0d7ce40  ! 4704: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r8
	.word 0x87802072  ! 4705: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f6e000  ! 4706: STXA_I	stxa	%r11, [%r27 + 0x0000] %asi
	.word 0xd4a5c4a0  ! 4707: STWA_R	stwa	%r10, [%r23 + %r0] 0x25
	.word 0xd6b66000  ! 4708: STHA_I	stha	%r11, [%r25 + 0x0000] %asi
	.word 0xd6aee000  ! 4709: STBA_I	stba	%r11, [%r27 + 0x0000] %asi
	.word 0xd6aea000  ! 4710: STBA_I	stba	%r11, [%r26 + 0x0000] %asi
	mov	0x78, %r26
	.word 0xdad7ce40  ! 4712: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r13
	.word 0x87802020  ! 4713: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4714: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca46000  ! 4715: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xd6848400  ! 4716: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	.word 0x87802073  ! 4717: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c8, %r20
	.word 0x8780204f  ! 4719: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x0, %r27
	.word 0xd2a5e000  ! 4721: STWA_I	stwa	%r9, [%r23 + 0x0000] %asi
	.word 0xd28de000  ! 4722: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r9
	.word 0xd4a689e0  ! 4723: STWA_R	stwa	%r10, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 4724: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48ec9e0  ! 4725: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r10
	mov	0x3f0, %r22
	.word 0x87802025  ! 4727: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb7e000  ! 4728: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 4729: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 4730: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeafe000  ! 4731: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xdab78e40  ! 4732: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	.word 0xd8afa000  ! 4733: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xdea48400  ! 4734: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xded44400  ! 4735: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	.word 0xdadf6000  ! 4736: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	mov	0x7f8, %r20
	.word 0xdaf7a000  ! 4738: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xd0f40400  ! 4739: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xd48f2000  ! 4740: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd8bc0400  ! 4741: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xda976000  ! 4742: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	.word 0xdcb7ce80  ! 4743: STHA_R	stha	%r14, [%r31 + %r0] 0x74
	.word 0x87802073  ! 4744: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f44400  ! 4745: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xdab44400  ! 4746: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	mov	0x58, %r26
	.word 0xdea504a0  ! 4748: STWA_R	stwa	%r15, [%r20 + %r0] 0x25
	.word 0xdcc4c400  ! 4749: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	.word 0xd29d04a0  ! 4750: LDDA_R	ldda	[%r20, %r0] 0x25, %r9
	.word 0xd8f74e60  ! 4751: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	.word 0xd0bfce60  ! 4752: STDA_R	stda	%r8, [%r31 + %r0] 0x73
	.word 0xdaa48400  ! 4753: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0xd0afa000  ! 4754: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd4a649e0  ! 4755: STWA_R	stwa	%r10, [%r25 + %r0] 0x4f
	.word 0xd4a7a000  ! 4756: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd6d78e60  ! 4757: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r11
	mov	0x48, %r19
	.word 0xde86c9e0  ! 4759: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r15
	mov	0x10, %r25
	.word 0xdea72000  ! 4761: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xd8bd84a0  ! 4762: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	mov	0x48, %r18
	.word 0xd2df6000  ! 4764: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2b76000  ! 4765: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2a76000  ! 4766: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd29fa000  ! 4767: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd2a7e000  ! 4768: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xdcf6c9e0  ! 4769: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	.word 0xd6b70e60  ! 4770: STHA_R	stha	%r11, [%r28 + %r0] 0x73
	mov	0x7f8, %r21
	mov	0x68, %r24
	.word 0x87802025  ! 4773: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdedc0400  ! 4774: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	mov	0x48, %r17
	.word 0x87802073  ! 4776: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b76000  ! 4777: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd4b72000  ! 4778: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd08ec9e0  ! 4779: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r8
	.word 0xd6f7e000  ! 4780: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd687e000  ! 4781: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6af6000  ! 4782: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd68f6000  ! 4783: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xdeae49e0  ! 4784: STBA_R	stba	%r15, [%r25 + %r0] 0x4f
	mov	0x68, %r16
	.word 0xdca72000  ! 4786: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdc876000  ! 4787: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0x87802074  ! 4788: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r16
	mov	0x28, %r18
	.word 0xd2af0e60  ! 4791: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	.word 0xdece6000  ! 4792: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r15
	.word 0xdebee000  ! 4793: STDA_I	stda	%r15, [%r27 + 0x0000] %asi
	.word 0xde86a000  ! 4794: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r15
	.word 0xdea66000  ! 4795: STWA_I	stwa	%r15, [%r25 + 0x0000] %asi
	.word 0xdeb66000  ! 4796: STHA_I	stha	%r15, [%r25 + 0x0000] %asi
	mov	0x48, %r26
	.word 0xdead84a0  ! 4798: STBA_R	stba	%r15, [%r22 + %r0] 0x25
	mov	0x60, %r24
	.word 0xd4b544a0  ! 4800: STHA_R	stha	%r10, [%r21 + %r0] 0x25
	mov	0x28, %r18
	.word 0xd8af0e40  ! 4802: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	.word 0x87802072  ! 4803: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a649e0  ! 4804: STWA_R	stwa	%r12, [%r25 + %r0] 0x4f
	.word 0xd4c42000  ! 4805: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r10
	.word 0xd4ac2000  ! 4806: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0xde974e40  ! 4807: LDUHA_R	lduha	[%r29, %r0] 0x72, %r15
	.word 0xd6a4e000  ! 4808: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	mov	0x30, %r26
	.word 0xd69ce000  ! 4810: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r11
	mov	0x50, %r25
	.word 0xd0cdc4a0  ! 4812: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r8
	mov	0x68, %r19
	.word 0xd2af8e60  ! 4814: STBA_R	stba	%r9, [%r30 + %r0] 0x73
	.word 0xdef48400  ! 4815: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xdc9544a0  ! 4816: LDUHA_R	lduha	[%r21, %r0] 0x25, %r14
	.word 0xd6d46000  ! 4817: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r11
	.word 0xd69c2000  ! 4818: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r11
	.word 0xd6c42000  ! 4819: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r11
	.word 0xd6dce000  ! 4820: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0xd6a4a000  ! 4821: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	.word 0xdc8cc400  ! 4822: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	mov	0x28, %r17
	.word 0x8780204f  ! 4824: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda8ce000  ! 4825: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	.word 0xda94a000  ! 4826: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	.word 0xdaa4a000  ! 4827: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xdaac6000  ! 4828: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	.word 0xd8bc8400  ! 4829: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	mov	0x60, %r19
	.word 0xdab78e60  ! 4831: STHA_R	stha	%r13, [%r30 + %r0] 0x73
	mov	0x7d8, %r20
	.word 0xdea74e40  ! 4833: STWA_R	stwa	%r15, [%r29 + %r0] 0x72
	.word 0xd6bf4e80  ! 4834: STDA_R	stda	%r11, [%r29 + %r0] 0x74
	mov	0x28, %r16
	.word 0x87802072  ! 4836: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f70e40  ! 4837: STXA_R	stxa	%r9, [%r28 + %r0] 0x72
	.word 0xd0f72000  ! 4838: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 4839: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2ae09e0  ! 4840: STBA_R	stba	%r9, [%r24 + %r0] 0x4f
	.word 0x87802072  ! 4841: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 4842: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdab46000  ! 4843: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0xd8df8e40  ! 4844: LDXA_R	ldxa	[%r30, %r0] 0x72, %r12
	.word 0x87802020  ! 4845: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b7a000  ! 4846: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd0f7e000  ! 4847: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd6b44400  ! 4848: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xdcd7e000  ! 4849: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	mov	0x50, %r26
	.word 0xdcf72000  ! 4851: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 4852: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcace000  ! 4853: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0xdc84e000  ! 4854: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r14
	mov	0x28, %r17
	.word 0xdcd46000  ! 4856: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	.word 0xd2dd04a0  ! 4857: LDXA_R	ldxa	[%r20, %r0] 0x25, %r9
	.word 0xd6be09e0  ! 4858: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	mov	0x58, %r17
	.word 0xdaa4a000  ! 4860: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0x87802073  ! 4862: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4a74e40  ! 4863: STWA_R	stwa	%r10, [%r29 + %r0] 0x72
	.word 0xd0878e40  ! 4864: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r8
	.word 0x87802074  ! 4865: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde9c0400  ! 4866: LDDA_R	ldda	[%r16, %r0] 0x20, %r15
	mov	0x10, %r25
	.word 0xdad7e000  ! 4868: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xded7ce40  ! 4869: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r15
	.word 0xd0cc4400  ! 4870: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	.word 0xdab76000  ! 4871: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xd2a689e0  ! 4872: STWA_R	stwa	%r9, [%r26 + %r0] 0x4f
	.word 0xd4d40400  ! 4873: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	.word 0x87802072  ! 4874: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4bc0400  ! 4875: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xdeb4a000  ! 4876: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	mov	0x50, %r27
	mov	0x7c0, %r21
	.word 0xdcbec9e0  ! 4879: STDA_R	stda	%r14, [%r27 + %r0] 0x4f
	.word 0xd89c6000  ! 4880: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r12
	.word 0xd8a4a000  ! 4881: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8cca000  ! 4882: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r12
	.word 0xd8f46000  ! 4883: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8bca000  ! 4884: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 4885: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d544a0  ! 4886: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r12
	.word 0xd0ad84a0  ! 4887: STBA_R	stba	%r8, [%r22 + %r0] 0x25
	.word 0xdcc4c400  ! 4888: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	.word 0xd094a000  ! 4889: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	.word 0xd0dca000  ! 4890: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0f4e000  ! 4891: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 4892: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedd44a0  ! 4893: LDXA_R	ldxa	[%r21, %r0] 0x25, %r15
	mov	0x7f0, %r22
	.word 0xdebf6000  ! 4895: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xdecfe000  ! 4896: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	ta	T_CHANGE_PRIV	! macro
	.word 0xda9c8400  ! 4898: LDDA_R	ldda	[%r18, %r0] 0x20, %r13
	mov	0x78, %r19
	mov	0x60, %r26
	.word 0xd8af2000  ! 4901: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xd897e000  ! 4902: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	mov	0x3c8, %r21
	mov	0x50, %r24
	.word 0xd8bf2000  ! 4905: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd8cfa000  ! 4906: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd8d76000  ! 4907: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xdca649e0  ! 4908: STWA_R	stwa	%r14, [%r25 + %r0] 0x4f
	.word 0xd4a7e000  ! 4909: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4dfa000  ! 4910: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0x87802025  ! 4911: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdadcc400  ! 4912: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xd2bcc400  ! 4913: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xd0f7ce40  ! 4914: STXA_R	stxa	%r8, [%r31 + %r0] 0x72
	.word 0x87802073  ! 4915: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4978e60  ! 4916: LDUHA_R	lduha	[%r30, %r0] 0x73, %r10
	.word 0xd49c2000  ! 4917: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	.word 0xd49ce000  ! 4918: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0xd69f8e80  ! 4919: LDDA_R	ldda	[%r30, %r0] 0x74, %r11
	.word 0xde9ca000  ! 4920: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	.word 0xdec4a000  ! 4921: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xdeb42000  ! 4922: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0xdea4a000  ! 4923: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	mov	0x30, %r24
	mov	0x60, %r26
	.word 0x87802020  ! 4926: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bcc400  ! 4927: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0xd2bfe000  ! 4928: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd2f7a000  ! 4929: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 4930: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2f5a000  ! 4932: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	.word 0xdaad04a0  ! 4933: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	.word 0x8780204f  ! 4934: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 4935: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r17
	.word 0x87802073  ! 4937: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6cf2000  ! 4938: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0xd48d44a0  ! 4939: LDUBA_R	lduba	[%r21, %r0] 0x25, %r10
	mov	0x18, %r17
	.word 0xdebc0400  ! 4941: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0xd0970e40  ! 4942: LDUHA_R	lduha	[%r28, %r0] 0x72, %r8
	.word 0xdab7e000  ! 4943: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xdad48400  ! 4944: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	mov	0x3f8, %r22
	.word 0xdaac8400  ! 4946: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0xd4b74e80  ! 4947: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	.word 0x87802073  ! 4948: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaafce80  ! 4949: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	.word 0xd4d78e40  ! 4950: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r10
	.word 0xdcc7e000  ! 4951: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	mov	0x3d8, %r22
	.word 0xdeaec9e0  ! 4953: STBA_R	stba	%r15, [%r27 + %r0] 0x4f
	.word 0xd0f76000  ! 4954: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xdcbf4e60  ! 4955: STDA_R	stda	%r14, [%r29 + %r0] 0x73
	.word 0xd6bf8e80  ! 4956: STDA_R	stda	%r11, [%r30 + %r0] 0x74
	.word 0xdabfe000  ! 4957: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 4958: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda872000  ! 4959: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0x87802025  ! 4960: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0bf4e80  ! 4961: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	mov	0x38, %r24
	.word 0xdabfa000  ! 4963: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 4964: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f8, %r20
	mov	0x18, %r17
	mov	0x68, %r25
	.word 0xda96e000  ! 4968: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r13
	.word 0xd2ce09e0  ! 4969: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r9
	.word 0xd8bea000  ! 4970: STDA_I	stda	%r12, [%r26 + 0x0000] %asi
	.word 0x8780204f  ! 4971: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8df8e60  ! 4972: LDXA_R	ldxa	[%r30, %r0] 0x73, %r12
	.word 0xd2bc4400  ! 4973: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0xded5e000  ! 4974: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r15
	.word 0xd88c0400  ! 4975: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	mov	0x40, %r24
	mov	0x40, %r18
	mov	0x3d8, %r23
	mov	0x70, %r18
	mov	0x20, %r18
	mov	0x70, %r16
	.word 0xd8cf4e80  ! 4982: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r12
	.word 0x87802072  ! 4983: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6ce09e0  ! 4984: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r11
	mov	0x3e8, %r22
	.word 0x87802025  ! 4986: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2ce49e0  ! 4987: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r9
	.word 0xd0d4a000  ! 4988: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	.word 0xdaa48400  ! 4989: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0xdecec9e0  ! 4990: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r15
	.word 0xd8a42000  ! 4991: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd284c400  ! 4992: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r9
	mov	0x7d8, %r23
	.word 0xd8d48400  ! 4994: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0x87802073  ! 4995: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2bc8400  ! 4996: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	.word 0xda970e40  ! 4997: LDUHA_R	lduha	[%r28, %r0] 0x72, %r13
	mov	0x38, %r18
	mov	0x10, %r27
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_2:
	.word 0xd0b72000  ! 1: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd0cfa000  ! 2: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0xd08fa000  ! 3: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0xd6874e80  ! 4: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r11
	mov	0x58, %r24
	.word 0x87802020  ! 6: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 7: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b40400  ! 8: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0xd4afe000  ! 9: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	mov	0x3c0, %r20
	.word 0xd4876000  ! 11: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	ta	T_CHANGE_PRIV	! macro
	.word 0xd6bfce40  ! 13: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	.word 0x87802025  ! 14: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f0, %r23
	.word 0x87802025  ! 16: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4a46000  ! 17: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 18: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4bfa000  ! 19: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd4b7e000  ! 20: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd4cfa000  ! 21: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	mov	0x10, %r17
	.word 0xd4bfe000  ! 23: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd4af2000  ! 24: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd49fa000  ! 25: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0xd4df6000  ! 26: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0x87802074  ! 27: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a72000  ! 28: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xdccc8400  ! 29: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	.word 0xdaafa000  ! 30: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdab72000  ! 31: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdad44400  ! 32: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0x8780204f  ! 33: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 34: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 35: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r16
	mov	0x0, %r25
	mov	0x3e8, %r21
	mov	0x48, %r26
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2a4a000  ! 41: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 42: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bf6000  ! 43: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd2dfe000  ! 44: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2bfe000  ! 45: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd0a6c9e0  ! 46: STWA_R	stwa	%r8, [%r27 + %r0] 0x4f
	.word 0xd2d72000  ! 47: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xd2dfa000  ! 48: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xd4d4c400  ! 49: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	mov	0x30, %r19
	.word 0xd0afce60  ! 51: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	.word 0x87802072  ! 52: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4b48400  ! 53: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd0f44400  ! 54: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	mov	0x3c8, %r23
	.word 0xdacc6000  ! 56: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	.word 0xd8bf4e40  ! 57: STDA_R	stda	%r12, [%r29 + %r0] 0x72
	.word 0xd2c74e80  ! 58: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r9
	mov	0x58, %r26
	.word 0xd2978e80  ! 60: LDUHA_R	lduha	[%r30, %r0] 0x74, %r9
	.word 0x8780204f  ! 61: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0cc8400  ! 62: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0xd0b70e80  ! 63: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	.word 0xd2d6c9e0  ! 64: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r9
	.word 0xde874e80  ! 65: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r15
	.word 0x8780204f  ! 66: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 67: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdccf6000  ! 68: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xd0878e60  ! 69: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r8
	.word 0xd0d7a000  ! 70: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	mov	0x3d8, %r21
	.word 0xd0a609e0  ! 72: STWA_R	stwa	%r8, [%r24 + %r0] 0x4f
	.word 0xd09dc4a0  ! 73: LDDA_R	ldda	[%r23, %r0] 0x25, %r8
	.word 0xdecfe000  ! 74: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xd0f6c9e0  ! 75: STXA_R	stxa	%r8, [%r27 + %r0] 0x4f
	.word 0xdcf7a000  ! 76: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcaf6000  ! 77: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xd4b40400  ! 78: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	mov	0x7d0, %r20
	mov	0x0, %r17
	.word 0xd6af6000  ! 81: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xda9e89e0  ! 82: LDDA_R	ldda	[%r26, %r0] 0x4f, %r13
	.word 0x87802074  ! 83: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde87e000  ! 84: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdef72000  ! 85: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xdebfa000  ! 86: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	mov	0x28, %r17
	.word 0xdef7e000  ! 88: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 89: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca504a0  ! 90: STWA_R	stwa	%r14, [%r20 + %r0] 0x25
	.word 0xd6df0e80  ! 91: LDXA_R	ldxa	[%r28, %r0] 0x74, %r11
	.word 0x87802025  ! 92: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd28f4e40  ! 93: LDUBA_R	lduba	[%r29, %r0] 0x72, %r9
	.word 0xdad6e000  ! 94: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r13
	.word 0xd4ce09e0  ! 95: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r10
	.word 0xd0be2000  ! 96: STDA_I	stda	%r8, [%r24 + 0x0000] %asi
	.word 0xd0d62000  ! 97: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r8
	mov	0x30, %r17
	mov	0x3f8, %r21
	.word 0xd49f8e80  ! 100: LDDA_R	ldda	[%r30, %r0] 0x74, %r10
	.word 0xd68f0e40  ! 101: LDUBA_R	lduba	[%r28, %r0] 0x72, %r11
	.word 0xdef6c9e0  ! 102: STXA_R	stxa	%r15, [%r27 + %r0] 0x4f
	.word 0xdeb7ce60  ! 103: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	.word 0xdc978e60  ! 104: LDUHA_R	lduha	[%r30, %r0] 0x73, %r14
	.word 0xde8609e0  ! 105: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r15
	.word 0x87802072  ! 106: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a70e40  ! 107: STWA_R	stwa	%r12, [%r28 + %r0] 0x72
	mov	0x7e0, %r22
	.word 0xdebfa000  ! 109: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xdccf8e40  ! 110: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r14
	mov	0x3d8, %r22
	.word 0x87802073  ! 112: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f72000  ! 113: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 114: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde9f8e60  ! 115: LDDA_R	ldda	[%r30, %r0] 0x73, %r15
	.word 0xd884a000  ! 116: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r12
	.word 0xdadc0400  ! 117: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	.word 0xdc946000  ! 118: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r14
	.word 0xd89cc400  ! 119: LDDA_R	ldda	[%r19, %r0] 0x20, %r12
	.word 0xd884c400  ! 120: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	.word 0x87802074  ! 121: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdccc6000  ! 122: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	.word 0xd0bc8400  ! 123: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0x87802072  ! 124: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde9ce000  ! 125: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0xde846000  ! 126: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0xdebc6000  ! 127: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	mov	0x3d8, %r21
	.word 0x87802073  ! 129: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 130: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r21
	.word 0xdec70e80  ! 132: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r15
	.word 0xdaafa000  ! 133: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 134: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c8, %r21
	.word 0xdaafe000  ! 136: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 137: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda976000  ! 138: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	mov	0x58, %r27
	.word 0x8780204f  ! 140: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda8da000  ! 141: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r13
	.word 0xdaad2000  ! 142: STBA_I	stba	%r13, [%r20 + 0x0000] %asi
	.word 0xdaa56000  ! 143: STWA_I	stwa	%r13, [%r21 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0xda9de000  ! 145: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r13
	.word 0xd4af4e40  ! 146: STBA_R	stba	%r10, [%r29 + %r0] 0x72
	.word 0xd08f4e60  ! 147: LDUBA_R	lduba	[%r29, %r0] 0x73, %r8
	.word 0xd6a52000  ! 148: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	.word 0xdaf504a0  ! 149: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	.word 0xd4bc8400  ! 150: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	mov	0x3d0, %r21
	.word 0xd2a74e80  ! 152: STWA_R	stwa	%r9, [%r29 + %r0] 0x74
	.word 0xd0a74e40  ! 153: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	mov	0x7f8, %r21
	.word 0xd6ae09e0  ! 155: STBA_R	stba	%r11, [%r24 + %r0] 0x4f
	.word 0xd6df4e40  ! 156: LDXA_R	ldxa	[%r29, %r0] 0x72, %r11
	.word 0xd6f5a000  ! 157: STXA_I	stxa	%r11, [%r22 + 0x0000] %asi
	.word 0xd6ad2000  ! 158: STBA_I	stba	%r11, [%r20 + 0x0000] %asi
	mov	0x60, %r24
	.word 0xdaa78e80  ! 160: STWA_R	stwa	%r13, [%r30 + %r0] 0x74
	mov	0x40, %r17
	.word 0x87802020  ! 162: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bca000  ! 163: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd6974e60  ! 164: LDUHA_R	lduha	[%r29, %r0] 0x73, %r11
	.word 0xd2d7ce60  ! 165: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r9
	mov	0x20, %r25
	mov	0x28, %r17
	mov	0x10, %r18
	.word 0x87802020  ! 169: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r24
	mov	0x60, %r24
	.word 0xd6a48400  ! 172: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0x87802025  ! 173: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r19
	.word 0xd28e09e0  ! 175: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r9
	.word 0xdab4c400  ! 176: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	mov	0x3e0, %r20
	.word 0x87802074  ! 178: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 179: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e8, %r22
	.word 0xd28609e0  ! 181: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r9
	.word 0xd0840400  ! 182: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	mov	0x3d0, %r20
	.word 0x87802074  ! 184: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdea70e60  ! 185: STWA_R	stwa	%r15, [%r28 + %r0] 0x73
	.word 0xd6b649e0  ! 186: STHA_R	stha	%r11, [%r25 + %r0] 0x4f
	.word 0xd6c48400  ! 187: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	.word 0xdca7ce80  ! 188: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	.word 0xd0cc2000  ! 189: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	.word 0x87802072  ! 190: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 191: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6d649e0  ! 192: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r11
	.word 0x87802020  ! 193: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r21
	.word 0xd094a000  ! 195: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	.word 0x87802025  ! 196: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2978e40  ! 197: LDUHA_R	lduha	[%r30, %r0] 0x72, %r9
	mov	0x30, %r24
	.word 0x87802020  ! 199: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd8b44400  ! 201: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0xdcf42000  ! 202: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0xdc94a000  ! 203: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xd89fce80  ! 204: LDDA_R	ldda	[%r31, %r0] 0x74, %r12
	.word 0xdad4a000  ! 205: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0xdabca000  ! 206: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdab4e000  ! 207: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xdaa42000  ! 208: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0xd4ce09e0  ! 209: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r10
	.word 0xdcdf0e40  ! 210: LDXA_R	ldxa	[%r28, %r0] 0x72, %r14
	mov	0x48, %r25
	.word 0x8780204f  ! 212: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc9d6000  ! 213: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r14
	.word 0xdccd6000  ! 214: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r14
	mov	0x60, %r19
	.word 0xd4bfce80  ! 216: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	.word 0x87802020  ! 217: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c70e80  ! 218: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r12
	.word 0xd6d584a0  ! 219: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r11
	mov	0x7c8, %r20
	.word 0xded74e40  ! 221: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r15
	.word 0xdac76000  ! 222: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0x87802025  ! 223: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdacf0e60  ! 224: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r13
	.word 0xd6bce000  ! 225: STDA_I	stda	%r11, [%r19 + 0x0000] %asi
	mov	0x8, %r26
	.word 0x87802074  ! 227: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6af6000  ! 228: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd6bfe000  ! 229: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xda9649e0  ! 230: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r13
	mov	0x48, %r25
	mov	0x3f0, %r22
	.word 0xd0df0e60  ! 233: LDXA_R	ldxa	[%r28, %r0] 0x73, %r8
	mov	0x58, %r17
	.word 0x87802020  ! 235: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b72000  ! 236: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 237: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f5c4a0  ! 238: STXA_R	stxa	%r8, [%r23 + %r0] 0x25
	.word 0x87802072  ! 239: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb7e000  ! 240: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xdad70e40  ! 241: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r13
	.word 0x87802025  ! 242: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd684c400  ! 243: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	.word 0xd8b70e60  ! 244: STHA_R	stha	%r12, [%r28 + %r0] 0x73
	mov	0x20, %r27
	.word 0x87802073  ! 246: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd89f4e60  ! 247: LDDA_R	ldda	[%r29, %r0] 0x73, %r12
	.word 0xdcf70e40  ! 248: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	.word 0xdc97e000  ! 249: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	mov	0x20, %r26
	.word 0xdcdfe000  ! 251: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xdca72000  ! 252: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcbfe000  ! 253: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdc876000  ! 254: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0xdc8fe000  ! 255: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0x87802074  ! 256: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 257: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r21
	.word 0xd49c8400  ! 259: LDDA_R	ldda	[%r18, %r0] 0x20, %r10
	.word 0xd0c4a000  ! 260: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	mov	0x20, %r16
	.word 0xdab44400  ! 262: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0xd29cc400  ! 263: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	mov	0x30, %r18
	.word 0xdebc2000  ! 265: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xd6a5c4a0  ! 266: STWA_R	stwa	%r11, [%r23 + %r0] 0x25
	mov	0x20, %r17
	mov	0x7c8, %r23
	.word 0xd4bf8e60  ! 269: STDA_R	stda	%r10, [%r30 + %r0] 0x73
	mov	0x18, %r17
	.word 0xd2dd84a0  ! 271: LDXA_R	ldxa	[%r22, %r0] 0x25, %r9
	mov	0x7e0, %r21
	.word 0xdabca000  ! 273: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdab42000  ! 274: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 275: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4cd84a0  ! 276: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r10
	.word 0xdeb52000  ! 277: STHA_I	stha	%r15, [%r20 + 0x0000] %asi
	.word 0x8780204f  ! 278: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde96e000  ! 279: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r15
	.word 0xd49f4e80  ! 280: LDDA_R	ldda	[%r29, %r0] 0x74, %r10
	.word 0x87802072  ! 281: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb78e80  ! 282: STHA_R	stha	%r14, [%r30 + %r0] 0x74
	.word 0xdcdc2000  ! 283: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r14
	.word 0xdaafce80  ! 284: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	.word 0xda8c8400  ! 285: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	.word 0xd8f584a0  ! 286: STXA_R	stxa	%r12, [%r22 + %r0] 0x25
	.word 0xdef42000  ! 287: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xde940400  ! 288: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0x87802025  ! 289: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2cec9e0  ! 290: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r9
	.word 0xd8ac0400  ! 291: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0x87802020  ! 292: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r18
	.word 0xdc9609e0  ! 294: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r14
	.word 0xd8f70e60  ! 295: STXA_R	stxa	%r12, [%r28 + %r0] 0x73
	.word 0x87802074  ! 296: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdccf6000  ! 297: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdac649e0  ! 298: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r13
	ta	T_CHANGE_HPRIV	! macro
	mov	0x3c8, %r21
	.word 0xdac5c4a0  ! 301: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r13
	.word 0xdcdf6000  ! 302: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xdc8f6000  ! 303: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcaf2000  ! 304: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xd8c74e80  ! 305: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r12
	mov	0x7f8, %r20
	mov	0x40, %r16
	.word 0x87802020  ! 308: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r16
	.word 0xd4be09e0  ! 310: STDA_R	stda	%r10, [%r24 + %r0] 0x4f
	.word 0xd6ce49e0  ! 311: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r11
	.word 0x87802072  ! 312: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda9f4e40  ! 313: LDDA_R	ldda	[%r29, %r0] 0x72, %r13
	mov	0x7d8, %r21
	.word 0xdecee000  ! 315: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r15
	.word 0xdec6e000  ! 316: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r15
	mov	0x10, %r24
	mov	0x70, %r19
	.word 0x87802074  ! 319: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r27
	mov	0x3d0, %r20
	mov	0x28, %r25
	mov	0x70, %r18
	mov	0x3f8, %r22
	.word 0xdeb7e000  ! 325: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xd8848400  ! 326: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r12
	mov	0x18, %r19
	mov	0x40, %r25
	.word 0x8780204f  ! 329: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d8, %r23
	.word 0xd697ce40  ! 331: LDUHA_R	lduha	[%r31, %r0] 0x72, %r11
	.word 0xdaa7ce40  ! 332: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	.word 0xd0a544a0  ! 333: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	mov	0x70, %r26
	.word 0xd4f48400  ! 335: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	mov	0x3f8, %r22
	.word 0x87802020  ! 337: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d70e60  ! 338: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r10
	mov	0x20, %r25
	mov	0x28, %r24
	mov	0x3d8, %r22
	.word 0x87802025  ! 342: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd884a000  ! 343: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r12
	.word 0xd8b4e000  ! 344: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0xd0af4e80  ! 345: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	.word 0x8780204f  ! 346: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r26
	.word 0x87802020  ! 348: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r23
	mov	0x18, %r26
	.word 0xd08f8e40  ! 351: LDUBA_R	lduba	[%r30, %r0] 0x72, %r8
	.word 0xdebee000  ! 352: STDA_I	stda	%r15, [%r27 + 0x0000] %asi
	mov	0x68, %r17
	.word 0xdeaea000  ! 354: STBA_I	stba	%r15, [%r26 + 0x0000] %asi
	.word 0xd2874e60  ! 355: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r9
	.word 0xdecea000  ! 356: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r15
	mov	0x28, %r19
	.word 0xdece6000  ! 358: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r15
	.word 0xde9ee000  ! 359: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r15
	.word 0xd0cf8e80  ! 360: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r8
	.word 0x87802025  ! 361: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a40400  ! 362: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0xda852000  ! 363: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r13
	mov	0x10, %r17
	.word 0xdacf0e60  ! 365: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r13
	.word 0xd6f4c400  ! 366: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0xd2d74e60  ! 367: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r9
	.word 0xda9c0400  ! 368: LDDA_R	ldda	[%r16, %r0] 0x20, %r13
	.word 0x87802074  ! 369: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf4e000  ! 370: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	mov	0x3c0, %r23
	.word 0xda844400  ! 372: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r13
	.word 0xde94a000  ! 373: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0xdef46000  ! 374: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xdea4a000  ! 375: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x30, %r18
	.word 0xdec46000  ! 378: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	.word 0xdec44400  ! 379: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0xd88c6000  ! 380: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	mov	0x3c0, %r21
	.word 0xd8bca000  ! 382: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd8d4e000  ! 383: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0xd8946000  ! 384: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	.word 0xd8a4e000  ! 385: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	mov	0x10, %r18
	.word 0xded40400  ! 387: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	.word 0xd4f46000  ! 388: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0xd4bce000  ! 389: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0xd4a4a000  ! 390: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xd4bc6000  ! 391: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xd6f74e60  ! 392: STXA_R	stxa	%r11, [%r29 + %r0] 0x73
	.word 0xd8bca000  ! 393: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd89ce000  ! 395: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	.word 0xd09d84a0  ! 396: LDDA_R	ldda	[%r22, %r0] 0x25, %r8
	.word 0xd68d04a0  ! 397: LDUBA_R	lduba	[%r20, %r0] 0x25, %r11
	.word 0x8780204f  ! 398: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeaf6000  ! 399: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 400: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde8d44a0  ! 401: LDUBA_R	lduba	[%r21, %r0] 0x25, %r15
	.word 0xd6af6000  ! 402: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd6af2000  ! 403: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x7f8, %r23
	mov	0x20, %r18
	mov	0x60, %r27
	.word 0xdcae89e0  ! 407: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	.word 0xd8f7e000  ! 408: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8c7a000  ! 409: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xd6bf0e60  ! 410: STDA_R	stda	%r11, [%r28 + %r0] 0x73
	.word 0x8780204f  ! 411: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d8, %r22
	.word 0xd2872000  ! 413: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	mov	0x38, %r18
	.word 0xd2a44400  ! 415: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	mov	0x3e8, %r21
	.word 0xd8cc4400  ! 417: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r12
	.word 0xd6b7e000  ! 418: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd8f40400  ! 419: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xd8cf6000  ! 420: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	mov	0x7f8, %r21
	mov	0x58, %r19
	.word 0xd8cf6000  ! 423: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0xd0c7ce80  ! 424: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r8
	mov	0x30, %r16
	mov	0x68, %r17
	mov	0x7c0, %r22
	mov	0x7e8, %r21
	mov	0x18, %r26
	mov	0x38, %r25
	.word 0xd68cc400  ! 431: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	.word 0xdabfce40  ! 432: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	mov	0x38, %r18
	.word 0xd49f0e80  ! 434: LDDA_R	ldda	[%r28, %r0] 0x74, %r10
	.word 0xd0a649e0  ! 435: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	.word 0xda8f2000  ! 436: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xdad7a000  ! 437: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0xdef70e60  ! 438: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	.word 0xd2a7e000  ! 439: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xd2afe000  ! 440: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	mov	0x40, %r18
	.word 0xd29fe000  ! 442: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	mov	0x3d8, %r23
	.word 0x87802020  ! 444: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29c6000  ! 445: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0b78e60  ! 447: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	mov	0x10, %r19
	.word 0x87802073  ! 449: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc940400  ! 450: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0xd08f8e40  ! 451: LDUBA_R	lduba	[%r30, %r0] 0x72, %r8
	mov	0x3f8, %r22
	mov	0x20, %r27
	.word 0xd4c72000  ! 454: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r10
	mov	0x7c0, %r20
	.word 0xd2bf8e40  ! 456: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	.word 0xdcbf6000  ! 457: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 458: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd89584a0  ! 459: LDUHA_R	lduha	[%r22, %r0] 0x25, %r12
	.word 0x87802020  ! 460: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9c2000  ! 461: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xde8ce000  ! 462: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	mov	0x3e8, %r22
	.word 0x87802072  ! 464: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdea4e000  ! 465: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xdecc2000  ! 466: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	.word 0xd68609e0  ! 467: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r11
	.word 0xd694c400  ! 468: LDUHA_R	lduha	[%r19, %r0] 0x20, %r11
	.word 0x87802074  ! 469: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8a7ce40  ! 470: STWA_R	stwa	%r12, [%r31 + %r0] 0x72
	.word 0x87802025  ! 471: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd69fe000  ! 472: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	.word 0xd8bc8400  ! 473: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xd497a000  ! 474: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0xd4f7e000  ! 475: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	mov	0x10, %r17
	mov	0x18, %r24
	.word 0xdaa689e0  ! 478: STWA_R	stwa	%r13, [%r26 + %r0] 0x4f
	mov	0x7d0, %r22
	mov	0x20, %r19
	mov	0x7f8, %r21
	mov	0x3d8, %r21
	.word 0xd6c76000  ! 483: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6cf2000  ! 484: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0x87802025  ! 485: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r17
	.word 0xd6ce6000  ! 487: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r11
	.word 0xd0a5c4a0  ! 488: STWA_R	stwa	%r8, [%r23 + %r0] 0x25
	.word 0xdabf8e40  ! 489: STDA_R	stda	%r13, [%r30 + %r0] 0x72
	mov	0x8, %r27
	.word 0xdcbe6000  ! 491: STDA_I	stda	%r14, [%r25 + 0x0000] %asi
	.word 0xdacf4e80  ! 492: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r13
	.word 0x87802074  ! 493: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc87e000  ! 494: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcd7a000  ! 495: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	mov	0x7f0, %r20
	mov	0x60, %r17
	.word 0xdc9fe000  ! 498: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	mov	0x7c0, %r22
	.word 0xdeacc400  ! 500: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xd2b609e0  ! 501: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	.word 0x87802072  ! 502: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb6c9e0  ! 503: STHA_R	stha	%r15, [%r27 + %r0] 0x4f
	.word 0xd69fce80  ! 504: LDDA_R	ldda	[%r31, %r0] 0x74, %r11
	.word 0xdef544a0  ! 505: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	.word 0xd4dfa000  ! 506: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd48f4e40  ! 507: LDUBA_R	lduba	[%r29, %r0] 0x72, %r10
	mov	0x7f0, %r23
	.word 0xd8d72000  ! 509: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xd8bf2000  ! 510: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 511: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c8, %r21
	.word 0xd88ca000  ! 513: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	.word 0x87802074  ! 514: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r25
	.word 0xdcacc400  ! 516: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	mov	0x7c8, %r20
	mov	0x38, %r27
	.word 0xdabf8e80  ! 519: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	.word 0xd0ad2000  ! 520: STBA_I	stba	%r8, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 521: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd087a000  ! 522: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2cfce80  ! 524: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r9
	.word 0xd8f74e80  ! 525: STXA_R	stxa	%r12, [%r29 + %r0] 0x74
	.word 0xd6bf2000  ! 526: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	mov	0x10, %r25
	mov	0x50, %r19
	mov	0x58, %r27
	.word 0xdccf8e80  ! 530: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r14
	.word 0xdaf7e000  ! 531: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xd4dd44a0  ! 532: LDXA_R	ldxa	[%r21, %r0] 0x25, %r10
	mov	0x20, %r16
	.word 0xd2cf6000  ! 534: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	mov	0x3d8, %r20
	mov	0x3e8, %r22
	.word 0xd2f48400  ! 537: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0xd2b78e40  ! 538: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	.word 0xdccc0400  ! 539: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r14
	.word 0xd8cfe000  ! 540: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x30, %r18
	.word 0xd88f6000  ! 543: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xd6af0e60  ! 544: STBA_R	stba	%r11, [%r28 + %r0] 0x73
	.word 0xd4c40400  ! 545: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	.word 0xd6978e60  ! 546: LDUHA_R	lduha	[%r30, %r0] 0x73, %r11
	.word 0xd09649e0  ! 547: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r8
	.word 0xd29fa000  ! 548: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd2df2000  ! 549: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd4c74e60  ! 550: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r10
	mov	0x40, %r26
	.word 0xd4f48400  ! 552: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xdca40400  ! 553: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xd4ac0400  ! 554: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0x87802020  ! 555: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cf4e40  ! 556: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	.word 0xdacf8e60  ! 557: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r13
	.word 0xd4bf8e80  ! 558: STDA_R	stda	%r10, [%r30 + %r0] 0x74
	.word 0xd0a44400  ! 559: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	mov	0x10, %r26
	.word 0xd8ae2000  ! 561: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	.word 0xdedf0e80  ! 562: LDXA_R	ldxa	[%r28, %r0] 0x74, %r15
	.word 0xd2f6e000  ! 563: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	.word 0xdcd70e60  ! 564: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r14
	mov	0x60, %r16
	.word 0xd2cf4e40  ! 566: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r9
	.word 0xd684c400  ! 567: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	.word 0xd0966000  ! 568: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r8
	.word 0xdc8544a0  ! 569: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r14
	.word 0xda97ce40  ! 570: LDUHA_R	lduha	[%r31, %r0] 0x72, %r13
	mov	0x78, %r26
	.word 0x87802073  ! 572: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 573: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r16
	.word 0xd2bd6000  ! 575: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 576: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d4e000  ! 577: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0xd2b4e000  ! 578: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	mov	0x3f0, %r21
	.word 0xd8d40400  ! 580: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	.word 0xdea4a000  ! 581: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xdaf48400  ! 582: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xd6f44400  ! 583: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0x87802072  ! 584: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda94c400  ! 585: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	mov	0x68, %r17
	.word 0xd4d7ce80  ! 587: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r10
	mov	0x70, %r19
	.word 0xdcc4c400  ! 589: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	mov	0x7c0, %r21
	.word 0x87802025  ! 591: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r26
	.word 0xd8a7e000  ! 593: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	mov	0x38, %r18
	mov	0x68, %r18
	.word 0x87802072  ! 596: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4b78e40  ! 597: STHA_R	stha	%r10, [%r30 + %r0] 0x72
	.word 0xd2af2000  ! 598: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	mov	0x48, %r27
	.word 0xd2c7e000  ! 600: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	mov	0x0, %r25
	.word 0xd2bfe000  ! 602: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd2f76000  ! 603: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 604: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6c74e80  ! 605: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r11
	mov	0x70, %r16
	.word 0xd6c4a000  ! 607: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r11
	mov	0x3f8, %r21
	.word 0xd6ac6000  ! 609: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xdabe89e0  ! 610: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	.word 0xdc8d44a0  ! 611: LDUBA_R	lduba	[%r21, %r0] 0x25, %r14
	.word 0xd69f4e40  ! 612: LDDA_R	ldda	[%r29, %r0] 0x72, %r11
	mov	0x78, %r17
	.word 0xd8dc8400  ! 614: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xd2c4a000  ! 615: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	mov	0x40, %r18
	.word 0xd2cca000  ! 617: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	.word 0x87802073  ! 618: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef44400  ! 619: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xdea5e000  ! 620: STWA_I	stwa	%r15, [%r23 + 0x0000] %asi
	.word 0xdeade000  ! 621: STBA_I	stba	%r15, [%r23 + 0x0000] %asi
	.word 0xd69d84a0  ! 622: LDDA_R	ldda	[%r22, %r0] 0x25, %r11
	.word 0xd48544a0  ! 623: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r10
	.word 0xdec44400  ! 624: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	mov	0x10, %r19
	.word 0xdca544a0  ! 626: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0xd0a5a000  ! 627: STWA_I	stwa	%r8, [%r22 + 0x0000] %asi
	.word 0xd0bda000  ! 628: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	.word 0xd0870e40  ! 629: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r8
	mov	0x0, %r18
	.word 0xd28de000  ! 631: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r9
	mov	0x18, %r17
	mov	0x7e0, %r21
	.word 0x87802020  ! 634: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 635: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd297e000  ! 636: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	.word 0x87802074  ! 637: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd296e000  ! 638: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r9
	mov	0x28, %r27
	.word 0xd2c66000  ! 640: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r9
	.word 0x87802025  ! 641: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2af6000  ! 642: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 643: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6adc4a0  ! 644: STBA_R	stba	%r11, [%r23 + %r0] 0x25
	mov	0x60, %r24
	mov	0x38, %r19
	.word 0xda9fa000  ! 647: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	mov	0x48, %r25
	.word 0xdabf6000  ! 649: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 650: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8dcc400  ! 651: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	.word 0xdc8c4400  ! 652: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0xde8fce40  ! 653: LDUBA_R	lduba	[%r31, %r0] 0x72, %r15
	.word 0x87802074  ! 654: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6856000  ! 655: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r11
	.word 0x87802020  ! 656: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68e6000  ! 657: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r11
	.word 0xd4f48400  ! 658: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xdcc48400  ! 659: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r14
	.word 0xdad70e80  ! 660: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r13
	mov	0x58, %r18
	.word 0xdcf40400  ! 662: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xd2b48400  ! 663: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd6866000  ! 664: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r11
	mov	0x8, %r17
	.word 0x87802072  ! 666: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b74e40  ! 667: STHA_R	stha	%r12, [%r29 + %r0] 0x72
	mov	0x7d8, %r22
	.word 0xdcaf6000  ! 669: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 670: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdad48400  ! 671: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0x87802072  ! 672: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2ada000  ! 673: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xd28d6000  ! 674: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r9
	mov	0x0, %r27
	.word 0xd2bd2000  ! 676: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	.word 0xd8d584a0  ! 677: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r12
	.word 0xd08e09e0  ! 678: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r8
	.word 0xd8a40400  ! 679: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0xd6ddc4a0  ! 680: LDXA_R	ldxa	[%r23, %r0] 0x25, %r11
	.word 0xd08fce80  ! 681: LDUBA_R	lduba	[%r31, %r0] 0x74, %r8
	.word 0xd4b5e000  ! 682: STHA_I	stha	%r10, [%r23 + 0x0000] %asi
	.word 0xd48da000  ! 683: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r10
	mov	0x50, %r18
	.word 0x87802072  ! 685: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6874e40  ! 686: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r11
	mov	0x0, %r19
	.word 0xd687ce60  ! 688: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r11
	.word 0x87802073  ! 689: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 690: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r26
	.word 0xdeafe000  ! 692: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xd8940400  ! 693: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	.word 0xd0a76000  ! 694: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	mov	0x8, %r24
	.word 0x87802074  ! 696: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcc78e60  ! 697: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r14
	.word 0xdc97ce40  ! 698: LDUHA_R	lduha	[%r31, %r0] 0x72, %r14
	.word 0xdcf7e000  ! 699: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xde8f4e60  ! 700: LDUBA_R	lduba	[%r29, %r0] 0x73, %r15
	mov	0x7c8, %r22
	.word 0xd2b76000  ! 702: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	mov	0x48, %r17
	mov	0x38, %r18
	.word 0x87802072  ! 705: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4bf4e40  ! 706: STDA_R	stda	%r10, [%r29 + %r0] 0x72
	mov	0x68, %r16
	.word 0xd4a70e40  ! 708: STWA_R	stwa	%r10, [%r28 + %r0] 0x72
	.word 0xd8b70e60  ! 709: STHA_R	stha	%r12, [%r28 + %r0] 0x73
	.word 0xd6cca000  ! 710: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 711: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd09fce60  ! 712: LDDA_R	ldda	[%r31, %r0] 0x73, %r8
	.word 0xdc8da000  ! 713: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r14
	.word 0xdc95a000  ! 714: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r14
	.word 0xdedfce40  ! 715: LDXA_R	ldxa	[%r31, %r0] 0x72, %r15
	.word 0xd09c0400  ! 716: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	.word 0xdef74e60  ! 717: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	mov	0x18, %r24
	.word 0xdaae89e0  ! 719: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	.word 0xd8c40400  ! 720: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	.word 0xdaad2000  ! 721: STBA_I	stba	%r13, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 722: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcdf4e40  ! 723: LDXA_R	ldxa	[%r29, %r0] 0x72, %r14
	.word 0xdca4e000  ! 724: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0x87802020  ! 726: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0d40400  ! 727: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	.word 0xd6a72000  ! 728: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6c76000  ! 729: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	mov	0x7f8, %r20
	.word 0xd697a000  ! 731: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0xd6b7e000  ! 732: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	mov	0x7c8, %r21
	mov	0x3d8, %r20
	.word 0xd6d7a000  ! 735: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	mov	0x3d0, %r20
	.word 0xda8fce80  ! 737: LDUBA_R	lduba	[%r31, %r0] 0x74, %r13
	.word 0xdcafe000  ! 738: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xd2acc400  ! 739: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	mov	0x7f0, %r21
	.word 0xdc8f2000  ! 741: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0xdca72000  ! 742: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdccf6000  ! 743: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcafe000  ! 744: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdcdfa000  ! 745: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcbf6000  ! 746: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdcb7a000  ! 747: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xd4a48400  ! 748: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	mov	0x8, %r25
	.word 0xdcbd04a0  ! 750: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	.word 0xdacf0e60  ! 751: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r13
	.word 0xde8f8e40  ! 752: LDUBA_R	lduba	[%r30, %r0] 0x72, %r15
	.word 0xd2df6000  ! 753: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	mov	0x70, %r18
	.word 0xd2bfa000  ! 755: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd2bf6000  ! 756: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	mov	0x0, %r19
	mov	0x30, %r19
	.word 0xd297a000  ! 759: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	mov	0x78, %r26
	.word 0xded504a0  ! 761: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r15
	.word 0xd68f8e60  ! 762: LDUBA_R	lduba	[%r30, %r0] 0x73, %r11
	.word 0xd8d7ce60  ! 763: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r12
	mov	0x3f0, %r20
	.word 0xd2d5c4a0  ! 765: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r9
	.word 0x87802073  ! 766: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8b72000  ! 767: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	mov	0x60, %r19
	.word 0xd8a7a000  ! 769: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xdad7ce40  ! 770: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r13
	.word 0xd2bfa000  ! 771: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd29fa000  ! 772: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd2afe000  ! 773: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xdecf4e80  ! 774: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r15
	.word 0xd6a7a000  ! 775: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xdea6c9e0  ! 776: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	.word 0xd29fe000  ! 777: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	mov	0x7f8, %r21
	mov	0x7e8, %r20
	.word 0xd2c76000  ! 780: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	mov	0x7d0, %r22
	mov	0x10, %r26
	mov	0x7f0, %r23
	.word 0x87802072  ! 784: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b544a0  ! 785: STHA_R	stha	%r8, [%r21 + %r0] 0x25
	.word 0x87802025  ! 786: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeae49e0  ! 787: STBA_R	stba	%r15, [%r25 + %r0] 0x4f
	.word 0xd2cca000  ! 788: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2846000  ! 789: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r9
	mov	0x8, %r18
	.word 0xdcac0400  ! 791: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xd2a504a0  ! 792: STWA_R	stwa	%r9, [%r20 + %r0] 0x25
	.word 0x87802072  ! 793: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd88d2000  ! 794: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r12
	.word 0xd8d5e000  ! 795: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r12
	.word 0xd8dde000  ! 796: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r12
	mov	0x70, %r26
	.word 0x8780204f  ! 798: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ad6000  ! 799: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	.word 0xd8bd6000  ! 800: STDA_I	stda	%r12, [%r21 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xd8ada000  ! 802: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0xd89f8e60  ! 803: LDDA_R	ldda	[%r30, %r0] 0x73, %r12
	.word 0xd6bf4e40  ! 804: STDA_R	stda	%r11, [%r29 + %r0] 0x72
	mov	0x70, %r25
	.word 0xd88e09e0  ! 806: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r12
	.word 0xdaf52000  ! 807: STXA_I	stxa	%r13, [%r20 + 0x0000] %asi
	.word 0xda8da000  ! 808: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r13
	.word 0xdaafce60  ! 809: STBA_R	stba	%r13, [%r31 + %r0] 0x73
	.word 0xd2bfce60  ! 810: STDA_R	stda	%r9, [%r31 + %r0] 0x73
	.word 0xdcc52000  ! 811: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r14
	.word 0xdc85a000  ! 812: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r14
	mov	0x8, %r27
	.word 0xd2ccc400  ! 814: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	.word 0xdaf78e40  ! 815: STXA_R	stxa	%r13, [%r30 + %r0] 0x72
	.word 0xd6874e80  ! 816: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r11
	.word 0xdc9da000  ! 817: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r14
	.word 0xdcbde000  ! 818: STDA_I	stda	%r14, [%r23 + 0x0000] %asi
	.word 0xd4af8e60  ! 819: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	.word 0xd2a5a000  ! 820: STWA_I	stwa	%r9, [%r22 + 0x0000] %asi
	.word 0xdec4c400  ! 821: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	mov	0x10, %r24
	.word 0xdca52000  ! 823: STWA_I	stwa	%r14, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 824: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc976000  ! 825: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	.word 0xdcdf6000  ! 826: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	mov	0x10, %r16
	.word 0x87802025  ! 828: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 829: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r25
	.word 0xdcdf6000  ! 831: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xdacf0e80  ! 832: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r13
	.word 0xdaa6c9e0  ! 833: STWA_R	stwa	%r13, [%r27 + %r0] 0x4f
	.word 0xd0b7e000  ! 834: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 835: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r26
	mov	0x8, %r17
	mov	0x58, %r17
	.word 0x87802020  ! 839: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd096a000  ! 840: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r8
	mov	0x3c8, %r22
	.word 0xd48609e0  ! 842: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r10
	.word 0xd6de6000  ! 843: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r11
	.word 0xd8b4c400  ! 844: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0xded584a0  ! 845: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r15
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x3f8, %r22
	mov	0x48, %r25
	mov	0x0, %r27
	.word 0x87802020  ! 850: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08e2000  ! 851: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r8
	.word 0x87802025  ! 852: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0ac6000  ! 853: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0xd6bc4400  ! 854: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	.word 0xdcdc2000  ! 855: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r14
	.word 0xdca4a000  ! 856: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0xdc84e000  ! 857: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r14
	mov	0x3d8, %r23
	.word 0xd68f4e40  ! 859: LDUBA_R	lduba	[%r29, %r0] 0x72, %r11
	.word 0xd4ccc400  ! 860: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0xd8c46000  ! 861: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r12
	.word 0xd8978e40  ! 862: LDUHA_R	lduha	[%r30, %r0] 0x72, %r12
	.word 0xd6b42000  ! 863: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	mov	0x0, %r18
	.word 0xd68ca000  ! 865: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r11
	.word 0xd4a74e40  ! 866: STWA_R	stwa	%r10, [%r29 + %r0] 0x72
	.word 0xd2ac4400  ! 867: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	mov	0x10, %r27
	.word 0xd2afce60  ! 869: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	.word 0xd0bfce60  ! 870: STDA_R	stda	%r8, [%r31 + %r0] 0x73
	.word 0x87802025  ! 871: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdecd44a0  ! 872: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r15
	.word 0xdacfa000  ! 873: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	mov	0x40, %r18
	.word 0xdc8cc400  ! 875: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	mov	0x7e8, %r23
	.word 0x87802020  ! 877: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0afa000  ! 878: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	mov	0x78, %r25
	.word 0xd2c70e80  ! 880: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r9
	.word 0xdcf72000  ! 881: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	mov	0x20, %r24
	.word 0xd4cc8400  ! 883: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	.word 0xd6f76000  ! 884: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xdeaf4e80  ! 885: STBA_R	stba	%r15, [%r29 + %r0] 0x74
	.word 0xd2b76000  ! 886: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd29f2000  ! 887: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xdccfce60  ! 888: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r14
	.word 0x87802025  ! 889: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 890: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b7ce80  ! 891: STHA_R	stha	%r10, [%r31 + %r0] 0x74
	.word 0xd0b4e000  ! 892: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xdabd84a0  ! 893: STDA_R	stda	%r13, [%r22 + %r0] 0x25
	mov	0x28, %r27
	.word 0xd0b42000  ! 895: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xd0cca000  ! 896: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	mov	0x7c0, %r21
	mov	0x3f0, %r23
	.word 0xd0f46000  ! 899: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0c42000  ! 900: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 901: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 902: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b609e0  ! 903: STHA_R	stha	%r10, [%r24 + %r0] 0x4f
	.word 0xd4d74e60  ! 904: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r10
	mov	0x30, %r25
	.word 0xd6b7e000  ! 906: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	mov	0x7e8, %r23
	mov	0x40, %r24
	.word 0xd2f78e60  ! 909: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0xd28fe000  ! 910: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	mov	0x30, %r18
	.word 0xdebcc400  ! 912: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	.word 0xd6f7ce40  ! 913: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	mov	0x10, %r17
	.word 0x87802020  ! 915: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 916: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r17
	.word 0xd2c4e000  ! 918: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0x87802025  ! 919: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r18
	.word 0xd2d7e000  ! 921: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xd2876000  ! 922: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2f7ce60  ! 923: STXA_R	stxa	%r9, [%r31 + %r0] 0x73
	mov	0x58, %r26
	mov	0x20, %r27
	.word 0xdcbe49e0  ! 926: STDA_R	stda	%r14, [%r25 + %r0] 0x4f
	.word 0xd4bf0e40  ! 927: STDA_R	stda	%r10, [%r28 + %r0] 0x72
	.word 0xd6b72000  ! 928: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 929: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdad74e60  ! 930: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r13
	.word 0x8780204f  ! 931: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc84a000  ! 932: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	.word 0xdccc6000  ! 933: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	.word 0xdc9c6000  ! 934: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r14
	.word 0xd2848400  ! 935: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r9
	mov	0x68, %r24
	.word 0xd49e09e0  ! 937: LDDA_R	ldda	[%r24, %r0] 0x4f, %r10
	.word 0x87802073  ! 938: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2d56000  ! 939: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r9
	mov	0x0, %r16
	.word 0xd29c8400  ! 941: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	mov	0x28, %r26
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcd56000  ! 944: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r14
	.word 0x87802025  ! 945: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4ce49e0  ! 946: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r10
	.word 0xdaf7e000  ! 947: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xd69e09e0  ! 948: LDDA_R	ldda	[%r24, %r0] 0x4f, %r11
	.word 0xdebf6000  ! 949: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xdea72000  ! 950: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 951: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 952: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd89cc400  ! 953: LDDA_R	ldda	[%r19, %r0] 0x20, %r12
	.word 0xd88ee000  ! 954: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r12
	mov	0x70, %r24
	.word 0xd8cc8400  ! 956: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0xde874e80  ! 957: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r15
	mov	0x7e0, %r20
	.word 0xd2b6a000  ! 959: STHA_I	stha	%r9, [%r26 + 0x0000] %asi
	.word 0xd286e000  ! 960: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r9
	mov	0x7d8, %r20
	mov	0x7d0, %r23
	.word 0xd2f62000  ! 963: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	mov	0x78, %r24
	.word 0x87802072  ! 965: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r19
	.word 0xd68e89e0  ! 967: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r11
	mov	0x7d0, %r21
	.word 0xd68cc400  ! 969: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	mov	0x28, %r18
	.word 0xd8c7e000  ! 971: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0xd2a70e40  ! 972: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	.word 0xdac70e80  ! 973: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r13
	.word 0xd087a000  ! 974: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0xdcb78e60  ! 975: STHA_R	stha	%r14, [%r30 + %r0] 0x73
	.word 0xdcd4c400  ! 976: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	mov	0x10, %r25
	.word 0xdcacc400  ! 978: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	mov	0x3d8, %r20
	.word 0xdcf7a000  ! 980: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xdccf2000  ! 981: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xdcc584a0  ! 982: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r14
	.word 0x8780204f  ! 983: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcb48400  ! 984: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xd4ad84a0  ! 985: STBA_R	stba	%r10, [%r22 + %r0] 0x25
	.word 0xdecc6000  ! 986: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r15
	.word 0xd8bd84a0  ! 987: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	mov	0x68, %r19
	.word 0xd4b4e000  ! 989: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xd09f8e60  ! 990: LDDA_R	ldda	[%r30, %r0] 0x73, %r8
	.word 0xd684e000  ! 991: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r11
	.word 0x87802020  ! 992: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ac6000  ! 993: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xd6d4e000  ! 994: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r11
	mov	0x0, %r19
	.word 0x87802020  ! 996: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ad2000  ! 997: STBA_I	stba	%r11, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 998: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28d44a0  ! 999: LDUBA_R	lduba	[%r21, %r0] 0x25, %r9
	.word 0xdabd2000  ! 1000: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	mov	0x3e0, %r20
	mov	0x50, %r18
	mov	0x78, %r17
	.word 0xd6ae49e0  ! 1004: STBA_R	stba	%r11, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 1005: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r25
	.word 0xd8dc0400  ! 1007: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0xd6bd84a0  ! 1008: STDA_R	stda	%r11, [%r22 + %r0] 0x25
	.word 0xdeb48400  ! 1009: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xd2b6e000  ! 1010: STHA_I	stha	%r9, [%r27 + 0x0000] %asi
	.word 0xd29e2000  ! 1011: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r9
	.word 0xdebf0e80  ! 1012: STDA_R	stda	%r15, [%r28 + %r0] 0x74
	.word 0x87802073  ! 1013: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca40400  ! 1014: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xd094c400  ! 1015: LDUHA_R	lduha	[%r19, %r0] 0x20, %r8
	mov	0x7e8, %r23
	.word 0xd29f8e40  ! 1017: LDDA_R	ldda	[%r30, %r0] 0x72, %r9
	.word 0xd6c72000  ! 1018: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0xd69f2000  ! 1019: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xd6a76000  ! 1020: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd0844400  ! 1021: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r8
	.word 0xdec6c9e0  ! 1022: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r15
	.word 0x8780204f  ! 1023: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf44400  ! 1024: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xd2bc0400  ! 1025: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	mov	0x3c8, %r23
	.word 0xd4cf0e80  ! 1027: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r10
	.word 0xdac66000  ! 1028: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r13
	.word 0xdcb609e0  ! 1029: STHA_R	stha	%r14, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 1030: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2dd44a0  ! 1031: LDXA_R	ldxa	[%r21, %r0] 0x25, %r9
	mov	0x3e8, %r22
	.word 0xd8f6e000  ! 1033: STXA_I	stxa	%r12, [%r27 + 0x0000] %asi
	.word 0xd8b66000  ! 1034: STHA_I	stha	%r12, [%r25 + 0x0000] %asi
	.word 0xde9cc400  ! 1035: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	.word 0xd8ce6000  ! 1036: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r12
	.word 0xd8d6e000  ! 1037: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r12
	mov	0x58, %r17
	mov	0x50, %r27
	.word 0xd8de2000  ! 1040: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r12
	.word 0xd6d4c400  ! 1041: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	.word 0x87802020  ! 1042: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r24
	.word 0xdca52000  ! 1044: STWA_I	stwa	%r14, [%r20 + 0x0000] %asi
	.word 0xdc8d2000  ! 1045: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r14
	.word 0xdc9d6000  ! 1046: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r14
	.word 0xdca52000  ! 1047: STWA_I	stwa	%r14, [%r20 + 0x0000] %asi
	.word 0xdc8d6000  ! 1048: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r14
	.word 0xdab74e60  ! 1049: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 1050: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 1051: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4dec9e0  ! 1052: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r10
	.word 0xd2bfa000  ! 1053: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd2972000  ! 1054: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	mov	0x0, %r18
	.word 0xd2d72000  ! 1056: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xdc8c4400  ! 1057: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0xdcf7ce60  ! 1058: STXA_R	stxa	%r14, [%r31 + %r0] 0x73
	.word 0x87802074  ! 1059: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r18
	.word 0x87802020  ! 1061: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f70e40  ! 1062: STXA_R	stxa	%r9, [%r28 + %r0] 0x72
	.word 0x87802025  ! 1063: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f8, %r23
	.word 0xd2f5e000  ! 1065: STXA_I	stxa	%r9, [%r23 + 0x0000] %asi
	.word 0xd2cd6000  ! 1066: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r9
	.word 0xd28da000  ! 1067: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r9
	.word 0xdebc0400  ! 1068: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0xd8f56000  ! 1069: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	mov	0x60, %r17
	mov	0x38, %r16
	.word 0xdaf74e60  ! 1072: STXA_R	stxa	%r13, [%r29 + %r0] 0x73
	.word 0xd2ad6000  ! 1073: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	mov	0x68, %r24
	.word 0xd4c48400  ! 1075: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r10
	mov	0x7e8, %r20
	.word 0x87802073  ! 1077: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r16
	.word 0x8780204f  ! 1079: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2ce2000  ! 1080: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r9
	.word 0x87802025  ! 1081: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde95c4a0  ! 1082: LDUHA_R	lduha	[%r23, %r0] 0x25, %r15
	.word 0x8780204f  ! 1083: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8adc4a0  ! 1084: STBA_R	stba	%r12, [%r23 + %r0] 0x25
	.word 0xd29c6000  ! 1085: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	.word 0xd2b4a000  ! 1086: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 1087: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2bda000  ! 1089: STDA_I	stda	%r9, [%r22 + 0x0000] %asi
	mov	0x68, %r17
	.word 0x8780204f  ! 1091: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1092: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bf6000  ! 1093: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd2c76000  ! 1094: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0xdadf8e80  ! 1095: LDXA_R	ldxa	[%r30, %r0] 0x74, %r13
	.word 0xdaa76000  ! 1096: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xda8fa000  ! 1097: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xdaf72000  ! 1098: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 1099: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1100: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda970e80  ! 1101: LDUHA_R	lduha	[%r28, %r0] 0x74, %r13
	.word 0xd4dfe000  ! 1102: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4f7e000  ! 1103: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1104: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf74e60  ! 1105: STXA_R	stxa	%r14, [%r29 + %r0] 0x73
	.word 0xd89fa000  ! 1106: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	.word 0xd8dfe000  ! 1107: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	mov	0x40, %r27
	.word 0xd8976000  ! 1109: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	mov	0x18, %r17
	mov	0x48, %r18
	mov	0x38, %r19
	.word 0xd8af6000  ! 1113: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	mov	0x3d0, %r23
	mov	0x7d0, %r22
	.word 0xd8a7a000  ! 1116: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd6b5c4a0  ! 1117: STHA_R	stha	%r11, [%r23 + %r0] 0x25
	mov	0x3d8, %r22
	mov	0x48, %r16
	mov	0x3d0, %r21
	.word 0x87802020  ! 1121: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r26
	.word 0x87802072  ! 1123: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebde000  ! 1124: STDA_I	stda	%r15, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 1125: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde8ce000  ! 1126: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	.word 0xdeaca000  ! 1127: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xd2d78e60  ! 1128: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r9
	.word 0xd6b4c400  ! 1129: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd8cf8e60  ! 1131: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r12
	.word 0xd4874e60  ! 1132: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r10
	.word 0xd6f4a000  ! 1133: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	.word 0xd6ac6000  ! 1134: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	mov	0x8, %r17
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6d42000  ! 1137: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r11
	.word 0xd6942000  ! 1138: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r11
	.word 0xd6cc6000  ! 1139: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r11
	mov	0x3f8, %r22
	.word 0xd6b584a0  ! 1141: STHA_R	stha	%r11, [%r22 + %r0] 0x25
	.word 0xdaaf8e80  ! 1142: STBA_R	stba	%r13, [%r30 + %r0] 0x74
	.word 0xde95c4a0  ! 1143: LDUHA_R	lduha	[%r23, %r0] 0x25, %r15
	.word 0xd4cca000  ! 1144: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r10
	.word 0xd2bc0400  ! 1145: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	mov	0x18, %r24
	.word 0x87802074  ! 1147: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e0, %r21
	.word 0xd6bda000  ! 1149: STDA_I	stda	%r11, [%r22 + 0x0000] %asi
	.word 0xd6dde000  ! 1150: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r11
	.word 0xd0978e80  ! 1151: LDUHA_R	lduha	[%r30, %r0] 0x74, %r8
	.word 0xdea70e60  ! 1152: STWA_R	stwa	%r15, [%r28 + %r0] 0x73
	.word 0xd0b5e000  ! 1153: STHA_I	stha	%r8, [%r23 + 0x0000] %asi
	.word 0xd0ada000  ! 1154: STBA_I	stba	%r8, [%r22 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x3e0, %r20
	.word 0xd4adc4a0  ! 1157: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0xd4a44400  ! 1158: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	mov	0x78, %r27
	mov	0x58, %r24
	.word 0xdadde000  ! 1161: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 1162: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd286c9e0  ! 1163: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r9
	.word 0x87802020  ! 1164: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf689e0  ! 1165: STXA_R	stxa	%r14, [%r26 + %r0] 0x4f
	.word 0xd084a000  ! 1166: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	ta	T_CHANGE_PRIV	! macro
	.word 0xdaaf4e80  ! 1168: STBA_R	stba	%r13, [%r29 + %r0] 0x74
	mov	0x48, %r17
	.word 0xd2bf4e80  ! 1170: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	mov	0x70, %r19
	.word 0xd4bca000  ! 1172: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 1173: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d7a000  ! 1174: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	mov	0x3d8, %r21
	.word 0xd0bf8e40  ! 1176: STDA_R	stda	%r8, [%r30 + %r0] 0x72
	mov	0x78, %r27
	mov	0x30, %r17
	.word 0xd89fa000  ! 1179: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	.word 0xd887e000  ! 1180: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8df6000  ! 1181: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0xd89fa000  ! 1182: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	mov	0x3d0, %r21
	.word 0x87802025  ! 1184: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d8, %r23
	.word 0xd8ce09e0  ! 1186: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r12
	.word 0x87802020  ! 1187: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r26
	.word 0xde8d44a0  ! 1189: LDUBA_R	lduba	[%r21, %r0] 0x25, %r15
	.word 0xd08649e0  ! 1190: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r8
	.word 0x87802074  ! 1191: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdebe49e0  ! 1192: STDA_R	stda	%r15, [%r25 + %r0] 0x4f
	.word 0xd897e000  ! 1193: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	mov	0x7d8, %r23
	mov	0x3e8, %r20
	.word 0xd8d649e0  ! 1196: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r12
	.word 0xd8b7a000  ! 1197: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	mov	0x48, %r19
	.word 0x8780204f  ! 1199: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8d46000  ! 1200: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	mov	0x7f0, %r23
	mov	0x30, %r25
	.word 0xd8d46000  ! 1203: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 1204: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8d76000  ! 1205: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0x87802074  ! 1206: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r16
	.word 0x87802073  ! 1208: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb44400  ! 1209: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0xd8ac6000  ! 1210: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 1211: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f504a0  ! 1212: STXA_R	stxa	%r11, [%r20 + %r0] 0x25
	.word 0xd2ac0400  ! 1213: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0xd4bf2000  ! 1214: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd4afe000  ! 1215: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xd4df2000  ! 1217: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0xd48f2000  ! 1218: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1219: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bfa000  ! 1220: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd4cf6000  ! 1221: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	mov	0x48, %r27
	.word 0xd4dcc400  ! 1223: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0xd0de89e0  ! 1224: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r8
	.word 0xdabf8e40  ! 1225: STDA_R	stda	%r13, [%r30 + %r0] 0x72
	mov	0x7f0, %r20
	.word 0xd2b7a000  ! 1227: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xde8c8400  ! 1228: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	mov	0x10, %r18
	mov	0x68, %r25
	.word 0xd4876000  ! 1231: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4af2000  ! 1232: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xdcaf8e40  ! 1233: STBA_R	stba	%r14, [%r30 + %r0] 0x72
	.word 0xdedfe000  ! 1234: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	mov	0x3d8, %r23
	mov	0x0, %r26
	.word 0xd29c0400  ! 1237: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	mov	0x7f8, %r20
	.word 0xdaf40400  ! 1239: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xd6acc400  ! 1240: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xd0dfa000  ! 1241: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0b74e80  ! 1243: STHA_R	stha	%r8, [%r29 + %r0] 0x74
	.word 0xdeb70e60  ! 1244: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	.word 0xd0f649e0  ! 1245: STXA_R	stxa	%r8, [%r25 + %r0] 0x4f
	.word 0xd4bfa000  ! 1246: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1247: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r27
	.word 0xd68f0e40  ! 1249: LDUBA_R	lduba	[%r28, %r0] 0x72, %r11
	mov	0x70, %r26
	.word 0xd8cc0400  ! 1251: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	mov	0x3c8, %r21
	.word 0xd496c9e0  ! 1253: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r10
	.word 0xdcf5e000  ! 1254: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0xdcd52000  ! 1255: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r14
	.word 0xd6a7ce40  ! 1256: STWA_R	stwa	%r11, [%r31 + %r0] 0x72
	.word 0x87802020  ! 1257: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bc2000  ! 1258: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	.word 0xd6c4c400  ! 1259: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r11
	.word 0xd4b4a000  ! 1260: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0xd4846000  ! 1261: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r10
	.word 0xde86c9e0  ! 1262: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r15
	.word 0xd4f40400  ! 1263: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	mov	0x7d8, %r20
	.word 0x87802073  ! 1265: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f48400  ! 1266: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	mov	0x3f0, %r21
	.word 0xd0df6000  ! 1268: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1269: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd096e000  ! 1270: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r8
	mov	0x7d8, %r20
	.word 0xd096a000  ! 1272: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r8
	.word 0xd0b6a000  ! 1273: STHA_I	stha	%r8, [%r26 + 0x0000] %asi
	.word 0x87802073  ! 1274: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2d44400  ! 1275: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r9
	.word 0xd2bd84a0  ! 1276: STDA_R	stda	%r9, [%r22 + %r0] 0x25
	mov	0x10, %r17
	mov	0x30, %r27
	.word 0x87802025  ! 1279: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 1280: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r26
	mov	0x7c8, %r23
	.word 0x87802073  ! 1283: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdad72000  ! 1284: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1285: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d649e0  ! 1286: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r12
	.word 0xdaf62000  ! 1287: STXA_I	stxa	%r13, [%r24 + 0x0000] %asi
	.word 0xd2bdc4a0  ! 1288: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	.word 0xd687ce80  ! 1289: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r11
	.word 0xd49c4400  ! 1290: LDDA_R	ldda	[%r17, %r0] 0x20, %r10
	.word 0xdab609e0  ! 1291: STHA_R	stha	%r13, [%r24 + %r0] 0x4f
	.word 0xd8f7ce80  ! 1292: STXA_R	stxa	%r12, [%r31 + %r0] 0x74
	mov	0x3f0, %r22
	mov	0x58, %r17
	.word 0xd2bec9e0  ! 1295: STDA_R	stda	%r9, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 1296: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r17
	.word 0xd49d04a0  ! 1298: LDDA_R	ldda	[%r20, %r0] 0x25, %r10
	.word 0xd2a42000  ! 1299: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	.word 0xdadf4e60  ! 1300: LDXA_R	ldxa	[%r29, %r0] 0x73, %r13
	.word 0x87802020  ! 1301: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r18
	.word 0xdcf544a0  ! 1303: STXA_R	stxa	%r14, [%r21 + %r0] 0x25
	mov	0x18, %r26
	.word 0xd6cc2000  ! 1305: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	.word 0xd6b42000  ! 1306: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	mov	0x10, %r26
	.word 0xdecd84a0  ! 1308: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r15
	mov	0x58, %r16
	.word 0xdab4e000  ! 1310: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xdacce000  ! 1311: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r13
	.word 0x87802073  ! 1312: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f8, %r22
	.word 0xdad4a000  ! 1314: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0xd0840400  ! 1315: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	.word 0x87802072  ! 1316: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd887e000  ! 1317: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0x87802074  ! 1318: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bfa000  ! 1319: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd6f584a0  ! 1320: STXA_R	stxa	%r11, [%r22 + %r0] 0x25
	.word 0xd0f7a000  ! 1321: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xdcbd04a0  ! 1322: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	.word 0xda9f2000  ! 1323: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xd8a74e40  ! 1324: STWA_R	stwa	%r12, [%r29 + %r0] 0x72
	.word 0xde972000  ! 1325: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	mov	0x7d8, %r20
	.word 0xd6c74e80  ! 1327: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r11
	.word 0xd0b5c4a0  ! 1328: STHA_R	stha	%r8, [%r23 + %r0] 0x25
	.word 0xd0df2000  ! 1329: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	mov	0x7e0, %r20
	.word 0xdcdc0400  ! 1331: LDXA_R	ldxa	[%r16, %r0] 0x20, %r14
	.word 0xd6c649e0  ! 1332: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r11
	mov	0x0, %r19
	.word 0x87802072  ! 1334: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 1335: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd28d44a0  ! 1336: LDUBA_R	lduba	[%r21, %r0] 0x25, %r9
	.word 0xd6f5a000  ! 1337: STXA_I	stxa	%r11, [%r22 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0xd6cda000  ! 1339: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r11
	mov	0x3d8, %r22
	.word 0xd48689e0  ! 1341: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r10
	.word 0xd8b5a000  ! 1342: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	.word 0xd8ad2000  ! 1343: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 1344: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 1345: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8cfa000  ! 1346: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	mov	0x7f0, %r21
	.word 0xd6f40400  ! 1348: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	.word 0xdcd6c9e0  ! 1349: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r14
	.word 0xdacf8e40  ! 1350: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r13
	mov	0x20, %r16
	mov	0x58, %r17
	.word 0xd8f7a000  ! 1353: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd4a584a0  ! 1354: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x7e0, %r21
	mov	0x48, %r16
	mov	0x8, %r25
	.word 0xd4df6000  ! 1359: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0x87802073  ! 1360: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r27
	mov	0x48, %r25
	.word 0xd48f6000  ! 1363: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd8b70e60  ! 1365: STHA_R	stha	%r12, [%r28 + %r0] 0x73
	.word 0xd29d84a0  ! 1366: LDDA_R	ldda	[%r22, %r0] 0x25, %r9
	.word 0xd6aec9e0  ! 1367: STBA_R	stba	%r11, [%r27 + %r0] 0x4f
	.word 0xdecf2000  ! 1368: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xde870e60  ! 1369: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r15
	mov	0x7f0, %r20
	.word 0xdabfe000  ! 1371: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	mov	0x60, %r25
	.word 0xda9f2000  ! 1373: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xdcd7ce40  ! 1374: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r14
	.word 0xd8b78e60  ! 1375: STHA_R	stha	%r12, [%r30 + %r0] 0x73
	.word 0x87802072  ! 1376: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0ce89e0  ! 1377: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r8
	mov	0x50, %r25
	mov	0x18, %r19
	.word 0x87802073  ! 1380: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb70e40  ! 1381: STHA_R	stha	%r14, [%r28 + %r0] 0x72
	.word 0xd68f0e40  ! 1382: LDUBA_R	lduba	[%r28, %r0] 0x72, %r11
	.word 0xd4cfce80  ! 1383: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r10
	.word 0xdecc4400  ! 1384: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r15
	.word 0x87802025  ! 1385: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1386: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1387: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4978e80  ! 1388: LDUHA_R	lduha	[%r30, %r0] 0x74, %r10
	.word 0x8780204f  ! 1389: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b544a0  ! 1390: STHA_R	stha	%r8, [%r21 + %r0] 0x25
	mov	0x8, %r24
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdaf42000  ! 1393: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0xdab4a000  ! 1394: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	mov	0x20, %r26
	.word 0xdab78e40  ! 1396: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	.word 0x87802025  ! 1397: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2cd04a0  ! 1398: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r9
	mov	0x0, %r26
	mov	0x20, %r17
	.word 0xd2870e40  ! 1401: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r9
	.word 0xdecf2000  ! 1402: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xded40400  ! 1403: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	.word 0x87802020  ! 1404: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdacfe000  ! 1405: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0xdab76000  ! 1406: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xd2aec9e0  ! 1407: STBA_R	stba	%r9, [%r27 + %r0] 0x4f
	mov	0x7c0, %r21
	.word 0x87802073  ! 1409: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd68fce80  ! 1410: LDUBA_R	lduba	[%r31, %r0] 0x74, %r11
	.word 0xdec78e60  ! 1411: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r15
	mov	0x30, %r26
	.word 0xdcc7ce80  ! 1413: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r14
	mov	0x8, %r19
	.word 0xda87a000  ! 1415: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0xdad7a000  ! 1416: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0xda87e000  ! 1417: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0xdabf6000  ! 1418: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xda9fe000  ! 1419: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xdab76000  ! 1420: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	mov	0x68, %r24
	.word 0xdad48400  ! 1422: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0xd8b72000  ! 1423: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	mov	0x78, %r16
	mov	0x0, %r26
	.word 0xd8976000  ! 1426: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0xd8dfe000  ! 1427: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8f76000  ! 1428: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	mov	0x28, %r19
	.word 0xd8d7a000  ! 1430: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0x87802025  ! 1431: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bce000  ! 1432: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 1433: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 1434: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd89de000  ! 1435: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r12
	.word 0xd0dc0400  ! 1436: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0x87802020  ! 1437: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8cf8e80  ! 1438: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r12
	.word 0xd2cf4e80  ! 1439: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r9
	.word 0xd0afa000  ! 1440: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd0d7a000  ! 1441: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1442: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd095a000  ! 1443: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r8
	.word 0xd0b48400  ! 1444: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xdea4c400  ! 1445: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	mov	0x48, %r19
	.word 0xd48d2000  ! 1447: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0xdacf8e60  ! 1448: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r13
	.word 0xd0dd2000  ! 1449: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0xdeaf0e40  ! 1450: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	mov	0x70, %r26
	.word 0xdaada000  ! 1452: STBA_I	stba	%r13, [%r22 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0xd6bf4e60  ! 1454: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd6952000  ! 1456: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r11
	.word 0xd6f5e000  ! 1457: STXA_I	stxa	%r11, [%r23 + 0x0000] %asi
	.word 0xd6a689e0  ! 1458: STWA_R	stwa	%r11, [%r26 + %r0] 0x4f
	.word 0xd0f70e60  ! 1459: STXA_R	stxa	%r8, [%r28 + %r0] 0x73
	.word 0xd4f48400  ! 1460: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 1461: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd29ea000  ! 1462: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r9
	.word 0xdcd7ce40  ! 1463: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r14
	mov	0x68, %r25
	.word 0xdcae6000  ! 1465: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	.word 0x87802074  ! 1466: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcaf6000  ! 1467: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xd6c649e0  ! 1468: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r11
	mov	0x3d0, %r22
	.word 0xdc8f4e40  ! 1470: LDUBA_R	lduba	[%r29, %r0] 0x72, %r14
	.word 0xdac7a000  ! 1471: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xd4d70e60  ! 1472: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r10
	mov	0x7e0, %r22
	.word 0x87802020  ! 1474: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f544a0  ! 1475: STXA_R	stxa	%r11, [%r21 + %r0] 0x25
	mov	0x40, %r25
	mov	0x3e8, %r21
	.word 0x87802020  ! 1478: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1479: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd88f6000  ! 1480: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xd8f7a000  ! 1481: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xdc9f8e60  ! 1482: LDDA_R	ldda	[%r30, %r0] 0x73, %r14
	.word 0xd09f2000  ! 1483: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0xd0df2000  ! 1484: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	mov	0x10, %r26
	.word 0xd0cf2000  ! 1486: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0xd8b7ce40  ! 1487: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0xd8f7a000  ! 1488: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd4f78e80  ! 1489: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	.word 0xd4944400  ! 1490: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	.word 0x87802025  ! 1491: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b74e80  ! 1492: STHA_R	stha	%r9, [%r29 + %r0] 0x74
	.word 0x87802072  ! 1493: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r27
	.word 0xd0de49e0  ! 1495: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r8
	.word 0xd2d7ce40  ! 1496: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r9
	.word 0xdc9e6000  ! 1497: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r14
	.word 0xd2b48400  ! 1498: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd0966000  ! 1499: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r8
	.word 0xdacc0400  ! 1500: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r13
	mov	0x10, %r17
	.word 0xdaa66000  ! 1502: STWA_I	stwa	%r13, [%r25 + 0x0000] %asi
	.word 0xdaa6e000  ! 1503: STWA_I	stwa	%r13, [%r27 + 0x0000] %asi
	.word 0xdaf6a000  ! 1504: STXA_I	stxa	%r13, [%r26 + 0x0000] %asi
	.word 0xd29d84a0  ! 1505: LDDA_R	ldda	[%r22, %r0] 0x25, %r9
	.word 0xdcb74e40  ! 1506: STHA_R	stha	%r14, [%r29 + %r0] 0x72
	.word 0xd0be6000  ! 1507: STDA_I	stda	%r8, [%r25 + 0x0000] %asi
	.word 0x87802025  ! 1508: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0cfe000  ! 1509: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	mov	0x50, %r16
	.word 0xdebf4e40  ! 1511: STDA_R	stda	%r15, [%r29 + %r0] 0x72
	.word 0xd2d72000  ! 1512: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xd4af8e60  ! 1513: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	.word 0xdc8f2000  ! 1514: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0xdc872000  ! 1515: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcafa000  ! 1516: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xdc972000  ! 1517: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	mov	0x3c8, %r21
	.word 0xdcc7a000  ! 1519: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcbf2000  ! 1520: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 1521: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbca000  ! 1522: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 1523: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r27
	.word 0xdc9fa000  ! 1525: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0xdea48400  ! 1526: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xdcdf2000  ! 1527: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcd7ce40  ! 1528: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r14
	.word 0xd8b7a000  ! 1529: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1530: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r27
	.word 0xd8b5e000  ! 1532: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	.word 0xd88d6000  ! 1533: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r12
	.word 0xd885e000  ! 1534: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r12
	.word 0xd885a000  ! 1535: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r12
	.word 0xd8b5e000  ! 1536: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	.word 0xd8f5a000  ! 1537: STXA_I	stxa	%r12, [%r22 + 0x0000] %asi
	.word 0xd8dd2000  ! 1538: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r12
	mov	0x8, %r18
	.word 0xdaa78e40  ! 1540: STWA_R	stwa	%r13, [%r30 + %r0] 0x72
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x38, %r26
	.word 0xd2978e60  ! 1543: LDUHA_R	lduha	[%r30, %r0] 0x73, %r9
	.word 0xd08f8e40  ! 1544: LDUBA_R	lduba	[%r30, %r0] 0x72, %r8
	.word 0xd297ce40  ! 1545: LDUHA_R	lduha	[%r31, %r0] 0x72, %r9
	.word 0xd8c74e40  ! 1546: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r12
	.word 0xd09d2000  ! 1547: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r8
	mov	0x30, %r27
	.word 0xd0952000  ! 1549: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r8
	.word 0xd0bda000  ! 1550: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	.word 0xd0c5e000  ! 1551: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 1552: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f8, %r22
	mov	0x3f8, %r20
	.word 0xd0ace000  ! 1555: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0xd6cc8400  ! 1556: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	.word 0xd6bc6000  ! 1557: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	mov	0x3c8, %r20
	.word 0xdc84c400  ! 1559: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	mov	0x3d0, %r20
	.word 0xdedfce60  ! 1561: LDXA_R	ldxa	[%r31, %r0] 0x73, %r15
	.word 0xd08cc400  ! 1562: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	.word 0xdaa70e40  ! 1563: STWA_R	stwa	%r13, [%r28 + %r0] 0x72
	.word 0xd6bca000  ! 1564: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	.word 0xd0a40400  ! 1565: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0xdab7ce80  ! 1566: STHA_R	stha	%r13, [%r31 + %r0] 0x74
	.word 0xd4dce000  ! 1567: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	.word 0xd6a584a0  ! 1568: STWA_R	stwa	%r11, [%r22 + %r0] 0x25
	.word 0x87802020  ! 1569: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcaec9e0  ! 1570: STBA_R	stba	%r14, [%r27 + %r0] 0x4f
	.word 0xd2d48400  ! 1571: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	.word 0xdc976000  ! 1572: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	.word 0xdcf7a000  ! 1573: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0xdccfa000  ! 1575: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xd89e89e0  ! 1576: LDDA_R	ldda	[%r26, %r0] 0x4f, %r12
	.word 0xd0c7a000  ! 1577: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0872000  ! 1578: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	mov	0x7c0, %r21
	mov	0x70, %r24
	.word 0x87802074  ! 1581: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6ce49e0  ! 1582: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r11
	.word 0xd2f78e60  ! 1583: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0x8780204f  ! 1584: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdef4c400  ! 1585: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0x87802020  ! 1586: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c66000  ! 1587: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r9
	.word 0xdcf4c400  ! 1588: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xdc970e40  ! 1589: LDUHA_R	lduha	[%r28, %r0] 0x72, %r14
	.word 0x87802074  ! 1590: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 1591: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f0, %r23
	.word 0xdede09e0  ! 1593: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r15
	.word 0xd6c62000  ! 1594: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r11
	.word 0xd6b74e60  ! 1595: STHA_R	stha	%r11, [%r29 + %r0] 0x73
	.word 0xd2a78e60  ! 1596: STWA_R	stwa	%r9, [%r30 + %r0] 0x73
	.word 0xdcf70e80  ! 1597: STXA_R	stxa	%r14, [%r28 + %r0] 0x74
	.word 0xd0940400  ! 1598: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	.word 0xd6bf0e60  ! 1599: STDA_R	stda	%r11, [%r28 + %r0] 0x73
	.word 0xde862000  ! 1600: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r15
	.word 0xd2a74e40  ! 1601: STWA_R	stwa	%r9, [%r29 + %r0] 0x72
	.word 0xdcafce80  ! 1602: STBA_R	stba	%r14, [%r31 + %r0] 0x74
	.word 0xd4d62000  ! 1603: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r10
	.word 0xd4a62000  ! 1604: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	mov	0x38, %r25
	.word 0xd48ee000  ! 1606: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r10
	mov	0x8, %r18
	.word 0x87802073  ! 1608: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd48fe000  ! 1609: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0x87802074  ! 1610: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd494a000  ! 1611: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r10
	.word 0xd4b4e000  ! 1612: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	mov	0x18, %r25
	.word 0xd4f4e000  ! 1614: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 1615: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcdcc400  ! 1616: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	mov	0x3d0, %r20
	.word 0xd2ad44a0  ! 1618: STBA_R	stba	%r9, [%r21 + %r0] 0x25
	.word 0xdcb40400  ! 1619: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0x87802020  ! 1620: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc976000  ! 1621: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	mov	0x78, %r24
	mov	0x3e8, %r20
	.word 0xd6bf0e60  ! 1624: STDA_R	stda	%r11, [%r28 + %r0] 0x73
	mov	0x30, %r24
	.word 0xd8c72000  ! 1626: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	mov	0x68, %r19
	.word 0xd887e000  ! 1628: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0x87802074  ! 1629: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8afa000  ! 1630: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8dfa000  ! 1632: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8bfe000  ! 1633: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd8afe000  ! 1634: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xdeaf8e60  ! 1635: STBA_R	stba	%r15, [%r30 + %r0] 0x73
	.word 0xd8a4c400  ! 1636: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xdea7e000  ! 1637: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xd4f7ce80  ! 1638: STXA_R	stxa	%r10, [%r31 + %r0] 0x74
	.word 0xdacfe000  ! 1639: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0xd6a7ce60  ! 1640: STWA_R	stwa	%r11, [%r31 + %r0] 0x73
	.word 0x87802020  ! 1641: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r20
	.word 0x87802025  ! 1643: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4f6e000  ! 1644: STXA_I	stxa	%r10, [%r27 + 0x0000] %asi
	.word 0xd4f6a000  ! 1645: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	.word 0xd2afce60  ! 1646: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	mov	0x7d8, %r21
	.word 0xd0f74e60  ! 1648: STXA_R	stxa	%r8, [%r29 + %r0] 0x73
	.word 0xd48ee000  ! 1649: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r10
	.word 0xd48e6000  ! 1650: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1651: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd494e000  ! 1652: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	.word 0xdadd04a0  ! 1653: LDXA_R	ldxa	[%r20, %r0] 0x25, %r13
	.word 0xd0f4e000  ! 1654: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	mov	0x10, %r17
	.word 0xd8940400  ! 1656: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	.word 0xd8acc400  ! 1657: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0x87802074  ! 1658: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde8fa000  ! 1659: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0x87802072  ! 1660: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 1661: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde8f2000  ! 1662: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xdea78e60  ! 1663: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	mov	0x18, %r25
	.word 0xd8872000  ! 1665: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	.word 0xd4b48400  ! 1666: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	mov	0x58, %r26
	.word 0xd0df2000  ! 1668: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0xdaf7ce80  ! 1669: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	.word 0xda9c4400  ! 1670: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	mov	0x8, %r18
	mov	0x68, %r19
	.word 0x8780204f  ! 1673: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdecec9e0  ! 1674: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r15
	mov	0x58, %r25
	mov	0x3e8, %r22
	.word 0xd0a649e0  ! 1677: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	.word 0x87802073  ! 1678: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 1679: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8af0e80  ! 1680: STBA_R	stba	%r12, [%r28 + %r0] 0x74
	.word 0x87802073  ! 1681: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4bd84a0  ! 1682: STDA_R	stda	%r10, [%r22 + %r0] 0x25
	.word 0xd0bca000  ! 1683: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 1684: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a5a000  ! 1685: STWA_I	stwa	%r8, [%r22 + 0x0000] %asi
	.word 0xd0f5a000  ! 1686: STXA_I	stxa	%r8, [%r22 + 0x0000] %asi
	.word 0x8780204f  ! 1687: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0c4e000  ! 1688: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	.word 0xd6b48400  ! 1689: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0x87802020  ! 1690: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9fe000  ! 1691: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xd8af4e40  ! 1692: STBA_R	stba	%r12, [%r29 + %r0] 0x72
	mov	0x20, %r25
	.word 0xdca72000  ! 1694: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcb70e60  ! 1695: STHA_R	stha	%r14, [%r28 + %r0] 0x73
	mov	0x70, %r26
	.word 0xda844400  ! 1697: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r13
	mov	0x60, %r16
	.word 0xde9fce80  ! 1699: LDDA_R	ldda	[%r31, %r0] 0x74, %r15
	.word 0xd2af2000  ! 1700: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2cf8e40  ! 1702: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r9
	.word 0xd2d76000  ! 1703: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0x87802072  ! 1704: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8be09e0  ! 1705: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	.word 0xd2afe000  ! 1706: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	mov	0x68, %r24
	.word 0xd2a76000  ! 1708: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 1709: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 1710: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2dde000  ! 1711: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 1712: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0874e60  ! 1713: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r8
	.word 0xd6b6a000  ! 1714: STHA_I	stha	%r11, [%r26 + 0x0000] %asi
	mov	0x28, %r17
	.word 0xd6962000  ! 1716: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r11
	.word 0xd6bec9e0  ! 1717: STDA_R	stda	%r11, [%r27 + %r0] 0x4f
	.word 0xd6de2000  ! 1718: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r11
	.word 0xdecdc4a0  ! 1719: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r15
	.word 0x87802072  ! 1720: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd896c9e0  ! 1721: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r12
	.word 0xd2ae6000  ! 1722: STBA_I	stba	%r9, [%r25 + 0x0000] %asi
	.word 0xd4f7ce40  ! 1723: STXA_R	stxa	%r10, [%r31 + %r0] 0x72
	mov	0x58, %r26
	.word 0xd0af0e80  ! 1725: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	.word 0xdcf6c9e0  ! 1726: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	.word 0x8780204f  ! 1727: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bfe000  ! 1728: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x60, %r17
	mov	0x7d8, %r23
	.word 0xd4a7a000  ! 1731: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xdec44400  ! 1732: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0x8780204f  ! 1733: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbd04a0  ! 1734: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	.word 0xd08ce000  ! 1735: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xdaa7ce60  ! 1736: STWA_R	stwa	%r13, [%r31 + %r0] 0x73
	mov	0x68, %r17
	.word 0xd8b48400  ! 1738: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	mov	0x40, %r25
	.word 0xda9c6000  ! 1740: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	mov	0x38, %r19
	.word 0xdca609e0  ! 1742: STWA_R	stwa	%r14, [%r24 + %r0] 0x4f
	.word 0xd4b4e000  ! 1743: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xd4dc2000  ! 1744: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	mov	0x3c0, %r21
	mov	0x68, %r27
	.word 0xdec40400  ! 1747: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xde9fce40  ! 1748: LDDA_R	ldda	[%r31, %r0] 0x72, %r15
	.word 0x87802020  ! 1749: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49f4e80  ! 1750: LDDA_R	ldda	[%r29, %r0] 0x74, %r10
	.word 0xd6af0e60  ! 1751: STBA_R	stba	%r11, [%r28 + %r0] 0x73
	.word 0xdcf4a000  ! 1752: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	mov	0x7c8, %r23
	.word 0xdcbca000  ! 1754: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 1755: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdea000  ! 1756: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r14
	.word 0xdcbe6000  ! 1757: STDA_I	stda	%r14, [%r25 + 0x0000] %asi
	.word 0x87802074  ! 1758: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b6c9e0  ! 1759: STHA_R	stha	%r9, [%r27 + %r0] 0x4f
	mov	0x30, %r18
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd4afce40  ! 1762: STBA_R	stba	%r10, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 1763: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a42000  ! 1764: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	mov	0x7f8, %r20
	.word 0x87802073  ! 1766: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0afa000  ! 1767: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd0dfa000  ! 1768: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0bfe000  ! 1769: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	mov	0x10, %r24
	mov	0x68, %r27
	mov	0x3e8, %r21
	.word 0xd69c0400  ! 1773: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	mov	0x28, %r16
	mov	0x40, %r24
	.word 0xd2cfe000  ! 1776: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1777: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r22
	.word 0x87802073  ! 1779: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r19
	.word 0xd6a7ce60  ! 1781: STWA_R	stwa	%r11, [%r31 + %r0] 0x73
	.word 0x87802073  ! 1782: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r18
	.word 0x87802025  ! 1784: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c8, %r23
	.word 0xdaf6c9e0  ! 1786: STXA_R	stxa	%r13, [%r27 + %r0] 0x4f
	.word 0xd2c7a000  ! 1787: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2a76000  ! 1788: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xdcbf4e40  ! 1789: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	mov	0x3f8, %r23
	.word 0x8780204f  ! 1791: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd284a000  ! 1792: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	.word 0xd2b42000  ! 1793: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0xd2a48400  ! 1794: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	mov	0x28, %r27
	.word 0xd8aca000  ! 1796: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0xd8946000  ! 1797: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	.word 0xd8a46000  ! 1798: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8a42000  ! 1799: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	mov	0x38, %r17
	mov	0x3c0, %r21
	.word 0xd0cf4e60  ! 1802: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r8
	.word 0xd4f42000  ! 1803: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	mov	0x38, %r16
	mov	0x7e0, %r20
	.word 0xdedc0400  ! 1806: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	.word 0xd4ace000  ! 1807: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	mov	0x20, %r17
	mov	0x0, %r17
	mov	0x58, %r17
	mov	0x38, %r26
	.word 0xd4bca000  ! 1812: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0xdeb7ce40  ! 1813: STHA_R	stha	%r15, [%r31 + %r0] 0x72
	.word 0xd6dcc400  ! 1814: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	.word 0x87802020  ! 1815: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r27
	.word 0xd8f649e0  ! 1817: STXA_R	stxa	%r12, [%r25 + %r0] 0x4f
	.word 0x87802072  ! 1818: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcaf6000  ! 1819: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 1820: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f8, %r23
	.word 0x87802020  ! 1822: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9649e0  ! 1823: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r13
	.word 0x87802073  ! 1824: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8dc8400  ! 1825: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xd4df2000  ! 1826: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4afa000  ! 1827: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd0ad04a0  ! 1828: STBA_R	stba	%r8, [%r20 + %r0] 0x25
	.word 0xd6dfe000  ! 1829: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	mov	0x7f8, %r20
	.word 0xd6afa000  ! 1831: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x20, %r27
	.word 0xdccdc4a0  ! 1833: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r14
	.word 0xdcf70e60  ! 1834: STXA_R	stxa	%r14, [%r28 + %r0] 0x73
	.word 0xdacfa000  ! 1835: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xdaaf2000  ! 1836: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xded584a0  ! 1837: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r15
	.word 0xd4af6000  ! 1838: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xdc8e89e0  ! 1839: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r14
	.word 0xd8cf4e80  ! 1840: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r12
	.word 0x87802020  ! 1841: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcde2000  ! 1842: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r14
	mov	0x18, %r25
	.word 0x87802020  ! 1844: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r26
	.word 0xdcc6e000  ! 1846: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r14
	.word 0x87802074  ! 1847: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdac44400  ! 1848: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r13
	.word 0xd6d70e40  ! 1849: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r11
	.word 0x87802074  ! 1850: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdec44400  ! 1851: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0xdebfce80  ! 1852: STDA_R	stda	%r15, [%r31 + %r0] 0x74
	.word 0xd6de49e0  ! 1853: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r11
	.word 0x87802074  ! 1854: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1855: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf6c9e0  ! 1856: STXA_R	stxa	%r13, [%r27 + %r0] 0x4f
	.word 0xd4a44400  ! 1857: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xd8c504a0  ! 1858: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r12
	.word 0x87802072  ! 1859: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 1860: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 1861: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r25
	.word 0xd0c46000  ! 1863: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r8
	.word 0x87802073  ! 1864: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0afa000  ! 1865: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 1866: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f70e60  ! 1867: STXA_R	stxa	%r9, [%r28 + %r0] 0x73
	.word 0xd2a70e80  ! 1868: STWA_R	stwa	%r9, [%r28 + %r0] 0x74
	.word 0x87802072  ! 1869: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b4c400  ! 1870: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xdede2000  ! 1871: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r15
	mov	0x40, %r17
	.word 0xd0a78e60  ! 1873: STWA_R	stwa	%r8, [%r30 + %r0] 0x73
	.word 0xdaa70e60  ! 1874: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	.word 0x87802073  ! 1875: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb72000  ! 1876: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	mov	0x40, %r27
	.word 0xd4cc0400  ! 1878: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r10
	.word 0xd8af2000  ! 1879: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	mov	0x0, %r24
	.word 0xd887a000  ! 1881: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1882: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49649e0  ! 1883: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r10
	.word 0xd2f504a0  ! 1884: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	.word 0xdcbf2000  ! 1885: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	mov	0x38, %r18
	.word 0xdcb7a000  ! 1887: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 1888: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6844400  ! 1889: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r11
	mov	0x7e8, %r21
	mov	0x58, %r18
	.word 0x87802025  ! 1892: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2a74e60  ! 1893: STWA_R	stwa	%r9, [%r29 + %r0] 0x73
	.word 0xdab584a0  ! 1894: STHA_R	stha	%r13, [%r22 + %r0] 0x25
	mov	0x8, %r18
	.word 0xdac7a000  ! 1896: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0x87802025  ! 1897: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0df8e40  ! 1898: LDXA_R	ldxa	[%r30, %r0] 0x72, %r8
	.word 0xd484e000  ! 1899: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r10
	.word 0x87802025  ! 1900: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 1901: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c0, %r22
	.word 0xd4bea000  ! 1903: STDA_I	stda	%r10, [%r26 + 0x0000] %asi
	mov	0x20, %r24
	.word 0xde8fce60  ! 1905: LDUBA_R	lduba	[%r31, %r0] 0x73, %r15
	.word 0xdca6a000  ! 1906: STWA_I	stwa	%r14, [%r26 + 0x0000] %asi
	.word 0xdc86e000  ! 1907: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r14
	.word 0x87802072  ! 1908: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd69609e0  ! 1909: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r11
	.word 0x87802020  ! 1910: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f74e60  ! 1911: STXA_R	stxa	%r9, [%r29 + %r0] 0x73
	mov	0x7d8, %r20
	.word 0xdcd74e40  ! 1913: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r14
	mov	0x28, %r16
	.word 0xdab66000  ! 1915: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0xdab6a000  ! 1916: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	.word 0x87802072  ! 1917: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef504a0  ! 1918: STXA_R	stxa	%r15, [%r20 + %r0] 0x25
	mov	0x7d8, %r22
	.word 0xd0d76000  ! 1920: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	mov	0x38, %r19
	.word 0x87802074  ! 1922: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f48400  ! 1923: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0x87802020  ! 1924: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8ee000  ! 1925: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r13
	.word 0xd88c4400  ! 1926: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0xd49e2000  ! 1927: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r10
	.word 0xdc9c8400  ! 1928: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0xdcde2000  ! 1929: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r14
	mov	0x60, %r16
	.word 0x87802072  ! 1931: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab584a0  ! 1932: STHA_R	stha	%r13, [%r22 + %r0] 0x25
	.word 0xd69cc400  ! 1933: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	mov	0x10, %r17
	.word 0xd68dc4a0  ! 1935: LDUBA_R	lduba	[%r23, %r0] 0x25, %r11
	.word 0xded46000  ! 1936: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	.word 0xda9f4e40  ! 1937: LDDA_R	ldda	[%r29, %r0] 0x72, %r13
	.word 0x87802025  ! 1938: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 1939: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1940: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccca000  ! 1941: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	.word 0xdcf4e000  ! 1942: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcbca000  ! 1943: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdaafce80  ! 1944: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	mov	0x58, %r27
	.word 0xdcc4c400  ! 1946: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	.word 0xdabf8e80  ! 1947: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	.word 0x87802074  ! 1948: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda9f4e60  ! 1949: LDDA_R	ldda	[%r29, %r0] 0x73, %r13
	.word 0xd08fa000  ! 1950: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0xd0f7a000  ! 1951: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0a72000  ! 1952: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xda9cc400  ! 1953: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	.word 0xd8c7e000  ! 1954: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	mov	0x68, %r19
	.word 0xd8b76000  ! 1956: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd4b78e60  ! 1957: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	mov	0x48, %r17
	.word 0xdca7a000  ! 1959: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdc872000  ! 1960: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	mov	0x70, %r24
	mov	0x0, %r18
	.word 0xdcaf6000  ! 1963: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xd0c40400  ! 1964: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	.word 0xd6f78e40  ! 1965: STXA_R	stxa	%r11, [%r30 + %r0] 0x72
	.word 0xd2dfa000  ! 1966: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xd8c544a0  ! 1967: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r12
	.word 0xd4a70e80  ! 1968: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	.word 0xda9fa000  ! 1969: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xdaa7e000  ! 1970: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xd8978e80  ! 1971: LDUHA_R	lduha	[%r30, %r0] 0x74, %r12
	.word 0x87802073  ! 1972: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r18
	.word 0xd0970e80  ! 1974: LDUHA_R	lduha	[%r28, %r0] 0x74, %r8
	.word 0xd4bf4e80  ! 1975: STDA_R	stda	%r10, [%r29 + %r0] 0x74
	.word 0xd287ce80  ! 1976: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r9
	mov	0x10, %r27
	.word 0xd8b70e40  ! 1978: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0xded7ce40  ! 1979: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r15
	.word 0xdcd4e000  ! 1980: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	.word 0xd0acc400  ! 1981: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	mov	0x60, %r24
	.word 0xd2c4e000  ! 1983: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	mov	0x78, %r16
	.word 0xdcb78e40  ! 1985: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	mov	0x48, %r19
	.word 0xd8bc2000  ! 1987: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd8af4e40  ! 1988: STBA_R	stba	%r12, [%r29 + %r0] 0x72
	.word 0x87802074  ! 1989: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc842000  ! 1990: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	mov	0x3f0, %r20
	.word 0xdccca000  ! 1992: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	.word 0xdc97ce80  ! 1993: LDUHA_R	lduha	[%r31, %r0] 0x74, %r14
	.word 0xdad46000  ! 1994: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1995: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r21
	.word 0xd09d04a0  ! 1997: LDDA_R	ldda	[%r20, %r0] 0x25, %r8
	.word 0xd4bc2000  ! 1998: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0xded6c9e0  ! 1999: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r15
	.word 0x87802020  ! 2000: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r21
	.word 0xd88f6000  ! 2002: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xd8a76000  ! 2003: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8cfe000  ! 2004: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8af2000  ! 2005: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xd8bc0400  ! 2006: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xdebd84a0  ! 2007: STDA_R	stda	%r15, [%r22 + %r0] 0x25
	.word 0xda876000  ! 2008: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0x87802073  ! 2009: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0ac4400  ! 2010: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	mov	0x78, %r17
	.word 0xdcbec9e0  ! 2012: STDA_R	stda	%r14, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 2013: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28d84a0  ! 2014: LDUBA_R	lduba	[%r22, %r0] 0x25, %r9
	mov	0x7d0, %r23
	.word 0xde9d6000  ! 2016: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r15
	.word 0xd8ad44a0  ! 2017: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	.word 0xdcd5a000  ! 2018: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r14
	.word 0xd6c78e80  ! 2019: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r11
	.word 0x87802020  ! 2020: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ac4400  ! 2021: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xdcd40400  ! 2022: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	mov	0x7c0, %r22
	.word 0xdca70e60  ! 2024: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	.word 0xdca46000  ! 2025: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 2026: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca4a000  ! 2027: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0xd0b609e0  ! 2028: STHA_R	stha	%r8, [%r24 + %r0] 0x4f
	.word 0xd8f46000  ! 2029: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xd2a70e80  ! 2030: STWA_R	stwa	%r9, [%r28 + %r0] 0x74
	.word 0x8780204f  ! 2031: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r17
	.word 0x87802072  ! 2033: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b48400  ! 2034: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd29ce000  ! 2035: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xd0c7ce60  ! 2036: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r8
	.word 0xda8c2000  ! 2037: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r13
	.word 0xdaf42000  ! 2038: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0xdc9544a0  ! 2039: LDUHA_R	lduha	[%r21, %r0] 0x25, %r14
	.word 0xdac4a000  ! 2040: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	.word 0x87802074  ! 2041: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2042: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabde000  ! 2043: STDA_I	stda	%r13, [%r23 + 0x0000] %asi
	.word 0xda85e000  ! 2044: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	.word 0xda952000  ! 2045: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 2046: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa6a000  ! 2047: STWA_I	stwa	%r13, [%r26 + 0x0000] %asi
	.word 0xd0bc8400  ! 2048: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0xd89ee000  ! 2049: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r12
	.word 0xd8ce2000  ! 2050: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r12
	.word 0xd8f6e000  ! 2051: STXA_I	stxa	%r12, [%r27 + 0x0000] %asi
	.word 0xd8b66000  ! 2052: STHA_I	stha	%r12, [%r25 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0x87802020  ! 2054: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r24
	mov	0x3e8, %r23
	.word 0xdec70e60  ! 2057: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r15
	mov	0x70, %r24
	.word 0xd0970e80  ! 2059: LDUHA_R	lduha	[%r28, %r0] 0x74, %r8
	mov	0x60, %r27
	mov	0x0, %r25
	mov	0x50, %r18
	.word 0xdab76000  ! 2063: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	mov	0x7f8, %r20
	mov	0x3d8, %r21
	.word 0x87802025  ! 2066: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d8, %r22
	.word 0xd69f4e60  ! 2068: LDDA_R	ldda	[%r29, %r0] 0x73, %r11
	.word 0xd2b609e0  ! 2069: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	.word 0x87802072  ! 2070: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b7e000  ! 2071: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	mov	0x20, %r26
	.word 0xd0af2000  ! 2073: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0cfe000  ! 2074: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	mov	0x28, %r27
	.word 0xd28c0400  ! 2076: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	.word 0xd6b76000  ! 2077: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd6afe000  ! 2078: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd6a72000  ! 2079: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xd6c76000  ! 2081: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0x87802072  ! 2082: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b5e000  ! 2083: STHA_I	stha	%r11, [%r23 + 0x0000] %asi
	.word 0xd6af0e40  ! 2084: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	.word 0xdea5e000  ! 2085: STWA_I	stwa	%r15, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 2086: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r18
	.word 0xded66000  ! 2088: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r15
	.word 0xd0a48400  ! 2089: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0xd4a44400  ! 2090: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	mov	0x8, %r18
	.word 0xd0f6e000  ! 2092: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	.word 0x87802073  ! 2093: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b4e000  ! 2094: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xdedc4400  ! 2095: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	.word 0x87802020  ! 2096: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r17
	.word 0xdca72000  ! 2098: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcf72000  ! 2099: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdc9f6000  ! 2100: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xda944400  ! 2101: LDUHA_R	lduha	[%r17, %r0] 0x20, %r13
	.word 0xd2cd44a0  ! 2102: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r9
	.word 0xd2b5c4a0  ! 2103: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	mov	0x30, %r18
	mov	0x68, %r17
	.word 0x8780204f  ! 2106: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f689e0  ! 2107: STXA_R	stxa	%r9, [%r26 + %r0] 0x4f
	.word 0x87802072  ! 2108: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29f6000  ! 2109: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2110: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r22
	.word 0x87802020  ! 2112: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd297a000  ! 2113: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	.word 0xd894c400  ! 2114: LDUHA_R	lduha	[%r19, %r0] 0x20, %r12
	.word 0xdac74e60  ! 2115: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r13
	.word 0xd2d72000  ! 2116: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0x87802072  ! 2117: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2be6000  ! 2118: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	.word 0xd286e000  ! 2119: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r9
	.word 0xd2a70e80  ! 2120: STWA_R	stwa	%r9, [%r28 + %r0] 0x74
	.word 0xd8ae2000  ! 2121: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	.word 0xdab40400  ! 2122: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xd4d62000  ! 2123: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r10
	mov	0x7e0, %r20
	.word 0xd2a40400  ! 2125: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xd8f62000  ! 2126: STXA_I	stxa	%r12, [%r24 + 0x0000] %asi
	.word 0xd6a74e80  ! 2127: STWA_R	stwa	%r11, [%r29 + %r0] 0x74
	.word 0x87802074  ! 2128: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4c7e000  ! 2129: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	mov	0x7d8, %r22
	.word 0xd4cfe000  ! 2131: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	mov	0x7f8, %r21
	mov	0x7e8, %r22
	.word 0x87802020  ! 2134: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r16
	.word 0xd4adc4a0  ! 2136: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0xdc9d2000  ! 2137: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r14
	.word 0xdc874e80  ! 2138: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r14
	.word 0xd6d56000  ! 2139: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r11
	mov	0x10, %r17
	mov	0x20, %r26
	mov	0x0, %r19
	.word 0xdea44400  ! 2143: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	mov	0x70, %r17
	mov	0x0, %r24
	.word 0xdab74e60  ! 2146: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	.word 0xdac7ce80  ! 2147: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r13
	mov	0x10, %r25
	.word 0xd4978e80  ! 2149: LDUHA_R	lduha	[%r30, %r0] 0x74, %r10
	.word 0xd0f52000  ! 2150: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	.word 0xd0b609e0  ! 2151: STHA_R	stha	%r8, [%r24 + %r0] 0x4f
	mov	0x7c8, %r20
	mov	0x3c0, %r20
	.word 0x87802073  ! 2154: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r16
	.word 0xdaf62000  ! 2156: STXA_I	stxa	%r13, [%r24 + 0x0000] %asi
	.word 0xd89689e0  ! 2157: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r12
	.word 0xdcadc4a0  ! 2158: STBA_R	stba	%r14, [%r23 + %r0] 0x25
	.word 0xdeae6000  ! 2159: STBA_I	stba	%r15, [%r25 + 0x0000] %asi
	mov	0x78, %r26
	.word 0xde8e6000  ! 2161: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r15
	mov	0x3c8, %r22
	.word 0xdeb66000  ! 2163: STHA_I	stha	%r15, [%r25 + 0x0000] %asi
	.word 0xda87ce80  ! 2164: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r13
	.word 0xd697ce80  ! 2165: LDUHA_R	lduha	[%r31, %r0] 0x74, %r11
	mov	0x20, %r27
	.word 0xdcdee000  ! 2167: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r14
	.word 0xdcbe6000  ! 2168: STDA_I	stda	%r14, [%r25 + 0x0000] %asi
	.word 0xdcaee000  ! 2169: STBA_I	stba	%r14, [%r27 + 0x0000] %asi
	mov	0x7d8, %r22
	mov	0x78, %r18
	.word 0xdcb6a000  ! 2172: STHA_I	stha	%r14, [%r26 + 0x0000] %asi
	mov	0x38, %r26
	.word 0xdcb66000  ! 2174: STHA_I	stha	%r14, [%r25 + 0x0000] %asi
	.word 0xd28dc4a0  ! 2175: LDUBA_R	lduba	[%r23, %r0] 0x25, %r9
	.word 0xde9649e0  ! 2176: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r15
	.word 0xd296e000  ! 2177: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r9
	.word 0xdca70e40  ! 2178: STWA_R	stwa	%r14, [%r28 + %r0] 0x72
	mov	0x8, %r25
	.word 0xdc9dc4a0  ! 2180: LDDA_R	ldda	[%r23, %r0] 0x25, %r14
	.word 0x87802020  ! 2181: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca7ce80  ! 2182: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	mov	0x38, %r19
	.word 0xd4c72000  ! 2184: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r10
	.word 0x87802020  ! 2185: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbe89e0  ! 2186: STDA_R	stda	%r14, [%r26 + %r0] 0x4f
	.word 0xd8a48400  ! 2187: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	.word 0xdca6a000  ! 2188: STWA_I	stwa	%r14, [%r26 + 0x0000] %asi
	mov	0x10, %r17
	.word 0xdcae6000  ! 2190: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	.word 0xdca6a000  ! 2191: STWA_I	stwa	%r14, [%r26 + 0x0000] %asi
	.word 0xdcbee000  ! 2192: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	.word 0xdc9ea000  ! 2193: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r14
	mov	0x7e0, %r22
	mov	0x60, %r18
	mov	0x60, %r24
	.word 0xdc9dc4a0  ! 2197: LDDA_R	ldda	[%r23, %r0] 0x25, %r14
	mov	0x7e0, %r20
	mov	0x68, %r27
	mov	0x7e0, %r23
	.word 0xd8bfce60  ! 2201: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	.word 0xde8fce60  ! 2202: LDUBA_R	lduba	[%r31, %r0] 0x73, %r15
	.word 0x87802073  ! 2203: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdccf0e40  ! 2204: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r14
	.word 0xde876000  ! 2205: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xd0c78e40  ! 2206: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r8
	.word 0x87802020  ! 2207: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a48400  ! 2208: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xd8972000  ! 2209: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2210: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r22
	.word 0xd08f0e80  ! 2212: LDUBA_R	lduba	[%r28, %r0] 0x74, %r8
	.word 0xd2b584a0  ! 2213: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0xd88689e0  ! 2214: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r12
	.word 0xdedf4e80  ! 2215: LDXA_R	ldxa	[%r29, %r0] 0x74, %r15
	mov	0x78, %r26
	.word 0xdadf6000  ! 2217: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xd2b609e0  ! 2218: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	.word 0xd4f7a000  ! 2219: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 2220: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4cf2000  ! 2221: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4f44400  ! 2222: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	mov	0x58, %r19
	.word 0x87802025  ! 2224: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6c70e80  ! 2225: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r11
	mov	0x3c0, %r20
	.word 0xdeb40400  ! 2227: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0xd4cfe000  ! 2228: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0xd4bf6000  ! 2229: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd4bfa000  ! 2230: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	mov	0x20, %r24
	.word 0xd0970e40  ! 2232: LDUHA_R	lduha	[%r28, %r0] 0x72, %r8
	mov	0x68, %r16
	.word 0xdc8cc400  ! 2234: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	.word 0xd2b74e60  ! 2235: STHA_R	stha	%r9, [%r29 + %r0] 0x73
	.word 0xd6bf6000  ! 2236: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd0be09e0  ! 2237: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0xdaaf6000  ! 2238: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xdacfe000  ! 2239: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0xd6dec9e0  ! 2240: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r11
	.word 0x87802025  ! 2241: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd4d6e000  ! 2243: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r10
	mov	0x70, %r19
	.word 0xd0d584a0  ! 2245: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r8
	.word 0x87802073  ! 2246: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb689e0  ! 2247: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	.word 0xd2ce49e0  ! 2248: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r9
	.word 0x87802074  ! 2249: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd88584a0  ! 2250: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r12
	.word 0xd0ce49e0  ! 2251: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r8
	.word 0xd8dea000  ! 2252: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r12
	.word 0xd886a000  ! 2253: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r12
	.word 0xd2ce89e0  ! 2254: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r9
	.word 0xd8ce2000  ! 2255: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r12
	.word 0xd8a6e000  ! 2256: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	.word 0xd0b7ce60  ! 2257: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	mov	0x18, %r26
	mov	0x7e8, %r21
	mov	0x78, %r19
	.word 0xd0ce6000  ! 2261: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r8
	.word 0xd6f78e60  ! 2262: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	.word 0xd2a544a0  ! 2263: STWA_R	stwa	%r9, [%r21 + %r0] 0x25
	.word 0xd6c6c9e0  ! 2264: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r11
	.word 0xdeaea000  ! 2265: STBA_I	stba	%r15, [%r26 + 0x0000] %asi
	.word 0xd2ac8400  ! 2266: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xdaa62000  ! 2267: STWA_I	stwa	%r13, [%r24 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xdad62000  ! 2269: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r13
	.word 0xdabee000  ! 2270: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	.word 0xdac6a000  ! 2271: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r13
	.word 0xdcaf0e40  ! 2272: STBA_R	stba	%r14, [%r28 + %r0] 0x72
	.word 0x87802025  ! 2273: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdab72000  ! 2274: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xd8acc400  ! 2275: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0x87802073  ! 2276: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b44400  ! 2277: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xd8af4e60  ! 2278: STBA_R	stba	%r12, [%r29 + %r0] 0x73
	.word 0xd0dce000  ! 2279: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r8
	.word 0xdcac0400  ! 2280: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	mov	0x7d8, %r20
	.word 0xd0d4c400  ! 2282: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	mov	0x68, %r25
	mov	0x50, %r17
	.word 0xdcb7ce40  ! 2285: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	.word 0xdc978e40  ! 2286: LDUHA_R	lduha	[%r30, %r0] 0x72, %r14
	.word 0xd8aca000  ! 2287: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	mov	0x3c8, %r20
	mov	0x60, %r24
	.word 0xd8f46000  ! 2290: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xdcbf0e80  ! 2291: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	.word 0xd8b40400  ! 2292: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	mov	0x3d8, %r21
	.word 0xd0a46000  ! 2294: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 2295: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0972000  ! 2296: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0cf0e60  ! 2297: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r8
	.word 0xd6cd44a0  ! 2298: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r11
	.word 0xdca7e000  ! 2299: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	mov	0x3c8, %r20
	.word 0xd8af8e60  ! 2301: STBA_R	stba	%r12, [%r30 + %r0] 0x73
	.word 0xdaafa000  ! 2302: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xd8be89e0  ! 2303: STDA_R	stda	%r12, [%r26 + %r0] 0x4f
	.word 0xd6a78e60  ! 2304: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0x8780204f  ! 2305: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 2306: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a70e40  ! 2307: STWA_R	stwa	%r11, [%r28 + %r0] 0x72
	.word 0xd09609e0  ! 2308: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r8
	mov	0x7e0, %r23
	.word 0xd0f52000  ! 2310: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	mov	0x60, %r26
	.word 0x8780204f  ! 2312: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a7a000  ! 2313: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0972000  ! 2314: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	mov	0x3f8, %r20
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0f7a000  ! 2317: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 2318: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeae09e0  ! 2319: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 2320: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad4a000  ! 2321: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0xdacce000  ! 2322: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r13
	mov	0x8, %r26
	mov	0x70, %r17
	.word 0xda94e000  ! 2325: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r13
	.word 0xd6a74e60  ! 2326: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	.word 0xdc84e000  ! 2327: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r14
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0f78e60  ! 2329: STXA_R	stxa	%r8, [%r30 + %r0] 0x73
	mov	0x40, %r27
	.word 0xd4b544a0  ! 2331: STHA_R	stha	%r10, [%r21 + %r0] 0x25
	.word 0xde9ca000  ! 2332: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	mov	0x3c8, %r21
	.word 0xdec4e000  ! 2334: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	.word 0x87802073  ! 2335: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 2336: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 2337: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8e09e0  ! 2338: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r13
	.word 0xd6bf6000  ! 2339: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 2340: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r27
	.word 0xd6b7a000  ! 2342: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd8b78e40  ! 2343: STHA_R	stha	%r12, [%r30 + %r0] 0x72
	mov	0x3d0, %r20
	mov	0x3e8, %r21
	.word 0xd08f6000  ! 2346: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r8
	.word 0xd0df8e40  ! 2347: LDXA_R	ldxa	[%r30, %r0] 0x72, %r8
	mov	0x58, %r16
	.word 0xd2b4c400  ! 2349: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xdcdf6000  ! 2350: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	mov	0x3d0, %r22
	.word 0xd88544a0  ! 2352: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r12
	.word 0xd88fa000  ! 2353: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2354: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bf2000  ! 2355: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xd8bfa000  ! 2357: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	mov	0x30, %r24
	.word 0xd88f2000  ! 2359: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0x87802072  ! 2360: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdac609e0  ! 2361: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r13
	.word 0xd29f8e80  ! 2362: LDDA_R	ldda	[%r30, %r0] 0x74, %r9
	mov	0x10, %r19
	.word 0x87802073  ! 2364: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r19
	.word 0xdebfce60  ! 2366: STDA_R	stda	%r15, [%r31 + %r0] 0x73
	mov	0x7e8, %r20
	.word 0xd4d6c9e0  ! 2368: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r10
	mov	0x3d0, %r21
	mov	0x3d0, %r21
	.word 0xd286e000  ! 2371: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r9
	.word 0xd2dea000  ! 2372: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2f62000  ! 2374: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	.word 0xd2cea000  ! 2375: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2376: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd297e000  ! 2377: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	mov	0x60, %r18
	.word 0xd2bfe000  ! 2379: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd2df6000  ! 2380: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	mov	0x8, %r18
	.word 0xdc8c4400  ! 2382: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0xd2bc8400  ! 2383: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	.word 0xd8d7a000  ! 2384: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	mov	0x28, %r26
	.word 0xdaa689e0  ! 2386: STWA_R	stwa	%r13, [%r26 + %r0] 0x4f
	mov	0x58, %r17
	.word 0xd0b7a000  ! 2388: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	mov	0x20, %r17
	.word 0x87802020  ! 2390: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r17
	mov	0x3c8, %r23
	mov	0x8, %r24
	.word 0xd0f46000  ! 2394: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 2395: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d8, %r20
	.word 0x87802025  ! 2397: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 2398: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2ae89e0  ! 2399: STBA_R	stba	%r9, [%r26 + %r0] 0x4f
	mov	0x3e0, %r23
	mov	0x18, %r25
	mov	0x7e8, %r21
	.word 0xd6d74e80  ! 2403: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r11
	.word 0x87802020  ! 2404: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r20
	.word 0xd6dcc400  ! 2406: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	.word 0x87802074  ! 2407: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2408: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0c72000  ! 2409: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xd2a44400  ! 2410: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xda8f8e80  ! 2411: LDUBA_R	lduba	[%r30, %r0] 0x74, %r13
	.word 0x87802025  ! 2412: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda9f0e40  ! 2413: LDDA_R	ldda	[%r28, %r0] 0x72, %r13
	.word 0xd0c72000  ! 2414: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	mov	0x38, %r18
	mov	0x8, %r27
	.word 0xd0c7a000  ! 2417: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xdcd74e80  ! 2418: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r14
	.word 0x87802072  ! 2419: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b70e40  ! 2420: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	.word 0xdcd42000  ! 2421: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	.word 0x87802073  ! 2422: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf7a000  ! 2423: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xdc872000  ! 2424: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcb76000  ! 2425: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0xdc87e000  ! 2427: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	mov	0x38, %r16
	.word 0xdcc76000  ! 2429: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2430: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccfe000  ! 2431: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xd88689e0  ! 2432: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r12
	.word 0xd8d48400  ! 2433: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0xdcf6c9e0  ! 2434: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	.word 0x87802025  ! 2435: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0d7ce80  ! 2436: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r8
	.word 0xdef7e000  ! 2437: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xde876000  ! 2438: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xdef78e80  ! 2439: STXA_R	stxa	%r15, [%r30 + %r0] 0x74
	mov	0x3f8, %r23
	mov	0x0, %r26
	.word 0xd6b7a000  ! 2442: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd6f7a000  ! 2443: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 2444: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r26
	mov	0x8, %r24
	.word 0xd2b70e40  ! 2447: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	.word 0xde976000  ! 2448: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	mov	0x3d0, %r20
	mov	0x3e8, %r22
	.word 0xd4df0e40  ! 2451: LDXA_R	ldxa	[%r28, %r0] 0x72, %r10
	.word 0x87802020  ! 2452: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4adc4a0  ! 2453: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0x87802025  ! 2454: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8f48400  ! 2455: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xd8af2000  ! 2456: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xde944400  ! 2457: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	mov	0x60, %r26
	.word 0xde8d44a0  ! 2459: LDUBA_R	lduba	[%r21, %r0] 0x25, %r15
	.word 0xd89f6000  ! 2460: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	.word 0xda944400  ! 2461: LDUHA_R	lduha	[%r17, %r0] 0x20, %r13
	.word 0xd4f7a000  ! 2462: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	mov	0x3d0, %r23
	mov	0x48, %r17
	mov	0x3d0, %r20
	.word 0xda9d44a0  ! 2466: LDDA_R	ldda	[%r21, %r0] 0x25, %r13
	.word 0xde8c8400  ! 2467: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	.word 0xd2dfe000  ! 2468: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0xd297e000  ! 2469: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2470: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2ac6000  ! 2471: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd0bfce60  ! 2472: STDA_R	stda	%r8, [%r31 + %r0] 0x73
	mov	0x48, %r18
	.word 0xdabc2000  ! 2474: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xde9f4e40  ! 2475: LDDA_R	ldda	[%r29, %r0] 0x72, %r15
	.word 0xdedc8400  ! 2476: LDXA_R	ldxa	[%r18, %r0] 0x20, %r15
	.word 0xd0f4e000  ! 2477: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	mov	0x7e0, %r22
	.word 0xd08c6000  ! 2479: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0xd0a42000  ! 2480: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xd0aca000  ! 2481: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xd09c2000  ! 2482: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r8
	.word 0xd0a42000  ! 2483: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	mov	0x8, %r26
	.word 0xd8844400  ! 2485: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r12
	.word 0x87802020  ! 2486: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde84c400  ! 2487: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0x8780204f  ! 2488: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r26
	.word 0xd6d70e40  ! 2490: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r11
	.word 0xdabc2000  ! 2491: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xda84c400  ! 2492: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r13
	.word 0xd0f504a0  ! 2493: STXA_R	stxa	%r8, [%r20 + %r0] 0x25
	mov	0x10, %r19
	.word 0xdec689e0  ! 2495: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r15
	.word 0xd694a000  ! 2496: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r11
	.word 0x87802073  ! 2497: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f544a0  ! 2498: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	.word 0xd6bfce40  ! 2499: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	mov	0x20, %r24
	.word 0x87802020  ! 2501: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2502: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2503: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f48400  ! 2504: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xd8d504a0  ! 2505: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r12
	mov	0x20, %r26
	mov	0x3e0, %r20
	.word 0xdad4a000  ! 2508: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	mov	0x3d8, %r21
	.word 0xde84c400  ! 2510: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0xdabcc400  ! 2511: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	.word 0x87802072  ! 2512: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2bca000  ! 2513: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	.word 0xdeaf8e40  ! 2514: STBA_R	stba	%r15, [%r30 + %r0] 0x72
	.word 0xdeb78e60  ! 2515: STHA_R	stha	%r15, [%r30 + %r0] 0x73
	.word 0xdcdf0e80  ! 2516: LDXA_R	ldxa	[%r28, %r0] 0x74, %r14
	.word 0xdec42000  ! 2517: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0x87802074  ! 2518: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2519: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2520: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xdea46000  ! 2522: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xdeaca000  ! 2523: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xdeb46000  ! 2524: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0xd6f6c9e0  ! 2525: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	.word 0x87802025  ! 2526: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6df2000  ! 2527: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6a7e000  ! 2528: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 2529: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4bd44a0  ! 2530: STDA_R	stda	%r10, [%r21 + %r0] 0x25
	.word 0xdab44400  ! 2531: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0xdcace000  ! 2532: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0xd0bf0e40  ! 2533: STDA_R	stda	%r8, [%r28 + %r0] 0x72
	.word 0xd2cca000  ! 2534: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	mov	0x7f8, %r23
	mov	0x40, %r17
	.word 0xdab44400  ! 2537: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0x87802020  ! 2538: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8e2000  ! 2539: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r13
	.word 0xd8c78e80  ! 2540: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r12
	mov	0x3e8, %r22
	.word 0xd4dee000  ! 2542: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r10
	.word 0xd2d70e80  ! 2543: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r9
	.word 0xd8970e40  ! 2544: LDUHA_R	lduha	[%r28, %r0] 0x72, %r12
	.word 0xd4cea000  ! 2545: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r10
	.word 0xd4d6a000  ! 2546: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r10
	.word 0xd4848400  ! 2547: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r10
	.word 0x87802025  ! 2548: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cf8e80  ! 2549: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r10
	.word 0xd69f4e60  ! 2550: LDDA_R	ldda	[%r29, %r0] 0x73, %r11
	ta	T_CHANGE_PRIV	! macro
	mov	0x3e0, %r23
	mov	0x30, %r17
	.word 0xda952000  ! 2554: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r13
	.word 0xda95e000  ! 2555: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r13
	.word 0xdaaf8e60  ! 2556: STBA_R	stba	%r13, [%r30 + %r0] 0x73
	mov	0x7e8, %r23
	.word 0xd6cd6000  ! 2558: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r11
	.word 0xd6f56000  ! 2559: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	.word 0xd8bf4e40  ! 2560: STDA_R	stda	%r12, [%r29 + %r0] 0x72
	.word 0x87802072  ! 2561: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd69cc400  ! 2562: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	.word 0xdc8ec9e0  ! 2563: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r14
	.word 0x87802020  ! 2564: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bc2000  ! 2565: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 2566: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cf6000  ! 2567: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd0f72000  ! 2568: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xd0872000  ! 2569: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xdeac0400  ! 2570: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0x87802074  ! 2571: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdecf0e60  ! 2572: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r15
	.word 0xdacfce60  ! 2573: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r13
	.word 0xdecc8400  ! 2574: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	mov	0x70, %r26
	.word 0xd0d6a000  ! 2576: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r8
	.word 0xdcb504a0  ! 2577: STHA_R	stha	%r14, [%r20 + %r0] 0x25
	.word 0xd0bd84a0  ! 2578: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0xd0cea000  ! 2579: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r8
	mov	0x70, %r16
	.word 0xd2f544a0  ! 2581: STXA_R	stxa	%r9, [%r21 + %r0] 0x25
	mov	0x7e0, %r20
	.word 0xd2dee000  ! 2583: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r9
	.word 0xdc8649e0  ! 2584: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r14
	.word 0xd8c66000  ! 2585: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r12
	.word 0xd4a48400  ! 2586: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	mov	0x50, %r19
	.word 0xd486a000  ! 2588: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r10
	mov	0x70, %r27
	.word 0xd4ae6000  ! 2590: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0xd4f6e000  ! 2591: STXA_I	stxa	%r10, [%r27 + 0x0000] %asi
	.word 0xd49ea000  ! 2592: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	mov	0x60, %r16
	mov	0x28, %r17
	mov	0x3c8, %r22
	.word 0xd6d649e0  ! 2596: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r11
	.word 0x87802025  ! 2597: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2598: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf4c400  ! 2599: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xd8b40400  ! 2600: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xd29fa000  ! 2601: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd2bfa000  ! 2602: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 2603: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a46000  ! 2604: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 2605: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 2606: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 2607: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b7ce40  ! 2608: STHA_R	stha	%r10, [%r31 + %r0] 0x72
	.word 0xd8866000  ! 2609: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r12
	.word 0xd88ee000  ! 2610: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r12
	.word 0xd89ea000  ! 2611: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r12
	.word 0xd8962000  ! 2612: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r12
	.word 0xdcb609e0  ! 2613: STHA_R	stha	%r14, [%r24 + %r0] 0x4f
	.word 0xd8bea000  ! 2614: STDA_I	stda	%r12, [%r26 + 0x0000] %asi
	.word 0xd8cee000  ! 2615: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r12
	mov	0x18, %r19
	mov	0x28, %r26
	.word 0x87802020  ! 2618: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r17
	.word 0xd2cd84a0  ! 2620: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r9
	.word 0xd4a66000  ! 2621: STWA_I	stwa	%r10, [%r25 + 0x0000] %asi
	.word 0xd2c74e60  ! 2622: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r9
	mov	0x8, %r16
	.word 0xdcd5c4a0  ! 2624: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r14
	.word 0x87802072  ! 2625: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca74e80  ! 2626: STWA_R	stwa	%r14, [%r29 + %r0] 0x74
	mov	0x40, %r19
	mov	0x18, %r19
	.word 0xd8966000  ! 2629: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r12
	.word 0xd8d62000  ! 2630: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r12
	mov	0x7e0, %r23
	.word 0xd8b6a000  ! 2632: STHA_I	stha	%r12, [%r26 + 0x0000] %asi
	.word 0xd0c74e60  ! 2633: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r8
	mov	0x30, %r18
	mov	0x7d8, %r20
	.word 0xde87ce40  ! 2636: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r15
	.word 0x87802025  ! 2637: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r17
	mov	0x8, %r17
	mov	0x0, %r25
	mov	0x30, %r25
	.word 0x8780204f  ! 2642: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x48, %r16
	.word 0xdcd44400  ! 2644: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	mov	0x60, %r18
	mov	0x38, %r27
	mov	0x7e0, %r21
	.word 0xd6c649e0  ! 2648: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r11
	.word 0xdedf4e60  ! 2649: LDXA_R	ldxa	[%r29, %r0] 0x73, %r15
	.word 0xdc8609e0  ! 2650: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r14
	mov	0x48, %r25
	.word 0xd0f70e60  ! 2652: STXA_R	stxa	%r8, [%r28 + %r0] 0x73
	.word 0xd6dde000  ! 2653: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 2654: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r18
	.word 0xd6f76000  ! 2656: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd69f6000  ! 2657: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	.word 0xd8a48400  ! 2658: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	.word 0xd0c76000  ! 2659: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0xdadcc400  ! 2660: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xd0cd84a0  ! 2661: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r8
	.word 0xd2cd04a0  ! 2662: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r9
	.word 0xd68609e0  ! 2663: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r11
	.word 0xd48fa000  ! 2664: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	mov	0x28, %r17
	.word 0x87802073  ! 2666: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 2667: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4b7e000  ! 2668: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	mov	0x3e0, %r21
	.word 0xd2f70e80  ! 2670: STXA_R	stxa	%r9, [%r28 + %r0] 0x74
	.word 0x87802072  ! 2671: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r25
	.word 0xd0cd84a0  ! 2673: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r8
	.word 0xd2b689e0  ! 2674: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	.word 0xd6848400  ! 2675: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	.word 0x87802073  ! 2676: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4a70e80  ! 2677: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	.word 0xdc9fe000  ! 2678: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xdcc544a0  ! 2679: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r14
	.word 0x87802072  ! 2680: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f76000  ! 2681: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 2682: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf4c400  ! 2683: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xdcf7e000  ! 2684: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x68, %r24
	mov	0x7e0, %r21
	mov	0x7e0, %r22
	.word 0x87802072  ! 2688: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc9f8e60  ! 2689: LDDA_R	ldda	[%r30, %r0] 0x73, %r14
	.word 0xde944400  ! 2690: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	.word 0xdcdf2000  ! 2691: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcafe000  ! 2693: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdcf7a000  ! 2694: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x10, %r26
	.word 0xdcd78e80  ! 2696: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r14
	mov	0x58, %r19
	.word 0xdcf7a000  ! 2698: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xdca7a000  ! 2699: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	mov	0x3d8, %r21
	.word 0xd0b7ce40  ! 2701: STHA_R	stha	%r8, [%r31 + %r0] 0x72
	.word 0x87802025  ! 2702: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bda000  ! 2703: STDA_I	stda	%r9, [%r22 + 0x0000] %asi
	.word 0xdaccc400  ! 2704: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r13
	.word 0xdeb56000  ! 2705: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	.word 0xd4af8e60  ! 2706: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	.word 0x8780204f  ! 2707: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdef76000  ! 2708: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xd4f70e40  ! 2709: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	.word 0xde9584a0  ! 2710: LDUHA_R	lduha	[%r22, %r0] 0x25, %r15
	.word 0xd4bfe000  ! 2711: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd4d76000  ! 2712: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0xd0dc0400  ! 2713: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xdcbf2000  ! 2714: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdcd76000  ! 2715: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	.word 0xdc8f6000  ! 2716: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	mov	0x7e8, %r21
	.word 0xdaf584a0  ! 2718: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	mov	0x18, %r25
	.word 0xdaa7e000  ! 2720: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	mov	0x48, %r17
	.word 0xd08fce80  ! 2722: LDUBA_R	lduba	[%r31, %r0] 0x74, %r8
	mov	0x78, %r16
	.word 0xd2f72000  ! 2724: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd29f2000  ! 2725: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd2bf6000  ! 2726: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd4a70e60  ! 2727: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	.word 0x87802020  ! 2728: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2729: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f6a000  ! 2730: STXA_I	stxa	%r11, [%r26 + 0x0000] %asi
	.word 0xd6866000  ! 2731: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r11
	mov	0x3d8, %r20
	.word 0xd6966000  ! 2733: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r11
	.word 0xd6a66000  ! 2734: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	.word 0xd6a62000  ! 2735: STWA_I	stwa	%r11, [%r24 + 0x0000] %asi
	.word 0x87802073  ! 2736: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 2737: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a44400  ! 2738: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0xdc87a000  ! 2739: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2740: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2741: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc970e40  ! 2742: LDUHA_R	lduha	[%r28, %r0] 0x72, %r14
	mov	0x7e8, %r23
	.word 0xd6f7ce60  ! 2744: STXA_R	stxa	%r11, [%r31 + %r0] 0x73
	.word 0xdecce000  ! 2745: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	.word 0xd4b544a0  ! 2746: STHA_R	stha	%r10, [%r21 + %r0] 0x25
	.word 0xde8fce60  ! 2747: LDUBA_R	lduba	[%r31, %r0] 0x73, %r15
	.word 0x87802072  ! 2748: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r17
	.word 0xdab40400  ! 2750: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xd6df4e40  ! 2751: LDXA_R	ldxa	[%r29, %r0] 0x72, %r11
	.word 0xdcbf2000  ! 2752: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdaa48400  ! 2753: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0xd6a609e0  ! 2754: STWA_R	stwa	%r11, [%r24 + %r0] 0x4f
	.word 0xdc8f6000  ! 2755: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	mov	0x10, %r25
	mov	0x40, %r24
	.word 0xdcf72000  ! 2758: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	mov	0x7d8, %r23
	mov	0x3c0, %r20
	.word 0xd6bd04a0  ! 2761: STDA_R	stda	%r11, [%r20 + %r0] 0x25
	.word 0xd2ac4400  ! 2762: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0x87802020  ! 2763: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bd04a0  ! 2764: STDA_R	stda	%r9, [%r20 + %r0] 0x25
	.word 0xd094e000  ! 2765: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0xd6b7ce60  ! 2766: STHA_R	stha	%r11, [%r31 + %r0] 0x73
	.word 0xdc948400  ! 2767: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	.word 0xd88ca000  ! 2768: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	.word 0xd0ae09e0  ! 2769: STBA_R	stba	%r8, [%r24 + %r0] 0x4f
	.word 0x87802025  ! 2770: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r24
	.word 0xd2b7a000  ! 2772: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	mov	0x3d0, %r21
	mov	0x38, %r18
	.word 0xdaa504a0  ! 2775: STWA_R	stwa	%r13, [%r20 + %r0] 0x25
	.word 0xd687a000  ! 2776: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0xdc8d84a0  ! 2777: LDUBA_R	lduba	[%r22, %r0] 0x25, %r14
	.word 0x8780204f  ! 2778: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2779: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2780: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c0, %r21
	.word 0xdab74e80  ! 2782: STHA_R	stha	%r13, [%r29 + %r0] 0x74
	.word 0xd0c44400  ! 2783: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r8
	.word 0xd4b72000  ! 2784: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd2b6c9e0  ! 2785: STHA_R	stha	%r9, [%r27 + %r0] 0x4f
	mov	0x48, %r25
	mov	0x8, %r18
	mov	0x30, %r26
	.word 0xd69f8e80  ! 2789: LDDA_R	ldda	[%r30, %r0] 0x74, %r11
	.word 0x87802074  ! 2790: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28c2000  ! 2791: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xd28ca000  ! 2792: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2c4e000  ! 2793: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xd4d44400  ! 2794: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0xd0d4e000  ! 2795: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	.word 0xd0f4a000  ! 2796: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xd0942000  ! 2797: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r8
	.word 0x87802072  ! 2798: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf5c4a0  ! 2799: STXA_R	stxa	%r13, [%r23 + %r0] 0x25
	.word 0xd09f8e60  ! 2800: LDDA_R	ldda	[%r30, %r0] 0x73, %r8
	.word 0xd2bfa000  ! 2801: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd2b7e000  ! 2802: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2b7a000  ! 2803: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xdcb7ce40  ! 2804: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	.word 0xd8dfa000  ! 2805: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8f7a000  ! 2806: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd6d44400  ! 2807: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r11
	.word 0xd6cf0e40  ! 2808: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r11
	.word 0x87802074  ! 2809: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a70e60  ! 2810: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802073  ! 2812: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 2813: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbf0e60  ! 2814: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	.word 0xd2aea000  ! 2815: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0xd2f62000  ! 2816: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	mov	0x48, %r18
	mov	0x48, %r25
	.word 0xd2dc4400  ! 2819: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xd4f44400  ! 2820: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0xd0bea000  ! 2821: STDA_I	stda	%r8, [%r26 + 0x0000] %asi
	.word 0xd0b66000  ! 2822: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	.word 0xd6dd84a0  ! 2823: LDXA_R	ldxa	[%r22, %r0] 0x25, %r11
	.word 0xdaaf0e80  ! 2824: STBA_R	stba	%r13, [%r28 + %r0] 0x74
	.word 0xd68c8400  ! 2825: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	mov	0x30, %r16
	.word 0xd4cc0400  ! 2827: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r10
	mov	0x18, %r27
	.word 0xdaafce60  ! 2829: STBA_R	stba	%r13, [%r31 + %r0] 0x73
	mov	0x7c0, %r20
	.word 0xd6d6e000  ! 2831: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r11
	mov	0x18, %r25
	.word 0xd686e000  ! 2833: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r11
	.word 0x87802074  ! 2834: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8dc0400  ! 2835: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0xdabca000  ! 2836: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	mov	0x70, %r18
	.word 0xdab4e000  ! 2838: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xda8c2000  ! 2839: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r13
	.word 0xdab42000  ! 2840: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 2841: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b584a0  ! 2842: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	mov	0x8, %r18
	.word 0x87802074  ! 2844: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdccf6000  ! 2845: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xd4a6c9e0  ! 2846: STWA_R	stwa	%r10, [%r27 + %r0] 0x4f
	.word 0xd0a72000  ! 2847: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x28, %r27
	.word 0x87802074  ! 2849: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda9f0e80  ! 2850: LDDA_R	ldda	[%r28, %r0] 0x74, %r13
	mov	0x48, %r18
	.word 0x87802073  ! 2852: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4dc2000  ! 2853: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	.word 0xd4f46000  ! 2854: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0xd8a48400  ! 2855: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	mov	0x30, %r19
	.word 0x87802020  ! 2857: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2858: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdabd04a0  ! 2859: STDA_R	stda	%r13, [%r20 + %r0] 0x25
	mov	0x7e0, %r20
	.word 0xd2c46000  ! 2861: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	mov	0x70, %r25
	.word 0xd2f46000  ! 2863: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xda9d04a0  ! 2864: LDDA_R	ldda	[%r20, %r0] 0x25, %r13
	mov	0x3d8, %r23
	.word 0xd2f7ce80  ! 2866: STXA_R	stxa	%r9, [%r31 + %r0] 0x74
	.word 0xd6ae49e0  ! 2867: STBA_R	stba	%r11, [%r25 + %r0] 0x4f
	.word 0xd0c42000  ! 2868: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r8
	.word 0xd2bdc4a0  ! 2869: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802073  ! 2871: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a544a0  ! 2872: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	mov	0x40, %r27
	.word 0xd6f40400  ! 2874: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	.word 0xd69ca000  ! 2875: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r11
	.word 0xd6ac6000  ! 2876: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xd6ac2000  ! 2877: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xd2b40400  ! 2879: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0xd89689e0  ! 2880: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r12
	.word 0xd0f70e80  ! 2881: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0xdeaca000  ! 2882: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xdcdf4e80  ! 2883: LDXA_R	ldxa	[%r29, %r0] 0x74, %r14
	mov	0x68, %r16
	.word 0xd2bec9e0  ! 2885: STDA_R	stda	%r9, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 2886: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4bfa000  ! 2887: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd4afa000  ! 2888: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xdcb4c400  ! 2889: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	mov	0x58, %r16
	.word 0xd887e000  ! 2891: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8df2000  ! 2892: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	mov	0x68, %r25
	.word 0xd8cf6000  ! 2894: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	mov	0x70, %r25
	.word 0xdeadc4a0  ! 2896: STBA_R	stba	%r15, [%r23 + %r0] 0x25
	.word 0xda8c0400  ! 2897: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	.word 0xd4a7ce80  ! 2898: STWA_R	stwa	%r10, [%r31 + %r0] 0x74
	.word 0xdc8f6000  ! 2899: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcd72000  ! 2900: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xdca72000  ! 2901: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xd2aec9e0  ! 2902: STBA_R	stba	%r9, [%r27 + %r0] 0x4f
	.word 0x87802025  ! 2903: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd485c4a0  ! 2904: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r10
	.word 0xd4cce000  ! 2905: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	.word 0xd0f504a0  ! 2906: STXA_R	stxa	%r8, [%r20 + %r0] 0x25
	.word 0xd4bc0400  ! 2907: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xd68c2000  ! 2908: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r11
	.word 0xd6dc2000  ! 2909: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2910: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6afe000  ! 2911: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0xdeac8400  ! 2913: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	mov	0x40, %r16
	mov	0x68, %r17
	.word 0xdcbc4400  ! 2916: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0xdcc72000  ! 2917: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2918: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a7ce40  ! 2919: STWA_R	stwa	%r9, [%r31 + %r0] 0x72
	.word 0xd69c0400  ! 2920: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	.word 0xd8b78e60  ! 2921: STHA_R	stha	%r12, [%r30 + %r0] 0x73
	mov	0x48, %r19
	.word 0xdedc4400  ! 2923: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	mov	0x7e8, %r20
	.word 0x87802020  ! 2925: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0c7a000  ! 2926: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xd4df4e40  ! 2927: LDXA_R	ldxa	[%r29, %r0] 0x72, %r10
	.word 0xda8e49e0  ! 2928: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r13
	mov	0x28, %r27
	.word 0x87802025  ! 2930: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2931: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r23
	.word 0xd09ec9e0  ! 2933: LDDA_R	ldda	[%r27, %r0] 0x4f, %r8
	mov	0x3c0, %r22
	.word 0x8780204f  ! 2935: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0af6000  ! 2936: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd0bfe000  ! 2937: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd0b70e40  ! 2938: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	.word 0xd2bfce60  ! 2939: STDA_R	stda	%r9, [%r31 + %r0] 0x73
	mov	0x7e0, %r22
	.word 0x87802073  ! 2941: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8b4e000  ! 2942: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 2943: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca504a0  ! 2944: STWA_R	stwa	%r14, [%r20 + %r0] 0x25
	.word 0xdabd84a0  ! 2945: STDA_R	stda	%r13, [%r22 + %r0] 0x25
	.word 0x87802074  ! 2946: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r24
	mov	0x3e0, %r21
	.word 0xd68f8e40  ! 2949: LDUBA_R	lduba	[%r30, %r0] 0x72, %r11
	.word 0xdecd84a0  ! 2950: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r15
	.word 0xd8af4e40  ! 2951: STBA_R	stba	%r12, [%r29 + %r0] 0x72
	.word 0xdad6c9e0  ! 2952: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r13
	mov	0x7d8, %r22
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802025  ! 2955: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebcc400  ! 2956: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	mov	0x28, %r18
	mov	0x0, %r25
	.word 0xd0c649e0  ! 2959: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r8
	mov	0x78, %r24
	.word 0xd2d48400  ! 2961: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	mov	0x10, %r27
	.word 0xd2bf8e80  ! 2963: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	.word 0xdaa48400  ! 2964: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0xdc9e09e0  ! 2965: LDDA_R	ldda	[%r24, %r0] 0x4f, %r14
	.word 0xdc8fce40  ! 2966: LDUBA_R	lduba	[%r31, %r0] 0x72, %r14
	mov	0x28, %r24
	mov	0x7c0, %r23
	.word 0xdca584a0  ! 2969: STWA_R	stwa	%r14, [%r22 + %r0] 0x25
	mov	0x70, %r24
	.word 0x87802073  ! 2971: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4a544a0  ! 2972: STWA_R	stwa	%r10, [%r21 + %r0] 0x25
	.word 0x87802073  ! 2973: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r16
	.word 0xd2c70e40  ! 2975: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r9
	mov	0x70, %r18
	.word 0xd0ce2000  ! 2977: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r8
	.word 0xd0966000  ! 2978: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r8
	.word 0xdcd7ce60  ! 2979: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r14
	mov	0x3e0, %r22
	.word 0xd6bc8400  ! 2981: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0x87802025  ! 2982: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2983: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r19
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd8bca000  ! 2986: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd88fce60  ! 2987: LDUBA_R	lduba	[%r31, %r0] 0x73, %r12
	.word 0xd2a42000  ! 2988: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	.word 0xd29c2000  ! 2989: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2990: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca544a0  ! 2991: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0xd2f48400  ! 2992: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0x87802020  ! 2993: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a5e000  ! 2994: STWA_I	stwa	%r10, [%r23 + 0x0000] %asi
	mov	0x48, %r24
	.word 0x87802072  ! 2996: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49f6000  ! 2997: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	mov	0x3c0, %r23
	mov	0x7d8, %r22
	.word 0xd48fa000  ! 3000: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	mov	0x10, %r26
	mov	0x3f8, %r21
	.word 0xdaf74e80  ! 3003: STXA_R	stxa	%r13, [%r29 + %r0] 0x74
	.word 0xd6f72000  ! 3004: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 3005: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b78e60  ! 3006: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	mov	0x28, %r19
	.word 0xdaaf6000  ! 3008: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 3009: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf52000  ! 3010: STXA_I	stxa	%r13, [%r20 + 0x0000] %asi
	.word 0xd2a544a0  ! 3011: STWA_R	stwa	%r9, [%r21 + %r0] 0x25
	mov	0x58, %r17
	mov	0x3c0, %r23
	.word 0xdabde000  ! 3014: STDA_I	stda	%r13, [%r23 + 0x0000] %asi
	.word 0xda9da000  ! 3015: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r13
	.word 0x87802073  ! 3016: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda9fe000  ! 3017: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xdacfe000  ! 3018: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0xdabc8400  ! 3019: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	mov	0x68, %r25
	mov	0x3f0, %r22
	.word 0xd4b44400  ! 3022: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 3023: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2cfce40  ! 3024: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r9
	mov	0x30, %r26
	mov	0x7c0, %r23
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802025  ! 3028: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r25
	.word 0xde8e09e0  ! 3030: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r15
	.word 0xd2b7e000  ! 3031: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 3032: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 3033: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bfe000  ! 3034: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd297a000  ! 3035: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	.word 0xd2a76000  ! 3036: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	mov	0x0, %r16
	.word 0xd2bf2000  ! 3038: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	mov	0x20, %r26
	mov	0x3c8, %r22
	.word 0xd4af0e60  ! 3041: STBA_R	stba	%r10, [%r28 + %r0] 0x73
	.word 0xd6afa000  ! 3042: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6f7e000  ! 3043: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 3044: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6c66000  ! 3045: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r11
	.word 0xd6862000  ! 3046: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r11
	mov	0x7e8, %r23
	.word 0xd68e6000  ! 3048: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r11
	.word 0xd8c40400  ! 3049: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	mov	0x3d8, %r22
	mov	0x58, %r27
	.word 0xd2de89e0  ! 3052: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r9
	.word 0xd2844400  ! 3053: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	.word 0xd6c70e60  ! 3054: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r11
	.word 0xd6f62000  ! 3055: STXA_I	stxa	%r11, [%r24 + 0x0000] %asi
	.word 0xdeb544a0  ! 3056: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	.word 0xd88584a0  ! 3057: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r12
	.word 0xdc9f4e60  ! 3058: LDDA_R	ldda	[%r29, %r0] 0x73, %r14
	.word 0xdc8d84a0  ! 3059: LDUBA_R	lduba	[%r22, %r0] 0x25, %r14
	.word 0x87802073  ! 3060: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd48f2000  ! 3061: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4c76000  ! 3062: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	.word 0xd6ac0400  ! 3063: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	mov	0x30, %r26
	.word 0xd2872000  ! 3065: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	mov	0x20, %r19
	.word 0xd2b76000  ! 3067: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2f7e000  ! 3068: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	mov	0x78, %r26
	.word 0xd2bfe000  ! 3070: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	mov	0x8, %r24
	.word 0xd2b48400  ! 3072: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd2a7e000  ! 3073: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xd4b5c4a0  ! 3074: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	.word 0xd2a609e0  ! 3075: STWA_R	stwa	%r9, [%r24 + %r0] 0x4f
	.word 0xd4874e60  ! 3076: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r10
	.word 0xdc9f6000  ! 3077: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xdc976000  ! 3078: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	.word 0xdcb7e000  ! 3079: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	mov	0x48, %r25
	.word 0xdcc7a000  ! 3081: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xdaac0400  ! 3082: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xd8dc8400  ! 3083: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xdc8fe000  ! 3084: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xdea74e80  ! 3085: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	.word 0xd4b7e000  ! 3086: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xdeac0400  ! 3087: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 3088: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0bf8e80  ! 3089: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	mov	0x8, %r27
	mov	0x10, %r24
	mov	0x38, %r26
	.word 0xdeb7e000  ! 3093: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xdecfa000  ! 3095: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xd2af0e40  ! 3096: STBA_R	stba	%r9, [%r28 + %r0] 0x72
	.word 0xd6acc400  ! 3097: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xd0bf0e40  ! 3098: STDA_R	stda	%r8, [%r28 + %r0] 0x72
	.word 0xdaf40400  ! 3099: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	mov	0x3e8, %r22
	.word 0xd0df2000  ! 3101: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	mov	0x50, %r17
	.word 0xdcf7ce80  ! 3103: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	mov	0x58, %r27
	mov	0x78, %r19
	mov	0x48, %r17
	mov	0x10, %r24
	mov	0x60, %r27
	.word 0xd8f4c400  ! 3109: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	mov	0x7d0, %r22
	.word 0xdc8fe000  ! 3111: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	mov	0x10, %r18
	.word 0x87802020  ! 3113: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9fa000  ! 3114: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0xd69c8400  ! 3115: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	.word 0x87802020  ! 3116: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac70e80  ! 3117: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r13
	.word 0xd4ac2000  ! 3118: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	mov	0x28, %r16
	mov	0x8, %r16
	mov	0x60, %r27
	mov	0x3e0, %r22
	.word 0xd48c2000  ! 3123: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r10
	.word 0xd08cc400  ! 3124: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	.word 0xde84a000  ! 3125: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	.word 0xd0f78e80  ! 3126: STXA_R	stxa	%r8, [%r30 + %r0] 0x74
	.word 0xd6a4e000  ! 3127: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 3128: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c0, %r22
	.word 0xd6a7a000  ! 3130: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 3131: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf544a0  ! 3132: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	mov	0x18, %r17
	.word 0xd2f74e40  ! 3134: STXA_R	stxa	%r9, [%r29 + %r0] 0x72
	.word 0xdc9f8e60  ! 3135: LDDA_R	ldda	[%r30, %r0] 0x73, %r14
	.word 0xd6cfa000  ! 3136: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0xd6a44400  ! 3137: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0xd8df2000  ! 3138: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0x87802073  ! 3139: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r26
	.word 0xd8d7e000  ! 3141: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0xdaac0400  ! 3142: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xdad4c400  ! 3143: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	mov	0x8, %r17
	mov	0x58, %r26
	.word 0xd8978e80  ! 3146: LDUHA_R	lduha	[%r30, %r0] 0x74, %r12
	.word 0x8780204f  ! 3147: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802073  ! 3149: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf7ce80  ! 3150: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	.word 0xd0c48400  ! 3151: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r8
	.word 0xd6afa000  ! 3152: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6d72000  ! 3153: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r11
	.word 0xd6872000  ! 3154: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6f7e000  ! 3155: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	mov	0x20, %r25
	.word 0xd6a584a0  ! 3157: STWA_R	stwa	%r11, [%r22 + %r0] 0x25
	.word 0xd28f2000  ! 3158: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	mov	0x3f8, %r22
	.word 0xd2b76000  ! 3160: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2a4c400  ! 3161: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0xdea48400  ! 3162: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xded7a000  ! 3163: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xde87e000  ! 3164: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xde9f6000  ! 3165: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0xdef7e000  ! 3166: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xdedf2000  ! 3167: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	mov	0x7c0, %r21
	.word 0xdeaf6000  ! 3169: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xdea7a000  ! 3170: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	mov	0x50, %r25
	mov	0x3e0, %r23
	.word 0xdec76000  ! 3173: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xdef6c9e0  ! 3174: STXA_R	stxa	%r15, [%r27 + %r0] 0x4f
	.word 0x87802072  ! 3175: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa70e40  ! 3176: STWA_R	stwa	%r13, [%r28 + %r0] 0x72
	.word 0xd2ad44a0  ! 3177: STBA_R	stba	%r9, [%r21 + %r0] 0x25
	.word 0xdcf7e000  ! 3178: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x8, %r25
	.word 0xdec544a0  ! 3180: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r15
	.word 0xd2f7a000  ! 3181: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	mov	0x20, %r27
	.word 0xd29ec9e0  ! 3183: LDDA_R	ldda	[%r27, %r0] 0x4f, %r9
	.word 0x87802020  ! 3184: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcac2000  ! 3185: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 3186: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcd52000  ! 3187: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r14
	.word 0x87802020  ! 3188: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r19
	.word 0xdcd76000  ! 3190: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	.word 0xdcac4400  ! 3191: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	mov	0x58, %r16
	mov	0x18, %r26
	mov	0x3e8, %r20
	.word 0xd8970e80  ! 3195: LDUHA_R	lduha	[%r28, %r0] 0x74, %r12
	.word 0xd8f72000  ! 3196: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	mov	0x3f8, %r22
	.word 0x8780204f  ! 3198: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd884e000  ! 3199: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r12
	mov	0x40, %r25
	mov	0x3f0, %r22
	.word 0xd8be49e0  ! 3202: STDA_R	stda	%r12, [%r25 + %r0] 0x4f
	.word 0x87802074  ! 3203: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r23
	.word 0xd6c70e40  ! 3205: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r11
	.word 0xd2d78e80  ! 3206: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r9
	.word 0xd2d4e000  ! 3207: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3208: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea4c400  ! 3209: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	.word 0xdcd72000  ! 3210: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xd6870e40  ! 3211: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r11
	mov	0x18, %r25
	.word 0xdcf7e000  ! 3213: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xdcf76000  ! 3215: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 3216: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcac2000  ! 3217: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	mov	0x30, %r26
	.word 0xd897ce40  ! 3219: LDUHA_R	lduha	[%r31, %r0] 0x72, %r12
	.word 0xd8d4a000  ! 3220: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0x87802072  ! 3221: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8ad2000  ! 3222: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	.word 0xd8dde000  ! 3223: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r12
	.word 0x87802025  ! 3224: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdef4c400  ! 3225: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	mov	0x60, %r19
	.word 0x87802025  ! 3227: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd89c8400  ! 3228: LDDA_R	ldda	[%r18, %r0] 0x20, %r12
	mov	0x0, %r27
	mov	0x48, %r19
	mov	0x28, %r26
	mov	0x0, %r25
	.word 0xd4dfe000  ! 3233: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802020  ! 3234: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4aca000  ! 3235: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	mov	0x0, %r25
	.word 0xda9544a0  ! 3237: LDUHA_R	lduha	[%r21, %r0] 0x25, %r13
	.word 0xd4874e80  ! 3238: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r10
	.word 0xd2f70e40  ! 3239: STXA_R	stxa	%r9, [%r28 + %r0] 0x72
	mov	0x20, %r25
	mov	0x0, %r16
	.word 0x87802025  ! 3242: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d0, %r22
	mov	0x3f8, %r22
	.word 0xde87a000  ! 3245: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xda86c9e0  ! 3246: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r13
	.word 0xd6bf6000  ! 3247: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd0a40400  ! 3248: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0xd2cfce60  ! 3249: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r9
	.word 0x87802074  ! 3250: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4dcc400  ! 3251: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0x87802072  ! 3252: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3253: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r22
	.word 0xd2b70e60  ! 3255: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	.word 0xd6ac8400  ! 3256: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	mov	0x7e8, %r22
	.word 0xd2dd2000  ! 3258: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r9
	mov	0x7f0, %r21
	.word 0xd4afce80  ! 3260: STBA_R	stba	%r10, [%r31 + %r0] 0x74
	mov	0x3f8, %r22
	.word 0xda9d6000  ! 3262: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r13
	.word 0xdaa52000  ! 3263: STWA_I	stwa	%r13, [%r20 + 0x0000] %asi
	.word 0xdaa52000  ! 3264: STWA_I	stwa	%r13, [%r20 + 0x0000] %asi
	.word 0xdac56000  ! 3265: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r13
	mov	0x7d0, %r20
	.word 0xde9f0e60  ! 3267: LDDA_R	ldda	[%r28, %r0] 0x73, %r15
	.word 0xdef56000  ! 3268: STXA_I	stxa	%r15, [%r21 + 0x0000] %asi
	.word 0xdebda000  ! 3269: STDA_I	stda	%r15, [%r22 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xd0878e80  ! 3271: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r8
	.word 0xdecd2000  ! 3272: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r15
	mov	0x78, %r19
	mov	0x8, %r17
	mov	0x40, %r16
	.word 0xde8de000  ! 3276: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r15
	.word 0xdcad44a0  ! 3277: STBA_R	stba	%r14, [%r21 + %r0] 0x25
	.word 0xdaa56000  ! 3278: STWA_I	stwa	%r13, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 3279: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdacfa000  ! 3280: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xda97a000  ! 3281: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xdaf7a000  ! 3282: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 3283: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8ae09e0  ! 3284: STBA_R	stba	%r12, [%r24 + %r0] 0x4f
	.word 0xdea4c400  ! 3285: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	.word 0xd2be6000  ! 3286: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	.word 0xd2be6000  ! 3287: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	.word 0xd2cfce40  ! 3288: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r9
	.word 0xd8bcc400  ! 3289: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0xd6866000  ! 3290: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r11
	mov	0x3c0, %r23
	.word 0xd6970e60  ! 3292: LDUHA_R	lduha	[%r28, %r0] 0x73, %r11
	mov	0x10, %r24
	.word 0xdaa6e000  ! 3294: STWA_I	stwa	%r13, [%r27 + 0x0000] %asi
	mov	0x7f8, %r23
	.word 0xdabea000  ! 3296: STDA_I	stda	%r13, [%r26 + 0x0000] %asi
	.word 0xdabea000  ! 3297: STDA_I	stda	%r13, [%r26 + 0x0000] %asi
	.word 0xda96a000  ! 3298: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r13
	.word 0xda862000  ! 3299: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r13
	mov	0x20, %r27
	.word 0xdea48400  ! 3301: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xd0f66000  ! 3302: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	.word 0xd0962000  ! 3303: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r8
	.word 0xdab74e40  ! 3304: STHA_R	stha	%r13, [%r29 + %r0] 0x72
	.word 0xdcb78e40  ! 3305: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	mov	0x7e8, %r21
	.word 0x87802072  ! 3307: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4c584a0  ! 3308: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r10
	mov	0x30, %r26
	.word 0xdccfa000  ! 3310: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xdc8fe000  ! 3311: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0x87802020  ! 3312: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r22
	mov	0x68, %r26
	.word 0xd8cd04a0  ! 3315: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r12
	.word 0xde8504a0  ! 3316: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r15
	.word 0xdab76000  ! 3317: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdabdc4a0  ! 3318: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	.word 0xda9f6000  ! 3319: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	mov	0x48, %r24
	mov	0x3c0, %r20
	.word 0xd2bfce60  ! 3322: STDA_R	stda	%r9, [%r31 + %r0] 0x73
	.word 0xdabc0400  ! 3323: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xd2f74e80  ! 3324: STXA_R	stxa	%r9, [%r29 + %r0] 0x74
	.word 0xdac4c400  ! 3325: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r13
	.word 0xd6b76000  ! 3326: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd6876000  ! 3327: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	.word 0xdcbc8400  ! 3328: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0x87802020  ! 3329: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cd6000  ! 3330: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r9
	.word 0xd2dde000  ! 3331: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r9
	.word 0xd4afce80  ! 3332: STBA_R	stba	%r10, [%r31 + %r0] 0x74
	.word 0xdc9de000  ! 3333: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r14
	.word 0x87802020  ! 3334: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd89f0e40  ! 3335: LDDA_R	ldda	[%r28, %r0] 0x72, %r12
	.word 0xd0df2000  ! 3336: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0bf2000  ! 3337: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xd087e000  ! 3338: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0xd88689e0  ! 3339: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r12
	.word 0xdcf7a000  ! 3340: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 3341: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r26
	.word 0xdaa70e60  ! 3343: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	.word 0xd6842000  ! 3344: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r11
	.word 0xd694a000  ! 3345: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r11
	.word 0xdedc8400  ! 3346: LDXA_R	ldxa	[%r18, %r0] 0x20, %r15
	.word 0xded7ce60  ! 3347: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r15
	.word 0xd4f7ce40  ! 3348: STXA_R	stxa	%r10, [%r31 + %r0] 0x72
	.word 0xd28689e0  ! 3349: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r9
	.word 0xdebce000  ! 3350: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 3351: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdadf4e60  ! 3352: LDXA_R	ldxa	[%r29, %r0] 0x73, %r13
	.word 0xd087ce60  ! 3353: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r8
	.word 0xd0a584a0  ! 3354: STWA_R	stwa	%r8, [%r22 + %r0] 0x25
	.word 0x87802020  ! 3355: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a72000  ! 3356: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 3357: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r18
	.word 0x87802074  ! 3359: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2d48400  ! 3360: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	.word 0xd48544a0  ! 3361: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r10
	mov	0x7e8, %r20
	mov	0x7e8, %r23
	.word 0xd4c74e60  ! 3364: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r10
	.word 0x87802020  ! 3365: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r22
	.word 0xd2848400  ! 3367: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r9
	.word 0xd8a40400  ! 3368: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0x87802073  ! 3369: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4866000  ! 3370: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r10
	.word 0xd4a62000  ! 3371: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	.word 0xdcc70e40  ! 3372: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r14
	.word 0xd48e6000  ! 3373: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r10
	.word 0xd2b70e40  ! 3374: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	.word 0xdeaf4e80  ! 3375: STBA_R	stba	%r15, [%r29 + %r0] 0x74
	.word 0xd4be2000  ! 3376: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	.word 0xd4a6e000  ! 3377: STWA_I	stwa	%r10, [%r27 + 0x0000] %asi
	mov	0x10, %r24
	.word 0xd4de2000  ! 3379: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r10
	.word 0xd4866000  ! 3380: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r10
	.word 0xd496e000  ! 3381: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r10
	.word 0xdcf4c400  ! 3382: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	mov	0x40, %r16
	.word 0xdebe2000  ! 3384: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	.word 0xdef6e000  ! 3385: STXA_I	stxa	%r15, [%r27 + 0x0000] %asi
	.word 0xde96a000  ! 3386: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r15
	.word 0xd2a4c400  ! 3387: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	mov	0x60, %r19
	.word 0x87802074  ! 3389: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bda000  ! 3390: STDA_I	stda	%r9, [%r22 + 0x0000] %asi
	.word 0x8780204f  ! 3391: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd294e000  ! 3392: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	mov	0x3e0, %r20
	.word 0xd2f4a000  ! 3394: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	mov	0x3e8, %r20
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2d46000  ! 3397: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	mov	0x40, %r25
	.word 0xd294a000  ! 3399: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r9
	.word 0xd2ace000  ! 3400: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	mov	0x48, %r19
	.word 0xd0df8e80  ! 3402: LDXA_R	ldxa	[%r30, %r0] 0x74, %r8
	.word 0xd084a000  ! 3403: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0b46000  ! 3404: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0xded48400  ! 3405: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	.word 0x87802074  ! 3406: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde97e000  ! 3407: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0xdebfa000  ! 3408: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xdea7a000  ! 3409: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xd4d48400  ! 3410: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	.word 0xd2bfa000  ! 3411: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3412: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ce89e0  ! 3413: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r12
	.word 0xd89f4e40  ! 3414: LDDA_R	ldda	[%r29, %r0] 0x72, %r12
	mov	0x7c8, %r22
	.word 0xdcbd84a0  ! 3416: STDA_R	stda	%r14, [%r22 + %r0] 0x25
	.word 0xd4966000  ! 3417: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r10
	.word 0xd2c48400  ! 3418: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0xd28e6000  ! 3419: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r9
	.word 0xd2c6e000  ! 3420: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r9
	.word 0xdcdd44a0  ! 3421: LDXA_R	ldxa	[%r21, %r0] 0x25, %r14
	.word 0xdaaee000  ! 3422: STBA_I	stba	%r13, [%r27 + 0x0000] %asi
	.word 0xdade2000  ! 3423: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r13
	.word 0xdadea000  ! 3424: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r13
	mov	0x7d8, %r22
	mov	0x68, %r17
	.word 0xdef6c9e0  ! 3427: STXA_R	stxa	%r15, [%r27 + %r0] 0x4f
	.word 0xdcafce60  ! 3428: STBA_R	stba	%r14, [%r31 + %r0] 0x73
	mov	0x7d8, %r22
	.word 0xdede2000  ! 3430: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r15
	.word 0xd6a7ce80  ! 3431: STWA_R	stwa	%r11, [%r31 + %r0] 0x74
	mov	0x3f8, %r20
	.word 0xd4c649e0  ! 3433: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r10
	.word 0xd2a62000  ! 3434: STWA_I	stwa	%r9, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 3435: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdade09e0  ! 3436: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r13
	.word 0x87802020  ! 3437: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ae2000  ! 3438: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	.word 0xdcdf8e60  ! 3439: LDXA_R	ldxa	[%r30, %r0] 0x73, %r14
	.word 0x87802072  ! 3440: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f46000  ! 3441: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 3442: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2b76000  ! 3443: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	mov	0x0, %r18
	.word 0x8780204f  ! 3445: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b70e40  ! 3446: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0xdc8fce80  ! 3447: LDUBA_R	lduba	[%r31, %r0] 0x74, %r14
	.word 0xde94c400  ! 3448: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	.word 0xdacca000  ! 3449: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	.word 0xd2ae49e0  ! 3450: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	.word 0xdab4e000  ! 3451: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	mov	0x10, %r27
	.word 0x87802020  ! 3453: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda87a000  ! 3454: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3455: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeaf0e80  ! 3456: STBA_R	stba	%r15, [%r28 + %r0] 0x74
	.word 0xdebc2000  ! 3457: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xd6df0e60  ! 3458: LDXA_R	ldxa	[%r28, %r0] 0x73, %r11
	mov	0x7c8, %r23
	mov	0x40, %r17
	mov	0x3e8, %r22
	.word 0xdedc2000  ! 3462: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r15
	.word 0xd6b70e40  ! 3463: STHA_R	stha	%r11, [%r28 + %r0] 0x72
	.word 0xdc9e89e0  ! 3464: LDDA_R	ldda	[%r26, %r0] 0x4f, %r14
	.word 0xd2df4e40  ! 3465: LDXA_R	ldxa	[%r29, %r0] 0x72, %r9
	.word 0xd4d70e40  ! 3466: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r10
	.word 0xd48cc400  ! 3467: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	.word 0xd8bfce60  ! 3468: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	mov	0x3f8, %r21
	.word 0xd0cce000  ! 3470: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0942000  ! 3471: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r8
	mov	0x7f0, %r21
	.word 0xd2cdc4a0  ! 3473: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r9
	.word 0x87802025  ! 3474: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc976000  ! 3475: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	.word 0xdcb7e000  ! 3476: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xdad7ce60  ! 3477: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r13
	.word 0xdef72000  ! 3478: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xdef7a000  ! 3479: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	mov	0x7e0, %r21
	mov	0x50, %r19
	.word 0xdeb7e000  ! 3482: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	mov	0x48, %r27
	mov	0x20, %r24
	.word 0xdcdf4e80  ! 3485: LDXA_R	ldxa	[%r29, %r0] 0x74, %r14
	.word 0xdadfce60  ! 3486: LDXA_R	ldxa	[%r31, %r0] 0x73, %r13
	.word 0xdca72000  ! 3487: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xd0d6c9e0  ! 3488: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r8
	.word 0xd8f544a0  ! 3489: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	.word 0xd4a48400  ! 3490: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 3491: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b76000  ! 3492: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd8dc8400  ! 3493: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xdef72000  ! 3494: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xdab74e40  ! 3495: STHA_R	stha	%r13, [%r29 + %r0] 0x72
	.word 0x8780204f  ! 3496: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6cd6000  ! 3497: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r11
	.word 0xdab44400  ! 3498: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0xd8dde000  ! 3499: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r12
	.word 0xd89d6000  ! 3500: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r12
	mov	0x18, %r16
	.word 0xd8856000  ! 3502: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	.word 0x87802074  ! 3503: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd88fe000  ! 3504: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	mov	0x78, %r16
	mov	0x60, %r24
	.word 0xd8c72000  ! 3507: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0x87802020  ! 3508: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 3509: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e0, %r23
	.word 0xd8b7e000  ! 3511: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0xd8af2000  ! 3512: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xd8bf8e80  ! 3513: STDA_R	stda	%r12, [%r30 + %r0] 0x74
	.word 0xd8bc8400  ! 3514: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xdcd48400  ! 3515: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	.word 0xdcdf2000  ! 3516: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcdfe000  ! 3517: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xd8974e80  ! 3518: LDUHA_R	lduha	[%r29, %r0] 0x74, %r12
	.word 0xd4d76000  ! 3519: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0xdaad04a0  ! 3520: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	.word 0x87802074  ! 3521: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2978e40  ! 3522: LDUHA_R	lduha	[%r30, %r0] 0x72, %r9
	.word 0xd48d44a0  ! 3523: LDUBA_R	lduba	[%r21, %r0] 0x25, %r10
	.word 0xdcc78e40  ! 3524: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r14
	.word 0x87802073  ! 3525: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 3526: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8870e60  ! 3527: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r12
	.word 0xdaa48400  ! 3528: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0xd8d74e40  ! 3529: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r12
	mov	0x78, %r25
	.word 0x87802073  ! 3531: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3532: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef7e000  ! 3533: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xdeb72000  ! 3534: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xd4cc4400  ! 3535: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r10
	.word 0xd28f2000  ! 3536: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	.word 0xd6974e40  ! 3537: LDUHA_R	lduha	[%r29, %r0] 0x72, %r11
	.word 0xdedfa000  ! 3538: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x0, %r25
	.word 0x87802073  ! 3540: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbf0e80  ! 3541: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	mov	0x0, %r16
	.word 0x87802020  ! 3543: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r19
	.word 0x8780204f  ! 3545: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc952000  ! 3546: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r14
	mov	0x3d0, %r21
	.word 0xdcccc400  ! 3548: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	mov	0x7e8, %r22
	mov	0x58, %r17
	.word 0xd4f52000  ! 3551: STXA_I	stxa	%r10, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 3552: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0be49e0  ! 3553: STDA_R	stda	%r8, [%r25 + %r0] 0x4f
	.word 0xdaa76000  ! 3554: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xdadcc400  ! 3555: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	mov	0x28, %r18
	mov	0x0, %r26
	.word 0xda8f2000  ! 3558: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xdc8f8e60  ! 3559: LDUBA_R	lduba	[%r30, %r0] 0x73, %r14
	.word 0xd0f76000  ! 3560: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0f7a000  ! 3561: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	mov	0x3e0, %r21
	.word 0xdc9dc4a0  ! 3563: LDDA_R	ldda	[%r23, %r0] 0x25, %r14
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcf7a000  ! 3565: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x10, %r19
	.word 0xdc8f2000  ! 3567: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0xded7ce40  ! 3568: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r15
	.word 0xd4872000  ! 3569: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 3570: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde9f0e80  ! 3571: LDDA_R	ldda	[%r28, %r0] 0x74, %r15
	.word 0x87802020  ! 3572: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c62000  ! 3573: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r12
	mov	0x7e0, %r21
	.word 0xd8de2000  ! 3575: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r12
	.word 0xdcbdc4a0  ! 3576: STDA_R	stda	%r14, [%r23 + %r0] 0x25
	.word 0xdacec9e0  ! 3577: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r13
	.word 0x87802020  ! 3578: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ad44a0  ! 3579: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	.word 0xd897a000  ! 3580: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	mov	0x3c8, %r22
	.word 0xd89d84a0  ! 3582: LDDA_R	ldda	[%r22, %r0] 0x25, %r12
	.word 0xdebf8e80  ! 3583: STDA_R	stda	%r15, [%r30 + %r0] 0x74
	mov	0x40, %r17
	.word 0xd8bf2000  ! 3585: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0xd2974e80  ! 3587: LDUHA_R	lduha	[%r29, %r0] 0x74, %r9
	.word 0xdedf6000  ! 3588: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xd4a609e0  ! 3589: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	.word 0xded76000  ! 3590: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3591: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08f8e60  ! 3592: LDUBA_R	lduba	[%r30, %r0] 0x73, %r8
	.word 0xd88c2000  ! 3593: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	.word 0xded70e40  ! 3594: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r15
	.word 0xd8b689e0  ! 3595: STHA_R	stha	%r12, [%r26 + %r0] 0x4f
	.word 0xdeace000  ! 3596: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 3597: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabc4400  ! 3598: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0x87802020  ! 3599: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c4a000  ! 3600: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r12
	.word 0x87802020  ! 3601: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd897e000  ! 3602: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	.word 0xd8afe000  ! 3603: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd0d74e60  ! 3604: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r8
	.word 0x87802073  ! 3605: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 3606: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r18
	mov	0x40, %r26
	.word 0xded76000  ! 3609: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0xdcf44400  ! 3610: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0x87802020  ! 3611: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r25
	mov	0x40, %r18
	.word 0xdabc2000  ! 3614: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xdacc2000  ! 3615: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	mov	0x68, %r18
	.word 0x87802072  ! 3617: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa46000  ! 3618: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	.word 0xd4ac0400  ! 3619: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xdea46000  ! 3620: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xd4a7ce40  ! 3622: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	.word 0xd6ae09e0  ! 3623: STBA_R	stba	%r11, [%r24 + %r0] 0x4f
	.word 0xd2f42000  ! 3624: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0xdacc8400  ! 3625: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r13
	mov	0x70, %r16
	.word 0xd8cc6000  ! 3627: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r12
	.word 0xd0a6c9e0  ! 3628: STWA_R	stwa	%r8, [%r27 + %r0] 0x4f
	.word 0x87802073  ! 3629: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0976000  ! 3630: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xdcf544a0  ! 3631: STXA_R	stxa	%r14, [%r21 + %r0] 0x25
	.word 0xd4ae49e0  ! 3632: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0xd8ac4400  ! 3633: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xd4afe000  ! 3634: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 3635: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4876000  ! 3636: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4bfe000  ! 3637: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xdec74e40  ! 3638: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r15
	.word 0xd89f0e80  ! 3639: LDDA_R	ldda	[%r28, %r0] 0x74, %r12
	.word 0xd6af6000  ! 3640: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd68fa000  ! 3641: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0xd2f4c400  ! 3642: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xd0d6c9e0  ! 3643: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r8
	.word 0xd49f6000  ! 3644: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0xdcbf8e80  ! 3645: STDA_R	stda	%r14, [%r30 + %r0] 0x74
	.word 0x87802074  ! 3646: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6c74e60  ! 3647: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r11
	mov	0x48, %r24
	.word 0x87802020  ! 3649: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 3650: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b48400  ! 3651: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0x87802072  ! 3652: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b6e000  ! 3653: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	.word 0xd4978e40  ! 3654: LDUHA_R	lduha	[%r30, %r0] 0x72, %r10
	.word 0x87802025  ! 3655: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bce000  ! 3656: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	mov	0x3d8, %r22
	.word 0x87802073  ! 3658: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c0, %r20
	.word 0x87802074  ! 3660: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3661: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f48400  ! 3662: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0x87802025  ! 3663: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 3664: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r18
	.word 0xd28fa000  ! 3666: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	.word 0xd2afe000  ! 3667: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd2cf6000  ! 3668: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	.word 0xd2f72000  ! 3669: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd2976000  ! 3670: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0xd29f2000  ! 3671: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0x87802072  ! 3672: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b7ce60  ! 3673: STHA_R	stha	%r9, [%r31 + %r0] 0x73
	.word 0xda84e000  ! 3674: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r13
	mov	0x7f0, %r21
	mov	0x58, %r25
	.word 0xdaac6000  ! 3677: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	.word 0xd2ce89e0  ! 3678: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r9
	.word 0xdaf42000  ! 3679: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0xdcd504a0  ! 3680: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r14
	.word 0xdea42000  ! 3681: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xd4f70e60  ! 3682: STXA_R	stxa	%r10, [%r28 + %r0] 0x73
	.word 0xde8ca000  ! 3683: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	mov	0x58, %r27
	.word 0xd6bc8400  ! 3685: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xdcf46000  ! 3686: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xd8d4c400  ! 3687: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0xdcb689e0  ! 3688: STHA_R	stha	%r14, [%r26 + %r0] 0x4f
	.word 0xd4b4e000  ! 3689: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xd29d44a0  ! 3690: LDDA_R	ldda	[%r21, %r0] 0x25, %r9
	.word 0xdca4e000  ! 3691: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0xd8a74e40  ! 3692: STWA_R	stwa	%r12, [%r29 + %r0] 0x72
	.word 0xd8cc2000  ! 3693: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r12
	.word 0xd49d84a0  ! 3694: LDDA_R	ldda	[%r22, %r0] 0x25, %r10
	mov	0x58, %r17
	.word 0xd2ac4400  ! 3696: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xd08ce000  ! 3697: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0846000  ! 3698: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0xda9f0e80  ! 3699: LDDA_R	ldda	[%r28, %r0] 0x74, %r13
	.word 0x8780204f  ! 3700: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r23
	mov	0x38, %r18
	.word 0xd4a5a000  ! 3703: STWA_I	stwa	%r10, [%r22 + 0x0000] %asi
	.word 0xd48d2000  ! 3704: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0xd4dde000  ! 3705: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r10
	.word 0xdaf504a0  ! 3706: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	.word 0xd6dd2000  ! 3707: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r11
	.word 0x87802072  ! 3708: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 3709: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c8, %r21
	.word 0xdcf7ce40  ! 3711: STXA_R	stxa	%r14, [%r31 + %r0] 0x72
	mov	0x18, %r18
	mov	0x7c8, %r23
	.word 0xd0af4e60  ! 3714: STBA_R	stba	%r8, [%r29 + %r0] 0x73
	.word 0xde9fe000  ! 3715: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3716: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9d6000  ! 3717: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r15
	mov	0x78, %r19
	.word 0xded52000  ! 3719: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r15
	.word 0xdeb5a000  ! 3720: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	mov	0x30, %r27
	mov	0x38, %r27
	.word 0xde85e000  ! 3723: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r15
	.word 0xdead44a0  ! 3724: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	mov	0x7d0, %r23
	.word 0xdc85a000  ! 3726: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r14
	.word 0xdca52000  ! 3727: STWA_I	stwa	%r14, [%r20 + 0x0000] %asi
	.word 0xdca48400  ! 3728: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0x87802073  ! 3729: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda8f8e80  ! 3730: LDUBA_R	lduba	[%r30, %r0] 0x74, %r13
	mov	0x50, %r16
	.word 0xd0f6e000  ! 3732: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	.word 0xd0866000  ! 3733: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r8
	.word 0xdef5c4a0  ! 3734: STXA_R	stxa	%r15, [%r23 + %r0] 0x25
	.word 0xd4ae6000  ! 3735: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0xd0dc4400  ! 3736: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	.word 0xd2ad04a0  ! 3737: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	.word 0xdac6e000  ! 3738: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r13
	.word 0x87802025  ! 3739: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 3740: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3741: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadf2000  ! 3742: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0xda978e60  ! 3743: LDUHA_R	lduha	[%r30, %r0] 0x73, %r13
	.word 0x87802074  ! 3744: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6bc0400  ! 3745: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xd4a4c400  ! 3746: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0xd29f4e80  ! 3747: LDDA_R	ldda	[%r29, %r0] 0x74, %r9
	.word 0xda872000  ! 3748: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0xd6a7ce40  ! 3749: STWA_R	stwa	%r11, [%r31 + %r0] 0x72
	.word 0x87802025  ! 3750: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb7e000  ! 3751: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0xdcbfe000  ! 3753: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xd4cc0400  ! 3754: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r10
	.word 0x87802020  ! 3755: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3756: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf504a0  ! 3757: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	.word 0xd2f5a000  ! 3758: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	.word 0xd2a56000  ! 3759: STWA_I	stwa	%r9, [%r21 + 0x0000] %asi
	.word 0xd2d52000  ! 3760: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r9
	.word 0x87802073  ! 3761: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2976000  ! 3762: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0xd8c7ce40  ! 3763: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r12
	mov	0x38, %r24
	.word 0xd8d70e40  ! 3765: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r12
	.word 0xda9f8e40  ! 3766: LDDA_R	ldda	[%r30, %r0] 0x72, %r13
	.word 0xdacfa000  ! 3767: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	mov	0x48, %r19
	.word 0xdacf6000  ! 3769: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xd0f7ce60  ! 3770: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	.word 0xd087a000  ! 3771: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0bf2000  ! 3772: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xd0f7e000  ! 3773: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0afa000  ! 3774: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xdca40400  ! 3775: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x7e8, %r20
	.word 0x87802073  ! 3778: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4ccc400  ! 3779: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0xd8848400  ! 3780: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r12
	.word 0xd2b5e000  ! 3781: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0xd0878e80  ! 3783: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r8
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcad2000  ! 3785: STBA_I	stba	%r14, [%r20 + 0x0000] %asi
	.word 0xdaa44400  ! 3786: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0xdaf5a000  ! 3787: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xd4acc400  ! 3788: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0x87802020  ! 3789: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f74e60  ! 3790: STXA_R	stxa	%r11, [%r29 + %r0] 0x73
	.word 0x87802074  ! 3791: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbf2000  ! 3792: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdccc8400  ! 3793: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	.word 0xd4876000  ! 3794: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0x87802072  ! 3795: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4bc2000  ! 3796: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 3797: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a6a000  ! 3798: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x7e0, %r20
	.word 0xd49ea000  ! 3801: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 3802: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4862000  ! 3803: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r10
	.word 0xd8a7ce80  ! 3804: STWA_R	stwa	%r12, [%r31 + %r0] 0x74
	.word 0x87802020  ! 3805: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ad04a0  ! 3806: STBA_R	stba	%r8, [%r20 + %r0] 0x25
	.word 0xda8f8e60  ! 3807: LDUBA_R	lduba	[%r30, %r0] 0x73, %r13
	mov	0x8, %r19
	.word 0xd4c689e0  ! 3809: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r10
	.word 0xd4b72000  ! 3810: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xdaae89e0  ! 3811: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	.word 0xd4a76000  ! 3812: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	mov	0x70, %r19
	mov	0x48, %r25
	mov	0x7d8, %r22
	.word 0xd4af6000  ! 3816: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xdc9cc400  ! 3817: LDDA_R	ldda	[%r19, %r0] 0x20, %r14
	.word 0x87802074  ! 3818: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2cd44a0  ! 3819: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r9
	mov	0x7c8, %r21
	.word 0xda8d84a0  ! 3821: LDUBA_R	lduba	[%r22, %r0] 0x25, %r13
	mov	0x7d8, %r21
	.word 0xd0cf6000  ! 3823: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd0a72000  ! 3824: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0xd0d72000  ! 3826: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 3827: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r19
	.word 0xd0d76000  ! 3829: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xdedf0e40  ! 3830: LDXA_R	ldxa	[%r28, %r0] 0x72, %r15
	.word 0xd2aec9e0  ! 3831: STBA_R	stba	%r9, [%r27 + %r0] 0x4f
	mov	0x10, %r18
	.word 0xd4a72000  ! 3833: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 3834: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc9e09e0  ! 3835: LDDA_R	ldda	[%r24, %r0] 0x4f, %r14
	.word 0x87802074  ! 3836: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd49fe000  ! 3837: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd6974e80  ! 3838: LDUHA_R	lduha	[%r29, %r0] 0x74, %r11
	.word 0xda86c9e0  ! 3839: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r13
	.word 0xda840400  ! 3840: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	.word 0xded7a000  ! 3841: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xd4c74e40  ! 3842: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r10
	.word 0xd2dfa000  ! 3843: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2df6000  ! 3844: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2b76000  ! 3845: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd6d74e80  ! 3846: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r11
	.word 0xd2b7a000  ! 3847: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3848: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaacc400  ! 3849: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0xd8f76000  ! 3850: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8cf6000  ! 3851: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0xd8f7a000  ! 3852: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd897a000  ! 3853: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0xd8af6000  ! 3854: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd0af0e80  ! 3855: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	.word 0xd2a609e0  ! 3856: STWA_R	stwa	%r9, [%r24 + %r0] 0x4f
	.word 0xd2f544a0  ! 3857: STXA_R	stxa	%r9, [%r21 + %r0] 0x25
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2b48400  ! 3859: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xdeaf2000  ! 3860: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xdeb7e000  ! 3861: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	mov	0x68, %r25
	.word 0xdea72000  ! 3863: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xdef7e000  ! 3864: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xd6bc0400  ! 3865: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xdcb44400  ! 3866: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	mov	0x7f8, %r21
	.word 0xd0a7e000  ! 3868: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 3869: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a72000  ! 3870: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xd09f6000  ! 3871: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	mov	0x68, %r18
	mov	0x0, %r18
	mov	0x58, %r27
	.word 0xd6bf4e60  ! 3875: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	.word 0xdedfa000  ! 3876: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xdea7e000  ! 3877: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xdebfa000  ! 3878: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 3879: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3880: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3881: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeafe000  ! 3882: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xde8fe000  ! 3883: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0xdea76000  ! 3884: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0xdedf6000  ! 3886: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xdc87ce80  ! 3887: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r14
	.word 0x87802072  ! 3888: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 3889: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd69ce000  ! 3890: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r11
	.word 0xd6b4a000  ! 3891: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	mov	0x40, %r17
	.word 0xdab40400  ! 3893: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xdc8544a0  ! 3894: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r14
	.word 0xd0bc6000  ! 3895: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	.word 0xd8bf8e40  ! 3896: STDA_R	stda	%r12, [%r30 + %r0] 0x72
	mov	0x8, %r16
	.word 0xd0942000  ! 3898: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r8
	.word 0xd0b46000  ! 3899: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 3900: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0df6000  ! 3901: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	mov	0x0, %r25
	.word 0x87802020  ! 3903: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0dce000  ! 3904: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r8
	.word 0xd0846000  ! 3905: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0x87802025  ! 3906: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd49d04a0  ! 3907: LDDA_R	ldda	[%r20, %r0] 0x25, %r10
	.word 0xdcbec9e0  ! 3908: STDA_R	stda	%r14, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 3909: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r27
	.word 0x8780204f  ! 3911: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d0, %r21
	.word 0xd6df2000  ! 3913: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6c7a000  ! 3914: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6c76000  ! 3915: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	mov	0x3f8, %r22
	.word 0xd4c40400  ! 3917: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	.word 0xd4df6000  ! 3918: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4af2000  ! 3919: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd4c76000  ! 3920: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4b7a000  ! 3921: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xda9d44a0  ! 3922: LDDA_R	ldda	[%r21, %r0] 0x25, %r13
	.word 0xdcb70e40  ! 3923: STHA_R	stha	%r14, [%r28 + %r0] 0x72
	.word 0x87802025  ! 3924: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc8f6000  ! 3925: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0x87802072  ! 3926: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 3927: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf66000  ! 3928: STXA_I	stxa	%r14, [%r25 + 0x0000] %asi
	.word 0xdc8ea000  ! 3929: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r14
	mov	0x7e8, %r21
	mov	0x7f8, %r21
	mov	0x38, %r24
	mov	0x68, %r17
	.word 0xdca62000  ! 3934: STWA_I	stwa	%r14, [%r24 + 0x0000] %asi
	.word 0xdc9e6000  ! 3935: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r14
	mov	0x30, %r19
	.word 0xdccea000  ! 3937: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r14
	.word 0xdc866000  ! 3938: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r14
	.word 0xdcb62000  ! 3939: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	.word 0xded7ce80  ! 3940: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r15
	.word 0xd28ee000  ! 3941: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r9
	.word 0xd2d6e000  ! 3942: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r9
	.word 0xd28e2000  ! 3943: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	.word 0xdabdc4a0  ! 3944: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	.word 0xd2a66000  ! 3945: STWA_I	stwa	%r9, [%r25 + 0x0000] %asi
	.word 0xd6cc0400  ! 3946: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r11
	.word 0xd6d40400  ! 3947: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	.word 0xd8df4e80  ! 3948: LDXA_R	ldxa	[%r29, %r0] 0x74, %r12
	.word 0xdef6c9e0  ! 3949: STXA_R	stxa	%r15, [%r27 + %r0] 0x4f
	mov	0x38, %r16
	mov	0x50, %r19
	.word 0xd6d74e80  ! 3952: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r11
	.word 0xdacf0e60  ! 3953: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r13
	mov	0x28, %r16
	.word 0xd4b7ce80  ! 3955: STHA_R	stha	%r10, [%r31 + %r0] 0x74
	.word 0xdef66000  ! 3956: STXA_I	stxa	%r15, [%r25 + 0x0000] %asi
	.word 0x8780204f  ! 3957: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeac2000  ! 3958: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xd2b584a0  ! 3959: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0x87802074  ! 3960: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a72000  ! 3961: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	mov	0x20, %r25
	.word 0xd4df0e40  ! 3963: LDXA_R	ldxa	[%r28, %r0] 0x72, %r10
	.word 0xdea7a000  ! 3964: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3965: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebd44a0  ! 3966: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	.word 0xd88ca000  ! 3967: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	mov	0x78, %r17
	.word 0xd884a000  ! 3969: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r12
	.word 0xdeb44400  ! 3970: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0x87802073  ! 3971: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdebd84a0  ! 3972: STDA_R	stda	%r15, [%r22 + %r0] 0x25
	mov	0x3e0, %r21
	.word 0xd6f5c4a0  ! 3974: STXA_R	stxa	%r11, [%r23 + %r0] 0x25
	mov	0x3d8, %r21
	.word 0xde9584a0  ! 3976: LDUHA_R	lduha	[%r22, %r0] 0x25, %r15
	.word 0xd09cc400  ! 3977: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	.word 0xd0cd84a0  ! 3978: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r8
	mov	0x50, %r18
	.word 0x87802020  ! 3980: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r25
	mov	0x50, %r25
	.word 0xdcb56000  ! 3983: STHA_I	stha	%r14, [%r21 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdc8de000  ! 3985: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r14
	mov	0x48, %r26
	.word 0xde8584a0  ! 3987: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r15
	.word 0x87802073  ! 3988: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0bca000  ! 3989: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0xd0bc6000  ! 3990: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	.word 0xd6a7ce60  ! 3991: STWA_R	stwa	%r11, [%r31 + %r0] 0x73
	.word 0x87802073  ! 3992: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa78e60  ! 3993: STWA_R	stwa	%r13, [%r30 + %r0] 0x73
	.word 0xdac5a000  ! 3994: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r13
	.word 0xdad5e000  ! 3995: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r13
	.word 0xd6dc4400  ! 3996: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0x87802074  ! 3997: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf4e000  ! 3998: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xdc8c8400  ! 3999: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0xd2cca000  ! 4000: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2d4e000  ! 4001: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0xd2bc0400  ! 4002: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xdea42000  ! 4003: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xde84e000  ! 4004: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	.word 0xd0bf4e80  ! 4005: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	.word 0xd4ac2000  ! 4006: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0xd4b4a000  ! 4007: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 4008: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a70e40  ! 4009: STWA_R	stwa	%r11, [%r28 + %r0] 0x72
	.word 0xd08f8e40  ! 4010: LDUBA_R	lduba	[%r30, %r0] 0x72, %r8
	.word 0xd2c4c400  ! 4011: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0xd2dfe000  ! 4012: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	mov	0x78, %r17
	.word 0xd6b70e60  ! 4014: STHA_R	stha	%r11, [%r28 + %r0] 0x73
	.word 0xd2972000  ! 4015: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	mov	0x50, %r27
	.word 0xd2b76000  ! 4017: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2b76000  ! 4018: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2c76000  ! 4019: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2bf6000  ! 4020: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	mov	0x10, %r26
	.word 0xd2afe000  ! 4022: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	mov	0x48, %r16
	.word 0x87802025  ! 4024: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bd2000  ! 4025: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 4026: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4027: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29fe000  ! 4028: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd2afe000  ! 4029: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd2afa000  ! 4030: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xd2b72000  ! 4031: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xdca4c400  ! 4032: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0x87802074  ! 4033: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4034: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabf8e80  ! 4035: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	.word 0x8780204f  ! 4036: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd89c2000  ! 4037: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	.word 0xd6ddc4a0  ! 4038: LDXA_R	ldxa	[%r23, %r0] 0x25, %r11
	mov	0x7f0, %r23
	mov	0x40, %r27
	.word 0xda978e60  ! 4041: LDUHA_R	lduha	[%r30, %r0] 0x73, %r13
	mov	0x8, %r19
	.word 0x87802020  ! 4043: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r20
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdaaf0e80  ! 4046: STBA_R	stba	%r13, [%r28 + %r0] 0x74
	mov	0x18, %r16
	.word 0x87802072  ! 4048: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 4049: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0bcc400  ! 4050: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0xd6c70e80  ! 4051: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r11
	.word 0xdaac8400  ! 4052: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0xd0d42000  ! 4053: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r8
	.word 0xde84c400  ! 4054: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0xd8a74e60  ! 4055: STWA_R	stwa	%r12, [%r29 + %r0] 0x73
	.word 0x87802072  ! 4056: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebc8400  ! 4057: STDA_R	stda	%r15, [%r18 + %r0] 0x20
	.word 0xd0afce60  ! 4058: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 4059: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf4e000  ! 4060: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	mov	0x3c0, %r22
	mov	0x3d0, %r21
	.word 0xdcb5c4a0  ! 4063: STHA_R	stha	%r14, [%r23 + %r0] 0x25
	mov	0x0, %r26
	.word 0xdab4e000  ! 4065: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 4066: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4067: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd89f8e60  ! 4068: LDDA_R	ldda	[%r30, %r0] 0x73, %r12
	.word 0xd4a7ce60  ! 4069: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	.word 0x87802020  ! 4070: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r17
	.word 0xdef46000  ! 4072: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xd28f8e60  ! 4073: LDUBA_R	lduba	[%r30, %r0] 0x73, %r9
	.word 0xd0df8e80  ! 4074: LDXA_R	ldxa	[%r30, %r0] 0x74, %r8
	.word 0xdeaf8e80  ! 4075: STBA_R	stba	%r15, [%r30 + %r0] 0x74
	mov	0x58, %r24
	.word 0x87802020  ! 4077: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcaf6000  ! 4078: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdcf7e000  ! 4079: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdca7a000  ! 4080: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 4081: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd487ce40  ! 4082: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r10
	.word 0x87802020  ! 4083: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r21
	mov	0x38, %r18
	.word 0xd2866000  ! 4086: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r9
	mov	0x7c0, %r21
	.word 0xd2b62000  ! 4088: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	.word 0xd2b6a000  ! 4089: STHA_I	stha	%r9, [%r26 + 0x0000] %asi
	.word 0xd2ae6000  ! 4090: STBA_I	stba	%r9, [%r25 + 0x0000] %asi
	.word 0xd2cea000  ! 4091: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r9
	.word 0xd6c4c400  ! 4092: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r11
	.word 0xd4970e60  ! 4093: LDUHA_R	lduha	[%r28, %r0] 0x73, %r10
	.word 0xd0bd84a0  ! 4094: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0xd8ce6000  ! 4095: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r12
	.word 0xd6bec9e0  ! 4096: STDA_R	stda	%r11, [%r27 + %r0] 0x4f
	.word 0xdaf66000  ! 4097: STXA_I	stxa	%r13, [%r25 + 0x0000] %asi
	mov	0x30, %r19
	.word 0xd89dc4a0  ! 4099: LDDA_R	ldda	[%r23, %r0] 0x25, %r12
	mov	0x3e8, %r23
	mov	0x3f8, %r21
	.word 0xde86a000  ! 4102: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r15
	mov	0x18, %r16
	.word 0xd6df0e60  ! 4104: LDXA_R	ldxa	[%r28, %r0] 0x73, %r11
	mov	0x10, %r17
	.word 0x87802074  ! 4106: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d0, %r21
	.word 0xd2bda000  ! 4108: STDA_I	stda	%r9, [%r22 + 0x0000] %asi
	.word 0xd8ac0400  ! 4109: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	mov	0x40, %r26
	mov	0x30, %r25
	.word 0xdc95a000  ! 4112: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r14
	.word 0xd4940400  ! 4113: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	mov	0x50, %r25
	.word 0x87802020  ! 4115: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab40400  ! 4116: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	mov	0x3d0, %r21
	.word 0x87802025  ! 4118: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a66000  ! 4119: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	.word 0xdaacc400  ! 4120: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0xdcbee000  ! 4121: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	.word 0xd2b70e60  ! 4122: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	.word 0xdad6e000  ! 4123: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r13
	.word 0xdac62000  ! 4124: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r13
	.word 0xdebdc4a0  ! 4125: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	.word 0xde9e6000  ! 4126: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r15
	.word 0xdebea000  ! 4127: STDA_I	stda	%r15, [%r26 + 0x0000] %asi
	.word 0xd88cc400  ! 4128: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	.word 0xd0f6e000  ! 4129: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	mov	0x78, %r16
	.word 0xd4ac0400  ! 4131: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xd4966000  ! 4132: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r10
	.word 0xd48e2000  ! 4133: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r10
	.word 0xd49ee000  ! 4134: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r10
	.word 0xd28c4400  ! 4135: LDUBA_R	lduba	[%r17, %r0] 0x20, %r9
	.word 0xd6af0e60  ! 4136: STBA_R	stba	%r11, [%r28 + %r0] 0x73
	.word 0xd29f0e40  ! 4137: LDDA_R	ldda	[%r28, %r0] 0x72, %r9
	mov	0x48, %r25
	.word 0xdaa70e60  ! 4139: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	.word 0xd4aee000  ! 4140: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	.word 0xd0f48400  ! 4141: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xdcb6a000  ! 4142: STHA_I	stha	%r14, [%r26 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0xd8978e60  ! 4144: LDUHA_R	lduha	[%r30, %r0] 0x73, %r12
	.word 0xd2cc0400  ! 4145: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r9
	.word 0xdca609e0  ! 4146: STWA_R	stwa	%r14, [%r24 + %r0] 0x4f
	mov	0x78, %r26
	.word 0xd2aea000  ! 4148: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0x87802072  ! 4150: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2d5a000  ! 4151: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r9
	.word 0xd2b52000  ! 4152: STHA_I	stha	%r9, [%r20 + 0x0000] %asi
	.word 0xdca7ce40  ! 4153: STWA_R	stwa	%r14, [%r31 + %r0] 0x72
	.word 0xd4940400  ! 4154: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	.word 0xd0dd2000  ! 4155: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0xd2af8e80  ! 4156: STBA_R	stba	%r9, [%r30 + %r0] 0x74
	.word 0xd4cf4e40  ! 4157: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r10
	ta	T_CHANGE_HPRIV	! macro
	mov	0x3f0, %r20
	mov	0x68, %r25
	.word 0xd4bd6000  ! 4161: STDA_I	stda	%r10, [%r21 + 0x0000] %asi
	.word 0x87802025  ! 4162: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b74e40  ! 4163: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	mov	0x7e8, %r20
	mov	0x3e8, %r21
	mov	0x7f0, %r21
	mov	0x58, %r25
	.word 0xdac52000  ! 4168: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r13
	mov	0x7e8, %r22
	mov	0x40, %r25
	.word 0xd2d78e60  ! 4171: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r9
	mov	0x3c8, %r20
	.word 0xd6a4c400  ! 4173: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	mov	0x50, %r25
	.word 0xd4c48400  ! 4175: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r10
	.word 0xd6de09e0  ! 4176: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r11
	.word 0xd2d78e60  ! 4177: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r9
	.word 0xd0b649e0  ! 4178: STHA_R	stha	%r8, [%r25 + %r0] 0x4f
	mov	0x70, %r18
	.word 0xd2bd6000  ! 4180: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	mov	0x60, %r26
	.word 0x87802073  ! 4182: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2a6e000  ! 4183: STWA_I	stwa	%r9, [%r27 + 0x0000] %asi
	.word 0xd2c44400  ! 4184: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	.word 0xdc8649e0  ! 4185: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r14
	.word 0xd4d62000  ! 4186: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r10
	mov	0x7e8, %r23
	mov	0x40, %r27
	mov	0x7d0, %r21
	.word 0x8780204f  ! 4190: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b7e000  ! 4191: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	mov	0x10, %r24
	mov	0x3d8, %r22
	mov	0x18, %r17
	.word 0xd0a78e60  ! 4195: STWA_R	stwa	%r8, [%r30 + %r0] 0x73
	.word 0xd2bf8e40  ! 4196: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	.word 0xdcac8400  ! 4197: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0x87802073  ! 4198: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde9c2000  ! 4199: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xded46000  ! 4200: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xde946000  ! 4202: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r15
	.word 0xdea46000  ! 4203: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xde842000  ! 4204: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	.word 0xd0ccc400  ! 4205: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	.word 0x87802073  ! 4206: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r18
	.word 0xdcbf4e60  ! 4208: STDA_R	stda	%r14, [%r29 + %r0] 0x73
	mov	0x30, %r27
	mov	0x58, %r19
	.word 0xd2cf0e40  ! 4211: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r9
	.word 0xd4b6a000  ! 4212: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	.word 0xd4f66000  ! 4213: STXA_I	stxa	%r10, [%r25 + 0x0000] %asi
	.word 0xd4cea000  ! 4214: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r10
	mov	0x3f0, %r20
	mov	0x28, %r27
	.word 0xd4dea000  ! 4217: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	mov	0x8, %r24
	.word 0xd8870e60  ! 4219: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r12
	.word 0xdec4c400  ! 4220: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	.word 0xd086a000  ! 4221: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r8
	mov	0x3e8, %r23
	.word 0xdac4c400  ! 4223: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r13
	mov	0x78, %r17
	.word 0xd4dee000  ! 4225: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r10
	.word 0xd4dee000  ! 4226: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r10
	.word 0xd4f5c4a0  ! 4227: STXA_R	stxa	%r10, [%r23 + %r0] 0x25
	.word 0xdebc0400  ! 4228: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0xd6aee000  ! 4229: STBA_I	stba	%r11, [%r27 + 0x0000] %asi
	.word 0xdcc7ce40  ! 4230: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r14
	mov	0x68, %r18
	.word 0xda966000  ! 4232: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r13
	.word 0xd4ae89e0  ! 4233: STBA_R	stba	%r10, [%r26 + %r0] 0x4f
	.word 0xdac48400  ! 4234: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	.word 0xd09ec9e0  ! 4235: LDDA_R	ldda	[%r27, %r0] 0x4f, %r8
	.word 0xd0b48400  ! 4236: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xd0cd84a0  ! 4237: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r8
	.word 0x87802073  ! 4238: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r19
	.word 0xd0b4a000  ! 4240: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 4241: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08c6000  ! 4242: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0xdeafce40  ! 4243: STBA_R	stba	%r15, [%r31 + %r0] 0x72
	mov	0x3d8, %r23
	.word 0x87802073  ! 4245: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8d78e60  ! 4246: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r12
	.word 0x87802073  ! 4247: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdecda000  ! 4248: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r15
	mov	0x30, %r25
	.word 0xd0bd84a0  ! 4250: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0xdc8e09e0  ! 4251: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r14
	.word 0xd4a52000  ! 4252: STWA_I	stwa	%r10, [%r20 + 0x0000] %asi
	mov	0x18, %r26
	.word 0x87802020  ! 4254: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r23
	.word 0xd4ae6000  ! 4256: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xd48e2000  ! 4258: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r10
	.word 0xd4aea000  ! 4259: STBA_I	stba	%r10, [%r26 + 0x0000] %asi
	.word 0xd8bc4400  ! 4260: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xda9e6000  ! 4261: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r13
	.word 0xdaf4c400  ! 4262: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0x87802072  ! 4263: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8970e80  ! 4264: LDUHA_R	lduha	[%r28, %r0] 0x74, %r12
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x48, %r17
	.word 0xdabf4e80  ! 4267: STDA_R	stda	%r13, [%r29 + %r0] 0x74
	.word 0xd4ad6000  ! 4268: STBA_I	stba	%r10, [%r21 + 0x0000] %asi
	.word 0xd4f56000  ! 4269: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	mov	0x40, %r19
	.word 0x87802074  ! 4271: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a7a000  ! 4272: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 4273: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd494a000  ! 4274: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r10
	.word 0xd0df0e60  ! 4275: LDXA_R	ldxa	[%r28, %r0] 0x73, %r8
	.word 0x8780204f  ! 4276: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcae09e0  ! 4277: STBA_R	stba	%r14, [%r24 + %r0] 0x4f
	.word 0xd4f6a000  ! 4278: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	.word 0xd4bee000  ! 4279: STDA_I	stda	%r10, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 4280: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cfa000  ! 4281: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0xd4f4c400  ! 4282: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd4f4c400  ! 4283: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0x87802072  ! 4284: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcdec9e0  ! 4285: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r14
	mov	0x28, %r25
	mov	0x18, %r16
	mov	0x10, %r26
	.word 0xd8ac0400  ! 4289: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xdcc46000  ! 4290: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r14
	.word 0xdca42000  ! 4291: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xdcd46000  ! 4292: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	.word 0xdab584a0  ! 4293: STHA_R	stha	%r13, [%r22 + %r0] 0x25
	.word 0xdab42000  ! 4294: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	mov	0x7e0, %r21
	.word 0xdadc6000  ! 4296: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xdc8544a0  ! 4297: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r14
	.word 0xd2ac2000  ! 4298: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	mov	0x60, %r18
	.word 0xdebf4e80  ! 4300: STDA_R	stda	%r15, [%r29 + %r0] 0x74
	.word 0xdab74e80  ! 4301: STHA_R	stha	%r13, [%r29 + %r0] 0x74
	.word 0xd0f4e000  ! 4302: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 4303: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bf4e40  ! 4304: STDA_R	stda	%r12, [%r29 + %r0] 0x72
	mov	0x3c0, %r21
	.word 0xd2870e40  ! 4306: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r9
	.word 0xda944400  ! 4307: LDUHA_R	lduha	[%r17, %r0] 0x20, %r13
	.word 0xdef7a000  ! 4308: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	mov	0x70, %r17
	.word 0x87802073  ! 4310: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb52000  ! 4311: STHA_I	stha	%r15, [%r20 + 0x0000] %asi
	.word 0xd8bfce80  ! 4312: STDA_R	stda	%r12, [%r31 + %r0] 0x74
	.word 0x87802072  ! 4313: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r19
	.word 0xdcdca000  ! 4315: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xde840400  ! 4316: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	.word 0xd2a42000  ! 4317: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	.word 0xd2a44400  ! 4318: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xd0b74e60  ! 4319: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	.word 0xd6b4a000  ! 4320: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 4321: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r17
	mov	0x0, %r18
	mov	0x60, %r24
	.word 0x87802074  ! 4325: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6ac6000  ! 4326: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xd0b48400  ! 4327: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0x87802020  ! 4328: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda87ce80  ! 4329: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r13
	mov	0x3d0, %r22
	.word 0xdaf6c9e0  ! 4331: STXA_R	stxa	%r13, [%r27 + %r0] 0x4f
	mov	0x3f0, %r23
	.word 0xda8544a0  ! 4333: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r13
	mov	0x3c0, %r23
	.word 0xdccee000  ! 4335: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r14
	.word 0xdcae6000  ! 4336: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdcb6e000  ! 4338: STHA_I	stha	%r14, [%r27 + 0x0000] %asi
	mov	0x60, %r25
	mov	0x8, %r26
	mov	0x3f0, %r23
	.word 0xdcbc4400  ! 4342: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0x87802074  ! 4343: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c0, %r21
	.word 0xdaa78e40  ! 4345: STWA_R	stwa	%r13, [%r30 + %r0] 0x72
	.word 0x87802073  ! 4346: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdadf4e80  ! 4347: LDXA_R	ldxa	[%r29, %r0] 0x74, %r13
	.word 0xd6afa000  ! 4348: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6df2000  ! 4349: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	mov	0x20, %r24
	.word 0xd6af6000  ! 4351: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x10, %r19
	.word 0xdcbd04a0  ! 4353: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	.word 0xd8c48400  ! 4354: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	.word 0xd8f76000  ! 4355: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd0974e40  ! 4356: LDUHA_R	lduha	[%r29, %r0] 0x72, %r8
	.word 0xdaaf6000  ! 4357: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xda8f2000  ! 4358: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xd6a70e40  ! 4359: STWA_R	stwa	%r11, [%r28 + %r0] 0x72
	.word 0xd2bf0e40  ! 4360: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	.word 0xdcbfa000  ! 4361: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 4362: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4363: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r24
	.word 0xdcc4c400  ! 4365: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	mov	0x7e0, %r23
	.word 0x87802020  ! 4367: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0acc400  ! 4368: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0x87802072  ! 4369: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 4370: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 4371: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4cd2000  ! 4372: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r10
	.word 0xd08ec9e0  ! 4373: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r8
	.word 0xda948400  ! 4374: LDUHA_R	lduha	[%r18, %r0] 0x20, %r13
	.word 0xd0a56000  ! 4375: STWA_I	stwa	%r8, [%r21 + 0x0000] %asi
	mov	0x7f0, %r23
	mov	0x7d0, %r20
	mov	0x7f0, %r22
	mov	0x20, %r24
	.word 0xd8b44400  ! 4380: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 4381: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6bc2000  ! 4382: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 4383: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6cfe000  ! 4384: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 4385: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9f8e80  ! 4386: LDDA_R	ldda	[%r30, %r0] 0x74, %r13
	.word 0xd2f46000  ! 4387: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xdc8e49e0  ! 4388: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r14
	.word 0x87802020  ! 4389: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r21
	mov	0x50, %r26
	.word 0xd49ec9e0  ! 4392: LDDA_R	ldda	[%r27, %r0] 0x4f, %r10
	.word 0xdaafe000  ! 4393: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xdaafa000  ! 4394: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 4395: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaa56000  ! 4396: STWA_I	stwa	%r13, [%r21 + 0x0000] %asi
	.word 0x87802072  ! 4397: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4398: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c7ce80  ! 4399: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r10
	.word 0xd69c8400  ! 4400: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	.word 0xd8ac4400  ! 4401: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	mov	0x50, %r18
	.word 0x87802074  ! 4403: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa4e000  ! 4404: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0xdab4a000  ! 4405: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0xdaaca000  ! 4406: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 4407: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 4408: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdacf2000  ! 4409: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xda978e80  ! 4410: LDUHA_R	lduha	[%r30, %r0] 0x74, %r13
	.word 0xd0a649e0  ! 4411: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	mov	0x18, %r17
	.word 0xdca76000  ! 4413: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcb76000  ! 4414: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xda9c8400  ! 4415: LDDA_R	ldda	[%r18, %r0] 0x20, %r13
	mov	0x7c0, %r21
	.word 0xd48f2000  ! 4417: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd08c8400  ! 4418: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0xd6a7e000  ! 4419: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 4420: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x0, %r26
	.word 0xda8c0400  ! 4422: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	.word 0x87802025  ! 4423: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4424: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4425: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaade000  ! 4426: STBA_I	stba	%r13, [%r23 + 0x0000] %asi
	mov	0x40, %r17
	.word 0xdac5e000  ! 4428: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r13
	.word 0xdaf5e000  ! 4429: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 4430: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabc6000  ! 4431: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 4432: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 4433: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r26
	.word 0xdad5e000  ! 4435: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r13
	mov	0x0, %r19
	.word 0x87802020  ! 4437: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf76000  ! 4438: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdabfa000  ! 4439: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xd8b70e40  ! 4440: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0xda840400  ! 4441: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	.word 0x87802020  ! 4442: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 4443: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r24
	.word 0xdcf5c4a0  ! 4445: STXA_R	stxa	%r14, [%r23 + %r0] 0x25
	.word 0x8780204f  ! 4446: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r24
	.word 0xd09da000  ! 4448: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r8
	.word 0x87802025  ! 4449: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0ae6000  ! 4450: STBA_I	stba	%r8, [%r25 + 0x0000] %asi
	.word 0xd8d584a0  ! 4451: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r12
	.word 0xd89c0400  ! 4452: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	.word 0x87802073  ! 4453: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda8d84a0  ! 4454: LDUBA_R	lduba	[%r22, %r0] 0x25, %r13
	.word 0x87802073  ! 4455: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 4456: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6d78e40  ! 4457: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r11
	.word 0x87802073  ! 4458: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f8, %r23
	.word 0xd2a48400  ! 4460: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0xd0dec9e0  ! 4461: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r8
	.word 0x87802072  ! 4462: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6866000  ! 4463: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r11
	.word 0x87802072  ! 4464: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f0, %r23
	.word 0xd6c74e80  ! 4466: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r11
	.word 0xdeac6000  ! 4467: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xde9ce000  ! 4468: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	mov	0x3c8, %r21
	mov	0x68, %r17
	.word 0xdeb4e000  ! 4471: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0xd2bc0400  ! 4472: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	mov	0x38, %r18
	.word 0xd2c70e40  ! 4474: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r9
	.word 0xd0afce60  ! 4475: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	.word 0xda94e000  ! 4476: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r13
	.word 0xda946000  ! 4477: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	.word 0xdadc6000  ! 4478: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xda878e40  ! 4479: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r13
	.word 0xd2c42000  ! 4480: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	.word 0x87802020  ! 4481: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28ca000  ! 4482: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	mov	0x38, %r16
	mov	0x38, %r24
	.word 0xd0cf8e60  ! 4485: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r8
	.word 0x87802020  ! 4486: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadc4400  ! 4487: LDXA_R	ldxa	[%r17, %r0] 0x20, %r13
	mov	0x3d8, %r22
	.word 0xdacd44a0  ! 4489: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r13
	.word 0xd6876000  ! 4490: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	.word 0xd8a40400  ! 4491: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0xdccf2000  ! 4492: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xdeb78e60  ! 4493: STHA_R	stha	%r15, [%r30 + %r0] 0x73
	.word 0xd2dfa000  ! 4494: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xdcbc8400  ! 4495: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xde8dc4a0  ! 4496: LDUBA_R	lduba	[%r23, %r0] 0x25, %r15
	.word 0xdc9f6000  ! 4497: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	mov	0x40, %r26
	.word 0x8780204f  ! 4499: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd084c400  ! 4500: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r8
	mov	0x48, %r16
	mov	0x38, %r18
	.word 0xd08ea000  ! 4503: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r8
	.word 0xd09ee000  ! 4504: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r8
	mov	0x7d8, %r22
	.word 0xdef74e60  ! 4506: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	mov	0x20, %r26
	.word 0xdab62000  ! 4508: STHA_I	stha	%r13, [%r24 + 0x0000] %asi
	mov	0x3f0, %r21
	.word 0xd69c0400  ! 4510: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	.word 0xd6f66000  ! 4511: STXA_I	stxa	%r11, [%r25 + 0x0000] %asi
	.word 0xd6a6a000  ! 4512: STWA_I	stwa	%r11, [%r26 + 0x0000] %asi
	.word 0xd6b6e000  ! 4513: STHA_I	stha	%r11, [%r27 + 0x0000] %asi
	.word 0xd6de2000  ! 4514: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r11
	mov	0x0, %r17
	.word 0xd49504a0  ! 4516: LDUHA_R	lduha	[%r20, %r0] 0x25, %r10
	.word 0xd2de6000  ! 4517: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r9
	.word 0x87802025  ! 4518: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2d7a000  ! 4519: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0xd28fe000  ! 4520: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	.word 0xd2dfe000  ! 4521: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	mov	0x3f8, %r22
	.word 0xd4c48400  ! 4523: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r10
	mov	0x3d8, %r22
	mov	0x7e0, %r22
	mov	0x68, %r27
	.word 0xd8a5c4a0  ! 4527: STWA_R	stwa	%r12, [%r23 + %r0] 0x25
	.word 0x87802073  ! 4528: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4bca000  ! 4529: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0xd4cca000  ! 4530: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r10
	mov	0x7f0, %r22
	.word 0xd49c6000  ! 4532: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0xdede89e0  ! 4533: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r15
	mov	0x10, %r18
	.word 0xd6d74e60  ! 4535: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r11
	.word 0xde844400  ! 4536: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	.word 0xdcf42000  ! 4537: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0xd2a70e60  ! 4538: STWA_R	stwa	%r9, [%r28 + %r0] 0x73
	.word 0xdaafce40  ! 4539: STBA_R	stba	%r13, [%r31 + %r0] 0x72
	.word 0xd2bce000  ! 4540: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xd2c42000  ! 4541: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	.word 0xd2c4e000  ! 4542: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xd6b609e0  ! 4543: STHA_R	stha	%r11, [%r24 + %r0] 0x4f
	.word 0xd0c42000  ! 4544: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r8
	mov	0x58, %r27
	.word 0xd48c0400  ! 4546: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	.word 0x87802020  ! 4547: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a7a000  ! 4548: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xdcf7ce60  ! 4549: STXA_R	stxa	%r14, [%r31 + %r0] 0x73
	.word 0xd4a40400  ! 4550: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	mov	0x0, %r26
	.word 0xd6cfce40  ! 4552: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r11
	.word 0xd68fe000  ! 4553: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xd6bf6000  ! 4554: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd68689e0  ! 4555: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r11
	.word 0xdacfce80  ! 4556: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r13
	.word 0x87802074  ! 4557: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4bf0e40  ! 4558: STDA_R	stda	%r10, [%r28 + %r0] 0x72
	.word 0xd4cf2000  ! 4559: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	mov	0x8, %r26
	.word 0xd2f7ce80  ! 4561: STXA_R	stxa	%r9, [%r31 + %r0] 0x74
	.word 0x87802073  ! 4562: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda8584a0  ! 4563: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r13
	.word 0xdacc8400  ! 4564: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r13
	.word 0xd6b66000  ! 4565: STHA_I	stha	%r11, [%r25 + 0x0000] %asi
	.word 0xd6c66000  ! 4566: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r11
	.word 0xd8cfce80  ! 4567: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r12
	.word 0xd8b70e60  ! 4568: STHA_R	stha	%r12, [%r28 + %r0] 0x73
	mov	0x18, %r24
	.word 0x8780204f  ! 4570: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 4571: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4572: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4573: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4afce80  ! 4574: STBA_R	stba	%r10, [%r31 + %r0] 0x74
	.word 0xd8f7a000  ! 4575: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xdea7ce60  ! 4576: STWA_R	stwa	%r15, [%r31 + %r0] 0x73
	.word 0xd0dd04a0  ! 4577: LDXA_R	ldxa	[%r20, %r0] 0x25, %r8
	.word 0x87802074  ! 4578: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6a7ce40  ! 4579: STWA_R	stwa	%r11, [%r31 + %r0] 0x72
	.word 0xd8c70e60  ! 4580: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r12
	mov	0x3f0, %r20
	.word 0x87802073  ! 4582: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r17
	.word 0x87802072  ! 4584: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbfce40  ! 4585: STDA_R	stda	%r14, [%r31 + %r0] 0x72
	.word 0x87802025  ! 4586: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r24
	.word 0xdccf4e40  ! 4588: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r14
	mov	0x7d0, %r21
	.word 0x87802020  ! 4590: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9c0400  ! 4591: LDDA_R	ldda	[%r16, %r0] 0x20, %r14
	.word 0xde946000  ! 4592: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r15
	.word 0xd0f4c400  ! 4593: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	mov	0x7f8, %r22
	mov	0x70, %r26
	.word 0x87802020  ! 4596: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4597: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdad52000  ! 4598: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r13
	.word 0xdaa70e80  ! 4599: STWA_R	stwa	%r13, [%r28 + %r0] 0x74
	.word 0xd4dd2000  ! 4600: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r10
	.word 0x87802020  ! 4601: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r19
	mov	0x28, %r18
	mov	0x10, %r24
	.word 0xd28f0e80  ! 4605: LDUBA_R	lduba	[%r28, %r0] 0x74, %r9
	.word 0xd4afce60  ! 4606: STBA_R	stba	%r10, [%r31 + %r0] 0x73
	.word 0x87802074  ! 4607: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdac74e40  ! 4608: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r13
	.word 0xd296e000  ! 4609: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r9
	.word 0xd2d6e000  ! 4610: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r9
	mov	0x20, %r26
	.word 0xd296e000  ! 4612: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r9
	mov	0x7f0, %r23
	mov	0x10, %r18
	.word 0xdcbc0400  ! 4615: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0xd4dea000  ! 4616: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	.word 0xdac584a0  ! 4617: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r13
	.word 0xdabfce40  ! 4618: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	mov	0x50, %r18
	.word 0xd4f689e0  ! 4620: STXA_R	stxa	%r10, [%r26 + %r0] 0x4f
	.word 0xdabec9e0  ! 4621: STDA_R	stda	%r13, [%r27 + %r0] 0x4f
	.word 0xdc940400  ! 4622: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0xda966000  ! 4623: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 4624: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda84a000  ! 4625: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	.word 0xd0a649e0  ! 4626: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	mov	0x3d8, %r22
	.word 0xd0ae49e0  ! 4628: STBA_R	stba	%r8, [%r25 + %r0] 0x4f
	.word 0xd8dc0400  ! 4629: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0x87802025  ! 4630: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0d72000  ! 4631: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	mov	0x8, %r19
	mov	0x3d0, %r20
	.word 0xd6bd04a0  ! 4634: STDA_R	stda	%r11, [%r20 + %r0] 0x25
	.word 0xd4af6000  ! 4635: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd0b48400  ! 4636: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0x87802072  ! 4637: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8d74e40  ! 4638: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r12
	.word 0x87802072  ! 4639: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc862000  ! 4640: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r14
	.word 0x87802072  ! 4641: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4642: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0df0e40  ! 4643: LDXA_R	ldxa	[%r28, %r0] 0x72, %r8
	.word 0xdacee000  ! 4644: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r13
	.word 0xdcb584a0  ! 4645: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	.word 0x87802020  ! 4646: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bfe000  ! 4647: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	mov	0x50, %r17
	.word 0xd8bfa000  ! 4649: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	mov	0x10, %r27
	.word 0xd8a76000  ! 4651: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8876000  ! 4652: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4653: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r18
	.word 0x87802020  ! 4655: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4656: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8dc2000  ! 4657: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0xd0c7ce60  ! 4658: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r8
	.word 0xd2f78e60  ! 4659: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0xd4f4c400  ! 4660: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xda9f8e40  ! 4661: LDDA_R	ldda	[%r30, %r0] 0x72, %r13
	.word 0x8780204f  ! 4662: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4663: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4664: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r25
	mov	0x70, %r27
	.word 0xdc874e60  ! 4667: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r14
	.word 0xd08fce60  ! 4668: LDUBA_R	lduba	[%r31, %r0] 0x73, %r8
	mov	0x70, %r16
	mov	0x3f0, %r23
	.word 0x87802020  ! 4671: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f7ce40  ! 4672: STXA_R	stxa	%r10, [%r31 + %r0] 0x72
	.word 0xd6ce2000  ! 4673: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	mov	0x38, %r24
	.word 0x87802020  ! 4675: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdacf4e40  ! 4676: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r13
	.word 0xd6c7e000  ! 4677: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	mov	0x7d8, %r20
	.word 0xd6976000  ! 4679: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	.word 0xd6af2000  ! 4680: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xde8689e0  ! 4681: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r15
	.word 0x87802074  ! 4682: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda97a000  ! 4683: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xdadf6000  ! 4684: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0x87802073  ! 4685: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdab76000  ! 4686: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xd89f0e40  ! 4687: LDDA_R	ldda	[%r28, %r0] 0x72, %r12
	.word 0xd4df2000  ! 4688: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	mov	0x3e0, %r22
	.word 0xdad6c9e0  ! 4690: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r13
	mov	0x0, %r17
	.word 0x87802020  ! 4692: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d72000  ! 4693: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xd2f7a000  ! 4694: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	mov	0x40, %r19
	mov	0x10, %r19
	.word 0xd8844400  ! 4697: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r12
	.word 0x87802072  ! 4698: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b7e000  ! 4699: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0xd0ad44a0  ! 4700: STBA_R	stba	%r8, [%r21 + %r0] 0x25
	.word 0xd09c0400  ! 4701: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	.word 0xd4a4c400  ! 4702: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0xdc8fce60  ! 4703: LDUBA_R	lduba	[%r31, %r0] 0x73, %r14
	.word 0xd0d78e60  ! 4704: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r8
	.word 0x87802020  ! 4705: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f62000  ! 4706: STXA_I	stxa	%r11, [%r24 + 0x0000] %asi
	.word 0xdaa74e60  ! 4707: STWA_R	stwa	%r13, [%r29 + %r0] 0x73
	.word 0xd6b6e000  ! 4708: STHA_I	stha	%r11, [%r27 + 0x0000] %asi
	.word 0xd6ae2000  ! 4709: STBA_I	stba	%r11, [%r24 + 0x0000] %asi
	.word 0xd6aea000  ! 4710: STBA_I	stba	%r11, [%r26 + 0x0000] %asi
	mov	0x8, %r24
	.word 0xd6d609e0  ! 4712: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r11
	.word 0x87802020  ! 4713: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 4714: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca46000  ! 4715: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xd6848400  ! 4716: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	.word 0x87802072  ! 4717: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c8, %r20
	.word 0x87802073  ! 4719: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r26
	.word 0xd2a56000  ! 4721: STWA_I	stwa	%r9, [%r21 + 0x0000] %asi
	.word 0xd28de000  ! 4722: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r9
	.word 0xd8a74e40  ! 4723: STWA_R	stwa	%r12, [%r29 + %r0] 0x72
	.word 0x87802020  ! 4724: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48d44a0  ! 4725: LDUBA_R	lduba	[%r21, %r0] 0x25, %r10
	mov	0x3d8, %r23
	.word 0x87802073  ! 4727: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb76000  ! 4728: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 4729: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 4730: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeafa000  ! 4731: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xd6b6c9e0  ! 4732: STHA_R	stha	%r11, [%r27 + %r0] 0x4f
	.word 0xd8af2000  ! 4733: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xdea48400  ! 4734: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xdad48400  ! 4735: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0xdadfa000  ! 4736: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	mov	0x3d8, %r21
	.word 0xdaf72000  ! 4738: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xd0f70e80  ! 4739: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0xd48f6000  ! 4740: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xd0bd84a0  ! 4741: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0xda97a000  ! 4742: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xd8b4c400  ! 4743: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0x87802072  ! 4744: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef78e60  ! 4745: STXA_R	stxa	%r15, [%r30 + %r0] 0x73
	.word 0xdeb70e40  ! 4746: STHA_R	stha	%r15, [%r28 + %r0] 0x72
	mov	0x10, %r27
	.word 0xdaa70e80  ! 4748: STWA_R	stwa	%r13, [%r28 + %r0] 0x74
	.word 0xd6c78e80  ! 4749: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r11
	.word 0xde9fce60  ! 4750: LDDA_R	ldda	[%r31, %r0] 0x73, %r15
	.word 0xd0f70e80  ! 4751: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0xd2bdc4a0  ! 4752: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	.word 0xd2a74e60  ! 4753: STWA_R	stwa	%r9, [%r29 + %r0] 0x73
	.word 0xd0afa000  ! 4754: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xdea44400  ! 4755: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xd4a72000  ! 4756: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xded7ce60  ! 4757: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r15
	mov	0x40, %r16
	.word 0xda878e60  ! 4759: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r13
	mov	0x0, %r25
	.word 0xdea76000  ! 4761: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xdebd84a0  ! 4762: STDA_R	stda	%r15, [%r22 + %r0] 0x25
	mov	0x8, %r18
	.word 0xd2df2000  ! 4764: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2b76000  ! 4765: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2a7a000  ! 4766: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xd29f2000  ! 4767: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd2a72000  ! 4768: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0xdaf70e60  ! 4769: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	.word 0xdcb649e0  ! 4770: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	mov	0x7e0, %r21
	mov	0x30, %r26
	.word 0x87802025  ! 4773: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0df8e80  ! 4774: LDXA_R	ldxa	[%r30, %r0] 0x74, %r8
	mov	0x10, %r18
	.word 0x87802073  ! 4776: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b7a000  ! 4777: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd4b76000  ! 4778: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xde8f8e80  ! 4779: LDUBA_R	lduba	[%r30, %r0] 0x74, %r15
	.word 0xd6f7a000  ! 4780: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6872000  ! 4781: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6afe000  ! 4782: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd68fe000  ! 4783: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xd0ae09e0  ! 4784: STBA_R	stba	%r8, [%r24 + %r0] 0x4f
	mov	0x0, %r17
	.word 0xdca7e000  ! 4786: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdc87a000  ! 4787: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0x87802073  ! 4788: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r19
	mov	0x68, %r19
	.word 0xdeafce60  ! 4791: STBA_R	stba	%r15, [%r31 + %r0] 0x73
	.word 0xdecee000  ! 4792: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r15
	.word 0xdebe2000  ! 4793: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	.word 0xde866000  ! 4794: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r15
	.word 0xdea62000  ! 4795: STWA_I	stwa	%r15, [%r24 + 0x0000] %asi
	.word 0xdeb62000  ! 4796: STHA_I	stha	%r15, [%r24 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xd8aec9e0  ! 4798: STBA_R	stba	%r12, [%r27 + %r0] 0x4f
	mov	0x60, %r25
	.word 0xdab7ce80  ! 4800: STHA_R	stha	%r13, [%r31 + %r0] 0x74
	mov	0x10, %r18
	.word 0xdaac8400  ! 4802: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0x87802020  ! 4803: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a6c9e0  ! 4804: STWA_R	stwa	%r9, [%r27 + %r0] 0x4f
	.word 0xd4c46000  ! 4805: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r10
	.word 0xd4ace000  ! 4806: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0xdc9689e0  ! 4807: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r14
	.word 0xd6a4a000  ! 4808: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xd69c6000  ! 4810: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r11
	mov	0x8, %r24
	.word 0xd2ce89e0  ! 4812: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r9
	mov	0x68, %r17
	.word 0xd4adc4a0  ! 4814: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0xdcf70e40  ! 4815: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	.word 0xd8978e60  ! 4816: LDUHA_R	lduha	[%r30, %r0] 0x73, %r12
	.word 0xd6d46000  ! 4817: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r11
	.word 0xd69ca000  ! 4818: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r11
	.word 0xd6c4e000  ! 4819: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r11
	.word 0xd6dca000  ! 4820: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r11
	.word 0xd6a4e000  ! 4821: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0xd48f4e60  ! 4822: LDUBA_R	lduba	[%r29, %r0] 0x73, %r10
	mov	0x0, %r16
	.word 0x87802020  ! 4824: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8c6000  ! 4825: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r13
	.word 0xda946000  ! 4826: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	.word 0xdaa4a000  ! 4827: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xdaaca000  ! 4828: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0xd2bc4400  ! 4829: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	mov	0x70, %r16
	.word 0xd2b70e80  ! 4831: STHA_R	stha	%r9, [%r28 + %r0] 0x74
	mov	0x7e8, %r23
	.word 0xd2a40400  ! 4833: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xd6bdc4a0  ! 4834: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	mov	0x0, %r17
	.word 0x87802074  ! 4836: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f6c9e0  ! 4837: STXA_R	stxa	%r8, [%r27 + %r0] 0x4f
	.word 0xd0f7e000  ! 4838: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 4839: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ad04a0  ! 4840: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	.word 0x87802020  ! 4841: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4842: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdab4a000  ! 4843: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0xdadf4e40  ! 4844: LDXA_R	ldxa	[%r29, %r0] 0x72, %r13
	.word 0x87802025  ! 4845: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0b7a000  ! 4846: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd0f7e000  ! 4847: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd2b7ce60  ! 4848: STHA_R	stha	%r9, [%r31 + %r0] 0x73
	.word 0xdcd72000  ! 4849: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	mov	0x68, %r24
	.word 0xdcf7a000  ! 4851: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 4852: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcac6000  ! 4853: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xdc84a000  ! 4854: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	mov	0x0, %r16
	.word 0xdcd42000  ! 4856: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	.word 0xdedd04a0  ! 4857: LDXA_R	ldxa	[%r20, %r0] 0x25, %r15
	.word 0xd4bc8400  ! 4858: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	mov	0x28, %r16
	.word 0xdaa42000  ! 4860: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0x87802020  ! 4862: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea504a0  ! 4863: STWA_R	stwa	%r15, [%r20 + %r0] 0x25
	.word 0xde878e60  ! 4864: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r15
	.word 0x87802020  ! 4865: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9d04a0  ! 4866: LDDA_R	ldda	[%r20, %r0] 0x25, %r14
	mov	0x70, %r24
	.word 0xdad7a000  ! 4868: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0xd4d584a0  ! 4869: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r10
	.word 0xd6ce09e0  ! 4870: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r11
	.word 0xdab7a000  ! 4871: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdaa78e60  ! 4872: STWA_R	stwa	%r13, [%r30 + %r0] 0x73
	.word 0xd4d689e0  ! 4873: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r10
	.word 0x87802073  ! 4874: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4bfce80  ! 4875: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	.word 0xdeb46000  ! 4876: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	mov	0x60, %r24
	mov	0x7f8, %r20
	.word 0xdcbf4e80  ! 4879: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	.word 0xd89ce000  ! 4880: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	.word 0xd8a42000  ! 4881: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8cc2000  ! 4882: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r12
	.word 0xd8f46000  ! 4883: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8bce000  ! 4884: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 4885: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xded7ce40  ! 4886: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r15
	.word 0xd4ae49e0  ! 4887: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0xd2c40400  ! 4888: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r9
	.word 0xd0942000  ! 4889: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r8
	.word 0xd0dca000  ! 4890: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0f4e000  ! 4891: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 4892: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0df4e40  ! 4893: LDXA_R	ldxa	[%r29, %r0] 0x72, %r8
	mov	0x3c0, %r20
	.word 0xdebf2000  ! 4895: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xdecfe000  ! 4896: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	ta	T_CHANGE_PRIV	! macro
	.word 0xde9e09e0  ! 4898: LDDA_R	ldda	[%r24, %r0] 0x4f, %r15
	mov	0x68, %r18
	mov	0x50, %r25
	.word 0xd8afe000  ! 4901: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd897a000  ! 4902: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	mov	0x3f0, %r20
	mov	0x58, %r25
	.word 0xd8bf2000  ! 4905: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd8cf2000  ! 4906: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0xd8d76000  ! 4907: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xd4a649e0  ! 4908: STWA_R	stwa	%r10, [%r25 + %r0] 0x4f
	.word 0xd4a72000  ! 4909: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4df2000  ! 4910: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 4911: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdadf8e60  ! 4912: LDXA_R	ldxa	[%r30, %r0] 0x73, %r13
	.word 0xdabc8400  ! 4913: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	.word 0xdcf70e40  ! 4914: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	.word 0x87802025  ! 4915: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde948400  ! 4916: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	.word 0xd49ce000  ! 4917: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0xd49c6000  ! 4918: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0xd29f0e80  ! 4919: LDDA_R	ldda	[%r28, %r0] 0x74, %r9
	.word 0xde9c2000  ! 4920: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xdec42000  ! 4921: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0xdeb4a000  ! 4922: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0xdea4e000  ! 4923: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	mov	0x8, %r26
	mov	0x60, %r24
	.word 0x8780204f  ! 4926: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbfce60  ! 4927: STDA_R	stda	%r14, [%r31 + %r0] 0x73
	.word 0xd2bf2000  ! 4928: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd2f76000  ! 4929: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 4930: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2f5e000  ! 4932: STXA_I	stxa	%r9, [%r23 + 0x0000] %asi
	.word 0xd4adc4a0  ! 4933: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0x87802073  ! 4934: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4935: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r19
	.word 0x87802025  ! 4937: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6cfa000  ! 4938: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0xda8f0e40  ! 4939: LDUBA_R	lduba	[%r28, %r0] 0x72, %r13
	mov	0x10, %r16
	.word 0xdabc4400  ! 4941: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xde970e80  ! 4942: LDUHA_R	lduha	[%r28, %r0] 0x74, %r15
	.word 0xdab76000  ! 4943: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xd8d48400  ! 4944: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	mov	0x3d8, %r22
	.word 0xdeaec9e0  ! 4946: STBA_R	stba	%r15, [%r27 + %r0] 0x4f
	.word 0xd0b74e60  ! 4947: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	.word 0x87802073  ! 4948: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4af0e80  ! 4949: STBA_R	stba	%r10, [%r28 + %r0] 0x74
	.word 0xd8d40400  ! 4950: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	.word 0xdcc7a000  ! 4951: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	mov	0x7e0, %r20
	.word 0xd8adc4a0  ! 4953: STBA_R	stba	%r12, [%r23 + %r0] 0x25
	.word 0xd0f72000  ! 4954: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xd6bc8400  ! 4955: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xd6bf0e40  ! 4956: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	.word 0xdabfa000  ! 4957: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 4958: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda872000  ! 4959: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 4960: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bf8e80  ! 4961: STDA_R	stda	%r12, [%r30 + %r0] 0x74
	mov	0x48, %r27
	.word 0xdabfe000  ! 4963: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 4964: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r23
	mov	0x78, %r17
	mov	0x30, %r26
	.word 0xda966000  ! 4968: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r13
	.word 0xd8cd04a0  ! 4969: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r12
	.word 0xd8be2000  ! 4970: STDA_I	stda	%r12, [%r24 + 0x0000] %asi
	.word 0x87802025  ! 4971: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0dc0400  ! 4972: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xd4bf8e60  ! 4973: STDA_R	stda	%r10, [%r30 + %r0] 0x73
	.word 0xded5e000  ! 4974: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r15
	.word 0xd28c4400  ! 4975: LDUBA_R	lduba	[%r17, %r0] 0x20, %r9
	mov	0x10, %r24
	mov	0x70, %r16
	mov	0x3f0, %r20
	mov	0x0, %r19
	mov	0x10, %r19
	mov	0x10, %r19
	.word 0xd0cfce80  ! 4982: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r8
	.word 0x8780204f  ! 4983: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4cfce40  ! 4984: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r10
	mov	0x7e8, %r20
	.word 0x87802020  ! 4986: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ccc400  ! 4987: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0xd0d4e000  ! 4988: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	.word 0xd6a40400  ! 4989: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0xd6cfce60  ! 4990: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r11
	.word 0xd8a4e000  ! 4991: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xd08544a0  ! 4992: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r8
	mov	0x3e0, %r21
	.word 0xded649e0  ! 4994: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r15
	.word 0x8780204f  ! 4995: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbdc4a0  ! 4996: STDA_R	stda	%r14, [%r23 + %r0] 0x25
	.word 0xd69689e0  ! 4997: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r11
	mov	0x68, %r19
	mov	0x0, %r27
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_1:
	.word 0xd0b7a000  ! 1: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd0cfe000  ! 2: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xd08fe000  ! 3: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	.word 0xd087ce40  ! 4: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r8
	mov	0x40, %r24
	.word 0x87802074  ! 6: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 7: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb7ce40  ! 8: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	.word 0xd4af2000  ! 9: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0xd4872000  ! 11: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8bc8400  ! 13: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0x87802020  ! 14: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r22
	.word 0x87802073  ! 16: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4a46000  ! 17: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 18: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4bf6000  ! 19: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd4b7a000  ! 20: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd4cf2000  ! 21: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	mov	0x0, %r17
	.word 0xd4bf6000  ! 23: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd4afe000  ! 24: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd49fe000  ! 25: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd4dfe000  ! 26: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802072  ! 27: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a7e000  ! 28: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd2cdc4a0  ! 29: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r9
	.word 0xdaafa000  ! 30: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdab72000  ! 31: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xd8d40400  ! 32: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	.word 0x87802072  ! 33: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 34: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 35: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r17
	mov	0x18, %r26
	mov	0x7e0, %r20
	mov	0x30, %r27
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2a4e000  ! 41: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 42: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2bfa000  ! 43: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd2dfe000  ! 44: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2bfa000  ! 45: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd4a5c4a0  ! 46: STWA_R	stwa	%r10, [%r23 + %r0] 0x25
	.word 0xd2d7e000  ! 47: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xd2df2000  ! 48: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xded48400  ! 49: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	mov	0x48, %r17
	.word 0xd8af0e60  ! 51: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	.word 0x87802072  ! 52: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b649e0  ! 53: STHA_R	stha	%r12, [%r25 + %r0] 0x4f
	.word 0xd2f5c4a0  ! 54: STXA_R	stxa	%r9, [%r23 + %r0] 0x25
	mov	0x3f0, %r21
	.word 0xdacc2000  ! 56: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xd6bd44a0  ! 57: STDA_R	stda	%r11, [%r21 + %r0] 0x25
	.word 0xd4c74e60  ! 58: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r10
	mov	0x58, %r25
	.word 0xd494c400  ! 60: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	.word 0x87802020  ! 61: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cf8e80  ! 62: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r10
	.word 0xd4b4c400  ! 63: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0xd2d70e80  ! 64: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r9
	.word 0xd8840400  ! 65: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r12
	.word 0x8780204f  ! 66: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 67: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccf2000  ! 68: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xd6870e40  ! 69: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r11
	.word 0xd0d7a000  ! 70: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	mov	0x7f0, %r21
	.word 0xd4a48400  ! 72: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xd29ec9e0  ! 73: LDDA_R	ldda	[%r27, %r0] 0x4f, %r9
	.word 0xdecfe000  ! 74: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xd4f78e60  ! 75: STXA_R	stxa	%r10, [%r30 + %r0] 0x73
	.word 0xdcf72000  ! 76: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcafe000  ! 77: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xd4b689e0  ! 78: STHA_R	stha	%r10, [%r26 + %r0] 0x4f
	mov	0x3c0, %r20
	mov	0x60, %r18
	.word 0xd6afa000  ! 81: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xde9f8e80  ! 82: LDDA_R	ldda	[%r30, %r0] 0x74, %r15
	.word 0x87802020  ! 83: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde87e000  ! 84: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdef72000  ! 85: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xdebfe000  ! 86: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	mov	0x38, %r19
	.word 0xdef72000  ! 88: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 89: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea609e0  ! 90: STWA_R	stwa	%r15, [%r24 + %r0] 0x4f
	.word 0xd4dc4400  ! 91: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	.word 0x8780204f  ! 92: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde8cc400  ! 93: LDUBA_R	lduba	[%r19, %r0] 0x20, %r15
	.word 0xdad66000  ! 94: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r13
	.word 0xd0cc0400  ! 95: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xd0be6000  ! 96: STDA_I	stda	%r8, [%r25 + 0x0000] %asi
	.word 0xd0d6e000  ! 97: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r8
	mov	0x78, %r17
	mov	0x3e8, %r20
	.word 0xd89f8e80  ! 100: LDDA_R	ldda	[%r30, %r0] 0x74, %r12
	.word 0xdc8f4e60  ! 101: LDUBA_R	lduba	[%r29, %r0] 0x73, %r14
	.word 0xd4f78e40  ! 102: STXA_R	stxa	%r10, [%r30 + %r0] 0x72
	.word 0xd0b44400  ! 103: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xda94c400  ! 104: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	.word 0xda8649e0  ! 105: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r13
	.word 0x87802025  ! 106: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2a689e0  ! 107: STWA_R	stwa	%r9, [%r26 + %r0] 0x4f
	mov	0x7d8, %r21
	.word 0xdebf2000  ! 109: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xdecc4400  ! 110: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r15
	mov	0x3d8, %r21
	.word 0x87802020  ! 112: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f7e000  ! 113: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 114: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd69c8400  ! 115: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	.word 0xd884e000  ! 116: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r12
	.word 0xdedf4e40  ! 117: LDXA_R	ldxa	[%r29, %r0] 0x72, %r15
	.word 0xdc94a000  ! 118: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xda9f8e60  ! 119: LDDA_R	ldda	[%r30, %r0] 0x73, %r13
	.word 0xde874e40  ! 120: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r15
	.word 0x87802025  ! 121: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdccce000  ! 122: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r14
	.word 0xd8bdc4a0  ! 123: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	.word 0x87802020  ! 124: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9c2000  ! 125: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xde84e000  ! 126: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	.word 0xdebce000  ! 127: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	mov	0x7f0, %r22
	.word 0x8780204f  ! 129: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 130: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3e8, %r23
	.word 0xdac7ce40  ! 132: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r13
	.word 0xdaafe000  ! 133: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 134: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d8, %r23
	.word 0xdaaf6000  ! 136: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 137: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda972000  ! 138: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	mov	0x60, %r26
	.word 0x87802025  ! 140: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8da000  ! 141: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r13
	.word 0xdaad6000  ! 142: STBA_I	stba	%r13, [%r21 + 0x0000] %asi
	.word 0xdaa5a000  ! 143: STWA_I	stwa	%r13, [%r22 + 0x0000] %asi
	mov	0x3f8, %r23
	.word 0xda9d2000  ! 145: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r13
	.word 0xd0ae09e0  ! 146: STBA_R	stba	%r8, [%r24 + %r0] 0x4f
	.word 0xd28ec9e0  ! 147: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r9
	.word 0xd6a5e000  ! 148: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	.word 0xdef40400  ! 149: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0xdebec9e0  ! 150: STDA_R	stda	%r15, [%r27 + %r0] 0x4f
	mov	0x7d0, %r22
	.word 0xd4a544a0  ! 152: STWA_R	stwa	%r10, [%r21 + %r0] 0x25
	.word 0xdaa78e60  ! 153: STWA_R	stwa	%r13, [%r30 + %r0] 0x73
	mov	0x7e8, %r20
	.word 0xd8acc400  ! 155: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0xdedd84a0  ! 156: LDXA_R	ldxa	[%r22, %r0] 0x25, %r15
	.word 0xd6f52000  ! 157: STXA_I	stxa	%r11, [%r20 + 0x0000] %asi
	.word 0xd6ad6000  ! 158: STBA_I	stba	%r11, [%r21 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xd8a7ce80  ! 160: STWA_R	stwa	%r12, [%r31 + %r0] 0x74
	mov	0x18, %r18
	.word 0x87802020  ! 162: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bc2000  ! 163: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd694c400  ! 164: LDUHA_R	lduha	[%r19, %r0] 0x20, %r11
	.word 0xd2d4c400  ! 165: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r9
	mov	0x68, %r27
	mov	0x8, %r18
	mov	0x30, %r17
	.word 0x8780204f  ! 169: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r24
	mov	0x48, %r27
	.word 0xd8a7ce80  ! 172: STWA_R	stwa	%r12, [%r31 + %r0] 0x74
	.word 0x87802073  ! 173: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r18
	.word 0xd88d44a0  ! 175: LDUBA_R	lduba	[%r21, %r0] 0x25, %r12
	.word 0xdab44400  ! 176: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	mov	0x7d8, %r22
	.word 0x87802020  ! 178: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 179: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f8, %r20
	.word 0xdc878e60  ! 181: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r14
	.word 0xde8649e0  ! 182: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r15
	mov	0x3d0, %r22
	.word 0x87802025  ! 184: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a48400  ! 185: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0xd4b544a0  ! 186: STHA_R	stha	%r10, [%r21 + %r0] 0x25
	.word 0xd8c7ce60  ! 187: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r12
	.word 0xd8a74e80  ! 188: STWA_R	stwa	%r12, [%r29 + %r0] 0x74
	.word 0xd0cc2000  ! 189: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 190: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 191: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xded7ce40  ! 192: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r15
	.word 0x8780204f  ! 193: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d0, %r23
	.word 0xd0946000  ! 195: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0x87802074  ! 196: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde970e60  ! 197: LDUHA_R	lduha	[%r28, %r0] 0x73, %r15
	mov	0x28, %r26
	.word 0x87802025  ! 199: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdcb7ce40  ! 201: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	.word 0xdcf4a000  ! 202: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdc94a000  ! 203: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xd49c4400  ! 204: LDDA_R	ldda	[%r17, %r0] 0x20, %r10
	.word 0xdad42000  ! 205: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r13
	.word 0xdabce000  ! 206: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0xdab4a000  ! 207: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0xdaa42000  ! 208: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0xd0cd44a0  ! 209: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r8
	.word 0xd2df0e80  ! 210: LDXA_R	ldxa	[%r28, %r0] 0x74, %r9
	mov	0x50, %r27
	.word 0x8780204f  ! 212: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc9d6000  ! 213: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r14
	.word 0xdccde000  ! 214: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r14
	mov	0x20, %r16
	.word 0xd6bf0e40  ! 216: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	.word 0x8780204f  ! 217: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcc70e60  ! 218: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r14
	.word 0xdcd4c400  ! 219: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	mov	0x3f0, %r22
	.word 0xd2d4c400  ! 221: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r9
	.word 0xdac7e000  ! 222: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0x87802025  ! 223: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cdc4a0  ! 224: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r10
	.word 0xd6bc6000  ! 225: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	mov	0x48, %r27
	.word 0x87802074  ! 227: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6afa000  ! 228: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6bfe000  ! 229: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xde978e60  ! 230: LDUHA_R	lduha	[%r30, %r0] 0x73, %r15
	mov	0x20, %r27
	mov	0x3f0, %r21
	.word 0xd2dfce60  ! 233: LDXA_R	ldxa	[%r31, %r0] 0x73, %r9
	mov	0x48, %r18
	.word 0x87802020  ! 235: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b7a000  ! 236: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 237: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f78e60  ! 238: STXA_R	stxa	%r10, [%r30 + %r0] 0x73
	.word 0x87802072  ! 239: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb7a000  ! 240: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xd4d74e40  ! 241: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r10
	.word 0x87802072  ! 242: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd685c4a0  ! 243: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r11
	.word 0xd8b689e0  ! 244: STHA_R	stha	%r12, [%r26 + %r0] 0x4f
	mov	0x20, %r26
	.word 0x87802020  ! 246: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9d44a0  ! 247: LDDA_R	ldda	[%r21, %r0] 0x25, %r15
	.word 0xd4f649e0  ! 248: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	.word 0xdc976000  ! 249: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	mov	0x38, %r25
	.word 0xdcdf2000  ! 251: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdca72000  ! 252: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcbf2000  ! 253: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdc872000  ! 254: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xdc8f6000  ! 255: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 256: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 257: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f0, %r22
	.word 0xd49f4e80  ! 259: LDDA_R	ldda	[%r29, %r0] 0x74, %r10
	.word 0xd0c4e000  ! 260: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	mov	0x70, %r19
	.word 0xd6b7ce80  ! 262: STHA_R	stha	%r11, [%r31 + %r0] 0x74
	.word 0xd49fce60  ! 263: LDDA_R	ldda	[%r31, %r0] 0x73, %r10
	mov	0x68, %r18
	.word 0xdebc6000  ! 265: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xd2a78e80  ! 266: STWA_R	stwa	%r9, [%r30 + %r0] 0x74
	mov	0x8, %r18
	mov	0x7c8, %r21
	.word 0xdabd44a0  ! 269: STDA_R	stda	%r13, [%r21 + %r0] 0x25
	mov	0x40, %r19
	.word 0xd0dc0400  ! 271: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	mov	0x7d0, %r22
	.word 0xdabc2000  ! 273: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xdab4e000  ! 274: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 275: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cdc4a0  ! 276: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r10
	.word 0xdeb5a000  ! 277: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 278: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde96a000  ! 279: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r15
	.word 0xda9f8e40  ! 280: LDDA_R	ldda	[%r30, %r0] 0x72, %r13
	.word 0x87802020  ! 281: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b649e0  ! 282: STHA_R	stha	%r8, [%r25 + %r0] 0x4f
	.word 0xdcdca000  ! 283: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xd0ae49e0  ! 284: STBA_R	stba	%r8, [%r25 + %r0] 0x4f
	.word 0xd68d04a0  ! 285: LDUBA_R	lduba	[%r20, %r0] 0x25, %r11
	.word 0xd4f6c9e0  ! 286: STXA_R	stxa	%r10, [%r27 + %r0] 0x4f
	.word 0xdef46000  ! 287: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xdc944400  ! 288: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	.word 0x87802074  ! 289: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8cc0400  ! 290: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	.word 0xdcafce80  ! 291: STBA_R	stba	%r14, [%r31 + %r0] 0x74
	.word 0x87802074  ! 292: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r16
	.word 0xd495c4a0  ! 294: LDUHA_R	lduha	[%r23, %r0] 0x25, %r10
	.word 0xd6f78e60  ! 295: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	.word 0x87802074  ! 296: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdccf6000  ! 297: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xd0c48400  ! 298: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r8
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7f8, %r22
	.word 0xdec7ce40  ! 301: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r15
	.word 0xdcdfa000  ! 302: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	.word 0xdc8f6000  ! 303: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcaf2000  ! 304: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdec4c400  ! 305: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	mov	0x7f0, %r22
	mov	0x10, %r19
	.word 0x8780204f  ! 308: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r18
	.word 0xdcbdc4a0  ! 310: STDA_R	stda	%r14, [%r23 + %r0] 0x25
	.word 0xd0cc4400  ! 311: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	.word 0x87802074  ! 312: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde9f4e60  ! 313: LDDA_R	ldda	[%r29, %r0] 0x73, %r15
	mov	0x3e8, %r21
	.word 0xdecee000  ! 315: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r15
	.word 0xdec66000  ! 316: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r15
	mov	0x60, %r27
	mov	0x50, %r19
	.word 0x87802072  ! 319: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r27
	mov	0x3f8, %r20
	mov	0x10, %r27
	mov	0x68, %r19
	mov	0x3e0, %r23
	.word 0xdeb76000  ! 325: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xde84c400  ! 326: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	mov	0x0, %r19
	mov	0x18, %r24
	.word 0x87802020  ! 329: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r21
	.word 0xdc948400  ! 331: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	.word 0xd8a70e60  ! 332: STWA_R	stwa	%r12, [%r28 + %r0] 0x73
	.word 0xd0a544a0  ! 333: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	mov	0x48, %r24
	.word 0xd8f74e40  ! 335: STXA_R	stxa	%r12, [%r29 + %r0] 0x72
	mov	0x3e0, %r21
	.word 0x87802025  ! 337: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcd40400  ! 338: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	mov	0x60, %r26
	mov	0x70, %r24
	mov	0x3d8, %r23
	.word 0x87802025  ! 342: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd884a000  ! 343: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r12
	.word 0xd8b4e000  ! 344: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0xd6af0e80  ! 345: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	.word 0x87802020  ! 346: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r25
	.word 0x87802025  ! 348: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c0, %r23
	mov	0x60, %r25
	.word 0xde8fce80  ! 351: LDUBA_R	lduba	[%r31, %r0] 0x74, %r15
	.word 0xdebee000  ! 352: STDA_I	stda	%r15, [%r27 + 0x0000] %asi
	mov	0x10, %r19
	.word 0xdeae2000  ! 354: STBA_I	stba	%r15, [%r24 + 0x0000] %asi
	.word 0xdc8689e0  ! 355: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r14
	.word 0xdece2000  ! 356: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r15
	mov	0x68, %r19
	.word 0xdecea000  ! 358: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r15
	.word 0xde9ee000  ! 359: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r15
	.word 0xdaccc400  ! 360: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r13
	.word 0x87802020  ! 361: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a7ce80  ! 362: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	.word 0xda852000  ! 363: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r13
	mov	0x58, %r17
	.word 0xd6cc8400  ! 365: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	.word 0xdef609e0  ! 366: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	.word 0xdcd504a0  ! 367: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r14
	.word 0xd29f4e60  ! 368: LDDA_R	ldda	[%r29, %r0] 0x73, %r9
	.word 0x87802025  ! 369: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaf46000  ! 370: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0xda8584a0  ! 372: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r13
	.word 0xde942000  ! 373: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	.word 0xdef4e000  ! 374: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xdea4a000  ! 375: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x18, %r16
	.word 0xdec42000  ! 378: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0xdec4c400  ! 379: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	.word 0xd88ce000  ! 380: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	mov	0x7c8, %r21
	.word 0xd8bc6000  ! 382: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0xd8d46000  ! 383: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	.word 0xd894e000  ! 384: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r12
	.word 0xd8a4e000  ! 385: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xdcd74e80  ! 387: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r14
	.word 0xd4f4a000  ! 388: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0xd4bc6000  ! 389: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xd4a4e000  ! 390: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xd4bca000  ! 391: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0xdcf40400  ! 392: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xd8bca000  ! 393: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd89ca000  ! 395: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r12
	.word 0xde9f0e60  ! 396: LDDA_R	ldda	[%r28, %r0] 0x73, %r15
	.word 0xd48c4400  ! 397: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0x87802020  ! 398: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeaf2000  ! 399: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 400: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8d84a0  ! 401: LDUBA_R	lduba	[%r22, %r0] 0x25, %r15
	.word 0xd6af6000  ! 402: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd6af2000  ! 403: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x7f0, %r20
	mov	0x20, %r16
	mov	0x48, %r27
	.word 0xd8af8e60  ! 407: STBA_R	stba	%r12, [%r30 + %r0] 0x73
	.word 0xd8f76000  ! 408: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8c7e000  ! 409: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0xdebe09e0  ! 410: STDA_R	stda	%r15, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 411: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e0, %r23
	.word 0xd287e000  ! 413: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	mov	0x10, %r17
	.word 0xd0a504a0  ! 415: STWA_R	stwa	%r8, [%r20 + %r0] 0x25
	mov	0x7f0, %r21
	.word 0xd0cf8e40  ! 417: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r8
	.word 0xd6b7a000  ! 418: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd2f504a0  ! 419: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	.word 0xd8cfa000  ! 420: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	mov	0x3c0, %r21
	mov	0x48, %r17
	.word 0xd8cf6000  ! 423: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0xdec689e0  ! 424: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r15
	mov	0x10, %r17
	mov	0x40, %r19
	mov	0x3e0, %r23
	mov	0x7f8, %r22
	mov	0x20, %r24
	mov	0x18, %r26
	.word 0xd28e49e0  ! 431: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r9
	.word 0xd8bec9e0  ! 432: STDA_R	stda	%r12, [%r27 + %r0] 0x4f
	mov	0x28, %r18
	.word 0xde9d44a0  ! 434: LDDA_R	ldda	[%r21, %r0] 0x25, %r15
	.word 0xd0a74e60  ! 435: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	.word 0xda8fe000  ! 436: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xdad72000  ! 437: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0xd8f78e40  ! 438: STXA_R	stxa	%r12, [%r30 + %r0] 0x72
	.word 0xd2a76000  ! 439: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd2af2000  ! 440: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xd29f6000  ! 442: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	mov	0x7e0, %r23
	.word 0x87802025  ! 444: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd29c6000  ! 445: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd4b74e60  ! 447: STHA_R	stha	%r10, [%r29 + %r0] 0x73
	mov	0x68, %r19
	.word 0x87802074  ! 449: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde970e40  ! 450: LDUHA_R	lduha	[%r28, %r0] 0x72, %r15
	.word 0xd28d44a0  ! 451: LDUBA_R	lduba	[%r21, %r0] 0x25, %r9
	mov	0x3e0, %r22
	mov	0x38, %r27
	.word 0xd4c76000  ! 454: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	mov	0x7e0, %r23
	.word 0xd2bd44a0  ! 456: STDA_R	stda	%r9, [%r21 + %r0] 0x25
	.word 0xdcbfe000  ! 457: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 458: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd297ce80  ! 459: LDUHA_R	lduha	[%r31, %r0] 0x74, %r9
	.word 0x8780204f  ! 460: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde9ca000  ! 461: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	.word 0xde8c2000  ! 462: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	mov	0x3c8, %r20
	.word 0x87802074  ! 464: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdea4a000  ! 465: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xdecc6000  ! 466: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r15
	.word 0xd686c9e0  ! 467: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r11
	.word 0xd897ce40  ! 468: LDUHA_R	lduha	[%r31, %r0] 0x72, %r12
	.word 0x87802074  ! 469: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a70e80  ! 470: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	.word 0x87802074  ! 471: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd69fa000  ! 472: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0xdebf8e80  ! 473: STDA_R	stda	%r15, [%r30 + %r0] 0x74
	.word 0xd4976000  ! 474: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r10
	.word 0xd4f7e000  ! 475: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	mov	0x58, %r19
	mov	0x48, %r25
	.word 0xdaa609e0  ! 478: STWA_R	stwa	%r13, [%r24 + %r0] 0x4f
	mov	0x7f8, %r21
	mov	0x40, %r17
	mov	0x3e0, %r22
	mov	0x3f8, %r23
	.word 0xd6c76000  ! 483: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6cfa000  ! 484: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0x87802020  ! 485: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r19
	.word 0xd6cee000  ! 487: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r11
	.word 0xdaa78e40  ! 488: STWA_R	stwa	%r13, [%r30 + %r0] 0x72
	.word 0xd8bc4400  ! 489: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	mov	0x60, %r26
	.word 0xdcbea000  ! 491: STDA_I	stda	%r14, [%r26 + 0x0000] %asi
	.word 0xd0cc8400  ! 492: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0x8780204f  ! 493: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc872000  ! 494: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcd76000  ! 495: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	mov	0x3e0, %r20
	mov	0x78, %r18
	.word 0xdc9f6000  ! 498: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	mov	0x3c0, %r22
	.word 0xdcaec9e0  ! 500: STBA_R	stba	%r14, [%r27 + %r0] 0x4f
	.word 0xd8b44400  ! 501: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0x87802025  ! 502: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4b40400  ! 503: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0xd69fce80  ! 504: LDDA_R	ldda	[%r31, %r0] 0x74, %r11
	.word 0xd6f609e0  ! 505: STXA_R	stxa	%r11, [%r24 + %r0] 0x4f
	.word 0xd4dfa000  ! 506: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd68c4400  ! 507: LDUBA_R	lduba	[%r17, %r0] 0x20, %r11
	mov	0x3f0, %r21
	.word 0xd8d7e000  ! 509: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0xd8bf6000  ! 510: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 511: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r22
	.word 0xd88c6000  ! 513: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 514: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r25
	.word 0xd0ac0400  ! 516: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	mov	0x3f0, %r22
	mov	0x10, %r26
	.word 0xd8bf4e40  ! 519: STDA_R	stda	%r12, [%r29 + %r0] 0x72
	.word 0xd0ade000  ! 520: STBA_I	stba	%r8, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 521: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0876000  ! 522: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd4ce89e0  ! 524: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r10
	.word 0xd4f609e0  ! 525: STXA_R	stxa	%r10, [%r24 + %r0] 0x4f
	.word 0xd6bf2000  ! 526: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	mov	0x70, %r25
	mov	0x58, %r19
	mov	0x38, %r26
	.word 0xdcccc400  ! 530: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	.word 0xdaf7a000  ! 531: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xd6dc8400  ! 532: LDXA_R	ldxa	[%r18, %r0] 0x20, %r11
	mov	0x60, %r16
	.word 0xd2cf6000  ! 534: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	mov	0x3e0, %r20
	mov	0x3c0, %r20
	.word 0xd0f7ce80  ! 537: STXA_R	stxa	%r8, [%r31 + %r0] 0x74
	.word 0xd6b74e60  ! 538: STHA_R	stha	%r11, [%r29 + %r0] 0x73
	.word 0xd6cf0e40  ! 539: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r11
	.word 0xd8cfe000  ! 540: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x70, %r18
	.word 0xd88fe000  ! 543: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd6ad84a0  ! 544: STBA_R	stba	%r11, [%r22 + %r0] 0x25
	.word 0xd2c7ce80  ! 545: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r9
	.word 0xda978e40  ! 546: LDUHA_R	lduha	[%r30, %r0] 0x72, %r13
	.word 0xd494c400  ! 547: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	.word 0xd29fa000  ! 548: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd2df2000  ! 549: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xdcc78e60  ! 550: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r14
	mov	0x38, %r27
	.word 0xd4f48400  ! 552: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xdea78e60  ! 553: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	.word 0xd4af0e80  ! 554: STBA_R	stba	%r10, [%r28 + %r0] 0x74
	.word 0x87802025  ! 555: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6cf0e40  ! 556: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r11
	.word 0xdecf0e60  ! 557: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r15
	.word 0xdabfce60  ! 558: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	.word 0xdca70e80  ! 559: STWA_R	stwa	%r14, [%r28 + %r0] 0x74
	mov	0x68, %r24
	.word 0xd8ae6000  ! 561: STBA_I	stba	%r12, [%r25 + 0x0000] %asi
	.word 0xd8df0e80  ! 562: LDXA_R	ldxa	[%r28, %r0] 0x74, %r12
	.word 0xd2f6a000  ! 563: STXA_I	stxa	%r9, [%r26 + 0x0000] %asi
	.word 0xd4d48400  ! 564: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	mov	0x18, %r19
	.word 0xdeccc400  ! 566: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r15
	.word 0xd287ce40  ! 567: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r9
	.word 0xd096e000  ! 568: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r8
	.word 0xda8689e0  ! 569: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r13
	.word 0xd8944400  ! 570: LDUHA_R	lduha	[%r17, %r0] 0x20, %r12
	mov	0x40, %r27
	.word 0x87802020  ! 572: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 573: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r16
	.word 0xd2bd6000  ! 575: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	.word 0x87802073  ! 576: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2d4a000  ! 577: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	.word 0xd2b4e000  ! 578: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0xd8d4c400  ! 580: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0xdea4a000  ! 581: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xd4f649e0  ! 582: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	.word 0xdef40400  ! 583: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0x87802073  ! 584: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd89689e0  ! 585: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r12
	mov	0x18, %r19
	.word 0xd8d74e80  ! 587: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r12
	mov	0x8, %r16
	.word 0xd6c78e80  ! 589: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r11
	mov	0x3c8, %r23
	.word 0x87802073  ! 591: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r26
	.word 0xd8a7a000  ! 593: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	mov	0x60, %r16
	mov	0x0, %r19
	.word 0x87802020  ! 596: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b70e80  ! 597: STHA_R	stha	%r12, [%r28 + %r0] 0x74
	.word 0xd2afe000  ! 598: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	mov	0x78, %r24
	.word 0xd2c7e000  ! 600: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	mov	0x10, %r25
	.word 0xd2bf6000  ! 602: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd2f7a000  ! 603: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 604: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdec70e40  ! 605: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r15
	mov	0x60, %r18
	.word 0xd6c4e000  ! 607: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r11
	mov	0x3e8, %r22
	.word 0xd6ac6000  ! 609: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xd0bfce80  ! 610: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	.word 0xd68e89e0  ! 611: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r11
	.word 0xd09c0400  ! 612: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	mov	0x10, %r18
	.word 0xd0df0e60  ! 614: LDXA_R	ldxa	[%r28, %r0] 0x73, %r8
	.word 0xd2c42000  ! 615: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	mov	0x38, %r16
	.word 0xd2cc2000  ! 617: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r9
	.word 0x87802074  ! 618: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f5c4a0  ! 619: STXA_R	stxa	%r8, [%r23 + %r0] 0x25
	.word 0xdea56000  ! 620: STWA_I	stwa	%r15, [%r21 + 0x0000] %asi
	.word 0xdeade000  ! 621: STBA_I	stba	%r15, [%r23 + 0x0000] %asi
	.word 0xde9c8400  ! 622: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	.word 0xd2874e40  ! 623: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r9
	.word 0xdac74e60  ! 624: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r13
	mov	0x48, %r19
	.word 0xd8a544a0  ! 626: STWA_R	stwa	%r12, [%r21 + %r0] 0x25
	.word 0xd0a56000  ! 627: STWA_I	stwa	%r8, [%r21 + 0x0000] %asi
	.word 0xd0bd6000  ! 628: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0xd8840400  ! 629: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r12
	mov	0x58, %r17
	.word 0xd28da000  ! 631: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r9
	mov	0x78, %r19
	mov	0x3e8, %r23
	.word 0x87802020  ! 634: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 635: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2976000  ! 636: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0x87802020  ! 637: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd296e000  ! 638: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r9
	mov	0x60, %r27
	.word 0xd2c6e000  ! 640: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r9
	.word 0x87802073  ! 641: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2af6000  ! 642: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 643: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4af8e60  ! 644: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	mov	0x78, %r26
	mov	0x50, %r16
	.word 0xda9f2000  ! 647: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	mov	0x8, %r27
	.word 0xdabfa000  ! 649: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 650: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4ddc4a0  ! 651: LDXA_R	ldxa	[%r23, %r0] 0x25, %r10
	.word 0xdc8c0400  ! 652: LDUBA_R	lduba	[%r16, %r0] 0x20, %r14
	.word 0xda8f0e80  ! 653: LDUBA_R	lduba	[%r28, %r0] 0x74, %r13
	.word 0x87802020  ! 654: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6852000  ! 655: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 656: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd68ea000  ! 657: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r11
	.word 0xd6f44400  ! 658: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0xd0c74e40  ! 659: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r8
	.word 0xd6d48400  ! 660: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	mov	0x60, %r18
	.word 0xd0f74e80  ! 662: STXA_R	stxa	%r8, [%r29 + %r0] 0x74
	.word 0xdeb70e60  ! 663: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	.word 0xd6862000  ! 664: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r11
	mov	0x38, %r18
	.word 0x87802074  ! 666: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b78e60  ! 667: STHA_R	stha	%r11, [%r30 + %r0] 0x73
	mov	0x7e8, %r22
	.word 0xdcaf2000  ! 669: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 670: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d609e0  ! 671: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r12
	.word 0x87802025  ! 672: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2ada000  ! 673: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xd28de000  ! 674: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r9
	mov	0x48, %r26
	.word 0xd2bde000  ! 676: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	.word 0xd2d4c400  ! 677: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r9
	.word 0xd88fce60  ! 678: LDUBA_R	lduba	[%r31, %r0] 0x73, %r12
	.word 0xdea7ce40  ! 679: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	.word 0xdeddc4a0  ! 680: LDXA_R	ldxa	[%r23, %r0] 0x25, %r15
	.word 0xd28fce80  ! 681: LDUBA_R	lduba	[%r31, %r0] 0x74, %r9
	.word 0xd4b52000  ! 682: STHA_I	stha	%r10, [%r20 + 0x0000] %asi
	.word 0xd48d6000  ! 683: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r10
	mov	0x10, %r19
	.word 0x87802072  ! 685: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc870e40  ! 686: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r14
	mov	0x30, %r16
	.word 0xde8609e0  ! 688: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r15
	.word 0x87802072  ! 689: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 690: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r26
	.word 0xdeafe000  ! 692: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xdc974e40  ! 693: LDUHA_R	lduha	[%r29, %r0] 0x72, %r14
	.word 0xd0a7e000  ! 694: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	mov	0x10, %r24
	.word 0x87802072  ! 696: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdec48400  ! 697: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	.word 0xd0940400  ! 698: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	.word 0xdcf72000  ! 699: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xd68c4400  ! 700: LDUBA_R	lduba	[%r17, %r0] 0x20, %r11
	mov	0x3c8, %r23
	.word 0xd2b7a000  ! 702: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	mov	0x30, %r17
	mov	0x0, %r16
	.word 0x8780204f  ! 705: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bf0e60  ! 706: STDA_R	stda	%r9, [%r28 + %r0] 0x73
	mov	0x40, %r17
	.word 0xdaa7ce60  ! 708: STWA_R	stwa	%r13, [%r31 + %r0] 0x73
	.word 0xd2b44400  ! 709: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0xd6cca000  ! 710: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r11
	.word 0x87802074  ! 711: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd09c0400  ! 712: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	.word 0xdc8de000  ! 713: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r14
	.word 0xdc952000  ! 714: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r14
	.word 0xdadcc400  ! 715: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xd69d04a0  ! 716: LDDA_R	ldda	[%r20, %r0] 0x25, %r11
	.word 0xd6f689e0  ! 717: STXA_R	stxa	%r11, [%r26 + %r0] 0x4f
	mov	0x30, %r26
	.word 0xdeaf0e80  ! 719: STBA_R	stba	%r15, [%r28 + %r0] 0x74
	.word 0xdcc44400  ! 720: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xdaad6000  ! 721: STBA_I	stba	%r13, [%r21 + 0x0000] %asi
	.word 0x87802073  ! 722: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0de49e0  ! 723: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r8
	.word 0xdca42000  ! 724: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	mov	0x7e0, %r21
	.word 0x8780204f  ! 726: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcd70e80  ! 727: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r14
	.word 0xd6a7a000  ! 728: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6c72000  ! 729: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	mov	0x3c0, %r22
	.word 0xd697a000  ! 731: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0xd6b7a000  ! 732: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	mov	0x3d0, %r22
	mov	0x7e0, %r22
	.word 0xd6d7a000  ! 735: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	mov	0x7d0, %r22
	.word 0xd28d44a0  ! 737: LDUBA_R	lduba	[%r21, %r0] 0x25, %r9
	.word 0xdcafe000  ! 738: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdcac0400  ! 739: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	mov	0x3d8, %r20
	.word 0xdc8f6000  ! 741: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdca7e000  ! 742: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdccfe000  ! 743: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xdcafa000  ! 744: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xdcdf2000  ! 745: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcbfa000  ! 746: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdcb72000  ! 747: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xd4a70e80  ! 748: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	mov	0x60, %r25
	.word 0xd8bec9e0  ! 750: STDA_R	stda	%r12, [%r27 + %r0] 0x4f
	.word 0xd4cf4e40  ! 751: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r10
	.word 0xda8fce80  ! 752: LDUBA_R	lduba	[%r31, %r0] 0x74, %r13
	.word 0xd2df2000  ! 753: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	mov	0x20, %r19
	.word 0xd2bfa000  ! 755: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd2bfe000  ! 756: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	mov	0x60, %r16
	mov	0x8, %r16
	.word 0xd2972000  ! 759: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	mov	0x40, %r25
	.word 0xdcd74e40  ! 761: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r14
	.word 0xd88d84a0  ! 762: LDUBA_R	lduba	[%r22, %r0] 0x25, %r12
	.word 0xd2d70e80  ! 763: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r9
	mov	0x3c8, %r20
	.word 0xdad6c9e0  ! 765: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r13
	.word 0x8780204f  ! 766: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b72000  ! 767: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xd8a76000  ! 769: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8d504a0  ! 770: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r12
	.word 0xd2bfa000  ! 771: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd29f2000  ! 772: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd2afa000  ! 773: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xdccfce40  ! 774: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r14
	.word 0xd6a7a000  ! 775: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xdea74e40  ! 776: STWA_R	stwa	%r15, [%r29 + %r0] 0x72
	.word 0xd29f6000  ! 777: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	mov	0x7e8, %r22
	mov	0x7c8, %r22
	.word 0xd2c76000  ! 780: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	mov	0x3c8, %r22
	mov	0x40, %r27
	mov	0x3e8, %r20
	.word 0x87802073  ! 784: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b4c400  ! 785: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0x87802073  ! 786: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcae49e0  ! 787: STBA_R	stba	%r14, [%r25 + %r0] 0x4f
	.word 0xd2cc6000  ! 788: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	.word 0xd2846000  ! 789: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r9
	mov	0x40, %r18
	.word 0xdcafce80  ! 791: STBA_R	stba	%r14, [%r31 + %r0] 0x74
	.word 0xd2a74e80  ! 792: STWA_R	stwa	%r9, [%r29 + %r0] 0x74
	.word 0x87802020  ! 793: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88d2000  ! 794: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r12
	.word 0xd8d5e000  ! 795: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r12
	.word 0xd8dd2000  ! 796: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r12
	mov	0x20, %r26
	.word 0x8780204f  ! 798: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ada000  ! 799: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0xd8bda000  ! 800: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	mov	0x78, %r24
	.word 0xd8ad6000  ! 802: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	.word 0xd09c8400  ! 803: LDDA_R	ldda	[%r18, %r0] 0x20, %r8
	.word 0xd4bf4e60  ! 804: STDA_R	stda	%r10, [%r29 + %r0] 0x73
	mov	0x68, %r26
	.word 0xd28c8400  ! 806: LDUBA_R	lduba	[%r18, %r0] 0x20, %r9
	.word 0xdaf5a000  ! 807: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xda8da000  ! 808: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r13
	.word 0xdeac4400  ! 809: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0xd2bc4400  ! 810: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0xdcc56000  ! 811: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r14
	.word 0xdc85a000  ! 812: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r14
	mov	0x20, %r24
	.word 0xd8cfce60  ! 814: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r12
	.word 0xd4f7ce60  ! 815: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	.word 0xdc840400  ! 816: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	.word 0xdc9d2000  ! 817: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r14
	.word 0xdcbd6000  ! 818: STDA_I	stda	%r14, [%r21 + 0x0000] %asi
	.word 0xd0af4e40  ! 819: STBA_R	stba	%r8, [%r29 + %r0] 0x72
	.word 0xd2a52000  ! 820: STWA_I	stwa	%r9, [%r20 + 0x0000] %asi
	.word 0xd4c48400  ! 821: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r10
	mov	0x50, %r24
	.word 0xdca56000  ! 823: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	.word 0x87802074  ! 824: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc972000  ! 825: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	.word 0xdcdf6000  ! 826: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	mov	0x60, %r17
	.word 0x87802073  ! 828: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 829: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r25
	.word 0xdcdf2000  ! 831: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xd4cf4e80  ! 832: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r10
	.word 0xdea70e80  ! 833: STWA_R	stwa	%r15, [%r28 + %r0] 0x74
	.word 0xd0b7e000  ! 834: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 835: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r24
	mov	0x70, %r18
	mov	0x30, %r18
	.word 0x87802072  ! 839: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0966000  ! 840: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r8
	mov	0x7f8, %r22
	.word 0xd28584a0  ! 842: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r9
	.word 0xd6de6000  ! 843: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r11
	.word 0xd4b504a0  ! 844: STHA_R	stha	%r10, [%r20 + %r0] 0x25
	.word 0xded74e40  ! 845: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r15
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x3d8, %r23
	mov	0x58, %r26
	mov	0x68, %r25
	.word 0x8780204f  ! 850: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd08e2000  ! 851: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r8
	.word 0x87802072  ! 852: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0aca000  ! 853: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xd8bcc400  ! 854: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0xdcdca000  ! 855: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xdca4a000  ! 856: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0xdc84a000  ! 857: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	mov	0x7e8, %r23
	.word 0xd48cc400  ! 859: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	.word 0xd2cf0e40  ! 860: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r9
	.word 0xd8c4e000  ! 861: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	.word 0xd0978e80  ! 862: LDUHA_R	lduha	[%r30, %r0] 0x74, %r8
	.word 0xd6b42000  ! 863: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	mov	0x78, %r16
	.word 0xd68ca000  ! 865: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r11
	.word 0xdca4c400  ! 866: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xdcadc4a0  ! 867: STBA_R	stba	%r14, [%r23 + %r0] 0x25
	mov	0x68, %r24
	.word 0xd6af8e80  ! 869: STBA_R	stba	%r11, [%r30 + %r0] 0x74
	.word 0xd0bc8400  ! 870: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0x87802020  ! 871: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8cc0400  ! 872: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	.word 0xdacf2000  ! 873: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	mov	0x68, %r18
	.word 0xd68cc400  ! 875: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	mov	0x7c8, %r20
	.word 0x87802072  ! 877: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0afe000  ! 878: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	mov	0x20, %r24
	.word 0xdac5c4a0  ! 880: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r13
	.word 0xdcf7e000  ! 881: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x78, %r26
	.word 0xd0ccc400  ! 883: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	.word 0xd6f7e000  ! 884: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xdeaf8e80  ! 885: STBA_R	stba	%r15, [%r30 + %r0] 0x74
	.word 0xd2b72000  ! 886: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd29fa000  ! 887: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd0cf4e80  ! 888: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r8
	.word 0x87802025  ! 889: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 890: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcb584a0  ! 891: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	.word 0xd0b4a000  ! 892: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xd4bcc400  ! 893: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	mov	0x48, %r25
	.word 0xd0b4a000  ! 895: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xd0cca000  ! 896: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	mov	0x3c8, %r22
	mov	0x7d0, %r21
	.word 0xd0f4e000  ! 899: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0c4e000  ! 900: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	.word 0x87802020  ! 901: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 902: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdab5c4a0  ! 903: STHA_R	stha	%r13, [%r23 + %r0] 0x25
	.word 0xd2d689e0  ! 904: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r9
	mov	0x30, %r26
	.word 0xd6b7e000  ! 906: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	mov	0x7d0, %r22
	mov	0x38, %r25
	.word 0xdef7ce40  ! 909: STXA_R	stxa	%r15, [%r31 + %r0] 0x72
	.word 0xd28f2000  ! 910: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	mov	0x60, %r17
	.word 0xd2bc4400  ! 912: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0xdaf70e60  ! 913: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	mov	0x40, %r19
	.word 0x87802020  ! 915: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 916: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r18
	.word 0xd2c46000  ! 918: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0x87802072  ! 919: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r18
	.word 0xd2d76000  ! 921: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0xd2876000  ! 922: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xd6f40400  ! 923: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	mov	0x30, %r27
	mov	0x30, %r26
	.word 0xd8bd84a0  ! 926: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	.word 0xd8bf0e40  ! 927: STDA_R	stda	%r12, [%r28 + %r0] 0x72
	.word 0xd6b7e000  ! 928: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 929: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d78e60  ! 930: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r9
	.word 0x87802072  ! 931: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc84a000  ! 932: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	.word 0xdccc2000  ! 933: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r14
	.word 0xdc9ca000  ! 934: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r14
	.word 0xd4874e60  ! 935: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r10
	mov	0x58, %r26
	.word 0xdc9c0400  ! 937: LDDA_R	ldda	[%r16, %r0] 0x20, %r14
	.word 0x87802073  ! 938: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2d5e000  ! 939: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r9
	mov	0x30, %r16
	.word 0xd09fce60  ! 941: LDDA_R	ldda	[%r31, %r0] 0x73, %r8
	mov	0x48, %r26
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcd5a000  ! 944: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r14
	.word 0x87802074  ! 945: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8cfce60  ! 946: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r12
	.word 0xdaf7a000  ! 947: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xd69f8e40  ! 948: LDDA_R	ldda	[%r30, %r0] 0x72, %r11
	.word 0xdebf6000  ! 949: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xdea7e000  ! 950: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 951: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 952: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9c8400  ! 953: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	.word 0xd88e6000  ! 954: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r12
	mov	0x50, %r24
	.word 0xdecf8e60  ! 956: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r15
	.word 0xde87ce60  ! 957: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r15
	mov	0x3d0, %r20
	.word 0xd2b66000  ! 959: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	.word 0xd286e000  ! 960: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r9
	mov	0x3e0, %r21
	mov	0x7d8, %r20
	.word 0xd2f62000  ! 963: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	mov	0x28, %r25
	.word 0x87802020  ! 965: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r17
	.word 0xd88d44a0  ! 967: LDUBA_R	lduba	[%r21, %r0] 0x25, %r12
	mov	0x7c8, %r21
	.word 0xd88d44a0  ! 969: LDUBA_R	lduba	[%r21, %r0] 0x25, %r12
	mov	0x60, %r17
	.word 0xd8c72000  ! 971: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd0a649e0  ! 972: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	.word 0xd4c70e80  ! 973: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r10
	.word 0xd0872000  ! 974: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xd4b689e0  ! 975: STHA_R	stha	%r10, [%r26 + %r0] 0x4f
	.word 0xd6d609e0  ! 976: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r11
	mov	0x30, %r25
	.word 0xdaaf4e60  ! 978: STBA_R	stba	%r13, [%r29 + %r0] 0x73
	mov	0x3c8, %r21
	.word 0xdcf7a000  ! 980: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xdccfa000  ! 981: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xd4c6c9e0  ! 982: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r10
	.word 0x8780204f  ! 983: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b6c9e0  ! 984: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0xdaadc4a0  ! 985: STBA_R	stba	%r13, [%r23 + %r0] 0x25
	.word 0xdecca000  ! 986: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	.word 0xdebfce60  ! 987: STDA_R	stda	%r15, [%r31 + %r0] 0x73
	mov	0x78, %r16
	.word 0xd4b4a000  ! 989: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0xde9fce60  ! 990: LDDA_R	ldda	[%r31, %r0] 0x73, %r15
	.word 0xd684e000  ! 991: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r11
	.word 0x87802020  ! 992: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6aca000  ! 993: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xd6d46000  ! 994: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r11
	mov	0x10, %r17
	.word 0x87802072  ! 996: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6ad2000  ! 997: STBA_I	stba	%r11, [%r20 + 0x0000] %asi
	.word 0x87802072  ! 998: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd48e09e0  ! 999: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r10
	.word 0xdabde000  ! 1000: STDA_I	stda	%r13, [%r23 + 0x0000] %asi
	mov	0x3f8, %r23
	mov	0x8, %r16
	mov	0x18, %r17
	.word 0xdcacc400  ! 1004: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0x87802025  ! 1005: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r26
	.word 0xdadf8e60  ! 1007: LDXA_R	ldxa	[%r30, %r0] 0x73, %r13
	.word 0xdebf0e60  ! 1008: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	.word 0xd4b70e60  ! 1009: STHA_R	stha	%r10, [%r28 + %r0] 0x73
	.word 0xd2b66000  ! 1010: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	.word 0xd29e2000  ! 1011: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r9
	.word 0xd2bfce60  ! 1012: STDA_R	stda	%r9, [%r31 + %r0] 0x73
	.word 0x87802074  ! 1013: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a6c9e0  ! 1014: STWA_R	stwa	%r10, [%r27 + %r0] 0x4f
	.word 0xde96c9e0  ! 1015: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r15
	mov	0x3f0, %r21
	.word 0xd89fce60  ! 1017: LDDA_R	ldda	[%r31, %r0] 0x73, %r12
	.word 0xd6c7a000  ! 1018: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	.word 0xd69f2000  ! 1019: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xd6a76000  ! 1020: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xda874e60  ! 1021: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r13
	.word 0xd6c40400  ! 1022: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r11
	.word 0x87802072  ! 1023: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef544a0  ! 1024: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	.word 0xd6bf4e40  ! 1025: STDA_R	stda	%r11, [%r29 + %r0] 0x72
	mov	0x7c0, %r20
	.word 0xdecf8e60  ! 1027: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r15
	.word 0xdac66000  ! 1028: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r13
	.word 0xdeb689e0  ! 1029: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 1030: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0dc4400  ! 1031: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	mov	0x7f8, %r22
	.word 0xd8f62000  ! 1033: STXA_I	stxa	%r12, [%r24 + 0x0000] %asi
	.word 0xd8b6a000  ! 1034: STHA_I	stha	%r12, [%r26 + 0x0000] %asi
	.word 0xda9f0e60  ! 1035: LDDA_R	ldda	[%r28, %r0] 0x73, %r13
	.word 0xd8cea000  ! 1036: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r12
	.word 0xd8d66000  ! 1037: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r12
	mov	0x30, %r16
	mov	0x18, %r27
	.word 0xd8de6000  ! 1040: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r12
	.word 0xdcd44400  ! 1041: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	.word 0x8780204f  ! 1042: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r26
	.word 0xdca5e000  ! 1044: STWA_I	stwa	%r14, [%r23 + 0x0000] %asi
	.word 0xdc8da000  ! 1045: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r14
	.word 0xdc9d6000  ! 1046: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r14
	.word 0xdca5e000  ! 1047: STWA_I	stwa	%r14, [%r23 + 0x0000] %asi
	.word 0xdc8d6000  ! 1048: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r14
	.word 0xd0b70e60  ! 1049: STHA_R	stha	%r8, [%r28 + %r0] 0x73
	.word 0x8780204f  ! 1050: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 1051: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdedf8e40  ! 1052: LDXA_R	ldxa	[%r30, %r0] 0x72, %r15
	.word 0xd2bfe000  ! 1053: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd2976000  ! 1054: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	mov	0x10, %r19
	.word 0xd2d72000  ! 1056: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xda8cc400  ! 1057: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	.word 0xd8f74e60  ! 1058: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	.word 0x87802020  ! 1059: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r17
	.word 0x87802020  ! 1061: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf584a0  ! 1062: STXA_R	stxa	%r14, [%r22 + %r0] 0x25
	.word 0x87802020  ! 1063: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r21
	.word 0xd2f5e000  ! 1065: STXA_I	stxa	%r9, [%r23 + 0x0000] %asi
	.word 0xd2cde000  ! 1066: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r9
	.word 0xd28d2000  ! 1067: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r9
	.word 0xdcbe09e0  ! 1068: STDA_R	stda	%r14, [%r24 + %r0] 0x4f
	.word 0xd8f5e000  ! 1069: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	mov	0x48, %r17
	mov	0x18, %r17
	.word 0xd6f7ce80  ! 1072: STXA_R	stxa	%r11, [%r31 + %r0] 0x74
	.word 0xd2ade000  ! 1073: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	mov	0x50, %r25
	.word 0xd2c7ce80  ! 1075: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r9
	mov	0x3c0, %r22
	.word 0x87802074  ! 1077: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r16
	.word 0x87802025  ! 1079: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2ce2000  ! 1080: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1081: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0974e80  ! 1082: LDUHA_R	lduha	[%r29, %r0] 0x74, %r8
	.word 0x87802074  ! 1083: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0af4e80  ! 1084: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	.word 0xd29c6000  ! 1085: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	.word 0xd2b4e000  ! 1086: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 1087: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2bd2000  ! 1089: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	mov	0x20, %r17
	.word 0x87802073  ! 1091: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 1092: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2bfe000  ! 1093: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd2c76000  ! 1094: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0xdcdcc400  ! 1095: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	.word 0xdaa7a000  ! 1096: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xda8f6000  ! 1097: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xdaf7e000  ! 1098: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 1099: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 1100: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde95c4a0  ! 1101: LDUHA_R	lduha	[%r23, %r0] 0x25, %r15
	.word 0xd4df6000  ! 1102: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4f72000  ! 1103: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 1104: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f48400  ! 1105: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xd89fe000  ! 1106: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0xd8dfe000  ! 1107: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	mov	0x20, %r27
	.word 0xd8972000  ! 1109: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	mov	0x50, %r17
	mov	0x48, %r18
	mov	0x28, %r19
	.word 0xd8afa000  ! 1113: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	mov	0x7f0, %r23
	mov	0x3e0, %r20
	.word 0xd8a72000  ! 1116: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd6b78e60  ! 1117: STHA_R	stha	%r11, [%r30 + %r0] 0x73
	mov	0x3c8, %r22
	mov	0x50, %r19
	mov	0x3c0, %r22
	.word 0x87802020  ! 1121: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r25
	.word 0x87802020  ! 1123: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebd2000  ! 1124: STDA_I	stda	%r15, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 1125: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde8c2000  ! 1126: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	.word 0xdeaca000  ! 1127: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xd6d649e0  ! 1128: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r11
	.word 0xdcb74e80  ! 1129: STHA_R	stha	%r14, [%r29 + %r0] 0x74
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2cd04a0  ! 1131: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r9
	.word 0xd6870e60  ! 1132: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r11
	.word 0xd6f46000  ! 1133: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0xd6ace000  ! 1134: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	mov	0x58, %r17
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6d4a000  ! 1137: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r11
	.word 0xd694e000  ! 1138: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r11
	.word 0xd6cce000  ! 1139: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r11
	mov	0x3f8, %r21
	.word 0xd0b74e60  ! 1141: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	.word 0xd4afce60  ! 1142: STBA_R	stba	%r10, [%r31 + %r0] 0x73
	.word 0xd6974e60  ! 1143: LDUHA_R	lduha	[%r29, %r0] 0x73, %r11
	.word 0xd4cc6000  ! 1144: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	.word 0xd6bd44a0  ! 1145: STDA_R	stda	%r11, [%r21 + %r0] 0x25
	mov	0x38, %r24
	.word 0x87802072  ! 1147: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f0, %r22
	.word 0xd6bd6000  ! 1149: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0xd6dd2000  ! 1150: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r11
	.word 0xd096c9e0  ! 1151: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r8
	.word 0xd6a44400  ! 1152: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0xd0b56000  ! 1153: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	.word 0xd0ada000  ! 1154: STBA_I	stba	%r8, [%r22 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x7e0, %r20
	.word 0xd4ad44a0  ! 1157: STBA_R	stba	%r10, [%r21 + %r0] 0x25
	.word 0xdca48400  ! 1158: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	mov	0x68, %r24
	mov	0x40, %r27
	.word 0xdadde000  ! 1161: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1162: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8870e60  ! 1163: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r12
	.word 0x87802020  ! 1164: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f44400  ! 1165: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd0846000  ! 1166: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	ta	T_CHANGE_PRIV	! macro
	.word 0xd4ad44a0  ! 1168: STBA_R	stba	%r10, [%r21 + %r0] 0x25
	mov	0x8, %r16
	.word 0xd0bfce40  ! 1170: STDA_R	stda	%r8, [%r31 + %r0] 0x72
	mov	0x38, %r17
	.word 0xd4bce000  ! 1172: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 1173: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d7e000  ! 1174: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	mov	0x3e8, %r21
	.word 0xd8bec9e0  ! 1176: STDA_R	stda	%r12, [%r27 + %r0] 0x4f
	mov	0x10, %r25
	mov	0x58, %r16
	.word 0xd89fe000  ! 1179: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0xd887a000  ! 1180: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8dfa000  ! 1181: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd89f6000  ! 1182: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	mov	0x7e0, %r22
	.word 0x87802074  ! 1184: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d8, %r21
	.word 0xd8cd44a0  ! 1186: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r12
	.word 0x87802025  ! 1187: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r24
	.word 0xd88cc400  ! 1189: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	.word 0xd284c400  ! 1190: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r9
	.word 0x87802020  ! 1191: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bf8e60  ! 1192: STDA_R	stda	%r9, [%r30 + %r0] 0x73
	.word 0xd8976000  ! 1193: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	mov	0x7e8, %r21
	mov	0x7c8, %r23
	.word 0xd8d44400  ! 1196: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	.word 0xd8b7e000  ! 1197: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	mov	0x0, %r17
	.word 0x87802020  ! 1199: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d4a000  ! 1200: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	mov	0x3f8, %r22
	mov	0x10, %r24
	.word 0xd8d4e000  ! 1203: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1204: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d72000  ! 1205: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0x87802073  ! 1206: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r18
	.word 0x8780204f  ! 1208: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b70e80  ! 1209: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	.word 0xd8ace000  ! 1210: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 1211: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f584a0  ! 1212: STXA_R	stxa	%r10, [%r22 + %r0] 0x25
	.word 0xd8ac8400  ! 1213: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0xd4bfa000  ! 1214: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd4af6000  ! 1215: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xd4dfe000  ! 1217: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd48fe000  ! 1218: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0x87802025  ! 1219: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4bfe000  ! 1220: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd4cf2000  ! 1221: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	mov	0x68, %r24
	.word 0xdcde49e0  ! 1223: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r14
	.word 0xd4df4e40  ! 1224: LDXA_R	ldxa	[%r29, %r0] 0x72, %r10
	.word 0xd2bf0e80  ! 1225: STDA_R	stda	%r9, [%r28 + %r0] 0x74
	mov	0x7e8, %r20
	.word 0xd2b7a000  ! 1227: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd68fce80  ! 1228: LDUBA_R	lduba	[%r31, %r0] 0x74, %r11
	mov	0x60, %r18
	mov	0x60, %r25
	.word 0xd4872000  ! 1231: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4af6000  ! 1232: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xdeaf4e40  ! 1233: STBA_R	stba	%r15, [%r29 + %r0] 0x72
	.word 0xdedf2000  ! 1234: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	mov	0x3f8, %r21
	mov	0x28, %r25
	.word 0xd09d44a0  ! 1237: LDDA_R	ldda	[%r21, %r0] 0x25, %r8
	mov	0x3d0, %r23
	.word 0xd4f544a0  ! 1239: STXA_R	stxa	%r10, [%r21 + %r0] 0x25
	.word 0xd8afce40  ! 1240: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	.word 0xd0df6000  ! 1241: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdab4c400  ! 1243: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xd0b78e80  ! 1244: STHA_R	stha	%r8, [%r30 + %r0] 0x74
	.word 0xdcf40400  ! 1245: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xd4bf2000  ! 1246: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 1247: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r27
	.word 0xde8c8400  ! 1249: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	mov	0x28, %r24
	.word 0xd6ce49e0  ! 1251: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r11
	mov	0x7d8, %r22
	.word 0xd49609e0  ! 1253: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r10
	.word 0xdcf5a000  ! 1254: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	.word 0xdcd52000  ! 1255: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r14
	.word 0xd4a48400  ! 1256: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0x87802025  ! 1257: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0bca000  ! 1258: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0xd2c609e0  ! 1259: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r9
	.word 0xd4b4a000  ! 1260: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0xd4842000  ! 1261: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	.word 0xd2848400  ! 1262: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r9
	.word 0xdef7ce40  ! 1263: STXA_R	stxa	%r15, [%r31 + %r0] 0x72
	mov	0x7d0, %r20
	.word 0x87802025  ! 1265: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf4c400  ! 1266: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	mov	0x3e8, %r21
	.word 0xd0dfa000  ! 1268: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0x87802073  ! 1269: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd096a000  ! 1270: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r8
	mov	0x3e8, %r22
	.word 0xd0962000  ! 1272: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r8
	.word 0xd0b66000  ! 1273: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	.word 0x8780204f  ! 1274: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2d70e40  ! 1275: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r9
	.word 0xd4bf4e60  ! 1276: STDA_R	stda	%r10, [%r29 + %r0] 0x73
	mov	0x70, %r16
	mov	0x18, %r24
	.word 0x8780204f  ! 1279: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 1280: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r26
	mov	0x3d8, %r21
	.word 0x87802073  ! 1283: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdad76000  ! 1284: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1285: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d40400  ! 1286: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	.word 0xdaf66000  ! 1287: STXA_I	stxa	%r13, [%r25 + 0x0000] %asi
	.word 0xd8bc0400  ! 1288: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xde8544a0  ! 1289: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r15
	.word 0xd49c8400  ! 1290: LDDA_R	ldda	[%r18, %r0] 0x20, %r10
	.word 0xd4b74e40  ! 1291: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	.word 0xdef4c400  ! 1292: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	mov	0x3f0, %r20
	mov	0x40, %r16
	.word 0xd6bcc400  ! 1295: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0x87802020  ! 1296: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r17
	.word 0xd29f0e80  ! 1298: LDDA_R	ldda	[%r28, %r0] 0x74, %r9
	.word 0xd2a46000  ! 1299: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd8dcc400  ! 1300: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	.word 0x87802074  ! 1301: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r18
	.word 0xdaf544a0  ! 1303: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	mov	0x50, %r24
	.word 0xd6cce000  ! 1305: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r11
	.word 0xd6b42000  ! 1306: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	mov	0x30, %r27
	.word 0xd0cfce40  ! 1308: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r8
	mov	0x0, %r18
	.word 0xdab4e000  ! 1310: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xdacc6000  ! 1311: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1312: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r23
	.word 0xdad4a000  ! 1314: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0xde874e80  ! 1315: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r15
	.word 0x87802073  ! 1316: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd887a000  ! 1317: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0x87802072  ! 1318: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8bfa000  ! 1319: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd8f74e80  ! 1320: STXA_R	stxa	%r12, [%r29 + %r0] 0x74
	.word 0xd0f7e000  ! 1321: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xdabc4400  ! 1322: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xda9fa000  ! 1323: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xd0a74e80  ! 1324: STWA_R	stwa	%r8, [%r29 + %r0] 0x74
	.word 0xde976000  ! 1325: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	mov	0x3f0, %r20
	.word 0xd2c7ce40  ! 1327: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r9
	.word 0xd6b44400  ! 1328: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xd0dfa000  ! 1329: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	mov	0x3f0, %r22
	.word 0xdeddc4a0  ! 1331: LDXA_R	ldxa	[%r23, %r0] 0x25, %r15
	.word 0xd4c7ce40  ! 1332: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r10
	mov	0x68, %r17
	.word 0x87802025  ! 1334: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 1335: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd48fce80  ! 1336: LDUBA_R	lduba	[%r31, %r0] 0x74, %r10
	.word 0xd6f56000  ! 1337: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	mov	0x7c8, %r21
	.word 0xd6cde000  ! 1339: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r11
	mov	0x3c8, %r20
	.word 0xd4848400  ! 1341: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r10
	.word 0xd8b56000  ! 1342: STHA_I	stha	%r12, [%r21 + 0x0000] %asi
	.word 0xd8ada000  ! 1343: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0x87802025  ! 1344: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 1345: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8cf6000  ! 1346: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	mov	0x3d8, %r20
	.word 0xd2f78e60  ! 1348: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0xd6d70e60  ! 1349: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r11
	.word 0xd4cfce60  ! 1350: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r10
	mov	0x58, %r16
	mov	0x30, %r18
	.word 0xd8f7e000  ! 1353: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xdca7ce60  ! 1354: STWA_R	stwa	%r14, [%r31 + %r0] 0x73
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x3c0, %r22
	mov	0x0, %r18
	mov	0x0, %r24
	.word 0xd4dfe000  ! 1359: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802073  ! 1360: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r27
	mov	0x18, %r24
	.word 0xd48f2000  ! 1363: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0b544a0  ! 1365: STHA_R	stha	%r8, [%r21 + %r0] 0x25
	.word 0xda9f8e40  ! 1366: LDDA_R	ldda	[%r30, %r0] 0x72, %r13
	.word 0xd6af4e60  ! 1367: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	.word 0xdecf2000  ! 1368: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xd884c400  ! 1369: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	mov	0x7e8, %r23
	.word 0xdabfa000  ! 1371: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	mov	0x20, %r27
	.word 0xda9f2000  ! 1373: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xd6d48400  ! 1374: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0xdeb44400  ! 1375: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0x87802072  ! 1376: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdccd44a0  ! 1377: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r14
	mov	0x68, %r26
	mov	0x8, %r19
	.word 0x87802020  ! 1380: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b7ce60  ! 1381: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	.word 0xd28d44a0  ! 1382: LDUBA_R	lduba	[%r21, %r0] 0x25, %r9
	.word 0xdecf4e40  ! 1383: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r15
	.word 0xdccc0400  ! 1384: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r14
	.word 0x87802074  ! 1385: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1386: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1387: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc970e80  ! 1388: LDUHA_R	lduha	[%r28, %r0] 0x74, %r14
	.word 0x87802074  ! 1389: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b6c9e0  ! 1390: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	mov	0x70, %r27
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdaf42000  ! 1393: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0xdab4a000  ! 1394: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	mov	0x78, %r27
	.word 0xdcb4c400  ! 1396: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0x87802073  ! 1397: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2cc8400  ! 1398: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	mov	0x78, %r26
	mov	0x20, %r17
	.word 0xd2878e40  ! 1401: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r9
	.word 0xdecf2000  ! 1402: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xdcd70e40  ! 1403: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r14
	.word 0x87802073  ! 1404: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdacfe000  ! 1405: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0xdab7a000  ! 1406: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xd2ad84a0  ! 1407: STBA_R	stba	%r9, [%r22 + %r0] 0x25
	mov	0x7f8, %r20
	.word 0x87802072  ! 1409: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd08f4e60  ! 1410: LDUBA_R	lduba	[%r29, %r0] 0x73, %r8
	.word 0xdac74e80  ! 1411: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r13
	mov	0x20, %r24
	.word 0xd2c44400  ! 1413: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	mov	0x60, %r18
	.word 0xda87e000  ! 1415: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0xdad7a000  ! 1416: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0xda876000  ! 1417: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0xdabfa000  ! 1418: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xda9fa000  ! 1419: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xdab72000  ! 1420: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	mov	0x70, %r27
	.word 0xdad78e40  ! 1422: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r13
	.word 0xd8b7e000  ! 1423: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	mov	0x50, %r18
	mov	0x10, %r27
	.word 0xd8976000  ! 1426: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0xd8dfe000  ! 1427: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8f76000  ! 1428: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	mov	0x48, %r16
	.word 0xd8d72000  ! 1430: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1431: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bce000  ! 1432: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 1433: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 1434: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd89de000  ! 1435: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r12
	.word 0xdedc8400  ! 1436: LDXA_R	ldxa	[%r18, %r0] 0x20, %r15
	.word 0x87802073  ! 1437: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdace09e0  ! 1438: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r13
	.word 0xd2cc4400  ! 1439: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r9
	.word 0xd0af6000  ! 1440: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd0d7a000  ! 1441: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1442: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd095a000  ! 1443: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r8
	.word 0xd2b7ce60  ! 1444: STHA_R	stha	%r9, [%r31 + %r0] 0x73
	.word 0xdea74e80  ! 1445: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	mov	0x30, %r17
	.word 0xd48d2000  ! 1447: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0xd0ce49e0  ! 1448: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r8
	.word 0xd0dd6000  ! 1449: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r8
	.word 0xdeac0400  ! 1450: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	mov	0x38, %r26
	.word 0xdaada000  ! 1452: STBA_I	stba	%r13, [%r22 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xd0bfce40  ! 1454: STDA_R	stda	%r8, [%r31 + %r0] 0x72
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd695e000  ! 1456: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r11
	.word 0xd6f52000  ! 1457: STXA_I	stxa	%r11, [%r20 + 0x0000] %asi
	.word 0xd2a5c4a0  ! 1458: STWA_R	stwa	%r9, [%r23 + %r0] 0x25
	.word 0xd4f4c400  ! 1459: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd6f4c400  ! 1460: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0x87802025  ! 1461: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd29ee000  ! 1462: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r9
	.word 0xd2d48400  ! 1463: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	mov	0x28, %r24
	.word 0xdcae6000  ! 1465: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 1466: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcaf2000  ! 1467: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xd6c7ce80  ! 1468: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r11
	mov	0x3d8, %r22
	.word 0xd88c4400  ! 1470: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0xdac7a000  ! 1471: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xd4d584a0  ! 1472: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r10
	mov	0x7c8, %r21
	.word 0x87802072  ! 1474: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f544a0  ! 1475: STXA_R	stxa	%r11, [%r21 + %r0] 0x25
	mov	0x0, %r25
	mov	0x7f0, %r23
	.word 0x87802020  ! 1478: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1479: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd88f6000  ! 1480: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xd8f7a000  ! 1481: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd09f4e60  ! 1482: LDDA_R	ldda	[%r29, %r0] 0x73, %r8
	.word 0xd09f2000  ! 1483: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0xd0dfe000  ! 1484: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	mov	0x20, %r26
	.word 0xd0cfe000  ! 1486: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xd6b5c4a0  ! 1487: STHA_R	stha	%r11, [%r23 + %r0] 0x25
	.word 0xd8f7a000  ! 1488: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd4f70e40  ! 1489: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	.word 0xda970e80  ! 1490: LDUHA_R	lduha	[%r28, %r0] 0x74, %r13
	.word 0x87802074  ! 1491: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb74e60  ! 1492: STHA_R	stha	%r14, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 1493: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r27
	.word 0xd8dc8400  ! 1495: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xdad4c400  ! 1496: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xdc9e6000  ! 1497: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r14
	.word 0xd2b78e40  ! 1498: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	.word 0xd0962000  ! 1499: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r8
	.word 0xdacd44a0  ! 1500: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r13
	mov	0x60, %r18
	.word 0xdaa66000  ! 1502: STWA_I	stwa	%r13, [%r25 + 0x0000] %asi
	.word 0xdaa62000  ! 1503: STWA_I	stwa	%r13, [%r24 + 0x0000] %asi
	.word 0xdaf62000  ! 1504: STXA_I	stxa	%r13, [%r24 + 0x0000] %asi
	.word 0xde9e09e0  ! 1505: LDDA_R	ldda	[%r24, %r0] 0x4f, %r15
	.word 0xdeb70e60  ! 1506: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	.word 0xd0bee000  ! 1507: STDA_I	stda	%r8, [%r27 + 0x0000] %asi
	.word 0x87802074  ! 1508: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0cf6000  ! 1509: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	mov	0x38, %r18
	.word 0xdcbd04a0  ! 1511: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	.word 0xd2d7e000  ! 1512: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xdaafce80  ! 1513: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	.word 0xdc8fa000  ! 1514: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdc87a000  ! 1515: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcaf6000  ! 1516: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdc972000  ! 1517: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	mov	0x7f0, %r22
	.word 0xdcc72000  ! 1519: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcbf2000  ! 1520: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 1521: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbca000  ! 1522: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 1523: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r25
	.word 0xdc9f6000  ! 1525: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xd0a40400  ! 1526: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0xdcdf6000  ! 1527: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xd4d6c9e0  ! 1528: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r10
	.word 0xd8b7a000  ! 1529: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 1530: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r24
	.word 0xd8b5e000  ! 1532: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	.word 0xd88da000  ! 1533: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r12
	.word 0xd885a000  ! 1534: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r12
	.word 0xd885a000  ! 1535: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r12
	.word 0xd8b5a000  ! 1536: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	.word 0xd8f5a000  ! 1537: STXA_I	stxa	%r12, [%r22 + 0x0000] %asi
	.word 0xd8dde000  ! 1538: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r12
	mov	0x48, %r17
	.word 0xdaa70e60  ! 1540: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x48, %r24
	.word 0xd4940400  ! 1543: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	.word 0xd48c4400  ! 1544: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0xd697ce80  ! 1545: LDUHA_R	lduha	[%r31, %r0] 0x74, %r11
	.word 0xd8c40400  ! 1546: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	.word 0xd09da000  ! 1547: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r8
	mov	0x48, %r25
	.word 0xd0952000  ! 1549: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r8
	.word 0xd0bd6000  ! 1550: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0xd0c5e000  ! 1551: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r8
	.word 0x87802074  ! 1552: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r20
	mov	0x3d0, %r21
	.word 0xd0ac2000  ! 1555: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xdacdc4a0  ! 1556: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r13
	.word 0xd6bc6000  ! 1557: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0xd4840400  ! 1559: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	mov	0x7e8, %r20
	.word 0xd2dc0400  ! 1561: LDXA_R	ldxa	[%r16, %r0] 0x20, %r9
	.word 0xde8fce60  ! 1562: LDUBA_R	lduba	[%r31, %r0] 0x73, %r15
	.word 0xd6a4c400  ! 1563: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0xd6bca000  ! 1564: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	.word 0xd8a5c4a0  ! 1565: STWA_R	stwa	%r12, [%r23 + %r0] 0x25
	.word 0xd6b609e0  ! 1566: STHA_R	stha	%r11, [%r24 + %r0] 0x4f
	.word 0xd4dc2000  ! 1567: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	.word 0xd6a7ce80  ! 1568: STWA_R	stwa	%r11, [%r31 + %r0] 0x74
	.word 0x87802073  ! 1569: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeac8400  ! 1570: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xd4d4c400  ! 1571: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0xdc97e000  ! 1572: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xdcf7a000  ! 1573: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0xdccfe000  ! 1575: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xda9fce80  ! 1576: LDDA_R	ldda	[%r31, %r0] 0x74, %r13
	.word 0xd0c7a000  ! 1577: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xd087a000  ! 1578: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	mov	0x3c8, %r23
	mov	0x40, %r26
	.word 0x87802020  ! 1581: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdace89e0  ! 1582: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r13
	.word 0xd0f7ce40  ! 1583: STXA_R	stxa	%r8, [%r31 + %r0] 0x72
	.word 0x87802025  ! 1584: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8f74e80  ! 1585: STXA_R	stxa	%r12, [%r29 + %r0] 0x74
	.word 0x87802025  ! 1586: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2c6a000  ! 1587: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r9
	.word 0xdef6c9e0  ! 1588: STXA_R	stxa	%r15, [%r27 + %r0] 0x4f
	.word 0xd29584a0  ! 1589: LDUHA_R	lduha	[%r22, %r0] 0x25, %r9
	.word 0x87802025  ! 1590: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 1591: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e0, %r22
	.word 0xdedf0e80  ! 1593: LDXA_R	ldxa	[%r28, %r0] 0x74, %r15
	.word 0xd6c66000  ! 1594: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r11
	.word 0xd8b74e40  ! 1595: STHA_R	stha	%r12, [%r29 + %r0] 0x72
	.word 0xdca78e60  ! 1596: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	.word 0xd4f7ce40  ! 1597: STXA_R	stxa	%r10, [%r31 + %r0] 0x72
	.word 0xd497ce60  ! 1598: LDUHA_R	lduha	[%r31, %r0] 0x73, %r10
	.word 0xdcbf8e60  ! 1599: STDA_R	stda	%r14, [%r30 + %r0] 0x73
	.word 0xde862000  ! 1600: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r15
	.word 0xdea44400  ! 1601: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xd2ac8400  ! 1602: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xd4d6e000  ! 1603: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r10
	.word 0xd4a6a000  ! 1604: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	mov	0x10, %r26
	.word 0xd48ee000  ! 1606: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r10
	mov	0x10, %r17
	.word 0x87802020  ! 1608: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48f2000  ! 1609: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0x87802073  ! 1610: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd494e000  ! 1611: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	.word 0xd4b4e000  ! 1612: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xd4f42000  ! 1614: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 1615: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2df4e60  ! 1616: LDXA_R	ldxa	[%r29, %r0] 0x73, %r9
	mov	0x7e0, %r20
	.word 0xd8af0e60  ! 1618: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	.word 0xdeb689e0  ! 1619: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	.word 0x8780204f  ! 1620: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc976000  ! 1621: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	mov	0x18, %r24
	mov	0x7f0, %r22
	.word 0xdebf0e40  ! 1624: STDA_R	stda	%r15, [%r28 + %r0] 0x72
	mov	0x68, %r27
	.word 0xd8c7e000  ! 1626: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	mov	0x70, %r17
	.word 0xd887a000  ! 1628: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0x87802073  ! 1629: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8afa000  ! 1630: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8df2000  ! 1632: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8bfa000  ! 1633: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd8af2000  ! 1634: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xd2afce40  ! 1635: STBA_R	stba	%r9, [%r31 + %r0] 0x72
	.word 0xdaa40400  ! 1636: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0xdea7a000  ! 1637: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xd2f70e40  ! 1638: STXA_R	stxa	%r9, [%r28 + %r0] 0x72
	.word 0xdacfe000  ! 1639: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0xdaa504a0  ! 1640: STWA_R	stwa	%r13, [%r20 + %r0] 0x25
	.word 0x87802072  ! 1641: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7c8, %r20
	.word 0x87802020  ! 1643: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f6a000  ! 1644: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	.word 0xd4f6a000  ! 1645: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	.word 0xd0acc400  ! 1646: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	mov	0x7e8, %r20
	.word 0xd6f689e0  ! 1648: STXA_R	stxa	%r11, [%r26 + %r0] 0x4f
	.word 0xd48ea000  ! 1649: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r10
	.word 0xd48e6000  ! 1650: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r10
	.word 0x87802072  ! 1651: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4942000  ! 1652: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r10
	.word 0xd8dc0400  ! 1653: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0xd0f46000  ! 1654: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	mov	0x20, %r17
	.word 0xd49689e0  ! 1656: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r10
	.word 0xd6ac8400  ! 1657: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 1658: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde8fa000  ! 1659: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0x87802072  ! 1660: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 1661: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde8f2000  ! 1662: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xdea74e80  ! 1663: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	mov	0x48, %r27
	.word 0xd887e000  ! 1665: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0xdeb7ce80  ! 1666: STHA_R	stha	%r15, [%r31 + %r0] 0x74
	mov	0x60, %r24
	.word 0xd0df6000  ! 1668: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0xd2f40400  ! 1669: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xd89d84a0  ! 1670: LDDA_R	ldda	[%r22, %r0] 0x25, %r12
	mov	0x20, %r18
	mov	0x48, %r18
	.word 0x87802020  ! 1673: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8cf0e40  ! 1674: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r12
	mov	0x18, %r26
	mov	0x7f8, %r23
	.word 0xd6a504a0  ! 1677: STWA_R	stwa	%r11, [%r20 + %r0] 0x25
	.word 0x87802074  ! 1678: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 1679: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2ac0400  ! 1680: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0x87802020  ! 1681: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebf0e40  ! 1682: STDA_R	stda	%r15, [%r28 + %r0] 0x72
	.word 0xd0bce000  ! 1683: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 1684: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a5e000  ! 1685: STWA_I	stwa	%r8, [%r23 + 0x0000] %asi
	.word 0xd0f5e000  ! 1686: STXA_I	stxa	%r8, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 1687: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0c42000  ! 1688: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r8
	.word 0xd6b48400  ! 1689: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0x87802020  ! 1690: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9f6000  ! 1691: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xdaad04a0  ! 1692: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	mov	0x30, %r26
	.word 0xdca72000  ! 1694: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xd4b544a0  ! 1695: STHA_R	stha	%r10, [%r21 + %r0] 0x25
	mov	0x60, %r26
	.word 0xdc8544a0  ! 1697: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r14
	mov	0x18, %r17
	.word 0xd09dc4a0  ! 1699: LDDA_R	ldda	[%r23, %r0] 0x25, %r8
	.word 0xd2afa000  ! 1700: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2ccc400  ! 1702: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	.word 0xd2d76000  ! 1703: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0x87802073  ! 1704: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0bdc4a0  ! 1705: STDA_R	stda	%r8, [%r23 + %r0] 0x25
	.word 0xd2afa000  ! 1706: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	mov	0x68, %r25
	.word 0xd2a7e000  ! 1708: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 1709: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1710: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dde000  ! 1711: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1712: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8870e40  ! 1713: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r12
	.word 0xd6b62000  ! 1714: STHA_I	stha	%r11, [%r24 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xd696a000  ! 1716: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r11
	.word 0xdcbe49e0  ! 1717: STDA_R	stda	%r14, [%r25 + %r0] 0x4f
	.word 0xd6dea000  ! 1718: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r11
	.word 0xd4ccc400  ! 1719: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0x87802074  ! 1720: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd694c400  ! 1721: LDUHA_R	lduha	[%r19, %r0] 0x20, %r11
	.word 0xd2aea000  ! 1722: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0xdcf48400  ! 1723: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	mov	0x30, %r24
	.word 0xdeac8400  ! 1725: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xd0f689e0  ! 1726: STXA_R	stxa	%r8, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 1727: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bf2000  ! 1728: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	mov	0x28, %r19
	mov	0x7d8, %r22
	.word 0xd4a7e000  ! 1731: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xdac40400  ! 1732: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	.word 0x87802020  ! 1733: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bf4e60  ! 1734: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	.word 0xd08c6000  ! 1735: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0xdca4c400  ! 1736: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	mov	0x0, %r17
	.word 0xdcb78e40  ! 1738: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	mov	0x18, %r24
	.word 0xda9ca000  ! 1740: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	mov	0x10, %r18
	.word 0xd4a7ce60  ! 1742: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	.word 0xd4b46000  ! 1743: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xd4dc2000  ! 1744: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	mov	0x3e8, %r20
	mov	0x30, %r24
	.word 0xd8c544a0  ! 1747: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r12
	.word 0xd69f0e40  ! 1748: LDDA_R	ldda	[%r28, %r0] 0x72, %r11
	.word 0x87802073  ! 1749: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd49c8400  ! 1750: LDDA_R	ldda	[%r18, %r0] 0x20, %r10
	.word 0xdeafce80  ! 1751: STBA_R	stba	%r15, [%r31 + %r0] 0x74
	.word 0xdcf46000  ! 1752: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0xdcbce000  ! 1754: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 1755: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcdee000  ! 1756: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r14
	.word 0xdcbee000  ! 1757: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	.word 0x87802072  ! 1758: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4b7ce40  ! 1759: STHA_R	stha	%r10, [%r31 + %r0] 0x72
	mov	0x78, %r18
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd4ac8400  ! 1762: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0x87802073  ! 1763: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a42000  ! 1764: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0x87802074  ! 1766: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0af2000  ! 1767: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0dfe000  ! 1768: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0bfe000  ! 1769: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	mov	0x30, %r26
	mov	0x40, %r25
	mov	0x7e0, %r21
	.word 0xde9dc4a0  ! 1773: LDDA_R	ldda	[%r23, %r0] 0x25, %r15
	mov	0x8, %r19
	mov	0x68, %r27
	.word 0xd2cf6000  ! 1776: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	.word 0x87802072  ! 1777: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d0, %r20
	.word 0x87802074  ! 1779: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r19
	.word 0xdaa44400  ! 1781: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 1782: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r18
	.word 0x87802025  ! 1784: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c8, %r21
	.word 0xdcf40400  ! 1786: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xd2c72000  ! 1787: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2a7e000  ! 1788: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xd4bf4e60  ! 1789: STDA_R	stda	%r10, [%r29 + %r0] 0x73
	mov	0x7e8, %r21
	.word 0x8780204f  ! 1791: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2842000  ! 1792: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r9
	.word 0xd2b4a000  ! 1793: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0xd2a74e80  ! 1794: STWA_R	stwa	%r9, [%r29 + %r0] 0x74
	mov	0x78, %r26
	.word 0xd8ac6000  ! 1796: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xd8942000  ! 1797: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r12
	.word 0xd8a4e000  ! 1798: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xd8a42000  ! 1799: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	mov	0x50, %r16
	mov	0x7c0, %r22
	.word 0xd8cfce40  ! 1802: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r12
	.word 0xd4f4e000  ! 1803: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	mov	0x78, %r16
	mov	0x7f8, %r22
	.word 0xd4dfce60  ! 1806: LDXA_R	ldxa	[%r31, %r0] 0x73, %r10
	.word 0xd4ac2000  ! 1807: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	mov	0x28, %r16
	mov	0x10, %r18
	mov	0x18, %r16
	mov	0x60, %r24
	.word 0xd4bce000  ! 1812: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0xdab4c400  ! 1813: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xd4dfce40  ! 1814: LDXA_R	ldxa	[%r31, %r0] 0x72, %r10
	.word 0x87802020  ! 1815: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r26
	.word 0xd8f40400  ! 1817: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0x87802072  ! 1818: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcaf6000  ! 1819: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 1820: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f0, %r23
	.word 0x87802073  ! 1822: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd497ce60  ! 1823: LDUHA_R	lduha	[%r31, %r0] 0x73, %r10
	.word 0x87802072  ! 1824: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcdc8400  ! 1825: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	.word 0xd4dfe000  ! 1826: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4afa000  ! 1827: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xdeaf8e80  ! 1828: STBA_R	stba	%r15, [%r30 + %r0] 0x74
	.word 0xd6dfa000  ! 1829: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	mov	0x3f0, %r22
	.word 0xd6af2000  ! 1831: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x58, %r24
	.word 0xd4cf0e40  ! 1833: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r10
	.word 0xd4f4c400  ! 1834: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xdacfa000  ! 1835: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xdaaf2000  ! 1836: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdcd649e0  ! 1837: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r14
	.word 0xd4af6000  ! 1838: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xdc8c8400  ! 1839: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0xd2cf8e80  ! 1840: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r9
	.word 0x87802020  ! 1841: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcde2000  ! 1842: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r14
	mov	0x0, %r27
	.word 0x8780204f  ! 1844: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r26
	.word 0xdcc66000  ! 1846: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	.word 0x87802072  ! 1847: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2c4c400  ! 1848: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0xdad7ce40  ! 1849: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r13
	.word 0x8780204f  ! 1850: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdec4c400  ! 1851: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	.word 0xdebe89e0  ! 1852: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	.word 0xdcdec9e0  ! 1853: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r14
	.word 0x87802072  ! 1854: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 1855: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f48400  ! 1856: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0xd6a74e60  ! 1857: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	.word 0xd6c7ce40  ! 1858: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r11
	.word 0x87802020  ! 1859: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1860: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1861: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r26
	.word 0xd0c4a000  ! 1863: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	.word 0x87802073  ! 1864: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0af2000  ! 1865: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 1866: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f689e0  ! 1867: STXA_R	stxa	%r12, [%r26 + %r0] 0x4f
	.word 0xdca70e60  ! 1868: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	.word 0x87802073  ! 1869: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb44400  ! 1870: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0xdedee000  ! 1871: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r15
	mov	0x58, %r19
	.word 0xd4a40400  ! 1873: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	.word 0xdaa44400  ! 1874: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0x87802074  ! 1875: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb76000  ! 1876: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	mov	0x38, %r27
	.word 0xd6ccc400  ! 1878: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	.word 0xd8af6000  ! 1879: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	mov	0x30, %r26
	.word 0xd887e000  ! 1881: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1882: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8940400  ! 1883: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	.word 0xd2f74e80  ! 1884: STXA_R	stxa	%r9, [%r29 + %r0] 0x74
	.word 0xdcbf6000  ! 1885: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	mov	0x60, %r19
	.word 0xdcb7e000  ! 1887: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 1888: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8844400  ! 1889: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r12
	mov	0x3f0, %r23
	mov	0x0, %r17
	.word 0x87802020  ! 1892: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a40400  ! 1893: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0xd4b609e0  ! 1894: STHA_R	stha	%r10, [%r24 + %r0] 0x4f
	mov	0x78, %r16
	.word 0xdac72000  ! 1896: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0x87802025  ! 1897: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6dcc400  ! 1898: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	.word 0xd4846000  ! 1899: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 1900: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 1901: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f0, %r20
	.word 0xd4be2000  ! 1903: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	mov	0x8, %r26
	.word 0xd08fce80  ! 1905: LDUBA_R	lduba	[%r31, %r0] 0x74, %r8
	.word 0xdca62000  ! 1906: STWA_I	stwa	%r14, [%r24 + 0x0000] %asi
	.word 0xdc86a000  ! 1907: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r14
	.word 0x87802025  ! 1908: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda948400  ! 1909: LDUHA_R	lduha	[%r18, %r0] 0x20, %r13
	.word 0x87802073  ! 1910: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f609e0  ! 1911: STXA_R	stxa	%r12, [%r24 + %r0] 0x4f
	mov	0x7e8, %r23
	.word 0xdad584a0  ! 1913: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r13
	mov	0x40, %r16
	.word 0xdab62000  ! 1915: STHA_I	stha	%r13, [%r24 + 0x0000] %asi
	.word 0xdab6a000  ! 1916: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	.word 0x87802074  ! 1917: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f4c400  ! 1918: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	mov	0x3f8, %r21
	.word 0xd0d7a000  ! 1920: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	mov	0x60, %r17
	.word 0x8780204f  ! 1922: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf48400  ! 1923: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0x87802073  ! 1924: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda8ee000  ! 1925: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r13
	.word 0xda8e09e0  ! 1926: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r13
	.word 0xd49e2000  ! 1927: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r10
	.word 0xd69f0e40  ! 1928: LDDA_R	ldda	[%r28, %r0] 0x72, %r11
	.word 0xdcdea000  ! 1929: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r14
	mov	0x20, %r18
	.word 0x87802074  ! 1931: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b4c400  ! 1932: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xde9d04a0  ! 1933: LDDA_R	ldda	[%r20, %r0] 0x25, %r15
	mov	0x78, %r17
	.word 0xdc8d44a0  ! 1935: LDUBA_R	lduba	[%r21, %r0] 0x25, %r14
	.word 0xded4a000  ! 1936: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	.word 0xd29d44a0  ! 1937: LDDA_R	ldda	[%r21, %r0] 0x25, %r9
	.word 0x87802074  ! 1938: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 1939: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 1940: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdccce000  ! 1941: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r14
	.word 0xdcf46000  ! 1942: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdcbca000  ! 1943: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xd8acc400  ! 1944: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	mov	0x18, %r27
	.word 0xd8c44400  ! 1946: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r12
	.word 0xdebfce80  ! 1947: STDA_R	stda	%r15, [%r31 + %r0] 0x74
	.word 0x87802073  ! 1948: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde9c8400  ! 1949: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	.word 0xd08fe000  ! 1950: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	.word 0xd0f7e000  ! 1951: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0a72000  ! 1952: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xd69f4e60  ! 1953: LDDA_R	ldda	[%r29, %r0] 0x73, %r11
	.word 0xd8c72000  ! 1954: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	mov	0x30, %r17
	.word 0xd8b7a000  ! 1956: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xd6b4c400  ! 1957: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	mov	0x0, %r19
	.word 0xdca7a000  ! 1959: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdc87a000  ! 1960: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	mov	0x38, %r25
	mov	0x20, %r17
	.word 0xdcaf6000  ! 1963: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdec504a0  ! 1964: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r15
	.word 0xdcf40400  ! 1965: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xd2df2000  ! 1966: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd0c70e40  ! 1967: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r8
	.word 0xd0a7ce60  ! 1968: STWA_R	stwa	%r8, [%r31 + %r0] 0x73
	.word 0xda9fe000  ! 1969: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xdaa7a000  ! 1970: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xd29544a0  ! 1971: LDUHA_R	lduha	[%r21, %r0] 0x25, %r9
	.word 0x87802020  ! 1972: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r17
	.word 0xda9584a0  ! 1974: LDUHA_R	lduha	[%r22, %r0] 0x25, %r13
	.word 0xd2bfce60  ! 1975: STDA_R	stda	%r9, [%r31 + %r0] 0x73
	.word 0xd68689e0  ! 1976: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r11
	mov	0x20, %r27
	.word 0xdeb70e60  ! 1978: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	.word 0xd0d544a0  ! 1979: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r8
	.word 0xdcd46000  ! 1980: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	.word 0xd6af0e80  ! 1981: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	mov	0x60, %r27
	.word 0xd2c42000  ! 1983: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	mov	0x50, %r17
	.word 0xdab74e60  ! 1985: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	mov	0x70, %r17
	.word 0xd8bca000  ! 1987: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd2afce80  ! 1988: STBA_R	stba	%r9, [%r31 + %r0] 0x74
	.word 0x87802020  ! 1989: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc84e000  ! 1990: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r14
	mov	0x7d8, %r20
	.word 0xdccc6000  ! 1992: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	.word 0xd094c400  ! 1993: LDUHA_R	lduha	[%r19, %r0] 0x20, %r8
	.word 0xdad46000  ! 1994: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 1995: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c0, %r23
	.word 0xd89d44a0  ! 1997: LDDA_R	ldda	[%r21, %r0] 0x25, %r12
	.word 0xd4bc6000  ! 1998: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xd0d40400  ! 1999: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	.word 0x87802020  ! 2000: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r20
	.word 0xd88f2000  ! 2002: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0xd8a76000  ! 2003: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8cf2000  ! 2004: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0xd8afa000  ! 2005: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xd2bfce80  ! 2006: STDA_R	stda	%r9, [%r31 + %r0] 0x74
	.word 0xd8bf8e60  ! 2007: STDA_R	stda	%r12, [%r30 + %r0] 0x73
	.word 0xda87a000  ! 2008: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2009: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaadc4a0  ! 2010: STBA_R	stba	%r13, [%r23 + %r0] 0x25
	mov	0x48, %r17
	.word 0xdcbcc400  ! 2012: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0x87802020  ! 2013: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88fce80  ! 2014: LDUBA_R	lduba	[%r31, %r0] 0x74, %r12
	mov	0x3c0, %r23
	.word 0xde9de000  ! 2016: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r15
	.word 0xd6ae89e0  ! 2017: STBA_R	stba	%r11, [%r26 + %r0] 0x4f
	.word 0xdcd5e000  ! 2018: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r14
	.word 0xd6c649e0  ! 2019: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r11
	.word 0x8780204f  ! 2020: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6afce40  ! 2021: STBA_R	stba	%r11, [%r31 + %r0] 0x72
	.word 0xd2d74e60  ! 2022: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r9
	mov	0x7c8, %r23
	.word 0xdea584a0  ! 2024: STWA_R	stwa	%r15, [%r22 + %r0] 0x25
	.word 0xdca4e000  ! 2025: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 2026: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca4a000  ! 2027: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0xd8b6c9e0  ! 2028: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	.word 0xd8f46000  ! 2029: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xdaa74e80  ! 2030: STWA_R	stwa	%r13, [%r29 + %r0] 0x74
	.word 0x87802020  ! 2031: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r17
	.word 0x87802074  ! 2033: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b48400  ! 2034: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd29c2000  ! 2035: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	.word 0xd2c74e80  ! 2036: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r9
	.word 0xda8c6000  ! 2037: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r13
	.word 0xdaf4e000  ! 2038: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xd494c400  ! 2039: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	.word 0xdac4a000  ! 2040: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	.word 0x87802073  ! 2041: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 2042: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabda000  ! 2043: STDA_I	stda	%r13, [%r22 + 0x0000] %asi
	.word 0xda856000  ! 2044: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r13
	.word 0xda952000  ! 2045: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r13
	.word 0x87802025  ! 2046: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaa66000  ! 2047: STWA_I	stwa	%r13, [%r25 + 0x0000] %asi
	.word 0xd6bf0e60  ! 2048: STDA_R	stda	%r11, [%r28 + %r0] 0x73
	.word 0xd89ee000  ! 2049: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r12
	.word 0xd8ce6000  ! 2050: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r12
	.word 0xd8f6a000  ! 2051: STXA_I	stxa	%r12, [%r26 + 0x0000] %asi
	.word 0xd8b6e000  ! 2052: STHA_I	stha	%r12, [%r27 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0x8780204f  ! 2054: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r24
	mov	0x3d0, %r23
	.word 0xdcc70e60  ! 2057: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r14
	mov	0x18, %r24
	.word 0xd29649e0  ! 2059: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r9
	mov	0x68, %r26
	mov	0x8, %r25
	mov	0x78, %r19
	.word 0xdab7e000  ! 2063: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	mov	0x3e8, %r20
	mov	0x3c0, %r20
	.word 0x87802025  ! 2066: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c8, %r22
	.word 0xd29f4e40  ! 2068: LDDA_R	ldda	[%r29, %r0] 0x72, %r9
	.word 0xd6b40400  ! 2069: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0x87802074  ! 2070: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b76000  ! 2071: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	mov	0x30, %r25
	.word 0xd0af2000  ! 2073: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0cfa000  ! 2074: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	mov	0x10, %r27
	.word 0xd28ec9e0  ! 2076: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r9
	.word 0xd6b72000  ! 2077: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd6afa000  ! 2078: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6a72000  ! 2079: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xd6c7e000  ! 2081: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2082: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b5a000  ! 2083: STHA_I	stha	%r11, [%r22 + 0x0000] %asi
	.word 0xd6af4e80  ! 2084: STBA_R	stba	%r11, [%r29 + %r0] 0x74
	.word 0xdea5e000  ! 2085: STWA_I	stwa	%r15, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 2086: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r17
	.word 0xded66000  ! 2088: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r15
	.word 0xdaa5c4a0  ! 2089: STWA_R	stwa	%r13, [%r23 + %r0] 0x25
	.word 0xdaa504a0  ! 2090: STWA_R	stwa	%r13, [%r20 + %r0] 0x25
	mov	0x68, %r17
	.word 0xd0f66000  ! 2092: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	.word 0x87802025  ! 2093: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0b4a000  ! 2094: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xdcdf4e60  ! 2095: LDXA_R	ldxa	[%r29, %r0] 0x73, %r14
	.word 0x87802025  ! 2096: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r17
	.word 0xdca7e000  ! 2098: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcf7a000  ! 2099: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xdc9fa000  ! 2100: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0xdc97ce40  ! 2101: LDUHA_R	lduha	[%r31, %r0] 0x72, %r14
	.word 0xd2cd84a0  ! 2102: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r9
	.word 0xdeb70e40  ! 2103: STHA_R	stha	%r15, [%r28 + %r0] 0x72
	mov	0x48, %r16
	mov	0x70, %r18
	.word 0x87802073  ! 2106: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f504a0  ! 2107: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	.word 0x87802073  ! 2108: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd29f6000  ! 2109: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0x87802025  ! 2110: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e8, %r20
	.word 0x87802020  ! 2112: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2972000  ! 2113: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xd094c400  ! 2114: LDUHA_R	lduha	[%r19, %r0] 0x20, %r8
	.word 0xd8c44400  ! 2115: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r12
	.word 0xd2d7a000  ! 2116: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0x87802072  ! 2117: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2bea000  ! 2118: STDA_I	stda	%r9, [%r26 + 0x0000] %asi
	.word 0xd2866000  ! 2119: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r9
	.word 0xd2a70e40  ! 2120: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	.word 0xd8ae2000  ! 2121: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	.word 0xdcb70e60  ! 2122: STHA_R	stha	%r14, [%r28 + %r0] 0x73
	.word 0xd4d6e000  ! 2123: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r10
	mov	0x3f8, %r22
	.word 0xdaa70e60  ! 2125: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	.word 0xd8f6e000  ! 2126: STXA_I	stxa	%r12, [%r27 + 0x0000] %asi
	.word 0xdca7ce80  ! 2127: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	.word 0x87802020  ! 2128: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c7e000  ! 2129: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	mov	0x3d8, %r22
	.word 0xd4cf6000  ! 2131: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	mov	0x7d0, %r20
	mov	0x3f8, %r21
	.word 0x87802020  ! 2134: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r16
	.word 0xdeaf8e40  ! 2136: STBA_R	stba	%r15, [%r30 + %r0] 0x72
	.word 0xdc9da000  ! 2137: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r14
	.word 0xd4844400  ! 2138: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0xd6d52000  ! 2139: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r11
	mov	0x50, %r16
	mov	0x70, %r25
	mov	0x60, %r19
	.word 0xd8a4c400  ! 2143: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	mov	0x38, %r17
	mov	0x20, %r27
	.word 0xd8b544a0  ! 2146: STHA_R	stha	%r12, [%r21 + %r0] 0x25
	.word 0xd0c74e60  ! 2147: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r8
	mov	0x50, %r27
	.word 0xda948400  ! 2149: LDUHA_R	lduha	[%r18, %r0] 0x20, %r13
	.word 0xd0f5a000  ! 2150: STXA_I	stxa	%r8, [%r22 + 0x0000] %asi
	.word 0xd2b609e0  ! 2151: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	mov	0x3d8, %r22
	mov	0x3e0, %r22
	.word 0x87802020  ! 2154: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r17
	.word 0xdaf66000  ! 2156: STXA_I	stxa	%r13, [%r25 + 0x0000] %asi
	.word 0xda96c9e0  ! 2157: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r13
	.word 0xdcac8400  ! 2158: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xdeaee000  ! 2159: STBA_I	stba	%r15, [%r27 + 0x0000] %asi
	mov	0x78, %r25
	.word 0xde8e2000  ! 2161: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r15
	mov	0x3c8, %r22
	.word 0xdeb62000  ! 2163: STHA_I	stha	%r15, [%r24 + 0x0000] %asi
	.word 0xd4878e40  ! 2164: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r10
	.word 0xda970e80  ! 2165: LDUHA_R	lduha	[%r28, %r0] 0x74, %r13
	mov	0x0, %r25
	.word 0xdcde6000  ! 2167: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r14
	.word 0xdcbe6000  ! 2168: STDA_I	stda	%r14, [%r25 + 0x0000] %asi
	.word 0xdcaea000  ! 2169: STBA_I	stba	%r14, [%r26 + 0x0000] %asi
	mov	0x3d0, %r22
	mov	0x60, %r16
	.word 0xdcb6a000  ! 2172: STHA_I	stha	%r14, [%r26 + 0x0000] %asi
	mov	0x58, %r26
	.word 0xdcb6a000  ! 2174: STHA_I	stha	%r14, [%r26 + 0x0000] %asi
	.word 0xde8dc4a0  ! 2175: LDUBA_R	lduba	[%r23, %r0] 0x25, %r15
	.word 0xd29544a0  ! 2176: LDUHA_R	lduha	[%r21, %r0] 0x25, %r9
	.word 0xd296a000  ! 2177: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r9
	.word 0xdca689e0  ! 2178: STWA_R	stwa	%r14, [%r26 + %r0] 0x4f
	mov	0x8, %r27
	.word 0xda9f8e60  ! 2180: LDDA_R	ldda	[%r30, %r0] 0x73, %r13
	.word 0x87802072  ! 2181: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0a48400  ! 2182: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	mov	0x50, %r17
	.word 0xd4c76000  ! 2184: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	.word 0x87802020  ! 2185: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bcc400  ! 2186: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0xd2a74e40  ! 2187: STWA_R	stwa	%r9, [%r29 + %r0] 0x72
	.word 0xdca6e000  ! 2188: STWA_I	stwa	%r14, [%r27 + 0x0000] %asi
	mov	0x18, %r16
	.word 0xdcaea000  ! 2190: STBA_I	stba	%r14, [%r26 + 0x0000] %asi
	.word 0xdca66000  ! 2191: STWA_I	stwa	%r14, [%r25 + 0x0000] %asi
	.word 0xdcbee000  ! 2192: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	.word 0xdc9ee000  ! 2193: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r14
	mov	0x7c8, %r22
	mov	0x0, %r16
	mov	0x40, %r27
	.word 0xdc9c0400  ! 2197: LDDA_R	ldda	[%r16, %r0] 0x20, %r14
	mov	0x7e8, %r23
	mov	0x30, %r27
	mov	0x3d0, %r23
	.word 0xd0bfce80  ! 2201: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	.word 0xd08c4400  ! 2202: LDUBA_R	lduba	[%r17, %r0] 0x20, %r8
	.word 0x8780204f  ! 2203: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0cc4400  ! 2204: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	.word 0xde872000  ! 2205: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xd4c7ce40  ! 2206: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r10
	.word 0x87802020  ! 2207: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a70e80  ! 2208: STWA_R	stwa	%r9, [%r28 + %r0] 0x74
	.word 0xd8972000  ! 2209: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	.word 0x87802074  ! 2210: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d8, %r20
	.word 0xda8ec9e0  ! 2212: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r13
	.word 0xd4b7ce80  ! 2213: STHA_R	stha	%r10, [%r31 + %r0] 0x74
	.word 0xd88584a0  ! 2214: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r12
	.word 0xd6df8e80  ! 2215: LDXA_R	ldxa	[%r30, %r0] 0x74, %r11
	mov	0x8, %r25
	.word 0xdadf6000  ! 2217: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xdeb78e60  ! 2218: STHA_R	stha	%r15, [%r30 + %r0] 0x73
	.word 0xd4f7a000  ! 2219: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 2220: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4cf6000  ! 2221: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0xd2f40400  ! 2222: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	mov	0x68, %r19
	.word 0x87802072  ! 2224: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8c649e0  ! 2225: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r12
	mov	0x7d0, %r22
	.word 0xd0b7ce40  ! 2227: STHA_R	stha	%r8, [%r31 + %r0] 0x72
	.word 0xd4cf6000  ! 2228: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0xd4bf2000  ! 2229: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd4bfe000  ! 2230: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x40, %r27
	.word 0xd0974e80  ! 2232: LDUHA_R	lduha	[%r29, %r0] 0x74, %r8
	mov	0x18, %r17
	.word 0xdc8d04a0  ! 2234: LDUBA_R	lduba	[%r20, %r0] 0x25, %r14
	.word 0xdab74e80  ! 2235: STHA_R	stha	%r13, [%r29 + %r0] 0x74
	.word 0xd6bf6000  ! 2236: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd4bc8400  ! 2237: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	.word 0xdaafa000  ! 2238: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdacf2000  ! 2239: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xd6de49e0  ! 2240: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r11
	.word 0x87802074  ! 2241: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd4d6e000  ! 2243: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r10
	mov	0x70, %r19
	.word 0xd6d4c400  ! 2245: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	.word 0x87802020  ! 2246: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b584a0  ! 2247: STHA_R	stha	%r11, [%r22 + %r0] 0x25
	.word 0xdacc0400  ! 2248: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r13
	.word 0x87802025  ! 2249: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8848400  ! 2250: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r12
	.word 0xdace09e0  ! 2251: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r13
	.word 0xd8dee000  ! 2252: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r12
	.word 0xd886e000  ! 2253: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r12
	.word 0xd0cf8e60  ! 2254: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r8
	.word 0xd8ce6000  ! 2255: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r12
	.word 0xd8a6e000  ! 2256: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	.word 0xd8b78e80  ! 2257: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	mov	0x10, %r27
	mov	0x7f0, %r23
	mov	0x70, %r16
	.word 0xd0cea000  ! 2261: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r8
	.word 0xdcf44400  ! 2262: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xd6a4c400  ! 2263: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0xdac78e60  ! 2264: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r13
	.word 0xdeae6000  ! 2265: STBA_I	stba	%r15, [%r25 + 0x0000] %asi
	.word 0xdcae49e0  ! 2266: STBA_R	stba	%r14, [%r25 + %r0] 0x4f
	.word 0xdaa62000  ! 2267: STWA_I	stwa	%r13, [%r24 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xdad62000  ! 2269: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r13
	.word 0xdabea000  ! 2270: STDA_I	stda	%r13, [%r26 + 0x0000] %asi
	.word 0xdac62000  ! 2271: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r13
	.word 0xd8acc400  ! 2272: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0x87802020  ! 2273: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab7a000  ! 2274: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdcad04a0  ! 2275: STBA_R	stba	%r14, [%r20 + %r0] 0x25
	.word 0x87802072  ! 2276: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab78e80  ! 2277: STHA_R	stha	%r13, [%r30 + %r0] 0x74
	.word 0xd6ac0400  ! 2278: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0xd0dc2000  ! 2279: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	.word 0xd4ad44a0  ! 2280: STBA_R	stba	%r10, [%r21 + %r0] 0x25
	mov	0x3d8, %r23
	.word 0xd0d584a0  ! 2282: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r8
	mov	0x8, %r27
	mov	0x30, %r17
	.word 0xd2b78e60  ! 2285: STHA_R	stha	%r9, [%r30 + %r0] 0x73
	.word 0xd29649e0  ! 2286: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r9
	.word 0xd8ace000  ! 2287: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	mov	0x3e0, %r22
	mov	0x48, %r26
	.word 0xd8f46000  ! 2290: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xd6bf0e40  ! 2291: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	.word 0xdab544a0  ! 2292: STHA_R	stha	%r13, [%r21 + %r0] 0x25
	mov	0x3f8, %r23
	.word 0xd0a46000  ! 2294: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 2295: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd097e000  ! 2296: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xdacf4e60  ! 2297: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r13
	.word 0xd8cd04a0  ! 2298: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r12
	.word 0xdca76000  ! 2299: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xd6afce40  ! 2301: STBA_R	stba	%r11, [%r31 + %r0] 0x72
	.word 0xdaaf6000  ! 2302: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xd0bf0e40  ! 2303: STDA_R	stda	%r8, [%r28 + %r0] 0x72
	.word 0xdaa6c9e0  ! 2304: STWA_R	stwa	%r13, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 2305: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2306: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdea584a0  ! 2307: STWA_R	stwa	%r15, [%r22 + %r0] 0x25
	.word 0xd694c400  ! 2308: LDUHA_R	lduha	[%r19, %r0] 0x20, %r11
	mov	0x7d0, %r23
	.word 0xd0f5e000  ! 2310: STXA_I	stxa	%r8, [%r23 + 0x0000] %asi
	mov	0x48, %r24
	.word 0x87802020  ! 2312: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a7e000  ! 2313: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xd097e000  ! 2314: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	mov	0x3f8, %r21
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0f7a000  ! 2317: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 2318: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0af0e40  ! 2319: STBA_R	stba	%r8, [%r28 + %r0] 0x72
	.word 0x87802020  ! 2320: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad46000  ! 2321: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	.word 0xdacc6000  ! 2322: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	mov	0x48, %r24
	mov	0x0, %r18
	.word 0xda94a000  ! 2325: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	.word 0xd4a70e60  ! 2326: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	.word 0xdc842000  ! 2327: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2f7ce60  ! 2329: STXA_R	stxa	%r9, [%r31 + %r0] 0x73
	mov	0x70, %r27
	.word 0xd4b74e80  ! 2331: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	.word 0xde9ca000  ! 2332: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	mov	0x3f0, %r23
	.word 0xdec42000  ! 2334: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0x87802020  ! 2335: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2336: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2337: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc8c8400  ! 2338: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0xd6bf2000  ! 2339: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 2340: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r25
	.word 0xd6b76000  ! 2342: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xdcb544a0  ! 2343: STHA_R	stha	%r14, [%r21 + %r0] 0x25
	mov	0x3f0, %r20
	mov	0x3f0, %r22
	.word 0xd08f2000  ! 2346: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	.word 0xdadcc400  ! 2347: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	mov	0x70, %r17
	.word 0xd6b40400  ! 2349: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xdcdfa000  ! 2350: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	mov	0x7c8, %r21
	.word 0xd4844400  ! 2352: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0xd88f6000  ! 2353: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0x87802072  ! 2354: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8bfe000  ! 2355: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	mov	0x10, %r18
	.word 0xd8bf6000  ! 2357: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	mov	0x38, %r25
	.word 0xd88f6000  ! 2359: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0x87802073  ! 2360: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdec70e40  ! 2361: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r15
	.word 0xde9d44a0  ! 2362: LDDA_R	ldda	[%r21, %r0] 0x25, %r15
	mov	0x60, %r19
	.word 0x87802020  ! 2364: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r16
	.word 0xd0bec9e0  ! 2366: STDA_R	stda	%r8, [%r27 + %r0] 0x4f
	mov	0x7d0, %r21
	.word 0xd6d40400  ! 2368: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	mov	0x3d0, %r22
	mov	0x3f0, %r22
	.word 0xd286e000  ! 2371: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r9
	.word 0xd2de6000  ! 2372: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2f6e000  ! 2374: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	.word 0xd2ce6000  ! 2375: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r9
	.word 0x87802073  ! 2376: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd297a000  ! 2377: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	mov	0x68, %r18
	.word 0xd2bfa000  ! 2379: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd2df6000  ! 2380: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	mov	0x18, %r17
	.word 0xde8d84a0  ! 2382: LDUBA_R	lduba	[%r22, %r0] 0x25, %r15
	.word 0xd8be09e0  ! 2383: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	.word 0xd8d76000  ! 2384: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	mov	0x20, %r24
	.word 0xdca78e60  ! 2386: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	mov	0x50, %r18
	.word 0xd0b72000  ! 2388: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	mov	0x30, %r16
	.word 0x8780204f  ! 2390: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r18
	mov	0x7d8, %r20
	mov	0x20, %r26
	.word 0xd0f4e000  ! 2394: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 2395: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r22
	.word 0x87802020  ! 2397: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2398: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0af4e40  ! 2399: STBA_R	stba	%r8, [%r29 + %r0] 0x72
	mov	0x3f8, %r23
	mov	0x28, %r24
	mov	0x7c8, %r23
	.word 0xd0d689e0  ! 2403: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r8
	.word 0x87802020  ! 2404: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r22
	.word 0xd6dcc400  ! 2406: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	.word 0x87802072  ! 2407: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2408: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0c76000  ! 2409: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0xd2a544a0  ! 2410: STWA_R	stwa	%r9, [%r21 + %r0] 0x25
	.word 0xd28ec9e0  ! 2411: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r9
	.word 0x87802020  ! 2412: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29c4400  ! 2413: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	.word 0xd0c76000  ! 2414: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	mov	0x20, %r19
	mov	0x10, %r24
	.word 0xd0c7e000  ! 2417: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0d544a0  ! 2418: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r8
	.word 0x87802020  ! 2419: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b70e40  ! 2420: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	.word 0xdcd4a000  ! 2421: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 2422: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf72000  ! 2423: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdc876000  ! 2424: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0xdcb7a000  ! 2425: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	mov	0x7c8, %r21
	.word 0xdc876000  ! 2427: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	mov	0x68, %r17
	.word 0xdcc7a000  ! 2429: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2430: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccfa000  ! 2431: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xd6878e60  ! 2432: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r11
	.word 0xded609e0  ! 2433: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r15
	.word 0xdaf504a0  ! 2434: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	.word 0x87802020  ! 2435: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d74e80  ! 2436: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r9
	.word 0xdef72000  ! 2437: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xde876000  ! 2438: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xd2f70e40  ! 2439: STXA_R	stxa	%r9, [%r28 + %r0] 0x72
	mov	0x7f0, %r21
	mov	0x18, %r24
	.word 0xd6b76000  ! 2442: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd6f7a000  ! 2443: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 2444: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r24
	mov	0x10, %r26
	.word 0xd6b4c400  ! 2447: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xde97a000  ! 2448: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	mov	0x7d0, %r21
	mov	0x3c8, %r23
	.word 0xd4df0e40  ! 2451: LDXA_R	ldxa	[%r28, %r0] 0x72, %r10
	.word 0x87802073  ! 2452: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaacc400  ! 2453: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0x87802020  ! 2454: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f70e40  ! 2455: STXA_R	stxa	%r12, [%r28 + %r0] 0x72
	.word 0xd8afa000  ! 2456: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xd697ce80  ! 2457: LDUHA_R	lduha	[%r31, %r0] 0x74, %r11
	mov	0x48, %r26
	.word 0xdc8d84a0  ! 2459: LDUBA_R	lduba	[%r22, %r0] 0x25, %r14
	.word 0xd89fa000  ! 2460: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	.word 0xd6974e40  ! 2461: LDUHA_R	lduha	[%r29, %r0] 0x72, %r11
	.word 0xd4f76000  ! 2462: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	mov	0x7d8, %r23
	mov	0x8, %r17
	mov	0x3d0, %r21
	.word 0xdc9c0400  ! 2466: LDDA_R	ldda	[%r16, %r0] 0x20, %r14
	.word 0xd88e09e0  ! 2467: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r12
	.word 0xd2df6000  ! 2468: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0xd297e000  ! 2469: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2470: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ac6000  ! 2471: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd4bcc400  ! 2472: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	mov	0x50, %r17
	.word 0xdabce000  ! 2474: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0xd69c8400  ! 2475: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	.word 0xd4dc8400  ! 2476: LDXA_R	ldxa	[%r18, %r0] 0x20, %r10
	.word 0xd0f4e000  ! 2477: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0xd08c2000  ! 2479: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0xd0a42000  ! 2480: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xd0ac2000  ! 2481: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xd09ca000  ! 2482: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	.word 0xd0a46000  ! 2483: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	mov	0x50, %r25
	.word 0xd48689e0  ! 2485: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r10
	.word 0x87802025  ! 2486: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd08584a0  ! 2487: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r8
	.word 0x8780204f  ! 2488: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r24
	.word 0xd6d4c400  ! 2490: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	.word 0xdabc6000  ! 2491: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xd2844400  ! 2492: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	.word 0xd6f609e0  ! 2493: STXA_R	stxa	%r11, [%r24 + %r0] 0x4f
	mov	0x0, %r18
	.word 0xd2c7ce60  ! 2495: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r9
	.word 0xd694e000  ! 2496: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2497: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f7ce60  ! 2498: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	.word 0xd8bfce60  ! 2499: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	mov	0x18, %r26
	.word 0x87802025  ! 2501: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 2502: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2503: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f584a0  ! 2504: STXA_R	stxa	%r11, [%r22 + %r0] 0x25
	.word 0xd8d44400  ! 2505: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	mov	0x0, %r24
	mov	0x3e0, %r21
	.word 0xdad4e000  ! 2508: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r13
	mov	0x7f8, %r23
	.word 0xd48649e0  ! 2510: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r10
	.word 0xdebc8400  ! 2511: STDA_R	stda	%r15, [%r18 + %r0] 0x20
	.word 0x87802074  ! 2512: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bc6000  ! 2513: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0xd6adc4a0  ! 2514: STBA_R	stba	%r11, [%r23 + %r0] 0x25
	.word 0xd2b689e0  ! 2515: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	.word 0xdedd44a0  ! 2516: LDXA_R	ldxa	[%r21, %r0] 0x25, %r15
	.word 0xdec4a000  ! 2517: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 2518: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 2519: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2520: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xdea42000  ! 2522: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xdeac2000  ! 2523: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xdeb4e000  ! 2524: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0xd0f78e40  ! 2525: STXA_R	stxa	%r8, [%r30 + %r0] 0x72
	.word 0x87802020  ! 2526: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6df6000  ! 2527: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6a7a000  ! 2528: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 2529: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8bf8e40  ! 2530: STDA_R	stda	%r12, [%r30 + %r0] 0x72
	.word 0xd6b609e0  ! 2531: STHA_R	stha	%r11, [%r24 + %r0] 0x4f
	.word 0xdcac6000  ! 2532: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xd0bf4e80  ! 2533: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	.word 0xd2cca000  ! 2534: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	mov	0x3d8, %r22
	mov	0x78, %r18
	.word 0xdcb609e0  ! 2537: STHA_R	stha	%r14, [%r24 + %r0] 0x4f
	.word 0x87802025  ! 2538: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8ea000  ! 2539: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r13
	.word 0xd6c70e80  ! 2540: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r11
	mov	0x3e0, %r22
	.word 0xd4dee000  ! 2542: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r10
	.word 0xd8d78e60  ! 2543: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r12
	.word 0xd697ce80  ! 2544: LDUHA_R	lduha	[%r31, %r0] 0x74, %r11
	.word 0xd4ce2000  ! 2545: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r10
	.word 0xd4d66000  ! 2546: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r10
	.word 0xd08584a0  ! 2547: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r8
	.word 0x87802074  ! 2548: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8cc0400  ! 2549: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	.word 0xd29c4400  ! 2550: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	ta	T_CHANGE_PRIV	! macro
	mov	0x7c8, %r23
	mov	0x20, %r17
	.word 0xda952000  ! 2554: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r13
	.word 0xda952000  ! 2555: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r13
	.word 0xdaaf4e40  ! 2556: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	mov	0x7f0, %r21
	.word 0xd6cda000  ! 2558: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r11
	.word 0xd6f52000  ! 2559: STXA_I	stxa	%r11, [%r20 + 0x0000] %asi
	.word 0xdcbc4400  ! 2560: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0x87802073  ! 2561: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd49dc4a0  ! 2562: LDDA_R	ldda	[%r23, %r0] 0x25, %r10
	.word 0xde8e09e0  ! 2563: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r15
	.word 0x87802020  ! 2564: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bca000  ! 2565: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 2566: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cfe000  ! 2567: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xd0f7e000  ! 2568: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd087a000  ! 2569: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0xdaacc400  ! 2570: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0x87802073  ! 2571: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcce89e0  ! 2572: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r14
	.word 0xd2cf4e60  ! 2573: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r9
	.word 0xdacfce40  ! 2574: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r13
	mov	0x50, %r26
	.word 0xd0d6a000  ! 2576: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r8
	.word 0xd0b44400  ! 2577: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xd8be89e0  ! 2578: STDA_R	stda	%r12, [%r26 + %r0] 0x4f
	.word 0xd0cee000  ! 2579: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r8
	mov	0x50, %r18
	.word 0xd8f7ce40  ! 2581: STXA_R	stxa	%r12, [%r31 + %r0] 0x72
	mov	0x3c8, %r22
	.word 0xd2de2000  ! 2583: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r9
	.word 0xd0848400  ! 2584: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r8
	.word 0xd8c6e000  ! 2585: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r12
	.word 0xd8a4c400  ! 2586: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	mov	0x68, %r16
	.word 0xd486e000  ! 2588: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	mov	0x0, %r27
	.word 0xd4ae6000  ! 2590: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0xd4f62000  ! 2591: STXA_I	stxa	%r10, [%r24 + 0x0000] %asi
	.word 0xd49ea000  ! 2592: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	mov	0x78, %r18
	mov	0x30, %r16
	mov	0x3e0, %r22
	.word 0xd2d544a0  ! 2596: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r9
	.word 0x87802074  ! 2597: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2598: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f74e80  ! 2599: STXA_R	stxa	%r9, [%r29 + %r0] 0x74
	.word 0xdab689e0  ! 2600: STHA_R	stha	%r13, [%r26 + %r0] 0x4f
	.word 0xd29f6000  ! 2601: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xd2bf2000  ! 2602: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 2603: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a4e000  ! 2604: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 2605: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 2606: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 2607: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2b74e40  ! 2608: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	.word 0xd886e000  ! 2609: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r12
	.word 0xd88ea000  ! 2610: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r12
	.word 0xd89ea000  ! 2611: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r12
	.word 0xd896a000  ! 2612: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r12
	.word 0xdcb74e80  ! 2613: STHA_R	stha	%r14, [%r29 + %r0] 0x74
	.word 0xd8be6000  ! 2614: STDA_I	stda	%r12, [%r25 + 0x0000] %asi
	.word 0xd8ce2000  ! 2615: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r12
	mov	0x10, %r16
	mov	0x68, %r26
	.word 0x87802025  ! 2618: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r16
	.word 0xd8cc0400  ! 2620: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	.word 0xd4a6e000  ! 2621: STWA_I	stwa	%r10, [%r27 + 0x0000] %asi
	.word 0xd0c4c400  ! 2622: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	mov	0x50, %r18
	.word 0xded584a0  ! 2624: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r15
	.word 0x87802020  ! 2625: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a44400  ! 2626: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	mov	0x8, %r16
	mov	0x68, %r16
	.word 0xd8962000  ! 2629: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r12
	.word 0xd8d6e000  ! 2630: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r12
	mov	0x7e0, %r20
	.word 0xd8b66000  ! 2632: STHA_I	stha	%r12, [%r25 + 0x0000] %asi
	.word 0xd8c70e40  ! 2633: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r12
	mov	0x50, %r17
	mov	0x3c8, %r21
	.word 0xd6848400  ! 2636: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	.word 0x87802020  ! 2637: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r18
	mov	0x50, %r17
	mov	0x8, %r27
	mov	0x50, %r27
	.word 0x87802073  ! 2642: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r19
	.word 0xded78e60  ! 2644: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r15
	mov	0x68, %r16
	mov	0x58, %r27
	mov	0x7d8, %r21
	.word 0xd2c74e40  ! 2648: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r9
	.word 0xd6dd44a0  ! 2649: LDXA_R	ldxa	[%r21, %r0] 0x25, %r11
	.word 0xda87ce60  ! 2650: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r13
	mov	0x8, %r24
	.word 0xd0f6c9e0  ! 2652: STXA_R	stxa	%r8, [%r27 + %r0] 0x4f
	.word 0xd6dd2000  ! 2653: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r11
	.word 0x87802073  ! 2654: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r19
	.word 0xd6f7e000  ! 2656: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd69fa000  ! 2657: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0xdaa504a0  ! 2658: STWA_R	stwa	%r13, [%r20 + %r0] 0x25
	.word 0xd0c76000  ! 2659: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0xdedfce60  ! 2660: LDXA_R	ldxa	[%r31, %r0] 0x73, %r15
	.word 0xd0cfce80  ! 2661: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r8
	.word 0xd0ce89e0  ! 2662: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r8
	.word 0xd084c400  ! 2663: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r8
	.word 0xd48f6000  ! 2664: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	mov	0x20, %r16
	.word 0x87802074  ! 2666: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2667: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b7a000  ! 2668: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xdcf78e40  ! 2670: STXA_R	stxa	%r14, [%r30 + %r0] 0x72
	.word 0x87802025  ! 2671: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r26
	.word 0xd0cf4e40  ! 2673: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	.word 0xd6b40400  ! 2674: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xd885c4a0  ! 2675: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r12
	.word 0x8780204f  ! 2676: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a78e80  ! 2677: STWA_R	stwa	%r8, [%r30 + %r0] 0x74
	.word 0xdc9f2000  ! 2678: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xd4c48400  ! 2679: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r10
	.word 0x87802073  ! 2680: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f76000  ! 2681: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 2682: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4f44400  ! 2683: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0xdcf7e000  ! 2684: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x8, %r24
	mov	0x3d8, %r22
	mov	0x3e0, %r23
	.word 0x87802020  ! 2688: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69e09e0  ! 2689: LDDA_R	ldda	[%r24, %r0] 0x4f, %r11
	.word 0xd49544a0  ! 2690: LDUHA_R	lduha	[%r21, %r0] 0x25, %r10
	.word 0xdcdf6000  ! 2691: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcaf2000  ! 2693: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdcf76000  ! 2694: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x60, %r24
	.word 0xd2d4c400  ! 2696: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r9
	mov	0x60, %r19
	.word 0xdcf7a000  ! 2698: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xdca7a000  ! 2699: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0xd0b40400  ! 2701: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0x87802025  ! 2702: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bda000  ! 2703: STDA_I	stda	%r9, [%r22 + 0x0000] %asi
	.word 0xd2cec9e0  ! 2704: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r9
	.word 0xdeb5a000  ! 2705: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	.word 0xdead04a0  ! 2706: STBA_R	stba	%r15, [%r20 + %r0] 0x25
	.word 0x87802074  ! 2707: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef7a000  ! 2708: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xd0f44400  ! 2709: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd494c400  ! 2710: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	.word 0xd4bf2000  ! 2711: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd4d76000  ! 2712: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0xd0df4e60  ! 2713: LDXA_R	ldxa	[%r29, %r0] 0x73, %r8
	.word 0xdcbf2000  ! 2714: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdcd7a000  ! 2715: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0xdc8fe000  ! 2716: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	mov	0x3c8, %r23
	.word 0xd6f44400  ! 2718: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	mov	0x50, %r25
	.word 0xdaa76000  ! 2720: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	mov	0x48, %r17
	.word 0xd48cc400  ! 2722: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	mov	0x48, %r16
	.word 0xd2f76000  ! 2724: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xd29f6000  ! 2725: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xd2bfa000  ! 2726: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xdaa40400  ! 2727: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0x87802074  ! 2728: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2729: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f6e000  ! 2730: STXA_I	stxa	%r11, [%r27 + 0x0000] %asi
	.word 0xd6862000  ! 2731: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r11
	mov	0x3d8, %r20
	.word 0xd696a000  ! 2733: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r11
	.word 0xd6a6e000  ! 2734: STWA_I	stwa	%r11, [%r27 + 0x0000] %asi
	.word 0xd6a66000  ! 2735: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 2736: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2737: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaa78e40  ! 2738: STWA_R	stwa	%r13, [%r30 + %r0] 0x72
	.word 0xdc87a000  ! 2739: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0x87802025  ! 2740: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 2741: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0978e40  ! 2742: LDUHA_R	lduha	[%r30, %r0] 0x72, %r8
	mov	0x7c0, %r20
	.word 0xdcf70e40  ! 2744: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	.word 0xdecce000  ! 2745: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	.word 0xdab78e40  ! 2746: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	.word 0xd68f8e40  ! 2747: LDUBA_R	lduba	[%r30, %r0] 0x72, %r11
	.word 0x87802020  ! 2748: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r19
	.word 0xd8b74e60  ! 2750: STHA_R	stha	%r12, [%r29 + %r0] 0x73
	.word 0xd0ddc4a0  ! 2751: LDXA_R	ldxa	[%r23, %r0] 0x25, %r8
	.word 0xdcbf2000  ! 2752: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xd8a74e60  ! 2753: STWA_R	stwa	%r12, [%r29 + %r0] 0x73
	.word 0xdaa70e80  ! 2754: STWA_R	stwa	%r13, [%r28 + %r0] 0x74
	.word 0xdc8fe000  ! 2755: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	mov	0x60, %r25
	mov	0x78, %r24
	.word 0xdcf7e000  ! 2758: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x3c0, %r21
	mov	0x7e8, %r23
	.word 0xd0bc0400  ! 2761: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0xdaacc400  ! 2762: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0x87802074  ! 2763: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bdc4a0  ! 2764: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	.word 0xd094e000  ! 2765: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0xd0b40400  ! 2766: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0xdc96c9e0  ! 2767: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r14
	.word 0xd88ce000  ! 2768: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	.word 0xd8ac4400  ! 2769: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0x87802074  ! 2770: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r24
	.word 0xd2b72000  ! 2772: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	mov	0x3c0, %r20
	mov	0x68, %r17
	.word 0xd8a7ce80  ! 2775: STWA_R	stwa	%r12, [%r31 + %r0] 0x74
	.word 0xd687a000  ! 2776: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0xda8c0400  ! 2777: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	.word 0x87802020  ! 2778: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2779: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2780: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c0, %r21
	.word 0xd8b78e40  ! 2782: STHA_R	stha	%r12, [%r30 + %r0] 0x72
	.word 0xdcc7ce80  ! 2783: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r14
	.word 0xd4b7e000  ! 2784: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd2b4c400  ! 2785: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	mov	0x50, %r25
	mov	0x28, %r17
	mov	0x78, %r24
	.word 0xda9cc400  ! 2789: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	.word 0x87802073  ! 2790: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd28c2000  ! 2791: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xd28c2000  ! 2792: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xd2c4e000  ! 2793: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xd8d584a0  ! 2794: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r12
	.word 0xd0d4e000  ! 2795: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	.word 0xd0f4e000  ! 2796: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0946000  ! 2797: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0x87802073  ! 2798: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0f609e0  ! 2799: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	.word 0xd49d44a0  ! 2800: LDDA_R	ldda	[%r21, %r0] 0x25, %r10
	.word 0xd2bf2000  ! 2801: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd2b72000  ! 2802: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd2b7e000  ! 2803: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd6b48400  ! 2804: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd8df2000  ! 2805: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8f76000  ! 2806: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xded609e0  ! 2807: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r15
	.word 0xd2cc8400  ! 2808: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0x87802072  ! 2809: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a70e40  ! 2810: STWA_R	stwa	%r10, [%r28 + %r0] 0x72
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802072  ! 2812: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 2813: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bcc400  ! 2814: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xd2ae6000  ! 2815: STBA_I	stba	%r9, [%r25 + 0x0000] %asi
	.word 0xd2f66000  ! 2816: STXA_I	stxa	%r9, [%r25 + 0x0000] %asi
	mov	0x40, %r19
	mov	0x10, %r25
	.word 0xd0de49e0  ! 2819: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r8
	.word 0xd2f40400  ! 2820: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xd0be6000  ! 2821: STDA_I	stda	%r8, [%r25 + 0x0000] %asi
	.word 0xd0b6a000  ! 2822: STHA_I	stha	%r8, [%r26 + 0x0000] %asi
	.word 0xdadc4400  ! 2823: LDXA_R	ldxa	[%r17, %r0] 0x20, %r13
	.word 0xd2ac4400  ! 2824: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xda8d04a0  ! 2825: LDUBA_R	lduba	[%r20, %r0] 0x25, %r13
	mov	0x70, %r16
	.word 0xdccfce60  ! 2827: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r14
	mov	0x18, %r26
	.word 0xd4af0e40  ! 2829: STBA_R	stba	%r10, [%r28 + %r0] 0x72
	mov	0x7e0, %r22
	.word 0xd6d62000  ! 2831: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r11
	mov	0x60, %r26
	.word 0xd6862000  ! 2833: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 2834: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6ddc4a0  ! 2835: LDXA_R	ldxa	[%r23, %r0] 0x25, %r11
	.word 0xdabce000  ! 2836: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	mov	0x60, %r17
	.word 0xdab46000  ! 2838: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0xda8ce000  ! 2839: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	.word 0xdab42000  ! 2840: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 2841: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b7ce80  ! 2842: STHA_R	stha	%r12, [%r31 + %r0] 0x74
	mov	0x40, %r17
	.word 0x87802073  ! 2844: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdccf6000  ! 2845: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xd4a44400  ! 2846: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xd0a76000  ! 2847: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	mov	0x10, %r27
	.word 0x87802072  ! 2849: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda9ec9e0  ! 2850: LDDA_R	ldda	[%r27, %r0] 0x4f, %r13
	mov	0x68, %r18
	.word 0x87802073  ! 2852: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4dc2000  ! 2853: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	.word 0xd4f42000  ! 2854: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xdea6c9e0  ! 2855: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	mov	0x60, %r19
	.word 0x87802025  ! 2857: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 2858: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbcc400  ! 2859: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	mov	0x7e0, %r20
	.word 0xd2c4e000  ! 2861: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	mov	0x10, %r26
	.word 0xd2f46000  ! 2863: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xde9f8e80  ! 2864: LDDA_R	ldda	[%r30, %r0] 0x74, %r15
	mov	0x7c0, %r20
	.word 0xdef544a0  ! 2866: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	.word 0xd4ac8400  ! 2867: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0xd0c4e000  ! 2868: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	.word 0xdabd04a0  ! 2869: STDA_R	stda	%r13, [%r20 + %r0] 0x25
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x8780204f  ! 2871: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea44400  ! 2872: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	mov	0x0, %r26
	.word 0xd2f44400  ! 2874: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	.word 0xd69c2000  ! 2875: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r11
	.word 0xd6aca000  ! 2876: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xd6aca000  ! 2877: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	mov	0x0, %r16
	.word 0xdcb48400  ! 2879: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xd09544a0  ! 2880: LDUHA_R	lduha	[%r21, %r0] 0x25, %r8
	.word 0xd4f7ce40  ! 2881: STXA_R	stxa	%r10, [%r31 + %r0] 0x72
	.word 0xdeace000  ! 2882: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xdedec9e0  ! 2883: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r15
	mov	0x50, %r18
	.word 0xd2bc4400  ! 2885: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0x87802020  ! 2886: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bfe000  ! 2887: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd4af2000  ! 2888: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xdeb4c400  ! 2889: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	mov	0x38, %r17
	.word 0xd887e000  ! 2891: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8dfe000  ! 2892: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	mov	0x40, %r27
	.word 0xd8cf2000  ! 2894: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	mov	0x78, %r26
	.word 0xd2ad44a0  ! 2896: STBA_R	stba	%r9, [%r21 + %r0] 0x25
	.word 0xdc8cc400  ! 2897: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	.word 0xd2a40400  ! 2898: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xdc8f6000  ! 2899: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcd7e000  ! 2900: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xdca7e000  ! 2901: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdaac0400  ! 2902: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0x87802020  ! 2903: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde85c4a0  ! 2904: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r15
	.word 0xd4cce000  ! 2905: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	.word 0xd8f7ce40  ! 2906: STXA_R	stxa	%r12, [%r31 + %r0] 0x72
	.word 0xd6bfce40  ! 2907: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	.word 0xd68ce000  ! 2908: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	.word 0xd6dc2000  ! 2909: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 2910: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6af2000  ! 2911: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0xdeae89e0  ! 2913: STBA_R	stba	%r15, [%r26 + %r0] 0x4f
	mov	0x18, %r18
	mov	0x58, %r19
	.word 0xd2bc4400  ! 2916: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0xdcc72000  ! 2917: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 2918: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a44400  ! 2919: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xd49fce60  ! 2920: LDDA_R	ldda	[%r31, %r0] 0x73, %r10
	.word 0xdab7ce80  ! 2921: STHA_R	stha	%r13, [%r31 + %r0] 0x74
	mov	0x38, %r17
	.word 0xdedf8e40  ! 2923: LDXA_R	ldxa	[%r30, %r0] 0x72, %r15
	mov	0x7c8, %r23
	.word 0x87802025  ! 2925: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0c7a000  ! 2926: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xdedc8400  ! 2927: LDXA_R	ldxa	[%r18, %r0] 0x20, %r15
	.word 0xda8c8400  ! 2928: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	mov	0x68, %r24
	.word 0x87802025  ! 2930: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 2931: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d8, %r20
	.word 0xd89f0e80  ! 2933: LDDA_R	ldda	[%r28, %r0] 0x74, %r12
	mov	0x7e8, %r23
	.word 0x8780204f  ! 2935: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0af6000  ! 2936: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd0bf6000  ! 2937: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd2b584a0  ! 2938: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0xd6bc4400  ! 2939: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	mov	0x7e8, %r20
	.word 0x87802073  ! 2941: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8b42000  ! 2942: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 2943: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa4c400  ! 2944: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0xdcbf4e60  ! 2945: STDA_R	stda	%r14, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 2946: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r26
	mov	0x7c8, %r23
	.word 0xd48fce80  ! 2949: LDUBA_R	lduba	[%r31, %r0] 0x74, %r10
	.word 0xd8cfce80  ! 2950: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r12
	.word 0xdeacc400  ! 2951: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xd2d40400  ! 2952: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	mov	0x3d0, %r21
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802025  ! 2955: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bf4e80  ! 2956: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	mov	0x8, %r19
	mov	0x8, %r27
	.word 0xdec44400  ! 2959: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	mov	0x0, %r24
	.word 0xdcd70e40  ! 2961: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r14
	mov	0x50, %r27
	.word 0xd0be49e0  ! 2963: STDA_R	stda	%r8, [%r25 + %r0] 0x4f
	.word 0xd6a78e80  ! 2964: STWA_R	stwa	%r11, [%r30 + %r0] 0x74
	.word 0xde9fce60  ! 2965: LDDA_R	ldda	[%r31, %r0] 0x73, %r15
	.word 0xdc8f8e80  ! 2966: LDUBA_R	lduba	[%r30, %r0] 0x74, %r14
	mov	0x50, %r24
	mov	0x3e8, %r21
	.word 0xd6a48400  ! 2969: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	mov	0x78, %r26
	.word 0x8780204f  ! 2971: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea70e80  ! 2972: STWA_R	stwa	%r15, [%r28 + %r0] 0x74
	.word 0x87802020  ! 2973: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r17
	.word 0xd4c70e60  ! 2975: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r10
	mov	0x30, %r16
	.word 0xd0ce6000  ! 2977: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r8
	.word 0xd096a000  ! 2978: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r8
	.word 0xd6d74e80  ! 2979: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r11
	mov	0x7d0, %r20
	.word 0xd0bfce80  ! 2981: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	.word 0x8780204f  ! 2982: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 2983: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r18
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd8bc2000  ! 2986: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd88c0400  ! 2987: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	.word 0xd2a4a000  ! 2988: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0xd29ca000  ! 2989: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 2990: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a40400  ! 2991: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0xd2f689e0  ! 2992: STXA_R	stxa	%r9, [%r26 + %r0] 0x4f
	.word 0x8780204f  ! 2993: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a5e000  ! 2994: STWA_I	stwa	%r10, [%r23 + 0x0000] %asi
	mov	0x0, %r26
	.word 0x87802020  ! 2996: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49fa000  ! 2997: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	mov	0x3f0, %r22
	mov	0x3c0, %r20
	.word 0xd48f6000  ! 3000: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	mov	0x30, %r26
	mov	0x3f0, %r23
	.word 0xd6f70e40  ! 3003: STXA_R	stxa	%r11, [%r28 + %r0] 0x72
	.word 0xd6f76000  ! 3004: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 3005: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb7ce80  ! 3006: STHA_R	stha	%r15, [%r31 + %r0] 0x74
	mov	0x20, %r16
	.word 0xdaaf2000  ! 3008: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 3009: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf5e000  ! 3010: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0xdca504a0  ! 3011: STWA_R	stwa	%r14, [%r20 + %r0] 0x25
	mov	0x38, %r17
	mov	0x3e0, %r20
	.word 0xdabda000  ! 3014: STDA_I	stda	%r13, [%r22 + 0x0000] %asi
	.word 0xda9da000  ! 3015: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r13
	.word 0x87802025  ! 3016: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda9f2000  ! 3017: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xdacfa000  ! 3018: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xdabf4e40  ! 3019: STDA_R	stda	%r13, [%r29 + %r0] 0x72
	mov	0x28, %r25
	mov	0x3c0, %r21
	.word 0xd2b44400  ! 3022: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0x87802072  ! 3023: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdece89e0  ! 3024: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r15
	mov	0x38, %r24
	mov	0x3e0, %r22
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802020  ! 3028: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r26
	.word 0xd28f0e40  ! 3030: LDUBA_R	lduba	[%r28, %r0] 0x72, %r9
	.word 0xd2b76000  ! 3031: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 3032: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3033: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2bf6000  ! 3034: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd2972000  ! 3035: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xd2a7a000  ! 3036: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	mov	0x8, %r18
	.word 0xd2bfa000  ! 3038: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	mov	0x28, %r25
	mov	0x7e0, %r23
	.word 0xd6af8e40  ! 3041: STBA_R	stba	%r11, [%r30 + %r0] 0x72
	.word 0xd6af6000  ! 3042: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd6f7e000  ! 3043: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 3044: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6c62000  ! 3045: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r11
	.word 0xd6862000  ! 3046: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r11
	mov	0x3c8, %r23
	.word 0xd68ea000  ! 3048: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r11
	.word 0xdac4c400  ! 3049: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r13
	mov	0x3e8, %r20
	mov	0x58, %r24
	.word 0xdcdf0e40  ! 3052: LDXA_R	ldxa	[%r28, %r0] 0x72, %r14
	.word 0xd086c9e0  ! 3053: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r8
	.word 0xdec48400  ! 3054: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	.word 0xd6f66000  ! 3055: STXA_I	stxa	%r11, [%r25 + 0x0000] %asi
	.word 0xd2b584a0  ! 3056: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0xde8584a0  ! 3057: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r15
	.word 0xdc9dc4a0  ! 3058: LDDA_R	ldda	[%r23, %r0] 0x25, %r14
	.word 0xd68f0e80  ! 3059: LDUBA_R	lduba	[%r28, %r0] 0x74, %r11
	.word 0x87802074  ! 3060: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd48fe000  ! 3061: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xd4c72000  ! 3062: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r10
	.word 0xd8afce40  ! 3063: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	mov	0x50, %r25
	.word 0xd2876000  ! 3065: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	mov	0x18, %r16
	.word 0xd2b7e000  ! 3067: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2f76000  ! 3068: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	mov	0x8, %r25
	.word 0xd2bf2000  ! 3070: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	mov	0x8, %r24
	.word 0xdab4c400  ! 3072: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xd2a7e000  ! 3073: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xdab40400  ! 3074: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xd0a44400  ! 3075: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xd08649e0  ! 3076: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r8
	.word 0xdc9fe000  ! 3077: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xdc976000  ! 3078: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	.word 0xdcb7a000  ! 3079: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	mov	0x70, %r27
	.word 0xdcc7e000  ! 3081: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0xd2ae89e0  ! 3082: STBA_R	stba	%r9, [%r26 + %r0] 0x4f
	.word 0xd6dc8400  ! 3083: LDXA_R	ldxa	[%r18, %r0] 0x20, %r11
	.word 0xdc8fa000  ! 3084: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdaa689e0  ! 3085: STWA_R	stwa	%r13, [%r26 + %r0] 0x4f
	.word 0xd4b72000  ! 3086: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd4ac8400  ! 3087: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0x87802073  ! 3088: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bc4400  ! 3089: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	mov	0x50, %r24
	mov	0x10, %r26
	mov	0x18, %r24
	.word 0xdeb7e000  ! 3093: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	mov	0x20, %r27
	.word 0xdecfe000  ! 3095: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xdaafce80  ! 3096: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	.word 0xd8acc400  ! 3097: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0xd6bc0400  ! 3098: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xd6f4c400  ! 3099: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	mov	0x3c0, %r20
	.word 0xd0dfe000  ! 3101: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	mov	0x8, %r18
	.word 0xd4f78e60  ! 3103: STXA_R	stxa	%r10, [%r30 + %r0] 0x73
	mov	0x78, %r26
	mov	0x28, %r17
	mov	0x68, %r16
	mov	0x50, %r25
	mov	0x28, %r26
	.word 0xdef74e80  ! 3109: STXA_R	stxa	%r15, [%r29 + %r0] 0x74
	mov	0x7c8, %r21
	.word 0xdc8fa000  ! 3111: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	mov	0x68, %r17
	.word 0x87802072  ! 3113: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc9fa000  ! 3114: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0xd69c4400  ! 3115: LDDA_R	ldda	[%r17, %r0] 0x20, %r11
	.word 0x87802072  ! 3116: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2c78e60  ! 3117: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r9
	.word 0xd4ace000  ! 3118: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	mov	0x28, %r17
	mov	0x18, %r18
	mov	0x28, %r25
	mov	0x7f8, %r21
	.word 0xd48ca000  ! 3123: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r10
	.word 0xde8cc400  ! 3124: LDUBA_R	lduba	[%r19, %r0] 0x20, %r15
	.word 0xde842000  ! 3125: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	.word 0xd4f78e60  ! 3126: STXA_R	stxa	%r10, [%r30 + %r0] 0x73
	.word 0xd6a4a000  ! 3127: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 3128: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e8, %r23
	.word 0xd6a7a000  ! 3130: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 3131: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f7ce40  ! 3132: STXA_R	stxa	%r9, [%r31 + %r0] 0x72
	mov	0x10, %r17
	.word 0xd0f78e60  ! 3134: STXA_R	stxa	%r8, [%r30 + %r0] 0x73
	.word 0xd29f4e40  ! 3135: LDDA_R	ldda	[%r29, %r0] 0x72, %r9
	.word 0xd6cfa000  ! 3136: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0xdaa5c4a0  ! 3137: STWA_R	stwa	%r13, [%r23 + %r0] 0x25
	.word 0xd8df2000  ! 3138: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 3139: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r27
	.word 0xd8d76000  ! 3141: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xd0afce60  ! 3142: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	.word 0xdad44400  ! 3143: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	mov	0x50, %r18
	mov	0x28, %r26
	.word 0xd097ce60  ! 3146: LDUHA_R	lduha	[%r31, %r0] 0x73, %r8
	.word 0x87802020  ! 3147: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802025  ! 3149: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf40400  ! 3150: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xdcc5c4a0  ! 3151: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r14
	.word 0xd6af6000  ! 3152: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd6d7a000  ! 3153: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	.word 0xd6872000  ! 3154: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6f7a000  ! 3155: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	mov	0x38, %r26
	.word 0xd8a48400  ! 3157: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	.word 0xd28f6000  ! 3158: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	mov	0x3f8, %r20
	.word 0xd2b7e000  ! 3160: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xdea7ce60  ! 3161: STWA_R	stwa	%r15, [%r31 + %r0] 0x73
	.word 0xd4a584a0  ! 3162: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	.word 0xded72000  ! 3163: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xde87a000  ! 3164: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xde9f2000  ! 3165: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xdef72000  ! 3166: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xdedfe000  ! 3167: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	mov	0x3c0, %r22
	.word 0xdeaf2000  ! 3169: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xdea7a000  ! 3170: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	mov	0x40, %r27
	mov	0x3e8, %r23
	.word 0xdec7e000  ! 3173: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xd6f40400  ! 3174: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	.word 0x87802073  ! 3175: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6a6c9e0  ! 3176: STWA_R	stwa	%r11, [%r27 + %r0] 0x4f
	.word 0xd8ae49e0  ! 3177: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0xdcf76000  ! 3178: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x60, %r24
	.word 0xdec48400  ! 3180: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	.word 0xd2f7a000  ! 3181: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	mov	0x58, %r27
	.word 0xde9cc400  ! 3183: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	.word 0x87802020  ! 3184: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcaca000  ! 3185: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 3186: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcd5e000  ! 3187: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r14
	.word 0x87802020  ! 3188: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r18
	.word 0xdcd7e000  ! 3190: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xd6af4e60  ! 3191: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	mov	0x48, %r16
	mov	0x28, %r27
	mov	0x3f8, %r22
	.word 0xd49689e0  ! 3195: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r10
	.word 0xd8f76000  ! 3196: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0x87802025  ! 3198: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8846000  ! 3199: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	mov	0x48, %r24
	mov	0x3c0, %r21
	.word 0xdcbcc400  ! 3202: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0x87802020  ! 3203: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r23
	.word 0xd2c70e40  ! 3205: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r9
	.word 0xd6d7ce80  ! 3206: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r11
	.word 0xd2d42000  ! 3207: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3208: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a689e0  ! 3209: STWA_R	stwa	%r10, [%r26 + %r0] 0x4f
	.word 0xdcd7e000  ! 3210: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xd687ce40  ! 3211: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r11
	mov	0x38, %r25
	.word 0xdcf7a000  ! 3213: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xdcf7e000  ! 3215: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 3216: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcaca000  ! 3217: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	mov	0x78, %r24
	.word 0xde944400  ! 3219: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	.word 0xd8d4a000  ! 3220: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0x87802025  ! 3221: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8ade000  ! 3222: STBA_I	stba	%r12, [%r23 + 0x0000] %asi
	.word 0xd8dd6000  ! 3223: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r12
	.word 0x87802025  ! 3224: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f7ce60  ! 3225: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	mov	0x20, %r17
	.word 0x87802020  ! 3227: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9f8e80  ! 3228: LDDA_R	ldda	[%r30, %r0] 0x74, %r14
	mov	0x8, %r25
	mov	0x30, %r17
	mov	0x30, %r24
	mov	0x28, %r25
	.word 0xd4df2000  ! 3233: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 3234: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4ace000  ! 3235: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	mov	0x60, %r27
	.word 0xde97ce60  ! 3237: LDUHA_R	lduha	[%r31, %r0] 0x73, %r15
	.word 0xdc87ce60  ! 3238: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r14
	.word 0xd4f4c400  ! 3239: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	mov	0x20, %r26
	mov	0x60, %r17
	.word 0x87802072  ! 3242: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d0, %r23
	mov	0x7f0, %r21
	.word 0xde87a000  ! 3245: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xda84c400  ! 3246: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r13
	.word 0xd6bfe000  ! 3247: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xdca584a0  ! 3248: STWA_R	stwa	%r14, [%r22 + %r0] 0x25
	.word 0xdacf4e60  ! 3249: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r13
	.word 0x87802025  ! 3250: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdadc4400  ! 3251: LDXA_R	ldxa	[%r17, %r0] 0x20, %r13
	.word 0x87802073  ! 3252: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 3253: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7e0, %r22
	.word 0xdeb4c400  ! 3255: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xd0af4e60  ! 3256: STBA_R	stba	%r8, [%r29 + %r0] 0x73
	mov	0x3f0, %r23
	.word 0xd2dda000  ! 3258: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r9
	mov	0x3e0, %r21
	.word 0xdcae09e0  ! 3260: STBA_R	stba	%r14, [%r24 + %r0] 0x4f
	mov	0x3e0, %r22
	.word 0xda9da000  ! 3262: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r13
	.word 0xdaa52000  ! 3263: STWA_I	stwa	%r13, [%r20 + 0x0000] %asi
	.word 0xdaa5e000  ! 3264: STWA_I	stwa	%r13, [%r23 + 0x0000] %asi
	.word 0xdac5a000  ! 3265: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r13
	mov	0x3c8, %r21
	.word 0xdc9c0400  ! 3267: LDDA_R	ldda	[%r16, %r0] 0x20, %r14
	.word 0xdef56000  ! 3268: STXA_I	stxa	%r15, [%r21 + 0x0000] %asi
	.word 0xdebda000  ! 3269: STDA_I	stda	%r15, [%r22 + 0x0000] %asi
	mov	0x0, %r24
	.word 0xd2840400  ! 3271: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r9
	.word 0xdecd6000  ! 3272: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r15
	mov	0x40, %r16
	mov	0x50, %r18
	mov	0x50, %r17
	.word 0xde8d2000  ! 3276: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r15
	.word 0xd4af4e60  ! 3277: STBA_R	stba	%r10, [%r29 + %r0] 0x73
	.word 0xdaa56000  ! 3278: STWA_I	stwa	%r13, [%r21 + 0x0000] %asi
	.word 0x87802025  ! 3279: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdacf2000  ! 3280: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xda976000  ! 3281: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	.word 0xdaf7e000  ! 3282: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 3283: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6ad84a0  ! 3284: STBA_R	stba	%r11, [%r22 + %r0] 0x25
	.word 0xdea609e0  ! 3285: STWA_R	stwa	%r15, [%r24 + %r0] 0x4f
	.word 0xd2bea000  ! 3286: STDA_I	stda	%r9, [%r26 + 0x0000] %asi
	.word 0xd2bea000  ! 3287: STDA_I	stda	%r9, [%r26 + 0x0000] %asi
	.word 0xd6ce09e0  ! 3288: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r11
	.word 0xd2bc0400  ! 3289: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xd6862000  ! 3290: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r11
	mov	0x7e0, %r20
	.word 0xda970e40  ! 3292: LDUHA_R	lduha	[%r28, %r0] 0x72, %r13
	mov	0x58, %r24
	.word 0xdaa66000  ! 3294: STWA_I	stwa	%r13, [%r25 + 0x0000] %asi
	mov	0x7c8, %r21
	.word 0xdabea000  ! 3296: STDA_I	stda	%r13, [%r26 + 0x0000] %asi
	.word 0xdabe6000  ! 3297: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	.word 0xda96a000  ! 3298: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r13
	.word 0xda86e000  ! 3299: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r13
	mov	0x68, %r25
	.word 0xd6a48400  ! 3301: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0xd0f66000  ! 3302: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	.word 0xd0966000  ! 3303: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r8
	.word 0xd4b7ce40  ! 3304: STHA_R	stha	%r10, [%r31 + %r0] 0x72
	.word 0xd2b504a0  ! 3305: STHA_R	stha	%r9, [%r20 + %r0] 0x25
	mov	0x3c0, %r20
	.word 0x87802072  ! 3307: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6c7ce80  ! 3308: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r11
	mov	0x68, %r24
	.word 0xdccfa000  ! 3310: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xdc8f2000  ! 3311: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0x87802025  ! 3312: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e0, %r21
	mov	0x58, %r25
	.word 0xdecfce80  ! 3315: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r15
	.word 0xda84c400  ! 3316: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r13
	.word 0xdab72000  ! 3317: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdabc0400  ! 3318: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xda9fe000  ! 3319: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	mov	0x0, %r26
	mov	0x7d0, %r22
	.word 0xd2bcc400  ! 3322: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xdebf8e80  ! 3323: STDA_R	stda	%r15, [%r30 + %r0] 0x74
	.word 0xd8f44400  ! 3324: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xd4c40400  ! 3325: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	.word 0xd6b72000  ! 3326: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd687e000  ! 3327: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xd2bdc4a0  ! 3328: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	.word 0x87802073  ! 3329: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2cd2000  ! 3330: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r9
	.word 0xd2dda000  ! 3331: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r9
	.word 0xd4adc4a0  ! 3332: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0xdc9d6000  ! 3333: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r14
	.word 0x87802020  ! 3334: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69c0400  ! 3335: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	.word 0xd0dfa000  ! 3336: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0bf6000  ! 3337: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd087e000  ! 3338: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0xd88584a0  ! 3339: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r12
	.word 0xdcf7e000  ! 3340: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 3341: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r26
	.word 0xdaa44400  ! 3343: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0xd6842000  ! 3344: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r11
	.word 0xd694e000  ! 3345: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r11
	.word 0xd6dc0400  ! 3346: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	.word 0xd6d7ce40  ! 3347: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r11
	.word 0xd2f78e60  ! 3348: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0xd686c9e0  ! 3349: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r11
	.word 0xdebc2000  ! 3350: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 3351: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdadc8400  ! 3352: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	.word 0xd484c400  ! 3353: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	.word 0xd4a44400  ! 3354: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0x87802020  ! 3355: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a72000  ! 3356: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 3357: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r18
	.word 0x8780204f  ! 3359: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4d44400  ! 3360: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0xd68689e0  ! 3361: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r11
	mov	0x3d8, %r21
	mov	0x3e8, %r23
	.word 0xdcc70e40  ! 3364: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r14
	.word 0x87802020  ! 3365: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r22
	.word 0xda84c400  ! 3367: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r13
	.word 0xd4a40400  ! 3368: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	.word 0x87802072  ! 3369: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4866000  ! 3370: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r10
	.word 0xd4a6a000  ! 3371: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	.word 0xdcc44400  ! 3372: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xd48e2000  ! 3373: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r10
	.word 0xdab584a0  ! 3374: STHA_R	stha	%r13, [%r22 + %r0] 0x25
	.word 0xd0afce80  ! 3375: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	.word 0xd4bee000  ! 3376: STDA_I	stda	%r10, [%r27 + 0x0000] %asi
	.word 0xd4a6a000  ! 3377: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xd4dee000  ! 3379: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r10
	.word 0xd4862000  ! 3380: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r10
	.word 0xd496e000  ! 3381: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r10
	.word 0xdcf40400  ! 3382: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	mov	0x10, %r17
	.word 0xdebe6000  ! 3384: STDA_I	stda	%r15, [%r25 + 0x0000] %asi
	.word 0xdef62000  ! 3385: STXA_I	stxa	%r15, [%r24 + 0x0000] %asi
	.word 0xde962000  ! 3386: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r15
	.word 0xdaa609e0  ! 3387: STWA_R	stwa	%r13, [%r24 + %r0] 0x4f
	mov	0x30, %r18
	.word 0x87802025  ! 3389: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bd2000  ! 3390: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 3391: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2942000  ! 3392: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	mov	0x3d0, %r20
	.word 0xd2f4a000  ! 3394: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	mov	0x3e0, %r22
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2d46000  ! 3397: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	mov	0x60, %r26
	.word 0xd2942000  ! 3399: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2ac2000  ! 3400: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xd6dcc400  ! 3402: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	.word 0xd084a000  ! 3403: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0b4e000  ! 3404: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xd0d7ce60  ! 3405: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r8
	.word 0x87802073  ! 3406: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde97a000  ! 3407: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	.word 0xdebfa000  ! 3408: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xdea72000  ! 3409: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xded504a0  ! 3410: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r15
	.word 0xd2bfa000  ! 3411: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 3412: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacdc4a0  ! 3413: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r13
	.word 0xd69e49e0  ! 3414: LDDA_R	ldda	[%r25, %r0] 0x4f, %r11
	mov	0x7e8, %r22
	.word 0xd2be09e0  ! 3416: STDA_R	stda	%r9, [%r24 + %r0] 0x4f
	.word 0xd4966000  ! 3417: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r10
	.word 0xd0c74e60  ! 3418: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r8
	.word 0xd28e6000  ! 3419: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r9
	.word 0xd2c66000  ! 3420: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r9
	.word 0xd4dd04a0  ! 3421: LDXA_R	ldxa	[%r20, %r0] 0x25, %r10
	.word 0xdaaee000  ! 3422: STBA_I	stba	%r13, [%r27 + 0x0000] %asi
	.word 0xdade6000  ! 3423: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r13
	.word 0xdadea000  ! 3424: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r13
	mov	0x7f8, %r23
	mov	0x8, %r16
	.word 0xd2f44400  ! 3427: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	.word 0xdeaf0e80  ! 3428: STBA_R	stba	%r15, [%r28 + %r0] 0x74
	mov	0x7c8, %r20
	.word 0xdede6000  ! 3430: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r15
	.word 0xd8a609e0  ! 3431: STWA_R	stwa	%r12, [%r24 + %r0] 0x4f
	mov	0x3e0, %r22
	.word 0xdcc689e0  ! 3433: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r14
	.word 0xd2a66000  ! 3434: STWA_I	stwa	%r9, [%r25 + 0x0000] %asi
	.word 0x87802072  ! 3435: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0df4e60  ! 3436: LDXA_R	ldxa	[%r29, %r0] 0x73, %r8
	.word 0x87802020  ! 3437: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ae6000  ! 3438: STBA_I	stba	%r12, [%r25 + 0x0000] %asi
	.word 0xd8dd84a0  ! 3439: LDXA_R	ldxa	[%r22, %r0] 0x25, %r12
	.word 0x8780204f  ! 3440: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f42000  ! 3441: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 3442: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b72000  ! 3443: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	mov	0x48, %r18
	.word 0x87802074  ! 3445: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdab70e60  ! 3446: STHA_R	stha	%r13, [%r28 + %r0] 0x73
	.word 0xd28c4400  ! 3447: LDUBA_R	lduba	[%r17, %r0] 0x20, %r9
	.word 0xd6970e40  ! 3448: LDUHA_R	lduha	[%r28, %r0] 0x72, %r11
	.word 0xdacca000  ! 3449: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	.word 0xd6af0e80  ! 3450: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	.word 0xdab46000  ! 3451: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	mov	0x78, %r24
	.word 0x87802072  ! 3453: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda872000  ! 3454: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 3455: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcaf4e80  ! 3456: STBA_R	stba	%r14, [%r29 + %r0] 0x74
	.word 0xdebce000  ! 3457: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xd2de89e0  ! 3458: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r9
	mov	0x3c0, %r22
	mov	0x18, %r18
	mov	0x7e8, %r21
	.word 0xdedca000  ! 3462: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xd4b40400  ! 3463: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0xda9e49e0  ! 3464: LDDA_R	ldda	[%r25, %r0] 0x4f, %r13
	.word 0xd6dc8400  ! 3465: LDXA_R	ldxa	[%r18, %r0] 0x20, %r11
	.word 0xdcd4c400  ! 3466: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	.word 0xdc8f4e80  ! 3467: LDUBA_R	lduba	[%r29, %r0] 0x74, %r14
	.word 0xdcbc8400  ! 3468: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	mov	0x3f0, %r21
	.word 0xd0cca000  ! 3470: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	.word 0xd0946000  ! 3471: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	mov	0x3c8, %r20
	.word 0xd2cf8e80  ! 3473: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r9
	.word 0x87802020  ! 3474: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc97a000  ! 3475: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	.word 0xdcb76000  ! 3476: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xd0d40400  ! 3477: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	.word 0xdef76000  ! 3478: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdef7e000  ! 3479: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	mov	0x7e0, %r23
	mov	0x68, %r18
	.word 0xdeb7a000  ! 3482: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	mov	0x78, %r24
	mov	0x48, %r25
	.word 0xdedf8e40  ! 3485: LDXA_R	ldxa	[%r30, %r0] 0x72, %r15
	.word 0xd0dc0400  ! 3486: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xdca76000  ! 3487: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xd8d609e0  ! 3488: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r12
	.word 0xd8f4c400  ! 3489: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xdea4c400  ! 3490: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	.word 0x87802025  ! 3491: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0b7e000  ! 3492: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0xdcdf8e40  ! 3493: LDXA_R	ldxa	[%r30, %r0] 0x72, %r14
	.word 0xdef7a000  ! 3494: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xd4b504a0  ! 3495: STHA_R	stha	%r10, [%r20 + %r0] 0x25
	.word 0x87802020  ! 3496: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cde000  ! 3497: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r11
	.word 0xdeb4c400  ! 3498: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xd8dd2000  ! 3499: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r12
	.word 0xd89d2000  ! 3500: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r12
	mov	0x58, %r17
	.word 0xd8852000  ! 3502: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r12
	.word 0x87802020  ! 3503: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88f6000  ! 3504: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	mov	0x40, %r17
	mov	0x70, %r26
	.word 0xd8c72000  ! 3507: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 3508: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 3509: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d8, %r23
	.word 0xd8b72000  ! 3511: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd8afe000  ! 3512: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd0bcc400  ! 3513: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0xdabc4400  ! 3514: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xd4d44400  ! 3515: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0xdcdfe000  ! 3516: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcdf6000  ! 3517: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xd6974e80  ! 3518: LDUHA_R	lduha	[%r29, %r0] 0x74, %r11
	.word 0xd4d7e000  ! 3519: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	.word 0xd2ac4400  ! 3520: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0x87802025  ! 3521: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc94c400  ! 3522: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	.word 0xde8f8e40  ! 3523: LDUBA_R	lduba	[%r30, %r0] 0x72, %r15
	.word 0xd4c78e40  ! 3524: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r10
	.word 0x87802073  ! 3525: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 3526: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde844400  ! 3527: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	.word 0xdca4c400  ! 3528: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xd6d4c400  ! 3529: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	mov	0x38, %r24
	.word 0x87802020  ! 3531: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 3532: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdef76000  ! 3533: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdeb72000  ! 3534: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xdccc0400  ! 3535: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r14
	.word 0xd28f6000  ! 3536: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd8978e60  ! 3537: LDUHA_R	lduha	[%r30, %r0] 0x73, %r12
	.word 0xdedf2000  ! 3538: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	mov	0x30, %r24
	.word 0x87802073  ! 3540: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdabe89e0  ! 3541: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	mov	0x38, %r16
	.word 0x87802074  ! 3543: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r19
	.word 0x87802074  ! 3545: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc956000  ! 3546: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r14
	mov	0x7f0, %r20
	.word 0xd2cf0e60  ! 3548: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r9
	mov	0x3c8, %r20
	mov	0x50, %r19
	.word 0xd4f5a000  ! 3551: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	.word 0x87802074  ! 3552: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6bf8e40  ! 3553: STDA_R	stda	%r11, [%r30 + %r0] 0x72
	.word 0xdaa7a000  ! 3554: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xdedcc400  ! 3555: LDXA_R	ldxa	[%r19, %r0] 0x20, %r15
	mov	0x48, %r17
	mov	0x0, %r24
	.word 0xda8f2000  ! 3558: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xd88ec9e0  ! 3559: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r12
	.word 0xd0f72000  ! 3560: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xd0f76000  ! 3561: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xd89c0400  ! 3563: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcf7a000  ! 3565: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x28, %r17
	.word 0xdc8fe000  ! 3567: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xd0d5c4a0  ! 3568: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r8
	.word 0xd4872000  ! 3569: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 3570: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd49fce80  ! 3571: LDDA_R	ldda	[%r31, %r0] 0x74, %r10
	.word 0x87802074  ! 3572: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8c66000  ! 3573: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r12
	mov	0x3c0, %r23
	.word 0xd8dee000  ! 3575: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r12
	.word 0xd8bf4e40  ! 3576: STDA_R	stda	%r12, [%r29 + %r0] 0x72
	.word 0xd4cd44a0  ! 3577: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r10
	.word 0x87802020  ! 3578: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2af8e60  ! 3579: STBA_R	stba	%r9, [%r30 + %r0] 0x73
	.word 0xd897e000  ! 3580: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	mov	0x7e8, %r22
	.word 0xd29e89e0  ! 3582: LDDA_R	ldda	[%r26, %r0] 0x4f, %r9
	.word 0xdcbc0400  ! 3583: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	mov	0x10, %r16
	.word 0xd8bfe000  ! 3585: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	mov	0x7e0, %r22
	.word 0xda970e60  ! 3587: LDUHA_R	lduha	[%r28, %r0] 0x73, %r13
	.word 0xdedfe000  ! 3588: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xdaa44400  ! 3589: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0xded7e000  ! 3590: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0x87802074  ! 3591: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde8e89e0  ! 3592: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r15
	.word 0xd88ce000  ! 3593: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	.word 0xd0d649e0  ! 3594: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r8
	.word 0xdeb504a0  ! 3595: STHA_R	stha	%r15, [%r20 + %r0] 0x25
	.word 0xdeace000  ! 3596: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 3597: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bf8e80  ! 3598: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	.word 0x87802074  ! 3599: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8c4e000  ! 3600: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 3601: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8976000  ! 3602: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0xd8afe000  ! 3603: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xdad48400  ! 3604: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0x8780204f  ! 3605: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 3606: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r18
	mov	0x10, %r27
	.word 0xded7e000  ! 3609: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0xd0f74e80  ! 3610: STXA_R	stxa	%r8, [%r29 + %r0] 0x74
	.word 0x87802073  ! 3611: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r25
	mov	0x20, %r17
	.word 0xdabc6000  ! 3614: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xdacca000  ! 3615: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	mov	0x10, %r19
	.word 0x87802020  ! 3617: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa4e000  ! 3618: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0xd2af4e80  ! 3619: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	.word 0xdea4e000  ! 3620: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	mov	0x68, %r18
	.word 0xd0a74e80  ! 3622: STWA_R	stwa	%r8, [%r29 + %r0] 0x74
	.word 0xd2ac4400  ! 3623: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xd2f46000  ! 3624: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd6cc8400  ! 3625: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	mov	0x70, %r16
	.word 0xd8cce000  ! 3627: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r12
	.word 0xd6a70e60  ! 3628: STWA_R	stwa	%r11, [%r28 + %r0] 0x73
	.word 0x87802020  ! 3629: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0976000  ! 3630: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0f40400  ! 3631: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xd6af4e60  ! 3632: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	.word 0xd0adc4a0  ! 3633: STBA_R	stba	%r8, [%r23 + %r0] 0x25
	.word 0xd4afa000  ! 3634: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 3635: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4872000  ! 3636: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4bf6000  ! 3637: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xdcc44400  ! 3638: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xd09f0e40  ! 3639: LDDA_R	ldda	[%r28, %r0] 0x72, %r8
	.word 0xd6afa000  ! 3640: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd68f2000  ! 3641: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xd2f5c4a0  ! 3642: STXA_R	stxa	%r9, [%r23 + %r0] 0x25
	.word 0xd6d48400  ! 3643: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0xd49fa000  ! 3644: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0xd8bd04a0  ! 3645: STDA_R	stda	%r12, [%r20 + %r0] 0x25
	.word 0x87802072  ! 3646: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2c7ce60  ! 3647: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r9
	mov	0x70, %r27
	.word 0x87802074  ! 3649: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 3650: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdab4c400  ! 3651: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0x87802020  ! 3652: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b6a000  ! 3653: STHA_I	stha	%r8, [%r26 + 0x0000] %asi
	.word 0xd2970e80  ! 3654: LDUHA_R	lduha	[%r28, %r0] 0x74, %r9
	.word 0x87802020  ! 3655: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bca000  ! 3656: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	mov	0x3e0, %r20
	.word 0x87802020  ! 3658: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r23
	.word 0x87802025  ! 3660: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 3661: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf7ce80  ! 3662: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	.word 0x87802025  ! 3663: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3664: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r17
	.word 0xd28f2000  ! 3666: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	.word 0xd2af2000  ! 3667: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd2cf2000  ! 3668: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r9
	.word 0xd2f7a000  ! 3669: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xd2976000  ! 3670: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0xd29fa000  ! 3671: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0x87802074  ! 3672: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeb78e80  ! 3673: STHA_R	stha	%r15, [%r30 + %r0] 0x74
	.word 0xda84e000  ! 3674: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r13
	mov	0x3e0, %r23
	mov	0x20, %r25
	.word 0xdaac2000  ! 3677: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0xdecf8e80  ! 3678: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r15
	.word 0xdaf42000  ! 3679: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0xd0d5c4a0  ! 3680: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r8
	.word 0xdea42000  ! 3681: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xd0f4c400  ! 3682: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0xde8c2000  ! 3683: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	mov	0x10, %r27
	.word 0xdebdc4a0  ! 3685: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	.word 0xdcf46000  ! 3686: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xd0d70e40  ! 3687: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r8
	.word 0xd8b584a0  ! 3688: STHA_R	stha	%r12, [%r22 + %r0] 0x25
	.word 0xd4b4e000  ! 3689: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xd09f4e60  ! 3690: LDDA_R	ldda	[%r29, %r0] 0x73, %r8
	.word 0xdca42000  ! 3691: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xd6a649e0  ! 3692: STWA_R	stwa	%r11, [%r25 + %r0] 0x4f
	.word 0xd8cc2000  ! 3693: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r12
	.word 0xd49f0e40  ! 3694: LDDA_R	ldda	[%r28, %r0] 0x72, %r10
	mov	0x68, %r18
	.word 0xdeac8400  ! 3696: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xd08ca000  ! 3697: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xd084e000  ! 3698: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	.word 0xd49c8400  ! 3699: LDDA_R	ldda	[%r18, %r0] 0x20, %r10
	.word 0x87802072  ! 3700: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d0, %r22
	mov	0x60, %r18
	.word 0xd4a5a000  ! 3703: STWA_I	stwa	%r10, [%r22 + 0x0000] %asi
	.word 0xd48d2000  ! 3704: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0xd4dd6000  ! 3705: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r10
	.word 0xdef44400  ! 3706: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xd6dd6000  ! 3707: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r11
	.word 0x87802074  ! 3708: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 3709: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e8, %r22
	.word 0xd2f40400  ! 3711: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	mov	0x40, %r19
	mov	0x3d8, %r20
	.word 0xd2af8e80  ! 3714: STBA_R	stba	%r9, [%r30 + %r0] 0x74
	.word 0xde9f2000  ! 3715: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0x87802025  ! 3716: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde9da000  ! 3717: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r15
	mov	0x0, %r17
	.word 0xded52000  ! 3719: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r15
	.word 0xdeb56000  ! 3720: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	mov	0x0, %r25
	mov	0x60, %r27
	.word 0xde856000  ! 3723: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r15
	.word 0xdeaec9e0  ! 3724: STBA_R	stba	%r15, [%r27 + %r0] 0x4f
	mov	0x7e8, %r23
	.word 0xdc852000  ! 3726: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r14
	.word 0xdca52000  ! 3727: STWA_I	stwa	%r14, [%r20 + 0x0000] %asi
	.word 0xd6a70e60  ! 3728: STWA_R	stwa	%r11, [%r28 + %r0] 0x73
	.word 0x87802073  ! 3729: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd88fce80  ! 3730: LDUBA_R	lduba	[%r31, %r0] 0x74, %r12
	mov	0x60, %r17
	.word 0xd0f66000  ! 3732: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	.word 0xd086a000  ! 3733: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r8
	.word 0xdcf74e60  ! 3734: STXA_R	stxa	%r14, [%r29 + %r0] 0x73
	.word 0xd4aea000  ! 3735: STBA_I	stba	%r10, [%r26 + 0x0000] %asi
	.word 0xd4dd84a0  ! 3736: LDXA_R	ldxa	[%r22, %r0] 0x25, %r10
	.word 0xd6ae49e0  ! 3737: STBA_R	stba	%r11, [%r25 + %r0] 0x4f
	.word 0xdac6e000  ! 3738: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r13
	.word 0x87802073  ! 3739: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 3740: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 3741: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdadfa000  ! 3742: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xd894c400  ! 3743: LDUHA_R	lduha	[%r19, %r0] 0x20, %r12
	.word 0x87802025  ! 3744: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabf0e40  ! 3745: STDA_R	stda	%r13, [%r28 + %r0] 0x72
	.word 0xdea48400  ! 3746: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xda9ec9e0  ! 3747: LDDA_R	ldda	[%r27, %r0] 0x4f, %r13
	.word 0xda876000  ! 3748: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0xd8a584a0  ! 3749: STWA_R	stwa	%r12, [%r22 + %r0] 0x25
	.word 0x87802074  ! 3750: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb7a000  ! 3751: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xdcbfe000  ! 3753: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdcccc400  ! 3754: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	.word 0x87802025  ! 3755: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 3756: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf40400  ! 3757: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xd2f5a000  ! 3758: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	.word 0xd2a56000  ! 3759: STWA_I	stwa	%r9, [%r21 + 0x0000] %asi
	.word 0xd2d52000  ! 3760: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 3761: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd297e000  ! 3762: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	.word 0xd2c44400  ! 3763: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	mov	0x18, %r26
	.word 0xded44400  ! 3765: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	.word 0xd89fce60  ! 3766: LDDA_R	ldda	[%r31, %r0] 0x73, %r12
	.word 0xdacfe000  ! 3767: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	mov	0x0, %r19
	.word 0xdacf2000  ! 3769: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xd4f78e60  ! 3770: STXA_R	stxa	%r10, [%r30 + %r0] 0x73
	.word 0xd087a000  ! 3771: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0bfa000  ! 3772: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0xd0f76000  ! 3773: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0af2000  ! 3774: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xdea74e80  ! 3775: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x7f0, %r20
	.word 0x87802072  ! 3778: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdccf8e40  ! 3779: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r14
	.word 0xd487ce60  ! 3780: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r10
	.word 0xd2b5e000  ! 3781: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0xde870e60  ! 3783: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcad2000  ! 3785: STBA_I	stba	%r14, [%r20 + 0x0000] %asi
	.word 0xd4a649e0  ! 3786: STWA_R	stwa	%r10, [%r25 + %r0] 0x4f
	.word 0xdaf5a000  ! 3787: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xdcac8400  ! 3788: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0x87802020  ! 3789: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef78e80  ! 3790: STXA_R	stxa	%r15, [%r30 + %r0] 0x74
	.word 0x87802074  ! 3791: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbfa000  ! 3792: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xd6cdc4a0  ! 3793: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r11
	.word 0xd4876000  ! 3794: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0x87802072  ! 3795: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4bca000  ! 3796: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 3797: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a62000  ! 3798: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x7f8, %r23
	.word 0xd49e6000  ! 3801: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r10
	.word 0x87802072  ! 3802: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4862000  ! 3803: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r10
	.word 0xd2a78e60  ! 3804: STWA_R	stwa	%r9, [%r30 + %r0] 0x73
	.word 0x87802025  ! 3805: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2afce60  ! 3806: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	.word 0xd28d04a0  ! 3807: LDUBA_R	lduba	[%r20, %r0] 0x25, %r9
	mov	0x78, %r16
	.word 0xd4c689e0  ! 3809: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r10
	.word 0xd4b7a000  ! 3810: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd4ae49e0  ! 3811: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0xd4a72000  ! 3812: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	mov	0x48, %r17
	mov	0x30, %r25
	mov	0x3f8, %r22
	.word 0xd4afe000  ! 3816: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xda9f4e60  ! 3817: LDDA_R	ldda	[%r29, %r0] 0x73, %r13
	.word 0x87802025  ! 3818: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeccc400  ! 3819: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r15
	mov	0x7f0, %r21
	.word 0xde8d84a0  ! 3821: LDUBA_R	lduba	[%r22, %r0] 0x25, %r15
	mov	0x3c8, %r21
	.word 0xd0cf2000  ! 3823: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0xd0a7e000  ! 3824: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	mov	0x7d0, %r20
	.word 0xd0d7a000  ! 3826: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0x87802020  ! 3827: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r19
	.word 0xd0d7e000  ! 3829: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0dfce60  ! 3830: LDXA_R	ldxa	[%r31, %r0] 0x73, %r8
	.word 0xd0af0e40  ! 3831: STBA_R	stba	%r8, [%r28 + %r0] 0x72
	mov	0x8, %r17
	.word 0xd4a76000  ! 3833: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 3834: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd69f0e60  ! 3835: LDDA_R	ldda	[%r28, %r0] 0x73, %r11
	.word 0x87802073  ! 3836: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd49f2000  ! 3837: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd4974e60  ! 3838: LDUHA_R	lduha	[%r29, %r0] 0x73, %r10
	.word 0xd2878e80  ! 3839: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r9
	.word 0xd4844400  ! 3840: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0xded7a000  ! 3841: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xd4c504a0  ! 3842: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r10
	.word 0xd2df2000  ! 3843: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2df6000  ! 3844: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2b7a000  ! 3845: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xdcd70e60  ! 3846: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r14
	.word 0xd2b7a000  ! 3847: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 3848: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaacc400  ! 3849: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0xd8f7a000  ! 3850: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8cfe000  ! 3851: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8f7e000  ! 3852: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8976000  ! 3853: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0xd8af2000  ! 3854: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xd8ae89e0  ! 3855: STBA_R	stba	%r12, [%r26 + %r0] 0x4f
	.word 0xdca40400  ! 3856: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xd0f70e60  ! 3857: STXA_R	stxa	%r8, [%r28 + %r0] 0x73
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2b40400  ! 3859: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0xdeafe000  ! 3860: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xdeb7a000  ! 3861: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	mov	0x10, %r25
	.word 0xdea7e000  ! 3863: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xdef7a000  ! 3864: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdabdc4a0  ! 3865: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	.word 0xd0b74e60  ! 3866: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	mov	0x7f0, %r22
	.word 0xd0a7e000  ! 3868: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 3869: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a72000  ! 3870: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xd09f2000  ! 3871: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	mov	0x48, %r16
	mov	0x50, %r17
	mov	0x78, %r26
	.word 0xd6bf4e80  ! 3875: STDA_R	stda	%r11, [%r29 + %r0] 0x74
	.word 0xdedf6000  ! 3876: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xdea7a000  ! 3877: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xdebf6000  ! 3878: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 3879: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3880: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 3881: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeaf2000  ! 3882: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xde8fa000  ! 3883: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0xdea7e000  ! 3884: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	mov	0x3f0, %r23
	.word 0xdedfa000  ! 3886: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xd4874e60  ! 3887: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r10
	.word 0x87802073  ! 3888: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 3889: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd69c2000  ! 3890: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r11
	.word 0xd6b4e000  ! 3891: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xd2b44400  ! 3893: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0xd4848400  ! 3894: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r10
	.word 0xd0bc6000  ! 3895: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	.word 0xdabcc400  ! 3896: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	mov	0x58, %r17
	.word 0xd0942000  ! 3898: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r8
	.word 0xd0b46000  ! 3899: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3900: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0dfa000  ! 3901: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	mov	0x20, %r25
	.word 0x87802020  ! 3903: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0dc2000  ! 3904: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	.word 0xd0842000  ! 3905: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r8
	.word 0x87802025  ! 3906: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd09d84a0  ! 3907: LDDA_R	ldda	[%r22, %r0] 0x25, %r8
	.word 0xd8bcc400  ! 3908: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 3909: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r24
	.word 0x8780204f  ! 3911: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r23
	.word 0xd6df2000  ! 3913: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6c76000  ! 3914: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6c7a000  ! 3915: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	mov	0x7e0, %r23
	.word 0xdac78e80  ! 3917: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r13
	.word 0xd4dfa000  ! 3918: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4afa000  ! 3919: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd4c7e000  ! 3920: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4b7e000  ! 3921: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xdc9f4e40  ! 3922: LDDA_R	ldda	[%r29, %r0] 0x72, %r14
	.word 0xd6b5c4a0  ! 3923: STHA_R	stha	%r11, [%r23 + %r0] 0x25
	.word 0x87802073  ! 3924: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc8f6000  ! 3925: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0x87802074  ! 3926: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3927: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf66000  ! 3928: STXA_I	stxa	%r14, [%r25 + 0x0000] %asi
	.word 0xdc8ee000  ! 3929: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r14
	mov	0x7f8, %r22
	mov	0x7e8, %r22
	mov	0x68, %r26
	mov	0x70, %r19
	.word 0xdca62000  ! 3934: STWA_I	stwa	%r14, [%r24 + 0x0000] %asi
	.word 0xdc9e6000  ! 3935: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r14
	mov	0x48, %r18
	.word 0xdcce6000  ! 3937: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r14
	.word 0xdc866000  ! 3938: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r14
	.word 0xdcb6a000  ! 3939: STHA_I	stha	%r14, [%r26 + 0x0000] %asi
	.word 0xd4d44400  ! 3940: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0xd28ea000  ! 3941: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r9
	.word 0xd2d6e000  ! 3942: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r9
	.word 0xd28ee000  ! 3943: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r9
	.word 0xdcbc0400  ! 3944: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0xd2a6e000  ! 3945: STWA_I	stwa	%r9, [%r27 + 0x0000] %asi
	.word 0xd0cfce60  ! 3946: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r8
	.word 0xd2d48400  ! 3947: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	.word 0xd6dd04a0  ! 3948: LDXA_R	ldxa	[%r20, %r0] 0x25, %r11
	.word 0xd0f7ce60  ! 3949: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	mov	0x58, %r16
	mov	0x40, %r17
	.word 0xd0d7ce60  ! 3952: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r8
	.word 0xdecf4e60  ! 3953: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r15
	mov	0x68, %r19
	.word 0xd4b584a0  ! 3955: STHA_R	stha	%r10, [%r22 + %r0] 0x25
	.word 0xdef6a000  ! 3956: STXA_I	stxa	%r15, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 3957: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeaca000  ! 3958: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xdab44400  ! 3959: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0x87802074  ! 3960: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a7a000  ! 3961: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xdedfce40  ! 3963: LDXA_R	ldxa	[%r31, %r0] 0x72, %r15
	.word 0xdea7e000  ! 3964: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 3965: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4bf0e80  ! 3966: STDA_R	stda	%r10, [%r28 + %r0] 0x74
	.word 0xd88c2000  ! 3967: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	mov	0x58, %r16
	.word 0xd884a000  ! 3969: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r12
	.word 0xdab4c400  ! 3970: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0x87802020  ! 3971: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbd84a0  ! 3972: STDA_R	stda	%r14, [%r22 + %r0] 0x25
	mov	0x3f8, %r20
	.word 0xd8f609e0  ! 3974: STXA_R	stxa	%r12, [%r24 + %r0] 0x4f
	mov	0x3c8, %r20
	.word 0xd0944400  ! 3976: LDUHA_R	lduha	[%r17, %r0] 0x20, %r8
	.word 0xd29cc400  ! 3977: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	.word 0xd4cc4400  ! 3978: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r10
	mov	0x0, %r18
	.word 0x87802020  ! 3980: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r25
	mov	0x58, %r26
	.word 0xdcb5e000  ! 3983: STHA_I	stha	%r14, [%r23 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdc8da000  ! 3985: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r14
	mov	0x28, %r25
	.word 0xda870e60  ! 3987: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r13
	.word 0x8780204f  ! 3988: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0bce000  ! 3989: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0xd0bce000  ! 3990: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0xd8a5c4a0  ! 3991: STWA_R	stwa	%r12, [%r23 + %r0] 0x25
	.word 0x87802020  ! 3992: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a609e0  ! 3993: STWA_R	stwa	%r8, [%r24 + %r0] 0x4f
	.word 0xdac5e000  ! 3994: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r13
	.word 0xdad5e000  ! 3995: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r13
	.word 0xd2dd04a0  ! 3996: LDXA_R	ldxa	[%r20, %r0] 0x25, %r9
	.word 0x87802073  ! 3997: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf4e000  ! 3998: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xd08f8e80  ! 3999: LDUBA_R	lduba	[%r30, %r0] 0x74, %r8
	.word 0xd2cca000  ! 4000: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2d42000  ! 4001: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0xd6bfce80  ! 4002: STDA_R	stda	%r11, [%r31 + %r0] 0x74
	.word 0xdea4e000  ! 4003: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xde842000  ! 4004: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	.word 0xdebdc4a0  ! 4005: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	.word 0xd4ac2000  ! 4006: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0xd4b46000  ! 4007: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 4008: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea70e80  ! 4009: STWA_R	stwa	%r15, [%r28 + %r0] 0x74
	.word 0xde8f4e40  ! 4010: LDUBA_R	lduba	[%r29, %r0] 0x72, %r15
	.word 0xd6c70e40  ! 4011: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r11
	.word 0xd2df6000  ! 4012: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	mov	0x38, %r19
	.word 0xdcb70e80  ! 4014: STHA_R	stha	%r14, [%r28 + %r0] 0x74
	.word 0xd2976000  ! 4015: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	mov	0x60, %r25
	.word 0xd2b76000  ! 4017: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2b7e000  ! 4018: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2c7a000  ! 4019: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2bf2000  ! 4020: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	mov	0x20, %r26
	.word 0xd2afe000  ! 4022: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	mov	0x28, %r18
	.word 0x87802025  ! 4024: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bd6000  ! 4025: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	.word 0x87802074  ! 4026: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4027: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29fa000  ! 4028: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd2afa000  ! 4029: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xd2af6000  ! 4030: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd2b72000  ! 4031: STHA_I	stha	%r9, [%r28 + 0x00