// Modified by Princeton University on June 9th, 2015
// ========== Copyright Header Begin ==========================================
// 
// OpenSPARC T1 Processor File: l2warm.v
// Copyright (c) 2006 Sun Microsystems, Inc.  All Rights Reserved.
// DO NOT ALTER OR REMOVE COPYRIGHT NOTICES.
// 
// The above named program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License version 2 as published by the Free Software Foundation.
// 
// The above named program is distributed in the hope that it will be 
// useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public
// License along with this work; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
// 
// ========== Copyright Header End ============================================
// ***************************************************************************
//
// File:        l2warm.v
// Description: warm l2 cache.
// 
// ***************************************************************************
module l2warm();
   //integer idx;
   //reg [155:0] tmp;
   
   
   initial 
     begin
	#100 //wait for memory read.
	$l2_warm(//sctag0 signals
		 //bank 0
		 `SCPATH0.tag.subbank01.way0,
		 `SCPATH0.tag.subbank01.way1,
		 `SCPATH0.tag.subbank23.way0,
		 `SCPATH0.tag.subbank23.way1,
		 `SCPATH0.tag.subbank45.way0,
		 `SCPATH0.tag.subbank45.way1,
		 `SCPATH0.tag.subbank67.way0,
		 `SCPATH0.tag.subbank67.way1,
		 `SCPATH0.tag.subbank89.way0,
		 `SCPATH0.tag.subbank89.way1,
		 `SCPATH0.tag.subbankab.way0,
		 `SCPATH0.tag.subbankab.way1,
		 //vuad
		 `SCPATH0.subarray_0.inq_ary,
		 `SCPATH0.subarray_1.inq_ary,
		 `SCPATH0.subarray_2.inq_ary,
		 `SCPATH0.subarray_3.inq_ary,
		 `SCPATH0.subarray_4.inq_ary,
		 `SCPATH0.subarray_5.inq_ary,
		 `SCPATH0.subarray_6.inq_ary,
		 `SCPATH0.subarray_7.inq_ary,

		 `SCPATH0.subarray_8.inq_ary,
		 `SCPATH0.subarray_9.inq_ary,
		 `SCPATH0.subarray_10.inq_ary,
		 `SCPATH0.subarray_11.inq_ary,
		 `SCPATH0.subarray_12.inq_ary,
		 `SCPATH0.subarray_13.inq_ary,
		 `SCPATH0.subarray_14.inq_ary,
		 `SCPATH0.subarray_15.inq_ary,
		 
		 //data
		 `SCDPATH0.subbank_0.data_array_0.mem_0.way0_decc,
		 `SCDPATH0.subbank_0.data_array_0.mem_0.way1_decc,
		 `SCDPATH0.subbank_0.data_array_0.mem_1.way0_decc,
		 `SCDPATH0.subbank_0.data_array_0.mem_1.way1_decc,
		 `SCDPATH0.subbank_0.data_array_1.mem_0.way0_decc,
		 `SCDPATH0.subbank_0.data_array_1.mem_0.way1_decc,
		 `SCDPATH0.subbank_0.data_array_1.mem_1.way0_decc,
		 `SCDPATH0.subbank_0.data_array_1.mem_1.way1_decc,
		 `SCDPATH0.subbank_0.data_array_2.mem_0.way0_decc,
		 `SCDPATH0.subbank_0.data_array_2.mem_0.way1_decc,
		 `SCDPATH0.subbank_0.data_array_2.mem_1.way0_decc,
		 `SCDPATH0.subbank_0.data_array_2.mem_1.way1_decc,

		 `SCDPATH0.subbank_1.data_array_0.mem_0.way0_decc,
		 `SCDPATH0.subbank_1.data_array_0.mem_0.way1_decc,
		 `SCDPATH0.subbank_1.data_array_0.mem_1.way0_decc,
		 `SCDPATH0.subbank_1.data_array_0.mem_1.way1_decc,
		 `SCDPATH0.subbank_1.data_array_1.mem_0.way0_decc,
		 `SCDPATH0.subbank_1.data_array_1.mem_0.way1_decc,
		 `SCDPATH0.subbank_1.data_array_1.mem_1.way0_decc,
		 `SCDPATH0.subbank_1.data_array_1.mem_1.way1_decc,
		 `SCDPATH0.subbank_1.data_array_2.mem_0.way0_decc,
		 `SCDPATH0.subbank_1.data_array_2.mem_0.way1_decc,
		 `SCDPATH0.subbank_1.data_array_2.mem_1.way0_decc,
		 `SCDPATH0.subbank_1.data_array_2.mem_1.way1_decc,

		 `SCDPATH0.subbank_2.data_array_0.mem_0.way0_decc,
		 `SCDPATH0.subbank_2.data_array_0.mem_0.way1_decc,
		 `SCDPATH0.subbank_2.data_array_0.mem_1.way0_decc,
		 `SCDPATH0.subbank_2.data_array_0.mem_1.way1_decc,
		 `SCDPATH0.subbank_2.data_array_1.mem_0.way0_decc,
		 `SCDPATH0.subbank_2.data_array_1.mem_0.way1_decc,
		 `SCDPATH0.subbank_2.data_array_1.mem_1.way0_decc,
		 `SCDPATH0.subbank_2.data_array_1.mem_1.way1_decc,
		 `SCDPATH0.subbank_2.data_array_2.mem_0.way0_decc,
		 `SCDPATH0.subbank_2.data_array_2.mem_0.way1_decc,
		 `SCDPATH0.subbank_2.data_array_2.mem_1.way0_decc,
		 `SCDPATH0.subbank_2.data_array_2.mem_1.way1_decc,

		 `SCDPATH0.subbank_3.data_array_0.mem_0.way0_decc,
		 `SCDPATH0.subbank_3.data_array_0.mem_0.way1_decc,
		 `SCDPATH0.subbank_3.data_array_0.mem_1.way0_decc,
		 `SCDPATH0.subbank_3.data_array_0.mem_1.way1_decc,
		 `SCDPATH0.subbank_3.data_array_1.mem_0.way0_decc,
		 `SCDPATH0.subbank_3.data_array_1.mem_0.way1_decc,
		 `SCDPATH0.subbank_3.data_array_1.mem_1.way0_decc,
		 `SCDPATH0.subbank_3.data_array_1.mem_1.way1_decc,
		 `SCDPATH0.subbank_3.data_array_2.mem_0.way0_decc,
		 `SCDPATH0.subbank_3.data_array_2.mem_0.way1_decc,
		 `SCDPATH0.subbank_3.data_array_2.mem_1.way0_decc,
		 `SCDPATH0.subbank_3.data_array_2.mem_1.way1_decc,
		
		 //bank 01
		 `SCPATH1.tag.subbank01.way0,
		 `SCPATH1.tag.subbank01.way1,
		 `SCPATH1.tag.subbank23.way0,
		 `SCPATH1.tag.subbank23.way1,
		 `SCPATH1.tag.subbank45.way0,
		 `SCPATH1.tag.subbank45.way1,
		 `SCPATH1.tag.subbank67.way0,
		 `SCPATH1.tag.subbank67.way1,
		 `SCPATH1.tag.subbank89.way0,
		 `SCPATH1.tag.subbank89.way1,
		 `SCPATH1.tag.subbankab.way0,
		 `SCPATH1.tag.subbankab.way1,
		  //vuad
		 `SCPATH1.subarray_0.inq_ary,
		 `SCPATH1.subarray_1.inq_ary,
		 `SCPATH1.subarray_2.inq_ary,
		 `SCPATH1.subarray_3.inq_ary,
		 `SCPATH1.subarray_4.inq_ary,
		 `SCPATH1.subarray_5.inq_ary,
		 `SCPATH1.subarray_6.inq_ary,
		 `SCPATH1.subarray_7.inq_ary,
		 `SCPATH1.subarray_8.inq_ary,
		 `SCPATH1.subarray_9.inq_ary,
		 `SCPATH1.subarray_10.inq_ary,
		 `SCPATH1.subarray_11.inq_ary,
		 `SCPATH1.subarray_12.inq_ary,
		 `SCPATH1.subarray_13.inq_ary,
		 `SCPATH1.subarray_14.inq_ary,
		 `SCPATH1.subarray_15.inq_ary,
		 //data
		 `SCDPATH1.subbank_0.data_array_0.mem_0.way0_decc,
		 `SCDPATH1.subbank_0.data_array_0.mem_0.way1_decc,
		 `SCDPATH1.subbank_0.data_array_0.mem_1.way0_decc,
		 `SCDPATH1.subbank_0.data_array_0.mem_1.way1_decc,
		 `SCDPATH1.subbank_0.data_array_1.mem_0.way0_decc,
		 `SCDPATH1.subbank_0.data_array_1.mem_0.way1_decc,
		 `SCDPATH1.subbank_0.data_array_1.mem_1.way0_decc,
		 `SCDPATH1.subbank_0.data_array_1.mem_1.way1_decc,
		 `SCDPATH1.subbank_0.data_array_2.mem_0.way0_decc,
		 `SCDPATH1.subbank_0.data_array_2.mem_0.way1_decc,
		 `SCDPATH1.subbank_0.data_array_2.mem_1.way0_decc,
		 `SCDPATH1.subbank_0.data_array_2.mem_1.way1_decc,

		 `SCDPATH1.subbank_1.data_array_0.mem_0.way0_decc,
		 `SCDPATH1.subbank_1.data_array_0.mem_0.way1_decc,
		 `SCDPATH1.subbank_1.data_array_0.mem_1.way0_decc,
		 `SCDPATH1.subbank_1.data_array_0.mem_1.way1_decc,
		 `SCDPATH1.subbank_1.data_array_1.mem_0.way0_decc,
		 `SCDPATH1.subbank_1.data_array_1.mem_0.way1_decc,
		 `SCDPATH1.subbank_1.data_array_1.mem_1.way0_decc,
		 `SCDPATH1.subbank_1.data_array_1.mem_1.way1_decc,
		 `SCDPATH1.subbank_1.data_array_2.mem_0.way0_decc,
		 `SCDPATH1.subbank_1.data_array_2.mem_0.way1_decc,
		 `SCDPATH1.subbank_1.data_array_2.mem_1.way0_decc,
		 `SCDPATH1.subbank_1.data_array_2.mem_1.way1_decc,

		 `SCDPATH1.subbank_2.data_array_0.mem_0.way0_decc,
		 `SCDPATH1.subbank_2.data_array_0.mem_0.way1_decc,
		 `SCDPATH1.subbank_2.data_array_0.mem_1.way0_decc,
		 `SCDPATH1.subbank_2.data_array_0.mem_1.way1_decc,
		 `SCDPATH1.subbank_2.data_array_1.mem_0.way0_decc,
		 `SCDPATH1.subbank_2.data_array_1.mem_0.way1_decc,
		 `SCDPATH1.subbank_2.data_array_1.mem_1.way0_decc,
		 `SCDPATH1.subbank_2.data_array_1.mem_1.way1_decc,
		 `SCDPATH1.subbank_2.data_array_2.mem_0.way0_decc,
		 `SCDPATH1.subbank_2.data_array_2.mem_0.way1_decc,
		 `SCDPATH1.subbank_2.data_array_2.mem_1.way0_decc,
		 `SCDPATH1.subbank_2.data_array_2.mem_1.way1_decc,

		 `SCDPATH1.subbank_3.data_array_0.mem_0.way0_decc,
		 `SCDPATH1.subbank_3.data_array_0.mem_0.way1_decc,
		 `SCDPATH1.subbank_3.data_array_0.mem_1.way0_decc,
		 `SCDPATH1.subbank_3.data_array_0.mem_1.way1_decc,
		 `SCDPATH1.subbank_3.data_array_1.mem_0.way0_decc,
		 `SCDPATH1.subbank_3.data_array_1.mem_0.way1_decc,
		 `SCDPATH1.subbank_3.data_array_1.mem_1.way0_decc,
		 `SCDPATH1.subbank_3.data_array_1.mem_1.way1_decc,
		 `SCDPATH1.subbank_3.data_array_2.mem_0.way0_decc,
		 `SCDPATH1.subbank_3.data_array_2.mem_0.way1_decc,
		 `SCDPATH1.subbank_3.data_array_2.mem_1.way0_decc,
		 `SCDPATH1.subbank_3.data_array_2.mem_1.way1_decc,
		
		 //bank 10
		 `SCPATH2.tag.subbank01.way0,
		 `SCPATH2.tag.subbank01.way1,
		 `SCPATH2.tag.subbank23.way0,
		 `SCPATH2.tag.subbank23.way1,
		 `SCPATH2.tag.subbank45.way0,
		 `SCPATH2.tag.subbank45.way1,
		 `SCPATH2.tag.subbank67.way0,
		 `SCPATH2.tag.subbank67.way1,
		 `SCPATH2.tag.subbank89.way0,
		 `SCPATH2.tag.subbank89.way1,
		 `SCPATH2.tag.subbankab.way0,
		 `SCPATH2.tag.subbankab.way1,
		 //vuad
		 `SCPATH2.subarray_0.inq_ary,
		 `SCPATH2.subarray_1.inq_ary,
		 `SCPATH2.subarray_2.inq_ary,
		 `SCPATH2.subarray_3.inq_ary,
		 `SCPATH2.subarray_4.inq_ary,
		 `SCPATH2.subarray_5.inq_ary,
		 `SCPATH2.subarray_6.inq_ary,
		 `SCPATH2.subarray_7.inq_ary,
		 `SCPATH2.subarray_8.inq_ary,
		 `SCPATH2.subarray_9.inq_ary,
		 `SCPATH2.subarray_10.inq_ary,
		 `SCPATH2.subarray_11.inq_ary,
		 `SCPATH2.subarray_12.inq_ary,
		 `SCPATH2.subarray_13.inq_ary,
		 `SCPATH2.subarray_14.inq_ary,
		 `SCPATH2.subarray_15.inq_ary,
		  //data
		 `SCDPATH2.subbank_0.data_array_0.mem_0.way0_decc,
		 `SCDPATH2.subbank_0.data_array_0.mem_0.way1_decc,
		 `SCDPATH2.subbank_0.data_array_0.mem_1.way0_decc,
		 `SCDPATH2.subbank_0.data_array_0.mem_1.way1_decc,
		 `SCDPATH2.subbank_0.data_array_1.mem_0.way0_decc,
		 `SCDPATH2.subbank_0.data_array_1.mem_0.way1_decc,
		 `SCDPATH2.subbank_0.data_array_1.mem_1.way0_decc,
		 `SCDPATH2.subbank_0.data_array_1.mem_1.way1_decc,
		 `SCDPATH2.subbank_0.data_array_2.mem_0.way0_decc,
		 `SCDPATH2.subbank_0.data_array_2.mem_0.way1_decc,
		 `SCDPATH2.subbank_0.data_array_2.mem_1.way0_decc,
		 `SCDPATH2.subbank_0.data_array_2.mem_1.way1_decc,

		 `SCDPATH2.subbank_1.data_array_0.mem_0.way0_decc,
		 `SCDPATH2.subbank_1.data_array_0.mem_0.way1_decc,
		 `SCDPATH2.subbank_1.data_array_0.mem_1.way0_decc,
		 `SCDPATH2.subbank_1.data_array_0.mem_1.way1_decc,
		 `SCDPATH2.subbank_1.data_array_1.mem_0.way0_decc,
		 `SCDPATH2.subbank_1.data_array_1.mem_0.way1_decc,
		 `SCDPATH2.subbank_1.data_array_1.mem_1.way0_decc,
		 `SCDPATH2.subbank_1.data_array_1.mem_1.way1_decc,
		 `SCDPATH2.subbank_1.data_array_2.mem_0.way0_decc,
		 `SCDPATH2.subbank_1.data_array_2.mem_0.way1_decc,
		 `SCDPATH2.subbank_1.data_array_2.mem_1.way0_decc,
		 `SCDPATH2.subbank_1.data_array_2.mem_1.way1_decc,

		 `SCDPATH2.subbank_2.data_array_0.mem_0.way0_decc,
		 `SCDPATH2.subbank_2.data_array_0.mem_0.way1_decc,
		 `SCDPATH2.subbank_2.data_array_0.mem_1.way0_decc,
		 `SCDPATH2.subbank_2.data_array_0.mem_1.way1_decc,
		 `SCDPATH2.subbank_2.data_array_1.mem_0.way0_decc,
		 `SCDPATH2.subbank_2.data_array_1.mem_0.way1_decc,
		 `SCDPATH2.subbank_2.data_array_1.mem_1.way0_decc,
		 `SCDPATH2.subbank_2.data_array_1.mem_1.way1_decc,
		 `SCDPATH2.subbank_2.data_array_2.mem_0.way0_decc,
		 `SCDPATH2.subbank_2.data_array_2.mem_0.way1_decc,
		 `SCDPATH2.subbank_2.data_array_2.mem_1.way0_decc,
		 `SCDPATH2.subbank_2.data_array_2.mem_1.way1_decc,

		 `SCDPATH2.subbank_3.data_array_0.mem_0.way0_decc,
		 `SCDPATH2.subbank_3.data_array_0.mem_0.way1_decc,
		 `SCDPATH2.subbank_3.data_array_0.mem_1.way0_decc,
		 `SCDPATH2.subbank_3.data_array_0.mem_1.way1_decc,
		 `SCDPATH2.subbank_3.data_array_1.mem_0.way0_decc,
		 `SCDPATH2.subbank_3.data_array_1.mem_0.way1_decc,
		 `SCDPATH2.subbank_3.data_array_1.mem_1.way0_decc,
		 `SCDPATH2.subbank_3.data_array_1.mem_1.way1_decc,
		 `SCDPATH2.subbank_3.data_array_2.mem_0.way0_decc,
		 `SCDPATH2.subbank_3.data_array_2.mem_0.way1_decc,
		 `SCDPATH2.subbank_3.data_array_2.mem_1.way0_decc,
		 `SCDPATH2.subbank_3.data_array_2.mem_1.way1_decc,
		 
		
		 //bank 11
		 `SCPATH3.tag.subbank01.way0,
		 `SCPATH3.tag.subbank01.way1,
		 `SCPATH3.tag.subbank23.way0,
		 `SCPATH3.tag.subbank23.way1,
		 `SCPATH3.tag.subbank45.way0,
		 `SCPATH3.tag.subbank45.way1,
		 `SCPATH3.tag.subbank67.way0,
		 `SCPATH3.tag.subbank67.way1,
		 `SCPATH3.tag.subbank89.way0,
		 `SCPATH3.tag.subbank89.way1,
		 `SCPATH3.tag.subbankab.way0,
		 `SCPATH3.tag.subbankab.way1,
		 //vuad
		 `SCPATH3.subarray_0.inq_ary,
		 `SCPATH3.subarray_1.inq_ary,
		 `SCPATH3.subarray_2.inq_ary,
		 `SCPATH3.subarray_3.inq_ary,
		 `SCPATH3.subarray_4.inq_ary,
		 `SCPATH3.subarray_5.inq_ary,
		 `SCPATH3.subarray_6.inq_ary,
		 `SCPATH3.subarray_7.inq_ary,
		 `SCPATH3.subarray_8.inq_ary,
		 `SCPATH3.subarray_9.inq_ary,
		 `SCPATH3.subarray_10.inq_ary,
		 `SCPATH3.subarray_11.inq_ary,
		 `SCPATH3.subarray_12.inq_ary,
		 `SCPATH3.subarray_13.inq_ary,
		 `SCPATH3.subarray_14.inq_ary,
		 `SCPATH3.subarray_15.inq_ary,
		  //data
		 `SCDPATH3.subbank_0.data_array_0.mem_0.way0_decc,
		 `SCDPATH3.subbank_0.data_array_0.mem_0.way1_decc,
		 `SCDPATH3.subbank_0.data_array_0.mem_1.way0_decc,
		 `SCDPATH3.subbank_0.data_array_0.mem_1.way1_decc,
		 `SCDPATH3.subbank_0.data_array_1.mem_0.way0_decc,
		 `SCDPATH3.subbank_0.data_array_1.mem_0.way1_decc,
		 `SCDPATH3.subbank_0.data_array_1.mem_1.way0_decc,
		 `SCDPATH3.subbank_0.data_array_1.mem_1.way1_decc,
		 `SCDPATH3.subbank_0.data_array_2.mem_0.way0_decc,
		 `SCDPATH3.subbank_0.data_array_2.mem_0.way1_decc,
		 `SCDPATH3.subbank_0.data_array_2.mem_1.way0_decc,
		 `SCDPATH3.subbank_0.data_array_2.mem_1.way1_decc,

		 `SCDPATH3.subbank_1.data_array_0.mem_0.way0_decc,
		 `SCDPATH3.subbank_1.data_array_0.mem_0.way1_decc,
		 `SCDPATH3.subbank_1.data_array_0.mem_1.way0_decc,
		 `SCDPATH3.subbank_1.data_array_0.mem_1.way1_decc,
		 `SCDPATH3.subbank_1.data_array_1.mem_0.way0_decc,
		 `SCDPATH3.subbank_1.data_array_1.mem_0.way1_decc,
		 `SCDPATH3.subbank_1.data_array_1.mem_1.way0_decc,
		 `SCDPATH3.subbank_1.data_array_1.mem_1.way1_decc,
		 `SCDPATH3.subbank_1.data_array_2.mem_0.way0_decc,
		 `SCDPATH3.subbank_1.data_array_2.mem_0.way1_decc,
		 `SCDPATH3.subbank_1.data_array_2.mem_1.way0_decc,
		 `SCDPATH3.subbank_1.data_array_2.mem_1.way1_decc,

		 `SCDPATH3.subbank_2.data_array_0.mem_0.way0_decc,
		 `SCDPATH3.subbank_2.data_array_0.mem_0.way1_decc,
		 `SCDPATH3.subbank_2.data_array_0.mem_1.way0_decc,
		 `SCDPATH3.subbank_2.data_array_0.mem_1.way1_decc,
		 `SCDPATH3.subbank_2.data_array_1.mem_0.way0_decc,
		 `SCDPATH3.subbank_2.data_array_1.mem_0.way1_decc,
		 `SCDPATH3.subbank_2.data_array_1.mem_1.way0_decc,
		 `SCDPATH3.subbank_2.data_array_1.mem_1.way1_decc,
		 `SCDPATH3.subbank_2.data_array_2.mem_0.way0_decc,
		 `SCDPATH3.subbank_2.data_array_2.mem_0.way1_decc,
		 `SCDPATH3.subbank_2.data_array_2.mem_1.way0_decc,
		 `SCDPATH3.subbank_2.data_array_2.mem_1.way1_decc,

		 `SCDPATH3.subbank_3.data_array_0.mem_0.way0_decc,
		 `SCDPATH3.subbank_3.data_array_0.mem_0.way1_decc,
		 `SCDPATH3.subbank_3.data_array_0.mem_1.way0_decc,
		 `SCDPATH3.subbank_3.data_array_0.mem_1.way1_decc,
		 `SCDPATH3.subbank_3.data_array_1.mem_0.way0_decc,
		 `SCDPATH3.subbank_3.data_array_1.mem_0.way1_decc,
		 `SCDPATH3.subbank_3.data_array_1.mem_1.way0_decc,
		 `SCDPATH3.subbank_3.data_array_1.mem_1.way1_decc,
		 `SCDPATH3.subbank_3.data_array_2.mem_0.way0_decc,
		 `SCDPATH3.subbank_3.data_array_2.mem_0.way1_decc,
		 `SCDPATH3.subbank_3.data_array_2.mem_1.way0_decc,
		 `SCDPATH3.subbank_3.data_array_2.mem_1.way1_decc
		 );

	//cache slam
	$slam_cache(2,
		    //directory
		    `SCPATH0.dc_row0.panel_pair0.panel0.addr_array,
		    `SCPATH0.dc_row0.panel_pair0.panel0.valid,
		    `SCPATH0.dc_row0.panel_pair0.panel0.parity,
		    `SCPATH0.dc_row0.panel_pair0.panel1.addr_array,
		    `SCPATH0.dc_row0.panel_pair0.panel1.valid,
		    `SCPATH0.dc_row0.panel_pair0.panel1.parity,
		    
		    `SCPATH0.dc_row0.panel_pair1.panel0.addr_array,
		    `SCPATH0.dc_row0.panel_pair1.panel0.valid,
		    `SCPATH0.dc_row0.panel_pair1.panel0.parity,
		    `SCPATH0.dc_row0.panel_pair1.panel1.addr_array,
		    `SCPATH0.dc_row0.panel_pair1.panel1.valid,
		    `SCPATH0.dc_row0.panel_pair1.panel1.parity,
		    
		    `SCPATH0.dc_row1.panel_pair0.panel0.addr_array,
		    `SCPATH0.dc_row1.panel_pair0.panel0.valid,
		    `SCPATH0.dc_row1.panel_pair0.panel0.parity,	 
		    `SCPATH0.dc_row1.panel_pair0.panel1.addr_array,
		    `SCPATH0.dc_row1.panel_pair0.panel1.valid,
		    `SCPATH0.dc_row1.panel_pair0.panel1.parity,
		    
		    `SCPATH0.dc_row1.panel_pair1.panel0.addr_array,
		    `SCPATH0.dc_row1.panel_pair1.panel0.valid,
		    `SCPATH0.dc_row1.panel_pair1.panel0.parity,	 
		    `SCPATH0.dc_row1.panel_pair1.panel1.addr_array,
		    `SCPATH0.dc_row1.panel_pair1.panel1.valid,
		    `SCPATH0.dc_row1.panel_pair1.panel1.parity,
		    
		    `SCPATH0.dc_row2.panel_pair0.panel0.addr_array,
		    `SCPATH0.dc_row2.panel_pair0.panel0.valid,
		    `SCPATH0.dc_row2.panel_pair0.panel0.parity,	 
		    `SCPATH0.dc_row2.panel_pair0.panel1.addr_array,
		    `SCPATH0.dc_row2.panel_pair0.panel1.valid,
		    `SCPATH0.dc_row2.panel_pair0.panel1.parity,
		    
		    `SCPATH0.dc_row2.panel_pair1.panel0.addr_array,
		    `SCPATH0.dc_row2.panel_pair1.panel0.valid,
		    `SCPATH0.dc_row2.panel_pair1.panel0.parity,	 
		    `SCPATH0.dc_row2.panel_pair1.panel1.addr_array,
		    `SCPATH0.dc_row2.panel_pair1.panel1.valid,
		    `SCPATH0.dc_row2.panel_pair1.panel1.parity,
		    
		    `SCPATH0.dc_row3.panel_pair0.panel0.addr_array,
		    `SCPATH0.dc_row3.panel_pair0.panel0.valid,
		    `SCPATH0.dc_row3.panel_pair0.panel0.parity,	 
		    `SCPATH0.dc_row3.panel_pair0.panel1.addr_array,
		    `SCPATH0.dc_row3.panel_pair0.panel1.valid,
		    `SCPATH0.dc_row3.panel_pair0.panel1.parity,
		 
		    `SCPATH0.dc_row3.panel_pair1.panel0.addr_array,
		    `SCPATH0.dc_row3.panel_pair1.panel0.valid,
		    `SCPATH0.dc_row3.panel_pair1.panel0.parity,	 
		    `SCPATH0.dc_row3.panel_pair1.panel1.addr_array,
		    `SCPATH0.dc_row3.panel_pair1.panel1.valid,
		    `SCPATH0.dc_row3.panel_pair1.panel1.parity,
		 
		    //bank 01
		    //dcache site
		    `SCPATH1.dc_row0.panel_pair0.panel0.addr_array,
		    `SCPATH1.dc_row0.panel_pair0.panel0.valid,
		    `SCPATH1.dc_row0.panel_pair0.panel0.parity,	 
		    `SCPATH1.dc_row0.panel_pair0.panel1.addr_array,
		    `SCPATH1.dc_row0.panel_pair0.panel1.valid,
		    `SCPATH1.dc_row0.panel_pair0.panel1.parity,
		    
		    `SCPATH1.dc_row0.panel_pair1.panel0.addr_array,
		    `SCPATH1.dc_row0.panel_pair1.panel0.valid,
		    `SCPATH1.dc_row0.panel_pair1.panel0.parity,	 
		    `SCPATH1.dc_row0.panel_pair1.panel1.addr_array,
		    `SCPATH1.dc_row0.panel_pair1.panel1.valid,
		    `SCPATH1.dc_row0.panel_pair1.panel1.parity,
		 
		    `SCPATH1.dc_row1.panel_pair0.panel0.addr_array,
		    `SCPATH1.dc_row1.panel_pair0.panel0.valid,
		    `SCPATH1.dc_row1.panel_pair0.panel0.parity,	 
		    `SCPATH1.dc_row1.panel_pair0.panel1.addr_array,
		    `SCPATH1.dc_row1.panel_pair0.panel1.valid,
		    `SCPATH1.dc_row1.panel_pair0.panel1.parity,
		    
		    `SCPATH1.dc_row1.panel_pair1.panel0.addr_array,
		    `SCPATH1.dc_row1.panel_pair1.panel0.valid,
		    `SCPATH1.dc_row1.panel_pair1.panel0.parity,	 
		    `SCPATH1.dc_row1.panel_pair1.panel1.addr_array,
		    `SCPATH1.dc_row1.panel_pair1.panel1.valid,
		    `SCPATH1.dc_row1.panel_pair1.panel1.parity,
		 
		    `SCPATH1.dc_row2.panel_pair0.panel0.addr_array,
		    `SCPATH1.dc_row2.panel_pair0.panel0.valid,
		    `SCPATH1.dc_row2.panel_pair0.panel0.parity,	 
		    `SCPATH1.dc_row2.panel_pair0.panel1.addr_array,
		    `SCPATH1.dc_row2.panel_pair0.panel1.valid,
		    `SCPATH1.dc_row2.panel_pair0.panel1.parity,
		 
		    `SCPATH1.dc_row2.panel_pair1.panel0.addr_array,
		    `SCPATH1.dc_row2.panel_pair1.panel0.valid,
		    `SCPATH1.dc_row2.panel_pair1.panel0.parity,	 
		    `SCPATH1.dc_row2.panel_pair1.panel1.addr_array,
		    `SCPATH1.dc_row2.panel_pair1.panel1.valid,
		    `SCPATH1.dc_row2.panel_pair1.panel1.parity,
		    
		    `SCPATH1.dc_row3.panel_pair0.panel0.addr_array,
		    `SCPATH1.dc_row3.panel_pair0.panel0.valid,
		    `SCPATH1.dc_row3.panel_pair0.panel0.parity,	 
		    `SCPATH1.dc_row3.panel_pair0.panel1.addr_array,
		    `SCPATH1.dc_row3.panel_pair0.panel1.valid,
		    `SCPATH1.dc_row3.panel_pair0.panel1.parity,
		 
		    `SCPATH1.dc_row3.panel_pair1.panel0.addr_array,
		    `SCPATH1.dc_row3.panel_pair1.panel0.valid,
		    `SCPATH1.dc_row3.panel_pair1.panel0.parity,	 
		    `SCPATH1.dc_row3.panel_pair1.panel1.addr_array,
		    `SCPATH1.dc_row3.panel_pair1.panel1.valid,
		    `SCPATH1.dc_row3.panel_pair1.panel1.parity,
		    //bank 10
		    //dcache site
		    `SCPATH2.dc_row0.panel_pair0.panel0.addr_array,
		    `SCPATH2.dc_row0.panel_pair0.panel0.valid,
		    `SCPATH2.dc_row0.panel_pair0.panel0.parity,	 
		    `SCPATH2.dc_row0.panel_pair0.panel1.addr_array,
		    `SCPATH2.dc_row0.panel_pair0.panel1.valid,
		    `SCPATH2.dc_row0.panel_pair0.panel1.parity,
		 
		    `SCPATH2.dc_row0.panel_pair1.panel0.addr_array,
		    `SCPATH2.dc_row0.panel_pair1.panel0.valid,
		    `SCPATH2.dc_row0.panel_pair1.panel0.parity,	 
		    `SCPATH2.dc_row0.panel_pair1.panel1.addr_array,
		    `SCPATH2.dc_row0.panel_pair1.panel1.valid,
		    `SCPATH2.dc_row0.panel_pair1.panel1.parity,
		    
		    `SCPATH2.dc_row1.panel_pair0.panel0.addr_array,
		    `SCPATH2.dc_row1.panel_pair0.panel0.valid,
		    `SCPATH2.dc_row1.panel_pair0.panel0.parity,	 
		    `SCPATH2.dc_row1.panel_pair0.panel1.addr_array,
		    `SCPATH2.dc_row1.panel_pair0.panel1.valid,
		    `SCPATH2.dc_row1.panel_pair0.panel1.parity,
		 
		    `SCPATH2.dc_row1.panel_pair1.panel0.addr_array,
		    `SCPATH2.dc_row1.panel_pair1.panel0.valid,
		    `SCPATH2.dc_row1.panel_pair1.panel0.parity,	 
		    `SCPATH2.dc_row1.panel_pair1.panel1.addr_array,
		    `SCPATH2.dc_row1.panel_pair1.panel1.valid,
		    `SCPATH2.dc_row1.panel_pair1.panel1.parity,
		 
		    `SCPATH2.dc_row2.panel_pair0.panel0.addr_array,
		    `SCPATH2.dc_row2.panel_pair0.panel0.valid,
		    `SCPATH2.dc_row2.panel_pair0.panel0.parity,	 
		    `SCPATH2.dc_row2.panel_pair0.panel1.addr_array,
		    `SCPATH2.dc_row2.panel_pair0.panel1.valid,
		    `SCPATH2.dc_row2.panel_pair0.panel1.parity,
		 
		    `SCPATH2.dc_row2.panel_pair1.panel0.addr_array,
		    `SCPATH2.dc_row2.panel_pair1.panel0.valid,
		    `SCPATH2.dc_row2.panel_pair1.panel0.parity,	 
		    `SCPATH2.dc_row2.panel_pair1.panel1.addr_array,
		    `SCPATH2.dc_row2.panel_pair1.panel1.valid,
		    `SCPATH2.dc_row2.panel_pair1.panel1.parity,
		    
		    `SCPATH2.dc_row3.panel_pair0.panel0.addr_array,
		    `SCPATH2.dc_row3.panel_pair0.panel0.valid,
		    `SCPATH2.dc_row3.panel_pair0.panel0.parity,	 
		    `SCPATH2.dc_row3.panel_pair0.panel1.addr_array,
		    `SCPATH2.dc_row3.panel_pair0.panel1.valid,
		    `SCPATH2.dc_row3.panel_pair0.panel1.parity,
		 
		    `SCPATH2.dc_row3.panel_pair1.panel0.addr_array,
		    `SCPATH2.dc_row3.panel_pair1.panel0.valid,
		    `SCPATH2.dc_row3.panel_pair1.panel0.parity,	 
		    `SCPATH2.dc_row3.panel_pair1.panel1.addr_array,
		    `SCPATH2.dc_row3.panel_pair1.panel1.valid,
		    `SCPATH2.dc_row3.panel_pair1.panel1.parity,
		    //bank11
		    //dcache site
		    `SCPATH3.dc_row0.panel_pair0.panel0.addr_array,
		    `SCPATH3.dc_row0.panel_pair0.panel0.valid,
		    `SCPATH3.dc_row0.panel_pair0.panel0.parity,	 
		    `SCPATH3.dc_row0.panel_pair0.panel1.addr_array,
		    `SCPATH3.dc_row0.panel_pair0.panel1.valid,
		    `SCPATH3.dc_row0.panel_pair0.panel1.parity,
		    
		    `SCPATH3.dc_row0.panel_pair1.panel0.addr_array,
		    `SCPATH3.dc_row0.panel_pair1.panel0.valid,
		    `SCPATH3.dc_row0.panel_pair1.panel0.parity,	 
		    `SCPATH3.dc_row0.panel_pair1.panel1.addr_array,
		    `SCPATH3.dc_row0.panel_pair1.panel1.valid,
		    `SCPATH3.dc_row0.panel_pair1.panel1.parity,
		 
		    `SCPATH3.dc_row1.panel_pair0.panel0.addr_array,
		    `SCPATH3.dc_row1.panel_pair0.panel0.valid,
		    `SCPATH3.dc_row1.panel_pair0.panel0.parity,	 
		    `SCPATH3.dc_row1.panel_pair0.panel1.addr_array,
		    `SCPATH3.dc_row1.panel_pair0.panel1.valid,
		    `SCPATH3.dc_row1.panel_pair0.panel1.parity,
		 
		    `SCPATH3.dc_row1.panel_pair1.panel0.addr_array,
		    `SCPATH3.dc_row1.panel_pair1.panel0.valid,
		    `SCPATH3.dc_row1.panel_pair1.panel0.parity,	 
		    `SCPATH3.dc_row1.panel_pair1.panel1.addr_array,
		    `SCPATH3.dc_row1.panel_pair1.panel1.valid,
		    `SCPATH3.dc_row1.panel_pair1.panel1.parity,
		 
		    `SCPATH3.dc_row2.panel_pair0.panel0.addr_array,
		    `SCPATH3.dc_row2.panel_pair0.panel0.valid,
		    `SCPATH3.dc_row2.panel_pair0.panel0.parity,	 
		    `SCPATH3.dc_row2.panel_pair0.panel1.addr_array,
		    `SCPATH3.dc_row2.panel_pair0.panel1.valid,
		    `SCPATH3.dc_row2.panel_pair0.panel1.parity,
		    
		    `SCPATH3.dc_row2.panel_pair1.panel0.addr_array,
		    `SCPATH3.dc_row2.panel_pair1.panel0.valid,
		    `SCPATH3.dc_row2.panel_pair1.panel0.parity,	 
		    `SCPATH3.dc_row2.panel_pair1.panel1.addr_array,
		    `SCPATH3.dc_row2.panel_pair1.panel1.valid,
		    `SCPATH3.dc_row2.panel_pair1.panel1.parity,
		 
		    `SCPATH3.dc_row3.panel_pair0.panel0.addr_array,
		    `SCPATH3.dc_row3.panel_pair0.panel0.valid,
		    `SCPATH3.dc_row3.panel_pair0.panel0.parity,	 
		    `SCPATH3.dc_row3.panel_pair0.panel1.addr_array,
		    `SCPATH3.dc_row3.panel_pair0.panel1.valid,
		    `SCPATH3.dc_row3.panel_pair0.panel1.parity,
		    
		    `SCPATH3.dc_row3.panel_pair1.panel0.addr_array,
		    `SCPATH3.dc_row3.panel_pair1.panel0.valid,
		    `SCPATH3.dc_row3.panel_pair1.panel0.parity,	 
		    `SCPATH3.dc_row3.panel_pair1.panel1.addr_array,
		    `SCPATH3.dc_row3.panel_pair1.panel1.valid,
		    `SCPATH3.dc_row3.panel_pair1.panel1.parity,
		    
		    //bank 00
		    //icache site. location 193
		    `SCPATH0.ic_row0.panel_pair0.panel0.addr_array,
		    `SCPATH0.ic_row0.panel_pair0.panel0.valid,
		    `SCPATH0.ic_row0.panel_pair0.panel0.parity,
		    `SCPATH0.ic_row0.panel_pair0.panel1.addr_array,
		    `SCPATH0.ic_row0.panel_pair0.panel1.valid,
		    `SCPATH0.ic_row0.panel_pair0.panel1.parity,
		    
		    `SCPATH0.ic_row0.panel_pair1.panel0.addr_array,
		    `SCPATH0.ic_row0.panel_pair1.panel0.valid,
		    `SCPATH0.ic_row0.panel_pair1.panel0.parity,	 
		    `SCPATH0.ic_row0.panel_pair1.panel1.addr_array,
		    `SCPATH0.ic_row0.panel_pair1.panel1.valid,
		    `SCPATH0.ic_row0.panel_pair1.panel1.parity,
		 
		    `SCPATH0.ic_row1.panel_pair0.panel0.addr_array,
		    `SCPATH0.ic_row1.panel_pair0.panel0.valid,
		    `SCPATH0.ic_row1.panel_pair0.panel0.parity,	 
		    `SCPATH0.ic_row1.panel_pair0.panel1.addr_array,
		    `SCPATH0.ic_row1.panel_pair0.panel1.valid,
		    `SCPATH0.ic_row1.panel_pair0.panel1.parity,
		 
		    `SCPATH0.ic_row1.panel_pair1.panel0.addr_array,
		    `SCPATH0.ic_row1.panel_pair1.panel0.valid,
		    `SCPATH0.ic_row1.panel_pair1.panel0.parity,	 
		    `SCPATH0.ic_row1.panel_pair1.panel1.addr_array,
		    `SCPATH0.ic_row1.panel_pair1.panel1.valid,
		    `SCPATH0.ic_row1.panel_pair1.panel1.parity,
		    
		    `SCPATH0.ic_row2.panel_pair0.panel0.addr_array,
		    `SCPATH0.ic_row2.panel_pair0.panel0.valid,
		    `SCPATH0.ic_row2.panel_pair0.panel0.parity,	 
		    `SCPATH0.ic_row2.panel_pair0.panel1.addr_array,
		    `SCPATH0.ic_row2.panel_pair0.panel1.valid,
		    `SCPATH0.ic_row2.panel_pair0.panel1.parity,
		 
		    `SCPATH0.ic_row2.panel_pair1.panel0.addr_array,
		    `SCPATH0.ic_row2.panel_pair1.panel0.valid,
		    `SCPATH0.ic_row2.panel_pair1.panel0.parity,	 
		    `SCPATH0.ic_row2.panel_pair1.panel1.addr_array,
		    `SCPATH0.ic_row2.panel_pair1.panel1.valid,
		    `SCPATH0.ic_row2.panel_pair1.panel1.parity,
		 
		    `SCPATH0.ic_row3.panel_pair0.panel0.addr_array,
		    `SCPATH0.ic_row3.panel_pair0.panel0.valid,
		    `SCPATH0.ic_row3.panel_pair0.panel0.parity,	 
		    `SCPATH0.ic_row3.panel_pair0.panel1.addr_array,
		    `SCPATH0.ic_row3.panel_pair0.panel1.valid,
		    `SCPATH0.ic_row3.panel_pair0.panel1.parity,
		    
		    `SCPATH0.ic_row3.panel_pair1.panel0.addr_array,
		    `SCPATH0.ic_row3.panel_pair1.panel0.valid,
		    `SCPATH0.ic_row3.panel_pair1.panel0.parity,	 
		    `SCPATH0.ic_row3.panel_pair1.panel1.addr_array,
		    `SCPATH0.ic_row3.panel_pair1.panel1.valid,
		    `SCPATH0.ic_row3.panel_pair1.panel1.parity,
		    
		    //bank 01
		    //icache site.
		    `SCPATH1.ic_row0.panel_pair0.panel0.addr_array,
		    `SCPATH1.ic_row0.panel_pair0.panel0.valid,
		    `SCPATH1.ic_row0.panel_pair0.panel0.parity,	 
		    `SCPATH1.ic_row0.panel_pair0.panel1.addr_array,
		    `SCPATH1.ic_row0.panel_pair0.panel1.valid,
		    `SCPATH1.ic_row0.panel_pair0.panel1.parity,
		    
		    `SCPATH1.ic_row0.panel_pair1.panel0.addr_array,
		    `SCPATH1.ic_row0.panel_pair1.panel0.valid,
		    `SCPATH1.ic_row0.panel_pair1.panel0.parity,	 
		    `SCPATH1.ic_row0.panel_pair1.panel1.addr_array,
		    `SCPATH1.ic_row0.panel_pair1.panel1.valid,
		    `SCPATH1.ic_row0.panel_pair1.panel1.parity,
		    
		    `SCPATH1.ic_row1.panel_pair0.panel0.addr_array,
		    `SCPATH1.ic_row1.panel_pair0.panel0.valid,
		    `SCPATH1.ic_row1.panel_pair0.panel0.parity,	 
		    `SCPATH1.ic_row1.panel_pair0.panel1.addr_array,
		    `SCPATH1.ic_row1.panel_pair0.panel1.valid,
		    `SCPATH1.ic_row1.panel_pair0.panel1.parity,
		    
		    `SCPATH1.ic_row1.panel_pair1.panel0.addr_array,
		    `SCPATH1.ic_row1.panel_pair1.panel0.valid,
		    `SCPATH1.ic_row1.panel_pair1.panel0.parity,	 
		    `SCPATH1.ic_row1.panel_pair1.panel1.addr_array,
		    `SCPATH1.ic_row1.panel_pair1.panel1.valid,
		    `SCPATH1.ic_row1.panel_pair1.panel1.parity,
		    
		    `SCPATH1.ic_row2.panel_pair0.panel0.addr_array,
		    `SCPATH1.ic_row2.panel_pair0.panel0.valid,
		    `SCPATH1.ic_row2.panel_pair0.panel0.parity,	 
		    `SCPATH1.ic_row2.panel_pair0.panel1.addr_array,
		    `SCPATH1.ic_row2.panel_pair0.panel1.valid,
		    `SCPATH1.ic_row2.panel_pair0.panel1.parity,
		 
		    `SCPATH1.ic_row2.panel_pair1.panel0.addr_array,
		    `SCPATH1.ic_row2.panel_pair1.panel0.valid,
		    `SCPATH1.ic_row2.panel_pair1.panel0.parity,	 
		    `SCPATH1.ic_row2.panel_pair1.panel1.addr_array,
		    `SCPATH1.ic_row2.panel_pair1.panel1.valid,
		    `SCPATH1.ic_row2.panel_pair1.panel1.parity,
		    
		    `SCPATH1.ic_row3.panel_pair0.panel0.addr_array,
		    `SCPATH1.ic_row3.panel_pair0.panel0.valid,
		    `SCPATH1.ic_row3.panel_pair0.panel0.parity,	 
		    `SCPATH1.ic_row3.panel_pair0.panel1.addr_array,
		    `SCPATH1.ic_row3.panel_pair0.panel1.valid,
		    `SCPATH1.ic_row3.panel_pair0.panel1.parity,
		 
		    `SCPATH1.ic_row3.panel_pair1.panel0.addr_array,
		    `SCPATH1.ic_row3.panel_pair1.panel0.valid,
		    `SCPATH1.ic_row3.panel_pair1.panel0.parity,	 
		    `SCPATH1.ic_row3.panel_pair1.panel1.addr_array,
		    `SCPATH1.ic_row3.panel_pair1.panel1.valid,
		    `SCPATH1.ic_row3.panel_pair1.panel1.parity,
		 
		    //bank 10
		    //icache site.
		    `SCPATH2.ic_row0.panel_pair0.panel0.addr_array,
		    `SCPATH2.ic_row0.panel_pair0.panel0.valid,
		    `SCPATH2.ic_row0.panel_pair0.panel0.parity,	 
		    `SCPATH2.ic_row0.panel_pair0.panel1.addr_array,
		    `SCPATH2.ic_row0.panel_pair0.panel1.valid,
		    `SCPATH2.ic_row0.panel_pair0.panel1.parity,
		    
		    `SCPATH2.ic_row0.panel_pair1.panel0.addr_array,
		    `SCPATH2.ic_row0.panel_pair1.panel0.valid,
		    `SCPATH2.ic_row0.panel_pair1.panel0.parity,	 
		    `SCPATH2.ic_row0.panel_pair1.panel1.addr_array,
		    `SCPATH2.ic_row0.panel_pair1.panel1.valid,
		    `SCPATH2.ic_row0.panel_pair1.panel1.parity,
		 
		    `SCPATH2.ic_row1.panel_pair0.panel0.addr_array,
		    `SCPATH2.ic_row1.panel_pair0.panel0.valid,
		    `SCPATH2.ic_row1.panel_pair0.panel0.parity,	 
		    `SCPATH2.ic_row1.panel_pair0.panel1.addr_array,
		    `SCPATH2.ic_row1.panel_pair0.panel1.valid,
		    `SCPATH2.ic_row1.panel_pair0.panel1.parity,
		 
		    `SCPATH2.ic_row1.panel_pair1.panel0.addr_array,
		    `SCPATH2.ic_row1.panel_pair1.panel0.valid,
		    `SCPATH2.ic_row1.panel_pair1.panel0.parity,	 
		    `SCPATH2.ic_row1.panel_pair1.panel1.addr_array,
		    `SCPATH2.ic_row1.panel_pair1.panel1.valid,
		    `SCPATH2.ic_row1.panel_pair1.panel1.parity,
		 
		    `SCPATH2.ic_row2.panel_pair0.panel0.addr_array,
		    `SCPATH2.ic_row2.panel_pair0.panel0.valid,
		    `SCPATH2.ic_row2.panel_pair0.panel0.parity,	 
		    `SCPATH2.ic_row2.panel_pair0.panel1.addr_array,
		    `SCPATH2.ic_row2.panel_pair0.panel1.valid,
		    `SCPATH2.ic_row2.panel_pair0.panel1.parity,
		    
		    `SCPATH2.ic_row2.panel_pair1.panel0.addr_array,
		    `SCPATH2.ic_row2.panel_pair1.panel0.valid,
		    `SCPATH2.ic_row2.panel_pair1.panel0.parity,	 
		    `SCPATH2.ic_row2.panel_pair1.panel1.addr_array,
		    `SCPATH2.ic_row2.panel_pair1.panel1.valid,
		    `SCPATH2.ic_row2.panel_pair1.panel1.parity,
		 
		    `SCPATH2.ic_row3.panel_pair0.panel0.addr_array,
		    `SCPATH2.ic_row3.panel_pair0.panel0.valid,
		    `SCPATH2.ic_row3.panel_pair0.panel0.parity,	 
		    `SCPATH2.ic_row3.panel_pair0.panel1.addr_array,
		    `SCPATH2.ic_row3.panel_pair0.panel1.valid,
		    `SCPATH2.ic_row3.panel_pair0.panel1.parity,
		 
		    `SCPATH2.ic_row3.panel_pair1.panel0.addr_array,
		    `SCPATH2.ic_row3.panel_pair1.panel0.valid,
		    `SCPATH2.ic_row3.panel_pair1.panel0.parity,	 
		    `SCPATH2.ic_row3.panel_pair1.panel1.addr_array,
		    `SCPATH2.ic_row3.panel_pair1.panel1.valid,
		    `SCPATH2.ic_row3.panel_pair1.panel1.parity,
		 
		    //bank11
		    //icache site.
		    `SCPATH3.ic_row0.panel_pair0.panel0.addr_array,
		    `SCPATH3.ic_row0.panel_pair0.panel0.valid,
		    `SCPATH3.ic_row0.panel_pair0.panel0.parity,	 
		    `SCPATH3.ic_row0.panel_pair0.panel1.addr_array,
		    `SCPATH3.ic_row0.panel_pair0.panel1.valid,
		    `SCPATH3.ic_row0.panel_pair0.panel1.parity,
		 
		    `SCPATH3.ic_row0.panel_pair1.panel0.addr_array,
		    `SCPATH3.ic_row0.panel_pair1.panel0.valid,
		    `SCPATH3.ic_row0.panel_pair1.panel0.parity,	 
		    `SCPATH3.ic_row0.panel_pair1.panel1.addr_array,
		    `SCPATH3.ic_row0.panel_pair1.panel1.valid,
		    `SCPATH3.ic_row0.panel_pair1.panel1.parity,
		 
		    `SCPATH3.ic_row1.panel_pair0.panel0.addr_array,
		    `SCPATH3.ic_row1.panel_pair0.panel0.valid,
		    `SCPATH3.ic_row1.panel_pair0.panel0.parity,	 
		    `SCPATH3.ic_row1.panel_pair0.panel1.addr_array,
		    `SCPATH3.ic_row1.panel_pair0.panel1.valid,
		    `SCPATH3.ic_row1.panel_pair0.panel1.parity,
		 
		    `SCPATH3.ic_row1.panel_pair1.panel0.addr_array,
		    `SCPATH3.ic_row1.panel_pair1.panel0.valid,
		    `SCPATH3.ic_row1.panel_pair1.panel0.parity,	 
		    `SCPATH3.ic_row1.panel_pair1.panel1.addr_array,
		    `SCPATH3.ic_row1.panel_pair1.panel1.valid,
		    `SCPATH3.ic_row1.panel_pair1.panel1.parity,
		    
		    `SCPATH3.ic_row2.panel_pair0.panel0.addr_array,
		    `SCPATH3.ic_row2.panel_pair0.panel0.valid,
		    `SCPATH3.ic_row2.panel_pair0.panel0.parity,	 
		    `SCPATH3.ic_row2.panel_pair0.panel1.addr_array,
		    `SCPATH3.ic_row2.panel_pair0.panel1.valid,
		    `SCPATH3.ic_row2.panel_pair0.panel1.parity,
		    
		    `SCPATH3.ic_row2.panel_pair1.panel0.addr_array,
		    `SCPATH3.ic_row2.panel_pair1.panel0.valid,
		    `SCPATH3.ic_row2.panel_pair1.panel0.parity,	 
		    `SCPATH3.ic_row2.panel_pair1.panel1.addr_array,
		    `SCPATH3.ic_row2.panel_pair1.panel1.valid,
		    `SCPATH3.ic_row2.panel_pair1.panel1.parity,
		 
		    `SCPATH3.ic_row3.panel_pair0.panel0.addr_array,
		    `SCPATH3.ic_row3.panel_pair0.panel0.valid,
		    `SCPATH3.ic_row3.panel_pair0.panel0.parity,	 
		    `SCPATH3.ic_row3.panel_pair0.panel1.addr_array,
		    `SCPATH3.ic_row3.panel_pair0.panel1.valid,
		    `SCPATH3.ic_row3.panel_pair0.panel1.parity,
		    
		    `SCPATH3.ic_row3.panel_pair1.panel0.addr_array,
		    `SCPATH3.ic_row3.panel_pair1.panel0.valid,
		    `SCPATH3.ic_row3.panel_pair1.panel0.parity,	 
		    `SCPATH3.ic_row3.panel_pair1.panel1.addr_array,
		    `SCPATH3.ic_row3.panel_pair1.panel1.valid,
		    `SCPATH3.ic_row3.panel_pair1.panel1.parity,
		    //tag and data
		   //bank 0
		    `SCPATH0.tag.subbank01.way0,
		    `SCPATH0.tag.subbank01.way1,
		    `SCPATH0.tag.subbank23.way0,
		    `SCPATH0.tag.subbank23.way1,
		    `SCPATH0.tag.subbank45.way0,
		    `SCPATH0.tag.subbank45.way1,
		    `SCPATH0.tag.subbank67.way0,
		    `SCPATH0.tag.subbank67.way1,
		    `SCPATH0.tag.subbank89.way0,
		    `SCPATH0.tag.subbank89.way1,
		    `SCPATH0.tag.subbankab.way0,
		    `SCPATH0.tag.subbankab.way1,
		 //vuad
		    `SCPATH0.subarray_0.inq_ary,
		    `SCPATH0.subarray_1.inq_ary,
		    `SCPATH0.subarray_2.inq_ary,
		    `SCPATH0.subarray_3.inq_ary,
		    `SCPATH0.subarray_4.inq_ary,
		    `SCPATH0.subarray_5.inq_ary,
		    `SCPATH0.subarray_6.inq_ary,
		    `SCPATH0.subarray_7.inq_ary,
		    
		    `SCPATH0.subarray_8.inq_ary,
		    `SCPATH0.subarray_9.inq_ary,
		    `SCPATH0.subarray_10.inq_ary,
		    `SCPATH0.subarray_11.inq_ary,
		    `SCPATH0.subarray_12.inq_ary,
		    `SCPATH0.subarray_13.inq_ary,
		    `SCPATH0.subarray_14.inq_ary,
		    `SCPATH0.subarray_15.inq_ary,
		 
		    //data
		    `SCDPATH0.subbank_0.data_array_0.mem_0.way0_decc,
		    `SCDPATH0.subbank_0.data_array_0.mem_0.way1_decc,
		    `SCDPATH0.subbank_0.data_array_0.mem_1.way0_decc,
		    `SCDPATH0.subbank_0.data_array_0.mem_1.way1_decc,
		    `SCDPATH0.subbank_0.data_array_1.mem_0.way0_decc,
		    `SCDPATH0.subbank_0.data_array_1.mem_0.way1_decc,
		    `SCDPATH0.subbank_0.data_array_1.mem_1.way0_decc,
		    `SCDPATH0.subbank_0.data_array_1.mem_1.way1_decc,
		    `SCDPATH0.subbank_0.data_array_2.mem_0.way0_decc,
		    `SCDPATH0.subbank_0.data_array_2.mem_0.way1_decc,
		    `SCDPATH0.subbank_0.data_array_2.mem_1.way0_decc,
		    `SCDPATH0.subbank_0.data_array_2.mem_1.way1_decc,
		    
		    `SCDPATH0.subbank_1.data_array_0.mem_0.way0_decc,
		    `SCDPATH0.subbank_1.data_array_0.mem_0.way1_decc,
		    `SCDPATH0.subbank_1.data_array_0.mem_1.way0_decc,
		    `SCDPATH0.subbank_1.data_array_0.mem_1.way1_decc,
		    `SCDPATH0.subbank_1.data_array_1.mem_0.way0_decc,
		    `SCDPATH0.subbank_1.data_array_1.mem_0.way1_decc,
		    `SCDPATH0.subbank_1.data_array_1.mem_1.way0_decc,
		    `SCDPATH0.subbank_1.data_array_1.mem_1.way1_decc,
		    `SCDPATH0.subbank_1.data_array_2.mem_0.way0_decc,
		    `SCDPATH0.subbank_1.data_array_2.mem_0.way1_decc,
		    `SCDPATH0.subbank_1.data_array_2.mem_1.way0_decc,
		    `SCDPATH0.subbank_1.data_array_2.mem_1.way1_decc,

		    `SCDPATH0.subbank_2.data_array_0.mem_0.way0_decc,
		    `SCDPATH0.subbank_2.data_array_0.mem_0.way1_decc,
		    `SCDPATH0.subbank_2.data_array_0.mem_1.way0_decc,
		    `SCDPATH0.subbank_2.data_array_0.mem_1.way1_decc,
		    `SCDPATH0.subbank_2.data_array_1.mem_0.way0_decc,
		    `SCDPATH0.subbank_2.data_array_1.mem_0.way1_decc,
		    `SCDPATH0.subbank_2.data_array_1.mem_1.way0_decc,
		    `SCDPATH0.subbank_2.data_array_1.mem_1.way1_decc,
		    `SCDPATH0.subbank_2.data_array_2.mem_0.way0_decc,
		    `SCDPATH0.subbank_2.data_array_2.mem_0.way1_decc,
		    `SCDPATH0.subbank_2.data_array_2.mem_1.way0_decc,
		    `SCDPATH0.subbank_2.data_array_2.mem_1.way1_decc,
		    
		    `SCDPATH0.subbank_3.data_array_0.mem_0.way0_decc,
		    `SCDPATH0.subbank_3.data_array_0.mem_0.way1_decc,
		    `SCDPATH0.subbank_3.data_array_0.mem_1.way0_decc,
		    `SCDPATH0.subbank_3.data_array_0.mem_1.way1_decc,
		    `SCDPATH0.subbank_3.data_array_1.mem_0.way0_decc,
		    `SCDPATH0.subbank_3.data_array_1.mem_0.way1_decc,
		    `SCDPATH0.subbank_3.data_array_1.mem_1.way0_decc,
		    `SCDPATH0.subbank_3.data_array_1.mem_1.way1_decc,
		    `SCDPATH0.subbank_3.data_array_2.mem_0.way0_decc,
		    `SCDPATH0.subbank_3.data_array_2.mem_0.way1_decc,
		    `SCDPATH0.subbank_3.data_array_2.mem_1.way0_decc,
		    `SCDPATH0.subbank_3.data_array_2.mem_1.way1_decc,
		
		    //bank 01
		    `SCPATH1.tag.subbank01.way0,
		    `SCPATH1.tag.subbank01.way1,
		    `SCPATH1.tag.subbank23.way0,
		    `SCPATH1.tag.subbank23.way1,
		    `SCPATH1.tag.subbank45.way0,
		    `SCPATH1.tag.subbank45.way1,
		    `SCPATH1.tag.subbank67.way0,
		    `SCPATH1.tag.subbank67.way1,
		    `SCPATH1.tag.subbank89.way0,
		    `SCPATH1.tag.subbank89.way1,
		    `SCPATH1.tag.subbankab.way0,
		    `SCPATH1.tag.subbankab.way1,
		    //vuad
		    `SCPATH1.subarray_0.inq_ary,
		    `SCPATH1.subarray_1.inq_ary,
		    `SCPATH1.subarray_2.inq_ary,
		    `SCPATH1.subarray_3.inq_ary,
		    `SCPATH1.subarray_4.inq_ary,
		    `SCPATH1.subarray_5.inq_ary,
		    `SCPATH1.subarray_6.inq_ary,
		    `SCPATH1.subarray_7.inq_ary,
		    `SCPATH1.subarray_8.inq_ary,
		    `SCPATH1.subarray_9.inq_ary,
		    `SCPATH1.subarray_10.inq_ary,
		    `SCPATH1.subarray_11.inq_ary,
		    `SCPATH1.subarray_12.inq_ary,
		    `SCPATH1.subarray_13.inq_ary,
		    `SCPATH1.subarray_14.inq_ary,
		    `SCPATH1.subarray_15.inq_ary,
		    //data
		    `SCDPATH1.subbank_0.data_array_0.mem_0.way0_decc,
		    `SCDPATH1.subbank_0.data_array_0.mem_0.way1_decc,
		    `SCDPATH1.subbank_0.data_array_0.mem_1.way0_decc,
		    `SCDPATH1.subbank_0.data_array_0.mem_1.way1_decc,
		    `SCDPATH1.subbank_0.data_array_1.mem_0.way0_decc,
		    `SCDPATH1.subbank_0.data_array_1.mem_0.way1_decc,
		    `SCDPATH1.subbank_0.data_array_1.mem_1.way0_decc,
		    `SCDPATH1.subbank_0.data_array_1.mem_1.way1_decc,
		    `SCDPATH1.subbank_0.data_array_2.mem_0.way0_decc,
		    `SCDPATH1.subbank_0.data_array_2.mem_0.way1_decc,
		    `SCDPATH1.subbank_0.data_array_2.mem_1.way0_decc,
		    `SCDPATH1.subbank_0.data_array_2.mem_1.way1_decc,

		    `SCDPATH1.subbank_1.data_array_0.mem_0.way0_decc,
		    `SCDPATH1.subbank_1.data_array_0.mem_0.way1_decc,
		    `SCDPATH1.subbank_1.data_array_0.mem_1.way0_decc,
		    `SCDPATH1.subbank_1.data_array_0.mem_1.way1_decc,
		    `SCDPATH1.subbank_1.data_array_1.mem_0.way0_decc,
		    `SCDPATH1.subbank_1.data_array_1.mem_0.way1_decc,
		    `SCDPATH1.subbank_1.data_array_1.mem_1.way0_decc,
		    `SCDPATH1.subbank_1.data_array_1.mem_1.way1_decc,
		    `SCDPATH1.subbank_1.data_array_2.mem_0.way0_decc,
		    `SCDPATH1.subbank_1.data_array_2.mem_0.way1_decc,
		    `SCDPATH1.subbank_1.data_array_2.mem_1.way0_decc,
		    `SCDPATH1.subbank_1.data_array_2.mem_1.way1_decc,

		    `SCDPATH1.subbank_2.data_array_0.mem_0.way0_decc,
		    `SCDPATH1.subbank_2.data_array_0.mem_0.way1_decc,
		    `SCDPATH1.subbank_2.data_array_0.mem_1.way0_decc,
		    `SCDPATH1.subbank_2.data_array_0.mem_1.way1_decc,
		    `SCDPATH1.subbank_2.data_array_1.mem_0.way0_decc,
		    `SCDPATH1.subbank_2.data_array_1.mem_0.way1_decc,
		    `SCDPATH1.subbank_2.data_array_1.mem_1.way0_decc,
		    `SCDPATH1.subbank_2.data_array_1.mem_1.way1_decc,
		    `SCDPATH1.subbank_2.data_array_2.mem_0.way0_decc,
		    `SCDPATH1.subbank_2.data_array_2.mem_0.way1_decc,
		    `SCDPATH1.subbank_2.data_array_2.mem_1.way0_decc,
		    `SCDPATH1.subbank_2.data_array_2.mem_1.way1_decc,

		    `SCDPATH1.subbank_3.data_array_0.mem_0.way0_decc,
		    `SCDPATH1.subbank_3.data_array_0.mem_0.way1_decc,
		    `SCDPATH1.subbank_3.data_array_0.mem_1.way0_decc,
		    `SCDPATH1.subbank_3.data_array_0.mem_1.way1_decc,
		    `SCDPATH1.subbank_3.data_array_1.mem_0.way0_decc,
		    `SCDPATH1.subbank_3.data_array_1.mem_0.way1_decc,
		    `SCDPATH1.subbank_3.data_array_1.mem_1.way0_decc,
		    `SCDPATH1.subbank_3.data_array_1.mem_1.way1_decc,
		    `SCDPATH1.subbank_3.data_array_2.mem_0.way0_decc,
		    `SCDPATH1.subbank_3.data_array_2.mem_0.way1_decc,
		    `SCDPATH1.subbank_3.data_array_2.mem_1.way0_decc,
		    `SCDPATH1.subbank_3.data_array_2.mem_1.way1_decc,
		
		    //bank 10
		    `SCPATH2.tag.subbank01.way0,
		    `SCPATH2.tag.subbank01.way1,
		    `SCPATH2.tag.subbank23.way0,
		    `SCPATH2.tag.subbank23.way1,
		    `SCPATH2.tag.subbank45.way0,
		    `SCPATH2.tag.subbank45.way1,
		    `SCPATH2.tag.subbank67.way0,
		    `SCPATH2.tag.subbank67.way1,
		    `SCPATH2.tag.subbank89.way0,
		    `SCPATH2.tag.subbank89.way1,
		    `SCPATH2.tag.subbankab.way0,
		    `SCPATH2.tag.subbankab.way1,
		    //vuad
		    `SCPATH2.subarray_0.inq_ary,
		    `SCPATH2.subarray_1.inq_ary,
		    `SCPATH2.subarray_2.inq_ary,
		    `SCPATH2.subarray_3.inq_ary,
		    `SCPATH2.subarray_4.inq_ary,
		    `SCPATH2.subarray_5.inq_ary,
		    `SCPATH2.subarray_6.inq_ary,
		    `SCPATH2.subarray_7.inq_ary,
		    `SCPATH2.subarray_8.inq_ary,
		    `SCPATH2.subarray_9.inq_ary,
		    `SCPATH2.subarray_10.inq_ary,
		    `SCPATH2.subarray_11.inq_ary,
		    `SCPATH2.subarray_12.inq_ary,
		    `SCPATH2.subarray_13.inq_ary,
		    `SCPATH2.subarray_14.inq_ary,
		    `SCPATH2.subarray_15.inq_ary,
		    //data
		    `SCDPATH2.subbank_0.data_array_0.mem_0.way0_decc,
		    `SCDPATH2.subbank_0.data_array_0.mem_0.way1_decc,
		    `SCDPATH2.subbank_0.data_array_0.mem_1.way0_decc,
		    `SCDPATH2.subbank_0.data_array_0.mem_1.way1_decc,
		    `SCDPATH2.subbank_0.data_array_1.mem_0.way0_decc,
		    `SCDPATH2.subbank_0.data_array_1.mem_0.way1_decc,
		    `SCDPATH2.subbank_0.data_array_1.mem_1.way0_decc,
		    `SCDPATH2.subbank_0.data_array_1.mem_1.way1_decc,
		    `SCDPATH2.subbank_0.data_array_2.mem_0.way0_decc,
		    `SCDPATH2.subbank_0.data_array_2.mem_0.way1_decc,
		    `SCDPATH2.subbank_0.data_array_2.mem_1.way0_decc,
		    `SCDPATH2.subbank_0.data_array_2.mem_1.way1_decc,

		    `SCDPATH2.subbank_1.data_array_0.mem_0.way0_decc,
		    `SCDPATH2.subbank_1.data_array_0.mem_0.way1_decc,
		    `SCDPATH2.subbank_1.data_array_0.mem_1.way0_decc,
		    `SCDPATH2.subbank_1.data_array_0.mem_1.way1_decc,
		    `SCDPATH2.subbank_1.data_array_1.mem_0.way0_decc,
		    `SCDPATH2.subbank_1.data_array_1.mem_0.way1_decc,
		    `SCDPATH2.subbank_1.data_array_1.mem_1.way0_decc,
		    `SCDPATH2.subbank_1.data_array_1.mem_1.way1_decc,
		    `SCDPATH2.subbank_1.data_array_2.mem_0.way0_decc,
		    `SCDPATH2.subbank_1.data_array_2.mem_0.way1_decc,
		    `SCDPATH2.subbank_1.data_array_2.mem_1.way0_decc,
		    `SCDPATH2.subbank_1.data_array_2.mem_1.way1_decc,
		    
		    `SCDPATH2.subbank_2.data_array_0.mem_0.way0_decc,
		    `SCDPATH2.subbank_2.data_array_0.mem_0.way1_decc,
		    `SCDPATH2.subbank_2.data_array_0.mem_1.way0_decc,
		    `SCDPATH2.subbank_2.data_array_0.mem_1.way1_decc,
		    `SCDPATH2.subbank_2.data_array_1.mem_0.way0_decc,
		    `SCDPATH2.subbank_2.data_array_1.mem_0.way1_decc,
		    `SCDPATH2.subbank_2.data_array_1.mem_1.way0_decc,
		    `SCDPATH2.subbank_2.data_array_1.mem_1.way1_decc,
		    `SCDPATH2.subbank_2.data_array_2.mem_0.way0_decc,
		    `SCDPATH2.subbank_2.data_array_2.mem_0.way1_decc,
		    `SCDPATH2.subbank_2.data_array_2.mem_1.way0_decc,
		    `SCDPATH2.subbank_2.data_array_2.mem_1.way1_decc,

		    `SCDPATH2.subbank_3.data_array_0.mem_0.way0_decc,
		    `SCDPATH2.subbank_3.data_array_0.mem_0.way1_decc,
		    `SCDPATH2.subbank_3.data_array_0.mem_1.way0_decc,
		    `SCDPATH2.subbank_3.data_array_0.mem_1.way1_decc,
		    `SCDPATH2.subbank_3.data_array_1.mem_0.way0_decc,
		    `SCDPATH2.subbank_3.data_array_1.mem_0.way1_decc,
		    `SCDPATH2.subbank_3.data_array_1.mem_1.way0_decc,
		    `SCDPATH2.subbank_3.data_array_1.mem_1.way1_decc,
		    `SCDPATH2.subbank_3.data_array_2.mem_0.way0_decc,
		    `SCDPATH2.subbank_3.data_array_2.mem_0.way1_decc,
		    `SCDPATH2.subbank_3.data_array_2.mem_1.way0_decc,
		    `SCDPATH2.subbank_3.data_array_2.mem_1.way1_decc,
		    
		    
		    //bank 11
		    `SCPATH3.tag.subbank01.way0,
		    `SCPATH3.tag.subbank01.way1,
		    `SCPATH3.tag.subbank23.way0,
		    `SCPATH3.tag.subbank23.way1,
		    `SCPATH3.tag.subbank45.way0,
		    `SCPATH3.tag.subbank45.way1,
		    `SCPATH3.tag.subbank67.way0,
		    `SCPATH3.tag.subbank67.way1,
		    `SCPATH3.tag.subbank89.way0,
		    `SCPATH3.tag.subbank89.way1,
		    `SCPATH3.tag.subbankab.way0,
		    `SCPATH3.tag.subbankab.way1,
		    //vuad
		    `SCPATH3.subarray_0.inq_ary,
		    `SCPATH3.subarray_1.inq_ary,
		    `SCPATH3.subarray_2.inq_ary,
		    `SCPATH3.subarray_3.inq_ary,
		    `SCPATH3.subarray_4.inq_ary,
		    `SCPATH3.subarray_5.inq_ary,
		    `SCPATH3.subarray_6.inq_ary,
		    `SCPATH3.subarray_7.inq_ary,
		    `SCPATH3.subarray_8.inq_ary,
		    `SCPATH3.subarray_9.inq_ary,
		    `SCPATH3.subarray_10.inq_ary,
		    `SCPATH3.subarray_11.inq_ary,
		    `SCPATH3.subarray_12.inq_ary,
		    `SCPATH3.subarray_13.inq_ary,
		    `SCPATH3.subarray_14.inq_ary,
		    `SCPATH3.subarray_15.inq_ary,
		    //data
		    `SCDPATH3.subbank_0.data_array_0.mem_0.way0_decc,
		    `SCDPATH3.subbank_0.data_array_0.mem_0.way1_decc,
		    `SCDPATH3.subbank_0.data_array_0.mem_1.way0_decc,
		    `SCDPATH3.subbank_0.data_array_0.mem_1.way1_decc,
		    `SCDPATH3.subbank_0.data_array_1.mem_0.way0_decc,
		    `SCDPATH3.subbank_0.data_array_1.mem_0.way1_decc,
		    `SCDPATH3.subbank_0.data_array_1.mem_1.way0_decc,
		    `SCDPATH3.subbank_0.data_array_1.mem_1.way1_decc,
		    `SCDPATH3.subbank_0.data_array_2.mem_0.way0_decc,
		    `SCDPATH3.subbank_0.data_array_2.mem_0.way1_decc,
		    `SCDPATH3.subbank_0.data_array_2.mem_1.way0_decc,
		    `SCDPATH3.subbank_0.data_array_2.mem_1.way1_decc,
		    
		    `SCDPATH3.subbank_1.data_array_0.mem_0.way0_decc,
		    `SCDPATH3.subbank_1.data_array_0.mem_0.way1_decc,
		    `SCDPATH3.subbank_1.data_array_0.mem_1.way0_decc,
		    `SCDPATH3.subbank_1.data_array_0.mem_1.way1_decc,
		    `SCDPATH3.subbank_1.data_array_1.mem_0.way0_decc,
		    `SCDPATH3.subbank_1.data_array_1.mem_0.way1_decc,
		    `SCDPATH3.subbank_1.data_array_1.mem_1.way0_decc,
		    `SCDPATH3.subbank_1.data_array_1.mem_1.way1_decc,
		    `SCDPATH3.subbank_1.data_array_2.mem_0.way0_decc,
		    `SCDPATH3.subbank_1.data_array_2.mem_0.way1_decc,
		    `SCDPATH3.subbank_1.data_array_2.mem_1.way0_decc,
		    `SCDPATH3.subbank_1.data_array_2.mem_1.way1_decc,

		    `SCDPATH3.subbank_2.data_array_0.mem_0.way0_decc,
		    `SCDPATH3.subbank_2.data_array_0.mem_0.way1_decc,
		    `SCDPATH3.subbank_2.data_array_0.mem_1.way0_decc,
		    `SCDPATH3.subbank_2.data_array_0.mem_1.way1_decc,
		    `SCDPATH3.subbank_2.data_array_1.mem_0.way0_decc,
		    `SCDPATH3.subbank_2.data_array_1.mem_0.way1_decc,
		    `SCDPATH3.subbank_2.data_array_1.mem_1.way0_decc,
		    `SCDPATH3.subbank_2.data_array_1.mem_1.way1_decc,
		    `SCDPATH3.subbank_2.data_array_2.mem_0.way0_decc,
		    `SCDPATH3.subbank_2.data_array_2.mem_0.way1_decc,
		    `SCDPATH3.subbank_2.data_array_2.mem_1.way0_decc,
		    `SCDPATH3.subbank_2.data_array_2.mem_1.way1_decc,
		    
		    `SCDPATH3.subbank_3.data_array_0.mem_0.way0_decc,
		    `SCDPATH3.subbank_3.data_array_0.mem_0.way1_decc,
		    `SCDPATH3.subbank_3.data_array_0.mem_1.way0_decc,
		    `SCDPATH3.subbank_3.data_array_0.mem_1.way1_decc,
		    `SCDPATH3.subbank_3.data_array_1.mem_0.way0_decc,
		    `SCDPATH3.subbank_3.data_array_1.mem_0.way1_decc,
		    `SCDPATH3.subbank_3.data_array_1.mem_1.way0_decc,
		    `SCDPATH3.subbank_3.data_array_1.mem_1.way1_decc,
		    `SCDPATH3.subbank_3.data_array_2.mem_0.way0_decc,
		    `SCDPATH3.subbank_3.data_array_2.mem_0.way1_decc,
		    `SCDPATH3.subbank_3.data_array_2.mem_1.way0_decc,
		    `SCDPATH3.subbank_3.data_array_2.mem_1.way1_decc 
		    );
	
     end
endmodule
