// Modified by Princeton University on June 9th, 2015
/*
* ========== Copyright Header Begin ==========================================
* 
* OpenSPARC T1 Processor File: tlu_asi_access_mt_1_rand_20_s2.s
* Copyright (c) 2006 Sun Microsystems, Inc.  All Rights Reserved.
* DO NOT ALTER OR REMOVE COPYRIGHT NOTICES.
* 
* The above named program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License version 2 as published by the Free Software Foundation.
* 
* The above named program is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
* 
* You should have received a copy of the GNU General Public
* License along with this work; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
* 
* ========== Copyright Header End ============================================
*/
/*
********************************************************************************
   random seed:	252950602
   Jal tlu_asi_access_mt_1.j:	
********************************************************************************/



#define PCONTEXT	0x10
#define SCONTEXT	0x10

#define MAIN_PAGE_NUCLEUS_ALSO
#define MAIN_PAGE_HV_ALSO

#define ALL_MY_INTR_HANDLERS
#include "my_intr_handlers.s"
#include "my_trap_handlers.s"
#include "tlu_custom_trap_handlers.s"

#include "enable_traps.h"
#include "boot.s"

.text
.global main

main:

	ta 	%icc, T_CHANGE_HPRIV
	mov	0x123, %g1
	wr	%g0, 0x20, %asi
	stxa	%g1, [0x00] %asi
	stxa	%g1, [0x08] %asi
	stxa	%g1, [0x10] %asi
	stxa	%g1, [0x18] %asi
	stxa	%g1, [0x20] %asi
	stxa	%g1, [0x28] %asi
	stxa	%g1, [0x30] %asi
	stxa	%g1, [0x38] %asi
	ta 	%icc, T_CHANGE_NONHPRIV

! Register init code

	setx 0x65c5854b0000e1f1, %g1, %g0
	setx 0x0418742f00002019, %g1, %g1
	setx 0xd0d84b170000206b, %g1, %g2
	setx 0x2026904c0000a376, %g1, %g3
	setx 0x78dbaa050000a182, %g1, %g4
	setx 0x9772ddc40000028a, %g1, %g5
	setx 0x36409f4a0000c25d, %g1, %g6
	setx 0xc427434100006181, %g1, %g7
	setx 0x120c4ce30000234f, %g1, %r16
	setx 0x9aa8b01900008090, %g1, %r17
	setx 0x45bbeaee00008277, %g1, %r18
	setx 0xabd9d97d000020b8, %g1, %r19
	setx 0xfef980fb0000e0c2, %g1, %r20
	setx 0x5b5ca5410000c244, %g1, %r21
	setx 0x747820a20000a17b, %g1, %r22
	setx 0xb3d5f0a1000061f6, %g1, %r23
	setx 0x50ecaa7a0000c221, %g1, %r24
	setx 0xae6c45bc00008186, %g1, %r25
	setx 0xabe473880000e251, %g1, %r26
	setx 0x6e94af2d0000032f, %g1, %r27
	setx 0x3ff936c30000e170, %g1, %r28
	setx 0x83797a58000000a2, %g1, %r29
	setx 0x481bae030000a2c3, %g1, %r30
	setx 0xc3620d5c0000c127, %g1, %r31
	save
	setx 0x90ddd9840000408e, %g1, %r16
	setx 0x6c4970800000e1d9, %g1, %r17
	setx 0x57ec99300000e318, %g1, %r18
	setx 0xbdcd1e5d0000c08c, %g1, %r19
	setx 0x3be5194b00000217, %g1, %r20
	setx 0x26dee70000000371, %g1, %r21
	setx 0x2c37273a0000a1b4, %g1, %r22
	setx 0xf6eab62200004383, %g1, %r23
	setx 0xd521ef7f0000e151, %g1, %r24
	setx 0x3c8554280000a138, %g1, %r25
	setx 0xc51913c60000823e, %g1, %r26
	setx 0x8ebb2ddf0000a20f, %g1, %r27
	setx 0x6838bec400008102, %g1, %r28
	setx 0xd3ccf5280000428c, %g1, %r29
	setx 0xb2a202e30000022d, %g1, %r30
	setx 0xfec56c9f0000c089, %g1, %r31
	restore
#ifdef PORTABLE_CORE
	mov	PORTABLE_CORE, %g1
	sllx	%g1, 10, %g1
	or	%r8, %g1, %r8
	or	%r9, %g1, %r9
	or	%r10, %g1, %r10
	or	%r11, %g1, %r11
	or	%r12, %g1, %r12
	or	%r13, %g1, %r13
	or	%r14, %g1, %r14
	or	%r15, %g1, %r15
#endif
	mov	0x38, %r16
	mov	0x18, %r17
	mov	0x8, %r18
	mov	0x58, %r19
	mov	0x3c8, %r20
	mov	0x7f0, %r21
	mov	0x7d8, %r22
	mov	0x3d0, %r23
	mov	0x50, %r24
	mov	0x38, %r25
	mov	0x58, %r26
	mov	0x48, %r27
	mov	0, %r28
	mov	0, %r29
	mov	0, %r30
	mov	0, %r31
	ta	%icc, T_CHANGE_HPRIV
	wr	%g0, 0x4f, %asi
	stxa	%g0, [%g0] 0x42
	mov	0x38, %g1
	stxa	%g0, [%g1] 0x58
	ta	%icc, T_RD_THID
! fork: source strm = 0xffffffff; target strm = 0x2
	cmp	%o1, 1
	setx	fork_lbl_0_1, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x4
	cmp	%o1, 2
	setx	fork_lbl_0_2, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x8
	cmp	%o1, 3
	setx	fork_lbl_0_3, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
	.word 0xd6bfce40  ! 1: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	.word 0xd6cea000  ! 2: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	.word 0xd0be09e0  ! 3: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0xd0b62000  ! 4: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0d62000  ! 6: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r8
	mov	0x3d0, %r22
	.word 0xd0be6000  ! 8: STDA_I	stda	%r8, [%r25 + 0x0000] %asi
	.word 0x87802074  ! 9: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6ac0400  ! 10: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0xda97ce80  ! 11: LDUHA_R	lduha	[%r31, %r0] 0x74, %r13
	.word 0xda9fa000  ! 12: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	mov	0x18, %r17
	.word 0x87802020  ! 14: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 15: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f584a0  ! 16: STXA_R	stxa	%r9, [%r22 + %r0] 0x25
	.word 0xd0de89e0  ! 17: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r8
	.word 0xd0dee000  ! 18: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r8
	.word 0xd0c6e000  ! 19: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r8
	.word 0xd88e09e0  ! 20: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r12
	.word 0xde8f8e60  ! 21: LDUBA_R	lduba	[%r30, %r0] 0x73, %r15
	.word 0xdeb6a000  ! 22: STHA_I	stha	%r15, [%r26 + 0x0000] %asi
	mov	0x38, %r19
	.word 0xde96e000  ! 24: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 25: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde862000  ! 26: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r15
	.word 0xdadc8400  ! 27: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	mov	0x18, %r17
	.word 0x8780204f  ! 29: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f48400  ! 30: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0xd2844400  ! 31: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	.word 0x8780204f  ! 32: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcd70e40  ! 33: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r14
	.word 0xdea4c400  ! 34: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	mov	0x7d0, %r22
	.word 0xde8e2000  ! 36: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r15
	mov	0x68, %r24
	.word 0xd2840400  ! 38: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r9
	.word 0xd6c5c4a0  ! 39: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r11
	mov	0x3c0, %r22
	mov	0x70, %r26
	.word 0xdc9f4e80  ! 42: LDDA_R	ldda	[%r29, %r0] 0x74, %r14
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd6af0e40  ! 44: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	.word 0xd6bee000  ! 45: STDA_I	stda	%r11, [%r27 + 0x0000] %asi
	.word 0xdef504a0  ! 46: STXA_R	stxa	%r15, [%r20 + %r0] 0x25
	.word 0xd48f0e60  ! 47: LDUBA_R	lduba	[%r28, %r0] 0x73, %r10
	.word 0xd486e000  ! 48: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	mov	0x20, %r26
	.word 0xdab609e0  ! 50: STHA_R	stha	%r13, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 51: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 52: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r27
	mov	0x0, %r18
	.word 0xda94a000  ! 55: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	.word 0x87802073  ! 56: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc8f4e60  ! 57: LDUBA_R	lduba	[%r29, %r0] 0x73, %r14
	.word 0xdc872000  ! 58: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0x87802025  ! 59: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r18
	.word 0x8780204f  ! 61: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd48e49e0  ! 62: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r10
	mov	0x70, %r25
	ta	T_CHANGE_NONHPRIV	! macro
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0f70e40  ! 66: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	.word 0x87802020  ! 67: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bf8e40  ! 68: STDA_R	stda	%r10, [%r30 + %r0] 0x72
	.word 0xd2dfce60  ! 69: LDXA_R	ldxa	[%r31, %r0] 0x73, %r9
	.word 0xd2ac2000  ! 70: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd8a78e80  ! 71: STWA_R	stwa	%r12, [%r30 + %r0] 0x74
	.word 0xd8c4a000  ! 72: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r12
	mov	0x0, %r25
	.word 0xdadcc400  ! 74: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xdcb40400  ! 75: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xdea40400  ! 76: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	mov	0x18, %r16
	mov	0x3d0, %r20
	.word 0x87802072  ! 79: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde972000  ! 80: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	mov	0x20, %r25
	.word 0xd4df4e80  ! 82: LDXA_R	ldxa	[%r29, %r0] 0x74, %r10
	.word 0xd4f78e80  ! 83: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	mov	0x20, %r24
	.word 0xd4cfa000  ! 85: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0x87802073  ! 86: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f8, %r21
	.word 0xdaa74e60  ! 88: STWA_R	stwa	%r13, [%r29 + %r0] 0x73
	.word 0xdaa7a000  ! 89: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xda872000  ! 90: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0xd6ae09e0  ! 91: STBA_R	stba	%r11, [%r24 + %r0] 0x4f
	mov	0x20, %r18
	.word 0x87802025  ! 93: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 94: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f78e40  ! 95: STXA_R	stxa	%r11, [%r30 + %r0] 0x72
	.word 0xdcf44400  ! 96: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xdc8ea000  ! 97: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r14
	.word 0xdcdd44a0  ! 98: LDXA_R	ldxa	[%r21, %r0] 0x25, %r14
	.word 0xdc866000  ! 99: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r14
	mov	0x20, %r16
	.word 0xd487ce60  ! 101: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r10
	.word 0xd4a66000  ! 102: STWA_I	stwa	%r10, [%r25 + 0x0000] %asi
	mov	0x7e0, %r20
	mov	0x7f0, %r22
	.word 0xd8d40400  ! 105: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	.word 0xd88ea000  ! 106: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r12
	.word 0xdad7ce40  ! 107: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r13
	.word 0xd2848400  ! 108: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r9
	mov	0x28, %r18
	mov	0x50, %r25
	.word 0x87802072  ! 111: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 112: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd29ea000  ! 113: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r9
	.word 0xdea74e80  ! 114: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	.word 0xdede6000  ! 115: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r15
	.word 0xd0f504a0  ! 116: STXA_R	stxa	%r8, [%r20 + %r0] 0x25
	.word 0xded584a0  ! 117: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r15
	mov	0x68, %r19
	.word 0x87802073  ! 119: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef40400  ! 120: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0xdea74e60  ! 121: STWA_R	stwa	%r15, [%r29 + %r0] 0x73
	mov	0x50, %r27
	.word 0xdec7e000  ! 123: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xd2f7ce40  ! 124: STXA_R	stxa	%r9, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 125: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2aea000  ! 126: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0xd88f8e60  ! 127: LDUBA_R	lduba	[%r30, %r0] 0x73, %r12
	mov	0x7d8, %r22
	.word 0xd8866000  ! 129: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r12
	mov	0x8, %r26
	mov	0x70, %r18
	.word 0xd2a5c4a0  ! 132: STWA_R	stwa	%r9, [%r23 + %r0] 0x25
	mov	0x30, %r27
	.word 0x87802074  ! 134: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bc0400  ! 135: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xdeb544a0  ! 136: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	mov	0x30, %r24
	.word 0x87802074  ! 138: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdecf6000  ! 139: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0xdec76000  ! 140: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xd29f0e60  ! 141: LDDA_R	ldda	[%r28, %r0] 0x73, %r9
	.word 0xd28f6000  ! 142: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0x87802020  ! 143: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded7ce40  ! 144: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r15
	.word 0xda874e40  ! 145: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r13
	mov	0x7d0, %r21
	.word 0x87802020  ! 147: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a4c400  ! 148: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xd0bc6000  ! 149: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 150: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 151: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d8, %r23
	mov	0x48, %r25
	.word 0xd09f6000  ! 154: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	.word 0xd0d7e000  ! 155: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	mov	0x7e8, %r23
	.word 0x87802020  ! 157: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ac6000  ! 158: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0xda874e80  ! 159: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r13
	.word 0xdacf4e60  ! 160: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r13
	.word 0xd8bd84a0  ! 161: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	.word 0xd8aca000  ! 162: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 163: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8d56000  ! 164: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r12
	.word 0xd8b56000  ! 165: STHA_I	stha	%r12, [%r21 + 0x0000] %asi
	.word 0xd885e000  ! 166: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r12
	.word 0xd6afce40  ! 167: STBA_R	stba	%r11, [%r31 + %r0] 0x72
	.word 0xd6bd2000  ! 168: STDA_I	stda	%r11, [%r20 + 0x0000] %asi
	.word 0xd6bda000  ! 169: STDA_I	stda	%r11, [%r22 + 0x0000] %asi
	.word 0xd2c70e80  ! 170: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r9
	mov	0x60, %r26
	.word 0xd2f5a000  ! 172: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	mov	0x7e8, %r23
	mov	0x48, %r24
	mov	0x3c0, %r22
	mov	0x7c0, %r21
	mov	0x50, %r24
	.word 0xd0b544a0  ! 178: STHA_R	stha	%r8, [%r21 + %r0] 0x25
	mov	0x7d8, %r21
	.word 0xd0a52000  ! 180: STWA_I	stwa	%r8, [%r20 + 0x0000] %asi
	.word 0xd4f74e80  ! 181: STXA_R	stxa	%r10, [%r29 + %r0] 0x74
	.word 0xdcaf0e80  ! 182: STBA_R	stba	%r14, [%r28 + %r0] 0x74
	.word 0x87802072  ! 183: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcdfe000  ! 184: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xdccf6000  ! 185: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcc76000  ! 186: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0x87802020  ! 187: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r24
	mov	0x7d0, %r21
	.word 0xdcb4e000  ! 190: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xd6ccc400  ! 191: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	.word 0xd69ce000  ! 192: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r11
	.word 0xd6c78e80  ! 193: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r11
	mov	0x78, %r26
	mov	0x3c0, %r23
	.word 0x87802025  ! 196: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c0, %r23
	mov	0x7d0, %r20
	mov	0x70, %r16
	.word 0xd6ade000  ! 200: STBA_I	stba	%r11, [%r23 + 0x0000] %asi
	.word 0xd6ada000  ! 201: STBA_I	stba	%r11, [%r22 + 0x0000] %asi
	mov	0x7f8, %r23
	.word 0xd8c44400  ! 203: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r12
	.word 0xd8dd2000  ! 204: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r12
	.word 0xd6b44400  ! 205: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0x87802025  ! 206: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f8, %r23
	.word 0xdcbf4e80  ! 208: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	.word 0xd6c5c4a0  ! 209: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r11
	.word 0xdedc0400  ! 210: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	.word 0xde8d6000  ! 211: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r15
	.word 0xdeb56000  ! 212: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	mov	0x8, %r26
	.word 0xd8f6c9e0  ! 214: STXA_R	stxa	%r12, [%r27 + %r0] 0x4f
	.word 0xd0d78e40  ! 215: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r8
	mov	0x3f0, %r23
	.word 0xd0dde000  ! 217: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r8
	.word 0xd4aec9e0  ! 218: STBA_R	stba	%r10, [%r27 + %r0] 0x4f
	mov	0x7c8, %r21
	.word 0xd4c52000  ! 220: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r10
	.word 0xd6b70e40  ! 221: STHA_R	stha	%r11, [%r28 + %r0] 0x72
	mov	0x28, %r27
	mov	0x78, %r27
	mov	0x7e0, %r22
	mov	0x0, %r17
	.word 0x87802020  ! 226: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c74e40  ! 227: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r11
	.word 0xda970e40  ! 228: LDUHA_R	lduha	[%r28, %r0] 0x72, %r13
	mov	0x3c8, %r20
	.word 0xdc8c8400  ! 230: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0x87802073  ! 231: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcc4c400  ! 232: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	.word 0xdcbf2000  ! 233: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	mov	0x60, %r18
	.word 0xdc9f6000  ! 235: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xdc8fa000  ! 236: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdca7a000  ! 237: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 238: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b48400  ! 239: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	mov	0x8, %r26
	.word 0xd2f44400  ! 241: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	.word 0xd6b78e80  ! 242: STHA_R	stha	%r11, [%r30 + %r0] 0x74
	mov	0x60, %r18
	mov	0x3f8, %r23
	mov	0x7d0, %r20
	mov	0x48, %r18
	mov	0x3d8, %r20
	.word 0xdcaf4e60  ! 248: STBA_R	stba	%r14, [%r29 + %r0] 0x73
	.word 0xdcbfa000  ! 249: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xd2b48400  ! 250: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	mov	0x7e0, %r23
	.word 0x87802072  ! 252: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r19
	.word 0xd287e000  ! 254: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0xd8948400  ! 255: LDUHA_R	lduha	[%r18, %r0] 0x20, %r12
	.word 0xd8876000  ! 256: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0xdaf70e80  ! 257: STXA_R	stxa	%r13, [%r28 + %r0] 0x74
	mov	0x7d0, %r20
	.word 0xda840400  ! 259: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	.word 0xdcf609e0  ! 260: STXA_R	stxa	%r14, [%r24 + %r0] 0x4f
	.word 0xdcd72000  ! 261: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xdc9fe000  ! 262: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xd686c9e0  ! 263: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r11
	.word 0x87802073  ! 264: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6972000  ! 265: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	.word 0x87802020  ! 266: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r24
	.word 0xd6a78e60  ! 268: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0xd2ac4400  ! 269: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xd6f40400  ! 270: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	mov	0x3f8, %r23
	.word 0x87802074  ! 272: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b78e80  ! 273: STHA_R	stha	%r10, [%r30 + %r0] 0x74
	.word 0xd287ce40  ! 274: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r9
	.word 0xdca609e0  ! 275: STWA_R	stwa	%r14, [%r24 + %r0] 0x4f
	.word 0xdc972000  ! 276: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	.word 0xdcb7e000  ! 277: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xd4dd84a0  ! 278: LDXA_R	ldxa	[%r22, %r0] 0x25, %r10
	.word 0x87802020  ! 279: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r19
	.word 0x87802073  ! 281: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r16
	.word 0xd6c78e40  ! 283: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	.word 0xdcdc8400  ! 284: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	.word 0xdccfa000  ! 285: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xd6f78e60  ! 286: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	.word 0xd6df2000  ! 287: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0x87802073  ! 288: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r17
	.word 0x8780204f  ! 290: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabe49e0  ! 291: STDA_R	stda	%r13, [%r25 + %r0] 0x4f
	mov	0x3d0, %r22
	.word 0x8780204f  ! 293: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdac6a000  ! 294: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r13
	.word 0xdab6a000  ! 295: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	.word 0xded6c9e0  ! 296: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r15
	.word 0xd2cf0e60  ! 297: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r9
	mov	0x7c8, %r22
	mov	0x7c0, %r20
	.word 0xd2c6a000  ! 300: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r9
	.word 0xd2f6e000  ! 301: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	.word 0xdeb44400  ! 302: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	mov	0x8, %r25
	.word 0xdebe2000  ! 304: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	.word 0xdecea000  ! 305: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r15
	.word 0xdeaee000  ! 306: STBA_I	stba	%r15, [%r27 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x68, %r26
	.word 0xde8e6000  ! 309: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 310: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e0, %r20
	.word 0x87802020  ! 312: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 313: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde9fe000  ! 314: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0xdedfa000  ! 315: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x3d8, %r23
	.word 0xd0bf0e80  ! 317: STDA_R	stda	%r8, [%r28 + %r0] 0x74
	.word 0xd0c72000  ! 318: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0cf6000  ! 319: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd4bf4e40  ! 320: STDA_R	stda	%r10, [%r29 + %r0] 0x72
	mov	0x58, %r19
	.word 0xd4cf6000  ! 322: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0xd4a76000  ! 323: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	mov	0x7f0, %r23
	mov	0x30, %r16
	mov	0x3d8, %r23
	.word 0xd0df4e40  ! 327: LDXA_R	ldxa	[%r29, %r0] 0x72, %r8
	.word 0xd0df0e80  ! 328: LDXA_R	ldxa	[%r28, %r0] 0x74, %r8
	mov	0x38, %r16
	.word 0xd6f74e80  ! 330: STXA_R	stxa	%r11, [%r29 + %r0] 0x74
	.word 0xdeccc400  ! 331: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r15
	mov	0x7d8, %r23
	.word 0xdec7e000  ! 333: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xdec76000  ! 334: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xd4c7ce40  ! 335: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r10
	.word 0xd8f6c9e0  ! 336: STXA_R	stxa	%r12, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 337: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 338: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd89ca000  ! 339: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r12
	.word 0xd8b4a000  ! 340: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0xd8f42000  ! 341: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8a42000  ! 342: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 343: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea649e0  ! 344: STWA_R	stwa	%r15, [%r25 + %r0] 0x4f
	.word 0x8780204f  ! 345: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 346: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea62000  ! 347: STWA_I	stwa	%r15, [%r24 + 0x0000] %asi
	mov	0x3c8, %r22
	.word 0xdc9ec9e0  ! 349: LDDA_R	ldda	[%r27, %r0] 0x4f, %r14
	.word 0xd2ac8400  ! 350: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0x87802025  ! 351: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2cde000  ! 352: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r9
	.word 0xdc944400  ! 353: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	.word 0xd2f70e40  ! 354: STXA_R	stxa	%r9, [%r28 + %r0] 0x72
	.word 0xd895c4a0  ! 355: LDUHA_R	lduha	[%r23, %r0] 0x25, %r12
	mov	0x3d0, %r22
	.word 0xd8ad6000  ! 357: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	.word 0xd8c52000  ! 358: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r12
	.word 0xd885e000  ! 359: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r12
	.word 0xdcf70e40  ! 360: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	mov	0x40, %r17
	mov	0x18, %r25
	.word 0xdcb52000  ! 363: STHA_I	stha	%r14, [%r20 + 0x0000] %asi
	.word 0xdcb52000  ! 364: STHA_I	stha	%r14, [%r20 + 0x0000] %asi
	.word 0xd6b74e80  ! 365: STHA_R	stha	%r11, [%r29 + %r0] 0x74
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x30, %r16
	.word 0xd6a56000  ! 368: STWA_I	stwa	%r11, [%r21 + 0x0000] %asi
	.word 0xdcf4c400  ! 369: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0x87802020  ! 370: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 371: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9c4400  ! 372: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	.word 0x87802074  ! 373: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd68689e0  ! 374: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r11
	.word 0xd6b70e40  ! 375: STHA_R	stha	%r11, [%r28 + %r0] 0x72
	.word 0x87802025  ! 376: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6bde000  ! 377: STDA_I	stda	%r11, [%r23 + 0x0000] %asi
	mov	0x68, %r25
	.word 0xd6bd2000  ! 379: STDA_I	stda	%r11, [%r20 + 0x0000] %asi
	.word 0xd6cd6000  ! 380: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r11
	.word 0xdad48400  ! 381: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0x87802072  ! 382: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcdc8400  ! 383: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	.word 0xdcbfe000  ! 384: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdcd76000  ! 385: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2b48400  ! 387: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd4ccc400  ! 388: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	mov	0x0, %r25
	.word 0xd4dfa000  ! 390: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	mov	0x38, %r24
	.word 0xda87ce40  ! 392: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r13
	.word 0xd68f8e80  ! 393: LDUBA_R	lduba	[%r30, %r0] 0x74, %r11
	.word 0x87802074  ! 394: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6dc8400  ! 395: LDXA_R	ldxa	[%r18, %r0] 0x20, %r11
	.word 0xd6f7a000  ! 396: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6bf6000  ! 397: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xdcbc4400  ! 398: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0xdcf76000  ! 399: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcd7e000  ! 400: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xdecdc4a0  ! 401: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r15
	.word 0xdebf4e40  ! 402: STDA_R	stda	%r15, [%r29 + %r0] 0x72
	.word 0xdcaf4e60  ! 403: STBA_R	stba	%r14, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 404: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r21
	.word 0xdaa584a0  ! 406: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	mov	0x78, %r27
	.word 0x87802074  ! 408: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabf2000  ! 409: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xd4bdc4a0  ! 410: STDA_R	stda	%r10, [%r23 + %r0] 0x25
	.word 0xd4c44400  ! 411: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r10
	.word 0xd4b40400  ! 412: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	mov	0x0, %r27
	mov	0x7f8, %r21
	mov	0x3f8, %r20
	mov	0x78, %r24
	.word 0x87802020  ! 417: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r22
	mov	0x3c0, %r20
	.word 0xd4bc2000  ! 420: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0xd4dce000  ! 421: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	.word 0xd4f4a000  ! 422: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0xd49c6000  ! 423: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	mov	0x7e8, %r22
	.word 0x87802072  ! 425: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cf6000  ! 426: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	mov	0x7c0, %r20
	.word 0xdaacc400  ! 428: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	mov	0x3f0, %r23
	.word 0xdaaf0e40  ! 430: STBA_R	stba	%r13, [%r28 + %r0] 0x72
	.word 0xdebf0e40  ! 431: STDA_R	stda	%r15, [%r28 + %r0] 0x72
	.word 0xdeb7a000  ! 432: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	mov	0x8, %r27
	.word 0x87802072  ! 434: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29609e0  ! 435: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd495c4a0  ! 437: LDUHA_R	lduha	[%r23, %r0] 0x25, %r10
	.word 0x87802073  ! 438: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c0, %r21
	.word 0x87802074  ! 440: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4ccc400  ! 441: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0x87802074  ! 442: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4d72000  ! 443: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	mov	0x28, %r24
	mov	0x3e8, %r20
	.word 0xd4c7e000  ! 446: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4b72000  ! 447: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 448: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 449: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b4c400  ! 450: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0xd0ac2000  ! 451: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xd69cc400  ! 452: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	mov	0x70, %r17
	.word 0x87802074  ! 454: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d8, %r21
	.word 0xdca5c4a0  ! 456: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	.word 0xdc9ec9e0  ! 457: LDDA_R	ldda	[%r27, %r0] 0x4f, %r14
	.word 0xd2978e40  ! 458: LDUHA_R	lduha	[%r30, %r0] 0x72, %r9
	.word 0xd2972000  ! 459: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xd48f4e40  ! 460: LDUBA_R	lduba	[%r29, %r0] 0x72, %r10
	.word 0xd4bf6000  ! 461: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	mov	0x10, %r17
	.word 0xd4a72000  ! 463: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	mov	0x3d0, %r23
	.word 0x8780204f  ! 465: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f5c4a0  ! 466: STXA_R	stxa	%r9, [%r23 + %r0] 0x25
	mov	0x7e8, %r23
	.word 0xd4f609e0  ! 468: STXA_R	stxa	%r10, [%r24 + %r0] 0x4f
	.word 0xd2b74e40  ! 469: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	.word 0xd2866000  ! 470: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r9
	.word 0x87802073  ! 471: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2bf2000  ! 472: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd8a4c400  ! 473: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xd2dc0400  ! 474: LDXA_R	ldxa	[%r16, %r0] 0x20, %r9
	mov	0x38, %r18
	.word 0xd29f2000  ! 476: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd29f2000  ! 477: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xde8d44a0  ! 478: LDUBA_R	lduba	[%r21, %r0] 0x25, %r15
	mov	0x48, %r27
	.word 0xd4978e80  ! 480: LDUHA_R	lduha	[%r30, %r0] 0x74, %r10
	mov	0x78, %r25
	.word 0xd4bf6000  ! 482: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd28cc400  ! 483: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	.word 0xd4bcc400  ! 484: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0x87802025  ! 485: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4f56000  ! 486: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 487: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 488: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcad84a0  ! 489: STBA_R	stba	%r14, [%r22 + %r0] 0x25
	.word 0xda8f4e40  ! 490: LDUBA_R	lduba	[%r29, %r0] 0x72, %r13
	.word 0xdab7a000  ! 491: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 492: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r26
	mov	0x7c8, %r23
	.word 0xdab6a000  ! 495: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	.word 0xdad62000  ! 496: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r13
	.word 0xd09cc400  ! 497: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	.word 0x87802020  ! 498: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 499: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaacc400  ! 500: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	mov	0x78, %r18
	mov	0x38, %r24
	.word 0x87802020  ! 503: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 504: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeae09e0  ! 505: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	.word 0xdeaca000  ! 506: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xde9c2000  ! 507: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xde9ce000  ! 508: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0xdeb42000  ! 509: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0xdebce000  ! 510: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xdeb4a000  ! 511: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	mov	0x7c8, %r22
	.word 0xdeaca000  ! 513: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xd6cf8e40  ! 514: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r11
	mov	0x40, %r27
	.word 0x87802025  ! 516: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r19
	mov	0x30, %r25
	.word 0xd8d44400  ! 519: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	.word 0xd8cda000  ! 520: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r12
	.word 0xd8f5a000  ! 521: STXA_I	stxa	%r12, [%r22 + 0x0000] %asi
	.word 0xd0a40400  ! 522: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0xda8ec9e0  ! 523: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r13
	.word 0xdab52000  ! 524: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	mov	0x18, %r16
	.word 0xd8a74e80  ! 526: STWA_R	stwa	%r12, [%r29 + %r0] 0x74
	mov	0x28, %r18
	mov	0x50, %r16
	.word 0x87802020  ! 529: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef44400  ! 530: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xdeb46000  ! 531: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 532: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r25
	.word 0xde9d6000  ! 534: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r15
	.word 0xde9de000  ! 535: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r15
	.word 0xd28f4e80  ! 536: LDUBA_R	lduba	[%r29, %r0] 0x74, %r9
	.word 0x87802025  ! 537: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2f5e000  ! 538: STXA_I	stxa	%r9, [%r23 + 0x0000] %asi
	.word 0xd2f5e000  ! 539: STXA_I	stxa	%r9, [%r23 + 0x0000] %asi
	.word 0xd4a609e0  ! 540: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	mov	0x58, %r19
	mov	0x58, %r17
	mov	0x3f8, %r22
	.word 0x87802020  ! 544: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbc0400  ! 545: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0xd8b7ce60  ! 546: STHA_R	stha	%r12, [%r31 + %r0] 0x73
	mov	0x3d8, %r21
	mov	0x10, %r19
	mov	0x3c8, %r22
	.word 0xd8cc2000  ! 550: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r12
	.word 0x87802020  ! 551: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r16
	.word 0xd8a4e000  ! 553: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 554: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9544a0  ! 555: LDUHA_R	lduha	[%r21, %r0] 0x25, %r15
	.word 0xdecc2000  ! 556: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	.word 0xda84c400  ! 557: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r13
	.word 0x87802025  ! 558: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabd6000  ! 559: STDA_I	stda	%r13, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 560: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8d4c400  ! 561: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0xd8a6a000  ! 562: STWA_I	stwa	%r12, [%r26 + 0x0000] %asi
	.word 0xd8ae6000  ! 563: STBA_I	stba	%r12, [%r25 + 0x0000] %asi
	.word 0xded649e0  ! 564: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r15
	.word 0xdcb584a0  ! 565: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	.word 0xd0bf0e40  ! 566: STDA_R	stda	%r8, [%r28 + %r0] 0x72
	.word 0xd08e2000  ! 567: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r8
	.word 0xd0d66000  ! 568: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r8
	.word 0x87802073  ! 569: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0df6000  ! 570: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	mov	0x28, %r16
	.word 0xd0f76000  ! 572: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	mov	0x0, %r24
	mov	0x8, %r25
	mov	0x7f0, %r22
	.word 0x87802073  ! 576: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a72000  ! 577: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x0, %r25
	.word 0xd4ac0400  ! 579: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xdeacc400  ! 580: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xdebfe000  ! 581: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xdeafa000  ! 582: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	mov	0x10, %r16
	.word 0xdab70e80  ! 584: STHA_R	stha	%r13, [%r28 + %r0] 0x74
	.word 0xdc874e40  ! 585: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r14
	.word 0x8780204f  ! 586: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbe49e0  ! 587: STDA_R	stda	%r14, [%r25 + %r0] 0x4f
	.word 0x8780204f  ! 588: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r27
	.word 0xdcde6000  ! 590: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r14
	.word 0xd0ce09e0  ! 591: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r8
	.word 0xd0be6000  ! 592: STDA_I	stda	%r8, [%r25 + 0x0000] %asi
	.word 0xd0c6a000  ! 593: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r8
	.word 0xd684c400  ! 594: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	.word 0xd6f6a000  ! 595: STXA_I	stxa	%r11, [%r26 + 0x0000] %asi
	.word 0xd696e000  ! 596: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	.word 0xdc9dc4a0  ! 597: LDDA_R	ldda	[%r23, %r0] 0x25, %r14
	.word 0xdaaf8e40  ! 598: STBA_R	stba	%r13, [%r30 + %r0] 0x72
	.word 0xd6bec9e0  ! 599: STDA_R	stda	%r11, [%r27 + %r0] 0x4f
	mov	0x38, %r17
	.word 0x87802020  ! 601: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r18
	.word 0xdab7ce80  ! 603: STHA_R	stha	%r13, [%r31 + %r0] 0x74
	mov	0x0, %r25
	.word 0xdadca000  ! 605: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	mov	0x78, %r24
	.word 0x87802020  ! 607: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad4a000  ! 608: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0xda9c6000  ! 609: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xdab46000  ! 610: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	mov	0x20, %r25
	.word 0xdc840400  ! 612: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	.word 0xdc946000  ! 613: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r14
	.word 0xd0d4c400  ! 614: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	.word 0xd09ca000  ! 615: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	.word 0xd0842000  ! 616: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r8
	.word 0xd0cca000  ! 617: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	.word 0xd0dc0400  ! 618: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xd0f42000  ! 619: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	mov	0x50, %r18
	.word 0xd29504a0  ! 621: LDUHA_R	lduha	[%r20, %r0] 0x25, %r9
	mov	0x0, %r26
	.word 0xd29c2000  ! 623: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	mov	0x28, %r25
	.word 0xd0ce09e0  ! 625: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r8
	.word 0xd0bc2000  ! 626: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	mov	0x7c0, %r22
	.word 0xd0dce000  ! 628: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r8
	.word 0xd08c2000  ! 629: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0xdcf78e40  ! 630: STXA_R	stxa	%r14, [%r30 + %r0] 0x72
	.word 0xdc84a000  ! 631: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	.word 0xd2b70e60  ! 632: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	.word 0xdec584a0  ! 633: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r15
	.word 0xde94e000  ! 634: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	.word 0x87802025  ! 635: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 636: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d78e40  ! 637: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r12
	mov	0x48, %r24
	.word 0xd09d84a0  ! 639: LDDA_R	ldda	[%r22, %r0] 0x25, %r8
	.word 0xd48f8e40  ! 640: LDUBA_R	lduba	[%r30, %r0] 0x72, %r10
	.word 0xd48544a0  ! 641: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r10
	mov	0x7f8, %r22
	.word 0xdebf4e80  ! 643: STDA_R	stda	%r15, [%r29 + %r0] 0x74
	.word 0xdeace000  ! 644: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xde846000  ! 645: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0xd2acc400  ! 646: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0x87802072  ! 647: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 648: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r18
	mov	0x0, %r25
	.word 0xd2c4a000  ! 651: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	.word 0xd49d84a0  ! 652: LDDA_R	ldda	[%r22, %r0] 0x25, %r10
	mov	0x3c8, %r22
	mov	0x60, %r24
	.word 0xdef584a0  ! 655: STXA_R	stxa	%r15, [%r22 + %r0] 0x25
	.word 0x87802072  ! 656: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb76000  ! 657: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	mov	0x40, %r25
	.word 0xdec7e000  ! 659: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	mov	0x8, %r27
	mov	0x70, %r16
	.word 0xd2d70e40  ! 662: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r9
	mov	0x7e0, %r21
	.word 0xd2bf6000  ! 664: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 665: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeac4400  ! 666: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0xde8c6000  ! 667: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0xde9c6000  ! 668: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0xd8ac8400  ! 669: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0xd8946000  ! 670: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	mov	0x10, %r18
	.word 0xd4bc8400  ! 672: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	mov	0x40, %r27
	.word 0xd6cfce60  ! 674: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r11
	.word 0xdeb48400  ! 675: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xde9ca000  ! 676: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	.word 0xdec4e000  ! 677: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	.word 0xda8c0400  ! 678: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	.word 0x87802073  ! 679: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 680: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3f8, %r20
	.word 0xda8f6000  ! 682: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xd8bc8400  ! 683: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0x87802072  ! 684: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r17
	.word 0xd0a78e40  ! 686: STWA_R	stwa	%r8, [%r30 + %r0] 0x72
	.word 0x8780204f  ! 687: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x0, %r19
	.word 0xd0b6e000  ! 689: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	.word 0xd0f584a0  ! 690: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	.word 0xd8f74e80  ! 691: STXA_R	stxa	%r12, [%r29 + %r0] 0x74
	mov	0x8, %r16
	.word 0xd8de2000  ! 693: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r12
	.word 0x87802074  ! 694: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802072  ! 696: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 697: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r19
	.word 0x87802072  ! 699: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r27
	.word 0xd897e000  ! 701: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	mov	0x68, %r25
	mov	0x3c8, %r21
	.word 0x87802020  ! 704: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 705: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6be09e0  ! 706: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	.word 0xd89f4e80  ! 707: LDDA_R	ldda	[%r29, %r0] 0x74, %r12
	.word 0xd8cfa000  ! 708: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd8f7a000  ! 709: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 710: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdedcc400  ! 711: LDXA_R	ldxa	[%r19, %r0] 0x20, %r15
	mov	0x48, %r27
	.word 0xd8b74e80  ! 713: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	mov	0x0, %r16
	.word 0x8780204f  ! 715: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8de2000  ! 716: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r12
	.word 0xd8bea000  ! 717: STDA_I	stda	%r12, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 718: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4dcc400  ! 719: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0xd6bcc400  ! 720: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	mov	0x18, %r24
	mov	0x7d8, %r22
	.word 0x8780204f  ! 723: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f8, %r23
	mov	0x20, %r25
	.word 0xd6f66000  ! 726: STXA_I	stxa	%r11, [%r25 + 0x0000] %asi
	.word 0xd68ee000  ! 727: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r11
	.word 0xd6f62000  ! 728: STXA_I	stxa	%r11, [%r24 + 0x0000] %asi
	mov	0x50, %r27
	mov	0x70, %r16
	mov	0x0, %r27
	.word 0x87802025  ! 732: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0b74e40  ! 733: STHA_R	stha	%r8, [%r29 + %r0] 0x72
	.word 0xded609e0  ! 734: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r15
	mov	0x38, %r25
	.word 0xdeb52000  ! 736: STHA_I	stha	%r15, [%r20 + 0x0000] %asi
	.word 0xdeb52000  ! 737: STHA_I	stha	%r15, [%r20 + 0x0000] %asi
	mov	0x60, %r27
	.word 0xd8f544a0  ! 739: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	mov	0x30, %r25
	mov	0x68, %r27
	.word 0xd0b48400  ! 742: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0x87802025  ! 743: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd08de000  ! 744: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r8
	.word 0xd6b74e40  ! 745: STHA_R	stha	%r11, [%r29 + %r0] 0x72
	mov	0x28, %r24
	.word 0xd69da000  ! 747: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r11
	.word 0xdab78e60  ! 748: STHA_R	stha	%r13, [%r30 + %r0] 0x73
	mov	0x58, %r16
	.word 0xd2af4e40  ! 750: STBA_R	stba	%r9, [%r29 + %r0] 0x72
	.word 0x87802020  ! 751: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r27
	.word 0x87802020  ! 753: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf70e80  ! 754: STXA_R	stxa	%r13, [%r28 + %r0] 0x74
	mov	0x70, %r17
	.word 0xd4ae09e0  ! 756: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0x87802025  ! 757: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f8, %r20
	.word 0x87802025  ! 759: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4bd2000  ! 760: STDA_I	stda	%r10, [%r20 + 0x0000] %asi
	.word 0xdef504a0  ! 761: STXA_R	stxa	%r15, [%r20 + %r0] 0x25
	.word 0xdecd2000  ! 762: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r15
	.word 0xde8da000  ! 763: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r15
	mov	0x20, %r19
	.word 0xdedd6000  ! 765: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r15
	.word 0xdef5a000  ! 766: STXA_I	stxa	%r15, [%r22 + 0x0000] %asi
	.word 0xdedde000  ! 767: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r15
	.word 0xdea52000  ! 768: STWA_I	stwa	%r15, [%r20 + 0x0000] %asi
	.word 0x8780204f  ! 769: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r18
	.word 0xdecf8e40  ! 771: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r15
	.word 0xded6a000  ! 772: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r15
	mov	0x8, %r18
	.word 0xdeacc400  ! 774: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	mov	0x7e8, %r23
	mov	0x68, %r26
	mov	0x48, %r26
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdecee000  ! 779: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r15
	.word 0xdede2000  ! 780: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r15
	.word 0xded6e000  ! 781: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r15
	.word 0xdaf6c9e0  ! 782: STXA_R	stxa	%r13, [%r27 + %r0] 0x4f
	.word 0xdab6a000  ! 783: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xdabe6000  ! 785: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	.word 0xdc9f0e40  ! 786: LDDA_R	ldda	[%r28, %r0] 0x72, %r14
	.word 0xd48c8400  ! 787: LDUBA_R	lduba	[%r18, %r0] 0x20, %r10
	.word 0xdec4c400  ! 788: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	mov	0x8, %r24
	.word 0xdea66000  ! 790: STWA_I	stwa	%r15, [%r25 + 0x0000] %asi
	mov	0x10, %r24
	.word 0xdc9f0e40  ! 792: LDDA_R	ldda	[%r28, %r0] 0x72, %r14
	.word 0xdaf78e80  ! 793: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	.word 0xdacea000  ! 794: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r13
	.word 0xd6acc400  ! 795: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	mov	0x58, %r27
	mov	0x8, %r26
	.word 0xd8878e80  ! 798: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r12
	.word 0xde970e60  ! 799: LDUHA_R	lduha	[%r28, %r0] 0x73, %r15
	.word 0xdec62000  ! 800: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r15
	.word 0xdea6a000  ! 801: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	.word 0xd2d504a0  ! 802: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r9
	.word 0x87802020  ! 803: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d42000  ! 804: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2b4e000  ! 805: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 806: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b46000  ! 807: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0xd2f42000  ! 808: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 809: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd28f6000  ! 810: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd4f4c400  ! 811: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd49f2000  ! 812: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd48f6000  ! 813: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xdaf44400  ! 814: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0xdaafe000  ! 815: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	mov	0x48, %r24
	.word 0x87802020  ! 817: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cc8400  ! 818: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0x87802072  ! 819: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r19
	.word 0xd0a44400  ! 821: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xd8c7ce80  ! 822: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r12
	.word 0xd0af0e40  ! 823: STBA_R	stba	%r8, [%r28 + %r0] 0x72
	.word 0xd2bc0400  ! 824: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xd8acc400  ! 825: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	mov	0x18, %r17
	.word 0xd0bd84a0  ! 827: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0xd6b74e40  ! 828: STHA_R	stha	%r11, [%r29 + %r0] 0x72
	.word 0xda9e09e0  ! 829: LDDA_R	ldda	[%r24, %r0] 0x4f, %r13
	.word 0xd0b584a0  ! 830: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	mov	0x78, %r25
	.word 0x87802020  ! 832: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b42000  ! 833: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 834: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0cfe000  ! 835: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	mov	0x7f0, %r22
	.word 0xd69c8400  ! 837: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	.word 0xd2874e80  ! 838: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r9
	.word 0x87802020  ! 839: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadf0e80  ! 840: LDXA_R	ldxa	[%r28, %r0] 0x74, %r13
	mov	0x70, %r19
	mov	0x30, %r19
	mov	0x8, %r18
	mov	0x3d0, %r20
	.word 0x87802073  ! 845: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda87a000  ! 846: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0x87802072  ! 847: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda972000  ! 848: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	mov	0x30, %r17
	.word 0xda9f4e40  ! 850: LDDA_R	ldda	[%r29, %r0] 0x72, %r13
	mov	0x48, %r25
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd09609e0  ! 853: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r8
	.word 0xd48d84a0  ! 854: LDUBA_R	lduba	[%r22, %r0] 0x25, %r10
	.word 0xd48f2000  ! 855: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0x87802073  ! 856: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdac4c400  ! 857: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r13
	.word 0xdad72000  ! 858: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0xd085c4a0  ! 859: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r8
	mov	0x7d0, %r23
	.word 0xd2ae89e0  ! 861: STBA_R	stba	%r9, [%r26 + %r0] 0x4f
	.word 0xdc87ce80  ! 862: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r14
	.word 0xdcaf6000  ! 863: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 864: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x48, %r19
	.word 0x87802020  ! 866: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f4c400  ! 867: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0xd2f7ce60  ! 868: STXA_R	stxa	%r9, [%r31 + %r0] 0x73
	.word 0xdc9f8e60  ! 869: LDDA_R	ldda	[%r30, %r0] 0x73, %r14
	.word 0x8780204f  ! 870: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 871: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e0, %r21
	.word 0xde870e80  ! 873: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r15
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802020  ! 875: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeace000  ! 876: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xdebc2000  ! 877: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xded42000  ! 878: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	.word 0xde846000  ! 879: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0xde9c2000  ! 880: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xdebc6000  ! 881: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 882: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r27
	.word 0x87802072  ! 884: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f8, %r20
	mov	0x7e0, %r20
	.word 0xdea7a000  ! 887: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	mov	0x3f8, %r23
	.word 0xdebfe000  ! 889: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xdec7a000  ! 890: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	mov	0x7c8, %r20
	mov	0x3d0, %r20
	.word 0xd0a44400  ! 893: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xd2bc0400  ! 894: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0x87802025  ! 895: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b5a000  ! 896: STHA_I	stha	%r9, [%r22 + 0x0000] %asi
	.word 0xdad78e60  ! 897: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r13
	.word 0xd8af4e60  ! 898: STBA_R	stba	%r12, [%r29 + %r0] 0x73
	.word 0xd8f56000  ! 899: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7c0, %r20
	.word 0xde9f0e80  ! 902: LDDA_R	ldda	[%r28, %r0] 0x74, %r15
	.word 0xdef52000  ! 903: STXA_I	stxa	%r15, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 904: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f70e40  ! 905: STXA_R	stxa	%r9, [%r28 + %r0] 0x72
	.word 0x87802073  ! 906: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r24
	.word 0xd49f8e60  ! 908: LDDA_R	ldda	[%r30, %r0] 0x73, %r10
	.word 0xd2ccc400  ! 909: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	.word 0xd29f6000  ! 910: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	mov	0x70, %r27
	mov	0x38, %r26
	mov	0x7d8, %r22
	mov	0x68, %r17
	.word 0xd0d78e40  ! 915: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r8
	.word 0xd0afe000  ! 916: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 917: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2cec9e0  ! 918: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r9
	.word 0xd2cfe000  ! 919: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	mov	0x60, %r18
	.word 0x87802074  ! 921: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde948400  ! 922: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	.word 0x87802020  ! 923: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68544a0  ! 924: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r11
	mov	0x7e8, %r23
	.word 0x87802020  ! 926: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bc4400  ! 927: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0x87802025  ! 928: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f8, %r22
	.word 0x87802020  ! 930: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 931: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a4c400  ! 932: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xd8dc6000  ! 933: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	mov	0x58, %r19
	.word 0x87802020  ! 935: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r24
	.word 0xd4a44400  ! 937: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xd4846000  ! 938: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r10
	.word 0x87802020  ! 939: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bc4400  ! 940: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0xd0a78e60  ! 941: STWA_R	stwa	%r8, [%r30 + %r0] 0x73
	.word 0xd0f42000  ! 942: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 943: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a56000  ! 944: STWA_I	stwa	%r8, [%r21 + 0x0000] %asi
	.word 0xd0bda000  ! 945: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	.word 0xd0b56000  ! 946: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	.word 0xd0952000  ! 947: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r8
	.word 0x87802020  ! 948: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebf8e60  ! 949: STDA_R	stda	%r15, [%r30 + %r0] 0x73
	mov	0x68, %r18
	mov	0x7d8, %r22
	.word 0xdeac2000  ! 952: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	mov	0x48, %r18
	.word 0xdcbc0400  ! 954: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0xdcaca000  ! 955: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xd6f7ce40  ! 957: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	mov	0x3f0, %r23
	mov	0x30, %r27
	mov	0x58, %r19
	.word 0xd6c4e000  ! 961: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r11
	.word 0xd6a42000  ! 962: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	mov	0x40, %r27
	.word 0xd684a000  ! 964: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r11
	.word 0xd6b4a000  ! 965: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd6a46000  ! 966: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0xdcbf0e80  ! 967: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	.word 0xd68c4400  ! 968: LDUBA_R	lduba	[%r17, %r0] 0x20, %r11
	.word 0x87802020  ! 969: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a7ce40  ! 970: STWA_R	stwa	%r9, [%r31 + %r0] 0x72
	.word 0xd2c42000  ! 971: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	.word 0x87802025  ! 972: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca74e60  ! 973: STWA_R	stwa	%r14, [%r29 + %r0] 0x73
	.word 0xdc8de000  ! 974: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r14
	.word 0x87802020  ! 975: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cc8400  ! 976: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	.word 0xd6a4a000  ! 977: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	.word 0xdaaf0e40  ! 978: STBA_R	stba	%r13, [%r28 + %r0] 0x72
	.word 0xda842000  ! 979: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r13
	mov	0x3f8, %r21
	.word 0xda84a000  ! 981: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	mov	0x7f8, %r22
	.word 0xdea584a0  ! 983: STWA_R	stwa	%r15, [%r22 + %r0] 0x25
	.word 0xded4a000  ! 984: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	.word 0xde8f4e80  ! 985: LDUBA_R	lduba	[%r29, %r0] 0x74, %r15
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802074  ! 987: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdecfa000  ! 988: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0x87802025  ! 989: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebda000  ! 990: STDA_I	stda	%r15, [%r22 + 0x0000] %asi
	.word 0xdef5e000  ! 991: STXA_I	stxa	%r15, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 992: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r25
	.word 0xde976000  ! 994: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	.word 0xde8f2000  ! 995: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xdecf2000  ! 996: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0x87802020  ! 997: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r25
	.word 0x87802025  ! 999: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd49f8e60  ! 1000: LDDA_R	ldda	[%r30, %r0] 0x73, %r10
	.word 0x87802020  ! 1001: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d7ce80  ! 1002: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r11
	.word 0xd4ad44a0  ! 1003: STBA_R	stba	%r10, [%r21 + %r0] 0x25
	.word 0xd28584a0  ! 1004: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r9
	.word 0xd2c78e40  ! 1005: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r9
	.word 0xd29c6000  ! 1006: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	.word 0xd28ce000  ! 1007: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	mov	0x7c8, %r21
	mov	0x50, %r26
	.word 0xd8d544a0  ! 1010: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r12
	.word 0xd8dc2000  ! 1011: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	mov	0x3c8, %r20
	mov	0x3e8, %r22
	mov	0x78, %r19
	.word 0xd8a46000  ! 1015: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	mov	0x48, %r26
	mov	0x3f8, %r23
	mov	0x3d8, %r20
	.word 0xde84c400  ! 1019: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0xdef46000  ! 1020: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xd8dc0400  ! 1021: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0x87802020  ! 1022: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4870e40  ! 1023: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r10
	.word 0xdccf0e80  ! 1024: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r14
	.word 0x87802072  ! 1025: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r27
	.word 0xdcc76000  ! 1027: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xd2f48400  ! 1028: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0xdca48400  ! 1029: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xdcb609e0  ! 1030: STHA_R	stha	%r14, [%r24 + %r0] 0x4f
	.word 0xdc8fa000  ! 1031: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	mov	0x7f8, %r23
	mov	0x10, %r19
	mov	0x7d8, %r22
	mov	0x70, %r17
	mov	0x60, %r16
	.word 0xdeb48400  ! 1037: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xd0a7ce60  ! 1038: STWA_R	stwa	%r8, [%r31 + %r0] 0x73
	mov	0x70, %r25
	.word 0x87802025  ! 1040: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c0, %r21
	mov	0x3f0, %r22
	.word 0xd095e000  ! 1043: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r8
	mov	0x18, %r17
	.word 0xd4f48400  ! 1045: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xd8848400  ! 1046: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r12
	.word 0xd8cd2000  ! 1047: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r12
	.word 0xd8ade000  ! 1048: STBA_I	stba	%r12, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 1049: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4a40400  ! 1050: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	.word 0xd0ac4400  ! 1051: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0x87802025  ! 1052: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d0, %r20
	mov	0x50, %r27
	.word 0xd0f5a000  ! 1055: STXA_I	stxa	%r8, [%r22 + 0x0000] %asi
	mov	0x7c8, %r22
	.word 0xd0d56000  ! 1057: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r8
	.word 0xd0b5a000  ! 1058: STHA_I	stha	%r8, [%r22 + 0x0000] %asi
	mov	0x60, %r19
	.word 0xda8dc4a0  ! 1060: LDUBA_R	lduba	[%r23, %r0] 0x25, %r13
	mov	0x10, %r26
	mov	0x10, %r19
	.word 0xdab544a0  ! 1063: STHA_R	stha	%r13, [%r21 + %r0] 0x25
	.word 0xd6f74e80  ! 1064: STXA_R	stxa	%r11, [%r29 + %r0] 0x74
	.word 0xd685a000  ! 1065: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r11
	.word 0xd6dde000  ! 1066: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r11
	.word 0x87802020  ! 1067: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6946000  ! 1068: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r11
	.word 0x87802074  ! 1069: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd69f2000  ! 1070: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0x87802073  ! 1071: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdebf0e60  ! 1072: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	.word 0x87802020  ! 1073: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebca000  ! 1074: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 1075: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd086c9e0  ! 1076: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r8
	mov	0x68, %r17
	.word 0xd4c689e0  ! 1078: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r10
	.word 0xd4df6000  ! 1079: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0x87802072  ! 1080: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4d72000  ! 1081: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	.word 0x87802072  ! 1082: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r24
	.word 0xdc8c4400  ! 1084: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0xdcbfe000  ! 1085: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdcbfa000  ! 1086: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1087: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r17
	.word 0xdcbc6000  ! 1089: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xdcb46000  ! 1090: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xdc8ca000  ! 1091: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r14
	.word 0x87802073  ! 1092: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8cc4400  ! 1093: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r12
	.word 0xdaf48400  ! 1094: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xd8d6c9e0  ! 1095: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r12
	.word 0x87802074  ! 1096: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8cf2000  ! 1097: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 1098: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 1099: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9f8e60  ! 1100: LDDA_R	ldda	[%r30, %r0] 0x73, %r13
	mov	0x28, %r19
	.word 0xdaf6a000  ! 1102: STXA_I	stxa	%r13, [%r26 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd6c78e40  ! 1104: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	mov	0x50, %r25
	.word 0xdca7ce40  ! 1106: STWA_R	stwa	%r14, [%r31 + %r0] 0x72
	mov	0x40, %r16
	mov	0x60, %r16
	.word 0xd2948400  ! 1109: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	.word 0xd0b78e80  ! 1110: STHA_R	stha	%r8, [%r30 + %r0] 0x74
	.word 0xd8cec9e0  ! 1111: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r12
	.word 0xd88e2000  ! 1112: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r12
	.word 0xd8ae2000  ! 1113: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0x87802020  ! 1115: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f42000  ! 1116: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	mov	0x38, %r18
	.word 0xd2a44400  ! 1118: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xd28c6000  ! 1119: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 1120: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a66000  ! 1121: STWA_I	stwa	%r9, [%r25 + 0x0000] %asi
	mov	0x0, %r25
	mov	0x7c8, %r22
	.word 0xd2f6a000  ! 1124: STXA_I	stxa	%r9, [%r26 + 0x0000] %asi
	.word 0xd2ce6000  ! 1125: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 1126: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 1127: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2878e60  ! 1128: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r9
	.word 0xd29fe000  ! 1129: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0x87802073  ! 1130: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2c7e000  ! 1131: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2f7e000  ! 1132: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 1133: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcd48400  ! 1134: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	.word 0x8780204f  ! 1135: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcd62000  ! 1136: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r14
	.word 0xdcde2000  ! 1137: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r14
	.word 0xd8a40400  ! 1138: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0xd2b609e0  ! 1139: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	.word 0xd29e6000  ! 1140: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r9
	.word 0xd2ae6000  ! 1141: STBA_I	stba	%r9, [%r25 + 0x0000] %asi
	.word 0x87802073  ! 1142: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b76000  ! 1143: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1144: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4be09e0  ! 1145: STDA_R	stda	%r10, [%r24 + %r0] 0x4f
	.word 0xdcf74e60  ! 1146: STXA_R	stxa	%r14, [%r29 + %r0] 0x73
	.word 0xd0f609e0  ! 1147: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	mov	0x7d0, %r21
	mov	0x78, %r19
	.word 0xdadc8400  ! 1150: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	.word 0x87802074  ! 1151: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r16
	.word 0xda9fa000  ! 1153: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xda8f6000  ! 1154: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	mov	0x18, %r25
	.word 0xdeacc400  ! 1156: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	mov	0x10, %r26
	.word 0xdadcc400  ! 1158: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xda9fe000  ! 1159: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0x87802073  ! 1160: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda8f6000  ! 1161: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0x87802025  ! 1162: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r24
	.word 0xdab5a000  ! 1164: STHA_I	stha	%r13, [%r22 + 0x0000] %asi
	.word 0xdadd6000  ! 1165: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r13
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdad56000  ! 1167: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r13
	.word 0x87802072  ! 1168: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r25
	mov	0x40, %r24
	.word 0xdadfa000  ! 1171: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xdaf7a000  ! 1172: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdab7e000  ! 1173: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xdab72000  ! 1175: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xd8dd84a0  ! 1176: LDXA_R	ldxa	[%r22, %r0] 0x25, %r12
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2f44400  ! 1178: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	.word 0xd2876000  ! 1179: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xd29f6000  ! 1180: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xd0a48400  ! 1181: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	mov	0x20, %r17
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802020  ! 1184: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r26
	.word 0x87802074  ! 1186: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r19
	mov	0x18, %r18
	mov	0x68, %r26
	.word 0x87802074  ! 1190: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e0, %r20
	mov	0x3f0, %r20
	.word 0xdca70e80  ! 1193: STWA_R	stwa	%r14, [%r28 + %r0] 0x74
	mov	0x20, %r19
	mov	0x60, %r27
	mov	0x3d8, %r22
	.word 0xdcafe000  ! 1197: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	mov	0x7f8, %r22
	.word 0xdca7a000  ! 1199: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 1200: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x3f8, %r20
	mov	0x30, %r25
	.word 0xdc872000  ! 1204: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcdfa000  ! 1205: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	mov	0x40, %r18
	.word 0x8780204f  ! 1207: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8c44400  ! 1208: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r12
	mov	0x58, %r25
	.word 0xd0c584a0  ! 1210: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r8
	.word 0xd0b62000  ! 1211: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0xd0dea000  ! 1212: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r8
	.word 0xd0c62000  ! 1213: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r8
	.word 0xd0de6000  ! 1214: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r8
	.word 0xd0b66000  ! 1215: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	.word 0xdebc8400  ! 1216: STDA_R	stda	%r15, [%r18 + %r0] 0x20
	.word 0xded78e80  ! 1217: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r15
	.word 0xdef6e000  ! 1218: STXA_I	stxa	%r15, [%r27 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdeb66000  ! 1220: STHA_I	stha	%r15, [%r25 + 0x0000] %asi
	.word 0xdef6a000  ! 1221: STXA_I	stxa	%r15, [%r26 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0xda9cc400  ! 1223: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	.word 0x87802025  ! 1224: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0dc0400  ! 1225: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xde9f0e40  ! 1226: LDDA_R	ldda	[%r28, %r0] 0x72, %r15
	.word 0xde878e80  ! 1227: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r15
	.word 0xd2948400  ! 1228: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	.word 0xdef544a0  ! 1229: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	.word 0xdecd6000  ! 1230: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r15
	.word 0xde85e000  ! 1231: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r15
	.word 0xd6b40400  ! 1232: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xd6a5e000  ! 1233: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	mov	0x58, %r18
	.word 0xd0cf4e60  ! 1235: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r8
	.word 0xd6f78e80  ! 1236: STXA_R	stxa	%r11, [%r30 + %r0] 0x74
	.word 0xd6df0e40  ! 1237: LDXA_R	ldxa	[%r28, %r0] 0x72, %r11
	mov	0x7f8, %r20
	.word 0x87802072  ! 1239: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r25
	.word 0xdca4c400  ! 1241: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xd8f649e0  ! 1242: STXA_R	stxa	%r12, [%r25 + %r0] 0x4f
	.word 0xd8a7e000  ! 1243: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1244: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48f4e40  ! 1245: LDUBA_R	lduba	[%r29, %r0] 0x72, %r10
	.word 0x87802073  ! 1246: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 1247: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4ade000  ! 1248: STBA_I	stba	%r10, [%r23 + 0x0000] %asi
	mov	0x18, %r19
	.word 0xd0ac0400  ! 1250: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	.word 0xd085e000  ! 1251: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r8
	.word 0xd4cfce40  ! 1252: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r10
	.word 0xd0f40400  ! 1253: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xd89d44a0  ! 1254: LDDA_R	ldda	[%r21, %r0] 0x25, %r12
	mov	0x3e8, %r23
	.word 0xdcaf0e60  ! 1256: STBA_R	stba	%r14, [%r28 + %r0] 0x73
	.word 0xdca5e000  ! 1257: STWA_I	stwa	%r14, [%r23 + 0x0000] %asi
	.word 0xd2ad04a0  ! 1258: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	.word 0xdeb74e60  ! 1259: STHA_R	stha	%r15, [%r29 + %r0] 0x73
	.word 0xd09f4e40  ! 1260: LDDA_R	ldda	[%r29, %r0] 0x72, %r8
	mov	0x68, %r16
	.word 0xd0bd2000  ! 1262: STDA_I	stda	%r8, [%r20 + 0x0000] %asi
	.word 0xd0dd6000  ! 1263: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r8
	.word 0xd48584a0  ! 1264: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r10
	.word 0xd4dde000  ! 1265: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r10
	.word 0xd4856000  ! 1266: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r10
	mov	0x3f8, %r22
	.word 0xd8cf4e40  ! 1268: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r12
	mov	0x7e8, %r22
	mov	0x3e0, %r20
	mov	0x28, %r24
	mov	0x3f8, %r23
	.word 0xd8956000  ! 1273: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r12
	mov	0x7e8, %r23
	.word 0xd8b5a000  ! 1275: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 1276: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd88fa000  ! 1277: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0xd88c0400  ! 1278: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	.word 0xd6bf4e60  ! 1279: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	.word 0x87802025  ! 1280: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd69da000  ! 1281: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r11
	.word 0x87802074  ! 1282: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c0, %r23
	.word 0xda878e60  ! 1284: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r13
	.word 0xdaf76000  ! 1285: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdadfe000  ! 1286: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0xd2b78e80  ! 1287: STHA_R	stha	%r9, [%r30 + %r0] 0x74
	.word 0xd6840400  ! 1288: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	mov	0x3c0, %r23
	.word 0xdebcc400  ! 1290: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	.word 0xdab48400  ! 1291: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0xdca74e80  ! 1292: STWA_R	stwa	%r14, [%r29 + %r0] 0x74
	.word 0xdcaf6000  ! 1293: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	mov	0x8, %r26
	.word 0xd69e89e0  ! 1295: LDDA_R	ldda	[%r26, %r0] 0x4f, %r11
	.word 0xd6b7a000  ! 1296: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1297: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d4e000  ! 1298: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r11
	.word 0xdc974e40  ! 1299: LDUHA_R	lduha	[%r29, %r0] 0x72, %r14
	.word 0x87802025  ! 1300: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd09504a0  ! 1301: LDUHA_R	lduha	[%r20, %r0] 0x25, %r8
	.word 0xd0b56000  ! 1302: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	mov	0x10, %r18
	.word 0xdabec9e0  ! 1304: STDA_R	stda	%r13, [%r27 + %r0] 0x4f
	mov	0x68, %r24
	.word 0xde87ce60  ! 1306: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r15
	.word 0xdcdfce60  ! 1307: LDXA_R	ldxa	[%r31, %r0] 0x73, %r14
	.word 0xdcc52000  ! 1308: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r14
	.word 0xd6974e80  ! 1309: LDUHA_R	lduha	[%r29, %r0] 0x74, %r11
	.word 0x87802020  ! 1310: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaccc400  ! 1311: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r13
	.word 0xd8cf4e60  ! 1312: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r12
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802072  ! 1314: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6a4c400  ! 1315: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0x87802020  ! 1316: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b4e000  ! 1317: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xd6a48400  ! 1318: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0xdcddc4a0  ! 1319: LDXA_R	ldxa	[%r23, %r0] 0x25, %r14
	.word 0xdcdc2000  ! 1320: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r14
	.word 0xd68f4e80  ! 1321: LDUBA_R	lduba	[%r29, %r0] 0x74, %r11
	.word 0xd6842000  ! 1322: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r11
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd68c2000  ! 1324: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r11
	.word 0xd684e000  ! 1325: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r11
	mov	0x50, %r19
	mov	0x7c8, %r22
	mov	0x7e8, %r20
	.word 0xd6d46000  ! 1329: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r11
	.word 0x87802074  ! 1330: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r16
	.word 0xd6df2000  ! 1332: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd4af0e80  ! 1333: STBA_R	stba	%r10, [%r28 + %r0] 0x74
	.word 0x87802020  ! 1334: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r26
	.word 0xd4a44400  ! 1336: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xd4d46000  ! 1337: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r10
	.word 0xd4b70e80  ! 1338: STHA_R	stha	%r10, [%r28 + %r0] 0x74
	.word 0x87802020  ! 1339: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcd78e40  ! 1340: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r14
	mov	0x20, %r18
	.word 0xdcf46000  ! 1342: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xd8c70e40  ! 1343: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r12
	mov	0x3d8, %r22
	.word 0x8780204f  ! 1345: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf44400  ! 1346: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0xdc874e80  ! 1347: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r14
	mov	0x30, %r24
	.word 0x87802072  ! 1349: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0cf0e80  ! 1350: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r8
	.word 0xd0872000  ! 1351: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1352: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0ade000  ! 1353: STBA_I	stba	%r8, [%r23 + 0x0000] %asi
	.word 0x87802073  ! 1354: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r24
	.word 0xd087a000  ! 1356: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0x87802074  ! 1357: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0af2000  ! 1358: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0d76000  ! 1359: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xdeb78e60  ! 1360: STHA_R	stha	%r15, [%r30 + %r0] 0x73
	mov	0x68, %r17
	.word 0xdadf0e40  ! 1362: LDXA_R	ldxa	[%r28, %r0] 0x72, %r13
	.word 0xda9f2000  ! 1363: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0x87802025  ! 1364: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd29cc400  ! 1365: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	.word 0xdcaf8e40  ! 1366: STBA_R	stba	%r14, [%r30 + %r0] 0x72
	mov	0x28, %r27
	.word 0xd6b4c400  ! 1368: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	mov	0x10, %r25
	.word 0xd88f4e40  ! 1370: LDUBA_R	lduba	[%r29, %r0] 0x72, %r12
	mov	0x3c0, %r23
	mov	0x3c0, %r21
	.word 0xd8ada000  ! 1373: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 1374: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ac2000  ! 1375: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 1376: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b46000  ! 1377: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xd8a4e000  ! 1379: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xd8a4a000  ! 1380: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8b46000  ! 1381: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0xd8a4a000  ! 1382: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	mov	0x7c0, %r20
	.word 0x87802020  ! 1384: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca78e60  ! 1385: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	mov	0x7c0, %r21
	.word 0xd6a74e60  ! 1387: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	mov	0x0, %r19
	.word 0xd6ac2000  ! 1389: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	.word 0xdca4c400  ! 1390: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xdca4e000  ! 1391: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	mov	0x3e0, %r20
	.word 0x87802020  ! 1393: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6870e60  ! 1394: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r11
	.word 0x87802073  ! 1395: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e8, %r23
	.word 0xd6afe000  ! 1397: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xdea44400  ! 1398: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0x87802074  ! 1399: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabf0e60  ! 1400: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	.word 0xd6d48400  ! 1401: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0xd8af0e60  ! 1402: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	.word 0xd0dc4400  ! 1403: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	.word 0xd0afa000  ! 1404: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd0df6000  ! 1405: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	mov	0x68, %r27
	mov	0x78, %r18
	.word 0xd0876000  ! 1408: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0b7a000  ! 1409: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd0bfe000  ! 1410: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 1411: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8974e60  ! 1412: LDUHA_R	lduha	[%r29, %r0] 0x73, %r12
	.word 0xdcb70e40  ! 1413: STHA_R	stha	%r14, [%r28 + %r0] 0x72
	.word 0xde8d84a0  ! 1414: LDUBA_R	lduba	[%r22, %r0] 0x25, %r15
	.word 0xd8b48400  ! 1415: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0x87802072  ! 1416: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 1417: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda85c4a0  ! 1418: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r13
	.word 0xdadf6000  ! 1419: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xdad76000  ! 1420: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0x87802072  ! 1421: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdacf2000  ! 1422: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xd08c0400  ! 1423: LDUBA_R	lduba	[%r16, %r0] 0x20, %r8
	.word 0x87802020  ! 1424: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6df0e80  ! 1425: LDXA_R	ldxa	[%r28, %r0] 0x74, %r11
	.word 0xdaa78e80  ! 1426: STWA_R	stwa	%r13, [%r30 + %r0] 0x74
	.word 0xda84a000  ! 1427: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	mov	0x0, %r27
	mov	0x8, %r16
	mov	0x60, %r25
	.word 0xdac46000  ! 1431: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r13
	.word 0xdcf6c9e0  ! 1432: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	.word 0xdaf4c400  ! 1433: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xdaaca000  ! 1434: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 1435: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r17
	.word 0xdac76000  ! 1437: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0xdac72000  ! 1438: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	mov	0x7d0, %r20
	.word 0x87802074  ! 1440: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf7a000  ! 1441: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdacf6000  ! 1442: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xdaafa000  ! 1443: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	mov	0x3f8, %r22
	.word 0xdad76000  ! 1445: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	mov	0x60, %r24
	.word 0x87802020  ! 1447: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab78e60  ! 1448: STHA_R	stha	%r13, [%r30 + %r0] 0x73
	.word 0x87802074  ! 1449: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0ae09e0  ! 1450: STBA_R	stba	%r8, [%r24 + %r0] 0x4f
	.word 0xd097e000  ! 1451: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1452: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd084e000  ! 1453: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	mov	0x0, %r26
	mov	0x38, %r25
	.word 0xdeccc400  ! 1456: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r15
	.word 0xdeb4a000  ! 1457: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0xdebc6000  ! 1459: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0x87802025  ! 1461: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c8, %r22
	mov	0x7d0, %r21
	mov	0x38, %r17
	.word 0xdaae09e0  ! 1465: STBA_R	stba	%r13, [%r24 + %r0] 0x4f
	.word 0xdadd2000  ! 1466: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r13
	.word 0xdabd2000  ! 1467: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	mov	0x78, %r16
	.word 0xd2874e60  ! 1469: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r9
	.word 0x87802025  ! 1470: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca7ce40  ! 1471: STWA_R	stwa	%r14, [%r31 + %r0] 0x72
	.word 0xda9f0e40  ! 1472: LDDA_R	ldda	[%r28, %r0] 0x72, %r13
	.word 0xdcc40400  ! 1473: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	.word 0xdcbda000  ! 1474: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	.word 0xdcdd6000  ! 1475: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r14
	mov	0x7d8, %r23
	.word 0xd4df0e40  ! 1477: LDXA_R	ldxa	[%r28, %r0] 0x72, %r10
	mov	0x3d8, %r20
	.word 0xd4bda000  ! 1479: STDA_I	stda	%r10, [%r22 + 0x0000] %asi
	mov	0x8, %r19
	.word 0xd8b609e0  ! 1481: STHA_R	stha	%r12, [%r24 + %r0] 0x4f
	.word 0xd8bda000  ! 1482: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	.word 0xd8bd2000  ! 1483: STDA_I	stda	%r12, [%r20 + 0x0000] %asi
	.word 0xd8f56000  ! 1484: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	.word 0xd8cda000  ! 1485: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r12
	.word 0xd08dc4a0  ! 1486: LDUBA_R	lduba	[%r23, %r0] 0x25, %r8
	mov	0x58, %r19
	mov	0x50, %r24
	.word 0x87802020  ! 1489: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r22
	.word 0xd0946000  ! 1491: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0xd0b4e000  ! 1492: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	mov	0x7f8, %r22
	.word 0xd4a74e40  ! 1494: STWA_R	stwa	%r10, [%r29 + %r0] 0x72
	.word 0x87802074  ! 1495: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4bf0e40  ! 1496: STDA_R	stda	%r10, [%r28 + %r0] 0x72
	.word 0xd4a78e60  ! 1497: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	.word 0xd6bf8e60  ! 1498: STDA_R	stda	%r11, [%r30 + %r0] 0x73
	mov	0x38, %r25
	mov	0x30, %r17
	mov	0x28, %r24
	mov	0x60, %r27
	mov	0x48, %r19
	mov	0x48, %r19
	.word 0xdab5c4a0  ! 1505: STHA_R	stha	%r13, [%r23 + %r0] 0x25
	.word 0x8780204f  ! 1506: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdccfce80  ! 1507: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r14
	.word 0xdc86a000  ! 1508: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r14
	.word 0xdcbcc400  ! 1509: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	mov	0x7d0, %r21
	.word 0xdcac8400  ! 1511: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xdac689e0  ! 1512: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r13
	.word 0xdaaf8e80  ! 1513: STBA_R	stba	%r13, [%r30 + %r0] 0x74
	.word 0xdad66000  ! 1514: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1515: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded74e80  ! 1516: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r15
	.word 0xde9ce000  ! 1517: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0xdea46000  ! 1518: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xd485c4a0  ! 1519: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r10
	.word 0xdea6c9e0  ! 1520: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	mov	0x3d8, %r21
	.word 0xdeb42000  ! 1522: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 1523: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r27
	.word 0xdeb42000  ! 1525: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0xde8ca000  ! 1526: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0xdca78e60  ! 1527: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	.word 0xdc9ca000  ! 1528: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r14
	.word 0xdcf40400  ! 1529: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	mov	0x40, %r26
	.word 0xd0bfce40  ! 1531: STDA_R	stda	%r8, [%r31 + %r0] 0x72
	.word 0xd2b4c400  ! 1532: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xd09c8400  ! 1533: LDDA_R	ldda	[%r18, %r0] 0x20, %r8
	.word 0xd0d4a000  ! 1534: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	.word 0xd0b4c400  ! 1535: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0xd2b4c400  ! 1536: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	mov	0x68, %r18
	mov	0x7e8, %r23
	.word 0xd0ac0400  ! 1539: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	.word 0xd0f46000  ! 1540: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	mov	0x78, %r25
	.word 0x87802020  ! 1542: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1543: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r25
	mov	0x8, %r19
	.word 0xd0d7e000  ! 1546: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xdaac8400  ! 1547: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	mov	0x7c0, %r22
	.word 0xdadf2000  ! 1549: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0xdadf6000  ! 1550: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xd2d7ce80  ! 1551: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r9
	.word 0xd2d72000  ! 1552: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xd4bf4e80  ! 1553: STDA_R	stda	%r10, [%r29 + %r0] 0x74
	.word 0xdec689e0  ! 1554: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r15
	.word 0xde972000  ! 1555: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0xde9f6000  ! 1556: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	mov	0x3e0, %r20
	.word 0xded76000  ! 1558: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0xd6af0e80  ! 1559: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	.word 0xd6cf2000  ! 1560: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	mov	0x50, %r25
	mov	0x3e8, %r21
	mov	0x58, %r18
	.word 0xded74e60  ! 1564: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r15
	mov	0x60, %r18
	.word 0x87802020  ! 1566: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea4e000  ! 1567: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	mov	0x7f8, %r23
	.word 0xd2d78e80  ! 1569: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r9
	.word 0xd69649e0  ! 1570: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r11
	.word 0xd69ca000  ! 1571: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r11
	.word 0xd6b42000  ! 1572: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0xd6bfce60  ! 1573: STDA_R	stda	%r11, [%r31 + %r0] 0x73
	mov	0x18, %r24
	mov	0x68, %r17
	.word 0x87802025  ! 1576: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 1577: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r24
	mov	0x48, %r27
	.word 0x87802072  ! 1580: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1581: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6aca000  ! 1582: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	mov	0x78, %r19
	.word 0xd6dce000  ! 1584: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0xd0be09e0  ! 1585: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0xd6a70e60  ! 1586: STWA_R	stwa	%r11, [%r28 + %r0] 0x73
	.word 0xd0f74e60  ! 1587: STXA_R	stxa	%r8, [%r29 + %r0] 0x73
	.word 0xdcc40400  ! 1588: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	.word 0xdcb4e000  ! 1589: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xdca4e000  ! 1590: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0xd4bec9e0  ! 1591: STDA_R	stda	%r10, [%r27 + %r0] 0x4f
	.word 0x8780204f  ! 1592: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1593: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc974e60  ! 1594: LDUHA_R	lduha	[%r29, %r0] 0x73, %r14
	mov	0x38, %r17
	.word 0xd0df0e60  ! 1596: LDXA_R	ldxa	[%r28, %r0] 0x73, %r8
	mov	0x3e0, %r23
	mov	0x78, %r16
	.word 0xd0a46000  ! 1599: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0f4e000  ! 1600: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	mov	0x3c8, %r22
	.word 0x87802020  ! 1602: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b74e60  ! 1603: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	.word 0xdaa649e0  ! 1604: STWA_R	stwa	%r13, [%r25 + %r0] 0x4f
	.word 0xd8ae09e0  ! 1605: STBA_R	stba	%r12, [%r24 + %r0] 0x4f
	.word 0xd8d42000  ! 1606: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0xd4bf8e60  ! 1607: STDA_R	stda	%r10, [%r30 + %r0] 0x73
	.word 0x8780204f  ! 1608: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r18
	.word 0xd4cea000  ! 1610: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r10
	.word 0xd6d78e80  ! 1611: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r11
	.word 0xdeaf8e60  ! 1612: STBA_R	stba	%r15, [%r30 + %r0] 0x73
	mov	0x7e8, %r21
	.word 0xde8ee000  ! 1614: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r15
	mov	0x3e0, %r21
	.word 0x87802020  ! 1616: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded46000  ! 1617: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	.word 0xdef4a000  ! 1618: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xdebc6000  ! 1620: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	mov	0x60, %r18
	.word 0x87802072  ! 1622: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4d7ce80  ! 1623: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r10
	.word 0x87802020  ! 1624: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f74e60  ! 1625: STXA_R	stxa	%r8, [%r29 + %r0] 0x73
	.word 0x87802020  ! 1626: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0dc6000  ! 1627: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	mov	0x7f0, %r21
	mov	0x7c0, %r20
	.word 0xd6d544a0  ! 1630: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r11
	.word 0xd08f4e80  ! 1631: LDUBA_R	lduba	[%r29, %r0] 0x74, %r8
	mov	0x3d8, %r22
	.word 0x87802072  ! 1633: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdade49e0  ! 1634: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r13
	.word 0xda87e000  ! 1635: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	mov	0x38, %r27
	mov	0x18, %r18
	.word 0xdaa7e000  ! 1638: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 1639: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda952000  ! 1640: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r13
	.word 0xde94c400  ! 1641: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	.word 0x8780204f  ! 1642: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a78e60  ! 1643: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	.word 0xd4a62000  ! 1644: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 1645: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r24
	.word 0xd0cf8e40  ! 1647: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r8
	mov	0x18, %r26
	.word 0xd0946000  ! 1649: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0x87802073  ! 1650: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r19
	.word 0xd0af6000  ! 1652: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1653: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8df4e40  ! 1654: LDXA_R	ldxa	[%r29, %r0] 0x72, %r12
	.word 0xd8f46000  ! 1655: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	mov	0x7f8, %r22
	mov	0x7d8, %r20
	.word 0x8780204f  ! 1658: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc87ce60  ! 1659: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r14
	.word 0x87802025  ! 1660: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd09e09e0  ! 1661: LDDA_R	ldda	[%r24, %r0] 0x4f, %r8
	mov	0x30, %r24
	.word 0x87802073  ! 1663: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd09fe000  ! 1664: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	mov	0x3d8, %r22
	.word 0xd08fe000  ! 1666: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	.word 0x87802074  ! 1667: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 1668: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0d56000  ! 1669: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r8
	.word 0xd2b78e60  ! 1670: STHA_R	stha	%r9, [%r30 + %r0] 0x73
	mov	0x7f0, %r21
	mov	0x70, %r17
	.word 0xd0a74e80  ! 1673: STWA_R	stwa	%r8, [%r29 + %r0] 0x74
	mov	0x8, %r17
	.word 0xd0d5c4a0  ! 1675: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r8
	.word 0x87802020  ! 1676: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cc0400  ! 1677: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	mov	0x7d8, %r20
	.word 0x87802073  ! 1679: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 1680: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcdf8e80  ! 1681: LDXA_R	ldxa	[%r30, %r0] 0x74, %r14
	.word 0xdcc7e000  ! 1682: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcdf6000  ! 1683: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	mov	0x30, %r26
	.word 0xdcb7a000  ! 1685: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xdcafe000  ! 1686: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdc8fa000  ! 1687: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdc9fe000  ! 1688: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0x87802020  ! 1689: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcaca000  ! 1690: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xd6ad84a0  ! 1691: STBA_R	stba	%r11, [%r22 + %r0] 0x25
	.word 0xd6f4a000  ! 1692: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	.word 0xd6ac2000  ! 1693: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 1694: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 1695: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1696: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c609e0  ! 1697: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r12
	.word 0xd0afce40  ! 1698: STBA_R	stba	%r8, [%r31 + %r0] 0x72
	.word 0xdef6c9e0  ! 1699: STXA_R	stxa	%r15, [%r27 + %r0] 0x4f
	mov	0x68, %r17
	mov	0x38, %r16
	.word 0xdeace000  ! 1702: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xdcc609e0  ! 1704: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r14
	.word 0xdcf504a0  ! 1705: STXA_R	stxa	%r14, [%r20 + %r0] 0x25
	.word 0x8780204f  ! 1706: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2ac8400  ! 1707: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0x87802072  ! 1708: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2cf2000  ! 1709: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r9
	mov	0x3c0, %r23
	mov	0x7c0, %r22
	mov	0x20, %r24
	mov	0x78, %r18
	.word 0x87802020  ! 1714: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b7ce40  ! 1715: STHA_R	stha	%r8, [%r31 + %r0] 0x72
	mov	0x30, %r26
	.word 0xd09c2000  ! 1717: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r8
	.word 0xdecf8e60  ! 1718: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r15
	.word 0xdebc6000  ! 1719: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xded46000  ! 1720: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	mov	0x68, %r19
	.word 0xdeac2000  ! 1722: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0xdecca000  ! 1724: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	.word 0xd8bc0400  ! 1725: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xded544a0  ! 1726: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r15
	.word 0xdef5c4a0  ! 1727: STXA_R	stxa	%r15, [%r23 + %r0] 0x25
	.word 0xd6f5c4a0  ! 1728: STXA_R	stxa	%r11, [%r23 + %r0] 0x25
	.word 0xd0a4c400  ! 1729: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xdcbf8e40  ! 1730: STDA_R	stda	%r14, [%r30 + %r0] 0x72
	.word 0xdcb42000  ! 1731: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xdcf42000  ! 1732: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 1733: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r18
	.word 0xd6b78e80  ! 1735: STHA_R	stha	%r11, [%r30 + %r0] 0x74
	.word 0xd8b7ce40  ! 1736: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	mov	0x3d0, %r23
	mov	0x3e0, %r23
	.word 0xdaccc400  ! 1739: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r13
	.word 0x87802073  ! 1740: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda8fe000  ! 1741: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xdab7a000  ! 1742: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xd887ce80  ! 1743: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r12
	.word 0xdccfce80  ! 1744: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r14
	mov	0x3f8, %r20
	.word 0x87802020  ! 1746: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1747: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc9e6000  ! 1748: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r14
	.word 0xdccee000  ! 1749: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r14
	.word 0xd6b504a0  ! 1750: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	mov	0x28, %r18
	.word 0xdeaf0e40  ! 1752: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	.word 0x87802072  ! 1753: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b649e0  ! 1754: STHA_R	stha	%r9, [%r25 + %r0] 0x4f
	.word 0xd2b7e000  ! 1755: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 1756: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8d78e40  ! 1757: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r12
	mov	0x30, %r17
	.word 0xd8a76000  ! 1759: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	mov	0x7c8, %r23
	.word 0xdebf4e40  ! 1761: STDA_R	stda	%r15, [%r29 + %r0] 0x72
	.word 0x87802020  ! 1762: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdebca000  ! 1764: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xde8c2000  ! 1765: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	mov	0x0, %r27
	.word 0xde9c6000  ! 1767: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0xde8ce000  ! 1768: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	.word 0xd286c9e0  ! 1769: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r9
	.word 0xda9f8e40  ! 1770: LDDA_R	ldda	[%r30, %r0] 0x72, %r13
	.word 0xdabc6000  ! 1771: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	mov	0x18, %r27
	.word 0xd4d78e40  ! 1773: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r10
	.word 0xd48ca000  ! 1774: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r10
	.word 0xd8af8e60  ! 1775: STBA_R	stba	%r12, [%r30 + %r0] 0x73
	.word 0x87802074  ! 1776: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd88e49e0  ! 1777: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r12
	.word 0xda878e80  ! 1778: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r13
	.word 0xdab7e000  ! 1779: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1780: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa4a000  ! 1781: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xdab74e40  ! 1782: STHA_R	stha	%r13, [%r29 + %r0] 0x72
	.word 0xdaf7ce80  ! 1783: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	.word 0xdad42000  ! 1784: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r13
	mov	0x10, %r27
	.word 0x87802020  ! 1786: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8ca000  ! 1787: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r13
	.word 0xdaf4e000  ! 1788: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xdac46000  ! 1789: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r13
	.word 0x87802072  ! 1790: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa7a000  ! 1791: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1792: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac42000  ! 1793: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0xda94a000  ! 1794: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	mov	0x18, %r19
	.word 0xdc8c4400  ! 1796: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0x87802025  ! 1797: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd49c4400  ! 1798: LDDA_R	ldda	[%r17, %r0] 0x20, %r10
	mov	0x0, %r19
	.word 0xd4ad6000  ! 1800: STBA_I	stba	%r10, [%r21 + 0x0000] %asi
	mov	0x38, %r17
	.word 0x87802073  ! 1802: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde9d84a0  ! 1803: LDDA_R	ldda	[%r22, %r0] 0x25, %r15
	mov	0x40, %r16
	mov	0x60, %r16
	.word 0xd4a649e0  ! 1806: STWA_R	stwa	%r10, [%r25 + %r0] 0x4f
	.word 0xd4a76000  ! 1807: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	mov	0x18, %r27
	.word 0x87802020  ! 1809: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f4e000  ! 1810: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 1811: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1812: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b4a000  ! 1813: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0xd4ac2000  ! 1814: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 1815: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4ae6000  ! 1816: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0xd4a62000  ! 1817: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	.word 0xd4a66000  ! 1818: STWA_I	stwa	%r10, [%r25 + 0x0000] %asi
	.word 0x87802073  ! 1819: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d8, %r20
	.word 0x87802074  ! 1821: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd48fe000  ! 1822: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xd6c48400  ! 1823: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	.word 0x87802074  ! 1824: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b78e60  ! 1825: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	.word 0xd487a000  ! 1826: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	.word 0xd49fe000  ! 1827: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	mov	0x50, %r26
	.word 0xd0d78e40  ! 1829: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r8
	mov	0x48, %r19
	.word 0xde9f8e60  ! 1831: LDDA_R	ldda	[%r30, %r0] 0x73, %r15
	.word 0xd4944400  ! 1832: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	mov	0x3d0, %r20
	.word 0xd8af4e80  ! 1834: STBA_R	stba	%r12, [%r29 + %r0] 0x74
	.word 0x87802020  ! 1835: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8aca000  ! 1836: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0xd8dce000  ! 1837: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	.word 0xdab40400  ! 1838: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0x87802073  ! 1839: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdac7e000  ! 1840: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xdcc504a0  ! 1841: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r14
	.word 0x87802073  ! 1842: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r19
	mov	0x50, %r18
	.word 0xdc876000  ! 1845: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	mov	0x30, %r24
	.word 0xdccf2000  ! 1847: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0x87802073  ! 1848: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb72000  ! 1849: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1850: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r27
	mov	0x3d8, %r20
	mov	0x18, %r26
	.word 0xde8f0e80  ! 1854: LDUBA_R	lduba	[%r28, %r0] 0x74, %r15
	.word 0xd0be09e0  ! 1855: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0xd0dc2000  ! 1856: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	ta	T_CHANGE_PRIV	! macro
	.word 0xd0bc2000  ! 1858: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	.word 0xdaaf8e60  ! 1859: STBA_R	stba	%r13, [%r30 + %r0] 0x73
	.word 0xd6a74e40  ! 1860: STWA_R	stwa	%r11, [%r29 + %r0] 0x72
	.word 0xd6a42000  ! 1861: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xd8cf4e40  ! 1862: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r12
	.word 0xd8cce000  ! 1863: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r12
	.word 0xd0a689e0  ! 1864: STWA_R	stwa	%r8, [%r26 + %r0] 0x4f
	.word 0xd0b4a000  ! 1865: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xdeb74e80  ! 1866: STHA_R	stha	%r15, [%r29 + %r0] 0x74
	.word 0x87802020  ! 1867: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedce000  ! 1868: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r15
	.word 0xde9ce000  ! 1869: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 1870: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 1871: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a70e60  ! 1872: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	.word 0xd8ac4400  ! 1873: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xd4a6c9e0  ! 1874: STWA_R	stwa	%r10, [%r27 + %r0] 0x4f
	.word 0xd28f4e60  ! 1875: LDUBA_R	lduba	[%r29, %r0] 0x73, %r9
	.word 0xd6bc8400  ! 1876: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xd6876000  ! 1877: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6f72000  ! 1878: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	mov	0x3e0, %r20
	.word 0x87802020  ! 1880: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r20
	.word 0xdcf544a0  ! 1882: STXA_R	stxa	%r14, [%r21 + %r0] 0x25
	.word 0xd2f78e40  ! 1883: STXA_R	stxa	%r9, [%r30 + %r0] 0x72
	.word 0xd0bfce40  ! 1884: STDA_R	stda	%r8, [%r31 + %r0] 0x72
	.word 0xd0f4a000  ! 1885: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	mov	0x7f0, %r23
	mov	0x70, %r26
	.word 0xd0d46000  ! 1888: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r8
	.word 0xd0dce000  ! 1889: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r8
	.word 0xd0bca000  ! 1890: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 1891: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd09e2000  ! 1893: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1894: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09c2000  ! 1895: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r8
	.word 0xd0cca000  ! 1896: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	.word 0xd0842000  ! 1897: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1898: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcc48400  ! 1899: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r14
	mov	0x3d0, %r20
	.word 0xdcbd6000  ! 1901: STDA_I	stda	%r14, [%r21 + 0x0000] %asi
	.word 0xd4b74e40  ! 1902: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	.word 0xd2a70e40  ! 1903: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	mov	0x3c8, %r23
	.word 0xd4b504a0  ! 1905: STHA_R	stha	%r10, [%r20 + %r0] 0x25
	.word 0xd4f56000  ! 1906: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	.word 0xdaa74e40  ! 1907: STWA_R	stwa	%r13, [%r29 + %r0] 0x72
	mov	0x7f0, %r22
	.word 0xdcd689e0  ! 1909: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r14
	.word 0xdcb5a000  ! 1910: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0xdec4c400  ! 1911: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	.word 0xdad78e60  ! 1912: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r13
	mov	0x7f0, %r21
	mov	0x38, %r25
	mov	0x3f0, %r20
	.word 0xd88584a0  ! 1916: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r12
	.word 0xd8ad2000  ! 1917: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	.word 0xdaa40400  ! 1918: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0xd4bf8e40  ! 1919: STDA_R	stda	%r10, [%r30 + %r0] 0x72
	.word 0x87802072  ! 1920: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f504a0  ! 1921: STXA_R	stxa	%r11, [%r20 + %r0] 0x25
	.word 0xd68fe000  ! 1922: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xd6f72000  ! 1923: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6cf6000  ! 1924: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0x87802020  ! 1925: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1926: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf5c4a0  ! 1927: STXA_R	stxa	%r13, [%r23 + %r0] 0x25
	mov	0x7f0, %r21
	mov	0x7c0, %r21
	mov	0x60, %r16
	mov	0x3d0, %r20
	.word 0xdabc6000  ! 1932: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xdc8d44a0  ! 1933: LDUBA_R	lduba	[%r21, %r0] 0x25, %r14
	.word 0xdcbce000  ! 1934: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xd2874e60  ! 1935: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r9
	.word 0xd8ac4400  ! 1936: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xd8f4a000  ! 1937: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	mov	0x7d8, %r21
	mov	0x38, %r27
	.word 0xd6f74e60  ! 1940: STXA_R	stxa	%r11, [%r29 + %r0] 0x73
	.word 0xdedcc400  ! 1941: LDXA_R	ldxa	[%r19, %r0] 0x20, %r15
	.word 0xdebc6000  ! 1942: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xdea4a000  ! 1943: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xd8f44400  ! 1944: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xd08f4e40  ! 1945: LDUBA_R	lduba	[%r29, %r0] 0x72, %r8
	.word 0x87802074  ! 1946: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e8, %r23
	mov	0x78, %r24
	.word 0xd0af2000  ! 1949: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0de09e0  ! 1950: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r8
	.word 0xd4cc8400  ! 1951: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	.word 0xd4a7e000  ! 1952: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd0870e60  ! 1953: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r8
	mov	0x20, %r27
	mov	0x78, %r18
	.word 0x87802074  ! 1956: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd48504a0  ! 1957: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r10
	.word 0x87802020  ! 1958: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f4a000  ! 1959: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 1960: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bf4e60  ! 1961: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	mov	0x7f0, %r22
	mov	0x20, %r25
	.word 0x87802072  ! 1964: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f7e000  ! 1965: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6cf2000  ! 1966: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0x87802025  ! 1967: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 1968: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b76000  ! 1969: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd6b72000  ! 1970: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	mov	0x7c0, %r20
	.word 0xdcf70e40  ! 1972: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	.word 0xdcdfe000  ! 1973: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xdccf6000  ! 1974: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcac0400  ! 1975: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xdcdf2000  ! 1976: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	mov	0x60, %r26
	mov	0x18, %r24
	.word 0xdcc76000  ! 1979: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xdca7a000  ! 1980: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xd89ec9e0  ! 1981: LDDA_R	ldda	[%r27, %r0] 0x4f, %r12
	.word 0x8780204f  ! 1982: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcc70e80  ! 1983: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r14
	.word 0x87802073  ! 1984: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r25
	mov	0x70, %r26
	.word 0xd8cf0e80  ! 1987: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r12
	.word 0x8780204f  ! 1988: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 1989: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1990: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1991: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b72000  ! 1992: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd8f70e80  ! 1993: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	.word 0x8780204f  ! 1994: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6bf4e80  ! 1995: STDA_R	stda	%r11, [%r29 + %r0] 0x74
	.word 0xd6ac0400  ! 1996: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0xd6f66000  ! 1997: STXA_I	stxa	%r11, [%r25 + 0x0000] %asi
	.word 0xd0f48400  ! 1998: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xdea74e80  ! 1999: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	.word 0xdea6e000  ! 2000: STWA_I	stwa	%r15, [%r27 + 0x0000] %asi
	.word 0xdea66000  ! 2001: STWA_I	stwa	%r15, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 2002: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8c6000  ! 2003: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0xdef46000  ! 2004: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xd0df4e40  ! 2005: LDXA_R	ldxa	[%r29, %r0] 0x72, %r8
	.word 0xdec74e40  ! 2006: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r15
	.word 0xdec4e000  ! 2007: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	.word 0xdec4a000  ! 2008: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xd0cc4400  ! 2009: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	.word 0xd0f4e000  ! 2010: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xd084a000  ! 2011: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	mov	0x70, %r18
	.word 0x8780204f  ! 2013: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdecf4e60  ! 2014: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r15
	.word 0x8780204f  ! 2015: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 2016: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0c70e80  ! 2017: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r8
	mov	0x0, %r16
	.word 0xd0976000  ! 2019: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0f7a000  ! 2020: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	mov	0x10, %r16
	.word 0x87802020  ! 2022: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b4a000  ! 2023: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xdaa78e60  ! 2024: STWA_R	stwa	%r13, [%r30 + %r0] 0x73
	.word 0xdabce000  ! 2025: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	mov	0x10, %r27
	.word 0xdaace000  ! 2027: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 2028: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b74e80  ! 2029: STHA_R	stha	%r8, [%r29 + %r0] 0x74
	.word 0xd0cea000  ! 2030: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r8
	.word 0xd0866000  ! 2031: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r8
	.word 0xd6af8e80  ! 2032: STBA_R	stba	%r11, [%r30 + %r0] 0x74
	mov	0x10, %r17
	.word 0xd4d7ce60  ! 2034: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r10
	.word 0xd2ac4400  ! 2035: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xdccf4e40  ! 2036: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r14
	.word 0x87802074  ! 2037: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbfe000  ! 2038: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdaac8400  ! 2039: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	mov	0x7f0, %r21
	.word 0x87802074  ! 2041: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2042: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf42000  ! 2043: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 2044: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r19
	.word 0xd69cc400  ! 2046: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	.word 0xdcc584a0  ! 2047: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r14
	.word 0xd6ac4400  ! 2048: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	mov	0x18, %r17
	.word 0xd6a76000  ! 2050: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6d7a000  ! 2051: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	.word 0xd6d76000  ! 2052: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	.word 0xd6f76000  ! 2053: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6af6000  ! 2054: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 2055: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6de2000  ! 2056: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r11
	.word 0x87802025  ! 2057: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b52000  ! 2058: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	mov	0x78, %r16
	.word 0xd69f0e80  ! 2060: LDDA_R	ldda	[%r28, %r0] 0x74, %r11
	.word 0xdc9d44a0  ! 2061: LDDA_R	ldda	[%r21, %r0] 0x25, %r14
	.word 0xdc956000  ! 2062: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r14
	.word 0xdc852000  ! 2063: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r14
	.word 0xd8df8e80  ! 2064: LDXA_R	ldxa	[%r30, %r0] 0x74, %r12
	.word 0xd8a649e0  ! 2065: STWA_R	stwa	%r12, [%r25 + %r0] 0x4f
	mov	0x30, %r25
	mov	0x10, %r18
	.word 0xdcb48400  ! 2068: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xdcc5a000  ! 2069: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r14
	.word 0xdcbda000  ! 2070: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	.word 0xdccd6000  ! 2071: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r14
	.word 0xdaafce80  ! 2072: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	.word 0xdad56000  ! 2073: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r13
	.word 0x87802072  ! 2074: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf72000  ! 2075: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xd8c7ce60  ! 2076: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r12
	.word 0x87802020  ! 2077: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb7ce40  ! 2078: STHA_R	stha	%r15, [%r31 + %r0] 0x72
	.word 0xde9ce000  ! 2079: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0xde8c2000  ! 2080: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	.word 0xde8ca000  ! 2081: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0xda9d84a0  ! 2082: LDDA_R	ldda	[%r22, %r0] 0x25, %r13
	.word 0xda9c2000  ! 2083: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	mov	0x20, %r16
	.word 0xd4df8e60  ! 2085: LDXA_R	ldxa	[%r30, %r0] 0x73, %r10
	.word 0xdc9fce80  ! 2086: LDDA_R	ldda	[%r31, %r0] 0x74, %r14
	.word 0x87802072  ! 2087: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf7a000  ! 2088: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x3c8, %r21
	mov	0x38, %r16
	.word 0xd4d44400  ! 2091: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0xd4f7a000  ! 2092: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xdccf0e60  ! 2093: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r14
	.word 0xda8c8400  ! 2094: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	.word 0xda8f8e60  ! 2095: LDUBA_R	lduba	[%r30, %r0] 0x73, %r13
	mov	0x7e0, %r20
	mov	0x30, %r19
	mov	0x68, %r16
	.word 0xdabf2000  ! 2099: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xdacfe000  ! 2100: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0x87802072  ! 2101: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 2102: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 2103: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7e8, %r23
	.word 0xdcafce40  ! 2105: STBA_R	stba	%r14, [%r31 + %r0] 0x72
	mov	0x48, %r19
	mov	0x8, %r18
	.word 0xd0f74e60  ! 2108: STXA_R	stxa	%r8, [%r29 + %r0] 0x73
	.word 0xd0cf2000  ! 2109: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0xd0af6000  ! 2110: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	mov	0x8, %r17
	.word 0xded70e80  ! 2112: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r15
	mov	0x28, %r19
	.word 0xde87a000  ! 2114: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xdadf4e80  ! 2115: LDXA_R	ldxa	[%r29, %r0] 0x74, %r13
	.word 0xdac7e000  ! 2116: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xda972000  ! 2117: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	mov	0x3c8, %r21
	.word 0xda9fa000  ! 2119: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0x87802074  ! 2120: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r27
	.word 0xd6f74e60  ! 2122: STXA_R	stxa	%r11, [%r29 + %r0] 0x73
	.word 0xd6a7e000  ! 2123: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	mov	0x60, %r17
	.word 0xd6bfa000  ! 2125: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xdcbdc4a0  ! 2126: STDA_R	stda	%r14, [%r23 + %r0] 0x25
	.word 0x87802025  ! 2127: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 2128: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc9f6000  ! 2129: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	mov	0x70, %r24
	.word 0xd4c78e80  ! 2131: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r10
	.word 0xd48fe000  ! 2132: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	mov	0x7e8, %r23
	.word 0xd4b48400  ! 2134: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd4f72000  ! 2135: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd2b4c400  ! 2136: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xd2f7e000  ! 2137: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd2cfa000  ! 2138: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	.word 0x87802073  ! 2139: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2140: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a7ce40  ! 2141: STWA_R	stwa	%r12, [%r31 + %r0] 0x72
	.word 0xdedfce40  ! 2142: LDXA_R	ldxa	[%r31, %r0] 0x72, %r15
	mov	0x3d8, %r23
	.word 0x87802073  ! 2144: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde872000  ! 2145: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xd6b544a0  ! 2146: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	.word 0xd6d76000  ! 2147: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	mov	0x20, %r26
	mov	0x60, %r26
	.word 0xd687a000  ! 2150: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	mov	0x3e0, %r21
	mov	0x18, %r26
	mov	0x3d8, %r20
	mov	0x7f8, %r23
	mov	0x3f0, %r22
	.word 0xdacf4e60  ! 2156: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r13
	.word 0xdad72000  ! 2157: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0xd8870e40  ! 2158: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r12
	mov	0x3c0, %r20
	.word 0xd8bfa000  ! 2160: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xdcb70e40  ! 2161: STHA_R	stha	%r14, [%r28 + %r0] 0x72
	.word 0xd6acc400  ! 2162: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xdaf504a0  ! 2163: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	mov	0x3f0, %r22
	.word 0x87802020  ! 2165: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r21
	.word 0x87802072  ! 2167: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda9f2000  ! 2168: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	mov	0x18, %r16
	.word 0xdaf7e000  ! 2170: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0xdaf7a000  ! 2172: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdabd44a0  ! 2173: STDA_R	stda	%r13, [%r21 + %r0] 0x25
	.word 0x8780204f  ! 2174: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9ea000  ! 2175: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r13
	mov	0x7c0, %r20
	.word 0xd8f74e40  ! 2177: STXA_R	stxa	%r12, [%r29 + %r0] 0x72
	mov	0x7e0, %r20
	.word 0xd8ae2000  ! 2179: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xdac74e80  ! 2181: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r13
	.word 0x8780204f  ! 2182: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e0, %r22
	.word 0xd6ac0400  ! 2184: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0xd6ce2000  ! 2185: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	mov	0x28, %r17
	mov	0x7e0, %r23
	mov	0x18, %r19
	.word 0xd4948400  ! 2189: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	mov	0x20, %r18
	.word 0xdcd74e40  ! 2191: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r14
	.word 0xd4a44400  ! 2192: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xd4878e40  ! 2193: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r10
	.word 0xd0970e40  ! 2194: LDUHA_R	lduha	[%r28, %r0] 0x72, %r8
	.word 0xdabd44a0  ! 2195: STDA_R	stda	%r13, [%r21 + %r0] 0x25
	mov	0x7d0, %r23
	mov	0x50, %r18
	.word 0xdaa6e000  ! 2198: STWA_I	stwa	%r13, [%r27 + 0x0000] %asi
	mov	0x7d0, %r20
	.word 0xd4cc4400  ! 2200: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r10
	.word 0x8780204f  ! 2201: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6d4c400  ! 2202: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	.word 0x87802072  ! 2203: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r25
	mov	0x38, %r24
	mov	0x70, %r17
	.word 0xd0bec9e0  ! 2207: STDA_R	stda	%r8, [%r27 + %r0] 0x4f
	mov	0x3d8, %r20
	.word 0x87802072  ! 2209: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 2210: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2c7ce80  ! 2211: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r9
	.word 0xd2ad44a0  ! 2212: STBA_R	stba	%r9, [%r21 + %r0] 0x25
	.word 0xd2a7e000  ! 2213: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xdeb544a0  ! 2214: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	.word 0x87802073  ! 2215: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r26
	mov	0x58, %r25
	.word 0x87802025  ! 2218: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2219: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeafa000  ! 2220: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xd8a78e40  ! 2221: STWA_R	stwa	%r12, [%r30 + %r0] 0x72
	mov	0x28, %r27
	.word 0xd88f2000  ! 2223: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	mov	0x30, %r17
	.word 0xd8976000  ! 2225: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2226: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r24
	mov	0x18, %r24
	.word 0xd0f7ce40  ! 2229: STXA_R	stxa	%r8, [%r31 + %r0] 0x72
	mov	0x20, %r17
	.word 0x87802072  ! 2231: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0a76000  ! 2232: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd4b40400  ! 2233: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0xd4b7e000  ! 2234: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0xd4bfe000  ! 2236: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 2237: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2238: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdccf0e80  ! 2239: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r14
	.word 0xdcbfe000  ! 2240: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdccfe000  ! 2241: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 2242: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd68504a0  ! 2243: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r11
	mov	0x78, %r19
	.word 0x87802025  ! 2245: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2246: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r17
	.word 0xdabd84a0  ! 2248: STDA_R	stda	%r13, [%r22 + %r0] 0x25
	mov	0x7f8, %r22
	.word 0xd08c4400  ! 2250: LDUBA_R	lduba	[%r17, %r0] 0x20, %r8
	mov	0x7d8, %r22
	.word 0x8780204f  ! 2252: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8de89e0  ! 2253: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r12
	.word 0xd8dc4400  ! 2254: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0xd2bf0e80  ! 2255: STDA_R	stda	%r9, [%r28 + %r0] 0x74
	mov	0x0, %r24
	.word 0xd2b6e000  ! 2257: STHA_I	stha	%r9, [%r27 + 0x0000] %asi
	.word 0xd2b66000  ! 2258: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	mov	0x3c8, %r22
	.word 0xd2cee000  ! 2260: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	.word 0xd2c6e000  ! 2261: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r9
	mov	0x20, %r27
	.word 0xd2b66000  ! 2263: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	.word 0xdc944400  ! 2264: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	.word 0xdcb66000  ! 2265: STHA_I	stha	%r14, [%r25 + 0x0000] %asi
	.word 0xdcc6a000  ! 2266: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r14
	.word 0xd2d70e40  ! 2267: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r9
	.word 0x87802020  ! 2268: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad70e40  ! 2269: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r13
	mov	0x50, %r18
	.word 0xdacca000  ! 2271: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	.word 0xd0ad44a0  ! 2272: STBA_R	stba	%r8, [%r21 + %r0] 0x25
	mov	0x7e8, %r23
	.word 0xd0ac6000  ! 2274: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0xd0b4e000  ! 2275: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xd08ce000  ! 2276: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	mov	0x7d8, %r21
	.word 0x8780204f  ! 2278: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 2279: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd085a000  ! 2280: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r8
	.word 0xd0a52000  ! 2281: STWA_I	stwa	%r8, [%r20 + 0x0000] %asi
	mov	0x7c0, %r21
	.word 0xd08d6000  ! 2283: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r8
	mov	0x3e0, %r21
	.word 0xdc8f0e40  ! 2285: LDUBA_R	lduba	[%r28, %r0] 0x72, %r14
	.word 0xdca52000  ! 2286: STWA_I	stwa	%r14, [%r20 + 0x0000] %asi
	.word 0xdc8da000  ! 2287: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r14
	.word 0xd2f78e60  ! 2288: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	mov	0x10, %r27
	mov	0x8, %r27
	mov	0x8, %r17
	.word 0xda878e80  ! 2292: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r13
	.word 0xdcbc8400  ! 2293: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xd8d74e60  ! 2294: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r12
	.word 0xd08c4400  ! 2295: LDUBA_R	lduba	[%r17, %r0] 0x20, %r8
	.word 0x87802074  ! 2296: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb7ce40  ! 2297: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	mov	0x3d0, %r22
	.word 0xdc97ce40  ! 2299: LDUHA_R	lduha	[%r31, %r0] 0x72, %r14
	mov	0x8, %r27
	.word 0xd6f78e60  ! 2301: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	.word 0xd6a76000  ! 2302: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd0bf8e60  ! 2303: STDA_R	stda	%r8, [%r30 + %r0] 0x73
	.word 0xd6f649e0  ! 2304: STXA_R	stxa	%r11, [%r25 + %r0] 0x4f
	.word 0xd8c78e40  ! 2305: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r12
	.word 0xdec4c400  ! 2306: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	mov	0x3e8, %r23
	.word 0xdcce49e0  ! 2308: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r14
	.word 0xdccf0e40  ! 2309: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r14
	.word 0x8780204f  ! 2310: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f70e40  ! 2311: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	.word 0xdacfce80  ! 2312: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r13
	mov	0x3e8, %r21
	.word 0xda9e6000  ! 2314: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r13
	.word 0xda970e40  ! 2315: LDUHA_R	lduha	[%r28, %r0] 0x72, %r13
	.word 0x87802073  ! 2316: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda848400  ! 2317: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r13
	mov	0x10, %r19
	mov	0x3c0, %r23
	.word 0xdaafe000  ! 2320: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xd4af0e40  ! 2321: STBA_R	stba	%r10, [%r28 + %r0] 0x72
	.word 0xdaac8400  ! 2322: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0xdaaf6000  ! 2323: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xdaf7a000  ! 2324: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdaafe000  ! 2325: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xdacf0e60  ! 2326: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r13
	mov	0x20, %r27
	.word 0xdab72000  ! 2328: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	mov	0x58, %r24
	.word 0x87802025  ! 2330: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 2331: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49d84a0  ! 2332: LDDA_R	ldda	[%r22, %r0] 0x25, %r10
	.word 0xd4974e80  ! 2333: LDUHA_R	lduha	[%r29, %r0] 0x74, %r10
	.word 0xd4dfe000  ! 2334: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802020  ! 2335: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r17
	.word 0xd6948400  ! 2337: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	.word 0xde9f4e60  ! 2338: LDDA_R	ldda	[%r29, %r0] 0x73, %r15
	.word 0xded4e000  ! 2339: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	.word 0xde84c400  ! 2340: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0xd6970e40  ! 2341: LDUHA_R	lduha	[%r28, %r0] 0x72, %r11
	mov	0x58, %r17
	mov	0x20, %r19
	.word 0xdcac4400  ! 2344: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	.word 0xdcb4e000  ! 2345: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xdab78e80  ! 2346: STHA_R	stha	%r13, [%r30 + %r0] 0x74
	.word 0xdad70e60  ! 2347: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r13
	.word 0xdea4c400  ! 2348: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	.word 0xd49f4e60  ! 2349: LDDA_R	ldda	[%r29, %r0] 0x73, %r10
	.word 0xdabf4e80  ! 2350: STDA_R	stda	%r13, [%r29 + %r0] 0x74
	mov	0x3c0, %r23
	mov	0x0, %r25
	.word 0xd6c74e40  ! 2353: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r11
	.word 0xde8544a0  ! 2354: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r15
	mov	0x3e8, %r20
	.word 0xdeac2000  ! 2356: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xd887ce80  ! 2357: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r12
	mov	0x60, %r19
	mov	0x48, %r26
	mov	0x3f8, %r20
	.word 0xd2a40400  ! 2361: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	mov	0x3e0, %r20
	mov	0x3c0, %r20
	.word 0xd0ad84a0  ! 2364: STBA_R	stba	%r8, [%r22 + %r0] 0x25
	mov	0x10, %r26
	.word 0x8780204f  ! 2366: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf40400  ! 2367: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	mov	0x58, %r27
	.word 0xd4b7ce80  ! 2369: STHA_R	stha	%r10, [%r31 + %r0] 0x74
	.word 0xd2970e80  ! 2370: LDUHA_R	lduha	[%r28, %r0] 0x74, %r9
	mov	0x7e0, %r21
	mov	0x48, %r26
	mov	0x38, %r17
	.word 0xd2bee000  ! 2374: STDA_I	stda	%r9, [%r27 + 0x0000] %asi
	.word 0xda85c4a0  ! 2375: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r13
	.word 0x87802020  ! 2376: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r26
	.word 0xd4bf4e60  ! 2378: STDA_R	stda	%r10, [%r29 + %r0] 0x73
	.word 0xd2f4c400  ! 2379: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xd2c46000  ! 2380: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	mov	0x40, %r26
	mov	0x3d0, %r21
	.word 0x8780204f  ! 2383: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 2384: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa7ce80  ! 2385: STWA_R	stwa	%r13, [%r31 + %r0] 0x74
	.word 0xd497ce40  ! 2386: LDUHA_R	lduha	[%r31, %r0] 0x72, %r10
	.word 0xd29fce60  ! 2387: LDDA_R	ldda	[%r31, %r0] 0x73, %r9
	.word 0x87802073  ! 2388: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd88e49e0  ! 2389: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r12
	.word 0xdec48400  ! 2390: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	.word 0xde97a000  ! 2391: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	.word 0xdea72000  ! 2392: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xded7e000  ! 2393: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0xd8f689e0  ! 2394: STXA_R	stxa	%r12, [%r26 + %r0] 0x4f
	.word 0xd8af2000  ! 2395: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xd88f2000  ! 2396: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0xd4f689e0  ! 2397: STXA_R	stxa	%r10, [%r26 + %r0] 0x4f
	.word 0xd4f7e000  ! 2398: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4bfe000  ! 2399: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd497e000  ! 2400: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	mov	0x3e8, %r21
	.word 0xd4d7e000  ! 2402: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	mov	0x58, %r16
	mov	0x3e0, %r21
	mov	0x7e0, %r23
	.word 0xd497e000  ! 2406: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	mov	0x40, %r25
	.word 0xd2a48400  ! 2408: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0xdebc0400  ! 2409: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0xda8e89e0  ! 2410: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r13
	.word 0xdacf4e80  ! 2411: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r13
	mov	0x38, %r16
	.word 0xdaf72000  ! 2413: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdaa72000  ! 2414: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xdac7a000  ! 2415: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0x87802074  ! 2416: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa72000  ! 2417: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 2418: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f0, %r22
	.word 0xdad6e000  ! 2420: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r13
	.word 0xd2bd04a0  ! 2421: STDA_R	stda	%r9, [%r20 + %r0] 0x25
	mov	0x8, %r19
	.word 0xda970e40  ! 2423: LDUHA_R	lduha	[%r28, %r0] 0x72, %r13
	.word 0xdabe2000  ! 2424: STDA_I	stda	%r13, [%r24 + 0x0000] %asi
	mov	0x18, %r19
	.word 0xdaa6e000  ! 2426: STWA_I	stwa	%r13, [%r27 + 0x0000] %asi
	.word 0xdade2000  ! 2427: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r13
	.word 0xdabe2000  ! 2428: STDA_I	stda	%r13, [%r24 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xdab66000  ! 2430: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	mov	0x28, %r16
	.word 0xdac6e000  ! 2432: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r13
	mov	0x7e8, %r20
	.word 0x87802073  ! 2434: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r27
	.word 0xdac7a000  ! 2436: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xdad78e60  ! 2437: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r13
	.word 0xd88c4400  ! 2438: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	mov	0x28, %r18
	mov	0x70, %r27
	.word 0xd8dfa000  ! 2441: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	mov	0x7f0, %r20
	.word 0xd2844400  ! 2443: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	mov	0x60, %r24
	.word 0x87802020  ! 2445: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2aca000  ! 2446: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 2447: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2b46000  ! 2449: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x7d8, %r23
	mov	0x7c8, %r20
	.word 0xd0af0e40  ! 2453: STBA_R	stba	%r8, [%r28 + %r0] 0x72
	.word 0xd0d4a000  ! 2454: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	.word 0xd2af8e80  ! 2455: STBA_R	stba	%r9, [%r30 + %r0] 0x74
	mov	0x7c0, %r21
	.word 0xdaa504a0  ! 2457: STWA_R	stwa	%r13, [%r20 + %r0] 0x25
	mov	0x50, %r24
	.word 0xdadc2000  ! 2459: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r13
	.word 0xdacce000  ! 2460: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r13
	.word 0x87802025  ! 2461: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcae09e0  ! 2462: STBA_R	stba	%r14, [%r24 + %r0] 0x4f
	.word 0xd0af8e40  ! 2463: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0x87802025  ! 2464: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r19
	.word 0x87802072  ! 2466: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 2467: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2ac0400  ! 2468: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0xd4cf0e40  ! 2469: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r10
	mov	0x20, %r26
	.word 0xd8be49e0  ! 2471: STDA_R	stda	%r12, [%r25 + %r0] 0x4f
	.word 0xd8976000  ! 2472: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0xd897e000  ! 2473: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	.word 0x87802025  ! 2474: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0840400  ! 2475: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	.word 0xd085a000  ! 2476: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r8
	mov	0x3d0, %r22
	.word 0xd0b78e40  ! 2478: STHA_R	stha	%r8, [%r30 + %r0] 0x72
	.word 0xded70e60  ! 2479: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r15
	.word 0xdad6c9e0  ! 2480: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r13
	.word 0x87802074  ! 2481: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d8, %r21
	.word 0xdaac4400  ! 2483: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2d70e60  ! 2485: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r9
	.word 0xd2a7e000  ! 2486: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	mov	0x48, %r19
	.word 0x87802074  ! 2488: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f76000  ! 2489: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xd2df2000  ! 2490: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xdac40400  ! 2491: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	mov	0x38, %r27
	.word 0xda9fa000  ! 2493: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xdc9f4e80  ! 2494: LDDA_R	ldda	[%r29, %r0] 0x74, %r14
	mov	0x58, %r18
	.word 0x87802072  ! 2496: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf7ce80  ! 2497: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	mov	0x3c0, %r22
	.word 0xdacdc4a0  ! 2499: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r13
	mov	0x70, %r27
	.word 0xdabf6000  ! 2501: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xdaf7e000  ! 2502: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xdaa7a000  ! 2503: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xd09f8e80  ! 2505: LDDA_R	ldda	[%r30, %r0] 0x74, %r8
	.word 0xd0a76000  ! 2506: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd4bf4e40  ! 2507: STDA_R	stda	%r10, [%r29 + %r0] 0x72
	.word 0xdea40400  ! 2508: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0x87802020  ! 2509: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2510: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2511: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd484c400  ! 2513: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	mov	0x58, %r25
	.word 0xd4f56000  ! 2515: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	mov	0x40, %r17
	mov	0x20, %r25
	.word 0xd4d5a000  ! 2518: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r10
	mov	0x3c8, %r20
	.word 0xdcd40400  ! 2520: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	mov	0x28, %r17
	.word 0xdcf52000  ! 2522: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	.word 0xdca5e000  ! 2523: STWA_I	stwa	%r14, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 2524: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0974e60  ! 2525: LDUHA_R	lduha	[%r29, %r0] 0x73, %r8
	.word 0xd6844400  ! 2526: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r11
	.word 0xde8f8e80  ! 2527: LDUBA_R	lduba	[%r30, %r0] 0x74, %r15
	.word 0xdcddc4a0  ! 2528: LDXA_R	ldxa	[%r23, %r0] 0x25, %r14
	.word 0xdc972000  ! 2529: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	.word 0xdcdf2000  ! 2530: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	mov	0x40, %r24
	.word 0xdccfa000  ! 2532: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	mov	0x3c8, %r20
	.word 0xdc8fa000  ! 2534: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xd8bf4e60  ! 2535: STDA_R	stda	%r12, [%r29 + %r0] 0x73
	.word 0xd4afce60  ! 2536: STBA_R	stba	%r10, [%r31 + %r0] 0x73
	.word 0x87802025  ! 2537: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r26
	.word 0xdc874e60  ! 2539: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r14
	.word 0xda9d44a0  ! 2540: LDDA_R	ldda	[%r21, %r0] 0x25, %r13
	.word 0xdc9d04a0  ! 2541: LDDA_R	ldda	[%r20, %r0] 0x25, %r14
	.word 0x87802074  ! 2542: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d0, %r23
	.word 0xdcd7a000  ! 2544: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0xd09e89e0  ! 2545: LDDA_R	ldda	[%r26, %r0] 0x4f, %r8
	mov	0x3f0, %r22
	.word 0xd0bfa000  ! 2547: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0xd0bfe000  ! 2548: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xdace89e0  ! 2549: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r13
	.word 0xda972000  ! 2550: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	mov	0x18, %r19
	.word 0xdadf2000  ! 2552: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	mov	0x7c8, %r23
	mov	0x10, %r27
	.word 0xdaf72000  ! 2555: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	mov	0x50, %r17
	.word 0x87802020  ! 2557: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf4a000  ! 2558: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0xda84a000  ! 2559: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	mov	0x7c0, %r23
	.word 0xdaf4e000  ! 2561: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xdad4e000  ! 2562: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r13
	.word 0xd0b78e40  ! 2563: STHA_R	stha	%r8, [%r30 + %r0] 0x72
	.word 0x87802025  ! 2564: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdacf0e80  ! 2565: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r13
	.word 0xdabd2000  ! 2566: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	.word 0xdaad2000  ! 2567: STBA_I	stba	%r13, [%r20 + 0x0000] %asi
	.word 0xdaf56000  ! 2568: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	.word 0xdab5e000  ! 2569: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0xdecf8e80  ! 2570: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r15
	.word 0xd4a78e60  ! 2571: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	mov	0x7f0, %r20
	.word 0x87802020  ! 2573: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f74e40  ! 2574: STXA_R	stxa	%r8, [%r29 + %r0] 0x72
	mov	0x30, %r17
	.word 0xd08f0e80  ! 2576: LDUBA_R	lduba	[%r28, %r0] 0x74, %r8
	mov	0x7c0, %r22
	.word 0xd08ca000  ! 2578: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0x87802074  ! 2579: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0cf6000  ! 2580: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd0cec9e0  ! 2581: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r8
	.word 0xdc8cc400  ! 2582: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	.word 0xdc9584a0  ! 2583: LDUHA_R	lduha	[%r22, %r0] 0x25, %r14
	.word 0xde9f0e80  ! 2584: LDDA_R	ldda	[%r28, %r0] 0x74, %r15
	mov	0x18, %r26
	.word 0xd09dc4a0  ! 2586: LDDA_R	ldda	[%r23, %r0] 0x25, %r8
	.word 0x87802072  ! 2587: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29d84a0  ! 2588: LDDA_R	ldda	[%r22, %r0] 0x25, %r9
	.word 0xd2f7a000  ! 2589: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 2590: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8940400  ! 2591: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	.word 0xd8cf2000  ! 2592: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0xd0ad84a0  ! 2593: STBA_R	stba	%r8, [%r22 + %r0] 0x25
	.word 0xd09fa000  ! 2594: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	.word 0x87802072  ! 2595: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r17
	mov	0x7c8, %r23
	.word 0xd09f6000  ! 2598: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	mov	0x48, %r25
	mov	0x28, %r27
	.word 0x87802074  ! 2601: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b76000  ! 2602: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 2603: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4b78e80  ! 2604: STHA_R	stha	%r10, [%r30 + %r0] 0x74
	mov	0x7d8, %r20
	.word 0xd294c400  ! 2606: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	.word 0xd2856000  ! 2607: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r9
	.word 0xd6cf4e80  ! 2608: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r11
	.word 0xd89689e0  ! 2609: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r12
	mov	0x3f8, %r21
	.word 0xd68ec9e0  ! 2611: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r11
	.word 0xd6d56000  ! 2612: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r11
	.word 0xd6a5a000  ! 2613: STWA_I	stwa	%r11, [%r22 + 0x0000] %asi
	.word 0xdab649e0  ! 2614: STHA_R	stha	%r13, [%r25 + %r0] 0x4f
	.word 0xdaf5a000  ! 2615: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xd6b4c400  ! 2616: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0x87802020  ! 2617: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bf4e80  ! 2618: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	.word 0xd0cc4400  ! 2619: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	.word 0xdca74e60  ! 2620: STWA_R	stwa	%r14, [%r29 + %r0] 0x73
	.word 0xdac74e80  ! 2621: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r13
	.word 0xd6bf0e60  ! 2622: STDA_R	stda	%r11, [%r28 + %r0] 0x73
	mov	0x58, %r16
	.word 0xd6b48400  ! 2624: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd684a000  ! 2625: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r11
	.word 0xd6b4a000  ! 2626: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xdcf78e80  ! 2627: STXA_R	stxa	%r14, [%r30 + %r0] 0x74
	mov	0x3e8, %r20
	.word 0x87802073  ! 2629: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb7a000  ! 2630: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xdc972000  ! 2631: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	.word 0xdaae89e0  ! 2632: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x50, %r16
	.word 0xd0cf8e80  ! 2635: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r8
	mov	0x8, %r16
	.word 0xd0a72000  ! 2637: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x3e0, %r21
	.word 0xd0b72000  ! 2639: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2640: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r19
	.word 0x87802072  ! 2642: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2a6c9e0  ! 2643: STWA_R	stwa	%r9, [%r27 + %r0] 0x4f
	.word 0xd2d7a000  ! 2644: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2645: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2646: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab74e60  ! 2647: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 2648: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 2649: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r19
	.word 0x87802020  ! 2651: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r22
	.word 0x87802020  ! 2653: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf42000  ! 2654: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0xd085c4a0  ! 2655: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r8
	.word 0x87802020  ! 2656: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c7ce40  ! 2657: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r10
	.word 0xdacc4400  ! 2658: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	.word 0xda8ce000  ! 2659: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	.word 0xda9c2000  ! 2660: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	mov	0x58, %r16
	.word 0xdad4a000  ! 2662: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0xd8cc4400  ! 2663: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r12
	.word 0x87802073  ! 2664: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bd44a0  ! 2665: STDA_R	stda	%r11, [%r21 + %r0] 0x25
	.word 0xd6af6000  ! 2666: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 2667: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r18
	.word 0xd2f48400  ! 2669: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x28, %r18
	.word 0xd2bfa000  ! 2672: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	mov	0x60, %r26
	.word 0xd2b7e000  ! 2674: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2b7a000  ! 2675: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xd0bf4e80  ! 2677: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	mov	0x8, %r25
	.word 0xd6ae89e0  ! 2679: STBA_R	stba	%r11, [%r26 + %r0] 0x4f
	.word 0x87802073  ! 2680: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6af6000  ! 2681: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd4f504a0  ! 2682: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0xd48f2000  ! 2683: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd2adc4a0  ! 2684: STBA_R	stba	%r9, [%r23 + %r0] 0x25
	.word 0xd6afce80  ! 2685: STBA_R	stba	%r11, [%r31 + %r0] 0x74
	.word 0xd697a000  ! 2686: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0xd69fce80  ! 2687: LDDA_R	ldda	[%r31, %r0] 0x74, %r11
	.word 0xd6cdc4a0  ! 2688: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r11
	.word 0x87802072  ! 2689: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2690: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bc8400  ! 2691: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xd8bc2000  ! 2692: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xdcac8400  ! 2693: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xdcbc6000  ! 2694: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0xdcbc2000  ! 2696: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 2697: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r27
	.word 0xd8a4c400  ! 2699: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xd8cfa000  ! 2700: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 2701: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8be6000  ! 2702: STDA_I	stda	%r12, [%r25 + 0x0000] %asi
	.word 0xdcbfce80  ! 2703: STDA_R	stda	%r14, [%r31 + %r0] 0x74
	.word 0xd48f8e60  ! 2704: LDUBA_R	lduba	[%r30, %r0] 0x73, %r10
	.word 0x8780204f  ! 2705: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r26
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd4de2000  ! 2708: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r10
	mov	0x28, %r18
	.word 0xd28fce60  ! 2710: LDUBA_R	lduba	[%r31, %r0] 0x73, %r9
	.word 0xd0acc400  ! 2711: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd8a70e80  ! 2712: STWA_R	stwa	%r12, [%r28 + %r0] 0x74
	.word 0xd8bee000  ! 2713: STDA_I	stda	%r12, [%r27 + 0x0000] %asi
	.word 0xdad7ce60  ! 2714: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r13
	.word 0x87802020  ! 2715: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2716: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad4a000  ! 2717: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0xd0adc4a0  ! 2718: STBA_R	stba	%r8, [%r23 + %r0] 0x25
	.word 0xd094a000  ! 2719: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	.word 0xd0946000  ! 2720: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0x87802025  ! 2721: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaf48400  ! 2722: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	mov	0x28, %r19
	mov	0x18, %r19
	mov	0x40, %r17
	.word 0xda85a000  ! 2726: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r13
	.word 0xda9e89e0  ! 2727: LDDA_R	ldda	[%r26, %r0] 0x4f, %r13
	.word 0x8780204f  ! 2728: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd49dc4a0  ! 2729: LDDA_R	ldda	[%r23, %r0] 0x25, %r10
	.word 0xd0df4e80  ! 2730: LDXA_R	ldxa	[%r29, %r0] 0x74, %r8
	.word 0x87802074  ! 2731: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a7ce80  ! 2732: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0ce49e0  ! 2734: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r8
	.word 0xd08fa000  ! 2735: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0xd8af0e80  ! 2736: STBA_R	stba	%r12, [%r28 + %r0] 0x74
	.word 0x87802020  ! 2737: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a46000  ! 2738: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8d46000  ! 2739: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	.word 0x87802025  ! 2740: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde944400  ! 2741: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	.word 0xde952000  ! 2742: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r15
	.word 0xd4c7ce40  ! 2743: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r10
	.word 0xd6acc400  ! 2744: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0x87802073  ! 2745: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6afe000  ! 2746: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x0, %r19
	.word 0x87802020  ! 2748: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde87ce80  ! 2749: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r15
	.word 0x87802072  ! 2750: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2a4c400  ! 2751: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0xd08ec9e0  ! 2752: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r8
	.word 0xd6ad04a0  ! 2753: STBA_R	stba	%r11, [%r20 + %r0] 0x25
	.word 0xd6bfe000  ! 2754: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd0a70e40  ! 2755: STWA_R	stwa	%r8, [%r28 + %r0] 0x72
	.word 0xd09f2000  ! 2756: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0xd087a000  ! 2757: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0xda8f8e40  ! 2758: LDUBA_R	lduba	[%r30, %r0] 0x72, %r13
	mov	0x70, %r18
	.word 0xd8ac0400  ! 2760: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0x87802074  ! 2761: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r26
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6bfce60  ! 2764: STDA_R	stda	%r11, [%r31 + %r0] 0x73
	.word 0x87802072  ! 2765: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d8, %r23
	.word 0xd69fe000  ! 2767: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	mov	0x68, %r25
	.word 0x87802074  ! 2769: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2770: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdadfce40  ! 2771: LDXA_R	ldxa	[%r31, %r0] 0x72, %r13
	.word 0xdab7a000  ! 2772: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdab7a000  ! 2773: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdeb689e0  ! 2774: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	.word 0xdea40400  ! 2775: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xdebf2000  ! 2776: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xdca70e40  ! 2777: STWA_R	stwa	%r14, [%r28 + %r0] 0x72
	.word 0xd8de49e0  ! 2778: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r12
	mov	0x3e8, %r23
	.word 0x87802020  ! 2780: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2781: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b72000  ! 2782: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xdadcc400  ! 2783: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0x87802073  ! 2784: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdadfe000  ! 2785: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0xd4c44400  ! 2786: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r10
	.word 0x87802072  ! 2787: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4afe000  ! 2788: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	mov	0x18, %r19
	.word 0xd4bfa000  ! 2790: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd8a48400  ! 2791: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	.word 0x87802025  ! 2792: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd895a000  ! 2793: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r12
	.word 0xd8856000  ! 2794: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2795: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b44400  ! 2796: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xd2a7ce40  ! 2797: STWA_R	stwa	%r9, [%r31 + %r0] 0x72
	.word 0xd2c4e000  ! 2798: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xdac78e80  ! 2799: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r13
	mov	0x30, %r25
	mov	0x3c0, %r21
	.word 0xdab42000  ! 2802: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x48, %r18
	.word 0xd08c8400  ! 2805: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0xd6af4e40  ! 2806: STBA_R	stba	%r11, [%r29 + %r0] 0x72
	.word 0xd684e000  ! 2807: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r11
	.word 0xd4ac4400  ! 2808: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xd4ac6000  ! 2809: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	.word 0xd484a000  ! 2810: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r10
	mov	0x3f8, %r21
	mov	0x28, %r24
	.word 0xd4b4a000  ! 2813: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	mov	0x28, %r17
	.word 0x87802020  ! 2815: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2816: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r17
	mov	0x7c0, %r23
	.word 0x87802020  ! 2819: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r18
	mov	0x28, %r25
	.word 0x87802025  ! 2822: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca7ce60  ! 2823: STWA_R	stwa	%r14, [%r31 + %r0] 0x73
	.word 0xdc9da000  ! 2824: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r14
	.word 0xdcb5e000  ! 2825: STHA_I	stha	%r14, [%r23 + 0x0000] %asi
	.word 0xde944400  ! 2826: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	.word 0xde8d6000  ! 2827: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r15
	mov	0x68, %r16
	.word 0x87802020  ! 2829: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8974e60  ! 2830: LDUHA_R	lduha	[%r29, %r0] 0x73, %r12
	.word 0x87802073  ! 2831: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf40400  ! 2832: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xdac544a0  ! 2833: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r13
	.word 0xdadf2000  ! 2834: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0x87802074  ! 2835: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf72000  ! 2836: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdaa7e000  ! 2837: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xdeb70e60  ! 2838: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	.word 0xd08c8400  ! 2839: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0x87802020  ! 2840: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f7ce60  ! 2841: STXA_R	stxa	%r11, [%r31 + %r0] 0x73
	.word 0xd6978e60  ! 2842: LDUHA_R	lduha	[%r30, %r0] 0x73, %r11
	mov	0x18, %r25
	mov	0x7f0, %r21
	.word 0xd8d48400  ! 2845: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0xd8dc2000  ! 2846: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2847: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a48400  ! 2848: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xda8e49e0  ! 2849: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r13
	.word 0xdab42000  ! 2850: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xda942000  ! 2851: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0xdabca000  ! 2852: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdabc4400  ! 2853: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xd4a6c9e0  ! 2854: STWA_R	stwa	%r10, [%r27 + %r0] 0x4f
	.word 0xd6f7ce80  ! 2855: STXA_R	stxa	%r11, [%r31 + %r0] 0x74
	.word 0x87802025  ! 2856: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r18
	.word 0xd695a000  ! 2858: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r11
	mov	0x58, %r17
	.word 0xd8f4c400  ! 2860: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xd0940400  ! 2861: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	.word 0xd6bf4e40  ! 2862: STDA_R	stda	%r11, [%r29 + %r0] 0x72
	.word 0xd6852000  ! 2863: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r11
	mov	0x3f0, %r22
	mov	0x7f0, %r22
	.word 0xde9609e0  ! 2866: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r15
	.word 0x87802073  ! 2867: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0870e60  ! 2868: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r8
	.word 0xd0b72000  ! 2869: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd0d7e000  ! 2870: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xd2adc4a0  ! 2871: STBA_R	stba	%r9, [%r23 + %r0] 0x25
	.word 0xd49fce60  ! 2872: LDDA_R	ldda	[%r31, %r0] 0x73, %r10
	mov	0x68, %r16
	.word 0xd4cf2000  ! 2874: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0x87802025  ! 2875: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6d4c400  ! 2876: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	.word 0xdadcc400  ! 2877: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0x87802072  ! 2878: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8af8e60  ! 2879: STBA_R	stba	%r12, [%r30 + %r0] 0x73
	mov	0x3f8, %r22
	.word 0xd88fa000  ! 2881: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0xd89fe000  ! 2882: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0x87802025  ! 2883: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r26
	.word 0xd885e000  ! 2885: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r12
	mov	0x7e0, %r21
	.word 0xd89d6000  ! 2887: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r12
	.word 0xd8dd6000  ! 2888: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r12
	.word 0xd8ac4400  ! 2889: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	mov	0x70, %r24
	mov	0x48, %r27
	mov	0x58, %r26
	.word 0x87802020  ! 2893: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2894: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde9584a0  ! 2895: LDUHA_R	lduha	[%r22, %r0] 0x25, %r15
	.word 0x8780204f  ! 2896: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bf8e40  ! 2897: STDA_R	stda	%r10, [%r30 + %r0] 0x72
	mov	0x3c0, %r22
	mov	0x3c0, %r21
	mov	0x7c0, %r22
	mov	0x40, %r26
	.word 0xd4878e80  ! 2902: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r10
	.word 0xd4ae2000  ! 2903: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	.word 0x87802025  ! 2904: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbcc400  ! 2905: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdc9da000  ! 2907: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r14
	.word 0xd2c48400  ! 2908: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0x87802072  ! 2909: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r16
	.word 0xd2bf2000  ! 2911: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	mov	0x3e0, %r23
	.word 0xd2d7e000  ! 2913: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xd29f2000  ! 2914: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xdac44400  ! 2915: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r13
	.word 0x87802072  ! 2916: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabf2000  ! 2917: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xdaf72000  ! 2918: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 2919: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e0, %r21
	.word 0xdaae6000  ! 2921: STBA_I	stba	%r13, [%r25 + 0x0000] %asi
	mov	0x7d0, %r21
	mov	0x3d8, %r22
	mov	0x7f0, %r21
	mov	0x30, %r19
	.word 0xd4bc4400  ! 2926: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	mov	0x7c0, %r22
	mov	0x3f0, %r22
	.word 0xd09fce80  ! 2929: LDDA_R	ldda	[%r31, %r0] 0x74, %r8
	.word 0xd096a000  ! 2930: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r8
	mov	0x60, %r24
	.word 0xd8bc0400  ! 2932: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 2933: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd896e000  ! 2934: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r12
	.word 0xd8a6a000  ! 2935: STWA_I	stwa	%r12, [%r26 + 0x0000] %asi
	.word 0xd896e000  ! 2936: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r12
	.word 0xd8df4e60  ! 2937: LDXA_R	ldxa	[%r29, %r0] 0x73, %r12
	.word 0xd8f62000  ! 2938: STXA_I	stxa	%r12, [%r24 + 0x0000] %asi
	.word 0xd8c6e000  ! 2939: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r12
	mov	0x30, %r25
	mov	0x8, %r26
	.word 0xdef78e60  ! 2942: STXA_R	stxa	%r15, [%r30 + %r0] 0x73
	.word 0xdeb544a0  ! 2943: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	mov	0x7d0, %r23
	.word 0xde8e6000  ! 2945: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r15
	.word 0xd2a48400  ! 2946: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0x87802074  ! 2947: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2948: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0d78e80  ! 2949: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r8
	.word 0xd0b70e40  ! 2950: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	mov	0x7d8, %r21
	.word 0xd0cfa000  ! 2952: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0xd0cf6000  ! 2953: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	mov	0x18, %r25
	.word 0x87802020  ! 2955: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r25
	.word 0x87802073  ! 2957: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 2958: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2870e60  ! 2959: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r9
	.word 0xd28f4e80  ! 2960: LDUBA_R	lduba	[%r29, %r0] 0x74, %r9
	mov	0x10, %r24
	mov	0x78, %r16
	.word 0xd2c56000  ! 2963: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r9
	mov	0x7c0, %r20
	.word 0xd2f5a000  ! 2965: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xd2dd2000  ! 2967: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r9
	mov	0x20, %r27
	.word 0xd2d5e000  ! 2969: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r9
	.word 0xd49504a0  ! 2970: LDUHA_R	lduha	[%r20, %r0] 0x25, %r10
	mov	0x3c8, %r23
	.word 0x87802025  ! 2972: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cec9e0  ! 2973: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r10
	.word 0xdef70e80  ! 2974: STXA_R	stxa	%r15, [%r28 + %r0] 0x74
	.word 0x87802072  ! 2975: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b78e80  ! 2976: STHA_R	stha	%r8, [%r30 + %r0] 0x74
	mov	0x3c8, %r20
	.word 0xd0df2000  ! 2978: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	mov	0x28, %r19
	.word 0xd0b7a000  ! 2980: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 2981: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r26
	.word 0xdabe89e0  ! 2983: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	.word 0xdab4e000  ! 2984: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0xdaaca000  ! 2986: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 2987: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda84a000  ! 2988: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	.word 0xd4ad44a0  ! 2989: STBA_R	stba	%r10, [%r21 + %r0] 0x25
	.word 0xd4bfce80  ! 2990: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	.word 0xd0a74e60  ! 2991: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	.word 0xd0a42000  ! 2992: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xdc848400  ! 2993: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	mov	0x3c0, %r22
	.word 0xdcb46000  ! 2995: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xd29fce80  ! 2996: LDDA_R	ldda	[%r31, %r0] 0x74, %r9
	mov	0x78, %r18
	.word 0xd8d40400  ! 2998: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	mov	0x7e8, %r21
	.word 0xd88ce000  ! 3000: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	.word 0xdcb74e80  ! 3001: STHA_R	stha	%r14, [%r29 + %r0] 0x74
	mov	0x38, %r25
	.word 0xd2cfce60  ! 3003: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r9
	.word 0xd48c0400  ! 3004: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	.word 0xdaaec9e0  ! 3005: STBA_R	stba	%r13, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 3006: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a689e0  ! 3007: STWA_R	stwa	%r8, [%r26 + %r0] 0x4f
	.word 0xd0f4a000  ! 3008: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xde9f4e40  ! 3009: LDDA_R	ldda	[%r29, %r0] 0x72, %r15
	.word 0xde94a000  ! 3010: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0xdeb4e000  ! 3011: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	mov	0x3d0, %r21
	.word 0xded42000  ! 3013: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	mov	0x40, %r24
	.word 0xdef4a000  ! 3015: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0xdebc6000  ! 3016: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xdef4a000  ! 3017: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 3018: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x78, %r16
	mov	0x10, %r16
	.word 0xdece6000  ! 3022: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r15
	.word 0xde96a000  ! 3023: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r15
	mov	0x60, %r19
	.word 0xd8bc8400  ! 3025: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xd8de6000  ! 3026: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r12
	mov	0x7c8, %r20
	.word 0xd8d6a000  ! 3028: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r12
	.word 0xdacc4400  ! 3029: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	.word 0x87802025  ! 3030: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r26
	.word 0xdcb544a0  ! 3032: STHA_R	stha	%r14, [%r21 + %r0] 0x25
	.word 0xdec689e0  ! 3033: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r15
	.word 0x87802074  ! 3034: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd28d04a0  ! 3036: LDUBA_R	lduba	[%r20, %r0] 0x25, %r9
	.word 0x87802074  ! 3037: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r26
	.word 0xdebc4400  ! 3039: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0xd29cc400  ! 3040: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	.word 0xd2cf8e80  ! 3041: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r9
	mov	0x3c8, %r20
	mov	0x3e8, %r21
	.word 0xd2d7e000  ! 3044: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xdca689e0  ! 3045: STWA_R	stwa	%r14, [%r26 + %r0] 0x4f
	.word 0x87802072  ! 3046: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcdf2000  ! 3047: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	mov	0x58, %r24
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x60, %r27
	.word 0xd88c4400  ! 3051: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0xd8a76000  ! 3052: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xdcad84a0  ! 3054: STBA_R	stba	%r14, [%r22 + %r0] 0x25
	.word 0xdea7ce40  ! 3055: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	.word 0x87802020  ! 3056: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef46000  ! 3057: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xde9c6000  ! 3058: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0x87802025  ! 3059: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdedc0400  ! 3060: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	.word 0xde852000  ! 3061: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r15
	mov	0x30, %r27
	mov	0x3c8, %r20
	.word 0xdca48400  ! 3064: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xdcf56000  ! 3065: STXA_I	stxa	%r14, [%r21 + 0x0000] %asi
	.word 0xd2970e40  ! 3066: LDUHA_R	lduha	[%r28, %r0] 0x72, %r9
	.word 0x87802020  ! 3067: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6be09e0  ! 3068: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	.word 0xd6a46000  ! 3069: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0xd09f4e40  ! 3070: LDDA_R	ldda	[%r29, %r0] 0x72, %r8
	.word 0x8780204f  ! 3071: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r18
	mov	0x0, %r25
	mov	0x78, %r24
	mov	0x40, %r19
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0be2000  ! 3077: STDA_I	stda	%r8, [%r24 + 0x0000] %asi
	.word 0xd08ee000  ! 3078: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r8
	.word 0xd8f48400  ! 3079: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xd8966000  ! 3080: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r12
	.word 0xdab689e0  ! 3081: STHA_R	stha	%r13, [%r26 + %r0] 0x4f
	.word 0xdab66000  ! 3082: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0xda9e2000  ! 3083: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r13
	.word 0xdaaea000  ! 3084: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	.word 0xdab6a000  ! 3085: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	.word 0xd48e49e0  ! 3086: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r10
	.word 0xd48e2000  ! 3087: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r10
	.word 0xd486e000  ! 3088: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	.word 0xd4aee000  ! 3089: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	.word 0xd4f62000  ! 3090: STXA_I	stxa	%r10, [%r24 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802020  ! 3092: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r27
	.word 0xd4a42000  ! 3094: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0xd4842000  ! 3095: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	.word 0xd484e000  ! 3096: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r10
	.word 0x87802073  ! 3097: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4bfa000  ! 3098: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	mov	0x3e8, %r22
	mov	0x3e0, %r23
	.word 0x87802072  ! 3101: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf6c9e0  ! 3102: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	.word 0xdc8fe000  ! 3103: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xd8940400  ! 3104: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	mov	0x48, %r24
	.word 0xdea689e0  ! 3106: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	.word 0xdecf6000  ! 3107: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0xdea76000  ! 3108: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	mov	0x30, %r25
	mov	0x48, %r27
	.word 0x87802020  ! 3111: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r23
	mov	0x3f0, %r23
	.word 0x87802072  ! 3114: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f8, %r21
	mov	0x20, %r25
	.word 0xd8d5c4a0  ! 3117: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r12
	mov	0x7e8, %r22
	.word 0xd8cf2000  ! 3119: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0xd8d74e80  ! 3120: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r12
	.word 0x87802072  ! 3121: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r26
	.word 0xd2f609e0  ! 3123: STXA_R	stxa	%r9, [%r24 + %r0] 0x4f
	.word 0xd2a7e000  ! 3124: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xdcafce80  ! 3125: STBA_R	stba	%r14, [%r31 + %r0] 0x74
	.word 0x8780204f  ! 3126: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 3127: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3128: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cfce60  ! 3129: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r10
	.word 0xdca78e60  ! 3130: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	.word 0xdcbce000  ! 3131: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xd0bc0400  ! 3132: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0xd8f78e60  ! 3133: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	mov	0x48, %r27
	mov	0x28, %r26
	.word 0xda974e40  ! 3136: LDUHA_R	lduha	[%r29, %r0] 0x72, %r13
	.word 0xdab42000  ! 3137: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xd6b48400  ! 3138: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd4840400  ! 3139: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	.word 0xd8c7ce40  ! 3140: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r12
	.word 0xd0af8e60  ! 3141: STBA_R	stba	%r8, [%r30 + %r0] 0x73
	.word 0xda8f4e60  ! 3142: LDUBA_R	lduba	[%r29, %r0] 0x73, %r13
	.word 0x87802074  ! 3143: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa7e000  ! 3144: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xd2ce89e0  ! 3145: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r9
	.word 0xd6a609e0  ! 3146: STWA_R	stwa	%r11, [%r24 + %r0] 0x4f
	mov	0x58, %r25
	.word 0xd29584a0  ! 3148: LDUHA_R	lduha	[%r22, %r0] 0x25, %r9
	mov	0x10, %r26
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2d7a000  ! 3151: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	mov	0x10, %r27
	.word 0xd2d72000  ! 3153: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	mov	0x48, %r26
	.word 0xd287e000  ! 3155: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2872000  ! 3156: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	mov	0x7e0, %r20
	.word 0xd4bd44a0  ! 3158: STDA_R	stda	%r10, [%r21 + %r0] 0x25
	.word 0xdcaf4e40  ! 3159: STBA_R	stba	%r14, [%r29 + %r0] 0x72
	mov	0x60, %r27
	.word 0xd2bf8e40  ! 3161: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	.word 0xd2a7e000  ! 3162: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xd2cf2000  ! 3163: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r9
	.word 0xd2bfa000  ! 3164: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xdeacc400  ! 3165: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xdcd74e80  ! 3166: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r14
	.word 0x87802074  ! 3167: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacc8400  ! 3168: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r13
	.word 0xdaafa000  ! 3169: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdaa7a000  ! 3170: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xd6bd84a0  ! 3171: STDA_R	stda	%r11, [%r22 + %r0] 0x25
	.word 0x87802073  ! 3172: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 3173: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6cf6000  ! 3174: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd2970e60  ! 3175: LDUHA_R	lduha	[%r28, %r0] 0x73, %r9
	.word 0xd2876000  ! 3176: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2c72000  ! 3177: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xdc9609e0  ! 3178: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r14
	.word 0xdcd70e60  ! 3179: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r14
	.word 0x87802020  ! 3180: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc84a000  ! 3181: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	mov	0x58, %r27
	.word 0xd88cc400  ! 3183: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	.word 0xd0b70e60  ! 3184: STHA_R	stha	%r8, [%r28 + %r0] 0x73
	.word 0xd0b4e000  ! 3185: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xdaacc400  ! 3186: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0xda942000  ! 3187: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0xdacc2000  ! 3188: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xd0c7ce80  ! 3189: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r8
	.word 0xd2bf8e80  ! 3190: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	.word 0xd0f74e80  ! 3191: STXA_R	stxa	%r8, [%r29 + %r0] 0x74
	.word 0x87802020  ! 3192: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc940400  ! 3193: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0xdccce000  ! 3194: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r14
	.word 0xd2cc0400  ! 3195: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r9
	.word 0xd0cf4e40  ! 3196: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	.word 0xd08ce000  ! 3197: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	mov	0x70, %r27
	.word 0xdccf0e40  ! 3199: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r14
	.word 0xdcace000  ! 3200: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	mov	0x8, %r18
	mov	0x8, %r19
	.word 0xdcac6000  ! 3203: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xd0c7ce80  ! 3204: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r8
	.word 0xd0a4a000  ! 3205: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0xd08e49e0  ! 3206: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r8
	.word 0xd6ce49e0  ! 3207: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r11
	.word 0x87802073  ! 3208: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6c76000  ! 3209: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3210: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49dc4a0  ! 3211: LDDA_R	ldda	[%r23, %r0] 0x25, %r10
	.word 0xd4dc2000  ! 3212: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	mov	0x40, %r18
	.word 0xd497ce40  ! 3214: LDUHA_R	lduha	[%r31, %r0] 0x72, %r10
	.word 0xd0a504a0  ! 3215: STWA_R	stwa	%r8, [%r20 + %r0] 0x25
	.word 0x87802025  ! 3216: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3217: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcc78e80  ! 3218: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r14
	.word 0x87802073  ! 3219: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcc72000  ! 3220: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xd68d04a0  ! 3221: LDUBA_R	lduba	[%r20, %r0] 0x25, %r11
	.word 0xd697a000  ! 3222: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0xd6cf4e40  ! 3223: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r11
	mov	0x40, %r24
	.word 0xd6b7a000  ! 3225: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd0df0e80  ! 3226: LDXA_R	ldxa	[%r28, %r0] 0x74, %r8
	.word 0xdeac0400  ! 3227: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xdecfa000  ! 3228: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xdaa74e40  ! 3229: STWA_R	stwa	%r13, [%r29 + %r0] 0x72
	.word 0x87802074  ! 3230: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf76000  ! 3231: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	mov	0x68, %r24
	.word 0xdaaf2000  ! 3233: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xdef44400  ! 3235: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xdea7e000  ! 3236: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xd4d4c400  ! 3237: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	mov	0x7f8, %r21
	.word 0xdc86c9e0  ! 3239: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r14
	.word 0xdeb44400  ! 3240: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	mov	0x3e8, %r22
	.word 0xd8940400  ! 3242: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	.word 0xdca544a0  ! 3243: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0xdebc4400  ! 3244: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0xdcb544a0  ! 3245: STHA_R	stha	%r14, [%r21 + %r0] 0x25
	mov	0x10, %r18
	mov	0x30, %r16
	.word 0xdcdfe000  ! 3248: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 3249: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcb6e000  ! 3250: STHA_I	stha	%r14, [%r27 + 0x0000] %asi
	.word 0xd0b689e0  ! 3251: STHA_R	stha	%r8, [%r26 + %r0] 0x4f
	.word 0xd0de6000  ! 3252: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r8
	.word 0x87802020  ! 3253: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cc2000  ! 3254: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	mov	0x0, %r26
	.word 0xdcd74e60  ! 3256: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r14
	.word 0xdc94a000  ! 3257: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xdca46000  ! 3258: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	mov	0x60, %r24
	.word 0xd2c7ce80  ! 3260: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r9
	.word 0x87802020  ! 3261: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd497ce60  ! 3262: LDUHA_R	lduha	[%r31, %r0] 0x73, %r10
	.word 0xd494e000  ! 3263: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	.word 0xdef78e40  ! 3264: STXA_R	stxa	%r15, [%r30 + %r0] 0x72
	.word 0x8780204f  ! 3265: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 3266: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e0, %r23
	mov	0x20, %r16
	.word 0xdeb52000  ! 3269: STHA_I	stha	%r15, [%r20 + 0x0000] %asi
	.word 0xde9d2000  ! 3270: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r15
	.word 0xd0f48400  ! 3271: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	mov	0x48, %r17
	mov	0x48, %r19
	.word 0xd0d52000  ! 3274: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r8
	mov	0x7f0, %r20
	.word 0xd0be09e0  ! 3276: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0xda870e40  ! 3277: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r13
	.word 0xdabd6000  ! 3278: STDA_I	stda	%r13, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 3279: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab42000  ! 3280: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xda84a000  ! 3281: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	.word 0xd4ad84a0  ! 3282: STBA_R	stba	%r10, [%r22 + %r0] 0x25
	.word 0xdcd6c9e0  ! 3283: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r14
	mov	0x7c8, %r21
	.word 0xdcb4a000  ! 3285: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xdca4e000  ! 3286: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0xdcace000  ! 3288: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	mov	0x8, %r17
	.word 0xdcf46000  ! 3290: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdcd4a000  ! 3291: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	.word 0x87802072  ! 3292: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 3293: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 3294: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf7e000  ! 3295: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcf72000  ! 3296: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdaaf0e80  ! 3297: STBA_R	stba	%r13, [%r28 + %r0] 0x74
	.word 0x87802025  ! 3298: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0c70e60  ! 3299: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r8
	mov	0x18, %r17
	.word 0x8780204f  ! 3301: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0d6e000  ! 3302: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r8
	mov	0x40, %r26
	.word 0xd08d84a0  ! 3304: LDUBA_R	lduba	[%r22, %r0] 0x25, %r8
	mov	0x60, %r26
	mov	0x28, %r16
	mov	0x50, %r24
	.word 0xd0be2000  ! 3308: STDA_I	stda	%r8, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 3309: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08ca000  ! 3310: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0x87802020  ! 3311: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0842000  ! 3312: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r8
	mov	0x3e0, %r21
	.word 0xd09c6000  ! 3314: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r8
	.word 0x87802020  ! 3315: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48c8400  ! 3316: LDUBA_R	lduba	[%r18, %r0] 0x20, %r10
	.word 0xd2f584a0  ! 3317: STXA_R	stxa	%r9, [%r22 + %r0] 0x25
	.word 0xd2b4e000  ! 3318: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	mov	0x3f8, %r22
	.word 0xdc8fce60  ! 3320: LDUBA_R	lduba	[%r31, %r0] 0x73, %r14
	.word 0xdc8ce000  ! 3321: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	.word 0xd2bfce80  ! 3322: STDA_R	stda	%r9, [%r31 + %r0] 0x74
	.word 0xd8bc0400  ! 3323: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0x87802020  ! 3324: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8946000  ! 3325: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	.word 0xd8f4a000  ! 3326: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xd6b44400  ! 3327: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xdad4c400  ! 3328: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xda9c6000  ! 3329: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xda946000  ! 3330: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3331: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0acc400  ! 3332: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xda87ce80  ! 3333: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r13
	.word 0xd2bf0e40  ! 3334: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	.word 0xd28c6000  ! 3335: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0xd2af8e40  ! 3336: STBA_R	stba	%r9, [%r30 + %r0] 0x72
	.word 0xd2f4a000  ! 3337: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0xd29fce40  ! 3338: LDDA_R	ldda	[%r31, %r0] 0x72, %r9
	mov	0x7d8, %r22
	.word 0x87802020  ! 3340: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a4e000  ! 3341: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0xd294a000  ! 3342: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3343: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b44400  ! 3344: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0xd89ca000  ! 3345: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r12
	.word 0x87802072  ! 3346: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8df6000  ! 3347: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	mov	0x3d8, %r23
	.word 0x87802020  ! 3349: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3350: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b72000  ! 3351: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 3352: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbe89e0  ! 3353: STDA_R	stda	%r14, [%r26 + %r0] 0x4f
	mov	0x68, %r25
	.word 0xdaf40400  ! 3355: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 3356: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdac6e000  ! 3357: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r13
	mov	0x20, %r25
	.word 0xdab62000  ! 3359: STHA_I	stha	%r13, [%r24 + 0x0000] %asi
	.word 0x8780204f  ! 3360: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 3361: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r27
	.word 0xd4f649e0  ! 3363: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	.word 0xd4f5c4a0  ! 3364: STXA_R	stxa	%r10, [%r23 + %r0] 0x25
	.word 0xd6f689e0  ! 3365: STXA_R	stxa	%r11, [%r26 + %r0] 0x4f
	mov	0x20, %r27
	.word 0xd6f72000  ! 3367: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	mov	0x68, %r16
	.word 0xd6cfa000  ! 3369: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0xd2b70e40  ! 3370: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	.word 0xd28fe000  ! 3371: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	mov	0x38, %r16
	mov	0x3e0, %r22
	mov	0x38, %r25
	.word 0xdaf48400  ! 3375: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0x87802073  ! 3376: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaafe000  ! 3377: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2af8e80  ! 3379: STBA_R	stba	%r9, [%r30 + %r0] 0x74
	.word 0xd2cfe000  ! 3380: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	.word 0xd2af6000  ! 3381: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xdaafce60  ! 3382: STBA_R	stba	%r13, [%r31 + %r0] 0x73
	.word 0xd4ac4400  ! 3383: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xd68fce80  ! 3384: LDUBA_R	lduba	[%r31, %r0] 0x74, %r11
	.word 0xd686c9e0  ! 3385: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r11
	.word 0xd8be09e0  ! 3386: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	.word 0xd897a000  ! 3387: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	mov	0x8, %r26
	.word 0xd8ac4400  ! 3389: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	mov	0x68, %r16
	.word 0xd897a000  ! 3391: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0xd88f2000  ! 3392: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0xd4ae89e0  ! 3393: STBA_R	stba	%r10, [%r26 + %r0] 0x4f
	mov	0x28, %r17
	.word 0xd6a544a0  ! 3395: STWA_R	stwa	%r11, [%r21 + %r0] 0x25
	.word 0xd6c76000  ! 3396: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd09f0e80  ! 3397: LDDA_R	ldda	[%r28, %r0] 0x74, %r8
	.word 0xd0de49e0  ! 3398: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r8
	.word 0xd2b70e60  ! 3399: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	.word 0xd2afa000  ! 3400: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3401: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2f5c4a0  ! 3403: STXA_R	stxa	%r9, [%r23 + %r0] 0x25
	.word 0xd2c42000  ! 3404: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	mov	0x70, %r17
	.word 0xd2cc2000  ! 3406: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r9
	.word 0xd28c2000  ! 3407: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xd8bf0e60  ! 3408: STDA_R	stda	%r12, [%r28 + %r0] 0x73
	.word 0x87802020  ! 3409: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf74e60  ! 3410: STXA_R	stxa	%r13, [%r29 + %r0] 0x73
	.word 0xdca7ce60  ! 3411: STWA_R	stwa	%r14, [%r31 + %r0] 0x73
	.word 0xdcc42000  ! 3412: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 3413: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc862000  ! 3414: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r14
	.word 0x87802074  ! 3415: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 3416: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdccfe000  ! 3417: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0x87802073  ! 3418: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb72000  ! 3419: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xdc97a000  ! 3420: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	mov	0x38, %r25
	.word 0xdebe09e0  ! 3422: STDA_R	stda	%r15, [%r24 + %r0] 0x4f
	mov	0x3f8, %r21
	.word 0xdad44400  ! 3424: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0xdab76000  ! 3425: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xd297ce40  ! 3426: LDUHA_R	lduha	[%r31, %r0] 0x72, %r9
	.word 0x87802074  ! 3427: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca6c9e0  ! 3428: STWA_R	stwa	%r14, [%r27 + %r0] 0x4f
	.word 0x87802072  ! 3429: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcdf6000  ! 3430: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xdcc72000  ! 3431: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcbfe000  ! 3432: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdaf78e80  ! 3433: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	.word 0x8780204f  ! 3434: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 3435: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabf2000  ! 3436: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xd0bfce80  ! 3437: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	.word 0xd08fe000  ! 3438: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	.word 0xd0d7a000  ! 3439: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0xd8b689e0  ! 3440: STHA_R	stha	%r12, [%r26 + %r0] 0x4f
	.word 0x87802073  ! 3441: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc878e60  ! 3442: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r14
	.word 0xd8b44400  ! 3443: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0xd8a72000  ! 3444: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xd8cfa000  ! 3446: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0x87802073  ! 3447: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa4c400  ! 3448: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	mov	0x28, %r18
	.word 0xdab76000  ! 3450: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdab7a000  ! 3451: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0xdacfa000  ! 3453: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xdabf6000  ! 3454: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	mov	0x28, %r27
	mov	0x40, %r16
	.word 0xdabfe000  ! 3457: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	mov	0x20, %r16
	mov	0x48, %r16
	.word 0xd2c70e60  ! 3460: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r9
	.word 0xd2d504a0  ! 3461: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r9
	.word 0xd8f48400  ! 3462: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xd4878e60  ! 3463: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r10
	.word 0xd4b7e000  ! 3464: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd28f8e40  ! 3465: LDUBA_R	lduba	[%r30, %r0] 0x72, %r9
	.word 0xd297a000  ! 3466: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	.word 0xda9f0e80  ! 3467: LDDA_R	ldda	[%r28, %r0] 0x74, %r13
	.word 0xd0d44400  ! 3468: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r8
	mov	0x7d0, %r22
	.word 0xd0cfe000  ! 3470: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xdaa70e40  ! 3471: STWA_R	stwa	%r13, [%r28 + %r0] 0x72
	mov	0x68, %r19
	mov	0x48, %r18
	.word 0xd6b78e60  ! 3474: STHA_R	stha	%r11, [%r30 + %r0] 0x73
	.word 0xd6a44400  ! 3475: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0xd6afa000  ! 3476: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xdaf504a0  ! 3477: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	.word 0xda9fe000  ! 3478: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xdacfa000  ! 3479: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xde84c400  ! 3480: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	mov	0x7f0, %r20
	.word 0x87802020  ! 3482: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8f0e40  ! 3483: LDUBA_R	lduba	[%r28, %r0] 0x72, %r15
	mov	0x48, %r26
	.word 0xd6f48400  ! 3485: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xdec74e60  ! 3486: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r15
	.word 0xdea4e000  ! 3487: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xdcbf4e60  ! 3488: STDA_R	stda	%r14, [%r29 + %r0] 0x73
	.word 0xdcc4e000  ! 3489: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r14
	.word 0xdcbce000  ! 3490: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xdc94a000  ! 3491: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xdc942000  ! 3492: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	mov	0x3c8, %r20
	mov	0x28, %r19
	.word 0xdc8c2000  ! 3495: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r14
	mov	0x68, %r16
	.word 0xdcf42000  ! 3497: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0xdcc46000  ! 3498: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 3499: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc8c0400  ! 3500: LDUBA_R	lduba	[%r16, %r0] 0x20, %r14
	.word 0xd294c400  ! 3501: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	.word 0x87802025  ! 3502: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0a544a0  ! 3504: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	.word 0xd8b4c400  ! 3505: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0x87802074  ! 3506: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bf2000  ! 3507: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd8f76000  ! 3508: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd89f2000  ! 3509: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0xd2f70e40  ! 3510: STXA_R	stxa	%r9, [%r28 + %r0] 0x72
	.word 0xd2c7ce80  ! 3511: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r9
	mov	0x50, %r19
	.word 0x87802025  ! 3513: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r25
	.word 0xd6cf8e60  ! 3515: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r11
	.word 0xd6f56000  ! 3516: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	.word 0xd8f544a0  ! 3517: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	.word 0xd4874e80  ! 3518: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r10
	.word 0xd4f78e80  ! 3519: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	.word 0xdcb40400  ! 3520: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	mov	0x30, %r18
	.word 0xdcc52000  ! 3522: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r14
	mov	0x58, %r18
	mov	0x7f8, %r22
	.word 0xd88fce60  ! 3525: LDUBA_R	lduba	[%r31, %r0] 0x73, %r12
	.word 0xd29c8400  ! 3526: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	.word 0xd285e000  ! 3527: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r9
	.word 0xd29d2000  ! 3528: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r9
	mov	0x68, %r19
	.word 0xd29d2000  ! 3530: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r9
	mov	0x3f8, %r20
	mov	0x3d8, %r23
	.word 0xd2ad2000  ! 3533: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0xd2bda000  ! 3535: STDA_I	stda	%r9, [%r22 + 0x0000] %asi
	.word 0xd6d4c400  ! 3536: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	mov	0x58, %r19
	mov	0x30, %r26
	mov	0x7e8, %r20
	.word 0xd6dd6000  ! 3540: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r11
	mov	0x10, %r16
	.word 0xd6b52000  ! 3542: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	.word 0xd6c56000  ! 3543: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r11
	.word 0xd695a000  ! 3544: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r11
	.word 0xdcb70e60  ! 3545: STHA_R	stha	%r14, [%r28 + %r0] 0x73
	.word 0xdcada000  ! 3546: STBA_I	stba	%r14, [%r22 + 0x0000] %asi
	.word 0x87802074  ! 3547: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdadf0e80  ! 3548: LDXA_R	ldxa	[%r28, %r0] 0x74, %r13
	.word 0xdacf6000  ! 3549: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xda97a000  ! 3550: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xd2af0e40  ! 3551: STBA_R	stba	%r9, [%r28 + %r0] 0x72
	.word 0xd0bec9e0  ! 3552: STDA_R	stda	%r8, [%r27 + %r0] 0x4f
	.word 0xd8d44400  ! 3553: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	.word 0xded78e80  ! 3554: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r15
	.word 0xd0a74e80  ! 3555: STWA_R	stwa	%r8, [%r29 + %r0] 0x74
	.word 0xd0d76000  ! 3556: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0bf6000  ! 3557: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd09fa000  ! 3558: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	.word 0xd0f76000  ! 3559: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0cfe000  ! 3560: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	mov	0x70, %r19
	.word 0xd0cf0e80  ! 3562: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r8
	mov	0x10, %r24
	mov	0x3d0, %r21
	.word 0xd0af2000  ! 3565: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	mov	0x48, %r19
	mov	0x28, %r18
	mov	0x58, %r27
	mov	0x68, %r24
	.word 0xd0bf6000  ! 3570: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd6944400  ! 3571: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	mov	0x7e0, %r21
	.word 0xd6848400  ! 3573: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	.word 0xda848400  ! 3574: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r13
	.word 0xd29504a0  ! 3575: LDUHA_R	lduha	[%r20, %r0] 0x25, %r9
	.word 0xd287a000  ! 3576: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	mov	0x7d8, %r22
	.word 0xd2ad44a0  ! 3578: STBA_R	stba	%r9, [%r21 + %r0] 0x25
	.word 0x87802074  ! 3579: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bf2000  ! 3580: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0xd28fe000  ! 3582: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	mov	0x18, %r25
	.word 0xd08f4e40  ! 3584: LDUBA_R	lduba	[%r29, %r0] 0x72, %r8
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0b7a000  ! 3586: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0xd0b7a000  ! 3588: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0x87802072  ! 3590: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab48400  ! 3591: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	mov	0x10, %r24
	.word 0xda9fa000  ! 3593: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0x87802074  ! 3594: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r18
	.word 0xd89f4e60  ! 3596: LDDA_R	ldda	[%r29, %r0] 0x73, %r12
	.word 0xd89e09e0  ! 3597: LDDA_R	ldda	[%r24, %r0] 0x4f, %r12
	mov	0x8, %r27
	.word 0xd8f78e40  ! 3599: STXA_R	stxa	%r12, [%r30 + %r0] 0x72
	.word 0x8780204f  ! 3600: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 3601: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8afe000  ! 3602: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd88fa000  ! 3603: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	mov	0x20, %r18
	.word 0x87802073  ! 3605: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bf8e80  ! 3606: STDA_R	stda	%r11, [%r30 + %r0] 0x74
	.word 0xd6cfe000  ! 3607: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0xda978e80  ! 3608: LDUHA_R	lduha	[%r30, %r0] 0x74, %r13
	.word 0x87802025  ! 3609: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda9da000  ! 3610: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r13
	.word 0xdaf52000  ! 3611: STXA_I	stxa	%r13, [%r20 + 0x0000] %asi
	.word 0xdad78e80  ! 3612: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r13
	mov	0x8, %r24
	.word 0xda8d2000  ! 3614: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r13
	.word 0xdab52000  ! 3615: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	.word 0xda8d6000  ! 3616: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r13
	.word 0xd4b78e60  ! 3617: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	.word 0xdabf0e40  ! 3618: STDA_R	stda	%r13, [%r28 + %r0] 0x72
	.word 0xdab56000  ! 3619: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	.word 0xdabda000  ! 3620: STDA_I	stda	%r13, [%r22 + 0x0000] %asi
	.word 0xdabf8e80  ! 3621: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	.word 0xdabd2000  ! 3622: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	.word 0xd8cf0e40  ! 3623: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r12
	.word 0xd885e000  ! 3624: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r12
	.word 0x87802025  ! 3625: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd29e89e0  ! 3626: LDDA_R	ldda	[%r26, %r0] 0x4f, %r9
	.word 0xd8d609e0  ! 3627: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r12
	.word 0x87802020  ! 3628: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b7ce80  ! 3629: STHA_R	stha	%r8, [%r31 + %r0] 0x74
	.word 0xdac7ce40  ! 3630: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r13
	.word 0xde870e80  ! 3631: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r15
	mov	0x18, %r17
	.word 0x87802025  ! 3633: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaa78e40  ! 3634: STWA_R	stwa	%r13, [%r30 + %r0] 0x72
	.word 0xdacd6000  ! 3635: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r13
	.word 0x87802025  ! 3636: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdab5a000  ! 3637: STHA_I	stha	%r13, [%r22 + 0x0000] %asi
	.word 0xd897ce60  ! 3638: LDUHA_R	lduha	[%r31, %r0] 0x73, %r12
	.word 0x87802020  ! 3639: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r22
	.word 0xd88c6000  ! 3641: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	mov	0x7c8, %r21
	.word 0xd8f4a000  ! 3643: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xd487ce80  ! 3644: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r10
	.word 0x87802020  ! 3645: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r27
	mov	0x68, %r24
	.word 0xd6a78e80  ! 3648: STWA_R	stwa	%r11, [%r30 + %r0] 0x74
	.word 0xd6b4e000  ! 3649: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xd0a78e40  ! 3650: STWA_R	stwa	%r8, [%r30 + %r0] 0x72
	mov	0x3d0, %r21
	.word 0xd8adc4a0  ! 3652: STBA_R	stba	%r12, [%r23 + %r0] 0x25
	.word 0xd0840400  ! 3653: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	.word 0xd0a46000  ! 3654: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xd8cf8e60  ! 3655: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r12
	.word 0xd4b6c9e0  ! 3656: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0xd4c46000  ! 3657: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r10
	mov	0x3e0, %r23
	mov	0x38, %r26
	mov	0x20, %r16
	.word 0xd4b4e000  ! 3661: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 3662: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4bde000  ! 3663: STDA_I	stda	%r10, [%r23 + 0x0000] %asi
	.word 0xd4b48400  ! 3664: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd68e49e0  ! 3665: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r11
	.word 0xd494c400  ! 3666: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	.word 0xdcac0400  ! 3667: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0x87802073  ! 3668: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbfa000  ! 3669: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdcbfa000  ! 3670: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xd6bc4400  ! 3671: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 3672: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd69ee000  ! 3673: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r11
	.word 0xd09c0400  ! 3674: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	mov	0x30, %r27
	.word 0xd2b74e80  ! 3676: STHA_R	stha	%r9, [%r29 + %r0] 0x74
	.word 0xd2b62000  ! 3677: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	mov	0x8, %r27
	.word 0xdcf5c4a0  ! 3679: STXA_R	stxa	%r14, [%r23 + %r0] 0x25
	.word 0xda978e40  ! 3680: LDUHA_R	lduha	[%r30, %r0] 0x72, %r13
	.word 0xdadea000  ! 3681: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r13
	mov	0x10, %r24
	.word 0x87802020  ! 3683: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r16
	mov	0x3c8, %r21
	.word 0x8780204f  ! 3686: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2b609e0  ! 3687: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	.word 0xd29ee000  ! 3688: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r9
	mov	0x70, %r25
	mov	0x8, %r26
	.word 0xd2ae2000  ! 3691: STBA_I	stba	%r9, [%r24 + 0x0000] %asi
	.word 0xd0c44400  ! 3692: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r8
	.word 0xd0ce6000  ! 3693: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r8
	.word 0x87802020  ! 3694: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f46000  ! 3695: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 3696: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4bfce80  ! 3697: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	.word 0xd0f70e40  ! 3698: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	.word 0xd0d52000  ! 3699: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r8
	.word 0xd09d6000  ! 3700: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r8
	.word 0xd28cc400  ! 3701: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	mov	0x3e0, %r23
	.word 0x87802025  ! 3703: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 3704: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2af2000  ! 3705: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	mov	0x8, %r18
	.word 0xd2af6000  ! 3707: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	mov	0x3f8, %r23
	.word 0x87802072  ! 3709: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2df6000  ! 3710: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	mov	0x3d8, %r23
	.word 0x87802072  ! 3712: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda9ec9e0  ! 3713: LDDA_R	ldda	[%r27, %r0] 0x4f, %r13
	mov	0x30, %r26
	.word 0xd88c8400  ! 3715: LDUBA_R	lduba	[%r18, %r0] 0x20, %r12
	.word 0xd88fa000  ! 3716: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0x87802020  ! 3717: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8dca000  ! 3718: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	.word 0xd8f4e000  ! 3719: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	mov	0x68, %r17
	.word 0xdca649e0  ! 3721: STWA_R	stwa	%r14, [%r25 + %r0] 0x4f
	.word 0xdcb4c400  ! 3722: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xdc846000  ! 3723: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	.word 0xdcf42000  ! 3724: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0xdcd46000  ! 3725: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	.word 0xd2ac0400  ! 3726: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0xdca4c400  ! 3727: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xded504a0  ! 3728: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r15
	mov	0x3d8, %r23
	.word 0xd4bc8400  ! 3730: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	.word 0xd4f4e000  ! 3731: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 3732: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r19
	.word 0x87802020  ! 3734: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r21
	mov	0x40, %r18
	.word 0x87802025  ! 3737: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd08504a0  ! 3738: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r8
	mov	0x3d8, %r22
	mov	0x40, %r18
	.word 0x87802073  ! 3741: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2978e80  ! 3742: LDUHA_R	lduha	[%r30, %r0] 0x74, %r9
	mov	0x28, %r27
	.word 0xd0bf0e80  ! 3744: STDA_R	stda	%r8, [%r28 + %r0] 0x74
	.word 0x87802020  ! 3745: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f42000  ! 3746: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0xd094a000  ! 3747: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	mov	0x7e8, %r20
	.word 0x8780204f  ! 3749: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b62000  ! 3750: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0xd2d7ce80  ! 3751: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r9
	mov	0x18, %r25
	.word 0xd2cee000  ! 3753: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	.word 0xdac40400  ! 3754: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	mov	0x58, %r18
	mov	0x78, %r25
	.word 0xd89e89e0  ! 3757: LDDA_R	ldda	[%r26, %r0] 0x4f, %r12
	.word 0x87802025  ! 3758: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 3759: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c8, %r22
	mov	0x18, %r16
	.word 0xd2ac4400  ! 3762: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	mov	0x60, %r25
	.word 0xdc974e40  ! 3764: LDUHA_R	lduha	[%r29, %r0] 0x72, %r14
	.word 0xd2cf8e40  ! 3765: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r9
	mov	0x3c0, %r20
	mov	0x40, %r17
	.word 0xd2b6e000  ! 3768: STHA_I	stha	%r9, [%r27 + 0x0000] %asi
	mov	0x3c8, %r20
	.word 0xd2bea000  ! 3770: STDA_I	stda	%r9, [%r26 + 0x0000] %asi
	.word 0xdeb48400  ! 3771: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xdef6a000  ! 3772: STXA_I	stxa	%r15, [%r26 + 0x0000] %asi
	.word 0xdef6a000  ! 3773: STXA_I	stxa	%r15, [%r26 + 0x0000] %asi
	mov	0x30, %r24
	.word 0x87802072  ! 3775: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc8609e0  ! 3776: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r14
	.word 0xdcd7a000  ! 3777: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0xdc844400  ! 3778: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	.word 0xdccf2000  ! 3779: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xd8bc4400  ! 3780: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0x87802073  ! 3781: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 3782: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e0, %r22
	.word 0xd6aec9e0  ! 3784: STBA_R	stba	%r11, [%r27 + %r0] 0x4f
	.word 0xd6f62000  ! 3785: STXA_I	stxa	%r11, [%r24 + 0x0000] %asi
	.word 0x87802072  ! 3786: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f76000  ! 3787: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xd6af2000  ! 3789: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x48, %r16
	.word 0xd6afa000  ! 3791: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x40, %r26
	.word 0xd2b48400  ! 3793: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 3794: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f74e60  ! 3795: STXA_R	stxa	%r10, [%r29 + %r0] 0x73
	.word 0xdec649e0  ! 3796: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r15
	.word 0xd6f48400  ! 3797: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xd6b6a000  ! 3798: STHA_I	stha	%r11, [%r26 + 0x0000] %asi
	.word 0xd6a6e000  ! 3799: STWA_I	stwa	%r11, [%r27 + 0x0000] %asi
	mov	0x7d0, %r20
	.word 0x87802025  ! 3801: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r19
	mov	0x7f8, %r22
	.word 0xd8afce80  ! 3804: STBA_R	stba	%r12, [%r31 + %r0] 0x74
	mov	0x0, %r26
	mov	0x60, %r24
	.word 0xd48c8400  ! 3807: LDUBA_R	lduba	[%r18, %r0] 0x20, %r10
	.word 0xd4ada000  ! 3808: STBA_I	stba	%r10, [%r22 + 0x0000] %asi
	.word 0x8780204f  ! 3809: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bea000  ! 3810: STDA_I	stda	%r10, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 3811: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r18
	mov	0x48, %r16
	.word 0xd494e000  ! 3814: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	.word 0xd2b5c4a0  ! 3815: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	.word 0xd2bce000  ! 3816: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	mov	0x7d0, %r20
	.word 0xd0acc400  ! 3818: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd28f4e60  ! 3819: LDUBA_R	lduba	[%r29, %r0] 0x73, %r9
	.word 0xdcb649e0  ! 3820: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	mov	0x48, %r24
	.word 0xdc8c6000  ! 3822: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r14
	mov	0x78, %r27
	.word 0xdadfce40  ! 3824: LDXA_R	ldxa	[%r31, %r0] 0x72, %r13
	mov	0x0, %r24
	mov	0x68, %r27
	.word 0xdad649e0  ! 3827: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r13
	.word 0xd09e09e0  ! 3828: LDDA_R	ldda	[%r24, %r0] 0x4f, %r8
	.word 0xd09ce000  ! 3829: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r8
	.word 0xd0cc6000  ! 3830: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	.word 0xd09ca000  ! 3831: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	.word 0xdef48400  ! 3832: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0x87802025  ! 3833: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcde89e0  ! 3834: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r14
	.word 0x87802020  ! 3835: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r20
	.word 0xdcdc2000  ! 3837: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r14
	mov	0x28, %r26
	.word 0xdcb4a000  ! 3839: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xdc9c6000  ! 3840: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r14
	.word 0xdcb4e000  ! 3841: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xd4f7ce60  ! 3842: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	.word 0xdef40400  ! 3843: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0xd2b70e80  ! 3844: STHA_R	stha	%r9, [%r28 + %r0] 0x74
	mov	0x7e0, %r22
	.word 0x87802072  ! 3846: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r27
	mov	0x48, %r16
	.word 0x87802020  ! 3849: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f4c400  ! 3850: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0xd6a4c400  ! 3851: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	mov	0x28, %r25
	mov	0x20, %r24
	.word 0xd4a40400  ! 3854: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	.word 0xdaf70e60  ! 3855: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	.word 0xd8974e40  ! 3856: LDUHA_R	lduha	[%r29, %r0] 0x72, %r12
	.word 0xd0a544a0  ! 3857: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	.word 0xd0ae49e0  ! 3858: STBA_R	stba	%r8, [%r25 + %r0] 0x4f
	.word 0xd8a40400  ! 3859: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 3860: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd886e000  ! 3861: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r12
	.word 0xdcdfce80  ! 3862: LDXA_R	ldxa	[%r31, %r0] 0x74, %r14
	.word 0xdc9ee000  ! 3863: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r14
	mov	0x38, %r24
	.word 0xd89f0e60  ! 3865: LDDA_R	ldda	[%r28, %r0] 0x73, %r12
	mov	0x68, %r19
	.word 0x87802020  ! 3867: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r18
	.word 0xd28f4e80  ! 3869: LDUBA_R	lduba	[%r29, %r0] 0x74, %r9
	.word 0x87802020  ! 3870: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc8649e0  ! 3871: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r14
	.word 0xd6de09e0  ! 3872: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r11
	.word 0xd6ac6000  ! 3873: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xd6c46000  ! 3874: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 3875: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0d584a0  ! 3876: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r8
	.word 0xd0be6000  ! 3877: STDA_I	stda	%r8, [%r25 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xde8fce80  ! 3879: LDUBA_R	lduba	[%r31, %r0] 0x74, %r15
	.word 0xde866000  ! 3880: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r15
	.word 0xdcafce80  ! 3881: STBA_R	stba	%r14, [%r31 + %r0] 0x74
	.word 0xdc966000  ! 3882: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r14
	.word 0x87802074  ! 3883: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdccf6000  ! 3884: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xd6bc4400  ! 3885: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	.word 0xd2bf0e40  ! 3886: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	.word 0x87802020  ! 3887: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d42000  ! 3888: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0xd8af4e60  ! 3889: STBA_R	stba	%r12, [%r29 + %r0] 0x73
	.word 0xdc8d04a0  ! 3890: LDUBA_R	lduba	[%r20, %r0] 0x25, %r14
	.word 0xd6b544a0  ! 3891: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	.word 0x87802074  ! 3892: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6df0e60  ! 3893: LDXA_R	ldxa	[%r28, %r0] 0x73, %r11
	.word 0xd8b609e0  ! 3894: STHA_R	stha	%r12, [%r24 + %r0] 0x4f
	.word 0xd8bf2000  ! 3895: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd8af2000  ! 3896: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xd8bfe000  ! 3897: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd8a7a000  ! 3898: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd2bf8e80  ! 3899: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	.word 0xd2d40400  ! 3900: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	.word 0xd2876000  ! 3901: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xdebf4e40  ! 3902: STDA_R	stda	%r15, [%r29 + %r0] 0x72
	.word 0xd8dd04a0  ! 3903: LDXA_R	ldxa	[%r20, %r0] 0x25, %r12
	.word 0xd4f689e0  ! 3904: STXA_R	stxa	%r10, [%r26 + %r0] 0x4f
	.word 0xdecfce60  ! 3905: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r15
	mov	0x3f8, %r20
	.word 0xdebf6000  ! 3907: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xdaa7ce60  ! 3908: STWA_R	stwa	%r13, [%r31 + %r0] 0x73
	.word 0xd6878e80  ! 3909: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r11
	.word 0xdaf609e0  ! 3910: STXA_R	stxa	%r13, [%r24 + %r0] 0x4f
	mov	0x7c0, %r23
	mov	0x7c8, %r22
	.word 0xdaf7e000  ! 3913: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xd4cfce40  ! 3915: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r10
	.word 0xd69fce40  ! 3916: LDDA_R	ldda	[%r31, %r0] 0x72, %r11
	.word 0x87802073  ! 3917: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e0, %r20
	.word 0xd697e000  ! 3919: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0xd6b76000  ! 3920: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd4cf0e80  ! 3921: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r10
	.word 0xd4cf6000  ! 3922: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0xda8d04a0  ! 3923: LDUBA_R	lduba	[%r20, %r0] 0x25, %r13
	.word 0x87802073  ! 3924: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf76000  ! 3925: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdad7a000  ! 3926: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0xd49ec9e0  ! 3927: LDDA_R	ldda	[%r27, %r0] 0x4f, %r10
	.word 0xd4bf2000  ! 3928: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	mov	0x10, %r19
	.word 0xd4cf2000  ! 3930: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd28649e0  ! 3931: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r9
	.word 0xdea7ce40  ! 3932: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xde9fce60  ! 3934: LDDA_R	ldda	[%r31, %r0] 0x73, %r15
	.word 0xdc9504a0  ! 3935: LDUHA_R	lduha	[%r20, %r0] 0x25, %r14
	.word 0x87802025  ! 3936: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf5e000  ! 3937: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0xd6944400  ! 3938: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	.word 0xdeacc400  ! 3939: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xdca5c4a0  ! 3940: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	.word 0x87802020  ! 3941: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c649e0  ! 3942: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r9
	.word 0xde9cc400  ! 3943: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	.word 0xdef609e0  ! 3944: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	.word 0xdef46000  ! 3945: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3946: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r21
	.word 0xd4cc0400  ! 3948: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r10
	mov	0x3d0, %r21
	.word 0xda8d04a0  ! 3950: LDUBA_R	lduba	[%r20, %r0] 0x25, %r13
	.word 0xde8c8400  ! 3951: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	.word 0x87802073  ! 3952: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6948400  ! 3953: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	.word 0xd6afa000  ! 3954: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6af0e40  ! 3955: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	.word 0xd6dfa000  ! 3956: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0x87802025  ! 3957: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f74e60  ! 3958: STXA_R	stxa	%r8, [%r29 + %r0] 0x73
	.word 0xd0cda000  ! 3959: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r8
	.word 0xd08da000  ! 3960: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r8
	.word 0xdeac8400  ! 3961: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xdea56000  ! 3962: STWA_I	stwa	%r15, [%r21 + 0x0000] %asi
	.word 0xdca6c9e0  ! 3963: STWA_R	stwa	%r14, [%r27 + %r0] 0x4f
	.word 0x87802073  ! 3964: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd28e09e0  ! 3965: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r9
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2f7e000  ! 3967: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd287a000  ! 3968: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	mov	0x50, %r16
	.word 0xdacc4400  ! 3970: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	.word 0x8780204f  ! 3971: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 3972: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3973: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r17
	.word 0xd49689e0  ! 3975: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r10
	.word 0xd49ca000  ! 3976: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd4dca000  ! 3977: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	mov	0x7f8, %r22
	mov	0x28, %r25
	.word 0x87802020  ! 3980: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ac6000  ! 3981: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0xd4b4a000  ! 3983: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0xd4a4e000  ! 3984: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xd4ac6000  ! 3985: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	.word 0xd6f649e0  ! 3986: STXA_R	stxa	%r11, [%r25 + %r0] 0x4f
	.word 0xd6cc6000  ! 3987: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3988: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab78e40  ! 3989: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	.word 0xdacca000  ! 3990: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	.word 0xd48d04a0  ! 3991: LDUBA_R	lduba	[%r20, %r0] 0x25, %r10
	.word 0xd4aca000  ! 3992: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0xd49c2000  ! 3993: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	.word 0xd4f46000  ! 3994: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0xd8cf4e80  ! 3995: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r12
	.word 0xd8ace000  ! 3996: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0xd88c2000  ! 3997: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	.word 0x87802073  ! 3998: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6d7ce40  ! 3999: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r11
	.word 0xd6cfe000  ! 4000: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	mov	0x78, %r27
	.word 0xd68fa000  ! 4002: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0xd4b78e80  ! 4003: STHA_R	stha	%r10, [%r30 + %r0] 0x74
	.word 0xd4cf2000  ! 4004: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4c76000  ! 4005: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	mov	0x3e0, %r21
	.word 0xdeaf8e40  ! 4007: STBA_R	stba	%r15, [%r30 + %r0] 0x72
	.word 0xdcdc0400  ! 4008: LDXA_R	ldxa	[%r16, %r0] 0x20, %r14
	.word 0x87802074  ! 4009: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb7e000  ! 4010: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xdcafe000  ! 4011: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xd6bd84a0  ! 4012: STDA_R	stda	%r11, [%r22 + %r0] 0x25
	.word 0x87802025  ! 4013: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a52000  ! 4014: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	.word 0xdcb649e0  ! 4015: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	.word 0xdedfce80  ! 4016: LDXA_R	ldxa	[%r31, %r0] 0x74, %r15
	.word 0x8780204f  ! 4017: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xded62000  ! 4018: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r15
	.word 0xd6cdc4a0  ! 4019: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r11
	mov	0x7e8, %r20
	.word 0xd686e000  ! 4021: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r11
	.word 0xd2f6c9e0  ! 4022: STXA_R	stxa	%r9, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 4023: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r19
	.word 0xd2c7e000  ! 4025: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0xdc9dc4a0  ! 4026: LDDA_R	ldda	[%r23, %r0] 0x25, %r14
	.word 0xdc97e000  ! 4027: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xdcaf2000  ! 4028: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdcc7e000  ! 4029: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	mov	0x0, %r19
	.word 0x87802025  ! 4031: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r16
	.word 0xd8a78e60  ! 4033: STWA_R	stwa	%r12, [%r30 + %r0] 0x73
	.word 0xdaafce80  ! 4034: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	mov	0x48, %r26
	.word 0xdac5a000  ! 4036: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r13
	.word 0xd6f504a0  ! 4037: STXA_R	stxa	%r11, [%r20 + %r0] 0x25
	.word 0xda9cc400  ! 4038: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	.word 0xd6974e80  ! 4039: LDUHA_R	lduha	[%r29, %r0] 0x74, %r11
	.word 0xda94c400  ! 4040: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	mov	0x7e8, %r21
	mov	0x40, %r26
	.word 0xde94c400  ! 4043: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	.word 0xda970e40  ! 4044: LDUHA_R	lduha	[%r28, %r0] 0x72, %r13
	.word 0xda852000  ! 4045: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r13
	.word 0xd6ae89e0  ! 4046: STBA_R	stba	%r11, [%r26 + %r0] 0x4f
	.word 0xdacd44a0  ! 4047: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r13
	mov	0x3c8, %r21
	.word 0xdaad6000  ! 4049: STBA_I	stba	%r13, [%r21 + 0x0000] %asi
	.word 0xdaad6000  ! 4050: STBA_I	stba	%r13, [%r21 + 0x0000] %asi
	.word 0xdaa5e000  ! 4051: STWA_I	stwa	%r13, [%r23 + 0x0000] %asi
	.word 0xd8af4e80  ! 4052: STBA_R	stba	%r12, [%r29 + %r0] 0x74
	mov	0x3d0, %r23
	.word 0xd8cd6000  ! 4054: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r12
	.word 0x87802072  ! 4055: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8df2000  ! 4056: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	mov	0x50, %r27
	.word 0x8780204f  ! 4058: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bee000  ! 4059: STDA_I	stda	%r12, [%r27 + 0x0000] %asi
	mov	0x30, %r27
	.word 0xd8d6e000  ! 4061: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r12
	.word 0xd2b70e60  ! 4062: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	.word 0xde8e89e0  ! 4063: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r15
	.word 0x8780204f  ! 4064: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d0, %r21
	.word 0xdebea000  ! 4066: STDA_I	stda	%r15, [%r26 + 0x0000] %asi
	.word 0x87802073  ! 4067: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r26
	.word 0xd4be49e0  ! 4069: STDA_R	stda	%r10, [%r25 + %r0] 0x4f
	.word 0xd8f74e80  ! 4070: STXA_R	stxa	%r12, [%r29 + %r0] 0x74
	mov	0x8, %r27
	.word 0xdacc0400  ! 4072: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r13
	mov	0x68, %r17
	.word 0x87802074  ! 4074: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef44400  ! 4075: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0x87802025  ! 4076: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdedda000  ! 4077: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r15
	.word 0xd2970e80  ! 4078: LDUHA_R	lduha	[%r28, %r0] 0x74, %r9
	.word 0xd2cd6000  ! 4079: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r9
	.word 0xd28d2000  ! 4080: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r9
	.word 0xd68f0e40  ! 4081: LDUBA_R	lduba	[%r28, %r0] 0x72, %r11
	mov	0x20, %r17
	mov	0x3d0, %r20
	.word 0xd4c5c4a0  ! 4084: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r10
	.word 0xd4856000  ! 4085: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r10
	.word 0xde948400  ! 4086: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	.word 0xde8d6000  ! 4087: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r15
	.word 0x87802020  ! 4088: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r18
	.word 0x87802020  ! 4090: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb46000  ! 4091: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x8, %r16
	.word 0xdeace000  ! 4094: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 4095: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b504a0  ! 4096: STHA_R	stha	%r9, [%r20 + %r0] 0x25
	mov	0x78, %r27
	mov	0x48, %r24
	mov	0x10, %r24
	.word 0xd6b7ce80  ! 4100: STHA_R	stha	%r11, [%r31 + %r0] 0x74
	.word 0xd6d5e000  ! 4101: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r11
	.word 0xd6b5a000  ! 4102: STHA_I	stha	%r11, [%r22 + 0x0000] %asi
	.word 0xd4ae49e0  ! 4103: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0xd0b504a0  ! 4104: STHA_R	stha	%r8, [%r20 + %r0] 0x25
	.word 0xd095e000  ! 4105: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r8
	.word 0xd6f40400  ! 4106: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	mov	0x30, %r17
	.word 0xdadf8e80  ! 4108: LDXA_R	ldxa	[%r30, %r0] 0x74, %r13
	.word 0xdab5e000  ! 4109: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0xd09ec9e0  ! 4110: LDDA_R	ldda	[%r27, %r0] 0x4f, %r8
	.word 0xd8af4e80  ! 4111: STBA_R	stba	%r12, [%r29 + %r0] 0x74
	mov	0x7e0, %r23
	.word 0x87802020  ! 4113: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4114: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb70e80  ! 4115: STHA_R	stha	%r14, [%r28 + %r0] 0x74
	.word 0xd4d74e40  ! 4116: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r10
	.word 0xdeccc400  ! 4117: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r15
	.word 0xd6c40400  ! 4118: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r11
	.word 0xd6b46000  ! 4119: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd4cf4e60  ! 4120: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r10
	.word 0xd6df8e60  ! 4121: LDXA_R	ldxa	[%r30, %r0] 0x73, %r11
	mov	0x0, %r19
	.word 0xd6b4a000  ! 4123: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xdc87ce60  ! 4124: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r14
	mov	0x7c0, %r20
	mov	0x18, %r18
	mov	0x78, %r16
	mov	0x10, %r26
	.word 0x8780204f  ! 4129: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x0, %r16
	.word 0xd49e49e0  ! 4131: LDDA_R	ldda	[%r25, %r0] 0x4f, %r10
	mov	0x58, %r16
	.word 0x87802072  ! 4133: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 4134: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r24
	.word 0xd48d6000  ! 4136: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r10
	mov	0x10, %r24
	.word 0x87802072  ! 4138: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f0, %r21
	.word 0xd0cd84a0  ! 4140: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r8
	.word 0xdaa6c9e0  ! 4141: STWA_R	stwa	%r13, [%r27 + %r0] 0x4f
	.word 0xdea544a0  ! 4142: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	mov	0x30, %r26
	.word 0xde9d04a0  ! 4144: LDDA_R	ldda	[%r20, %r0] 0x25, %r15
	.word 0xdeb74e80  ! 4145: STHA_R	stha	%r15, [%r29 + %r0] 0x74
	mov	0x60, %r26
	.word 0xdeaf2000  ! 4147: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	mov	0x38, %r27
	.word 0xde8fa000  ! 4149: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0xde8fa000  ! 4150: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0xdea72000  ! 4151: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xde97e000  ! 4152: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 4153: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 4154: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4155: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9c6000  ! 4156: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0xd0b70e80  ! 4157: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	.word 0xd0d4e000  ! 4158: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	.word 0xd8af4e80  ! 4159: STBA_R	stba	%r12, [%r29 + %r0] 0x74
	.word 0x87802073  ! 4160: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2a70e60  ! 4161: STWA_R	stwa	%r9, [%r28 + %r0] 0x73
	mov	0x50, %r18
	.word 0xdccf0e40  ! 4163: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r14
	.word 0xdcbfe000  ! 4164: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xd68544a0  ! 4165: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r11
	mov	0x40, %r24
	.word 0x8780204f  ! 4167: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6a6a000  ! 4168: STWA_I	stwa	%r11, [%r26 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0xd4afce60  ! 4170: STBA_R	stba	%r10, [%r31 + %r0] 0x73
	.word 0xd4d66000  ! 4171: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r10
	.word 0xdaa504a0  ! 4172: STWA_R	stwa	%r13, [%r20 + %r0] 0x25
	.word 0xd2d74e60  ! 4173: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r9
	.word 0xdac44400  ! 4174: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r13
	.word 0xd4de89e0  ! 4175: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r10
	.word 0xd486a000  ! 4176: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r10
	.word 0xd2f7ce60  ! 4177: STXA_R	stxa	%r9, [%r31 + %r0] 0x73
	.word 0xd2be2000  ! 4178: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	.word 0xdef70e40  ! 4179: STXA_R	stxa	%r15, [%r28 + %r0] 0x72
	.word 0xdace49e0  ! 4180: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r13
	.word 0xdad66000  ! 4181: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r13
	.word 0x87802073  ! 4182: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2be09e0  ! 4183: STDA_R	stda	%r9, [%r24 + %r0] 0x4f
	.word 0xdaf70e40  ! 4184: STXA_R	stxa	%r13, [%r28 + %r0] 0x72
	.word 0xd2874e40  ! 4185: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r9
	.word 0xd2f72000  ! 4186: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xda8f4e80  ! 4187: LDUBA_R	lduba	[%r29, %r0] 0x74, %r13
	.word 0xd0cf8e60  ! 4188: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r8
	.word 0xd495c4a0  ! 4189: LDUHA_R	lduha	[%r23, %r0] 0x25, %r10
	mov	0x7c8, %r21
	.word 0xd4bfa000  ! 4191: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd2cf4e40  ! 4192: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r9
	mov	0x48, %r18
	mov	0x60, %r18
	.word 0xd2bf2000  ! 4195: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xdeb609e0  ! 4196: STHA_R	stha	%r15, [%r24 + %r0] 0x4f
	.word 0x87802072  ! 4197: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4198: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde94e000  ! 4199: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	.word 0xde8c6000  ! 4200: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0xdcf609e0  ! 4201: STXA_R	stxa	%r14, [%r24 + %r0] 0x4f
	.word 0xdca4e000  ! 4202: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 4203: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcc56000  ! 4204: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r14
	.word 0xdcad6000  ! 4205: STBA_I	stba	%r14, [%r21 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0xd8a78e40  ! 4207: STWA_R	stwa	%r12, [%r30 + %r0] 0x72
	.word 0xd8cde000  ! 4208: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r12
	.word 0xd8f52000  ! 4209: STXA_I	stxa	%r12, [%r20 + 0x0000] %asi
	.word 0xd8a5a000  ! 4210: STWA_I	stwa	%r12, [%r22 + 0x0000] %asi
	mov	0x3d8, %r22
	mov	0x60, %r24
	mov	0x38, %r16
	.word 0xdec544a0  ! 4214: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r15
	mov	0x28, %r27
	.word 0xdeb56000  ! 4216: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	mov	0x8, %r19
	.word 0xd2cc8400  ! 4218: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	mov	0x38, %r18
	.word 0xd6bd44a0  ! 4220: STDA_R	stda	%r11, [%r21 + %r0] 0x25
	mov	0x8, %r26
	.word 0x87802074  ! 4222: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6cf6000  ! 4223: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6cfce40  ! 4224: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r11
	.word 0xd09609e0  ! 4225: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r8
	.word 0x87802073  ! 4226: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r27
	.word 0xd0bfe000  ! 4228: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd8d48400  ! 4229: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	mov	0x28, %r19
	.word 0x87802074  ! 4231: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e8, %r23
	.word 0x87802020  ! 4233: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r21
	mov	0x3e8, %r22
	mov	0x60, %r25
	.word 0xd8dc6000  ! 4237: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	mov	0x20, %r27
	mov	0x28, %r27
	.word 0xd8d4e000  ! 4240: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0xd8d4a000  ! 4241: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xd8d4a000  ! 4242: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	mov	0x70, %r16
	mov	0x38, %r24
	.word 0x87802072  ! 4245: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0f7ce60  ! 4246: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	.word 0xd0dfa000  ! 4247: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0xdc8689e0  ! 4248: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r14
	.word 0x87802020  ! 4249: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc84e000  ! 4250: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r14
	mov	0x60, %r19
	mov	0x58, %r25
	.word 0xdcbfce80  ! 4253: STDA_R	stda	%r14, [%r31 + %r0] 0x74
	.word 0x87802072  ! 4254: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 4255: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 4256: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf7a000  ! 4257: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcbf6000  ! 4258: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0x87802020  ! 4260: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4261: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28504a0  ! 4262: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r9
	.word 0x87802020  ! 4263: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r24
	.word 0xd2f4e000  ! 4265: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2946000  ! 4266: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r9
	.word 0xd2d42000  ! 4267: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 4268: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c0, %r20
	.word 0xd2b6e000  ! 4270: STHA_I	stha	%r9, [%r27 + 0x0000] %asi
	.word 0x8780204f  ! 4271: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2d5c4a0  ! 4272: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r9
	.word 0xd09f0e40  ! 4273: LDDA_R	ldda	[%r28, %r0] 0x72, %r8
	mov	0x48, %r24
	mov	0x50, %r26
	.word 0x87802074  ! 4276: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c8, %r23
	.word 0xd09fe000  ! 4278: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	.word 0xd8d70e80  ! 4279: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r12
	.word 0xd8b7a000  ! 4280: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xd8cfe000  ! 4281: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8f7a000  ! 4282: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xdad78e80  ! 4283: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r13
	.word 0xdac72000  ! 4284: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0xdebc0400  ! 4285: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	mov	0x18, %r26
	.word 0xdeb7a000  ! 4287: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xdec7ce80  ! 4288: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r15
	.word 0xdaaf0e60  ! 4289: STBA_R	stba	%r13, [%r28 + %r0] 0x73
	.word 0xda9f6000  ! 4290: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	mov	0x3f8, %r21
	mov	0x78, %r19
	.word 0x87802073  ! 4293: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r27
	.word 0xda8cc400  ! 4295: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	.word 0xd8b5c4a0  ! 4296: STHA_R	stha	%r12, [%r23 + %r0] 0x25
	mov	0x58, %r19
	.word 0xd897e000  ! 4298: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	mov	0x48, %r17
	mov	0x60, %r25
	.word 0xd0bd84a0  ! 4301: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0x87802025  ! 4302: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a5e000  ! 4303: STWA_I	stwa	%r8, [%r23 + 0x0000] %asi
	.word 0xd0bd6000  ! 4304: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0xd0bd2000  ! 4305: STDA_I	stda	%r8, [%r20 + 0x0000] %asi
	.word 0xd0bda000  ! 4306: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	.word 0x87802025  ! 4307: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdedf0e40  ! 4308: LDXA_R	ldxa	[%r28, %r0] 0x72, %r15
	mov	0x8, %r17
	mov	0x20, %r16
	.word 0xd2b40400  ! 4311: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0xdcae89e0  ! 4312: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	.word 0xdcf52000  ! 4313: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	.word 0x87802025  ! 4314: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcdcc400  ! 4315: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	.word 0xdcb5a000  ! 4316: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0x8780204f  ! 4317: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r24
	.word 0xdcde6000  ! 4319: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r14
	.word 0xdc9c4400  ! 4320: LDDA_R	ldda	[%r17, %r0] 0x20, %r14
	.word 0x87802020  ! 4321: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r18
	.word 0xda84c400  ! 4323: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r13
	.word 0x87802074  ! 4324: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda970e80  ! 4325: LDUHA_R	lduha	[%r28, %r0] 0x74, %r13
	.word 0xda9f2000  ! 4326: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xdaa76000  ! 4327: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xd2cc4400  ! 4329: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r9
	.word 0x87802073  ! 4330: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 4331: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r18
	.word 0xd2a76000  ! 4333: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd8a70e80  ! 4334: STWA_R	stwa	%r12, [%r28 + %r0] 0x74
	.word 0x87802074  ! 4335: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc86c9e0  ! 4336: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r14
	.word 0x87802073  ! 4337: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r19
	.word 0xdc9f2000  ! 4339: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xdc8f2000  ! 4340: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	mov	0x18, %r18
	.word 0x87802020  ! 4342: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdce000  ! 4343: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r14
	.word 0xdcd4e000  ! 4344: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4345: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ac4400  ! 4346: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	mov	0x3c0, %r21
	.word 0xd6a42000  ! 4348: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xd0dc8400  ! 4349: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	mov	0x20, %r19
	.word 0xd0bc6000  ! 4351: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	mov	0x3f8, %r22
	.word 0xdcbfce80  ! 4353: STDA_R	stda	%r14, [%r31 + %r0] 0x74
	.word 0xd6a48400  ! 4354: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0x87802020  ! 4355: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc8dc4a0  ! 4356: LDUBA_R	lduba	[%r23, %r0] 0x25, %r14
	mov	0x48, %r24
	mov	0x0, %r26
	.word 0xdc846000  ! 4359: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	.word 0xdeaf0e60  ! 4360: STBA_R	stba	%r15, [%r28 + %r0] 0x73
	.word 0xdebc6000  ! 4361: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 4362: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r25
	mov	0x60, %r16
	.word 0x87802020  ! 4365: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd884c400  ! 4366: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	.word 0xd8d6c9e0  ! 4367: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r12
	.word 0xd8b42000  ! 4368: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	mov	0x7f0, %r20
	mov	0x7c8, %r23
	.word 0xdec70e80  ! 4371: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r15
	.word 0x87802072  ! 4372: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2a44400  ! 4373: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xd8978e40  ! 4374: LDUHA_R	lduha	[%r30, %r0] 0x72, %r12
	.word 0xd8f76000  ! 4375: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 4376: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 4377: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8d5e000  ! 4378: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r12
	.word 0xd8dda000  ! 4379: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r12
	.word 0xd4dd84a0  ! 4380: LDXA_R	ldxa	[%r22, %r0] 0x25, %r10
	.word 0xdca48400  ! 4381: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xdcada000  ! 4382: STBA_I	stba	%r14, [%r22 + 0x0000] %asi
	.word 0x87802025  ! 4383: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c8, %r20
	.word 0xdcdde000  ! 4385: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	.word 0xdca5e000  ! 4386: STWA_I	stwa	%r14, [%r23 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xda840400  ! 4388: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	mov	0x48, %r24
	.word 0xdaad2000  ! 4390: STBA_I	stba	%r13, [%r20 + 0x0000] %asi
	.word 0xdccc4400  ! 4391: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r14
	mov	0x60, %r19
	.word 0xd4cf0e40  ! 4393: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r10
	.word 0xd485e000  ! 4394: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r10
	.word 0x87802020  ! 4395: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2870e80  ! 4397: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r9
	.word 0x8780204f  ! 4398: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 4399: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r27
	mov	0x28, %r16
	.word 0xd2b76000  ! 4402: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xde974e40  ! 4403: LDUHA_R	lduha	[%r29, %r0] 0x72, %r15
	mov	0x30, %r25
	.word 0xdeb7e000  ! 4405: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xdec7e000  ! 4406: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xdec7a000  ! 4407: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xdeafe000  ! 4408: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xd6dfce40  ! 4410: LDXA_R	ldxa	[%r31, %r0] 0x72, %r11
	.word 0xd6f76000  ! 4411: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	mov	0x10, %r16
	.word 0x87802072  ! 4413: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd69f2000  ! 4414: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xd48fce60  ! 4415: LDUBA_R	lduba	[%r31, %r0] 0x73, %r10
	.word 0xd49fe000  ! 4416: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd4f40400  ! 4417: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xdead84a0  ! 4418: STBA_R	stba	%r15, [%r22 + %r0] 0x25
	mov	0x68, %r24
	.word 0xd69504a0  ! 4420: LDUHA_R	lduha	[%r20, %r0] 0x25, %r11
	mov	0x7f0, %r22
	mov	0x8, %r26
	.word 0xdad544a0  ! 4423: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r13
	.word 0xd49f4e60  ! 4424: LDDA_R	ldda	[%r29, %r0] 0x73, %r10
	.word 0x87802074  ! 4425: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd48f6000  ! 4426: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xd8ccc400  ! 4427: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r12
	.word 0xd887e000  ! 4428: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8cf6000  ! 4429: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0x87802073  ! 4430: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r18
	.word 0xd88f6000  ! 4432: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xd8f72000  ! 4433: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8b76000  ! 4434: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 4435: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4436: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d4e000  ! 4437: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0xd89ca000  ! 4438: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r12
	mov	0x78, %r26
	.word 0xd8942000  ! 4440: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r12
	.word 0xd6c649e0  ! 4441: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r11
	.word 0xd8d44400  ! 4442: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	.word 0xd2cc0400  ! 4443: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r9
	.word 0xda8f0e60  ! 4444: LDUBA_R	lduba	[%r28, %r0] 0x73, %r13
	.word 0xdab4e000  ! 4445: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xdacc2000  ! 4446: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xdaa4e000  ! 4447: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 4448: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2c5c4a0  ! 4449: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r9
	.word 0xdad44400  ! 4450: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0x87802073  ! 4451: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r25
	.word 0xdaf72000  ! 4453: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	mov	0x50, %r19
	.word 0xd88f0e80  ! 4455: LDUBA_R	lduba	[%r28, %r0] 0x74, %r12
	mov	0x40, %r17
	mov	0x48, %r16
	.word 0x87802020  ! 4458: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r20
	.word 0xd8ace000  ! 4460: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	mov	0x30, %r18
	.word 0x87802025  ! 4462: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r17
	.word 0x87802020  ! 4464: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r25
	.word 0xd4b78e60  ! 4466: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	mov	0x48, %r27
	.word 0xd49c2000  ! 4468: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	.word 0xd6d7ce40  ! 4469: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r11
	.word 0xdaaf4e40  ! 4470: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	mov	0x38, %r24
	.word 0x87802020  ! 4472: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b649e0  ! 4473: STHA_R	stha	%r11, [%r25 + %r0] 0x4f
	.word 0xd6dca000  ! 4474: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r11
	.word 0x87802073  ! 4475: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f72000  ! 4476: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd68f6000  ! 4477: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xd68fe000  ! 4478: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xd6af6000  ! 4479: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xdef689e0  ! 4480: STXA_R	stxa	%r15, [%r26 + %r0] 0x4f
	.word 0xdec72000  ! 4481: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xdef72000  ! 4482: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xd0cfce60  ! 4483: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r8
	.word 0xd0c7e000  ! 4484: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0df6000  ! 4485: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0x87802072  ! 4486: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 4487: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4488: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 4489: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 4490: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8f7ce80  ! 4491: STXA_R	stxa	%r12, [%r31 + %r0] 0x74
	mov	0x78, %r27
	mov	0x3e0, %r20
	.word 0x87802073  ! 4494: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8bf2000  ! 4495: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xda8ec9e0  ! 4496: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r13
	mov	0x30, %r17
	mov	0x58, %r26
	.word 0x87802025  ! 4499: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabe49e0  ! 4500: STDA_R	stda	%r13, [%r25 + %r0] 0x4f
	.word 0x87802072  ! 4501: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdac7a000  ! 4502: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4503: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda84a000  ! 4504: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	mov	0x68, %r19
	.word 0x87802025  ! 4506: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d0, %r20
	.word 0xdab5e000  ! 4508: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	mov	0x38, %r24
	.word 0xd4bc8400  ! 4510: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	.word 0xd4dd2000  ! 4511: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r10
	.word 0xd8970e80  ! 4512: LDUHA_R	lduha	[%r28, %r0] 0x74, %r12
	.word 0x87802020  ! 4513: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b7ce60  ! 4514: STHA_R	stha	%r11, [%r31 + %r0] 0x73
	.word 0xd6bdc4a0  ! 4515: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	.word 0xdaac4400  ! 4516: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	mov	0x48, %r16
	.word 0xdade89e0  ! 4518: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r13
	.word 0x87802074  ! 4519: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdac7a000  ! 4520: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xd6bf4e80  ! 4521: STDA_R	stda	%r11, [%r29 + %r0] 0x74
	.word 0x87802025  ! 4522: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b5a000  ! 4523: STHA_I	stha	%r11, [%r22 + 0x0000] %asi
	mov	0x68, %r18
	.word 0xd685e000  ! 4525: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r11
	mov	0x7e8, %r20
	.word 0xd8adc4a0  ! 4527: STBA_R	stba	%r12, [%r23 + %r0] 0x25
	.word 0xd4f44400  ! 4528: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0xd6b4c400  ! 4529: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xd2ac4400  ! 4530: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	mov	0x7d0, %r23
	.word 0x8780204f  ! 4532: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2c66000  ! 4533: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r9
	.word 0xd2b6e000  ! 4534: STHA_I	stha	%r9, [%r27 + 0x0000] %asi
	.word 0xd2c6a000  ! 4535: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r9
	mov	0x8, %r16
	.word 0xd2c74e60  ! 4537: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r9
	.word 0xd2c6e000  ! 4538: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r9
	.word 0xd2b66000  ! 4539: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	.word 0xd2962000  ! 4540: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r9
	.word 0xd4cc0400  ! 4541: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r10
	.word 0xd4f62000  ! 4542: STXA_I	stxa	%r10, [%r24 + 0x0000] %asi
	.word 0xda9f4e60  ! 4543: LDDA_R	ldda	[%r29, %r0] 0x73, %r13
	.word 0xd2b74e60  ! 4544: STHA_R	stha	%r9, [%r29 + %r0] 0x73
	.word 0xd6b7ce40  ! 4545: STHA_R	stha	%r11, [%r31 + %r0] 0x72
	.word 0xd8a40400  ! 4546: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0xd4b6c9e0  ! 4547: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0xd6b48400  ! 4548: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xdc8f0e80  ! 4549: LDUBA_R	lduba	[%r28, %r0] 0x74, %r14
	.word 0x87802073  ! 4550: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c8, %r23
	mov	0x7d8, %r21
	.word 0x87802020  ! 4553: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdce000  ! 4554: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r14
	.word 0xdcbce000  ! 4555: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xd4a4c400  ! 4556: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0x87802020  ! 4557: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cc6000  ! 4558: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	.word 0xd4dce000  ! 4559: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	.word 0x87802074  ! 4560: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x20, %r18
	.word 0xdcc6c9e0  ! 4563: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r14
	mov	0x20, %r25
	.word 0xdea6c9e0  ! 4565: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	.word 0xd8adc4a0  ! 4566: STBA_R	stba	%r12, [%r23 + %r0] 0x25
	.word 0x8780204f  ! 4567: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8962000  ! 4568: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r12
	.word 0xd8b66000  ! 4569: STHA_I	stha	%r12, [%r25 + 0x0000] %asi
	.word 0xd8a62000  ! 4570: STWA_I	stwa	%r12, [%r24 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xd6b70e60  ! 4572: STHA_R	stha	%r11, [%r28 + %r0] 0x73
	.word 0xd6f62000  ! 4573: STXA_I	stxa	%r11, [%r24 + 0x0000] %asi
	.word 0xd6d66000  ! 4574: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r11
	.word 0xdaa70e80  ! 4575: STWA_R	stwa	%r13, [%r28 + %r0] 0x74
	.word 0xda870e40  ! 4576: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r13
	mov	0x58, %r17
	.word 0x87802020  ! 4578: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f74e40  ! 4579: STXA_R	stxa	%r9, [%r29 + %r0] 0x72
	.word 0xd0dc4400  ! 4580: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	.word 0x87802025  ! 4581: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 4582: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4583: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a78e40  ! 4584: STWA_R	stwa	%r11, [%r30 + %r0] 0x72
	.word 0x87802020  ! 4585: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f40400  ! 4586: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xd09e09e0  ! 4587: LDDA_R	ldda	[%r24, %r0] 0x4f, %r8
	.word 0x8780204f  ! 4588: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r24
	.word 0xda8f8e60  ! 4590: LDUBA_R	lduba	[%r30, %r0] 0x73, %r13
	.word 0xdab6e000  ! 4591: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	mov	0x70, %r19
	mov	0x10, %r27
	mov	0x7c8, %r20
	.word 0x87802072  ! 4595: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4596: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r24
	mov	0x58, %r25
	.word 0x8780204f  ! 4599: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4dc4400  ! 4600: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	.word 0xd4f62000  ! 4601: STXA_I	stxa	%r10, [%r24 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0x87802020  ! 4603: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c42000  ! 4604: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r10
	mov	0x78, %r27
	mov	0x70, %r27
	.word 0xd2b74e40  ! 4607: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	mov	0x50, %r17
	.word 0x87802025  ! 4609: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2cd2000  ! 4610: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r9
	.word 0xd0bdc4a0  ! 4611: STDA_R	stda	%r8, [%r23 + %r0] 0x25
	.word 0xd49dc4a0  ! 4612: LDDA_R	ldda	[%r23, %r0] 0x25, %r10
	.word 0xd2870e60  ! 4613: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r9
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x70, %r27
	.word 0xd285e000  ! 4616: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r9
	.word 0xd2ad2000  ! 4617: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xde948400  ! 4618: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	.word 0xd0be09e0  ! 4619: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0xd2af8e40  ! 4620: STBA_R	stba	%r9, [%r30 + %r0] 0x72
	.word 0xd2b56000  ! 4621: STHA_I	stha	%r9, [%r21 + 0x0000] %asi
	.word 0xdaf5c4a0  ! 4622: STXA_R	stxa	%r13, [%r23 + %r0] 0x25
	mov	0x10, %r25
	.word 0xd2af0e60  ! 4624: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	.word 0xd285e000  ! 4625: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r9
	.word 0xd2f52000  ! 4626: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	.word 0xd2a5a000  ! 4627: STWA_I	stwa	%r9, [%r22 + 0x0000] %asi
	.word 0xdc8ec9e0  ! 4628: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r14
	.word 0xdebc0400  ! 4629: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0xd2de49e0  ! 4630: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r9
	mov	0x7c8, %r22
	mov	0x50, %r16
	.word 0xd2c5a000  ! 4633: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r9
	mov	0x3e8, %r20
	.word 0xdad78e40  ! 4635: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r13
	.word 0x8780204f  ! 4636: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8944400  ! 4637: LDUHA_R	lduha	[%r17, %r0] 0x20, %r12
	.word 0xd8aee000  ! 4638: STBA_I	stba	%r12, [%r27 + 0x0000] %asi
	.word 0xd8dee000  ! 4639: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r12
	mov	0x20, %r18
	.word 0x87802073  ! 4641: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8c76000  ! 4642: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	mov	0x48, %r17
	.word 0xd8bf6000  ! 4644: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	mov	0x48, %r17
	mov	0x3d8, %r23
	.word 0xd8a72000  ! 4647: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xdeac4400  ! 4648: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0xdecfa000  ! 4649: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	mov	0x20, %r16
	.word 0x87802025  ! 4651: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2dfce60  ! 4652: LDXA_R	ldxa	[%r31, %r0] 0x73, %r9
	.word 0xd2d5e000  ! 4653: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r9
	mov	0x78, %r24
	.word 0xd2bd6000  ! 4655: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	.word 0xd28d6000  ! 4656: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 4657: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd28ee000  ! 4658: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r9
	mov	0x8, %r18
	.word 0xd2a6e000  ! 4660: STWA_I	stwa	%r9, [%r27 + 0x0000] %asi
	.word 0xd2d6e000  ! 4661: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r9
	.word 0x87802074  ! 4662: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6ac8400  ! 4663: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xd6bf6000  ! 4664: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd6afa000  ! 4665: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 4666: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r17
	mov	0x20, %r24
	mov	0x8, %r19
	.word 0x87802025  ! 4670: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r18
	.word 0xd6bde000  ! 4672: STDA_I	stda	%r11, [%r23 + 0x0000] %asi
	.word 0xd6b52000  ! 4673: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	.word 0xdef44400  ! 4674: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xde85e000  ! 4675: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r15
	.word 0xdef5e000  ! 4676: STXA_I	stxa	%r15, [%r23 + 0x0000] %asi
	mov	0x28, %r27
	mov	0x3d0, %r22
	.word 0xd2948400  ! 4679: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	mov	0x28, %r19
	mov	0x40, %r18
	.word 0xd8dcc400  ! 4682: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	mov	0x70, %r18
	mov	0x68, %r26
	mov	0x18, %r16
	mov	0x38, %r18
	mov	0x60, %r27
	.word 0xdaa504a0  ! 4688: STWA_R	stwa	%r13, [%r20 + %r0] 0x25
	.word 0xdad5a000  ! 4689: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r13
	.word 0xdaa5a000  ! 4690: STWA_I	stwa	%r13, [%r22 + 0x0000] %asi
	.word 0xda85e000  ! 4691: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	.word 0x87802073  ! 4692: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdacf2000  ! 4693: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xdabfa000  ! 4694: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	mov	0x8, %r17
	.word 0xdacf0e80  ! 4696: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r13
	.word 0xdac76000  ! 4697: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0xdaa76000  ! 4698: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xdaa7e000  ! 4699: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	mov	0x50, %r16
	.word 0xdaf7ce60  ! 4701: STXA_R	stxa	%r13, [%r31 + %r0] 0x73
	mov	0x3c8, %r21
	.word 0xd2870e80  ! 4703: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r9
	.word 0x8780204f  ! 4704: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcb4c400  ! 4705: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	mov	0x30, %r18
	.word 0xd8b74e40  ! 4707: STHA_R	stha	%r12, [%r29 + %r0] 0x72
	.word 0xd886e000  ! 4708: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r12
	mov	0x8, %r16
	mov	0x8, %r24
	mov	0x3f8, %r23
	.word 0xd8b6e000  ! 4712: STHA_I	stha	%r12, [%r27 + 0x0000] %asi
	.word 0xd8a6a000  ! 4713: STWA_I	stwa	%r12, [%r26 + 0x0000] %asi
	.word 0xd8bee000  ! 4714: STDA_I	stda	%r12, [%r27 + 0x0000] %asi
	.word 0xd8b62000  ! 4715: STHA_I	stha	%r12, [%r24 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0xd8b44400  ! 4717: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	mov	0x60, %r16
	mov	0x7c0, %r20
	.word 0xd8dee000  ! 4720: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r12
	mov	0x58, %r26
	mov	0x7c8, %r23
	.word 0xd6f74e40  ! 4723: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	mov	0x7e8, %r23
	.word 0x87802073  ! 4725: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4726: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r27
	.word 0xd6a4e000  ! 4728: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xd6bca000  ! 4730: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	.word 0xd6b40400  ! 4731: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	mov	0x3f0, %r22
	.word 0xd68ca000  ! 4733: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r11
	.word 0xdeaf0e60  ! 4734: STBA_R	stba	%r15, [%r28 + %r0] 0x73
	.word 0x87802025  ! 4735: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbc8400  ! 4736: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xdccda000  ! 4737: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r14
	.word 0xdcd5e000  ! 4738: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r14
	.word 0xdcada000  ! 4739: STBA_I	stba	%r14, [%r22 + 0x0000] %asi
	.word 0xdcbd2000  ! 4740: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	.word 0xdcf52000  ! 4741: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	.word 0xdccde000  ! 4742: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r14
	.word 0xdca689e0  ! 4743: STWA_R	stwa	%r14, [%r26 + %r0] 0x4f
	.word 0xda9f4e60  ! 4744: LDDA_R	ldda	[%r29, %r0] 0x73, %r13
	.word 0xd6dd84a0  ! 4745: LDXA_R	ldxa	[%r22, %r0] 0x25, %r11
	.word 0x87802073  ! 4746: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 4747: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x48, %r26
	mov	0x68, %r18
	.word 0x87802020  ! 4750: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29649e0  ! 4751: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r9
	.word 0x8780204f  ! 4752: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r19
	.word 0xd2aee000  ! 4754: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	.word 0xdaf4c400  ! 4755: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xd6c74e80  ! 4756: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r11
	.word 0xd696e000  ! 4757: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	.word 0xdab7ce40  ! 4758: STHA_R	stha	%r13, [%r31 + %r0] 0x72
	.word 0x87802025  ! 4759: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c0, %r22
	.word 0xd2ce49e0  ! 4761: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r9
	.word 0xd2c5e000  ! 4762: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r9
	.word 0xd2a5a000  ! 4763: STWA_I	stwa	%r9, [%r22 + 0x0000] %asi
	.word 0xd4cf8e40  ! 4764: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r10
	.word 0xd4d56000  ! 4765: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r10
	.word 0xd4a52000  ! 4766: STWA_I	stwa	%r10, [%r20 + 0x0000] %asi
	.word 0xd4dda000  ! 4767: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r10
	.word 0xd4b56000  ! 4768: STHA_I	stha	%r10, [%r21 + 0x0000] %asi
	.word 0xd0bf0e80  ! 4769: STDA_R	stda	%r8, [%r28 + %r0] 0x74
	.word 0xd0dde000  ! 4770: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r8
	mov	0x7f8, %r23
	.word 0x87802074  ! 4772: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r18
	.word 0xd09fa000  ! 4774: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	.word 0xd4a70e80  ! 4775: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	.word 0xd4a7e000  ! 4776: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	mov	0x38, %r24
	.word 0xd88fce40  ! 4778: LDUBA_R	lduba	[%r31, %r0] 0x72, %r12
	mov	0x7e8, %r21
	.word 0xd8f584a0  ! 4780: STXA_R	stxa	%r12, [%r22 + %r0] 0x25
	.word 0xd4af0e40  ! 4781: STBA_R	stba	%r10, [%r28 + %r0] 0x72
	.word 0xd8f544a0  ! 4782: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	mov	0x78, %r27
	.word 0xd6a4c400  ! 4784: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	mov	0x50, %r16
	.word 0xdca649e0  ! 4786: STWA_R	stwa	%r14, [%r25 + %r0] 0x4f
	.word 0xd4af4e60  ! 4787: STBA_R	stba	%r10, [%r29 + %r0] 0x73
	.word 0x87802072  ! 4788: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4972000  ! 4789: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0xd497e000  ! 4790: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	.word 0xd4d7e000  ! 4791: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	mov	0x50, %r19
	.word 0xd497a000  ! 4793: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0x87802072  ! 4794: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd48f8e80  ! 4795: LDUBA_R	lduba	[%r30, %r0] 0x74, %r10
	.word 0xd497e000  ! 4796: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	.word 0x87802073  ! 4797: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 4798: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r19
	mov	0x7d0, %r22
	mov	0x7d0, %r21
	.word 0x87802074  ! 4802: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4d76000  ! 4803: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0xd6f78e60  ! 4804: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	mov	0x3f0, %r22
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x7c0, %r21
	.word 0xd6df2000  ! 4808: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd2ac8400  ! 4809: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xde87ce40  ! 4810: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r15
	.word 0x87802072  ! 4811: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdedf2000  ! 4812: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	mov	0x78, %r25
	mov	0x7f0, %r20
	.word 0xd8c44400  ! 4815: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r12
	.word 0xd8f76000  ! 4816: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8876000  ! 4817: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	mov	0x3f0, %r22
	mov	0x7e8, %r20
	.word 0xd4dd04a0  ! 4820: LDXA_R	ldxa	[%r20, %r0] 0x25, %r10
	.word 0xd49f6000  ! 4821: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0xd48fe000  ! 4822: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	mov	0x3c8, %r22
	.word 0xdec70e80  ! 4824: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r15
	mov	0x8, %r19
	.word 0xdea7e000  ! 4826: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xd0d689e0  ! 4827: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r8
	mov	0x48, %r25
	.word 0xde870e40  ! 4829: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r15
	.word 0x87802073  ! 4830: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r25
	.word 0x87802073  ! 4832: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f44400  ! 4833: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	mov	0x38, %r25
	mov	0x3f8, %r21
	.word 0xd2bf4e40  ! 4836: STDA_R	stda	%r9, [%r29 + %r0] 0x72
	mov	0x0, %r26
	.word 0xd4f70e80  ! 4838: STXA_R	stxa	%r10, [%r28 + %r0] 0x74
	.word 0xd4bfe000  ! 4839: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd4876000  ! 4840: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	mov	0x38, %r25
	.word 0xd4dfe000  ! 4842: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4afe000  ! 4843: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0xd4b72000  ! 4845: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd4b7a000  ! 4846: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xdacf4e80  ! 4847: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r13
	.word 0xd8df0e60  ! 4848: LDXA_R	ldxa	[%r28, %r0] 0x73, %r12
	.word 0xd69d44a0  ! 4849: LDDA_R	ldda	[%r21, %r0] 0x25, %r11
	.word 0xd4f78e80  ! 4850: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	.word 0xd0ad44a0  ! 4851: STBA_R	stba	%r8, [%r21 + %r0] 0x25
	.word 0x87802073  ! 4852: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd08fa000  ! 4853: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0xd0a7e000  ! 4854: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0b76000  ! 4855: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xd2d74e80  ! 4857: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r9
	.word 0xd2976000  ! 4858: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0xdcb5c4a0  ! 4859: STHA_R	stha	%r14, [%r23 + %r0] 0x25
	.word 0xdcbfa000  ! 4860: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0xd0d7ce80  ! 4862: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r8
	.word 0xd8a74e60  ! 4863: STWA_R	stwa	%r12, [%r29 + %r0] 0x73
	.word 0xd2ac8400  ! 4864: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xd2872000  ! 4865: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	mov	0x30, %r27
	mov	0x70, %r19
	mov	0x7c0, %r21
	.word 0xded6c9e0  ! 4869: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r15
	mov	0x58, %r16
	.word 0xd687ce40  ! 4871: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r11
	.word 0xd6bf6000  ! 4872: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd697a000  ! 4873: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0xdaf4c400  ! 4874: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xda8fe000  ! 4875: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 4876: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaaea000  ! 4877: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	.word 0xdaf62000  ! 4878: STXA_I	stxa	%r13, [%r24 + 0x0000] %asi
	.word 0xdab6e000  ! 4879: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	mov	0x30, %r27
	.word 0x8780204f  ! 4881: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6cf0e40  ! 4882: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r11
	.word 0xd4f40400  ! 4883: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xd6cf4e60  ! 4884: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r11
	.word 0xd6bf4e60  ! 4885: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	.word 0xd6f4c400  ! 4886: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	mov	0x30, %r27
	.word 0xd6b62000  ! 4888: STHA_I	stha	%r11, [%r24 + 0x0000] %asi
	.word 0xd89f8e60  ! 4889: LDDA_R	ldda	[%r30, %r0] 0x73, %r12
	.word 0xdabc8400  ! 4890: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	mov	0x48, %r17
	.word 0xdace2000  ! 4892: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r13
	.word 0x87802025  ! 4893: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e8, %r23
	mov	0x70, %r26
	.word 0xd89f4e60  ! 4896: LDDA_R	ldda	[%r29, %r0] 0x73, %r12
	.word 0x8780204f  ! 4897: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdead44a0  ! 4898: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	.word 0xd6ad84a0  ! 4899: STBA_R	stba	%r11, [%r22 + %r0] 0x25
	.word 0x87802020  ! 4900: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ac6000  ! 4901: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	mov	0x7d0, %r22
	.word 0x87802020  ! 4903: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r25
	.word 0xd6b46000  ! 4905: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xdeb78e80  ! 4906: STHA_R	stha	%r15, [%r30 + %r0] 0x74
	.word 0xdedca000  ! 4907: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xdeb74e60  ! 4908: STHA_R	stha	%r15, [%r29 + %r0] 0x73
	mov	0x60, %r16
	.word 0xdea42000  ! 4910: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xde8c6000  ! 4911: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0x87802020  ! 4912: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedca000  ! 4913: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	mov	0x7e8, %r22
	mov	0x28, %r24
	.word 0xdebc2000  ! 4916: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xdebc2000  ! 4917: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xdeb4e000  ! 4918: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 4919: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b70e60  ! 4920: STHA_R	stha	%r11, [%r28 + %r0] 0x73
	.word 0x87802074  ! 4921: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r24
	.word 0xd4f78e80  ! 4923: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	.word 0xd49f6000  ! 4924: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0x87802074  ! 4925: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4972000  ! 4926: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	mov	0x18, %r19
	.word 0xd4b7a000  ! 4928: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 4929: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f76000  ! 4930: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd08d84a0  ! 4931: LDUBA_R	lduba	[%r22, %r0] 0x25, %r8
	.word 0xd0af2000  ! 4932: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd8bc0400  ! 4933: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xdab44400  ! 4934: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	mov	0x3d8, %r22
	.word 0xd4af4e60  ! 4936: STBA_R	stba	%r10, [%r29 + %r0] 0x73
	mov	0x30, %r27
	.word 0xd8974e40  ! 4938: LDUHA_R	lduha	[%r29, %r0] 0x72, %r12
	.word 0x87802073  ! 4939: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e0, %r20
	.word 0x87802072  ! 4941: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd89c0400  ! 4942: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	.word 0xd2f70e60  ! 4943: STXA_R	stxa	%r9, [%r28 + %r0] 0x73
	.word 0x87802020  ! 4944: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28ce000  ! 4945: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	.word 0xd2970e80  ! 4946: LDUHA_R	lduha	[%r28, %r0] 0x74, %r9
	.word 0xd8bf8e60  ! 4947: STDA_R	stda	%r12, [%r30 + %r0] 0x73
	.word 0x87802074  ! 4948: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d8, %r20
	.word 0x87802073  ! 4950: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8c76000  ! 4951: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	.word 0xde8d84a0  ! 4952: LDUBA_R	lduba	[%r22, %r0] 0x25, %r15
	mov	0x8, %r16
	.word 0x87802020  ! 4954: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf5c4a0  ! 4955: STXA_R	stxa	%r14, [%r23 + %r0] 0x25
	.word 0xd88f4e40  ! 4956: LDUBA_R	lduba	[%r29, %r0] 0x72, %r12
	mov	0x18, %r18
	.word 0xd2d78e40  ! 4958: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r9
	.word 0xde8c8400  ! 4959: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	.word 0x87802025  ! 4960: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4961: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4962: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f4c400  ! 4963: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xd2a46000  ! 4964: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xde9c0400  ! 4965: LDDA_R	ldda	[%r16, %r0] 0x20, %r15
	.word 0xd09d84a0  ! 4966: LDDA_R	ldda	[%r22, %r0] 0x25, %r8
	mov	0x3c0, %r21
	.word 0x87802074  ! 4968: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0cfe000  ! 4969: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0x87802074  ! 4970: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3f0, %r22
	.word 0xdad40400  ! 4972: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	mov	0x48, %r19
	.word 0xdaf7a000  ! 4974: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	mov	0x40, %r24
	.word 0xdaa76000  ! 4976: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xdc8c0400  ! 4977: LDUBA_R	lduba	[%r16, %r0] 0x20, %r14
	mov	0x7f0, %r20
	mov	0x40, %r18
	.word 0xdcd7e000  ! 4980: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xd6f504a0  ! 4981: STXA_R	stxa	%r11, [%r20 + %r0] 0x25
	.word 0xd6a76000  ! 4982: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 4983: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r18
	mov	0x20, %r24
	.word 0xd68c2000  ! 4986: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r11
	.word 0xd69c6000  ! 4987: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r11
	.word 0xd29fce40  ! 4988: LDDA_R	ldda	[%r31, %r0] 0x72, %r9
	.word 0xd4a44400  ! 4989: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xda9ec9e0  ! 4990: LDDA_R	ldda	[%r27, %r0] 0x4f, %r13
	.word 0xda9ca000  ! 4991: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	.word 0xdac4e000  ! 4992: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r13
	.word 0x87802072  ! 4993: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab74e60  ! 4994: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	.word 0xdcaf0e60  ! 4995: STBA_R	stba	%r14, [%r28 + %r0] 0x73
	.word 0xdcd7e000  ! 4996: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xd2bf0e40  ! 4997: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	.word 0x87802020  ! 4998: WRASI_I	wr	%r0, 0x0020, %asi
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_3:
	.word 0xdebd84a0  ! 1: STDA_R	stda	%r15, [%r22 + %r0] 0x25
	.word 0xd6ce2000  ! 2: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	.word 0xdabc4400  ! 3: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xd0b6e000  ! 4: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0d66000  ! 6: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r8
	mov	0x7c0, %r22
	.word 0xd0bee000  ! 8: STDA_I	stda	%r8, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 9: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ad84a0  ! 10: STBA_R	stba	%r10, [%r22 + %r0] 0x25
	.word 0xd6944400  ! 11: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	.word 0xda9f6000  ! 12: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	mov	0x20, %r18
	.word 0x87802074  ! 14: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 15: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf7ce60  ! 16: STXA_R	stxa	%r13, [%r31 + %r0] 0x73
	.word 0xd2dc0400  ! 17: LDXA_R	ldxa	[%r16, %r0] 0x20, %r9
	.word 0xd0de6000  ! 18: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r8
	.word 0xd0c6a000  ! 19: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r8
	.word 0xd88fce40  ! 20: LDUBA_R	lduba	[%r31, %r0] 0x72, %r12
	.word 0xd28fce40  ! 21: LDUBA_R	lduba	[%r31, %r0] 0x72, %r9
	.word 0xdeb62000  ! 22: STHA_I	stha	%r15, [%r24 + 0x0000] %asi
	mov	0x8, %r16
	.word 0xde96e000  ! 24: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r15
	.word 0x87802020  ! 25: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde86a000  ! 26: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r15
	.word 0xdcdd84a0  ! 27: LDXA_R	ldxa	[%r22, %r0] 0x25, %r14
	mov	0x30, %r18
	.word 0x87802072  ! 29: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf649e0  ! 30: STXA_R	stxa	%r13, [%r25 + %r0] 0x4f
	.word 0xdc874e60  ! 31: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r14
	.word 0x8780204f  ! 32: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0d6c9e0  ! 33: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r8
	.word 0xd4a584a0  ! 34: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	mov	0x3d8, %r22
	.word 0xde8e2000  ! 36: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r15
	mov	0x40, %r26
	.word 0xd685c4a0  ! 38: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r11
	.word 0xd2c70e80  ! 39: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r9
	mov	0x3f0, %r23
	mov	0x10, %r25
	.word 0xda9d84a0  ! 42: LDDA_R	ldda	[%r22, %r0] 0x25, %r13
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd6ae89e0  ! 44: STBA_R	stba	%r11, [%r26 + %r0] 0x4f
	.word 0xd6bea000  ! 45: STDA_I	stda	%r11, [%r26 + 0x0000] %asi
	.word 0xdcf74e60  ! 46: STXA_R	stxa	%r14, [%r29 + %r0] 0x73
	.word 0xd48c4400  ! 47: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0xd486a000  ! 48: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r10
	mov	0x70, %r27
	.word 0xdeb5c4a0  ! 50: STHA_R	stha	%r15, [%r23 + %r0] 0x25
	.word 0x8780204f  ! 51: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 52: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r24
	mov	0x40, %r19
	.word 0xda946000  ! 55: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	.word 0x87802072  ! 56: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd08f0e60  ! 57: LDUBA_R	lduba	[%r28, %r0] 0x73, %r8
	.word 0xdc872000  ! 58: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0x87802020  ! 59: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r17
	.word 0x87802072  ! 61: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd48c4400  ! 62: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	mov	0x20, %r27
	ta	T_CHANGE_NONHPRIV	! macro
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdcf70e40  ! 66: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	.word 0x87802025  ! 67: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4bf8e40  ! 68: STDA_R	stda	%r10, [%r30 + %r0] 0x72
	.word 0xd8dc8400  ! 69: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xd2aca000  ! 70: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0xdaa649e0  ! 71: STWA_R	stwa	%r13, [%r25 + %r0] 0x4f
	.word 0xd8c42000  ! 72: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r12
	mov	0x58, %r27
	.word 0xd0df4e80  ! 74: LDXA_R	ldxa	[%r29, %r0] 0x74, %r8
	.word 0xd8b74e80  ! 75: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	.word 0xd2a78e60  ! 76: STWA_R	stwa	%r9, [%r30 + %r0] 0x73
	mov	0x78, %r17
	mov	0x3d8, %r20
	.word 0x87802074  ! 79: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde97a000  ! 80: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	mov	0x60, %r27
	.word 0xd8dd44a0  ! 82: LDXA_R	ldxa	[%r21, %r0] 0x25, %r12
	.word 0xd2f544a0  ! 83: STXA_R	stxa	%r9, [%r21 + %r0] 0x25
	mov	0x10, %r27
	.word 0xd4cf2000  ! 85: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0x87802020  ! 86: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r22
	.word 0xdca7ce60  ! 88: STWA_R	stwa	%r14, [%r31 + %r0] 0x73
	.word 0xdaa72000  ! 89: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xda872000  ! 90: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0xdcad44a0  ! 91: STBA_R	stba	%r14, [%r21 + %r0] 0x25
	mov	0x10, %r19
	.word 0x87802025  ! 93: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 94: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f4c400  ! 95: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xd6f74e60  ! 96: STXA_R	stxa	%r11, [%r29 + %r0] 0x73
	.word 0xdc8ea000  ! 97: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r14
	.word 0xd6dfce80  ! 98: LDXA_R	ldxa	[%r31, %r0] 0x74, %r11
	.word 0xdc86a000  ! 99: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r14
	mov	0x58, %r18
	.word 0xd484c400  ! 101: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	.word 0xd4a6e000  ! 102: STWA_I	stwa	%r10, [%r27 + 0x0000] %asi
	mov	0x3c8, %r22
	mov	0x7c0, %r22
	.word 0xd4d70e80  ! 105: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r10
	.word 0xd88e6000  ! 106: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r12
	.word 0xded504a0  ! 107: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r15
	.word 0xd08504a0  ! 108: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r8
	mov	0x18, %r17
	mov	0x0, %r26
	.word 0x87802073  ! 111: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 112: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd29e6000  ! 113: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r9
	.word 0xd8a6c9e0  ! 114: STWA_R	stwa	%r12, [%r27 + %r0] 0x4f
	.word 0xdedee000  ! 115: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r15
	.word 0xd6f5c4a0  ! 116: STXA_R	stxa	%r11, [%r23 + %r0] 0x25
	.word 0xd2d74e40  ! 117: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r9
	mov	0x8, %r16
	.word 0x87802020  ! 119: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef40400  ! 120: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0xd8a78e80  ! 121: STWA_R	stwa	%r12, [%r30 + %r0] 0x74
	mov	0x50, %r26
	.word 0xdec76000  ! 123: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xd6f7ce80  ! 124: STXA_R	stxa	%r11, [%r31 + %r0] 0x74
	.word 0x8780204f  ! 125: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2aee000  ! 126: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	.word 0xde8fce60  ! 127: LDUBA_R	lduba	[%r31, %r0] 0x73, %r15
	mov	0x3f8, %r23
	.word 0xd886a000  ! 129: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r12
	mov	0x70, %r26
	mov	0x28, %r18
	.word 0xdaa74e80  ! 132: STWA_R	stwa	%r13, [%r29 + %r0] 0x74
	mov	0x0, %r24
	.word 0x87802020  ! 134: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0be89e0  ! 135: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	.word 0xd4b609e0  ! 136: STHA_R	stha	%r10, [%r24 + %r0] 0x4f
	mov	0x70, %r25
	.word 0x8780204f  ! 138: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdecf6000  ! 139: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0xdec72000  ! 140: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xdc9ec9e0  ! 141: LDDA_R	ldda	[%r27, %r0] 0x4f, %r14
	.word 0xd28f2000  ! 142: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	.word 0x87802072  ! 143: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0d4c400  ! 144: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	.word 0xd684c400  ! 145: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	mov	0x3e0, %r21
	.word 0x87802073  ! 147: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca70e80  ! 148: STWA_R	stwa	%r14, [%r28 + %r0] 0x74
	.word 0xd0bce000  ! 149: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 150: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 151: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r22
	mov	0x40, %r27
	.word 0xd09fe000  ! 154: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	.word 0xd0d7a000  ! 155: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	mov	0x3d0, %r21
	.word 0x87802025  ! 157: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0aca000  ! 158: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xda86c9e0  ! 159: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r13
	.word 0xd6ce09e0  ! 160: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r11
	.word 0xdcbcc400  ! 161: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xd8ac2000  ! 162: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 163: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8d52000  ! 164: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r12
	.word 0xd8b5e000  ! 165: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	.word 0xd8856000  ! 166: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	.word 0xd0ad44a0  ! 167: STBA_R	stba	%r8, [%r21 + %r0] 0x25
	.word 0xd6bd2000  ! 168: STDA_I	stda	%r11, [%r20 + 0x0000] %asi
	.word 0xd6bd6000  ! 169: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0xdac40400  ! 170: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	mov	0x48, %r25
	.word 0xd2f56000  ! 172: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	mov	0x7d0, %r20
	mov	0x38, %r24
	mov	0x7f8, %r23
	mov	0x3d8, %r23
	mov	0x10, %r24
	.word 0xd6b70e80  ! 178: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	mov	0x3e8, %r20
	.word 0xd0a56000  ! 180: STWA_I	stwa	%r8, [%r21 + 0x0000] %asi
	.word 0xdef48400  ! 181: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xdcac0400  ! 182: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0x87802025  ! 183: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcdf6000  ! 184: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xdccfe000  ! 185: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xdcc7a000  ! 186: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0x87802020  ! 187: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r25
	mov	0x3f0, %r21
	.word 0xdcb4e000  ! 190: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xd4cf0e60  ! 191: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r10
	.word 0xd69ce000  ! 192: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r11
	.word 0xdac40400  ! 193: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	mov	0x10, %r26
	mov	0x3c0, %r20
	.word 0x87802074  ! 196: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e8, %r23
	mov	0x7d0, %r22
	mov	0x48, %r17
	.word 0xd6ad2000  ! 200: STBA_I	stba	%r11, [%r20 + 0x0000] %asi
	.word 0xd6ad6000  ! 201: STBA_I	stba	%r11, [%r21 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xd8c74e40  ! 203: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r12
	.word 0xd8dde000  ! 204: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r12
	.word 0xd0b544a0  ! 205: STHA_R	stha	%r8, [%r21 + %r0] 0x25
	.word 0x8780204f  ! 206: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c0, %r22
	.word 0xd6bf0e80  ! 208: STDA_R	stda	%r11, [%r28 + %r0] 0x74
	.word 0xdcc504a0  ! 209: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r14
	.word 0xdedc0400  ! 210: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	.word 0xde8de000  ! 211: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r15
	.word 0xdeb5a000  ! 212: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	mov	0x48, %r27
	.word 0xdef5c4a0  ! 214: STXA_R	stxa	%r15, [%r23 + %r0] 0x25
	.word 0xdcd44400  ! 215: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	mov	0x7c0, %r23
	.word 0xd0dd2000  ! 217: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0xdcad84a0  ! 218: STBA_R	stba	%r14, [%r22 + %r0] 0x25
	mov	0x3c0, %r22
	.word 0xd4c52000  ! 220: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r10
	.word 0xdcb78e80  ! 221: STHA_R	stha	%r14, [%r30 + %r0] 0x74
	mov	0x68, %r27
	mov	0x58, %r27
	mov	0x3e8, %r20
	mov	0x68, %r16
	.word 0x87802072  ! 226: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2c649e0  ! 227: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r9
	.word 0xdc9609e0  ! 228: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r14
	mov	0x7c8, %r20
	.word 0xde8f0e80  ! 230: LDUBA_R	lduba	[%r28, %r0] 0x74, %r15
	.word 0x87802020  ! 231: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c7ce80  ! 232: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r10
	.word 0xdcbfe000  ! 233: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	mov	0x20, %r17
	.word 0xdc9f2000  ! 235: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xdc8fa000  ! 236: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdca7e000  ! 237: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 238: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b584a0  ! 239: STHA_R	stha	%r11, [%r22 + %r0] 0x25
	mov	0x8, %r27
	.word 0xdaf48400  ! 241: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xd0b6c9e0  ! 242: STHA_R	stha	%r8, [%r27 + %r0] 0x4f
	mov	0x10, %r16
	mov	0x7c8, %r20
	mov	0x7f0, %r20
	mov	0x18, %r16
	mov	0x3f8, %r23
	.word 0xdcac0400  ! 248: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xdcbf2000  ! 249: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xd6b544a0  ! 250: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	mov	0x3d0, %r22
	.word 0x87802072  ! 252: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r16
	.word 0xd287e000  ! 254: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0xd897ce40  ! 255: LDUHA_R	lduha	[%r31, %r0] 0x72, %r12
	.word 0xd887a000  ! 256: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xd4f7ce40  ! 257: STXA_R	stxa	%r10, [%r31 + %r0] 0x72
	mov	0x7f0, %r20
	.word 0xde844400  ! 259: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	.word 0xdef4c400  ! 260: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xdcd7e000  ! 261: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xdc9f6000  ! 262: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xd28544a0  ! 263: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r9
	.word 0x87802020  ! 264: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd697e000  ! 265: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 266: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r24
	.word 0xd8a4c400  ! 268: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xd2ae89e0  ! 269: STBA_R	stba	%r9, [%r26 + %r0] 0x4f
	.word 0xd2f504a0  ! 270: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	mov	0x7d0, %r22
	.word 0x87802025  ! 272: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdab6c9e0  ! 273: STHA_R	stha	%r13, [%r27 + %r0] 0x4f
	.word 0xd0874e60  ! 274: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r8
	.word 0xdca504a0  ! 275: STWA_R	stwa	%r14, [%r20 + %r0] 0x25
	.word 0xdc976000  ! 276: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	.word 0xdcb72000  ! 277: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xd4dfce80  ! 278: LDXA_R	ldxa	[%r31, %r0] 0x74, %r10
	.word 0x8780204f  ! 279: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r17
	.word 0x87802072  ! 281: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r16
	.word 0xd0c7ce80  ! 283: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r8
	.word 0xdcdcc400  ! 284: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	.word 0xdccfa000  ! 285: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xdef70e80  ! 286: STXA_R	stxa	%r15, [%r28 + %r0] 0x74
	.word 0xd6dfe000  ! 287: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 288: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r17
	.word 0x87802072  ! 290: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4bcc400  ! 291: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	mov	0x3c0, %r20
	.word 0x87802020  ! 293: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac62000  ! 294: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r13
	.word 0xdab6e000  ! 295: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	.word 0xd8d649e0  ! 296: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r12
	.word 0xd0cf0e60  ! 297: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r8
	mov	0x3e0, %r22
	mov	0x3f8, %r22
	.word 0xd2c66000  ! 300: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r9
	.word 0xd2f6e000  ! 301: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	.word 0xdab78e80  ! 302: STHA_R	stha	%r13, [%r30 + %r0] 0x74
	mov	0x78, %r26
	.word 0xdebee000  ! 304: STDA_I	stda	%r15, [%r27 + 0x0000] %asi
	.word 0xdece2000  ! 305: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r15
	.word 0xdeae6000  ! 306: STBA_I	stba	%r15, [%r25 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x20, %r25
	.word 0xde8ee000  ! 309: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r15
	.word 0x87802072  ! 310: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f8, %r22
	.word 0x87802025  ! 312: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 313: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde9fe000  ! 314: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0xdedfa000  ! 315: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x3c8, %r23
	.word 0xdabc8400  ! 317: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	.word 0xd0c7a000  ! 318: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0cf6000  ! 319: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd2bf4e40  ! 320: STDA_R	stda	%r9, [%r29 + %r0] 0x72
	mov	0x40, %r17
	.word 0xd4cfa000  ! 322: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0xd4a76000  ! 323: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	mov	0x3c0, %r22
	mov	0x20, %r17
	mov	0x7e0, %r20
	.word 0xdedc8400  ! 327: LDXA_R	ldxa	[%r18, %r0] 0x20, %r15
	.word 0xd4dfce80  ! 328: LDXA_R	ldxa	[%r31, %r0] 0x74, %r10
	mov	0x30, %r17
	.word 0xd8f48400  ! 330: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xdcce09e0  ! 331: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r14
	mov	0x3f8, %r22
	.word 0xdec76000  ! 333: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xdec7a000  ! 334: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xd2c70e40  ! 335: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r9
	.word 0xd6f6c9e0  ! 336: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	.word 0x8780204f  ! 337: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 338: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd89ca000  ! 339: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r12
	.word 0xd8b4e000  ! 340: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0xd8f42000  ! 341: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8a4a000  ! 342: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 343: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdea78e60  ! 344: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	.word 0x87802020  ! 345: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 346: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea62000  ! 347: STWA_I	stwa	%r15, [%r24 + 0x0000] %asi
	mov	0x7f8, %r22
	.word 0xd89cc400  ! 349: LDDA_R	ldda	[%r19, %r0] 0x20, %r12
	.word 0xd8af4e80  ! 350: STBA_R	stba	%r12, [%r29 + %r0] 0x74
	.word 0x87802073  ! 351: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2cde000  ! 352: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r9
	.word 0xdc948400  ! 353: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	.word 0xd8f70e40  ! 354: STXA_R	stxa	%r12, [%r28 + %r0] 0x72
	.word 0xde970e80  ! 355: LDUHA_R	lduha	[%r28, %r0] 0x74, %r15
	mov	0x7c0, %r20
	.word 0xd8ade000  ! 357: STBA_I	stba	%r12, [%r23 + 0x0000] %asi
	.word 0xd8c52000  ! 358: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r12
	.word 0xd885a000  ! 359: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r12
	.word 0xd0f74e40  ! 360: STXA_R	stxa	%r8, [%r29 + %r0] 0x72
	mov	0x48, %r16
	mov	0x18, %r24
	.word 0xdcb5e000  ! 363: STHA_I	stha	%r14, [%r23 + 0x0000] %asi
	.word 0xdcb5e000  ! 364: STHA_I	stha	%r14, [%r23 + 0x0000] %asi
	.word 0xdab74e40  ! 365: STHA_R	stha	%r13, [%r29 + %r0] 0x72
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x48, %r17
	.word 0xd6a52000  ! 368: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	.word 0xdaf44400  ! 369: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0x87802020  ! 370: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 371: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd69fce40  ! 372: LDDA_R	ldda	[%r31, %r0] 0x72, %r11
	.word 0x87802072  ! 373: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda874e60  ! 374: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r13
	.word 0xd2b44400  ! 375: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0x87802020  ! 376: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bde000  ! 377: STDA_I	stda	%r11, [%r23 + 0x0000] %asi
	mov	0x68, %r26
	.word 0xd6bd6000  ! 379: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0xd6cd2000  ! 380: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r11
	.word 0xd4d649e0  ! 381: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r10
	.word 0x87802020  ! 382: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedc4400  ! 383: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	.word 0xdcbfe000  ! 384: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdcd7e000  ! 385: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdab504a0  ! 387: STHA_R	stha	%r13, [%r20 + %r0] 0x25
	.word 0xd0cc8400  ! 388: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	mov	0x18, %r27
	.word 0xd4dfa000  ! 390: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	mov	0x48, %r24
	.word 0xd4870e60  ! 392: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r10
	.word 0xd68fce40  ! 393: LDUBA_R	lduba	[%r31, %r0] 0x72, %r11
	.word 0x8780204f  ! 394: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6dc0400  ! 395: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	.word 0xd6f76000  ! 396: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6bfa000  ! 397: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd6be89e0  ! 398: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	.word 0xdcf76000  ! 399: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcd7e000  ! 400: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xdccc8400  ! 401: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	.word 0xd0bcc400  ! 402: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0xdcaf4e80  ! 403: STBA_R	stba	%r14, [%r29 + %r0] 0x74
	.word 0x87802073  ! 404: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f0, %r22
	.word 0xd4a74e60  ! 406: STWA_R	stwa	%r10, [%r29 + %r0] 0x73
	mov	0x0, %r24
	.word 0x87802020  ! 408: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabf2000  ! 409: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xd2be49e0  ! 410: STDA_R	stda	%r9, [%r25 + %r0] 0x4f
	.word 0xd6c40400  ! 411: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r11
	.word 0xdeb7ce60  ! 412: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	mov	0x78, %r27
	mov	0x3f8, %r23
	mov	0x7c8, %r22
	mov	0x70, %r25
	.word 0x87802020  ! 417: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r22
	mov	0x7c8, %r21
	.word 0xd4bce000  ! 420: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0xd4dca000  ! 421: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	.word 0xd4f46000  ! 422: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0xd49ca000  ! 423: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	mov	0x7c8, %r23
	.word 0x87802020  ! 425: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cf2000  ! 426: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	mov	0x3f0, %r22
	.word 0xd4af4e40  ! 428: STBA_R	stba	%r10, [%r29 + %r0] 0x72
	mov	0x3e8, %r20
	.word 0xdcaf4e80  ! 430: STBA_R	stba	%r14, [%r29 + %r0] 0x74
	.word 0xdcbf4e40  ! 431: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	.word 0xdeb76000  ! 432: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	mov	0x70, %r24
	.word 0x8780204f  ! 434: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4940400  ! 435: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdc970e40  ! 437: LDUHA_R	lduha	[%r28, %r0] 0x72, %r14
	.word 0x87802074  ! 438: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d8, %r21
	.word 0x87802073  ! 440: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6cc8400  ! 441: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	.word 0x87802073  ! 442: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4d7a000  ! 443: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	mov	0x18, %r24
	mov	0x7d8, %r21
	.word 0xd4c7e000  ! 446: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4b76000  ! 447: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 448: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 449: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb70e40  ! 450: STHA_R	stha	%r14, [%r28 + %r0] 0x72
	.word 0xd0ac2000  ! 451: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xd09f4e40  ! 452: LDDA_R	ldda	[%r29, %r0] 0x72, %r8
	mov	0x38, %r19
	.word 0x87802074  ! 454: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3f0, %r21
	.word 0xd6a4c400  ! 456: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0xd89f8e60  ! 457: LDDA_R	ldda	[%r30, %r0] 0x73, %r12
	.word 0xd69689e0  ! 458: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r11
	.word 0xd297a000  ! 459: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	.word 0xd68c0400  ! 460: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	.word 0xd4bf2000  ! 461: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	mov	0x30, %r18
	.word 0xd4a76000  ! 463: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0x87802025  ! 465: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f5c4a0  ! 466: STXA_R	stxa	%r8, [%r23 + %r0] 0x25
	mov	0x7e8, %r23
	.word 0xdef40400  ! 468: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0xd4b5c4a0  ! 469: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	.word 0xd2862000  ! 470: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r9
	.word 0x87802020  ! 471: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bf2000  ! 472: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xdaa40400  ! 473: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0xd6dfce40  ! 474: LDXA_R	ldxa	[%r31, %r0] 0x72, %r11
	mov	0x50, %r16
	.word 0xd29f2000  ! 476: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd29f2000  ! 477: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd68fce60  ! 478: LDUBA_R	lduba	[%r31, %r0] 0x73, %r11
	mov	0x70, %r26
	.word 0xd0974e80  ! 480: LDUHA_R	lduha	[%r29, %r0] 0x74, %r8
	mov	0x40, %r27
	.word 0xd4bf2000  ! 482: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd48fce60  ! 483: LDUBA_R	lduba	[%r31, %r0] 0x73, %r10
	.word 0xd6bc0400  ! 484: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0x87802025  ! 485: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4f52000  ! 486: STXA_I	stxa	%r10, [%r20 + 0x0000] %asi
	.word 0x8780204f  ! 487: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 488: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcaf8e60  ! 489: STBA_R	stba	%r14, [%r30 + %r0] 0x73
	.word 0xda8f0e80  ! 490: LDUBA_R	lduba	[%r28, %r0] 0x74, %r13
	.word 0xdab7a000  ! 491: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 492: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r27
	mov	0x3f8, %r23
	.word 0xdab6a000  ! 495: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	.word 0xdad62000  ! 496: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r13
	.word 0xde9f0e60  ! 497: LDDA_R	ldda	[%r28, %r0] 0x73, %r15
	.word 0x87802020  ! 498: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 499: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4af0e60  ! 500: STBA_R	stba	%r10, [%r28 + %r0] 0x73
	mov	0x78, %r18
	mov	0x18, %r26
	.word 0x87802020  ! 503: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 504: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6ac0400  ! 505: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0xdeac2000  ! 506: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xde9c6000  ! 507: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0xde9c2000  ! 508: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xdeb4a000  ! 509: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0xdebc2000  ! 510: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xdeb42000  ! 511: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	mov	0x7c0, %r21
	.word 0xdeaca000  ! 513: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xd4cf4e60  ! 514: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r10
	mov	0x10, %r26
	.word 0x87802020  ! 516: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r16
	mov	0x10, %r24
	.word 0xd2d48400  ! 519: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	.word 0xd8cde000  ! 520: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r12
	.word 0xd8f5e000  ! 521: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	.word 0xdca5c4a0  ! 522: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	.word 0xdc8d84a0  ! 523: LDUBA_R	lduba	[%r22, %r0] 0x25, %r14
	.word 0xdab5a000  ! 524: STHA_I	stha	%r13, [%r22 + 0x0000] %asi
	mov	0x38, %r18
	.word 0xdaa544a0  ! 526: STWA_R	stwa	%r13, [%r21 + %r0] 0x25
	mov	0x48, %r19
	mov	0x40, %r17
	.word 0x87802074  ! 529: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f70e40  ! 530: STXA_R	stxa	%r9, [%r28 + %r0] 0x72
	.word 0xdeb46000  ! 531: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 532: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r27
	.word 0xde9d6000  ! 534: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r15
	.word 0xde9da000  ! 535: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r15
	.word 0xd28e09e0  ! 536: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r9
	.word 0x87802074  ! 537: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f5a000  ! 538: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	.word 0xd2f5a000  ! 539: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	.word 0xd2a40400  ! 540: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	mov	0x38, %r17
	mov	0x48, %r18
	mov	0x7d0, %r22
	.word 0x87802074  ! 544: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2be49e0  ! 545: STDA_R	stda	%r9, [%r25 + %r0] 0x4f
	.word 0xd4b584a0  ! 546: STHA_R	stha	%r10, [%r22 + %r0] 0x25
	mov	0x3f8, %r21
	mov	0x50, %r17
	mov	0x7d8, %r22
	.word 0xd8cc6000  ! 550: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r12
	.word 0x87802073  ! 551: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r17
	.word 0xd8a42000  ! 553: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 554: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4970e40  ! 555: LDUHA_R	lduha	[%r28, %r0] 0x72, %r10
	.word 0xdecc6000  ! 556: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r15
	.word 0xd2840400  ! 557: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r9
	.word 0x87802074  ! 558: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabd2000  ! 559: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	.word 0x8780204f  ! 560: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xded48400  ! 561: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	.word 0xd8a66000  ! 562: STWA_I	stwa	%r12, [%r25 + 0x0000] %asi
	.word 0xd8aee000  ! 563: STBA_I	stba	%r12, [%r27 + 0x0000] %asi
	.word 0xdad78e80  ! 564: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r13
	.word 0xdab689e0  ! 565: STHA_R	stha	%r13, [%r26 + %r0] 0x4f
	.word 0xdebf4e60  ! 566: STDA_R	stda	%r15, [%r29 + %r0] 0x73
	.word 0xd08ea000  ! 567: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r8
	.word 0xd0d66000  ! 568: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 569: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0df6000  ! 570: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	mov	0x48, %r18
	.word 0xd0f72000  ! 572: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	mov	0x48, %r26
	mov	0x0, %r24
	mov	0x3d0, %r21
	.word 0x87802020  ! 576: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a72000  ! 577: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xd4af8e60  ! 579: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	.word 0xdcafce60  ! 580: STBA_R	stba	%r14, [%r31 + %r0] 0x73
	.word 0xdebfe000  ! 581: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xdeafa000  ! 582: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	mov	0x8, %r19
	.word 0xd8b649e0  ! 584: STHA_R	stha	%r12, [%r25 + %r0] 0x4f
	.word 0xd8874e80  ! 585: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r12
	.word 0x87802074  ! 586: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabe49e0  ! 587: STDA_R	stda	%r13, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 588: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r27
	.word 0xdcdee000  ! 590: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r14
	.word 0xd2cf4e60  ! 591: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r9
	.word 0xd0bea000  ! 592: STDA_I	stda	%r8, [%r26 + 0x0000] %asi
	.word 0xd0c6e000  ! 593: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r8
	.word 0xde8609e0  ! 594: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r15
	.word 0xd6f6a000  ! 595: STXA_I	stxa	%r11, [%r26 + 0x0000] %asi
	.word 0xd696e000  ! 596: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	.word 0xd29d84a0  ! 597: LDDA_R	ldda	[%r22, %r0] 0x25, %r9
	.word 0xd0ad84a0  ! 598: STBA_R	stba	%r8, [%r22 + %r0] 0x25
	.word 0xd0bcc400  ! 599: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	mov	0x38, %r18
	.word 0x8780204f  ! 601: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x48, %r16
	.word 0xd8b4c400  ! 603: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	mov	0x58, %r27
	.word 0xdadca000  ! 605: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	mov	0x58, %r27
	.word 0x87802020  ! 607: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad4a000  ! 608: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0xda9c2000  ! 609: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	.word 0xdab4a000  ! 610: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	mov	0x60, %r26
	.word 0xd0870e80  ! 612: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r8
	.word 0xdc94e000  ! 613: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	.word 0xdad44400  ! 614: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0xd09ca000  ! 615: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	.word 0xd084a000  ! 616: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0cc6000  ! 617: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	.word 0xdadf8e40  ! 618: LDXA_R	ldxa	[%r30, %r0] 0x72, %r13
	.word 0xd0f4a000  ! 619: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	mov	0x8, %r19
	.word 0xd2970e40  ! 621: LDUHA_R	lduha	[%r28, %r0] 0x72, %r9
	mov	0x70, %r24
	.word 0xd29c2000  ! 623: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	mov	0x18, %r27
	.word 0xd2cf4e80  ! 625: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r9
	.word 0xd0bce000  ! 626: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	mov	0x7c8, %r21
	.word 0xd0dce000  ! 628: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r8
	.word 0xd08ce000  ! 629: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0f609e0  ! 630: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	.word 0xdc84e000  ! 631: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r14
	.word 0xdeb7ce60  ! 632: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	.word 0xdac70e40  ! 633: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r13
	.word 0xde94e000  ! 634: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	.word 0x87802072  ! 635: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 636: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xded70e40  ! 637: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r15
	mov	0x20, %r25
	.word 0xd69f0e60  ! 639: LDDA_R	ldda	[%r28, %r0] 0x73, %r11
	.word 0xdc8c4400  ! 640: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0xdc87ce60  ! 641: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r14
	mov	0x3f8, %r23
	.word 0xd8bcc400  ! 643: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0xdeaca000  ! 644: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xde84e000  ! 645: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	.word 0xd4ac0400  ! 646: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0x87802025  ! 647: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 648: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r18
	mov	0x48, %r27
	.word 0xd2c46000  ! 651: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0xd09d44a0  ! 652: LDDA_R	ldda	[%r21, %r0] 0x25, %r8
	mov	0x3c8, %r23
	mov	0x0, %r27
	.word 0xd8f7ce40  ! 655: STXA_R	stxa	%r12, [%r31 + %r0] 0x72
	.word 0x87802020  ! 656: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb72000  ! 657: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	mov	0x40, %r26
	.word 0xdec72000  ! 659: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	mov	0x0, %r24
	mov	0x70, %r16
	.word 0xd6d649e0  ! 662: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r11
	mov	0x7c0, %r22
	.word 0xd2bfe000  ! 664: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 665: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8aec9e0  ! 666: STBA_R	stba	%r12, [%r27 + %r0] 0x4f
	.word 0xde8c2000  ! 667: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	.word 0xde9ce000  ! 668: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0xdeaf8e40  ! 669: STBA_R	stba	%r15, [%r30 + %r0] 0x72
	.word 0xd894a000  ! 670: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r12
	mov	0x10, %r17
	.word 0xdabc0400  ! 672: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	mov	0x58, %r25
	.word 0xdccf0e60  ! 674: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r14
	.word 0xdab7ce80  ! 675: STHA_R	stha	%r13, [%r31 + %r0] 0x74
	.word 0xde9ca000  ! 676: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	.word 0xdec4a000  ! 677: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xd28f8e60  ! 678: LDUBA_R	lduba	[%r30, %r0] 0x73, %r9
	.word 0x87802074  ! 679: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 680: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d0, %r22
	.word 0xda8f2000  ! 682: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xdcbdc4a0  ! 683: STDA_R	stda	%r14, [%r23 + %r0] 0x25
	.word 0x87802073  ! 684: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r19
	.word 0xdaa7ce80  ! 686: STWA_R	stwa	%r13, [%r31 + %r0] 0x74
	.word 0x87802073  ! 687: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r17
	.word 0xd0b66000  ! 689: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	.word 0xd6f70e40  ! 690: STXA_R	stxa	%r11, [%r28 + %r0] 0x72
	.word 0xd4f4c400  ! 691: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	mov	0x48, %r19
	.word 0xd8dee000  ! 693: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r12
	.word 0x87802025  ! 694: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802020  ! 696: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 697: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r19
	.word 0x87802072  ! 699: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r27
	.word 0xd8972000  ! 701: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	mov	0x30, %r26
	mov	0x7e8, %r22
	.word 0x87802072  ! 704: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 705: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bc4400  ! 706: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0xde9ec9e0  ! 707: LDDA_R	ldda	[%r27, %r0] 0x4f, %r15
	.word 0xd8cfa000  ! 708: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd8f72000  ! 709: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 710: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcdfce80  ! 711: LDXA_R	ldxa	[%r31, %r0] 0x74, %r14
	mov	0x30, %r25
	.word 0xd8b78e40  ! 713: STHA_R	stha	%r12, [%r30 + %r0] 0x72
	mov	0x38, %r16
	.word 0x87802020  ! 715: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8de2000  ! 716: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r12
	.word 0xd8be6000  ! 717: STDA_I	stda	%r12, [%r25 + 0x0000] %asi
	.word 0x87802025  ! 718: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdedec9e0  ! 719: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r15
	.word 0xdcbcc400  ! 720: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	mov	0x28, %r26
	mov	0x7e0, %r22
	.word 0x87802072  ! 723: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d8, %r23
	mov	0x68, %r24
	.word 0xd6f6e000  ! 726: STXA_I	stxa	%r11, [%r27 + 0x0000] %asi
	.word 0xd68ee000  ! 727: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r11
	.word 0xd6f66000  ! 728: STXA_I	stxa	%r11, [%r25 + 0x0000] %asi
	mov	0x58, %r27
	mov	0x68, %r19
	mov	0x8, %r24
	.word 0x87802072  ! 732: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb584a0  ! 733: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	.word 0xd6d78e80  ! 734: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r11
	mov	0x78, %r26
	.word 0xdeb56000  ! 736: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	.word 0xdeb52000  ! 737: STHA_I	stha	%r15, [%r20 + 0x0000] %asi
	mov	0x48, %r25
	.word 0xd0f78e40  ! 739: STXA_R	stxa	%r8, [%r30 + %r0] 0x72
	mov	0x0, %r25
	mov	0x60, %r25
	.word 0xdeb74e80  ! 742: STHA_R	stha	%r15, [%r29 + %r0] 0x74
	.word 0x8780204f  ! 743: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd08d2000  ! 744: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r8
	.word 0xdeb44400  ! 745: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	mov	0x60, %r25
	.word 0xd69da000  ! 747: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r11
	.word 0xd2b74e40  ! 748: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	mov	0x10, %r17
	.word 0xd6ad84a0  ! 750: STBA_R	stba	%r11, [%r22 + %r0] 0x25
	.word 0x8780204f  ! 751: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x48, %r27
	.word 0x87802072  ! 753: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f74e80  ! 754: STXA_R	stxa	%r9, [%r29 + %r0] 0x74
	mov	0x58, %r18
	.word 0xd2af0e40  ! 756: STBA_R	stba	%r9, [%r28 + %r0] 0x72
	.word 0x87802020  ! 757: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r20
	.word 0x87802025  ! 759: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4bd6000  ! 760: STDA_I	stda	%r10, [%r21 + 0x0000] %asi
	.word 0xdaf7ce60  ! 761: STXA_R	stxa	%r13, [%r31 + %r0] 0x73
	.word 0xdecda000  ! 762: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r15
	.word 0xde8de000  ! 763: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r15
	mov	0x8, %r17
	.word 0xdedd6000  ! 765: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r15
	.word 0xdef52000  ! 766: STXA_I	stxa	%r15, [%r20 + 0x0000] %asi
	.word 0xdedda000  ! 767: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r15
	.word 0xdea5e000  ! 768: STWA_I	stwa	%r15, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 769: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r18
	.word 0xd6cdc4a0  ! 771: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r11
	.word 0xded6a000  ! 772: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r15
	mov	0x50, %r19
	.word 0xdeaf8e80  ! 774: STBA_R	stba	%r15, [%r30 + %r0] 0x74
	mov	0x3d8, %r20
	mov	0x68, %r24
	mov	0x8, %r25
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdecea000  ! 779: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r15
	.word 0xdede6000  ! 780: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r15
	.word 0xded62000  ! 781: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r15
	.word 0xdaf7ce80  ! 782: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	.word 0xdab6a000  ! 783: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xdabee000  ! 785: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	.word 0xda9f4e80  ! 786: LDDA_R	ldda	[%r29, %r0] 0x74, %r13
	.word 0xde8c4400  ! 787: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	.word 0xd6c7ce60  ! 788: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r11
	mov	0x8, %r26
	.word 0xdea66000  ! 790: STWA_I	stwa	%r15, [%r25 + 0x0000] %asi
	mov	0x38, %r25
	.word 0xd29c4400  ! 792: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	.word 0xd2f78e60  ! 793: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0xdacea000  ! 794: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r13
	.word 0xd2af4e80  ! 795: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	mov	0x60, %r24
	mov	0x18, %r26
	.word 0xd2840400  ! 798: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r9
	.word 0xd2948400  ! 799: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	.word 0xdec6e000  ! 800: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r15
	.word 0xdea6e000  ! 801: STWA_I	stwa	%r15, [%r27 + 0x0000] %asi
	.word 0xd2d689e0  ! 802: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r9
	.word 0x87802073  ! 803: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2d42000  ! 804: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2b46000  ! 805: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 806: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b4e000  ! 807: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0xd2f4e000  ! 808: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 809: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd28fe000  ! 810: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	.word 0xd4f584a0  ! 811: STXA_R	stxa	%r10, [%r22 + %r0] 0x25
	.word 0xd49f2000  ! 812: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd48fa000  ! 813: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xd2f78e80  ! 814: STXA_R	stxa	%r9, [%r30 + %r0] 0x74
	.word 0xdaafa000  ! 815: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	mov	0x60, %r25
	.word 0x87802074  ! 817: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8cf4e40  ! 818: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r12
	.word 0x87802074  ! 819: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r16
	.word 0xd4a4c400  ! 821: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0xdac70e80  ! 822: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r13
	.word 0xd0ae49e0  ! 823: STBA_R	stba	%r8, [%r25 + %r0] 0x4f
	.word 0xd0bf4e80  ! 824: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	.word 0xd4af4e40  ! 825: STBA_R	stba	%r10, [%r29 + %r0] 0x72
	mov	0x8, %r17
	.word 0xdebf8e60  ! 827: STDA_R	stda	%r15, [%r30 + %r0] 0x73
	.word 0xdeb70e40  ! 828: STHA_R	stha	%r15, [%r28 + %r0] 0x72
	.word 0xd69e89e0  ! 829: LDDA_R	ldda	[%r26, %r0] 0x4f, %r11
	.word 0xd4b7ce40  ! 830: STHA_R	stha	%r10, [%r31 + %r0] 0x72
	mov	0x68, %r26
	.word 0x87802073  ! 832: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b46000  ! 833: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 834: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0cfe000  ! 835: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	mov	0x3f8, %r21
	.word 0xd69c8400  ! 837: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	.word 0xde874e40  ! 838: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r15
	.word 0x87802020  ! 839: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdc8400  ! 840: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	mov	0x0, %r19
	mov	0x38, %r18
	mov	0x30, %r18
	mov	0x7f8, %r21
	.word 0x87802020  ! 845: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda876000  ! 846: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0x87802074  ! 847: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda972000  ! 848: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	mov	0x28, %r17
	.word 0xd09f4e40  ! 850: LDDA_R	ldda	[%r29, %r0] 0x72, %r8
	mov	0x10, %r24
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd29544a0  ! 853: LDUHA_R	lduha	[%r21, %r0] 0x25, %r9
	.word 0xd28fce40  ! 854: LDUBA_R	lduba	[%r31, %r0] 0x72, %r9
	.word 0xd48fe000  ! 855: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0x87802072  ! 856: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdac74e60  ! 857: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r13
	.word 0xdad76000  ! 858: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0xd68584a0  ! 859: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r11
	mov	0x3c0, %r21
	.word 0xd0af4e80  ! 861: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	.word 0xd484c400  ! 862: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	.word 0xdcaf2000  ! 863: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 864: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r17
	.word 0x8780204f  ! 866: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f4c400  ! 867: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd0f74e40  ! 868: STXA_R	stxa	%r8, [%r29 + %r0] 0x72
	.word 0xda9e09e0  ! 869: LDDA_R	ldda	[%r24, %r0] 0x4f, %r13
	.word 0x87802025  ! 870: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 871: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c8, %r22
	.word 0xd0870e80  ! 873: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r8
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802073  ! 875: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeac2000  ! 876: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xdebc2000  ! 877: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xded42000  ! 878: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	.word 0xde846000  ! 879: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0xde9c6000  ! 880: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0xdebc6000  ! 881: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 882: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r26
	.word 0x87802020  ! 884: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r22
	mov	0x3f8, %r22
	.word 0xdea7e000  ! 887: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xdebfa000  ! 889: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xdec76000  ! 890: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	mov	0x3d8, %r20
	mov	0x7e0, %r20
	.word 0xdca609e0  ! 893: STWA_R	stwa	%r14, [%r24 + %r0] 0x4f
	.word 0xd2bf8e60  ! 894: STDA_R	stda	%r9, [%r30 + %r0] 0x73
	.word 0x87802074  ! 895: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b5a000  ! 896: STHA_I	stha	%r9, [%r22 + 0x0000] %asi
	.word 0xd2d70e80  ! 897: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r9
	.word 0xdaaec9e0  ! 898: STBA_R	stba	%r13, [%r27 + %r0] 0x4f
	.word 0xd8f52000  ! 899: STXA_I	stxa	%r12, [%r20 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x3f8, %r23
	.word 0xd89d44a0  ! 902: LDDA_R	ldda	[%r21, %r0] 0x25, %r12
	.word 0xdef5e000  ! 903: STXA_I	stxa	%r15, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 904: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f584a0  ! 905: STXA_R	stxa	%r9, [%r22 + %r0] 0x25
	.word 0x87802072  ! 906: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r26
	.word 0xd69fce80  ! 908: LDDA_R	ldda	[%r31, %r0] 0x74, %r11
	.word 0xd2cf8e80  ! 909: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r9
	.word 0xd29fa000  ! 910: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	mov	0x30, %r25
	mov	0x60, %r27
	mov	0x3c0, %r23
	mov	0x60, %r19
	.word 0xd8d70e80  ! 915: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r12
	.word 0xd0afa000  ! 916: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 917: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccf8e80  ! 918: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r14
	.word 0xd2cfa000  ! 919: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	mov	0x28, %r18
	.word 0x87802072  ! 921: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda974e80  ! 922: LDUHA_R	lduha	[%r29, %r0] 0x74, %r13
	.word 0x8780204f  ! 923: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc844400  ! 924: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	mov	0x3e8, %r22
	.word 0x87802020  ! 926: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4be89e0  ! 927: STDA_R	stda	%r10, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 928: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d0, %r23
	.word 0x87802072  ! 930: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 931: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0a48400  ! 932: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0xd8dc2000  ! 933: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	mov	0x10, %r17
	.word 0x87802073  ! 935: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r24
	.word 0xd0a44400  ! 937: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xd484e000  ! 938: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r10
	.word 0x87802020  ! 939: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4be89e0  ! 940: STDA_R	stda	%r10, [%r26 + %r0] 0x4f
	.word 0xd6a70e60  ! 941: STWA_R	stwa	%r11, [%r28 + %r0] 0x73
	.word 0xd0f42000  ! 942: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 943: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a52000  ! 944: STWA_I	stwa	%r8, [%r20 + 0x0000] %asi
	.word 0xd0bda000  ! 945: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	.word 0xd0b56000  ! 946: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	.word 0xd095a000  ! 947: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r8
	.word 0x87802074  ! 948: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bc8400  ! 949: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	mov	0x28, %r17
	mov	0x3f0, %r20
	.word 0xdeace000  ! 952: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xdebf4e40  ! 954: STDA_R	stda	%r15, [%r29 + %r0] 0x72
	.word 0xdcac6000  ! 955: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xdef78e80  ! 957: STXA_R	stxa	%r15, [%r30 + %r0] 0x74
	mov	0x3d8, %r23
	mov	0x50, %r25
	mov	0x48, %r18
	.word 0xd6c4a000  ! 961: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r11
	.word 0xd6a46000  ! 962: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	mov	0x10, %r25
	.word 0xd684e000  ! 964: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r11
	.word 0xd6b4a000  ! 965: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd6a4e000  ! 966: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0xdebc4400  ! 967: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0xdc8e09e0  ! 968: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r14
	.word 0x8780204f  ! 969: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa74e40  ! 970: STWA_R	stwa	%r13, [%r29 + %r0] 0x72
	.word 0xd2c4a000  ! 971: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	.word 0x87802073  ! 972: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a609e0  ! 973: STWA_R	stwa	%r8, [%r24 + %r0] 0x4f
	.word 0xdc8de000  ! 974: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r14
	.word 0x87802073  ! 975: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8cfce60  ! 976: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r12
	.word 0xd6a46000  ! 977: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0xd8aec9e0  ! 978: STBA_R	stba	%r12, [%r27 + %r0] 0x4f
	.word 0xda846000  ! 979: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r13
	mov	0x7d8, %r22
	.word 0xda842000  ! 981: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r13
	mov	0x7e0, %r22
	.word 0xd6a649e0  ! 983: STWA_R	stwa	%r11, [%r25 + %r0] 0x4f
	.word 0xded4a000  ! 984: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	.word 0xde8c4400  ! 985: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802020  ! 987: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdecf2000  ! 988: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0x87802020  ! 989: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebde000  ! 990: STDA_I	stda	%r15, [%r23 + 0x0000] %asi
	.word 0xdef56000  ! 991: STXA_I	stxa	%r15, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 992: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r25
	.word 0xde97e000  ! 994: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0xde8f2000  ! 995: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xdecfe000  ! 996: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0x87802073  ! 997: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r25
	.word 0x87802072  ! 999: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd69dc4a0  ! 1000: LDDA_R	ldda	[%r23, %r0] 0x25, %r11
	.word 0x87802020  ! 1001: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d78e40  ! 1002: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r9
	.word 0xdeae49e0  ! 1003: STBA_R	stba	%r15, [%r25 + %r0] 0x4f
	.word 0xdc8584a0  ! 1004: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r14
	.word 0xd6c78e60  ! 1005: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r11
	.word 0xd29c2000  ! 1006: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	.word 0xd28c6000  ! 1007: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	mov	0x3d0, %r23
	mov	0x28, %r26
	.word 0xd8d584a0  ! 1010: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r12
	.word 0xd8dc6000  ! 1011: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	mov	0x7f8, %r22
	mov	0x7f0, %r21
	mov	0x18, %r18
	.word 0xd8a4e000  ! 1015: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	mov	0x50, %r24
	mov	0x7f8, %r20
	mov	0x3f0, %r23
	.word 0xdc84c400  ! 1019: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	.word 0xdef42000  ! 1020: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xdadf8e80  ! 1021: LDXA_R	ldxa	[%r30, %r0] 0x74, %r13
	.word 0x87802020  ! 1022: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2878e80  ! 1023: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r9
	.word 0xdecfce40  ! 1024: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r15
	.word 0x87802072  ! 1025: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r24
	.word 0xdcc76000  ! 1027: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xdef7ce60  ! 1028: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0xd0a7ce80  ! 1029: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	.word 0xd0b544a0  ! 1030: STHA_R	stha	%r8, [%r21 + %r0] 0x25
	.word 0xdc8f2000  ! 1031: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	mov	0x7e0, %r21
	mov	0x18, %r18
	mov	0x7d0, %r22
	mov	0x20, %r17
	mov	0x50, %r18
	.word 0xdcb74e40  ! 1037: STHA_R	stha	%r14, [%r29 + %r0] 0x72
	.word 0xdea48400  ! 1038: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	mov	0x28, %r25
	.word 0x87802025  ! 1040: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d0, %r23
	mov	0x7c0, %r21
	.word 0xd095a000  ! 1043: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r8
	mov	0x78, %r18
	.word 0xd8f7ce80  ! 1045: STXA_R	stxa	%r12, [%r31 + %r0] 0x74
	.word 0xd8874e40  ! 1046: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r12
	.word 0xd8cde000  ! 1047: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r12
	.word 0xd8ade000  ! 1048: STBA_I	stba	%r12, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 1049: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2a44400  ! 1050: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xdaaf8e40  ! 1051: STBA_R	stba	%r13, [%r30 + %r0] 0x72
	.word 0x87802020  ! 1052: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r20
	mov	0x50, %r24
	.word 0xd0f5a000  ! 1055: STXA_I	stxa	%r8, [%r22 + 0x0000] %asi
	mov	0x7c0, %r21
	.word 0xd0d5e000  ! 1057: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r8
	.word 0xd0b5a000  ! 1058: STHA_I	stha	%r8, [%r22 + 0x0000] %asi
	mov	0x8, %r18
	.word 0xdc8f0e40  ! 1060: LDUBA_R	lduba	[%r28, %r0] 0x72, %r14
	mov	0x68, %r25
	mov	0x60, %r17
	.word 0xd6b7ce80  ! 1063: STHA_R	stha	%r11, [%r31 + %r0] 0x74
	.word 0xd6f4c400  ! 1064: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0xd685a000  ! 1065: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r11
	.word 0xd6dd6000  ! 1066: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r11
	.word 0x87802020  ! 1067: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6946000  ! 1068: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r11
	.word 0x87802072  ! 1069: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd69f6000  ! 1070: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	.word 0x87802025  ! 1071: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4bf4e80  ! 1072: STDA_R	stda	%r10, [%r29 + %r0] 0x74
	.word 0x87802025  ! 1073: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebc6000  ! 1074: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 1075: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda86c9e0  ! 1076: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r13
	mov	0x10, %r18
	.word 0xd6c689e0  ! 1078: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r11
	.word 0xd4dfe000  ! 1079: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1080: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d72000  ! 1081: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	.word 0x87802073  ! 1082: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r26
	.word 0xd68f0e60  ! 1084: LDUBA_R	lduba	[%r28, %r0] 0x73, %r11
	.word 0xdcbf2000  ! 1085: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdcbf2000  ! 1086: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 1087: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r17
	.word 0xdcbc2000  ! 1089: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xdcb46000  ! 1090: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xdc8ce000  ! 1091: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 1092: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4cf4e40  ! 1093: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r10
	.word 0xd6f4c400  ! 1094: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0xd6d689e0  ! 1095: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r11
	.word 0x87802072  ! 1096: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8cf6000  ! 1097: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0x87802073  ! 1098: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 1099: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd69d44a0  ! 1100: LDDA_R	ldda	[%r21, %r0] 0x25, %r11
	mov	0x78, %r18
	.word 0xdaf6e000  ! 1102: STXA_I	stxa	%r13, [%r27 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd4c78e60  ! 1104: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r10
	mov	0x68, %r26
	.word 0xdca4c400  ! 1106: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	mov	0x40, %r17
	mov	0x48, %r18
	.word 0xda94c400  ! 1109: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	.word 0xdeb74e40  ! 1110: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	.word 0xdece49e0  ! 1111: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r15
	.word 0xd88ea000  ! 1112: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r12
	.word 0xd8ae6000  ! 1113: STBA_I	stba	%r12, [%r25 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0x87802074  ! 1115: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f46000  ! 1116: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	mov	0x0, %r18
	.word 0xd8a4c400  ! 1118: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xd28c2000  ! 1119: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0x87802025  ! 1120: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2a6a000  ! 1121: STWA_I	stwa	%r9, [%r26 + 0x0000] %asi
	mov	0x70, %r25
	mov	0x3f8, %r20
	.word 0xd2f6a000  ! 1124: STXA_I	stxa	%r9, [%r26 + 0x0000] %asi
	.word 0xd2cee000  ! 1125: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	.word 0x87802074  ! 1126: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 1127: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28544a0  ! 1128: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r9
	.word 0xd29f2000  ! 1129: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1130: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c72000  ! 1131: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2f76000  ! 1132: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1133: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded4c400  ! 1134: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r15
	.word 0x87802073  ! 1135: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcd6e000  ! 1136: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r14
	.word 0xdcdea000  ! 1137: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r14
	.word 0xdca584a0  ! 1138: STWA_R	stwa	%r14, [%r22 + %r0] 0x25
	.word 0xd0b78e60  ! 1139: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	.word 0xd29ee000  ! 1140: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r9
	.word 0xd2ae2000  ! 1141: STBA_I	stba	%r9, [%r24 + 0x0000] %asi
	.word 0x8780204f  ! 1142: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2b72000  ! 1143: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 1144: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bf8e40  ! 1145: STDA_R	stda	%r11, [%r30 + %r0] 0x72
	.word 0xd4f78e80  ! 1146: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	.word 0xdcf7ce80  ! 1147: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	mov	0x7f8, %r23
	mov	0x0, %r17
	.word 0xdcdc4400  ! 1150: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	.word 0x8780204f  ! 1151: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r18
	.word 0xda9f2000  ! 1153: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xda8f6000  ! 1154: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	mov	0x20, %r26
	.word 0xdcac8400  ! 1156: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	mov	0x48, %r24
	.word 0xd8de49e0  ! 1158: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r12
	.word 0xda9fe000  ! 1159: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1160: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8f2000  ! 1161: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0x87802073  ! 1162: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r26
	.word 0xdab52000  ! 1164: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	.word 0xdadd6000  ! 1165: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r13
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdad5e000  ! 1167: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r13
	.word 0x87802025  ! 1168: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r26
	mov	0x50, %r24
	.word 0xdadfa000  ! 1171: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xdaf7a000  ! 1172: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdab72000  ! 1173: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	mov	0x8, %r17
	.word 0xdab72000  ! 1175: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xd6df4e80  ! 1176: LDXA_R	ldxa	[%r29, %r0] 0x74, %r11
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdaf544a0  ! 1178: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	.word 0xd2876000  ! 1179: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xd29f2000  ! 1180: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd4a609e0  ! 1181: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	mov	0x10, %r16
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802072  ! 1184: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r24
	.word 0x8780204f  ! 1186: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r17
	mov	0x60, %r17
	mov	0x60, %r27
	.word 0x87802072  ! 1190: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d8, %r20
	mov	0x7d0, %r21
	.word 0xdaa78e40  ! 1193: STWA_R	stwa	%r13, [%r30 + %r0] 0x72
	mov	0x60, %r19
	mov	0x70, %r24
	mov	0x7d8, %r23
	.word 0xdcaf2000  ! 1197: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xdca7e000  ! 1199: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 1200: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x3d8, %r21
	mov	0x28, %r25
	.word 0xdc87e000  ! 1204: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcdf2000  ! 1205: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	mov	0x28, %r19
	.word 0x8780204f  ! 1207: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2c74e80  ! 1208: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r9
	mov	0x40, %r26
	.word 0xd4c70e60  ! 1210: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r10
	.word 0xd0b66000  ! 1211: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	.word 0xd0de2000  ! 1212: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r8
	.word 0xd0c66000  ! 1213: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r8
	.word 0xd0de6000  ! 1214: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r8
	.word 0xd0b66000  ! 1215: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	.word 0xd0be89e0  ! 1216: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	.word 0xd2d6c9e0  ! 1217: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r9
	.word 0xdef6e000  ! 1218: STXA_I	stxa	%r15, [%r27 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdeb62000  ! 1220: STHA_I	stha	%r15, [%r24 + 0x0000] %asi
	.word 0xdef6e000  ! 1221: STXA_I	stxa	%r15, [%r27 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0xd09cc400  ! 1223: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	.word 0x87802020  ! 1224: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdf0e80  ! 1225: LDXA_R	ldxa	[%r28, %r0] 0x74, %r14
	.word 0xd49d04a0  ! 1226: LDDA_R	ldda	[%r20, %r0] 0x25, %r10
	.word 0xd2874e60  ! 1227: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r9
	.word 0xd4978e40  ! 1228: LDUHA_R	lduha	[%r30, %r0] 0x72, %r10
	.word 0xd4f78e80  ! 1229: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	.word 0xdecd6000  ! 1230: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r15
	.word 0xde85a000  ! 1231: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r15
	.word 0xd8b70e60  ! 1232: STHA_R	stha	%r12, [%r28 + %r0] 0x73
	.word 0xd6a56000  ! 1233: STWA_I	stwa	%r11, [%r21 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xd8cf0e60  ! 1235: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r12
	.word 0xd0f70e40  ! 1236: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	.word 0xd4dfce60  ! 1237: LDXA_R	ldxa	[%r31, %r0] 0x73, %r10
	mov	0x3c0, %r22
	.word 0x87802020  ! 1239: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r26
	.word 0xd8a70e60  ! 1241: STWA_R	stwa	%r12, [%r28 + %r0] 0x73
	.word 0xd4f40400  ! 1242: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xd8a76000  ! 1243: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1244: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc8c4400  ! 1245: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0x87802074  ! 1246: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 1247: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4ade000  ! 1248: STBA_I	stba	%r10, [%r23 + 0x0000] %asi
	mov	0x10, %r19
	.word 0xd8afce40  ! 1250: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	.word 0xd0856000  ! 1251: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r8
	.word 0xdaccc400  ! 1252: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r13
	.word 0xd4f7ce60  ! 1253: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	.word 0xd09c4400  ! 1254: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	mov	0x7c8, %r21
	.word 0xd0ac0400  ! 1256: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	.word 0xdca52000  ! 1257: STWA_I	stwa	%r14, [%r20 + 0x0000] %asi
	.word 0xd2ac0400  ! 1258: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0xd4b504a0  ! 1259: STHA_R	stha	%r10, [%r20 + %r0] 0x25
	.word 0xde9cc400  ! 1260: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	mov	0x78, %r17
	.word 0xd0bda000  ! 1262: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	.word 0xd0dde000  ! 1263: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r8
	.word 0xde8689e0  ! 1264: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r15
	.word 0xd4dd6000  ! 1265: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r10
	.word 0xd485e000  ! 1266: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r10
	mov	0x3f0, %r23
	.word 0xd2cd84a0  ! 1268: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r9
	mov	0x7f0, %r21
	mov	0x7d8, %r23
	mov	0x58, %r27
	mov	0x3e8, %r23
	.word 0xd8952000  ! 1273: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r12
	mov	0x3c8, %r21
	.word 0xd8b52000  ! 1275: STHA_I	stha	%r12, [%r20 + 0x0000] %asi
	.word 0x8780204f  ! 1276: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd88fe000  ! 1277: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd28f8e60  ! 1278: LDUBA_R	lduba	[%r30, %r0] 0x73, %r9
	.word 0xd8bf8e80  ! 1279: STDA_R	stda	%r12, [%r30 + %r0] 0x74
	.word 0x87802020  ! 1280: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69d2000  ! 1281: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r11
	.word 0x87802020  ! 1282: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r20
	.word 0xd4878e40  ! 1284: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r10
	.word 0xdaf72000  ! 1285: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdadfe000  ! 1286: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0xd4b5c4a0  ! 1287: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	.word 0xdc8504a0  ! 1288: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r14
	mov	0x7f8, %r20
	.word 0xd4bfce80  ! 1290: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	.word 0xdab4c400  ! 1291: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xdca7ce60  ! 1292: STWA_R	stwa	%r14, [%r31 + %r0] 0x73
	.word 0xdcafe000  ! 1293: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	mov	0x30, %r27
	.word 0xd09f4e40  ! 1295: LDDA_R	ldda	[%r29, %r0] 0x72, %r8
	.word 0xd6b76000  ! 1296: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 1297: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6d4a000  ! 1298: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r11
	.word 0xd2940400  ! 1299: LDUHA_R	lduha	[%r16, %r0] 0x20, %r9
	.word 0x87802073  ! 1300: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda9689e0  ! 1301: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r13
	.word 0xd0b5e000  ! 1302: STHA_I	stha	%r8, [%r23 + 0x0000] %asi
	mov	0x20, %r18
	.word 0xd8be49e0  ! 1304: STDA_R	stda	%r12, [%r25 + %r0] 0x4f
	mov	0x30, %r25
	.word 0xda8689e0  ! 1306: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r13
	.word 0xd0dfce80  ! 1307: LDXA_R	ldxa	[%r31, %r0] 0x74, %r8
	.word 0xdcc56000  ! 1308: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r14
	.word 0xdc94c400  ! 1309: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	.word 0x8780204f  ! 1310: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0ccc400  ! 1311: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	.word 0xdccf8e40  ! 1312: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r14
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802072  ! 1314: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0a70e80  ! 1315: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0x87802025  ! 1316: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b42000  ! 1317: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0xd2a70e60  ! 1318: STWA_R	stwa	%r9, [%r28 + %r0] 0x73
	.word 0xd2dcc400  ! 1319: LDXA_R	ldxa	[%r19, %r0] 0x20, %r9
	.word 0xdcdc6000  ! 1320: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	.word 0xde8c0400  ! 1321: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0xd6842000  ! 1322: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r11
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd68ce000  ! 1324: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	.word 0xd684e000  ! 1325: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r11
	mov	0x58, %r18
	mov	0x3c8, %r20
	mov	0x3d0, %r23
	.word 0xd6d4e000  ! 1329: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 1330: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r18
	.word 0xd6dfa000  ! 1332: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0xd2af4e80  ! 1333: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	.word 0x8780204f  ! 1334: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r24
	.word 0xd2a7ce40  ! 1336: STWA_R	stwa	%r9, [%r31 + %r0] 0x72
	.word 0xd4d46000  ! 1337: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r10
	.word 0xd6b609e0  ! 1338: STHA_R	stha	%r11, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 1339: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcd48400  ! 1340: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	mov	0x70, %r16
	.word 0xdcf46000  ! 1342: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdcc609e0  ! 1343: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r14
	mov	0x3c8, %r22
	.word 0x87802074  ! 1345: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf74e40  ! 1346: STXA_R	stxa	%r13, [%r29 + %r0] 0x72
	.word 0xd88649e0  ! 1347: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r12
	mov	0x70, %r27
	.word 0x8780204f  ! 1349: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdece09e0  ! 1350: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r15
	.word 0xd087e000  ! 1351: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1352: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0ada000  ! 1353: STBA_I	stba	%r8, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 1354: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r24
	.word 0xd087a000  ! 1356: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0x87802074  ! 1357: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0af6000  ! 1358: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd0d7e000  ! 1359: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xdeb5c4a0  ! 1360: STHA_R	stha	%r15, [%r23 + %r0] 0x25
	mov	0x8, %r18
	.word 0xd6dc0400  ! 1362: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	.word 0xda9fa000  ! 1363: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1364: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09d04a0  ! 1365: LDDA_R	ldda	[%r20, %r0] 0x25, %r8
	.word 0xd0ad04a0  ! 1366: STBA_R	stba	%r8, [%r20 + %r0] 0x25
	mov	0x30, %r27
	.word 0xdab70e80  ! 1368: STHA_R	stha	%r13, [%r28 + %r0] 0x74
	mov	0x78, %r24
	.word 0xda8cc400  ! 1370: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	mov	0x3e0, %r23
	mov	0x3c8, %r20
	.word 0xd8ad6000  ! 1373: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 1374: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ac6000  ! 1375: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 1376: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8b42000  ! 1377: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	mov	0x28, %r17
	.word 0xd8a4e000  ! 1379: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xd8a4e000  ! 1380: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xd8b4a000  ! 1381: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0xd8a4a000  ! 1382: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0x87802073  ! 1384: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa78e60  ! 1385: STWA_R	stwa	%r13, [%r30 + %r0] 0x73
	mov	0x7e0, %r21
	.word 0xd0a7ce80  ! 1387: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	mov	0x30, %r19
	.word 0xd6aca000  ! 1389: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xdea504a0  ! 1390: STWA_R	stwa	%r15, [%r20 + %r0] 0x25
	.word 0xdca42000  ! 1391: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	mov	0x3e0, %r20
	.word 0x87802073  ! 1393: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd48609e0  ! 1394: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r10
	.word 0x87802020  ! 1395: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r23
	.word 0xd6afe000  ! 1397: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd0a48400  ! 1398: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0x87802073  ! 1399: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdebec9e0  ! 1400: STDA_R	stda	%r15, [%r27 + %r0] 0x4f
	.word 0xdcd48400  ! 1401: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	.word 0xd0afce80  ! 1402: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	.word 0xd4df4e40  ! 1403: LDXA_R	ldxa	[%r29, %r0] 0x72, %r10
	.word 0xd0af6000  ! 1404: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd0dfa000  ! 1405: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	mov	0x0, %r25
	mov	0x58, %r18
	.word 0xd087a000  ! 1408: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0b7a000  ! 1409: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd0bfa000  ! 1410: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1411: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd497ce40  ! 1412: LDUHA_R	lduha	[%r31, %r0] 0x72, %r10
	.word 0xdeb74e40  ! 1413: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	.word 0xd48d44a0  ! 1414: LDUBA_R	lduba	[%r21, %r0] 0x25, %r10
	.word 0xdeb584a0  ! 1415: STHA_R	stha	%r15, [%r22 + %r0] 0x25
	.word 0x87802072  ! 1416: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 1417: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6878e60  ! 1418: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r11
	.word 0xdadf2000  ! 1419: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0xdad7e000  ! 1420: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0x87802025  ! 1421: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdacf2000  ! 1422: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xdc8f0e60  ! 1423: LDUBA_R	lduba	[%r28, %r0] 0x73, %r14
	.word 0x87802074  ! 1424: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6df4e80  ! 1425: LDXA_R	ldxa	[%r29, %r0] 0x74, %r11
	.word 0xdea689e0  ! 1426: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	.word 0xda842000  ! 1427: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r13
	mov	0x8, %r25
	mov	0x50, %r16
	mov	0x10, %r26
	.word 0xdac42000  ! 1431: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0xd6f78e40  ! 1432: STXA_R	stxa	%r11, [%r30 + %r0] 0x72
	.word 0xdcf48400  ! 1433: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xdaac2000  ! 1434: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 1435: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r18
	.word 0xdac7e000  ! 1437: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xdac7e000  ! 1438: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	mov	0x3c0, %r21
	.word 0x87802025  ! 1440: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaf76000  ! 1441: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdacf6000  ! 1442: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xdaaf2000  ! 1443: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	mov	0x7f0, %r21
	.word 0xdad76000  ! 1445: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	mov	0x78, %r27
	.word 0x87802073  ! 1447: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb70e80  ! 1448: STHA_R	stha	%r14, [%r28 + %r0] 0x74
	.word 0x8780204f  ! 1449: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6ac8400  ! 1450: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xd097a000  ! 1451: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	.word 0x87802072  ! 1452: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd084a000  ! 1453: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	mov	0x20, %r27
	mov	0x60, %r26
	.word 0xd0ccc400  ! 1456: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	.word 0xdeb42000  ! 1457: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xdebca000  ! 1459: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0x87802020  ! 1461: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r20
	mov	0x3f8, %r22
	mov	0x40, %r19
	.word 0xd0ac8400  ! 1465: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xdadd6000  ! 1466: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r13
	.word 0xdabda000  ! 1467: STDA_I	stda	%r13, [%r22 + 0x0000] %asi
	mov	0x50, %r19
	.word 0xd28689e0  ! 1469: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r9
	.word 0x87802025  ! 1470: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2a609e0  ! 1471: STWA_R	stwa	%r9, [%r24 + %r0] 0x4f
	.word 0xd29c8400  ! 1472: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	.word 0xd6c74e60  ! 1473: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r11
	.word 0xdcbda000  ! 1474: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	.word 0xdcdde000  ! 1475: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	mov	0x3e0, %r22
	.word 0xdedd84a0  ! 1477: LDXA_R	ldxa	[%r22, %r0] 0x25, %r15
	mov	0x7e8, %r20
	.word 0xd4bd6000  ! 1479: STDA_I	stda	%r10, [%r21 + 0x0000] %asi
	mov	0x68, %r18
	.word 0xd0b689e0  ! 1481: STHA_R	stha	%r8, [%r26 + %r0] 0x4f
	.word 0xd8bd2000  ! 1482: STDA_I	stda	%r12, [%r20 + 0x0000] %asi
	.word 0xd8bd2000  ! 1483: STDA_I	stda	%r12, [%r20 + 0x0000] %asi
	.word 0xd8f5e000  ! 1484: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	.word 0xd8cde000  ! 1485: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r12
	.word 0xd68cc400  ! 1486: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	mov	0x60, %r19
	mov	0x18, %r26
	.word 0x87802072  ! 1489: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d8, %r22
	.word 0xd094e000  ! 1491: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0xd0b4e000  ! 1492: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	mov	0x3d8, %r21
	.word 0xd8a74e40  ! 1494: STWA_R	stwa	%r12, [%r29 + %r0] 0x72
	.word 0x87802073  ! 1495: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdabf4e40  ! 1496: STDA_R	stda	%r13, [%r29 + %r0] 0x72
	.word 0xdea7ce60  ! 1497: STWA_R	stwa	%r15, [%r31 + %r0] 0x73
	.word 0xdebc8400  ! 1498: STDA_R	stda	%r15, [%r18 + %r0] 0x20
	mov	0x20, %r26
	mov	0x58, %r19
	mov	0x0, %r24
	mov	0x78, %r24
	mov	0x10, %r18
	mov	0x40, %r17
	.word 0xdcb70e80  ! 1505: STHA_R	stha	%r14, [%r28 + %r0] 0x74
	.word 0x87802020  ! 1506: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8cec9e0  ! 1507: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r12
	.word 0xdc866000  ! 1508: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r14
	.word 0xd0bfce80  ! 1509: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	mov	0x7e0, %r21
	.word 0xd0af8e40  ! 1511: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0xdcc584a0  ! 1512: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r14
	.word 0xd2aec9e0  ! 1513: STBA_R	stba	%r9, [%r27 + %r0] 0x4f
	.word 0xdad6e000  ! 1514: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 1515: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8d4c400  ! 1516: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0xde9c6000  ! 1517: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0xdea4e000  ! 1518: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xd2870e40  ! 1519: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r9
	.word 0xd8a78e60  ! 1520: STWA_R	stwa	%r12, [%r30 + %r0] 0x73
	mov	0x7e0, %r20
	.word 0xdeb4e000  ! 1522: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 1523: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r24
	.word 0xdeb46000  ! 1525: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0xde8c6000  ! 1526: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0xd0a4c400  ! 1527: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xdc9ce000  ! 1528: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r14
	.word 0xd6f70e80  ! 1529: STXA_R	stxa	%r11, [%r28 + %r0] 0x74
	mov	0x8, %r27
	.word 0xd4bcc400  ! 1531: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0xd8b74e80  ! 1532: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	.word 0xd69e09e0  ! 1533: LDDA_R	ldda	[%r24, %r0] 0x4f, %r11
	.word 0xd0d4e000  ! 1534: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	.word 0xdeb48400  ! 1535: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xdeb78e80  ! 1536: STHA_R	stha	%r15, [%r30 + %r0] 0x74
	mov	0x70, %r18
	mov	0x3f8, %r22
	.word 0xd0afce60  ! 1539: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	.word 0xd0f4a000  ! 1540: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	mov	0x28, %r24
	.word 0x87802020  ! 1542: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1543: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r24
	mov	0x38, %r17
	.word 0xd0d72000  ! 1546: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd2af8e60  ! 1547: STBA_R	stba	%r9, [%r30 + %r0] 0x73
	mov	0x3c8, %r20
	.word 0xdadf2000  ! 1549: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0xdadf6000  ! 1550: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xd8d78e40  ! 1551: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r12
	.word 0xd2d76000  ! 1552: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0xdcbf4e60  ! 1553: STDA_R	stda	%r14, [%r29 + %r0] 0x73
	.word 0xd0c7ce40  ! 1554: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r8
	.word 0xde976000  ! 1555: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	.word 0xde9fe000  ! 1556: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	mov	0x3c0, %r20
	.word 0xded7a000  ! 1558: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xdeaf8e40  ! 1559: STBA_R	stba	%r15, [%r30 + %r0] 0x72
	.word 0xd6cfa000  ! 1560: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	mov	0x20, %r26
	mov	0x7d8, %r21
	mov	0x10, %r16
	.word 0xdad40400  ! 1564: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	mov	0x28, %r16
	.word 0x8780204f  ! 1566: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea46000  ! 1567: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	mov	0x7f0, %r21
	.word 0xd6d44400  ! 1569: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r11
	.word 0xd49584a0  ! 1570: LDUHA_R	lduha	[%r22, %r0] 0x25, %r10
	.word 0xd69ca000  ! 1571: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r11
	.word 0xd6b4a000  ! 1572: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd0bdc4a0  ! 1573: STDA_R	stda	%r8, [%r23 + %r0] 0x25
	mov	0x0, %r25
	mov	0x60, %r18
	.word 0x87802020  ! 1576: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1577: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r25
	mov	0x78, %r26
	.word 0x87802073  ! 1580: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 1581: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6aca000  ! 1582: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	mov	0x48, %r17
	.word 0xd6dce000  ! 1584: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0xd0be09e0  ! 1585: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0xd4a40400  ! 1586: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	.word 0xdcf609e0  ! 1587: STXA_R	stxa	%r14, [%r24 + %r0] 0x4f
	.word 0xd2c70e80  ! 1588: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r9
	.word 0xdcb46000  ! 1589: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xdca42000  ! 1590: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xdabec9e0  ! 1591: STDA_R	stda	%r13, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 1592: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1593: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6944400  ! 1594: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	mov	0x78, %r19
	.word 0xd4dc4400  ! 1596: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	mov	0x7c8, %r20
	mov	0x10, %r16
	.word 0xd0a46000  ! 1599: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0f4e000  ! 1600: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	mov	0x7e0, %r21
	.word 0x87802072  ! 1602: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb74e60  ! 1603: STHA_R	stha	%r15, [%r29 + %r0] 0x73
	.word 0xdaa70e60  ! 1604: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	.word 0xd2acc400  ! 1605: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0xd8d4a000  ! 1606: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xd8bf8e60  ! 1607: STDA_R	stda	%r12, [%r30 + %r0] 0x73
	.word 0x87802073  ! 1608: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r17
	.word 0xd4ce2000  ! 1610: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r10
	.word 0xd4d689e0  ! 1611: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r10
	.word 0xdead44a0  ! 1612: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	mov	0x7e0, %r21
	.word 0xde8e2000  ! 1614: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r15
	mov	0x7c0, %r20
	.word 0x87802020  ! 1616: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded46000  ! 1617: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	.word 0xdef42000  ! 1618: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	mov	0x70, %r18
	.word 0xdebc2000  ! 1620: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	mov	0x30, %r17
	.word 0x87802020  ! 1622: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0d40400  ! 1623: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	.word 0x87802074  ! 1624: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f70e60  ! 1625: STXA_R	stxa	%r10, [%r28 + %r0] 0x73
	.word 0x87802073  ! 1626: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0dc2000  ! 1627: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	mov	0x7e0, %r22
	mov	0x3c0, %r21
	.word 0xd6d48400  ! 1630: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0xdc8c4400  ! 1631: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	mov	0x7e8, %r20
	.word 0x87802074  ! 1633: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6dcc400  ! 1634: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	.word 0xda876000  ! 1635: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	mov	0x60, %r27
	mov	0x18, %r17
	.word 0xdaa7a000  ! 1638: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 1639: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda956000  ! 1640: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r13
	.word 0xd69544a0  ! 1641: LDUHA_R	lduha	[%r21, %r0] 0x25, %r11
	.word 0x8780204f  ! 1642: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a5c4a0  ! 1643: STWA_R	stwa	%r8, [%r23 + %r0] 0x25
	.word 0xd4a6e000  ! 1644: STWA_I	stwa	%r10, [%r27 + 0x0000] %asi
	.word 0x87802025  ! 1645: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r26
	.word 0xd2cfce80  ! 1647: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r9
	mov	0x48, %r25
	.word 0xd094e000  ! 1649: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0x87802074  ! 1650: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r16
	.word 0xd0af2000  ! 1652: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 1653: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6dc4400  ! 1654: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xd8f4a000  ! 1655: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	mov	0x3f0, %r22
	mov	0x3f8, %r21
	.word 0x87802020  ! 1658: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0848400  ! 1659: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r8
	.word 0x87802025  ! 1660: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd29d44a0  ! 1661: LDDA_R	ldda	[%r21, %r0] 0x25, %r9
	mov	0x70, %r27
	.word 0x87802020  ! 1663: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09f2000  ! 1664: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	mov	0x3f0, %r22
	.word 0xd08fa000  ! 1666: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1667: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1668: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0d56000  ! 1669: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r8
	.word 0xdcb70e80  ! 1670: STHA_R	stha	%r14, [%r28 + %r0] 0x74
	mov	0x3c8, %r23
	mov	0x30, %r17
	.word 0xdca78e60  ! 1673: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	mov	0x40, %r16
	.word 0xd2d5c4a0  ! 1675: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r9
	.word 0x87802025  ! 1676: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cdc4a0  ! 1677: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r10
	mov	0x7d8, %r22
	.word 0x87802025  ! 1679: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 1680: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0dfce60  ! 1681: LDXA_R	ldxa	[%r31, %r0] 0x73, %r8
	.word 0xdcc76000  ! 1682: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xdcdf6000  ! 1683: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	mov	0x8, %r26
	.word 0xdcb76000  ! 1685: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xdcafa000  ! 1686: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xdc8fa000  ! 1687: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdc9fe000  ! 1688: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0x87802020  ! 1689: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcac2000  ! 1690: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0xd8af0e40  ! 1691: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	.word 0xd6f4e000  ! 1692: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	.word 0xd6aca000  ! 1693: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 1694: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 1695: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1696: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcc78e60  ! 1697: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r14
	.word 0xd8af8e60  ! 1698: STBA_R	stba	%r12, [%r30 + %r0] 0x73
	.word 0xdef70e60  ! 1699: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	mov	0x40, %r18
	mov	0x38, %r16
	.word 0xdeaca000  ! 1702: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xd0c649e0  ! 1704: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r8
	.word 0xd6f74e40  ! 1705: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	.word 0x87802072  ! 1706: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeac8400  ! 1707: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0x87802025  ! 1708: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2cf6000  ! 1709: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	mov	0x3c8, %r23
	mov	0x3e8, %r22
	mov	0x18, %r25
	mov	0x30, %r17
	.word 0x87802025  ! 1714: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b5c4a0  ! 1715: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	mov	0x38, %r24
	.word 0xd09c6000  ! 1717: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r8
	.word 0xd6cf0e80  ! 1718: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r11
	.word 0xdebc2000  ! 1719: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xded4a000  ! 1720: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	mov	0x70, %r19
	.word 0xdeace000  ! 1722: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0xdecc2000  ! 1724: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	.word 0xd6bf8e40  ! 1725: STDA_R	stda	%r11, [%r30 + %r0] 0x72
	.word 0xd6d504a0  ! 1726: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r11
	.word 0xdaf544a0  ! 1727: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	.word 0xdef74e80  ! 1728: STXA_R	stxa	%r15, [%r29 + %r0] 0x74
	.word 0xd4a44400  ! 1729: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xdabf8e80  ! 1730: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	.word 0xdcb4a000  ! 1731: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xdcf4a000  ! 1732: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 1733: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r18
	.word 0xd8b78e40  ! 1735: STHA_R	stha	%r12, [%r30 + %r0] 0x72
	.word 0xdcb7ce40  ! 1736: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	mov	0x3e8, %r23
	mov	0x3f0, %r20
	.word 0xd0cfce80  ! 1739: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r8
	.word 0x87802074  ! 1740: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda8f2000  ! 1741: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xdab7e000  ! 1742: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xd487ce60  ! 1743: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r10
	.word 0xdccc8400  ! 1744: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	mov	0x3c0, %r20
	.word 0x87802020  ! 1746: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1747: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9e2000  ! 1748: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r14
	.word 0xdcce6000  ! 1749: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r14
	.word 0xdcb70e60  ! 1750: STHA_R	stha	%r14, [%r28 + %r0] 0x73
	mov	0x18, %r19
	.word 0xdeac0400  ! 1752: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 1753: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b504a0  ! 1754: STHA_R	stha	%r8, [%r20 + %r0] 0x25
	.word 0xd2b76000  ! 1755: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1756: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad7ce80  ! 1757: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r13
	mov	0x18, %r18
	.word 0xd8a7e000  ! 1759: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0xd8bcc400  ! 1761: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0x87802074  ! 1762: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdebc2000  ! 1764: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xde8ca000  ! 1765: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	mov	0x30, %r26
	.word 0xde9ca000  ! 1767: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	.word 0xde8c2000  ! 1768: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	.word 0xd4844400  ! 1769: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0xd69e49e0  ! 1770: LDDA_R	ldda	[%r25, %r0] 0x4f, %r11
	.word 0xdabce000  ! 1771: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	mov	0x8, %r24
	.word 0xdad48400  ! 1773: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0xd48ce000  ! 1774: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r10
	.word 0xdcaf0e60  ! 1775: STBA_R	stba	%r14, [%r28 + %r0] 0x73
	.word 0x87802074  ! 1776: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde8f0e40  ! 1777: LDUBA_R	lduba	[%r28, %r0] 0x72, %r15
	.word 0xd8844400  ! 1778: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r12
	.word 0xdab72000  ! 1779: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 1780: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaa4e000  ! 1781: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0xd0b70e40  ! 1782: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	.word 0xd0f40400  ! 1783: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xdad42000  ! 1784: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r13
	mov	0x70, %r25
	.word 0x87802072  ! 1786: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda8ce000  ! 1787: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	.word 0xdaf46000  ! 1788: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0xdac4a000  ! 1789: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	.word 0x87802025  ! 1790: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaa7a000  ! 1791: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 1792: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdac4e000  ! 1793: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r13
	.word 0xda946000  ! 1794: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	mov	0x28, %r16
	.word 0xd48c8400  ! 1796: LDUBA_R	lduba	[%r18, %r0] 0x20, %r10
	.word 0x87802020  ! 1797: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9dc4a0  ! 1798: LDDA_R	ldda	[%r23, %r0] 0x25, %r15
	mov	0x28, %r18
	.word 0xd4ad6000  ! 1800: STBA_I	stba	%r10, [%r21 + 0x0000] %asi
	mov	0x50, %r18
	.word 0x87802074  ! 1802: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd09c4400  ! 1803: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	mov	0x70, %r17
	mov	0x70, %r18
	.word 0xd4a78e80  ! 1806: STWA_R	stwa	%r10, [%r30 + %r0] 0x74
	.word 0xd4a76000  ! 1807: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	mov	0x78, %r27
	.word 0x87802074  ! 1809: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f46000  ! 1810: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 1811: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 1812: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b4e000  ! 1813: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xd4ac2000  ! 1814: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 1815: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4aee000  ! 1816: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	.word 0xd4a6e000  ! 1817: STWA_I	stwa	%r10, [%r27 + 0x0000] %asi
	.word 0xd4a62000  ! 1818: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 1819: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r23
	.word 0x87802073  ! 1821: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd48fa000  ! 1822: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xd2c609e0  ! 1823: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r9
	.word 0x87802074  ! 1824: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeb48400  ! 1825: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xd487e000  ! 1826: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd49fa000  ! 1827: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	mov	0x20, %r25
	.word 0xd8d78e80  ! 1829: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r12
	mov	0x68, %r17
	.word 0xdc9c8400  ! 1831: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0xd6940400  ! 1832: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	mov	0x3d0, %r23
	.word 0xdaafce40  ! 1834: STBA_R	stba	%r13, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 1835: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ac6000  ! 1836: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xd8dce000  ! 1837: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	.word 0xd8b70e40  ! 1838: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0x8780204f  ! 1839: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdac72000  ! 1840: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0xd8c70e80  ! 1841: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r12
	.word 0x87802020  ! 1842: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r17
	mov	0x18, %r18
	.word 0xdc872000  ! 1845: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	mov	0x78, %r26
	.word 0xdccf2000  ! 1847: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0x87802072  ! 1848: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb7e000  ! 1849: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 1850: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r27
	mov	0x3d8, %r23
	mov	0x0, %r24
	.word 0xd48c4400  ! 1854: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0xd6bf4e60  ! 1855: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	.word 0xd0dce000  ! 1856: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r8
	ta	T_CHANGE_PRIV	! macro
	.word 0xd0bc6000  ! 1858: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	.word 0xd2af0e40  ! 1859: STBA_R	stba	%r9, [%r28 + %r0] 0x72
	.word 0xdaa609e0  ! 1860: STWA_R	stwa	%r13, [%r24 + %r0] 0x4f
	.word 0xd6a4a000  ! 1861: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	.word 0xd4cc0400  ! 1862: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r10
	.word 0xd8cc6000  ! 1863: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r12
	.word 0xd6a649e0  ! 1864: STWA_R	stwa	%r11, [%r25 + %r0] 0x4f
	.word 0xd0b4e000  ! 1865: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xd0b70e40  ! 1866: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	.word 0x87802073  ! 1867: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdedc2000  ! 1868: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r15
	.word 0xde9c2000  ! 1869: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 1870: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 1871: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca584a0  ! 1872: STWA_R	stwa	%r14, [%r22 + %r0] 0x25
	.word 0xdaaf4e80  ! 1873: STBA_R	stba	%r13, [%r29 + %r0] 0x74
	.word 0xd2a74e60  ! 1874: STWA_R	stwa	%r9, [%r29 + %r0] 0x73
	.word 0xd68c0400  ! 1875: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	.word 0xdcbec9e0  ! 1876: STDA_R	stda	%r14, [%r27 + %r0] 0x4f
	.word 0xd687a000  ! 1877: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6f7a000  ! 1878: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0x87802074  ! 1880: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d8, %r20
	.word 0xdef5c4a0  ! 1882: STXA_R	stxa	%r15, [%r23 + %r0] 0x25
	.word 0xd6f649e0  ! 1883: STXA_R	stxa	%r11, [%r25 + %r0] 0x4f
	.word 0xd4bf0e40  ! 1884: STDA_R	stda	%r10, [%r28 + %r0] 0x72
	.word 0xd0f46000  ! 1885: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	mov	0x7e8, %r20
	mov	0x8, %r25
	.word 0xd0d4e000  ! 1888: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	.word 0xd0dc6000  ! 1889: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	.word 0xd0bce000  ! 1890: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 1891: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd09e2000  ! 1893: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1894: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd09c6000  ! 1895: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r8
	.word 0xd0cc2000  ! 1896: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	.word 0xd084e000  ! 1897: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	.word 0x87802074  ! 1898: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8c6c9e0  ! 1899: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r12
	mov	0x3e0, %r23
	.word 0xdcbd2000  ! 1901: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	.word 0xdeb584a0  ! 1902: STHA_R	stha	%r15, [%r22 + %r0] 0x25
	.word 0xd6a4c400  ! 1903: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	mov	0x3e8, %r22
	.word 0xdcb44400  ! 1905: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0xd4f5a000  ! 1906: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	.word 0xdaa5c4a0  ! 1907: STWA_R	stwa	%r13, [%r23 + %r0] 0x25
	mov	0x7d8, %r20
	.word 0xdcd44400  ! 1909: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	.word 0xdcb52000  ! 1910: STHA_I	stha	%r14, [%r20 + 0x0000] %asi
	.word 0xd2c4c400  ! 1911: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0xded609e0  ! 1912: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r15
	mov	0x7d8, %r20
	mov	0x48, %r25
	mov	0x3d8, %r21
	.word 0xd08649e0  ! 1916: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r8
	.word 0xd8ada000  ! 1917: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0xdea7ce80  ! 1918: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	.word 0xd8bc0400  ! 1919: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0x87802020  ! 1920: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef40400  ! 1921: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0xd68f2000  ! 1922: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xd6f7a000  ! 1923: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6cf6000  ! 1924: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0x87802025  ! 1925: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 1926: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f70e80  ! 1927: STXA_R	stxa	%r10, [%r28 + %r0] 0x74
	mov	0x3f8, %r22
	mov	0x7d0, %r21
	mov	0x68, %r19
	mov	0x7d0, %r23
	.word 0xdabca000  ! 1932: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xda8e89e0  ! 1933: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r13
	.word 0xdcbc2000  ! 1934: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xd4840400  ! 1935: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	.word 0xd8adc4a0  ! 1936: STBA_R	stba	%r12, [%r23 + %r0] 0x25
	.word 0xd8f4a000  ! 1937: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	mov	0x7d8, %r21
	mov	0x10, %r24
	.word 0xdcf544a0  ! 1940: STXA_R	stxa	%r14, [%r21 + %r0] 0x25
	.word 0xd6dcc400  ! 1941: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	.word 0xdebce000  ! 1942: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xdea46000  ! 1943: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xd6f78e40  ! 1944: STXA_R	stxa	%r11, [%r30 + %r0] 0x72
	.word 0xda8c8400  ! 1945: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	.word 0x87802074  ! 1946: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e0, %r23
	mov	0x48, %r24
	.word 0xd0af2000  ! 1949: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xdedfce60  ! 1950: LDXA_R	ldxa	[%r31, %r0] 0x73, %r15
	.word 0xd8cc4400  ! 1951: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r12
	.word 0xd4a7e000  ! 1952: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd6844400  ! 1953: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r11
	mov	0x28, %r25
	mov	0x60, %r16
	.word 0x8780204f  ! 1956: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6878e40  ! 1957: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r11
	.word 0x87802074  ! 1958: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f4e000  ! 1959: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 1960: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbd84a0  ! 1961: STDA_R	stda	%r14, [%r22 + %r0] 0x25
	mov	0x3e0, %r21
	mov	0x50, %r27
	.word 0x87802072  ! 1964: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f76000  ! 1965: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6cfe000  ! 1966: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0x87802074  ! 1967: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 1968: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b7e000  ! 1969: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd6b72000  ! 1970: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	mov	0x3d0, %r21
	.word 0xd0f5c4a0  ! 1972: STXA_R	stxa	%r8, [%r23 + %r0] 0x25
	.word 0xdcdf6000  ! 1973: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xdccf6000  ! 1974: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xd8ad44a0  ! 1975: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	.word 0xdcdf6000  ! 1976: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	mov	0x60, %r25
	mov	0x10, %r27
	.word 0xdcc76000  ! 1979: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xdca7e000  ! 1980: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xde9cc400  ! 1981: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	.word 0x87802074  ! 1982: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0c5c4a0  ! 1983: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r8
	.word 0x87802074  ! 1984: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r25
	mov	0x68, %r26
	.word 0xdacd84a0  ! 1987: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r13
	.word 0x87802074  ! 1988: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1989: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1990: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1991: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b7e000  ! 1992: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0xdcf74e80  ! 1993: STXA_R	stxa	%r14, [%r29 + %r0] 0x74
	.word 0x87802020  ! 1994: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bd44a0  ! 1995: STDA_R	stda	%r11, [%r21 + %r0] 0x25
	.word 0xdaafce40  ! 1996: STBA_R	stba	%r13, [%r31 + %r0] 0x72
	.word 0xd6f6e000  ! 1997: STXA_I	stxa	%r11, [%r27 + 0x0000] %asi
	.word 0xd4f584a0  ! 1998: STXA_R	stxa	%r10, [%r22 + %r0] 0x25
	.word 0xd2a74e40  ! 1999: STWA_R	stwa	%r9, [%r29 + %r0] 0x72
	.word 0xdea66000  ! 2000: STWA_I	stwa	%r15, [%r25 + 0x0000] %asi
	.word 0xdea62000  ! 2001: STWA_I	stwa	%r15, [%r24 + 0x0000] %asi
	.word 0x87802073  ! 2002: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde8c2000  ! 2003: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	.word 0xdef4e000  ! 2004: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xd8dfce80  ! 2005: LDXA_R	ldxa	[%r31, %r0] 0x74, %r12
	.word 0xdec4c400  ! 2006: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	.word 0xdec4e000  ! 2007: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	.word 0xdec4a000  ! 2008: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xd0cfce40  ! 2009: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r8
	.word 0xd0f42000  ! 2010: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0xd084e000  ! 2011: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	mov	0x60, %r17
	.word 0x87802072  ! 2013: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cd04a0  ! 2014: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r10
	.word 0x87802074  ! 2015: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2016: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdec609e0  ! 2017: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r15
	mov	0x68, %r19
	.word 0xd0972000  ! 2019: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0f72000  ! 2020: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	mov	0x10, %r19
	.word 0x8780204f  ! 2022: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b42000  ! 2023: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xd4a70e60  ! 2024: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	.word 0xdabc6000  ! 2025: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	mov	0x70, %r27
	.word 0xdaaca000  ! 2027: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 2028: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b48400  ! 2029: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd0ce6000  ! 2030: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r8
	.word 0xd086a000  ! 2031: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r8
	.word 0xdeaf0e40  ! 2032: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	mov	0x50, %r19
	.word 0xd8d48400  ! 2034: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0xdeaf8e80  ! 2035: STBA_R	stba	%r15, [%r30 + %r0] 0x74
	.word 0xdacd84a0  ! 2036: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r13
	.word 0x87802074  ! 2037: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbf6000  ! 2038: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xd6afce40  ! 2039: STBA_R	stba	%r11, [%r31 + %r0] 0x72
	mov	0x7c8, %r21
	.word 0x87802020  ! 2041: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2042: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf4a000  ! 2043: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 2044: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r17
	.word 0xd69f0e80  ! 2046: LDDA_R	ldda	[%r28, %r0] 0x74, %r11
	.word 0xdec70e40  ! 2047: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r15
	.word 0xd2ac4400  ! 2048: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	mov	0x10, %r17
	.word 0xd6a7e000  ! 2050: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6d7e000  ! 2051: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	.word 0xd6d72000  ! 2052: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r11
	.word 0xd6f7a000  ! 2053: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6af6000  ! 2054: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 2055: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6dea000  ! 2056: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r11
	.word 0x87802072  ! 2057: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b5a000  ! 2058: STHA_I	stha	%r11, [%r22 + 0x0000] %asi
	mov	0x18, %r16
	.word 0xd69c4400  ! 2060: LDDA_R	ldda	[%r17, %r0] 0x20, %r11
	.word 0xd89c4400  ! 2061: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	.word 0xdc95e000  ! 2062: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r14
	.word 0xdc852000  ! 2063: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r14
	.word 0xd2dfce80  ! 2064: LDXA_R	ldxa	[%r31, %r0] 0x74, %r9
	.word 0xd8a70e60  ! 2065: STWA_R	stwa	%r12, [%r28 + %r0] 0x73
	mov	0x0, %r26
	mov	0x28, %r18
	.word 0xd2b4c400  ! 2068: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xdcc52000  ! 2069: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r14
	.word 0xdcbd2000  ! 2070: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	.word 0xdccd2000  ! 2071: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r14
	.word 0xd2af4e60  ! 2072: STBA_R	stba	%r9, [%r29 + %r0] 0x73
	.word 0xdad5a000  ! 2073: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2074: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf7e000  ! 2075: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xdec609e0  ! 2076: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r15
	.word 0x87802074  ! 2077: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8b44400  ! 2078: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0xde9c2000  ! 2079: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xde8c6000  ! 2080: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0xde8ca000  ! 2081: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0xd69d44a0  ! 2082: LDDA_R	ldda	[%r21, %r0] 0x25, %r11
	.word 0xda9c2000  ! 2083: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	mov	0x18, %r19
	.word 0xdedfce60  ! 2085: LDXA_R	ldxa	[%r31, %r0] 0x73, %r15
	.word 0xde9d04a0  ! 2086: LDDA_R	ldda	[%r20, %r0] 0x25, %r15
	.word 0x87802072  ! 2087: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf7e000  ! 2088: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x7f0, %r22
	mov	0x60, %r18
	.word 0xd6d70e80  ! 2091: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r11
	.word 0xd4f76000  ! 2092: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xdccc4400  ! 2093: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r14
	.word 0xd08d04a0  ! 2094: LDUBA_R	lduba	[%r20, %r0] 0x25, %r8
	.word 0xd88e09e0  ! 2095: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r12
	mov	0x3e0, %r23
	mov	0x60, %r16
	mov	0x48, %r17
	.word 0xdabf6000  ! 2099: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xdacf6000  ! 2100: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0x87802073  ! 2101: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 2102: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 2103: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f8, %r22
	.word 0xdaafce60  ! 2105: STBA_R	stba	%r13, [%r31 + %r0] 0x73
	mov	0x38, %r19
	mov	0x70, %r17
	.word 0xd4f40400  ! 2108: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xd0cfe000  ! 2109: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xd0afa000  ! 2110: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xd4d5c4a0  ! 2112: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r10
	mov	0x18, %r19
	.word 0xde872000  ! 2114: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xd6dc8400  ! 2115: LDXA_R	ldxa	[%r18, %r0] 0x20, %r11
	.word 0xdac7e000  ! 2116: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xda97e000  ! 2117: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	mov	0x7e8, %r20
	.word 0xda9f6000  ! 2119: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 2120: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r27
	.word 0xd8f6c9e0  ! 2122: STXA_R	stxa	%r12, [%r27 + %r0] 0x4f
	.word 0xd6a72000  ! 2123: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xd6bf2000  ! 2125: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xdcbc0400  ! 2126: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0x87802020  ! 2127: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2128: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9f6000  ! 2129: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	mov	0x38, %r26
	.word 0xd4c7ce60  ! 2131: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r10
	.word 0xd48f2000  ! 2132: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	mov	0x7f0, %r23
	.word 0xdcb78e40  ! 2134: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xd4f76000  ! 2135: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd8b7ce80  ! 2136: STHA_R	stha	%r12, [%r31 + %r0] 0x74
	.word 0xd2f72000  ! 2137: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd2cfa000  ! 2138: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	.word 0x87802072  ! 2139: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 2140: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a609e0  ! 2141: STWA_R	stwa	%r12, [%r24 + %r0] 0x4f
	.word 0xdadf8e40  ! 2142: LDXA_R	ldxa	[%r30, %r0] 0x72, %r13
	mov	0x7f8, %r22
	.word 0x87802072  ! 2144: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde87e000  ! 2145: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdeb4c400  ! 2146: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xd6d72000  ! 2147: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r11
	mov	0x20, %r27
	mov	0x50, %r26
	.word 0xd6872000  ! 2150: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	mov	0x3f8, %r21
	mov	0x28, %r25
	mov	0x3f0, %r22
	mov	0x3f8, %r22
	mov	0x7e8, %r23
	.word 0xdccc8400  ! 2156: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	.word 0xdad7a000  ! 2157: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0xd487ce40  ! 2158: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r10
	mov	0x7e8, %r21
	.word 0xd8bf2000  ! 2160: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd8b6c9e0  ! 2161: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	.word 0xd6ac8400  ! 2162: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xdef7ce60  ! 2163: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	mov	0x3f8, %r20
	.word 0x8780204f  ! 2165: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c0, %r20
	.word 0x8780204f  ! 2167: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9fa000  ! 2168: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	mov	0x28, %r17
	.word 0xdaf76000  ! 2170: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0xdaf7e000  ! 2172: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xdebc0400  ! 2173: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0x87802073  ! 2174: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda9e6000  ! 2175: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r13
	mov	0x7c8, %r20
	.word 0xd0f48400  ! 2177: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	mov	0x3f8, %r21
	.word 0xd8aee000  ! 2179: STBA_I	stba	%r12, [%r27 + 0x0000] %asi
	mov	0x18, %r25
	.word 0xd4c44400  ! 2181: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r10
	.word 0x87802072  ! 2182: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7c8, %r21
	.word 0xdaac0400  ! 2184: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xd6cea000  ! 2185: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	mov	0x78, %r16
	mov	0x7c8, %r22
	mov	0x8, %r16
	.word 0xd8970e60  ! 2189: LDUHA_R	lduha	[%r28, %r0] 0x73, %r12
	mov	0x30, %r16
	.word 0xd6d7ce60  ! 2191: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r11
	.word 0xdea44400  ! 2192: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xde84c400  ! 2193: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0xda974e60  ! 2194: LDUHA_R	lduha	[%r29, %r0] 0x73, %r13
	.word 0xd4be89e0  ! 2195: STDA_R	stda	%r10, [%r26 + %r0] 0x4f
	mov	0x3f0, %r23
	mov	0x58, %r19
	.word 0xdaa6a000  ! 2198: STWA_I	stwa	%r13, [%r26 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0xdccd84a0  ! 2200: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r14
	.word 0x87802020  ! 2201: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d48400  ! 2202: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	.word 0x87802020  ! 2203: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r26
	mov	0x48, %r25
	mov	0x70, %r17
	.word 0xdabe89e0  ! 2207: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	mov	0x3f8, %r20
	.word 0x87802073  ! 2209: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 2210: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0c44400  ! 2211: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r8
	.word 0xdaaf4e60  ! 2212: STBA_R	stba	%r13, [%r29 + %r0] 0x73
	.word 0xd2a7a000  ! 2213: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xdcb70e40  ! 2214: STHA_R	stha	%r14, [%r28 + %r0] 0x72
	.word 0x8780204f  ! 2215: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x0, %r25
	mov	0x40, %r25
	.word 0x8780204f  ! 2218: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 2219: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeafa000  ! 2220: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xdaa584a0  ! 2221: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	mov	0x8, %r26
	.word 0xd88f6000  ! 2223: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	mov	0x18, %r18
	.word 0xd897a000  ! 2225: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2226: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r25
	mov	0x70, %r26
	.word 0xdcf74e80  ! 2229: STXA_R	stxa	%r14, [%r29 + %r0] 0x74
	mov	0x40, %r16
	.word 0x87802074  ! 2231: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a76000  ! 2232: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0b649e0  ! 2233: STHA_R	stha	%r8, [%r25 + %r0] 0x4f
	.word 0xd4b7a000  ! 2234: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0xd4bf6000  ! 2236: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 2237: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 2238: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2ce49e0  ! 2239: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r9
	.word 0xdcbfa000  ! 2240: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdccfa000  ! 2241: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0x87802073  ! 2242: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde840400  ! 2243: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	mov	0x0, %r16
	.word 0x8780204f  ! 2245: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 2246: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r17
	.word 0xd6bf0e40  ! 2248: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	mov	0x3f8, %r20
	.word 0xda8f8e60  ! 2250: LDUBA_R	lduba	[%r30, %r0] 0x73, %r13
	mov	0x7d8, %r20
	.word 0x87802073  ! 2252: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdedfce60  ! 2253: LDXA_R	ldxa	[%r31, %r0] 0x73, %r15
	.word 0xd2dc0400  ! 2254: LDXA_R	ldxa	[%r16, %r0] 0x20, %r9
	.word 0xd2be89e0  ! 2255: STDA_R	stda	%r9, [%r26 + %r0] 0x4f
	mov	0x48, %r24
	.word 0xd2b6a000  ! 2257: STHA_I	stha	%r9, [%r26 + 0x0000] %asi
	.word 0xd2b6e000  ! 2258: STHA_I	stha	%r9, [%r27 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xd2cee000  ! 2260: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	.word 0xd2c66000  ! 2261: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r9
	mov	0x30, %r26
	.word 0xd2b62000  ! 2263: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	.word 0xd69689e0  ! 2264: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r11
	.word 0xdcb6a000  ! 2265: STHA_I	stha	%r14, [%r26 + 0x0000] %asi
	.word 0xdcc66000  ! 2266: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	.word 0xdad504a0  ! 2267: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r13
	.word 0x87802074  ! 2268: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2d44400  ! 2269: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r9
	mov	0x58, %r16
	.word 0xdacc2000  ! 2271: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xd6af8e40  ! 2272: STBA_R	stba	%r11, [%r30 + %r0] 0x72
	mov	0x7d8, %r20
	.word 0xd0ac2000  ! 2274: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xd0b42000  ! 2275: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xd08c6000  ! 2276: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	mov	0x7c8, %r22
	.word 0x87802025  ! 2278: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2279: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd085a000  ! 2280: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r8
	.word 0xd0a56000  ! 2281: STWA_I	stwa	%r8, [%r21 + 0x0000] %asi
	mov	0x7c8, %r22
	.word 0xd08d6000  ! 2283: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r8
	mov	0x7e8, %r21
	.word 0xd68d84a0  ! 2285: LDUBA_R	lduba	[%r22, %r0] 0x25, %r11
	.word 0xdca52000  ! 2286: STWA_I	stwa	%r14, [%r20 + 0x0000] %asi
	.word 0xdc8de000  ! 2287: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r14
	.word 0xdaf4c400  ! 2288: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	mov	0x60, %r27
	mov	0x68, %r24
	mov	0x58, %r16
	.word 0xd4840400  ! 2292: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	.word 0xdebd44a0  ! 2293: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	.word 0xd0d78e60  ! 2294: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r8
	.word 0xd88dc4a0  ! 2295: LDUBA_R	lduba	[%r23, %r0] 0x25, %r12
	.word 0x8780204f  ! 2296: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b7ce60  ! 2297: STHA_R	stha	%r11, [%r31 + %r0] 0x73
	mov	0x3d0, %r20
	.word 0xda970e40  ! 2299: LDUHA_R	lduha	[%r28, %r0] 0x72, %r13
	mov	0x18, %r25
	.word 0xd8f584a0  ! 2301: STXA_R	stxa	%r12, [%r22 + %r0] 0x25
	.word 0xd6a7e000  ! 2302: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xd0bf4e80  ! 2303: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	.word 0xd2f74e80  ! 2304: STXA_R	stxa	%r9, [%r29 + %r0] 0x74
	.word 0xd2c70e80  ! 2305: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r9
	.word 0xdcc544a0  ! 2306: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r14
	mov	0x3f8, %r23
	.word 0xd4cc4400  ! 2308: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r10
	.word 0xd4ccc400  ! 2309: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0x87802025  ! 2310: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf40400  ! 2311: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xdccd44a0  ! 2312: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r14
	mov	0x3e0, %r22
	.word 0xda9ea000  ! 2314: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r13
	.word 0xd4948400  ! 2315: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	.word 0x87802072  ! 2316: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde86c9e0  ! 2317: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r15
	mov	0x30, %r17
	mov	0x7d0, %r22
	.word 0xdaafe000  ! 2320: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xd4afce60  ! 2321: STBA_R	stba	%r10, [%r31 + %r0] 0x73
	.word 0xd4ad04a0  ! 2322: STBA_R	stba	%r10, [%r20 + %r0] 0x25
	.word 0xdaafe000  ! 2323: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xdaf7e000  ! 2324: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xdaaf6000  ! 2325: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xd2cc8400  ! 2326: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	mov	0x48, %r26
	.word 0xdab72000  ! 2328: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	mov	0x60, %r25
	.word 0x87802073  ! 2330: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2331: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29f4e60  ! 2332: LDDA_R	ldda	[%r29, %r0] 0x73, %r9
	.word 0xd8970e60  ! 2333: LDUHA_R	lduha	[%r28, %r0] 0x73, %r12
	.word 0xd4dfe000  ! 2334: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802025  ! 2335: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r17
	.word 0xd8940400  ! 2337: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	.word 0xd89c4400  ! 2338: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	.word 0xded42000  ! 2339: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	.word 0xde870e80  ! 2340: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r15
	.word 0xd0970e80  ! 2341: LDUHA_R	lduha	[%r28, %r0] 0x74, %r8
	mov	0x0, %r17
	mov	0x68, %r17
	.word 0xd4af0e40  ! 2344: STBA_R	stba	%r10, [%r28 + %r0] 0x72
	.word 0xdcb4a000  ! 2345: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xdab544a0  ! 2346: STHA_R	stha	%r13, [%r21 + %r0] 0x25
	.word 0xd8d7ce80  ! 2347: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r12
	.word 0xd8a544a0  ! 2348: STWA_R	stwa	%r12, [%r21 + %r0] 0x25
	.word 0xd09d44a0  ! 2349: LDDA_R	ldda	[%r21, %r0] 0x25, %r8
	.word 0xd2bf0e60  ! 2350: STDA_R	stda	%r9, [%r28 + %r0] 0x73
	mov	0x3e0, %r23
	mov	0x0, %r26
	.word 0xd6c44400  ! 2353: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r11
	.word 0xd08504a0  ! 2354: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r8
	mov	0x3e0, %r22
	.word 0xdeac2000  ! 2356: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xda8609e0  ! 2357: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r13
	mov	0x8, %r18
	mov	0x38, %r25
	mov	0x7e0, %r22
	.word 0xd2a4c400  ! 2361: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	mov	0x7f8, %r22
	mov	0x7e0, %r21
	.word 0xd4ad84a0  ! 2364: STBA_R	stba	%r10, [%r22 + %r0] 0x25
	mov	0x30, %r27
	.word 0x8780204f  ! 2366: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf7ce40  ! 2367: STXA_R	stxa	%r13, [%r31 + %r0] 0x72
	mov	0x70, %r26
	.word 0xd8b504a0  ! 2369: STHA_R	stha	%r12, [%r20 + %r0] 0x25
	.word 0xd097ce60  ! 2370: LDUHA_R	lduha	[%r31, %r0] 0x73, %r8
	mov	0x7d0, %r23
	mov	0x50, %r26
	mov	0x48, %r16
	.word 0xd2be2000  ! 2374: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	.word 0xdc840400  ! 2375: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	.word 0x87802020  ! 2376: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r26
	.word 0xdabc8400  ! 2378: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	.word 0xd2f74e60  ! 2379: STXA_R	stxa	%r9, [%r29 + %r0] 0x73
	.word 0xd2c42000  ! 2380: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	mov	0x50, %r24
	mov	0x3f0, %r20
	.word 0x87802025  ! 2383: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 2384: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2a74e60  ! 2385: STWA_R	stwa	%r9, [%r29 + %r0] 0x73
	.word 0xd297ce60  ! 2386: LDUHA_R	lduha	[%r31, %r0] 0x73, %r9
	.word 0xd49d84a0  ! 2387: LDDA_R	ldda	[%r22, %r0] 0x25, %r10
	.word 0x87802025  ! 2388: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd48e09e0  ! 2389: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r10
	.word 0xd6c7ce40  ! 2390: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r11
	.word 0xde97a000  ! 2391: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	.word 0xdea7a000  ! 2392: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xded76000  ! 2393: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0xdcf70e80  ! 2394: STXA_R	stxa	%r14, [%r28 + %r0] 0x74
	.word 0xd8af6000  ! 2395: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd88fe000  ! 2396: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd4f609e0  ! 2397: STXA_R	stxa	%r10, [%r24 + %r0] 0x4f
	.word 0xd4f76000  ! 2398: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4bfa000  ! 2399: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd497e000  ! 2400: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	mov	0x7e8, %r22
	.word 0xd4d7a000  ! 2402: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	mov	0x0, %r16
	mov	0x3d8, %r22
	mov	0x3d8, %r22
	.word 0xd4972000  ! 2406: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	mov	0x10, %r24
	.word 0xd8a44400  ! 2408: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xd6bcc400  ! 2409: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0xd08cc400  ! 2410: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	.word 0xd6ccc400  ! 2411: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	mov	0x68, %r16
	.word 0xdaf72000  ! 2413: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdaa7e000  ! 2414: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xdac72000  ! 2415: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0x87802025  ! 2416: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaa72000  ! 2417: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 2418: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d8, %r23
	.word 0xdad66000  ! 2420: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r13
	.word 0xd6bf0e40  ! 2421: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	mov	0x38, %r17
	.word 0xd29544a0  ! 2423: LDUHA_R	lduha	[%r21, %r0] 0x25, %r9
	.word 0xdabe2000  ! 2424: STDA_I	stda	%r13, [%r24 + 0x0000] %asi
	mov	0x48, %r17
	.word 0xdaa62000  ! 2426: STWA_I	stwa	%r13, [%r24 + 0x0000] %asi
	.word 0xdade6000  ! 2427: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r13
	.word 0xdabea000  ! 2428: STDA_I	stda	%r13, [%r26 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xdab6a000  ! 2430: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	mov	0x10, %r16
	.word 0xdac6a000  ! 2432: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r13
	mov	0x3f0, %r21
	.word 0x87802074  ! 2434: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r26
	.word 0xdac7e000  ! 2436: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xd4d4c400  ! 2437: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0xdc8f8e60  ! 2438: LDUBA_R	lduba	[%r30, %r0] 0x73, %r14
	mov	0x8, %r16
	mov	0x68, %r24
	.word 0xd8dfa000  ! 2441: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	mov	0x3c0, %r20
	.word 0xd2874e40  ! 2443: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r9
	mov	0x58, %r25
	.word 0x87802072  ! 2445: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2ac6000  ! 2446: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 2447: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2b4e000  ! 2449: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x7d8, %r21
	mov	0x3c0, %r20
	.word 0xd0ae49e0  ! 2453: STBA_R	stba	%r8, [%r25 + %r0] 0x4f
	.word 0xd0d4e000  ! 2454: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	.word 0xdeadc4a0  ! 2455: STBA_R	stba	%r15, [%r23 + %r0] 0x25
	mov	0x3e8, %r22
	.word 0xdaa7ce40  ! 2457: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	mov	0x60, %r27
	.word 0xdadc6000  ! 2459: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xdacc6000  ! 2460: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	.word 0x87802074  ! 2461: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6ac4400  ! 2462: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xdcafce80  ! 2463: STBA_R	stba	%r14, [%r31 + %r0] 0x74
	.word 0x8780204f  ! 2464: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r17
	.word 0x8780204f  ! 2466: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 2467: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4af8e40  ! 2468: STBA_R	stba	%r10, [%r30 + %r0] 0x72
	.word 0xd8cf0e40  ! 2469: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r12
	mov	0x20, %r25
	.word 0xd2bd84a0  ! 2471: STDA_R	stda	%r9, [%r22 + %r0] 0x25
	.word 0xd897a000  ! 2472: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0xd897a000  ! 2473: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2474: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0848400  ! 2475: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r8
	.word 0xd0856000  ! 2476: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r8
	mov	0x3e8, %r22
	.word 0xd2b649e0  ! 2478: STHA_R	stha	%r9, [%r25 + %r0] 0x4f
	.word 0xded649e0  ! 2479: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r15
	.word 0xd8d44400  ! 2480: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	.word 0x87802072  ! 2481: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c0, %r20
	.word 0xdcaf0e60  ! 2483: STBA_R	stba	%r14, [%r28 + %r0] 0x73
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2d7ce60  ! 2485: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r9
	.word 0xd2a72000  ! 2486: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	mov	0x48, %r18
	.word 0x87802025  ! 2488: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2f7e000  ! 2489: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd2df2000  ! 2490: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd6c78e40  ! 2491: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	mov	0x18, %r25
	.word 0xda9f6000  ! 2493: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xd69cc400  ! 2494: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	mov	0x38, %r19
	.word 0x87802025  ! 2496: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdef74e80  ! 2497: STXA_R	stxa	%r15, [%r29 + %r0] 0x74
	mov	0x7e0, %r22
	.word 0xdacf0e80  ! 2499: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r13
	mov	0x78, %r24
	.word 0xdabf6000  ! 2501: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xdaf7e000  ! 2502: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xdaa7a000  ! 2503: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	mov	0x68, %r27
	.word 0xd09d44a0  ! 2505: LDDA_R	ldda	[%r21, %r0] 0x25, %r8
	.word 0xd0a7a000  ! 2506: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xdabfce40  ! 2507: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	.word 0xd0a504a0  ! 2508: STWA_R	stwa	%r8, [%r20 + %r0] 0x25
	.word 0x87802073  ! 2509: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 2510: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 2511: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd4874e40  ! 2513: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r10
	mov	0x38, %r26
	.word 0xd4f52000  ! 2515: STXA_I	stxa	%r10, [%r20 + 0x0000] %asi
	mov	0x40, %r19
	mov	0x30, %r24
	.word 0xd4d56000  ! 2518: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r10
	mov	0x7c0, %r20
	.word 0xdcd6c9e0  ! 2520: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r14
	mov	0x40, %r18
	.word 0xdcf5e000  ! 2522: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0xdca52000  ! 2523: STWA_I	stwa	%r14, [%r20 + 0x0000] %asi
	.word 0x87802072  ! 2524: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6978e40  ! 2525: LDUHA_R	lduha	[%r30, %r0] 0x72, %r11
	.word 0xd0874e80  ! 2526: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r8
	.word 0xd88f8e60  ! 2527: LDUBA_R	lduba	[%r30, %r0] 0x73, %r12
	.word 0xdede09e0  ! 2528: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r15
	.word 0xdc972000  ! 2529: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	.word 0xdcdfe000  ! 2530: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	mov	0x20, %r24
	.word 0xdccf6000  ! 2532: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	mov	0x7c0, %r20
	.word 0xdc8f6000  ! 2534: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdabe09e0  ! 2535: STDA_R	stda	%r13, [%r24 + %r0] 0x4f
	.word 0xdead84a0  ! 2536: STBA_R	stba	%r15, [%r22 + %r0] 0x25
	.word 0x87802072  ! 2537: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r26
	.word 0xd684c400  ! 2539: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	.word 0xd69ec9e0  ! 2540: LDDA_R	ldda	[%r27, %r0] 0x4f, %r11
	.word 0xd49f0e60  ! 2541: LDDA_R	ldda	[%r28, %r0] 0x73, %r10
	.word 0x87802072  ! 2542: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d8, %r22
	.word 0xdcd72000  ! 2544: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xd49f0e40  ! 2545: LDDA_R	ldda	[%r28, %r0] 0x72, %r10
	mov	0x3e0, %r23
	.word 0xd0bfa000  ! 2547: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0xd0bf6000  ! 2548: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd4cf0e80  ! 2549: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r10
	.word 0xda97a000  ! 2550: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	mov	0x20, %r19
	.word 0xdadf6000  ! 2552: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	mov	0x3f0, %r23
	mov	0x28, %r26
	.word 0xdaf7e000  ! 2555: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	mov	0x40, %r18
	.word 0x87802072  ! 2557: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf4a000  ! 2558: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0xda842000  ! 2559: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r13
	mov	0x7e8, %r23
	.word 0xdaf46000  ! 2561: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0xdad4a000  ! 2562: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0xd2b74e60  ! 2563: STHA_R	stha	%r9, [%r29 + %r0] 0x73
	.word 0x87802020  ! 2564: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cc8400  ! 2565: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0xdabd6000  ! 2566: STDA_I	stda	%r13, [%r21 + 0x0000] %asi
	.word 0xdaad2000  ! 2567: STBA_I	stba	%r13, [%r20 + 0x0000] %asi
	.word 0xdaf5e000  ! 2568: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0xdab56000  ! 2569: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	.word 0xd0cd84a0  ! 2570: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r8
	.word 0xd6a70e80  ! 2571: STWA_R	stwa	%r11, [%r28 + %r0] 0x74
	mov	0x7e0, %r22
	.word 0x87802074  ! 2573: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef609e0  ! 2574: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	mov	0x58, %r16
	.word 0xd28e89e0  ! 2576: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r9
	mov	0x7c0, %r22
	.word 0xd08c2000  ! 2578: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 2579: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0cfe000  ! 2580: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xd4cc4400  ! 2581: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r10
	.word 0xda8f8e80  ! 2582: LDUBA_R	lduba	[%r30, %r0] 0x74, %r13
	.word 0xdc974e80  ! 2583: LDUHA_R	lduha	[%r29, %r0] 0x74, %r14
	.word 0xd29f8e80  ! 2584: LDDA_R	ldda	[%r30, %r0] 0x74, %r9
	mov	0x58, %r24
	.word 0xd49f4e40  ! 2586: LDDA_R	ldda	[%r29, %r0] 0x72, %r10
	.word 0x87802020  ! 2587: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9c8400  ! 2588: LDDA_R	ldda	[%r18, %r0] 0x20, %r13
	.word 0xd2f7a000  ! 2589: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 2590: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda9584a0  ! 2591: LDUHA_R	lduha	[%r22, %r0] 0x25, %r13
	.word 0xd8cfe000  ! 2592: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xdaad04a0  ! 2593: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	.word 0xd09f6000  ! 2594: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	.word 0x87802074  ! 2595: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r17
	mov	0x7f8, %r22
	.word 0xd09fe000  ! 2598: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	mov	0x48, %r26
	mov	0x30, %r24
	.word 0x87802020  ! 2601: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b72000  ! 2602: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 2603: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b74e80  ! 2604: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	mov	0x3c8, %r21
	.word 0xd0948400  ! 2606: LDUHA_R	lduha	[%r18, %r0] 0x20, %r8
	.word 0xd2852000  ! 2607: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r9
	.word 0xdccfce60  ! 2608: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r14
	.word 0xd29584a0  ! 2609: LDUHA_R	lduha	[%r22, %r0] 0x25, %r9
	mov	0x3e8, %r20
	.word 0xd68dc4a0  ! 2611: LDUBA_R	lduba	[%r23, %r0] 0x25, %r11
	.word 0xd6d52000  ! 2612: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r11
	.word 0xd6a5a000  ! 2613: STWA_I	stwa	%r11, [%r22 + 0x0000] %asi
	.word 0xd0b74e60  ! 2614: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	.word 0xdaf56000  ! 2615: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	.word 0xd8b40400  ! 2616: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0x87802025  ! 2617: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabec9e0  ! 2618: STDA_R	stda	%r13, [%r27 + %r0] 0x4f
	.word 0xd0cc0400  ! 2619: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xdea48400  ! 2620: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xdac7ce80  ! 2621: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r13
	.word 0xd8bc8400  ! 2622: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	mov	0x58, %r18
	.word 0xd2b6c9e0  ! 2624: STHA_R	stha	%r9, [%r27 + %r0] 0x4f
	.word 0xd6846000  ! 2625: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r11
	.word 0xd6b46000  ! 2626: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd0f78e40  ! 2627: STXA_R	stxa	%r8, [%r30 + %r0] 0x72
	mov	0x7d0, %r23
	.word 0x87802025  ! 2629: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb72000  ! 2630: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xdc97e000  ! 2631: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xd4ac0400  ! 2632: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x48, %r16
	.word 0xdece49e0  ! 2635: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r15
	mov	0x68, %r19
	.word 0xd0a76000  ! 2637: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	mov	0x7f8, %r23
	.word 0xd0b72000  ! 2639: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 2640: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r17
	.word 0x87802072  ! 2642: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a78e40  ! 2643: STWA_R	stwa	%r10, [%r30 + %r0] 0x72
	.word 0xd2d7e000  ! 2644: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 2645: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2646: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b70e40  ! 2647: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	.word 0x87802073  ! 2648: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2649: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r18
	.word 0x87802020  ! 2651: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r21
	.word 0x8780204f  ! 2653: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf42000  ! 2654: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0xd4870e60  ! 2655: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r10
	.word 0x8780204f  ! 2656: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4c78e80  ! 2657: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r10
	.word 0xd8cfce60  ! 2658: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r12
	.word 0xda8c2000  ! 2659: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r13
	.word 0xda9c6000  ! 2660: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	mov	0x68, %r16
	.word 0xdad4a000  ! 2662: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0xd6cd84a0  ! 2663: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r11
	.word 0x8780204f  ! 2664: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bf4e80  ! 2665: STDA_R	stda	%r10, [%r29 + %r0] 0x74
	.word 0xd6afe000  ! 2666: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 2667: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r19
	.word 0xd6f6c9e0  ! 2669: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x20, %r18
	.word 0xd2bfa000  ! 2672: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	mov	0x0, %r27
	.word 0xd2b72000  ! 2674: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd2b72000  ! 2675: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0xdcbd04a0  ! 2677: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	mov	0x58, %r25
	.word 0xdaad04a0  ! 2679: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	.word 0x87802072  ! 2680: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6afa000  ! 2681: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xdcf70e80  ! 2682: STXA_R	stxa	%r14, [%r28 + %r0] 0x74
	.word 0xd48fe000  ! 2683: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xd0ae89e0  ! 2684: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	.word 0xd4acc400  ! 2685: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xd6976000  ! 2686: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	.word 0xdc9d84a0  ! 2687: LDDA_R	ldda	[%r22, %r0] 0x25, %r14
	.word 0xdacfce80  ! 2688: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r13
	.word 0x87802074  ! 2689: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2690: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0bc0400  ! 2691: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0xd8bce000  ! 2692: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xdaaf0e80  ! 2693: STBA_R	stba	%r13, [%r28 + %r0] 0x74
	.word 0xdcbc6000  ! 2694: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	mov	0x3e0, %r23
	.word 0xdcbce000  ! 2696: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 2697: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r25
	.word 0xd6a6c9e0  ! 2699: STWA_R	stwa	%r11, [%r27 + %r0] 0x4f
	.word 0xd8cf2000  ! 2700: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0x87802072  ! 2701: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8bea000  ! 2702: STDA_I	stda	%r12, [%r26 + 0x0000] %asi
	.word 0xd2bcc400  ! 2703: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xde8d04a0  ! 2704: LDUBA_R	lduba	[%r20, %r0] 0x25, %r15
	.word 0x87802074  ! 2705: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r24
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd4dee000  ! 2708: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r10
	mov	0x10, %r18
	.word 0xd68f0e80  ! 2710: LDUBA_R	lduba	[%r28, %r0] 0x74, %r11
	.word 0xdaafce60  ! 2711: STBA_R	stba	%r13, [%r31 + %r0] 0x73
	.word 0xdaa78e80  ! 2712: STWA_R	stwa	%r13, [%r30 + %r0] 0x74
	.word 0xd8bea000  ! 2713: STDA_I	stda	%r12, [%r26 + 0x0000] %asi
	.word 0xd4d70e80  ! 2714: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r10
	.word 0x87802074  ! 2715: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2716: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdad46000  ! 2717: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	.word 0xd4afce60  ! 2718: STBA_R	stba	%r10, [%r31 + %r0] 0x73
	.word 0xd0946000  ! 2719: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0xd094e000  ! 2720: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0x87802025  ! 2721: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaf74e40  ! 2722: STXA_R	stxa	%r13, [%r29 + %r0] 0x72
	mov	0x48, %r18
	mov	0x78, %r16
	mov	0x10, %r18
	.word 0xda856000  ! 2726: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r13
	.word 0xde9f0e80  ! 2727: LDDA_R	ldda	[%r28, %r0] 0x74, %r15
	.word 0x87802020  ! 2728: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49d04a0  ! 2729: LDDA_R	ldda	[%r20, %r0] 0x25, %r10
	.word 0xd8dc8400  ! 2730: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0x87802072  ! 2731: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca74e80  ! 2732: STWA_R	stwa	%r14, [%r29 + %r0] 0x74
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdecf0e80  ! 2734: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r15
	.word 0xd08fe000  ! 2735: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	.word 0xd4af0e80  ! 2736: STBA_R	stba	%r10, [%r28 + %r0] 0x74
	.word 0x87802073  ! 2737: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8a42000  ! 2738: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8d4a000  ! 2739: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2740: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6948400  ! 2741: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	.word 0xde95e000  ! 2742: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r15
	.word 0xd0c40400  ! 2743: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	.word 0xd6af0e40  ! 2744: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	.word 0x87802020  ! 2745: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6af6000  ! 2746: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x38, %r17
	.word 0x8780204f  ! 2748: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6848400  ! 2749: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	.word 0x87802025  ! 2750: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdea7ce80  ! 2751: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	.word 0xda8c0400  ! 2752: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	.word 0xd6ae49e0  ! 2753: STBA_R	stba	%r11, [%r25 + %r0] 0x4f
	.word 0xd6bfe000  ! 2754: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xdea6c9e0  ! 2755: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	.word 0xd09fe000  ! 2756: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	.word 0xd0876000  ! 2757: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	.word 0xda8c0400  ! 2758: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	mov	0x20, %r17
	.word 0xdcadc4a0  ! 2760: STBA_R	stba	%r14, [%r23 + %r0] 0x25
	.word 0x8780204f  ! 2761: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r25
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd4bf0e60  ! 2764: STDA_R	stda	%r10, [%r28 + %r0] 0x73
	.word 0x87802020  ! 2765: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r22
	.word 0xd69f2000  ! 2767: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	mov	0x8, %r26
	.word 0x87802073  ! 2769: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2770: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dfce60  ! 2771: LDXA_R	ldxa	[%r31, %r0] 0x73, %r9
	.word 0xdab7a000  ! 2772: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdab7a000  ! 2773: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdcb44400  ! 2774: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0xd0a544a0  ! 2775: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	.word 0xdebf2000  ! 2776: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xdca74e40  ! 2777: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	.word 0xdedf0e40  ! 2778: LDXA_R	ldxa	[%r28, %r0] 0x72, %r15
	mov	0x7e8, %r21
	.word 0x87802020  ! 2780: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2781: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8b7e000  ! 2782: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0xd4dc0400  ! 2783: LDXA_R	ldxa	[%r16, %r0] 0x20, %r10
	.word 0x87802073  ! 2784: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdadfe000  ! 2785: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0xd4c78e80  ! 2786: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r10
	.word 0x87802073  ! 2787: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4af6000  ! 2788: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xd4bf2000  ! 2790: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd8a584a0  ! 2791: STWA_R	stwa	%r12, [%r22 + %r0] 0x25
	.word 0x87802025  ! 2792: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd895a000  ! 2793: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r12
	.word 0xd885e000  ! 2794: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r12
	.word 0x87802072  ! 2795: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b78e80  ! 2796: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	.word 0xd8a40400  ! 2797: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0xd2c4e000  ! 2798: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xdec48400  ! 2799: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	mov	0x50, %r24
	mov	0x3d8, %r23
	.word 0xdab4a000  ! 2802: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x20, %r19
	.word 0xd68d04a0  ! 2805: LDUBA_R	lduba	[%r20, %r0] 0x25, %r11
	.word 0xd8ad84a0  ! 2806: STBA_R	stba	%r12, [%r22 + %r0] 0x25
	.word 0xd6846000  ! 2807: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r11
	.word 0xd8ac0400  ! 2808: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xd4ac2000  ! 2809: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0xd4842000  ! 2810: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	mov	0x7d8, %r22
	mov	0x8, %r25
	.word 0xd4b4e000  ! 2813: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	mov	0x58, %r18
	.word 0x87802020  ! 2815: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2816: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r17
	mov	0x7e8, %r21
	.word 0x8780204f  ! 2819: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r18
	mov	0x30, %r26
	.word 0x87802073  ! 2822: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4a7ce80  ! 2823: STWA_R	stwa	%r10, [%r31 + %r0] 0x74
	.word 0xdc9da000  ! 2824: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r14
	.word 0xdcb5a000  ! 2825: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0xd096c9e0  ! 2826: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r8
	.word 0xde8d2000  ! 2827: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r15
	mov	0x60, %r18
	.word 0x87802073  ! 2829: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd89609e0  ! 2830: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r12
	.word 0x87802020  ! 2831: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f40400  ! 2832: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	.word 0xdac44400  ! 2833: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r13
	.word 0xdadfa000  ! 2834: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0x87802025  ! 2835: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaf72000  ! 2836: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdaa76000  ! 2837: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xdeb7ce40  ! 2838: STHA_R	stha	%r15, [%r31 + %r0] 0x72
	.word 0xd88c0400  ! 2839: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	.word 0x87802020  ! 2840: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f4c400  ! 2841: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0xda948400  ! 2842: LDUHA_R	lduha	[%r18, %r0] 0x20, %r13
	mov	0x28, %r26
	mov	0x7d0, %r23
	.word 0xdcd74e60  ! 2845: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r14
	.word 0xd8dc6000  ! 2846: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	.word 0x87802025  ! 2847: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaa74e60  ! 2848: STWA_R	stwa	%r13, [%r29 + %r0] 0x73
	.word 0xd28cc400  ! 2849: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	.word 0xdab4a000  ! 2850: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0xda946000  ! 2851: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	.word 0xdabca000  ! 2852: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xd4bc0400  ! 2853: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xdca649e0  ! 2854: STWA_R	stwa	%r14, [%r25 + %r0] 0x4f
	.word 0xd6f40400  ! 2855: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	.word 0x87802020  ! 2856: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r18
	.word 0xd6952000  ! 2858: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r11
	mov	0x58, %r16
	.word 0xd4f78e40  ! 2860: STXA_R	stxa	%r10, [%r30 + %r0] 0x72
	.word 0xd497ce80  ! 2861: LDUHA_R	lduha	[%r31, %r0] 0x74, %r10
	.word 0xd4bcc400  ! 2862: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0xd685e000  ! 2863: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r11
	mov	0x3c8, %r22
	mov	0x7c0, %r22
	.word 0xd6974e80  ! 2866: LDUHA_R	lduha	[%r29, %r0] 0x74, %r11
	.word 0x87802074  ! 2867: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda878e40  ! 2868: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r13
	.word 0xd0b7a000  ! 2869: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd0d72000  ! 2870: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd4aec9e0  ! 2871: STBA_R	stba	%r10, [%r27 + %r0] 0x4f
	.word 0xd49cc400  ! 2872: LDDA_R	ldda	[%r19, %r0] 0x20, %r10
	mov	0x58, %r16
	.word 0xd4cf6000  ! 2874: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0x87802025  ! 2875: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8d649e0  ! 2876: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r12
	.word 0xd2dd04a0  ! 2877: LDXA_R	ldxa	[%r20, %r0] 0x25, %r9
	.word 0x8780204f  ! 2878: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0ad04a0  ! 2879: STBA_R	stba	%r8, [%r20 + %r0] 0x25
	mov	0x3e0, %r22
	.word 0xd88fe000  ! 2881: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd89fa000  ! 2882: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	.word 0x87802072  ! 2883: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r24
	.word 0xd885e000  ! 2885: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r12
	mov	0x3c0, %r23
	.word 0xd89d6000  ! 2887: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r12
	.word 0xd8dd2000  ! 2888: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r12
	.word 0xd6af0e60  ! 2889: STBA_R	stba	%r11, [%r28 + %r0] 0x73
	mov	0x38, %r24
	mov	0x8, %r26
	mov	0x0, %r27
	.word 0x87802025  ! 2893: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2894: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd096c9e0  ! 2895: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r8
	.word 0x87802025  ! 2896: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bc4400  ! 2897: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	mov	0x3c0, %r20
	mov	0x7c8, %r23
	mov	0x7e0, %r23
	mov	0x60, %r26
	.word 0xda878e60  ! 2902: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r13
	.word 0xd4ae2000  ! 2903: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	.word 0x87802073  ! 2904: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdebfce60  ! 2905: STDA_R	stda	%r15, [%r31 + %r0] 0x73
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdc9d2000  ! 2907: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r14
	.word 0xd0c74e60  ! 2908: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r8
	.word 0x87802074  ! 2909: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r19
	.word 0xd2bfe000  ! 2911: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	mov	0x3d8, %r22
	.word 0xd2d72000  ! 2913: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xd29f6000  ! 2914: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xdcc544a0  ! 2915: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r14
	.word 0x87802073  ! 2916: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdabfa000  ! 2917: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdaf7a000  ! 2918: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 2919: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r23
	.word 0xdaae6000  ! 2921: STBA_I	stba	%r13, [%r25 + 0x0000] %asi
	mov	0x3f8, %r22
	mov	0x7f0, %r22
	mov	0x3c8, %r21
	mov	0x78, %r18
	.word 0xdabfce80  ! 2926: STDA_R	stda	%r13, [%r31 + %r0] 0x74
	mov	0x3e0, %r20
	mov	0x3d0, %r20
	.word 0xd89fce80  ! 2929: LDDA_R	ldda	[%r31, %r0] 0x74, %r12
	.word 0xd0962000  ! 2930: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r8
	mov	0x68, %r27
	.word 0xd4bc4400  ! 2932: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0x87802020  ! 2933: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8966000  ! 2934: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r12
	.word 0xd8a6e000  ! 2935: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	.word 0xd896a000  ! 2936: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r12
	.word 0xdcdc4400  ! 2937: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	.word 0xd8f6a000  ! 2938: STXA_I	stxa	%r12, [%r26 + 0x0000] %asi
	.word 0xd8c66000  ! 2939: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r12
	mov	0x38, %r25
	mov	0x68, %r25
	.word 0xdcf7ce80  ! 2942: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	.word 0xdeb78e80  ! 2943: STHA_R	stha	%r15, [%r30 + %r0] 0x74
	mov	0x3d0, %r20
	.word 0xde8ee000  ! 2945: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r15
	.word 0xd2a48400  ! 2946: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0x87802073  ! 2947: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2948: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d44400  ! 2949: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r9
	.word 0xd4b40400  ! 2950: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	mov	0x7e8, %r22
	.word 0xd0cfa000  ! 2952: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0xd0cf6000  ! 2953: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	mov	0x8, %r26
	.word 0x87802025  ! 2955: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r25
	.word 0x87802020  ! 2957: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2958: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd48584a0  ! 2959: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r10
	.word 0xd48c8400  ! 2960: LDUBA_R	lduba	[%r18, %r0] 0x20, %r10
	mov	0x28, %r24
	mov	0x60, %r16
	.word 0xd2c52000  ! 2963: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r9
	mov	0x7f0, %r21
	.word 0xd2f52000  ! 2965: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	mov	0x78, %r24
	.word 0xd2dd6000  ! 2967: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r9
	mov	0x40, %r26
	.word 0xd2d5a000  ! 2969: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r9
	.word 0xd6970e40  ! 2970: LDUHA_R	lduha	[%r28, %r0] 0x72, %r11
	mov	0x7e0, %r23
	.word 0x87802074  ! 2972: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacc8400  ! 2973: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r13
	.word 0xd6f544a0  ! 2974: STXA_R	stxa	%r11, [%r21 + %r0] 0x25
	.word 0x87802074  ! 2975: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b48400  ! 2976: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	mov	0x3d8, %r21
	.word 0xd0dfe000  ! 2978: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	mov	0x50, %r19
	.word 0xd0b76000  ! 2980: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 2981: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r25
	.word 0xdebe49e0  ! 2983: STDA_R	stda	%r15, [%r25 + %r0] 0x4f
	.word 0xdab42000  ! 2984: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	mov	0x3c8, %r20
	.word 0xdaaca000  ! 2986: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 2987: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda846000  ! 2988: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r13
	.word 0xd8ae89e0  ! 2989: STBA_R	stba	%r12, [%r26 + %r0] 0x4f
	.word 0xd8be09e0  ! 2990: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	.word 0xd0a6c9e0  ! 2991: STWA_R	stwa	%r8, [%r27 + %r0] 0x4f
	.word 0xd0a4e000  ! 2992: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd2878e60  ! 2993: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r9
	mov	0x7d0, %r22
	.word 0xdcb46000  ! 2995: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xd89f8e40  ! 2996: LDDA_R	ldda	[%r30, %r0] 0x72, %r12
	mov	0x28, %r16
	.word 0xd4d74e40  ! 2998: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r10
	mov	0x3f8, %r22
	.word 0xd88ce000  ! 3000: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	.word 0xd6b78e60  ! 3001: STHA_R	stha	%r11, [%r30 + %r0] 0x73
	mov	0x50, %r25
	.word 0xd4cc4400  ! 3003: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r10
	.word 0xd88f4e40  ! 3004: LDUBA_R	lduba	[%r29, %r0] 0x72, %r12
	.word 0xd8ac8400  ! 3005: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0x87802074  ! 3006: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6a40400  ! 3007: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0xd0f4a000  ! 3008: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xd89f0e80  ! 3009: LDDA_R	ldda	[%r28, %r0] 0x74, %r12
	.word 0xde942000  ! 3010: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	.word 0xdeb46000  ! 3011: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	mov	0x3d0, %r21
	.word 0xded42000  ! 3013: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	mov	0x68, %r27
	.word 0xdef42000  ! 3015: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xdebce000  ! 3016: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xdef46000  ! 3017: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 3018: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x40, %r17
	mov	0x38, %r19
	.word 0xdecea000  ! 3022: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r15
	.word 0xde962000  ! 3023: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r15
	mov	0x18, %r19
	.word 0xd4bd84a0  ! 3025: STDA_R	stda	%r10, [%r22 + %r0] 0x25
	.word 0xd8dee000  ! 3026: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r12
	mov	0x7c8, %r20
	.word 0xd8d66000  ! 3028: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r12
	.word 0xdccd84a0  ! 3029: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r14
	.word 0x87802025  ! 3030: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r24
	.word 0xd8b7ce60  ! 3032: STHA_R	stha	%r12, [%r31 + %r0] 0x73
	.word 0xd8c48400  ! 3033: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	.word 0x87802025  ! 3034: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd28dc4a0  ! 3036: LDUBA_R	lduba	[%r23, %r0] 0x25, %r9
	.word 0x87802074  ! 3037: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r27
	.word 0xd2bc0400  ! 3039: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xd09c0400  ! 3040: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	.word 0xd0ccc400  ! 3041: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	mov	0x7c8, %r22
	mov	0x7d8, %r20
	.word 0xd2d7e000  ! 3044: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xd6a7ce40  ! 3045: STWA_R	stwa	%r11, [%r31 + %r0] 0x72
	.word 0x87802025  ! 3046: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcdfa000  ! 3047: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	mov	0x30, %r27
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x40, %r27
	.word 0xd88d84a0  ! 3051: LDUBA_R	lduba	[%r22, %r0] 0x25, %r12
	.word 0xd8a7e000  ! 3052: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0xd6ac0400  ! 3054: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0xdaa74e60  ! 3055: STWA_R	stwa	%r13, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 3056: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdef46000  ! 3057: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xde9c2000  ! 3058: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3059: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dcc400  ! 3060: LDXA_R	ldxa	[%r19, %r0] 0x20, %r9
	.word 0xde856000  ! 3061: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r15
	mov	0x48, %r24
	mov	0x3d0, %r20
	.word 0xdea7ce40  ! 3064: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	.word 0xdcf56000  ! 3065: STXA_I	stxa	%r14, [%r21 + 0x0000] %asi
	.word 0xd8978e80  ! 3066: LDUHA_R	lduha	[%r30, %r0] 0x74, %r12
	.word 0x87802074  ! 3067: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabc0400  ! 3068: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xd6a4e000  ! 3069: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0xd09dc4a0  ! 3070: LDDA_R	ldda	[%r23, %r0] 0x25, %r8
	.word 0x87802074  ! 3071: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r18
	mov	0x68, %r27
	mov	0x40, %r25
	mov	0x8, %r17
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0bee000  ! 3077: STDA_I	stda	%r8, [%r27 + 0x0000] %asi
	.word 0xd08e6000  ! 3078: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r8
	.word 0xdef70e60  ! 3079: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	.word 0xd8962000  ! 3080: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r12
	.word 0xdab609e0  ! 3081: STHA_R	stha	%r13, [%r24 + %r0] 0x4f
	.word 0xdab6e000  ! 3082: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	.word 0xda9e6000  ! 3083: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r13
	.word 0xdaaee000  ! 3084: STBA_I	stba	%r13, [%r27 + 0x0000] %asi
	.word 0xdab6e000  ! 3085: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	.word 0xd88fce60  ! 3086: LDUBA_R	lduba	[%r31, %r0] 0x73, %r12
	.word 0xd48e2000  ! 3087: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r10
	.word 0xd486e000  ! 3088: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	.word 0xd4aea000  ! 3089: STBA_I	stba	%r10, [%r26 + 0x0000] %asi
	.word 0xd4f6e000  ! 3090: STXA_I	stxa	%r10, [%r27 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0x8780204f  ! 3092: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r26
	.word 0xd4a46000  ! 3094: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xd484a000  ! 3095: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r10
	.word 0xd484e000  ! 3096: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r10
	.word 0x87802073  ! 3097: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4bf6000  ! 3098: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	mov	0x7e8, %r22
	mov	0x7d0, %r23
	.word 0x87802020  ! 3101: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf44400  ! 3102: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xdc8fe000  ! 3103: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xd4974e80  ! 3104: LDUHA_R	lduha	[%r29, %r0] 0x74, %r10
	mov	0x40, %r26
	.word 0xd0a7ce60  ! 3106: STWA_R	stwa	%r8, [%r31 + %r0] 0x73
	.word 0xdecf2000  ! 3107: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xdea72000  ! 3108: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	mov	0x30, %r24
	mov	0x18, %r25
	.word 0x87802073  ! 3111: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e0, %r22
	mov	0x7d8, %r22
	.word 0x87802073  ! 3114: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f8, %r22
	mov	0x70, %r27
	.word 0xded70e60  ! 3117: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r15
	mov	0x3e0, %r20
	.word 0xd8cfa000  ! 3119: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xdcd40400  ! 3120: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	.word 0x8780204f  ! 3121: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r26
	.word 0xd4f7ce60  ! 3123: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	.word 0xd2a76000  ! 3124: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd6af0e40  ! 3125: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	.word 0x87802074  ! 3126: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3127: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3128: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cf8e40  ! 3129: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r10
	.word 0xd8a5c4a0  ! 3130: STWA_R	stwa	%r12, [%r23 + %r0] 0x25
	.word 0xdcbca000  ! 3131: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xd0bc4400  ! 3132: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xd4f7ce80  ! 3133: STXA_R	stxa	%r10, [%r31 + %r0] 0x74
	mov	0x30, %r26
	mov	0x40, %r25
	.word 0xd6940400  ! 3136: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	.word 0xdab42000  ! 3137: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xdcb70e60  ! 3138: STHA_R	stha	%r14, [%r28 + %r0] 0x73
	.word 0xd4840400  ! 3139: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	.word 0xdcc7ce80  ! 3140: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r14
	.word 0xdcaf0e60  ! 3141: STBA_R	stba	%r14, [%r28 + %r0] 0x73
	.word 0xd68c8400  ! 3142: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	.word 0x87802073  ! 3143: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa7e000  ! 3144: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xdccc8400  ! 3145: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	.word 0xd0a504a0  ! 3146: STWA_R	stwa	%r8, [%r20 + %r0] 0x25
	mov	0x70, %r26
	.word 0xde94c400  ! 3148: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	mov	0x70, %r24
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2d76000  ! 3151: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	mov	0x60, %r25
	.word 0xd2d72000  ! 3153: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	mov	0x20, %r24
	.word 0xd2872000  ! 3155: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2872000  ! 3156: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	mov	0x3f8, %r21
	.word 0xd8be49e0  ! 3158: STDA_R	stda	%r12, [%r25 + %r0] 0x4f
	.word 0xd8ac8400  ! 3159: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	mov	0x10, %r25
	.word 0xdebfce60  ! 3161: STDA_R	stda	%r15, [%r31 + %r0] 0x73
	.word 0xd2a7e000  ! 3162: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xd2cf6000  ! 3163: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	.word 0xd2bf6000  ! 3164: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd2afce60  ! 3165: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	.word 0xd8d5c4a0  ! 3166: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r12
	.word 0x87802074  ! 3167: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0ce49e0  ! 3168: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r8
	.word 0xdaafa000  ! 3169: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdaa72000  ! 3170: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xd6bc8400  ! 3171: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0x87802073  ! 3172: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3173: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cf6000  ! 3174: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd497ce80  ! 3175: LDUHA_R	lduha	[%r31, %r0] 0x74, %r10
	.word 0xd2876000  ! 3176: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2c72000  ! 3177: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xde940400  ! 3178: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0xd8d4c400  ! 3179: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0x87802020  ! 3180: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc842000  ! 3181: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	mov	0x70, %r26
	.word 0xda8fce60  ! 3183: LDUBA_R	lduba	[%r31, %r0] 0x73, %r13
	.word 0xdcb40400  ! 3184: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xd0b4a000  ! 3185: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xd6ac8400  ! 3186: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xda94e000  ! 3187: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r13
	.word 0xdacc2000  ! 3188: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xd6c4c400  ! 3189: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r11
	.word 0xd2bc8400  ! 3190: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	.word 0xdef44400  ! 3191: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0x87802025  ! 3192: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4978e60  ! 3193: LDUHA_R	lduha	[%r30, %r0] 0x73, %r10
	.word 0xdccca000  ! 3194: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	.word 0xdacc4400  ! 3195: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	.word 0xd2cd04a0  ! 3196: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r9
	.word 0xd08c2000  ! 3197: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	mov	0x10, %r27
	.word 0xd0cf0e60  ! 3199: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r8
	.word 0xdcaca000  ! 3200: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	mov	0x30, %r19
	mov	0x50, %r17
	.word 0xdcac6000  ! 3203: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xd0c70e60  ! 3204: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r8
	.word 0xd0a4a000  ! 3205: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0xde8e09e0  ! 3206: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r15
	.word 0xd4ce09e0  ! 3207: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r10
	.word 0x87802074  ! 3208: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6c7e000  ! 3209: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0x87802073  ! 3210: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd29f8e40  ! 3211: LDDA_R	ldda	[%r30, %r0] 0x72, %r9
	.word 0xd4dc6000  ! 3212: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	mov	0x60, %r17
	.word 0xd495c4a0  ! 3214: LDUHA_R	lduha	[%r23, %r0] 0x25, %r10
	.word 0xd8a48400  ! 3215: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	.word 0x87802025  ! 3216: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 3217: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4c74e80  ! 3218: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r10
	.word 0x87802074  ! 3219: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcc72000  ! 3220: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xdc8e49e0  ! 3221: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r14
	.word 0xd6976000  ! 3222: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	.word 0xd2cf0e40  ! 3223: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r9
	mov	0x10, %r26
	.word 0xd6b76000  ! 3225: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xdcdc4400  ! 3226: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	.word 0xdcac8400  ! 3227: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xdecf2000  ! 3228: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xd6a544a0  ! 3229: STWA_R	stwa	%r11, [%r21 + %r0] 0x25
	.word 0x87802020  ! 3230: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf76000  ! 3231: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xdaafe000  ! 3233: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xdef44400  ! 3235: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xdea7e000  ! 3236: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xdad44400  ! 3237: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	mov	0x3f8, %r22
	.word 0xd4874e60  ! 3239: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r10
	.word 0xdeb74e80  ! 3240: STHA_R	stha	%r15, [%r29 + %r0] 0x74
	mov	0x7d8, %r20
	.word 0xd4944400  ! 3242: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	.word 0xd4a4c400  ! 3243: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0xd8be09e0  ! 3244: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	.word 0xd8b40400  ! 3245: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	mov	0x28, %r16
	mov	0x40, %r18
	.word 0xdcdf6000  ! 3248: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0x87802073  ! 3249: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb66000  ! 3250: STHA_I	stha	%r14, [%r25 + 0x0000] %asi
	.word 0xdeb7ce40  ! 3251: STHA_R	stha	%r15, [%r31 + %r0] 0x72
	.word 0xd0dea000  ! 3252: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r8
	.word 0x87802020  ! 3253: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cce000  ! 3254: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	mov	0x40, %r25
	.word 0xd6d70e60  ! 3256: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r11
	.word 0xdc946000  ! 3257: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r14
	.word 0xdca42000  ! 3258: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	mov	0x30, %r27
	.word 0xdcc584a0  ! 3260: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r14
	.word 0x87802020  ! 3261: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29609e0  ! 3262: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r9
	.word 0xd4946000  ! 3263: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r10
	.word 0xd4f544a0  ! 3264: STXA_R	stxa	%r10, [%r21 + %r0] 0x25
	.word 0x8780204f  ! 3265: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3266: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r21
	mov	0x78, %r16
	.word 0xdeb56000  ! 3269: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	.word 0xde9de000  ! 3270: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r15
	.word 0xdaf649e0  ! 3271: STXA_R	stxa	%r13, [%r25 + %r0] 0x4f
	mov	0x18, %r19
	mov	0x18, %r19
	.word 0xd0d5e000  ! 3274: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r8
	mov	0x3e8, %r20
	.word 0xd4bf8e40  ! 3276: STDA_R	stda	%r10, [%r30 + %r0] 0x72
	.word 0xda848400  ! 3277: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r13
	.word 0xdabd2000  ! 3278: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 3279: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdab4e000  ! 3280: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xda846000  ! 3281: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r13
	.word 0xd4af4e80  ! 3282: STBA_R	stba	%r10, [%r29 + %r0] 0x74
	.word 0xd2d78e40  ! 3283: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r9
	mov	0x7c8, %r21
	.word 0xdcb42000  ! 3285: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xdca4e000  ! 3286: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	mov	0x7d0, %r20
	.word 0xdcac2000  ! 3288: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	mov	0x68, %r17
	.word 0xdcf46000  ! 3290: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdcd46000  ! 3291: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	.word 0x87802020  ! 3292: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3293: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 3294: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf7e000  ! 3295: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcf7e000  ! 3296: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdaafce80  ! 3297: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	.word 0x87802074  ! 3298: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0c7ce80  ! 3299: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r8
	mov	0x28, %r16
	.word 0x87802020  ! 3301: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0d6a000  ! 3302: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r8
	mov	0x60, %r25
	.word 0xdc8f8e60  ! 3304: LDUBA_R	lduba	[%r30, %r0] 0x73, %r14
	mov	0x10, %r25
	mov	0x50, %r19
	mov	0x48, %r27
	.word 0xd0be2000  ! 3308: STDA_I	stda	%r8, [%r24 + 0x0000] %asi
	.word 0x87802025  ! 3309: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd08ce000  ! 3310: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0x87802072  ! 3311: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd084e000  ! 3312: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	mov	0x3e0, %r22
	.word 0xd09ca000  ! 3314: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	.word 0x87802072  ! 3315: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd28fce80  ! 3316: LDUBA_R	lduba	[%r31, %r0] 0x74, %r9
	.word 0xdef78e60  ! 3317: STXA_R	stxa	%r15, [%r30 + %r0] 0x73
	.word 0xd2b46000  ! 3318: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0xd48fce80  ! 3320: LDUBA_R	lduba	[%r31, %r0] 0x74, %r10
	.word 0xdc8c6000  ! 3321: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r14
	.word 0xd8be09e0  ! 3322: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	.word 0xd2bf4e60  ! 3323: STDA_R	stda	%r9, [%r29 + %r0] 0x73
	.word 0x87802020  ! 3324: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd894a000  ! 3325: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r12
	.word 0xd8f42000  ! 3326: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xd6b504a0  ! 3327: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	.word 0xdcd48400  ! 3328: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	.word 0xda9c2000  ! 3329: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	.word 0xda942000  ! 3330: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3331: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8af4e40  ! 3332: STBA_R	stba	%r12, [%r29 + %r0] 0x72
	.word 0xda848400  ! 3333: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r13
	.word 0xd4bd84a0  ! 3334: STDA_R	stda	%r10, [%r22 + %r0] 0x25
	.word 0xd28c6000  ! 3335: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0xd8ae89e0  ! 3336: STBA_R	stba	%r12, [%r26 + %r0] 0x4f
	.word 0xd2f4e000  ! 3337: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd89e89e0  ! 3338: LDDA_R	ldda	[%r26, %r0] 0x4f, %r12
	mov	0x7d0, %r21
	.word 0x87802020  ! 3340: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a4a000  ! 3341: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0xd294a000  ! 3342: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r9
	.word 0x87802073  ! 3343: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b7ce60  ! 3344: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	.word 0xd89c6000  ! 3345: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r12
	.word 0x87802073  ! 3346: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8dfe000  ! 3347: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	mov	0x7d8, %r23
	.word 0x87802074  ! 3349: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 3350: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b72000  ! 3351: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 3352: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbf0e80  ! 3353: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	mov	0x0, %r24
	.word 0xd2f504a0  ! 3355: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	.word 0x8780204f  ! 3356: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdac6a000  ! 3357: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r13
	mov	0x0, %r26
	.word 0xdab6a000  ! 3359: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	.word 0x87802072  ! 3360: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3361: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r26
	.word 0xdaf7ce80  ! 3363: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	.word 0xdcf7ce40  ! 3364: STXA_R	stxa	%r14, [%r31 + %r0] 0x72
	.word 0xdaf7ce40  ! 3365: STXA_R	stxa	%r13, [%r31 + %r0] 0x72
	mov	0x68, %r25
	.word 0xd6f7e000  ! 3367: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	mov	0x28, %r16
	.word 0xd6cfe000  ! 3369: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0xd2b70e80  ! 3370: STHA_R	stha	%r9, [%r28 + %r0] 0x74
	.word 0xd28fe000  ! 3371: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	mov	0x38, %r19
	mov	0x7e8, %r23
	mov	0x0, %r25
	.word 0xdef74e40  ! 3375: STXA_R	stxa	%r15, [%r29 + %r0] 0x72
	.word 0x87802072  ! 3376: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaaf2000  ! 3377: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0ad04a0  ! 3379: STBA_R	stba	%r8, [%r20 + %r0] 0x25
	.word 0xd2cfe000  ! 3380: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	.word 0xd2af2000  ! 3381: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xdcad84a0  ! 3382: STBA_R	stba	%r14, [%r22 + %r0] 0x25
	.word 0xd2ae09e0  ! 3383: STBA_R	stba	%r9, [%r24 + %r0] 0x4f
	.word 0xde8c8400  ! 3384: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	.word 0xd0840400  ! 3385: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	.word 0xdabc8400  ! 3386: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	.word 0xd897a000  ! 3387: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	mov	0x20, %r26
	.word 0xd6ad44a0  ! 3389: STBA_R	stba	%r11, [%r21 + %r0] 0x25
	mov	0x0, %r16
	.word 0xd8972000  ! 3391: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	.word 0xd88fe000  ! 3392: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8ac0400  ! 3393: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	mov	0x28, %r17
	.word 0xd0a4c400  ! 3395: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xd6c72000  ! 3396: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0xdc9c8400  ! 3397: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0xd4df8e60  ! 3398: LDXA_R	ldxa	[%r30, %r0] 0x73, %r10
	.word 0xd6b4c400  ! 3399: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xd2afe000  ! 3400: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 3401: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdef78e40  ! 3403: STXA_R	stxa	%r15, [%r30 + %r0] 0x72
	.word 0xd2c46000  ! 3404: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	mov	0x28, %r16
	.word 0xd2cce000  ! 3406: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	.word 0xd28c6000  ! 3407: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0xd2bf0e80  ! 3408: STDA_R	stda	%r9, [%r28 + %r0] 0x74
	.word 0x87802020  ! 3409: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f44400  ! 3410: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd2a609e0  ! 3411: STWA_R	stwa	%r9, [%r24 + %r0] 0x4f
	.word 0xdcc4a000  ! 3412: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r14
	.word 0x87802072  ! 3413: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc866000  ! 3414: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r14
	.word 0x87802074  ! 3415: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 3416: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdccf6000  ! 3417: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0x87802074  ! 3418: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb7a000  ! 3419: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xdc976000  ! 3420: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	mov	0x10, %r27
	.word 0xdabf0e40  ! 3422: STDA_R	stda	%r13, [%r28 + %r0] 0x72
	mov	0x7c0, %r23
	.word 0xded70e40  ! 3424: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r15
	.word 0xdab72000  ! 3425: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xde948400  ! 3426: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	.word 0x87802020  ! 3427: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa70e60  ! 3428: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	.word 0x87802073  ! 3429: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcdf6000  ! 3430: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xdcc72000  ! 3431: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcbfe000  ! 3432: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdcf609e0  ! 3433: STXA_R	stxa	%r14, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 3434: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3435: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabf2000  ! 3436: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xd4bf4e60  ! 3437: STDA_R	stda	%r10, [%r29 + %r0] 0x73
	.word 0xd08fa000  ! 3438: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0xd0d76000  ! 3439: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xd4b74e40  ! 3440: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	.word 0x87802020  ! 3441: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2848400  ! 3442: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r9
	.word 0xdab48400  ! 3443: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0xd8a7a000  ! 3444: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	mov	0x7f8, %r22
	.word 0xd8cf2000  ! 3446: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0x87802072  ! 3447: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a5c4a0  ! 3448: STWA_R	stwa	%r12, [%r23 + %r0] 0x25
	mov	0x10, %r17
	.word 0xdab7a000  ! 3450: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdab72000  ! 3451: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xdacfa000  ! 3453: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xdabfe000  ! 3454: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	mov	0x30, %r26
	mov	0x68, %r18
	.word 0xdabfe000  ! 3457: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	mov	0x40, %r17
	mov	0x58, %r19
	.word 0xd0c4c400  ! 3460: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	.word 0xdcd74e40  ! 3461: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r14
	.word 0xdaf70e60  ! 3462: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	.word 0xd884c400  ! 3463: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	.word 0xd4b76000  ! 3464: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd48fce80  ! 3465: LDUBA_R	lduba	[%r31, %r0] 0x74, %r10
	.word 0xd2972000  ! 3466: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xde9c4400  ! 3467: LDDA_R	ldda	[%r17, %r0] 0x20, %r15
	.word 0xded7ce40  ! 3468: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r15
	mov	0x3f8, %r20
	.word 0xd0cf6000  ! 3470: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd8a48400  ! 3471: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	mov	0x58, %r19
	mov	0x60, %r18
	.word 0xd0b504a0  ! 3474: STHA_R	stha	%r8, [%r20 + %r0] 0x25
	.word 0xdca584a0  ! 3475: STWA_R	stwa	%r14, [%r22 + %r0] 0x25
	.word 0xd6af2000  ! 3476: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd2f544a0  ! 3477: STXA_R	stxa	%r9, [%r21 + %r0] 0x25
	.word 0xda9f2000  ! 3478: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xdacf6000  ! 3479: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xdc840400  ! 3480: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	mov	0x7c0, %r22
	.word 0x87802072  ! 3482: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd48c8400  ! 3483: LDUBA_R	lduba	[%r18, %r0] 0x20, %r10
	mov	0x38, %r25
	.word 0xd6f74e40  ! 3485: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	.word 0xd2c74e60  ! 3486: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r9
	.word 0xdea4a000  ! 3487: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xdebe89e0  ! 3488: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	.word 0xdcc4e000  ! 3489: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r14
	.word 0xdcbc2000  ! 3490: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xdc946000  ! 3491: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r14
	.word 0xdc942000  ! 3492: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	mov	0x3e8, %r22
	mov	0x78, %r19
	.word 0xdc8ce000  ! 3495: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	mov	0x28, %r16
	.word 0xdcf42000  ! 3497: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0xdcc4a000  ! 3498: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r14
	.word 0x87802020  ! 3499: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08fce80  ! 3500: LDUBA_R	lduba	[%r31, %r0] 0x74, %r8
	.word 0xd0974e60  ! 3501: LDUHA_R	lduha	[%r29, %r0] 0x73, %r8
	.word 0x8780204f  ! 3502: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0a584a0  ! 3504: STWA_R	stwa	%r8, [%r22 + %r0] 0x25
	.word 0xd0b7ce80  ! 3505: STHA_R	stha	%r8, [%r31 + %r0] 0x74
	.word 0x87802074  ! 3506: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bf2000  ! 3507: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd8f7e000  ! 3508: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd89f6000  ! 3509: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	.word 0xd4f4c400  ! 3510: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd0c6c9e0  ! 3511: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r8
	mov	0x8, %r18
	.word 0x87802020  ! 3513: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r27
	.word 0xdaccc400  ! 3515: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r13
	.word 0xd6f52000  ! 3516: STXA_I	stxa	%r11, [%r20 + 0x0000] %asi
	.word 0xdef7ce60  ! 3517: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0xde87ce80  ! 3518: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r15
	.word 0xd4f7ce40  ! 3519: STXA_R	stxa	%r10, [%r31 + %r0] 0x72
	.word 0xd0b40400  ! 3520: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	mov	0x8, %r18
	.word 0xdcc52000  ! 3522: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r14
	mov	0x68, %r16
	mov	0x7f0, %r23
	.word 0xd88f8e60  ! 3525: LDUBA_R	lduba	[%r30, %r0] 0x73, %r12
	.word 0xd09f8e40  ! 3526: LDDA_R	ldda	[%r30, %r0] 0x72, %r8
	.word 0xd2852000  ! 3527: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r9
	.word 0xd29de000  ! 3528: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r9
	mov	0x60, %r19
	.word 0xd29de000  ! 3530: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r9
	mov	0x7e0, %r21
	mov	0x7e0, %r20
	.word 0xd2ada000  ! 3533: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0xd2bda000  ! 3535: STDA_I	stda	%r9, [%r22 + 0x0000] %asi
	.word 0xd2d78e80  ! 3536: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r9
	mov	0x50, %r19
	mov	0x0, %r25
	mov	0x7d0, %r23
	.word 0xd6dde000  ! 3540: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r11
	mov	0x10, %r17
	.word 0xd6b56000  ! 3542: STHA_I	stha	%r11, [%r21 + 0x0000] %asi
	.word 0xd6c52000  ! 3543: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r11
	.word 0xd695a000  ! 3544: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r11
	.word 0xd2b74e60  ! 3545: STHA_R	stha	%r9, [%r29 + %r0] 0x73
	.word 0xdcad2000  ! 3546: STBA_I	stba	%r14, [%r20 + 0x0000] %asi
	.word 0x87802025  ! 3547: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6dc8400  ! 3548: LDXA_R	ldxa	[%r18, %r0] 0x20, %r11
	.word 0xdacfe000  ! 3549: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0xda97e000  ! 3550: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	.word 0xd4adc4a0  ! 3551: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0xd4bc8400  ! 3552: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	.word 0xdcd70e80  ! 3553: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r14
	.word 0xd2d649e0  ! 3554: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r9
	.word 0xdca70e60  ! 3555: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	.word 0xd0d7a000  ! 3556: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0xd0bf6000  ! 3557: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd09f2000  ! 3558: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0xd0f7e000  ! 3559: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0cf6000  ! 3560: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	mov	0x0, %r16
	.word 0xd2cec9e0  ! 3562: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r9
	mov	0x30, %r26
	mov	0x3c8, %r20
	.word 0xd0afe000  ! 3565: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	mov	0x50, %r16
	mov	0x70, %r17
	mov	0x28, %r27
	mov	0x60, %r24
	.word 0xd0bf2000  ! 3570: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xdc97ce80  ! 3571: LDUHA_R	lduha	[%r31, %r0] 0x74, %r14
	mov	0x3f0, %r23
	.word 0xde844400  ! 3573: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	.word 0xd0870e60  ! 3574: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r8
	.word 0xdc940400  ! 3575: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0xd287a000  ! 3576: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	mov	0x3e0, %r21
	.word 0xd4ac0400  ! 3578: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0x87802072  ! 3579: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2bf6000  ! 3580: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	mov	0x3c0, %r20
	.word 0xd28f6000  ! 3582: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	mov	0x48, %r25
	.word 0xd88c4400  ! 3584: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0b72000  ! 3586: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0xd0b76000  ! 3588: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	mov	0x7e0, %r22
	.word 0x87802025  ! 3590: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b44400  ! 3591: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	mov	0x48, %r26
	.word 0xda9fe000  ! 3593: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0x87802025  ! 3594: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r18
	.word 0xdc9f0e60  ! 3596: LDDA_R	ldda	[%r28, %r0] 0x73, %r14
	.word 0xd69f8e80  ! 3597: LDDA_R	ldda	[%r30, %r0] 0x74, %r11
	mov	0x10, %r26
	.word 0xdef544a0  ! 3599: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	.word 0x87802020  ! 3600: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3601: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8af6000  ! 3602: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd88f2000  ! 3603: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	mov	0x28, %r19
	.word 0x87802020  ! 3605: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabc0400  ! 3606: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xd6cfe000  ! 3607: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0xdc97ce60  ! 3608: LDUHA_R	lduha	[%r31, %r0] 0x73, %r14
	.word 0x87802073  ! 3609: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda9d2000  ! 3610: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r13
	.word 0xdaf5e000  ! 3611: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0xdcd4c400  ! 3612: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	mov	0x70, %r24
	.word 0xda8d2000  ! 3614: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r13
	.word 0xdab52000  ! 3615: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	.word 0xda8da000  ! 3616: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r13
	.word 0xd2b7ce60  ! 3617: STHA_R	stha	%r9, [%r31 + %r0] 0x73
	.word 0xd0bd84a0  ! 3618: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0xdab5a000  ! 3619: STHA_I	stha	%r13, [%r22 + 0x0000] %asi
	.word 0xdabda000  ! 3620: STDA_I	stda	%r13, [%r22 + 0x0000] %asi
	.word 0xdcbe89e0  ! 3621: STDA_R	stda	%r14, [%r26 + %r0] 0x4f
	.word 0xdabde000  ! 3622: STDA_I	stda	%r13, [%r23 + 0x0000] %asi
	.word 0xdacf8e60  ! 3623: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r13
	.word 0xd885e000  ! 3624: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r12
	.word 0x87802020  ! 3625: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09f4e80  ! 3626: LDDA_R	ldda	[%r29, %r0] 0x74, %r8
	.word 0xd8d70e80  ! 3627: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r12
	.word 0x87802072  ! 3628: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b70e60  ! 3629: STHA_R	stha	%r11, [%r28 + %r0] 0x73
	.word 0xd0c70e60  ! 3630: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r8
	.word 0xd8870e40  ! 3631: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r12
	mov	0x0, %r18
	.word 0x87802074  ! 3633: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdea6c9e0  ! 3634: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	.word 0xdacde000  ! 3635: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3636: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab56000  ! 3637: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	.word 0xd0948400  ! 3638: LDUHA_R	lduha	[%r18, %r0] 0x20, %r8
	.word 0x87802073  ! 3639: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d0, %r23
	.word 0xd88ce000  ! 3641: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	mov	0x7c8, %r22
	.word 0xd8f4e000  ! 3643: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xd4878e80  ! 3644: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r10
	.word 0x87802020  ! 3645: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r24
	mov	0x18, %r26
	.word 0xd2a649e0  ! 3648: STWA_R	stwa	%r9, [%r25 + %r0] 0x4f
	.word 0xd6b4a000  ! 3649: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd4a40400  ! 3650: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	mov	0x3d0, %r20
	.word 0xd6afce80  ! 3652: STBA_R	stba	%r11, [%r31 + %r0] 0x74
	.word 0xd6870e40  ! 3653: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r11
	.word 0xd0a4e000  ! 3654: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0cc0400  ! 3655: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xdab48400  ! 3656: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0xd4c4a000  ! 3657: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	mov	0x7f8, %r20
	mov	0x40, %r26
	mov	0x48, %r17
	.word 0xd4b46000  ! 3661: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 3662: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4bda000  ! 3663: STDA_I	stda	%r10, [%r22 + 0x0000] %asi
	.word 0xdcb584a0  ! 3664: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	.word 0xde8fce60  ! 3665: LDUBA_R	lduba	[%r31, %r0] 0x73, %r15
	.word 0xd896c9e0  ! 3666: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r12
	.word 0xd2afce80  ! 3667: STBA_R	stba	%r9, [%r31 + %r0] 0x74
	.word 0x87802020  ! 3668: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbf6000  ! 3669: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdcbfa000  ! 3670: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xd2bec9e0  ! 3671: STDA_R	stda	%r9, [%r27 + %r0] 0x4f
	.word 0x8780204f  ! 3672: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd69ee000  ! 3673: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r11
	.word 0xdc9f8e80  ! 3674: LDDA_R	ldda	[%r30, %r0] 0x74, %r14
	mov	0x70, %r26
	.word 0xd2b78e40  ! 3676: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	.word 0xd2b6a000  ! 3677: STHA_I	stha	%r9, [%r26 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xdcf544a0  ! 3679: STXA_R	stxa	%r14, [%r21 + %r0] 0x25
	.word 0xda9544a0  ! 3680: LDUHA_R	lduha	[%r21, %r0] 0x25, %r13
	.word 0xdade6000  ! 3681: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r13
	mov	0x20, %r25
	.word 0x87802020  ! 3683: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r17
	mov	0x3e8, %r23
	.word 0x87802073  ! 3686: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8b48400  ! 3687: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0xd29e6000  ! 3688: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r9
	mov	0x48, %r27
	mov	0x18, %r27
	.word 0xd2aee000  ! 3691: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	.word 0xd0c74e60  ! 3692: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r8
	.word 0xd0cea000  ! 3693: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r8
	.word 0x87802072  ! 3694: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0f46000  ! 3695: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3696: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bc8400  ! 3697: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xdcf40400  ! 3698: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xd0d5a000  ! 3699: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r8
	.word 0xd09da000  ! 3700: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r8
	.word 0xd88c8400  ! 3701: LDUBA_R	lduba	[%r18, %r0] 0x20, %r12
	mov	0x7f0, %r20
	.word 0x87802025  ! 3703: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3704: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2af6000  ! 3705: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	mov	0x28, %r17
	.word 0xd2afa000  ! 3707: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0x87802074  ! 3709: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2df2000  ! 3710: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	mov	0x7d0, %r22
	.word 0x87802020  ! 3712: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69d44a0  ! 3713: LDDA_R	ldda	[%r21, %r0] 0x25, %r11
	mov	0x40, %r25
	.word 0xda8f4e40  ! 3715: LDUBA_R	lduba	[%r29, %r0] 0x72, %r13
	.word 0xd88fa000  ! 3716: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0x87802073  ! 3717: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8dce000  ! 3718: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	.word 0xd8f42000  ! 3719: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	mov	0x50, %r19
	.word 0xdaa74e40  ! 3721: STWA_R	stwa	%r13, [%r29 + %r0] 0x72
	.word 0xdcb48400  ! 3722: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xdc84a000  ! 3723: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	.word 0xdcf4e000  ! 3724: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcd42000  ! 3725: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	.word 0xdcaf0e40  ! 3726: STBA_R	stba	%r14, [%r28 + %r0] 0x72
	.word 0xd4a44400  ! 3727: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xd8d74e60  ! 3728: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r12
	mov	0x3d0, %r21
	.word 0xd8bf4e80  ! 3730: STDA_R	stda	%r12, [%r29 + %r0] 0x74
	.word 0xd4f4e000  ! 3731: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 3732: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r17
	.word 0x87802072  ! 3734: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d8, %r20
	mov	0x30, %r18
	.word 0x87802025  ! 3737: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4878e80  ! 3738: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r10
	mov	0x3f0, %r21
	mov	0x50, %r18
	.word 0x8780204f  ! 3741: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6944400  ! 3742: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	mov	0x40, %r25
	.word 0xdcbe09e0  ! 3744: STDA_R	stda	%r14, [%r24 + %r0] 0x4f
	.word 0x87802074  ! 3745: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f4a000  ! 3746: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xd0942000  ! 3747: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r8
	mov	0x3f0, %r20
	.word 0x87802020  ! 3749: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b6a000  ! 3750: STHA_I	stha	%r8, [%r26 + 0x0000] %asi
	.word 0xdad44400  ! 3751: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	mov	0x58, %r24
	.word 0xd2ce2000  ! 3753: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r9
	.word 0xd4c78e40  ! 3754: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r10
	mov	0x38, %r16
	mov	0x58, %r25
	.word 0xd29c4400  ! 3757: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	.word 0x87802020  ! 3758: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3759: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d8, %r22
	mov	0x70, %r17
	.word 0xd0ac8400  ! 3762: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	mov	0x60, %r25
	.word 0xde96c9e0  ! 3764: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r15
	.word 0xd2cf8e80  ! 3765: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r9
	mov	0x7e8, %r21
	mov	0x38, %r18
	.word 0xd2b66000  ! 3768: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0xd2bea000  ! 3770: STDA_I	stda	%r9, [%r26 + 0x0000] %asi
	.word 0xdcb40400  ! 3771: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xdef66000  ! 3772: STXA_I	stxa	%r15, [%r25 + 0x0000] %asi
	.word 0xdef62000  ! 3773: STXA_I	stxa	%r15, [%r24 + 0x0000] %asi
	mov	0x30, %r27
	.word 0x87802020  ! 3775: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68689e0  ! 3776: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r11
	.word 0xdcd7a000  ! 3777: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0xd887ce40  ! 3778: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r12
	.word 0xdccf2000  ! 3779: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xdabfce60  ! 3780: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 3781: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 3782: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d8, %r23
	.word 0xd2af4e80  ! 3784: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	.word 0xd6f62000  ! 3785: STXA_I	stxa	%r11, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 3786: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f72000  ! 3787: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	mov	0x8, %r24
	.word 0xd6afe000  ! 3789: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x68, %r18
	.word 0xd6afe000  ! 3791: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x40, %r24
	.word 0xd2b48400  ! 3793: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0x87802073  ! 3794: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f74e40  ! 3795: STXA_R	stxa	%r10, [%r29 + %r0] 0x72
	.word 0xd6c78e80  ! 3796: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r11
	.word 0xdef7ce80  ! 3797: STXA_R	stxa	%r15, [%r31 + %r0] 0x74
	.word 0xd6b6e000  ! 3798: STHA_I	stha	%r11, [%r27 + 0x0000] %asi
	.word 0xd6a66000  ! 3799: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	mov	0x3c0, %r20
	.word 0x8780204f  ! 3801: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r17
	mov	0x7e0, %r22
	.word 0xd6ac4400  ! 3804: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	mov	0x58, %r26
	mov	0x18, %r26
	.word 0xd88d44a0  ! 3807: LDUBA_R	lduba	[%r21, %r0] 0x25, %r12
	.word 0xd4ada000  ! 3808: STBA_I	stba	%r10, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 3809: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4be6000  ! 3810: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 3811: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r18
	mov	0x18, %r19
	.word 0xd4942000  ! 3814: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r10
	.word 0xdeb74e80  ! 3815: STHA_R	stha	%r15, [%r29 + %r0] 0x74
	.word 0xd2bc2000  ! 3816: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xdcaec9e0  ! 3818: STBA_R	stba	%r14, [%r27 + %r0] 0x4f
	.word 0xd48f0e60  ! 3819: LDUBA_R	lduba	[%r28, %r0] 0x73, %r10
	.word 0xd4b44400  ! 3820: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	mov	0x20, %r25
	.word 0xdc8ce000  ! 3822: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	mov	0x18, %r24
	.word 0xd2dd04a0  ! 3824: LDXA_R	ldxa	[%r20, %r0] 0x25, %r9
	mov	0x28, %r24
	mov	0x30, %r27
	.word 0xd2d584a0  ! 3827: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r9
	.word 0xd49cc400  ! 3828: LDDA_R	ldda	[%r19, %r0] 0x20, %r10
	.word 0xd09c2000  ! 3829: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r8
	.word 0xd0cc6000  ! 3830: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	.word 0xd09ce000  ! 3831: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r8
	.word 0xd2f4c400  ! 3832: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0x87802025  ! 3833: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8dc8400  ! 3834: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0x8780204f  ! 3835: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e0, %r23
	.word 0xdcdc6000  ! 3837: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	mov	0x50, %r24
	.word 0xdcb42000  ! 3839: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xdc9ce000  ! 3840: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r14
	.word 0xdcb4e000  ! 3841: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xd0f48400  ! 3842: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xd2f78e80  ! 3843: STXA_R	stxa	%r9, [%r30 + %r0] 0x74
	.word 0xdab40400  ! 3844: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	mov	0x3f0, %r20
	.word 0x8780204f  ! 3846: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r27
	mov	0x40, %r18
	.word 0x87802020  ! 3849: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f649e0  ! 3850: STXA_R	stxa	%r8, [%r25 + %r0] 0x4f
	.word 0xd4a7ce80  ! 3851: STWA_R	stwa	%r10, [%r31 + %r0] 0x74
	mov	0x58, %r27
	mov	0x68, %r25
	.word 0xdaa70e80  ! 3854: STWA_R	stwa	%r13, [%r28 + %r0] 0x74
	.word 0xd2f5c4a0  ! 3855: STXA_R	stxa	%r9, [%r23 + %r0] 0x25
	.word 0xdc94c400  ! 3856: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	.word 0xd8a70e80  ! 3857: STWA_R	stwa	%r12, [%r28 + %r0] 0x74
	.word 0xdeafce60  ! 3858: STBA_R	stba	%r15, [%r31 + %r0] 0x73
	.word 0xd8a7ce40  ! 3859: STWA_R	stwa	%r12, [%r31 + %r0] 0x72
	.word 0x87802074  ! 3860: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd886a000  ! 3861: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r12
	.word 0xdadf0e60  ! 3862: LDXA_R	ldxa	[%r28, %r0] 0x73, %r13
	.word 0xdc9ee000  ! 3863: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r14
	mov	0x70, %r25
	.word 0xd29c0400  ! 3865: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	mov	0x60, %r17
	.word 0x87802074  ! 3867: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r16
	.word 0xda8f0e40  ! 3869: LDUBA_R	lduba	[%r28, %r0] 0x72, %r13
	.word 0x87802025  ! 3870: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8874e60  ! 3871: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r12
	.word 0xd8dc8400  ! 3872: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xd6ac6000  ! 3873: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xd6c42000  ! 3874: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r11
	.word 0x87802073  ! 3875: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6d5c4a0  ! 3876: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r11
	.word 0xd0bee000  ! 3877: STDA_I	stda	%r8, [%r27 + 0x0000] %asi
	mov	0x7c0, %r21
	.word 0xdc8cc400  ! 3879: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	.word 0xde86a000  ! 3880: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r15
	.word 0xdeac4400  ! 3881: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0xdc96a000  ! 3882: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r14
	.word 0x87802025  ! 3883: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdccf2000  ! 3884: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xd6be49e0  ! 3885: STDA_R	stda	%r11, [%r25 + %r0] 0x4f
	.word 0xdabfce80  ! 3886: STDA_R	stda	%r13, [%r31 + %r0] 0x74
	.word 0x87802074  ! 3887: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2d42000  ! 3888: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0xdeaf8e60  ! 3889: STBA_R	stba	%r15, [%r30 + %r0] 0x73
	.word 0xde8f4e80  ! 3890: LDUBA_R	lduba	[%r29, %r0] 0x74, %r15
	.word 0xd8b70e40  ! 3891: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0x87802073  ! 3892: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdedfce80  ! 3893: LDXA_R	ldxa	[%r31, %r0] 0x74, %r15
	.word 0xdab5c4a0  ! 3894: STHA_R	stha	%r13, [%r23 + %r0] 0x25
	.word 0xd8bfa000  ! 3895: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd8af6000  ! 3896: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd8bf2000  ! 3897: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd8a7a000  ! 3898: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xdabf4e60  ! 3899: STDA_R	stda	%r13, [%r29 + %r0] 0x73
	.word 0xd8d584a0  ! 3900: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r12
	.word 0xd287e000  ! 3901: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0xd0bf8e40  ! 3902: STDA_R	stda	%r8, [%r30 + %r0] 0x72
	.word 0xd4dfce60  ! 3903: LDXA_R	ldxa	[%r31, %r0] 0x73, %r10
	.word 0xd6f4c400  ! 3904: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0xd2cfce40  ! 3905: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r9
	mov	0x7c0, %r21
	.word 0xdebf6000  ! 3907: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xdca74e80  ! 3908: STWA_R	stwa	%r14, [%r29 + %r0] 0x74
	.word 0xde844400  ! 3909: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	.word 0xd4f544a0  ! 3910: STXA_R	stxa	%r10, [%r21 + %r0] 0x25
	mov	0x3e8, %r20
	mov	0x3e8, %r22
	.word 0xdaf7a000  ! 3913: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0xd0cf4e40  ! 3915: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	.word 0xd49cc400  ! 3916: LDDA_R	ldda	[%r19, %r0] 0x20, %r10
	.word 0x87802074  ! 3917: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e0, %r22
	.word 0xd697e000  ! 3919: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0xd6b72000  ! 3920: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd2cf4e80  ! 3921: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r9
	.word 0xd4cfa000  ! 3922: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0xd28c0400  ! 3923: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	.word 0x87802073  ! 3924: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf72000  ! 3925: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdad7e000  ! 3926: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xda9c4400  ! 3927: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	.word 0xd4bf6000  ! 3928: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	mov	0x0, %r17
	.word 0xd4cf2000  ! 3930: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xde878e40  ! 3931: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r15
	.word 0xd8a544a0  ! 3932: STWA_R	stwa	%r12, [%r21 + %r0] 0x25
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xda9f8e80  ! 3934: LDDA_R	ldda	[%r30, %r0] 0x74, %r13
	.word 0xd4948400  ! 3935: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	.word 0x87802020  ! 3936: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf52000  ! 3937: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	.word 0xda940400  ! 3938: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	.word 0xdaac4400  ! 3939: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	.word 0xd4a78e80  ! 3940: STWA_R	stwa	%r10, [%r30 + %r0] 0x74
	.word 0x87802072  ! 3941: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6c70e60  ! 3942: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r11
	.word 0xd49f8e60  ! 3943: LDDA_R	ldda	[%r30, %r0] 0x73, %r10
	.word 0xdcf40400  ! 3944: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xdef4a000  ! 3945: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 3946: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d0, %r21
	.word 0xdecc8400  ! 3948: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	mov	0x7d8, %r21
	.word 0xd88d44a0  ! 3950: LDUBA_R	lduba	[%r21, %r0] 0x25, %r12
	.word 0xd88f4e80  ! 3951: LDUBA_R	lduba	[%r29, %r0] 0x74, %r12
	.word 0x87802073  ! 3952: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6974e80  ! 3953: LDUHA_R	lduha	[%r29, %r0] 0x74, %r11
	.word 0xd6af6000  ! 3954: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xdcaf8e40  ! 3955: STBA_R	stba	%r14, [%r30 + %r0] 0x72
	.word 0xd6df2000  ! 3956: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0x87802074  ! 3957: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f74e60  ! 3958: STXA_R	stxa	%r10, [%r29 + %r0] 0x73
	.word 0xd0cde000  ! 3959: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r8
	.word 0xd08de000  ! 3960: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r8
	.word 0xdeac0400  ! 3961: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xdea56000  ! 3962: STWA_I	stwa	%r15, [%r21 + 0x0000] %asi
	.word 0xdaa609e0  ! 3963: STWA_R	stwa	%r13, [%r24 + %r0] 0x4f
	.word 0x87802072  ! 3964: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda8fce40  ! 3965: LDUBA_R	lduba	[%r31, %r0] 0x72, %r13
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2f7e000  ! 3967: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd2872000  ! 3968: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	mov	0x10, %r19
	.word 0xd0cdc4a0  ! 3970: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r8
	.word 0x87802074  ! 3971: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 3972: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 3973: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r18
	.word 0xd29649e0  ! 3975: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r9
	.word 0xd49ca000  ! 3976: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd4dce000  ! 3977: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	mov	0x3e0, %r22
	mov	0x68, %r27
	.word 0x8780204f  ! 3980: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4aca000  ! 3981: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0xd4b42000  ! 3983: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	.word 0xd4a4e000  ! 3984: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xd4ac6000  ! 3985: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	.word 0xd8f70e60  ! 3986: STXA_R	stxa	%r12, [%r28 + %r0] 0x73
	.word 0xd6cc2000  ! 3987: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	.word 0x87802073  ! 3988: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6b70e80  ! 3989: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	.word 0xdacce000  ! 3990: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r13
	.word 0xdc8d04a0  ! 3991: LDUBA_R	lduba	[%r20, %r0] 0x25, %r14
	.word 0xd4ac6000  ! 3992: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	.word 0xd49ce000  ! 3993: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0xd4f42000  ! 3994: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd8cc0400  ! 3995: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	.word 0xd8ac2000  ! 3996: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0xd88ce000  ! 3997: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	.word 0x87802020  ! 3998: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d504a0  ! 3999: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r11
	.word 0xd6cf6000  ! 4000: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	mov	0x30, %r27
	.word 0xd68f2000  ! 4002: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xd8b74e40  ! 4003: STHA_R	stha	%r12, [%r29 + %r0] 0x72
	.word 0xd4cfe000  ! 4004: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0xd4c7e000  ! 4005: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	mov	0x7d8, %r21
	.word 0xdaad44a0  ! 4007: STBA_R	stba	%r13, [%r21 + %r0] 0x25
	.word 0xdcdc8400  ! 4008: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	.word 0x87802074  ! 4009: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb72000  ! 4010: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xdcaf2000  ! 4011: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xd2bd44a0  ! 4012: STDA_R	stda	%r9, [%r21 + %r0] 0x25
	.word 0x87802020  ! 4013: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a5a000  ! 4014: STWA_I	stwa	%r11, [%r22 + 0x0000] %asi
	.word 0xd2b74e40  ! 4015: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	.word 0xd8dfce60  ! 4016: LDXA_R	ldxa	[%r31, %r0] 0x73, %r12
	.word 0x8780204f  ! 4017: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xded6a000  ! 4018: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r15
	.word 0xd2cec9e0  ! 4019: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r9
	mov	0x7c0, %r22
	.word 0xd6866000  ! 4021: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r11
	.word 0xd0f609e0  ! 4022: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	.word 0x87802025  ! 4023: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r17
	.word 0xd2c72000  ! 4025: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xda9dc4a0  ! 4026: LDDA_R	ldda	[%r23, %r0] 0x25, %r13
	.word 0xdc976000  ! 4027: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	.word 0xdcafa000  ! 4028: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xdcc76000  ! 4029: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	mov	0x70, %r18
	.word 0x87802074  ! 4031: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r18
	.word 0xd4a6c9e0  ! 4033: STWA_R	stwa	%r10, [%r27 + %r0] 0x4f
	.word 0xd0af4e60  ! 4034: STBA_R	stba	%r8, [%r29 + %r0] 0x73
	mov	0x28, %r24
	.word 0xdac5e000  ! 4036: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r13
	.word 0xd2f74e80  ! 4037: STXA_R	stxa	%r9, [%r29 + %r0] 0x74
	.word 0xda9cc400  ! 4038: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	.word 0xd6940400  ! 4039: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	.word 0xde97ce60  ! 4040: LDUHA_R	lduha	[%r31, %r0] 0x73, %r15
	mov	0x3f8, %r22
	mov	0x10, %r27
	.word 0xdc95c4a0  ! 4043: LDUHA_R	lduha	[%r23, %r0] 0x25, %r14
	.word 0xd494c400  ! 4044: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	.word 0xda85e000  ! 4045: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	.word 0xdeacc400  ! 4046: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xdecc8400  ! 4047: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	mov	0x7d8, %r21
	.word 0xdaad6000  ! 4049: STBA_I	stba	%r13, [%r21 + 0x0000] %asi
	.word 0xdaad2000  ! 4050: STBA_I	stba	%r13, [%r20 + 0x0000] %asi
	.word 0xdaa5a000  ! 4051: STWA_I	stwa	%r13, [%r22 + 0x0000] %asi
	.word 0xd2af0e40  ! 4052: STBA_R	stba	%r9, [%r28 + %r0] 0x72
	mov	0x3e0, %r23
	.word 0xd8cd2000  ! 4054: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r12
	.word 0x87802073  ! 4055: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8df2000  ! 4056: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	mov	0x68, %r24
	.word 0x87802020  ! 4058: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8be6000  ! 4059: STDA_I	stda	%r12, [%r25 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xd8d62000  ! 4061: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r12
	.word 0xdab40400  ! 4062: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xd08fce40  ! 4063: LDUBA_R	lduba	[%r31, %r0] 0x72, %r8
	.word 0x87802072  ! 4064: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d8, %r22
	.word 0xdebe6000  ! 4066: STDA_I	stda	%r15, [%r25 + 0x0000] %asi
	.word 0x8780204f  ! 4067: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r25
	.word 0xdcbd04a0  ! 4069: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	.word 0xd8f5c4a0  ! 4070: STXA_R	stxa	%r12, [%r23 + %r0] 0x25
	mov	0x18, %r25
	.word 0xdecf4e60  ! 4072: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r15
	mov	0x30, %r19
	.word 0x87802020  ! 4074: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f44400  ! 4075: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0x87802020  ! 4076: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedd6000  ! 4077: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r15
	.word 0xd095c4a0  ! 4078: LDUHA_R	lduha	[%r23, %r0] 0x25, %r8
	.word 0xd2cd2000  ! 4079: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r9
	.word 0xd28da000  ! 4080: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r9
	.word 0xd48c0400  ! 4081: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	mov	0x58, %r18
	mov	0x7e8, %r22
	.word 0xdcc5c4a0  ! 4084: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r14
	.word 0xd485a000  ! 4085: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r10
	.word 0xd297ce80  ! 4086: LDUHA_R	lduha	[%r31, %r0] 0x74, %r9
	.word 0xde8d6000  ! 4087: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r15
	.word 0x87802072  ! 4088: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r19
	.word 0x8780204f  ! 4090: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeb4a000  ! 4091: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x78, %r16
	.word 0xdeac6000  ! 4094: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 4095: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b74e60  ! 4096: STHA_R	stha	%r10, [%r29 + %r0] 0x73
	mov	0x58, %r25
	mov	0x38, %r26
	mov	0x50, %r24
	.word 0xdeb4c400  ! 4100: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xd6d56000  ! 4101: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r11
	.word 0xd6b56000  ! 4102: STHA_I	stha	%r11, [%r21 + 0x0000] %asi
	.word 0xdaaf4e60  ! 4103: STBA_R	stba	%r13, [%r29 + %r0] 0x73
	.word 0xd8b584a0  ! 4104: STHA_R	stha	%r12, [%r22 + %r0] 0x25
	.word 0xd0956000  ! 4105: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r8
	.word 0xdaf78e40  ! 4106: STXA_R	stxa	%r13, [%r30 + %r0] 0x72
	mov	0x68, %r19
	.word 0xd4df0e60  ! 4108: LDXA_R	ldxa	[%r28, %r0] 0x73, %r10
	.word 0xdab52000  ! 4109: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	.word 0xd69d44a0  ! 4110: LDDA_R	ldda	[%r21, %r0] 0x25, %r11
	.word 0xdcaf0e40  ! 4111: STBA_R	stba	%r14, [%r28 + %r0] 0x72
	mov	0x7e8, %r22
	.word 0x87802020  ! 4113: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4114: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b4c400  ! 4115: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xded6c9e0  ! 4116: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r15
	.word 0xd4cc8400  ! 4117: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	.word 0xd2c44400  ! 4118: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	.word 0xd6b4e000  ! 4119: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xd0cf0e80  ! 4120: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r8
	.word 0xd2dd44a0  ! 4121: LDXA_R	ldxa	[%r21, %r0] 0x25, %r9
	mov	0x10, %r19
	.word 0xd6b4e000  ! 4123: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xdc8544a0  ! 4124: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r14
	mov	0x3e8, %r23
	mov	0x38, %r19
	mov	0x78, %r19
	mov	0x58, %r27
	.word 0x8780204f  ! 4129: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r18
	.word 0xd29f0e40  ! 4131: LDDA_R	ldda	[%r28, %r0] 0x72, %r9
	mov	0x20, %r17
	.word 0x87802020  ! 4133: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4134: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r27
	.word 0xd48d6000  ! 4136: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r10
	mov	0x60, %r27
	.word 0x87802072  ! 4138: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d0, %r22
	.word 0xd0ce09e0  ! 4140: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r8
	.word 0xd0a7ce40  ! 4141: STWA_R	stwa	%r8, [%r31 + %r0] 0x72
	.word 0xd6a74e60  ! 4142: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	mov	0x20, %r27
	.word 0xdc9e09e0  ! 4144: LDDA_R	ldda	[%r24, %r0] 0x4f, %r14
	.word 0xdeb70e80  ! 4145: STHA_R	stha	%r15, [%r28 + %r0] 0x74
	mov	0x38, %r24
	.word 0xdeafa000  ! 4147: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	mov	0x30, %r26
	.word 0xde8fa000  ! 4149: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0xde8f6000  ! 4150: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	.word 0xdea7e000  ! 4151: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xde97e000  ! 4152: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0x87802072  ! 4153: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4154: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4155: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9c6000  ! 4156: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0xd4b78e60  ! 4157: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	.word 0xd0d42000  ! 4158: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r8
	.word 0xdead44a0  ! 4159: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	.word 0x87802074  ! 4160: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a6c9e0  ! 4161: STWA_R	stwa	%r8, [%r27 + %r0] 0x4f
	mov	0x60, %r19
	.word 0xd0cf4e60  ! 4163: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r8
	.word 0xdcbfe000  ! 4164: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xde8649e0  ! 4165: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r15
	mov	0x68, %r25
	.word 0x87802020  ! 4167: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a6e000  ! 4168: STWA_I	stwa	%r11, [%r27 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xd4af8e60  ! 4170: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	.word 0xd4d66000  ! 4171: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r10
	.word 0xdaa74e80  ! 4172: STWA_R	stwa	%r13, [%r29 + %r0] 0x74
	.word 0xd6d48400  ! 4173: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0xdec40400  ! 4174: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xd2df4e80  ! 4175: LDXA_R	ldxa	[%r29, %r0] 0x74, %r9
	.word 0xd486e000  ! 4176: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	.word 0xd8f40400  ! 4177: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xd2bea000  ! 4178: STDA_I	stda	%r9, [%r26 + 0x0000] %asi
	.word 0xdcf689e0  ! 4179: STXA_R	stxa	%r14, [%r26 + %r0] 0x4f
	.word 0xd4cec9e0  ! 4180: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r10
	.word 0xdad66000  ! 4181: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r13
	.word 0x87802025  ! 4182: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bfce60  ! 4183: STDA_R	stda	%r9, [%r31 + %r0] 0x73
	.word 0xdaf44400  ! 4184: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0xdc8584a0  ! 4185: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r14
	.word 0xd2f72000  ! 4186: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xdc8f8e40  ! 4187: LDUBA_R	lduba	[%r30, %r0] 0x72, %r14
	.word 0xd6ce09e0  ! 4188: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r11
	.word 0xd897ce80  ! 4189: LDUHA_R	lduha	[%r31, %r0] 0x74, %r12
	mov	0x3d8, %r22
	.word 0xd4bf6000  ! 4191: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd2cf8e80  ! 4192: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r9
	mov	0x28, %r16
	mov	0x10, %r18
	.word 0xd2bfa000  ! 4195: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd6b40400  ! 4196: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0x87802072  ! 4197: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 4198: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde94a000  ! 4199: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0xde8ce000  ! 4200: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	.word 0xdcf7ce60  ! 4201: STXA_R	stxa	%r14, [%r31 + %r0] 0x73
	.word 0xdca4a000  ! 4202: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 4203: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcc5e000  ! 4204: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r14
	.word 0xdcade000  ! 4205: STBA_I	stba	%r14, [%r23 + 0x0000] %asi
	mov	0x7f8, %r22
	.word 0xd6a584a0  ! 4207: STWA_R	stwa	%r11, [%r22 + %r0] 0x25
	.word 0xd8cda000  ! 4208: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r12
	.word 0xd8f5e000  ! 4209: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	.word 0xd8a56000  ! 4210: STWA_I	stwa	%r12, [%r21 + 0x0000] %asi
	mov	0x7d0, %r23
	mov	0x8, %r24
	mov	0x0, %r18
	.word 0xdcc504a0  ! 4214: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r14
	mov	0x60, %r24
	.word 0xdeb5a000  ! 4216: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xd2cc4400  ! 4218: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r9
	mov	0x70, %r19
	.word 0xd0bf8e40  ! 4220: STDA_R	stda	%r8, [%r30 + %r0] 0x72
	mov	0x68, %r26
	.word 0x87802020  ! 4222: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cf2000  ! 4223: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0xd2cc0400  ! 4224: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r9
	.word 0xd8978e40  ! 4225: LDUHA_R	lduha	[%r30, %r0] 0x72, %r12
	.word 0x87802074  ! 4226: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r24
	.word 0xd0bf2000  ! 4228: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xdad44400  ! 4229: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	mov	0x40, %r18
	.word 0x8780204f  ! 4231: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c8, %r20
	.word 0x87802020  ! 4233: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r21
	mov	0x3d8, %r20
	mov	0x8, %r25
	.word 0xd8dc6000  ! 4237: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	mov	0x10, %r27
	mov	0x20, %r26
	.word 0xd8d46000  ! 4240: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	.word 0xd8d42000  ! 4241: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0xd8d42000  ! 4242: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	mov	0x28, %r19
	mov	0x60, %r27
	.word 0x8780204f  ! 4245: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f7ce80  ! 4246: STXA_R	stxa	%r8, [%r31 + %r0] 0x74
	.word 0xd0df2000  ! 4247: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0xda874e80  ! 4248: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r13
	.word 0x87802025  ! 4249: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc84a000  ! 4250: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	mov	0x58, %r17
	mov	0x18, %r25
	.word 0xdabf4e40  ! 4253: STDA_R	stda	%r13, [%r29 + %r0] 0x72
	.word 0x87802072  ! 4254: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4255: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4256: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf7a000  ! 4257: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcbf2000  ! 4258: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	mov	0x3f0, %r23
	.word 0x87802072  ! 4260: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 4261: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde840400  ! 4262: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	.word 0x8780204f  ! 4263: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r25
	.word 0xd2f4a000  ! 4265: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0xd2946000  ! 4266: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r9
	.word 0xd2d4a000  ! 4267: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	.word 0x87802020  ! 4268: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r23
	.word 0xd2b66000  ! 4270: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	.word 0x87802025  ! 4271: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2d74e60  ! 4272: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r9
	.word 0xd89c4400  ! 4273: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	mov	0x48, %r26
	mov	0x8, %r27
	.word 0x87802020  ! 4276: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r21
	.word 0xd09f6000  ! 4278: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	.word 0xd8d70e80  ! 4279: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r12
	.word 0xd8b72000  ! 4280: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd8cfa000  ! 4281: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd8f72000  ! 4282: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd0d74e60  ! 4283: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r8
	.word 0xdac7e000  ! 4284: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xd8bc4400  ! 4285: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	mov	0x38, %r26
	.word 0xdeb72000  ! 4287: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xd4c7ce40  ! 4288: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r10
	.word 0xd8ac8400  ! 4289: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0xda9fe000  ! 4290: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	mov	0x7e8, %r21
	mov	0x8, %r16
	.word 0x87802020  ! 4293: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r24
	.word 0xd68fce80  ! 4295: LDUBA_R	lduba	[%r31, %r0] 0x74, %r11
	.word 0xd4b40400  ! 4296: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	mov	0x8, %r17
	.word 0xd897a000  ! 4298: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	mov	0x0, %r17
	mov	0x20, %r27
	.word 0xdebe89e0  ! 4301: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 4302: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a56000  ! 4303: STWA_I	stwa	%r8, [%r21 + 0x0000] %asi
	.word 0xd0bd2000  ! 4304: STDA_I	stda	%r8, [%r20 + 0x0000] %asi
	.word 0xd0bd2000  ! 4305: STDA_I	stda	%r8, [%r20 + 0x0000] %asi
	.word 0xd0bd2000  ! 4306: STDA_I	stda	%r8, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 4307: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcdf0e40  ! 4308: LDXA_R	ldxa	[%r28, %r0] 0x72, %r14
	mov	0x10, %r18
	mov	0x50, %r18
	.word 0xdab40400  ! 4311: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xd2ae89e0  ! 4312: STBA_R	stba	%r9, [%r26 + %r0] 0x4f
	.word 0xdcf5a000  ! 4313: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	.word 0x8780204f  ! 4314: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8df8e40  ! 4315: LDXA_R	ldxa	[%r30, %r0] 0x72, %r12
	.word 0xdcb52000  ! 4316: STHA_I	stha	%r14, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 4317: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r27
	.word 0xdcde6000  ! 4319: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r14
	.word 0xdc9c0400  ! 4320: LDDA_R	ldda	[%r16, %r0] 0x20, %r14
	.word 0x87802074  ! 4321: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r17
	.word 0xd087ce80  ! 4323: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r8
	.word 0x87802020  ! 4324: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29504a0  ! 4325: LDUHA_R	lduha	[%r20, %r0] 0x25, %r9
	.word 0xda9f6000  ! 4326: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xdaa7a000  ! 4327: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	mov	0x7c8, %r22
	.word 0xdecc0400  ! 4329: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r15
	.word 0x87802020  ! 4330: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4331: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r19
	.word 0xd2a7e000  ! 4333: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xd4a78e80  ! 4334: STWA_R	stwa	%r10, [%r30 + %r0] 0x74
	.word 0x87802020  ! 4335: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd287ce40  ! 4336: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r9
	.word 0x87802025  ! 4337: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r18
	.word 0xdc9fa000  ! 4339: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0xdc8f6000  ! 4340: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	mov	0x20, %r18
	.word 0x87802074  ! 4342: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcdc6000  ! 4343: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	.word 0xdcd4e000  ! 4344: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4345: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaaf0e40  ! 4346: STBA_R	stba	%r13, [%r28 + %r0] 0x72
	mov	0x3d8, %r20
	.word 0xd6a42000  ! 4348: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xd0de49e0  ! 4349: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r8
	mov	0x30, %r16
	.word 0xd0bc2000  ! 4351: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0xdcbfce40  ! 4353: STDA_R	stda	%r14, [%r31 + %r0] 0x72
	.word 0xd0a78e40  ! 4354: STWA_R	stwa	%r8, [%r30 + %r0] 0x72
	.word 0x87802020  ! 4355: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68f0e40  ! 4356: LDUBA_R	lduba	[%r28, %r0] 0x72, %r11
	mov	0x0, %r26
	mov	0x10, %r25
	.word 0xdc84a000  ! 4359: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	.word 0xd0ae89e0  ! 4360: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	.word 0xdebc2000  ! 4361: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4362: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r24
	mov	0x0, %r18
	.word 0x87802073  ! 4365: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8878e80  ! 4366: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r12
	.word 0xd8d6c9e0  ! 4367: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r12
	.word 0xd8b4e000  ! 4368: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	mov	0x7f0, %r21
	mov	0x3d0, %r23
	.word 0xdcc689e0  ! 4371: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r14
	.word 0x87802020  ! 4372: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa78e60  ! 4373: STWA_R	stwa	%r13, [%r30 + %r0] 0x73
	.word 0xd2970e60  ! 4374: LDUHA_R	lduha	[%r28, %r0] 0x73, %r9
	.word 0xd8f72000  ! 4375: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 4376: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 4377: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8d52000  ! 4378: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r12
	.word 0xd8dd2000  ! 4379: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r12
	.word 0xd4df4e80  ! 4380: LDXA_R	ldxa	[%r29, %r0] 0x74, %r10
	.word 0xdea78e60  ! 4381: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	.word 0xdcad2000  ! 4382: STBA_I	stba	%r14, [%r20 + 0x0000] %asi
	.word 0x87802072  ! 4383: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d0, %r23
	.word 0xdcdd2000  ! 4385: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r14
	.word 0xdca5e000  ! 4386: STWA_I	stwa	%r14, [%r23 + 0x0000] %asi
	mov	0x20, %r24
	.word 0xd28649e0  ! 4388: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r9
	mov	0x10, %r27
	.word 0xdaad6000  ! 4390: STBA_I	stba	%r13, [%r21 + 0x0000] %asi
	.word 0xd8cd44a0  ! 4391: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r12
	mov	0x28, %r19
	.word 0xdacfce80  ! 4393: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r13
	.word 0xd4852000  ! 4394: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r10
	.word 0x87802025  ! 4395: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8848400  ! 4397: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r12
	.word 0x87802020  ! 4398: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4399: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r25
	mov	0x18, %r16
	.word 0xd2b76000  ! 4402: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xde9609e0  ! 4403: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r15
	mov	0x40, %r25
	.word 0xdeb76000  ! 4405: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xdec72000  ! 4406: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xdec72000  ! 4407: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xdeaf6000  ! 4408: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	mov	0x10, %r17
	.word 0xdedec9e0  ! 4410: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r15
	.word 0xd6f72000  ! 4411: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	mov	0x20, %r18
	.word 0x87802020  ! 4413: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69fa000  ! 4414: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0xd68f8e40  ! 4415: LDUBA_R	lduba	[%r30, %r0] 0x72, %r11
	.word 0xd49fa000  ! 4416: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0xd4f7ce60  ! 4417: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	.word 0xdaaf8e60  ! 4418: STBA_R	stba	%r13, [%r30 + %r0] 0x73
	mov	0x10, %r24
	.word 0xd894c400  ! 4420: LDUHA_R	lduha	[%r19, %r0] 0x20, %r12
	mov	0x7d0, %r22
	mov	0x48, %r25
	.word 0xd8d70e60  ! 4423: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r12
	.word 0xd29e89e0  ! 4424: LDDA_R	ldda	[%r26, %r0] 0x4f, %r9
	.word 0x87802074  ! 4425: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd48f6000  ! 4426: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xd0cd84a0  ! 4427: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r8
	.word 0xd8876000  ! 4428: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8cfe000  ! 4429: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0x87802074  ! 4430: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r18
	.word 0xd88f6000  ! 4432: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xd8f76000  ! 4433: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8b7a000  ! 4434: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 4435: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4436: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d4a000  ! 4437: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xd89ce000  ! 4438: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	mov	0x58, %r26
	.word 0xd8942000  ! 4440: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r12
	.word 0xd6c70e60  ! 4441: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r11
	.word 0xd4d4c400  ! 4442: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0xd0cf4e40  ! 4443: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	.word 0xd88c4400  ! 4444: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0xdab4e000  ! 4445: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xdacce000  ! 4446: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r13
	.word 0xdaa46000  ! 4447: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 4448: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdec70e40  ! 4449: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r15
	.word 0xdad48400  ! 4450: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0x87802020  ! 4451: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r24
	.word 0xdaf72000  ! 4453: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	mov	0x70, %r18
	.word 0xd48c4400  ! 4455: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	mov	0x50, %r17
	mov	0x50, %r19
	.word 0x8780204f  ! 4458: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f0, %r21
	.word 0xd8ac6000  ! 4460: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	mov	0x68, %r19
	.word 0x87802020  ! 4462: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r17
	.word 0x87802025  ! 4464: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r27
	.word 0xd4b70e40  ! 4466: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	mov	0x0, %r25
	.word 0xd49ce000  ! 4468: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0xdcd4c400  ! 4469: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	.word 0xdcaf4e40  ! 4470: STBA_R	stba	%r14, [%r29 + %r0] 0x72
	mov	0x68, %r26
	.word 0x87802072  ! 4472: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab544a0  ! 4473: STHA_R	stha	%r13, [%r21 + %r0] 0x25
	.word 0xd6dc6000  ! 4474: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r11
	.word 0x87802073  ! 4475: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f72000  ! 4476: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd68f6000  ! 4477: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xd68f6000  ! 4478: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6afe000  ! 4479: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xdaf48400  ! 4480: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xdec7e000  ! 4481: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xdef7a000  ! 4482: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xd6cfce60  ! 4483: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r11
	.word 0xd0c76000  ! 4484: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0df2000  ! 4485: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0x87802072  ! 4486: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 4487: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4488: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4489: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4490: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f40400  ! 4491: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	mov	0x28, %r25
	mov	0x7c0, %r22
	.word 0x87802020  ! 4494: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bfa000  ! 4495: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd48c0400  ! 4496: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	mov	0x18, %r16
	mov	0x20, %r26
	.word 0x87802020  ! 4499: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbec9e0  ! 4500: STDA_R	stda	%r14, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 4501: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac72000  ! 4502: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0x87802025  ! 4503: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda84a000  ! 4504: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	mov	0x60, %r17
	.word 0x87802074  ! 4506: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r23
	.word 0xdab52000  ! 4508: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xdcbf0e80  ! 4510: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	.word 0xd4dd6000  ! 4511: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r10
	.word 0xde96c9e0  ! 4512: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r15
	.word 0x8780204f  ! 4513: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b7ce60  ! 4514: STHA_R	stha	%r12, [%r31 + %r0] 0x73
	.word 0xdcbc0400  ! 4515: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0xd2ac0400  ! 4516: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	mov	0x20, %r18
	.word 0xdedd84a0  ! 4518: LDXA_R	ldxa	[%r22, %r0] 0x25, %r15
	.word 0x87802020  ! 4519: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac72000  ! 4520: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0xd6bd04a0  ! 4521: STDA_R	stda	%r11, [%r20 + %r0] 0x25
	.word 0x87802020  ! 4522: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b56000  ! 4523: STHA_I	stha	%r11, [%r21 + 0x0000] %asi
	mov	0x58, %r18
	.word 0xd685a000  ! 4525: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r11
	mov	0x3d0, %r22
	.word 0xd2ad04a0  ! 4527: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	.word 0xdef7ce60  ! 4528: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0xdeb7ce40  ! 4529: STHA_R	stha	%r15, [%r31 + %r0] 0x72
	.word 0xd4af8e40  ! 4530: STBA_R	stba	%r10, [%r30 + %r0] 0x72
	mov	0x3f8, %r22
	.word 0x87802074  ! 4532: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2c6a000  ! 4533: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r9
	.word 0xd2b62000  ! 4534: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	.word 0xd2c66000  ! 4535: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r9
	mov	0x20, %r16
	.word 0xdec78e60  ! 4537: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r15
	.word 0xd2c62000  ! 4538: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r9
	.word 0xd2b66000  ! 4539: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	.word 0xd2966000  ! 4540: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r9
	.word 0xdacf8e60  ! 4541: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r13
	.word 0xd4f6e000  ! 4542: STXA_I	stxa	%r10, [%r27 + 0x0000] %asi
	.word 0xda9f4e60  ! 4543: LDDA_R	ldda	[%r29, %r0] 0x73, %r13
	.word 0xd2b504a0  ! 4544: STHA_R	stha	%r9, [%r20 + %r0] 0x25
	.word 0xdab504a0  ! 4545: STHA_R	stha	%r13, [%r20 + %r0] 0x25
	.word 0xd2a44400  ! 4546: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xd2b40400  ! 4547: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0xdeb504a0  ! 4548: STHA_R	stha	%r15, [%r20 + %r0] 0x25
	.word 0xde8f8e40  ! 4549: LDUBA_R	lduba	[%r30, %r0] 0x72, %r15
	.word 0x87802072  ! 4550: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d8, %r20
	mov	0x3f8, %r21
	.word 0x87802020  ! 4553: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdc2000  ! 4554: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r14
	.word 0xdcbce000  ! 4555: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xdca40400  ! 4556: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0x87802073  ! 4557: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4cca000  ! 4558: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r10
	.word 0xd4dc6000  ! 4559: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	.word 0x87802074  ! 4560: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x60, %r17
	.word 0xdac609e0  ! 4563: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r13
	mov	0x50, %r26
	.word 0xd4a584a0  ! 4565: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	.word 0xd4ad04a0  ! 4566: STBA_R	stba	%r10, [%r20 + %r0] 0x25
	.word 0x87802020  ! 4567: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8966000  ! 4568: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r12
	.word 0xd8b6a000  ! 4569: STHA_I	stha	%r12, [%r26 + 0x0000] %asi
	.word 0xd8a6e000  ! 4570: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0xd2b70e60  ! 4572: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	.word 0xd6f62000  ! 4573: STXA_I	stxa	%r11, [%r24 + 0x0000] %asi
	.word 0xd6d66000  ! 4574: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r11
	.word 0xdea74e80  ! 4575: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	.word 0xdc84c400  ! 4576: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	mov	0x0, %r19
	.word 0x87802072  ! 4578: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f78e60  ! 4579: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0xdcdc0400  ! 4580: LDXA_R	ldxa	[%r16, %r0] 0x20, %r14
	.word 0x87802074  ! 4581: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 4582: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 4583: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaa40400  ! 4584: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 4585: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f74e40  ! 4586: STXA_R	stxa	%r10, [%r29 + %r0] 0x72
	.word 0xdc9fce40  ! 4587: LDDA_R	ldda	[%r31, %r0] 0x72, %r14
	.word 0x87802025  ! 4588: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r25
	.word 0xd48e89e0  ! 4590: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r10
	.word 0xdab62000  ! 4591: STHA_I	stha	%r13, [%r24 + 0x0000] %asi
	mov	0x38, %r18
	mov	0x78, %r27
	mov	0x3e0, %r23
	.word 0x87802025  ! 4595: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 4596: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r24
	mov	0x10, %r24
	.word 0x87802073  ! 4599: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6dfce60  ! 4600: LDXA_R	ldxa	[%r31, %r0] 0x73, %r11
	.word 0xd4f6a000  ! 4601: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	mov	0x3e0, %r23
	.word 0x87802074  ! 4603: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4c46000  ! 4604: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r10
	mov	0x8, %r25
	mov	0x10, %r25
	.word 0xdeb78e40  ! 4607: STHA_R	stha	%r15, [%r30 + %r0] 0x72
	mov	0x20, %r19
	.word 0x87802072  ! 4609: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2cda000  ! 4610: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r9
	.word 0xd2bf0e40  ! 4611: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	.word 0xd09cc400  ! 4612: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	.word 0xdc8609e0  ! 4613: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r14
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x48, %r25
	.word 0xd285a000  ! 4616: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r9
	.word 0xd2ad6000  ! 4617: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0xd097ce40  ! 4618: LDUHA_R	lduha	[%r31, %r0] 0x72, %r8
	.word 0xdebc8400  ! 4619: STDA_R	stda	%r15, [%r18 + %r0] 0x20
	.word 0xdaaf4e80  ! 4620: STBA_R	stba	%r13, [%r29 + %r0] 0x74
	.word 0xd2b56000  ! 4621: STHA_I	stha	%r9, [%r21 + 0x0000] %asi
	.word 0xd8f544a0  ! 4622: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	mov	0x58, %r24
	.word 0xdcaf0e40  ! 4624: STBA_R	stba	%r14, [%r28 + %r0] 0x72
	.word 0xd2852000  ! 4625: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r9
	.word 0xd2f52000  ! 4626: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	.word 0xd2a52000  ! 4627: STWA_I	stwa	%r9, [%r20 + 0x0000] %asi
	.word 0xd28f4e80  ! 4628: LDUBA_R	lduba	[%r29, %r0] 0x74, %r9
	.word 0xdabc4400  ! 4629: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xdedf4e60  ! 4630: LDXA_R	ldxa	[%r29, %r0] 0x73, %r15
	mov	0x3e0, %r21
	mov	0x58, %r16
	.word 0xd2c5a000  ! 4633: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r9
	mov	0x7e8, %r21
	.word 0xdcd44400  ! 4635: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	.word 0x8780204f  ! 4636: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8978e60  ! 4637: LDUHA_R	lduha	[%r30, %r0] 0x73, %r12
	.word 0xd8aee000  ! 4638: STBA_I	stba	%r12, [%r27 + 0x0000] %asi
	.word 0xd8de2000  ! 4639: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r12
	mov	0x68, %r17
	.word 0x87802074  ! 4641: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8c72000  ! 4642: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	mov	0x38, %r16
	.word 0xd8bf2000  ! 4644: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	mov	0x10, %r19
	mov	0x3e0, %r22
	.word 0xd8a72000  ! 4647: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xdeae49e0  ! 4648: STBA_R	stba	%r15, [%r25 + %r0] 0x4f
	.word 0xdecfa000  ! 4649: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	mov	0x48, %r19
	.word 0x87802074  ! 4651: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2dc8400  ! 4652: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0xd2d52000  ! 4653: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r9
	mov	0x0, %r24
	.word 0xd2bda000  ! 4655: STDA_I	stda	%r9, [%r22 + 0x0000] %asi
	.word 0xd28de000  ! 4656: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r9
	.word 0x87802072  ! 4657: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd28e2000  ! 4658: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	mov	0x18, %r17
	.word 0xd2a6e000  ! 4660: STWA_I	stwa	%r9, [%r27 + 0x0000] %asi
	.word 0xd2d66000  ! 4661: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r9
	.word 0x87802020  ! 4662: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ae49e0  ! 4663: STBA_R	stba	%r8, [%r25 + %r0] 0x4f
	.word 0xd6bfe000  ! 4664: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd6af2000  ! 4665: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 4666: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r19
	mov	0x40, %r27
	mov	0x0, %r17
	.word 0x87802074  ! 4670: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r17
	.word 0xd6bda000  ! 4672: STDA_I	stda	%r11, [%r22 + 0x0000] %asi
	.word 0xd6b5a000  ! 4673: STHA_I	stha	%r11, [%r22 + 0x0000] %asi
	.word 0xdef5c4a0  ! 4674: STXA_R	stxa	%r15, [%r23 + %r0] 0x25
	.word 0xde856000  ! 4675: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r15
	.word 0xdef52000  ! 4676: STXA_I	stxa	%r15, [%r20 + 0x0000] %asi
	mov	0x28, %r27
	mov	0x7c8, %r23
	.word 0xd4978e40  ! 4679: LDUHA_R	lduha	[%r30, %r0] 0x72, %r10
	mov	0x8, %r18
	mov	0x68, %r16
	.word 0xdedc4400  ! 4682: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	mov	0x8, %r19
	mov	0x30, %r25
	mov	0x20, %r17
	mov	0x30, %r16
	mov	0x40, %r24
	.word 0xd2a44400  ! 4688: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xdad5e000  ! 4689: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r13
	.word 0xdaa5a000  ! 4690: STWA_I	stwa	%r13, [%r22 + 0x0000] %asi
	.word 0xda85e000  ! 4691: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4692: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdacf6000  ! 4693: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xdabf2000  ! 4694: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	mov	0x10, %r16
	.word 0xd2cf4e80  ! 4696: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r9
	.word 0xdac72000  ! 4697: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0xdaa7e000  ! 4698: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xdaa76000  ! 4699: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	mov	0x18, %r18
	.word 0xd8f40400  ! 4701: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	mov	0x3f8, %r23
	.word 0xd086c9e0  ! 4703: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r8
	.word 0x87802020  ! 4704: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b4c400  ! 4705: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	mov	0x8, %r16
	.word 0xd2b504a0  ! 4707: STHA_R	stha	%r9, [%r20 + %r0] 0x25
	.word 0xd8866000  ! 4708: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r12
	mov	0x70, %r17
	mov	0x38, %r25
	mov	0x3c0, %r21
	.word 0xd8b6a000  ! 4712: STHA_I	stha	%r12, [%r26 + 0x0000] %asi
	.word 0xd8a66000  ! 4713: STWA_I	stwa	%r12, [%r25 + 0x0000] %asi
	.word 0xd8be6000  ! 4714: STDA_I	stda	%r12, [%r25 + 0x0000] %asi
	.word 0xd8b6e000  ! 4715: STHA_I	stha	%r12, [%r27 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xd0b584a0  ! 4717: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	mov	0x0, %r17
	mov	0x3e8, %r21
	.word 0xd8dea000  ! 4720: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r12
	mov	0x10, %r24
	mov	0x3d8, %r23
	.word 0xdaf609e0  ! 4723: STXA_R	stxa	%r13, [%r24 + %r0] 0x4f
	mov	0x3e0, %r20
	.word 0x87802074  ! 4725: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4726: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r24
	.word 0xd6a46000  ! 4728: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	mov	0x7d0, %r20
	.word 0xd6bc6000  ! 4730: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0xd4b48400  ! 4731: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	mov	0x7f0, %r21
	.word 0xd68ce000  ! 4733: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	.word 0xd2adc4a0  ! 4734: STBA_R	stba	%r9, [%r23 + %r0] 0x25
	.word 0x8780204f  ! 4735: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bf8e40  ! 4736: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	.word 0xdccde000  ! 4737: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r14
	.word 0xdcd56000  ! 4738: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r14
	.word 0xdcada000  ! 4739: STBA_I	stba	%r14, [%r22 + 0x0000] %asi
	.word 0xdcbd6000  ! 4740: STDA_I	stda	%r14, [%r21 + 0x0000] %asi
	.word 0xdcf5e000  ! 4741: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0xdccde000  ! 4742: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r14
	.word 0xdea44400  ! 4743: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xd09f4e80  ! 4744: LDDA_R	ldda	[%r29, %r0] 0x74, %r8
	.word 0xdcdf0e40  ! 4745: LDXA_R	ldxa	[%r28, %r0] 0x72, %r14
	.word 0x87802073  ! 4746: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4747: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r26
	mov	0x68, %r17
	.word 0x87802073  ! 4750: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd09609e0  ! 4751: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r8
	.word 0x87802072  ! 4752: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r16
	.word 0xd2aee000  ! 4754: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	.word 0xd4f44400  ! 4755: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0xdcc44400  ! 4756: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xd6962000  ! 4757: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r11
	.word 0xd8b40400  ! 4758: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0x87802074  ! 4759: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c8, %r21
	.word 0xd0cf0e40  ! 4761: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r8
	.word 0xd2c56000  ! 4762: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r9
	.word 0xd2a52000  ! 4763: STWA_I	stwa	%r9, [%r20 + 0x0000] %asi
	.word 0xd4cc0400  ! 4764: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r10
	.word 0xd4d5e000  ! 4765: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r10
	.word 0xd4a56000  ! 4766: STWA_I	stwa	%r10, [%r21 + 0x0000] %asi
	.word 0xd4dde000  ! 4767: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r10
	.word 0xd4b5a000  ! 4768: STHA_I	stha	%r10, [%r22 + 0x0000] %asi
	.word 0xdebf0e80  ! 4769: STDA_R	stda	%r15, [%r28 + %r0] 0x74
	.word 0xd0dd6000  ! 4770: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r8
	mov	0x7c8, %r20
	.word 0x8780204f  ! 4772: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r16
	.word 0xd09fa000  ! 4774: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	.word 0xdea78e60  ! 4775: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	.word 0xd4a7e000  ! 4776: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	mov	0x50, %r27
	.word 0xdc8dc4a0  ! 4778: LDUBA_R	lduba	[%r23, %r0] 0x25, %r14
	mov	0x3e0, %r22
	.word 0xd6f78e80  ! 4780: STXA_R	stxa	%r11, [%r30 + %r0] 0x74
	.word 0xdcac0400  ! 4781: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xd0f40400  ! 4782: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	mov	0x8, %r26
	.word 0xdca7ce80  ! 4784: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	mov	0x30, %r16
	.word 0xdea7ce80  ! 4786: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	.word 0xd0ad04a0  ! 4787: STBA_R	stba	%r8, [%r20 + %r0] 0x25
	.word 0x87802074  ! 4788: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4972000  ! 4789: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0xd497a000  ! 4790: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0xd4d7a000  ! 4791: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	mov	0x20, %r16
	.word 0xd497e000  ! 4793: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	.word 0x87802074  ! 4794: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd48ec9e0  ! 4795: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r10
	.word 0xd497e000  ! 4796: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	.word 0x87802020  ! 4797: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4798: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r17
	mov	0x3f0, %r21
	mov	0x3c8, %r21
	.word 0x87802025  ! 4802: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4d7e000  ! 4803: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	.word 0xd4f689e0  ! 4804: STXA_R	stxa	%r10, [%r26 + %r0] 0x4f
	mov	0x7d8, %r22
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x7e8, %r22
	.word 0xd6df6000  ! 4808: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0xd2ad04a0  ! 4809: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	.word 0xd0870e60  ! 4810: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r8
	.word 0x87802072  ! 4811: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdedf6000  ! 4812: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	mov	0x10, %r27
	mov	0x3e8, %r20
	.word 0xd8c78e40  ! 4815: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r12
	.word 0xd8f7a000  ! 4816: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8872000  ! 4817: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	mov	0x7d0, %r20
	mov	0x7f8, %r21
	.word 0xd2df8e80  ! 4820: LDXA_R	ldxa	[%r30, %r0] 0x74, %r9
	.word 0xd49f2000  ! 4821: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd48fe000  ! 4822: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	mov	0x3e0, %r20
	.word 0xdcc70e80  ! 4824: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r14
	mov	0x10, %r16
	.word 0xdea72000  ! 4826: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xded544a0  ! 4827: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r15
	mov	0x18, %r27
	.word 0xda8504a0  ! 4829: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r13
	.word 0x87802074  ! 4830: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r25
	.word 0x87802073  ! 4832: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0f74e80  ! 4833: STXA_R	stxa	%r8, [%r29 + %r0] 0x74
	mov	0x60, %r24
	mov	0x7f8, %r20
	.word 0xd8bf4e60  ! 4836: STDA_R	stda	%r12, [%r29 + %r0] 0x73
	mov	0x50, %r27
	.word 0xd6f7ce60  ! 4838: STXA_R	stxa	%r11, [%r31 + %r0] 0x73
	.word 0xd4bfa000  ! 4839: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd4872000  ! 4840: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	mov	0x40, %r24
	.word 0xd4dfe000  ! 4842: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4af2000  ! 4843: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	mov	0x3c0, %r23
	.word 0xd4b7e000  ! 4845: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd4b72000  ! 4846: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd0cc0400  ! 4847: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xdcdcc400  ! 4848: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	.word 0xd29f4e40  ! 4849: LDDA_R	ldda	[%r29, %r0] 0x72, %r9
	.word 0xdcf7ce80  ! 4850: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	.word 0xd4ac4400  ! 4851: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0x87802020  ! 4852: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08f6000  ! 4853: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r8
	.word 0xd0a7a000  ! 4854: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0b7e000  ! 4855: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	mov	0x3e0, %r20
	.word 0xd0d7ce80  ! 4857: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r8
	.word 0xd297e000  ! 4858: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	.word 0xdab584a0  ! 4859: STHA_R	stha	%r13, [%r22 + %r0] 0x25
	.word 0xdcbf2000  ! 4860: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	mov	0x3c8, %r20
	.word 0xd8d7ce80  ! 4862: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r12
	.word 0xd6a584a0  ! 4863: STWA_R	stwa	%r11, [%r22 + %r0] 0x25
	.word 0xd8ae09e0  ! 4864: STBA_R	stba	%r12, [%r24 + %r0] 0x4f
	.word 0xd2872000  ! 4865: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	mov	0x10, %r26
	mov	0x40, %r17
	mov	0x3c0, %r20
	.word 0xdad649e0  ! 4869: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r13
	mov	0x58, %r16
	.word 0xd486c9e0  ! 4871: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r10
	.word 0xd6bf6000  ! 4872: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd697e000  ! 4873: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0xd6f70e60  ! 4874: STXA_R	stxa	%r11, [%r28 + %r0] 0x73
	.word 0xda8fe000  ! 4875: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4876: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaae2000  ! 4877: STBA_I	stba	%r13, [%r24 + 0x0000] %asi
	.word 0xdaf66000  ! 4878: STXA_I	stxa	%r13, [%r25 + 0x0000] %asi
	.word 0xdab6a000  ! 4879: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	mov	0x48, %r25
	.word 0x87802073  ! 4881: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0cf0e40  ! 4882: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r8
	.word 0xd8f4c400  ! 4883: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xdccc8400  ! 4884: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	.word 0xdcbf0e40  ! 4885: STDA_R	stda	%r14, [%r28 + %r0] 0x72
	.word 0xdef78e40  ! 4886: STXA_R	stxa	%r15, [%r30 + %r0] 0x72
	mov	0x10, %r25
	.word 0xd6b6a000  ! 4888: STHA_I	stha	%r11, [%r26 + 0x0000] %asi
	.word 0xdc9f8e60  ! 4889: LDDA_R	ldda	[%r30, %r0] 0x73, %r14
	.word 0xd4bf4e40  ! 4890: STDA_R	stda	%r10, [%r29 + %r0] 0x72
	mov	0x18, %r16
	.word 0xdace2000  ! 4892: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 4893: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r21
	mov	0x18, %r26
	.word 0xd69c4400  ! 4896: LDDA_R	ldda	[%r17, %r0] 0x20, %r11
	.word 0x87802072  ! 4897: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8ae49e0  ! 4898: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0xd0af4e80  ! 4899: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	.word 0x8780204f  ! 4900: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6ac2000  ! 4901: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0x87802074  ! 4903: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r24
	.word 0xd6b4a000  ! 4905: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xdab78e80  ! 4906: STHA_R	stha	%r13, [%r30 + %r0] 0x74
	.word 0xdedce000  ! 4907: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r15
	.word 0xd2b4c400  ! 4908: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	mov	0x58, %r16
	.word 0xdea46000  ! 4910: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xde8ca000  ! 4911: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0x87802020  ! 4912: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedc2000  ! 4913: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r15
	mov	0x3d0, %r22
	mov	0x30, %r25
	.word 0xdebca000  ! 4916: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xdebc6000  ! 4917: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xdeb46000  ! 4918: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 4919: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb7ce40  ! 4920: STHA_R	stha	%r15, [%r31 + %r0] 0x72
	.word 0x87802025  ! 4921: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r24
	.word 0xd2f689e0  ! 4923: STXA_R	stxa	%r9, [%r26 + %r0] 0x4f
	.word 0xd49fa000  ! 4924: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0x87802073  ! 4925: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd497a000  ! 4926: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	mov	0x20, %r19
	.word 0xd4b72000  ! 4928: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 4929: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f7e000  ! 4930: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xd28c4400  ! 4931: LDUBA_R	lduba	[%r17, %r0] 0x20, %r9
	.word 0xd0afe000  ! 4932: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd8bd84a0  ! 4933: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	.word 0xd0b584a0  ! 4934: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	mov	0x3c0, %r21
	.word 0xd8ad44a0  ! 4936: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	mov	0x8, %r25
	.word 0xd09689e0  ! 4938: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r8
	.word 0x8780204f  ! 4939: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e8, %r21
	.word 0x87802073  ! 4941: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda9f0e40  ! 4942: LDDA_R	ldda	[%r28, %r0] 0x72, %r13
	.word 0xdcf7ce60  ! 4943: STXA_R	stxa	%r14, [%r31 + %r0] 0x73
	.word 0x87802025  ! 4944: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd28ce000  ! 4945: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	.word 0xda9504a0  ! 4946: LDUHA_R	lduha	[%r20, %r0] 0x25, %r13
	.word 0xd2bdc4a0  ! 4947: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	.word 0x87802020  ! 4948: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r22
	.word 0x87802025  ! 4950: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8c72000  ! 4951: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd08f4e60  ! 4952: LDUBA_R	lduba	[%r29, %r0] 0x73, %r8
	mov	0x48, %r17
	.word 0x8780204f  ! 4954: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdef78e40  ! 4955: STXA_R	stxa	%r15, [%r30 + %r0] 0x72
	.word 0xd28c4400  ! 4956: LDUBA_R	lduba	[%r17, %r0] 0x20, %r9
	mov	0x20, %r17
	.word 0xded40400  ! 4958: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	.word 0xd68dc4a0  ! 4959: LDUBA_R	lduba	[%r23, %r0] 0x25, %r11
	.word 0x87802072  ! 4960: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 4961: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 4962: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f6c9e0  ! 4963: STXA_R	stxa	%r9, [%r27 + %r0] 0x4f
	.word 0xd2a4e000  ! 4964: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0xd49d44a0  ! 4965: LDDA_R	ldda	[%r21, %r0] 0x25, %r10
	.word 0xd29fce80  ! 4966: LDDA_R	ldda	[%r31, %r0] 0x74, %r9
	mov	0x3f0, %r20
	.word 0x87802020  ! 4968: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cf2000  ! 4969: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0x87802072  ! 4970: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f0, %r22
	.word 0xd0d609e0  ! 4972: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r8
	mov	0x10, %r19
	.word 0xdaf76000  ! 4974: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	mov	0x0, %r27
	.word 0xdaa7a000  ! 4976: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xd28f0e80  ! 4977: LDUBA_R	lduba	[%r28, %r0] 0x74, %r9
	mov	0x7e8, %r23
	mov	0x18, %r19
	.word 0xdcd7e000  ! 4980: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xdaf74e80  ! 4981: STXA_R	stxa	%r13, [%r29 + %r0] 0x74
	.word 0xd6a7a000  ! 4982: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 4983: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r16
	mov	0x28, %r27
	.word 0xd68ca000  ! 4986: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r11
	.word 0xd69c6000  ! 4987: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r11
	.word 0xde9e89e0  ! 4988: LDDA_R	ldda	[%r26, %r0] 0x4f, %r15
	.word 0xd2a649e0  ! 4989: STWA_R	stwa	%r9, [%r25 + %r0] 0x4f
	.word 0xd09f0e80  ! 4990: LDDA_R	ldda	[%r28, %r0] 0x74, %r8
	.word 0xda9c6000  ! 4991: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xdac42000  ! 4992: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4993: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b7ce80  ! 4994: STHA_R	stha	%r12, [%r31 + %r0] 0x74
	.word 0xd4ac0400  ! 4995: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xdcd7a000  ! 4996: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0xd4bc0400  ! 4997: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0x87802020  ! 4998: WRASI_I	wr	%r0, 0x0020, %asi
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_2:
	.word 0xdcbf4e80  ! 1: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	.word 0xd6cee000  ! 2: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r11
	.word 0xd2bfce80  ! 3: STDA_R	stda	%r9, [%r31 + %r0] 0x74
	.word 0xd0b62000  ! 4: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0d6a000  ! 6: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r8
	mov	0x7e8, %r21
	.word 0xd0bee000  ! 8: STDA_I	stda	%r8, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 9: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ae09e0  ! 10: STBA_R	stba	%r8, [%r24 + %r0] 0x4f
	.word 0xd4978e80  ! 11: LDUHA_R	lduha	[%r30, %r0] 0x74, %r10
	.word 0xda9fa000  ! 12: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	mov	0x50, %r18
	.word 0x87802025  ! 14: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 15: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f74e40  ! 16: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	.word 0xd6dfce60  ! 17: LDXA_R	ldxa	[%r31, %r0] 0x73, %r11
	.word 0xd0dea000  ! 18: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r8
	.word 0xd0c62000  ! 19: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r8
	.word 0xdc8dc4a0  ! 20: LDUBA_R	lduba	[%r23, %r0] 0x25, %r14
	.word 0xdc8fce60  ! 21: LDUBA_R	lduba	[%r31, %r0] 0x73, %r14
	.word 0xdeb6e000  ! 22: STHA_I	stha	%r15, [%r27 + 0x0000] %asi
	mov	0x30, %r16
	.word 0xde962000  ! 24: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r15
	.word 0x87802020  ! 25: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde862000  ! 26: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r15
	.word 0xdcdc4400  ! 27: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	mov	0x20, %r17
	.word 0x87802025  ! 29: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2f649e0  ! 30: STXA_R	stxa	%r9, [%r25 + %r0] 0x4f
	.word 0xde8689e0  ! 31: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r15
	.word 0x8780204f  ! 32: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0d40400  ! 33: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	.word 0xd6a70e40  ! 34: STWA_R	stwa	%r11, [%r28 + %r0] 0x72
	mov	0x3c0, %r23
	.word 0xde8ee000  ! 36: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r15
	mov	0x30, %r27
	.word 0xde8609e0  ! 38: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r15
	.word 0xdec78e80  ! 39: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r15
	mov	0x7d8, %r22
	mov	0x30, %r25
	.word 0xdc9d04a0  ! 42: LDDA_R	ldda	[%r20, %r0] 0x25, %r14
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0afce40  ! 44: STBA_R	stba	%r8, [%r31 + %r0] 0x72
	.word 0xd6be2000  ! 45: STDA_I	stda	%r11, [%r24 + 0x0000] %asi
	.word 0xd0f78e80  ! 46: STXA_R	stxa	%r8, [%r30 + %r0] 0x74
	.word 0xdc8c0400  ! 47: LDUBA_R	lduba	[%r16, %r0] 0x20, %r14
	.word 0xd486e000  ! 48: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	mov	0x70, %r25
	.word 0xd2b44400  ! 50: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0x87802025  ! 51: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 52: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r27
	mov	0x10, %r16
	.word 0xda946000  ! 55: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	.word 0x87802025  ! 56: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd28d44a0  ! 57: LDUBA_R	lduba	[%r21, %r0] 0x25, %r9
	.word 0xdc87a000  ! 58: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0x87802020  ! 59: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r16
	.word 0x87802072  ! 61: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd68c0400  ! 62: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	mov	0x58, %r24
	ta	T_CHANGE_NONHPRIV	! macro
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd8f4c400  ! 66: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0x87802074  ! 67: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bd84a0  ! 68: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	.word 0xd8dfce80  ! 69: LDXA_R	ldxa	[%r31, %r0] 0x74, %r12
	.word 0xd2aca000  ! 70: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0xd2a70e80  ! 71: STWA_R	stwa	%r9, [%r28 + %r0] 0x74
	.word 0xd8c42000  ! 72: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r12
	mov	0x18, %r24
	.word 0xdcdcc400  ! 74: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	.word 0xd8b4c400  ! 75: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0xdca48400  ! 76: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	mov	0x68, %r16
	mov	0x3d0, %r20
	.word 0x87802074  ! 79: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde972000  ! 80: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	mov	0x0, %r26
	.word 0xd2de89e0  ! 82: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r9
	.word 0xd4f4c400  ! 83: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	mov	0x58, %r26
	.word 0xd4cf6000  ! 85: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0x87802074  ! 86: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c0, %r21
	.word 0xd8a6c9e0  ! 88: STWA_R	stwa	%r12, [%r27 + %r0] 0x4f
	.word 0xdaa72000  ! 89: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xda872000  ! 90: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0xd4af4e80  ! 91: STBA_R	stba	%r10, [%r29 + %r0] 0x74
	mov	0x48, %r16
	.word 0x87802073  ! 93: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 94: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f689e0  ! 95: STXA_R	stxa	%r9, [%r26 + %r0] 0x4f
	.word 0xdef544a0  ! 96: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	.word 0xdc8ee000  ! 97: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r14
	.word 0xd6dc0400  ! 98: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	.word 0xdc862000  ! 99: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r14
	mov	0x20, %r17
	.word 0xde840400  ! 101: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	.word 0xd4a62000  ! 102: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	mov	0x7c8, %r22
	mov	0x7f0, %r21
	.word 0xdad6c9e0  ! 105: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r13
	.word 0xd88ee000  ! 106: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r12
	.word 0xded40400  ! 107: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	.word 0xd8844400  ! 108: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r12
	mov	0x28, %r16
	mov	0x78, %r27
	.word 0x8780204f  ! 111: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 112: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29ea000  ! 113: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r9
	.word 0xdea78e80  ! 114: STWA_R	stwa	%r15, [%r30 + %r0] 0x74
	.word 0xdedee000  ! 115: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r15
	.word 0xd0f70e40  ! 116: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	.word 0xd2d649e0  ! 117: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r9
	mov	0x78, %r16
	.word 0x8780204f  ! 119: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f48400  ! 120: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xd0a74e80  ! 121: STWA_R	stwa	%r8, [%r29 + %r0] 0x74
	mov	0x60, %r27
	.word 0xdec72000  ! 123: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xdcf48400  ! 124: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 125: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2ae6000  ! 126: STBA_I	stba	%r9, [%r25 + 0x0000] %asi
	.word 0xdc8cc400  ! 127: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	mov	0x7e0, %r21
	.word 0xd8866000  ! 129: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r12
	mov	0x40, %r27
	mov	0x20, %r17
	.word 0xdaa44400  ! 132: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	mov	0x20, %r24
	.word 0x87802025  ! 134: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebf0e80  ! 135: STDA_R	stda	%r15, [%r28 + %r0] 0x74
	.word 0xd6b544a0  ! 136: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	mov	0x10, %r26
	.word 0x87802073  ! 138: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdecfa000  ! 139: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xdec72000  ! 140: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xda9f4e40  ! 141: LDDA_R	ldda	[%r29, %r0] 0x72, %r13
	.word 0xd28fa000  ! 142: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	.word 0x87802074  ! 143: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2d74e40  ! 144: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r9
	.word 0xda86c9e0  ! 145: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r13
	mov	0x7d0, %r20
	.word 0x87802073  ! 147: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4a48400  ! 148: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xd0bca000  ! 149: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 150: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 151: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d0, %r23
	mov	0x68, %r24
	.word 0xd09f6000  ! 154: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	.word 0xd0d76000  ! 155: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	mov	0x7d0, %r23
	.word 0x87802020  ! 157: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ac2000  ! 158: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xd887ce40  ! 159: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r12
	.word 0xd6cf0e40  ! 160: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r11
	.word 0xd0bf8e80  ! 161: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	.word 0xd8ace000  ! 162: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 163: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d56000  ! 164: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r12
	.word 0xd8b56000  ! 165: STHA_I	stha	%r12, [%r21 + 0x0000] %asi
	.word 0xd8856000  ! 166: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	.word 0xd2af4e80  ! 167: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	.word 0xd6bd6000  ! 168: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0xd6bda000  ! 169: STDA_I	stda	%r11, [%r22 + 0x0000] %asi
	.word 0xd0c689e0  ! 170: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r8
	mov	0x50, %r24
	.word 0xd2f5a000  ! 172: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	mov	0x3e8, %r23
	mov	0x8, %r24
	mov	0x3c0, %r22
	mov	0x3e0, %r23
	mov	0x28, %r24
	.word 0xd6b504a0  ! 178: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	mov	0x7f0, %r20
	.word 0xd0a52000  ! 180: STWA_I	stwa	%r8, [%r20 + 0x0000] %asi
	.word 0xd4f78e60  ! 181: STXA_R	stxa	%r10, [%r30 + %r0] 0x73
	.word 0xd2ad44a0  ! 182: STBA_R	stba	%r9, [%r21 + %r0] 0x25
	.word 0x87802073  ! 183: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcdf6000  ! 184: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xdccfa000  ! 185: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xdcc7a000  ! 186: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0x87802072  ! 187: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r25
	mov	0x7f0, %r20
	.word 0xdcb4e000  ! 190: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xd6cd44a0  ! 191: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r11
	.word 0xd69ce000  ! 192: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r11
	.word 0xd0c7ce40  ! 193: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r8
	mov	0x40, %r24
	mov	0x3d0, %r22
	.word 0x87802072  ! 196: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f8, %r21
	mov	0x7c8, %r23
	mov	0x58, %r17
	.word 0xd6ade000  ! 200: STBA_I	stba	%r11, [%r23 + 0x0000] %asi
	.word 0xd6ad2000  ! 201: STBA_I	stba	%r11, [%r20 + 0x0000] %asi
	mov	0x3e0, %r23
	.word 0xd6c78e40  ! 203: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	.word 0xd8dd2000  ! 204: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r12
	.word 0xd8b74e80  ! 205: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	.word 0x87802074  ! 206: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c8, %r22
	.word 0xdabc0400  ! 208: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xdac40400  ! 209: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	.word 0xd6df4e60  ! 210: LDXA_R	ldxa	[%r29, %r0] 0x73, %r11
	.word 0xde8de000  ! 211: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r15
	.word 0xdeb5a000  ! 212: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	mov	0x68, %r26
	.word 0xd8f78e60  ! 214: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	.word 0xd4d5c4a0  ! 215: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r10
	mov	0x3f8, %r20
	.word 0xd0dda000  ! 217: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r8
	.word 0xdcadc4a0  ! 218: STBA_R	stba	%r14, [%r23 + %r0] 0x25
	mov	0x3e0, %r20
	.word 0xd4c5a000  ! 220: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r10
	.word 0xd8b609e0  ! 221: STHA_R	stha	%r12, [%r24 + %r0] 0x4f
	mov	0x18, %r26
	mov	0x0, %r24
	mov	0x3f8, %r21
	mov	0x58, %r18
	.word 0x87802020  ! 226: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c78e80  ! 227: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r9
	.word 0xd29609e0  ! 228: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r9
	mov	0x3f0, %r23
	.word 0xd28c0400  ! 230: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	.word 0x87802074  ! 231: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4c689e0  ! 232: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r10
	.word 0xdcbfa000  ! 233: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	mov	0x8, %r19
	.word 0xdc9f2000  ! 235: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xdc8fa000  ! 236: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdca7a000  ! 237: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 238: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b44400  ! 239: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	mov	0x40, %r26
	.word 0xd4f504a0  ! 241: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0xdeb4c400  ! 242: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	mov	0x68, %r16
	mov	0x7d0, %r23
	mov	0x7c0, %r20
	mov	0x40, %r19
	mov	0x7c0, %r21
	.word 0xdcafce80  ! 248: STBA_R	stba	%r14, [%r31 + %r0] 0x74
	.word 0xdcbfe000  ! 249: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdcb7ce60  ! 250: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	mov	0x3e8, %r20
	.word 0x87802020  ! 252: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r16
	.word 0xd2876000  ! 254: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xd295c4a0  ! 255: LDUHA_R	lduha	[%r23, %r0] 0x25, %r9
	.word 0xd8872000  ! 256: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	.word 0xd6f40400  ! 257: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	mov	0x7e0, %r23
	.word 0xd2844400  ! 259: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	.word 0xdaf44400  ! 260: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0xdcd72000  ! 261: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xdc9f2000  ! 262: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xde8544a0  ! 263: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r15
	.word 0x87802072  ! 264: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd697a000  ! 265: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0x87802025  ! 266: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r26
	.word 0xdaa70e40  ! 268: STWA_R	stwa	%r13, [%r28 + %r0] 0x72
	.word 0xdeac0400  ! 269: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xd6f4c400  ! 270: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	mov	0x3d0, %r20
	.word 0x87802073  ! 272: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb40400  ! 273: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0xd48544a0  ! 274: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r10
	.word 0xdaa78e80  ! 275: STWA_R	stwa	%r13, [%r30 + %r0] 0x74
	.word 0xdc97a000  ! 276: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	.word 0xdcb7e000  ! 277: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xdcdd44a0  ! 278: LDXA_R	ldxa	[%r21, %r0] 0x25, %r14
	.word 0x87802025  ! 279: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r16
	.word 0x87802073  ! 281: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r18
	.word 0xd4c74e60  ! 283: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r10
	.word 0xd8dc4400  ! 284: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0xdccf6000  ! 285: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdef48400  ! 286: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xd6df2000  ! 287: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0x87802073  ! 288: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r17
	.word 0x87802020  ! 290: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bc4400  ! 291: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	mov	0x7c8, %r20
	.word 0x87802073  ! 293: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdac62000  ! 294: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r13
	.word 0xdab6a000  ! 295: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	.word 0xd4d689e0  ! 296: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r10
	.word 0xd8cc8400  ! 297: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	mov	0x7d8, %r20
	mov	0x3d8, %r23
	.word 0xd2c66000  ! 300: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r9
	.word 0xd2f62000  ! 301: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	.word 0xd6b5c4a0  ! 302: STHA_R	stha	%r11, [%r23 + %r0] 0x25
	mov	0x20, %r26
	.word 0xdebe6000  ! 304: STDA_I	stda	%r15, [%r25 + 0x0000] %asi
	.word 0xdecea000  ! 305: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r15
	.word 0xdeaee000  ! 306: STBA_I	stba	%r15, [%r27 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x70, %r26
	.word 0xde8e6000  ! 309: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r15
	.word 0x87802020  ! 310: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r23
	.word 0x87802025  ! 312: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 313: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9fa000  ! 314: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	.word 0xdedfa000  ! 315: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x7d8, %r20
	.word 0xd2bc0400  ! 317: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xd0c7a000  ! 318: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0cfe000  ! 319: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xd0bc0400  ! 320: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	mov	0x38, %r18
	.word 0xd4cfa000  ! 322: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0xd4a7a000  ! 323: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	mov	0x7d8, %r20
	mov	0x0, %r17
	mov	0x3c0, %r21
	.word 0xdedf4e80  ! 327: LDXA_R	ldxa	[%r29, %r0] 0x74, %r15
	.word 0xdedd04a0  ! 328: LDXA_R	ldxa	[%r20, %r0] 0x25, %r15
	mov	0x10, %r18
	.word 0xdef4c400  ! 330: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xdece09e0  ! 331: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r15
	mov	0x3f0, %r20
	.word 0xdec7a000  ! 333: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xdec7e000  ! 334: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xd8c6c9e0  ! 335: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r12
	.word 0xdcf7ce40  ! 336: STXA_R	stxa	%r14, [%r31 + %r0] 0x72
	.word 0x87802025  ! 337: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 338: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd89ce000  ! 339: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	.word 0xd8b46000  ! 340: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0xd8f4e000  ! 341: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xd8a4a000  ! 342: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 343: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a78e40  ! 344: STWA_R	stwa	%r11, [%r30 + %r0] 0x72
	.word 0x87802073  ! 345: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 346: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdea6a000  ! 347: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	mov	0x7c8, %r21
	.word 0xd89c8400  ! 349: LDDA_R	ldda	[%r18, %r0] 0x20, %r12
	.word 0xdaaf4e40  ! 350: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	.word 0x87802020  ! 351: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cd2000  ! 352: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r9
	.word 0xd0978e80  ! 353: LDUHA_R	lduha	[%r30, %r0] 0x74, %r8
	.word 0xd8f6c9e0  ! 354: STXA_R	stxa	%r12, [%r27 + %r0] 0x4f
	.word 0xd494c400  ! 355: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	mov	0x7f8, %r22
	.word 0xd8ad2000  ! 357: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	.word 0xd8c56000  ! 358: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r12
	.word 0xd885e000  ! 359: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r12
	.word 0xd8f40400  ! 360: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	mov	0x50, %r19
	mov	0x30, %r27
	.word 0xdcb56000  ! 363: STHA_I	stha	%r14, [%r21 + 0x0000] %asi
	.word 0xdcb52000  ! 364: STHA_I	stha	%r14, [%r20 + 0x0000] %asi
	.word 0xd0b48400  ! 365: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x38, %r18
	.word 0xd6a5e000  ! 368: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	.word 0xd2f40400  ! 369: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0x87802020  ! 370: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 371: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49c8400  ! 372: LDDA_R	ldda	[%r18, %r0] 0x20, %r10
	.word 0x87802074  ! 373: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc878e60  ! 374: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r14
	.word 0xdab48400  ! 375: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0x87802072  ! 376: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6bd2000  ! 377: STDA_I	stda	%r11, [%r20 + 0x0000] %asi
	mov	0x48, %r26
	.word 0xd6bd6000  ! 379: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0xd6cde000  ! 380: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r11
	.word 0xd2d48400  ! 381: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	.word 0x87802020  ! 382: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6dd44a0  ! 383: LDXA_R	ldxa	[%r21, %r0] 0x25, %r11
	.word 0xdcbf6000  ! 384: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdcd76000  ! 385: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdab70e80  ! 387: STHA_R	stha	%r13, [%r28 + %r0] 0x74
	.word 0xd2cd04a0  ! 388: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r9
	mov	0x0, %r26
	.word 0xd4dfe000  ! 390: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	mov	0x60, %r26
	.word 0xda8649e0  ! 392: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r13
	.word 0xd88ec9e0  ! 393: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r12
	.word 0x87802020  ! 394: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadf8e40  ! 395: LDXA_R	ldxa	[%r30, %r0] 0x72, %r13
	.word 0xd6f72000  ! 396: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6bf2000  ! 397: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd6bf0e80  ! 398: STDA_R	stda	%r11, [%r28 + %r0] 0x74
	.word 0xdcf7e000  ! 399: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcd72000  ! 400: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xd6cf8e40  ! 401: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r11
	.word 0xd8bf0e60  ! 402: STDA_R	stda	%r12, [%r28 + %r0] 0x73
	.word 0xdaaf8e40  ! 403: STBA_R	stba	%r13, [%r30 + %r0] 0x72
	.word 0x8780204f  ! 404: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r23
	.word 0xd6a5c4a0  ! 406: STWA_R	stwa	%r11, [%r23 + %r0] 0x25
	mov	0x18, %r24
	.word 0x87802025  ! 408: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabf2000  ! 409: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xd8bdc4a0  ! 410: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	.word 0xd6c7ce60  ! 411: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r11
	.word 0xdeb584a0  ! 412: STHA_R	stha	%r15, [%r22 + %r0] 0x25
	mov	0x40, %r24
	mov	0x3d0, %r20
	mov	0x3c8, %r21
	mov	0x68, %r26
	.word 0x87802025  ! 417: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d0, %r22
	mov	0x3f8, %r21
	.word 0xd4bca000  ! 420: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0xd4dce000  ! 421: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	.word 0xd4f42000  ! 422: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd49c6000  ! 423: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	mov	0x7d0, %r21
	.word 0x87802020  ! 425: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cfa000  ! 426: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	mov	0x3d8, %r23
	.word 0xd2ae09e0  ! 428: STBA_R	stba	%r9, [%r24 + %r0] 0x4f
	mov	0x3e8, %r22
	.word 0xd4ad04a0  ! 430: STBA_R	stba	%r10, [%r20 + %r0] 0x25
	.word 0xdebfce40  ! 431: STDA_R	stda	%r15, [%r31 + %r0] 0x72
	.word 0xdeb72000  ! 432: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	mov	0x50, %r25
	.word 0x87802020  ! 434: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2944400  ! 435: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0948400  ! 437: LDUHA_R	lduha	[%r18, %r0] 0x20, %r8
	.word 0x87802020  ! 438: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r23
	.word 0x87802073  ! 440: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8ce09e0  ! 441: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r12
	.word 0x87802020  ! 442: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d7a000  ! 443: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	mov	0x0, %r27
	mov	0x7e0, %r21
	.word 0xd4c76000  ! 446: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4b76000  ! 447: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 448: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 449: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2b7ce80  ! 450: STHA_R	stha	%r9, [%r31 + %r0] 0x74
	.word 0xd0ac2000  ! 451: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xd69f0e80  ! 452: LDDA_R	ldda	[%r28, %r0] 0x74, %r11
	mov	0x68, %r18
	.word 0x87802020  ! 454: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r21
	.word 0xd6a4c400  ! 456: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0xd69d04a0  ! 457: LDDA_R	ldda	[%r20, %r0] 0x25, %r11
	.word 0xd296c9e0  ! 458: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r9
	.word 0xd297a000  ! 459: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	.word 0xd28f8e80  ! 460: LDUBA_R	lduba	[%r30, %r0] 0x74, %r9
	.word 0xd4bfe000  ! 461: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x50, %r18
	.word 0xd4a7a000  ! 463: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0x87802020  ! 465: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f4c400  ! 466: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	mov	0x3c8, %r21
	.word 0xdaf609e0  ! 468: STXA_R	stxa	%r13, [%r24 + %r0] 0x4f
	.word 0xd2b74e60  ! 469: STHA_R	stha	%r9, [%r29 + %r0] 0x73
	.word 0xd286e000  ! 470: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r9
	.word 0x87802072  ! 471: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2bf6000  ! 472: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd4a70e60  ! 473: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	.word 0xd0dfce40  ! 474: LDXA_R	ldxa	[%r31, %r0] 0x72, %r8
	mov	0x60, %r16
	.word 0xd29f6000  ! 476: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xd29fa000  ! 477: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd48c4400  ! 478: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	mov	0x70, %r27
	.word 0xdc94c400  ! 480: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	mov	0x10, %r25
	.word 0xd4bf6000  ! 482: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xda8c8400  ! 483: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	.word 0xdcbc0400  ! 484: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0x87802074  ! 485: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f56000  ! 486: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 487: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 488: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0af8e40  ! 489: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0xd48fce40  ! 490: LDUBA_R	lduba	[%r31, %r0] 0x72, %r10
	.word 0xdab72000  ! 491: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 492: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r26
	mov	0x7f8, %r22
	.word 0xdab62000  ! 495: STHA_I	stha	%r13, [%r24 + 0x0000] %asi
	.word 0xdad66000  ! 496: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r13
	.word 0xd29e49e0  ! 497: LDDA_R	ldda	[%r25, %r0] 0x4f, %r9
	.word 0x8780204f  ! 498: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 499: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcaf8e60  ! 500: STBA_R	stba	%r14, [%r30 + %r0] 0x73
	mov	0x78, %r16
	mov	0x28, %r27
	.word 0x87802020  ! 503: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 504: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcacc400  ! 505: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0xdeaca000  ! 506: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xde9ce000  ! 507: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0xde9c2000  ! 508: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xdeb4a000  ! 509: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0xdebce000  ! 510: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xdeb4e000  ! 511: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	mov	0x3c8, %r20
	.word 0xdeaca000  ! 513: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xdecd04a0  ! 514: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r15
	mov	0x8, %r27
	.word 0x87802073  ! 516: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r19
	mov	0x20, %r25
	.word 0xdcd44400  ! 519: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	.word 0xd8cda000  ! 520: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r12
	.word 0xd8f52000  ! 521: STXA_I	stxa	%r12, [%r20 + 0x0000] %asi
	.word 0xd2a7ce80  ! 522: STWA_R	stwa	%r9, [%r31 + %r0] 0x74
	.word 0xd28f0e80  ! 523: LDUBA_R	lduba	[%r28, %r0] 0x74, %r9
	.word 0xdab5e000  ! 524: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xd6a7ce40  ! 526: STWA_R	stwa	%r11, [%r31 + %r0] 0x72
	mov	0x68, %r19
	mov	0x40, %r17
	.word 0x8780204f  ! 529: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf44400  ! 530: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0xdeb42000  ! 531: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 532: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r27
	.word 0xde9de000  ! 534: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r15
	.word 0xde9da000  ! 535: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r15
	.word 0xd68d84a0  ! 536: LDUBA_R	lduba	[%r22, %r0] 0x25, %r11
	.word 0x87802025  ! 537: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2f5a000  ! 538: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	.word 0xd2f5a000  ! 539: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	.word 0xd0a7ce60  ! 540: STWA_R	stwa	%r8, [%r31 + %r0] 0x73
	mov	0x20, %r17
	mov	0x60, %r17
	mov	0x3e8, %r21
	.word 0x87802073  ! 544: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bc0400  ! 545: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xd6b74e40  ! 546: STHA_R	stha	%r11, [%r29 + %r0] 0x72
	mov	0x3e0, %r22
	mov	0x10, %r17
	mov	0x3f0, %r23
	.word 0xd8cc6000  ! 550: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r12
	.word 0x87802072  ! 551: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r18
	.word 0xd8a4a000  ! 553: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 554: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda9584a0  ! 555: LDUHA_R	lduha	[%r22, %r0] 0x25, %r13
	.word 0xdecc2000  ! 556: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	.word 0xde8609e0  ! 557: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r15
	.word 0x8780204f  ! 558: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabd2000  ! 559: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 560: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d40400  ! 561: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	.word 0xd8a66000  ! 562: STWA_I	stwa	%r12, [%r25 + 0x0000] %asi
	.word 0xd8aea000  ! 563: STBA_I	stba	%r12, [%r26 + 0x0000] %asi
	.word 0xdcd6c9e0  ! 564: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r14
	.word 0xd2b70e60  ! 565: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	.word 0xd2bc0400  ! 566: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xd08ea000  ! 567: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r8
	.word 0xd0d6a000  ! 568: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r8
	.word 0x87802072  ! 569: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0dfe000  ! 570: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	mov	0x68, %r19
	.word 0xd0f7a000  ! 572: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	mov	0x20, %r25
	mov	0x8, %r24
	mov	0x3c0, %r20
	.word 0x8780204f  ! 576: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a7e000  ! 577: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	mov	0x48, %r27
	.word 0xd4af0e40  ! 579: STBA_R	stba	%r10, [%r28 + %r0] 0x72
	.word 0xdaaf4e60  ! 580: STBA_R	stba	%r13, [%r29 + %r0] 0x73
	.word 0xdebfe000  ! 581: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xdeafe000  ! 582: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xd0b5c4a0  ! 584: STHA_R	stha	%r8, [%r23 + %r0] 0x25
	.word 0xd0870e40  ! 585: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r8
	.word 0x8780204f  ! 586: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0bfce40  ! 587: STDA_R	stda	%r8, [%r31 + %r0] 0x72
	.word 0x87802074  ! 588: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r25
	.word 0xdcde6000  ! 590: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r14
	.word 0xd6cc0400  ! 591: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r11
	.word 0xd0bea000  ! 592: STDA_I	stda	%r8, [%r26 + 0x0000] %asi
	.word 0xd0c66000  ! 593: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r8
	.word 0xd2878e60  ! 594: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r9
	.word 0xd6f6a000  ! 595: STXA_I	stxa	%r11, [%r26 + 0x0000] %asi
	.word 0xd6966000  ! 596: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r11
	.word 0xd69f4e60  ! 597: LDDA_R	ldda	[%r29, %r0] 0x73, %r11
	.word 0xd0acc400  ! 598: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd2be09e0  ! 599: STDA_R	stda	%r9, [%r24 + %r0] 0x4f
	mov	0x30, %r18
	.word 0x87802020  ! 601: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r16
	.word 0xdab40400  ! 603: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	mov	0x10, %r24
	.word 0xdadce000  ! 605: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	mov	0x10, %r25
	.word 0x8780204f  ! 607: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdad46000  ! 608: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	.word 0xda9c6000  ! 609: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xdab42000  ! 610: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	mov	0x60, %r27
	.word 0xda840400  ! 612: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	.word 0xdc946000  ! 613: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r14
	.word 0xd8d4c400  ! 614: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0xd09ce000  ! 615: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r8
	.word 0xd084e000  ! 616: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	.word 0xd0cce000  ! 617: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0xd2df0e60  ! 618: LDXA_R	ldxa	[%r28, %r0] 0x73, %r9
	.word 0xd0f42000  ! 619: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	mov	0x60, %r18
	.word 0xd896c9e0  ! 621: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r12
	mov	0x30, %r27
	.word 0xd29ca000  ! 623: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	mov	0x48, %r27
	.word 0xd4cd44a0  ! 625: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r10
	.word 0xd0bca000  ! 626: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0xd0dca000  ! 628: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	.word 0xd08c6000  ! 629: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0xdef6c9e0  ! 630: STXA_R	stxa	%r15, [%r27 + %r0] 0x4f
	.word 0xdc842000  ! 631: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	.word 0xd8b74e80  ! 632: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	.word 0xd4c78e60  ! 633: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r10
	.word 0xde942000  ! 634: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	.word 0x87802025  ! 635: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 636: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0d544a0  ! 637: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r8
	mov	0x70, %r24
	.word 0xd29d04a0  ! 639: LDDA_R	ldda	[%r20, %r0] 0x25, %r9
	.word 0xd28e89e0  ! 640: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r9
	.word 0xda878e40  ! 641: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r13
	mov	0x3f8, %r20
	.word 0xd2bf8e60  ! 643: STDA_R	stda	%r9, [%r30 + %r0] 0x73
	.word 0xdeac6000  ! 644: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xde842000  ! 645: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	.word 0xdcaf4e80  ! 646: STBA_R	stba	%r14, [%r29 + %r0] 0x74
	.word 0x87802020  ! 647: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 648: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r19
	mov	0x38, %r24
	.word 0xd2c4a000  ! 651: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	.word 0xd89f8e40  ! 652: LDDA_R	ldda	[%r30, %r0] 0x72, %r12
	mov	0x3e0, %r23
	mov	0x60, %r24
	.word 0xd8f649e0  ! 655: STXA_R	stxa	%r12, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 656: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb76000  ! 657: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	mov	0x70, %r24
	.word 0xdec7e000  ! 659: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	mov	0x50, %r26
	mov	0x60, %r19
	.word 0xd8d689e0  ! 662: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r12
	mov	0x7d8, %r22
	.word 0xd2bfa000  ! 664: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 665: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeafce60  ! 666: STBA_R	stba	%r15, [%r31 + %r0] 0x73
	.word 0xde8c6000  ! 667: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0xde9c2000  ! 668: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xdeafce60  ! 669: STBA_R	stba	%r15, [%r31 + %r0] 0x73
	.word 0xd894e000  ! 670: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r12
	mov	0x38, %r18
	.word 0xd0bc4400  ! 672: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	mov	0x48, %r24
	.word 0xd6cf4e40  ! 674: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r11
	.word 0xd6b70e80  ! 675: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	.word 0xde9ca000  ! 676: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	.word 0xdec4e000  ! 677: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	.word 0xd68d04a0  ! 678: LDUBA_R	lduba	[%r20, %r0] 0x25, %r11
	.word 0x87802073  ! 679: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 680: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r22
	.word 0xda8f6000  ! 682: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xdabc0400  ! 683: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0x87802020  ! 684: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r18
	.word 0xd0a78e80  ! 686: STWA_R	stwa	%r8, [%r30 + %r0] 0x74
	.word 0x87802073  ! 687: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r19
	.word 0xd0b6e000  ! 689: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	.word 0xd2f7ce40  ! 690: STXA_R	stxa	%r9, [%r31 + %r0] 0x72
	.word 0xdaf78e60  ! 691: STXA_R	stxa	%r13, [%r30 + %r0] 0x73
	mov	0x50, %r18
	.word 0xd8dee000  ! 693: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r12
	.word 0x87802073  ! 694: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802072  ! 696: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 697: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r16
	.word 0x87802020  ! 699: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r26
	.word 0xd8972000  ! 701: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	mov	0x70, %r25
	mov	0x7f8, %r21
	.word 0x87802072  ! 704: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 705: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4bf8e80  ! 706: STDA_R	stda	%r10, [%r30 + %r0] 0x74
	.word 0xd89cc400  ! 707: LDDA_R	ldda	[%r19, %r0] 0x20, %r12
	.word 0xd8cf2000  ! 708: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0xd8f7a000  ! 709: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 710: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4dfce80  ! 711: LDXA_R	ldxa	[%r31, %r0] 0x74, %r10
	mov	0x58, %r24
	.word 0xdcb7ce80  ! 713: STHA_R	stha	%r14, [%r31 + %r0] 0x74
	mov	0x38, %r16
	.word 0x87802020  ! 715: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8de6000  ! 716: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r12
	.word 0xd8be6000  ! 717: STDA_I	stda	%r12, [%r25 + 0x0000] %asi
	.word 0x87802073  ! 718: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcdf0e80  ! 719: LDXA_R	ldxa	[%r28, %r0] 0x74, %r14
	.word 0xdebf0e80  ! 720: STDA_R	stda	%r15, [%r28 + %r0] 0x74
	mov	0x58, %r25
	mov	0x7f8, %r21
	.word 0x8780204f  ! 723: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f0, %r21
	mov	0x50, %r25
	.word 0xd6f6a000  ! 726: STXA_I	stxa	%r11, [%r26 + 0x0000] %asi
	.word 0xd68ee000  ! 727: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r11
	.word 0xd6f6e000  ! 728: STXA_I	stxa	%r11, [%r27 + 0x0000] %asi
	mov	0x20, %r25
	mov	0x8, %r16
	mov	0x48, %r24
	.word 0x87802020  ! 732: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b48400  ! 733: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xd6d544a0  ! 734: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r11
	mov	0x10, %r25
	.word 0xdeb5a000  ! 736: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	.word 0xdeb5a000  ! 737: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	mov	0x70, %r25
	.word 0xd4f544a0  ! 739: STXA_R	stxa	%r10, [%r21 + %r0] 0x25
	mov	0x18, %r27
	mov	0x48, %r26
	.word 0xd8b48400  ! 742: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0x87802072  ! 743: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd08de000  ! 744: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r8
	.word 0xd2b70e60  ! 745: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	mov	0x50, %r27
	.word 0xd69d2000  ! 747: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r11
	.word 0xd0b7ce60  ! 748: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	mov	0x68, %r19
	.word 0xd2ad84a0  ! 750: STBA_R	stba	%r9, [%r22 + %r0] 0x25
	.word 0x8780204f  ! 751: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r26
	.word 0x87802074  ! 753: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f609e0  ! 754: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	mov	0x78, %r19
	.word 0xd0af8e40  ! 756: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0x87802073  ! 757: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e8, %r22
	.word 0x8780204f  ! 759: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bda000  ! 760: STDA_I	stda	%r10, [%r22 + 0x0000] %asi
	.word 0xdef689e0  ! 761: STXA_R	stxa	%r15, [%r26 + %r0] 0x4f
	.word 0xdecde000  ! 762: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r15
	.word 0xde8d2000  ! 763: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r15
	mov	0x58, %r18
	.word 0xdedde000  ! 765: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r15
	.word 0xdef5a000  ! 766: STXA_I	stxa	%r15, [%r22 + 0x0000] %asi
	.word 0xdedd2000  ! 767: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r15
	.word 0xdea52000  ! 768: STWA_I	stwa	%r15, [%r20 + 0x0000] %asi
	.word 0x87802072  ! 769: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r17
	.word 0xd2ce89e0  ! 771: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r9
	.word 0xded6a000  ! 772: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r15
	mov	0x70, %r18
	.word 0xd6af8e40  ! 774: STBA_R	stba	%r11, [%r30 + %r0] 0x72
	mov	0x3d0, %r22
	mov	0x48, %r25
	mov	0x28, %r24
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdece6000  ! 779: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r15
	.word 0xdede6000  ! 780: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r15
	.word 0xded6a000  ! 781: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r15
	.word 0xdcf74e60  ! 782: STXA_R	stxa	%r14, [%r29 + %r0] 0x73
	.word 0xdab6a000  ! 783: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xdabe6000  ! 785: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	.word 0xd89d44a0  ! 786: LDDA_R	ldda	[%r21, %r0] 0x25, %r12
	.word 0xd08fce40  ! 787: LDUBA_R	lduba	[%r31, %r0] 0x72, %r8
	.word 0xd8c584a0  ! 788: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r12
	mov	0x78, %r27
	.word 0xdea66000  ! 790: STWA_I	stwa	%r15, [%r25 + 0x0000] %asi
	mov	0x40, %r27
	.word 0xd49c8400  ! 792: LDDA_R	ldda	[%r18, %r0] 0x20, %r10
	.word 0xd2f504a0  ! 793: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	.word 0xdacea000  ! 794: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r13
	.word 0xdeac0400  ! 795: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	mov	0x18, %r26
	mov	0x18, %r26
	.word 0xd2874e60  ! 798: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r9
	.word 0xd8940400  ! 799: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	.word 0xdec62000  ! 800: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r15
	.word 0xdea62000  ! 801: STWA_I	stwa	%r15, [%r24 + 0x0000] %asi
	.word 0xd2d78e40  ! 802: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r9
	.word 0x87802025  ! 803: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2d4a000  ! 804: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	.word 0xd2b42000  ! 805: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 806: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2b46000  ! 807: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0xd2f46000  ! 808: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 809: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd28fe000  ! 810: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	.word 0xd2f40400  ! 811: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xd49fa000  ! 812: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0xd48fa000  ! 813: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xd4f70e80  ! 814: STXA_R	stxa	%r10, [%r28 + %r0] 0x74
	.word 0xdaafe000  ! 815: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	mov	0x38, %r24
	.word 0x8780204f  ! 817: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4cc0400  ! 818: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r10
	.word 0x87802020  ! 819: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r18
	.word 0xd2a4c400  ! 821: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0xd6c44400  ! 822: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r11
	.word 0xd2af8e80  ! 823: STBA_R	stba	%r9, [%r30 + %r0] 0x74
	.word 0xd6bf8e60  ! 824: STDA_R	stda	%r11, [%r30 + %r0] 0x73
	.word 0xdcaf0e80  ! 825: STBA_R	stba	%r14, [%r28 + %r0] 0x74
	mov	0x28, %r16
	.word 0xdebfce60  ! 827: STDA_R	stda	%r15, [%r31 + %r0] 0x73
	.word 0xd6b70e60  ! 828: STHA_R	stha	%r11, [%r28 + %r0] 0x73
	.word 0xde9e49e0  ! 829: LDDA_R	ldda	[%r25, %r0] 0x4f, %r15
	.word 0xd0b70e80  ! 830: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	mov	0x70, %r27
	.word 0x87802020  ! 832: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b4a000  ! 833: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 834: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cfe000  ! 835: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	mov	0x7e0, %r20
	.word 0xd89d84a0  ! 837: LDDA_R	ldda	[%r22, %r0] 0x25, %r12
	.word 0xd88689e0  ! 838: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r12
	.word 0x87802074  ! 839: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8de89e0  ! 840: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r12
	mov	0x38, %r16
	mov	0x60, %r19
	mov	0x10, %r18
	mov	0x7c0, %r20
	.word 0x87802072  ! 845: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda87e000  ! 846: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0x87802074  ! 847: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda97a000  ! 848: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	mov	0x30, %r19
	.word 0xd49c0400  ! 850: LDDA_R	ldda	[%r16, %r0] 0x20, %r10
	mov	0x20, %r25
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd6974e40  ! 853: LDUHA_R	lduha	[%r29, %r0] 0x72, %r11
	.word 0xdc8f0e60  ! 854: LDUBA_R	lduba	[%r28, %r0] 0x73, %r14
	.word 0xd48f2000  ! 855: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 856: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdec48400  ! 857: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	.word 0xdad7e000  ! 858: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xd48649e0  ! 859: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r10
	mov	0x7d0, %r22
	.word 0xd2af4e80  ! 861: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	.word 0xde87ce40  ! 862: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r15
	.word 0xdcaf6000  ! 863: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 864: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r19
	.word 0x87802073  ! 866: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f74e40  ! 867: STXA_R	stxa	%r12, [%r29 + %r0] 0x72
	.word 0xdaf584a0  ! 868: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	.word 0xd89c8400  ! 869: LDDA_R	ldda	[%r18, %r0] 0x20, %r12
	.word 0x87802074  ! 870: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 871: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d0, %r23
	.word 0xd6874e80  ! 873: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r11
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802020  ! 875: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeac6000  ! 876: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xdebc6000  ! 877: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xded4e000  ! 878: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	.word 0xde846000  ! 879: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0xde9c2000  ! 880: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xdebca000  ! 881: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 882: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r26
	.word 0x87802020  ! 884: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r22
	mov	0x3d8, %r20
	.word 0xdea7e000  ! 887: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	mov	0x3e0, %r21
	.word 0xdebfa000  ! 889: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xdec76000  ! 890: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	mov	0x7c8, %r22
	mov	0x7c0, %r21
	.word 0xd6a74e60  ! 893: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	.word 0xdebf0e40  ! 894: STDA_R	stda	%r15, [%r28 + %r0] 0x72
	.word 0x87802020  ! 895: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b56000  ! 896: STHA_I	stha	%r9, [%r21 + 0x0000] %asi
	.word 0xdcd44400  ! 897: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	.word 0xd2ae09e0  ! 898: STBA_R	stba	%r9, [%r24 + %r0] 0x4f
	.word 0xd8f56000  ! 899: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x3d0, %r20
	.word 0xd89fce80  ! 902: LDDA_R	ldda	[%r31, %r0] 0x74, %r12
	.word 0xdef52000  ! 903: STXA_I	stxa	%r15, [%r20 + 0x0000] %asi
	.word 0x87802072  ! 904: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf74e80  ! 905: STXA_R	stxa	%r13, [%r29 + %r0] 0x74
	.word 0x8780204f  ! 906: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r25
	.word 0xd49e09e0  ! 908: LDDA_R	ldda	[%r24, %r0] 0x4f, %r10
	.word 0xd4cc4400  ! 909: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r10
	.word 0xd29f2000  ! 910: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	mov	0x70, %r24
	mov	0x60, %r26
	mov	0x3c0, %r22
	mov	0x20, %r19
	.word 0xd2d7ce60  ! 915: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r9
	.word 0xd0afe000  ! 916: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 917: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6cfce80  ! 918: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r11
	.word 0xd2cf6000  ! 919: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	mov	0x38, %r19
	.word 0x87802025  ! 921: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc94c400  ! 922: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	.word 0x8780204f  ! 923: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda874e60  ! 924: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r13
	mov	0x3c0, %r21
	.word 0x87802020  ! 926: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbfce60  ! 927: STDA_R	stda	%r14, [%r31 + %r0] 0x73
	.word 0x87802073  ! 928: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d8, %r23
	.word 0x8780204f  ! 930: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 931: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a609e0  ! 932: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	.word 0xd8dca000  ! 933: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	mov	0x78, %r17
	.word 0x87802020  ! 935: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r26
	.word 0xd0a70e60  ! 937: STWA_R	stwa	%r8, [%r28 + %r0] 0x73
	.word 0xd484a000  ! 938: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r10
	.word 0x87802020  ! 939: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabfce40  ! 940: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	.word 0xd8a44400  ! 941: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xd0f42000  ! 942: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 943: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a56000  ! 944: STWA_I	stwa	%r8, [%r21 + 0x0000] %asi
	.word 0xd0bde000  ! 945: STDA_I	stda	%r8, [%r23 + 0x0000] %asi
	.word 0xd0b56000  ! 946: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	.word 0xd095a000  ! 947: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r8
	.word 0x87802073  ! 948: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bd84a0  ! 949: STDA_R	stda	%r11, [%r22 + %r0] 0x25
	mov	0x38, %r19
	mov	0x7e0, %r23
	.word 0xdeaca000  ! 952: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	mov	0x70, %r16
	.word 0xd0bd04a0  ! 954: STDA_R	stda	%r8, [%r20 + %r0] 0x25
	.word 0xdcac2000  ! 955: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	mov	0x78, %r16
	.word 0xdaf78e80  ! 957: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	mov	0x3e0, %r22
	mov	0x18, %r24
	mov	0x50, %r16
	.word 0xd6c4e000  ! 961: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r11
	.word 0xd6a4e000  ! 962: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xd6846000  ! 964: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r11
	.word 0xd6b42000  ! 965: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0xd6a42000  ! 966: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xd8bf8e80  ! 967: STDA_R	stda	%r12, [%r30 + %r0] 0x74
	.word 0xdc8c0400  ! 968: LDUBA_R	lduba	[%r16, %r0] 0x20, %r14
	.word 0x87802020  ! 969: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea70e40  ! 970: STWA_R	stwa	%r15, [%r28 + %r0] 0x72
	.word 0xd2c4e000  ! 971: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0x87802020  ! 972: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a4c400  ! 973: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xdc8de000  ! 974: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r14
	.word 0x87802020  ! 975: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cf4e80  ! 976: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r8
	.word 0xd6a46000  ! 977: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0xd0ad04a0  ! 978: STBA_R	stba	%r8, [%r20 + %r0] 0x25
	.word 0xda84e000  ! 979: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r13
	mov	0x3c0, %r20
	.word 0xda846000  ! 981: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r13
	mov	0x3f8, %r22
	.word 0xd6a5c4a0  ! 983: STWA_R	stwa	%r11, [%r23 + %r0] 0x25
	.word 0xded4e000  ! 984: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	.word 0xdc8c8400  ! 985: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802072  ! 987: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdecfe000  ! 988: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 989: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebda000  ! 990: STDA_I	stda	%r15, [%r22 + 0x0000] %asi
	.word 0xdef5a000  ! 991: STXA_I	stxa	%r15, [%r22 + 0x0000] %asi
	.word 0x87802074  ! 992: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r24
	.word 0xde972000  ! 994: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0xde8f2000  ! 995: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xdecf6000  ! 996: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0x87802073  ! 997: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r24
	.word 0x87802025  ! 999: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd89c4400  ! 1000: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	.word 0x87802072  ! 1001: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2d48400  ! 1002: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	.word 0xd2af0e80  ! 1003: STBA_R	stba	%r9, [%r28 + %r0] 0x74
	.word 0xd0840400  ! 1004: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	.word 0xd2c70e60  ! 1005: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r9
	.word 0xd29ce000  ! 1006: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xd28ce000  ! 1007: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	mov	0x7d8, %r23
	mov	0x68, %r27
	.word 0xded44400  ! 1010: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	.word 0xd8dca000  ! 1011: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	mov	0x7c8, %r21
	mov	0x3d8, %r22
	mov	0x58, %r18
	.word 0xd8a42000  ! 1015: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	mov	0x48, %r25
	mov	0x3d0, %r20
	mov	0x7c0, %r23
	.word 0xd0870e60  ! 1019: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r8
	.word 0xdef42000  ! 1020: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xd4dfce80  ! 1021: LDXA_R	ldxa	[%r31, %r0] 0x74, %r10
	.word 0x87802072  ! 1022: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0848400  ! 1023: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r8
	.word 0xd6cc4400  ! 1024: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	.word 0x87802020  ! 1025: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r24
	.word 0xdcc7a000  ! 1027: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xd4f4c400  ! 1028: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd6a78e60  ! 1029: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0xd0b4c400  ! 1030: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0xdc8fe000  ! 1031: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	mov	0x3d0, %r20
	mov	0x70, %r19
	mov	0x3c8, %r21
	mov	0x50, %r18
	mov	0x58, %r17
	.word 0xd2b74e40  ! 1037: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	.word 0xd6a78e80  ! 1038: STWA_R	stwa	%r11, [%r30 + %r0] 0x74
	mov	0x58, %r24
	.word 0x87802072  ! 1040: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f8, %r21
	mov	0x7c8, %r23
	.word 0xd0956000  ! 1043: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r8
	mov	0x0, %r16
	.word 0xdcf649e0  ! 1045: STXA_R	stxa	%r14, [%r25 + %r0] 0x4f
	.word 0xda8649e0  ! 1046: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r13
	.word 0xd8cda000  ! 1047: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r12
	.word 0xd8ada000  ! 1048: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 1049: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a689e0  ! 1050: STWA_R	stwa	%r11, [%r26 + %r0] 0x4f
	.word 0xd8ad04a0  ! 1051: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	.word 0x87802072  ! 1052: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3e8, %r22
	mov	0x50, %r26
	.word 0xd0f56000  ! 1055: STXA_I	stxa	%r8, [%r21 + 0x0000] %asi
	mov	0x3c8, %r22
	.word 0xd0d52000  ! 1057: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r8
	.word 0xd0b5a000  ! 1058: STHA_I	stha	%r8, [%r22 + 0x0000] %asi
	mov	0x28, %r17
	.word 0xda8d04a0  ! 1060: LDUBA_R	lduba	[%r20, %r0] 0x25, %r13
	mov	0x58, %r27
	mov	0x70, %r17
	.word 0xd2b74e80  ! 1063: STHA_R	stha	%r9, [%r29 + %r0] 0x74
	.word 0xd8f504a0  ! 1064: STXA_R	stxa	%r12, [%r20 + %r0] 0x25
	.word 0xd685a000  ! 1065: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r11
	.word 0xd6dda000  ! 1066: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r11
	.word 0x87802074  ! 1067: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd694e000  ! 1068: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 1069: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd69f2000  ! 1070: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0x87802073  ! 1071: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdebec9e0  ! 1072: STDA_R	stda	%r15, [%r27 + %r0] 0x4f
	.word 0x8780204f  ! 1073: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebc2000  ! 1074: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 1075: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4878e80  ! 1076: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r10
	mov	0x28, %r16
	.word 0xd4c584a0  ! 1078: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r10
	.word 0xd4dfe000  ! 1079: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1080: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d7a000  ! 1081: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	.word 0x87802072  ! 1082: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r27
	.word 0xd68c0400  ! 1084: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	.word 0xdcbfe000  ! 1085: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdcbfe000  ! 1086: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 1087: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r17
	.word 0xdcbca000  ! 1089: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdcb4a000  ! 1090: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xdc8c6000  ! 1091: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 1092: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4cc0400  ! 1093: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r10
	.word 0xd0f48400  ! 1094: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xd4d584a0  ! 1095: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r10
	.word 0x87802025  ! 1096: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8cfe000  ! 1097: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0x87802072  ! 1098: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 1099: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd09f4e80  ! 1100: LDDA_R	ldda	[%r29, %r0] 0x74, %r8
	mov	0x10, %r16
	.word 0xdaf6e000  ! 1102: STXA_I	stxa	%r13, [%r27 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdac48400  ! 1104: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	mov	0x48, %r26
	.word 0xd8a78e60  ! 1106: STWA_R	stwa	%r12, [%r30 + %r0] 0x73
	mov	0x68, %r17
	mov	0x68, %r16
	.word 0xd09689e0  ! 1109: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r8
	.word 0xd8b40400  ! 1110: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xd8cfce80  ! 1111: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r12
	.word 0xd88ee000  ! 1112: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r12
	.word 0xd8aee000  ! 1113: STBA_I	stba	%r12, [%r27 + 0x0000] %asi
	mov	0x3f0, %r23
	.word 0x87802025  ! 1115: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8f4e000  ! 1116: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	mov	0x30, %r18
	.word 0xd0a44400  ! 1118: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xd28ca000  ! 1119: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1120: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a6e000  ! 1121: STWA_I	stwa	%r9, [%r27 + 0x0000] %asi
	mov	0x18, %r27
	mov	0x3d8, %r23
	.word 0xd2f62000  ! 1124: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	.word 0xd2cea000  ! 1125: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1126: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1127: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda878e80  ! 1128: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r13
	.word 0xd29f2000  ! 1129: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0x87802072  ! 1130: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2c7a000  ! 1131: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2f7e000  ! 1132: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1133: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcd7ce60  ! 1134: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r14
	.word 0x87802020  ! 1135: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcd6a000  ! 1136: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r14
	.word 0xdcde6000  ! 1137: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r14
	.word 0xd2a70e60  ! 1138: STWA_R	stwa	%r9, [%r28 + %r0] 0x73
	.word 0xdeb74e40  ! 1139: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	.word 0xd29ee000  ! 1140: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r9
	.word 0xd2aea000  ! 1141: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0x87802073  ! 1142: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b76000  ! 1143: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 1144: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0bf4e80  ! 1145: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	.word 0xdef74e80  ! 1146: STXA_R	stxa	%r15, [%r29 + %r0] 0x74
	.word 0xd8f74e80  ! 1147: STXA_R	stxa	%r12, [%r29 + %r0] 0x74
	mov	0x3c0, %r21
	mov	0x20, %r17
	.word 0xdcdfce60  ! 1150: LDXA_R	ldxa	[%r31, %r0] 0x73, %r14
	.word 0x8780204f  ! 1151: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r19
	.word 0xda9fe000  ! 1153: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xda8f6000  ! 1154: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	mov	0x60, %r26
	.word 0xd0af8e40  ! 1156: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	mov	0x78, %r26
	.word 0xd4ddc4a0  ! 1158: LDXA_R	ldxa	[%r23, %r0] 0x25, %r10
	.word 0xda9fe000  ! 1159: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0x87802025  ! 1160: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8f2000  ! 1161: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1162: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r27
	.word 0xdab52000  ! 1164: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	.word 0xdadde000  ! 1165: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r13
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdad52000  ! 1167: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1168: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r27
	mov	0x68, %r26
	.word 0xdadf6000  ! 1171: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xdaf7a000  ! 1172: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdab7e000  ! 1173: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	mov	0x38, %r19
	.word 0xdab7a000  ! 1175: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xd0df0e40  ! 1176: LDXA_R	ldxa	[%r28, %r0] 0x72, %r8
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2f4c400  ! 1178: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xd287e000  ! 1179: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0xd29fa000  ! 1180: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd4a609e0  ! 1181: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	mov	0x68, %r19
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802020  ! 1184: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r24
	.word 0x87802020  ! 1186: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r18
	mov	0x30, %r16
	mov	0x20, %r26
	.word 0x87802020  ! 1190: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r22
	mov	0x7d0, %r23
	.word 0xd6a78e60  ! 1193: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	mov	0x78, %r16
	mov	0x60, %r27
	mov	0x7f0, %r22
	.word 0xdcafa000  ! 1197: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xdca7a000  ! 1199: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1200: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x3e0, %r20
	mov	0x28, %r24
	.word 0xdc876000  ! 1204: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0xdcdfe000  ! 1205: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	mov	0x68, %r19
	.word 0x8780204f  ! 1207: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4c7ce60  ! 1208: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r10
	mov	0x38, %r26
	.word 0xd6c44400  ! 1210: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r11
	.word 0xd0b62000  ! 1211: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0xd0dee000  ! 1212: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r8
	.word 0xd0c6e000  ! 1213: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r8
	.word 0xd0dee000  ! 1214: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r8
	.word 0xd0b6a000  ! 1215: STHA_I	stha	%r8, [%r26 + 0x0000] %asi
	.word 0xd0bc4400  ! 1216: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xd6d504a0  ! 1217: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r11
	.word 0xdef66000  ! 1218: STXA_I	stxa	%r15, [%r25 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdeb6a000  ! 1220: STHA_I	stha	%r15, [%r26 + 0x0000] %asi
	.word 0xdef6a000  ! 1221: STXA_I	stxa	%r15, [%r26 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xda9fce80  ! 1223: LDDA_R	ldda	[%r31, %r0] 0x74, %r13
	.word 0x87802020  ! 1224: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dfce80  ! 1225: LDXA_R	ldxa	[%r31, %r0] 0x74, %r9
	.word 0xd49c4400  ! 1226: LDDA_R	ldda	[%r17, %r0] 0x20, %r10
	.word 0xda870e60  ! 1227: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r13
	.word 0xd296c9e0  ! 1228: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r9
	.word 0xd6f74e60  ! 1229: STXA_R	stxa	%r11, [%r29 + %r0] 0x73
	.word 0xdecd2000  ! 1230: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r15
	.word 0xde856000  ! 1231: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r15
	.word 0xd6b78e40  ! 1232: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	.word 0xd6a5e000  ! 1233: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	mov	0x68, %r17
	.word 0xd8ce49e0  ! 1235: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r12
	.word 0xdcf5c4a0  ! 1236: STXA_R	stxa	%r14, [%r23 + %r0] 0x25
	.word 0xd2dc8400  ! 1237: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	mov	0x3c0, %r23
	.word 0x87802074  ! 1239: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r27
	.word 0xd2a78e80  ! 1241: STWA_R	stwa	%r9, [%r30 + %r0] 0x74
	.word 0xd8f689e0  ! 1242: STXA_R	stxa	%r12, [%r26 + %r0] 0x4f
	.word 0xd8a72000  ! 1243: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 1244: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde8e09e0  ! 1245: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r15
	.word 0x87802020  ! 1246: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1247: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4ad2000  ! 1248: STBA_I	stba	%r10, [%r20 + 0x0000] %asi
	mov	0x30, %r16
	.word 0xd2ac8400  ! 1250: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xd0852000  ! 1251: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r8
	.word 0xdece89e0  ! 1252: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r15
	.word 0xdcf7ce80  ! 1253: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	.word 0xde9c0400  ! 1254: LDDA_R	ldda	[%r16, %r0] 0x20, %r15
	mov	0x3f0, %r21
	.word 0xd0ac0400  ! 1256: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	.word 0xdca52000  ! 1257: STWA_I	stwa	%r14, [%r20 + 0x0000] %asi
	.word 0xd8ac8400  ! 1258: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0xd2b70e60  ! 1259: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	.word 0xd09f0e40  ! 1260: LDDA_R	ldda	[%r28, %r0] 0x72, %r8
	mov	0x40, %r16
	.word 0xd0bd6000  ! 1262: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0xd0dda000  ! 1263: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r8
	.word 0xda878e60  ! 1264: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r13
	.word 0xd4dd2000  ! 1265: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r10
	.word 0xd4856000  ! 1266: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r10
	mov	0x3c0, %r22
	.word 0xdacf8e60  ! 1268: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r13
	mov	0x3f0, %r23
	mov	0x7e8, %r21
	mov	0x40, %r25
	mov	0x7c0, %r22
	.word 0xd8956000  ! 1273: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r12
	mov	0x3f0, %r23
	.word 0xd8b56000  ! 1275: STHA_I	stha	%r12, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 1276: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88f2000  ! 1277: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0xdc8c4400  ! 1278: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0xd0bc0400  ! 1279: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0x87802020  ! 1280: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69de000  ! 1281: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r11
	.word 0x87802073  ! 1282: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d8, %r23
	.word 0xd284c400  ! 1284: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r9
	.word 0xdaf76000  ! 1285: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdadf6000  ! 1286: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xdeb44400  ! 1287: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0xda870e80  ! 1288: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r13
	mov	0x3c8, %r21
	.word 0xd4bf4e60  ! 1290: STDA_R	stda	%r10, [%r29 + %r0] 0x73
	.word 0xd2b584a0  ! 1291: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0xdaa584a0  ! 1292: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	.word 0xdcafe000  ! 1293: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	mov	0x60, %r27
	.word 0xde9d84a0  ! 1295: LDDA_R	ldda	[%r22, %r0] 0x25, %r15
	.word 0xd6b7a000  ! 1296: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1297: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d4a000  ! 1298: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r11
	.word 0xdc9544a0  ! 1299: LDUHA_R	lduha	[%r21, %r0] 0x25, %r14
	.word 0x87802020  ! 1300: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd897ce60  ! 1301: LDUHA_R	lduha	[%r31, %r0] 0x73, %r12
	.word 0xd0b5e000  ! 1302: STHA_I	stha	%r8, [%r23 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xd6bd04a0  ! 1304: STDA_R	stda	%r11, [%r20 + %r0] 0x25
	mov	0x10, %r25
	.word 0xd0844400  ! 1306: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r8
	.word 0xdedf4e60  ! 1307: LDXA_R	ldxa	[%r29, %r0] 0x73, %r15
	.word 0xdcc5a000  ! 1308: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r14
	.word 0xd2970e80  ! 1309: LDUHA_R	lduha	[%r28, %r0] 0x74, %r9
	.word 0x87802073  ! 1310: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6cec9e0  ! 1311: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r11
	.word 0xd0cd04a0  ! 1312: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r8
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802020  ! 1314: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a78e60  ! 1315: STWA_R	stwa	%r9, [%r30 + %r0] 0x73
	.word 0x8780204f  ! 1316: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b46000  ! 1317: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd0a48400  ! 1318: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0xd8ddc4a0  ! 1319: LDXA_R	ldxa	[%r23, %r0] 0x25, %r12
	.word 0xdcdca000  ! 1320: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xd68c0400  ! 1321: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	.word 0xd6842000  ! 1322: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r11
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd68ca000  ! 1324: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r11
	.word 0xd684a000  ! 1325: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r11
	mov	0x8, %r16
	mov	0x3e0, %r21
	mov	0x3f0, %r21
	.word 0xd6d4a000  ! 1329: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 1330: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r18
	.word 0xd6df2000  ! 1332: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd8af8e60  ! 1333: STBA_R	stba	%r12, [%r30 + %r0] 0x73
	.word 0x8780204f  ! 1334: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r25
	.word 0xd8a4c400  ! 1336: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xd4d4e000  ! 1337: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0xdab70e60  ! 1338: STHA_R	stha	%r13, [%r28 + %r0] 0x73
	.word 0x8780204f  ! 1339: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcd78e60  ! 1340: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r14
	mov	0x30, %r19
	.word 0xdcf42000  ! 1342: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0xd8c544a0  ! 1343: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r12
	mov	0x7c8, %r23
	.word 0x8780204f  ! 1345: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f74e40  ! 1346: STXA_R	stxa	%r8, [%r29 + %r0] 0x72
	.word 0xd4878e40  ! 1347: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r10
	mov	0x0, %r26
	.word 0x87802074  ! 1349: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6cc8400  ! 1350: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	.word 0xd087a000  ! 1351: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1352: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ad2000  ! 1353: STBA_I	stba	%r8, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 1354: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r24
	.word 0xd0872000  ! 1356: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0x87802074  ! 1357: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0afe000  ! 1358: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0d72000  ! 1359: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd4b78e60  ! 1360: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	mov	0x0, %r17
	.word 0xd2df4e60  ! 1362: LDXA_R	ldxa	[%r29, %r0] 0x73, %r9
	.word 0xda9fa000  ! 1363: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0x87802072  ! 1364: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde9f0e40  ! 1365: LDDA_R	ldda	[%r28, %r0] 0x72, %r15
	.word 0xd0aec9e0  ! 1366: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	mov	0x60, %r24
	.word 0xd4b78e60  ! 1368: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	mov	0x50, %r27
	.word 0xd28fce40  ! 1370: LDUBA_R	lduba	[%r31, %r0] 0x72, %r9
	mov	0x7e0, %r21
	mov	0x3d8, %r22
	.word 0xd8ada000  ! 1373: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0x8780204f  ! 1374: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ace000  ! 1375: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 1376: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b46000  ! 1377: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	mov	0x38, %r17
	.word 0xd8a42000  ! 1379: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8a4a000  ! 1380: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8b42000  ! 1381: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	.word 0xd8a4a000  ! 1382: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0x87802073  ! 1384: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2a40400  ! 1385: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	mov	0x7c0, %r23
	.word 0xd8a7ce60  ! 1387: STWA_R	stwa	%r12, [%r31 + %r0] 0x73
	mov	0x20, %r18
	.word 0xd6ac2000  ! 1389: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	.word 0xdca4c400  ! 1390: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xdca42000  ! 1391: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0x87802074  ! 1393: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28504a0  ! 1394: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r9
	.word 0x87802072  ! 1395: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f8, %r23
	.word 0xd6af2000  ! 1397: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd2a40400  ! 1398: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 1399: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bc0400  ! 1400: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xded78e80  ! 1401: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r15
	.word 0xdaaf8e40  ! 1402: STBA_R	stba	%r13, [%r30 + %r0] 0x72
	.word 0xd8dd44a0  ! 1403: LDXA_R	ldxa	[%r21, %r0] 0x25, %r12
	.word 0xd0af2000  ! 1404: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0df6000  ! 1405: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	mov	0x50, %r25
	mov	0x38, %r17
	.word 0xd0872000  ! 1408: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0b76000  ! 1409: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd0bfa000  ! 1410: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 1411: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0970e60  ! 1412: LDUHA_R	lduha	[%r28, %r0] 0x73, %r8
	.word 0xd6b70e80  ! 1413: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	.word 0xd08ec9e0  ! 1414: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r8
	.word 0xd2b70e40  ! 1415: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	.word 0x87802025  ! 1416: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1417: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8878e80  ! 1418: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r12
	.word 0xdadf2000  ! 1419: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0xdad76000  ! 1420: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0x87802073  ! 1421: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdacf2000  ! 1422: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xd68f8e80  ! 1423: LDUBA_R	lduba	[%r30, %r0] 0x74, %r11
	.word 0x87802025  ! 1424: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdedf8e40  ! 1425: LDXA_R	ldxa	[%r30, %r0] 0x72, %r15
	.word 0xd4a4c400  ! 1426: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0xda84e000  ! 1427: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r13
	mov	0x70, %r27
	mov	0x68, %r16
	mov	0x30, %r26
	.word 0xdac42000  ! 1431: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0xd2f78e60  ! 1432: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0xd6f78e60  ! 1433: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	.word 0xdaaca000  ! 1434: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 1435: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r16
	.word 0xdac7a000  ! 1437: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xdac72000  ! 1438: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	mov	0x3f0, %r22
	.word 0x87802020  ! 1440: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf76000  ! 1441: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdacfa000  ! 1442: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xdaafa000  ! 1443: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0xdad7e000  ! 1445: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	mov	0x8, %r27
	.word 0x87802025  ! 1447: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4b44400  ! 1448: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	.word 0x87802020  ! 1449: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaafce80  ! 1450: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	.word 0xd0976000  ! 1451: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0x87802072  ! 1452: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0846000  ! 1453: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	mov	0x60, %r24
	mov	0x48, %r24
	.word 0xdace09e0  ! 1456: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r13
	.word 0xdeb4e000  ! 1457: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0xdebc6000  ! 1459: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	mov	0x7e0, %r22
	.word 0x87802073  ! 1461: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d0, %r21
	mov	0x7e8, %r23
	mov	0x30, %r17
	.word 0xd8af4e80  ! 1465: STBA_R	stba	%r12, [%r29 + %r0] 0x74
	.word 0xdadd2000  ! 1466: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r13
	.word 0xdabda000  ! 1467: STDA_I	stda	%r13, [%r22 + 0x0000] %asi
	mov	0x18, %r19
	.word 0xdc84c400  ! 1469: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	.word 0x87802020  ! 1470: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a4c400  ! 1471: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0xd09f8e80  ! 1472: LDDA_R	ldda	[%r30, %r0] 0x74, %r8
	.word 0xdac40400  ! 1473: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	.word 0xdcbd6000  ! 1474: STDA_I	stda	%r14, [%r21 + 0x0000] %asi
	.word 0xdcdde000  ! 1475: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	mov	0x3d0, %r20
	.word 0xd8dc4400  ! 1477: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	mov	0x7d8, %r21
	.word 0xd4bde000  ! 1479: STDA_I	stda	%r10, [%r23 + 0x0000] %asi
	mov	0x48, %r17
	.word 0xdcb44400  ! 1481: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0xd8bd2000  ! 1482: STDA_I	stda	%r12, [%r20 + 0x0000] %asi
	.word 0xd8bde000  ! 1483: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0xd8f56000  ! 1484: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	.word 0xd8cd6000  ! 1485: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r12
	.word 0xd88c0400  ! 1486: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	mov	0x48, %r16
	mov	0x8, %r26
	.word 0x87802025  ! 1489: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e8, %r21
	.word 0xd0946000  ! 1491: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0xd0b46000  ! 1492: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0xd2a74e60  ! 1494: STWA_R	stwa	%r9, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 1495: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbd84a0  ! 1496: STDA_R	stda	%r14, [%r22 + %r0] 0x25
	.word 0xd8a48400  ! 1497: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	.word 0xdabcc400  ! 1498: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	mov	0x58, %r27
	mov	0x48, %r17
	mov	0x78, %r27
	mov	0x8, %r24
	mov	0x48, %r19
	mov	0x50, %r18
	.word 0xd8b649e0  ! 1505: STHA_R	stha	%r12, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 1506: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ce89e0  ! 1507: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r12
	.word 0xdc862000  ! 1508: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r14
	.word 0xd4bcc400  ! 1509: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	mov	0x7f0, %r21
	.word 0xd2aec9e0  ! 1511: STBA_R	stba	%r9, [%r27 + %r0] 0x4f
	.word 0xd0c504a0  ! 1512: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r8
	.word 0xd4af8e40  ! 1513: STBA_R	stba	%r10, [%r30 + %r0] 0x72
	.word 0xdad6e000  ! 1514: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r13
	.word 0x87802073  ! 1515: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdad44400  ! 1516: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0xde9ca000  ! 1517: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	.word 0xdea42000  ! 1518: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xd68609e0  ! 1519: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r11
	.word 0xd6a40400  ! 1520: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	mov	0x7e8, %r23
	.word 0xdeb42000  ! 1522: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 1523: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r24
	.word 0xdeb4a000  ! 1525: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0xde8ce000  ! 1526: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	.word 0xd6a44400  ! 1527: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0xdc9c6000  ! 1528: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r14
	.word 0xd8f48400  ! 1529: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	mov	0x40, %r25
	.word 0xd2bc4400  ! 1531: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0xd2b48400  ! 1532: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd69cc400  ! 1533: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	.word 0xd0d46000  ! 1534: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r8
	.word 0xd2b70e60  ! 1535: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	.word 0xd4b78e80  ! 1536: STHA_R	stha	%r10, [%r30 + %r0] 0x74
	mov	0x58, %r18
	mov	0x7c0, %r20
	.word 0xdeaf8e80  ! 1539: STBA_R	stba	%r15, [%r30 + %r0] 0x74
	.word 0xd0f4e000  ! 1540: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	mov	0x20, %r26
	.word 0x87802074  ! 1542: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 1543: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r27
	mov	0x30, %r18
	.word 0xd0d72000  ! 1546: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0af4e80  ! 1547: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	mov	0x7f0, %r23
	.word 0xdadf2000  ! 1549: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0xdadfa000  ! 1550: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xd6d70e80  ! 1551: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r11
	.word 0xd2d76000  ! 1552: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0xdabfce60  ! 1553: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	.word 0xdec44400  ! 1554: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0xde972000  ! 1555: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0xde9fa000  ! 1556: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	mov	0x3c8, %r23
	.word 0xded7a000  ! 1558: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xdcac8400  ! 1559: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xd6cfa000  ! 1560: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	mov	0x38, %r26
	mov	0x7e0, %r23
	mov	0x10, %r19
	.word 0xd8d7ce80  ! 1564: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r12
	mov	0x20, %r16
	.word 0x87802073  ! 1566: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdea4e000  ! 1567: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0xd4d70e80  ! 1569: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r10
	.word 0xd097ce60  ! 1570: LDUHA_R	lduha	[%r31, %r0] 0x73, %r8
	.word 0xd69ce000  ! 1571: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r11
	.word 0xd6b42000  ! 1572: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0xd2bd44a0  ! 1573: STDA_R	stda	%r9, [%r21 + %r0] 0x25
	mov	0x50, %r24
	mov	0x68, %r19
	.word 0x87802073  ! 1576: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 1577: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r25
	mov	0x28, %r25
	.word 0x87802074  ! 1580: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 1581: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6ac2000  ! 1582: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xd6dce000  ! 1584: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0xd2bf8e80  ! 1585: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	.word 0xd2a70e80  ! 1586: STWA_R	stwa	%r9, [%r28 + %r0] 0x74
	.word 0xdef6c9e0  ! 1587: STXA_R	stxa	%r15, [%r27 + %r0] 0x4f
	.word 0xdac70e80  ! 1588: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r13
	.word 0xdcb46000  ! 1589: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xdca4e000  ! 1590: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0xd8be09e0  ! 1591: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 1592: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1593: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4948400  ! 1594: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	mov	0x70, %r18
	.word 0xd8df8e40  ! 1596: LDXA_R	ldxa	[%r30, %r0] 0x72, %r12
	mov	0x3c0, %r21
	mov	0x58, %r16
	.word 0xd0a4e000  ! 1599: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0f4a000  ! 1600: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	mov	0x3c0, %r20
	.word 0x87802072  ! 1602: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb649e0  ! 1603: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	.word 0xd0a649e0  ! 1604: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	.word 0xd8afce60  ! 1605: STBA_R	stba	%r12, [%r31 + %r0] 0x73
	.word 0xd8d4e000  ! 1606: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0xd8bfce60  ! 1607: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	.word 0x87802025  ! 1608: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r18
	.word 0xd4ce6000  ! 1610: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r10
	.word 0xdcd78e60  ! 1611: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r14
	.word 0xd6ae49e0  ! 1612: STBA_R	stba	%r11, [%r25 + %r0] 0x4f
	mov	0x3c0, %r20
	.word 0xde8e6000  ! 1614: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r15
	mov	0x7c8, %r23
	.word 0x87802073  ! 1616: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xded4a000  ! 1617: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	.word 0xdef42000  ! 1618: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	mov	0x20, %r16
	.word 0xdebce000  ! 1620: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	mov	0x58, %r19
	.word 0x87802074  ! 1622: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4d44400  ! 1623: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0x87802025  ! 1624: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4f544a0  ! 1625: STXA_R	stxa	%r10, [%r21 + %r0] 0x25
	.word 0x87802020  ! 1626: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0dc6000  ! 1627: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	mov	0x7d0, %r21
	mov	0x7c0, %r21
	.word 0xd0d48400  ! 1630: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	.word 0xdc8f0e80  ! 1631: LDUBA_R	lduba	[%r28, %r0] 0x74, %r14
	mov	0x7e0, %r22
	.word 0x87802074  ! 1633: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcde09e0  ! 1634: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r14
	.word 0xda876000  ! 1635: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	mov	0x0, %r24
	mov	0x28, %r16
	.word 0xdaa7a000  ! 1638: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 1639: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda95e000  ! 1640: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r13
	.word 0xd49649e0  ! 1641: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r10
	.word 0x87802020  ! 1642: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a7ce60  ! 1643: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	.word 0xd4a6a000  ! 1644: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	.word 0x8780204f  ! 1645: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r26
	.word 0xd8cc0400  ! 1647: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	mov	0x78, %r24
	.word 0xd0946000  ! 1649: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0x87802073  ! 1650: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r16
	.word 0xd0af2000  ! 1652: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 1653: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdedec9e0  ! 1654: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r15
	.word 0xd8f4a000  ! 1655: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	mov	0x7c0, %r23
	mov	0x3d0, %r20
	.word 0x87802025  ! 1658: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc878e40  ! 1659: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r14
	.word 0x87802020  ! 1660: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09c4400  ! 1661: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	mov	0x48, %r27
	.word 0x87802025  ! 1663: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd09fa000  ! 1664: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	mov	0x3c8, %r23
	.word 0xd08fe000  ! 1666: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	.word 0x87802073  ! 1667: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 1668: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0d5a000  ! 1669: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r8
	.word 0xd6b4c400  ! 1670: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	mov	0x3d0, %r23
	mov	0x38, %r18
	.word 0xd0a6c9e0  ! 1673: STWA_R	stwa	%r8, [%r27 + %r0] 0x4f
	mov	0x10, %r18
	.word 0xd2d74e60  ! 1675: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r9
	.word 0x8780204f  ! 1676: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0cf8e80  ! 1677: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r8
	mov	0x3e8, %r23
	.word 0x87802072  ! 1679: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 1680: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0dd04a0  ! 1681: LDXA_R	ldxa	[%r20, %r0] 0x25, %r8
	.word 0xdcc7e000  ! 1682: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcdf2000  ! 1683: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	mov	0x20, %r25
	.word 0xdcb72000  ! 1685: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xdcaf6000  ! 1686: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdc8fe000  ! 1687: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xdc9f6000  ! 1688: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0x87802074  ! 1689: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcac2000  ! 1690: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0xd4afce60  ! 1691: STBA_R	stba	%r10, [%r31 + %r0] 0x73
	.word 0xd6f42000  ! 1692: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	.word 0xd6aca000  ! 1693: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 1694: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 1695: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 1696: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcc78e60  ! 1697: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r14
	.word 0xdcac8400  ! 1698: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xd4f7ce40  ! 1699: STXA_R	stxa	%r10, [%r31 + %r0] 0x72
	mov	0x70, %r19
	mov	0x78, %r16
	.word 0xdeac6000  ! 1702: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0xdec584a0  ! 1704: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r15
	.word 0xdcf649e0  ! 1705: STXA_R	stxa	%r14, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 1706: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ae09e0  ! 1707: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 1708: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2cf2000  ! 1709: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r9
	mov	0x7d8, %r23
	mov	0x3d8, %r23
	mov	0x58, %r25
	mov	0x8, %r16
	.word 0x87802020  ! 1714: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b74e40  ! 1715: STHA_R	stha	%r12, [%r29 + %r0] 0x72
	mov	0x50, %r27
	.word 0xd09c6000  ! 1717: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r8
	.word 0xd2cf8e40  ! 1718: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r9
	.word 0xdebce000  ! 1719: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xded4e000  ! 1720: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	mov	0x38, %r18
	.word 0xdeac6000  ! 1722: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0xdecce000  ! 1724: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	.word 0xd6be89e0  ! 1725: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	.word 0xd6d609e0  ! 1726: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r11
	.word 0xdef44400  ! 1727: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xd4f649e0  ! 1728: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	.word 0xdaa48400  ! 1729: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0xdabe49e0  ! 1730: STDA_R	stda	%r13, [%r25 + %r0] 0x4f
	.word 0xdcb42000  ! 1731: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xdcf4e000  ! 1732: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 1733: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r16
	.word 0xd2b40400  ! 1735: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0xdcb70e40  ! 1736: STHA_R	stha	%r14, [%r28 + %r0] 0x72
	mov	0x3e8, %r20
	mov	0x3c0, %r23
	.word 0xd0cfce60  ! 1739: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r8
	.word 0x87802025  ! 1740: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8f6000  ! 1741: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xdab72000  ! 1742: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xd6870e60  ! 1743: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r11
	.word 0xd6cf8e40  ! 1744: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r11
	mov	0x7e8, %r22
	.word 0x87802025  ! 1746: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 1747: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc9e6000  ! 1748: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r14
	.word 0xdccee000  ! 1749: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r14
	.word 0xdcb689e0  ! 1750: STHA_R	stha	%r14, [%r26 + %r0] 0x4f
	mov	0x8, %r16
	.word 0xdcad04a0  ! 1752: STBA_R	stba	%r14, [%r20 + %r0] 0x25
	.word 0x87802025  ! 1753: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4b70e40  ! 1754: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	.word 0xd2b72000  ! 1755: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 1756: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8d70e40  ! 1757: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r12
	mov	0x70, %r17
	.word 0xd8a72000  ! 1759: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0xdabf4e40  ! 1761: STDA_R	stda	%r13, [%r29 + %r0] 0x72
	.word 0x87802020  ! 1762: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdebc2000  ! 1764: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xde8c2000  ! 1765: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	mov	0x10, %r25
	.word 0xde9c6000  ! 1767: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0xde8ca000  ! 1768: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0xdc874e40  ! 1769: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r14
	.word 0xd29f0e60  ! 1770: LDDA_R	ldda	[%r28, %r0] 0x73, %r9
	.word 0xdabc6000  ! 1771: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	mov	0x78, %r27
	.word 0xd0d74e40  ! 1773: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r8
	.word 0xd48ce000  ! 1774: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r10
	.word 0xd0ac0400  ! 1775: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 1776: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd88cc400  ! 1777: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	.word 0xda8609e0  ! 1778: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r13
	.word 0xdab76000  ! 1779: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 1780: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa4a000  ! 1781: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xdab70e80  ! 1782: STHA_R	stha	%r13, [%r28 + %r0] 0x74
	.word 0xdcf609e0  ! 1783: STXA_R	stxa	%r14, [%r24 + %r0] 0x4f
	.word 0xdad4e000  ! 1784: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r13
	mov	0x10, %r25
	.word 0x87802073  ! 1786: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda8ca000  ! 1787: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r13
	.word 0xdaf46000  ! 1788: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0xdac4e000  ! 1789: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r13
	.word 0x87802072  ! 1790: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa7e000  ! 1791: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 1792: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdac42000  ! 1793: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0xda946000  ! 1794: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	mov	0x38, %r19
	.word 0xd28c4400  ! 1796: LDUBA_R	lduba	[%r17, %r0] 0x20, %r9
	.word 0x8780204f  ! 1797: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde9f4e60  ! 1798: LDDA_R	ldda	[%r29, %r0] 0x73, %r15
	mov	0x0, %r19
	.word 0xd4ade000  ! 1800: STBA_I	stba	%r10, [%r23 + 0x0000] %asi
	mov	0x10, %r19
	.word 0x87802020  ! 1802: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29f0e60  ! 1803: LDDA_R	ldda	[%r28, %r0] 0x73, %r9
	mov	0x68, %r16
	mov	0x38, %r18
	.word 0xd0a689e0  ! 1806: STWA_R	stwa	%r8, [%r26 + %r0] 0x4f
	.word 0xd4a76000  ! 1807: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	mov	0x48, %r27
	.word 0x87802073  ! 1809: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f42000  ! 1810: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 1811: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 1812: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4b46000  ! 1813: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xd4ac6000  ! 1814: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 1815: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4aea000  ! 1816: STBA_I	stba	%r10, [%r26 + 0x0000] %asi
	.word 0xd4a66000  ! 1817: STWA_I	stwa	%r10, [%r25 + 0x0000] %asi
	.word 0xd4a62000  ! 1818: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 1819: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r23
	.word 0x87802020  ! 1821: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48f6000  ! 1822: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xd8c504a0  ! 1823: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r12
	.word 0x87802025  ! 1824: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb4c400  ! 1825: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xd4876000  ! 1826: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xd49f2000  ! 1827: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	mov	0x50, %r24
	.word 0xdad40400  ! 1829: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	mov	0x40, %r18
	.word 0xd69f4e60  ! 1831: LDDA_R	ldda	[%r29, %r0] 0x73, %r11
	.word 0xd6970e80  ! 1832: LDUHA_R	lduha	[%r28, %r0] 0x74, %r11
	mov	0x3f8, %r20
	.word 0xd4af0e80  ! 1834: STBA_R	stba	%r10, [%r28 + %r0] 0x74
	.word 0x87802073  ! 1835: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8ac2000  ! 1836: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0xd8dc2000  ! 1837: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0xd2b6c9e0  ! 1838: STHA_R	stha	%r9, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 1839: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac7a000  ! 1840: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xdec584a0  ! 1841: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r15
	.word 0x87802074  ! 1842: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r18
	mov	0x50, %r18
	.word 0xdc876000  ! 1845: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	mov	0x58, %r24
	.word 0xdccf6000  ! 1847: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0x87802025  ! 1848: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb72000  ! 1849: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 1850: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r26
	mov	0x3c0, %r20
	mov	0x48, %r25
	.word 0xde8c8400  ! 1854: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	.word 0xd0bf4e80  ! 1855: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	.word 0xd0dc6000  ! 1856: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	ta	T_CHANGE_PRIV	! macro
	.word 0xd0bce000  ! 1858: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0xd0afce80  ! 1859: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	.word 0xd0a7ce80  ! 1860: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	.word 0xd6a4e000  ! 1861: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0xd2cec9e0  ! 1862: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r9
	.word 0xd8cc2000  ! 1863: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r12
	.word 0xdaa7ce40  ! 1864: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	.word 0xd0b42000  ! 1865: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xd8b6c9e0  ! 1866: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 1867: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedc6000  ! 1868: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r15
	.word 0xde9ce000  ! 1869: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0x87802073  ! 1870: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 1871: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a70e80  ! 1872: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	.word 0xd6af4e40  ! 1873: STBA_R	stba	%r11, [%r29 + %r0] 0x72
	.word 0xd4a7ce80  ! 1874: STWA_R	stwa	%r10, [%r31 + %r0] 0x74
	.word 0xd88cc400  ! 1875: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	.word 0xdcbe89e0  ! 1876: STDA_R	stda	%r14, [%r26 + %r0] 0x4f
	.word 0xd6872000  ! 1877: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6f76000  ! 1878: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	mov	0x7e0, %r21
	.word 0x87802020  ! 1880: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r23
	.word 0xdaf74e80  ! 1882: STXA_R	stxa	%r13, [%r29 + %r0] 0x74
	.word 0xd0f74e80  ! 1883: STXA_R	stxa	%r8, [%r29 + %r0] 0x74
	.word 0xd4be89e0  ! 1884: STDA_R	stda	%r10, [%r26 + %r0] 0x4f
	.word 0xd0f42000  ! 1885: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	mov	0x7e8, %r22
	mov	0x28, %r24
	.word 0xd0d4a000  ! 1888: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	.word 0xd0dce000  ! 1889: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r8
	.word 0xd0bce000  ! 1890: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 1891: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd09ee000  ! 1893: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r8
	.word 0x87802073  ! 1894: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd09ca000  ! 1895: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	.word 0xd0cc6000  ! 1896: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	.word 0xd084a000  ! 1897: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1898: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcc74e40  ! 1899: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r14
	mov	0x3d8, %r22
	.word 0xdcbd6000  ! 1901: STDA_I	stda	%r14, [%r21 + 0x0000] %asi
	.word 0xdcb689e0  ! 1902: STHA_R	stha	%r14, [%r26 + %r0] 0x4f
	.word 0xd2a78e60  ! 1903: STWA_R	stwa	%r9, [%r30 + %r0] 0x73
	mov	0x7f8, %r21
	.word 0xdeb6c9e0  ! 1905: STHA_R	stha	%r15, [%r27 + %r0] 0x4f
	.word 0xd4f5a000  ! 1906: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	.word 0xd8a4c400  ! 1907: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	mov	0x7d8, %r20
	.word 0xd2d584a0  ! 1909: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r9
	.word 0xdcb5e000  ! 1910: STHA_I	stha	%r14, [%r23 + 0x0000] %asi
	.word 0xd2c689e0  ! 1911: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r9
	.word 0xd6d5c4a0  ! 1912: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r11
	mov	0x3d8, %r21
	mov	0x18, %r24
	mov	0x3e8, %r20
	.word 0xd0840400  ! 1916: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	.word 0xd8ada000  ! 1917: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0xdea544a0  ! 1918: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	.word 0xd4bc0400  ! 1919: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 1920: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f48400  ! 1921: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0xd68f6000  ! 1922: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6f72000  ! 1923: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6cf2000  ! 1924: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0x87802020  ! 1925: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1926: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f74e60  ! 1927: STXA_R	stxa	%r9, [%r29 + %r0] 0x73
	mov	0x7e0, %r23
	mov	0x3f8, %r23
	mov	0x20, %r18
	mov	0x3c0, %r20
	.word 0xdabce000  ! 1932: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0xd28f8e80  ! 1933: LDUBA_R	lduba	[%r30, %r0] 0x74, %r9
	.word 0xdcbca000  ! 1934: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xd2844400  ! 1935: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	.word 0xd6af4e60  ! 1936: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	.word 0xd8f4e000  ! 1937: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	mov	0x3d8, %r21
	mov	0x78, %r27
	.word 0xdef70e60  ! 1940: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	.word 0xd8dc8400  ! 1941: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xdebc2000  ! 1942: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xdea42000  ! 1943: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xd6f70e80  ! 1944: STXA_R	stxa	%r11, [%r28 + %r0] 0x74
	.word 0xd88c0400  ! 1945: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	.word 0x8780204f  ! 1946: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c8, %r21
	mov	0x20, %r25
	.word 0xd0af6000  ! 1949: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd2dd44a0  ! 1950: LDXA_R	ldxa	[%r21, %r0] 0x25, %r9
	.word 0xdcccc400  ! 1951: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	.word 0xd4a76000  ! 1952: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd28504a0  ! 1953: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r9
	mov	0x8, %r26
	mov	0x58, %r18
	.word 0x87802074  ! 1956: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc8689e0  ! 1957: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r14
	.word 0x87802020  ! 1958: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f4a000  ! 1959: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 1960: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6bfce40  ! 1961: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	mov	0x7f8, %r20
	mov	0x60, %r25
	.word 0x87802020  ! 1964: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f76000  ! 1965: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6cf6000  ! 1966: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0x87802073  ! 1967: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 1968: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b76000  ! 1969: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd6b72000  ! 1970: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0xdef44400  ! 1972: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xdcdfa000  ! 1973: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	.word 0xdccf6000  ! 1974: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xd2af8e80  ! 1975: STBA_R	stba	%r9, [%r30 + %r0] 0x74
	.word 0xdcdf6000  ! 1976: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	mov	0x48, %r25
	mov	0x58, %r27
	.word 0xdcc72000  ! 1979: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xdca76000  ! 1980: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xd49d84a0  ! 1981: LDDA_R	ldda	[%r22, %r0] 0x25, %r10
	.word 0x87802074  ! 1982: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0c70e40  ! 1983: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r8
	.word 0x8780204f  ! 1984: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r27
	mov	0x48, %r27
	.word 0xd8ccc400  ! 1987: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r12
	.word 0x87802072  ! 1988: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1989: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1990: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 1991: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b7a000  ! 1992: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xd2f6c9e0  ! 1993: STXA_R	stxa	%r9, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 1994: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8be49e0  ! 1995: STDA_R	stda	%r12, [%r25 + %r0] 0x4f
	.word 0xd0ae89e0  ! 1996: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	.word 0xd6f6e000  ! 1997: STXA_I	stxa	%r11, [%r27 + 0x0000] %asi
	.word 0xd0f609e0  ! 1998: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	.word 0xdca6c9e0  ! 1999: STWA_R	stwa	%r14, [%r27 + %r0] 0x4f
	.word 0xdea6e000  ! 2000: STWA_I	stwa	%r15, [%r27 + 0x0000] %asi
	.word 0xdea6e000  ! 2001: STWA_I	stwa	%r15, [%r27 + 0x0000] %asi
	.word 0x87802074  ! 2002: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde8c6000  ! 2003: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0xdef4e000  ! 2004: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xd2de49e0  ! 2005: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r9
	.word 0xd0c40400  ! 2006: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	.word 0xdec4e000  ! 2007: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	.word 0xdec42000  ! 2008: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0xd0cf0e40  ! 2009: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r8
	.word 0xd0f42000  ! 2010: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0xd084e000  ! 2011: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	mov	0x68, %r18
	.word 0x87802020  ! 2013: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdacf4e80  ! 2014: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r13
	.word 0x87802072  ! 2015: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2016: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c4c400  ! 2017: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r12
	mov	0x18, %r16
	.word 0xd0972000  ! 2019: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0f7e000  ! 2020: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	mov	0x58, %r17
	.word 0x87802072  ! 2022: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b46000  ! 2023: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0xdaa5c4a0  ! 2024: STWA_R	stwa	%r13, [%r23 + %r0] 0x25
	.word 0xdabca000  ! 2025: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	mov	0x68, %r25
	.word 0xdaaca000  ! 2027: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 2028: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b78e60  ! 2029: STHA_R	stha	%r11, [%r30 + %r0] 0x73
	.word 0xd0ce6000  ! 2030: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r8
	.word 0xd0862000  ! 2031: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r8
	.word 0xdeae09e0  ! 2032: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	mov	0x48, %r17
	.word 0xdad74e40  ! 2034: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r13
	.word 0xd0af8e40  ! 2035: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0xd4cd04a0  ! 2036: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r10
	.word 0x87802020  ! 2037: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbfa000  ! 2038: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xd8ae49e0  ! 2039: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	mov	0x7d0, %r23
	.word 0x8780204f  ! 2041: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 2042: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf4e000  ! 2043: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 2044: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r16
	.word 0xd29c4400  ! 2046: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	.word 0xdac70e80  ! 2047: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r13
	.word 0xdcac8400  ! 2048: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	mov	0x48, %r17
	.word 0xd6a76000  ! 2050: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6d72000  ! 2051: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r11
	.word 0xd6d7a000  ! 2052: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	.word 0xd6f76000  ! 2053: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6af6000  ! 2054: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 2055: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6de2000  ! 2056: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2057: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b52000  ! 2058: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	mov	0x50, %r18
	.word 0xdc9f0e80  ! 2060: LDDA_R	ldda	[%r28, %r0] 0x74, %r14
	.word 0xd09fce60  ! 2061: LDDA_R	ldda	[%r31, %r0] 0x73, %r8
	.word 0xdc952000  ! 2062: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r14
	.word 0xdc856000  ! 2063: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r14
	.word 0xd0dd44a0  ! 2064: LDXA_R	ldxa	[%r21, %r0] 0x25, %r8
	.word 0xdea70e60  ! 2065: STWA_R	stwa	%r15, [%r28 + %r0] 0x73
	mov	0x68, %r26
	mov	0x30, %r18
	.word 0xdeb4c400  ! 2068: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xdcc56000  ! 2069: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r14
	.word 0xdcbd2000  ! 2070: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	.word 0xdccda000  ! 2071: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r14
	.word 0xd4af8e60  ! 2072: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	.word 0xdad56000  ! 2073: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2074: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf7e000  ! 2075: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xdcc40400  ! 2076: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	.word 0x87802074  ! 2077: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b48400  ! 2078: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xde9c2000  ! 2079: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xde8ca000  ! 2080: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0xde8c6000  ! 2081: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0xd49f8e80  ! 2082: LDDA_R	ldda	[%r30, %r0] 0x74, %r10
	.word 0xda9c6000  ! 2083: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	mov	0x38, %r19
	.word 0xd0dc0400  ! 2085: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xd09c8400  ! 2086: LDDA_R	ldda	[%r18, %r0] 0x20, %r8
	.word 0x87802025  ! 2087: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf7e000  ! 2088: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x3f0, %r21
	mov	0x50, %r16
	.word 0xd0d74e40  ! 2091: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r8
	.word 0xd4f7a000  ! 2092: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xdccc4400  ! 2093: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r14
	.word 0xd48e89e0  ! 2094: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r10
	.word 0xdc8dc4a0  ! 2095: LDUBA_R	lduba	[%r23, %r0] 0x25, %r14
	mov	0x3c8, %r22
	mov	0x10, %r17
	mov	0x68, %r19
	.word 0xdabf6000  ! 2099: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xdacfa000  ! 2100: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0x87802025  ! 2101: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 2102: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2103: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r23
	.word 0xd2af0e40  ! 2105: STBA_R	stba	%r9, [%r28 + %r0] 0x72
	mov	0x48, %r17
	mov	0x10, %r16
	.word 0xd0f544a0  ! 2108: STXA_R	stxa	%r8, [%r21 + %r0] 0x25
	.word 0xd0cfa000  ! 2109: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0xd0afe000  ! 2110: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xd4d44400  ! 2112: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	mov	0x68, %r19
	.word 0xde87e000  ! 2114: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xd8df8e80  ! 2115: LDXA_R	ldxa	[%r30, %r0] 0x74, %r12
	.word 0xdac72000  ! 2116: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0xda976000  ! 2117: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	mov	0x3c0, %r23
	.word 0xda9f2000  ! 2119: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0x87802025  ! 2120: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r25
	.word 0xd4f44400  ! 2122: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0xd6a7a000  ! 2123: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xd6bf2000  ! 2125: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd8be09e0  ! 2126: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	.word 0x87802072  ! 2127: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 2128: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc9fe000  ! 2129: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	mov	0x18, %r27
	.word 0xdac70e40  ! 2131: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r13
	.word 0xd48f6000  ! 2132: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	mov	0x7e0, %r21
	.word 0xdcb504a0  ! 2134: STHA_R	stha	%r14, [%r20 + %r0] 0x25
	.word 0xd4f76000  ! 2135: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xdab70e40  ! 2136: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	.word 0xd2f72000  ! 2137: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd2cfe000  ! 2138: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	.word 0x87802072  ! 2139: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2140: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a7ce80  ! 2141: STWA_R	stwa	%r11, [%r31 + %r0] 0x74
	.word 0xd0dc4400  ! 2142: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	mov	0x3e0, %r20
	.word 0x8780204f  ! 2144: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde87a000  ! 2145: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xd0b5c4a0  ! 2146: STHA_R	stha	%r8, [%r23 + %r0] 0x25
	.word 0xd6d7a000  ! 2147: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	mov	0x38, %r27
	mov	0x78, %r26
	.word 0xd6872000  ! 2150: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	mov	0x3c8, %r23
	mov	0x20, %r27
	mov	0x3f8, %r21
	mov	0x3e8, %r20
	mov	0x7c8, %r20
	.word 0xdccd44a0  ! 2156: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r14
	.word 0xdad7a000  ! 2157: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0xd08584a0  ! 2158: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r8
	mov	0x7f0, %r21
	.word 0xd8bf6000  ! 2160: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xdeb649e0  ! 2161: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	.word 0xd2afce40  ! 2162: STBA_R	stba	%r9, [%r31 + %r0] 0x72
	.word 0xd8f7ce80  ! 2163: STXA_R	stxa	%r12, [%r31 + %r0] 0x74
	mov	0x7c0, %r20
	.word 0x87802020  ! 2165: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r21
	.word 0x87802020  ! 2167: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9f2000  ! 2168: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	mov	0x38, %r19
	.word 0xdaf7e000  ! 2170: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xdaf72000  ! 2172: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xd4bf8e80  ! 2173: STDA_R	stda	%r10, [%r30 + %r0] 0x74
	.word 0x87802074  ! 2174: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda9ee000  ! 2175: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r13
	mov	0x7c0, %r22
	.word 0xd6f6c9e0  ! 2177: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	mov	0x7d0, %r21
	.word 0xd8ae6000  ! 2179: STBA_I	stba	%r12, [%r25 + 0x0000] %asi
	mov	0x40, %r27
	.word 0xdec40400  ! 2181: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0x87802074  ! 2182: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e0, %r22
	.word 0xdaac0400  ! 2184: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xd6ce2000  ! 2185: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	mov	0x60, %r19
	mov	0x7e0, %r20
	mov	0x0, %r16
	.word 0xda9609e0  ! 2189: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r13
	mov	0x58, %r17
	.word 0xdcd78e40  ! 2191: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r14
	.word 0xd8a78e60  ! 2192: STWA_R	stwa	%r12, [%r30 + %r0] 0x73
	.word 0xd48649e0  ! 2193: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r10
	.word 0xd0978e60  ! 2194: LDUHA_R	lduha	[%r30, %r0] 0x73, %r8
	.word 0xd0bfce60  ! 2195: STDA_R	stda	%r8, [%r31 + %r0] 0x73
	mov	0x7c8, %r23
	mov	0x38, %r18
	.word 0xdaa6e000  ! 2198: STWA_I	stwa	%r13, [%r27 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0xd2ccc400  ! 2200: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	.word 0x87802073  ! 2201: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0d44400  ! 2202: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r8
	.word 0x8780204f  ! 2203: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r24
	mov	0x10, %r27
	mov	0x10, %r16
	.word 0xdcbfce80  ! 2207: STDA_R	stda	%r14, [%r31 + %r0] 0x74
	mov	0x7f8, %r23
	.word 0x87802072  ! 2209: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 2210: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcc4c400  ! 2211: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	.word 0xd4ad04a0  ! 2212: STBA_R	stba	%r10, [%r20 + %r0] 0x25
	.word 0xd2a7e000  ! 2213: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xdeb48400  ! 2214: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0x87802020  ! 2215: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r26
	mov	0x20, %r27
	.word 0x87802025  ! 2218: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2219: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeafe000  ! 2220: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xdca649e0  ! 2221: STWA_R	stwa	%r14, [%r25 + %r0] 0x4f
	mov	0x0, %r25
	.word 0xd88f6000  ! 2223: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	mov	0x28, %r19
	.word 0xd8976000  ! 2225: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0x87802074  ! 2226: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r26
	mov	0x60, %r24
	.word 0xdef44400  ! 2229: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	mov	0x18, %r18
	.word 0x87802073  ! 2231: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a7a000  ! 2232: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd2b649e0  ! 2233: STHA_R	stha	%r9, [%r25 + %r0] 0x4f
	.word 0xd4b7e000  ! 2234: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	mov	0x7e0, %r20
	.word 0xd4bf2000  ! 2236: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 2237: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 2238: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4cc4400  ! 2239: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r10
	.word 0xdcbf2000  ! 2240: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdccf2000  ! 2241: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0x87802074  ! 2242: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc840400  ! 2243: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	mov	0x38, %r18
	.word 0x87802073  ! 2245: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2246: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r18
	.word 0xdebf0e40  ! 2248: STDA_R	stda	%r15, [%r28 + %r0] 0x72
	mov	0x3e8, %r23
	.word 0xd68e89e0  ! 2250: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r11
	mov	0x3f8, %r21
	.word 0x87802020  ! 2252: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4dc8400  ! 2253: LDXA_R	ldxa	[%r18, %r0] 0x20, %r10
	.word 0xdcde49e0  ! 2254: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r14
	.word 0xdabe09e0  ! 2255: STDA_R	stda	%r13, [%r24 + %r0] 0x4f
	mov	0x10, %r25
	.word 0xd2b62000  ! 2257: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	.word 0xd2b6a000  ! 2258: STHA_I	stha	%r9, [%r26 + 0x0000] %asi
	mov	0x3c0, %r20
	.word 0xd2cee000  ! 2260: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	.word 0xd2c62000  ! 2261: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r9
	mov	0x10, %r25
	.word 0xd2b62000  ! 2263: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	.word 0xde95c4a0  ! 2264: LDUHA_R	lduha	[%r23, %r0] 0x25, %r15
	.word 0xdcb62000  ! 2265: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	.word 0xdcc6e000  ! 2266: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r14
	.word 0xdcd609e0  ! 2267: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r14
	.word 0x87802072  ! 2268: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdad649e0  ! 2269: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r13
	mov	0x28, %r19
	.word 0xdacce000  ! 2271: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r13
	.word 0xd0acc400  ! 2272: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	mov	0x7e0, %r21
	.word 0xd0ace000  ! 2274: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0xd0b4a000  ! 2275: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xd08ce000  ! 2276: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	mov	0x7f0, %r21
	.word 0x8780204f  ! 2278: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2279: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0852000  ! 2280: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r8
	.word 0xd0a5e000  ! 2281: STWA_I	stwa	%r8, [%r23 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xd08d2000  ! 2283: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r8
	mov	0x3d0, %r23
	.word 0xd28f4e40  ! 2285: LDUBA_R	lduba	[%r29, %r0] 0x72, %r9
	.word 0xdca56000  ! 2286: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	.word 0xdc8d2000  ! 2287: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r14
	.word 0xd6f609e0  ! 2288: STXA_R	stxa	%r11, [%r24 + %r0] 0x4f
	mov	0x18, %r26
	mov	0x78, %r24
	mov	0x38, %r19
	.word 0xd4878e40  ! 2292: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r10
	.word 0xdcbc4400  ! 2293: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0xdad78e80  ! 2294: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r13
	.word 0xd28f8e60  ! 2295: LDUBA_R	lduba	[%r30, %r0] 0x73, %r9
	.word 0x8780204f  ! 2296: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdab4c400  ! 2297: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	mov	0x3f8, %r20
	.word 0xd0974e40  ! 2299: LDUHA_R	lduha	[%r29, %r0] 0x72, %r8
	mov	0x28, %r26
	.word 0xd2f44400  ! 2301: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	.word 0xd6a7a000  ! 2302: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6bc4400  ! 2303: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	.word 0xdef44400  ! 2304: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xd8c78e40  ! 2305: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r12
	.word 0xd8c70e60  ! 2306: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r12
	mov	0x7e0, %r21
	.word 0xdccec9e0  ! 2308: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r14
	.word 0xdccfce40  ! 2309: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r14
	.word 0x87802072  ! 2310: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f40400  ! 2311: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xdcccc400  ! 2312: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	mov	0x7d8, %r21
	.word 0xda9ea000  ! 2314: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r13
	.word 0xdc944400  ! 2315: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	.word 0x87802020  ! 2316: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd285c4a0  ! 2317: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r9
	mov	0x78, %r19
	mov	0x3f8, %r22
	.word 0xdaaf6000  ! 2320: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xd0ac4400  ! 2321: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0xd6af4e80  ! 2322: STBA_R	stba	%r11, [%r29 + %r0] 0x74
	.word 0xdaafe000  ! 2323: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xdaf76000  ! 2324: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdaaf6000  ! 2325: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xd2ce49e0  ! 2326: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r9
	mov	0x70, %r26
	.word 0xdab76000  ! 2328: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	mov	0x40, %r25
	.word 0x8780204f  ! 2330: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 2331: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde9ec9e0  ! 2332: LDDA_R	ldda	[%r27, %r0] 0x4f, %r15
	.word 0xd69649e0  ! 2333: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r11
	.word 0xd4dfe000  ! 2334: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802072  ! 2335: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r16
	.word 0xd2978e60  ! 2337: LDUHA_R	lduha	[%r30, %r0] 0x73, %r9
	.word 0xdc9f4e60  ! 2338: LDDA_R	ldda	[%r29, %r0] 0x73, %r14
	.word 0xded42000  ! 2339: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	.word 0xdc8649e0  ! 2340: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r14
	.word 0xdc974e40  ! 2341: LDUHA_R	lduha	[%r29, %r0] 0x72, %r14
	mov	0x60, %r19
	mov	0x60, %r17
	.word 0xd8af4e40  ! 2344: STBA_R	stba	%r12, [%r29 + %r0] 0x72
	.word 0xdcb46000  ! 2345: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xd0b74e60  ! 2346: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	.word 0xd6d70e40  ! 2347: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r11
	.word 0xd0a689e0  ! 2348: STWA_R	stwa	%r8, [%r26 + %r0] 0x4f
	.word 0xd09f4e80  ! 2349: LDDA_R	ldda	[%r29, %r0] 0x74, %r8
	.word 0xd4bfce60  ! 2350: STDA_R	stda	%r10, [%r31 + %r0] 0x73
	mov	0x7f0, %r21
	mov	0x18, %r26
	.word 0xdac48400  ! 2353: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	.word 0xde84c400  ! 2354: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	mov	0x3e8, %r20
	.word 0xdeac6000  ! 2356: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xd0874e80  ! 2357: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r8
	mov	0x40, %r18
	mov	0x40, %r25
	mov	0x3c0, %r20
	.word 0xdaa48400  ! 2361: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	mov	0x7c8, %r22
	mov	0x3d0, %r23
	.word 0xdcaf8e80  ! 2364: STBA_R	stba	%r14, [%r30 + %r0] 0x74
	mov	0x0, %r25
	.word 0x87802020  ! 2366: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf44400  ! 2367: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	mov	0x48, %r25
	.word 0xd0b78e60  ! 2369: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	.word 0xd0940400  ! 2370: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	mov	0x7d8, %r20
	mov	0x68, %r26
	mov	0x38, %r16
	.word 0xd2bea000  ! 2374: STDA_I	stda	%r9, [%r26 + 0x0000] %asi
	.word 0xda874e80  ! 2375: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r13
	.word 0x87802020  ! 2376: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r25
	.word 0xdebd44a0  ! 2378: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	.word 0xd0f70e60  ! 2379: STXA_R	stxa	%r8, [%r28 + %r0] 0x73
	.word 0xd2c46000  ! 2380: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	mov	0x10, %r25
	mov	0x7f8, %r21
	.word 0x8780204f  ! 2383: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 2384: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a609e0  ! 2385: STWA_R	stwa	%r9, [%r24 + %r0] 0x4f
	.word 0xd497ce40  ! 2386: LDUHA_R	lduha	[%r31, %r0] 0x72, %r10
	.word 0xdc9e89e0  ! 2387: LDDA_R	ldda	[%r26, %r0] 0x4f, %r14
	.word 0x87802020  ! 2388: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8c4400  ! 2389: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	.word 0xd2c40400  ! 2390: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r9
	.word 0xde97e000  ! 2391: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0xdea76000  ! 2392: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xded7a000  ! 2393: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xd0f70e60  ! 2394: STXA_R	stxa	%r8, [%r28 + %r0] 0x73
	.word 0xd8afa000  ! 2395: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xd88f2000  ! 2396: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0xd0f40400  ! 2397: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xd4f72000  ! 2398: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4bf6000  ! 2399: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd497e000  ! 2400: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	mov	0x7e8, %r23
	.word 0xd4d7a000  ! 2402: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	mov	0x0, %r18
	mov	0x7f8, %r22
	mov	0x3c8, %r22
	.word 0xd497a000  ! 2406: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	mov	0x60, %r26
	.word 0xdaa44400  ! 2408: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0xd4bf0e80  ! 2409: STDA_R	stda	%r10, [%r28 + %r0] 0x74
	.word 0xd08ec9e0  ! 2410: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r8
	.word 0xd6cf4e60  ! 2411: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r11
	mov	0x20, %r17
	.word 0xdaf7a000  ! 2413: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdaa72000  ! 2414: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xdac7e000  ! 2415: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0x87802073  ! 2416: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa76000  ! 2417: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 2418: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7e0, %r22
	.word 0xdad6e000  ! 2420: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r13
	.word 0xdebfce80  ! 2421: STDA_R	stda	%r15, [%r31 + %r0] 0x74
	mov	0x18, %r18
	.word 0xd8944400  ! 2423: LDUHA_R	lduha	[%r17, %r0] 0x20, %r12
	.word 0xdabe6000  ! 2424: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xdaa6e000  ! 2426: STWA_I	stwa	%r13, [%r27 + 0x0000] %asi
	.word 0xdadee000  ! 2427: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r13
	.word 0xdabee000  ! 2428: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0xdab6e000  ! 2430: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	mov	0x70, %r16
	.word 0xdac66000  ! 2432: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r13
	mov	0x3e0, %r23
	.word 0x87802073  ! 2434: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r24
	.word 0xdac7a000  ! 2436: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xd0d74e60  ! 2437: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r8
	.word 0xdc8f8e60  ! 2438: LDUBA_R	lduba	[%r30, %r0] 0x73, %r14
	mov	0x50, %r18
	mov	0x70, %r26
	.word 0xd8df6000  ! 2441: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	mov	0x7e8, %r20
	.word 0xd0844400  ! 2443: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r8
	mov	0x60, %r27
	.word 0x87802020  ! 2445: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2aca000  ! 2446: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 2447: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2b46000  ! 2449: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x7d0, %r23
	mov	0x3f8, %r20
	.word 0xd8af4e40  ! 2453: STBA_R	stba	%r12, [%r29 + %r0] 0x72
	.word 0xd0d46000  ! 2454: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r8
	.word 0xdcad84a0  ! 2455: STBA_R	stba	%r14, [%r22 + %r0] 0x25
	mov	0x7c0, %r20
	.word 0xd6a48400  ! 2457: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	mov	0x28, %r24
	.word 0xdadce000  ! 2459: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xdacc6000  ! 2460: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 2461: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2af0e80  ! 2462: STBA_R	stba	%r9, [%r28 + %r0] 0x74
	.word 0xd8af0e40  ! 2463: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	.word 0x87802073  ! 2464: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r18
	.word 0x87802072  ! 2466: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2467: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ac8400  ! 2468: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xdacfce40  ! 2469: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r13
	mov	0x28, %r26
	.word 0xd0bd44a0  ! 2471: STDA_R	stda	%r8, [%r21 + %r0] 0x25
	.word 0xd8972000  ! 2472: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	.word 0xd8972000  ! 2473: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	.word 0x87802072  ! 2474: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda840400  ! 2475: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	.word 0xd085a000  ! 2476: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r8
	mov	0x3d8, %r21
	.word 0xd0b7ce40  ! 2478: STHA_R	stha	%r8, [%r31 + %r0] 0x72
	.word 0xd0d44400  ! 2479: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r8
	.word 0xdad70e80  ! 2480: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r13
	.word 0x8780204f  ! 2481: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f8, %r21
	.word 0xdcafce60  ! 2483: STBA_R	stba	%r14, [%r31 + %r0] 0x73
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2d4c400  ! 2485: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r9
	.word 0xd2a7a000  ! 2486: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	mov	0x10, %r18
	.word 0x87802072  ! 2488: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f7a000  ! 2489: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xd2df2000  ! 2490: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd0c70e80  ! 2491: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r8
	mov	0x58, %r26
	.word 0xda9f2000  ! 2493: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xd89e09e0  ! 2494: LDDA_R	ldda	[%r24, %r0] 0x4f, %r12
	mov	0x48, %r19
	.word 0x87802073  ! 2496: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef584a0  ! 2497: STXA_R	stxa	%r15, [%r22 + %r0] 0x25
	mov	0x7d0, %r23
	.word 0xd4cf8e60  ! 2499: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r10
	mov	0x78, %r25
	.word 0xdabfa000  ! 2501: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdaf72000  ! 2502: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdaa72000  ! 2503: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	mov	0x40, %r25
	.word 0xdc9e89e0  ! 2505: LDDA_R	ldda	[%r26, %r0] 0x4f, %r14
	.word 0xd0a72000  ! 2506: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xd4bd44a0  ! 2507: STDA_R	stda	%r10, [%r21 + %r0] 0x25
	.word 0xd8a6c9e0  ! 2508: STWA_R	stwa	%r12, [%r27 + %r0] 0x4f
	.word 0x87802025  ! 2509: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2510: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2511: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd4840400  ! 2513: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	mov	0x68, %r26
	.word 0xd4f5a000  ! 2515: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	mov	0x60, %r18
	mov	0x18, %r26
	.word 0xd4d5a000  ! 2518: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r10
	mov	0x3c0, %r20
	.word 0xd4d74e80  ! 2520: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r10
	mov	0x40, %r18
	.word 0xdcf56000  ! 2522: STXA_I	stxa	%r14, [%r21 + 0x0000] %asi
	.word 0xdca56000  ! 2523: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	.word 0x87802072  ! 2524: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29649e0  ! 2525: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r9
	.word 0xde870e60  ! 2526: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r15
	.word 0xd68f4e80  ! 2527: LDUBA_R	lduba	[%r29, %r0] 0x74, %r11
	.word 0xd2df4e40  ! 2528: LDXA_R	ldxa	[%r29, %r0] 0x72, %r9
	.word 0xdc97a000  ! 2529: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	.word 0xdcdfa000  ! 2530: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	mov	0x48, %r24
	.word 0xdccfe000  ! 2532: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	mov	0x7f0, %r22
	.word 0xdc8fa000  ! 2534: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdabc8400  ! 2535: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	.word 0xdaaf8e40  ! 2536: STBA_R	stba	%r13, [%r30 + %r0] 0x72
	.word 0x87802072  ! 2537: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r24
	.word 0xdc8609e0  ! 2539: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r14
	.word 0xd89e89e0  ! 2540: LDDA_R	ldda	[%r26, %r0] 0x4f, %r12
	.word 0xd69e89e0  ! 2541: LDDA_R	ldda	[%r26, %r0] 0x4f, %r11
	.word 0x8780204f  ! 2542: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c0, %r22
	.word 0xdcd72000  ! 2544: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xd29f0e40  ! 2545: LDDA_R	ldda	[%r28, %r0] 0x72, %r9
	mov	0x7e0, %r20
	.word 0xd0bf2000  ! 2547: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xd0bfa000  ! 2548: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0xd0cfce80  ! 2549: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r8
	.word 0xda976000  ! 2550: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	mov	0x50, %r16
	.word 0xdadfe000  ! 2552: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	mov	0x3f0, %r20
	mov	0x30, %r25
	.word 0xdaf7a000  ! 2555: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	mov	0x40, %r17
	.word 0x87802072  ! 2557: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf4e000  ! 2558: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xda84a000  ! 2559: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	mov	0x7f8, %r23
	.word 0xdaf4a000  ! 2561: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0xdad4e000  ! 2562: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r13
	.word 0xd4b44400  ! 2563: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	.word 0x87802020  ! 2564: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccc8400  ! 2565: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	.word 0xdabda000  ! 2566: STDA_I	stda	%r13, [%r22 + 0x0000] %asi
	.word 0xdaad6000  ! 2567: STBA_I	stba	%r13, [%r21 + 0x0000] %asi
	.word 0xdaf52000  ! 2568: STXA_I	stxa	%r13, [%r20 + 0x0000] %asi
	.word 0xdab5e000  ! 2569: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0xdccf4e80  ! 2570: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r14
	.word 0xd0a44400  ! 2571: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	mov	0x7e8, %r21
	.word 0x87802074  ! 2573: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f6c9e0  ! 2574: STXA_R	stxa	%r9, [%r27 + %r0] 0x4f
	mov	0x28, %r17
	.word 0xd48f8e80  ! 2576: LDUBA_R	lduba	[%r30, %r0] 0x74, %r10
	mov	0x3e0, %r20
	.word 0xd08ca000  ! 2578: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0x87802073  ! 2579: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0cf6000  ! 2580: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xdecf0e80  ! 2581: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r15
	.word 0xd28cc400  ! 2582: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	.word 0xdc974e60  ! 2583: LDUHA_R	lduha	[%r29, %r0] 0x73, %r14
	.word 0xd69c0400  ! 2584: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	mov	0x40, %r24
	.word 0xda9e89e0  ! 2586: LDDA_R	ldda	[%r26, %r0] 0x4f, %r13
	.word 0x87802073  ! 2587: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd09d44a0  ! 2588: LDDA_R	ldda	[%r21, %r0] 0x25, %r8
	.word 0xd2f72000  ! 2589: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 2590: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde9649e0  ! 2591: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r15
	.word 0xd8cfe000  ! 2592: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xdcaf0e60  ! 2593: STBA_R	stba	%r14, [%r28 + %r0] 0x73
	.word 0xd09fa000  ! 2594: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	.word 0x87802020  ! 2595: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r18
	mov	0x3c0, %r22
	.word 0xd09f6000  ! 2598: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	mov	0x48, %r27
	mov	0x60, %r27
	.word 0x87802072  ! 2601: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b76000  ! 2602: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 2603: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b78e60  ! 2604: STHA_R	stha	%r11, [%r30 + %r0] 0x73
	mov	0x3f8, %r23
	.word 0xd0940400  ! 2606: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	.word 0xd2852000  ! 2607: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r9
	.word 0xd4cec9e0  ! 2608: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r10
	.word 0xda970e80  ! 2609: LDUHA_R	lduha	[%r28, %r0] 0x74, %r13
	mov	0x7c0, %r23
	.word 0xd68f4e80  ! 2611: LDUBA_R	lduba	[%r29, %r0] 0x74, %r11
	.word 0xd6d56000  ! 2612: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r11
	.word 0xd6a52000  ! 2613: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	.word 0xdeb48400  ! 2614: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xdaf5e000  ! 2615: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0xd6b70e80  ! 2616: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	.word 0x87802025  ! 2617: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6bf8e60  ! 2618: STDA_R	stda	%r11, [%r30 + %r0] 0x73
	.word 0xdccfce60  ! 2619: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r14
	.word 0xdca689e0  ! 2620: STWA_R	stwa	%r14, [%r26 + %r0] 0x4f
	.word 0xd4c4c400  ! 2621: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r10
	.word 0xdebc4400  ! 2622: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	mov	0x40, %r19
	.word 0xd4b4c400  ! 2624: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0xd6846000  ! 2625: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r11
	.word 0xd6b42000  ! 2626: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0xd6f544a0  ! 2627: STXA_R	stxa	%r11, [%r21 + %r0] 0x25
	mov	0x7d8, %r20
	.word 0x87802020  ! 2629: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb76000  ! 2630: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xdc976000  ! 2631: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	.word 0xdaaf4e40  ! 2632: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x18, %r16
	.word 0xdecfce60  ! 2635: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r15
	mov	0x20, %r16
	.word 0xd0a72000  ! 2637: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x7f0, %r22
	.word 0xd0b72000  ! 2639: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 2640: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r16
	.word 0x87802074  ! 2642: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa48400  ! 2643: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0xd2d7e000  ! 2644: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2645: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2646: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdab78e40  ! 2647: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	.word 0x87802020  ! 2648: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2649: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r16
	.word 0x8780204f  ! 2651: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f0, %r22
	.word 0x87802073  ! 2653: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf46000  ! 2654: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0xda844400  ! 2655: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r13
	.word 0x87802074  ! 2656: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0c5c4a0  ! 2657: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r8
	.word 0xd4cc8400  ! 2658: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	.word 0xda8c2000  ! 2659: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r13
	.word 0xda9c6000  ! 2660: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	mov	0x48, %r19
	.word 0xdad42000  ! 2662: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r13
	.word 0xdecf4e40  ! 2663: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r15
	.word 0x87802072  ! 2664: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4bd04a0  ! 2665: STDA_R	stda	%r10, [%r20 + %r0] 0x25
	.word 0xd6af6000  ! 2666: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 2667: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r18
	.word 0xd6f584a0  ! 2669: STXA_R	stxa	%r11, [%r22 + %r0] 0x25
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x70, %r17
	.word 0xd2bf2000  ! 2672: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	mov	0x30, %r25
	.word 0xd2b72000  ! 2674: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd2b76000  ! 2675: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xd4be09e0  ! 2677: STDA_R	stda	%r10, [%r24 + %r0] 0x4f
	mov	0x10, %r26
	.word 0xdeac0400  ! 2679: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 2680: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6af6000  ! 2681: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xdcf689e0  ! 2682: STXA_R	stxa	%r14, [%r26 + %r0] 0x4f
	.word 0xd48fe000  ! 2683: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xd2ac8400  ! 2684: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xdaae89e0  ! 2685: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	.word 0xd697e000  ! 2686: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0xd09e09e0  ! 2687: LDDA_R	ldda	[%r24, %r0] 0x4f, %r8
	.word 0xd4ccc400  ! 2688: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0x87802025  ! 2689: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 2690: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbf8e40  ! 2691: STDA_R	stda	%r14, [%r30 + %r0] 0x72
	.word 0xd8bce000  ! 2692: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xdaaf4e80  ! 2693: STBA_R	stba	%r13, [%r29 + %r0] 0x74
	.word 0xdcbce000  ! 2694: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	mov	0x7f0, %r22
	.word 0xdcbca000  ! 2696: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 2697: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r26
	.word 0xd2a78e80  ! 2699: STWA_R	stwa	%r9, [%r30 + %r0] 0x74
	.word 0xd8cf2000  ! 2700: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2701: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8be2000  ! 2702: STDA_I	stda	%r12, [%r24 + 0x0000] %asi
	.word 0xdabfce40  ! 2703: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	.word 0xd48c8400  ! 2704: LDUBA_R	lduba	[%r18, %r0] 0x20, %r10
	.word 0x87802073  ! 2705: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r25
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd4de6000  ! 2708: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r10
	mov	0x10, %r19
	.word 0xd68f4e80  ! 2710: LDUBA_R	lduba	[%r29, %r0] 0x74, %r11
	.word 0xd8ad84a0  ! 2711: STBA_R	stba	%r12, [%r22 + %r0] 0x25
	.word 0xdca5c4a0  ! 2712: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	.word 0xd8bee000  ! 2713: STDA_I	stda	%r12, [%r27 + 0x0000] %asi
	.word 0xded7ce80  ! 2714: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r15
	.word 0x8780204f  ! 2715: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2716: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad4a000  ! 2717: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0xd4ae09e0  ! 2718: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0xd0946000  ! 2719: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0xd094e000  ! 2720: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0x87802020  ! 2721: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f48400  ! 2722: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	mov	0x28, %r16
	mov	0x28, %r19
	mov	0x30, %r19
	.word 0xda85a000  ! 2726: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r13
	.word 0xd49d44a0  ! 2727: LDDA_R	ldda	[%r21, %r0] 0x25, %r10
	.word 0x87802020  ! 2728: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9fce40  ! 2729: LDDA_R	ldda	[%r31, %r0] 0x72, %r15
	.word 0xd2dcc400  ! 2730: LDXA_R	ldxa	[%r19, %r0] 0x20, %r9
	.word 0x87802025  ! 2731: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2a70e40  ! 2732: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdecd44a0  ! 2734: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r15
	.word 0xd08fa000  ! 2735: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0xdaacc400  ! 2736: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0x87802072  ! 2737: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a42000  ! 2738: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8d42000  ! 2739: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2740: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49544a0  ! 2741: LDUHA_R	lduha	[%r21, %r0] 0x25, %r10
	.word 0xde95a000  ! 2742: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r15
	.word 0xdac609e0  ! 2743: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r13
	.word 0xd0ac8400  ! 2744: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0x87802074  ! 2745: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6af6000  ! 2746: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x50, %r19
	.word 0x87802020  ! 2748: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28544a0  ! 2749: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r9
	.word 0x87802025  ! 2750: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8a584a0  ! 2751: STWA_R	stwa	%r12, [%r22 + %r0] 0x25
	.word 0xd28f4e80  ! 2752: LDUBA_R	lduba	[%r29, %r0] 0x74, %r9
	.word 0xd0aec9e0  ! 2753: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	.word 0xd6bf2000  ! 2754: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xdea7ce40  ! 2755: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	.word 0xd09f2000  ! 2756: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0xd0876000  ! 2757: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	.word 0xd28c4400  ! 2758: LDUBA_R	lduba	[%r17, %r0] 0x20, %r9
	mov	0x40, %r18
	.word 0xd2ac4400  ! 2760: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0x87802020  ! 2761: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r27
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd4bec9e0  ! 2764: STDA_R	stda	%r10, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 2765: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d0, %r21
	.word 0xd69fe000  ! 2767: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	mov	0x60, %r26
	.word 0x87802020  ! 2769: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2770: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdadc0400  ! 2771: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	.word 0xdab76000  ! 2772: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdab7e000  ! 2773: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xd0b70e40  ! 2774: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	.word 0xd0a70e80  ! 2775: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0xdebf6000  ! 2776: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xd0a44400  ! 2777: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xd4dc4400  ! 2778: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	mov	0x7d8, %r23
	.word 0x87802025  ! 2780: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 2781: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b7a000  ! 2782: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xdcdcc400  ! 2783: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	.word 0x87802072  ! 2784: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdadf6000  ! 2785: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xdcc4c400  ! 2786: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	.word 0x87802020  ! 2787: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4afe000  ! 2788: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	mov	0x10, %r18
	.word 0xd4bf2000  ! 2790: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd0a74e80  ! 2791: STWA_R	stwa	%r8, [%r29 + %r0] 0x74
	.word 0x87802074  ! 2792: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8956000  ! 2793: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r12
	.word 0xd8856000  ! 2794: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2795: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab48400  ! 2796: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0xd6a78e60  ! 2797: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0xd2c4e000  ! 2798: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xd8c74e60  ! 2799: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r12
	mov	0x60, %r24
	mov	0x7f8, %r22
	.word 0xdab4e000  ! 2802: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x70, %r18
	.word 0xdc8fce60  ! 2805: LDUBA_R	lduba	[%r31, %r0] 0x73, %r14
	.word 0xdcaf8e60  ! 2806: STBA_R	stba	%r14, [%r30 + %r0] 0x73
	.word 0xd684a000  ! 2807: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r11
	.word 0xd8ae49e0  ! 2808: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0xd4aca000  ! 2809: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0xd4842000  ! 2810: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	mov	0x7c8, %r23
	mov	0x58, %r26
	.word 0xd4b4e000  ! 2813: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	mov	0x70, %r17
	.word 0x87802074  ! 2815: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 2816: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r16
	mov	0x7d8, %r22
	.word 0x87802025  ! 2819: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r19
	mov	0x60, %r27
	.word 0x87802020  ! 2822: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a78e80  ! 2823: STWA_R	stwa	%r9, [%r30 + %r0] 0x74
	.word 0xdc9de000  ! 2824: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r14
	.word 0xdcb56000  ! 2825: STHA_I	stha	%r14, [%r21 + 0x0000] %asi
	.word 0xd095c4a0  ! 2826: LDUHA_R	lduha	[%r23, %r0] 0x25, %r8
	.word 0xde8da000  ! 2827: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r15
	mov	0x68, %r16
	.word 0x87802020  ! 2829: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde944400  ! 2830: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	.word 0x87802025  ! 2831: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaf40400  ! 2832: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xd0c78e60  ! 2833: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r8
	.word 0xdadfe000  ! 2834: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0x87802073  ! 2835: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf7e000  ! 2836: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xdaa76000  ! 2837: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xd2b74e80  ! 2838: STHA_R	stha	%r9, [%r29 + %r0] 0x74
	.word 0xd08f0e60  ! 2839: LDUBA_R	lduba	[%r28, %r0] 0x73, %r8
	.word 0x87802020  ! 2840: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f48400  ! 2841: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xd0974e80  ! 2842: LDUHA_R	lduha	[%r29, %r0] 0x74, %r8
	mov	0x40, %r27
	mov	0x3e0, %r22
	.word 0xd8d78e60  ! 2845: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r12
	.word 0xd8dc6000  ! 2846: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 2847: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a44400  ! 2848: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xd68c0400  ! 2849: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	.word 0xdab42000  ! 2850: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xda946000  ! 2851: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	.word 0xdabc6000  ! 2852: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xdebf0e40  ! 2853: STDA_R	stda	%r15, [%r28 + %r0] 0x72
	.word 0xd8a649e0  ! 2854: STWA_R	stwa	%r12, [%r25 + %r0] 0x4f
	.word 0xd8f4c400  ! 2855: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0x87802025  ! 2856: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r16
	.word 0xd695a000  ! 2858: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r11
	mov	0x58, %r17
	.word 0xdaf48400  ! 2860: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xdc9504a0  ! 2861: LDUHA_R	lduha	[%r20, %r0] 0x25, %r14
	.word 0xdabcc400  ! 2862: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	.word 0xd6856000  ! 2863: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r11
	mov	0x3d8, %r21
	mov	0x7d8, %r20
	.word 0xd8948400  ! 2866: LDUHA_R	lduha	[%r18, %r0] 0x20, %r12
	.word 0x8780204f  ! 2867: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2844400  ! 2868: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	.word 0xd0b7e000  ! 2869: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0xd0d7e000  ! 2870: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xd8af0e80  ! 2871: STBA_R	stba	%r12, [%r28 + %r0] 0x74
	.word 0xd09cc400  ! 2872: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	mov	0x28, %r16
	.word 0xd4cfe000  ! 2874: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0x87802020  ! 2875: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcd584a0  ! 2876: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r14
	.word 0xd2dc8400  ! 2877: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0x87802072  ! 2878: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2acc400  ! 2879: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	mov	0x3f0, %r21
	.word 0xd88fa000  ! 2881: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0xd89f2000  ! 2882: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2883: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r25
	.word 0xd8852000  ! 2885: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r12
	mov	0x3f8, %r21
	.word 0xd89d2000  ! 2887: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r12
	.word 0xd8dd6000  ! 2888: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r12
	.word 0xdeaec9e0  ! 2889: STBA_R	stba	%r15, [%r27 + %r0] 0x4f
	mov	0x50, %r26
	mov	0x38, %r24
	mov	0x20, %r27
	.word 0x87802025  ! 2893: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2894: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd89544a0  ! 2895: LDUHA_R	lduha	[%r21, %r0] 0x25, %r12
	.word 0x87802072  ! 2896: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabc8400  ! 2897: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	mov	0x7f8, %r22
	mov	0x3f0, %r21
	mov	0x3d8, %r21
	mov	0x48, %r24
	.word 0xda874e60  ! 2902: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r13
	.word 0xd4ae2000  ! 2903: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 2904: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bd84a0  ! 2905: STDA_R	stda	%r9, [%r22 + %r0] 0x25
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdc9da000  ! 2907: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r14
	.word 0xdcc78e40  ! 2908: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r14
	.word 0x8780204f  ! 2909: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r19
	.word 0xd2bf6000  ! 2911: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xd2d72000  ! 2913: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xd29fa000  ! 2914: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd6c7ce80  ! 2915: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r11
	.word 0x87802073  ! 2916: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdabf2000  ! 2917: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xdaf72000  ! 2918: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2919: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r21
	.word 0xdaae6000  ! 2921: STBA_I	stba	%r13, [%r25 + 0x0000] %asi
	mov	0x7e0, %r21
	mov	0x3e0, %r20
	mov	0x7e8, %r20
	mov	0x40, %r16
	.word 0xd8bf0e40  ! 2926: STDA_R	stda	%r12, [%r28 + %r0] 0x72
	mov	0x7f0, %r20
	mov	0x7c8, %r21
	.word 0xdc9f4e40  ! 2929: LDDA_R	ldda	[%r29, %r0] 0x72, %r14
	.word 0xd096e000  ! 2930: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r8
	mov	0x30, %r25
	.word 0xd4bc0400  ! 2932: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 2933: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd896e000  ! 2934: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r12
	.word 0xd8a62000  ! 2935: STWA_I	stwa	%r12, [%r24 + 0x0000] %asi
	.word 0xd896a000  ! 2936: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r12
	.word 0xdcdf4e60  ! 2937: LDXA_R	ldxa	[%r29, %r0] 0x73, %r14
	.word 0xd8f6a000  ! 2938: STXA_I	stxa	%r12, [%r26 + 0x0000] %asi
	.word 0xd8c6e000  ! 2939: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r12
	mov	0x78, %r26
	mov	0x78, %r25
	.word 0xdef78e40  ! 2942: STXA_R	stxa	%r15, [%r30 + %r0] 0x72
	.word 0xd8b6c9e0  ! 2943: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	mov	0x3c0, %r20
	.word 0xde8ea000  ! 2945: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r15
	.word 0xd0a74e60  ! 2946: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	.word 0x87802020  ! 2947: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2948: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcd70e60  ! 2949: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r14
	.word 0xd0b584a0  ! 2950: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	mov	0x7e0, %r20
	.word 0xd0cf6000  ! 2952: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd0cf2000  ! 2953: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	mov	0x0, %r27
	.word 0x87802020  ! 2955: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r27
	.word 0x87802073  ! 2957: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 2958: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6874e60  ! 2959: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r11
	.word 0xd48dc4a0  ! 2960: LDUBA_R	lduba	[%r23, %r0] 0x25, %r10
	mov	0x40, %r24
	mov	0x68, %r19
	.word 0xd2c5e000  ! 2963: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r9
	mov	0x3d8, %r22
	.word 0xd2f52000  ! 2965: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	mov	0x28, %r25
	.word 0xd2dd6000  ! 2967: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r9
	mov	0x78, %r25
	.word 0xd2d5e000  ! 2969: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r9
	.word 0xd2948400  ! 2970: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	mov	0x7e8, %r21
	.word 0x8780204f  ! 2972: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdccc8400  ! 2973: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	.word 0xd2f5c4a0  ! 2974: STXA_R	stxa	%r9, [%r23 + %r0] 0x25
	.word 0x87802020  ! 2975: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab70e80  ! 2976: STHA_R	stha	%r13, [%r28 + %r0] 0x74
	mov	0x7c8, %r22
	.word 0xd0dfa000  ! 2978: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	mov	0x60, %r18
	.word 0xd0b72000  ! 2980: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2981: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r26
	.word 0xd4bc0400  ! 2983: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xdab4a000  ! 2984: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0xdaac2000  ! 2986: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 2987: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda84e000  ! 2988: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r13
	.word 0xdaad04a0  ! 2989: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	.word 0xdebd44a0  ! 2990: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	.word 0xdaa649e0  ! 2991: STWA_R	stwa	%r13, [%r25 + %r0] 0x4f
	.word 0xd0a46000  ! 2992: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xdc878e80  ! 2993: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r14
	mov	0x7c8, %r22
	.word 0xdcb42000  ! 2995: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xd89f4e60  ! 2996: LDDA_R	ldda	[%r29, %r0] 0x73, %r12
	mov	0x18, %r18
	.word 0xded4c400  ! 2998: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r15
	mov	0x3e8, %r21
	.word 0xd88ce000  ! 3000: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	.word 0xdcb7ce40  ! 3001: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	mov	0x0, %r26
	.word 0xdccc4400  ! 3003: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r14
	.word 0xde8f0e60  ! 3004: LDUBA_R	lduba	[%r28, %r0] 0x73, %r15
	.word 0xd2ac8400  ! 3005: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0x87802074  ! 3006: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa74e60  ! 3007: STWA_R	stwa	%r13, [%r29 + %r0] 0x73
	.word 0xd0f46000  ! 3008: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xd29f0e40  ! 3009: LDDA_R	ldda	[%r28, %r0] 0x72, %r9
	.word 0xde94e000  ! 3010: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	.word 0xdeb4a000  ! 3011: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0xded42000  ! 3013: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	mov	0x30, %r27
	.word 0xdef42000  ! 3015: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xdebce000  ! 3016: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xdef4e000  ! 3017: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 3018: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x10, %r18
	mov	0x38, %r17
	.word 0xdecea000  ! 3022: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r15
	.word 0xde96a000  ! 3023: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r15
	mov	0x48, %r18
	.word 0xdcbc0400  ! 3025: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0xd8dee000  ! 3026: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r12
	mov	0x3c8, %r21
	.word 0xd8d62000  ! 3028: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r12
	.word 0xd2cc4400  ! 3029: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r9
	.word 0x87802020  ! 3030: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r26
	.word 0xd8b40400  ! 3032: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xd0c7ce80  ! 3033: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r8
	.word 0x87802025  ! 3034: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd48f4e80  ! 3036: LDUBA_R	lduba	[%r29, %r0] 0x74, %r10
	.word 0x87802074  ! 3037: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r27
	.word 0xd8bc4400  ! 3039: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xd09f0e60  ! 3040: LDDA_R	ldda	[%r28, %r0] 0x73, %r8
	.word 0xdccf4e40  ! 3041: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r14
	mov	0x3c8, %r21
	mov	0x3c0, %r23
	.word 0xd2d76000  ! 3044: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0xd8a7ce60  ! 3045: STWA_R	stwa	%r12, [%r31 + %r0] 0x73
	.word 0x87802025  ! 3046: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcdfe000  ! 3047: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	mov	0x50, %r26
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x70, %r26
	.word 0xd68f8e40  ! 3051: LDUBA_R	lduba	[%r30, %r0] 0x72, %r11
	.word 0xd8a72000  ! 3052: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	mov	0x3d8, %r21
	.word 0xd6ac8400  ! 3054: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xd2a44400  ! 3055: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0x87802073  ! 3056: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef4e000  ! 3057: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xde9c6000  ! 3058: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0x87802073  ! 3059: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8dcc400  ! 3060: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	.word 0xde85a000  ! 3061: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r15
	mov	0x70, %r26
	mov	0x7c8, %r20
	.word 0xdca48400  ! 3064: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xdcf56000  ! 3065: STXA_I	stxa	%r14, [%r21 + 0x0000] %asi
	.word 0xd29689e0  ! 3066: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r9
	.word 0x87802025  ! 3067: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bdc4a0  ! 3068: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	.word 0xd6a4a000  ! 3069: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	.word 0xd09c0400  ! 3070: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	.word 0x87802020  ! 3071: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r17
	mov	0x60, %r25
	mov	0x60, %r25
	mov	0x40, %r19
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0be6000  ! 3077: STDA_I	stda	%r8, [%r25 + 0x0000] %asi
	.word 0xd08ee000  ! 3078: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r8
	.word 0xdcf609e0  ! 3079: STXA_R	stxa	%r14, [%r24 + %r0] 0x4f
	.word 0xd8966000  ! 3080: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r12
	.word 0xdeb74e40  ! 3081: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	.word 0xdab6e000  ! 3082: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	.word 0xda9ea000  ! 3083: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r13
	.word 0xdaae2000  ! 3084: STBA_I	stba	%r13, [%r24 + 0x0000] %asi
	.word 0xdab66000  ! 3085: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0xd08f0e60  ! 3086: LDUBA_R	lduba	[%r28, %r0] 0x73, %r8
	.word 0xd48e6000  ! 3087: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r10
	.word 0xd486e000  ! 3088: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	.word 0xd4ae2000  ! 3089: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	.word 0xd4f62000  ! 3090: STXA_I	stxa	%r10, [%r24 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802072  ! 3092: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r26
	.word 0xd4a42000  ! 3094: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0xd484e000  ! 3095: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r10
	.word 0xd484e000  ! 3096: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r10
	.word 0x87802020  ! 3097: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bfe000  ! 3098: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x7f0, %r22
	mov	0x3e0, %r20
	.word 0x87802072  ! 3101: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8f48400  ! 3102: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xdc8f2000  ! 3103: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0xde97ce60  ! 3104: LDUHA_R	lduha	[%r31, %r0] 0x73, %r15
	mov	0x20, %r26
	.word 0xd6a6c9e0  ! 3106: STWA_R	stwa	%r11, [%r27 + %r0] 0x4f
	.word 0xdecf6000  ! 3107: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0xdea76000  ! 3108: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	mov	0x70, %r24
	mov	0x48, %r26
	.word 0x8780204f  ! 3111: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f8, %r20
	mov	0x3e0, %r20
	.word 0x87802072  ! 3114: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c8, %r21
	mov	0x18, %r26
	.word 0xd2d78e40  ! 3117: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r9
	mov	0x7d0, %r22
	.word 0xd8cfa000  ! 3119: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd8d7ce80  ! 3120: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r12
	.word 0x87802074  ! 3121: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r26
	.word 0xd4f44400  ! 3123: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0xd2a7a000  ! 3124: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xd0afce60  ! 3125: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	.word 0x87802020  ! 3126: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3127: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3128: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8cf8e40  ! 3129: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r12
	.word 0xd0a74e60  ! 3130: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	.word 0xdcbc2000  ! 3131: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xd6bf4e80  ! 3132: STDA_R	stda	%r11, [%r29 + %r0] 0x74
	.word 0xd6f5c4a0  ! 3133: STXA_R	stxa	%r11, [%r23 + %r0] 0x25
	mov	0x30, %r26
	mov	0x70, %r25
	.word 0xd8978e60  ! 3136: LDUHA_R	lduha	[%r30, %r0] 0x73, %r12
	.word 0xdab46000  ! 3137: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0xd6b78e80  ! 3138: STHA_R	stha	%r11, [%r30 + %r0] 0x74
	.word 0xd6870e80  ! 3139: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r11
	.word 0xd8c44400  ! 3140: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r12
	.word 0xd8ae49e0  ! 3141: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0xd48e09e0  ! 3142: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r10
	.word 0x8780204f  ! 3143: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa72000  ! 3144: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xdecc8400  ! 3145: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	.word 0xd4a7ce80  ! 3146: STWA_R	stwa	%r10, [%r31 + %r0] 0x74
	mov	0x20, %r26
	.word 0xd095c4a0  ! 3148: LDUHA_R	lduha	[%r23, %r0] 0x25, %r8
	mov	0x58, %r26
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2d7e000  ! 3151: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	mov	0x10, %r27
	.word 0xd2d7a000  ! 3153: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	mov	0x30, %r24
	.word 0xd287e000  ! 3155: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2876000  ! 3156: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	mov	0x3c8, %r22
	.word 0xd4bfce80  ! 3158: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	.word 0xdaad44a0  ! 3159: STBA_R	stba	%r13, [%r21 + %r0] 0x25
	mov	0x70, %r26
	.word 0xd2bc8400  ! 3161: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	.word 0xd2a7e000  ! 3162: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xd2cf6000  ! 3163: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	.word 0xd2bf6000  ! 3164: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xdeaf0e40  ! 3165: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	.word 0xd2d70e60  ! 3166: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r9
	.word 0x87802025  ! 3167: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdccf8e60  ! 3168: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r14
	.word 0xdaafa000  ! 3169: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdaa72000  ! 3170: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xdcbc8400  ! 3171: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 3172: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 3173: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6cf2000  ! 3174: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0xda978e40  ! 3175: LDUHA_R	lduha	[%r30, %r0] 0x72, %r13
	.word 0xd287a000  ! 3176: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2c7e000  ! 3177: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0xd6970e60  ! 3178: LDUHA_R	lduha	[%r28, %r0] 0x73, %r11
	.word 0xdad4c400  ! 3179: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0x87802020  ! 3180: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc84e000  ! 3181: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r14
	mov	0x20, %r27
	.word 0xd68fce60  ! 3183: LDUBA_R	lduba	[%r31, %r0] 0x73, %r11
	.word 0xdeb689e0  ! 3184: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	.word 0xd0b46000  ! 3185: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0xdaae89e0  ! 3186: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	.word 0xda94a000  ! 3187: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	.word 0xdacc6000  ! 3188: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	.word 0xdac7ce80  ! 3189: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r13
	.word 0xd8bc0400  ! 3190: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xd8f78e60  ! 3191: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	.word 0x87802072  ! 3192: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde970e60  ! 3193: LDUHA_R	lduha	[%r28, %r0] 0x73, %r15
	.word 0xdccce000  ! 3194: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r14
	.word 0xdccf4e80  ! 3195: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r14
	.word 0xd2cfce60  ! 3196: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r9
	.word 0xd08c2000  ! 3197: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	mov	0x28, %r24
	.word 0xdccc8400  ! 3199: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	.word 0xdcac2000  ! 3200: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	mov	0x0, %r17
	mov	0x60, %r18
	.word 0xdcac6000  ! 3203: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xd2c4c400  ! 3204: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0xd0a46000  ! 3205: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xda8c0400  ! 3206: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	.word 0xdecc0400  ! 3207: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r15
	.word 0x87802074  ! 3208: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6c72000  ! 3209: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 3210: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd89f4e80  ! 3211: LDDA_R	ldda	[%r29, %r0] 0x74, %r12
	.word 0xd4dc6000  ! 3212: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	mov	0x38, %r19
	.word 0xd097ce80  ! 3214: LDUHA_R	lduha	[%r31, %r0] 0x74, %r8
	.word 0xdaa74e80  ! 3215: STWA_R	stwa	%r13, [%r29 + %r0] 0x74
	.word 0x87802074  ! 3216: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 3217: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcc4c400  ! 3218: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	.word 0x87802073  ! 3219: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcc7a000  ! 3220: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xd48f0e80  ! 3221: LDUBA_R	lduba	[%r28, %r0] 0x74, %r10
	.word 0xd697e000  ! 3222: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0xd0cd44a0  ! 3223: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r8
	mov	0x8, %r26
	.word 0xd6b7e000  ! 3225: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xdedd44a0  ! 3226: LDXA_R	ldxa	[%r21, %r0] 0x25, %r15
	.word 0xd8ac8400  ! 3227: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0xdecf6000  ! 3228: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0xd0a48400  ! 3229: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0x87802073  ! 3230: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf72000  ! 3231: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	mov	0x60, %r26
	.word 0xdaaf6000  ! 3233: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0xd6f4c400  ! 3235: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0xdea72000  ! 3236: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xd4d40400  ! 3237: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	mov	0x3f8, %r21
	.word 0xdc86c9e0  ! 3239: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r14
	.word 0xdab74e40  ! 3240: STHA_R	stha	%r13, [%r29 + %r0] 0x72
	mov	0x3e0, %r21
	.word 0xdc970e40  ! 3242: LDUHA_R	lduha	[%r28, %r0] 0x72, %r14
	.word 0xd8a74e40  ! 3243: STWA_R	stwa	%r12, [%r29 + %r0] 0x72
	.word 0xdabf4e60  ! 3244: STDA_R	stda	%r13, [%r29 + %r0] 0x73
	.word 0xd2b40400  ! 3245: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	mov	0x70, %r19
	mov	0x38, %r19
	.word 0xdcdfa000  ! 3248: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	.word 0x87802073  ! 3249: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb6a000  ! 3250: STHA_I	stha	%r14, [%r26 + 0x0000] %asi
	.word 0xdab74e60  ! 3251: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	.word 0xd0de6000  ! 3252: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r8
	.word 0x87802074  ! 3253: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0cca000  ! 3254: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	mov	0x20, %r25
	.word 0xdcd6c9e0  ! 3256: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r14
	.word 0xdc946000  ! 3257: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r14
	.word 0xdca46000  ! 3258: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	mov	0x50, %r27
	.word 0xd6c40400  ! 3260: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r11
	.word 0x87802074  ! 3261: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd897ce80  ! 3262: LDUHA_R	lduha	[%r31, %r0] 0x74, %r12
	.word 0xd4946000  ! 3263: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r10
	.word 0xdef74e40  ! 3264: STXA_R	stxa	%r15, [%r29 + %r0] 0x72
	.word 0x87802020  ! 3265: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3266: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e0, %r21
	mov	0x68, %r17
	.word 0xdeb52000  ! 3269: STHA_I	stha	%r15, [%r20 + 0x0000] %asi
	.word 0xde9da000  ! 3270: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r15
	.word 0xd6f609e0  ! 3271: STXA_R	stxa	%r11, [%r24 + %r0] 0x4f
	mov	0x78, %r19
	mov	0x0, %r17
	.word 0xd0d52000  ! 3274: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r8
	mov	0x7f0, %r23
	.word 0xd4be09e0  ! 3276: STDA_R	stda	%r10, [%r24 + %r0] 0x4f
	.word 0xda8544a0  ! 3277: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r13
	.word 0xdabd6000  ! 3278: STDA_I	stda	%r13, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 3279: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab4e000  ! 3280: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xda84a000  ! 3281: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	.word 0xd8afce60  ! 3282: STBA_R	stba	%r12, [%r31 + %r0] 0x73
	.word 0xded40400  ! 3283: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	mov	0x7f0, %r22
	.word 0xdcb4a000  ! 3285: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xdca42000  ! 3286: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0xdcac6000  ! 3288: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	mov	0x38, %r18
	.word 0xdcf4e000  ! 3290: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcd4a000  ! 3291: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	.word 0x87802020  ! 3292: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3293: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 3294: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf76000  ! 3295: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcf7e000  ! 3296: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdaacc400  ! 3297: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0x87802020  ! 3298: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c5c4a0  ! 3299: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r11
	mov	0x18, %r16
	.word 0x87802025  ! 3301: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0d6e000  ! 3302: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r8
	mov	0x60, %r27
	.word 0xd48c4400  ! 3304: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	mov	0x70, %r27
	mov	0x8, %r18
	mov	0x48, %r26
	.word 0xd0bee000  ! 3308: STDA_I	stda	%r8, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 3309: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08c6000  ! 3310: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0x87802025  ! 3311: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0846000  ! 3312: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	mov	0x3e0, %r22
	.word 0xd09ca000  ! 3314: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	.word 0x87802073  ! 3315: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd88cc400  ! 3316: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	.word 0xd0f48400  ! 3317: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xd2b46000  ! 3318: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xd88c4400  ! 3320: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0xdc8ce000  ! 3321: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	.word 0xd4bf0e80  ! 3322: STDA_R	stda	%r10, [%r28 + %r0] 0x74
	.word 0xdabc0400  ! 3323: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0x87802072  ! 3324: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd894a000  ! 3325: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r12
	.word 0xd8f4e000  ! 3326: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xdeb74e60  ! 3327: STHA_R	stha	%r15, [%r29 + %r0] 0x73
	.word 0xdad649e0  ! 3328: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r13
	.word 0xda9c2000  ! 3329: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	.word 0xda94a000  ! 3330: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3331: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcad84a0  ! 3332: STBA_R	stba	%r14, [%r22 + %r0] 0x25
	.word 0xd8878e60  ! 3333: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r12
	.word 0xdabf4e80  ! 3334: STDA_R	stda	%r13, [%r29 + %r0] 0x74
	.word 0xd28c2000  ! 3335: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xd2ae09e0  ! 3336: STBA_R	stba	%r9, [%r24 + %r0] 0x4f
	.word 0xd2f4e000  ! 3337: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd49fce80  ! 3338: LDDA_R	ldda	[%r31, %r0] 0x74, %r10
	mov	0x3c8, %r20
	.word 0x87802074  ! 3340: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2a46000  ! 3341: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd294e000  ! 3342: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	.word 0x87802074  ! 3343: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b609e0  ! 3344: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	.word 0xd89ce000  ! 3345: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 3346: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8df6000  ! 3347: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	mov	0x7f0, %r20
	.word 0x87802074  ! 3349: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 3350: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8b76000  ! 3351: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 3352: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bd44a0  ! 3353: STDA_R	stda	%r11, [%r21 + %r0] 0x25
	mov	0x68, %r26
	.word 0xdef584a0  ! 3355: STXA_R	stxa	%r15, [%r22 + %r0] 0x25
	.word 0x87802073  ! 3356: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdac66000  ! 3357: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r13
	mov	0x40, %r26
	.word 0xdab66000  ! 3359: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0x87802025  ! 3360: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 3361: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r26
	.word 0xdcf44400  ! 3363: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xdef70e60  ! 3364: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	.word 0xd6f40400  ! 3365: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	mov	0x28, %r26
	.word 0xd6f76000  ! 3367: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	mov	0x60, %r18
	.word 0xd6cf2000  ! 3369: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0xd2b4c400  ! 3370: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xd28fa000  ! 3371: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	mov	0x48, %r19
	mov	0x7e0, %r21
	mov	0x28, %r27
	.word 0xdaf70e80  ! 3375: STXA_R	stxa	%r13, [%r28 + %r0] 0x74
	.word 0x87802073  ! 3376: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaafe000  ! 3377: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd6ad04a0  ! 3379: STBA_R	stba	%r11, [%r20 + %r0] 0x25
	.word 0xd2cf6000  ! 3380: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	.word 0xd2afa000  ! 3381: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xd4adc4a0  ! 3382: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0xdaac0400  ! 3383: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xd68c0400  ! 3384: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	.word 0xd88584a0  ! 3385: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r12
	.word 0xd8bf4e60  ! 3386: STDA_R	stda	%r12, [%r29 + %r0] 0x73
	.word 0xd8972000  ! 3387: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	mov	0x10, %r27
	.word 0xd2af4e60  ! 3389: STBA_R	stba	%r9, [%r29 + %r0] 0x73
	mov	0x68, %r17
	.word 0xd897e000  ! 3391: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	.word 0xd88f2000  ! 3392: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0xd2adc4a0  ! 3393: STBA_R	stba	%r9, [%r23 + %r0] 0x25
	mov	0x18, %r18
	.word 0xdca78e40  ! 3395: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	.word 0xd6c72000  ! 3396: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0xda9cc400  ! 3397: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	.word 0xd0df0e60  ! 3398: LDXA_R	ldxa	[%r28, %r0] 0x73, %r8
	.word 0xd6b40400  ! 3399: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xd2af2000  ! 3400: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 3401: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0f689e0  ! 3403: STXA_R	stxa	%r8, [%r26 + %r0] 0x4f
	.word 0xd2c4a000  ! 3404: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	mov	0x10, %r19
	.word 0xd2cca000  ! 3406: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	.word 0xd28ce000  ! 3407: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	.word 0xd0be89e0  ! 3408: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 3409: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f44400  ! 3410: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0xd8a44400  ! 3411: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xdcc4a000  ! 3412: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r14
	.word 0x87802025  ! 3413: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc86e000  ! 3414: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r14
	.word 0x87802025  ! 3415: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 3416: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdccfe000  ! 3417: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 3418: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcb72000  ! 3419: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xdc97a000  ! 3420: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	mov	0x0, %r27
	.word 0xd4bdc4a0  ! 3422: STDA_R	stda	%r10, [%r23 + %r0] 0x25
	mov	0x3e0, %r23
	.word 0xdad70e80  ! 3424: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r13
	.word 0xdab7e000  ! 3425: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xda9504a0  ! 3426: LDUHA_R	lduha	[%r20, %r0] 0x25, %r13
	.word 0x8780204f  ! 3427: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6a70e60  ! 3428: STWA_R	stwa	%r11, [%r28 + %r0] 0x73
	.word 0x87802025  ! 3429: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcdfa000  ! 3430: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcc76000  ! 3431: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xdcbfa000  ! 3432: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xd8f74e60  ! 3433: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	.word 0x87802025  ! 3434: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3435: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabf6000  ! 3436: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xd2bd04a0  ! 3437: STDA_R	stda	%r9, [%r20 + %r0] 0x25
	.word 0xd08f2000  ! 3438: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	.word 0xd0d7e000  ! 3439: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0b7ce80  ! 3440: STHA_R	stha	%r8, [%r31 + %r0] 0x74
	.word 0x87802020  ! 3441: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8609e0  ! 3442: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r13
	.word 0xd6b44400  ! 3443: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xd8a76000  ! 3444: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0xd8cf2000  ! 3446: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0x87802020  ! 3447: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a78e60  ! 3448: STWA_R	stwa	%r8, [%r30 + %r0] 0x73
	mov	0x78, %r19
	.word 0xdab72000  ! 3450: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdab7e000  ! 3451: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	mov	0x3c0, %r20
	.word 0xdacf2000  ! 3453: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xdabf2000  ! 3454: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	mov	0x78, %r25
	mov	0x60, %r17
	.word 0xdabf2000  ! 3457: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	mov	0x30, %r16
	mov	0x50, %r17
	.word 0xdac48400  ! 3460: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	.word 0xd8d70e40  ! 3461: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r12
	.word 0xdaf504a0  ! 3462: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	.word 0xd287ce80  ! 3463: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r9
	.word 0xd4b72000  ! 3464: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd08fce60  ! 3465: LDUBA_R	lduba	[%r31, %r0] 0x73, %r8
	.word 0xd297e000  ! 3466: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	.word 0xd09dc4a0  ! 3467: LDDA_R	ldda	[%r23, %r0] 0x25, %r8
	.word 0xd6d4c400  ! 3468: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	mov	0x7f0, %r20
	.word 0xd0cf6000  ! 3470: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xdca70e80  ! 3471: STWA_R	stwa	%r14, [%r28 + %r0] 0x74
	mov	0x50, %r16
	mov	0x38, %r17
	.word 0xd8b40400  ! 3474: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xd6a584a0  ! 3475: STWA_R	stwa	%r11, [%r22 + %r0] 0x25
	.word 0xd6af6000  ! 3476: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xdaf70e40  ! 3477: STXA_R	stxa	%r13, [%r28 + %r0] 0x72
	.word 0xda9fa000  ! 3478: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xdacfe000  ! 3479: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0xd2844400  ! 3480: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	mov	0x3c0, %r20
	.word 0x87802073  ! 3482: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd28c4400  ! 3483: LDUBA_R	lduba	[%r17, %r0] 0x20, %r9
	mov	0x38, %r27
	.word 0xdef78e40  ! 3485: STXA_R	stxa	%r15, [%r30 + %r0] 0x72
	.word 0xd8c584a0  ! 3486: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r12
	.word 0xdea4a000  ! 3487: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xd0bec9e0  ! 3488: STDA_R	stda	%r8, [%r27 + %r0] 0x4f
	.word 0xdcc46000  ! 3489: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r14
	.word 0xdcbc2000  ! 3490: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xdc946000  ! 3491: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r14
	.word 0xdc942000  ! 3492: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	mov	0x7d8, %r20
	mov	0x28, %r17
	.word 0xdc8c6000  ! 3495: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r14
	mov	0x58, %r19
	.word 0xdcf4a000  ! 3497: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcc42000  ! 3498: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r14
	.word 0x87802072  ! 3499: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd28f8e60  ! 3500: LDUBA_R	lduba	[%r30, %r0] 0x73, %r9
	.word 0xd297ce60  ! 3501: LDUHA_R	lduha	[%r31, %r0] 0x73, %r9
	.word 0x87802025  ! 3502: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd4a48400  ! 3504: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xd8b7ce60  ! 3505: STHA_R	stha	%r12, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 3506: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bf6000  ! 3507: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd8f72000  ! 3508: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd89f6000  ! 3509: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	.word 0xd8f48400  ! 3510: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xd4c7ce40  ! 3511: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r10
	mov	0x40, %r16
	.word 0x87802020  ! 3513: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r27
	.word 0xdacd84a0  ! 3515: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r13
	.word 0xd6f52000  ! 3516: STXA_I	stxa	%r11, [%r20 + 0x0000] %asi
	.word 0xd2f4c400  ! 3517: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xd2840400  ! 3518: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r9
	.word 0xdaf74e60  ! 3519: STXA_R	stxa	%r13, [%r29 + %r0] 0x73
	.word 0xd0b78e60  ! 3520: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	mov	0x58, %r19
	.word 0xdcc52000  ! 3522: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r14
	mov	0x78, %r18
	mov	0x3d8, %r21
	.word 0xdc8f8e80  ! 3525: LDUBA_R	lduba	[%r30, %r0] 0x74, %r14
	.word 0xd29e89e0  ! 3526: LDDA_R	ldda	[%r26, %r0] 0x4f, %r9
	.word 0xd2852000  ! 3527: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r9
	.word 0xd29da000  ! 3528: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r9
	mov	0x28, %r19
	.word 0xd29da000  ! 3530: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r9
	mov	0x3c8, %r21
	mov	0x7c8, %r21
	.word 0xd2ade000  ! 3533: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0xd2bd2000  ! 3535: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	.word 0xdcd609e0  ! 3536: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r14
	mov	0x40, %r16
	mov	0x28, %r27
	mov	0x3d8, %r20
	.word 0xd6dda000  ! 3540: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r11
	mov	0x60, %r19
	.word 0xd6b5e000  ! 3542: STHA_I	stha	%r11, [%r23 + 0x0000] %asi
	.word 0xd6c5e000  ! 3543: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r11
	.word 0xd695a000  ! 3544: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r11
	.word 0xdcb5c4a0  ! 3545: STHA_R	stha	%r14, [%r23 + %r0] 0x25
	.word 0xdcad2000  ! 3546: STBA_I	stba	%r14, [%r20 + 0x0000] %asi
	.word 0x8780204f  ! 3547: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8dec9e0  ! 3548: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r12
	.word 0xdacf6000  ! 3549: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xda976000  ! 3550: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	.word 0xdaac0400  ! 3551: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xd6bfce40  ! 3552: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	.word 0xded40400  ! 3553: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	.word 0xd0d48400  ! 3554: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	.word 0xd0a584a0  ! 3555: STWA_R	stwa	%r8, [%r22 + %r0] 0x25
	.word 0xd0d72000  ! 3556: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0bf6000  ! 3557: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd09fa000  ! 3558: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	.word 0xd0f72000  ! 3559: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xd0cf6000  ! 3560: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	mov	0x10, %r16
	.word 0xdacc4400  ! 3562: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	mov	0x48, %r26
	mov	0x7f8, %r22
	.word 0xd0af6000  ! 3565: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	mov	0x20, %r16
	mov	0x40, %r17
	mov	0x8, %r26
	mov	0x60, %r24
	.word 0xd0bfa000  ! 3570: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0xd49689e0  ! 3571: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r10
	mov	0x3d0, %r22
	.word 0xd8840400  ! 3573: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r12
	.word 0xd4848400  ! 3574: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r10
	.word 0xdc9584a0  ! 3575: LDUHA_R	lduha	[%r22, %r0] 0x25, %r14
	.word 0xd287a000  ! 3576: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	mov	0x3f0, %r23
	.word 0xdcacc400  ! 3578: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0x87802072  ! 3579: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2bfe000  ! 3580: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	mov	0x3c0, %r20
	.word 0xd28f2000  ! 3582: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	mov	0x0, %r25
	.word 0xdc8e49e0  ! 3584: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r14
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0b76000  ! 3586: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	mov	0x7c8, %r23
	.word 0xd0b7e000  ! 3588: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	mov	0x7c8, %r22
	.word 0x87802072  ! 3590: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b78e80  ! 3591: STHA_R	stha	%r8, [%r30 + %r0] 0x74
	mov	0x38, %r26
	.word 0xda9fa000  ! 3593: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0x87802025  ! 3594: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r19
	.word 0xd69f4e80  ! 3596: LDDA_R	ldda	[%r29, %r0] 0x74, %r11
	.word 0xd49f8e80  ! 3597: LDDA_R	ldda	[%r30, %r0] 0x74, %r10
	mov	0x70, %r27
	.word 0xd0f4c400  ! 3599: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0x87802073  ! 3600: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 3601: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8afe000  ! 3602: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd88f2000  ! 3603: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	mov	0x60, %r17
	.word 0x87802073  ! 3605: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdabd04a0  ! 3606: STDA_R	stda	%r13, [%r20 + %r0] 0x25
	.word 0xd6cf2000  ! 3607: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0xde948400  ! 3608: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	.word 0x87802020  ! 3609: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9de000  ! 3610: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r13
	.word 0xdaf5e000  ! 3611: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0xdcd544a0  ! 3612: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r14
	mov	0x78, %r25
	.word 0xda8de000  ! 3614: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r13
	.word 0xdab5e000  ! 3615: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0xda8da000  ! 3616: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r13
	.word 0xdab7ce60  ! 3617: STHA_R	stha	%r13, [%r31 + %r0] 0x73
	.word 0xdcbdc4a0  ! 3618: STDA_R	stda	%r14, [%r23 + %r0] 0x25
	.word 0xdab5e000  ! 3619: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0xdabd6000  ! 3620: STDA_I	stda	%r13, [%r21 + 0x0000] %asi
	.word 0xdcbf8e60  ! 3621: STDA_R	stda	%r14, [%r30 + %r0] 0x73
	.word 0xdabda000  ! 3622: STDA_I	stda	%r13, [%r22 + 0x0000] %asi
	.word 0xdecf4e40  ! 3623: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r15
	.word 0xd8852000  ! 3624: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r12
	.word 0x87802074  ! 3625: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd29f0e40  ! 3626: LDDA_R	ldda	[%r28, %r0] 0x72, %r9
	.word 0xd6d78e80  ! 3627: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r11
	.word 0x87802020  ! 3628: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb78e60  ! 3629: STHA_R	stha	%r14, [%r30 + %r0] 0x73
	.word 0xd2c48400  ! 3630: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0xda848400  ! 3631: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r13
	mov	0x40, %r16
	.word 0x8780204f  ! 3633: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a689e0  ! 3634: STWA_R	stwa	%r9, [%r26 + %r0] 0x4f
	.word 0xdacd2000  ! 3635: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r13
	.word 0x87802072  ! 3636: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab5e000  ! 3637: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0xd8978e80  ! 3638: LDUHA_R	lduha	[%r30, %r0] 0x74, %r12
	.word 0x8780204f  ! 3639: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d0, %r22
	.word 0xd88c2000  ! 3641: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	mov	0x7e8, %r20
	.word 0xd8f46000  ! 3643: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xda84c400  ! 3644: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r13
	.word 0x8780204f  ! 3645: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r24
	mov	0x40, %r26
	.word 0xd6a7ce80  ! 3648: STWA_R	stwa	%r11, [%r31 + %r0] 0x74
	.word 0xd6b4a000  ! 3649: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd8a70e60  ! 3650: STWA_R	stwa	%r12, [%r28 + %r0] 0x73
	mov	0x3f8, %r20
	.word 0xdcae49e0  ! 3652: STBA_R	stba	%r14, [%r25 + %r0] 0x4f
	.word 0xda878e60  ! 3653: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r13
	.word 0xd0a46000  ! 3654: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0cc8400  ! 3655: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0xd0b44400  ! 3656: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xd4c4e000  ! 3657: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r10
	mov	0x3c8, %r22
	mov	0x30, %r25
	mov	0x78, %r16
	.word 0xd4b42000  ! 3661: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 3662: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bd2000  ! 3663: STDA_I	stda	%r10, [%r20 + 0x0000] %asi
	.word 0xd8b48400  ! 3664: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0xde8f0e40  ! 3665: LDUBA_R	lduba	[%r28, %r0] 0x72, %r15
	.word 0xd8940400  ! 3666: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	.word 0xdeac0400  ! 3667: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0x87802020  ! 3668: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbf2000  ! 3669: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdcbf6000  ! 3670: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xd2bcc400  ! 3671: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0x87802072  ! 3672: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd69e2000  ! 3673: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r11
	.word 0xd29f0e40  ! 3674: LDDA_R	ldda	[%r28, %r0] 0x72, %r9
	mov	0x78, %r24
	.word 0xd8b70e60  ! 3676: STHA_R	stha	%r12, [%r28 + %r0] 0x73
	.word 0xd2b66000  ! 3677: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xdcf7ce80  ! 3679: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	.word 0xde944400  ! 3680: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	.word 0xdadea000  ! 3681: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r13
	mov	0x70, %r25
	.word 0x87802020  ! 3683: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r19
	mov	0x3d0, %r22
	.word 0x87802074  ! 3686: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b7ce60  ! 3687: STHA_R	stha	%r11, [%r31 + %r0] 0x73
	.word 0xd29e6000  ! 3688: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r9
	mov	0x18, %r24
	mov	0x38, %r25
	.word 0xd2ae2000  ! 3691: STBA_I	stba	%r9, [%r24 + 0x0000] %asi
	.word 0xd6c48400  ! 3692: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	.word 0xd0ce6000  ! 3693: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r8
	.word 0x87802020  ! 3694: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f46000  ! 3695: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3696: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebd04a0  ! 3697: STDA_R	stda	%r15, [%r20 + %r0] 0x25
	.word 0xd8f70e80  ! 3698: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	.word 0xd0d5a000  ! 3699: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r8
	.word 0xd09da000  ! 3700: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r8
	.word 0xdc8c4400  ! 3701: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	mov	0x7f0, %r20
	.word 0x87802072  ! 3703: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3704: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2afe000  ! 3705: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	mov	0x10, %r18
	.word 0xd2afa000  ! 3707: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	mov	0x7f8, %r20
	.word 0x8780204f  ! 3709: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2df2000  ! 3710: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	mov	0x7f8, %r23
	.word 0x8780204f  ! 3712: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd69e89e0  ! 3713: LDDA_R	ldda	[%r26, %r0] 0x4f, %r11
	mov	0x68, %r26
	.word 0xd88fce80  ! 3715: LDUBA_R	lduba	[%r31, %r0] 0x74, %r12
	.word 0xd88fe000  ! 3716: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0x87802074  ! 3717: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8dc6000  ! 3718: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	.word 0xd8f4a000  ! 3719: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xdca78e40  ! 3721: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	.word 0xd4b78e40  ! 3722: STHA_R	stha	%r10, [%r30 + %r0] 0x72
	.word 0xdc842000  ! 3723: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	.word 0xdcf4e000  ! 3724: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcd42000  ! 3725: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	.word 0xd8af4e40  ! 3726: STBA_R	stba	%r12, [%r29 + %r0] 0x72
	.word 0xdea4c400  ! 3727: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	.word 0xdad44400  ! 3728: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	mov	0x7f0, %r21
	.word 0xdebd44a0  ! 3730: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	.word 0xd4f42000  ! 3731: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 3732: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r17
	.word 0x87802074  ! 3734: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d8, %r23
	mov	0x10, %r16
	.word 0x87802025  ! 3737: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0878e40  ! 3738: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r8
	mov	0x3c0, %r20
	mov	0x18, %r16
	.word 0x87802025  ! 3741: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd096c9e0  ! 3742: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r8
	mov	0x68, %r27
	.word 0xd6bc0400  ! 3744: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0x87802020  ! 3745: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f42000  ! 3746: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0xd094e000  ! 3747: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	mov	0x7c0, %r21
	.word 0x87802074  ! 3749: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b62000  ! 3750: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0xd2d74e80  ! 3751: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r9
	mov	0x8, %r25
	.word 0xd2ce2000  ! 3753: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r9
	.word 0xdec7ce80  ! 3754: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r15
	mov	0x48, %r19
	mov	0x8, %r24
	.word 0xda9cc400  ! 3757: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	.word 0x87802072  ! 3758: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 3759: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e0, %r21
	mov	0x0, %r17
	.word 0xd0ae09e0  ! 3762: STBA_R	stba	%r8, [%r24 + %r0] 0x4f
	mov	0x8, %r25
	.word 0xd8948400  ! 3764: LDUHA_R	lduha	[%r18, %r0] 0x20, %r12
	.word 0xdacdc4a0  ! 3765: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r13
	mov	0x3d0, %r20
	mov	0x30, %r19
	.word 0xd2b66000  ! 3768: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	mov	0x7f8, %r23
	.word 0xd2bea000  ! 3770: STDA_I	stda	%r9, [%r26 + 0x0000] %asi
	.word 0xd8b70e40  ! 3771: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0xdef6a000  ! 3772: STXA_I	stxa	%r15, [%r26 + 0x0000] %asi
	.word 0xdef66000  ! 3773: STXA_I	stxa	%r15, [%r25 + 0x0000] %asi
	mov	0x30, %r26
	.word 0x87802073  ! 3775: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd485c4a0  ! 3776: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r10
	.word 0xdcd72000  ! 3777: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xd6844400  ! 3778: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r11
	.word 0xdccf6000  ! 3779: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdabe49e0  ! 3780: STDA_R	stda	%r13, [%r25 + %r0] 0x4f
	.word 0x8780204f  ! 3781: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 3782: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c0, %r23
	.word 0xd0afce80  ! 3784: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	.word 0xd6f6a000  ! 3785: STXA_I	stxa	%r11, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 3786: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f72000  ! 3787: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	mov	0x10, %r25
	.word 0xd6af6000  ! 3789: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x50, %r17
	.word 0xd6afa000  ! 3791: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xd6b689e0  ! 3793: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 3794: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf78e60  ! 3795: STXA_R	stxa	%r14, [%r30 + %r0] 0x73
	.word 0xdac7ce40  ! 3796: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r13
	.word 0xd2f74e40  ! 3797: STXA_R	stxa	%r9, [%r29 + %r0] 0x72
	.word 0xd6b6a000  ! 3798: STHA_I	stha	%r11, [%r26 + 0x0000] %asi
	.word 0xd6a66000  ! 3799: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	mov	0x3f8, %r22
	.word 0x87802020  ! 3801: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r18
	mov	0x7d8, %r23
	.word 0xd0ac0400  ! 3804: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	mov	0x60, %r25
	mov	0x40, %r27
	.word 0xd68ec9e0  ! 3807: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r11
	.word 0xd4ad6000  ! 3808: STBA_I	stba	%r10, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 3809: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4be6000  ! 3810: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 3811: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r17
	mov	0x20, %r19
	.word 0xd4946000  ! 3814: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r10
	.word 0xdab74e60  ! 3815: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	.word 0xd2bca000  ! 3816: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	mov	0x3f8, %r22
	.word 0xd6ac4400  ! 3818: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xd48fce40  ! 3819: LDUBA_R	lduba	[%r31, %r0] 0x72, %r10
	.word 0xdab74e60  ! 3820: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	mov	0x60, %r26
	.word 0xdc8ce000  ! 3822: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	mov	0x30, %r26
	.word 0xdadf8e40  ! 3824: LDXA_R	ldxa	[%r30, %r0] 0x72, %r13
	mov	0x20, %r27
	mov	0x78, %r26
	.word 0xdad78e60  ! 3827: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r13
	.word 0xd69f0e40  ! 3828: LDDA_R	ldda	[%r28, %r0] 0x72, %r11
	.word 0xd09c2000  ! 3829: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r8
	.word 0xd0cce000  ! 3830: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0xd09ca000  ! 3831: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	.word 0xd8f7ce60  ! 3832: STXA_R	stxa	%r12, [%r31 + %r0] 0x73
	.word 0x87802073  ! 3833: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6dfce60  ! 3834: LDXA_R	ldxa	[%r31, %r0] 0x73, %r11
	.word 0x8780204f  ! 3835: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c0, %r20
	.word 0xdcdca000  ! 3837: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	mov	0x20, %r24
	.word 0xdcb4e000  ! 3839: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xdc9c2000  ! 3840: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r14
	.word 0xdcb4a000  ! 3841: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xdef4c400  ! 3842: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xd8f609e0  ! 3843: STXA_R	stxa	%r12, [%r24 + %r0] 0x4f
	.word 0xd4b7ce80  ! 3844: STHA_R	stha	%r10, [%r31 + %r0] 0x74
	mov	0x3e8, %r21
	.word 0x87802072  ! 3846: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r27
	mov	0x50, %r19
	.word 0x87802020  ! 3849: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf78e80  ! 3850: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	.word 0xdca74e40  ! 3851: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	mov	0x28, %r27
	mov	0x20, %r24
	.word 0xdaa74e80  ! 3854: STWA_R	stwa	%r13, [%r29 + %r0] 0x74
	.word 0xd8f609e0  ! 3855: STXA_R	stxa	%r12, [%r24 + %r0] 0x4f
	.word 0xdc96c9e0  ! 3856: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r14
	.word 0xd4a48400  ! 3857: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xdaafce40  ! 3858: STBA_R	stba	%r13, [%r31 + %r0] 0x72
	.word 0xd8a40400  ! 3859: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0x87802072  ! 3860: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd886a000  ! 3861: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r12
	.word 0xd0de09e0  ! 3862: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r8
	.word 0xdc9ea000  ! 3863: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r14
	mov	0x10, %r27
	.word 0xda9cc400  ! 3865: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	mov	0x40, %r19
	.word 0x8780204f  ! 3867: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r18
	.word 0xdc8ec9e0  ! 3869: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r14
	.word 0x87802073  ! 3870: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd087ce60  ! 3871: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r8
	.word 0xd2df0e80  ! 3872: LDXA_R	ldxa	[%r28, %r0] 0x74, %r9
	.word 0xd6aca000  ! 3873: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xd6c46000  ! 3874: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3875: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcd44400  ! 3876: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	.word 0xd0bee000  ! 3877: STDA_I	stda	%r8, [%r27 + 0x0000] %asi
	mov	0x3f0, %r21
	.word 0xd08cc400  ! 3879: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	.word 0xde86e000  ! 3880: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r15
	.word 0xd6af4e40  ! 3881: STBA_R	stba	%r11, [%r29 + %r0] 0x72
	.word 0xdc96e000  ! 3882: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r14
	.word 0x87802025  ! 3883: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdccf6000  ! 3884: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xd8bc4400  ! 3885: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xdabcc400  ! 3886: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	.word 0x87802074  ! 3887: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2d4e000  ! 3888: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0xd0afce80  ! 3889: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	.word 0xd68c8400  ! 3890: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	.word 0xd2b48400  ! 3891: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0x87802025  ! 3892: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6df8e40  ! 3893: LDXA_R	ldxa	[%r30, %r0] 0x72, %r11
	.word 0xdcb609e0  ! 3894: STHA_R	stha	%r14, [%r24 + %r0] 0x4f
	.word 0xd8bf2000  ! 3895: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd8af2000  ! 3896: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xd8bfe000  ! 3897: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd8a72000  ! 3898: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd6bc0400  ! 3899: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xd2d44400  ! 3900: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r9
	.word 0xd287e000  ! 3901: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2bd04a0  ! 3902: STDA_R	stda	%r9, [%r20 + %r0] 0x25
	.word 0xd8df4e40  ! 3903: LDXA_R	ldxa	[%r29, %r0] 0x72, %r12
	.word 0xd6f70e40  ! 3904: STXA_R	stxa	%r11, [%r28 + %r0] 0x72
	.word 0xd6cf4e40  ! 3905: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r11
	mov	0x3f8, %r23
	.word 0xdebfa000  ! 3907: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xd6a70e80  ! 3908: STWA_R	stwa	%r11, [%r28 + %r0] 0x74
	.word 0xdc848400  ! 3909: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	.word 0xd0f7ce60  ! 3910: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	mov	0x3d0, %r22
	mov	0x3e0, %r20
	.word 0xdaf7e000  ! 3913: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	mov	0x3c8, %r22
	.word 0xd6cd04a0  ! 3915: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r11
	.word 0xda9c4400  ! 3916: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	.word 0x87802074  ! 3917: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d8, %r23
	.word 0xd697a000  ! 3919: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0xd6b7e000  ! 3920: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd8ce49e0  ! 3921: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r12
	.word 0xd4cf2000  ! 3922: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xda8f0e60  ! 3923: LDUBA_R	lduba	[%r28, %r0] 0x73, %r13
	.word 0x87802072  ! 3924: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf7e000  ! 3925: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xdad7a000  ! 3926: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0xda9cc400  ! 3927: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	.word 0xd4bf6000  ! 3928: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	mov	0x28, %r19
	.word 0xd4cf2000  ! 3930: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd2874e60  ! 3931: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r9
	.word 0xd2a40400  ! 3932: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd69f0e60  ! 3934: LDDA_R	ldda	[%r28, %r0] 0x73, %r11
	.word 0xd4940400  ! 3935: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	.word 0x8780204f  ! 3936: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf5e000  ! 3937: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0xdc9609e0  ! 3938: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r14
	.word 0xd0aec9e0  ! 3939: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	.word 0xd6a40400  ! 3940: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0x87802072  ! 3941: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6c48400  ! 3942: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	.word 0xd89ec9e0  ! 3943: LDDA_R	ldda	[%r27, %r0] 0x4f, %r12
	.word 0xdef4c400  ! 3944: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xdef4e000  ! 3945: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 3946: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c0, %r23
	.word 0xdace09e0  ! 3948: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r13
	mov	0x7e0, %r20
	.word 0xdc8c0400  ! 3950: LDUBA_R	lduba	[%r16, %r0] 0x20, %r14
	.word 0xde8f0e40  ! 3951: LDUBA_R	lduba	[%r28, %r0] 0x72, %r15
	.word 0x87802073  ! 3952: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2978e40  ! 3953: LDUHA_R	lduha	[%r30, %r0] 0x72, %r9
	.word 0xd6af6000  ! 3954: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xdeac4400  ! 3955: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0xd6df6000  ! 3956: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0x87802072  ! 3957: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf544a0  ! 3958: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	.word 0xd0cde000  ! 3959: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r8
	.word 0xd08d6000  ! 3960: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r8
	.word 0xd2af8e40  ! 3961: STBA_R	stba	%r9, [%r30 + %r0] 0x72
	.word 0xdea5e000  ! 3962: STWA_I	stwa	%r15, [%r23 + 0x0000] %asi
	.word 0xd8a70e60  ! 3963: STWA_R	stwa	%r12, [%r28 + %r0] 0x73
	.word 0x87802020  ! 3964: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc8cc400  ! 3965: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2f7e000  ! 3967: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd287e000  ! 3968: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	mov	0x18, %r18
	.word 0xd8cd04a0  ! 3970: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r12
	.word 0x87802072  ! 3971: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3972: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3973: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r18
	.word 0xd6970e60  ! 3975: LDUHA_R	lduha	[%r28, %r0] 0x73, %r11
	.word 0xd49c6000  ! 3976: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0xd4dca000  ! 3977: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	mov	0x3d0, %r21
	mov	0x48, %r25
	.word 0x87802073  ! 3980: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4aca000  ! 3981: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	mov	0x3c8, %r22
	.word 0xd4b46000  ! 3983: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xd4a46000  ! 3984: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xd4aca000  ! 3985: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0xd4f689e0  ! 3986: STXA_R	stxa	%r10, [%r26 + %r0] 0x4f
	.word 0xd6cc2000  ! 3987: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	.word 0x87802073  ! 3988: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb4c400  ! 3989: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xdacca000  ! 3990: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	.word 0xd68c8400  ! 3991: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	.word 0xd4aca000  ! 3992: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0xd49ca000  ! 3993: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd4f4a000  ! 3994: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0xd6cfce60  ! 3995: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r11
	.word 0xd8ac6000  ! 3996: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xd88ca000  ! 3997: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	.word 0x87802072  ! 3998: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcd78e80  ! 3999: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r14
	.word 0xd6cf2000  ! 4000: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	mov	0x18, %r24
	.word 0xd68f2000  ! 4002: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xd8b70e40  ! 4003: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0xd4cfe000  ! 4004: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0xd4c72000  ! 4005: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r10
	mov	0x3e0, %r23
	.word 0xdeac8400  ! 4007: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xd4dfce60  ! 4008: LDXA_R	ldxa	[%r31, %r0] 0x73, %r10
	.word 0x87802072  ! 4009: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb7e000  ! 4010: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xdcafe000  ! 4011: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xd4bfce80  ! 4012: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	.word 0x87802074  ! 4013: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6a5e000  ! 4014: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	.word 0xd4b74e60  ! 4015: STHA_R	stha	%r10, [%r29 + %r0] 0x73
	.word 0xd4df8e80  ! 4016: LDXA_R	ldxa	[%r30, %r0] 0x74, %r10
	.word 0x87802073  ! 4017: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xded62000  ! 4018: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r15
	.word 0xdeccc400  ! 4019: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r15
	mov	0x3d8, %r21
	.word 0xd6866000  ! 4021: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r11
	.word 0xdcf48400  ! 4022: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0x87802025  ! 4023: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r17
	.word 0xd2c76000  ! 4025: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0xd69c8400  ! 4026: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	.word 0xdc97e000  ! 4027: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xdcafa000  ! 4028: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xdcc7e000  ! 4029: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	mov	0x40, %r16
	.word 0x87802020  ! 4031: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r19
	.word 0xdaa4c400  ! 4033: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0xdcac0400  ! 4034: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	mov	0x18, %r24
	.word 0xdac5a000  ! 4036: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r13
	.word 0xd8f6c9e0  ! 4037: STXA_R	stxa	%r12, [%r27 + %r0] 0x4f
	.word 0xd09dc4a0  ! 4038: LDDA_R	ldda	[%r23, %r0] 0x25, %r8
	.word 0xda978e40  ! 4039: LDUHA_R	lduha	[%r30, %r0] 0x72, %r13
	.word 0xd0970e40  ! 4040: LDUHA_R	lduha	[%r28, %r0] 0x72, %r8
	mov	0x3c0, %r23
	mov	0x68, %r26
	.word 0xd4948400  ! 4043: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	.word 0xd4970e80  ! 4044: LDUHA_R	lduha	[%r28, %r0] 0x74, %r10
	.word 0xda85e000  ! 4045: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	.word 0xd6acc400  ! 4046: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xd0cc4400  ! 4047: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	mov	0x7f8, %r22
	.word 0xdaada000  ! 4049: STBA_I	stba	%r13, [%r22 + 0x0000] %asi
	.word 0xdaad6000  ! 4050: STBA_I	stba	%r13, [%r21 + 0x0000] %asi
	.word 0xdaa5a000  ! 4051: STWA_I	stwa	%r13, [%r22 + 0x0000] %asi
	.word 0xdcadc4a0  ! 4052: STBA_R	stba	%r14, [%r23 + %r0] 0x25
	mov	0x7c8, %r21
	.word 0xd8cd2000  ! 4054: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r12
	.word 0x87802072  ! 4055: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8dfa000  ! 4056: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	mov	0x30, %r27
	.word 0x87802020  ! 4058: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8be6000  ! 4059: STDA_I	stda	%r12, [%r25 + 0x0000] %asi
	mov	0x68, %r24
	.word 0xd8d6e000  ! 4061: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r12
	.word 0xd4b74e60  ! 4062: STHA_R	stha	%r10, [%r29 + %r0] 0x73
	.word 0xdc8f0e40  ! 4063: LDUBA_R	lduba	[%r28, %r0] 0x72, %r14
	.word 0x87802073  ! 4064: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f8, %r23
	.word 0xdebea000  ! 4066: STDA_I	stda	%r15, [%r26 + 0x0000] %asi
	.word 0x87802074  ! 4067: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r27
	.word 0xdcbd44a0  ! 4069: STDA_R	stda	%r14, [%r21 + %r0] 0x25
	.word 0xd0f74e40  ! 4070: STXA_R	stxa	%r8, [%r29 + %r0] 0x72
	mov	0x18, %r26
	.word 0xdccf0e80  ! 4072: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r14
	mov	0x18, %r17
	.word 0x87802074  ! 4074: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f48400  ! 4075: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0x87802073  ! 4076: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdedd2000  ! 4077: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r15
	.word 0xde978e40  ! 4078: LDUHA_R	lduha	[%r30, %r0] 0x72, %r15
	.word 0xd2cde000  ! 4079: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r9
	.word 0xd28d6000  ! 4080: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r9
	.word 0xd08cc400  ! 4081: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	mov	0x78, %r18
	mov	0x7e8, %r22
	.word 0xdcc40400  ! 4084: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	.word 0xd485a000  ! 4085: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r10
	.word 0xd697ce40  ! 4086: LDUHA_R	lduha	[%r31, %r0] 0x72, %r11
	.word 0xde8d2000  ! 4087: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r15
	.word 0x87802074  ! 4088: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r18
	.word 0x87802073  ! 4090: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb4a000  ! 4091: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x70, %r18
	.word 0xdeace000  ! 4094: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 4095: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b78e60  ! 4096: STHA_R	stha	%r11, [%r30 + %r0] 0x73
	mov	0x40, %r27
	mov	0x68, %r24
	mov	0x68, %r24
	.word 0xd8b48400  ! 4100: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0xd6d5a000  ! 4101: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r11
	.word 0xd6b5e000  ! 4102: STHA_I	stha	%r11, [%r23 + 0x0000] %asi
	.word 0xd0aec9e0  ! 4103: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	.word 0xd2b74e40  ! 4104: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	.word 0xd0952000  ! 4105: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r8
	.word 0xd4f74e80  ! 4106: STXA_R	stxa	%r10, [%r29 + %r0] 0x74
	mov	0x50, %r19
	.word 0xd0ddc4a0  ! 4108: LDXA_R	ldxa	[%r23, %r0] 0x25, %r8
	.word 0xdab52000  ! 4109: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	.word 0xdc9f0e40  ! 4110: LDDA_R	ldda	[%r28, %r0] 0x72, %r14
	.word 0xd0ac8400  ! 4111: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	mov	0x3f8, %r21
	.word 0x87802074  ! 4113: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4114: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b74e40  ! 4115: STHA_R	stha	%r8, [%r29 + %r0] 0x72
	.word 0xd6d74e60  ! 4116: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r11
	.word 0xd4cf0e80  ! 4117: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r10
	.word 0xd2c48400  ! 4118: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0xd6b4e000  ! 4119: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xd0ce49e0  ! 4120: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r8
	.word 0xd4df4e80  ! 4121: LDXA_R	ldxa	[%r29, %r0] 0x74, %r10
	mov	0x30, %r17
	.word 0xd6b4a000  ! 4123: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd8848400  ! 4124: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r12
	mov	0x3c0, %r20
	mov	0x70, %r19
	mov	0x50, %r17
	mov	0x78, %r27
	.word 0x87802020  ! 4129: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r18
	.word 0xd29f0e80  ! 4131: LDDA_R	ldda	[%r28, %r0] 0x74, %r9
	mov	0x28, %r17
	.word 0x87802072  ! 4133: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 4134: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r25
	.word 0xd48d6000  ! 4136: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r10
	mov	0x10, %r25
	.word 0x87802020  ! 4138: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r22
	.word 0xd4cf8e80  ! 4140: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r10
	.word 0xd6a7ce60  ! 4141: STWA_R	stwa	%r11, [%r31 + %r0] 0x73
	.word 0xdca70e80  ! 4142: STWA_R	stwa	%r14, [%r28 + %r0] 0x74
	mov	0x50, %r24
	.word 0xde9e89e0  ! 4144: LDDA_R	ldda	[%r26, %r0] 0x4f, %r15
	.word 0xd0b6c9e0  ! 4145: STHA_R	stha	%r8, [%r27 + %r0] 0x4f
	mov	0x78, %r26
	.word 0xdeaf6000  ! 4147: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	mov	0x8, %r24
	.word 0xde8fe000  ! 4149: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0xde8fe000  ! 4150: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0xdea7e000  ! 4151: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xde972000  ! 4152: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 4153: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 4154: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 4155: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde9c2000  ! 4156: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xd6b609e0  ! 4157: STHA_R	stha	%r11, [%r24 + %r0] 0x4f
	.word 0xd0d4a000  ! 4158: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	.word 0xd8ac8400  ! 4159: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 4160: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6a544a0  ! 4161: STWA_R	stwa	%r11, [%r21 + %r0] 0x25
	mov	0x40, %r17
	.word 0xdecdc4a0  ! 4163: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r15
	.word 0xdcbfa000  ! 4164: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdc84c400  ! 4165: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	mov	0x38, %r24
	.word 0x87802020  ! 4167: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a62000  ! 4168: STWA_I	stwa	%r11, [%r24 + 0x0000] %asi
	mov	0x7e0, %r21
	.word 0xd2acc400  ! 4170: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0xd4d6e000  ! 4171: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r10
	.word 0xdaa78e40  ! 4172: STWA_R	stwa	%r13, [%r30 + %r0] 0x72
	.word 0xded78e80  ! 4173: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r15
	.word 0xd6c70e40  ! 4174: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r11
	.word 0xdcdf8e60  ! 4175: LDXA_R	ldxa	[%r30, %r0] 0x73, %r14
	.word 0xd486a000  ! 4176: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r10
	.word 0xd6f74e80  ! 4177: STXA_R	stxa	%r11, [%r29 + %r0] 0x74
	.word 0xd2be2000  ! 4178: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	.word 0xd6f40400  ! 4179: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	.word 0xd4cfce80  ! 4180: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r10
	.word 0xdad6a000  ! 4181: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4182: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bc4400  ! 4183: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xd0f5c4a0  ! 4184: STXA_R	stxa	%r8, [%r23 + %r0] 0x25
	.word 0xd4874e80  ! 4185: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r10
	.word 0xd2f7e000  ! 4186: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xda8dc4a0  ! 4187: LDUBA_R	lduba	[%r23, %r0] 0x25, %r13
	.word 0xd2ccc400  ! 4188: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	.word 0xde9504a0  ! 4189: LDUHA_R	lduha	[%r20, %r0] 0x25, %r15
	mov	0x3d8, %r22
	.word 0xd4bfa000  ! 4191: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd4cf0e80  ! 4192: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r10
	mov	0x68, %r19
	mov	0x58, %r18
	.word 0xd2bfe000  ! 4195: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd4b689e0  ! 4196: STHA_R	stha	%r10, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 4197: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 4198: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde94e000  ! 4199: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	.word 0xde8ce000  ! 4200: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	.word 0xd2f78e40  ! 4201: STXA_R	stxa	%r9, [%r30 + %r0] 0x72
	.word 0xdca42000  ! 4202: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 4203: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcc56000  ! 4204: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r14
	.word 0xdcad2000  ! 4205: STBA_I	stba	%r14, [%r20 + 0x0000] %asi
	mov	0x3e0, %r21
	.word 0xd6a609e0  ! 4207: STWA_R	stwa	%r11, [%r24 + %r0] 0x4f
	.word 0xd8cd2000  ! 4208: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r12
	.word 0xd8f5a000  ! 4209: STXA_I	stxa	%r12, [%r22 + 0x0000] %asi
	.word 0xd8a56000  ! 4210: STWA_I	stwa	%r12, [%r21 + 0x0000] %asi
	mov	0x3d8, %r20
	mov	0x0, %r26
	mov	0x18, %r16
	.word 0xdcc6c9e0  ! 4214: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r14
	mov	0x48, %r24
	.word 0xdeb56000  ! 4216: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	mov	0x60, %r19
	.word 0xd4cf8e80  ! 4218: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r10
	mov	0x70, %r16
	.word 0xdabcc400  ! 4220: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	mov	0x48, %r26
	.word 0x87802072  ! 4222: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6cfa000  ! 4223: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0xdacc8400  ! 4224: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r13
	.word 0xdc978e80  ! 4225: LDUHA_R	lduha	[%r30, %r0] 0x74, %r14
	.word 0x87802074  ! 4226: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r24
	.word 0xd0bf6000  ! 4228: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xdcd78e40  ! 4229: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r14
	mov	0x70, %r17
	.word 0x87802074  ! 4231: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e0, %r23
	.word 0x87802020  ! 4233: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r22
	mov	0x3f8, %r21
	mov	0x68, %r24
	.word 0xd8dce000  ! 4237: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	mov	0x78, %r26
	mov	0x10, %r26
	.word 0xd8d4a000  ! 4240: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xd8d42000  ! 4241: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0xd8d4e000  ! 4242: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	mov	0x20, %r16
	mov	0x48, %r24
	.word 0x87802025  ! 4245: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f74e40  ! 4246: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	.word 0xd0dfa000  ! 4247: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0xda87ce80  ! 4248: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r13
	.word 0x87802020  ! 4249: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc84a000  ! 4250: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	mov	0x10, %r17
	mov	0x28, %r27
	.word 0xd8bd84a0  ! 4253: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	.word 0x87802025  ! 4254: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 4255: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4256: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf7a000  ! 4257: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcbf2000  ! 4258: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	mov	0x7f8, %r23
	.word 0x87802074  ! 4260: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 4261: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc870e80  ! 4262: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r14
	.word 0x87802072  ! 4263: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r27
	.word 0xd2f4e000  ! 4265: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd294a000  ! 4266: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r9
	.word 0xd2d4a000  ! 4267: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	.word 0x87802073  ! 4268: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d0, %r21
	.word 0xd2b62000  ! 4270: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 4271: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d48400  ! 4272: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0xda9dc4a0  ! 4273: LDDA_R	ldda	[%r23, %r0] 0x25, %r13
	mov	0x68, %r25
	mov	0x8, %r27
	.word 0x87802072  ! 4276: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f8, %r23
	.word 0xd09f6000  ! 4278: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	.word 0xd2d4c400  ! 4279: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r9
	.word 0xd8b76000  ! 4280: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd8cf2000  ! 4281: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0xd8f7a000  ! 4282: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd4d584a0  ! 4283: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r10
	.word 0xdac7a000  ! 4284: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xd2bc8400  ! 4285: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	mov	0x40, %r25
	.word 0xdeb7a000  ! 4287: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xd6c609e0  ! 4288: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r11
	.word 0xdaaf4e40  ! 4289: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	.word 0xda9fa000  ! 4290: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	mov	0x3e8, %r21
	mov	0x38, %r16
	.word 0x87802020  ! 4293: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r26
	.word 0xd48dc4a0  ! 4295: LDUBA_R	lduba	[%r23, %r0] 0x25, %r10
	.word 0xd2b44400  ! 4296: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	mov	0x20, %r17
	.word 0xd897e000  ! 4298: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	mov	0x28, %r17
	mov	0x78, %r27
	.word 0xdabc0400  ! 4301: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0x87802072  ! 4302: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0a52000  ! 4303: STWA_I	stwa	%r8, [%r20 + 0x0000] %asi
	.word 0xd0bda000  ! 4304: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	.word 0xd0bd6000  ! 4305: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0xd0bda000  ! 4306: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	.word 0x8780204f  ! 4307: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6dfce40  ! 4308: LDXA_R	ldxa	[%r31, %r0] 0x72, %r11
	mov	0x60, %r17
	mov	0x10, %r16
	.word 0xdeb48400  ! 4311: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xd8af0e80  ! 4312: STBA_R	stba	%r12, [%r28 + %r0] 0x74
	.word 0xdcf5e000  ! 4313: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 4314: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdadd84a0  ! 4315: LDXA_R	ldxa	[%r22, %r0] 0x25, %r13
	.word 0xdcb52000  ! 4316: STHA_I	stha	%r14, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 4317: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r27
	.word 0xdcdea000  ! 4319: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r14
	.word 0xd49d84a0  ! 4320: LDDA_R	ldda	[%r22, %r0] 0x25, %r10
	.word 0x87802020  ! 4321: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r18
	.word 0xdc870e80  ! 4323: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r14
	.word 0x87802073  ! 4324: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda97ce80  ! 4325: LDUHA_R	lduha	[%r31, %r0] 0x74, %r13
	.word 0xda9f6000  ! 4326: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xdaa7a000  ! 4327: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xdccf8e80  ! 4329: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r14
	.word 0x87802025  ! 4330: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 4331: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r16
	.word 0xd2a7a000  ! 4333: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xdca44400  ! 4334: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0x87802025  ! 4335: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4874e40  ! 4336: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r10
	.word 0x87802072  ! 4337: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r17
	.word 0xdc9f6000  ! 4339: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xdc8fe000  ! 4340: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	mov	0x48, %r16
	.word 0x87802072  ! 4342: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcdca000  ! 4343: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xdcd42000  ! 4344: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4345: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcacc400  ! 4346: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	mov	0x3c0, %r21
	.word 0xd6a46000  ! 4348: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0xd4df8e60  ! 4349: LDXA_R	ldxa	[%r30, %r0] 0x73, %r10
	mov	0x40, %r16
	.word 0xd0bc2000  ! 4351: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	mov	0x7d0, %r22
	.word 0xd6bf0e60  ! 4353: STDA_R	stda	%r11, [%r28 + %r0] 0x73
	.word 0xdaa584a0  ! 4354: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	.word 0x87802020  ! 4355: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68c8400  ! 4356: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	mov	0x0, %r24
	mov	0x50, %r26
	.word 0xdc84e000  ! 4359: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r14
	.word 0xdeaf4e60  ! 4360: STBA_R	stba	%r15, [%r29 + %r0] 0x73
	.word 0xdebca000  ! 4361: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 4362: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r27
	mov	0x38, %r19
	.word 0x87802074  ! 4365: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4874e40  ! 4366: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r10
	.word 0xd0d78e40  ! 4367: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r8
	.word 0xd8b46000  ! 4368: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	mov	0x3f0, %r22
	mov	0x3f0, %r21
	.word 0xd6c584a0  ! 4371: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r11
	.word 0x8780204f  ! 4372: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a584a0  ! 4373: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	.word 0xdc944400  ! 4374: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	.word 0xd8f76000  ! 4375: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 4376: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 4377: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8d52000  ! 4378: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r12
	.word 0xd8dde000  ! 4379: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r12
	.word 0xdedc4400  ! 4380: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	.word 0xdaa70e40  ! 4381: STWA_R	stwa	%r13, [%r28 + %r0] 0x72
	.word 0xdcada000  ! 4382: STBA_I	stba	%r14, [%r22 + 0x0000] %asi
	.word 0x87802025  ! 4383: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c0, %r20
	.word 0xdcdde000  ! 4385: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	.word 0xdca5e000  ! 4386: STWA_I	stwa	%r14, [%r23 + 0x0000] %asi
	mov	0x50, %r27
	.word 0xd8848400  ! 4388: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r12
	mov	0x38, %r25
	.word 0xdaade000  ! 4390: STBA_I	stba	%r13, [%r23 + 0x0000] %asi
	.word 0xdecf8e80  ! 4391: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r15
	mov	0x8, %r16
	.word 0xd6cf4e40  ! 4393: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r11
	.word 0xd4856000  ! 4394: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r10
	.word 0x87802020  ! 4395: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xda878e40  ! 4397: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r13
	.word 0x8780204f  ! 4398: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4399: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r24
	mov	0x10, %r17
	.word 0xd2b7a000  ! 4402: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xde970e60  ! 4403: LDUHA_R	lduha	[%r28, %r0] 0x73, %r15
	mov	0x18, %r27
	.word 0xdeb76000  ! 4405: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xdec72000  ! 4406: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xdec76000  ! 4407: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xdeaf6000  ! 4408: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	mov	0x8, %r19
	.word 0xd6df8e60  ! 4410: LDXA_R	ldxa	[%r30, %r0] 0x73, %r11
	.word 0xd6f7a000  ! 4411: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	mov	0x40, %r16
	.word 0x87802020  ! 4413: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69f2000  ! 4414: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xde8e49e0  ! 4415: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r15
	.word 0xd49f6000  ! 4416: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0xdaf74e40  ! 4417: STXA_R	stxa	%r13, [%r29 + %r0] 0x72
	.word 0xd6af8e80  ! 4418: STBA_R	stba	%r11, [%r30 + %r0] 0x74
	mov	0x10, %r24
	.word 0xde940400  ! 4420: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	mov	0x3e0, %r22
	mov	0x0, %r26
	.word 0xd6d689e0  ! 4423: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r11
	.word 0xde9dc4a0  ! 4424: LDDA_R	ldda	[%r23, %r0] 0x25, %r15
	.word 0x87802025  ! 4425: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd48f2000  ! 4426: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd6cf0e80  ! 4427: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r11
	.word 0xd8876000  ! 4428: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8cf6000  ! 4429: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4430: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r17
	.word 0xd88fe000  ! 4432: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8f7a000  ! 4433: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8b76000  ! 4434: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 4435: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 4436: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8d4e000  ! 4437: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0xd89c2000  ! 4438: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	mov	0x50, %r26
	.word 0xd894e000  ! 4440: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r12
	.word 0xdcc7ce60  ! 4441: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r14
	.word 0xd4d70e40  ! 4442: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r10
	.word 0xdccdc4a0  ! 4443: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r14
	.word 0xde8c0400  ! 4444: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0xdab4e000  ! 4445: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xdacc6000  ! 4446: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	.word 0xdaa46000  ! 4447: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 4448: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac7ce80  ! 4449: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r13
	.word 0xdcd44400  ! 4450: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	.word 0x87802074  ! 4451: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r27
	.word 0xdaf7a000  ! 4453: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	mov	0x20, %r18
	.word 0xd68e09e0  ! 4455: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r11
	mov	0x58, %r18
	mov	0x60, %r16
	.word 0x87802025  ! 4458: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c0, %r21
	.word 0xd8ace000  ! 4460: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	mov	0x10, %r17
	.word 0x87802073  ! 4462: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r16
	.word 0x8780204f  ! 4464: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r27
	.word 0xd8b544a0  ! 4466: STHA_R	stha	%r12, [%r21 + %r0] 0x25
	mov	0x78, %r27
	.word 0xd49c2000  ! 4468: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	.word 0xd4d74e80  ! 4469: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r10
	.word 0xd0af4e80  ! 4470: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	mov	0x78, %r26
	.word 0x8780204f  ! 4472: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b609e0  ! 4473: STHA_R	stha	%r11, [%r24 + %r0] 0x4f
	.word 0xd6dca000  ! 4474: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r11
	.word 0x87802020  ! 4475: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f7e000  ! 4476: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd68f2000  ! 4477: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xd68f6000  ! 4478: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6af2000  ! 4479: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd0f7ce80  ! 4480: STXA_R	stxa	%r8, [%r31 + %r0] 0x74
	.word 0xdec72000  ! 4481: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xdef72000  ! 4482: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xd4cc8400  ! 4483: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	.word 0xd0c76000  ! 4484: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0df6000  ! 4485: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0x87802073  ! 4486: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4487: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4488: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4489: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 4490: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f78e40  ! 4491: STXA_R	stxa	%r12, [%r30 + %r0] 0x72
	mov	0x58, %r26
	mov	0x7d8, %r20
	.word 0x8780204f  ! 4494: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bfa000  ! 4495: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd08c8400  ! 4496: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	mov	0x28, %r16
	mov	0x48, %r25
	.word 0x8780204f  ! 4499: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabfce60  ! 4500: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 4501: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdac7e000  ! 4502: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4503: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda84e000  ! 4504: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r13
	mov	0x78, %r18
	.word 0x87802020  ! 4506: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r21
	.word 0xdab56000  ! 4508: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xd2bf0e40  ! 4510: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	.word 0xd4dda000  ! 4511: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r10
	.word 0xdc940400  ! 4512: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0x87802073  ! 4513: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb7ce40  ! 4514: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	.word 0xdebc4400  ! 4515: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0xd4af8e80  ! 4516: STBA_R	stba	%r10, [%r30 + %r0] 0x74
	mov	0x60, %r18
	.word 0xd0df0e60  ! 4518: LDXA_R	ldxa	[%r28, %r0] 0x73, %r8
	.word 0x87802025  ! 4519: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdac7e000  ! 4520: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xd0bfce60  ! 4521: STDA_R	stda	%r8, [%r31 + %r0] 0x73
	.word 0x87802074  ! 4522: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b5a000  ! 4523: STHA_I	stha	%r11, [%r22 + 0x0000] %asi
	mov	0x18, %r18
	.word 0xd685e000  ! 4525: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r11
	mov	0x7c8, %r20
	.word 0xd4af0e40  ! 4527: STBA_R	stba	%r10, [%r28 + %r0] 0x72
	.word 0xd4f78e60  ! 4528: STXA_R	stxa	%r10, [%r30 + %r0] 0x73
	.word 0xd6b74e80  ! 4529: STHA_R	stha	%r11, [%r29 + %r0] 0x74
	.word 0xd4ad04a0  ! 4530: STBA_R	stba	%r10, [%r20 + %r0] 0x25
	mov	0x3c0, %r21
	.word 0x87802073  ! 4532: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2c62000  ! 4533: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r9
	.word 0xd2b62000  ! 4534: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	.word 0xd2c6a000  ! 4535: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r9
	mov	0x78, %r16
	.word 0xdec40400  ! 4537: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xd2c62000  ! 4538: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r9
	.word 0xd2b6a000  ! 4539: STHA_I	stha	%r9, [%r26 + 0x0000] %asi
	.word 0xd2966000  ! 4540: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r9
	.word 0xd6cf4e40  ! 4541: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r11
	.word 0xd4f6a000  ! 4542: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	.word 0xd09e49e0  ! 4543: LDDA_R	ldda	[%r25, %r0] 0x4f, %r8
	.word 0xdeb7ce40  ! 4544: STHA_R	stha	%r15, [%r31 + %r0] 0x72
	.word 0xd2b40400  ! 4545: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0xdca78e60  ! 4546: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	.word 0xd2b74e80  ! 4547: STHA_R	stha	%r9, [%r29 + %r0] 0x74
	.word 0xd2b70e60  ! 4548: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	.word 0xd08fce60  ! 4549: LDUBA_R	lduba	[%r31, %r0] 0x73, %r8
	.word 0x87802074  ! 4550: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e0, %r23
	mov	0x3d0, %r21
	.word 0x87802073  ! 4553: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcdce000  ! 4554: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r14
	.word 0xdcbce000  ! 4555: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xdea7ce60  ! 4556: STWA_R	stwa	%r15, [%r31 + %r0] 0x73
	.word 0x87802020  ! 4557: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cc6000  ! 4558: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	.word 0xd4dca000  ! 4559: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	.word 0x87802020  ! 4560: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x58, %r17
	.word 0xd2c74e60  ! 4563: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r9
	mov	0x40, %r25
	.word 0xdaa74e80  ! 4565: STWA_R	stwa	%r13, [%r29 + %r0] 0x74
	.word 0xd8ad84a0  ! 4566: STBA_R	stba	%r12, [%r22 + %r0] 0x25
	.word 0x8780204f  ! 4567: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd896a000  ! 4568: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r12
	.word 0xd8b66000  ! 4569: STHA_I	stha	%r12, [%r25 + 0x0000] %asi
	.word 0xd8a66000  ! 4570: STWA_I	stwa	%r12, [%r25 + 0x0000] %asi
	mov	0x7c8, %r22
	.word 0xdcb40400  ! 4572: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xd6f6e000  ! 4573: STXA_I	stxa	%r11, [%r27 + 0x0000] %asi
	.word 0xd6d6e000  ! 4574: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r11
	.word 0xd0a504a0  ! 4575: STWA_R	stwa	%r8, [%r20 + %r0] 0x25
	.word 0xd887ce40  ! 4576: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r12
	mov	0x70, %r16
	.word 0x87802072  ! 4578: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f6c9e0  ! 4579: STXA_R	stxa	%r9, [%r27 + %r0] 0x4f
	.word 0xdade89e0  ! 4580: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r13
	.word 0x87802020  ! 4581: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4582: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 4583: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a70e60  ! 4584: STWA_R	stwa	%r8, [%r28 + %r0] 0x73
	.word 0x87802020  ! 4585: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf74e80  ! 4586: STXA_R	stxa	%r14, [%r29 + %r0] 0x74
	.word 0xd49f0e60  ! 4587: LDDA_R	ldda	[%r28, %r0] 0x73, %r10
	.word 0x87802073  ! 4588: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r26
	.word 0xd68d44a0  ! 4590: LDUBA_R	lduba	[%r21, %r0] 0x25, %r11
	.word 0xdab6e000  ! 4591: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	mov	0x48, %r17
	mov	0x78, %r25
	mov	0x7f0, %r20
	.word 0x87802020  ! 4595: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4596: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r27
	mov	0x50, %r26
	.word 0x87802025  ! 4599: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdadc0400  ! 4600: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	.word 0xd4f6a000  ! 4601: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0x87802074  ! 4603: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4c4a000  ! 4604: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	mov	0x50, %r26
	mov	0x30, %r24
	.word 0xd6b689e0  ! 4607: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	mov	0x8, %r16
	.word 0x87802074  ! 4609: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2cd2000  ! 4610: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r9
	.word 0xd6bf0e40  ! 4611: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	.word 0xd49dc4a0  ! 4612: LDDA_R	ldda	[%r23, %r0] 0x25, %r10
	.word 0xd887ce40  ! 4613: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r12
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x78, %r24
	.word 0xd2856000  ! 4616: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r9
	.word 0xd2ada000  ! 4617: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xde970e40  ! 4618: LDUHA_R	lduha	[%r28, %r0] 0x72, %r15
	.word 0xd6bc8400  ! 4619: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xd2acc400  ! 4620: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0xd2b5a000  ! 4621: STHA_I	stha	%r9, [%r22 + 0x0000] %asi
	.word 0xd6f40400  ! 4622: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	mov	0x28, %r25
	.word 0xdeafce40  ! 4624: STBA_R	stba	%r15, [%r31 + %r0] 0x72
	.word 0xd2856000  ! 4625: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r9
	.word 0xd2f5e000  ! 4626: STXA_I	stxa	%r9, [%r23 + 0x0000] %asi
	.word 0xd2a56000  ! 4627: STWA_I	stwa	%r9, [%r21 + 0x0000] %asi
	.word 0xd28fce40  ! 4628: LDUBA_R	lduba	[%r31, %r0] 0x72, %r9
	.word 0xdebc4400  ! 4629: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0xd0dfce40  ! 4630: LDXA_R	ldxa	[%r31, %r0] 0x72, %r8
	mov	0x7c8, %r21
	mov	0x30, %r16
	.word 0xd2c5a000  ! 4633: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r9
	mov	0x3f0, %r22
	.word 0xd4d609e0  ! 4635: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r10
	.word 0x87802074  ! 4636: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8940400  ! 4637: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	.word 0xd8ae6000  ! 4638: STBA_I	stba	%r12, [%r25 + 0x0000] %asi
	.word 0xd8dea000  ! 4639: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r12
	mov	0x30, %r18
	.word 0x8780204f  ! 4641: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8c76000  ! 4642: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	mov	0x48, %r19
	.word 0xd8bf6000  ! 4644: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	mov	0x58, %r19
	mov	0x7e0, %r20
	.word 0xd8a72000  ! 4647: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd2ad84a0  ! 4648: STBA_R	stba	%r9, [%r22 + %r0] 0x25
	.word 0xdecfe000  ! 4649: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	mov	0x30, %r16
	.word 0x8780204f  ! 4651: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdadcc400  ! 4652: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xd2d5a000  ! 4653: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r9
	mov	0x10, %r27
	.word 0xd2bda000  ! 4655: STDA_I	stda	%r9, [%r22 + 0x0000] %asi
	.word 0xd28de000  ! 4656: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r9
	.word 0x87802074  ! 4657: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28e2000  ! 4658: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	mov	0x48, %r19
	.word 0xd2a62000  ! 4660: STWA_I	stwa	%r9, [%r24 + 0x0000] %asi
	.word 0xd2d66000  ! 4661: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r9
	.word 0x87802020  ! 4662: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6aec9e0  ! 4663: STBA_R	stba	%r11, [%r27 + %r0] 0x4f
	.word 0xd6bfa000  ! 4664: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd6af2000  ! 4665: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 4666: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r19
	mov	0x38, %r27
	mov	0x10, %r17
	.word 0x87802020  ! 4670: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r17
	.word 0xd6bd6000  ! 4672: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0xd6b5e000  ! 4673: STHA_I	stha	%r11, [%r23 + 0x0000] %asi
	.word 0xd6f70e40  ! 4674: STXA_R	stxa	%r11, [%r28 + %r0] 0x72
	.word 0xde856000  ! 4675: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r15
	.word 0xdef5e000  ! 4676: STXA_I	stxa	%r15, [%r23 + 0x0000] %asi
	mov	0x10, %r25
	mov	0x3d0, %r21
	.word 0xd894c400  ! 4679: LDUHA_R	lduha	[%r19, %r0] 0x20, %r12
	mov	0x38, %r19
	mov	0x78, %r16
	.word 0xd0df8e80  ! 4682: LDXA_R	ldxa	[%r30, %r0] 0x74, %r8
	mov	0x78, %r19
	mov	0x18, %r26
	mov	0x70, %r17
	mov	0x48, %r19
	mov	0x28, %r27
	.word 0xd8a70e60  ! 4688: STWA_R	stwa	%r12, [%r28 + %r0] 0x73
	.word 0xdad5e000  ! 4689: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r13
	.word 0xdaa56000  ! 4690: STWA_I	stwa	%r13, [%r21 + 0x0000] %asi
	.word 0xda852000  ! 4691: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 4692: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdacf2000  ! 4693: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xdabfa000  ! 4694: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xdacf0e60  ! 4696: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r13
	.word 0xdac7e000  ! 4697: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xdaa72000  ! 4698: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xdaa72000  ! 4699: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	mov	0x20, %r16
	.word 0xdaf4c400  ! 4701: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	mov	0x7c8, %r21
	.word 0xdc86c9e0  ! 4703: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r14
	.word 0x8780204f  ! 4704: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b504a0  ! 4705: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	mov	0x8, %r17
	.word 0xdcb5c4a0  ! 4707: STHA_R	stha	%r14, [%r23 + %r0] 0x25
	.word 0xd886e000  ! 4708: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r12
	mov	0x30, %r19
	mov	0x78, %r24
	mov	0x7e0, %r22
	.word 0xd8b6e000  ! 4712: STHA_I	stha	%r12, [%r27 + 0x0000] %asi
	.word 0xd8a6a000  ! 4713: STWA_I	stwa	%r12, [%r26 + 0x0000] %asi
	.word 0xd8bea000  ! 4714: STDA_I	stda	%r12, [%r26 + 0x0000] %asi
	.word 0xd8b66000  ! 4715: STHA_I	stha	%r12, [%r25 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xdcb48400  ! 4717: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	mov	0x50, %r19
	mov	0x3e8, %r22
	.word 0xd8de6000  ! 4720: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r12
	mov	0x10, %r24
	mov	0x3c0, %r20
	.word 0xd0f44400  ! 4723: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	mov	0x7d0, %r23
	.word 0x87802072  ! 4725: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4726: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r26
	.word 0xd6a46000  ! 4728: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xd6bc2000  ! 4730: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0xd2b544a0  ! 4731: STHA_R	stha	%r9, [%r21 + %r0] 0x25
	mov	0x3f0, %r22
	.word 0xd68ce000  ! 4733: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	.word 0xdcaf4e80  ! 4734: STBA_R	stba	%r14, [%r29 + %r0] 0x74
	.word 0x87802074  ! 4735: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdebd84a0  ! 4736: STDA_R	stda	%r15, [%r22 + %r0] 0x25
	.word 0xdccde000  ! 4737: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r14
	.word 0xdcd56000  ! 4738: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r14
	.word 0xdcad6000  ! 4739: STBA_I	stba	%r14, [%r21 + 0x0000] %asi
	.word 0xdcbd2000  ! 4740: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	.word 0xdcf5e000  ! 4741: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0xdccda000  ! 4742: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r14
	.word 0xd0a78e80  ! 4743: STWA_R	stwa	%r8, [%r30 + %r0] 0x74
	.word 0xd69ec9e0  ! 4744: LDDA_R	ldda	[%r27, %r0] 0x4f, %r11
	.word 0xd4dd84a0  ! 4745: LDXA_R	ldxa	[%r22, %r0] 0x25, %r10
	.word 0x8780204f  ! 4746: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4747: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r24
	mov	0x58, %r17
	.word 0x87802020  ! 4750: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde970e80  ! 4751: LDUHA_R	lduha	[%r28, %r0] 0x74, %r15
	.word 0x8780204f  ! 4752: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r18
	.word 0xd2aee000  ! 4754: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	.word 0xd4f649e0  ! 4755: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	.word 0xd2c7ce80  ! 4756: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r9
	.word 0xd696e000  ! 4757: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	.word 0xdcb609e0  ! 4758: STHA_R	stha	%r14, [%r24 + %r0] 0x4f
	.word 0x87802072  ! 4759: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f0, %r23
	.word 0xd4cfce40  ! 4761: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r10
	.word 0xd2c52000  ! 4762: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r9
	.word 0xd2a52000  ! 4763: STWA_I	stwa	%r9, [%r20 + 0x0000] %asi
	.word 0xdacf8e40  ! 4764: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r13
	.word 0xd4d5a000  ! 4765: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r10
	.word 0xd4a5e000  ! 4766: STWA_I	stwa	%r10, [%r23 + 0x0000] %asi
	.word 0xd4dd2000  ! 4767: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r10
	.word 0xd4b52000  ! 4768: STHA_I	stha	%r10, [%r20 + 0x0000] %asi
	.word 0xd4bec9e0  ! 4769: STDA_R	stda	%r10, [%r27 + %r0] 0x4f
	.word 0xd0dda000  ! 4770: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r8
	mov	0x7e0, %r20
	.word 0x87802020  ! 4772: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r17
	.word 0xd09fe000  ! 4774: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	.word 0xd8a40400  ! 4775: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0xd4a76000  ! 4776: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	mov	0x10, %r25
	.word 0xdc8fce60  ! 4778: LDUBA_R	lduba	[%r31, %r0] 0x73, %r14
	mov	0x7c8, %r22
	.word 0xd2f7ce80  ! 4780: STXA_R	stxa	%r9, [%r31 + %r0] 0x74
	.word 0xd4ae09e0  ! 4781: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0xd2f40400  ! 4782: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	mov	0x10, %r26
	.word 0xd8a40400  ! 4784: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	mov	0x50, %r18
	.word 0xdaa584a0  ! 4786: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	.word 0xdcaf4e80  ! 4787: STBA_R	stba	%r14, [%r29 + %r0] 0x74
	.word 0x87802025  ! 4788: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd497a000  ! 4789: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0xd497a000  ! 4790: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0xd4d72000  ! 4791: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	mov	0x30, %r19
	.word 0xd497e000  ! 4793: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	.word 0x87802020  ! 4794: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08fce60  ! 4795: LDUBA_R	lduba	[%r31, %r0] 0x73, %r8
	.word 0xd497e000  ! 4796: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	.word 0x87802020  ! 4797: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4798: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r18
	mov	0x3c8, %r21
	mov	0x7c8, %r20
	.word 0x87802025  ! 4802: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4d7e000  ! 4803: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	.word 0xdaf70e40  ! 4804: STXA_R	stxa	%r13, [%r28 + %r0] 0x72
	mov	0x3e0, %r20
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x3c0, %r20
	.word 0xd6dfe000  ! 4808: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	.word 0xd8af4e40  ! 4809: STBA_R	stba	%r12, [%r29 + %r0] 0x72
	.word 0xde8609e0  ! 4810: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r15
	.word 0x87802074  ! 4811: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdedfa000  ! 4812: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x20, %r25
	mov	0x7e0, %r23
	.word 0xd4c649e0  ! 4815: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r10
	.word 0xd8f72000  ! 4816: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8872000  ! 4817: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	mov	0x3d0, %r20
	mov	0x3e8, %r22
	.word 0xdedf4e80  ! 4820: LDXA_R	ldxa	[%r29, %r0] 0x74, %r15
	.word 0xd49fe000  ! 4821: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd48fe000  ! 4822: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	mov	0x7f8, %r22
	.word 0xd2c6c9e0  ! 4824: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r9
	mov	0x58, %r17
	.word 0xdea76000  ! 4826: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xd0d609e0  ! 4827: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r8
	mov	0x28, %r25
	.word 0xd4844400  ! 4829: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0x87802073  ! 4830: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r25
	.word 0x87802020  ! 4832: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf70e80  ! 4833: STXA_R	stxa	%r14, [%r28 + %r0] 0x74
	mov	0x50, %r25
	mov	0x3e8, %r22
	.word 0xd2bec9e0  ! 4836: STDA_R	stda	%r9, [%r27 + %r0] 0x4f
	mov	0x30, %r25
	.word 0xd6f609e0  ! 4838: STXA_R	stxa	%r11, [%r24 + %r0] 0x4f
	.word 0xd4bfe000  ! 4839: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd487a000  ! 4840: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	mov	0x28, %r24
	.word 0xd4dfe000  ! 4842: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4af2000  ! 4843: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	mov	0x3d8, %r21
	.word 0xd4b7e000  ! 4845: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd4b7e000  ! 4846: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xdcccc400  ! 4847: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	.word 0xd0dc8400  ! 4848: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0xdc9c8400  ! 4849: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0xdef609e0  ! 4850: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	.word 0xd0ad04a0  ! 4851: STBA_R	stba	%r8, [%r20 + %r0] 0x25
	.word 0x87802072  ! 4852: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd08fa000  ! 4853: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0xd0a72000  ! 4854: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xd0b7e000  ! 4855: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	mov	0x7f8, %r22
	.word 0xd2d609e0  ! 4857: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r9
	.word 0xd297a000  ! 4858: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	.word 0xdab78e40  ! 4859: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	.word 0xdcbfe000  ! 4860: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0xd0d609e0  ! 4862: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r8
	.word 0xd6a689e0  ! 4863: STWA_R	stwa	%r11, [%r26 + %r0] 0x4f
	.word 0xd2af4e60  ! 4864: STBA_R	stba	%r9, [%r29 + %r0] 0x73
	.word 0xd287a000  ! 4865: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	mov	0x0, %r24
	mov	0x60, %r16
	mov	0x7c8, %r23
	.word 0xded544a0  ! 4869: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r15
	mov	0x18, %r16
	.word 0xdc848400  ! 4871: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	.word 0xd6bf6000  ! 4872: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd697e000  ! 4873: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0xd0f584a0  ! 4874: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	.word 0xda8fe000  ! 4875: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4876: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaae2000  ! 4877: STBA_I	stba	%r13, [%r24 + 0x0000] %asi
	.word 0xdaf66000  ! 4878: STXA_I	stxa	%r13, [%r25 + 0x0000] %asi
	.word 0xdab6e000  ! 4879: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	mov	0x18, %r24
	.word 0x87802020  ! 4881: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8cf4e80  ! 4882: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r12
	.word 0xd6f504a0  ! 4883: STXA_R	stxa	%r11, [%r20 + %r0] 0x25
	.word 0xdecfce80  ! 4884: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r15
	.word 0xdebf0e60  ! 4885: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	.word 0xdcf44400  ! 4886: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	mov	0x58, %r25
	.word 0xd6b62000  ! 4888: STHA_I	stha	%r11, [%r24 + 0x0000] %asi
	.word 0xde9f4e80  ! 4889: LDDA_R	ldda	[%r29, %r0] 0x74, %r15
	.word 0xd6be09e0  ! 4890: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	mov	0x10, %r16
	.word 0xdace6000  ! 4892: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r13
	.word 0x87802074  ! 4893: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c8, %r23
	mov	0x40, %r24
	.word 0xd69c4400  ! 4896: LDDA_R	ldda	[%r17, %r0] 0x20, %r11
	.word 0x87802025  ! 4897: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeaf0e80  ! 4898: STBA_R	stba	%r15, [%r28 + %r0] 0x74
	.word 0xd8af0e40  ! 4899: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	.word 0x87802025  ! 4900: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6ace000  ! 4901: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0x87802073  ! 4903: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r26
	.word 0xd6b46000  ! 4905: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xdcb649e0  ! 4906: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	.word 0xdedce000  ! 4907: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r15
	.word 0xdab78e80  ! 4908: STHA_R	stha	%r13, [%r30 + %r0] 0x74
	mov	0x20, %r19
	.word 0xdea4e000  ! 4910: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xde8ce000  ! 4911: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	.word 0x87802072  ! 4912: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdedce000  ! 4913: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r15
	mov	0x7d0, %r22
	mov	0x0, %r24
	.word 0xdebca000  ! 4916: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xdebc6000  ! 4917: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xdeb4a000  ! 4918: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 4919: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b7ce60  ! 4920: STHA_R	stha	%r11, [%r31 + %r0] 0x73
	.word 0x87802074  ! 4921: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r27
	.word 0xdef40400  ! 4923: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0xd49fe000  ! 4924: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0x87802072  ! 4925: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd497a000  ! 4926: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	mov	0x58, %r17
	.word 0xd4b72000  ! 4928: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 4929: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f72000  ! 4930: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd48cc400  ! 4931: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	.word 0xd0afa000  ! 4932: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd6bd44a0  ! 4933: STDA_R	stda	%r11, [%r21 + %r0] 0x25
	.word 0xd0b5c4a0  ! 4934: STHA_R	stha	%r8, [%r23 + %r0] 0x25
	mov	0x7f0, %r22
	.word 0xd6afce80  ! 4936: STBA_R	stba	%r11, [%r31 + %r0] 0x74
	mov	0x48, %r26
	.word 0xd8978e40  ! 4938: LDUHA_R	lduha	[%r30, %r0] 0x72, %r12
	.word 0x8780204f  ! 4939: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d8, %r23
	.word 0x87802073  ! 4941: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd69fce60  ! 4942: LDDA_R	ldda	[%r31, %r0] 0x73, %r11
	.word 0xdaf40400  ! 4943: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0x87802074  ! 4944: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28ca000  ! 4945: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0xd8940400  ! 4946: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	.word 0xd6bfce80  ! 4947: STDA_R	stda	%r11, [%r31 + %r0] 0x74
	.word 0x87802073  ! 4948: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d0, %r23
	.word 0x87802020  ! 4950: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c76000  ! 4951: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	.word 0xd28f8e60  ! 4952: LDUBA_R	lduba	[%r30, %r0] 0x73, %r9
	mov	0x60, %r16
	.word 0x87802073  ! 4954: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef70e60  ! 4955: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	.word 0xdc8fce60  ! 4956: LDUBA_R	lduba	[%r31, %r0] 0x73, %r14
	mov	0x20, %r16
	.word 0xdad74e60  ! 4958: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r13
	.word 0xde8f0e40  ! 4959: LDUBA_R	lduba	[%r28, %r0] 0x72, %r15
	.word 0x87802073  ! 4960: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 4961: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 4962: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f544a0  ! 4963: STXA_R	stxa	%r11, [%r21 + %r0] 0x25
	.word 0xd2a4e000  ! 4964: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0xd89f8e80  ! 4965: LDDA_R	ldda	[%r30, %r0] 0x74, %r12
	.word 0xda9f0e80  ! 4966: LDDA_R	ldda	[%r28, %r0] 0x74, %r13
	mov	0x7d8, %r20
	.word 0x87802074  ! 4968: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0cf2000  ! 4969: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0x87802020  ! 4970: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r23
	.word 0xd4d74e80  ! 4972: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r10
	mov	0x68, %r18
	.word 0xdaf76000  ! 4974: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	mov	0x68, %r27
	.word 0xdaa7e000  ! 4976: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xd28cc400  ! 4977: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	mov	0x7c8, %r20
	mov	0x18, %r18
	.word 0xdcd72000  ! 4980: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xd0f78e40  ! 4981: STXA_R	stxa	%r8, [%r30 + %r0] 0x72
	.word 0xd6a7e000  ! 4982: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 4983: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r19
	mov	0x58, %r26
	.word 0xd68c6000  ! 4986: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r11
	.word 0xd69ca000  ! 4987: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r11
	.word 0xd89f4e40  ! 4988: LDDA_R	ldda	[%r29, %r0] 0x72, %r12
	.word 0xd0a74e80  ! 4989: STWA_R	stwa	%r8, [%r29 + %r0] 0x74
	.word 0xdc9fce80  ! 4990: LDDA_R	ldda	[%r31, %r0] 0x74, %r14
	.word 0xda9ce000  ! 4991: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r13
	.word 0xdac4a000  ! 4992: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	.word 0x87802072  ! 4993: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b4c400  ! 4994: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xdeae49e0  ! 4995: STBA_R	stba	%r15, [%r25 + %r0] 0x4f
	.word 0xdcd7e000  ! 4996: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xd0bcc400  ! 4997: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 4998: WRASI_I	wr	%r0, 0x004f, %asi
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_1:
	.word 0xd2be49e0  ! 1: STDA_R	stda	%r9, [%r25 + %r0] 0x4f
	.word 0xd6cea000  ! 2: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	.word 0xdabcc400  ! 3: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	.word 0xd0b62000  ! 4: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0d6a000  ! 6: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r8
	mov	0x7d8, %r22
	.word 0xd0bee000  ! 8: STDA_I	stda	%r8, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 9: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaae49e0  ! 10: STBA_R	stba	%r13, [%r25 + %r0] 0x4f
	.word 0xdc978e40  ! 11: LDUHA_R	lduha	[%r30, %r0] 0x72, %r14
	.word 0xda9fa000  ! 12: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	mov	0x68, %r19
	.word 0x8780204f  ! 14: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 15: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f70e40  ! 16: STXA_R	stxa	%r11, [%r28 + %r0] 0x72
	.word 0xdedc8400  ! 17: LDXA_R	ldxa	[%r18, %r0] 0x20, %r15
	.word 0xd0dee000  ! 18: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r8
	.word 0xd0c6a000  ! 19: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r8
	.word 0xd08e89e0  ! 20: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r8
	.word 0xd68fce80  ! 21: LDUBA_R	lduba	[%r31, %r0] 0x74, %r11
	.word 0xdeb62000  ! 22: STHA_I	stha	%r15, [%r24 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xde96a000  ! 24: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 25: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde866000  ! 26: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r15
	.word 0xd8dc4400  ! 27: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	mov	0x0, %r17
	.word 0x87802074  ! 29: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf7ce60  ! 30: STXA_R	stxa	%r13, [%r31 + %r0] 0x73
	.word 0xda84c400  ! 31: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r13
	.word 0x87802025  ! 32: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8d689e0  ! 33: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r12
	.word 0xd2a74e40  ! 34: STWA_R	stwa	%r9, [%r29 + %r0] 0x72
	mov	0x3e8, %r23
	.word 0xde8ee000  ! 36: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r15
	mov	0x0, %r27
	.word 0xd887ce80  ! 38: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r12
	.word 0xdac40400  ! 39: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	mov	0x7f0, %r20
	mov	0x38, %r24
	.word 0xd29fce60  ! 42: LDDA_R	ldda	[%r31, %r0] 0x73, %r9
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdeafce40  ! 44: STBA_R	stba	%r15, [%r31 + %r0] 0x72
	.word 0xd6be2000  ! 45: STDA_I	stda	%r11, [%r24 + 0x0000] %asi
	.word 0xdaf504a0  ! 46: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	.word 0xda8f0e40  ! 47: LDUBA_R	lduba	[%r28, %r0] 0x72, %r13
	.word 0xd4866000  ! 48: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r10
	mov	0x68, %r26
	.word 0xdeb44400  ! 50: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0x87802074  ! 51: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 52: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r24
	mov	0x28, %r17
	.word 0xda946000  ! 55: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	.word 0x87802025  ! 56: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd68cc400  ! 57: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	.word 0xdc87e000  ! 58: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0x87802020  ! 59: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r16
	.word 0x87802020  ! 61: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8c8400  ! 62: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	mov	0x48, %r25
	ta	T_CHANGE_NONHPRIV	! macro
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd4f44400  ! 66: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0x87802025  ! 67: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6bec9e0  ! 68: STDA_R	stda	%r11, [%r27 + %r0] 0x4f
	.word 0xdadd44a0  ! 69: LDXA_R	ldxa	[%r21, %r0] 0x25, %r13
	.word 0xd2aca000  ! 70: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0xd8a40400  ! 71: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0xd8c4e000  ! 72: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	mov	0x40, %r26
	.word 0xdadfce60  ! 74: LDXA_R	ldxa	[%r31, %r0] 0x73, %r13
	.word 0xd4b74e80  ! 75: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	.word 0xd4a78e60  ! 76: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	mov	0x30, %r16
	mov	0x7c0, %r20
	.word 0x87802072  ! 79: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde972000  ! 80: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	mov	0x78, %r27
	.word 0xdade09e0  ! 82: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r13
	.word 0xd6f78e60  ! 83: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	mov	0x10, %r25
	.word 0xd4cf6000  ! 85: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0x87802074  ! 86: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e8, %r22
	.word 0xd4a48400  ! 88: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xdaa7a000  ! 89: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xda87a000  ! 90: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0xdaaf4e80  ! 91: STBA_R	stba	%r13, [%r29 + %r0] 0x74
	mov	0x20, %r17
	.word 0x87802020  ! 93: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 94: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f584a0  ! 95: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	.word 0xdaf609e0  ! 96: STXA_R	stxa	%r13, [%r24 + %r0] 0x4f
	.word 0xdc8ea000  ! 97: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r14
	.word 0xd0dd04a0  ! 98: LDXA_R	ldxa	[%r20, %r0] 0x25, %r8
	.word 0xdc86a000  ! 99: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r14
	mov	0x48, %r17
	.word 0xd2878e40  ! 101: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r9
	.word 0xd4a6e000  ! 102: STWA_I	stwa	%r10, [%r27 + 0x0000] %asi
	mov	0x7d8, %r23
	mov	0x7c0, %r23
	.word 0xdcd48400  ! 105: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	.word 0xd88e2000  ! 106: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r12
	.word 0xd2d74e80  ! 107: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r9
	.word 0xde878e80  ! 108: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r15
	mov	0x18, %r18
	mov	0x78, %r27
	.word 0x87802025  ! 111: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 112: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd29e6000  ! 113: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r9
	.word 0xd2a40400  ! 114: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xdedea000  ! 115: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r15
	.word 0xdcf44400  ! 116: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xd2d7ce60  ! 117: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r9
	mov	0x18, %r17
	.word 0x87802020  ! 119: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f44400  ! 120: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd0a6c9e0  ! 121: STWA_R	stwa	%r8, [%r27 + %r0] 0x4f
	mov	0x60, %r26
	.word 0xdec76000  ! 123: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xd6f7ce40  ! 124: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	.word 0x87802020  ! 125: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ae6000  ! 126: STBA_I	stba	%r9, [%r25 + 0x0000] %asi
	.word 0xd48c8400  ! 127: LDUBA_R	lduba	[%r18, %r0] 0x20, %r10
	mov	0x3d8, %r20
	.word 0xd8866000  ! 129: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r12
	mov	0x58, %r27
	mov	0x30, %r17
	.word 0xd8a40400  ! 132: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	mov	0x40, %r24
	.word 0x87802074  ! 134: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabf8e80  ! 135: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	.word 0xd0b6c9e0  ! 136: STHA_R	stha	%r8, [%r27 + %r0] 0x4f
	mov	0x38, %r25
	.word 0x8780204f  ! 138: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdecf2000  ! 139: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xdec76000  ! 140: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xd49c0400  ! 141: LDDA_R	ldda	[%r16, %r0] 0x20, %r10
	.word 0xd28f6000  ! 142: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0x87802072  ! 143: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0d70e60  ! 144: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r8
	.word 0xde8504a0  ! 145: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r15
	mov	0x7d0, %r22
	.word 0x87802074  ! 147: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdea649e0  ! 148: STWA_R	stwa	%r15, [%r25 + %r0] 0x4f
	.word 0xd0bca000  ! 149: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 150: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 151: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d8, %r23
	mov	0x28, %r27
	.word 0xd09f6000  ! 154: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	.word 0xd0d76000  ! 155: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	mov	0x3f0, %r21
	.word 0x87802025  ! 157: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0ac2000  ! 158: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xde874e80  ! 159: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r15
	.word 0xdecf4e80  ! 160: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r15
	.word 0xdabe09e0  ! 161: STDA_R	stda	%r13, [%r24 + %r0] 0x4f
	.word 0xd8aca000  ! 162: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 163: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8d52000  ! 164: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r12
	.word 0xd8b56000  ! 165: STHA_I	stha	%r12, [%r21 + 0x0000] %asi
	.word 0xd8856000  ! 166: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	.word 0xd4af0e60  ! 167: STBA_R	stba	%r10, [%r28 + %r0] 0x73
	.word 0xd6bd6000  ! 168: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0xd6bd2000  ! 169: STDA_I	stda	%r11, [%r20 + 0x0000] %asi
	.word 0xd0c44400  ! 170: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r8
	mov	0x0, %r26
	.word 0xd2f56000  ! 172: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	mov	0x3e8, %r20
	mov	0x8, %r26
	mov	0x7e0, %r20
	mov	0x3f8, %r22
	mov	0x78, %r24
	.word 0xd2b48400  ! 178: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	mov	0x3f8, %r23
	.word 0xd0a52000  ! 180: STWA_I	stwa	%r8, [%r20 + 0x0000] %asi
	.word 0xd6f7ce40  ! 181: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	.word 0xd4ac4400  ! 182: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0x87802074  ! 183: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcdf2000  ! 184: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdccf2000  ! 185: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xdcc76000  ! 186: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0x87802020  ! 187: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r24
	mov	0x3f8, %r22
	.word 0xdcb42000  ! 190: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xd0cf0e80  ! 191: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r8
	.word 0xd69ca000  ! 192: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r11
	.word 0xdec48400  ! 193: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	mov	0x68, %r25
	mov	0x7c0, %r20
	.word 0x87802073  ! 196: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c0, %r20
	mov	0x7d0, %r21
	mov	0x40, %r19
	.word 0xd6ad2000  ! 200: STBA_I	stba	%r11, [%r20 + 0x0000] %asi
	.word 0xd6ad6000  ! 201: STBA_I	stba	%r11, [%r21 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xd8c78e40  ! 203: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r12
	.word 0xd8dd6000  ! 204: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r12
	.word 0xdcb4c400  ! 205: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0x87802025  ! 206: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c0, %r22
	.word 0xdabc4400  ! 208: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xdcc584a0  ! 209: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r14
	.word 0xdcde49e0  ! 210: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r14
	.word 0xde8d2000  ! 211: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r15
	.word 0xdeb5e000  ! 212: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	mov	0x70, %r25
	.word 0xdcf7ce80  ! 214: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	.word 0xd6d40400  ! 215: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	mov	0x7c0, %r23
	.word 0xd0dde000  ! 217: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r8
	.word 0xd6af0e60  ! 218: STBA_R	stba	%r11, [%r28 + %r0] 0x73
	mov	0x7d8, %r23
	.word 0xd4c5e000  ! 220: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r10
	.word 0xd0b7ce80  ! 221: STHA_R	stha	%r8, [%r31 + %r0] 0x74
	mov	0x68, %r27
	mov	0x10, %r24
	mov	0x7e0, %r22
	mov	0x70, %r18
	.word 0x87802074  ! 226: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4c584a0  ! 227: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r10
	.word 0xd49689e0  ! 228: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r10
	mov	0x3d0, %r23
	.word 0xd48f4e80  ! 230: LDUBA_R	lduba	[%r29, %r0] 0x74, %r10
	.word 0x87802020  ! 231: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c7ce80  ! 232: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r10
	.word 0xdcbf2000  ! 233: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	mov	0x30, %r18
	.word 0xdc9f2000  ! 235: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xdc8f2000  ! 236: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0xdca72000  ! 237: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 238: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b70e40  ! 239: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	mov	0x18, %r24
	.word 0xd6f609e0  ! 241: STXA_R	stxa	%r11, [%r24 + %r0] 0x4f
	.word 0xd0b689e0  ! 242: STHA_R	stha	%r8, [%r26 + %r0] 0x4f
	mov	0x20, %r16
	mov	0x7e0, %r22
	mov	0x7c0, %r20
	mov	0x70, %r19
	mov	0x3c0, %r20
	.word 0xdeac0400  ! 248: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xdcbfa000  ! 249: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdeb689e0  ! 250: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	mov	0x7e0, %r23
	.word 0x8780204f  ! 252: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r16
	.word 0xd2876000  ! 254: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xdc970e60  ! 255: LDUHA_R	lduha	[%r28, %r0] 0x73, %r14
	.word 0xd8876000  ! 256: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0xd2f649e0  ! 257: STXA_R	stxa	%r9, [%r25 + %r0] 0x4f
	mov	0x3c0, %r20
	.word 0xd6848400  ! 259: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	.word 0xdaf7ce60  ! 260: STXA_R	stxa	%r13, [%r31 + %r0] 0x73
	.word 0xdcd7a000  ! 261: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0xdc9fa000  ! 262: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0xd4870e80  ! 263: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r10
	.word 0x87802020  ! 264: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd697a000  ! 265: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0x87802072  ! 266: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r26
	.word 0xdea7ce80  ! 268: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	.word 0xdaaf0e40  ! 269: STBA_R	stba	%r13, [%r28 + %r0] 0x72
	.word 0xdaf78e40  ! 270: STXA_R	stxa	%r13, [%r30 + %r0] 0x72
	mov	0x7c8, %r22
	.word 0x87802074  ! 272: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb7ce60  ! 273: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	.word 0xda85c4a0  ! 274: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r13
	.word 0xdaa74e80  ! 275: STWA_R	stwa	%r13, [%r29 + %r0] 0x74
	.word 0xdc97e000  ! 276: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xdcb76000  ! 277: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xd6de09e0  ! 278: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r11
	.word 0x8780204f  ! 279: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r18
	.word 0x87802020  ! 281: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r18
	.word 0xd6c74e60  ! 283: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r11
	.word 0xd8df8e60  ! 284: LDXA_R	ldxa	[%r30, %r0] 0x73, %r12
	.word 0xdccf6000  ! 285: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xd2f70e60  ! 286: STXA_R	stxa	%r9, [%r28 + %r0] 0x73
	.word 0xd6dfe000  ! 287: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	.word 0x87802072  ! 288: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r19
	.word 0x87802073  ! 290: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdebf8e80  ! 291: STDA_R	stda	%r15, [%r30 + %r0] 0x74
	mov	0x3d8, %r23
	.word 0x87802020  ! 293: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac62000  ! 294: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r13
	.word 0xdab6e000  ! 295: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	.word 0xd2d689e0  ! 296: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r9
	.word 0xd8cfce60  ! 297: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r12
	mov	0x3c8, %r22
	mov	0x7f0, %r22
	.word 0xd2c62000  ! 300: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r9
	.word 0xd2f6e000  ! 301: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	.word 0xd8b7ce60  ! 302: STHA_R	stha	%r12, [%r31 + %r0] 0x73
	mov	0x10, %r24
	.word 0xdebe2000  ! 304: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	.word 0xdecea000  ! 305: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r15
	.word 0xdeae6000  ! 306: STBA_I	stba	%r15, [%r25 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x30, %r26
	.word 0xde8e2000  ! 309: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r15
	.word 0x87802074  ! 310: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d0, %r22
	.word 0x87802073  ! 312: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 313: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9f2000  ! 314: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xdedfe000  ! 315: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	mov	0x3c0, %r21
	.word 0xdabc0400  ! 317: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xd0c7e000  ! 318: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0cf6000  ! 319: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd4be09e0  ! 320: STDA_R	stda	%r10, [%r24 + %r0] 0x4f
	mov	0x0, %r17
	.word 0xd4cfa000  ! 322: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0xd4a72000  ! 323: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	mov	0x7e0, %r20
	mov	0x10, %r18
	mov	0x3e8, %r21
	.word 0xdcdc0400  ! 327: LDXA_R	ldxa	[%r16, %r0] 0x20, %r14
	.word 0xd2dc4400  ! 328: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	mov	0x10, %r19
	.word 0xd0f4c400  ! 330: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0xd8cc8400  ! 331: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	mov	0x7f8, %r22
	.word 0xdec72000  ! 333: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xdec7e000  ! 334: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xd6c6c9e0  ! 335: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r11
	.word 0xdcf70e80  ! 336: STXA_R	stxa	%r14, [%r28 + %r0] 0x74
	.word 0x87802072  ! 337: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 338: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd89ce000  ! 339: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	.word 0xd8b4a000  ! 340: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0xd8f46000  ! 341: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8a42000  ! 342: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 343: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8a4c400  ! 344: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0x87802074  ! 345: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 346: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea6a000  ! 347: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	mov	0x7c0, %r21
	.word 0xd69c4400  ! 349: LDDA_R	ldda	[%r17, %r0] 0x20, %r11
	.word 0xd8af8e80  ! 350: STBA_R	stba	%r12, [%r30 + %r0] 0x74
	.word 0x87802073  ! 351: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2cda000  ! 352: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r9
	.word 0xd0974e40  ! 353: LDUHA_R	lduha	[%r29, %r0] 0x72, %r8
	.word 0xdcf4c400  ! 354: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xde9544a0  ! 355: LDUHA_R	lduha	[%r21, %r0] 0x25, %r15
	mov	0x7c0, %r22
	.word 0xd8ada000  ! 357: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0xd8c52000  ! 358: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r12
	.word 0xd885a000  ! 359: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r12
	.word 0xdef70e80  ! 360: STXA_R	stxa	%r15, [%r28 + %r0] 0x74
	mov	0x48, %r16
	mov	0x40, %r26
	.word 0xdcb5a000  ! 363: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0xdcb5a000  ! 364: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0xdab44400  ! 365: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x40, %r19
	.word 0xd6a56000  ! 368: STWA_I	stwa	%r11, [%r21 + 0x0000] %asi
	.word 0xdcf649e0  ! 369: STXA_R	stxa	%r14, [%r25 + %r0] 0x4f
	.word 0x87802073  ! 370: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 371: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9f0e60  ! 372: LDDA_R	ldda	[%r28, %r0] 0x73, %r14
	.word 0x87802074  ! 373: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6878e40  ! 374: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r11
	.word 0xd2b7ce40  ! 375: STHA_R	stha	%r9, [%r31 + %r0] 0x72
	.word 0x87802073  ! 376: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bde000  ! 377: STDA_I	stda	%r11, [%r23 + 0x0000] %asi
	mov	0x10, %r26
	.word 0xd6bda000  ! 379: STDA_I	stda	%r11, [%r22 + 0x0000] %asi
	.word 0xd6cd2000  ! 380: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r11
	.word 0xd8d4c400  ! 381: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0x87802020  ! 382: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6de09e0  ! 383: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r11
	.word 0xdcbf2000  ! 384: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdcd72000  ! 385: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd6b544a0  ! 387: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	.word 0xd8cf8e60  ! 388: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r12
	mov	0x58, %r26
	.word 0xd4dfe000  ! 390: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	mov	0x20, %r24
	.word 0xd487ce40  ! 392: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r10
	.word 0xd88d44a0  ! 393: LDUBA_R	lduba	[%r21, %r0] 0x25, %r12
	.word 0x87802020  ! 394: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0dc0400  ! 395: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xd6f7e000  ! 396: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6bfa000  ! 397: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd8bc4400  ! 398: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xdcf7e000  ! 399: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcd7a000  ! 400: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0xd2ce49e0  ! 401: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r9
	.word 0xd6be09e0  ! 402: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	.word 0xd6ac4400  ! 403: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0x87802020  ! 404: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r20
	.word 0xd6a44400  ! 406: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	mov	0x10, %r24
	.word 0x87802020  ! 408: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabf6000  ! 409: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xdebf0e40  ! 410: STDA_R	stda	%r15, [%r28 + %r0] 0x72
	.word 0xd2c48400  ! 411: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0xdcb689e0  ! 412: STHA_R	stha	%r14, [%r26 + %r0] 0x4f
	mov	0x30, %r24
	mov	0x3e8, %r22
	mov	0x3e0, %r21
	mov	0x38, %r27
	.word 0x87802074  ! 417: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c8, %r22
	mov	0x7c8, %r23
	.word 0xd4bce000  ! 420: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0xd4dc6000  ! 421: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	.word 0xd4f42000  ! 422: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd49c2000  ! 423: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	mov	0x3d0, %r20
	.word 0x87802072  ! 425: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cfe000  ! 426: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	mov	0x7e0, %r23
	.word 0xd8afce80  ! 428: STBA_R	stba	%r12, [%r31 + %r0] 0x74
	mov	0x3f0, %r23
	.word 0xd2af4e40  ! 430: STBA_R	stba	%r9, [%r29 + %r0] 0x72
	.word 0xdabd04a0  ! 431: STDA_R	stda	%r13, [%r20 + %r0] 0x25
	.word 0xdeb76000  ! 432: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	mov	0x40, %r25
	.word 0x87802020  ! 434: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69649e0  ! 435: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r11
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2948400  ! 437: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	.word 0x87802020  ! 438: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r23
	.word 0x87802072  ! 440: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6cc8400  ! 441: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	.word 0x87802020  ! 442: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d76000  ! 443: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	mov	0x58, %r26
	mov	0x7d0, %r20
	.word 0xd4c7a000  ! 446: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4b72000  ! 447: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 448: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 449: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b74e60  ! 450: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	.word 0xd0ac6000  ! 451: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0xd49e49e0  ! 452: LDDA_R	ldda	[%r25, %r0] 0x4f, %r10
	mov	0x68, %r17
	.word 0x87802025  ! 454: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f8, %r23
	.word 0xd8a7ce40  ! 456: STWA_R	stwa	%r12, [%r31 + %r0] 0x72
	.word 0xd49cc400  ! 457: LDDA_R	ldda	[%r19, %r0] 0x20, %r10
	.word 0xd6978e40  ! 458: LDUHA_R	lduha	[%r30, %r0] 0x72, %r11
	.word 0xd2976000  ! 459: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0xd68f0e60  ! 460: LDUBA_R	lduba	[%r28, %r0] 0x73, %r11
	.word 0xd4bfe000  ! 461: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x18, %r18
	.word 0xd4a7a000  ! 463: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	mov	0x3f0, %r23
	.word 0x87802020  ! 465: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f74e40  ! 466: STXA_R	stxa	%r10, [%r29 + %r0] 0x72
	mov	0x3d8, %r21
	.word 0xd8f7ce60  ! 468: STXA_R	stxa	%r12, [%r31 + %r0] 0x73
	.word 0xdab78e40  ! 469: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	.word 0xd2862000  ! 470: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r9
	.word 0x87802072  ! 471: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2bf2000  ! 472: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd6a78e80  ! 473: STWA_R	stwa	%r11, [%r30 + %r0] 0x74
	.word 0xdadcc400  ! 474: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	mov	0x30, %r16
	.word 0xd29f6000  ! 476: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xd29f6000  ! 477: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xde8f0e40  ! 478: LDUBA_R	lduba	[%r28, %r0] 0x72, %r15
	mov	0x60, %r24
	.word 0xd69544a0  ! 480: LDUHA_R	lduha	[%r21, %r0] 0x25, %r11
	mov	0x28, %r26
	.word 0xd4bf6000  ! 482: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xde8d04a0  ! 483: LDUBA_R	lduba	[%r20, %r0] 0x25, %r15
	.word 0xd2be49e0  ! 484: STDA_R	stda	%r9, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 485: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f56000  ! 486: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	.word 0x87802072  ! 487: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 488: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2af4e60  ! 489: STBA_R	stba	%r9, [%r29 + %r0] 0x73
	.word 0xd68e89e0  ! 490: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r11
	.word 0xdab76000  ! 491: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 492: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r26
	mov	0x7d0, %r21
	.word 0xdab6e000  ! 495: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	.word 0xdad6e000  ! 496: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r13
	.word 0xd09dc4a0  ! 497: LDDA_R	ldda	[%r23, %r0] 0x25, %r8
	.word 0x87802072  ! 498: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 499: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0ae49e0  ! 500: STBA_R	stba	%r8, [%r25 + %r0] 0x4f
	mov	0x18, %r19
	mov	0x28, %r27
	.word 0x87802074  ! 503: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 504: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcaf4e40  ! 505: STBA_R	stba	%r14, [%r29 + %r0] 0x72
	.word 0xdeace000  ! 506: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xde9c6000  ! 507: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0xde9c2000  ! 508: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xdeb42000  ! 509: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0xdebce000  ! 510: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xdeb46000  ! 511: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	mov	0x7e0, %r20
	.word 0xdeace000  ! 513: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xd0ce89e0  ! 514: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r8
	mov	0x78, %r27
	.word 0x87802025  ! 516: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r17
	mov	0x40, %r26
	.word 0xd6d70e40  ! 519: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r11
	.word 0xd8cda000  ! 520: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r12
	.word 0xd8f52000  ! 521: STXA_I	stxa	%r12, [%r20 + 0x0000] %asi
	.word 0xdea5c4a0  ! 522: STWA_R	stwa	%r15, [%r23 + %r0] 0x25
	.word 0xda8fce60  ! 523: LDUBA_R	lduba	[%r31, %r0] 0x73, %r13
	.word 0xdab56000  ! 524: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	mov	0x60, %r18
	.word 0xd8a689e0  ! 526: STWA_R	stwa	%r12, [%r26 + %r0] 0x4f
	mov	0x30, %r17
	mov	0x20, %r18
	.word 0x87802072  ! 529: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef7ce80  ! 530: STXA_R	stxa	%r15, [%r31 + %r0] 0x74
	.word 0xdeb42000  ! 531: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 532: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r26
	.word 0xde9d2000  ! 534: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r15
	.word 0xde9da000  ! 535: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r15
	.word 0xd08cc400  ! 536: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	.word 0x87802072  ! 537: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f5a000  ! 538: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	.word 0xd2f56000  ! 539: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	.word 0xdea689e0  ! 540: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	mov	0x68, %r19
	mov	0x0, %r19
	mov	0x7d8, %r23
	.word 0x87802074  ! 544: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0bf4e80  ! 545: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	.word 0xdab78e60  ! 546: STHA_R	stha	%r13, [%r30 + %r0] 0x73
	mov	0x7c8, %r20
	mov	0x60, %r17
	mov	0x3c0, %r23
	.word 0xd8cc2000  ! 550: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r12
	.word 0x87802025  ! 551: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r17
	.word 0xd8a42000  ! 553: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 554: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0978e60  ! 555: LDUHA_R	lduha	[%r30, %r0] 0x73, %r8
	.word 0xdecc2000  ! 556: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	.word 0xde8544a0  ! 557: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r15
	.word 0x87802072  ! 558: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabd2000  ! 559: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 560: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6d74e80  ! 561: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r11
	.word 0xd8a66000  ! 562: STWA_I	stwa	%r12, [%r25 + 0x0000] %asi
	.word 0xd8ae2000  ! 563: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	.word 0xd4d40400  ! 564: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	.word 0xd4b70e60  ! 565: STHA_R	stha	%r10, [%r28 + %r0] 0x73
	.word 0xdcbdc4a0  ! 566: STDA_R	stda	%r14, [%r23 + %r0] 0x25
	.word 0xd08e2000  ! 567: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r8
	.word 0xd0d6a000  ! 568: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r8
	.word 0x87802073  ! 569: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0df6000  ! 570: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	mov	0x30, %r18
	.word 0xd0f7a000  ! 572: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	mov	0x10, %r25
	mov	0x0, %r27
	mov	0x7c0, %r21
	.word 0x87802074  ! 576: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a7a000  ! 577: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	mov	0x28, %r25
	.word 0xdcac4400  ! 579: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	.word 0xd0af4e60  ! 580: STBA_R	stba	%r8, [%r29 + %r0] 0x73
	.word 0xdebfa000  ! 581: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xdeafe000  ! 582: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	mov	0x48, %r17
	.word 0xd8b689e0  ! 584: STHA_R	stha	%r12, [%r26 + %r0] 0x4f
	.word 0xd0870e60  ! 585: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r8
	.word 0x87802073  ! 586: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbe89e0  ! 587: STDA_R	stda	%r14, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 588: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r27
	.word 0xdcdea000  ! 590: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r14
	.word 0xd4cf4e80  ! 591: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r10
	.word 0xd0bee000  ! 592: STDA_I	stda	%r8, [%r27 + 0x0000] %asi
	.word 0xd0c6a000  ! 593: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r8
	.word 0xd0878e40  ! 594: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r8
	.word 0xd6f6e000  ! 595: STXA_I	stxa	%r11, [%r27 + 0x0000] %asi
	.word 0xd6962000  ! 596: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r11
	.word 0xd29f0e40  ! 597: LDDA_R	ldda	[%r28, %r0] 0x72, %r9
	.word 0xd4afce60  ! 598: STBA_R	stba	%r10, [%r31 + %r0] 0x73
	.word 0xdebc8400  ! 599: STDA_R	stda	%r15, [%r18 + %r0] 0x20
	mov	0x30, %r18
	.word 0x87802025  ! 601: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r17
	.word 0xd2b78e40  ! 603: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	mov	0x58, %r27
	.word 0xdadca000  ! 605: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	mov	0x38, %r27
	.word 0x87802025  ! 607: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad42000  ! 608: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r13
	.word 0xda9c2000  ! 609: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	.word 0xdab42000  ! 610: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	mov	0x10, %r24
	.word 0xd087ce40  ! 612: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r8
	.word 0xdc94e000  ! 613: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	.word 0xd0d74e60  ! 614: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r8
	.word 0xd09c6000  ! 615: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r8
	.word 0xd0846000  ! 616: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0xd0cc6000  ! 617: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	.word 0xd0dcc400  ! 618: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0xd0f4a000  ! 619: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	mov	0x38, %r17
	.word 0xd6974e40  ! 621: LDUHA_R	lduha	[%r29, %r0] 0x72, %r11
	mov	0x30, %r24
	.word 0xd29ca000  ! 623: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	mov	0x40, %r26
	.word 0xd8cfce80  ! 625: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r12
	.word 0xd0bc6000  ! 626: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0xd0dc2000  ! 628: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	.word 0xd08ca000  ! 629: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xdcf504a0  ! 630: STXA_R	stxa	%r14, [%r20 + %r0] 0x25
	.word 0xdc84a000  ! 631: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	.word 0xd8b70e60  ! 632: STHA_R	stha	%r12, [%r28 + %r0] 0x73
	.word 0xd4c78e80  ! 633: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r10
	.word 0xde94a000  ! 634: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0x87802020  ! 635: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 636: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcd689e0  ! 637: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r14
	mov	0x20, %r24
	.word 0xd49d04a0  ! 639: LDDA_R	ldda	[%r20, %r0] 0x25, %r10
	.word 0xd48fce40  ! 640: LDUBA_R	lduba	[%r31, %r0] 0x72, %r10
	.word 0xdc87ce80  ! 641: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r14
	mov	0x7d8, %r21
	.word 0xdabf0e40  ! 643: STDA_R	stda	%r13, [%r28 + %r0] 0x72
	.word 0xdeaca000  ! 644: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xde846000  ! 645: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0xdeacc400  ! 646: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0x87802020  ! 647: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 648: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r19
	mov	0x78, %r25
	.word 0xd2c4e000  ! 651: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xd29f4e80  ! 652: LDDA_R	ldda	[%r29, %r0] 0x74, %r9
	mov	0x7e0, %r21
	mov	0x0, %r27
	.word 0xd8f544a0  ! 655: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	.word 0x87802073  ! 656: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb7a000  ! 657: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	mov	0x78, %r24
	.word 0xdec7e000  ! 659: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	mov	0x18, %r27
	mov	0x38, %r18
	.word 0xd4d70e80  ! 662: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r10
	mov	0x3f0, %r23
	.word 0xd2bf6000  ! 664: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 665: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0ac4400  ! 666: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0xde8ce000  ! 667: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	.word 0xde9c2000  ! 668: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xd2af8e40  ! 669: STBA_R	stba	%r9, [%r30 + %r0] 0x72
	.word 0xd894a000  ! 670: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r12
	mov	0x20, %r17
	.word 0xdcbf4e60  ! 672: STDA_R	stda	%r14, [%r29 + %r0] 0x73
	mov	0x40, %r24
	.word 0xdccd44a0  ! 674: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r14
	.word 0xdab78e80  ! 675: STHA_R	stha	%r13, [%r30 + %r0] 0x74
	.word 0xde9ca000  ! 676: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	.word 0xdec4a000  ! 677: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xd68fce60  ! 678: LDUBA_R	lduba	[%r31, %r0] 0x73, %r11
	.word 0x87802025  ! 679: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 680: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c8, %r23
	.word 0xda8f2000  ! 682: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xdebf0e40  ! 683: STDA_R	stda	%r15, [%r28 + %r0] 0x72
	.word 0x87802020  ! 684: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r16
	.word 0xdca70e80  ! 686: STWA_R	stwa	%r14, [%r28 + %r0] 0x74
	.word 0x87802020  ! 687: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r18
	.word 0xd0b62000  ! 689: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0xdef4c400  ! 690: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xdef48400  ! 691: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	mov	0x70, %r19
	.word 0xd8de6000  ! 693: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 694: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802073  ! 696: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 697: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r16
	.word 0x87802072  ! 699: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r24
	.word 0xd897a000  ! 701: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	mov	0x70, %r24
	mov	0x7f0, %r21
	.word 0x87802074  ! 704: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 705: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bfce40  ! 706: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	.word 0xd89cc400  ! 707: LDDA_R	ldda	[%r19, %r0] 0x20, %r12
	.word 0xd8cf6000  ! 708: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0xd8f72000  ! 709: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 710: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcdd44a0  ! 711: LDXA_R	ldxa	[%r21, %r0] 0x25, %r14
	mov	0x48, %r27
	.word 0xd4b5c4a0  ! 713: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	mov	0x68, %r18
	.word 0x87802072  ! 715: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8dee000  ! 716: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r12
	.word 0xd8bea000  ! 717: STDA_I	stda	%r12, [%r26 + 0x0000] %asi
	.word 0x87802025  ! 718: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdedfce80  ! 719: LDXA_R	ldxa	[%r31, %r0] 0x74, %r15
	.word 0xd0bc4400  ! 720: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	mov	0x8, %r24
	mov	0x7f8, %r21
	.word 0x8780204f  ! 723: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c8, %r21
	mov	0x60, %r26
	.word 0xd6f66000  ! 726: STXA_I	stxa	%r11, [%r25 + 0x0000] %asi
	.word 0xd68e2000  ! 727: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r11
	.word 0xd6f6e000  ! 728: STXA_I	stxa	%r11, [%r27 + 0x0000] %asi
	mov	0x10, %r27
	mov	0x40, %r17
	mov	0x40, %r24
	.word 0x87802074  ! 732: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeb74e60  ! 733: STHA_R	stha	%r15, [%r29 + %r0] 0x73
	.word 0xdcd40400  ! 734: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	mov	0x20, %r24
	.word 0xdeb52000  ! 736: STHA_I	stha	%r15, [%r20 + 0x0000] %asi
	.word 0xdeb5e000  ! 737: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	mov	0x60, %r25
	.word 0xd4f74e60  ! 739: STXA_R	stxa	%r10, [%r29 + %r0] 0x73
	mov	0x8, %r25
	mov	0x38, %r24
	.word 0xd0b70e60  ! 742: STHA_R	stha	%r8, [%r28 + %r0] 0x73
	.word 0x87802072  ! 743: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd08d2000  ! 744: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r8
	.word 0xd2b544a0  ! 745: STHA_R	stha	%r9, [%r21 + %r0] 0x25
	mov	0x60, %r26
	.word 0xd69d2000  ! 747: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r11
	.word 0xd8b78e60  ! 748: STHA_R	stha	%r12, [%r30 + %r0] 0x73
	mov	0x70, %r17
	.word 0xd6ac4400  ! 750: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0x87802073  ! 751: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r25
	.word 0x87802020  ! 753: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef649e0  ! 754: STXA_R	stxa	%r15, [%r25 + %r0] 0x4f
	mov	0x40, %r18
	.word 0xd2ac8400  ! 756: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0x87802020  ! 757: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r21
	.word 0x87802072  ! 759: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4bd6000  ! 760: STDA_I	stda	%r10, [%r21 + 0x0000] %asi
	.word 0xd4f609e0  ! 761: STXA_R	stxa	%r10, [%r24 + %r0] 0x4f
	.word 0xdecda000  ! 762: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r15
	.word 0xde8de000  ! 763: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r15
	mov	0x8, %r16
	.word 0xdedd2000  ! 765: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r15
	.word 0xdef5a000  ! 766: STXA_I	stxa	%r15, [%r22 + 0x0000] %asi
	.word 0xdedda000  ! 767: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r15
	.word 0xdea5a000  ! 768: STWA_I	stwa	%r15, [%r22 + 0x0000] %asi
	.word 0x8780204f  ! 769: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r16
	.word 0xd0cd44a0  ! 771: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r8
	.word 0xded66000  ! 772: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r15
	mov	0x48, %r19
	.word 0xdcaf8e60  ! 774: STBA_R	stba	%r14, [%r30 + %r0] 0x73
	mov	0x7d8, %r21
	mov	0x38, %r27
	mov	0x30, %r24
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdecee000  ! 779: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r15
	.word 0xdede6000  ! 780: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r15
	.word 0xded6e000  ! 781: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r15
	.word 0xd0f6c9e0  ! 782: STXA_R	stxa	%r8, [%r27 + %r0] 0x4f
	.word 0xdab66000  ! 783: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xdabee000  ! 785: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	.word 0xd09f8e40  ! 786: LDDA_R	ldda	[%r30, %r0] 0x72, %r8
	.word 0xdc8fce80  ! 787: LDUBA_R	lduba	[%r31, %r0] 0x74, %r14
	.word 0xd0c48400  ! 788: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r8
	mov	0x8, %r27
	.word 0xdea6a000  ! 790: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	mov	0x38, %r25
	.word 0xd89d84a0  ! 792: LDDA_R	ldda	[%r22, %r0] 0x25, %r12
	.word 0xd0f649e0  ! 793: STXA_R	stxa	%r8, [%r25 + %r0] 0x4f
	.word 0xdacee000  ! 794: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r13
	.word 0xd8acc400  ! 795: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	mov	0x20, %r26
	mov	0x60, %r26
	.word 0xde8504a0  ! 798: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r15
	.word 0xd294c400  ! 799: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	.word 0xdec66000  ! 800: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r15
	.word 0xdea66000  ! 801: STWA_I	stwa	%r15, [%r25 + 0x0000] %asi
	.word 0xded7ce80  ! 802: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r15
	.word 0x87802072  ! 803: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2d46000  ! 804: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	.word 0xd2b42000  ! 805: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 806: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b42000  ! 807: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0xd2f4e000  ! 808: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 809: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28f2000  ! 810: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	.word 0xd8f78e60  ! 811: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	.word 0xd49fa000  ! 812: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0xd48fa000  ! 813: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xdef70e80  ! 814: STXA_R	stxa	%r15, [%r28 + %r0] 0x74
	.word 0xdaafe000  ! 815: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	mov	0x78, %r25
	.word 0x87802072  ! 817: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8ccc400  ! 818: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r12
	.word 0x87802020  ! 819: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r17
	.word 0xd4a70e40  ! 821: STWA_R	stwa	%r10, [%r28 + %r0] 0x72
	.word 0xd2c4c400  ! 822: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0xd6af8e60  ! 823: STBA_R	stba	%r11, [%r30 + %r0] 0x73
	.word 0xdabf8e80  ! 824: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	.word 0xdaaf0e40  ! 825: STBA_R	stba	%r13, [%r28 + %r0] 0x72
	mov	0x40, %r17
	.word 0xd8bc8400  ! 827: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xdcb78e80  ! 828: STHA_R	stha	%r14, [%r30 + %r0] 0x74
	.word 0xd69f4e80  ! 829: LDDA_R	ldda	[%r29, %r0] 0x74, %r11
	.word 0xd4b544a0  ! 830: STHA_R	stha	%r10, [%r21 + %r0] 0x25
	mov	0x48, %r27
	.word 0x87802025  ! 832: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0b4a000  ! 833: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 834: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cf6000  ! 835: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	mov	0x3f0, %r22
	.word 0xde9d04a0  ! 837: LDDA_R	ldda	[%r20, %r0] 0x25, %r15
	.word 0xda86c9e0  ! 838: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r13
	.word 0x87802020  ! 839: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdc4400  ! 840: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	mov	0x70, %r19
	mov	0x58, %r16
	mov	0x0, %r16
	mov	0x7c8, %r20
	.word 0x87802020  ! 845: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda876000  ! 846: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0x87802025  ! 847: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda97e000  ! 848: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	mov	0x28, %r19
	.word 0xde9fce40  ! 850: LDDA_R	ldda	[%r31, %r0] 0x72, %r15
	mov	0x0, %r26
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdc9689e0  ! 853: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r14
	.word 0xda8fce40  ! 854: LDUBA_R	lduba	[%r31, %r0] 0x72, %r13
	.word 0xd48f6000  ! 855: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0x87802020  ! 856: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c48400  ! 857: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	.word 0xdad7a000  ! 858: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0xdc844400  ! 859: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	mov	0x3c8, %r23
	.word 0xd2acc400  ! 861: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0xde84c400  ! 862: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0xdcafa000  ! 863: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 864: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r17
	.word 0x87802073  ! 866: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f5c4a0  ! 867: STXA_R	stxa	%r11, [%r23 + %r0] 0x25
	.word 0xdaf44400  ! 868: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0xd09c8400  ! 869: LDDA_R	ldda	[%r18, %r0] 0x20, %r8
	.word 0x87802074  ! 870: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 871: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c0, %r20
	.word 0xd8870e60  ! 873: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r12
	ta	T_CHANGE_PRIV	! macro
	.word 0x8780204f  ! 875: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeac2000  ! 876: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xdebce000  ! 877: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xded46000  ! 878: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	.word 0xde842000  ! 879: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	.word 0xde9c2000  ! 880: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xdebce000  ! 881: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 882: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r25
	.word 0x87802074  ! 884: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c8, %r21
	mov	0x3e8, %r23
	.word 0xdea72000  ! 887: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0xdebf6000  ! 889: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xdec7a000  ! 890: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	mov	0x3e0, %r21
	mov	0x7d8, %r21
	.word 0xdea74e80  ! 893: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	.word 0xd8bfce60  ! 894: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	.word 0x87802074  ! 895: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b56000  ! 896: STHA_I	stha	%r9, [%r21 + 0x0000] %asi
	.word 0xdad7ce60  ! 897: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r13
	.word 0xd4ad84a0  ! 898: STBA_R	stba	%r10, [%r22 + %r0] 0x25
	.word 0xd8f5a000  ! 899: STXA_I	stxa	%r12, [%r22 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x3d0, %r20
	.word 0xde9c0400  ! 902: LDDA_R	ldda	[%r16, %r0] 0x20, %r15
	.word 0xdef5e000  ! 903: STXA_I	stxa	%r15, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 904: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf584a0  ! 905: STXA_R	stxa	%r14, [%r22 + %r0] 0x25
	.word 0x8780204f  ! 906: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r27
	.word 0xd89f8e80  ! 908: LDDA_R	ldda	[%r30, %r0] 0x74, %r12
	.word 0xd2ce49e0  ! 909: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r9
	.word 0xd29fe000  ! 910: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	mov	0x20, %r24
	mov	0x40, %r26
	mov	0x3e8, %r22
	mov	0x68, %r17
	.word 0xd6d4c400  ! 915: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	.word 0xd0af6000  ! 916: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 917: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cfce80  ! 918: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r10
	.word 0xd2cf6000  ! 919: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	mov	0x8, %r19
	.word 0x87802020  ! 921: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd895c4a0  ! 922: LDUHA_R	lduha	[%r23, %r0] 0x25, %r12
	.word 0x87802025  ! 923: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc874e60  ! 924: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r14
	mov	0x3e0, %r22
	.word 0x87802072  ! 926: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbf0e80  ! 927: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	.word 0x87802072  ! 928: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d0, %r20
	.word 0x87802025  ! 930: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 931: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a504a0  ! 932: STWA_R	stwa	%r8, [%r20 + %r0] 0x25
	.word 0xd8dca000  ! 933: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	mov	0x58, %r16
	.word 0x87802074  ! 935: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r24
	.word 0xd0a544a0  ! 937: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	.word 0xd4846000  ! 938: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r10
	.word 0x87802074  ! 939: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdebf8e40  ! 940: STDA_R	stda	%r15, [%r30 + %r0] 0x72
	.word 0xdca40400  ! 941: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xd0f46000  ! 942: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 943: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a56000  ! 944: STWA_I	stwa	%r8, [%r21 + 0x0000] %asi
	.word 0xd0bda000  ! 945: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	.word 0xd0b56000  ! 946: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	.word 0xd0952000  ! 947: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r8
	.word 0x87802025  ! 948: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8be49e0  ! 949: STDA_R	stda	%r12, [%r25 + %r0] 0x4f
	mov	0x10, %r18
	mov	0x7f0, %r20
	.word 0xdeace000  ! 952: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	mov	0x30, %r19
	.word 0xd6bd04a0  ! 954: STDA_R	stda	%r11, [%r20 + %r0] 0x25
	.word 0xdcac2000  ! 955: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xdcf74e40  ! 957: STXA_R	stxa	%r14, [%r29 + %r0] 0x72
	mov	0x3f0, %r21
	mov	0x58, %r25
	mov	0x30, %r19
	.word 0xd6c4a000  ! 961: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r11
	.word 0xd6a4a000  ! 962: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	mov	0x8, %r27
	.word 0xd684a000  ! 964: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r11
	.word 0xd6b4a000  ! 965: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd6a4a000  ! 966: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	.word 0xd0bf4e40  ! 967: STDA_R	stda	%r8, [%r29 + %r0] 0x72
	.word 0xdc8f0e60  ! 968: LDUBA_R	lduba	[%r28, %r0] 0x73, %r14
	.word 0x87802073  ! 969: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca78e40  ! 970: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	.word 0xd2c4a000  ! 971: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	.word 0x87802074  ! 972: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa78e40  ! 973: STWA_R	stwa	%r13, [%r30 + %r0] 0x72
	.word 0xdc8d6000  ! 974: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r14
	.word 0x87802072  ! 975: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cc8400  ! 976: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	.word 0xd6a46000  ! 977: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0xd8aec9e0  ! 978: STBA_R	stba	%r12, [%r27 + %r0] 0x4f
	.word 0xda84a000  ! 979: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	mov	0x7e0, %r20
	.word 0xda846000  ! 981: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r13
	mov	0x3f0, %r21
	.word 0xdca78e80  ! 983: STWA_R	stwa	%r14, [%r30 + %r0] 0x74
	.word 0xded4a000  ! 984: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	.word 0xd28f4e80  ! 985: LDUBA_R	lduba	[%r29, %r0] 0x74, %r9
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802020  ! 987: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdecf2000  ! 988: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0x87802020  ! 989: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebd6000  ! 990: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	.word 0xdef5e000  ! 991: STXA_I	stxa	%r15, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 992: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r25
	.word 0xde97e000  ! 994: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0xde8f2000  ! 995: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xdecfa000  ! 996: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0x87802074  ! 997: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r26
	.word 0x87802072  ! 999: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd09cc400  ! 1000: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	.word 0x87802020  ! 1001: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcd78e80  ! 1002: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r14
	.word 0xd2af0e60  ! 1003: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	.word 0xd0840400  ! 1004: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	.word 0xd6c48400  ! 1005: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	.word 0xd29ca000  ! 1006: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	.word 0xd28c6000  ! 1007: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	mov	0x7c0, %r21
	mov	0x60, %r26
	.word 0xd2d74e80  ! 1010: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r9
	.word 0xd8dc6000  ! 1011: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	mov	0x7e0, %r21
	mov	0x7c8, %r21
	mov	0x0, %r19
	.word 0xd8a46000  ! 1015: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	mov	0x28, %r24
	mov	0x7f0, %r23
	mov	0x7f8, %r23
	.word 0xd4870e60  ! 1019: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r10
	.word 0xdef4a000  ! 1020: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0xd6dd84a0  ! 1021: LDXA_R	ldxa	[%r22, %r0] 0x25, %r11
	.word 0x87802025  ! 1022: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde84c400  ! 1023: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0xdeccc400  ! 1024: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r15
	.word 0x87802020  ! 1025: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r25
	.word 0xdcc7e000  ! 1027: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0xdef6c9e0  ! 1028: STXA_R	stxa	%r15, [%r27 + %r0] 0x4f
	.word 0xd4a70e60  ! 1029: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	.word 0xdcb40400  ! 1030: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xdc8fe000  ! 1031: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	mov	0x3f8, %r23
	mov	0x0, %r19
	mov	0x7e0, %r20
	mov	0x60, %r17
	mov	0x70, %r17
	.word 0xd4b6c9e0  ! 1037: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0xd6a4c400  ! 1038: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	mov	0x18, %r26
	.word 0x87802072  ! 1040: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7c8, %r23
	mov	0x7e0, %r23
	.word 0xd095a000  ! 1043: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r8
	mov	0x0, %r16
	.word 0xdef74e60  ! 1045: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	.word 0xd08689e0  ! 1046: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r8
	.word 0xd8cd6000  ! 1047: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r12
	.word 0xd8ada000  ! 1048: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 1049: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdea44400  ! 1050: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xdeaf0e40  ! 1051: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	.word 0x87802072  ! 1052: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7e8, %r20
	mov	0x10, %r24
	.word 0xd0f52000  ! 1055: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0xd0d5a000  ! 1057: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r8
	.word 0xd0b5e000  ! 1058: STHA_I	stha	%r8, [%r23 + 0x0000] %asi
	mov	0x50, %r18
	.word 0xd28f8e40  ! 1060: LDUBA_R	lduba	[%r30, %r0] 0x72, %r9
	mov	0x50, %r26
	mov	0x40, %r19
	.word 0xd0b44400  ! 1063: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xd6f44400  ! 1064: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0xd685a000  ! 1065: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r11
	.word 0xd6dd6000  ! 1066: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r11
	.word 0x87802020  ! 1067: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd694e000  ! 1068: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r11
	.word 0x87802073  ! 1069: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd69f2000  ! 1070: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0x87802020  ! 1071: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabcc400  ! 1072: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	.word 0x87802072  ! 1073: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebc2000  ! 1074: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 1075: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6848400  ! 1076: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	mov	0x18, %r18
	.word 0xdec584a0  ! 1078: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r15
	.word 0xd4dfe000  ! 1079: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1080: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d76000  ! 1081: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0x87802025  ! 1082: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r27
	.word 0xd48ec9e0  ! 1084: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r10
	.word 0xdcbf2000  ! 1085: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdcbf6000  ! 1086: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1087: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r16
	.word 0xdcbca000  ! 1089: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdcb46000  ! 1090: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xdc8ca000  ! 1091: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 1092: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdece09e0  ! 1093: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r15
	.word 0xd6f74e60  ! 1094: STXA_R	stxa	%r11, [%r29 + %r0] 0x73
	.word 0xd2d689e0  ! 1095: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r9
	.word 0x87802073  ! 1096: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8cfe000  ! 1097: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0x87802073  ! 1098: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 1099: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc9cc400  ! 1100: LDDA_R	ldda	[%r19, %r0] 0x20, %r14
	mov	0x20, %r18
	.word 0xdaf62000  ! 1102: STXA_I	stxa	%r13, [%r24 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd4c7ce60  ! 1104: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r10
	mov	0x0, %r24
	.word 0xd6a7ce80  ! 1106: STWA_R	stwa	%r11, [%r31 + %r0] 0x74
	mov	0x10, %r18
	mov	0x38, %r17
	.word 0xd0940400  ! 1109: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	.word 0xd0b78e40  ! 1110: STHA_R	stha	%r8, [%r30 + %r0] 0x72
	.word 0xdccf0e80  ! 1111: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r14
	.word 0xd88e6000  ! 1112: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r12
	.word 0xd8aea000  ! 1113: STBA_I	stba	%r12, [%r26 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0x87802073  ! 1115: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f4a000  ! 1116: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	mov	0x58, %r18
	.word 0xd2a504a0  ! 1118: STWA_R	stwa	%r9, [%r20 + %r0] 0x25
	.word 0xd28c6000  ! 1119: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0x87802025  ! 1120: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2a6a000  ! 1121: STWA_I	stwa	%r9, [%r26 + 0x0000] %asi
	mov	0x38, %r26
	mov	0x3f0, %r21
	.word 0xd2f6a000  ! 1124: STXA_I	stxa	%r9, [%r26 + 0x0000] %asi
	.word 0xd2ce6000  ! 1125: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 1126: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 1127: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd08609e0  ! 1128: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r8
	.word 0xd29fa000  ! 1129: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 1130: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2c7e000  ! 1131: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2f7a000  ! 1132: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 1133: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xded544a0  ! 1134: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r15
	.word 0x87802074  ! 1135: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcd6a000  ! 1136: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r14
	.word 0xdcde6000  ! 1137: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r14
	.word 0xdaa48400  ! 1138: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0xd2b44400  ! 1139: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0xd29e2000  ! 1140: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r9
	.word 0xd2aee000  ! 1141: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	.word 0x87802074  ! 1142: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b72000  ! 1143: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1144: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabf4e80  ! 1145: STDA_R	stda	%r13, [%r29 + %r0] 0x74
	.word 0xdef78e40  ! 1146: STXA_R	stxa	%r15, [%r30 + %r0] 0x72
	.word 0xd6f7ce80  ! 1147: STXA_R	stxa	%r11, [%r31 + %r0] 0x74
	mov	0x7e0, %r23
	mov	0x30, %r19
	.word 0xdedf8e60  ! 1150: LDXA_R	ldxa	[%r30, %r0] 0x73, %r15
	.word 0x87802073  ! 1151: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r18
	.word 0xda9f6000  ! 1153: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xda8fe000  ! 1154: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	mov	0x30, %r26
	.word 0xd2acc400  ! 1156: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	mov	0x48, %r26
	.word 0xdcdf4e80  ! 1158: LDXA_R	ldxa	[%r29, %r0] 0x74, %r14
	.word 0xda9f2000  ! 1159: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0x87802074  ! 1160: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda8f2000  ! 1161: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1162: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r24
	.word 0xdab5a000  ! 1164: STHA_I	stha	%r13, [%r22 + 0x0000] %asi
	.word 0xdadd6000  ! 1165: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r13
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdad5e000  ! 1167: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r13
	.word 0x87802072  ! 1168: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r27
	mov	0x18, %r24
	.word 0xdadf2000  ! 1171: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0xdaf7a000  ! 1172: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdab72000  ! 1173: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xdab72000  ! 1175: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xd2dc8400  ! 1176: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd4f609e0  ! 1178: STXA_R	stxa	%r10, [%r24 + %r0] 0x4f
	.word 0xd2876000  ! 1179: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xd29fa000  ! 1180: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd8a7ce60  ! 1181: STWA_R	stwa	%r12, [%r31 + %r0] 0x73
	mov	0x28, %r17
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802073  ! 1184: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r25
	.word 0x87802072  ! 1186: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r18
	mov	0x20, %r18
	mov	0x30, %r26
	.word 0x87802020  ! 1190: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r21
	mov	0x7e8, %r23
	.word 0xdea7ce40  ! 1193: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	mov	0x8, %r17
	mov	0x30, %r25
	mov	0x7e8, %r23
	.word 0xdcaf2000  ! 1197: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	mov	0x7e0, %r20
	.word 0xdca7a000  ! 1199: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 1200: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x7e0, %r21
	mov	0x10, %r27
	.word 0xdc87e000  ! 1204: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcdfa000  ! 1205: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	mov	0x20, %r19
	.word 0x87802074  ! 1207: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcc649e0  ! 1208: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r14
	mov	0x60, %r27
	.word 0xd4c7ce40  ! 1210: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r10
	.word 0xd0b6a000  ! 1211: STHA_I	stha	%r8, [%r26 + 0x0000] %asi
	.word 0xd0de2000  ! 1212: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r8
	.word 0xd0c6a000  ! 1213: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r8
	.word 0xd0dea000  ! 1214: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r8
	.word 0xd0b62000  ! 1215: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0xd0bc0400  ! 1216: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0xd8d70e60  ! 1217: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r12
	.word 0xdef6e000  ! 1218: STXA_I	stxa	%r15, [%r27 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdeb6e000  ! 1220: STHA_I	stha	%r15, [%r27 + 0x0000] %asi
	.word 0xdef6a000  ! 1221: STXA_I	stxa	%r15, [%r26 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0xda9d84a0  ! 1223: LDDA_R	ldda	[%r22, %r0] 0x25, %r13
	.word 0x87802073  ! 1224: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdedec9e0  ! 1225: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r15
	.word 0xd09c8400  ! 1226: LDDA_R	ldda	[%r18, %r0] 0x20, %r8
	.word 0xd8870e40  ! 1227: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r12
	.word 0xd2974e60  ! 1228: LDUHA_R	lduha	[%r29, %r0] 0x73, %r9
	.word 0xd6f7ce40  ! 1229: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	.word 0xdecd2000  ! 1230: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r15
	.word 0xde856000  ! 1231: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r15
	.word 0xd4b6c9e0  ! 1232: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0xd6a56000  ! 1233: STWA_I	stwa	%r11, [%r21 + 0x0000] %asi
	mov	0x0, %r18
	.word 0xd0cf4e60  ! 1235: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r8
	.word 0xdef44400  ! 1236: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xdcdd84a0  ! 1237: LDXA_R	ldxa	[%r22, %r0] 0x25, %r14
	mov	0x7e8, %r22
	.word 0x87802072  ! 1239: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r27
	.word 0xd0a6c9e0  ! 1241: STWA_R	stwa	%r8, [%r27 + %r0] 0x4f
	.word 0xd2f4c400  ! 1242: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xd8a76000  ! 1243: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1244: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28f0e60  ! 1245: LDUBA_R	lduba	[%r28, %r0] 0x73, %r9
	.word 0x87802072  ! 1246: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1247: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ad2000  ! 1248: STBA_I	stba	%r10, [%r20 + 0x0000] %asi
	mov	0x70, %r16
	.word 0xd2ae09e0  ! 1250: STBA_R	stba	%r9, [%r24 + %r0] 0x4f
	.word 0xd0856000  ! 1251: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r8
	.word 0xd0cc4400  ! 1252: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	.word 0xd8f6c9e0  ! 1253: STXA_R	stxa	%r12, [%r27 + %r0] 0x4f
	.word 0xd29f8e60  ! 1254: LDDA_R	ldda	[%r30, %r0] 0x73, %r9
	mov	0x3d0, %r20
	.word 0xdcad04a0  ! 1256: STBA_R	stba	%r14, [%r20 + %r0] 0x25
	.word 0xdca5a000  ! 1257: STWA_I	stwa	%r14, [%r22 + 0x0000] %asi
	.word 0xd2af0e60  ! 1258: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	.word 0xdeb609e0  ! 1259: STHA_R	stha	%r15, [%r24 + %r0] 0x4f
	.word 0xd49c0400  ! 1260: LDDA_R	ldda	[%r16, %r0] 0x20, %r10
	mov	0x50, %r16
	.word 0xd0bd6000  ! 1262: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0xd0dda000  ! 1263: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r8
	.word 0xdc874e60  ! 1264: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r14
	.word 0xd4dd6000  ! 1265: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r10
	.word 0xd4856000  ! 1266: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r10
	mov	0x7c8, %r22
	.word 0xd6cf4e80  ! 1268: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r11
	mov	0x7c8, %r23
	mov	0x7f0, %r23
	mov	0x68, %r26
	mov	0x7d8, %r21
	.word 0xd8952000  ! 1273: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r12
	mov	0x3d8, %r21
	.word 0xd8b5e000  ! 1275: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 1276: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd88f2000  ! 1277: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0xd08c8400  ! 1278: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0xd2bec9e0  ! 1279: STDA_R	stda	%r9, [%r27 + %r0] 0x4f
	.word 0x87802073  ! 1280: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd69da000  ! 1281: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r11
	.word 0x87802020  ! 1282: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r20
	.word 0xd6870e80  ! 1284: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r11
	.word 0xdaf7e000  ! 1285: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xdadf6000  ! 1286: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xdcb40400  ! 1287: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xd887ce80  ! 1288: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r12
	mov	0x7f8, %r21
	.word 0xd0bc0400  ! 1290: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0xd4b70e40  ! 1291: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	.word 0xd8a5c4a0  ! 1292: STWA_R	stwa	%r12, [%r23 + %r0] 0x25
	.word 0xdcaf6000  ! 1293: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	mov	0x10, %r26
	.word 0xd29ec9e0  ! 1295: LDDA_R	ldda	[%r27, %r0] 0x4f, %r9
	.word 0xd6b7e000  ! 1296: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 1297: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6d4a000  ! 1298: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r11
	.word 0xd2940400  ! 1299: LDUHA_R	lduha	[%r16, %r0] 0x20, %r9
	.word 0x87802020  ! 1300: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd89504a0  ! 1301: LDUHA_R	lduha	[%r20, %r0] 0x25, %r12
	.word 0xd0b52000  ! 1302: STHA_I	stha	%r8, [%r20 + 0x0000] %asi
	mov	0x18, %r18
	.word 0xd6bf8e80  ! 1304: STDA_R	stda	%r11, [%r30 + %r0] 0x74
	mov	0x40, %r25
	.word 0xd08504a0  ! 1306: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r8
	.word 0xdcdfce80  ! 1307: LDXA_R	ldxa	[%r31, %r0] 0x74, %r14
	.word 0xdcc56000  ! 1308: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r14
	.word 0xda9544a0  ! 1309: LDUHA_R	lduha	[%r21, %r0] 0x25, %r13
	.word 0x87802074  ! 1310: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6ccc400  ! 1311: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	.word 0xd6ccc400  ! 1312: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802073  ! 1314: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a74e60  ! 1315: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	.word 0x87802020  ! 1316: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b42000  ! 1317: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0xd6a40400  ! 1318: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0xdade49e0  ! 1319: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r13
	.word 0xdcdce000  ! 1320: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r14
	.word 0xd68d44a0  ! 1321: LDUBA_R	lduba	[%r21, %r0] 0x25, %r11
	.word 0xd6842000  ! 1322: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r11
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd68ce000  ! 1324: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	.word 0xd6842000  ! 1325: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r11
	mov	0x8, %r17
	mov	0x3c8, %r21
	mov	0x7c0, %r20
	.word 0xd6d42000  ! 1329: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r11
	.word 0x87802025  ! 1330: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r19
	.word 0xd6dfa000  ! 1332: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0xdeadc4a0  ! 1333: STBA_R	stba	%r15, [%r23 + %r0] 0x25
	.word 0x87802074  ! 1334: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r25
	.word 0xdaa48400  ! 1336: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0xd4d4a000  ! 1337: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0xdab44400  ! 1338: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0x87802020  ! 1339: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d7ce80  ! 1340: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r10
	mov	0x48, %r18
	.word 0xdcf46000  ! 1342: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xd4c544a0  ! 1343: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r10
	mov	0x3d8, %r20
	.word 0x8780204f  ! 1345: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf649e0  ! 1346: STXA_R	stxa	%r14, [%r25 + %r0] 0x4f
	.word 0xd4844400  ! 1347: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	mov	0x60, %r26
	.word 0x87802025  ! 1349: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2ccc400  ! 1350: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	.word 0xd0872000  ! 1351: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 1352: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0ad6000  ! 1353: STBA_I	stba	%r8, [%r21 + 0x0000] %asi
	.word 0x87802074  ! 1354: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r26
	.word 0xd087a000  ! 1356: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0x87802072  ! 1357: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0afa000  ! 1358: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd0d72000  ! 1359: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd2b609e0  ! 1360: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	mov	0x68, %r19
	.word 0xdadf4e60  ! 1362: LDXA_R	ldxa	[%r29, %r0] 0x73, %r13
	.word 0xda9f2000  ! 1363: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0x87802074  ! 1364: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd29e49e0  ! 1365: LDDA_R	ldda	[%r25, %r0] 0x4f, %r9
	.word 0xd8ad04a0  ! 1366: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	mov	0x30, %r26
	.word 0xd0b609e0  ! 1368: STHA_R	stha	%r8, [%r24 + %r0] 0x4f
	mov	0x68, %r27
	.word 0xde8dc4a0  ! 1370: LDUBA_R	lduba	[%r23, %r0] 0x25, %r15
	mov	0x7d0, %r20
	mov	0x3f8, %r23
	.word 0xd8ade000  ! 1373: STBA_I	stba	%r12, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 1374: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ac2000  ! 1375: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 1376: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8b4e000  ! 1377: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	mov	0x30, %r16
	.word 0xd8a46000  ! 1379: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8a4e000  ! 1380: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xd8b4a000  ! 1381: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0xd8a4e000  ! 1382: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0x87802025  ! 1384: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a70e80  ! 1385: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	mov	0x3d0, %r23
	.word 0xdaa40400  ! 1387: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	mov	0x18, %r19
	.word 0xd6aca000  ! 1389: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xdca7ce80  ! 1390: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	.word 0xdca42000  ! 1391: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	mov	0x7e0, %r22
	.word 0x87802020  ! 1393: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88584a0  ! 1394: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r12
	.word 0x87802025  ! 1395: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d8, %r22
	.word 0xd6afe000  ! 1397: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd4a7ce40  ! 1398: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	.word 0x87802020  ! 1399: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bfce40  ! 1400: STDA_R	stda	%r8, [%r31 + %r0] 0x72
	.word 0xd4d40400  ! 1401: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	.word 0xd2af0e40  ! 1402: STBA_R	stba	%r9, [%r28 + %r0] 0x72
	.word 0xdedc8400  ! 1403: LDXA_R	ldxa	[%r18, %r0] 0x20, %r15
	.word 0xd0afe000  ! 1404: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0dfa000  ! 1405: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	mov	0x0, %r26
	mov	0x10, %r18
	.word 0xd087e000  ! 1408: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0b7a000  ! 1409: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd0bf2000  ! 1410: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 1411: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde978e40  ! 1412: LDUHA_R	lduha	[%r30, %r0] 0x72, %r15
	.word 0xdcb48400  ! 1413: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xdc8c8400  ! 1414: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0xd0b48400  ! 1415: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0x87802074  ! 1416: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 1417: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde844400  ! 1418: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	.word 0xdadf2000  ! 1419: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0xdad76000  ! 1420: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0x87802074  ! 1421: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacfe000  ! 1422: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0xda8ec9e0  ! 1423: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r13
	.word 0x87802073  ! 1424: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0df4e80  ! 1425: LDXA_R	ldxa	[%r29, %r0] 0x74, %r8
	.word 0xd8a4c400  ! 1426: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xda84e000  ! 1427: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r13
	mov	0x70, %r24
	mov	0x8, %r17
	mov	0x60, %r24
	.word 0xdac4a000  ! 1431: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	.word 0xd6f6c9e0  ! 1432: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	.word 0xdcf74e40  ! 1433: STXA_R	stxa	%r14, [%r29 + %r0] 0x72
	.word 0xdaac2000  ! 1434: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 1435: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r18
	.word 0xdac7e000  ! 1437: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xdac72000  ! 1438: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	mov	0x3d0, %r20
	.word 0x87802020  ! 1440: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf7e000  ! 1441: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xdacf6000  ! 1442: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xdaaf2000  ! 1443: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	mov	0x3e0, %r23
	.word 0xdad76000  ! 1445: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	mov	0x0, %r26
	.word 0x87802020  ! 1447: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b584a0  ! 1448: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	.word 0x87802025  ! 1449: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaaf0e80  ! 1450: STBA_R	stba	%r13, [%r28 + %r0] 0x74
	.word 0xd097a000  ! 1451: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	.word 0x87802073  ! 1452: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0846000  ! 1453: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	mov	0x30, %r26
	mov	0x20, %r24
	.word 0xd0cc4400  ! 1456: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	.word 0xdeb46000  ! 1457: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0xdebc6000  ! 1459: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0x8780204f  ! 1461: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f0, %r22
	mov	0x3f8, %r20
	mov	0x50, %r18
	.word 0xd4af8e80  ! 1465: STBA_R	stba	%r10, [%r30 + %r0] 0x74
	.word 0xdadda000  ! 1466: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r13
	.word 0xdabd2000  ! 1467: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	mov	0x8, %r19
	.word 0xd4870e80  ! 1469: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r10
	.word 0x87802020  ! 1470: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a40400  ! 1471: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	.word 0xd29e49e0  ! 1472: LDDA_R	ldda	[%r25, %r0] 0x4f, %r9
	.word 0xdcc70e80  ! 1473: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r14
	.word 0xdcbde000  ! 1474: STDA_I	stda	%r14, [%r23 + 0x0000] %asi
	.word 0xdcdd6000  ! 1475: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r14
	mov	0x3f8, %r23
	.word 0xdcdd84a0  ! 1477: LDXA_R	ldxa	[%r22, %r0] 0x25, %r14
	mov	0x3f0, %r23
	.word 0xd4bd2000  ! 1479: STDA_I	stda	%r10, [%r20 + 0x0000] %asi
	mov	0x48, %r17
	.word 0xdeb504a0  ! 1481: STHA_R	stha	%r15, [%r20 + %r0] 0x25
	.word 0xd8bd6000  ! 1482: STDA_I	stda	%r12, [%r21 + 0x0000] %asi
	.word 0xd8bda000  ! 1483: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	.word 0xd8f52000  ! 1484: STXA_I	stxa	%r12, [%r20 + 0x0000] %asi
	.word 0xd8cda000  ! 1485: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r12
	.word 0xd08f8e80  ! 1486: LDUBA_R	lduba	[%r30, %r0] 0x74, %r8
	mov	0x20, %r19
	mov	0x30, %r27
	.word 0x87802025  ! 1489: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e0, %r21
	.word 0xd094e000  ! 1491: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0xd0b46000  ! 1492: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	mov	0x7c0, %r20
	.word 0xdca44400  ! 1494: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0x87802020  ! 1495: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bdc4a0  ! 1496: STDA_R	stda	%r8, [%r23 + %r0] 0x25
	.word 0xdaa70e80  ! 1497: STWA_R	stwa	%r13, [%r28 + %r0] 0x74
	.word 0xd0bfce40  ! 1498: STDA_R	stda	%r8, [%r31 + %r0] 0x72
	mov	0x10, %r24
	mov	0x48, %r16
	mov	0x78, %r27
	mov	0x20, %r26
	mov	0x40, %r16
	mov	0x60, %r18
	.word 0xd6b70e80  ! 1505: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	.word 0x8780204f  ! 1506: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4cf8e60  ! 1507: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r10
	.word 0xdc862000  ! 1508: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r14
	.word 0xd6bdc4a0  ! 1509: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	mov	0x3c8, %r23
	.word 0xd6af0e80  ! 1511: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	.word 0xdac584a0  ! 1512: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r13
	.word 0xd6acc400  ! 1513: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xdad66000  ! 1514: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r13
	.word 0x87802072  ! 1515: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcd584a0  ! 1516: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r14
	.word 0xde9c2000  ! 1517: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xdea4e000  ! 1518: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xd8840400  ! 1519: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r12
	.word 0xd8a70e80  ! 1520: STWA_R	stwa	%r12, [%r28 + %r0] 0x74
	mov	0x7d8, %r23
	.word 0xdeb4a000  ! 1522: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 1523: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r26
	.word 0xdeb4a000  ! 1525: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0xde8ca000  ! 1526: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0xd8a44400  ! 1527: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xdc9c6000  ! 1528: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r14
	.word 0xdef70e80  ! 1529: STXA_R	stxa	%r15, [%r28 + %r0] 0x74
	mov	0x18, %r27
	.word 0xd6bd04a0  ! 1531: STDA_R	stda	%r11, [%r20 + %r0] 0x25
	.word 0xd8b70e80  ! 1532: STHA_R	stha	%r12, [%r28 + %r0] 0x74
	.word 0xd29cc400  ! 1533: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	.word 0xd0d4e000  ! 1534: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	.word 0xd4b70e40  ! 1535: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	.word 0xd0b70e40  ! 1536: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	mov	0x18, %r16
	mov	0x3c0, %r20
	.word 0xd6ad84a0  ! 1539: STBA_R	stba	%r11, [%r22 + %r0] 0x25
	.word 0xd0f46000  ! 1540: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	mov	0x20, %r26
	.word 0x87802020  ! 1542: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1543: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r24
	mov	0x58, %r19
	.word 0xd0d7e000  ! 1546: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xd6af8e80  ! 1547: STBA_R	stba	%r11, [%r30 + %r0] 0x74
	mov	0x7c0, %r22
	.word 0xdadf6000  ! 1549: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xdadfa000  ! 1550: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xd0d649e0  ! 1551: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r8
	.word 0xd2d7e000  ! 1552: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xdebf0e40  ! 1553: STDA_R	stda	%r15, [%r28 + %r0] 0x72
	.word 0xd6c504a0  ! 1554: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r11
	.word 0xde97e000  ! 1555: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0xde9f2000  ! 1556: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	mov	0x7e8, %r20
	.word 0xded7a000  ! 1558: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xd4af4e80  ! 1559: STBA_R	stba	%r10, [%r29 + %r0] 0x74
	.word 0xd6cfa000  ! 1560: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	mov	0x68, %r24
	mov	0x3d0, %r23
	mov	0x18, %r18
	.word 0xd0d44400  ! 1564: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r8
	mov	0x40, %r19
	.word 0x87802020  ! 1566: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea4a000  ! 1567: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xd4d74e60  ! 1569: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r10
	.word 0xdc978e60  ! 1570: LDUHA_R	lduha	[%r30, %r0] 0x73, %r14
	.word 0xd69c6000  ! 1571: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r11
	.word 0xd6b46000  ! 1572: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd2bf4e80  ! 1573: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	mov	0x18, %r25
	mov	0x38, %r19
	.word 0x87802072  ! 1576: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1577: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r27
	mov	0x60, %r27
	.word 0x87802020  ! 1580: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1581: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ac6000  ! 1582: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	mov	0x60, %r19
	.word 0xd6dce000  ! 1584: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0xd8bf8e40  ! 1585: STDA_R	stda	%r12, [%r30 + %r0] 0x72
	.word 0xdaa70e80  ! 1586: STWA_R	stwa	%r13, [%r28 + %r0] 0x74
	.word 0xd6f74e40  ! 1587: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	.word 0xdac6c9e0  ! 1588: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r13
	.word 0xdcb4a000  ! 1589: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xdca4a000  ! 1590: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcbfce40  ! 1591: STDA_R	stda	%r14, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 1592: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 1593: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd09649e0  ! 1594: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r8
	mov	0x48, %r19
	.word 0xdcdc0400  ! 1596: LDXA_R	ldxa	[%r16, %r0] 0x20, %r14
	mov	0x7c8, %r22
	mov	0x28, %r18
	.word 0xd0a42000  ! 1599: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xd0f4a000  ! 1600: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	mov	0x3f0, %r23
	.word 0x8780204f  ! 1602: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b78e60  ! 1603: STHA_R	stha	%r12, [%r30 + %r0] 0x73
	.word 0xd4a74e80  ! 1604: STWA_R	stwa	%r10, [%r29 + %r0] 0x74
	.word 0xdeafce40  ! 1605: STBA_R	stba	%r15, [%r31 + %r0] 0x72
	.word 0xd8d42000  ! 1606: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0xd0bfce60  ! 1607: STDA_R	stda	%r8, [%r31 + %r0] 0x73
	.word 0x87802020  ! 1608: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r19
	.word 0xd4ce2000  ! 1610: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r10
	.word 0xdad7ce40  ! 1611: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r13
	.word 0xd0af8e60  ! 1612: STBA_R	stba	%r8, [%r30 + %r0] 0x73
	mov	0x3d0, %r22
	.word 0xde8e6000  ! 1614: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r15
	mov	0x7c0, %r23
	.word 0x87802073  ! 1616: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xded4e000  ! 1617: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	.word 0xdef42000  ! 1618: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	mov	0x28, %r19
	.word 0xdebc2000  ! 1620: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	mov	0x50, %r18
	.word 0x87802020  ! 1622: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d4c400  ! 1623: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0x87802072  ! 1624: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f7ce40  ! 1625: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	.word 0x87802073  ! 1626: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0dca000  ! 1627: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	mov	0x7e0, %r23
	mov	0x7c0, %r22
	.word 0xdcd40400  ! 1630: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	.word 0xd68ec9e0  ! 1631: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r11
	mov	0x3e8, %r20
	.word 0x87802073  ! 1633: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcdd04a0  ! 1634: LDXA_R	ldxa	[%r20, %r0] 0x25, %r14
	.word 0xda87a000  ! 1635: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	mov	0x40, %r25
	mov	0x60, %r19
	.word 0xdaa7e000  ! 1638: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 1639: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda952000  ! 1640: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r13
	.word 0xda974e40  ! 1641: LDUHA_R	lduha	[%r29, %r0] 0x72, %r13
	.word 0x87802025  ! 1642: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaa70e60  ! 1643: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	.word 0xd4a62000  ! 1644: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 1645: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r25
	.word 0xdacfce60  ! 1647: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r13
	mov	0x20, %r25
	.word 0xd094a000  ! 1649: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1650: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r16
	.word 0xd0afa000  ! 1652: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 1653: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0df0e80  ! 1654: LDXA_R	ldxa	[%r28, %r0] 0x74, %r8
	.word 0xd8f4e000  ! 1655: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	mov	0x3f0, %r20
	mov	0x7e0, %r21
	.word 0x87802074  ! 1658: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc848400  ! 1659: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	.word 0x87802074  ! 1660: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd29fce40  ! 1661: LDDA_R	ldda	[%r31, %r0] 0x72, %r9
	mov	0x40, %r24
	.word 0x87802074  ! 1663: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd09fa000  ! 1664: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	mov	0x7c8, %r20
	.word 0xd08fa000  ! 1666: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1667: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1668: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0d56000  ! 1669: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r8
	.word 0xd0b40400  ! 1670: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	mov	0x3d8, %r23
	mov	0x68, %r19
	.word 0xd4a7ce40  ! 1673: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	mov	0x0, %r18
	.word 0xded48400  ! 1675: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	.word 0x87802020  ! 1676: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcccc400  ! 1677: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	mov	0x7c8, %r22
	.word 0x87802072  ! 1679: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 1680: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8dec9e0  ! 1681: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r12
	.word 0xdcc7a000  ! 1682: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcdfe000  ! 1683: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	mov	0x78, %r25
	.word 0xdcb7a000  ! 1685: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xdcaf6000  ! 1686: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdc8f6000  ! 1687: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdc9fa000  ! 1688: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 1689: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcac2000  ! 1690: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0xdeaf0e40  ! 1691: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	.word 0xd6f42000  ! 1692: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	.word 0xd6ac2000  ! 1693: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 1694: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 1695: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 1696: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcc78e60  ! 1697: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r14
	.word 0xd2ad84a0  ! 1698: STBA_R	stba	%r9, [%r22 + %r0] 0x25
	.word 0xdcf584a0  ! 1699: STXA_R	stxa	%r14, [%r22 + %r0] 0x25
	mov	0x38, %r17
	mov	0x10, %r19
	.word 0xdeace000  ! 1702: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	mov	0x3d0, %r23
	.word 0xd0c70e40  ! 1704: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r8
	.word 0xd0f70e80  ! 1705: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0x87802020  ! 1706: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4acc400  ! 1707: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 1708: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2cf2000  ! 1709: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r9
	mov	0x7d8, %r22
	mov	0x7d0, %r22
	mov	0x38, %r25
	mov	0x18, %r16
	.word 0x87802074  ! 1714: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdab44400  ! 1715: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	mov	0x28, %r25
	.word 0xd09c2000  ! 1717: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r8
	.word 0xd6cec9e0  ! 1718: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r11
	.word 0xdebc2000  ! 1719: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xded42000  ! 1720: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	mov	0x28, %r17
	.word 0xdeaca000  ! 1722: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0xdecc6000  ! 1724: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r15
	.word 0xd0bf8e80  ! 1725: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	.word 0xd0d44400  ! 1726: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r8
	.word 0xd2f689e0  ! 1727: STXA_R	stxa	%r9, [%r26 + %r0] 0x4f
	.word 0xd2f78e60  ! 1728: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0xd8a78e80  ! 1729: STWA_R	stwa	%r12, [%r30 + %r0] 0x74
	.word 0xdebec9e0  ! 1730: STDA_R	stda	%r15, [%r27 + %r0] 0x4f
	.word 0xdcb42000  ! 1731: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xdcf4e000  ! 1732: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 1733: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r17
	.word 0xdeb44400  ! 1735: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0xd8b504a0  ! 1736: STHA_R	stha	%r12, [%r20 + %r0] 0x25
	mov	0x7c0, %r21
	mov	0x3d0, %r23
	.word 0xd4ce89e0  ! 1739: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r10
	.word 0x87802073  ! 1740: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda8f6000  ! 1741: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xdab72000  ! 1742: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xda870e80  ! 1743: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r13
	.word 0xd4cf4e40  ! 1744: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r10
	mov	0x3e0, %r21
	.word 0x87802074  ! 1746: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 1747: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc9ea000  ! 1748: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r14
	.word 0xdccee000  ! 1749: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r14
	.word 0xd6b504a0  ! 1750: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	mov	0x0, %r16
	.word 0xdaad44a0  ! 1752: STBA_R	stba	%r13, [%r21 + %r0] 0x25
	.word 0x87802020  ! 1753: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb74e40  ! 1754: STHA_R	stha	%r14, [%r29 + %r0] 0x72
	.word 0xd2b7a000  ! 1755: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 1756: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xded74e60  ! 1757: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r15
	mov	0x50, %r19
	.word 0xd8a7e000  ! 1759: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xd0be89e0  ! 1761: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 1762: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdebca000  ! 1764: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xde8c6000  ! 1765: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	mov	0x68, %r27
	.word 0xde9c2000  ! 1767: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xde8ca000  ! 1768: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0xdc84c400  ! 1769: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	.word 0xd29e49e0  ! 1770: LDDA_R	ldda	[%r25, %r0] 0x4f, %r9
	.word 0xdabc6000  ! 1771: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	mov	0x60, %r25
	.word 0xd4d584a0  ! 1773: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r10
	.word 0xd48ce000  ! 1774: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r10
	.word 0xd6af0e40  ! 1775: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	.word 0x87802074  ! 1776: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde8f0e60  ! 1777: LDUBA_R	lduba	[%r28, %r0] 0x73, %r15
	.word 0xd0878e40  ! 1778: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r8
	.word 0xdab76000  ! 1779: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 1780: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa42000  ! 1781: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0xd2b74e60  ! 1782: STHA_R	stha	%r9, [%r29 + %r0] 0x73
	.word 0xd6f74e80  ! 1783: STXA_R	stxa	%r11, [%r29 + %r0] 0x74
	.word 0xdad4a000  ! 1784: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	mov	0x78, %r27
	.word 0x87802020  ! 1786: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8ce000  ! 1787: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	.word 0xdaf46000  ! 1788: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0xdac42000  ! 1789: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1790: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa7a000  ! 1791: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 1792: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdac4a000  ! 1793: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	.word 0xda94e000  ! 1794: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r13
	mov	0x58, %r16
	.word 0xd68e89e0  ! 1796: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r11
	.word 0x87802020  ! 1797: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69fce80  ! 1798: LDDA_R	ldda	[%r31, %r0] 0x74, %r11
	mov	0x10, %r17
	.word 0xd4ad6000  ! 1800: STBA_I	stba	%r10, [%r21 + 0x0000] %asi
	mov	0x48, %r16
	.word 0x87802072  ! 1802: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc9d84a0  ! 1803: LDDA_R	ldda	[%r22, %r0] 0x25, %r14
	mov	0x38, %r17
	mov	0x18, %r16
	.word 0xd0a78e60  ! 1806: STWA_R	stwa	%r8, [%r30 + %r0] 0x73
	.word 0xd4a72000  ! 1807: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	mov	0x70, %r27
	.word 0x87802020  ! 1809: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f42000  ! 1810: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 1811: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 1812: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b46000  ! 1813: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xd4ac6000  ! 1814: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 1815: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4ae6000  ! 1816: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0xd4a6a000  ! 1817: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	.word 0xd4a66000  ! 1818: STWA_I	stwa	%r10, [%r25 + 0x0000] %asi
	.word 0x87802025  ! 1819: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e8, %r23
	.word 0x87802074  ! 1821: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd48f6000  ! 1822: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xd2c5c4a0  ! 1823: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r9
	.word 0x87802025  ! 1824: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb689e0  ! 1825: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	.word 0xd487e000  ! 1826: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd49f2000  ! 1827: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	mov	0x70, %r26
	.word 0xd0d6c9e0  ! 1829: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r8
	mov	0x78, %r18
	.word 0xd89f0e60  ! 1831: LDDA_R	ldda	[%r28, %r0] 0x73, %r12
	.word 0xd297ce80  ! 1832: LDUHA_R	lduha	[%r31, %r0] 0x74, %r9
	mov	0x3c8, %r23
	.word 0xd8ad44a0  ! 1834: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	.word 0x87802073  ! 1835: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8ac2000  ! 1836: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0xd8dc2000  ! 1837: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0xd6b544a0  ! 1838: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	.word 0x87802020  ! 1839: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac72000  ! 1840: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0xdec78e40  ! 1841: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r15
	.word 0x87802072  ! 1842: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r16
	mov	0x0, %r16
	.word 0xdc876000  ! 1845: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	mov	0x40, %r26
	.word 0xdccfe000  ! 1847: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0x87802073  ! 1848: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb72000  ! 1849: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 1850: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r24
	mov	0x7c8, %r21
	mov	0x18, %r27
	.word 0xd08f8e60  ! 1854: LDUBA_R	lduba	[%r30, %r0] 0x73, %r8
	.word 0xd0bc4400  ! 1855: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xd0dc6000  ! 1856: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	ta	T_CHANGE_PRIV	! macro
	.word 0xd0bca000  ! 1858: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0xd8ae89e0  ! 1859: STBA_R	stba	%r12, [%r26 + %r0] 0x4f
	.word 0xdea48400  ! 1860: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xd6a42000  ! 1861: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xd0ce49e0  ! 1862: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r8
	.word 0xd8cce000  ! 1863: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r12
	.word 0xdaa40400  ! 1864: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0xd0b4e000  ! 1865: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xd4b4c400  ! 1866: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0x87802020  ! 1867: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedca000  ! 1868: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xde9c2000  ! 1869: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0x87802020  ! 1870: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1871: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2a609e0  ! 1872: STWA_R	stwa	%r9, [%r24 + %r0] 0x4f
	.word 0xdcac8400  ! 1873: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xdea4c400  ! 1874: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	.word 0xd68cc400  ! 1875: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	.word 0xdabe89e0  ! 1876: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	.word 0xd687e000  ! 1877: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6f76000  ! 1878: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	mov	0x7e0, %r22
	.word 0x87802020  ! 1880: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r22
	.word 0xd2f7ce80  ! 1882: STXA_R	stxa	%r9, [%r31 + %r0] 0x74
	.word 0xd6f78e40  ! 1883: STXA_R	stxa	%r11, [%r30 + %r0] 0x72
	.word 0xdabec9e0  ! 1884: STDA_R	stda	%r13, [%r27 + %r0] 0x4f
	.word 0xd0f4e000  ! 1885: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	mov	0x7d0, %r23
	mov	0x30, %r25
	.word 0xd0d42000  ! 1888: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r8
	.word 0xd0dc6000  ! 1889: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	.word 0xd0bc6000  ! 1890: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 1891: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd09e2000  ! 1893: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r8
	.word 0x87802072  ! 1894: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd09ca000  ! 1895: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	.word 0xd0cce000  ! 1896: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0842000  ! 1897: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1898: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0c70e80  ! 1899: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r8
	mov	0x7d8, %r22
	.word 0xdcbd6000  ! 1901: STDA_I	stda	%r14, [%r21 + 0x0000] %asi
	.word 0xd8b78e40  ! 1902: STHA_R	stha	%r12, [%r30 + %r0] 0x72
	.word 0xd8a504a0  ! 1903: STWA_R	stwa	%r12, [%r20 + %r0] 0x25
	mov	0x7f0, %r21
	.word 0xd0b6c9e0  ! 1905: STHA_R	stha	%r8, [%r27 + %r0] 0x4f
	.word 0xd4f5e000  ! 1906: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	.word 0xdca584a0  ! 1907: STWA_R	stwa	%r14, [%r22 + %r0] 0x25
	mov	0x3e8, %r20
	.word 0xd4d40400  ! 1909: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	.word 0xdcb5a000  ! 1910: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0xd4c74e80  ! 1911: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r10
	.word 0xd0d70e60  ! 1912: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r8
	mov	0x3f8, %r23
	mov	0x20, %r25
	mov	0x3e8, %r20
	.word 0xd08584a0  ! 1916: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r8
	.word 0xd8ad2000  ! 1917: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	.word 0xd8a609e0  ! 1918: STWA_R	stwa	%r12, [%r24 + %r0] 0x4f
	.word 0xd4bec9e0  ! 1919: STDA_R	stda	%r10, [%r27 + %r0] 0x4f
	.word 0x87802072  ! 1920: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf78e80  ! 1921: STXA_R	stxa	%r14, [%r30 + %r0] 0x74
	.word 0xd68fe000  ! 1922: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xd6f7e000  ! 1923: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6cfa000  ! 1924: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0x87802073  ! 1925: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 1926: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef544a0  ! 1927: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	mov	0x3c8, %r23
	mov	0x7f8, %r20
	mov	0x0, %r19
	mov	0x3d0, %r20
	.word 0xdabca000  ! 1932: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xd08c0400  ! 1933: LDUBA_R	lduba	[%r16, %r0] 0x20, %r8
	.word 0xdcbce000  ! 1934: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xdc848400  ! 1935: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	.word 0xd6ac4400  ! 1936: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xd8f4a000  ! 1937: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	mov	0x3f8, %r23
	mov	0x40, %r27
	.word 0xd0f70e60  ! 1940: STXA_R	stxa	%r8, [%r28 + %r0] 0x73
	.word 0xd4dc0400  ! 1941: LDXA_R	ldxa	[%r16, %r0] 0x20, %r10
	.word 0xdebc6000  ! 1942: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xdea4a000  ! 1943: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xd2f6c9e0  ! 1944: STXA_R	stxa	%r9, [%r27 + %r0] 0x4f
	.word 0xda8f4e40  ! 1945: LDUBA_R	lduba	[%r29, %r0] 0x72, %r13
	.word 0x87802074  ! 1946: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c8, %r22
	mov	0x20, %r27
	.word 0xd0afe000  ! 1949: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xdadf0e60  ! 1950: LDXA_R	ldxa	[%r28, %r0] 0x73, %r13
	.word 0xd2ce49e0  ! 1951: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r9
	.word 0xd4a7e000  ! 1952: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xdc87ce40  ! 1953: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r14
	mov	0x40, %r25
	mov	0x8, %r16
	.word 0x87802074  ! 1956: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda878e60  ! 1957: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r13
	.word 0x87802073  ! 1958: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f46000  ! 1959: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 1960: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4bcc400  ! 1961: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	mov	0x3f8, %r20
	mov	0x58, %r24
	.word 0x87802072  ! 1964: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f72000  ! 1965: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6cfe000  ! 1966: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0x87802025  ! 1967: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 1968: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b72000  ! 1969: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd6b72000  ! 1970: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xdaf7ce60  ! 1972: STXA_R	stxa	%r13, [%r31 + %r0] 0x73
	.word 0xdcdf2000  ! 1973: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdccfe000  ! 1974: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xd0ac4400  ! 1975: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0xdcdf2000  ! 1976: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	mov	0x8, %r26
	mov	0x48, %r24
	.word 0xdcc72000  ! 1979: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xdca7e000  ! 1980: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdc9c4400  ! 1981: LDDA_R	ldda	[%r17, %r0] 0x20, %r14
	.word 0x87802020  ! 1982: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c609e0  ! 1983: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r10
	.word 0x8780204f  ! 1984: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x48, %r26
	mov	0x68, %r24
	.word 0xd2cf0e80  ! 1987: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r9
	.word 0x87802020  ! 1988: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1989: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1990: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1991: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b72000  ! 1992: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd0f44400  ! 1993: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0x87802073  ! 1994: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2be89e0  ! 1995: STDA_R	stda	%r9, [%r26 + %r0] 0x4f
	.word 0xd0af4e40  ! 1996: STBA_R	stba	%r8, [%r29 + %r0] 0x72
	.word 0xd6f6a000  ! 1997: STXA_I	stxa	%r11, [%r26 + 0x0000] %asi
	.word 0xd0f584a0  ! 1998: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	.word 0xd4a584a0  ! 1999: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	.word 0xdea6a000  ! 2000: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	.word 0xdea6a000  ! 2001: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	.word 0x87802072  ! 2002: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde8ca000  ! 2003: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0xdef42000  ! 2004: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xdcdf8e40  ! 2005: LDXA_R	ldxa	[%r30, %r0] 0x72, %r14
	.word 0xd8c70e80  ! 2006: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r12
	.word 0xdec4a000  ! 2007: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xdec4a000  ! 2008: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xd6cc4400  ! 2009: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	.word 0xd0f4a000  ! 2010: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xd084a000  ! 2011: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	mov	0x58, %r19
	.word 0x87802020  ! 2013: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdacfce40  ! 2014: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r13
	.word 0x87802020  ! 2015: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2016: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdec40400  ! 2017: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	mov	0x20, %r19
	.word 0xd0972000  ! 2019: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0f72000  ! 2020: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	mov	0x40, %r16
	.word 0x87802020  ! 2022: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b4a000  ! 2023: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xdaa70e60  ! 2024: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	.word 0xdabce000  ! 2025: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xdaac2000  ! 2027: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 2028: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b74e60  ! 2029: STHA_R	stha	%r11, [%r29 + %r0] 0x73
	.word 0xd0ce2000  ! 2030: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r8
	.word 0xd0862000  ! 2031: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r8
	.word 0xd2ad84a0  ! 2032: STBA_R	stba	%r9, [%r22 + %r0] 0x25
	mov	0x28, %r19
	.word 0xd6d649e0  ! 2034: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r11
	.word 0xdaaf8e80  ! 2035: STBA_R	stba	%r13, [%r30 + %r0] 0x74
	.word 0xd4ce09e0  ! 2036: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r10
	.word 0x8780204f  ! 2037: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbfa000  ! 2038: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xd8acc400  ! 2039: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	mov	0x3f0, %r23
	.word 0x87802025  ! 2041: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2042: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf42000  ! 2043: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 2044: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r16
	.word 0xd29f8e60  ! 2046: LDDA_R	ldda	[%r30, %r0] 0x73, %r9
	.word 0xd6c78e80  ! 2047: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r11
	.word 0xdcaf8e40  ! 2048: STBA_R	stba	%r14, [%r30 + %r0] 0x72
	mov	0x38, %r17
	.word 0xd6a72000  ! 2050: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6d76000  ! 2051: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	.word 0xd6d7e000  ! 2052: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	.word 0xd6f76000  ! 2053: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6afe000  ! 2054: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2055: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6dee000  ! 2056: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 2057: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b52000  ! 2058: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	mov	0x68, %r16
	.word 0xdc9d44a0  ! 2060: LDDA_R	ldda	[%r21, %r0] 0x25, %r14
	.word 0xd49d04a0  ! 2061: LDDA_R	ldda	[%r20, %r0] 0x25, %r10
	.word 0xdc95e000  ! 2062: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r14
	.word 0xdc852000  ! 2063: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r14
	.word 0xd4dfce40  ! 2064: LDXA_R	ldxa	[%r31, %r0] 0x72, %r10
	.word 0xd8a70e40  ! 2065: STWA_R	stwa	%r12, [%r28 + %r0] 0x72
	mov	0x18, %r27
	mov	0x48, %r18
	.word 0xd0b70e40  ! 2068: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	.word 0xdcc52000  ! 2069: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r14
	.word 0xdcbd2000  ! 2070: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	.word 0xdccd2000  ! 2071: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r14
	.word 0xd0af8e80  ! 2072: STBA_R	stba	%r8, [%r30 + %r0] 0x74
	.word 0xdad5a000  ! 2073: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2074: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf72000  ! 2075: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdac78e40  ! 2076: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r13
	.word 0x87802025  ! 2077: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb78e80  ! 2078: STHA_R	stha	%r14, [%r30 + %r0] 0x74
	.word 0xde9ca000  ! 2079: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	.word 0xde8ce000  ! 2080: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	.word 0xde8ca000  ! 2081: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0xd89e49e0  ! 2082: LDDA_R	ldda	[%r25, %r0] 0x4f, %r12
	.word 0xda9c2000  ! 2083: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	mov	0x60, %r18
	.word 0xd0dc0400  ! 2085: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xde9cc400  ! 2086: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	.word 0x87802025  ! 2087: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf7e000  ! 2088: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x3d8, %r22
	mov	0x40, %r16
	.word 0xd2d5c4a0  ! 2091: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r9
	.word 0xd4f7a000  ! 2092: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd8cec9e0  ! 2093: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r12
	.word 0xd28cc400  ! 2094: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	.word 0xde8cc400  ! 2095: LDUBA_R	lduba	[%r19, %r0] 0x20, %r15
	mov	0x3e0, %r21
	mov	0x78, %r16
	mov	0x50, %r17
	.word 0xdabfa000  ! 2099: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdacfe000  ! 2100: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2101: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2102: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 2103: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d8, %r22
	.word 0xd4ae49e0  ! 2105: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	mov	0x0, %r18
	mov	0x68, %r19
	.word 0xd6f78e40  ! 2108: STXA_R	stxa	%r11, [%r30 + %r0] 0x72
	.word 0xd0cf2000  ! 2109: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0xd0afe000  ! 2110: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	mov	0x8, %r19
	.word 0xd6d44400  ! 2112: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r11
	mov	0x48, %r17
	.word 0xde876000  ! 2114: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xd0df0e40  ! 2115: LDXA_R	ldxa	[%r28, %r0] 0x72, %r8
	.word 0xdac72000  ! 2116: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0xda976000  ! 2117: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	mov	0x3d8, %r22
	.word 0xda9f6000  ! 2119: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0x87802073  ! 2120: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r24
	.word 0xd4f48400  ! 2122: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xd6a7e000  ! 2123: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xd6bf6000  ! 2125: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xdcbdc4a0  ! 2126: STDA_R	stda	%r14, [%r23 + %r0] 0x25
	.word 0x87802074  ! 2127: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2128: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9fa000  ! 2129: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	mov	0x8, %r25
	.word 0xdcc689e0  ! 2131: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r14
	.word 0xd48fe000  ! 2132: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	mov	0x3d8, %r20
	.word 0xdcb649e0  ! 2134: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	.word 0xd4f7a000  ! 2135: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd6b70e80  ! 2136: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	.word 0xd2f76000  ! 2137: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xd2cfa000  ! 2138: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2139: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2140: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdea74e80  ! 2141: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	.word 0xd6dec9e0  ! 2142: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r11
	mov	0x7e8, %r23
	.word 0x87802073  ! 2144: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde87e000  ! 2145: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xd2b544a0  ! 2146: STHA_R	stha	%r9, [%r21 + %r0] 0x25
	.word 0xd6d7a000  ! 2147: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	mov	0x50, %r26
	mov	0x68, %r27
	.word 0xd687a000  ! 2150: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	mov	0x3f8, %r21
	mov	0x28, %r24
	mov	0x7d0, %r23
	mov	0x7d8, %r22
	mov	0x3c8, %r21
	.word 0xdecc8400  ! 2156: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	.word 0xdad72000  ! 2157: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0xd685c4a0  ! 2158: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r11
	mov	0x7d8, %r20
	.word 0xd8bfe000  ! 2160: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xdeb504a0  ! 2161: STHA_R	stha	%r15, [%r20 + %r0] 0x25
	.word 0xd4afce40  ! 2162: STBA_R	stba	%r10, [%r31 + %r0] 0x72
	.word 0xdaf504a0  ! 2163: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	mov	0x7f0, %r22
	.word 0x87802025  ! 2165: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f8, %r21
	.word 0x87802072  ! 2167: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda9fa000  ! 2168: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	mov	0x10, %r18
	.word 0xdaf72000  ! 2170: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xdaf7e000  ! 2172: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xdabdc4a0  ! 2173: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	.word 0x8780204f  ! 2174: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9e2000  ! 2175: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r13
	mov	0x3c8, %r23
	.word 0xd4f689e0  ! 2177: STXA_R	stxa	%r10, [%r26 + %r0] 0x4f
	mov	0x3d0, %r20
	.word 0xd8aee000  ! 2179: STBA_I	stba	%r12, [%r27 + 0x0000] %asi
	mov	0x78, %r24
	.word 0xd4c5c4a0  ! 2181: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r10
	.word 0x87802020  ! 2182: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r21
	.word 0xd6ad44a0  ! 2184: STBA_R	stba	%r11, [%r21 + %r0] 0x25
	.word 0xd6ce2000  ! 2185: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	mov	0x38, %r17
	mov	0x3d0, %r22
	mov	0x10, %r19
	.word 0xd8978e80  ! 2189: LDUHA_R	lduha	[%r30, %r0] 0x74, %r12
	mov	0x38, %r19
	.word 0xd0d74e80  ! 2191: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r8
	.word 0xdaa70e60  ! 2192: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	.word 0xd0878e80  ! 2193: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r8
	.word 0xd09689e0  ! 2194: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r8
	.word 0xd8bdc4a0  ! 2195: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	mov	0x3d8, %r21
	mov	0x60, %r17
	.word 0xdaa6a000  ! 2198: STWA_I	stwa	%r13, [%r26 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0xd8cd84a0  ! 2200: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r12
	.word 0x8780204f  ! 2201: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2d78e60  ! 2202: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r9
	.word 0x87802072  ! 2203: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r24
	mov	0x78, %r24
	mov	0x70, %r17
	.word 0xd6bf8e40  ! 2207: STDA_R	stda	%r11, [%r30 + %r0] 0x72
	mov	0x7d0, %r23
	.word 0x87802073  ! 2209: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2210: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcc44400  ! 2211: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xd4adc4a0  ! 2212: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0xd2a76000  ! 2213: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xdcb70e40  ! 2214: STHA_R	stha	%r14, [%r28 + %r0] 0x72
	.word 0x87802020  ! 2215: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r27
	mov	0x20, %r26
	.word 0x87802025  ! 2218: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 2219: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeaf6000  ! 2220: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xdaa7ce40  ! 2221: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	mov	0x18, %r26
	.word 0xd88fa000  ! 2223: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	mov	0x78, %r16
	.word 0xd8972000  ! 2225: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2226: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r27
	mov	0x48, %r25
	.word 0xd2f4c400  ! 2229: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	mov	0x30, %r18
	.word 0x87802072  ! 2231: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0a7a000  ! 2232: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd4b48400  ! 2233: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd4b7e000  ! 2234: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0xd4bfa000  ! 2236: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 2237: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2238: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cdc4a0  ! 2239: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r8
	.word 0xdcbfe000  ! 2240: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdccf6000  ! 2241: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 2242: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc84c400  ! 2243: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	mov	0x48, %r19
	.word 0x87802020  ! 2245: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2246: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r19
	.word 0xd6bc4400  ! 2248: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	mov	0x7f0, %r22
	.word 0xd48c8400  ! 2250: LDUBA_R	lduba	[%r18, %r0] 0x20, %r10
	mov	0x3d8, %r23
	.word 0x8780204f  ! 2252: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2df0e60  ! 2253: LDXA_R	ldxa	[%r28, %r0] 0x73, %r9
	.word 0xd2dc0400  ! 2254: LDXA_R	ldxa	[%r16, %r0] 0x20, %r9
	.word 0xdebec9e0  ! 2255: STDA_R	stda	%r15, [%r27 + %r0] 0x4f
	mov	0x40, %r27
	.word 0xd2b66000  ! 2257: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	.word 0xd2b6e000  ! 2258: STHA_I	stha	%r9, [%r27 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xd2ce2000  ! 2260: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r9
	.word 0xd2c6e000  ! 2261: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r9
	mov	0x78, %r26
	.word 0xd2b66000  ! 2263: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	.word 0xda970e40  ! 2264: LDUHA_R	lduha	[%r28, %r0] 0x72, %r13
	.word 0xdcb66000  ! 2265: STHA_I	stha	%r14, [%r25 + 0x0000] %asi
	.word 0xdcc6a000  ! 2266: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r14
	.word 0xded5c4a0  ! 2267: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r15
	.word 0x87802072  ! 2268: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8d78e80  ! 2269: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r12
	mov	0x18, %r17
	.word 0xdacc6000  ! 2271: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	.word 0xd2ae89e0  ! 2272: STBA_R	stba	%r9, [%r26 + %r0] 0x4f
	mov	0x3d0, %r20
	.word 0xd0aca000  ! 2274: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xd0b4e000  ! 2275: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xd08ce000  ! 2276: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	mov	0x7d0, %r20
	.word 0x87802025  ! 2278: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 2279: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd085a000  ! 2280: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r8
	.word 0xd0a5e000  ! 2281: STWA_I	stwa	%r8, [%r23 + 0x0000] %asi
	mov	0x3f8, %r23
	.word 0xd08de000  ! 2283: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r8
	mov	0x3d8, %r23
	.word 0xd08c0400  ! 2285: LDUBA_R	lduba	[%r16, %r0] 0x20, %r8
	.word 0xdca5e000  ! 2286: STWA_I	stwa	%r14, [%r23 + 0x0000] %asi
	.word 0xdc8de000  ! 2287: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r14
	.word 0xdaf40400  ! 2288: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	mov	0x70, %r25
	mov	0x78, %r24
	mov	0x10, %r17
	.word 0xdc84c400  ! 2292: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	.word 0xd4bd44a0  ! 2293: STDA_R	stda	%r10, [%r21 + %r0] 0x25
	.word 0xdcd70e80  ! 2294: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r14
	.word 0xd08f8e60  ! 2295: LDUBA_R	lduba	[%r30, %r0] 0x73, %r8
	.word 0x87802020  ! 2296: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b5c4a0  ! 2297: STHA_R	stha	%r11, [%r23 + %r0] 0x25
	mov	0x3f0, %r20
	.word 0xd8978e80  ! 2299: LDUHA_R	lduha	[%r30, %r0] 0x74, %r12
	mov	0x48, %r24
	.word 0xd4f7ce60  ! 2301: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	.word 0xd6a76000  ! 2302: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6bc8400  ! 2303: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xdaf44400  ! 2304: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0xd6c4c400  ! 2305: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r11
	.word 0xd4c40400  ! 2306: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	mov	0x7e8, %r20
	.word 0xd4ccc400  ! 2308: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0xd2cfce40  ! 2309: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r9
	.word 0x8780204f  ! 2310: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf7ce40  ! 2311: STXA_R	stxa	%r14, [%r31 + %r0] 0x72
	.word 0xdecf4e80  ! 2312: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r15
	mov	0x3d8, %r22
	.word 0xda9e2000  ! 2314: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r13
	.word 0xd496c9e0  ! 2315: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r10
	.word 0x87802073  ! 2316: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0844400  ! 2317: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r8
	mov	0x78, %r18
	mov	0x3c0, %r20
	.word 0xdaafe000  ! 2320: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xd4aec9e0  ! 2321: STBA_R	stba	%r10, [%r27 + %r0] 0x4f
	.word 0xd6ac4400  ! 2322: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xdaaf6000  ! 2323: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xdaf7a000  ! 2324: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdaaf6000  ! 2325: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xd4ce49e0  ! 2326: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r10
	mov	0x18, %r27
	.word 0xdab7e000  ! 2328: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	mov	0x18, %r27
	.word 0x87802073  ! 2330: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 2331: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc9f8e80  ! 2332: LDDA_R	ldda	[%r30, %r0] 0x74, %r14
	.word 0xd895c4a0  ! 2333: LDUHA_R	lduha	[%r23, %r0] 0x25, %r12
	.word 0xd4dfa000  ! 2334: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0x87802020  ! 2335: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r16
	.word 0xd09689e0  ! 2337: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r8
	.word 0xd69ec9e0  ! 2338: LDDA_R	ldda	[%r27, %r0] 0x4f, %r11
	.word 0xded42000  ! 2339: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	.word 0xde87ce80  ! 2340: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r15
	.word 0xd297ce80  ! 2341: LDUHA_R	lduha	[%r31, %r0] 0x74, %r9
	mov	0x18, %r18
	mov	0x78, %r16
	.word 0xdeacc400  ! 2344: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xdcb4e000  ! 2345: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xd4b74e60  ! 2346: STHA_R	stha	%r10, [%r29 + %r0] 0x73
	.word 0xdad504a0  ! 2347: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r13
	.word 0xdaa78e40  ! 2348: STWA_R	stwa	%r13, [%r30 + %r0] 0x72
	.word 0xd09cc400  ! 2349: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	.word 0xd8bfce60  ! 2350: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	mov	0x7c8, %r22
	mov	0x8, %r27
	.word 0xd8c78e60  ! 2353: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r12
	.word 0xdc8649e0  ! 2354: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r14
	mov	0x7d0, %r20
	.word 0xdeac2000  ! 2356: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xda870e40  ! 2357: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r13
	mov	0x68, %r16
	mov	0x20, %r26
	mov	0x3f0, %r22
	.word 0xdea7ce60  ! 2361: STWA_R	stwa	%r15, [%r31 + %r0] 0x73
	mov	0x3f8, %r22
	mov	0x3e0, %r21
	.word 0xdcae09e0  ! 2364: STBA_R	stba	%r14, [%r24 + %r0] 0x4f
	mov	0x40, %r26
	.word 0x87802073  ! 2366: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0f7ce80  ! 2367: STXA_R	stxa	%r8, [%r31 + %r0] 0x74
	mov	0x8, %r26
	.word 0xd8b74e80  ! 2369: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	.word 0xd49584a0  ! 2370: LDUHA_R	lduha	[%r22, %r0] 0x25, %r10
	mov	0x3e0, %r20
	mov	0x78, %r24
	mov	0x68, %r18
	.word 0xd2bea000  ! 2374: STDA_I	stda	%r9, [%r26 + 0x0000] %asi
	.word 0xd684c400  ! 2375: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	.word 0x87802025  ! 2376: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r27
	.word 0xdcbc0400  ! 2378: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0xd0f78e80  ! 2379: STXA_R	stxa	%r8, [%r30 + %r0] 0x74
	.word 0xd2c4e000  ! 2380: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	mov	0x58, %r25
	mov	0x7e8, %r23
	.word 0x87802072  ! 2383: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2384: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a70e60  ! 2385: STWA_R	stwa	%r9, [%r28 + %r0] 0x73
	.word 0xd69689e0  ! 2386: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r11
	.word 0xdc9e09e0  ! 2387: LDDA_R	ldda	[%r24, %r0] 0x4f, %r14
	.word 0x87802072  ! 2388: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde8e49e0  ! 2389: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r15
	.word 0xd2c6c9e0  ! 2390: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r9
	.word 0xde97a000  ! 2391: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	.word 0xdea7a000  ! 2392: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xded72000  ! 2393: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xdaf78e80  ! 2394: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	.word 0xd8afa000  ! 2395: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xd88fa000  ! 2396: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0xd0f7ce40  ! 2397: STXA_R	stxa	%r8, [%r31 + %r0] 0x72
	.word 0xd4f72000  ! 2398: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4bf2000  ! 2399: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd497e000  ! 2400: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	mov	0x7c0, %r21
	.word 0xd4d76000  ! 2402: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	mov	0x0, %r17
	mov	0x3c0, %r21
	mov	0x3d0, %r22
	.word 0xd4976000  ! 2406: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r10
	mov	0x30, %r25
	.word 0xd4a78e80  ! 2408: STWA_R	stwa	%r10, [%r30 + %r0] 0x74
	.word 0xd0bc0400  ! 2409: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0xd08d44a0  ! 2410: LDUBA_R	lduba	[%r21, %r0] 0x25, %r8
	.word 0xd6cf0e40  ! 2411: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r11
	mov	0x18, %r19
	.word 0xdaf72000  ! 2413: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdaa72000  ! 2414: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xdac7a000  ! 2415: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2416: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa76000  ! 2417: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 2418: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e0, %r21
	.word 0xdad62000  ! 2420: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r13
	.word 0xdcbf4e80  ! 2421: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	mov	0x10, %r18
	.word 0xd497ce40  ! 2423: LDUHA_R	lduha	[%r31, %r0] 0x72, %r10
	.word 0xdabee000  ! 2424: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xdaa6a000  ! 2426: STWA_I	stwa	%r13, [%r26 + 0x0000] %asi
	.word 0xdade2000  ! 2427: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r13
	.word 0xdabee000  ! 2428: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0xdab66000  ! 2430: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xdac62000  ! 2432: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r13
	mov	0x3f8, %r20
	.word 0x87802073  ! 2434: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r26
	.word 0xdac76000  ! 2436: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0xd0d4c400  ! 2437: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	.word 0xd48d04a0  ! 2438: LDUBA_R	lduba	[%r20, %r0] 0x25, %r10
	mov	0x30, %r18
	mov	0x0, %r26
	.word 0xd8dfe000  ! 2441: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	mov	0x7d8, %r22
	.word 0xde8649e0  ! 2443: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r15
	mov	0x40, %r24
	.word 0x87802020  ! 2445: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ac6000  ! 2446: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 2447: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2b42000  ! 2449: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x3d0, %r21
	mov	0x7e0, %r23
	.word 0xd2ad04a0  ! 2453: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	.word 0xd0d4a000  ! 2454: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	.word 0xd0af0e40  ! 2455: STBA_R	stba	%r8, [%r28 + %r0] 0x72
	mov	0x7c8, %r23
	.word 0xdaa48400  ! 2457: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	mov	0x0, %r27
	.word 0xdadc6000  ! 2459: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xdacce000  ! 2460: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r13
	.word 0x87802072  ! 2461: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdead84a0  ! 2462: STBA_R	stba	%r15, [%r22 + %r0] 0x25
	.word 0xdcacc400  ! 2463: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0x87802072  ! 2464: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r18
	.word 0x87802025  ! 2466: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 2467: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0ad04a0  ! 2468: STBA_R	stba	%r8, [%r20 + %r0] 0x25
	.word 0xd8cf0e40  ! 2469: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r12
	mov	0x40, %r27
	.word 0xd8bf4e80  ! 2471: STDA_R	stda	%r12, [%r29 + %r0] 0x74
	.word 0xd897e000  ! 2472: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	.word 0xd897a000  ! 2473: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2474: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8544a0  ! 2475: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r15
	.word 0xd0856000  ! 2476: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r8
	mov	0x3d0, %r21
	.word 0xdeb70e60  ! 2478: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	.word 0xd4d74e60  ! 2479: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r10
	.word 0xd0d609e0  ! 2480: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r8
	.word 0x87802020  ! 2481: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r21
	.word 0xdeaf0e60  ! 2483: STBA_R	stba	%r15, [%r28 + %r0] 0x73
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd4d7ce40  ! 2485: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r10
	.word 0xd2a7e000  ! 2486: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	mov	0x10, %r18
	.word 0x87802072  ! 2488: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f7a000  ! 2489: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xd2dfe000  ! 2490: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0xdec4c400  ! 2491: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	mov	0x18, %r25
	.word 0xda9f2000  ! 2493: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xd89d04a0  ! 2494: LDDA_R	ldda	[%r20, %r0] 0x25, %r12
	mov	0x60, %r18
	.word 0x87802020  ! 2496: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf44400  ! 2497: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	mov	0x7f0, %r21
	.word 0xd6cf8e80  ! 2499: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r11
	mov	0x58, %r26
	.word 0xdabfa000  ! 2501: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdaf76000  ! 2502: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdaa76000  ! 2503: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	mov	0x58, %r27
	.word 0xd49d44a0  ! 2505: LDDA_R	ldda	[%r21, %r0] 0x25, %r10
	.word 0xd0a7a000  ! 2506: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd4bd44a0  ! 2507: STDA_R	stda	%r10, [%r21 + %r0] 0x25
	.word 0xd4a78e60  ! 2508: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	.word 0x87802073  ! 2509: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 2510: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2511: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2878e40  ! 2513: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r9
	mov	0x40, %r25
	.word 0xd4f56000  ! 2515: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	mov	0x48, %r19
	mov	0x18, %r27
	.word 0xd4d56000  ! 2518: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r10
	mov	0x7e0, %r23
	.word 0xd0d48400  ! 2520: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	mov	0x38, %r18
	.word 0xdcf52000  ! 2522: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	.word 0xdca5a000  ! 2523: STWA_I	stwa	%r14, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 2524: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49609e0  ! 2525: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r10
	.word 0xde86c9e0  ! 2526: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r15
	.word 0xd88cc400  ! 2527: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	.word 0xdadc0400  ! 2528: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	.word 0xdc97a000  ! 2529: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	.word 0xdcdf2000  ! 2530: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	mov	0x0, %r27
	.word 0xdccfa000  ! 2532: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	mov	0x7f8, %r23
	.word 0xdc8fe000  ! 2534: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xdabd84a0  ! 2535: STDA_R	stda	%r13, [%r22 + %r0] 0x25
	.word 0xd8acc400  ! 2536: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0x87802020  ! 2537: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r24
	.word 0xd285c4a0  ! 2539: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r9
	.word 0xd29dc4a0  ! 2540: LDDA_R	ldda	[%r23, %r0] 0x25, %r9
	.word 0xda9f8e80  ! 2541: LDDA_R	ldda	[%r30, %r0] 0x74, %r13
	.word 0x87802020  ! 2542: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r20
	.word 0xdcd7e000  ! 2544: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xd09f0e80  ! 2545: LDDA_R	ldda	[%r28, %r0] 0x74, %r8
	mov	0x3c8, %r20
	.word 0xd0bf2000  ! 2547: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xd0bf6000  ! 2548: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd6cd44a0  ! 2549: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r11
	.word 0xda972000  ! 2550: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	mov	0x68, %r17
	.word 0xdadfe000  ! 2552: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	mov	0x3e8, %r22
	mov	0x70, %r27
	.word 0xdaf72000  ! 2555: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	mov	0x50, %r19
	.word 0x87802073  ! 2557: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf4e000  ! 2558: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xda842000  ! 2559: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r13
	mov	0x3d0, %r20
	.word 0xdaf4e000  ! 2561: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xdad46000  ! 2562: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	.word 0xdcb6c9e0  ! 2563: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	.word 0x87802072  ! 2564: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8ce09e0  ! 2565: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r12
	.word 0xdabd6000  ! 2566: STDA_I	stda	%r13, [%r21 + 0x0000] %asi
	.word 0xdaade000  ! 2567: STBA_I	stba	%r13, [%r23 + 0x0000] %asi
	.word 0xdaf5e000  ! 2568: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0xdab5e000  ! 2569: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0xd6cfce40  ! 2570: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r11
	.word 0xdaa70e40  ! 2571: STWA_R	stwa	%r13, [%r28 + %r0] 0x72
	mov	0x7f0, %r23
	.word 0x87802073  ! 2573: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef44400  ! 2574: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	mov	0x0, %r19
	.word 0xd68f8e80  ! 2576: LDUBA_R	lduba	[%r30, %r0] 0x74, %r11
	mov	0x7f0, %r20
	.word 0xd08ce000  ! 2578: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 2579: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0cf6000  ! 2580: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd4cc0400  ! 2581: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r10
	.word 0xd88fce80  ! 2582: LDUBA_R	lduba	[%r31, %r0] 0x74, %r12
	.word 0xde948400  ! 2583: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	.word 0xd29c0400  ! 2584: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	mov	0x8, %r24
	.word 0xde9f0e40  ! 2586: LDDA_R	ldda	[%r28, %r0] 0x72, %r15
	.word 0x87802074  ! 2587: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc9c8400  ! 2588: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0xd2f7e000  ! 2589: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 2590: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd097ce40  ! 2591: LDUHA_R	lduha	[%r31, %r0] 0x72, %r8
	.word 0xd8cfa000  ! 2592: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xdeae89e0  ! 2593: STBA_R	stba	%r15, [%r26 + %r0] 0x4f
	.word 0xd09f2000  ! 2594: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0x87802073  ! 2595: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r17
	mov	0x3e0, %r22
	.word 0xd09f6000  ! 2598: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	mov	0x40, %r25
	mov	0x50, %r24
	.word 0x87802074  ! 2601: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b72000  ! 2602: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 2603: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb5c4a0  ! 2604: STHA_R	stha	%r15, [%r23 + %r0] 0x25
	mov	0x7d0, %r20
	.word 0xda974e60  ! 2606: LDUHA_R	lduha	[%r29, %r0] 0x73, %r13
	.word 0xd285e000  ! 2607: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r9
	.word 0xd4cfce60  ! 2608: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r10
	.word 0xd296c9e0  ! 2609: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r9
	mov	0x7c8, %r21
	.word 0xd08fce40  ! 2611: LDUBA_R	lduba	[%r31, %r0] 0x72, %r8
	.word 0xd6d5e000  ! 2612: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r11
	.word 0xd6a52000  ! 2613: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	.word 0xdcb74e80  ! 2614: STHA_R	stha	%r14, [%r29 + %r0] 0x74
	.word 0xdaf52000  ! 2615: STXA_I	stxa	%r13, [%r20 + 0x0000] %asi
	.word 0xd8b689e0  ! 2616: STHA_R	stha	%r12, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 2617: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebfce60  ! 2618: STDA_R	stda	%r15, [%r31 + %r0] 0x73
	.word 0xdace09e0  ! 2619: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r13
	.word 0xd4a70e40  ! 2620: STWA_R	stwa	%r10, [%r28 + %r0] 0x72
	.word 0xdcc7ce80  ! 2621: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r14
	.word 0xd6be09e0  ! 2622: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	mov	0x68, %r16
	.word 0xd2b78e80  ! 2624: STHA_R	stha	%r9, [%r30 + %r0] 0x74
	.word 0xd6846000  ! 2625: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r11
	.word 0xd6b4a000  ! 2626: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xdaf5c4a0  ! 2627: STXA_R	stxa	%r13, [%r23 + %r0] 0x25
	mov	0x3d0, %r23
	.word 0x87802020  ! 2629: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb7e000  ! 2630: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xdc97e000  ! 2631: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xd6ac8400  ! 2632: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x20, %r19
	.word 0xd4cf8e40  ! 2635: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r10
	mov	0x58, %r18
	.word 0xd0a76000  ! 2637: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	mov	0x7d0, %r22
	.word 0xd0b72000  ! 2639: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 2640: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r17
	.word 0x87802073  ! 2642: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2a78e60  ! 2643: STWA_R	stwa	%r9, [%r30 + %r0] 0x73
	.word 0xd2d76000  ! 2644: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2645: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2646: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b78e60  ! 2647: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	.word 0x8780204f  ! 2648: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 2649: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r18
	.word 0x87802020  ! 2651: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r23
	.word 0x87802072  ! 2653: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf42000  ! 2654: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0xd0874e40  ! 2655: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r8
	.word 0x87802072  ! 2656: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdac78e80  ! 2657: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r13
	.word 0xd8cfce80  ! 2658: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r12
	.word 0xda8c6000  ! 2659: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r13
	.word 0xda9c6000  ! 2660: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	mov	0x28, %r19
	.word 0xdad4e000  ! 2662: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r13
	.word 0xd2cec9e0  ! 2663: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r9
	.word 0x87802073  ! 2664: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8bf4e60  ! 2665: STDA_R	stda	%r12, [%r29 + %r0] 0x73
	.word 0xd6afa000  ! 2666: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 2667: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r18
	.word 0xd2f4c400  ! 2669: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x10, %r17
	.word 0xd2bf2000  ! 2672: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	mov	0x38, %r26
	.word 0xd2b76000  ! 2674: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2b7e000  ! 2675: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	mov	0x7c0, %r21
	.word 0xd0bf0e60  ! 2677: STDA_R	stda	%r8, [%r28 + %r0] 0x73
	mov	0x20, %r26
	.word 0xdaad04a0  ! 2679: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	.word 0x87802074  ! 2680: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6af6000  ! 2681: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd4f74e60  ! 2682: STXA_R	stxa	%r10, [%r29 + %r0] 0x73
	.word 0xd48f2000  ! 2683: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd6af0e80  ! 2684: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	.word 0xd0ad44a0  ! 2685: STBA_R	stba	%r8, [%r21 + %r0] 0x25
	.word 0xd697a000  ! 2686: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0xd49f0e40  ! 2687: LDDA_R	ldda	[%r28, %r0] 0x72, %r10
	.word 0xd0cf4e60  ! 2688: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r8
	.word 0x87802074  ! 2689: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2690: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bec9e0  ! 2691: STDA_R	stda	%r8, [%r27 + %r0] 0x4f
	.word 0xd8bc6000  ! 2692: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0xd8ad84a0  ! 2693: STBA_R	stba	%r12, [%r22 + %r0] 0x25
	.word 0xdcbca000  ! 2694: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	mov	0x3d8, %r21
	.word 0xdcbca000  ! 2696: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 2697: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r24
	.word 0xd6a78e80  ! 2699: STWA_R	stwa	%r11, [%r30 + %r0] 0x74
	.word 0xd8cfe000  ! 2700: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2701: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bea000  ! 2702: STDA_I	stda	%r12, [%r26 + 0x0000] %asi
	.word 0xd0be49e0  ! 2703: STDA_R	stda	%r8, [%r25 + %r0] 0x4f
	.word 0xda8f4e40  ! 2704: LDUBA_R	lduba	[%r29, %r0] 0x72, %r13
	.word 0x87802020  ! 2705: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r26
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd4de6000  ! 2708: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r10
	mov	0x58, %r19
	.word 0xd48d44a0  ! 2710: LDUBA_R	lduba	[%r21, %r0] 0x25, %r10
	.word 0xdcad04a0  ! 2711: STBA_R	stba	%r14, [%r20 + %r0] 0x25
	.word 0xdea7ce40  ! 2712: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	.word 0xd8be2000  ! 2713: STDA_I	stda	%r12, [%r24 + 0x0000] %asi
	.word 0xd8d544a0  ! 2714: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r12
	.word 0x87802074  ! 2715: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 2716: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad46000  ! 2717: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	.word 0xdaad04a0  ! 2718: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	.word 0xd094a000  ! 2719: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	.word 0xd0946000  ! 2720: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0x87802025  ! 2721: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f544a0  ! 2722: STXA_R	stxa	%r11, [%r21 + %r0] 0x25
	mov	0x10, %r17
	mov	0x20, %r17
	mov	0x20, %r17
	.word 0xda85a000  ! 2726: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r13
	.word 0xd69c4400  ! 2727: LDDA_R	ldda	[%r17, %r0] 0x20, %r11
	.word 0x87802020  ! 2728: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9c8400  ! 2729: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	.word 0xd6df4e60  ! 2730: LDXA_R	ldxa	[%r29, %r0] 0x73, %r11
	.word 0x87802072  ! 2731: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdea689e0  ! 2732: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdecdc4a0  ! 2734: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r15
	.word 0xd08f2000  ! 2735: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	.word 0xd6ac4400  ! 2736: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0x87802020  ! 2737: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a4a000  ! 2738: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8d42000  ! 2739: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0x87802025  ! 2740: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8978e40  ! 2741: LDUHA_R	lduha	[%r30, %r0] 0x72, %r12
	.word 0xde95e000  ! 2742: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r15
	.word 0xd8c70e80  ! 2743: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r12
	.word 0xd6ac8400  ! 2744: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0x87802074  ! 2745: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6afe000  ! 2746: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x30, %r16
	.word 0x87802020  ! 2748: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88689e0  ! 2749: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r12
	.word 0x87802020  ! 2750: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa78e60  ! 2751: STWA_R	stwa	%r13, [%r30 + %r0] 0x73
	.word 0xd28dc4a0  ! 2752: LDUBA_R	lduba	[%r23, %r0] 0x25, %r9
	.word 0xdeafce40  ! 2753: STBA_R	stba	%r15, [%r31 + %r0] 0x72
	.word 0xd6bfa000  ! 2754: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd4a7ce40  ! 2755: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	.word 0xd09fa000  ! 2756: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	.word 0xd087a000  ! 2757: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0xd68c0400  ! 2758: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	mov	0x30, %r18
	.word 0xdaac0400  ! 2760: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 2761: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r24
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd4bd84a0  ! 2764: STDA_R	stda	%r10, [%r22 + %r0] 0x25
	.word 0x87802020  ! 2765: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r22
	.word 0xd69f2000  ! 2767: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	mov	0x20, %r25
	.word 0x87802072  ! 2769: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 2770: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcdec9e0  ! 2771: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r14
	.word 0xdab72000  ! 2772: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdab76000  ! 2773: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdab6c9e0  ! 2774: STHA_R	stha	%r13, [%r27 + %r0] 0x4f
	.word 0xdca74e60  ! 2775: STWA_R	stwa	%r14, [%r29 + %r0] 0x73
	.word 0xdebfe000  ! 2776: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xd0a7ce80  ! 2777: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	.word 0xd4dd84a0  ! 2778: LDXA_R	ldxa	[%r22, %r0] 0x25, %r10
	mov	0x7c8, %r22
	.word 0x87802072  ! 2780: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 2781: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8b76000  ! 2782: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd6df8e80  ! 2783: LDXA_R	ldxa	[%r30, %r0] 0x74, %r11
	.word 0x87802073  ! 2784: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdadf2000  ! 2785: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0xd6c6c9e0  ! 2786: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r11
	.word 0x87802074  ! 2787: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4afe000  ! 2788: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	mov	0x20, %r19
	.word 0xd4bfe000  ! 2790: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xdaa70e60  ! 2791: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	.word 0x87802074  ! 2792: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd895e000  ! 2793: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r12
	.word 0xd8852000  ! 2794: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2795: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b7ce80  ! 2796: STHA_R	stha	%r10, [%r31 + %r0] 0x74
	.word 0xd8a609e0  ! 2797: STWA_R	stwa	%r12, [%r24 + %r0] 0x4f
	.word 0xd2c4a000  ! 2798: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	.word 0xd4c78e40  ! 2799: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r10
	mov	0x50, %r24
	mov	0x7c8, %r22
	.word 0xdab4e000  ! 2802: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x50, %r18
	.word 0xd08d04a0  ! 2805: LDUBA_R	lduba	[%r20, %r0] 0x25, %r8
	.word 0xd8afce60  ! 2806: STBA_R	stba	%r12, [%r31 + %r0] 0x73
	.word 0xd684a000  ! 2807: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r11
	.word 0xd2af4e60  ! 2808: STBA_R	stba	%r9, [%r29 + %r0] 0x73
	.word 0xd4ac6000  ! 2809: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	.word 0xd484a000  ! 2810: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r10
	mov	0x3e0, %r23
	mov	0x60, %r25
	.word 0xd4b46000  ! 2813: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	mov	0x70, %r18
	.word 0x8780204f  ! 2815: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 2816: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r19
	mov	0x7f0, %r23
	.word 0x87802020  ! 2819: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r17
	mov	0x60, %r26
	.word 0x87802020  ! 2822: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a7ce60  ! 2823: STWA_R	stwa	%r8, [%r31 + %r0] 0x73
	.word 0xdc9d6000  ! 2824: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r14
	.word 0xdcb56000  ! 2825: STHA_I	stha	%r14, [%r21 + 0x0000] %asi
	.word 0xdc9504a0  ! 2826: LDUHA_R	lduha	[%r20, %r0] 0x25, %r14
	.word 0xde8da000  ! 2827: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r15
	mov	0x8, %r16
	.word 0x87802073  ! 2829: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd49609e0  ! 2830: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r10
	.word 0x87802020  ! 2831: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef74e60  ! 2832: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	.word 0xdac40400  ! 2833: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	.word 0xdadf6000  ! 2834: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2835: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf7e000  ! 2836: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xdaa72000  ! 2837: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xd8b40400  ! 2838: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xde8c0400  ! 2839: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0x87802072  ! 2840: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f5c4a0  ! 2841: STXA_R	stxa	%r9, [%r23 + %r0] 0x25
	.word 0xdc97ce60  ! 2842: LDUHA_R	lduha	[%r31, %r0] 0x73, %r14
	mov	0x60, %r27
	mov	0x3c0, %r21
	.word 0xded649e0  ! 2845: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r15
	.word 0xd8dca000  ! 2846: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	.word 0x87802072  ! 2847: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a609e0  ! 2848: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	.word 0xd28c4400  ! 2849: LDUBA_R	lduba	[%r17, %r0] 0x20, %r9
	.word 0xdab4a000  ! 2850: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0xda946000  ! 2851: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	.word 0xdabc2000  ! 2852: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xd0bf8e40  ! 2853: STDA_R	stda	%r8, [%r30 + %r0] 0x72
	.word 0xd6a70e60  ! 2854: STWA_R	stwa	%r11, [%r28 + %r0] 0x73
	.word 0xdef70e40  ! 2855: STXA_R	stxa	%r15, [%r28 + %r0] 0x72
	.word 0x87802020  ! 2856: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r17
	.word 0xd695e000  ! 2858: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r11
	mov	0x60, %r18
	.word 0xd4f689e0  ! 2860: STXA_R	stxa	%r10, [%r26 + %r0] 0x4f
	.word 0xdc9609e0  ! 2861: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r14
	.word 0xdabd84a0  ! 2862: STDA_R	stda	%r13, [%r22 + %r0] 0x25
	.word 0xd6852000  ! 2863: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r11
	mov	0x3f0, %r23
	mov	0x3e8, %r20
	.word 0xd4948400  ! 2866: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	.word 0x87802020  ! 2867: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda874e40  ! 2868: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r13
	.word 0xd0b7e000  ! 2869: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0xd0d7e000  ! 2870: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xdcae89e0  ! 2871: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	.word 0xd69e49e0  ! 2872: LDDA_R	ldda	[%r25, %r0] 0x4f, %r11
	mov	0x60, %r18
	.word 0xd4cfe000  ! 2874: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0x87802073  ! 2875: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0d78e60  ! 2876: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r8
	.word 0xd4dfce80  ! 2877: LDXA_R	ldxa	[%r31, %r0] 0x74, %r10
	.word 0x87802020  ! 2878: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcacc400  ! 2879: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	mov	0x3c0, %r22
	.word 0xd88fe000  ! 2881: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd89fe000  ! 2882: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0x87802025  ! 2883: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r26
	.word 0xd885a000  ! 2885: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r12
	mov	0x3c0, %r20
	.word 0xd89d2000  ! 2887: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r12
	.word 0xd8dd2000  ! 2888: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r12
	.word 0xdeac8400  ! 2889: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	mov	0x18, %r24
	mov	0x40, %r24
	mov	0x30, %r26
	.word 0x87802025  ! 2893: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 2894: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4974e60  ! 2895: LDUHA_R	lduha	[%r29, %r0] 0x73, %r10
	.word 0x8780204f  ! 2896: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabf0e60  ! 2897: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	mov	0x3e8, %r21
	mov	0x3e8, %r22
	mov	0x7d0, %r22
	mov	0x58, %r26
	.word 0xd087ce60  ! 2902: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r8
	.word 0xd4ae6000  ! 2903: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 2904: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbe89e0  ! 2905: STDA_R	stda	%r14, [%r26 + %r0] 0x4f
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdc9d6000  ! 2907: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r14
	.word 0xd4c48400  ! 2908: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r10
	.word 0x87802025  ! 2909: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r16
	.word 0xd2bf6000  ! 2911: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xd2d7e000  ! 2913: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xd29fa000  ! 2914: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd4c609e0  ! 2915: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r10
	.word 0x87802072  ! 2916: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabf6000  ! 2917: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xdaf7a000  ! 2918: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 2919: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d8, %r20
	.word 0xdaaea000  ! 2921: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	mov	0x3c8, %r21
	mov	0x7c0, %r23
	mov	0x3f8, %r23
	mov	0x38, %r19
	.word 0xd2bf0e60  ! 2926: STDA_R	stda	%r9, [%r28 + %r0] 0x73
	mov	0x7e8, %r22
	mov	0x7d0, %r22
	.word 0xd89f0e80  ! 2929: LDDA_R	ldda	[%r28, %r0] 0x74, %r12
	.word 0xd0966000  ! 2930: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r8
	mov	0x0, %r25
	.word 0xd0bcc400  ! 2932: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0x87802074  ! 2933: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd896e000  ! 2934: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r12
	.word 0xd8a6e000  ! 2935: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	.word 0xd896a000  ! 2936: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r12
	.word 0xd2dfce60  ! 2937: LDXA_R	ldxa	[%r31, %r0] 0x73, %r9
	.word 0xd8f66000  ! 2938: STXA_I	stxa	%r12, [%r25 + 0x0000] %asi
	.word 0xd8c6a000  ! 2939: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r12
	mov	0x18, %r25
	mov	0x58, %r27
	.word 0xd6f70e40  ! 2942: STXA_R	stxa	%r11, [%r28 + %r0] 0x72
	.word 0xd6b78e40  ! 2943: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	mov	0x7e8, %r23
	.word 0xde8ea000  ! 2945: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r15
	.word 0xd8a44400  ! 2946: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0x87802025  ! 2947: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2948: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4d40400  ! 2949: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	.word 0xd4b5c4a0  ! 2950: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	mov	0x7c8, %r20
	.word 0xd0cf2000  ! 2952: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0xd0cf2000  ! 2953: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	mov	0x68, %r24
	.word 0x87802074  ! 2955: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r25
	.word 0x87802020  ! 2957: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2958: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc8649e0  ! 2959: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r14
	.word 0xd08ec9e0  ! 2960: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r8
	mov	0x0, %r27
	mov	0x10, %r19
	.word 0xd2c56000  ! 2963: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r9
	mov	0x3e8, %r21
	.word 0xd2f52000  ! 2965: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xd2dd6000  ! 2967: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r9
	mov	0x10, %r24
	.word 0xd2d5a000  ! 2969: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r9
	.word 0xda9544a0  ! 2970: LDUHA_R	lduha	[%r21, %r0] 0x25, %r13
	mov	0x7c8, %r23
	.word 0x87802020  ! 2972: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ccc400  ! 2973: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	.word 0xdaf544a0  ! 2974: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	.word 0x87802020  ! 2975: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b44400  ! 2976: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	mov	0x3d0, %r22
	.word 0xd0dfe000  ! 2978: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	mov	0x40, %r16
	.word 0xd0b72000  ! 2980: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 2981: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r24
	.word 0xd8be49e0  ! 2983: STDA_R	stda	%r12, [%r25 + %r0] 0x4f
	.word 0xdab4a000  ! 2984: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	mov	0x3e8, %r23
	.word 0xdaac6000  ! 2986: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 2987: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda84a000  ! 2988: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	.word 0xd8ac8400  ! 2989: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0xd0bd44a0  ! 2990: STDA_R	stda	%r8, [%r21 + %r0] 0x25
	.word 0xd0a649e0  ! 2991: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	.word 0xd0a42000  ! 2992: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xdc874e80  ! 2993: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r14
	mov	0x7e0, %r21
	.word 0xdcb4a000  ! 2995: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xd09fce40  ! 2996: LDDA_R	ldda	[%r31, %r0] 0x72, %r8
	mov	0x0, %r19
	.word 0xd0d40400  ! 2998: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	mov	0x3f8, %r20
	.word 0xd88c6000  ! 3000: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	.word 0xd2b4c400  ! 3001: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	mov	0x10, %r26
	.word 0xd6cc4400  ! 3003: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	.word 0xda8c4400  ! 3004: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0xdead84a0  ! 3005: STBA_R	stba	%r15, [%r22 + %r0] 0x25
	.word 0x87802020  ! 3006: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a74e60  ! 3007: STWA_R	stwa	%r9, [%r29 + %r0] 0x73
	.word 0xd0f42000  ! 3008: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0xd69fce80  ! 3009: LDDA_R	ldda	[%r31, %r0] 0x74, %r11
	.word 0xde94e000  ! 3010: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	.word 0xdeb4a000  ! 3011: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0xded42000  ! 3013: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	mov	0x18, %r25
	.word 0xdef42000  ! 3015: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xdebce000  ! 3016: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xdef4e000  ! 3017: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 3018: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x28, %r18
	mov	0x78, %r16
	.word 0xdecea000  ! 3022: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r15
	.word 0xde966000  ! 3023: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r15
	mov	0x78, %r18
	.word 0xdebdc4a0  ! 3025: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	.word 0xd8de6000  ! 3026: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r12
	mov	0x3e0, %r21
	.word 0xd8d6e000  ! 3028: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r12
	.word 0xdccc4400  ! 3029: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r14
	.word 0x87802020  ! 3030: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r27
	.word 0xd8b78e80  ! 3032: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	.word 0xdac649e0  ! 3033: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r13
	.word 0x87802020  ! 3034: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xde8cc400  ! 3036: LDUBA_R	lduba	[%r19, %r0] 0x20, %r15
	.word 0x87802072  ! 3037: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r26
	.word 0xd2be49e0  ! 3039: STDA_R	stda	%r9, [%r25 + %r0] 0x4f
	.word 0xde9d44a0  ! 3040: LDDA_R	ldda	[%r21, %r0] 0x25, %r15
	.word 0xd8ce09e0  ! 3041: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r12
	mov	0x3f0, %r23
	mov	0x3d8, %r23
	.word 0xd2d7a000  ! 3044: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0xdea48400  ! 3045: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0x87802020  ! 3046: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdf6000  ! 3047: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	mov	0x78, %r27
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x28, %r26
	.word 0xde8f8e80  ! 3051: LDUBA_R	lduba	[%r30, %r0] 0x74, %r15
	.word 0xd8a7e000  ! 3052: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	mov	0x3e0, %r21
	.word 0xd6ad44a0  ! 3054: STBA_R	stba	%r11, [%r21 + %r0] 0x25
	.word 0xd6a4c400  ! 3055: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0x87802020  ! 3056: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef4e000  ! 3057: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xde9c6000  ! 3058: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0x87802074  ! 3059: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4df0e40  ! 3060: LDXA_R	ldxa	[%r28, %r0] 0x72, %r10
	.word 0xde85e000  ! 3061: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r15
	mov	0x48, %r24
	mov	0x7d8, %r22
	.word 0xd4a40400  ! 3064: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	.word 0xdcf52000  ! 3065: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	.word 0xd6944400  ! 3066: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	.word 0x87802073  ! 3067: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0be09e0  ! 3068: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0xd6a42000  ! 3069: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xd69f0e80  ! 3070: LDDA_R	ldda	[%r28, %r0] 0x74, %r11
	.word 0x87802020  ! 3071: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r16
	mov	0x70, %r26
	mov	0x68, %r25
	mov	0x18, %r16
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0bee000  ! 3077: STDA_I	stda	%r8, [%r27 + 0x0000] %asi
	.word 0xd08e6000  ! 3078: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r8
	.word 0xd0f74e40  ! 3079: STXA_R	stxa	%r8, [%r29 + %r0] 0x72
	.word 0xd896a000  ! 3080: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r12
	.word 0xdab7ce60  ! 3081: STHA_R	stha	%r13, [%r31 + %r0] 0x73
	.word 0xdab6a000  ! 3082: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	.word 0xda9ea000  ! 3083: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r13
	.word 0xdaae2000  ! 3084: STBA_I	stba	%r13, [%r24 + 0x0000] %asi
	.word 0xdab6e000  ! 3085: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	.word 0xd08f8e40  ! 3086: LDUBA_R	lduba	[%r30, %r0] 0x72, %r8
	.word 0xd48ea000  ! 3087: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r10
	.word 0xd4866000  ! 3088: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r10
	.word 0xd4aea000  ! 3089: STBA_I	stba	%r10, [%r26 + 0x0000] %asi
	.word 0xd4f62000  ! 3090: STXA_I	stxa	%r10, [%r24 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0x8780204f  ! 3092: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r24
	.word 0xd4a42000  ! 3094: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0xd4842000  ! 3095: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	.word 0xd4842000  ! 3096: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	.word 0x87802073  ! 3097: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4bfa000  ! 3098: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	mov	0x3d0, %r21
	mov	0x3c0, %r21
	.word 0x87802020  ! 3101: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f40400  ! 3102: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xdc8f2000  ! 3103: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0xd2948400  ! 3104: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	mov	0x50, %r27
	.word 0xdaa70e40  ! 3106: STWA_R	stwa	%r13, [%r28 + %r0] 0x72
	.word 0xdecfa000  ! 3107: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xdea76000  ! 3108: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	mov	0x48, %r25
	mov	0x20, %r26
	.word 0x87802072  ! 3111: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d8, %r23
	mov	0x7f8, %r23
	.word 0x87802074  ! 3114: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d8, %r21
	mov	0x28, %r24
	.word 0xd0d4c400  ! 3117: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	mov	0x7c8, %r23
	.word 0xd8cfe000  ! 3119: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xd4d544a0  ! 3120: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r10
	.word 0x87802020  ! 3121: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r26
	.word 0xdef649e0  ! 3123: STXA_R	stxa	%r15, [%r25 + %r0] 0x4f
	.word 0xd2a7a000  ! 3124: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xd0af8e40  ! 3125: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0x87802020  ! 3126: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3127: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 3128: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdecc0400  ! 3129: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r15
	.word 0xd2a584a0  ! 3130: STWA_R	stwa	%r9, [%r22 + %r0] 0x25
	.word 0xdcbc6000  ! 3131: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xd0bf8e80  ! 3132: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	.word 0xd4f504a0  ! 3133: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	mov	0x20, %r26
	mov	0x18, %r25
	.word 0xdc970e40  ! 3136: LDUHA_R	lduha	[%r28, %r0] 0x72, %r14
	.word 0xdab46000  ! 3137: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0xd2b74e80  ! 3138: STHA_R	stha	%r9, [%r29 + %r0] 0x74
	.word 0xd8878e80  ! 3139: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r12
	.word 0xd2c74e40  ! 3140: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r9
	.word 0xd0acc400  ! 3141: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd08c8400  ! 3142: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0x87802072  ! 3143: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa76000  ! 3144: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xd2cf4e80  ! 3145: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r9
	.word 0xd2a5c4a0  ! 3146: STWA_R	stwa	%r9, [%r23 + %r0] 0x25
	mov	0x50, %r26
	.word 0xde948400  ! 3148: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	mov	0x18, %r24
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2d7e000  ! 3151: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	mov	0x20, %r27
	.word 0xd2d76000  ! 3153: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	mov	0x50, %r27
	.word 0xd287a000  ! 3155: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0xd287e000  ! 3156: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	mov	0x3e8, %r23
	.word 0xdebd84a0  ! 3158: STDA_R	stda	%r15, [%r22 + %r0] 0x25
	.word 0xd0acc400  ! 3159: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	mov	0x50, %r26
	.word 0xd8bf4e40  ! 3161: STDA_R	stda	%r12, [%r29 + %r0] 0x72
	.word 0xd2a7a000  ! 3162: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xd2cfe000  ! 3163: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	.word 0xd2bf2000  ! 3164: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xdeac4400  ! 3165: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0xdad584a0  ! 3166: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r13
	.word 0x8780204f  ! 3167: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdace09e0  ! 3168: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r13
	.word 0xdaaf6000  ! 3169: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xdaa7e000  ! 3170: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xd4bc0400  ! 3171: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0x87802072  ! 3172: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 3173: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6cfa000  ! 3174: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0xda948400  ! 3175: LDUHA_R	lduha	[%r18, %r0] 0x20, %r13
	.word 0xd287a000  ! 3176: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2c72000  ! 3177: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd297ce80  ! 3178: LDUHA_R	lduha	[%r31, %r0] 0x74, %r9
	.word 0xd2d4c400  ! 3179: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r9
	.word 0x8780204f  ! 3180: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc84a000  ! 3181: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	mov	0x20, %r26
	.word 0xd68f8e40  ! 3183: LDUBA_R	lduba	[%r30, %r0] 0x72, %r11
	.word 0xdeb40400  ! 3184: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0xd0b4e000  ! 3185: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xdaac4400  ! 3186: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	.word 0xda94e000  ! 3187: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r13
	.word 0xdacc2000  ! 3188: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xdac5c4a0  ! 3189: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r13
	.word 0xd8bf4e40  ! 3190: STDA_R	stda	%r12, [%r29 + %r0] 0x72
	.word 0xd0f48400  ! 3191: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0x87802072  ! 3192: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4970e60  ! 3193: LDUHA_R	lduha	[%r28, %r0] 0x73, %r10
	.word 0xdccc6000  ! 3194: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	.word 0xd0cc0400  ! 3195: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xd0cf4e40  ! 3196: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	.word 0xd08ce000  ! 3197: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	mov	0x70, %r26
	.word 0xd6cf4e60  ! 3199: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r11
	.word 0xdcac2000  ! 3200: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	mov	0x0, %r18
	mov	0x8, %r19
	.word 0xdcac2000  ! 3203: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0xdac44400  ! 3204: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r13
	.word 0xd0a4e000  ! 3205: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xdc8f4e60  ! 3206: LDUBA_R	lduba	[%r29, %r0] 0x73, %r14
	.word 0xdacf0e60  ! 3207: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r13
	.word 0x8780204f  ! 3208: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6c76000  ! 3209: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0x87802074  ! 3210: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda9cc400  ! 3211: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	.word 0xd4dce000  ! 3212: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	mov	0x50, %r17
	.word 0xd297ce80  ! 3214: LDUHA_R	lduha	[%r31, %r0] 0x74, %r9
	.word 0xd0a48400  ! 3215: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0x87802072  ! 3216: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 3217: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4c44400  ! 3218: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r10
	.word 0x87802073  ! 3219: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcc72000  ! 3220: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xd68e49e0  ! 3221: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r11
	.word 0xd6972000  ! 3222: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	.word 0xd4cfce40  ! 3223: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r10
	mov	0x18, %r25
	.word 0xd6b72000  ! 3225: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd0dc0400  ! 3226: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xd0adc4a0  ! 3227: STBA_R	stba	%r8, [%r23 + %r0] 0x25
	.word 0xdecfa000  ! 3228: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xd4a6c9e0  ! 3229: STWA_R	stwa	%r10, [%r27 + %r0] 0x4f
	.word 0x87802025  ! 3230: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaf7e000  ! 3231: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xdaafa000  ! 3233: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	mov	0x3c8, %r22
	.word 0xd6f504a0  ! 3235: STXA_R	stxa	%r11, [%r20 + %r0] 0x25
	.word 0xdea76000  ! 3236: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xd0d544a0  ! 3237: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r8
	mov	0x7e0, %r22
	.word 0xd08544a0  ! 3239: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r8
	.word 0xdeb70e80  ! 3240: STHA_R	stha	%r15, [%r28 + %r0] 0x74
	mov	0x7c8, %r20
	.word 0xd49584a0  ! 3242: LDUHA_R	lduha	[%r22, %r0] 0x25, %r10
	.word 0xd4a6c9e0  ! 3243: STWA_R	stwa	%r10, [%r27 + %r0] 0x4f
	.word 0xdcbcc400  ! 3244: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xd4b70e40  ! 3245: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	mov	0x40, %r18
	mov	0x50, %r16
	.word 0xdcdf2000  ! 3248: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0x87802025  ! 3249: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb6e000  ! 3250: STHA_I	stha	%r14, [%r27 + 0x0000] %asi
	.word 0xd8b584a0  ! 3251: STHA_R	stha	%r12, [%r22 + %r0] 0x25
	.word 0xd0dea000  ! 3252: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r8
	.word 0x87802074  ! 3253: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0cca000  ! 3254: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	mov	0x18, %r26
	.word 0xd8d544a0  ! 3256: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r12
	.word 0xdc94a000  ! 3257: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xdca42000  ! 3258: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	mov	0x68, %r26
	.word 0xd4c689e0  ! 3260: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r10
	.word 0x87802074  ! 3261: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4970e80  ! 3262: LDUHA_R	lduha	[%r28, %r0] 0x74, %r10
	.word 0xd494e000  ! 3263: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	.word 0xdcf78e60  ! 3264: STXA_R	stxa	%r14, [%r30 + %r0] 0x73
	.word 0x87802020  ! 3265: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3266: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d0, %r22
	mov	0x78, %r16
	.word 0xdeb5e000  ! 3269: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	.word 0xde9d2000  ! 3270: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r15
	.word 0xd0f609e0  ! 3271: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	mov	0x30, %r17
	mov	0x20, %r19
	.word 0xd0d56000  ! 3274: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r8
	mov	0x7d0, %r20
	.word 0xd6bf8e80  ! 3276: STDA_R	stda	%r11, [%r30 + %r0] 0x74
	.word 0xda84c400  ! 3277: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r13
	.word 0xdabd6000  ! 3278: STDA_I	stda	%r13, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 3279: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab4e000  ! 3280: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xda84a000  ! 3281: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	.word 0xdcafce60  ! 3282: STBA_R	stba	%r14, [%r31 + %r0] 0x73
	.word 0xd6d4c400  ! 3283: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	mov	0x7f8, %r21
	.word 0xdcb46000  ! 3285: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xdca42000  ! 3286: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	mov	0x3e0, %r20
	.word 0xdcac6000  ! 3288: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xdcf46000  ! 3290: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdcd42000  ! 3291: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	.word 0x87802025  ! 3292: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 3293: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3294: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf7e000  ! 3295: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcf72000  ! 3296: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcaf4e80  ! 3297: STBA_R	stba	%r14, [%r29 + %r0] 0x74
	.word 0x87802072  ! 3298: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdec48400  ! 3299: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	mov	0x18, %r17
	.word 0x87802073  ! 3301: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0d6e000  ! 3302: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r8
	mov	0x0, %r24
	.word 0xd88f8e40  ! 3304: LDUBA_R	lduba	[%r30, %r0] 0x72, %r12
	mov	0x20, %r27
	mov	0x58, %r19
	mov	0x28, %r26
	.word 0xd0be2000  ! 3308: STDA_I	stda	%r8, [%r24 + 0x0000] %asi
	.word 0x87802073  ! 3309: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd08c2000  ! 3310: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0x87802073  ! 3311: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd084e000  ! 3312: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	mov	0x3f8, %r22
	.word 0xd09ce000  ! 3314: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r8
	.word 0x87802025  ! 3315: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde8dc4a0  ! 3316: LDUBA_R	lduba	[%r23, %r0] 0x25, %r15
	.word 0xd2f4c400  ! 3317: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xd2b4e000  ! 3318: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0xda8dc4a0  ! 3320: LDUBA_R	lduba	[%r23, %r0] 0x25, %r13
	.word 0xdc8ce000  ! 3321: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	.word 0xd8bc8400  ! 3322: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xd8bf8e80  ! 3323: STDA_R	stda	%r12, [%r30 + %r0] 0x74
	.word 0x87802072  ! 3324: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8942000  ! 3325: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r12
	.word 0xd8f4e000  ! 3326: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xd4b4c400  ! 3327: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0xdad70e80  ! 3328: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r13
	.word 0xda9ca000  ! 3329: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	.word 0xda94a000  ! 3330: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3331: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8afce40  ! 3332: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	.word 0xd6870e40  ! 3333: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r11
	.word 0xd8bf8e60  ! 3334: STDA_R	stda	%r12, [%r30 + %r0] 0x73
	.word 0xd28ca000  ! 3335: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0xd0adc4a0  ! 3336: STBA_R	stba	%r8, [%r23 + %r0] 0x25
	.word 0xd2f42000  ! 3337: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0xd09c0400  ! 3338: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	mov	0x7d8, %r22
	.word 0x8780204f  ! 3340: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a4a000  ! 3341: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0xd2942000  ! 3342: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3343: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b78e40  ! 3344: STHA_R	stha	%r12, [%r30 + %r0] 0x72
	.word 0xd89c2000  ! 3345: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	.word 0x87802025  ! 3346: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8dfa000  ! 3347: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	mov	0x7e8, %r21
	.word 0x87802025  ! 3349: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3350: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b72000  ! 3351: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 3352: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bcc400  ! 3353: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	mov	0x10, %r25
	.word 0xd6f6c9e0  ! 3355: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 3356: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac6e000  ! 3357: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r13
	mov	0x60, %r26
	.word 0xdab66000  ! 3359: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0x8780204f  ! 3360: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 3361: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r26
	.word 0xd6f74e80  ! 3363: STXA_R	stxa	%r11, [%r29 + %r0] 0x74
	.word 0xdcf584a0  ! 3364: STXA_R	stxa	%r14, [%r22 + %r0] 0x25
	.word 0xd6f504a0  ! 3365: STXA_R	stxa	%r11, [%r20 + %r0] 0x25
	mov	0x70, %r24
	.word 0xd6f76000  ! 3367: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	mov	0x18, %r16
	.word 0xd6cf6000  ! 3369: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd0b70e60  ! 3370: STHA_R	stha	%r8, [%r28 + %r0] 0x73
	.word 0xd28f2000  ! 3371: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	mov	0x48, %r19
	mov	0x7c0, %r21
	mov	0x48, %r25
	.word 0xdaf6c9e0  ! 3375: STXA_R	stxa	%r13, [%r27 + %r0] 0x4f
	.word 0x8780204f  ! 3376: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaafa000  ! 3377: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd6af8e60  ! 3379: STBA_R	stba	%r11, [%r30 + %r0] 0x73
	.word 0xd2cfe000  ! 3380: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	.word 0xd2af6000  ! 3381: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xdcaf4e60  ! 3382: STBA_R	stba	%r14, [%r29 + %r0] 0x73
	.word 0xdeac0400  ! 3383: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xd88c8400  ! 3384: LDUBA_R	lduba	[%r18, %r0] 0x20, %r12
	.word 0xde87ce60  ! 3385: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r15
	.word 0xdabf0e40  ! 3386: STDA_R	stda	%r13, [%r28 + %r0] 0x72
	.word 0xd8972000  ! 3387: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	mov	0x50, %r27
	.word 0xdcad44a0  ! 3389: STBA_R	stba	%r14, [%r21 + %r0] 0x25
	mov	0x18, %r19
	.word 0xd8976000  ! 3391: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0xd88fa000  ! 3392: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0xd6afce40  ! 3393: STBA_R	stba	%r11, [%r31 + %r0] 0x72
	mov	0x0, %r16
	.word 0xd6a7ce60  ! 3395: STWA_R	stwa	%r11, [%r31 + %r0] 0x73
	.word 0xd6c7a000  ! 3396: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	.word 0xd09c4400  ! 3397: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	.word 0xdedf4e80  ! 3398: LDXA_R	ldxa	[%r29, %r0] 0x74, %r15
	.word 0xdeb649e0  ! 3399: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	.word 0xd2afe000  ! 3400: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 3401: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdcf70e60  ! 3403: STXA_R	stxa	%r14, [%r28 + %r0] 0x73
	.word 0xd2c42000  ! 3404: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	mov	0x30, %r19
	.word 0xd2cce000  ! 3406: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	.word 0xd28ce000  ! 3407: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	.word 0xd6bd84a0  ! 3408: STDA_R	stda	%r11, [%r22 + %r0] 0x25
	.word 0x8780204f  ! 3409: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf74e80  ! 3410: STXA_R	stxa	%r13, [%r29 + %r0] 0x74
	.word 0xdea44400  ! 3411: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xdcc4e000  ! 3412: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r14
	.word 0x87802020  ! 3413: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc866000  ! 3414: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r14
	.word 0x87802025  ! 3415: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3416: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccfa000  ! 3417: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0x87802072  ! 3418: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb7e000  ! 3419: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xdc976000  ! 3420: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	mov	0x38, %r27
	.word 0xdcbe89e0  ! 3422: STDA_R	stda	%r14, [%r26 + %r0] 0x4f
	mov	0x3c0, %r23
	.word 0xd6d48400  ! 3424: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0xdab7a000  ! 3425: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xde97ce80  ! 3426: LDUHA_R	lduha	[%r31, %r0] 0x74, %r15
	.word 0x87802072  ! 3427: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a44400  ! 3428: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0x87802020  ! 3429: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdf2000  ! 3430: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcc76000  ! 3431: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xdcbfe000  ! 3432: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xd0f689e0  ! 3433: STXA_R	stxa	%r8, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 3434: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 3435: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabf6000  ! 3436: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xd8bfce80  ! 3437: STDA_R	stda	%r12, [%r31 + %r0] 0x74
	.word 0xd08f6000  ! 3438: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r8
	.word 0xd0d72000  ! 3439: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd4b70e40  ! 3440: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	.word 0x87802073  ! 3441: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd887ce80  ! 3442: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r12
	.word 0xdeb48400  ! 3443: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xd8a72000  ! 3444: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	mov	0x3f0, %r20
	.word 0xd8cf6000  ! 3446: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0x87802025  ! 3447: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a78e80  ! 3448: STWA_R	stwa	%r11, [%r30 + %r0] 0x74
	mov	0x8, %r18
	.word 0xdab7e000  ! 3450: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xdab76000  ! 3451: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	mov	0x3f0, %r20
	.word 0xdacf2000  ! 3453: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xdabf2000  ! 3454: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	mov	0x50, %r26
	mov	0x20, %r19
	.word 0xdabf6000  ! 3457: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	mov	0x68, %r17
	mov	0x20, %r18
	.word 0xd2c44400  ! 3460: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	.word 0xd6d544a0  ! 3461: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r11
	.word 0xd4f649e0  ! 3462: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	.word 0xde840400  ! 3463: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	.word 0xd4b7e000  ! 3464: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xda8c0400  ! 3465: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	.word 0xd2972000  ! 3466: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xda9e49e0  ! 3467: LDDA_R	ldda	[%r25, %r0] 0x4f, %r13
	.word 0xd2d74e60  ! 3468: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r9
	mov	0x7f0, %r22
	.word 0xd0cfe000  ! 3470: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xdea689e0  ! 3471: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	mov	0x40, %r16
	mov	0x48, %r16
	.word 0xd4b74e80  ! 3474: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	.word 0xd0a74e80  ! 3475: STWA_R	stwa	%r8, [%r29 + %r0] 0x74
	.word 0xd6afa000  ! 3476: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd0f78e60  ! 3477: STXA_R	stxa	%r8, [%r30 + %r0] 0x73
	.word 0xda9f6000  ! 3478: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xdacfe000  ! 3479: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0xd087ce60  ! 3480: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r8
	mov	0x7c0, %r22
	.word 0x87802025  ! 3482: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd48f4e80  ! 3483: LDUBA_R	lduba	[%r29, %r0] 0x74, %r10
	mov	0x28, %r26
	.word 0xdaf5c4a0  ! 3485: STXA_R	stxa	%r13, [%r23 + %r0] 0x25
	.word 0xd2c5c4a0  ! 3486: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r9
	.word 0xdea46000  ! 3487: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xdebe09e0  ! 3488: STDA_R	stda	%r15, [%r24 + %r0] 0x4f
	.word 0xdcc4e000  ! 3489: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r14
	.word 0xdcbca000  ! 3490: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdc94a000  ! 3491: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xdc942000  ! 3492: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	mov	0x3d0, %r22
	mov	0x30, %r16
	.word 0xdc8c2000  ! 3495: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r14
	mov	0x68, %r17
	.word 0xdcf4a000  ! 3497: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcc4e000  ! 3498: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r14
	.word 0x87802074  ! 3499: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd68cc400  ! 3500: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	.word 0xd895c4a0  ! 3501: LDUHA_R	lduha	[%r23, %r0] 0x25, %r12
	.word 0x87802020  ! 3502: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0a70e80  ! 3504: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0xd4b74e60  ! 3505: STHA_R	stha	%r10, [%r29 + %r0] 0x73
	.word 0x87802072  ! 3506: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8bfa000  ! 3507: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd8f76000  ! 3508: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd89fa000  ! 3509: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	.word 0xd6f70e60  ! 3510: STXA_R	stxa	%r11, [%r28 + %r0] 0x73
	.word 0xdac78e60  ! 3511: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r13
	mov	0x40, %r16
	.word 0x8780204f  ! 3513: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r27
	.word 0xd0cf8e60  ! 3515: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r8
	.word 0xd6f56000  ! 3516: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	.word 0xd2f4c400  ! 3517: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xdc85c4a0  ! 3518: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r14
	.word 0xd6f74e40  ! 3519: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	.word 0xdab4c400  ! 3520: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	mov	0x58, %r17
	.word 0xdcc5a000  ! 3522: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r14
	mov	0x28, %r18
	mov	0x3e8, %r22
	.word 0xd88dc4a0  ! 3525: LDUBA_R	lduba	[%r23, %r0] 0x25, %r12
	.word 0xdc9e09e0  ! 3526: LDDA_R	ldda	[%r24, %r0] 0x4f, %r14
	.word 0xd2856000  ! 3527: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r9
	.word 0xd29d2000  ! 3528: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r9
	mov	0x70, %r19
	.word 0xd29d6000  ! 3530: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r9
	mov	0x3d0, %r23
	mov	0x7d8, %r20
	.word 0xd2ada000  ! 3533: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0xd2bd2000  ! 3535: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	.word 0xded44400  ! 3536: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	mov	0x18, %r17
	mov	0x30, %r25
	mov	0x3e8, %r20
	.word 0xd6dd2000  ! 3540: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r11
	mov	0x48, %r17
	.word 0xd6b52000  ! 3542: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	.word 0xd6c5a000  ! 3543: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r11
	.word 0xd6952000  ! 3544: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r11
	.word 0xd4b5c4a0  ! 3545: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	.word 0xdcade000  ! 3546: STBA_I	stba	%r14, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 3547: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8df4e40  ! 3548: LDXA_R	ldxa	[%r29, %r0] 0x72, %r12
	.word 0xdacf2000  ! 3549: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xda976000  ! 3550: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	.word 0xd6ac4400  ! 3551: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xdabc4400  ! 3552: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xd8d504a0  ! 3553: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r12
	.word 0xdad48400  ! 3554: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0xd0a4c400  ! 3555: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xd0d7e000  ! 3556: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0bf6000  ! 3557: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd09f2000  ! 3558: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0xd0f7e000  ! 3559: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0cf6000  ! 3560: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	mov	0x70, %r17
	.word 0xd8cf0e80  ! 3562: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r12
	mov	0x70, %r27
	mov	0x3c0, %r22
	.word 0xd0af2000  ! 3565: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	mov	0x20, %r16
	mov	0x58, %r19
	mov	0x60, %r26
	mov	0x70, %r24
	.word 0xd0bf2000  ! 3570: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xdc97ce80  ! 3571: LDUHA_R	lduha	[%r31, %r0] 0x74, %r14
	mov	0x3c0, %r20
	.word 0xdc8649e0  ! 3573: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r14
	.word 0xd0878e40  ! 3574: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r8
	.word 0xdc940400  ! 3575: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0xd2876000  ! 3576: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	mov	0x3d0, %r23
	.word 0xd6acc400  ! 3578: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0x87802020  ! 3579: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bf2000  ! 3580: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	mov	0x7c0, %r20
	.word 0xd28fa000  ! 3582: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	mov	0x70, %r27
	.word 0xda8dc4a0  ! 3584: LDUBA_R	lduba	[%r23, %r0] 0x25, %r13
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0b72000  ! 3586: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	mov	0x7e0, %r21
	.word 0xd0b7a000  ! 3588: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	mov	0x7c0, %r21
	.word 0x87802020  ! 3590: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b78e80  ! 3591: STHA_R	stha	%r11, [%r30 + %r0] 0x74
	mov	0x50, %r26
	.word 0xda9fe000  ! 3593: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0x87802072  ! 3594: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r16
	.word 0xd89f0e60  ! 3596: LDDA_R	ldda	[%r28, %r0] 0x73, %r12
	.word 0xde9c8400  ! 3597: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	mov	0x20, %r25
	.word 0xd0f44400  ! 3599: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0x87802072  ! 3600: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3601: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8afa000  ! 3602: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xd88fe000  ! 3603: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	mov	0x20, %r16
	.word 0x87802073  ! 3605: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2bf4e40  ! 3606: STDA_R	stda	%r9, [%r29 + %r0] 0x72
	.word 0xd6cf6000  ! 3607: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xde940400  ! 3608: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0x87802073  ! 3609: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda9d2000  ! 3610: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r13
	.word 0xdaf52000  ! 3611: STXA_I	stxa	%r13, [%r20 + 0x0000] %asi
	.word 0xdcd5c4a0  ! 3612: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r14
	mov	0x20, %r25
	.word 0xda8de000  ! 3614: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r13
	.word 0xdab5e000  ! 3615: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0xda8d2000  ! 3616: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r13
	.word 0xd6b609e0  ! 3617: STHA_R	stha	%r11, [%r24 + %r0] 0x4f
	.word 0xdebf8e60  ! 3618: STDA_R	stda	%r15, [%r30 + %r0] 0x73
	.word 0xdab52000  ! 3619: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	.word 0xdabd2000  ! 3620: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	.word 0xdabd04a0  ! 3621: STDA_R	stda	%r13, [%r20 + %r0] 0x25
	.word 0xdabd2000  ! 3622: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	.word 0xd8cd44a0  ! 3623: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r12
	.word 0xd885a000  ! 3624: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r12
	.word 0x87802072  ! 3625: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49d44a0  ! 3626: LDDA_R	ldda	[%r21, %r0] 0x25, %r10
	.word 0xd2d74e40  ! 3627: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r9
	.word 0x87802020  ! 3628: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb7ce40  ! 3629: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	.word 0xd6c5c4a0  ! 3630: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r11
	.word 0xd4840400  ! 3631: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	mov	0x28, %r17
	.word 0x8780204f  ! 3633: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a74e80  ! 3634: STWA_R	stwa	%r8, [%r29 + %r0] 0x74
	.word 0xdacda000  ! 3635: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r13
	.word 0x87802073  ! 3636: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdab52000  ! 3637: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	.word 0xda97ce60  ! 3638: LDUHA_R	lduha	[%r31, %r0] 0x73, %r13
	.word 0x87802072  ! 3639: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7c8, %r21
	.word 0xd88ce000  ! 3641: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	mov	0x3d8, %r22
	.word 0xd8f46000  ! 3643: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xd287ce40  ! 3644: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r9
	.word 0x87802073  ! 3645: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r27
	mov	0x78, %r25
	.word 0xdea48400  ! 3648: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xd6b46000  ! 3649: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xdca649e0  ! 3650: STWA_R	stwa	%r14, [%r25 + %r0] 0x4f
	mov	0x7c8, %r20
	.word 0xd0af0e60  ! 3652: STBA_R	stba	%r8, [%r28 + %r0] 0x73
	.word 0xda878e40  ! 3653: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r13
	.word 0xd0a4a000  ! 3654: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0xdcce09e0  ! 3655: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r14
	.word 0xd0b504a0  ! 3656: STHA_R	stha	%r8, [%r20 + %r0] 0x25
	.word 0xd4c46000  ! 3657: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r10
	mov	0x3c8, %r21
	mov	0x70, %r24
	mov	0x18, %r18
	.word 0xd4b4a000  ! 3661: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 3662: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bd2000  ! 3663: STDA_I	stda	%r10, [%r20 + 0x0000] %asi
	.word 0xdcb4c400  ! 3664: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xd68f0e60  ! 3665: LDUBA_R	lduba	[%r28, %r0] 0x73, %r11
	.word 0xd29649e0  ! 3666: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r9
	.word 0xd0af8e40  ! 3667: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0x87802073  ! 3668: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbfe000  ! 3669: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdcbfa000  ! 3670: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdcbd84a0  ! 3671: STDA_R	stda	%r14, [%r22 + %r0] 0x25
	.word 0x8780204f  ! 3672: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd69e2000  ! 3673: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r11
	.word 0xd09f4e40  ! 3674: LDDA_R	ldda	[%r29, %r0] 0x72, %r8
	mov	0x78, %r25
	.word 0xdab70e40  ! 3676: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	.word 0xd2b6e000  ! 3677: STHA_I	stha	%r9, [%r27 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xd2f78e60  ! 3679: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0xd2974e40  ! 3680: LDUHA_R	lduha	[%r29, %r0] 0x72, %r9
	.word 0xdadee000  ! 3681: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r13
	mov	0x68, %r24
	.word 0x8780204f  ! 3683: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r17
	mov	0x7e8, %r22
	.word 0x87802073  ! 3686: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6b48400  ! 3687: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd29e6000  ! 3688: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r9
	mov	0x60, %r26
	mov	0x78, %r27
	.word 0xd2aea000  ! 3691: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0xd4c544a0  ! 3692: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r10
	.word 0xd0ce2000  ! 3693: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r8
	.word 0x87802073  ! 3694: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0f4a000  ! 3695: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 3696: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4bc0400  ! 3697: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xdaf44400  ! 3698: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0xd0d5e000  ! 3699: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r8
	.word 0xd09de000  ! 3700: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r8
	.word 0xd88cc400  ! 3701: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	mov	0x7e8, %r23
	.word 0x8780204f  ! 3703: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3704: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2afe000  ! 3705: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	mov	0x48, %r18
	.word 0xd2af2000  ! 3707: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0x87802072  ! 3709: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2df2000  ! 3710: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	mov	0x7d8, %r23
	.word 0x87802020  ! 3712: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9c4400  ! 3713: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	mov	0x70, %r25
	.word 0xde8f4e80  ! 3715: LDUBA_R	lduba	[%r29, %r0] 0x74, %r15
	.word 0xd88f6000  ! 3716: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0x87802073  ! 3717: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8dc2000  ! 3718: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0xd8f4e000  ! 3719: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	mov	0x10, %r17
	.word 0xd6a70e40  ! 3721: STWA_R	stwa	%r11, [%r28 + %r0] 0x72
	.word 0xd6b584a0  ! 3722: STHA_R	stha	%r11, [%r22 + %r0] 0x25
	.word 0xdc846000  ! 3723: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	.word 0xdcf42000  ! 3724: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0xdcd4e000  ! 3725: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	.word 0xd4ad84a0  ! 3726: STBA_R	stba	%r10, [%r22 + %r0] 0x25
	.word 0xd0a7ce40  ! 3727: STWA_R	stwa	%r8, [%r31 + %r0] 0x72
	.word 0xdad40400  ! 3728: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	mov	0x3d0, %r21
	.word 0xd6bd04a0  ! 3730: STDA_R	stda	%r11, [%r20 + %r0] 0x25
	.word 0xd4f42000  ! 3731: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 3732: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r17
	.word 0x87802025  ! 3734: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f8, %r23
	mov	0x28, %r19
	.word 0x87802025  ! 3737: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8649e0  ! 3738: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r13
	mov	0x7c0, %r23
	mov	0x8, %r18
	.word 0x87802025  ! 3741: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde940400  ! 3742: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	mov	0x60, %r27
	.word 0xdebfce60  ! 3744: STDA_R	stda	%r15, [%r31 + %r0] 0x73
	.word 0x87802025  ! 3745: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f46000  ! 3746: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xd094a000  ! 3747: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	mov	0x7d0, %r22
	.word 0x87802073  ! 3749: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b66000  ! 3750: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	.word 0xdcd7ce40  ! 3751: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r14
	mov	0x40, %r25
	.word 0xd2ce2000  ! 3753: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r9
	.word 0xd4c4c400  ! 3754: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r10
	mov	0x70, %r17
	mov	0x0, %r27
	.word 0xd49c8400  ! 3757: LDDA_R	ldda	[%r18, %r0] 0x20, %r10
	.word 0x87802072  ! 3758: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3759: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d8, %r21
	mov	0x60, %r16
	.word 0xd0afce80  ! 3762: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	mov	0x78, %r24
	.word 0xde978e80  ! 3764: LDUHA_R	lduha	[%r30, %r0] 0x74, %r15
	.word 0xdcccc400  ! 3765: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	mov	0x3d8, %r20
	mov	0x48, %r19
	.word 0xd2b6a000  ! 3768: STHA_I	stha	%r9, [%r26 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0xd2bea000  ! 3770: STDA_I	stda	%r9, [%r26 + 0x0000] %asi
	.word 0xd2b4c400  ! 3771: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xdef62000  ! 3772: STXA_I	stxa	%r15, [%r24 + 0x0000] %asi
	.word 0xdef62000  ! 3773: STXA_I	stxa	%r15, [%r24 + 0x0000] %asi
	mov	0x68, %r24
	.word 0x87802074  ! 3775: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd087ce60  ! 3776: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r8
	.word 0xdcd7a000  ! 3777: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0xda874e40  ! 3778: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r13
	.word 0xdccf6000  ! 3779: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcbc4400  ! 3780: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0x87802020  ! 3781: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3782: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c0, %r21
	.word 0xd6af4e80  ! 3784: STBA_R	stba	%r11, [%r29 + %r0] 0x74
	.word 0xd6f6e000  ! 3785: STXA_I	stxa	%r11, [%r27 + 0x0000] %asi
	.word 0x87802072  ! 3786: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f76000  ! 3787: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	mov	0x48, %r26
	.word 0xd6afe000  ! 3789: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x68, %r18
	.word 0xd6afe000  ! 3791: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x30, %r27
	.word 0xdeb4c400  ! 3793: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0x87802025  ! 3794: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8f4c400  ! 3795: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xd2c48400  ! 3796: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0xd4f7ce60  ! 3797: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	.word 0xd6b62000  ! 3798: STHA_I	stha	%r11, [%r24 + 0x0000] %asi
	.word 0xd6a66000  ! 3799: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0x8780204f  ! 3801: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r19
	mov	0x7e0, %r23
	.word 0xd8af4e40  ! 3804: STBA_R	stba	%r12, [%r29 + %r0] 0x72
	mov	0x68, %r26
	mov	0x50, %r25
	.word 0xde8f4e40  ! 3807: LDUBA_R	lduba	[%r29, %r0] 0x72, %r15
	.word 0xd4ad2000  ! 3808: STBA_I	stba	%r10, [%r20 + 0x0000] %asi
	.word 0x87802072  ! 3809: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4bea000  ! 3810: STDA_I	stda	%r10, [%r26 + 0x0000] %asi
	.word 0x87802073  ! 3811: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r16
	mov	0x48, %r19
	.word 0xd494a000  ! 3814: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r10
	.word 0xdeb4c400  ! 3815: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xd2bce000  ! 3816: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0xd8af4e80  ! 3818: STBA_R	stba	%r12, [%r29 + %r0] 0x74
	.word 0xd08cc400  ! 3819: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	.word 0xd0b4c400  ! 3820: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	mov	0x78, %r26
	.word 0xdc8c2000  ! 3822: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r14
	mov	0x18, %r26
	.word 0xdaddc4a0  ! 3824: LDXA_R	ldxa	[%r23, %r0] 0x25, %r13
	mov	0x50, %r25
	mov	0x38, %r26
	.word 0xd4d689e0  ! 3827: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r10
	.word 0xda9f4e40  ! 3828: LDDA_R	ldda	[%r29, %r0] 0x72, %r13
	.word 0xd09ce000  ! 3829: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r8
	.word 0xd0cc2000  ! 3830: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	.word 0xd09c2000  ! 3831: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r8
	.word 0xd8f4c400  ! 3832: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0x87802074  ! 3833: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0dd04a0  ! 3834: LDXA_R	ldxa	[%r20, %r0] 0x25, %r8
	.word 0x87802074  ! 3835: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r23
	.word 0xdcdc6000  ! 3837: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	mov	0x78, %r26
	.word 0xdcb42000  ! 3839: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xdc9ca000  ! 3840: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r14
	.word 0xdcb42000  ! 3841: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xd4f609e0  ! 3842: STXA_R	stxa	%r10, [%r24 + %r0] 0x4f
	.word 0xd8f74e60  ! 3843: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	.word 0xd8b689e0  ! 3844: STHA_R	stha	%r12, [%r26 + %r0] 0x4f
	mov	0x7f0, %r23
	.word 0x87802020  ! 3846: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r26
	mov	0x60, %r16
	.word 0x87802020  ! 3849: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f40400  ! 3850: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xdea78e60  ! 3851: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	mov	0x78, %r25
	mov	0x48, %r26
	.word 0xd0a5c4a0  ! 3854: STWA_R	stwa	%r8, [%r23 + %r0] 0x25
	.word 0xd4f70e40  ! 3855: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	.word 0xd8970e60  ! 3856: LDUHA_R	lduha	[%r28, %r0] 0x73, %r12
	.word 0xdea78e40  ! 3857: STWA_R	stwa	%r15, [%r30 + %r0] 0x72
	.word 0xd0afce60  ! 3858: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	.word 0xdea70e80  ! 3859: STWA_R	stwa	%r15, [%r28 + %r0] 0x74
	.word 0x87802074  ! 3860: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8866000  ! 3861: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r12
	.word 0xdadf0e40  ! 3862: LDXA_R	ldxa	[%r28, %r0] 0x72, %r13
	.word 0xdc9e6000  ! 3863: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r14
	mov	0x68, %r24
	.word 0xde9d44a0  ! 3865: LDDA_R	ldda	[%r21, %r0] 0x25, %r15
	mov	0x40, %r17
	.word 0x87802072  ! 3867: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r18
	.word 0xdc8c4400  ! 3869: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0x87802072  ! 3870: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd68504a0  ! 3871: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r11
	.word 0xdcdc4400  ! 3872: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	.word 0xd6aca000  ! 3873: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xd6c4e000  ! 3874: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3875: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d649e0  ! 3876: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r11
	.word 0xd0bee000  ! 3877: STDA_I	stda	%r8, [%r27 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xd48ec9e0  ! 3879: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r10
	.word 0xde86e000  ! 3880: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r15
	.word 0xd4ac0400  ! 3881: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xdc962000  ! 3882: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 3883: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdccfa000  ! 3884: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xdcbd84a0  ! 3885: STDA_R	stda	%r14, [%r22 + %r0] 0x25
	.word 0xdabf4e80  ! 3886: STDA_R	stda	%r13, [%r29 + %r0] 0x74
	.word 0x87802074  ! 3887: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2d46000  ! 3888: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	.word 0xdaaf8e80  ! 3889: STBA_R	stba	%r13, [%r30 + %r0] 0x74
	.word 0xde8ec9e0  ! 3890: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r15
	.word 0xd4b4c400  ! 3891: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0x87802073  ! 3892: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8dcc400  ! 3893: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	.word 0xd0b6c9e0  ! 3894: STHA_R	stha	%r8, [%r27 + %r0] 0x4f
	.word 0xd8bfe000  ! 3895: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd8afa000  ! 3896: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xd8bfe000  ! 3897: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd8a76000  ! 3898: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xdebc4400  ! 3899: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0xd4d74e60  ! 3900: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r10
	.word 0xd2876000  ! 3901: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xdcbe89e0  ! 3902: STDA_R	stda	%r14, [%r26 + %r0] 0x4f
	.word 0xdcdcc400  ! 3903: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	.word 0xdcf48400  ! 3904: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xdccf4e40  ! 3905: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r14
	mov	0x7e8, %r20
	.word 0xdebf6000  ! 3907: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xd8a6c9e0  ! 3908: STWA_R	stwa	%r12, [%r27 + %r0] 0x4f
	.word 0xde8689e0  ! 3909: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r15
	.word 0xd0f44400  ! 3910: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	mov	0x7f8, %r20
	mov	0x3e0, %r20
	.word 0xdaf72000  ! 3913: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	mov	0x7e0, %r22
	.word 0xd2cc8400  ! 3915: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0xd89ec9e0  ! 3916: LDDA_R	ldda	[%r27, %r0] 0x4f, %r12
	.word 0x87802073  ! 3917: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c8, %r20
	.word 0xd6976000  ! 3919: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	.word 0xd6b7a000  ! 3920: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd0ccc400  ! 3921: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	.word 0xd4cf2000  ! 3922: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xde8f0e80  ! 3923: LDUBA_R	lduba	[%r28, %r0] 0x74, %r15
	.word 0x87802020  ! 3924: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf7a000  ! 3925: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdad72000  ! 3926: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0xde9f0e60  ! 3927: LDDA_R	ldda	[%r28, %r0] 0x73, %r15
	.word 0xd4bfa000  ! 3928: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xd4cf2000  ! 3930: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xdc878e80  ! 3931: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r14
	.word 0xd8a7ce60  ! 3932: STWA_R	stwa	%r12, [%r31 + %r0] 0x73
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd89cc400  ! 3934: LDDA_R	ldda	[%r19, %r0] 0x20, %r12
	.word 0xde97ce40  ! 3935: LDUHA_R	lduha	[%r31, %r0] 0x72, %r15
	.word 0x87802074  ! 3936: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf5a000  ! 3937: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	.word 0xdc978e80  ! 3938: LDUHA_R	lduha	[%r30, %r0] 0x74, %r14
	.word 0xdcad04a0  ! 3939: STBA_R	stba	%r14, [%r20 + %r0] 0x25
	.word 0xdaa44400  ! 3940: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 3941: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4c70e80  ! 3942: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r10
	.word 0xd49c0400  ! 3943: LDDA_R	ldda	[%r16, %r0] 0x20, %r10
	.word 0xd0f74e40  ! 3944: STXA_R	stxa	%r8, [%r29 + %r0] 0x72
	.word 0xdef4e000  ! 3945: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 3946: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r21
	.word 0xd8cf0e80  ! 3948: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r12
	mov	0x7f0, %r22
	.word 0xd08f8e80  ! 3950: LDUBA_R	lduba	[%r30, %r0] 0x74, %r8
	.word 0xdc8fce60  ! 3951: LDUBA_R	lduba	[%r31, %r0] 0x73, %r14
	.word 0x87802025  ! 3952: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd694c400  ! 3953: LDUHA_R	lduha	[%r19, %r0] 0x20, %r11
	.word 0xd6af2000  ! 3954: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xdaae89e0  ! 3955: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	.word 0xd6df2000  ! 3956: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0x87802072  ! 3957: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf584a0  ! 3958: STXA_R	stxa	%r14, [%r22 + %r0] 0x25
	.word 0xd0cd6000  ! 3959: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r8
	.word 0xd08d2000  ! 3960: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r8
	.word 0xdcaf0e80  ! 3961: STBA_R	stba	%r14, [%r28 + %r0] 0x74
	.word 0xdea5e000  ! 3962: STWA_I	stwa	%r15, [%r23 + 0x0000] %asi
	.word 0xd4a7ce40  ! 3963: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	.word 0x87802020  ! 3964: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68cc400  ! 3965: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2f7a000  ! 3967: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xd2876000  ! 3968: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	mov	0x48, %r16
	.word 0xd6cf0e80  ! 3970: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r11
	.word 0x87802020  ! 3971: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3972: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 3973: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r19
	.word 0xd49609e0  ! 3975: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r10
	.word 0xd49ce000  ! 3976: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0xd4dca000  ! 3977: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	mov	0x7c0, %r20
	mov	0x68, %r26
	.word 0x87802072  ! 3980: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4ace000  ! 3981: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	mov	0x7f8, %r20
	.word 0xd4b4e000  ! 3983: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xd4a4a000  ! 3984: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xd4ace000  ! 3985: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0xdcf584a0  ! 3986: STXA_R	stxa	%r14, [%r22 + %r0] 0x25
	.word 0xd6cc2000  ! 3987: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	.word 0x87802073  ! 3988: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b78e60  ! 3989: STHA_R	stha	%r9, [%r30 + %r0] 0x73
	.word 0xdacce000  ! 3990: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r13
	.word 0xd88f0e40  ! 3991: LDUBA_R	lduba	[%r28, %r0] 0x72, %r12
	.word 0xd4ace000  ! 3992: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0xd49ce000  ! 3993: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0xd4f42000  ! 3994: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd0ce49e0  ! 3995: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r8
	.word 0xd8ace000  ! 3996: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0xd88c6000  ! 3997: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	.word 0x87802025  ! 3998: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xded7ce80  ! 3999: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r15
	.word 0xd6cfe000  ! 4000: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	mov	0x18, %r26
	.word 0xd68fa000  ! 4002: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0xd0b7ce60  ! 4003: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	.word 0xd4cfe000  ! 4004: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0xd4c7e000  ! 4005: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	mov	0x7e0, %r23
	.word 0xdaad44a0  ! 4007: STBA_R	stba	%r13, [%r21 + %r0] 0x25
	.word 0xd4dfce80  ! 4008: LDXA_R	ldxa	[%r31, %r0] 0x74, %r10
	.word 0x8780204f  ! 4009: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcb72000  ! 4010: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xdcaf2000  ! 4011: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xd4bdc4a0  ! 4012: STDA_R	stda	%r10, [%r23 + %r0] 0x25
	.word 0x87802025  ! 4013: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a5a000  ! 4014: STWA_I	stwa	%r11, [%r22 + 0x0000] %asi
	.word 0xd8b7ce40  ! 4015: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0xd6dc8400  ! 4016: LDXA_R	ldxa	[%r18, %r0] 0x20, %r11
	.word 0x87802073  ! 4017: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xded6e000  ! 4018: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r15
	.word 0xd0cd04a0  ! 4019: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r8
	mov	0x3f0, %r20
	.word 0xd686e000  ! 4021: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r11
	.word 0xd8f78e60  ! 4022: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	.word 0x87802074  ! 4023: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r18
	.word 0xd2c76000  ! 4025: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0xdc9cc400  ! 4026: LDDA_R	ldda	[%r19, %r0] 0x20, %r14
	.word 0xdc972000  ! 4027: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	.word 0xdcafe000  ! 4028: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdcc7e000  ! 4029: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	mov	0x8, %r18
	.word 0x87802072  ! 4031: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r18
	.word 0xd4a6c9e0  ! 4033: STWA_R	stwa	%r10, [%r27 + %r0] 0x4f
	.word 0xdcad44a0  ! 4034: STBA_R	stba	%r14, [%r21 + %r0] 0x25
	mov	0x58, %r26
	.word 0xdac5a000  ! 4036: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r13
	.word 0xdaf44400  ! 4037: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0xd29f8e40  ! 4038: LDDA_R	ldda	[%r30, %r0] 0x72, %r9
	.word 0xd4978e40  ! 4039: LDUHA_R	lduha	[%r30, %r0] 0x72, %r10
	.word 0xdc970e40  ! 4040: LDUHA_R	lduha	[%r28, %r0] 0x72, %r14
	mov	0x3d0, %r21
	mov	0x58, %r25
	.word 0xd297ce80  ! 4043: LDUHA_R	lduha	[%r31, %r0] 0x74, %r9
	.word 0xda9649e0  ! 4044: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r13
	.word 0xda856000  ! 4045: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r13
	.word 0xdcafce60  ! 4046: STBA_R	stba	%r14, [%r31 + %r0] 0x73
	.word 0xdcce89e0  ! 4047: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r14
	mov	0x3d0, %r20
	.word 0xdaad2000  ! 4049: STBA_I	stba	%r13, [%r20 + 0x0000] %asi
	.word 0xdaad2000  ! 4050: STBA_I	stba	%r13, [%r20 + 0x0000] %asi
	.word 0xdaa5e000  ! 4051: STWA_I	stwa	%r13, [%r23 + 0x0000] %asi
	.word 0xd4ae89e0  ! 4052: STBA_R	stba	%r10, [%r26 + %r0] 0x4f
	mov	0x7f0, %r22
	.word 0xd8cd6000  ! 4054: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r12
	.word 0x87802025  ! 4055: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8df6000  ! 4056: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	mov	0x0, %r25
	.word 0x87802074  ! 4058: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8be6000  ! 4059: STDA_I	stda	%r12, [%r25 + 0x0000] %asi
	mov	0x20, %r27
	.word 0xd8d6a000  ! 4061: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r12
	.word 0xd8b70e80  ! 4062: STHA_R	stha	%r12, [%r28 + %r0] 0x74
	.word 0xd68e89e0  ! 4063: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r11
	.word 0x8780204f  ! 4064: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f8, %r21
	.word 0xdebee000  ! 4066: STDA_I	stda	%r15, [%r27 + 0x0000] %asi
	.word 0x87802073  ! 4067: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r25
	.word 0xd0bfce80  ! 4069: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	.word 0xdcf70e80  ! 4070: STXA_R	stxa	%r14, [%r28 + %r0] 0x74
	mov	0x38, %r25
	.word 0xdccfce40  ! 4072: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r14
	mov	0x30, %r18
	.word 0x87802020  ! 4074: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef609e0  ! 4075: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	.word 0x87802074  ! 4076: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdedd6000  ! 4077: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r15
	.word 0xd097ce60  ! 4078: LDUHA_R	lduha	[%r31, %r0] 0x73, %r8
	.word 0xd2cda000  ! 4079: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r9
	.word 0xd28da000  ! 4080: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r9
	.word 0xd48fce80  ! 4081: LDUBA_R	lduba	[%r31, %r0] 0x74, %r10
	mov	0x10, %r19
	mov	0x7d8, %r22
	.word 0xd6c70e80  ! 4084: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r11
	.word 0xd4856000  ! 4085: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r10
	.word 0xd6970e40  ! 4086: LDUHA_R	lduha	[%r28, %r0] 0x72, %r11
	.word 0xde8da000  ! 4087: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r15
	.word 0x87802072  ! 4088: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r19
	.word 0x87802073  ! 4090: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb4e000  ! 4091: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x20, %r19
	.word 0xdeac6000  ! 4094: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 4095: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcb544a0  ! 4096: STHA_R	stha	%r14, [%r21 + %r0] 0x25
	mov	0x20, %r24
	mov	0x68, %r25
	mov	0x30, %r24
	.word 0xd2b584a0  ! 4100: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0xd6d56000  ! 4101: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r11
	.word 0xd6b52000  ! 4102: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	.word 0xd4af0e60  ! 4103: STBA_R	stba	%r10, [%r28 + %r0] 0x73
	.word 0xdab7ce40  ! 4104: STHA_R	stha	%r13, [%r31 + %r0] 0x72
	.word 0xd095a000  ! 4105: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r8
	.word 0xdcf4c400  ! 4106: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	mov	0x70, %r16
	.word 0xdcdf4e60  ! 4108: LDXA_R	ldxa	[%r29, %r0] 0x73, %r14
	.word 0xdab5e000  ! 4109: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0xd49cc400  ! 4110: LDDA_R	ldda	[%r19, %r0] 0x20, %r10
	.word 0xd0ac8400  ! 4111: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	mov	0x7c8, %r20
	.word 0x87802073  ! 4113: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4114: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab74e40  ! 4115: STHA_R	stha	%r13, [%r29 + %r0] 0x72
	.word 0xd8d48400  ! 4116: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0xd8cfce40  ! 4117: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r12
	.word 0xd0c6c9e0  ! 4118: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r8
	.word 0xd6b42000  ! 4119: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0xd4ce49e0  ! 4120: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r10
	.word 0xd8dfce80  ! 4121: LDXA_R	ldxa	[%r31, %r0] 0x74, %r12
	mov	0x10, %r19
	.word 0xd6b4e000  ! 4123: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xd0840400  ! 4124: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	mov	0x7f0, %r20
	mov	0x0, %r17
	mov	0x60, %r19
	mov	0x20, %r25
	.word 0x87802020  ! 4129: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r18
	.word 0xd89d44a0  ! 4131: LDDA_R	ldda	[%r21, %r0] 0x25, %r12
	mov	0x0, %r18
	.word 0x87802072  ! 4133: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4134: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r25
	.word 0xd48de000  ! 4136: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r10
	mov	0x70, %r27
	.word 0x87802020  ! 4138: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r21
	.word 0xd2cf8e60  ! 4140: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r9
	.word 0xd8a70e40  ! 4141: STWA_R	stwa	%r12, [%r28 + %r0] 0x72
	.word 0xdaa584a0  ! 4142: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	mov	0x10, %r24
	.word 0xd29f8e40  ! 4144: LDDA_R	ldda	[%r30, %r0] 0x72, %r9
	.word 0xd2b48400  ! 4145: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	mov	0x8, %r24
	.word 0xdeafa000  ! 4147: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	mov	0x40, %r24
	.word 0xde8fe000  ! 4149: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0xde8f2000  ! 4150: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xdea72000  ! 4151: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xde97a000  ! 4152: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	.word 0x87802074  ! 4153: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 4154: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 4155: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde9c6000  ! 4156: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0xdcb78e40  ! 4157: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xd0d4e000  ! 4158: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	.word 0xd4afce80  ! 4159: STBA_R	stba	%r10, [%r31 + %r0] 0x74
	.word 0x87802025  ! 4160: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a40400  ! 4161: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	mov	0x40, %r17
	.word 0xd0cf4e80  ! 4163: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r8
	.word 0xdcbf6000  ! 4164: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xda878e40  ! 4165: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r13
	mov	0x0, %r26
	.word 0x8780204f  ! 4167: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6a6e000  ! 4168: STWA_I	stwa	%r11, [%r27 + 0x0000] %asi
	mov	0x3f0, %r23
	.word 0xd8ad44a0  ! 4170: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	.word 0xd4d6a000  ! 4171: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r10
	.word 0xd4a44400  ! 4172: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xd8d504a0  ! 4173: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r12
	.word 0xdec48400  ! 4174: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	.word 0xd6dec9e0  ! 4175: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r11
	.word 0xd486e000  ! 4176: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	.word 0xd8f40400  ! 4177: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xd2be2000  ! 4178: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	.word 0xd4f504a0  ! 4179: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0xdecc8400  ! 4180: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	.word 0xdad6a000  ! 4181: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r13
	.word 0x87802072  ! 4182: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebf8e40  ! 4183: STDA_R	stda	%r15, [%r30 + %r0] 0x72
	.word 0xd8f44400  ! 4184: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xde874e60  ! 4185: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r15
	.word 0xd2f7a000  ! 4186: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xda8d04a0  ! 4187: LDUBA_R	lduba	[%r20, %r0] 0x25, %r13
	.word 0xd0cf0e40  ! 4188: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r8
	.word 0xd097ce40  ! 4189: LDUHA_R	lduha	[%r31, %r0] 0x72, %r8
	mov	0x3e8, %r21
	.word 0xd4bf2000  ! 4191: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd8cc0400  ! 4192: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	mov	0x70, %r19
	mov	0x20, %r18
	.word 0xd2bf6000  ! 4195: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xdeb48400  ! 4196: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0x87802025  ! 4197: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 4198: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde94a000  ! 4199: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0xde8c2000  ! 4200: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	.word 0xd2f40400  ! 4201: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xdca4a000  ! 4202: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 4203: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcc5a000  ! 4204: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r14
	.word 0xdcada000  ! 4205: STBA_I	stba	%r14, [%r22 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xd0a70e40  ! 4207: STWA_R	stwa	%r8, [%r28 + %r0] 0x72
	.word 0xd8cda000  ! 4208: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r12
	.word 0xd8f5a000  ! 4209: STXA_I	stxa	%r12, [%r22 + 0x0000] %asi
	.word 0xd8a5e000  ! 4210: STWA_I	stwa	%r12, [%r23 + 0x0000] %asi
	mov	0x3e0, %r22
	mov	0x20, %r27
	mov	0x50, %r17
	.word 0xd4c70e60  ! 4214: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r10
	mov	0x70, %r26
	.word 0xdeb56000  ! 4216: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	mov	0x68, %r19
	.word 0xd6cf4e80  ! 4218: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r11
	mov	0x28, %r18
	.word 0xd6bf8e60  ! 4220: STDA_R	stda	%r11, [%r30 + %r0] 0x73
	mov	0x30, %r25
	.word 0x87802074  ! 4222: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6cf2000  ! 4223: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0xd4cd44a0  ! 4224: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r10
	.word 0xda9609e0  ! 4225: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r13
	.word 0x87802020  ! 4226: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r24
	.word 0xd0bfe000  ! 4228: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xdcd74e40  ! 4229: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r14
	mov	0x40, %r19
	.word 0x87802072  ! 4231: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7c8, %r23
	.word 0x87802074  ! 4233: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c8, %r22
	mov	0x7f8, %r21
	mov	0x30, %r25
	.word 0xd8dc6000  ! 4237: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	mov	0x20, %r24
	mov	0x40, %r27
	.word 0xd8d46000  ! 4240: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	.word 0xd8d42000  ! 4241: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0xd8d4a000  ! 4242: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	mov	0x70, %r18
	mov	0x18, %r25
	.word 0x87802073  ! 4245: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0f689e0  ! 4246: STXA_R	stxa	%r8, [%r26 + %r0] 0x4f
	.word 0xd0dfe000  ! 4247: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xdc8609e0  ! 4248: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r14
	.word 0x87802020  ! 4249: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc842000  ! 4250: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	mov	0x10, %r16
	mov	0x8, %r24
	.word 0xd2bc0400  ! 4253: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0x87802072  ! 4254: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 4255: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 4256: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf72000  ! 4257: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcbfe000  ! 4258: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0x87802073  ! 4260: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 4261: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6840400  ! 4262: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0x87802072  ! 4263: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r26
	.word 0xd2f46000  ! 4265: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2942000  ! 4266: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2d46000  ! 4267: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	.word 0x87802025  ! 4268: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e8, %r21
	.word 0xd2b6a000  ! 4270: STHA_I	stha	%r9, [%r26 + 0x0000] %asi
	.word 0x87802025  ! 4271: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad44400  ! 4272: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0xd29fce80  ! 4273: LDDA_R	ldda	[%r31, %r0] 0x74, %r9
	mov	0x18, %r24
	mov	0x68, %r24
	.word 0x87802073  ! 4276: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f0, %r23
	.word 0xd09f2000  ! 4278: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0xd6d649e0  ! 4279: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r11
	.word 0xd8b76000  ! 4280: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd8cfa000  ! 4281: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd8f7e000  ! 4282: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xded40400  ! 4283: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	.word 0xdac7e000  ! 4284: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xd8bec9e0  ! 4285: STDA_R	stda	%r12, [%r27 + %r0] 0x4f
	mov	0x8, %r26
	.word 0xdeb72000  ! 4287: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xd6c6c9e0  ! 4288: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r11
	.word 0xd2ad84a0  ! 4289: STBA_R	stba	%r9, [%r22 + %r0] 0x25
	.word 0xda9fe000  ! 4290: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	mov	0x7c8, %r23
	mov	0x40, %r18
	.word 0x87802074  ! 4293: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r25
	.word 0xdc8f8e40  ! 4295: LDUBA_R	lduba	[%r30, %r0] 0x72, %r14
	.word 0xdeb74e40  ! 4296: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	mov	0x0, %r16
	.word 0xd897e000  ! 4298: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	mov	0x78, %r18
	mov	0x40, %r25
	.word 0xd8bfce60  ! 4301: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 4302: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a5a000  ! 4303: STWA_I	stwa	%r8, [%r22 + 0x0000] %asi
	.word 0xd0bd2000  ! 4304: STDA_I	stda	%r8, [%r20 + 0x0000] %asi
	.word 0xd0bda000  ! 4305: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	.word 0xd0bd6000  ! 4306: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0x87802073  ! 4307: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8df4e80  ! 4308: LDXA_R	ldxa	[%r29, %r0] 0x74, %r12
	mov	0x30, %r18
	mov	0x18, %r16
	.word 0xd8b48400  ! 4311: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0xdeacc400  ! 4312: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xdcf5a000  ! 4313: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 4314: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2dfce80  ! 4315: LDXA_R	ldxa	[%r31, %r0] 0x74, %r9
	.word 0xdcb5a000  ! 4316: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 4317: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r24
	.word 0xdcde2000  ! 4319: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r14
	.word 0xde9d84a0  ! 4320: LDDA_R	ldda	[%r22, %r0] 0x25, %r15
	.word 0x87802020  ! 4321: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r18
	.word 0xd4870e60  ! 4323: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r10
	.word 0x87802020  ! 4324: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8940400  ! 4325: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	.word 0xda9f6000  ! 4326: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xdaa7e000  ! 4327: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	mov	0x3d8, %r22
	.word 0xdecfce60  ! 4329: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r15
	.word 0x8780204f  ! 4330: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 4331: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r17
	.word 0xd2a7a000  ! 4333: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xd2a609e0  ! 4334: STWA_R	stwa	%r9, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 4335: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde848400  ! 4336: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	.word 0x87802025  ! 4337: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r16
	.word 0xdc9fa000  ! 4339: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0xdc8fa000  ! 4340: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	mov	0x20, %r19
	.word 0x87802020  ! 4342: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdc2000  ! 4343: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r14
	.word 0xdcd42000  ! 4344: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4345: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ad84a0  ! 4346: STBA_R	stba	%r9, [%r22 + %r0] 0x25
	mov	0x7e8, %r23
	.word 0xd6a4e000  ! 4348: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0xd0de09e0  ! 4349: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r8
	mov	0x60, %r17
	.word 0xd0bc6000  ! 4351: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	mov	0x3c8, %r20
	.word 0xd8be89e0  ! 4353: STDA_R	stda	%r12, [%r26 + %r0] 0x4f
	.word 0xdca74e40  ! 4354: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	.word 0x87802020  ! 4355: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8ec9e0  ! 4356: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r15
	mov	0x38, %r27
	mov	0x68, %r26
	.word 0xdc84e000  ! 4359: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r14
	.word 0xd2ad04a0  ! 4360: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	.word 0xdebca000  ! 4361: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0x8780