// Modified by Princeton University on June 9th, 2015
/*
* ========== Copyright Header Begin ==========================================
* 
* OpenSPARC T1 Processor File: tlu_asi_access_mt_2_rand_24_s2.s
* Copyright (c) 2006 Sun Microsystems, Inc.  All Rights Reserved.
* DO NOT ALTER OR REMOVE COPYRIGHT NOTICES.
* 
* The above named program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License version 2 as published by the Free Software Foundation.
* 
* The above named program is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
* 
* You should have received a copy of the GNU General Public
* License along with this work; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
* 
* ========== Copyright Header End ============================================
*/
/*
********************************************************************************
   random seed:	553298323
   Jal tlu_asi_access_mt_2.j:	
********************************************************************************/



#define PCONTEXT	0x10
#define SCONTEXT	0x10

#define MAIN_PAGE_NUCLEUS_ALSO
#define MAIN_PAGE_HV_ALSO

#define ALL_MY_INTR_HANDLERS
#include "my_intr_handlers.s"
#include "my_trap_handlers.s"
#include "tlu_custom_trap_handlers.s"

#include "enable_traps.h"
#include "boot.s"

.text
.global main

main:

	ta 	%icc, T_CHANGE_HPRIV
	mov	0x123, %g1
	wr	%g0, 0x20, %asi
	stxa	%g1, [0x00] %asi
	stxa	%g1, [0x08] %asi
	stxa	%g1, [0x10] %asi
	stxa	%g1, [0x18] %asi
	stxa	%g1, [0x20] %asi
	stxa	%g1, [0x28] %asi
	stxa	%g1, [0x30] %asi
	stxa	%g1, [0x38] %asi
	ta 	%icc, T_CHANGE_NONHPRIV

! Register init code

	setx 0x9d87585b0000e2aa, %g1, %g0
	setx 0x10e5ef95000000b7, %g1, %g1
	setx 0x909de2a500002039, %g1, %g2
	setx 0x5ec99d4800004351, %g1, %g3
	setx 0x41246fd6000023cf, %g1, %g4
	setx 0x8fa28b3a00000212, %g1, %g5
	setx 0xf320097e0000a0b3, %g1, %g6
	setx 0x3dbea1e30000c008, %g1, %g7
	setx 0x222d935b0000833f, %g1, %r16
	setx 0xcf5ee05f0000c126, %g1, %r17
	setx 0xe78a2e110000c2c5, %g1, %r18
	setx 0x6d7468090000a0cb, %g1, %r19
	setx 0xd47759760000a079, %g1, %r20
	setx 0x1638486800000184, %g1, %r21
	setx 0x77cf5d7c0000036b, %g1, %r22
	setx 0x3cf9a58a000002e1, %g1, %r23
	setx 0x1d3650810000630b, %g1, %r24
	setx 0x9022c7fe000043d0, %g1, %r25
	setx 0x0e0712ff0000e1ea, %g1, %r26
	setx 0xdc34b4bc00000334, %g1, %r27
	setx 0x07fd2c79000000c9, %g1, %r28
	setx 0x5ac9b523000061e3, %g1, %r29
	setx 0x7e3f9afe0000c1d8, %g1, %r30
	setx 0x12330fd80000a0aa, %g1, %r31
	save
	setx 0x663a22790000c297, %g1, %r16
	setx 0x83c82e580000011e, %g1, %r17
	setx 0x94d243740000a02d, %g1, %r18
	setx 0xb7851a070000000a, %g1, %r19
	setx 0x3728357300004183, %g1, %r20
	setx 0x4f864d4c000062bc, %g1, %r21
	setx 0x6fae3ded0000c11f, %g1, %r22
	setx 0x39568a3b00008214, %g1, %r23
	setx 0x6b755eb90000e147, %g1, %r24
	setx 0x5001609d000040d8, %g1, %r25
	setx 0x5f3452a6000023a9, %g1, %r26
	setx 0x57fb82cc0000a118, %g1, %r27
	setx 0x936cd9fb0000a126, %g1, %r28
	setx 0xf51a5e2f000083d0, %g1, %r29
	setx 0xf78b2c1500002223, %g1, %r30
	setx 0x840038c90000e1ce, %g1, %r31
	save
	setx 0x3576d0d1000063d9, %g1, %r16
	setx 0x6cded103000003e2, %g1, %r17
	setx 0x00770d5600000135, %g1, %r18
	setx 0x669fb0820000836c, %g1, %r19
	setx 0x018f74ff0000a075, %g1, %r20
	setx 0xff33249a0000a030, %g1, %r21
	setx 0x5961b4fa00008183, %g1, %r22
	setx 0x8d6e0775000043be, %g1, %r23
	setx 0x50feaeaf0000c29c, %g1, %r24
	setx 0xea2555520000a133, %g1, %r25
	setx 0x0270d6880000e2e4, %g1, %r26
	setx 0x1098ce60000041e5, %g1, %r27
	setx 0xd311383c000063b3, %g1, %r28
	setx 0x1e6c5e3d00004221, %g1, %r29
	setx 0xd77a95470000c19a, %g1, %r30
	setx 0x85673fb8000041ac, %g1, %r31
	restore
#ifdef PORTABLE_CORE
	mov	PORTABLE_CORE, %g1
	sllx	%g1, 10, %g1
	or	%r8, %g1, %r8
	or	%r9, %g1, %r9
	or	%r10, %g1, %r10
	or	%r11, %g1, %r11
	or	%r12, %g1, %r12
	or	%r13, %g1, %r13
	or	%r14, %g1, %r14
	or	%r15, %g1, %r15
#endif
	mov	0x70, %r16
	mov	0x28, %r17
	mov	0x28, %r18
	mov	0x58, %r19
	mov	0x3f0, %r20
	mov	0x7f8, %r21
	mov	0x3c8, %r22
	mov	0x7c0, %r23
	mov	0x58, %r24
	mov	0x38, %r25
	mov	0x50, %r26
	mov	0x78, %r27
	mov	0, %r28
	mov	0, %r29
	mov	0, %r30
	mov	0, %r31
	ta	%icc, T_CHANGE_HPRIV
	wr	%g0, 0x4f, %asi
	stxa	%g0, [%g0] 0x42
	mov	0x38, %g1
	stxa	%g0, [%g1] 0x58
	ta	%icc, T_RD_THID
! fork: source strm = 0xffffffff; target strm = 0x2
	cmp	%o1, 1
	setx	fork_lbl_0_1, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x4
	cmp	%o1, 2
	setx	fork_lbl_0_2, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x8
	cmp	%o1, 3
	setx	fork_lbl_0_3, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
	mov	0x70, %r25
	mov	0x60, %r24
	.word 0xd49f0e80  ! 3: LDDA_R	ldda	[%r28, %r0] 0x74, %r10
	.word 0x87802072  ! 4: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r27
	mov	0x8, %r19
	.word 0x87802020  ! 7: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r22
	.word 0xdecf0e80  ! 9: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r15
	.word 0xdedca000  ! 10: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xd48f8e40  ! 11: LDUBA_R	lduba	[%r30, %r0] 0x72, %r10
	mov	0x30, %r18
	.word 0xd0f689e0  ! 13: STXA_R	stxa	%r8, [%r26 + %r0] 0x4f
	.word 0xd0ac6000  ! 14: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0xd29c0400  ! 15: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	.word 0x87802073  ! 16: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r16
	.word 0xd49fce40  ! 18: LDDA_R	ldda	[%r31, %r0] 0x72, %r10
	.word 0x87802025  ! 19: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0d5c4a0  ! 20: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r8
	.word 0xd0b56000  ! 21: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	.word 0xd4f74e80  ! 22: STXA_R	stxa	%r10, [%r29 + %r0] 0x74
	.word 0xd4f56000  ! 23: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	.word 0xd4a5a000  ! 24: STWA_I	stwa	%r10, [%r22 + 0x0000] %asi
	.word 0x87802074  ! 25: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b7e000  ! 26: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	mov	0x8, %r16
	.word 0xd6f44400  ! 28: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0xd6f7a000  ! 29: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd8de89e0  ! 30: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r12
	.word 0xd887a000  ! 31: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xd484c400  ! 32: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	.word 0xdef609e0  ! 33: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	.word 0xdedf2000  ! 34: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xd4df8e40  ! 35: LDXA_R	ldxa	[%r30, %r0] 0x72, %r10
	mov	0x10, %r17
	.word 0xd4976000  ! 37: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r10
	.word 0xd49fe000  ! 38: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd4a7a000  ! 39: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	mov	0x28, %r17
	.word 0xdcd5c4a0  ! 41: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r14
	.word 0xd4c74e40  ! 42: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r10
	.word 0xd48f2000  ! 43: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0x87802020  ! 44: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r23
	.word 0xd49c6000  ! 46: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0xd4b42000  ! 47: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	.word 0xd2d689e0  ! 48: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r9
	mov	0x3d0, %r23
	.word 0xd28ce000  ! 50: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	.word 0xd8b40400  ! 51: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	mov	0x38, %r17
	.word 0xd0d70e40  ! 53: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r8
	.word 0xd4dcc400  ! 54: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	mov	0x7f0, %r23
	wr_tick_cmpr_0_0:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x97, %g2
	or	%g4, 0xad, %g4
	or	%g6, 0xd9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	wr_tick_cmpr_0_1:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb1, %g2
	or	%g4, 0x9a, %g4
	or	%g6, 0xa7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802025  ! 58: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4d5e000  ! 59: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r10
	.word 0xd4ada000  ! 60: STBA_I	stba	%r10, [%r22 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0xde9f0e40  ! 62: LDDA_R	ldda	[%r28, %r0] 0x72, %r15
	.word 0xd0dcc400  ! 63: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0xd0b52000  ! 64: STHA_I	stha	%r8, [%r20 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xd0bd6000  ! 66: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0x87802072  ! 67: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdad7ce80  ! 68: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r13
	.word 0xd4cc8400  ! 69: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	ta	T_CHANGE_PRIV	! macro
	.word 0x8780204f  ! 71: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4aee000  ! 72: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	.word 0xd48ea000  ! 73: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r10
	.word 0x87802072  ! 74: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cfa000  ! 75: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	mov	0x3d8, %r22
	.word 0xd8b48400  ! 77: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0xdcac8400  ! 78: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xd6a78e40  ! 79: STWA_R	stwa	%r11, [%r30 + %r0] 0x72
	.word 0xd6872000  ! 80: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0x87802020  ! 81: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda87ce80  ! 82: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r13
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x8780204f  ! 84: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda962000  ! 85: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r13
	.word 0xd8f48400  ! 86: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	mov	0x7c8, %r22
	mov	0x0, %r25
	.word 0x87802073  ! 89: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f7a000  ! 90: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xdcb48400  ! 91: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xd6a4c400  ! 92: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0xd6c7e000  ! 93: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 94: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 95: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09c8400  ! 96: LDDA_R	ldda	[%r18, %r0] 0x20, %r8
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0cca000  ! 98: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	.word 0xd0cec9e0  ! 99: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r8
	.word 0xd0d4e000  ! 100: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	mov	0x60, %r25
	.word 0x87802020  ! 102: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcce89e0  ! 103: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r14
	.word 0xd8de89e0  ! 104: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r12
	.word 0xdc8f4e80  ! 105: LDUBA_R	lduba	[%r29, %r0] 0x74, %r14
	.word 0xdc84a000  ! 106: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	mov	0x70, %r17
	.word 0xdcbc6000  ! 108: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 109: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaddc4a0  ! 110: LDXA_R	ldxa	[%r23, %r0] 0x25, %r13
	mov	0x28, %r17
	.word 0x87802020  ! 112: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad42000  ! 113: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r13
	.word 0xd0ac0400  ! 114: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	.word 0x87802072  ! 115: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdea44400  ! 116: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0x87802020  ! 117: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebc6000  ! 118: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xd0b7ce80  ! 119: STHA_R	stha	%r8, [%r31 + %r0] 0x74
	mov	0x0, %r25
	.word 0xdcaf8e80  ! 121: STBA_R	stba	%r14, [%r30 + %r0] 0x74
	.word 0xdcbc6000  ! 122: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 123: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r17
	.word 0xdcdda000  ! 125: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r14
	mov	0x38, %r25
	.word 0xd6d4c400  ! 127: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	.word 0x87802020  ! 128: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4974e40  ! 129: LDUHA_R	lduha	[%r29, %r0] 0x72, %r10
	.word 0xd4a42000  ! 130: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	mov	0x68, %r19
	.word 0xd2f609e0  ! 132: STXA_R	stxa	%r9, [%r24 + %r0] 0x4f
	mov	0x70, %r19
	.word 0xd2cca000  ! 134: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	mov	0x7c8, %r23
	.word 0xd28c6000  ! 136: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0xdabd44a0  ! 137: STDA_R	stda	%r13, [%r21 + %r0] 0x25
	.word 0xdab42000  ! 138: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xdab4a000  ! 140: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0xd2f78e40  ! 141: STXA_R	stxa	%r9, [%r30 + %r0] 0x72
	.word 0xd2f42000  ! 142: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 143: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 144: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cca000  ! 145: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	.word 0xdcdcc400  ! 146: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	.word 0xdca46000  ! 147: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 148: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcac6000  ! 149: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xdec6c9e0  ! 151: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r15
	.word 0x87802020  ! 152: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8d84a0  ! 153: LDUBA_R	lduba	[%r22, %r0] 0x25, %r13
	.word 0xdab46000  ! 154: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0xdabca000  ! 155: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdaa42000  ! 156: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0xd28f4e40  ! 157: LDUBA_R	lduba	[%r29, %r0] 0x72, %r9
	.word 0xd2ac2000  ! 158: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xda9f0e60  ! 159: LDDA_R	ldda	[%r28, %r0] 0x73, %r13
	.word 0xd4acc400  ! 160: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xd0d5c4a0  ! 161: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r8
	.word 0xd0cc6000  ! 162: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	.word 0xd0846000  ! 163: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0xd0946000  ! 164: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0xd4df8e80  ! 165: LDXA_R	ldxa	[%r30, %r0] 0x74, %r10
	.word 0x87802025  ! 166: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f5c4a0  ! 167: STXA_R	stxa	%r11, [%r23 + %r0] 0x25
	.word 0xd68d6000  ! 168: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r11
	.word 0x87802025  ! 169: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcce49e0  ! 170: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r14
	mov	0x7e8, %r22
	.word 0x87802073  ! 172: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r26
	.word 0x87802020  ! 174: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c584a0  ! 175: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r10
	.word 0xd48c6000  ! 176: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r10
	.word 0xdac7ce60  ! 177: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r13
	.word 0x87802020  ! 178: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadca000  ! 179: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0xd28f0e60  ! 180: LDUBA_R	lduba	[%r28, %r0] 0x73, %r9
	mov	0x18, %r16
	.word 0xd2f42000  ! 182: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0xd8cec9e0  ! 183: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r12
	.word 0x87802020  ! 184: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bf0e80  ! 185: STDA_R	stda	%r11, [%r28 + %r0] 0x74
	mov	0x28, %r24
	.word 0x87802020  ! 187: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 188: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 189: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 190: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6d504a0  ! 191: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r11
	.word 0xd6f7e000  ! 192: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6df2000  ! 193: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6bf2000  ! 194: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd6bf6000  ! 195: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 196: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 197: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcd70e80  ! 198: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r14
	.word 0xdcb6e000  ! 199: STHA_I	stha	%r14, [%r27 + 0x0000] %asi
	.word 0xd2d504a0  ! 200: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r9
	mov	0x10, %r18
	.word 0xdaacc400  ! 202: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	mov	0x7f8, %r22
	mov	0x60, %r25
	.word 0x87802072  ! 205: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 206: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdad6e000  ! 207: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r13
	.word 0xdabe6000  ! 208: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	.word 0xdab6c9e0  ! 209: STHA_R	stha	%r13, [%r27 + %r0] 0x4f
	.word 0xdaaee000  ! 210: STBA_I	stba	%r13, [%r27 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xdab6e000  ! 212: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	mov	0x48, %r19
	.word 0xdebcc400  ! 214: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	.word 0xd29c4400  ! 215: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	.word 0xd8a78e60  ! 216: STWA_R	stwa	%r12, [%r30 + %r0] 0x73
	mov	0x0, %r18
	mov	0x3e0, %r22
	.word 0x87802073  ! 219: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd28f0e40  ! 220: LDUBA_R	lduba	[%r28, %r0] 0x72, %r9
	.word 0xd2d72000  ! 221: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xdc8f4e80  ! 222: LDUBA_R	lduba	[%r29, %r0] 0x74, %r14
	.word 0xdcdfe000  ! 223: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	mov	0x70, %r26
	mov	0x78, %r16
	.word 0x8780204f  ! 226: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0d40400  ! 227: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	.word 0xdca609e0  ! 228: STWA_R	stwa	%r14, [%r24 + %r0] 0x4f
	mov	0x8, %r25
	.word 0x87802020  ! 230: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcaca000  ! 231: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xd2d504a0  ! 232: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r9
	.word 0xd29f0e40  ! 233: LDDA_R	ldda	[%r28, %r0] 0x72, %r9
	.word 0xd2f4a000  ! 234: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0xdebfce40  ! 235: STDA_R	stda	%r15, [%r31 + %r0] 0x72
	.word 0x87802073  ! 236: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc8f0e40  ! 237: LDUBA_R	lduba	[%r28, %r0] 0x72, %r14
	.word 0xdcad04a0  ! 238: STBA_R	stba	%r14, [%r20 + %r0] 0x25
	.word 0xdc97e000  ! 239: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xdc9fe000  ! 240: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xdcaf6000  ! 241: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0x8780204f  ! 243: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc86a000  ! 244: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r14
	.word 0xdcf70e60  ! 245: STXA_R	stxa	%r14, [%r28 + %r0] 0x73
	.word 0x87802020  ! 246: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r25
	mov	0x3f8, %r21
	mov	0x58, %r19
	.word 0xdccca000  ! 250: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	.word 0xdaa48400  ! 251: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0x87802020  ! 252: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69d84a0  ! 253: LDDA_R	ldda	[%r22, %r0] 0x25, %r11
	.word 0xdc8689e0  ! 254: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r14
	.word 0xdc84a000  ! 255: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	mov	0x0, %r25
	mov	0x58, %r27
	.word 0xdc8c2000  ! 258: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r14
	.word 0xdcd42000  ! 259: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	.word 0xd8c78e60  ! 260: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r12
	.word 0xd8cca000  ! 261: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r12
	.word 0xdedf0e60  ! 262: LDXA_R	ldxa	[%r28, %r0] 0x73, %r15
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802025  ! 264: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdef5a000  ! 265: STXA_I	stxa	%r15, [%r22 + 0x0000] %asi
	.word 0xdec56000  ! 266: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r15
	.word 0xde952000  ! 267: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r15
	.word 0xdeb56000  ! 268: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	.word 0xd69f8e40  ! 269: LDDA_R	ldda	[%r30, %r0] 0x72, %r11
	.word 0xd6dda000  ! 270: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r11
	.word 0xd6ad6000  ! 271: STBA_I	stba	%r11, [%r21 + 0x0000] %asi
	.word 0xd6a52000  ! 272: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 273: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd69fe000  ! 274: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	mov	0x58, %r27
	.word 0x87802020  ! 276: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ac8400  ! 277: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xda870e40  ! 278: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r13
	.word 0xda84a000  ! 279: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	mov	0x48, %r18
	mov	0x0, %r16
	.word 0x87802020  ! 282: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea48400  ! 283: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xdebca000  ! 284: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xd8d48400  ! 285: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0x87802025  ! 286: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd28fce60  ! 287: LDUBA_R	lduba	[%r31, %r0] 0x73, %r9
	.word 0xdecf8e80  ! 288: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r15
	.word 0xdeafce40  ! 289: STBA_R	stba	%r15, [%r31 + %r0] 0x72
	mov	0x8, %r16
	.word 0xdea5a000  ! 291: STWA_I	stwa	%r15, [%r22 + 0x0000] %asi
	.word 0xd2bf0e80  ! 292: STDA_R	stda	%r9, [%r28 + %r0] 0x74
	.word 0xd0d70e80  ! 293: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r8
	.word 0xd2dd44a0  ! 294: LDXA_R	ldxa	[%r21, %r0] 0x25, %r9
	.word 0x87802020  ! 295: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cca000  ! 296: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	mov	0x7c0, %r20
	mov	0x58, %r19
	.word 0xd0c7ce60  ! 299: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r8
	.word 0xda97ce80  ! 300: LDUHA_R	lduha	[%r31, %r0] 0x74, %r13
	.word 0xd4b6c9e0  ! 301: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0xd49c6000  ! 302: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0x87802020  ! 303: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4aca000  ! 304: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 305: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4a76000  ! 306: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 307: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4dfe000  ! 308: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd8b48400  ! 309: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	mov	0x0, %r17
	mov	0x78, %r27
	.word 0x87802020  ! 312: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 313: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 314: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69f0e40  ! 315: LDDA_R	ldda	[%r28, %r0] 0x72, %r11
	mov	0x3c0, %r20
	wr_tick_cmpr_0_2:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xbf, %g2
	or	%g4, 0x90, %g4
	or	%g6, 0xc4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x40, %r18
	.word 0x8780204f  ! 319: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebc0400  ! 320: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	mov	0x68, %r24
	mov	0x3d8, %r21
	mov	0x3c0, %r21
	mov	0x58, %r25
	.word 0xdece2000  ! 325: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r15
	.word 0xd6944400  ! 326: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	wr_tick_cmpr_0_3:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf8, %g2
	or	%g4, 0x9d, %g4
	or	%g6, 0x91, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x58, %r17
	.word 0xd6c6a000  ! 329: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r11
	mov	0x18, %r18
	mov	0x58, %r25
	.word 0xd6d6a000  ! 332: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r11
	mov	0x30, %r17
	.word 0x87802025  ! 334: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6ad2000  ! 335: STBA_I	stba	%r11, [%r20 + 0x0000] %asi
	.word 0xdcc40400  ! 336: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	.word 0xdcd56000  ! 337: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r14
	mov	0x0, %r27
	.word 0xd4acc400  ! 339: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	mov	0x58, %r26
	.word 0x87802020  ! 341: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r16
	.word 0xd4f44400  ! 343: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0xd4f42000  ! 344: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd4b6c9e0  ! 345: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	mov	0x70, %r25
	.word 0x87802072  ! 347: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 348: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4b52000  ! 349: STHA_I	stha	%r10, [%r20 + 0x0000] %asi
	.word 0xd2bf8e40  ! 350: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	.word 0xded7ce40  ! 351: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r15
	mov	0x8, %r27
	.word 0x87802073  ! 353: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0970e40  ! 354: LDUHA_R	lduha	[%r28, %r0] 0x72, %r8
	mov	0x48, %r19
	mov	0x8, %r26
	.word 0xd0a76000  ! 357: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xdaccc400  ! 358: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r13
	.word 0xdaf7a000  ! 359: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdaafe000  ! 360: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xdc97ce60  ! 361: LDUHA_R	lduha	[%r31, %r0] 0x73, %r14
	.word 0xdcdfa000  ! 362: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	wr_tick_cmpr_0_4:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xdb, %g2
	or	%g4, 0xbc, %g4
	or	%g6, 0xe2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x18, %r19
	.word 0xdcd4c400  ! 365: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	.word 0xd2f584a0  ! 366: STXA_R	stxa	%r9, [%r22 + %r0] 0x25
	mov	0x78, %r19
	mov	0x8, %r19
	.word 0x8780204f  ! 369: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2866000  ! 370: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r9
	.word 0xd2c6a000  ! 371: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r9
	.word 0xd2962000  ! 372: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r9
	.word 0xd2dee000  ! 373: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r9
	.word 0xd2f62000  ! 374: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	mov	0x60, %r18
	.word 0xdeb7ce80  ! 376: STHA_R	stha	%r15, [%r31 + %r0] 0x74
	mov	0x28, %r18
	.word 0x87802025  ! 378: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb52000  ! 379: STHA_I	stha	%r15, [%r20 + 0x0000] %asi
	mov	0x78, %r26
	.word 0x87802025  ! 381: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8b5c4a0  ! 382: STHA_R	stha	%r12, [%r23 + %r0] 0x25
	.word 0x87802073  ! 383: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdec7ce80  ! 384: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r15
	.word 0x8780204f  ! 385: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdef689e0  ! 386: STXA_R	stxa	%r15, [%r26 + %r0] 0x4f
	.word 0xd6d4c400  ! 387: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	.word 0xd0848400  ! 388: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r8
	mov	0x38, %r24
	.word 0x87802074  ! 390: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7f8, %r21
	.word 0x87802025  ! 393: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 394: WRASI_I	wr	%r0, 0x004f, %asi
	wr_tick_cmpr_0_5:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x9c, %g2
	or	%g4, 0xc0, %g4
	or	%g6, 0xa0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0dea000  ! 396: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r8
	.word 0xd0f66000  ! 397: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	.word 0x87802072  ! 398: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r16
	mov	0x7d0, %r22
	mov	0x68, %r24
	.word 0xd4c74e80  ! 402: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r10
	.word 0xd4af2000  ! 403: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd4b72000  ! 404: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	mov	0x18, %r26
	.word 0x87802072  ! 406: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 407: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd49fe000  ! 408: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd8a48400  ! 409: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	.word 0xd8cfe000  ! 410: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8cfe000  ! 411: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	mov	0x58, %r19
	.word 0xd4bd44a0  ! 413: STDA_R	stda	%r10, [%r21 + %r0] 0x25
	.word 0xdc970e40  ! 414: LDUHA_R	lduha	[%r28, %r0] 0x72, %r14
	.word 0xdcf74e60  ! 415: STXA_R	stxa	%r14, [%r29 + %r0] 0x73
	.word 0xdef74e40  ! 416: STXA_R	stxa	%r15, [%r29 + %r0] 0x72
	mov	0x18, %r26
	.word 0xdecf6000  ! 418: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	mov	0x0, %r25
	.word 0xd2a44400  ! 420: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xd087ce60  ! 421: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r8
	.word 0x87802025  ! 422: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0c56000  ! 423: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r8
	.word 0xd0f5a000  ! 424: STXA_I	stxa	%r8, [%r22 + 0x0000] %asi
	.word 0xd0d52000  ! 425: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r8
	.word 0x87802020  ! 426: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r21
	mov	0x70, %r19
	.word 0xd69c4400  ! 429: LDDA_R	ldda	[%r17, %r0] 0x20, %r11
	mov	0x40, %r19
	.word 0xdaa649e0  ! 431: STWA_R	stwa	%r13, [%r25 + %r0] 0x4f
	.word 0xda8c6000  ! 432: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r13
	.word 0xdadc2000  ! 433: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r13
	mov	0x68, %r19
	.word 0x87802072  ! 435: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b7ce40  ! 436: STHA_R	stha	%r9, [%r31 + %r0] 0x72
	ta	T_CHANGE_NONHPRIV	! macro
	wr_tick_cmpr_0_6:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xfa, %g2
	or	%g4, 0xdb, %g4
	or	%g6, 0xf3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 439: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c46000  ! 440: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	mov	0x70, %r25
	mov	0x3e0, %r20
	.word 0xd284a000  ! 443: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	mov	0x68, %r26
	.word 0x87802073  ! 445: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2a72000  ! 446: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0xdecc8400  ! 447: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	.word 0xde84c400  ! 448: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0xdef76000  ! 449: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdedf6000  ! 450: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	mov	0x40, %r16
	.word 0x87802074  ! 452: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 453: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_0_7:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xfd, %g2
	or	%g4, 0xa0, %g4
	or	%g6, 0xb8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdef4e000  ! 455: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xde9f0e60  ! 456: LDDA_R	ldda	[%r28, %r0] 0x73, %r15
	.word 0xd4a44400  ! 457: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xd4a42000  ! 458: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	mov	0x10, %r19
	.word 0xd4d42000  ! 460: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	.word 0x87802074  ! 461: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf48400  ! 462: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	wr_tick_cmpr_0_8:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x8d, %g2
	or	%g4, 0xdf, %g4
	or	%g6, 0xd1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x60, %r18
	.word 0x87802020  ! 465: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6be09e0  ! 466: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	.word 0xd6a4e000  ! 467: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 468: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c8, %r21
	.word 0xd2a609e0  ! 470: STWA_R	stwa	%r9, [%r24 + %r0] 0x4f
	.word 0xd2d66000  ! 471: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r9
	.word 0x87802072  ! 472: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 473: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad6c9e0  ! 474: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r13
	.word 0xd6f70e80  ! 475: STXA_R	stxa	%r11, [%r28 + %r0] 0x74
	.word 0x87802072  ! 476: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6cf6000  ! 477: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	mov	0x48, %r18
	.word 0xd68f2000  ! 479: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xd6976000  ! 480: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	mov	0x10, %r16
	.word 0xd6b76000  ! 482: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 483: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a42000  ! 484: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xd6adc4a0  ! 485: STBA_R	stba	%r11, [%r23 + %r0] 0x25
	mov	0x28, %r17
	mov	0x30, %r16
	.word 0xd8a689e0  ! 488: STWA_R	stwa	%r12, [%r26 + %r0] 0x4f
	.word 0xd28c0400  ! 489: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	wr_tick_cmpr_0_9:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb9, %g2
	or	%g4, 0xc3, %g4
	or	%g6, 0xdb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd6ac4400  ! 491: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	mov	0x68, %r19
	mov	0x8, %r16
	.word 0x87802072  ! 494: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd687a000  ! 495: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6b76000  ! 496: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd08f0e60  ! 497: LDUBA_R	lduba	[%r28, %r0] 0x73, %r8
	.word 0xd085c4a0  ! 498: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r8
	mov	0x3f0, %r21
	.word 0x87802020  ! 500: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 501: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0872000  ! 502: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xd8d504a0  ! 503: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r12
	mov	0x7c0, %r23
	.word 0xdcb7ce60  ! 505: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	.word 0xdcaf6000  ! 506: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdcf7e000  ! 507: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xdccfa000  ! 509: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	mov	0x3d0, %r21
	.word 0xdcd72000  ! 511: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xdcf7a000  ! 512: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcd76000  ! 513: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	mov	0x58, %r24
	.word 0xdca7a000  ! 515: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdc8fa000  ! 516: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	mov	0x30, %r19
	.word 0xdcb72000  ! 518: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 519: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcd42000  ! 520: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	.word 0xdcb4a000  ! 521: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xd89d04a0  ! 522: LDDA_R	ldda	[%r20, %r0] 0x25, %r12
	.word 0xd0f7ce80  ! 523: STXA_R	stxa	%r8, [%r31 + %r0] 0x74
	.word 0xd4dec9e0  ! 524: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r10
	.word 0xd4f4e000  ! 525: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xd6874e60  ! 527: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r11
	.word 0xdaae09e0  ! 528: STBA_R	stba	%r13, [%r24 + %r0] 0x4f
	.word 0xdacc2000  ! 529: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xdadca000  ! 530: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0xd08f8e80  ! 531: LDUBA_R	lduba	[%r30, %r0] 0x74, %r8
	wr_tick_cmpr_0_10:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb2, %g2
	or	%g4, 0xf1, %g4
	or	%g6, 0x88, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3d8, %r22
	.word 0xdaaf4e40  ! 534: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	.word 0xdaa46000  ! 535: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	.word 0xd2a40400  ! 536: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xd2dce000  ! 537: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r9
	.word 0x87802072  ! 538: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f72000  ! 539: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	mov	0x28, %r19
	mov	0x68, %r16
	.word 0xd2df6000  ! 542: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0xd6bdc4a0  ! 543: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	mov	0x0, %r27
	.word 0xd69f2000  ! 545: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xd2dfce60  ! 546: LDXA_R	ldxa	[%r31, %r0] 0x73, %r9
	.word 0xdc974e60  ! 547: LDUHA_R	lduha	[%r29, %r0] 0x73, %r14
	.word 0xd2ae49e0  ! 548: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	.word 0xdabf8e60  ! 549: STDA_R	stda	%r13, [%r30 + %r0] 0x73
	.word 0xd69ec9e0  ! 550: LDDA_R	ldda	[%r27, %r0] 0x4f, %r11
	.word 0x87802025  ! 551: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r17
	.word 0x87802025  ! 553: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f8, %r22
	.word 0x87802020  ! 555: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 556: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcd5c4a0  ! 557: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r14
	mov	0x70, %r18
	.word 0xdca66000  ! 559: STWA_I	stwa	%r14, [%r25 + 0x0000] %asi
	.word 0xdcc66000  ! 560: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	.word 0xd6ccc400  ! 561: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	.word 0xd4c78e40  ! 562: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r10
	.word 0xd4aee000  ! 563: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0xd4a544a0  ! 565: STWA_R	stwa	%r10, [%r21 + %r0] 0x25
	.word 0x87802025  ! 566: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 567: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4af2000  ! 568: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd0bf8e80  ! 569: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	.word 0xd48609e0  ! 570: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r10
	.word 0xd48fe000  ! 571: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xdecc8400  ! 572: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	mov	0x7d8, %r22
	.word 0xde9f2000  ! 574: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 575: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdef62000  ! 576: STXA_I	stxa	%r15, [%r24 + 0x0000] %asi
	.word 0xd6bfce80  ! 577: STDA_R	stda	%r11, [%r31 + %r0] 0x74
	.word 0xd696a000  ! 578: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r11
	.word 0xd6d66000  ! 579: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r11
	mov	0x3d8, %r21
	.word 0xd2974e60  ! 581: LDUHA_R	lduha	[%r29, %r0] 0x73, %r9
	.word 0x87802020  ! 582: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r23
	.word 0xd2dc6000  ! 584: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r9
	mov	0x7d0, %r20
	mov	0x78, %r18
	.word 0xd2a46000  ! 587: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd6be09e0  ! 588: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	.word 0xd6f42000  ! 589: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 590: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 591: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 592: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r18
	.word 0xdcae49e0  ! 594: STBA_R	stba	%r14, [%r25 + %r0] 0x4f
	.word 0xdccf6000  ! 595: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0x87802074  ! 596: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 597: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf5e000  ! 598: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xd2b7ce60  ! 600: STHA_R	stha	%r9, [%r31 + %r0] 0x73
	.word 0xdabf4e80  ! 601: STDA_R	stda	%r13, [%r29 + %r0] 0x74
	.word 0xdaada000  ! 602: STBA_I	stba	%r13, [%r22 + 0x0000] %asi
	.word 0xdadc0400  ! 603: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	.word 0xd6ac4400  ! 604: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	mov	0x18, %r17
	mov	0x0, %r26
	wr_tick_cmpr_0_11:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb5, %g2
	or	%g4, 0xe1, %g4
	or	%g6, 0x97, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x60, %r25
	.word 0x87802074  ! 609: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r16
	.word 0xd687a000  ! 611: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0xd8cf4e80  ! 612: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r12
	.word 0x8780204f  ! 613: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b6e000  ! 614: STHA_I	stha	%r12, [%r27 + 0x0000] %asi
	.word 0xd8aea000  ! 615: STBA_I	stba	%r12, [%r26 + 0x0000] %asi
	mov	0x70, %r27
	.word 0xd4d74e60  ! 617: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r10
	mov	0x28, %r19
	.word 0xd48ea000  ! 619: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r10
	mov	0x10, %r18
	.word 0xd4bcc400  ! 621: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0x87802025  ! 622: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd495e000  ! 623: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r10
	mov	0x20, %r17
	.word 0xd4b5e000  ! 625: STHA_I	stha	%r10, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 626: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r26
	.word 0xd4a7e000  ! 628: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd6840400  ! 629: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0xd6b544a0  ! 630: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	.word 0xd6afa000  ! 631: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x0, %r27
	mov	0x48, %r24
	.word 0x87802020  ! 634: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b44400  ! 635: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xdcf649e0  ! 636: STXA_R	stxa	%r14, [%r25 + %r0] 0x4f
	.word 0xdcdc6000  ! 637: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	.word 0x87802025  ! 638: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb40400  ! 639: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0x87802025  ! 640: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc9da000  ! 641: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r14
	.word 0xdc8f4e80  ! 642: LDUBA_R	lduba	[%r29, %r0] 0x74, %r14
	.word 0xd2cf8e80  ! 643: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r9
	.word 0xdca70e80  ! 644: STWA_R	stwa	%r14, [%r28 + %r0] 0x74
	.word 0x87802072  ! 645: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 646: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca42000  ! 647: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xdcdc6000  ! 649: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 650: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x48, %r24
	.word 0xd0b78e80  ! 652: STHA_R	stha	%r8, [%r30 + %r0] 0x74
	.word 0x87802025  ! 653: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c0, %r23
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0d5a000  ! 656: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r8
	.word 0xd0ad2000  ! 657: STBA_I	stba	%r8, [%r20 + 0x0000] %asi
	.word 0xda8c8400  ! 658: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	mov	0x7d0, %r21
	.word 0xdaf56000  ! 660: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	.word 0xd0a70e40  ! 661: STWA_R	stwa	%r8, [%r28 + %r0] 0x72
	.word 0xd2c74e40  ! 662: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r9
	.word 0xd2cd6000  ! 663: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r9
	.word 0xd697ce40  ! 664: LDUHA_R	lduha	[%r31, %r0] 0x72, %r11
	.word 0x87802074  ! 665: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 666: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f72000  ! 667: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0xde8fce40  ! 669: LDUBA_R	lduba	[%r31, %r0] 0x72, %r15
	.word 0xdec7e000  ! 670: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xdcaf8e40  ! 671: STBA_R	stba	%r14, [%r30 + %r0] 0x72
	.word 0xdc872000  ! 672: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	mov	0x20, %r27
	.word 0xdcbfe000  ! 674: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xd484c400  ! 675: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	mov	0x78, %r24
	.word 0xd0c609e0  ! 677: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r8
	.word 0xd2c7ce60  ! 678: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r9
	.word 0xdcd7ce80  ! 679: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r14
	.word 0xdcbf2000  ! 680: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdcc72000  ! 681: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0x87802074  ! 682: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcd78e40  ! 683: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r14
	mov	0x60, %r18
	.word 0xd8940400  ! 685: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	.word 0xd8f7e000  ! 686: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd69609e0  ! 687: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r11
	.word 0xdab609e0  ! 688: STHA_R	stha	%r13, [%r24 + %r0] 0x4f
	.word 0xdaf72000  ! 689: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	mov	0x7c8, %r23
	.word 0xd0af8e60  ! 691: STBA_R	stba	%r8, [%r30 + %r0] 0x73
	.word 0xd097e000  ! 692: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	mov	0x60, %r24
	.word 0x87802073  ! 694: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r19
	.word 0xd2c74e40  ! 696: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r9
	mov	0x38, %r17
	mov	0x40, %r17
	mov	0x68, %r16
	.word 0xd4870e40  ! 700: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r10
	.word 0xd4afa000  ! 701: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd4bfe000  ! 702: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x3c8, %r21
	mov	0x7c0, %r20
	.word 0xd4f76000  ! 705: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	mov	0x70, %r24
	.word 0xd4cf2000  ! 707: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4bf2000  ! 708: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd48f4e40  ! 709: LDUBA_R	lduba	[%r29, %r0] 0x72, %r10
	.word 0xd0970e40  ! 710: LDUHA_R	lduha	[%r28, %r0] 0x72, %r8
	.word 0xde8c4400  ! 711: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	.word 0xdec72000  ! 712: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xdedf6000  ! 713: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802074  ! 715: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde87e000  ! 716: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xded76000  ! 717: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	mov	0x3d0, %r23
	mov	0x3e8, %r23
	mov	0x58, %r24
	mov	0x7f0, %r22
	mov	0x38, %r17
	.word 0xdc840400  ! 723: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	.word 0xd4a70e60  ! 724: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	.word 0xd48f6000  ! 725: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xd4f7e000  ! 726: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	mov	0x38, %r26
	.word 0xd0a74e60  ! 728: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	.word 0xd0afe000  ! 729: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0a76000  ! 730: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0c7a000  ! 731: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xd2874e40  ! 732: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r9
	.word 0xdef78e80  ! 733: STXA_R	stxa	%r15, [%r30 + %r0] 0x74
	mov	0x60, %r27
	.word 0xd09c0400  ! 735: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	.word 0xd48e89e0  ! 736: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r10
	.word 0xdad584a0  ! 737: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r13
	.word 0xda8f2000  ! 738: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xd895c4a0  ! 739: LDUHA_R	lduha	[%r23, %r0] 0x25, %r12
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd6b70e80  ! 741: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	.word 0xdc9609e0  ! 742: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r14
	.word 0xdcc7e000  ! 743: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0xdabf0e60  ! 744: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	mov	0x28, %r27
	.word 0xdac72000  ! 746: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0xd2afce60  ! 747: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	.word 0xd2bf6000  ! 748: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 749: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29ce000  ! 750: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xd2cca000  ! 751: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	mov	0x7e8, %r20
	.word 0xdab70e40  ! 753: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	wr_tick_cmpr_0_12:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf1, %g2
	or	%g4, 0xa4, %g4
	or	%g6, 0x9c, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8944400  ! 755: LDUHA_R	lduha	[%r17, %r0] 0x20, %r12
	.word 0xd884e000  ! 756: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r12
	.word 0x87802073  ! 757: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 758: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd89ee000  ! 759: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r12
	mov	0x18, %r17
	mov	0x3c0, %r20
	.word 0x87802072  ! 762: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4ac4400  ! 763: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0x87802025  ! 764: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 765: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 766: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd49fe000  ! 767: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd4f72000  ! 768: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd0dd04a0  ! 769: LDXA_R	ldxa	[%r20, %r0] 0x25, %r8
	.word 0xdcb4c400  ! 770: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0x87802072  ! 771: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbfe000  ! 772: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xd08c0400  ! 773: LDUBA_R	lduba	[%r16, %r0] 0x20, %r8
	mov	0x7d8, %r22
	.word 0xd0b76000  ! 775: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	mov	0x28, %r24
	.word 0xd0afe000  ! 777: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0df6000  ! 778: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0x87802073  ! 779: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0bfe000  ! 780: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd2b70e80  ! 781: STHA_R	stha	%r9, [%r28 + %r0] 0x74
	mov	0x7f0, %r23
	.word 0xd2f7a000  ! 783: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xdaa40400  ! 784: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0xdaa544a0  ! 785: STWA_R	stwa	%r13, [%r21 + %r0] 0x25
	.word 0xd2af8e40  ! 786: STBA_R	stba	%r9, [%r30 + %r0] 0x72
	.word 0xd2a7a000  ! 787: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	mov	0x7f8, %r20
	mov	0x78, %r17
	.word 0xd2872000  ! 790: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 791: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf78e60  ! 792: STXA_R	stxa	%r14, [%r30 + %r0] 0x73
	.word 0xdccdc4a0  ! 793: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r14
	.word 0xdc96e000  ! 794: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r14
	.word 0xd6dfce80  ! 795: LDXA_R	ldxa	[%r31, %r0] 0x74, %r11
	.word 0xd0f6c9e0  ! 796: STXA_R	stxa	%r8, [%r27 + %r0] 0x4f
	mov	0x68, %r17
	mov	0x38, %r16
	mov	0x7f0, %r20
	mov	0x50, %r18
	mov	0x70, %r24
	.word 0xd0d6e000  ! 802: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r8
	.word 0xdc8504a0  ! 803: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r14
	mov	0x30, %r25
	.word 0x87802074  ! 805: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf76000  ! 806: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xd0974e60  ! 807: LDUHA_R	lduha	[%r29, %r0] 0x73, %r8
	.word 0xd0f76000  ! 808: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd2840400  ! 809: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r9
	.word 0xd28f6000  ! 810: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd4d4c400  ! 811: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0xd4972000  ! 812: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	mov	0x3f0, %r23
	mov	0x58, %r24
	.word 0xd4f7ce80  ! 815: STXA_R	stxa	%r10, [%r31 + %r0] 0x74
	.word 0xd4f7a000  ! 816: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd2840400  ! 817: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r9
	.word 0x87802072  ! 818: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b7a000  ! 819: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 820: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8940400  ! 821: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	.word 0xd897e000  ! 822: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	mov	0x3f8, %r22
	.word 0xd4dfce40  ! 824: LDXA_R	ldxa	[%r31, %r0] 0x72, %r10
	.word 0xd4ae49e0  ! 825: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0x87802025  ! 826: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd48d6000  ! 827: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r10
	.word 0xd4bd6000  ! 828: STDA_I	stda	%r10, [%r21 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x70, %r16
	.word 0xd49de000  ! 831: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r10
	.word 0xd4cd2000  ! 832: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r10
	.word 0xd49d2000  ! 833: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r10
	.word 0xd2f74e40  ! 834: STXA_R	stxa	%r9, [%r29 + %r0] 0x72
	.word 0xd2956000  ! 835: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r9
	mov	0x58, %r26
	.word 0xdea4c400  ! 837: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	.word 0xd0d70e60  ! 838: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r8
	.word 0xd8974e40  ! 839: LDUHA_R	lduha	[%r29, %r0] 0x72, %r12
	.word 0x87802073  ! 840: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8b7a000  ! 841: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xdab4c400  ! 842: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xdab76000  ! 843: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	mov	0x8, %r16
	.word 0x87802074  ! 845: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaafe000  ! 846: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 847: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 848: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 849: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 850: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf6e000  ! 851: STXA_I	stxa	%r13, [%r27 + 0x0000] %asi
	.word 0xdc9ec9e0  ! 852: LDDA_R	ldda	[%r27, %r0] 0x4f, %r14
	.word 0xdaac0400  ! 853: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	mov	0x70, %r18
	.word 0xdaf62000  ! 855: STXA_I	stxa	%r13, [%r24 + 0x0000] %asi
	.word 0xda966000  ! 856: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r13
	.word 0xd0b48400  ! 857: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0x87802072  ! 858: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 859: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0c76000  ! 860: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0xd6b6c9e0  ! 861: STHA_R	stha	%r11, [%r27 + %r0] 0x4f
	.word 0xd687e000  ! 862: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	mov	0x60, %r17
	.word 0xde940400  ! 864: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0xdcac0400  ! 865: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	mov	0x48, %r25
	.word 0x87802073  ! 867: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca76000  ! 868: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 869: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcac2000  ! 870: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0xdcf42000  ! 871: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	mov	0x70, %r19
	.word 0x87802020  ! 873: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcc4a000  ! 874: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r14
	.word 0xd69d04a0  ! 875: LDDA_R	ldda	[%r20, %r0] 0x25, %r11
	.word 0xd2de09e0  ! 876: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r9
	mov	0x78, %r18
	.word 0x87802025  ! 878: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeae09e0  ! 879: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	.word 0xde9d6000  ! 880: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r15
	.word 0xd6a48400  ! 881: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	mov	0x68, %r16
	.word 0x87802074  ! 883: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f72000  ! 884: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd2870e80  ! 885: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r9
	mov	0x48, %r17
	.word 0xd8a4c400  ! 887: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	mov	0x30, %r16
	.word 0xda8f0e80  ! 889: LDUBA_R	lduba	[%r28, %r0] 0x74, %r13
	mov	0x68, %r18
	.word 0xd0cd44a0  ! 891: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r8
	.word 0xd0a76000  ! 892: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0c7a000  ! 893: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0f76000  ! 894: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 895: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc9c0400  ! 896: LDDA_R	ldda	[%r16, %r0] 0x20, %r14
	.word 0x87802072  ! 897: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c8, %r20
	.word 0x87802020  ! 899: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcd42000  ! 900: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	.word 0x87802072  ! 901: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7c8, %r21
	.word 0x87802020  ! 903: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcace000  ! 904: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0xdcd46000  ! 905: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	.word 0xdcf70e40  ! 906: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	mov	0x48, %r17
	.word 0xdca42000  ! 908: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xd8dc8400  ! 909: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	mov	0x48, %r16
	.word 0xd8a4e000  ! 911: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xde978e60  ! 912: LDUHA_R	lduha	[%r30, %r0] 0x73, %r15
	mov	0x58, %r26
	.word 0xde842000  ! 914: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	.word 0xdea42000  ! 915: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xd49d44a0  ! 916: LDDA_R	ldda	[%r21, %r0] 0x25, %r10
	.word 0xd29f8e60  ! 917: LDDA_R	ldda	[%r30, %r0] 0x73, %r9
	mov	0x7f8, %r20
	.word 0xd2b4a000  ! 919: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0xd2bce000  ! 920: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 921: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2cd6000  ! 922: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r9
	.word 0xd2ad6000  ! 923: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	mov	0x7d0, %r23
	mov	0x28, %r27
	.word 0xd2f5e000  ! 926: STXA_I	stxa	%r9, [%r23 + 0x0000] %asi
	.word 0xd4b504a0  ! 927: STHA_R	stha	%r10, [%r20 + %r0] 0x25
	.word 0xd2a70e60  ! 928: STWA_R	stwa	%r9, [%r28 + %r0] 0x73
	.word 0xd2b5e000  ! 929: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	.word 0xd2bd2000  ! 930: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	mov	0x8, %r27
	.word 0xd2c5a000  ! 932: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r9
	mov	0x60, %r26
	.word 0xd2ade000  ! 934: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0xd2a5a000  ! 935: STWA_I	stwa	%r9, [%r22 + 0x0000] %asi
	mov	0x3c0, %r20
	.word 0xd2a56000  ! 937: STWA_I	stwa	%r9, [%r21 + 0x0000] %asi
	.word 0xd295e000  ! 938: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r9
	.word 0xd2b5a000  ! 939: STHA_I	stha	%r9, [%r22 + 0x0000] %asi
	.word 0xdcb44400  ! 940: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0xd6bd44a0  ! 941: STDA_R	stda	%r11, [%r21 + %r0] 0x25
	.word 0xd6dd6000  ! 942: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r11
	.word 0xd6b5e000  ! 943: STHA_I	stha	%r11, [%r23 + 0x0000] %asi
	.word 0xdcd544a0  ! 944: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r14
	mov	0x3d8, %r20
	mov	0x3e8, %r21
	.word 0xdca5e000  ! 947: STWA_I	stwa	%r14, [%r23 + 0x0000] %asi
	.word 0xdebf0e40  ! 948: STDA_R	stda	%r15, [%r28 + %r0] 0x72
	.word 0xdcb584a0  ! 949: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	.word 0xdcbde000  ! 950: STDA_I	stda	%r14, [%r23 + 0x0000] %asi
	.word 0xdc952000  ! 951: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r14
	.word 0x87802020  ! 952: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcac2000  ! 953: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdc94a000  ! 955: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xd0ddc4a0  ! 956: LDXA_R	ldxa	[%r23, %r0] 0x25, %r8
	.word 0xd094e000  ! 957: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0xd0b42000  ! 958: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	mov	0x10, %r19
	mov	0x38, %r19
	.word 0xdcbf0e40  ! 961: STDA_R	stda	%r14, [%r28 + %r0] 0x72
	.word 0xdc942000  ! 962: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	.word 0xdcf4a000  ! 963: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	mov	0x78, %r24
	.word 0x8780204f  ! 965: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2c70e60  ! 966: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r9
	mov	0x68, %r17
	.word 0x8780204f  ! 968: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r26
	.word 0xd2aee000  ! 970: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	.word 0xd2dea000  ! 971: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r9
	.word 0x87802074  ! 972: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f7a000  ! 973: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xd2afa000  ! 974: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xd2a72000  ! 975: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xdeaf4e40  ! 977: STBA_R	stba	%r15, [%r29 + %r0] 0x72
	.word 0xda8f0e40  ! 978: LDUBA_R	lduba	[%r28, %r0] 0x72, %r13
	.word 0xdaaf6000  ! 979: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xdad76000  ! 980: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0xdaf76000  ! 981: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 982: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r25
	.word 0x87802074  ! 984: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdac76000  ! 985: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0xdca48400  ! 986: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	mov	0x8, %r27
	mov	0x3f8, %r23
	mov	0x78, %r25
	.word 0xd2c5c4a0  ! 990: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r9
	.word 0xd4a78e60  ! 991: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	.word 0xd4cfe000  ! 992: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0xd4af2000  ! 993: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 994: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde9f8e60  ! 995: LDDA_R	ldda	[%r30, %r0] 0x73, %r15
	.word 0x87802072  ! 996: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xded7e000  ! 997: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0xde8fa000  ! 998: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0x87802072  ! 999: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdec72000  ! 1000: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xdeae49e0  ! 1001: STBA_R	stba	%r15, [%r25 + %r0] 0x4f
	.word 0xdeaf6000  ! 1002: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xd8bf8e60  ! 1003: STDA_R	stda	%r12, [%r30 + %r0] 0x73
	.word 0xd8ddc4a0  ! 1004: LDXA_R	ldxa	[%r23, %r0] 0x25, %r12
	mov	0x30, %r27
	.word 0xdaf7ce60  ! 1006: STXA_R	stxa	%r13, [%r31 + %r0] 0x73
	.word 0xdab7a000  ! 1007: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1008: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa4e000  ! 1009: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0xda842000  ! 1010: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r13
	.word 0x87802074  ! 1011: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdab7a000  ! 1012: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 1013: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e8, %r22
	.word 0xdcf40400  ! 1015: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 1016: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4cd84a0  ! 1017: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r10
	.word 0xde9649e0  ! 1018: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r15
	.word 0xdef6e000  ! 1019: STXA_I	stxa	%r15, [%r27 + 0x0000] %asi
	.word 0xdebe6000  ! 1020: STDA_I	stda	%r15, [%r25 + 0x0000] %asi
	.word 0xdea66000  ! 1021: STWA_I	stwa	%r15, [%r25 + 0x0000] %asi
	.word 0xde86e000  ! 1022: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r15
	.word 0xdeae2000  ! 1023: STBA_I	stba	%r15, [%r24 + 0x0000] %asi
	mov	0x8, %r19
	.word 0xde862000  ! 1025: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r15
	.word 0xd4a70e40  ! 1026: STWA_R	stwa	%r10, [%r28 + %r0] 0x72
	.word 0xd4ce6000  ! 1027: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r10
	.word 0x87802072  ! 1028: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4afa000  ! 1029: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xde97ce80  ! 1030: LDUHA_R	lduha	[%r31, %r0] 0x74, %r15
	mov	0x40, %r18
	.word 0x8780204f  ! 1032: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa4c400  ! 1033: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	mov	0x18, %r26
	.word 0xd6ae89e0  ! 1035: STBA_R	stba	%r11, [%r26 + %r0] 0x4f
	.word 0xdca70e40  ! 1036: STWA_R	stwa	%r14, [%r28 + %r0] 0x72
	mov	0x3d0, %r20
	.word 0x87802025  ! 1038: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r24
	mov	0x10, %r18
	.word 0xdc85e000  ! 1041: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r14
	.word 0xd6f74e40  ! 1042: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	wr_tick_cmpr_0_13:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xee, %g2
	or	%g4, 0xba, %g4
	or	%g6, 0xcb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x58, %r17
	.word 0xd6bde000  ! 1045: STDA_I	stda	%r11, [%r23 + 0x0000] %asi
	.word 0xd6f5e000  ! 1046: STXA_I	stxa	%r11, [%r23 + 0x0000] %asi
	.word 0xd6b56000  ! 1047: STHA_I	stha	%r11, [%r21 + 0x0000] %asi
	.word 0x87802025  ! 1048: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e8, %r22
	.word 0xd2df0e80  ! 1050: LDXA_R	ldxa	[%r28, %r0] 0x74, %r9
	.word 0x87802073  ! 1051: WRASI_I	wr	%r0, 0x0073, %asi
	wr_tick_cmpr_0_14:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x9d, %g2
	or	%g4, 0xb4, %g4
	or	%g6, 0xb7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2bfe000  ! 1053: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd2bf6000  ! 1054: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd6874e60  ! 1055: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r11
	mov	0x78, %r18
	.word 0xd8870e40  ! 1057: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r12
	.word 0xdcb74e80  ! 1058: STHA_R	stha	%r14, [%r29 + %r0] 0x74
	.word 0xd0bf0e40  ! 1059: STDA_R	stda	%r8, [%r28 + %r0] 0x72
	.word 0xd685c4a0  ! 1060: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r11
	.word 0xdcb78e60  ! 1061: STHA_R	stha	%r14, [%r30 + %r0] 0x73
	.word 0xdaa4c400  ! 1062: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0xdc8f4e80  ! 1063: LDUBA_R	lduba	[%r29, %r0] 0x74, %r14
	.word 0xdc972000  ! 1064: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	mov	0x3c0, %r20
	mov	0x7f8, %r21
	.word 0xdc876000  ! 1067: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0xdabd04a0  ! 1068: STDA_R	stda	%r13, [%r20 + %r0] 0x25
	.word 0x87802020  ! 1069: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc8c0400  ! 1070: LDUBA_R	lduba	[%r16, %r0] 0x20, %r14
	mov	0x60, %r26
	.word 0xdccc2000  ! 1072: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r14
	mov	0x0, %r27
	.word 0xd6c70e60  ! 1074: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r11
	.word 0xde874e40  ! 1075: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r15
	.word 0xde8ca000  ! 1076: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 1077: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f689e0  ! 1078: STXA_R	stxa	%r8, [%r26 + %r0] 0x4f
	.word 0xd0f62000  ! 1079: STXA_I	stxa	%r8, [%r24 + 0x0000] %asi
	.word 0xde8c0400  ! 1080: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	mov	0x7e0, %r22
	.word 0xdeb6a000  ! 1082: STHA_I	stha	%r15, [%r26 + 0x0000] %asi
	.word 0xdede6000  ! 1083: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r15
	.word 0xdec62000  ! 1084: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r15
	mov	0x7f8, %r21
	mov	0x7f8, %r21
	.word 0xd8844400  ! 1087: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r12
	.word 0x87802025  ! 1088: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r26
	.word 0xdcf74e60  ! 1090: STXA_R	stxa	%r14, [%r29 + %r0] 0x73
	.word 0xdc85a000  ! 1091: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r14
	wr_tick_cmpr_0_15:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xdc, %g2
	or	%g4, 0xd3, %g4
	or	%g6, 0xaa, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd89f0e60  ! 1093: LDDA_R	ldda	[%r28, %r0] 0x73, %r12
	mov	0x70, %r26
	.word 0xd8dd6000  ! 1095: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r12
	.word 0xd89de000  ! 1096: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r12
	.word 0xdab609e0  ! 1097: STHA_R	stha	%r13, [%r24 + %r0] 0x4f
	.word 0xd2de89e0  ! 1098: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r9
	.word 0xde8e49e0  ! 1099: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r15
	.word 0xdebda000  ! 1100: STDA_I	stda	%r15, [%r22 + 0x0000] %asi
	.word 0xd4f649e0  ! 1101: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	.word 0xd4c52000  ! 1102: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r10
	mov	0x3c8, %r20
	.word 0xd8a7ce60  ! 1104: STWA_R	stwa	%r12, [%r31 + %r0] 0x73
	.word 0xdabe89e0  ! 1105: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 1106: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r27
	.word 0xdac52000  ! 1108: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r13
	.word 0x87802073  ! 1109: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 1110: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 1111: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad52000  ! 1112: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r13
	.word 0xd8bf4e40  ! 1113: STDA_R	stda	%r12, [%r29 + %r0] 0x72
	.word 0xdad70e40  ! 1114: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r13
	.word 0xd48c0400  ! 1115: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	mov	0x30, %r16
	mov	0x3f8, %r22
	.word 0xd0f78e60  ! 1118: STXA_R	stxa	%r8, [%r30 + %r0] 0x73
	.word 0xd0bda000  ! 1119: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	.word 0xd8a4c400  ! 1120: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0x87802074  ! 1121: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 1122: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf4c400  ! 1123: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xdabc4400  ! 1124: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xd68e49e0  ! 1125: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r11
	.word 0xd4b4c400  ! 1126: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0xd48f2000  ! 1127: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd48fa000  ! 1128: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xd4870e40  ! 1129: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r10
	mov	0x50, %r25
	.word 0xd4cf6000  ! 1131: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	mov	0x7c8, %r21
	mov	0x7c8, %r22
	mov	0x3f0, %r23
	.word 0x87802020  ! 1135: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cc6000  ! 1136: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	mov	0x48, %r16
	.word 0x87802073  ! 1138: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8bfce40  ! 1139: STDA_R	stda	%r12, [%r31 + %r0] 0x72
	.word 0xdca584a0  ! 1140: STWA_R	stwa	%r14, [%r22 + %r0] 0x25
	.word 0xdca72000  ! 1141: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 1142: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r25
	.word 0xd89c0400  ! 1144: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	.word 0xd89f6000  ! 1145: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	.word 0xd8dfe000  ! 1146: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	mov	0x40, %r16
	.word 0xd8afe000  ! 1148: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd4f44400  ! 1149: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	mov	0x68, %r17
	mov	0x7c0, %r20
	.word 0xd4972000  ! 1152: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0xd4bfa000  ! 1153: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd4c7a000  ! 1154: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4b72000  ! 1155: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd4af2000  ! 1156: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xde87ce60  ! 1157: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r15
	.word 0x87802020  ! 1158: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r18
	.word 0xdec40400  ! 1160: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xdef70e80  ! 1161: STXA_R	stxa	%r15, [%r28 + %r0] 0x74
	mov	0x60, %r19
	.word 0x87802020  ! 1163: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadcc400  ! 1164: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7f8, %r21
	.word 0x87802020  ! 1167: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r22
	.word 0x8780204f  ! 1169: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabee000  ! 1170: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	.word 0xdc8f0e60  ! 1171: LDUBA_R	lduba	[%r28, %r0] 0x73, %r14
	mov	0x3f8, %r20
	mov	0x20, %r16
	.word 0x87802073  ! 1174: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r19
	.word 0x87802020  ! 1176: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4df0e60  ! 1177: LDXA_R	ldxa	[%r28, %r0] 0x73, %r10
	.word 0xd4d7ce60  ! 1178: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r10
	.word 0xd0f7ce80  ! 1179: STXA_R	stxa	%r8, [%r31 + %r0] 0x74
	.word 0xd08c6000  ! 1180: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0xd0be89e0  ! 1181: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	.word 0xd6f649e0  ! 1182: STXA_R	stxa	%r11, [%r25 + %r0] 0x4f
	mov	0x18, %r17
	.word 0xd6a40400  ! 1184: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	mov	0x7f0, %r21
	.word 0xd6cc2000  ! 1186: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	mov	0x68, %r19
	.word 0xd6dc2000  ! 1188: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r11
	.word 0xd2c7ce80  ! 1189: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r9
	.word 0xdac5c4a0  ! 1190: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r13
	.word 0xdaf42000  ! 1191: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 1192: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r16
	.word 0xd0cc8400  ! 1194: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0xd0f7a000  ! 1195: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd6ad44a0  ! 1196: STBA_R	stba	%r11, [%r21 + %r0] 0x25
	mov	0x60, %r17
	.word 0xd8af4e80  ! 1198: STBA_R	stba	%r12, [%r29 + %r0] 0x74
	mov	0x3c0, %r22
	.word 0xd8bf8e40  ! 1200: STDA_R	stda	%r12, [%r30 + %r0] 0x72
	.word 0x87802074  ! 1201: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8a7a000  ! 1202: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8dfa000  ! 1203: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd897e000  ! 1204: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	.word 0xd88fce40  ! 1205: LDUBA_R	lduba	[%r31, %r0] 0x72, %r12
	.word 0xd8dfe000  ! 1206: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 1207: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b6e000  ! 1208: STHA_I	stha	%r12, [%r27 + 0x0000] %asi
	mov	0x70, %r25
	.word 0xd8dee000  ! 1210: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r12
	.word 0xd8d62000  ! 1211: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r12
	.word 0xde9c4400  ! 1212: LDDA_R	ldda	[%r17, %r0] 0x20, %r15
	.word 0xdedee000  ! 1213: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r15
	.word 0xd2af8e40  ! 1214: STBA_R	stba	%r9, [%r30 + %r0] 0x72
	.word 0xd2a66000  ! 1215: STWA_I	stwa	%r9, [%r25 + 0x0000] %asi
	.word 0xd0b70e40  ! 1216: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	.word 0x87802072  ! 1217: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6d7ce60  ! 1218: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r11
	.word 0xd6afe000  ! 1219: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x7f0, %r22
	.word 0xd6bf2000  ! 1221: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd6a76000  ! 1222: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6af2000  ! 1223: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd6b72000  ! 1224: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd6b76000  ! 1225: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xdab6c9e0  ! 1226: STHA_R	stha	%r13, [%r27 + %r0] 0x4f
	.word 0xda8fe000  ! 1227: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1228: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1229: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r19
	.word 0xda86e000  ! 1231: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r13
	mov	0x70, %r24
	.word 0xd6bf8e60  ! 1233: STDA_R	stda	%r11, [%r30 + %r0] 0x73
	ta	T_CHANGE_PRIV	! macro
	.word 0xd6c504a0  ! 1235: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r11
	.word 0xd68e2000  ! 1236: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r11
	mov	0x3d8, %r20
	mov	0x10, %r27
	.word 0xdebcc400  ! 1239: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	mov	0x7e0, %r21
	.word 0x87802020  ! 1241: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded48400  ! 1242: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	.word 0xdecce000  ! 1243: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	.word 0xdea4e000  ! 1244: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xde84e000  ! 1245: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	.word 0xd4a78e80  ! 1246: STWA_R	stwa	%r10, [%r30 + %r0] 0x74
	mov	0x3c8, %r20
	mov	0x18, %r18
	.word 0xdac48400  ! 1249: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	.word 0xdabce000  ! 1250: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0xdaaca000  ! 1251: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0xdcd70e60  ! 1252: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r14
	.word 0x87802020  ! 1253: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bf8e60  ! 1254: STDA_R	stda	%r11, [%r30 + %r0] 0x73
	.word 0xd0adc4a0  ! 1255: STBA_R	stba	%r8, [%r23 + %r0] 0x25
	.word 0x87802025  ! 1256: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0852000  ! 1257: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r8
	.word 0xd2d609e0  ! 1258: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r9
	mov	0x7c8, %r23
	mov	0x8, %r27
	.word 0xdabc0400  ! 1261: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xd0df4e60  ! 1262: LDXA_R	ldxa	[%r29, %r0] 0x73, %r8
	.word 0xd0cd2000  ! 1263: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r8
	.word 0xdcb78e80  ! 1264: STHA_R	stha	%r14, [%r30 + %r0] 0x74
	wr_tick_cmpr_0_16:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xa6, %g2
	or	%g4, 0xa9, %g4
	or	%g6, 0xb0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4f40400  ! 1266: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xd4a5e000  ! 1267: STWA_I	stwa	%r10, [%r23 + 0x0000] %asi
	.word 0xd4a5e000  ! 1268: STWA_I	stwa	%r10, [%r23 + 0x0000] %asi
	.word 0xd0bf0e80  ! 1269: STDA_R	stda	%r8, [%r28 + %r0] 0x74
	.word 0xd0bda000  ! 1270: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	.word 0xd89f4e80  ! 1271: LDDA_R	ldda	[%r29, %r0] 0x74, %r12
	.word 0xd8bd2000  ! 1272: STDA_I	stda	%r12, [%r20 + 0x0000] %asi
	.word 0x8780204f  ! 1273: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0878e60  ! 1274: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r8
	.word 0x87802020  ! 1275: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bc4400  ! 1276: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	wr_tick_cmpr_0_17:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf4, %g2
	or	%g4, 0xd0, %g4
	or	%g6, 0xfb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0f4e000  ! 1278: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xd6974e40  ! 1279: LDUHA_R	lduha	[%r29, %r0] 0x72, %r11
	.word 0xd8878e60  ! 1280: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r12
	.word 0xd0a7ce40  ! 1281: STWA_R	stwa	%r8, [%r31 + %r0] 0x72
	wr_tick_cmpr_0_18:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xac, %g2
	or	%g4, 0xcb, %g4
	or	%g6, 0xb2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7f0, %r23
	.word 0xd08c6000  ! 1284: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0xdacfce40  ! 1285: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r13
	.word 0x87802074  ! 1286: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xded44400  ! 1287: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	.word 0xdeb7a000  ! 1288: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xd0af0e80  ! 1290: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	mov	0x7c0, %r20
	.word 0xd2bc8400  ! 1292: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	.word 0xd28fa000  ! 1293: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	mov	0x30, %r25
	.word 0xd69e09e0  ! 1295: LDDA_R	ldda	[%r24, %r0] 0x4f, %r11
	.word 0xdac70e60  ! 1296: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r13
	.word 0xdab76000  ! 1297: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	mov	0x38, %r16
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x48, %r16
	mov	0x50, %r25
	.word 0xdcf584a0  ! 1302: STXA_R	stxa	%r14, [%r22 + %r0] 0x25
	.word 0xdcafe000  ! 1303: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	mov	0x28, %r16
	.word 0xdc9fe000  ! 1305: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xdcc76000  ! 1306: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xdca689e0  ! 1307: STWA_R	stwa	%r14, [%r26 + %r0] 0x4f
	.word 0xdcc72000  ! 1308: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0x87802074  ! 1309: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r24
	.word 0xdc9f2000  ! 1311: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0x87802072  ! 1312: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x18, %r25
	mov	0x30, %r24
	.word 0xdc9f2000  ! 1316: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xd6f40400  ! 1317: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	.word 0xd4af0e40  ! 1318: STBA_R	stba	%r10, [%r28 + %r0] 0x72
	.word 0xd4b7e000  ! 1319: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd4d7a000  ! 1320: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	mov	0x7c8, %r20
	mov	0x68, %r17
	.word 0xd49fe000  ! 1323: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xdc974e40  ! 1324: LDUHA_R	lduha	[%r29, %r0] 0x72, %r14
	.word 0xd2f48400  ! 1325: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0xdcc48400  ! 1326: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r14
	.word 0xdcbfa000  ! 1327: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	mov	0x7e0, %r20
	mov	0x3c8, %r20
	.word 0x87802020  ! 1330: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca42000  ! 1331: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xdc942000  ! 1332: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	mov	0x60, %r24
	.word 0xdacf4e80  ! 1334: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r13
	.word 0x8780204f  ! 1335: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1336: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r17
	.word 0xdaace000  ! 1338: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0xd8b6c9e0  ! 1339: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	mov	0x8, %r19
	.word 0xd0a689e0  ! 1341: STWA_R	stwa	%r8, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 1342: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r16
	mov	0x58, %r26
	.word 0xd48d44a0  ! 1345: LDUBA_R	lduba	[%r21, %r0] 0x25, %r10
	.word 0x87802025  ! 1346: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f44400  ! 1347: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd0d52000  ! 1348: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1349: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 1350: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r18
	.word 0xd087e000  ! 1352: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0x87802073  ! 1353: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d8, %r21
	.word 0x8780204f  ! 1355: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdac584a0  ! 1356: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r13
	.word 0xd89ec9e0  ! 1357: LDDA_R	ldda	[%r27, %r0] 0x4f, %r12
	mov	0x7d8, %r20
	.word 0x87802074  ! 1359: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8d72000  ! 1360: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	mov	0x3d0, %r22
	.word 0x87802020  ! 1362: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r18
	.word 0xd2b48400  ! 1364: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd2afce60  ! 1365: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2f4e000  ! 1367: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	mov	0x8, %r17
	mov	0x7f8, %r23
	.word 0xd4bf0e60  ! 1370: STDA_R	stda	%r10, [%r28 + %r0] 0x73
	.word 0xd4ac6000  ! 1371: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	.word 0xd4a42000  ! 1372: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0xd4f4c400  ! 1373: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd6af0e80  ! 1374: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	mov	0x10, %r18
	mov	0x60, %r26
	.word 0x87802025  ! 1377: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6bda000  ! 1378: STDA_I	stda	%r11, [%r22 + 0x0000] %asi
	.word 0xd6ade000  ! 1379: STBA_I	stba	%r11, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 1380: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 1381: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf649e0  ! 1382: STXA_R	stxa	%r13, [%r25 + %r0] 0x4f
	.word 0xd2cc8400  ! 1383: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	mov	0x7c0, %r22
	.word 0xd28ea000  ! 1385: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r9
	.word 0xd2be2000  ! 1386: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	.word 0x8780204f  ! 1387: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1388: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a4a000  ! 1389: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0xd2a4a000  ! 1390: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 1391: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r18
	.word 0xd8bfce40  ! 1393: STDA_R	stda	%r12, [%r31 + %r0] 0x72
	mov	0x18, %r18
	.word 0xd8a7a000  ! 1395: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8a76000  ! 1396: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	mov	0x60, %r27
	mov	0x0, %r25
	.word 0xdcb5c4a0  ! 1399: STHA_R	stha	%r14, [%r23 + %r0] 0x25
	.word 0xdccfa000  ! 1400: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xd2848400  ! 1401: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r9
	mov	0x40, %r26
	mov	0x0, %r17
	.word 0xd2df6000  ! 1404: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	mov	0x3c0, %r22
	.word 0xd2b72000  ! 1406: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 1407: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde974e60  ! 1408: LDUHA_R	lduha	[%r29, %r0] 0x73, %r15
	mov	0x3d8, %r22
	.word 0xde9de000  ! 1410: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r15
	.word 0x87802025  ! 1411: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbd04a0  ! 1412: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	mov	0x60, %r27
	mov	0x7f8, %r22
	.word 0xdcb52000  ! 1415: STHA_I	stha	%r14, [%r20 + 0x0000] %asi
	.word 0xdca56000  ! 1416: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	.word 0xd6ac8400  ! 1417: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xd4bc0400  ! 1418: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xd4f52000  ! 1419: STXA_I	stxa	%r10, [%r20 + 0x0000] %asi
	.word 0xda948400  ! 1420: LDUHA_R	lduha	[%r18, %r0] 0x20, %r13
	.word 0x87802073  ! 1421: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef78e80  ! 1422: STXA_R	stxa	%r15, [%r30 + %r0] 0x74
	.word 0xd2b4c400  ! 1423: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0x87802074  ! 1424: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde970e80  ! 1425: LDUHA_R	lduha	[%r28, %r0] 0x74, %r15
	.word 0xde9fa000  ! 1426: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	.word 0xdebf2000  ! 1427: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 1428: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde8de000  ! 1429: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r15
	.word 0xdea52000  ! 1430: STWA_I	stwa	%r15, [%r20 + 0x0000] %asi
	.word 0xd6b609e0  ! 1431: STHA_R	stha	%r11, [%r24 + %r0] 0x4f
	.word 0xd2d6c9e0  ! 1432: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r9
	.word 0xd2f56000  ! 1433: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	mov	0x3e0, %r20
	mov	0x30, %r17
	.word 0xd295a000  ! 1436: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r9
	.word 0xdcd4c400  ! 1437: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	.word 0xdcbda000  ! 1438: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	.word 0xd2cc0400  ! 1439: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r9
	mov	0x48, %r18
	.word 0xd4cec9e0  ! 1441: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r10
	.word 0xd48da000  ! 1442: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r10
	.word 0xdcdc0400  ! 1443: LDXA_R	ldxa	[%r16, %r0] 0x20, %r14
	.word 0x87802074  ! 1444: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf76000  ! 1445: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcb7e000  ! 1446: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xdca7a000  ! 1447: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	mov	0x58, %r24
	.word 0xdccf2000  ! 1449: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xdcf7e000  ! 1450: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcc7a000  ! 1452: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xdc876000  ! 1453: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0xdcafe000  ! 1454: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdab7ce80  ! 1455: STHA_R	stha	%r13, [%r31 + %r0] 0x74
	.word 0xdaf76000  ! 1456: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	mov	0x10, %r24
	.word 0xd8b4c400  ! 1458: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0xdaaf8e80  ! 1459: STBA_R	stba	%r13, [%r30 + %r0] 0x74
	.word 0x87802020  ! 1460: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab42000  ! 1461: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xd0a74e40  ! 1462: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	.word 0xd08ca000  ! 1463: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xd094e000  ! 1464: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0xd0c46000  ! 1465: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r8
	.word 0xd0ac2000  ! 1466: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	mov	0x8, %r18
	.word 0xd097ce40  ! 1468: LDUHA_R	lduha	[%r31, %r0] 0x72, %r8
	.word 0xd0c4a000  ! 1469: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	mov	0x58, %r19
	mov	0x38, %r18
	.word 0x87802020  ! 1472: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r18
	mov	0x18, %r27
	.word 0xd8a5c4a0  ! 1475: STWA_R	stwa	%r12, [%r23 + %r0] 0x25
	mov	0x30, %r19
	.word 0xd8ac6000  ! 1477: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	mov	0x30, %r26
	.word 0xd8f42000  ! 1479: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8b4e000  ! 1480: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0xd0974e80  ! 1481: LDUHA_R	lduha	[%r29, %r0] 0x74, %r8
	.word 0x8780204f  ! 1482: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f6e000  ! 1483: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	.word 0x87802025  ! 1484: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd28cc400  ! 1485: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	mov	0x28, %r17
	.word 0x87802074  ! 1487: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e0, %r20
	.word 0x87802020  ! 1489: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a4e000  ! 1490: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 1491: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 1492: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r17
	.word 0xd0f74e60  ! 1494: STXA_R	stxa	%r8, [%r29 + %r0] 0x73
	.word 0xd495c4a0  ! 1495: LDUHA_R	lduha	[%r23, %r0] 0x25, %r10
	.word 0xd4bf2000  ! 1496: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd0b689e0  ! 1497: STHA_R	stha	%r8, [%r26 + %r0] 0x4f
	mov	0x48, %r18
	.word 0xd8a74e40  ! 1499: STWA_R	stwa	%r12, [%r29 + %r0] 0x72
	.word 0xd8dfa000  ! 1500: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	mov	0x10, %r24
	mov	0x10, %r27
	.word 0xd8d76000  ! 1503: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xd28cc400  ! 1504: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	.word 0xd2d7e000  ! 1505: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0x87802025  ! 1506: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e8, %r20
	mov	0x30, %r16
	.word 0xd2ada000  ! 1509: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0xdcb70e80  ! 1511: STHA_R	stha	%r14, [%r28 + %r0] 0x74
	.word 0xd2b74e60  ! 1512: STHA_R	stha	%r9, [%r29 + %r0] 0x73
	.word 0xd49d04a0  ! 1513: LDDA_R	ldda	[%r20, %r0] 0x25, %r10
	mov	0x38, %r18
	.word 0xd4cde000  ! 1515: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r10
	mov	0x10, %r27
	.word 0xd495e000  ! 1517: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r10
	.word 0xd4a5a000  ! 1518: STWA_I	stwa	%r10, [%r22 + 0x0000] %asi
	mov	0x7f8, %r23
	mov	0x48, %r17
	.word 0xd48d2000  ! 1521: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0xd49de000  ! 1522: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r10
	.word 0xdcf40400  ! 1523: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xde94c400  ! 1524: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	.word 0xdea56000  ! 1525: STWA_I	stwa	%r15, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 1526: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda874e80  ! 1527: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r13
	.word 0xd6ccc400  ! 1528: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	.word 0xd6a4e000  ! 1529: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	mov	0x0, %r25
	.word 0xd6b4e000  ! 1531: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xdabfce60  ! 1532: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	mov	0x28, %r16
	.word 0x87802073  ! 1534: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaaf2000  ! 1535: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdadfa000  ! 1536: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xdaa7e000  ! 1537: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xdabfe000  ! 1538: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xda9584a0  ! 1539: LDUHA_R	lduha	[%r22, %r0] 0x25, %r13
	.word 0xd2bf0e80  ! 1540: STDA_R	stda	%r9, [%r28 + %r0] 0x74
	mov	0x70, %r25
	mov	0x3d8, %r21
	.word 0xd4bd04a0  ! 1543: STDA_R	stda	%r10, [%r20 + %r0] 0x25
	.word 0x87802073  ! 1544: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd28f8e40  ! 1545: LDUBA_R	lduba	[%r30, %r0] 0x72, %r9
	.word 0xd2bfe000  ! 1546: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0xd2c7e000  ! 1548: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2afe000  ! 1549: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	mov	0x8, %r18
	.word 0xd0bcc400  ! 1551: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0xdcf6c9e0  ! 1552: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	.word 0xdc9f2000  ! 1553: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xdcf76000  ! 1554: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	wr_tick_cmpr_0_19:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xca, %g2
	or	%g4, 0xde, %g4
	or	%g6, 0x94, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_PRIV	! macro
	.word 0xde9c8400  ! 1557: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	mov	0x7c8, %r22
	mov	0x3c8, %r23
	.word 0xdedf6000  ! 1560: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	mov	0x50, %r18
	.word 0xdcf649e0  ! 1562: STXA_R	stxa	%r14, [%r25 + %r0] 0x4f
	.word 0xd4d5c4a0  ! 1563: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r10
	.word 0xd29544a0  ! 1564: LDUHA_R	lduha	[%r21, %r0] 0x25, %r9
	.word 0xd6a6c9e0  ! 1565: STWA_R	stwa	%r11, [%r27 + %r0] 0x4f
	.word 0xd6c7e000  ! 1566: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6a78e60  ! 1567: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0xdcdf0e60  ! 1568: LDXA_R	ldxa	[%r28, %r0] 0x73, %r14
	mov	0x68, %r18
	.word 0xdc97e000  ! 1570: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xdcbf6000  ! 1571: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdccfe000  ! 1572: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xdc976000  ! 1573: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	mov	0x7d0, %r22
	.word 0xdcb7a000  ! 1575: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 1576: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbde000  ! 1577: STDA_I	stda	%r14, [%r23 + 0x0000] %asi
	.word 0xd28f4e60  ! 1578: LDUBA_R	lduba	[%r29, %r0] 0x73, %r9
	.word 0xdeb70e60  ! 1579: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	.word 0xde8584a0  ! 1580: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r15
	.word 0xded5e000  ! 1581: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r15
	.word 0xde9de000  ! 1582: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r15
	.word 0xdc944400  ! 1583: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	.word 0xdcbc4400  ! 1584: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	mov	0x3d0, %r21
	.word 0xdeac0400  ! 1586: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xdead84a0  ! 1587: STBA_R	stba	%r15, [%r22 + %r0] 0x25
	.word 0xdeb56000  ! 1588: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	.word 0xd2cd84a0  ! 1589: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r9
	.word 0x87802072  ! 1590: WRASI_I	wr	%r0, 0x0072, %asi
	wr_tick_cmpr_0_20:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xdc, %g2
	or	%g4, 0x82, %g4
	or	%g6, 0x81, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	wr_tick_cmpr_0_21:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf4, %g2
	or	%g4, 0xf2, %g4
	or	%g6, 0xb1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4970e80  ! 1593: LDUHA_R	lduha	[%r28, %r0] 0x74, %r10
	.word 0x87802020  ! 1594: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28f4e80  ! 1595: LDUBA_R	lduba	[%r29, %r0] 0x74, %r9
	.word 0xd28ca000  ! 1596: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	mov	0x8, %r25
	.word 0xd0acc400  ! 1598: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0x87802020  ! 1599: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a42000  ! 1600: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xd0cc6000  ! 1601: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	.word 0xd08ce000  ! 1602: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0a78e60  ! 1603: STWA_R	stwa	%r8, [%r30 + %r0] 0x73
	mov	0x50, %r24
	.word 0x87802020  ! 1605: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a7ce60  ! 1606: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	.word 0xd8f689e0  ! 1607: STXA_R	stxa	%r12, [%r26 + %r0] 0x4f
	.word 0xd6b70e80  ! 1608: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	.word 0xd6ac2000  ! 1609: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 1610: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r20
	wr_tick_cmpr_0_22:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x85, %g2
	or	%g4, 0xb7, %g4
	or	%g6, 0xe7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdec74e80  ! 1613: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r15
	wr_tick_cmpr_0_23:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa2, %g2
	or	%g4, 0xa9, %g4
	or	%g6, 0xbf, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdea42000  ! 1615: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xdcdc8400  ! 1616: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	.word 0xdcac2000  ! 1617: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	mov	0x40, %r24
	.word 0xdcf46000  ! 1619: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xd8848400  ! 1620: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r12
	.word 0xdaa7ce60  ! 1621: STWA_R	stwa	%r13, [%r31 + %r0] 0x73
	.word 0xdad689e0  ! 1622: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r13
	mov	0x20, %r17
	.word 0xd8c504a0  ! 1624: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r12
	.word 0xd8d46000  ! 1625: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	wr_tick_cmpr_0_24:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb0, %g2
	or	%g4, 0xec, %g4
	or	%g6, 0xf4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x28, %r26
	.word 0xdcc544a0  ! 1628: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r14
	.word 0xdcf78e60  ! 1629: STXA_R	stxa	%r14, [%r30 + %r0] 0x73
	.word 0xd68c0400  ! 1630: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	mov	0x0, %r26
	mov	0x58, %r26
	.word 0xd8978e40  ! 1633: LDUHA_R	lduha	[%r30, %r0] 0x72, %r12
	mov	0x8, %r18
	.word 0xd0f40400  ! 1635: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xdeb689e0  ! 1636: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	.word 0xde8c2000  ! 1637: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	.word 0xdeb4a000  ! 1638: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	mov	0x0, %r18
	.word 0xdea4e000  ! 1640: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	wr_tick_cmpr_0_25:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x81, %g2
	or	%g4, 0x90, %g4
	or	%g6, 0xd6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8c5c4a0  ! 1642: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r12
	.word 0xdea6c9e0  ! 1643: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	.word 0x8780204f  ! 1644: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdede2000  ! 1645: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r15
	mov	0x7f0, %r22
	mov	0x3f0, %r23
	mov	0x68, %r18
	.word 0xd0bd84a0  ! 1649: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0x87802025  ! 1650: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b40400  ! 1651: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0x87802020  ! 1652: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb44400  ! 1653: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0xdec46000  ! 1654: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	.word 0xde8c6000  ! 1655: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	mov	0x8, %r19
	.word 0xd0f78e40  ! 1657: STXA_R	stxa	%r8, [%r30 + %r0] 0x72
	wr_tick_cmpr_0_26:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xc8, %g2
	or	%g4, 0x80, %g4
	or	%g6, 0xa5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd6d7ce40  ! 1659: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r11
	.word 0xd2d7ce40  ! 1660: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r9
	mov	0x3d8, %r20
	.word 0xd8cc4400  ! 1662: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r12
	mov	0x3d8, %r22
	.word 0xd8c46000  ! 1664: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r12
	.word 0xdccfce40  ! 1665: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r14
	.word 0xdcbc2000  ! 1666: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	mov	0x48, %r27
	.word 0xd2afce60  ! 1668: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	.word 0xd8af0e40  ! 1669: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	.word 0xd8b4e000  ! 1670: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	mov	0x60, %r27
	mov	0x8, %r26
	.word 0x87802025  ! 1673: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8dde000  ! 1674: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r12
	.word 0xd6bf0e40  ! 1675: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	.word 0xd6a584a0  ! 1676: STWA_R	stwa	%r11, [%r22 + %r0] 0x25
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802074  ! 1678: WRASI_I	wr	%r0, 0x0074, %asi
	wr_tick_cmpr_0_27:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf7, %g2
	or	%g4, 0xac, %g4
	or	%g6, 0xe5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdeaec9e0  ! 1680: STBA_R	stba	%r15, [%r27 + %r0] 0x4f
	.word 0xd4c48400  ! 1681: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r10
	.word 0xd887ce80  ! 1682: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r12
	.word 0xd8a7e000  ! 1683: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd88f2000  ! 1684: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0xd88f6000  ! 1685: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1686: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ac6000  ! 1687: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	mov	0x30, %r24
	.word 0xd88ca000  ! 1689: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	.word 0xd6f70e40  ! 1690: STXA_R	stxa	%r11, [%r28 + %r0] 0x72
	.word 0x87802074  ! 1691: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 1692: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 1693: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 1694: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bf8e80  ! 1695: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	.word 0xd2bfa000  ! 1696: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	mov	0x18, %r25
	mov	0x10, %r24
	.word 0xd2afa000  ! 1699: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 1700: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4940400  ! 1701: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	mov	0x28, %r18
	.word 0xd4a7a000  ! 1703: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4a76000  ! 1704: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4f7e000  ! 1705: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4d7e000  ! 1706: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	.word 0x87802072  ! 1707: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 1708: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b7a000  ! 1709: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	mov	0x3e8, %r20
	mov	0x70, %r27
	.word 0xd48f8e60  ! 1712: LDUBA_R	lduba	[%r30, %r0] 0x73, %r10
	.word 0xd4afa000  ! 1713: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0xdad4c400  ! 1715: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	mov	0x50, %r26
	mov	0x40, %r17
	mov	0x48, %r25
	.word 0xd4bf0e40  ! 1719: STDA_R	stda	%r10, [%r28 + %r0] 0x72
	.word 0xd2f40400  ! 1720: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xd2bfa000  ! 1721: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 1722: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdedfce40  ! 1723: LDXA_R	ldxa	[%r31, %r0] 0x72, %r15
	mov	0x3f8, %r22
	.word 0x8780204f  ! 1725: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdab40400  ! 1726: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xdaf66000  ! 1727: STXA_I	stxa	%r13, [%r25 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdcdf8e40  ! 1729: LDXA_R	ldxa	[%r30, %r0] 0x72, %r14
	.word 0xd29fce80  ! 1730: LDDA_R	ldda	[%r31, %r0] 0x74, %r9
	.word 0xd2b504a0  ! 1731: STHA_R	stha	%r9, [%r20 + %r0] 0x25
	.word 0xd4844400  ! 1732: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	mov	0x10, %r17
	.word 0xdcb649e0  ! 1734: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	.word 0x87802073  ! 1735: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcc72000  ! 1736: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xd29e49e0  ! 1737: LDDA_R	ldda	[%r25, %r0] 0x4f, %r9
	.word 0xd28f2000  ! 1738: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	.word 0xdadd44a0  ! 1739: LDXA_R	ldxa	[%r21, %r0] 0x25, %r13
	.word 0x87802072  ! 1740: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdad7e000  ! 1741: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xd8a689e0  ! 1742: STWA_R	stwa	%r12, [%r26 + %r0] 0x4f
	.word 0xda9e89e0  ! 1743: LDDA_R	ldda	[%r26, %r0] 0x4f, %r13
	.word 0x87802025  ! 1744: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad78e80  ! 1745: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r13
	.word 0xdaf5a000  ! 1746: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0xd4a504a0  ! 1748: STWA_R	stwa	%r10, [%r20 + %r0] 0x25
	.word 0x87802073  ! 1749: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaaf4e60  ! 1750: STBA_R	stba	%r13, [%r29 + %r0] 0x73
	.word 0xdab72000  ! 1751: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdabf2000  ! 1752: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xdac72000  ! 1753: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	mov	0x60, %r16
	mov	0x40, %r18
	.word 0xda8609e0  ! 1756: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r13
	mov	0x30, %r18
	mov	0x8, %r24
	.word 0xda84c400  ! 1759: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r13
	.word 0xde978e40  ! 1760: LDUHA_R	lduha	[%r30, %r0] 0x72, %r15
	.word 0xde9f2000  ! 1761: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	mov	0x0, %r16
	.word 0x87802073  ! 1763: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd087ce60  ! 1764: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r8
	.word 0xd6af8e80  ! 1765: STBA_R	stba	%r11, [%r30 + %r0] 0x74
	.word 0xd6afa000  ! 1766: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6af2000  ! 1767: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x60, %r24
	.word 0xd28689e0  ! 1769: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r9
	.word 0x87802073  ! 1770: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2af6000  ! 1771: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1772: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r16
	mov	0x3d8, %r21
	.word 0xda97ce40  ! 1775: LDUHA_R	lduha	[%r31, %r0] 0x72, %r13
	mov	0x10, %r17
	.word 0xdaa42000  ! 1777: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0xdcf70e40  ! 1778: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	.word 0x87802072  ! 1779: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r16
	mov	0x7f8, %r22
	mov	0x50, %r26
	.word 0xdcafe000  ! 1783: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdcc72000  ! 1784: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	mov	0x8, %r27
	.word 0xdcf76000  ! 1786: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x60, %r26
	.word 0x87802025  ! 1788: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc952000  ! 1789: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r14
	.word 0xd2940400  ! 1790: LDUHA_R	lduha	[%r16, %r0] 0x20, %r9
	.word 0xd2b5e000  ! 1791: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	.word 0xdac74e60  ! 1792: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r13
	.word 0xd6b544a0  ! 1793: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	.word 0xdeb5c4a0  ! 1794: STHA_R	stha	%r15, [%r23 + %r0] 0x25
	.word 0x87802020  ! 1795: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r16
	.word 0xded46000  ! 1797: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	.word 0xdea46000  ! 1798: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 1799: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r17
	.word 0xdabec9e0  ! 1801: STDA_R	stda	%r13, [%r27 + %r0] 0x4f
	.word 0xd6f7ce40  ! 1802: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	.word 0xda9c8400  ! 1803: LDDA_R	ldda	[%r18, %r0] 0x20, %r13
	.word 0xdacfa000  ! 1804: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xdaaf2000  ! 1805: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdaf7a000  ! 1806: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xdab76000  ! 1808: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 1809: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda872000  ! 1810: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	mov	0x3c8, %r22
	.word 0xdaf76000  ! 1812: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdaa7ce60  ! 1813: STWA_R	stwa	%r13, [%r31 + %r0] 0x73
	mov	0x18, %r16
	.word 0x8780204f  ! 1815: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd087ce80  ! 1816: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r8
	.word 0xd4d4c400  ! 1817: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0x87802020  ! 1818: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r24
	.word 0x87802073  ! 1820: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f72000  ! 1821: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4bfa000  ! 1822: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x8780204f  ! 1824: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b7ce60  ! 1825: STHA_R	stha	%r10, [%r31 + %r0] 0x73
	.word 0xd8f504a0  ! 1826: STXA_R	stxa	%r12, [%r20 + %r0] 0x25
	mov	0x38, %r26
	.word 0xd0cc4400  ! 1828: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	.word 0xd0f62000  ! 1829: STXA_I	stxa	%r8, [%r24 + 0x0000] %asi
	.word 0xd08e2000  ! 1830: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r8
	.word 0x87802073  ! 1831: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8cfce40  ! 1832: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r12
	.word 0xdca74e40  ! 1833: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	mov	0x7f8, %r23
	.word 0x87802074  ! 1835: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r26
	.word 0x87802025  ! 1837: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc8de000  ! 1838: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r14
	.word 0xdc956000  ! 1839: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r14
	.word 0xd0b7ce60  ! 1840: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	.word 0xd0b52000  ! 1841: STHA_I	stha	%r8, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 1842: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ac0400  ! 1843: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0xda9cc400  ! 1844: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	mov	0x18, %r17
	.word 0xda84e000  ! 1846: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r13
	.word 0x87802073  ! 1847: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd08fce80  ! 1848: LDUBA_R	lduba	[%r31, %r0] 0x74, %r8
	.word 0xd0dfa000  ! 1849: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1850: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0aca000  ! 1851: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	mov	0x40, %r19
	mov	0x50, %r25
	mov	0x60, %r25
	.word 0x87802020  ! 1855: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r27
	.word 0xd2dc0400  ! 1857: LDXA_R	ldxa	[%r16, %r0] 0x20, %r9
	.word 0xdebfce80  ! 1858: STDA_R	stda	%r15, [%r31 + %r0] 0x74
	.word 0xd0870e60  ! 1859: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r8
	.word 0x87802020  ! 1860: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0c4a000  ! 1861: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1862: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1863: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r16
	.word 0xd0cf6000  ! 1865: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0x87802073  ! 1866: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r26
	.word 0xd09c0400  ! 1868: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	mov	0x0, %r18
	.word 0xd0b72000  ! 1870: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd0df2000  ! 1871: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	mov	0x40, %r26
	.word 0xd0cf6000  ! 1873: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd0d72000  ! 1874: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	mov	0x38, %r27
	.word 0xd0df6000  ! 1876: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1877: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r17
	mov	0x0, %r17
	.word 0xd0ae49e0  ! 1880: STBA_R	stba	%r8, [%r25 + %r0] 0x4f
	.word 0xdead84a0  ! 1881: STBA_R	stba	%r15, [%r22 + %r0] 0x25
	mov	0x7f8, %r22
	mov	0x38, %r18
	.word 0xdef4e000  ! 1884: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 1885: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1886: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd497ce60  ! 1887: LDUHA_R	lduha	[%r31, %r0] 0x73, %r10
	mov	0x50, %r19
	.word 0xd4d4e000  ! 1889: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	mov	0x18, %r26
	.word 0xd4a78e60  ! 1891: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	.word 0xd4f4e000  ! 1892: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0xdca584a0  ! 1893: STWA_R	stwa	%r14, [%r22 + %r0] 0x25
	.word 0xdca46000  ! 1894: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 1895: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca7a000  ! 1896: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xd8a48400  ! 1898: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	.word 0xd8f76000  ! 1899: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xdabc0400  ! 1900: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	mov	0x68, %r24
	.word 0xda976000  ! 1902: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	.word 0xd6df8e60  ! 1903: LDXA_R	ldxa	[%r30, %r0] 0x73, %r11
	ta	T_CHANGE_PRIV	! macro
	.word 0xd6cfe000  ! 1905: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	mov	0x3c0, %r20
	mov	0x7e0, %r21
	mov	0x50, %r27
	.word 0x87802025  ! 1909: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd695e000  ! 1910: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r11
	mov	0x70, %r26
	.word 0xd0c689e0  ! 1912: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r8
	.word 0xd0bd6000  ! 1913: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0xdcaf4e60  ! 1914: STBA_R	stba	%r14, [%r29 + %r0] 0x73
	.word 0xdcdd6000  ! 1915: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 1916: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdede89e0  ! 1917: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r15
	.word 0xd4f504a0  ! 1918: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0xdabc0400  ! 1919: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0x87802025  ! 1920: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r27
	.word 0xd6bc0400  ! 1922: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xd6cd2000  ! 1923: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r11
	.word 0xd6cc0400  ! 1924: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r11
	mov	0x3d8, %r20
	mov	0x7e8, %r20
	.word 0x87802072  ! 1927: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf78e60  ! 1928: STXA_R	stxa	%r13, [%r30 + %r0] 0x73
	.word 0xdedf4e40  ! 1929: LDXA_R	ldxa	[%r29, %r0] 0x72, %r15
	.word 0x87802025  ! 1930: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c0, %r20
	.word 0x8780204f  ! 1932: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa70e40  ! 1933: STWA_R	stwa	%r13, [%r28 + %r0] 0x72
	.word 0xd6bcc400  ! 1934: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0xd8f544a0  ! 1935: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	.word 0xdeb44400  ! 1936: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0xdede6000  ! 1937: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r15
	.word 0xded6a000  ! 1938: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r15
	.word 0xdeb62000  ! 1939: STHA_I	stha	%r15, [%r24 + 0x0000] %asi
	.word 0xdeae2000  ! 1940: STBA_I	stba	%r15, [%r24 + 0x0000] %asi
	.word 0xde86e000  ! 1941: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r15
	.word 0xdaf4c400  ! 1942: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xdef689e0  ! 1943: STXA_R	stxa	%r15, [%r26 + %r0] 0x4f
	mov	0x28, %r24
	.word 0xd0ac8400  ! 1945: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xda8c0400  ! 1946: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	.word 0x87802074  ! 1947: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1948: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabca000  ! 1949: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 1950: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadc6000  ! 1951: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xdaf42000  ! 1952: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0xdc940400  ! 1953: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0xdc9c2000  ! 1954: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r14
	.word 0xdc8cc400  ! 1955: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	.word 0xdab40400  ! 1956: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xda8c6000  ! 1957: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r13
	.word 0xdab4e000  ! 1958: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0x87802073  ! 1960: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 1961: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0c4c400  ! 1962: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	mov	0x3c0, %r20
	mov	0x30, %r17
	mov	0x30, %r24
	.word 0xd0df2000  ! 1966: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	mov	0x48, %r25
	mov	0x78, %r18
	.word 0x87802020  ! 1969: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r16
	mov	0x7d0, %r21
	mov	0x28, %r25
	.word 0xd0cc2000  ! 1973: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	mov	0x10, %r16
	.word 0xd09ce000  ! 1975: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r8
	mov	0x8, %r19
	mov	0x30, %r27
	.word 0xd8c74e40  ! 1978: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r12
	mov	0x7d0, %r22
	.word 0xd89ca000  ! 1980: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r12
	.word 0xdab78e60  ! 1981: STHA_R	stha	%r13, [%r30 + %r0] 0x73
	.word 0xd28d84a0  ! 1982: LDUBA_R	lduba	[%r22, %r0] 0x25, %r9
	.word 0x87802025  ! 1983: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc8fce40  ! 1984: LDUBA_R	lduba	[%r31, %r0] 0x72, %r14
	.word 0xdcd52000  ! 1985: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r14
	.word 0xd2dc4400  ! 1986: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xd8b584a0  ! 1987: STHA_R	stha	%r12, [%r22 + %r0] 0x25
	mov	0x30, %r17
	.word 0xd8a5e000  ! 1989: STWA_I	stwa	%r12, [%r23 + 0x0000] %asi
	.word 0xd89de000  ! 1990: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r12
	mov	0x3d0, %r22
	.word 0xd2cfce40  ! 1992: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r9
	mov	0x20, %r24
	mov	0x60, %r26
	.word 0x87802020  ! 1995: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1996: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2bf2000  ! 1997: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0xd4878e80  ! 1999: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r10
	.word 0xd4bf0e60  ! 2000: STDA_R	stda	%r10, [%r28 + %r0] 0x73
	.word 0xdcf6c9e0  ! 2001: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	.word 0xdcf7a000  ! 2002: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x0, %r16
	.word 0x87802020  ! 2004: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2005: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde94c400  ! 2006: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	mov	0x7f0, %r22
	.word 0xd2bcc400  ! 2008: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xd8a74e60  ! 2009: STWA_R	stwa	%r12, [%r29 + %r0] 0x73
	mov	0x50, %r19
	.word 0xd8f72000  ! 2011: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8d7a000  ! 2012: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0xd8bfa000  ! 2013: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	mov	0x0, %r18
	.word 0xd6b78e40  ! 2015: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	.word 0x8780204f  ! 2016: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 2017: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r17
	.word 0x87802025  ! 2019: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f5e000  ! 2020: STXA_I	stxa	%r11, [%r23 + 0x0000] %asi
	.word 0xdccc0400  ! 2021: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r14
	.word 0xdc9da000  ! 2022: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r14
	.word 0xdcad6000  ! 2023: STBA_I	stba	%r14, [%r21 + 0x0000] %asi
	.word 0xde8c8400  ! 2024: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	.word 0xdec56000  ! 2025: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802072  ! 2027: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeafe000  ! 2028: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xdedfe000  ! 2029: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	mov	0x68, %r16
	.word 0xd4b609e0  ! 2031: STHA_R	stha	%r10, [%r24 + %r0] 0x4f
	.word 0xdef74e60  ! 2032: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	.word 0xdaf44400  ! 2033: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0xdad76000  ! 2034: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0x87802072  ! 2035: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde8f0e60  ! 2036: LDUBA_R	lduba	[%r28, %r0] 0x73, %r15
	.word 0xdecfe000  ! 2037: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xdec7e000  ! 2038: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xd0cf8e60  ! 2039: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r8
	.word 0xd09f2000  ! 2040: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	mov	0x38, %r16
	mov	0x0, %r27
	.word 0xdcaf0e80  ! 2043: STBA_R	stba	%r14, [%r28 + %r0] 0x74
	mov	0x58, %r16
	.word 0x8780204f  ! 2045: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0bc4400  ! 2046: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xd0a6e000  ! 2047: STWA_I	stwa	%r8, [%r27 + 0x0000] %asi
	mov	0x28, %r16
	mov	0x7c8, %r22
	.word 0xd0df8e80  ! 2050: LDXA_R	ldxa	[%r30, %r0] 0x74, %r8
	.word 0x87802025  ! 2051: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r17
	.word 0xd8b5c4a0  ! 2053: STHA_R	stha	%r12, [%r23 + %r0] 0x25
	.word 0x87802025  ! 2054: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8d5e000  ! 2055: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r12
	mov	0x60, %r24
	mov	0x68, %r17
	.word 0xdaa78e40  ! 2058: STWA_R	stwa	%r13, [%r30 + %r0] 0x72
	.word 0xdaf56000  ! 2059: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	mov	0x3e8, %r23
	.word 0x8780204f  ! 2061: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaae2000  ! 2062: STBA_I	stba	%r13, [%r24 + 0x0000] %asi
	.word 0x87802072  ! 2063: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabfa000  ! 2064: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 2065: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r24
	wr_tick_cmpr_0_28:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x97, %g2
	or	%g4, 0xb4, %g4
	or	%g6, 0x82, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0a7ce60  ! 2068: STWA_R	stwa	%r8, [%r31 + %r0] 0x73
	.word 0x87802025  ! 2069: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8970e40  ! 2070: LDUHA_R	lduha	[%r28, %r0] 0x72, %r12
	.word 0xd6878e60  ! 2071: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r11
	.word 0x8780204f  ! 2072: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r17
	.word 0xd6bec9e0  ! 2074: STDA_R	stda	%r11, [%r27 + %r0] 0x4f
	.word 0xd6966000  ! 2075: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r11
	.word 0xdecf4e40  ! 2076: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r15
	.word 0x8780204f  ! 2077: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f7ce60  ! 2078: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	.word 0xd496e000  ! 2079: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r10
	.word 0xd4dea000  ! 2080: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	.word 0xd4f6e000  ! 2081: STXA_I	stxa	%r10, [%r27 + 0x0000] %asi
	mov	0x20, %r17
	.word 0x87802020  ! 2083: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b4e000  ! 2084: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	wr_tick_cmpr_0_29:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc0, %g2
	or	%g4, 0xe4, %g4
	or	%g6, 0xf9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2ac8400  ! 2086: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	mov	0x78, %r19
	.word 0xd48fce80  ! 2088: LDUBA_R	lduba	[%r31, %r0] 0x74, %r10
	.word 0x87802020  ! 2089: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc840400  ! 2090: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	.word 0xd0bfce40  ! 2091: STDA_R	stda	%r8, [%r31 + %r0] 0x72
	.word 0x87802020  ! 2092: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r26
	.word 0x87802020  ! 2094: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r21
	.word 0xd4cc0400  ! 2096: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r10
	.word 0xdcb48400  ! 2097: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	mov	0x70, %r25
	.word 0xdca4e000  ! 2099: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	mov	0x78, %r24
	mov	0x70, %r27
	.word 0xdcbc2000  ! 2102: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 2103: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r19
	.word 0xdcdca000  ! 2105: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xd89584a0  ! 2106: LDUHA_R	lduha	[%r22, %r0] 0x25, %r12
	.word 0xd88ce000  ! 2107: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	.word 0xd2ae09e0  ! 2108: STBA_R	stba	%r9, [%r24 + %r0] 0x4f
	.word 0xd2d46000  ! 2109: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	.word 0xd4af8e60  ! 2110: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	.word 0xdedf8e60  ! 2111: LDXA_R	ldxa	[%r30, %r0] 0x73, %r15
	.word 0xd8ae09e0  ! 2112: STBA_R	stba	%r12, [%r24 + %r0] 0x4f
	.word 0xd8b46000  ! 2113: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0xd0df0e60  ! 2114: LDXA_R	ldxa	[%r28, %r0] 0x73, %r8
	.word 0xd0c46000  ! 2115: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r8
	.word 0xdeac0400  ! 2116: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xdef42000  ! 2117: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xdeac2000  ! 2118: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xde942000  ! 2119: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	.word 0xdef4a000  ! 2120: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0xdeace000  ! 2121: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xdeb4e000  ! 2123: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0xd6a70e60  ! 2124: STWA_R	stwa	%r11, [%r28 + %r0] 0x73
	mov	0x38, %r18
	.word 0x87802074  ! 2126: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4dfce40  ! 2127: LDXA_R	ldxa	[%r31, %r0] 0x72, %r10
	.word 0xdef44400  ! 2128: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	mov	0x7e0, %r22
	.word 0xdecf6000  ! 2130: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	mov	0x3e0, %r20
	.word 0xdef7e000  ! 2132: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xdec72000  ! 2133: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xded76000  ! 2134: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0xd08c4400  ! 2135: LDUBA_R	lduba	[%r17, %r0] 0x20, %r8
	mov	0x3f0, %r20
	.word 0xd8acc400  ! 2137: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0x87802020  ! 2138: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2139: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a46000  ! 2140: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	mov	0x28, %r25
	.word 0xd6bc8400  ! 2142: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	mov	0x40, %r27
	.word 0x87802072  ! 2144: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2145: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bd84a0  ! 2146: STDA_R	stda	%r10, [%r22 + %r0] 0x25
	.word 0xd4d44400  ! 2147: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0xd8f7ce60  ! 2148: STXA_R	stxa	%r12, [%r31 + %r0] 0x73
	.word 0x87802073  ! 2149: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 2150: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2151: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2152: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8956000  ! 2153: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r12
	.word 0xd89da000  ! 2154: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r12
	.word 0x87802025  ! 2155: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4d584a0  ! 2156: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r10
	.word 0xd0a6c9e0  ! 2157: STWA_R	stwa	%r8, [%r27 + %r0] 0x4f
	.word 0xd49e89e0  ! 2158: LDDA_R	ldda	[%r26, %r0] 0x4f, %r10
	.word 0xd4d5a000  ! 2159: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r10
	.word 0x87802072  ! 2160: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d0, %r20
	.word 0xdef78e80  ! 2162: STXA_R	stxa	%r15, [%r30 + %r0] 0x74
	.word 0xdecfe000  ! 2163: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xdc96c9e0  ! 2164: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r14
	.word 0xdca7a000  ! 2165: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcc7a000  ! 2166: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xdc87a000  ! 2167: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcc76000  ! 2168: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0x87802072  ! 2169: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f8, %r20
	.word 0xdcf40400  ! 2171: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	wr_tick_cmpr_0_30:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xfc, %g2
	or	%g4, 0xcf, %g4
	or	%g6, 0xe6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdc8f6000  ! 2173: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcc7a000  ! 2174: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xdc8f6000  ! 2175: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xd0940400  ! 2176: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	.word 0x87802072  ! 2177: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 2178: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2179: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09ca000  ! 2180: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	.word 0xd6acc400  ! 2181: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xd6946000  ! 2182: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r11
	.word 0xd694e000  ! 2183: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r11
	mov	0x3c0, %r20
	.word 0xd6d4e000  ! 2185: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r11
	mov	0x60, %r19
	.word 0xd6b42000  ! 2187: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 2188: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6cf2000  ! 2189: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0xd6d7ce60  ! 2190: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r11
	.word 0xd6b7a000  ! 2191: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd4ddc4a0  ! 2192: LDXA_R	ldxa	[%r23, %r0] 0x25, %r10
	.word 0xdeb7ce60  ! 2193: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	.word 0xda948400  ! 2194: LDUHA_R	lduha	[%r18, %r0] 0x20, %r13
	.word 0xda976000  ! 2195: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	.word 0xdaa7e000  ! 2196: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 2197: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 2198: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0af8e40  ! 2199: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0xd4de89e0  ! 2200: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r10
	.word 0xd6c70e60  ! 2201: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r11
	.word 0xd6a62000  ! 2202: STWA_I	stwa	%r11, [%r24 + 0x0000] %asi
	.word 0xd6ce6000  ! 2203: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r11
	.word 0xde948400  ! 2204: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	.word 0xd0f7ce60  ! 2205: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	.word 0xd0f70e40  ! 2206: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	.word 0xd0b6a000  ! 2207: STHA_I	stha	%r8, [%r26 + 0x0000] %asi
	.word 0xd09f8e40  ! 2208: LDDA_R	ldda	[%r30, %r0] 0x72, %r8
	.word 0x8780204f  ! 2209: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf689e0  ! 2210: STXA_R	stxa	%r14, [%r26 + %r0] 0x4f
	.word 0xdcf62000  ! 2211: STXA_I	stxa	%r14, [%r24 + 0x0000] %asi
	mov	0x68, %r18
	.word 0x87802074  ! 2213: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd296c9e0  ! 2214: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r9
	mov	0x3c0, %r22
	.word 0xd8f649e0  ! 2216: STXA_R	stxa	%r12, [%r25 + %r0] 0x4f
	.word 0xd8cfa000  ! 2217: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd69c0400  ! 2218: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	.word 0xd2f609e0  ! 2219: STXA_R	stxa	%r9, [%r24 + %r0] 0x4f
	.word 0x87802074  ! 2220: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r26
	.word 0xd2cf2000  ! 2222: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r9
	.word 0x87802072  ! 2223: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 2224: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r18
	.word 0xd6bc4400  ! 2226: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	mov	0x7c0, %r20
	.word 0xd6bf6000  ! 2228: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xdabe49e0  ! 2229: STDA_R	stda	%r13, [%r25 + %r0] 0x4f
	mov	0x40, %r17
	.word 0x87802020  ! 2231: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9c6000  ! 2232: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xd8ac4400  ! 2233: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	wr_tick_cmpr_0_31:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xbb, %g2
	or	%g4, 0xf7, %g4
	or	%g6, 0xa4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 2235: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbf4e60  ! 2236: STDA_R	stda	%r14, [%r29 + %r0] 0x73
	.word 0xdecf0e60  ! 2237: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r15
	.word 0xdac78e60  ! 2238: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r13
	.word 0xdac7e000  ! 2239: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xd2b544a0  ! 2240: STHA_R	stha	%r9, [%r21 + %r0] 0x25
	mov	0x3e0, %r20
	.word 0x87802074  ! 2242: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r25
	.word 0xd2cf6000  ! 2244: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	mov	0x7f8, %r22
	.word 0x87802020  ! 2246: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28ce000  ! 2247: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdc8c4400  ! 2249: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0xdc8ce000  ! 2250: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	.word 0xd0f70e80  ! 2251: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	mov	0x7f8, %r22
	.word 0x87802020  ! 2253: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9689e0  ! 2254: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r14
	mov	0x48, %r18
	.word 0xd4a609e0  ! 2256: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	.word 0xdca5c4a0  ! 2257: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	.word 0x87802072  ! 2258: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r24
	mov	0x3f0, %r20
	.word 0x87802020  ! 2261: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdc6000  ! 2262: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	mov	0x7f0, %r22
	mov	0x48, %r24
	.word 0xd2f48400  ! 2265: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0xde9f4e80  ! 2266: LDDA_R	ldda	[%r29, %r0] 0x74, %r15
	.word 0xd6c504a0  ! 2267: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r11
	.word 0x87802025  ! 2268: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8a649e0  ! 2269: STWA_R	stwa	%r12, [%r25 + %r0] 0x4f
	.word 0xdc9f0e60  ! 2270: LDDA_R	ldda	[%r28, %r0] 0x73, %r14
	mov	0x78, %r18
	.word 0x87802073  ! 2272: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4dc8400  ! 2273: LDXA_R	ldxa	[%r18, %r0] 0x20, %r10
	.word 0xdca5c4a0  ! 2274: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	.word 0xd4af8e80  ! 2275: STBA_R	stba	%r10, [%r30 + %r0] 0x74
	mov	0x70, %r27
	mov	0x60, %r18
	mov	0x30, %r17
	.word 0xd2dc0400  ! 2279: LDXA_R	ldxa	[%r16, %r0] 0x20, %r9
	.word 0xd887ce60  ! 2280: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r12
	.word 0x87802020  ! 2281: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b46000  ! 2282: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	mov	0x58, %r16
	mov	0x48, %r27
	.word 0xd8b4e000  ! 2285: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0xdcbe09e0  ! 2286: STDA_R	stda	%r14, [%r24 + %r0] 0x4f
	.word 0xda8fce40  ! 2287: LDUBA_R	lduba	[%r31, %r0] 0x72, %r13
	mov	0x70, %r16
	.word 0xd2af4e60  ! 2289: STBA_R	stba	%r9, [%r29 + %r0] 0x73
	mov	0x7f0, %r21
	.word 0xde9c4400  ! 2291: LDDA_R	ldda	[%r17, %r0] 0x20, %r15
	.word 0xd6d44400  ! 2292: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r11
	.word 0xd88d04a0  ! 2293: LDUBA_R	lduba	[%r20, %r0] 0x25, %r12
	mov	0x7c8, %r20
	.word 0xd49d84a0  ! 2295: LDDA_R	ldda	[%r22, %r0] 0x25, %r10
	.word 0xd2974e80  ! 2296: LDUHA_R	lduha	[%r29, %r0] 0x74, %r9
	.word 0xda8ec9e0  ! 2297: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r13
	.word 0xda84a000  ! 2298: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	.word 0xdaace000  ! 2299: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0xdaf4a000  ! 2300: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0xdabc6000  ! 2301: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xdab46000  ! 2302: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 2303: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e8, %r22
	.word 0xdacee000  ! 2305: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r13
	.word 0x87802072  ! 2306: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r27
	.word 0x87802020  ! 2308: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabce000  ! 2309: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 2310: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r26
	.word 0x87802025  ! 2312: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6d7ce80  ! 2313: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r11
	.word 0xd68d6000  ! 2314: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r11
	.word 0xd6c5a000  ! 2315: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r11
	.word 0xd68d2000  ! 2316: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r11
	.word 0xd6b5a000  ! 2317: STHA_I	stha	%r11, [%r22 + 0x0000] %asi
	.word 0xd0dc0400  ! 2318: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xdcb5c4a0  ! 2319: STHA_R	stha	%r14, [%r23 + %r0] 0x25
	.word 0xd6a40400  ! 2320: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	mov	0x48, %r24
	mov	0x50, %r27
	mov	0x60, %r17
	.word 0xd685a000  ! 2324: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r11
	.word 0xd6ade000  ! 2325: STBA_I	stba	%r11, [%r23 + 0x0000] %asi
	.word 0xd6f5e000  ! 2326: STXA_I	stxa	%r11, [%r23 + 0x0000] %asi
	.word 0xd6b52000  ! 2327: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	mov	0x7e0, %r22
	.word 0x87802072  ! 2329: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 2330: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r25
	.word 0xd8acc400  ! 2332: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	mov	0x7e0, %r23
	.word 0xd6ac8400  ! 2334: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xd8b74e80  ! 2335: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	.word 0xd6bdc4a0  ! 2336: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	mov	0x38, %r27
	mov	0x3f0, %r20
	mov	0x3c8, %r20
	.word 0xdaafce80  ! 2340: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	.word 0xdabd6000  ! 2341: STDA_I	stda	%r13, [%r21 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0xdcf44400  ! 2343: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	mov	0x40, %r17
	mov	0x40, %r24
	.word 0xdccd04a0  ! 2346: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r14
	.word 0xd8c74e40  ! 2347: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r12
	.word 0xdef48400  ! 2348: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xdec56000  ! 2349: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r15
	.word 0x87802072  ! 2350: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 2351: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdecfa000  ! 2352: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0x87802074  ! 2353: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdebfe000  ! 2354: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 2355: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb7a000  ! 2356: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 2357: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r27
	.word 0x87802072  ! 2359: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 2360: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeb7e000  ! 2361: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xd28fce80  ! 2362: LDUBA_R	lduba	[%r31, %r0] 0x74, %r9
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd287e000  ! 2364: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0xd88504a0  ! 2365: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r12
	mov	0x0, %r24
	mov	0x70, %r19
	.word 0xdaf649e0  ! 2368: STXA_R	stxa	%r13, [%r25 + %r0] 0x4f
	.word 0xd0a7ce80  ! 2369: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	mov	0x3c8, %r21
	.word 0xd08f2000  ! 2371: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	.word 0xd6b74e40  ! 2372: STHA_R	stha	%r11, [%r29 + %r0] 0x72
	mov	0x50, %r18
	.word 0xd0978e60  ! 2374: LDUHA_R	lduha	[%r30, %r0] 0x73, %r8
	mov	0x58, %r26
	mov	0x3c8, %r23
	mov	0x38, %r18
	.word 0x87802020  ! 2378: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca74e60  ! 2379: STWA_R	stwa	%r14, [%r29 + %r0] 0x73
	mov	0x3d0, %r21
	.word 0x87802072  ! 2381: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdccf6000  ! 2382: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcc76000  ! 2383: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xd8dd04a0  ! 2384: LDXA_R	ldxa	[%r20, %r0] 0x25, %r12
	mov	0x3d0, %r23
	.word 0xd8a6c9e0  ! 2386: STWA_R	stwa	%r12, [%r27 + %r0] 0x4f
	.word 0xd8b76000  ! 2387: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd8bfe000  ! 2388: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd68c0400  ! 2389: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	.word 0x87802025  ! 2390: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r27
	.word 0x87802020  ! 2392: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_0_32:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xdb, %g2
	or	%g4, 0xbc, %g4
	or	%g6, 0xd9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2de09e0  ! 2394: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r9
	.word 0xd2dce000  ! 2395: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r9
	.word 0xd0bd84a0  ! 2396: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0xd0dca000  ! 2397: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	.word 0xd4d40400  ! 2398: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	mov	0x58, %r25
	.word 0xd0df8e40  ! 2400: LDXA_R	ldxa	[%r30, %r0] 0x72, %r8
	.word 0x87802025  ! 2401: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f56000  ! 2402: STXA_I	stxa	%r8, [%r21 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xdad70e60  ! 2404: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r13
	.word 0x87802072  ! 2405: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r27
	mov	0x38, %r25
	.word 0xd6c609e0  ! 2408: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r11
	wr_tick_cmpr_0_33:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb4, %g2
	or	%g4, 0xa9, %g4
	or	%g6, 0xa2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7c0, %r20
	.word 0xd8dc8400  ! 2411: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xdad504a0  ! 2412: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r13
	.word 0x87802020  ! 2413: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f78e80  ! 2414: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	.word 0xd4b4a000  ! 2415: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0x87802020  ! 2417: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r24
	.word 0xd2a40400  ! 2419: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xd29c6000  ! 2420: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	mov	0x78, %r19
	.word 0xd2bca000  ! 2422: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	.word 0xd2d42000  ! 2423: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0xd4ccc400  ! 2424: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0xd49ce000  ! 2425: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0xd4b42000  ! 2426: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0xdaafce40  ! 2428: STBA_R	stba	%r13, [%r31 + %r0] 0x72
	.word 0xd8ad84a0  ! 2429: STBA_R	stba	%r12, [%r22 + %r0] 0x25
	.word 0xd8842000  ! 2430: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	mov	0x70, %r24
	.word 0x87802072  ! 2432: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa74e60  ! 2433: STWA_R	stwa	%r13, [%r29 + %r0] 0x73
	mov	0x3d0, %r23
	.word 0xdcaf4e60  ! 2435: STBA_R	stba	%r14, [%r29 + %r0] 0x73
	mov	0x20, %r24
	mov	0x20, %r24
	.word 0xdab70e40  ! 2438: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	wr_tick_cmpr_0_34:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xbb, %g2
	or	%g4, 0xf0, %g4
	or	%g6, 0xaf, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdaf7e000  ! 2440: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xdc948400  ! 2441: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	.word 0xdc8f6000  ! 2442: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	mov	0x18, %r27
	.word 0xdecf4e40  ! 2444: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r15
	.word 0xdc8649e0  ! 2445: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r14
	wr_tick_cmpr_0_35:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb5, %g2
	or	%g4, 0x8f, %g4
	or	%g6, 0xdc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802072  ! 2447: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0bd44a0  ! 2448: STDA_R	stda	%r8, [%r21 + %r0] 0x25
	.word 0xd0b72000  ! 2449: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 2450: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r25
	.word 0xdedc4400  ! 2452: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	mov	0x70, %r25
	.word 0xd2a74e60  ! 2454: STWA_R	stwa	%r9, [%r29 + %r0] 0x73
	mov	0x38, %r24
	.word 0xdea74e80  ! 2456: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	.word 0x87802025  ! 2457: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802025  ! 2459: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdead2000  ! 2460: STBA_I	stba	%r15, [%r20 + 0x0000] %asi
	.word 0xdebc8400  ! 2461: STDA_R	stda	%r15, [%r18 + %r0] 0x20
	.word 0xdeb52000  ! 2462: STHA_I	stha	%r15, [%r20 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0xdc974e40  ! 2464: LDUHA_R	lduha	[%r29, %r0] 0x72, %r14
	.word 0xdcf52000  ! 2465: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	.word 0xdaf70e80  ! 2466: STXA_R	stxa	%r13, [%r28 + %r0] 0x74
	mov	0x28, %r17
	.word 0xdc9c4400  ! 2468: LDDA_R	ldda	[%r17, %r0] 0x20, %r14
	.word 0xdcdda000  ! 2469: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r14
	.word 0xdc9d2000  ! 2470: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r14
	.word 0xd8f70e60  ! 2471: STXA_R	stxa	%r12, [%r28 + %r0] 0x73
	.word 0xd8d52000  ! 2472: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r12
	.word 0xdadc0400  ! 2473: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	.word 0x87802020  ! 2474: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad4e000  ! 2475: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r13
	mov	0x68, %r25
	mov	0x3f0, %r21
	.word 0x87802020  ! 2478: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa4e000  ! 2479: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0xdaac2000  ! 2480: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0xd894c400  ! 2481: LDUHA_R	lduha	[%r19, %r0] 0x20, %r12
	.word 0xd8dc6000  ! 2482: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	.word 0x87802074  ! 2483: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8cfa000  ! 2484: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xdcdd44a0  ! 2485: LDXA_R	ldxa	[%r21, %r0] 0x25, %r14
	.word 0xdcafe000  ! 2486: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xdc87a000  ! 2488: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcaf2000  ! 2489: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	mov	0x3c8, %r22
	.word 0xdccfe000  ! 2491: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xdccfe000  ! 2492: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xdc9c8400  ! 2493: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0xded78e80  ! 2494: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r15
	.word 0xde8e89e0  ! 2495: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r15
	.word 0xdedf2000  ! 2496: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	mov	0x18, %r25
	.word 0xd485c4a0  ! 2498: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r10
	.word 0xd4bf6000  ! 2499: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd4d72000  ! 2500: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	mov	0x70, %r18
	.word 0xd0ac4400  ! 2502: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0xde848400  ! 2503: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	.word 0xde8f2000  ! 2504: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xdedf6000  ! 2505: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xd6a78e60  ! 2506: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0xd6df6000  ! 2507: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6c7a000  ! 2508: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	mov	0x38, %r17
	.word 0x87802073  ! 2510: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r19
	.word 0xdcc74e40  ! 2512: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r14
	.word 0xdc9fa000  ! 2513: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0xd6d78e40  ! 2514: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r11
	.word 0xd2a78e80  ! 2515: STWA_R	stwa	%r9, [%r30 + %r0] 0x74
	.word 0xded7ce80  ! 2516: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r15
	.word 0x87802072  ! 2517: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 2518: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdec7e000  ! 2519: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xde87a000  ! 2520: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xd4ae09e0  ! 2521: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0xd4afe000  ! 2522: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd8af4e40  ! 2523: STBA_R	stba	%r12, [%r29 + %r0] 0x72
	mov	0x7e8, %r23
	.word 0xd8d76000  ! 2525: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	mov	0x7e0, %r23
	.word 0x87802074  ! 2527: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2528: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8dfa000  ! 2529: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8874e80  ! 2530: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r12
	.word 0xd8c7e000  ! 2531: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	mov	0x48, %r27
	.word 0x87802025  ! 2533: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd89d2000  ! 2534: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r12
	.word 0xd8a5a000  ! 2535: STWA_I	stwa	%r12, [%r22 + 0x0000] %asi
	.word 0xdcf74e40  ! 2536: STXA_R	stxa	%r14, [%r29 + %r0] 0x72
	.word 0xdcdda000  ! 2537: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r14
	.word 0xdcade000  ! 2538: STBA_I	stba	%r14, [%r23 + 0x0000] %asi
	.word 0xd2a78e80  ! 2539: STWA_R	stwa	%r9, [%r30 + %r0] 0x74
	.word 0xd0b78e40  ! 2540: STHA_R	stha	%r8, [%r30 + %r0] 0x72
	mov	0x3e0, %r22
	wr_tick_cmpr_0_36:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x92, %g2
	or	%g4, 0xa6, %g4
	or	%g6, 0xe8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0b5a000  ! 2543: STHA_I	stha	%r8, [%r22 + 0x0000] %asi
	.word 0xd0bf4e60  ! 2544: STDA_R	stda	%r8, [%r29 + %r0] 0x73
	mov	0x7f8, %r21
	.word 0xd0ad6000  ! 2546: STBA_I	stba	%r8, [%r21 + 0x0000] %asi
	.word 0xd2c584a0  ! 2547: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r9
	.word 0xd2ade000  ! 2548: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0xd2956000  ! 2549: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2550: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cf8e60  ! 2551: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r8
	.word 0xd0a46000  ! 2552: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 2553: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0b56000  ! 2554: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	.word 0xdec544a0  ! 2555: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r15
	.word 0xdef5a000  ! 2556: STXA_I	stxa	%r15, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 2557: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r27
	.word 0xdea7a000  ! 2559: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	mov	0x30, %r19
	.word 0xded72000  ! 2561: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	mov	0x50, %r19
	.word 0xdac44400  ! 2563: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r13
	mov	0x7c0, %r21
	mov	0x3f0, %r21
	.word 0xdadcc400  ! 2566: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xd8978e40  ! 2567: LDUHA_R	lduha	[%r30, %r0] 0x72, %r12
	.word 0xd8b76000  ! 2568: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	mov	0x58, %r25
	.word 0x87802020  ! 2570: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbd04a0  ! 2571: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	.word 0xd8d689e0  ! 2572: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r12
	.word 0xdcbf0e60  ! 2573: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	.word 0x8780204f  ! 2574: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r24
	.word 0xd8f74e60  ! 2576: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	.word 0xd8be6000  ! 2577: STDA_I	stda	%r12, [%r25 + 0x0000] %asi
	.word 0xdca5c4a0  ! 2578: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	.word 0x87802020  ! 2579: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb584a0  ! 2580: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	.word 0xdeb609e0  ! 2581: STHA_R	stha	%r15, [%r24 + %r0] 0x4f
	.word 0xd4970e80  ! 2582: LDUHA_R	lduha	[%r28, %r0] 0x74, %r10
	.word 0xd2940400  ! 2583: LDUHA_R	lduha	[%r16, %r0] 0x20, %r9
	.word 0x8780204f  ! 2584: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bee000  ! 2585: STDA_I	stda	%r9, [%r27 + 0x0000] %asi
	.word 0xd896c9e0  ! 2586: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r12
	.word 0x87802073  ! 2587: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f8, %r20
	.word 0x87802073  ! 2589: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f72000  ! 2590: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 2591: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6a78e60  ! 2592: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0xd68ea000  ! 2593: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r11
	.word 0xd6b6e000  ! 2594: STHA_I	stha	%r11, [%r27 + 0x0000] %asi
	mov	0x70, %r24
	.word 0xd4c584a0  ! 2596: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r10
	mov	0x3e8, %r22
	.word 0xdec74e80  ! 2598: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r15
	.word 0xdebee000  ! 2599: STDA_I	stda	%r15, [%r27 + 0x0000] %asi
	mov	0x7f8, %r20
	.word 0xde86a000  ! 2601: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r15
	mov	0x20, %r25
	mov	0x78, %r24
	.word 0xd48f8e80  ! 2604: LDUBA_R	lduba	[%r30, %r0] 0x74, %r10
	.word 0xd0a78e60  ! 2605: STWA_R	stwa	%r8, [%r30 + %r0] 0x73
	.word 0xd29f4e60  ! 2606: LDDA_R	ldda	[%r29, %r0] 0x73, %r9
	mov	0x10, %r18
	.word 0xd2ce2000  ! 2608: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r9
	.word 0xdaafce60  ! 2609: STBA_R	stba	%r13, [%r31 + %r0] 0x73
	.word 0xdaaee000  ! 2610: STBA_I	stba	%r13, [%r27 + 0x0000] %asi
	.word 0xdab66000  ! 2611: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0xdaa66000  ! 2612: STWA_I	stwa	%r13, [%r25 + 0x0000] %asi
	.word 0xdabe6000  ! 2613: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	.word 0xdab78e60  ! 2614: STHA_R	stha	%r13, [%r30 + %r0] 0x73
	.word 0xdad66000  ! 2615: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r13
	.word 0xd2d7ce60  ! 2616: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r9
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd286a000  ! 2618: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 2619: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8df4e40  ! 2620: LDXA_R	ldxa	[%r29, %r0] 0x72, %r12
	.word 0xd8aee000  ! 2621: STBA_I	stba	%r12, [%r27 + 0x0000] %asi
	.word 0x8780204f  ! 2622: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2623: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8946000  ! 2624: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	.word 0xd8a42000  ! 2625: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8b4a000  ! 2626: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0xd4d649e0  ! 2627: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r10
	.word 0xd4bce000  ! 2628: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0xd494e000  ! 2629: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	.word 0xdabd44a0  ! 2630: STDA_R	stda	%r13, [%r21 + %r0] 0x25
	.word 0xda94a000  ! 2631: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	.word 0x87802072  ! 2632: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 2633: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda852000  ! 2634: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r13
	.word 0xdaad2000  ! 2635: STBA_I	stba	%r13, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 2636: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 2637: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r27
	.word 0xd68f4e40  ! 2639: LDUBA_R	lduba	[%r29, %r0] 0x72, %r11
	.word 0xd6c6e000  ! 2640: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r11
	.word 0xd6ce2000  ! 2641: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	.word 0xde8544a0  ! 2642: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r15
	mov	0x7c8, %r23
	.word 0xdcf48400  ! 2644: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0x87802072  ! 2645: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcafa000  ! 2646: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xdcdf0e40  ! 2647: LDXA_R	ldxa	[%r28, %r0] 0x72, %r14
	.word 0xdaf70e80  ! 2648: STXA_R	stxa	%r13, [%r28 + %r0] 0x74
	.word 0x87802073  ! 2649: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdabfe000  ! 2650: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 2651: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 2652: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc874e80  ! 2653: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r14
	.word 0x87802073  ! 2654: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc8fa000  ! 2655: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdc9fe000  ! 2656: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xdc96c9e0  ! 2657: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r14
	ta	T_CHANGE_PRIV	! macro
	mov	0x70, %r24
	.word 0x87802020  ! 2660: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2661: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc94e000  ! 2662: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	.word 0xdc84e000  ! 2663: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2664: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb42000  ! 2665: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 2666: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2667: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x10, %r25
	.word 0x87802020  ! 2670: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9c6000  ! 2671: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r14
	.word 0xd8f78e60  ! 2672: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	.word 0x87802073  ! 2673: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8a72000  ! 2674: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd0df8e60  ! 2675: LDXA_R	ldxa	[%r30, %r0] 0x73, %r8
	.word 0xd8f6c9e0  ! 2676: STXA_R	stxa	%r12, [%r27 + %r0] 0x4f
	.word 0xd8cfa000  ! 2677: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd0b7ce40  ! 2678: STHA_R	stha	%r8, [%r31 + %r0] 0x72
	.word 0xd0b76000  ! 2679: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	mov	0x3d0, %r21
	.word 0xd0cfa000  ! 2681: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0xd0f40400  ! 2682: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xd2c74e60  ! 2683: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r9
	.word 0xd2a76000  ! 2684: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 2685: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 2686: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2cda000  ! 2687: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r9
	.word 0xd2dda000  ! 2688: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r9
	.word 0xd2ada000  ! 2689: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0x87802073  ! 2690: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2d76000  ! 2691: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	mov	0x7c8, %r22
	.word 0xd2a7e000  ! 2693: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	mov	0x58, %r27
	mov	0x18, %r16
	.word 0xd2afa000  ! 2696: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xd2af6000  ! 2697: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd2bfe000  ! 2698: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd28f6000  ! 2699: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd2c7a000  ! 2700: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2a7e000  ! 2701: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 2702: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0c544a0  ! 2703: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r8
	.word 0x87802072  ! 2704: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8f74e80  ! 2705: STXA_R	stxa	%r12, [%r29 + %r0] 0x74
	.word 0xdea78e60  ! 2706: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	.word 0xdea72000  ! 2707: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xda9e49e0  ! 2708: LDDA_R	ldda	[%r25, %r0] 0x4f, %r13
	.word 0xdadf6000  ! 2709: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	mov	0x40, %r24
	.word 0x87802025  ! 2711: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8d84a0  ! 2712: LDUBA_R	lduba	[%r22, %r0] 0x25, %r13
	mov	0x70, %r26
	.word 0xd6a78e60  ! 2714: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0xd4f78e40  ! 2715: STXA_R	stxa	%r10, [%r30 + %r0] 0x72
	wr_tick_cmpr_0_37:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x98, %g2
	or	%g4, 0xc4, %g4
	or	%g6, 0xc4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x60, %r26
	.word 0xd4bde000  ! 2718: STDA_I	stda	%r10, [%r23 + 0x0000] %asi
	mov	0x68, %r27
	mov	0x58, %r26
	.word 0xd48e49e0  ! 2721: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r10
	.word 0xd4ad04a0  ! 2722: STBA_R	stba	%r10, [%r20 + %r0] 0x25
	.word 0xd4a609e0  ! 2723: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	mov	0x60, %r24
	.word 0xd0a7ce40  ! 2725: STWA_R	stwa	%r8, [%r31 + %r0] 0x72
	.word 0x87802020  ! 2726: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r19
	.word 0xdcc44400  ! 2728: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xdcac6000  ! 2729: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xdcc42000  ! 2730: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r14
	.word 0xdcac2000  ! 2731: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0xdcaca000  ! 2733: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 2734: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc87a000  ! 2735: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	ta	T_CHANGE_HPRIV	! macro
	.word 0x8780204f  ! 2737: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcc66000  ! 2738: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	.word 0x87802072  ! 2739: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcc72000  ! 2740: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xd68d44a0  ! 2741: LDUBA_R	lduba	[%r21, %r0] 0x25, %r11
	.word 0xd6afe000  ! 2742: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xdac609e0  ! 2743: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r13
	.word 0xde8d44a0  ! 2744: LDUBA_R	lduba	[%r21, %r0] 0x25, %r15
	.word 0xd0c4c400  ! 2745: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	.word 0xd0f7ce60  ! 2746: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	.word 0xdedfce40  ! 2747: LDXA_R	ldxa	[%r31, %r0] 0x72, %r15
	.word 0xd0cc8400  ! 2748: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0xd68584a0  ! 2749: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r11
	mov	0x40, %r26
	mov	0x48, %r16
	.word 0xd6dfa000  ! 2752: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2753: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2754: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r25
	.word 0xd6f7a000  ! 2756: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 2757: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6976000  ! 2758: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	.word 0xd6d7e000  ! 2759: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	.word 0xd6f72000  ! 2760: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	mov	0x30, %r16
	.word 0xd8b74e60  ! 2762: STHA_R	stha	%r12, [%r29 + %r0] 0x73
	.word 0xd8a7a000  ! 2763: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	mov	0x40, %r25
	.word 0x87802073  ! 2765: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd897a000  ! 2766: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0xdeaf8e80  ! 2767: STBA_R	stba	%r15, [%r30 + %r0] 0x74
	mov	0x8, %r19
	.word 0xdeafa000  ! 2769: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xde8649e0  ! 2770: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r15
	.word 0xdabec9e0  ! 2771: STDA_R	stda	%r13, [%r27 + %r0] 0x4f
	mov	0x7d8, %r22
	mov	0x3e0, %r22
	.word 0x8780204f  ! 2774: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r17
	.word 0xda9ea000  ! 2776: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r13
	mov	0x18, %r18
	.word 0xda9e6000  ! 2778: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r13
	.word 0xd0ad44a0  ! 2779: STBA_R	stba	%r8, [%r21 + %r0] 0x25
	.word 0xd68c0400  ! 2780: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	.word 0xd6f62000  ! 2781: STXA_I	stxa	%r11, [%r24 + 0x0000] %asi
	mov	0x50, %r25
	.word 0xd6ae6000  ! 2783: STBA_I	stba	%r11, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 2784: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f40400  ! 2785: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xd0b46000  ! 2786: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	mov	0x8, %r16
	mov	0x38, %r26
	mov	0x48, %r24
	.word 0xdaafce40  ! 2790: STBA_R	stba	%r13, [%r31 + %r0] 0x72
	mov	0x10, %r25
	.word 0x87802025  ! 2792: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda9fce40  ! 2793: LDDA_R	ldda	[%r31, %r0] 0x72, %r13
	.word 0xdaa52000  ! 2794: STWA_I	stwa	%r13, [%r20 + 0x0000] %asi
	mov	0x68, %r19
	.word 0xdea7ce60  ! 2796: STWA_R	stwa	%r15, [%r31 + %r0] 0x73
	.word 0xdebde000  ! 2797: STDA_I	stda	%r15, [%r23 + 0x0000] %asi
	.word 0xdedd6000  ! 2798: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r15
	.word 0xdead2000  ! 2799: STBA_I	stba	%r15, [%r20 + 0x0000] %asi
	.word 0xdeac0400  ! 2800: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xdecd6000  ! 2801: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r15
	.word 0xdcf40400  ! 2802: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0x87802074  ! 2803: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f4c400  ! 2804: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	mov	0x78, %r24
	.word 0xd6a40400  ! 2806: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	mov	0x40, %r24
	.word 0xd6bf6000  ! 2808: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 2809: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 2810: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r24
	.word 0xd6bf2000  ! 2812: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	mov	0x48, %r19
	mov	0x68, %r27
	.word 0xd6a76000  ! 2815: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	mov	0x78, %r16
	mov	0x38, %r25
	.word 0xd6f72000  ! 2818: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd68fa000  ! 2820: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0xd2de09e0  ! 2821: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r9
	.word 0xd2978e60  ! 2822: LDUHA_R	lduha	[%r30, %r0] 0x73, %r9
	.word 0xd2f4c400  ! 2823: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	mov	0x3d0, %r22
	.word 0xd2f72000  ! 2825: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2826: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r24
	mov	0x48, %r27
	.word 0x87802072  ! 2829: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b72000  ! 2830: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 2831: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f8, %r23
	.word 0xdc940400  ! 2833: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0xdca72000  ! 2834: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	mov	0x38, %r18
	mov	0x50, %r27
	.word 0xdcf48400  ! 2837: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0x87802074  ! 2838: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd29c4400  ! 2839: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	.word 0xd2af2000  ! 2840: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 2841: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6af4e60  ! 2842: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	.word 0xd6afe000  ! 2843: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x68, %r27
	mov	0x58, %r19
	.word 0xd4f6c9e0  ! 2846: STXA_R	stxa	%r10, [%r27 + %r0] 0x4f
	.word 0xd8df0e80  ! 2847: LDXA_R	ldxa	[%r28, %r0] 0x74, %r12
	.word 0xd8d7e000  ! 2848: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0xd8872000  ! 2849: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8d7a000  ! 2850: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	mov	0x48, %r16
	.word 0xd8bfe000  ! 2852: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd8d7e000  ! 2853: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	mov	0x18, %r24
	.word 0xd8df2000  ! 2855: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xd89fa000  ! 2856: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	.word 0xd8b76000  ! 2857: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	mov	0x8, %r16
	.word 0x8780204f  ! 2859: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd8978e60  ! 2861: LDUHA_R	lduha	[%r30, %r0] 0x73, %r12
	.word 0xd8f6e000  ! 2862: STXA_I	stxa	%r12, [%r27 + 0x0000] %asi
	.word 0x87802025  ! 2863: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8b56000  ! 2864: STHA_I	stha	%r12, [%r21 + 0x0000] %asi
	.word 0xd8f5a000  ! 2865: STXA_I	stxa	%r12, [%r22 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802074  ! 2867: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8cfe000  ! 2868: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2869: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2870: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2871: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f78e60  ! 2872: STXA_R	stxa	%r8, [%r30 + %r0] 0x73
	.word 0xd0f40400  ! 2873: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xd4d78e60  ! 2874: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r10
	.word 0x87802025  ! 2875: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde978e40  ! 2876: LDUHA_R	lduha	[%r30, %r0] 0x72, %r15
	mov	0x40, %r27
	.word 0x87802020  ! 2878: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_0_38:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf1, %g2
	or	%g4, 0xea, %g4
	or	%g6, 0xa5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xde94e000  ! 2880: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	mov	0x38, %r19
	mov	0x18, %r16
	.word 0xd0af4e60  ! 2883: STBA_R	stba	%r8, [%r29 + %r0] 0x73
	.word 0xd0a4e000  ! 2884: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0b42000  ! 2885: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xd0af4e80  ! 2886: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	mov	0x10, %r16
	wr_tick_cmpr_0_39:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa2, %g2
	or	%g4, 0xb4, %g4
	or	%g6, 0xa2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0f4a000  ! 2889: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xd0d4a000  ! 2891: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	mov	0x20, %r24
	.word 0xde84c400  ! 2893: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0xdcc48400  ! 2894: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r14
	.word 0x87802025  ! 2895: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf5e000  ! 2896: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0xdec584a0  ! 2897: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r15
	mov	0x8, %r17
	.word 0xd6af0e60  ! 2899: STBA_R	stba	%r11, [%r28 + %r0] 0x73
	.word 0x87802073  ! 2900: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6a609e0  ! 2901: STWA_R	stwa	%r11, [%r24 + %r0] 0x4f
	.word 0xd2d40400  ! 2902: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	mov	0x58, %r25
	.word 0x87802072  ! 2904: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2cfa000  ! 2905: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	.word 0xd2f7e000  ! 2906: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd2dfa000  ! 2907: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	mov	0x38, %r27
	mov	0x78, %r25
	mov	0x30, %r16
	.word 0x87802020  ! 2911: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bc0400  ! 2912: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0xd0842000  ! 2913: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r8
	.word 0x87802020  ! 2914: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r27
	.word 0xd2bc0400  ! 2916: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xdc9cc400  ! 2917: LDDA_R	ldda	[%r19, %r0] 0x20, %r14
	.word 0xdca4a000  ! 2918: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 2919: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcc6a000  ! 2920: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r14
	.word 0x87802074  ! 2921: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd484c400  ! 2922: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	.word 0xdc87ce80  ! 2923: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r14
	.word 0x87802020  ! 2924: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cc0400  ! 2925: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r11
	.word 0xd6f4e000  ! 2926: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	.word 0xd68c6000  ! 2927: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r11
	mov	0x70, %r27
	mov	0x50, %r24
	.word 0xd0b48400  ! 2930: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xdea5c4a0  ! 2931: STWA_R	stwa	%r15, [%r23 + %r0] 0x25
	.word 0xd0bc0400  ! 2932: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0xd0b42000  ! 2933: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	mov	0x3d0, %r21
	mov	0x8, %r25
	mov	0x38, %r27
	.word 0xdcc5c4a0  ! 2937: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r14
	mov	0x0, %r18
	.word 0x87802025  ! 2939: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbde000  ! 2940: STDA_I	stda	%r14, [%r23 + 0x0000] %asi
	.word 0xdcf5a000  ! 2941: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 2942: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2943: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2944: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf7e000  ! 2945: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xd6bf4e80  ! 2946: STDA_R	stda	%r11, [%r29 + %r0] 0x74
	mov	0x28, %r16
	.word 0x87802074  ! 2948: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r17
	.word 0xdeaf8e40  ! 2950: STBA_R	stba	%r15, [%r30 + %r0] 0x72
	.word 0xdc840400  ! 2951: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	.word 0xdab7ce40  ! 2952: STHA_R	stha	%r13, [%r31 + %r0] 0x72
	mov	0x7e8, %r23
	.word 0x87802020  ! 2954: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa42000  ! 2955: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0xdaa4e000  ! 2956: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0xd0c4c400  ! 2957: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	mov	0x3c8, %r22
	mov	0x3d8, %r21
	.word 0xdac7ce40  ! 2960: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r13
	.word 0xdaf4e000  ! 2961: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xdabce000  ! 2962: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0xd2a74e40  ! 2963: STWA_R	stwa	%r9, [%r29 + %r0] 0x72
	.word 0xd2d4a000  ! 2964: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	.word 0xda9fce60  ! 2965: LDDA_R	ldda	[%r31, %r0] 0x73, %r13
	.word 0xde9f0e80  ! 2966: LDDA_R	ldda	[%r28, %r0] 0x74, %r15
	.word 0xdcb584a0  ! 2967: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	.word 0xd6b40400  ! 2968: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xd0f70e60  ! 2969: STXA_R	stxa	%r8, [%r28 + %r0] 0x73
	.word 0xd0dc2000  ! 2970: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	mov	0x68, %r26
	.word 0x87802074  ! 2972: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0af2000  ! 2973: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd8f78e80  ! 2974: STXA_R	stxa	%r12, [%r30 + %r0] 0x74
	.word 0xd897e000  ! 2975: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8dfa000  ! 2977: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2978: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28d44a0  ! 2979: LDUBA_R	lduba	[%r21, %r0] 0x25, %r9
	.word 0xd8af4e60  ! 2980: STBA_R	stba	%r12, [%r29 + %r0] 0x73
	.word 0x87802073  ! 2981: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca44400  ! 2982: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0xdead04a0  ! 2983: STBA_R	stba	%r15, [%r20 + %r0] 0x25
	mov	0x3d8, %r20
	.word 0xde87a000  ! 2985: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0x87802074  ! 2986: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2987: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_0_40:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x8a, %g2
	or	%g4, 0xc6, %g4
	or	%g6, 0x8b, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdcbc0400  ! 2989: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0xdccc2000  ! 2990: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r14
	.word 0xd4b544a0  ! 2991: STHA_R	stha	%r10, [%r21 + %r0] 0x25
	.word 0xd4a4a000  ! 2992: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xdc9f8e40  ! 2993: LDDA_R	ldda	[%r30, %r0] 0x72, %r14
	mov	0x3d8, %r23
	.word 0xd0b544a0  ! 2995: STHA_R	stha	%r8, [%r21 + %r0] 0x25
	.word 0xd6f74e60  ! 2996: STXA_R	stxa	%r11, [%r29 + %r0] 0x73
	.word 0xd6ace000  ! 2997: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0xd6b74e80  ! 2998: STHA_R	stha	%r11, [%r29 + %r0] 0x74
	.word 0xd2d40400  ! 2999: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	mov	0x20, %r18
	.word 0xded74e40  ! 3001: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r15
	.word 0xd6bcc400  ! 3002: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0xd6a46000  ! 3003: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	mov	0x58, %r24
	.word 0x87802073  ! 3005: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c8, %r20
	.word 0xd4ac4400  ! 3007: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	mov	0x50, %r24
	.word 0xd4f76000  ! 3009: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	mov	0x40, %r26
	.word 0xd4b72000  ! 3011: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd4dd04a0  ! 3012: LDXA_R	ldxa	[%r20, %r0] 0x25, %r10
	.word 0xdecf8e40  ! 3013: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r15
	mov	0x0, %r18
	.word 0x87802020  ! 3015: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef4e000  ! 3016: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xde946000  ! 3017: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3018: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r22
	ta	T_CHANGE_PRIV	! macro
	.word 0xdc8c8400  ! 3021: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0x87802025  ! 3022: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf5a000  ! 3023: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	mov	0x40, %r26
	.word 0x87802072  ! 3025: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3026: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4948400  ! 3027: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	.word 0xd4cce000  ! 3028: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	.word 0xd4a46000  ! 3029: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	mov	0x30, %r27
	.word 0xd4f4e000  ! 3031: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	mov	0x7e0, %r22
	.word 0xd4d4e000  ! 3033: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0x87802020  ! 3034: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ae89e0  ! 3035: STBA_R	stba	%r11, [%r26 + %r0] 0x4f
	.word 0x87802072  ! 3036: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6afa000  ! 3037: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x28, %r25
	.word 0xd697a000  ! 3039: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0xd6bf2000  ! 3040: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	mov	0x20, %r26
	.word 0x87802072  ! 3042: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b7e000  ! 3043: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd68fa000  ! 3044: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0x87802072  ! 3045: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2bdc4a0  ! 3046: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	.word 0xd29fe000  ! 3047: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	mov	0x18, %r18
	.word 0x87802020  ! 3049: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cfce80  ! 3050: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r11
	.word 0xd2ac4400  ! 3051: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xd28c6000  ! 3052: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	mov	0x7e8, %r22
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdc8fce60  ! 3055: LDUBA_R	lduba	[%r31, %r0] 0x73, %r14
	.word 0xdcf70e40  ! 3056: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	.word 0xded78e60  ! 3057: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r15
	.word 0xdebca000  ! 3058: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xdea46000  ! 3059: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xdeaf0e60  ! 3060: STBA_R	stba	%r15, [%r28 + %r0] 0x73
	.word 0xde9ce000  ! 3061: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0x87802025  ! 3062: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r16
	.word 0xd4b70e40  ! 3064: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	mov	0x48, %r25
	.word 0xd4dde000  ! 3066: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r10
	.word 0xdcaf4e60  ! 3067: STBA_R	stba	%r14, [%r29 + %r0] 0x73
	.word 0x87802073  ! 3068: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r19
	.word 0xd6a40400  ! 3070: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0xd2bcc400  ! 3071: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xded48400  ! 3072: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	.word 0xd6a544a0  ! 3073: STWA_R	stwa	%r11, [%r21 + %r0] 0x25
	.word 0xd6f7a000  ! 3074: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6c72000  ! 3075: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6f70e40  ! 3076: STXA_R	stxa	%r11, [%r28 + %r0] 0x72
	mov	0x7d0, %r21
	.word 0xd8af4e60  ! 3078: STBA_R	stba	%r12, [%r29 + %r0] 0x73
	.word 0xd09fce80  ! 3079: LDDA_R	ldda	[%r31, %r0] 0x74, %r8
	mov	0x70, %r18
	mov	0x3d8, %r23
	.word 0xd0ae49e0  ! 3082: STBA_R	stba	%r8, [%r25 + %r0] 0x4f
	.word 0xd08f2000  ! 3083: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	.word 0xd08fce40  ! 3084: LDUBA_R	lduba	[%r31, %r0] 0x72, %r8
	.word 0x8780204f  ! 3085: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd09ee000  ! 3086: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r8
	.word 0xd08ee000  ! 3087: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r8
	.word 0xd4a504a0  ! 3088: STWA_R	stwa	%r10, [%r20 + %r0] 0x25
	.word 0xd4862000  ! 3089: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r10
	mov	0x38, %r25
	.word 0x87802072  ! 3091: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f8, %r21
	.word 0x87802020  ! 3093: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r21
	mov	0x8, %r27
	mov	0x28, %r26
	.word 0xda9d44a0  ! 3097: LDDA_R	ldda	[%r21, %r0] 0x25, %r13
	.word 0xd8c70e80  ! 3098: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r12
	.word 0xd4c78e60  ! 3099: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r10
	.word 0xd4a4a000  ! 3100: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd89d04a0  ! 3102: LDDA_R	ldda	[%r20, %r0] 0x25, %r12
	.word 0xd8942000  ! 3103: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r12
	.word 0xd49d04a0  ! 3104: LDDA_R	ldda	[%r20, %r0] 0x25, %r10
	.word 0xd4d46000  ! 3105: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r10
	.word 0xdacfce40  ! 3106: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r13
	.word 0xd4d44400  ! 3107: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	mov	0x68, %r17
	.word 0x8780204f  ! 3109: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4ae2000  ! 3110: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0xd0b4c400  ! 3112: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0xd48f0e40  ! 3113: LDUBA_R	lduba	[%r28, %r0] 0x72, %r10
	.word 0xd4966000  ! 3114: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r10
	.word 0x87802074  ! 3115: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 3116: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f689e0  ! 3117: STXA_R	stxa	%r10, [%r26 + %r0] 0x4f
	.word 0xd28f8e60  ! 3118: LDUBA_R	lduba	[%r30, %r0] 0x73, %r9
	mov	0x3e0, %r22
	mov	0x7f8, %r20
	mov	0x38, %r18
	.word 0xd28cc400  ! 3122: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	.word 0xd2b66000  ! 3123: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	.word 0xd2cc4400  ! 3124: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r9
	.word 0xdc8cc400  ! 3125: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	.word 0xdcbee000  ! 3126: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	.word 0xdcaee000  ! 3127: STBA_I	stba	%r14, [%r27 + 0x0000] %asi
	.word 0xdcd66000  ! 3128: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r14
	mov	0x20, %r19
	.word 0xd6b44400  ! 3130: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xd6d66000  ! 3131: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r11
	mov	0x78, %r18
	.word 0xd2c609e0  ! 3133: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r9
	.word 0xd6be89e0  ! 3134: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	mov	0x38, %r24
	.word 0xd6cea000  ! 3136: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	mov	0x60, %r27
	mov	0x3d0, %r21
	.word 0x87802025  ! 3139: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e8, %r21
	.word 0xd6a4c400  ! 3141: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0xd6ad6000  ! 3142: STBA_I	stba	%r11, [%r21 + 0x0000] %asi
	.word 0xd6d52000  ! 3143: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r11
	.word 0xd6b56000  ! 3144: STHA_I	stha	%r11, [%r21 + 0x0000] %asi
	.word 0xd28689e0  ! 3145: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r9
	.word 0x87802074  ! 3146: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c0, %r23
	.word 0xd68f0e40  ! 3148: LDUBA_R	lduba	[%r28, %r0] 0x72, %r11
	.word 0xd6c7ce40  ! 3149: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r11
	mov	0x18, %r24
	.word 0xd0bf0e60  ! 3151: STDA_R	stda	%r8, [%r28 + %r0] 0x73
	mov	0x78, %r25
	.word 0xd0af2000  ! 3153: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0f76000  ! 3154: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0b76000  ! 3155: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xded74e40  ! 3156: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r15
	.word 0xdebfe000  ! 3157: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xdef72000  ! 3158: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 3159: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd09cc400  ! 3160: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	.word 0xd0cd6000  ! 3161: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r8
	.word 0xd0d52000  ! 3162: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r8
	.word 0xdead44a0  ! 3163: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	.word 0xd2870e80  ! 3164: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r9
	mov	0x18, %r24
	.word 0x87802020  ! 3166: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_0_41:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xd5, %g2
	or	%g4, 0xa7, %g4
	or	%g6, 0xe5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2ac2000  ! 3168: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 3169: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r20
	.word 0x87802073  ! 3171: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3172: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 3173: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r25
	.word 0xdeb649e0  ! 3175: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	.word 0x87802073  ! 3176: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde972000  ! 3177: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0xd6b74e80  ! 3178: STHA_R	stha	%r11, [%r29 + %r0] 0x74
	.word 0xd68c0400  ! 3179: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	.word 0x87802025  ! 3180: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde874e80  ! 3181: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r15
	.word 0xda8649e0  ! 3182: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r13
	.word 0xd8f70e80  ! 3183: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd8cd6000  ! 3185: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r12
	.word 0x87802020  ! 3186: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bc6000  ! 3187: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0xd8f4e000  ! 3188: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xd894a000  ! 3189: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r12
	.word 0xd8b42000  ! 3190: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	.word 0xd8f4e000  ! 3191: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 3192: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d4e000  ! 3193: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0xd8cc6000  ! 3194: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r12
	.word 0xd8842000  ! 3195: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	mov	0x40, %r25
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x60, %r26
	.word 0x87802072  ! 3199: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8c7e000  ! 3200: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0xd28fce80  ! 3201: LDUBA_R	lduba	[%r31, %r0] 0x74, %r9
	.word 0xd2a72000  ! 3202: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0xda948400  ! 3203: LDUHA_R	lduha	[%r18, %r0] 0x20, %r13
	.word 0xd28f4e40  ! 3204: LDUBA_R	lduba	[%r29, %r0] 0x72, %r9
	.word 0xd09689e0  ! 3205: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r8
	mov	0x70, %r27
	.word 0xd0cf6000  ! 3207: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd0f76000  ! 3208: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	mov	0x7e0, %r21
	.word 0xd29f0e60  ! 3210: LDDA_R	ldda	[%r28, %r0] 0x73, %r9
	.word 0xd6d70e80  ! 3211: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r11
	.word 0xd6cf0e80  ! 3212: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r11
	mov	0x7e0, %r23
	.word 0xd6bf2000  ! 3214: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd687e000  ! 3215: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6f76000  ! 3216: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6876000  ! 3217: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	mov	0x30, %r24
	.word 0xd8d78e40  ! 3219: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r12
	.word 0x87802020  ! 3220: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb4c400  ! 3221: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xdedce000  ! 3222: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r15
	.word 0xde84e000  ! 3223: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	.word 0xdea4a000  ! 3224: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xdc8c0400  ! 3226: LDUBA_R	lduba	[%r16, %r0] 0x20, %r14
	.word 0x87802073  ! 3227: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r24
	.word 0xdc8fa000  ! 3229: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdcf76000  ! 3230: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xd8bf0e80  ! 3231: STDA_R	stda	%r12, [%r28 + %r0] 0x74
	mov	0x3f0, %r23
	.word 0xd89f2000  ! 3233: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0xd8bfe000  ! 3234: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 3235: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88ca000  ! 3236: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	.word 0x87802073  ! 3237: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 3238: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 3239: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bda000  ! 3240: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	.word 0x87802025  ! 3241: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde8f8e40  ! 3242: LDUBA_R	lduba	[%r30, %r0] 0x72, %r15
	.word 0xd094c400  ! 3243: LDUHA_R	lduha	[%r19, %r0] 0x20, %r8
	.word 0x87802020  ! 3244: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ad44a0  ! 3245: STBA_R	stba	%r8, [%r21 + %r0] 0x25
	.word 0xd0bc0400  ! 3246: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	mov	0x40, %r16
	.word 0x8780204f  ! 3248: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8df0e60  ! 3249: LDXA_R	ldxa	[%r28, %r0] 0x73, %r12
	mov	0x7d8, %r23
	mov	0x3e0, %r22
	.word 0xd6974e60  ! 3252: LDUHA_R	lduha	[%r29, %r0] 0x73, %r11
	mov	0x0, %r24
	.word 0xd0970e60  ! 3254: LDUHA_R	lduha	[%r28, %r0] 0x73, %r8
	.word 0xd08e6000  ! 3255: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r8
	mov	0x48, %r27
	.word 0xd0978e80  ! 3257: LDUHA_R	lduha	[%r30, %r0] 0x74, %r8
	.word 0xd0bea000  ! 3258: STDA_I	stda	%r8, [%r26 + 0x0000] %asi
	.word 0xd2cf8e60  ! 3259: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r9
	.word 0xd2cee000  ! 3260: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	.word 0x87802072  ! 3261: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 3262: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r16
	.word 0xdebfce40  ! 3264: STDA_R	stda	%r15, [%r31 + %r0] 0x72
	.word 0xdebfa000  ! 3265: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xdebfa000  ! 3266: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xd0bd44a0  ! 3267: STDA_R	stda	%r8, [%r21 + %r0] 0x25
	mov	0x48, %r26
	.word 0xd8af8e60  ! 3269: STBA_R	stba	%r12, [%r30 + %r0] 0x73
	.word 0xdeb74e40  ! 3270: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	.word 0xd29e09e0  ! 3271: LDDA_R	ldda	[%r24, %r0] 0x4f, %r9
	.word 0xd2d78e80  ! 3272: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r9
	.word 0xdcaf4e40  ! 3273: STBA_R	stba	%r14, [%r29 + %r0] 0x72
	.word 0xdcc7a000  ! 3274: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	mov	0x50, %r24
	.word 0xdcafe000  ! 3276: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdcc72000  ! 3277: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xd2c7ce80  ! 3278: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r9
	wr_tick_cmpr_0_42:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf1, %g2
	or	%g4, 0xa5, %g4
	or	%g6, 0xe7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8dc0400  ! 3280: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0xd6a70e80  ! 3281: STWA_R	stwa	%r11, [%r28 + %r0] 0x74
	.word 0xd6f7a000  ! 3282: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6a72000  ! 3283: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd69f2000  ! 3284: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xd4c40400  ! 3285: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	.word 0xdec74e80  ! 3286: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r15
	.word 0xd6c78e80  ! 3287: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r11
	.word 0xd4878e80  ! 3288: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r10
	.word 0xd8c5c4a0  ! 3289: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r12
	mov	0x30, %r18
	.word 0xd89fe000  ! 3291: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	mov	0x3e8, %r20
	.word 0xd8f7a000  ! 3293: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xdaddc4a0  ! 3294: LDXA_R	ldxa	[%r23, %r0] 0x25, %r13
	mov	0x38, %r17
	.word 0xd8f48400  ! 3296: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xd8afce80  ! 3297: STBA_R	stba	%r12, [%r31 + %r0] 0x74
	.word 0xd897e000  ! 3298: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	mov	0x0, %r19
	.word 0xd8f76000  ! 3300: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8c7e000  ! 3301: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0x87802020  ! 3302: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c42000  ! 3303: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r12
	.word 0xde940400  ! 3304: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0x87802020  ! 3305: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8c2000  ! 3306: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	mov	0x7c8, %r20
	mov	0x18, %r26
	.word 0xd09f8e80  ! 3309: LDDA_R	ldda	[%r30, %r0] 0x74, %r8
	.word 0x87802020  ! 3310: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3311: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r26
	.word 0xd0aca000  ! 3313: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xd0a4e000  ! 3314: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd8ac4400  ! 3315: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xdeaf0e40  ! 3316: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	mov	0x58, %r17
	mov	0x3c8, %r20
	mov	0x50, %r27
	mov	0x38, %r19
	mov	0x78, %r24
	.word 0xda8e49e0  ! 3322: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r13
	.word 0xdadce000  ! 3323: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xd8afce40  ! 3324: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	mov	0x28, %r19
	mov	0x10, %r25
	.word 0xd8d4a000  ! 3327: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xded78e60  ! 3328: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r15
	.word 0xde946000  ! 3329: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r15
	mov	0x38, %r25
	.word 0x87802072  ! 3331: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde9f2000  ! 3332: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	mov	0x28, %r17
	mov	0x78, %r16
	.word 0xd2ddc4a0  ! 3335: LDXA_R	ldxa	[%r23, %r0] 0x25, %r9
	.word 0x87802072  ! 3336: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd89544a0  ! 3337: LDUHA_R	lduha	[%r21, %r0] 0x25, %r12
	.word 0xd8f72000  ! 3338: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	mov	0x7d0, %r22
	.word 0x87802074  ! 3340: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3341: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r16
	.word 0xd8f4e000  ! 3343: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xd68f4e40  ! 3344: LDUBA_R	lduba	[%r29, %r0] 0x72, %r11
	.word 0xd8f7ce80  ! 3345: STXA_R	stxa	%r12, [%r31 + %r0] 0x74
	.word 0xd4a78e40  ! 3346: STWA_R	stwa	%r10, [%r30 + %r0] 0x72
	.word 0xdc9dc4a0  ! 3347: LDDA_R	ldda	[%r23, %r0] 0x25, %r14
	.word 0xdcbc2000  ! 3348: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	mov	0x60, %r27
	.word 0xde848400  ! 3350: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	mov	0x10, %r16
	.word 0x87802074  ! 3352: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 3353: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 3354: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde87a000  ! 3355: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xdeaf2000  ! 3356: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xd4f78e60  ! 3357: STXA_R	stxa	%r10, [%r30 + %r0] 0x73
	.word 0xdecf4e60  ! 3358: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r15
	.word 0xd6c48400  ! 3359: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	.word 0xd6bcc400  ! 3360: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	mov	0x3f8, %r21
	.word 0xd6c76000  ! 3362: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6af2000  ! 3363: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd0c6c9e0  ! 3364: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r8
	.word 0xdcf689e0  ! 3365: STXA_R	stxa	%r14, [%r26 + %r0] 0x4f
	mov	0x7e0, %r21
	.word 0xdc8fa000  ! 3367: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0x87802073  ! 3368: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6cfce40  ! 3369: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r11
	.word 0xdabec9e0  ! 3370: STDA_R	stda	%r13, [%r27 + %r0] 0x4f
	.word 0xdaa7a000  ! 3371: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xdaf7a000  ! 3372: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdab7e000  ! 3373: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xdc948400  ! 3374: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	.word 0x87802025  ! 3375: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc956000  ! 3376: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r14
	.word 0xdcc56000  ! 3377: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r14
	mov	0x7e8, %r23
	.word 0x8780204f  ! 3379: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc870e80  ! 3380: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r14
	.word 0xdcb6a000  ! 3381: STHA_I	stha	%r14, [%r26 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xdcf6a000  ! 3383: STXA_I	stxa	%r14, [%r26 + 0x0000] %asi
	mov	0x48, %r19
	.word 0xdcae6000  ! 3385: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	mov	0x8, %r16
	.word 0xdc8f0e60  ! 3387: LDUBA_R	lduba	[%r28, %r0] 0x73, %r14
	mov	0x7d8, %r20
	.word 0xdc862000  ! 3389: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r14
	mov	0x18, %r16
	.word 0x87802020  ! 3391: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3392: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88c0400  ! 3393: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	.word 0x87802020  ! 3394: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4afce80  ! 3395: STBA_R	stba	%r10, [%r31 + %r0] 0x74
	.word 0xd4bc2000  ! 3396: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 3397: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3398: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6df0e80  ! 3399: LDXA_R	ldxa	[%r28, %r0] 0x74, %r11
	.word 0xd0bd44a0  ! 3400: STDA_R	stda	%r8, [%r21 + %r0] 0x25
	.word 0xdcbf0e40  ! 3401: STDA_R	stda	%r14, [%r28 + %r0] 0x72
	.word 0xd6a504a0  ! 3402: STWA_R	stwa	%r11, [%r20 + %r0] 0x25
	mov	0x0, %r16
	.word 0x8780204f  ! 3404: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdadf0e80  ! 3405: LDXA_R	ldxa	[%r28, %r0] 0x74, %r13
	mov	0x7d0, %r22
	.word 0xda966000  ! 3407: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r13
	.word 0xdab66000  ! 3408: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0xdab6e000  ! 3409: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 3410: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaac6000  ! 3411: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	.word 0xdaac2000  ! 3412: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	mov	0x70, %r16
	.word 0x87802072  ! 3414: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r25
	.word 0x8780204f  ! 3416: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4d7ce40  ! 3417: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r10
	.word 0xd4ae6000  ! 3418: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0xd49e2000  ! 3419: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r10
	.word 0xd2bd84a0  ! 3420: STDA_R	stda	%r9, [%r22 + %r0] 0x25
	.word 0x87802074  ! 3421: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbf8e40  ! 3422: STDA_R	stda	%r14, [%r30 + %r0] 0x72
	mov	0x3d0, %r21
	.word 0xd8ae09e0  ! 3424: STBA_R	stba	%r12, [%r24 + %r0] 0x4f
	.word 0xd8bf6000  ! 3425: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	mov	0x20, %r17
	.word 0xd28f8e60  ! 3427: LDUBA_R	lduba	[%r30, %r0] 0x73, %r9
	.word 0xd2a7e000  ! 3428: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 3429: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r26
	.word 0xd6c5c4a0  ! 3431: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r11
	.word 0xd6bf6000  ! 3432: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xd6afe000  ! 3434: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xdcdf8e60  ! 3435: LDXA_R	ldxa	[%r30, %r0] 0x73, %r14
	.word 0x87802020  ! 3436: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 3437: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6acc400  ! 3438: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0x87802072  ! 3439: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6a72000  ! 3440: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6bfe000  ! 3441: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xdca544a0  ! 3442: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0xdca76000  ! 3443: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xd6a74e60  ! 3445: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	mov	0x3d0, %r21
	.word 0x87802073  ! 3447: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f0, %r20
	.word 0xd4b40400  ! 3449: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	wr_tick_cmpr_0_43:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xa1, %g2
	or	%g4, 0xba, %g4
	or	%g6, 0xab, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4c76000  ! 3451: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	.word 0xd8a584a0  ! 3452: STWA_R	stwa	%r12, [%r22 + %r0] 0x25
	.word 0xd8a76000  ! 3453: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8c76000  ! 3454: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	.word 0x87802025  ! 3455: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8cda000  ! 3456: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r12
	.word 0xd2d5c4a0  ! 3457: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r9
	.word 0xd2b5e000  ! 3458: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	.word 0xd2b5e000  ! 3459: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	.word 0xd2bd2000  ! 3460: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	.word 0xd0f74e80  ! 3461: STXA_R	stxa	%r8, [%r29 + %r0] 0x74
	.word 0xd6a70e60  ! 3462: STWA_R	stwa	%r11, [%r28 + %r0] 0x73
	mov	0x3f8, %r21
	.word 0xd0be89e0  ! 3464: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	.word 0xd09f4e60  ! 3465: LDDA_R	ldda	[%r29, %r0] 0x73, %r8
	mov	0x0, %r19
	.word 0xd0c5e000  ! 3467: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r8
	.word 0xd0b5a000  ! 3468: STHA_I	stha	%r8, [%r22 + 0x0000] %asi
	.word 0xd0dda000  ! 3469: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r8
	.word 0x87802020  ! 3470: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r27
	.word 0xd0dc6000  ! 3472: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	mov	0x70, %r26
	mov	0x10, %r18
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0cc6000  ! 3476: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	.word 0xd0bc6000  ! 3477: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 3478: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd09f6000  ! 3479: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	.word 0xd0872000  ! 3480: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	mov	0x8, %r26
	.word 0xd4bdc4a0  ! 3482: STDA_R	stda	%r10, [%r23 + %r0] 0x25
	.word 0xd48f2000  ! 3483: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd2afce40  ! 3484: STBA_R	stba	%r9, [%r31 + %r0] 0x72
	.word 0xd297a000  ! 3485: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	.word 0xd2b72000  ! 3486: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd6bc4400  ! 3487: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	mov	0x68, %r16
	.word 0xdaf48400  ! 3489: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xde878e80  ! 3490: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r15
	.word 0xd295c4a0  ! 3491: LDUHA_R	lduha	[%r23, %r0] 0x25, %r9
	mov	0x60, %r16
	.word 0xd2afa000  ! 3493: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xdef44400  ! 3494: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xd2b44400  ! 3495: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	mov	0x70, %r18
	.word 0xd2d7a000  ! 3497: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0xd2ae49e0  ! 3498: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	.word 0x87802072  ! 3499: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f40400  ! 3500: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	mov	0x3c8, %r23
	.word 0xd4c40400  ! 3502: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	mov	0x3c8, %r22
	.word 0xd4f72000  ! 3504: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd8c48400  ! 3505: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	.word 0xd8a74e40  ! 3506: STWA_R	stwa	%r12, [%r29 + %r0] 0x72
	mov	0x60, %r26
	.word 0xdef48400  ! 3508: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	mov	0x30, %r27
	mov	0x70, %r18
	.word 0x87802074  ! 3511: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 3512: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4d4c400  ! 3513: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0xd4b7a000  ! 3514: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 3515: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2d584a0  ! 3516: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r9
	mov	0x7c0, %r23
	.word 0xd487ce40  ! 3518: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r10
	mov	0x7e8, %r23
	.word 0x87802072  ! 3520: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r19
	.word 0x87802020  ! 3522: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 3523: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r24
	.word 0xdcbc4400  ! 3525: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	mov	0x7e0, %r21
	.word 0xdc85a000  ! 3527: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r14
	.word 0xdccd2000  ! 3528: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r14
	mov	0x20, %r25
	mov	0x50, %r27
	.word 0xde97ce40  ! 3531: LDUHA_R	lduha	[%r31, %r0] 0x72, %r15
	.word 0xdeb52000  ! 3532: STHA_I	stha	%r15, [%r20 + 0x0000] %asi
	.word 0xdaccc400  ! 3533: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r13
	.word 0xdc9c0400  ! 3534: LDDA_R	ldda	[%r16, %r0] 0x20, %r14
	mov	0x58, %r26
	.word 0x87802020  ! 3536: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r25
	.word 0xd6cf4e80  ! 3538: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r11
	.word 0xd6d42000  ! 3539: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3540: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b42000  ! 3541: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 3542: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r26
	.word 0xd6cfe000  ! 3544: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0x87802072  ! 3545: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6bf2000  ! 3546: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xdc9fce60  ! 3547: LDDA_R	ldda	[%r31, %r0] 0x73, %r14
	.word 0x87802020  ! 3548: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcac6000  ! 3549: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xdcf4a000  ! 3550: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdca4a000  ! 3551: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0xd4bf0e60  ! 3552: STDA_R	stda	%r10, [%r28 + %r0] 0x73
	.word 0xd08dc4a0  ! 3553: LDUBA_R	lduba	[%r23, %r0] 0x25, %r8
	.word 0xd0a42000  ! 3554: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	mov	0x8, %r27
	.word 0x87802020  ! 3556: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0dca000  ! 3557: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0b42000  ! 3558: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xd0b42000  ! 3559: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	mov	0x18, %r27
	mov	0x58, %r27
	mov	0x48, %r24
	.word 0xd2b6c9e0  ! 3563: STHA_R	stha	%r9, [%r27 + %r0] 0x4f
	.word 0x87802072  ! 3564: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r27
	mov	0x30, %r27
	.word 0xd28fe000  ! 3567: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	.word 0xd8a70e60  ! 3568: STWA_R	stwa	%r12, [%r28 + %r0] 0x73
	.word 0xd8c7e000  ! 3569: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0x87802074  ! 3570: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdadd84a0  ! 3571: LDXA_R	ldxa	[%r22, %r0] 0x25, %r13
	.word 0xdaad44a0  ! 3572: STBA_R	stba	%r13, [%r21 + %r0] 0x25
	.word 0x87802073  ! 3573: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa544a0  ! 3574: STWA_R	stwa	%r13, [%r21 + %r0] 0x25
	.word 0xdaf7e000  ! 3575: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 3576: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6a78e40  ! 3577: STWA_R	stwa	%r11, [%r30 + %r0] 0x72
	.word 0xd68fa000  ! 3578: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	mov	0x10, %r17
	.word 0xd69f6000  ! 3580: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	.word 0xd0a544a0  ! 3581: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	.word 0x87802072  ! 3582: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r16
	.word 0x87802020  ! 3584: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0846000  ! 3585: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 3586: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd09ee000  ! 3587: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r8
	.word 0xd0d6e000  ! 3588: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r8
	.word 0xd0b6a000  ! 3589: STHA_I	stha	%r8, [%r26 + 0x0000] %asi
	mov	0x7f8, %r20
	mov	0x7d0, %r20
	.word 0xdab74e60  ! 3592: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	mov	0x8, %r18
	.word 0xd6af0e60  ! 3594: STBA_R	stba	%r11, [%r28 + %r0] 0x73
	.word 0xd8bd04a0  ! 3595: STDA_R	stda	%r12, [%r20 + %r0] 0x25
	.word 0xd8b6a000  ! 3596: STHA_I	stha	%r12, [%r26 + 0x0000] %asi
	.word 0xdc97ce80  ! 3597: LDUHA_R	lduha	[%r31, %r0] 0x74, %r14
	.word 0xdcdee000  ! 3598: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r14
	.word 0xdcbee000  ! 3599: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	mov	0x3f8, %r23
	.word 0xdadc8400  ! 3601: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	.word 0xdeb584a0  ! 3602: STHA_R	stha	%r15, [%r22 + %r0] 0x25
	.word 0xdea6a000  ! 3603: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0xd0af4e40  ! 3605: STBA_R	stba	%r8, [%r29 + %r0] 0x72
	.word 0xd0dea000  ! 3606: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r8
	.word 0xd0f6e000  ! 3607: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	.word 0xd0f62000  ! 3608: STXA_I	stxa	%r8, [%r24 + 0x0000] %asi
	mov	0x18, %r19
	.word 0xd0a6a000  ! 3610: STWA_I	stwa	%r8, [%r26 + 0x0000] %asi
	.word 0xd0dee000  ! 3611: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r8
	mov	0x50, %r25
	.word 0x87802073  ! 3613: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc940400  ! 3614: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0xd4d609e0  ! 3615: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r10
	mov	0x28, %r17
	.word 0xde8609e0  ! 3617: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r15
	mov	0x7d0, %r23
	.word 0xd0cf4e80  ! 3619: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r8
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd6dfce40  ! 3621: LDXA_R	ldxa	[%r31, %r0] 0x72, %r11
	mov	0x68, %r27
	.word 0x87802074  ! 3623: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 3624: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd6bf2000  ! 3626: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd6a7e000  ! 3627: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	mov	0x7f8, %r23
	mov	0x28, %r16
	mov	0x48, %r19
	.word 0x87802025  ! 3631: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6c5a000  ! 3632: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r11
	.word 0xd6a56000  ! 3633: STWA_I	stwa	%r11, [%r21 + 0x0000] %asi
	.word 0xd6bd2000  ! 3634: STDA_I	stda	%r11, [%r20 + 0x0000] %asi
	.word 0xd4b7ce60  ! 3635: STHA_R	stha	%r10, [%r31 + %r0] 0x73
	.word 0xd4c56000  ! 3636: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r10
	.word 0xd2ddc4a0  ! 3637: LDXA_R	ldxa	[%r23, %r0] 0x25, %r9
	mov	0x70, %r27
	.word 0x87802025  ! 3639: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f0, %r23
	.word 0xd8d649e0  ! 3641: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r12
	.word 0xd2df8e80  ! 3642: LDXA_R	ldxa	[%r30, %r0] 0x74, %r9
	mov	0x28, %r26
	.word 0xdef544a0  ! 3644: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	.word 0xdaa48400  ! 3645: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	wr_tick_cmpr_0_44:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xee, %g2
	or	%g4, 0xab, %g4
	or	%g6, 0xbd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0874e40  ! 3647: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r8
	.word 0xdabcc400  ! 3648: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	.word 0x87802020  ! 3649: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda94e000  ! 3650: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r13
	mov	0x3c0, %r22
	.word 0xdab70e80  ! 3652: STHA_R	stha	%r13, [%r28 + %r0] 0x74
	.word 0xd6978e80  ! 3653: LDUHA_R	lduha	[%r30, %r0] 0x74, %r11
	.word 0xd6cc6000  ! 3654: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r11
	.word 0xd6ace000  ! 3655: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	wr_tick_cmpr_0_45:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xa2, %g2
	or	%g4, 0xa8, %g4
	or	%g6, 0xfc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd684e000  ! 3657: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r11
	.word 0xd6a4a000  ! 3658: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	.word 0xde9cc400  ! 3659: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	.word 0xd2d44400  ! 3660: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r9
	mov	0x50, %r26
	.word 0xd2d46000  ! 3662: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	.word 0xdca40400  ! 3663: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xdec78e80  ! 3664: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r15
	.word 0xdebca000  ! 3665: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xde944400  ! 3666: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	.word 0x8780204f  ! 3667: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r26
	.word 0x87802020  ! 3669: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29c4400  ! 3670: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	.word 0xd4c78e80  ! 3671: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r10
	.word 0xd49ca000  ! 3672: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd09e09e0  ! 3673: LDDA_R	ldda	[%r24, %r0] 0x4f, %r8
	.word 0x87802073  ! 3674: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda97ce80  ! 3675: LDUHA_R	lduha	[%r31, %r0] 0x74, %r13
	.word 0xdabf2000  ! 3676: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 3677: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda946000  ! 3678: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x7c8, %r23
	.word 0xdeb689e0  ! 3681: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	.word 0xdebc6000  ! 3682: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	mov	0x18, %r18
	.word 0xdec42000  ! 3684: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0xd6bf4e80  ! 3685: STDA_R	stda	%r11, [%r29 + %r0] 0x74
	.word 0xd6d4a000  ! 3686: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r11
	.word 0x87802074  ! 3687: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd68fa000  ! 3688: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0x87802072  ! 3689: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2afce60  ! 3690: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	.word 0xd6bf0e40  ! 3691: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	.word 0xdaf70e60  ! 3692: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	mov	0x7d0, %r23
	.word 0xd8f504a0  ! 3694: STXA_R	stxa	%r12, [%r20 + %r0] 0x25
	.word 0xd88fa000  ! 3695: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0xdabf0e80  ! 3696: STDA_R	stda	%r13, [%r28 + %r0] 0x74
	.word 0xdadf6000  ! 3697: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 3698: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeafce80  ! 3699: STBA_R	stba	%r15, [%r31 + %r0] 0x74
	.word 0xde86a000  ! 3700: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r15
	.word 0xdac40400  ! 3701: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	.word 0xda9ee000  ! 3702: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r13
	.word 0xd8f689e0  ! 3703: STXA_R	stxa	%r12, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 3704: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8af6000  ! 3705: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd4df0e40  ! 3706: LDXA_R	ldxa	[%r28, %r0] 0x72, %r10
	mov	0x48, %r26
	.word 0xd4afe000  ! 3708: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd4bf0e80  ! 3709: STDA_R	stda	%r10, [%r28 + %r0] 0x74
	.word 0xd2af8e80  ! 3710: STBA_R	stba	%r9, [%r30 + %r0] 0x74
	mov	0x68, %r18
	.word 0xd2bfe000  ! 3712: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xdef70e40  ! 3713: STXA_R	stxa	%r15, [%r28 + %r0] 0x72
	.word 0xd2c7ce40  ! 3714: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r9
	.word 0xdcf74e80  ! 3715: STXA_R	stxa	%r14, [%r29 + %r0] 0x74
	.word 0xd8874e80  ! 3716: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r12
	.word 0x87802073  ! 3717: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3718: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d42000  ! 3719: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	mov	0x78, %r24
	.word 0xd88c6000  ! 3721: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	mov	0x68, %r19
	mov	0x70, %r18
	.word 0x87802020  ! 3724: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccf4e40  ! 3725: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r14
	mov	0x68, %r24
	.word 0xd8844400  ! 3727: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r12
	.word 0x87802072  ! 3728: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc8e89e0  ! 3729: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r14
	mov	0x40, %r16
	.word 0xdca72000  ! 3731: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 3732: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbca000  ! 3733: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdcaca000  ! 3734: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xd0a70e60  ! 3735: STWA_R	stwa	%r8, [%r28 + %r0] 0x73
	mov	0x18, %r16
	.word 0xd0ac6000  ! 3737: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 3738: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6cf8e40  ! 3739: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r11
	mov	0x0, %r25
	.word 0xd087ce80  ! 3741: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r8
	.word 0xd0f7a000  ! 3742: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	mov	0x0, %r18
	.word 0xd0bc8400  ! 3744: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0x87802074  ! 3745: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0872000  ! 3746: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	mov	0x7f0, %r21
	.word 0x87802073  ! 3748: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e0, %r23
	.word 0x87802074  ! 3750: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd097a000  ! 3751: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	mov	0x0, %r18
	.word 0xd8878e80  ! 3753: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r12
	.word 0xd8bfa000  ! 3754: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd6b70e60  ! 3755: STHA_R	stha	%r11, [%r28 + %r0] 0x73
	.word 0xdeaf0e60  ! 3756: STBA_R	stba	%r15, [%r28 + %r0] 0x73
	.word 0xdedf6000  ! 3757: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xd88d04a0  ! 3758: LDUBA_R	lduba	[%r20, %r0] 0x25, %r12
	.word 0xd8b7e000  ! 3759: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0xd6af0e60  ! 3760: STBA_R	stba	%r11, [%r28 + %r0] 0x73
	.word 0x87802025  ! 3761: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f52000  ! 3762: STXA_I	stxa	%r11, [%r20 + 0x0000] %asi
	.word 0xd4dd84a0  ! 3763: LDXA_R	ldxa	[%r22, %r0] 0x25, %r10
	.word 0xd48d2000  ! 3764: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0xdacd04a0  ! 3765: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r13
	mov	0x48, %r19
	.word 0xdaa56000  ! 3767: STWA_I	stwa	%r13, [%r21 + 0x0000] %asi
	.word 0xd487ce80  ! 3768: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r10
	.word 0xd4b5e000  ! 3769: STHA_I	stha	%r10, [%r23 + 0x0000] %asi
	mov	0x8, %r18
	.word 0xdcbf8e80  ! 3771: STDA_R	stda	%r14, [%r30 + %r0] 0x74
	mov	0x7e0, %r22
	.word 0xdadf4e60  ! 3773: LDXA_R	ldxa	[%r29, %r0] 0x73, %r13
	.word 0xdc8d44a0  ! 3774: LDUBA_R	lduba	[%r21, %r0] 0x25, %r14
	.word 0x87802072  ! 3775: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde95c4a0  ! 3776: LDUHA_R	lduha	[%r23, %r0] 0x25, %r15
	.word 0xdedfe000  ! 3777: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0x87802074  ! 3778: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdea72000  ! 3779: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	mov	0x18, %r17
	.word 0xdedfa000  ! 3781: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xde8f2000  ! 3782: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	mov	0x60, %r24
	.word 0x87802074  ! 3784: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdedfa000  ! 3785: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xd6cc0400  ! 3786: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r11
	mov	0x3c8, %r21
	mov	0x3f0, %r22
	.word 0xd6df6000  ! 3789: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6a76000  ! 3790: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd68fa000  ! 3791: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0xd0a70e80  ! 3792: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0x87802073  ! 3793: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3794: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r27
	mov	0x28, %r27
	.word 0xd0846000  ! 3797: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0xd08ca000  ! 3798: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	mov	0x7d0, %r21
	mov	0x3c0, %r23
	.word 0xd6bc8400  ! 3801: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	mov	0x28, %r25
	.word 0xd69ca000  ! 3803: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r11
	.word 0xd6f42000  ! 3804: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	.word 0xd6bc2000  ! 3805: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	mov	0x60, %r16
	mov	0x3c0, %r23
	.word 0x87802025  ! 3808: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6cda000  ! 3809: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r11
	.word 0xd2de49e0  ! 3810: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r9
	.word 0xd4bc8400  ! 3811: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	.word 0xd4f5a000  ! 3812: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0xd4a5a000  ! 3814: STWA_I	stwa	%r10, [%r22 + 0x0000] %asi
	.word 0xd6acc400  ! 3815: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xdad78e60  ! 3816: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r13
	.word 0xd8ad84a0  ! 3817: STBA_R	stba	%r12, [%r22 + %r0] 0x25
	.word 0xd6d504a0  ! 3818: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r11
	.word 0xd0a70e40  ! 3819: STWA_R	stwa	%r8, [%r28 + %r0] 0x72
	.word 0xdc8cc400  ! 3820: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	mov	0x40, %r18
	mov	0x3f0, %r22
	.word 0xdca52000  ! 3823: STWA_I	stwa	%r14, [%r20 + 0x0000] %asi
	.word 0xd2df8e80  ! 3824: LDXA_R	ldxa	[%r30, %r0] 0x74, %r9
	.word 0xd0f7ce80  ! 3825: STXA_R	stxa	%r8, [%r31 + %r0] 0x74
	.word 0x87802074  ! 3826: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcaec9e0  ! 3827: STBA_R	stba	%r14, [%r27 + %r0] 0x4f
	mov	0x7f8, %r22
	.word 0xdc9fe000  ! 3829: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0x87802073  ! 3830: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r26
	mov	0x7d8, %r21
	.word 0xd4f74e80  ! 3833: STXA_R	stxa	%r10, [%r29 + %r0] 0x74
	.word 0x8780204f  ! 3834: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4966000  ! 3835: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 3836: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b6a000  ! 3837: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	mov	0x7c0, %r22
	.word 0xd496a000  ! 3839: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r10
	.word 0xdca7ce60  ! 3840: STWA_R	stwa	%r14, [%r31 + %r0] 0x73
	.word 0x87802074  ! 3841: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xdc9fa000  ! 3843: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	mov	0x60, %r17
	mov	0x8, %r17
	.word 0x87802020  ! 3846: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb46000  ! 3847: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xdcf4a000  ! 3848: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdc9ce000  ! 3849: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r14
	.word 0xdcf4e000  ! 3850: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcd70e40  ! 3851: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r14
	.word 0xdc842000  ! 3852: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	mov	0x0, %r19
	.word 0xd6b78e80  ! 3854: STHA_R	stha	%r11, [%r30 + %r0] 0x74
	.word 0xd6cc6000  ! 3855: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 3856: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd686a000  ! 3857: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r11
	.word 0xd6ce2000  ! 3858: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	.word 0xd6bea000  ! 3859: STDA_I	stda	%r11, [%r26 + 0x0000] %asi
	mov	0x3e0, %r20
	.word 0xd68504a0  ! 3861: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r11
	.word 0xd2a4c400  ! 3862: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0x87802020  ! 3863: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3864: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 3865: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 3866: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 3867: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 3868: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r25
	.word 0xdaaec9e0  ! 3870: STBA_R	stba	%r13, [%r27 + %r0] 0x4f
	.word 0xdaa56000  ! 3871: STWA_I	stwa	%r13, [%r21 + 0x0000] %asi
	mov	0x3d0, %r22
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xda952000  ! 3874: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r13
	.word 0xdab56000  ! 3875: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802025  ! 3877: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r16
	mov	0x30, %r24
	.word 0xdab56000  ! 3880: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xdab5a000  ! 3882: STHA_I	stha	%r13, [%r22 + 0x0000] %asi
	.word 0xda8d2000  ! 3883: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r13
	mov	0x78, %r25
	wr_tick_cmpr_0_46:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa6, %g2
	or	%g4, 0xda, %g4
	or	%g6, 0xed, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd294c400  ! 3886: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	.word 0xd2d52000  ! 3887: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r9
	.word 0xd2f56000  ! 3888: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	.word 0xd2a544a0  ! 3889: STWA_R	stwa	%r9, [%r21 + %r0] 0x25
	.word 0xd4dc8400  ! 3890: LDXA_R	ldxa	[%r18, %r0] 0x20, %r10
	.word 0xd4bd6000  ! 3891: STDA_I	stda	%r10, [%r21 + 0x0000] %asi
	.word 0xdc86c9e0  ! 3892: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r14
	.word 0xdcc74e40  ! 3893: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r14
	.word 0xdccd6000  ! 3894: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r14
	mov	0x40, %r24
	.word 0x87802020  ! 3896: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 3897: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8cd44a0  ! 3898: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r12
	mov	0x7c8, %r22
	mov	0x0, %r24
	.word 0xd88ea000  ! 3901: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r12
	mov	0x30, %r25
	.word 0xd8be2000  ! 3903: STDA_I	stda	%r12, [%r24 + 0x0000] %asi
	.word 0xd8d6a000  ! 3904: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r12
	.word 0xd8d62000  ! 3905: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r12
	mov	0x60, %r27
	mov	0x38, %r24
	.word 0xd89ee000  ! 3908: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r12
	.word 0xd8b6e000  ! 3909: STHA_I	stha	%r12, [%r27 + 0x0000] %asi
	.word 0xd0cfce40  ! 3910: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r8
	.word 0xd0a62000  ! 3911: STWA_I	stwa	%r8, [%r24 + 0x0000] %asi
	mov	0x3f0, %r21
	.word 0xd09ee000  ! 3913: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r8
	.word 0xd0b62000  ! 3914: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0x87802025  ! 3915: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 3916: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b74e40  ! 3917: STHA_R	stha	%r11, [%r29 + %r0] 0x72
	.word 0xd6c6a000  ! 3918: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3919: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69ca000  ! 3920: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r11
	.word 0xd6acc400  ! 3921: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xd6a4e000  ! 3922: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 3923: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r25
	.word 0xd4bf4e40  ! 3925: STDA_R	stda	%r10, [%r29 + %r0] 0x72
	.word 0xd4b7a000  ! 3926: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd4afa000  ! 3927: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 3928: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r26
	.word 0xd0bd04a0  ! 3930: STDA_R	stda	%r8, [%r20 + %r0] 0x25
	.word 0xd0c72000  ! 3931: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xd08e49e0  ! 3932: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r8
	.word 0xd087e000  ! 3933: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0xdeaf4e60  ! 3934: STBA_R	stba	%r15, [%r29 + %r0] 0x73
	.word 0xdeafa000  ! 3935: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xdeb7e000  ! 3936: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xdcbf8e40  ! 3937: STDA_R	stda	%r14, [%r30 + %r0] 0x72
	.word 0xdcaf0e60  ! 3938: STBA_R	stba	%r14, [%r28 + %r0] 0x73
	mov	0x30, %r27
	.word 0xd08e49e0  ! 3940: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r8
	.word 0xd0f5c4a0  ! 3941: STXA_R	stxa	%r8, [%r23 + %r0] 0x25
	.word 0xd0af2000  ! 3942: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	mov	0x50, %r24
	.word 0xd0bf2000  ! 3944: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	mov	0x78, %r27
	.word 0xd8978e60  ! 3946: LDUHA_R	lduha	[%r30, %r0] 0x73, %r12
	.word 0xd2974e40  ! 3947: LDUHA_R	lduha	[%r29, %r0] 0x72, %r9
	.word 0xd2bf6000  ! 3948: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	mov	0x40, %r19
	.word 0xd0bc4400  ! 3950: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0x87802020  ! 3951: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3952: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r25
	.word 0xd0bfe000  ! 3954: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xde94c400  ! 3955: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	mov	0x10, %r26
	.word 0xdeaf2000  ! 3957: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0xde87e000  ! 3959: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 3960: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeaea000  ! 3961: STBA_I	stba	%r15, [%r26 + 0x0000] %asi
	.word 0xdebe6000  ! 3962: STDA_I	stda	%r15, [%r25 + 0x0000] %asi
	.word 0xdcbf8e40  ! 3963: STDA_R	stda	%r14, [%r30 + %r0] 0x72
	.word 0xd6c689e0  ! 3964: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r11
	.word 0xd69e6000  ! 3965: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r11
	.word 0x87802025  ! 3966: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 3967: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b72000  ! 3968: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	mov	0x40, %r25
	.word 0xd0a4c400  ! 3970: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xd0d7a000  ! 3971: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0xd0a76000  ! 3972: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	mov	0x78, %r26
	mov	0x40, %r25
	.word 0xd0f76000  ! 3975: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd297ce80  ! 3976: LDUHA_R	lduha	[%r31, %r0] 0x74, %r9
	.word 0xd2a7e000  ! 3977: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 3978: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2a7a000  ! 3979: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xdcbe89e0  ! 3980: STDA_R	stda	%r14, [%r26 + %r0] 0x4f
	mov	0x78, %r25
	.word 0xdc97e000  ! 3982: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	mov	0x0, %r17
	mov	0x30, %r18
	wr_tick_cmpr_0_47:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xc3, %g2
	or	%g4, 0x9d, %g4
	or	%g6, 0xef, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdab689e0  ! 3986: STHA_R	stha	%r13, [%r26 + %r0] 0x4f
	.word 0xd4ad84a0  ! 3987: STBA_R	stba	%r10, [%r22 + %r0] 0x25
	mov	0x8, %r17
	.word 0xdef7ce60  ! 3989: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0xd6b74e80  ! 3990: STHA_R	stha	%r11, [%r29 + %r0] 0x74
	.word 0xd6bf2000  ! 3991: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd6afa000  ! 3992: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 3993: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd687a000  ! 3994: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0xd68f2000  ! 3995: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0x87802025  ! 3996: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6ad2000  ! 3997: STBA_I	stba	%r11, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 3998: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ace000  ! 3999: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	mov	0x3d8, %r22
	.word 0xd6f4e000  ! 4001: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	mov	0x28, %r17
	.word 0xd6a46000  ! 4003: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	mov	0x20, %r25
	mov	0x7d8, %r22
	mov	0x48, %r24
	.word 0xd6846000  ! 4007: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r11
	.word 0xd6f42000  ! 4008: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	.word 0xd6a4a000  ! 4009: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 4010: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r27
	.word 0xd6ce2000  ! 4012: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	mov	0x18, %r27
	.word 0x8780204f  ! 4014: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f584a0  ! 4015: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	mov	0x48, %r27
	mov	0x28, %r27
	.word 0xd0862000  ! 4018: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r8
	mov	0x3f8, %r23
	.word 0xdef78e40  ! 4020: STXA_R	stxa	%r15, [%r30 + %r0] 0x72
	.word 0xded6e000  ! 4021: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r15
	.word 0xdec66000  ! 4022: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r15
	.word 0xd0f78e60  ! 4023: STXA_R	stxa	%r8, [%r30 + %r0] 0x73
	.word 0x87802020  ! 4024: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c44400  ! 4025: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r10
	.word 0x87802020  ! 4026: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d78e80  ! 4027: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r11
	.word 0x87802020  ! 4028: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f42000  ! 4029: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	.word 0xdaaf8e60  ! 4030: STBA_R	stba	%r13, [%r30 + %r0] 0x73
	.word 0xdaf4e000  ! 4031: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xdab4a000  ! 4032: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 4033: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc844400  ! 4034: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	.word 0x87802073  ! 4035: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4036: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r18
	.word 0xdcb42000  ! 4038: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	mov	0x3e0, %r20
	.word 0xda9dc4a0  ! 4040: LDDA_R	ldda	[%r23, %r0] 0x25, %r13
	mov	0x8, %r27
	.word 0xdaa544a0  ! 4042: STWA_R	stwa	%r13, [%r21 + %r0] 0x25
	.word 0xda9c6000  ! 4043: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xd6840400  ! 4044: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	mov	0x3c8, %r22
	.word 0xd0f78e80  ! 4046: STXA_R	stxa	%r8, [%r30 + %r0] 0x74
	.word 0xd4f44400  ! 4047: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0xd48ca000  ! 4048: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r10
	mov	0x60, %r26
	.word 0xd4cca000  ! 4050: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r10
	.word 0xd4a4a000  ! 4051: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 4052: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdab7ce60  ! 4053: STHA_R	stha	%r13, [%r31 + %r0] 0x73
	.word 0x87802020  ! 4054: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa42000  ! 4055: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 4056: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 4057: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda8fa000  ! 4058: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xd28d44a0  ! 4059: LDUBA_R	lduba	[%r21, %r0] 0x25, %r9
	.word 0xd4f70e80  ! 4060: STXA_R	stxa	%r10, [%r28 + %r0] 0x74
	.word 0xdebcc400  ! 4061: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	.word 0x87802020  ! 4062: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f74e60  ! 4063: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	.word 0xd8ac6000  ! 4064: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xdcbfce60  ! 4065: STDA_R	stda	%r14, [%r31 + %r0] 0x73
	.word 0x87802072  ! 4066: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4d6c9e0  ! 4067: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r10
	.word 0xd4a7e000  ! 4068: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	mov	0x3f8, %r22
	mov	0x60, %r27
	.word 0xdeae49e0  ! 4071: STBA_R	stba	%r15, [%r25 + %r0] 0x4f
	mov	0x3d8, %r20
	.word 0xdedfe000  ! 4073: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xd4840400  ! 4074: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	.word 0x87802072  ! 4075: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b74e80  ! 4076: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	.word 0xd8f7a000  ! 4077: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8f72000  ! 4078: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8f76000  ! 4079: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8cfe000  ! 4080: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8afe000  ! 4081: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xdeb7ce40  ! 4082: STHA_R	stha	%r15, [%r31 + %r0] 0x72
	.word 0xdea72000  ! 4083: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xded72000  ! 4085: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xdeb72000  ! 4086: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xdca70e80  ! 4087: STWA_R	stwa	%r14, [%r28 + %r0] 0x74
	.word 0xdc876000  ! 4088: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	mov	0x70, %r18
	.word 0x87802074  ! 4090: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb7e000  ! 4091: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xd09fce60  ! 4092: LDDA_R	ldda	[%r31, %r0] 0x73, %r8
	.word 0xdcdfce80  ! 4093: LDXA_R	ldxa	[%r31, %r0] 0x74, %r14
	.word 0xd89c4400  ! 4094: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	.word 0xd6848400  ! 4095: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	.word 0x8780204f  ! 4096: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 4097: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6966000  ! 4098: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r11
	mov	0x60, %r27
	mov	0x0, %r17
	mov	0x3d8, %r20
	.word 0x87802074  ! 4102: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r18
	.word 0x8780204f  ! 4104: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebc8400  ! 4105: STDA_R	stda	%r15, [%r18 + %r0] 0x20
	mov	0x3d8, %r23
	.word 0xdeac8400  ! 4107: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xded7ce40  ! 4108: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r15
	.word 0xda9c4400  ! 4109: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	.word 0xd6c6c9e0  ! 4110: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r11
	.word 0x87802025  ! 4111: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6dd6000  ! 4112: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r11
	.word 0xd6dd6000  ! 4113: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r11
	.word 0xdcf689e0  ! 4114: STXA_R	stxa	%r14, [%r26 + %r0] 0x4f
	.word 0xd6df4e60  ! 4115: LDXA_R	ldxa	[%r29, %r0] 0x73, %r11
	.word 0xdaf78e80  ! 4116: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	.word 0x87802073  ! 4117: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r17
	mov	0x7e0, %r22
	.word 0xd4dfce60  ! 4120: LDXA_R	ldxa	[%r31, %r0] 0x73, %r10
	mov	0x7f0, %r22
	.word 0xd49fe000  ! 4122: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd49f2000  ! 4123: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd8c544a0  ! 4124: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r12
	mov	0x7f8, %r20
	.word 0xd2940400  ! 4126: LDUHA_R	lduha	[%r16, %r0] 0x20, %r9
	.word 0xd48584a0  ! 4127: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r10
	.word 0xdac70e80  ! 4128: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r13
	.word 0xda8f6000  ! 4129: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xda9fa000  ! 4130: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xdabc0400  ! 4131: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xda976000  ! 4132: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	mov	0x40, %r18
	.word 0xdc8c0400  ! 4134: LDUBA_R	lduba	[%r16, %r0] 0x20, %r14
	mov	0x3f8, %r21
	.word 0xdcaf6000  ! 4136: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 4137: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r27
	mov	0x58, %r27
	mov	0x7c0, %r20
	.word 0xd0870e60  ! 4141: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r8
	.word 0xd0f7e000  ! 4142: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	mov	0x8, %r24
	.word 0x87802020  ! 4144: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r23
	.word 0xd0bc6000  ! 4146: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	.word 0xd8a74e80  ! 4147: STWA_R	stwa	%r12, [%r29 + %r0] 0x74
	.word 0xd8b4a000  ! 4148: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 4149: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8af2000  ! 4150: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xd8a76000  ! 4151: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 4152: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdab44400  ! 4153: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	mov	0x50, %r24
	mov	0x20, %r17
	.word 0xdac6e000  ! 4156: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r13
	.word 0xdace2000  ! 4157: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r13
	.word 0xd4dc8400  ! 4158: LDXA_R	ldxa	[%r18, %r0] 0x20, %r10
	.word 0xde8c4400  ! 4159: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	.word 0xde8d44a0  ! 4160: LDUBA_R	lduba	[%r21, %r0] 0x25, %r15
	.word 0x87802020  ! 4161: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea4a000  ! 4162: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xdea4a000  ! 4163: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xdebc0400  ! 4164: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0xdedca000  ! 4165: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0x87802072  ! 4166: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r18
	mov	0x78, %r17
	mov	0x30, %r27
	.word 0x87802074  ! 4170: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r24
	mov	0x50, %r24
	.word 0xde972000  ! 4173: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0xdcac0400  ! 4174: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xd4d70e60  ! 4175: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r10
	.word 0xd4df2000  ! 4176: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4cf2000  ! 4177: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4d7a000  ! 4178: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	.word 0xdad78e80  ! 4179: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r13
	.word 0xdaf649e0  ! 4180: STXA_R	stxa	%r13, [%r25 + %r0] 0x4f
	mov	0x3c0, %r21
	.word 0xd6f689e0  ! 4182: STXA_R	stxa	%r11, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 4183: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b42000  ! 4184: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0xd4b4c400  ! 4185: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0x87802025  ! 4186: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdccc0400  ! 4187: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r14
	mov	0x48, %r26
	mov	0x58, %r16
	.word 0xd4b4c400  ! 4190: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0xd48d6000  ! 4191: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r10
	.word 0x87802073  ! 4192: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd49fe000  ! 4193: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd4bf6000  ! 4194: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	mov	0x58, %r18
	.word 0x87802074  ! 4196: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4df2000  ! 4197: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0xda8c4400  ! 4198: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0x87802074  ! 4199: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf74e80  ! 4200: STXA_R	stxa	%r13, [%r29 + %r0] 0x74
	mov	0x18, %r27
	.word 0xdac7a000  ! 4202: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xdacf2000  ! 4203: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xdad7e000  ! 4204: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xd4970e80  ! 4205: LDUHA_R	lduha	[%r28, %r0] 0x74, %r10
	mov	0x20, %r17
	mov	0x30, %r25
	.word 0xd4b7e000  ! 4208: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 4209: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r25
	mov	0x10, %r19
	.word 0xd89e49e0  ! 4212: LDDA_R	ldda	[%r25, %r0] 0x4f, %r12
	.word 0x8780204f  ! 4213: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8862000  ! 4214: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r12
	.word 0xd6b609e0  ! 4215: STHA_R	stha	%r11, [%r24 + %r0] 0x4f
	mov	0x30, %r19
	.word 0xdcf70e80  ! 4217: STXA_R	stxa	%r14, [%r28 + %r0] 0x74
	.word 0x87802074  ! 4218: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c0, %r20
	.word 0xd0b504a0  ! 4220: STHA_R	stha	%r8, [%r20 + %r0] 0x25
	.word 0x8780204f  ! 4221: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8d6c9e0  ! 4222: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r12
	mov	0x50, %r24
	.word 0xd0a7ce60  ! 4224: STWA_R	stwa	%r8, [%r31 + %r0] 0x73
	.word 0xd0dea000  ! 4225: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r8
	mov	0x7d8, %r20
	mov	0x28, %r19
	mov	0x0, %r24
	.word 0x87802072  ! 4229: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7e0, %r23
	.word 0xd09fe000  ! 4231: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	mov	0x3c0, %r21
	.word 0xdeb609e0  ! 4233: STHA_R	stha	%r15, [%r24 + %r0] 0x4f
	mov	0x10, %r17
	mov	0x20, %r25
	mov	0x3c0, %r21
	.word 0xdeaf6000  ! 4237: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xdc8504a0  ! 4238: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r14
	.word 0xd0bcc400  ! 4239: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	mov	0x30, %r16
	.word 0xd0dc8400  ! 4241: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0xdebfce60  ! 4242: STDA_R	stda	%r15, [%r31 + %r0] 0x73
	.word 0xde87a000  ! 4243: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0x87802025  ! 4244: WRASI_I	wr	%r0, 0x0025, %asi
	wr_tick_cmpr_0_48:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xee, %g2
	or	%g4, 0x86, %g4
	or	%g6, 0xae, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdca40400  ! 4246: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xdec74e40  ! 4247: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r15
	.word 0x87802072  ! 4248: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab74e60  ! 4249: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	mov	0x58, %r27
	.word 0x8780204f  ! 4251: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa6a000  ! 4252: STWA_I	stwa	%r13, [%r26 + 0x0000] %asi
	mov	0x40, %r19
	.word 0x87802074  ! 4254: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8dc4400  ! 4255: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0x87802073  ! 4256: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r24
	mov	0x38, %r24
	mov	0x3f8, %r21
	.word 0x87802073  ! 4260: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde978e40  ! 4261: LDUHA_R	lduha	[%r30, %r0] 0x72, %r15
	.word 0xdec76000  ! 4262: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0x87802025  ! 4263: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r24
	mov	0x3f0, %r23
	.word 0xdebd6000  ! 4266: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	.word 0xdec52000  ! 4267: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r15
	mov	0x30, %r25
	.word 0xd89649e0  ! 4269: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r12
	mov	0x3d8, %r20
	.word 0xd6d4c400  ! 4271: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	.word 0xd6cde000  ! 4272: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r11
	.word 0xd6b52000  ! 4273: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	.word 0xd4d5c4a0  ! 4274: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r10
	.word 0xd4b5e000  ! 4275: STHA_I	stha	%r10, [%r23 + 0x0000] %asi
	.word 0xd4a52000  ! 4276: STWA_I	stwa	%r10, [%r20 + 0x0000] %asi
	.word 0xd6dcc400  ! 4277: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	.word 0xd6f5e000  ! 4278: STXA_I	stxa	%r11, [%r23 + 0x0000] %asi
	mov	0x7e8, %r21
	mov	0x3f0, %r23
	mov	0x20, %r16
	mov	0x3e0, %r21
	.word 0xdaa44400  ! 4283: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0xda956000  ! 4284: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r13
	wr_tick_cmpr_0_49:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xec, %g2
	or	%g4, 0xc1, %g4
	or	%g6, 0x90, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdab5a000  ! 4286: STHA_I	stha	%r13, [%r22 + 0x0000] %asi
	.word 0xdaa5a000  ! 4287: STWA_I	stwa	%r13, [%r22 + 0x0000] %asi
	.word 0xd2874e40  ! 4288: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r9
	wr_tick_cmpr_0_50:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf0, %g2
	or	%g4, 0xd7, %g4
	or	%g6, 0xa0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2bde000  ! 4290: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	mov	0x10, %r19
	.word 0xd2b5e000  ! 4292: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 4293: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28dc4a0  ! 4294: LDUBA_R	lduba	[%r23, %r0] 0x25, %r9
	.word 0xd2f7e000  ! 4295: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd297a000  ! 4296: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	mov	0x18, %r16
	.word 0xd2a76000  ! 4298: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 4299: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd28ea000  ! 4300: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r9
	.word 0xd2c6a000  ! 4301: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r9
	.word 0xd2a6a000  ! 4302: STWA_I	stwa	%r9, [%r26 + 0x0000] %asi
	.word 0x87802074  ! 4303: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc848400  ! 4304: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	.word 0xdcb7a000  ! 4305: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 4306: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcad04a0  ! 4307: STBA_R	stba	%r14, [%r20 + %r0] 0x25
	mov	0x20, %r24
	.word 0xdade49e0  ! 4309: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r13
	.word 0xdadfe000  ! 4310: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0xd2f78e40  ! 4311: STXA_R	stxa	%r9, [%r30 + %r0] 0x72
	mov	0x68, %r27
	.word 0xd687ce80  ! 4313: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r11
	.word 0xd6b70e80  ! 4314: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	.word 0x87802073  ! 4315: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6a7a000  ! 4316: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6a7e000  ! 4317: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	mov	0x78, %r18
	mov	0x68, %r16
	.word 0xd697a000  ! 4320: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0xdeb44400  ! 4321: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	mov	0x0, %r17
	.word 0xde872000  ! 4323: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0x87802073  ! 4324: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb72000  ! 4325: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xdeb76000  ! 4326: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 4327: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde9f2000  ! 4328: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xda8c4400  ! 4329: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0xdc9ec9e0  ! 4330: LDDA_R	ldda	[%r27, %r0] 0x4f, %r14
	.word 0xd0a70e60  ! 4331: STWA_R	stwa	%r8, [%r28 + %r0] 0x73
	.word 0xd6b70e40  ! 4332: STHA_R	stha	%r11, [%r28 + %r0] 0x72
	.word 0xd6a72000  ! 4333: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 4334: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6aca000  ! 4335: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xd4cf0e40  ! 4336: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r10
	mov	0x68, %r16
	mov	0x70, %r26
	.word 0xd4f4a000  ! 4339: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0xd494a000  ! 4340: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r10
	.word 0xd8cf4e80  ! 4341: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r12
	.word 0xd2b74e60  ! 4342: STHA_R	stha	%r9, [%r29 + %r0] 0x73
	.word 0xd08e89e0  ! 4343: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r8
	.word 0xd08c6000  ! 4344: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0xd28c0400  ! 4345: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	.word 0xd2bc2000  ! 4346: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xd2d4e000  ! 4347: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 4348: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e0, %r20
	.word 0x87802025  ! 4350: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 4351: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd295a000  ! 4352: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r9
	.word 0xd2ad2000  ! 4353: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xd2ad2000  ! 4354: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xd2ade000  ! 4355: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0xd6afce60  ! 4356: STBA_R	stba	%r11, [%r31 + %r0] 0x73
	.word 0xde8fce60  ! 4357: LDUBA_R	lduba	[%r31, %r0] 0x73, %r15
	mov	0x3f0, %r23
	.word 0xdebd6000  ! 4359: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	mov	0x70, %r27
	.word 0x87802072  ! 4361: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a70e60  ! 4362: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	.word 0x87802073  ! 4363: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f0, %r23
	.word 0xd88cc400  ! 4365: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	.word 0x87802025  ! 4366: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bde000  ! 4367: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0xdabf4e60  ! 4368: STDA_R	stda	%r13, [%r29 + %r0] 0x73
	.word 0xd6f74e60  ! 4369: STXA_R	stxa	%r11, [%r29 + %r0] 0x73
	mov	0x10, %r24
	.word 0xd89649e0  ! 4371: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r12
	.word 0xd8a52000  ! 4372: STWA_I	stwa	%r12, [%r20 + 0x0000] %asi
	mov	0x68, %r24
	.word 0xd8a5e000  ! 4374: STWA_I	stwa	%r12, [%r23 + 0x0000] %asi
	.word 0xdcf70e80  ! 4375: STXA_R	stxa	%r14, [%r28 + %r0] 0x74
	.word 0xd4dd44a0  ! 4376: LDXA_R	ldxa	[%r21, %r0] 0x25, %r10
	.word 0xd4852000  ! 4377: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r10
	mov	0x20, %r18
	.word 0xd4f52000  ! 4379: STXA_I	stxa	%r10, [%r20 + 0x0000] %asi
	.word 0xd2c48400  ! 4380: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0x87802072  ! 4381: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdea74e60  ! 4382: STWA_R	stwa	%r15, [%r29 + %r0] 0x73
	.word 0x87802020  ! 4383: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde84e000  ! 4384: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	.word 0xde9c6000  ! 4385: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0x87802025  ! 4386: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 4387: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r26
	.word 0xd6c74e60  ! 4389: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r11
	.word 0xd6dea000  ! 4390: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r11
	.word 0xded74e60  ! 4391: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r15
	mov	0x3c0, %r22
	.word 0xdcd4c400  ! 4393: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	.word 0xdcbe6000  ! 4394: STDA_I	stda	%r14, [%r25 + 0x0000] %asi
	.word 0xdcb62000  ! 4395: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	.word 0xdcbc0400  ! 4396: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0xd6a504a0  ! 4397: STWA_R	stwa	%r11, [%r20 + %r0] 0x25
	mov	0x48, %r24
	.word 0xd6f66000  ! 4399: STXA_I	stxa	%r11, [%r25 + 0x0000] %asi
	mov	0x0, %r18
	.word 0x87802020  ! 4401: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcc7ce40  ! 4402: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r14
	.word 0xdcac6000  ! 4403: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xdc8ce000  ! 4404: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	.word 0xd0c40400  ! 4405: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	.word 0xd0cce000  ! 4406: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0f4a000  ! 4407: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xdc978e40  ! 4408: LDUHA_R	lduha	[%r30, %r0] 0x72, %r14
	.word 0x87802025  ! 4409: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaa4c400  ! 4410: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0xdaf5a000  ! 4411: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xda85a000  ! 4413: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r13
	.word 0xd2afce40  ! 4414: STBA_R	stba	%r9, [%r31 + %r0] 0x72
	mov	0x18, %r25
	.word 0x8780204f  ! 4416: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8978e80  ! 4417: LDUHA_R	lduha	[%r30, %r0] 0x74, %r12
	.word 0xd2bf4e40  ! 4418: STDA_R	stda	%r9, [%r29 + %r0] 0x72
	mov	0x50, %r27
	mov	0x8, %r16
	.word 0xd296e000  ! 4421: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r9
	.word 0xd0f70e80  ! 4422: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0x87802020  ! 4423: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f78e60  ! 4424: STXA_R	stxa	%r10, [%r30 + %r0] 0x73
	.word 0xd4bc6000  ! 4425: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xded584a0  ! 4426: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r15
	mov	0x18, %r25
	.word 0x87802020  ! 4428: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4429: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8b7ce60  ! 4430: STHA_R	stha	%r12, [%r31 + %r0] 0x73
	mov	0x3c8, %r22
	.word 0xdcb70e80  ! 4432: STHA_R	stha	%r14, [%r28 + %r0] 0x74
	mov	0x7e0, %r20
	.word 0xd2bc8400  ! 4434: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	.word 0xdab40400  ! 4435: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0x87802025  ! 4436: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a74e40  ! 4437: STWA_R	stwa	%r11, [%r29 + %r0] 0x72
	.word 0xd6ad2000  ! 4438: STBA_I	stba	%r11, [%r20 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xdecf8e40  ! 4440: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r15
	.word 0xdeb56000  ! 4441: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	.word 0xdebd84a0  ! 4442: STDA_R	stda	%r15, [%r22 + %r0] 0x25
	mov	0x48, %r19
	.word 0xd8ad04a0  ! 4444: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	.word 0xd8b5e000  ! 4445: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0xd8b5e000  ! 4447: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	mov	0x48, %r25
	mov	0x7d8, %r23
	.word 0x87802020  ! 4450: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f4e000  ! 4451: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xd0f504a0  ! 4452: STXA_R	stxa	%r8, [%r20 + %r0] 0x25
	.word 0xdccc0400  ! 4453: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r14
	.word 0x87802020  ! 4454: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r26
	.word 0x8780204f  ! 4456: WRASI_I	wr	%r0, 0x004f, %asi
	wr_tick_cmpr_0_51:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xc7, %g2
	or	%g4, 0x8c, %g4
	or	%g6, 0x81, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 4458: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccce000  ! 4459: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r14
	.word 0xdc8ce000  ! 4460: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	.word 0xdccc2000  ! 4461: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r14
	mov	0x3e0, %r22
	.word 0xdcbc2000  ! 4463: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xd8be09e0  ! 4464: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	.word 0xd8f4e000  ! 4465: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xd0f504a0  ! 4466: STXA_R	stxa	%r8, [%r20 + %r0] 0x25
	mov	0x28, %r27
	.word 0xd0a4a000  ! 4468: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0xdcbf4e80  ! 4469: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	mov	0x60, %r18
	.word 0xd6b40400  ! 4471: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0x87802025  ! 4472: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6bd84a0  ! 4473: STDA_R	stda	%r11, [%r22 + %r0] 0x25
	.word 0xd685a000  ! 4474: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 4475: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd687ce60  ! 4476: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r11
	.word 0x87802020  ! 4477: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r25
	.word 0x87802074  ! 4479: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdea7ce40  ! 4480: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	.word 0x87802073  ! 4481: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f40400  ! 4482: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	mov	0x68, %r27
	.word 0xdc9649e0  ! 4484: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r14
	.word 0xd2ac0400  ! 4485: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0xdca44400  ! 4486: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0xdebc4400  ! 4487: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0xd4cdc4a0  ! 4488: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r10
	.word 0xd4cfe000  ! 4489: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0xd4bf2000  ! 4490: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd4b7e000  ! 4491: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	mov	0x20, %r24
	.word 0xd4f7a000  ! 4493: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4b72000  ! 4494: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd08c8400  ! 4495: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0xd4a504a0  ! 4496: STWA_R	stwa	%r10, [%r20 + %r0] 0x25
	mov	0x70, %r24
	.word 0xd4d72000  ! 4498: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	mov	0x7c0, %r21
	.word 0x87802020  ! 4500: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49ca000  ! 4501: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd4c4a000  ! 4502: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	.word 0xd4c4e000  ! 4503: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r10
	.word 0xd4dc6000  ! 4504: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	.word 0x87802073  ! 4505: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4afe000  ! 4506: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xdcbc4400  ! 4507: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0xdc9f6000  ! 4508: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0x87802072  ! 4509: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49c0400  ! 4510: LDDA_R	ldda	[%r16, %r0] 0x20, %r10
	.word 0xd4a72000  ! 4511: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	mov	0x70, %r24
	ta	T_CHANGE_PRIV	! macro
	mov	0x8, %r24
	.word 0xd4bcc400  ! 4515: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0xd0c70e60  ! 4516: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r8
	mov	0x7d0, %r21
	.word 0xd097e000  ! 4518: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0af2000  ! 4519: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	mov	0x48, %r18
	mov	0x70, %r24
	mov	0x18, %r25
	.word 0xd0bfa000  ! 4523: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0xd4c40400  ! 4524: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	.word 0xdc97ce60  ! 4525: LDUHA_R	lduha	[%r31, %r0] 0x73, %r14
	.word 0x87802073  ! 4526: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6ac8400  ! 4527: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xd6972000  ! 4528: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	mov	0x3d8, %r20
	.word 0xd6a7a000  ! 4530: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd2cd04a0  ! 4531: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r9
	mov	0x7e8, %r22
	.word 0x87802073  ! 4533: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r16
	mov	0x0, %r16
	mov	0x3f8, %r21
	.word 0xd8d584a0  ! 4537: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r12
	.word 0xd8cf2000  ! 4538: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0xd8afce40  ! 4539: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	.word 0xd8cfe000  ! 4540: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0x87802072  ! 4541: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 4542: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bc0400  ! 4543: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xd4cf8e60  ! 4544: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r10
	.word 0xd4ad2000  ! 4545: STBA_I	stba	%r10, [%r20 + 0x0000] %asi
	.word 0xd09f0e80  ! 4546: LDDA_R	ldda	[%r28, %r0] 0x74, %r8
	.word 0x8780204f  ! 4547: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b6e000  ! 4548: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	.word 0x8780204f  ! 4549: WRASI_I	wr	%r0, 0x004f, %asi
	wr_tick_cmpr_0_52:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x85, %g2
	or	%g4, 0xa1, %g4
	or	%g6, 0xf1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x8780204f  ! 4551: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r26
	.word 0xd0b6e000  ! 4553: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	.word 0x87802025  ! 4554: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 4555: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0976000  ! 4556: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0cfa000  ! 4557: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0x87802072  ! 4558: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0a72000  ! 4559: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xda9f8e40  ! 4561: LDDA_R	ldda	[%r30, %r0] 0x72, %r13
	.word 0xdac7e000  ! 4562: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xdaf76000  ! 4563: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	mov	0x0, %r25
	.word 0xd0be89e0  ! 4565: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	.word 0xd89f0e60  ! 4566: LDDA_R	ldda	[%r28, %r0] 0x73, %r12
	.word 0xd2dc0400  ! 4567: LDXA_R	ldxa	[%r16, %r0] 0x20, %r9
	.word 0xd2df6000  ! 4568: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	mov	0x7f0, %r21
	.word 0x87802025  ! 4570: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r17
	.word 0xd09c8400  ! 4572: LDDA_R	ldda	[%r18, %r0] 0x20, %r8
	.word 0x87802020  ! 4573: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0846000  ! 4574: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	mov	0x0, %r19
	.word 0xd0cc0400  ! 4576: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xd6b544a0  ! 4577: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	.word 0xdebf8e40  ! 4578: STDA_R	stda	%r15, [%r30 + %r0] 0x72
	.word 0xdea42000  ! 4579: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xded46000  ! 4580: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	.word 0xdec4a000  ! 4581: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	mov	0x3d0, %r22
	.word 0xdecc6000  ! 4583: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r15
	mov	0x3d0, %r23
	.word 0xd2d544a0  ! 4585: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r9
	.word 0x8780204f  ! 4586: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b48400  ! 4587: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0xd8ae2000  ! 4588: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	.word 0xd68f4e60  ! 4589: LDUBA_R	lduba	[%r29, %r0] 0x73, %r11
	.word 0xd8b70e80  ! 4590: STHA_R	stha	%r12, [%r28 + %r0] 0x74
	mov	0x48, %r25
	.word 0xd8ae09e0  ! 4592: STBA_R	stba	%r12, [%r24 + %r0] 0x4f
	.word 0xd2b689e0  ! 4593: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	.word 0x87802072  ! 4594: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29f6000  ! 4595: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xd2f7a000  ! 4596: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	mov	0x58, %r27
	.word 0xde9fce60  ! 4598: LDDA_R	ldda	[%r31, %r0] 0x73, %r15
	mov	0x60, %r26
	.word 0xdcb44400  ! 4600: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	mov	0x28, %r19
	.word 0xdcc7a000  ! 4602: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	mov	0x3f0, %r23
	.word 0xdece09e0  ! 4604: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r15
	mov	0x60, %r17
	mov	0x70, %r16
	.word 0xd4bd44a0  ! 4607: STDA_R	stda	%r10, [%r21 + %r0] 0x25
	.word 0x87802072  ! 4608: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7c8, %r22
	.word 0xd4a72000  ! 4610: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	mov	0x38, %r17
	.word 0xd4bf6000  ! 4612: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	mov	0x10, %r18
	.word 0xd497a000  ! 4614: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0xd4af2000  ! 4615: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	mov	0x68, %r26
	mov	0x30, %r24
	.word 0xd48f6000  ! 4618: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xd4bf6000  ! 4619: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd8948400  ! 4620: LDUHA_R	lduha	[%r18, %r0] 0x20, %r12
	.word 0xd8bfa000  ! 4621: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xd0870e40  ! 4623: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r8
	mov	0x60, %r17
	.word 0xd0a70e80  ! 4625: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0xdca78e60  ! 4626: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	.word 0xd4a70e60  ! 4627: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	.word 0xd4b76000  ! 4628: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 4629: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r23
	.word 0x87802074  ! 4631: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca70e80  ! 4632: STWA_R	stwa	%r14, [%r28 + %r0] 0x74
	.word 0xd88c4400  ! 4633: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	mov	0x3d8, %r23
	.word 0xd8bfe000  ! 4635: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd8bfa000  ! 4636: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xd28e89e0  ! 4638: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r9
	mov	0x7c0, %r20
	mov	0x7e0, %r21
	.word 0xd2872000  ! 4641: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	ta	T_CHANGE_PRIV	! macro
	.word 0xd0840400  ! 4643: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	.word 0xdc974e40  ! 4644: LDUHA_R	lduha	[%r29, %r0] 0x72, %r14
	mov	0x7d0, %r22
	mov	0x18, %r17
	mov	0x10, %r17
	.word 0x87802073  ! 4648: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0d78e40  ! 4650: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r8
	mov	0x18, %r16
	.word 0x87802020  ! 4652: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac689e0  ! 4653: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r13
	.word 0xd0bc4400  ! 4654: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xd0aca000  ! 4655: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	mov	0x3d8, %r21
	mov	0x3c8, %r20
	.word 0x87802072  ! 4658: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r19
	.word 0xd0b72000  ! 4660: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 4661: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b66000  ! 4662: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	.word 0xd0a62000  ! 4663: STWA_I	stwa	%r8, [%r24 + 0x0000] %asi
	.word 0xd0d6a000  ! 4664: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r8
	.word 0xd8d584a0  ! 4665: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r12
	mov	0x78, %r17
	mov	0x38, %r25
	.word 0x87802072  ! 4668: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab4c400  ! 4669: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xdcf40400  ! 4670: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xd0d70e80  ! 4671: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r8
	.word 0xd8c74e40  ! 4672: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r12
	.word 0xd8b76000  ! 4673: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	mov	0x7f0, %r22
	.word 0xd8bfe000  ! 4675: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd8872000  ! 4676: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	.word 0x87802025  ! 4677: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8cd6000  ! 4678: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r12
	.word 0xd8ad6000  ! 4679: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	.word 0xd8bde000  ! 4680: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	mov	0x18, %r25
	.word 0xd8c70e80  ! 4682: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r12
	.word 0xd89d6000  ! 4683: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r12
	.word 0x87802025  ! 4684: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4a5c4a0  ! 4685: STWA_R	stwa	%r10, [%r23 + %r0] 0x25
	.word 0x87802025  ! 4686: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d8, %r21
	.word 0xd4d52000  ! 4688: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r10
	mov	0x10, %r19
	.word 0xd0bd44a0  ! 4690: STDA_R	stda	%r8, [%r21 + %r0] 0x25
	mov	0x78, %r19
	mov	0x3d0, %r20
	.word 0xd29f0e80  ! 4693: LDDA_R	ldda	[%r28, %r0] 0x74, %r9
	mov	0x78, %r19
	.word 0xd2f5a000  ! 4695: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	.word 0x87802074  ! 4696: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e8, %r21
	.word 0x87802020  ! 4698: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ace000  ! 4699: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0xdea4c400  ! 4700: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	mov	0x3f0, %r20
	.word 0x87802073  ! 4702: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4703: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r20
	mov	0x30, %r17
	mov	0x10, %r18
	.word 0xdea42000  ! 4707: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	wr_tick_cmpr_0_53:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xac, %g2
	or	%g4, 0x9c, %g4
	or	%g6, 0x81, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdeaca000  ! 4709: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xdea42000  ! 4710: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xd2b7ce40  ! 4711: STHA_R	stha	%r9, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 4712: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2b544a0  ! 4713: STHA_R	stha	%r9, [%r21 + %r0] 0x25
	mov	0x20, %r27
	mov	0x7d8, %r22
	.word 0xd29e2000  ! 4716: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r9
	.word 0x87802020  ! 4717: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r26
	.word 0x8780204f  ! 4719: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 4720: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 4721: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd28ea000  ! 4722: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r9
	mov	0x7d8, %r20
	.word 0xd8a74e60  ! 4724: STWA_R	stwa	%r12, [%r29 + %r0] 0x73
	mov	0x40, %r27
	.word 0xd8f6a000  ! 4726: STXA_I	stxa	%r12, [%r26 + 0x0000] %asi
	.word 0xd4bc4400  ! 4727: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0xd8f544a0  ! 4728: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	mov	0x8, %r27
	mov	0x7c8, %r22
	mov	0x3d8, %r22
	mov	0x0, %r17
	.word 0xd8c78e60  ! 4733: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r12
	.word 0xd8be2000  ! 4734: STDA_I	stda	%r12, [%r24 + 0x0000] %asi
	mov	0x28, %r16
	.word 0x87802072  ! 4736: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 4737: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebf4e40  ! 4738: STDA_R	stda	%r15, [%r29 + %r0] 0x72
	mov	0x7d0, %r22
	mov	0x28, %r25
	.word 0xd88d44a0  ! 4741: LDUBA_R	lduba	[%r21, %r0] 0x25, %r12
	.word 0x8780204f  ! 4742: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4743: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8cc6000  ! 4744: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r12
	.word 0xd8aca000  ! 4745: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 4746: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 4747: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd88c0400  ! 4748: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	.word 0xd0c7ce80  ! 4749: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r8
	.word 0xd0cfa000  ! 4750: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	mov	0x3e0, %r21
	mov	0x30, %r16
	.word 0xd0ae09e0  ! 4753: STBA_R	stba	%r8, [%r24 + %r0] 0x4f
	mov	0x3e0, %r20
	mov	0x70, %r26
	.word 0x87802025  ! 4756: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdadec9e0  ! 4757: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r13
	.word 0xd8cd84a0  ! 4758: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r12
	.word 0xd8f52000  ! 4759: STXA_I	stxa	%r12, [%r20 + 0x0000] %asi
	mov	0x60, %r26
	.word 0xdaac4400  ! 4761: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	.word 0xdaf56000  ! 4762: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	mov	0x7c0, %r23
	mov	0x3d8, %r22
	.word 0x87802025  ! 4765: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdab5e000  ! 4766: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	mov	0x68, %r25
	.word 0xdadd6000  ! 4768: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r13
	.word 0xdad56000  ! 4769: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r13
	.word 0xdab56000  ! 4770: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	.word 0xd29c0400  ! 4771: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	mov	0x7c0, %r23
	mov	0x10, %r17
	mov	0x7e0, %r23
	.word 0xd2f5e000  ! 4775: STXA_I	stxa	%r9, [%r23 + 0x0000] %asi
	mov	0x78, %r16
	.word 0xd2a56000  ! 4777: STWA_I	stwa	%r9, [%r21 + 0x0000] %asi
	.word 0xd2a5a000  ! 4778: STWA_I	stwa	%r9, [%r22 + 0x0000] %asi
	.word 0xd2cda000  ! 4779: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r9
	.word 0x87802020  ! 4780: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r23
	mov	0x68, %r17
	mov	0x70, %r17
	mov	0x38, %r19
	.word 0x87802072  ! 4785: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdade49e0  ! 4786: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r13
	.word 0xd88584a0  ! 4787: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r12
	.word 0x87802020  ! 4788: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r25
	.word 0xd8d4a000  ! 4790: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xd2cf4e60  ! 4791: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r9
	.word 0xd4c74e60  ! 4792: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r10
	.word 0xd2f70e60  ! 4793: STXA_R	stxa	%r9, [%r28 + %r0] 0x73
	mov	0x48, %r26
	.word 0x87802072  ! 4795: WRASI_I	wr	%r0, 0x0072, %asi
	wr_tick_cmpr_0_54:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe3, %g2
	or	%g4, 0x9f, %g4
	or	%g6, 0xd5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x70, %r27
	mov	0x3e0, %r23
	.word 0xd2af2000  ! 4799: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd2bfe000  ! 4800: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd2afe000  ! 4801: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 4802: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 4803: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r25
	.word 0xd2f72000  ! 4805: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	mov	0x20, %r26
	.word 0x87802074  ! 4807: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2972000  ! 4808: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xd2d7e000  ! 4809: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0x87802074  ! 4810: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 4811: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2a76000  ! 4812: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd0afce60  ! 4813: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	.word 0xd0dfe000  ! 4814: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0876000  ! 4815: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	.word 0xdeb70e40  ! 4816: STHA_R	stha	%r15, [%r28 + %r0] 0x72
	.word 0xd4c609e0  ! 4817: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r10
	.word 0xdeafce60  ! 4818: STBA_R	stba	%r15, [%r31 + %r0] 0x73
	.word 0xdcaf8e60  ! 4819: STBA_R	stba	%r14, [%r30 + %r0] 0x73
	.word 0xdc9fa000  ! 4820: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 4821: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b44400  ! 4822: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0x87802025  ! 4823: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d0, %r20
	.word 0xd2cc4400  ! 4825: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r9
	.word 0x87802020  ! 4826: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4827: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dce000  ! 4828: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r9
	.word 0xd28ca000  ! 4829: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0xdef74e40  ! 4830: STXA_R	stxa	%r15, [%r29 + %r0] 0x72
	.word 0xde84e000  ! 4831: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	.word 0xdec46000  ! 4832: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	mov	0x40, %r27
	.word 0x8780204f  ! 4834: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f0, %r21
	mov	0x68, %r25
	mov	0x50, %r16
	.word 0xdcafce60  ! 4838: STBA_R	stba	%r14, [%r31 + %r0] 0x73
	.word 0xdcde2000  ! 4839: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r14
	.word 0xd0cf0e40  ! 4840: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r8
	.word 0xd8dcc400  ! 4841: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	.word 0xdab70e80  ! 4842: STHA_R	stha	%r13, [%r28 + %r0] 0x74
	.word 0xd48d04a0  ! 4843: LDUBA_R	lduba	[%r20, %r0] 0x25, %r10
	.word 0xdcb48400  ! 4844: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0x87802074  ! 4845: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbf6000  ! 4846: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	mov	0x68, %r19
	.word 0x87802020  ! 4848: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6978e80  ! 4849: LDUHA_R	lduha	[%r30, %r0] 0x74, %r11
	mov	0x7d0, %r21
	.word 0x87802072  ! 4851: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f4c400  ! 4852: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0xd4f48400  ! 4853: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xdac74e60  ! 4854: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r13
	mov	0x38, %r27
	.word 0xdab7e000  ! 4856: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 4857: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeac4400  ! 4858: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0xded72000  ! 4859: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xdebf2000  ! 4860: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	mov	0x20, %r25
	.word 0xdea7a000  ! 4862: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	mov	0x7c8, %r22
	mov	0x3e8, %r22
	wr_tick_cmpr_0_55:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe7, %g2
	or	%g4, 0xb4, %g4
	or	%g6, 0xc0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 4866: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda86c9e0  ! 4867: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r13
	.word 0xd8bc4400  ! 4868: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0x87802072  ! 4869: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7e0, %r20
	.word 0xd8f72000  ! 4871: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8bfa000  ! 4872: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	mov	0x7f8, %r23
	mov	0x3f0, %r20
	mov	0x0, %r18
	.word 0xd8bf6000  ! 4876: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xdebf4e40  ! 4877: STDA_R	stda	%r15, [%r29 + %r0] 0x72
	mov	0x70, %r24
	.word 0x87802074  ! 4879: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdec76000  ! 4880: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xdeaf6000  ! 4881: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 4882: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebe2000  ! 4883: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	wr_tick_cmpr_0_56:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xcd, %g2
	or	%g4, 0xf0, %g4
	or	%g6, 0x9a, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3e0, %r20
	.word 0xdedc8400  ! 4886: LDXA_R	ldxa	[%r18, %r0] 0x20, %r15
	.word 0xd4bd44a0  ! 4887: STDA_R	stda	%r10, [%r21 + %r0] 0x25
	mov	0x3f0, %r22
	.word 0x87802074  ! 4889: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a76000  ! 4890: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4b72000  ! 4891: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	mov	0x20, %r27
	.word 0x87802020  ! 4893: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb74e40  ! 4894: STHA_R	stha	%r14, [%r29 + %r0] 0x72
	.word 0xdcb4e000  ! 4895: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xd8d689e0  ! 4896: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r12
	.word 0xd2a70e60  ! 4897: STWA_R	stwa	%r9, [%r28 + %r0] 0x73
	.word 0xd29ca000  ! 4898: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	mov	0x0, %r26
	.word 0xd2d42000  ! 4900: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0xd8afce80  ! 4901: STBA_R	stba	%r12, [%r31 + %r0] 0x74
	mov	0x30, %r27
	.word 0x87802020  ! 4903: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f4a000  ! 4904: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xdcc70e60  ! 4905: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r14
	.word 0x87802073  ! 4906: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 4907: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 4908: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8504a0  ! 4909: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r13
	.word 0xd6f48400  ! 4910: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xd68de000  ! 4911: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r11
	.word 0xd6bd2000  ! 4912: STDA_I	stda	%r11, [%r20 + 0x0000] %asi
	.word 0xd6ade000  ! 4913: STBA_I	stba	%r11, [%r23 + 0x0000] %asi
	.word 0xd6b52000  ! 4914: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	.word 0xd6d5e000  ! 4915: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r11
	.word 0xd2878e80  ! 4916: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r9
	mov	0x7e0, %r21
	mov	0x70, %r17
	.word 0x87802020  ! 4919: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r17
	mov	0x8, %r18
	.word 0xd29ca000  ! 4922: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 4923: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a6c9e0  ! 4924: STWA_R	stwa	%r10, [%r27 + %r0] 0x4f
	.word 0xd49ea000  ! 4925: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	.word 0x87802020  ! 4926: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r19
	mov	0x60, %r24
	mov	0x7f0, %r20
	.word 0xd4ac2000  ! 4930: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0xd6a7ce80  ! 4931: STWA_R	stwa	%r11, [%r31 + %r0] 0x74
	.word 0xde8504a0  ! 4932: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r15
	.word 0xded46000  ! 4933: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	mov	0x3e8, %r21
	.word 0xdedce000  ! 4935: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r15
	.word 0xdebc6000  ! 4936: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 4937: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebca000  ! 4938: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xd0b74e80  ! 4939: STHA_R	stha	%r8, [%r29 + %r0] 0x74
	.word 0xdab74e60  ! 4940: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	.word 0x87802074  ! 4941: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b7ce40  ! 4942: STHA_R	stha	%r11, [%r31 + %r0] 0x72
	mov	0x40, %r24
	.word 0x87802072  ! 4944: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf584a0  ! 4945: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	.word 0xdad7a000  ! 4946: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	mov	0x20, %r27
	.word 0xda9fa000  ! 4948: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xd6bc8400  ! 4949: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0x87802020  ! 4950: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4951: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8ae49e0  ! 4952: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0xd2be49e0  ! 4953: STDA_R	stda	%r9, [%r25 + %r0] 0x4f
	.word 0x87802074  ! 4954: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bfe000  ! 4955: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 4956: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8c7ce60  ! 4957: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r12
	.word 0xd68cc400  ! 4958: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	mov	0x7f8, %r20
	wr_tick_cmpr_0_57:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xfa, %g2
	or	%g4, 0xb7, %g4
	or	%g6, 0x94, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x60, %r18
	.word 0xd685e000  ! 4962: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r11
	.word 0xd6952000  ! 4963: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r11
	.word 0xd6dd2000  ! 4964: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r11
	mov	0x10, %r24
	.word 0xd6bd6000  ! 4966: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0xd6a5a000  ! 4967: STWA_I	stwa	%r11, [%r22 + 0x0000] %asi
	.word 0xdabc8400  ! 4968: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	mov	0x3c8, %r21
	.word 0xdab52000  ! 4970: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	.word 0xdad5c4a0  ! 4971: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r13
	.word 0xdab5e000  ! 4972: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0xd2af4e60  ! 4973: STBA_R	stba	%r9, [%r29 + %r0] 0x73
	mov	0x0, %r17
	.word 0xd4af4e80  ! 4975: STBA_R	stba	%r10, [%r29 + %r0] 0x74
	.word 0xd2cf4e60  ! 4976: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r9
	.word 0xd2b5a000  ! 4977: STHA_I	stha	%r9, [%r22 + 0x0000] %asi
	.word 0xd2b56000  ! 4978: STHA_I	stha	%r9, [%r21 + 0x0000] %asi
	.word 0xd2a52000  ! 4979: STWA_I	stwa	%r9, [%r20 + 0x0000] %asi
	.word 0x87802025  ! 4980: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8970e80  ! 4981: LDUHA_R	lduha	[%r28, %r0] 0x74, %r12
	.word 0xd8cc4400  ! 4982: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r12
	.word 0xd8856000  ! 4983: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	.word 0xd895a000  ! 4984: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4985: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d4a000  ! 4986: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xda9e49e0  ! 4987: LDDA_R	ldda	[%r25, %r0] 0x4f, %r13
	.word 0xdcb689e0  ! 4988: STHA_R	stha	%r14, [%r26 + %r0] 0x4f
	.word 0xd2cfce60  ! 4989: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r9
	.word 0xd2a46000  ! 4990: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	mov	0x7d0, %r23
	mov	0x7c0, %r22
	.word 0xd4be09e0  ! 4993: STDA_R	stda	%r10, [%r24 + %r0] 0x4f
	.word 0xd6974e40  ! 4994: LDUHA_R	lduha	[%r29, %r0] 0x72, %r11
	.word 0xd6dce000  ! 4995: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0xd8b504a0  ! 4996: STHA_R	stha	%r12, [%r20 + %r0] 0x25
	.word 0xded40400  ! 4997: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	mov	0x28, %r26
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_3:
	mov	0x70, %r27
	mov	0x48, %r27
	.word 0xd09f4e60  ! 3: LDDA_R	ldda	[%r29, %r0] 0x73, %r8
	.word 0x87802074  ! 4: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r26
	mov	0x18, %r19
	.word 0x87802020  ! 7: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r22
	.word 0xd6cc4400  ! 9: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	.word 0xdedc2000  ! 10: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r15
	.word 0xdc8fce80  ! 11: LDUBA_R	lduba	[%r31, %r0] 0x74, %r14
	mov	0x8, %r18
	.word 0xd2f4c400  ! 13: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xd0aca000  ! 14: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xd89f0e40  ! 15: LDDA_R	ldda	[%r28, %r0] 0x72, %r12
	.word 0x87802020  ! 16: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r16
	.word 0xd89f0e40  ! 18: LDDA_R	ldda	[%r28, %r0] 0x72, %r12
	.word 0x8780204f  ! 19: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4d48400  ! 20: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	.word 0xd0b5e000  ! 21: STHA_I	stha	%r8, [%r23 + 0x0000] %asi
	.word 0xdef4c400  ! 22: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xd4f5e000  ! 23: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	.word 0xd4a52000  ! 24: STWA_I	stwa	%r10, [%r20 + 0x0000] %asi
	.word 0x87802072  ! 25: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4b76000  ! 26: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	mov	0x18, %r16
	.word 0xd0f544a0  ! 28: STXA_R	stxa	%r8, [%r21 + %r0] 0x25
	.word 0xd6f72000  ! 29: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6de89e0  ! 30: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r11
	.word 0xd8876000  ! 31: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8840400  ! 32: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r12
	.word 0xdcf78e40  ! 33: STXA_R	stxa	%r14, [%r30 + %r0] 0x72
	.word 0xdedf6000  ! 34: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xd8dc4400  ! 35: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	mov	0x50, %r18
	.word 0xd4972000  ! 37: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0xd49f2000  ! 38: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd4a72000  ! 39: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xd6d649e0  ! 41: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r11
	.word 0xdac4c400  ! 42: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r13
	.word 0xd48fe000  ! 43: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0x87802020  ! 44: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r22
	.word 0xd49ce000  ! 46: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0xd4b4a000  ! 47: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0xd4d78e40  ! 48: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r10
	mov	0x3d0, %r23
	.word 0xd28c6000  ! 50: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0xd2b4c400  ! 51: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	mov	0x10, %r16
	.word 0xdad584a0  ! 53: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r13
	.word 0xd0de09e0  ! 54: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r8
	mov	0x7f0, %r21
	wr_tick_cmpr_3_0:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb4, %g2
	or	%g4, 0xd0, %g4
	or	%g6, 0xb2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	wr_tick_cmpr_3_1:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xa2, %g2
	or	%g4, 0x8a, %g4
	or	%g6, 0xb1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802074  ! 58: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4d56000  ! 59: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r10
	.word 0xd4ade000  ! 60: STBA_I	stba	%r10, [%r23 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0xd29f8e40  ! 62: LDDA_R	ldda	[%r30, %r0] 0x72, %r9
	.word 0xd0dcc400  ! 63: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0xd0b5a000  ! 64: STHA_I	stha	%r8, [%r22 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xd0bd6000  ! 66: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 67: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d7ce40  ! 68: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r11
	.word 0xdacc8400  ! 69: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r13
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802073  ! 71: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4ae2000  ! 72: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	.word 0xd48ea000  ! 73: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r10
	.word 0x87802025  ! 74: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cf6000  ! 75: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	mov	0x7f8, %r22
	.word 0xdcb78e40  ! 77: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xdcafce60  ! 78: STBA_R	stba	%r14, [%r31 + %r0] 0x73
	.word 0xdea48400  ! 79: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xd687a000  ! 80: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0x87802072  ! 81: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6840400  ! 82: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802020  ! 84: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda966000  ! 85: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r13
	.word 0xd0f44400  ! 86: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	mov	0x7d8, %r21
	mov	0x38, %r27
	.word 0x87802074  ! 89: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f7e000  ! 90: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd2b70e60  ! 91: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	.word 0xdca48400  ! 92: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xd6c76000  ! 93: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0x87802072  ! 94: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 95: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc9c8400  ! 96: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0cc6000  ! 98: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	.word 0xdece49e0  ! 99: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r15
	.word 0xd0d4a000  ! 100: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	mov	0x30, %r24
	.word 0x87802020  ! 102: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cf4e60  ! 103: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r10
	.word 0xdadd04a0  ! 104: LDXA_R	ldxa	[%r20, %r0] 0x25, %r13
	.word 0xda8c4400  ! 105: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0xdc846000  ! 106: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	mov	0x0, %r19
	.word 0xdcbc2000  ! 108: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 109: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4df4e60  ! 110: LDXA_R	ldxa	[%r29, %r0] 0x73, %r10
	mov	0x28, %r19
	.word 0x8780204f  ! 112: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdad4a000  ! 113: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0xdaafce40  ! 114: STBA_R	stba	%r13, [%r31 + %r0] 0x72
	.word 0x87802020  ! 115: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a78e80  ! 116: STWA_R	stwa	%r12, [%r30 + %r0] 0x74
	.word 0x8780204f  ! 117: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebc2000  ! 118: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xdcb584a0  ! 119: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	mov	0x10, %r25
	.word 0xd8ac4400  ! 121: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xdcbca000  ! 122: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 123: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r18
	.word 0xdcdde000  ! 125: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	mov	0x18, %r24
	.word 0xd8d4c400  ! 127: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0x87802025  ! 128: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd696c9e0  ! 129: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r11
	.word 0xd4a4e000  ! 130: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	mov	0x58, %r18
	.word 0xdcf48400  ! 132: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	mov	0x60, %r18
	.word 0xd2cc6000  ! 134: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	mov	0x7f8, %r22
	.word 0xd28c2000  ! 136: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xd2be89e0  ! 137: STDA_R	stda	%r9, [%r26 + %r0] 0x4f
	.word 0xdab46000  ! 138: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xdab4e000  ! 140: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xdef689e0  ! 141: STXA_R	stxa	%r15, [%r26 + %r0] 0x4f
	.word 0xd2f46000  ! 142: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 143: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 144: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2cca000  ! 145: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2dfce40  ! 146: LDXA_R	ldxa	[%r31, %r0] 0x72, %r9
	.word 0xdca4e000  ! 147: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 148: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcaca000  ! 149: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	mov	0x3e0, %r20
	.word 0xd2c689e0  ! 151: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r9
	.word 0x87802020  ! 152: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88cc400  ! 153: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	.word 0xdab42000  ! 154: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xdabca000  ! 155: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdaa46000  ! 156: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	.word 0xd68cc400  ! 157: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	.word 0xd2ac2000  ! 158: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xdc9f0e40  ! 159: LDDA_R	ldda	[%r28, %r0] 0x72, %r14
	.word 0xd8ad44a0  ! 160: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	.word 0xdad4c400  ! 161: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xd0cc2000  ! 162: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	.word 0xd0846000  ! 163: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0xd094a000  ! 164: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	.word 0xd4df4e80  ! 165: LDXA_R	ldxa	[%r29, %r0] 0x74, %r10
	.word 0x8780204f  ! 166: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf44400  ! 167: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xd68d2000  ! 168: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r11
	.word 0x87802073  ! 169: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4cf8e80  ! 170: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r10
	mov	0x3f0, %r22
	.word 0x87802025  ! 172: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r25
	.word 0x87802020  ! 174: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdec4c400  ! 175: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	.word 0xd48c2000  ! 176: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r10
	.word 0xd6c40400  ! 177: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r11
	.word 0x87802020  ! 178: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadce000  ! 179: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xd88c0400  ! 180: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	mov	0x78, %r16
	.word 0xd2f42000  ! 182: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0xd4cf0e40  ! 183: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r10
	.word 0x87802025  ! 184: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbfce60  ! 185: STDA_R	stda	%r14, [%r31 + %r0] 0x73
	mov	0x70, %r27
	.word 0x87802020  ! 187: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 188: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 189: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 190: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0d48400  ! 191: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	.word 0xd6f72000  ! 192: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6dfa000  ! 193: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6bf2000  ! 194: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd6bf2000  ! 195: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 196: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 197: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6d48400  ! 198: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0xdcb6a000  ! 199: STHA_I	stha	%r14, [%r26 + 0x0000] %asi
	.word 0xd0d609e0  ! 200: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r8
	mov	0x68, %r19
	.word 0xdcac0400  ! 202: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	mov	0x7e0, %r21
	mov	0x8, %r25
	.word 0x87802072  ! 205: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 206: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdad66000  ! 207: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r13
	.word 0xdabe6000  ! 208: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	.word 0xd6b4c400  ! 209: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xdaaea000  ! 210: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	mov	0x3e0, %r23
	.word 0xdab66000  ! 212: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	mov	0x10, %r17
	.word 0xd6be89e0  ! 214: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	.word 0xde9cc400  ! 215: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	.word 0xdca609e0  ! 216: STWA_R	stwa	%r14, [%r24 + %r0] 0x4f
	mov	0x0, %r16
	mov	0x3c0, %r21
	.word 0x87802073  ! 219: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd08fce40  ! 220: LDUBA_R	lduba	[%r31, %r0] 0x72, %r8
	.word 0xd2d72000  ! 221: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xde8fce40  ! 222: LDUBA_R	lduba	[%r31, %r0] 0x72, %r15
	.word 0xdcdfe000  ! 223: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	mov	0x58, %r24
	mov	0x28, %r16
	.word 0x87802020  ! 226: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d70e80  ! 227: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r9
	.word 0xdea649e0  ! 228: STWA_R	stwa	%r15, [%r25 + %r0] 0x4f
	mov	0x28, %r24
	.word 0x87802025  ! 230: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcac6000  ! 231: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xd4d584a0  ! 232: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r10
	.word 0xd69d04a0  ! 233: LDDA_R	ldda	[%r20, %r0] 0x25, %r11
	.word 0xd2f42000  ! 234: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0xd8be89e0  ! 235: STDA_R	stda	%r12, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 236: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28c0400  ! 237: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	.word 0xd4ac0400  ! 238: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xdc976000  ! 239: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	.word 0xdc9f6000  ! 240: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xdcaf6000  ! 241: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0x87802072  ! 243: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc862000  ! 244: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r14
	.word 0xd2f689e0  ! 245: STXA_R	stxa	%r9, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 246: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r26
	mov	0x7f0, %r22
	mov	0x10, %r18
	.word 0xdccca000  ! 250: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	.word 0xdca40400  ! 251: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0x87802073  ! 252: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd29c8400  ! 253: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	.word 0xd6870e60  ! 254: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r11
	.word 0xdc842000  ! 255: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	mov	0x60, %r26
	mov	0x68, %r26
	.word 0xdc8ca000  ! 258: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r14
	.word 0xdcd46000  ! 259: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	.word 0xdcc78e60  ! 260: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r14
	.word 0xd8cc2000  ! 261: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r12
	.word 0xd6dd44a0  ! 262: LDXA_R	ldxa	[%r21, %r0] 0x25, %r11
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802073  ! 264: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef56000  ! 265: STXA_I	stxa	%r15, [%r21 + 0x0000] %asi
	.word 0xdec5e000  ! 266: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r15
	.word 0xde95e000  ! 267: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r15
	.word 0xdeb5a000  ! 268: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	.word 0xd29c4400  ! 269: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	.word 0xd6dd6000  ! 270: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r11
	.word 0xd6ade000  ! 271: STBA_I	stba	%r11, [%r23 + 0x0000] %asi
	.word 0xd6a5a000  ! 272: STWA_I	stwa	%r11, [%r22 + 0x0000] %asi
	.word 0x87802074  ! 273: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd69fe000  ! 274: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	mov	0x58, %r25
	.word 0x87802072  ! 276: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcae09e0  ! 277: STBA_R	stba	%r14, [%r24 + %r0] 0x4f
	.word 0xd6878e60  ! 278: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r11
	.word 0xda84a000  ! 279: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	mov	0x40, %r17
	mov	0x78, %r18
	.word 0x87802073  ! 282: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6a44400  ! 283: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0xdebce000  ! 284: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xdad7ce60  ! 285: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r13
	.word 0x87802073  ! 286: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd48f4e80  ! 287: LDUBA_R	lduba	[%r29, %r0] 0x74, %r10
	.word 0xd2cf0e80  ! 288: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r9
	.word 0xdeaf4e80  ! 289: STBA_R	stba	%r15, [%r29 + %r0] 0x74
	mov	0x18, %r16
	.word 0xdea5e000  ! 291: STWA_I	stwa	%r15, [%r23 + 0x0000] %asi
	.word 0xd4bcc400  ! 292: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0xdad78e40  ! 293: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r13
	.word 0xdadfce80  ! 294: LDXA_R	ldxa	[%r31, %r0] 0x74, %r13
	.word 0x87802074  ! 295: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2cc6000  ! 296: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	mov	0x3e8, %r20
	mov	0x8, %r16
	.word 0xd2c4c400  ! 299: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0xda97ce40  ! 300: LDUHA_R	lduha	[%r31, %r0] 0x72, %r13
	.word 0xd8b544a0  ! 301: STHA_R	stha	%r12, [%r21 + %r0] 0x25
	.word 0xd49c2000  ! 302: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 303: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4aca000  ! 304: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 305: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a72000  ! 306: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 307: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4dfe000  ! 308: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xdeb649e0  ! 309: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	mov	0x28, %r16
	mov	0x58, %r27
	.word 0x87802020  ! 312: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 313: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 314: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd89dc4a0  ! 315: LDDA_R	ldda	[%r23, %r0] 0x25, %r12
	mov	0x7f0, %r23
	wr_tick_cmpr_3_2:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc3, %g2
	or	%g4, 0xe6, %g4
	or	%g6, 0xb1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x48, %r18
	.word 0x87802020  ! 319: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bc4400  ! 320: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	mov	0x58, %r25
	mov	0x7f8, %r23
	mov	0x3c8, %r22
	mov	0x70, %r26
	.word 0xdecee000  ! 325: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r15
	.word 0xd69609e0  ! 326: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r11
	wr_tick_cmpr_3_3:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x92, %g2
	or	%g4, 0x88, %g4
	or	%g6, 0xeb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x68, %r18
	.word 0xd6c66000  ! 329: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r11
	mov	0x70, %r19
	mov	0x30, %r24
	.word 0xd6d62000  ! 332: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r11
	mov	0x28, %r18
	.word 0x87802020  ! 334: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ad6000  ! 335: STBA_I	stba	%r11, [%r21 + 0x0000] %asi
	.word 0xd6c7ce80  ! 336: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r11
	.word 0xdcd56000  ! 337: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r14
	mov	0x40, %r26
	.word 0xd2ae09e0  ! 339: STBA_R	stba	%r9, [%r24 + %r0] 0x4f
	mov	0x38, %r24
	.word 0x87802020  ! 341: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r19
	.word 0xdcf649e0  ! 343: STXA_R	stxa	%r14, [%r25 + %r0] 0x4f
	.word 0xd4f46000  ! 344: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0xd8b6c9e0  ! 345: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	mov	0x70, %r26
	.word 0x87802074  ! 347: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 348: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b5a000  ! 349: STHA_I	stha	%r10, [%r22 + 0x0000] %asi
	.word 0xd2bf8e40  ! 350: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	.word 0xd2d48400  ! 351: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	mov	0x30, %r26
	.word 0x87802072  ! 353: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd494c400  ! 354: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	mov	0x48, %r18
	mov	0x48, %r24
	.word 0xd0a7a000  ! 357: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xdecec9e0  ! 358: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r15
	.word 0xdaf7e000  ! 359: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xdaafe000  ! 360: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xd8948400  ! 361: LDUHA_R	lduha	[%r18, %r0] 0x20, %r12
	.word 0xdcdf2000  ! 362: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	wr_tick_cmpr_3_4:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe7, %g2
	or	%g4, 0xf3, %g4
	or	%g6, 0xc8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x28, %r18
	.word 0xdcd70e80  ! 365: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r14
	.word 0xd0f4c400  ! 366: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	mov	0x50, %r17
	mov	0x8, %r18
	.word 0x87802025  ! 369: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2866000  ! 370: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r9
	.word 0xd2c62000  ! 371: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r9
	.word 0xd2962000  ! 372: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r9
	.word 0xd2dea000  ! 373: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r9
	.word 0xd2f66000  ! 374: STXA_I	stxa	%r9, [%r25 + 0x0000] %asi
	mov	0x8, %r17
	.word 0xdcb7ce60  ! 376: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	mov	0x28, %r18
	.word 0x87802073  ! 378: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb56000  ! 379: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	mov	0x50, %r25
	.word 0x87802020  ! 381: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb7ce40  ! 382: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	.word 0x87802074  ! 383: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6c44400  ! 384: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r11
	.word 0x87802020  ! 385: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf4c400  ! 386: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xdcd7ce80  ! 387: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r14
	.word 0xd686c9e0  ! 388: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r11
	mov	0x8, %r25
	.word 0x87802025  ! 390: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x3f8, %r23
	.word 0x87802025  ! 393: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 394: WRASI_I	wr	%r0, 0x0025, %asi
	wr_tick_cmpr_3_5:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xde, %g2
	or	%g4, 0x82, %g4
	or	%g6, 0xc6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0de2000  ! 396: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r8
	.word 0xd0f6a000  ! 397: STXA_I	stxa	%r8, [%r26 + 0x0000] %asi
	.word 0x87802074  ! 398: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r16
	mov	0x3c0, %r21
	mov	0x28, %r24
	.word 0xd6c504a0  ! 402: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r11
	.word 0xd4af6000  ! 403: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd4b76000  ! 404: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	mov	0x70, %r24
	.word 0x8780204f  ! 406: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 407: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49fe000  ! 408: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd4a78e40  ! 409: STWA_R	stwa	%r10, [%r30 + %r0] 0x72
	.word 0xd8cfe000  ! 410: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8cfa000  ! 411: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	mov	0x58, %r18
	.word 0xdcbd84a0  ! 413: STDA_R	stda	%r14, [%r22 + %r0] 0x25
	.word 0xd69689e0  ! 414: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r11
	.word 0xdcf78e60  ! 415: STXA_R	stxa	%r14, [%r30 + %r0] 0x73
	.word 0xdaf70e40  ! 416: STXA_R	stxa	%r13, [%r28 + %r0] 0x72
	mov	0x50, %r26
	.word 0xdecf6000  ! 418: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	mov	0x60, %r26
	.word 0xd0a7ce40  ! 420: STWA_R	stwa	%r8, [%r31 + %r0] 0x72
	.word 0xd086c9e0  ! 421: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r8
	.word 0x87802020  ! 422: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0c5a000  ! 423: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r8
	.word 0xd0f5a000  ! 424: STXA_I	stxa	%r8, [%r22 + 0x0000] %asi
	.word 0xd0d5e000  ! 425: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r8
	.word 0x87802025  ! 426: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c8, %r20
	mov	0x58, %r17
	.word 0xdc9dc4a0  ! 429: LDDA_R	ldda	[%r23, %r0] 0x25, %r14
	mov	0x18, %r18
	.word 0xd6a584a0  ! 431: STWA_R	stwa	%r11, [%r22 + %r0] 0x25
	.word 0xda8ce000  ! 432: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	.word 0xdadce000  ! 433: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	mov	0x70, %r17
	.word 0x87802020  ! 435: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b7ce80  ! 436: STHA_R	stha	%r9, [%r31 + %r0] 0x74
	ta	T_CHANGE_NONHPRIV	! macro
	wr_tick_cmpr_3_6:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf3, %g2
	or	%g4, 0xb7, %g4
	or	%g6, 0xdf, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 439: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c42000  ! 440: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	mov	0x30, %r24
	mov	0x7f8, %r20
	.word 0xd2846000  ! 443: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r9
	mov	0x78, %r27
	.word 0x87802073  ! 445: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2a76000  ! 446: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xdccf4e60  ! 447: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r14
	.word 0xdc848400  ! 448: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	.word 0xdef76000  ! 449: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdedf2000  ! 450: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	mov	0x58, %r18
	.word 0x87802074  ! 452: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 453: WRASI_I	wr	%r0, 0x004f, %asi
	wr_tick_cmpr_3_7:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x87, %g2
	or	%g4, 0xfe, %g4
	or	%g6, 0xe4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdef4e000  ! 455: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xd09e89e0  ! 456: LDDA_R	ldda	[%r26, %r0] 0x4f, %r8
	.word 0xd8a4c400  ! 457: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xd4a42000  ! 458: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	mov	0x18, %r19
	.word 0xd4d42000  ! 460: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	.word 0x87802072  ! 461: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f74e40  ! 462: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	wr_tick_cmpr_3_8:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xbe, %g2
	or	%g4, 0xbf, %g4
	or	%g6, 0xb7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x60, %r19
	.word 0x87802072  ! 465: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbf8e60  ! 466: STDA_R	stda	%r14, [%r30 + %r0] 0x73
	.word 0xd6a4e000  ! 467: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 468: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r22
	.word 0xdea6c9e0  ! 470: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	.word 0xd2d62000  ! 471: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r9
	.word 0x87802025  ! 472: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 473: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4d70e80  ! 474: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r10
	.word 0xd0f78e60  ! 475: STXA_R	stxa	%r8, [%r30 + %r0] 0x73
	.word 0x87802025  ! 476: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6cf2000  ! 477: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	mov	0x68, %r16
	.word 0xd68fa000  ! 479: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0xd697e000  ! 480: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	mov	0x70, %r16
	.word 0xd6b72000  ! 482: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 483: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6a4a000  ! 484: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	.word 0xd6af8e80  ! 485: STBA_R	stba	%r11, [%r30 + %r0] 0x74
	mov	0x68, %r17
	mov	0x18, %r16
	.word 0xd2a74e40  ! 488: STWA_R	stwa	%r9, [%r29 + %r0] 0x72
	.word 0xd08e49e0  ! 489: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r8
	wr_tick_cmpr_3_9:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc6, %g2
	or	%g4, 0xa9, %g4
	or	%g6, 0xba, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdeaf4e40  ! 491: STBA_R	stba	%r15, [%r29 + %r0] 0x72
	mov	0x50, %r16
	mov	0x58, %r17
	.word 0x87802025  ! 494: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd687e000  ! 495: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6b76000  ! 496: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xda8f0e80  ! 497: LDUBA_R	lduba	[%r28, %r0] 0x74, %r13
	.word 0xda85c4a0  ! 498: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r13
	mov	0x7e8, %r23
	.word 0x87802072  ! 500: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 501: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd087a000  ! 502: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0xd4d74e40  ! 503: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r10
	mov	0x3f0, %r21
	.word 0xdcb78e60  ! 505: STHA_R	stha	%r14, [%r30 + %r0] 0x73
	.word 0xdcaf2000  ! 506: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdcf7e000  ! 507: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x7f8, %r20
	.word 0xdccf2000  ! 509: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	mov	0x3d8, %r22
	.word 0xdcd72000  ! 511: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xdcf7a000  ! 512: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcd72000  ! 513: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	mov	0x60, %r26
	.word 0xdca7a000  ! 515: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdc8fe000  ! 516: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	mov	0x28, %r19
	.word 0xdcb7a000  ! 518: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 519: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcd4e000  ! 520: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	.word 0xdcb4a000  ! 521: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xda9e89e0  ! 522: LDDA_R	ldda	[%r26, %r0] 0x4f, %r13
	.word 0xd0f44400  ! 523: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd4dc0400  ! 524: LDXA_R	ldxa	[%r16, %r0] 0x20, %r10
	.word 0xd4f46000  ! 525: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0xd8874e60  ! 527: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r12
	.word 0xd0ac8400  ! 528: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xdacc6000  ! 529: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	.word 0xdadce000  ! 530: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xd68c8400  ! 531: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	wr_tick_cmpr_3_10:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xa0, %g2
	or	%g4, 0xea, %g4
	or	%g6, 0xac, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3c0, %r21
	.word 0xd8af4e60  ! 534: STBA_R	stba	%r12, [%r29 + %r0] 0x73
	.word 0xdaa46000  ! 535: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	.word 0xdca74e40  ! 536: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	.word 0xd2dca000  ! 537: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 538: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f7e000  ! 539: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	mov	0x38, %r19
	mov	0x40, %r17
	.word 0xd2dfe000  ! 542: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0xdebf0e60  ! 543: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	mov	0x60, %r25
	.word 0xd69f6000  ! 545: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	.word 0xd2dd04a0  ! 546: LDXA_R	ldxa	[%r20, %r0] 0x25, %r9
	.word 0xde94c400  ! 547: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	.word 0xd8af4e40  ! 548: STBA_R	stba	%r12, [%r29 + %r0] 0x72
	.word 0xd8bc4400  ! 549: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xda9fce80  ! 550: LDDA_R	ldda	[%r31, %r0] 0x74, %r13
	.word 0x87802074  ! 551: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r17
	.word 0x8780204f  ! 553: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f0, %r22
	.word 0x8780204f  ! 555: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 556: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0d7ce60  ! 557: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r8
	mov	0x70, %r17
	.word 0xdca6a000  ! 559: STWA_I	stwa	%r14, [%r26 + 0x0000] %asi
	.word 0xdcc6a000  ! 560: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r14
	.word 0xdecdc4a0  ! 561: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r15
	.word 0xd4c649e0  ! 562: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r10
	.word 0xd4aea000  ! 563: STBA_I	stba	%r10, [%r26 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0xd2a7ce40  ! 565: STWA_R	stwa	%r9, [%r31 + %r0] 0x72
	.word 0x87802020  ! 566: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 567: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4afe000  ! 568: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd6bc0400  ! 569: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xd884c400  ! 570: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	.word 0xd48fe000  ! 571: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xd8cdc4a0  ! 572: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r12
	mov	0x7d0, %r20
	.word 0xde9f6000  ! 574: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0x87802020  ! 575: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef6a000  ! 576: STXA_I	stxa	%r15, [%r26 + 0x0000] %asi
	.word 0xd4bfce80  ! 577: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	.word 0xd696e000  ! 578: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	.word 0xd6d6a000  ! 579: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r11
	mov	0x7d0, %r20
	.word 0xd8974e60  ! 581: LDUHA_R	lduha	[%r29, %r0] 0x73, %r12
	.word 0x87802074  ! 582: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e0, %r21
	.word 0xd2dc6000  ! 584: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r9
	mov	0x7c0, %r22
	mov	0x68, %r16
	.word 0xd2a4a000  ! 587: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0xdebf4e60  ! 588: STDA_R	stda	%r15, [%r29 + %r0] 0x73
	.word 0xd6f42000  ! 589: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 590: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 591: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 592: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r17
	.word 0xd4ae49e0  ! 594: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0xdccf2000  ! 595: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 596: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 597: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf52000  ! 598: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	mov	0x38, %r18
	.word 0xdeb40400  ! 600: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0xdabd44a0  ! 601: STDA_R	stda	%r13, [%r21 + %r0] 0x25
	.word 0xdaad6000  ! 602: STBA_I	stba	%r13, [%r21 + 0x0000] %asi
	.word 0xd8df4e80  ! 603: LDXA_R	ldxa	[%r29, %r0] 0x74, %r12
	.word 0xd4ac0400  ! 604: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	mov	0x58, %r17
	mov	0x50, %r27
	wr_tick_cmpr_3_11:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x9d, %g2
	or	%g4, 0xf6, %g4
	or	%g6, 0xdf, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x10, %r25
	.word 0x87802025  ! 609: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r19
	.word 0xd687e000  ! 611: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xdacf0e60  ! 612: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r13
	.word 0x87802020  ! 613: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b62000  ! 614: STHA_I	stha	%r12, [%r24 + 0x0000] %asi
	.word 0xd8aea000  ! 615: STBA_I	stba	%r12, [%r26 + 0x0000] %asi
	mov	0x60, %r24
	.word 0xd0d74e40  ! 617: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r8
	mov	0x58, %r19
	.word 0xd48ea000  ! 619: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r10
	mov	0x18, %r19
	.word 0xd0bf0e80  ! 621: STDA_R	stda	%r8, [%r28 + %r0] 0x74
	.word 0x8780204f  ! 622: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4952000  ! 623: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r10
	mov	0x0, %r19
	.word 0xd4b52000  ! 625: STHA_I	stha	%r10, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 626: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r27
	.word 0xd4a72000  ! 628: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd0848400  ! 629: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r8
	.word 0xd8b609e0  ! 630: STHA_R	stha	%r12, [%r24 + %r0] 0x4f
	.word 0xd6afa000  ! 631: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x78, %r25
	mov	0x48, %r25
	.word 0x8780204f  ! 634: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b48400  ! 635: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd6f44400  ! 636: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0xdcdc2000  ! 637: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r14
	.word 0x87802025  ! 638: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b40400  ! 639: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0x87802074  ! 640: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc9da000  ! 641: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r14
	.word 0xda8c4400  ! 642: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0xdaccc400  ! 643: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r13
	.word 0xdea70e80  ! 644: STWA_R	stwa	%r15, [%r28 + %r0] 0x74
	.word 0x87802020  ! 645: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 646: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca4e000  ! 647: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	mov	0x70, %r16
	.word 0xdcdc6000  ! 649: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	.word 0x87802020  ! 650: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r24
	.word 0xd0b48400  ! 652: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0x87802072  ! 653: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f0, %r22
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0d5a000  ! 656: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r8
	.word 0xd0ad6000  ! 657: STBA_I	stba	%r8, [%r21 + 0x0000] %asi
	.word 0xda8c0400  ! 658: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	mov	0x7d8, %r22
	.word 0xdaf5a000  ! 660: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xd4a48400  ! 661: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xd4c48400  ! 662: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r10
	.word 0xd2cd2000  ! 663: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r9
	.word 0xda970e80  ! 664: LDUHA_R	lduha	[%r28, %r0] 0x74, %r13
	.word 0x87802020  ! 665: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 666: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f7a000  ! 667: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0xd08dc4a0  ! 669: LDUBA_R	lduba	[%r23, %r0] 0x25, %r8
	.word 0xdec7e000  ! 670: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xdaaf8e60  ! 671: STBA_R	stba	%r13, [%r30 + %r0] 0x73
	.word 0xdc872000  ! 672: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	mov	0x18, %r25
	.word 0xdcbf2000  ! 674: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdc84c400  ! 675: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	mov	0x8, %r27
	.word 0xd6c70e40  ! 677: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r11
	.word 0xdec44400  ! 678: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0xd4d44400  ! 679: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0xdcbfa000  ! 680: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdcc76000  ! 681: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0x87802020  ! 682: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d6c9e0  ! 683: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r12
	mov	0x28, %r16
	.word 0xde974e40  ! 685: LDUHA_R	lduha	[%r29, %r0] 0x72, %r15
	.word 0xd8f7e000  ! 686: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xde9609e0  ! 687: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r15
	.word 0xdab4c400  ! 688: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xdaf72000  ! 689: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0xd8afce60  ! 691: STBA_R	stba	%r12, [%r31 + %r0] 0x73
	.word 0xd097a000  ! 692: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	mov	0x0, %r24
	.word 0x87802020  ! 694: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r16
	.word 0xd4c504a0  ! 696: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r10
	mov	0x10, %r17
	mov	0x60, %r16
	mov	0x70, %r16
	.word 0xd2878e60  ! 700: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r9
	.word 0xd4afe000  ! 701: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd4bfa000  ! 702: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	mov	0x3c8, %r21
	mov	0x7e8, %r21
	.word 0xd4f72000  ! 705: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	mov	0x68, %r24
	.word 0xd4cf2000  ! 707: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4bfe000  ! 708: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd48fce40  ! 709: LDUBA_R	lduba	[%r31, %r0] 0x72, %r10
	.word 0xdc970e40  ! 710: LDUHA_R	lduha	[%r28, %r0] 0x72, %r14
	.word 0xd48c4400  ! 711: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0xdec76000  ! 712: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xdedfe000  ! 713: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802020  ! 715: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde872000  ! 716: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xded7e000  ! 717: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	mov	0x3d8, %r23
	mov	0x3f8, %r20
	mov	0x30, %r24
	mov	0x3c8, %r23
	mov	0x38, %r16
	.word 0xde8689e0  ! 723: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r15
	.word 0xdaa48400  ! 724: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0xd48f2000  ! 725: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4f7e000  ! 726: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	mov	0x0, %r25
	.word 0xd4a44400  ! 728: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xd0af2000  ! 729: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0a7a000  ! 730: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0c76000  ! 731: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0xde870e80  ! 732: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r15
	.word 0xd0f70e80  ! 733: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	mov	0x20, %r27
	.word 0xd09d04a0  ! 735: LDDA_R	ldda	[%r20, %r0] 0x25, %r8
	.word 0xd88e49e0  ! 736: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r12
	.word 0xd4d40400  ! 737: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	.word 0xda8f2000  ! 738: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xd0970e40  ! 739: LDUHA_R	lduha	[%r28, %r0] 0x72, %r8
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd8b504a0  ! 741: STHA_R	stha	%r12, [%r20 + %r0] 0x25
	.word 0xd29504a0  ! 742: LDUHA_R	lduha	[%r20, %r0] 0x25, %r9
	.word 0xdcc72000  ! 743: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xd2bd04a0  ! 744: STDA_R	stda	%r9, [%r20 + %r0] 0x25
	mov	0x18, %r27
	.word 0xdac7a000  ! 746: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xd6ac8400  ! 747: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xd2bf2000  ! 748: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 749: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd29c6000  ! 750: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	.word 0xd2cce000  ! 751: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	mov	0x3d0, %r21
	.word 0xdeb48400  ! 753: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	wr_tick_cmpr_3_12:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xbd, %g2
	or	%g4, 0xd1, %g4
	or	%g6, 0xd9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd297ce80  ! 755: LDUHA_R	lduha	[%r31, %r0] 0x74, %r9
	.word 0xd8846000  ! 756: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	.word 0x87802020  ! 757: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 758: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd89ea000  ! 759: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r12
	mov	0x28, %r19
	mov	0x7d0, %r20
	.word 0x87802020  ! 762: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcae49e0  ! 763: STBA_R	stba	%r14, [%r25 + %r0] 0x4f
	.word 0x87802072  ! 764: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 765: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 766: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49fa000  ! 767: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0xd4f7e000  ! 768: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xdadd84a0  ! 769: LDXA_R	ldxa	[%r22, %r0] 0x25, %r13
	.word 0xdcb7ce60  ! 770: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	.word 0x87802025  ! 771: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbfe000  ! 772: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xd48fce40  ! 773: LDUBA_R	lduba	[%r31, %r0] 0x72, %r10
	mov	0x7d8, %r20
	.word 0xd0b72000  ! 775: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	mov	0x50, %r27
	.word 0xd0af2000  ! 777: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0dfe000  ! 778: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0x87802074  ! 779: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0bf2000  ! 780: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xd4b40400  ! 781: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	mov	0x3d8, %r21
	.word 0xd2f7a000  ! 783: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xdea7ce80  ! 784: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	.word 0xd0a7ce60  ! 785: STWA_R	stwa	%r8, [%r31 + %r0] 0x73
	.word 0xdaafce60  ! 786: STBA_R	stba	%r13, [%r31 + %r0] 0x73
	.word 0xd2a76000  ! 787: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	mov	0x3f8, %r20
	mov	0x60, %r16
	.word 0xd287a000  ! 790: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0x87802073  ! 791: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf7ce40  ! 792: STXA_R	stxa	%r13, [%r31 + %r0] 0x72
	.word 0xd4cf4e60  ! 793: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r10
	.word 0xdc966000  ! 794: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r14
	.word 0xd8dc8400  ! 795: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xd0f44400  ! 796: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	mov	0x38, %r19
	mov	0x0, %r16
	mov	0x3c0, %r22
	mov	0x8, %r17
	mov	0x10, %r27
	.word 0xd0d62000  ! 802: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r8
	.word 0xde8689e0  ! 803: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r15
	mov	0x78, %r26
	.word 0x87802074  ! 805: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf7e000  ! 806: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xde97ce40  ! 807: LDUHA_R	lduha	[%r31, %r0] 0x72, %r15
	.word 0xd0f72000  ! 808: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xdc8544a0  ! 809: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r14
	.word 0xd28fe000  ! 810: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	.word 0xd4d44400  ! 811: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0xd4972000  ! 812: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	mov	0x3d0, %r21
	mov	0x30, %r26
	.word 0xd2f78e40  ! 815: STXA_R	stxa	%r9, [%r30 + %r0] 0x72
	.word 0xd4f72000  ! 816: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd6848400  ! 817: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	.word 0x87802020  ! 818: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b7a000  ! 819: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 820: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde97ce80  ! 821: LDUHA_R	lduha	[%r31, %r0] 0x74, %r15
	.word 0xd897e000  ! 822: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	mov	0x7e8, %r22
	.word 0xd2ddc4a0  ! 824: LDXA_R	ldxa	[%r23, %r0] 0x25, %r9
	.word 0xd8afce40  ! 825: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	.word 0x87802020  ! 826: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48d6000  ! 827: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r10
	.word 0xd4bd6000  ! 828: STDA_I	stda	%r10, [%r21 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x28, %r18
	.word 0xd49de000  ! 831: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r10
	.word 0xd4cda000  ! 832: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r10
	.word 0xd49da000  ! 833: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r10
	.word 0xdcf48400  ! 834: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xd2952000  ! 835: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r9
	mov	0x18, %r25
	.word 0xd2a40400  ! 837: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xd2d609e0  ! 838: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r9
	.word 0xda944400  ! 839: LDUHA_R	lduha	[%r17, %r0] 0x20, %r13
	.word 0x87802073  ! 840: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8b76000  ! 841: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd4b40400  ! 842: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0xdab7a000  ! 843: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	mov	0x78, %r19
	.word 0x87802020  ! 845: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaaf2000  ! 846: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 847: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 848: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 849: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 850: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf6e000  ! 851: STXA_I	stxa	%r13, [%r27 + 0x0000] %asi
	.word 0xd69ec9e0  ! 852: LDDA_R	ldda	[%r27, %r0] 0x4f, %r11
	.word 0xd2ad04a0  ! 853: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	mov	0x68, %r18
	.word 0xdaf6e000  ! 855: STXA_I	stxa	%r13, [%r27 + 0x0000] %asi
	.word 0xda962000  ! 856: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r13
	.word 0xd0b7ce80  ! 857: STHA_R	stha	%r8, [%r31 + %r0] 0x74
	.word 0x87802072  ! 858: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 859: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0c72000  ! 860: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xdeb689e0  ! 861: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	.word 0xd687a000  ! 862: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	mov	0x30, %r17
	.word 0xd4974e40  ! 864: LDUHA_R	lduha	[%r29, %r0] 0x72, %r10
	.word 0xd8ad44a0  ! 865: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	mov	0x50, %r26
	.word 0x87802025  ! 867: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca7e000  ! 868: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 869: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcac6000  ! 870: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xdcf4e000  ! 871: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	mov	0x0, %r19
	.word 0x8780204f  ! 873: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcc4e000  ! 874: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r14
	.word 0xd89f0e40  ! 875: LDDA_R	ldda	[%r28, %r0] 0x72, %r12
	.word 0xd0dd04a0  ! 876: LDXA_R	ldxa	[%r20, %r0] 0x25, %r8
	mov	0x38, %r19
	.word 0x87802025  ! 878: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcadc4a0  ! 879: STBA_R	stba	%r14, [%r23 + %r0] 0x25
	.word 0xde9da000  ! 880: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r15
	.word 0xd8a40400  ! 881: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	mov	0x48, %r17
	.word 0x87802074  ! 883: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f7e000  ! 884: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd2848400  ! 885: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r9
	mov	0x10, %r19
	.word 0xd0a78e40  ! 887: STWA_R	stwa	%r8, [%r30 + %r0] 0x72
	mov	0x20, %r18
	.word 0xdc8f4e80  ! 889: LDUBA_R	lduba	[%r29, %r0] 0x74, %r14
	mov	0x70, %r16
	.word 0xd6cc0400  ! 891: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r11
	.word 0xd0a76000  ! 892: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0c7e000  ! 893: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0f7e000  ! 894: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 895: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde9d84a0  ! 896: LDDA_R	ldda	[%r22, %r0] 0x25, %r15
	.word 0x87802072  ! 897: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c8, %r23
	.word 0x87802020  ! 899: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcd4e000  ! 900: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	.word 0x87802073  ! 901: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d8, %r22
	.word 0x8780204f  ! 903: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcac2000  ! 904: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0xdcd42000  ! 905: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	.word 0xd4f6c9e0  ! 906: STXA_R	stxa	%r10, [%r27 + %r0] 0x4f
	mov	0x58, %r17
	.word 0xdca46000  ! 908: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xd2ddc4a0  ! 909: LDXA_R	ldxa	[%r23, %r0] 0x25, %r9
	mov	0x30, %r16
	.word 0xd8a4e000  ! 911: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xde978e60  ! 912: LDUHA_R	lduha	[%r30, %r0] 0x73, %r15
	mov	0x38, %r27
	.word 0xde84e000  ! 914: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	.word 0xdea42000  ! 915: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xd89fce40  ! 916: LDDA_R	ldda	[%r31, %r0] 0x72, %r12
	.word 0xdc9c4400  ! 917: LDDA_R	ldda	[%r17, %r0] 0x20, %r14
	mov	0x3d8, %r23
	.word 0xd2b4a000  ! 919: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0xd2bce000  ! 920: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 921: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2cda000  ! 922: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r9
	.word 0xd2ada000  ! 923: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	mov	0x7f0, %r22
	mov	0x10, %r27
	.word 0xd2f5e000  ! 926: STXA_I	stxa	%r9, [%r23 + 0x0000] %asi
	.word 0xd6b544a0  ! 927: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	.word 0xdea689e0  ! 928: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	.word 0xd2b52000  ! 929: STHA_I	stha	%r9, [%r20 + 0x0000] %asi
	.word 0xd2bd6000  ! 930: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xd2c5a000  ! 932: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r9
	mov	0x8, %r25
	.word 0xd2ade000  ! 934: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0xd2a5a000  ! 935: STWA_I	stwa	%r9, [%r22 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0xd2a5a000  ! 937: STWA_I	stwa	%r9, [%r22 + 0x0000] %asi
	.word 0xd295e000  ! 938: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r9
	.word 0xd2b5a000  ! 939: STHA_I	stha	%r9, [%r22 + 0x0000] %asi
	.word 0xdeb504a0  ! 940: STHA_R	stha	%r15, [%r20 + %r0] 0x25
	.word 0xdebec9e0  ! 941: STDA_R	stda	%r15, [%r27 + %r0] 0x4f
	.word 0xd6dda000  ! 942: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r11
	.word 0xd6b56000  ! 943: STHA_I	stha	%r11, [%r21 + 0x0000] %asi
	.word 0xd4d78e60  ! 944: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r10
	mov	0x3f0, %r21
	mov	0x3c8, %r23
	.word 0xdca56000  ! 947: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	.word 0xdebd84a0  ! 948: STDA_R	stda	%r15, [%r22 + %r0] 0x25
	.word 0xdcb7ce60  ! 949: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	.word 0xdcbda000  ! 950: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	.word 0xdc95a000  ! 951: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r14
	.word 0x87802020  ! 952: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcace000  ! 953: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdc94a000  ! 955: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xd2dc8400  ! 956: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0xd0946000  ! 957: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0xd0b46000  ! 958: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	mov	0x8, %r17
	mov	0x58, %r18
	.word 0xd4bfce40  ! 961: STDA_R	stda	%r10, [%r31 + %r0] 0x72
	.word 0xdc942000  ! 962: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	.word 0xdcf42000  ! 963: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	mov	0x30, %r26
	.word 0x8780204f  ! 965: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdac5c4a0  ! 966: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r13
	mov	0x60, %r17
	.word 0x87802073  ! 968: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r25
	.word 0xd2aea000  ! 970: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0xd2dee000  ! 971: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r9
	.word 0x87802072  ! 972: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f72000  ! 973: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd2afa000  ! 974: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xd2a72000  ! 975: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0xd8af0e40  ! 977: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	.word 0xde8d44a0  ! 978: LDUBA_R	lduba	[%r21, %r0] 0x25, %r15
	.word 0xdaaf2000  ! 979: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdad7e000  ! 980: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xdaf7e000  ! 981: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 982: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r27
	.word 0x87802074  ! 984: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdac76000  ! 985: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0xd0a584a0  ! 986: STWA_R	stwa	%r8, [%r22 + %r0] 0x25
	mov	0x30, %r27
	mov	0x7d8, %r23
	mov	0x70, %r27
	.word 0xdec78e80  ! 990: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r15
	.word 0xd0a689e0  ! 991: STWA_R	stwa	%r8, [%r26 + %r0] 0x4f
	.word 0xd4cf6000  ! 992: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0xd4af6000  ! 993: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 994: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde9c4400  ! 995: LDDA_R	ldda	[%r17, %r0] 0x20, %r15
	.word 0x87802020  ! 996: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded72000  ! 997: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xde8f2000  ! 998: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0x87802072  ! 999: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdec7a000  ! 1000: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xd6af8e80  ! 1001: STBA_R	stba	%r11, [%r30 + %r0] 0x74
	.word 0xdeafe000  ! 1002: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xd0bf4e60  ! 1003: STDA_R	stda	%r8, [%r29 + %r0] 0x73
	.word 0xd4dc4400  ! 1004: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	mov	0x68, %r26
	.word 0xdcf78e80  ! 1006: STXA_R	stxa	%r14, [%r30 + %r0] 0x74
	.word 0xdab76000  ! 1007: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 1008: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa4e000  ! 1009: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0xda84a000  ! 1010: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	.word 0x87802074  ! 1011: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdab76000  ! 1012: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 1013: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r20
	.word 0xdcf4c400  ! 1015: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0x87802025  ! 1016: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0cc4400  ! 1017: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	.word 0xd4948400  ! 1018: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	.word 0xdef6e000  ! 1019: STXA_I	stxa	%r15, [%r27 + 0x0000] %asi
	.word 0xdebe2000  ! 1020: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	.word 0xdea6e000  ! 1021: STWA_I	stwa	%r15, [%r27 + 0x0000] %asi
	.word 0xde86a000  ! 1022: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r15
	.word 0xdeaee000  ! 1023: STBA_I	stba	%r15, [%r27 + 0x0000] %asi
	mov	0x10, %r18
	.word 0xde86e000  ! 1025: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r15
	.word 0xd4a609e0  ! 1026: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	.word 0xd4cea000  ! 1027: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r10
	.word 0x87802025  ! 1028: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4afe000  ! 1029: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd094c400  ! 1030: LDUHA_R	lduha	[%r19, %r0] 0x20, %r8
	mov	0x50, %r16
	.word 0x87802020  ! 1032: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a4c400  ! 1033: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	mov	0x0, %r26
	.word 0xdcaf0e60  ! 1035: STBA_R	stba	%r14, [%r28 + %r0] 0x73
	.word 0xdca78e40  ! 1036: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	mov	0x3c0, %r21
	.word 0x87802072  ! 1038: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r25
	mov	0x28, %r17
	.word 0xdc852000  ! 1041: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r14
	.word 0xd0f5c4a0  ! 1042: STXA_R	stxa	%r8, [%r23 + %r0] 0x25
	wr_tick_cmpr_3_13:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe8, %g2
	or	%g4, 0xde, %g4
	or	%g6, 0xb8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x58, %r19
	.word 0xd6bde000  ! 1045: STDA_I	stda	%r11, [%r23 + 0x0000] %asi
	.word 0xd6f52000  ! 1046: STXA_I	stxa	%r11, [%r20 + 0x0000] %asi
	.word 0xd6b5a000  ! 1047: STHA_I	stha	%r11, [%r22 + 0x0000] %asi
	.word 0x8780204f  ! 1048: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d8, %r23
	.word 0xd2dc8400  ! 1050: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0x87802025  ! 1051: WRASI_I	wr	%r0, 0x0025, %asi
	wr_tick_cmpr_3_14:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x8d, %g2
	or	%g4, 0x8b, %g4
	or	%g6, 0xf8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2bf6000  ! 1053: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd2bfe000  ! 1054: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd88544a0  ! 1055: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r12
	mov	0x50, %r18
	.word 0xda86c9e0  ! 1057: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r13
	.word 0xdcb40400  ! 1058: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xdabc4400  ! 1059: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xda874e60  ! 1060: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r13
	.word 0xd0b504a0  ! 1061: STHA_R	stha	%r8, [%r20 + %r0] 0x25
	.word 0xd8a7ce40  ! 1062: STWA_R	stwa	%r12, [%r31 + %r0] 0x72
	.word 0xdc8dc4a0  ! 1063: LDUBA_R	lduba	[%r23, %r0] 0x25, %r14
	.word 0xdc976000  ! 1064: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	mov	0x7d0, %r20
	mov	0x3d0, %r20
	.word 0xdc87e000  ! 1067: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xd2bfce40  ! 1068: STDA_R	stda	%r9, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 1069: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd28e09e0  ! 1070: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r9
	mov	0x0, %r26
	.word 0xdccce000  ! 1072: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r14
	mov	0x10, %r25
	.word 0xd8c4c400  ! 1074: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r12
	.word 0xd285c4a0  ! 1075: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r9
	.word 0xde8ca000  ! 1076: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0x87802072  ! 1077: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf544a0  ! 1078: STXA_R	stxa	%r14, [%r21 + %r0] 0x25
	.word 0xd0f6a000  ! 1079: STXA_I	stxa	%r8, [%r26 + 0x0000] %asi
	.word 0xda8cc400  ! 1080: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	mov	0x3f8, %r21
	.word 0xdeb62000  ! 1082: STHA_I	stha	%r15, [%r24 + 0x0000] %asi
	.word 0xdede2000  ! 1083: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r15
	.word 0xdec66000  ! 1084: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r15
	mov	0x3f0, %r20
	mov	0x3e0, %r20
	.word 0xd087ce80  ! 1087: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r8
	.word 0x87802072  ! 1088: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r24
	.word 0xd4f78e60  ! 1090: STXA_R	stxa	%r10, [%r30 + %r0] 0x73
	.word 0xdc85e000  ! 1091: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r14
	wr_tick_cmpr_3_15:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb8, %g2
	or	%g4, 0xc2, %g4
	or	%g6, 0xf7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd29c0400  ! 1093: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	mov	0x68, %r24
	.word 0xd8dd6000  ! 1095: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r12
	.word 0xd89d6000  ! 1096: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r12
	.word 0xdeb48400  ! 1097: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xd4dfce40  ! 1098: LDXA_R	ldxa	[%r31, %r0] 0x72, %r10
	.word 0xda8f8e60  ! 1099: LDUBA_R	lduba	[%r30, %r0] 0x73, %r13
	.word 0xdebd2000  ! 1100: STDA_I	stda	%r15, [%r20 + 0x0000] %asi
	.word 0xdef689e0  ! 1101: STXA_R	stxa	%r15, [%r26 + %r0] 0x4f
	.word 0xd4c56000  ! 1102: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r10
	mov	0x7d0, %r23
	.word 0xd6a5c4a0  ! 1104: STWA_R	stwa	%r11, [%r23 + %r0] 0x25
	.word 0xd4be09e0  ! 1105: STDA_R	stda	%r10, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 1106: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r27
	.word 0xdac5e000  ! 1108: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1109: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1110: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1111: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdad5a000  ! 1112: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r13
	.word 0xd6bf8e80  ! 1113: STDA_R	stda	%r11, [%r30 + %r0] 0x74
	.word 0xd6d44400  ! 1114: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r11
	.word 0xde8d44a0  ! 1115: LDUBA_R	lduba	[%r21, %r0] 0x25, %r15
	mov	0x28, %r16
	mov	0x7f8, %r23
	.word 0xd4f78e40  ! 1118: STXA_R	stxa	%r10, [%r30 + %r0] 0x72
	.word 0xd0bda000  ! 1119: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	.word 0xdea48400  ! 1120: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0x87802072  ! 1121: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 1122: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf74e80  ! 1123: STXA_R	stxa	%r13, [%r29 + %r0] 0x74
	.word 0xd4bc0400  ! 1124: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xd68f4e80  ! 1125: LDUBA_R	lduba	[%r29, %r0] 0x74, %r11
	.word 0xdeb74e40  ! 1126: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	.word 0xd48fe000  ! 1127: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xd48fa000  ! 1128: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xde848400  ! 1129: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	mov	0x70, %r25
	.word 0xd4cfe000  ! 1131: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	mov	0x3f8, %r23
	mov	0x3e0, %r23
	mov	0x7c0, %r21
	.word 0x87802020  ! 1135: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cc2000  ! 1136: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	mov	0x58, %r18
	.word 0x87802025  ! 1138: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabc4400  ! 1139: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xd6a7ce60  ! 1140: STWA_R	stwa	%r11, [%r31 + %r0] 0x73
	.word 0xdca72000  ! 1141: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 1142: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r26
	.word 0xda9f8e40  ! 1144: LDDA_R	ldda	[%r30, %r0] 0x72, %r13
	.word 0xd89f2000  ! 1145: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0xd8dfe000  ! 1146: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	mov	0x40, %r19
	.word 0xd8af6000  ! 1148: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd8f7ce60  ! 1149: STXA_R	stxa	%r12, [%r31 + %r0] 0x73
	mov	0x50, %r16
	mov	0x7f8, %r23
	.word 0xd497a000  ! 1152: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0xd4bfa000  ! 1153: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd4c7e000  ! 1154: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4b76000  ! 1155: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd4afa000  ! 1156: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xdc87ce40  ! 1157: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r14
	.word 0x87802074  ! 1158: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r17
	.word 0xd0c70e80  ! 1160: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r8
	.word 0xd4f78e60  ! 1161: STXA_R	stxa	%r10, [%r30 + %r0] 0x73
	mov	0x28, %r16
	.word 0x8780204f  ! 1163: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8df4e40  ! 1164: LDXA_R	ldxa	[%r29, %r0] 0x72, %r12
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7d8, %r21
	.word 0x87802072  ! 1167: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f0, %r20
	.word 0x8780204f  ! 1169: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabe6000  ! 1170: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	.word 0xd48c0400  ! 1171: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	mov	0x7e0, %r22
	mov	0x40, %r18
	.word 0x8780204f  ! 1174: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r17
	.word 0x87802073  ! 1176: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0dc8400  ! 1177: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0xd2d78e80  ! 1178: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r9
	.word 0xd8f40400  ! 1179: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xd08ce000  ! 1180: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xd8be89e0  ! 1181: STDA_R	stda	%r12, [%r26 + %r0] 0x4f
	.word 0xdcf48400  ! 1182: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	mov	0x68, %r18
	.word 0xdca44400  ! 1184: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	mov	0x7d8, %r20
	.word 0xd6cc2000  ! 1186: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	mov	0x78, %r19
	.word 0xd6dc6000  ! 1188: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r11
	.word 0xd8c4c400  ! 1189: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r12
	.word 0xd6c48400  ! 1190: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	.word 0xdaf4a000  ! 1191: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 1192: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r18
	.word 0xdcce89e0  ! 1194: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r14
	.word 0xd0f7e000  ! 1195: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd8af8e40  ! 1196: STBA_R	stba	%r12, [%r30 + %r0] 0x72
	mov	0x48, %r19
	.word 0xd4acc400  ! 1198: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	mov	0x7c8, %r20
	.word 0xd6bfce40  ! 1200: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	.word 0x87802073  ! 1201: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8a72000  ! 1202: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8df6000  ! 1203: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8976000  ! 1204: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0xde8d04a0  ! 1205: LDUBA_R	lduba	[%r20, %r0] 0x25, %r15
	.word 0xd8dfa000  ! 1206: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0x87802072  ! 1207: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b62000  ! 1208: STHA_I	stha	%r12, [%r24 + 0x0000] %asi
	mov	0x38, %r27
	.word 0xd8de6000  ! 1210: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r12
	.word 0xd8d62000  ! 1211: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r12
	.word 0xdc9cc400  ! 1212: LDDA_R	ldda	[%r19, %r0] 0x20, %r14
	.word 0xdedee000  ! 1213: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r15
	.word 0xdeaf4e40  ! 1214: STBA_R	stba	%r15, [%r29 + %r0] 0x72
	.word 0xd2a66000  ! 1215: STWA_I	stwa	%r9, [%r25 + 0x0000] %asi
	.word 0xdab544a0  ! 1216: STHA_R	stha	%r13, [%r21 + %r0] 0x25
	.word 0x87802025  ! 1217: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xded74e80  ! 1218: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r15
	.word 0xd6af2000  ! 1219: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xd6bf6000  ! 1221: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd6a7e000  ! 1222: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6afa000  ! 1223: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6b7a000  ! 1224: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd6b7a000  ! 1225: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd8b7ce80  ! 1226: STHA_R	stha	%r12, [%r31 + %r0] 0x74
	.word 0xda8fa000  ! 1227: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0x87802025  ! 1228: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 1229: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r19
	.word 0xda866000  ! 1231: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r13
	mov	0x38, %r26
	.word 0xd6bf4e60  ! 1233: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	ta	T_CHANGE_PRIV	! macro
	.word 0xd6c78e40  ! 1235: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	.word 0xd68ee000  ! 1236: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r11
	mov	0x7e0, %r21
	mov	0x60, %r26
	.word 0xdcbd44a0  ! 1239: STDA_R	stda	%r14, [%r21 + %r0] 0x25
	mov	0x7f0, %r21
	.word 0x87802072  ! 1241: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcd78e80  ! 1242: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r14
	.word 0xdecc2000  ! 1243: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	.word 0xdea4a000  ! 1244: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xde84e000  ! 1245: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	.word 0xd2a7ce60  ! 1246: STWA_R	stwa	%r9, [%r31 + %r0] 0x73
	mov	0x7d0, %r21
	mov	0x68, %r19
	.word 0xdec584a0  ! 1249: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r15
	.word 0xdabce000  ! 1250: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0xdaaca000  ! 1251: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0xdcd78e40  ! 1252: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r14
	.word 0x87802074  ! 1253: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbc0400  ! 1254: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0xd8af4e60  ! 1255: STBA_R	stba	%r12, [%r29 + %r0] 0x73
	.word 0x87802020  ! 1256: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0852000  ! 1257: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r8
	.word 0xdad6c9e0  ! 1258: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r13
	mov	0x3f8, %r22
	mov	0x40, %r27
	.word 0xd6bf0e80  ! 1261: STDA_R	stda	%r11, [%r28 + %r0] 0x74
	.word 0xd0dc8400  ! 1262: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0xd0cd6000  ! 1263: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r8
	.word 0xd8b4c400  ! 1264: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	wr_tick_cmpr_3_16:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf9, %g2
	or	%g4, 0xb7, %g4
	or	%g6, 0xc3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdcf44400  ! 1266: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xd4a56000  ! 1267: STWA_I	stwa	%r10, [%r21 + 0x0000] %asi
	.word 0xd4a5a000  ! 1268: STWA_I	stwa	%r10, [%r22 + 0x0000] %asi
	.word 0xd2bf8e80  ! 1269: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	.word 0xd0bd6000  ! 1270: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0xd89e89e0  ! 1271: LDDA_R	ldda	[%r26, %r0] 0x4f, %r12
	.word 0xd8bde000  ! 1272: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 1273: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88584a0  ! 1274: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r12
	.word 0x8780204f  ! 1275: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabc8400  ! 1276: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	wr_tick_cmpr_3_17:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x9a, %g2
	or	%g4, 0x85, %g4
	or	%g6, 0xa4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0f4a000  ! 1278: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xda944400  ! 1279: LDUHA_R	lduha	[%r17, %r0] 0x20, %r13
	.word 0xd6878e80  ! 1280: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r11
	.word 0xd4a74e60  ! 1281: STWA_R	stwa	%r10, [%r29 + %r0] 0x73
	wr_tick_cmpr_3_18:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe7, %g2
	or	%g4, 0xa8, %g4
	or	%g6, 0xcc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3c8, %r20
	.word 0xd08ce000  ! 1284: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xdaccc400  ! 1285: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r13
	.word 0x8780204f  ! 1286: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4d584a0  ! 1287: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r10
	.word 0xdeb76000  ! 1288: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	mov	0x3f0, %r23
	.word 0xd4af4e40  ! 1290: STBA_R	stba	%r10, [%r29 + %r0] 0x72
	mov	0x7f0, %r20
	.word 0xd0bcc400  ! 1292: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0xd28f6000  ! 1293: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	mov	0x60, %r26
	.word 0xd49d44a0  ! 1295: LDDA_R	ldda	[%r21, %r0] 0x25, %r10
	.word 0xd8c7ce80  ! 1296: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r12
	.word 0xdab7e000  ! 1297: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	mov	0x0, %r19
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x20, %r18
	mov	0x68, %r27
	.word 0xdef5c4a0  ! 1302: STXA_R	stxa	%r15, [%r23 + %r0] 0x25
	.word 0xdcaf6000  ! 1303: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	mov	0x40, %r18
	.word 0xdc9fe000  ! 1305: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xdcc7a000  ! 1306: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xdea74e40  ! 1307: STWA_R	stwa	%r15, [%r29 + %r0] 0x72
	.word 0xdcc7e000  ! 1308: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 1309: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r24
	.word 0xdc9fe000  ! 1311: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0x87802020  ! 1312: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x28, %r25
	mov	0x20, %r24
	.word 0xdc9f6000  ! 1316: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xdcf74e80  ! 1317: STXA_R	stxa	%r14, [%r29 + %r0] 0x74
	.word 0xd8ac8400  ! 1318: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0xd4b7e000  ! 1319: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd4d7e000  ! 1320: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	mov	0x3e0, %r23
	mov	0x30, %r19
	.word 0xd49f2000  ! 1323: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd6948400  ! 1324: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	.word 0xdcf78e80  ! 1325: STXA_R	stxa	%r14, [%r30 + %r0] 0x74
	.word 0xd2c48400  ! 1326: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0xdcbfa000  ! 1327: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	mov	0x7e0, %r22
	mov	0x7d8, %r21
	.word 0x87802072  ! 1330: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca42000  ! 1331: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xdc94a000  ! 1332: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	mov	0x60, %r27
	.word 0xd6cc8400  ! 1334: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	.word 0x87802074  ! 1335: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 1336: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r16
	.word 0xdaace000  ! 1338: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0xd6b78e40  ! 1339: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	mov	0x58, %r16
	.word 0xd0a609e0  ! 1341: STWA_R	stwa	%r8, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 1342: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r19
	mov	0x48, %r25
	.word 0xda8d44a0  ! 1345: LDUBA_R	lduba	[%r21, %r0] 0x25, %r13
	.word 0x87802073  ! 1346: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf44400  ! 1347: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xd0d5e000  ! 1348: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r8
	.word 0x87802074  ! 1349: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1350: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r16
	.word 0xd0876000  ! 1352: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1353: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d0, %r23
	.word 0x87802072  ! 1355: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdec74e60  ! 1356: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r15
	.word 0xd89d84a0  ! 1357: LDDA_R	ldda	[%r22, %r0] 0x25, %r12
	mov	0x7d0, %r21
	.word 0x8780204f  ! 1359: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8d72000  ! 1360: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	mov	0x7d0, %r20
	.word 0x87802020  ! 1362: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r19
	.word 0xd6b544a0  ! 1364: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	.word 0xd6af4e60  ! 1365: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2f42000  ! 1367: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	mov	0x70, %r16
	mov	0x7d8, %r23
	.word 0xd0bf8e40  ! 1370: STDA_R	stda	%r8, [%r30 + %r0] 0x72
	.word 0xd4aca000  ! 1371: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0xd4a4a000  ! 1372: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xd2f40400  ! 1373: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xd8adc4a0  ! 1374: STBA_R	stba	%r12, [%r23 + %r0] 0x25
	mov	0x40, %r16
	mov	0x28, %r24
	.word 0x87802025  ! 1377: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6bd6000  ! 1378: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0xd6ada000  ! 1379: STBA_I	stba	%r11, [%r22 + 0x0000] %asi
	.word 0x8780204f  ! 1380: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 1381: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf40400  ! 1382: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xd4ce49e0  ! 1383: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r10
	mov	0x7c0, %r23
	.word 0xd28ea000  ! 1385: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r9
	.word 0xd2bee000  ! 1386: STDA_I	stda	%r9, [%r27 + 0x0000] %asi
	.word 0x87802025  ! 1387: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1388: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a46000  ! 1389: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2a42000  ! 1390: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 1391: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r18
	.word 0xdebd44a0  ! 1393: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	mov	0x60, %r18
	.word 0xd8a72000  ! 1395: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8a7e000  ! 1396: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	mov	0x20, %r26
	mov	0x30, %r27
	.word 0xd4b544a0  ! 1399: STHA_R	stha	%r10, [%r21 + %r0] 0x25
	.word 0xdccf2000  ! 1400: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xda87ce60  ! 1401: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r13
	mov	0x68, %r27
	mov	0x30, %r17
	.word 0xd2dfe000  ! 1404: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	mov	0x3f8, %r23
	.word 0xd2b72000  ! 1406: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1407: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6970e80  ! 1408: LDUHA_R	lduha	[%r28, %r0] 0x74, %r11
	mov	0x3e8, %r20
	.word 0xde9d6000  ! 1410: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 1411: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2be49e0  ! 1412: STDA_R	stda	%r9, [%r25 + %r0] 0x4f
	mov	0x8, %r24
	mov	0x7d0, %r22
	.word 0xdcb5a000  ! 1415: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0xdca5a000  ! 1416: STWA_I	stwa	%r14, [%r22 + 0x0000] %asi
	.word 0xdcaf0e60  ! 1417: STBA_R	stba	%r14, [%r28 + %r0] 0x73
	.word 0xd2bfce80  ! 1418: STDA_R	stda	%r9, [%r31 + %r0] 0x74
	.word 0xd4f5e000  ! 1419: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	.word 0xd89504a0  ! 1420: LDUHA_R	lduha	[%r20, %r0] 0x25, %r12
	.word 0x87802025  ! 1421: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2f504a0  ! 1422: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	.word 0xd8b40400  ! 1423: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0x87802020  ! 1424: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6948400  ! 1425: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	.word 0xde9f6000  ! 1426: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0xdebfa000  ! 1427: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1428: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8de000  ! 1429: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r15
	.word 0xdea5a000  ! 1430: STWA_I	stwa	%r15, [%r22 + 0x0000] %asi
	.word 0xd4b4c400  ! 1431: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0xdad78e80  ! 1432: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r13
	.word 0xd2f5a000  ! 1433: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	mov	0x3f0, %r23
	mov	0x48, %r18
	.word 0xd2956000  ! 1436: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r9
	.word 0xded78e80  ! 1437: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r15
	.word 0xdcbd6000  ! 1438: STDA_I	stda	%r14, [%r21 + 0x0000] %asi
	.word 0xdacf4e60  ! 1439: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r13
	mov	0x30, %r17
	.word 0xd0cc0400  ! 1441: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xd48de000  ! 1442: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r10
	.word 0xd2dc8400  ! 1443: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0x87802074  ! 1444: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf72000  ! 1445: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcb7e000  ! 1446: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xdca7a000  ! 1447: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	mov	0x78, %r25
	.word 0xdccfe000  ! 1449: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xdcf7a000  ! 1450: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcc76000  ! 1452: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xdc87a000  ! 1453: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcafa000  ! 1454: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xd8b44400  ! 1455: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0xdaf72000  ! 1456: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	mov	0x30, %r25
	.word 0xdeb4c400  ! 1458: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xdcacc400  ! 1459: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 1460: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdab4e000  ! 1461: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xd4a78e40  ! 1462: STWA_R	stwa	%r10, [%r30 + %r0] 0x72
	.word 0xd08ce000  ! 1463: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0946000  ! 1464: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0xd0c42000  ! 1465: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r8
	.word 0xd0ac6000  ! 1466: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	mov	0x28, %r19
	.word 0xdc94c400  ! 1468: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	.word 0xd0c4a000  ! 1469: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	mov	0x40, %r16
	mov	0x18, %r17
	.word 0x87802025  ! 1472: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r17
	mov	0x20, %r24
	.word 0xd6a649e0  ! 1475: STWA_R	stwa	%r11, [%r25 + %r0] 0x4f
	mov	0x58, %r19
	.word 0xd8aca000  ! 1477: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	mov	0x20, %r25
	.word 0xd8f46000  ! 1479: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8b4a000  ! 1480: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0xd897ce80  ! 1481: LDUHA_R	lduha	[%r31, %r0] 0x74, %r12
	.word 0x87802025  ! 1482: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f66000  ! 1483: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	.word 0x8780204f  ! 1484: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda8fce40  ! 1485: LDUBA_R	lduba	[%r31, %r0] 0x72, %r13
	mov	0x0, %r19
	.word 0x87802020  ! 1487: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r22
	.word 0x87802074  ! 1489: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2a4a000  ! 1490: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 1491: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 1492: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r17
	.word 0xd8f48400  ! 1494: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xd09584a0  ! 1495: LDUHA_R	lduha	[%r22, %r0] 0x25, %r8
	.word 0xd4bf6000  ! 1496: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd8b78e80  ! 1497: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	mov	0x60, %r16
	.word 0xdaa5c4a0  ! 1499: STWA_R	stwa	%r13, [%r23 + %r0] 0x25
	.word 0xd8dfa000  ! 1500: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	mov	0x40, %r25
	mov	0x30, %r27
	.word 0xd8d76000  ! 1503: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xd28c8400  ! 1504: LDUBA_R	lduba	[%r18, %r0] 0x20, %r9
	.word 0xd2d72000  ! 1505: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1506: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r22
	mov	0x20, %r18
	.word 0xd2ade000  ! 1509: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0xd8b7ce60  ! 1511: STHA_R	stha	%r12, [%r31 + %r0] 0x73
	.word 0xd4b4c400  ! 1512: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0xd49fce40  ! 1513: LDDA_R	ldda	[%r31, %r0] 0x72, %r10
	mov	0x78, %r16
	.word 0xd4cda000  ! 1515: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r10
	mov	0x0, %r24
	.word 0xd495a000  ! 1517: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r10
	.word 0xd4a5a000  ! 1518: STWA_I	stwa	%r10, [%r22 + 0x0000] %asi
	mov	0x7f0, %r23
	mov	0x28, %r17
	.word 0xd48de000  ! 1521: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r10
	.word 0xd49d6000  ! 1522: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r10
	.word 0xdaf7ce80  ! 1523: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	.word 0xda970e80  ! 1524: LDUHA_R	lduha	[%r28, %r0] 0x74, %r13
	.word 0xdea5e000  ! 1525: STWA_I	stwa	%r15, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 1526: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc84c400  ! 1527: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	.word 0xd0cf4e80  ! 1528: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r8
	.word 0xd6a4e000  ! 1529: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xd6b4e000  ! 1531: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xd2bf8e60  ! 1532: STDA_R	stda	%r9, [%r30 + %r0] 0x73
	mov	0x60, %r16
	.word 0x87802073  ! 1534: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaaf2000  ! 1535: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdadf2000  ! 1536: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0xdaa76000  ! 1537: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xdabf2000  ! 1538: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xdc970e60  ! 1539: LDUHA_R	lduha	[%r28, %r0] 0x73, %r14
	.word 0xd8bf0e60  ! 1540: STDA_R	stda	%r12, [%r28 + %r0] 0x73
	mov	0x8, %r27
	mov	0x7d8, %r22
	.word 0xd4bec9e0  ! 1543: STDA_R	stda	%r10, [%r27 + %r0] 0x4f
	.word 0x87802073  ! 1544: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd48e09e0  ! 1545: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r10
	.word 0xd2bf6000  ! 1546: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xd2c7a000  ! 1548: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2af6000  ! 1549: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	mov	0x40, %r19
	.word 0xdabc0400  ! 1551: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xdcf44400  ! 1552: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xdc9f2000  ! 1553: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xdcf72000  ! 1554: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	wr_tick_cmpr_3_19:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xda, %g2
	or	%g4, 0x8b, %g4
	or	%g6, 0xbe, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_PRIV	! macro
	.word 0xdc9d44a0  ! 1557: LDDA_R	ldda	[%r21, %r0] 0x25, %r14
	mov	0x3f0, %r23
	mov	0x3f8, %r21
	.word 0xdedf2000  ! 1560: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	mov	0x38, %r18
	.word 0xd0f544a0  ! 1562: STXA_R	stxa	%r8, [%r21 + %r0] 0x25
	.word 0xd6d584a0  ! 1563: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r11
	.word 0xde970e80  ! 1564: LDUHA_R	lduha	[%r28, %r0] 0x74, %r15
	.word 0xd2a40400  ! 1565: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xd6c76000  ! 1566: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd0a4c400  ! 1567: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xdcdc8400  ! 1568: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	mov	0x10, %r19
	.word 0xdc976000  ! 1570: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	.word 0xdcbfe000  ! 1571: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdccf6000  ! 1572: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdc972000  ! 1573: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	mov	0x7f0, %r20
	.word 0xdcb7e000  ! 1575: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 1576: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbde000  ! 1577: STDA_I	stda	%r14, [%r23 + 0x0000] %asi
	.word 0xda8f8e60  ! 1578: LDUBA_R	lduba	[%r30, %r0] 0x73, %r13
	.word 0xdab74e80  ! 1579: STHA_R	stha	%r13, [%r29 + %r0] 0x74
	.word 0xd487ce80  ! 1580: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r10
	.word 0xded5a000  ! 1581: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r15
	.word 0xde9da000  ! 1582: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r15
	.word 0xde940400  ! 1583: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0xd0bf8e80  ! 1584: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	mov	0x3c0, %r23
	.word 0xd6ad84a0  ! 1586: STBA_R	stba	%r11, [%r22 + %r0] 0x25
	.word 0xd4ac8400  ! 1587: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0xdeb5e000  ! 1588: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	.word 0xd2cc8400  ! 1589: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0x87802020  ! 1590: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_3_20:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x85, %g2
	or	%g4, 0xad, %g4
	or	%g6, 0x97, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	wr_tick_cmpr_3_21:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe5, %g2
	or	%g4, 0xc8, %g4
	or	%g6, 0xe9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8940400  ! 1593: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	.word 0x87802072  ! 1594: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd68fce40  ! 1595: LDUBA_R	lduba	[%r31, %r0] 0x72, %r11
	.word 0xd28ce000  ! 1596: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	mov	0x38, %r25
	.word 0xdcacc400  ! 1598: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0x87802073  ! 1599: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a4a000  ! 1600: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0xd0cc2000  ! 1601: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	.word 0xd08ca000  ! 1602: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xd0a40400  ! 1603: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	mov	0x78, %r25
	.word 0x87802020  ! 1605: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a44400  ! 1606: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xd8f74e60  ! 1607: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	.word 0xd2b74e80  ! 1608: STHA_R	stha	%r9, [%r29 + %r0] 0x74
	.word 0xd6ac2000  ! 1609: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 1610: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7e8, %r21
	wr_tick_cmpr_3_22:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc1, %g2
	or	%g4, 0xb4, %g4
	or	%g6, 0xf0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4c5c4a0  ! 1613: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r10
	wr_tick_cmpr_3_23:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x84, %g2
	or	%g4, 0xd9, %g4
	or	%g6, 0x94, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdea46000  ! 1615: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xd0de89e0  ! 1616: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r8
	.word 0xdcace000  ! 1617: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xdcf46000  ! 1619: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xda8504a0  ! 1620: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r13
	.word 0xd4a44400  ! 1621: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xdcd74e60  ! 1622: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r14
	mov	0x78, %r19
	.word 0xd6c44400  ! 1624: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r11
	.word 0xd8d4a000  ! 1625: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	wr_tick_cmpr_3_24:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x92, %g2
	or	%g4, 0xdc, %g4
	or	%g6, 0xb0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x58, %r26
	.word 0xdec40400  ! 1628: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xd4f7ce80  ! 1629: STXA_R	stxa	%r10, [%r31 + %r0] 0x74
	.word 0xd68f4e80  ! 1630: LDUBA_R	lduba	[%r29, %r0] 0x74, %r11
	mov	0x10, %r27
	mov	0x28, %r24
	.word 0xd49504a0  ! 1633: LDUHA_R	lduha	[%r20, %r0] 0x25, %r10
	mov	0x50, %r19
	.word 0xdef609e0  ! 1635: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	.word 0xdeb7ce80  ! 1636: STHA_R	stha	%r15, [%r31 + %r0] 0x74
	.word 0xde8c2000  ! 1637: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	.word 0xdeb4e000  ! 1638: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xdea4e000  ! 1640: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	wr_tick_cmpr_3_25:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb1, %g2
	or	%g4, 0xd9, %g4
	or	%g6, 0xf5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdac689e0  ! 1642: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r13
	.word 0xd8a7ce60  ! 1643: STWA_R	stwa	%r12, [%r31 + %r0] 0x73
	.word 0x87802074  ! 1644: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdedee000  ! 1645: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r15
	mov	0x7e0, %r22
	mov	0x7d0, %r20
	mov	0x0, %r17
	.word 0xd0be49e0  ! 1649: STDA_R	stda	%r8, [%r25 + %r0] 0x4f
	.word 0x87802074  ! 1650: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b7ce60  ! 1651: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	.word 0x87802020  ! 1652: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab7ce80  ! 1653: STHA_R	stha	%r13, [%r31 + %r0] 0x74
	.word 0xdec4a000  ! 1654: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xde8ca000  ! 1655: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	mov	0x70, %r17
	.word 0xd8f504a0  ! 1657: STXA_R	stxa	%r12, [%r20 + %r0] 0x25
	wr_tick_cmpr_3_26:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xeb, %g2
	or	%g4, 0xc7, %g4
	or	%g6, 0xfc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdad40400  ! 1659: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	.word 0xd6d70e60  ! 1660: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r11
	mov	0x7e8, %r20
	.word 0xdecf0e60  ! 1662: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r15
	mov	0x3c0, %r21
	.word 0xd8c4e000  ! 1664: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	.word 0xd2cf0e80  ! 1665: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r9
	.word 0xdcbc2000  ! 1666: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	mov	0x68, %r24
	.word 0xdcac8400  ! 1668: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xdaac0400  ! 1669: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xd8b4e000  ! 1670: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	mov	0x38, %r24
	mov	0x10, %r24
	.word 0x87802074  ! 1673: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8dda000  ! 1674: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r12
	.word 0xdcbf0e40  ! 1675: STDA_R	stda	%r14, [%r28 + %r0] 0x72
	.word 0xd0a78e80  ! 1676: STWA_R	stwa	%r8, [%r30 + %r0] 0x74
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802025  ! 1678: WRASI_I	wr	%r0, 0x0025, %asi
	wr_tick_cmpr_3_27:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xfc, %g2
	or	%g4, 0x9c, %g4
	or	%g6, 0xe6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdaaf4e60  ! 1680: STBA_R	stba	%r13, [%r29 + %r0] 0x73
	.word 0xdac40400  ! 1681: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	.word 0xd8840400  ! 1682: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r12
	.word 0xd8a76000  ! 1683: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xd88fe000  ! 1684: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd88f6000  ! 1685: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0x87802025  ! 1686: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8ac2000  ! 1687: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	mov	0x0, %r24
	.word 0xd88c6000  ! 1689: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	.word 0xdcf40400  ! 1690: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0x87802020  ! 1691: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1692: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 1693: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 1694: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbf4e80  ! 1695: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	.word 0xd2bfe000  ! 1696: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	mov	0x38, %r25
	mov	0x8, %r24
	.word 0xd2afe000  ! 1699: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 1700: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8970e80  ! 1701: LDUHA_R	lduha	[%r28, %r0] 0x74, %r12
	mov	0x60, %r18
	.word 0xd4a7a000  ! 1703: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4a7e000  ! 1704: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4f7e000  ! 1705: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4d76000  ! 1706: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0x87802072  ! 1707: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1708: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b76000  ! 1709: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	mov	0x3e0, %r22
	mov	0x30, %r25
	.word 0xd68d84a0  ! 1712: LDUBA_R	lduba	[%r22, %r0] 0x25, %r11
	.word 0xd4afe000  ! 1713: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	mov	0x3d0, %r23
	.word 0xd0d78e80  ! 1715: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r8
	mov	0x68, %r24
	mov	0x60, %r16
	mov	0x60, %r24
	.word 0xd6bf0e80  ! 1719: STDA_R	stda	%r11, [%r28 + %r0] 0x74
	.word 0xdaf7ce80  ! 1720: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	.word 0xd2bf6000  ! 1721: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 1722: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdedf4e40  ! 1723: LDXA_R	ldxa	[%r29, %r0] 0x72, %r15
	mov	0x3d8, %r23
	.word 0x87802020  ! 1725: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b7ce80  ! 1726: STHA_R	stha	%r11, [%r31 + %r0] 0x74
	.word 0xdaf62000  ! 1727: STXA_I	stxa	%r13, [%r24 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0df8e40  ! 1729: LDXA_R	ldxa	[%r30, %r0] 0x72, %r8
	.word 0xd89fce40  ! 1730: LDDA_R	ldda	[%r31, %r0] 0x72, %r12
	.word 0xdab7ce80  ! 1731: STHA_R	stha	%r13, [%r31 + %r0] 0x74
	.word 0xda870e80  ! 1732: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r13
	mov	0x58, %r16
	.word 0xdcb78e40  ! 1734: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0x87802025  ! 1735: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcc76000  ! 1736: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xd69fce80  ! 1737: LDDA_R	ldda	[%r31, %r0] 0x74, %r11
	.word 0xd28fa000  ! 1738: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	.word 0xd4df0e60  ! 1739: LDXA_R	ldxa	[%r28, %r0] 0x73, %r10
	.word 0x87802072  ! 1740: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdad7e000  ! 1741: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xd6a78e40  ! 1742: STWA_R	stwa	%r11, [%r30 + %r0] 0x72
	.word 0xde9c8400  ! 1743: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	.word 0x87802072  ! 1744: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdad7ce40  ! 1745: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r13
	.word 0xdaf5e000  ! 1746: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	mov	0x3c0, %r23
	.word 0xdca7ce40  ! 1748: STWA_R	stwa	%r14, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 1749: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8af8e60  ! 1750: STBA_R	stba	%r12, [%r30 + %r0] 0x73
	.word 0xdab76000  ! 1751: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdabfe000  ! 1752: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xdac72000  ! 1753: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	mov	0x0, %r16
	mov	0x60, %r16
	.word 0xd687ce60  ! 1756: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r11
	mov	0x40, %r19
	mov	0x60, %r25
	.word 0xd6840400  ! 1759: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0xd8948400  ! 1760: LDUHA_R	lduha	[%r18, %r0] 0x20, %r12
	.word 0xde9f2000  ! 1761: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	mov	0x28, %r17
	.word 0x87802073  ! 1763: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8874e80  ! 1764: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r12
	.word 0xd6ac0400  ! 1765: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0xd6afe000  ! 1766: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd6afe000  ! 1767: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xda8689e0  ! 1769: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r13
	.word 0x87802025  ! 1770: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2af2000  ! 1771: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 1772: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r19
	mov	0x7f8, %r20
	.word 0xd4970e60  ! 1775: LDUHA_R	lduha	[%r28, %r0] 0x73, %r10
	mov	0x28, %r16
	.word 0xdaa42000  ! 1777: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0xd4f504a0  ! 1778: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0x87802073  ! 1779: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r16
	mov	0x3c0, %r23
	mov	0x30, %r27
	.word 0xdcaf2000  ! 1783: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdcc7a000  ! 1784: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	mov	0x18, %r27
	.word 0xdcf76000  ! 1786: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x60, %r24
	.word 0x87802074  ! 1788: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc95a000  ! 1789: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r14
	.word 0xd695c4a0  ! 1790: LDUHA_R	lduha	[%r23, %r0] 0x25, %r11
	.word 0xd2b56000  ! 1791: STHA_I	stha	%r9, [%r21 + 0x0000] %asi
	.word 0xd8c689e0  ! 1792: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r12
	.word 0xd0b70e80  ! 1793: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	.word 0xd6b7ce60  ! 1794: STHA_R	stha	%r11, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 1795: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r17
	.word 0xded42000  ! 1797: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	.word 0xdea4e000  ! 1798: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 1799: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r16
	.word 0xd4bf4e80  ! 1801: STDA_R	stda	%r10, [%r29 + %r0] 0x74
	.word 0xd2f584a0  ! 1802: STXA_R	stxa	%r9, [%r22 + %r0] 0x25
	.word 0xde9d04a0  ! 1803: LDDA_R	ldda	[%r20, %r0] 0x25, %r15
	.word 0xdacfa000  ! 1804: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xdaaf2000  ! 1805: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdaf7a000  ! 1806: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0xdab7a000  ! 1808: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 1809: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda872000  ! 1810: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	mov	0x7f0, %r22
	.word 0xdaf7a000  ! 1812: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdca44400  ! 1813: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	mov	0x50, %r16
	.word 0x87802072  ! 1815: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2848400  ! 1816: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r9
	.word 0xd6d48400  ! 1817: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0x87802020  ! 1818: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r24
	.word 0x87802025  ! 1820: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4f76000  ! 1821: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4bfe000  ! 1822: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802020  ! 1824: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b5c4a0  ! 1825: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	.word 0xdcf40400  ! 1826: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	mov	0x50, %r26
	.word 0xdccf8e40  ! 1828: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r14
	.word 0xd0f6a000  ! 1829: STXA_I	stxa	%r8, [%r26 + 0x0000] %asi
	.word 0xd08ee000  ! 1830: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r8
	.word 0x87802072  ! 1831: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6cf8e40  ! 1832: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r11
	.word 0xdca70e80  ! 1833: STWA_R	stwa	%r14, [%r28 + %r0] 0x74
	mov	0x7e0, %r23
	.word 0x87802073  ! 1835: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r27
	.word 0x8780204f  ! 1837: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc8d2000  ! 1838: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r14
	.word 0xdc95e000  ! 1839: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r14
	.word 0xd6b689e0  ! 1840: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	.word 0xd0b5a000  ! 1841: STHA_I	stha	%r8, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 1842: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcafce80  ! 1843: STBA_R	stba	%r14, [%r31 + %r0] 0x74
	.word 0xdc9f4e40  ! 1844: LDDA_R	ldda	[%r29, %r0] 0x72, %r14
	mov	0x28, %r17
	.word 0xda84e000  ! 1846: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1847: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08c8400  ! 1848: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0xd0dfa000  ! 1849: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0x87802073  ! 1850: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0ac2000  ! 1851: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	mov	0x38, %r16
	mov	0x28, %r25
	mov	0x40, %r26
	.word 0x8780204f  ! 1855: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r27
	.word 0xdedf0e80  ! 1857: LDXA_R	ldxa	[%r28, %r0] 0x74, %r15
	.word 0xd4bd84a0  ! 1858: STDA_R	stda	%r10, [%r22 + %r0] 0x25
	.word 0xd48609e0  ! 1859: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r10
	.word 0x87802073  ! 1860: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0c4a000  ! 1861: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	.word 0x87802072  ! 1862: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 1863: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r17
	.word 0xd0cfe000  ! 1865: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1866: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r27
	.word 0xda9cc400  ! 1868: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	mov	0x28, %r16
	.word 0xd0b72000  ! 1870: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd0dfe000  ! 1871: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	mov	0x58, %r25
	.word 0xd0cf6000  ! 1873: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd0d76000  ! 1874: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	mov	0x18, %r25
	.word 0xd0dfe000  ! 1876: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0x87802073  ! 1877: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r19
	mov	0x58, %r18
	.word 0xd2af8e40  ! 1880: STBA_R	stba	%r9, [%r30 + %r0] 0x72
	.word 0xd4ad44a0  ! 1881: STBA_R	stba	%r10, [%r21 + %r0] 0x25
	mov	0x3c0, %r22
	mov	0x78, %r17
	.word 0xdef4e000  ! 1884: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 1885: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 1886: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde9609e0  ! 1887: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r15
	mov	0x20, %r19
	.word 0xd4d42000  ! 1889: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	mov	0x0, %r24
	.word 0xdca78e40  ! 1891: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	.word 0xd4f42000  ! 1892: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd8a70e80  ! 1893: STWA_R	stwa	%r12, [%r28 + %r0] 0x74
	.word 0xdca4a000  ! 1894: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 1895: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca7a000  ! 1896: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	mov	0x48, %r27
	.word 0xdaa6c9e0  ! 1898: STWA_R	stwa	%r13, [%r27 + %r0] 0x4f
	.word 0xd8f76000  ! 1899: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd4bc8400  ! 1900: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	mov	0x70, %r27
	.word 0xda97a000  ! 1902: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xdadfce40  ! 1903: LDXA_R	ldxa	[%r31, %r0] 0x72, %r13
	ta	T_CHANGE_PRIV	! macro
	.word 0xd6cfe000  ! 1905: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	mov	0x3d0, %r23
	mov	0x7e8, %r22
	mov	0x38, %r25
	.word 0x8780204f  ! 1909: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd695a000  ! 1910: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r11
	mov	0x78, %r24
	.word 0xd6c7ce60  ! 1912: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r11
	.word 0xd0bda000  ! 1913: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	.word 0xd8af0e40  ! 1914: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	.word 0xdcdde000  ! 1915: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	.word 0x87802020  ! 1916: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdade89e0  ! 1917: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r13
	.word 0xd4f44400  ! 1918: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0xd0bfce40  ! 1919: STDA_R	stda	%r8, [%r31 + %r0] 0x72
	.word 0x87802072  ! 1920: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r25
	.word 0xdebdc4a0  ! 1922: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	.word 0xd6cda000  ! 1923: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r11
	.word 0xdccf8e80  ! 1924: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r14
	mov	0x7c8, %r21
	mov	0x3f0, %r20
	.word 0x87802020  ! 1927: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f4c400  ! 1928: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xd4dcc400  ! 1929: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0x87802025  ! 1930: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c8, %r20
	.word 0x8780204f  ! 1932: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6a40400  ! 1933: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0xdabf4e40  ! 1934: STDA_R	stda	%r13, [%r29 + %r0] 0x72
	.word 0xdef78e60  ! 1935: STXA_R	stxa	%r15, [%r30 + %r0] 0x73
	.word 0xd8b74e80  ! 1936: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	.word 0xdedee000  ! 1937: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r15
	.word 0xded66000  ! 1938: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r15
	.word 0xdeb66000  ! 1939: STHA_I	stha	%r15, [%r25 + 0x0000] %asi
	.word 0xdeaea000  ! 1940: STBA_I	stba	%r15, [%r26 + 0x0000] %asi
	.word 0xde86a000  ! 1941: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r15
	.word 0xd2f40400  ! 1942: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xdaf74e80  ! 1943: STXA_R	stxa	%r13, [%r29 + %r0] 0x74
	mov	0x0, %r25
	.word 0xd4acc400  ! 1945: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xdc8e09e0  ! 1946: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r14
	.word 0x87802020  ! 1947: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1948: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabc2000  ! 1949: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 1950: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdadc6000  ! 1951: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xdaf46000  ! 1952: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0xd09609e0  ! 1953: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r8
	.word 0xdc9c6000  ! 1954: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r14
	.word 0xde8ec9e0  ! 1955: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r15
	.word 0xd8b78e60  ! 1956: STHA_R	stha	%r12, [%r30 + %r0] 0x73
	.word 0xda8c2000  ! 1957: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r13
	.word 0xdab42000  ! 1958: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0x87802074  ! 1960: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1961: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac40400  ! 1962: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	mov	0x3c0, %r23
	mov	0x48, %r17
	mov	0x50, %r27
	.word 0xd0dfa000  ! 1966: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	mov	0x40, %r26
	mov	0x8, %r17
	.word 0x87802072  ! 1969: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r16
	mov	0x3f0, %r20
	mov	0x18, %r25
	.word 0xd0cc6000  ! 1973: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	mov	0x60, %r17
	.word 0xd09c2000  ! 1975: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r8
	mov	0x40, %r16
	mov	0x30, %r27
	.word 0xd6c584a0  ! 1978: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r11
	mov	0x3e0, %r20
	.word 0xd89c6000  ! 1980: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r12
	.word 0xdab74e80  ! 1981: STHA_R	stha	%r13, [%r29 + %r0] 0x74
	.word 0xdc8c8400  ! 1982: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0x87802020  ! 1983: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68e09e0  ! 1984: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r11
	.word 0xdcd5a000  ! 1985: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r14
	.word 0xd0df8e40  ! 1986: LDXA_R	ldxa	[%r30, %r0] 0x72, %r8
	.word 0xdab7ce60  ! 1987: STHA_R	stha	%r13, [%r31 + %r0] 0x73
	mov	0x30, %r19
	.word 0xd8a52000  ! 1989: STWA_I	stwa	%r12, [%r20 + 0x0000] %asi
	.word 0xd89d2000  ! 1990: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r12
	mov	0x3d0, %r22
	.word 0xd0ce49e0  ! 1992: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r8
	mov	0x30, %r27
	mov	0x30, %r24
	.word 0x87802074  ! 1995: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 1996: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2bfa000  ! 1997: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xd6870e80  ! 1999: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r11
	.word 0xd4bd84a0  ! 2000: STDA_R	stda	%r10, [%r22 + %r0] 0x25
	.word 0xdaf70e80  ! 2001: STXA_R	stxa	%r13, [%r28 + %r0] 0x74
	.word 0xdcf72000  ! 2002: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	mov	0x38, %r16
	.word 0x8780204f  ! 2004: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2005: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4940400  ! 2006: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	mov	0x3f8, %r21
	.word 0xd6bcc400  ! 2008: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0xd0a48400  ! 2009: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	mov	0x18, %r16
	.word 0xd8f76000  ! 2011: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8d72000  ! 2012: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xd8bf6000  ! 2013: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xd8b4c400  ! 2015: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0x87802074  ! 2016: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2017: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r19
	.word 0x87802074  ! 2019: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f56000  ! 2020: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	.word 0xd6ccc400  ! 2021: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	.word 0xdc9d6000  ! 2022: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r14
	.word 0xdcade000  ! 2023: STBA_I	stba	%r14, [%r23 + 0x0000] %asi
	.word 0xd08fce60  ! 2024: LDUBA_R	lduba	[%r31, %r0] 0x73, %r8
	.word 0xdec52000  ! 2025: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802072  ! 2027: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeaf2000  ! 2028: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xdedf2000  ! 2029: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	mov	0x38, %r18
	.word 0xdeb44400  ! 2031: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0xdcf609e0  ! 2032: STXA_R	stxa	%r14, [%r24 + %r0] 0x4f
	.word 0xd0f44400  ! 2033: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xdad76000  ! 2034: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 2035: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde8f4e80  ! 2036: LDUBA_R	lduba	[%r29, %r0] 0x74, %r15
	.word 0xdecf2000  ! 2037: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xdec7e000  ! 2038: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xdecfce80  ! 2039: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r15
	.word 0xd09f6000  ! 2040: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	mov	0x18, %r17
	mov	0x78, %r25
	.word 0xd0afce80  ! 2043: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	mov	0x10, %r18
	.word 0x87802073  ! 2045: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6be89e0  ! 2046: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	.word 0xd0a6a000  ! 2047: STWA_I	stwa	%r8, [%r26 + 0x0000] %asi
	mov	0x40, %r16
	mov	0x7c0, %r22
	.word 0xd8df4e60  ! 2050: LDXA_R	ldxa	[%r29, %r0] 0x73, %r12
	.word 0x87802020  ! 2051: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r16
	.word 0xd2b48400  ! 2053: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0x87802074  ! 2054: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8d5a000  ! 2055: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r12
	mov	0x40, %r24
	mov	0x78, %r18
	.word 0xdaa74e80  ! 2058: STWA_R	stwa	%r13, [%r29 + %r0] 0x74
	.word 0xdaf5a000  ! 2059: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0x87802072  ! 2061: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaae6000  ! 2062: STBA_I	stba	%r13, [%r25 + 0x0000] %asi
	.word 0x87802073  ! 2063: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdabf2000  ! 2064: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 2065: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r25
	wr_tick_cmpr_3_28:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x85, %g2
	or	%g4, 0x81, %g4
	or	%g6, 0xc5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdea74e80  ! 2068: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	.word 0x87802020  ! 2069: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda970e80  ! 2070: LDUHA_R	lduha	[%r28, %r0] 0x74, %r13
	.word 0xd8840400  ! 2071: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r12
	.word 0x87802072  ! 2072: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r18
	.word 0xd8bd04a0  ! 2074: STDA_R	stda	%r12, [%r20 + %r0] 0x25
	.word 0xd696e000  ! 2075: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	.word 0xdacc4400  ! 2076: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	.word 0x87802025  ! 2077: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f44400  ! 2078: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd496e000  ! 2079: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r10
	.word 0xd4de6000  ! 2080: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r10
	.word 0xd4f66000  ! 2081: STXA_I	stxa	%r10, [%r25 + 0x0000] %asi
	mov	0x20, %r17
	.word 0x87802074  ! 2083: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b42000  ! 2084: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	wr_tick_cmpr_3_29:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xc1, %g2
	or	%g4, 0xe6, %g4
	or	%g6, 0x80, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd6af8e60  ! 2086: STBA_R	stba	%r11, [%r30 + %r0] 0x73
	mov	0x20, %r19
	.word 0xde8c8400  ! 2088: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	.word 0x87802020  ! 2089: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8870e40  ! 2090: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r12
	.word 0xd2bc4400  ! 2091: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0x87802025  ! 2092: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r26
	.word 0x87802073  ! 2094: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e0, %r20
	.word 0xdecfce80  ! 2096: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r15
	.word 0xd0b44400  ! 2097: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	mov	0x60, %r27
	.word 0xdca42000  ! 2099: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	mov	0x0, %r27
	mov	0x30, %r25
	.word 0xdcbc2000  ! 2102: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 2103: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r19
	.word 0xdcdca000  ! 2105: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xde978e40  ! 2106: LDUHA_R	lduha	[%r30, %r0] 0x72, %r15
	.word 0xd88c6000  ! 2107: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	.word 0xdcaf4e80  ! 2108: STBA_R	stba	%r14, [%r29 + %r0] 0x74
	.word 0xd2d4e000  ! 2109: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0xd2af0e40  ! 2110: STBA_R	stba	%r9, [%r28 + %r0] 0x72
	.word 0xd2dc0400  ! 2111: LDXA_R	ldxa	[%r16, %r0] 0x20, %r9
	.word 0xd4ac4400  ! 2112: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xd8b4a000  ! 2113: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0xd0dd04a0  ! 2114: LDXA_R	ldxa	[%r20, %r0] 0x25, %r8
	.word 0xd0c4e000  ! 2115: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	.word 0xd4afce60  ! 2116: STBA_R	stba	%r10, [%r31 + %r0] 0x73
	.word 0xdef46000  ! 2117: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xdeaca000  ! 2118: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xde946000  ! 2119: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r15
	.word 0xdef42000  ! 2120: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xdeac2000  ! 2121: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	mov	0x30, %r16
	.word 0xdeb42000  ! 2123: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0xdaa609e0  ! 2124: STWA_R	stwa	%r13, [%r24 + %r0] 0x4f
	mov	0x60, %r19
	.word 0x8780204f  ! 2126: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcdf4e40  ! 2127: LDXA_R	ldxa	[%r29, %r0] 0x72, %r14
	.word 0xdcf40400  ! 2128: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	mov	0x3e8, %r22
	.word 0xdecfe000  ! 2130: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	mov	0x7c8, %r20
	.word 0xdef76000  ! 2132: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdec7a000  ! 2133: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xded76000  ! 2134: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0xd68cc400  ! 2135: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	mov	0x3d8, %r20
	.word 0xd4ae09e0  ! 2137: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 2138: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 2139: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a4a000  ! 2140: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	mov	0x30, %r27
	.word 0xd0bf8e40  ! 2142: STDA_R	stda	%r8, [%r30 + %r0] 0x72
	mov	0x30, %r25
	.word 0x87802020  ! 2144: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2145: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdebdc4a0  ! 2146: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	.word 0xdad609e0  ! 2147: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r13
	.word 0xdcf504a0  ! 2148: STXA_R	stxa	%r14, [%r20 + %r0] 0x25
	.word 0x87802072  ! 2149: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2150: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2151: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 2152: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8956000  ! 2153: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r12
	.word 0xd89de000  ! 2154: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r12
	.word 0x87802073  ! 2155: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2d4c400  ! 2156: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r9
	.word 0xd4a78e80  ! 2157: STWA_R	stwa	%r10, [%r30 + %r0] 0x74
	.word 0xd29f4e80  ! 2158: LDDA_R	ldda	[%r29, %r0] 0x74, %r9
	.word 0xd4d5a000  ! 2159: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r10
	.word 0x87802074  ! 2160: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c8, %r21
	.word 0xd6f649e0  ! 2162: STXA_R	stxa	%r11, [%r25 + %r0] 0x4f
	.word 0xdecfa000  ! 2163: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xd897ce80  ! 2164: LDUHA_R	lduha	[%r31, %r0] 0x74, %r12
	.word 0xdca7a000  ! 2165: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcc7e000  ! 2166: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0xdc87a000  ! 2167: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcc76000  ! 2168: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0x87802025  ! 2169: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d8, %r20
	.word 0xd8f4c400  ! 2171: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	wr_tick_cmpr_3_30:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x8a, %g2
	or	%g4, 0xda, %g4
	or	%g6, 0xbc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdc8f6000  ! 2173: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcc72000  ! 2174: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xdc8f6000  ! 2175: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdc944400  ! 2176: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	.word 0x87802073  ! 2177: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 2178: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2179: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd09c2000  ! 2180: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r8
	.word 0xd8ac8400  ! 2181: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0xd6946000  ! 2182: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r11
	.word 0xd694a000  ! 2183: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r11
	mov	0x7d0, %r23
	.word 0xd6d4e000  ! 2185: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r11
	mov	0x50, %r16
	.word 0xd6b42000  ! 2187: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 2188: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6cfa000  ! 2189: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0xdcd7ce40  ! 2190: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r14
	.word 0xd6b7e000  ! 2191: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd8dd04a0  ! 2192: LDXA_R	ldxa	[%r20, %r0] 0x25, %r12
	.word 0xdcb48400  ! 2193: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xde970e60  ! 2194: LDUHA_R	lduha	[%r28, %r0] 0x73, %r15
	.word 0xda97e000  ! 2195: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	.word 0xdaa76000  ! 2196: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 2197: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2198: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6afce60  ! 2199: STBA_R	stba	%r11, [%r31 + %r0] 0x73
	.word 0xd2de89e0  ! 2200: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r9
	.word 0xd0c70e40  ! 2201: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r8
	.word 0xd6a66000  ! 2202: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	.word 0xd6cea000  ! 2203: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	.word 0xdc940400  ! 2204: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0xd2f7ce80  ! 2205: STXA_R	stxa	%r9, [%r31 + %r0] 0x74
	.word 0xd2f40400  ! 2206: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xd0b66000  ! 2207: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	.word 0xda9c4400  ! 2208: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	.word 0x8780204f  ! 2209: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8f74e40  ! 2210: STXA_R	stxa	%r12, [%r29 + %r0] 0x72
	.word 0xdcf66000  ! 2211: STXA_I	stxa	%r14, [%r25 + 0x0000] %asi
	mov	0x28, %r19
	.word 0x87802072  ! 2213: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd095c4a0  ! 2214: LDUHA_R	lduha	[%r23, %r0] 0x25, %r8
	mov	0x3f0, %r23
	.word 0xd6f44400  ! 2216: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0xd8cfe000  ! 2217: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xdc9f8e80  ! 2218: LDDA_R	ldda	[%r30, %r0] 0x74, %r14
	.word 0xd2f74e40  ! 2219: STXA_R	stxa	%r9, [%r29 + %r0] 0x72
	.word 0x87802020  ! 2220: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r24
	.word 0xd2cf2000  ! 2222: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r9
	.word 0x87802025  ! 2223: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2224: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r17
	.word 0xdcbf8e80  ! 2226: STDA_R	stda	%r14, [%r30 + %r0] 0x74
	mov	0x7d8, %r23
	.word 0xd6bf6000  ! 2228: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xdabd84a0  ! 2229: STDA_R	stda	%r13, [%r22 + %r0] 0x25
	mov	0x60, %r17
	.word 0x8780204f  ! 2231: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9c6000  ! 2232: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xdcad84a0  ! 2233: STBA_R	stba	%r14, [%r22 + %r0] 0x25
	wr_tick_cmpr_3_31:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xbc, %g2
	or	%g4, 0xc5, %g4
	or	%g6, 0xe2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802072  ! 2235: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0bfce80  ! 2236: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	.word 0xd6cdc4a0  ! 2237: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r11
	.word 0xd6c7ce40  ! 2238: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r11
	.word 0xdac76000  ! 2239: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0xd0b78e60  ! 2240: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	mov	0x3c8, %r20
	.word 0x87802074  ! 2242: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r27
	.word 0xd2cfa000  ! 2244: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	mov	0x7d0, %r21
	.word 0x87802025  ! 2246: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd28c6000  ! 2247: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd68cc400  ! 2249: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	.word 0xdc8ce000  ! 2250: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	.word 0xd2f609e0  ! 2251: STXA_R	stxa	%r9, [%r24 + %r0] 0x4f
	mov	0x7c8, %r21
	.word 0x87802020  ! 2253: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc940400  ! 2254: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	mov	0x28, %r18
	.word 0xdca4c400  ! 2256: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xdea4c400  ! 2257: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	.word 0x87802072  ! 2258: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r26
	mov	0x7e8, %r21
	.word 0x87802020  ! 2261: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdc6000  ! 2262: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	mov	0x7c0, %r23
	mov	0x78, %r27
	.word 0xdaf6c9e0  ! 2265: STXA_R	stxa	%r13, [%r27 + %r0] 0x4f
	.word 0xd89dc4a0  ! 2266: LDDA_R	ldda	[%r23, %r0] 0x25, %r12
	.word 0xd2c74e40  ! 2267: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r9
	.word 0x87802073  ! 2268: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2a609e0  ! 2269: STWA_R	stwa	%r9, [%r24 + %r0] 0x4f
	.word 0xd89fce40  ! 2270: LDDA_R	ldda	[%r31, %r0] 0x72, %r12
	mov	0x30, %r19
	.word 0x87802072  ! 2272: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcdd44a0  ! 2273: LDXA_R	ldxa	[%r21, %r0] 0x25, %r14
	.word 0xd4a544a0  ! 2274: STWA_R	stwa	%r10, [%r21 + %r0] 0x25
	.word 0xd2aec9e0  ! 2275: STBA_R	stba	%r9, [%r27 + %r0] 0x4f
	mov	0x8, %r25
	mov	0x78, %r19
	mov	0x58, %r16
	.word 0xdedf0e80  ! 2279: LDXA_R	ldxa	[%r28, %r0] 0x74, %r15
	.word 0xda848400  ! 2280: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r13
	.word 0x87802072  ! 2281: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b4e000  ! 2282: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	mov	0x30, %r17
	mov	0x28, %r24
	.word 0xd8b4a000  ! 2285: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0xd0bec9e0  ! 2286: STDA_R	stda	%r8, [%r27 + %r0] 0x4f
	.word 0xd88fce60  ! 2287: LDUBA_R	lduba	[%r31, %r0] 0x73, %r12
	mov	0x30, %r19
	.word 0xdeaf0e40  ! 2289: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	mov	0x3e0, %r20
	.word 0xde9ec9e0  ! 2291: LDDA_R	ldda	[%r27, %r0] 0x4f, %r15
	.word 0xd4d48400  ! 2292: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	.word 0xda8d04a0  ! 2293: LDUBA_R	lduba	[%r20, %r0] 0x25, %r13
	mov	0x3e8, %r21
	.word 0xde9f8e60  ! 2295: LDDA_R	ldda	[%r30, %r0] 0x73, %r15
	.word 0xd4944400  ! 2296: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	.word 0xda8f4e60  ! 2297: LDUBA_R	lduba	[%r29, %r0] 0x73, %r13
	.word 0xda84a000  ! 2298: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	.word 0xdaace000  ! 2299: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0xdaf4e000  ! 2300: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xdabce000  ! 2301: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0xdab42000  ! 2302: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 2303: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f8, %r23
	.word 0xdace6000  ! 2305: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r13
	.word 0x87802025  ! 2306: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r25
	.word 0x87802074  ! 2308: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabce000  ! 2309: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 2310: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r26
	.word 0x87802025  ! 2312: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4d70e60  ! 2313: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r10
	.word 0xd68da000  ! 2314: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r11
	.word 0xd6c52000  ! 2315: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r11
	.word 0xd68da000  ! 2316: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r11
	.word 0xd6b5a000  ! 2317: STHA_I	stha	%r11, [%r22 + 0x0000] %asi
	.word 0xd8df8e40  ! 2318: LDXA_R	ldxa	[%r30, %r0] 0x72, %r12
	.word 0xd2b504a0  ! 2319: STHA_R	stha	%r9, [%r20 + %r0] 0x25
	.word 0xdea584a0  ! 2320: STWA_R	stwa	%r15, [%r22 + %r0] 0x25
	mov	0x0, %r24
	mov	0x48, %r27
	mov	0x10, %r19
	.word 0xd685a000  ! 2324: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r11
	.word 0xd6ad2000  ! 2325: STBA_I	stba	%r11, [%r20 + 0x0000] %asi
	.word 0xd6f56000  ! 2326: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	.word 0xd6b5e000  ! 2327: STHA_I	stha	%r11, [%r23 + 0x0000] %asi
	mov	0x7d0, %r22
	.word 0x87802072  ! 2329: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 2330: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r25
	.word 0xd6af8e40  ! 2332: STBA_R	stba	%r11, [%r30 + %r0] 0x72
	mov	0x7f8, %r20
	.word 0xd0af0e80  ! 2334: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	.word 0xdcb7ce40  ! 2335: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	.word 0xd6bec9e0  ! 2336: STDA_R	stda	%r11, [%r27 + %r0] 0x4f
	mov	0x20, %r26
	mov	0x3e8, %r23
	mov	0x3d0, %r23
	.word 0xdaacc400  ! 2340: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0xdabda000  ! 2341: STDA_I	stda	%r13, [%r22 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xd0f4c400  ! 2343: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	mov	0x58, %r16
	mov	0x48, %r25
	.word 0xdccf4e40  ! 2346: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r14
	.word 0xdec48400  ! 2347: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	.word 0xd4f74e80  ! 2348: STXA_R	stxa	%r10, [%r29 + %r0] 0x74
	.word 0xdec56000  ! 2349: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r15
	.word 0x87802072  ! 2350: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2351: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdecfe000  ! 2352: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0x87802072  ! 2353: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebf2000  ! 2354: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 2355: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeb76000  ! 2356: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 2357: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r24
	.word 0x8780204f  ! 2359: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 2360: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeb7e000  ! 2361: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xd68d04a0  ! 2362: LDUBA_R	lduba	[%r20, %r0] 0x25, %r11
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd287e000  ! 2364: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0xd687ce40  ! 2365: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r11
	mov	0x38, %r27
	mov	0x8, %r16
	.word 0xd6f504a0  ! 2368: STXA_R	stxa	%r11, [%r20 + %r0] 0x25
	.word 0xdaa40400  ! 2369: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	mov	0x7f0, %r21
	.word 0xd08fa000  ! 2371: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0xd2b7ce80  ! 2372: STHA_R	stha	%r9, [%r31 + %r0] 0x74
	mov	0x30, %r19
	.word 0xd89584a0  ! 2374: LDUHA_R	lduha	[%r22, %r0] 0x25, %r12
	mov	0x18, %r27
	mov	0x3e0, %r23
	mov	0x18, %r17
	.word 0x87802073  ! 2378: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca44400  ! 2379: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	mov	0x7d8, %r21
	.word 0x87802073  ! 2381: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdccf6000  ! 2382: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcc76000  ! 2383: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xd8dfce40  ! 2384: LDXA_R	ldxa	[%r31, %r0] 0x72, %r12
	mov	0x3f8, %r20
	.word 0xd4a78e80  ! 2386: STWA_R	stwa	%r10, [%r30 + %r0] 0x74
	.word 0xd8b72000  ! 2387: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd8bf2000  ! 2388: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xde8c4400  ! 2389: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	.word 0x87802025  ! 2390: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r24
	.word 0x87802074  ! 2392: WRASI_I	wr	%r0, 0x0074, %asi
	wr_tick_cmpr_3_32:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x8a, %g2
	or	%g4, 0xa7, %g4
	or	%g6, 0xe4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8dc4400  ! 2394: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0xd2dce000  ! 2395: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r9
	.word 0xd2bf4e40  ! 2396: STDA_R	stda	%r9, [%r29 + %r0] 0x72
	.word 0xd0dce000  ! 2397: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r8
	.word 0xdcd4c400  ! 2398: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	mov	0x60, %r25
	.word 0xd2dc8400  ! 2400: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0x87802073  ! 2401: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0f5e000  ! 2402: STXA_I	stxa	%r8, [%r23 + 0x0000] %asi
	mov	0x78, %r25
	.word 0xd8d74e80  ! 2404: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r12
	.word 0x87802074  ! 2405: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r27
	mov	0x68, %r24
	.word 0xdcc609e0  ! 2408: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r14
	wr_tick_cmpr_3_33:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xdf, %g2
	or	%g4, 0xe9, %g4
	or	%g6, 0xf4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7f0, %r23
	.word 0xdedfce60  ! 2411: LDXA_R	ldxa	[%r31, %r0] 0x73, %r15
	.word 0xdcd70e40  ! 2412: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r14
	.word 0x87802073  ! 2413: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f74e60  ! 2414: STXA_R	stxa	%r11, [%r29 + %r0] 0x73
	.word 0xd4b4e000  ! 2415: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0x8780204f  ! 2417: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r24
	.word 0xd4a544a0  ! 2419: STWA_R	stwa	%r10, [%r21 + %r0] 0x25
	.word 0xd29ca000  ! 2420: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	mov	0x10, %r18
	.word 0xd2bce000  ! 2422: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xd2d4a000  ! 2423: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	.word 0xdccd04a0  ! 2424: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r14
	.word 0xd49ca000  ! 2425: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd4b46000  ! 2426: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xdeaf8e40  ! 2428: STBA_R	stba	%r15, [%r30 + %r0] 0x72
	.word 0xdcad04a0  ! 2429: STBA_R	stba	%r14, [%r20 + %r0] 0x25
	.word 0xd884a000  ! 2430: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r12
	mov	0x58, %r26
	.word 0x87802020  ! 2432: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a5c4a0  ! 2433: STWA_R	stwa	%r11, [%r23 + %r0] 0x25
	mov	0x7d0, %r20
	.word 0xd4ac4400  ! 2435: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	mov	0x40, %r27
	mov	0x70, %r27
	.word 0xdeb40400  ! 2438: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	wr_tick_cmpr_3_34:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xfa, %g2
	or	%g4, 0xee, %g4
	or	%g6, 0xe4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdaf72000  ! 2440: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xd097ce60  ! 2441: LDUHA_R	lduha	[%r31, %r0] 0x73, %r8
	.word 0xdc8f2000  ! 2442: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	mov	0x48, %r24
	.word 0xd8cdc4a0  ! 2444: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r12
	.word 0xd887ce60  ! 2445: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r12
	wr_tick_cmpr_3_35:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xac, %g2
	or	%g4, 0xaa, %g4
	or	%g6, 0xa0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802072  ! 2447: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0be09e0  ! 2448: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0xd0b7e000  ! 2449: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2450: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r26
	.word 0xd8de89e0  ! 2452: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r12
	mov	0x30, %r27
	.word 0xd4a7ce80  ! 2454: STWA_R	stwa	%r10, [%r31 + %r0] 0x74
	mov	0x30, %r25
	.word 0xdaa44400  ! 2456: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0x87802073  ! 2457: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802073  ! 2459: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdead6000  ! 2460: STBA_I	stba	%r15, [%r21 + 0x0000] %asi
	.word 0xdcbf0e60  ! 2461: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	.word 0xdeb5e000  ! 2462: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	mov	0x7d0, %r20
	.word 0xde9609e0  ! 2464: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r15
	.word 0xdcf5e000  ! 2465: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0xdaf689e0  ! 2466: STXA_R	stxa	%r13, [%r26 + %r0] 0x4f
	mov	0x68, %r16
	.word 0xd29f0e60  ! 2468: LDDA_R	ldda	[%r28, %r0] 0x73, %r9
	.word 0xdcdd2000  ! 2469: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r14
	.word 0xdc9da000  ! 2470: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r14
	.word 0xd0f40400  ! 2471: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xd8d52000  ! 2472: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r12
	.word 0xd8dd04a0  ! 2473: LDXA_R	ldxa	[%r20, %r0] 0x25, %r12
	.word 0x87802025  ! 2474: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad42000  ! 2475: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r13
	mov	0x78, %r25
	mov	0x7f8, %r23
	.word 0x87802073  ! 2478: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa4a000  ! 2479: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xdaace000  ! 2480: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0xd8974e80  ! 2481: LDUHA_R	lduha	[%r29, %r0] 0x74, %r12
	.word 0xd8dce000  ! 2482: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2483: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8cfa000  ! 2484: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd6dec9e0  ! 2485: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r11
	.word 0xdcaf6000  ! 2486: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	mov	0x50, %r19
	.word 0xdc87e000  ! 2488: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcafa000  ! 2489: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0xdccfe000  ! 2491: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xdccf6000  ! 2492: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xd89fce80  ! 2493: LDDA_R	ldda	[%r31, %r0] 0x74, %r12
	.word 0xded7ce60  ! 2494: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r15
	.word 0xdc8c8400  ! 2495: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0xdedfa000  ! 2496: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x60, %r27
	.word 0xd885c4a0  ! 2498: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r12
	.word 0xd4bf6000  ! 2499: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd4d76000  ! 2500: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	mov	0x68, %r18
	.word 0xd0ae89e0  ! 2502: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	.word 0xde848400  ! 2503: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	.word 0xde8fa000  ! 2504: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0xdedfa000  ! 2505: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xdca78e60  ! 2506: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	.word 0xd6dfe000  ! 2507: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6c7e000  ! 2508: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	mov	0x0, %r17
	.word 0x87802025  ! 2510: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r16
	.word 0xd6c7ce80  ! 2512: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r11
	.word 0xdc9fa000  ! 2513: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0xded74e60  ! 2514: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r15
	.word 0xdaa70e80  ! 2515: STWA_R	stwa	%r13, [%r28 + %r0] 0x74
	.word 0xded44400  ! 2516: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	.word 0x87802025  ! 2517: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2518: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdec72000  ! 2519: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xde87a000  ! 2520: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xd0acc400  ! 2521: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd4afa000  ! 2522: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd2af8e60  ! 2523: STBA_R	stba	%r9, [%r30 + %r0] 0x73
	mov	0x7f0, %r21
	.word 0xd8d7e000  ! 2525: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	mov	0x7f0, %r22
	.word 0x8780204f  ! 2527: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2528: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8dfe000  ! 2529: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xdc870e60  ! 2530: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r14
	.word 0xd8c72000  ! 2531: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	mov	0x20, %r24
	.word 0x87802072  ! 2533: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd89d6000  ! 2534: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r12
	.word 0xd8a5e000  ! 2535: STWA_I	stwa	%r12, [%r23 + 0x0000] %asi
	.word 0xd8f4c400  ! 2536: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xdcdde000  ! 2537: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	.word 0xdcade000  ! 2538: STBA_I	stba	%r14, [%r23 + 0x0000] %asi
	.word 0xd6a5c4a0  ! 2539: STWA_R	stwa	%r11, [%r23 + %r0] 0x25
	.word 0xd2b74e40  ! 2540: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	mov	0x3d8, %r23
	wr_tick_cmpr_3_36:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xdb, %g2
	or	%g4, 0x8a, %g4
	or	%g6, 0xe6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0b52000  ! 2543: STHA_I	stha	%r8, [%r20 + 0x0000] %asi
	.word 0xdcbf0e80  ! 2544: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	mov	0x7c8, %r23
	.word 0xd0ad6000  ! 2546: STBA_I	stba	%r8, [%r21 + 0x0000] %asi
	.word 0xdac5c4a0  ! 2547: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r13
	.word 0xd2ada000  ! 2548: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xd2956000  ! 2549: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2550: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccdc4a0  ! 2551: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r14
	.word 0xd0a4e000  ! 2552: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 2553: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b52000  ! 2554: STHA_I	stha	%r8, [%r20 + 0x0000] %asi
	.word 0xd2c48400  ! 2555: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0xdef5e000  ! 2556: STXA_I	stxa	%r15, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 2557: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r24
	.word 0xdea7a000  ! 2559: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	mov	0x60, %r19
	.word 0xded7e000  ! 2561: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	mov	0x68, %r19
	.word 0xd0c689e0  ! 2563: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r8
	mov	0x7c8, %r21
	mov	0x7f8, %r23
	.word 0xd4ddc4a0  ! 2566: LDXA_R	ldxa	[%r23, %r0] 0x25, %r10
	.word 0xda940400  ! 2567: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	.word 0xd8b7e000  ! 2568: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	mov	0x78, %r26
	.word 0x87802020  ! 2570: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bd04a0  ! 2571: STDA_R	stda	%r10, [%r20 + %r0] 0x25
	.word 0xdcd70e40  ! 2572: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r14
	.word 0xd2be09e0  ! 2573: STDA_R	stda	%r9, [%r24 + %r0] 0x4f
	.word 0x87802074  ! 2574: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r25
	.word 0xdef4c400  ! 2576: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xd8be6000  ! 2577: STDA_I	stda	%r12, [%r25 + 0x0000] %asi
	.word 0xd4a4c400  ! 2578: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0x87802020  ! 2579: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b78e80  ! 2580: STHA_R	stha	%r10, [%r30 + %r0] 0x74
	.word 0xdeb7ce80  ! 2581: STHA_R	stha	%r15, [%r31 + %r0] 0x74
	.word 0xd09544a0  ! 2582: LDUHA_R	lduha	[%r21, %r0] 0x25, %r8
	.word 0xd4978e40  ! 2583: LDUHA_R	lduha	[%r30, %r0] 0x72, %r10
	.word 0x87802072  ! 2584: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2be2000  ! 2585: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	.word 0xd2978e80  ! 2586: LDUHA_R	lduha	[%r30, %r0] 0x74, %r9
	.word 0x87802073  ! 2587: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e0, %r21
	.word 0x87802020  ! 2589: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f7a000  ! 2590: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 2591: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a78e60  ! 2592: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0xd68e6000  ! 2593: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r11
	.word 0xd6b62000  ! 2594: STHA_I	stha	%r11, [%r24 + 0x0000] %asi
	mov	0x0, %r24
	.word 0xdac78e60  ! 2596: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r13
	mov	0x7d0, %r20
	.word 0xd2c48400  ! 2598: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0xdebe6000  ! 2599: STDA_I	stda	%r15, [%r25 + 0x0000] %asi
	mov	0x3e0, %r21
	.word 0xde862000  ! 2601: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r15
	mov	0x68, %r25
	mov	0x40, %r27
	.word 0xde8f0e80  ! 2604: LDUBA_R	lduba	[%r28, %r0] 0x74, %r15
	.word 0xd2a74e60  ! 2605: STWA_R	stwa	%r9, [%r29 + %r0] 0x73
	.word 0xde9ec9e0  ! 2606: LDDA_R	ldda	[%r27, %r0] 0x4f, %r15
	mov	0x78, %r19
	.word 0xd2cee000  ! 2608: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	.word 0xd0adc4a0  ! 2609: STBA_R	stba	%r8, [%r23 + %r0] 0x25
	.word 0xdaaea000  ! 2610: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	.word 0xdab66000  ! 2611: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0xdaa62000  ! 2612: STWA_I	stwa	%r13, [%r24 + 0x0000] %asi
	.word 0xdabee000  ! 2613: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	.word 0xd0b70e60  ! 2614: STHA_R	stha	%r8, [%r28 + %r0] 0x73
	.word 0xdad66000  ! 2615: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r13
	.word 0xdcd7ce60  ! 2616: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r14
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2866000  ! 2618: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r9
	.word 0x87802072  ! 2619: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8df4e40  ! 2620: LDXA_R	ldxa	[%r29, %r0] 0x72, %r12
	.word 0xd8aea000  ! 2621: STBA_I	stba	%r12, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 2622: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2623: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8942000  ! 2624: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r12
	.word 0xd8a46000  ! 2625: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8b4a000  ! 2626: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0xd8d7ce40  ! 2627: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r12
	.word 0xd4bc6000  ! 2628: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xd4946000  ! 2629: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r10
	.word 0xdabd84a0  ! 2630: STDA_R	stda	%r13, [%r22 + %r0] 0x25
	.word 0xda942000  ! 2631: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0x87802074  ! 2632: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2633: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda856000  ! 2634: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r13
	.word 0xdaade000  ! 2635: STBA_I	stba	%r13, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 2636: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2637: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r24
	.word 0xda8c4400  ! 2639: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0xd6c62000  ! 2640: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r11
	.word 0xd6cee000  ! 2641: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r11
	.word 0xde878e40  ! 2642: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r15
	mov	0x3c0, %r21
	.word 0xdcf48400  ! 2644: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0x87802073  ! 2645: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcaf2000  ! 2646: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdcddc4a0  ! 2647: LDXA_R	ldxa	[%r23, %r0] 0x25, %r14
	.word 0xdef7ce60  ! 2648: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0x87802025  ! 2649: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabfa000  ! 2650: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 2651: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2652: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde87ce40  ! 2653: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r15
	.word 0x8780204f  ! 2654: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc8fe000  ! 2655: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xdc9fe000  ! 2656: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xda96c9e0  ! 2657: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r13
	ta	T_CHANGE_PRIV	! macro
	mov	0x60, %r24
	.word 0x87802025  ! 2660: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 2661: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc946000  ! 2662: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r14
	.word 0xdc84a000  ! 2663: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	.word 0x87802072  ! 2664: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb46000  ! 2665: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 2666: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 2667: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x10, %r27
	.word 0x87802020  ! 2670: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9c6000  ! 2671: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r14
	.word 0xd8f689e0  ! 2672: STXA_R	stxa	%r12, [%r26 + %r0] 0x4f
	.word 0x8780204f  ! 2673: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a72000  ! 2674: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd0df8e40  ! 2675: LDXA_R	ldxa	[%r30, %r0] 0x72, %r8
	.word 0xd4f40400  ! 2676: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xd8cf6000  ! 2677: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0xd4b44400  ! 2678: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	.word 0xd0b7a000  ! 2679: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0xd0cfa000  ! 2681: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0xdaf40400  ! 2682: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xd4c649e0  ! 2683: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r10
	.word 0xd2a72000  ! 2684: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 2685: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2686: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cd6000  ! 2687: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r9
	.word 0xd2dd6000  ! 2688: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r9
	.word 0xd2ad6000  ! 2689: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0x87802025  ! 2690: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2d7e000  ! 2691: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	mov	0x3f0, %r21
	.word 0xd2a72000  ! 2693: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	mov	0x48, %r26
	mov	0x58, %r19
	.word 0xd2afe000  ! 2696: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd2af6000  ! 2697: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd2bf2000  ! 2698: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd28fa000  ! 2699: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	.word 0xd2c76000  ! 2700: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2a72000  ! 2701: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 2702: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2c74e40  ! 2703: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r9
	.word 0x87802072  ! 2704: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f70e80  ! 2705: STXA_R	stxa	%r10, [%r28 + %r0] 0x74
	.word 0xd0a544a0  ! 2706: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	.word 0xdea7e000  ! 2707: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xdc9f0e60  ! 2708: LDDA_R	ldda	[%r28, %r0] 0x73, %r14
	.word 0xdadf2000  ! 2709: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	mov	0x60, %r24
	.word 0x87802073  ! 2711: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd68cc400  ! 2712: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	mov	0x70, %r26
	.word 0xd6a609e0  ! 2714: STWA_R	stwa	%r11, [%r24 + %r0] 0x4f
	.word 0xdef78e40  ! 2715: STXA_R	stxa	%r15, [%r30 + %r0] 0x72
	wr_tick_cmpr_3_37:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf1, %g2
	or	%g4, 0xd2, %g4
	or	%g6, 0xa2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x0, %r25
	.word 0xd4bde000  ! 2718: STDA_I	stda	%r10, [%r23 + 0x0000] %asi
	mov	0x8, %r24
	mov	0x70, %r27
	.word 0xde8e89e0  ! 2721: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r15
	.word 0xdeaf4e40  ! 2722: STBA_R	stba	%r15, [%r29 + %r0] 0x72
	.word 0xd6a7ce80  ! 2723: STWA_R	stwa	%r11, [%r31 + %r0] 0x74
	mov	0x28, %r24
	.word 0xd4a609e0  ! 2725: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 2726: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r17
	.word 0xd4c689e0  ! 2728: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r10
	.word 0xdcaca000  ! 2729: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xdcc4a000  ! 2730: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r14
	.word 0xdcace000  ! 2731: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0xdcac6000  ! 2733: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 2734: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc872000  ! 2735: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802074  ! 2737: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcc66000  ! 2738: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2739: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcc72000  ! 2740: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xde8c8400  ! 2741: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	.word 0xd6afa000  ! 2742: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd8c6c9e0  ! 2743: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r12
	.word 0xd68cc400  ! 2744: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	.word 0xd8c70e80  ! 2745: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r12
	.word 0xd2f544a0  ! 2746: STXA_R	stxa	%r9, [%r21 + %r0] 0x25
	.word 0xd8dec9e0  ! 2747: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r12
	.word 0xd2ccc400  ! 2748: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	.word 0xd484c400  ! 2749: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	mov	0x0, %r24
	mov	0x10, %r19
	.word 0xd6df6000  ! 2752: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2753: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2754: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r26
	.word 0xd6f72000  ! 2756: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2757: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd697a000  ! 2758: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0xd6d7e000  ! 2759: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	.word 0xd6f7a000  ! 2760: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	mov	0x68, %r19
	.word 0xd8b609e0  ! 2762: STHA_R	stha	%r12, [%r24 + %r0] 0x4f
	.word 0xd8a76000  ! 2763: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	mov	0x40, %r27
	.word 0x87802020  ! 2765: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8972000  ! 2766: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	.word 0xd2af0e60  ! 2767: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	mov	0x0, %r16
	.word 0xdeafe000  ! 2769: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xd48584a0  ! 2770: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r10
	.word 0xd6be09e0  ! 2771: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	mov	0x7e8, %r22
	mov	0x3e0, %r20
	.word 0x87802020  ! 2774: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r17
	.word 0xda9ee000  ! 2776: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r13
	mov	0x30, %r18
	.word 0xda9e2000  ! 2778: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r13
	.word 0xd0af0e60  ! 2779: STBA_R	stba	%r8, [%r28 + %r0] 0x73
	.word 0xde8fce40  ! 2780: LDUBA_R	lduba	[%r31, %r0] 0x72, %r15
	.word 0xd6f66000  ! 2781: STXA_I	stxa	%r11, [%r25 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xd6ae6000  ! 2783: STBA_I	stba	%r11, [%r25 + 0x0000] %asi
	.word 0x87802073  ! 2784: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f544a0  ! 2785: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	.word 0xd0b42000  ! 2786: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	mov	0x60, %r17
	mov	0x50, %r24
	mov	0x18, %r24
	.word 0xd4ac8400  ! 2790: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	mov	0x30, %r24
	.word 0x87802025  ! 2792: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd89d44a0  ! 2793: LDDA_R	ldda	[%r21, %r0] 0x25, %r12
	.word 0xdaa56000  ! 2794: STWA_I	stwa	%r13, [%r21 + 0x0000] %asi
	mov	0x50, %r16
	.word 0xd8a584a0  ! 2796: STWA_R	stwa	%r12, [%r22 + %r0] 0x25
	.word 0xdebd6000  ! 2797: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	.word 0xdedda000  ! 2798: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r15
	.word 0xdeada000  ! 2799: STBA_I	stba	%r15, [%r22 + 0x0000] %asi
	.word 0xd2ae89e0  ! 2800: STBA_R	stba	%r9, [%r26 + %r0] 0x4f
	.word 0xdecd6000  ! 2801: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r15
	.word 0xdaf4c400  ! 2802: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0x87802073  ! 2803: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf544a0  ! 2804: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	mov	0x0, %r24
	.word 0xdaa504a0  ! 2806: STWA_R	stwa	%r13, [%r20 + %r0] 0x25
	mov	0x48, %r27
	.word 0xd6bfa000  ! 2808: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 2809: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2810: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r27
	.word 0xd6bfe000  ! 2812: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	mov	0x48, %r19
	mov	0x58, %r26
	.word 0xd6a76000  ! 2815: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	mov	0x48, %r19
	mov	0x68, %r25
	.word 0xd6f72000  ! 2818: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd68f6000  ! 2820: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xd8dc0400  ! 2821: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0xdc948400  ! 2822: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	.word 0xd2f78e40  ! 2823: STXA_R	stxa	%r9, [%r30 + %r0] 0x72
	mov	0x3e8, %r22
	.word 0xd2f76000  ! 2825: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 2826: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r27
	mov	0x68, %r25
	.word 0x87802073  ! 2829: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b7e000  ! 2830: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 2831: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f0, %r23
	.word 0xd2970e80  ! 2833: LDUHA_R	lduha	[%r28, %r0] 0x74, %r9
	.word 0xdca72000  ! 2834: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	mov	0x0, %r18
	mov	0x0, %r25
	.word 0xdaf74e80  ! 2837: STXA_R	stxa	%r13, [%r29 + %r0] 0x74
	.word 0x87802073  ! 2838: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde9e09e0  ! 2839: LDDA_R	ldda	[%r24, %r0] 0x4f, %r15
	.word 0xd2afe000  ! 2840: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 2841: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaaf0e60  ! 2842: STBA_R	stba	%r13, [%r28 + %r0] 0x73
	.word 0xd6af6000  ! 2843: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x60, %r25
	mov	0x8, %r19
	.word 0xdef74e40  ! 2846: STXA_R	stxa	%r15, [%r29 + %r0] 0x72
	.word 0xd2de49e0  ! 2847: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r9
	.word 0xd8d72000  ! 2848: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xd8876000  ! 2849: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8d72000  ! 2850: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	mov	0x10, %r18
	.word 0xd8bfa000  ! 2852: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd8d72000  ! 2853: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	mov	0x20, %r24
	.word 0xd8dfe000  ! 2855: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xd89f2000  ! 2856: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0xd8b76000  ! 2857: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	mov	0x68, %r18
	.word 0x87802072  ! 2859: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdc96c9e0  ! 2861: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r14
	.word 0xd8f66000  ! 2862: STXA_I	stxa	%r12, [%r25 + 0x0000] %asi
	.word 0x87802074  ! 2863: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8b56000  ! 2864: STHA_I	stha	%r12, [%r21 + 0x0000] %asi
	.word 0xd8f52000  ! 2865: STXA_I	stxa	%r12, [%r20 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802025  ! 2867: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8cf2000  ! 2868: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0x87802025  ! 2869: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2870: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2871: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf4c400  ! 2872: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xd8f5c4a0  ! 2873: STXA_R	stxa	%r12, [%r23 + %r0] 0x25
	.word 0xdad48400  ! 2874: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0x87802020  ! 2875: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2970e60  ! 2876: LDUHA_R	lduha	[%r28, %r0] 0x73, %r9
	mov	0x78, %r27
	.word 0x87802074  ! 2878: WRASI_I	wr	%r0, 0x0074, %asi
	wr_tick_cmpr_3_38:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe0, %g2
	or	%g4, 0xf4, %g4
	or	%g6, 0xb3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xde942000  ! 2880: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	mov	0x28, %r17
	mov	0x0, %r19
	.word 0xd8afce40  ! 2883: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	.word 0xd0a4e000  ! 2884: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0b4e000  ! 2885: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xdeaf0e40  ! 2886: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	mov	0x20, %r18
	wr_tick_cmpr_3_39:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xae, %g2
	or	%g4, 0xb6, %g4
	or	%g6, 0xf4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0f42000  ! 2889: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	mov	0x20, %r25
	.word 0xd0d4a000  ! 2891: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	mov	0x40, %r24
	.word 0xd2844400  ! 2893: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	.word 0xdcc4c400  ! 2894: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	.word 0x87802020  ! 2895: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf5e000  ! 2896: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0xd2c4c400  ! 2897: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	mov	0x70, %r19
	.word 0xd4ad04a0  ! 2899: STBA_R	stba	%r10, [%r20 + %r0] 0x25
	.word 0x8780204f  ! 2900: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a74e40  ! 2901: STWA_R	stwa	%r9, [%r29 + %r0] 0x72
	.word 0xd6d40400  ! 2902: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	mov	0x28, %r26
	.word 0x87802072  ! 2904: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2cfe000  ! 2905: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	.word 0xd2f72000  ! 2906: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd2dfe000  ! 2907: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	mov	0x8, %r24
	mov	0x50, %r24
	mov	0x78, %r16
	.word 0x87802073  ! 2911: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bc0400  ! 2912: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xd084e000  ! 2913: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	.word 0x87802025  ! 2914: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r24
	.word 0xdebd44a0  ! 2916: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	.word 0xd69fce40  ! 2917: LDDA_R	ldda	[%r31, %r0] 0x72, %r11
	.word 0xdca46000  ! 2918: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 2919: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcc66000  ! 2920: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2921: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8840400  ! 2922: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r12
	.word 0xdc840400  ! 2923: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	.word 0x87802072  ! 2924: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cf8e60  ! 2925: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r10
	.word 0xd6f4e000  ! 2926: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	.word 0xd68ce000  ! 2927: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	mov	0x70, %r27
	mov	0x8, %r24
	.word 0xdeb74e60  ! 2930: STHA_R	stha	%r15, [%r29 + %r0] 0x73
	.word 0xd8a78e60  ! 2931: STWA_R	stwa	%r12, [%r30 + %r0] 0x73
	.word 0xd4bf8e40  ! 2932: STDA_R	stda	%r10, [%r30 + %r0] 0x72
	.word 0xd0b4a000  ! 2933: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	mov	0x3f8, %r21
	mov	0x28, %r24
	mov	0x48, %r25
	.word 0xd8c4c400  ! 2937: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r12
	mov	0x70, %r19
	.word 0x87802020  ! 2939: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbda000  ! 2940: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	.word 0xdcf5e000  ! 2941: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 2942: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2943: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2944: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf7e000  ! 2945: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xd2bd84a0  ! 2946: STDA_R	stda	%r9, [%r22 + %r0] 0x25
	mov	0x28, %r16
	.word 0x87802025  ! 2948: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r17
	.word 0xd4af0e80  ! 2950: STBA_R	stba	%r10, [%r28 + %r0] 0x74
	.word 0xd484c400  ! 2951: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	.word 0xd2b649e0  ! 2952: STHA_R	stha	%r9, [%r25 + %r0] 0x4f
	mov	0x7e0, %r23
	.word 0x87802073  ! 2954: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa4e000  ! 2955: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0xdaa42000  ! 2956: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0xdec5c4a0  ! 2957: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r15
	mov	0x3f8, %r21
	mov	0x3c8, %r23
	.word 0xd4c544a0  ! 2960: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r10
	.word 0xdaf4e000  ! 2961: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xdabce000  ! 2962: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0xd2a70e80  ! 2963: STWA_R	stwa	%r9, [%r28 + %r0] 0x74
	.word 0xd2d4e000  ! 2964: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0xda9cc400  ! 2965: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	.word 0xd49ec9e0  ! 2966: LDDA_R	ldda	[%r27, %r0] 0x4f, %r10
	.word 0xdab544a0  ! 2967: STHA_R	stha	%r13, [%r21 + %r0] 0x25
	.word 0xdab40400  ! 2968: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xd2f78e80  ! 2969: STXA_R	stxa	%r9, [%r30 + %r0] 0x74
	.word 0xd0dc2000  ! 2970: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	mov	0x50, %r25
	.word 0x8780204f  ! 2972: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0afa000  ! 2973: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd4f544a0  ! 2974: STXA_R	stxa	%r10, [%r21 + %r0] 0x25
	.word 0xd897a000  ! 2975: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8df6000  ! 2977: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0x87802074  ! 2978: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28f0e60  ! 2979: LDUBA_R	lduba	[%r28, %r0] 0x73, %r9
	.word 0xdead84a0  ! 2980: STBA_R	stba	%r15, [%r22 + %r0] 0x25
	.word 0x8780204f  ! 2981: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdca78e60  ! 2982: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	.word 0xdeac0400  ! 2983: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	mov	0x3d8, %r21
	.word 0xde87e000  ! 2985: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0x87802073  ! 2986: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2987: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_3_40:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa8, %g2
	or	%g4, 0xc1, %g4
	or	%g6, 0xb6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd6bd84a0  ! 2989: STDA_R	stda	%r11, [%r22 + %r0] 0x25
	.word 0xdccc2000  ! 2990: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r14
	.word 0xdab78e40  ! 2991: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	.word 0xd4a42000  ! 2992: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0xd49e49e0  ! 2993: LDDA_R	ldda	[%r25, %r0] 0x4f, %r10
	mov	0x3e0, %r22
	.word 0xd2b5c4a0  ! 2995: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	.word 0xd2f40400  ! 2996: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xd6aca000  ! 2997: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xd2b74e80  ! 2998: STHA_R	stha	%r9, [%r29 + %r0] 0x74
	.word 0xd6d6c9e0  ! 2999: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r11
	mov	0x18, %r17
	.word 0xd2d504a0  ! 3001: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r9
	.word 0xdabc0400  ! 3002: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xd6a42000  ! 3003: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	mov	0x28, %r24
	.word 0x8780204f  ! 3005: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d8, %r22
	.word 0xd2afce60  ! 3007: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	mov	0x70, %r27
	.word 0xd4f7a000  ! 3009: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	mov	0x30, %r27
	.word 0xd4b7a000  ! 3011: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd4dd04a0  ! 3012: LDXA_R	ldxa	[%r20, %r0] 0x25, %r10
	.word 0xd6cc4400  ! 3013: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	mov	0x38, %r19
	.word 0x87802020  ! 3015: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef46000  ! 3016: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xde94a000  ! 3017: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0x87802074  ! 3018: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d8, %r20
	ta	T_CHANGE_PRIV	! macro
	.word 0xd48f0e80  ! 3021: LDUBA_R	lduba	[%r28, %r0] 0x74, %r10
	.word 0x87802074  ! 3022: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf5a000  ! 3023: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	mov	0x30, %r24
	.word 0x87802020  ! 3025: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 3026: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc970e40  ! 3027: LDUHA_R	lduha	[%r28, %r0] 0x72, %r14
	.word 0xd4cca000  ! 3028: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r10
	.word 0xd4a42000  ! 3029: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	mov	0x20, %r26
	.word 0xd4f4a000  ! 3031: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0xd4d42000  ! 3033: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	.word 0x87802073  ! 3034: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4ae09e0  ! 3035: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 3036: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6af6000  ! 3037: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x8, %r27
	.word 0xd697e000  ! 3039: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0xd6bf2000  ! 3040: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	mov	0x18, %r25
	.word 0x87802072  ! 3042: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b72000  ! 3043: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd68fe000  ! 3044: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0x87802025  ! 3045: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebe09e0  ! 3046: STDA_R	stda	%r15, [%r24 + %r0] 0x4f
	.word 0xd29f2000  ! 3047: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	mov	0x0, %r19
	.word 0x87802072  ! 3049: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdecc4400  ! 3050: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r15
	.word 0xd0af8e80  ! 3051: STBA_R	stba	%r8, [%r30 + %r0] 0x74
	.word 0xd28c2000  ! 3052: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	mov	0x3e0, %r20
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdc8f8e80  ! 3055: LDUBA_R	lduba	[%r30, %r0] 0x74, %r14
	.word 0xd6f544a0  ! 3056: STXA_R	stxa	%r11, [%r21 + %r0] 0x25
	.word 0xded48400  ! 3057: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	.word 0xdebce000  ! 3058: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xdea4e000  ! 3059: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xd4af0e60  ! 3060: STBA_R	stba	%r10, [%r28 + %r0] 0x73
	.word 0xde9c2000  ! 3061: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0x87802072  ! 3062: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r16
	.word 0xd4b74e40  ! 3064: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	mov	0x50, %r26
	.word 0xd4dd6000  ! 3066: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r10
	.word 0xd2afce80  ! 3067: STBA_R	stba	%r9, [%r31 + %r0] 0x74
	.word 0x87802072  ! 3068: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r17
	.word 0xd6a78e80  ! 3070: STWA_R	stwa	%r11, [%r30 + %r0] 0x74
	.word 0xd4bec9e0  ! 3071: STDA_R	stda	%r10, [%r27 + %r0] 0x4f
	.word 0xd2d5c4a0  ! 3072: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r9
	.word 0xdca70e40  ! 3073: STWA_R	stwa	%r14, [%r28 + %r0] 0x72
	.word 0xd6f72000  ! 3074: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6c76000  ! 3075: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd0f78e40  ! 3076: STXA_R	stxa	%r8, [%r30 + %r0] 0x72
	mov	0x3e8, %r22
	.word 0xd4ae09e0  ! 3078: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0xd09d04a0  ! 3079: LDDA_R	ldda	[%r20, %r0] 0x25, %r8
	mov	0x18, %r16
	mov	0x7f8, %r20
	.word 0xd2ac8400  ! 3082: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xd08fa000  ! 3083: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0xde8fce60  ! 3084: LDUBA_R	lduba	[%r31, %r0] 0x73, %r15
	.word 0x87802025  ! 3085: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd09e6000  ! 3086: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r8
	.word 0xd08e6000  ! 3087: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r8
	.word 0xd0a4c400  ! 3088: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xd4866000  ! 3089: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r10
	mov	0x10, %r27
	.word 0x87802072  ! 3091: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d0, %r22
	.word 0x87802072  ! 3093: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f8, %r21
	mov	0x28, %r25
	mov	0x48, %r25
	.word 0xda9fce40  ! 3097: LDDA_R	ldda	[%r31, %r0] 0x72, %r13
	.word 0xdac7ce80  ! 3098: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r13
	.word 0xd0c7ce60  ! 3099: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r8
	.word 0xd4a4e000  ! 3100: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd29cc400  ! 3102: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	.word 0xd894e000  ! 3103: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r12
	.word 0xda9f0e80  ! 3104: LDDA_R	ldda	[%r28, %r0] 0x74, %r13
	.word 0xd4d46000  ! 3105: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r10
	.word 0xd8ce09e0  ! 3106: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r12
	.word 0xd2d689e0  ! 3107: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r9
	mov	0x10, %r19
	.word 0x87802074  ! 3109: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4aea000  ! 3110: STBA_I	stba	%r10, [%r26 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xd4b48400  ! 3112: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd88c0400  ! 3113: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	.word 0xd4966000  ! 3114: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r10
	.word 0x87802020  ! 3115: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3116: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f48400  ! 3117: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xd08c8400  ! 3118: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	mov	0x7c8, %r22
	mov	0x3c0, %r23
	mov	0x20, %r17
	.word 0xd68e89e0  ! 3122: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r11
	.word 0xd2b62000  ! 3123: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	.word 0xdccf0e60  ! 3124: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r14
	.word 0xd88e09e0  ! 3125: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r12
	.word 0xdcbe6000  ! 3126: STDA_I	stda	%r14, [%r25 + 0x0000] %asi
	.word 0xdcae2000  ! 3127: STBA_I	stba	%r14, [%r24 + 0x0000] %asi
	.word 0xdcd62000  ! 3128: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r14
	mov	0x30, %r16
	.word 0xd0b70e80  ! 3130: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	.word 0xd6d6a000  ! 3131: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r11
	mov	0x50, %r19
	.word 0xd6c4c400  ! 3133: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r11
	.word 0xd6bf4e60  ! 3134: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	mov	0x8, %r26
	.word 0xd6cea000  ! 3136: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	mov	0x10, %r26
	mov	0x7c0, %r23
	.word 0x8780204f  ! 3139: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c8, %r23
	.word 0xd8a40400  ! 3141: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0xd6ada000  ! 3142: STBA_I	stba	%r11, [%r22 + 0x0000] %asi
	.word 0xd6d5a000  ! 3143: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r11
	.word 0xd6b5a000  ! 3144: STHA_I	stha	%r11, [%r22 + 0x0000] %asi
	.word 0xdc870e60  ! 3145: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r14
	.word 0x87802073  ! 3146: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f0, %r22
	.word 0xd88f4e60  ! 3148: LDUBA_R	lduba	[%r29, %r0] 0x73, %r12
	.word 0xdac4c400  ! 3149: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r13
	mov	0x10, %r24
	.word 0xd6bfce80  ! 3151: STDA_R	stda	%r11, [%r31 + %r0] 0x74
	mov	0x0, %r26
	.word 0xd0afa000  ! 3153: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd0f76000  ! 3154: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0b7e000  ! 3155: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0xd2d78e80  ! 3156: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r9
	.word 0xdebf6000  ! 3157: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xdef76000  ! 3158: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 3159: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69ec9e0  ! 3160: LDDA_R	ldda	[%r27, %r0] 0x4f, %r11
	.word 0xd0cde000  ! 3161: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r8
	.word 0xd0d52000  ! 3162: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r8
	.word 0xd6ae89e0  ! 3163: STBA_R	stba	%r11, [%r26 + %r0] 0x4f
	.word 0xd2874e40  ! 3164: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r9
	mov	0x60, %r27
	.word 0x87802020  ! 3166: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_3_41:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd4, %g2
	or	%g4, 0xc0, %g4
	or	%g6, 0xb4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2aca000  ! 3168: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 3169: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d8, %r23
	.word 0x87802025  ! 3171: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3172: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3173: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r27
	.word 0xd0b78e40  ! 3175: STHA_R	stha	%r8, [%r30 + %r0] 0x72
	.word 0x87802020  ! 3176: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde972000  ! 3177: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0xd6b74e80  ! 3178: STHA_R	stha	%r11, [%r29 + %r0] 0x74
	.word 0xdc8f4e60  ! 3179: LDUBA_R	lduba	[%r29, %r0] 0x73, %r14
	.word 0x87802020  ! 3180: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd284c400  ! 3181: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r9
	.word 0xdc874e80  ! 3182: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r14
	.word 0xd0f649e0  ! 3183: STXA_R	stxa	%r8, [%r25 + %r0] 0x4f
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd8cda000  ! 3185: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r12
	.word 0x87802025  ! 3186: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bc2000  ! 3187: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd8f42000  ! 3188: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8946000  ! 3189: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	.word 0xd8b42000  ! 3190: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	.word 0xd8f4e000  ! 3191: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 3192: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d4e000  ! 3193: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0xd8cca000  ! 3194: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r12
	.word 0xd8842000  ! 3195: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	mov	0x58, %r25
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x48, %r26
	.word 0x87802025  ! 3199: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8c72000  ! 3200: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd48d84a0  ! 3201: LDUBA_R	lduba	[%r22, %r0] 0x25, %r10
	.word 0xd2a7a000  ! 3202: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xdc944400  ! 3203: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	.word 0xd88c0400  ! 3204: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	.word 0xd897ce40  ! 3205: LDUHA_R	lduha	[%r31, %r0] 0x72, %r12
	mov	0x20, %r26
	.word 0xd0cfe000  ! 3207: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xd0f76000  ! 3208: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0xd89f8e40  ! 3210: LDDA_R	ldda	[%r30, %r0] 0x72, %r12
	.word 0xdad7ce40  ! 3211: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r13
	.word 0xd8cfce40  ! 3212: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r12
	mov	0x3f0, %r22
	.word 0xd6bfa000  ! 3214: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd687a000  ! 3215: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6f72000  ! 3216: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd687e000  ! 3217: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	mov	0x28, %r25
	.word 0xded40400  ! 3219: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	.word 0x87802072  ! 3220: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab4c400  ! 3221: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xdedc2000  ! 3222: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r15
	.word 0xde84a000  ! 3223: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	.word 0xdea4a000  ! 3224: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0xd88c0400  ! 3226: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	.word 0x87802020  ! 3227: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r24
	.word 0xdc8f2000  ! 3229: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0xdcf72000  ! 3230: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xd4bcc400  ! 3231: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	mov	0x7c8, %r22
	.word 0xd89f2000  ! 3233: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0xd8bfa000  ! 3234: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3235: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88c6000  ! 3236: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	.word 0x87802020  ! 3237: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3238: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 3239: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bda000  ! 3240: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	.word 0x8780204f  ! 3241: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd88e89e0  ! 3242: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r12
	.word 0xd49584a0  ! 3243: LDUHA_R	lduha	[%r22, %r0] 0x25, %r10
	.word 0x87802072  ! 3244: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaaf4e80  ! 3245: STBA_R	stba	%r13, [%r29 + %r0] 0x74
	.word 0xd4bd04a0  ! 3246: STDA_R	stda	%r10, [%r20 + %r0] 0x25
	mov	0x48, %r19
	.word 0x87802025  ! 3248: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdedfce60  ! 3249: LDXA_R	ldxa	[%r31, %r0] 0x73, %r15
	mov	0x3f8, %r20
	mov	0x7c8, %r23
	.word 0xd0970e80  ! 3252: LDUHA_R	lduha	[%r28, %r0] 0x74, %r8
	mov	0x30, %r25
	.word 0xda95c4a0  ! 3254: LDUHA_R	lduha	[%r23, %r0] 0x25, %r13
	.word 0xd08e2000  ! 3255: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r8
	mov	0x78, %r27
	.word 0xda94c400  ! 3257: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	.word 0xd0be2000  ! 3258: STDA_I	stda	%r8, [%r24 + 0x0000] %asi
	.word 0xdccc8400  ! 3259: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	.word 0xd2cee000  ! 3260: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 3261: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 3262: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r16
	.word 0xdcbf8e40  ! 3264: STDA_R	stda	%r14, [%r30 + %r0] 0x72
	.word 0xdebfa000  ! 3265: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xdebf6000  ! 3266: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xd0bf8e80  ! 3267: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	mov	0x10, %r26
	.word 0xd2afce80  ! 3269: STBA_R	stba	%r9, [%r31 + %r0] 0x74
	.word 0xd4b74e80  ! 3270: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	.word 0xdc9f4e80  ! 3271: LDDA_R	ldda	[%r29, %r0] 0x74, %r14
	.word 0xded44400  ! 3272: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	.word 0xd6acc400  ! 3273: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xdcc72000  ! 3274: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	mov	0x78, %r25
	.word 0xdcafe000  ! 3276: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdcc7a000  ! 3277: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xdac649e0  ! 3278: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r13
	wr_tick_cmpr_3_42:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xc4, %g2
	or	%g4, 0x9b, %g4
	or	%g6, 0xb1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8dc8400  ! 3280: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xdea44400  ! 3281: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xd6f7a000  ! 3282: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6a7e000  ! 3283: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xd69f6000  ! 3284: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	.word 0xd2c40400  ! 3285: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r9
	.word 0xd8c78e80  ! 3286: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r12
	.word 0xdac504a0  ! 3287: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r13
	.word 0xd0870e40  ! 3288: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r8
	.word 0xdec74e80  ! 3289: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r15
	mov	0x28, %r17
	.word 0xd89fa000  ! 3291: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	mov	0x7d8, %r23
	.word 0xd8f72000  ! 3293: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd0dd84a0  ! 3294: LDXA_R	ldxa	[%r22, %r0] 0x25, %r8
	mov	0x60, %r17
	.word 0xd0f44400  ! 3296: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xdcae49e0  ! 3297: STBA_R	stba	%r14, [%r25 + %r0] 0x4f
	.word 0xd8972000  ! 3298: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	mov	0x50, %r18
	.word 0xd8f72000  ! 3300: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8c76000  ! 3301: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	.word 0x87802020  ! 3302: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c42000  ! 3303: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r12
	.word 0xd69689e0  ! 3304: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r11
	.word 0x87802073  ! 3305: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde8ce000  ! 3306: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	mov	0x3d8, %r20
	mov	0x38, %r25
	.word 0xda9f4e60  ! 3309: LDDA_R	ldda	[%r29, %r0] 0x73, %r13
	.word 0x87802072  ! 3310: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 3311: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r27
	.word 0xd0ace000  ! 3313: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0xd0a42000  ! 3314: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xd6ac4400  ! 3315: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xd6acc400  ! 3316: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	mov	0x10, %r17
	mov	0x7f0, %r23
	mov	0x10, %r25
	mov	0x60, %r17
	mov	0x18, %r26
	.word 0xd28f0e40  ! 3322: LDUBA_R	lduba	[%r28, %r0] 0x72, %r9
	.word 0xdadce000  ! 3323: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xdcac0400  ! 3324: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	mov	0x10, %r17
	mov	0x0, %r25
	.word 0xd8d4e000  ! 3327: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0xd0d78e40  ! 3328: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r8
	.word 0xde94e000  ! 3329: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	mov	0x60, %r26
	.word 0x87802020  ! 3331: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9fa000  ! 3332: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	mov	0x60, %r18
	mov	0x50, %r18
	.word 0xd8dc4400  ! 3335: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0x8780204f  ! 3336: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda95c4a0  ! 3337: LDUHA_R	lduha	[%r23, %r0] 0x25, %r13
	.word 0xd8f7a000  ! 3338: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	mov	0x3c8, %r20
	.word 0x87802072  ! 3340: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3341: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r17
	.word 0xd8f46000  ! 3343: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xd88f8e80  ! 3344: LDUBA_R	lduba	[%r30, %r0] 0x74, %r12
	.word 0xd0f544a0  ! 3345: STXA_R	stxa	%r8, [%r21 + %r0] 0x25
	.word 0xdea544a0  ! 3346: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	.word 0xd49e09e0  ! 3347: LDDA_R	ldda	[%r24, %r0] 0x4f, %r10
	.word 0xdcbc6000  ! 3348: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	mov	0x30, %r26
	.word 0xd6844400  ! 3350: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r11
	mov	0x28, %r17
	.word 0x87802074  ! 3352: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 3353: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 3354: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde876000  ! 3355: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xdeafa000  ! 3356: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xdcf584a0  ! 3357: STXA_R	stxa	%r14, [%r22 + %r0] 0x25
	.word 0xd4cf4e80  ! 3358: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r10
	.word 0xd4c78e40  ! 3359: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r10
	.word 0xd8bdc4a0  ! 3360: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	mov	0x7c8, %r21
	.word 0xd6c76000  ! 3362: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6afa000  ! 3363: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6c40400  ! 3364: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r11
	.word 0xd4f70e60  ! 3365: STXA_R	stxa	%r10, [%r28 + %r0] 0x73
	mov	0x3f8, %r20
	.word 0xdc8fe000  ! 3367: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0x87802073  ! 3368: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4cfce60  ! 3369: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r10
	.word 0xd0bf8e80  ! 3370: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	.word 0xdaa7e000  ! 3371: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xdaf72000  ! 3372: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdab7a000  ! 3373: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xd896c9e0  ! 3374: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r12
	.word 0x87802072  ! 3375: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc956000  ! 3376: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r14
	.word 0xdcc56000  ! 3377: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r14
	mov	0x3d8, %r22
	.word 0x87802073  ! 3379: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda844400  ! 3380: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r13
	.word 0xdcb6a000  ! 3381: STHA_I	stha	%r14, [%r26 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0xdcf66000  ! 3383: STXA_I	stxa	%r14, [%r25 + 0x0000] %asi
	mov	0x18, %r18
	.word 0xdcaee000  ! 3385: STBA_I	stba	%r14, [%r27 + 0x0000] %asi
	mov	0x78, %r17
	.word 0xd48e49e0  ! 3387: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r10
	mov	0x3c0, %r21
	.word 0xdc866000  ! 3389: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r14
	mov	0x68, %r16
	.word 0x87802072  ! 3391: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3392: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda8cc400  ! 3393: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	.word 0x87802074  ! 3394: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2ae49e0  ! 3395: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	.word 0xd4bc2000  ! 3396: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 3397: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 3398: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcdc8400  ! 3399: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	.word 0xd6bfce80  ! 3400: STDA_R	stda	%r11, [%r31 + %r0] 0x74
	.word 0xd0bf4e80  ! 3401: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	.word 0xd6a70e80  ! 3402: STWA_R	stwa	%r11, [%r28 + %r0] 0x74
	mov	0x28, %r18
	.word 0x87802020  ! 3404: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0df4e60  ! 3405: LDXA_R	ldxa	[%r29, %r0] 0x73, %r8
	mov	0x7c0, %r22
	.word 0xda96e000  ! 3407: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r13
	.word 0xdab66000  ! 3408: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0xdab6a000  ! 3409: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	.word 0x87802025  ! 3410: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaac2000  ! 3411: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0xdaac6000  ! 3412: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	mov	0x70, %r17
	.word 0x87802020  ! 3414: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r25
	.word 0x87802072  ! 3416: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcd7ce80  ! 3417: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r14
	.word 0xd4ae2000  ! 3418: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	.word 0xd49ea000  ! 3419: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	.word 0xdabd84a0  ! 3420: STDA_R	stda	%r13, [%r22 + %r0] 0x25
	.word 0x87802073  ! 3421: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bc0400  ! 3422: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	mov	0x7e8, %r21
	.word 0xdead84a0  ! 3424: STBA_R	stba	%r15, [%r22 + %r0] 0x25
	.word 0xd8bf6000  ! 3425: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	mov	0x48, %r19
	.word 0xd68cc400  ! 3427: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	.word 0xd2a76000  ! 3428: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 3429: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r25
	.word 0xd0c544a0  ! 3431: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r8
	.word 0xd6bfa000  ! 3432: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	mov	0x48, %r18
	.word 0xd6af6000  ! 3434: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd6dfce80  ! 3435: LDXA_R	ldxa	[%r31, %r0] 0x74, %r11
	.word 0x87802020  ! 3436: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3437: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaac8400  ! 3438: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0x87802072  ! 3439: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6a76000  ! 3440: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6bf2000  ! 3441: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd6a74e80  ! 3442: STWA_R	stwa	%r11, [%r29 + %r0] 0x74
	.word 0xdca76000  ! 3443: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	mov	0x50, %r18
	.word 0xd8a70e60  ! 3445: STWA_R	stwa	%r12, [%r28 + %r0] 0x73
	mov	0x7f0, %r21
	.word 0x87802073  ! 3447: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f0, %r20
	.word 0xdab40400  ! 3449: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	wr_tick_cmpr_3_43:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xfa, %g2
	or	%g4, 0xde, %g4
	or	%g6, 0xfe, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4c7a000  ! 3451: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	.word 0xd8a689e0  ! 3452: STWA_R	stwa	%r12, [%r26 + %r0] 0x4f
	.word 0xd8a7a000  ! 3453: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8c7a000  ! 3454: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0x87802020  ! 3455: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8cda000  ! 3456: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r12
	.word 0xd4d78e40  ! 3457: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r10
	.word 0xd2b5a000  ! 3458: STHA_I	stha	%r9, [%r22 + 0x0000] %asi
	.word 0xd2b5e000  ! 3459: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	.word 0xd2bd6000  ! 3460: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	.word 0xdef544a0  ! 3461: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	.word 0xd4a609e0  ! 3462: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	mov	0x3c8, %r22
	.word 0xdcbdc4a0  ! 3464: STDA_R	stda	%r14, [%r23 + %r0] 0x25
	.word 0xd69c8400  ! 3465: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	mov	0x78, %r17
	.word 0xd0c56000  ! 3467: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r8
	.word 0xd0b56000  ! 3468: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	.word 0xd0dd2000  ! 3469: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0x87802020  ! 3470: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r25
	.word 0xd0dca000  ! 3472: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	mov	0x68, %r24
	mov	0x68, %r18
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0cc6000  ! 3476: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	.word 0xd0bca000  ! 3477: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 3478: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd09fa000  ! 3479: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	.word 0xd087e000  ! 3480: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	mov	0x48, %r25
	.word 0xd4bfce80  ! 3482: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	.word 0xd48fe000  ! 3483: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xdeaf8e80  ! 3484: STBA_R	stba	%r15, [%r30 + %r0] 0x74
	.word 0xd297a000  ! 3485: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	.word 0xd2b7e000  ! 3486: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xdebc0400  ! 3487: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	mov	0x78, %r18
	.word 0xdaf48400  ! 3489: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xd4844400  ! 3490: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0xd297ce80  ! 3491: LDUHA_R	lduha	[%r31, %r0] 0x74, %r9
	mov	0x0, %r16
	.word 0xd2af2000  ! 3493: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd2f78e60  ! 3494: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0xdcb7ce40  ! 3495: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	mov	0x40, %r19
	.word 0xd2d76000  ! 3497: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0xd0af4e60  ! 3498: STBA_R	stba	%r8, [%r29 + %r0] 0x73
	.word 0x87802072  ! 3499: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0f70e80  ! 3500: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	mov	0x7d0, %r20
	.word 0xdac544a0  ! 3502: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r13
	mov	0x7f0, %r21
	.word 0xd4f76000  ! 3504: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4c78e80  ! 3505: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r10
	.word 0xdca48400  ! 3506: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	mov	0x50, %r27
	.word 0xd6f544a0  ! 3508: STXA_R	stxa	%r11, [%r21 + %r0] 0x25
	mov	0x0, %r24
	mov	0x20, %r17
	.word 0x87802073  ! 3511: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 3512: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6d78e40  ! 3513: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r11
	.word 0xd4b76000  ! 3514: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 3515: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4d70e60  ! 3516: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r10
	mov	0x7c8, %r22
	.word 0xde8649e0  ! 3518: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r15
	mov	0x7e8, %r23
	.word 0x87802020  ! 3520: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r18
	.word 0x87802072  ! 3522: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3523: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r27
	.word 0xd0bc0400  ! 3525: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	mov	0x7e0, %r20
	.word 0xdc85a000  ! 3527: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r14
	.word 0xdccd2000  ! 3528: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r14
	mov	0x20, %r27
	mov	0x60, %r24
	.word 0xd0978e60  ! 3531: LDUHA_R	lduha	[%r30, %r0] 0x73, %r8
	.word 0xdeb5a000  ! 3532: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	.word 0xd8cf0e40  ! 3533: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r12
	.word 0xd29c0400  ! 3534: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	mov	0x30, %r27
	.word 0x8780204f  ! 3536: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r26
	.word 0xd0ce09e0  ! 3538: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r8
	.word 0xd6d46000  ! 3539: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r11
	.word 0x87802025  ! 3540: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b4a000  ! 3541: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 3542: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r27
	.word 0xd6cf6000  ! 3544: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3545: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bf6000  ! 3546: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd49e09e0  ! 3547: LDDA_R	ldda	[%r24, %r0] 0x4f, %r10
	.word 0x87802020  ! 3548: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcaca000  ! 3549: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xdcf46000  ! 3550: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdca42000  ! 3551: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xd4bf4e80  ! 3552: STDA_R	stda	%r10, [%r29 + %r0] 0x74
	.word 0xd48c0400  ! 3553: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	.word 0xd0a4e000  ! 3554: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	mov	0x68, %r24
	.word 0x87802074  ! 3556: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0dc2000  ! 3557: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	.word 0xd0b46000  ! 3558: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0xd0b42000  ! 3559: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	mov	0x38, %r25
	mov	0x58, %r27
	mov	0x68, %r24
	.word 0xdeb584a0  ! 3563: STHA_R	stha	%r15, [%r22 + %r0] 0x25
	.word 0x87802072  ! 3564: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r26
	mov	0x70, %r26
	.word 0xd28fe000  ! 3567: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	.word 0xdea6c9e0  ! 3568: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	.word 0xd8c72000  ! 3569: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0x87802074  ! 3570: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8dcc400  ! 3571: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	.word 0xd0af0e80  ! 3572: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	.word 0x87802020  ! 3573: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a689e0  ! 3574: STWA_R	stwa	%r8, [%r26 + %r0] 0x4f
	.word 0xdaf76000  ! 3575: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 3576: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea78e60  ! 3577: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	.word 0xd68fe000  ! 3578: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	mov	0x68, %r19
	.word 0xd69fe000  ! 3580: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	.word 0xdaa504a0  ! 3581: STWA_R	stwa	%r13, [%r20 + %r0] 0x25
	.word 0x8780204f  ! 3582: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r16
	.word 0x87802073  ! 3584: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd084e000  ! 3585: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	.word 0x87802020  ! 3586: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09ea000  ! 3587: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r8
	.word 0xd0d66000  ! 3588: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r8
	.word 0xd0b62000  ! 3589: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	mov	0x3e0, %r20
	mov	0x7f0, %r21
	.word 0xd8b6c9e0  ! 3592: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	mov	0x0, %r17
	.word 0xd0af4e40  ! 3594: STBA_R	stba	%r8, [%r29 + %r0] 0x72
	.word 0xd2bf4e40  ! 3595: STDA_R	stda	%r9, [%r29 + %r0] 0x72
	.word 0xd8b62000  ! 3596: STHA_I	stha	%r12, [%r24 + 0x0000] %asi
	.word 0xde9649e0  ! 3597: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r15
	.word 0xdcdea000  ! 3598: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r14
	.word 0xdcbea000  ! 3599: STDA_I	stda	%r14, [%r26 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0xd8dfce80  ! 3601: LDXA_R	ldxa	[%r31, %r0] 0x74, %r12
	.word 0xdcb48400  ! 3602: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xdea66000  ! 3603: STWA_I	stwa	%r15, [%r25 + 0x0000] %asi
	mov	0x3f0, %r20
	.word 0xdcaf0e40  ! 3605: STBA_R	stba	%r14, [%r28 + %r0] 0x72
	.word 0xd0de2000  ! 3606: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r8
	.word 0xd0f66000  ! 3607: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	.word 0xd0f6a000  ! 3608: STXA_I	stxa	%r8, [%r26 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xd0a6a000  ! 3610: STWA_I	stwa	%r8, [%r26 + 0x0000] %asi
	.word 0xd0dee000  ! 3611: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r8
	mov	0x28, %r26
	.word 0x87802074  ! 3613: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0970e60  ! 3614: LDUHA_R	lduha	[%r28, %r0] 0x73, %r8
	.word 0xdcd74e40  ! 3615: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r14
	mov	0x50, %r16
	.word 0xda87ce80  ! 3617: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r13
	mov	0x3d8, %r22
	.word 0xd2cd44a0  ! 3619: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcdf8e40  ! 3621: LDXA_R	ldxa	[%r30, %r0] 0x72, %r14
	mov	0x60, %r27
	.word 0x87802020  ! 3623: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 3624: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd6bf2000  ! 3626: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd6a72000  ! 3627: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	mov	0x7f8, %r20
	mov	0x0, %r16
	mov	0x40, %r17
	.word 0x8780204f  ! 3631: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6c56000  ! 3632: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r11
	.word 0xd6a5a000  ! 3633: STWA_I	stwa	%r11, [%r22 + 0x0000] %asi
	.word 0xd6bd2000  ! 3634: STDA_I	stda	%r11, [%r20 + 0x0000] %asi
	.word 0xd2b584a0  ! 3635: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0xd4c56000  ! 3636: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r10
	.word 0xd0dc8400  ! 3637: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	mov	0x40, %r24
	.word 0x87802072  ! 3639: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c8, %r22
	.word 0xd4d544a0  ! 3641: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r10
	.word 0xdcdd84a0  ! 3642: LDXA_R	ldxa	[%r22, %r0] 0x25, %r14
	mov	0x28, %r27
	.word 0xd2f7ce80  ! 3644: STXA_R	stxa	%r9, [%r31 + %r0] 0x74
	.word 0xd0a70e60  ! 3645: STWA_R	stwa	%r8, [%r28 + %r0] 0x73
	wr_tick_cmpr_3_44:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xed, %g2
	or	%g4, 0xf0, %g4
	or	%g6, 0xbe, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xde84c400  ! 3647: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0xd4bfce80  ! 3648: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	.word 0x8780204f  ! 3649: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda946000  ! 3650: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	mov	0x3e8, %r20
	.word 0xd8b70e60  ! 3652: STHA_R	stha	%r12, [%r28 + %r0] 0x73
	.word 0xd0978e60  ! 3653: LDUHA_R	lduha	[%r30, %r0] 0x73, %r8
	.word 0xd6cca000  ! 3654: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r11
	.word 0xd6ace000  ! 3655: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	wr_tick_cmpr_3_45:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xec, %g2
	or	%g4, 0xc2, %g4
	or	%g6, 0xc9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd684a000  ! 3657: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r11
	.word 0xd6a4e000  ! 3658: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0xd69e49e0  ! 3659: LDDA_R	ldda	[%r25, %r0] 0x4f, %r11
	.word 0xd0d7ce60  ! 3660: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r8
	mov	0x40, %r27
	.word 0xd2d4e000  ! 3662: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0xd8a70e80  ! 3663: STWA_R	stwa	%r12, [%r28 + %r0] 0x74
	.word 0xdec689e0  ! 3664: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r15
	.word 0xdebc2000  ! 3665: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xd297ce80  ! 3666: LDUHA_R	lduha	[%r31, %r0] 0x74, %r9
	.word 0x87802020  ! 3667: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r24
	.word 0x87802073  ! 3669: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd29d44a0  ! 3670: LDDA_R	ldda	[%r21, %r0] 0x25, %r9
	.word 0xd4c7ce80  ! 3671: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r10
	.word 0xd49ca000  ! 3672: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd29fce60  ! 3673: LDDA_R	ldda	[%r31, %r0] 0x73, %r9
	.word 0x87802073  ! 3674: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd094c400  ! 3675: LDUHA_R	lduha	[%r19, %r0] 0x20, %r8
	.word 0xdabf6000  ! 3676: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 3677: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda94e000  ! 3678: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r13
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x7f0, %r21
	.word 0xd2b649e0  ! 3681: STHA_R	stha	%r9, [%r25 + %r0] 0x4f
	.word 0xdebc6000  ! 3682: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	mov	0x38, %r17
	.word 0xdec4a000  ! 3684: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xdabf0e80  ! 3685: STDA_R	stda	%r13, [%r28 + %r0] 0x74
	.word 0xd6d46000  ! 3686: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3687: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68f6000  ! 3688: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0x87802025  ! 3689: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6acc400  ! 3690: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xd6bc4400  ! 3691: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	.word 0xd2f48400  ! 3692: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	mov	0x7e0, %r22
	.word 0xd2f6c9e0  ! 3694: STXA_R	stxa	%r9, [%r27 + %r0] 0x4f
	.word 0xd88f6000  ! 3695: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xdcbd84a0  ! 3696: STDA_R	stda	%r14, [%r22 + %r0] 0x25
	.word 0xdadfa000  ! 3697: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0x87802072  ! 3698: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0af8e60  ! 3699: STBA_R	stba	%r8, [%r30 + %r0] 0x73
	.word 0xde866000  ! 3700: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r15
	.word 0xdec584a0  ! 3701: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r15
	.word 0xda9ea000  ! 3702: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r13
	.word 0xd4f48400  ! 3703: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0x87802072  ! 3704: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8afa000  ! 3705: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xd6dfce40  ! 3706: LDXA_R	ldxa	[%r31, %r0] 0x72, %r11
	mov	0x40, %r24
	.word 0xd4af6000  ! 3708: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd4bc4400  ! 3709: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0xd0ad44a0  ! 3710: STBA_R	stba	%r8, [%r21 + %r0] 0x25
	mov	0x28, %r19
	.word 0xd2bf2000  ! 3712: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd6f649e0  ! 3713: STXA_R	stxa	%r11, [%r25 + %r0] 0x4f
	.word 0xdec70e60  ! 3714: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r15
	.word 0xd4f40400  ! 3715: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xd487ce40  ! 3716: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r10
	.word 0x87802020  ! 3717: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3718: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8d46000  ! 3719: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	mov	0x48, %r27
	.word 0xd88c2000  ! 3721: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	mov	0x68, %r18
	mov	0x60, %r19
	.word 0x87802025  ! 3724: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cd84a0  ! 3725: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r10
	mov	0x58, %r25
	.word 0xd4878e80  ! 3727: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r10
	.word 0x87802072  ! 3728: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc8cc400  ! 3729: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	mov	0x58, %r18
	.word 0xdca7a000  ! 3731: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 3732: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbc2000  ! 3733: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xdcac2000  ! 3734: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0xd0a649e0  ! 3735: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	mov	0x0, %r19
	.word 0xd0ac6000  ! 3737: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3738: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8cfce80  ! 3739: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r12
	mov	0x48, %r25
	.word 0xd887ce40  ! 3741: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r12
	.word 0xd0f76000  ! 3742: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	mov	0x70, %r16
	.word 0xdebe89e0  ! 3744: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	.word 0x87802072  ! 3745: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd087e000  ! 3746: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	mov	0x3d8, %r23
	.word 0x87802020  ! 3748: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r20
	.word 0x87802072  ! 3750: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd097a000  ! 3751: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	mov	0x8, %r19
	.word 0xda8584a0  ! 3753: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r13
	.word 0xd8bfa000  ! 3754: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xdab40400  ! 3755: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xd4afce80  ! 3756: STBA_R	stba	%r10, [%r31 + %r0] 0x74
	.word 0xdedf2000  ! 3757: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xd68c4400  ! 3758: LDUBA_R	lduba	[%r17, %r0] 0x20, %r11
	.word 0xd8b72000  ! 3759: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd2af8e80  ! 3760: STBA_R	stba	%r9, [%r30 + %r0] 0x74
	.word 0x87802072  ! 3761: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f5a000  ! 3762: STXA_I	stxa	%r11, [%r22 + 0x0000] %asi
	.word 0xd6df0e40  ! 3763: LDXA_R	ldxa	[%r28, %r0] 0x72, %r11
	.word 0xd48d2000  ! 3764: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0xd2cf8e40  ! 3765: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r9
	mov	0x68, %r16
	.word 0xdaa5e000  ! 3767: STWA_I	stwa	%r13, [%r23 + 0x0000] %asi
	.word 0xd4840400  ! 3768: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	.word 0xd4b5e000  ! 3769: STHA_I	stha	%r10, [%r23 + 0x0000] %asi
	mov	0x18, %r16
	.word 0xd8bf8e80  ! 3771: STDA_R	stda	%r12, [%r30 + %r0] 0x74
	mov	0x3f0, %r20
	.word 0xdedf0e40  ! 3773: LDXA_R	ldxa	[%r28, %r0] 0x72, %r15
	.word 0xde8c0400  ! 3774: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0x87802025  ! 3775: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd49584a0  ! 3776: LDUHA_R	lduha	[%r22, %r0] 0x25, %r10
	.word 0xdedf2000  ! 3777: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0x87802072  ! 3778: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdea7a000  ! 3779: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	mov	0x10, %r17
	.word 0xdedf2000  ! 3781: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xde8fe000  ! 3782: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	mov	0x30, %r24
	.word 0x87802020  ! 3784: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedf2000  ! 3785: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xd0cf8e80  ! 3786: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r8
	mov	0x7f8, %r21
	mov	0x3e0, %r20
	.word 0xd6df2000  ! 3789: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6a72000  ! 3790: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd68fe000  ! 3791: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xd8a40400  ! 3792: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0x87802074  ! 3793: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3794: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r24
	mov	0x30, %r25
	.word 0xd084a000  ! 3797: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	.word 0xd08c6000  ! 3798: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	mov	0x7d8, %r20
	mov	0x3d0, %r20
	.word 0xdcbfce60  ! 3801: STDA_R	stda	%r14, [%r31 + %r0] 0x73
	mov	0x68, %r26
	.word 0xd69c2000  ! 3803: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r11
	.word 0xd6f42000  ! 3804: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	.word 0xd6bca000  ! 3805: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	mov	0x20, %r18
	mov	0x3c8, %r23
	.word 0x87802072  ! 3808: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6cd2000  ! 3809: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r11
	.word 0xd4df8e40  ! 3810: LDXA_R	ldxa	[%r30, %r0] 0x72, %r10
	.word 0xd8bfce60  ! 3811: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	.word 0xd4f5a000  ! 3812: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	mov	0x7d0, %r20
	.word 0xd4a52000  ! 3814: STWA_I	stwa	%r10, [%r20 + 0x0000] %asi
	.word 0xd6adc4a0  ! 3815: STBA_R	stba	%r11, [%r23 + %r0] 0x25
	.word 0xd6d48400  ! 3816: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0xdaae89e0  ! 3817: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	.word 0xd6d70e40  ! 3818: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r11
	.word 0xd2a504a0  ! 3819: STWA_R	stwa	%r9, [%r20 + %r0] 0x25
	.word 0xda8cc400  ! 3820: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	mov	0x0, %r19
	mov	0x3e0, %r22
	.word 0xdca52000  ! 3823: STWA_I	stwa	%r14, [%r20 + 0x0000] %asi
	.word 0xd4df0e60  ! 3824: LDXA_R	ldxa	[%r28, %r0] 0x73, %r10
	.word 0xdcf44400  ! 3825: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0x87802020  ! 3826: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ac4400  ! 3827: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	mov	0x7c0, %r20
	.word 0xdc9f2000  ! 3829: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0x87802074  ! 3830: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r27
	mov	0x3d8, %r21
	.word 0xd8f70e80  ! 3833: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	.word 0x87802073  ! 3834: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4962000  ! 3835: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r10
	.word 0x87802020  ! 3836: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b66000  ! 3837: STHA_I	stha	%r10, [%r25 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0xd496a000  ! 3839: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r10
	.word 0xd8a78e40  ! 3840: STWA_R	stwa	%r12, [%r30 + %r0] 0x72
	.word 0x87802020  ! 3841: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xdc9fe000  ! 3843: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	mov	0x48, %r18
	mov	0x0, %r19
	.word 0x87802073  ! 3846: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb4a000  ! 3847: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xdcf42000  ! 3848: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0xdc9ce000  ! 3849: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r14
	.word 0xdcf42000  ! 3850: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0xd2d78e80  ! 3851: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r9
	.word 0xdc84a000  ! 3852: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	mov	0x10, %r19
	.word 0xd0b74e60  ! 3854: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	.word 0xd6cca000  ! 3855: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r11
	.word 0x87802072  ! 3856: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd686e000  ! 3857: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r11
	.word 0xd6cea000  ! 3858: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	.word 0xd6bee000  ! 3859: STDA_I	stda	%r11, [%r27 + 0x0000] %asi
	mov	0x3c8, %r20
	.word 0xd68609e0  ! 3861: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r11
	.word 0xdca4c400  ! 3862: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 3863: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 3864: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 3865: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3866: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 3867: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3868: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r27
	.word 0xdcac0400  ! 3870: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xdaa5a000  ! 3871: STWA_I	stwa	%r13, [%r22 + 0x0000] %asi
	mov	0x7c0, %r22
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xda95a000  ! 3874: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r13
	.word 0xdab5a000  ! 3875: STHA_I	stha	%r13, [%r22 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802025  ! 3877: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r17
	mov	0x70, %r27
	.word 0xdab56000  ! 3880: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xdab5e000  ! 3882: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0xda8de000  ! 3883: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r13
	mov	0x68, %r24
	wr_tick_cmpr_3_46:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xd3, %g2
	or	%g4, 0xfa, %g4
	or	%g6, 0x8a, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd897ce60  ! 3886: LDUHA_R	lduha	[%r31, %r0] 0x73, %r12
	.word 0xd2d56000  ! 3887: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r9
	.word 0xd2f52000  ! 3888: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	.word 0xdaa544a0  ! 3889: STWA_R	stwa	%r13, [%r21 + %r0] 0x25
	.word 0xd8df4e60  ! 3890: LDXA_R	ldxa	[%r29, %r0] 0x73, %r12
	.word 0xd4bd2000  ! 3891: STDA_I	stda	%r10, [%r20 + 0x0000] %asi
	.word 0xdc87ce60  ! 3892: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r14
	.word 0xd8c70e60  ! 3893: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r12
	.word 0xdccda000  ! 3894: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r14
	mov	0x10, %r25
	.word 0x87802072  ! 3896: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 3897: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0cc4400  ! 3898: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	mov	0x7d8, %r20
	mov	0x78, %r24
	.word 0xd88ee000  ! 3901: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r12
	mov	0x28, %r25
	.word 0xd8bea000  ! 3903: STDA_I	stda	%r12, [%r26 + 0x0000] %asi
	.word 0xd8d62000  ! 3904: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r12
	.word 0xd8d6e000  ! 3905: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r12
	mov	0x78, %r26
	mov	0x0, %r26
	.word 0xd89e6000  ! 3908: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r12
	.word 0xd8b6e000  ! 3909: STHA_I	stha	%r12, [%r27 + 0x0000] %asi
	.word 0xd6ce89e0  ! 3910: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r11
	.word 0xd0a62000  ! 3911: STWA_I	stwa	%r8, [%r24 + 0x0000] %asi
	mov	0x7f8, %r20
	.word 0xd09e2000  ! 3913: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r8
	.word 0xd0b62000  ! 3914: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0x8780204f  ! 3915: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 3916: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4b48400  ! 3917: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd6c66000  ! 3918: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 3919: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd69c2000  ! 3920: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r11
	.word 0xd0aec9e0  ! 3921: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	.word 0xd6a4e000  ! 3922: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 3923: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r26
	.word 0xd8bcc400  ! 3925: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0xd4b7e000  ! 3926: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd4afe000  ! 3927: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 3928: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r27
	.word 0xd8bc4400  ! 3930: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xd0c7a000  ! 3931: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xd48e89e0  ! 3932: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r10
	.word 0xd087a000  ! 3933: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0xd8ac4400  ! 3934: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xdeaf6000  ! 3935: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xdeb72000  ! 3936: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xd0bc4400  ! 3937: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xd0ac0400  ! 3938: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	mov	0x38, %r26
	.word 0xd68f8e40  ! 3940: LDUBA_R	lduba	[%r30, %r0] 0x72, %r11
	.word 0xd0f584a0  ! 3941: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	.word 0xd0af6000  ! 3942: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	mov	0x60, %r26
	.word 0xd0bfe000  ! 3944: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	mov	0x68, %r25
	.word 0xd895c4a0  ! 3946: LDUHA_R	lduha	[%r23, %r0] 0x25, %r12
	.word 0xd2974e60  ! 3947: LDUHA_R	lduha	[%r29, %r0] 0x73, %r9
	.word 0xd2bfa000  ! 3948: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xdcbec9e0  ! 3950: STDA_R	stda	%r14, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 3951: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3952: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r27
	.word 0xd0bf6000  ! 3954: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd6974e40  ! 3955: LDUHA_R	lduha	[%r29, %r0] 0x72, %r11
	mov	0x10, %r27
	.word 0xdeafa000  ! 3957: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xde872000  ! 3959: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0x87802073  ! 3960: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeaee000  ! 3961: STBA_I	stba	%r15, [%r27 + 0x0000] %asi
	.word 0xdebe2000  ! 3962: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	.word 0xd6bf8e40  ! 3963: STDA_R	stda	%r11, [%r30 + %r0] 0x72
	.word 0xdac504a0  ! 3964: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r13
	.word 0xd69ee000  ! 3965: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3966: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3967: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b7a000  ! 3968: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	mov	0x68, %r25
	.word 0xd2a544a0  ! 3970: STWA_R	stwa	%r9, [%r21 + %r0] 0x25
	.word 0xd0d7e000  ! 3971: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0a76000  ! 3972: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	mov	0x40, %r27
	mov	0x20, %r24
	.word 0xd0f7e000  ! 3975: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xda978e60  ! 3976: LDUHA_R	lduha	[%r30, %r0] 0x73, %r13
	.word 0xd2a72000  ! 3977: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 3978: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a7e000  ! 3979: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xd8bf4e60  ! 3980: STDA_R	stda	%r12, [%r29 + %r0] 0x73
	mov	0x58, %r24
	.word 0xdc972000  ! 3982: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	mov	0x70, %r16
	mov	0x50, %r17
	wr_tick_cmpr_3_47:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc7, %g2
	or	%g4, 0x94, %g4
	or	%g6, 0xd7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2b689e0  ! 3986: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	.word 0xd8ad84a0  ! 3987: STBA_R	stba	%r12, [%r22 + %r0] 0x25
	mov	0x18, %r17
	.word 0xd2f78e80  ! 3989: STXA_R	stxa	%r9, [%r30 + %r0] 0x74
	.word 0xd8b74e40  ! 3990: STHA_R	stha	%r12, [%r29 + %r0] 0x72
	.word 0xd6bfe000  ! 3991: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd6afe000  ! 3992: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 3993: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6876000  ! 3994: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	.word 0xd68fe000  ! 3995: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0x87802074  ! 3996: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6ade000  ! 3997: STBA_I	stba	%r11, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 3998: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6aca000  ! 3999: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0xd6f4e000  ! 4001: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xd6a46000  ! 4003: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	mov	0x78, %r24
	mov	0x3c8, %r21
	mov	0x58, %r26
	.word 0xd6846000  ! 4007: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r11
	.word 0xd6f46000  ! 4008: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0xd6a42000  ! 4009: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 4010: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r27
	.word 0xd6cea000  ! 4012: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	mov	0x60, %r25
	.word 0x87802072  ! 4014: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8f40400  ! 4015: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	mov	0x20, %r27
	mov	0x70, %r26
	.word 0xd086e000  ! 4018: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r8
	mov	0x7e8, %r21
	.word 0xdaf40400  ! 4020: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xded66000  ! 4021: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r15
	.word 0xdec6a000  ! 4022: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r15
	.word 0xd8f7ce40  ! 4023: STXA_R	stxa	%r12, [%r31 + %r0] 0x72
	.word 0x87802020  ! 4024: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c74e60  ! 4025: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r12
	.word 0x87802073  ! 4026: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6d6c9e0  ! 4027: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r11
	.word 0x8780204f  ! 4028: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f4e000  ! 4029: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	.word 0xd8af8e60  ! 4030: STBA_R	stba	%r12, [%r30 + %r0] 0x73
	.word 0xdaf42000  ! 4031: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0xdab4a000  ! 4032: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 4033: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4874e40  ! 4034: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r10
	.word 0x8780204f  ! 4035: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4036: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r19
	.word 0xdcb42000  ! 4038: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xd09f0e40  ! 4040: LDDA_R	ldda	[%r28, %r0] 0x72, %r8
	mov	0x30, %r25
	.word 0xd8a40400  ! 4042: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0xda9c6000  ! 4043: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xd4878e60  ! 4044: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r10
	mov	0x7d0, %r23
	.word 0xd8f40400  ! 4046: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xdef74e60  ! 4047: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	.word 0xd48c6000  ! 4048: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r10
	mov	0x50, %r24
	.word 0xd4cc2000  ! 4050: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	.word 0xd4a42000  ! 4051: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4052: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b7ce60  ! 4053: STHA_R	stha	%r10, [%r31 + %r0] 0x73
	.word 0x87802073  ! 4054: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa42000  ! 4055: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 4056: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4057: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8f2000  ! 4058: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xde8c4400  ! 4059: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	.word 0xdef78e80  ! 4060: STXA_R	stxa	%r15, [%r30 + %r0] 0x74
	.word 0xd8be89e0  ! 4061: STDA_R	stda	%r12, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 4062: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdef609e0  ! 4063: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	.word 0xd8ace000  ! 4064: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0xd2bfce80  ! 4065: STDA_R	stda	%r9, [%r31 + %r0] 0x74
	.word 0x87802073  ! 4066: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4d6c9e0  ! 4067: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r10
	.word 0xd4a7a000  ! 4068: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	mov	0x3f0, %r23
	mov	0x8, %r24
	.word 0xdeaf8e40  ! 4071: STBA_R	stba	%r15, [%r30 + %r0] 0x72
	mov	0x3c0, %r22
	.word 0xdedfa000  ! 4073: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xd286c9e0  ! 4074: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r9
	.word 0x8780204f  ! 4075: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b6c9e0  ! 4076: STHA_R	stha	%r8, [%r27 + %r0] 0x4f
	.word 0xd8f7e000  ! 4077: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8f72000  ! 4078: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8f7e000  ! 4079: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8cfe000  ! 4080: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8afe000  ! 4081: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd6b48400  ! 4082: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xdea7e000  ! 4083: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xded72000  ! 4085: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xdeb7a000  ! 4086: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xd8a74e40  ! 4087: STWA_R	stwa	%r12, [%r29 + %r0] 0x72
	.word 0xdc876000  ! 4088: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	mov	0x8, %r19
	.word 0x87802020  ! 4090: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb7e000  ! 4091: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xd49dc4a0  ! 4092: LDDA_R	ldda	[%r23, %r0] 0x25, %r10
	.word 0xd4dfce80  ! 4093: LDXA_R	ldxa	[%r31, %r0] 0x74, %r10
	.word 0xdc9c4400  ! 4094: LDDA_R	ldda	[%r17, %r0] 0x20, %r14
	.word 0xd88609e0  ! 4095: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r12
	.word 0x87802025  ! 4096: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4097: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6962000  ! 4098: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r11
	mov	0x10, %r27
	mov	0x58, %r16
	mov	0x3e0, %r21
	.word 0x87802074  ! 4102: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r19
	.word 0x87802025  ! 4104: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbf0e80  ! 4105: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	mov	0x7f0, %r20
	.word 0xdaaec9e0  ! 4107: STBA_R	stba	%r13, [%r27 + %r0] 0x4f
	.word 0xd4d48400  ! 4108: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	.word 0xd69f4e40  ! 4109: LDDA_R	ldda	[%r29, %r0] 0x72, %r11
	.word 0xd6c40400  ! 4110: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r11
	.word 0x87802074  ! 4111: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6dda000  ! 4112: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r11
	.word 0xd6dde000  ! 4113: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r11
	.word 0xd4f7ce60  ! 4114: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	.word 0xd8de89e0  ! 4115: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r12
	.word 0xd6f649e0  ! 4116: STXA_R	stxa	%r11, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 4117: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r18
	mov	0x7c0, %r22
	.word 0xd0dfce40  ! 4120: LDXA_R	ldxa	[%r31, %r0] 0x72, %r8
	mov	0x3d0, %r20
	.word 0xd49fa000  ! 4122: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0xd49f2000  ! 4123: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd6c70e40  ! 4124: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r11
	mov	0x7c8, %r22
	.word 0xd09649e0  ! 4126: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r8
	.word 0xd686c9e0  ! 4127: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r11
	.word 0xd4c689e0  ! 4128: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r10
	.word 0xda8f2000  ! 4129: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xda9fa000  ! 4130: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xdcbf4e40  ! 4131: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	.word 0xda97a000  ! 4132: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	mov	0x40, %r19
	.word 0xda8c8400  ! 4134: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	mov	0x7e0, %r23
	.word 0xdcafe000  ! 4136: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 4137: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r25
	mov	0x10, %r27
	mov	0x3c8, %r22
	.word 0xd687ce60  ! 4141: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r11
	.word 0xd0f72000  ! 4142: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	mov	0x28, %r24
	.word 0x87802073  ! 4144: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e8, %r22
	.word 0xd0bca000  ! 4146: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0xdca4c400  ! 4147: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xd8b4a000  ! 4148: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 4149: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8afa000  ! 4150: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xd8a72000  ! 4151: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 4152: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2b48400  ! 4153: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	mov	0x10, %r26
	mov	0x8, %r16
	.word 0xdac62000  ! 4156: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r13
	.word 0xdacea000  ! 4157: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r13
	.word 0xd4df4e80  ! 4158: LDXA_R	ldxa	[%r29, %r0] 0x74, %r10
	.word 0xd08d84a0  ! 4159: LDUBA_R	lduba	[%r22, %r0] 0x25, %r8
	.word 0xd08f8e80  ! 4160: LDUBA_R	lduba	[%r30, %r0] 0x74, %r8
	.word 0x87802020  ! 4161: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea46000  ! 4162: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xdea46000  ! 4163: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xdcbd84a0  ! 4164: STDA_R	stda	%r14, [%r22 + %r0] 0x25
	.word 0xdedce000  ! 4165: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r15
	.word 0x87802025  ! 4166: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r16
	mov	0x18, %r18
	mov	0x10, %r24
	.word 0x87802072  ! 4170: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r24
	mov	0x38, %r24
	.word 0xde97a000  ! 4173: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	.word 0xd0af4e80  ! 4174: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	.word 0xd0d4c400  ! 4175: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	.word 0xd4df6000  ! 4176: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4cf6000  ! 4177: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0xd4d76000  ! 4178: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0xdad70e40  ! 4179: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r13
	.word 0xd8f74e80  ! 4180: STXA_R	stxa	%r12, [%r29 + %r0] 0x74
	mov	0x7d0, %r23
	.word 0xd0f70e80  ! 4182: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0x87802074  ! 4183: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b4e000  ! 4184: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xd4b40400  ! 4185: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0x87802074  ! 4186: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2cc8400  ! 4187: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	mov	0x20, %r25
	mov	0x30, %r18
	.word 0xd0b70e40  ! 4190: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	.word 0xd48de000  ! 4191: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r10
	.word 0x87802074  ! 4192: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd49f6000  ! 4193: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0xd4bfe000  ! 4194: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x78, %r18
	.word 0x87802072  ! 4196: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4dfe000  ! 4197: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd28c0400  ! 4198: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	.word 0x87802025  ! 4199: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f584a0  ! 4200: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	mov	0x10, %r24
	.word 0xdac7e000  ! 4202: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xdacfe000  ! 4203: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0xdad7a000  ! 4204: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0xd2948400  ! 4205: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	mov	0x70, %r17
	mov	0x48, %r27
	.word 0xd4b7e000  ! 4208: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 4209: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r25
	mov	0x78, %r18
	.word 0xd69fce60  ! 4212: LDDA_R	ldda	[%r31, %r0] 0x73, %r11
	.word 0x8780204f  ! 4213: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd886e000  ! 4214: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r12
	.word 0xdcb6c9e0  ! 4215: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	mov	0x0, %r16
	.word 0xdaf5c4a0  ! 4217: STXA_R	stxa	%r13, [%r23 + %r0] 0x25
	.word 0x87802020  ! 4218: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r23
	.word 0xd0b70e80  ! 4220: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	.word 0x87802020  ! 4221: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad6c9e0  ! 4222: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r13
	mov	0x58, %r26
	.word 0xd0a609e0  ! 4224: STWA_R	stwa	%r8, [%r24 + %r0] 0x4f
	.word 0xd0dee000  ! 4225: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r8
	mov	0x7d0, %r20
	mov	0x60, %r16
	mov	0x0, %r26
	.word 0x87802020  ! 4229: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r21
	.word 0xd09fe000  ! 4231: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	mov	0x7f8, %r23
	.word 0xd4b4c400  ! 4233: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	mov	0x40, %r16
	mov	0x60, %r25
	mov	0x7c0, %r20
	.word 0xdeaf6000  ! 4237: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xd48609e0  ! 4238: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r10
	.word 0xd4bec9e0  ! 4239: STDA_R	stda	%r10, [%r27 + %r0] 0x4f
	mov	0x58, %r16
	.word 0xdcdd84a0  ! 4241: LDXA_R	ldxa	[%r22, %r0] 0x25, %r14
	.word 0xd6bfce40  ! 4242: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	.word 0xde87a000  ! 4243: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0x87802020  ! 4244: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_3_48:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe7, %g2
	or	%g4, 0xcd, %g4
	or	%g6, 0xee, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2a78e40  ! 4246: STWA_R	stwa	%r9, [%r30 + %r0] 0x72
	.word 0xd8c6c9e0  ! 4247: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r12
	.word 0x8780204f  ! 4248: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeb649e0  ! 4249: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	mov	0x28, %r25
	.word 0x87802074  ! 4251: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa66000  ! 4252: STWA_I	stwa	%r13, [%r25 + 0x0000] %asi
	mov	0x0, %r17
	.word 0x87802072  ! 4254: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcdf8e40  ! 4255: LDXA_R	ldxa	[%r30, %r0] 0x72, %r14
	.word 0x87802020  ! 4256: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r25
	mov	0x20, %r26
	mov	0x7e8, %r23
	.word 0x87802020  ! 4260: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde94c400  ! 4261: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	.word 0xdec76000  ! 4262: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0x87802072  ! 4263: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r25
	mov	0x7f8, %r21
	.word 0xdebda000  ! 4266: STDA_I	stda	%r15, [%r22 + 0x0000] %asi
	.word 0xdec52000  ! 4267: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r15
	mov	0x68, %r26
	.word 0xd09609e0  ! 4269: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r8
	mov	0x3d8, %r22
	.word 0xdad7ce80  ! 4271: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r13
	.word 0xd6cde000  ! 4272: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r11
	.word 0xd6b52000  ! 4273: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	.word 0xd4d544a0  ! 4274: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r10
	.word 0xd4b5a000  ! 4275: STHA_I	stha	%r10, [%r22 + 0x0000] %asi
	.word 0xd4a52000  ! 4276: STWA_I	stwa	%r10, [%r20 + 0x0000] %asi
	.word 0xdade49e0  ! 4277: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r13
	.word 0xd6f56000  ! 4278: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	mov	0x7d0, %r22
	mov	0x3f8, %r21
	mov	0x68, %r16
	mov	0x3d8, %r22
	.word 0xdea7ce40  ! 4283: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	.word 0xda952000  ! 4284: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r13
	wr_tick_cmpr_3_49:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xba, %g2
	or	%g4, 0x89, %g4
	or	%g6, 0xb8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdab56000  ! 4286: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	.word 0xdaa5e000  ! 4287: STWA_I	stwa	%r13, [%r23 + 0x0000] %asi
	.word 0xdc870e60  ! 4288: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r14
	wr_tick_cmpr_3_50:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd1, %g2
	or	%g4, 0xf7, %g4
	or	%g6, 0x8b, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2bd6000  ! 4290: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	mov	0x0, %r16
	.word 0xd2b52000  ! 4292: STHA_I	stha	%r9, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 4293: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68fce60  ! 4294: LDUBA_R	lduba	[%r31, %r0] 0x73, %r11
	.word 0xd2f76000  ! 4295: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xd297e000  ! 4296: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	mov	0x20, %r18
	.word 0xd2a72000  ! 4298: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 4299: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28ee000  ! 4300: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r9
	.word 0xd2c6e000  ! 4301: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r9
	.word 0xd2a6e000  ! 4302: STWA_I	stwa	%r9, [%r27 + 0x0000] %asi
	.word 0x8780204f  ! 4303: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde844400  ! 4304: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	.word 0xdcb72000  ! 4305: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 4306: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdead84a0  ! 4307: STBA_R	stba	%r15, [%r22 + %r0] 0x25
	mov	0x48, %r25
	.word 0xd0df8e40  ! 4309: LDXA_R	ldxa	[%r30, %r0] 0x72, %r8
	.word 0xdadf6000  ! 4310: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xdaf689e0  ! 4311: STXA_R	stxa	%r13, [%r26 + %r0] 0x4f
	mov	0x70, %r27
	.word 0xd0870e80  ! 4313: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r8
	.word 0xd0b6c9e0  ! 4314: STHA_R	stha	%r8, [%r27 + %r0] 0x4f
	.word 0x87802072  ! 4315: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6a76000  ! 4316: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6a76000  ! 4317: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	mov	0x50, %r17
	mov	0x28, %r18
	.word 0xd697e000  ! 4320: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0xd6b78e60  ! 4321: STHA_R	stha	%r11, [%r30 + %r0] 0x73
	mov	0x78, %r17
	.word 0xde87e000  ! 4323: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0x87802025  ! 4324: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb7e000  ! 4325: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xdeb72000  ! 4326: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 4327: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9f2000  ! 4328: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xd88c4400  ! 4329: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0xd09f8e60  ! 4330: LDDA_R	ldda	[%r30, %r0] 0x73, %r8
	.word 0xd6a7ce40  ! 4331: STWA_R	stwa	%r11, [%r31 + %r0] 0x72
	.word 0xd4b7ce80  ! 4332: STHA_R	stha	%r10, [%r31 + %r0] 0x74
	.word 0xd6a72000  ! 4333: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 4334: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6ac2000  ! 4335: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	.word 0xdacc0400  ! 4336: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r13
	mov	0x0, %r19
	mov	0x58, %r24
	.word 0xd4f4a000  ! 4339: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0xd494e000  ! 4340: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	.word 0xd6ccc400  ! 4341: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	.word 0xd8b44400  ! 4342: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0xd08c0400  ! 4343: LDUBA_R	lduba	[%r16, %r0] 0x20, %r8
	.word 0xd08c2000  ! 4344: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0xd88ec9e0  ! 4345: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r12
	.word 0xd2bc2000  ! 4346: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xd2d42000  ! 4347: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0x87802073  ! 4348: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c8, %r20
	.word 0x87802073  ! 4350: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 4351: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd295a000  ! 4352: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r9
	.word 0xd2ad6000  ! 4353: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0xd2ada000  ! 4354: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xd2ad2000  ! 4355: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xd0af0e40  ! 4356: STBA_R	stba	%r8, [%r28 + %r0] 0x72
	.word 0xda8f0e60  ! 4357: LDUBA_R	lduba	[%r28, %r0] 0x73, %r13
	mov	0x7d0, %r22
	.word 0xdebde000  ! 4359: STDA_I	stda	%r15, [%r23 + 0x0000] %asi
	mov	0x28, %r24
	.word 0x8780204f  ! 4361: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a44400  ! 4362: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0x87802020  ! 4363: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r23
	.word 0xdc8c8400  ! 4365: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0x87802020  ! 4366: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bd2000  ! 4367: STDA_I	stda	%r12, [%r20 + 0x0000] %asi
	.word 0xd2bd04a0  ! 4368: STDA_R	stda	%r9, [%r20 + %r0] 0x25
	.word 0xdcf584a0  ! 4369: STXA_R	stxa	%r14, [%r22 + %r0] 0x25
	mov	0x50, %r27
	.word 0xd696c9e0  ! 4371: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r11
	.word 0xd8a5a000  ! 4372: STWA_I	stwa	%r12, [%r22 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xd8a5a000  ! 4374: STWA_I	stwa	%r12, [%r22 + 0x0000] %asi
	.word 0xd4f74e80  ! 4375: STXA_R	stxa	%r10, [%r29 + %r0] 0x74
	.word 0xdedc8400  ! 4376: LDXA_R	ldxa	[%r18, %r0] 0x20, %r15
	.word 0xd4856000  ! 4377: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r10
	mov	0x60, %r19
	.word 0xd4f56000  ! 4379: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	.word 0xdec689e0  ! 4380: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r15
	.word 0x87802020  ! 4381: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a609e0  ! 4382: STWA_R	stwa	%r9, [%r24 + %r0] 0x4f
	.word 0x87802072  ! 4383: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde846000  ! 4384: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0xde9c2000  ! 4385: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0x87802025  ! 4386: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 4387: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r26
	.word 0xdac70e40  ! 4389: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r13
	.word 0xd6dea000  ! 4390: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r11
	.word 0xdad584a0  ! 4391: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r13
	mov	0x3f0, %r21
	.word 0xdad48400  ! 4393: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0xdcbe6000  ! 4394: STDA_I	stda	%r14, [%r25 + 0x0000] %asi
	.word 0xdcb62000  ! 4395: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	.word 0xd6bd04a0  ! 4396: STDA_R	stda	%r11, [%r20 + %r0] 0x25
	.word 0xdea504a0  ! 4397: STWA_R	stwa	%r15, [%r20 + %r0] 0x25
	mov	0x50, %r25
	.word 0xd6f62000  ! 4399: STXA_I	stxa	%r11, [%r24 + 0x0000] %asi
	mov	0x60, %r18
	.word 0x87802073  ! 4401: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6c74e80  ! 4402: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r11
	.word 0xdcaca000  ! 4403: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xdc8c6000  ! 4404: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r14
	.word 0xd2c689e0  ! 4405: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r9
	.word 0xd0cca000  ! 4406: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	.word 0xd0f46000  ! 4407: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xd69609e0  ! 4408: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r11
	.word 0x87802020  ! 4409: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a504a0  ! 4410: STWA_R	stwa	%r12, [%r20 + %r0] 0x25
	.word 0xdaf56000  ! 4411: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0xda85e000  ! 4413: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	.word 0xd0af0e80  ! 4414: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	mov	0x30, %r26
	.word 0x87802020  ! 4416: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8940400  ! 4417: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	.word 0xd8bc0400  ! 4418: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	mov	0x18, %r25
	mov	0x40, %r18
	.word 0xd2966000  ! 4421: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r9
	.word 0xd4f609e0  ! 4422: STXA_R	stxa	%r10, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 4423: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8f4c400  ! 4424: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xd4bc6000  ! 4425: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xd2d74e80  ! 4426: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r9
	mov	0x68, %r24
	.word 0x87802020  ! 4428: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4429: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2b78e40  ! 4430: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	mov	0x3d8, %r22
	.word 0xd6b40400  ! 4432: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	mov	0x7d0, %r21
	.word 0xdebe49e0  ! 4434: STDA_R	stda	%r15, [%r25 + %r0] 0x4f
	.word 0xdab78e80  ! 4435: STHA_R	stha	%r13, [%r30 + %r0] 0x74
	.word 0x87802025  ! 4436: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca544a0  ! 4437: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0xd6ada000  ! 4438: STBA_I	stba	%r11, [%r22 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xdacfce40  ! 4440: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r13
	.word 0xdeb56000  ! 4441: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	.word 0xd8bf4e40  ! 4442: STDA_R	stda	%r12, [%r29 + %r0] 0x72
	mov	0x38, %r19
	.word 0xd6ac8400  ! 4444: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xd8b5e000  ! 4445: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xd8b5a000  ! 4447: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	mov	0x28, %r24
	mov	0x7f0, %r23
	.word 0x8780204f  ! 4450: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8f4e000  ! 4451: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xdcf48400  ! 4452: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xdccdc4a0  ! 4453: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r14
	.word 0x87802020  ! 4454: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r27
	.word 0x87802074  ! 4456: WRASI_I	wr	%r0, 0x0074, %asi
	wr_tick_cmpr_3_51:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa9, %g2
	or	%g4, 0xe1, %g4
	or	%g6, 0xd1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 4458: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccca000  ! 4459: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	.word 0xdc8ce000  ! 4460: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	.word 0xdccce000  ! 4461: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r14
	mov	0x3d0, %r22
	.word 0xdcbc6000  ! 4463: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xd6bec9e0  ! 4464: STDA_R	stda	%r11, [%r27 + %r0] 0x4f
	.word 0xd8f46000  ! 4465: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xd6f689e0  ! 4466: STXA_R	stxa	%r11, [%r26 + %r0] 0x4f
	mov	0x50, %r25
	.word 0xd0a4a000  ! 4468: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0xd2bc0400  ! 4469: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	mov	0x70, %r17
	.word 0xd6b78e40  ! 4471: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	.word 0x87802074  ! 4472: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4bfce60  ! 4473: STDA_R	stda	%r10, [%r31 + %r0] 0x73
	.word 0xd685e000  ! 4474: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r11
	.word 0x87802072  ! 4475: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc870e60  ! 4476: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r14
	.word 0x8780204f  ! 4477: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r24
	.word 0x8780204f  ! 4479: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a74e60  ! 4480: STWA_R	stwa	%r12, [%r29 + %r0] 0x73
	.word 0x87802025  ! 4481: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaf78e40  ! 4482: STXA_R	stxa	%r13, [%r30 + %r0] 0x72
	mov	0x40, %r26
	.word 0xd2974e40  ! 4484: LDUHA_R	lduha	[%r29, %r0] 0x72, %r9
	.word 0xdcafce40  ! 4485: STBA_R	stba	%r14, [%r31 + %r0] 0x72
	.word 0xd8a609e0  ! 4486: STWA_R	stwa	%r12, [%r24 + %r0] 0x4f
	.word 0xd0bd44a0  ! 4487: STDA_R	stda	%r8, [%r21 + %r0] 0x25
	.word 0xd2ccc400  ! 4488: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	.word 0xd4cfa000  ! 4489: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0xd4bf6000  ! 4490: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd4b72000  ! 4491: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	mov	0x0, %r24
	.word 0xd4f76000  ! 4493: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4b72000  ! 4494: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd68f4e80  ! 4495: LDUBA_R	lduba	[%r29, %r0] 0x74, %r11
	.word 0xdea4c400  ! 4496: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	mov	0x30, %r25
	.word 0xd4d7a000  ! 4498: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	mov	0x3f0, %r20
	.word 0x87802074  ! 4500: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd49ca000  ! 4501: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd4c4a000  ! 4502: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	.word 0xd4c42000  ! 4503: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r10
	.word 0xd4dce000  ! 4504: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	.word 0x87802072  ! 4505: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4afa000  ! 4506: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd8bc8400  ! 4507: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xdc9fa000  ! 4508: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0x87802025  ! 4509: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc9fce60  ! 4510: LDDA_R	ldda	[%r31, %r0] 0x73, %r14
	.word 0xd4a72000  ! 4511: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	mov	0x78, %r26
	ta	T_CHANGE_PRIV	! macro
	mov	0x18, %r25
	.word 0xd4bf4e80  ! 4515: STDA_R	stda	%r10, [%r29 + %r0] 0x74
	.word 0xd2c74e80  ! 4516: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r9
	mov	0x7c8, %r23
	.word 0xd0976000  ! 4518: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0af6000  ! 4519: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	mov	0x50, %r18
	mov	0x0, %r25
	mov	0x60, %r26
	.word 0xd0bf2000  ! 4523: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xd8c40400  ! 4524: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	.word 0xd897ce80  ! 4525: LDUHA_R	lduha	[%r31, %r0] 0x74, %r12
	.word 0x87802025  ! 4526: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdead04a0  ! 4527: STBA_R	stba	%r15, [%r20 + %r0] 0x25
	.word 0xd6976000  ! 4528: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	mov	0x3c0, %r23
	.word 0xd6a76000  ! 4530: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xdece09e0  ! 4531: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r15
	mov	0x7c0, %r22
	.word 0x8780204f  ! 4533: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r17
	mov	0x38, %r17
	mov	0x7c0, %r22
	.word 0xd0d44400  ! 4537: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r8
	.word 0xd8cf2000  ! 4538: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0xd0acc400  ! 4539: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd8cfa000  ! 4540: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0x87802025  ! 4541: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4542: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bd44a0  ! 4543: STDA_R	stda	%r11, [%r21 + %r0] 0x25
	.word 0xdecc8400  ! 4544: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	.word 0xd4ad6000  ! 4545: STBA_I	stba	%r10, [%r21 + 0x0000] %asi
	.word 0xd69fce40  ! 4546: LDDA_R	ldda	[%r31, %r0] 0x72, %r11
	.word 0x87802073  ! 4547: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b62000  ! 4548: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 4549: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_3_52:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xcb, %g2
	or	%g4, 0xd9, %g4
	or	%g6, 0xa4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x8780204f  ! 4551: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r25
	.word 0xd0b62000  ! 4553: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0x87802074  ! 4554: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 4555: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0976000  ! 4556: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0cfe000  ! 4557: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0x87802073  ! 4558: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a76000  ! 4559: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xdc9c8400  ! 4561: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0xdac7a000  ! 4562: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xdaf7a000  ! 4563: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	mov	0x18, %r27
	.word 0xdebc0400  ! 4565: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0xde9cc400  ! 4566: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	.word 0xdedfce60  ! 4567: LDXA_R	ldxa	[%r31, %r0] 0x73, %r15
	.word 0xd2dfa000  ! 4568: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	mov	0x3f8, %r22
	.word 0x87802020  ! 4570: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r17
	.word 0xd49c8400  ! 4572: LDDA_R	ldda	[%r18, %r0] 0x20, %r10
	.word 0x87802074  ! 4573: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0842000  ! 4574: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r8
	mov	0x30, %r19
	.word 0xdacc4400  ! 4576: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	.word 0xd2b7ce60  ! 4577: STHA_R	stha	%r9, [%r31 + %r0] 0x73
	.word 0xd0bd44a0  ! 4578: STDA_R	stda	%r8, [%r21 + %r0] 0x25
	.word 0xdea42000  ! 4579: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xded4e000  ! 4580: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	.word 0xdec4a000  ! 4581: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	mov	0x3f0, %r23
	.word 0xdecce000  ! 4583: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	mov	0x7d8, %r23
	.word 0xd6d7ce40  ! 4585: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r11
	.word 0x87802020  ! 4586: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b78e40  ! 4587: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	.word 0xd8ae2000  ! 4588: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	.word 0xd48cc400  ! 4589: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	.word 0xd0b74e40  ! 4590: STHA_R	stha	%r8, [%r29 + %r0] 0x72
	mov	0x68, %r27
	.word 0xd8ad84a0  ! 4592: STBA_R	stba	%r12, [%r22 + %r0] 0x25
	.word 0xd8b40400  ! 4593: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 4594: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd29fe000  ! 4595: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd2f72000  ! 4596: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	mov	0x8, %r25
	.word 0xd09f0e60  ! 4598: LDDA_R	ldda	[%r28, %r0] 0x73, %r8
	mov	0x8, %r25
	.word 0xdeb70e60  ! 4600: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	mov	0x28, %r19
	.word 0xdcc72000  ! 4602: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	mov	0x7c0, %r22
	.word 0xd4cd84a0  ! 4604: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r10
	mov	0x70, %r16
	mov	0x0, %r17
	.word 0xdabc0400  ! 4607: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0x87802020  ! 4608: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r21
	.word 0xd4a72000  ! 4610: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	mov	0x28, %r16
	.word 0xd4bf2000  ! 4612: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xd4976000  ! 4614: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r10
	.word 0xd4afe000  ! 4615: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	mov	0x18, %r25
	mov	0x8, %r26
	.word 0xd48f6000  ! 4618: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xd4bf6000  ! 4619: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xdc9609e0  ! 4620: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r14
	.word 0xd8bfa000  ! 4621: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	mov	0x7c0, %r21
	.word 0xdc848400  ! 4623: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	mov	0x18, %r16
	.word 0xdca78e40  ! 4625: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	.word 0xdea78e40  ! 4626: STWA_R	stwa	%r15, [%r30 + %r0] 0x72
	.word 0xdca44400  ! 4627: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0xd4b76000  ! 4628: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 4629: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c0, %r21
	.word 0x8780204f  ! 4631: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a70e40  ! 4632: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	.word 0xd08d84a0  ! 4633: LDUBA_R	lduba	[%r22, %r0] 0x25, %r8
	mov	0x7f8, %r23
	.word 0xd8bfe000  ! 4635: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd8bfe000  ! 4636: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	mov	0x7c8, %r23
	.word 0xde8c8400  ! 4638: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	mov	0x3f8, %r20
	mov	0x3f0, %r22
	.word 0xd2876000  ! 4641: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	ta	T_CHANGE_PRIV	! macro
	.word 0xd885c4a0  ! 4643: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r12
	.word 0xd497ce60  ! 4644: LDUHA_R	lduha	[%r31, %r0] 0x73, %r10
	mov	0x7c8, %r23
	mov	0x50, %r18
	mov	0x20, %r16
	.word 0x8780204f  ! 4648: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdcd584a0  ! 4650: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r14
	mov	0x68, %r16
	.word 0x8780204f  ! 4652: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6c44400  ! 4653: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r11
	.word 0xdabe49e0  ! 4654: STDA_R	stda	%r13, [%r25 + %r0] 0x4f
	.word 0xd0ace000  ! 4655: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	mov	0x3d8, %r20
	mov	0x3e0, %r22
	.word 0x87802074  ! 4658: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r16
	.word 0xd0b7e000  ! 4660: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 4661: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b6e000  ! 4662: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	.word 0xd0a6a000  ! 4663: STWA_I	stwa	%r8, [%r26 + 0x0000] %asi
	.word 0xd0d6a000  ! 4664: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r8
	.word 0xdcd40400  ! 4665: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	mov	0x18, %r18
	mov	0x20, %r25
	.word 0x87802020  ! 4668: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b48400  ! 4669: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd0f74e60  ! 4670: STXA_R	stxa	%r8, [%r29 + %r0] 0x73
	.word 0xd6d544a0  ! 4671: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r11
	.word 0xd8c504a0  ! 4672: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r12
	.word 0xd8b76000  ! 4673: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0xd8bf2000  ! 4675: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd8876000  ! 4676: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 4677: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8cd6000  ! 4678: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r12
	.word 0xd8ade000  ! 4679: STBA_I	stba	%r12, [%r23 + 0x0000] %asi
	.word 0xd8bde000  ! 4680: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	mov	0x70, %r26
	.word 0xdec74e60  ! 4682: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r15
	.word 0xd89de000  ! 4683: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4684: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a5c4a0  ! 4685: STWA_R	stwa	%r9, [%r23 + %r0] 0x25
	.word 0x87802025  ! 4686: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e8, %r23
	.word 0xd4d56000  ! 4688: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r10
	mov	0x30, %r19
	.word 0xd0bcc400  ! 4690: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	mov	0x18, %r18
	mov	0x7d8, %r21
	.word 0xd09fce40  ! 4693: LDDA_R	ldda	[%r31, %r0] 0x72, %r8
	mov	0x20, %r18
	.word 0xd2f56000  ! 4695: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 4696: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r20
	.word 0x87802020  ! 4698: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ac2000  ! 4699: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd2a7ce80  ! 4700: STWA_R	stwa	%r9, [%r31 + %r0] 0x74
	mov	0x7f0, %r23
	.word 0x87802025  ! 4702: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 4703: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c8, %r20
	mov	0x10, %r17
	mov	0x8, %r18
	.word 0xdea46000  ! 4707: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	wr_tick_cmpr_3_53:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x94, %g2
	or	%g4, 0xd0, %g4
	or	%g6, 0xa2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdeac2000  ! 4709: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xdea46000  ! 4710: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xd8b70e40  ! 4711: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0x87802020  ! 4712: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b48400  ! 4713: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	mov	0x60, %r27
	mov	0x7f8, %r22
	.word 0xd29ea000  ! 4716: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r9
	.word 0x87802072  ! 4717: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r24
	.word 0x87802025  ! 4719: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 4720: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 4721: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd28e6000  ! 4722: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r9
	mov	0x7c8, %r21
	.word 0xdaa48400  ! 4724: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	mov	0x18, %r27
	.word 0xd8f66000  ! 4726: STXA_I	stxa	%r12, [%r25 + 0x0000] %asi
	.word 0xdebfce40  ! 4727: STDA_R	stda	%r15, [%r31 + %r0] 0x72
	.word 0xd0f584a0  ! 4728: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	mov	0x58, %r27
	mov	0x3c0, %r20
	mov	0x3d0, %r20
	mov	0x38, %r18
	.word 0xdac4c400  ! 4733: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r13
	.word 0xd8be2000  ! 4734: STDA_I	stda	%r12, [%r24 + 0x0000] %asi
	mov	0x40, %r16
	.word 0x87802073  ! 4736: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 4737: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2be89e0  ! 4738: STDA_R	stda	%r9, [%r26 + %r0] 0x4f
	mov	0x3d0, %r23
	mov	0x60, %r26
	.word 0xd08e89e0  ! 4741: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r8
	.word 0x8780204f  ! 4742: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 4743: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8cc6000  ! 4744: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r12
	.word 0xd8aca000  ! 4745: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 4746: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4747: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd68e09e0  ! 4748: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r11
	.word 0xdac70e80  ! 4749: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r13
	.word 0xd0cf2000  ! 4750: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	mov	0x7d8, %r20
	mov	0x68, %r18
	.word 0xdaafce80  ! 4753: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	mov	0x3f8, %r21
	mov	0x38, %r26
	.word 0x87802020  ! 4756: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedf4e40  ! 4757: LDXA_R	ldxa	[%r29, %r0] 0x72, %r15
	.word 0xd0cc0400  ! 4758: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xd8f5a000  ! 4759: STXA_I	stxa	%r12, [%r22 + 0x0000] %asi
	mov	0x40, %r24
	.word 0xd8ae49e0  ! 4761: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0xdaf56000  ! 4762: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	mov	0x7d8, %r21
	mov	0x7f8, %r21
	.word 0x87802073  ! 4765: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdab52000  ! 4766: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	mov	0x0, %r24
	.word 0xdadde000  ! 4768: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r13
	.word 0xdad56000  ! 4769: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r13
	.word 0xdab5a000  ! 4770: STHA_I	stha	%r13, [%r22 + 0x0000] %asi
	.word 0xd69d84a0  ! 4771: LDDA_R	ldda	[%r22, %r0] 0x25, %r11
	mov	0x7d8, %r21
	mov	0x10, %r17
	mov	0x7c8, %r20
	.word 0xd2f56000  ! 4775: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	mov	0x38, %r19
	.word 0xd2a5e000  ! 4777: STWA_I	stwa	%r9, [%r23 + 0x0000] %asi
	.word 0xd2a52000  ! 4778: STWA_I	stwa	%r9, [%r20 + 0x0000] %asi
	.word 0xd2cde000  ! 4779: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r9
	.word 0x87802025  ! 4780: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d0, %r21
	mov	0x8, %r18
	mov	0x20, %r17
	mov	0x48, %r17
	.word 0x87802073  ! 4785: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdedcc400  ! 4786: LDXA_R	ldxa	[%r19, %r0] 0x20, %r15
	.word 0xdc87ce80  ! 4787: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r14
	.word 0x87802020  ! 4788: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r27
	.word 0xd8d4e000  ! 4790: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0xd8cc4400  ! 4791: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r12
	.word 0xd6c5c4a0  ! 4792: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r11
	.word 0xd6f544a0  ! 4793: STXA_R	stxa	%r11, [%r21 + %r0] 0x25
	mov	0x38, %r24
	.word 0x87802072  ! 4795: WRASI_I	wr	%r0, 0x0072, %asi
	wr_tick_cmpr_3_54:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x8d, %g2
	or	%g4, 0xc3, %g4
	or	%g6, 0xb0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x28, %r25
	mov	0x7f0, %r23
	.word 0xd2afe000  ! 4799: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd2bf2000  ! 4800: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd2afa000  ! 4801: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 4802: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 4803: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r26
	.word 0xd2f7a000  ! 4805: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	mov	0x30, %r24
	.word 0x87802025  ! 4807: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd297e000  ! 4808: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	.word 0xd2d7a000  ! 4809: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0x87802074  ! 4810: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 4811: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2a7a000  ! 4812: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xd8af0e60  ! 4813: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	.word 0xd0dfa000  ! 4814: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0876000  ! 4815: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0b5c4a0  ! 4816: STHA_R	stha	%r8, [%r23 + %r0] 0x25
	.word 0xdec70e60  ! 4817: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r15
	.word 0xdaaf8e60  ! 4818: STBA_R	stba	%r13, [%r30 + %r0] 0x73
	.word 0xdeaf8e60  ! 4819: STBA_R	stba	%r15, [%r30 + %r0] 0x73
	.word 0xdc9fa000  ! 4820: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 4821: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b609e0  ! 4822: STHA_R	stha	%r12, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 4823: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d0, %r23
	.word 0xd2cec9e0  ! 4825: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r9
	.word 0x87802025  ! 4826: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4827: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dc6000  ! 4828: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r9
	.word 0xd28c2000  ! 4829: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xd8f7ce40  ! 4830: STXA_R	stxa	%r12, [%r31 + %r0] 0x72
	.word 0xde846000  ! 4831: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0xdec4a000  ! 4832: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	mov	0x28, %r24
	.word 0x87802025  ! 4834: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c0, %r22
	mov	0x10, %r27
	mov	0x28, %r17
	.word 0xdaaf8e60  ! 4838: STBA_R	stba	%r13, [%r30 + %r0] 0x73
	.word 0xdcdee000  ! 4839: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r14
	.word 0xd0cf4e80  ! 4840: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r8
	.word 0xdcdc4400  ! 4841: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	.word 0xd8b40400  ! 4842: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xde8e49e0  ! 4843: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r15
	.word 0xd6b70e80  ! 4844: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	.word 0x87802020  ! 4845: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbfa000  ! 4846: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	mov	0x40, %r17
	.word 0x87802072  ! 4848: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2974e60  ! 4849: LDUHA_R	lduha	[%r29, %r0] 0x73, %r9
	mov	0x3c0, %r22
	.word 0x87802072  ! 4851: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f74e60  ! 4852: STXA_R	stxa	%r11, [%r29 + %r0] 0x73
	.word 0xdcf78e60  ! 4853: STXA_R	stxa	%r14, [%r30 + %r0] 0x73
	.word 0xd8c78e40  ! 4854: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r12
	mov	0x38, %r26
	.word 0xdab72000  ! 4856: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 4857: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcae09e0  ! 4858: STBA_R	stba	%r14, [%r24 + %r0] 0x4f
	.word 0xded72000  ! 4859: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xdebf2000  ! 4860: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	mov	0x28, %r24
	.word 0xdea7e000  ! 4862: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	mov	0x7d0, %r23
	mov	0x7c0, %r22
	wr_tick_cmpr_3_55:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x8a, %g2
	or	%g4, 0xcb, %g4
	or	%g6, 0xc3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802072  ! 4866: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc84c400  ! 4867: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	.word 0xd6bdc4a0  ! 4868: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	.word 0x8780204f  ! 4869: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f8, %r22
	.word 0xd8f7a000  ! 4871: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8bf2000  ! 4872: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	mov	0x7e0, %r22
	mov	0x7c8, %r23
	mov	0x50, %r18
	.word 0xd8bfe000  ! 4876: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xdabf8e40  ! 4877: STDA_R	stda	%r13, [%r30 + %r0] 0x72
	mov	0x10, %r26
	.word 0x87802072  ! 4879: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdec72000  ! 4880: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xdeafe000  ! 4881: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 4882: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebe6000  ! 4883: STDA_I	stda	%r15, [%r25 + 0x0000] %asi
	wr_tick_cmpr_3_56:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xa2, %g2
	or	%g4, 0xe0, %g4
	or	%g6, 0xe8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7c0, %r22
	.word 0xd6dc4400  ! 4886: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xd6bf8e40  ! 4887: STDA_R	stda	%r11, [%r30 + %r0] 0x72
	mov	0x7c0, %r21
	.word 0x87802020  ! 4889: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a72000  ! 4890: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4b72000  ! 4891: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	mov	0x48, %r27
	.word 0x8780204f  ! 4893: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b78e60  ! 4894: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	.word 0xdcb42000  ! 4895: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xdcd40400  ! 4896: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	.word 0xdea584a0  ! 4897: STWA_R	stwa	%r15, [%r22 + %r0] 0x25
	.word 0xd29c2000  ! 4898: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	mov	0x68, %r25
	.word 0xd2d4a000  ! 4900: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	.word 0xd0af0e80  ! 4901: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	mov	0x0, %r24
	.word 0x87802073  ! 4903: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f46000  ! 4904: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xd6c40400  ! 4905: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r11
	.word 0x87802073  ! 4906: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4907: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4908: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc870e40  ! 4909: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r14
	.word 0xdaf70e40  ! 4910: STXA_R	stxa	%r13, [%r28 + %r0] 0x72
	.word 0xd68da000  ! 4911: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r11
	.word 0xd6bd2000  ! 4912: STDA_I	stda	%r11, [%r20 + 0x0000] %asi
	.word 0xd6ad2000  ! 4913: STBA_I	stba	%r11, [%r20 + 0x0000] %asi
	.word 0xd6b5a000  ! 4914: STHA_I	stha	%r11, [%r22 + 0x0000] %asi
	.word 0xd6d52000  ! 4915: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r11
	.word 0xd48649e0  ! 4916: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r10
	mov	0x7e0, %r21
	mov	0x28, %r18
	.word 0x87802025  ! 4919: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r18
	mov	0x8, %r17
	.word 0xd29ce000  ! 4922: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0x87802072  ! 4923: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca544a0  ! 4924: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0xd49e2000  ! 4925: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 4926: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r17
	mov	0x18, %r25
	mov	0x7c0, %r23
	.word 0xd4aca000  ! 4930: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0xd6a48400  ! 4931: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0xd885c4a0  ! 4932: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r12
	.word 0xded4a000  ! 4933: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	mov	0x7c8, %r23
	.word 0xdedca000  ! 4935: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xdebca000  ! 4936: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 4937: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebc2000  ! 4938: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xd4b504a0  ! 4939: STHA_R	stha	%r10, [%r20 + %r0] 0x25
	.word 0xdeb40400  ! 4940: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0x87802074  ! 4941: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b74e40  ! 4942: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	mov	0x68, %r24
	.word 0x87802020  ! 4944: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f48400  ! 4945: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xdad7a000  ! 4946: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	mov	0x68, %r27
	.word 0xda9fa000  ! 4948: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xdebc0400  ! 4949: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0x87802072  ! 4950: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 4951: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcafce40  ! 4952: STBA_R	stba	%r14, [%r31 + %r0] 0x72
	.word 0xdcbc4400  ! 4953: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0x87802025  ! 4954: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bfa000  ! 4955: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 4956: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2c649e0  ! 4957: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r9
	.word 0xde8fce60  ! 4958: LDUBA_R	lduba	[%r31, %r0] 0x73, %r15
	mov	0x7f8, %r21
	wr_tick_cmpr_3_57:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xde, %g2
	or	%g4, 0xc6, %g4
	or	%g6, 0xda, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x40, %r18
	.word 0xd6856000  ! 4962: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r11
	.word 0xd695e000  ! 4963: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r11
	.word 0xd6dd6000  ! 4964: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r11
	mov	0x30, %r26
	.word 0xd6bd6000  ! 4966: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0xd6a52000  ! 4967: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	.word 0xd6bf0e80  ! 4968: STDA_R	stda	%r11, [%r28 + %r0] 0x74
	mov	0x7c8, %r21
	.word 0xdab56000  ! 4970: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	.word 0xded48400  ! 4971: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	.word 0xdab5e000  ! 4972: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0xd6ac8400  ! 4973: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	mov	0x8, %r19
	.word 0xd2ac4400  ! 4975: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xd6ce09e0  ! 4976: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r11
	.word 0xd2b5e000  ! 4977: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	.word 0xd2b56000  ! 4978: STHA_I	stha	%r9, [%r21 + 0x0000] %asi
	.word 0xd2a5a000  ! 4979: STWA_I	stwa	%r9, [%r22 + 0x0000] %asi
	.word 0x87802073  ! 4980: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd09504a0  ! 4981: LDUHA_R	lduha	[%r20, %r0] 0x25, %r8
	.word 0xd6cc8400  ! 4982: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	.word 0xd885e000  ! 4983: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r12
	.word 0xd895e000  ! 4984: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4985: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d4a000  ! 4986: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xda9f8e40  ! 4987: LDDA_R	ldda	[%r30, %r0] 0x72, %r13
	.word 0xd0b48400  ! 4988: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xd8cf4e40  ! 4989: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r12
	.word 0xd2a4a000  ! 4990: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	mov	0x7d8, %r23
	mov	0x7d0, %r22
	.word 0xd8be49e0  ! 4993: STDA_R	stda	%r12, [%r25 + %r0] 0x4f
	.word 0xd297ce60  ! 4994: LDUHA_R	lduha	[%r31, %r0] 0x73, %r9
	.word 0xd6dca000  ! 4995: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r11
	.word 0xdeb649e0  ! 4996: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	.word 0xd6d44400  ! 4997: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r11
	mov	0x70, %r24
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_2:
	mov	0x48, %r25
	mov	0x10, %r25
	.word 0xd09f8e60  ! 3: LDDA_R	ldda	[%r30, %r0] 0x73, %r8
	.word 0x87802073  ! 4: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r25
	mov	0x10, %r17
	.word 0x87802074  ! 7: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d0, %r20
	.word 0xdacf0e60  ! 9: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r13
	.word 0xdedc2000  ! 10: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r15
	.word 0xd28c0400  ! 11: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	mov	0x50, %r18
	.word 0xd4f7ce60  ! 13: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	.word 0xd0ace000  ! 14: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0xd89e09e0  ! 15: LDDA_R	ldda	[%r24, %r0] 0x4f, %r12
	.word 0x87802020  ! 16: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r19
	.word 0xdc9d44a0  ! 18: LDDA_R	ldda	[%r21, %r0] 0x25, %r14
	.word 0x87802020  ! 19: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d78e60  ! 20: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r10
	.word 0xd0b5e000  ! 21: STHA_I	stha	%r8, [%r23 + 0x0000] %asi
	.word 0xd8f70e60  ! 22: STXA_R	stxa	%r12, [%r28 + %r0] 0x73
	.word 0xd4f56000  ! 23: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	.word 0xd4a5a000  ! 24: STWA_I	stwa	%r10, [%r22 + 0x0000] %asi
	.word 0x87802073  ! 25: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b76000  ! 26: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	mov	0x70, %r18
	.word 0xd8f40400  ! 28: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xd6f7e000  ! 29: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xdadd84a0  ! 30: LDXA_R	ldxa	[%r22, %r0] 0x25, %r13
	.word 0xd8876000  ! 31: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0xd2870e40  ! 32: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r9
	.word 0xd2f74e80  ! 33: STXA_R	stxa	%r9, [%r29 + %r0] 0x74
	.word 0xdedf6000  ! 34: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xd6df8e60  ! 35: LDXA_R	ldxa	[%r30, %r0] 0x73, %r11
	mov	0x28, %r17
	.word 0xd4972000  ! 37: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0xd49fa000  ! 38: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0xd4a7e000  ! 39: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	mov	0x60, %r18
	.word 0xdcd7ce80  ! 41: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r14
	.word 0xd6c7ce60  ! 42: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r11
	.word 0xd48f2000  ! 43: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0x87802025  ! 44: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e0, %r22
	.word 0xd49ca000  ! 46: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd4b4a000  ! 47: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0xd4d74e80  ! 48: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r10
	mov	0x3d0, %r22
	.word 0xd28ce000  ! 50: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	.word 0xd0b70e40  ! 51: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	mov	0x38, %r17
	.word 0xd4d74e60  ! 53: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r10
	.word 0xd8dcc400  ! 54: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	mov	0x7d0, %r23
	wr_tick_cmpr_2_0:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xee, %g2
	or	%g4, 0xd0, %g4
	or	%g6, 0xde, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	wr_tick_cmpr_2_1:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xfe, %g2
	or	%g4, 0xfd, %g4
	or	%g6, 0xb5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 58: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d56000  ! 59: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r10
	.word 0xd4ad2000  ! 60: STBA_I	stba	%r10, [%r20 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xd49ec9e0  ! 62: LDDA_R	ldda	[%r27, %r0] 0x4f, %r10
	.word 0xdedfce80  ! 63: LDXA_R	ldxa	[%r31, %r0] 0x74, %r15
	.word 0xd0b5a000  ! 64: STHA_I	stha	%r8, [%r22 + 0x0000] %asi
	mov	0x7c8, %r21
	.word 0xd0bd6000  ! 66: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 67: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4d6c9e0  ! 68: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r10
	.word 0xd0cd84a0  ! 69: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r8
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802073  ! 71: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4ae2000  ! 72: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	.word 0xd48ee000  ! 73: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 74: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4cf6000  ! 75: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	mov	0x7e8, %r22
	.word 0xdcb78e40  ! 77: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xd0af4e80  ! 78: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	.word 0xdca74e40  ! 79: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	.word 0xd687e000  ! 80: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0x87802073  ! 81: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0870e40  ! 82: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r8
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x8780204f  ! 84: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda96e000  ! 85: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r13
	.word 0xd2f504a0  ! 86: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	mov	0x7d0, %r22
	mov	0x8, %r25
	.word 0x87802074  ! 89: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f7e000  ! 90: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd0b70e80  ! 91: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	.word 0xdca4c400  ! 92: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xd6c7e000  ! 93: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0x87802020  ! 94: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 95: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd29e89e0  ! 96: LDDA_R	ldda	[%r26, %r0] 0x4f, %r9
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0cca000  ! 98: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	.word 0xd4ce49e0  ! 99: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r10
	.word 0xd0d4e000  ! 100: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	mov	0x78, %r27
	.word 0x87802072  ! 102: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8cf0e60  ! 103: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r12
	.word 0xdcdf8e60  ! 104: LDXA_R	ldxa	[%r30, %r0] 0x73, %r14
	.word 0xdc8c4400  ! 105: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0xdc84e000  ! 106: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r14
	mov	0x30, %r18
	.word 0xdcbce000  ! 108: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 109: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2dd84a0  ! 110: LDXA_R	ldxa	[%r22, %r0] 0x25, %r9
	mov	0x20, %r16
	.word 0x8780204f  ! 112: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdad4e000  ! 113: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r13
	.word 0xdcac8400  ! 114: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0x87802072  ! 115: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a48400  ! 116: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	.word 0x87802020  ! 117: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebca000  ! 118: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xdcb584a0  ! 119: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	mov	0x38, %r27
	.word 0xd4af8e80  ! 121: STBA_R	stba	%r10, [%r30 + %r0] 0x74
	.word 0xdcbc6000  ! 122: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 123: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r16
	.word 0xdcdd6000  ! 125: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r14
	mov	0x50, %r27
	.word 0xd8d544a0  ! 127: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r12
	.word 0x87802025  ! 128: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0974e80  ! 129: LDUHA_R	lduha	[%r29, %r0] 0x74, %r8
	.word 0xd4a4e000  ! 130: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	mov	0x28, %r16
	.word 0xd8f74e60  ! 132: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	mov	0x68, %r19
	.word 0xd2cce000  ! 134: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	mov	0x7d8, %r23
	.word 0xd28ca000  ! 136: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0xdebf4e80  ! 137: STDA_R	stda	%r15, [%r29 + %r0] 0x74
	.word 0xdab42000  ! 138: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xdab4e000  ! 140: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xd0f48400  ! 141: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xd2f46000  ! 142: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 143: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 144: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2cc2000  ! 145: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r9
	.word 0xdedf4e80  ! 146: LDXA_R	ldxa	[%r29, %r0] 0x74, %r15
	.word 0xdca46000  ! 147: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 148: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcac2000  ! 149: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	mov	0x7d0, %r22
	.word 0xd0c4c400  ! 151: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	.word 0x87802020  ! 152: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28dc4a0  ! 153: LDUBA_R	lduba	[%r23, %r0] 0x25, %r9
	.word 0xdab42000  ! 154: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xdabc6000  ! 155: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xdaa4a000  ! 156: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xde8c8400  ! 157: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	.word 0xd2ace000  ! 158: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0xda9fce60  ! 159: LDDA_R	ldda	[%r31, %r0] 0x73, %r13
	.word 0xd4ae09e0  ! 160: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0xd4d7ce40  ! 161: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r10
	.word 0xd0cc2000  ! 162: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	.word 0xd084e000  ! 163: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	.word 0xd0942000  ! 164: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r8
	.word 0xd8de09e0  ! 165: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r12
	.word 0x87802020  ! 166: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f609e0  ! 167: STXA_R	stxa	%r9, [%r24 + %r0] 0x4f
	.word 0xd68d2000  ! 168: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r11
	.word 0x87802025  ! 169: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdacc0400  ! 170: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r13
	mov	0x3d8, %r21
	.word 0x87802025  ! 172: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r27
	.word 0x8780204f  ! 174: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8c7ce80  ! 175: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r12
	.word 0xd48c6000  ! 176: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r10
	.word 0xdec544a0  ! 177: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r15
	.word 0x87802072  ! 178: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdadc6000  ! 179: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xd88c0400  ! 180: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	mov	0x0, %r18
	.word 0xd2f4e000  ! 182: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd6ce49e0  ! 183: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r11
	.word 0x87802020  ! 184: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bf8e80  ! 185: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	mov	0x58, %r27
	.word 0x87802025  ! 187: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 188: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 189: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 190: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d70e80  ! 191: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r10
	.word 0xd6f76000  ! 192: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6dfa000  ! 193: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6bfe000  ! 194: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd6bf2000  ! 195: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 196: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 197: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdad70e80  ! 198: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r13
	.word 0xdcb62000  ! 199: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	.word 0xd8d6c9e0  ! 200: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r12
	mov	0x70, %r19
	.word 0xd0acc400  ! 202: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	mov	0x3f8, %r23
	mov	0x30, %r24
	.word 0x87802025  ! 205: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 206: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad66000  ! 207: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r13
	.word 0xdabee000  ! 208: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	.word 0xd0b649e0  ! 209: STHA_R	stha	%r8, [%r25 + %r0] 0x4f
	.word 0xdaaea000  ! 210: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	mov	0x3e8, %r23
	.word 0xdab62000  ! 212: STHA_I	stha	%r13, [%r24 + 0x0000] %asi
	mov	0x18, %r18
	.word 0xd6bf0e80  ! 214: STDA_R	stda	%r11, [%r28 + %r0] 0x74
	.word 0xd29f4e40  ! 215: LDDA_R	ldda	[%r29, %r0] 0x72, %r9
	.word 0xd4a504a0  ! 216: STWA_R	stwa	%r10, [%r20 + %r0] 0x25
	mov	0x70, %r19
	mov	0x7e8, %r22
	.word 0x87802020  ! 219: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8f4e60  ! 220: LDUBA_R	lduba	[%r29, %r0] 0x73, %r15
	.word 0xd2d72000  ! 221: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xd48fce40  ! 222: LDUBA_R	lduba	[%r31, %r0] 0x72, %r10
	.word 0xdcdf6000  ! 223: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	mov	0x40, %r25
	mov	0x8, %r17
	.word 0x8780204f  ! 226: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8d78e80  ! 227: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r12
	.word 0xd0a70e60  ! 228: STWA_R	stwa	%r8, [%r28 + %r0] 0x73
	mov	0x70, %r25
	.word 0x87802025  ! 230: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcac2000  ! 231: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0xdcd6c9e0  ! 232: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r14
	.word 0xd69f8e40  ! 233: LDDA_R	ldda	[%r30, %r0] 0x72, %r11
	.word 0xd2f46000  ! 234: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd0bd44a0  ! 235: STDA_R	stda	%r8, [%r21 + %r0] 0x25
	.word 0x87802073  ! 236: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc8c8400  ! 237: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0xd4ae89e0  ! 238: STBA_R	stba	%r10, [%r26 + %r0] 0x4f
	.word 0xdc97e000  ! 239: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xdc9f2000  ! 240: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xdcafe000  ! 241: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0x87802020  ! 243: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc86a000  ! 244: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r14
	.word 0xd2f7ce80  ! 245: STXA_R	stxa	%r9, [%r31 + %r0] 0x74
	.word 0x8780204f  ! 246: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r26
	mov	0x7d0, %r22
	mov	0x70, %r19
	.word 0xdccc6000  ! 250: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	.word 0xd4a74e40  ! 251: STWA_R	stwa	%r10, [%r29 + %r0] 0x72
	.word 0x87802072  ! 252: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda9d84a0  ! 253: LDDA_R	ldda	[%r22, %r0] 0x25, %r13
	.word 0xde870e80  ! 254: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r15
	.word 0xdc846000  ! 255: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	mov	0x0, %r25
	mov	0x28, %r25
	.word 0xdc8ca000  ! 258: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r14
	.word 0xdcd4a000  ! 259: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	.word 0xd6c70e60  ! 260: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r11
	.word 0xd8cce000  ! 261: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r12
	.word 0xd8de49e0  ! 262: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r12
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802020  ! 264: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef52000  ! 265: STXA_I	stxa	%r15, [%r20 + 0x0000] %asi
	.word 0xdec56000  ! 266: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r15
	.word 0xde956000  ! 267: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r15
	.word 0xdeb5a000  ! 268: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	.word 0xd69c4400  ! 269: LDDA_R	ldda	[%r17, %r0] 0x20, %r11
	.word 0xd6dd6000  ! 270: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r11
	.word 0xd6ad6000  ! 271: STBA_I	stba	%r11, [%r21 + 0x0000] %asi
	.word 0xd6a56000  ! 272: STWA_I	stwa	%r11, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 273: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd69f6000  ! 274: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	mov	0x40, %r26
	.word 0x87802020  ! 276: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcaf0e40  ! 277: STBA_R	stba	%r14, [%r28 + %r0] 0x72
	.word 0xd88504a0  ! 278: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r12
	.word 0xda84a000  ! 279: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	mov	0x58, %r16
	mov	0x70, %r18
	.word 0x87802073  ! 282: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6a609e0  ! 283: STWA_R	stwa	%r11, [%r24 + %r0] 0x4f
	.word 0xdebc2000  ! 284: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xd6d40400  ! 285: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	.word 0x87802074  ! 286: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc8e09e0  ! 287: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r14
	.word 0xdacf4e80  ! 288: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r13
	.word 0xd6ad04a0  ! 289: STBA_R	stba	%r11, [%r20 + %r0] 0x25
	mov	0x68, %r18
	.word 0xdea52000  ! 291: STWA_I	stwa	%r15, [%r20 + 0x0000] %asi
	.word 0xd2bf8e80  ! 292: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	.word 0xded689e0  ! 293: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r15
	.word 0xd4df4e80  ! 294: LDXA_R	ldxa	[%r29, %r0] 0x74, %r10
	.word 0x87802020  ! 295: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cce000  ! 296: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	mov	0x7d8, %r22
	mov	0x40, %r17
	.word 0xd4c74e40  ! 299: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r10
	.word 0xda9504a0  ! 300: LDUHA_R	lduha	[%r20, %r0] 0x25, %r13
	.word 0xdcb78e60  ! 301: STHA_R	stha	%r14, [%r30 + %r0] 0x73
	.word 0xd49c2000  ! 302: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 303: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4aca000  ! 304: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 305: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a7e000  ! 306: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 307: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4dfe000  ! 308: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd2b7ce40  ! 309: STHA_R	stha	%r9, [%r31 + %r0] 0x72
	mov	0x50, %r16
	mov	0x58, %r26
	.word 0x8780204f  ! 312: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 313: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 314: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09d84a0  ! 315: LDDA_R	ldda	[%r22, %r0] 0x25, %r8
	mov	0x7c0, %r20
	wr_tick_cmpr_2_2:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf8, %g2
	or	%g4, 0xde, %g4
	or	%g6, 0xfd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x68, %r18
	.word 0x87802073  ! 319: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8bc0400  ! 320: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	mov	0x40, %r27
	mov	0x3f0, %r23
	mov	0x7e8, %r23
	mov	0x18, %r24
	.word 0xdecee000  ! 325: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r15
	.word 0xd695c4a0  ! 326: LDUHA_R	lduha	[%r23, %r0] 0x25, %r11
	wr_tick_cmpr_2_3:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xeb, %g2
	or	%g4, 0xb2, %g4
	or	%g6, 0xac, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x50, %r18
	.word 0xd6c6a000  ! 329: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r11
	mov	0x0, %r19
	mov	0x0, %r27
	.word 0xd6d6a000  ! 332: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r11
	mov	0x40, %r18
	.word 0x87802074  ! 334: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6ad6000  ! 335: STBA_I	stba	%r11, [%r21 + 0x0000] %asi
	.word 0xdac4c400  ! 336: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r13
	.word 0xdcd5a000  ! 337: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r14
	mov	0x58, %r26
	.word 0xdcaf8e60  ! 339: STBA_R	stba	%r14, [%r30 + %r0] 0x73
	mov	0x48, %r25
	.word 0x87802020  ! 341: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r17
	.word 0xdef7ce60  ! 343: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0xd4f42000  ! 344: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd4b70e60  ! 345: STHA_R	stha	%r10, [%r28 + %r0] 0x73
	mov	0x10, %r24
	.word 0x87802020  ! 347: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 348: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b5a000  ! 349: STHA_I	stha	%r10, [%r22 + 0x0000] %asi
	.word 0xdebe09e0  ! 350: STDA_R	stda	%r15, [%r24 + %r0] 0x4f
	.word 0xded4c400  ! 351: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r15
	mov	0x78, %r26
	.word 0x8780204f  ! 353: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde96c9e0  ! 354: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r15
	mov	0x60, %r16
	mov	0x38, %r27
	.word 0xd0a76000  ! 357: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xdccf4e40  ! 358: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r14
	.word 0xdaf76000  ! 359: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdaaf2000  ! 360: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xd094c400  ! 361: LDUHA_R	lduha	[%r19, %r0] 0x20, %r8
	.word 0xdcdfe000  ! 362: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	wr_tick_cmpr_2_4:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x9b, %g2
	or	%g4, 0xab, %g4
	or	%g6, 0x8f, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x28, %r18
	.word 0xd4d48400  ! 365: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	.word 0xd0f70e40  ! 366: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	mov	0x58, %r16
	mov	0x38, %r16
	.word 0x8780204f  ! 369: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd286e000  ! 370: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r9
	.word 0xd2c62000  ! 371: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r9
	.word 0xd2962000  ! 372: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r9
	.word 0xd2de2000  ! 373: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r9
	.word 0xd2f62000  ! 374: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	mov	0x0, %r18
	.word 0xdab40400  ! 376: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	mov	0x8, %r16
	.word 0x87802073  ! 378: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb5a000  ! 379: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	mov	0x70, %r27
	.word 0x87802025  ! 381: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b4c400  ! 382: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0x87802025  ! 383: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4c6c9e0  ! 384: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r10
	.word 0x87802073  ! 385: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef7ce60  ! 386: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0xd2d44400  ! 387: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r9
	.word 0xd0840400  ! 388: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	mov	0x50, %r24
	.word 0x8780204f  ! 390: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x3c8, %r21
	.word 0x87802074  ! 393: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 394: WRASI_I	wr	%r0, 0x0025, %asi
	wr_tick_cmpr_2_5:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x9d, %g2
	or	%g4, 0xc9, %g4
	or	%g6, 0xa2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0dee000  ! 396: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r8
	.word 0xd0f62000  ! 397: STXA_I	stxa	%r8, [%r24 + 0x0000] %asi
	.word 0x87802073  ! 398: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r18
	mov	0x7f0, %r21
	mov	0x40, %r26
	.word 0xd4c689e0  ! 402: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r10
	.word 0xd4af6000  ! 403: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd4b7a000  ! 404: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	mov	0x30, %r26
	.word 0x87802020  ! 406: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 407: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd49fe000  ! 408: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd6a78e80  ! 409: STWA_R	stwa	%r11, [%r30 + %r0] 0x74
	.word 0xd8cfe000  ! 410: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8cf2000  ! 411: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	mov	0x60, %r16
	.word 0xd0bf8e80  ! 413: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	.word 0xd49649e0  ! 414: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r10
	.word 0xd2f70e40  ! 415: STXA_R	stxa	%r9, [%r28 + %r0] 0x72
	.word 0xd2f48400  ! 416: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	mov	0x78, %r25
	.word 0xdecf6000  ! 418: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	mov	0x58, %r25
	.word 0xd0a5c4a0  ! 420: STWA_R	stwa	%r8, [%r23 + %r0] 0x25
	.word 0xdc870e80  ! 421: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r14
	.word 0x8780204f  ! 422: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0c5e000  ! 423: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r8
	.word 0xd0f56000  ! 424: STXA_I	stxa	%r8, [%r21 + 0x0000] %asi
	.word 0xd0d56000  ! 425: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r8
	.word 0x87802074  ! 426: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d8, %r23
	mov	0x48, %r19
	.word 0xd09c8400  ! 429: LDDA_R	ldda	[%r18, %r0] 0x20, %r8
	mov	0x8, %r16
	.word 0xd2a70e40  ! 431: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	.word 0xda8ce000  ! 432: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	.word 0xdadc6000  ! 433: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	mov	0x70, %r19
	.word 0x87802025  ! 435: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb689e0  ! 436: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	ta	T_CHANGE_NONHPRIV	! macro
	wr_tick_cmpr_2_6:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xfc, %g2
	or	%g4, 0xa4, %g4
	or	%g6, 0xe3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802025  ! 439: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2c46000  ! 440: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	mov	0x40, %r25
	mov	0x3d0, %r21
	.word 0xd284a000  ! 443: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	mov	0x78, %r25
	.word 0x87802074  ! 445: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2a7e000  ! 446: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xd8cf4e60  ! 447: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r12
	.word 0xda874e40  ! 448: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r13
	.word 0xdef7a000  ! 449: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdedfe000  ! 450: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	mov	0x38, %r18
	.word 0x87802072  ! 452: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 453: WRASI_I	wr	%r0, 0x0073, %asi
	wr_tick_cmpr_2_7:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xd5, %g2
	or	%g4, 0xa6, %g4
	or	%g6, 0xef, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdef46000  ! 455: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xdc9c4400  ! 456: LDDA_R	ldda	[%r17, %r0] 0x20, %r14
	.word 0xdea544a0  ! 457: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	.word 0xd4a46000  ! 458: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	mov	0x40, %r17
	.word 0xd4d4e000  ! 460: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0x87802074  ! 461: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef78e80  ! 462: STXA_R	stxa	%r15, [%r30 + %r0] 0x74
	wr_tick_cmpr_2_8:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd0, %g2
	or	%g4, 0xf6, %g4
	or	%g6, 0xf2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x8, %r17
	.word 0x87802020  ! 465: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebfce40  ! 466: STDA_R	stda	%r15, [%r31 + %r0] 0x72
	.word 0xd6a4a000  ! 467: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 468: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r21
	.word 0xd2a40400  ! 470: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xd2d62000  ! 471: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r9
	.word 0x87802073  ! 472: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 473: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4d4c400  ! 474: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0xdaf6c9e0  ! 475: STXA_R	stxa	%r13, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 476: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cf2000  ! 477: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	mov	0x70, %r17
	.word 0xd68fa000  ! 479: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0xd697e000  ! 480: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	mov	0x30, %r16
	.word 0xd6b7a000  ! 482: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 483: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6a46000  ! 484: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0xd6af8e80  ! 485: STBA_R	stba	%r11, [%r30 + %r0] 0x74
	mov	0x0, %r16
	mov	0x48, %r18
	.word 0xdea70e60  ! 488: STWA_R	stwa	%r15, [%r28 + %r0] 0x73
	.word 0xde8f8e40  ! 489: LDUBA_R	lduba	[%r30, %r0] 0x72, %r15
	wr_tick_cmpr_2_9:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x8a, %g2
	or	%g4, 0xc7, %g4
	or	%g6, 0xb6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdcac8400  ! 491: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	mov	0x20, %r19
	mov	0x58, %r17
	.word 0x87802074  ! 494: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6876000  ! 495: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6b72000  ! 496: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xde8f4e80  ! 497: LDUBA_R	lduba	[%r29, %r0] 0x74, %r15
	.word 0xd2840400  ! 498: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r9
	mov	0x7f8, %r22
	.word 0x87802074  ! 500: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 501: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd087e000  ! 502: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0xdcd4c400  ! 503: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	mov	0x3e0, %r22
	.word 0xdeb70e60  ! 505: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	.word 0xdcaf6000  ! 506: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdcf72000  ! 507: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	mov	0x3e8, %r23
	.word 0xdccfa000  ! 509: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	mov	0x3f8, %r21
	.word 0xdcd76000  ! 511: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	.word 0xdcf7e000  ! 512: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcd76000  ! 513: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	mov	0x28, %r26
	.word 0xdca7e000  ! 515: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdc8f2000  ! 516: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	mov	0x78, %r16
	.word 0xdcb7a000  ! 518: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 519: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcd4a000  ! 520: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	.word 0xdcb42000  ! 521: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xda9f0e40  ! 522: LDDA_R	ldda	[%r28, %r0] 0x72, %r13
	.word 0xd8f689e0  ! 523: STXA_R	stxa	%r12, [%r26 + %r0] 0x4f
	.word 0xd2dfce80  ! 524: LDXA_R	ldxa	[%r31, %r0] 0x74, %r9
	.word 0xd4f4a000  ! 525: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xde8584a0  ! 527: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r15
	.word 0xd6af4e80  ! 528: STBA_R	stba	%r11, [%r29 + %r0] 0x74
	.word 0xdacc2000  ! 529: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xdadc2000  ! 530: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r13
	.word 0xd48c0400  ! 531: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	wr_tick_cmpr_2_10:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x9d, %g2
	or	%g4, 0xa8, %g4
	or	%g6, 0xcf, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3f8, %r22
	.word 0xd6afce40  ! 534: STBA_R	stba	%r11, [%r31 + %r0] 0x72
	.word 0xdaa4e000  ! 535: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0xdaa649e0  ! 536: STWA_R	stwa	%r13, [%r25 + %r0] 0x4f
	.word 0xd2dc6000  ! 537: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r9
	.word 0x87802020  ! 538: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f72000  ! 539: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	mov	0x28, %r18
	mov	0x0, %r18
	.word 0xd2dfe000  ! 542: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0xd6bd44a0  ! 543: STDA_R	stda	%r11, [%r21 + %r0] 0x25
	mov	0x20, %r26
	.word 0xd69f6000  ! 545: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	.word 0xd0de89e0  ! 546: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r8
	.word 0xd0978e40  ! 547: LDUHA_R	lduha	[%r30, %r0] 0x72, %r8
	.word 0xd6af0e60  ! 548: STBA_R	stba	%r11, [%r28 + %r0] 0x73
	.word 0xdebd84a0  ! 549: STDA_R	stda	%r15, [%r22 + %r0] 0x25
	.word 0xde9ec9e0  ! 550: LDDA_R	ldda	[%r27, %r0] 0x4f, %r15
	.word 0x87802020  ! 551: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r17
	.word 0x87802072  ! 553: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3e0, %r22
	.word 0x87802020  ! 555: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 556: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8d4c400  ! 557: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	mov	0x28, %r18
	.word 0xdca62000  ! 559: STWA_I	stwa	%r14, [%r24 + 0x0000] %asi
	.word 0xdcc6a000  ! 560: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r14
	.word 0xd2cf4e40  ! 561: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r9
	.word 0xdec4c400  ! 562: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	.word 0xd4ae2000  ! 563: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0xd0a7ce40  ! 565: STWA_R	stwa	%r8, [%r31 + %r0] 0x72
	.word 0x87802073  ! 566: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 567: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4af6000  ! 568: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd2bdc4a0  ! 569: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	.word 0xd4840400  ! 570: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	.word 0xd48f2000  ! 571: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xdace49e0  ! 572: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r13
	mov	0x7e8, %r20
	.word 0xde9f6000  ! 574: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0x87802020  ! 575: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef62000  ! 576: STXA_I	stxa	%r15, [%r24 + 0x0000] %asi
	.word 0xdebf0e40  ! 577: STDA_R	stda	%r15, [%r28 + %r0] 0x72
	.word 0xd696e000  ! 578: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	.word 0xd6d62000  ! 579: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r11
	mov	0x7d8, %r23
	.word 0xd29649e0  ! 581: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r9
	.word 0x87802025  ! 582: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f8, %r23
	.word 0xd2dca000  ! 584: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r9
	mov	0x7e8, %r21
	mov	0x78, %r19
	.word 0xd2a4a000  ! 587: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0xd8bf4e80  ! 588: STDA_R	stda	%r12, [%r29 + %r0] 0x74
	.word 0xd6f4a000  ! 589: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 590: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 591: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 592: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r16
	.word 0xdaaf8e40  ! 594: STBA_R	stba	%r13, [%r30 + %r0] 0x72
	.word 0xdccf2000  ! 595: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0x87802020  ! 596: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 597: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf5a000  ! 598: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	mov	0x58, %r18
	.word 0xd2b70e80  ! 600: STHA_R	stha	%r9, [%r28 + %r0] 0x74
	.word 0xd2bdc4a0  ! 601: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	.word 0xdaad2000  ! 602: STBA_I	stba	%r13, [%r20 + 0x0000] %asi
	.word 0xd8df8e40  ! 603: LDXA_R	ldxa	[%r30, %r0] 0x72, %r12
	.word 0xdcafce40  ! 604: STBA_R	stba	%r14, [%r31 + %r0] 0x72
	mov	0x10, %r18
	mov	0x50, %r25
	wr_tick_cmpr_2_11:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc9, %g2
	or	%g4, 0x8a, %g4
	or	%g6, 0xad, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x0, %r24
	.word 0x87802020  ! 609: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r16
	.word 0xd6872000  ! 611: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xdecdc4a0  ! 612: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r15
	.word 0x87802020  ! 613: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b6e000  ! 614: STHA_I	stha	%r12, [%r27 + 0x0000] %asi
	.word 0xd8aee000  ! 615: STBA_I	stba	%r12, [%r27 + 0x0000] %asi
	mov	0x50, %r25
	.word 0xded7ce60  ! 617: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r15
	mov	0x0, %r18
	.word 0xd48ea000  ! 619: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r10
	mov	0x30, %r19
	.word 0xd0bf0e40  ! 621: STDA_R	stda	%r8, [%r28 + %r0] 0x72
	.word 0x87802020  ! 622: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd495e000  ! 623: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r10
	mov	0x70, %r18
	.word 0xd4b56000  ! 625: STHA_I	stha	%r10, [%r21 + 0x0000] %asi
	.word 0x87802025  ! 626: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r24
	.word 0xd4a72000  ! 628: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd487ce60  ! 629: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r10
	.word 0xdeb78e40  ! 630: STHA_R	stha	%r15, [%r30 + %r0] 0x72
	.word 0xd6af2000  ! 631: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x10, %r27
	mov	0x60, %r26
	.word 0x87802020  ! 634: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b5c4a0  ! 635: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	.word 0xd8f48400  ! 636: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xdcdce000  ! 637: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r14
	.word 0x87802073  ! 638: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8b44400  ! 639: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0x87802072  ! 640: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc9d2000  ! 641: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r14
	.word 0xd88d84a0  ! 642: LDUBA_R	lduba	[%r22, %r0] 0x25, %r12
	.word 0xdece09e0  ! 643: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r15
	.word 0xd2a70e40  ! 644: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	.word 0x8780204f  ! 645: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 646: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca4a000  ! 647: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	mov	0x50, %r18
	.word 0xdcdca000  ! 649: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 650: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r24
	.word 0xd0b4c400  ! 652: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 653: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e8, %r21
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0d56000  ! 656: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r8
	.word 0xd0ada000  ! 657: STBA_I	stba	%r8, [%r22 + 0x0000] %asi
	.word 0xd08c8400  ! 658: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	mov	0x7f0, %r22
	.word 0xdaf5e000  ! 660: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0xd2a40400  ! 661: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xd2c5c4a0  ! 662: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r9
	.word 0xd2cd2000  ! 663: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r9
	.word 0xd49504a0  ! 664: LDUHA_R	lduha	[%r20, %r0] 0x25, %r10
	.word 0x87802072  ! 665: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 666: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f76000  ! 667: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xde8dc4a0  ! 669: LDUBA_R	lduba	[%r23, %r0] 0x25, %r15
	.word 0xdec7e000  ! 670: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xdaafce40  ! 671: STBA_R	stba	%r13, [%r31 + %r0] 0x72
	.word 0xdc872000  ! 672: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	mov	0x40, %r24
	.word 0xdcbfa000  ! 674: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xda848400  ! 675: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r13
	mov	0x78, %r26
	.word 0xdcc504a0  ! 677: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r14
	.word 0xd4c74e60  ! 678: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r10
	.word 0xd0d78e60  ! 679: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r8
	.word 0xdcbf6000  ! 680: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdcc7e000  ! 681: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0x87802025  ! 682: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8d4c400  ! 683: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	mov	0x50, %r17
	.word 0xd49504a0  ! 685: LDUHA_R	lduha	[%r20, %r0] 0x25, %r10
	.word 0xd8f76000  ! 686: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd2978e60  ! 687: LDUHA_R	lduha	[%r30, %r0] 0x73, %r9
	.word 0xd2b74e40  ! 688: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	.word 0xdaf7e000  ! 689: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0xdaad44a0  ! 691: STBA_R	stba	%r13, [%r21 + %r0] 0x25
	.word 0xd0976000  ! 692: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	mov	0x0, %r24
	.word 0x87802072  ! 694: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r19
	.word 0xdcc70e80  ! 696: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r14
	mov	0x30, %r17
	mov	0x70, %r19
	mov	0x70, %r16
	.word 0xdc8689e0  ! 700: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r14
	.word 0xd4afa000  ! 701: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd4bfe000  ! 702: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x7e0, %r22
	mov	0x7d8, %r22
	.word 0xd4f72000  ! 705: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	mov	0x10, %r26
	.word 0xd4cf6000  ! 707: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0xd4bf2000  ! 708: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd48e49e0  ! 709: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r10
	.word 0xdc970e60  ! 710: LDUHA_R	lduha	[%r28, %r0] 0x73, %r14
	.word 0xd08c0400  ! 711: LDUBA_R	lduba	[%r16, %r0] 0x20, %r8
	.word 0xdec76000  ! 712: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xdedfa000  ! 713: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802020  ! 715: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde876000  ! 716: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xded7e000  ! 717: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	mov	0x3f0, %r23
	mov	0x3f8, %r21
	mov	0x78, %r25
	mov	0x3e8, %r22
	mov	0x50, %r18
	.word 0xde848400  ! 723: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	.word 0xd2a74e80  ! 724: STWA_R	stwa	%r9, [%r29 + %r0] 0x74
	.word 0xd48f6000  ! 725: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xd4f7e000  ! 726: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	mov	0x58, %r24
	.word 0xd0a74e60  ! 728: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	.word 0xd0afe000  ! 729: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0a76000  ! 730: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0c72000  ! 731: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xdc844400  ! 732: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	.word 0xd8f70e80  ! 733: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	mov	0x30, %r27
	.word 0xda9c0400  ! 735: LDDA_R	ldda	[%r16, %r0] 0x20, %r13
	.word 0xd28f0e60  ! 736: LDUBA_R	lduba	[%r28, %r0] 0x73, %r9
	.word 0xd2d78e40  ! 737: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r9
	.word 0xda8fa000  ! 738: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xd2940400  ! 739: LDUHA_R	lduha	[%r16, %r0] 0x20, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd6b649e0  ! 741: STHA_R	stha	%r11, [%r25 + %r0] 0x4f
	.word 0xd0948400  ! 742: LDUHA_R	lduha	[%r18, %r0] 0x20, %r8
	.word 0xdcc7a000  ! 743: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xdebe89e0  ! 744: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	mov	0x8, %r26
	.word 0xdac7a000  ! 746: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xdaac0400  ! 747: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xd2bf2000  ! 748: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 749: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29c2000  ! 750: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	.word 0xd2cce000  ! 751: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	mov	0x7c8, %r23
	.word 0xdeb504a0  ! 753: STHA_R	stha	%r15, [%r20 + %r0] 0x25
	wr_tick_cmpr_2_12:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe5, %g2
	or	%g4, 0xa0, %g4
	or	%g6, 0x80, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xde974e60  ! 755: LDUHA_R	lduha	[%r29, %r0] 0x73, %r15
	.word 0xd8846000  ! 756: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	.word 0x87802074  ! 757: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 758: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd89ee000  ! 759: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r12
	mov	0x70, %r17
	mov	0x7f8, %r22
	.word 0x87802072  ! 762: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4ae49e0  ! 763: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 764: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 765: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 766: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd49fe000  ! 767: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd4f7a000  ! 768: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd0dc8400  ! 769: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0xdcb689e0  ! 770: STHA_R	stha	%r14, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 771: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbfa000  ! 772: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xd48f0e80  ! 773: LDUBA_R	lduba	[%r28, %r0] 0x74, %r10
	mov	0x3e8, %r21
	.word 0xd0b7a000  ! 775: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	mov	0x58, %r26
	.word 0xd0afa000  ! 777: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd0df6000  ! 778: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0x87802074  ! 779: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0bfe000  ! 780: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd0b78e80  ! 781: STHA_R	stha	%r8, [%r30 + %r0] 0x74
	mov	0x3e8, %r21
	.word 0xd2f7a000  ! 783: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xdea74e40  ! 784: STWA_R	stwa	%r15, [%r29 + %r0] 0x72
	.word 0xdea7ce40  ! 785: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	.word 0xdaac0400  ! 786: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xd2a72000  ! 787: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	mov	0x7c8, %r21
	mov	0x40, %r16
	.word 0xd287e000  ! 790: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0x87802074  ! 791: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf584a0  ! 792: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	.word 0xdacf4e60  ! 793: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r13
	.word 0xdc96a000  ! 794: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r14
	.word 0xd6df4e80  ! 795: LDXA_R	ldxa	[%r29, %r0] 0x74, %r11
	.word 0xd2f609e0  ! 796: STXA_R	stxa	%r9, [%r24 + %r0] 0x4f
	mov	0x18, %r17
	mov	0x8, %r16
	mov	0x7e0, %r22
	mov	0x60, %r17
	mov	0x68, %r27
	.word 0xd0d66000  ! 802: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r8
	.word 0xd88649e0  ! 803: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r12
	mov	0x20, %r27
	.word 0x87802020  ! 805: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf7a000  ! 806: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xd097ce60  ! 807: LDUHA_R	lduha	[%r31, %r0] 0x73, %r8
	.word 0xd0f7e000  ! 808: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd8874e60  ! 809: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r12
	.word 0xd28f6000  ! 810: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xded7ce80  ! 811: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r15
	.word 0xd497a000  ! 812: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	mov	0x3f0, %r21
	mov	0x68, %r24
	.word 0xd8f544a0  ! 815: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	.word 0xd4f72000  ! 816: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xde874e80  ! 817: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r15
	.word 0x87802020  ! 818: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b72000  ! 819: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 820: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0970e80  ! 821: LDUHA_R	lduha	[%r28, %r0] 0x74, %r8
	.word 0xd897a000  ! 822: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	mov	0x3e8, %r21
	.word 0xd2dec9e0  ! 824: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r9
	.word 0xdcac0400  ! 825: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0x87802020  ! 826: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48d6000  ! 827: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r10
	.word 0xd4bde000  ! 828: STDA_I	stda	%r10, [%r23 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x58, %r16
	.word 0xd49d2000  ! 831: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r10
	.word 0xd4cd2000  ! 832: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r10
	.word 0xd49da000  ! 833: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r10
	.word 0xd2f4c400  ! 834: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xd295e000  ! 835: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r9
	mov	0x68, %r26
	.word 0xdca7ce80  ! 837: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	.word 0xdad6c9e0  ! 838: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r13
	.word 0xd894c400  ! 839: LDUHA_R	lduha	[%r19, %r0] 0x20, %r12
	.word 0x8780204f  ! 840: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b76000  ! 841: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd4b78e40  ! 842: STHA_R	stha	%r10, [%r30 + %r0] 0x72
	.word 0xdab7e000  ! 843: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	mov	0x58, %r18
	.word 0x87802025  ! 845: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaafa000  ! 846: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 847: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 848: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 849: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 850: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf6e000  ! 851: STXA_I	stxa	%r13, [%r27 + 0x0000] %asi
	.word 0xda9c4400  ! 852: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	.word 0xd2ac4400  ! 853: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	mov	0x18, %r16
	.word 0xdaf62000  ! 855: STXA_I	stxa	%r13, [%r24 + 0x0000] %asi
	.word 0xda96a000  ! 856: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r13
	.word 0xdab74e80  ! 857: STHA_R	stha	%r13, [%r29 + %r0] 0x74
	.word 0x87802025  ! 858: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 859: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0c7a000  ! 860: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0b689e0  ! 861: STHA_R	stha	%r8, [%r26 + %r0] 0x4f
	.word 0xd6872000  ! 862: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	mov	0x30, %r16
	.word 0xd89649e0  ! 864: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r12
	.word 0xdaad84a0  ! 865: STBA_R	stba	%r13, [%r22 + %r0] 0x25
	mov	0x30, %r25
	.word 0x87802020  ! 867: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca7a000  ! 868: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 869: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcace000  ! 870: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0xdcf46000  ! 871: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	mov	0x30, %r17
	.word 0x8780204f  ! 873: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcc42000  ! 874: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r14
	.word 0xd09e89e0  ! 875: LDDA_R	ldda	[%r26, %r0] 0x4f, %r8
	.word 0xd8df4e60  ! 876: LDXA_R	ldxa	[%r29, %r0] 0x73, %r12
	mov	0x28, %r17
	.word 0x87802072  ! 878: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcacc400  ! 879: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0xde9d6000  ! 880: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r15
	.word 0xd4a74e60  ! 881: STWA_R	stwa	%r10, [%r29 + %r0] 0x73
	mov	0x20, %r19
	.word 0x87802073  ! 883: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f7a000  ! 884: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6874e40  ! 885: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r11
	mov	0x78, %r19
	.word 0xdea44400  ! 887: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	mov	0x58, %r16
	.word 0xd28f0e80  ! 889: LDUBA_R	lduba	[%r28, %r0] 0x74, %r9
	mov	0x20, %r17
	.word 0xdacf8e40  ! 891: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r13
	.word 0xd0a7a000  ! 892: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0c76000  ! 893: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0f7a000  ! 894: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 895: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9c8400  ! 896: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0x87802072  ! 897: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f8, %r22
	.word 0x8780204f  ! 899: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcd46000  ! 900: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 901: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e0, %r23
	.word 0x87802020  ! 903: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcaca000  ! 904: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xdcd42000  ! 905: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	.word 0xd6f649e0  ! 906: STXA_R	stxa	%r11, [%r25 + %r0] 0x4f
	mov	0x28, %r16
	.word 0xdca4a000  ! 908: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0xdedf0e60  ! 909: LDXA_R	ldxa	[%r28, %r0] 0x73, %r15
	mov	0x48, %r19
	.word 0xd8a4a000  ! 911: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xda9649e0  ! 912: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r13
	mov	0x60, %r24
	.word 0xde842000  ! 914: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	.word 0xdea46000  ! 915: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xd49d44a0  ! 916: LDDA_R	ldda	[%r21, %r0] 0x25, %r10
	.word 0xd09d44a0  ! 917: LDDA_R	ldda	[%r21, %r0] 0x25, %r8
	mov	0x3d8, %r22
	.word 0xd2b42000  ! 919: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0xd2bce000  ! 920: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 921: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cde000  ! 922: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r9
	.word 0xd2ad6000  ! 923: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	mov	0x7c8, %r21
	mov	0x58, %r26
	.word 0xd2f56000  ! 926: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	.word 0xdeb609e0  ! 927: STHA_R	stha	%r15, [%r24 + %r0] 0x4f
	.word 0xd4a609e0  ! 928: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	.word 0xd2b56000  ! 929: STHA_I	stha	%r9, [%r21 + 0x0000] %asi
	.word 0xd2bde000  ! 930: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	mov	0x70, %r24
	.word 0xd2c5e000  ! 932: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r9
	mov	0x50, %r26
	.word 0xd2ad6000  ! 934: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0xd2a52000  ! 935: STWA_I	stwa	%r9, [%r20 + 0x0000] %asi
	mov	0x3f0, %r23
	.word 0xd2a5a000  ! 937: STWA_I	stwa	%r9, [%r22 + 0x0000] %asi
	.word 0xd295e000  ! 938: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r9
	.word 0xd2b56000  ! 939: STHA_I	stha	%r9, [%r21 + 0x0000] %asi
	.word 0xd0b70e40  ! 940: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	.word 0xd8bc8400  ! 941: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xd6dd6000  ! 942: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r11
	.word 0xd6b5a000  ! 943: STHA_I	stha	%r11, [%r22 + 0x0000] %asi
	.word 0xded70e80  ! 944: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r15
	mov	0x7c8, %r22
	mov	0x3c8, %r21
	.word 0xdca5e000  ! 947: STWA_I	stwa	%r14, [%r23 + 0x0000] %asi
	.word 0xd6be09e0  ! 948: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	.word 0xdab48400  ! 949: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0xdcbd2000  ! 950: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	.word 0xdc956000  ! 951: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r14
	.word 0x87802072  ! 952: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcaca000  ! 953: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdc94a000  ! 955: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xd6df0e40  ! 956: LDXA_R	ldxa	[%r28, %r0] 0x72, %r11
	.word 0xd094a000  ! 957: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	.word 0xd0b46000  ! 958: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	mov	0x20, %r18
	mov	0x0, %r19
	.word 0xdcbf8e40  ! 961: STDA_R	stda	%r14, [%r30 + %r0] 0x72
	.word 0xdc94e000  ! 962: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	.word 0xdcf4a000  ! 963: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	mov	0x78, %r24
	.word 0x87802074  ! 965: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8c74e60  ! 966: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r12
	mov	0x70, %r16
	.word 0x87802074  ! 968: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r24
	.word 0xd2aea000  ! 970: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0xd2de6000  ! 971: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r9
	.word 0x87802020  ! 972: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f72000  ! 973: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd2af6000  ! 974: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd2a7e000  ! 975: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0xd4af8e40  ! 977: STBA_R	stba	%r10, [%r30 + %r0] 0x72
	.word 0xd28c8400  ! 978: LDUBA_R	lduba	[%r18, %r0] 0x20, %r9
	.word 0xdaafe000  ! 979: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xdad72000  ! 980: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0xdaf72000  ! 981: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 982: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r24
	.word 0x87802072  ! 984: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdac7a000  ! 985: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xd0a7ce60  ! 986: STWA_R	stwa	%r8, [%r31 + %r0] 0x73
	mov	0x20, %r24
	mov	0x7c0, %r23
	mov	0x50, %r27
	.word 0xdac649e0  ! 990: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r13
	.word 0xd4a40400  ! 991: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	.word 0xd4cf6000  ! 992: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0xd4afe000  ! 993: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 994: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc9f4e40  ! 995: LDDA_R	ldda	[%r29, %r0] 0x72, %r14
	.word 0x87802074  ! 996: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xded7e000  ! 997: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0xde8f2000  ! 998: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0x87802025  ! 999: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdec7a000  ! 1000: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xd0ae09e0  ! 1001: STBA_R	stba	%r8, [%r24 + %r0] 0x4f
	.word 0xdeaf2000  ! 1002: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xdcbec9e0  ! 1003: STDA_R	stda	%r14, [%r27 + %r0] 0x4f
	.word 0xd2df4e80  ! 1004: LDXA_R	ldxa	[%r29, %r0] 0x74, %r9
	mov	0x70, %r24
	.word 0xdef44400  ! 1006: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xdab7e000  ! 1007: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1008: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa4e000  ! 1009: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0xda842000  ! 1010: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r13
	.word 0x87802074  ! 1011: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdab7a000  ! 1012: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 1013: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d0, %r22
	.word 0xdef70e60  ! 1015: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	.word 0x87802025  ! 1016: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6ccc400  ! 1017: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	.word 0xde940400  ! 1018: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0xdef62000  ! 1019: STXA_I	stxa	%r15, [%r24 + 0x0000] %asi
	.word 0xdebe6000  ! 1020: STDA_I	stda	%r15, [%r25 + 0x0000] %asi
	.word 0xdea6e000  ! 1021: STWA_I	stwa	%r15, [%r27 + 0x0000] %asi
	.word 0xde866000  ! 1022: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r15
	.word 0xdeaee000  ! 1023: STBA_I	stba	%r15, [%r27 + 0x0000] %asi
	mov	0x50, %r19
	.word 0xde862000  ! 1025: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r15
	.word 0xd8a7ce40  ! 1026: STWA_R	stwa	%r12, [%r31 + %r0] 0x72
	.word 0xd4ce2000  ! 1027: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r10
	.word 0x87802025  ! 1028: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4afa000  ! 1029: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd0978e60  ! 1030: LDUHA_R	lduha	[%r30, %r0] 0x73, %r8
	mov	0x60, %r19
	.word 0x87802074  ! 1032: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6a44400  ! 1033: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	mov	0x78, %r26
	.word 0xdaae89e0  ! 1035: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	.word 0xdaa74e60  ! 1036: STWA_R	stwa	%r13, [%r29 + %r0] 0x73
	mov	0x7e8, %r21
	.word 0x87802073  ! 1038: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r25
	mov	0x40, %r19
	.word 0xdc85a000  ! 1041: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r14
	.word 0xdef48400  ! 1042: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	wr_tick_cmpr_2_13:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xcd, %g2
	or	%g4, 0x81, %g4
	or	%g6, 0xc4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x68, %r18
	.word 0xd6bd6000  ! 1045: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0xd6f5e000  ! 1046: STXA_I	stxa	%r11, [%r23 + 0x0000] %asi
	.word 0xd6b52000  ! 1047: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 1048: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c0, %r21
	.word 0xd4dec9e0  ! 1050: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r10
	.word 0x8780204f  ! 1051: WRASI_I	wr	%r0, 0x004f, %asi
	wr_tick_cmpr_2_14:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xd4, %g2
	or	%g4, 0xd0, %g4
	or	%g6, 0x88, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2bf6000  ! 1053: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd2bf6000  ! 1054: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xde840400  ! 1055: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	mov	0x40, %r17
	.word 0xde85c4a0  ! 1057: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r15
	.word 0xd2b7ce60  ! 1058: STHA_R	stha	%r9, [%r31 + %r0] 0x73
	.word 0xd6bcc400  ! 1059: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0xd4878e60  ! 1060: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r10
	.word 0xdeb74e40  ! 1061: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	.word 0xd2a70e80  ! 1062: STWA_R	stwa	%r9, [%r28 + %r0] 0x74
	.word 0xd28c0400  ! 1063: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	.word 0xdc972000  ! 1064: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	mov	0x3e8, %r21
	mov	0x7d0, %r22
	.word 0xdc876000  ! 1067: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0xd0be09e0  ! 1068: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0x87802074  ! 1069: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda8fce40  ! 1070: LDUBA_R	lduba	[%r31, %r0] 0x72, %r13
	mov	0x0, %r25
	.word 0xdccca000  ! 1072: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	mov	0x0, %r24
	.word 0xd2c544a0  ! 1074: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r9
	.word 0xd2840400  ! 1075: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r9
	.word 0xde8ce000  ! 1076: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 1077: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf70e60  ! 1078: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	.word 0xd0f6e000  ! 1079: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	.word 0xde8ec9e0  ! 1080: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r15
	mov	0x3e0, %r20
	.word 0xdeb66000  ! 1082: STHA_I	stha	%r15, [%r25 + 0x0000] %asi
	.word 0xdedea000  ! 1083: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r15
	.word 0xdec62000  ! 1084: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r15
	mov	0x3f8, %r21
	mov	0x3d0, %r23
	.word 0xda878e40  ! 1087: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r13
	.word 0x87802025  ! 1088: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r27
	.word 0xd0f44400  ! 1090: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xdc856000  ! 1091: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r14
	wr_tick_cmpr_2_15:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf6, %g2
	or	%g4, 0x8a, %g4
	or	%g6, 0xe9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xde9f8e80  ! 1093: LDDA_R	ldda	[%r30, %r0] 0x74, %r15
	mov	0x60, %r26
	.word 0xd8dd6000  ! 1095: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r12
	.word 0xd89da000  ! 1096: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r12
	.word 0xdeb48400  ! 1097: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xd4dd04a0  ! 1098: LDXA_R	ldxa	[%r20, %r0] 0x25, %r10
	.word 0xdc8ec9e0  ! 1099: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r14
	.word 0xdebde000  ! 1100: STDA_I	stda	%r15, [%r23 + 0x0000] %asi
	.word 0xdaf40400  ! 1101: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xd4c5a000  ! 1102: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r10
	mov	0x7f0, %r23
	.word 0xd4a609e0  ! 1104: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	.word 0xdebc4400  ! 1105: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0x87802020  ! 1106: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r27
	.word 0xdac5a000  ! 1108: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r13
	.word 0x87802074  ! 1109: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 1110: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 1111: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdad5a000  ! 1112: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r13
	.word 0xd2bf4e40  ! 1113: STDA_R	stda	%r9, [%r29 + %r0] 0x72
	.word 0xd2d78e80  ! 1114: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r9
	.word 0xda8c0400  ! 1115: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	mov	0x48, %r19
	mov	0x3f0, %r23
	.word 0xd2f70e40  ! 1118: STXA_R	stxa	%r9, [%r28 + %r0] 0x72
	.word 0xd0bd6000  ! 1119: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0xd2a78e40  ! 1120: STWA_R	stwa	%r9, [%r30 + %r0] 0x72
	.word 0x87802073  ! 1121: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 1122: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f48400  ! 1123: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xd4bd84a0  ! 1124: STDA_R	stda	%r10, [%r22 + %r0] 0x25
	.word 0xda8d84a0  ! 1125: LDUBA_R	lduba	[%r22, %r0] 0x25, %r13
	.word 0xd6b44400  ! 1126: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xd48f2000  ! 1127: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd48f2000  ! 1128: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd8878e60  ! 1129: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r12
	mov	0x58, %r27
	.word 0xd4cf2000  ! 1131: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	mov	0x3f8, %r22
	mov	0x3c0, %r21
	mov	0x7d0, %r21
	.word 0x87802025  ! 1135: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cca000  ! 1136: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r10
	mov	0x8, %r18
	.word 0x8780204f  ! 1138: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6bfce60  ! 1139: STDA_R	stda	%r11, [%r31 + %r0] 0x73
	.word 0xdaa44400  ! 1140: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0xdca7a000  ! 1141: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 1142: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r26
	.word 0xde9fce40  ! 1144: LDDA_R	ldda	[%r31, %r0] 0x72, %r15
	.word 0xd89f6000  ! 1145: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	.word 0xd8dfa000  ! 1146: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	mov	0x0, %r16
	.word 0xd8afa000  ! 1148: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xdef74e60  ! 1149: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	mov	0x78, %r16
	mov	0x3e0, %r23
	.word 0xd497e000  ! 1152: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	.word 0xd4bf6000  ! 1153: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd4c72000  ! 1154: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4b76000  ! 1155: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd4af6000  ! 1156: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd88649e0  ! 1157: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r12
	.word 0x87802074  ! 1158: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r19
	.word 0xd0c584a0  ! 1160: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r8
	.word 0xd0f74e40  ! 1161: STXA_R	stxa	%r8, [%r29 + %r0] 0x72
	mov	0x48, %r17
	.word 0x87802025  ! 1163: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdedf4e40  ! 1164: LDXA_R	ldxa	[%r29, %r0] 0x72, %r15
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7d0, %r21
	.word 0x87802020  ! 1167: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r23
	.word 0x87802074  ! 1169: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabee000  ! 1170: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	.word 0xd08f0e60  ! 1171: LDUBA_R	lduba	[%r28, %r0] 0x73, %r8
	mov	0x3d8, %r22
	mov	0x50, %r18
	.word 0x87802020  ! 1174: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r18
	.word 0x87802020  ! 1176: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdc0400  ! 1177: LDXA_R	ldxa	[%r16, %r0] 0x20, %r14
	.word 0xd8d504a0  ! 1178: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r12
	.word 0xd0f48400  ! 1179: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xd08ca000  ! 1180: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xd8bc0400  ! 1181: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xd8f74e80  ! 1182: STXA_R	stxa	%r12, [%r29 + %r0] 0x74
	mov	0x38, %r16
	.word 0xdca48400  ! 1184: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	mov	0x7e0, %r21
	.word 0xd6cc2000  ! 1186: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	mov	0x30, %r18
	.word 0xd6dc2000  ! 1188: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r11
	.word 0xdac584a0  ! 1189: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r13
	.word 0xd2c504a0  ! 1190: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r9
	.word 0xdaf4e000  ! 1191: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 1192: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r19
	.word 0xdccf0e40  ! 1194: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r14
	.word 0xd0f76000  ! 1195: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0ad44a0  ! 1196: STBA_R	stba	%r8, [%r21 + %r0] 0x25
	mov	0x68, %r19
	.word 0xdcac4400  ! 1198: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	mov	0x7d8, %r23
	.word 0xd4bf8e60  ! 1200: STDA_R	stda	%r10, [%r30 + %r0] 0x73
	.word 0x87802025  ! 1201: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8a7a000  ! 1202: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8df2000  ! 1203: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xd897a000  ! 1204: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0xd08f8e60  ! 1205: LDUBA_R	lduba	[%r30, %r0] 0x73, %r8
	.word 0xd8df6000  ! 1206: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1207: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b6a000  ! 1208: STHA_I	stha	%r12, [%r26 + 0x0000] %asi
	mov	0x50, %r26
	.word 0xd8dea000  ! 1210: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r12
	.word 0xd8d6a000  ! 1211: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r12
	.word 0xd29f0e60  ! 1212: LDDA_R	ldda	[%r28, %r0] 0x73, %r9
	.word 0xdedea000  ! 1213: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r15
	.word 0xd8ac0400  ! 1214: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xd2a66000  ! 1215: STWA_I	stwa	%r9, [%r25 + 0x0000] %asi
	.word 0xdcb78e80  ! 1216: STHA_R	stha	%r14, [%r30 + %r0] 0x74
	.word 0x87802020  ! 1217: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d6c9e0  ! 1218: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r10
	.word 0xd6afa000  ! 1219: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0xd6bf6000  ! 1221: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd6a72000  ! 1222: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6afe000  ! 1223: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd6b7e000  ! 1224: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd6b7e000  ! 1225: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd6b78e80  ! 1226: STHA_R	stha	%r11, [%r30 + %r0] 0x74
	.word 0xda8f2000  ! 1227: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0x87802072  ! 1228: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1229: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r16
	.word 0xda862000  ! 1231: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r13
	mov	0x70, %r25
	.word 0xdebd44a0  ! 1233: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	ta	T_CHANGE_PRIV	! macro
	.word 0xd0c40400  ! 1235: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	.word 0xd68e2000  ! 1236: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r11
	mov	0x3e8, %r23
	mov	0x8, %r24
	.word 0xd8bd84a0  ! 1239: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	mov	0x3f0, %r21
	.word 0x87802074  ! 1241: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0d40400  ! 1242: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	.word 0xdecc6000  ! 1243: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r15
	.word 0xdea42000  ! 1244: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xde84e000  ! 1245: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	.word 0xd0a609e0  ! 1246: STWA_R	stwa	%r8, [%r24 + %r0] 0x4f
	mov	0x7f8, %r23
	mov	0x50, %r18
	.word 0xd6c48400  ! 1249: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	.word 0xdabc2000  ! 1250: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xdaac6000  ! 1251: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	.word 0xd6d6c9e0  ! 1252: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r11
	.word 0x87802025  ! 1253: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbf0e60  ! 1254: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	.word 0xd4ac8400  ! 1255: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 1256: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0852000  ! 1257: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r8
	.word 0xd0d74e80  ! 1258: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r8
	mov	0x3d0, %r21
	mov	0x18, %r24
	.word 0xd0bd44a0  ! 1261: STDA_R	stda	%r8, [%r21 + %r0] 0x25
	.word 0xd0dc8400  ! 1262: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0xd0cda000  ! 1263: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r8
	.word 0xd8b74e40  ! 1264: STHA_R	stha	%r12, [%r29 + %r0] 0x72
	wr_tick_cmpr_2_16:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x9b, %g2
	or	%g4, 0xb4, %g4
	or	%g6, 0x8c, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdcf544a0  ! 1266: STXA_R	stxa	%r14, [%r21 + %r0] 0x25
	.word 0xd4a56000  ! 1267: STWA_I	stwa	%r10, [%r21 + 0x0000] %asi
	.word 0xd4a5a000  ! 1268: STWA_I	stwa	%r10, [%r22 + 0x0000] %asi
	.word 0xdabf4e60  ! 1269: STDA_R	stda	%r13, [%r29 + %r0] 0x73
	.word 0xd0bd2000  ! 1270: STDA_I	stda	%r8, [%r20 + 0x0000] %asi
	.word 0xdc9e89e0  ! 1271: LDDA_R	ldda	[%r26, %r0] 0x4f, %r14
	.word 0xd8bd2000  ! 1272: STDA_I	stda	%r12, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 1273: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6878e80  ! 1274: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r11
	.word 0x87802020  ! 1275: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bf8e40  ! 1276: STDA_R	stda	%r11, [%r30 + %r0] 0x72
	wr_tick_cmpr_2_17:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf1, %g2
	or	%g4, 0xf3, %g4
	or	%g6, 0x95, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0f46000  ! 1278: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xde9649e0  ! 1279: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r15
	.word 0xda8649e0  ! 1280: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r13
	.word 0xd8a7ce40  ! 1281: STWA_R	stwa	%r12, [%r31 + %r0] 0x72
	wr_tick_cmpr_2_18:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xcf, %g2
	or	%g4, 0xe6, %g4
	or	%g6, 0x93, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3d0, %r22
	.word 0xd08ce000  ! 1284: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xdecf8e40  ! 1285: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r15
	.word 0x87802020  ! 1286: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d70e40  ! 1287: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r9
	.word 0xdeb76000  ! 1288: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xd4af8e80  ! 1290: STBA_R	stba	%r10, [%r30 + %r0] 0x74
	mov	0x3e0, %r22
	.word 0xd2bfce80  ! 1292: STDA_R	stda	%r9, [%r31 + %r0] 0x74
	.word 0xd28f2000  ! 1293: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	mov	0x58, %r24
	.word 0xda9fce40  ! 1295: LDDA_R	ldda	[%r31, %r0] 0x72, %r13
	.word 0xdec7ce80  ! 1296: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r15
	.word 0xdab7a000  ! 1297: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	mov	0x10, %r17
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x20, %r17
	mov	0x70, %r27
	.word 0xdef40400  ! 1302: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0xdcaf2000  ! 1303: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	mov	0x8, %r18
	.word 0xdc9fa000  ! 1305: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0xdcc76000  ! 1306: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xd0a44400  ! 1307: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xdcc7e000  ! 1308: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0x87802020  ! 1309: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r25
	.word 0xdc9fa000  ! 1311: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0x87802073  ! 1312: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x28, %r24
	mov	0x50, %r27
	.word 0xdc9f2000  ! 1316: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xd8f40400  ! 1317: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xd0ae89e0  ! 1318: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	.word 0xd4b7a000  ! 1319: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd4d72000  ! 1320: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	mov	0x3d8, %r21
	mov	0x0, %r16
	.word 0xd49fe000  ! 1323: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd8974e60  ! 1324: LDUHA_R	lduha	[%r29, %r0] 0x73, %r12
	.word 0xd2f609e0  ! 1325: STXA_R	stxa	%r9, [%r24 + %r0] 0x4f
	.word 0xdec504a0  ! 1326: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r15
	.word 0xdcbfe000  ! 1327: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	mov	0x3e0, %r20
	mov	0x7d0, %r21
	.word 0x87802025  ! 1330: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca4a000  ! 1331: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0xdc946000  ! 1332: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r14
	mov	0x50, %r27
	.word 0xdecf4e40  ! 1334: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r15
	.word 0x87802020  ! 1335: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1336: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r19
	.word 0xdaaca000  ! 1338: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0xdeb6c9e0  ! 1339: STHA_R	stha	%r15, [%r27 + %r0] 0x4f
	mov	0x8, %r16
	.word 0xd6a7ce60  ! 1341: STWA_R	stwa	%r11, [%r31 + %r0] 0x73
	.word 0x87802025  ! 1342: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r19
	mov	0x60, %r25
	.word 0xd88f4e80  ! 1345: LDUBA_R	lduba	[%r29, %r0] 0x74, %r12
	.word 0x87802020  ! 1346: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f40400  ! 1347: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xd0d52000  ! 1348: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r8
	.word 0x87802074  ! 1349: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 1350: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r19
	.word 0xd087a000  ! 1352: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0x87802074  ! 1353: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d0, %r23
	.word 0x87802073  ! 1355: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8c6c9e0  ! 1356: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r12
	.word 0xdc9c4400  ! 1357: LDDA_R	ldda	[%r17, %r0] 0x20, %r14
	mov	0x7e0, %r22
	.word 0x87802020  ! 1359: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d7a000  ! 1360: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	mov	0x7f0, %r20
	.word 0x87802072  ! 1362: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r18
	.word 0xd4b44400  ! 1364: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	.word 0xd2ad84a0  ! 1365: STBA_R	stba	%r9, [%r22 + %r0] 0x25
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2f46000  ! 1367: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	mov	0x38, %r19
	mov	0x7d8, %r22
	.word 0xdebdc4a0  ! 1370: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	.word 0xd4aca000  ! 1371: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0xd4a4e000  ! 1372: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xdef7ce80  ! 1373: STXA_R	stxa	%r15, [%r31 + %r0] 0x74
	.word 0xd8afce60  ! 1374: STBA_R	stba	%r12, [%r31 + %r0] 0x73
	mov	0x30, %r18
	mov	0x68, %r26
	.word 0x87802072  ! 1377: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6bde000  ! 1378: STDA_I	stda	%r11, [%r23 + 0x0000] %asi
	.word 0xd6ade000  ! 1379: STBA_I	stba	%r11, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 1380: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 1381: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf504a0  ! 1382: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	.word 0xdcce49e0  ! 1383: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r14
	mov	0x3e8, %r20
	.word 0xd28e2000  ! 1385: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	.word 0xd2be6000  ! 1386: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	.word 0x87802073  ! 1387: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 1388: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a46000  ! 1389: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2a42000  ! 1390: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 1391: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r17
	.word 0xd8bd04a0  ! 1393: STDA_R	stda	%r12, [%r20 + %r0] 0x25
	mov	0x8, %r19
	.word 0xd8a7a000  ! 1395: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8a7e000  ! 1396: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	mov	0x8, %r26
	mov	0x60, %r27
	.word 0xd4b70e60  ! 1399: STHA_R	stha	%r10, [%r28 + %r0] 0x73
	.word 0xdccfe000  ! 1400: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xdc87ce80  ! 1401: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r14
	mov	0x20, %r26
	mov	0x60, %r19
	.word 0xd2dfe000  ! 1404: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	mov	0x3e0, %r21
	.word 0xd2b7e000  ! 1406: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1407: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc978e40  ! 1408: LDUHA_R	lduha	[%r30, %r0] 0x72, %r14
	mov	0x3e0, %r22
	.word 0xde9de000  ! 1410: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r15
	.word 0x87802020  ! 1411: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8be89e0  ! 1412: STDA_R	stda	%r12, [%r26 + %r0] 0x4f
	mov	0x58, %r26
	mov	0x7c0, %r23
	.word 0xdcb52000  ! 1415: STHA_I	stha	%r14, [%r20 + 0x0000] %asi
	.word 0xdca5e000  ! 1416: STWA_I	stwa	%r14, [%r23 + 0x0000] %asi
	.word 0xd4ac0400  ! 1417: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xd0bf8e60  ! 1418: STDA_R	stda	%r8, [%r30 + %r0] 0x73
	.word 0xd4f56000  ! 1419: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	.word 0xd095c4a0  ! 1420: LDUHA_R	lduha	[%r23, %r0] 0x25, %r8
	.word 0x87802020  ! 1421: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f70e60  ! 1422: STXA_R	stxa	%r10, [%r28 + %r0] 0x73
	.word 0xdcb78e80  ! 1423: STHA_R	stha	%r14, [%r30 + %r0] 0x74
	.word 0x87802025  ! 1424: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4974e40  ! 1425: LDUHA_R	lduha	[%r29, %r0] 0x72, %r10
	.word 0xde9fe000  ! 1426: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0xdebf2000  ! 1427: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 1428: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde8d6000  ! 1429: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r15
	.word 0xdea56000  ! 1430: STWA_I	stwa	%r15, [%r21 + 0x0000] %asi
	.word 0xd8b78e40  ! 1431: STHA_R	stha	%r12, [%r30 + %r0] 0x72
	.word 0xdcd40400  ! 1432: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	.word 0xd2f56000  ! 1433: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	mov	0x7d0, %r21
	mov	0x30, %r19
	.word 0xd2952000  ! 1436: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r9
	.word 0xdad4c400  ! 1437: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xdcbd2000  ! 1438: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	.word 0xdccc0400  ! 1439: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r14
	mov	0x30, %r17
	.word 0xd6cf4e40  ! 1441: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r11
	.word 0xd48da000  ! 1442: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r10
	.word 0xd6dcc400  ! 1443: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	.word 0x87802020  ! 1444: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf76000  ! 1445: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcb7e000  ! 1446: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xdca72000  ! 1447: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	mov	0x78, %r24
	.word 0xdccf2000  ! 1449: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xdcf7e000  ! 1450: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcc7a000  ! 1452: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xdc87a000  ! 1453: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcaf2000  ! 1454: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xd0b7ce40  ! 1455: STHA_R	stha	%r8, [%r31 + %r0] 0x72
	.word 0xdaf76000  ! 1456: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	mov	0x58, %r24
	.word 0xd0b4c400  ! 1458: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0xd8af4e80  ! 1459: STBA_R	stba	%r12, [%r29 + %r0] 0x74
	.word 0x8780204f  ! 1460: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdab46000  ! 1461: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0xdaa44400  ! 1462: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0xd08c6000  ! 1463: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0xd094a000  ! 1464: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	.word 0xd0c46000  ! 1465: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r8
	.word 0xd0ac6000  ! 1466: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xde974e40  ! 1468: LDUHA_R	lduha	[%r29, %r0] 0x72, %r15
	.word 0xd0c42000  ! 1469: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r8
	mov	0x48, %r17
	mov	0x68, %r19
	.word 0x87802025  ! 1472: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r16
	mov	0x48, %r26
	.word 0xdaa74e60  ! 1475: STWA_R	stwa	%r13, [%r29 + %r0] 0x73
	mov	0x48, %r16
	.word 0xd8ac2000  ! 1477: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	mov	0x68, %r25
	.word 0xd8f4e000  ! 1479: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xd8b4a000  ! 1480: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0xd894c400  ! 1481: LDUHA_R	lduha	[%r19, %r0] 0x20, %r12
	.word 0x87802020  ! 1482: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f62000  ! 1483: STXA_I	stxa	%r8, [%r24 + 0x0000] %asi
	.word 0x87802074  ! 1484: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda8f0e40  ! 1485: LDUBA_R	lduba	[%r28, %r0] 0x72, %r13
	mov	0x58, %r19
	.word 0x87802025  ! 1487: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f0, %r22
	.word 0x87802074  ! 1489: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2a46000  ! 1490: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 1491: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 1492: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r18
	.word 0xd6f7ce60  ! 1494: STXA_R	stxa	%r11, [%r31 + %r0] 0x73
	.word 0xda9609e0  ! 1495: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r13
	.word 0xd4bfe000  ! 1496: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xdab78e40  ! 1497: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	mov	0x30, %r19
	.word 0xdea4c400  ! 1499: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	.word 0xd8dfa000  ! 1500: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	mov	0x68, %r26
	mov	0x40, %r27
	.word 0xd8d76000  ! 1503: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xde8fce40  ! 1504: LDUBA_R	lduba	[%r31, %r0] 0x72, %r15
	.word 0xd2d7a000  ! 1505: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0x87802025  ! 1506: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f0, %r22
	mov	0x68, %r17
	.word 0xd2ada000  ! 1509: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	mov	0x7f0, %r21
	.word 0xd2b78e60  ! 1511: STHA_R	stha	%r9, [%r30 + %r0] 0x73
	.word 0xd8b78e40  ! 1512: STHA_R	stha	%r12, [%r30 + %r0] 0x72
	.word 0xda9cc400  ! 1513: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	mov	0x68, %r18
	.word 0xd4cde000  ! 1515: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r10
	mov	0x38, %r24
	.word 0xd495a000  ! 1517: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r10
	.word 0xd4a56000  ! 1518: STWA_I	stwa	%r10, [%r21 + 0x0000] %asi
	mov	0x7f0, %r23
	mov	0x60, %r16
	.word 0xd48d2000  ! 1521: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0xd49d2000  ! 1522: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r10
	.word 0xd2f44400  ! 1523: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	.word 0xd4974e80  ! 1524: LDUHA_R	lduha	[%r29, %r0] 0x74, %r10
	.word 0xdea5a000  ! 1525: STWA_I	stwa	%r15, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 1526: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd88544a0  ! 1527: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r12
	.word 0xd0cf8e40  ! 1528: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r8
	.word 0xd6a42000  ! 1529: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	mov	0x78, %r26
	.word 0xd6b42000  ! 1531: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0xdcbdc4a0  ! 1532: STDA_R	stda	%r14, [%r23 + %r0] 0x25
	mov	0x78, %r16
	.word 0x87802025  ! 1534: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaafa000  ! 1535: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdadf2000  ! 1536: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0xdaa7e000  ! 1537: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xdabf2000  ! 1538: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xdc948400  ! 1539: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	.word 0xd8bfce60  ! 1540: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	mov	0x70, %r26
	mov	0x3d8, %r20
	.word 0xd2be49e0  ! 1543: STDA_R	stda	%r9, [%r25 + %r0] 0x4f
	.word 0x87802072  ! 1544: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd48d04a0  ! 1545: LDUBA_R	lduba	[%r20, %r0] 0x25, %r10
	.word 0xd2bfa000  ! 1546: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0xd2c7a000  ! 1548: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2afa000  ! 1549: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xd0bc8400  ! 1551: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0xd2f7ce40  ! 1552: STXA_R	stxa	%r9, [%r31 + %r0] 0x72
	.word 0xdc9f6000  ! 1553: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xdcf7a000  ! 1554: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	wr_tick_cmpr_2_19:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb9, %g2
	or	%g4, 0xc2, %g4
	or	%g6, 0xd4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_PRIV	! macro
	.word 0xd89d84a0  ! 1557: LDDA_R	ldda	[%r22, %r0] 0x25, %r12
	mov	0x3d0, %r21
	mov	0x7c0, %r23
	.word 0xdedf6000  ! 1560: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	mov	0x20, %r16
	.word 0xd0f70e40  ! 1562: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	.word 0xd6d78e60  ! 1563: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r11
	.word 0xd2970e80  ! 1564: LDUHA_R	lduha	[%r28, %r0] 0x74, %r9
	.word 0xd2a544a0  ! 1565: STWA_R	stwa	%r9, [%r21 + %r0] 0x25
	.word 0xd6c7e000  ! 1566: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xdca74e80  ! 1567: STWA_R	stwa	%r14, [%r29 + %r0] 0x74
	.word 0xdcddc4a0  ! 1568: LDXA_R	ldxa	[%r23, %r0] 0x25, %r14
	mov	0x50, %r17
	.word 0xdc97a000  ! 1570: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	.word 0xdcbfa000  ! 1571: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdccfa000  ! 1572: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xdc976000  ! 1573: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	mov	0x3c8, %r21
	.word 0xdcb7a000  ! 1575: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1576: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbd2000  ! 1577: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	.word 0xde8d44a0  ! 1578: LDUBA_R	lduba	[%r21, %r0] 0x25, %r15
	.word 0xd6b48400  ! 1579: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xde840400  ! 1580: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	.word 0xded52000  ! 1581: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r15
	.word 0xde9da000  ! 1582: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r15
	.word 0xd496c9e0  ! 1583: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r10
	.word 0xd8bc0400  ! 1584: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	mov	0x3d8, %r23
	.word 0xd2af0e80  ! 1586: STBA_R	stba	%r9, [%r28 + %r0] 0x74
	.word 0xdcaf4e60  ! 1587: STBA_R	stba	%r14, [%r29 + %r0] 0x73
	.word 0xdeb5e000  ! 1588: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	.word 0xd0cc8400  ! 1589: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0x87802020  ! 1590: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_2_20:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe6, %g2
	or	%g4, 0xa7, %g4
	or	%g6, 0xac, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	wr_tick_cmpr_2_21:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x9c, %g2
	or	%g4, 0xb2, %g4
	or	%g6, 0xcb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0970e40  ! 1593: LDUHA_R	lduha	[%r28, %r0] 0x72, %r8
	.word 0x87802020  ! 1594: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08f8e40  ! 1595: LDUBA_R	lduba	[%r30, %r0] 0x72, %r8
	.word 0xd28c2000  ! 1596: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	mov	0x70, %r25
	.word 0xd6aec9e0  ! 1598: STBA_R	stba	%r11, [%r27 + %r0] 0x4f
	.word 0x87802025  ! 1599: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a42000  ! 1600: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xd0cc2000  ! 1601: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	.word 0xd08ce000  ! 1602: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xd4a544a0  ! 1603: STWA_R	stwa	%r10, [%r21 + %r0] 0x25
	mov	0x30, %r25
	.word 0x87802073  ! 1605: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdea689e0  ! 1606: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	.word 0xdaf48400  ! 1607: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xd0b48400  ! 1608: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xd6aca000  ! 1609: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 1610: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r22
	wr_tick_cmpr_2_22:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd1, %g2
	or	%g4, 0xe1, %g4
	or	%g6, 0xdd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0c70e80  ! 1613: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r8
	wr_tick_cmpr_2_23:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa3, %g2
	or	%g4, 0xbb, %g4
	or	%g6, 0x91, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdea4e000  ! 1615: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xdadcc400  ! 1616: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xdcace000  ! 1617: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	mov	0x68, %r27
	.word 0xdcf46000  ! 1619: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xd084c400  ! 1620: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r8
	.word 0xd8a5c4a0  ! 1621: STWA_R	stwa	%r12, [%r23 + %r0] 0x25
	.word 0xdad44400  ! 1622: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	mov	0x78, %r19
	.word 0xd6c584a0  ! 1624: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r11
	.word 0xd8d4e000  ! 1625: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	wr_tick_cmpr_2_24:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x89, %g2
	or	%g4, 0xbd, %g4
	or	%g6, 0xbc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x50, %r25
	.word 0xd0c4c400  ! 1628: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	.word 0xd0f78e40  ! 1629: STXA_R	stxa	%r8, [%r30 + %r0] 0x72
	.word 0xda8cc400  ! 1630: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	mov	0x10, %r25
	mov	0x38, %r25
	.word 0xd8944400  ! 1633: LDUHA_R	lduha	[%r17, %r0] 0x20, %r12
	mov	0x20, %r16
	.word 0xdef649e0  ! 1635: STXA_R	stxa	%r15, [%r25 + %r0] 0x4f
	.word 0xdeb70e60  ! 1636: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	.word 0xde8ce000  ! 1637: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	.word 0xdeb42000  ! 1638: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xdea46000  ! 1640: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	wr_tick_cmpr_2_25:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd0, %g2
	or	%g4, 0xa6, %g4
	or	%g6, 0xcd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2c48400  ! 1642: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0xd0a44400  ! 1643: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0x87802073  ! 1644: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdedee000  ! 1645: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r15
	mov	0x7c0, %r23
	mov	0x3c8, %r22
	mov	0x20, %r18
	.word 0xdcbc0400  ! 1649: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0x87802074  ! 1650: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b609e0  ! 1651: STHA_R	stha	%r8, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 1652: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb5c4a0  ! 1653: STHA_R	stha	%r15, [%r23 + %r0] 0x25
	.word 0xdec42000  ! 1654: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0xde8ca000  ! 1655: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	mov	0x78, %r16
	.word 0xd0f4c400  ! 1657: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	wr_tick_cmpr_2_26:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc5, %g2
	or	%g4, 0xd1, %g4
	or	%g6, 0x9b, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2d7ce40  ! 1659: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r9
	.word 0xdcd78e60  ! 1660: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r14
	mov	0x3d0, %r23
	.word 0xd6cfce60  ! 1662: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r11
	mov	0x7f8, %r20
	.word 0xd8c4a000  ! 1664: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r12
	.word 0xd8cf4e60  ! 1665: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r12
	.word 0xdcbca000  ! 1666: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	mov	0x70, %r27
	.word 0xd0aec9e0  ! 1668: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	.word 0xd0aec9e0  ! 1669: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	.word 0xd8b4e000  ! 1670: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	mov	0x70, %r27
	mov	0x58, %r25
	.word 0x87802072  ! 1673: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8dd6000  ! 1674: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r12
	.word 0xdcbfce80  ! 1675: STDA_R	stda	%r14, [%r31 + %r0] 0x74
	.word 0xdaa40400  ! 1676: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802073  ! 1678: WRASI_I	wr	%r0, 0x0073, %asi
	wr_tick_cmpr_2_27:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xde, %g2
	or	%g4, 0xf6, %g4
	or	%g6, 0xce, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4af0e60  ! 1680: STBA_R	stba	%r10, [%r28 + %r0] 0x73
	.word 0xd0c40400  ! 1681: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	.word 0xde84c400  ! 1682: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0xd8a7e000  ! 1683: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd88f2000  ! 1684: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0xd88f2000  ! 1685: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0x87802072  ! 1686: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8ac2000  ! 1687: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	mov	0x60, %r25
	.word 0xd88ce000  ! 1689: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	.word 0xdaf584a0  ! 1690: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	.word 0x87802020  ! 1691: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1692: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1693: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1694: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6bf0e40  ! 1695: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	.word 0xd2bf6000  ! 1696: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	mov	0x70, %r27
	mov	0x70, %r26
	.word 0xd2af2000  ! 1699: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1700: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9609e0  ! 1701: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r15
	mov	0x60, %r16
	.word 0xd4a72000  ! 1703: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4a76000  ! 1704: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4f76000  ! 1705: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4d7e000  ! 1706: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1707: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1708: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b76000  ! 1709: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	mov	0x7e8, %r23
	mov	0x38, %r25
	.word 0xda8e89e0  ! 1712: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r13
	.word 0xd4af2000  ! 1713: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xd8d78e80  ! 1715: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r12
	mov	0x10, %r25
	mov	0x28, %r19
	mov	0x60, %r26
	.word 0xdcbf0e40  ! 1719: STDA_R	stda	%r14, [%r28 + %r0] 0x72
	.word 0xdcf70e80  ! 1720: STXA_R	stxa	%r14, [%r28 + %r0] 0x74
	.word 0xd2bfe000  ! 1721: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 1722: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdedf0e80  ! 1723: LDXA_R	ldxa	[%r28, %r0] 0x74, %r15
	mov	0x7e0, %r20
	.word 0x8780204f  ! 1725: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeb4c400  ! 1726: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xdaf62000  ! 1727: STXA_I	stxa	%r13, [%r24 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdcdd44a0  ! 1729: LDXA_R	ldxa	[%r21, %r0] 0x25, %r14
	.word 0xda9dc4a0  ! 1730: LDDA_R	ldda	[%r23, %r0] 0x25, %r13
	.word 0xdcb40400  ! 1731: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xd28584a0  ! 1732: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r9
	mov	0x60, %r19
	.word 0xd6b78e60  ! 1734: STHA_R	stha	%r11, [%r30 + %r0] 0x73
	.word 0x87802073  ! 1735: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcc7e000  ! 1736: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0xd29f0e40  ! 1737: LDDA_R	ldda	[%r28, %r0] 0x72, %r9
	.word 0xd28f6000  ! 1738: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd0dc0400  ! 1739: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0x87802074  ! 1740: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdad7a000  ! 1741: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0xd6a40400  ! 1742: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0xd09fce40  ! 1743: LDDA_R	ldda	[%r31, %r0] 0x72, %r8
	.word 0x8780204f  ! 1744: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdad78e80  ! 1745: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r13
	.word 0xdaf5e000  ! 1746: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	mov	0x7c8, %r22
	.word 0xd2a78e40  ! 1748: STWA_R	stwa	%r9, [%r30 + %r0] 0x72
	.word 0x87802072  ! 1749: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8ac4400  ! 1750: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xdab7a000  ! 1751: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdabf2000  ! 1752: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xdac76000  ! 1753: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	mov	0x28, %r18
	mov	0x60, %r17
	.word 0xd68544a0  ! 1756: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r11
	mov	0x40, %r19
	mov	0x20, %r26
	.word 0xde84c400  ! 1759: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0xd894c400  ! 1760: LDUHA_R	lduha	[%r19, %r0] 0x20, %r12
	.word 0xde9f6000  ! 1761: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	mov	0x10, %r16
	.word 0x87802025  ! 1763: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8878e40  ! 1764: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r12
	.word 0xdaac0400  ! 1765: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xd6af2000  ! 1766: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd6afe000  ! 1767: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x60, %r24
	.word 0xd6878e40  ! 1769: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r11
	.word 0x87802025  ! 1770: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2afa000  ! 1771: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 1772: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r17
	mov	0x7d0, %r21
	.word 0xd897ce40  ! 1775: LDUHA_R	lduha	[%r31, %r0] 0x72, %r12
	mov	0x70, %r18
	.word 0xdaa46000  ! 1777: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	.word 0xd8f78e80  ! 1778: STXA_R	stxa	%r12, [%r30 + %r0] 0x74
	.word 0x87802025  ! 1779: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r19
	mov	0x7c8, %r22
	mov	0x50, %r25
	.word 0xdcafa000  ! 1783: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xdcc76000  ! 1784: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	mov	0x68, %r27
	.word 0xdcf72000  ! 1786: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	mov	0x20, %r25
	.word 0x87802074  ! 1788: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc95e000  ! 1789: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r14
	.word 0xd8978e40  ! 1790: LDUHA_R	lduha	[%r30, %r0] 0x72, %r12
	.word 0xd2b56000  ! 1791: STHA_I	stha	%r9, [%r21 + 0x0000] %asi
	.word 0xd2c78e60  ! 1792: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r9
	.word 0xd0b70e60  ! 1793: STHA_R	stha	%r8, [%r28 + %r0] 0x73
	.word 0xdeb48400  ! 1794: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0x87802072  ! 1795: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r19
	.word 0xded4a000  ! 1797: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	.word 0xdea42000  ! 1798: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 1799: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r16
	.word 0xdabdc4a0  ! 1801: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	.word 0xdef7ce60  ! 1802: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0xd09fce40  ! 1803: LDDA_R	ldda	[%r31, %r0] 0x72, %r8
	.word 0xdacf6000  ! 1804: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xdaaf2000  ! 1805: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdaf7a000  ! 1806: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xdab76000  ! 1808: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1809: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda872000  ! 1810: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	mov	0x7f0, %r22
	.word 0xdaf7a000  ! 1812: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xd0a7ce80  ! 1813: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	mov	0x38, %r16
	.word 0x87802074  ! 1815: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd88544a0  ! 1816: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r12
	.word 0xd2d504a0  ! 1817: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r9
	.word 0x87802020  ! 1818: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r27
	.word 0x8780204f  ! 1820: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f76000  ! 1821: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4bf2000  ! 1822: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802072  ! 1824: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb584a0  ! 1825: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	.word 0xdaf44400  ! 1826: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	mov	0x70, %r27
	.word 0xd2cc8400  ! 1828: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0xd0f66000  ! 1829: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	.word 0xd08ea000  ! 1830: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r8
	.word 0x87802074  ! 1831: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0ce89e0  ! 1832: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r8
	.word 0xdca48400  ! 1833: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	mov	0x7d0, %r20
	.word 0x87802025  ! 1835: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r27
	.word 0x87802025  ! 1837: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc8de000  ! 1838: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r14
	.word 0xdc95e000  ! 1839: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r14
	.word 0xd2b6c9e0  ! 1840: STHA_R	stha	%r9, [%r27 + %r0] 0x4f
	.word 0xd0b52000  ! 1841: STHA_I	stha	%r8, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 1842: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdead84a0  ! 1843: STBA_R	stba	%r15, [%r22 + %r0] 0x25
	.word 0xd49f8e60  ! 1844: LDDA_R	ldda	[%r30, %r0] 0x73, %r10
	mov	0x40, %r16
	.word 0xda846000  ! 1846: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r13
	.word 0x87802074  ! 1847: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd48f0e40  ! 1848: LDUBA_R	lduba	[%r28, %r0] 0x72, %r10
	.word 0xd0df2000  ! 1849: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1850: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ac2000  ! 1851: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	mov	0x68, %r16
	mov	0x68, %r26
	mov	0x60, %r26
	.word 0x87802072  ! 1855: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r24
	.word 0xdadf8e40  ! 1857: LDXA_R	ldxa	[%r30, %r0] 0x72, %r13
	.word 0xdebcc400  ! 1858: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	.word 0xda87ce40  ! 1859: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r13
	.word 0x87802020  ! 1860: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0c4e000  ! 1861: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1862: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 1863: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r18
	.word 0xd0cfa000  ! 1865: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0x87802072  ! 1866: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r26
	.word 0xd69cc400  ! 1868: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	mov	0x30, %r17
	.word 0xd0b76000  ! 1870: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd0dfa000  ! 1871: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	mov	0x20, %r24
	.word 0xd0cfe000  ! 1873: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xd0d7e000  ! 1874: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	mov	0x0, %r24
	.word 0xd0dfa000  ! 1876: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0x87802073  ! 1877: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r19
	mov	0x28, %r19
	.word 0xd4ac8400  ! 1880: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0xd6adc4a0  ! 1881: STBA_R	stba	%r11, [%r23 + %r0] 0x25
	mov	0x3e8, %r21
	mov	0x18, %r18
	.word 0xdef46000  ! 1884: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 1885: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1886: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda978e80  ! 1887: LDUHA_R	lduha	[%r30, %r0] 0x74, %r13
	mov	0x10, %r17
	.word 0xd4d4a000  ! 1889: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	mov	0x0, %r26
	.word 0xdaa4c400  ! 1891: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0xd4f46000  ! 1892: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0xdaa584a0  ! 1893: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	.word 0xdca4e000  ! 1894: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 1895: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca7e000  ! 1896: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xdea48400  ! 1898: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xd8f7e000  ! 1899: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd4bd84a0  ! 1900: STDA_R	stda	%r10, [%r22 + %r0] 0x25
	mov	0x8, %r27
	.word 0xda972000  ! 1902: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0xd2dd84a0  ! 1903: LDXA_R	ldxa	[%r22, %r0] 0x25, %r9
	ta	T_CHANGE_PRIV	! macro
	.word 0xd6cfe000  ! 1905: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	mov	0x7e0, %r20
	mov	0x3c0, %r20
	mov	0x58, %r24
	.word 0x87802020  ! 1909: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6956000  ! 1910: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r11
	mov	0x60, %r27
	.word 0xdac74e40  ! 1912: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r13
	.word 0xd0bde000  ! 1913: STDA_I	stda	%r8, [%r23 + 0x0000] %asi
	.word 0xd0ad04a0  ! 1914: STBA_R	stba	%r8, [%r20 + %r0] 0x25
	.word 0xdcdd6000  ! 1915: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r14
	.word 0x87802025  ! 1916: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4dcc400  ! 1917: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0xd2f4c400  ! 1918: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xdcbc4400  ! 1919: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0x87802020  ! 1920: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r25
	.word 0xdabcc400  ! 1922: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	.word 0xd6cde000  ! 1923: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r11
	.word 0xdecf4e40  ! 1924: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r15
	mov	0x7d0, %r22
	mov	0x3f8, %r20
	.word 0x87802074  ! 1927: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf78e40  ! 1928: STXA_R	stxa	%r13, [%r30 + %r0] 0x72
	.word 0xd2dcc400  ! 1929: LDXA_R	ldxa	[%r19, %r0] 0x20, %r9
	.word 0x87802020  ! 1930: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r23
	.word 0x87802074  ! 1932: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a74e80  ! 1933: STWA_R	stwa	%r8, [%r29 + %r0] 0x74
	.word 0xd4bdc4a0  ! 1934: STDA_R	stda	%r10, [%r23 + %r0] 0x25
	.word 0xdef70e80  ! 1935: STXA_R	stxa	%r15, [%r28 + %r0] 0x74
	.word 0xd8b7ce60  ! 1936: STHA_R	stha	%r12, [%r31 + %r0] 0x73
	.word 0xdede6000  ! 1937: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r15
	.word 0xded62000  ! 1938: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r15
	.word 0xdeb6e000  ! 1939: STHA_I	stha	%r15, [%r27 + 0x0000] %asi
	.word 0xdeaea000  ! 1940: STBA_I	stba	%r15, [%r26 + 0x0000] %asi
	.word 0xde866000  ! 1941: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r15
	.word 0xd6f544a0  ! 1942: STXA_R	stxa	%r11, [%r21 + %r0] 0x25
	.word 0xdaf7ce80  ! 1943: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	mov	0x68, %r27
	.word 0xd2af4e80  ! 1945: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	.word 0xd08d44a0  ! 1946: LDUBA_R	lduba	[%r21, %r0] 0x25, %r8
	.word 0x87802020  ! 1947: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1948: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabc6000  ! 1949: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 1950: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadce000  ! 1951: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xdaf42000  ! 1952: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0xd8970e40  ! 1953: LDUHA_R	lduha	[%r28, %r0] 0x72, %r12
	.word 0xdc9ca000  ! 1954: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r14
	.word 0xde8c4400  ! 1955: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	.word 0xdeb4c400  ! 1956: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xda8ce000  ! 1957: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	.word 0xdab46000  ! 1958: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	mov	0x3d8, %r21
	.word 0x8780204f  ! 1960: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1961: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac689e0  ! 1962: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r13
	mov	0x7d8, %r23
	mov	0x30, %r16
	mov	0x18, %r27
	.word 0xd0df6000  ! 1966: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	mov	0x10, %r24
	mov	0x28, %r17
	.word 0x87802074  ! 1969: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r19
	mov	0x3e0, %r22
	mov	0x20, %r27
	.word 0xd0cc6000  ! 1973: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	mov	0x10, %r17
	.word 0xd09c6000  ! 1975: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r8
	mov	0x18, %r19
	mov	0x58, %r25
	.word 0xd4c78e80  ! 1978: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r10
	mov	0x3f0, %r22
	.word 0xd89c2000  ! 1980: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	.word 0xd4b74e80  ! 1981: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	.word 0xd28d44a0  ! 1982: LDUBA_R	lduba	[%r21, %r0] 0x25, %r9
	.word 0x87802025  ! 1983: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd28f4e80  ! 1984: LDUBA_R	lduba	[%r29, %r0] 0x74, %r9
	.word 0xdcd52000  ! 1985: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r14
	.word 0xd8dd04a0  ! 1986: LDXA_R	ldxa	[%r20, %r0] 0x25, %r12
	.word 0xd4b44400  ! 1987: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	mov	0x70, %r17
	.word 0xd8a52000  ! 1989: STWA_I	stwa	%r12, [%r20 + 0x0000] %asi
	.word 0xd89d2000  ! 1990: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r12
	mov	0x7c8, %r22
	.word 0xd4cd04a0  ! 1992: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r10
	mov	0x48, %r27
	mov	0x40, %r27
	.word 0x87802020  ! 1995: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1996: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2bfa000  ! 1997: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	mov	0x3d0, %r21
	.word 0xde8649e0  ! 1999: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r15
	.word 0xdcbd84a0  ! 2000: STDA_R	stda	%r14, [%r22 + %r0] 0x25
	.word 0xd8f70e40  ! 2001: STXA_R	stxa	%r12, [%r28 + %r0] 0x72
	.word 0xdcf7a000  ! 2002: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x20, %r19
	.word 0x8780204f  ! 2004: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 2005: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49584a0  ! 2006: LDUHA_R	lduha	[%r22, %r0] 0x25, %r10
	mov	0x3c0, %r23
	.word 0xd4bcc400  ! 2008: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0xd4a74e80  ! 2009: STWA_R	stwa	%r10, [%r29 + %r0] 0x74
	mov	0x58, %r17
	.word 0xd8f7e000  ! 2011: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8d7a000  ! 2012: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0xd8bf6000  ! 2013: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	mov	0x78, %r17
	.word 0xd0b74e60  ! 2015: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	.word 0x87802020  ! 2016: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2017: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r16
	.word 0x87802020  ! 2019: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f5a000  ! 2020: STXA_I	stxa	%r11, [%r22 + 0x0000] %asi
	.word 0xd8cf0e40  ! 2021: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r12
	.word 0xdc9d6000  ! 2022: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r14
	.word 0xdcade000  ! 2023: STBA_I	stba	%r14, [%r23 + 0x0000] %asi
	.word 0xd08c8400  ! 2024: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0xdec5a000  ! 2025: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802073  ! 2027: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeaf6000  ! 2028: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xdedfa000  ! 2029: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x18, %r16
	.word 0xdab48400  ! 2031: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0xd0f4c400  ! 2032: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0xd4f40400  ! 2033: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xdad7a000  ! 2034: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2035: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc8fce80  ! 2036: LDUBA_R	lduba	[%r31, %r0] 0x74, %r14
	.word 0xdecf6000  ! 2037: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0xdec76000  ! 2038: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xdccf4e40  ! 2039: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r14
	.word 0xd09fe000  ! 2040: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	mov	0x68, %r18
	mov	0x20, %r24
	.word 0xd6af8e40  ! 2043: STBA_R	stba	%r11, [%r30 + %r0] 0x72
	mov	0x10, %r16
	.word 0x87802020  ! 2045: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bcc400  ! 2046: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0xd0a66000  ! 2047: STWA_I	stwa	%r8, [%r25 + 0x0000] %asi
	mov	0x18, %r19
	mov	0x3c8, %r23
	.word 0xd4dfce80  ! 2050: LDXA_R	ldxa	[%r31, %r0] 0x74, %r10
	.word 0x87802020  ! 2051: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r16
	.word 0xd2b609e0  ! 2053: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	.word 0x87802025  ! 2054: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8d52000  ! 2055: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r12
	mov	0x30, %r26
	mov	0x28, %r17
	.word 0xd0a74e40  ! 2058: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	.word 0xdaf5e000  ! 2059: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0x87802074  ! 2061: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaaea000  ! 2062: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	.word 0x87802074  ! 2063: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabf6000  ! 2064: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 2065: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r26
	wr_tick_cmpr_2_28:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe5, %g2
	or	%g4, 0xec, %g4
	or	%g6, 0x89, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8a609e0  ! 2068: STWA_R	stwa	%r12, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 2069: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd09609e0  ! 2070: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r8
	.word 0xd4848400  ! 2071: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r10
	.word 0x87802020  ! 2072: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r18
	.word 0xdebd04a0  ! 2074: STDA_R	stda	%r15, [%r20 + %r0] 0x25
	.word 0xd696e000  ! 2075: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	.word 0xdccf4e40  ! 2076: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r14
	.word 0x87802025  ! 2077: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdef609e0  ! 2078: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	.word 0xd496e000  ! 2079: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r10
	.word 0xd4dea000  ! 2080: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	.word 0xd4f6a000  ! 2081: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	mov	0x48, %r18
	.word 0x87802072  ! 2083: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4b46000  ! 2084: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	wr_tick_cmpr_2_29:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xa6, %g2
	or	%g4, 0xa6, %g4
	or	%g6, 0xa2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8af4e80  ! 2086: STBA_R	stba	%r12, [%r29 + %r0] 0x74
	mov	0x0, %r19
	.word 0xd88d84a0  ! 2088: LDUBA_R	lduba	[%r22, %r0] 0x25, %r12
	.word 0x87802072  ! 2089: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6878e60  ! 2090: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r11
	.word 0xd8bf0e40  ! 2091: STDA_R	stda	%r12, [%r28 + %r0] 0x72
	.word 0x87802020  ! 2092: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r27
	.word 0x87802020  ! 2094: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r22
	.word 0xd8cd44a0  ! 2096: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r12
	.word 0xd4b40400  ! 2097: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	mov	0x20, %r25
	.word 0xdca4e000  ! 2099: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	mov	0x60, %r27
	mov	0x20, %r27
	.word 0xdcbca000  ! 2102: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 2103: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r17
	.word 0xdcdc2000  ! 2105: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r14
	.word 0xd8970e40  ! 2106: LDUHA_R	lduha	[%r28, %r0] 0x72, %r12
	.word 0xd88ce000  ! 2107: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	.word 0xd2adc4a0  ! 2108: STBA_R	stba	%r9, [%r23 + %r0] 0x25
	.word 0xd2d46000  ! 2109: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	.word 0xd8af0e60  ! 2110: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	.word 0xd8df8e40  ! 2111: LDXA_R	ldxa	[%r30, %r0] 0x72, %r12
	.word 0xd4af4e60  ! 2112: STBA_R	stba	%r10, [%r29 + %r0] 0x73
	.word 0xd8b46000  ! 2113: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0xd8dc4400  ! 2114: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0xd0c46000  ! 2115: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r8
	.word 0xd2ac0400  ! 2116: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0xdef46000  ! 2117: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xdeac2000  ! 2118: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xde94a000  ! 2119: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0xdef46000  ! 2120: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xdeac2000  ! 2121: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	mov	0x10, %r19
	.word 0xdeb46000  ! 2123: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0xdea584a0  ! 2124: STWA_R	stwa	%r15, [%r22 + %r0] 0x25
	mov	0x70, %r16
	.word 0x87802072  ! 2126: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8dd04a0  ! 2127: LDXA_R	ldxa	[%r20, %r0] 0x25, %r12
	.word 0xd6f7ce40  ! 2128: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	mov	0x3e0, %r21
	.word 0xdecfe000  ! 2130: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	mov	0x7f0, %r20
	.word 0xdef7e000  ! 2132: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xdec76000  ! 2133: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xded76000  ! 2134: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0xd28e49e0  ! 2135: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r9
	mov	0x3e0, %r20
	.word 0xdeac8400  ! 2137: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0x87802025  ! 2138: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 2139: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a4a000  ! 2140: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	mov	0x60, %r27
	.word 0xd6bd44a0  ! 2142: STDA_R	stda	%r11, [%r21 + %r0] 0x25
	mov	0x18, %r25
	.word 0x87802020  ! 2144: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2145: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabd44a0  ! 2146: STDA_R	stda	%r13, [%r21 + %r0] 0x25
	.word 0xd2d7ce80  ! 2147: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r9
	.word 0xdcf689e0  ! 2148: STXA_R	stxa	%r14, [%r26 + %r0] 0x4f
	.word 0x87802072  ! 2149: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 2150: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 2151: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 2152: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8952000  ! 2153: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r12
	.word 0xd89de000  ! 2154: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r12
	.word 0x87802073  ! 2155: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8d689e0  ! 2156: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r12
	.word 0xdea7ce40  ! 2157: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	.word 0xdc9fce80  ! 2158: LDDA_R	ldda	[%r31, %r0] 0x74, %r14
	.word 0xd4d52000  ! 2159: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r10
	.word 0x87802073  ! 2160: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e0, %r20
	.word 0xd0f7ce80  ! 2162: STXA_R	stxa	%r8, [%r31 + %r0] 0x74
	.word 0xdecfe000  ! 2163: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xd09584a0  ! 2164: LDUHA_R	lduha	[%r22, %r0] 0x25, %r8
	.word 0xdca7e000  ! 2165: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcc76000  ! 2166: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xdc872000  ! 2167: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcc76000  ! 2168: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2169: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r22
	.word 0xdcf7ce80  ! 2171: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	wr_tick_cmpr_2_30:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xca, %g2
	or	%g4, 0x97, %g4
	or	%g6, 0xfa, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdc8fa000  ! 2173: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdcc7a000  ! 2174: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xdc8fa000  ! 2175: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xde97ce40  ! 2176: LDUHA_R	lduha	[%r31, %r0] 0x72, %r15
	.word 0x87802074  ! 2177: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2178: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2179: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd09c2000  ! 2180: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r8
	.word 0xdcac4400  ! 2181: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	.word 0xd694e000  ! 2182: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r11
	.word 0xd6946000  ! 2183: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r11
	mov	0x7e8, %r23
	.word 0xd6d4e000  ! 2185: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r11
	mov	0x38, %r17
	.word 0xd6b46000  ! 2187: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 2188: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6cf6000  ! 2189: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd0d584a0  ! 2190: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r8
	.word 0xd6b72000  ! 2191: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd6dc4400  ! 2192: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xd0b584a0  ! 2193: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	.word 0xda974e60  ! 2194: LDUHA_R	lduha	[%r29, %r0] 0x73, %r13
	.word 0xda97a000  ! 2195: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xdaa76000  ! 2196: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 2197: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 2198: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcac0400  ! 2199: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xd4dec9e0  ! 2200: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r10
	.word 0xdec44400  ! 2201: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0xd6a6a000  ! 2202: STWA_I	stwa	%r11, [%r26 + 0x0000] %asi
	.word 0xd6cee000  ! 2203: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r11
	.word 0xd29689e0  ! 2204: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r9
	.word 0xd0f649e0  ! 2205: STXA_R	stxa	%r8, [%r25 + %r0] 0x4f
	.word 0xdef544a0  ! 2206: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	.word 0xd0b6e000  ! 2207: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	.word 0xd89f4e40  ! 2208: LDDA_R	ldda	[%r29, %r0] 0x72, %r12
	.word 0x87802020  ! 2209: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef4c400  ! 2210: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xdcf6e000  ! 2211: STXA_I	stxa	%r14, [%r27 + 0x0000] %asi
	mov	0x8, %r16
	.word 0x87802025  ! 2213: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4948400  ! 2214: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	mov	0x7f0, %r20
	.word 0xdef78e80  ! 2216: STXA_R	stxa	%r15, [%r30 + %r0] 0x74
	.word 0xd8cfa000  ! 2217: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd49fce40  ! 2218: LDDA_R	ldda	[%r31, %r0] 0x72, %r10
	.word 0xd2f689e0  ! 2219: STXA_R	stxa	%r9, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 2220: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r26
	.word 0xd2cfe000  ! 2222: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	.word 0x87802072  ! 2223: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2224: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r18
	.word 0xd2bfce80  ! 2226: STDA_R	stda	%r9, [%r31 + %r0] 0x74
	mov	0x3f0, %r23
	.word 0xd6bfe000  ! 2228: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd4bcc400  ! 2229: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	mov	0x38, %r19
	.word 0x87802025  ! 2231: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda9c6000  ! 2232: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xdcaf8e60  ! 2233: STBA_R	stba	%r14, [%r30 + %r0] 0x73
	wr_tick_cmpr_2_31:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc3, %g2
	or	%g4, 0xf2, %g4
	or	%g6, 0xe5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802025  ! 2235: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0bf4e60  ! 2236: STDA_R	stda	%r8, [%r29 + %r0] 0x73
	.word 0xd8ce09e0  ! 2237: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r12
	.word 0xd0c5c4a0  ! 2238: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r8
	.word 0xdac7e000  ! 2239: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xdeb4c400  ! 2240: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	mov	0x3d0, %r23
	.word 0x87802073  ! 2242: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r25
	.word 0xd2cfe000  ! 2244: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	mov	0x3e0, %r20
	.word 0x8780204f  ! 2246: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd28c2000  ! 2247: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd48c0400  ! 2249: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	.word 0xdc8c2000  ! 2250: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r14
	.word 0xd4f78e80  ! 2251: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	mov	0x7f0, %r20
	.word 0x8780204f  ! 2253: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda978e40  ! 2254: LDUHA_R	lduha	[%r30, %r0] 0x72, %r13
	mov	0x70, %r16
	.word 0xd8a649e0  ! 2256: STWA_R	stwa	%r12, [%r25 + %r0] 0x4f
	.word 0xdea70e40  ! 2257: STWA_R	stwa	%r15, [%r28 + %r0] 0x72
	.word 0x87802073  ! 2258: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r27
	mov	0x3f0, %r20
	.word 0x87802020  ! 2261: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdc6000  ! 2262: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	mov	0x3e0, %r23
	mov	0x68, %r26
	.word 0xdcf6c9e0  ! 2265: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	.word 0xdc9f0e60  ! 2266: LDDA_R	ldda	[%r28, %r0] 0x73, %r14
	.word 0xd4c7ce80  ! 2267: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r10
	.word 0x87802072  ! 2268: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a44400  ! 2269: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xd89d44a0  ! 2270: LDDA_R	ldda	[%r21, %r0] 0x25, %r12
	mov	0x78, %r18
	.word 0x87802074  ! 2272: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcddc4a0  ! 2273: LDXA_R	ldxa	[%r23, %r0] 0x25, %r14
	.word 0xd4a48400  ! 2274: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xd4af4e60  ! 2275: STBA_R	stba	%r10, [%r29 + %r0] 0x73
	mov	0x0, %r24
	mov	0x40, %r17
	mov	0x50, %r17
	.word 0xd0dc4400  ! 2279: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	.word 0xd084c400  ! 2280: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r8
	.word 0x87802020  ! 2281: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b4a000  ! 2282: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	mov	0x70, %r19
	mov	0x10, %r27
	.word 0xd8b4e000  ! 2285: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0xd6bec9e0  ! 2286: STDA_R	stda	%r11, [%r27 + %r0] 0x4f
	.word 0xda8f0e60  ! 2287: LDUBA_R	lduba	[%r28, %r0] 0x73, %r13
	mov	0x0, %r17
	.word 0xdaacc400  ! 2289: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	mov	0x7d0, %r21
	.word 0xd69cc400  ! 2291: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	.word 0xd0d504a0  ! 2292: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r8
	.word 0xd28e09e0  ! 2293: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r9
	mov	0x3f8, %r22
	.word 0xd09e89e0  ! 2295: LDDA_R	ldda	[%r26, %r0] 0x4f, %r8
	.word 0xd2948400  ! 2296: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	.word 0xda8c8400  ! 2297: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	.word 0xda846000  ! 2298: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r13
	.word 0xdaac6000  ! 2299: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	.word 0xdaf4e000  ! 2300: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xdabca000  ! 2301: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdab46000  ! 2302: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 2303: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r22
	.word 0xdace2000  ! 2305: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 2306: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r24
	.word 0x87802073  ! 2308: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdabca000  ! 2309: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 2310: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r25
	.word 0x87802074  ! 2312: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2d74e80  ! 2313: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r9
	.word 0xd68de000  ! 2314: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r11
	.word 0xd6c5e000  ! 2315: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r11
	.word 0xd68d2000  ! 2316: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r11
	.word 0xd6b56000  ! 2317: STHA_I	stha	%r11, [%r21 + 0x0000] %asi
	.word 0xdcdd04a0  ! 2318: LDXA_R	ldxa	[%r20, %r0] 0x25, %r14
	.word 0xdab44400  ! 2319: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0xdea4c400  ! 2320: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	mov	0x30, %r27
	mov	0x30, %r27
	mov	0x30, %r19
	.word 0xd6852000  ! 2324: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r11
	.word 0xd6ade000  ! 2325: STBA_I	stba	%r11, [%r23 + 0x0000] %asi
	.word 0xd6f5a000  ! 2326: STXA_I	stxa	%r11, [%r22 + 0x0000] %asi
	.word 0xd6b52000  ! 2327: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	mov	0x3f8, %r23
	.word 0x87802074  ! 2329: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 2330: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r26
	.word 0xd6af0e40  ! 2332: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	mov	0x7f0, %r22
	.word 0xdeafce80  ! 2334: STBA_R	stba	%r15, [%r31 + %r0] 0x74
	.word 0xd6b689e0  ! 2335: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	.word 0xd6be89e0  ! 2336: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	mov	0x48, %r27
	mov	0x3e0, %r20
	mov	0x3c8, %r20
	.word 0xd4afce80  ! 2340: STBA_R	stba	%r10, [%r31 + %r0] 0x74
	.word 0xdabda000  ! 2341: STDA_I	stda	%r13, [%r22 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xd4f70e40  ! 2343: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	mov	0x70, %r16
	mov	0x28, %r26
	.word 0xd6cec9e0  ! 2346: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r11
	.word 0xdcc4c400  ! 2347: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	.word 0xdef78e80  ! 2348: STXA_R	stxa	%r15, [%r30 + %r0] 0x74
	.word 0xdec5a000  ! 2349: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r15
	.word 0x87802073  ! 2350: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 2351: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdecf6000  ! 2352: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 2353: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebfa000  ! 2354: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 2355: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeb7e000  ! 2356: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 2357: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r24
	.word 0x87802073  ! 2359: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 2360: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb72000  ! 2361: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xd48f4e60  ! 2362: LDUBA_R	lduba	[%r29, %r0] 0x73, %r10
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd287e000  ! 2364: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0xd687ce60  ! 2365: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r11
	mov	0x70, %r26
	mov	0x50, %r19
	.word 0xd4f70e40  ! 2368: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	.word 0xd4a504a0  ! 2369: STWA_R	stwa	%r10, [%r20 + %r0] 0x25
	mov	0x3e0, %r21
	.word 0xd08fe000  ! 2371: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	.word 0xdeb7ce40  ! 2372: STHA_R	stha	%r15, [%r31 + %r0] 0x72
	mov	0x10, %r17
	.word 0xd6948400  ! 2374: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	mov	0x60, %r25
	mov	0x7c0, %r20
	mov	0x40, %r17
	.word 0x87802025  ! 2378: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaa7ce80  ! 2379: STWA_R	stwa	%r13, [%r31 + %r0] 0x74
	mov	0x3e8, %r21
	.word 0x8780204f  ! 2381: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdccfa000  ! 2382: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xdcc76000  ! 2383: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xd0dc4400  ! 2384: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	mov	0x7d8, %r22
	.word 0xd8a78e80  ! 2386: STWA_R	stwa	%r12, [%r30 + %r0] 0x74
	.word 0xd8b76000  ! 2387: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd8bfa000  ! 2388: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xde8fce80  ! 2389: LDUBA_R	lduba	[%r31, %r0] 0x74, %r15
	.word 0x87802020  ! 2390: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r26
	.word 0x87802020  ! 2392: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_2_32:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x94, %g2
	or	%g4, 0xcc, %g4
	or	%g6, 0x9e, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdedd44a0  ! 2394: LDXA_R	ldxa	[%r21, %r0] 0x25, %r15
	.word 0xd2dc2000  ! 2395: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r9
	.word 0xd4bf8e80  ! 2396: STDA_R	stda	%r10, [%r30 + %r0] 0x74
	.word 0xd0dca000  ! 2397: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	.word 0xdcd609e0  ! 2398: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r14
	mov	0x58, %r25
	.word 0xd0dd04a0  ! 2400: LDXA_R	ldxa	[%r20, %r0] 0x25, %r8
	.word 0x87802020  ! 2401: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f5a000  ! 2402: STXA_I	stxa	%r8, [%r22 + 0x0000] %asi
	mov	0x20, %r25
	.word 0xd2d7ce80  ! 2404: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r9
	.word 0x87802073  ! 2405: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r25
	mov	0x70, %r26
	.word 0xd8c78e40  ! 2408: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r12
	wr_tick_cmpr_2_33:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd5, %g2
	or	%g4, 0x8c, %g4
	or	%g6, 0xd6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3f0, %r20
	.word 0xd0dfce80  ! 2411: LDXA_R	ldxa	[%r31, %r0] 0x74, %r8
	.word 0xd6d5c4a0  ! 2412: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r11
	.word 0x87802072  ! 2413: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f649e0  ! 2414: STXA_R	stxa	%r11, [%r25 + %r0] 0x4f
	.word 0xd4b42000  ! 2415: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0x87802025  ! 2417: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r26
	.word 0xd2a689e0  ! 2419: STWA_R	stwa	%r9, [%r26 + %r0] 0x4f
	.word 0xd29c6000  ! 2420: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	mov	0x60, %r19
	.word 0xd2bc2000  ! 2422: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xd2d4a000  ! 2423: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	.word 0xd6cf4e80  ! 2424: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r11
	.word 0xd49ca000  ! 2425: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd4b4a000  ! 2426: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	mov	0x7c8, %r23
	.word 0xd0af8e60  ! 2428: STBA_R	stba	%r8, [%r30 + %r0] 0x73
	.word 0xd4ac4400  ! 2429: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xd8842000  ! 2430: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	mov	0x60, %r25
	.word 0x87802025  ! 2432: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2a74e60  ! 2433: STWA_R	stwa	%r9, [%r29 + %r0] 0x73
	mov	0x7e8, %r20
	.word 0xd8af4e60  ! 2435: STBA_R	stba	%r12, [%r29 + %r0] 0x73
	mov	0x50, %r24
	mov	0x70, %r26
	.word 0xd8b70e80  ! 2438: STHA_R	stha	%r12, [%r28 + %r0] 0x74
	wr_tick_cmpr_2_34:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xcb, %g2
	or	%g4, 0xe1, %g4
	or	%g6, 0x83, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdaf7e000  ! 2440: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xd49544a0  ! 2441: LDUHA_R	lduha	[%r21, %r0] 0x25, %r10
	.word 0xdc8f2000  ! 2442: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	mov	0x58, %r27
	.word 0xd0cf0e60  ! 2444: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r8
	.word 0xd6874e40  ! 2445: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r11
	wr_tick_cmpr_2_35:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xba, %g2
	or	%g4, 0x80, %g4
	or	%g6, 0x92, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 2447: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdebf0e80  ! 2448: STDA_R	stda	%r15, [%r28 + %r0] 0x74
	.word 0xd0b76000  ! 2449: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 2450: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r24
	.word 0xd8dd44a0  ! 2452: LDXA_R	ldxa	[%r21, %r0] 0x25, %r12
	mov	0x60, %r24
	.word 0xd0a70e60  ! 2454: STWA_R	stwa	%r8, [%r28 + %r0] 0x73
	mov	0x70, %r27
	.word 0xd2a609e0  ! 2456: STWA_R	stwa	%r9, [%r24 + %r0] 0x4f
	.word 0x87802074  ! 2457: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802073  ! 2459: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeada000  ! 2460: STBA_I	stba	%r15, [%r22 + 0x0000] %asi
	.word 0xdabf0e80  ! 2461: STDA_R	stda	%r13, [%r28 + %r0] 0x74
	.word 0xdeb5e000  ! 2462: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	mov	0x3e0, %r23
	.word 0xd897ce40  ! 2464: LDUHA_R	lduha	[%r31, %r0] 0x72, %r12
	.word 0xdcf56000  ! 2465: STXA_I	stxa	%r14, [%r21 + 0x0000] %asi
	.word 0xd0f649e0  ! 2466: STXA_R	stxa	%r8, [%r25 + %r0] 0x4f
	mov	0x30, %r18
	.word 0xd89f4e40  ! 2468: LDDA_R	ldda	[%r29, %r0] 0x72, %r12
	.word 0xdcdd6000  ! 2469: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r14
	.word 0xdc9d6000  ! 2470: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r14
	.word 0xdaf5c4a0  ! 2471: STXA_R	stxa	%r13, [%r23 + %r0] 0x25
	.word 0xd8d56000  ! 2472: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r12
	.word 0xd0dc4400  ! 2473: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	.word 0x87802025  ! 2474: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad46000  ! 2475: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	mov	0x48, %r26
	mov	0x3e8, %r20
	.word 0x8780204f  ! 2478: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa4e000  ! 2479: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0xdaac6000  ! 2480: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	.word 0xda96c9e0  ! 2481: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r13
	.word 0xd8dc2000  ! 2482: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 2483: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8cfa000  ! 2484: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd2dcc400  ! 2485: LDXA_R	ldxa	[%r19, %r0] 0x20, %r9
	.word 0xdcafe000  ! 2486: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	mov	0x40, %r17
	.word 0xdc87e000  ! 2488: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcaf2000  ! 2489: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	mov	0x7e0, %r21
	.word 0xdccfa000  ! 2491: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xdccfa000  ! 2492: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xd09c8400  ! 2493: LDDA_R	ldda	[%r18, %r0] 0x20, %r8
	.word 0xd0d70e40  ! 2494: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r8
	.word 0xd48f4e60  ! 2495: LDUBA_R	lduba	[%r29, %r0] 0x73, %r10
	.word 0xdedfe000  ! 2496: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	mov	0x38, %r24
	.word 0xd884c400  ! 2498: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	.word 0xd4bfe000  ! 2499: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd4d76000  ! 2500: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	mov	0x78, %r17
	.word 0xdcafce40  ! 2502: STBA_R	stba	%r14, [%r31 + %r0] 0x72
	.word 0xd4840400  ! 2503: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	.word 0xde8fa000  ! 2504: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0xdedf2000  ! 2505: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xd2a44400  ! 2506: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xd6df6000  ! 2507: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6c72000  ! 2508: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	mov	0x18, %r18
	.word 0x87802072  ! 2510: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r16
	.word 0xdac74e80  ! 2512: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r13
	.word 0xdc9f2000  ! 2513: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xd0d48400  ! 2514: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	.word 0xd6a70e60  ! 2515: STWA_R	stwa	%r11, [%r28 + %r0] 0x73
	.word 0xd8d78e60  ! 2516: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r12
	.word 0x87802020  ! 2517: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2518: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdec76000  ! 2519: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xde872000  ! 2520: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xd4af4e40  ! 2521: STBA_R	stba	%r10, [%r29 + %r0] 0x72
	.word 0xd4af2000  ! 2522: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd8ac0400  ! 2523: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	mov	0x3d8, %r22
	.word 0xd8d7e000  ! 2525: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	mov	0x3e8, %r21
	.word 0x87802072  ! 2527: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 2528: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8dfe000  ! 2529: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xd68649e0  ! 2530: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r11
	.word 0xd8c72000  ! 2531: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	mov	0x8, %r25
	.word 0x87802073  ! 2533: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd89d2000  ! 2534: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r12
	.word 0xd8a56000  ! 2535: STWA_I	stwa	%r12, [%r21 + 0x0000] %asi
	.word 0xd8f70e40  ! 2536: STXA_R	stxa	%r12, [%r28 + %r0] 0x72
	.word 0xdcdde000  ! 2537: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	.word 0xdcad6000  ! 2538: STBA_I	stba	%r14, [%r21 + 0x0000] %asi
	.word 0xd4a78e60  ! 2539: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	.word 0xd6b78e80  ! 2540: STHA_R	stha	%r11, [%r30 + %r0] 0x74
	mov	0x7f0, %r23
	wr_tick_cmpr_2_36:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb6, %g2
	or	%g4, 0xaf, %g4
	or	%g6, 0xc8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0b5a000  ! 2543: STHA_I	stha	%r8, [%r22 + 0x0000] %asi
	.word 0xdcbc0400  ! 2544: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	mov	0x7c8, %r23
	.word 0xd0ade000  ! 2546: STBA_I	stba	%r8, [%r23 + 0x0000] %asi
	.word 0xdec504a0  ! 2547: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r15
	.word 0xd2ad2000  ! 2548: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xd2952000  ! 2549: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r9
	.word 0x87802073  ! 2550: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2cd84a0  ! 2551: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r9
	.word 0xd0a4a000  ! 2552: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 2553: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b56000  ! 2554: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	.word 0xdcc44400  ! 2555: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xdef5e000  ! 2556: STXA_I	stxa	%r15, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 2557: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r25
	.word 0xdea7a000  ! 2559: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	mov	0x40, %r17
	.word 0xded76000  ! 2561: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	mov	0x60, %r17
	.word 0xdcc584a0  ! 2563: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r14
	mov	0x7f0, %r21
	mov	0x3c0, %r22
	.word 0xdedfce80  ! 2566: LDXA_R	ldxa	[%r31, %r0] 0x74, %r15
	.word 0xdc970e80  ! 2567: LDUHA_R	lduha	[%r28, %r0] 0x74, %r14
	.word 0xd8b7a000  ! 2568: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	mov	0x58, %r27
	.word 0x87802072  ! 2570: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebf0e60  ! 2571: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	.word 0xdad7ce80  ! 2572: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r13
	.word 0xd6bec9e0  ! 2573: STDA_R	stda	%r11, [%r27 + %r0] 0x4f
	.word 0x87802073  ! 2574: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r27
	.word 0xd2f7ce80  ! 2576: STXA_R	stxa	%r9, [%r31 + %r0] 0x74
	.word 0xd8bea000  ! 2577: STDA_I	stda	%r12, [%r26 + 0x0000] %asi
	.word 0xdaa7ce80  ! 2578: STWA_R	stwa	%r13, [%r31 + %r0] 0x74
	.word 0x87802072  ! 2579: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b74e60  ! 2580: STHA_R	stha	%r12, [%r29 + %r0] 0x73
	.word 0xd2b70e80  ! 2581: STHA_R	stha	%r9, [%r28 + %r0] 0x74
	.word 0xdc944400  ! 2582: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	.word 0xd2974e60  ! 2583: LDUHA_R	lduha	[%r29, %r0] 0x73, %r9
	.word 0x87802025  ! 2584: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2be2000  ! 2585: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	.word 0xd29689e0  ! 2586: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r9
	.word 0x87802020  ! 2587: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r22
	.word 0x87802020  ! 2589: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f72000  ! 2590: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 2591: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca40400  ! 2592: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xd68e6000  ! 2593: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r11
	.word 0xd6b62000  ! 2594: STHA_I	stha	%r11, [%r24 + 0x0000] %asi
	mov	0x8, %r26
	.word 0xdcc40400  ! 2596: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	mov	0x3d0, %r22
	.word 0xd6c44400  ! 2598: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r11
	.word 0xdebee000  ! 2599: STDA_I	stda	%r15, [%r27 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xde866000  ! 2601: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r15
	mov	0x40, %r26
	mov	0x20, %r24
	.word 0xde8e49e0  ! 2604: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r15
	.word 0xd2a7ce80  ! 2605: STWA_R	stwa	%r9, [%r31 + %r0] 0x74
	.word 0xd09e09e0  ! 2606: LDDA_R	ldda	[%r24, %r0] 0x4f, %r8
	mov	0x60, %r17
	.word 0xd2cee000  ! 2608: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	.word 0xdcae89e0  ! 2609: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	.word 0xdaae2000  ! 2610: STBA_I	stba	%r13, [%r24 + 0x0000] %asi
	.word 0xdab66000  ! 2611: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0xdaa62000  ! 2612: STWA_I	stwa	%r13, [%r24 + 0x0000] %asi
	.word 0xdabe2000  ! 2613: STDA_I	stda	%r13, [%r24 + 0x0000] %asi
	.word 0xdeb584a0  ! 2614: STHA_R	stha	%r15, [%r22 + %r0] 0x25
	.word 0xdad6e000  ! 2615: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r13
	.word 0xd0d78e80  ! 2616: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r8
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd286a000  ! 2618: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r9
	.word 0x87802025  ! 2619: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcdec9e0  ! 2620: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r14
	.word 0xd8ae2000  ! 2621: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	.word 0x87802025  ! 2622: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2623: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8942000  ! 2624: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r12
	.word 0xd8a4e000  ! 2625: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xd8b4a000  ! 2626: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0xdad4c400  ! 2627: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xd4bc6000  ! 2628: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xd494a000  ! 2629: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r10
	.word 0xdabfce80  ! 2630: STDA_R	stda	%r13, [%r31 + %r0] 0x74
	.word 0xda94a000  ! 2631: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2632: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2633: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda85e000  ! 2634: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	.word 0xdaad6000  ! 2635: STBA_I	stba	%r13, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 2636: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2637: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r24
	.word 0xd08f8e80  ! 2639: LDUBA_R	lduba	[%r30, %r0] 0x74, %r8
	.word 0xd6c6e000  ! 2640: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r11
	.word 0xd6cea000  ! 2641: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	.word 0xd8878e80  ! 2642: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r12
	mov	0x3e8, %r22
	.word 0xdef70e40  ! 2644: STXA_R	stxa	%r15, [%r28 + %r0] 0x72
	.word 0x87802020  ! 2645: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcaf2000  ! 2646: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xd0de49e0  ! 2647: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r8
	.word 0xdef6c9e0  ! 2648: STXA_R	stxa	%r15, [%r27 + %r0] 0x4f
	.word 0x8780204f  ! 2649: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabfa000  ! 2650: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 2651: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 2652: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6870e80  ! 2653: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r11
	.word 0x87802020  ! 2654: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc8f2000  ! 2655: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0xdc9f2000  ! 2656: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xd4970e60  ! 2657: LDUHA_R	lduha	[%r28, %r0] 0x73, %r10
	ta	T_CHANGE_PRIV	! macro
	mov	0x20, %r25
	.word 0x87802020  ! 2660: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2661: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc942000  ! 2662: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	.word 0xdc84e000  ! 2663: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r14
	.word 0x87802074  ! 2664: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb46000  ! 2665: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 2666: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2667: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x28, %r26
	.word 0x87802073  ! 2670: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc9c6000  ! 2671: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r14
	.word 0xd8f44400  ! 2672: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0x87802025  ! 2673: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8a76000  ! 2674: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xd0dc0400  ! 2675: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xd4f609e0  ! 2676: STXA_R	stxa	%r10, [%r24 + %r0] 0x4f
	.word 0xd8cfa000  ! 2677: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd2b48400  ! 2678: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd0b7a000  ! 2679: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0xd0cf6000  ! 2681: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xdef48400  ! 2682: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xdec4c400  ! 2683: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	.word 0xd2a72000  ! 2684: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2685: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2686: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2cd6000  ! 2687: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r9
	.word 0xd2dda000  ! 2688: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r9
	.word 0xd2ad6000  ! 2689: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 2690: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d7e000  ! 2691: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	mov	0x7f0, %r21
	.word 0xd2a76000  ! 2693: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	mov	0x58, %r26
	mov	0x60, %r17
	.word 0xd2af2000  ! 2696: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd2afe000  ! 2697: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd2bfa000  ! 2698: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd28f2000  ! 2699: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	.word 0xd2c76000  ! 2700: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2a76000  ! 2701: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 2702: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdac4c400  ! 2703: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r13
	.word 0x87802073  ! 2704: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f504a0  ! 2705: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	.word 0xd6a48400  ! 2706: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0xdea76000  ! 2707: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xd29c8400  ! 2708: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	.word 0xdadf2000  ! 2709: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	mov	0x68, %r26
	.word 0x87802073  ! 2711: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda8d04a0  ! 2712: LDUBA_R	lduba	[%r20, %r0] 0x25, %r13
	mov	0x70, %r26
	.word 0xdca44400  ! 2714: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0xdcf7ce80  ! 2715: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	wr_tick_cmpr_2_37:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x8e, %g2
	or	%g4, 0xda, %g4
	or	%g6, 0xf4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x0, %r25
	.word 0xd4bda000  ! 2718: STDA_I	stda	%r10, [%r22 + 0x0000] %asi
	mov	0x18, %r25
	mov	0x68, %r27
	.word 0xd68e09e0  ! 2721: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r11
	.word 0xd4ae49e0  ! 2722: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0xd4a689e0  ! 2723: STWA_R	stwa	%r10, [%r26 + %r0] 0x4f
	mov	0x8, %r27
	.word 0xdaa584a0  ! 2725: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	.word 0x87802072  ! 2726: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r16
	.word 0xd4c504a0  ! 2728: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r10
	.word 0xdcac2000  ! 2729: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0xdcc4a000  ! 2730: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r14
	.word 0xdcaca000  ! 2731: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xdcaca000  ! 2733: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 2734: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc872000  ! 2735: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802020  ! 2737: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcc6e000  ! 2738: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r14
	.word 0x87802025  ! 2739: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcc7a000  ! 2740: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xd88c4400  ! 2741: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0xd6afa000  ! 2742: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd0c74e60  ! 2743: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r8
	.word 0xda8c8400  ! 2744: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	.word 0xd0c584a0  ! 2745: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r8
	.word 0xd4f5c4a0  ! 2746: STXA_R	stxa	%r10, [%r23 + %r0] 0x25
	.word 0xd6dd04a0  ! 2747: LDXA_R	ldxa	[%r20, %r0] 0x25, %r11
	.word 0xd8cc8400  ! 2748: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0xd8874e60  ! 2749: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r12
	mov	0x70, %r24
	mov	0x18, %r18
	.word 0xd6dfe000  ! 2752: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2753: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2754: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r27
	.word 0xd6f72000  ! 2756: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 2757: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6976000  ! 2758: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	.word 0xd6d76000  ! 2759: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	.word 0xd6f76000  ! 2760: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xd4b7ce40  ! 2762: STHA_R	stha	%r10, [%r31 + %r0] 0x72
	.word 0xd8a7e000  ! 2763: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	mov	0x78, %r25
	.word 0x8780204f  ! 2765: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8976000  ! 2766: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0xd2ac0400  ! 2767: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	mov	0x68, %r16
	.word 0xdeaf2000  ! 2769: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xd8870e60  ! 2770: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r12
	.word 0xdcbe89e0  ! 2771: STDA_R	stda	%r14, [%r26 + %r0] 0x4f
	mov	0x7c8, %r20
	mov	0x3c0, %r20
	.word 0x87802073  ! 2774: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r17
	.word 0xda9ee000  ! 2776: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r13
	mov	0x68, %r17
	.word 0xda9e6000  ! 2778: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r13
	.word 0xdaaec9e0  ! 2779: STBA_R	stba	%r13, [%r27 + %r0] 0x4f
	.word 0xdc8f4e60  ! 2780: LDUBA_R	lduba	[%r29, %r0] 0x73, %r14
	.word 0xd6f6a000  ! 2781: STXA_I	stxa	%r11, [%r26 + 0x0000] %asi
	mov	0x30, %r26
	.word 0xd6aea000  ! 2783: STBA_I	stba	%r11, [%r26 + 0x0000] %asi
	.word 0x87802073  ! 2784: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef74e80  ! 2785: STXA_R	stxa	%r15, [%r29 + %r0] 0x74
	.word 0xd0b4e000  ! 2786: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	mov	0x70, %r17
	mov	0x8, %r24
	mov	0x78, %r25
	.word 0xd2af8e40  ! 2790: STBA_R	stba	%r9, [%r30 + %r0] 0x72
	mov	0x18, %r26
	.word 0x87802072  ! 2792: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49e49e0  ! 2793: LDDA_R	ldda	[%r25, %r0] 0x4f, %r10
	.word 0xdaa5e000  ! 2794: STWA_I	stwa	%r13, [%r23 + 0x0000] %asi
	mov	0x78, %r19
	.word 0xd8a44400  ! 2796: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xdebde000  ! 2797: STDA_I	stda	%r15, [%r23 + 0x0000] %asi
	.word 0xdedd6000  ! 2798: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r15
	.word 0xdead6000  ! 2799: STBA_I	stba	%r15, [%r21 + 0x0000] %asi
	.word 0xd2ac8400  ! 2800: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xdecda000  ! 2801: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r15
	.word 0xd4f7ce80  ! 2802: STXA_R	stxa	%r10, [%r31 + %r0] 0x74
	.word 0x87802020  ! 2803: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f584a0  ! 2804: STXA_R	stxa	%r10, [%r22 + %r0] 0x25
	mov	0x48, %r24
	.word 0xd2a504a0  ! 2806: STWA_R	stwa	%r9, [%r20 + %r0] 0x25
	mov	0x0, %r25
	.word 0xd6bfe000  ! 2808: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 2809: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 2810: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r26
	.word 0xd6bf2000  ! 2812: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	mov	0x40, %r19
	mov	0x70, %r26
	.word 0xd6a7e000  ! 2815: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	mov	0x40, %r16
	mov	0x0, %r25
	.word 0xd6f76000  ! 2818: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd68f2000  ! 2820: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xd2dfce80  ! 2821: LDXA_R	ldxa	[%r31, %r0] 0x74, %r9
	.word 0xd4944400  ! 2822: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	.word 0xdcf48400  ! 2823: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	mov	0x7f8, %r21
	.word 0xd2f7a000  ! 2825: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 2826: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r25
	mov	0x30, %r27
	.word 0x87802025  ! 2829: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b7a000  ! 2830: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 2831: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f8, %r20
	.word 0xda974e60  ! 2833: LDUHA_R	lduha	[%r29, %r0] 0x73, %r13
	.word 0xdca7e000  ! 2834: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	mov	0x8, %r16
	mov	0x20, %r27
	.word 0xd0f504a0  ! 2837: STXA_R	stxa	%r8, [%r20 + %r0] 0x25
	.word 0x87802073  ! 2838: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd09f8e60  ! 2839: LDDA_R	ldda	[%r30, %r0] 0x73, %r8
	.word 0xd2af2000  ! 2840: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2841: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0af0e40  ! 2842: STBA_R	stba	%r8, [%r28 + %r0] 0x72
	.word 0xd6af6000  ! 2843: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x70, %r26
	mov	0x18, %r19
	.word 0xdef544a0  ! 2846: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	.word 0xd8de09e0  ! 2847: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r12
	.word 0xd8d7a000  ! 2848: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0xd8872000  ! 2849: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8d7a000  ! 2850: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	mov	0x50, %r17
	.word 0xd8bf6000  ! 2852: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd8d7e000  ! 2853: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	mov	0x48, %r27
	.word 0xd8dfa000  ! 2855: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd89fe000  ! 2856: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0xd8b7a000  ! 2857: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	mov	0x70, %r17
	.word 0x87802074  ! 2859: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdc948400  ! 2861: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	.word 0xd8f6e000  ! 2862: STXA_I	stxa	%r12, [%r27 + 0x0000] %asi
	.word 0x8780204f  ! 2863: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b52000  ! 2864: STHA_I	stha	%r12, [%r20 + 0x0000] %asi
	.word 0xd8f5e000  ! 2865: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802072  ! 2867: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8cf6000  ! 2868: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0x87802074  ! 2869: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 2870: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2871: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f7ce60  ! 2872: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	.word 0xd0f78e60  ! 2873: STXA_R	stxa	%r8, [%r30 + %r0] 0x73
	.word 0xd6d48400  ! 2874: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0x87802074  ! 2875: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd497ce60  ! 2876: LDUHA_R	lduha	[%r31, %r0] 0x73, %r10
	mov	0x58, %r25
	.word 0x87802020  ! 2878: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_2_38:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe4, %g2
	or	%g4, 0xf5, %g4
	or	%g6, 0xa1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xde94e000  ! 2880: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	mov	0x18, %r18
	mov	0x18, %r17
	.word 0xdcaf8e40  ! 2883: STBA_R	stba	%r14, [%r30 + %r0] 0x72
	.word 0xd0a4a000  ! 2884: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0xd0b46000  ! 2885: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0xdeaf0e40  ! 2886: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	mov	0x0, %r16
	wr_tick_cmpr_2_39:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xc4, %g2
	or	%g4, 0xc5, %g4
	or	%g6, 0xf3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0f42000  ! 2889: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	mov	0x30, %r24
	.word 0xd0d4a000  ! 2891: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	mov	0x30, %r24
	.word 0xd685c4a0  ! 2893: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r11
	.word 0xdec74e40  ! 2894: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r15
	.word 0x87802074  ! 2895: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf5a000  ! 2896: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	.word 0xd8c609e0  ! 2897: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r12
	mov	0x40, %r16
	.word 0xd8afce60  ! 2899: STBA_R	stba	%r12, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 2900: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdca78e80  ! 2901: STWA_R	stwa	%r14, [%r30 + %r0] 0x74
	.word 0xded7ce60  ! 2902: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r15
	mov	0x78, %r24
	.word 0x8780204f  ! 2904: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2cfa000  ! 2905: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	.word 0xd2f72000  ! 2906: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd2df2000  ! 2907: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	mov	0x8, %r27
	mov	0x60, %r24
	mov	0x58, %r19
	.word 0x87802074  ! 2911: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdebec9e0  ! 2912: STDA_R	stda	%r15, [%r27 + %r0] 0x4f
	.word 0xd0846000  ! 2913: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0x87802025  ! 2914: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r25
	.word 0xdcbfce80  ! 2916: STDA_R	stda	%r14, [%r31 + %r0] 0x74
	.word 0xdc9e89e0  ! 2917: LDDA_R	ldda	[%r26, %r0] 0x4f, %r14
	.word 0xdca46000  ! 2918: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 2919: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcc6e000  ! 2920: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 2921: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde87ce60  ! 2922: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r15
	.word 0xd0840400  ! 2923: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	.word 0x87802020  ! 2924: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccf0e80  ! 2925: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r14
	.word 0xd6f4a000  ! 2926: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	.word 0xd68ce000  ! 2927: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	mov	0x60, %r27
	mov	0x10, %r24
	.word 0xd2b5c4a0  ! 2930: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	.word 0xd6a78e40  ! 2931: STWA_R	stwa	%r11, [%r30 + %r0] 0x72
	.word 0xd2bdc4a0  ! 2932: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	.word 0xd0b4e000  ! 2933: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	mov	0x7f0, %r23
	mov	0x10, %r24
	mov	0x48, %r24
	.word 0xd0c78e80  ! 2937: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r8
	mov	0x58, %r17
	.word 0x8780204f  ! 2939: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbd2000  ! 2940: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	.word 0xdcf56000  ! 2941: STXA_I	stxa	%r14, [%r21 + 0x0000] %asi
	.word 0x87802074  ! 2942: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2943: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2944: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf7a000  ! 2945: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xd0bc4400  ! 2946: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	mov	0x30, %r19
	.word 0x87802074  ! 2948: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r16
	.word 0xdaaf0e60  ! 2950: STBA_R	stba	%r13, [%r28 + %r0] 0x73
	.word 0xd28689e0  ! 2951: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r9
	.word 0xdeb609e0  ! 2952: STHA_R	stha	%r15, [%r24 + %r0] 0x4f
	mov	0x3d8, %r21
	.word 0x87802072  ! 2954: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa42000  ! 2955: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0xdaa42000  ! 2956: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0xd0c7ce40  ! 2957: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r8
	mov	0x7f0, %r21
	mov	0x3c0, %r21
	.word 0xdac70e40  ! 2960: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r13
	.word 0xdaf4a000  ! 2961: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0xdabce000  ! 2962: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0xd2a78e80  ! 2963: STWA_R	stwa	%r9, [%r30 + %r0] 0x74
	.word 0xd2d4a000  ! 2964: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	.word 0xde9c8400  ! 2965: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	.word 0xd69f8e40  ! 2966: LDDA_R	ldda	[%r30, %r0] 0x72, %r11
	.word 0xd6b70e80  ! 2967: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	.word 0xd0b5c4a0  ! 2968: STHA_R	stha	%r8, [%r23 + %r0] 0x25
	.word 0xdcf74e40  ! 2969: STXA_R	stxa	%r14, [%r29 + %r0] 0x72
	.word 0xd0dc2000  ! 2970: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	mov	0x8, %r25
	.word 0x87802020  ! 2972: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0afe000  ! 2973: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xdaf7ce60  ! 2974: STXA_R	stxa	%r13, [%r31 + %r0] 0x73
	.word 0xd897a000  ! 2975: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8dfa000  ! 2977: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0x87802072  ! 2978: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde8fce80  ! 2979: LDUBA_R	lduba	[%r31, %r0] 0x74, %r15
	.word 0xd8af0e60  ! 2980: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	.word 0x87802074  ! 2981: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2a40400  ! 2982: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xd8af0e40  ! 2983: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	mov	0x7d0, %r20
	.word 0xde872000  ! 2985: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0x87802020  ! 2986: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2987: WRASI_I	wr	%r0, 0x0074, %asi
	wr_tick_cmpr_2_40:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf3, %g2
	or	%g4, 0xc3, %g4
	or	%g6, 0xf0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdabf8e60  ! 2989: STDA_R	stda	%r13, [%r30 + %r0] 0x73
	.word 0xdccc2000  ! 2990: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r14
	.word 0xd4b649e0  ! 2991: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	.word 0xd4a4e000  ! 2992: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xd89fce80  ! 2993: LDDA_R	ldda	[%r31, %r0] 0x74, %r12
	mov	0x3d0, %r22
	.word 0xd0b70e40  ! 2995: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	.word 0xdaf78e40  ! 2996: STXA_R	stxa	%r13, [%r30 + %r0] 0x72
	.word 0xd6ac6000  ! 2997: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xd0b544a0  ! 2998: STHA_R	stha	%r8, [%r21 + %r0] 0x25
	.word 0xd4d609e0  ! 2999: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r10
	mov	0x50, %r16
	.word 0xd0d4c400  ! 3001: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	.word 0xd4bf0e60  ! 3002: STDA_R	stda	%r10, [%r28 + %r0] 0x73
	.word 0xd6a46000  ! 3003: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	mov	0x70, %r27
	.word 0x87802074  ! 3005: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d8, %r23
	.word 0xd0af0e60  ! 3007: STBA_R	stba	%r8, [%r28 + %r0] 0x73
	mov	0x40, %r24
	.word 0xd4f72000  ! 3009: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	mov	0x20, %r26
	.word 0xd4b76000  ! 3011: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd4dfce60  ! 3012: LDXA_R	ldxa	[%r31, %r0] 0x73, %r10
	.word 0xdecc4400  ! 3013: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r15
	mov	0x20, %r18
	.word 0x87802073  ! 3015: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef4a000  ! 3016: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0xde942000  ! 3017: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	.word 0x87802025  ! 3018: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f8, %r20
	ta	T_CHANGE_PRIV	! macro
	.word 0xd48f8e80  ! 3021: LDUBA_R	lduba	[%r30, %r0] 0x74, %r10
	.word 0x87802020  ! 3022: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf5e000  ! 3023: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	mov	0x28, %r27
	.word 0x87802020  ! 3025: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3026: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd697ce40  ! 3027: LDUHA_R	lduha	[%r31, %r0] 0x72, %r11
	.word 0xd4cc2000  ! 3028: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	.word 0xd4a4a000  ! 3029: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xd4f4a000  ! 3031: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0xd4d4a000  ! 3033: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0x87802020  ! 3034: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeacc400  ! 3035: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0x87802020  ! 3036: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6afa000  ! 3037: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x0, %r25
	.word 0xd6976000  ! 3039: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	.word 0xd6bf6000  ! 3040: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	mov	0x68, %r24
	.word 0x87802073  ! 3042: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6b72000  ! 3043: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd68f6000  ! 3044: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0x87802025  ! 3045: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bc4400  ! 3046: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0xd29f6000  ! 3047: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	mov	0x78, %r18
	.word 0x87802074  ! 3049: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdecc4400  ! 3050: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r15
	.word 0xd0af0e60  ! 3051: STBA_R	stba	%r8, [%r28 + %r0] 0x73
	.word 0xd28c2000  ! 3052: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	mov	0x3c8, %r21
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdc8f0e40  ! 3055: LDUBA_R	lduba	[%r28, %r0] 0x72, %r14
	.word 0xdef4c400  ! 3056: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xd8d48400  ! 3057: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0xdebce000  ! 3058: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xdea4e000  ! 3059: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xdcaf4e80  ! 3060: STBA_R	stba	%r14, [%r29 + %r0] 0x74
	.word 0xde9ca000  ! 3061: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	.word 0x87802074  ! 3062: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r16
	.word 0xd4b78e80  ! 3064: STHA_R	stha	%r10, [%r30 + %r0] 0x74
	mov	0x60, %r27
	.word 0xd4dda000  ! 3066: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r10
	.word 0xdaad84a0  ! 3067: STBA_R	stba	%r13, [%r22 + %r0] 0x25
	.word 0x87802025  ! 3068: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r17
	.word 0xdea78e60  ! 3070: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	.word 0xd2bd04a0  ! 3071: STDA_R	stda	%r9, [%r20 + %r0] 0x25
	.word 0xd0d78e60  ! 3072: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r8
	.word 0xdea70e80  ! 3073: STWA_R	stwa	%r15, [%r28 + %r0] 0x74
	.word 0xd6f7a000  ! 3074: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6c7e000  ! 3075: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xd0f649e0  ! 3076: STXA_R	stxa	%r8, [%r25 + %r0] 0x4f
	mov	0x7e8, %r23
	.word 0xd2ac8400  ! 3078: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xda9f4e60  ! 3079: LDDA_R	ldda	[%r29, %r0] 0x73, %r13
	mov	0x40, %r17
	mov	0x7d8, %r22
	.word 0xd2ac4400  ! 3082: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xd08f2000  ! 3083: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	.word 0xd28f8e40  ! 3084: LDUBA_R	lduba	[%r30, %r0] 0x72, %r9
	.word 0x87802074  ! 3085: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd09e6000  ! 3086: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r8
	.word 0xd08e2000  ! 3087: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r8
	.word 0xd4a78e40  ! 3088: STWA_R	stwa	%r10, [%r30 + %r0] 0x72
	.word 0xd4866000  ! 3089: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r10
	mov	0x20, %r27
	.word 0x87802020  ! 3091: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r21
	.word 0x87802025  ! 3093: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d0, %r21
	mov	0x38, %r26
	mov	0x68, %r25
	.word 0xde9d44a0  ! 3097: LDDA_R	ldda	[%r21, %r0] 0x25, %r15
	.word 0xdec7ce80  ! 3098: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r15
	.word 0xdec74e40  ! 3099: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r15
	.word 0xd4a4e000  ! 3100: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd89cc400  ! 3102: LDDA_R	ldda	[%r19, %r0] 0x20, %r12
	.word 0xd894e000  ! 3103: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r12
	.word 0xde9cc400  ! 3104: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	.word 0xd4d42000  ! 3105: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	.word 0xd4cf0e60  ! 3106: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r10
	.word 0xd4d5c4a0  ! 3107: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r10
	mov	0x70, %r19
	.word 0x87802020  ! 3109: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4aee000  ! 3110: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0xdab70e40  ! 3112: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	.word 0xd48c4400  ! 3113: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0xd496e000  ! 3114: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r10
	.word 0x87802020  ! 3115: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 3116: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f74e60  ! 3117: STXA_R	stxa	%r9, [%r29 + %r0] 0x73
	.word 0xde8c4400  ! 3118: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	mov	0x7f0, %r20
	mov	0x3d0, %r21
	mov	0x48, %r17
	.word 0xd08f0e80  ! 3122: LDUBA_R	lduba	[%r28, %r0] 0x74, %r8
	.word 0xd2b66000  ! 3123: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	.word 0xd2cf8e60  ! 3124: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r9
	.word 0xd68d04a0  ! 3125: LDUBA_R	lduba	[%r20, %r0] 0x25, %r11
	.word 0xdcbee000  ! 3126: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	.word 0xdcae2000  ! 3127: STBA_I	stba	%r14, [%r24 + 0x0000] %asi
	.word 0xdcd6e000  ! 3128: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r14
	mov	0x70, %r16
	.word 0xd6b48400  ! 3130: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd6d6a000  ! 3131: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r11
	mov	0x0, %r16
	.word 0xd6c7ce60  ! 3133: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r11
	.word 0xdabf8e60  ! 3134: STDA_R	stda	%r13, [%r30 + %r0] 0x73
	mov	0x68, %r24
	.word 0xd6ce6000  ! 3136: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r11
	mov	0x68, %r27
	mov	0x3e0, %r22
	.word 0x87802020  ! 3139: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r23
	.word 0xd6a40400  ! 3141: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0xd6ada000  ! 3142: STBA_I	stba	%r11, [%r22 + 0x0000] %asi
	.word 0xd6d5e000  ! 3143: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r11
	.word 0xd6b52000  ! 3144: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	.word 0xd084c400  ! 3145: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r8
	.word 0x87802073  ! 3146: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f0, %r21
	.word 0xd88f0e60  ! 3148: LDUBA_R	lduba	[%r28, %r0] 0x73, %r12
	.word 0xd8c78e60  ! 3149: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r12
	mov	0x60, %r27
	.word 0xdebfce40  ! 3151: STDA_R	stda	%r15, [%r31 + %r0] 0x72
	mov	0x58, %r24
	.word 0xd0afe000  ! 3153: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0f7e000  ! 3154: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0b7a000  ! 3155: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd6d5c4a0  ! 3156: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r11
	.word 0xdebfa000  ! 3157: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xdef7a000  ! 3158: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 3159: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd49fce80  ! 3160: LDDA_R	ldda	[%r31, %r0] 0x74, %r10
	.word 0xd0cd2000  ! 3161: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r8
	.word 0xd0d56000  ! 3162: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r8
	.word 0xd2ac8400  ! 3163: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xd4870e60  ! 3164: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r10
	mov	0x58, %r24
	.word 0x87802074  ! 3166: WRASI_I	wr	%r0, 0x0074, %asi
	wr_tick_cmpr_2_41:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb9, %g2
	or	%g4, 0x9d, %g4
	or	%g6, 0xf0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2ac2000  ! 3168: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 3169: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r20
	.word 0x87802020  ! 3171: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 3172: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3173: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r27
	.word 0xd0b70e80  ! 3175: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	.word 0x87802073  ! 3176: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde97e000  ! 3177: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0xdab4c400  ! 3178: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xda8f4e60  ! 3179: LDUBA_R	lduba	[%r29, %r0] 0x73, %r13
	.word 0x8780204f  ! 3180: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4878e80  ! 3181: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r10
	.word 0xd8870e40  ! 3182: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r12
	.word 0xd2f70e80  ! 3183: STXA_R	stxa	%r9, [%r28 + %r0] 0x74
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd8cd2000  ! 3185: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r12
	.word 0x87802025  ! 3186: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bce000  ! 3187: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd8f4a000  ! 3188: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xd894a000  ! 3189: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r12
	.word 0xd8b46000  ! 3190: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0xd8f4e000  ! 3191: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 3192: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d4e000  ! 3193: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0xd8cc6000  ! 3194: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r12
	.word 0xd884e000  ! 3195: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r12
	mov	0x40, %r25
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x70, %r26
	.word 0x87802025  ! 3199: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8c72000  ! 3200: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd68ec9e0  ! 3201: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r11
	.word 0xd2a7e000  ! 3202: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xd29649e0  ! 3203: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r9
	.word 0xd48d84a0  ! 3204: LDUBA_R	lduba	[%r22, %r0] 0x25, %r10
	.word 0xda940400  ! 3205: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	mov	0x70, %r26
	.word 0xd0cf2000  ! 3207: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0xd0f76000  ! 3208: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0xd29cc400  ! 3210: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	.word 0xd8d5c4a0  ! 3211: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r12
	.word 0xd0cdc4a0  ! 3212: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r8
	mov	0x3c0, %r21
	.word 0xd6bf6000  ! 3214: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd687a000  ! 3215: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6f7e000  ! 3216: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6876000  ! 3217: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	mov	0x28, %r24
	.word 0xd4d78e40  ! 3219: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r10
	.word 0x87802020  ! 3220: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b78e80  ! 3221: STHA_R	stha	%r10, [%r30 + %r0] 0x74
	.word 0xdedc6000  ! 3222: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r15
	.word 0xde846000  ! 3223: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0xdea42000  ! 3224: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	mov	0x3d0, %r23
	.word 0xdc8c8400  ! 3226: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0x87802072  ! 3227: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r25
	.word 0xdc8f6000  ! 3229: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcf72000  ! 3230: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xd0be49e0  ! 3231: STDA_R	stda	%r8, [%r25 + %r0] 0x4f
	mov	0x3f8, %r22
	.word 0xd89f6000  ! 3233: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	.word 0xd8bfa000  ! 3234: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 3235: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd88c6000  ! 3236: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	.word 0x87802025  ! 3237: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3238: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 3239: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bde000  ! 3240: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 3241: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68fce40  ! 3242: LDUBA_R	lduba	[%r31, %r0] 0x72, %r11
	.word 0xdc948400  ! 3243: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	.word 0x87802025  ! 3244: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeac8400  ! 3245: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xdabec9e0  ! 3246: STDA_R	stda	%r13, [%r27 + %r0] 0x4f
	mov	0x40, %r16
	.word 0x87802020  ! 3248: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcde89e0  ! 3249: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r14
	mov	0x3e8, %r21
	mov	0x3d8, %r22
	.word 0xd0948400  ! 3252: LDUHA_R	lduha	[%r18, %r0] 0x20, %r8
	mov	0x8, %r26
	.word 0xd49504a0  ! 3254: LDUHA_R	lduha	[%r20, %r0] 0x25, %r10
	.word 0xd08e6000  ! 3255: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r8
	mov	0x20, %r25
	.word 0xd494c400  ! 3257: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	.word 0xd0be2000  ! 3258: STDA_I	stda	%r8, [%r24 + 0x0000] %asi
	.word 0xd0cf8e60  ! 3259: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r8
	.word 0xd2cee000  ! 3260: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	.word 0x87802072  ! 3261: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 3262: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r16
	.word 0xdebf4e40  ! 3264: STDA_R	stda	%r15, [%r29 + %r0] 0x72
	.word 0xdebfe000  ! 3265: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xdebf6000  ! 3266: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xd8bf0e60  ! 3267: STDA_R	stda	%r12, [%r28 + %r0] 0x73
	mov	0x50, %r25
	.word 0xd6aec9e0  ! 3269: STBA_R	stba	%r11, [%r27 + %r0] 0x4f
	.word 0xd0b7ce40  ! 3270: STHA_R	stha	%r8, [%r31 + %r0] 0x72
	.word 0xd49f8e60  ! 3271: LDDA_R	ldda	[%r30, %r0] 0x73, %r10
	.word 0xd6d7ce60  ! 3272: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r11
	.word 0xd4aec9e0  ! 3273: STBA_R	stba	%r10, [%r27 + %r0] 0x4f
	.word 0xdcc7e000  ! 3274: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	mov	0x18, %r27
	.word 0xdcaf6000  ! 3276: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdcc7e000  ! 3277: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0xd4c78e80  ! 3278: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r10
	wr_tick_cmpr_2_42:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x8b, %g2
	or	%g4, 0xd9, %g4
	or	%g6, 0xc4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdadfce40  ! 3280: LDXA_R	ldxa	[%r31, %r0] 0x72, %r13
	.word 0xdca7ce80  ! 3281: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	.word 0xd6f7e000  ! 3282: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6a72000  ! 3283: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd69fe000  ! 3284: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	.word 0xdec649e0  ! 3285: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r15
	.word 0xd6c74e60  ! 3286: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r11
	.word 0xd8c40400  ! 3287: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	.word 0xd084c400  ! 3288: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r8
	.word 0xd6c74e60  ! 3289: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r11
	mov	0x0, %r18
	.word 0xd89f6000  ! 3291: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	mov	0x7d8, %r21
	.word 0xd8f7e000  ! 3293: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd2df8e40  ! 3294: LDXA_R	ldxa	[%r30, %r0] 0x72, %r9
	mov	0x68, %r17
	.word 0xdef40400  ! 3296: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0xdeaf8e80  ! 3297: STBA_R	stba	%r15, [%r30 + %r0] 0x74
	.word 0xd8976000  ! 3298: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	mov	0x38, %r16
	.word 0xd8f76000  ! 3300: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8c7e000  ! 3301: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0x87802073  ! 3302: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8c4e000  ! 3303: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	.word 0xd2944400  ! 3304: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	.word 0x87802020  ! 3305: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8ce000  ! 3306: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	mov	0x3c0, %r23
	mov	0x20, %r25
	.word 0xd29f4e60  ! 3309: LDDA_R	ldda	[%r29, %r0] 0x73, %r9
	.word 0x87802073  ! 3310: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3311: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r27
	.word 0xd0ace000  ! 3313: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0xd0a42000  ! 3314: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xd4ad84a0  ! 3315: STBA_R	stba	%r10, [%r22 + %r0] 0x25
	.word 0xd2aec9e0  ! 3316: STBA_R	stba	%r9, [%r27 + %r0] 0x4f
	mov	0x50, %r19
	mov	0x3e8, %r22
	mov	0x10, %r25
	mov	0x68, %r16
	mov	0x10, %r24
	.word 0xda8c0400  ! 3322: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	.word 0xdadc6000  ! 3323: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xdead44a0  ! 3324: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	mov	0x38, %r18
	mov	0x0, %r27
	.word 0xd8d4a000  ! 3327: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xd0d5c4a0  ! 3328: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r8
	.word 0xde94e000  ! 3329: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	mov	0x0, %r24
	.word 0x87802074  ! 3331: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde9f2000  ! 3332: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	mov	0x60, %r19
	mov	0x8, %r18
	.word 0xd4dc0400  ! 3335: LDXA_R	ldxa	[%r16, %r0] 0x20, %r10
	.word 0x8780204f  ! 3336: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd69544a0  ! 3337: LDUHA_R	lduha	[%r21, %r0] 0x25, %r11
	.word 0xd8f72000  ! 3338: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	mov	0x3d0, %r23
	.word 0x87802072  ! 3340: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 3341: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r16
	.word 0xd8f4a000  ! 3343: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xd08d04a0  ! 3344: LDUBA_R	lduba	[%r20, %r0] 0x25, %r8
	.word 0xdaf74e40  ! 3345: STXA_R	stxa	%r13, [%r29 + %r0] 0x72
	.word 0xdca70e60  ! 3346: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	.word 0xda9c0400  ! 3347: LDDA_R	ldda	[%r16, %r0] 0x20, %r13
	.word 0xdcbce000  ! 3348: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	mov	0x10, %r24
	.word 0xdc878e40  ! 3350: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r14
	mov	0x0, %r17
	.word 0x87802074  ! 3352: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 3353: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3354: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde87e000  ! 3355: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdeaf2000  ! 3356: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xd2f584a0  ! 3357: STXA_R	stxa	%r9, [%r22 + %r0] 0x25
	.word 0xdecf4e60  ! 3358: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r15
	.word 0xd8c7ce40  ! 3359: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r12
	.word 0xd6bcc400  ! 3360: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	mov	0x7c8, %r20
	.word 0xd6c72000  ! 3362: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6af2000  ! 3363: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd8c70e40  ! 3364: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r12
	.word 0xd8f78e80  ! 3365: STXA_R	stxa	%r12, [%r30 + %r0] 0x74
	mov	0x3e0, %r22
	.word 0xdc8f2000  ! 3367: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0x87802072  ! 3368: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdacc8400  ! 3369: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r13
	.word 0xdabc4400  ! 3370: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xdaa72000  ! 3371: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xdaf7a000  ! 3372: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdab7e000  ! 3373: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xde95c4a0  ! 3374: LDUHA_R	lduha	[%r23, %r0] 0x25, %r15
	.word 0x87802073  ! 3375: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc95a000  ! 3376: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r14
	.word 0xdcc5e000  ! 3377: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r14
	mov	0x7d0, %r23
	.word 0x87802073  ! 3379: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc874e80  ! 3380: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r14
	.word 0xdcb62000  ! 3381: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xdcf6e000  ! 3383: STXA_I	stxa	%r14, [%r27 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xdcae2000  ! 3385: STBA_I	stba	%r14, [%r24 + 0x0000] %asi
	mov	0x30, %r19
	.word 0xd08f4e60  ! 3387: LDUBA_R	lduba	[%r29, %r0] 0x73, %r8
	mov	0x3c8, %r22
	.word 0xdc866000  ! 3389: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r14
	mov	0x78, %r18
	.word 0x87802020  ! 3391: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3392: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd88c4400  ! 3393: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0x87802073  ! 3394: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2af0e60  ! 3395: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	.word 0xd4bca000  ! 3396: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 3397: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3398: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedc0400  ! 3399: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	.word 0xd4bf4e40  ! 3400: STDA_R	stda	%r10, [%r29 + %r0] 0x72
	.word 0xdcbec9e0  ! 3401: STDA_R	stda	%r14, [%r27 + %r0] 0x4f
	.word 0xd8a4c400  ! 3402: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	mov	0x60, %r19
	.word 0x87802020  ! 3404: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8dec9e0  ! 3405: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r12
	mov	0x3e8, %r21
	.word 0xda962000  ! 3407: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r13
	.word 0xdab6e000  ! 3408: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	.word 0xdab6a000  ! 3409: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	.word 0x8780204f  ! 3410: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaace000  ! 3411: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0xdaac2000  ! 3412: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	mov	0x58, %r16
	.word 0x87802072  ! 3414: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r25
	.word 0x87802020  ! 3416: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad7ce80  ! 3417: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r13
	.word 0xd4ae2000  ! 3418: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	.word 0xd49e2000  ! 3419: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r10
	.word 0xdabd04a0  ! 3420: STDA_R	stda	%r13, [%r20 + %r0] 0x25
	.word 0x87802020  ! 3421: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabe09e0  ! 3422: STDA_R	stda	%r13, [%r24 + %r0] 0x4f
	mov	0x3e0, %r22
	.word 0xd4acc400  ! 3424: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xd8bf2000  ! 3425: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	mov	0x48, %r19
	.word 0xd08c4400  ! 3427: LDUBA_R	lduba	[%r17, %r0] 0x20, %r8
	.word 0xd2a7a000  ! 3428: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 3429: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r25
	.word 0xdec78e80  ! 3431: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r15
	.word 0xd6bfe000  ! 3432: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	mov	0x68, %r19
	.word 0xd6af6000  ! 3434: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xdedf8e40  ! 3435: LDXA_R	ldxa	[%r30, %r0] 0x72, %r15
	.word 0x87802020  ! 3436: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3437: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6ae49e0  ! 3438: STBA_R	stba	%r11, [%r25 + %r0] 0x4f
	.word 0x87802074  ! 3439: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6a7a000  ! 3440: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6bfe000  ! 3441: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xdca48400  ! 3442: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xdca7e000  ! 3443: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	mov	0x70, %r16
	.word 0xd4a5c4a0  ! 3445: STWA_R	stwa	%r10, [%r23 + %r0] 0x25
	mov	0x7e0, %r23
	.word 0x87802020  ! 3447: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r20
	.word 0xdeb78e60  ! 3449: STHA_R	stha	%r15, [%r30 + %r0] 0x73
	wr_tick_cmpr_2_43:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xad, %g2
	or	%g4, 0xfb, %g4
	or	%g6, 0xcf, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4c7e000  ! 3451: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	.word 0xdaa504a0  ! 3452: STWA_R	stwa	%r13, [%r20 + %r0] 0x25
	.word 0xd8a72000  ! 3453: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8c7a000  ! 3454: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0x87802025  ! 3455: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8cd2000  ! 3456: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r12
	.word 0xd6d504a0  ! 3457: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r11
	.word 0xd2b56000  ! 3458: STHA_I	stha	%r9, [%r21 + 0x0000] %asi
	.word 0xd2b5a000  ! 3459: STHA_I	stha	%r9, [%r22 + 0x0000] %asi
	.word 0xd2bde000  ! 3460: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	.word 0xd0f7ce80  ! 3461: STXA_R	stxa	%r8, [%r31 + %r0] 0x74
	.word 0xd2a40400  ! 3462: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	mov	0x7e0, %r21
	.word 0xd6bcc400  ! 3464: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0xd29f8e80  ! 3465: LDDA_R	ldda	[%r30, %r0] 0x74, %r9
	mov	0x8, %r17
	.word 0xd0c52000  ! 3467: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r8
	.word 0xd0b5a000  ! 3468: STHA_I	stha	%r8, [%r22 + 0x0000] %asi
	.word 0xd0dd6000  ! 3469: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r8
	.word 0x87802020  ! 3470: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r24
	.word 0xd0dca000  ! 3472: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	mov	0x20, %r26
	mov	0x78, %r18
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0cce000  ! 3476: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0bc2000  ! 3477: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 3478: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd09fe000  ! 3479: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	.word 0xd0872000  ! 3480: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	mov	0x50, %r25
	.word 0xd4bfce40  ! 3482: STDA_R	stda	%r10, [%r31 + %r0] 0x72
	.word 0xd48fa000  ! 3483: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xdeac4400  ! 3484: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0xd2976000  ! 3485: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0xd2b76000  ! 3486: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd8bf8e40  ! 3487: STDA_R	stda	%r12, [%r30 + %r0] 0x72
	mov	0x20, %r19
	.word 0xd2f48400  ! 3489: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0xd484c400  ! 3490: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	.word 0xdc974e80  ! 3491: LDUHA_R	lduha	[%r29, %r0] 0x74, %r14
	mov	0x68, %r16
	.word 0xd2af2000  ! 3493: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd2f74e40  ! 3494: STXA_R	stxa	%r9, [%r29 + %r0] 0x72
	.word 0xd0b78e40  ! 3495: STHA_R	stha	%r8, [%r30 + %r0] 0x72
	mov	0x58, %r17
	.word 0xd2d72000  ! 3497: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xd0af8e60  ! 3498: STBA_R	stba	%r8, [%r30 + %r0] 0x73
	.word 0x87802025  ! 3499: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2f74e40  ! 3500: STXA_R	stxa	%r9, [%r29 + %r0] 0x72
	mov	0x3e0, %r21
	.word 0xd0c70e40  ! 3502: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r8
	mov	0x3d0, %r21
	.word 0xd4f72000  ! 3504: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd0c48400  ! 3505: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r8
	.word 0xdaa70e80  ! 3506: STWA_R	stwa	%r13, [%r28 + %r0] 0x74
	mov	0x48, %r25
	.word 0xd4f504a0  ! 3508: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	mov	0x50, %r27
	mov	0x18, %r18
	.word 0x87802074  ! 3511: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 3512: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcd70e80  ! 3513: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r14
	.word 0xd4b72000  ! 3514: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 3515: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4d609e0  ! 3516: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r10
	mov	0x7d0, %r20
	.word 0xde85c4a0  ! 3518: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r15
	mov	0x3e0, %r22
	.word 0x87802073  ! 3520: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r19
	.word 0x87802074  ! 3522: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 3523: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r26
	.word 0xd0bd04a0  ! 3525: STDA_R	stda	%r8, [%r20 + %r0] 0x25
	mov	0x3d8, %r23
	.word 0xdc85a000  ! 3527: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r14
	.word 0xdccd6000  ! 3528: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r14
	mov	0x18, %r24
	mov	0x18, %r24
	.word 0xdc978e80  ! 3531: LDUHA_R	lduha	[%r30, %r0] 0x74, %r14
	.word 0xdeb5a000  ! 3532: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	.word 0xd0cfce60  ! 3533: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r8
	.word 0xd09fce60  ! 3534: LDDA_R	ldda	[%r31, %r0] 0x73, %r8
	mov	0x38, %r27
	.word 0x87802073  ! 3536: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r26
	.word 0xdecf0e80  ! 3538: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r15
	.word 0xd6d4e000  ! 3539: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r11
	.word 0x87802025  ! 3540: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b46000  ! 3541: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 3542: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r25
	.word 0xd6cf2000  ! 3544: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3545: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bf6000  ! 3546: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd69d04a0  ! 3547: LDDA_R	ldda	[%r20, %r0] 0x25, %r11
	.word 0x87802020  ! 3548: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcaca000  ! 3549: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xdcf42000  ! 3550: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0xdca46000  ! 3551: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xdabf0e60  ! 3552: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	.word 0xdc8f0e40  ! 3553: LDUBA_R	lduba	[%r28, %r0] 0x72, %r14
	.word 0xd0a42000  ! 3554: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	mov	0x50, %r25
	.word 0x87802073  ! 3556: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0dc6000  ! 3557: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	.word 0xd0b42000  ! 3558: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xd0b4e000  ! 3559: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	mov	0x70, %r24
	mov	0x78, %r27
	mov	0x0, %r24
	.word 0xd8b48400  ! 3563: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0x87802074  ! 3564: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r27
	mov	0x48, %r27
	.word 0xd28f6000  ! 3567: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd0a44400  ! 3568: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xd8c72000  ! 3569: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 3570: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0de49e0  ! 3571: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r8
	.word 0xd8afce60  ! 3572: STBA_R	stba	%r12, [%r31 + %r0] 0x73
	.word 0x87802020  ! 3573: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a7ce60  ! 3574: STWA_R	stwa	%r9, [%r31 + %r0] 0x73
	.word 0xdaf72000  ! 3575: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 3576: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a7ce40  ! 3577: STWA_R	stwa	%r11, [%r31 + %r0] 0x72
	.word 0xd68fa000  ! 3578: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	mov	0x10, %r17
	.word 0xd69fa000  ! 3580: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0xdea74e80  ! 3581: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	.word 0x87802073  ! 3582: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r17
	.word 0x87802072  ! 3584: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0846000  ! 3585: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0x87802074  ! 3586: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd09ea000  ! 3587: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r8
	.word 0xd0d6a000  ! 3588: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r8
	.word 0xd0b66000  ! 3589: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	mov	0x7c0, %r20
	mov	0x7d8, %r22
	.word 0xdab70e60  ! 3592: STHA_R	stha	%r13, [%r28 + %r0] 0x73
	mov	0x30, %r19
	.word 0xd2ac0400  ! 3594: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0xdabc4400  ! 3595: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xd8b6e000  ! 3596: STHA_I	stha	%r12, [%r27 + 0x0000] %asi
	.word 0xd295c4a0  ! 3597: LDUHA_R	lduha	[%r23, %r0] 0x25, %r9
	.word 0xdcde2000  ! 3598: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r14
	.word 0xdcbe2000  ! 3599: STDA_I	stda	%r14, [%r24 + 0x0000] %asi
	mov	0x3c0, %r23
	.word 0xdadcc400  ! 3601: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xdab609e0  ! 3602: STHA_R	stha	%r13, [%r24 + %r0] 0x4f
	.word 0xdea66000  ! 3603: STWA_I	stwa	%r15, [%r25 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xd0af4e60  ! 3605: STBA_R	stba	%r8, [%r29 + %r0] 0x73
	.word 0xd0de6000  ! 3606: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r8
	.word 0xd0f6a000  ! 3607: STXA_I	stxa	%r8, [%r26 + 0x0000] %asi
	.word 0xd0f66000  ! 3608: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	mov	0x10, %r19
	.word 0xd0a62000  ! 3610: STWA_I	stwa	%r8, [%r24 + 0x0000] %asi
	.word 0xd0dea000  ! 3611: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r8
	mov	0x18, %r26
	.word 0x87802073  ! 3613: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda9504a0  ! 3614: LDUHA_R	lduha	[%r20, %r0] 0x25, %r13
	.word 0xdad70e40  ! 3615: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r13
	mov	0x60, %r16
	.word 0xda85c4a0  ! 3617: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r13
	mov	0x7d0, %r20
	.word 0xdecc8400  ! 3619: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdedc0400  ! 3621: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	mov	0x18, %r27
	.word 0x87802073  ! 3623: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 3624: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd6bfe000  ! 3626: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd6a72000  ! 3627: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	mov	0x7f8, %r23
	mov	0x58, %r19
	mov	0x58, %r17
	.word 0x87802025  ! 3631: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6c5e000  ! 3632: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r11
	.word 0xd6a5e000  ! 3633: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	.word 0xd6bd2000  ! 3634: STDA_I	stda	%r11, [%r20 + 0x0000] %asi
	.word 0xdcb4c400  ! 3635: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xd4c5a000  ! 3636: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r10
	.word 0xdadf8e40  ! 3637: LDXA_R	ldxa	[%r30, %r0] 0x72, %r13
	mov	0x10, %r27
	.word 0x87802074  ! 3639: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e0, %r22
	.word 0xdcd70e40  ! 3641: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r14
	.word 0xdadc0400  ! 3642: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	mov	0x58, %r24
	.word 0xd0f74e80  ! 3644: STXA_R	stxa	%r8, [%r29 + %r0] 0x74
	.word 0xd8a584a0  ! 3645: STWA_R	stwa	%r12, [%r22 + %r0] 0x25
	wr_tick_cmpr_2_44:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xd9, %g2
	or	%g4, 0x8f, %g4
	or	%g6, 0xea, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd087ce60  ! 3647: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r8
	.word 0xd0bfce80  ! 3648: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	.word 0x87802025  ! 3649: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda946000  ! 3650: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	mov	0x7f0, %r21
	.word 0xd2b4c400  ! 3652: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xd6944400  ! 3653: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	.word 0xd6cc6000  ! 3654: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r11
	.word 0xd6ac2000  ! 3655: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	wr_tick_cmpr_2_45:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xdc, %g2
	or	%g4, 0xbf, %g4
	or	%g6, 0xb1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd684e000  ! 3657: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r11
	.word 0xd6a42000  ! 3658: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xdc9dc4a0  ! 3659: LDDA_R	ldda	[%r23, %r0] 0x25, %r14
	.word 0xd2d7ce60  ! 3660: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r9
	mov	0x48, %r26
	.word 0xd2d4a000  ! 3662: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	.word 0xd0a48400  ! 3663: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0xd4c5c4a0  ! 3664: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r10
	.word 0xdebc6000  ! 3665: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xdc978e80  ! 3666: LDUHA_R	lduha	[%r30, %r0] 0x74, %r14
	.word 0x87802072  ! 3667: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r24
	.word 0x87802073  ! 3669: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd49f0e60  ! 3670: LDDA_R	ldda	[%r28, %r0] 0x73, %r10
	.word 0xdcc5c4a0  ! 3671: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r14
	.word 0xd49c6000  ! 3672: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0xda9f0e40  ! 3673: LDDA_R	ldda	[%r28, %r0] 0x72, %r13
	.word 0x87802073  ! 3674: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd29544a0  ! 3675: LDUHA_R	lduha	[%r21, %r0] 0x25, %r9
	.word 0xdabfa000  ! 3676: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 3677: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda942000  ! 3678: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x7c0, %r20
	.word 0xd4b44400  ! 3681: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	.word 0xdebc2000  ! 3682: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	mov	0x18, %r16
	.word 0xdec46000  ! 3684: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	.word 0xd2bf4e80  ! 3685: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	.word 0xd6d42000  ! 3686: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r11
	.word 0x87802072  ! 3687: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd68f2000  ! 3688: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0x87802074  ! 3689: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcae89e0  ! 3690: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	.word 0xd0bd84a0  ! 3691: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0xdaf7ce80  ! 3692: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	mov	0x7e8, %r21
	.word 0xdcf40400  ! 3694: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xd88f6000  ! 3695: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xdcbfce40  ! 3696: STDA_R	stda	%r14, [%r31 + %r0] 0x72
	.word 0xdadfe000  ! 3697: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3698: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ae49e0  ! 3699: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0xde86e000  ! 3700: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r15
	.word 0xd0c649e0  ! 3701: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r8
	.word 0xda9e2000  ! 3702: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r13
	.word 0xdcf44400  ! 3703: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0x87802025  ! 3704: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8afe000  ! 3705: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd8dfce60  ! 3706: LDXA_R	ldxa	[%r31, %r0] 0x73, %r12
	mov	0x78, %r25
	.word 0xd4afa000  ! 3708: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xdabec9e0  ! 3709: STDA_R	stda	%r13, [%r27 + %r0] 0x4f
	.word 0xd8ac0400  ! 3710: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	mov	0x50, %r19
	.word 0xd2bfe000  ! 3712: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd0f649e0  ! 3713: STXA_R	stxa	%r8, [%r25 + %r0] 0x4f
	.word 0xd8c74e60  ! 3714: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r12
	.word 0xdcf649e0  ! 3715: STXA_R	stxa	%r14, [%r25 + %r0] 0x4f
	.word 0xde8584a0  ! 3716: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r15
	.word 0x87802020  ! 3717: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3718: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8d4e000  ! 3719: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	mov	0x40, %r25
	.word 0xd88c2000  ! 3721: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	mov	0x40, %r18
	mov	0x58, %r17
	.word 0x87802025  ! 3724: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2cd04a0  ! 3725: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r9
	mov	0x18, %r24
	.word 0xda878e60  ! 3727: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r13
	.word 0x87802072  ! 3728: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd88cc400  ! 3729: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	mov	0x30, %r16
	.word 0xdca7a000  ! 3731: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3732: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbc6000  ! 3733: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xdcaca000  ! 3734: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xd8a7ce40  ! 3735: STWA_R	stwa	%r12, [%r31 + %r0] 0x72
	mov	0x28, %r19
	.word 0xd0ace000  ! 3737: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 3738: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdecc0400  ! 3739: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r15
	mov	0x30, %r25
	.word 0xd0870e80  ! 3741: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r8
	.word 0xd0f72000  ! 3742: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	mov	0x68, %r17
	.word 0xdebcc400  ! 3744: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	.word 0x87802020  ! 3745: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd087a000  ! 3746: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	mov	0x3d0, %r21
	.word 0x87802074  ! 3748: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d8, %r20
	.word 0x87802020  ! 3750: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0976000  ! 3751: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	mov	0x28, %r17
	.word 0xd08609e0  ! 3753: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r8
	.word 0xd8bfe000  ! 3754: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd2b48400  ! 3755: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd6ad84a0  ! 3756: STBA_R	stba	%r11, [%r22 + %r0] 0x25
	.word 0xdedfe000  ! 3757: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xd08f0e60  ! 3758: LDUBA_R	lduba	[%r28, %r0] 0x73, %r8
	.word 0xd8b7e000  ! 3759: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0xd0af8e40  ! 3760: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0x87802020  ! 3761: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f52000  ! 3762: STXA_I	stxa	%r11, [%r20 + 0x0000] %asi
	.word 0xd2dfce40  ! 3763: LDXA_R	ldxa	[%r31, %r0] 0x72, %r9
	.word 0xd48d6000  ! 3764: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r10
	.word 0xdece09e0  ! 3765: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r15
	mov	0x48, %r19
	.word 0xdaa56000  ! 3767: STWA_I	stwa	%r13, [%r21 + 0x0000] %asi
	.word 0xd08584a0  ! 3768: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r8
	.word 0xd4b52000  ! 3769: STHA_I	stha	%r10, [%r20 + 0x0000] %asi
	mov	0x60, %r18
	.word 0xd2bd04a0  ! 3771: STDA_R	stda	%r9, [%r20 + %r0] 0x25
	mov	0x7c8, %r21
	.word 0xd4df8e40  ! 3773: LDXA_R	ldxa	[%r30, %r0] 0x72, %r10
	.word 0xd88c4400  ! 3774: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0x87802020  ! 3775: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9609e0  ! 3776: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r13
	.word 0xdedf2000  ! 3777: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0x87802025  ! 3778: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdea72000  ! 3779: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	mov	0x18, %r19
	.word 0xdedf2000  ! 3781: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xde8fe000  ! 3782: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	mov	0x70, %r25
	.word 0x87802020  ! 3784: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedfe000  ! 3785: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xdecdc4a0  ! 3786: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r15
	mov	0x7f8, %r20
	mov	0x7f0, %r22
	.word 0xd6dfa000  ! 3789: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6a7e000  ! 3790: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xd68f2000  ! 3791: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xd2a4c400  ! 3792: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 3793: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3794: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r25
	mov	0x28, %r26
	.word 0xd0842000  ! 3797: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r8
	.word 0xd08ce000  ! 3798: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	mov	0x7f8, %r23
	mov	0x7c8, %r22
	.word 0xdabf4e80  ! 3801: STDA_R	stda	%r13, [%r29 + %r0] 0x74
	mov	0x60, %r27
	.word 0xd69ce000  ! 3803: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r11
	.word 0xd6f42000  ! 3804: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	.word 0xd6bc2000  ! 3805: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	mov	0x10, %r18
	mov	0x3f8, %r23
	.word 0x87802074  ! 3808: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6cda000  ! 3809: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r11
	.word 0xd2df8e60  ! 3810: LDXA_R	ldxa	[%r30, %r0] 0x73, %r9
	.word 0xdebc4400  ! 3811: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0xd4f52000  ! 3812: STXA_I	stxa	%r10, [%r20 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0xd4a52000  ! 3814: STWA_I	stwa	%r10, [%r20 + 0x0000] %asi
	.word 0xd0ad04a0  ! 3815: STBA_R	stba	%r8, [%r20 + %r0] 0x25
	.word 0xd4d4c400  ! 3816: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0xd8ae49e0  ! 3817: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0xd0d649e0  ! 3818: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r8
	.word 0xdca609e0  ! 3819: STWA_R	stwa	%r14, [%r24 + %r0] 0x4f
	.word 0xd88cc400  ! 3820: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	mov	0x40, %r19
	mov	0x7e0, %r20
	.word 0xdca5e000  ! 3823: STWA_I	stwa	%r14, [%r23 + 0x0000] %asi
	.word 0xd0ddc4a0  ! 3824: LDXA_R	ldxa	[%r23, %r0] 0x25, %r8
	.word 0xd0f74e40  ! 3825: STXA_R	stxa	%r8, [%r29 + %r0] 0x72
	.word 0x87802020  ! 3826: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeacc400  ! 3827: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	mov	0x3f8, %r23
	.word 0xdc9fa000  ! 3829: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0x87802072  ! 3830: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r26
	mov	0x7c8, %r22
	.word 0xd4f74e60  ! 3833: STXA_R	stxa	%r10, [%r29 + %r0] 0x73
	.word 0x87802020  ! 3834: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4966000  ! 3835: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r10
	.word 0x87802020  ! 3836: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b66000  ! 3837: STHA_I	stha	%r10, [%r25 + 0x0000] %asi
	mov	0x7f8, %r22
	.word 0xd496a000  ! 3839: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r10
	.word 0xd8a78e80  ! 3840: STWA_R	stwa	%r12, [%r30 + %r0] 0x74
	.word 0x87802020  ! 3841: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xdc9f6000  ! 3843: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	mov	0x18, %r19
	mov	0x60, %r16
	.word 0x87802072  ! 3846: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb46000  ! 3847: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xdcf4e000  ! 3848: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xdc9ca000  ! 3849: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r14
	.word 0xdcf4e000  ! 3850: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xded78e40  ! 3851: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r15
	.word 0xdc842000  ! 3852: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	mov	0x58, %r19
	.word 0xd6b74e60  ! 3854: STHA_R	stha	%r11, [%r29 + %r0] 0x73
	.word 0xd6cca000  ! 3855: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3856: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd686e000  ! 3857: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r11
	.word 0xd6ce2000  ! 3858: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	.word 0xd6bee000  ! 3859: STDA_I	stda	%r11, [%r27 + 0x0000] %asi
	mov	0x7c8, %r23
	.word 0xda870e40  ! 3861: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r13
	.word 0xd2a6c9e0  ! 3862: STWA_R	stwa	%r9, [%r27 + %r0] 0x4f
	.word 0x87802025  ! 3863: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3864: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 3865: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 3866: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 3867: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3868: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r26
	.word 0xd6ac4400  ! 3870: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xdaa5a000  ! 3871: STWA_I	stwa	%r13, [%r22 + 0x0000] %asi
	mov	0x3f0, %r22
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xda95a000  ! 3874: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r13
	.word 0xdab56000  ! 3875: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802072  ! 3877: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r19
	mov	0x0, %r26
	.word 0xdab52000  ! 3880: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	mov	0x60, %r19
	.word 0xdab56000  ! 3882: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	.word 0xda8de000  ! 3883: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r13
	mov	0x18, %r25
	wr_tick_cmpr_2_46:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x9f, %g2
	or	%g4, 0xaf, %g4
	or	%g6, 0x90, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd49689e0  ! 3886: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r10
	.word 0xd2d56000  ! 3887: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r9
	.word 0xd2f5a000  ! 3888: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	.word 0xd2a649e0  ! 3889: STWA_R	stwa	%r9, [%r25 + %r0] 0x4f
	.word 0xd0de49e0  ! 3890: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r8
	.word 0xd4bde000  ! 3891: STDA_I	stda	%r10, [%r23 + 0x0000] %asi
	.word 0xd6878e60  ! 3892: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r11
	.word 0xdac689e0  ! 3893: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r13
	.word 0xdccd2000  ! 3894: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r14
	mov	0x40, %r27
	.word 0x87802074  ! 3896: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3897: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cc0400  ! 3898: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r11
	mov	0x3f0, %r21
	mov	0x60, %r27
	.word 0xd88ea000  ! 3901: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r12
	mov	0x18, %r25
	.word 0xd8bee000  ! 3903: STDA_I	stda	%r12, [%r27 + 0x0000] %asi
	.word 0xd8d6a000  ! 3904: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r12
	.word 0xd8d66000  ! 3905: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r12
	mov	0x58, %r24
	mov	0x48, %r27
	.word 0xd89e6000  ! 3908: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r12
	.word 0xd8b6a000  ! 3909: STHA_I	stha	%r12, [%r26 + 0x0000] %asi
	.word 0xd8cfce40  ! 3910: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r12
	.word 0xd0a62000  ! 3911: STWA_I	stwa	%r8, [%r24 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xd09e2000  ! 3913: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r8
	.word 0xd0b62000  ! 3914: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 3915: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 3916: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b6c9e0  ! 3917: STHA_R	stha	%r9, [%r27 + %r0] 0x4f
	.word 0xd6c6e000  ! 3918: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3919: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69ce000  ! 3920: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r11
	.word 0xd6ad44a0  ! 3921: STBA_R	stba	%r11, [%r21 + %r0] 0x25
	.word 0xd6a4e000  ! 3922: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 3923: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r25
	.word 0xd8bc8400  ! 3925: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xd4b72000  ! 3926: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd4af2000  ! 3927: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 3928: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r25
	.word 0xdabec9e0  ! 3930: STDA_R	stda	%r13, [%r27 + %r0] 0x4f
	.word 0xd0c72000  ! 3931: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xd68fce60  ! 3932: LDUBA_R	lduba	[%r31, %r0] 0x73, %r11
	.word 0xd0872000  ! 3933: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xdaad84a0  ! 3934: STBA_R	stba	%r13, [%r22 + %r0] 0x25
	.word 0xdeaf6000  ! 3935: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xdeb72000  ! 3936: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xd6bf4e60  ! 3937: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	.word 0xd4af4e60  ! 3938: STBA_R	stba	%r10, [%r29 + %r0] 0x73
	mov	0x8, %r26
	.word 0xd88c4400  ! 3940: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0xdef78e60  ! 3941: STXA_R	stxa	%r15, [%r30 + %r0] 0x73
	.word 0xd0af2000  ! 3942: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	mov	0x50, %r25
	.word 0xd0bf6000  ! 3944: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	mov	0x48, %r27
	.word 0xd6974e60  ! 3946: LDUHA_R	lduha	[%r29, %r0] 0x73, %r11
	.word 0xde940400  ! 3947: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0xd2bfe000  ! 3948: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	mov	0x10, %r18
	.word 0xd8bf8e60  ! 3950: STDA_R	stda	%r12, [%r30 + %r0] 0x73
	.word 0x87802020  ! 3951: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 3952: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r24
	.word 0xd0bf6000  ! 3954: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd6974e40  ! 3955: LDUHA_R	lduha	[%r29, %r0] 0x72, %r11
	mov	0x38, %r27
	.word 0xdeafe000  ! 3957: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0xde87e000  ! 3959: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0x87802074  ! 3960: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeae2000  ! 3961: STBA_I	stba	%r15, [%r24 + 0x0000] %asi
	.word 0xdebee000  ! 3962: STDA_I	stda	%r15, [%r27 + 0x0000] %asi
	.word 0xd8bd84a0  ! 3963: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	.word 0xdec70e80  ! 3964: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r15
	.word 0xd69e6000  ! 3965: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 3966: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 3967: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6b72000  ! 3968: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	mov	0x68, %r27
	.word 0xd4a74e60  ! 3970: STWA_R	stwa	%r10, [%r29 + %r0] 0x73
	.word 0xd0d7a000  ! 3971: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0xd0a72000  ! 3972: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x48, %r27
	mov	0x28, %r24
	.word 0xd0f7e000  ! 3975: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd89584a0  ! 3976: LDUHA_R	lduha	[%r22, %r0] 0x25, %r12
	.word 0xd2a76000  ! 3977: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 3978: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a76000  ! 3979: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd6bd04a0  ! 3980: STDA_R	stda	%r11, [%r20 + %r0] 0x25
	mov	0x50, %r27
	.word 0xdc97e000  ! 3982: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	mov	0x40, %r19
	mov	0x48, %r18
	wr_tick_cmpr_2_47:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x87, %g2
	or	%g4, 0xc6, %g4
	or	%g6, 0xa7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd6b689e0  ! 3986: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	.word 0xd8ae49e0  ! 3987: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	mov	0x28, %r19
	.word 0xd4f4c400  ! 3989: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xdcb6c9e0  ! 3990: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	.word 0xd6bfa000  ! 3991: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd6af2000  ! 3992: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 3993: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6872000  ! 3994: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd68fa000  ! 3995: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3996: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ad6000  ! 3997: STBA_I	stba	%r11, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 3998: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ace000  ! 3999: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	mov	0x3c8, %r22
	.word 0xd6f42000  ! 4001: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	mov	0x28, %r17
	.word 0xd6a46000  ! 4003: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	mov	0x48, %r24
	mov	0x3c8, %r22
	mov	0x40, %r25
	.word 0xd684a000  ! 4007: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r11
	.word 0xd6f42000  ! 4008: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	.word 0xd6a4e000  ! 4009: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 4010: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r25
	.word 0xd6ce2000  ! 4012: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	mov	0x78, %r27
	.word 0x87802073  ! 4014: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef74e80  ! 4015: STXA_R	stxa	%r15, [%r29 + %r0] 0x74
	mov	0x78, %r27
	mov	0x18, %r26
	.word 0xd086e000  ! 4018: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r8
	mov	0x3d8, %r23
	.word 0xd0f44400  ! 4020: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xded6a000  ! 4021: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r15
	.word 0xdec66000  ! 4022: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r15
	.word 0xdef44400  ! 4023: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0x87802072  ! 4024: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6c689e0  ! 4025: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r11
	.word 0x87802074  ! 4026: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4d40400  ! 4027: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	.word 0x87802020  ! 4028: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f4a000  ! 4029: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	.word 0xdeadc4a0  ! 4030: STBA_R	stba	%r15, [%r23 + %r0] 0x25
	.word 0xdaf4a000  ! 4031: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0xdab4a000  ! 4032: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 4033: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd487ce80  ! 4034: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r10
	.word 0x87802073  ! 4035: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4036: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r19
	.word 0xdcb4e000  ! 4038: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	mov	0x7c0, %r22
	.word 0xd49c0400  ! 4040: LDDA_R	ldda	[%r16, %r0] 0x20, %r10
	mov	0x30, %r26
	.word 0xd8a44400  ! 4042: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xda9c6000  ! 4043: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xd0874e60  ! 4044: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r8
	mov	0x3f8, %r22
	.word 0xdcf48400  ! 4046: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xd2f40400  ! 4047: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xd48c2000  ! 4048: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r10
	mov	0x58, %r24
	.word 0xd4cce000  ! 4050: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	.word 0xd4a42000  ! 4051: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 4052: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b4c400  ! 4053: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0x87802073  ! 4054: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa4e000  ! 4055: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 4056: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4057: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8f6000  ! 4058: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xd28ec9e0  ! 4059: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r9
	.word 0xd0f584a0  ! 4060: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	.word 0xd2bf4e80  ! 4061: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	.word 0x87802073  ! 4062: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f40400  ! 4063: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xd8ac6000  ! 4064: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xd6bc4400  ! 4065: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	.word 0x87802020  ! 4066: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded544a0  ! 4067: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r15
	.word 0xd4a7e000  ! 4068: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	mov	0x7d0, %r22
	mov	0x18, %r24
	.word 0xdcae89e0  ! 4071: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	mov	0x7d8, %r23
	.word 0xdedfe000  ! 4073: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xda840400  ! 4074: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	.word 0x87802072  ! 4075: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b78e40  ! 4076: STHA_R	stha	%r12, [%r30 + %r0] 0x72
	.word 0xd8f7a000  ! 4077: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8f7a000  ! 4078: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8f72000  ! 4079: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8cf2000  ! 4080: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0xd8afa000  ! 4081: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xd6b48400  ! 4082: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xdea76000  ! 4083: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	mov	0x68, %r17
	.word 0xded7a000  ! 4085: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xdeb76000  ! 4086: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xd0a70e80  ! 4087: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0xdc872000  ! 4088: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	mov	0x48, %r16
	.word 0x87802074  ! 4090: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb76000  ! 4091: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xd69c4400  ! 4092: LDDA_R	ldda	[%r17, %r0] 0x20, %r11
	.word 0xdcde09e0  ! 4093: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r14
	.word 0xdc9e09e0  ! 4094: LDDA_R	ldda	[%r24, %r0] 0x4f, %r14
	.word 0xd0870e40  ! 4095: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r8
	.word 0x87802073  ! 4096: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 4097: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6962000  ! 4098: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r11
	mov	0x70, %r26
	mov	0x18, %r17
	mov	0x7f8, %r23
	.word 0x87802020  ! 4102: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r16
	.word 0x8780204f  ! 4104: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bfce80  ! 4105: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	mov	0x3f8, %r22
	.word 0xdcaf4e80  ! 4107: STBA_R	stba	%r14, [%r29 + %r0] 0x74
	.word 0xd0d544a0  ! 4108: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r8
	.word 0xd09dc4a0  ! 4109: LDDA_R	ldda	[%r23, %r0] 0x25, %r8
	.word 0xd2c4c400  ! 4110: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0x87802025  ! 4111: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6dd2000  ! 4112: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r11
	.word 0xd6dda000  ! 4113: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r11
	.word 0xd2f5c4a0  ! 4114: STXA_R	stxa	%r9, [%r23 + %r0] 0x25
	.word 0xd8dec9e0  ! 4115: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r12
	.word 0xdaf6c9e0  ! 4116: STXA_R	stxa	%r13, [%r27 + %r0] 0x4f
	.word 0x87802072  ! 4117: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r16
	mov	0x3e0, %r22
	.word 0xd0dcc400  ! 4120: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	mov	0x3d8, %r20
	.word 0xd49fa000  ! 4122: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0xd49f2000  ! 4123: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd8c584a0  ! 4124: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r12
	mov	0x3f8, %r21
	.word 0xd49504a0  ! 4126: LDUHA_R	lduha	[%r20, %r0] 0x25, %r10
	.word 0xd8878e80  ! 4127: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r12
	.word 0xdac74e80  ! 4128: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r13
	.word 0xda8fe000  ! 4129: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xda9f6000  ! 4130: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xdebdc4a0  ! 4131: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	.word 0xda97e000  ! 4132: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	mov	0x78, %r16
	.word 0xd88f4e60  ! 4134: LDUBA_R	lduba	[%r29, %r0] 0x73, %r12
	mov	0x7c0, %r23
	.word 0xdcafe000  ! 4136: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 4137: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r25
	mov	0x70, %r27
	mov	0x3f0, %r22
	.word 0xde84c400  ! 4141: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0xd0f72000  ! 4142: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	mov	0x58, %r26
	.word 0x8780204f  ! 4144: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c8, %r20
	.word 0xd0bc6000  ! 4146: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	.word 0xdca689e0  ! 4147: STWA_R	stwa	%r14, [%r26 + %r0] 0x4f
	.word 0xd8b4e000  ! 4148: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 4149: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8afe000  ! 4150: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd8a7a000  ! 4151: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 4152: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6b70e60  ! 4153: STHA_R	stha	%r11, [%r28 + %r0] 0x73
	mov	0x68, %r27
	mov	0x70, %r18
	.word 0xdac62000  ! 4156: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r13
	.word 0xdace2000  ! 4157: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r13
	.word 0xd8df4e40  ! 4158: LDXA_R	ldxa	[%r29, %r0] 0x72, %r12
	.word 0xda8cc400  ! 4159: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	.word 0xd28f8e80  ! 4160: LDUBA_R	lduba	[%r30, %r0] 0x74, %r9
	.word 0x87802073  ! 4161: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdea4e000  ! 4162: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xdea4e000  ! 4163: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xd0bf8e80  ! 4164: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	.word 0xdedca000  ! 4165: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0x87802020  ! 4166: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r18
	mov	0x18, %r18
	mov	0x18, %r24
	.word 0x87802074  ! 4170: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r25
	mov	0x58, %r27
	.word 0xde976000  ! 4173: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	.word 0xd8afce40  ! 4174: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	.word 0xd0d78e40  ! 4175: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r8
	.word 0xd4df2000  ! 4176: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4cf2000  ! 4177: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4d76000  ! 4178: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0xd6d70e80  ! 4179: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r11
	.word 0xd4f7ce60  ! 4180: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	mov	0x7c8, %r20
	.word 0xd4f70e60  ! 4182: STXA_R	stxa	%r10, [%r28 + %r0] 0x73
	.word 0x8780204f  ! 4183: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b46000  ! 4184: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd6b70e40  ! 4185: STHA_R	stha	%r11, [%r28 + %r0] 0x72
	.word 0x87802074  ! 4186: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacc0400  ! 4187: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r13
	mov	0x8, %r24
	mov	0x20, %r17
	.word 0xd6b7ce80  ! 4190: STHA_R	stha	%r11, [%r31 + %r0] 0x74
	.word 0xd48de000  ! 4191: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r10
	.word 0x87802073  ! 4192: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd49f2000  ! 4193: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd4bfe000  ! 4194: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x18, %r17
	.word 0x87802073  ! 4196: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4df6000  ! 4197: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0xde8e49e0  ! 4198: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r15
	.word 0x87802073  ! 4199: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef44400  ! 4200: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	mov	0x78, %r26
	.word 0xdac72000  ! 4202: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0xdacfa000  ! 4203: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xdad7e000  ! 4204: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xde97ce40  ! 4205: LDUHA_R	lduha	[%r31, %r0] 0x72, %r15
	mov	0x0, %r18
	mov	0x8, %r25
	.word 0xd4b76000  ! 4208: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 4209: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r26
	mov	0x40, %r18
	.word 0xd89c8400  ! 4212: LDDA_R	ldda	[%r18, %r0] 0x20, %r12
	.word 0x87802020  ! 4213: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd886a000  ! 4214: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r12
	.word 0xdcb48400  ! 4215: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	mov	0x28, %r18
	.word 0xd6f7ce40  ! 4217: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	.word 0x87802074  ! 4218: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c8, %r23
	.word 0xd2b78e60  ! 4220: STHA_R	stha	%r9, [%r30 + %r0] 0x73
	.word 0x8780204f  ! 4221: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4d70e40  ! 4222: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r10
	mov	0x70, %r25
	.word 0xdaa40400  ! 4224: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0xd0dee000  ! 4225: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r8
	mov	0x3e0, %r20
	mov	0x18, %r16
	mov	0x8, %r27
	.word 0x87802020  ! 4229: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r21
	.word 0xd09f6000  ! 4231: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	mov	0x7d8, %r21
	.word 0xd8b544a0  ! 4233: STHA_R	stha	%r12, [%r21 + %r0] 0x25
	mov	0x30, %r17
	mov	0x58, %r27
	mov	0x7d8, %r23
	.word 0xdeafa000  ! 4237: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xd68504a0  ! 4238: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r11
	.word 0xdabdc4a0  ! 4239: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	mov	0x68, %r19
	.word 0xd8dcc400  ! 4241: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	.word 0xdcbc8400  ! 4242: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xde87a000  ! 4243: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0x87802074  ! 4244: WRASI_I	wr	%r0, 0x0074, %asi
	wr_tick_cmpr_2_48:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xae, %g2
	or	%g4, 0x83, %g4
	or	%g6, 0xce, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd6a7ce80  ! 4246: STWA_R	stwa	%r11, [%r31 + %r0] 0x74
	.word 0xd0c44400  ! 4247: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r8
	.word 0x87802025  ! 4248: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb78e40  ! 4249: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	mov	0x30, %r24
	.word 0x87802020  ! 4251: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa62000  ! 4252: STWA_I	stwa	%r13, [%r24 + 0x0000] %asi
	mov	0x70, %r16
	.word 0x87802020  ! 4254: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6df8e80  ! 4255: LDXA_R	ldxa	[%r30, %r0] 0x74, %r11
	.word 0x8780204f  ! 4256: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r24
	mov	0x8, %r27
	mov	0x3c8, %r21
	.word 0x87802025  ! 4260: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0940400  ! 4261: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	.word 0xdec72000  ! 4262: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0x87802020  ! 4263: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r25
	mov	0x3e8, %r21
	.word 0xdebd2000  ! 4266: STDA_I	stda	%r15, [%r20 + 0x0000] %asi
	.word 0xdec56000  ! 4267: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r15
	mov	0x78, %r25
	.word 0xd4940400  ! 4269: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	mov	0x7f8, %r23
	.word 0xd2d7ce40  ! 4271: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r9
	.word 0xd6cda000  ! 4272: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r11
	.word 0xd6b56000  ! 4273: STHA_I	stha	%r11, [%r21 + 0x0000] %asi
	.word 0xdad4c400  ! 4274: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xd4b52000  ! 4275: STHA_I	stha	%r10, [%r20 + 0x0000] %asi
	.word 0xd4a52000  ! 4276: STWA_I	stwa	%r10, [%r20 + 0x0000] %asi
	.word 0xdedf8e40  ! 4277: LDXA_R	ldxa	[%r30, %r0] 0x72, %r15
	.word 0xd6f5e000  ! 4278: STXA_I	stxa	%r11, [%r23 + 0x0000] %asi
	mov	0x3c0, %r21
	mov	0x7c8, %r21
	mov	0x48, %r17
	mov	0x7d0, %r23
	.word 0xd4a78e80  ! 4283: STWA_R	stwa	%r10, [%r30 + %r0] 0x74
	.word 0xda95a000  ! 4284: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r13
	wr_tick_cmpr_2_49:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xdb, %g2
	or	%g4, 0xad, %g4
	or	%g6, 0xe8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdab52000  ! 4286: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	.word 0xdaa5a000  ! 4287: STWA_I	stwa	%r13, [%r22 + 0x0000] %asi
	.word 0xde878e80  ! 4288: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r15
	wr_tick_cmpr_2_50:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa6, %g2
	or	%g4, 0xe3, %g4
	or	%g6, 0xa9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2bda000  ! 4290: STDA_I	stda	%r9, [%r22 + 0x0000] %asi
	mov	0x28, %r16
	.word 0xd2b52000  ! 4292: STHA_I	stha	%r9, [%r20 + 0x0000] %asi
	.word 0x87802025  ! 4293: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd48f4e40  ! 4294: LDUBA_R	lduba	[%r29, %r0] 0x72, %r10
	.word 0xd2f72000  ! 4295: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd297a000  ! 4296: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	mov	0x60, %r16
	.word 0xd2a72000  ! 4298: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 4299: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd28ea000  ! 4300: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r9
	.word 0xd2c6a000  ! 4301: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r9
	.word 0xd2a6e000  ! 4302: STWA_I	stwa	%r9, [%r27 + 0x0000] %asi
	.word 0x87802074  ! 4303: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28544a0  ! 4304: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r9
	.word 0xdcb72000  ! 4305: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 4306: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2af8e60  ! 4307: STBA_R	stba	%r9, [%r30 + %r0] 0x73
	mov	0x78, %r25
	.word 0xdedd84a0  ! 4309: LDXA_R	ldxa	[%r22, %r0] 0x25, %r15
	.word 0xdadf6000  ! 4310: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xd6f7ce60  ! 4311: STXA_R	stxa	%r11, [%r31 + %r0] 0x73
	mov	0x48, %r26
	.word 0xda8544a0  ! 4313: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r13
	.word 0xd8b78e80  ! 4314: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	.word 0x87802073  ! 4315: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6a7e000  ! 4316: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6a7a000  ! 4317: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	mov	0x40, %r19
	mov	0x60, %r18
	.word 0xd697e000  ! 4320: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0xdab40400  ! 4321: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	mov	0x20, %r19
	.word 0xde87a000  ! 4323: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0x87802020  ! 4324: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb72000  ! 4325: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xdeb76000  ! 4326: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 4327: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde9fa000  ! 4328: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	.word 0xd28f4e80  ! 4329: LDUBA_R	lduba	[%r29, %r0] 0x74, %r9
	.word 0xd89d84a0  ! 4330: LDDA_R	ldda	[%r22, %r0] 0x25, %r12
	.word 0xd8a78e80  ! 4331: STWA_R	stwa	%r12, [%r30 + %r0] 0x74
	.word 0xd8b609e0  ! 4332: STHA_R	stha	%r12, [%r24 + %r0] 0x4f
	.word 0xd6a7e000  ! 4333: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 4334: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6aca000  ! 4335: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xdecf0e40  ! 4336: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r15
	mov	0x20, %r18
	mov	0x40, %r26
	.word 0xd4f42000  ! 4339: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd494e000  ! 4340: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	.word 0xd0cf8e40  ! 4341: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r8
	.word 0xd2b689e0  ! 4342: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	.word 0xde8dc4a0  ! 4343: LDUBA_R	lduba	[%r23, %r0] 0x25, %r15
	.word 0xd08ca000  ! 4344: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xde8cc400  ! 4345: LDUBA_R	lduba	[%r19, %r0] 0x20, %r15
	.word 0xd2bc6000  ! 4346: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0xd2d4e000  ! 4347: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0x87802073  ! 4348: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d0, %r22
	.word 0x8780204f  ! 4350: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4351: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2956000  ! 4352: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r9
	.word 0xd2ad2000  ! 4353: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xd2ad6000  ! 4354: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0xd2ad6000  ! 4355: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0xdcad04a0  ! 4356: STBA_R	stba	%r14, [%r20 + %r0] 0x25
	.word 0xd68d84a0  ! 4357: LDUBA_R	lduba	[%r22, %r0] 0x25, %r11
	mov	0x3e8, %r20
	.word 0xdebd2000  ! 4359: STDA_I	stda	%r15, [%r20 + 0x0000] %asi
	mov	0x60, %r24
	.word 0x87802025  ! 4361: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4a40400  ! 4362: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	.word 0x87802025  ! 4363: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c8, %r21
	.word 0xd88f0e40  ! 4365: LDUBA_R	lduba	[%r28, %r0] 0x72, %r12
	.word 0x87802072  ! 4366: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8bde000  ! 4367: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0xd2bf8e40  ! 4368: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	.word 0xdef48400  ! 4369: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	mov	0x48, %r27
	.word 0xd097ce60  ! 4371: LDUHA_R	lduha	[%r31, %r0] 0x73, %r8
	.word 0xd8a5e000  ! 4372: STWA_I	stwa	%r12, [%r23 + 0x0000] %asi
	mov	0x30, %r27
	.word 0xd8a52000  ! 4374: STWA_I	stwa	%r12, [%r20 + 0x0000] %asi
	.word 0xdaf74e60  ! 4375: STXA_R	stxa	%r13, [%r29 + %r0] 0x73
	.word 0xdadc0400  ! 4376: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	.word 0xd485a000  ! 4377: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r10
	mov	0x58, %r18
	.word 0xd4f5a000  ! 4379: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	.word 0xdec40400  ! 4380: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0x87802020  ! 4381: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a78e80  ! 4382: STWA_R	stwa	%r11, [%r30 + %r0] 0x74
	.word 0x87802072  ! 4383: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde84a000  ! 4384: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	.word 0xde9c6000  ! 4385: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0x87802073  ! 4386: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 4387: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r24
	.word 0xd0c48400  ! 4389: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r8
	.word 0xd6de6000  ! 4390: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r11
	.word 0xd2d4c400  ! 4391: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r9
	mov	0x7c8, %r21
	.word 0xd8d4c400  ! 4393: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0xdcbe6000  ! 4394: STDA_I	stda	%r14, [%r25 + 0x0000] %asi
	.word 0xdcb66000  ! 4395: STHA_I	stha	%r14, [%r25 + 0x0000] %asi
	.word 0xdcbfce60  ! 4396: STDA_R	stda	%r14, [%r31 + %r0] 0x73
	.word 0xd2a70e40  ! 4397: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	mov	0x78, %r27
	.word 0xd6f62000  ! 4399: STXA_I	stxa	%r11, [%r24 + 0x0000] %asi
	mov	0x48, %r19
	.word 0x87802020  ! 4401: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c5c4a0  ! 4402: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r10
	.word 0xdcaca000  ! 4403: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xdc8c2000  ! 4404: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r14
	.word 0xd6c504a0  ! 4405: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r11
	.word 0xd0cce000  ! 4406: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0f42000  ! 4407: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0xda97ce40  ! 4408: LDUHA_R	lduha	[%r31, %r0] 0x72, %r13
	.word 0x87802074  ! 4409: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a7ce60  ! 4410: STWA_R	stwa	%r8, [%r31 + %r0] 0x73
	.word 0xdaf56000  ! 4411: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0xda852000  ! 4413: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r13
	.word 0xdeae89e0  ! 4414: STBA_R	stba	%r15, [%r26 + %r0] 0x4f
	mov	0x8, %r25
	.word 0x87802073  ! 4416: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6970e80  ! 4417: LDUHA_R	lduha	[%r28, %r0] 0x74, %r11
	.word 0xd8bc4400  ! 4418: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	mov	0x60, %r26
	mov	0x50, %r17
	.word 0xd2966000  ! 4421: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r9
	.word 0xd6f40400  ! 4422: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	.word 0x87802074  ! 4423: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf5c4a0  ! 4424: STXA_R	stxa	%r13, [%r23 + %r0] 0x25
	.word 0xd4bca000  ! 4425: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0xd6d48400  ! 4426: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	mov	0x30, %r27
	.word 0x8780204f  ! 4428: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 4429: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b4c400  ! 4430: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	mov	0x7f0, %r23
	.word 0xd8b4c400  ! 4432: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	mov	0x3f8, %r21
	.word 0xd4bf8e80  ! 4434: STDA_R	stda	%r10, [%r30 + %r0] 0x74
	.word 0xd2b78e80  ! 4435: STHA_R	stha	%r9, [%r30 + %r0] 0x74
	.word 0x87802072  ! 4436: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca40400  ! 4437: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xd6ade000  ! 4438: STBA_I	stba	%r11, [%r23 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xd8cf4e40  ! 4440: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r12
	.word 0xdeb5e000  ! 4441: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	.word 0xd6bc0400  ! 4442: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	mov	0x48, %r17
	.word 0xd8afce80  ! 4444: STBA_R	stba	%r12, [%r31 + %r0] 0x74
	.word 0xd8b5e000  ! 4445: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0xd8b5a000  ! 4447: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	mov	0x70, %r27
	mov	0x3e8, %r20
	.word 0x87802073  ! 4450: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f46000  ! 4451: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xdcf7ce60  ! 4452: STXA_R	stxa	%r14, [%r31 + %r0] 0x73
	.word 0xd0cf0e80  ! 4453: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r8
	.word 0x87802025  ! 4454: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r26
	.word 0x87802025  ! 4456: WRASI_I	wr	%r0, 0x0025, %asi
	wr_tick_cmpr_2_51:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf9, %g2
	or	%g4, 0xcf, %g4
	or	%g6, 0xe3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 4458: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccc2000  ! 4459: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r14
	.word 0xdc8ce000  ! 4460: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	.word 0xdccca000  ! 4461: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	mov	0x3c8, %r22
	.word 0xdcbca000  ! 4463: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdebe09e0  ! 4464: STDA_R	stda	%r15, [%r24 + %r0] 0x4f
	.word 0xd8f4e000  ! 4465: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xd2f584a0  ! 4466: STXA_R	stxa	%r9, [%r22 + %r0] 0x25
	mov	0x60, %r24
	.word 0xd0a4e000  ! 4468: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xdebfce80  ! 4469: STDA_R	stda	%r15, [%r31 + %r0] 0x74
	mov	0x10, %r16
	.word 0xdcb70e80  ! 4471: STHA_R	stha	%r14, [%r28 + %r0] 0x74
	.word 0x87802020  ! 4472: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bd44a0  ! 4473: STDA_R	stda	%r12, [%r21 + %r0] 0x25
	.word 0xd6852000  ! 4474: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 4475: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd287ce80  ! 4476: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r9
	.word 0x87802072  ! 4477: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r24
	.word 0x87802020  ! 4479: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea74e60  ! 4480: STWA_R	stwa	%r15, [%r29 + %r0] 0x73
	.word 0x87802025  ! 4481: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f7ce40  ! 4482: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	mov	0x20, %r26
	.word 0xd2974e60  ! 4484: LDUHA_R	lduha	[%r29, %r0] 0x73, %r9
	.word 0xd8afce60  ! 4485: STBA_R	stba	%r12, [%r31 + %r0] 0x73
	.word 0xd2a44400  ! 4486: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xdebdc4a0  ! 4487: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	.word 0xd6cdc4a0  ! 4488: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r11
	.word 0xd4cf2000  ! 4489: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4bf6000  ! 4490: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd4b76000  ! 4491: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	mov	0x8, %r25
	.word 0xd4f76000  ! 4493: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4b72000  ! 4494: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xde8e49e0  ! 4495: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r15
	.word 0xd8a609e0  ! 4496: STWA_R	stwa	%r12, [%r24 + %r0] 0x4f
	mov	0x50, %r25
	.word 0xd4d72000  ! 4498: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	mov	0x7c0, %r23
	.word 0x87802020  ! 4500: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49ce000  ! 4501: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0xd4c46000  ! 4502: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r10
	.word 0xd4c4e000  ! 4503: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r10
	.word 0xd4dce000  ! 4504: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	.word 0x87802073  ! 4505: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4afa000  ! 4506: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd6bf4e40  ! 4507: STDA_R	stda	%r11, [%r29 + %r0] 0x72
	.word 0xdc9fa000  ! 4508: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 4509: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd69f4e40  ! 4510: LDDA_R	ldda	[%r29, %r0] 0x72, %r11
	.word 0xd4a7a000  ! 4511: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	mov	0x40, %r25
	ta	T_CHANGE_PRIV	! macro
	mov	0x68, %r24
	.word 0xd6bf0e60  ! 4515: STDA_R	stda	%r11, [%r28 + %r0] 0x73
	.word 0xdac78e80  ! 4516: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r13
	mov	0x3e8, %r22
	.word 0xd0972000  ! 4518: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0af6000  ! 4519: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	mov	0x28, %r19
	mov	0x60, %r27
	mov	0x0, %r25
	.word 0xd0bfe000  ! 4523: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd4c504a0  ! 4524: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r10
	.word 0xdc940400  ! 4525: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0x87802020  ! 4526: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ad84a0  ! 4527: STBA_R	stba	%r11, [%r22 + %r0] 0x25
	.word 0xd697a000  ! 4528: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	mov	0x7e8, %r22
	.word 0xd6a72000  ! 4530: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xdecf4e60  ! 4531: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r15
	mov	0x7c0, %r23
	.word 0x87802072  ! 4533: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r19
	mov	0x60, %r18
	mov	0x7f8, %r21
	.word 0xded6c9e0  ! 4537: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r15
	.word 0xd8cfe000  ! 4538: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xdaad84a0  ! 4539: STBA_R	stba	%r13, [%r22 + %r0] 0x25
	.word 0xd8cf6000  ! 4540: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0x87802025  ! 4541: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 4542: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0bfce60  ! 4543: STDA_R	stda	%r8, [%r31 + %r0] 0x73
	.word 0xd8cd04a0  ! 4544: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r12
	.word 0xd4ad2000  ! 4545: STBA_I	stba	%r10, [%r20 + 0x0000] %asi
	.word 0xdc9cc400  ! 4546: LDDA_R	ldda	[%r19, %r0] 0x20, %r14
	.word 0x8780204f  ! 4547: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b62000  ! 4548: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0x8780204f  ! 4549: WRASI_I	wr	%r0, 0x004f, %asi
	wr_tick_cmpr_2_52:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xdb, %g2
	or	%g4, 0x93, %g4
	or	%g6, 0x9b, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 4551: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r26
	.word 0xd0b66000  ! 4553: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	.word 0x87802072  ! 4554: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 4555: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd097e000  ! 4556: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0cf2000  ! 4557: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0x87802020  ! 4558: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a72000  ! 4559: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x38, %r24
	.word 0xdc9fce60  ! 4561: LDDA_R	ldda	[%r31, %r0] 0x73, %r14
	.word 0xdac7a000  ! 4562: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xdaf7a000  ! 4563: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	mov	0x48, %r26
	.word 0xd6bfce40  ! 4565: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	.word 0xd09fce40  ! 4566: LDDA_R	ldda	[%r31, %r0] 0x72, %r8
	.word 0xd4df0e80  ! 4567: LDXA_R	ldxa	[%r28, %r0] 0x74, %r10
	.word 0xd2df6000  ! 4568: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	mov	0x7d8, %r21
	.word 0x87802073  ! 4570: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r18
	.word 0xd29f8e60  ! 4572: LDDA_R	ldda	[%r30, %r0] 0x73, %r9
	.word 0x87802073  ! 4573: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd084e000  ! 4574: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	mov	0x48, %r19
	.word 0xd2ccc400  ! 4576: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	.word 0xdab6c9e0  ! 4577: STHA_R	stha	%r13, [%r27 + %r0] 0x4f
	.word 0xd8bf0e80  ! 4578: STDA_R	stda	%r12, [%r28 + %r0] 0x74
	.word 0xdea4e000  ! 4579: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xded4e000  ! 4580: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	.word 0xdec4e000  ! 4581: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	mov	0x3d0, %r23
	.word 0xdecc6000  ! 4583: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r15
	mov	0x3d0, %r23
	.word 0xdad48400  ! 4585: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0x8780204f  ! 4586: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b584a0  ! 4587: STHA_R	stha	%r11, [%r22 + %r0] 0x25
	.word 0xd8aee000  ! 4588: STBA_I	stba	%r12, [%r27 + 0x0000] %asi
	.word 0xd28c4400  ! 4589: LDUBA_R	lduba	[%r17, %r0] 0x20, %r9
	.word 0xdcb609e0  ! 4590: STHA_R	stha	%r14, [%r24 + %r0] 0x4f
	mov	0x58, %r24
	.word 0xdcacc400  ! 4592: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0xd6b70e40  ! 4593: STHA_R	stha	%r11, [%r28 + %r0] 0x72
	.word 0x87802025  ! 4594: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd29f6000  ! 4595: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xd2f76000  ! 4596: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xda9c0400  ! 4598: LDDA_R	ldda	[%r16, %r0] 0x20, %r13
	mov	0x8, %r26
	.word 0xd0b584a0  ! 4600: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	mov	0x68, %r19
	.word 0xdcc76000  ! 4602: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	mov	0x3f0, %r21
	.word 0xdacc4400  ! 4604: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	mov	0x40, %r19
	mov	0x0, %r16
	.word 0xd4bf8e40  ! 4607: STDA_R	stda	%r10, [%r30 + %r0] 0x72
	.word 0x87802074  ! 4608: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e0, %r20
	.word 0xd4a7a000  ! 4610: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	mov	0x8, %r17
	.word 0xd4bfa000  ! 4612: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	mov	0x10, %r17
	.word 0xd4972000  ! 4614: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0xd4af6000  ! 4615: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	mov	0x40, %r24
	mov	0x8, %r25
	.word 0xd48fe000  ! 4618: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xd4bf2000  ! 4619: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd89649e0  ! 4620: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r12
	.word 0xd8bfe000  ! 4621: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	mov	0x7c8, %r21
	.word 0xdc874e80  ! 4623: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r14
	mov	0x20, %r17
	.word 0xd6a74e40  ! 4625: STWA_R	stwa	%r11, [%r29 + %r0] 0x72
	.word 0xd0a649e0  ! 4626: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	.word 0xd2a609e0  ! 4627: STWA_R	stwa	%r9, [%r24 + %r0] 0x4f
	.word 0xd4b72000  ! 4628: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 4629: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c8, %r20
	.word 0x87802072  ! 4631: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a40400  ! 4632: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0xd48ec9e0  ! 4633: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r10
	mov	0x3e8, %r22
	.word 0xd8bfa000  ! 4635: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd8bf6000  ! 4636: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	mov	0x3c0, %r20
	.word 0xd48f4e60  ! 4638: LDUBA_R	lduba	[%r29, %r0] 0x73, %r10
	mov	0x3d8, %r23
	mov	0x7d0, %r22
	.word 0xd2872000  ! 4641: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	ta	T_CHANGE_PRIV	! macro
	.word 0xd687ce60  ! 4643: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r11
	.word 0xd296c9e0  ! 4644: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r9
	mov	0x7e0, %r22
	mov	0x20, %r17
	mov	0x10, %r17
	.word 0x87802020  ! 4648: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2d6c9e0  ! 4650: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r9
	mov	0x8, %r19
	.word 0x87802020  ! 4652: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac78e40  ! 4653: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r13
	.word 0xdcbc8400  ! 4654: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xd0aca000  ! 4655: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	mov	0x7c8, %r21
	mov	0x3d0, %r23
	.word 0x87802073  ! 4658: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r18
	.word 0xd0b72000  ! 4660: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 4661: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b62000  ! 4662: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0xd0a62000  ! 4663: STWA_I	stwa	%r8, [%r24 + 0x0000] %asi
	.word 0xd0d6e000  ! 4664: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r8
	.word 0xded48400  ! 4665: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	mov	0x10, %r19
	mov	0x0, %r27
	.word 0x87802072  ! 4668: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b74e60  ! 4669: STHA_R	stha	%r12, [%r29 + %r0] 0x73
	.word 0xdef7ce60  ! 4670: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0xdad74e60  ! 4671: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r13
	.word 0xd0c78e80  ! 4672: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r8
	.word 0xd8b7a000  ! 4673: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	mov	0x3c0, %r20
	.word 0xd8bfe000  ! 4675: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd887e000  ! 4676: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0x87802073  ! 4677: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8cde000  ! 4678: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r12
	.word 0xd8ada000  ! 4679: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0xd8bda000  ! 4680: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	mov	0x28, %r25
	.word 0xd2c689e0  ! 4682: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r9
	.word 0xd89d2000  ! 4683: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r12
	.word 0x87802025  ! 4684: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4a544a0  ! 4685: STWA_R	stwa	%r10, [%r21 + %r0] 0x25
	.word 0x87802072  ! 4686: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f0, %r23
	.word 0xd4d56000  ! 4688: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r10
	mov	0x48, %r17
	.word 0xdebf8e60  ! 4690: STDA_R	stda	%r15, [%r30 + %r0] 0x73
	mov	0x78, %r17
	mov	0x7c0, %r22
	.word 0xdc9d44a0  ! 4693: LDDA_R	ldda	[%r21, %r0] 0x25, %r14
	mov	0x30, %r17
	.word 0xd2f52000  ! 4695: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	.word 0x8780204f  ! 4696: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c0, %r23
	.word 0x87802020  ! 4698: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ac6000  ! 4699: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd0a48400  ! 4700: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	mov	0x3e0, %r20
	.word 0x87802074  ! 4702: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4703: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r20
	mov	0x28, %r19
	mov	0x10, %r16
	.word 0xdea4e000  ! 4707: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	wr_tick_cmpr_2_53:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xc6, %g2
	or	%g4, 0xe0, %g4
	or	%g6, 0xf4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdeaca000  ! 4709: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xdea46000  ! 4710: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xd8b609e0  ! 4711: STHA_R	stha	%r12, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 4712: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcb609e0  ! 4713: STHA_R	stha	%r14, [%r24 + %r0] 0x4f
	mov	0x8, %r25
	mov	0x3c8, %r22
	.word 0xd29ee000  ! 4716: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r9
	.word 0x87802020  ! 4717: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r25
	.word 0x87802072  ! 4719: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 4720: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 4721: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd28e2000  ! 4722: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	mov	0x7e0, %r22
	.word 0xdca40400  ! 4724: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	mov	0x8, %r24
	.word 0xd8f6e000  ! 4726: STXA_I	stxa	%r12, [%r27 + 0x0000] %asi
	.word 0xd2bc0400  ! 4727: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xdef7ce40  ! 4728: STXA_R	stxa	%r15, [%r31 + %r0] 0x72
	mov	0x0, %r25
	mov	0x3f0, %r21
	mov	0x7d0, %r23
	mov	0x38, %r16
	.word 0xd0c4c400  ! 4733: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	.word 0xd8be6000  ! 4734: STDA_I	stda	%r12, [%r25 + 0x0000] %asi
	mov	0x8, %r19
	.word 0x87802074  ! 4736: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4737: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bf0e60  ! 4738: STDA_R	stda	%r11, [%r28 + %r0] 0x73
	mov	0x7f8, %r22
	mov	0x60, %r26
	.word 0xd48d44a0  ! 4741: LDUBA_R	lduba	[%r21, %r0] 0x25, %r10
	.word 0x87802074  ! 4742: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4743: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8cc6000  ! 4744: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r12
	.word 0xd8ac6000  ! 4745: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 4746: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4747: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd48e49e0  ! 4748: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r10
	.word 0xd6c70e60  ! 4749: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r11
	.word 0xd0cfa000  ! 4750: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	mov	0x3f0, %r22
	mov	0x40, %r18
	.word 0xd0af8e60  ! 4753: STBA_R	stba	%r8, [%r30 + %r0] 0x73
	mov	0x3e0, %r20
	mov	0x30, %r27
	.word 0x87802072  ! 4756: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6de89e0  ! 4757: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r11
	.word 0xd2cf4e80  ! 4758: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r9
	.word 0xd8f56000  ! 4759: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	mov	0x70, %r24
	.word 0xd8ac4400  ! 4761: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xdaf56000  ! 4762: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	mov	0x7d0, %r20
	mov	0x7d0, %r22
	.word 0x87802074  ! 4765: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdab56000  ! 4766: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	mov	0x50, %r25
	.word 0xdadde000  ! 4768: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r13
	.word 0xdad5a000  ! 4769: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r13
	.word 0xdab5e000  ! 4770: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0xd09f8e80  ! 4771: LDDA_R	ldda	[%r30, %r0] 0x74, %r8
	mov	0x7d8, %r20
	mov	0x18, %r17
	mov	0x7c0, %r21
	.word 0xd2f5a000  ! 4775: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	mov	0x78, %r19
	.word 0xd2a5e000  ! 4777: STWA_I	stwa	%r9, [%r23 + 0x0000] %asi
	.word 0xd2a56000  ! 4778: STWA_I	stwa	%r9, [%r21 + 0x0000] %asi
	.word 0xd2cda000  ! 4779: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r9
	.word 0x87802025  ! 4780: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c0, %r23
	mov	0x40, %r18
	mov	0x58, %r17
	mov	0x38, %r16
	.word 0x87802025  ! 4785: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0dd44a0  ! 4786: LDXA_R	ldxa	[%r21, %r0] 0x25, %r8
	.word 0xde878e80  ! 4787: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r15
	.word 0x87802020  ! 4788: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r27
	.word 0xd8d4e000  ! 4790: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0xd4cc4400  ! 4791: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r10
	.word 0xd8c6c9e0  ! 4792: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r12
	.word 0xdcf40400  ! 4793: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	mov	0x60, %r24
	.word 0x87802072  ! 4795: WRASI_I	wr	%r0, 0x0072, %asi
	wr_tick_cmpr_2_54:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x82, %g2
	or	%g4, 0xec, %g4
	or	%g6, 0xf4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x10, %r25
	mov	0x3f8, %r23
	.word 0xd2afa000  ! 4799: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xd2bf6000  ! 4800: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd2af6000  ! 4801: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 4802: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 4803: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r26
	.word 0xd2f7e000  ! 4805: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	mov	0x38, %r24
	.word 0x87802020  ! 4807: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2972000  ! 4808: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xd2d7a000  ! 4809: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0x87802020  ! 4810: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4811: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2a7a000  ! 4812: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xdcafce60  ! 4813: STBA_R	stba	%r14, [%r31 + %r0] 0x73
	.word 0xd0df6000  ! 4814: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0872000  ! 4815: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xd4b78e60  ! 4816: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	.word 0xd8c689e0  ! 4817: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r12
	.word 0xd2af8e40  ! 4818: STBA_R	stba	%r9, [%r30 + %r0] 0x72
	.word 0xd2af8e60  ! 4819: STBA_R	stba	%r9, [%r30 + %r0] 0x73
	.word 0xdc9fa000  ! 4820: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 4821: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2b44400  ! 4822: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0x87802072  ! 4823: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d8, %r20
	.word 0xd8ccc400  ! 4825: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r12
	.word 0x87802072  ! 4826: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4827: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dce000  ! 4828: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r9
	.word 0xd28ce000  ! 4829: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	.word 0xdaf40400  ! 4830: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xde84a000  ! 4831: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	.word 0xdec46000  ! 4832: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	mov	0x40, %r24
	.word 0x87802072  ! 4834: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f8, %r23
	mov	0x78, %r25
	mov	0x68, %r19
	.word 0xd6af0e60  ! 4838: STBA_R	stba	%r11, [%r28 + %r0] 0x73
	.word 0xdcde2000  ! 4839: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r14
	.word 0xd8ce09e0  ! 4840: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r12
	.word 0xd4df8e40  ! 4841: LDXA_R	ldxa	[%r30, %r0] 0x72, %r10
	.word 0xdab4c400  ! 4842: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xd48c4400  ! 4843: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0xdab44400  ! 4844: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0x87802020  ! 4845: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbfa000  ! 4846: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	mov	0x68, %r16
	.word 0x87802073  ! 4848: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd296c9e0  ! 4849: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r9
	mov	0x7f8, %r21
	.word 0x87802020  ! 4851: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef544a0  ! 4852: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	.word 0xd0f70e80  ! 4853: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0xd6c40400  ! 4854: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r11
	mov	0x78, %r26
	.word 0xdab76000  ! 4856: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 4857: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6af0e80  ! 4858: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	.word 0xded72000  ! 4859: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xdebf6000  ! 4860: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	mov	0x40, %r27
	.word 0xdea72000  ! 4862: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	mov	0x3e8, %r23
	mov	0x7c0, %r22
	wr_tick_cmpr_2_55:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb6, %g2
	or	%g4, 0xed, %g4
	or	%g6, 0xac, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 4866: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd486c9e0  ! 4867: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r10
	.word 0xd4bc0400  ! 4868: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0x87802072  ! 4869: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c0, %r20
	.word 0xd8f72000  ! 4871: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8bfa000  ! 4872: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	mov	0x3c8, %r20
	mov	0x7f0, %r22
	mov	0x50, %r17
	.word 0xd8bf2000  ! 4876: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd8bcc400  ! 4877: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	mov	0x30, %r26
	.word 0x8780204f  ! 4879: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdec76000  ! 4880: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xdeaf6000  ! 4881: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 4882: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebe2000  ! 4883: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	wr_tick_cmpr_2_56:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb4, %g2
	or	%g4, 0xdc, %g4
	or	%g6, 0xcd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3f0, %r22
	.word 0xd2dcc400  ! 4886: LDXA_R	ldxa	[%r19, %r0] 0x20, %r9
	.word 0xdcbc4400  ! 4887: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	mov	0x7c8, %r20
	.word 0x87802072  ! 4889: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a7a000  ! 4890: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4b7e000  ! 4891: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	mov	0x48, %r24
	.word 0x87802073  ! 4893: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb4c400  ! 4894: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xdcb4a000  ! 4895: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xd0d78e40  ! 4896: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r8
	.word 0xdca689e0  ! 4897: STWA_R	stwa	%r14, [%r26 + %r0] 0x4f
	.word 0xd29ce000  ! 4898: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	mov	0x40, %r27
	.word 0xd2d4a000  ! 4900: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	.word 0xd2ac8400  ! 4901: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	mov	0x40, %r27
	.word 0x87802073  ! 4903: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f4a000  ! 4904: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xdac7ce60  ! 4905: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r13
	.word 0x8780204f  ! 4906: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 4907: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 4908: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0878e60  ! 4909: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r8
	.word 0xdcf584a0  ! 4910: STXA_R	stxa	%r14, [%r22 + %r0] 0x25
	.word 0xd68da000  ! 4911: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r11
	.word 0xd6bd2000  ! 4912: STDA_I	stda	%r11, [%r20 + 0x0000] %asi
	.word 0xd6ad6000  ! 4913: STBA_I	stba	%r11, [%r21 + 0x0000] %asi
	.word 0xd6b52000  ! 4914: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	.word 0xd6d52000  ! 4915: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r11
	.word 0xd48504a0  ! 4916: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r10
	mov	0x3d8, %r22
	mov	0x70, %r17
	.word 0x87802072  ! 4919: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r16
	mov	0x0, %r19
	.word 0xd29c2000  ! 4922: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	.word 0x87802025  ! 4923: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a74e40  ! 4924: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	.word 0xd49e2000  ! 4925: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r10
	.word 0x87802020  ! 4926: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r19
	mov	0x48, %r24
	mov	0x7d8, %r23
	.word 0xd4ac6000  ! 4930: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	.word 0xd2a78e60  ! 4931: STWA_R	stwa	%r9, [%r30 + %r0] 0x73
	.word 0xd8878e60  ! 4932: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r12
	.word 0xded46000  ! 4933: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	mov	0x3c8, %r21
	.word 0xdedc2000  ! 4935: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r15
	.word 0xdebc6000  ! 4936: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 4937: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebc6000  ! 4938: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xd6b5c4a0  ! 4939: STHA_R	stha	%r11, [%r23 + %r0] 0x25
	.word 0xdeb4c400  ! 4940: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 4941: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdab78e40  ! 4942: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	mov	0x78, %r27
	.word 0x87802025  ! 4944: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f74e40  ! 4945: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	.word 0xdad7a000  ! 4946: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	mov	0x28, %r26
	.word 0xda9fa000  ! 4948: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xd4bc4400  ! 4949: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0x87802025  ! 4950: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 4951: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaafce60  ! 4952: STBA_R	stba	%r13, [%r31 + %r0] 0x73
	.word 0xdebcc400  ! 4953: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	.word 0x87802073  ! 4954: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2bf6000  ! 4955: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 4956: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdec584a0  ! 4957: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r15
	.word 0xd48d04a0  ! 4958: LDUBA_R	lduba	[%r20, %r0] 0x25, %r10
	mov	0x3e0, %r21
	wr_tick_cmpr_2_57:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe8, %g2
	or	%g4, 0xeb, %g4
	or	%g6, 0xac, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x60, %r19
	.word 0xd685e000  ! 4962: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r11
	.word 0xd6952000  ! 4963: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r11
	.word 0xd6dde000  ! 4964: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r11
	mov	0x68, %r27
	.word 0xd6bda000  ! 4966: STDA_I	stda	%r11, [%r22 + 0x0000] %asi
	.word 0xd6a52000  ! 4967: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	.word 0xdcbd44a0  ! 4968: STDA_R	stda	%r14, [%r21 + %r0] 0x25
	mov	0x3e8, %r21
	.word 0xdab5a000  ! 4970: STHA_I	stha	%r13, [%r22 + 0x0000] %asi
	.word 0xd4d609e0  ! 4971: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r10
	.word 0xdab5e000  ! 4972: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0xd2ac0400  ! 4973: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	mov	0x28, %r17
	.word 0xdaae09e0  ! 4975: STBA_R	stba	%r13, [%r24 + %r0] 0x4f
	.word 0xd2cd04a0  ! 4976: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r9
	.word 0xd2b5a000  ! 4977: STHA_I	stha	%r9, [%r22 + 0x0000] %asi
	.word 0xd2b56000  ! 4978: STHA_I	stha	%r9, [%r21 + 0x0000] %asi
	.word 0xd2a52000  ! 4979: STWA_I	stwa	%r9, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 4980: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69649e0  ! 4981: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r11
	.word 0xd4cf8e80  ! 4982: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r10
	.word 0xd8856000  ! 4983: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	.word 0xd8956000  ! 4984: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r12
	.word 0x87802073  ! 4985: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8d42000  ! 4986: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0xdc9c0400  ! 4987: LDDA_R	ldda	[%r16, %r0] 0x20, %r14
	.word 0xd4b48400  ! 4988: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd8cfce40  ! 4989: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r12
	.word 0xd2a42000  ! 4990: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	mov	0x7e0, %r22
	mov	0x3c0, %r22
	.word 0xdebc4400  ! 4993: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0xd4940400  ! 4994: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	.word 0xd6dce000  ! 4995: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0xdcb4c400  ! 4996: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xd8d44400  ! 4997: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	mov	0x28, %r26
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_1:
	mov	0x58, %r26
	mov	0x8, %r24
	.word 0xd29c0400  ! 3: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	.word 0x87802073  ! 4: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r25
	mov	0x70, %r17
	.word 0x87802020  ! 7: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r23
	.word 0xdecc8400  ! 9: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	.word 0xdedce000  ! 10: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r15
	.word 0xda8d44a0  ! 11: LDUBA_R	lduba	[%r21, %r0] 0x25, %r13
	mov	0x58, %r19
	.word 0xdaf78e60  ! 13: STXA_R	stxa	%r13, [%r30 + %r0] 0x73
	.word 0xd0ac2000  ! 14: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xde9dc4a0  ! 15: LDDA_R	ldda	[%r23, %r0] 0x25, %r15
	.word 0x87802020  ! 16: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r17
	.word 0xde9c4400  ! 18: LDDA_R	ldda	[%r17, %r0] 0x20, %r15
	.word 0x8780204f  ! 19: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2d78e80  ! 20: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r9
	.word 0xd0b5e000  ! 21: STHA_I	stha	%r8, [%r23 + 0x0000] %asi
	.word 0xd0f70e60  ! 22: STXA_R	stxa	%r8, [%r28 + %r0] 0x73
	.word 0xd4f52000  ! 23: STXA_I	stxa	%r10, [%r20 + 0x0000] %asi
	.word 0xd4a56000  ! 24: STWA_I	stwa	%r10, [%r21 + 0x0000] %asi
	.word 0x87802025  ! 25: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4b7e000  ! 26: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	mov	0x30, %r18
	.word 0xd0f4c400  ! 28: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0xd6f72000  ! 29: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd0de89e0  ! 30: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r8
	.word 0xd887a000  ! 31: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8848400  ! 32: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r12
	.word 0xd0f40400  ! 33: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xdedf6000  ! 34: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xd4dfce80  ! 35: LDXA_R	ldxa	[%r31, %r0] 0x74, %r10
	mov	0x0, %r17
	.word 0xd4972000  ! 37: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0xd49fe000  ! 38: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd4a7a000  ! 39: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	mov	0x60, %r18
	.word 0xd4d544a0  ! 41: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r10
	.word 0xd0c5c4a0  ! 42: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r8
	.word 0xd48f6000  ! 43: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0x87802072  ! 44: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7e8, %r20
	.word 0xd49ca000  ! 46: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd4b46000  ! 47: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xd4d48400  ! 48: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	mov	0x7f0, %r21
	.word 0xd28ca000  ! 50: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0xd4b74e80  ! 51: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	mov	0x68, %r18
	.word 0xd0d44400  ! 53: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r8
	.word 0xd2dcc400  ! 54: LDXA_R	ldxa	[%r19, %r0] 0x20, %r9
	mov	0x3e0, %r23
	wr_tick_cmpr_1_0:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x87, %g2
	or	%g4, 0xe6, %g4
	or	%g6, 0x91, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	wr_tick_cmpr_1_1:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x92, %g2
	or	%g4, 0xd9, %g4
	or	%g6, 0xa7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802074  ! 58: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4d52000  ! 59: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r10
	.word 0xd4ad6000  ! 60: STBA_I	stba	%r10, [%r21 + 0x0000] %asi
	mov	0x7f8, %r20
	.word 0xda9f8e60  ! 62: LDDA_R	ldda	[%r30, %r0] 0x73, %r13
	.word 0xd6dc4400  ! 63: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xd0b5e000  ! 64: STHA_I	stha	%r8, [%r23 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0xd0bd6000  ! 66: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0x87802074  ! 67: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xded78e40  ! 68: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r15
	.word 0xd0cf0e60  ! 69: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r8
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802020  ! 71: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ae6000  ! 72: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0xd48ee000  ! 73: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r10
	.word 0x87802074  ! 74: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4cfa000  ! 75: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	mov	0x7c8, %r22
	.word 0xd4b44400  ! 77: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	.word 0xd0adc4a0  ! 78: STBA_R	stba	%r8, [%r23 + %r0] 0x25
	.word 0xd4a78e80  ! 79: STWA_R	stwa	%r10, [%r30 + %r0] 0x74
	.word 0xd687a000  ! 80: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0x87802020  ! 81: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8870e80  ! 82: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r12
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802020  ! 84: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda962000  ! 85: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r13
	.word 0xd8f78e40  ! 86: STXA_R	stxa	%r12, [%r30 + %r0] 0x72
	mov	0x7f8, %r20
	mov	0x50, %r25
	.word 0x87802020  ! 89: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f7a000  ! 90: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd2b4c400  ! 91: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xdca609e0  ! 92: STWA_R	stwa	%r14, [%r24 + %r0] 0x4f
	.word 0xd6c72000  ! 93: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0x87802025  ! 94: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 95: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd89c0400  ! 96: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0cc2000  ! 98: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	.word 0xd6ce89e0  ! 99: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r11
	.word 0xd0d42000  ! 100: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r8
	mov	0x20, %r26
	.word 0x87802074  ! 102: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdecc0400  ! 103: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r15
	.word 0xd0dcc400  ! 104: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0xd08e49e0  ! 105: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r8
	.word 0xdc846000  ! 106: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	mov	0x8, %r17
	.word 0xdcbc2000  ! 108: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 109: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdadc0400  ! 110: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	mov	0x30, %r16
	.word 0x87802020  ! 112: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad4e000  ! 113: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r13
	.word 0xdcad04a0  ! 114: STBA_R	stba	%r14, [%r20 + %r0] 0x25
	.word 0x87802020  ! 115: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a40400  ! 116: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0x87802025  ! 117: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebca000  ! 118: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xd6b40400  ! 119: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	mov	0x18, %r26
	.word 0xd8ac0400  ! 121: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xdcbca000  ! 122: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 123: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r16
	.word 0xdcdd2000  ! 125: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r14
	mov	0x0, %r26
	.word 0xded70e80  ! 127: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r15
	.word 0x87802073  ! 128: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc978e40  ! 129: LDUHA_R	lduha	[%r30, %r0] 0x72, %r14
	.word 0xd4a4e000  ! 130: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xd8f70e40  ! 132: STXA_R	stxa	%r12, [%r28 + %r0] 0x72
	mov	0x70, %r18
	.word 0xd2cce000  ! 134: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	mov	0x3f0, %r20
	.word 0xd28ce000  ! 136: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	.word 0xd8bf8e60  ! 137: STDA_R	stda	%r12, [%r30 + %r0] 0x73
	.word 0xdab46000  ! 138: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	mov	0x8, %r19
	.word 0xdab4a000  ! 140: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0xd6f609e0  ! 141: STXA_R	stxa	%r11, [%r24 + %r0] 0x4f
	.word 0xd2f4e000  ! 142: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 143: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 144: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2cc6000  ! 145: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	.word 0xdadc8400  ! 146: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	.word 0xdca42000  ! 147: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 148: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcace000  ! 149: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xd2c74e80  ! 151: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r9
	.word 0x87802072  ! 152: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc8e89e0  ! 153: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r14
	.word 0xdab42000  ! 154: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xdabca000  ! 155: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdaa46000  ! 156: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	.word 0xd48c8400  ! 157: LDUBA_R	lduba	[%r18, %r0] 0x20, %r10
	.word 0xd2aca000  ! 158: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0xd49e89e0  ! 159: LDDA_R	ldda	[%r26, %r0] 0x4f, %r10
	.word 0xdeaf4e60  ! 160: STBA_R	stba	%r15, [%r29 + %r0] 0x73
	.word 0xd0d48400  ! 161: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	.word 0xd0cc6000  ! 162: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	.word 0xd0842000  ! 163: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r8
	.word 0xd0946000  ! 164: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0xd2df0e60  ! 165: LDXA_R	ldxa	[%r28, %r0] 0x73, %r9
	.word 0x87802025  ! 166: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f70e80  ! 167: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0xd68da000  ! 168: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r11
	.word 0x87802074  ! 169: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4cd04a0  ! 170: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r10
	mov	0x3d8, %r23
	.word 0x8780204f  ! 172: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r27
	.word 0x87802020  ! 174: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c78e40  ! 175: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r12
	.word 0xd48ca000  ! 176: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r10
	.word 0xdcc40400  ! 177: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	.word 0x87802073  ! 178: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdadce000  ! 179: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xd68f4e80  ! 180: LDUBA_R	lduba	[%r29, %r0] 0x74, %r11
	mov	0x50, %r18
	.word 0xd2f42000  ! 182: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0xdcce49e0  ! 183: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r14
	.word 0x8780204f  ! 184: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabec9e0  ! 185: STDA_R	stda	%r13, [%r27 + %r0] 0x4f
	mov	0x30, %r26
	.word 0x87802073  ! 187: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 188: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 189: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 190: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8d44400  ! 191: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	.word 0xd6f72000  ! 192: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6df6000  ! 193: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6bfa000  ! 194: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd6bf6000  ! 195: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 196: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 197: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcd6c9e0  ! 198: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r14
	.word 0xdcb66000  ! 199: STHA_I	stha	%r14, [%r25 + 0x0000] %asi
	.word 0xd0d48400  ! 200: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	mov	0x60, %r19
	.word 0xd2af4e60  ! 202: STBA_R	stba	%r9, [%r29 + %r0] 0x73
	mov	0x3c8, %r21
	mov	0x0, %r25
	.word 0x87802072  ! 205: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 206: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad62000  ! 207: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r13
	.word 0xdabea000  ! 208: STDA_I	stda	%r13, [%r26 + 0x0000] %asi
	.word 0xd4b4c400  ! 209: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0xdaae6000  ! 210: STBA_I	stba	%r13, [%r25 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0xdab66000  ! 212: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	mov	0x78, %r17
	.word 0xdcbcc400  ! 214: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xdc9f4e80  ! 215: LDDA_R	ldda	[%r29, %r0] 0x74, %r14
	.word 0xdaa689e0  ! 216: STWA_R	stwa	%r13, [%r26 + %r0] 0x4f
	mov	0x70, %r17
	mov	0x3c0, %r22
	.word 0x87802074  ! 219: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd48c0400  ! 220: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	.word 0xd2d7e000  ! 221: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xd88c4400  ! 222: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0xdcdf6000  ! 223: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	mov	0x40, %r27
	mov	0x8, %r18
	.word 0x8780204f  ! 226: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0d609e0  ! 227: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r8
	.word 0xd2a544a0  ! 228: STWA_R	stwa	%r9, [%r21 + %r0] 0x25
	mov	0x20, %r25
	.word 0x87802074  ! 230: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcace000  ! 231: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0xdcd584a0  ! 232: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r14
	.word 0xdc9f8e60  ! 233: LDDA_R	ldda	[%r30, %r0] 0x73, %r14
	.word 0xd2f42000  ! 234: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0xdabcc400  ! 235: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	.word 0x87802072  ! 236: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde8dc4a0  ! 237: LDUBA_R	lduba	[%r23, %r0] 0x25, %r15
	.word 0xdead44a0  ! 238: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	.word 0xdc97e000  ! 239: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xdc9fa000  ! 240: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0xdcaf6000  ! 241: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	mov	0x3d0, %r21
	.word 0x8780204f  ! 243: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc862000  ! 244: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r14
	.word 0xd8f70e60  ! 245: STXA_R	stxa	%r12, [%r28 + %r0] 0x73
	.word 0x87802073  ! 246: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r24
	mov	0x3c0, %r20
	mov	0x50, %r18
	.word 0xdccc2000  ! 250: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r14
	.word 0xd0a70e80  ! 251: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0x87802020  ! 252: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49f4e40  ! 253: LDDA_R	ldda	[%r29, %r0] 0x72, %r10
	.word 0xde87ce60  ! 254: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r15
	.word 0xdc846000  ! 255: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	mov	0x8, %r24
	mov	0x70, %r27
	.word 0xdc8ca000  ! 258: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r14
	.word 0xdcd46000  ! 259: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	.word 0xd4c584a0  ! 260: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r10
	.word 0xd8cc6000  ! 261: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r12
	.word 0xdcdfce40  ! 262: LDXA_R	ldxa	[%r31, %r0] 0x72, %r14
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802073  ! 264: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef5a000  ! 265: STXA_I	stxa	%r15, [%r22 + 0x0000] %asi
	.word 0xdec5e000  ! 266: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r15
	.word 0xde956000  ! 267: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r15
	.word 0xdeb5e000  ! 268: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	.word 0xdc9f0e60  ! 269: LDDA_R	ldda	[%r28, %r0] 0x73, %r14
	.word 0xd6dd2000  ! 270: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r11
	.word 0xd6ad2000  ! 271: STBA_I	stba	%r11, [%r20 + 0x0000] %asi
	.word 0xd6a5e000  ! 272: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 273: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd69f6000  ! 274: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	mov	0x20, %r27
	.word 0x87802025  ! 276: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8ad84a0  ! 277: STBA_R	stba	%r12, [%r22 + %r0] 0x25
	.word 0xd284c400  ! 278: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r9
	.word 0xda84e000  ! 279: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r13
	mov	0x48, %r19
	mov	0x10, %r18
	.word 0x87802025  ! 282: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdea70e80  ! 283: STWA_R	stwa	%r15, [%r28 + %r0] 0x74
	.word 0xdebc2000  ! 284: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xd0d4c400  ! 285: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	.word 0x87802074  ! 286: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda8c8400  ! 287: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	.word 0xd2cf0e60  ! 288: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r9
	.word 0xd8af0e60  ! 289: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	mov	0x68, %r17
	.word 0xdea5a000  ! 291: STWA_I	stwa	%r15, [%r22 + 0x0000] %asi
	.word 0xdcbc4400  ! 292: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0xd2d40400  ! 293: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	.word 0xdedd04a0  ! 294: LDXA_R	ldxa	[%r20, %r0] 0x25, %r15
	.word 0x87802020  ! 295: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cce000  ! 296: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	mov	0x7f0, %r22
	mov	0x48, %r16
	.word 0xd6c70e40  ! 299: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r11
	.word 0xd0974e60  ! 300: LDUHA_R	lduha	[%r29, %r0] 0x73, %r8
	.word 0xd0b48400  ! 301: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xd49c6000  ! 302: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 303: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4ace000  ! 304: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 305: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a7e000  ! 306: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 307: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4dfe000  ! 308: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd2b5c4a0  ! 309: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	mov	0x28, %r17
	mov	0x10, %r24
	.word 0x87802020  ! 312: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 313: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 314: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde9f8e40  ! 315: LDDA_R	ldda	[%r30, %r0] 0x72, %r15
	mov	0x7e0, %r22
	wr_tick_cmpr_1_2:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x96, %g2
	or	%g4, 0xfc, %g4
	or	%g6, 0xfa, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x58, %r16
	.word 0x87802072  ! 319: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabf4e80  ! 320: STDA_R	stda	%r13, [%r29 + %r0] 0x74
	mov	0x8, %r27
	mov	0x7f0, %r21
	mov	0x3e0, %r21
	mov	0x30, %r25
	.word 0xdecea000  ! 325: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r15
	.word 0xd09609e0  ! 326: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r8
	wr_tick_cmpr_1_3:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf1, %g2
	or	%g4, 0xb8, %g4
	or	%g6, 0x96, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x20, %r16
	.word 0xd6c6e000  ! 329: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r11
	mov	0x28, %r18
	mov	0x20, %r26
	.word 0xd6d66000  ! 332: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r11
	mov	0x10, %r18
	.word 0x8780204f  ! 334: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6ad2000  ! 335: STBA_I	stba	%r11, [%r20 + 0x0000] %asi
	.word 0xdac689e0  ! 336: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r13
	.word 0xdcd56000  ! 337: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r14
	mov	0x8, %r25
	.word 0xd6af0e60  ! 339: STBA_R	stba	%r11, [%r28 + %r0] 0x73
	mov	0x48, %r26
	.word 0x87802025  ! 341: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r19
	.word 0xdaf70e40  ! 343: STXA_R	stxa	%r13, [%r28 + %r0] 0x72
	.word 0xd4f4a000  ! 344: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0xdcb40400  ! 345: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	mov	0x60, %r26
	.word 0x87802074  ! 347: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 348: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b56000  ! 349: STHA_I	stha	%r10, [%r21 + 0x0000] %asi
	.word 0xd4bf0e60  ! 350: STDA_R	stda	%r10, [%r28 + %r0] 0x73
	.word 0xd0d40400  ! 351: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	mov	0x78, %r25
	.word 0x87802020  ! 353: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd496c9e0  ! 354: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r10
	mov	0x28, %r17
	mov	0x8, %r24
	.word 0xd0a76000  ! 357: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd4cfce80  ! 358: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r10
	.word 0xdaf7a000  ! 359: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdaaf6000  ! 360: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xd2940400  ! 361: LDUHA_R	lduha	[%r16, %r0] 0x20, %r9
	.word 0xdcdfa000  ! 362: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	wr_tick_cmpr_1_4:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xab, %g2
	or	%g4, 0xac, %g4
	or	%g6, 0xc5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x18, %r17
	.word 0xd0d584a0  ! 365: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r8
	.word 0xd6f6c9e0  ! 366: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	mov	0x20, %r18
	mov	0x8, %r18
	.word 0x87802073  ! 369: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2866000  ! 370: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r9
	.word 0xd2c62000  ! 371: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r9
	.word 0xd296a000  ! 372: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r9
	.word 0xd2de2000  ! 373: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r9
	.word 0xd2f6a000  ! 374: STXA_I	stxa	%r9, [%r26 + 0x0000] %asi
	mov	0x8, %r19
	.word 0xdcb70e40  ! 376: STHA_R	stha	%r14, [%r28 + %r0] 0x72
	mov	0x8, %r18
	.word 0x87802025  ! 378: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb5e000  ! 379: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	mov	0x60, %r26
	.word 0x8780204f  ! 381: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b7ce60  ! 382: STHA_R	stha	%r11, [%r31 + %r0] 0x73
	.word 0x87802020  ! 383: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c7ce80  ! 384: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r12
	.word 0x8780204f  ! 385: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8f48400  ! 386: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xdad544a0  ! 387: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r13
	.word 0xd687ce40  ! 388: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r11
	mov	0x50, %r27
	.word 0x87802072  ! 390: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7c8, %r22
	.word 0x87802073  ! 393: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 394: WRASI_I	wr	%r0, 0x0073, %asi
	wr_tick_cmpr_1_5:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb0, %g2
	or	%g4, 0x89, %g4
	or	%g6, 0x8a, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0dee000  ! 396: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r8
	.word 0xd0f6e000  ! 397: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 398: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r18
	mov	0x3e0, %r22
	mov	0x48, %r27
	.word 0xdec78e60  ! 402: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r15
	.word 0xd4af6000  ! 403: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd4b7a000  ! 404: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	mov	0x58, %r24
	.word 0x87802020  ! 406: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 407: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49f6000  ! 408: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0xd0a44400  ! 409: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xd8cf6000  ! 410: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0xd8cf6000  ! 411: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	mov	0x60, %r16
	.word 0xdabc4400  ! 413: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xdc97ce60  ! 414: LDUHA_R	lduha	[%r31, %r0] 0x73, %r14
	.word 0xd6f44400  ! 415: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0xd6f74e60  ! 416: STXA_R	stxa	%r11, [%r29 + %r0] 0x73
	mov	0x8, %r27
	.word 0xdecfa000  ! 418: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	mov	0x70, %r27
	.word 0xdca40400  ! 420: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xdc840400  ! 421: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	.word 0x87802020  ! 422: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0c5e000  ! 423: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r8
	.word 0xd0f52000  ! 424: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	.word 0xd0d5a000  ! 425: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r8
	.word 0x87802074  ! 426: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d0, %r22
	mov	0x60, %r18
	.word 0xd69e89e0  ! 429: LDDA_R	ldda	[%r26, %r0] 0x4f, %r11
	mov	0x38, %r19
	.word 0xd0a7ce40  ! 431: STWA_R	stwa	%r8, [%r31 + %r0] 0x72
	.word 0xda8ce000  ! 432: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	.word 0xdadc6000  ! 433: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	mov	0x48, %r16
	.word 0x87802020  ! 435: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb40400  ! 436: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	ta	T_CHANGE_NONHPRIV	! macro
	wr_tick_cmpr_1_6:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc1, %g2
	or	%g4, 0xa3, %g4
	or	%g6, 0xac, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 439: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c4a000  ! 440: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	mov	0x0, %r26
	mov	0x3f0, %r22
	.word 0xd2842000  ! 443: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r9
	mov	0x70, %r27
	.word 0x87802025  ! 445: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2a7e000  ! 446: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xdccf0e80  ! 447: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r14
	.word 0xde874e60  ! 448: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r15
	.word 0xdef7a000  ! 449: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdedf6000  ! 450: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	mov	0x10, %r18
	.word 0x87802020  ! 452: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 453: WRASI_I	wr	%r0, 0x004f, %asi
	wr_tick_cmpr_1_7:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x94, %g2
	or	%g4, 0x96, %g4
	or	%g6, 0xaa, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdef42000  ! 455: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xd49e49e0  ! 456: LDDA_R	ldda	[%r25, %r0] 0x4f, %r10
	.word 0xd4a689e0  ! 457: STWA_R	stwa	%r10, [%r26 + %r0] 0x4f
	.word 0xd4a46000  ! 458: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	mov	0x0, %r18
	.word 0xd4d46000  ! 460: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r10
	.word 0x87802072  ! 461: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef78e40  ! 462: STXA_R	stxa	%r15, [%r30 + %r0] 0x72
	wr_tick_cmpr_1_8:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf3, %g2
	or	%g4, 0xd5, %g4
	or	%g6, 0xb5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x0, %r18
	.word 0x87802020  ! 465: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bc0400  ! 466: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0xd6a46000  ! 467: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 468: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d8, %r22
	.word 0xd2a7ce40  ! 470: STWA_R	stwa	%r9, [%r31 + %r0] 0x72
	.word 0xd2d6a000  ! 471: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 472: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 473: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d44400  ! 474: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r9
	.word 0xd6f544a0  ! 475: STXA_R	stxa	%r11, [%r21 + %r0] 0x25
	.word 0x87802020  ! 476: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cfe000  ! 477: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	mov	0x8, %r16
	.word 0xd68fe000  ! 479: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xd6976000  ! 480: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	mov	0x78, %r17
	.word 0xd6b72000  ! 482: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 483: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a4e000  ! 484: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0xd6ad44a0  ! 485: STBA_R	stba	%r11, [%r21 + %r0] 0x25
	mov	0x68, %r19
	mov	0x30, %r19
	.word 0xd0a7ce80  ! 488: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	.word 0xdc8f4e40  ! 489: LDUBA_R	lduba	[%r29, %r0] 0x72, %r14
	wr_tick_cmpr_1_9:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xec, %g2
	or	%g4, 0x80, %g4
	or	%g6, 0xbe, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0ac8400  ! 491: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	mov	0x18, %r16
	mov	0x78, %r17
	.word 0x87802025  ! 494: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6872000  ! 495: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6b76000  ! 496: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xdc8ec9e0  ! 497: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r14
	.word 0xda87ce40  ! 498: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r13
	mov	0x7d0, %r22
	.word 0x87802074  ! 500: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 501: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0872000  ! 502: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xd4d504a0  ! 503: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r10
	mov	0x7d0, %r21
	.word 0xdeb78e80  ! 505: STHA_R	stha	%r15, [%r30 + %r0] 0x74
	.word 0xdcafe000  ! 506: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdcf76000  ! 507: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0xdccf6000  ! 509: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	mov	0x7c0, %r23
	.word 0xdcd72000  ! 511: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xdcf76000  ! 512: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcd7e000  ! 513: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	mov	0x60, %r26
	.word 0xdca72000  ! 515: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdc8fe000  ! 516: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	mov	0x28, %r19
	.word 0xdcb7e000  ! 518: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 519: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcd4a000  ! 520: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	.word 0xdcb4a000  ! 521: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xd89f0e40  ! 522: LDDA_R	ldda	[%r28, %r0] 0x72, %r12
	.word 0xd0f584a0  ! 523: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	.word 0xd6dec9e0  ! 524: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r11
	.word 0xd4f4a000  ! 525: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xd0844400  ! 527: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r8
	.word 0xd2adc4a0  ! 528: STBA_R	stba	%r9, [%r23 + %r0] 0x25
	.word 0xdacce000  ! 529: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r13
	.word 0xdadc6000  ! 530: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xd28f8e40  ! 531: LDUBA_R	lduba	[%r30, %r0] 0x72, %r9
	wr_tick_cmpr_1_10:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x88, %g2
	or	%g4, 0xfa, %g4
	or	%g6, 0xc3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7c8, %r20
	.word 0xd2af4e80  ! 534: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	.word 0xdaa4a000  ! 535: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xd6a609e0  ! 536: STWA_R	stwa	%r11, [%r24 + %r0] 0x4f
	.word 0xd2dca000  ! 537: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r9
	.word 0x87802073  ! 538: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f72000  ! 539: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	mov	0x0, %r17
	mov	0x30, %r18
	.word 0xd2dfa000  ! 542: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xd6bf8e40  ! 543: STDA_R	stda	%r11, [%r30 + %r0] 0x72
	mov	0x58, %r26
	.word 0xd69f2000  ! 545: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xdadf8e80  ! 546: LDXA_R	ldxa	[%r30, %r0] 0x74, %r13
	.word 0xda948400  ! 547: LDUHA_R	lduha	[%r18, %r0] 0x20, %r13
	.word 0xd8af4e80  ! 548: STBA_R	stba	%r12, [%r29 + %r0] 0x74
	.word 0xd0bf4e80  ! 549: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	.word 0xdc9e89e0  ! 550: LDDA_R	ldda	[%r26, %r0] 0x4f, %r14
	.word 0x8780204f  ! 551: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r17
	.word 0x87802072  ! 553: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7c8, %r21
	.word 0x87802025  ! 555: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 556: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcd78e80  ! 557: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r14
	mov	0x68, %r17
	.word 0xdca6e000  ! 559: STWA_I	stwa	%r14, [%r27 + 0x0000] %asi
	.word 0xdcc66000  ! 560: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	.word 0xd8cc4400  ! 561: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r12
	.word 0xdcc70e40  ! 562: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r14
	.word 0xd4aee000  ! 563: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	mov	0x7f0, %r22
	.word 0xdaa4c400  ! 565: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0x87802073  ! 566: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 567: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4afe000  ! 568: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xdcbc8400  ! 569: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xd0848400  ! 570: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r8
	.word 0xd48f2000  ! 571: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4cdc4a0  ! 572: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r10
	mov	0x7f8, %r23
	.word 0xde9fe000  ! 574: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0x87802020  ! 575: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef6a000  ! 576: STXA_I	stxa	%r15, [%r26 + 0x0000] %asi
	.word 0xdebd84a0  ! 577: STDA_R	stda	%r15, [%r22 + %r0] 0x25
	.word 0xd696e000  ! 578: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	.word 0xd6d62000  ! 579: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r11
	mov	0x3e8, %r20
	.word 0xd0948400  ! 581: LDUHA_R	lduha	[%r18, %r0] 0x20, %r8
	.word 0x87802072  ! 582: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f8, %r20
	.word 0xd2dca000  ! 584: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r9
	mov	0x7e8, %r20
	mov	0x10, %r16
	.word 0xd2a4e000  ! 587: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0xd8bd44a0  ! 588: STDA_R	stda	%r12, [%r21 + %r0] 0x25
	.word 0xd6f4e000  ! 589: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 590: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 591: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 592: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r19
	.word 0xdeadc4a0  ! 594: STBA_R	stba	%r15, [%r23 + %r0] 0x25
	.word 0xdccf6000  ! 595: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0x87802074  ! 596: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 597: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf56000  ! 598: STXA_I	stxa	%r14, [%r21 + 0x0000] %asi
	mov	0x28, %r19
	.word 0xd6b504a0  ! 600: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	.word 0xd6be49e0  ! 601: STDA_R	stda	%r11, [%r25 + %r0] 0x4f
	.word 0xdaad6000  ! 602: STBA_I	stba	%r13, [%r21 + 0x0000] %asi
	.word 0xd8ddc4a0  ! 603: LDXA_R	ldxa	[%r23, %r0] 0x25, %r12
	.word 0xdead04a0  ! 604: STBA_R	stba	%r15, [%r20 + %r0] 0x25
	mov	0x70, %r17
	mov	0x28, %r26
	wr_tick_cmpr_1_11:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xd6, %g2
	or	%g4, 0xdd, %g4
	or	%g6, 0x9f, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x8, %r25
	.word 0x87802074  ! 609: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r16
	.word 0xd6872000  ! 611: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd2cf0e60  ! 612: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r9
	.word 0x87802072  ! 613: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b6a000  ! 614: STHA_I	stha	%r12, [%r26 + 0x0000] %asi
	.word 0xd8ae2000  ! 615: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	mov	0x60, %r26
	.word 0xd6d78e40  ! 617: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r11
	mov	0x78, %r17
	.word 0xd48e6000  ! 619: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r10
	mov	0x0, %r18
	.word 0xdcbd84a0  ! 621: STDA_R	stda	%r14, [%r22 + %r0] 0x25
	.word 0x87802020  ! 622: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4952000  ! 623: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r10
	mov	0x20, %r18
	.word 0xd4b5a000  ! 625: STHA_I	stha	%r10, [%r22 + 0x0000] %asi
	.word 0x87802074  ! 626: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r25
	.word 0xd4a7a000  ! 628: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xdc8689e0  ! 629: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r14
	.word 0xdcb78e80  ! 630: STHA_R	stha	%r14, [%r30 + %r0] 0x74
	.word 0xd6af6000  ! 631: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x18, %r25
	mov	0x18, %r24
	.word 0x8780204f  ! 634: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdab4c400  ! 635: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xd0f78e80  ! 636: STXA_R	stxa	%r8, [%r30 + %r0] 0x74
	.word 0xdcdca000  ! 637: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0x87802073  ! 638: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb44400  ! 639: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 640: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc9d6000  ! 641: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r14
	.word 0xde8e89e0  ! 642: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r15
	.word 0xd0cdc4a0  ! 643: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r8
	.word 0xdea48400  ! 644: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0x87802020  ! 645: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 646: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca42000  ! 647: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	mov	0x18, %r19
	.word 0xdcdc2000  ! 649: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r14
	.word 0x87802020  ! 650: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r25
	.word 0xd2b4c400  ! 652: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0x87802073  ! 653: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e8, %r20
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0d56000  ! 656: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r8
	.word 0xd0ad6000  ! 657: STBA_I	stba	%r8, [%r21 + 0x0000] %asi
	.word 0xd08ec9e0  ! 658: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r8
	mov	0x3f8, %r20
	.word 0xdaf56000  ! 660: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	.word 0xd4a70e80  ! 661: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	.word 0xd4c649e0  ! 662: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r10
	.word 0xd2cd6000  ! 663: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r9
	.word 0xdc940400  ! 664: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0x87802020  ! 665: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 666: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f76000  ! 667: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0xd88f4e60  ! 669: LDUBA_R	lduba	[%r29, %r0] 0x73, %r12
	.word 0xdec7e000  ! 670: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xd8acc400  ! 671: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0xdc87e000  ! 672: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	mov	0x48, %r24
	.word 0xdcbf2000  ! 674: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdc8584a0  ! 675: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r14
	mov	0x10, %r27
	.word 0xdec609e0  ! 677: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r15
	.word 0xd6c544a0  ! 678: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r11
	.word 0xdcd70e40  ! 679: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r14
	.word 0xdcbfa000  ! 680: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdcc7e000  ! 681: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0x87802074  ! 682: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xded70e80  ! 683: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r15
	mov	0x70, %r16
	.word 0xd8974e60  ! 685: LDUHA_R	lduha	[%r29, %r0] 0x73, %r12
	.word 0xd8f7e000  ! 686: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd294c400  ! 687: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	.word 0xdeb7ce60  ! 688: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	.word 0xdaf76000  ! 689: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	mov	0x7e0, %r20
	.word 0xd6ae09e0  ! 691: STBA_R	stba	%r11, [%r24 + %r0] 0x4f
	.word 0xd0976000  ! 692: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	mov	0x20, %r25
	.word 0x87802020  ! 694: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r18
	.word 0xdec44400  ! 696: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	mov	0x0, %r16
	mov	0x78, %r19
	mov	0x60, %r18
	.word 0xd88584a0  ! 700: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r12
	.word 0xd4af2000  ! 701: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd4bf2000  ! 702: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	mov	0x3d0, %r21
	mov	0x3c0, %r21
	.word 0xd4f76000  ! 705: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	mov	0x20, %r24
	.word 0xd4cf2000  ! 707: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4bfa000  ! 708: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xde8f0e80  ! 709: LDUBA_R	lduba	[%r28, %r0] 0x74, %r15
	.word 0xd297ce80  ! 710: LDUHA_R	lduha	[%r31, %r0] 0x74, %r9
	.word 0xd68f4e60  ! 711: LDUBA_R	lduba	[%r29, %r0] 0x73, %r11
	.word 0xdec7e000  ! 712: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xdedfa000  ! 713: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802072  ! 715: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde872000  ! 716: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xded76000  ! 717: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	mov	0x3d0, %r21
	mov	0x3d8, %r21
	mov	0x10, %r25
	mov	0x7f8, %r20
	mov	0x0, %r18
	.word 0xda840400  ! 723: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	.word 0xdca78e60  ! 724: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	.word 0xd48f6000  ! 725: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xd4f7a000  ! 726: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	mov	0x0, %r25
	.word 0xdea48400  ! 728: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xd0afa000  ! 729: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd0a7a000  ! 730: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0c7e000  ! 731: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0xda8649e0  ! 732: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r13
	.word 0xd8f44400  ! 733: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	mov	0x28, %r26
	.word 0xd09fce80  ! 735: LDDA_R	ldda	[%r31, %r0] 0x74, %r8
	.word 0xd68e09e0  ! 736: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r11
	.word 0xd8d5c4a0  ! 737: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r12
	.word 0xda8fa000  ! 738: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xd6948400  ! 739: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdeb70e80  ! 741: STHA_R	stha	%r15, [%r28 + %r0] 0x74
	.word 0xdc97ce40  ! 742: LDUHA_R	lduha	[%r31, %r0] 0x72, %r14
	.word 0xdcc7a000  ! 743: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xd0bc0400  ! 744: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	mov	0x10, %r26
	.word 0xdac7e000  ! 746: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xd6af8e80  ! 747: STBA_R	stba	%r11, [%r30 + %r0] 0x74
	.word 0xd2bfe000  ! 748: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 749: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd29ce000  ! 750: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xd2cc6000  ! 751: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	mov	0x3d8, %r20
	.word 0xd4b44400  ! 753: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	wr_tick_cmpr_1_12:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xdf, %g2
	or	%g4, 0xb4, %g4
	or	%g6, 0xbb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0974e80  ! 755: LDUHA_R	lduha	[%r29, %r0] 0x74, %r8
	.word 0xd8842000  ! 756: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	.word 0x87802074  ! 757: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 758: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd89ea000  ! 759: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r12
	mov	0x18, %r16
	mov	0x7d8, %r22
	.word 0x87802020  ! 762: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4afce60  ! 763: STBA_R	stba	%r10, [%r31 + %r0] 0x73
	.word 0x87802020  ! 764: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 765: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 766: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd49fa000  ! 767: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0xd4f7e000  ! 768: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4dfce60  ! 769: LDXA_R	ldxa	[%r31, %r0] 0x73, %r10
	.word 0xdcb544a0  ! 770: STHA_R	stha	%r14, [%r21 + %r0] 0x25
	.word 0x87802020  ! 771: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbf2000  ! 772: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xd88e89e0  ! 773: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r12
	mov	0x7e8, %r21
	.word 0xd0b7a000  ! 775: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xd0af6000  ! 777: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd0dfa000  ! 778: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0x87802020  ! 779: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bfa000  ! 780: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0xd0b584a0  ! 781: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	mov	0x7f0, %r20
	.word 0xd2f7a000  ! 783: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xd2a544a0  ! 784: STWA_R	stwa	%r9, [%r21 + %r0] 0x25
	.word 0xd8a70e80  ! 785: STWA_R	stwa	%r12, [%r28 + %r0] 0x74
	.word 0xdaaf4e40  ! 786: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	.word 0xd2a7a000  ! 787: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	mov	0x3f0, %r22
	mov	0x28, %r16
	.word 0xd287a000  ! 790: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 791: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f74e40  ! 792: STXA_R	stxa	%r8, [%r29 + %r0] 0x72
	.word 0xd6cdc4a0  ! 793: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r11
	.word 0xdc96e000  ! 794: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r14
	.word 0xd8df0e40  ! 795: LDXA_R	ldxa	[%r28, %r0] 0x72, %r12
	.word 0xd0f70e60  ! 796: STXA_R	stxa	%r8, [%r28 + %r0] 0x73
	mov	0x30, %r16
	mov	0x20, %r18
	mov	0x3f0, %r22
	mov	0x20, %r17
	mov	0x8, %r27
	.word 0xd0d6a000  ! 802: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r8
	.word 0xde85c4a0  ! 803: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r15
	mov	0x58, %r27
	.word 0x8780204f  ! 805: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf76000  ! 806: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xd8948400  ! 807: LDUHA_R	lduha	[%r18, %r0] 0x20, %r12
	.word 0xd0f76000  ! 808: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xdc878e80  ! 809: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r14
	.word 0xd28fe000  ! 810: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	.word 0xdcd70e40  ! 811: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r14
	.word 0xd497a000  ! 812: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	mov	0x7e0, %r20
	mov	0x70, %r24
	.word 0xdef7ce60  ! 815: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0xd4f7e000  ! 816: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xd0878e40  ! 817: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r8
	.word 0x87802020  ! 818: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b7a000  ! 819: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 820: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd296c9e0  ! 821: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r9
	.word 0xd897e000  ! 822: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	mov	0x3e0, %r23
	.word 0xd8dcc400  ! 824: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	.word 0xd8ad44a0  ! 825: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	.word 0x87802074  ! 826: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd48d6000  ! 827: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r10
	.word 0xd4bde000  ! 828: STDA_I	stda	%r10, [%r23 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x48, %r17
	.word 0xd49d2000  ! 831: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r10
	.word 0xd4cde000  ! 832: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r10
	.word 0xd49d6000  ! 833: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r10
	.word 0xd2f78e60  ! 834: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0xd2956000  ! 835: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r9
	mov	0x28, %r26
	.word 0xd8a70e40  ! 837: STWA_R	stwa	%r12, [%r28 + %r0] 0x72
	.word 0xdcd48400  ! 838: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	.word 0xd6974e60  ! 839: LDUHA_R	lduha	[%r29, %r0] 0x73, %r11
	.word 0x87802074  ! 840: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8b72000  ! 841: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd2b504a0  ! 842: STHA_R	stha	%r9, [%r20 + %r0] 0x25
	.word 0xdab7e000  ! 843: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	mov	0x40, %r18
	.word 0x87802020  ! 845: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaafe000  ! 846: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 847: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 848: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 849: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 850: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf6e000  ! 851: STXA_I	stxa	%r13, [%r27 + 0x0000] %asi
	.word 0xd69fce80  ! 852: LDDA_R	ldda	[%r31, %r0] 0x74, %r11
	.word 0xd2ac4400  ! 853: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	mov	0x20, %r16
	.word 0xdaf6e000  ! 855: STXA_I	stxa	%r13, [%r27 + 0x0000] %asi
	.word 0xda96e000  ! 856: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r13
	.word 0xd4b74e80  ! 857: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	.word 0x87802073  ! 858: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 859: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0c7a000  ! 860: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xdab7ce60  ! 861: STHA_R	stha	%r13, [%r31 + %r0] 0x73
	.word 0xd6876000  ! 862: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	mov	0x28, %r16
	.word 0xd294c400  ! 864: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	.word 0xd2afce60  ! 865: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	mov	0x68, %r24
	.word 0x87802025  ! 867: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca72000  ! 868: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 869: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcac2000  ! 870: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0xdcf4e000  ! 871: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	mov	0x50, %r17
	.word 0x8780204f  ! 873: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcc42000  ! 874: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r14
	.word 0xde9fce80  ! 875: LDDA_R	ldda	[%r31, %r0] 0x74, %r15
	.word 0xd0ddc4a0  ! 876: LDXA_R	ldxa	[%r23, %r0] 0x25, %r8
	mov	0x20, %r16
	.word 0x87802025  ! 878: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0ac4400  ! 879: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0xde9de000  ! 880: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r15
	.word 0xd0a48400  ! 881: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	mov	0x40, %r18
	.word 0x87802072  ! 883: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f7a000  ! 884: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6840400  ! 885: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	mov	0x48, %r19
	.word 0xd4a4c400  ! 887: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	mov	0x60, %r16
	.word 0xda8d44a0  ! 889: LDUBA_R	lduba	[%r21, %r0] 0x25, %r13
	mov	0x78, %r19
	.word 0xdccc4400  ! 891: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r14
	.word 0xd0a7e000  ! 892: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0c7e000  ! 893: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0f72000  ! 894: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 895: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69c0400  ! 896: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	.word 0x87802025  ! 897: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e8, %r22
	.word 0x87802074  ! 899: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcd4a000  ! 900: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	.word 0x87802020  ! 901: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r22
	.word 0x87802073  ! 903: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcace000  ! 904: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0xdcd4e000  ! 905: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	.word 0xd8f70e80  ! 906: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	mov	0x48, %r19
	.word 0xdca4e000  ! 908: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0xd8de49e0  ! 909: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r12
	mov	0x10, %r19
	.word 0xd8a4a000  ! 911: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd294c400  ! 912: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	mov	0x70, %r25
	.word 0xde846000  ! 914: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0xdea46000  ! 915: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xde9cc400  ! 916: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	.word 0xde9fce60  ! 917: LDDA_R	ldda	[%r31, %r0] 0x73, %r15
	mov	0x3e8, %r21
	.word 0xd2b4a000  ! 919: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0xd2bca000  ! 920: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 921: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cda000  ! 922: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r9
	.word 0xd2ade000  ! 923: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	mov	0x3e0, %r21
	mov	0x8, %r25
	.word 0xd2f52000  ! 926: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	.word 0xdab40400  ! 927: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xdea584a0  ! 928: STWA_R	stwa	%r15, [%r22 + %r0] 0x25
	.word 0xd2b5a000  ! 929: STHA_I	stha	%r9, [%r22 + 0x0000] %asi
	.word 0xd2bde000  ! 930: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	mov	0x50, %r24
	.word 0xd2c5e000  ! 932: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r9
	mov	0x58, %r27
	.word 0xd2ad2000  ! 934: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xd2a5a000  ! 935: STWA_I	stwa	%r9, [%r22 + 0x0000] %asi
	mov	0x7c8, %r23
	.word 0xd2a5e000  ! 937: STWA_I	stwa	%r9, [%r23 + 0x0000] %asi
	.word 0xd295e000  ! 938: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r9
	.word 0xd2b5e000  ! 939: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	.word 0xd4b609e0  ! 940: STHA_R	stha	%r10, [%r24 + %r0] 0x4f
	.word 0xdcbc8400  ! 941: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xd6dd2000  ! 942: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r11
	.word 0xd6b52000  ! 943: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	.word 0xd4d74e60  ! 944: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r10
	mov	0x3c8, %r21
	mov	0x7f8, %r21
	.word 0xdca52000  ! 947: STWA_I	stwa	%r14, [%r20 + 0x0000] %asi
	.word 0xd8bdc4a0  ! 948: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	.word 0xd0b48400  ! 949: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xdcbd2000  ! 950: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	.word 0xdc95e000  ! 951: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 952: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcac6000  ! 953: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdc94e000  ! 955: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	.word 0xd0dfce40  ! 956: LDXA_R	ldxa	[%r31, %r0] 0x72, %r8
	.word 0xd094a000  ! 957: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	.word 0xd0b42000  ! 958: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	mov	0x10, %r18
	mov	0x48, %r17
	.word 0xdebf4e40  ! 961: STDA_R	stda	%r15, [%r29 + %r0] 0x72
	.word 0xdc94a000  ! 962: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xdcf4a000  ! 963: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	mov	0x48, %r25
	.word 0x87802025  ! 965: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2c40400  ! 966: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r9
	mov	0x28, %r17
	.word 0x8780204f  ! 968: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r25
	.word 0xd2ae2000  ! 970: STBA_I	stba	%r9, [%r24 + 0x0000] %asi
	.word 0xd2dee000  ! 971: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r9
	.word 0x87802073  ! 972: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f7a000  ! 973: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xd2af6000  ! 974: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd2a7a000  ! 975: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xdeaf4e80  ! 977: STBA_R	stba	%r15, [%r29 + %r0] 0x74
	.word 0xd68f0e40  ! 978: LDUBA_R	lduba	[%r28, %r0] 0x72, %r11
	.word 0xdaafe000  ! 979: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xdad72000  ! 980: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0xdaf7e000  ! 981: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 982: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r27
	.word 0x8780204f  ! 984: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdac76000  ! 985: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0xdaa78e80  ! 986: STWA_R	stwa	%r13, [%r30 + %r0] 0x74
	mov	0x50, %r25
	mov	0x7f8, %r20
	mov	0x70, %r26
	.word 0xd4c7ce40  ! 990: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r10
	.word 0xdea78e40  ! 991: STWA_R	stwa	%r15, [%r30 + %r0] 0x72
	.word 0xd4cf2000  ! 992: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4afa000  ! 993: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 994: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9f8e80  ! 995: LDDA_R	ldda	[%r30, %r0] 0x74, %r15
	.word 0x87802020  ! 996: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded72000  ! 997: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xde8fe000  ! 998: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0x87802020  ! 999: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdec7a000  ! 1000: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xdeaec9e0  ! 1001: STBA_R	stba	%r15, [%r27 + %r0] 0x4f
	.word 0xdeaf6000  ! 1002: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xd6bd44a0  ! 1003: STDA_R	stda	%r11, [%r21 + %r0] 0x25
	.word 0xd6dcc400  ! 1004: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	mov	0x70, %r27
	.word 0xd4f4c400  ! 1006: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xdab76000  ! 1007: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 1008: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa46000  ! 1009: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	.word 0xda84a000  ! 1010: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	.word 0x87802025  ! 1011: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdab76000  ! 1012: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 1013: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d8, %r21
	.word 0xdef40400  ! 1015: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0x87802020  ! 1016: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccf4e40  ! 1017: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r14
	.word 0xd49649e0  ! 1018: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r10
	.word 0xdef6e000  ! 1019: STXA_I	stxa	%r15, [%r27 + 0x0000] %asi
	.word 0xdebee000  ! 1020: STDA_I	stda	%r15, [%r27 + 0x0000] %asi
	.word 0xdea62000  ! 1021: STWA_I	stwa	%r15, [%r24 + 0x0000] %asi
	.word 0xde86e000  ! 1022: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r15
	.word 0xdeaea000  ! 1023: STBA_I	stba	%r15, [%r26 + 0x0000] %asi
	mov	0x58, %r18
	.word 0xde862000  ! 1025: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r15
	.word 0xd4a649e0  ! 1026: STWA_R	stwa	%r10, [%r25 + %r0] 0x4f
	.word 0xd4ce2000  ! 1027: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1028: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4af6000  ! 1029: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd2974e60  ! 1030: LDUHA_R	lduha	[%r29, %r0] 0x73, %r9
	mov	0x58, %r18
	.word 0x87802074  ! 1032: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca78e40  ! 1033: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	mov	0x58, %r27
	.word 0xd6af8e80  ! 1035: STBA_R	stba	%r11, [%r30 + %r0] 0x74
	.word 0xdca40400  ! 1036: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	mov	0x3e0, %r23
	.word 0x87802020  ! 1038: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r27
	mov	0x40, %r16
	.word 0xdc85a000  ! 1041: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r14
	.word 0xdaf689e0  ! 1042: STXA_R	stxa	%r13, [%r26 + %r0] 0x4f
	wr_tick_cmpr_1_13:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x91, %g2
	or	%g4, 0xfc, %g4
	or	%g6, 0xe9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x70, %r19
	.word 0xd6bde000  ! 1045: STDA_I	stda	%r11, [%r23 + 0x0000] %asi
	.word 0xd6f56000  ! 1046: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	.word 0xd6b5e000  ! 1047: STHA_I	stha	%r11, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 1048: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r23
	.word 0xd6df0e80  ! 1050: LDXA_R	ldxa	[%r28, %r0] 0x74, %r11
	.word 0x87802073  ! 1051: WRASI_I	wr	%r0, 0x0073, %asi
	wr_tick_cmpr_1_14:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xff, %g2
	or	%g4, 0x81, %g4
	or	%g6, 0xf5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2bfa000  ! 1053: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd2bfe000  ! 1054: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xdc878e60  ! 1055: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r14
	mov	0x68, %r18
	.word 0xd48689e0  ! 1057: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r10
	.word 0xd0b48400  ! 1058: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xd2bf0e80  ! 1059: STDA_R	stda	%r9, [%r28 + %r0] 0x74
	.word 0xd684c400  ! 1060: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	.word 0xdab78e80  ! 1061: STHA_R	stha	%r13, [%r30 + %r0] 0x74
	.word 0xd4a78e80  ! 1062: STWA_R	stwa	%r10, [%r30 + %r0] 0x74
	.word 0xd08fce40  ! 1063: LDUBA_R	lduba	[%r31, %r0] 0x72, %r8
	.word 0xdc976000  ! 1064: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	mov	0x7e0, %r21
	mov	0x7c0, %r21
	.word 0xdc87e000  ! 1067: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xd4bd84a0  ! 1068: STDA_R	stda	%r10, [%r22 + %r0] 0x25
	.word 0x87802020  ! 1069: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8f0e40  ! 1070: LDUBA_R	lduba	[%r28, %r0] 0x72, %r15
	mov	0x70, %r27
	.word 0xdccc6000  ! 1072: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	mov	0x20, %r25
	.word 0xdac74e80  ! 1074: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r13
	.word 0xd88544a0  ! 1075: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r12
	.word 0xde8ca000  ! 1076: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0x87802020  ! 1077: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f78e80  ! 1078: STXA_R	stxa	%r9, [%r30 + %r0] 0x74
	.word 0xd0f6a000  ! 1079: STXA_I	stxa	%r8, [%r26 + 0x0000] %asi
	.word 0xde8d44a0  ! 1080: LDUBA_R	lduba	[%r21, %r0] 0x25, %r15
	mov	0x7d0, %r22
	.word 0xdeb6e000  ! 1082: STHA_I	stha	%r15, [%r27 + 0x0000] %asi
	.word 0xdedee000  ! 1083: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r15
	.word 0xdec6a000  ! 1084: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r15
	mov	0x3e0, %r22
	mov	0x7d8, %r21
	.word 0xde84c400  ! 1087: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0x87802073  ! 1088: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r26
	.word 0xd0f40400  ! 1090: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xdc856000  ! 1091: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r14
	wr_tick_cmpr_1_15:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xd0, %g2
	or	%g4, 0xaf, %g4
	or	%g6, 0xc2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xda9f8e40  ! 1093: LDDA_R	ldda	[%r30, %r0] 0x72, %r13
	mov	0x48, %r25
	.word 0xd8dda000  ! 1095: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r12
	.word 0xd89da000  ! 1096: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r12
	.word 0xd8b74e60  ! 1097: STHA_R	stha	%r12, [%r29 + %r0] 0x73
	.word 0xd0dcc400  ! 1098: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0xd08f8e60  ! 1099: LDUBA_R	lduba	[%r30, %r0] 0x73, %r8
	.word 0xdebd6000  ! 1100: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	.word 0xd8f74e60  ! 1101: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	.word 0xd4c5a000  ! 1102: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r10
	mov	0x7d0, %r23
	.word 0xd2a78e60  ! 1104: STWA_R	stwa	%r9, [%r30 + %r0] 0x73
	.word 0xd2be89e0  ! 1105: STDA_R	stda	%r9, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 1106: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r24
	.word 0xdac5e000  ! 1108: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r13
	.word 0x87802073  ! 1109: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 1110: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 1111: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdad56000  ! 1112: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r13
	.word 0xd6bf4e80  ! 1113: STDA_R	stda	%r11, [%r29 + %r0] 0x74
	.word 0xd8d4c400  ! 1114: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0xd48e49e0  ! 1115: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r10
	mov	0x10, %r19
	mov	0x7f8, %r20
	.word 0xdef5c4a0  ! 1118: STXA_R	stxa	%r15, [%r23 + %r0] 0x25
	.word 0xd0bda000  ! 1119: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	.word 0xdaa74e80  ! 1120: STWA_R	stwa	%r13, [%r29 + %r0] 0x74
	.word 0x87802020  ! 1121: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1122: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f7ce40  ! 1123: STXA_R	stxa	%r10, [%r31 + %r0] 0x72
	.word 0xdabec9e0  ! 1124: STDA_R	stda	%r13, [%r27 + %r0] 0x4f
	.word 0xda8c4400  ! 1125: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0xdeb584a0  ! 1126: STHA_R	stha	%r15, [%r22 + %r0] 0x25
	.word 0xd48fa000  ! 1127: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xd48fe000  ! 1128: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xda844400  ! 1129: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r13
	mov	0x30, %r25
	.word 0xd4cf6000  ! 1131: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	mov	0x7e8, %r23
	mov	0x3d0, %r22
	mov	0x3c0, %r23
	.word 0x87802073  ! 1135: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4cc6000  ! 1136: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	mov	0x58, %r16
	.word 0x87802072  ! 1138: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0bc8400  ! 1139: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0xd4a74e60  ! 1140: STWA_R	stwa	%r10, [%r29 + %r0] 0x73
	.word 0xdca76000  ! 1141: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 1142: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r27
	.word 0xd89f4e40  ! 1144: LDDA_R	ldda	[%r29, %r0] 0x72, %r12
	.word 0xd89fa000  ! 1145: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	.word 0xd8dfe000  ! 1146: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	mov	0x58, %r17
	.word 0xd8afa000  ! 1148: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xdcf649e0  ! 1149: STXA_R	stxa	%r14, [%r25 + %r0] 0x4f
	mov	0x38, %r19
	mov	0x7e8, %r23
	.word 0xd497a000  ! 1152: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0xd4bf6000  ! 1153: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd4c76000  ! 1154: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4b7a000  ! 1155: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd4af2000  ! 1156: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd0848400  ! 1157: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r8
	.word 0x87802073  ! 1158: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r17
	.word 0xd8c5c4a0  ! 1160: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r12
	.word 0xdcf70e80  ! 1161: STXA_R	stxa	%r14, [%r28 + %r0] 0x74
	mov	0x58, %r19
	.word 0x87802073  ! 1163: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8dfce40  ! 1164: LDXA_R	ldxa	[%r31, %r0] 0x72, %r12
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7c0, %r20
	.word 0x8780204f  ! 1167: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c8, %r22
	.word 0x87802025  ! 1169: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabe6000  ! 1170: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	.word 0xd28f8e60  ! 1171: LDUBA_R	lduba	[%r30, %r0] 0x73, %r9
	mov	0x7c8, %r21
	mov	0x68, %r16
	.word 0x87802020  ! 1174: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r19
	.word 0x87802020  ! 1176: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4dc8400  ! 1177: LDXA_R	ldxa	[%r18, %r0] 0x20, %r10
	.word 0xded7ce80  ! 1178: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r15
	.word 0xd0f74e40  ! 1179: STXA_R	stxa	%r8, [%r29 + %r0] 0x72
	.word 0xd08c6000  ! 1180: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0xd0bc0400  ! 1181: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0xdaf70e80  ! 1182: STXA_R	stxa	%r13, [%r28 + %r0] 0x74
	mov	0x0, %r16
	.word 0xdaa40400  ! 1184: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	mov	0x7d0, %r22
	.word 0xd6cce000  ! 1186: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r11
	mov	0x60, %r16
	.word 0xd6dca000  ! 1188: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r11
	.word 0xdcc649e0  ! 1189: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r14
	.word 0xd0c7ce60  ! 1190: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r8
	.word 0xdaf42000  ! 1191: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 1192: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r18
	.word 0xd0ccc400  ! 1194: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	.word 0xd0f7a000  ! 1195: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0ad84a0  ! 1196: STBA_R	stba	%r8, [%r22 + %r0] 0x25
	mov	0x70, %r16
	.word 0xd8acc400  ! 1198: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	mov	0x7d8, %r20
	.word 0xd2bdc4a0  ! 1200: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	.word 0x87802073  ! 1201: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8a7a000  ! 1202: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8df2000  ! 1203: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8972000  ! 1204: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	.word 0xd08e49e0  ! 1205: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r8
	.word 0xd8df6000  ! 1206: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0x87802074  ! 1207: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8b62000  ! 1208: STHA_I	stha	%r12, [%r24 + 0x0000] %asi
	mov	0x70, %r24
	.word 0xd8de6000  ! 1210: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r12
	.word 0xd8d6e000  ! 1211: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r12
	.word 0xd29c8400  ! 1212: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	.word 0xdede2000  ! 1213: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r15
	.word 0xdcafce40  ! 1214: STBA_R	stba	%r14, [%r31 + %r0] 0x72
	.word 0xd2a6a000  ! 1215: STWA_I	stwa	%r9, [%r26 + 0x0000] %asi
	.word 0xd0b40400  ! 1216: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 1217: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6d4c400  ! 1218: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	.word 0xd6af2000  ! 1219: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x7c0, %r22
	.word 0xd6bf2000  ! 1221: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd6a7e000  ! 1222: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6af2000  ! 1223: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd6b72000  ! 1224: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd6b76000  ! 1225: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd0b7ce40  ! 1226: STHA_R	stha	%r8, [%r31 + %r0] 0x72
	.word 0xda8f6000  ! 1227: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0x87802072  ! 1228: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1229: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r16
	.word 0xda862000  ! 1231: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r13
	mov	0x58, %r25
	.word 0xd0bf4e80  ! 1233: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8c544a0  ! 1235: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r12
	.word 0xd68ee000  ! 1236: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r11
	mov	0x7e0, %r20
	mov	0x0, %r27
	.word 0xdabf4e40  ! 1239: STDA_R	stda	%r13, [%r29 + %r0] 0x72
	mov	0x3c0, %r22
	.word 0x87802025  ! 1241: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2d7ce60  ! 1242: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r9
	.word 0xdecca000  ! 1243: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	.word 0xdea4e000  ! 1244: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xde84e000  ! 1245: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	.word 0xd0a44400  ! 1246: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	mov	0x3c0, %r20
	mov	0x40, %r18
	.word 0xdec78e80  ! 1249: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r15
	.word 0xdabca000  ! 1250: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdaaca000  ! 1251: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0xd4d504a0  ! 1252: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r10
	.word 0x87802020  ! 1253: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabf8e80  ! 1254: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	.word 0xd2af4e80  ! 1255: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	.word 0x87802020  ! 1256: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd085e000  ! 1257: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r8
	.word 0xd0d48400  ! 1258: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	mov	0x3d8, %r23
	mov	0x78, %r25
	.word 0xd4bc4400  ! 1261: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0xd0df4e60  ! 1262: LDXA_R	ldxa	[%r29, %r0] 0x73, %r8
	.word 0xd0cde000  ! 1263: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r8
	.word 0xdcb7ce40  ! 1264: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	wr_tick_cmpr_1_16:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xa9, %g2
	or	%g4, 0xc2, %g4
	or	%g6, 0xf8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0f609e0  ! 1266: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	.word 0xd4a52000  ! 1267: STWA_I	stwa	%r10, [%r20 + 0x0000] %asi
	.word 0xd4a52000  ! 1268: STWA_I	stwa	%r10, [%r20 + 0x0000] %asi
	.word 0xdcbc4400  ! 1269: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0xd0bd2000  ! 1270: STDA_I	stda	%r8, [%r20 + 0x0000] %asi
	.word 0xd89f8e40  ! 1271: LDDA_R	ldda	[%r30, %r0] 0x72, %r12
	.word 0xd8bde000  ! 1272: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 1273: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8504a0  ! 1274: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r15
	.word 0x87802074  ! 1275: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bdc4a0  ! 1276: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	wr_tick_cmpr_1_17:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf6, %g2
	or	%g4, 0x81, %g4
	or	%g6, 0xb5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0f46000  ! 1278: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xd09689e0  ! 1279: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r8
	.word 0xda87ce40  ! 1280: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r13
	.word 0xd2a74e80  ! 1281: STWA_R	stwa	%r9, [%r29 + %r0] 0x74
	wr_tick_cmpr_1_18:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa0, %g2
	or	%g4, 0xe6, %g4
	or	%g6, 0xb2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3e0, %r23
	.word 0xd08ca000  ! 1284: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xdecf0e40  ! 1285: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r15
	.word 0x87802073  ! 1286: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xded40400  ! 1287: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	.word 0xdeb76000  ! 1288: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0xdcac0400  ! 1290: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	mov	0x3f8, %r21
	.word 0xd8bf0e80  ! 1292: STDA_R	stda	%r12, [%r28 + %r0] 0x74
	.word 0xd28f2000  ! 1293: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	mov	0x68, %r26
	.word 0xd89c4400  ! 1295: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	.word 0xdec40400  ! 1296: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xdab72000  ! 1297: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	mov	0x58, %r17
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x0, %r16
	mov	0x28, %r25
	.word 0xd2f78e60  ! 1302: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0xdcaf2000  ! 1303: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	mov	0x70, %r18
	.word 0xdc9f6000  ! 1305: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xdcc76000  ! 1306: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xdea689e0  ! 1307: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	.word 0xdcc7e000  ! 1308: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0x87802074  ! 1309: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r26
	.word 0xdc9f6000  ! 1311: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0x87802073  ! 1312: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x60, %r26
	mov	0x68, %r25
	.word 0xdc9f2000  ! 1316: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xd0f504a0  ! 1317: STXA_R	stxa	%r8, [%r20 + %r0] 0x25
	.word 0xd2ae89e0  ! 1318: STBA_R	stba	%r9, [%r26 + %r0] 0x4f
	.word 0xd4b7a000  ! 1319: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd4d7a000  ! 1320: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	mov	0x7f8, %r22
	mov	0x30, %r18
	.word 0xd49fe000  ! 1323: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xdc96c9e0  ! 1324: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r14
	.word 0xdcf609e0  ! 1325: STXA_R	stxa	%r14, [%r24 + %r0] 0x4f
	.word 0xd2c74e80  ! 1326: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r9
	.word 0xdcbfe000  ! 1327: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	mov	0x3c0, %r21
	mov	0x7d0, %r20
	.word 0x87802025  ! 1330: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca4e000  ! 1331: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0xdc946000  ! 1332: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r14
	mov	0x30, %r24
	.word 0xd8cc8400  ! 1334: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0x87802072  ! 1335: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1336: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r18
	.word 0xdaace000  ! 1338: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0xd0b609e0  ! 1339: STHA_R	stha	%r8, [%r24 + %r0] 0x4f
	mov	0x20, %r19
	.word 0xd6a74e60  ! 1341: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	.word 0x87802025  ! 1342: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r16
	mov	0x0, %r24
	.word 0xd28c4400  ! 1345: LDUBA_R	lduba	[%r17, %r0] 0x20, %r9
	.word 0x87802020  ! 1346: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f6c9e0  ! 1347: STXA_R	stxa	%r12, [%r27 + %r0] 0x4f
	.word 0xd0d56000  ! 1348: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1349: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1350: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x48, %r16
	.word 0xd0872000  ! 1352: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1353: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r23
	.word 0x87802073  ! 1355: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2c78e80  ! 1356: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r9
	.word 0xdc9f4e40  ! 1357: LDDA_R	ldda	[%r29, %r0] 0x72, %r14
	mov	0x3d8, %r22
	.word 0x87802025  ! 1359: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8d72000  ! 1360: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	mov	0x7f0, %r22
	.word 0x87802072  ! 1362: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r18
	.word 0xdab4c400  ! 1364: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xd4ad04a0  ! 1365: STBA_R	stba	%r10, [%r20 + %r0] 0x25
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2f4e000  ! 1367: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	mov	0x0, %r17
	mov	0x3d0, %r22
	.word 0xdebf4e60  ! 1370: STDA_R	stda	%r15, [%r29 + %r0] 0x73
	.word 0xd4ace000  ! 1371: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0xd4a4e000  ! 1372: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xd8f584a0  ! 1373: STXA_R	stxa	%r12, [%r22 + %r0] 0x25
	.word 0xd8afce40  ! 1374: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	mov	0x40, %r18
	mov	0x40, %r25
	.word 0x87802025  ! 1377: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6bda000  ! 1378: STDA_I	stda	%r11, [%r22 + 0x0000] %asi
	.word 0xd6ade000  ! 1379: STBA_I	stba	%r11, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 1380: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 1381: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0f4c400  ! 1382: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0xd8cf8e60  ! 1383: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r12
	mov	0x7f8, %r20
	.word 0xd28ee000  ! 1385: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r9
	.word 0xd2bee000  ! 1386: STDA_I	stda	%r9, [%r27 + 0x0000] %asi
	.word 0x87802025  ! 1387: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 1388: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2a4a000  ! 1389: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0xd2a42000  ! 1390: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 1391: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r18
	.word 0xdabfce40  ! 1393: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	mov	0x10, %r16
	.word 0xd8a72000  ! 1395: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8a76000  ! 1396: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	mov	0x0, %r27
	mov	0x38, %r26
	.word 0xdab5c4a0  ! 1399: STHA_R	stha	%r13, [%r23 + %r0] 0x25
	.word 0xdccfe000  ! 1400: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xdc86c9e0  ! 1401: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r14
	mov	0x58, %r24
	mov	0x58, %r16
	.word 0xd2dfe000  ! 1404: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	mov	0x7d0, %r20
	.word 0xd2b7a000  ! 1406: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1407: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6940400  ! 1408: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	mov	0x3c0, %r22
	.word 0xde9da000  ! 1410: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r15
	.word 0x87802074  ! 1411: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6bc8400  ! 1412: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	mov	0x10, %r24
	mov	0x7d0, %r23
	.word 0xdcb56000  ! 1415: STHA_I	stha	%r14, [%r21 + 0x0000] %asi
	.word 0xdca5a000  ! 1416: STWA_I	stwa	%r14, [%r22 + 0x0000] %asi
	.word 0xdcafce60  ! 1417: STBA_R	stba	%r14, [%r31 + %r0] 0x73
	.word 0xd4bc8400  ! 1418: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	.word 0xd4f5e000  ! 1419: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	.word 0xdc96c9e0  ! 1420: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r14
	.word 0x87802025  ! 1421: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4f74e80  ! 1422: STXA_R	stxa	%r10, [%r29 + %r0] 0x74
	.word 0xdab689e0  ! 1423: STHA_R	stha	%r13, [%r26 + %r0] 0x4f
	.word 0x87802073  ! 1424: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6978e60  ! 1425: LDUHA_R	lduha	[%r30, %r0] 0x73, %r11
	.word 0xde9f6000  ! 1426: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0xdebf6000  ! 1427: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 1428: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde8de000  ! 1429: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r15
	.word 0xdea5e000  ! 1430: STWA_I	stwa	%r15, [%r23 + 0x0000] %asi
	.word 0xd2b544a0  ! 1431: STHA_R	stha	%r9, [%r21 + %r0] 0x25
	.word 0xd8d584a0  ! 1432: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r12
	.word 0xd2f5a000  ! 1433: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	mov	0x3f8, %r22
	mov	0x48, %r18
	.word 0xd295e000  ! 1436: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r9
	.word 0xd8d70e60  ! 1437: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r12
	.word 0xdcbda000  ! 1438: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	.word 0xdacf4e40  ! 1439: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r13
	mov	0x40, %r19
	.word 0xd0cf0e80  ! 1441: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r8
	.word 0xd48d2000  ! 1442: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0xd8df0e40  ! 1443: LDXA_R	ldxa	[%r28, %r0] 0x72, %r12
	.word 0x8780204f  ! 1444: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf7e000  ! 1445: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcb7e000  ! 1446: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xdca76000  ! 1447: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	mov	0x48, %r25
	.word 0xdccfe000  ! 1449: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xdcf7e000  ! 1450: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcc7a000  ! 1452: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xdc87e000  ! 1453: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcafa000  ! 1454: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xdab74e60  ! 1455: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	.word 0xdaf7a000  ! 1456: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	mov	0x50, %r27
	.word 0xdab7ce40  ! 1458: STHA_R	stha	%r13, [%r31 + %r0] 0x72
	.word 0xdeae89e0  ! 1459: STBA_R	stba	%r15, [%r26 + %r0] 0x4f
	.word 0x8780204f  ! 1460: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdab4e000  ! 1461: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xd0a44400  ! 1462: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xd08ce000  ! 1463: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xd094e000  ! 1464: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0xd0c42000  ! 1465: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r8
	.word 0xd0ac6000  ! 1466: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	mov	0x70, %r18
	.word 0xde978e60  ! 1468: LDUHA_R	lduha	[%r30, %r0] 0x73, %r15
	.word 0xd0c4e000  ! 1469: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	mov	0x40, %r18
	mov	0x38, %r17
	.word 0x87802020  ! 1472: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r18
	mov	0x68, %r26
	.word 0xdaa78e60  ! 1475: STWA_R	stwa	%r13, [%r30 + %r0] 0x73
	mov	0x40, %r17
	.word 0xd8ace000  ! 1477: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	mov	0x70, %r26
	.word 0xd8f46000  ! 1479: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8b46000  ! 1480: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0xdc974e40  ! 1481: LDUHA_R	lduha	[%r29, %r0] 0x72, %r14
	.word 0x87802073  ! 1482: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0f6a000  ! 1483: STXA_I	stxa	%r8, [%r26 + 0x0000] %asi
	.word 0x8780204f  ! 1484: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd68d44a0  ! 1485: LDUBA_R	lduba	[%r21, %r0] 0x25, %r11
	mov	0x58, %r18
	.word 0x87802072  ! 1487: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3e0, %r20
	.word 0x87802072  ! 1489: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2a4a000  ! 1490: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 1491: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1492: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r19
	.word 0xd8f74e60  ! 1494: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	.word 0xd8944400  ! 1495: LDUHA_R	lduha	[%r17, %r0] 0x20, %r12
	.word 0xd4bf6000  ! 1496: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd0b40400  ! 1497: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	mov	0x8, %r19
	.word 0xd2a40400  ! 1499: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xd8df6000  ! 1500: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	mov	0x8, %r26
	mov	0x58, %r25
	.word 0xd8d7a000  ! 1503: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0xde8e89e0  ! 1504: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r15
	.word 0xd2d7e000  ! 1505: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0x87802025  ! 1506: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d0, %r20
	mov	0x8, %r17
	.word 0xd2ad2000  ! 1509: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0xd0b44400  ! 1511: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xdab44400  ! 1512: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0xde9ec9e0  ! 1513: LDDA_R	ldda	[%r27, %r0] 0x4f, %r15
	mov	0x30, %r19
	.word 0xd4cd2000  ! 1515: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r10
	mov	0x28, %r26
	.word 0xd495e000  ! 1517: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r10
	.word 0xd4a52000  ! 1518: STWA_I	stwa	%r10, [%r20 + 0x0000] %asi
	mov	0x3d0, %r21
	mov	0x78, %r17
	.word 0xd48d2000  ! 1521: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0xd49d6000  ! 1522: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r10
	.word 0xdaf78e80  ! 1523: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	.word 0xd494c400  ! 1524: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	.word 0xdea52000  ! 1525: STWA_I	stwa	%r15, [%r20 + 0x0000] %asi
	.word 0x87802025  ! 1526: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8609e0  ! 1527: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r13
	.word 0xd0ce89e0  ! 1528: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r8
	.word 0xd6a4e000  ! 1529: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xd6b4e000  ! 1531: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xdcbf8e80  ! 1532: STDA_R	stda	%r14, [%r30 + %r0] 0x74
	mov	0x18, %r17
	.word 0x8780204f  ! 1534: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaaf2000  ! 1535: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdadf6000  ! 1536: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xdaa76000  ! 1537: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xdabfe000  ! 1538: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xd29584a0  ! 1539: LDUHA_R	lduha	[%r22, %r0] 0x25, %r9
	.word 0xd6bec9e0  ! 1540: STDA_R	stda	%r11, [%r27 + %r0] 0x4f
	mov	0x38, %r27
	mov	0x7f8, %r21
	.word 0xd6bfce40  ! 1543: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 1544: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd88cc400  ! 1545: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	.word 0xd2bf6000  ! 1546: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0xd2c76000  ! 1548: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2af6000  ! 1549: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	mov	0x68, %r17
	.word 0xd6bf4e60  ! 1551: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	.word 0xd0f609e0  ! 1552: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	.word 0xdc9f6000  ! 1553: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xdcf76000  ! 1554: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	wr_tick_cmpr_1_19:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x80, %g2
	or	%g4, 0x97, %g4
	or	%g6, 0xcd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_PRIV	! macro
	.word 0xdc9d84a0  ! 1557: LDDA_R	ldda	[%r22, %r0] 0x25, %r14
	mov	0x3c8, %r21
	mov	0x3f0, %r20
	.word 0xdedfe000  ! 1560: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	mov	0x30, %r18
	.word 0xd2f7ce60  ! 1562: STXA_R	stxa	%r9, [%r31 + %r0] 0x73
	.word 0xded78e80  ! 1563: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r15
	.word 0xd6940400  ! 1564: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	.word 0xdaa689e0  ! 1565: STWA_R	stwa	%r13, [%r26 + %r0] 0x4f
	.word 0xd6c7e000  ! 1566: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xd0a74e40  ! 1567: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	.word 0xd0de89e0  ! 1568: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r8
	mov	0x10, %r19
	.word 0xdc97e000  ! 1570: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xdcbfe000  ! 1571: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdccfe000  ! 1572: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xdc976000  ! 1573: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	mov	0x3c8, %r22
	.word 0xdcb7a000  ! 1575: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 1576: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbd2000  ! 1577: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	.word 0xd08f4e60  ! 1578: LDUBA_R	lduba	[%r29, %r0] 0x73, %r8
	.word 0xd0b48400  ! 1579: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xde848400  ! 1580: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	.word 0xded5a000  ! 1581: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r15
	.word 0xde9de000  ! 1582: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r15
	.word 0xdc9649e0  ! 1583: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r14
	.word 0xd2bc4400  ! 1584: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	mov	0x3f8, %r21
	.word 0xdeae09e0  ! 1586: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	.word 0xdaacc400  ! 1587: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0xdeb52000  ! 1588: STHA_I	stha	%r15, [%r20 + 0x0000] %asi
	.word 0xd0cf8e60  ! 1589: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r8
	.word 0x87802020  ! 1590: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_1_20:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xaf, %g2
	or	%g4, 0xd6, %g4
	or	%g6, 0x8e, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	wr_tick_cmpr_1_21:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x97, %g2
	or	%g4, 0xa7, %g4
	or	%g6, 0x8c, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2974e40  ! 1593: LDUHA_R	lduha	[%r29, %r0] 0x72, %r9
	.word 0x87802025  ! 1594: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc8f4e40  ! 1595: LDUBA_R	lduba	[%r29, %r0] 0x72, %r14
	.word 0xd28ca000  ! 1596: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	mov	0x48, %r25
	.word 0xd0af4e80  ! 1598: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	.word 0x87802020  ! 1599: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a4e000  ! 1600: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0cc2000  ! 1601: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	.word 0xd08c2000  ! 1602: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0xdea504a0  ! 1603: STWA_R	stwa	%r15, [%r20 + %r0] 0x25
	mov	0x30, %r25
	.word 0x87802073  ! 1605: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdea4c400  ! 1606: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	.word 0xd6f74e80  ! 1607: STXA_R	stxa	%r11, [%r29 + %r0] 0x74
	.word 0xdeb74e60  ! 1608: STHA_R	stha	%r15, [%r29 + %r0] 0x73
	.word 0xd6ac6000  ! 1609: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 1610: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r21
	wr_tick_cmpr_1_22:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd3, %g2
	or	%g4, 0xc8, %g4
	or	%g6, 0xd6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0c504a0  ! 1613: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r8
	wr_tick_cmpr_1_23:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd1, %g2
	or	%g4, 0xa9, %g4
	or	%g6, 0xe3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdea4e000  ! 1615: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xdadcc400  ! 1616: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xdcaca000  ! 1617: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	mov	0x48, %r27
	.word 0xdcf4a000  ! 1619: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xd0874e80  ! 1620: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r8
	.word 0xd4a7ce60  ! 1621: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	.word 0xd0d7ce60  ! 1622: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r8
	mov	0x60, %r17
	.word 0xd6c78e40  ! 1624: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	.word 0xd8d4e000  ! 1625: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	wr_tick_cmpr_1_24:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x91, %g2
	or	%g4, 0x93, %g4
	or	%g6, 0xd0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x60, %r25
	.word 0xd6c40400  ! 1628: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r11
	.word 0xd4f74e40  ! 1629: STXA_R	stxa	%r10, [%r29 + %r0] 0x72
	.word 0xd88d84a0  ! 1630: LDUBA_R	lduba	[%r22, %r0] 0x25, %r12
	mov	0x68, %r26
	mov	0x28, %r24
	.word 0xdc974e40  ! 1633: LDUHA_R	lduha	[%r29, %r0] 0x72, %r14
	mov	0x38, %r19
	.word 0xd8f649e0  ! 1635: STXA_R	stxa	%r12, [%r25 + %r0] 0x4f
	.word 0xd2b48400  ! 1636: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xde8ca000  ! 1637: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0xdeb46000  ! 1638: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	mov	0x78, %r16
	.word 0xdea4a000  ! 1640: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	wr_tick_cmpr_1_25:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf4, %g2
	or	%g4, 0xdd, %g4
	or	%g6, 0xed, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4c74e80  ! 1642: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r10
	.word 0xd0a584a0  ! 1643: STWA_R	stwa	%r8, [%r22 + %r0] 0x25
	.word 0x87802025  ! 1644: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdedea000  ! 1645: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r15
	mov	0x3e0, %r20
	mov	0x7e0, %r20
	mov	0x78, %r18
	.word 0xd2bc4400  ! 1649: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0x87802073  ! 1650: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6b74e80  ! 1651: STHA_R	stha	%r11, [%r29 + %r0] 0x74
	.word 0x8780204f  ! 1652: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcb7ce80  ! 1653: STHA_R	stha	%r14, [%r31 + %r0] 0x74
	.word 0xdec4e000  ! 1654: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	.word 0xde8c6000  ! 1655: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	mov	0x50, %r19
	.word 0xd0f584a0  ! 1657: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	wr_tick_cmpr_1_26:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb7, %g2
	or	%g4, 0xc7, %g4
	or	%g6, 0x81, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdad44400  ! 1659: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0xd4d544a0  ! 1660: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r10
	mov	0x3e8, %r22
	.word 0xd2cf8e60  ! 1662: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r9
	mov	0x3f0, %r22
	.word 0xd8c4e000  ! 1664: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	.word 0xd0cc0400  ! 1665: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xdcbc2000  ! 1666: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	mov	0x0, %r27
	.word 0xdaad44a0  ! 1668: STBA_R	stba	%r13, [%r21 + %r0] 0x25
	.word 0xd0ac8400  ! 1669: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xd8b4a000  ! 1670: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	mov	0x18, %r26
	mov	0x38, %r26
	.word 0x87802025  ! 1673: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8dd6000  ! 1674: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r12
	.word 0xdabc0400  ! 1675: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xd0a70e40  ! 1676: STWA_R	stwa	%r8, [%r28 + %r0] 0x72
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802072  ! 1678: WRASI_I	wr	%r0, 0x0072, %asi
	wr_tick_cmpr_1_27:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x8e, %g2
	or	%g4, 0xbd, %g4
	or	%g6, 0xd6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4ac8400  ! 1680: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0xdcc504a0  ! 1681: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r14
	.word 0xd8848400  ! 1682: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r12
	.word 0xd8a72000  ! 1683: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd88fe000  ! 1684: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd88f6000  ! 1685: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0x87802072  ! 1686: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8ac6000  ! 1687: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xd88ce000  ! 1689: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	.word 0xd4f78e80  ! 1690: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	.word 0x87802020  ! 1691: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1692: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 1693: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 1694: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebfce40  ! 1695: STDA_R	stda	%r15, [%r31 + %r0] 0x72
	.word 0xd2bf2000  ! 1696: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	mov	0x38, %r26
	mov	0x48, %r25
	.word 0xd2afe000  ! 1699: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 1700: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd89504a0  ! 1701: LDUHA_R	lduha	[%r20, %r0] 0x25, %r12
	mov	0x28, %r16
	.word 0xd4a7a000  ! 1703: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4a7e000  ! 1704: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4f72000  ! 1705: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4d7a000  ! 1706: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	.word 0x87802025  ! 1707: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1708: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b72000  ! 1709: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	mov	0x7e8, %r20
	mov	0x8, %r27
	.word 0xdc8c4400  ! 1712: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0xd4afe000  ! 1713: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0xdad70e80  ! 1715: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r13
	mov	0x0, %r25
	mov	0x8, %r16
	mov	0x48, %r24
	.word 0xdcbf0e60  ! 1719: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	.word 0xd0f44400  ! 1720: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd2bfe000  ! 1721: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 1722: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2dc8400  ! 1723: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	mov	0x3d0, %r21
	.word 0x87802073  ! 1725: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdab70e60  ! 1726: STHA_R	stha	%r13, [%r28 + %r0] 0x73
	.word 0xdaf66000  ! 1727: STXA_I	stxa	%r13, [%r25 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd8df0e60  ! 1729: LDXA_R	ldxa	[%r28, %r0] 0x73, %r12
	.word 0xde9f8e80  ! 1730: LDDA_R	ldda	[%r30, %r0] 0x74, %r15
	.word 0xdeb48400  ! 1731: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xde84c400  ! 1732: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	mov	0x8, %r18
	.word 0xd0b40400  ! 1734: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0x87802020  ! 1735: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcc76000  ! 1736: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xde9d44a0  ! 1737: LDDA_R	ldda	[%r21, %r0] 0x25, %r15
	.word 0xd28fe000  ! 1738: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	.word 0xd6df8e60  ! 1739: LDXA_R	ldxa	[%r30, %r0] 0x73, %r11
	.word 0x87802020  ! 1740: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad7e000  ! 1741: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xd2a78e40  ! 1742: STWA_R	stwa	%r9, [%r30 + %r0] 0x72
	.word 0xd49f4e40  ! 1743: LDDA_R	ldda	[%r29, %r0] 0x72, %r10
	.word 0x87802020  ! 1744: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0d4c400  ! 1745: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	.word 0xdaf5e000  ! 1746: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0xd2a48400  ! 1748: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0x87802074  ! 1749: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6ac0400  ! 1750: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0xdab72000  ! 1751: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdabfa000  ! 1752: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdac76000  ! 1753: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	mov	0x20, %r17
	mov	0x50, %r18
	.word 0xda8544a0  ! 1756: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r13
	mov	0x28, %r16
	mov	0x58, %r26
	.word 0xd0848400  ! 1759: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r8
	.word 0xde940400  ! 1760: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0xde9f6000  ! 1761: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	mov	0x78, %r18
	.word 0x87802072  ! 1763: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde8689e0  ! 1764: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r15
	.word 0xd4af8e60  ! 1765: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	.word 0xd6afa000  ! 1766: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6af6000  ! 1767: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x0, %r24
	.word 0xd08584a0  ! 1769: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r8
	.word 0x8780204f  ! 1770: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2af2000  ! 1771: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1772: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r18
	mov	0x3e8, %r22
	.word 0xd897ce80  ! 1775: LDUHA_R	lduha	[%r31, %r0] 0x74, %r12
	mov	0x20, %r16
	.word 0xdaa4a000  ! 1777: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xd2f7ce80  ! 1778: STXA_R	stxa	%r9, [%r31 + %r0] 0x74
	.word 0x87802025  ! 1779: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r19
	mov	0x3f0, %r21
	mov	0x60, %r27
	.word 0xdcaf6000  ! 1783: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdcc72000  ! 1784: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	mov	0x38, %r25
	.word 0xdcf7e000  ! 1786: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x70, %r26
	.word 0x8780204f  ! 1788: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc95a000  ! 1789: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r14
	.word 0xdc9544a0  ! 1790: LDUHA_R	lduha	[%r21, %r0] 0x25, %r14
	.word 0xd2b52000  ! 1791: STHA_I	stha	%r9, [%r20 + 0x0000] %asi
	.word 0xd8c584a0  ! 1792: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r12
	.word 0xdeb7ce40  ! 1793: STHA_R	stha	%r15, [%r31 + %r0] 0x72
	.word 0xd0b78e40  ! 1794: STHA_R	stha	%r8, [%r30 + %r0] 0x72
	.word 0x87802073  ! 1795: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r17
	.word 0xded42000  ! 1797: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	.word 0xdea42000  ! 1798: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 1799: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r18
	.word 0xd8bd84a0  ! 1801: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	.word 0xdaf48400  ! 1802: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xd09dc4a0  ! 1803: LDDA_R	ldda	[%r23, %r0] 0x25, %r8
	.word 0xdacf2000  ! 1804: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xdaaf2000  ! 1805: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdaf7a000  ! 1806: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xdab7e000  ! 1808: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 1809: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda872000  ! 1810: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	mov	0x3d8, %r22
	.word 0xdaf7e000  ! 1812: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xdca7ce80  ! 1813: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	mov	0x10, %r16
	.word 0x87802073  ! 1815: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2840400  ! 1816: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r9
	.word 0xd6d649e0  ! 1817: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r11
	.word 0x87802072  ! 1818: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r25
	.word 0x87802073  ! 1820: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f7e000  ! 1821: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4bf6000  ! 1822: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802073  ! 1824: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb689e0  ! 1825: STHA_R	stha	%r14, [%r26 + %r0] 0x4f
	.word 0xd0f7ce60  ! 1826: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	mov	0x0, %r26
	.word 0xd4cf0e40  ! 1828: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r10
	.word 0xd0f62000  ! 1829: STXA_I	stxa	%r8, [%r24 + 0x0000] %asi
	.word 0xd08ea000  ! 1830: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1831: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cfce80  ! 1832: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r10
	.word 0xdca6c9e0  ! 1833: STWA_R	stwa	%r14, [%r27 + %r0] 0x4f
	mov	0x3d8, %r22
	.word 0x87802025  ! 1835: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r25
	.word 0x87802025  ! 1837: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc8d6000  ! 1838: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r14
	.word 0xdc95a000  ! 1839: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r14
	.word 0xdab7ce80  ! 1840: STHA_R	stha	%r13, [%r31 + %r0] 0x74
	.word 0xd0b5a000  ! 1841: STHA_I	stha	%r8, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 1842: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8adc4a0  ! 1843: STBA_R	stba	%r12, [%r23 + %r0] 0x25
	.word 0xdc9f4e80  ! 1844: LDDA_R	ldda	[%r29, %r0] 0x74, %r14
	mov	0x68, %r19
	.word 0xda842000  ! 1846: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r13
	.word 0x87802025  ! 1847: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc8fce60  ! 1848: LDUBA_R	lduba	[%r31, %r0] 0x73, %r14
	.word 0xd0df2000  ! 1849: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1850: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ace000  ! 1851: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	mov	0x38, %r19
	mov	0x0, %r25
	mov	0x40, %r25
	.word 0x87802074  ! 1855: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r26
	.word 0xd6dfce80  ! 1857: LDXA_R	ldxa	[%r31, %r0] 0x74, %r11
	.word 0xd8bd84a0  ! 1858: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	.word 0xd4870e80  ! 1859: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r10
	.word 0x87802074  ! 1860: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0c46000  ! 1861: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1862: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1863: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r17
	.word 0xd0cf6000  ! 1865: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1866: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r27
	.word 0xd29d44a0  ! 1868: LDDA_R	ldda	[%r21, %r0] 0x25, %r9
	mov	0x0, %r16
	.word 0xd0b76000  ! 1870: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd0dfa000  ! 1871: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	mov	0x28, %r27
	.word 0xd0cf6000  ! 1873: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd0d76000  ! 1874: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	mov	0x70, %r26
	.word 0xd0dfe000  ! 1876: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1877: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r19
	mov	0x48, %r18
	.word 0xdaac8400  ! 1880: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0xd6ac8400  ! 1881: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	mov	0x3e8, %r22
	mov	0x70, %r16
	.word 0xdef4e000  ! 1884: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 1885: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1886: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd09544a0  ! 1887: LDUHA_R	lduha	[%r21, %r0] 0x25, %r8
	mov	0x38, %r17
	.word 0xd4d42000  ! 1889: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	mov	0x40, %r25
	.word 0xd8a504a0  ! 1891: STWA_R	stwa	%r12, [%r20 + %r0] 0x25
	.word 0xd4f4a000  ! 1892: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0xd0a44400  ! 1893: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xdca46000  ! 1894: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 1895: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca7a000  ! 1896: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	mov	0x8, %r25
	.word 0xd8a7ce40  ! 1898: STWA_R	stwa	%r12, [%r31 + %r0] 0x72
	.word 0xd8f7a000  ! 1899: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd0be09e0  ! 1900: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	mov	0x0, %r26
	.word 0xda972000  ! 1902: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0xdedc4400  ! 1903: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	ta	T_CHANGE_PRIV	! macro
	.word 0xd6cf6000  ! 1905: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	mov	0x3f0, %r21
	mov	0x7c8, %r21
	mov	0x38, %r24
	.word 0x87802074  ! 1909: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6952000  ! 1910: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r11
	mov	0x48, %r25
	.word 0xd0c7ce40  ! 1912: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r8
	.word 0xd0bd2000  ! 1913: STDA_I	stda	%r8, [%r20 + 0x0000] %asi
	.word 0xd6ac4400  ! 1914: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xdcdde000  ! 1915: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	.word 0x87802072  ! 1916: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcdc4400  ! 1917: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	.word 0xdef689e0  ! 1918: STXA_R	stxa	%r15, [%r26 + %r0] 0x4f
	.word 0xdabc0400  ! 1919: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0x87802074  ! 1920: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r26
	.word 0xd2bfce80  ! 1922: STDA_R	stda	%r9, [%r31 + %r0] 0x74
	.word 0xd6cda000  ! 1923: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r11
	.word 0xd0cf4e80  ! 1924: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r8
	mov	0x3d8, %r21
	mov	0x3e8, %r22
	.word 0x87802020  ! 1927: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf7ce60  ! 1928: STXA_R	stxa	%r14, [%r31 + %r0] 0x73
	.word 0xd0dc8400  ! 1929: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0x87802025  ! 1930: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d0, %r23
	.word 0x87802020  ! 1932: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a74e60  ! 1933: STWA_R	stwa	%r12, [%r29 + %r0] 0x73
	.word 0xdabe89e0  ! 1934: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	.word 0xd4f48400  ! 1935: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xd4b40400  ! 1936: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0xdede6000  ! 1937: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r15
	.word 0xded66000  ! 1938: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r15
	.word 0xdeb62000  ! 1939: STHA_I	stha	%r15, [%r24 + 0x0000] %asi
	.word 0xdeaea000  ! 1940: STBA_I	stba	%r15, [%r26 + 0x0000] %asi
	.word 0xde862000  ! 1941: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r15
	.word 0xdaf48400  ! 1942: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xd4f689e0  ! 1943: STXA_R	stxa	%r10, [%r26 + %r0] 0x4f
	mov	0x58, %r25
	.word 0xd8ad44a0  ! 1945: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	.word 0xd68f0e40  ! 1946: LDUBA_R	lduba	[%r28, %r0] 0x72, %r11
	.word 0x87802020  ! 1947: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1948: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabca000  ! 1949: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 1950: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdadca000  ! 1951: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0xdaf4a000  ! 1952: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0xd09689e0  ! 1953: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r8
	.word 0xdc9ca000  ! 1954: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r14
	.word 0xd28f4e60  ! 1955: LDUBA_R	lduba	[%r29, %r0] 0x73, %r9
	.word 0xd2b74e40  ! 1956: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	.word 0xda8c2000  ! 1957: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r13
	.word 0xdab4e000  ! 1958: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	mov	0x3f8, %r22
	.word 0x87802020  ! 1960: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1961: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4c584a0  ! 1962: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r10
	mov	0x7e8, %r21
	mov	0x38, %r19
	mov	0x78, %r27
	.word 0xd0df6000  ! 1966: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	mov	0x18, %r24
	mov	0x78, %r18
	.word 0x87802072  ! 1969: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r18
	mov	0x3f8, %r23
	mov	0x8, %r24
	.word 0xd0cc6000  ! 1973: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	mov	0x30, %r16
	.word 0xd09c2000  ! 1975: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r8
	mov	0x8, %r17
	mov	0x38, %r27
	.word 0xdec74e80  ! 1978: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r15
	mov	0x7d8, %r20
	.word 0xd89c2000  ! 1980: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	.word 0xd8b44400  ! 1981: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0xd68f4e40  ! 1982: LDUBA_R	lduba	[%r29, %r0] 0x72, %r11
	.word 0x87802073  ! 1983: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd48cc400  ! 1984: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	.word 0xdcd52000  ! 1985: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r14
	.word 0xd8df4e80  ! 1986: LDXA_R	ldxa	[%r29, %r0] 0x74, %r12
	.word 0xdab78e40  ! 1987: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	mov	0x58, %r19
	.word 0xd8a5a000  ! 1989: STWA_I	stwa	%r12, [%r22 + 0x0000] %asi
	.word 0xd89d2000  ! 1990: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r12
	mov	0x7d0, %r23
	.word 0xdecf4e40  ! 1992: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r15
	mov	0x60, %r25
	mov	0x60, %r27
	.word 0x87802025  ! 1995: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 1996: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bfe000  ! 1997: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	mov	0x7f0, %r22
	.word 0xd88504a0  ! 1999: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r12
	.word 0xd2bc8400  ! 2000: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	.word 0xd8f40400  ! 2001: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xdcf72000  ! 2002: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	mov	0x40, %r16
	.word 0x87802020  ! 2004: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2005: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd095c4a0  ! 2006: LDUHA_R	lduha	[%r23, %r0] 0x25, %r8
	mov	0x3d0, %r22
	.word 0xd0bec9e0  ! 2008: STDA_R	stda	%r8, [%r27 + %r0] 0x4f
	.word 0xdaa48400  ! 2009: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	mov	0x68, %r16
	.word 0xd8f76000  ! 2011: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8d76000  ! 2012: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xd8bf2000  ! 2013: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	mov	0x10, %r18
	.word 0xd8b4c400  ! 2015: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 2016: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2017: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r17
	.word 0x87802074  ! 2019: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f56000  ! 2020: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	.word 0xd0cec9e0  ! 2021: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r8
	.word 0xdc9d6000  ! 2022: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r14
	.word 0xdcada000  ! 2023: STBA_I	stba	%r14, [%r22 + 0x0000] %asi
	.word 0xde8e09e0  ! 2024: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r15
	.word 0xdec5a000  ! 2025: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802073  ! 2027: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeafe000  ! 2028: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xdedf2000  ! 2029: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	mov	0x78, %r16
	.word 0xd4b689e0  ! 2031: STHA_R	stha	%r10, [%r26 + %r0] 0x4f
	.word 0xdef78e60  ! 2032: STXA_R	stxa	%r15, [%r30 + %r0] 0x73
	.word 0xd6f74e40  ! 2033: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	.word 0xdad72000  ! 2034: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 2035: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd08c8400  ! 2036: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0xdecfa000  ! 2037: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xdec7a000  ! 2038: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xd2cf8e80  ! 2039: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r9
	.word 0xd09fe000  ! 2040: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	mov	0x48, %r18
	mov	0x28, %r27
	.word 0xdaae89e0  ! 2043: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	mov	0x18, %r18
	.word 0x87802072  ! 2045: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8bf4e60  ! 2046: STDA_R	stda	%r12, [%r29 + %r0] 0x73
	.word 0xd0a66000  ! 2047: STWA_I	stwa	%r8, [%r25 + 0x0000] %asi
	mov	0x50, %r19
	mov	0x7e8, %r23
	.word 0xd6dc4400  ! 2050: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0x87802020  ! 2051: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r19
	.word 0xdeb70e60  ! 2053: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	.word 0x87802020  ! 2054: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d5a000  ! 2055: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r12
	mov	0x0, %r25
	mov	0x20, %r17
	.word 0xd4a74e40  ! 2058: STWA_R	stwa	%r10, [%r29 + %r0] 0x72
	.word 0xdaf56000  ! 2059: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0x87802020  ! 2061: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaaea000  ! 2062: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	.word 0x8780204f  ! 2063: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabfa000  ! 2064: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 2065: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r27
	wr_tick_cmpr_1_28:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x8c, %g2
	or	%g4, 0x81, %g4
	or	%g6, 0xd9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdaa48400  ! 2068: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0x87802072  ! 2069: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde94c400  ! 2070: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	.word 0xd687ce40  ! 2071: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r11
	.word 0x87802072  ! 2072: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r18
	.word 0xdcbe89e0  ! 2074: STDA_R	stda	%r14, [%r26 + %r0] 0x4f
	.word 0xd696e000  ! 2075: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	.word 0xd4cf4e40  ! 2076: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r10
	.word 0x8780204f  ! 2077: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdef70e40  ! 2078: STXA_R	stxa	%r15, [%r28 + %r0] 0x72
	.word 0xd496e000  ! 2079: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r10
	.word 0xd4de2000  ! 2080: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r10
	.word 0xd4f6a000  ! 2081: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	mov	0x40, %r18
	.word 0x87802074  ! 2083: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b4a000  ! 2084: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	wr_tick_cmpr_1_29:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x82, %g2
	or	%g4, 0xd4, %g4
	or	%g6, 0xd6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdeaf4e80  ! 2086: STBA_R	stba	%r15, [%r29 + %r0] 0x74
	mov	0x70, %r17
	.word 0xd68c0400  ! 2088: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	.word 0x8780204f  ! 2089: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda874e60  ! 2090: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r13
	.word 0xd2be89e0  ! 2091: STDA_R	stda	%r9, [%r26 + %r0] 0x4f
	.word 0x8780204f  ! 2092: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r24
	.word 0x8780204f  ! 2094: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e0, %r23
	.word 0xd0cd44a0  ! 2096: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r8
	.word 0xd2b78e80  ! 2097: STHA_R	stha	%r9, [%r30 + %r0] 0x74
	mov	0x28, %r25
	.word 0xdca46000  ! 2099: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	mov	0x50, %r27
	mov	0x28, %r27
	.word 0xdcbc6000  ! 2102: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 2103: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r17
	.word 0xdcdc2000  ! 2105: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r14
	.word 0xd0974e60  ! 2106: LDUHA_R	lduha	[%r29, %r0] 0x73, %r8
	.word 0xd88c2000  ! 2107: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	.word 0xd8acc400  ! 2108: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0xd2d4e000  ! 2109: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0xd4ad44a0  ! 2110: STBA_R	stba	%r10, [%r21 + %r0] 0x25
	.word 0xd8de09e0  ! 2111: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r12
	.word 0xd0ae09e0  ! 2112: STBA_R	stba	%r8, [%r24 + %r0] 0x4f
	.word 0xd8b4e000  ! 2113: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0xdadc4400  ! 2114: LDXA_R	ldxa	[%r17, %r0] 0x20, %r13
	.word 0xd0c42000  ! 2115: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r8
	.word 0xd0ac8400  ! 2116: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xdef4e000  ! 2117: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xdeaca000  ! 2118: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xde946000  ! 2119: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r15
	.word 0xdef4a000  ! 2120: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0xdeaca000  ! 2121: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	mov	0x10, %r17
	.word 0xdeb42000  ! 2123: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0xdea544a0  ! 2124: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	mov	0x68, %r19
	.word 0x8780204f  ! 2126: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ddc4a0  ! 2127: LDXA_R	ldxa	[%r23, %r0] 0x25, %r12
	.word 0xd4f5c4a0  ! 2128: STXA_R	stxa	%r10, [%r23 + %r0] 0x25
	mov	0x7e0, %r22
	.word 0xdecfe000  ! 2130: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	mov	0x7e8, %r23
	.word 0xdef76000  ! 2132: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdec7a000  ! 2133: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xded72000  ! 2134: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xd08f0e60  ! 2135: LDUBA_R	lduba	[%r28, %r0] 0x73, %r8
	mov	0x7d0, %r22
	.word 0xdaaf4e60  ! 2137: STBA_R	stba	%r13, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 2138: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 2139: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a4a000  ! 2140: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	mov	0x68, %r27
	.word 0xd8bdc4a0  ! 2142: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	mov	0x78, %r25
	.word 0x87802073  ! 2144: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2145: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bf8e60  ! 2146: STDA_R	stda	%r11, [%r30 + %r0] 0x73
	.word 0xdcd584a0  ! 2147: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r14
	.word 0xd4f504a0  ! 2148: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0x87802074  ! 2149: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2150: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2151: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2152: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd895e000  ! 2153: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r12
	.word 0xd89d2000  ! 2154: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2155: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad44400  ! 2156: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0xd8a584a0  ! 2157: STWA_R	stwa	%r12, [%r22 + %r0] 0x25
	.word 0xd69f8e40  ! 2158: LDDA_R	ldda	[%r30, %r0] 0x72, %r11
	.word 0xd4d5e000  ! 2159: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r10
	.word 0x87802074  ! 2160: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c0, %r22
	.word 0xdaf48400  ! 2162: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xdecfa000  ! 2163: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xdc9584a0  ! 2164: LDUHA_R	lduha	[%r22, %r0] 0x25, %r14
	.word 0xdca7a000  ! 2165: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcc76000  ! 2166: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xdc872000  ! 2167: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcc7a000  ! 2168: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0x87802025  ! 2169: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d8, %r23
	.word 0xdcf40400  ! 2171: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	wr_tick_cmpr_1_30:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe0, %g2
	or	%g4, 0xfe, %g4
	or	%g6, 0xfc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdc8fa000  ! 2173: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdcc7e000  ! 2174: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0xdc8f2000  ! 2175: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0xd697ce80  ! 2176: LDUHA_R	lduha	[%r31, %r0] 0x74, %r11
	.word 0x87802020  ! 2177: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2178: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 2179: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd09c2000  ! 2180: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r8
	.word 0xd4ae49e0  ! 2181: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0xd6942000  ! 2182: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r11
	.word 0xd694a000  ! 2183: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r11
	mov	0x7d8, %r20
	.word 0xd6d42000  ! 2185: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r11
	mov	0x68, %r16
	.word 0xd6b42000  ! 2187: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 2188: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cf6000  ! 2189: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd4d689e0  ! 2190: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r10
	.word 0xd6b76000  ! 2191: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd8dd84a0  ! 2192: LDXA_R	ldxa	[%r22, %r0] 0x25, %r12
	.word 0xd8b74e60  ! 2193: STHA_R	stha	%r12, [%r29 + %r0] 0x73
	.word 0xd4970e60  ! 2194: LDUHA_R	lduha	[%r28, %r0] 0x73, %r10
	.word 0xda97a000  ! 2195: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xdaa76000  ! 2196: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 2197: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 2198: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4af8e40  ! 2199: STBA_R	stba	%r10, [%r30 + %r0] 0x72
	.word 0xd4df0e40  ! 2200: LDXA_R	ldxa	[%r28, %r0] 0x72, %r10
	.word 0xdec4c400  ! 2201: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	.word 0xd6a66000  ! 2202: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	.word 0xd6cee000  ! 2203: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r11
	.word 0xda9609e0  ! 2204: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r13
	.word 0xdaf78e60  ! 2205: STXA_R	stxa	%r13, [%r30 + %r0] 0x73
	.word 0xd6f44400  ! 2206: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0xd0b66000  ! 2207: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	.word 0xd89fce40  ! 2208: LDDA_R	ldda	[%r31, %r0] 0x72, %r12
	.word 0x87802020  ! 2209: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f74e80  ! 2210: STXA_R	stxa	%r10, [%r29 + %r0] 0x74
	.word 0xdcf6a000  ! 2211: STXA_I	stxa	%r14, [%r26 + 0x0000] %asi
	mov	0x48, %r17
	.word 0x87802025  ! 2213: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd894c400  ! 2214: LDUHA_R	lduha	[%r19, %r0] 0x20, %r12
	mov	0x3c8, %r21
	.word 0xd2f74e60  ! 2216: STXA_R	stxa	%r9, [%r29 + %r0] 0x73
	.word 0xd8cfe000  ! 2217: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xde9dc4a0  ! 2218: LDDA_R	ldda	[%r23, %r0] 0x25, %r15
	.word 0xd6f74e40  ! 2219: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	.word 0x8780204f  ! 2220: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r24
	.word 0xd2cf6000  ! 2222: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2223: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 2224: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r16
	.word 0xd6bcc400  ! 2226: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	mov	0x3e0, %r20
	.word 0xd6bf6000  ! 2228: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xdabf4e60  ! 2229: STDA_R	stda	%r13, [%r29 + %r0] 0x73
	mov	0x20, %r16
	.word 0x87802072  ! 2231: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda9ce000  ! 2232: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r13
	.word 0xd4ac0400  ! 2233: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	wr_tick_cmpr_1_31:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf4, %g2
	or	%g4, 0xf3, %g4
	or	%g6, 0xd8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 2235: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8bd04a0  ! 2236: STDA_R	stda	%r12, [%r20 + %r0] 0x25
	.word 0xd0cf8e40  ! 2237: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r8
	.word 0xd6c74e80  ! 2238: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r11
	.word 0xdac72000  ! 2239: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0xdeb5c4a0  ! 2240: STHA_R	stha	%r15, [%r23 + %r0] 0x25
	mov	0x7f8, %r22
	.word 0x87802072  ! 2242: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r26
	.word 0xd2cf6000  ! 2244: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	mov	0x3e0, %r23
	.word 0x87802073  ! 2246: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd28ca000  ! 2247: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdc8cc400  ! 2249: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	.word 0xdc8c2000  ! 2250: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r14
	.word 0xdaf7ce80  ! 2251: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	mov	0x3d8, %r21
	.word 0x87802074  ! 2253: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd097ce60  ! 2254: LDUHA_R	lduha	[%r31, %r0] 0x73, %r8
	mov	0x70, %r17
	.word 0xd4a544a0  ! 2256: STWA_R	stwa	%r10, [%r21 + %r0] 0x25
	.word 0xdea48400  ! 2257: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0x87802074  ! 2258: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r25
	mov	0x7e8, %r23
	.word 0x87802020  ! 2261: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdc6000  ! 2262: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	mov	0x7e0, %r22
	mov	0x60, %r24
	.word 0xdef48400  ! 2265: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xd49f0e60  ! 2266: LDDA_R	ldda	[%r28, %r0] 0x73, %r10
	.word 0xd0c40400  ! 2267: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	.word 0x8780204f  ! 2268: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a40400  ! 2269: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0xd69f8e60  ! 2270: LDDA_R	ldda	[%r30, %r0] 0x73, %r11
	mov	0x0, %r18
	.word 0x8780204f  ! 2272: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6dc4400  ! 2273: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xd2a48400  ! 2274: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0xd2af8e40  ! 2275: STBA_R	stba	%r9, [%r30 + %r0] 0x72
	mov	0x0, %r27
	mov	0x18, %r17
	mov	0x18, %r19
	.word 0xd0df0e40  ! 2279: LDXA_R	ldxa	[%r28, %r0] 0x72, %r8
	.word 0xde878e80  ! 2280: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r15
	.word 0x87802025  ! 2281: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8b46000  ! 2282: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	mov	0x8, %r16
	mov	0x10, %r25
	.word 0xd8b46000  ! 2285: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0xd4bfce60  ! 2286: STDA_R	stda	%r10, [%r31 + %r0] 0x73
	.word 0xd88f8e60  ! 2287: LDUBA_R	lduba	[%r30, %r0] 0x73, %r12
	mov	0x50, %r19
	.word 0xd6af0e40  ! 2289: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	mov	0x7d8, %r20
	.word 0xda9f0e60  ! 2291: LDDA_R	ldda	[%r28, %r0] 0x73, %r13
	.word 0xd6d48400  ! 2292: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0xd68e49e0  ! 2293: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r11
	mov	0x7d0, %r23
	.word 0xd69f4e60  ! 2295: LDDA_R	ldda	[%r29, %r0] 0x73, %r11
	.word 0xd4974e80  ! 2296: LDUHA_R	lduha	[%r29, %r0] 0x74, %r10
	.word 0xd88fce60  ! 2297: LDUBA_R	lduba	[%r31, %r0] 0x73, %r12
	.word 0xda84e000  ! 2298: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r13
	.word 0xdaac2000  ! 2299: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0xdaf46000  ! 2300: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0xdabca000  ! 2301: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdab4e000  ! 2302: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 2303: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e8, %r23
	.word 0xdacee000  ! 2305: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r13
	.word 0x87802072  ! 2306: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r24
	.word 0x87802020  ! 2308: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabca000  ! 2309: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 2310: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r27
	.word 0x87802020  ! 2312: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad584a0  ! 2313: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r13
	.word 0xd68da000  ! 2314: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r11
	.word 0xd6c5e000  ! 2315: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r11
	.word 0xd68d2000  ! 2316: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r11
	.word 0xd6b52000  ! 2317: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	.word 0xdcde09e0  ! 2318: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r14
	.word 0xd6b6c9e0  ! 2319: STHA_R	stha	%r11, [%r27 + %r0] 0x4f
	.word 0xdea544a0  ! 2320: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	mov	0x60, %r27
	mov	0x58, %r27
	mov	0x60, %r18
	.word 0xd6856000  ! 2324: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r11
	.word 0xd6ade000  ! 2325: STBA_I	stba	%r11, [%r23 + 0x0000] %asi
	.word 0xd6f56000  ! 2326: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	.word 0xd6b52000  ! 2327: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	mov	0x7f8, %r23
	.word 0x87802020  ! 2329: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2330: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r27
	.word 0xd6ad84a0  ! 2332: STBA_R	stba	%r11, [%r22 + %r0] 0x25
	mov	0x3d0, %r23
	.word 0xd4ac0400  ! 2334: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xdeb74e40  ! 2335: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	.word 0xd0bc8400  ! 2336: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	mov	0x30, %r26
	mov	0x7d8, %r21
	mov	0x3c0, %r20
	.word 0xd0ac8400  ! 2340: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xdabd6000  ! 2341: STDA_I	stda	%r13, [%r21 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0xd8f609e0  ! 2343: STXA_R	stxa	%r12, [%r24 + %r0] 0x4f
	mov	0x18, %r19
	mov	0x0, %r27
	.word 0xdacf8e60  ! 2346: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r13
	.word 0xd8c609e0  ! 2347: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r12
	.word 0xd8f544a0  ! 2348: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	.word 0xdec52000  ! 2349: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r15
	.word 0x87802020  ! 2350: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2351: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdecfe000  ! 2352: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0x87802025  ! 2353: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebfa000  ! 2354: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 2355: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb72000  ! 2356: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2357: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r26
	.word 0x87802025  ! 2359: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2360: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb7e000  ! 2361: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xd68f8e40  ! 2362: LDUBA_R	lduba	[%r30, %r0] 0x72, %r11
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2876000  ! 2364: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xd4840400  ! 2365: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	mov	0x48, %r25
	mov	0x58, %r18
	.word 0xd8f48400  ! 2368: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xd0a44400  ! 2369: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	mov	0x3c8, %r20
	.word 0xd08fe000  ! 2371: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	.word 0xdab74e60  ! 2372: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	mov	0x58, %r19
	.word 0xd29584a0  ! 2374: LDUHA_R	lduha	[%r22, %r0] 0x25, %r9
	mov	0x28, %r25
	mov	0x3e0, %r22
	mov	0x68, %r17
	.word 0x87802020  ! 2378: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea74e60  ! 2379: STWA_R	stwa	%r15, [%r29 + %r0] 0x73
	mov	0x7e0, %r20
	.word 0x8780204f  ! 2381: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdccf6000  ! 2382: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcc72000  ! 2383: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xd4de09e0  ! 2384: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r10
	mov	0x7e0, %r20
	.word 0xdca689e0  ! 2386: STWA_R	stwa	%r14, [%r26 + %r0] 0x4f
	.word 0xd8b72000  ! 2387: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd8bfa000  ! 2388: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xdc8f4e60  ! 2389: LDUBA_R	lduba	[%r29, %r0] 0x73, %r14
	.word 0x87802020  ! 2390: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r25
	.word 0x87802025  ! 2392: WRASI_I	wr	%r0, 0x0025, %asi
	wr_tick_cmpr_1_32:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xdf, %g2
	or	%g4, 0xfe, %g4
	or	%g6, 0xda, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2dd04a0  ! 2394: LDXA_R	ldxa	[%r20, %r0] 0x25, %r9
	.word 0xd2dc6000  ! 2395: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r9
	.word 0xd0bf8e80  ! 2396: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	.word 0xd0dca000  ! 2397: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	.word 0xd2d544a0  ! 2398: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r9
	mov	0x48, %r26
	.word 0xdedfce80  ! 2400: LDXA_R	ldxa	[%r31, %r0] 0x74, %r15
	.word 0x87802020  ! 2401: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f5e000  ! 2402: STXA_I	stxa	%r8, [%r23 + 0x0000] %asi
	mov	0x50, %r27
	.word 0xdcd74e80  ! 2404: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r14
	.word 0x87802020  ! 2405: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r26
	mov	0x58, %r27
	.word 0xdac70e40  ! 2408: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r13
	wr_tick_cmpr_1_33:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb4, %g2
	or	%g4, 0x98, %g4
	or	%g6, 0xbe, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7d8, %r22
	.word 0xd2dc4400  ! 2411: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xd2d5c4a0  ! 2412: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r9
	.word 0x8780204f  ! 2413: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8f74e40  ! 2414: STXA_R	stxa	%r12, [%r29 + %r0] 0x72
	.word 0xd4b4a000  ! 2415: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0x87802020  ! 2417: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r26
	.word 0xdaa5c4a0  ! 2419: STWA_R	stwa	%r13, [%r23 + %r0] 0x25
	.word 0xd29c2000  ! 2420: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	mov	0x10, %r18
	.word 0xd2bca000  ! 2422: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	.word 0xd2d4e000  ! 2423: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0xdecfce40  ! 2424: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r15
	.word 0xd49c2000  ! 2425: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	.word 0xd4b42000  ! 2426: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	mov	0x3d8, %r21
	.word 0xdaaf0e60  ! 2428: STBA_R	stba	%r13, [%r28 + %r0] 0x73
	.word 0xdaaf8e60  ! 2429: STBA_R	stba	%r13, [%r30 + %r0] 0x73
	.word 0xd8842000  ! 2430: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	mov	0x78, %r25
	.word 0x87802020  ! 2432: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a48400  ! 2433: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	mov	0x7e0, %r20
	.word 0xd2ae09e0  ! 2435: STBA_R	stba	%r9, [%r24 + %r0] 0x4f
	mov	0x50, %r27
	mov	0x10, %r27
	.word 0xd2b48400  ! 2438: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	wr_tick_cmpr_1_34:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x94, %g2
	or	%g4, 0xcd, %g4
	or	%g6, 0x82, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdaf76000  ! 2440: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdc9689e0  ! 2441: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r14
	.word 0xdc8f2000  ! 2442: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	mov	0x18, %r27
	.word 0xd8cf4e60  ! 2444: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r12
	.word 0xd087ce40  ! 2445: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r8
	wr_tick_cmpr_1_35:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf0, %g2
	or	%g4, 0x85, %g4
	or	%g6, 0xf8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x8780204f  ! 2447: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0be89e0  ! 2448: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	.word 0xd0b7e000  ! 2449: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 2450: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r26
	.word 0xd0df0e80  ! 2452: LDXA_R	ldxa	[%r28, %r0] 0x74, %r8
	mov	0x18, %r24
	.word 0xdca689e0  ! 2454: STWA_R	stwa	%r14, [%r26 + %r0] 0x4f
	mov	0x20, %r25
	.word 0xd2a48400  ! 2456: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0x87802020  ! 2457: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802025  ! 2459: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdead2000  ! 2460: STBA_I	stba	%r15, [%r20 + 0x0000] %asi
	.word 0xdebd44a0  ! 2461: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	.word 0xdeb52000  ! 2462: STHA_I	stha	%r15, [%r20 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xdc9544a0  ! 2464: LDUHA_R	lduha	[%r21, %r0] 0x25, %r14
	.word 0xdcf5e000  ! 2465: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0xdaf6c9e0  ! 2466: STXA_R	stxa	%r13, [%r27 + %r0] 0x4f
	mov	0x48, %r19
	.word 0xd09e89e0  ! 2468: LDDA_R	ldda	[%r26, %r0] 0x4f, %r8
	.word 0xdcdde000  ! 2469: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	.word 0xdc9d6000  ! 2470: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r14
	.word 0xd0f4c400  ! 2471: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0xd8d5a000  ! 2472: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r12
	.word 0xd4dd04a0  ! 2473: LDXA_R	ldxa	[%r20, %r0] 0x25, %r10
	.word 0x87802072  ! 2474: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdad4e000  ! 2475: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r13
	mov	0x0, %r27
	mov	0x7e8, %r22
	.word 0x8780204f  ! 2478: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa4a000  ! 2479: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xdaace000  ! 2480: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0xd0974e40  ! 2481: LDUHA_R	lduha	[%r29, %r0] 0x72, %r8
	.word 0xd8dca000  ! 2482: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	.word 0x87802073  ! 2483: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8cf6000  ! 2484: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0xdadf4e80  ! 2485: LDXA_R	ldxa	[%r29, %r0] 0x74, %r13
	.word 0xdcafa000  ! 2486: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	mov	0x28, %r19
	.word 0xdc876000  ! 2488: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0xdcaf2000  ! 2489: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0xdccf2000  ! 2491: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xdccf2000  ! 2492: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xd49cc400  ! 2493: LDDA_R	ldda	[%r19, %r0] 0x20, %r10
	.word 0xd0d48400  ! 2494: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	.word 0xd08c4400  ! 2495: LDUBA_R	lduba	[%r17, %r0] 0x20, %r8
	.word 0xdedfe000  ! 2496: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	mov	0x48, %r25
	.word 0xd8870e60  ! 2498: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r12
	.word 0xd4bfe000  ! 2499: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd4d7e000  ! 2500: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	mov	0x60, %r19
	.word 0xdaaf4e40  ! 2502: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	.word 0xdc8584a0  ! 2503: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r14
	.word 0xde8f2000  ! 2504: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xdedf2000  ! 2505: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xd8a6c9e0  ! 2506: STWA_R	stwa	%r12, [%r27 + %r0] 0x4f
	.word 0xd6df2000  ! 2507: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6c76000  ! 2508: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	mov	0x50, %r16
	.word 0x87802073  ! 2510: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r18
	.word 0xdac78e60  ! 2512: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r13
	.word 0xdc9f2000  ! 2513: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xd8d689e0  ! 2514: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r12
	.word 0xd8a70e40  ! 2515: STWA_R	stwa	%r12, [%r28 + %r0] 0x72
	.word 0xdad78e40  ! 2516: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r13
	.word 0x87802074  ! 2517: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2518: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdec7a000  ! 2519: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xde87a000  ! 2520: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xd4ac4400  ! 2521: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xd4afe000  ! 2522: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xdaac4400  ! 2523: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	mov	0x7e8, %r22
	.word 0xd8d7e000  ! 2525: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	mov	0x3f0, %r21
	.word 0x87802073  ! 2527: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 2528: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8df2000  ! 2529: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xda87ce40  ! 2530: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r13
	.word 0xd8c7a000  ! 2531: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	mov	0x78, %r24
	.word 0x87802025  ! 2533: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd89da000  ! 2534: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r12
	.word 0xd8a56000  ! 2535: STWA_I	stwa	%r12, [%r21 + 0x0000] %asi
	.word 0xd4f6c9e0  ! 2536: STXA_R	stxa	%r10, [%r27 + %r0] 0x4f
	.word 0xdcdd6000  ! 2537: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r14
	.word 0xdcada000  ! 2538: STBA_I	stba	%r14, [%r22 + 0x0000] %asi
	.word 0xd6a78e40  ! 2539: STWA_R	stwa	%r11, [%r30 + %r0] 0x72
	.word 0xdcb7ce60  ! 2540: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	mov	0x7c8, %r21
	wr_tick_cmpr_1_36:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf2, %g2
	or	%g4, 0xcf, %g4
	or	%g6, 0xdf, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0b56000  ! 2543: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	.word 0xd8bd04a0  ! 2544: STDA_R	stda	%r12, [%r20 + %r0] 0x25
	mov	0x3e8, %r21
	.word 0xd0ad2000  ! 2546: STBA_I	stba	%r8, [%r20 + 0x0000] %asi
	.word 0xdcc649e0  ! 2547: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r14
	.word 0xd2ada000  ! 2548: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xd2956000  ! 2549: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2550: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8cfce40  ! 2551: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r12
	.word 0xd0a46000  ! 2552: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 2553: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b56000  ! 2554: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	.word 0xdec649e0  ! 2555: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r15
	.word 0xdef5e000  ! 2556: STXA_I	stxa	%r15, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 2557: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r27
	.word 0xdea72000  ! 2559: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	mov	0x48, %r16
	.word 0xded72000  ! 2561: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	mov	0x10, %r16
	.word 0xd0c44400  ! 2563: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r8
	mov	0x3d0, %r20
	mov	0x7f8, %r21
	.word 0xd6dcc400  ! 2566: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	.word 0xd295c4a0  ! 2567: LDUHA_R	lduha	[%r23, %r0] 0x25, %r9
	.word 0xd8b72000  ! 2568: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	mov	0x28, %r25
	.word 0x87802020  ! 2570: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bc0400  ! 2571: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xdad7ce60  ! 2572: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r13
	.word 0xdebd04a0  ! 2573: STDA_R	stda	%r15, [%r20 + %r0] 0x25
	.word 0x87802020  ! 2574: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r26
	.word 0xd0f609e0  ! 2576: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	.word 0xd8be6000  ! 2577: STDA_I	stda	%r12, [%r25 + 0x0000] %asi
	.word 0xdca7ce60  ! 2578: STWA_R	stwa	%r14, [%r31 + %r0] 0x73
	.word 0x87802025  ! 2579: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdab4c400  ! 2580: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xd0b78e80  ! 2581: STHA_R	stha	%r8, [%r30 + %r0] 0x74
	.word 0xdc944400  ! 2582: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	.word 0xd0978e60  ! 2583: LDUHA_R	lduha	[%r30, %r0] 0x73, %r8
	.word 0x87802020  ! 2584: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bee000  ! 2585: STDA_I	stda	%r9, [%r27 + 0x0000] %asi
	.word 0xd6944400  ! 2586: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	.word 0x87802025  ! 2587: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d8, %r21
	.word 0x87802074  ! 2589: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f7e000  ! 2590: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 2591: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdca649e0  ! 2592: STWA_R	stwa	%r14, [%r25 + %r0] 0x4f
	.word 0xd68e2000  ! 2593: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r11
	.word 0xd6b6a000  ! 2594: STHA_I	stha	%r11, [%r26 + 0x0000] %asi
	mov	0x40, %r26
	.word 0xdac649e0  ! 2596: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r13
	mov	0x7d8, %r22
	.word 0xd6c7ce40  ! 2598: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r11
	.word 0xdebe2000  ! 2599: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	mov	0x3e0, %r20
	.word 0xde866000  ! 2601: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r15
	mov	0x40, %r24
	mov	0x10, %r25
	.word 0xde8dc4a0  ! 2604: LDUBA_R	lduba	[%r23, %r0] 0x25, %r15
	.word 0xdaa70e40  ! 2605: STWA_R	stwa	%r13, [%r28 + %r0] 0x72
	.word 0xda9c4400  ! 2606: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	mov	0x10, %r18
	.word 0xd2cee000  ! 2608: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	.word 0xdcad44a0  ! 2609: STBA_R	stba	%r14, [%r21 + %r0] 0x25
	.word 0xdaae2000  ! 2610: STBA_I	stba	%r13, [%r24 + 0x0000] %asi
	.word 0xdab6a000  ! 2611: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	.word 0xdaa62000  ! 2612: STWA_I	stwa	%r13, [%r24 + 0x0000] %asi
	.word 0xdabe6000  ! 2613: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	.word 0xd6b44400  ! 2614: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xdad66000  ! 2615: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r13
	.word 0xded78e40  ! 2616: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r15
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd286a000  ! 2618: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 2619: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0dec9e0  ! 2620: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r8
	.word 0xd8aea000  ! 2621: STBA_I	stba	%r12, [%r26 + 0x0000] %asi
	.word 0x87802025  ! 2622: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2623: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8942000  ! 2624: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r12
	.word 0xd8a4a000  ! 2625: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8b4e000  ! 2626: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0xdcd74e60  ! 2627: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r14
	.word 0xd4bca000  ! 2628: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0xd494e000  ! 2629: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	.word 0xd6be49e0  ! 2630: STDA_R	stda	%r11, [%r25 + %r0] 0x4f
	.word 0xda94e000  ! 2631: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r13
	.word 0x87802073  ! 2632: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 2633: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda85e000  ! 2634: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	.word 0xdaade000  ! 2635: STBA_I	stba	%r13, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 2636: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2637: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r25
	.word 0xd28c8400  ! 2639: LDUBA_R	lduba	[%r18, %r0] 0x20, %r9
	.word 0xd6c6e000  ! 2640: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r11
	.word 0xd6ce6000  ! 2641: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r11
	.word 0xd28544a0  ! 2642: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r9
	mov	0x7e0, %r23
	.word 0xdcf70e60  ! 2644: STXA_R	stxa	%r14, [%r28 + %r0] 0x73
	.word 0x87802073  ! 2645: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcaf2000  ! 2646: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xd6dfce60  ! 2647: LDXA_R	ldxa	[%r31, %r0] 0x73, %r11
	.word 0xd4f7ce60  ! 2648: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	.word 0x87802073  ! 2649: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdabfe000  ! 2650: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2651: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2652: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6840400  ! 2653: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0x8780204f  ! 2654: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc8fe000  ! 2655: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xdc9f6000  ! 2656: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xdc970e80  ! 2657: LDUHA_R	lduha	[%r28, %r0] 0x74, %r14
	ta	T_CHANGE_PRIV	! macro
	mov	0x38, %r24
	.word 0x87802020  ! 2660: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2661: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc94e000  ! 2662: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	.word 0xdc84a000  ! 2663: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	.word 0x87802074  ! 2664: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb4e000  ! 2665: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 2666: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2667: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x28, %r26
	.word 0x87802073  ! 2670: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc9ce000  ! 2671: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r14
	.word 0xdaf48400  ! 2672: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0x87802072  ! 2673: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a72000  ! 2674: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xdedc4400  ! 2675: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	.word 0xd8f48400  ! 2676: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xd8cfa000  ! 2677: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd4b5c4a0  ! 2678: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	.word 0xd0b7e000  ! 2679: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	mov	0x7c0, %r21
	.word 0xd0cf2000  ! 2681: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0xd8f70e60  ! 2682: STXA_R	stxa	%r12, [%r28 + %r0] 0x73
	.word 0xd6c649e0  ! 2683: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r11
	.word 0xd2a72000  ! 2684: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2685: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2686: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2cda000  ! 2687: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r9
	.word 0xd2dde000  ! 2688: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r9
	.word 0xd2ad2000  ! 2689: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0x8780204f  ! 2690: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2d7e000  ! 2691: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	mov	0x3f8, %r20
	.word 0xd2a7e000  ! 2693: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	mov	0x50, %r27
	mov	0x10, %r18
	.word 0xd2af6000  ! 2696: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd2afa000  ! 2697: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xd2bfa000  ! 2698: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd28f6000  ! 2699: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd2c7e000  ! 2700: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2a76000  ! 2701: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 2702: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c78e80  ! 2703: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r9
	.word 0x87802074  ! 2704: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f78e40  ! 2705: STXA_R	stxa	%r9, [%r30 + %r0] 0x72
	.word 0xdea78e80  ! 2706: STWA_R	stwa	%r15, [%r30 + %r0] 0x74
	.word 0xdea7e000  ! 2707: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xde9f4e40  ! 2708: LDDA_R	ldda	[%r29, %r0] 0x72, %r15
	.word 0xdadf6000  ! 2709: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	mov	0x50, %r25
	.word 0x87802074  ! 2711: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd88f0e80  ! 2712: LDUBA_R	lduba	[%r28, %r0] 0x74, %r12
	mov	0x48, %r24
	.word 0xd0a544a0  ! 2714: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	.word 0xdcf74e60  ! 2715: STXA_R	stxa	%r14, [%r29 + %r0] 0x73
	wr_tick_cmpr_1_37:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb7, %g2
	or	%g4, 0x96, %g4
	or	%g6, 0xde, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x58, %r24
	.word 0xd4bd6000  ! 2718: STDA_I	stda	%r10, [%r21 + 0x0000] %asi
	mov	0x60, %r27
	mov	0x48, %r24
	.word 0xd48c4400  ! 2721: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0xdcae49e0  ! 2722: STBA_R	stba	%r14, [%r25 + %r0] 0x4f
	.word 0xdca4c400  ! 2723: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	mov	0x58, %r27
	.word 0xd0a689e0  ! 2725: STWA_R	stwa	%r8, [%r26 + %r0] 0x4f
	.word 0x87802072  ! 2726: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r16
	.word 0xd6c78e40  ! 2728: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	.word 0xdcac6000  ! 2729: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xdcc46000  ! 2730: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r14
	.word 0xdcac2000  ! 2731: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0xdcac2000  ! 2733: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 2734: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc876000  ! 2735: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802020  ! 2737: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcc6a000  ! 2738: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r14
	.word 0x87802074  ! 2739: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcc76000  ! 2740: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xde8fce60  ! 2741: LDUBA_R	lduba	[%r31, %r0] 0x73, %r15
	.word 0xd6afe000  ! 2742: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd0c74e80  ! 2743: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r8
	.word 0xd08f0e40  ! 2744: LDUBA_R	lduba	[%r28, %r0] 0x72, %r8
	.word 0xd6c689e0  ! 2745: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r11
	.word 0xd6f70e40  ! 2746: STXA_R	stxa	%r11, [%r28 + %r0] 0x72
	.word 0xd2de09e0  ! 2747: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r9
	.word 0xd4cfce60  ! 2748: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r10
	.word 0xd6870e60  ! 2749: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r11
	mov	0x68, %r27
	mov	0x8, %r16
	.word 0xd6dfa000  ! 2752: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 2753: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 2754: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r27
	.word 0xd6f7e000  ! 2756: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 2757: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6976000  ! 2758: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	.word 0xd6d76000  ! 2759: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	.word 0xd6f76000  ! 2760: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	mov	0x78, %r17
	.word 0xd8b48400  ! 2762: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0xd8a72000  ! 2763: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	mov	0x28, %r25
	.word 0x87802073  ! 2765: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd897e000  ! 2766: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	.word 0xdaad04a0  ! 2767: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	mov	0x60, %r16
	.word 0xdeafe000  ! 2769: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xda8689e0  ! 2770: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r13
	.word 0xd2bf4e40  ! 2771: STDA_R	stda	%r9, [%r29 + %r0] 0x72
	mov	0x7e8, %r23
	mov	0x7d0, %r22
	.word 0x87802020  ! 2774: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r19
	.word 0xda9ee000  ! 2776: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r13
	mov	0x48, %r17
	.word 0xda9e2000  ! 2778: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r13
	.word 0xdcae89e0  ! 2779: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	.word 0xda8f0e80  ! 2780: LDUBA_R	lduba	[%r28, %r0] 0x74, %r13
	.word 0xd6f66000  ! 2781: STXA_I	stxa	%r11, [%r25 + 0x0000] %asi
	mov	0x70, %r26
	.word 0xd6aea000  ! 2783: STBA_I	stba	%r11, [%r26 + 0x0000] %asi
	.word 0x87802074  ! 2784: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f74e80  ! 2785: STXA_R	stxa	%r10, [%r29 + %r0] 0x74
	.word 0xd0b4a000  ! 2786: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	mov	0x28, %r17
	mov	0x78, %r27
	mov	0x68, %r25
	.word 0xdead44a0  ! 2790: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	mov	0x18, %r25
	.word 0x87802074  ! 2792: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd29c0400  ! 2793: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	.word 0xdaa5e000  ! 2794: STWA_I	stwa	%r13, [%r23 + 0x0000] %asi
	mov	0x30, %r18
	.word 0xd0a44400  ! 2796: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xdebd6000  ! 2797: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	.word 0xdedd6000  ! 2798: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r15
	.word 0xdead6000  ! 2799: STBA_I	stba	%r15, [%r21 + 0x0000] %asi
	.word 0xd6acc400  ! 2800: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xdecde000  ! 2801: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r15
	.word 0xd2f7ce80  ! 2802: STXA_R	stxa	%r9, [%r31 + %r0] 0x74
	.word 0x87802072  ! 2803: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f7ce80  ! 2804: STXA_R	stxa	%r11, [%r31 + %r0] 0x74
	mov	0x0, %r25
	.word 0xdaa70e80  ! 2806: STWA_R	stwa	%r13, [%r28 + %r0] 0x74
	mov	0x58, %r25
	.word 0xd6bf2000  ! 2808: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2809: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2810: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r25
	.word 0xd6bfe000  ! 2812: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	mov	0x48, %r18
	mov	0x8, %r27
	.word 0xd6a72000  ! 2815: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	mov	0x10, %r16
	mov	0x78, %r25
	.word 0xd6f7a000  ! 2818: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd68f6000  ! 2820: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xd8df0e60  ! 2821: LDXA_R	ldxa	[%r28, %r0] 0x73, %r12
	.word 0xdc974e40  ! 2822: LDUHA_R	lduha	[%r29, %r0] 0x72, %r14
	.word 0xd0f44400  ! 2823: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	mov	0x7f8, %r23
	.word 0xd2f7a000  ! 2825: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 2826: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r27
	mov	0x40, %r27
	.word 0x87802073  ! 2829: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b72000  ! 2830: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2831: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r22
	.word 0xde9689e0  ! 2833: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r15
	.word 0xdca76000  ! 2834: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	mov	0x60, %r19
	mov	0x38, %r26
	.word 0xd0f649e0  ! 2837: STXA_R	stxa	%r8, [%r25 + %r0] 0x4f
	.word 0x87802073  ! 2838: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd89e49e0  ! 2839: LDDA_R	ldda	[%r25, %r0] 0x4f, %r12
	.word 0xd2af2000  ! 2840: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 2841: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2af8e60  ! 2842: STBA_R	stba	%r9, [%r30 + %r0] 0x73
	.word 0xd6af6000  ! 2843: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x58, %r25
	mov	0x70, %r16
	.word 0xd2f40400  ! 2846: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xdcdc4400  ! 2847: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	.word 0xd8d76000  ! 2848: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xd887a000  ! 2849: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8d7e000  ! 2850: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	mov	0x70, %r18
	.word 0xd8bf6000  ! 2852: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd8d72000  ! 2853: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	mov	0x8, %r25
	.word 0xd8dfe000  ! 2855: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xd89fe000  ! 2856: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0xd8b72000  ! 2857: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	mov	0x30, %r19
	.word 0x87802072  ! 2859: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdc940400  ! 2861: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0xd8f66000  ! 2862: STXA_I	stxa	%r12, [%r25 + 0x0000] %asi
	.word 0x87802025  ! 2863: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8b5a000  ! 2864: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	.word 0xd8f5a000  ! 2865: STXA_I	stxa	%r12, [%r22 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802072  ! 2867: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8cf6000  ! 2868: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0x87802025  ! 2869: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2870: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2871: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f78e60  ! 2872: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	.word 0xd6f78e80  ! 2873: STXA_R	stxa	%r11, [%r30 + %r0] 0x74
	.word 0xded4c400  ! 2874: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r15
	.word 0x87802073  ! 2875: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc944400  ! 2876: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	mov	0x0, %r27
	.word 0x87802073  ! 2878: WRASI_I	wr	%r0, 0x0073, %asi
	wr_tick_cmpr_1_38:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xdc, %g2
	or	%g4, 0xe3, %g4
	or	%g6, 0xf6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xde94a000  ! 2880: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	mov	0x40, %r19
	mov	0x10, %r16
	.word 0xd2ac4400  ! 2883: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xd0a4a000  ! 2884: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0xd0b46000  ! 2885: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0xd0ac4400  ! 2886: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	mov	0x10, %r19
	wr_tick_cmpr_1_39:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x8e, %g2
	or	%g4, 0xbe, %g4
	or	%g6, 0xc5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0f46000  ! 2889: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	mov	0x30, %r24
	.word 0xd0d4a000  ! 2891: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	mov	0x50, %r24
	.word 0xdc848400  ! 2893: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	.word 0xdac7ce40  ! 2894: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r13
	.word 0x8780204f  ! 2895: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf52000  ! 2896: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	.word 0xd6c504a0  ! 2897: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r11
	mov	0x30, %r19
	.word 0xdcadc4a0  ! 2899: STBA_R	stba	%r14, [%r23 + %r0] 0x25
	.word 0x87802073  ! 2900: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4a609e0  ! 2901: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	.word 0xdad70e40  ! 2902: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r13
	mov	0x30, %r24
	.word 0x8780204f  ! 2904: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2cfa000  ! 2905: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	.word 0xd2f72000  ! 2906: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd2dfa000  ! 2907: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	mov	0x30, %r27
	mov	0x28, %r25
	mov	0x60, %r19
	.word 0x8780204f  ! 2911: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabe49e0  ! 2912: STDA_R	stda	%r13, [%r25 + %r0] 0x4f
	.word 0xd0846000  ! 2913: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0x87802073  ! 2914: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r25
	.word 0xd6bf4e40  ! 2916: STDA_R	stda	%r11, [%r29 + %r0] 0x72
	.word 0xdc9d44a0  ! 2917: LDDA_R	ldda	[%r21, %r0] 0x25, %r14
	.word 0xdca46000  ! 2918: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 2919: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcc66000  ! 2920: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	.word 0x87802072  ! 2921: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda870e40  ! 2922: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r13
	.word 0xd88649e0  ! 2923: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r12
	.word 0x87802025  ! 2924: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cc0400  ! 2925: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r10
	.word 0xd6f46000  ! 2926: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0xd68c6000  ! 2927: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r11
	mov	0x8, %r25
	mov	0x38, %r25
	.word 0xd0b78e60  ! 2930: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	.word 0xdea78e80  ! 2931: STWA_R	stwa	%r15, [%r30 + %r0] 0x74
	.word 0xd6bc0400  ! 2932: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xd0b42000  ! 2933: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	mov	0x7c8, %r23
	mov	0x40, %r25
	mov	0x48, %r24
	.word 0xdac40400  ! 2937: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	mov	0x68, %r17
	.word 0x87802073  ! 2939: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbda000  ! 2940: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	.word 0xdcf5e000  ! 2941: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 2942: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 2943: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2944: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf7a000  ! 2945: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xd0bfce60  ! 2946: STDA_R	stda	%r8, [%r31 + %r0] 0x73
	mov	0x8, %r19
	.word 0x87802074  ! 2948: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r16
	.word 0xdcac0400  ! 2950: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xde840400  ! 2951: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	.word 0xd8b44400  ! 2952: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	mov	0x3d0, %r20
	.word 0x87802073  ! 2954: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa42000  ! 2955: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0xdaa4a000  ! 2956: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xd0c609e0  ! 2957: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r8
	mov	0x7f0, %r22
	mov	0x7e0, %r23
	.word 0xd6c70e80  ! 2960: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r11
	.word 0xdaf4e000  ! 2961: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xdabce000  ! 2962: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0xd0a48400  ! 2963: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0xd2d42000  ! 2964: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0xd49f8e40  ! 2965: LDDA_R	ldda	[%r30, %r0] 0x72, %r10
	.word 0xd49d04a0  ! 2966: LDDA_R	ldda	[%r20, %r0] 0x25, %r10
	.word 0xd2b7ce40  ! 2967: STHA_R	stha	%r9, [%r31 + %r0] 0x72
	.word 0xdab689e0  ! 2968: STHA_R	stha	%r13, [%r26 + %r0] 0x4f
	.word 0xd6f48400  ! 2969: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xd0dca000  ! 2970: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	mov	0x30, %r27
	.word 0x8780204f  ! 2972: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0af6000  ! 2973: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd8f78e80  ! 2974: STXA_R	stxa	%r12, [%r30 + %r0] 0x74
	.word 0xd897a000  ! 2975: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8dfe000  ! 2977: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0x87802073  ! 2978: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd88d04a0  ! 2979: LDUBA_R	lduba	[%r20, %r0] 0x25, %r12
	.word 0xd4ac0400  ! 2980: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0x87802073  ! 2981: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa6c9e0  ! 2982: STWA_R	stwa	%r13, [%r27 + %r0] 0x4f
	.word 0xdeae09e0  ! 2983: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	mov	0x3f8, %r23
	.word 0xde872000  ! 2985: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 2986: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 2987: WRASI_I	wr	%r0, 0x0072, %asi
	wr_tick_cmpr_1_40:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xec, %g2
	or	%g4, 0x9a, %g4
	or	%g6, 0xa0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %psta