// Modified by Princeton University on June 9th, 2015
/*
* ========== Copyright Header Begin ==========================================
* 
* OpenSPARC T1 Processor File: fmuld_rnd_near.s
* Copyright (c) 2006 Sun Microsystems, Inc.  All Rights Reserved.
* DO NOT ALTER OR REMOVE COPYRIGHT NOTICES.
* 
* The above named program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License version 2 as published by the Free Software Foundation.
* 
* The above named program is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
* 
* You should have received a copy of the GNU General Public
* License along with this work; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
* 
* ========== Copyright Header End ============================================
*/
/***********************************************************************
* Name:   fmuld_rnd_near.s
* Date:   11/6/02
*
*
**********************************************************************/

#ifdef MT_TEMPLATE
#include "mt_body.h"
#else
#define ENABLE_T0_Fp_disabled_0x20
#include "boot.s"
.global main
#endif

.global sam_fast_immu_miss
.global sam_fast_dmmu_miss

.text

! Testing fmuld with rounding mode near

!// fmuld_rnd_near
!//
!//	Tests FMULD in round to nearest mode
!//	Inputs are positive and negative:
!//		- infinity and infinity
!//		- infinity and NaN
!//		- NaN and infinity
!//		- NaN and NaN
!//		- infinity and norm/denorm/zero
!//		- NaN and norm/denorm/zero
!//		- norm/denorm/zero and infinity
!//		- norm/denorm/zero and NaN
!//		- norm/denorm/zero and norm/denorm/zero


main:

	! Common code

	wr		%g0, 0x4, %fprs		! make sure fef is 1 
	setx		source1, %l0, %l1
	setx		source2, %l0, %l2
	setx		result, %l0, %l3
	setx		fcc_result, %l0, %l4
	setx		cexc_flag, %l0, %l5
	setx		fsr_rounding_mode, %l0, %l6
	setx		scratch, %l0, %l7


	set		386, %g1		! Set loop count
	set		0x0, %g2		! Set loop iterator


fmuld_loop:
	ldx		[%l6+0x0], %fsr


	! instruction specific code

	sll		%g2, 0x3, %g3

	ldx		[%l6], %fsr		! Load fsr with rounding mode
	ldd		[%l1+%g3], %f0		! Load source 1
	ldd		[%l2+%g3], %f2		! Load source 2
	fmuld		%f0, %f2, %f4		! Perform the operation
	std		%f4, [%l7+0x0]		! Store the result for comparison
	stx		%fsr, [%l7+0x8]		! Store the fsr for comparison
	ldx		[%l7+0x0], %g4		! Load result from memory for comparison

        ldx     [%l7+0x8], %g5   ! Load fsr from memory for comparison
        sll     %g2, 0x3, %g3
        ldx     [%l5+%g3], %g6   ! Load fsr with expected cexc mode
        mov     0x0f, %g3              ! Mask for nv
        and     %g3, %g6, %g7          ! Mask off nv
        srl     %g7, 0x3, %g7          ! Shift to get of
        or      %g7, %g6, %g6          ! Generate correct nx with of
        mov     0x01, %g3              ! Mask to get nx
        and     %g3, %g6, %g7          ! Mask off all but nx
        sll     %g7, 0x2, %g7          ! Shift to align nx and uf
        or      %g7, 0x1b, %g7         ! Mask for all cexc bits
        and     %g7, %g6, %g6          ! Generate correct uf for denorm
	      sll     %g6, 0x5, %g7          ! Generate aexc
	      or      %g6, %g7, %g7          ! Generate expected fsr
	      ldx     [%l6], %g6        ! Load fsr with rounding mode
	      or      %g6, %g7, %g7          ! Generate expected fsr

	sll		%g2, 0x3, %g3
	ldx		[%l3+%g3], %g6		! Load expected result

	subcc		%g4, %g6, %g0		! Compare
	bne,a		test_fail		! If not equal, test failed
	nop
	subcc		%g5, %g7, %g0		! Compare
	bne,a		test_fail		! If not equal, test failed
	nop


	add		%g2, 0x1, %g2		! Increment loop iterator
	subcc		%g2, %g1, %g0		! Compare
	bne,a		fmuld_loop		! Loop
	nop


/*******************************************************
 * Exit code
 *******************************************************/

test_pass:
	ta		T_GOOD_TRAP

test_fail:
	ta		T_BAD_TRAP




/*******************************************************
* Data section
*******************************************************/
.data


fsr_rounding_mode:
	.xword		0x0000000000000000


source1:
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0x7ff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0x7fffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0x7ff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0x7fffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fe0000000000000
	.xword		0x7fe0000000000000
	.xword		0x7fe0000000000001
	.xword		0x3ffffffffffffffe
	.xword		0x3fffffffffffffff
	.xword		0x3fffffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x3ff2000000000000
	.xword		0x3ff4000000000000
	.xword		0x3ff6000000000000
	.xword		0x3ff0000000000000
	.xword		0x3ff4000000000000
	.xword		0x3ff8000000000000
	.xword		0x3ffc000000000000
	.xword		0x3ff0000000000001
	.xword		0x3ff8000000000001
	.xword		0x3ff0000000000001
	.xword		0x3ff4000000000001
	.xword		0x3ff0000000000002
	.xword		0x3ff0000000000002
	.xword		0x3ff0000000000002
	.xword		0x3ff0000000000002
	.xword		0x3ff0000000000001
	.xword		0x3ff0000000000001
	.xword		0x3ff0000000000001
	.xword		0x3ff0000000000001
	.xword		0x3ff0000000000001
	.xword		0x3ff0000000000001
	.xword		0x3ff0000000000002
	.xword		0x3ff0000000000002
	.xword		0x2000000000000000
	.xword		0x2004000000000000
	.xword		0x2008000000000000
	.xword		0x200c000000000000
	.xword		0x2000000000000000
	.xword		0x2002000000000000
	.xword		0x2004000000000000
	.xword		0x2006000000000000
	.xword		0x2000000000000001
	.xword		0x2004000000000001
	.xword		0x2000000000000001
	.xword		0x2008000000000001
	.xword		0x1ff0000000000002
	.xword		0x1ff0000000000002
	.xword		0x1ff0000000000002
	.xword		0x1ff0000000000002
	.xword		0x1ff0000000000004
	.xword		0x1ff0000000000004
	.xword		0x1ff0000000000004
	.xword		0x1ff0000000000004
	.xword		0x1ff0000000000004
	.xword		0x1ff0000000000008
	.xword		0x1ff0000000000002
	.xword		0x1ff0000000000008
.align 8


source2:
	.xword		0x7ff0000000000000
	.xword		0xfff0000000000000
	.xword		0x7ff0000000000000
	.xword		0xfff0000000000000
	.xword		0x7ff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0x7fffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0x7ff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0x7fffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0x7ff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0x7fffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0x7ff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0x7fffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0x7ff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0x7fffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0x7ff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0x7fffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xfff012345678000c
	.xword		0x7ff012345678000c
	.xword		0xfff012345678000c
	.xword		0x7ff012345678000c
	.xword		0xffffedcba9870003
	.xword		0x7fffedcba9870003
	.xword		0xffffedcba9870003
	.xword		0x7fffedcba9870003
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0x7ff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0xfff0123456789abc
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0x7fefffffffffffff
	.xword		0x7fefffffffffffff
	.xword		0x7fefffffffffffff
	.xword		0x7fefffffffffffff
	.xword		0x7fefffffffffffff
	.xword		0x7fefffffffffffff
	.xword		0x7fefffffffffffff
	.xword		0x7fefffffffffffff
	.xword		0x7fefffffffffffff
	.xword		0x7fefffffffffffff
	.xword		0x7fefffffffffffff
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x3ff0000000000000
	.xword		0x3ff0000000000000
	.xword		0x3ff0000000000000
	.xword		0x3ff0000000000000
	.xword		0x3ff0000000000000
	.xword		0x3ff0000000000000
	.xword		0x3ff0000000000000
	.xword		0x3ff0000000000000
	.xword		0x3ff0000000000000
	.xword		0x3ff0000000000000
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x0010000000000000
	.xword		0x0010000000000000
	.xword		0x0010000000000000
	.xword		0x0010000000000000
	.xword		0x0010000000000000
	.xword		0x0010000000000000
	.xword		0x0010000000000000
	.xword		0x0010000000000000
	.xword		0x0010000000000000
	.xword		0x0010000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x000fffffffffffff
	.xword		0x000fffffffffffff
	.xword		0x000fffffffffffff
	.xword		0x000fffffffffffff
	.xword		0x000fffffffffffff
	.xword		0x000fffffffffffff
	.xword		0x000fffffffffffff
	.xword		0x000fffffffffffff
	.xword		0x000fffffffffffff
	.xword		0x000fffffffffffff
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xffefffffffffffff
	.xword		0xffefffffffffffff
	.xword		0xffefffffffffffff
	.xword		0xffefffffffffffff
	.xword		0xffefffffffffffff
	.xword		0xffefffffffffffff
	.xword		0xffefffffffffffff
	.xword		0xffefffffffffffff
	.xword		0xffefffffffffffff
	.xword		0xffefffffffffffff
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0xbff0000000000000
	.xword		0xbff0000000000000
	.xword		0xbff0000000000000
	.xword		0xbff0000000000000
	.xword		0xbff0000000000000
	.xword		0xbff0000000000000
	.xword		0xbff0000000000000
	.xword		0xbff0000000000000
	.xword		0xbff0000000000000
	.xword		0xbff0000000000000
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x8010000000000000
	.xword		0x8010000000000000
	.xword		0x8010000000000000
	.xword		0x8010000000000000
	.xword		0x8010000000000000
	.xword		0x8010000000000000
	.xword		0x8010000000000000
	.xword		0x8010000000000000
	.xword		0x8010000000000000
	.xword		0x8010000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x800fffffffffffff
	.xword		0x800fffffffffffff
	.xword		0x800fffffffffffff
	.xword		0x800fffffffffffff
	.xword		0x800fffffffffffff
	.xword		0x800fffffffffffff
	.xword		0x800fffffffffffff
	.xword		0x800fffffffffffff
	.xword		0x800fffffffffffff
	.xword		0x800fffffffffffff
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000001
	.xword		0x8000000000000001
	.xword		0x8000000000000001
	.xword		0x8000000000000001
	.xword		0x8000000000000001
	.xword		0x8000000000000001
	.xword		0x8000000000000001
	.xword		0x8000000000000001
	.xword		0x8000000000000001
	.xword		0x8000000000000001
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x3ffffffffffffffe
	.xword		0x3fffffffffffffff
	.xword		0x3fffffffffffffff
	.xword		0x7fe0000000000000
	.xword		0x7fe0000000000000
	.xword		0x7fe0000000000001
	.xword		0x3ff0000000000002
	.xword		0x3ff0000000000002
	.xword		0x3ff0000000000002
	.xword		0x3ff0000000000002
	.xword		0x3ff0000000000001
	.xword		0x3ff0000000000001
	.xword		0x3ff0000000000001
	.xword		0x3ff0000000000001
	.xword		0x3ff0000000000001
	.xword		0x3ff0000000000001
	.xword		0x3ff0000000000002
	.xword		0x3ff0000000000002
	.xword		0x3ff0000000000000
	.xword		0x3ff2000000000000
	.xword		0x3ff4000000000000
	.xword		0x3ff6000000000000
	.xword		0x3ff0000000000000
	.xword		0x3ff4000000000000
	.xword		0x3ff8000000000000
	.xword		0x3ffc000000000000
	.xword		0x3ff0000000000001
	.xword		0x3ff8000000000001
	.xword		0x3ff0000000000001
	.xword		0x3ff4000000000001
	.xword		0x1ff0000000000002
	.xword		0x1ff0000000000002
	.xword		0x1ff0000000000002
	.xword		0x1ff0000000000002
	.xword		0x1ff0000000000004
	.xword		0x1ff0000000000004
	.xword		0x1ff0000000000004
	.xword		0x1ff0000000000004
	.xword		0x1ff0000000000004
	.xword		0x1ff0000000000008
	.xword		0x1ff0000000000002
	.xword		0x1ff0000000000008
	.xword		0x2000000000000000
	.xword		0x2004000000000000
	.xword		0x2008000000000000
	.xword		0x200c000000000000
	.xword		0x2000000000000000
	.xword		0x2002000000000000
	.xword		0x2004000000000000
	.xword		0x2006000000000000
	.xword		0x2000000000000001
	.xword		0x2004000000000001
	.xword		0x2000000000000001
	.xword		0x2008000000000001
.align 8


result:
	.xword		0x7ff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0x7fffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0x7ff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0x7fffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0x7ff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0x7fffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0x7ff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0x7fffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0x7ff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0x7fffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0x7ff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0x7fffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xfff812345678000c
	.xword		0x7ff812345678000c
	.xword		0xfff812345678000c
	.xword		0x7ff812345678000c
	.xword		0xffffedcba9870003
	.xword		0x7fffedcba9870003
	.xword		0xffffedcba9870003
	.xword		0x7fffedcba9870003
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7fffffffffffffff
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0x7fffffffffffffff
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0x7fffffffffffffff
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7fffffffffffffff
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7fffffffffffffff
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0x7fffffffffffffff
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0xfff0000000000000
	.xword		0x7fffffffffffffff
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7ff0000000000000
	.xword		0x7fffffffffffffff
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0x7ff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0xfff8123456789abc
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0x7fffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0xffffedcba9876543
	.xword		0x7ff0000000000000
	.xword		0x7fefffffffffffff
	.xword		0x400fffffffffffff
	.xword		0x400ffffffffffffd
	.xword		0x3ccfffffffffffff
	.xword		0x0000000000000000
	.xword		0xfff0000000000000
	.xword		0xffefffffffffffff
	.xword		0xc00fffffffffffff
	.xword		0xc00ffffffffffffd
	.xword		0xbccfffffffffffff
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x400fffffffffffff
	.xword		0x0010000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0xc00fffffffffffff
	.xword		0x8010000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x400ffffffffffffd
	.xword		0x000fffffffffffff
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0xc00ffffffffffffd
	.xword		0x800fffffffffffff
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x3ccfffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0xbccfffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0xfff0000000000000
	.xword		0xffefffffffffffff
	.xword		0xc00fffffffffffff
	.xword		0xc00ffffffffffffd
	.xword		0xbccfffffffffffff
	.xword		0x8000000000000000
	.xword		0x7ff0000000000000
	.xword		0x7fefffffffffffff
	.xword		0x400fffffffffffff
	.xword		0x400ffffffffffffd
	.xword		0x3ccfffffffffffff
	.xword		0x0000000000000000
	.xword		0xffefffffffffffff
	.xword		0xbff0000000000000
	.xword		0x8010000000000000
	.xword		0x800fffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x7fefffffffffffff
	.xword		0x3ff0000000000000
	.xword		0x0010000000000000
	.xword		0x000fffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0xc00fffffffffffff
	.xword		0x8010000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x400fffffffffffff
	.xword		0x0010000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0xc00ffffffffffffd
	.xword		0x800fffffffffffff
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x400ffffffffffffd
	.xword		0x000fffffffffffff
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0xbccfffffffffffff
	.xword		0x8000000000000001
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x3ccfffffffffffff
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x8000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x7feffffffffffffe
	.xword		0x7fefffffffffffff
	.xword		0x7ff0000000000000
	.xword		0x7feffffffffffffe
	.xword		0x7fefffffffffffff
	.xword		0x7ff0000000000000
	.xword		0x3ff0000000000002
	.xword		0x3ff2000000000002
	.xword		0x3ff4000000000002
	.xword		0x3ff6000000000003
	.xword		0x3ff0000000000001
	.xword		0x3ff4000000000001
	.xword		0x3ff8000000000002
	.xword		0x3ffc000000000002
	.xword		0x3ff0000000000002
	.xword		0x3ff8000000000003
	.xword		0x3ff0000000000003
	.xword		0x3ff4000000000004
	.xword		0x3ff0000000000002
	.xword		0x3ff2000000000002
	.xword		0x3ff4000000000002
	.xword		0x3ff6000000000003
	.xword		0x3ff0000000000001
	.xword		0x3ff4000000000001
	.xword		0x3ff8000000000002
	.xword		0x3ffc000000000002
	.xword		0x3ff0000000000002
	.xword		0x3ff8000000000003
	.xword		0x3ff0000000000003
	.xword		0x3ff4000000000004
	.xword		0x0008000000000001
	.xword		0x000a000000000001
	.xword		0x000c000000000002
	.xword		0x000e000000000002
	.xword		0x0008000000000002
	.xword		0x0009000000000002
	.xword		0x000a000000000002
	.xword		0x000b000000000003
	.xword		0x0008000000000003
	.xword		0x000a000000000006
	.xword		0x0008000000000002
	.xword		0x000c000000000007
	.xword		0x0008000000000001
	.xword		0x000a000000000001
	.xword		0x000c000000000002
	.xword		0x000e000000000002
	.xword		0x0008000000000002
	.xword		0x0009000000000002
	.xword		0x000a000000000002
	.xword		0x000b000000000003
	.xword		0x0008000000000003
	.xword		0x000a000000000006
	.xword		0x0008000000000002
	.xword		0x000c000000000007
.align 8
fcc_result:


cexc_flag:
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000010
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000010
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000010
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000010
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000010
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000010
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000009
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000009
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000000
	.xword		0x0000000000000001
	.xword		0x0000000000000004
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000000
	.xword		0x0000000000000001
	.xword		0x0000000000000004
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000004
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000004
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000009
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000009
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000000
	.xword		0x0000000000000001
	.xword		0x0000000000000004
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000000
	.xword		0x0000000000000001
	.xword		0x0000000000000004
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000004
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000004
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000009
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000009
	.xword		0x0000000000000000
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000000
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000004
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000004
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000004
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000004
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
.align 8


scratch:
	.xword		0x0000000000000000
	.xword		0x0000000000000000


