// Modified by Princeton University on June 9th, 2015
/*
* ========== Copyright Header Begin ==========================================
* 
* OpenSPARC T1 Processor File: bug7117_4.s
* Copyright (c) 2006 Sun Microsystems, Inc.  All Rights Reserved.
* DO NOT ALTER OR REMOVE COPYRIGHT NOTICES.
* 
* The above named program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License version 2 as published by the Free Software Foundation.
* 
* The above named program is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
* 
* You should have received a copy of the GNU General Public
* License along with this work; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
* 
* ========== Copyright Header End ============================================
*/
/*
********************************************************************************
   random seed:	534934199
   Jal lsubug.j:	
********************************************************************************/


#define CIOP
#define THREAD_MASK 0xf
#define NO_TRAPCHECK
#include "enable_traps.h"
#include "hboot.s"

.text
.global main

main:

	ta	%icc, T_RD_THID
! fork: source strm = 0xffffffff; target strm = 0x1
	cmp	%o1, 0
	setx	fork_lbl_0_1, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x2
	cmp	%o1, 1
	setx	fork_lbl_0_2, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x4
	cmp	%o1, 2
	setx	fork_lbl_0_3, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x8
	cmp	%o1, 3
	setx	fork_lbl_0_4, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_4:
        setx  0x858386392fb7730c, %r1, %r1
        setx  0x03d18d26362b13da, %r1, %r2
        setx  0x410a4b7db9bc6e92, %r1, %r3
        setx  0x70a6648d12bab693, %r1, %r4
        setx  0x2a2cdd39fafc2563, %r1, %r5
        setx  0x064673be61515254, %r1, %r6
        setx  0x343b9e48d602d8a5, %r1, %r7
        setx  0xebdbcffaa7b6a49d, %r1, %r8
        setx  0xa1ec4174dfa8fbd1, %r1, %r9
        setx  0x043b548894b7ca3e, %r1, %r10
        setx  0xea9e341da7b2432b, %r1, %r11
        setx  0x2e3483c0388bd369, %r1, %r12
        setx  0x05c297781abb3958, %r1, %r13
        setx  0x1d89172120a40b29, %r1, %r14
        setx  0x36516bc7d026fd60, %r1, %r15
        setx  0xf4a8a7716702c20f, %r1, %r16
        setx  0xe1bbf0c271db3e2c, %r1, %r17
        setx  0x87523cb7ddd1ffe4, %r1, %r18
        setx  0x6981847cb9cdda55, %r1, %r19
        setx  0xf2276eb12df11b49, %r1, %r20
        setx  0x6daeb9e1ac8ad6a9, %r1, %r21
        setx  0x8c9bca36d1d2c4ce, %r1, %r22
        setx  0x831852e6b373db27, %r1, %r23
        setx  0x31ef8c8a7cfb33ee, %r1, %r24
        setx  0xd3b8de47966d4fbb, %r1, %r25
        setx  0x5db28c94d389b758, %r1, %r26
        setx  0xc33c09ea7bef21d4, %r1, %r27
        setx  0x5ad1a6c0c0f08518, %r1, %r28
        setx  0x48e5fc6af75e8761, %r1, %r29
        setx  0x78d58546189c04ac, %r1, %r30
        setx  0xf1b05d55af82637b, %r1, %r31
        setx  0x0000000000000cd0, %r1, %r2
	setx shared_data, %r1, %r16
        wr %g0, 0x80, %asi
        wr %g0, 0x4, %fprs
	ldd	[%r16 + 0], %f0
	ldd	[%r16 + 8], %f2
	ldd	[%r16 + 16], %f4
	ldd	[%r16 + 24], %f6
	ldd	[%r16 + 32], %f8
	ldd	[%r16 + 40], %f10
	ldd	[%r16 + 48], %f12
	ldd	[%r16 + 56], %f14
	ldd	[%r16 + 64], %f16
	ldd	[%r16 + 72], %f18
	ldd	[%r16 + 80], %f20
	ldd	[%r16 + 88], %f22
	ldd	[%r16 + 96], %f24
	ldd	[%r16 + 104], %f26
	ldd	[%r16 + 112], %f28
	ldd	[%r16 + 120], %f30
	ldd	[%r16 + 128], %f32
	ldd	[%r16 + 136], %f34
	ldd	[%r16 + 144], %f36
	ldd	[%r16 + 152], %f38
	ldd	[%r16 + 160], %f40
	ldd	[%r16 + 168], %f42
	ldd	[%r16 + 176], %f44
	ldd	[%r16 + 184], %f46
	ldd	[%r16 + 192], %f48
	ldd	[%r16 + 200], %f50
	ldd	[%r16 + 208], %f52
	ldd	[%r16 + 216], %f54
	ldd	[%r16 + 224], %f56
	ldd	[%r16 + 232], %f58
	ldd	[%r16 + 240], %f60
	ldd	[%r16 + 248], %f62
        mov 0x11, %r31
thr3_loop_cnt_0:
	.word 0xc65422f8  ! 1: LDSH_I	ldsh	[%r16 + 0x02f8], %r3
	.word 0xe2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r17
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xced42b36  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b36] %asi, %r7
	.word 0xc6d42ee4  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ee4] %asi, %r3
	.word 0xd644228c  ! 1: LDSW_I	ldsw	[%r16 + 0x028c], %r11
	.word 0xf28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r25
	.word 0xecdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r22
	.word 0xdc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r14
	.word 0xd4cc2581  ! 1: LDSBA_I	ldsba	[%r16, + 0x0581] %asi, %r10
	brnz %r31,thr3_loop_cnt_0
	dec %r31
	.word 0x921c0002  ! 1: XOR_R	xor 	%r16, %r2, %r9
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0xa92c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r20
        mov 0x4c, %r31
thr3_loop_cnt_1:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc60428bc  ! 1: LDUW_I	lduw	[%r16 + 0x08bc], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd2942bca  ! 1: LDUHA_I	lduha	[%r16, + 0x0bca] %asi, %r9
	.word 0xd0c42f8c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f8c] %asi, %r8
	.word 0xfcc42894  ! 1: LDSWA_I	ldswa	[%r16, + 0x0894] %asi, %r30
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1
	dec %r31
        mov 0x27, %r31
thr3_loop_cnt_2:
	.word 0xd48c2b81  ! 1: LDUBA_I	lduba	[%r16, + 0x0b81] %asi, %r10
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc68c2c18  ! 1: LDUBA_I	lduba	[%r16, + 0x0c18] %asi, %r3
	.word 0xc64c2e01  ! 1: LDSB_I	ldsb	[%r16 + 0x0e01], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc68c2a21  ! 1: LDUBA_I	lduba	[%r16, + 0x0a21] %asi, %r3
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6842b60  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b60] %asi, %r3
	brnz %r31,thr3_loop_cnt_2
	dec %r31
        mov 0x17, %r31
thr3_loop_cnt_3:
	.word 0xf05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r24
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6842914  ! 1: LDUWA_I	lduwa	[%r16, + 0x0914] %asi, %r3
	.word 0xf6542334  ! 1: LDSH_I	ldsh	[%r16 + 0x0334], %r27
	.word 0xc6dc22d8  ! 1: LDXA_I	ldxa	[%r16, + 0x02d8] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r20
	.word 0xeac42c0c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c0c] %asi, %r21
	brnz %r31,thr3_loop_cnt_3
	dec %r31
        mov 0x2e, %r31
thr3_loop_cnt_4:
	.word 0xc6c42130  ! 1: LDSWA_I	ldswa	[%r16, + 0x0130] %asi, %r3
	.word 0xeec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r23
	.word 0xc6042048  ! 1: LDUW_I	lduw	[%r16 + 0x0048], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xead42b0e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b0e] %asi, %r21
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	brnz %r31,thr3_loop_cnt_4
	dec %r31
	.word 0x9e0c2df7  ! 1: AND_I	and 	%r16, 0x0df7, %r15
	.word 0x8e140002  ! 1: OR_R	or 	%r16, %r2, %r7
	.word 0x9d340002  ! 1: SRL_R	srl 	%r16, %r2, %r14
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x24, %r31
thr3_loop_cnt_5:
	.word 0xecdc2e98  ! 1: LDXA_I	ldxa	[%r16, + 0x0e98] %asi, %r22
	.word 0xc64c24e6  ! 1: LDSB_I	ldsb	[%r16 + 0x04e6], %r3
	.word 0xe6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r19
	.word 0xc6dc2cd0  ! 1: LDXA_I	ldxa	[%r16, + 0x0cd0] %asi, %r3
	.word 0xda440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r13
	.word 0xd80c2ea7  ! 1: LDUB_I	ldub	[%r16 + 0x0ea7], %r12
	.word 0xc6442674  ! 1: LDSW_I	ldsw	[%r16 + 0x0674], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf844204c  ! 1: LDSW_I	ldsw	[%r16 + 0x004c], %r28
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd05c2c48  ! 1: LDX_I	ldx	[%r16 + 0x0c48], %r8
	brnz %r31,thr3_loop_cnt_5
	dec %r31
	.word 0xb2342f6f  ! 1: SUBC_I	orn 	%r16, 0x0f6f, %r25
	.word 0x96440002  ! 1: ADDC_R	addc 	%r16, %r2, %r11
        mov 0x9b, %r31
thr3_loop_cnt_6:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe2c42a80  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a80] %asi, %r17
	.word 0xc6c42aac  ! 1: LDSWA_I	ldswa	[%r16, + 0x0aac] %asi, %r3
	.word 0xe25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r17
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xeecc2dc1  ! 1: LDSBA_I	ldsba	[%r16, + 0x0dc1] %asi, %r23
	.word 0xeccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r22
	.word 0xe60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r19
	brnz %r31,thr3_loop_cnt_6
	dec %r31
	.word 0x9f2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r15
	.word 0x9a1c2047  ! 1: XOR_I	xor 	%r16, 0x0047, %r13
        mov 0xbb, %r31
thr3_loop_cnt_7:
	.word 0xd0542ab2  ! 1: LDSH_I	ldsh	[%r16 + 0x0ab2], %r8
	.word 0xc6dc2188  ! 1: LDXA_I	ldxa	[%r16, + 0x0188] %asi, %r3
	.word 0xc694291e  ! 1: LDUHA_I	lduha	[%r16, + 0x091e] %asi, %r3
	.word 0xf69423ec  ! 1: LDUHA_I	lduha	[%r16, + 0x03ec] %asi, %r27
	.word 0xec5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r22
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	.word 0xe4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r18
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_7
	dec %r31
        mov 0x4e, %r31
thr3_loop_cnt_8:
	.word 0xf0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r24
	.word 0xf6cc269d  ! 1: LDSBA_I	ldsba	[%r16, + 0x069d] %asi, %r27
	.word 0xc6442620  ! 1: LDSW_I	ldsw	[%r16 + 0x0620], %r3
	.word 0xeccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r22
	.word 0xf0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r24
	.word 0xe28c2a20  ! 1: LDUBA_I	lduba	[%r16, + 0x0a20] %asi, %r17
	.word 0xf40c2636  ! 1: LDUB_I	ldub	[%r16 + 0x0636], %r26
	.word 0xc6c42200  ! 1: LDSWA_I	ldswa	[%r16, + 0x0200] %asi, %r3
	.word 0xd05c2218  ! 1: LDX_I	ldx	[%r16 + 0x0218], %r8
	.word 0xf0dc25c0  ! 1: LDXA_I	ldxa	[%r16, + 0x05c0] %asi, %r24
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_8
	dec %r31
	.word 0xb1341002  ! 1: SRLX_R	srlx	%r16, %r2, %r24
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x25, %r31
thr3_loop_cnt_9:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r24
	.word 0xc644274c  ! 1: LDSW_I	ldsw	[%r16 + 0x074c], %r3
	.word 0xf0dc2e28  ! 1: LDXA_I	ldxa	[%r16, + 0x0e28] %asi, %r24
	.word 0xc60c2c80  ! 1: LDUB_I	ldub	[%r16 + 0x0c80], %r3
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xde0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r15
	.word 0xccdc2638  ! 1: LDXA_I	ldxa	[%r16, + 0x0638] %asi, %r6
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_9
	dec %r31
        mov 0xbe, %r31
thr3_loop_cnt_10:
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xd84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r12
	.word 0xc6942dfc  ! 1: LDUHA_I	lduha	[%r16, + 0x0dfc] %asi, %r3
	.word 0xdc4c2a95  ! 1: LDSB_I	ldsb	[%r16 + 0x0a95], %r14
	.word 0xc604296c  ! 1: LDUW_I	lduw	[%r16 + 0x096c], %r3
	.word 0xc6cc22ed  ! 1: LDSBA_I	ldsba	[%r16, + 0x02ed] %asi, %r3
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xfc942638  ! 1: LDUHA_I	lduha	[%r16, + 0x0638] %asi, %r30
	.word 0xdedc23c8  ! 1: LDXA_I	ldxa	[%r16, + 0x03c8] %asi, %r15
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	.word 0xc6dc2a78  ! 1: LDXA_I	ldxa	[%r16, + 0x0a78] %asi, %r3
	brnz %r31,thr3_loop_cnt_10
	dec %r31
	.word 0xac240002  ! 1: SUB_R	sub 	%r16, %r2, %r22
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x913c0002  ! 1: SRA_R	sra 	%r16, %r2, %r8
        mov 0x9e, %r31
thr3_loop_cnt_11:
	.word 0xf85c2e50  ! 1: LDX_I	ldx	[%r16 + 0x0e50], %r28
	.word 0xdc5c2c08  ! 1: LDX_I	ldx	[%r16 + 0x0c08], %r14
	.word 0xf65c29e0  ! 1: LDX_I	ldx	[%r16 + 0x09e0], %r27
	.word 0xc6142e94  ! 1: LDUH_I	lduh	[%r16 + 0x0e94], %r3
	.word 0xc6dc2468  ! 1: LDXA_I	ldxa	[%r16, + 0x0468] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf4dc2e80  ! 1: LDXA_I	ldxa	[%r16, + 0x0e80] %asi, %r26
	.word 0xf4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r26
	.word 0xe2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r17
	.word 0xd0042d54  ! 1: LDUW_I	lduw	[%r16 + 0x0d54], %r8
	.word 0xc6d42030  ! 1: LDSHA_I	ldsha	[%r16, + 0x0030] %asi, %r3
	.word 0xc6d42404  ! 1: LDSHA_I	ldsha	[%r16, + 0x0404] %asi, %r3
	brnz %r31,thr3_loop_cnt_11
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x8e2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r7
	.word 0x98140002  ! 1: OR_R	or 	%r16, %r2, %r12
        mov 0xbe, %r31
thr3_loop_cnt_12:
	.word 0xf4042174  ! 1: LDUW_I	lduw	[%r16 + 0x0174], %r26
	.word 0xd4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r10
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc26d0  ! 1: LDSBA_I	ldsba	[%r16, + 0x06d0] %asi, %r3
	.word 0xc6942a86  ! 1: LDUHA_I	lduha	[%r16, + 0x0a86] %asi, %r3
	.word 0xf48c2830  ! 1: LDUBA_I	lduba	[%r16, + 0x0830] %asi, %r26
	.word 0xc65c2928  ! 1: LDX_I	ldx	[%r16 + 0x0928], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc60c2c3e  ! 1: LDUB_I	ldub	[%r16 + 0x0c3e], %r3
	brnz %r31,thr3_loop_cnt_12
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x983c27e5  ! 1: XNOR_I	xnor 	%r16, 0x07e5, %r12
        mov 0x7, %r31
thr3_loop_cnt_13:
	.word 0xc64c27c5  ! 1: LDSB_I	ldsb	[%r16 + 0x07c5], %r3
	.word 0xe8dc25c8  ! 1: LDXA_I	ldxa	[%r16, + 0x05c8] %asi, %r20
	.word 0xc6842fe0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0fe0] %asi, %r3
	.word 0xd4d42db8  ! 1: LDSHA_I	ldsha	[%r16, + 0x0db8] %asi, %r10
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc65c2d58  ! 1: LDX_I	ldx	[%r16 + 0x0d58], %r3
	.word 0xc6cc2df3  ! 1: LDSBA_I	ldsba	[%r16, + 0x0df3] %asi, %r3
	.word 0xc6142302  ! 1: LDUH_I	lduh	[%r16 + 0x0302], %r3
	.word 0xc6542150  ! 1: LDSH_I	ldsh	[%r16 + 0x0150], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_13
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x863c2502  ! 1: XNOR_I	xnor 	%r16, 0x0502, %r3
	.word 0x862c2c6d  ! 1: ANDN_I	andn 	%r16, 0x0c6d, %r3
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x6e, %r31
thr3_loop_cnt_14:
	.word 0xc6942f1a  ! 1: LDUHA_I	lduha	[%r16, + 0x0f1a] %asi, %r3
	.word 0xd45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r10
	.word 0xc60c2629  ! 1: LDUB_I	ldub	[%r16 + 0x0629], %r3
	.word 0xc6c428c8  ! 1: LDSWA_I	ldswa	[%r16, + 0x08c8] %asi, %r3
	.word 0xd0c428a0  ! 1: LDSWA_I	ldswa	[%r16, + 0x08a0] %asi, %r8
	.word 0xe6142f02  ! 1: LDUH_I	lduh	[%r16 + 0x0f02], %r19
	.word 0xfa8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r29
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6542ef8  ! 1: LDSH_I	ldsh	[%r16 + 0x0ef8], %r3
	.word 0xc64c2ff7  ! 1: LDSB_I	ldsb	[%r16 + 0x0ff7], %r3
	.word 0xe494284a  ! 1: LDUHA_I	lduha	[%r16, + 0x084a] %asi, %r18
	brnz %r31,thr3_loop_cnt_14
	dec %r31
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x862c270b  ! 1: ANDN_I	andn 	%r16, 0x070b, %r3
        mov 0xc1, %r31
thr3_loop_cnt_15:
	.word 0xc684257c  ! 1: LDUWA_I	lduwa	[%r16, + 0x057c] %asi, %r3
	.word 0xc6dc2a40  ! 1: LDXA_I	ldxa	[%r16, + 0x0a40] %asi, %r3
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	.word 0xc6142218  ! 1: LDUH_I	lduh	[%r16 + 0x0218], %r3
	.word 0xda842c40  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c40] %asi, %r13
	.word 0xe4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r18
	.word 0xc6d4271a  ! 1: LDSHA_I	ldsha	[%r16, + 0x071a] %asi, %r3
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xd2cc2813  ! 1: LDSBA_I	ldsba	[%r16, + 0x0813] %asi, %r9
	.word 0xf84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r28
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_15
	dec %r31
        mov 0x2b, %r31
thr3_loop_cnt_16:
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	.word 0xdac42b4c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b4c] %asi, %r13
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2d89  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d89] %asi, %r3
	.word 0xc68422c4  ! 1: LDUWA_I	lduwa	[%r16, + 0x02c4] %asi, %r3
	.word 0xf8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r28
	.word 0xc6842044  ! 1: LDUWA_I	lduwa	[%r16, + 0x0044] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd8542644  ! 1: LDSH_I	ldsh	[%r16 + 0x0644], %r12
	.word 0xf4cc2af3  ! 1: LDSBA_I	ldsba	[%r16, + 0x0af3] %asi, %r26
	brnz %r31,thr3_loop_cnt_16
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x902429f2  ! 1: SUB_I	sub 	%r16, 0x09f2, %r8
	.word 0x86442948  ! 1: ADDC_I	addc 	%r16, 0x0948, %r3
        mov 0xc6, %r31
thr3_loop_cnt_17:
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc65422fe  ! 1: LDSH_I	ldsh	[%r16 + 0x02fe], %r3
	.word 0xd20c2857  ! 1: LDUB_I	ldub	[%r16 + 0x0857], %r9
	.word 0xc604223c  ! 1: LDUW_I	lduw	[%r16 + 0x023c], %r3
	.word 0xc65c2f78  ! 1: LDX_I	ldx	[%r16 + 0x0f78], %r3
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xda841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r13
	brnz %r31,thr3_loop_cnt_17
	dec %r31
	.word 0x9d340002  ! 1: SRL_R	srl 	%r16, %r2, %r14
        mov 0xc2, %r31
thr3_loop_cnt_18:
	.word 0xf8dc2938  ! 1: LDXA_I	ldxa	[%r16, + 0x0938] %asi, %r28
	.word 0xd0dc2b80  ! 1: LDXA_I	ldxa	[%r16, + 0x0b80] %asi, %r8
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2cf9  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cf9] %asi, %r3
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xc6942b2c  ! 1: LDUHA_I	lduha	[%r16, + 0x0b2c] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6442fd8  ! 1: LDSW_I	ldsw	[%r16 + 0x0fd8], %r3
	.word 0xc60c269c  ! 1: LDUB_I	ldub	[%r16 + 0x069c], %r3
	.word 0xe4cc2313  ! 1: LDSBA_I	ldsba	[%r16, + 0x0313] %asi, %r18
	brnz %r31,thr3_loop_cnt_18
	dec %r31
	.word 0xbd3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r30
	.word 0xbb2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r29
        mov 0xa3, %r31
thr3_loop_cnt_19:
	.word 0xe2542376  ! 1: LDSH_I	ldsh	[%r16 + 0x0376], %r17
	.word 0xc6cc25da  ! 1: LDSBA_I	ldsba	[%r16, + 0x05da] %asi, %r3
	.word 0xeecc22ca  ! 1: LDSBA_I	ldsba	[%r16, + 0x02ca] %asi, %r23
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r26
	.word 0xd0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r8
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xea842630  ! 1: LDUWA_I	lduwa	[%r16, + 0x0630] %asi, %r21
	.word 0xfccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r30
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xd8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r12
	.word 0xc694274c  ! 1: LDUHA_I	lduha	[%r16, + 0x074c] %asi, %r3
	brnz %r31,thr3_loop_cnt_19
	dec %r31
	.word 0xab2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r21
	.word 0x86242432  ! 1: SUB_I	sub 	%r16, 0x0432, %r3
	.word 0xb0340002  ! 1: ORN_R	orn 	%r16, %r2, %r24
        mov 0x85, %r31
thr3_loop_cnt_20:
	.word 0xc6cc235e  ! 1: LDSBA_I	ldsba	[%r16, + 0x035e] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc64c2e0e  ! 1: LDSB_I	ldsb	[%r16 + 0x0e0e], %r3
	.word 0xea140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r21
	.word 0xc6442c68  ! 1: LDSW_I	ldsw	[%r16 + 0x0c68], %r3
	.word 0xc6c426fc  ! 1: LDSWA_I	ldswa	[%r16, + 0x06fc] %asi, %r3
	.word 0xe6dc2bd0  ! 1: LDXA_I	ldxa	[%r16, + 0x0bd0] %asi, %r19
	.word 0xc6842f28  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f28] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xe8c42f74  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f74] %asi, %r20
	.word 0xc6442dc0  ! 1: LDSW_I	ldsw	[%r16 + 0x0dc0], %r3
	brnz %r31,thr3_loop_cnt_20
	dec %r31
	.word 0x973c0002  ! 1: SRA_R	sra 	%r16, %r2, %r11
	.word 0x9f342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r15
	.word 0x8c2429fb  ! 1: SUB_I	sub 	%r16, 0x09fb, %r6
        mov 0xc7, %r31
thr3_loop_cnt_21:
	.word 0xeccc2a33  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a33] %asi, %r22
	.word 0xc64428d4  ! 1: LDSW_I	ldsw	[%r16 + 0x08d4], %r3
	.word 0xc6cc2c5a  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c5a] %asi, %r3
	.word 0xe25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r17
	.word 0xc68c2fc1  ! 1: LDUBA_I	lduba	[%r16, + 0x0fc1] %asi, %r3
	.word 0xc6d42fa2  ! 1: LDSHA_I	ldsha	[%r16, + 0x0fa2] %asi, %r3
	.word 0xec040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r22
	.word 0xc6cc2200  ! 1: LDSBA_I	ldsba	[%r16, + 0x0200] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe6c42ac0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ac0] %asi, %r19
	.word 0xc65c2638  ! 1: LDX_I	ldx	[%r16 + 0x0638], %r3
	.word 0xe20c20f0  ! 1: LDUB_I	ldub	[%r16 + 0x00f0], %r17
	brnz %r31,thr3_loop_cnt_21
	dec %r31
	.word 0x86342aa5  ! 1: SUBC_I	orn 	%r16, 0x0aa5, %r3
	.word 0xaf343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r23
	.word 0xb3343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r25
	.word 0x8e3c20af  ! 1: XNOR_I	xnor 	%r16, 0x00af, %r7
        mov 0x2f, %r31
thr3_loop_cnt_22:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xee8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r23
	.word 0xcc8c2cad  ! 1: LDUBA_I	lduba	[%r16, + 0x0cad] %asi, %r6
	.word 0xe2cc2062  ! 1: LDSBA_I	ldsba	[%r16, + 0x0062] %asi, %r17
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6942734  ! 1: LDUHA_I	lduha	[%r16, + 0x0734] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xec440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r22
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_22
	dec %r31
	.word 0x861c275d  ! 1: XOR_I	xor 	%r16, 0x075d, %r3
	.word 0x933c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r9
	.word 0x9c240002  ! 1: SUB_R	sub 	%r16, %r2, %r14
	.word 0x86242052  ! 1: SUB_I	sub 	%r16, 0x0052, %r3
        mov 0xc, %r31
thr3_loop_cnt_23:
	.word 0xdcd42730  ! 1: LDSHA_I	ldsha	[%r16, + 0x0730] %asi, %r14
	.word 0xd25423ec  ! 1: LDSH_I	ldsh	[%r16 + 0x03ec], %r9
	.word 0xd8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r12
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc65c2e90  ! 1: LDX_I	ldx	[%r16 + 0x0e90], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc22c8  ! 1: LDSBA_I	ldsba	[%r16, + 0x02c8] %asi, %r3
	.word 0xc6142ffe  ! 1: LDUH_I	lduh	[%r16 + 0x0ffe], %r3
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xfa442cf8  ! 1: LDSW_I	ldsw	[%r16 + 0x0cf8], %r29
	.word 0xc6842034  ! 1: LDUWA_I	lduwa	[%r16, + 0x0034] %asi, %r3
	.word 0xd4542300  ! 1: LDSH_I	ldsh	[%r16 + 0x0300], %r10
	brnz %r31,thr3_loop_cnt_23
	dec %r31
        mov 0x6c, %r31
thr3_loop_cnt_24:
	.word 0xd0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r8
	.word 0xf48c2245  ! 1: LDUBA_I	lduba	[%r16, + 0x0245] %asi, %r26
	.word 0xc68c2887  ! 1: LDUBA_I	lduba	[%r16, + 0x0887] %asi, %r3
	.word 0xc64c2235  ! 1: LDSB_I	ldsb	[%r16 + 0x0235], %r3
	.word 0xf64c2e10  ! 1: LDSB_I	ldsb	[%r16 + 0x0e10], %r27
	.word 0xf84425f8  ! 1: LDSW_I	ldsw	[%r16 + 0x05f8], %r28
	.word 0xfa142d1c  ! 1: LDUH_I	lduh	[%r16 + 0x0d1c], %r29
	.word 0xce4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r7
	.word 0xc6dc2140  ! 1: LDXA_I	ldxa	[%r16, + 0x0140] %asi, %r3
	.word 0xc61425ee  ! 1: LDUH_I	lduh	[%r16 + 0x05ee], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_24
	dec %r31
        mov 0x94, %r31
thr3_loop_cnt_25:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2980  ! 1: LDXA_I	ldxa	[%r16, + 0x0980] %asi, %r3
	.word 0xc61420a8  ! 1: LDUH_I	lduh	[%r16 + 0x00a8], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc64c2ee1  ! 1: LDSB_I	ldsb	[%r16 + 0x0ee1], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xe8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r20
	.word 0xf4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r26
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_25
	dec %r31
        mov 0x17, %r31
thr3_loop_cnt_26:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc64c2841  ! 1: LDSB_I	ldsb	[%r16 + 0x0841], %r3
	.word 0xe85c21c0  ! 1: LDX_I	ldx	[%r16 + 0x01c0], %r20
	.word 0xdcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r14
	.word 0xf4dc2138  ! 1: LDXA_I	ldxa	[%r16, + 0x0138] %asi, %r26
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc60425a8  ! 1: LDUW_I	lduw	[%r16 + 0x05a8], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6442478  ! 1: LDSW_I	ldsw	[%r16 + 0x0478], %r3
	.word 0xf65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r27
	brnz %r31,thr3_loop_cnt_26
	dec %r31
	.word 0x86442c62  ! 1: ADDC_I	addc 	%r16, 0x0c62, %r3
	.word 0x86042c93  ! 1: ADD_I	add 	%r16, 0x0c93, %r3
        mov 0x6d, %r31
thr3_loop_cnt_27:
	.word 0xf8dc2680  ! 1: LDXA_I	ldxa	[%r16, + 0x0680] %asi, %r28
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xf8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r28
	.word 0xd25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r9
	.word 0xc6d4282a  ! 1: LDSHA_I	ldsha	[%r16, + 0x082a] %asi, %r3
	.word 0xf25429ca  ! 1: LDSH_I	ldsh	[%r16 + 0x09ca], %r25
	.word 0xde4c29ef  ! 1: LDSB_I	ldsb	[%r16 + 0x09ef], %r15
	.word 0xc6942602  ! 1: LDUHA_I	lduha	[%r16, + 0x0602] %asi, %r3
	.word 0xd8d4217c  ! 1: LDSHA_I	ldsha	[%r16, + 0x017c] %asi, %r12
	.word 0xc6142530  ! 1: LDUH_I	lduh	[%r16 + 0x0530], %r3
	brnz %r31,thr3_loop_cnt_27
	dec %r31
	.word 0xa72c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r19
        mov 0xaf, %r31
thr3_loop_cnt_28:
	.word 0xe4842cac  ! 1: LDUWA_I	lduwa	[%r16, + 0x0cac] %asi, %r18
	.word 0xc6042c9c  ! 1: LDUW_I	lduw	[%r16 + 0x0c9c], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d42c98  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c98] %asi, %r3
	.word 0xf8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r28
	.word 0xda4c21fa  ! 1: LDSB_I	ldsb	[%r16 + 0x01fa], %r13
	.word 0xd28c2af3  ! 1: LDUBA_I	lduba	[%r16, + 0x0af3] %asi, %r9
	.word 0xc65c2430  ! 1: LDX_I	ldx	[%r16 + 0x0430], %r3
	.word 0xe8542da8  ! 1: LDSH_I	ldsh	[%r16 + 0x0da8], %r20
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_28
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x9c3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r14
        mov 0x13, %r31
thr3_loop_cnt_29:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xcccc23a4  ! 1: LDSBA_I	ldsba	[%r16, + 0x03a4] %asi, %r6
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6942354  ! 1: LDUHA_I	lduha	[%r16, + 0x0354] %asi, %r3
	.word 0xc6cc2d73  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d73] %asi, %r3
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	.word 0xdc0c2cdd  ! 1: LDUB_I	ldub	[%r16 + 0x0cdd], %r14
	.word 0xc65425b6  ! 1: LDSH_I	ldsh	[%r16 + 0x05b6], %r3
	brnz %r31,thr3_loop_cnt_29
	dec %r31
	.word 0x8644283c  ! 1: ADDC_I	addc 	%r16, 0x083c, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0xba, %r31
thr3_loop_cnt_30:
	.word 0xc6dc2a30  ! 1: LDXA_I	ldxa	[%r16, + 0x0a30] %asi, %r3
	.word 0xc65c2930  ! 1: LDX_I	ldx	[%r16 + 0x0930], %r3
	.word 0xc68425f4  ! 1: LDUWA_I	lduwa	[%r16, + 0x05f4] %asi, %r3
	.word 0xc6cc204c  ! 1: LDSBA_I	ldsba	[%r16, + 0x004c] %asi, %r3
	.word 0xe44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r18
	.word 0xc6042f88  ! 1: LDUW_I	lduw	[%r16 + 0x0f88], %r3
	.word 0xd20c2ad2  ! 1: LDUB_I	ldub	[%r16 + 0x0ad2], %r9
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_30
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x8c242bce  ! 1: SUB_I	sub 	%r16, 0x0bce, %r6
	.word 0x92340002  ! 1: SUBC_R	orn 	%r16, %r2, %r9
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x50, %r31
thr3_loop_cnt_31:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe24c2298  ! 1: LDSB_I	ldsb	[%r16 + 0x0298], %r17
	.word 0xda841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r13
	.word 0xfcd42e36  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e36] %asi, %r30
	.word 0xd45427a4  ! 1: LDSH_I	ldsh	[%r16 + 0x07a4], %r10
	.word 0xeccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r22
	.word 0xc644205c  ! 1: LDSW_I	ldsw	[%r16 + 0x005c], %r3
	.word 0xe68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r19
	.word 0xc6142fcc  ! 1: LDUH_I	lduh	[%r16 + 0x0fcc], %r3
	.word 0xe8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r20
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r20
	brnz %r31,thr3_loop_cnt_31
	dec %r31
	.word 0x86342f0c  ! 1: SUBC_I	orn 	%r16, 0x0f0c, %r3
	.word 0xa83c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r20
	.word 0x9b2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r13
	.word 0x863c298d  ! 1: XNOR_I	xnor 	%r16, 0x098d, %r3
        mov 0x0, %r31
thr3_loop_cnt_32:
	.word 0xc6542ee6  ! 1: LDSH_I	ldsh	[%r16 + 0x0ee6], %r3
	.word 0xfc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r30
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r19
	.word 0xdedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r15
	.word 0xc6442118  ! 1: LDSW_I	ldsw	[%r16 + 0x0118], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xdecc2f64  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f64] %asi, %r15
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe88c272d  ! 1: LDUBA_I	lduba	[%r16, + 0x072d] %asi, %r20
	brnz %r31,thr3_loop_cnt_32
	dec %r31
	.word 0xa84425fd  ! 1: ADDC_I	addc 	%r16, 0x05fd, %r20
        mov 0x9f, %r31
thr3_loop_cnt_33:
	.word 0xe8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r20
	.word 0xc6942682  ! 1: LDUHA_I	lduha	[%r16, + 0x0682] %asi, %r3
	.word 0xda0c2a36  ! 1: LDUB_I	ldub	[%r16 + 0x0a36], %r13
	.word 0xc6d42ba0  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ba0] %asi, %r3
	.word 0xcc4c277c  ! 1: LDSB_I	ldsb	[%r16 + 0x077c], %r6
	.word 0xe8042de8  ! 1: LDUW_I	lduw	[%r16 + 0x0de8], %r20
	.word 0xc6542c20  ! 1: LDSH_I	ldsh	[%r16 + 0x0c20], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r17
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xd4042a34  ! 1: LDUW_I	lduw	[%r16 + 0x0a34], %r10
	brnz %r31,thr3_loop_cnt_33
	dec %r31
	.word 0x860c225d  ! 1: AND_I	and 	%r16, 0x025d, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0x11, %r31
thr3_loop_cnt_34:
	.word 0xc60c275c  ! 1: LDUB_I	ldub	[%r16 + 0x075c], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6c42f64  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f64] %asi, %r3
	.word 0xc60429d0  ! 1: LDUW_I	lduw	[%r16 + 0x09d0], %r3
	.word 0xdc8425fc  ! 1: LDUWA_I	lduwa	[%r16, + 0x05fc] %asi, %r14
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xd0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r8
	brnz %r31,thr3_loop_cnt_34
	dec %r31
	.word 0x972c0002  ! 1: SLL_R	sll 	%r16, %r2, %r11
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0xe, %r31
thr3_loop_cnt_35:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe20c24ea  ! 1: LDUB_I	ldub	[%r16 + 0x04ea], %r17
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6542186  ! 1: LDSH_I	ldsh	[%r16 + 0x0186], %r3
	.word 0xd8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r12
	.word 0xce8c27f6  ! 1: LDUBA_I	lduba	[%r16, + 0x07f6] %asi, %r7
	.word 0xce542b80  ! 1: LDSH_I	ldsh	[%r16 + 0x0b80], %r7
	.word 0xc6d428fc  ! 1: LDSHA_I	ldsha	[%r16, + 0x08fc] %asi, %r3
	brnz %r31,thr3_loop_cnt_35
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x9f343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r15
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x96, %r31
thr3_loop_cnt_36:
	.word 0xe20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r17
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6842a84  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a84] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe45c2dc0  ! 1: LDX_I	ldx	[%r16 + 0x0dc0], %r18
	.word 0xd2c4298c  ! 1: LDSWA_I	ldswa	[%r16, + 0x098c] %asi, %r9
	.word 0xf4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r26
	.word 0xc65423ea  ! 1: LDSH_I	ldsh	[%r16 + 0x03ea], %r3
	.word 0xc6042eec  ! 1: LDUW_I	lduw	[%r16 + 0x0eec], %r3
	brnz %r31,thr3_loop_cnt_36
	dec %r31
	.word 0xaa3c25d3  ! 1: XNOR_I	xnor 	%r16, 0x05d3, %r21
	.word 0x8f340002  ! 1: SRL_R	srl 	%r16, %r2, %r7
        mov 0xb2, %r31
thr3_loop_cnt_37:
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf4142d42  ! 1: LDUH_I	lduh	[%r16 + 0x0d42], %r26
	.word 0xc6942b4c  ! 1: LDUHA_I	lduha	[%r16, + 0x0b4c] %asi, %r3
	.word 0xdadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r13
	.word 0xe4cc285b  ! 1: LDSBA_I	ldsba	[%r16, + 0x085b] %asi, %r18
	.word 0xd88c2a06  ! 1: LDUBA_I	lduba	[%r16, + 0x0a06] %asi, %r12
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6cc28b0  ! 1: LDSBA_I	ldsba	[%r16, + 0x08b0] %asi, %r3
	brnz %r31,thr3_loop_cnt_37
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x9d2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r14
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0xb83c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r28
        mov 0x49, %r31
thr3_loop_cnt_38:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6842f18  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f18] %asi, %r3
	.word 0xe24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r17
	.word 0xc6942bb4  ! 1: LDUHA_I	lduha	[%r16, + 0x0bb4] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc614266c  ! 1: LDUH_I	lduh	[%r16 + 0x066c], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_38
	dec %r31
        mov 0x0, %r31
thr3_loop_cnt_39:
	.word 0xcedc2b68  ! 1: LDXA_I	ldxa	[%r16, + 0x0b68] %asi, %r7
	.word 0xc6cc238e  ! 1: LDSBA_I	ldsba	[%r16, + 0x038e] %asi, %r3
	.word 0xc694239e  ! 1: LDUHA_I	lduha	[%r16, + 0x039e] %asi, %r3
	.word 0xe88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r20
	.word 0xf08c25f3  ! 1: LDUBA_I	lduba	[%r16, + 0x05f3] %asi, %r24
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf25c2380  ! 1: LDX_I	ldx	[%r16 + 0x0380], %r25
	.word 0xfc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r30
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_39
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x6a, %r31
thr3_loop_cnt_40:
	.word 0xc68422a4  ! 1: LDUWA_I	lduwa	[%r16, + 0x02a4] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xdc942f48  ! 1: LDUHA_I	lduha	[%r16, + 0x0f48] %asi, %r14
	.word 0xf2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r25
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe8042624  ! 1: LDUW_I	lduw	[%r16 + 0x0624], %r20
	.word 0xcc54288c  ! 1: LDSH_I	ldsh	[%r16 + 0x088c], %r6
	.word 0xce5c2248  ! 1: LDX_I	ldx	[%r16 + 0x0248], %r7
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_40
	dec %r31
	.word 0x8c1c2fc0  ! 1: XOR_I	xor 	%r16, 0x0fc0, %r6
	.word 0x8e340002  ! 1: ORN_R	orn 	%r16, %r2, %r7
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x4c, %r31
thr3_loop_cnt_41:
	.word 0xfa941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r29
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf64c2a00  ! 1: LDSB_I	ldsb	[%r16 + 0x0a00], %r27
	.word 0xd8542300  ! 1: LDSH_I	ldsh	[%r16 + 0x0300], %r12
	.word 0xc64c23e9  ! 1: LDSB_I	ldsb	[%r16 + 0x03e9], %r3
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf2d42f3a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f3a] %asi, %r25
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_41
	dec %r31
        mov 0x2c, %r31
thr3_loop_cnt_42:
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r19
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xdad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r13
	.word 0xc68c2690  ! 1: LDUBA_I	lduba	[%r16, + 0x0690] %asi, %r3
	.word 0xf2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r25
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r20
	brnz %r31,thr3_loop_cnt_42
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0xc4, %r31
thr3_loop_cnt_43:
	.word 0xd6dc2a78  ! 1: LDXA_I	ldxa	[%r16, + 0x0a78] %asi, %r11
	.word 0xc64c259d  ! 1: LDSB_I	ldsb	[%r16 + 0x059d], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd65c2e98  ! 1: LDX_I	ldx	[%r16 + 0x0e98], %r11
	.word 0xc68c2dbf  ! 1: LDUBA_I	lduba	[%r16, + 0x0dbf] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6442424  ! 1: LDSW_I	ldsw	[%r16 + 0x0424], %r3
	.word 0xe64c25c2  ! 1: LDSB_I	ldsb	[%r16 + 0x05c2], %r19
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xcccc2a9f  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a9f] %asi, %r6
	.word 0xf0842dbc  ! 1: LDUWA_I	lduwa	[%r16, + 0x0dbc] %asi, %r24
	brnz %r31,thr3_loop_cnt_43
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0xb5, %r31
thr3_loop_cnt_44:
	.word 0xd05c2b78  ! 1: LDX_I	ldx	[%r16 + 0x0b78], %r8
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r18
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r20
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd4c42738  ! 1: LDSWA_I	ldswa	[%r16, + 0x0738] %asi, %r10
	.word 0xc6c42d78  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d78] %asi, %r3
	.word 0xda0c2d24  ! 1: LDUB_I	ldub	[%r16 + 0x0d24], %r13
	brnz %r31,thr3_loop_cnt_44
	dec %r31
	.word 0x98440002  ! 1: ADDC_R	addc 	%r16, %r2, %r12
	.word 0x9f3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r15
	.word 0x96040002  ! 1: ADD_R	add 	%r16, %r2, %r11
	.word 0xbb2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r29
        mov 0xb3, %r31
thr3_loop_cnt_45:
	.word 0xc68428d8  ! 1: LDUWA_I	lduwa	[%r16, + 0x08d8] %asi, %r3
	.word 0xc6d4219c  ! 1: LDSHA_I	ldsha	[%r16, + 0x019c] %asi, %r3
	.word 0xea140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r21
	.word 0xd8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r12
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc65c2ab8  ! 1: LDX_I	ldx	[%r16 + 0x0ab8], %r3
	.word 0xc6942f2c  ! 1: LDUHA_I	lduha	[%r16, + 0x0f2c] %asi, %r3
	.word 0xc69422a6  ! 1: LDUHA_I	lduha	[%r16, + 0x02a6] %asi, %r3
	brnz %r31,thr3_loop_cnt_45
	dec %r31
	.word 0x86042005  ! 1: ADD_I	add 	%r16, 0x0005, %r3
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x860c2a9a  ! 1: AND_I	and 	%r16, 0x0a9a, %r3
        mov 0x74, %r31
thr3_loop_cnt_46:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r20
	.word 0xf64c2969  ! 1: LDSB_I	ldsb	[%r16 + 0x0969], %r27
	.word 0xf08c2883  ! 1: LDUBA_I	lduba	[%r16, + 0x0883] %asi, %r24
	.word 0xfc44260c  ! 1: LDSW_I	ldsw	[%r16 + 0x060c], %r30
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	brnz %r31,thr3_loop_cnt_46
	dec %r31
        mov 0x7, %r31
thr3_loop_cnt_47:
	.word 0xf45c2c30  ! 1: LDX_I	ldx	[%r16 + 0x0c30], %r26
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xce1421c0  ! 1: LDUH_I	lduh	[%r16 + 0x01c0], %r7
	.word 0xc6c42a84  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a84] %asi, %r3
	.word 0xdc1423c6  ! 1: LDUH_I	lduh	[%r16 + 0x03c6], %r14
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf4542314  ! 1: LDSH_I	ldsh	[%r16 + 0x0314], %r26
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xe84c20a3  ! 1: LDSB_I	ldsb	[%r16 + 0x00a3], %r20
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_47
	dec %r31
	.word 0x9d3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r14
	.word 0xb00c2a14  ! 1: AND_I	and 	%r16, 0x0a14, %r24
	.word 0xa92c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r20
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0xa3, %r31
thr3_loop_cnt_48:
	.word 0xe2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r17
	.word 0xe25c2fa8  ! 1: LDX_I	ldx	[%r16 + 0x0fa8], %r17
	.word 0xce042368  ! 1: LDUW_I	lduw	[%r16 + 0x0368], %r7
	.word 0xf4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r26
	.word 0xc68c21ce  ! 1: LDUBA_I	lduba	[%r16, + 0x01ce] %asi, %r3
	.word 0xda842c04  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c04] %asi, %r13
	.word 0xecc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r22
	.word 0xc65c2780  ! 1: LDX_I	ldx	[%r16 + 0x0780], %r3
	.word 0xce5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r7
	brnz %r31,thr3_loop_cnt_48
	dec %r31
	.word 0x97340002  ! 1: SRL_R	srl 	%r16, %r2, %r11
	.word 0xb60c0002  ! 1: AND_R	and 	%r16, %r2, %r27
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0x84, %r31
thr3_loop_cnt_49:
	.word 0xdc942f10  ! 1: LDUHA_I	lduha	[%r16, + 0x0f10] %asi, %r14
	.word 0xc60421ac  ! 1: LDUW_I	lduw	[%r16 + 0x01ac], %r3
	.word 0xdc942a06  ! 1: LDUHA_I	lduha	[%r16, + 0x0a06] %asi, %r14
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	.word 0xe2d42d5e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d5e] %asi, %r17
	.word 0xc6942a5a  ! 1: LDUHA_I	lduha	[%r16, + 0x0a5a] %asi, %r3
	.word 0xfa0c2eba  ! 1: LDUB_I	ldub	[%r16 + 0x0eba], %r29
	.word 0xc6442984  ! 1: LDSW_I	ldsw	[%r16 + 0x0984], %r3
	.word 0xde4427f8  ! 1: LDSW_I	ldsw	[%r16 + 0x07f8], %r15
	.word 0xc6c420fc  ! 1: LDSWA_I	ldswa	[%r16, + 0x00fc] %asi, %r3
	.word 0xdc4c2346  ! 1: LDSB_I	ldsb	[%r16 + 0x0346], %r14
	brnz %r31,thr3_loop_cnt_49
	dec %r31
	.word 0x99341002  ! 1: SRLX_R	srlx	%r16, %r2, %r12
        mov 0x5e, %r31
thr3_loop_cnt_50:
	.word 0xc644242c  ! 1: LDSW_I	ldsw	[%r16 + 0x042c], %r3
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	.word 0xe8442d64  ! 1: LDSW_I	ldsw	[%r16 + 0x0d64], %r20
	.word 0xead420c2  ! 1: LDSHA_I	ldsha	[%r16, + 0x00c2] %asi, %r21
	.word 0xec0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r22
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd40c2847  ! 1: LDUB_I	ldub	[%r16 + 0x0847], %r10
	.word 0xf8c4289c  ! 1: LDSWA_I	ldswa	[%r16, + 0x089c] %asi, %r28
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_50
	dec %r31
	.word 0x8f340002  ! 1: SRL_R	srl 	%r16, %r2, %r7
	.word 0xaf342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r23
	.word 0x94342a9b  ! 1: ORN_I	orn 	%r16, 0x0a9b, %r10
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0x7b, %r31
thr3_loop_cnt_51:
	.word 0xde0420f0  ! 1: LDUW_I	lduw	[%r16 + 0x00f0], %r15
	.word 0xc6cc2075  ! 1: LDSBA_I	ldsba	[%r16, + 0x0075] %asi, %r3
	.word 0xc6942a6e  ! 1: LDUHA_I	lduha	[%r16, + 0x0a6e] %asi, %r3
	.word 0xdc542b46  ! 1: LDSH_I	ldsh	[%r16 + 0x0b46], %r14
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xec5c2308  ! 1: LDX_I	ldx	[%r16 + 0x0308], %r22
	.word 0xcc5c2258  ! 1: LDX_I	ldx	[%r16 + 0x0258], %r6
	.word 0xc6942174  ! 1: LDUHA_I	lduha	[%r16, + 0x0174] %asi, %r3
	brnz %r31,thr3_loop_cnt_51
	dec %r31
        mov 0xa9, %r31
thr3_loop_cnt_52:
	.word 0xec140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r22
	.word 0xf4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r26
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xda5c20d0  ! 1: LDX_I	ldx	[%r16 + 0x00d0], %r13
	.word 0xdc542ee0  ! 1: LDSH_I	ldsh	[%r16 + 0x0ee0], %r14
	.word 0xced41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r7
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c253a  ! 1: LDSB_I	ldsb	[%r16 + 0x053a], %r3
	.word 0xd4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r10
	.word 0xc69421e8  ! 1: LDUHA_I	lduha	[%r16, + 0x01e8] %asi, %r3
	.word 0xc64c25d2  ! 1: LDSB_I	ldsb	[%r16 + 0x05d2], %r3
	brnz %r31,thr3_loop_cnt_52
	dec %r31
        mov 0x79, %r31
thr3_loop_cnt_53:
	.word 0xeac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r21
	.word 0xc65c2088  ! 1: LDX_I	ldx	[%r16 + 0x0088], %r3
	.word 0xc6142fe4  ! 1: LDUH_I	lduh	[%r16 + 0x0fe4], %r3
	.word 0xe40c2a9c  ! 1: LDUB_I	ldub	[%r16 + 0x0a9c], %r18
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf2042b90  ! 1: LDUW_I	lduw	[%r16 + 0x0b90], %r25
	.word 0xdacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r13
	.word 0xe8cc258c  ! 1: LDSBA_I	ldsba	[%r16, + 0x058c] %asi, %r20
	brnz %r31,thr3_loop_cnt_53
	dec %r31
	.word 0x98140002  ! 1: OR_R	or 	%r16, %r2, %r12
	.word 0xb0142ebb  ! 1: OR_I	or 	%r16, 0x0ebb, %r24
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x58, %r31
thr3_loop_cnt_54:
	.word 0xea0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r21
	.word 0xf6942908  ! 1: LDUHA_I	lduha	[%r16, + 0x0908] %asi, %r27
	.word 0xd2cc23c1  ! 1: LDSBA_I	ldsba	[%r16, + 0x03c1] %asi, %r9
	.word 0xc6542748  ! 1: LDSH_I	ldsh	[%r16 + 0x0748], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r18
	.word 0xc60c2ea9  ! 1: LDUB_I	ldub	[%r16 + 0x0ea9], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r20
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_54
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x8634209c  ! 1: SUBC_I	orn 	%r16, 0x009c, %r3
	.word 0xa62c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r19
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0x40, %r31
thr3_loop_cnt_55:
	.word 0xf0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r24
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6d4230c  ! 1: LDSHA_I	ldsha	[%r16, + 0x030c] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6d423f0  ! 1: LDSHA_I	ldsha	[%r16, + 0x03f0] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xda540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r13
	brnz %r31,thr3_loop_cnt_55
	dec %r31
	.word 0x901c0002  ! 1: XOR_R	xor 	%r16, %r2, %r8
	.word 0x862c2a25  ! 1: ANDN_I	andn 	%r16, 0x0a25, %r3
	.word 0x86142a52  ! 1: OR_I	or 	%r16, 0x0a52, %r3
        mov 0x74, %r31
thr3_loop_cnt_56:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc68c292d  ! 1: LDUBA_I	lduba	[%r16, + 0x092d] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf04c2aa9  ! 1: LDSB_I	ldsb	[%r16 + 0x0aa9], %r24
	.word 0xc6d42a5c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a5c] %asi, %r3
	.word 0xc6c42c88  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c88] %asi, %r3
	brnz %r31,thr3_loop_cnt_56
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0xb6340002  ! 1: SUBC_R	orn 	%r16, %r2, %r27
	.word 0x9c3c2521  ! 1: XNOR_I	xnor 	%r16, 0x0521, %r14
        mov 0x69, %r31
thr3_loop_cnt_57:
	.word 0xee5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r23
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r19
	.word 0xf8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r28
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xfa94240c  ! 1: LDUHA_I	lduha	[%r16, + 0x040c] %asi, %r29
	.word 0xc6542952  ! 1: LDSH_I	ldsh	[%r16 + 0x0952], %r3
	.word 0xcecc2b36  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b36] %asi, %r7
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xe2842a48  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a48] %asi, %r17
	.word 0xded42c96  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c96] %asi, %r15
	.word 0xe45c2c20  ! 1: LDX_I	ldx	[%r16 + 0x0c20], %r18
	brnz %r31,thr3_loop_cnt_57
	dec %r31
	.word 0x973c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r11
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0x90, %r31
thr3_loop_cnt_58:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xc68421e4  ! 1: LDUWA_I	lduwa	[%r16, + 0x01e4] %asi, %r3
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xfa5c2700  ! 1: LDX_I	ldx	[%r16 + 0x0700], %r29
	.word 0xe45c2800  ! 1: LDX_I	ldx	[%r16 + 0x0800], %r18
	.word 0xc644281c  ! 1: LDSW_I	ldsw	[%r16 + 0x081c], %r3
	.word 0xc68428fc  ! 1: LDUWA_I	lduwa	[%r16, + 0x08fc] %asi, %r3
	brnz %r31,thr3_loop_cnt_58
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x45, %r31
thr3_loop_cnt_59:
	.word 0xf2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r25
	.word 0xded42308  ! 1: LDSHA_I	ldsha	[%r16, + 0x0308] %asi, %r15
	.word 0xeecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r23
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6c42268  ! 1: LDSWA_I	ldswa	[%r16, + 0x0268] %asi, %r3
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xf0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r24
	.word 0xc6c42bf0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0bf0] %asi, %r3
	.word 0xc6c42fc0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0fc0] %asi, %r3
	.word 0xf65425d4  ! 1: LDSH_I	ldsh	[%r16 + 0x05d4], %r27
	.word 0xf0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r24
	brnz %r31,thr3_loop_cnt_59
	dec %r31
	.word 0x8e4424e2  ! 1: ADDC_I	addc 	%r16, 0x04e2, %r7
	.word 0x8e3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r7
	.word 0x862c2e71  ! 1: ANDN_I	andn 	%r16, 0x0e71, %r3
        mov 0x61, %r31
thr3_loop_cnt_60:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r24
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	.word 0xf6dc2160  ! 1: LDXA_I	ldxa	[%r16, + 0x0160] %asi, %r27
	.word 0xcc142f86  ! 1: LDUH_I	lduh	[%r16 + 0x0f86], %r6
	.word 0xc65c23c8  ! 1: LDX_I	ldx	[%r16 + 0x03c8], %r3
	.word 0xc60c2dab  ! 1: LDUB_I	ldub	[%r16 + 0x0dab], %r3
	.word 0xcecc2c96  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c96] %asi, %r7
	.word 0xe2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r17
	brnz %r31,thr3_loop_cnt_60
	dec %r31
        mov 0xc1, %r31
thr3_loop_cnt_61:
	.word 0xee5c2ae8  ! 1: LDX_I	ldx	[%r16 + 0x0ae8], %r23
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc68c2c8d  ! 1: LDUBA_I	lduba	[%r16, + 0x0c8d] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xdec42984  ! 1: LDSWA_I	ldswa	[%r16, + 0x0984] %asi, %r15
	.word 0xf2dc2d60  ! 1: LDXA_I	ldxa	[%r16, + 0x0d60] %asi, %r25
	.word 0xc65c2140  ! 1: LDX_I	ldx	[%r16 + 0x0140], %r3
	.word 0xe44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r18
	brnz %r31,thr3_loop_cnt_61
	dec %r31
	.word 0x9d340002  ! 1: SRL_R	srl 	%r16, %r2, %r14
	.word 0x863c21f0  ! 1: XNOR_I	xnor 	%r16, 0x01f0, %r3
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x2b, %r31
thr3_loop_cnt_62:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xdac42110  ! 1: LDSWA_I	ldswa	[%r16, + 0x0110] %asi, %r13
	.word 0xc6d42670  ! 1: LDSHA_I	ldsha	[%r16, + 0x0670] %asi, %r3
	.word 0xcccc2971  ! 1: LDSBA_I	ldsba	[%r16, + 0x0971] %asi, %r6
	.word 0xf88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r28
	.word 0xce941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r7
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf6dc2018  ! 1: LDXA_I	ldxa	[%r16, + 0x0018] %asi, %r27
	.word 0xe2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r17
	.word 0xc60421e4  ! 1: LDUW_I	lduw	[%r16 + 0x01e4], %r3
	.word 0xc6dc2128  ! 1: LDXA_I	ldxa	[%r16, + 0x0128] %asi, %r3
	brnz %r31,thr3_loop_cnt_62
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x8c3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r6
        mov 0x41, %r31
thr3_loop_cnt_63:
	.word 0xc6542030  ! 1: LDSH_I	ldsh	[%r16 + 0x0030], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xce8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r7
	.word 0xccd428aa  ! 1: LDSHA_I	ldsha	[%r16, + 0x08aa] %asi, %r6
	.word 0xdecc25a7  ! 1: LDSBA_I	ldsba	[%r16, + 0x05a7] %asi, %r15
	.word 0xc6042e68  ! 1: LDUW_I	lduw	[%r16 + 0x0e68], %r3
	.word 0xd8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r12
	.word 0xde0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r15
	.word 0xccdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r6
	.word 0xc6cc265c  ! 1: LDSBA_I	ldsba	[%r16, + 0x065c] %asi, %r3
	.word 0xf8cc2a94  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a94] %asi, %r28
	.word 0xc6142a3e  ! 1: LDUH_I	lduh	[%r16 + 0x0a3e], %r3
	brnz %r31,thr3_loop_cnt_63
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x9614268e  ! 1: OR_I	or 	%r16, 0x068e, %r11
        mov 0x38, %r31
thr3_loop_cnt_64:
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	.word 0xd2dc23f0  ! 1: LDXA_I	ldxa	[%r16, + 0x03f0] %asi, %r9
	.word 0xd44c2bbb  ! 1: LDSB_I	ldsb	[%r16 + 0x0bbb], %r10
	.word 0xfa942620  ! 1: LDUHA_I	lduha	[%r16, + 0x0620] %asi, %r29
	.word 0xc6842d14  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d14] %asi, %r3
	.word 0xd4dc2c58  ! 1: LDXA_I	ldxa	[%r16, + 0x0c58] %asi, %r10
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r27
	.word 0xc6142a0e  ! 1: LDUH_I	lduh	[%r16 + 0x0a0e], %r3
	brnz %r31,thr3_loop_cnt_64
	dec %r31
	.word 0x860428a4  ! 1: ADD_I	add 	%r16, 0x08a4, %r3
        mov 0x12, %r31
thr3_loop_cnt_65:
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xf2842ff8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ff8] %asi, %r25
	.word 0xe4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r18
	.word 0xc60c209e  ! 1: LDUB_I	ldub	[%r16 + 0x009e], %r3
	.word 0xc64c2faa  ! 1: LDSB_I	ldsb	[%r16 + 0x0faa], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xce8c2f9f  ! 1: LDUBA_I	lduba	[%r16, + 0x0f9f] %asi, %r7
	.word 0xc68426f8  ! 1: LDUWA_I	lduwa	[%r16, + 0x06f8] %asi, %r3
	.word 0xc64c29a7  ! 1: LDSB_I	ldsb	[%r16 + 0x09a7], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_65
	dec %r31
	.word 0x860c2ce0  ! 1: AND_I	and 	%r16, 0x0ce0, %r3
	.word 0xa4342ded  ! 1: ORN_I	orn 	%r16, 0x0ded, %r18
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0x3f, %r31
thr3_loop_cnt_66:
	.word 0xee140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r23
	.word 0xc6142b7e  ! 1: LDUH_I	lduh	[%r16 + 0x0b7e], %r3
	.word 0xc6942d1e  ! 1: LDUHA_I	lduha	[%r16, + 0x0d1e] %asi, %r3
	.word 0xeed41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r23
	.word 0xe20428c8  ! 1: LDUW_I	lduw	[%r16 + 0x08c8], %r17
	.word 0xc6042ca4  ! 1: LDUW_I	lduw	[%r16 + 0x0ca4], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	brnz %r31,thr3_loop_cnt_66
	dec %r31
        mov 0xa7, %r31
thr3_loop_cnt_67:
	.word 0xec4c2448  ! 1: LDSB_I	ldsb	[%r16 + 0x0448], %r22
	.word 0xc6c42478  ! 1: LDSWA_I	ldswa	[%r16, + 0x0478] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6542b4c  ! 1: LDSH_I	ldsh	[%r16 + 0x0b4c], %r3
	.word 0xd2cc211f  ! 1: LDSBA_I	ldsba	[%r16, + 0x011f] %asi, %r9
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	.word 0xd8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r12
	.word 0xea44218c  ! 1: LDSW_I	ldsw	[%r16 + 0x018c], %r21
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_67
	dec %r31
        mov 0x96, %r31
thr3_loop_cnt_68:
	.word 0xd2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r9
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r25
	.word 0xd2942160  ! 1: LDUHA_I	lduha	[%r16, + 0x0160] %asi, %r9
	.word 0xc6442b68  ! 1: LDSW_I	ldsw	[%r16 + 0x0b68], %r3
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	.word 0xda4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r13
	.word 0xc6dc28e8  ! 1: LDXA_I	ldxa	[%r16, + 0x08e8] %asi, %r3
	.word 0xc6942482  ! 1: LDUHA_I	lduha	[%r16, + 0x0482] %asi, %r3
	.word 0xcedc2958  ! 1: LDXA_I	ldxa	[%r16, + 0x0958] %asi, %r7
	brnz %r31,thr3_loop_cnt_68
	dec %r31
	.word 0x863422a3  ! 1: ORN_I	orn 	%r16, 0x02a3, %r3
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x96042b34  ! 1: ADD_I	add 	%r16, 0x0b34, %r11
        mov 0x88, %r31
thr3_loop_cnt_69:
	.word 0xc6042538  ! 1: LDUW_I	lduw	[%r16 + 0x0538], %r3
	.word 0xe8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r20
	.word 0xc6d42f46  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f46] %asi, %r3
	.word 0xeed41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r23
	.word 0xf45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r26
	.word 0xcc4c2b08  ! 1: LDSB_I	ldsb	[%r16 + 0x0b08], %r6
	.word 0xc6d42dca  ! 1: LDSHA_I	ldsha	[%r16, + 0x0dca] %asi, %r3
	.word 0xe6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r19
	.word 0xc6042d48  ! 1: LDUW_I	lduw	[%r16 + 0x0d48], %r3
	.word 0xfa140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r29
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r28
	brnz %r31,thr3_loop_cnt_69
	dec %r31
        mov 0x5a, %r31
thr3_loop_cnt_70:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xce5c2f90  ! 1: LDX_I	ldx	[%r16 + 0x0f90], %r7
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6142022  ! 1: LDUH_I	lduh	[%r16 + 0x0022], %r3
	.word 0xd2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r9
	.word 0xc6442554  ! 1: LDSW_I	ldsw	[%r16 + 0x0554], %r3
	.word 0xd0cc2a7a  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a7a] %asi, %r8
	.word 0xc6dc2c58  ! 1: LDXA_I	ldxa	[%r16, + 0x0c58] %asi, %r3
	.word 0xe4d42efc  ! 1: LDSHA_I	ldsha	[%r16, + 0x0efc] %asi, %r18
	brnz %r31,thr3_loop_cnt_70
	dec %r31
	.word 0x860427fa  ! 1: ADD_I	add 	%r16, 0x07fa, %r3
	.word 0xa22c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r17
	.word 0x862422f0  ! 1: SUB_I	sub 	%r16, 0x02f0, %r3
        mov 0xb6, %r31
thr3_loop_cnt_71:
	.word 0xd40c27da  ! 1: LDUB_I	ldub	[%r16 + 0x07da], %r10
	.word 0xcc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r6
	.word 0xf21429ee  ! 1: LDUH_I	lduh	[%r16 + 0x09ee], %r25
	.word 0xea540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r21
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xc6042e18  ! 1: LDUW_I	lduw	[%r16 + 0x0e18], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_71
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x962c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r11
	.word 0x861c2d49  ! 1: XOR_I	xor 	%r16, 0x0d49, %r3
        mov 0x58, %r31
thr3_loop_cnt_72:
	.word 0xde540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r15
	.word 0xc68c282c  ! 1: LDUBA_I	lduba	[%r16, + 0x082c] %asi, %r3
	.word 0xec941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r22
	.word 0xc68c2b09  ! 1: LDUBA_I	lduba	[%r16, + 0x0b09] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd8d42536  ! 1: LDSHA_I	ldsha	[%r16, + 0x0536] %asi, %r12
	.word 0xcc5c2248  ! 1: LDX_I	ldx	[%r16 + 0x0248], %r6
	.word 0xda842e44  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e44] %asi, %r13
	brnz %r31,thr3_loop_cnt_72
	dec %r31
        mov 0x78, %r31
thr3_loop_cnt_73:
	.word 0xc6cc2826  ! 1: LDSBA_I	ldsba	[%r16, + 0x0826] %asi, %r3
	.word 0xc6142630  ! 1: LDUH_I	lduh	[%r16 + 0x0630], %r3
	.word 0xf04c2030  ! 1: LDSB_I	ldsb	[%r16 + 0x0030], %r24
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc61429cc  ! 1: LDUH_I	lduh	[%r16 + 0x09cc], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xfa540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r29
	.word 0xc64c29f9  ! 1: LDSB_I	ldsb	[%r16 + 0x09f9], %r3
	brnz %r31,thr3_loop_cnt_73
	dec %r31
	.word 0x913c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r8
	.word 0x91341002  ! 1: SRLX_R	srlx	%r16, %r2, %r8
        mov 0x71, %r31
thr3_loop_cnt_74:
	.word 0xfc4c27bd  ! 1: LDSB_I	ldsb	[%r16 + 0x07bd], %r30
	.word 0xc6c42fe4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0fe4] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf20423f4  ! 1: LDUW_I	lduw	[%r16 + 0x03f4], %r25
	.word 0xe20420e0  ! 1: LDUW_I	lduw	[%r16 + 0x00e0], %r17
	.word 0xe8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r20
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xee8427bc  ! 1: LDUWA_I	lduwa	[%r16, + 0x07bc] %asi, %r23
	.word 0xf4c4299c  ! 1: LDSWA_I	ldswa	[%r16, + 0x099c] %asi, %r26
	.word 0xc6dc2600  ! 1: LDXA_I	ldxa	[%r16, + 0x0600] %asi, %r3
	brnz %r31,thr3_loop_cnt_74
	dec %r31
	.word 0x86242466  ! 1: SUB_I	sub 	%r16, 0x0466, %r3
	.word 0x863429c1  ! 1: ORN_I	orn 	%r16, 0x09c1, %r3
	.word 0x862c249e  ! 1: ANDN_I	andn 	%r16, 0x049e, %r3
        mov 0x3b, %r31
thr3_loop_cnt_75:
	.word 0xc6c42780  ! 1: LDSWA_I	ldswa	[%r16, + 0x0780] %asi, %r3
	.word 0xe28c2144  ! 1: LDUBA_I	lduba	[%r16, + 0x0144] %asi, %r17
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xfc5424fc  ! 1: LDSH_I	ldsh	[%r16 + 0x04fc], %r30
	.word 0xe84c261a  ! 1: LDSB_I	ldsb	[%r16 + 0x061a], %r20
	.word 0xd0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r8
	.word 0xc69425c0  ! 1: LDUHA_I	lduha	[%r16, + 0x05c0] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xcc44295c  ! 1: LDSW_I	ldsw	[%r16 + 0x095c], %r6
	.word 0xfc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r30
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xc65c2258  ! 1: LDX_I	ldx	[%r16 + 0x0258], %r3
	brnz %r31,thr3_loop_cnt_75
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x9d, %r31
thr3_loop_cnt_76:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r9
	.word 0xe60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r19
	.word 0xc6c42d8c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d8c] %asi, %r3
	.word 0xd0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r8
	.word 0xdecc257d  ! 1: LDSBA_I	ldsba	[%r16, + 0x057d] %asi, %r15
	.word 0xf4dc27d8  ! 1: LDXA_I	ldxa	[%r16, + 0x07d8] %asi, %r26
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_76
	dec %r31
	.word 0x913c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r8
	.word 0x9e342d1c  ! 1: SUBC_I	orn 	%r16, 0x0d1c, %r15
	.word 0xae140002  ! 1: OR_R	or 	%r16, %r2, %r23
        mov 0x97, %r31
thr3_loop_cnt_77:
	.word 0xc6542f48  ! 1: LDSH_I	ldsh	[%r16 + 0x0f48], %r3
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xc6cc203f  ! 1: LDSBA_I	ldsba	[%r16, + 0x003f] %asi, %r3
	.word 0xd0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r8
	.word 0xe6cc2e1e  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e1e] %asi, %r19
	.word 0xf00c2719  ! 1: LDUB_I	ldub	[%r16 + 0x0719], %r24
	.word 0xd28c29b1  ! 1: LDUBA_I	lduba	[%r16, + 0x09b1] %asi, %r9
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_77
	dec %r31
        mov 0x6, %r31
thr3_loop_cnt_78:
	.word 0xe6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r19
	.word 0xd44c2ea3  ! 1: LDSB_I	ldsb	[%r16 + 0x0ea3], %r10
	.word 0xee8c205d  ! 1: LDUBA_I	lduba	[%r16, + 0x005d] %asi, %r23
	.word 0xded42fa6  ! 1: LDSHA_I	ldsha	[%r16, + 0x0fa6] %asi, %r15
	.word 0xee94209a  ! 1: LDUHA_I	lduha	[%r16, + 0x009a] %asi, %r23
	.word 0xf8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r28
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_78
	dec %r31
	.word 0x8c4426f4  ! 1: ADDC_I	addc 	%r16, 0x06f4, %r6
	.word 0xa93c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r20
	.word 0x9c2c236b  ! 1: ANDN_I	andn 	%r16, 0x036b, %r14
        mov 0x13, %r31
thr3_loop_cnt_79:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6c424ec  ! 1: LDSWA_I	ldswa	[%r16, + 0x04ec] %asi, %r3
	.word 0xf2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r25
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd2dc20e0  ! 1: LDXA_I	ldxa	[%r16, + 0x00e0] %asi, %r9
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xc6dc23d0  ! 1: LDXA_I	ldxa	[%r16, + 0x03d0] %asi, %r3
	.word 0xd0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r8
	.word 0xc6cc2db9  ! 1: LDSBA_I	ldsba	[%r16, + 0x0db9] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r18
	brnz %r31,thr3_loop_cnt_79
	dec %r31
	.word 0x8624237a  ! 1: SUB_I	sub 	%r16, 0x037a, %r3
	.word 0x863c287d  ! 1: XNOR_I	xnor 	%r16, 0x087d, %r3
	.word 0xa404288b  ! 1: ADD_I	add 	%r16, 0x088b, %r18
        mov 0xa2, %r31
thr3_loop_cnt_80:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r24
	.word 0xc6c423ac  ! 1: LDSWA_I	ldswa	[%r16, + 0x03ac] %asi, %r3
	.word 0xf2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r25
	.word 0xc6c429b0  ! 1: LDSWA_I	ldswa	[%r16, + 0x09b0] %asi, %r3
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_80
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0xb6, %r31
thr3_loop_cnt_81:
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xc6d42798  ! 1: LDSHA_I	ldsha	[%r16, + 0x0798] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf0442d1c  ! 1: LDSW_I	ldsw	[%r16 + 0x0d1c], %r24
	.word 0xf2042bf4  ! 1: LDUW_I	lduw	[%r16 + 0x0bf4], %r25
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc614209a  ! 1: LDUH_I	lduh	[%r16 + 0x009a], %r3
	.word 0xd2d42b7e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b7e] %asi, %r9
	.word 0xea8c2c8d  ! 1: LDUBA_I	lduba	[%r16, + 0x0c8d] %asi, %r21
	brnz %r31,thr3_loop_cnt_81
	dec %r31
	.word 0xaf3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r23
	.word 0x861424ba  ! 1: OR_I	or 	%r16, 0x04ba, %r3
	.word 0x86442dfd  ! 1: ADDC_I	addc 	%r16, 0x0dfd, %r3
	.word 0x862c276d  ! 1: ANDN_I	andn 	%r16, 0x076d, %r3
        mov 0x87, %r31
thr3_loop_cnt_82:
	.word 0xdc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r14
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xce0c2923  ! 1: LDUB_I	ldub	[%r16 + 0x0923], %r7
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc60c291c  ! 1: LDUB_I	ldub	[%r16 + 0x091c], %r3
	.word 0xc64c23f2  ! 1: LDSB_I	ldsb	[%r16 + 0x03f2], %r3
	.word 0xd48c23a3  ! 1: LDUBA_I	lduba	[%r16, + 0x03a3] %asi, %r10
	.word 0xea042b98  ! 1: LDUW_I	lduw	[%r16 + 0x0b98], %r21
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xccdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r6
	.word 0xc6d42ad8  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ad8] %asi, %r3
	brnz %r31,thr3_loop_cnt_82
	dec %r31
	.word 0xbb3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r29
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0x46, %r31
thr3_loop_cnt_83:
	.word 0xc6cc2f4d  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f4d] %asi, %r3
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xda04277c  ! 1: LDUW_I	lduw	[%r16 + 0x077c], %r13
	.word 0xecd426f6  ! 1: LDSHA_I	ldsha	[%r16, + 0x06f6] %asi, %r22
	.word 0xde941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r15
	.word 0xc60c2505  ! 1: LDUB_I	ldub	[%r16 + 0x0505], %r3
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_83
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0xb0340002  ! 1: SUBC_R	orn 	%r16, %r2, %r24
	.word 0xbb3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r29
	.word 0x940c0002  ! 1: AND_R	and 	%r16, %r2, %r10
        mov 0x98, %r31
thr3_loop_cnt_84:
	.word 0xee440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r23
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	.word 0xc6dc2950  ! 1: LDXA_I	ldxa	[%r16, + 0x0950] %asi, %r3
	.word 0xc60c24cb  ! 1: LDUB_I	ldub	[%r16 + 0x04cb], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf4cc2c60  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c60] %asi, %r26
	.word 0xd0d42742  ! 1: LDSHA_I	ldsha	[%r16, + 0x0742] %asi, %r8
	.word 0xf48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r26
	.word 0xc6942de4  ! 1: LDUHA_I	lduha	[%r16, + 0x0de4] %asi, %r3
	brnz %r31,thr3_loop_cnt_84
	dec %r31
        mov 0xb6, %r31
thr3_loop_cnt_85:
	.word 0xec442b88  ! 1: LDSW_I	ldsw	[%r16 + 0x0b88], %r22
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xda440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r13
	.word 0xf85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r28
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd2542d62  ! 1: LDSH_I	ldsh	[%r16 + 0x0d62], %r9
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd20c291b  ! 1: LDUB_I	ldub	[%r16 + 0x091b], %r9
	brnz %r31,thr3_loop_cnt_85
	dec %r31
	.word 0x860c2502  ! 1: AND_I	and 	%r16, 0x0502, %r3
        mov 0xb3, %r31
thr3_loop_cnt_86:
	.word 0xf4942eb6  ! 1: LDUHA_I	lduha	[%r16, + 0x0eb6] %asi, %r26
	.word 0xce8c232f  ! 1: LDUBA_I	lduba	[%r16, + 0x032f] %asi, %r7
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r26
	.word 0xc64c20b3  ! 1: LDSB_I	ldsb	[%r16 + 0x00b3], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xde540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r15
	.word 0xe4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r18
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xfa440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r29
	brnz %r31,thr3_loop_cnt_86
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x94, %r31
thr3_loop_cnt_87:
	.word 0xc614204a  ! 1: LDUH_I	lduh	[%r16 + 0x004a], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xde4c2588  ! 1: LDSB_I	ldsb	[%r16 + 0x0588], %r15
	.word 0xd25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r9
	.word 0xf4042db4  ! 1: LDUW_I	lduw	[%r16 + 0x0db4], %r26
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	brnz %r31,thr3_loop_cnt_87
	dec %r31
	.word 0x9d2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r14
        mov 0x59, %r31
thr3_loop_cnt_88:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xee0c2eda  ! 1: LDUB_I	ldub	[%r16 + 0x0eda], %r23
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r17
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xd2dc22d8  ! 1: LDXA_I	ldxa	[%r16, + 0x02d8] %asi, %r9
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xc6dc22c8  ! 1: LDXA_I	ldxa	[%r16, + 0x02c8] %asi, %r3
	brnz %r31,thr3_loop_cnt_88
	dec %r31
	.word 0x953c1002  ! 1: SRAX_R	srax	%r16, %r2, %r10
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x94140002  ! 1: OR_R	or 	%r16, %r2, %r10
	.word 0xb81c2fb7  ! 1: XOR_I	xor 	%r16, 0x0fb7, %r28
        mov 0x55, %r31
thr3_loop_cnt_89:
	.word 0xde540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r15
	.word 0xc68c26ab  ! 1: LDUBA_I	lduba	[%r16, + 0x06ab] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	.word 0xea8c27b9  ! 1: LDUBA_I	lduba	[%r16, + 0x07b9] %asi, %r21
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6442a00  ! 1: LDSW_I	ldsw	[%r16 + 0x0a00], %r3
	.word 0xeedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r23
	.word 0xc64c2aaf  ! 1: LDSB_I	ldsb	[%r16 + 0x0aaf], %r3
	brnz %r31,thr3_loop_cnt_89
	dec %r31
        mov 0x65, %r31
thr3_loop_cnt_90:
	.word 0xfa5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r29
	.word 0xde542c88  ! 1: LDSH_I	ldsh	[%r16 + 0x0c88], %r15
	.word 0xd2d426da  ! 1: LDSHA_I	ldsha	[%r16, + 0x06da] %asi, %r9
	.word 0xc6042884  ! 1: LDUW_I	lduw	[%r16 + 0x0884], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6042538  ! 1: LDUW_I	lduw	[%r16 + 0x0538], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6d42ad6  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ad6] %asi, %r3
	.word 0xc65c2920  ! 1: LDX_I	ldx	[%r16 + 0x0920], %r3
	.word 0xe65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r19
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	brnz %r31,thr3_loop_cnt_90
	dec %r31
        mov 0x13, %r31
thr3_loop_cnt_91:
	.word 0xc6442534  ! 1: LDSW_I	ldsw	[%r16 + 0x0534], %r3
	.word 0xdecc2146  ! 1: LDSBA_I	ldsba	[%r16, + 0x0146] %asi, %r15
	.word 0xee8c2bf8  ! 1: LDUBA_I	lduba	[%r16, + 0x0bf8] %asi, %r23
	.word 0xee0c2e50  ! 1: LDUB_I	ldub	[%r16 + 0x0e50], %r23
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc64c28f8  ! 1: LDSB_I	ldsb	[%r16 + 0x08f8], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xeccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r22
	.word 0xd8842c50  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c50] %asi, %r12
	brnz %r31,thr3_loop_cnt_91
	dec %r31
	.word 0x913c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r8
	.word 0x960c0002  ! 1: AND_R	and 	%r16, %r2, %r11
        mov 0x2, %r31
thr3_loop_cnt_92:
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xf65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r27
	.word 0xc6942c94  ! 1: LDUHA_I	lduha	[%r16, + 0x0c94] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xea941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r21
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r12
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d42eea  ! 1: LDSHA_I	ldsha	[%r16, + 0x0eea] %asi, %r3
	.word 0xcc8c2336  ! 1: LDUBA_I	lduba	[%r16, + 0x0336] %asi, %r6
	brnz %r31,thr3_loop_cnt_92
	dec %r31
        mov 0xe, %r31
thr3_loop_cnt_93:
	.word 0xc6cc2772  ! 1: LDSBA_I	ldsba	[%r16, + 0x0772] %asi, %r3
	.word 0xd2842f10  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f10] %asi, %r9
	.word 0xc68c2e26  ! 1: LDUBA_I	lduba	[%r16, + 0x0e26] %asi, %r3
	.word 0xe68c212e  ! 1: LDUBA_I	lduba	[%r16, + 0x012e] %asi, %r19
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6d42b6e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b6e] %asi, %r3
	.word 0xc6cc2bdb  ! 1: LDSBA_I	ldsba	[%r16, + 0x0bdb] %asi, %r3
	brnz %r31,thr3_loop_cnt_93
	dec %r31
	.word 0x86442ce0  ! 1: ADDC_I	addc 	%r16, 0x0ce0, %r3
        mov 0xb8, %r31
thr3_loop_cnt_94:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc68424f4  ! 1: LDUWA_I	lduwa	[%r16, + 0x04f4] %asi, %r3
	.word 0xda4c24d8  ! 1: LDSB_I	ldsb	[%r16 + 0x04d8], %r13
	.word 0xd804237c  ! 1: LDUW_I	lduw	[%r16 + 0x037c], %r12
	.word 0xe80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r20
	.word 0xf4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r26
	.word 0xcc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r6
	.word 0xe6442288  ! 1: LDSW_I	ldsw	[%r16 + 0x0288], %r19
	.word 0xc6dc2990  ! 1: LDXA_I	ldxa	[%r16, + 0x0990] %asi, %r3
	.word 0xf0142fde  ! 1: LDUH_I	lduh	[%r16 + 0x0fde], %r24
	brnz %r31,thr3_loop_cnt_94
	dec %r31
        mov 0xd, %r31
thr3_loop_cnt_95:
	.word 0xc69428a4  ! 1: LDUHA_I	lduha	[%r16, + 0x08a4] %asi, %r3
	.word 0xdadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r13
	.word 0xe2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r17
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	.word 0xd0dc25f0  ! 1: LDXA_I	ldxa	[%r16, + 0x05f0] %asi, %r8
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xe6942160  ! 1: LDUHA_I	lduha	[%r16, + 0x0160] %asi, %r19
	.word 0xda8c2fb8  ! 1: LDUBA_I	lduba	[%r16, + 0x0fb8] %asi, %r13
	brnz %r31,thr3_loop_cnt_95
	dec %r31
        mov 0x23, %r31
thr3_loop_cnt_96:
	.word 0xf6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r27
	.word 0xda042c48  ! 1: LDUW_I	lduw	[%r16 + 0x0c48], %r13
	.word 0xce042e58  ! 1: LDUW_I	lduw	[%r16 + 0x0e58], %r7
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd2142a5e  ! 1: LDUH_I	lduh	[%r16 + 0x0a5e], %r9
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd4442200  ! 1: LDSW_I	ldsw	[%r16 + 0x0200], %r10
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_96
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x3d, %r31
thr3_loop_cnt_97:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc64c2b3c  ! 1: LDSB_I	ldsb	[%r16 + 0x0b3c], %r3
	.word 0xc60422f4  ! 1: LDUW_I	lduw	[%r16 + 0x02f4], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xc6142cf6  ! 1: LDUH_I	lduh	[%r16 + 0x0cf6], %r3
	.word 0xc64c2723  ! 1: LDSB_I	ldsb	[%r16 + 0x0723], %r3
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_97
	dec %r31
        mov 0x96, %r31
thr3_loop_cnt_98:
	.word 0xf8942096  ! 1: LDUHA_I	lduha	[%r16, + 0x0096] %asi, %r28
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc69420e6  ! 1: LDUHA_I	lduha	[%r16, + 0x00e6] %asi, %r3
	.word 0xde5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r15
	.word 0xf8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r28
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6c421f8  ! 1: LDSWA_I	ldswa	[%r16, + 0x01f8] %asi, %r3
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	.word 0xe65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r19
	.word 0xf61429b0  ! 1: LDUH_I	lduh	[%r16 + 0x09b0], %r27
	.word 0xc69421d6  ! 1: LDUHA_I	lduha	[%r16, + 0x01d6] %asi, %r3
	brnz %r31,thr3_loop_cnt_98
	dec %r31
	.word 0xb52c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r26
	.word 0xa80c29ed  ! 1: AND_I	and 	%r16, 0x09ed, %r20
	.word 0xb03c22db  ! 1: XNOR_I	xnor 	%r16, 0x02db, %r24
        mov 0x72, %r31
thr3_loop_cnt_99:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf4d42a90  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a90] %asi, %r26
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xf4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r26
	.word 0xdac42078  ! 1: LDSWA_I	ldswa	[%r16, + 0x0078] %asi, %r13
	.word 0xd2c429ec  ! 1: LDSWA_I	ldswa	[%r16, + 0x09ec] %asi, %r9
	.word 0xf4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r26
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc60c20f9  ! 1: LDUB_I	ldub	[%r16 + 0x00f9], %r3
	brnz %r31,thr3_loop_cnt_99
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0xbb, %r31
thr3_loop_cnt_100:
	.word 0xd0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r8
	.word 0xd4c4212c  ! 1: LDSWA_I	ldswa	[%r16, + 0x012c] %asi, %r10
	.word 0xf8542fa4  ! 1: LDSH_I	ldsh	[%r16 + 0x0fa4], %r28
	.word 0xf8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r28
	.word 0xc65c2df8  ! 1: LDX_I	ldx	[%r16 + 0x0df8], %r3
	.word 0xee0c236c  ! 1: LDUB_I	ldub	[%r16 + 0x036c], %r23
	.word 0xce942d88  ! 1: LDUHA_I	lduha	[%r16, + 0x0d88] %asi, %r7
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xc6d4287a  ! 1: LDSHA_I	ldsha	[%r16, + 0x087a] %asi, %r3
	brnz %r31,thr3_loop_cnt_100
	dec %r31
	.word 0xad342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r22
        mov 0xc6, %r31
thr3_loop_cnt_101:
	.word 0xdacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r13
	.word 0xd8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r12
	.word 0xc6d42706  ! 1: LDSHA_I	ldsha	[%r16, + 0x0706] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf84c22ba  ! 1: LDSB_I	ldsb	[%r16 + 0x02ba], %r28
	.word 0xd8442280  ! 1: LDSW_I	ldsw	[%r16 + 0x0280], %r12
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	.word 0xee140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r23
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc60c29d4  ! 1: LDUB_I	ldub	[%r16 + 0x09d4], %r3
	.word 0xfc0c2ab3  ! 1: LDUB_I	ldub	[%r16 + 0x0ab3], %r30
	brnz %r31,thr3_loop_cnt_101
	dec %r31
	.word 0x92340002  ! 1: ORN_R	orn 	%r16, %r2, %r9
	.word 0x960c248c  ! 1: AND_I	and 	%r16, 0x048c, %r11
	.word 0x86042db9  ! 1: ADD_I	add 	%r16, 0x0db9, %r3
        mov 0x83, %r31
thr3_loop_cnt_102:
	.word 0xda5c2230  ! 1: LDX_I	ldx	[%r16 + 0x0230], %r13
	.word 0xd6dc2490  ! 1: LDXA_I	ldxa	[%r16, + 0x0490] %asi, %r11
	.word 0xc60c2a63  ! 1: LDUB_I	ldub	[%r16 + 0x0a63], %r3
	.word 0xcc8427a0  ! 1: LDUWA_I	lduwa	[%r16, + 0x07a0] %asi, %r6
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xec04260c  ! 1: LDUW_I	lduw	[%r16 + 0x060c], %r22
	.word 0xf2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r25
	brnz %r31,thr3_loop_cnt_102
	dec %r31
	.word 0xbb3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r29
	.word 0xae1c0002  ! 1: XOR_R	xor 	%r16, %r2, %r23
	.word 0x86342bc9  ! 1: ORN_I	orn 	%r16, 0x0bc9, %r3
        mov 0x4f, %r31
thr3_loop_cnt_103:
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xdec429d4  ! 1: LDSWA_I	ldswa	[%r16, + 0x09d4] %asi, %r15
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	.word 0xdc4c2f8e  ! 1: LDSB_I	ldsb	[%r16 + 0x0f8e], %r14
	.word 0xee4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r23
	.word 0xc6dc2cf0  ! 1: LDXA_I	ldxa	[%r16, + 0x0cf0] %asi, %r3
	.word 0xf0942fa4  ! 1: LDUHA_I	lduha	[%r16, + 0x0fa4] %asi, %r24
	brnz %r31,thr3_loop_cnt_103
	dec %r31
	.word 0xae1c23a5  ! 1: XOR_I	xor 	%r16, 0x03a5, %r23
	.word 0xaa442739  ! 1: ADDC_I	addc 	%r16, 0x0739, %r21
	.word 0x861c2c38  ! 1: XOR_I	xor 	%r16, 0x0c38, %r3
        mov 0xbe, %r31
thr3_loop_cnt_104:
	.word 0xe6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r19
	.word 0xc6dc2028  ! 1: LDXA_I	ldxa	[%r16, + 0x0028] %asi, %r3
	.word 0xea8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r21
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xd6dc28f0  ! 1: LDXA_I	ldxa	[%r16, + 0x08f0] %asi, %r11
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc64c22f2  ! 1: LDSB_I	ldsb	[%r16 + 0x02f2], %r3
	brnz %r31,thr3_loop_cnt_104
	dec %r31
	.word 0xa5342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r18
        mov 0x21, %r31
thr3_loop_cnt_105:
	.word 0xee0c273a  ! 1: LDUB_I	ldub	[%r16 + 0x073a], %r23
	.word 0xe60c2d9b  ! 1: LDUB_I	ldub	[%r16 + 0x0d9b], %r19
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6c42b44  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b44] %asi, %r3
	.word 0xc64c2022  ! 1: LDSB_I	ldsb	[%r16 + 0x0022], %r3
	.word 0xd8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r12
	.word 0xc6c420f0  ! 1: LDSWA_I	ldswa	[%r16, + 0x00f0] %asi, %r3
	.word 0xc6c42a6c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a6c] %asi, %r3
	brnz %r31,thr3_loop_cnt_105
	dec %r31
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x8e142a7e  ! 1: OR_I	or 	%r16, 0x0a7e, %r7
        mov 0x2d, %r31
thr3_loop_cnt_106:
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xd4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r10
	.word 0xf65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r27
	.word 0xf40c2abd  ! 1: LDUB_I	ldub	[%r16 + 0x0abd], %r26
	.word 0xd4542c68  ! 1: LDSH_I	ldsh	[%r16 + 0x0c68], %r10
	.word 0xe8dc2590  ! 1: LDXA_I	ldxa	[%r16, + 0x0590] %asi, %r20
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xc69424d8  ! 1: LDUHA_I	lduha	[%r16, + 0x04d8] %asi, %r3
	.word 0xeccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r22
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc65c2ed0  ! 1: LDX_I	ldx	[%r16 + 0x0ed0], %r3
	.word 0xc6042090  ! 1: LDUW_I	lduw	[%r16 + 0x0090], %r3
	brnz %r31,thr3_loop_cnt_106
	dec %r31
        mov 0xa5, %r31
thr3_loop_cnt_107:
	.word 0xc694290a  ! 1: LDUHA_I	lduha	[%r16, + 0x090a] %asi, %r3
	.word 0xe6cc21b1  ! 1: LDSBA_I	ldsba	[%r16, + 0x01b1] %asi, %r19
	.word 0xdc8c2089  ! 1: LDUBA_I	lduba	[%r16, + 0x0089] %asi, %r14
	.word 0xee042b6c  ! 1: LDUW_I	lduw	[%r16 + 0x0b6c], %r23
	.word 0xe80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r20
	.word 0xc6142990  ! 1: LDUH_I	lduh	[%r16 + 0x0990], %r3
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	.word 0xf2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r25
	.word 0xc614274a  ! 1: LDUH_I	lduh	[%r16 + 0x074a], %r3
	.word 0xc6cc2cbb  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cbb] %asi, %r3
	brnz %r31,thr3_loop_cnt_107
	dec %r31
	.word 0x921420d0  ! 1: OR_I	or 	%r16, 0x00d0, %r9
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x77, %r31
thr3_loop_cnt_108:
	.word 0xfa1428a4  ! 1: LDUH_I	lduh	[%r16 + 0x08a4], %r29
	.word 0xde040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r15
	.word 0xc6442e40  ! 1: LDSW_I	ldsw	[%r16 + 0x0e40], %r3
	.word 0xc6dc2540  ! 1: LDXA_I	ldxa	[%r16, + 0x0540] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xce941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r7
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xc6142e20  ! 1: LDUH_I	lduh	[%r16 + 0x0e20], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xec142f5e  ! 1: LDUH_I	lduh	[%r16 + 0x0f5e], %r22
	.word 0xfc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r30
	brnz %r31,thr3_loop_cnt_108
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x8d2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r6
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0xb0340002  ! 1: ORN_R	orn 	%r16, %r2, %r24
        mov 0x5b, %r31
thr3_loop_cnt_109:
	.word 0xda140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r13
	.word 0xf44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r26
	.word 0xda4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r13
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xced423c2  ! 1: LDSHA_I	ldsha	[%r16, + 0x03c2] %asi, %r7
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc604297c  ! 1: LDUW_I	lduw	[%r16 + 0x097c], %r3
	.word 0xc60c27fc  ! 1: LDUB_I	ldub	[%r16 + 0x07fc], %r3
	brnz %r31,thr3_loop_cnt_109
	dec %r31
        mov 0x48, %r31
thr3_loop_cnt_110:
	.word 0xc6d425b2  ! 1: LDSHA_I	ldsha	[%r16, + 0x05b2] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r20
	.word 0xda54239c  ! 1: LDSH_I	ldsh	[%r16 + 0x039c], %r13
	.word 0xdedc2e60  ! 1: LDXA_I	ldxa	[%r16, + 0x0e60] %asi, %r15
	.word 0xf4d4283c  ! 1: LDSHA_I	ldsha	[%r16, + 0x083c] %asi, %r26
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd0042f60  ! 1: LDUW_I	lduw	[%r16 + 0x0f60], %r8
	.word 0xc6142fba  ! 1: LDUH_I	lduh	[%r16 + 0x0fba], %r3
	.word 0xc6842488  ! 1: LDUWA_I	lduwa	[%r16, + 0x0488] %asi, %r3
	brnz %r31,thr3_loop_cnt_110
	dec %r31
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x86342447  ! 1: SUBC_I	orn 	%r16, 0x0447, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0xa40c0002  ! 1: AND_R	and 	%r16, %r2, %r18
        mov 0x8e, %r31
thr3_loop_cnt_111:
	.word 0xf08c2359  ! 1: LDUBA_I	lduba	[%r16, + 0x0359] %asi, %r24
	.word 0xc6842a88  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a88] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd6542b78  ! 1: LDSH_I	ldsh	[%r16 + 0x0b78], %r11
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r27
	.word 0xc60c2b96  ! 1: LDUB_I	ldub	[%r16 + 0x0b96], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r27
	.word 0xfa4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r29
	brnz %r31,thr3_loop_cnt_111
	dec %r31
	.word 0xa4042256  ! 1: ADD_I	add 	%r16, 0x0256, %r18
	.word 0x9a2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r13
	.word 0x9d2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r14
	.word 0x863428d7  ! 1: SUBC_I	orn 	%r16, 0x08d7, %r3
        mov 0xa, %r31
thr3_loop_cnt_112:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xcedc2780  ! 1: LDXA_I	ldxa	[%r16, + 0x0780] %asi, %r7
	.word 0xc6842ca8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ca8] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c42cd0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0cd0] %asi, %r3
	.word 0xd00c21bf  ! 1: LDUB_I	ldub	[%r16 + 0x01bf], %r8
	.word 0xe68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r19
	.word 0xd8cc2d23  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d23] %asi, %r12
	brnz %r31,thr3_loop_cnt_112
	dec %r31
	.word 0x86342bcb  ! 1: ORN_I	orn 	%r16, 0x0bcb, %r3
	.word 0xbc44232e  ! 1: ADDC_I	addc 	%r16, 0x032e, %r30
        mov 0x59, %r31
thr3_loop_cnt_113:
	.word 0xd0dc21e0  ! 1: LDXA_I	ldxa	[%r16, + 0x01e0] %asi, %r8
	.word 0xea9420ce  ! 1: LDUHA_I	lduha	[%r16, + 0x00ce] %asi, %r21
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xf84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r28
	.word 0xea0426c4  ! 1: LDUW_I	lduw	[%r16 + 0x06c4], %r21
	.word 0xec0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r22
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xdc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r14
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_113
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x9d340002  ! 1: SRL_R	srl 	%r16, %r2, %r14
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x8e0c2b97  ! 1: AND_I	and 	%r16, 0x0b97, %r7
        mov 0x4a, %r31
thr3_loop_cnt_114:
	.word 0xd65c23a0  ! 1: LDX_I	ldx	[%r16 + 0x03a0], %r11
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd8c42f1c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f1c] %asi, %r12
	.word 0xc6442e34  ! 1: LDSW_I	ldsw	[%r16 + 0x0e34], %r3
	.word 0xc6842b30  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b30] %asi, %r3
	.word 0xfcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r30
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc299b  ! 1: LDSBA_I	ldsba	[%r16, + 0x099b] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_114
	dec %r31
	.word 0x8f2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r7
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x9a0420a0  ! 1: ADD_I	add 	%r16, 0x00a0, %r13
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0x79, %r31
thr3_loop_cnt_115:
	.word 0xf8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r28
	.word 0xfc94227c  ! 1: LDUHA_I	lduha	[%r16, + 0x027c] %asi, %r30
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xe85c2a90  ! 1: LDX_I	ldx	[%r16 + 0x0a90], %r20
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xd28c292a  ! 1: LDUBA_I	lduba	[%r16, + 0x092a] %asi, %r9
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_115
	dec %r31
	.word 0xb73c1002  ! 1: SRAX_R	srax	%r16, %r2, %r27
	.word 0x921c0002  ! 1: XOR_R	xor 	%r16, %r2, %r9
        mov 0xa5, %r31
thr3_loop_cnt_116:
	.word 0xcccc2ab3  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ab3] %asi, %r6
	.word 0xec042b24  ! 1: LDUW_I	lduw	[%r16 + 0x0b24], %r22
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6d4232e  ! 1: LDSHA_I	ldsha	[%r16, + 0x032e] %asi, %r3
	.word 0xda0c26a3  ! 1: LDUB_I	ldub	[%r16 + 0x06a3], %r13
	.word 0xc68425f0  ! 1: LDUWA_I	lduwa	[%r16, + 0x05f0] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe21427ec  ! 1: LDUH_I	lduh	[%r16 + 0x07ec], %r17
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf2d427c0  ! 1: LDSHA_I	ldsha	[%r16, + 0x07c0] %asi, %r25
	brnz %r31,thr3_loop_cnt_116
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0xac242f12  ! 1: SUB_I	sub 	%r16, 0x0f12, %r22
        mov 0xbc, %r31
thr3_loop_cnt_117:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6942ade  ! 1: LDUHA_I	lduha	[%r16, + 0x0ade] %asi, %r3
	.word 0xd08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r8
	.word 0xc68c28a9  ! 1: LDUBA_I	lduba	[%r16, + 0x08a9] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe2d42c14  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c14] %asi, %r17
	.word 0xf88c23ae  ! 1: LDUBA_I	lduba	[%r16, + 0x03ae] %asi, %r28
	.word 0xc6042de0  ! 1: LDUW_I	lduw	[%r16 + 0x0de0], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_117
	dec %r31
	.word 0x913c1002  ! 1: SRAX_R	srax	%r16, %r2, %r8
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0xa40c0002  ! 1: AND_R	and 	%r16, %r2, %r18
        mov 0x12, %r31
thr3_loop_cnt_118:
	.word 0xc6c429e0  ! 1: LDSWA_I	ldswa	[%r16, + 0x09e0] %asi, %r3
	.word 0xe404278c  ! 1: LDUW_I	lduw	[%r16 + 0x078c], %r18
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xe45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r18
	.word 0xe8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r20
	.word 0xfa5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r29
	.word 0xf8cc2ec5  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ec5] %asi, %r28
	.word 0xec9424c0  ! 1: LDUHA_I	lduha	[%r16, + 0x04c0] %asi, %r22
	.word 0xdc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r14
	brnz %r31,thr3_loop_cnt_118
	dec %r31
        mov 0x14, %r31
thr3_loop_cnt_119:
	.word 0xf8cc2975  ! 1: LDSBA_I	ldsba	[%r16, + 0x0975] %asi, %r28
	.word 0xc68c2ac0  ! 1: LDUBA_I	lduba	[%r16, + 0x0ac0] %asi, %r3
	.word 0xe60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r19
	.word 0xfc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r30
	.word 0xde540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r15
	.word 0xc6042730  ! 1: LDUW_I	lduw	[%r16 + 0x0730], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xc6c42d74  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d74] %asi, %r3
	.word 0xd08c26f9  ! 1: LDUBA_I	lduba	[%r16, + 0x06f9] %asi, %r8
	brnz %r31,thr3_loop_cnt_119
	dec %r31
	.word 0x902c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r8
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x981c0002  ! 1: XOR_R	xor 	%r16, %r2, %r12
	.word 0xb40424fc  ! 1: ADD_I	add 	%r16, 0x04fc, %r26
        mov 0x91, %r31
thr3_loop_cnt_120:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d42f0a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f0a] %asi, %r3
	.word 0xc604240c  ! 1: LDUW_I	lduw	[%r16 + 0x040c], %r3
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xe28c22e3  ! 1: LDUBA_I	lduba	[%r16, + 0x02e3] %asi, %r17
	.word 0xd2542bb6  ! 1: LDSH_I	ldsh	[%r16 + 0x0bb6], %r9
	.word 0xe4442d3c  ! 1: LDSW_I	ldsw	[%r16 + 0x0d3c], %r18
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xfadc2d90  ! 1: LDXA_I	ldxa	[%r16, + 0x0d90] %asi, %r29
	.word 0xecd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r22
	brnz %r31,thr3_loop_cnt_120
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x903c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r8
	.word 0x983c2298  ! 1: XNOR_I	xnor 	%r16, 0x0298, %r12
        mov 0xb9, %r31
thr3_loop_cnt_121:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6042d60  ! 1: LDUW_I	lduw	[%r16 + 0x0d60], %r3
	.word 0xc6cc2c53  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c53] %asi, %r3
	.word 0xea942b66  ! 1: LDUHA_I	lduha	[%r16, + 0x0b66] %asi, %r21
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_121
	dec %r31
	.word 0xb93c0002  ! 1: SRA_R	sra 	%r16, %r2, %r28
	.word 0x863424a2  ! 1: SUBC_I	orn 	%r16, 0x04a2, %r3
	.word 0x863426ed  ! 1: ORN_I	orn 	%r16, 0x06ed, %r3
	.word 0x93341002  ! 1: SRLX_R	srlx	%r16, %r2, %r9
        mov 0x7b, %r31
thr3_loop_cnt_122:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r28
	.word 0xe4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r18
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6042e04  ! 1: LDUW_I	lduw	[%r16 + 0x0e04], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6542152  ! 1: LDSH_I	ldsh	[%r16 + 0x0152], %r3
	.word 0xee4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r23
	.word 0xc68422c8  ! 1: LDUWA_I	lduwa	[%r16, + 0x02c8] %asi, %r3
	.word 0xd48c28ea  ! 1: LDUBA_I	lduba	[%r16, + 0x08ea] %asi, %r10
	brnz %r31,thr3_loop_cnt_122
	dec %r31
	.word 0xb8340002  ! 1: SUBC_R	orn 	%r16, %r2, %r28
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0x17, %r31
thr3_loop_cnt_123:
	.word 0xded42b84  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b84] %asi, %r15
	.word 0xcc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r6
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xecdc2da0  ! 1: LDXA_I	ldxa	[%r16, + 0x0da0] %asi, %r22
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd4c42964  ! 1: LDSWA_I	ldswa	[%r16, + 0x0964] %asi, %r10
	.word 0xcc042e98  ! 1: LDUW_I	lduw	[%r16 + 0x0e98], %r6
	.word 0xd44c240c  ! 1: LDSB_I	ldsb	[%r16 + 0x040c], %r10
	brnz %r31,thr3_loop_cnt_123
	dec %r31
	.word 0x9c342f93  ! 1: SUBC_I	orn 	%r16, 0x0f93, %r14
	.word 0xa2342258  ! 1: SUBC_I	orn 	%r16, 0x0258, %r17
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0xbc, %r31
thr3_loop_cnt_124:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6d422ec  ! 1: LDSHA_I	ldsha	[%r16, + 0x02ec] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6d425b6  ! 1: LDSHA_I	ldsha	[%r16, + 0x05b6] %asi, %r3
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xe2542a72  ! 1: LDSH_I	ldsh	[%r16 + 0x0a72], %r17
	.word 0xc6542b96  ! 1: LDSH_I	ldsh	[%r16 + 0x0b96], %r3
	.word 0xdac420d4  ! 1: LDSWA_I	ldswa	[%r16, + 0x00d4] %asi, %r13
	.word 0xf4d4232e  ! 1: LDSHA_I	ldsha	[%r16, + 0x032e] %asi, %r26
	brnz %r31,thr3_loop_cnt_124
	dec %r31
	.word 0xb83c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r28
	.word 0xbc142178  ! 1: OR_I	or 	%r16, 0x0178, %r30
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0xa93c1002  ! 1: SRAX_R	srax	%r16, %r2, %r20
        mov 0x4d, %r31
thr3_loop_cnt_125:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xee5c2d18  ! 1: LDX_I	ldx	[%r16 + 0x0d18], %r23
	.word 0xec4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r22
	.word 0xd2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r9
	.word 0xd29428be  ! 1: LDUHA_I	lduha	[%r16, + 0x08be] %asi, %r9
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf8c42c54  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c54] %asi, %r28
	.word 0xe2442ef4  ! 1: LDSW_I	ldsw	[%r16 + 0x0ef4], %r17
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6442db4  ! 1: LDSW_I	ldsw	[%r16 + 0x0db4], %r3
	.word 0xc68c28f9  ! 1: LDUBA_I	lduba	[%r16, + 0x08f9] %asi, %r3
	brnz %r31,thr3_loop_cnt_125
	dec %r31
	.word 0x862c2999  ! 1: ANDN_I	andn 	%r16, 0x0999, %r3
        mov 0x39, %r31
thr3_loop_cnt_126:
	.word 0xc60c23f6  ! 1: LDUB_I	ldub	[%r16 + 0x03f6], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe45c23d0  ! 1: LDX_I	ldx	[%r16 + 0x03d0], %r18
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xdacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r13
	.word 0xd2842498  ! 1: LDUWA_I	lduwa	[%r16, + 0x0498] %asi, %r9
	.word 0xee4c28e6  ! 1: LDSB_I	ldsb	[%r16 + 0x08e6], %r23
	.word 0xc6042678  ! 1: LDUW_I	lduw	[%r16 + 0x0678], %r3
	.word 0xfcdc2ff8  ! 1: LDXA_I	ldxa	[%r16, + 0x0ff8] %asi, %r30
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	brnz %r31,thr3_loop_cnt_126
	dec %r31
	.word 0x99343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r12
        mov 0x29, %r31
thr3_loop_cnt_127:
	.word 0xdad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r13
	.word 0xe2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r17
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe44428a0  ! 1: LDSW_I	ldsw	[%r16 + 0x08a0], %r18
	.word 0xfa8c28e0  ! 1: LDUBA_I	lduba	[%r16, + 0x08e0] %asi, %r29
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6442858  ! 1: LDSW_I	ldsw	[%r16 + 0x0858], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6d42aca  ! 1: LDSHA_I	ldsha	[%r16, + 0x0aca] %asi, %r3
	.word 0xc614276a  ! 1: LDUH_I	lduh	[%r16 + 0x076a], %r3
	.word 0xdc142d34  ! 1: LDUH_I	lduh	[%r16 + 0x0d34], %r14
	brnz %r31,thr3_loop_cnt_127
	dec %r31
        mov 0x50, %r31
thr3_loop_cnt_128:
	.word 0xd84c2779  ! 1: LDSB_I	ldsb	[%r16 + 0x0779], %r12
	.word 0xc6dc2ff0  ! 1: LDXA_I	ldxa	[%r16, + 0x0ff0] %asi, %r3
	.word 0xc65c28d0  ! 1: LDX_I	ldx	[%r16 + 0x08d0], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xd6dc23c0  ! 1: LDXA_I	ldxa	[%r16, + 0x03c0] %asi, %r11
	.word 0xda0c2d42  ! 1: LDUB_I	ldub	[%r16 + 0x0d42], %r13
	.word 0xdc142bf4  ! 1: LDUH_I	lduh	[%r16 + 0x0bf4], %r14
	.word 0xc69424aa  ! 1: LDUHA_I	lduha	[%r16, + 0x04aa] %asi, %r3
	.word 0xe84c2478  ! 1: LDSB_I	ldsb	[%r16 + 0x0478], %r20
	brnz %r31,thr3_loop_cnt_128
	dec %r31
	.word 0xa7340002  ! 1: SRL_R	srl 	%r16, %r2, %r19
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x6, %r31
thr3_loop_cnt_129:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc65c2798  ! 1: LDX_I	ldx	[%r16 + 0x0798], %r3
	.word 0xdacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r13
	.word 0xc6042f58  ! 1: LDUW_I	lduw	[%r16 + 0x0f58], %r3
	.word 0xc644286c  ! 1: LDSW_I	ldsw	[%r16 + 0x086c], %r3
	.word 0xe604266c  ! 1: LDUW_I	lduw	[%r16 + 0x066c], %r19
	.word 0xc6042da4  ! 1: LDUW_I	lduw	[%r16 + 0x0da4], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r27
	.word 0xd8d42be4  ! 1: LDSHA_I	ldsha	[%r16, + 0x0be4] %asi, %r12
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd8442770  ! 1: LDSW_I	ldsw	[%r16 + 0x0770], %r12
	brnz %r31,thr3_loop_cnt_129
	dec %r31
	.word 0x9f3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r15
	.word 0x992c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r12
	.word 0x8c1424a6  ! 1: OR_I	or 	%r16, 0x04a6, %r6
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0x12, %r31
thr3_loop_cnt_130:
	.word 0xda5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r13
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xfc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r30
	.word 0xd4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r10
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xfadc2e40  ! 1: LDXA_I	ldxa	[%r16, + 0x0e40] %asi, %r29
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xc6542a5e  ! 1: LDSH_I	ldsh	[%r16 + 0x0a5e], %r3
	.word 0xc6d42b2e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b2e] %asi, %r3
	brnz %r31,thr3_loop_cnt_130
	dec %r31
        mov 0xa0, %r31
thr3_loop_cnt_131:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc68c28fe  ! 1: LDUBA_I	lduba	[%r16, + 0x08fe] %asi, %r3
	.word 0xfc4c24e8  ! 1: LDSB_I	ldsb	[%r16 + 0x04e8], %r30
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xecdc23b0  ! 1: LDXA_I	ldxa	[%r16, + 0x03b0] %asi, %r22
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd04c21af  ! 1: LDSB_I	ldsb	[%r16 + 0x01af], %r8
	.word 0xc68c2378  ! 1: LDUBA_I	lduba	[%r16, + 0x0378] %asi, %r3
	.word 0xcc4c29e4  ! 1: LDSB_I	ldsb	[%r16 + 0x09e4], %r6
	brnz %r31,thr3_loop_cnt_131
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0x6c, %r31
thr3_loop_cnt_132:
	.word 0xc6cc2a7c  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a7c] %asi, %r3
	.word 0xe404241c  ! 1: LDUW_I	lduw	[%r16 + 0x041c], %r18
	.word 0xe24c2858  ! 1: LDSB_I	ldsb	[%r16 + 0x0858], %r17
	.word 0xc6c42810  ! 1: LDSWA_I	ldswa	[%r16, + 0x0810] %asi, %r3
	.word 0xc6d426fe  ! 1: LDSHA_I	ldsha	[%r16, + 0x06fe] %asi, %r3
	.word 0xf45c2778  ! 1: LDX_I	ldx	[%r16 + 0x0778], %r26
	.word 0xdc8c25b6  ! 1: LDUBA_I	lduba	[%r16, + 0x05b6] %asi, %r14
	.word 0xc68c26a9  ! 1: LDUBA_I	lduba	[%r16, + 0x06a9] %asi, %r3
	brnz %r31,thr3_loop_cnt_132
	dec %r31
	.word 0x9a3c28b0  ! 1: XNOR_I	xnor 	%r16, 0x08b0, %r13
        mov 0x29, %r31
thr3_loop_cnt_133:
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf8042c20  ! 1: LDUW_I	lduw	[%r16 + 0x0c20], %r28
	.word 0xc654222a  ! 1: LDSH_I	ldsh	[%r16 + 0x022a], %r3
	.word 0xec842624  ! 1: LDUWA_I	lduwa	[%r16, + 0x0624] %asi, %r22
	.word 0xc68424f0  ! 1: LDUWA_I	lduwa	[%r16, + 0x04f0] %asi, %r3
	.word 0xee4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r23
	brnz %r31,thr3_loop_cnt_133
	dec %r31
	.word 0x97342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r11
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x86242714  ! 1: SUB_I	sub 	%r16, 0x0714, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x7a, %r31
thr3_loop_cnt_134:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r27
	.word 0xf2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r25
	.word 0xeccc2926  ! 1: LDSBA_I	ldsba	[%r16, + 0x0926] %asi, %r22
	.word 0xe45c2530  ! 1: LDX_I	ldx	[%r16 + 0x0530], %r18
	.word 0xd4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r10
	.word 0xc6542fac  ! 1: LDSH_I	ldsh	[%r16 + 0x0fac], %r3
	.word 0xc6d42852  ! 1: LDSHA_I	ldsha	[%r16, + 0x0852] %asi, %r3
	.word 0xea8c215f  ! 1: LDUBA_I	lduba	[%r16, + 0x015f] %asi, %r21
	.word 0xdadc2dd0  ! 1: LDXA_I	ldxa	[%r16, + 0x0dd0] %asi, %r13
	.word 0xdc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r14
	.word 0xd8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r12
	brnz %r31,thr3_loop_cnt_134
	dec %r31
	.word 0x932c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r9
	.word 0x8e3c2d61  ! 1: XNOR_I	xnor 	%r16, 0x0d61, %r7
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0xc5, %r31
thr3_loop_cnt_135:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xdc0424b8  ! 1: LDUW_I	lduw	[%r16 + 0x04b8], %r14
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xea140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r21
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe85c29c8  ! 1: LDX_I	ldx	[%r16 + 0x09c8], %r20
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd2142750  ! 1: LDUH_I	lduh	[%r16 + 0x0750], %r9
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd89429b2  ! 1: LDUHA_I	lduha	[%r16, + 0x09b2] %asi, %r12
	.word 0xf0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r24
	brnz %r31,thr3_loop_cnt_135
	dec %r31
        mov 0x81, %r31
thr3_loop_cnt_136:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd2442578  ! 1: LDSW_I	ldsw	[%r16 + 0x0578], %r9
	.word 0xc6c428c0  ! 1: LDSWA_I	ldswa	[%r16, + 0x08c0] %asi, %r3
	.word 0xce941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r7
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xdec42a68  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a68] %asi, %r15
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd85428d6  ! 1: LDSH_I	ldsh	[%r16 + 0x08d6], %r12
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe88c2439  ! 1: LDUBA_I	lduba	[%r16, + 0x0439] %asi, %r20
	.word 0xf2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r25
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_136
	dec %r31
        mov 0x25, %r31
thr3_loop_cnt_137:
	.word 0xf45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r26
	.word 0xec040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r22
	.word 0xc68c2688  ! 1: LDUBA_I	lduba	[%r16, + 0x0688] %asi, %r3
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xea540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r21
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	.word 0xc6942680  ! 1: LDUHA_I	lduha	[%r16, + 0x0680] %asi, %r3
	brnz %r31,thr3_loop_cnt_137
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x97, %r31
thr3_loop_cnt_138:
	.word 0xcc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r6
	.word 0xc60c2578  ! 1: LDUB_I	ldub	[%r16 + 0x0578], %r3
	.word 0xee0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r23
	.word 0xc60427a4  ! 1: LDUW_I	lduw	[%r16 + 0x07a4], %r3
	.word 0xea140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r21
	.word 0xfc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r30
	.word 0xee0c2b1b  ! 1: LDUB_I	ldub	[%r16 + 0x0b1b], %r23
	.word 0xde042514  ! 1: LDUW_I	lduw	[%r16 + 0x0514], %r15
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc68c2437  ! 1: LDUBA_I	lduba	[%r16, + 0x0437] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c272b  ! 1: LDSB_I	ldsb	[%r16 + 0x072b], %r3
	brnz %r31,thr3_loop_cnt_138
	dec %r31
	.word 0x9a3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r13
	.word 0xad341002  ! 1: SRLX_R	srlx	%r16, %r2, %r22
        mov 0x2a, %r31
thr3_loop_cnt_139:
	.word 0xc6cc28f3  ! 1: LDSBA_I	ldsba	[%r16, + 0x08f3] %asi, %r3
	.word 0xc6dc2e30  ! 1: LDXA_I	ldxa	[%r16, + 0x0e30] %asi, %r3
	.word 0xc6942684  ! 1: LDUHA_I	lduha	[%r16, + 0x0684] %asi, %r3
	.word 0xf8842268  ! 1: LDUWA_I	lduwa	[%r16, + 0x0268] %asi, %r28
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2448  ! 1: LDXA_I	ldxa	[%r16, + 0x0448] %asi, %r3
	.word 0xe64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r19
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xea0421d8  ! 1: LDUW_I	lduw	[%r16 + 0x01d8], %r21
	.word 0xf80c2ffa  ! 1: LDUB_I	ldub	[%r16 + 0x0ffa], %r28
	.word 0xf244256c  ! 1: LDSW_I	ldsw	[%r16 + 0x056c], %r25
	brnz %r31,thr3_loop_cnt_139
	dec %r31
	.word 0x86142878  ! 1: OR_I	or 	%r16, 0x0878, %r3
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x49, %r31
thr3_loop_cnt_140:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xda440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r13
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r26
	.word 0xde140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r15
	.word 0xea4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r21
	.word 0xc6d429e6  ! 1: LDSHA_I	ldsha	[%r16, + 0x09e6] %asi, %r3
	.word 0xf6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r27
	brnz %r31,thr3_loop_cnt_140
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x86142943  ! 1: OR_I	or 	%r16, 0x0943, %r3
	.word 0x8634263e  ! 1: ORN_I	orn 	%r16, 0x063e, %r3
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0x8a, %r31
thr3_loop_cnt_141:
	.word 0xe40c2e5d  ! 1: LDUB_I	ldub	[%r16 + 0x0e5d], %r18
	.word 0xc65c26b8  ! 1: LDX_I	ldx	[%r16 + 0x06b8], %r3
	.word 0xc6c429b4  ! 1: LDSWA_I	ldswa	[%r16, + 0x09b4] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xea5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r21
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd0cc264f  ! 1: LDSBA_I	ldsba	[%r16, + 0x064f] %asi, %r8
	.word 0xd6542c50  ! 1: LDSH_I	ldsh	[%r16 + 0x0c50], %r11
	.word 0xdad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r13
	.word 0xf84429e0  ! 1: LDSW_I	ldsw	[%r16 + 0x09e0], %r28
	.word 0xec0c2ff5  ! 1: LDUB_I	ldub	[%r16 + 0x0ff5], %r22
	.word 0xd4842544  ! 1: LDUWA_I	lduwa	[%r16, + 0x0544] %asi, %r10
	brnz %r31,thr3_loop_cnt_141
	dec %r31
	.word 0x86342cc5  ! 1: ORN_I	orn 	%r16, 0x0cc5, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x8f3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r7
        mov 0x7e, %r31
thr3_loop_cnt_142:
	.word 0xc6c42068  ! 1: LDSWA_I	ldswa	[%r16, + 0x0068] %asi, %r3
	.word 0xc6142190  ! 1: LDUH_I	lduh	[%r16 + 0x0190], %r3
	.word 0xf0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r24
	.word 0xe6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r19
	.word 0xfa0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r29
	.word 0xfacc2222  ! 1: LDSBA_I	ldsba	[%r16, + 0x0222] %asi, %r29
	.word 0xd8d427f6  ! 1: LDSHA_I	ldsha	[%r16, + 0x07f6] %asi, %r12
	.word 0xc6c427d4  ! 1: LDSWA_I	ldswa	[%r16, + 0x07d4] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r26
	brnz %r31,thr3_loop_cnt_142
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0x3, %r31
thr3_loop_cnt_143:
	.word 0xdc842470  ! 1: LDUWA_I	lduwa	[%r16, + 0x0470] %asi, %r14
	.word 0xdecc2600  ! 1: LDSBA_I	ldsba	[%r16, + 0x0600] %asi, %r15
	.word 0xf4442c24  ! 1: LDSW_I	ldsw	[%r16 + 0x0c24], %r26
	.word 0xe4142eca  ! 1: LDUH_I	lduh	[%r16 + 0x0eca], %r18
	.word 0xee440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r23
	.word 0xc64c276f  ! 1: LDSB_I	ldsb	[%r16 + 0x076f], %r3
	.word 0xd2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r9
	.word 0xd2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r9
	.word 0xc64427a8  ! 1: LDSW_I	ldsw	[%r16 + 0x07a8], %r3
	.word 0xdac42e5c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e5c] %asi, %r13
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_143
	dec %r31
	.word 0xa824252e  ! 1: SUB_I	sub 	%r16, 0x052e, %r20
	.word 0x9d342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r14
	.word 0xa72c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r19
	.word 0xb01c0002  ! 1: XOR_R	xor 	%r16, %r2, %r24
        mov 0x74, %r31
thr3_loop_cnt_144:
	.word 0xc6cc26cc  ! 1: LDSBA_I	ldsba	[%r16, + 0x06cc] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc68423b4  ! 1: LDUWA_I	lduwa	[%r16, + 0x03b4] %asi, %r3
	.word 0xc6842834  ! 1: LDUWA_I	lduwa	[%r16, + 0x0834] %asi, %r3
	.word 0xf60c2d07  ! 1: LDUB_I	ldub	[%r16 + 0x0d07], %r27
	.word 0xda5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r13
	.word 0xc68c2a22  ! 1: LDUBA_I	lduba	[%r16, + 0x0a22] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_144
	dec %r31
	.word 0xb64426c1  ! 1: ADDC_I	addc 	%r16, 0x06c1, %r27
        mov 0x96, %r31
thr3_loop_cnt_145:
	.word 0xd00c2411  ! 1: LDUB_I	ldub	[%r16 + 0x0411], %r8
	.word 0xf4dc25d0  ! 1: LDXA_I	ldxa	[%r16, + 0x05d0] %asi, %r26
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r24
	.word 0xfa841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r29
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_145
	dec %r31
        mov 0x23, %r31
thr3_loop_cnt_146:
	.word 0xea040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r21
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6dc2828  ! 1: LDXA_I	ldxa	[%r16, + 0x0828] %asi, %r3
	.word 0xc6dc2b78  ! 1: LDXA_I	ldxa	[%r16, + 0x0b78] %asi, %r3
	.word 0xc6dc2220  ! 1: LDXA_I	ldxa	[%r16, + 0x0220] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xe64422d8  ! 1: LDSW_I	ldsw	[%r16 + 0x02d8], %r19
	.word 0xecc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r22
	brnz %r31,thr3_loop_cnt_146
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x86342d1f  ! 1: SUBC_I	orn 	%r16, 0x0d1f, %r3
	.word 0x862c2e8a  ! 1: ANDN_I	andn 	%r16, 0x0e8a, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0x3e, %r31
thr3_loop_cnt_147:
	.word 0xccdc26a8  ! 1: LDXA_I	ldxa	[%r16, + 0x06a8] %asi, %r6
	.word 0xf0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r24
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf0542694  ! 1: LDSH_I	ldsh	[%r16 + 0x0694], %r24
	.word 0xd4042bb0  ! 1: LDUW_I	lduw	[%r16 + 0x0bb0], %r10
	.word 0xc6442134  ! 1: LDSW_I	ldsw	[%r16 + 0x0134], %r3
	.word 0xf4542552  ! 1: LDSH_I	ldsh	[%r16 + 0x0552], %r26
	.word 0xe4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r18
	.word 0xcc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r6
	.word 0xde5c27b8  ! 1: LDX_I	ldx	[%r16 + 0x07b8], %r15
	.word 0xe414263e  ! 1: LDUH_I	lduh	[%r16 + 0x063e], %r18
	brnz %r31,thr3_loop_cnt_147
	dec %r31
	.word 0x9c340002  ! 1: SUBC_R	orn 	%r16, %r2, %r14
	.word 0x963c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r11
        mov 0xa3, %r31
thr3_loop_cnt_148:
	.word 0xc6cc20d8  ! 1: LDSBA_I	ldsba	[%r16, + 0x00d8] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6442b54  ! 1: LDSW_I	ldsw	[%r16 + 0x0b54], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc60c2c07  ! 1: LDUB_I	ldub	[%r16 + 0x0c07], %r3
	.word 0xd8542622  ! 1: LDSH_I	ldsh	[%r16 + 0x0622], %r12
	.word 0xd0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r8
	.word 0xc68c2c31  ! 1: LDUBA_I	lduba	[%r16, + 0x0c31] %asi, %r3
	brnz %r31,thr3_loop_cnt_148
	dec %r31
	.word 0x8d2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r6
        mov 0x2f, %r31
thr3_loop_cnt_149:
	.word 0xe68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r19
	.word 0xc64c274a  ! 1: LDSB_I	ldsb	[%r16 + 0x074a], %r3
	.word 0xc6cc22a4  ! 1: LDSBA_I	ldsba	[%r16, + 0x02a4] %asi, %r3
	.word 0xec040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r22
	.word 0xc6942482  ! 1: LDUHA_I	lduha	[%r16, + 0x0482] %asi, %r3
	.word 0xf6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r27
	.word 0xc68429b4  ! 1: LDUWA_I	lduwa	[%r16, + 0x09b4] %asi, %r3
	.word 0xc604251c  ! 1: LDUW_I	lduw	[%r16 + 0x051c], %r3
	.word 0xe80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r20
	.word 0xc68c2b6e  ! 1: LDUBA_I	lduba	[%r16, + 0x0b6e] %asi, %r3
	brnz %r31,thr3_loop_cnt_149
	dec %r31
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x982429a5  ! 1: SUB_I	sub 	%r16, 0x09a5, %r12
        mov 0xaa, %r31
thr3_loop_cnt_150:
	.word 0xc60c2a33  ! 1: LDUB_I	ldub	[%r16 + 0x0a33], %r3
	.word 0xfa4c296a  ! 1: LDSB_I	ldsb	[%r16 + 0x096a], %r29
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xc60c2519  ! 1: LDUB_I	ldub	[%r16 + 0x0519], %r3
	.word 0xc6d42e2c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e2c] %asi, %r3
	.word 0xc6cc2feb  ! 1: LDSBA_I	ldsba	[%r16, + 0x0feb] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6842778  ! 1: LDUWA_I	lduwa	[%r16, + 0x0778] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xec5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r22
	.word 0xc68c2592  ! 1: LDUBA_I	lduba	[%r16, + 0x0592] %asi, %r3
	brnz %r31,thr3_loop_cnt_150
	dec %r31
        mov 0xb, %r31
thr3_loop_cnt_151:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xdcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r14
	.word 0xec941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r22
	.word 0xc6cc2e7d  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e7d] %asi, %r3
	.word 0xd6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r11
	.word 0xe8142f70  ! 1: LDUH_I	lduh	[%r16 + 0x0f70], %r20
	.word 0xf24c24f3  ! 1: LDSB_I	ldsb	[%r16 + 0x04f3], %r25
	.word 0xec0c22c1  ! 1: LDUB_I	ldub	[%r16 + 0x02c1], %r22
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xc68c2eac  ! 1: LDUBA_I	lduba	[%r16, + 0x0eac] %asi, %r3
	brnz %r31,thr3_loop_cnt_151
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x70, %r31
thr3_loop_cnt_152:
	.word 0xdad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r13
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xd40c2532  ! 1: LDUB_I	ldub	[%r16 + 0x0532], %r10
	.word 0xda841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r13
	.word 0xfc9425c2  ! 1: LDUHA_I	lduha	[%r16, + 0x05c2] %asi, %r30
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xc6842284  ! 1: LDUWA_I	lduwa	[%r16, + 0x0284] %asi, %r3
	.word 0xfc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r30
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf6142d0a  ! 1: LDUH_I	lduh	[%r16 + 0x0d0a], %r27
	brnz %r31,thr3_loop_cnt_152
	dec %r31
        mov 0x3c, %r31
thr3_loop_cnt_153:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6cc2064  ! 1: LDSBA_I	ldsba	[%r16, + 0x0064] %asi, %r3
	.word 0xc65c2588  ! 1: LDX_I	ldx	[%r16 + 0x0588], %r3
	.word 0xc654222c  ! 1: LDSH_I	ldsh	[%r16 + 0x022c], %r3
	.word 0xc6542e0e  ! 1: LDSH_I	ldsh	[%r16 + 0x0e0e], %r3
	.word 0xd8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r12
	.word 0xc6d4209c  ! 1: LDSHA_I	ldsha	[%r16, + 0x009c] %asi, %r3
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xda5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r13
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_153
	dec %r31
	.word 0x861c2ac6  ! 1: XOR_I	xor 	%r16, 0x0ac6, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x86342064  ! 1: ORN_I	orn 	%r16, 0x0064, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x64, %r31
thr3_loop_cnt_154:
	.word 0xc6442884  ! 1: LDSW_I	ldsw	[%r16 + 0x0884], %r3
	.word 0xea8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r21
	.word 0xf6842468  ! 1: LDUWA_I	lduwa	[%r16, + 0x0468] %asi, %r27
	.word 0xc64c24da  ! 1: LDSB_I	ldsb	[%r16 + 0x04da], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6142eb4  ! 1: LDUH_I	lduh	[%r16 + 0x0eb4], %r3
	.word 0xc644228c  ! 1: LDSW_I	ldsw	[%r16 + 0x028c], %r3
	.word 0xd204289c  ! 1: LDUW_I	lduw	[%r16 + 0x089c], %r9
	.word 0xd44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r10
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_154
	dec %r31
	.word 0x86242c35  ! 1: SUB_I	sub 	%r16, 0x0c35, %r3
	.word 0x860c2249  ! 1: AND_I	and 	%r16, 0x0249, %r3
        mov 0xb8, %r31
thr3_loop_cnt_155:
	.word 0xc64c2e2a  ! 1: LDSB_I	ldsb	[%r16 + 0x0e2a], %r3
	.word 0xc6cc20fd  ! 1: LDSBA_I	ldsba	[%r16, + 0x00fd] %asi, %r3
	.word 0xc6942594  ! 1: LDUHA_I	lduha	[%r16, + 0x0594] %asi, %r3
	.word 0xec841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r22
	.word 0xc614209c  ! 1: LDUH_I	lduh	[%r16 + 0x009c], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xce0429d0  ! 1: LDUW_I	lduw	[%r16 + 0x09d0], %r7
	.word 0xc69425fc  ! 1: LDUHA_I	lduha	[%r16, + 0x05fc] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc68c2a5c  ! 1: LDUBA_I	lduba	[%r16, + 0x0a5c] %asi, %r3
	brnz %r31,thr3_loop_cnt_155
	dec %r31
	.word 0xb01c0002  ! 1: XOR_R	xor 	%r16, %r2, %r24
	.word 0x8e2c290d  ! 1: ANDN_I	andn 	%r16, 0x090d, %r7
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x2d, %r31
thr3_loop_cnt_156:
	.word 0xdccc2696  ! 1: LDSBA_I	ldsba	[%r16, + 0x0696] %asi, %r14
	.word 0xc6042930  ! 1: LDUW_I	lduw	[%r16 + 0x0930], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc68c2356  ! 1: LDUBA_I	lduba	[%r16, + 0x0356] %asi, %r3
	.word 0xc64c2c19  ! 1: LDSB_I	ldsb	[%r16 + 0x0c19], %r3
	.word 0xc6dc2908  ! 1: LDXA_I	ldxa	[%r16, + 0x0908] %asi, %r3
	.word 0xdccc26c4  ! 1: LDSBA_I	ldsba	[%r16, + 0x06c4] %asi, %r14
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc24c0  ! 1: LDSBA_I	ldsba	[%r16, + 0x04c0] %asi, %r3
	.word 0xcc842c54  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c54] %asi, %r6
	brnz %r31,thr3_loop_cnt_156
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x960c0002  ! 1: AND_R	and 	%r16, %r2, %r11
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x64, %r31
thr3_loop_cnt_157:
	.word 0xd6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r11
	.word 0xcc9420da  ! 1: LDUHA_I	lduha	[%r16, + 0x00da] %asi, %r6
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6842af4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0af4] %asi, %r3
	.word 0xc6dc2b90  ! 1: LDXA_I	ldxa	[%r16, + 0x0b90] %asi, %r3
	.word 0xdecc2aaa  ! 1: LDSBA_I	ldsba	[%r16, + 0x0aaa] %asi, %r15
	.word 0xc68c2ac1  ! 1: LDUBA_I	lduba	[%r16, + 0x0ac1] %asi, %r3
	.word 0xc6dc2b40  ! 1: LDXA_I	ldxa	[%r16, + 0x0b40] %asi, %r3
	.word 0xf0942cf2  ! 1: LDUHA_I	lduha	[%r16, + 0x0cf2] %asi, %r24
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_157
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0x76, %r31
thr3_loop_cnt_158:
	.word 0xc6842a84  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a84] %asi, %r3
	.word 0xe4dc26e8  ! 1: LDXA_I	ldxa	[%r16, + 0x06e8] %asi, %r18
	.word 0xec8c23ce  ! 1: LDUBA_I	lduba	[%r16, + 0x03ce] %asi, %r22
	.word 0xf6042fa8  ! 1: LDUW_I	lduw	[%r16 + 0x0fa8], %r27
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc60c2ca7  ! 1: LDUB_I	ldub	[%r16 + 0x0ca7], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc65c2a30  ! 1: LDX_I	ldx	[%r16 + 0x0a30], %r3
	brnz %r31,thr3_loop_cnt_158
	dec %r31
	.word 0xb12c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r24
	.word 0xa93c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r20
	.word 0xa72c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r19
        mov 0x5d, %r31
thr3_loop_cnt_159:
	.word 0xda942fc8  ! 1: LDUHA_I	lduha	[%r16, + 0x0fc8] %asi, %r13
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r9
	.word 0xea440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r21
	.word 0xd4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r10
	.word 0xc6442128  ! 1: LDSW_I	ldsw	[%r16 + 0x0128], %r3
	.word 0xf28424fc  ! 1: LDUWA_I	lduwa	[%r16, + 0x04fc] %asi, %r25
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xeacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r21
	.word 0xe6542934  ! 1: LDSH_I	ldsh	[%r16 + 0x0934], %r19
	brnz %r31,thr3_loop_cnt_159
	dec %r31
	.word 0x95342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r10
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x3, %r31
thr3_loop_cnt_160:
	.word 0xc684239c  ! 1: LDUWA_I	lduwa	[%r16, + 0x039c] %asi, %r3
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc694244c  ! 1: LDUHA_I	lduha	[%r16, + 0x044c] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r19
	.word 0xf28c2d46  ! 1: LDUBA_I	lduba	[%r16, + 0x0d46] %asi, %r25
	.word 0xc6042758  ! 1: LDUW_I	lduw	[%r16 + 0x0758], %r3
	.word 0xe8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r20
	brnz %r31,thr3_loop_cnt_160
	dec %r31
	.word 0x91342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r8
	.word 0x8e040002  ! 1: ADD_R	add 	%r16, %r2, %r7
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x86342ac5  ! 1: SUBC_I	orn 	%r16, 0x0ac5, %r3
        mov 0x0, %r31
thr3_loop_cnt_161:
	.word 0xf8d42d5c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d5c] %asi, %r28
	.word 0xcc542004  ! 1: LDSH_I	ldsh	[%r16 + 0x0004], %r6
	.word 0xc6c42254  ! 1: LDSWA_I	ldswa	[%r16, + 0x0254] %asi, %r3
	.word 0xc6842e58  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e58] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r25
	.word 0xc60421f8  ! 1: LDUW_I	lduw	[%r16 + 0x01f8], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xec942638  ! 1: LDUHA_I	lduha	[%r16, + 0x0638] %asi, %r22
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6842d30  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d30] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_161
	dec %r31
	.word 0xaf343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r23
        mov 0xad, %r31
thr3_loop_cnt_162:
	.word 0xea8c2438  ! 1: LDUBA_I	lduba	[%r16, + 0x0438] %asi, %r21
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xe6942cae  ! 1: LDUHA_I	lduha	[%r16, + 0x0cae] %asi, %r19
	.word 0xe6d429d8  ! 1: LDSHA_I	ldsha	[%r16, + 0x09d8] %asi, %r19
	.word 0xce440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r7
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xdc0425e0  ! 1: LDUW_I	lduw	[%r16 + 0x05e0], %r14
	brnz %r31,thr3_loop_cnt_162
	dec %r31
	.word 0x860c2605  ! 1: AND_I	and 	%r16, 0x0605, %r3
	.word 0xa3340002  ! 1: SRL_R	srl 	%r16, %r2, %r17
	.word 0x860423d1  ! 1: ADD_I	add 	%r16, 0x03d1, %r3
        mov 0x84, %r31
thr3_loop_cnt_163:
	.word 0xc60c2aa0  ! 1: LDUB_I	ldub	[%r16 + 0x0aa0], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r8
	.word 0xc6142e78  ! 1: LDUH_I	lduh	[%r16 + 0x0e78], %r3
	.word 0xc68c2a1b  ! 1: LDUBA_I	lduba	[%r16, + 0x0a1b] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r18
	brnz %r31,thr3_loop_cnt_163
	dec %r31
	.word 0x861c2bb3  ! 1: XOR_I	xor 	%r16, 0x0bb3, %r3
	.word 0xb13c1002  ! 1: SRAX_R	srax	%r16, %r2, %r24
	.word 0xa61c2531  ! 1: XOR_I	xor 	%r16, 0x0531, %r19
	.word 0xb8140002  ! 1: OR_R	or 	%r16, %r2, %r28
        mov 0x3c, %r31
thr3_loop_cnt_164:
	.word 0xc6842a10  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a10] %asi, %r3
	.word 0xf4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r26
	.word 0xf29420d4  ! 1: LDUHA_I	lduha	[%r16, + 0x00d4] %asi, %r25
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc60c20b8  ! 1: LDUB_I	ldub	[%r16 + 0x00b8], %r3
	.word 0xc64c2633  ! 1: LDSB_I	ldsb	[%r16 + 0x0633], %r3
	.word 0xc60c2201  ! 1: LDUB_I	ldub	[%r16 + 0x0201], %r3
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xee4c2279  ! 1: LDSB_I	ldsb	[%r16 + 0x0279], %r23
	.word 0xf6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r27
	brnz %r31,thr3_loop_cnt_164
	dec %r31
	.word 0x9b341002  ! 1: SRLX_R	srlx	%r16, %r2, %r13
	.word 0x864429a9  ! 1: ADDC_I	addc 	%r16, 0x09a9, %r3
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0xaa, %r31
thr3_loop_cnt_165:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xfc942796  ! 1: LDUHA_I	lduha	[%r16, + 0x0796] %asi, %r30
	.word 0xc6042f78  ! 1: LDUW_I	lduw	[%r16 + 0x0f78], %r3
	.word 0xc68c263d  ! 1: LDUBA_I	lduba	[%r16, + 0x063d] %asi, %r3
	.word 0xea8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r21
	.word 0xfa5c26c0  ! 1: LDX_I	ldx	[%r16 + 0x06c0], %r29
	.word 0xc60c29fa  ! 1: LDUB_I	ldub	[%r16 + 0x09fa], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6042db8  ! 1: LDUW_I	lduw	[%r16 + 0x0db8], %r3
	brnz %r31,thr3_loop_cnt_165
	dec %r31
	.word 0xb13c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r24
	.word 0xbb3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r29
        mov 0x46, %r31
thr3_loop_cnt_166:
	.word 0xcc94263a  ! 1: LDUHA_I	lduha	[%r16, + 0x063a] %asi, %r6
	.word 0xfa4c2d62  ! 1: LDSB_I	ldsb	[%r16 + 0x0d62], %r29
	.word 0xc654295c  ! 1: LDSH_I	ldsh	[%r16 + 0x095c], %r3
	.word 0xc68c2745  ! 1: LDUBA_I	lduba	[%r16, + 0x0745] %asi, %r3
	.word 0xc64c2b75  ! 1: LDSB_I	ldsb	[%r16 + 0x0b75], %r3
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xc6542952  ! 1: LDSH_I	ldsh	[%r16 + 0x0952], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xe60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r19
	.word 0xec142970  ! 1: LDUH_I	lduh	[%r16 + 0x0970], %r22
	.word 0xe2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r17
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_166
	dec %r31
	.word 0xae1c2efb  ! 1: XOR_I	xor 	%r16, 0x0efb, %r23
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x86342e82  ! 1: SUBC_I	orn 	%r16, 0x0e82, %r3
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x67, %r31
thr3_loop_cnt_167:
	.word 0xd4842064  ! 1: LDUWA_I	lduwa	[%r16, + 0x0064] %asi, %r10
	.word 0xe8042e70  ! 1: LDUW_I	lduw	[%r16 + 0x0e70], %r20
	.word 0xc6442018  ! 1: LDSW_I	ldsw	[%r16 + 0x0018], %r3
	.word 0xc60c28cb  ! 1: LDUB_I	ldub	[%r16 + 0x08cb], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc68c2f0c  ! 1: LDUBA_I	lduba	[%r16, + 0x0f0c] %asi, %r3
	.word 0xce042118  ! 1: LDUW_I	lduw	[%r16 + 0x0118], %r7
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xce4c2b23  ! 1: LDSB_I	ldsb	[%r16 + 0x0b23], %r7
	brnz %r31,thr3_loop_cnt_167
	dec %r31
        mov 0xa6, %r31
thr3_loop_cnt_168:
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	.word 0xc61420e8  ! 1: LDUH_I	lduh	[%r16 + 0x00e8], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc60c20ca  ! 1: LDUB_I	ldub	[%r16 + 0x00ca], %r3
	.word 0xc61421b4  ! 1: LDUH_I	lduh	[%r16 + 0x01b4], %r3
	.word 0xee5c2a20  ! 1: LDX_I	ldx	[%r16 + 0x0a20], %r23
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xee14271c  ! 1: LDUH_I	lduh	[%r16 + 0x071c], %r23
	.word 0xf454202a  ! 1: LDSH_I	ldsh	[%r16 + 0x002a], %r26
	.word 0xd65420fa  ! 1: LDSH_I	ldsh	[%r16 + 0x00fa], %r11
	brnz %r31,thr3_loop_cnt_168
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x91340002  ! 1: SRL_R	srl 	%r16, %r2, %r8
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0x44, %r31
thr3_loop_cnt_169:
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xe6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r19
	.word 0xf45c24b0  ! 1: LDX_I	ldx	[%r16 + 0x04b0], %r26
	.word 0xc6842184  ! 1: LDUWA_I	lduwa	[%r16, + 0x0184] %asi, %r3
	.word 0xea8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r21
	.word 0xd2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r9
	.word 0xeedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r23
	.word 0xf29423ec  ! 1: LDUHA_I	lduha	[%r16, + 0x03ec] %asi, %r25
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6142f1e  ! 1: LDUH_I	lduh	[%r16 + 0x0f1e], %r3
	.word 0xc68c22ea  ! 1: LDUBA_I	lduba	[%r16, + 0x02ea] %asi, %r3
	brnz %r31,thr3_loop_cnt_169
	dec %r31
        mov 0x1e, %r31
thr3_loop_cnt_170:
	.word 0xec0427f0  ! 1: LDUW_I	lduw	[%r16 + 0x07f0], %r22
	.word 0xf45426da  ! 1: LDSH_I	ldsh	[%r16 + 0x06da], %r26
	.word 0xe48424c0  ! 1: LDUWA_I	lduwa	[%r16, + 0x04c0] %asi, %r18
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r8
	.word 0xc6c42f6c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f6c] %asi, %r3
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xc65424b8  ! 1: LDSH_I	ldsh	[%r16 + 0x04b8], %r3
	.word 0xc6142cf0  ! 1: LDUH_I	lduh	[%r16 + 0x0cf0], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2150  ! 1: LDXA_I	ldxa	[%r16, + 0x0150] %asi, %r3
	brnz %r31,thr3_loop_cnt_170
	dec %r31
	.word 0x862c277b  ! 1: ANDN_I	andn 	%r16, 0x077b, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x4, %r31
thr3_loop_cnt_171:
	.word 0xc60425fc  ! 1: LDUW_I	lduw	[%r16 + 0x05fc], %r3
	.word 0xc6d42612  ! 1: LDSHA_I	ldsha	[%r16, + 0x0612] %asi, %r3
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	.word 0xcecc2b46  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b46] %asi, %r7
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc614267e  ! 1: LDUH_I	lduh	[%r16 + 0x067e], %r3
	.word 0xe8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r20
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_171
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0xa73c0002  ! 1: SRA_R	sra 	%r16, %r2, %r19
        mov 0xc7, %r31
thr3_loop_cnt_172:
	.word 0xc6cc287a  ! 1: LDSBA_I	ldsba	[%r16, + 0x087a] %asi, %r3
	.word 0xe4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r18
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc68427cc  ! 1: LDUWA_I	lduwa	[%r16, + 0x07cc] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc65c2210  ! 1: LDX_I	ldx	[%r16 + 0x0210], %r3
	brnz %r31,thr3_loop_cnt_172
	dec %r31
	.word 0xa23c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r17
	.word 0x9e0c0002  ! 1: AND_R	and 	%r16, %r2, %r15
	.word 0x933c0002  ! 1: SRA_R	sra 	%r16, %r2, %r9
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0xc6, %r31
thr3_loop_cnt_173:
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xd4dc27b0  ! 1: LDXA_I	ldxa	[%r16, + 0x07b0] %asi, %r10
	.word 0xeecc2ed9  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ed9] %asi, %r23
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xcc5c25a0  ! 1: LDX_I	ldx	[%r16 + 0x05a0], %r6
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r12
	.word 0xf60c24a6  ! 1: LDUB_I	ldub	[%r16 + 0x04a6], %r27
	.word 0xc6942250  ! 1: LDUHA_I	lduha	[%r16, + 0x0250] %asi, %r3
	.word 0xc6d425ca  ! 1: LDSHA_I	ldsha	[%r16, + 0x05ca] %asi, %r3
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	brnz %r31,thr3_loop_cnt_173
	dec %r31
	.word 0xb02c26e9  ! 1: ANDN_I	andn 	%r16, 0x06e9, %r24
        mov 0x3c, %r31
thr3_loop_cnt_174:
	.word 0xde140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r15
	.word 0xec542b22  ! 1: LDSH_I	ldsh	[%r16 + 0x0b22], %r22
	.word 0xee0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r23
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc64c2c5d  ! 1: LDSB_I	ldsb	[%r16 + 0x0c5d], %r3
	.word 0xd0dc2f18  ! 1: LDXA_I	ldxa	[%r16, + 0x0f18] %asi, %r8
	.word 0xc65c2338  ! 1: LDX_I	ldx	[%r16 + 0x0338], %r3
	.word 0xc6542e24  ! 1: LDSH_I	ldsh	[%r16 + 0x0e24], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_174
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
        mov 0x86, %r31
thr3_loop_cnt_175:
	.word 0xea8c21ef  ! 1: LDUBA_I	lduba	[%r16, + 0x01ef] %asi, %r21
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6042950  ! 1: LDUW_I	lduw	[%r16 + 0x0950], %r3
	.word 0xeac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r21
	.word 0xe8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r20
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6542c86  ! 1: LDSH_I	ldsh	[%r16 + 0x0c86], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc64c2d94  ! 1: LDSB_I	ldsb	[%r16 + 0x0d94], %r3
	brnz %r31,thr3_loop_cnt_175
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0xac140002  ! 1: OR_R	or 	%r16, %r2, %r22
        mov 0x5b, %r31
thr3_loop_cnt_176:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6442f40  ! 1: LDSW_I	ldsw	[%r16 + 0x0f40], %r3
	.word 0xcc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r6
	.word 0xc6dc2708  ! 1: LDXA_I	ldxa	[%r16, + 0x0708] %asi, %r3
	.word 0xc6042934  ! 1: LDUW_I	lduw	[%r16 + 0x0934], %r3
	.word 0xe8dc2b28  ! 1: LDXA_I	ldxa	[%r16, + 0x0b28] %asi, %r20
	.word 0xe894260e  ! 1: LDUHA_I	lduha	[%r16, + 0x060e] %asi, %r20
	.word 0xc69429a0  ! 1: LDUHA_I	lduha	[%r16, + 0x09a0] %asi, %r3
	brnz %r31,thr3_loop_cnt_176
	dec %r31
        mov 0x6c, %r31
thr3_loop_cnt_177:
	.word 0xc6cc2f05  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f05] %asi, %r3
	.word 0xc68c2bb4  ! 1: LDUBA_I	lduba	[%r16, + 0x0bb4] %asi, %r3
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r28
	.word 0xc60c211c  ! 1: LDUB_I	ldub	[%r16 + 0x011c], %r3
	.word 0xc6dc2bf8  ! 1: LDXA_I	ldxa	[%r16, + 0x0bf8] %asi, %r3
	.word 0xd2dc27f0  ! 1: LDXA_I	ldxa	[%r16, + 0x07f0] %asi, %r9
	.word 0xd68c291b  ! 1: LDUBA_I	lduba	[%r16, + 0x091b] %asi, %r11
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6d4267e  ! 1: LDSHA_I	ldsha	[%r16, + 0x067e] %asi, %r3
	.word 0xc6cc29e8  ! 1: LDSBA_I	ldsba	[%r16, + 0x09e8] %asi, %r3
	brnz %r31,thr3_loop_cnt_177
	dec %r31
        mov 0x65, %r31
thr3_loop_cnt_178:
	.word 0xc6dc22e8  ! 1: LDXA_I	ldxa	[%r16, + 0x02e8] %asi, %r3
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	.word 0xc6c4273c  ! 1: LDSWA_I	ldswa	[%r16, + 0x073c] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xee942ce8  ! 1: LDUHA_I	lduha	[%r16, + 0x0ce8] %asi, %r23
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	.word 0xf85c28b0  ! 1: LDX_I	ldx	[%r16 + 0x08b0], %r28
	.word 0xc6042cf4  ! 1: LDUW_I	lduw	[%r16 + 0x0cf4], %r3
	.word 0xc65c28a0  ! 1: LDX_I	ldx	[%r16 + 0x08a0], %r3
	brnz %r31,thr3_loop_cnt_178
	dec %r31
	.word 0xb6042f3b  ! 1: ADD_I	add 	%r16, 0x0f3b, %r27
        mov 0x5, %r31
thr3_loop_cnt_179:
	.word 0xde5c2578  ! 1: LDX_I	ldx	[%r16 + 0x0578], %r15
	.word 0xea8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r21
	.word 0xc60c2e88  ! 1: LDUB_I	ldub	[%r16 + 0x0e88], %r3
	.word 0xc6c428dc  ! 1: LDSWA_I	ldswa	[%r16, + 0x08dc] %asi, %r3
	.word 0xe48422a0  ! 1: LDUWA_I	lduwa	[%r16, + 0x02a0] %asi, %r18
	.word 0xd05428a4  ! 1: LDSH_I	ldsh	[%r16 + 0x08a4], %r8
	.word 0xde942c50  ! 1: LDUHA_I	lduha	[%r16, + 0x0c50] %asi, %r15
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe6142d8a  ! 1: LDUH_I	lduh	[%r16 + 0x0d8a], %r19
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_179
	dec %r31
	.word 0x941c25c6  ! 1: XOR_I	xor 	%r16, 0x05c6, %r10
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x9c1421c9  ! 1: OR_I	or 	%r16, 0x01c9, %r14
        mov 0x50, %r31
thr3_loop_cnt_180:
	.word 0xc60c23f6  ! 1: LDUB_I	ldub	[%r16 + 0x03f6], %r3
	.word 0xc6cc26b6  ! 1: LDSBA_I	ldsba	[%r16, + 0x06b6] %asi, %r3
	.word 0xc61423b2  ! 1: LDUH_I	lduh	[%r16 + 0x03b2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc68c2a61  ! 1: LDUBA_I	lduba	[%r16, + 0x0a61] %asi, %r3
	brnz %r31,thr3_loop_cnt_180
	dec %r31
	.word 0xa2442aa8  ! 1: ADDC_I	addc 	%r16, 0x0aa8, %r17
        mov 0xc4, %r31
thr3_loop_cnt_181:
	.word 0xc68c2067  ! 1: LDUBA_I	lduba	[%r16, + 0x0067] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xde9425ea  ! 1: LDUHA_I	lduha	[%r16, + 0x05ea] %asi, %r15
	.word 0xc61424dc  ! 1: LDUH_I	lduh	[%r16 + 0x04dc], %r3
	.word 0xea0429f4  ! 1: LDUW_I	lduw	[%r16 + 0x09f4], %r21
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xfccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r30
	.word 0xe8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r20
	.word 0xeccc20fb  ! 1: LDSBA_I	ldsba	[%r16, + 0x00fb] %asi, %r22
	brnz %r31,thr3_loop_cnt_181
	dec %r31
	.word 0x960427e5  ! 1: ADD_I	add 	%r16, 0x07e5, %r11
	.word 0xbc0c2a1f  ! 1: AND_I	and 	%r16, 0x0a1f, %r30
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0xa7, %r31
thr3_loop_cnt_182:
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xcc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r6
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc68c24de  ! 1: LDUBA_I	lduba	[%r16, + 0x04de] %asi, %r3
	.word 0xc6cc2944  ! 1: LDSBA_I	ldsba	[%r16, + 0x0944] %asi, %r3
	.word 0xc6cc24c5  ! 1: LDSBA_I	ldsba	[%r16, + 0x04c5] %asi, %r3
	.word 0xf85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r28
	brnz %r31,thr3_loop_cnt_182
	dec %r31
	.word 0x98040002  ! 1: ADD_R	add 	%r16, %r2, %r12
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x92240002  ! 1: SUB_R	sub 	%r16, %r2, %r9
	.word 0x99343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r12
        mov 0x79, %r31
thr3_loop_cnt_183:
	.word 0xccdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r6
	.word 0xd8cc2a80  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a80] %asi, %r12
	.word 0xc6442644  ! 1: LDSW_I	ldsw	[%r16 + 0x0644], %r3
	.word 0xc65c2ad0  ! 1: LDX_I	ldx	[%r16 + 0x0ad0], %r3
	.word 0xc64c2496  ! 1: LDSB_I	ldsb	[%r16 + 0x0496], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd4dc2ee0  ! 1: LDXA_I	ldxa	[%r16, + 0x0ee0] %asi, %r10
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc68c28f7  ! 1: LDUBA_I	lduba	[%r16, + 0x08f7] %asi, %r3
	.word 0xce042f38  ! 1: LDUW_I	lduw	[%r16 + 0x0f38], %r7
	brnz %r31,thr3_loop_cnt_183
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0x36, %r31
thr3_loop_cnt_184:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf28426ac  ! 1: LDUWA_I	lduwa	[%r16, + 0x06ac] %asi, %r25
	.word 0xf6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r27
	.word 0xc64429a4  ! 1: LDSW_I	ldsw	[%r16 + 0x09a4], %r3
	.word 0xccc4253c  ! 1: LDSWA_I	ldswa	[%r16, + 0x053c] %asi, %r6
	.word 0xc6542d16  ! 1: LDSH_I	ldsh	[%r16 + 0x0d16], %r3
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xd4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r10
	.word 0xc6d42fc6  ! 1: LDSHA_I	ldsha	[%r16, + 0x0fc6] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc60422d8  ! 1: LDUW_I	lduw	[%r16 + 0x02d8], %r3
	brnz %r31,thr3_loop_cnt_184
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0xa33c1002  ! 1: SRAX_R	srax	%r16, %r2, %r17
        mov 0xa8, %r31
thr3_loop_cnt_185:
	.word 0xdc1423c4  ! 1: LDUH_I	lduh	[%r16 + 0x03c4], %r14
	.word 0xc6d42d2e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d2e] %asi, %r3
	.word 0xfa4c28e7  ! 1: LDSB_I	ldsb	[%r16 + 0x08e7], %r29
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xc6042760  ! 1: LDUW_I	lduw	[%r16 + 0x0760], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xcc8c2161  ! 1: LDUBA_I	lduba	[%r16, + 0x0161] %asi, %r6
	brnz %r31,thr3_loop_cnt_185
	dec %r31
	.word 0x86342a79  ! 1: ORN_I	orn 	%r16, 0x0a79, %r3
	.word 0x861c2a11  ! 1: XOR_I	xor 	%r16, 0x0a11, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x86142470  ! 1: OR_I	or 	%r16, 0x0470, %r3
        mov 0xb9, %r31
thr3_loop_cnt_186:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6142dd6  ! 1: LDUH_I	lduh	[%r16 + 0x0dd6], %r3
	.word 0xe64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r19
	.word 0xd69427e2  ! 1: LDUHA_I	lduha	[%r16, + 0x07e2] %asi, %r11
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r20
	.word 0xc6c42a28  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a28] %asi, %r3
	.word 0xd2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r9
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_186
	dec %r31
	.word 0x933c1002  ! 1: SRAX_R	srax	%r16, %r2, %r9
        mov 0x6e, %r31
thr3_loop_cnt_187:
	.word 0xd0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r8
	.word 0xf4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r26
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xcc5c2e58  ! 1: LDX_I	ldx	[%r16 + 0x0e58], %r6
	.word 0xded42728  ! 1: LDSHA_I	ldsha	[%r16, + 0x0728] %asi, %r15
	.word 0xe8d42eb0  ! 1: LDSHA_I	ldsha	[%r16, + 0x0eb0] %asi, %r20
	.word 0xecd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r22
	.word 0xc654220a  ! 1: LDSH_I	ldsh	[%r16 + 0x020a], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6c42394  ! 1: LDSWA_I	ldswa	[%r16, + 0x0394] %asi, %r3
	brnz %r31,thr3_loop_cnt_187
	dec %r31
	.word 0x912c0002  ! 1: SLL_R	sll 	%r16, %r2, %r8
	.word 0x921c214c  ! 1: XOR_I	xor 	%r16, 0x014c, %r9
	.word 0x9e2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r15
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x96, %r31
thr3_loop_cnt_188:
	.word 0xc61427d2  ! 1: LDUH_I	lduh	[%r16 + 0x07d2], %r3
	.word 0xde0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r15
	.word 0xc6942e8a  ! 1: LDUHA_I	lduha	[%r16, + 0x0e8a] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xda5c2a00  ! 1: LDX_I	ldx	[%r16 + 0x0a00], %r13
	.word 0xf6cc2523  ! 1: LDSBA_I	ldsba	[%r16, + 0x0523] %asi, %r27
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6c42488  ! 1: LDSWA_I	ldswa	[%r16, + 0x0488] %asi, %r3
	brnz %r31,thr3_loop_cnt_188
	dec %r31
	.word 0x9b342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r13
	.word 0x860c21a6  ! 1: AND_I	and 	%r16, 0x01a6, %r3
        mov 0xab, %r31
thr3_loop_cnt_189:
	.word 0xd4042488  ! 1: LDUW_I	lduw	[%r16 + 0x0488], %r10
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd6542a5e  ! 1: LDSH_I	ldsh	[%r16 + 0x0a5e], %r11
	.word 0xc64429cc  ! 1: LDSW_I	ldsw	[%r16 + 0x09cc], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xccc428a8  ! 1: LDSWA_I	ldswa	[%r16, + 0x08a8] %asi, %r6
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_189
	dec %r31
	.word 0xa52c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r18
	.word 0xaa3428d1  ! 1: ORN_I	orn 	%r16, 0x08d1, %r21
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0x9b, %r31
thr3_loop_cnt_190:
	.word 0xd25c2500  ! 1: LDX_I	ldx	[%r16 + 0x0500], %r9
	.word 0xfc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r30
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd28c2aa9  ! 1: LDUBA_I	lduba	[%r16, + 0x0aa9] %asi, %r9
	.word 0xf0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r24
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6042434  ! 1: LDUW_I	lduw	[%r16 + 0x0434], %r3
	.word 0xc6942e8c  ! 1: LDUHA_I	lduha	[%r16, + 0x0e8c] %asi, %r3
	.word 0xfc8425c4  ! 1: LDUWA_I	lduwa	[%r16, + 0x05c4] %asi, %r30
	brnz %r31,thr3_loop_cnt_190
	dec %r31
	.word 0x95341002  ! 1: SRLX_R	srlx	%r16, %r2, %r10
        mov 0x59, %r31
thr3_loop_cnt_191:
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	.word 0xe2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r17
	.word 0xe2d4286c  ! 1: LDSHA_I	ldsha	[%r16, + 0x086c] %asi, %r17
	.word 0xfa941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r29
	.word 0xccc42698  ! 1: LDSWA_I	ldswa	[%r16, + 0x0698] %asi, %r6
	.word 0xc68c224f  ! 1: LDUBA_I	lduba	[%r16, + 0x024f] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xea5c2498  ! 1: LDX_I	ldx	[%r16 + 0x0498], %r21
	.word 0xd0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r8
	brnz %r31,thr3_loop_cnt_191
	dec %r31
        mov 0x15, %r31
thr3_loop_cnt_192:
	.word 0xf094208a  ! 1: LDUHA_I	lduha	[%r16, + 0x008a] %asi, %r24
	.word 0xdad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r13
	.word 0xd6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r11
	.word 0xf444201c  ! 1: LDSW_I	ldsw	[%r16 + 0x001c], %r26
	.word 0xc6cc2469  ! 1: LDSBA_I	ldsba	[%r16, + 0x0469] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2627  ! 1: LDSBA_I	ldsba	[%r16, + 0x0627] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6942b5c  ! 1: LDUHA_I	lduha	[%r16, + 0x0b5c] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xda4c24c8  ! 1: LDSB_I	ldsb	[%r16 + 0x04c8], %r13
	brnz %r31,thr3_loop_cnt_192
	dec %r31
        mov 0x9d, %r31
thr3_loop_cnt_193:
	.word 0xf4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r26
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc68c2f3c  ! 1: LDUBA_I	lduba	[%r16, + 0x0f3c] %asi, %r3
	.word 0xe4542bb6  ! 1: LDSH_I	ldsh	[%r16 + 0x0bb6], %r18
	.word 0xfa0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r29
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xda440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r13
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_193
	dec %r31
        mov 0xb3, %r31
thr3_loop_cnt_194:
	.word 0xd2042c00  ! 1: LDUW_I	lduw	[%r16 + 0x0c00], %r9
	.word 0xc6cc21ad  ! 1: LDSBA_I	ldsba	[%r16, + 0x01ad] %asi, %r3
	.word 0xdc542bf6  ! 1: LDSH_I	ldsh	[%r16 + 0x0bf6], %r14
	.word 0xd05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r8
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe2c422f4  ! 1: LDSWA_I	ldswa	[%r16, + 0x02f4] %asi, %r17
	.word 0xd4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r10
	.word 0xd00c2b18  ! 1: LDUB_I	ldub	[%r16 + 0x0b18], %r8
	brnz %r31,thr3_loop_cnt_194
	dec %r31
	.word 0xb61c2976  ! 1: XOR_I	xor 	%r16, 0x0976, %r27
	.word 0x96342e9f  ! 1: SUBC_I	orn 	%r16, 0x0e9f, %r11
        mov 0x39, %r31
thr3_loop_cnt_195:
	.word 0xdc0429b4  ! 1: LDUW_I	lduw	[%r16 + 0x09b4], %r14
	.word 0xccc42864  ! 1: LDSWA_I	ldswa	[%r16, + 0x0864] %asi, %r6
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc68c2115  ! 1: LDUBA_I	lduba	[%r16, + 0x0115] %asi, %r3
	.word 0xc604235c  ! 1: LDUW_I	lduw	[%r16 + 0x035c], %r3
	.word 0xc64c2dcb  ! 1: LDSB_I	ldsb	[%r16 + 0x0dcb], %r3
	.word 0xc6842f08  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f08] %asi, %r3
	brnz %r31,thr3_loop_cnt_195
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x86142cb5  ! 1: OR_I	or 	%r16, 0x0cb5, %r3
        mov 0x14, %r31
thr3_loop_cnt_196:
	.word 0xe8442a40  ! 1: LDSW_I	ldsw	[%r16 + 0x0a40], %r20
	.word 0xc6842e18  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e18] %asi, %r3
	.word 0xe8542fa6  ! 1: LDSH_I	ldsh	[%r16 + 0x0fa6], %r20
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6542d94  ! 1: LDSH_I	ldsh	[%r16 + 0x0d94], %r3
	.word 0xdc5425e2  ! 1: LDSH_I	ldsh	[%r16 + 0x05e2], %r14
	.word 0xc614248c  ! 1: LDUH_I	lduh	[%r16 + 0x048c], %r3
	.word 0xc6942568  ! 1: LDUHA_I	lduha	[%r16, + 0x0568] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc68c2006  ! 1: LDUBA_I	lduba	[%r16, + 0x0006] %asi, %r3
	brnz %r31,thr3_loop_cnt_196
	dec %r31
        mov 0xa2, %r31
thr3_loop_cnt_197:
	.word 0xc6942c10  ! 1: LDUHA_I	lduha	[%r16, + 0x0c10] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd0cc211b  ! 1: LDSBA_I	ldsba	[%r16, + 0x011b] %asi, %r8
	.word 0xc64c2e4f  ! 1: LDSB_I	ldsb	[%r16 + 0x0e4f], %r3
	.word 0xf6cc2164  ! 1: LDSBA_I	ldsba	[%r16, + 0x0164] %asi, %r27
	.word 0xecc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r22
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	.word 0xfa842c60  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c60] %asi, %r29
	brnz %r31,thr3_loop_cnt_197
	dec %r31
	.word 0x8d3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r6
	.word 0x86342588  ! 1: ORN_I	orn 	%r16, 0x0588, %r3
	.word 0xae440002  ! 1: ADDC_R	addc 	%r16, %r2, %r23
        mov 0x2a, %r31
thr3_loop_cnt_198:
	.word 0xe8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r20
	.word 0xc6d42a78  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a78] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xce942480  ! 1: LDUHA_I	lduha	[%r16, + 0x0480] %asi, %r7
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6c42b08  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b08] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc61429ee  ! 1: LDUH_I	lduh	[%r16 + 0x09ee], %r3
	brnz %r31,thr3_loop_cnt_198
	dec %r31
	.word 0xa9342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r20
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0xae3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r23
        mov 0x49, %r31
thr3_loop_cnt_199:
	.word 0xf88c27e9  ! 1: LDUBA_I	lduba	[%r16, + 0x07e9] %asi, %r28
	.word 0xc6842f7c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f7c] %asi, %r3
	.word 0xf4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r26
	.word 0xf8cc2a3e  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a3e] %asi, %r28
	.word 0xfa5c24a0  ! 1: LDX_I	ldx	[%r16 + 0x04a0], %r29
	.word 0xfa540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r29
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6dc29b8  ! 1: LDXA_I	ldxa	[%r16, + 0x09b8] %asi, %r3
	.word 0xe40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r18
	.word 0xfcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r30
	brnz %r31,thr3_loop_cnt_199
	dec %r31
	.word 0x91343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r8
        mov 0x93, %r31
thr3_loop_cnt_200:
	.word 0xcc8c261c  ! 1: LDUBA_I	lduba	[%r16, + 0x061c] %asi, %r6
	.word 0xc6c4225c  ! 1: LDSWA_I	ldswa	[%r16, + 0x025c] %asi, %r3
	.word 0xce042f38  ! 1: LDUW_I	lduw	[%r16 + 0x0f38], %r7
	.word 0xd2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r9
	.word 0xd0cc2ac3  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ac3] %asi, %r8
	.word 0xc65c2000  ! 1: LDX_I	ldx	[%r16 + 0x0000], %r3
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xc694231c  ! 1: LDUHA_I	lduha	[%r16, + 0x031c] %asi, %r3
	.word 0xf8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r28
	.word 0xf6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r27
	.word 0xee5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r23
	brnz %r31,thr3_loop_cnt_200
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0xaa040002  ! 1: ADD_R	add 	%r16, %r2, %r21
        mov 0x57, %r31
thr3_loop_cnt_201:
	.word 0xc64c2780  ! 1: LDSB_I	ldsb	[%r16 + 0x0780], %r3
	.word 0xee8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r23
	.word 0xd00c21b3  ! 1: LDUB_I	ldub	[%r16 + 0x01b3], %r8
	.word 0xec8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r22
	.word 0xc6cc2078  ! 1: LDSBA_I	ldsba	[%r16, + 0x0078] %asi, %r3
	.word 0xc6842af0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0af0] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	brnz %r31,thr3_loop_cnt_201
	dec %r31
	.word 0x860c229b  ! 1: AND_I	and 	%r16, 0x029b, %r3
	.word 0x86442c46  ! 1: ADDC_I	addc 	%r16, 0x0c46, %r3
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x98142755  ! 1: OR_I	or 	%r16, 0x0755, %r12
        mov 0x4e, %r31
thr3_loop_cnt_202:
	.word 0xec5426e6  ! 1: LDSH_I	ldsh	[%r16 + 0x06e6], %r22
	.word 0xe2842470  ! 1: LDUWA_I	lduwa	[%r16, + 0x0470] %asi, %r17
	.word 0xc6cc2d58  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d58] %asi, %r3
	.word 0xc6d422ba  ! 1: LDSHA_I	ldsha	[%r16, + 0x02ba] %asi, %r3
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	.word 0xc6d423fc  ! 1: LDSHA_I	ldsha	[%r16, + 0x03fc] %asi, %r3
	.word 0xd2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r9
	brnz %r31,thr3_loop_cnt_202
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x86442499  ! 1: ADDC_I	addc 	%r16, 0x0499, %r3
        mov 0x4c, %r31
thr3_loop_cnt_203:
	.word 0xf8c42ef8  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ef8] %asi, %r28
	.word 0xe8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r20
	.word 0xd2c42090  ! 1: LDSWA_I	ldswa	[%r16, + 0x0090] %asi, %r9
	.word 0xe2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r17
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xcccc24ae  ! 1: LDSBA_I	ldsba	[%r16, + 0x04ae] %asi, %r6
	.word 0xf25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r25
	.word 0xc65c2dc8  ! 1: LDX_I	ldx	[%r16 + 0x0dc8], %r3
	.word 0xc60c2e57  ! 1: LDUB_I	ldub	[%r16 + 0x0e57], %r3
	.word 0xc68c2a6e  ! 1: LDUBA_I	lduba	[%r16, + 0x0a6e] %asi, %r3
	.word 0xc60c257c  ! 1: LDUB_I	ldub	[%r16 + 0x057c], %r3
	.word 0xec040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r22
	brnz %r31,thr3_loop_cnt_203
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x89, %r31
thr3_loop_cnt_204:
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xdedc2d70  ! 1: LDXA_I	ldxa	[%r16, + 0x0d70] %asi, %r15
	.word 0xc6442150  ! 1: LDSW_I	ldsw	[%r16 + 0x0150], %r3
	.word 0xea040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r21
	.word 0xc6042b30  ! 1: LDUW_I	lduw	[%r16 + 0x0b30], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6142fee  ! 1: LDUH_I	lduh	[%r16 + 0x0fee], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r17
	.word 0xf2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r25
	.word 0xcc5c24b0  ! 1: LDX_I	ldx	[%r16 + 0x04b0], %r6
	.word 0xc6cc216e  ! 1: LDSBA_I	ldsba	[%r16, + 0x016e] %asi, %r3
	brnz %r31,thr3_loop_cnt_204
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x8f3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r7
        mov 0x76, %r31
thr3_loop_cnt_205:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r27
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6042784  ! 1: LDUW_I	lduw	[%r16 + 0x0784], %r3
	.word 0xe80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r20
	.word 0xea042a94  ! 1: LDUW_I	lduw	[%r16 + 0x0a94], %r21
	.word 0xc64428b8  ! 1: LDSW_I	ldsw	[%r16 + 0x08b8], %r3
	.word 0xc60c27ae  ! 1: LDUB_I	ldub	[%r16 + 0x07ae], %r3
	.word 0xc6042aec  ! 1: LDUW_I	lduw	[%r16 + 0x0aec], %r3
	.word 0xc65c2988  ! 1: LDX_I	ldx	[%r16 + 0x0988], %r3
	brnz %r31,thr3_loop_cnt_205
	dec %r31
	.word 0xb62c27a7  ! 1: ANDN_I	andn 	%r16, 0x07a7, %r27
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x933c0002  ! 1: SRA_R	sra 	%r16, %r2, %r9
        mov 0x36, %r31
thr3_loop_cnt_206:
	.word 0xe8042a94  ! 1: LDUW_I	lduw	[%r16 + 0x0a94], %r20
	.word 0xc6c4265c  ! 1: LDSWA_I	ldswa	[%r16, + 0x065c] %asi, %r3
	.word 0xd2c426e0  ! 1: LDSWA_I	ldswa	[%r16, + 0x06e0] %asi, %r9
	.word 0xfa5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r29
	.word 0xeec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r23
	.word 0xc6442080  ! 1: LDSW_I	ldsw	[%r16 + 0x0080], %r3
	.word 0xfc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r30
	.word 0xfa440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r29
	.word 0xe20c230a  ! 1: LDUB_I	ldub	[%r16 + 0x030a], %r17
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	.word 0xf6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r27
	.word 0xf85425d2  ! 1: LDSH_I	ldsh	[%r16 + 0x05d2], %r28
	brnz %r31,thr3_loop_cnt_206
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0xb2, %r31
thr3_loop_cnt_207:
	.word 0xc64c215b  ! 1: LDSB_I	ldsb	[%r16 + 0x015b], %r3
	.word 0xd2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r9
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xde841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r15
	.word 0xce941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r7
	.word 0xde0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r15
	.word 0xf08c27e2  ! 1: LDUBA_I	lduba	[%r16, + 0x07e2] %asi, %r24
	.word 0xd2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r9
	.word 0xc68c27d6  ! 1: LDUBA_I	lduba	[%r16, + 0x07d6] %asi, %r3
	.word 0xf44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r26
	brnz %r31,thr3_loop_cnt_207
	dec %r31
        mov 0x1a, %r31
thr3_loop_cnt_208:
	.word 0xc60c224d  ! 1: LDUB_I	ldub	[%r16 + 0x024d], %r3
	.word 0xc68c2216  ! 1: LDUBA_I	lduba	[%r16, + 0x0216] %asi, %r3
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe2942278  ! 1: LDUHA_I	lduha	[%r16, + 0x0278] %asi, %r17
	.word 0xf2cc20b3  ! 1: LDSBA_I	ldsba	[%r16, + 0x00b3] %asi, %r25
	.word 0xd8842220  ! 1: LDUWA_I	lduwa	[%r16, + 0x0220] %asi, %r12
	.word 0xc68c2f30  ! 1: LDUBA_I	lduba	[%r16, + 0x0f30] %asi, %r3
	.word 0xecc42ef4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ef4] %asi, %r22
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_208
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x16, %r31
thr3_loop_cnt_209:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6942826  ! 1: LDUHA_I	lduha	[%r16, + 0x0826] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6042ba4  ! 1: LDUW_I	lduw	[%r16 + 0x0ba4], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc614236a  ! 1: LDUH_I	lduh	[%r16 + 0x036a], %r3
	.word 0xc6542d80  ! 1: LDSH_I	ldsh	[%r16 + 0x0d80], %r3
	.word 0xe65c2eb8  ! 1: LDX_I	ldx	[%r16 + 0x0eb8], %r19
	brnz %r31,thr3_loop_cnt_209
	dec %r31
        mov 0xc3, %r31
thr3_loop_cnt_210:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc60c2726  ! 1: LDUB_I	ldub	[%r16 + 0x0726], %r3
	.word 0xde8423d0  ! 1: LDUWA_I	lduwa	[%r16, + 0x03d0] %asi, %r15
	.word 0xc6cc27e4  ! 1: LDSBA_I	ldsba	[%r16, + 0x07e4] %asi, %r3
	.word 0xee841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r23
	.word 0xfa8c236b  ! 1: LDUBA_I	lduba	[%r16, + 0x036b] %asi, %r29
	.word 0xfad425c0  ! 1: LDSHA_I	ldsha	[%r16, + 0x05c0] %asi, %r29
	.word 0xf8142f4a  ! 1: LDUH_I	lduh	[%r16 + 0x0f4a], %r28
	brnz %r31,thr3_loop_cnt_210
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x9f3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r15
        mov 0x78, %r31
thr3_loop_cnt_211:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6c42cbc  ! 1: LDSWA_I	ldswa	[%r16, + 0x0cbc] %asi, %r3
	.word 0xd0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r8
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xe2842598  ! 1: LDUWA_I	lduwa	[%r16, + 0x0598] %asi, %r17
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	brnz %r31,thr3_loop_cnt_211
	dec %r31
	.word 0x860c28b9  ! 1: AND_I	and 	%r16, 0x08b9, %r3
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x863428fc  ! 1: SUBC_I	orn 	%r16, 0x08fc, %r3
	.word 0xb7342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r27
        mov 0x1c, %r31
thr3_loop_cnt_212:
	.word 0xda5c2478  ! 1: LDX_I	ldx	[%r16 + 0x0478], %r13
	.word 0xc64c23ee  ! 1: LDSB_I	ldsb	[%r16 + 0x03ee], %r3
	.word 0xc6dc2ca8  ! 1: LDXA_I	ldxa	[%r16, + 0x0ca8] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd08c2787  ! 1: LDUBA_I	lduba	[%r16, + 0x0787] %asi, %r8
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd4042f74  ! 1: LDUW_I	lduw	[%r16 + 0x0f74], %r10
	.word 0xcc842a28  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a28] %asi, %r6
	.word 0xe25c2670  ! 1: LDX_I	ldx	[%r16 + 0x0670], %r17
	.word 0xc654245c  ! 1: LDSH_I	ldsh	[%r16 + 0x045c], %r3
	.word 0xd4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r10
	.word 0xd24c2e0d  ! 1: LDSB_I	ldsb	[%r16 + 0x0e0d], %r9
	brnz %r31,thr3_loop_cnt_212
	dec %r31
	.word 0xa3342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r17
	.word 0x9a142f4c  ! 1: OR_I	or 	%r16, 0x0f4c, %r13
        mov 0x46, %r31
thr3_loop_cnt_213:
	.word 0xc68c2aed  ! 1: LDUBA_I	lduba	[%r16, + 0x0aed] %asi, %r3
	.word 0xc64c206d  ! 1: LDSB_I	ldsb	[%r16 + 0x006d], %r3
	.word 0xde540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r15
	.word 0xd49425e6  ! 1: LDUHA_I	lduha	[%r16, + 0x05e6] %asi, %r10
	.word 0xc64c22fd  ! 1: LDSB_I	ldsb	[%r16 + 0x02fd], %r3
	.word 0xec4c2a9a  ! 1: LDSB_I	ldsb	[%r16 + 0x0a9a], %r22
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd0442eb8  ! 1: LDSW_I	ldsw	[%r16 + 0x0eb8], %r8
	.word 0xced4213a  ! 1: LDSHA_I	ldsha	[%r16, + 0x013a] %asi, %r7
	.word 0xf4042634  ! 1: LDUW_I	lduw	[%r16 + 0x0634], %r26
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_213
	dec %r31
	.word 0x973c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r11
	.word 0x86142cd1  ! 1: OR_I	or 	%r16, 0x0cd1, %r3
	.word 0x98142176  ! 1: OR_I	or 	%r16, 0x0176, %r12
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0xb, %r31
thr3_loop_cnt_214:
	.word 0xf6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r27
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe2dc21a8  ! 1: LDXA_I	ldxa	[%r16, + 0x01a8] %asi, %r17
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r17
	.word 0xda4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r13
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xc64c2e64  ! 1: LDSB_I	ldsb	[%r16 + 0x0e64], %r3
	.word 0xc64c2518  ! 1: LDSB_I	ldsb	[%r16 + 0x0518], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_214
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x9e, %r31
thr3_loop_cnt_215:
	.word 0xee8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r23
	.word 0xce542dc0  ! 1: LDSH_I	ldsh	[%r16 + 0x0dc0], %r7
	.word 0xe4c42a8c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a8c] %asi, %r18
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	.word 0xced41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r7
	.word 0xf6442640  ! 1: LDSW_I	ldsw	[%r16 + 0x0640], %r27
	.word 0xc68c212e  ! 1: LDUBA_I	lduba	[%r16, + 0x012e] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc694246a  ! 1: LDUHA_I	lduha	[%r16, + 0x046a] %asi, %r3
	.word 0xc64c238d  ! 1: LDSB_I	ldsb	[%r16 + 0x038d], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r12
	brnz %r31,thr3_loop_cnt_215
	dec %r31
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
        mov 0x59, %r31
thr3_loop_cnt_216:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc68c29f9  ! 1: LDUBA_I	lduba	[%r16, + 0x09f9] %asi, %r3
	.word 0xc65c2a30  ! 1: LDX_I	ldx	[%r16 + 0x0a30], %r3
	.word 0xc6942856  ! 1: LDUHA_I	lduha	[%r16, + 0x0856] %asi, %r3
	.word 0xc6442950  ! 1: LDSW_I	ldsw	[%r16 + 0x0950], %r3
	.word 0xd85c2750  ! 1: LDX_I	ldx	[%r16 + 0x0750], %r12
	.word 0xfc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r30
	.word 0xc604242c  ! 1: LDUW_I	lduw	[%r16 + 0x042c], %r3
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xdedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r15
	brnz %r31,thr3_loop_cnt_216
	dec %r31
	.word 0x9b2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r13
	.word 0x86442222  ! 1: ADDC_I	addc 	%r16, 0x0222, %r3
        mov 0xa7, %r31
thr3_loop_cnt_217:
	.word 0xd8442a58  ! 1: LDSW_I	ldsw	[%r16 + 0x0a58], %r12
	.word 0xe80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r20
	.word 0xc6cc2423  ! 1: LDSBA_I	ldsba	[%r16, + 0x0423] %asi, %r3
	.word 0xd2cc25d3  ! 1: LDSBA_I	ldsba	[%r16, + 0x05d3] %asi, %r9
	.word 0xc6142bee  ! 1: LDUH_I	lduh	[%r16 + 0x0bee], %r3
	.word 0xde140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r15
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xc6dc2038  ! 1: LDXA_I	ldxa	[%r16, + 0x0038] %asi, %r3
	.word 0xea4c2936  ! 1: LDSB_I	ldsb	[%r16 + 0x0936], %r21
	brnz %r31,thr3_loop_cnt_217
	dec %r31
	.word 0xb62c2a27  ! 1: ANDN_I	andn 	%r16, 0x0a27, %r27
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x94340002  ! 1: SUBC_R	orn 	%r16, %r2, %r10
	.word 0xab3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r21
        mov 0x9e, %r31
thr3_loop_cnt_218:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xdc142220  ! 1: LDUH_I	lduh	[%r16 + 0x0220], %r14
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r28
	.word 0xd4d420e6  ! 1: LDSHA_I	ldsha	[%r16, + 0x00e6] %asi, %r10
	.word 0xe20c2536  ! 1: LDUB_I	ldub	[%r16 + 0x0536], %r17
	.word 0xd0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r8
	.word 0xccdc2b90  ! 1: LDXA_I	ldxa	[%r16, + 0x0b90] %asi, %r6
	.word 0xe8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r20
	.word 0xda542b0c  ! 1: LDSH_I	ldsh	[%r16 + 0x0b0c], %r13
	brnz %r31,thr3_loop_cnt_218
	dec %r31
	.word 0x98142589  ! 1: OR_I	or 	%r16, 0x0589, %r12
	.word 0xab3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r21
	.word 0xa6040002  ! 1: ADD_R	add 	%r16, %r2, %r19
        mov 0xa1, %r31
thr3_loop_cnt_219:
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe2c427d8  ! 1: LDSWA_I	ldswa	[%r16, + 0x07d8] %asi, %r17
	.word 0xc60c23f3  ! 1: LDUB_I	ldub	[%r16 + 0x03f3], %r3
	.word 0xc60c291e  ! 1: LDUB_I	ldub	[%r16 + 0x091e], %r3
	.word 0xdc8c24da  ! 1: LDUBA_I	lduba	[%r16, + 0x04da] %asi, %r14
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_219
	dec %r31
        mov 0xb, %r31
thr3_loop_cnt_220:
	.word 0xc61420c0  ! 1: LDUH_I	lduh	[%r16 + 0x00c0], %r3
	.word 0xc6542902  ! 1: LDSH_I	ldsh	[%r16 + 0x0902], %r3
	.word 0xc60425c4  ! 1: LDUW_I	lduw	[%r16 + 0x05c4], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6942ede  ! 1: LDUHA_I	lduha	[%r16, + 0x0ede] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xeedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r23
	.word 0xe2d42e4c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e4c] %asi, %r17
	brnz %r31,thr3_loop_cnt_220
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x9a3421e9  ! 1: ORN_I	orn 	%r16, 0x01e9, %r13
	.word 0xb63c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r27
	.word 0x90242dfd  ! 1: SUB_I	sub 	%r16, 0x0dfd, %r8
        mov 0x58, %r31
thr3_loop_cnt_221:
	.word 0xc60c2228  ! 1: LDUB_I	ldub	[%r16 + 0x0228], %r3
	.word 0xc6d425d4  ! 1: LDSHA_I	ldsha	[%r16, + 0x05d4] %asi, %r3
	.word 0xdad42fe6  ! 1: LDSHA_I	ldsha	[%r16, + 0x0fe6] %asi, %r13
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_221
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x94440002  ! 1: ADDC_R	addc 	%r16, %r2, %r10
        mov 0xa0, %r31
thr3_loop_cnt_222:
	.word 0xd0842208  ! 1: LDUWA_I	lduwa	[%r16, + 0x0208] %asi, %r8
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r8
	.word 0xc6842df4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0df4] %asi, %r3
	.word 0xd40c2321  ! 1: LDUB_I	ldub	[%r16 + 0x0321], %r10
	.word 0xc6cc2aa1  ! 1: LDSBA_I	ldsba	[%r16, + 0x0aa1] %asi, %r3
	.word 0xeed41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r23
	.word 0xf8142878  ! 1: LDUH_I	lduh	[%r16 + 0x0878], %r28
	.word 0xc60c2b2a  ! 1: LDUB_I	ldub	[%r16 + 0x0b2a], %r3
	.word 0xd8c42f60  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f60] %asi, %r12
	brnz %r31,thr3_loop_cnt_222
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0xae, %r31
thr3_loop_cnt_223:
	.word 0xc69429f8  ! 1: LDUHA_I	lduha	[%r16, + 0x09f8] %asi, %r3
	.word 0xd0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r8
	.word 0xc6c42e84  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e84] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xdc4c248b  ! 1: LDSB_I	ldsb	[%r16 + 0x048b], %r14
	.word 0xdccc2d43  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d43] %asi, %r14
	.word 0xe4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r18
	.word 0xc65c2b90  ! 1: LDX_I	ldx	[%r16 + 0x0b90], %r3
	.word 0xee4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r23
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xda8c2ef4  ! 1: LDUBA_I	lduba	[%r16, + 0x0ef4] %asi, %r13
	brnz %r31,thr3_loop_cnt_223
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x861c2856  ! 1: XOR_I	xor 	%r16, 0x0856, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0xb6, %r31
thr3_loop_cnt_224:
	.word 0xd45c29c8  ! 1: LDX_I	ldx	[%r16 + 0x09c8], %r10
	.word 0xfc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r30
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xea440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r21
	.word 0xc6cc26a3  ! 1: LDSBA_I	ldsba	[%r16, + 0x06a3] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf0c42cb4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0cb4] %asi, %r24
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_224
	dec %r31
	.word 0x86342bd6  ! 1: ORN_I	orn 	%r16, 0x0bd6, %r3
	.word 0x902422cd  ! 1: SUB_I	sub 	%r16, 0x02cd, %r8
	.word 0xb42c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r26
	.word 0x92442da1  ! 1: ADDC_I	addc 	%r16, 0x0da1, %r9
        mov 0x38, %r31
thr3_loop_cnt_225:
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xe6cc29d6  ! 1: LDSBA_I	ldsba	[%r16, + 0x09d6] %asi, %r19
	.word 0xde142e12  ! 1: LDUH_I	lduh	[%r16 + 0x0e12], %r15
	.word 0xc6cc21c5  ! 1: LDSBA_I	ldsba	[%r16, + 0x01c5] %asi, %r3
	.word 0xc6c4225c  ! 1: LDSWA_I	ldswa	[%r16, + 0x025c] %asi, %r3
	.word 0xc6842f20  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f20] %asi, %r3
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc290f  ! 1: LDSBA_I	ldsba	[%r16, + 0x090f] %asi, %r3
	brnz %r31,thr3_loop_cnt_225
	dec %r31
	.word 0x9a1c0002  ! 1: XOR_R	xor 	%r16, %r2, %r13
	.word 0x86142cbf  ! 1: OR_I	or 	%r16, 0x0cbf, %r3
	.word 0xa92c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r20
        mov 0x26, %r31
thr3_loop_cnt_226:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xda8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r13
	.word 0xc6042718  ! 1: LDUW_I	lduw	[%r16 + 0x0718], %r3
	.word 0xc6842800  ! 1: LDUWA_I	lduwa	[%r16, + 0x0800] %asi, %r3
	.word 0xcec42580  ! 1: LDSWA_I	ldswa	[%r16, + 0x0580] %asi, %r7
	.word 0xea5c2270  ! 1: LDX_I	ldx	[%r16 + 0x0270], %r21
	.word 0xeedc2478  ! 1: LDXA_I	ldxa	[%r16, + 0x0478] %asi, %r23
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r8
	brnz %r31,thr3_loop_cnt_226
	dec %r31
	.word 0x9f3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r15
	.word 0xb8342683  ! 1: ORN_I	orn 	%r16, 0x0683, %r28
	.word 0x920c21e9  ! 1: AND_I	and 	%r16, 0x01e9, %r9
        mov 0x10, %r31
thr3_loop_cnt_227:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc60c25d1  ! 1: LDUB_I	ldub	[%r16 + 0x05d1], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf0d42fda  ! 1: LDSHA_I	ldsha	[%r16, + 0x0fda] %asi, %r24
	brnz %r31,thr3_loop_cnt_227
	dec %r31
	.word 0xab2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r21
	.word 0xaf342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r23
	.word 0x982c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r12
	.word 0xb93c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r28
        mov 0x14, %r31
thr3_loop_cnt_228:
	.word 0xde9422c4  ! 1: LDUHA_I	lduha	[%r16, + 0x02c4] %asi, %r15
	.word 0xdc5c2d88  ! 1: LDX_I	ldx	[%r16 + 0x0d88], %r14
	.word 0xd8d42a2c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a2c] %asi, %r12
	.word 0xd2cc2c02  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c02] %asi, %r9
	.word 0xc6dc2318  ! 1: LDXA_I	ldxa	[%r16, + 0x0318] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xdcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r14
	.word 0xc6442964  ! 1: LDSW_I	ldsw	[%r16 + 0x0964], %r3
	.word 0xc68c2df1  ! 1: LDUBA_I	lduba	[%r16, + 0x0df1] %asi, %r3
	.word 0xf0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r24
	.word 0xe4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r18
	.word 0xe4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r18
	brnz %r31,thr3_loop_cnt_228
	dec %r31
        mov 0x41, %r31
thr3_loop_cnt_229:
	.word 0xe8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r20
	.word 0xc6d429d6  ! 1: LDSHA_I	ldsha	[%r16, + 0x09d6] %asi, %r3
	.word 0xf4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r26
	.word 0xc65c22d0  ! 1: LDX_I	ldx	[%r16 + 0x02d0], %r3
	.word 0xc6d42634  ! 1: LDSHA_I	ldsha	[%r16, + 0x0634] %asi, %r3
	.word 0xee142942  ! 1: LDUH_I	lduh	[%r16 + 0x0942], %r23
	.word 0xda5c2c28  ! 1: LDX_I	ldx	[%r16 + 0x0c28], %r13
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xfa4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r29
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xda1423ea  ! 1: LDUH_I	lduh	[%r16 + 0x03ea], %r13
	.word 0xea4c2f70  ! 1: LDSB_I	ldsb	[%r16 + 0x0f70], %r21
	brnz %r31,thr3_loop_cnt_229
	dec %r31
        mov 0x90, %r31
thr3_loop_cnt_230:
	.word 0xc6542dca  ! 1: LDSH_I	ldsh	[%r16 + 0x0dca], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc614282a  ! 1: LDUH_I	lduh	[%r16 + 0x082a], %r3
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xf28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r25
	.word 0xd2cc23f2  ! 1: LDSBA_I	ldsba	[%r16, + 0x03f2] %asi, %r9
	.word 0xc6dc20d8  ! 1: LDXA_I	ldxa	[%r16, + 0x00d8] %asi, %r3
	.word 0xc64c2ce5  ! 1: LDSB_I	ldsb	[%r16 + 0x0ce5], %r3
	.word 0xc684210c  ! 1: LDUWA_I	lduwa	[%r16, + 0x010c] %asi, %r3
	.word 0xc68429e8  ! 1: LDUWA_I	lduwa	[%r16, + 0x09e8] %asi, %r3
	.word 0xd0cc203b  ! 1: LDSBA_I	ldsba	[%r16, + 0x003b] %asi, %r8
	brnz %r31,thr3_loop_cnt_230
	dec %r31
	.word 0x972c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r11
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x94242644  ! 1: SUB_I	sub 	%r16, 0x0644, %r10
        mov 0x73, %r31
thr3_loop_cnt_231:
	.word 0xc65c21b0  ! 1: LDX_I	ldx	[%r16 + 0x01b0], %r3
	.word 0xde540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r15
	.word 0xc64c2a9d  ! 1: LDSB_I	ldsb	[%r16 + 0x0a9d], %r3
	.word 0xee94253e  ! 1: LDUHA_I	lduha	[%r16, + 0x053e] %asi, %r23
	.word 0xec842030  ! 1: LDUWA_I	lduwa	[%r16, + 0x0030] %asi, %r22
	.word 0xe8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r20
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6842c98  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c98] %asi, %r3
	.word 0xc6c4248c  ! 1: LDSWA_I	ldswa	[%r16, + 0x048c] %asi, %r3
	brnz %r31,thr3_loop_cnt_231
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x8624252c  ! 1: SUB_I	sub 	%r16, 0x052c, %r3
        mov 0x9c, %r31
thr3_loop_cnt_232:
	.word 0xfc842774  ! 1: LDUWA_I	lduwa	[%r16, + 0x0774] %asi, %r30
	.word 0xfc8427ec  ! 1: LDUWA_I	lduwa	[%r16, + 0x07ec] %asi, %r30
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd00426dc  ! 1: LDUW_I	lduw	[%r16 + 0x06dc], %r8
	.word 0xce54259a  ! 1: LDSH_I	ldsh	[%r16 + 0x059a], %r7
	.word 0xc6042de8  ! 1: LDUW_I	lduw	[%r16 + 0x0de8], %r3
	.word 0xde4c27a8  ! 1: LDSB_I	ldsb	[%r16 + 0x07a8], %r15
	brnz %r31,thr3_loop_cnt_232
	dec %r31
	.word 0x860c271f  ! 1: AND_I	and 	%r16, 0x071f, %r3
	.word 0xb93c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r28
	.word 0xa42c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r18
	.word 0xa93c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r20
        mov 0xb3, %r31
thr3_loop_cnt_233:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf8042548  ! 1: LDUW_I	lduw	[%r16 + 0x0548], %r28
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe2d428e8  ! 1: LDSHA_I	ldsha	[%r16, + 0x08e8] %asi, %r17
	.word 0xd8042324  ! 1: LDUW_I	lduw	[%r16 + 0x0324], %r12
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xced41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r7
	.word 0xc64c2bc4  ! 1: LDSB_I	ldsb	[%r16 + 0x0bc4], %r3
	.word 0xea4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r21
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_233
	dec %r31
	.word 0x8e24213f  ! 1: SUB_I	sub 	%r16, 0x013f, %r7
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x9a0421b4  ! 1: ADD_I	add 	%r16, 0x01b4, %r13
        mov 0x85, %r31
thr3_loop_cnt_234:
	.word 0xe6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r19
	.word 0xc65c2c38  ! 1: LDX_I	ldx	[%r16 + 0x0c38], %r3
	.word 0xe2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r17
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xdc4c2290  ! 1: LDSB_I	ldsb	[%r16 + 0x0290], %r14
	.word 0xe48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r18
	.word 0xd8c424b8  ! 1: LDSWA_I	ldswa	[%r16, + 0x04b8] %asi, %r12
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xea542a44  ! 1: LDSH_I	ldsh	[%r16 + 0x0a44], %r21
	brnz %r31,thr3_loop_cnt_234
	dec %r31
	.word 0x940c2c26  ! 1: AND_I	and 	%r16, 0x0c26, %r10
	.word 0x940c2214  ! 1: AND_I	and 	%r16, 0x0214, %r10
	.word 0x9a240002  ! 1: SUB_R	sub 	%r16, %r2, %r13
        mov 0x8e, %r31
thr3_loop_cnt_235:
	.word 0xc6d42d8e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d8e] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc60c270f  ! 1: LDUB_I	ldub	[%r16 + 0x070f], %r3
	.word 0xea5c21c0  ! 1: LDX_I	ldx	[%r16 + 0x01c0], %r21
	.word 0xf68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r27
	.word 0xdc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r14
	.word 0xe20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r17
	.word 0xd2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r9
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	.word 0xe2542516  ! 1: LDSH_I	ldsh	[%r16 + 0x0516], %r17
	.word 0xf8c4274c  ! 1: LDSWA_I	ldswa	[%r16, + 0x074c] %asi, %r28
	.word 0xf28c23dd  ! 1: LDUBA_I	lduba	[%r16, + 0x03dd] %asi, %r25
	brnz %r31,thr3_loop_cnt_235
	dec %r31
	.word 0x94442ec1  ! 1: ADDC_I	addc 	%r16, 0x0ec1, %r10
	.word 0x8f340002  ! 1: SRL_R	srl 	%r16, %r2, %r7
        mov 0x65, %r31
thr3_loop_cnt_236:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r26
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xee142054  ! 1: LDUH_I	lduh	[%r16 + 0x0054], %r23
	.word 0xc68c2b33  ! 1: LDUBA_I	lduba	[%r16, + 0x0b33] %asi, %r3
	.word 0xd05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r8
	.word 0xc6cc2694  ! 1: LDSBA_I	ldsba	[%r16, + 0x0694] %asi, %r3
	.word 0xded42566  ! 1: LDSHA_I	ldsha	[%r16, + 0x0566] %asi, %r15
	brnz %r31,thr3_loop_cnt_236
	dec %r31
        mov 0xad, %r31
thr3_loop_cnt_237:
	.word 0xeac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r21
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6842540  ! 1: LDUWA_I	lduwa	[%r16, + 0x0540] %asi, %r3
	.word 0xd6cc2f74  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f74] %asi, %r11
	.word 0xdcc42e04  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e04] %asi, %r14
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf8d42300  ! 1: LDSHA_I	ldsha	[%r16, + 0x0300] %asi, %r28
	.word 0xeec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r23
	.word 0xe6442ab0  ! 1: LDSW_I	ldsw	[%r16 + 0x0ab0], %r19
	.word 0xc6cc23fe  ! 1: LDSBA_I	ldsba	[%r16, + 0x03fe] %asi, %r3
	brnz %r31,thr3_loop_cnt_237
	dec %r31
	.word 0x9a2c2364  ! 1: ANDN_I	andn 	%r16, 0x0364, %r13
        mov 0x5, %r31
thr3_loop_cnt_238:
	.word 0xd2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r9
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc64c2118  ! 1: LDSB_I	ldsb	[%r16 + 0x0118], %r3
	.word 0xee440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r23
	.word 0xe4542330  ! 1: LDSH_I	ldsh	[%r16 + 0x0330], %r18
	.word 0xc6dc2578  ! 1: LDXA_I	ldxa	[%r16, + 0x0578] %asi, %r3
	.word 0xc6142c24  ! 1: LDUH_I	lduh	[%r16 + 0x0c24], %r3
	.word 0xc6542a20  ! 1: LDSH_I	ldsh	[%r16 + 0x0a20], %r3
	.word 0xf2d42ede  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ede] %asi, %r25
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_238
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0xb0142159  ! 1: OR_I	or 	%r16, 0x0159, %r24
        mov 0xc2, %r31
thr3_loop_cnt_239:
	.word 0xc64c2009  ! 1: LDSB_I	ldsb	[%r16 + 0x0009], %r3
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xe64c210b  ! 1: LDSB_I	ldsb	[%r16 + 0x010b], %r19
	.word 0xd04c23d4  ! 1: LDSB_I	ldsb	[%r16 + 0x03d4], %r8
	.word 0xf2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r25
	.word 0xf6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r27
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_239
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0xc1, %r31
thr3_loop_cnt_240:
	.word 0xc6542244  ! 1: LDSH_I	ldsh	[%r16 + 0x0244], %r3
	.word 0xf40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r26
	.word 0xd684268c  ! 1: LDUWA_I	lduwa	[%r16, + 0x068c] %asi, %r11
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r19
	.word 0xfc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r30
	.word 0xc6442f18  ! 1: LDSW_I	ldsw	[%r16 + 0x0f18], %r3
	.word 0xc6d421fe  ! 1: LDSHA_I	ldsha	[%r16, + 0x01fe] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_240
	dec %r31
	.word 0xbd2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r30
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0xa4140002  ! 1: OR_R	or 	%r16, %r2, %r18
        mov 0xc3, %r31
thr3_loop_cnt_241:
	.word 0xc6842890  ! 1: LDUWA_I	lduwa	[%r16, + 0x0890] %asi, %r3
	.word 0xc694240c  ! 1: LDUHA_I	lduha	[%r16, + 0x040c] %asi, %r3
	.word 0xc6c42e64  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e64] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xe8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r20
	.word 0xf2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r25
	.word 0xf20c2070  ! 1: LDUB_I	ldub	[%r16 + 0x0070], %r25
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6d42208  ! 1: LDSHA_I	ldsha	[%r16, + 0x0208] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_241
	dec %r31
	.word 0xbc3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r30
	.word 0x9e342731  ! 1: SUBC_I	orn 	%r16, 0x0731, %r15
        mov 0xa2, %r31
thr3_loop_cnt_242:
	.word 0xc6442390  ! 1: LDSW_I	ldsw	[%r16 + 0x0390], %r3
	.word 0xe6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r19
	.word 0xd2dc2b40  ! 1: LDXA_I	ldxa	[%r16, + 0x0b40] %asi, %r9
	.word 0xfc8c2bd8  ! 1: LDUBA_I	lduba	[%r16, + 0x0bd8] %asi, %r30
	.word 0xdac42e50  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e50] %asi, %r13
	.word 0xc68421d8  ! 1: LDUWA_I	lduwa	[%r16, + 0x01d8] %asi, %r3
	.word 0xc6442374  ! 1: LDSW_I	ldsw	[%r16 + 0x0374], %r3
	.word 0xe2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r17
	.word 0xe4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r18
	brnz %r31,thr3_loop_cnt_242
	dec %r31
	.word 0xba142196  ! 1: OR_I	or 	%r16, 0x0196, %r29
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x5c, %r31
thr3_loop_cnt_243:
	.word 0xf2cc2d69  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d69] %asi, %r25
	.word 0xc60420ac  ! 1: LDUW_I	lduw	[%r16 + 0x00ac], %r3
	.word 0xe84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r20
	.word 0xf64c2055  ! 1: LDSB_I	ldsb	[%r16 + 0x0055], %r27
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc65c21b0  ! 1: LDX_I	ldx	[%r16 + 0x01b0], %r3
	.word 0xd6942174  ! 1: LDUHA_I	lduha	[%r16, + 0x0174] %asi, %r11
	.word 0xce942cec  ! 1: LDUHA_I	lduha	[%r16, + 0x0cec] %asi, %r7
	.word 0xe6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r19
	.word 0xd8d42f24  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f24] %asi, %r12
	.word 0xf2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r25
	brnz %r31,thr3_loop_cnt_243
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x8e0c2b40  ! 1: AND_I	and 	%r16, 0x0b40, %r7
        mov 0xb8, %r31
thr3_loop_cnt_244:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc60c2d9e  ! 1: LDUB_I	ldub	[%r16 + 0x0d9e], %r3
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xc60c231c  ! 1: LDUB_I	ldub	[%r16 + 0x031c], %r3
	.word 0xd4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r10
	.word 0xec142490  ! 1: LDUH_I	lduh	[%r16 + 0x0490], %r22
	.word 0xc6dc22c0  ! 1: LDXA_I	ldxa	[%r16, + 0x02c0] %asi, %r3
	.word 0xd0d42492  ! 1: LDSHA_I	ldsha	[%r16, + 0x0492] %asi, %r8
	.word 0xc60c2c91  ! 1: LDUB_I	ldub	[%r16 + 0x0c91], %r3
	brnz %r31,thr3_loop_cnt_244
	dec %r31
	.word 0xaf343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r23
	.word 0x86342e12  ! 1: SUBC_I	orn 	%r16, 0x0e12, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x8c4427b6  ! 1: ADDC_I	addc 	%r16, 0x07b6, %r6
        mov 0x77, %r31
thr3_loop_cnt_245:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r25
	.word 0xe8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r20
	.word 0xea5c2dc8  ! 1: LDX_I	ldx	[%r16 + 0x0dc8], %r21
	.word 0xc68c2277  ! 1: LDUBA_I	lduba	[%r16, + 0x0277] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6042ae0  ! 1: LDUW_I	lduw	[%r16 + 0x0ae0], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd2042dd4  ! 1: LDUW_I	lduw	[%r16 + 0x0dd4], %r9
	.word 0xcc0c2b2c  ! 1: LDUB_I	ldub	[%r16 + 0x0b2c], %r6
	.word 0xdc5c2948  ! 1: LDX_I	ldx	[%r16 + 0x0948], %r14
	brnz %r31,thr3_loop_cnt_245
	dec %r31
        mov 0x1c, %r31
thr3_loop_cnt_246:
	.word 0xf20c2da4  ! 1: LDUB_I	ldub	[%r16 + 0x0da4], %r25
	.word 0xd8042e38  ! 1: LDUW_I	lduw	[%r16 + 0x0e38], %r12
	.word 0xe8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r20
	.word 0xe6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r19
	.word 0xc6942a24  ! 1: LDUHA_I	lduha	[%r16, + 0x0a24] %asi, %r3
	.word 0xf4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r26
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6442c00  ! 1: LDSW_I	ldsw	[%r16 + 0x0c00], %r3
	brnz %r31,thr3_loop_cnt_246
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0xb5, %r31
thr3_loop_cnt_247:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd6042870  ! 1: LDUW_I	lduw	[%r16 + 0x0870], %r11
	.word 0xd0842048  ! 1: LDUWA_I	lduwa	[%r16, + 0x0048] %asi, %r8
	.word 0xc65c20a8  ! 1: LDX_I	ldx	[%r16 + 0x00a8], %r3
	.word 0xd0942e7a  ! 1: LDUHA_I	lduha	[%r16, + 0x0e7a] %asi, %r8
	.word 0xc6042cfc  ! 1: LDUW_I	lduw	[%r16 + 0x0cfc], %r3
	.word 0xc6d42daa  ! 1: LDSHA_I	ldsha	[%r16, + 0x0daa] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	.word 0xd4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r10
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_247
	dec %r31
	.word 0xa2340002  ! 1: ORN_R	orn 	%r16, %r2, %r17
        mov 0x93, %r31
thr3_loop_cnt_248:
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r20
	.word 0xc65c25d0  ! 1: LDX_I	ldx	[%r16 + 0x05d0], %r3
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xf40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r26
	.word 0xc6dc27c0  ! 1: LDXA_I	ldxa	[%r16, + 0x07c0] %asi, %r3
	.word 0xc65c2970  ! 1: LDX_I	ldx	[%r16 + 0x0970], %r3
	brnz %r31,thr3_loop_cnt_248
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0xac0420a2  ! 1: ADD_I	add 	%r16, 0x00a2, %r22
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x72, %r31
thr3_loop_cnt_249:
	.word 0xd48c2546  ! 1: LDUBA_I	lduba	[%r16, + 0x0546] %asi, %r10
	.word 0xe4dc25c0  ! 1: LDXA_I	ldxa	[%r16, + 0x05c0] %asi, %r18
	.word 0xc6442b7c  ! 1: LDSW_I	ldsw	[%r16 + 0x0b7c], %r3
	.word 0xecdc2018  ! 1: LDXA_I	ldxa	[%r16, + 0x0018] %asi, %r22
	.word 0xce941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r7
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd2042914  ! 1: LDUW_I	lduw	[%r16 + 0x0914], %r9
	.word 0xfa841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r29
	.word 0xc60c2d73  ! 1: LDUB_I	ldub	[%r16 + 0x0d73], %r3
	.word 0xee4c27b9  ! 1: LDSB_I	ldsb	[%r16 + 0x07b9], %r23
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_249
	dec %r31
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0xa3, %r31
thr3_loop_cnt_250:
	.word 0xc60c2f34  ! 1: LDUB_I	ldub	[%r16 + 0x0f34], %r3
	.word 0xf40c2c4b  ! 1: LDUB_I	ldub	[%r16 + 0x0c4b], %r26
	.word 0xc6c424ec  ! 1: LDSWA_I	ldswa	[%r16, + 0x04ec] %asi, %r3
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xf4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r26
	.word 0xc6942a7a  ! 1: LDUHA_I	lduha	[%r16, + 0x0a7a] %asi, %r3
	.word 0xe6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r19
	.word 0xc6c42fb4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0fb4] %asi, %r3
	.word 0xde84221c  ! 1: LDUWA_I	lduwa	[%r16, + 0x021c] %asi, %r15
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_250
	dec %r31
	.word 0xb12c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r24
	.word 0xa61c0002  ! 1: XOR_R	xor 	%r16, %r2, %r19
	.word 0x9a2c27a3  ! 1: ANDN_I	andn 	%r16, 0x07a3, %r13
	.word 0x943c2aa6  ! 1: XNOR_I	xnor 	%r16, 0x0aa6, %r10
        mov 0xa2, %r31
thr3_loop_cnt_251:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r25
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r25
	.word 0xd04428ac  ! 1: LDSW_I	ldsw	[%r16 + 0x08ac], %r8
	.word 0xc6842a10  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a10] %asi, %r3
	.word 0xc68427b8  ! 1: LDUWA_I	lduwa	[%r16, + 0x07b8] %asi, %r3
	.word 0xc6cc2cfd  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cfd] %asi, %r3
	.word 0xdc04209c  ! 1: LDUW_I	lduw	[%r16 + 0x009c], %r14
	.word 0xc6dc2368  ! 1: LDXA_I	ldxa	[%r16, + 0x0368] %asi, %r3
	brnz %r31,thr3_loop_cnt_251
	dec %r31
	.word 0xb23c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r25
	.word 0x863425da  ! 1: SUBC_I	orn 	%r16, 0x05da, %r3
	.word 0x863425b7  ! 1: SUBC_I	orn 	%r16, 0x05b7, %r3
        mov 0x97, %r31
thr3_loop_cnt_252:
	.word 0xf4d42302  ! 1: LDSHA_I	ldsha	[%r16, + 0x0302] %asi, %r26
	.word 0xea142574  ! 1: LDUH_I	lduh	[%r16 + 0x0574], %r21
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xded429ac  ! 1: LDSHA_I	ldsha	[%r16, + 0x09ac] %asi, %r15
	.word 0xf4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r26
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r12
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd494294c  ! 1: LDUHA_I	lduha	[%r16, + 0x094c] %asi, %r10
	brnz %r31,thr3_loop_cnt_252
	dec %r31
	.word 0x862c2823  ! 1: ANDN_I	andn 	%r16, 0x0823, %r3
        mov 0x4b, %r31
thr3_loop_cnt_253:
	.word 0xde5c2d88  ! 1: LDX_I	ldx	[%r16 + 0x0d88], %r15
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc65c2548  ! 1: LDX_I	ldx	[%r16 + 0x0548], %r3
	.word 0xc65c2360  ! 1: LDX_I	ldx	[%r16 + 0x0360], %r3
	.word 0xc6542d2e  ! 1: LDSH_I	ldsh	[%r16 + 0x0d2e], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	.word 0xc60c2c07  ! 1: LDUB_I	ldub	[%r16 + 0x0c07], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r25
	brnz %r31,thr3_loop_cnt_253
	dec %r31
	.word 0x86042260  ! 1: ADD_I	add 	%r16, 0x0260, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x860c2d8f  ! 1: AND_I	and 	%r16, 0x0d8f, %r3
	.word 0x860421f0  ! 1: ADD_I	add 	%r16, 0x01f0, %r3
        mov 0x4c, %r31
thr3_loop_cnt_254:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd4cc21db  ! 1: LDSBA_I	ldsba	[%r16, + 0x01db] %asi, %r10
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r10
	brnz %r31,thr3_loop_cnt_254
	dec %r31
	.word 0x94342252  ! 1: ORN_I	orn 	%r16, 0x0252, %r10
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0xb82c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r28
        mov 0x56, %r31
thr3_loop_cnt_255:
	.word 0xd85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r12
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xdac42634  ! 1: LDSWA_I	ldswa	[%r16, + 0x0634] %asi, %r13
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xde5c2088  ! 1: LDX_I	ldx	[%r16 + 0x0088], %r15
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xeed41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r23
	.word 0xc60c2015  ! 1: LDUB_I	ldub	[%r16 + 0x0015], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd20422a4  ! 1: LDUW_I	lduw	[%r16 + 0x02a4], %r9
	.word 0xc6cc2272  ! 1: LDSBA_I	ldsba	[%r16, + 0x0272] %asi, %r3
	brnz %r31,thr3_loop_cnt_255
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x982c2d1a  ! 1: ANDN_I	andn 	%r16, 0x0d1a, %r12
        mov 0x6e, %r31
thr3_loop_cnt_256:
	.word 0xc6cc2cc4  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cc4] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r10
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xecdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r22
	.word 0xc65424be  ! 1: LDSH_I	ldsh	[%r16 + 0x04be], %r3
	.word 0xd48429d8  ! 1: LDUWA_I	lduwa	[%r16, + 0x09d8] %asi, %r10
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xf4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r26
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r27
	brnz %r31,thr3_loop_cnt_256
	dec %r31
	.word 0x9e2c289c  ! 1: ANDN_I	andn 	%r16, 0x089c, %r15
	.word 0x9c340002  ! 1: ORN_R	orn 	%r16, %r2, %r14
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x86442d6c  ! 1: ADDC_I	addc 	%r16, 0x0d6c, %r3
        mov 0x25, %r31
thr3_loop_cnt_257:
	.word 0xc65c2588  ! 1: LDX_I	ldx	[%r16 + 0x0588], %r3
	.word 0xd4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r10
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xccdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r6
	.word 0xd8dc24f0  ! 1: LDXA_I	ldxa	[%r16, + 0x04f0] %asi, %r12
	.word 0xf08c2d41  ! 1: LDUBA_I	lduba	[%r16, + 0x0d41] %asi, %r24
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xec8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r22
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_257
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x86342b23  ! 1: ORN_I	orn 	%r16, 0x0b23, %r3
	.word 0x863427e2  ! 1: SUBC_I	orn 	%r16, 0x07e2, %r3
        mov 0xaf, %r31
thr3_loop_cnt_258:
	.word 0xe614241a  ! 1: LDUH_I	lduh	[%r16 + 0x041a], %r19
	.word 0xd8c42948  ! 1: LDSWA_I	ldswa	[%r16, + 0x0948] %asi, %r12
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xce9428a0  ! 1: LDUHA_I	lduha	[%r16, + 0x08a0] %asi, %r7
	.word 0xc6d4222a  ! 1: LDSHA_I	ldsha	[%r16, + 0x022a] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6d42a84  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a84] %asi, %r3
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xda5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r13
	.word 0xf0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r24
	brnz %r31,thr3_loop_cnt_258
	dec %r31
	.word 0xb92c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r28
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0xad3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r22
        mov 0x93, %r31
thr3_loop_cnt_259:
	.word 0xc6542446  ! 1: LDSH_I	ldsh	[%r16 + 0x0446], %r3
	.word 0xd4d423de  ! 1: LDSHA_I	ldsha	[%r16, + 0x03de] %asi, %r10
	.word 0xd6c42870  ! 1: LDSWA_I	ldswa	[%r16, + 0x0870] %asi, %r11
	.word 0xee04282c  ! 1: LDUW_I	lduw	[%r16 + 0x082c], %r23
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6dc2fa8  ! 1: LDXA_I	ldxa	[%r16, + 0x0fa8] %asi, %r3
	.word 0xce842ad8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ad8] %asi, %r7
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xcc4c2ed6  ! 1: LDSB_I	ldsb	[%r16 + 0x0ed6], %r6
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_259
	dec %r31
	.word 0x913c0002  ! 1: SRA_R	sra 	%r16, %r2, %r8
	.word 0xad343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r22
        mov 0x18, %r31
thr3_loop_cnt_260:
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r26
	.word 0xd04c267f  ! 1: LDSB_I	ldsb	[%r16 + 0x067f], %r8
	.word 0xce542980  ! 1: LDSH_I	ldsh	[%r16 + 0x0980], %r7
	.word 0xf25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r25
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	.word 0xded421d6  ! 1: LDSHA_I	ldsha	[%r16, + 0x01d6] %asi, %r15
	.word 0xea942438  ! 1: LDUHA_I	lduha	[%r16, + 0x0438] %asi, %r21
	brnz %r31,thr3_loop_cnt_260
	dec %r31
	.word 0x90242b87  ! 1: SUB_I	sub 	%r16, 0x0b87, %r8
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x9f2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r15
	.word 0x862c2d11  ! 1: ANDN_I	andn 	%r16, 0x0d11, %r3
        mov 0x15, %r31
thr3_loop_cnt_261:
	.word 0xc6c42584  ! 1: LDSWA_I	ldswa	[%r16, + 0x0584] %asi, %r3
	.word 0xc65c28e0  ! 1: LDX_I	ldx	[%r16 + 0x08e0], %r3
	.word 0xc614292c  ! 1: LDUH_I	lduh	[%r16 + 0x092c], %r3
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	.word 0xc6d42f8a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f8a] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r9
	brnz %r31,thr3_loop_cnt_261
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x863c264a  ! 1: XNOR_I	xnor 	%r16, 0x064a, %r3
        mov 0x98, %r31
thr3_loop_cnt_262:
	.word 0xde8c2b3d  ! 1: LDUBA_I	lduba	[%r16, + 0x0b3d] %asi, %r15
	.word 0xc6442550  ! 1: LDSW_I	ldsw	[%r16 + 0x0550], %r3
	.word 0xc6d42e4e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e4e] %asi, %r3
	.word 0xd40423ac  ! 1: LDUW_I	lduw	[%r16 + 0x03ac], %r10
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	.word 0xf80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r28
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe214288a  ! 1: LDUH_I	lduh	[%r16 + 0x088a], %r17
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	.word 0xfa941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r29
	brnz %r31,thr3_loop_cnt_262
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x35, %r31
thr3_loop_cnt_263:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xe6842844  ! 1: LDUWA_I	lduwa	[%r16, + 0x0844] %asi, %r19
	.word 0xc6142080  ! 1: LDUH_I	lduh	[%r16 + 0x0080], %r3
	.word 0xf0842e18  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e18] %asi, %r24
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r19
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xfcc42350  ! 1: LDSWA_I	ldswa	[%r16, + 0x0350] %asi, %r30
	.word 0xc60422dc  ! 1: LDUW_I	lduw	[%r16 + 0x02dc], %r3
	.word 0xc6d422de  ! 1: LDSHA_I	ldsha	[%r16, + 0x02de] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_263
	dec %r31
	.word 0x862c2303  ! 1: ANDN_I	andn 	%r16, 0x0303, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x86342b6e  ! 1: ORN_I	orn 	%r16, 0x0b6e, %r3
        mov 0x18, %r31
thr3_loop_cnt_264:
	.word 0xf65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r27
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xe69423f4  ! 1: LDUHA_I	lduha	[%r16, + 0x03f4] %asi, %r19
	.word 0xc6c42f24  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f24] %asi, %r3
	.word 0xec5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r22
	.word 0xc6c42170  ! 1: LDSWA_I	ldswa	[%r16, + 0x0170] %asi, %r3
	.word 0xc6d42846  ! 1: LDSHA_I	ldsha	[%r16, + 0x0846] %asi, %r3
	.word 0xea142bbe  ! 1: LDUH_I	lduh	[%r16 + 0x0bbe], %r21
	brnz %r31,thr3_loop_cnt_264
	dec %r31
	.word 0xac040002  ! 1: ADD_R	add 	%r16, %r2, %r22
	.word 0x86342261  ! 1: SUBC_I	orn 	%r16, 0x0261, %r3
	.word 0xba3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r29
	.word 0xa42c26a3  ! 1: ANDN_I	andn 	%r16, 0x06a3, %r18
        mov 0x35, %r31
thr3_loop_cnt_265:
	.word 0xc60c2912  ! 1: LDUB_I	ldub	[%r16 + 0x0912], %r3
	.word 0xd8c42184  ! 1: LDSWA_I	ldswa	[%r16, + 0x0184] %asi, %r12
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	.word 0xd2542de6  ! 1: LDSH_I	ldsh	[%r16 + 0x0de6], %r9
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r26
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_265
	dec %r31
        mov 0x2e, %r31
thr3_loop_cnt_266:
	.word 0xd65c23a8  ! 1: LDX_I	ldx	[%r16 + 0x03a8], %r11
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6cc22c8  ! 1: LDSBA_I	ldsba	[%r16, + 0x02c8] %asi, %r3
	.word 0xe4c42338  ! 1: LDSWA_I	ldswa	[%r16, + 0x0338] %asi, %r18
	.word 0xd88c24f0  ! 1: LDUBA_I	lduba	[%r16, + 0x04f0] %asi, %r12
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	.word 0xf2942082  ! 1: LDUHA_I	lduha	[%r16, + 0x0082] %asi, %r25
	.word 0xd6942dec  ! 1: LDUHA_I	lduha	[%r16, + 0x0dec] %asi, %r11
	brnz %r31,thr3_loop_cnt_266
	dec %r31
	.word 0x92442714  ! 1: ADDC_I	addc 	%r16, 0x0714, %r9
	.word 0xa4342f84  ! 1: SUBC_I	orn 	%r16, 0x0f84, %r18
	.word 0xba2c2fcb  ! 1: ANDN_I	andn 	%r16, 0x0fcb, %r29
        mov 0x1f, %r31
thr3_loop_cnt_267:
	.word 0xce0421e0  ! 1: LDUW_I	lduw	[%r16 + 0x01e0], %r7
	.word 0xc6cc2cc4  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cc4] %asi, %r3
	.word 0xea540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r21
	.word 0xf8042d84  ! 1: LDUW_I	lduw	[%r16 + 0x0d84], %r28
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xf8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r28
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc60c22ad  ! 1: LDUB_I	ldub	[%r16 + 0x02ad], %r3
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	brnz %r31,thr3_loop_cnt_267
	dec %r31
	.word 0x86142dfa  ! 1: OR_I	or 	%r16, 0x0dfa, %r3
        mov 0x5, %r31
thr3_loop_cnt_268:
	.word 0xf05428fe  ! 1: LDSH_I	ldsh	[%r16 + 0x08fe], %r24
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64424f8  ! 1: LDSW_I	ldsw	[%r16 + 0x04f8], %r3
	.word 0xc64c2c24  ! 1: LDSB_I	ldsb	[%r16 + 0x0c24], %r3
	.word 0xc60c2088  ! 1: LDUB_I	ldub	[%r16 + 0x0088], %r3
	.word 0xee941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r23
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf6c42c24  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c24] %asi, %r27
	.word 0xf6c42e9c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e9c] %asi, %r27
	brnz %r31,thr3_loop_cnt_268
	dec %r31
        mov 0x28, %r31
thr3_loop_cnt_269:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6842ae0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ae0] %asi, %r3
	.word 0xd88c2d3c  ! 1: LDUBA_I	lduba	[%r16, + 0x0d3c] %asi, %r12
	.word 0xf4142384  ! 1: LDUH_I	lduh	[%r16 + 0x0384], %r26
	.word 0xf48c21f8  ! 1: LDUBA_I	lduba	[%r16, + 0x01f8] %asi, %r26
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_269
	dec %r31
        mov 0x83, %r31
thr3_loop_cnt_270:
	.word 0xec0c2523  ! 1: LDUB_I	ldub	[%r16 + 0x0523], %r22
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	.word 0xe654208c  ! 1: LDSH_I	ldsh	[%r16 + 0x008c], %r19
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf6cc2c94  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c94] %asi, %r27
	.word 0xe64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r19
	.word 0xc6d42180  ! 1: LDSHA_I	ldsha	[%r16, + 0x0180] %asi, %r3
	.word 0xf0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r24
	.word 0xea44244c  ! 1: LDSW_I	ldsw	[%r16 + 0x044c], %r21
	brnz %r31,thr3_loop_cnt_270
	dec %r31
        mov 0x44, %r31
thr3_loop_cnt_271:
	.word 0xc64c2e91  ! 1: LDSB_I	ldsb	[%r16 + 0x0e91], %r3
	.word 0xc68c2836  ! 1: LDUBA_I	lduba	[%r16, + 0x0836] %asi, %r3
	.word 0xf4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r26
	.word 0xc64c2008  ! 1: LDSB_I	ldsb	[%r16 + 0x0008], %r3
	.word 0xec842c60  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c60] %asi, %r22
	.word 0xf4cc2bd9  ! 1: LDSBA_I	ldsba	[%r16, + 0x0bd9] %asi, %r26
	.word 0xd2dc2360  ! 1: LDXA_I	ldxa	[%r16, + 0x0360] %asi, %r9
	.word 0xe8d42e90  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e90] %asi, %r20
	brnz %r31,thr3_loop_cnt_271
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x86442d37  ! 1: ADDC_I	addc 	%r16, 0x0d37, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0xb81c28a0  ! 1: XOR_I	xor 	%r16, 0x08a0, %r28
        mov 0x2b, %r31
thr3_loop_cnt_272:
	.word 0xf0942198  ! 1: LDUHA_I	lduha	[%r16, + 0x0198] %asi, %r24
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	.word 0xc6c42164  ! 1: LDSWA_I	ldswa	[%r16, + 0x0164] %asi, %r3
	.word 0xc68420ac  ! 1: LDUWA_I	lduwa	[%r16, + 0x00ac] %asi, %r3
	.word 0xd40c26b5  ! 1: LDUB_I	ldub	[%r16 + 0x06b5], %r10
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xc6142df6  ! 1: LDUH_I	lduh	[%r16 + 0x0df6], %r3
	.word 0xfc8c2fda  ! 1: LDUBA_I	lduba	[%r16, + 0x0fda] %asi, %r30
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_272
	dec %r31
	.word 0xb40c27e3  ! 1: AND_I	and 	%r16, 0x07e3, %r26
	.word 0xb7342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r27
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x33, %r31
thr3_loop_cnt_273:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	.word 0xec4422ec  ! 1: LDSW_I	ldsw	[%r16 + 0x02ec], %r22
	.word 0xc68c2a10  ! 1: LDUBA_I	lduba	[%r16, + 0x0a10] %asi, %r3
	.word 0xecd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r22
	.word 0xc6542308  ! 1: LDSH_I	ldsh	[%r16 + 0x0308], %r3
	.word 0xec540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r22
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_273
	dec %r31
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x8c2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r6
        mov 0x88, %r31
thr3_loop_cnt_274:
	.word 0xd21423f2  ! 1: LDUH_I	lduh	[%r16 + 0x03f2], %r9
	.word 0xe4542252  ! 1: LDSH_I	ldsh	[%r16 + 0x0252], %r18
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xcc84237c  ! 1: LDUWA_I	lduwa	[%r16, + 0x037c] %asi, %r6
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6942b8c  ! 1: LDUHA_I	lduha	[%r16, + 0x0b8c] %asi, %r3
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xc6942f20  ! 1: LDUHA_I	lduha	[%r16, + 0x0f20] %asi, %r3
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	.word 0xd84c2be7  ! 1: LDSB_I	ldsb	[%r16 + 0x0be7], %r12
	brnz %r31,thr3_loop_cnt_274
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x22, %r31
thr3_loop_cnt_275:
	.word 0xf4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r26
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6042684  ! 1: LDUW_I	lduw	[%r16 + 0x0684], %r3
	.word 0xf4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r26
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xec841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r22
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xe48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r18
	.word 0xe2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r17
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_275
	dec %r31
        mov 0x63, %r31
thr3_loop_cnt_276:
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	.word 0xc684271c  ! 1: LDUWA_I	lduwa	[%r16, + 0x071c] %asi, %r3
	.word 0xfacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r29
	.word 0xe2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r17
	.word 0xecc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r22
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xda4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r13
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	.word 0xec142716  ! 1: LDUH_I	lduh	[%r16 + 0x0716], %r22
	.word 0xc604285c  ! 1: LDUW_I	lduw	[%r16 + 0x085c], %r3
	brnz %r31,thr3_loop_cnt_276
	dec %r31
        mov 0x79, %r31
thr3_loop_cnt_277:
	.word 0xeadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r21
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6542400  ! 1: LDSH_I	ldsh	[%r16 + 0x0400], %r3
	.word 0xd20c2aba  ! 1: LDUB_I	ldub	[%r16 + 0x0aba], %r9
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xdc842908  ! 1: LDUWA_I	lduwa	[%r16, + 0x0908] %asi, %r14
	.word 0xc6042890  ! 1: LDUW_I	lduw	[%r16 + 0x0890], %r3
	brnz %r31,thr3_loop_cnt_277
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x9b, %r31
thr3_loop_cnt_278:
	.word 0xe80c2782  ! 1: LDUB_I	ldub	[%r16 + 0x0782], %r20
	.word 0xf2442b20  ! 1: LDSW_I	ldsw	[%r16 + 0x0b20], %r25
	.word 0xc6142c70  ! 1: LDUH_I	lduh	[%r16 + 0x0c70], %r3
	.word 0xc6d42fc8  ! 1: LDSHA_I	ldsha	[%r16, + 0x0fc8] %asi, %r3
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xfc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r30
	.word 0xe4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r18
	.word 0xd6042490  ! 1: LDUW_I	lduw	[%r16 + 0x0490], %r11
	brnz %r31,thr3_loop_cnt_278
	dec %r31
	.word 0x861c2d45  ! 1: XOR_I	xor 	%r16, 0x0d45, %r3
	.word 0x862424fc  ! 1: SUB_I	sub 	%r16, 0x04fc, %r3
	.word 0x862c2751  ! 1: ANDN_I	andn 	%r16, 0x0751, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0x4b, %r31
thr3_loop_cnt_279:
	.word 0xc6cc2c99  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c99] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf8c42640  ! 1: LDSWA_I	ldswa	[%r16, + 0x0640] %asi, %r28
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6d421c4  ! 1: LDSHA_I	ldsha	[%r16, + 0x01c4] %asi, %r3
	.word 0xe45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r18
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	.word 0xc65c2ef0  ! 1: LDX_I	ldx	[%r16 + 0x0ef0], %r3
	.word 0xc6442ffc  ! 1: LDSW_I	ldsw	[%r16 + 0x0ffc], %r3
	brnz %r31,thr3_loop_cnt_279
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x7f, %r31
thr3_loop_cnt_280:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xeac425ac  ! 1: LDSWA_I	ldswa	[%r16, + 0x05ac] %asi, %r21
	.word 0xd2842644  ! 1: LDUWA_I	lduwa	[%r16, + 0x0644] %asi, %r9
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	.word 0xd8d42186  ! 1: LDSHA_I	ldsha	[%r16, + 0x0186] %asi, %r12
	.word 0xeec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r23
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe8d425a2  ! 1: LDSHA_I	ldsha	[%r16, + 0x05a2] %asi, %r20
	brnz %r31,thr3_loop_cnt_280
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0xa64422c0  ! 1: ADDC_I	addc 	%r16, 0x02c0, %r19
        mov 0x68, %r31
thr3_loop_cnt_281:
	.word 0xd8dc28b8  ! 1: LDXA_I	ldxa	[%r16, + 0x08b8] %asi, %r12
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf4c42ae0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ae0] %asi, %r26
	.word 0xc64426a4  ! 1: LDSW_I	ldsw	[%r16 + 0x06a4], %r3
	.word 0xce9420c6  ! 1: LDUHA_I	lduha	[%r16, + 0x00c6] %asi, %r7
	.word 0xc6042fb8  ! 1: LDUW_I	lduw	[%r16 + 0x0fb8], %r3
	.word 0xd8142c4e  ! 1: LDUH_I	lduh	[%r16 + 0x0c4e], %r12
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xec8422b4  ! 1: LDUWA_I	lduwa	[%r16, + 0x02b4] %asi, %r22
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_281
	dec %r31
	.word 0x9d341002  ! 1: SRLX_R	srlx	%r16, %r2, %r14
        mov 0x5b, %r31
thr3_loop_cnt_282:
	.word 0xc6cc2e8f  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e8f] %asi, %r3
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	.word 0xec042920  ! 1: LDUW_I	lduw	[%r16 + 0x0920], %r22
	.word 0xe6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r19
	.word 0xc6042c14  ! 1: LDUW_I	lduw	[%r16 + 0x0c14], %r3
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xe4842b04  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b04] %asi, %r18
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_282
	dec %r31
	.word 0x932c0002  ! 1: SLL_R	sll 	%r16, %r2, %r9
	.word 0xb6440002  ! 1: ADDC_R	addc 	%r16, %r2, %r27
	.word 0x860c29fa  ! 1: AND_I	and 	%r16, 0x09fa, %r3
        mov 0x2d, %r31
thr3_loop_cnt_283:
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xda540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r13
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6c42318  ! 1: LDSWA_I	ldswa	[%r16, + 0x0318] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_283
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x51, %r31
thr3_loop_cnt_284:
	.word 0xc68c2af1  ! 1: LDUBA_I	lduba	[%r16, + 0x0af1] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6d42ab0  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ab0] %asi, %r3
	.word 0xe2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r17
	.word 0xcc942f78  ! 1: LDUHA_I	lduha	[%r16, + 0x0f78] %asi, %r6
	.word 0xc6142dea  ! 1: LDUH_I	lduh	[%r16 + 0x0dea], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc64c22ec  ! 1: LDSB_I	ldsb	[%r16 + 0x02ec], %r3
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	brnz %r31,thr3_loop_cnt_284
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x73, %r31
thr3_loop_cnt_285:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xeac4260c  ! 1: LDSWA_I	ldswa	[%r16, + 0x060c] %asi, %r21
	.word 0xd0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r8
	.word 0xc6942f0c  ! 1: LDUHA_I	lduha	[%r16, + 0x0f0c] %asi, %r3
	.word 0xf60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r27
	.word 0xc64c2dba  ! 1: LDSB_I	ldsb	[%r16 + 0x0dba], %r3
	.word 0xf054278a  ! 1: LDSH_I	ldsh	[%r16 + 0x078a], %r24
	.word 0xf4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r26
	brnz %r31,thr3_loop_cnt_285
	dec %r31
        mov 0x58, %r31
thr3_loop_cnt_286:
	.word 0xfadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r29
	.word 0xd0dc2498  ! 1: LDXA_I	ldxa	[%r16, + 0x0498] %asi, %r8
	.word 0xce4c2d63  ! 1: LDSB_I	ldsb	[%r16 + 0x0d63], %r7
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	.word 0xc6d42342  ! 1: LDSHA_I	ldsha	[%r16, + 0x0342] %asi, %r3
	.word 0xecdc2968  ! 1: LDXA_I	ldxa	[%r16, + 0x0968] %asi, %r22
	.word 0xf0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r24
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xfac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r29
	.word 0xc6cc215a  ! 1: LDSBA_I	ldsba	[%r16, + 0x015a] %asi, %r3
	brnz %r31,thr3_loop_cnt_286
	dec %r31
	.word 0xb6440002  ! 1: ADDC_R	addc 	%r16, %r2, %r27
	.word 0xab340002  ! 1: SRL_R	srl 	%r16, %r2, %r21
	.word 0x903c2323  ! 1: XNOR_I	xnor 	%r16, 0x0323, %r8
	.word 0x972c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r11
        mov 0x5d, %r31
thr3_loop_cnt_287:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf20c2756  ! 1: LDUB_I	ldub	[%r16 + 0x0756], %r25
	.word 0xd4942342  ! 1: LDUHA_I	lduha	[%r16, + 0x0342] %asi, %r10
	.word 0xe85c2830  ! 1: LDX_I	ldx	[%r16 + 0x0830], %r20
	.word 0xc68c2e45  ! 1: LDUBA_I	lduba	[%r16, + 0x0e45] %asi, %r3
	.word 0xc6cc28db  ! 1: LDSBA_I	ldsba	[%r16, + 0x08db] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xcc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r6
	.word 0xe4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r18
	.word 0xde440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r15
	.word 0xde0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r15
	brnz %r31,thr3_loop_cnt_287
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x18, %r31
thr3_loop_cnt_288:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xda5c2268  ! 1: LDX_I	ldx	[%r16 + 0x0268], %r13
	.word 0xce4c28d6  ! 1: LDSB_I	ldsb	[%r16 + 0x08d6], %r7
	.word 0xc60c2fae  ! 1: LDUB_I	ldub	[%r16 + 0x0fae], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r24
	.word 0xc6542c2c  ! 1: LDSH_I	ldsh	[%r16 + 0x0c2c], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	brnz %r31,thr3_loop_cnt_288
	dec %r31
        mov 0x5d, %r31
thr3_loop_cnt_289:
	.word 0xec442e34  ! 1: LDSW_I	ldsw	[%r16 + 0x0e34], %r22
	.word 0xf4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r26
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r9
	.word 0xfac424f4  ! 1: LDSWA_I	ldswa	[%r16, + 0x04f4] %asi, %r29
	.word 0xc6442ac8  ! 1: LDSW_I	ldsw	[%r16 + 0x0ac8], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xfc5c2bb8  ! 1: LDX_I	ldx	[%r16 + 0x0bb8], %r30
	brnz %r31,thr3_loop_cnt_289
	dec %r31
	.word 0xb7342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r27
        mov 0x5e, %r31
thr3_loop_cnt_290:
	.word 0xe64c210b  ! 1: LDSB_I	ldsb	[%r16 + 0x010b], %r19
	.word 0xe2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r17
	.word 0xd41425fe  ! 1: LDUH_I	lduh	[%r16 + 0x05fe], %r10
	.word 0xde8c28d1  ! 1: LDUBA_I	lduba	[%r16, + 0x08d1] %asi, %r15
	.word 0xc6142a44  ! 1: LDUH_I	lduh	[%r16 + 0x0a44], %r3
	.word 0xfa941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r29
	.word 0xdad42742  ! 1: LDSHA_I	ldsha	[%r16, + 0x0742] %asi, %r13
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_290
	dec %r31
	.word 0x922c2dd3  ! 1: ANDN_I	andn 	%r16, 0x0dd3, %r9
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x8634208a  ! 1: SUBC_I	orn 	%r16, 0x008a, %r3
        mov 0x30, %r31
thr3_loop_cnt_291:
	.word 0xc6d42f8c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f8c] %asi, %r3
	.word 0xe2c424a8  ! 1: LDSWA_I	ldswa	[%r16, + 0x04a8] %asi, %r17
	.word 0xce8c2605  ! 1: LDUBA_I	lduba	[%r16, + 0x0605] %asi, %r7
	.word 0xd8842b60  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b60] %asi, %r12
	.word 0xf4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r26
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r28
	.word 0xce0c23fb  ! 1: LDUB_I	ldub	[%r16 + 0x03fb], %r7
	brnz %r31,thr3_loop_cnt_291
	dec %r31
	.word 0xb22c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r25
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0x62, %r31
thr3_loop_cnt_292:
	.word 0xe6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r19
	.word 0xf8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r28
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6d42850  ! 1: LDSHA_I	ldsha	[%r16, + 0x0850] %asi, %r3
	.word 0xe4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r18
	.word 0xec040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r22
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe2942f3e  ! 1: LDUHA_I	lduha	[%r16, + 0x0f3e] %asi, %r17
	.word 0xde440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r15
	brnz %r31,thr3_loop_cnt_292
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x861c27df  ! 1: XOR_I	xor 	%r16, 0x07df, %r3
	.word 0x86042e7f  ! 1: ADD_I	add 	%r16, 0x0e7f, %r3
        mov 0x20, %r31
thr3_loop_cnt_293:
	.word 0xe45420ee  ! 1: LDSH_I	ldsh	[%r16 + 0x00ee], %r18
	.word 0xd6042e8c  ! 1: LDUW_I	lduw	[%r16 + 0x0e8c], %r11
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r10
	.word 0xd80c230d  ! 1: LDUB_I	ldub	[%r16 + 0x030d], %r12
	.word 0xd4042338  ! 1: LDUW_I	lduw	[%r16 + 0x0338], %r10
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xfc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r30
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xee040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r23
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xec842fb0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0fb0] %asi, %r22
	brnz %r31,thr3_loop_cnt_293
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x8d3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r6
	.word 0xba0c244b  ! 1: AND_I	and 	%r16, 0x044b, %r29
        mov 0x3e, %r31
thr3_loop_cnt_294:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc65c2f80  ! 1: LDX_I	ldx	[%r16 + 0x0f80], %r3
	.word 0xc614213c  ! 1: LDUH_I	lduh	[%r16 + 0x013c], %r3
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xc60c20c3  ! 1: LDUB_I	ldub	[%r16 + 0x00c3], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r24
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xee4421e4  ! 1: LDSW_I	ldsw	[%r16 + 0x01e4], %r23
	brnz %r31,thr3_loop_cnt_294
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0x38, %r31
thr3_loop_cnt_295:
	.word 0xce4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r7
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2024  ! 1: LDSBA_I	ldsba	[%r16, + 0x0024] %asi, %r3
	.word 0xc6c42758  ! 1: LDSWA_I	ldswa	[%r16, + 0x0758] %asi, %r3
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xc6442d4c  ! 1: LDSW_I	ldsw	[%r16 + 0x0d4c], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6542892  ! 1: LDSH_I	ldsh	[%r16 + 0x0892], %r3
	.word 0xc6cc2429  ! 1: LDSBA_I	ldsba	[%r16, + 0x0429] %asi, %r3
	brnz %r31,thr3_loop_cnt_295
	dec %r31
        mov 0x4d, %r31
thr3_loop_cnt_296:
	.word 0xd8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r12
	.word 0xc64c224a  ! 1: LDSB_I	ldsb	[%r16 + 0x024a], %r3
	.word 0xc61428d2  ! 1: LDUH_I	lduh	[%r16 + 0x08d2], %r3
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r26
	.word 0xfcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r30
	.word 0xc65c2a48  ! 1: LDX_I	ldx	[%r16 + 0x0a48], %r3
	brnz %r31,thr3_loop_cnt_296
	dec %r31
	.word 0x9d341002  ! 1: SRLX_R	srlx	%r16, %r2, %r14
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0xb224234c  ! 1: SUB_I	sub 	%r16, 0x034c, %r25
        mov 0x0, %r31
thr3_loop_cnt_297:
	.word 0xf2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r25
	.word 0xe8942ace  ! 1: LDUHA_I	lduha	[%r16, + 0x0ace] %asi, %r20
	.word 0xcc04236c  ! 1: LDUW_I	lduw	[%r16 + 0x036c], %r6
	.word 0xcc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r6
	.word 0xc6d4252e  ! 1: LDSHA_I	ldsha	[%r16, + 0x052e] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc64c2905  ! 1: LDSB_I	ldsb	[%r16 + 0x0905], %r3
	.word 0xd0542e26  ! 1: LDSH_I	ldsh	[%r16 + 0x0e26], %r8
	.word 0xc6c42a68  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a68] %asi, %r3
	.word 0xfacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r29
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_297
	dec %r31
        mov 0x12, %r31
thr3_loop_cnt_298:
	.word 0xc6c42508  ! 1: LDSWA_I	ldswa	[%r16, + 0x0508] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6442438  ! 1: LDSW_I	ldsw	[%r16 + 0x0438], %r3
	.word 0xd0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r8
	.word 0xc6d42f72  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f72] %asi, %r3
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xc68c20d4  ! 1: LDUBA_I	lduba	[%r16, + 0x00d4] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2500  ! 1: LDXA_I	ldxa	[%r16, + 0x0500] %asi, %r3
	.word 0xea042ca0  ! 1: LDUW_I	lduw	[%r16 + 0x0ca0], %r21
	brnz %r31,thr3_loop_cnt_298
	dec %r31
        mov 0x27, %r31
thr3_loop_cnt_299:
	.word 0xdc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r14
	.word 0xc60c2088  ! 1: LDUB_I	ldub	[%r16 + 0x0088], %r3
	.word 0xd8c42e5c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e5c] %asi, %r12
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc65c2a70  ! 1: LDX_I	ldx	[%r16 + 0x0a70], %r3
	.word 0xecdc27a0  ! 1: LDXA_I	ldxa	[%r16, + 0x07a0] %asi, %r22
	.word 0xee040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r23
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	brnz %r31,thr3_loop_cnt_299
	dec %r31
	.word 0xb62c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r27
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x920c2489  ! 1: AND_I	and 	%r16, 0x0489, %r9
        mov 0x29, %r31
thr3_loop_cnt_300:
	.word 0xc65424b6  ! 1: LDSH_I	ldsh	[%r16 + 0x04b6], %r3
	.word 0xdcdc2c48  ! 1: LDXA_I	ldxa	[%r16, + 0x0c48] %asi, %r14
	.word 0xfac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r29
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xfa4c28f3  ! 1: LDSB_I	ldsb	[%r16 + 0x08f3], %r29
	.word 0xde5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r15
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe4842498  ! 1: LDUWA_I	lduwa	[%r16, + 0x0498] %asi, %r18
	brnz %r31,thr3_loop_cnt_300
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x86242ba0  ! 1: SUB_I	sub 	%r16, 0x0ba0, %r3
	.word 0x86442add  ! 1: ADDC_I	addc 	%r16, 0x0add, %r3
	.word 0xa6140002  ! 1: OR_R	or 	%r16, %r2, %r19
        mov 0x78, %r31
thr3_loop_cnt_301:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6c42690  ! 1: LDSWA_I	ldswa	[%r16, + 0x0690] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf68c2d13  ! 1: LDUBA_I	lduba	[%r16, + 0x0d13] %asi, %r27
	.word 0xe2d4259a  ! 1: LDSHA_I	ldsha	[%r16, + 0x059a] %asi, %r17
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xfa5c2e80  ! 1: LDX_I	ldx	[%r16 + 0x0e80], %r29
	.word 0xfa9423a4  ! 1: LDUHA_I	lduha	[%r16, + 0x03a4] %asi, %r29
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xd044238c  ! 1: LDSW_I	ldsw	[%r16 + 0x038c], %r8
	brnz %r31,thr3_loop_cnt_301
	dec %r31
        mov 0x2, %r31
thr3_loop_cnt_302:
	.word 0xced41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r7
	.word 0xd2942d7c  ! 1: LDUHA_I	lduha	[%r16, + 0x0d7c] %asi, %r9
	.word 0xe6442680  ! 1: LDSW_I	ldsw	[%r16 + 0x0680], %r19
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xced41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r7
	.word 0xf88429fc  ! 1: LDUWA_I	lduwa	[%r16, + 0x09fc] %asi, %r28
	.word 0xdadc2dd8  ! 1: LDXA_I	ldxa	[%r16, + 0x0dd8] %asi, %r13
	.word 0xec84272c  ! 1: LDUWA_I	lduwa	[%r16, + 0x072c] %asi, %r22
	.word 0xde942d1c  ! 1: LDUHA_I	lduha	[%r16, + 0x0d1c] %asi, %r15
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc68c2007  ! 1: LDUBA_I	lduba	[%r16, + 0x0007] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_302
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x8d341002  ! 1: SRLX_R	srlx	%r16, %r2, %r6
	.word 0x96042efc  ! 1: ADD_I	add 	%r16, 0x0efc, %r11
	.word 0x86442603  ! 1: ADDC_I	addc 	%r16, 0x0603, %r3
        mov 0x2d, %r31
thr3_loop_cnt_303:
	.word 0xc64429f8  ! 1: LDSW_I	ldsw	[%r16 + 0x09f8], %r3
	.word 0xc6dc2f78  ! 1: LDXA_I	ldxa	[%r16, + 0x0f78] %asi, %r3
	.word 0xd0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r8
	.word 0xc68c2d15  ! 1: LDUBA_I	lduba	[%r16, + 0x0d15] %asi, %r3
	.word 0xce1427d6  ! 1: LDUH_I	lduh	[%r16 + 0x07d6], %r7
	.word 0xeadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r21
	.word 0xe4542c66  ! 1: LDSH_I	ldsh	[%r16 + 0x0c66], %r18
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_303
	dec %r31
        mov 0x59, %r31
thr3_loop_cnt_304:
	.word 0xf48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r26
	.word 0xc6d429cc  ! 1: LDSHA_I	ldsha	[%r16, + 0x09cc] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe28c23c9  ! 1: LDUBA_I	lduba	[%r16, + 0x03c9] %asi, %r17
	.word 0xee5c23d0  ! 1: LDX_I	ldx	[%r16 + 0x03d0], %r23
	.word 0xf6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r27
	.word 0xeccc26fe  ! 1: LDSBA_I	ldsba	[%r16, + 0x06fe] %asi, %r22
	.word 0xce440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r7
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_304
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x8c042751  ! 1: ADD_I	add 	%r16, 0x0751, %r6
	.word 0x9c242840  ! 1: SUB_I	sub 	%r16, 0x0840, %r14
        mov 0xc4, %r31
thr3_loop_cnt_305:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6c4259c  ! 1: LDSWA_I	ldswa	[%r16, + 0x059c] %asi, %r3
	.word 0xf2442cf0  ! 1: LDSW_I	ldsw	[%r16 + 0x0cf0], %r25
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6cc2d12  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d12] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc65427d8  ! 1: LDSH_I	ldsh	[%r16 + 0x07d8], %r3
	.word 0xc6442af0  ! 1: LDSW_I	ldsw	[%r16 + 0x0af0], %r3
	.word 0xc68c2344  ! 1: LDUBA_I	lduba	[%r16, + 0x0344] %asi, %r3
	.word 0xc65c2078  ! 1: LDX_I	ldx	[%r16 + 0x0078], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_305
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x922c235b  ! 1: ANDN_I	andn 	%r16, 0x035b, %r9
	.word 0xb0042ee3  ! 1: ADD_I	add 	%r16, 0x0ee3, %r24
	.word 0xba240002  ! 1: SUB_R	sub 	%r16, %r2, %r29
        mov 0x99, %r31
thr3_loop_cnt_306:
	.word 0xda942c1e  ! 1: LDUHA_I	lduha	[%r16, + 0x0c1e] %asi, %r13
	.word 0xcc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r6
	.word 0xc60c2a88  ! 1: LDUB_I	ldub	[%r16 + 0x0a88], %r3
	.word 0xe4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r18
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd65c2470  ! 1: LDX_I	ldx	[%r16 + 0x0470], %r11
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc60423a0  ! 1: LDUW_I	lduw	[%r16 + 0x03a0], %r3
	.word 0xea842360  ! 1: LDUWA_I	lduwa	[%r16, + 0x0360] %asi, %r21
	.word 0xea5c2190  ! 1: LDX_I	ldx	[%r16 + 0x0190], %r21
	.word 0xced41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r7
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	brnz %r31,thr3_loop_cnt_306
	dec %r31
        mov 0x8f, %r31
thr3_loop_cnt_307:
	.word 0xde842dd0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0dd0] %asi, %r15
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc644274c  ! 1: LDSW_I	ldsw	[%r16 + 0x074c], %r3
	.word 0xc69426cc  ! 1: LDUHA_I	lduha	[%r16, + 0x06cc] %asi, %r3
	.word 0xdedc2e78  ! 1: LDXA_I	ldxa	[%r16, + 0x0e78] %asi, %r15
	.word 0xc6c42f6c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f6c] %asi, %r3
	.word 0xcc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r6
	.word 0xc6c424d0  ! 1: LDSWA_I	ldswa	[%r16, + 0x04d0] %asi, %r3
	.word 0xfcc428a8  ! 1: LDSWA_I	ldswa	[%r16, + 0x08a8] %asi, %r30
	.word 0xec442c68  ! 1: LDSW_I	ldsw	[%r16 + 0x0c68], %r22
	brnz %r31,thr3_loop_cnt_307
	dec %r31
	.word 0xa42c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r18
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0xb33c0002  ! 1: SRA_R	sra 	%r16, %r2, %r25
        mov 0x75, %r31
thr3_loop_cnt_308:
	.word 0xc65c29f0  ! 1: LDX_I	ldx	[%r16 + 0x09f0], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf44c2fa4  ! 1: LDSB_I	ldsb	[%r16 + 0x0fa4], %r26
	.word 0xc6c423e0  ! 1: LDSWA_I	ldswa	[%r16, + 0x03e0] %asi, %r3
	.word 0xcc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r6
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xc6dc2b98  ! 1: LDXA_I	ldxa	[%r16, + 0x0b98] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_308
	dec %r31
	.word 0x9a142611  ! 1: OR_I	or 	%r16, 0x0611, %r13
	.word 0x9a340002  ! 1: SUBC_R	orn 	%r16, %r2, %r13
        mov 0xc, %r31
thr3_loop_cnt_309:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc64c25b3  ! 1: LDSB_I	ldsb	[%r16 + 0x05b3], %r3
	.word 0xf05c2290  ! 1: LDX_I	ldx	[%r16 + 0x0290], %r24
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xc6542bf4  ! 1: LDSH_I	ldsh	[%r16 + 0x0bf4], %r3
	.word 0xf05c2980  ! 1: LDX_I	ldx	[%r16 + 0x0980], %r24
	.word 0xc6442880  ! 1: LDSW_I	ldsw	[%r16 + 0x0880], %r3
	.word 0xc654243e  ! 1: LDSH_I	ldsh	[%r16 + 0x043e], %r3
	brnz %r31,thr3_loop_cnt_309
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0xbb2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r29
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x98, %r31
thr3_loop_cnt_310:
	.word 0xc684219c  ! 1: LDUWA_I	lduwa	[%r16, + 0x019c] %asi, %r3
	.word 0xc6442000  ! 1: LDSW_I	ldsw	[%r16 + 0x0000], %r3
	.word 0xf65c2580  ! 1: LDX_I	ldx	[%r16 + 0x0580], %r27
	.word 0xc64c2864  ! 1: LDSB_I	ldsb	[%r16 + 0x0864], %r3
	.word 0xd0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r8
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf4842648  ! 1: LDUWA_I	lduwa	[%r16, + 0x0648] %asi, %r26
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd60423f8  ! 1: LDUW_I	lduw	[%r16 + 0x03f8], %r11
	brnz %r31,thr3_loop_cnt_310
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0x71, %r31
thr3_loop_cnt_311:
	.word 0xde8429b4  ! 1: LDUWA_I	lduwa	[%r16, + 0x09b4] %asi, %r15
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r10
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf2542b2c  ! 1: LDSH_I	ldsh	[%r16 + 0x0b2c], %r25
	.word 0xc65c2600  ! 1: LDX_I	ldx	[%r16 + 0x0600], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xea542422  ! 1: LDSH_I	ldsh	[%r16 + 0x0422], %r21
	.word 0xf28c27c1  ! 1: LDUBA_I	lduba	[%r16, + 0x07c1] %asi, %r25
	.word 0xd64c2f9d  ! 1: LDSB_I	ldsb	[%r16 + 0x0f9d], %r11
	.word 0xe48c288b  ! 1: LDUBA_I	lduba	[%r16, + 0x088b] %asi, %r18
	brnz %r31,thr3_loop_cnt_311
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0x73, %r31
thr3_loop_cnt_312:
	.word 0xfc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r30
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6442c68  ! 1: LDSW_I	ldsw	[%r16 + 0x0c68], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd8d4216a  ! 1: LDSHA_I	ldsha	[%r16, + 0x016a] %asi, %r12
	.word 0xe25c2c80  ! 1: LDX_I	ldx	[%r16 + 0x0c80], %r17
	.word 0xc68c2272  ! 1: LDUBA_I	lduba	[%r16, + 0x0272] %asi, %r3
	.word 0xf88c2c19  ! 1: LDUBA_I	lduba	[%r16, + 0x0c19] %asi, %r28
	.word 0xda540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r13
	.word 0xe40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r18
	brnz %r31,thr3_loop_cnt_312
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x2a, %r31
thr3_loop_cnt_313:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6d42360  ! 1: LDSHA_I	ldsha	[%r16, + 0x0360] %asi, %r3
	.word 0xc64421b8  ! 1: LDSW_I	ldsw	[%r16 + 0x01b8], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6842688  ! 1: LDUWA_I	lduwa	[%r16, + 0x0688] %asi, %r3
	.word 0xfc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r30
	.word 0xfadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r29
	.word 0xfcd42916  ! 1: LDSHA_I	ldsha	[%r16, + 0x0916] %asi, %r30
	.word 0xec440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r22
	.word 0xd2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r9
	brnz %r31,thr3_loop_cnt_313
	dec %r31
        mov 0x7d, %r31
thr3_loop_cnt_314:
	.word 0xc68c2502  ! 1: LDUBA_I	lduba	[%r16, + 0x0502] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c42990  ! 1: LDSWA_I	ldswa	[%r16, + 0x0990] %asi, %r3
	.word 0xec941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r22
	.word 0xc60c2d37  ! 1: LDUB_I	ldub	[%r16 + 0x0d37], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xe2542d92  ! 1: LDSH_I	ldsh	[%r16 + 0x0d92], %r17
	.word 0xfcc42104  ! 1: LDSWA_I	ldswa	[%r16, + 0x0104] %asi, %r30
	.word 0xde5429c6  ! 1: LDSH_I	ldsh	[%r16 + 0x09c6], %r15
	.word 0xc6c42798  ! 1: LDSWA_I	ldswa	[%r16, + 0x0798] %asi, %r3
	brnz %r31,thr3_loop_cnt_314
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0xb73c0002  ! 1: SRA_R	sra 	%r16, %r2, %r27
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x65, %r31
thr3_loop_cnt_315:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6d42d5c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d5c] %asi, %r3
	.word 0xd25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r9
	.word 0xc64c26c4  ! 1: LDSB_I	ldsb	[%r16 + 0x06c4], %r3
	.word 0xf65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r27
	.word 0xf6d42192  ! 1: LDSHA_I	ldsha	[%r16, + 0x0192] %asi, %r27
	.word 0xc6142334  ! 1: LDUH_I	lduh	[%r16 + 0x0334], %r3
	.word 0xc64422bc  ! 1: LDSW_I	ldsw	[%r16 + 0x02bc], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6442b2c  ! 1: LDSW_I	ldsw	[%r16 + 0x0b2c], %r3
	.word 0xec941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r22
	brnz %r31,thr3_loop_cnt_315
	dec %r31
	.word 0x861c2496  ! 1: XOR_I	xor 	%r16, 0x0496, %r3
	.word 0xb80427bb  ! 1: ADD_I	add 	%r16, 0x07bb, %r28
	.word 0x982c2c8a  ! 1: ANDN_I	andn 	%r16, 0x0c8a, %r12
        mov 0xc2, %r31
thr3_loop_cnt_316:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r26
	.word 0xe4042ba4  ! 1: LDUW_I	lduw	[%r16 + 0x0ba4], %r18
	.word 0xc64c2378  ! 1: LDSB_I	ldsb	[%r16 + 0x0378], %r3
	.word 0xc65c25b0  ! 1: LDX_I	ldx	[%r16 + 0x05b0], %r3
	.word 0xc6dc2a38  ! 1: LDXA_I	ldxa	[%r16, + 0x0a38] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xfc0429b4  ! 1: LDUW_I	lduw	[%r16 + 0x09b4], %r30
	.word 0xc694252e  ! 1: LDUHA_I	lduha	[%r16, + 0x052e] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_316
	dec %r31
	.word 0x9c4420b3  ! 1: ADDC_I	addc 	%r16, 0x00b3, %r14
        mov 0x2f, %r31
thr3_loop_cnt_317:
	.word 0xce941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r7
	.word 0xc6842338  ! 1: LDUWA_I	lduwa	[%r16, + 0x0338] %asi, %r3
	.word 0xfcd4255e  ! 1: LDSHA_I	ldsha	[%r16, + 0x055e] %asi, %r30
	.word 0xe4d42904  ! 1: LDSHA_I	ldsha	[%r16, + 0x0904] %asi, %r18
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d42ab6  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ab6] %asi, %r3
	brnz %r31,thr3_loop_cnt_317
	dec %r31
	.word 0x992c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r12
        mov 0xb9, %r31
thr3_loop_cnt_318:
	.word 0xc6942e54  ! 1: LDUHA_I	lduha	[%r16, + 0x0e54] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc68c2fbc  ! 1: LDUBA_I	lduba	[%r16, + 0x0fbc] %asi, %r3
	.word 0xcc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r6
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd454244e  ! 1: LDSH_I	ldsh	[%r16 + 0x044e], %r10
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	brnz %r31,thr3_loop_cnt_318
	dec %r31
	.word 0x961c2f64  ! 1: XOR_I	xor 	%r16, 0x0f64, %r11
	.word 0xbc1428de  ! 1: OR_I	or 	%r16, 0x08de, %r30
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0xaf341002  ! 1: SRLX_R	srlx	%r16, %r2, %r23
        mov 0x25, %r31
thr3_loop_cnt_319:
	.word 0xc68424b0  ! 1: LDUWA_I	lduwa	[%r16, + 0x04b0] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r11
	.word 0xc6cc2496  ! 1: LDSBA_I	ldsba	[%r16, + 0x0496] %asi, %r3
	.word 0xec442f58  ! 1: LDSW_I	ldsw	[%r16 + 0x0f58], %r22
	.word 0xc6d42920  ! 1: LDSHA_I	ldsha	[%r16, + 0x0920] %asi, %r3
	.word 0xc6542564  ! 1: LDSH_I	ldsh	[%r16 + 0x0564], %r3
	.word 0xc68429d4  ! 1: LDUWA_I	lduwa	[%r16, + 0x09d4] %asi, %r3
	.word 0xe20c2451  ! 1: LDUB_I	ldub	[%r16 + 0x0451], %r17
	brnz %r31,thr3_loop_cnt_319
	dec %r31
	.word 0xb92c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r28
        mov 0x6f, %r31
thr3_loop_cnt_320:
	.word 0xf6dc2d70  ! 1: LDXA_I	ldxa	[%r16, + 0x0d70] %asi, %r27
	.word 0xe88c267c  ! 1: LDUBA_I	lduba	[%r16, + 0x067c] %asi, %r20
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc64423a8  ! 1: LDSW_I	ldsw	[%r16 + 0x03a8], %r3
	.word 0xe4c423d4  ! 1: LDSWA_I	ldswa	[%r16, + 0x03d4] %asi, %r18
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_320
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0xa4, %r31
thr3_loop_cnt_321:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2273  ! 1: LDSBA_I	ldsba	[%r16, + 0x0273] %asi, %r3
	.word 0xc69428a8  ! 1: LDUHA_I	lduha	[%r16, + 0x08a8] %asi, %r3
	.word 0xf29421de  ! 1: LDUHA_I	lduha	[%r16, + 0x01de] %asi, %r25
	.word 0xc60c2189  ! 1: LDUB_I	ldub	[%r16 + 0x0189], %r3
	.word 0xea0c2cbe  ! 1: LDUB_I	ldub	[%r16 + 0x0cbe], %r21
	.word 0xecc4231c  ! 1: LDSWA_I	ldswa	[%r16, + 0x031c] %asi, %r22
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_321
	dec %r31
        mov 0x31, %r31
thr3_loop_cnt_322:
	.word 0xe45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r18
	.word 0xc68c2283  ! 1: LDUBA_I	lduba	[%r16, + 0x0283] %asi, %r3
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xdacc2c3d  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c3d] %asi, %r13
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6442550  ! 1: LDSW_I	ldsw	[%r16 + 0x0550], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_322
	dec %r31
	.word 0x98342455  ! 1: ORN_I	orn 	%r16, 0x0455, %r12
	.word 0xaf3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r23
        mov 0x4d, %r31
thr3_loop_cnt_323:
	.word 0xc6d4271e  ! 1: LDSHA_I	ldsha	[%r16, + 0x071e] %asi, %r3
	.word 0xc6042220  ! 1: LDUW_I	lduw	[%r16 + 0x0220], %r3
	.word 0xec4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r22
	.word 0xee0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r23
	.word 0xc6442934  ! 1: LDSW_I	ldsw	[%r16 + 0x0934], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xc6d42f86  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f86] %asi, %r3
	.word 0xd05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r8
	brnz %r31,thr3_loop_cnt_323
	dec %r31
	.word 0x86242822  ! 1: SUB_I	sub 	%r16, 0x0822, %r3
	.word 0x9e0c0002  ! 1: AND_R	and 	%r16, %r2, %r15
	.word 0x861c2957  ! 1: XOR_I	xor 	%r16, 0x0957, %r3
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x93, %r31
thr3_loop_cnt_324:
	.word 0xdcc42060  ! 1: LDSWA_I	ldswa	[%r16, + 0x0060] %asi, %r14
	.word 0xc6c42e14  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e14] %asi, %r3
	.word 0xe2142a72  ! 1: LDUH_I	lduh	[%r16 + 0x0a72], %r17
	.word 0xc6cc28e9  ! 1: LDSBA_I	ldsba	[%r16, + 0x08e9] %asi, %r3
	.word 0xc6dc28f0  ! 1: LDXA_I	ldxa	[%r16, + 0x08f0] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xe4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r18
	.word 0xd0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r8
	.word 0xda9422da  ! 1: LDUHA_I	lduha	[%r16, + 0x02da] %asi, %r13
	.word 0xdc0421e8  ! 1: LDUW_I	lduw	[%r16 + 0x01e8], %r14
	brnz %r31,thr3_loop_cnt_324
	dec %r31
	.word 0xab3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r21
	.word 0x9e340002  ! 1: SUBC_R	orn 	%r16, %r2, %r15
        mov 0x35, %r31
thr3_loop_cnt_325:
	.word 0xe4c421d0  ! 1: LDSWA_I	ldswa	[%r16, + 0x01d0] %asi, %r18
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xce440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r7
	.word 0xe6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r19
	.word 0xe6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r19
	.word 0xf25429fe  ! 1: LDSH_I	ldsh	[%r16 + 0x09fe], %r25
	.word 0xee842aac  ! 1: LDUWA_I	lduwa	[%r16, + 0x0aac] %asi, %r23
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	.word 0xc64426ec  ! 1: LDSW_I	ldsw	[%r16 + 0x06ec], %r3
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xc68427e0  ! 1: LDUWA_I	lduwa	[%r16, + 0x07e0] %asi, %r3
	brnz %r31,thr3_loop_cnt_325
	dec %r31
        mov 0xb5, %r31
thr3_loop_cnt_326:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r25
	.word 0xf8dc22d8  ! 1: LDXA_I	ldxa	[%r16, + 0x02d8] %asi, %r28
	.word 0xd4dc2b18  ! 1: LDXA_I	ldxa	[%r16, + 0x0b18] %asi, %r10
	.word 0xc68425a0  ! 1: LDUWA_I	lduwa	[%r16, + 0x05a0] %asi, %r3
	.word 0xe2542a5c  ! 1: LDSH_I	ldsh	[%r16 + 0x0a5c], %r17
	.word 0xc6142a8c  ! 1: LDUH_I	lduh	[%r16 + 0x0a8c], %r3
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	brnz %r31,thr3_loop_cnt_326
	dec %r31
        mov 0x5f, %r31
thr3_loop_cnt_327:
	.word 0xee0426b4  ! 1: LDUW_I	lduw	[%r16 + 0x06b4], %r23
	.word 0xc6dc22f0  ! 1: LDXA_I	ldxa	[%r16, + 0x02f0] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xeacc2baf  ! 1: LDSBA_I	ldsba	[%r16, + 0x0baf] %asi, %r21
	.word 0xc60c2704  ! 1: LDUB_I	ldub	[%r16 + 0x0704], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc68c2071  ! 1: LDUBA_I	lduba	[%r16, + 0x0071] %asi, %r3
	brnz %r31,thr3_loop_cnt_327
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x86442a25  ! 1: ADDC_I	addc 	%r16, 0x0a25, %r3
	.word 0xb62c2348  ! 1: ANDN_I	andn 	%r16, 0x0348, %r27
        mov 0x6, %r31
thr3_loop_cnt_328:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xce142414  ! 1: LDUH_I	lduh	[%r16 + 0x0414], %r7
	.word 0xe414265c  ! 1: LDUH_I	lduh	[%r16 + 0x065c], %r18
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xce84240c  ! 1: LDUWA_I	lduwa	[%r16, + 0x040c] %asi, %r7
	.word 0xc6c42818  ! 1: LDSWA_I	ldswa	[%r16, + 0x0818] %asi, %r3
	brnz %r31,thr3_loop_cnt_328
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x1a, %r31
thr3_loop_cnt_329:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe4142904  ! 1: LDUH_I	lduh	[%r16 + 0x0904], %r18
	.word 0xe8842a08  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a08] %asi, %r20
	.word 0xc6cc28c3  ! 1: LDSBA_I	ldsba	[%r16, + 0x08c3] %asi, %r3
	.word 0xeed42850  ! 1: LDSHA_I	ldsha	[%r16, + 0x0850] %asi, %r23
	.word 0xd654296e  ! 1: LDSH_I	ldsh	[%r16 + 0x096e], %r11
	.word 0xd8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r12
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_329
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x65, %r31
thr3_loop_cnt_330:
	.word 0xcc542032  ! 1: LDSH_I	ldsh	[%r16 + 0x0032], %r6
	.word 0xc6c42fb8  ! 1: LDSWA_I	ldswa	[%r16, + 0x0fb8] %asi, %r3
	.word 0xe2dc2840  ! 1: LDXA_I	ldxa	[%r16, + 0x0840] %asi, %r17
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r26
	.word 0xfc942310  ! 1: LDUHA_I	lduha	[%r16, + 0x0310] %asi, %r30
	.word 0xd0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r8
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xde942390  ! 1: LDUHA_I	lduha	[%r16, + 0x0390] %asi, %r15
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_330
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0xc1, %r31
thr3_loop_cnt_331:
	.word 0xc60c24ac  ! 1: LDUB_I	ldub	[%r16 + 0x04ac], %r3
	.word 0xdac4281c  ! 1: LDSWA_I	ldswa	[%r16, + 0x081c] %asi, %r13
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2d96  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d96] %asi, %r3
	.word 0xc6942c7a  ! 1: LDUHA_I	lduha	[%r16, + 0x0c7a] %asi, %r3
	.word 0xccc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r6
	.word 0xf40c24a0  ! 1: LDUB_I	ldub	[%r16 + 0x04a0], %r26
	.word 0xda5c2d90  ! 1: LDX_I	ldx	[%r16 + 0x0d90], %r13
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xee140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r23
	.word 0xd85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r12
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_331
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x99343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r12
        mov 0x56, %r31
thr3_loop_cnt_332:
	.word 0xda0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r13
	.word 0xdc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r14
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xecdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r22
	.word 0xec842e88  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e88] %asi, %r22
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	.word 0xd284297c  ! 1: LDUWA_I	lduwa	[%r16, + 0x097c] %asi, %r9
	brnz %r31,thr3_loop_cnt_332
	dec %r31
	.word 0xb824294b  ! 1: SUB_I	sub 	%r16, 0x094b, %r28
	.word 0xb02c296f  ! 1: ANDN_I	andn 	%r16, 0x096f, %r24
	.word 0x8f341002  ! 1: SRLX_R	srlx	%r16, %r2, %r7
	.word 0xb80c0002  ! 1: AND_R	and 	%r16, %r2, %r28
        mov 0x92, %r31
thr3_loop_cnt_333:
	.word 0xf85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r28
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6142dcc  ! 1: LDUH_I	lduh	[%r16 + 0x0dcc], %r3
	.word 0xdac42568  ! 1: LDSWA_I	ldswa	[%r16, + 0x0568] %asi, %r13
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xde440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r15
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xc65c22a0  ! 1: LDX_I	ldx	[%r16 + 0x02a0], %r3
	.word 0xcc042b24  ! 1: LDUW_I	lduw	[%r16 + 0x0b24], %r6
	brnz %r31,thr3_loop_cnt_333
	dec %r31
	.word 0x952c0002  ! 1: SLL_R	sll 	%r16, %r2, %r10
        mov 0x6b, %r31
thr3_loop_cnt_334:
	.word 0xf2d42dee  ! 1: LDSHA_I	ldsha	[%r16, + 0x0dee] %asi, %r25
	.word 0xd2142394  ! 1: LDUH_I	lduh	[%r16 + 0x0394], %r9
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc644228c  ! 1: LDSW_I	ldsw	[%r16 + 0x028c], %r3
	.word 0xf8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r28
	.word 0xfa040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r29
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r10
	brnz %r31,thr3_loop_cnt_334
	dec %r31
	.word 0x98240002  ! 1: SUB_R	sub 	%r16, %r2, %r12
        mov 0x72, %r31
thr3_loop_cnt_335:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc60c2dbd  ! 1: LDUB_I	ldub	[%r16 + 0x0dbd], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6cc2b54  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b54] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc65c22d0  ! 1: LDX_I	ldx	[%r16 + 0x02d0], %r3
	.word 0xc654248c  ! 1: LDSH_I	ldsh	[%r16 + 0x048c], %r3
	brnz %r31,thr3_loop_cnt_335
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0xb5, %r31
thr3_loop_cnt_336:
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xd2d425ec  ! 1: LDSHA_I	ldsha	[%r16, + 0x05ec] %asi, %r9
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6842be4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0be4] %asi, %r3
	.word 0xc65c25a0  ! 1: LDX_I	ldx	[%r16 + 0x05a0], %r3
	.word 0xda1426c8  ! 1: LDUH_I	lduh	[%r16 + 0x06c8], %r13
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc68c2a70  ! 1: LDUBA_I	lduba	[%r16, + 0x0a70] %asi, %r3
	.word 0xdcdc2210  ! 1: LDXA_I	ldxa	[%r16, + 0x0210] %asi, %r14
	.word 0xf84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r28
	brnz %r31,thr3_loop_cnt_336
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0xbf, %r31
thr3_loop_cnt_337:
	.word 0xfcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r30
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xce4c2334  ! 1: LDSB_I	ldsb	[%r16 + 0x0334], %r7
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xea0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r21
	.word 0xee5c2f88  ! 1: LDX_I	ldx	[%r16 + 0x0f88], %r23
	.word 0xc60c23f1  ! 1: LDUB_I	ldub	[%r16 + 0x03f1], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_337
	dec %r31
	.word 0x8d341002  ! 1: SRLX_R	srlx	%r16, %r2, %r6
        mov 0x2b, %r31
thr3_loop_cnt_338:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6142298  ! 1: LDUH_I	lduh	[%r16 + 0x0298], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r19
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf8dc2be0  ! 1: LDXA_I	ldxa	[%r16, + 0x0be0] %asi, %r28
	.word 0xc6dc26e8  ! 1: LDXA_I	ldxa	[%r16, + 0x06e8] %asi, %r3
	.word 0xc60c27a2  ! 1: LDUB_I	ldub	[%r16 + 0x07a2], %r3
	.word 0xc6c4283c  ! 1: LDSWA_I	ldswa	[%r16, + 0x083c] %asi, %r3
	.word 0xc6cc2689  ! 1: LDSBA_I	ldsba	[%r16, + 0x0689] %asi, %r3
	.word 0xfa941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r29
	.word 0xc6cc279a  ! 1: LDSBA_I	ldsba	[%r16, + 0x079a] %asi, %r3
	brnz %r31,thr3_loop_cnt_338
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0x5f, %r31
thr3_loop_cnt_339:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd44c2fca  ! 1: LDSB_I	ldsb	[%r16 + 0x0fca], %r10
	.word 0xf2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r25
	.word 0xce5c2840  ! 1: LDX_I	ldx	[%r16 + 0x0840], %r7
	.word 0xe8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r20
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xce042b78  ! 1: LDUW_I	lduw	[%r16 + 0x0b78], %r7
	brnz %r31,thr3_loop_cnt_339
	dec %r31
	.word 0xac2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r22
        mov 0x3d, %r31
thr3_loop_cnt_340:
	.word 0xc65c2460  ! 1: LDX_I	ldx	[%r16 + 0x0460], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xce142516  ! 1: LDUH_I	lduh	[%r16 + 0x0516], %r7
	.word 0xf28c2dad  ! 1: LDUBA_I	lduba	[%r16, + 0x0dad] %asi, %r25
	.word 0xc6842bf0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0bf0] %asi, %r3
	.word 0xf48425c0  ! 1: LDUWA_I	lduwa	[%r16, + 0x05c0] %asi, %r26
	brnz %r31,thr3_loop_cnt_340
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0xb63c2463  ! 1: XNOR_I	xnor 	%r16, 0x0463, %r27
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
        mov 0x90, %r31
thr3_loop_cnt_341:
	.word 0xdadc2500  ! 1: LDXA_I	ldxa	[%r16, + 0x0500] %asi, %r13
	.word 0xc65c22a0  ! 1: LDX_I	ldx	[%r16 + 0x02a0], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf00c2179  ! 1: LDUB_I	ldub	[%r16 + 0x0179], %r24
	.word 0xda5c2e28  ! 1: LDX_I	ldx	[%r16 + 0x0e28], %r13
	.word 0xc65c2298  ! 1: LDX_I	ldx	[%r16 + 0x0298], %r3
	.word 0xda4c2a6e  ! 1: LDSB_I	ldsb	[%r16 + 0x0a6e], %r13
	.word 0xf0442d34  ! 1: LDSW_I	ldsw	[%r16 + 0x0d34], %r24
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_341
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x96342b91  ! 1: SUBC_I	orn 	%r16, 0x0b91, %r11
	.word 0xab341002  ! 1: SRLX_R	srlx	%r16, %r2, %r21
        mov 0x62, %r31
thr3_loop_cnt_342:
	.word 0xf88c2206  ! 1: LDUBA_I	lduba	[%r16, + 0x0206] %asi, %r28
	.word 0xf25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r25
	.word 0xeecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r23
	.word 0xde040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r15
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf444224c  ! 1: LDSW_I	ldsw	[%r16 + 0x024c], %r26
	.word 0xc6cc20a8  ! 1: LDSBA_I	ldsba	[%r16, + 0x00a8] %asi, %r3
	.word 0xd8142b2c  ! 1: LDUH_I	lduh	[%r16 + 0x0b2c], %r12
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_342
	dec %r31
	.word 0xab3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r21
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x97343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r11
        mov 0x7a, %r31
thr3_loop_cnt_343:
	.word 0xc6542d76  ! 1: LDSH_I	ldsh	[%r16 + 0x0d76], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6942776  ! 1: LDUHA_I	lduha	[%r16, + 0x0776] %asi, %r3
	.word 0xd2cc28c7  ! 1: LDSBA_I	ldsba	[%r16, + 0x08c7] %asi, %r9
	.word 0xde842630  ! 1: LDUWA_I	lduwa	[%r16, + 0x0630] %asi, %r15
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xce8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r7
	.word 0xfc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r30
	.word 0xc60422d0  ! 1: LDUW_I	lduw	[%r16 + 0x02d0], %r3
	.word 0xf2842b4c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b4c] %asi, %r25
	.word 0xf204263c  ! 1: LDUW_I	lduw	[%r16 + 0x063c], %r25
	.word 0xea142d1e  ! 1: LDUH_I	lduh	[%r16 + 0x0d1e], %r21
	brnz %r31,thr3_loop_cnt_343
	dec %r31
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x863c24be  ! 1: XNOR_I	xnor 	%r16, 0x04be, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0xa4040002  ! 1: ADD_R	add 	%r16, %r2, %r18
        mov 0xb6, %r31
thr3_loop_cnt_344:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc60425ac  ! 1: LDUW_I	lduw	[%r16 + 0x05ac], %r3
	.word 0xe2dc20e0  ! 1: LDXA_I	ldxa	[%r16, + 0x00e0] %asi, %r17
	.word 0xc6d4246e  ! 1: LDSHA_I	ldsha	[%r16, + 0x046e] %asi, %r3
	.word 0xc68c2c8e  ! 1: LDUBA_I	lduba	[%r16, + 0x0c8e] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd6cc25d1  ! 1: LDSBA_I	ldsba	[%r16, + 0x05d1] %asi, %r11
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd4042970  ! 1: LDUW_I	lduw	[%r16 + 0x0970], %r10
	.word 0xe24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r17
	brnz %r31,thr3_loop_cnt_344
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0xb5342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r26
	.word 0x972c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r11
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x5, %r31
thr3_loop_cnt_345:
	.word 0xe6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r19
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf09427e8  ! 1: LDUHA_I	lduha	[%r16, + 0x07e8] %asi, %r24
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc65c26a8  ! 1: LDX_I	ldx	[%r16 + 0x06a8], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc68c219d  ! 1: LDUBA_I	lduba	[%r16, + 0x019d] %asi, %r3
	.word 0xc68c20af  ! 1: LDUBA_I	lduba	[%r16, + 0x00af] %asi, %r3
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xd8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r12
	.word 0xf89426bc  ! 1: LDUHA_I	lduha	[%r16, + 0x06bc] %asi, %r28
	brnz %r31,thr3_loop_cnt_345
	dec %r31
	.word 0xbc242bc1  ! 1: SUB_I	sub 	%r16, 0x0bc1, %r30
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
        mov 0xb7, %r31
thr3_loop_cnt_346:
	.word 0xee040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r23
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xdc4c29ad  ! 1: LDSB_I	ldsb	[%r16 + 0x09ad], %r14
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	.word 0xc6d42ffc  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ffc] %asi, %r3
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xd45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r10
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_346
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x94240002  ! 1: SUB_R	sub 	%r16, %r2, %r10
        mov 0x79, %r31
thr3_loop_cnt_347:
	.word 0xc6dc22e0  ! 1: LDXA_I	ldxa	[%r16, + 0x02e0] %asi, %r3
	.word 0xcc0c2e02  ! 1: LDUB_I	ldub	[%r16 + 0x0e02], %r6
	.word 0xdc5c2d00  ! 1: LDX_I	ldx	[%r16 + 0x0d00], %r14
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r28
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc68c2416  ! 1: LDUBA_I	lduba	[%r16, + 0x0416] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_347
	dec %r31
	.word 0x8604214c  ! 1: ADD_I	add 	%r16, 0x014c, %r3
	.word 0x903c2a8b  ! 1: XNOR_I	xnor 	%r16, 0x0a8b, %r8
	.word 0xb13c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r24
	.word 0xa3340002  ! 1: SRL_R	srl 	%r16, %r2, %r17
        mov 0x2f, %r31
thr3_loop_cnt_348:
	.word 0xf4442384  ! 1: LDSW_I	ldsw	[%r16 + 0x0384], %r26
	.word 0xde941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r15
	.word 0xf2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r25
	.word 0xf6dc2c00  ! 1: LDXA_I	ldxa	[%r16, + 0x0c00] %asi, %r27
	.word 0xf25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r25
	.word 0xc6842260  ! 1: LDUWA_I	lduwa	[%r16, + 0x0260] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_348
	dec %r31
	.word 0x8e340002  ! 1: SUBC_R	orn 	%r16, %r2, %r7
        mov 0x47, %r31
thr3_loop_cnt_349:
	.word 0xfa942d8a  ! 1: LDUHA_I	lduha	[%r16, + 0x0d8a] %asi, %r29
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xfa8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r29
	.word 0xc6842878  ! 1: LDUWA_I	lduwa	[%r16, + 0x0878] %asi, %r3
	.word 0xdc0c2011  ! 1: LDUB_I	ldub	[%r16 + 0x0011], %r14
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xda4c24c3  ! 1: LDSB_I	ldsb	[%r16 + 0x04c3], %r13
	.word 0xdc4c2945  ! 1: LDSB_I	ldsb	[%r16 + 0x0945], %r14
	brnz %r31,thr3_loop_cnt_349
	dec %r31
	.word 0x860c2e83  ! 1: AND_I	and 	%r16, 0x0e83, %r3
	.word 0x943429d2  ! 1: ORN_I	orn 	%r16, 0x09d2, %r10
        mov 0x91, %r31
thr3_loop_cnt_350:
	.word 0xc614284a  ! 1: LDUH_I	lduh	[%r16 + 0x084a], %r3
	.word 0xc64c2e3c  ! 1: LDSB_I	ldsb	[%r16 + 0x0e3c], %r3
	.word 0xfa4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r29
	.word 0xc65c2100  ! 1: LDX_I	ldx	[%r16 + 0x0100], %r3
	.word 0xe8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r20
	.word 0xec0c2a67  ! 1: LDUB_I	ldub	[%r16 + 0x0a67], %r22
	.word 0xda941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r13
	.word 0xf80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r28
	.word 0xf4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r26
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_350
	dec %r31
	.word 0xbc140002  ! 1: OR_R	or 	%r16, %r2, %r30
	.word 0x86342e48  ! 1: SUBC_I	orn 	%r16, 0x0e48, %r3
        mov 0x60, %r31
thr3_loop_cnt_351:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	.word 0xccc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r6
	.word 0xc6d42dfa  ! 1: LDSHA_I	ldsha	[%r16, + 0x0dfa] %asi, %r3
	.word 0xc6942c44  ! 1: LDUHA_I	lduha	[%r16, + 0x0c44] %asi, %r3
	.word 0xd04c22f3  ! 1: LDSB_I	ldsb	[%r16 + 0x02f3], %r8
	.word 0xee442724  ! 1: LDSW_I	ldsw	[%r16 + 0x0724], %r23
	.word 0xc64c2551  ! 1: LDSB_I	ldsb	[%r16 + 0x0551], %r3
	.word 0xc6cc279b  ! 1: LDSBA_I	ldsba	[%r16, + 0x079b] %asi, %r3
	.word 0xf24c2fd7  ! 1: LDSB_I	ldsb	[%r16 + 0x0fd7], %r25
	.word 0xce4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r7
	.word 0xc65c2c88  ! 1: LDX_I	ldx	[%r16 + 0x0c88], %r3
	brnz %r31,thr3_loop_cnt_351
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0xb32c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r25
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x94440002  ! 1: ADDC_R	addc 	%r16, %r2, %r10
        mov 0xb6, %r31
thr3_loop_cnt_352:
	.word 0xf0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r24
	.word 0xe4dc2f48  ! 1: LDXA_I	ldxa	[%r16, + 0x0f48] %asi, %r18
	.word 0xec442048  ! 1: LDSW_I	ldsw	[%r16 + 0x0048], %r22
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	.word 0xc6c422b4  ! 1: LDSWA_I	ldswa	[%r16, + 0x02b4] %asi, %r3
	.word 0xe8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r20
	.word 0xc6dc22d8  ! 1: LDXA_I	ldxa	[%r16, + 0x02d8] %asi, %r3
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	brnz %r31,thr3_loop_cnt_352
	dec %r31
        mov 0x6e, %r31
thr3_loop_cnt_353:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc65420de  ! 1: LDSH_I	ldsh	[%r16 + 0x00de], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xccc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r6
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_353
	dec %r31
        mov 0x8c, %r31
thr3_loop_cnt_354:
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6842dd8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0dd8] %asi, %r3
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xc6042a50  ! 1: LDUW_I	lduw	[%r16 + 0x0a50], %r3
	.word 0xe2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r17
	.word 0xf8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r28
	.word 0xc6d42e30  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e30] %asi, %r3
	.word 0xe68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r19
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf68c2af3  ! 1: LDUBA_I	lduba	[%r16, + 0x0af3] %asi, %r27
	brnz %r31,thr3_loop_cnt_354
	dec %r31
	.word 0x8604238e  ! 1: ADD_I	add 	%r16, 0x038e, %r3
	.word 0xac3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r22
	.word 0x9404217b  ! 1: ADD_I	add 	%r16, 0x017b, %r10
        mov 0x3, %r31
thr3_loop_cnt_355:
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xdc942c60  ! 1: LDUHA_I	lduha	[%r16, + 0x0c60] %asi, %r14
	.word 0xf8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r28
	.word 0xccc4202c  ! 1: LDSWA_I	ldswa	[%r16, + 0x002c] %asi, %r6
	.word 0xc654226a  ! 1: LDSH_I	ldsh	[%r16 + 0x026a], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc64c2f33  ! 1: LDSB_I	ldsb	[%r16 + 0x0f33], %r3
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xccc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r6
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_355
	dec %r31
        mov 0x1a, %r31
thr3_loop_cnt_356:
	.word 0xeacc265e  ! 1: LDSBA_I	ldsba	[%r16, + 0x065e] %asi, %r21
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	.word 0xe8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r20
	.word 0xe6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r19
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xda8c2d44  ! 1: LDUBA_I	lduba	[%r16, + 0x0d44] %asi, %r13
	.word 0xf08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r24
	.word 0xc61425ec  ! 1: LDUH_I	lduh	[%r16 + 0x05ec], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd4c42a20  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a20] %asi, %r10
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	brnz %r31,thr3_loop_cnt_356
	dec %r31
	.word 0xa8240002  ! 1: SUB_R	sub 	%r16, %r2, %r20
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x63, %r31
thr3_loop_cnt_357:
	.word 0xdcc42ef0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ef0] %asi, %r14
	.word 0xc68c29fc  ! 1: LDUBA_I	lduba	[%r16, + 0x09fc] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc68428a0  ! 1: LDUWA_I	lduwa	[%r16, + 0x08a0] %asi, %r3
	.word 0xdcc4266c  ! 1: LDSWA_I	ldswa	[%r16, + 0x066c] %asi, %r14
	.word 0xc65c25b0  ! 1: LDX_I	ldx	[%r16 + 0x05b0], %r3
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	brnz %r31,thr3_loop_cnt_357
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0xac3c29b6  ! 1: XNOR_I	xnor 	%r16, 0x09b6, %r22
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0x6, %r31
thr3_loop_cnt_358:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r19
	.word 0xf69425d6  ! 1: LDUHA_I	lduha	[%r16, + 0x05d6] %asi, %r27
	.word 0xc61425dc  ! 1: LDUH_I	lduh	[%r16 + 0x05dc], %r3
	.word 0xd2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r9
	.word 0xd4542b4c  ! 1: LDSH_I	ldsh	[%r16 + 0x0b4c], %r10
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc64c2b78  ! 1: LDSB_I	ldsb	[%r16 + 0x0b78], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_358
	dec %r31
        mov 0x6a, %r31
thr3_loop_cnt_359:
	.word 0xf6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r27
	.word 0xfcdc2660  ! 1: LDXA_I	ldxa	[%r16, + 0x0660] %asi, %r30
	.word 0xd2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r9
	.word 0xd2d42b18  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b18] %asi, %r9
	.word 0xcecc22ed  ! 1: LDSBA_I	ldsba	[%r16, + 0x02ed] %asi, %r7
	.word 0xc6d42a64  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a64] %asi, %r3
	.word 0xce040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r7
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_359
	dec %r31
	.word 0xbb2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r29
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x862421cb  ! 1: SUB_I	sub 	%r16, 0x01cb, %r3
	.word 0x9e342fff  ! 1: SUBC_I	orn 	%r16, 0x0fff, %r15
        mov 0xb, %r31
thr3_loop_cnt_360:
	.word 0xf8c42b18  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b18] %asi, %r28
	.word 0xc654280a  ! 1: LDSH_I	ldsh	[%r16 + 0x080a], %r3
	.word 0xc6cc221b  ! 1: LDSBA_I	ldsba	[%r16, + 0x021b] %asi, %r3
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xd8842c24  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c24] %asi, %r12
	.word 0xd6042738  ! 1: LDUW_I	lduw	[%r16 + 0x0738], %r11
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe68428e8  ! 1: LDUWA_I	lduwa	[%r16, + 0x08e8] %asi, %r19
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xc6c42870  ! 1: LDSWA_I	ldswa	[%r16, + 0x0870] %asi, %r3
	.word 0xd05c2b50  ! 1: LDX_I	ldx	[%r16 + 0x0b50], %r8
	brnz %r31,thr3_loop_cnt_360
	dec %r31
	.word 0x9a3429b9  ! 1: SUBC_I	orn 	%r16, 0x09b9, %r13
	.word 0x90240002  ! 1: SUB_R	sub 	%r16, %r2, %r8
	.word 0xb4240002  ! 1: SUB_R	sub 	%r16, %r2, %r26
        mov 0x3a, %r31
thr3_loop_cnt_361:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6c42c70  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c70] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc64c246b  ! 1: LDSB_I	ldsb	[%r16 + 0x046b], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xcc84220c  ! 1: LDUWA_I	lduwa	[%r16, + 0x020c] %asi, %r6
	.word 0xe2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r17
	brnz %r31,thr3_loop_cnt_361
	dec %r31
	.word 0x99340002  ! 1: SRL_R	srl 	%r16, %r2, %r12
        mov 0x66, %r31
thr3_loop_cnt_362:
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	.word 0xfc0c2265  ! 1: LDUB_I	ldub	[%r16 + 0x0265], %r30
	.word 0xf4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r26
	.word 0xd08c2a2e  ! 1: LDUBA_I	lduba	[%r16, + 0x0a2e] %asi, %r8
	.word 0xc65c2a98  ! 1: LDX_I	ldx	[%r16 + 0x0a98], %r3
	.word 0xda842ff4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ff4] %asi, %r13
	.word 0xf4042c54  ! 1: LDUW_I	lduw	[%r16 + 0x0c54], %r26
	.word 0xc64c27af  ! 1: LDSB_I	ldsb	[%r16 + 0x07af], %r3
	.word 0xc6442474  ! 1: LDSW_I	ldsw	[%r16 + 0x0474], %r3
	.word 0xe8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r20
	.word 0xdc0c22b8  ! 1: LDUB_I	ldub	[%r16 + 0x02b8], %r14
	brnz %r31,thr3_loop_cnt_362
	dec %r31
	.word 0xa3343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r17
        mov 0x18, %r31
thr3_loop_cnt_363:
	.word 0xf48c28e0  ! 1: LDUBA_I	lduba	[%r16, + 0x08e0] %asi, %r26
	.word 0xda8c29eb  ! 1: LDUBA_I	lduba	[%r16, + 0x09eb] %asi, %r13
	.word 0xd28c2896  ! 1: LDUBA_I	lduba	[%r16, + 0x0896] %asi, %r9
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe4cc24a3  ! 1: LDSBA_I	ldsba	[%r16, + 0x04a3] %asi, %r18
	.word 0xc604294c  ! 1: LDUW_I	lduw	[%r16 + 0x094c], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_363
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x9b2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r13
        mov 0xbf, %r31
thr3_loop_cnt_364:
	.word 0xd25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r9
	.word 0xd48c2a3f  ! 1: LDUBA_I	lduba	[%r16, + 0x0a3f] %asi, %r10
	.word 0xc6042a50  ! 1: LDUW_I	lduw	[%r16 + 0x0a50], %r3
	.word 0xd69424a8  ! 1: LDUHA_I	lduha	[%r16, + 0x04a8] %asi, %r11
	.word 0xc65c27e0  ! 1: LDX_I	ldx	[%r16 + 0x07e0], %r3
	.word 0xda8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r13
	.word 0xea042758  ! 1: LDUW_I	lduw	[%r16 + 0x0758], %r21
	.word 0xde941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r15
	.word 0xd84c2c79  ! 1: LDSB_I	ldsb	[%r16 + 0x0c79], %r12
	.word 0xcc8429a8  ! 1: LDUWA_I	lduwa	[%r16, + 0x09a8] %asi, %r6
	.word 0xdc0c2e25  ! 1: LDUB_I	ldub	[%r16 + 0x0e25], %r14
	brnz %r31,thr3_loop_cnt_364
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x9e340002  ! 1: ORN_R	orn 	%r16, %r2, %r15
        mov 0x5e, %r31
thr3_loop_cnt_365:
	.word 0xeacc2849  ! 1: LDSBA_I	ldsba	[%r16, + 0x0849] %asi, %r21
	.word 0xcccc2b1e  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b1e] %asi, %r6
	.word 0xe494204a  ! 1: LDUHA_I	lduha	[%r16, + 0x004a] %asi, %r18
	.word 0xc6dc2890  ! 1: LDXA_I	ldxa	[%r16, + 0x0890] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6842d0c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d0c] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xda0420a0  ! 1: LDUW_I	lduw	[%r16 + 0x00a0], %r13
	.word 0xc68c2f98  ! 1: LDUBA_I	lduba	[%r16, + 0x0f98] %asi, %r3
	.word 0xcc142976  ! 1: LDUH_I	lduh	[%r16 + 0x0976], %r6
	.word 0xf4dc2d80  ! 1: LDXA_I	ldxa	[%r16, + 0x0d80] %asi, %r26
	brnz %r31,thr3_loop_cnt_365
	dec %r31
	.word 0xaa0c0002  ! 1: AND_R	and 	%r16, %r2, %r21
	.word 0xb4340002  ! 1: SUBC_R	orn 	%r16, %r2, %r26
        mov 0x10, %r31
thr3_loop_cnt_366:
	.word 0xe6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r19
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf09425ba  ! 1: LDUHA_I	lduha	[%r16, + 0x05ba] %asi, %r24
	.word 0xd2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r9
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc68429d4  ! 1: LDUWA_I	lduwa	[%r16, + 0x09d4] %asi, %r3
	.word 0xc68c2f1a  ! 1: LDUBA_I	lduba	[%r16, + 0x0f1a] %asi, %r3
	.word 0xe84c2e29  ! 1: LDSB_I	ldsb	[%r16 + 0x0e29], %r20
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r17
	brnz %r31,thr3_loop_cnt_366
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x2d, %r31
thr3_loop_cnt_367:
	.word 0xec0c2c08  ! 1: LDUB_I	ldub	[%r16 + 0x0c08], %r22
	.word 0xf48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r26
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xc68c21ad  ! 1: LDUBA_I	lduba	[%r16, + 0x01ad] %asi, %r3
	.word 0xee0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r23
	.word 0xc6942aec  ! 1: LDUHA_I	lduha	[%r16, + 0x0aec] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2ae7  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ae7] %asi, %r3
	.word 0xda4c22e6  ! 1: LDSB_I	ldsb	[%r16 + 0x02e6], %r13
	.word 0xec4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r22
	.word 0xda442f00  ! 1: LDSW_I	ldsw	[%r16 + 0x0f00], %r13
	.word 0xe8d42c38  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c38] %asi, %r20
	brnz %r31,thr3_loop_cnt_367
	dec %r31
        mov 0xac, %r31
thr3_loop_cnt_368:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6d42160  ! 1: LDSHA_I	ldsha	[%r16, + 0x0160] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc20a4  ! 1: LDSBA_I	ldsba	[%r16, + 0x00a4] %asi, %r3
	.word 0xdecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r15
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	.word 0xc644259c  ! 1: LDSW_I	ldsw	[%r16 + 0x059c], %r3
	.word 0xc6c42078  ! 1: LDSWA_I	ldswa	[%r16, + 0x0078] %asi, %r3
	.word 0xfacc26d7  ! 1: LDSBA_I	ldsba	[%r16, + 0x06d7] %asi, %r29
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r8
	brnz %r31,thr3_loop_cnt_368
	dec %r31
	.word 0x8e3c247d  ! 1: XNOR_I	xnor 	%r16, 0x047d, %r7
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x8c, %r31
thr3_loop_cnt_369:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xdacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r13
	.word 0xf65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r27
	.word 0xc69425d2  ! 1: LDUHA_I	lduha	[%r16, + 0x05d2] %asi, %r3
	.word 0xc69422d0  ! 1: LDUHA_I	lduha	[%r16, + 0x02d0] %asi, %r3
	.word 0xc6cc295a  ! 1: LDSBA_I	ldsba	[%r16, + 0x095a] %asi, %r3
	.word 0xc6042474  ! 1: LDUW_I	lduw	[%r16 + 0x0474], %r3
	brnz %r31,thr3_loop_cnt_369
	dec %r31
	.word 0x861c2bd4  ! 1: XOR_I	xor 	%r16, 0x0bd4, %r3
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x8f3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r7
	.word 0x973c0002  ! 1: SRA_R	sra 	%r16, %r2, %r11
        mov 0x51, %r31
thr3_loop_cnt_370:
	.word 0xc69426a2  ! 1: LDUHA_I	lduha	[%r16, + 0x06a2] %asi, %r3
	.word 0xc6142c94  ! 1: LDUH_I	lduh	[%r16 + 0x0c94], %r3
	.word 0xde040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r15
	.word 0xc6442a90  ! 1: LDSW_I	ldsw	[%r16 + 0x0a90], %r3
	.word 0xc68c293a  ! 1: LDUBA_I	lduba	[%r16, + 0x093a] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6442348  ! 1: LDSW_I	ldsw	[%r16 + 0x0348], %r3
	.word 0xec942cb6  ! 1: LDUHA_I	lduha	[%r16, + 0x0cb6] %asi, %r22
	brnz %r31,thr3_loop_cnt_370
	dec %r31
	.word 0xbd2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r30
	.word 0xa6042d50  ! 1: ADD_I	add 	%r16, 0x0d50, %r19
	.word 0xbd341002  ! 1: SRLX_R	srlx	%r16, %r2, %r30
        mov 0xc3, %r31
thr3_loop_cnt_371:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r11
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe85c2500  ! 1: LDX_I	ldx	[%r16 + 0x0500], %r20
	.word 0xd4942c3a  ! 1: LDUHA_I	lduha	[%r16, + 0x0c3a] %asi, %r10
	.word 0xe48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r18
	.word 0xc64c25b4  ! 1: LDSB_I	ldsb	[%r16 + 0x05b4], %r3
	.word 0xd4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r10
	.word 0xc6942876  ! 1: LDUHA_I	lduha	[%r16, + 0x0876] %asi, %r3
	brnz %r31,thr3_loop_cnt_371
	dec %r31
	.word 0x862429b6  ! 1: SUB_I	sub 	%r16, 0x09b6, %r3
	.word 0x861c2441  ! 1: XOR_I	xor 	%r16, 0x0441, %r3
        mov 0x9b, %r31
thr3_loop_cnt_372:
	.word 0xc60429c0  ! 1: LDUW_I	lduw	[%r16 + 0x09c0], %r3
	.word 0xc6142ea0  ! 1: LDUH_I	lduh	[%r16 + 0x0ea0], %r3
	.word 0xc64c2486  ! 1: LDSB_I	ldsb	[%r16 + 0x0486], %r3
	.word 0xec942ade  ! 1: LDUHA_I	lduha	[%r16, + 0x0ade] %asi, %r22
	.word 0xd4c427c4  ! 1: LDSWA_I	ldswa	[%r16, + 0x07c4] %asi, %r10
	.word 0xc6d4247c  ! 1: LDSHA_I	ldsha	[%r16, + 0x047c] %asi, %r3
	.word 0xe6cc2ccd  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ccd] %asi, %r19
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd64c2a9e  ! 1: LDSB_I	ldsb	[%r16 + 0x0a9e], %r11
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xfa0c2d76  ! 1: LDUB_I	ldub	[%r16 + 0x0d76], %r29
	brnz %r31,thr3_loop_cnt_372
	dec %r31
	.word 0x860c2592  ! 1: AND_I	and 	%r16, 0x0592, %r3
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x49, %r31
thr3_loop_cnt_373:
	.word 0xc6942250  ! 1: LDUHA_I	lduha	[%r16, + 0x0250] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r11
	.word 0xe85c2580  ! 1: LDX_I	ldx	[%r16 + 0x0580], %r20
	.word 0xc6dc21f0  ! 1: LDXA_I	ldxa	[%r16, + 0x01f0] %asi, %r3
	.word 0xfa140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r29
	.word 0xc65c2d88  ! 1: LDX_I	ldx	[%r16 + 0x0d88], %r3
	.word 0xf05c2410  ! 1: LDX_I	ldx	[%r16 + 0x0410], %r24
	brnz %r31,thr3_loop_cnt_373
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0xa4, %r31
thr3_loop_cnt_374:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc65c2210  ! 1: LDX_I	ldx	[%r16 + 0x0210], %r3
	.word 0xd8d42282  ! 1: LDSHA_I	ldsha	[%r16, + 0x0282] %asi, %r12
	.word 0xdc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r14
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc65c2130  ! 1: LDX_I	ldx	[%r16 + 0x0130], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xec841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r22
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6cc2d60  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d60] %asi, %r3
	.word 0xccc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r6
	.word 0xc6942138  ! 1: LDUHA_I	lduha	[%r16, + 0x0138] %asi, %r3
	brnz %r31,thr3_loop_cnt_374
	dec %r31
	.word 0xa2140002  ! 1: OR_R	or 	%r16, %r2, %r17
        mov 0x9d, %r31
thr3_loop_cnt_375:
	.word 0xc684277c  ! 1: LDUWA_I	lduwa	[%r16, + 0x077c] %asi, %r3
	.word 0xf2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r25
	.word 0xe65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r19
	.word 0xc65c25f8  ! 1: LDX_I	ldx	[%r16 + 0x05f8], %r3
	.word 0xc60429cc  ! 1: LDUW_I	lduw	[%r16 + 0x09cc], %r3
	.word 0xc60c2266  ! 1: LDUB_I	ldub	[%r16 + 0x0266], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe25c2260  ! 1: LDX_I	ldx	[%r16 + 0x0260], %r17
	.word 0xe8cc2fb6  ! 1: LDSBA_I	ldsba	[%r16, + 0x0fb6] %asi, %r20
	.word 0xd8542718  ! 1: LDSH_I	ldsh	[%r16 + 0x0718], %r12
	.word 0xcecc2ce1  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ce1] %asi, %r7
	.word 0xf2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r25
	brnz %r31,thr3_loop_cnt_375
	dec %r31
	.word 0x9b2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r13
        mov 0x3c, %r31
thr3_loop_cnt_376:
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xc6cc2f75  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f75] %asi, %r3
	.word 0xf4c42c50  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c50] %asi, %r26
	.word 0xc6942270  ! 1: LDUHA_I	lduha	[%r16, + 0x0270] %asi, %r3
	.word 0xda9427de  ! 1: LDUHA_I	lduha	[%r16, + 0x07de] %asi, %r13
	.word 0xc6842e54  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e54] %asi, %r3
	.word 0xc6dc2938  ! 1: LDXA_I	ldxa	[%r16, + 0x0938] %asi, %r3
	.word 0xec54278c  ! 1: LDSH_I	ldsh	[%r16 + 0x078c], %r22
	brnz %r31,thr3_loop_cnt_376
	dec %r31
	.word 0xaf3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r23
	.word 0xba1422f8  ! 1: OR_I	or 	%r16, 0x02f8, %r29
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x861422ac  ! 1: OR_I	or 	%r16, 0x02ac, %r3
        mov 0x4, %r31
thr3_loop_cnt_377:
	.word 0xc65c2680  ! 1: LDX_I	ldx	[%r16 + 0x0680], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6dc2870  ! 1: LDXA_I	ldxa	[%r16, + 0x0870] %asi, %r3
	.word 0xfc542352  ! 1: LDSH_I	ldsh	[%r16 + 0x0352], %r30
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd2dc23b8  ! 1: LDXA_I	ldxa	[%r16, + 0x03b8] %asi, %r9
	.word 0xdc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r14
	.word 0xf48c2c86  ! 1: LDUBA_I	lduba	[%r16, + 0x0c86] %asi, %r26
	.word 0xdc942734  ! 1: LDUHA_I	lduha	[%r16, + 0x0734] %asi, %r14
	.word 0xe8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r20
	.word 0xc65c24e8  ! 1: LDX_I	ldx	[%r16 + 0x04e8], %r3
	.word 0xee941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r23
	brnz %r31,thr3_loop_cnt_377
	dec %r31
        mov 0x2b, %r31
thr3_loop_cnt_378:
	.word 0xd60c2424  ! 1: LDUB_I	ldub	[%r16 + 0x0424], %r11
	.word 0xf65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r27
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc61420aa  ! 1: LDUH_I	lduh	[%r16 + 0x00aa], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r20
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc60427e4  ! 1: LDUW_I	lduw	[%r16 + 0x07e4], %r3
	.word 0xd6c429ec  ! 1: LDSWA_I	ldswa	[%r16, + 0x09ec] %asi, %r11
	brnz %r31,thr3_loop_cnt_378
	dec %r31
	.word 0x9c142c65  ! 1: OR_I	or 	%r16, 0x0c65, %r14
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x861c2fbe  ! 1: XOR_I	xor 	%r16, 0x0fbe, %r3
        mov 0x6, %r31
thr3_loop_cnt_379:
	.word 0xc68c23bb  ! 1: LDUBA_I	lduba	[%r16, + 0x03bb] %asi, %r3
	.word 0xee942584  ! 1: LDUHA_I	lduha	[%r16, + 0x0584] %asi, %r23
	.word 0xde9420f2  ! 1: LDUHA_I	lduha	[%r16, + 0x00f2] %asi, %r15
	.word 0xec8c26c3  ! 1: LDUBA_I	lduba	[%r16, + 0x06c3] %asi, %r22
	.word 0xf2cc2e26  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e26] %asi, %r25
	.word 0xc6cc2ca6  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ca6] %asi, %r3
	.word 0xd4042750  ! 1: LDUW_I	lduw	[%r16 + 0x0750], %r10
	.word 0xea841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r21
	.word 0xc65422dc  ! 1: LDSH_I	ldsh	[%r16 + 0x02dc], %r3
	.word 0xc644226c  ! 1: LDSW_I	ldsw	[%r16 + 0x026c], %r3
	.word 0xe80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r20
	brnz %r31,thr3_loop_cnt_379
	dec %r31
	.word 0x9e0c0002  ! 1: AND_R	and 	%r16, %r2, %r15
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
        mov 0x6b, %r31
thr3_loop_cnt_380:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf04c2905  ! 1: LDSB_I	ldsb	[%r16 + 0x0905], %r24
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xccd42dea  ! 1: LDSHA_I	ldsha	[%r16, + 0x0dea] %asi, %r6
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd2c421a0  ! 1: LDSWA_I	ldswa	[%r16, + 0x01a0] %asi, %r9
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc64429e8  ! 1: LDSW_I	ldsw	[%r16 + 0x09e8], %r3
	.word 0xead42af6  ! 1: LDSHA_I	ldsha	[%r16, + 0x0af6] %asi, %r21
	.word 0xc6042aec  ! 1: LDUW_I	lduw	[%r16 + 0x0aec], %r3
	.word 0xded42a68  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a68] %asi, %r15
	brnz %r31,thr3_loop_cnt_380
	dec %r31
        mov 0x7d, %r31
thr3_loop_cnt_381:
	.word 0xce8c2ba7  ! 1: LDUBA_I	lduba	[%r16, + 0x0ba7] %asi, %r7
	.word 0xec140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r22
	.word 0xd44c2587  ! 1: LDSB_I	ldsb	[%r16 + 0x0587], %r10
	.word 0xe6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r19
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	.word 0xd854240c  ! 1: LDSH_I	ldsh	[%r16 + 0x040c], %r12
	.word 0xf48c24cf  ! 1: LDUBA_I	lduba	[%r16, + 0x04cf] %asi, %r26
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6942fd8  ! 1: LDUHA_I	lduha	[%r16, + 0x0fd8] %asi, %r3
	.word 0xd6942622  ! 1: LDUHA_I	lduha	[%r16, + 0x0622] %asi, %r11
	.word 0xc6d425ac  ! 1: LDSHA_I	ldsha	[%r16, + 0x05ac] %asi, %r3
	brnz %r31,thr3_loop_cnt_381
	dec %r31
        mov 0xb8, %r31
thr3_loop_cnt_382:
	.word 0xc60c27e3  ! 1: LDUB_I	ldub	[%r16 + 0x07e3], %r3
	.word 0xc6442008  ! 1: LDSW_I	ldsw	[%r16 + 0x0008], %r3
	.word 0xd6142bf0  ! 1: LDUH_I	lduh	[%r16 + 0x0bf0], %r11
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xc6c42748  ! 1: LDSWA_I	ldswa	[%r16, + 0x0748] %asi, %r3
	.word 0xde8421e4  ! 1: LDUWA_I	lduwa	[%r16, + 0x01e4] %asi, %r15
	.word 0xda841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r13
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	.word 0xeccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r22
	.word 0xfcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r30
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_382
	dec %r31
	.word 0x9d2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r14
	.word 0xaa1c252b  ! 1: XOR_I	xor 	%r16, 0x052b, %r21
        mov 0x6f, %r31
thr3_loop_cnt_383:
	.word 0xc6942690  ! 1: LDUHA_I	lduha	[%r16, + 0x0690] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd0942604  ! 1: LDUHA_I	lduha	[%r16, + 0x0604] %asi, %r8
	.word 0xc65c2070  ! 1: LDX_I	ldx	[%r16 + 0x0070], %r3
	.word 0xec140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r22
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd85c2e30  ! 1: LDX_I	ldx	[%r16 + 0x0e30], %r12
	.word 0xf8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r28
	brnz %r31,thr3_loop_cnt_383
	dec %r31
        mov 0xc3, %r31
thr3_loop_cnt_384:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd84424b0  ! 1: LDSW_I	ldsw	[%r16 + 0x04b0], %r12
	.word 0xc6d428ba  ! 1: LDSHA_I	ldsha	[%r16, + 0x08ba] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r27
	.word 0xea040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r21
	.word 0xd21427ca  ! 1: LDUH_I	lduh	[%r16 + 0x07ca], %r9
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_384
	dec %r31
	.word 0x963421a5  ! 1: SUBC_I	orn 	%r16, 0x01a5, %r11
	.word 0xb03c2eed  ! 1: XNOR_I	xnor 	%r16, 0x0eed, %r24
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0x45, %r31
thr3_loop_cnt_385:
	.word 0xf2d42e1c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e1c] %asi, %r25
	.word 0xd4dc29e8  ! 1: LDXA_I	ldxa	[%r16, + 0x09e8] %asi, %r10
	.word 0xf8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r28
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r11
	.word 0xc6dc24d8  ! 1: LDXA_I	ldxa	[%r16, + 0x04d8] %asi, %r3
	.word 0xfcdc2c50  ! 1: LDXA_I	ldxa	[%r16, + 0x0c50] %asi, %r30
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_385
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0xaf, %r31
thr3_loop_cnt_386:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6042068  ! 1: LDUW_I	lduw	[%r16 + 0x0068], %r3
	.word 0xd8cc27f5  ! 1: LDSBA_I	ldsba	[%r16, + 0x07f5] %asi, %r12
	.word 0xd0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r8
	.word 0xc6142c5a  ! 1: LDUH_I	lduh	[%r16 + 0x0c5a], %r3
	.word 0xc6042d30  ! 1: LDUW_I	lduw	[%r16 + 0x0d30], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6442960  ! 1: LDSW_I	ldsw	[%r16 + 0x0960], %r3
	.word 0xcc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r6
	.word 0xc64c2465  ! 1: LDSB_I	ldsb	[%r16 + 0x0465], %r3
	.word 0xec040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r22
	brnz %r31,thr3_loop_cnt_386
	dec %r31
	.word 0x86442983  ! 1: ADDC_I	addc 	%r16, 0x0983, %r3
	.word 0xb0340002  ! 1: SUBC_R	orn 	%r16, %r2, %r24
	.word 0x94440002  ! 1: ADDC_R	addc 	%r16, %r2, %r10
        mov 0x7c, %r31
thr3_loop_cnt_387:
	.word 0xfac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r29
	.word 0xd4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r10
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xc6942d14  ! 1: LDUHA_I	lduha	[%r16, + 0x0d14] %asi, %r3
	.word 0xc6dc2798  ! 1: LDXA_I	ldxa	[%r16, + 0x0798] %asi, %r3
	.word 0xd48c280d  ! 1: LDUBA_I	lduba	[%r16, + 0x080d] %asi, %r10
	.word 0xc60c25bc  ! 1: LDUB_I	ldub	[%r16 + 0x05bc], %r3
	.word 0xc68c27c9  ! 1: LDUBA_I	lduba	[%r16, + 0x07c9] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_387
	dec %r31
	.word 0x9c2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r14
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0xd, %r31
thr3_loop_cnt_388:
	.word 0xc654218a  ! 1: LDSH_I	ldsh	[%r16 + 0x018a], %r3
	.word 0xc60c240e  ! 1: LDUB_I	ldub	[%r16 + 0x040e], %r3
	.word 0xc6d4233c  ! 1: LDSHA_I	ldsha	[%r16, + 0x033c] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r10
	.word 0xf29426ec  ! 1: LDUHA_I	lduha	[%r16, + 0x06ec] %asi, %r25
	.word 0xf65c2b68  ! 1: LDX_I	ldx	[%r16 + 0x0b68], %r27
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6042c28  ! 1: LDUW_I	lduw	[%r16 + 0x0c28], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6942baa  ! 1: LDUHA_I	lduha	[%r16, + 0x0baa] %asi, %r3
	brnz %r31,thr3_loop_cnt_388
	dec %r31
	.word 0x8c340002  ! 1: SUBC_R	orn 	%r16, %r2, %r6
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0xbc, %r31
thr3_loop_cnt_389:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd004276c  ! 1: LDUW_I	lduw	[%r16 + 0x076c], %r8
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6542754  ! 1: LDSH_I	ldsh	[%r16 + 0x0754], %r3
	.word 0xc6cc2761  ! 1: LDSBA_I	ldsba	[%r16, + 0x0761] %asi, %r3
	.word 0xc64424ac  ! 1: LDSW_I	ldsw	[%r16 + 0x04ac], %r3
	.word 0xc6cc223c  ! 1: LDSBA_I	ldsba	[%r16, + 0x023c] %asi, %r3
	.word 0xea941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r21
	.word 0xe88c23b5  ! 1: LDUBA_I	lduba	[%r16, + 0x03b5] %asi, %r20
	.word 0xda5422d0  ! 1: LDSH_I	ldsh	[%r16 + 0x02d0], %r13
	.word 0xd0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r8
	brnz %r31,thr3_loop_cnt_389
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0xb7, %r31
thr3_loop_cnt_390:
	.word 0xf6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r27
	.word 0xf6542d96  ! 1: LDSH_I	ldsh	[%r16 + 0x0d96], %r27
	.word 0xccc42f44  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f44] %asi, %r6
	.word 0xc60c2ad1  ! 1: LDUB_I	ldub	[%r16 + 0x0ad1], %r3
	.word 0xe4dc2568  ! 1: LDXA_I	ldxa	[%r16, + 0x0568] %asi, %r18
	.word 0xc65426b0  ! 1: LDSH_I	ldsh	[%r16 + 0x06b0], %r3
	.word 0xdedc2f78  ! 1: LDXA_I	ldxa	[%r16, + 0x0f78] %asi, %r15
	.word 0xe8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r20
	.word 0xfadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r29
	brnz %r31,thr3_loop_cnt_390
	dec %r31
	.word 0x86242228  ! 1: SUB_I	sub 	%r16, 0x0228, %r3
        mov 0x1f, %r31
thr3_loop_cnt_391:
	.word 0xc69427e4  ! 1: LDUHA_I	lduha	[%r16, + 0x07e4] %asi, %r3
	.word 0xd8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r12
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd4942ab8  ! 1: LDUHA_I	lduha	[%r16, + 0x0ab8] %asi, %r10
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xcedc2860  ! 1: LDXA_I	ldxa	[%r16, + 0x0860] %asi, %r7
	.word 0xc68420e0  ! 1: LDUWA_I	lduwa	[%r16, + 0x00e0] %asi, %r3
	.word 0xc6c421a0  ! 1: LDSWA_I	ldswa	[%r16, + 0x01a0] %asi, %r3
	.word 0xd8c429ec  ! 1: LDSWA_I	ldswa	[%r16, + 0x09ec] %asi, %r12
	.word 0xd0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r8
	brnz %r31,thr3_loop_cnt_391
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x36, %r31
thr3_loop_cnt_392:
	.word 0xdc5422c6  ! 1: LDSH_I	ldsh	[%r16 + 0x02c6], %r14
	.word 0xdcc42c20  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c20] %asi, %r14
	.word 0xde841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r15
	.word 0xccdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r6
	.word 0xc6942420  ! 1: LDUHA_I	lduha	[%r16, + 0x0420] %asi, %r3
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xd64c265c  ! 1: LDSB_I	ldsb	[%r16 + 0x065c], %r11
	.word 0xf24428f4  ! 1: LDSW_I	ldsw	[%r16 + 0x08f4], %r25
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xcc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r6
	.word 0xc6942e50  ! 1: LDUHA_I	lduha	[%r16, + 0x0e50] %asi, %r3
	.word 0xc64c286f  ! 1: LDSB_I	ldsb	[%r16 + 0x086f], %r3
	brnz %r31,thr3_loop_cnt_392
	dec %r31
        mov 0x58, %r31
thr3_loop_cnt_393:
	.word 0xdacc2f15  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f15] %asi, %r13
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd444209c  ! 1: LDSW_I	ldsw	[%r16 + 0x009c], %r10
	.word 0xe24c23cd  ! 1: LDSB_I	ldsb	[%r16 + 0x03cd], %r17
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	.word 0xc68c26cd  ! 1: LDUBA_I	lduba	[%r16, + 0x06cd] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r26
	brnz %r31,thr3_loop_cnt_393
	dec %r31
	.word 0x863c214d  ! 1: XNOR_I	xnor 	%r16, 0x014d, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0xa40c251a  ! 1: AND_I	and 	%r16, 0x051a, %r18
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0x1b, %r31
thr3_loop_cnt_394:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc60422f4  ! 1: LDUW_I	lduw	[%r16 + 0x02f4], %r3
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf04c2fa1  ! 1: LDSB_I	ldsb	[%r16 + 0x0fa1], %r24
	.word 0xfa5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r29
	.word 0xf24c2d5b  ! 1: LDSB_I	ldsb	[%r16 + 0x0d5b], %r25
	.word 0xf05c2e78  ! 1: LDX_I	ldx	[%r16 + 0x0e78], %r24
	brnz %r31,thr3_loop_cnt_394
	dec %r31
	.word 0x9f343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r15
	.word 0xb73c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r27
        mov 0x33, %r31
thr3_loop_cnt_395:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xcc0c224b  ! 1: LDUB_I	ldub	[%r16 + 0x024b], %r6
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xee4c2285  ! 1: LDSB_I	ldsb	[%r16 + 0x0285], %r23
	.word 0xfc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r30
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	.word 0xc6dc2a60  ! 1: LDXA_I	ldxa	[%r16, + 0x0a60] %asi, %r3
	.word 0xfc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r30
	.word 0xc64c2f6e  ! 1: LDSB_I	ldsb	[%r16 + 0x0f6e], %r3
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	.word 0xfc4428f4  ! 1: LDSW_I	ldsw	[%r16 + 0x08f4], %r30
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	brnz %r31,thr3_loop_cnt_395
	dec %r31
	.word 0x93343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r9
        mov 0x8, %r31
thr3_loop_cnt_396:
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xc6c42504  ! 1: LDSWA_I	ldswa	[%r16, + 0x0504] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xcc8c27e8  ! 1: LDUBA_I	lduba	[%r16, + 0x07e8] %asi, %r6
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6cc23a1  ! 1: LDSBA_I	ldsba	[%r16, + 0x03a1] %asi, %r3
	.word 0xd08c204f  ! 1: LDUBA_I	lduba	[%r16, + 0x004f] %asi, %r8
	.word 0xde8c2124  ! 1: LDUBA_I	lduba	[%r16, + 0x0124] %asi, %r15
	.word 0xd8542222  ! 1: LDSH_I	ldsh	[%r16 + 0x0222], %r12
	.word 0xc6cc21c7  ! 1: LDSBA_I	ldsba	[%r16, + 0x01c7] %asi, %r3
	.word 0xe2c42510  ! 1: LDSWA_I	ldswa	[%r16, + 0x0510] %asi, %r17
	brnz %r31,thr3_loop_cnt_396
	dec %r31
	.word 0x8614229b  ! 1: OR_I	or 	%r16, 0x029b, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x8e442c52  ! 1: ADDC_I	addc 	%r16, 0x0c52, %r7
        mov 0x49, %r31
thr3_loop_cnt_397:
	.word 0xfc8c2fbd  ! 1: LDUBA_I	lduba	[%r16, + 0x0fbd] %asi, %r30
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xdad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r13
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xe40c2beb  ! 1: LDUB_I	ldub	[%r16 + 0x0beb], %r18
	.word 0xec040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r22
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r28
	.word 0xd0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r8
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_397
	dec %r31
	.word 0x9a4429fe  ! 1: ADDC_I	addc 	%r16, 0x09fe, %r13
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x8f341002  ! 1: SRLX_R	srlx	%r16, %r2, %r7
	.word 0xbc0c2349  ! 1: AND_I	and 	%r16, 0x0349, %r30
        mov 0xad, %r31
thr3_loop_cnt_398:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r20
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r8
	.word 0xfac4291c  ! 1: LDSWA_I	ldswa	[%r16, + 0x091c] %asi, %r29
	.word 0xc6442ca4  ! 1: LDSW_I	ldsw	[%r16 + 0x0ca4], %r3
	.word 0xc6142596  ! 1: LDUH_I	lduh	[%r16 + 0x0596], %r3
	.word 0xc65c23e8  ! 1: LDX_I	ldx	[%r16 + 0x03e8], %r3
	.word 0xf2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r25
	brnz %r31,thr3_loop_cnt_398
	dec %r31
        mov 0xbd, %r31
thr3_loop_cnt_399:
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xfc042f44  ! 1: LDUW_I	lduw	[%r16 + 0x0f44], %r30
	.word 0xc60427a8  ! 1: LDUW_I	lduw	[%r16 + 0x07a8], %r3
	.word 0xda0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r13
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6942d6a  ! 1: LDUHA_I	lduha	[%r16, + 0x0d6a] %asi, %r3
	.word 0xd6942296  ! 1: LDUHA_I	lduha	[%r16, + 0x0296] %asi, %r11
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_399
	dec %r31
        mov 0x3f, %r31
thr3_loop_cnt_400:
	.word 0xd60c2f22  ! 1: LDUB_I	ldub	[%r16 + 0x0f22], %r11
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xc6842230  ! 1: LDUWA_I	lduwa	[%r16, + 0x0230] %asi, %r3
	.word 0xd6cc2ee8  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ee8] %asi, %r11
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe4942a84  ! 1: LDUHA_I	lduha	[%r16, + 0x0a84] %asi, %r18
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	.word 0xee542b40  ! 1: LDSH_I	ldsh	[%r16 + 0x0b40], %r23
	.word 0xc65c2008  ! 1: LDX_I	ldx	[%r16 + 0x0008], %r3
	brnz %r31,thr3_loop_cnt_400
	dec %r31
	.word 0x86342e8d  ! 1: SUBC_I	orn 	%r16, 0x0e8d, %r3
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0xb20c215f  ! 1: AND_I	and 	%r16, 0x015f, %r25
        mov 0xb, %r31
thr3_loop_cnt_401:
	.word 0xc68c26a1  ! 1: LDUBA_I	lduba	[%r16, + 0x06a1] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6442eec  ! 1: LDSW_I	ldsw	[%r16 + 0x0eec], %r3
	.word 0xc6542992  ! 1: LDSH_I	ldsh	[%r16 + 0x0992], %r3
	.word 0xc6c420e0  ! 1: LDSWA_I	ldswa	[%r16, + 0x00e0] %asi, %r3
	.word 0xf2d42154  ! 1: LDSHA_I	ldsha	[%r16, + 0x0154] %asi, %r25
	.word 0xe60426f4  ! 1: LDUW_I	lduw	[%r16 + 0x06f4], %r19
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_401
	dec %r31
	.word 0xa32c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r17
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0xb81c245b  ! 1: XOR_I	xor 	%r16, 0x045b, %r28
	.word 0xa4340002  ! 1: ORN_R	orn 	%r16, %r2, %r18
        mov 0x74, %r31
thr3_loop_cnt_402:
	.word 0xd45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r10
	.word 0xec5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r22
	.word 0xc6442a04  ! 1: LDSW_I	ldsw	[%r16 + 0x0a04], %r3
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	.word 0xc60c2fc1  ! 1: LDUB_I	ldub	[%r16 + 0x0fc1], %r3
	.word 0xd8c4248c  ! 1: LDSWA_I	ldswa	[%r16, + 0x048c] %asi, %r12
	.word 0xc60423b0  ! 1: LDUW_I	lduw	[%r16 + 0x03b0], %r3
	.word 0xe4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r18
	.word 0xda542444  ! 1: LDSH_I	ldsh	[%r16 + 0x0444], %r13
	.word 0xf2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r25
	.word 0xd0142cec  ! 1: LDUH_I	lduh	[%r16 + 0x0cec], %r8
	brnz %r31,thr3_loop_cnt_402
	dec %r31
        mov 0x53, %r31
thr3_loop_cnt_403:
	.word 0xde042abc  ! 1: LDUW_I	lduw	[%r16 + 0x0abc], %r15
	.word 0xec8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r22
	.word 0xc65c2ef0  ! 1: LDX_I	ldx	[%r16 + 0x0ef0], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe61424a8  ! 1: LDUH_I	lduh	[%r16 + 0x04a8], %r19
	.word 0xf0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r24
	.word 0xcec42d58  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d58] %asi, %r7
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_403
	dec %r31
	.word 0x972c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r11
	.word 0x9d3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r14
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0xbc240002  ! 1: SUB_R	sub 	%r16, %r2, %r30
        mov 0x6f, %r31
thr3_loop_cnt_404:
	.word 0xeed41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r23
	.word 0xea440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r21
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xdcdc2ca0  ! 1: LDXA_I	ldxa	[%r16, + 0x0ca0] %asi, %r14
	.word 0xf6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r27
	.word 0xf68c2051  ! 1: LDUBA_I	lduba	[%r16, + 0x0051] %asi, %r27
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf44425b4  ! 1: LDSW_I	ldsw	[%r16 + 0x05b4], %r26
	brnz %r31,thr3_loop_cnt_404
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x862c2fae  ! 1: ANDN_I	andn 	%r16, 0x0fae, %r3
        mov 0xa1, %r31
thr3_loop_cnt_405:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6d427d2  ! 1: LDSHA_I	ldsha	[%r16, + 0x07d2] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc64c283b  ! 1: LDSB_I	ldsb	[%r16 + 0x083b], %r3
	.word 0xc68c2e05  ! 1: LDUBA_I	lduba	[%r16, + 0x0e05] %asi, %r3
	.word 0xea5c2e38  ! 1: LDX_I	ldx	[%r16 + 0x0e38], %r21
	.word 0xd2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r9
	.word 0xdecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r15
	.word 0xd2d42054  ! 1: LDSHA_I	ldsha	[%r16, + 0x0054] %asi, %r9
	.word 0xc6d42062  ! 1: LDSHA_I	ldsha	[%r16, + 0x0062] %asi, %r3
	brnz %r31,thr3_loop_cnt_405
	dec %r31
	.word 0x8634232b  ! 1: SUBC_I	orn 	%r16, 0x032b, %r3
	.word 0xa814285a  ! 1: OR_I	or 	%r16, 0x085a, %r20
	.word 0xb8342e56  ! 1: ORN_I	orn 	%r16, 0x0e56, %r28
        mov 0x82, %r31
thr3_loop_cnt_406:
	.word 0xd4442e7c  ! 1: LDSW_I	ldsw	[%r16 + 0x0e7c], %r10
	.word 0xe28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r17
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xde941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r15
	.word 0xd4942f7c  ! 1: LDUHA_I	lduha	[%r16, + 0x0f7c] %asi, %r10
	.word 0xe28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r17
	.word 0xdc542fa8  ! 1: LDSH_I	ldsh	[%r16 + 0x0fa8], %r14
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc69421b0  ! 1: LDUHA_I	lduha	[%r16, + 0x01b0] %asi, %r3
	brnz %r31,thr3_loop_cnt_406
	dec %r31
	.word 0xa81c227b  ! 1: XOR_I	xor 	%r16, 0x027b, %r20
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0x92, %r31
thr3_loop_cnt_407:
	.word 0xf48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r26
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd2842e58  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e58] %asi, %r9
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc250c  ! 1: LDSBA_I	ldsba	[%r16, + 0x050c] %asi, %r3
	.word 0xdc0c2122  ! 1: LDUB_I	ldub	[%r16 + 0x0122], %r14
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc68c25ff  ! 1: LDUBA_I	lduba	[%r16, + 0x05ff] %asi, %r3
	brnz %r31,thr3_loop_cnt_407
	dec %r31
	.word 0x860421d9  ! 1: ADD_I	add 	%r16, 0x01d9, %r3
        mov 0x13, %r31
thr3_loop_cnt_408:
	.word 0xc694215c  ! 1: LDUHA_I	lduha	[%r16, + 0x015c] %asi, %r3
	.word 0xd894265e  ! 1: LDUHA_I	lduha	[%r16, + 0x065e] %asi, %r12
	.word 0xdc5c27b8  ! 1: LDX_I	ldx	[%r16 + 0x07b8], %r14
	.word 0xe6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r19
	.word 0xcc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r6
	.word 0xc6942ca4  ! 1: LDUHA_I	lduha	[%r16, + 0x0ca4] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd69423ce  ! 1: LDUHA_I	lduha	[%r16, + 0x03ce] %asi, %r11
	.word 0xdcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r14
	brnz %r31,thr3_loop_cnt_408
	dec %r31
	.word 0xa9340002  ! 1: SRL_R	srl 	%r16, %r2, %r20
        mov 0x50, %r31
thr3_loop_cnt_409:
	.word 0xc6142898  ! 1: LDUH_I	lduh	[%r16 + 0x0898], %r3
	.word 0xcc5c2d58  ! 1: LDX_I	ldx	[%r16 + 0x0d58], %r6
	.word 0xe85c2890  ! 1: LDX_I	ldx	[%r16 + 0x0890], %r20
	.word 0xccdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r6
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc68c27e9  ! 1: LDUBA_I	lduba	[%r16, + 0x07e9] %asi, %r3
	.word 0xcc542c72  ! 1: LDSH_I	ldsh	[%r16 + 0x0c72], %r6
	.word 0xdc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r14
	brnz %r31,thr3_loop_cnt_409
	dec %r31
	.word 0xba040002  ! 1: ADD_R	add 	%r16, %r2, %r29
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0xa3, %r31
thr3_loop_cnt_410:
	.word 0xc6942b92  ! 1: LDUHA_I	lduha	[%r16, + 0x0b92] %asi, %r3
	.word 0xdcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r14
	.word 0xd6842f20  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f20] %asi, %r11
	.word 0xd4942eba  ! 1: LDUHA_I	lduha	[%r16, + 0x0eba] %asi, %r10
	.word 0xd244254c  ! 1: LDSW_I	ldsw	[%r16 + 0x054c], %r9
	.word 0xe2c422dc  ! 1: LDSWA_I	ldswa	[%r16, + 0x02dc] %asi, %r17
	.word 0xccdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r6
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_410
	dec %r31
	.word 0xa41c0002  ! 1: XOR_R	xor 	%r16, %r2, %r18
        mov 0x82, %r31
thr3_loop_cnt_411:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r8
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xdc842bf0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0bf0] %asi, %r14
	.word 0xf65c2270  ! 1: LDX_I	ldx	[%r16 + 0x0270], %r27
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xc6c42748  ! 1: LDSWA_I	ldswa	[%r16, + 0x0748] %asi, %r3
	.word 0xc6042f2c  ! 1: LDUW_I	lduw	[%r16 + 0x0f2c], %r3
	.word 0xe8042fa4  ! 1: LDUW_I	lduw	[%r16 + 0x0fa4], %r20
	brnz %r31,thr3_loop_cnt_411
	dec %r31
        mov 0xc6, %r31
thr3_loop_cnt_412:
	.word 0xc64c206f  ! 1: LDSB_I	ldsb	[%r16 + 0x006f], %r3
	.word 0xc6042e94  ! 1: LDUW_I	lduw	[%r16 + 0x0e94], %r3
	.word 0xdc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r14
	.word 0xf0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r24
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xe8dc2be8  ! 1: LDXA_I	ldxa	[%r16, + 0x0be8] %asi, %r20
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe84c2796  ! 1: LDSB_I	ldsb	[%r16 + 0x0796], %r20
	.word 0xc6d4260c  ! 1: LDSHA_I	ldsha	[%r16, + 0x060c] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc654244a  ! 1: LDSH_I	ldsh	[%r16 + 0x044a], %r3
	brnz %r31,thr3_loop_cnt_412
	dec %r31
	.word 0x972c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r11
        mov 0xb3, %r31
thr3_loop_cnt_413:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd68c2a59  ! 1: LDUBA_I	lduba	[%r16, + 0x0a59] %asi, %r11
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd41428f2  ! 1: LDUH_I	lduh	[%r16 + 0x08f2], %r10
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf0c42070  ! 1: LDSWA_I	ldswa	[%r16, + 0x0070] %asi, %r24
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xfad42210  ! 1: LDSHA_I	ldsha	[%r16, + 0x0210] %asi, %r29
	.word 0xec140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r22
	brnz %r31,thr3_loop_cnt_413
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x32, %r31
thr3_loop_cnt_414:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf2dc2668  ! 1: LDXA_I	ldxa	[%r16, + 0x0668] %asi, %r25
	.word 0xd8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r12
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xf8942b22  ! 1: LDUHA_I	lduha	[%r16, + 0x0b22] %asi, %r28
	.word 0xc64422e8  ! 1: LDSW_I	ldsw	[%r16 + 0x02e8], %r3
	.word 0xd4942c4a  ! 1: LDUHA_I	lduha	[%r16, + 0x0c4a] %asi, %r10
	.word 0xc6c4235c  ! 1: LDSWA_I	ldswa	[%r16, + 0x035c] %asi, %r3
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	brnz %r31,thr3_loop_cnt_414
	dec %r31
	.word 0x8614278d  ! 1: OR_I	or 	%r16, 0x078d, %r3
        mov 0x5a, %r31
thr3_loop_cnt_415:
	.word 0xea8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r21
	.word 0xfacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r29
	.word 0xd80c2344  ! 1: LDUB_I	ldub	[%r16 + 0x0344], %r12
	.word 0xe8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r20
	.word 0xda4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r13
	.word 0xd8142b00  ! 1: LDUH_I	lduh	[%r16 + 0x0b00], %r12
	.word 0xc6942284  ! 1: LDUHA_I	lduha	[%r16, + 0x0284] %asi, %r3
	.word 0xde440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r15
	brnz %r31,thr3_loop_cnt_415
	dec %r31
	.word 0x982c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r12
	.word 0xa62c2b28  ! 1: ANDN_I	andn 	%r16, 0x0b28, %r19
        mov 0x2c, %r31
thr3_loop_cnt_416:
	.word 0xde9425cc  ! 1: LDUHA_I	lduha	[%r16, + 0x05cc] %asi, %r15
	.word 0xf8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r28
	.word 0xdcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r14
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xfccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r30
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf8c42240  ! 1: LDSWA_I	ldswa	[%r16, + 0x0240] %asi, %r28
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	brnz %r31,thr3_loop_cnt_416
	dec %r31
	.word 0xb63c22db  ! 1: XNOR_I	xnor 	%r16, 0x02db, %r27
	.word 0x901c2c2e  ! 1: XOR_I	xor 	%r16, 0x0c2e, %r8
	.word 0x9e34244c  ! 1: ORN_I	orn 	%r16, 0x044c, %r15
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x4, %r31
thr3_loop_cnt_417:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xe8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r20
	.word 0xde0426fc  ! 1: LDUW_I	lduw	[%r16 + 0x06fc], %r15
	.word 0xf00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r24
	.word 0xc6442dd4  ! 1: LDSW_I	ldsw	[%r16 + 0x0dd4], %r3
	.word 0xf2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r25
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf8842c70  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c70] %asi, %r28
	brnz %r31,thr3_loop_cnt_417
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0xba342269  ! 1: ORN_I	orn 	%r16, 0x0269, %r29
        mov 0x3, %r31
thr3_loop_cnt_418:
	.word 0xfcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r30
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6cc2631  ! 1: LDSBA_I	ldsba	[%r16, + 0x0631] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xd85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r12
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	brnz %r31,thr3_loop_cnt_418
	dec %r31
        mov 0x1b, %r31
thr3_loop_cnt_419:
	.word 0xd6c420d0  ! 1: LDSWA_I	ldswa	[%r16, + 0x00d0] %asi, %r11
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xecdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r22
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r27
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r24
	.word 0xec440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r22
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	brnz %r31,thr3_loop_cnt_419
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x983429fd  ! 1: ORN_I	orn 	%r16, 0x09fd, %r12
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0xa8140002  ! 1: OR_R	or 	%r16, %r2, %r20
        mov 0x69, %r31
thr3_loop_cnt_420:
	.word 0xf8142588  ! 1: LDUH_I	lduh	[%r16 + 0x0588], %r28
	.word 0xc68428f8  ! 1: LDUWA_I	lduwa	[%r16, + 0x08f8] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xfa040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r29
	.word 0xc6442024  ! 1: LDSW_I	ldsw	[%r16 + 0x0024], %r3
	.word 0xe8942604  ! 1: LDUHA_I	lduha	[%r16, + 0x0604] %asi, %r20
	.word 0xc6542d82  ! 1: LDSH_I	ldsh	[%r16 + 0x0d82], %r3
	.word 0xf64c2a91  ! 1: LDSB_I	ldsb	[%r16 + 0x0a91], %r27
	.word 0xc6442c68  ! 1: LDSW_I	ldsw	[%r16 + 0x0c68], %r3
	.word 0xec942916  ! 1: LDUHA_I	lduha	[%r16, + 0x0916] %asi, %r22
	.word 0xd8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r12
	.word 0xc6dc2f28  ! 1: LDXA_I	ldxa	[%r16, + 0x0f28] %asi, %r3
	brnz %r31,thr3_loop_cnt_420
	dec %r31
        mov 0xbe, %r31
thr3_loop_cnt_421:
	.word 0xc6d422ac  ! 1: LDSHA_I	ldsha	[%r16, + 0x02ac] %asi, %r3
	.word 0xc65421d8  ! 1: LDSH_I	ldsh	[%r16 + 0x01d8], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xec5c2d28  ! 1: LDX_I	ldx	[%r16 + 0x0d28], %r22
	.word 0xd05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r8
	.word 0xfa841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r29
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_421
	dec %r31
	.word 0x9a3c222d  ! 1: XNOR_I	xnor 	%r16, 0x022d, %r13
        mov 0x7e, %r31
thr3_loop_cnt_422:
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xce8c2e34  ! 1: LDUBA_I	lduba	[%r16, + 0x0e34] %asi, %r7
	.word 0xc684236c  ! 1: LDUWA_I	lduwa	[%r16, + 0x036c] %asi, %r3
	.word 0xc6d427bc  ! 1: LDSHA_I	ldsha	[%r16, + 0x07bc] %asi, %r3
	.word 0xe8c42b14  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b14] %asi, %r20
	.word 0xd80c2029  ! 1: LDUB_I	ldub	[%r16 + 0x0029], %r12
	.word 0xd88c2311  ! 1: LDUBA_I	lduba	[%r16, + 0x0311] %asi, %r12
	.word 0xfa140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r29
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xda540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r13
	brnz %r31,thr3_loop_cnt_422
	dec %r31
	.word 0xad340002  ! 1: SRL_R	srl 	%r16, %r2, %r22
	.word 0xab2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r21
	.word 0x8604273c  ! 1: ADD_I	add 	%r16, 0x073c, %r3
        mov 0xc0, %r31
thr3_loop_cnt_423:
	.word 0xec442e2c  ! 1: LDSW_I	ldsw	[%r16 + 0x0e2c], %r22
	.word 0xced422d8  ! 1: LDSHA_I	ldsha	[%r16, + 0x02d8] %asi, %r7
	.word 0xc64426b0  ! 1: LDSW_I	ldsw	[%r16 + 0x06b0], %r3
	.word 0xc6cc211c  ! 1: LDSBA_I	ldsba	[%r16, + 0x011c] %asi, %r3
	.word 0xd0d42bc8  ! 1: LDSHA_I	ldsha	[%r16, + 0x0bc8] %asi, %r8
	.word 0xe8cc249d  ! 1: LDSBA_I	ldsba	[%r16, + 0x049d] %asi, %r20
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xec841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r22
	.word 0xc69426b8  ! 1: LDUHA_I	lduha	[%r16, + 0x06b8] %asi, %r3
	.word 0xc6c428b8  ! 1: LDSWA_I	ldswa	[%r16, + 0x08b8] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_423
	dec %r31
	.word 0x960c0002  ! 1: AND_R	and 	%r16, %r2, %r11
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0x38, %r31
thr3_loop_cnt_424:
	.word 0xf4dc22b8  ! 1: LDXA_I	ldxa	[%r16, + 0x02b8] %asi, %r26
	.word 0xd40420ec  ! 1: LDUW_I	lduw	[%r16 + 0x00ec], %r10
	.word 0xce941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r7
	.word 0xc6842548  ! 1: LDUWA_I	lduwa	[%r16, + 0x0548] %asi, %r3
	.word 0xc6942084  ! 1: LDUHA_I	lduha	[%r16, + 0x0084] %asi, %r3
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xc6542118  ! 1: LDSH_I	ldsh	[%r16 + 0x0118], %r3
	.word 0xc6542ee4  ! 1: LDSH_I	ldsh	[%r16 + 0x0ee4], %r3
	.word 0xe80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r20
	.word 0xd4d4220c  ! 1: LDSHA_I	ldsha	[%r16, + 0x020c] %asi, %r10
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xce542d20  ! 1: LDSH_I	ldsh	[%r16 + 0x0d20], %r7
	brnz %r31,thr3_loop_cnt_424
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0xaa0c21ee  ! 1: AND_I	and 	%r16, 0x01ee, %r21
        mov 0x17, %r31
thr3_loop_cnt_425:
	.word 0xf04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r24
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xcc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r6
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xfa4c286a  ! 1: LDSB_I	ldsb	[%r16 + 0x086a], %r29
	.word 0xc6942f56  ! 1: LDUHA_I	lduha	[%r16, + 0x0f56] %asi, %r3
	.word 0xc6542740  ! 1: LDSH_I	ldsh	[%r16 + 0x0740], %r3
	.word 0xcc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r6
	brnz %r31,thr3_loop_cnt_425
	dec %r31
        mov 0x7d, %r31
thr3_loop_cnt_426:
	.word 0xc60c2966  ! 1: LDUB_I	ldub	[%r16 + 0x0966], %r3
	.word 0xec942896  ! 1: LDUHA_I	lduha	[%r16, + 0x0896] %asi, %r22
	.word 0xc614219a  ! 1: LDUH_I	lduh	[%r16 + 0x019a], %r3
	.word 0xcc5c2be8  ! 1: LDX_I	ldx	[%r16 + 0x0be8], %r6
	.word 0xc64422a4  ! 1: LDSW_I	ldsw	[%r16 + 0x02a4], %r3
	.word 0xd2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r9
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xe68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r19
	.word 0xc6942ba4  ! 1: LDUHA_I	lduha	[%r16, + 0x0ba4] %asi, %r3
	brnz %r31,thr3_loop_cnt_426
	dec %r31
	.word 0x86342963  ! 1: ORN_I	orn 	%r16, 0x0963, %r3
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0x1e, %r31
thr3_loop_cnt_427:
	.word 0xe6542a0a  ! 1: LDSH_I	ldsh	[%r16 + 0x0a0a], %r19
	.word 0xf8dc2e88  ! 1: LDXA_I	ldxa	[%r16, + 0x0e88] %asi, %r28
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xe6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r19
	.word 0xc644231c  ! 1: LDSW_I	ldsw	[%r16 + 0x031c], %r3
	.word 0xda841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r13
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_427
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0xb40c2d47  ! 1: AND_I	and 	%r16, 0x0d47, %r26
	.word 0x973c0002  ! 1: SRA_R	sra 	%r16, %r2, %r11
        mov 0x9a, %r31
thr3_loop_cnt_428:
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	.word 0xda841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r13
	.word 0xe8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r20
	.word 0xc6842b74  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b74] %asi, %r3
	.word 0xe44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r18
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xe64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r19
	.word 0xde9421d0  ! 1: LDUHA_I	lduha	[%r16, + 0x01d0] %asi, %r15
	.word 0xd8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r12
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_428
	dec %r31
        mov 0xbd, %r31
thr3_loop_cnt_429:
	.word 0xe85c2fe0  ! 1: LDX_I	ldx	[%r16 + 0x0fe0], %r20
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xd614238e  ! 1: LDUH_I	lduh	[%r16 + 0x038e], %r11
	.word 0xc68c2f40  ! 1: LDUBA_I	lduba	[%r16, + 0x0f40] %asi, %r3
	.word 0xd4d42a22  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a22] %asi, %r10
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xda440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r13
	.word 0xfa8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r29
	.word 0xee5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r23
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_429
	dec %r31
	.word 0xa92c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r20
	.word 0x92342ab4  ! 1: SUBC_I	orn 	%r16, 0x0ab4, %r9
        mov 0x95, %r31
thr3_loop_cnt_430:
	.word 0xced42cfc  ! 1: LDSHA_I	ldsha	[%r16, + 0x0cfc] %asi, %r7
	.word 0xe4042748  ! 1: LDUW_I	lduw	[%r16 + 0x0748], %r18
	.word 0xd6942634  ! 1: LDUHA_I	lduha	[%r16, + 0x0634] %asi, %r11
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6442e60  ! 1: LDSW_I	ldsw	[%r16 + 0x0e60], %r3
	.word 0xce440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r7
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_430
	dec %r31
        mov 0x8, %r31
thr3_loop_cnt_431:
	.word 0xc6c42410  ! 1: LDSWA_I	ldswa	[%r16, + 0x0410] %asi, %r3
	.word 0xc64c2420  ! 1: LDSB_I	ldsb	[%r16 + 0x0420], %r3
	.word 0xc6c42254  ! 1: LDSWA_I	ldswa	[%r16, + 0x0254] %asi, %r3
	.word 0xf45421cc  ! 1: LDSH_I	ldsh	[%r16 + 0x01cc], %r26
	.word 0xfa0c2e69  ! 1: LDUB_I	ldub	[%r16 + 0x0e69], %r29
	.word 0xd45c28d8  ! 1: LDX_I	ldx	[%r16 + 0x08d8], %r10
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf0c42940  ! 1: LDSWA_I	ldswa	[%r16, + 0x0940] %asi, %r24
	.word 0xd68c23e7  ! 1: LDUBA_I	lduba	[%r16, + 0x03e7] %asi, %r11
	brnz %r31,thr3_loop_cnt_431
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0xb2342501  ! 1: ORN_I	orn 	%r16, 0x0501, %r25
        mov 0x81, %r31
thr3_loop_cnt_432:
	.word 0xd8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r12
	.word 0xd0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r8
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	.word 0xe25c28d8  ! 1: LDX_I	ldx	[%r16 + 0x08d8], %r17
	.word 0xd0942174  ! 1: LDUHA_I	lduha	[%r16, + 0x0174] %asi, %r8
	.word 0xc6842aa8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0aa8] %asi, %r3
	.word 0xd4cc223e  ! 1: LDSBA_I	ldsba	[%r16, + 0x023e] %asi, %r10
	.word 0xc69425de  ! 1: LDUHA_I	lduha	[%r16, + 0x05de] %asi, %r3
	brnz %r31,thr3_loop_cnt_432
	dec %r31
        mov 0x31, %r31
thr3_loop_cnt_433:
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	.word 0xc6942db4  ! 1: LDUHA_I	lduha	[%r16, + 0x0db4] %asi, %r3
	.word 0xd0142cdc  ! 1: LDUH_I	lduh	[%r16 + 0x0cdc], %r8
	.word 0xe80c2efe  ! 1: LDUB_I	ldub	[%r16 + 0x0efe], %r20
	.word 0xc6cc202c  ! 1: LDSBA_I	ldsba	[%r16, + 0x002c] %asi, %r3
	.word 0xee4c20a1  ! 1: LDSB_I	ldsb	[%r16 + 0x00a1], %r23
	.word 0xe24c20e0  ! 1: LDSB_I	ldsb	[%r16 + 0x00e0], %r17
	.word 0xc6542e66  ! 1: LDSH_I	ldsh	[%r16 + 0x0e66], %r3
	brnz %r31,thr3_loop_cnt_433
	dec %r31
	.word 0x92340002  ! 1: SUBC_R	orn 	%r16, %r2, %r9
	.word 0xa6340002  ! 1: SUBC_R	orn 	%r16, %r2, %r19
	.word 0x860c2160  ! 1: AND_I	and 	%r16, 0x0160, %r3
        mov 0x92, %r31
thr3_loop_cnt_434:
	.word 0xf48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r26
	.word 0xe2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r17
	.word 0xd28c2c0d  ! 1: LDUBA_I	lduba	[%r16, + 0x0c0d] %asi, %r9
	.word 0xe4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r18
	.word 0xc68c21de  ! 1: LDUBA_I	lduba	[%r16, + 0x01de] %asi, %r3
	.word 0xc6dc2f98  ! 1: LDXA_I	ldxa	[%r16, + 0x0f98] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xfa042c34  ! 1: LDUW_I	lduw	[%r16 + 0x0c34], %r29
	.word 0xcc8c2f35  ! 1: LDUBA_I	lduba	[%r16, + 0x0f35] %asi, %r6
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xde0422f0  ! 1: LDUW_I	lduw	[%r16 + 0x02f0], %r15
	brnz %r31,thr3_loop_cnt_434
	dec %r31
	.word 0xb6342abd  ! 1: SUBC_I	orn 	%r16, 0x0abd, %r27
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0xc2, %r31
thr3_loop_cnt_435:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6c42010  ! 1: LDSWA_I	ldswa	[%r16, + 0x0010] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc203c  ! 1: LDSBA_I	ldsba	[%r16, + 0x003c] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc69422f2  ! 1: LDUHA_I	lduha	[%r16, + 0x02f2] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6d429ac  ! 1: LDSHA_I	ldsha	[%r16, + 0x09ac] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xee4427fc  ! 1: LDSW_I	ldsw	[%r16 + 0x07fc], %r23
	.word 0xc6542e38  ! 1: LDSH_I	ldsh	[%r16 + 0x0e38], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_435
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x62, %r31
thr3_loop_cnt_436:
	.word 0xc68c2c8a  ! 1: LDUBA_I	lduba	[%r16, + 0x0c8a] %asi, %r3
	.word 0xc6542fa0  ! 1: LDSH_I	ldsh	[%r16 + 0x0fa0], %r3
	.word 0xd8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r12
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xead42bcc  ! 1: LDSHA_I	ldsha	[%r16, + 0x0bcc] %asi, %r21
	.word 0xc6c42be4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0be4] %asi, %r3
	.word 0xdcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r14
	.word 0xc604269c  ! 1: LDUW_I	lduw	[%r16 + 0x069c], %r3
	.word 0xf0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r24
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_436
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x96240002  ! 1: SUB_R	sub 	%r16, %r2, %r11
        mov 0x7b, %r31
thr3_loop_cnt_437:
	.word 0xecdc21c0  ! 1: LDXA_I	ldxa	[%r16, + 0x01c0] %asi, %r22
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xc654270c  ! 1: LDSH_I	ldsh	[%r16 + 0x070c], %r3
	.word 0xeedc2b78  ! 1: LDXA_I	ldxa	[%r16, + 0x0b78] %asi, %r23
	.word 0xd2942776  ! 1: LDUHA_I	lduha	[%r16, + 0x0776] %asi, %r9
	.word 0xc65c2ac0  ! 1: LDX_I	ldx	[%r16 + 0x0ac0], %r3
	.word 0xc6c42564  ! 1: LDSWA_I	ldswa	[%r16, + 0x0564] %asi, %r3
	.word 0xf2dc2f40  ! 1: LDXA_I	ldxa	[%r16, + 0x0f40] %asi, %r25
	.word 0xf4942266  ! 1: LDUHA_I	lduha	[%r16, + 0x0266] %asi, %r26
	brnz %r31,thr3_loop_cnt_437
	dec %r31
	.word 0x860c25b7  ! 1: AND_I	and 	%r16, 0x05b7, %r3
	.word 0xaa2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r21
        mov 0x63, %r31
thr3_loop_cnt_438:
	.word 0xdedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r15
	.word 0xd24c2011  ! 1: LDSB_I	ldsb	[%r16 + 0x0011], %r9
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd2142cca  ! 1: LDUH_I	lduh	[%r16 + 0x0cca], %r9
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	brnz %r31,thr3_loop_cnt_438
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0xbc3c2ab3  ! 1: XNOR_I	xnor 	%r16, 0x0ab3, %r30
	.word 0x86142faf  ! 1: OR_I	or 	%r16, 0x0faf, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x9b, %r31
thr3_loop_cnt_439:
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	.word 0xd0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r8
	.word 0xc6d4267c  ! 1: LDSHA_I	ldsha	[%r16, + 0x067c] %asi, %r3
	.word 0xd0c4280c  ! 1: LDSWA_I	ldswa	[%r16, + 0x080c] %asi, %r8
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2b58  ! 1: LDXA_I	ldxa	[%r16, + 0x0b58] %asi, %r3
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	.word 0xd2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r9
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6cc2999  ! 1: LDSBA_I	ldsba	[%r16, + 0x0999] %asi, %r3
	.word 0xdc542cba  ! 1: LDSH_I	ldsh	[%r16 + 0x0cba], %r14
	brnz %r31,thr3_loop_cnt_439
	dec %r31
	.word 0x9b342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r13
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x63, %r31
thr3_loop_cnt_440:
	.word 0xfcc42020  ! 1: LDSWA_I	ldswa	[%r16, + 0x0020] %asi, %r30
	.word 0xc69425c4  ! 1: LDUHA_I	lduha	[%r16, + 0x05c4] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc69426d0  ! 1: LDUHA_I	lduha	[%r16, + 0x06d0] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc64c2b6f  ! 1: LDSB_I	ldsb	[%r16 + 0x0b6f], %r3
	.word 0xf0d422f6  ! 1: LDSHA_I	ldsha	[%r16, + 0x02f6] %asi, %r24
	.word 0xc6dc2238  ! 1: LDXA_I	ldxa	[%r16, + 0x0238] %asi, %r3
	.word 0xc68c2c37  ! 1: LDUBA_I	lduba	[%r16, + 0x0c37] %asi, %r3
	.word 0xc60c2074  ! 1: LDUB_I	ldub	[%r16 + 0x0074], %r3
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	brnz %r31,thr3_loop_cnt_440
	dec %r31
	.word 0xb21c0002  ! 1: XOR_R	xor 	%r16, %r2, %r25
        mov 0x72, %r31
thr3_loop_cnt_441:
	.word 0xc6142f64  ! 1: LDUH_I	lduh	[%r16 + 0x0f64], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc68429f8  ! 1: LDUWA_I	lduwa	[%r16, + 0x09f8] %asi, %r3
	.word 0xc684253c  ! 1: LDUWA_I	lduwa	[%r16, + 0x053c] %asi, %r3
	.word 0xd6cc2a69  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a69] %asi, %r11
	.word 0xc68c2b64  ! 1: LDUBA_I	lduba	[%r16, + 0x0b64] %asi, %r3
	.word 0xea040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r21
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6d42da8  ! 1: LDSHA_I	ldsha	[%r16, + 0x0da8] %asi, %r3
	.word 0xee8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r23
	brnz %r31,thr3_loop_cnt_441
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x8e0c0002  ! 1: AND_R	and 	%r16, %r2, %r7
	.word 0x903c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r8
        mov 0x97, %r31
thr3_loop_cnt_442:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc64c2123  ! 1: LDSB_I	ldsb	[%r16 + 0x0123], %r3
	.word 0xe81420c6  ! 1: LDUH_I	lduh	[%r16 + 0x00c6], %r20
	.word 0xc65c2140  ! 1: LDX_I	ldx	[%r16 + 0x0140], %r3
	.word 0xfa440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r29
	.word 0xfcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r30
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xfcd427a6  ! 1: LDSHA_I	ldsha	[%r16, + 0x07a6] %asi, %r30
	brnz %r31,thr3_loop_cnt_442
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x8f3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r7
	.word 0x86142369  ! 1: OR_I	or 	%r16, 0x0369, %r3
	.word 0xb21424a3  ! 1: OR_I	or 	%r16, 0x04a3, %r25
        mov 0x5f, %r31
thr3_loop_cnt_443:
	.word 0xdc442b04  ! 1: LDSW_I	ldsw	[%r16 + 0x0b04], %r14
	.word 0xc64c2228  ! 1: LDSB_I	ldsb	[%r16 + 0x0228], %r3
	.word 0xd80c2060  ! 1: LDUB_I	ldub	[%r16 + 0x0060], %r12
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6c42264  ! 1: LDSWA_I	ldswa	[%r16, + 0x0264] %asi, %r3
	.word 0xc68426e0  ! 1: LDUWA_I	lduwa	[%r16, + 0x06e0] %asi, %r3
	.word 0xfc5c24e0  ! 1: LDX_I	ldx	[%r16 + 0x04e0], %r30
	.word 0xe4142e56  ! 1: LDUH_I	lduh	[%r16 + 0x0e56], %r18
	.word 0xf2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r25
	.word 0xc6942dbc  ! 1: LDUHA_I	lduha	[%r16, + 0x0dbc] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_443
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0x3d, %r31
thr3_loop_cnt_444:
	.word 0xd8cc21fd  ! 1: LDSBA_I	ldsba	[%r16, + 0x01fd] %asi, %r12
	.word 0xc64c2127  ! 1: LDSB_I	ldsb	[%r16 + 0x0127], %r3
	.word 0xda042994  ! 1: LDUW_I	lduw	[%r16 + 0x0994], %r13
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf4cc2e73  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e73] %asi, %r26
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd6142704  ! 1: LDUH_I	lduh	[%r16 + 0x0704], %r11
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_444
	dec %r31
	.word 0x9b3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r13
        mov 0x4a, %r31
thr3_loop_cnt_445:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6942490  ! 1: LDUHA_I	lduha	[%r16, + 0x0490] %asi, %r3
	.word 0xf49423f6  ! 1: LDUHA_I	lduha	[%r16, + 0x03f6] %asi, %r26
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xfadc29a0  ! 1: LDXA_I	ldxa	[%r16, + 0x09a0] %asi, %r29
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc60c2b73  ! 1: LDUB_I	ldub	[%r16 + 0x0b73], %r3
	.word 0xfc942aee  ! 1: LDUHA_I	lduha	[%r16, + 0x0aee] %asi, %r30
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	.word 0xf2c42418  ! 1: LDSWA_I	ldswa	[%r16, + 0x0418] %asi, %r25
	.word 0xc64421a8  ! 1: LDSW_I	ldsw	[%r16 + 0x01a8], %r3
	brnz %r31,thr3_loop_cnt_445
	dec %r31
	.word 0xbc240002  ! 1: SUB_R	sub 	%r16, %r2, %r30
        mov 0x4a, %r31
thr3_loop_cnt_446:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc64421a4  ! 1: LDSW_I	ldsw	[%r16 + 0x01a4], %r3
	.word 0xf85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r28
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xdacc2b05  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b05] %asi, %r13
	.word 0xc6dc2b18  ! 1: LDXA_I	ldxa	[%r16, + 0x0b18] %asi, %r3
	.word 0xd40c25a4  ! 1: LDUB_I	ldub	[%r16 + 0x05a4], %r10
	.word 0xe2042354  ! 1: LDUW_I	lduw	[%r16 + 0x0354], %r17
	brnz %r31,thr3_loop_cnt_446
	dec %r31
        mov 0x4f, %r31
thr3_loop_cnt_447:
	.word 0xc60c28ed  ! 1: LDUB_I	ldub	[%r16 + 0x08ed], %r3
	.word 0xf64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r27
	.word 0xf0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r24
	.word 0xc68c26aa  ! 1: LDUBA_I	lduba	[%r16, + 0x06aa] %asi, %r3
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xfa5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r29
	.word 0xc6142f2a  ! 1: LDUH_I	lduh	[%r16 + 0x0f2a], %r3
	.word 0xea0c2403  ! 1: LDUB_I	ldub	[%r16 + 0x0403], %r21
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	.word 0xcc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r6
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	brnz %r31,thr3_loop_cnt_447
	dec %r31
	.word 0x913c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r8
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x24, %r31
thr3_loop_cnt_448:
	.word 0xe4c429c8  ! 1: LDSWA_I	ldswa	[%r16, + 0x09c8] %asi, %r18
	.word 0xde542e26  ! 1: LDSH_I	ldsh	[%r16 + 0x0e26], %r15
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xda54253a  ! 1: LDSH_I	ldsh	[%r16 + 0x053a], %r13
	.word 0xcc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r6
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xfc542262  ! 1: LDSH_I	ldsh	[%r16 + 0x0262], %r30
	.word 0xd88c2951  ! 1: LDUBA_I	lduba	[%r16, + 0x0951] %asi, %r12
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_448
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x29, %r31
thr3_loop_cnt_449:
	.word 0xe6042ad4  ! 1: LDUW_I	lduw	[%r16 + 0x0ad4], %r19
	.word 0xe80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r20
	.word 0xc6cc22d5  ! 1: LDSBA_I	ldsba	[%r16, + 0x02d5] %asi, %r3
	.word 0xc6dc2298  ! 1: LDXA_I	ldxa	[%r16, + 0x0298] %asi, %r3
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xdc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r14
	.word 0xced421f4  ! 1: LDSHA_I	ldsha	[%r16, + 0x01f4] %asi, %r7
	.word 0xf8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r28
	brnz %r31,thr3_loop_cnt_449
	dec %r31
	.word 0x861c218d  ! 1: XOR_I	xor 	%r16, 0x018d, %r3
	.word 0xad342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r22
        mov 0x68, %r31
thr3_loop_cnt_450:
	.word 0xe8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r20
	.word 0xd6dc2e98  ! 1: LDXA_I	ldxa	[%r16, + 0x0e98] %asi, %r11
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xec4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r22
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xdc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r14
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_450
	dec %r31
	.word 0x864421df  ! 1: ADDC_I	addc 	%r16, 0x01df, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0x38, %r31
thr3_loop_cnt_451:
	.word 0xe894240a  ! 1: LDUHA_I	lduha	[%r16, + 0x040a] %asi, %r20
	.word 0xccdc2c48  ! 1: LDXA_I	ldxa	[%r16, + 0x0c48] %asi, %r6
	.word 0xe6442774  ! 1: LDSW_I	ldsw	[%r16 + 0x0774], %r19
	.word 0xe4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r18
	.word 0xda4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r13
	.word 0xdadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r13
	.word 0xc68c27e2  ! 1: LDUBA_I	lduba	[%r16, + 0x07e2] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xec540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r22
	.word 0xfa4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r29
	.word 0xe6542a66  ! 1: LDSH_I	ldsh	[%r16 + 0x0a66], %r19
	.word 0xc68c2d92  ! 1: LDUBA_I	lduba	[%r16, + 0x0d92] %asi, %r3
	brnz %r31,thr3_loop_cnt_451
	dec %r31
	.word 0x860c2ce4  ! 1: AND_I	and 	%r16, 0x0ce4, %r3
	.word 0x861c27ec  ! 1: XOR_I	xor 	%r16, 0x07ec, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0xa5, %r31
thr3_loop_cnt_452:
	.word 0xc64c2175  ! 1: LDSB_I	ldsb	[%r16 + 0x0175], %r3
	.word 0xe6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r19
	.word 0xc6542f48  ! 1: LDSH_I	ldsh	[%r16 + 0x0f48], %r3
	.word 0xc65c2940  ! 1: LDX_I	ldx	[%r16 + 0x0940], %r3
	.word 0xfcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r30
	.word 0xc64422c8  ! 1: LDSW_I	ldsw	[%r16 + 0x02c8], %r3
	.word 0xd4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r10
	.word 0xe2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r17
	brnz %r31,thr3_loop_cnt_452
	dec %r31
	.word 0x862c29cc  ! 1: ANDN_I	andn 	%r16, 0x09cc, %r3
	.word 0x964425f9  ! 1: ADDC_I	addc 	%r16, 0x05f9, %r11
	.word 0xb8340002  ! 1: ORN_R	orn 	%r16, %r2, %r28
	.word 0x86342d2f  ! 1: ORN_I	orn 	%r16, 0x0d2f, %r3
        mov 0x60, %r31
thr3_loop_cnt_453:
	.word 0xd0542600  ! 1: LDSH_I	ldsh	[%r16 + 0x0600], %r8
	.word 0xc68c2115  ! 1: LDUBA_I	lduba	[%r16, + 0x0115] %asi, %r3
	.word 0xc6842c00  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c00] %asi, %r3
	.word 0xc6142a64  ! 1: LDUH_I	lduh	[%r16 + 0x0a64], %r3
	.word 0xc6042c28  ! 1: LDUW_I	lduw	[%r16 + 0x0c28], %r3
	.word 0xea542942  ! 1: LDSH_I	ldsh	[%r16 + 0x0942], %r21
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	brnz %r31,thr3_loop_cnt_453
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0xb7342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r27
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x863c2e74  ! 1: XNOR_I	xnor 	%r16, 0x0e74, %r3
        mov 0x5d, %r31
thr3_loop_cnt_454:
	.word 0xc614297e  ! 1: LDUH_I	lduh	[%r16 + 0x097e], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6842ee8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ee8] %asi, %r3
	.word 0xd0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r8
	.word 0xc6c42e7c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e7c] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r18
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xc6d42b3a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b3a] %asi, %r3
	.word 0xe48c2dee  ! 1: LDUBA_I	lduba	[%r16, + 0x0dee] %asi, %r18
	brnz %r31,thr3_loop_cnt_454
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0xb9340002  ! 1: SRL_R	srl 	%r16, %r2, %r28
        mov 0x93, %r31
thr3_loop_cnt_455:
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xe45c2c80  ! 1: LDX_I	ldx	[%r16 + 0x0c80], %r18
	.word 0xf0142bf4  ! 1: LDUH_I	lduh	[%r16 + 0x0bf4], %r24
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xe2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r17
	.word 0xc68c24dd  ! 1: LDUBA_I	lduba	[%r16, + 0x04dd] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd85c2778  ! 1: LDX_I	ldx	[%r16 + 0x0778], %r12
	brnz %r31,thr3_loop_cnt_455
	dec %r31
	.word 0xbc040002  ! 1: ADD_R	add 	%r16, %r2, %r30
        mov 0x2e, %r31
thr3_loop_cnt_456:
	.word 0xe4542ca4  ! 1: LDSH_I	ldsh	[%r16 + 0x0ca4], %r18
	.word 0xc68c2bed  ! 1: LDUBA_I	lduba	[%r16, + 0x0bed] %asi, %r3
	.word 0xf00c21af  ! 1: LDUB_I	ldub	[%r16 + 0x01af], %r24
	.word 0xf00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r24
	.word 0xdc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r14
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r12
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc69421dc  ! 1: LDUHA_I	lduha	[%r16, + 0x01dc] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r25
	brnz %r31,thr3_loop_cnt_456
	dec %r31
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x943425b6  ! 1: ORN_I	orn 	%r16, 0x05b6, %r10
        mov 0xb3, %r31
thr3_loop_cnt_457:
	.word 0xf2dc2898  ! 1: LDXA_I	ldxa	[%r16, + 0x0898] %asi, %r25
	.word 0xc6942e1a  ! 1: LDUHA_I	lduha	[%r16, + 0x0e1a] %asi, %r3
	.word 0xded423e2  ! 1: LDSHA_I	ldsha	[%r16, + 0x03e2] %asi, %r15
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd4542ca8  ! 1: LDSH_I	ldsh	[%r16 + 0x0ca8], %r10
	.word 0xfc442320  ! 1: LDSW_I	ldsw	[%r16 + 0x0320], %r30
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd6cc24b1  ! 1: LDSBA_I	ldsba	[%r16, + 0x04b1] %asi, %r11
	.word 0xc6d425c6  ! 1: LDSHA_I	ldsha	[%r16, + 0x05c6] %asi, %r3
	.word 0xec142a4c  ! 1: LDUH_I	lduh	[%r16 + 0x0a4c], %r22
	brnz %r31,thr3_loop_cnt_457
	dec %r31
	.word 0x932c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r9
        mov 0x1f, %r31
thr3_loop_cnt_458:
	.word 0xcc542b60  ! 1: LDSH_I	ldsh	[%r16 + 0x0b60], %r6
	.word 0xd20c2d21  ! 1: LDUB_I	ldub	[%r16 + 0x0d21], %r9
	.word 0xdedc2da8  ! 1: LDXA_I	ldxa	[%r16, + 0x0da8] %asi, %r15
	.word 0xde841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r15
	.word 0xf8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r28
	.word 0xc6d427f4  ! 1: LDSHA_I	ldsha	[%r16, + 0x07f4] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r27
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xfcc42750  ! 1: LDSWA_I	ldswa	[%r16, + 0x0750] %asi, %r30
	.word 0xe8942768  ! 1: LDUHA_I	lduha	[%r16, + 0x0768] %asi, %r20
	.word 0xd64c23bb  ! 1: LDSB_I	ldsb	[%r16 + 0x03bb], %r11
	brnz %r31,thr3_loop_cnt_458
	dec %r31
        mov 0x53, %r31
thr3_loop_cnt_459:
	.word 0xfc142db0  ! 1: LDUH_I	lduh	[%r16 + 0x0db0], %r30
	.word 0xc64428f8  ! 1: LDSW_I	ldsw	[%r16 + 0x08f8], %r3
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xda0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r13
	.word 0xc64c2107  ! 1: LDSB_I	ldsb	[%r16 + 0x0107], %r3
	.word 0xe8142504  ! 1: LDUH_I	lduh	[%r16 + 0x0504], %r20
	.word 0xf8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r28
	.word 0xf6c42bd4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0bd4] %asi, %r27
	.word 0xf8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r28
	.word 0xc64c2408  ! 1: LDSB_I	ldsb	[%r16 + 0x0408], %r3
	brnz %r31,thr3_loop_cnt_459
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0xa92c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r20
        mov 0x2a, %r31
thr3_loop_cnt_460:
	.word 0xc60c2c71  ! 1: LDUB_I	ldub	[%r16 + 0x0c71], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_460
	dec %r31
        mov 0x8, %r31
thr3_loop_cnt_461:
	.word 0xc64c25e1  ! 1: LDSB_I	ldsb	[%r16 + 0x05e1], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6c42800  ! 1: LDSWA_I	ldswa	[%r16, + 0x0800] %asi, %r3
	.word 0xf45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r26
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc61422fe  ! 1: LDUH_I	lduh	[%r16 + 0x02fe], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	brnz %r31,thr3_loop_cnt_461
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0x53, %r31
thr3_loop_cnt_462:
	.word 0xf4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r26
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd0542090  ! 1: LDSH_I	ldsh	[%r16 + 0x0090], %r8
	.word 0xc6cc21f2  ! 1: LDSBA_I	ldsba	[%r16, + 0x01f2] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xdc4c206b  ! 1: LDSB_I	ldsb	[%r16 + 0x006b], %r14
	.word 0xf4c42f1c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f1c] %asi, %r26
	.word 0xee841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r23
	.word 0xdc942806  ! 1: LDUHA_I	lduha	[%r16, + 0x0806] %asi, %r14
	brnz %r31,thr3_loop_cnt_462
	dec %r31
	.word 0x9d3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r14
	.word 0x86242009  ! 1: SUB_I	sub 	%r16, 0x0009, %r3
        mov 0x68, %r31
thr3_loop_cnt_463:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xee5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r23
	.word 0xc60c2aeb  ! 1: LDUB_I	ldub	[%r16 + 0x0aeb], %r3
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	.word 0xf85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r28
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xced425c4  ! 1: LDSHA_I	ldsha	[%r16, + 0x05c4] %asi, %r7
	.word 0xc64c24b3  ! 1: LDSB_I	ldsb	[%r16 + 0x04b3], %r3
	brnz %r31,thr3_loop_cnt_463
	dec %r31
	.word 0x8d2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r6
	.word 0xba2c21ed  ! 1: ANDN_I	andn 	%r16, 0x01ed, %r29
	.word 0x98040002  ! 1: ADD_R	add 	%r16, %r2, %r12
        mov 0x17, %r31
thr3_loop_cnt_464:
	.word 0xf0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r24
	.word 0xc6442028  ! 1: LDSW_I	ldsw	[%r16 + 0x0028], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd0842068  ! 1: LDUWA_I	lduwa	[%r16, + 0x0068] %asi, %r8
	.word 0xf0d42f26  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f26] %asi, %r24
	.word 0xe6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r19
	.word 0xd00c20f0  ! 1: LDUB_I	ldub	[%r16 + 0x00f0], %r8
	.word 0xced41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r7
	.word 0xe2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r17
	brnz %r31,thr3_loop_cnt_464
	dec %r31
        mov 0x70, %r31
thr3_loop_cnt_465:
	.word 0xee040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r23
	.word 0xce942386  ! 1: LDUHA_I	lduha	[%r16, + 0x0386] %asi, %r7
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xee14202e  ! 1: LDUH_I	lduh	[%r16 + 0x002e], %r23
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xc64c211d  ! 1: LDSB_I	ldsb	[%r16 + 0x011d], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r19
	brnz %r31,thr3_loop_cnt_465
	dec %r31
        mov 0x5b, %r31
thr3_loop_cnt_466:
	.word 0xe4dc2a30  ! 1: LDXA_I	ldxa	[%r16, + 0x0a30] %asi, %r18
	.word 0xd65c2068  ! 1: LDX_I	ldx	[%r16 + 0x0068], %r11
	.word 0xf60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r27
	.word 0xf0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r24
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xf44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r26
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xce0c27e4  ! 1: LDUB_I	ldub	[%r16 + 0x07e4], %r7
	.word 0xc68422a0  ! 1: LDUWA_I	lduwa	[%r16, + 0x02a0] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_466
	dec %r31
	.word 0x953c1002  ! 1: SRAX_R	srax	%r16, %r2, %r10
	.word 0x94440002  ! 1: ADDC_R	addc 	%r16, %r2, %r10
        mov 0xb3, %r31
thr3_loop_cnt_467:
	.word 0xc68426a4  ! 1: LDUWA_I	lduwa	[%r16, + 0x06a4] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc68424ac  ! 1: LDUWA_I	lduwa	[%r16, + 0x04ac] %asi, %r3
	.word 0xc6042b10  ! 1: LDUW_I	lduw	[%r16 + 0x0b10], %r3
	.word 0xda8422f8  ! 1: LDUWA_I	lduwa	[%r16, + 0x02f8] %asi, %r13
	.word 0xcc442a0c  ! 1: LDSW_I	ldsw	[%r16 + 0x0a0c], %r6
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc68c2beb  ! 1: LDUBA_I	lduba	[%r16, + 0x0beb] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_467
	dec %r31
	.word 0x9b3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r13
	.word 0x86242dde  ! 1: SUB_I	sub 	%r16, 0x0dde, %r3
	.word 0x9c442f2d  ! 1: ADDC_I	addc 	%r16, 0x0f2d, %r14
	.word 0x9f3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r15
        mov 0x74, %r31
thr3_loop_cnt_468:
	.word 0xc6cc2db3  ! 1: LDSBA_I	ldsba	[%r16, + 0x0db3] %asi, %r3
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	.word 0xc6442c08  ! 1: LDSW_I	ldsw	[%r16 + 0x0c08], %r3
	.word 0xc60c2f46  ! 1: LDUB_I	ldub	[%r16 + 0x0f46], %r3
	.word 0xee842d58  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d58] %asi, %r23
	.word 0xc604238c  ! 1: LDUW_I	lduw	[%r16 + 0x038c], %r3
	.word 0xd04c20a2  ! 1: LDSB_I	ldsb	[%r16 + 0x00a2], %r8
	.word 0xd4842198  ! 1: LDUWA_I	lduwa	[%r16, + 0x0198] %asi, %r10
	.word 0xc6942e4e  ! 1: LDUHA_I	lduha	[%r16, + 0x0e4e] %asi, %r3
	brnz %r31,thr3_loop_cnt_468
	dec %r31
	.word 0x86242225  ! 1: SUB_I	sub 	%r16, 0x0225, %r3
	.word 0x9a2c2dfd  ! 1: ANDN_I	andn 	%r16, 0x0dfd, %r13
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x8c, %r31
thr3_loop_cnt_469:
	.word 0xecdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r22
	.word 0xd6cc2577  ! 1: LDSBA_I	ldsba	[%r16, + 0x0577] %asi, %r11
	.word 0xc6dc2ea8  ! 1: LDXA_I	ldxa	[%r16, + 0x0ea8] %asi, %r3
	.word 0xf4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r26
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6542554  ! 1: LDSH_I	ldsh	[%r16 + 0x0554], %r3
	brnz %r31,thr3_loop_cnt_469
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x863422cd  ! 1: SUBC_I	orn 	%r16, 0x02cd, %r3
        mov 0xa7, %r31
thr3_loop_cnt_470:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6cc2cfd  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cfd] %asi, %r3
	.word 0xc64c2e2e  ! 1: LDSB_I	ldsb	[%r16 + 0x0e2e], %r3
	.word 0xc69423aa  ! 1: LDUHA_I	lduha	[%r16, + 0x03aa] %asi, %r3
	.word 0xc65c2d80  ! 1: LDX_I	ldx	[%r16 + 0x0d80], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xda0424e0  ! 1: LDUW_I	lduw	[%r16 + 0x04e0], %r13
	.word 0xd0542562  ! 1: LDSH_I	ldsh	[%r16 + 0x0562], %r8
	brnz %r31,thr3_loop_cnt_470
	dec %r31
	.word 0x86242e26  ! 1: SUB_I	sub 	%r16, 0x0e26, %r3
        mov 0x4b, %r31
thr3_loop_cnt_471:
	.word 0xc68c2362  ! 1: LDUBA_I	lduba	[%r16, + 0x0362] %asi, %r3
	.word 0xc64c247c  ! 1: LDSB_I	ldsb	[%r16 + 0x047c], %r3
	.word 0xc68c2534  ! 1: LDUBA_I	lduba	[%r16, + 0x0534] %asi, %r3
	.word 0xf80c20c2  ! 1: LDUB_I	ldub	[%r16 + 0x00c2], %r28
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xeac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r21
	.word 0xea142afc  ! 1: LDUH_I	lduh	[%r16 + 0x0afc], %r21
	.word 0xe8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r20
	.word 0xf8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r28
	.word 0xc60c22fe  ! 1: LDUB_I	ldub	[%r16 + 0x02fe], %r3
	brnz %r31,thr3_loop_cnt_471
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0xb6, %r31
thr3_loop_cnt_472:
	.word 0xd08c29fa  ! 1: LDUBA_I	lduba	[%r16, + 0x09fa] %asi, %r8
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xc65c29f0  ! 1: LDX_I	ldx	[%r16 + 0x09f0], %r3
	.word 0xd4c424bc  ! 1: LDSWA_I	ldswa	[%r16, + 0x04bc] %asi, %r10
	.word 0xc6c42dd4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0dd4] %asi, %r3
	.word 0xc614271a  ! 1: LDUH_I	lduh	[%r16 + 0x071a], %r3
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xd00c22f1  ! 1: LDUB_I	ldub	[%r16 + 0x02f1], %r8
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_472
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0xb, %r31
thr3_loop_cnt_473:
	.word 0xf41420d2  ! 1: LDUH_I	lduh	[%r16 + 0x00d2], %r26
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d4237e  ! 1: LDSHA_I	ldsha	[%r16, + 0x037e] %asi, %r3
	.word 0xc614211e  ! 1: LDUH_I	lduh	[%r16 + 0x011e], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xcc5c27c8  ! 1: LDX_I	ldx	[%r16 + 0x07c8], %r6
	.word 0xda540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r13
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc68c2089  ! 1: LDUBA_I	lduba	[%r16, + 0x0089] %asi, %r3
	.word 0xcc0c2208  ! 1: LDUB_I	ldub	[%r16 + 0x0208], %r6
	brnz %r31,thr3_loop_cnt_473
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x4f, %r31
thr3_loop_cnt_474:
	.word 0xe2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r17
	.word 0xc6dc2ed0  ! 1: LDXA_I	ldxa	[%r16, + 0x0ed0] %asi, %r3
	.word 0xc60c2dbb  ! 1: LDUB_I	ldub	[%r16 + 0x0dbb], %r3
	.word 0xf2942f36  ! 1: LDUHA_I	lduha	[%r16, + 0x0f36] %asi, %r25
	.word 0xd6042f68  ! 1: LDUW_I	lduw	[%r16 + 0x0f68], %r11
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xde542ada  ! 1: LDSH_I	ldsh	[%r16 + 0x0ada], %r15
	.word 0xe88c2a06  ! 1: LDUBA_I	lduba	[%r16, + 0x0a06] %asi, %r20
	.word 0xfa040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r29
	.word 0xd8cc299e  ! 1: LDSBA_I	ldsba	[%r16, + 0x099e] %asi, %r12
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xdc94228c  ! 1: LDUHA_I	lduha	[%r16, + 0x028c] %asi, %r14
	brnz %r31,thr3_loop_cnt_474
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0x57, %r31
thr3_loop_cnt_475:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r26
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xe60c2e1a  ! 1: LDUB_I	ldub	[%r16 + 0x0e1a], %r19
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6042968  ! 1: LDUW_I	lduw	[%r16 + 0x0968], %r3
	.word 0xec042ffc  ! 1: LDUW_I	lduw	[%r16 + 0x0ffc], %r22
	brnz %r31,thr3_loop_cnt_475
	dec %r31
	.word 0x960c0002  ! 1: AND_R	and 	%r16, %r2, %r11
	.word 0xa2140002  ! 1: OR_R	or 	%r16, %r2, %r17
	.word 0x99340002  ! 1: SRL_R	srl 	%r16, %r2, %r12
	.word 0x8c440002  ! 1: ADDC_R	addc 	%r16, %r2, %r6
        mov 0x77, %r31
thr3_loop_cnt_476:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6dc2468  ! 1: LDXA_I	ldxa	[%r16, + 0x0468] %asi, %r3
	.word 0xf4d421d0  ! 1: LDSHA_I	ldsha	[%r16, + 0x01d0] %asi, %r26
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xdc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r14
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd8c42fe4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0fe4] %asi, %r12
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xd8dc2fa8  ! 1: LDXA_I	ldxa	[%r16, + 0x0fa8] %asi, %r12
	brnz %r31,thr3_loop_cnt_476
	dec %r31
	.word 0x864424ad  ! 1: ADDC_I	addc 	%r16, 0x04ad, %r3
	.word 0x983c296f  ! 1: XNOR_I	xnor 	%r16, 0x096f, %r12
	.word 0x972c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r11
	.word 0x942c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r10
        mov 0x5, %r31
thr3_loop_cnt_477:
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xeed41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r23
	.word 0xc64c267f  ! 1: LDSB_I	ldsb	[%r16 + 0x067f], %r3
	.word 0xe6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r19
	.word 0xd4c426a8  ! 1: LDSWA_I	ldswa	[%r16, + 0x06a8] %asi, %r10
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xfad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r29
	.word 0xc6cc2ef0  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ef0] %asi, %r3
	.word 0xf0c426d8  ! 1: LDSWA_I	ldswa	[%r16, + 0x06d8] %asi, %r24
	.word 0xcc8c221b  ! 1: LDUBA_I	lduba	[%r16, + 0x021b] %asi, %r6
	.word 0xea1425c2  ! 1: LDUH_I	lduh	[%r16 + 0x05c2], %r21
	brnz %r31,thr3_loop_cnt_477
	dec %r31
	.word 0x943c2d29  ! 1: XNOR_I	xnor 	%r16, 0x0d29, %r10
        mov 0x24, %r31
thr3_loop_cnt_478:
	.word 0xee4c228b  ! 1: LDSB_I	ldsb	[%r16 + 0x028b], %r23
	.word 0xfc542426  ! 1: LDSH_I	ldsh	[%r16 + 0x0426], %r30
	.word 0xd8542e70  ! 1: LDSH_I	ldsh	[%r16 + 0x0e70], %r12
	.word 0xda1425c6  ! 1: LDUH_I	lduh	[%r16 + 0x05c6], %r13
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	.word 0xc6d42eb0  ! 1: LDSHA_I	ldsha	[%r16, + 0x0eb0] %asi, %r3
	.word 0xec0c21ec  ! 1: LDUB_I	ldub	[%r16 + 0x01ec], %r22
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd2842aac  ! 1: LDUWA_I	lduwa	[%r16, + 0x0aac] %asi, %r9
	brnz %r31,thr3_loop_cnt_478
	dec %r31
	.word 0x93342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r9
	.word 0xb03c2d66  ! 1: XNOR_I	xnor 	%r16, 0x0d66, %r24
	.word 0xac2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r22
	.word 0x863c2a7b  ! 1: XNOR_I	xnor 	%r16, 0x0a7b, %r3
        mov 0x88, %r31
thr3_loop_cnt_479:
	.word 0xc6d421fc  ! 1: LDSHA_I	ldsha	[%r16, + 0x01fc] %asi, %r3
	.word 0xc6042730  ! 1: LDUW_I	lduw	[%r16 + 0x0730], %r3
	.word 0xfa841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r29
	.word 0xc68c219d  ! 1: LDUBA_I	lduba	[%r16, + 0x019d] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xe4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r18
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2076  ! 1: LDSBA_I	ldsba	[%r16, + 0x0076] %asi, %r3
	.word 0xc64c29e3  ! 1: LDSB_I	ldsb	[%r16 + 0x09e3], %r3
	.word 0xc6cc2b6a  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b6a] %asi, %r3
	.word 0xc684258c  ! 1: LDUWA_I	lduwa	[%r16, + 0x058c] %asi, %r3
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	brnz %r31,thr3_loop_cnt_479
	dec %r31
	.word 0xbb343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r29
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0x61, %r31
thr3_loop_cnt_480:
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xde140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r15
	.word 0xcc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r6
	.word 0xc64c219d  ! 1: LDSB_I	ldsb	[%r16 + 0x019d], %r3
	.word 0xf0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r24
	.word 0xd68c274e  ! 1: LDUBA_I	lduba	[%r16, + 0x074e] %asi, %r11
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_480
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x86042fff  ! 1: ADD_I	add 	%r16, 0x0fff, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0xb8, %r31
thr3_loop_cnt_481:
	.word 0xf0cc2bbc  ! 1: LDSBA_I	ldsba	[%r16, + 0x0bbc] %asi, %r24
	.word 0xfccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r30
	.word 0xd00420bc  ! 1: LDUW_I	lduw	[%r16 + 0x00bc], %r8
	.word 0xd44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r10
	.word 0xf65c2538  ! 1: LDX_I	ldx	[%r16 + 0x0538], %r27
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc64c26dd  ! 1: LDSB_I	ldsb	[%r16 + 0x06dd], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_481
	dec %r31
	.word 0x9e140002  ! 1: OR_R	or 	%r16, %r2, %r15
        mov 0x90, %r31
thr3_loop_cnt_482:
	.word 0xc64c235e  ! 1: LDSB_I	ldsb	[%r16 + 0x035e], %r3
	.word 0xce8c20e9  ! 1: LDUBA_I	lduba	[%r16, + 0x00e9] %asi, %r7
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6442794  ! 1: LDSW_I	ldsw	[%r16 + 0x0794], %r3
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xfa5c2da8  ! 1: LDX_I	ldx	[%r16 + 0x0da8], %r29
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xec040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r22
	brnz %r31,thr3_loop_cnt_482
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x35, %r31
thr3_loop_cnt_483:
	.word 0xd4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r10
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	.word 0xde140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r15
	.word 0xc6542ac4  ! 1: LDSH_I	ldsh	[%r16 + 0x0ac4], %r3
	.word 0xe4842e38  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e38] %asi, %r18
	.word 0xc6d4298c  ! 1: LDSHA_I	ldsha	[%r16, + 0x098c] %asi, %r3
	.word 0xead41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r21
	.word 0xfa841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r29
	.word 0xd65c2fc8  ! 1: LDX_I	ldx	[%r16 + 0x0fc8], %r11
	brnz %r31,thr3_loop_cnt_483
	dec %r31
	.word 0x98040002  ! 1: ADD_R	add 	%r16, %r2, %r12
	.word 0x9c3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r14
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0xb6, %r31
thr3_loop_cnt_484:
	.word 0xc6542d34  ! 1: LDSH_I	ldsh	[%r16 + 0x0d34], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r8
	.word 0xf48c25d6  ! 1: LDUBA_I	lduba	[%r16, + 0x05d6] %asi, %r26
	.word 0xc6942402  ! 1: LDUHA_I	lduha	[%r16, + 0x0402] %asi, %r3
	.word 0xe85423c6  ! 1: LDSH_I	ldsh	[%r16 + 0x03c6], %r20
	.word 0xfa941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r29
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf65c29d8  ! 1: LDX_I	ldx	[%r16 + 0x09d8], %r27
	brnz %r31,thr3_loop_cnt_484
	dec %r31
	.word 0x86342091  ! 1: SUBC_I	orn 	%r16, 0x0091, %r3
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x92040002  ! 1: ADD_R	add 	%r16, %r2, %r9
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x6f, %r31
thr3_loop_cnt_485:
	.word 0xc68c228b  ! 1: LDUBA_I	lduba	[%r16, + 0x028b] %asi, %r3
	.word 0xc6542a9a  ! 1: LDSH_I	ldsh	[%r16 + 0x0a9a], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf8dc2860  ! 1: LDXA_I	ldxa	[%r16, + 0x0860] %asi, %r28
	.word 0xd68c29ee  ! 1: LDUBA_I	lduba	[%r16, + 0x09ee] %asi, %r11
	.word 0xc6d4297a  ! 1: LDSHA_I	ldsha	[%r16, + 0x097a] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd4542c3c  ! 1: LDSH_I	ldsh	[%r16 + 0x0c3c], %r10
	.word 0xd4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r10
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	brnz %r31,thr3_loop_cnt_485
	dec %r31
	.word 0xb9343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r28
	.word 0x9e3c2746  ! 1: XNOR_I	xnor 	%r16, 0x0746, %r15
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0xc4, %r31
thr3_loop_cnt_486:
	.word 0xc6542a9c  ! 1: LDSH_I	ldsh	[%r16 + 0x0a9c], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf2542b82  ! 1: LDSH_I	ldsh	[%r16 + 0x0b82], %r25
	.word 0xcc14237a  ! 1: LDUH_I	lduh	[%r16 + 0x037a], %r6
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6142144  ! 1: LDUH_I	lduh	[%r16 + 0x0144], %r3
	.word 0xcc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r6
	brnz %r31,thr3_loop_cnt_486
	dec %r31
	.word 0x92440002  ! 1: ADDC_R	addc 	%r16, %r2, %r9
	.word 0xb83c277d  ! 1: XNOR_I	xnor 	%r16, 0x077d, %r28
        mov 0x52, %r31
thr3_loop_cnt_487:
	.word 0xc60429b4  ! 1: LDUW_I	lduw	[%r16 + 0x09b4], %r3
	.word 0xe2dc2c30  ! 1: LDXA_I	ldxa	[%r16, + 0x0c30] %asi, %r17
	.word 0xfcdc2d70  ! 1: LDXA_I	ldxa	[%r16, + 0x0d70] %asi, %r30
	.word 0xec8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r22
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xea842c88  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c88] %asi, %r21
	.word 0xe65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r19
	.word 0xdadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r13
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_487
	dec %r31
	.word 0xb13c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r24
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0xa80c0002  ! 1: AND_R	and 	%r16, %r2, %r20
        mov 0xd, %r31
thr3_loop_cnt_488:
	.word 0xd48424a8  ! 1: LDUWA_I	lduwa	[%r16, + 0x04a8] %asi, %r10
	.word 0xdcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r14
	.word 0xd65c2b70  ! 1: LDX_I	ldx	[%r16 + 0x0b70], %r11
	.word 0xc64c2694  ! 1: LDSB_I	ldsb	[%r16 + 0x0694], %r3
	.word 0xd60429d8  ! 1: LDUW_I	lduw	[%r16 + 0x09d8], %r11
	.word 0xc614270e  ! 1: LDUH_I	lduh	[%r16 + 0x070e], %r3
	.word 0xc614230a  ! 1: LDUH_I	lduh	[%r16 + 0x030a], %r3
	.word 0xc64c2351  ! 1: LDSB_I	ldsb	[%r16 + 0x0351], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xda542f98  ! 1: LDSH_I	ldsh	[%r16 + 0x0f98], %r13
	brnz %r31,thr3_loop_cnt_488
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x9a342af2  ! 1: ORN_I	orn 	%r16, 0x0af2, %r13
        mov 0x1d, %r31
thr3_loop_cnt_489:
	.word 0xc60c2d1c  ! 1: LDUB_I	ldub	[%r16 + 0x0d1c], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6c42be8  ! 1: LDSWA_I	ldswa	[%r16, + 0x0be8] %asi, %r3
	.word 0xc68c2ca9  ! 1: LDUBA_I	lduba	[%r16, + 0x0ca9] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6542af6  ! 1: LDSH_I	ldsh	[%r16 + 0x0af6], %r3
	.word 0xea140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r21
	.word 0xc6dc2758  ! 1: LDXA_I	ldxa	[%r16, + 0x0758] %asi, %r3
	brnz %r31,thr3_loop_cnt_489
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x29, %r31
thr3_loop_cnt_490:
	.word 0xd04422b8  ! 1: LDSW_I	ldsw	[%r16 + 0x02b8], %r8
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6442078  ! 1: LDSW_I	ldsw	[%r16 + 0x0078], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd8d42c5c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c5c] %asi, %r12
	.word 0xdacc229b  ! 1: LDSBA_I	ldsba	[%r16, + 0x029b] %asi, %r13
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xeccc20f4  ! 1: LDSBA_I	ldsba	[%r16, + 0x00f4] %asi, %r22
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_490
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0xb1, %r31
thr3_loop_cnt_491:
	.word 0xc69426fc  ! 1: LDUHA_I	lduha	[%r16, + 0x06fc] %asi, %r3
	.word 0xc6cc29e1  ! 1: LDSBA_I	ldsba	[%r16, + 0x09e1] %asi, %r3
	.word 0xc60c2dea  ! 1: LDUB_I	ldub	[%r16 + 0x0dea], %r3
	.word 0xc6cc2888  ! 1: LDSBA_I	ldsba	[%r16, + 0x0888] %asi, %r3
	.word 0xc60c2042  ! 1: LDUB_I	ldub	[%r16 + 0x0042], %r3
	.word 0xc6c42cd8  ! 1: LDSWA_I	ldswa	[%r16, + 0x0cd8] %asi, %r3
	.word 0xe84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r20
	.word 0xc69422a0  ! 1: LDUHA_I	lduha	[%r16, + 0x02a0] %asi, %r3
	.word 0xdc8c2f6c  ! 1: LDUBA_I	lduba	[%r16, + 0x0f6c] %asi, %r14
	brnz %r31,thr3_loop_cnt_491
	dec %r31
	.word 0x98340002  ! 1: ORN_R	orn 	%r16, %r2, %r12
	.word 0xab2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r21
	.word 0x8e3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r7
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x97, %r31
thr3_loop_cnt_492:
	.word 0xf0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r24
	.word 0xf844270c  ! 1: LDSW_I	ldsw	[%r16 + 0x070c], %r28
	.word 0xd6442ad4  ! 1: LDSW_I	ldsw	[%r16 + 0x0ad4], %r11
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf2042f88  ! 1: LDUW_I	lduw	[%r16 + 0x0f88], %r25
	.word 0xee5c2600  ! 1: LDX_I	ldx	[%r16 + 0x0600], %r23
	.word 0xc604239c  ! 1: LDUW_I	lduw	[%r16 + 0x039c], %r3
	.word 0xfa8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r29
	.word 0xcc542998  ! 1: LDSH_I	ldsh	[%r16 + 0x0998], %r6
	.word 0xc6942070  ! 1: LDUHA_I	lduha	[%r16, + 0x0070] %asi, %r3
	.word 0xee0c221a  ! 1: LDUB_I	ldub	[%r16 + 0x021a], %r23
	brnz %r31,thr3_loop_cnt_492
	dec %r31
	.word 0x900c0002  ! 1: AND_R	and 	%r16, %r2, %r8
	.word 0x9e340002  ! 1: SUBC_R	orn 	%r16, %r2, %r15
        mov 0x83, %r31
thr3_loop_cnt_493:
	.word 0xc6cc23ae  ! 1: LDSBA_I	ldsba	[%r16, + 0x03ae] %asi, %r3
	.word 0xc60c24ac  ! 1: LDUB_I	ldub	[%r16 + 0x04ac], %r3
	.word 0xf0c429c4  ! 1: LDSWA_I	ldswa	[%r16, + 0x09c4] %asi, %r24
	.word 0xe84c2c53  ! 1: LDSB_I	ldsb	[%r16 + 0x0c53], %r20
	.word 0xccc42100  ! 1: LDSWA_I	ldswa	[%r16, + 0x0100] %asi, %r6
	.word 0xcc442948  ! 1: LDSW_I	ldsw	[%r16 + 0x0948], %r6
	.word 0xfc8c2824  ! 1: LDUBA_I	lduba	[%r16, + 0x0824] %asi, %r30
	.word 0xe4d4297c  ! 1: LDSHA_I	ldsha	[%r16, + 0x097c] %asi, %r18
	.word 0xd6c4259c  ! 1: LDSWA_I	ldswa	[%r16, + 0x059c] %asi, %r11
	brnz %r31,thr3_loop_cnt_493
	dec %r31
	.word 0x86042121  ! 1: ADD_I	add 	%r16, 0x0121, %r3
	.word 0xa92c0002  ! 1: SLL_R	sll 	%r16, %r2, %r20
        mov 0x5c, %r31
thr3_loop_cnt_494:
	.word 0xc60421b4  ! 1: LDUW_I	lduw	[%r16 + 0x01b4], %r3
	.word 0xf6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r27
	.word 0xd60c2f1e  ! 1: LDUB_I	ldub	[%r16 + 0x0f1e], %r11
	.word 0xc6842b18  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b18] %asi, %r3
	.word 0xc60c2e1e  ! 1: LDUB_I	ldub	[%r16 + 0x0e1e], %r3
	.word 0xc6042cc4  ! 1: LDUW_I	lduw	[%r16 + 0x0cc4], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6442180  ! 1: LDSW_I	ldsw	[%r16 + 0x0180], %r3
	.word 0xd4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r10
	.word 0xc68c2f45  ! 1: LDUBA_I	lduba	[%r16, + 0x0f45] %asi, %r3
	.word 0xc6d42f24  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f24] %asi, %r3
	brnz %r31,thr3_loop_cnt_494
	dec %r31
	.word 0xa2342d7e  ! 1: ORN_I	orn 	%r16, 0x0d7e, %r17
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0xae142dad  ! 1: OR_I	or 	%r16, 0x0dad, %r23
        mov 0x73, %r31
thr3_loop_cnt_495:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d42776  ! 1: LDSHA_I	ldsha	[%r16, + 0x0776] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2a58  ! 1: LDXA_I	ldxa	[%r16, + 0x0a58] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r27
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xdecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r15
	.word 0xdc1429a6  ! 1: LDUH_I	lduh	[%r16 + 0x09a6], %r14
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_495
	dec %r31
	.word 0x8c4428d5  ! 1: ADDC_I	addc 	%r16, 0x08d5, %r6
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x3b, %r31
thr3_loop_cnt_496:
	.word 0xda1428c0  ! 1: LDUH_I	lduh	[%r16 + 0x08c0], %r13
	.word 0xce4c2ec4  ! 1: LDSB_I	ldsb	[%r16 + 0x0ec4], %r7
	.word 0xccd425f4  ! 1: LDSHA_I	ldsha	[%r16, + 0x05f4] %asi, %r6
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd8942ab2  ! 1: LDUHA_I	lduha	[%r16, + 0x0ab2] %asi, %r12
	.word 0xeacc2126  ! 1: LDSBA_I	ldsba	[%r16, + 0x0126] %asi, %r21
	.word 0xf2cc267f  ! 1: LDSBA_I	ldsba	[%r16, + 0x067f] %asi, %r25
	.word 0xdcc42494  ! 1: LDSWA_I	ldswa	[%r16, + 0x0494] %asi, %r14
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd80c2d95  ! 1: LDUB_I	ldub	[%r16 + 0x0d95], %r12
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_496
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0xa2340002  ! 1: ORN_R	orn 	%r16, %r2, %r17
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0x10, %r31
thr3_loop_cnt_497:
	.word 0xe68429dc  ! 1: LDUWA_I	lduwa	[%r16, + 0x09dc] %asi, %r19
	.word 0xee442af8  ! 1: LDSW_I	ldsw	[%r16 + 0x0af8], %r23
	.word 0xde0c2407  ! 1: LDUB_I	ldub	[%r16 + 0x0407], %r15
	.word 0xfc04238c  ! 1: LDUW_I	lduw	[%r16 + 0x038c], %r30
	.word 0xc6d426f2  ! 1: LDSHA_I	ldsha	[%r16, + 0x06f2] %asi, %r3
	.word 0xf8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r28
	.word 0xe4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r18
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc68421a4  ! 1: LDUWA_I	lduwa	[%r16, + 0x01a4] %asi, %r3
	.word 0xf8c42d3c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d3c] %asi, %r28
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_497
	dec %r31
	.word 0x98340002  ! 1: SUBC_R	orn 	%r16, %r2, %r12
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0x92, %r31
thr3_loop_cnt_498:
	.word 0xf24420c0  ! 1: LDSW_I	ldsw	[%r16 + 0x00c0], %r25
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r26
	.word 0xd0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r8
	.word 0xc68c202f  ! 1: LDUBA_I	lduba	[%r16, + 0x002f] %asi, %r3
	.word 0xec842900  ! 1: LDUWA_I	lduwa	[%r16, + 0x0900] %asi, %r22
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	.word 0xd4542036  ! 1: LDSH_I	ldsh	[%r16 + 0x0036], %r10
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xee94213a  ! 1: LDUHA_I	lduha	[%r16, + 0x013a] %asi, %r23
	.word 0xd2142ba0  ! 1: LDUH_I	lduh	[%r16 + 0x0ba0], %r9
	brnz %r31,thr3_loop_cnt_498
	dec %r31
        mov 0x72, %r31
thr3_loop_cnt_499:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xee8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r23
	.word 0xf0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r24
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xd0442830  ! 1: LDSW_I	ldsw	[%r16 + 0x0830], %r8
	brnz %r31,thr3_loop_cnt_499
	dec %r31
	.word 0x8f2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r7
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x31, %r31
thr3_loop_cnt_500:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd004253c  ! 1: LDUW_I	lduw	[%r16 + 0x053c], %r8
	.word 0xcc5c20a8  ! 1: LDX_I	ldx	[%r16 + 0x00a8], %r6
	.word 0xfa94218c  ! 1: LDUHA_I	lduha	[%r16, + 0x018c] %asi, %r29
	.word 0xc6842ab4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ab4] %asi, %r3
	.word 0xf88c2855  ! 1: LDUBA_I	lduba	[%r16, + 0x0855] %asi, %r28
	.word 0xda540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r13
	.word 0xc6c42a44  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a44] %asi, %r3
	brnz %r31,thr3_loop_cnt_500
	dec %r31
	.word 0x9c342456  ! 1: ORN_I	orn 	%r16, 0x0456, %r14
	.word 0xb63c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r27
	.word 0x912c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r8
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0x21, %r31
thr3_loop_cnt_501:
	.word 0xde942a70  ! 1: LDUHA_I	lduha	[%r16, + 0x0a70] %asi, %r15
	.word 0xe88c2b24  ! 1: LDUBA_I	lduba	[%r16, + 0x0b24] %asi, %r20
	.word 0xeacc2c0a  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c0a] %asi, %r21
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xce842f8c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f8c] %asi, %r7
	.word 0xfc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r30
	.word 0xc65c2ef0  ! 1: LDX_I	ldx	[%r16 + 0x0ef0], %r3
	.word 0xe8142840  ! 1: LDUH_I	lduh	[%r16 + 0x0840], %r20
	.word 0xc64424bc  ! 1: LDSW_I	ldsw	[%r16 + 0x04bc], %r3
	.word 0xd64c20eb  ! 1: LDSB_I	ldsb	[%r16 + 0x00eb], %r11
	.word 0xc64c270a  ! 1: LDSB_I	ldsb	[%r16 + 0x070a], %r3
	brnz %r31,thr3_loop_cnt_501
	dec %r31
        mov 0x8b, %r31
thr3_loop_cnt_502:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6cc2b5b  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b5b] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xfcd42870  ! 1: LDSHA_I	ldsha	[%r16, + 0x0870] %asi, %r30
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_502
	dec %r31
        mov 0xae, %r31
thr3_loop_cnt_503:
	.word 0xf85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r28
	.word 0xd84c2557  ! 1: LDSB_I	ldsb	[%r16 + 0x0557], %r12
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6d42a2a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a2a] %asi, %r3
	.word 0xcc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r6
	.word 0xeecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r23
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc65c2d60  ! 1: LDX_I	ldx	[%r16 + 0x0d60], %r3
	.word 0xea8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r21
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_503
	dec %r31
	.word 0xa52c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r18
	.word 0xaa442594  ! 1: ADDC_I	addc 	%r16, 0x0594, %r21
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0xbe, %r31
thr3_loop_cnt_504:
	.word 0xf2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r25
	.word 0xc69429f8  ! 1: LDUHA_I	lduha	[%r16, + 0x09f8] %asi, %r3
	.word 0xd8842ee0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ee0] %asi, %r12
	.word 0xf4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r26
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd28423c8  ! 1: LDUWA_I	lduwa	[%r16, + 0x03c8] %asi, %r9
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	brnz %r31,thr3_loop_cnt_504
	dec %r31
	.word 0xa22c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r17
	.word 0xbc2c20ff  ! 1: ANDN_I	andn 	%r16, 0x00ff, %r30
	.word 0xac140002  ! 1: OR_R	or 	%r16, %r2, %r22
        mov 0x3f, %r31
thr3_loop_cnt_505:
	.word 0xd094278c  ! 1: LDUHA_I	lduha	[%r16, + 0x078c] %asi, %r8
	.word 0xf2dc23c8  ! 1: LDXA_I	ldxa	[%r16, + 0x03c8] %asi, %r25
	.word 0xf45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r26
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xf6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r27
	.word 0xc68c203d  ! 1: LDUBA_I	lduba	[%r16, + 0x003d] %asi, %r3
	.word 0xe8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r20
	.word 0xc68425ec  ! 1: LDUWA_I	lduwa	[%r16, + 0x05ec] %asi, %r3
	.word 0xf28c25bc  ! 1: LDUBA_I	lduba	[%r16, + 0x05bc] %asi, %r25
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xda941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r13
	brnz %r31,thr3_loop_cnt_505
	dec %r31
	.word 0x963423d7  ! 1: SUBC_I	orn 	%r16, 0x03d7, %r11
        mov 0x7a, %r31
thr3_loop_cnt_506:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r27
	.word 0xee042a44  ! 1: LDUW_I	lduw	[%r16 + 0x0a44], %r23
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r9
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc68c2855  ! 1: LDUBA_I	lduba	[%r16, + 0x0855] %asi, %r3
	.word 0xc6cc2b6e  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b6e] %asi, %r3
	.word 0xe41429a2  ! 1: LDUH_I	lduh	[%r16 + 0x09a2], %r18
	.word 0xd28c2e70  ! 1: LDUBA_I	lduba	[%r16, + 0x0e70] %asi, %r9
	.word 0xd04c293c  ! 1: LDSB_I	ldsb	[%r16 + 0x093c], %r8
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	brnz %r31,thr3_loop_cnt_506
	dec %r31
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x98340002  ! 1: SUBC_R	orn 	%r16, %r2, %r12
	.word 0x860427b3  ! 1: ADD_I	add 	%r16, 0x07b3, %r3
        mov 0x67, %r31
thr3_loop_cnt_507:
	.word 0xde54208e  ! 1: LDSH_I	ldsh	[%r16 + 0x008e], %r15
	.word 0xf48c2087  ! 1: LDUBA_I	lduba	[%r16, + 0x0087] %asi, %r26
	.word 0xd8542cf0  ! 1: LDSH_I	ldsh	[%r16 + 0x0cf0], %r12
	.word 0xe25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r17
	.word 0xea0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r21
	.word 0xc6cc2224  ! 1: LDSBA_I	ldsba	[%r16, + 0x0224] %asi, %r3
	.word 0xc6542700  ! 1: LDSH_I	ldsh	[%r16 + 0x0700], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xf44c2a3f  ! 1: LDSB_I	ldsb	[%r16 + 0x0a3f], %r26
	brnz %r31,thr3_loop_cnt_507
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x28, %r31
thr3_loop_cnt_508:
	.word 0xc65c27f0  ! 1: LDX_I	ldx	[%r16 + 0x07f0], %r3
	.word 0xda440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r13
	.word 0xf25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r25
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	.word 0xd8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r12
	.word 0xf8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r28
	.word 0xc6042100  ! 1: LDUW_I	lduw	[%r16 + 0x0100], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xe4dc2a70  ! 1: LDXA_I	ldxa	[%r16, + 0x0a70] %asi, %r18
	.word 0xc64c25c0  ! 1: LDSB_I	ldsb	[%r16 + 0x05c0], %r3
	.word 0xd45c2b78  ! 1: LDX_I	ldx	[%r16 + 0x0b78], %r10
	.word 0xfcdc2d70  ! 1: LDXA_I	ldxa	[%r16, + 0x0d70] %asi, %r30
	brnz %r31,thr3_loop_cnt_508
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x86342f32  ! 1: ORN_I	orn 	%r16, 0x0f32, %r3
        mov 0xa0, %r31
thr3_loop_cnt_509:
	.word 0xe2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r17
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2bb0  ! 1: LDXA_I	ldxa	[%r16, + 0x0bb0] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6842a5c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a5c] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xc65c27b8  ! 1: LDX_I	ldx	[%r16 + 0x07b8], %r3
	.word 0xc6042848  ! 1: LDUW_I	lduw	[%r16 + 0x0848], %r3
	brnz %r31,thr3_loop_cnt_509
	dec %r31
	.word 0x860c24b7  ! 1: AND_I	and 	%r16, 0x04b7, %r3
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0xb0042e81  ! 1: ADD_I	add 	%r16, 0x0e81, %r24
        mov 0xb9, %r31
thr3_loop_cnt_510:
	.word 0xc6142d36  ! 1: LDUH_I	lduh	[%r16 + 0x0d36], %r3
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xf2cc235a  ! 1: LDSBA_I	ldsba	[%r16, + 0x035a] %asi, %r25
	.word 0xc6042b5c  ! 1: LDUW_I	lduw	[%r16 + 0x0b5c], %r3
	.word 0xe484289c  ! 1: LDUWA_I	lduwa	[%r16, + 0x089c] %asi, %r18
	.word 0xded428d2  ! 1: LDSHA_I	ldsha	[%r16, + 0x08d2] %asi, %r15
	.word 0xee942188  ! 1: LDUHA_I	lduha	[%r16, + 0x0188] %asi, %r23
	.word 0xee5c2498  ! 1: LDX_I	ldx	[%r16 + 0x0498], %r23
	.word 0xc6042200  ! 1: LDUW_I	lduw	[%r16 + 0x0200], %r3
	brnz %r31,thr3_loop_cnt_510
	dec %r31
	.word 0x940c0002  ! 1: AND_R	and 	%r16, %r2, %r10
	.word 0x942c2134  ! 1: ANDN_I	andn 	%r16, 0x0134, %r10
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x9e1c0002  ! 1: XOR_R	xor 	%r16, %r2, %r15
        mov 0x37, %r31
thr3_loop_cnt_511:
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xfcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r30
	.word 0xc6cc2de5  ! 1: LDSBA_I	ldsba	[%r16, + 0x0de5] %asi, %r3
	.word 0xf6842ea0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ea0] %asi, %r27
	.word 0xf25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r25
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r10
	.word 0xc6cc25ca  ! 1: LDSBA_I	ldsba	[%r16, + 0x05ca] %asi, %r3
	.word 0xc6042bc0  ! 1: LDUW_I	lduw	[%r16 + 0x0bc0], %r3
	brnz %r31,thr3_loop_cnt_511
	dec %r31
	.word 0x862c2232  ! 1: ANDN_I	andn 	%r16, 0x0232, %r3
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0xa4240002  ! 1: SUB_R	sub 	%r16, %r2, %r18
        mov 0x15, %r31
thr3_loop_cnt_512:
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	.word 0xf6142e5e  ! 1: LDUH_I	lduh	[%r16 + 0x0e5e], %r27
	.word 0xf6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r27
	.word 0xfa8c22a5  ! 1: LDUBA_I	lduba	[%r16, + 0x02a5] %asi, %r29
	.word 0xdadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r13
	.word 0xc6cc24e1  ! 1: LDSBA_I	ldsba	[%r16, + 0x04e1] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc64c23ab  ! 1: LDSB_I	ldsb	[%r16 + 0x03ab], %r3
	.word 0xd20c2f06  ! 1: LDUB_I	ldub	[%r16 + 0x0f06], %r9
	.word 0xf6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r27
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_512
	dec %r31
	.word 0x8c3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r6
	.word 0x9a440002  ! 1: ADDC_R	addc 	%r16, %r2, %r13
        mov 0x37, %r31
thr3_loop_cnt_513:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xe4942bf0  ! 1: LDUHA_I	lduha	[%r16, + 0x0bf0] %asi, %r18
	.word 0xe6042c84  ! 1: LDUW_I	lduw	[%r16 + 0x0c84], %r19
	.word 0xc65c24a8  ! 1: LDX_I	ldx	[%r16 + 0x04a8], %r3
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xec5c25d8  ! 1: LDX_I	ldx	[%r16 + 0x05d8], %r22
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc64c27d4  ! 1: LDSB_I	ldsb	[%r16 + 0x07d4], %r3
	.word 0xe2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r17
	brnz %r31,thr3_loop_cnt_513
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x91342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r8
	.word 0xb61c21ce  ! 1: XOR_I	xor 	%r16, 0x01ce, %r27
	.word 0xa82c230c  ! 1: ANDN_I	andn 	%r16, 0x030c, %r20
        mov 0xb9, %r31
thr3_loop_cnt_514:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6942870  ! 1: LDUHA_I	lduha	[%r16, + 0x0870] %asi, %r3
	.word 0xf8d420b2  ! 1: LDSHA_I	ldsha	[%r16, + 0x00b2] %asi, %r28
	.word 0xf0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r24
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe8cc214f  ! 1: LDSBA_I	ldsba	[%r16, + 0x014f] %asi, %r20
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r28
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xea8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r21
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xcc8c2af8  ! 1: LDUBA_I	lduba	[%r16, + 0x0af8] %asi, %r6
	brnz %r31,thr3_loop_cnt_514
	dec %r31
	.word 0x99340002  ! 1: SRL_R	srl 	%r16, %r2, %r12
	.word 0xba142605  ! 1: OR_I	or 	%r16, 0x0605, %r29
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x8c, %r31
thr3_loop_cnt_515:
	.word 0xd2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r9
	.word 0xc6942c9e  ! 1: LDUHA_I	lduha	[%r16, + 0x0c9e] %asi, %r3
	.word 0xf4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r26
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6cc210d  ! 1: LDSBA_I	ldsba	[%r16, + 0x010d] %asi, %r3
	.word 0xd0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r8
	.word 0xe4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r18
	.word 0xf4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r26
	.word 0xf05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r24
	.word 0xfccc2230  ! 1: LDSBA_I	ldsba	[%r16, + 0x0230] %asi, %r30
	brnz %r31,thr3_loop_cnt_515
	dec %r31
        mov 0x6d, %r31
thr3_loop_cnt_516:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xce942d00  ! 1: LDUHA_I	lduha	[%r16, + 0x0d00] %asi, %r7
	.word 0xc6cc2937  ! 1: LDSBA_I	ldsba	[%r16, + 0x0937] %asi, %r3
	.word 0xc6042684  ! 1: LDUW_I	lduw	[%r16 + 0x0684], %r3
	.word 0xf80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r28
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	.word 0xccdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r6
	brnz %r31,thr3_loop_cnt_516
	dec %r31
        mov 0x93, %r31
thr3_loop_cnt_517:
	.word 0xd40c2d01  ! 1: LDUB_I	ldub	[%r16 + 0x0d01], %r10
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r25
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd6d42d08  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d08] %asi, %r11
	.word 0xea4423fc  ! 1: LDSW_I	ldsw	[%r16 + 0x03fc], %r21
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6942c3a  ! 1: LDUHA_I	lduha	[%r16, + 0x0c3a] %asi, %r3
	.word 0xee8c2a7a  ! 1: LDUBA_I	lduba	[%r16, + 0x0a7a] %asi, %r23
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd2dc2188  ! 1: LDXA_I	ldxa	[%r16, + 0x0188] %asi, %r9
	brnz %r31,thr3_loop_cnt_517
	dec %r31
        mov 0x25, %r31
thr3_loop_cnt_518:
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xe8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r20
	.word 0xee440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r23
	.word 0xda5c2b50  ! 1: LDX_I	ldx	[%r16 + 0x0b50], %r13
	.word 0xe4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r18
	.word 0xd0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r8
	.word 0xc6142718  ! 1: LDUH_I	lduh	[%r16 + 0x0718], %r3
	.word 0xc60420d4  ! 1: LDUW_I	lduw	[%r16 + 0x00d4], %r3
	.word 0xe6dc2120  ! 1: LDXA_I	ldxa	[%r16, + 0x0120] %asi, %r19
	brnz %r31,thr3_loop_cnt_518
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x9a340002  ! 1: SUBC_R	orn 	%r16, %r2, %r13
	.word 0x86042215  ! 1: ADD_I	add 	%r16, 0x0215, %r3
        mov 0x3, %r31
thr3_loop_cnt_519:
	.word 0xce5c2c30  ! 1: LDX_I	ldx	[%r16 + 0x0c30], %r7
	.word 0xd8dc2b28  ! 1: LDXA_I	ldxa	[%r16, + 0x0b28] %asi, %r12
	.word 0xfa440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r29
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc60420b4  ! 1: LDUW_I	lduw	[%r16 + 0x00b4], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd04c2622  ! 1: LDSB_I	ldsb	[%r16 + 0x0622], %r8
	.word 0xd2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r9
	.word 0xdecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r15
	brnz %r31,thr3_loop_cnt_519
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x90, %r31
thr3_loop_cnt_520:
	.word 0xda542d9e  ! 1: LDSH_I	ldsh	[%r16 + 0x0d9e], %r13
	.word 0xc6cc2734  ! 1: LDSBA_I	ldsba	[%r16, + 0x0734] %asi, %r3
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xecdc28d8  ! 1: LDXA_I	ldxa	[%r16, + 0x08d8] %asi, %r22
	.word 0xc65c2998  ! 1: LDX_I	ldx	[%r16 + 0x0998], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc65c2b78  ! 1: LDX_I	ldx	[%r16 + 0x0b78], %r3
	.word 0xc6442aa8  ! 1: LDSW_I	ldsw	[%r16 + 0x0aa8], %r3
	.word 0xf4442908  ! 1: LDSW_I	ldsw	[%r16 + 0x0908], %r26
	brnz %r31,thr3_loop_cnt_520
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0xc4, %r31
thr3_loop_cnt_521:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6d42856  ! 1: LDSHA_I	ldsha	[%r16, + 0x0856] %asi, %r3
	.word 0xe4942246  ! 1: LDUHA_I	lduha	[%r16, + 0x0246] %asi, %r18
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc65c21d0  ! 1: LDX_I	ldx	[%r16 + 0x01d0], %r3
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xc65c2978  ! 1: LDX_I	ldx	[%r16 + 0x0978], %r3
	brnz %r31,thr3_loop_cnt_521
	dec %r31
	.word 0xbc0c2f4e  ! 1: AND_I	and 	%r16, 0x0f4e, %r30
	.word 0xa5340002  ! 1: SRL_R	srl 	%r16, %r2, %r18
        mov 0xb2, %r31
thr3_loop_cnt_522:
	.word 0xe28c2ee5  ! 1: LDUBA_I	lduba	[%r16, + 0x0ee5] %asi, %r17
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd65c2ec0  ! 1: LDX_I	ldx	[%r16 + 0x0ec0], %r11
	.word 0xc60427d0  ! 1: LDUW_I	lduw	[%r16 + 0x07d0], %r3
	.word 0xf2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r25
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	brnz %r31,thr3_loop_cnt_522
	dec %r31
	.word 0xba340002  ! 1: SUBC_R	orn 	%r16, %r2, %r29
	.word 0x982c29c5  ! 1: ANDN_I	andn 	%r16, 0x09c5, %r12
        mov 0x52, %r31
thr3_loop_cnt_523:
	.word 0xf0cc2ab1  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ab1] %asi, %r24
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc217b  ! 1: LDSBA_I	ldsba	[%r16, + 0x017b] %asi, %r3
	.word 0xf45429dc  ! 1: LDSH_I	ldsh	[%r16 + 0x09dc], %r26
	.word 0xf6d429e4  ! 1: LDSHA_I	ldsha	[%r16, + 0x09e4] %asi, %r27
	.word 0xc6c42750  ! 1: LDSWA_I	ldswa	[%r16, + 0x0750] %asi, %r3
	.word 0xde0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r15
	brnz %r31,thr3_loop_cnt_523
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0xba1c2e5c  ! 1: XOR_I	xor 	%r16, 0x0e5c, %r29
        mov 0x6c, %r31
thr3_loop_cnt_524:
	.word 0xec0c2fb9  ! 1: LDUB_I	ldub	[%r16 + 0x0fb9], %r22
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xc64426e0  ! 1: LDSW_I	ldsw	[%r16 + 0x06e0], %r3
	.word 0xf2842d78  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d78] %asi, %r25
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xc654203e  ! 1: LDSH_I	ldsh	[%r16 + 0x003e], %r3
	.word 0xd64423b4  ! 1: LDSW_I	ldsw	[%r16 + 0x03b4], %r11
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r26
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_524
	dec %r31
	.word 0xa40c0002  ! 1: AND_R	and 	%r16, %r2, %r18
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0x48, %r31
thr3_loop_cnt_525:
	.word 0xeadc2c20  ! 1: LDXA_I	ldxa	[%r16, + 0x0c20] %asi, %r21
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe68c236c  ! 1: LDUBA_I	lduba	[%r16, + 0x036c] %asi, %r19
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc694290e  ! 1: LDUHA_I	lduha	[%r16, + 0x090e] %asi, %r3
	.word 0xf6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r27
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6942664  ! 1: LDUHA_I	lduha	[%r16, + 0x0664] %asi, %r3
	.word 0xccd422c4  ! 1: LDSHA_I	ldsha	[%r16, + 0x02c4] %asi, %r6
	.word 0xd45c27d8  ! 1: LDX_I	ldx	[%r16 + 0x07d8], %r10
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	brnz %r31,thr3_loop_cnt_525
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x86242ebb  ! 1: SUB_I	sub 	%r16, 0x0ebb, %r3
	.word 0xad341002  ! 1: SRLX_R	srlx	%r16, %r2, %r22
        mov 0x67, %r31
thr3_loop_cnt_526:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xda0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r13
	.word 0xe6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r19
	.word 0xce4427c8  ! 1: LDSW_I	ldsw	[%r16 + 0x07c8], %r7
	.word 0xda4c20ec  ! 1: LDSB_I	ldsb	[%r16 + 0x00ec], %r13
	.word 0xd8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r12
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd68c2568  ! 1: LDUBA_I	lduba	[%r16, + 0x0568] %asi, %r11
	.word 0xc6cc20a1  ! 1: LDSBA_I	ldsba	[%r16, + 0x00a1] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_526
	dec %r31
        mov 0xaf, %r31
thr3_loop_cnt_527:
	.word 0xeec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r23
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6142378  ! 1: LDUH_I	lduh	[%r16 + 0x0378], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc60c259e  ! 1: LDUB_I	ldub	[%r16 + 0x059e], %r3
	.word 0xea440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r21
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_527
	dec %r31
	.word 0x860c2583  ! 1: AND_I	and 	%r16, 0x0583, %r3
	.word 0xae340002  ! 1: SUBC_R	orn 	%r16, %r2, %r23
        mov 0x3c, %r31
thr3_loop_cnt_528:
	.word 0xc6d428f0  ! 1: LDSHA_I	ldsha	[%r16, + 0x08f0] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc65c23c8  ! 1: LDX_I	ldx	[%r16 + 0x03c8], %r3
	.word 0xf8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r28
	.word 0xda841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r13
	.word 0xf6c429f0  ! 1: LDSWA_I	ldswa	[%r16, + 0x09f0] %asi, %r27
	.word 0xc6cc221c  ! 1: LDSBA_I	ldsba	[%r16, + 0x021c] %asi, %r3
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	.word 0xc65c2070  ! 1: LDX_I	ldx	[%r16 + 0x0070], %r3
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xc6142c4a  ! 1: LDUH_I	lduh	[%r16 + 0x0c4a], %r3
	brnz %r31,thr3_loop_cnt_528
	dec %r31
        mov 0x73, %r31
thr3_loop_cnt_529:
	.word 0xce5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r7
	.word 0xf6c422b0  ! 1: LDSWA_I	ldswa	[%r16, + 0x02b0] %asi, %r27
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r27
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	.word 0xf44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r26
	.word 0xf2cc28db  ! 1: LDSBA_I	ldsba	[%r16, + 0x08db] %asi, %r25
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xdad42db0  ! 1: LDSHA_I	ldsha	[%r16, + 0x0db0] %asi, %r13
	.word 0xc6142f90  ! 1: LDUH_I	lduh	[%r16 + 0x0f90], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_529
	dec %r31
	.word 0xb72c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r27
        mov 0x8a, %r31
thr3_loop_cnt_530:
	.word 0xfad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r29
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xec941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r22
	.word 0xf85c2bc8  ! 1: LDX_I	ldx	[%r16 + 0x0bc8], %r28
	.word 0xc6cc23ba  ! 1: LDSBA_I	ldsba	[%r16, + 0x03ba] %asi, %r3
	.word 0xfc4c27b7  ! 1: LDSB_I	ldsb	[%r16 + 0x07b7], %r30
	.word 0xc68c2088  ! 1: LDUBA_I	lduba	[%r16, + 0x0088] %asi, %r3
	.word 0xc6542b74  ! 1: LDSH_I	ldsh	[%r16 + 0x0b74], %r3
	.word 0xd0042c50  ! 1: LDUW_I	lduw	[%r16 + 0x0c50], %r8
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_530
	dec %r31
	.word 0xa72c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r19
        mov 0x27, %r31
thr3_loop_cnt_531:
	.word 0xd6442810  ! 1: LDSW_I	ldsw	[%r16 + 0x0810], %r11
	.word 0xf004226c  ! 1: LDUW_I	lduw	[%r16 + 0x026c], %r24
	.word 0xc60c23e4  ! 1: LDUB_I	ldub	[%r16 + 0x03e4], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc684261c  ! 1: LDUWA_I	lduwa	[%r16, + 0x061c] %asi, %r3
	.word 0xd0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r8
	.word 0xf64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r27
	brnz %r31,thr3_loop_cnt_531
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x75, %r31
thr3_loop_cnt_532:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6c42e1c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e1c] %asi, %r3
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	.word 0xc6842aec  ! 1: LDUWA_I	lduwa	[%r16, + 0x0aec] %asi, %r3
	.word 0xc654259e  ! 1: LDSH_I	ldsh	[%r16 + 0x059e], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc60c2760  ! 1: LDUB_I	ldub	[%r16 + 0x0760], %r3
	.word 0xc60c2400  ! 1: LDUB_I	ldub	[%r16 + 0x0400], %r3
	.word 0xc6842f7c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f7c] %asi, %r3
	brnz %r31,thr3_loop_cnt_532
	dec %r31
	.word 0x86342753  ! 1: SUBC_I	orn 	%r16, 0x0753, %r3
	.word 0x9a240002  ! 1: SUB_R	sub 	%r16, %r2, %r13
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x1f, %r31
thr3_loop_cnt_533:
	.word 0xe25c2f80  ! 1: LDX_I	ldx	[%r16 + 0x0f80], %r17
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6542cbc  ! 1: LDSH_I	ldsh	[%r16 + 0x0cbc], %r3
	.word 0xc6d42bfc  ! 1: LDSHA_I	ldsha	[%r16, + 0x0bfc] %asi, %r3
	.word 0xf2142128  ! 1: LDUH_I	lduh	[%r16 + 0x0128], %r25
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6d42912  ! 1: LDSHA_I	ldsha	[%r16, + 0x0912] %asi, %r3
	.word 0xdcd42f84  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f84] %asi, %r14
	.word 0xf6cc2631  ! 1: LDSBA_I	ldsba	[%r16, + 0x0631] %asi, %r27
	brnz %r31,thr3_loop_cnt_533
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0xb01c0002  ! 1: XOR_R	xor 	%r16, %r2, %r24
        mov 0xb5, %r31
thr3_loop_cnt_534:
	.word 0xfad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r29
	.word 0xc64c254a  ! 1: LDSB_I	ldsb	[%r16 + 0x054a], %r3
	.word 0xc6942a70  ! 1: LDUHA_I	lduha	[%r16, + 0x0a70] %asi, %r3
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	.word 0xcc5c2230  ! 1: LDX_I	ldx	[%r16 + 0x0230], %r6
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xd65c2f98  ! 1: LDX_I	ldx	[%r16 + 0x0f98], %r11
	.word 0xecdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r22
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_534
	dec %r31
	.word 0x9f3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r15
	.word 0x8f2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r7
	.word 0xbc440002  ! 1: ADDC_R	addc 	%r16, %r2, %r30
	.word 0xa61c2880  ! 1: XOR_I	xor 	%r16, 0x0880, %r19
        mov 0x1d, %r31
thr3_loop_cnt_535:
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xe6442bf0  ! 1: LDSW_I	ldsw	[%r16 + 0x0bf0], %r19
	.word 0xe84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r20
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	.word 0xf6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r27
	.word 0xc6d42832  ! 1: LDSHA_I	ldsha	[%r16, + 0x0832] %asi, %r3
	.word 0xf84c217c  ! 1: LDSB_I	ldsb	[%r16 + 0x017c], %r28
	.word 0xe2d42fac  ! 1: LDSHA_I	ldsha	[%r16, + 0x0fac] %asi, %r17
	brnz %r31,thr3_loop_cnt_535
	dec %r31
	.word 0x903c235b  ! 1: XNOR_I	xnor 	%r16, 0x035b, %r8
        mov 0xb4, %r31
thr3_loop_cnt_536:
	.word 0xc6dc2938  ! 1: LDXA_I	ldxa	[%r16, + 0x0938] %asi, %r3
	.word 0xc6442b3c  ! 1: LDSW_I	ldsw	[%r16 + 0x0b3c], %r3
	.word 0xf00428e8  ! 1: LDUW_I	lduw	[%r16 + 0x08e8], %r24
	.word 0xc60c2acc  ! 1: LDUB_I	ldub	[%r16 + 0x0acc], %r3
	.word 0xdecc29bb  ! 1: LDSBA_I	ldsba	[%r16, + 0x09bb] %asi, %r15
	.word 0xced42be8  ! 1: LDSHA_I	ldsha	[%r16, + 0x0be8] %asi, %r7
	.word 0xe8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r20
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc69425b4  ! 1: LDUHA_I	lduha	[%r16, + 0x05b4] %asi, %r3
	.word 0xde8c2cf6  ! 1: LDUBA_I	lduba	[%r16, + 0x0cf6] %asi, %r15
	brnz %r31,thr3_loop_cnt_536
	dec %r31
	.word 0x860420cf  ! 1: ADD_I	add 	%r16, 0x00cf, %r3
	.word 0xb63423f9  ! 1: ORN_I	orn 	%r16, 0x03f9, %r27
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0xab, %r31
thr3_loop_cnt_537:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf2542606  ! 1: LDSH_I	ldsh	[%r16 + 0x0606], %r25
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6542894  ! 1: LDSH_I	ldsh	[%r16 + 0x0894], %r3
	.word 0xe8cc2d70  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d70] %asi, %r20
	.word 0xda942abe  ! 1: LDUHA_I	lduha	[%r16, + 0x0abe] %asi, %r13
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	.word 0xe6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r19
	.word 0xf24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r25
	brnz %r31,thr3_loop_cnt_537
	dec %r31
	.word 0xae04233a  ! 1: ADD_I	add 	%r16, 0x033a, %r23
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x862421d3  ! 1: SUB_I	sub 	%r16, 0x01d3, %r3
        mov 0x77, %r31
thr3_loop_cnt_538:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xde140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r15
	.word 0xfccc21e3  ! 1: LDSBA_I	ldsba	[%r16, + 0x01e3] %asi, %r30
	.word 0xc6842dd8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0dd8] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	.word 0xc65c2b00  ! 1: LDX_I	ldx	[%r16 + 0x0b00], %r3
	.word 0xd054216c  ! 1: LDSH_I	ldsh	[%r16 + 0x016c], %r8
	brnz %r31,thr3_loop_cnt_538
	dec %r31
        mov 0xa4, %r31
thr3_loop_cnt_539:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc60c289e  ! 1: LDUB_I	ldub	[%r16 + 0x089e], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xde841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r15
	.word 0xf0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r24
	.word 0xe4c42240  ! 1: LDSWA_I	ldswa	[%r16, + 0x0240] %asi, %r18
	.word 0xd0c4284c  ! 1: LDSWA_I	ldswa	[%r16, + 0x084c] %asi, %r8
	.word 0xda44267c  ! 1: LDSW_I	ldsw	[%r16 + 0x067c], %r13
	.word 0xf0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r24
	.word 0xcc542f66  ! 1: LDSH_I	ldsh	[%r16 + 0x0f66], %r6
	brnz %r31,thr3_loop_cnt_539
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x96142a70  ! 1: OR_I	or 	%r16, 0x0a70, %r11
        mov 0xbe, %r31
thr3_loop_cnt_540:
	.word 0xf8d4202e  ! 1: LDSHA_I	ldsha	[%r16, + 0x002e] %asi, %r28
	.word 0xd0d429b0  ! 1: LDSHA_I	ldsha	[%r16, + 0x09b0] %asi, %r8
	.word 0xc6dc2e20  ! 1: LDXA_I	ldxa	[%r16, + 0x0e20] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r27
	.word 0xe4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r18
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r8
	.word 0xc68c2795  ! 1: LDUBA_I	lduba	[%r16, + 0x0795] %asi, %r3
	.word 0xf64c2701  ! 1: LDSB_I	ldsb	[%r16 + 0x0701], %r27
	.word 0xfc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r30
	.word 0xc6042e44  ! 1: LDUW_I	lduw	[%r16 + 0x0e44], %r3
	brnz %r31,thr3_loop_cnt_540
	dec %r31
	.word 0xbd342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r30
	.word 0x9a2c2883  ! 1: ANDN_I	andn 	%r16, 0x0883, %r13
	.word 0xad3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r22
        mov 0x39, %r31
thr3_loop_cnt_541:
	.word 0xf0d42838  ! 1: LDSHA_I	ldsha	[%r16, + 0x0838] %asi, %r24
	.word 0xe8cc2ac8  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ac8] %asi, %r20
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd6d42388  ! 1: LDSHA_I	ldsha	[%r16, + 0x0388] %asi, %r11
	.word 0xc6c42388  ! 1: LDSWA_I	ldswa	[%r16, + 0x0388] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc60c2ea1  ! 1: LDUB_I	ldub	[%r16 + 0x0ea1], %r3
	.word 0xc694235a  ! 1: LDUHA_I	lduha	[%r16, + 0x035a] %asi, %r3
	brnz %r31,thr3_loop_cnt_541
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x67, %r31
thr3_loop_cnt_542:
	.word 0xd2d4251c  ! 1: LDSHA_I	ldsha	[%r16, + 0x051c] %asi, %r9
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xc644276c  ! 1: LDSW_I	ldsw	[%r16 + 0x076c], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc64421a4  ! 1: LDSW_I	ldsw	[%r16 + 0x01a4], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd2d42814  ! 1: LDSHA_I	ldsha	[%r16, + 0x0814] %asi, %r9
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf6542b6a  ! 1: LDSH_I	ldsh	[%r16 + 0x0b6a], %r27
	brnz %r31,thr3_loop_cnt_542
	dec %r31
	.word 0xb2140002  ! 1: OR_R	or 	%r16, %r2, %r25
	.word 0x94340002  ! 1: ORN_R	orn 	%r16, %r2, %r10
        mov 0x57, %r31
thr3_loop_cnt_543:
	.word 0xe88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r20
	.word 0xc6442f44  ! 1: LDSW_I	ldsw	[%r16 + 0x0f44], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe20c217b  ! 1: LDUB_I	ldub	[%r16 + 0x017b], %r17
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xfac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r29
	.word 0xe84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r20
	.word 0xdedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r15
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6142c92  ! 1: LDUH_I	lduh	[%r16 + 0x0c92], %r3
	.word 0xf2cc2ff5  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ff5] %asi, %r25
	.word 0xf8842848  ! 1: LDUWA_I	lduwa	[%r16, + 0x0848] %asi, %r28
	brnz %r31,thr3_loop_cnt_543
	dec %r31
	.word 0x912c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r8
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0xf, %r31
thr3_loop_cnt_544:
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc60c2404  ! 1: LDUB_I	ldub	[%r16 + 0x0404], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xda04243c  ! 1: LDUW_I	lduw	[%r16 + 0x043c], %r13
	.word 0xccc427c8  ! 1: LDSWA_I	ldswa	[%r16, + 0x07c8] %asi, %r6
	brnz %r31,thr3_loop_cnt_544
	dec %r31
	.word 0x9a3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r13
        mov 0x84, %r31
thr3_loop_cnt_545:
	.word 0xe40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r18
	.word 0xdacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r13
	.word 0xd6842438  ! 1: LDUWA_I	lduwa	[%r16, + 0x0438] %asi, %r11
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xfa841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r29
	.word 0xc64c2a10  ! 1: LDSB_I	ldsb	[%r16 + 0x0a10], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd65c2ce0  ! 1: LDX_I	ldx	[%r16 + 0x0ce0], %r11
	.word 0xd84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r12
	brnz %r31,thr3_loop_cnt_545
	dec %r31
        mov 0xa9, %r31
thr3_loop_cnt_546:
	.word 0xeacc27f5  ! 1: LDSBA_I	ldsba	[%r16, + 0x07f5] %asi, %r21
	.word 0xe68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r19
	.word 0xc69426f0  ! 1: LDUHA_I	lduha	[%r16, + 0x06f0] %asi, %r3
	.word 0xc654234a  ! 1: LDSH_I	ldsh	[%r16 + 0x034a], %r3
	.word 0xccc428e8  ! 1: LDSWA_I	ldswa	[%r16, + 0x08e8] %asi, %r6
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xfcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r30
	.word 0xf2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r25
	.word 0xf8c42a44  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a44] %asi, %r28
	.word 0xde8c23ba  ! 1: LDUBA_I	lduba	[%r16, + 0x03ba] %asi, %r15
	.word 0xda54240a  ! 1: LDSH_I	ldsh	[%r16 + 0x040a], %r13
	.word 0xda8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r13
	brnz %r31,thr3_loop_cnt_546
	dec %r31
	.word 0x962c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r11
	.word 0xab3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r21
	.word 0xa60c0002  ! 1: AND_R	and 	%r16, %r2, %r19
        mov 0xb, %r31
thr3_loop_cnt_547:
	.word 0xc684203c  ! 1: LDUWA_I	lduwa	[%r16, + 0x003c] %asi, %r3
	.word 0xc6d42b78  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b78] %asi, %r3
	.word 0xe6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r19
	.word 0xc6842a70  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a70] %asi, %r3
	.word 0xd28429fc  ! 1: LDUWA_I	lduwa	[%r16, + 0x09fc] %asi, %r9
	.word 0xf4142d42  ! 1: LDUH_I	lduh	[%r16 + 0x0d42], %r26
	.word 0xc6042b78  ! 1: LDUW_I	lduw	[%r16 + 0x0b78], %r3
	.word 0xc61429f4  ! 1: LDUH_I	lduh	[%r16 + 0x09f4], %r3
	brnz %r31,thr3_loop_cnt_547
	dec %r31
	.word 0x993c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r12
	.word 0xab3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r21
        mov 0x2a, %r31
thr3_loop_cnt_548:
	.word 0xfc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r30
	.word 0xc6d42e90  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e90] %asi, %r3
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xd44c2b36  ! 1: LDSB_I	ldsb	[%r16 + 0x0b36], %r10
	.word 0xdc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r14
	.word 0xce040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r7
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc60c2bc5  ! 1: LDUB_I	ldub	[%r16 + 0x0bc5], %r3
	.word 0xc6442030  ! 1: LDSW_I	ldsw	[%r16 + 0x0030], %r3
	.word 0xc65c22f0  ! 1: LDX_I	ldx	[%r16 + 0x02f0], %r3
	brnz %r31,thr3_loop_cnt_548
	dec %r31
	.word 0x982c238d  ! 1: ANDN_I	andn 	%r16, 0x038d, %r12
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0x4b, %r31
thr3_loop_cnt_549:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xea0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r21
	.word 0xc684225c  ! 1: LDUWA_I	lduwa	[%r16, + 0x025c] %asi, %r3
	.word 0xc6dc2c80  ! 1: LDXA_I	ldxa	[%r16, + 0x0c80] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc614272a  ! 1: LDUH_I	lduh	[%r16 + 0x072a], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r8
	.word 0xfc942730  ! 1: LDUHA_I	lduha	[%r16, + 0x0730] %asi, %r30
	.word 0xfcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r30
	brnz %r31,thr3_loop_cnt_549
	dec %r31
	.word 0x93342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r9
        mov 0xae, %r31
thr3_loop_cnt_550:
	.word 0xc6cc2066  ! 1: LDSBA_I	ldsba	[%r16, + 0x0066] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xee5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r23
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xfc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r30
	.word 0xd44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r10
	.word 0xc68c2137  ! 1: LDUBA_I	lduba	[%r16, + 0x0137] %asi, %r3
	brnz %r31,thr3_loop_cnt_550
	dec %r31
	.word 0x9b2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r13
	.word 0x8624277d  ! 1: SUB_I	sub 	%r16, 0x077d, %r3
        mov 0x2a, %r31
thr3_loop_cnt_551:
	.word 0xc6542500  ! 1: LDSH_I	ldsh	[%r16 + 0x0500], %r3
	.word 0xea0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r21
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd28426d4  ! 1: LDUWA_I	lduwa	[%r16, + 0x06d4] %asi, %r9
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf4442304  ! 1: LDSW_I	ldsw	[%r16 + 0x0304], %r26
	brnz %r31,thr3_loop_cnt_551
	dec %r31
        mov 0x7f, %r31
thr3_loop_cnt_552:
	.word 0xdacc2a1a  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a1a] %asi, %r13
	.word 0xf4d42c64  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c64] %asi, %r26
	.word 0xf6542258  ! 1: LDSH_I	ldsh	[%r16 + 0x0258], %r27
	.word 0xccc42fd0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0fd0] %asi, %r6
	.word 0xf6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r27
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6dc2f08  ! 1: LDXA_I	ldxa	[%r16, + 0x0f08] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6d42cd8  ! 1: LDSHA_I	ldsha	[%r16, + 0x0cd8] %asi, %r3
	.word 0xec941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r22
	brnz %r31,thr3_loop_cnt_552
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x9e0425f2  ! 1: ADD_I	add 	%r16, 0x05f2, %r15
        mov 0xb3, %r31
thr3_loop_cnt_553:
	.word 0xe80c20b2  ! 1: LDUB_I	ldub	[%r16 + 0x00b2], %r20
	.word 0xd0c42424  ! 1: LDSWA_I	ldswa	[%r16, + 0x0424] %asi, %r8
	.word 0xf20c2181  ! 1: LDUB_I	ldub	[%r16 + 0x0181], %r25
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xfc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r30
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xeac42338  ! 1: LDSWA_I	ldswa	[%r16, + 0x0338] %asi, %r21
	.word 0xda0c28e3  ! 1: LDUB_I	ldub	[%r16 + 0x08e3], %r13
	.word 0xfc942b2e  ! 1: LDUHA_I	lduha	[%r16, + 0x0b2e] %asi, %r30
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_553
	dec %r31
	.word 0xbb3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r29
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x86342787  ! 1: SUBC_I	orn 	%r16, 0x0787, %r3
        mov 0x41, %r31
thr3_loop_cnt_554:
	.word 0xf8942b7c  ! 1: LDUHA_I	lduha	[%r16, + 0x0b7c] %asi, %r28
	.word 0xe6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r19
	.word 0xd2542f3c  ! 1: LDSH_I	ldsh	[%r16 + 0x0f3c], %r9
	.word 0xe25c2178  ! 1: LDX_I	ldx	[%r16 + 0x0178], %r17
	.word 0xc65c2118  ! 1: LDX_I	ldx	[%r16 + 0x0118], %r3
	.word 0xc60c220e  ! 1: LDUB_I	ldub	[%r16 + 0x020e], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd04c2cf4  ! 1: LDSB_I	ldsb	[%r16 + 0x0cf4], %r8
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_554
	dec %r31
        mov 0x94, %r31
thr3_loop_cnt_555:
	.word 0xd88c281b  ! 1: LDUBA_I	lduba	[%r16, + 0x081b] %asi, %r12
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xdecc28ca  ! 1: LDSBA_I	ldsba	[%r16, + 0x08ca] %asi, %r15
	.word 0xfa44274c  ! 1: LDSW_I	ldsw	[%r16 + 0x074c], %r29
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd88c2443  ! 1: LDUBA_I	lduba	[%r16, + 0x0443] %asi, %r12
	.word 0xfa0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r29
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_555
	dec %r31
	.word 0xb0440002  ! 1: ADDC_R	addc 	%r16, %r2, %r24
	.word 0x8c140002  ! 1: OR_R	or 	%r16, %r2, %r6
	.word 0xa5342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r18
        mov 0x8, %r31
thr3_loop_cnt_556:
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xd6542028  ! 1: LDSH_I	ldsh	[%r16 + 0x0028], %r11
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xcc8c2f43  ! 1: LDUBA_I	lduba	[%r16, + 0x0f43] %asi, %r6
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc64c2b9a  ! 1: LDSB_I	ldsb	[%r16 + 0x0b9a], %r3
	.word 0xc6dc2af8  ! 1: LDXA_I	ldxa	[%r16, + 0x0af8] %asi, %r3
	.word 0xc6042964  ! 1: LDUW_I	lduw	[%r16 + 0x0964], %r3
	.word 0xc6d42806  ! 1: LDSHA_I	ldsha	[%r16, + 0x0806] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_556
	dec %r31
	.word 0xb5342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r26
	.word 0x93342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r9
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x972c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r11
        mov 0x47, %r31
thr3_loop_cnt_557:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf04c2b3f  ! 1: LDSB_I	ldsb	[%r16 + 0x0b3f], %r24
	.word 0xd0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r8
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6442cfc  ! 1: LDSW_I	ldsw	[%r16 + 0x0cfc], %r3
	.word 0xc65c27e8  ! 1: LDX_I	ldx	[%r16 + 0x07e8], %r3
	.word 0xd254287c  ! 1: LDSH_I	ldsh	[%r16 + 0x087c], %r9
	.word 0xdcc42208  ! 1: LDSWA_I	ldswa	[%r16, + 0x0208] %asi, %r14
	.word 0xe8cc2d14  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d14] %asi, %r20
	.word 0xfa5c2ea0  ! 1: LDX_I	ldx	[%r16 + 0x0ea0], %r29
	.word 0xe8d42164  ! 1: LDSHA_I	ldsha	[%r16, + 0x0164] %asi, %r20
	brnz %r31,thr3_loop_cnt_557
	dec %r31
	.word 0x923c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r9
	.word 0x901c0002  ! 1: XOR_R	xor 	%r16, %r2, %r8
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x86442d38  ! 1: ADDC_I	addc 	%r16, 0x0d38, %r3
        mov 0xb2, %r31
thr3_loop_cnt_558:
	.word 0xc6842464  ! 1: LDUWA_I	lduwa	[%r16, + 0x0464] %asi, %r3
	.word 0xc6942926  ! 1: LDUHA_I	lduha	[%r16, + 0x0926] %asi, %r3
	.word 0xc60425d0  ! 1: LDUW_I	lduw	[%r16 + 0x05d0], %r3
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	.word 0xd8d42d6e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d6e] %asi, %r12
	.word 0xd4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r10
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d427b2  ! 1: LDSHA_I	ldsha	[%r16, + 0x07b2] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_558
	dec %r31
	.word 0xb3341002  ! 1: SRLX_R	srlx	%r16, %r2, %r25
	.word 0x9e2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r15
	.word 0x863423e0  ! 1: ORN_I	orn 	%r16, 0x03e0, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0xc2, %r31
thr3_loop_cnt_559:
	.word 0xc6dc20a0  ! 1: LDXA_I	ldxa	[%r16, + 0x00a0] %asi, %r3
	.word 0xe8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r20
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd8cc269f  ! 1: LDSBA_I	ldsba	[%r16, + 0x069f] %asi, %r12
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6042900  ! 1: LDUW_I	lduw	[%r16 + 0x0900], %r3
	.word 0xf2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r25
	.word 0xcc0c2be4  ! 1: LDUB_I	ldub	[%r16 + 0x0be4], %r6
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_559
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x93340002  ! 1: SRL_R	srl 	%r16, %r2, %r9
	.word 0xb42c239b  ! 1: ANDN_I	andn 	%r16, 0x039b, %r26
	.word 0x860c2da4  ! 1: AND_I	and 	%r16, 0x0da4, %r3
        mov 0x54, %r31
thr3_loop_cnt_560:
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc65c2c18  ! 1: LDX_I	ldx	[%r16 + 0x0c18], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf44c21f7  ! 1: LDSB_I	ldsb	[%r16 + 0x01f7], %r26
	.word 0xc64c2b64  ! 1: LDSB_I	ldsb	[%r16 + 0x0b64], %r3
	.word 0xccc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r6
	.word 0xe4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r18
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_560
	dec %r31
        mov 0x30, %r31
thr3_loop_cnt_561:
	.word 0xc60c29dd  ! 1: LDUB_I	ldub	[%r16 + 0x09dd], %r3
	.word 0xc64c28b7  ! 1: LDSB_I	ldsb	[%r16 + 0x08b7], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xccc42d2c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d2c] %asi, %r6
	.word 0xc6dc2c38  ! 1: LDXA_I	ldxa	[%r16, + 0x0c38] %asi, %r3
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	.word 0xec040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r22
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xeedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r23
	brnz %r31,thr3_loop_cnt_561
	dec %r31
	.word 0x9e042d84  ! 1: ADD_I	add 	%r16, 0x0d84, %r15
	.word 0x86042a2c  ! 1: ADD_I	add 	%r16, 0x0a2c, %r3
        mov 0xa9, %r31
thr3_loop_cnt_562:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6842fb8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0fb8] %asi, %r3
	.word 0xd05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r8
	.word 0xc6dc2b70  ! 1: LDXA_I	ldxa	[%r16, + 0x0b70] %asi, %r3
	.word 0xc68429fc  ! 1: LDUWA_I	lduwa	[%r16, + 0x09fc] %asi, %r3
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	.word 0xc6142f44  ! 1: LDUH_I	lduh	[%r16 + 0x0f44], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r24
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	.word 0xf0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r24
	brnz %r31,thr3_loop_cnt_562
	dec %r31
	.word 0xba240002  ! 1: SUB_R	sub 	%r16, %r2, %r29
	.word 0x86442c2f  ! 1: ADDC_I	addc 	%r16, 0x0c2f, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x13, %r31
thr3_loop_cnt_563:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc60c2cf4  ! 1: LDUB_I	ldub	[%r16 + 0x0cf4], %r3
	.word 0xc644271c  ! 1: LDSW_I	ldsw	[%r16 + 0x071c], %r3
	.word 0xf08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r24
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	.word 0xc68c2dcd  ! 1: LDUBA_I	lduba	[%r16, + 0x0dcd] %asi, %r3
	.word 0xc68c22fd  ! 1: LDUBA_I	lduba	[%r16, + 0x02fd] %asi, %r3
	.word 0xee4c2194  ! 1: LDSB_I	ldsb	[%r16 + 0x0194], %r23
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe48c21b8  ! 1: LDUBA_I	lduba	[%r16, + 0x01b8] %asi, %r18
	brnz %r31,thr3_loop_cnt_563
	dec %r31
        mov 0x63, %r31
thr3_loop_cnt_564:
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xda941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r13
	.word 0xf24c2792  ! 1: LDSB_I	ldsb	[%r16 + 0x0792], %r25
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xc68c2708  ! 1: LDUBA_I	lduba	[%r16, + 0x0708] %asi, %r3
	.word 0xc60c2826  ! 1: LDUB_I	ldub	[%r16 + 0x0826], %r3
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	.word 0xe6142df2  ! 1: LDUH_I	lduh	[%r16 + 0x0df2], %r19
	.word 0xdadc28e8  ! 1: LDXA_I	ldxa	[%r16, + 0x08e8] %asi, %r13
	.word 0xda5c24d8  ! 1: LDX_I	ldx	[%r16 + 0x04d8], %r13
	brnz %r31,thr3_loop_cnt_564
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0xb6040002  ! 1: ADD_R	add 	%r16, %r2, %r27
        mov 0xbe, %r31
thr3_loop_cnt_565:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d42e24  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e24] %asi, %r3
	.word 0xe8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r20
	.word 0xde5c22e8  ! 1: LDX_I	ldx	[%r16 + 0x02e8], %r15
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd0042e88  ! 1: LDUW_I	lduw	[%r16 + 0x0e88], %r8
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_565
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x8d3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r6
        mov 0x33, %r31
thr3_loop_cnt_566:
	.word 0xf2c42868  ! 1: LDSWA_I	ldswa	[%r16, + 0x0868] %asi, %r25
	.word 0xdc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r14
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf0142312  ! 1: LDUH_I	lduh	[%r16 + 0x0312], %r24
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xccc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r6
	brnz %r31,thr3_loop_cnt_566
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x39, %r31
thr3_loop_cnt_567:
	.word 0xc6142096  ! 1: LDUH_I	lduh	[%r16 + 0x0096], %r3
	.word 0xde0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r15
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	.word 0xe2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r17
	.word 0xc6dc2050  ! 1: LDXA_I	ldxa	[%r16, + 0x0050] %asi, %r3
	.word 0xd0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r8
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xda942b90  ! 1: LDUHA_I	lduha	[%r16, + 0x0b90] %asi, %r13
	.word 0xf85c2570  ! 1: LDX_I	ldx	[%r16 + 0x0570], %r28
	brnz %r31,thr3_loop_cnt_567
	dec %r31
	.word 0x8d3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r6
	.word 0xa6440002  ! 1: ADDC_R	addc 	%r16, %r2, %r19
        mov 0x55, %r31
thr3_loop_cnt_568:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf4542d26  ! 1: LDSH_I	ldsh	[%r16 + 0x0d26], %r26
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd68c2abe  ! 1: LDUBA_I	lduba	[%r16, + 0x0abe] %asi, %r11
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r25
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xde4c27e1  ! 1: LDSB_I	ldsb	[%r16 + 0x07e1], %r15
	brnz %r31,thr3_loop_cnt_568
	dec %r31
	.word 0x902c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r8
        mov 0x25, %r31
thr3_loop_cnt_569:
	.word 0xce542d62  ! 1: LDSH_I	ldsh	[%r16 + 0x0d62], %r7
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r26
	.word 0xda5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r13
	.word 0xc60428e4  ! 1: LDUW_I	lduw	[%r16 + 0x08e4], %r3
	.word 0xd65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r11
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r20
	.word 0xc69426e6  ! 1: LDUHA_I	lduha	[%r16, + 0x06e6] %asi, %r3
	.word 0xce5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r7
	.word 0xc60c2eef  ! 1: LDUB_I	ldub	[%r16 + 0x0eef], %r3
	.word 0xd85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r12
	brnz %r31,thr3_loop_cnt_569
	dec %r31
	.word 0x932c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r9
	.word 0x861c2ad9  ! 1: XOR_I	xor 	%r16, 0x0ad9, %r3
        mov 0x58, %r31
thr3_loop_cnt_570:
	.word 0xfa0429c8  ! 1: LDUW_I	lduw	[%r16 + 0x09c8], %r29
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xc68c2e04  ! 1: LDUBA_I	lduba	[%r16, + 0x0e04] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2f80  ! 1: LDXA_I	ldxa	[%r16, + 0x0f80] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc65c2d08  ! 1: LDX_I	ldx	[%r16 + 0x0d08], %r3
	.word 0xf0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r24
	brnz %r31,thr3_loop_cnt_570
	dec %r31
	.word 0xac342ec8  ! 1: ORN_I	orn 	%r16, 0x0ec8, %r22
	.word 0x90142c21  ! 1: OR_I	or 	%r16, 0x0c21, %r8
	.word 0x863c2e0f  ! 1: XNOR_I	xnor 	%r16, 0x0e0f, %r3
	.word 0xbb343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r29
        mov 0x5d, %r31
thr3_loop_cnt_571:
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf49426d6  ! 1: LDUHA_I	lduha	[%r16, + 0x06d6] %asi, %r26
	.word 0xec841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r22
	.word 0xc6442bbc  ! 1: LDSW_I	ldsw	[%r16 + 0x0bbc], %r3
	.word 0xde442614  ! 1: LDSW_I	ldsw	[%r16 + 0x0614], %r15
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	.word 0xccd42420  ! 1: LDSHA_I	ldsha	[%r16, + 0x0420] %asi, %r6
	.word 0xf40c29f9  ! 1: LDUB_I	ldub	[%r16 + 0x09f9], %r26
	.word 0xe84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r20
	brnz %r31,thr3_loop_cnt_571
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x86342913  ! 1: ORN_I	orn 	%r16, 0x0913, %r3
	.word 0xbd340002  ! 1: SRL_R	srl 	%r16, %r2, %r30
	.word 0x961c2973  ! 1: XOR_I	xor 	%r16, 0x0973, %r11
        mov 0xb7, %r31
thr3_loop_cnt_572:
	.word 0xdc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r14
	.word 0xdc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r14
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc654286a  ! 1: LDSH_I	ldsh	[%r16 + 0x086a], %r3
	.word 0xf04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r24
	.word 0xc65426aa  ! 1: LDSH_I	ldsh	[%r16 + 0x06aa], %r3
	.word 0xfc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r30
	.word 0xe65c2a80  ! 1: LDX_I	ldx	[%r16 + 0x0a80], %r19
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	brnz %r31,thr3_loop_cnt_572
	dec %r31
	.word 0xa6042ca0  ! 1: ADD_I	add 	%r16, 0x0ca0, %r19
        mov 0xad, %r31
thr3_loop_cnt_573:
	.word 0xcc942c12  ! 1: LDUHA_I	lduha	[%r16, + 0x0c12] %asi, %r6
	.word 0xc6442ad4  ! 1: LDSW_I	ldsw	[%r16 + 0x0ad4], %r3
	.word 0xc65c20c0  ! 1: LDX_I	ldx	[%r16 + 0x00c0], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xda4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r13
	.word 0xce942af8  ! 1: LDUHA_I	lduha	[%r16, + 0x0af8] %asi, %r7
	.word 0xccc42db8  ! 1: LDSWA_I	ldswa	[%r16, + 0x0db8] %asi, %r6
	.word 0xda442f6c  ! 1: LDSW_I	ldsw	[%r16 + 0x0f6c], %r13
	brnz %r31,thr3_loop_cnt_573
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0xb0142087  ! 1: OR_I	or 	%r16, 0x0087, %r24
	.word 0xbb340002  ! 1: SRL_R	srl 	%r16, %r2, %r29
        mov 0x59, %r31
thr3_loop_cnt_574:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r24
	.word 0xc6dc28c0  ! 1: LDXA_I	ldxa	[%r16, + 0x08c0] %asi, %r3
	.word 0xc60422bc  ! 1: LDUW_I	lduw	[%r16 + 0x02bc], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	.word 0xc6c427b4  ! 1: LDSWA_I	ldswa	[%r16, + 0x07b4] %asi, %r3
	.word 0xc6d42874  ! 1: LDSHA_I	ldsha	[%r16, + 0x0874] %asi, %r3
	.word 0xd004277c  ! 1: LDUW_I	lduw	[%r16 + 0x077c], %r8
	.word 0xc6c422c0  ! 1: LDSWA_I	ldswa	[%r16, + 0x02c0] %asi, %r3
	.word 0xc6042490  ! 1: LDUW_I	lduw	[%r16 + 0x0490], %r3
	brnz %r31,thr3_loop_cnt_574
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0xa6, %r31
thr3_loop_cnt_575:
	.word 0xc60c2dcd  ! 1: LDUB_I	ldub	[%r16 + 0x0dcd], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe6542406  ! 1: LDSH_I	ldsh	[%r16 + 0x0406], %r19
	.word 0xc6dc2850  ! 1: LDXA_I	ldxa	[%r16, + 0x0850] %asi, %r3
	.word 0xc6942bb4  ! 1: LDUHA_I	lduha	[%r16, + 0x0bb4] %asi, %r3
	.word 0xd2042efc  ! 1: LDUW_I	lduw	[%r16 + 0x0efc], %r9
	.word 0xc6942d72  ! 1: LDUHA_I	lduha	[%r16, + 0x0d72] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xdcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r14
	.word 0xf60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r27
	brnz %r31,thr3_loop_cnt_575
	dec %r31
	.word 0x993c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r12
        mov 0xb8, %r31
thr3_loop_cnt_576:
	.word 0xda5429f8  ! 1: LDSH_I	ldsh	[%r16 + 0x09f8], %r13
	.word 0xfcdc2e10  ! 1: LDXA_I	ldxa	[%r16, + 0x0e10] %asi, %r30
	.word 0xde8c2b1a  ! 1: LDUBA_I	lduba	[%r16, + 0x0b1a] %asi, %r15
	.word 0xd8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r12
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	.word 0xcc0c21af  ! 1: LDUB_I	ldub	[%r16 + 0x01af], %r6
	.word 0xc68c20cd  ! 1: LDUBA_I	lduba	[%r16, + 0x00cd] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_576
	dec %r31
	.word 0xbc1c0002  ! 1: XOR_R	xor 	%r16, %r2, %r30
	.word 0x861c2741  ! 1: XOR_I	xor 	%r16, 0x0741, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x86442dee  ! 1: ADDC_I	addc 	%r16, 0x0dee, %r3
        mov 0xd, %r31
thr3_loop_cnt_577:
	.word 0xc64c2788  ! 1: LDSB_I	ldsb	[%r16 + 0x0788], %r3
	.word 0xf614247c  ! 1: LDUH_I	lduh	[%r16 + 0x047c], %r27
	.word 0xcc842704  ! 1: LDUWA_I	lduwa	[%r16, + 0x0704] %asi, %r6
	.word 0xd8dc2860  ! 1: LDXA_I	ldxa	[%r16, + 0x0860] %asi, %r12
	.word 0xc60c2109  ! 1: LDUB_I	ldub	[%r16 + 0x0109], %r3
	.word 0xe2942de2  ! 1: LDUHA_I	lduha	[%r16, + 0x0de2] %asi, %r17
	.word 0xc6c42e8c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e8c] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_577
	dec %r31
	.word 0xae140002  ! 1: OR_R	or 	%r16, %r2, %r23
	.word 0x8e4424d1  ! 1: ADDC_I	addc 	%r16, 0x04d1, %r7
	.word 0xaa340002  ! 1: SUBC_R	orn 	%r16, %r2, %r21
        mov 0x5a, %r31
thr3_loop_cnt_578:
	.word 0xe89421b2  ! 1: LDUHA_I	lduha	[%r16, + 0x01b2] %asi, %r20
	.word 0xc6d42054  ! 1: LDSHA_I	ldsha	[%r16, + 0x0054] %asi, %r3
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6d42498  ! 1: LDSHA_I	ldsha	[%r16, + 0x0498] %asi, %r3
	.word 0xc6142e1c  ! 1: LDUH_I	lduh	[%r16 + 0x0e1c], %r3
	.word 0xf6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r27
	.word 0xc6c42f28  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f28] %asi, %r3
	brnz %r31,thr3_loop_cnt_578
	dec %r31
	.word 0xb23c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r25
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x863c2459  ! 1: XNOR_I	xnor 	%r16, 0x0459, %r3
	.word 0x8f2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r7
        mov 0x15, %r31
thr3_loop_cnt_579:
	.word 0xe84c2a81  ! 1: LDSB_I	ldsb	[%r16 + 0x0a81], %r20
	.word 0xe64c27aa  ! 1: LDSB_I	ldsb	[%r16 + 0x07aa], %r19
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xce040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r7
	.word 0xe4842a94  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a94] %asi, %r18
	.word 0xd64426d8  ! 1: LDSW_I	ldsw	[%r16 + 0x06d8], %r11
	.word 0xc6c427f8  ! 1: LDSWA_I	ldswa	[%r16, + 0x07f8] %asi, %r3
	.word 0xc6442070  ! 1: LDSW_I	ldsw	[%r16 + 0x0070], %r3
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	brnz %r31,thr3_loop_cnt_579
	dec %r31
        mov 0x3f, %r31
thr3_loop_cnt_580:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r25
	.word 0xec440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r22
	.word 0xf8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r28
	.word 0xe6442a1c  ! 1: LDSW_I	ldsw	[%r16 + 0x0a1c], %r19
	.word 0xd20c2d51  ! 1: LDUB_I	ldub	[%r16 + 0x0d51], %r9
	.word 0xd4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r10
	.word 0xc6842810  ! 1: LDUWA_I	lduwa	[%r16, + 0x0810] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_580
	dec %r31
        mov 0x5e, %r31
thr3_loop_cnt_581:
	.word 0xc6dc2ca8  ! 1: LDXA_I	ldxa	[%r16, + 0x0ca8] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xea8425a8  ! 1: LDUWA_I	lduwa	[%r16, + 0x05a8] %asi, %r21
	.word 0xde5c2898  ! 1: LDX_I	ldx	[%r16 + 0x0898], %r15
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe45c20b0  ! 1: LDX_I	ldx	[%r16 + 0x00b0], %r18
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xcccc27e5  ! 1: LDSBA_I	ldsba	[%r16, + 0x07e5] %asi, %r6
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc61429ce  ! 1: LDUH_I	lduh	[%r16 + 0x09ce], %r3
	brnz %r31,thr3_loop_cnt_581
	dec %r31
	.word 0xa80c0002  ! 1: AND_R	and 	%r16, %r2, %r20
	.word 0x94142990  ! 1: OR_I	or 	%r16, 0x0990, %r10
        mov 0x7, %r31
thr3_loop_cnt_582:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6542c92  ! 1: LDSH_I	ldsh	[%r16 + 0x0c92], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xfa8c2372  ! 1: LDUBA_I	lduba	[%r16, + 0x0372] %asi, %r29
	.word 0xe6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r19
	.word 0xc6442d38  ! 1: LDSW_I	ldsw	[%r16 + 0x0d38], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6d423b8  ! 1: LDSHA_I	ldsha	[%r16, + 0x03b8] %asi, %r3
	brnz %r31,thr3_loop_cnt_582
	dec %r31
	.word 0xb33c0002  ! 1: SRA_R	sra 	%r16, %r2, %r25
	.word 0xa5343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r18
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0xa73c0002  ! 1: SRA_R	sra 	%r16, %r2, %r19
        mov 0x12, %r31
thr3_loop_cnt_583:
	.word 0xde841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r15
	.word 0xe8942f6c  ! 1: LDUHA_I	lduha	[%r16, + 0x0f6c] %asi, %r20
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	.word 0xc6942db0  ! 1: LDUHA_I	lduha	[%r16, + 0x0db0] %asi, %r3
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xe6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r19
	.word 0xc6942740  ! 1: LDUHA_I	lduha	[%r16, + 0x0740] %asi, %r3
	.word 0xf4942b16  ! 1: LDUHA_I	lduha	[%r16, + 0x0b16] %asi, %r26
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	brnz %r31,thr3_loop_cnt_583
	dec %r31
	.word 0xb43c2256  ! 1: XNOR_I	xnor 	%r16, 0x0256, %r26
	.word 0x913c0002  ! 1: SRA_R	sra 	%r16, %r2, %r8
        mov 0x82, %r31
thr3_loop_cnt_584:
	.word 0xc6c429f8  ! 1: LDSWA_I	ldswa	[%r16, + 0x09f8] %asi, %r3
	.word 0xf0cc2f43  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f43] %asi, %r24
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xf0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r24
	.word 0xc60c2a87  ! 1: LDUB_I	ldub	[%r16 + 0x0a87], %r3
	.word 0xea0c206a  ! 1: LDUB_I	ldub	[%r16 + 0x006a], %r21
	.word 0xe8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r20
	.word 0xe45420da  ! 1: LDSH_I	ldsh	[%r16 + 0x00da], %r18
	brnz %r31,thr3_loop_cnt_584
	dec %r31
	.word 0xaa340002  ! 1: ORN_R	orn 	%r16, %r2, %r21
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x99341002  ! 1: SRLX_R	srlx	%r16, %r2, %r12
        mov 0x4b, %r31
thr3_loop_cnt_585:
	.word 0xc64c267a  ! 1: LDSB_I	ldsb	[%r16 + 0x067a], %r3
	.word 0xc6d42c3e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c3e] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc65c2768  ! 1: LDX_I	ldx	[%r16 + 0x0768], %r3
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xd08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r8
	.word 0xc6542e20  ! 1: LDSH_I	ldsh	[%r16 + 0x0e20], %r3
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	brnz %r31,thr3_loop_cnt_585
	dec %r31
	.word 0xba3c272e  ! 1: XNOR_I	xnor 	%r16, 0x072e, %r29
        mov 0xad, %r31
thr3_loop_cnt_586:
	.word 0xf60c27e5  ! 1: LDUB_I	ldub	[%r16 + 0x07e5], %r27
	.word 0xc6142042  ! 1: LDUH_I	lduh	[%r16 + 0x0042], %r3
	.word 0xc6dc2968  ! 1: LDXA_I	ldxa	[%r16, + 0x0968] %asi, %r3
	.word 0xd2942120  ! 1: LDUHA_I	lduha	[%r16, + 0x0120] %asi, %r9
	.word 0xd64c2ac6  ! 1: LDSB_I	ldsb	[%r16 + 0x0ac6], %r11
	.word 0xf6442a08  ! 1: LDSW_I	ldsw	[%r16 + 0x0a08], %r27
	.word 0xe2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r17
	.word 0xe8542388  ! 1: LDSH_I	ldsh	[%r16 + 0x0388], %r20
	.word 0xc6442ffc  ! 1: LDSW_I	ldsw	[%r16 + 0x0ffc], %r3
	brnz %r31,thr3_loop_cnt_586
	dec %r31
	.word 0xa6040002  ! 1: ADD_R	add 	%r16, %r2, %r19
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x1c, %r31
thr3_loop_cnt_587:
	.word 0xdadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r13
	.word 0xec142132  ! 1: LDUH_I	lduh	[%r16 + 0x0132], %r22
	.word 0xc6cc2cd2  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cd2] %asi, %r3
	.word 0xd8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r12
	.word 0xf8542ea2  ! 1: LDSH_I	ldsh	[%r16 + 0x0ea2], %r28
	.word 0xc69426f4  ! 1: LDUHA_I	lduha	[%r16, + 0x06f4] %asi, %r3
	.word 0xdadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r13
	.word 0xda540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r13
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6c42db0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0db0] %asi, %r3
	brnz %r31,thr3_loop_cnt_587
	dec %r31
	.word 0x862420c7  ! 1: SUB_I	sub 	%r16, 0x00c7, %r3
        mov 0x8f, %r31
thr3_loop_cnt_588:
	.word 0xd09420c0  ! 1: LDUHA_I	lduha	[%r16, + 0x00c0] %asi, %r8
	.word 0xe8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r20
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc694274a  ! 1: LDUHA_I	lduha	[%r16, + 0x074a] %asi, %r3
	.word 0xc6842248  ! 1: LDUWA_I	lduwa	[%r16, + 0x0248] %asi, %r3
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6842e7c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e7c] %asi, %r3
	.word 0xf4842aac  ! 1: LDUWA_I	lduwa	[%r16, + 0x0aac] %asi, %r26
	.word 0xf2dc2ea0  ! 1: LDXA_I	ldxa	[%r16, + 0x0ea0] %asi, %r25
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r24
	brnz %r31,thr3_loop_cnt_588
	dec %r31
	.word 0x86442c9a  ! 1: ADDC_I	addc 	%r16, 0x0c9a, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0x7e, %r31
thr3_loop_cnt_589:
	.word 0xc654213c  ! 1: LDSH_I	ldsh	[%r16 + 0x013c], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf0542af6  ! 1: LDSH_I	ldsh	[%r16 + 0x0af6], %r24
	.word 0xfacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r29
	.word 0xf0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r24
	.word 0xf2d42e16  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e16] %asi, %r25
	.word 0xc6942c42  ! 1: LDUHA_I	lduha	[%r16, + 0x0c42] %asi, %r3
	.word 0xc64420b0  ! 1: LDSW_I	ldsw	[%r16 + 0x00b0], %r3
	brnz %r31,thr3_loop_cnt_589
	dec %r31
	.word 0xa2240002  ! 1: SUB_R	sub 	%r16, %r2, %r17
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x922c2086  ! 1: ANDN_I	andn 	%r16, 0x0086, %r9
	.word 0x860c2e66  ! 1: AND_I	and 	%r16, 0x0e66, %r3
        mov 0x8b, %r31
thr3_loop_cnt_590:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r28
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	.word 0xd2042ddc  ! 1: LDUW_I	lduw	[%r16 + 0x0ddc], %r9
	.word 0xccc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r6
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd6542650  ! 1: LDSH_I	ldsh	[%r16 + 0x0650], %r11
	.word 0xc6842638  ! 1: LDUWA_I	lduwa	[%r16, + 0x0638] %asi, %r3
	brnz %r31,thr3_loop_cnt_590
	dec %r31
        mov 0x8c, %r31
thr3_loop_cnt_591:
	.word 0xde8429e8  ! 1: LDUWA_I	lduwa	[%r16, + 0x09e8] %asi, %r15
	.word 0xe48428fc  ! 1: LDUWA_I	lduwa	[%r16, + 0x08fc] %asi, %r18
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe60c2231  ! 1: LDUB_I	ldub	[%r16 + 0x0231], %r19
	.word 0xc6842ecc  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ecc] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xeedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r23
	.word 0xcc042d84  ! 1: LDUW_I	lduw	[%r16 + 0x0d84], %r6
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	brnz %r31,thr3_loop_cnt_591
	dec %r31
	.word 0x861c2572  ! 1: XOR_I	xor 	%r16, 0x0572, %r3
	.word 0xb83c2933  ! 1: XNOR_I	xnor 	%r16, 0x0933, %r28
	.word 0xb83c219a  ! 1: XNOR_I	xnor 	%r16, 0x019a, %r28
        mov 0x75, %r31
thr3_loop_cnt_592:
	.word 0xd854246e  ! 1: LDSH_I	ldsh	[%r16 + 0x046e], %r12
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xfc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r30
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd0942524  ! 1: LDUHA_I	lduha	[%r16, + 0x0524] %asi, %r8
	.word 0xc6042338  ! 1: LDUW_I	lduw	[%r16 + 0x0338], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xfc942eea  ! 1: LDUHA_I	lduha	[%r16, + 0x0eea] %asi, %r30
	brnz %r31,thr3_loop_cnt_592
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x922c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r9
        mov 0x20, %r31
thr3_loop_cnt_593:
	.word 0xc6d426f8  ! 1: LDSHA_I	ldsha	[%r16, + 0x06f8] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xee040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r23
	.word 0xf08c2be5  ! 1: LDUBA_I	lduba	[%r16, + 0x0be5] %asi, %r24
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_593
	dec %r31
	.word 0xa6342297  ! 1: ORN_I	orn 	%r16, 0x0297, %r19
        mov 0x38, %r31
thr3_loop_cnt_594:
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6c42128  ! 1: LDSWA_I	ldswa	[%r16, + 0x0128] %asi, %r3
	.word 0xfa942fcc  ! 1: LDUHA_I	lduha	[%r16, + 0x0fcc] %asi, %r29
	.word 0xfa4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r29
	.word 0xe2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r17
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xde542698  ! 1: LDSH_I	ldsh	[%r16 + 0x0698], %r15
	brnz %r31,thr3_loop_cnt_594
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x9d3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r14
	.word 0xaa340002  ! 1: ORN_R	orn 	%r16, %r2, %r21
        mov 0x44, %r31
thr3_loop_cnt_595:
	.word 0xfc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r30
	.word 0xc6dc26b0  ! 1: LDXA_I	ldxa	[%r16, + 0x06b0] %asi, %r3
	.word 0xc68c21c0  ! 1: LDUBA_I	lduba	[%r16, + 0x01c0] %asi, %r3
	.word 0xc6942ec6  ! 1: LDUHA_I	lduha	[%r16, + 0x0ec6] %asi, %r3
	.word 0xc64c23a3  ! 1: LDSB_I	ldsb	[%r16 + 0x03a3], %r3
	.word 0xd4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r10
	.word 0xec4c2d4a  ! 1: LDSB_I	ldsb	[%r16 + 0x0d4a], %r22
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	.word 0xec8c26a8  ! 1: LDUBA_I	lduba	[%r16, + 0x06a8] %asi, %r22
	.word 0xf0542d2a  ! 1: LDSH_I	ldsh	[%r16 + 0x0d2a], %r24
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd8dc2950  ! 1: LDXA_I	ldxa	[%r16, + 0x0950] %asi, %r12
	brnz %r31,thr3_loop_cnt_595
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0xbc3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r30
	.word 0x861c2a6d  ! 1: XOR_I	xor 	%r16, 0x0a6d, %r3
        mov 0xa4, %r31
thr3_loop_cnt_596:
	.word 0xf6842660  ! 1: LDUWA_I	lduwa	[%r16, + 0x0660] %asi, %r27
	.word 0xe8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r20
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd0c42340  ! 1: LDSWA_I	ldswa	[%r16, + 0x0340] %asi, %r8
	.word 0xc60c2541  ! 1: LDUB_I	ldub	[%r16 + 0x0541], %r3
	.word 0xf6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r27
	.word 0xeadc2200  ! 1: LDXA_I	ldxa	[%r16, + 0x0200] %asi, %r21
	.word 0xd61428aa  ! 1: LDUH_I	lduh	[%r16 + 0x08aa], %r11
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xeac42fb0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0fb0] %asi, %r21
	.word 0xc6d4273c  ! 1: LDSHA_I	ldsha	[%r16, + 0x073c] %asi, %r3
	brnz %r31,thr3_loop_cnt_596
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x863429d2  ! 1: ORN_I	orn 	%r16, 0x09d2, %r3
        mov 0x57, %r31
thr3_loop_cnt_597:
	.word 0xe6c42bfc  ! 1: LDSWA_I	ldswa	[%r16, + 0x0bfc] %asi, %r19
	.word 0xc64c2a43  ! 1: LDSB_I	ldsb	[%r16 + 0x0a43], %r3
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xdc0c255f  ! 1: LDUB_I	ldub	[%r16 + 0x055f], %r14
	.word 0xdc842040  ! 1: LDUWA_I	lduwa	[%r16, + 0x0040] %asi, %r14
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xdad4253c  ! 1: LDSHA_I	ldsha	[%r16, + 0x053c] %asi, %r13
	.word 0xea0c28d9  ! 1: LDUB_I	ldub	[%r16 + 0x08d9], %r21
	.word 0xc64c2ef2  ! 1: LDSB_I	ldsb	[%r16 + 0x0ef2], %r3
	brnz %r31,thr3_loop_cnt_597
	dec %r31
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x86342ec8  ! 1: SUBC_I	orn 	%r16, 0x0ec8, %r3
	.word 0xb0340002  ! 1: SUBC_R	orn 	%r16, %r2, %r24
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x6b, %r31
thr3_loop_cnt_598:
	.word 0xc60c2237  ! 1: LDUB_I	ldub	[%r16 + 0x0237], %r3
	.word 0xc68c27c3  ! 1: LDUBA_I	lduba	[%r16, + 0x07c3] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6d42ad0  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ad0] %asi, %r3
	.word 0xeed41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r23
	.word 0xfac42258  ! 1: LDSWA_I	ldswa	[%r16, + 0x0258] %asi, %r29
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6dc2298  ! 1: LDXA_I	ldxa	[%r16, + 0x0298] %asi, %r3
	.word 0xc60c2501  ! 1: LDUB_I	ldub	[%r16 + 0x0501], %r3
	brnz %r31,thr3_loop_cnt_598
	dec %r31
	.word 0x8d2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r6
	.word 0xb2242bf1  ! 1: SUB_I	sub 	%r16, 0x0bf1, %r25
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x912c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r8
        mov 0x4a, %r31
thr3_loop_cnt_599:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xce5c2890  ! 1: LDX_I	ldx	[%r16 + 0x0890], %r7
	.word 0xc68429ac  ! 1: LDUWA_I	lduwa	[%r16, + 0x09ac] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd8542f26  ! 1: LDSH_I	ldsh	[%r16 + 0x0f26], %r12
	.word 0xeec42b80  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b80] %asi, %r23
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	brnz %r31,thr3_loop_cnt_599
	dec %r31
	.word 0x862c2150  ! 1: ANDN_I	andn 	%r16, 0x0150, %r3
	.word 0x86242def  ! 1: SUB_I	sub 	%r16, 0x0def, %r3
	.word 0x8e342649  ! 1: ORN_I	orn 	%r16, 0x0649, %r7
        mov 0x3c, %r31
thr3_loop_cnt_600:
	.word 0xce5428bc  ! 1: LDSH_I	ldsh	[%r16 + 0x08bc], %r7
	.word 0xc6542b78  ! 1: LDSH_I	ldsh	[%r16 + 0x0b78], %r3
	.word 0xc68c2786  ! 1: LDUBA_I	lduba	[%r16, + 0x0786] %asi, %r3
	.word 0xc65c2550  ! 1: LDX_I	ldx	[%r16 + 0x0550], %r3
	.word 0xd0cc2ae8  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ae8] %asi, %r8
	.word 0xd6442a90  ! 1: LDSW_I	ldsw	[%r16 + 0x0a90], %r11
	.word 0xe4942c0e  ! 1: LDUHA_I	lduha	[%r16, + 0x0c0e] %asi, %r18
	.word 0xec5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r22
	.word 0xc64c2dc4  ! 1: LDSB_I	ldsb	[%r16 + 0x0dc4], %r3
	brnz %r31,thr3_loop_cnt_600
	dec %r31
	.word 0xb62c2f39  ! 1: ANDN_I	andn 	%r16, 0x0f39, %r27
	.word 0x860420c5  ! 1: ADD_I	add 	%r16, 0x00c5, %r3
        mov 0x82, %r31
thr3_loop_cnt_601:
	.word 0xda442c78  ! 1: LDSW_I	ldsw	[%r16 + 0x0c78], %r13
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xdcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r14
	.word 0xc6c4293c  ! 1: LDSWA_I	ldswa	[%r16, + 0x093c] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xfc0c22ba  ! 1: LDUB_I	ldub	[%r16 + 0x02ba], %r30
	.word 0xc6142126  ! 1: LDUH_I	lduh	[%r16 + 0x0126], %r3
	.word 0xe68c208d  ! 1: LDUBA_I	lduba	[%r16, + 0x008d] %asi, %r19
	.word 0xc64c21ab  ! 1: LDSB_I	ldsb	[%r16 + 0x01ab], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_601
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0xa7341002  ! 1: SRLX_R	srlx	%r16, %r2, %r19
	.word 0xb12c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r24
        mov 0x49, %r31
thr3_loop_cnt_602:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6042014  ! 1: LDUW_I	lduw	[%r16 + 0x0014], %r3
	.word 0xf48c263e  ! 1: LDUBA_I	lduba	[%r16, + 0x063e] %asi, %r26
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xde0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r15
	brnz %r31,thr3_loop_cnt_602
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0x51, %r31
thr3_loop_cnt_603:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xee0c239a  ! 1: LDUB_I	ldub	[%r16 + 0x039a], %r23
	.word 0xcccc2a44  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a44] %asi, %r6
	.word 0xdcd42a2e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a2e] %asi, %r14
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xccc42264  ! 1: LDSWA_I	ldswa	[%r16, + 0x0264] %asi, %r6
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	.word 0xfa4c2b52  ! 1: LDSB_I	ldsb	[%r16 + 0x0b52], %r29
	.word 0xdc0c21c8  ! 1: LDUB_I	ldub	[%r16 + 0x01c8], %r14
	brnz %r31,thr3_loop_cnt_603
	dec %r31
	.word 0xa7340002  ! 1: SRL_R	srl 	%r16, %r2, %r19
        mov 0xae, %r31
thr3_loop_cnt_604:
	.word 0xc64c232b  ! 1: LDSB_I	ldsb	[%r16 + 0x032b], %r3
	.word 0xc64c2261  ! 1: LDSB_I	ldsb	[%r16 + 0x0261], %r3
	.word 0xd6dc2d48  ! 1: LDXA_I	ldxa	[%r16, + 0x0d48] %asi, %r11
	.word 0xe24c2cb5  ! 1: LDSB_I	ldsb	[%r16 + 0x0cb5], %r17
	.word 0xea4c2c80  ! 1: LDSB_I	ldsb	[%r16 + 0x0c80], %r21
	.word 0xd2dc2c98  ! 1: LDXA_I	ldxa	[%r16, + 0x0c98] %asi, %r9
	.word 0xd2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r9
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_604
	dec %r31
	.word 0x863c2c48  ! 1: XNOR_I	xnor 	%r16, 0x0c48, %r3
	.word 0x9e3c2269  ! 1: XNOR_I	xnor 	%r16, 0x0269, %r15
        mov 0x5b, %r31
thr3_loop_cnt_605:
	.word 0xd05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r8
	.word 0xe6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r19
	.word 0xc694229e  ! 1: LDUHA_I	lduha	[%r16, + 0x029e] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xc60423e8  ! 1: LDUW_I	lduw	[%r16 + 0x03e8], %r3
	.word 0xea4c25f1  ! 1: LDSB_I	ldsb	[%r16 + 0x05f1], %r21
	.word 0xf4dc2828  ! 1: LDXA_I	ldxa	[%r16, + 0x0828] %asi, %r26
	.word 0xe2142372  ! 1: LDUH_I	lduh	[%r16 + 0x0372], %r17
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf0442020  ! 1: LDSW_I	ldsw	[%r16 + 0x0020], %r24
	brnz %r31,thr3_loop_cnt_605
	dec %r31
	.word 0x98240002  ! 1: SUB_R	sub 	%r16, %r2, %r12
	.word 0x9a3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r13
        mov 0x66, %r31
thr3_loop_cnt_606:
	.word 0xf8cc2e82  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e82] %asi, %r28
	.word 0xfc8427c4  ! 1: LDUWA_I	lduwa	[%r16, + 0x07c4] %asi, %r30
	.word 0xdc84230c  ! 1: LDUWA_I	lduwa	[%r16, + 0x030c] %asi, %r14
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6442364  ! 1: LDSW_I	ldsw	[%r16 + 0x0364], %r3
	.word 0xde842238  ! 1: LDUWA_I	lduwa	[%r16, + 0x0238] %asi, %r15
	.word 0xd0c421d8  ! 1: LDSWA_I	ldswa	[%r16, + 0x01d8] %asi, %r8
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	brnz %r31,thr3_loop_cnt_606
	dec %r31
        mov 0x25, %r31
thr3_loop_cnt_607:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6cc2ece  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ece] %asi, %r3
	.word 0xd0442664  ! 1: LDSW_I	ldsw	[%r16 + 0x0664], %r8
	.word 0xd0cc212d  ! 1: LDSBA_I	ldsba	[%r16, + 0x012d] %asi, %r8
	.word 0xc6c425ac  ! 1: LDSWA_I	ldswa	[%r16, + 0x05ac] %asi, %r3
	.word 0xcc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r6
	.word 0xdc4c2ea9  ! 1: LDSB_I	ldsb	[%r16 + 0x0ea9], %r14
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xc6c4235c  ! 1: LDSWA_I	ldswa	[%r16, + 0x035c] %asi, %r3
	.word 0xda440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r13
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_607
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0x97, %r31
thr3_loop_cnt_608:
	.word 0xc6442480  ! 1: LDSW_I	ldsw	[%r16 + 0x0480], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe65c2b88  ! 1: LDX_I	ldx	[%r16 + 0x0b88], %r19
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xde140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r15
	.word 0xf2442b8c  ! 1: LDSW_I	ldsw	[%r16 + 0x0b8c], %r25
	.word 0xdadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r13
	.word 0xce4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r7
	brnz %r31,thr3_loop_cnt_608
	dec %r31
        mov 0xa7, %r31
thr3_loop_cnt_609:
	.word 0xc6d42f8e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f8e] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6cc2a13  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a13] %asi, %r3
	.word 0xe4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r18
	.word 0xccd4231a  ! 1: LDSHA_I	ldsha	[%r16, + 0x031a] %asi, %r6
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe40c22df  ! 1: LDUB_I	ldub	[%r16 + 0x02df], %r18
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_609
	dec %r31
	.word 0x8c3422ec  ! 1: ORN_I	orn 	%r16, 0x02ec, %r6
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0xbb, %r31
thr3_loop_cnt_610:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc604275c  ! 1: LDUW_I	lduw	[%r16 + 0x075c], %r3
	.word 0xf00c2922  ! 1: LDUB_I	ldub	[%r16 + 0x0922], %r24
	.word 0xce4424cc  ! 1: LDSW_I	ldsw	[%r16 + 0x04cc], %r7
	.word 0xd4442c48  ! 1: LDSW_I	ldsw	[%r16 + 0x0c48], %r10
	.word 0xdacc23e4  ! 1: LDSBA_I	ldsba	[%r16, + 0x03e4] %asi, %r13
	.word 0xe8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r20
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_610
	dec %r31
	.word 0x98140002  ! 1: OR_R	or 	%r16, %r2, %r12
        mov 0x79, %r31
thr3_loop_cnt_611:
	.word 0xd4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r10
	.word 0xc60c2637  ! 1: LDUB_I	ldub	[%r16 + 0x0637], %r3
	.word 0xc6dc2f60  ! 1: LDXA_I	ldxa	[%r16, + 0x0f60] %asi, %r3
	.word 0xf20c2595  ! 1: LDUB_I	ldub	[%r16 + 0x0595], %r25
	.word 0xc6dc2650  ! 1: LDXA_I	ldxa	[%r16, + 0x0650] %asi, %r3
	.word 0xc6842e0c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e0c] %asi, %r3
	.word 0xde542676  ! 1: LDSH_I	ldsh	[%r16 + 0x0676], %r15
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xdcdc2f98  ! 1: LDXA_I	ldxa	[%r16, + 0x0f98] %asi, %r14
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_611
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x3b, %r31
thr3_loop_cnt_612:
	.word 0xc60422c0  ! 1: LDUW_I	lduw	[%r16 + 0x02c0], %r3
	.word 0xf09422a2  ! 1: LDUHA_I	lduha	[%r16, + 0x02a2] %asi, %r24
	.word 0xc6dc2288  ! 1: LDXA_I	ldxa	[%r16, + 0x0288] %asi, %r3
	.word 0xde8c2471  ! 1: LDUBA_I	lduba	[%r16, + 0x0471] %asi, %r15
	.word 0xe84c2727  ! 1: LDSB_I	ldsb	[%r16 + 0x0727], %r20
	.word 0xfc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r30
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6cc2219  ! 1: LDSBA_I	ldsba	[%r16, + 0x0219] %asi, %r3
	.word 0xf60c222f  ! 1: LDUB_I	ldub	[%r16 + 0x022f], %r27
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	brnz %r31,thr3_loop_cnt_612
	dec %r31
	.word 0x860c2ddd  ! 1: AND_I	and 	%r16, 0x0ddd, %r3
	.word 0xb1341002  ! 1: SRLX_R	srlx	%r16, %r2, %r24
        mov 0x6f, %r31
thr3_loop_cnt_613:
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xde942118  ! 1: LDUHA_I	lduha	[%r16, + 0x0118] %asi, %r15
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xfacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r29
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xda0c2739  ! 1: LDUB_I	ldub	[%r16 + 0x0739], %r13
	brnz %r31,thr3_loop_cnt_613
	dec %r31
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x20, %r31
thr3_loop_cnt_614:
	.word 0xc6142c38  ! 1: LDUH_I	lduh	[%r16 + 0x0c38], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r25
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf88c2ae3  ! 1: LDUBA_I	lduba	[%r16, + 0x0ae3] %asi, %r28
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6d42cca  ! 1: LDSHA_I	ldsha	[%r16, + 0x0cca] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd2cc22f2  ! 1: LDSBA_I	ldsba	[%r16, + 0x02f2] %asi, %r9
	.word 0xc65c2648  ! 1: LDX_I	ldx	[%r16 + 0x0648], %r3
	brnz %r31,thr3_loop_cnt_614
	dec %r31
	.word 0x86242aad  ! 1: SUB_I	sub 	%r16, 0x0aad, %r3
        mov 0xa1, %r31
thr3_loop_cnt_615:
	.word 0xf08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r24
	.word 0xfc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r30
	.word 0xda1425ce  ! 1: LDUH_I	lduh	[%r16 + 0x05ce], %r13
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd8442e9c  ! 1: LDSW_I	ldsw	[%r16 + 0x0e9c], %r12
	.word 0xc6c42010  ! 1: LDSWA_I	ldswa	[%r16, + 0x0010] %asi, %r3
	.word 0xea540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r21
	.word 0xfa442e00  ! 1: LDSW_I	ldsw	[%r16 + 0x0e00], %r29
	brnz %r31,thr3_loop_cnt_615
	dec %r31
	.word 0xab341002  ! 1: SRLX_R	srlx	%r16, %r2, %r21
        mov 0x4, %r31
thr3_loop_cnt_616:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xdc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r14
	.word 0xe8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r20
	.word 0xcc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r6
	.word 0xc6142436  ! 1: LDUH_I	lduh	[%r16 + 0x0436], %r3
	brnz %r31,thr3_loop_cnt_616
	dec %r31
	.word 0x86242e19  ! 1: SUB_I	sub 	%r16, 0x0e19, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x6b, %r31
thr3_loop_cnt_617:
	.word 0xd24c2071  ! 1: LDSB_I	ldsb	[%r16 + 0x0071], %r9
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xcec42f5c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f5c] %asi, %r7
	.word 0xf8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r28
	.word 0xc6942638  ! 1: LDUHA_I	lduha	[%r16, + 0x0638] %asi, %r3
	.word 0xfad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r29
	.word 0xd0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r8
	.word 0xc6442bb4  ! 1: LDSW_I	ldsw	[%r16 + 0x0bb4], %r3
	.word 0xd49421f4  ! 1: LDUHA_I	lduha	[%r16, + 0x01f4] %asi, %r10
	brnz %r31,thr3_loop_cnt_617
	dec %r31
	.word 0xb20c0002  ! 1: AND_R	and 	%r16, %r2, %r25
        mov 0xb7, %r31
thr3_loop_cnt_618:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd8dc2e90  ! 1: LDXA_I	ldxa	[%r16, + 0x0e90] %asi, %r12
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6dc2cd0  ! 1: LDXA_I	ldxa	[%r16, + 0x0cd0] %asi, %r3
	.word 0xc6942b18  ! 1: LDUHA_I	lduha	[%r16, + 0x0b18] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc65c29e8  ! 1: LDX_I	ldx	[%r16 + 0x09e8], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xeec42a5c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a5c] %asi, %r23
	.word 0xd2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r9
	.word 0xea941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r21
	brnz %r31,thr3_loop_cnt_618
	dec %r31
        mov 0x5e, %r31
thr3_loop_cnt_619:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r18
	.word 0xc60c2b08  ! 1: LDUB_I	ldub	[%r16 + 0x0b08], %r3
	.word 0xc64c2db6  ! 1: LDSB_I	ldsb	[%r16 + 0x0db6], %r3
	.word 0xf4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r26
	.word 0xd2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r9
	.word 0xce4c2fbc  ! 1: LDSB_I	ldsb	[%r16 + 0x0fbc], %r7
	brnz %r31,thr3_loop_cnt_619
	dec %r31
	.word 0x86342938  ! 1: ORN_I	orn 	%r16, 0x0938, %r3
	.word 0xb4340002  ! 1: SUBC_R	orn 	%r16, %r2, %r26
	.word 0xad340002  ! 1: SRL_R	srl 	%r16, %r2, %r22
        mov 0x93, %r31
thr3_loop_cnt_620:
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf4c424b0  ! 1: LDSWA_I	ldswa	[%r16, + 0x04b0] %asi, %r26
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6042d54  ! 1: LDUW_I	lduw	[%r16 + 0x0d54], %r3
	.word 0xcec42b70  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b70] %asi, %r7
	.word 0xf4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r26
	brnz %r31,thr3_loop_cnt_620
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x6c, %r31
thr3_loop_cnt_621:
	.word 0xec540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r22
	.word 0xf2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r25
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6542860  ! 1: LDSH_I	ldsh	[%r16 + 0x0860], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xc60c2141  ! 1: LDUB_I	ldub	[%r16 + 0x0141], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc68c22ee  ! 1: LDUBA_I	lduba	[%r16, + 0x02ee] %asi, %r3
	.word 0xced41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r7
	brnz %r31,thr3_loop_cnt_621
	dec %r31
        mov 0xb8, %r31
thr3_loop_cnt_622:
	.word 0xc6142374  ! 1: LDUH_I	lduh	[%r16 + 0x0374], %r3
	.word 0xc6842edc  ! 1: LDUWA_I	lduwa	[%r16, + 0x0edc] %asi, %r3
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xdecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r15
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xfc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r30
	.word 0xc6d429be  ! 1: LDSHA_I	ldsha	[%r16, + 0x09be] %asi, %r3
	.word 0xce4c26ca  ! 1: LDSB_I	ldsb	[%r16 + 0x06ca], %r7
	brnz %r31,thr3_loop_cnt_622
	dec %r31
	.word 0xa6340002  ! 1: SUBC_R	orn 	%r16, %r2, %r19
	.word 0x92142c04  ! 1: OR_I	or 	%r16, 0x0c04, %r9
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x9a0c0002  ! 1: AND_R	and 	%r16, %r2, %r13
        mov 0x6b, %r31
thr3_loop_cnt_623:
	.word 0xec4428cc  ! 1: LDSW_I	ldsw	[%r16 + 0x08cc], %r22
	.word 0xdec4205c  ! 1: LDSWA_I	ldswa	[%r16, + 0x005c] %asi, %r15
	.word 0xd4842cd8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0cd8] %asi, %r10
	.word 0xea4c25bb  ! 1: LDSB_I	ldsb	[%r16 + 0x05bb], %r21
	.word 0xfadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r29
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xfcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r30
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	brnz %r31,thr3_loop_cnt_623
	dec %r31
	.word 0x8f3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r7
        mov 0x54, %r31
thr3_loop_cnt_624:
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xde841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r15
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6442530  ! 1: LDSW_I	ldsw	[%r16 + 0x0530], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xec8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r22
	.word 0xdad42a58  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a58] %asi, %r13
	.word 0xc6dc2318  ! 1: LDXA_I	ldxa	[%r16, + 0x0318] %asi, %r3
	.word 0xe6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r19
	brnz %r31,thr3_loop_cnt_624
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x3, %r31
thr3_loop_cnt_625:
	.word 0xc6142332  ! 1: LDUH_I	lduh	[%r16 + 0x0332], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xfccc24f4  ! 1: LDSBA_I	ldsba	[%r16, + 0x04f4] %asi, %r30
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd45c20f0  ! 1: LDX_I	ldx	[%r16 + 0x00f0], %r10
	.word 0xf8142cfc  ! 1: LDUH_I	lduh	[%r16 + 0x0cfc], %r28
	.word 0xec540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r22
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd09422e2  ! 1: LDUHA_I	lduha	[%r16, + 0x02e2] %asi, %r8
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xc6dc2cd0  ! 1: LDXA_I	ldxa	[%r16, + 0x0cd0] %asi, %r3
	brnz %r31,thr3_loop_cnt_625
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x86242c7f  ! 1: SUB_I	sub 	%r16, 0x0c7f, %r3
	.word 0xa33c0002  ! 1: SRA_R	sra 	%r16, %r2, %r17
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x3b, %r31
thr3_loop_cnt_626:
	.word 0xe2442b8c  ! 1: LDSW_I	ldsw	[%r16 + 0x0b8c], %r17
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6942fd8  ! 1: LDUHA_I	lduha	[%r16, + 0x0fd8] %asi, %r3
	.word 0xc6d42688  ! 1: LDSHA_I	ldsha	[%r16, + 0x0688] %asi, %r3
	.word 0xeadc2270  ! 1: LDXA_I	ldxa	[%r16, + 0x0270] %asi, %r21
	.word 0xc684268c  ! 1: LDUWA_I	lduwa	[%r16, + 0x068c] %asi, %r3
	.word 0xc684219c  ! 1: LDUWA_I	lduwa	[%r16, + 0x019c] %asi, %r3
	.word 0xfad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r29
	.word 0xfc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r30
	brnz %r31,thr3_loop_cnt_626
	dec %r31
	.word 0x9b2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r13
	.word 0xab340002  ! 1: SRL_R	srl 	%r16, %r2, %r21
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x98340002  ! 1: ORN_R	orn 	%r16, %r2, %r12
        mov 0x70, %r31
thr3_loop_cnt_627:
	.word 0xc6dc2820  ! 1: LDXA_I	ldxa	[%r16, + 0x0820] %asi, %r3
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xc6042574  ! 1: LDUW_I	lduw	[%r16 + 0x0574], %r3
	.word 0xd2cc2eec  ! 1: LDSBA_I	ldsba	[%r16, + 0x0eec] %asi, %r9
	.word 0xc6dc2058  ! 1: LDXA_I	ldxa	[%r16, + 0x0058] %asi, %r3
	.word 0xf0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r24
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc68c22a6  ! 1: LDUBA_I	lduba	[%r16, + 0x02a6] %asi, %r3
	brnz %r31,thr3_loop_cnt_627
	dec %r31
	.word 0x98342baa  ! 1: SUBC_I	orn 	%r16, 0x0baa, %r12
        mov 0x92, %r31
thr3_loop_cnt_628:
	.word 0xce042560  ! 1: LDUW_I	lduw	[%r16 + 0x0560], %r7
	.word 0xec442260  ! 1: LDSW_I	ldsw	[%r16 + 0x0260], %r22
	.word 0xd6942a1a  ! 1: LDUHA_I	lduha	[%r16, + 0x0a1a] %asi, %r11
	.word 0xc6942128  ! 1: LDUHA_I	lduha	[%r16, + 0x0128] %asi, %r3
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xc68c2c0d  ! 1: LDUBA_I	lduba	[%r16, + 0x0c0d] %asi, %r3
	.word 0xc6c42b50  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b50] %asi, %r3
	.word 0xccdc26a8  ! 1: LDXA_I	ldxa	[%r16, + 0x06a8] %asi, %r6
	.word 0xecdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r22
	.word 0xfcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r30
	.word 0xc6142024  ! 1: LDUH_I	lduh	[%r16 + 0x0024], %r3
	brnz %r31,thr3_loop_cnt_628
	dec %r31
	.word 0x86142654  ! 1: OR_I	or 	%r16, 0x0654, %r3
        mov 0x8d, %r31
thr3_loop_cnt_629:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xde542d5c  ! 1: LDSH_I	ldsh	[%r16 + 0x0d5c], %r15
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r18
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xeecc2123  ! 1: LDSBA_I	ldsba	[%r16, + 0x0123] %asi, %r23
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_629
	dec %r31
	.word 0x8f3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r7
	.word 0x9c3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r14
        mov 0x33, %r31
thr3_loop_cnt_630:
	.word 0xe64c2407  ! 1: LDSB_I	ldsb	[%r16 + 0x0407], %r19
	.word 0xcccc2655  ! 1: LDSBA_I	ldsba	[%r16, + 0x0655] %asi, %r6
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc68c244e  ! 1: LDUBA_I	lduba	[%r16, + 0x044e] %asi, %r3
	.word 0xd4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r10
	.word 0xec140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r22
	.word 0xf24429a4  ! 1: LDSW_I	ldsw	[%r16 + 0x09a4], %r25
	.word 0xde14247a  ! 1: LDUH_I	lduh	[%r16 + 0x047a], %r15
	brnz %r31,thr3_loop_cnt_630
	dec %r31
        mov 0xa5, %r31
thr3_loop_cnt_631:
	.word 0xf44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r26
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xc6c420f4  ! 1: LDSWA_I	ldswa	[%r16, + 0x00f4] %asi, %r3
	.word 0xfc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r30
	.word 0xf84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r28
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe20427e4  ! 1: LDUW_I	lduw	[%r16 + 0x07e4], %r17
	.word 0xc69423e2  ! 1: LDUHA_I	lduha	[%r16, + 0x03e2] %asi, %r3
	.word 0xc6dc2238  ! 1: LDXA_I	ldxa	[%r16, + 0x0238] %asi, %r3
	.word 0xd054270e  ! 1: LDSH_I	ldsh	[%r16 + 0x070e], %r8
	brnz %r31,thr3_loop_cnt_631
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x76, %r31
thr3_loop_cnt_632:
	.word 0xc68c23a1  ! 1: LDUBA_I	lduba	[%r16, + 0x03a1] %asi, %r3
	.word 0xd2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r9
	.word 0xc6542932  ! 1: LDSH_I	ldsh	[%r16 + 0x0932], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xcc8c295e  ! 1: LDUBA_I	lduba	[%r16, + 0x095e] %asi, %r6
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r25
	brnz %r31,thr3_loop_cnt_632
	dec %r31
        mov 0x9, %r31
thr3_loop_cnt_633:
	.word 0xe2942b72  ! 1: LDUHA_I	lduha	[%r16, + 0x0b72] %asi, %r17
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xce0c2290  ! 1: LDUB_I	ldub	[%r16 + 0x0290], %r7
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe21423a0  ! 1: LDUH_I	lduh	[%r16 + 0x03a0], %r17
	.word 0xf4d42496  ! 1: LDSHA_I	ldsha	[%r16, + 0x0496] %asi, %r26
	.word 0xc6542254  ! 1: LDSH_I	ldsh	[%r16 + 0x0254], %r3
	.word 0xe8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r20
	brnz %r31,thr3_loop_cnt_633
	dec %r31
	.word 0x8614275e  ! 1: OR_I	or 	%r16, 0x075e, %r3
	.word 0xb80c0002  ! 1: AND_R	and 	%r16, %r2, %r28
        mov 0x65, %r31
thr3_loop_cnt_634:
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	.word 0xee440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r23
	.word 0xf25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r25
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6dc24b0  ! 1: LDXA_I	ldxa	[%r16, + 0x04b0] %asi, %r3
	.word 0xf0c42580  ! 1: LDSWA_I	ldswa	[%r16, + 0x0580] %asi, %r24
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	.word 0xe6dc2a70  ! 1: LDXA_I	ldxa	[%r16, + 0x0a70] %asi, %r19
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_634
	dec %r31
        mov 0x5a, %r31
thr3_loop_cnt_635:
	.word 0xc61425b6  ! 1: LDUH_I	lduh	[%r16 + 0x05b6], %r3
	.word 0xde5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r15
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6942504  ! 1: LDUHA_I	lduha	[%r16, + 0x0504] %asi, %r3
	.word 0xe28425f4  ! 1: LDUWA_I	lduwa	[%r16, + 0x05f4] %asi, %r17
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xee5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r23
	.word 0xd0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r8
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_635
	dec %r31
	.word 0x940c2633  ! 1: AND_I	and 	%r16, 0x0633, %r10
	.word 0x862c224c  ! 1: ANDN_I	andn 	%r16, 0x024c, %r3
	.word 0x861c2533  ! 1: XOR_I	xor 	%r16, 0x0533, %r3
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0xb9, %r31
thr3_loop_cnt_636:
	.word 0xeadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r21
	.word 0xe2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r17
	.word 0xc6d429c4  ! 1: LDSHA_I	ldsha	[%r16, + 0x09c4] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd88c2186  ! 1: LDUBA_I	lduba	[%r16, + 0x0186] %asi, %r12
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc65c2c00  ! 1: LDX_I	ldx	[%r16 + 0x0c00], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6dc2980  ! 1: LDXA_I	ldxa	[%r16, + 0x0980] %asi, %r3
	brnz %r31,thr3_loop_cnt_636
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x863c24cd  ! 1: XNOR_I	xnor 	%r16, 0x04cd, %r3
	.word 0x921c2f2b  ! 1: XOR_I	xor 	%r16, 0x0f2b, %r9
        mov 0xae, %r31
thr3_loop_cnt_637:
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xf8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r28
	.word 0xfc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r30
	.word 0xc65c2050  ! 1: LDX_I	ldx	[%r16 + 0x0050], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6842750  ! 1: LDUWA_I	lduwa	[%r16, + 0x0750] %asi, %r3
	.word 0xec8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r22
	brnz %r31,thr3_loop_cnt_637
	dec %r31
	.word 0x861422ff  ! 1: OR_I	or 	%r16, 0x02ff, %r3
        mov 0x3, %r31
thr3_loop_cnt_638:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xc6842660  ! 1: LDUWA_I	lduwa	[%r16, + 0x0660] %asi, %r3
	.word 0xd4cc22e7  ! 1: LDSBA_I	ldsba	[%r16, + 0x02e7] %asi, %r10
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	.word 0xc65421a4  ! 1: LDSH_I	ldsh	[%r16 + 0x01a4], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r24
	.word 0xc6cc2f4f  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f4f] %asi, %r3
	.word 0xcc8c2127  ! 1: LDUBA_I	lduba	[%r16, + 0x0127] %asi, %r6
	brnz %r31,thr3_loop_cnt_638
	dec %r31
	.word 0x9e3c291d  ! 1: XNOR_I	xnor 	%r16, 0x091d, %r15
	.word 0xbd3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r30
	.word 0x8e1427da  ! 1: OR_I	or 	%r16, 0x07da, %r7
        mov 0x8a, %r31
thr3_loop_cnt_639:
	.word 0xc60c2291  ! 1: LDUB_I	ldub	[%r16 + 0x0291], %r3
	.word 0xe84c29e9  ! 1: LDSB_I	ldsb	[%r16 + 0x09e9], %r20
	.word 0xc6cc25d1  ! 1: LDSBA_I	ldsba	[%r16, + 0x05d1] %asi, %r3
	.word 0xf2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r25
	.word 0xd65c2ea0  ! 1: LDX_I	ldx	[%r16 + 0x0ea0], %r11
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xce942938  ! 1: LDUHA_I	lduha	[%r16, + 0x0938] %asi, %r7
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc654285a  ! 1: LDSH_I	ldsh	[%r16 + 0x085a], %r3
	.word 0xc60c2a9d  ! 1: LDUB_I	ldub	[%r16 + 0x0a9d], %r3
	brnz %r31,thr3_loop_cnt_639
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x1a, %r31
thr3_loop_cnt_640:
	.word 0xeec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r23
	.word 0xfc5c20b8  ! 1: LDX_I	ldx	[%r16 + 0x00b8], %r30
	.word 0xee5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r23
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xfa94237a  ! 1: LDUHA_I	lduha	[%r16, + 0x037a] %asi, %r29
	.word 0xc68c2ee7  ! 1: LDUBA_I	lduba	[%r16, + 0x0ee7] %asi, %r3
	.word 0xd8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r12
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xc6c42b70  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b70] %asi, %r3
	.word 0xf8c42084  ! 1: LDSWA_I	ldswa	[%r16, + 0x0084] %asi, %r28
	brnz %r31,thr3_loop_cnt_640
	dec %r31
        mov 0x3c, %r31
thr3_loop_cnt_641:
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xe68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r19
	.word 0xd8542784  ! 1: LDSH_I	ldsh	[%r16 + 0x0784], %r12
	.word 0xf85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r28
	.word 0xf0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r24
	.word 0xfa5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r29
	.word 0xc60421d0  ! 1: LDUW_I	lduw	[%r16 + 0x01d0], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	brnz %r31,thr3_loop_cnt_641
	dec %r31
	.word 0xb41c0002  ! 1: XOR_R	xor 	%r16, %r2, %r26
        mov 0x57, %r31
thr3_loop_cnt_642:
	.word 0xc6542818  ! 1: LDSH_I	ldsh	[%r16 + 0x0818], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6cc227d  ! 1: LDSBA_I	ldsba	[%r16, + 0x027d] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf4cc2312  ! 1: LDSBA_I	ldsba	[%r16, + 0x0312] %asi, %r26
	.word 0xc65c26c0  ! 1: LDX_I	ldx	[%r16 + 0x06c0], %r3
	.word 0xc68420d8  ! 1: LDUWA_I	lduwa	[%r16, + 0x00d8] %asi, %r3
	.word 0xd4dc2dd8  ! 1: LDXA_I	ldxa	[%r16, + 0x0dd8] %asi, %r10
	.word 0xde442ce0  ! 1: LDSW_I	ldsw	[%r16 + 0x0ce0], %r15
	.word 0xec4c2cb9  ! 1: LDSB_I	ldsb	[%r16 + 0x0cb9], %r22
	brnz %r31,thr3_loop_cnt_642
	dec %r31
	.word 0x9444206a  ! 1: ADDC_I	addc 	%r16, 0x006a, %r10
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0xc6, %r31
thr3_loop_cnt_643:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xec042998  ! 1: LDUW_I	lduw	[%r16 + 0x0998], %r22
	.word 0xc6042638  ! 1: LDUW_I	lduw	[%r16 + 0x0638], %r3
	.word 0xc6842a84  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a84] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r27
	.word 0xc6c42a90  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a90] %asi, %r3
	.word 0xc6d42a62  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a62] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe2942b84  ! 1: LDUHA_I	lduha	[%r16, + 0x0b84] %asi, %r17
	brnz %r31,thr3_loop_cnt_643
	dec %r31
	.word 0x8c2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r6
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0xa8, %r31
thr3_loop_cnt_644:
	.word 0xdc5425a6  ! 1: LDSH_I	ldsh	[%r16 + 0x05a6], %r14
	.word 0xd64c2310  ! 1: LDSB_I	ldsb	[%r16 + 0x0310], %r11
	.word 0xcc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r6
	.word 0xf00c23c4  ! 1: LDUB_I	ldub	[%r16 + 0x03c4], %r24
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6c428e8  ! 1: LDSWA_I	ldswa	[%r16, + 0x08e8] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe44c2e1e  ! 1: LDSB_I	ldsb	[%r16 + 0x0e1e], %r18
	.word 0xda540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r13
	brnz %r31,thr3_loop_cnt_644
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0x30, %r31
thr3_loop_cnt_645:
	.word 0xc6dc20c8  ! 1: LDXA_I	ldxa	[%r16, + 0x00c8] %asi, %r3
	.word 0xc68c22e9  ! 1: LDUBA_I	lduba	[%r16, + 0x02e9] %asi, %r3
	.word 0xc694278a  ! 1: LDUHA_I	lduha	[%r16, + 0x078a] %asi, %r3
	.word 0xf4cc2cad  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cad] %asi, %r26
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	.word 0xf4942bc4  ! 1: LDUHA_I	lduha	[%r16, + 0x0bc4] %asi, %r26
	.word 0xd45c2290  ! 1: LDX_I	ldx	[%r16 + 0x0290], %r10
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe2542992  ! 1: LDSH_I	ldsh	[%r16 + 0x0992], %r17
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	.word 0xf05c2b98  ! 1: LDX_I	ldx	[%r16 + 0x0b98], %r24
	brnz %r31,thr3_loop_cnt_645
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0x97, %r31
thr3_loop_cnt_646:
	.word 0xc68c252b  ! 1: LDUBA_I	lduba	[%r16, + 0x052b] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf2042074  ! 1: LDUW_I	lduw	[%r16 + 0x0074], %r25
	.word 0xcc9429e8  ! 1: LDUHA_I	lduha	[%r16, + 0x09e8] %asi, %r6
	.word 0xe4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r18
	.word 0xea942dca  ! 1: LDUHA_I	lduha	[%r16, + 0x0dca] %asi, %r21
	.word 0xc68421ec  ! 1: LDUWA_I	lduwa	[%r16, + 0x01ec] %asi, %r3
	.word 0xe2cc2a27  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a27] %asi, %r17
	.word 0xc6cc2b5c  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b5c] %asi, %r3
	.word 0xc6dc2880  ! 1: LDXA_I	ldxa	[%r16, + 0x0880] %asi, %r3
	brnz %r31,thr3_loop_cnt_646
	dec %r31
	.word 0x98242d69  ! 1: SUB_I	sub 	%r16, 0x0d69, %r12
        mov 0x78, %r31
thr3_loop_cnt_647:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xda0c20ab  ! 1: LDUB_I	ldub	[%r16 + 0x00ab], %r13
	.word 0xd44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r10
	.word 0xc68420b0  ! 1: LDUWA_I	lduwa	[%r16, + 0x00b0] %asi, %r3
	.word 0xc68c21cb  ! 1: LDUBA_I	lduba	[%r16, + 0x01cb] %asi, %r3
	.word 0xc60423fc  ! 1: LDUW_I	lduw	[%r16 + 0x03fc], %r3
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xf2442ab4  ! 1: LDSW_I	ldsw	[%r16 + 0x0ab4], %r25
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r25
	.word 0xe40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r18
	brnz %r31,thr3_loop_cnt_647
	dec %r31
	.word 0xa6142752  ! 1: OR_I	or 	%r16, 0x0752, %r19
	.word 0x912c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r8
	.word 0xaf2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r23
        mov 0x64, %r31
thr3_loop_cnt_648:
	.word 0xd25c23c8  ! 1: LDX_I	ldx	[%r16 + 0x03c8], %r9
	.word 0xd6442208  ! 1: LDSW_I	ldsw	[%r16 + 0x0208], %r11
	.word 0xda042564  ! 1: LDUW_I	lduw	[%r16 + 0x0564], %r13
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	.word 0xd85422ee  ! 1: LDSH_I	ldsh	[%r16 + 0x02ee], %r12
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r19
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_648
	dec %r31
	.word 0x86142033  ! 1: OR_I	or 	%r16, 0x0033, %r3
	.word 0xad3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r22
        mov 0xb2, %r31
thr3_loop_cnt_649:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	.word 0xe2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r17
	.word 0xf08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r24
	.word 0xc6dc21c0  ! 1: LDXA_I	ldxa	[%r16, + 0x01c0] %asi, %r3
	.word 0xdc442b5c  ! 1: LDSW_I	ldsw	[%r16 + 0x0b5c], %r14
	.word 0xd68c2d71  ! 1: LDUBA_I	lduba	[%r16, + 0x0d71] %asi, %r11
	.word 0xe2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r17
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2202  ! 1: LDSBA_I	ldsba	[%r16, + 0x0202] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_649
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0xa9, %r31
thr3_loop_cnt_650:
	.word 0xe28c2112  ! 1: LDUBA_I	lduba	[%r16, + 0x0112] %asi, %r17
	.word 0xe2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r17
	.word 0xccc42830  ! 1: LDSWA_I	ldswa	[%r16, + 0x0830] %asi, %r6
	.word 0xc6cc2e06  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e06] %asi, %r3
	.word 0xd4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r10
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6842118  ! 1: LDUWA_I	lduwa	[%r16, + 0x0118] %asi, %r3
	.word 0xf8cc24bb  ! 1: LDSBA_I	ldsba	[%r16, + 0x04bb] %asi, %r28
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6842c48  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c48] %asi, %r3
	brnz %r31,thr3_loop_cnt_650
	dec %r31
	.word 0x86342e47  ! 1: SUBC_I	orn 	%r16, 0x0e47, %r3
        mov 0xb2, %r31
thr3_loop_cnt_651:
	.word 0xc6542bc8  ! 1: LDSH_I	ldsh	[%r16 + 0x0bc8], %r3
	.word 0xee540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r23
	.word 0xf6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r27
	.word 0xe8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r20
	.word 0xd6842f90  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f90] %asi, %r11
	.word 0xc6cc2b6f  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b6f] %asi, %r3
	.word 0xda440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r13
	.word 0xc6c42210  ! 1: LDSWA_I	ldswa	[%r16, + 0x0210] %asi, %r3
	.word 0xc60c26cb  ! 1: LDUB_I	ldub	[%r16 + 0x06cb], %r3
	.word 0xec841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r22
	.word 0xfc442d6c  ! 1: LDSW_I	ldsw	[%r16 + 0x0d6c], %r30
	.word 0xfa841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r29
	brnz %r31,thr3_loop_cnt_651
	dec %r31
	.word 0x863c2093  ! 1: XNOR_I	xnor 	%r16, 0x0093, %r3
	.word 0xb53c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r26
	.word 0xab2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r21
        mov 0x9f, %r31
thr3_loop_cnt_652:
	.word 0xda9424a2  ! 1: LDUHA_I	lduha	[%r16, + 0x04a2] %asi, %r13
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xc6442274  ! 1: LDSW_I	ldsw	[%r16 + 0x0274], %r3
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xc64c2123  ! 1: LDSB_I	ldsb	[%r16 + 0x0123], %r3
	.word 0xd6142e92  ! 1: LDUH_I	lduh	[%r16 + 0x0e92], %r11
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6dc2160  ! 1: LDXA_I	ldxa	[%r16, + 0x0160] %asi, %r3
	.word 0xc6cc2cb1  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cb1] %asi, %r3
	.word 0xfacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r29
	.word 0xc6942bce  ! 1: LDUHA_I	lduha	[%r16, + 0x0bce] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_652
	dec %r31
	.word 0x922c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r9
	.word 0x95341002  ! 1: SRLX_R	srlx	%r16, %r2, %r10
	.word 0x862c2d6c  ! 1: ANDN_I	andn 	%r16, 0x0d6c, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x52, %r31
thr3_loop_cnt_653:
	.word 0xf6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r27
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd644287c  ! 1: LDSW_I	ldsw	[%r16 + 0x087c], %r11
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	.word 0xd65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r11
	.word 0xf2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r25
	.word 0xee841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r23
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_653
	dec %r31
	.word 0x86442333  ! 1: ADDC_I	addc 	%r16, 0x0333, %r3
	.word 0x86342959  ! 1: SUBC_I	orn 	%r16, 0x0959, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x86142d9d  ! 1: OR_I	or 	%r16, 0x0d9d, %r3
        mov 0xa6, %r31
thr3_loop_cnt_654:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xded42fdc  ! 1: LDSHA_I	ldsha	[%r16, + 0x0fdc] %asi, %r15
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xe2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r17
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc68c2f67  ! 1: LDUBA_I	lduba	[%r16, + 0x0f67] %asi, %r3
	.word 0xea4425bc  ! 1: LDSW_I	ldsw	[%r16 + 0x05bc], %r21
	.word 0xce842fb4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0fb4] %asi, %r7
	.word 0xd4942306  ! 1: LDUHA_I	lduha	[%r16, + 0x0306] %asi, %r10
	brnz %r31,thr3_loop_cnt_654
	dec %r31
	.word 0xb0040002  ! 1: ADD_R	add 	%r16, %r2, %r24
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x2d, %r31
thr3_loop_cnt_655:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6d42446  ! 1: LDSHA_I	ldsha	[%r16, + 0x0446] %asi, %r3
	.word 0xd0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r8
	.word 0xe8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r20
	.word 0xc64c2e85  ! 1: LDSB_I	ldsb	[%r16 + 0x0e85], %r3
	.word 0xec1424a4  ! 1: LDUH_I	lduh	[%r16 + 0x04a4], %r22
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc65c2f80  ! 1: LDX_I	ldx	[%r16 + 0x0f80], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6c421bc  ! 1: LDSWA_I	ldswa	[%r16, + 0x01bc] %asi, %r3
	.word 0xec0c273f  ! 1: LDUB_I	ldub	[%r16 + 0x073f], %r22
	brnz %r31,thr3_loop_cnt_655
	dec %r31
	.word 0xa61c0002  ! 1: XOR_R	xor 	%r16, %r2, %r19
	.word 0x86442d17  ! 1: ADDC_I	addc 	%r16, 0x0d17, %r3
        mov 0x5a, %r31
thr3_loop_cnt_656:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	.word 0xc65c2698  ! 1: LDX_I	ldx	[%r16 + 0x0698], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc65c29f8  ! 1: LDX_I	ldx	[%r16 + 0x09f8], %r3
	.word 0xe25c2718  ! 1: LDX_I	ldx	[%r16 + 0x0718], %r17
	.word 0xf4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r26
	brnz %r31,thr3_loop_cnt_656
	dec %r31
	.word 0x940c0002  ! 1: AND_R	and 	%r16, %r2, %r10
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x86142c6c  ! 1: OR_I	or 	%r16, 0x0c6c, %r3
        mov 0x18, %r31
thr3_loop_cnt_657:
	.word 0xc64c25bc  ! 1: LDSB_I	ldsb	[%r16 + 0x05bc], %r3
	.word 0xd60c27d2  ! 1: LDUB_I	ldub	[%r16 + 0x07d2], %r11
	.word 0xc604295c  ! 1: LDUW_I	lduw	[%r16 + 0x095c], %r3
	.word 0xe84427d0  ! 1: LDSW_I	ldsw	[%r16 + 0x07d0], %r20
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc65c26a0  ! 1: LDX_I	ldx	[%r16 + 0x06a0], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc68422b0  ! 1: LDUWA_I	lduwa	[%r16, + 0x02b0] %asi, %r3
	.word 0xd2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r9
	.word 0xe4c42770  ! 1: LDSWA_I	ldswa	[%r16, + 0x0770] %asi, %r18
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	brnz %r31,thr3_loop_cnt_657
	dec %r31
	.word 0xa2340002  ! 1: ORN_R	orn 	%r16, %r2, %r17
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0xad341002  ! 1: SRLX_R	srlx	%r16, %r2, %r22
	.word 0x861c2385  ! 1: XOR_I	xor 	%r16, 0x0385, %r3
        mov 0x22, %r31
thr3_loop_cnt_658:
	.word 0xd84429a8  ! 1: LDSW_I	ldsw	[%r16 + 0x09a8], %r12
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc60426d4  ! 1: LDUW_I	lduw	[%r16 + 0x06d4], %r3
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	.word 0xe45c26f0  ! 1: LDX_I	ldx	[%r16 + 0x06f0], %r18
	brnz %r31,thr3_loop_cnt_658
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0xba042579  ! 1: ADD_I	add 	%r16, 0x0579, %r29
        mov 0x59, %r31
thr3_loop_cnt_659:
	.word 0xce8427f8  ! 1: LDUWA_I	lduwa	[%r16, + 0x07f8] %asi, %r7
	.word 0xc68c22bd  ! 1: LDUBA_I	lduba	[%r16, + 0x02bd] %asi, %r3
	.word 0xecdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r22
	.word 0xc60427bc  ! 1: LDUW_I	lduw	[%r16 + 0x07bc], %r3
	.word 0xc6c42424  ! 1: LDSWA_I	ldswa	[%r16, + 0x0424] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6c4290c  ! 1: LDSWA_I	ldswa	[%r16, + 0x090c] %asi, %r3
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	brnz %r31,thr3_loop_cnt_659
	dec %r31
        mov 0x7c, %r31
thr3_loop_cnt_660:
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xc60c2210  ! 1: LDUB_I	ldub	[%r16 + 0x0210], %r3
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xd84c2091  ! 1: LDSB_I	ldsb	[%r16 + 0x0091], %r12
	.word 0xc6cc2ac6  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ac6] %asi, %r3
	.word 0xdecc2e68  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e68] %asi, %r15
	.word 0xd80c294b  ! 1: LDUB_I	ldub	[%r16 + 0x094b], %r12
	.word 0xc60c2236  ! 1: LDUB_I	ldub	[%r16 + 0x0236], %r3
	brnz %r31,thr3_loop_cnt_660
	dec %r31
	.word 0x912c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r8
	.word 0x86342c9f  ! 1: SUBC_I	orn 	%r16, 0x0c9f, %r3
	.word 0x9c4427dc  ! 1: ADDC_I	addc 	%r16, 0x07dc, %r14
        mov 0x6e, %r31
thr3_loop_cnt_661:
	.word 0xd85c2b18  ! 1: LDX_I	ldx	[%r16 + 0x0b18], %r12
	.word 0xee8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r23
	.word 0xc6d42e94  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e94] %asi, %r3
	.word 0xd40c2086  ! 1: LDUB_I	ldub	[%r16 + 0x0086], %r10
	.word 0xc6dc28c0  ! 1: LDXA_I	ldxa	[%r16, + 0x08c0] %asi, %r3
	.word 0xfa8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r29
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r20
	.word 0xc6542314  ! 1: LDSH_I	ldsh	[%r16 + 0x0314], %r3
	brnz %r31,thr3_loop_cnt_661
	dec %r31
	.word 0x9234289e  ! 1: ORN_I	orn 	%r16, 0x089e, %r9
	.word 0x9a442b99  ! 1: ADDC_I	addc 	%r16, 0x0b99, %r13
        mov 0x10, %r31
thr3_loop_cnt_662:
	.word 0xc60c28aa  ! 1: LDUB_I	ldub	[%r16 + 0x08aa], %r3
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xfacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r29
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf25c2e58  ! 1: LDX_I	ldx	[%r16 + 0x0e58], %r25
	.word 0xe44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r18
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c42800  ! 1: LDSWA_I	ldswa	[%r16, + 0x0800] %asi, %r3
	.word 0xdcc420c0  ! 1: LDSWA_I	ldswa	[%r16, + 0x00c0] %asi, %r14
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_662
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x863c28f2  ! 1: XNOR_I	xnor 	%r16, 0x08f2, %r3
	.word 0xb60c204e  ! 1: AND_I	and 	%r16, 0x004e, %r27
        mov 0x94, %r31
thr3_loop_cnt_663:
	.word 0xc614233c  ! 1: LDUH_I	lduh	[%r16 + 0x033c], %r3
	.word 0xf2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r25
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc694263e  ! 1: LDUHA_I	lduha	[%r16, + 0x063e] %asi, %r3
	.word 0xf4cc210c  ! 1: LDSBA_I	ldsba	[%r16, + 0x010c] %asi, %r26
	.word 0xdad4207a  ! 1: LDSHA_I	ldsha	[%r16, + 0x007a] %asi, %r13
	.word 0xea4c2a9b  ! 1: LDSB_I	ldsb	[%r16 + 0x0a9b], %r21
	.word 0xf0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r24
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	.word 0xde542462  ! 1: LDSH_I	ldsh	[%r16 + 0x0462], %r15
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_663
	dec %r31
        mov 0xb1, %r31
thr3_loop_cnt_664:
	.word 0xf2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r25
	.word 0xd2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r9
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6542d9a  ! 1: LDSH_I	ldsh	[%r16 + 0x0d9a], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xce040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r7
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc65c2980  ! 1: LDX_I	ldx	[%r16 + 0x0980], %r3
	.word 0xeadc23b8  ! 1: LDXA_I	ldxa	[%r16, + 0x03b8] %asi, %r21
	brnz %r31,thr3_loop_cnt_664
	dec %r31
	.word 0x862c2ded  ! 1: ANDN_I	andn 	%r16, 0x0ded, %r3
	.word 0x860c26c5  ! 1: AND_I	and 	%r16, 0x06c5, %r3
	.word 0x861c2830  ! 1: XOR_I	xor 	%r16, 0x0830, %r3
	.word 0x90242fc1  ! 1: SUB_I	sub 	%r16, 0x0fc1, %r8
        mov 0xbd, %r31
thr3_loop_cnt_665:
	.word 0xc684252c  ! 1: LDUWA_I	lduwa	[%r16, + 0x052c] %asi, %r3
	.word 0xfccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r30
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6042e74  ! 1: LDUW_I	lduw	[%r16 + 0x0e74], %r3
	.word 0xde941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r15
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	.word 0xdc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r14
	.word 0xc65426e6  ! 1: LDSH_I	ldsh	[%r16 + 0x06e6], %r3
	.word 0xc6542322  ! 1: LDSH_I	ldsh	[%r16 + 0x0322], %r3
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xf2dc2a78  ! 1: LDXA_I	ldxa	[%r16, + 0x0a78] %asi, %r25
	brnz %r31,thr3_loop_cnt_665
	dec %r31
        mov 0x96, %r31
thr3_loop_cnt_666:
	.word 0xe4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r18
	.word 0xe20c2da0  ! 1: LDUB_I	ldub	[%r16 + 0x0da0], %r17
	.word 0xfa8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r29
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc68c2493  ! 1: LDUBA_I	lduba	[%r16, + 0x0493] %asi, %r3
	.word 0xd85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r12
	.word 0xf65c2ae0  ! 1: LDX_I	ldx	[%r16 + 0x0ae0], %r27
	.word 0xdc0c2e7b  ! 1: LDUB_I	ldub	[%r16 + 0x0e7b], %r14
	brnz %r31,thr3_loop_cnt_666
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x960c0002  ! 1: AND_R	and 	%r16, %r2, %r11
        mov 0x9e, %r31
thr3_loop_cnt_667:
	.word 0xf644267c  ! 1: LDSW_I	ldsw	[%r16 + 0x067c], %r27
	.word 0xea8426c4  ! 1: LDUWA_I	lduwa	[%r16, + 0x06c4] %asi, %r21
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xecd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r22
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	brnz %r31,thr3_loop_cnt_667
	dec %r31
        mov 0x21, %r31
thr3_loop_cnt_668:
	.word 0xc6842c84  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c84] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2609  ! 1: LDSBA_I	ldsba	[%r16, + 0x0609] %asi, %r3
	.word 0xc6442640  ! 1: LDSW_I	ldsw	[%r16 + 0x0640], %r3
	.word 0xe8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r20
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc68c2457  ! 1: LDUBA_I	lduba	[%r16, + 0x0457] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xda8c2733  ! 1: LDUBA_I	lduba	[%r16, + 0x0733] %asi, %r13
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_668
	dec %r31
	.word 0xb4240002  ! 1: SUB_R	sub 	%r16, %r2, %r26
	.word 0x91343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r8
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x860c2a98  ! 1: AND_I	and 	%r16, 0x0a98, %r3
        mov 0xb, %r31
thr3_loop_cnt_669:
	.word 0xf8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r28
	.word 0xee1427b8  ! 1: LDUH_I	lduh	[%r16 + 0x07b8], %r23
	.word 0xd85427cc  ! 1: LDSH_I	ldsh	[%r16 + 0x07cc], %r12
	.word 0xdc5c2a00  ! 1: LDX_I	ldx	[%r16 + 0x0a00], %r14
	.word 0xd0442a80  ! 1: LDSW_I	ldsw	[%r16 + 0x0a80], %r8
	.word 0xe80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r20
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r19
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd2942544  ! 1: LDUHA_I	lduha	[%r16, + 0x0544] %asi, %r9
	.word 0xc6cc27a4  ! 1: LDSBA_I	ldsba	[%r16, + 0x07a4] %asi, %r3
	brnz %r31,thr3_loop_cnt_669
	dec %r31
	.word 0x862c26e8  ! 1: ANDN_I	andn 	%r16, 0x06e8, %r3
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x861c2a8c  ! 1: XOR_I	xor 	%r16, 0x0a8c, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0xa, %r31
thr3_loop_cnt_670:
	.word 0xf84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r28
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xdedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r15
	.word 0xecd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r22
	.word 0xd2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r9
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xce440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r7
	.word 0xc6442998  ! 1: LDSW_I	ldsw	[%r16 + 0x0998], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_670
	dec %r31
	.word 0x86342439  ! 1: ORN_I	orn 	%r16, 0x0439, %r3
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x19, %r31
thr3_loop_cnt_671:
	.word 0xc6dc2ad0  ! 1: LDXA_I	ldxa	[%r16, + 0x0ad0] %asi, %r3
	.word 0xfcd42b94  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b94] %asi, %r30
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xea5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r21
	.word 0xec440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r22
	.word 0xc684240c  ! 1: LDUWA_I	lduwa	[%r16, + 0x040c] %asi, %r3
	.word 0xe84c20f8  ! 1: LDSB_I	ldsb	[%r16 + 0x00f8], %r20
	.word 0xc60c2b09  ! 1: LDUB_I	ldub	[%r16 + 0x0b09], %r3
	.word 0xdcdc2118  ! 1: LDXA_I	ldxa	[%r16, + 0x0118] %asi, %r14
	.word 0xc65c2940  ! 1: LDX_I	ldx	[%r16 + 0x0940], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6dc2808  ! 1: LDXA_I	ldxa	[%r16, + 0x0808] %asi, %r3
	brnz %r31,thr3_loop_cnt_671
	dec %r31
	.word 0x862c24e3  ! 1: ANDN_I	andn 	%r16, 0x04e3, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0xb7343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r27
        mov 0x14, %r31
thr3_loop_cnt_672:
	.word 0xc68424dc  ! 1: LDUWA_I	lduwa	[%r16, + 0x04dc] %asi, %r3
	.word 0xde0c2811  ! 1: LDUB_I	ldub	[%r16 + 0x0811], %r15
	.word 0xd6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r11
	.word 0xf08c2028  ! 1: LDUBA_I	lduba	[%r16, + 0x0028] %asi, %r24
	.word 0xc6d42328  ! 1: LDSHA_I	ldsha	[%r16, + 0x0328] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xe2142f3e  ! 1: LDUH_I	lduh	[%r16 + 0x0f3e], %r17
	.word 0xc60c2f31  ! 1: LDUB_I	ldub	[%r16 + 0x0f31], %r3
	.word 0xfc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r30
	.word 0xe84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r20
	brnz %r31,thr3_loop_cnt_672
	dec %r31
	.word 0x86342726  ! 1: ORN_I	orn 	%r16, 0x0726, %r3
	.word 0x943c20f8  ! 1: XNOR_I	xnor 	%r16, 0x00f8, %r10
        mov 0x9e, %r31
thr3_loop_cnt_673:
	.word 0xec942902  ! 1: LDUHA_I	lduha	[%r16, + 0x0902] %asi, %r22
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc64c29c8  ! 1: LDSB_I	ldsb	[%r16 + 0x09c8], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6442f60  ! 1: LDSW_I	ldsw	[%r16 + 0x0f60], %r3
	.word 0xdc14216c  ! 1: LDUH_I	lduh	[%r16 + 0x016c], %r14
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xce040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r7
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	.word 0xd45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r10
	.word 0xc6842384  ! 1: LDUWA_I	lduwa	[%r16, + 0x0384] %asi, %r3
	brnz %r31,thr3_loop_cnt_673
	dec %r31
	.word 0x86142d78  ! 1: OR_I	or 	%r16, 0x0d78, %r3
	.word 0x862c20c6  ! 1: ANDN_I	andn 	%r16, 0x00c6, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x40, %r31
thr3_loop_cnt_674:
	.word 0xce8c24a4  ! 1: LDUBA_I	lduba	[%r16, + 0x04a4] %asi, %r7
	.word 0xde040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r15
	.word 0xe4042d58  ! 1: LDUW_I	lduw	[%r16 + 0x0d58], %r18
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xdac42e78  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e78] %asi, %r13
	.word 0xe68c2bbe  ! 1: LDUBA_I	lduba	[%r16, + 0x0bbe] %asi, %r19
	.word 0xce4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r7
	.word 0xc60428cc  ! 1: LDUW_I	lduw	[%r16 + 0x08cc], %r3
	.word 0xe4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r18
	.word 0xc6842868  ! 1: LDUWA_I	lduwa	[%r16, + 0x0868] %asi, %r3
	.word 0xdedc2ff0  ! 1: LDXA_I	ldxa	[%r16, + 0x0ff0] %asi, %r15
	brnz %r31,thr3_loop_cnt_674
	dec %r31
        mov 0x42, %r31
thr3_loop_cnt_675:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf0942b36  ! 1: LDUHA_I	lduha	[%r16, + 0x0b36] %asi, %r24
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf004223c  ! 1: LDUW_I	lduw	[%r16 + 0x023c], %r24
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6c42a48  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a48] %asi, %r3
	.word 0xccdc2ed0  ! 1: LDXA_I	ldxa	[%r16, + 0x0ed0] %asi, %r6
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc65425a4  ! 1: LDSH_I	ldsh	[%r16 + 0x05a4], %r3
	brnz %r31,thr3_loop_cnt_675
	dec %r31
	.word 0x920428d9  ! 1: ADD_I	add 	%r16, 0x08d9, %r9
        mov 0x4a, %r31
thr3_loop_cnt_676:
	.word 0xc6042598  ! 1: LDUW_I	lduw	[%r16 + 0x0598], %r3
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	.word 0xfcdc2d08  ! 1: LDXA_I	ldxa	[%r16, + 0x0d08] %asi, %r30
	.word 0xf01421bc  ! 1: LDUH_I	lduh	[%r16 + 0x01bc], %r24
	.word 0xf4dc2738  ! 1: LDXA_I	ldxa	[%r16, + 0x0738] %asi, %r26
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf45c28c0  ! 1: LDX_I	ldx	[%r16 + 0x08c0], %r26
	.word 0xe8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r20
	.word 0xfad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r29
	brnz %r31,thr3_loop_cnt_676
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0xa8142f93  ! 1: OR_I	or 	%r16, 0x0f93, %r20
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0x45, %r31
thr3_loop_cnt_677:
	.word 0xf2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r25
	.word 0xc60c2016  ! 1: LDUB_I	ldub	[%r16 + 0x0016], %r3
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd4d42d9c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d9c] %asi, %r10
	.word 0xf8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r28
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xd6cc28f9  ! 1: LDSBA_I	ldsba	[%r16, + 0x08f9] %asi, %r11
	.word 0xe28c2736  ! 1: LDUBA_I	lduba	[%r16, + 0x0736] %asi, %r17
	.word 0xc6442c6c  ! 1: LDSW_I	ldsw	[%r16 + 0x0c6c], %r3
	brnz %r31,thr3_loop_cnt_677
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0x13, %r31
thr3_loop_cnt_678:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r19
	.word 0xd24c2414  ! 1: LDSB_I	ldsb	[%r16 + 0x0414], %r9
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xfc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r30
	.word 0xc6842d4c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d4c] %asi, %r3
	.word 0xced42ff0  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ff0] %asi, %r7
	.word 0xc68c2502  ! 1: LDUBA_I	lduba	[%r16, + 0x0502] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_678
	dec %r31
	.word 0x862c2edc  ! 1: ANDN_I	andn 	%r16, 0x0edc, %r3
        mov 0x6, %r31
thr3_loop_cnt_679:
	.word 0xfc4421b0  ! 1: LDSW_I	ldsw	[%r16 + 0x01b0], %r30
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc64c23f0  ! 1: LDSB_I	ldsb	[%r16 + 0x03f0], %r3
	.word 0xc64c288b  ! 1: LDSB_I	ldsb	[%r16 + 0x088b], %r3
	.word 0xf08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r24
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6042f4c  ! 1: LDUW_I	lduw	[%r16 + 0x0f4c], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_679
	dec %r31
	.word 0x860426db  ! 1: ADD_I	add 	%r16, 0x06db, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x8e3427aa  ! 1: SUBC_I	orn 	%r16, 0x07aa, %r7
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0x7b, %r31
thr3_loop_cnt_680:
	.word 0xc6dc2798  ! 1: LDXA_I	ldxa	[%r16, + 0x0798] %asi, %r3
	.word 0xd8542750  ! 1: LDSH_I	ldsh	[%r16 + 0x0750], %r12
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc64c22f3  ! 1: LDSB_I	ldsb	[%r16 + 0x02f3], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc60c2444  ! 1: LDUB_I	ldub	[%r16 + 0x0444], %r3
	.word 0xc65c2088  ! 1: LDX_I	ldx	[%r16 + 0x0088], %r3
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	brnz %r31,thr3_loop_cnt_680
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0xa52c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r18
	.word 0xb82c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r28
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0xc6, %r31
thr3_loop_cnt_681:
	.word 0xc6042fb0  ! 1: LDUW_I	lduw	[%r16 + 0x0fb0], %r3
	.word 0xc6042730  ! 1: LDUW_I	lduw	[%r16 + 0x0730], %r3
	.word 0xd6d42b52  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b52] %asi, %r11
	.word 0xc68c2fb0  ! 1: LDUBA_I	lduba	[%r16, + 0x0fb0] %asi, %r3
	.word 0xe64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r19
	.word 0xd0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r8
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r26
	.word 0xe8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r20
	.word 0xc65c2fa8  ! 1: LDX_I	ldx	[%r16 + 0x0fa8], %r3
	.word 0xf8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r28
	.word 0xe2442838  ! 1: LDSW_I	ldsw	[%r16 + 0x0838], %r17
	brnz %r31,thr3_loop_cnt_681
	dec %r31
        mov 0x21, %r31
thr3_loop_cnt_682:
	.word 0xc60c2206  ! 1: LDUB_I	ldub	[%r16 + 0x0206], %r3
	.word 0xf00c2e56  ! 1: LDUB_I	ldub	[%r16 + 0x0e56], %r24
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc64c2478  ! 1: LDSB_I	ldsb	[%r16 + 0x0478], %r3
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	.word 0xfa4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r29
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc60c298c  ! 1: LDUB_I	ldub	[%r16 + 0x098c], %r3
	brnz %r31,thr3_loop_cnt_682
	dec %r31
	.word 0xa93c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r20
	.word 0xb52c0002  ! 1: SLL_R	sll 	%r16, %r2, %r26
	.word 0xbc0c2baa  ! 1: AND_I	and 	%r16, 0x0baa, %r30
        mov 0x1d, %r31
thr3_loop_cnt_683:
	.word 0xc64c2cfb  ! 1: LDSB_I	ldsb	[%r16 + 0x0cfb], %r3
	.word 0xc6d42f4c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f4c] %asi, %r3
	.word 0xf2842fbc  ! 1: LDUWA_I	lduwa	[%r16, + 0x0fbc] %asi, %r25
	.word 0xc6842b30  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b30] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xee0c2f88  ! 1: LDUB_I	ldub	[%r16 + 0x0f88], %r23
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6442114  ! 1: LDSW_I	ldsw	[%r16 + 0x0114], %r3
	.word 0xd68c2e1c  ! 1: LDUBA_I	lduba	[%r16, + 0x0e1c] %asi, %r11
	brnz %r31,thr3_loop_cnt_683
	dec %r31
        mov 0x9c, %r31
thr3_loop_cnt_684:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf294285e  ! 1: LDUHA_I	lduha	[%r16, + 0x085e] %asi, %r25
	.word 0xdacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r13
	.word 0xe48c24e1  ! 1: LDUBA_I	lduba	[%r16, + 0x04e1] %asi, %r18
	.word 0xc6d42016  ! 1: LDSHA_I	ldsha	[%r16, + 0x0016] %asi, %r3
	.word 0xecdc2410  ! 1: LDXA_I	ldxa	[%r16, + 0x0410] %asi, %r22
	.word 0xf20427c4  ! 1: LDUW_I	lduw	[%r16 + 0x07c4], %r25
	.word 0xc65c2e98  ! 1: LDX_I	ldx	[%r16 + 0x0e98], %r3
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	.word 0xda94299e  ! 1: LDUHA_I	lduha	[%r16, + 0x099e] %asi, %r13
	brnz %r31,thr3_loop_cnt_684
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0x6d, %r31
thr3_loop_cnt_685:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6d4254a  ! 1: LDSHA_I	ldsha	[%r16, + 0x054a] %asi, %r3
	.word 0xd21428c4  ! 1: LDUH_I	lduh	[%r16 + 0x08c4], %r9
	.word 0xeacc2f5c  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f5c] %asi, %r21
	.word 0xc65c28a0  ! 1: LDX_I	ldx	[%r16 + 0x08a0], %r3
	.word 0xd2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r9
	.word 0xd69421f2  ! 1: LDUHA_I	lduha	[%r16, + 0x01f2] %asi, %r11
	.word 0xc6442ec0  ! 1: LDSW_I	ldsw	[%r16 + 0x0ec0], %r3
	.word 0xc68c2326  ! 1: LDUBA_I	lduba	[%r16, + 0x0326] %asi, %r3
	.word 0xdc1421cc  ! 1: LDUH_I	lduh	[%r16 + 0x01cc], %r14
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_685
	dec %r31
	.word 0x860c2c54  ! 1: AND_I	and 	%r16, 0x0c54, %r3
	.word 0xa22c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r17
        mov 0xb8, %r31
thr3_loop_cnt_686:
	.word 0xc6d42f2e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f2e] %asi, %r3
	.word 0xe2542c40  ! 1: LDSH_I	ldsh	[%r16 + 0x0c40], %r17
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xfcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r30
	.word 0xe4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r18
	.word 0xd8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r12
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf8042f08  ! 1: LDUW_I	lduw	[%r16 + 0x0f08], %r28
	brnz %r31,thr3_loop_cnt_686
	dec %r31
        mov 0xa2, %r31
thr3_loop_cnt_687:
	.word 0xe2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r17
	.word 0xce4c2727  ! 1: LDSB_I	ldsb	[%r16 + 0x0727], %r7
	.word 0xf65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r27
	.word 0xd48c2a06  ! 1: LDUBA_I	lduba	[%r16, + 0x0a06] %asi, %r10
	.word 0xc6d42240  ! 1: LDSHA_I	ldsha	[%r16, + 0x0240] %asi, %r3
	.word 0xc65c2930  ! 1: LDX_I	ldx	[%r16 + 0x0930], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xfa4c2978  ! 1: LDSB_I	ldsb	[%r16 + 0x0978], %r29
	.word 0xde440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r15
	.word 0xd0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r8
	.word 0xf25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r25
	.word 0xd4d422fe  ! 1: LDSHA_I	ldsha	[%r16, + 0x02fe] %asi, %r10
	brnz %r31,thr3_loop_cnt_687
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0xf, %r31
thr3_loop_cnt_688:
	.word 0xe48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r18
	.word 0xc6d42b6c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b6c] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r20
	.word 0xe25c2918  ! 1: LDX_I	ldx	[%r16 + 0x0918], %r17
	.word 0xd0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r8
	brnz %r31,thr3_loop_cnt_688
	dec %r31
	.word 0x8614257e  ! 1: OR_I	or 	%r16, 0x057e, %r3
        mov 0xba, %r31
thr3_loop_cnt_689:
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6142ff2  ! 1: LDUH_I	lduh	[%r16 + 0x0ff2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xce5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r7
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd25421c2  ! 1: LDSH_I	ldsh	[%r16 + 0x01c2], %r9
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_689
	dec %r31
	.word 0x8d340002  ! 1: SRL_R	srl 	%r16, %r2, %r6
        mov 0x8a, %r31
thr3_loop_cnt_690:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6042c38  ! 1: LDUW_I	lduw	[%r16 + 0x0c38], %r3
	.word 0xc6d4210a  ! 1: LDSHA_I	ldsha	[%r16, + 0x010a] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xdadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r13
	.word 0xc6042314  ! 1: LDUW_I	lduw	[%r16 + 0x0314], %r3
	.word 0xe8d42cfe  ! 1: LDSHA_I	ldsha	[%r16, + 0x0cfe] %asi, %r20
	.word 0xce542a4c  ! 1: LDSH_I	ldsh	[%r16 + 0x0a4c], %r7
	.word 0xfc8c2cb5  ! 1: LDUBA_I	lduba	[%r16, + 0x0cb5] %asi, %r30
	brnz %r31,thr3_loop_cnt_690
	dec %r31
	.word 0x8d2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r6
	.word 0x86242e3c  ! 1: SUB_I	sub 	%r16, 0x0e3c, %r3
        mov 0x3a, %r31
thr3_loop_cnt_691:
	.word 0xf4942fde  ! 1: LDUHA_I	lduha	[%r16, + 0x0fde] %asi, %r26
	.word 0xf6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r27
	.word 0xc6542e1e  ! 1: LDSH_I	ldsh	[%r16 + 0x0e1e], %r3
	.word 0xea542150  ! 1: LDSH_I	ldsh	[%r16 + 0x0150], %r21
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf2842528  ! 1: LDUWA_I	lduwa	[%r16, + 0x0528] %asi, %r25
	.word 0xc6c429d0  ! 1: LDSWA_I	ldswa	[%r16, + 0x09d0] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_691
	dec %r31
        mov 0x87, %r31
thr3_loop_cnt_692:
	.word 0xd05c2158  ! 1: LDX_I	ldx	[%r16 + 0x0158], %r8
	.word 0xc644277c  ! 1: LDSW_I	ldsw	[%r16 + 0x077c], %r3
	.word 0xce942076  ! 1: LDUHA_I	lduha	[%r16, + 0x0076] %asi, %r7
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r10
	.word 0xee8c2977  ! 1: LDUBA_I	lduba	[%r16, + 0x0977] %asi, %r23
	.word 0xda042d48  ! 1: LDUW_I	lduw	[%r16 + 0x0d48], %r13
	.word 0xcc5c2908  ! 1: LDX_I	ldx	[%r16 + 0x0908], %r6
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_692
	dec %r31
	.word 0x86342531  ! 1: ORN_I	orn 	%r16, 0x0531, %r3
        mov 0x31, %r31
thr3_loop_cnt_693:
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	.word 0xc68c2dec  ! 1: LDUBA_I	lduba	[%r16, + 0x0dec] %asi, %r3
	.word 0xd44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r10
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	.word 0xc68c2169  ! 1: LDUBA_I	lduba	[%r16, + 0x0169] %asi, %r3
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xe6542c60  ! 1: LDSH_I	ldsh	[%r16 + 0x0c60], %r19
	.word 0xd4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r10
	brnz %r31,thr3_loop_cnt_693
	dec %r31
        mov 0x9e, %r31
thr3_loop_cnt_694:
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	.word 0xd8042db0  ! 1: LDUW_I	lduw	[%r16 + 0x0db0], %r12
	.word 0xc6942fc2  ! 1: LDUHA_I	lduha	[%r16, + 0x0fc2] %asi, %r3
	.word 0xe6842628  ! 1: LDUWA_I	lduwa	[%r16, + 0x0628] %asi, %r19
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc65c2f90  ! 1: LDX_I	ldx	[%r16 + 0x0f90], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc65424aa  ! 1: LDSH_I	ldsh	[%r16 + 0x04aa], %r3
	.word 0xc60c2b1e  ! 1: LDUB_I	ldub	[%r16 + 0x0b1e], %r3
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xf8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r28
	.word 0xe4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r18
	brnz %r31,thr3_loop_cnt_694
	dec %r31
	.word 0xb21c20e3  ! 1: XOR_I	xor 	%r16, 0x00e3, %r25
        mov 0xa7, %r31
thr3_loop_cnt_695:
	.word 0xc6942e8c  ! 1: LDUHA_I	lduha	[%r16, + 0x0e8c] %asi, %r3
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	.word 0xd0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r8
	.word 0xc6cc2367  ! 1: LDSBA_I	ldsba	[%r16, + 0x0367] %asi, %r3
	.word 0xc6c423d8  ! 1: LDSWA_I	ldswa	[%r16, + 0x03d8] %asi, %r3
	.word 0xc6c4256c  ! 1: LDSWA_I	ldswa	[%r16, + 0x056c] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe6942c6a  ! 1: LDUHA_I	lduha	[%r16, + 0x0c6a] %asi, %r19
	brnz %r31,thr3_loop_cnt_695
	dec %r31
	.word 0x942c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r10
        mov 0x67, %r31
thr3_loop_cnt_696:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xc65c2970  ! 1: LDX_I	ldx	[%r16 + 0x0970], %r3
	.word 0xd08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r8
	.word 0xc6cc2de7  ! 1: LDSBA_I	ldsba	[%r16, + 0x0de7] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xee4c28fe  ! 1: LDSB_I	ldsb	[%r16 + 0x08fe], %r23
	.word 0xc60c2577  ! 1: LDUB_I	ldub	[%r16 + 0x0577], %r3
	.word 0xd01428a2  ! 1: LDUH_I	lduh	[%r16 + 0x08a2], %r8
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd094285e  ! 1: LDUHA_I	lduha	[%r16, + 0x085e] %asi, %r8
	brnz %r31,thr3_loop_cnt_696
	dec %r31
        mov 0x1d, %r31
thr3_loop_cnt_697:
	.word 0xf68c2dbf  ! 1: LDUBA_I	lduba	[%r16, + 0x0dbf] %asi, %r27
	.word 0xc68c2797  ! 1: LDUBA_I	lduba	[%r16, + 0x0797] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6842b58  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b58] %asi, %r3
	.word 0xc6142852  ! 1: LDUH_I	lduh	[%r16 + 0x0852], %r3
	.word 0xf6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r27
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6542ef6  ! 1: LDSH_I	ldsh	[%r16 + 0x0ef6], %r3
	brnz %r31,thr3_loop_cnt_697
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0x0, %r31
thr3_loop_cnt_698:
	.word 0xf8042dd8  ! 1: LDUW_I	lduw	[%r16 + 0x0dd8], %r28
	.word 0xc6442f7c  ! 1: LDSW_I	ldsw	[%r16 + 0x0f7c], %r3
	.word 0xc6c4241c  ! 1: LDSWA_I	ldswa	[%r16, + 0x041c] %asi, %r3
	.word 0xe8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r20
	.word 0xeecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r23
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf45c2a40  ! 1: LDX_I	ldx	[%r16 + 0x0a40], %r26
	.word 0xc65c28e8  ! 1: LDX_I	ldx	[%r16 + 0x08e8], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_698
	dec %r31
	.word 0xa8140002  ! 1: OR_R	or 	%r16, %r2, %r20
	.word 0x8c3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r6
        mov 0x52, %r31
thr3_loop_cnt_699:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6cc2e3e  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e3e] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xfccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r30
	.word 0xf68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r27
	.word 0xdc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r14
	.word 0xc6c429d0  ! 1: LDSWA_I	ldswa	[%r16, + 0x09d0] %asi, %r3
	.word 0xf8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r28
	.word 0xdc542732  ! 1: LDSH_I	ldsh	[%r16 + 0x0732], %r14
	brnz %r31,thr3_loop_cnt_699
	dec %r31
	.word 0x8c040002  ! 1: ADD_R	add 	%r16, %r2, %r6
        mov 0xab, %r31
thr3_loop_cnt_700:
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf84c2de2  ! 1: LDSB_I	ldsb	[%r16 + 0x0de2], %r28
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc60c205e  ! 1: LDUB_I	ldub	[%r16 + 0x005e], %r3
	.word 0xdecc20e2  ! 1: LDSBA_I	ldsba	[%r16, + 0x00e2] %asi, %r15
	.word 0xe2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r17
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xee142c72  ! 1: LDUH_I	lduh	[%r16 + 0x0c72], %r23
	.word 0xe454203c  ! 1: LDSH_I	ldsh	[%r16 + 0x003c], %r18
	brnz %r31,thr3_loop_cnt_700
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x52, %r31
thr3_loop_cnt_701:
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	.word 0xc6cc24df  ! 1: LDSBA_I	ldsba	[%r16, + 0x04df] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc65c2248  ! 1: LDX_I	ldx	[%r16 + 0x0248], %r3
	.word 0xe4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r18
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf41420e6  ! 1: LDUH_I	lduh	[%r16 + 0x00e6], %r26
	.word 0xd2dc2d58  ! 1: LDXA_I	ldxa	[%r16, + 0x0d58] %asi, %r9
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xe4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r18
	.word 0xd8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r12
	brnz %r31,thr3_loop_cnt_701
	dec %r31
        mov 0xc7, %r31
thr3_loop_cnt_702:
	.word 0xc64c24ea  ! 1: LDSB_I	ldsb	[%r16 + 0x04ea], %r3
	.word 0xd85c2200  ! 1: LDX_I	ldx	[%r16 + 0x0200], %r12
	.word 0xdc942a72  ! 1: LDUHA_I	lduha	[%r16, + 0x0a72] %asi, %r14
	.word 0xd2042344  ! 1: LDUW_I	lduw	[%r16 + 0x0344], %r9
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xda0429a4  ! 1: LDUW_I	lduw	[%r16 + 0x09a4], %r13
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6042328  ! 1: LDUW_I	lduw	[%r16 + 0x0328], %r3
	.word 0xc6442658  ! 1: LDSW_I	ldsw	[%r16 + 0x0658], %r3
	brnz %r31,thr3_loop_cnt_702
	dec %r31
	.word 0xa2140002  ! 1: OR_R	or 	%r16, %r2, %r17
        mov 0x84, %r31
thr3_loop_cnt_703:
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xc65c2c40  ! 1: LDX_I	ldx	[%r16 + 0x0c40], %r3
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xec4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r22
	.word 0xe2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r17
	.word 0xe24c22c0  ! 1: LDSB_I	ldsb	[%r16 + 0x02c0], %r17
	.word 0xeecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r23
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_703
	dec %r31
        mov 0xb3, %r31
thr3_loop_cnt_704:
	.word 0xecdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r22
	.word 0xfac42564  ! 1: LDSWA_I	ldswa	[%r16, + 0x0564] %asi, %r29
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc69421d0  ! 1: LDUHA_I	lduha	[%r16, + 0x01d0] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6142de6  ! 1: LDUH_I	lduh	[%r16 + 0x0de6], %r3
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xc65c2500  ! 1: LDX_I	ldx	[%r16 + 0x0500], %r3
	.word 0xe6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r19
	.word 0xfa841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r29
	brnz %r31,thr3_loop_cnt_704
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x860c2b94  ! 1: AND_I	and 	%r16, 0x0b94, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0xc6, %r31
thr3_loop_cnt_705:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf20c2412  ! 1: LDUB_I	ldub	[%r16 + 0x0412], %r25
	.word 0xf0442d1c  ! 1: LDSW_I	ldsw	[%r16 + 0x0d1c], %r24
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	.word 0xc65c23f8  ! 1: LDX_I	ldx	[%r16 + 0x03f8], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf44c2230  ! 1: LDSB_I	ldsb	[%r16 + 0x0230], %r26
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xde0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r15
	.word 0xc6142eea  ! 1: LDUH_I	lduh	[%r16 + 0x0eea], %r3
	.word 0xee8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r23
	brnz %r31,thr3_loop_cnt_705
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0x70, %r31
thr3_loop_cnt_706:
	.word 0xe2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r17
	.word 0xe60c2fe3  ! 1: LDUB_I	ldub	[%r16 + 0x0fe3], %r19
	.word 0xda4c2f9c  ! 1: LDSB_I	ldsb	[%r16 + 0x0f9c], %r13
	.word 0xce9427c0  ! 1: LDUHA_I	lduha	[%r16, + 0x07c0] %asi, %r7
	.word 0xe2842db4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0db4] %asi, %r17
	.word 0xc654226e  ! 1: LDSH_I	ldsh	[%r16 + 0x026e], %r3
	.word 0xce442768  ! 1: LDSW_I	ldsw	[%r16 + 0x0768], %r7
	.word 0xc6d42174  ! 1: LDSHA_I	ldsha	[%r16, + 0x0174] %asi, %r3
	.word 0xcc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r6
	.word 0xc6142e1c  ! 1: LDUH_I	lduh	[%r16 + 0x0e1c], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xda942262  ! 1: LDUHA_I	lduha	[%r16, + 0x0262] %asi, %r13
	brnz %r31,thr3_loop_cnt_706
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x4a, %r31
thr3_loop_cnt_707:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6c42ae0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ae0] %asi, %r3
	.word 0xc68c25c2  ! 1: LDUBA_I	lduba	[%r16, + 0x05c2] %asi, %r3
	.word 0xfc9429ca  ! 1: LDUHA_I	lduha	[%r16, + 0x09ca] %asi, %r30
	.word 0xd6942312  ! 1: LDUHA_I	lduha	[%r16, + 0x0312] %asi, %r11
	.word 0xc68c29c8  ! 1: LDUBA_I	lduba	[%r16, + 0x09c8] %asi, %r3
	.word 0xec040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r22
	.word 0xfcc42d68  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d68] %asi, %r30
	.word 0xf68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r27
	brnz %r31,thr3_loop_cnt_707
	dec %r31
	.word 0xb20c2933  ! 1: AND_I	and 	%r16, 0x0933, %r25
        mov 0x41, %r31
thr3_loop_cnt_708:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf64c2c4e  ! 1: LDSB_I	ldsb	[%r16 + 0x0c4e], %r27
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf45c2568  ! 1: LDX_I	ldx	[%r16 + 0x0568], %r26
	.word 0xc60c2a85  ! 1: LDUB_I	ldub	[%r16 + 0x0a85], %r3
	.word 0xc6c420bc  ! 1: LDSWA_I	ldswa	[%r16, + 0x00bc] %asi, %r3
	.word 0xee540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r23
	.word 0xe6942dc0  ! 1: LDUHA_I	lduha	[%r16, + 0x0dc0] %asi, %r19
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	brnz %r31,thr3_loop_cnt_708
	dec %r31
	.word 0xa6140002  ! 1: OR_R	or 	%r16, %r2, %r19
	.word 0x861420b7  ! 1: OR_I	or 	%r16, 0x00b7, %r3
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x18, %r31
thr3_loop_cnt_709:
	.word 0xc6dc24a8  ! 1: LDXA_I	ldxa	[%r16, + 0x04a8] %asi, %r3
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r20
	.word 0xe88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r20
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6442cf0  ! 1: LDSW_I	ldsw	[%r16 + 0x0cf0], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_709
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0xb4040002  ! 1: ADD_R	add 	%r16, %r2, %r26
	.word 0x960c2f9f  ! 1: AND_I	and 	%r16, 0x0f9f, %r11
        mov 0xc7, %r31
thr3_loop_cnt_710:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xd65c2a88  ! 1: LDX_I	ldx	[%r16 + 0x0a88], %r11
	.word 0xde542d0a  ! 1: LDSH_I	ldsh	[%r16 + 0x0d0a], %r15
	.word 0xe8442310  ! 1: LDSW_I	ldsw	[%r16 + 0x0310], %r20
	.word 0xc6042140  ! 1: LDUW_I	lduw	[%r16 + 0x0140], %r3
	.word 0xeccc2c91  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c91] %asi, %r22
	.word 0xc6dc2e60  ! 1: LDXA_I	ldxa	[%r16, + 0x0e60] %asi, %r3
	.word 0xc6842708  ! 1: LDUWA_I	lduwa	[%r16, + 0x0708] %asi, %r3
	brnz %r31,thr3_loop_cnt_710
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0xb73c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r27
        mov 0x1c, %r31
thr3_loop_cnt_711:
	.word 0xdc842288  ! 1: LDUWA_I	lduwa	[%r16, + 0x0288] %asi, %r14
	.word 0xf6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r27
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	.word 0xd28c27dd  ! 1: LDUBA_I	lduba	[%r16, + 0x07dd] %asi, %r9
	.word 0xdecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r15
	.word 0xc6142592  ! 1: LDUH_I	lduh	[%r16 + 0x0592], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xf0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r24
	.word 0xd0142d0c  ! 1: LDUH_I	lduh	[%r16 + 0x0d0c], %r8
	brnz %r31,thr3_loop_cnt_711
	dec %r31
        mov 0x64, %r31
thr3_loop_cnt_712:
	.word 0xc6d4290e  ! 1: LDSHA_I	ldsha	[%r16, + 0x090e] %asi, %r3
	.word 0xd00c29f7  ! 1: LDUB_I	ldub	[%r16 + 0x09f7], %r8
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xcc0c252f  ! 1: LDUB_I	ldub	[%r16 + 0x052f], %r6
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc65c2ac8  ! 1: LDX_I	ldx	[%r16 + 0x0ac8], %r3
	.word 0xdad42162  ! 1: LDSHA_I	ldsha	[%r16, + 0x0162] %asi, %r13
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf41429cc  ! 1: LDUH_I	lduh	[%r16 + 0x09cc], %r26
	brnz %r31,thr3_loop_cnt_712
	dec %r31
	.word 0x8f3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r7
	.word 0x861c2e99  ! 1: XOR_I	xor 	%r16, 0x0e99, %r3
	.word 0x860c2912  ! 1: AND_I	and 	%r16, 0x0912, %r3
	.word 0xa93c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r20
        mov 0xb3, %r31
thr3_loop_cnt_713:
	.word 0xea5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r21
	.word 0xd0cc2ba2  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ba2] %asi, %r8
	.word 0xfc0c2738  ! 1: LDUB_I	ldub	[%r16 + 0x0738], %r30
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r10
	.word 0xecdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r22
	.word 0xe8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r20
	.word 0xd4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r10
	.word 0xf04c2955  ! 1: LDSB_I	ldsb	[%r16 + 0x0955], %r24
	.word 0xc6c42be4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0be4] %asi, %r3
	.word 0xd84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r12
	brnz %r31,thr3_loop_cnt_713
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x9b3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r13
	.word 0x9c342df3  ! 1: ORN_I	orn 	%r16, 0x0df3, %r14
	.word 0x86442b2a  ! 1: ADDC_I	addc 	%r16, 0x0b2a, %r3
        mov 0x10, %r31
thr3_loop_cnt_714:
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xe2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r17
	.word 0xe4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r18
	.word 0xc6142762  ! 1: LDUH_I	lduh	[%r16 + 0x0762], %r3
	.word 0xdcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r14
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xf48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r26
	.word 0xfc94232a  ! 1: LDUHA_I	lduha	[%r16, + 0x032a] %asi, %r30
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xdc442f58  ! 1: LDSW_I	ldsw	[%r16 + 0x0f58], %r14
	.word 0xec540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r22
	brnz %r31,thr3_loop_cnt_714
	dec %r31
	.word 0x942c2f09  ! 1: ANDN_I	andn 	%r16, 0x0f09, %r10
	.word 0xb20c0002  ! 1: AND_R	and 	%r16, %r2, %r25
	.word 0x861c2a04  ! 1: XOR_I	xor 	%r16, 0x0a04, %r3
        mov 0x6d, %r31
thr3_loop_cnt_715:
	.word 0xf88c24ed  ! 1: LDUBA_I	lduba	[%r16, + 0x04ed] %asi, %r28
	.word 0xd84c2adb  ! 1: LDSB_I	ldsb	[%r16 + 0x0adb], %r12
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xc68423f4  ! 1: LDUWA_I	lduwa	[%r16, + 0x03f4] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xced42ef8  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ef8] %asi, %r7
	.word 0xc61426a2  ! 1: LDUH_I	lduh	[%r16 + 0x06a2], %r3
	.word 0xea841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r21
	.word 0xce14286e  ! 1: LDUH_I	lduh	[%r16 + 0x086e], %r7
	.word 0xe8dc22a0  ! 1: LDXA_I	ldxa	[%r16, + 0x02a0] %asi, %r20
	.word 0xdcd42c66  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c66] %asi, %r14
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	brnz %r31,thr3_loop_cnt_715
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x8c142655  ! 1: OR_I	or 	%r16, 0x0655, %r6
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x13, %r31
thr3_loop_cnt_716:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc68c219a  ! 1: LDUBA_I	lduba	[%r16, + 0x019a] %asi, %r3
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xea4429e0  ! 1: LDSW_I	ldsw	[%r16 + 0x09e0], %r21
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6542200  ! 1: LDSH_I	ldsh	[%r16 + 0x0200], %r3
	.word 0xd2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r9
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r27
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	brnz %r31,thr3_loop_cnt_716
	dec %r31
	.word 0xa7343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r19
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0xac, %r31
thr3_loop_cnt_717:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd80c24c6  ! 1: LDUB_I	ldub	[%r16 + 0x04c6], %r12
	.word 0xc60c2e0d  ! 1: LDUB_I	ldub	[%r16 + 0x0e0d], %r3
	.word 0xc6d4207c  ! 1: LDSHA_I	ldsha	[%r16, + 0x007c] %asi, %r3
	.word 0xf6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r27
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6cc20cb  ! 1: LDSBA_I	ldsba	[%r16, + 0x00cb] %asi, %r3
	.word 0xce4424b0  ! 1: LDSW_I	ldsw	[%r16 + 0x04b0], %r7
	.word 0xc6cc206d  ! 1: LDSBA_I	ldsba	[%r16, + 0x006d] %asi, %r3
	brnz %r31,thr3_loop_cnt_717
	dec %r31
        mov 0x3a, %r31
thr3_loop_cnt_718:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6542016  ! 1: LDSH_I	ldsh	[%r16 + 0x0016], %r3
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r28
	.word 0xf0cc26e1  ! 1: LDSBA_I	ldsba	[%r16, + 0x06e1] %asi, %r24
	.word 0xc6dc2660  ! 1: LDXA_I	ldxa	[%r16, + 0x0660] %asi, %r3
	brnz %r31,thr3_loop_cnt_718
	dec %r31
	.word 0x86242c6f  ! 1: SUB_I	sub 	%r16, 0x0c6f, %r3
	.word 0x962c2b02  ! 1: ANDN_I	andn 	%r16, 0x0b02, %r11
	.word 0x95342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r10
        mov 0x32, %r31
thr3_loop_cnt_719:
	.word 0xd88c2286  ! 1: LDUBA_I	lduba	[%r16, + 0x0286] %asi, %r12
	.word 0xd4dc2170  ! 1: LDXA_I	ldxa	[%r16, + 0x0170] %asi, %r10
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6942f68  ! 1: LDUHA_I	lduha	[%r16, + 0x0f68] %asi, %r3
	.word 0xc6dc2168  ! 1: LDXA_I	ldxa	[%r16, + 0x0168] %asi, %r3
	.word 0xcedc2c90  ! 1: LDXA_I	ldxa	[%r16, + 0x0c90] %asi, %r7
	.word 0xec440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r22
	.word 0xee4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r23
	.word 0xc6c429c4  ! 1: LDSWA_I	ldswa	[%r16, + 0x09c4] %asi, %r3
	.word 0xd8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r12
	.word 0xde4c236b  ! 1: LDSB_I	ldsb	[%r16 + 0x036b], %r15
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	brnz %r31,thr3_loop_cnt_719
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0xaa142148  ! 1: OR_I	or 	%r16, 0x0148, %r21
        mov 0x40, %r31
thr3_loop_cnt_720:
	.word 0xfc5428b6  ! 1: LDSH_I	ldsh	[%r16 + 0x08b6], %r30
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xf4d42e20  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e20] %asi, %r26
	.word 0xfcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r30
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd44c2b40  ! 1: LDSB_I	ldsb	[%r16 + 0x0b40], %r10
	.word 0xc6442c50  ! 1: LDSW_I	ldsw	[%r16 + 0x0c50], %r3
	.word 0xc6142e14  ! 1: LDUH_I	lduh	[%r16 + 0x0e14], %r3
	brnz %r31,thr3_loop_cnt_720
	dec %r31
	.word 0x961c240e  ! 1: XOR_I	xor 	%r16, 0x040e, %r11
        mov 0x48, %r31
thr3_loop_cnt_721:
	.word 0xc65c2178  ! 1: LDX_I	ldx	[%r16 + 0x0178], %r3
	.word 0xd8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r12
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xdc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r14
	.word 0xc65c2610  ! 1: LDX_I	ldx	[%r16 + 0x0610], %r3
	.word 0xf64c2b36  ! 1: LDSB_I	ldsb	[%r16 + 0x0b36], %r27
	.word 0xfcc42dd8  ! 1: LDSWA_I	ldswa	[%r16, + 0x0dd8] %asi, %r30
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xcecc29b6  ! 1: LDSBA_I	ldsba	[%r16, + 0x09b6] %asi, %r7
	.word 0xc60c2f4b  ! 1: LDUB_I	ldub	[%r16 + 0x0f4b], %r3
	brnz %r31,thr3_loop_cnt_721
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x8f343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r7
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x53, %r31
thr3_loop_cnt_722:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6042c50  ! 1: LDUW_I	lduw	[%r16 + 0x0c50], %r3
	.word 0xde540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r15
	.word 0xdacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r13
	.word 0xc684231c  ! 1: LDUWA_I	lduwa	[%r16, + 0x031c] %asi, %r3
	.word 0xc64c2dbf  ! 1: LDSB_I	ldsb	[%r16 + 0x0dbf], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd2c42750  ! 1: LDSWA_I	ldswa	[%r16, + 0x0750] %asi, %r9
	brnz %r31,thr3_loop_cnt_722
	dec %r31
	.word 0xba342400  ! 1: ORN_I	orn 	%r16, 0x0400, %r29
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0x3e, %r31
thr3_loop_cnt_723:
	.word 0xc6dc2dd0  ! 1: LDXA_I	ldxa	[%r16, + 0x0dd0] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xec8421ac  ! 1: LDUWA_I	lduwa	[%r16, + 0x01ac] %asi, %r22
	.word 0xe64426ec  ! 1: LDSW_I	ldsw	[%r16 + 0x06ec], %r19
	.word 0xf4cc24a3  ! 1: LDSBA_I	ldsba	[%r16, + 0x04a3] %asi, %r26
	.word 0xc6442efc  ! 1: LDSW_I	ldsw	[%r16 + 0x0efc], %r3
	.word 0xc60c2ba9  ! 1: LDUB_I	ldub	[%r16 + 0x0ba9], %r3
	.word 0xdedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r15
	brnz %r31,thr3_loop_cnt_723
	dec %r31
	.word 0x92240002  ! 1: SUB_R	sub 	%r16, %r2, %r9
	.word 0xb63c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r27
	.word 0x86242738  ! 1: SUB_I	sub 	%r16, 0x0738, %r3
        mov 0x45, %r31
thr3_loop_cnt_724:
	.word 0xd04424c8  ! 1: LDSW_I	ldsw	[%r16 + 0x04c8], %r8
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	.word 0xf2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r25
	.word 0xecc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r22
	.word 0xc6cc2fe0  ! 1: LDSBA_I	ldsba	[%r16, + 0x0fe0] %asi, %r3
	.word 0xc6442e6c  ! 1: LDSW_I	ldsw	[%r16 + 0x0e6c], %r3
	.word 0xda4429ac  ! 1: LDSW_I	ldsw	[%r16 + 0x09ac], %r13
	.word 0xf2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r25
	.word 0xea042094  ! 1: LDUW_I	lduw	[%r16 + 0x0094], %r21
	.word 0xd4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r10
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc68c2531  ! 1: LDUBA_I	lduba	[%r16, + 0x0531] %asi, %r3
	brnz %r31,thr3_loop_cnt_724
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0xb0340002  ! 1: ORN_R	orn 	%r16, %r2, %r24
	.word 0xa92c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r20
	.word 0x863c2bb4  ! 1: XNOR_I	xnor 	%r16, 0x0bb4, %r3
        mov 0x1b, %r31
thr3_loop_cnt_725:
	.word 0xfa8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r29
	.word 0xf0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r24
	.word 0xc6dc2218  ! 1: LDXA_I	ldxa	[%r16, + 0x0218] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc27dd  ! 1: LDSBA_I	ldsba	[%r16, + 0x07dd] %asi, %r3
	.word 0xf4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r26
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_725
	dec %r31
	.word 0x91342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r8
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0xb4242e91  ! 1: SUB_I	sub 	%r16, 0x0e91, %r26
	.word 0x863c2766  ! 1: XNOR_I	xnor 	%r16, 0x0766, %r3
        mov 0x86, %r31
thr3_loop_cnt_726:
	.word 0xd2d4269c  ! 1: LDSHA_I	ldsha	[%r16, + 0x069c] %asi, %r9
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xfc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r30
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6842090  ! 1: LDUWA_I	lduwa	[%r16, + 0x0090] %asi, %r3
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xe2142992  ! 1: LDUH_I	lduh	[%r16 + 0x0992], %r17
	.word 0xd60c2a3b  ! 1: LDUB_I	ldub	[%r16 + 0x0a3b], %r11
	.word 0xdadc28f8  ! 1: LDXA_I	ldxa	[%r16, + 0x08f8] %asi, %r13
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_726
	dec %r31
        mov 0x7e, %r31
thr3_loop_cnt_727:
	.word 0xf6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r27
	.word 0xf2dc24b0  ! 1: LDXA_I	ldxa	[%r16, + 0x04b0] %asi, %r25
	.word 0xd2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r9
	.word 0xd6cc2fc9  ! 1: LDSBA_I	ldsba	[%r16, + 0x0fc9] %asi, %r11
	.word 0xec0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r22
	.word 0xc6d4284a  ! 1: LDSHA_I	ldsha	[%r16, + 0x084a] %asi, %r3
	.word 0xd4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r10
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_727
	dec %r31
	.word 0xa4142e27  ! 1: OR_I	or 	%r16, 0x0e27, %r18
	.word 0x86142188  ! 1: OR_I	or 	%r16, 0x0188, %r3
	.word 0x8634268b  ! 1: ORN_I	orn 	%r16, 0x068b, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x11, %r31
thr3_loop_cnt_728:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	.word 0xda142fe0  ! 1: LDUH_I	lduh	[%r16 + 0x0fe0], %r13
	.word 0xc68c2c16  ! 1: LDUBA_I	lduba	[%r16, + 0x0c16] %asi, %r3
	.word 0xd60c227a  ! 1: LDUB_I	ldub	[%r16 + 0x027a], %r11
	.word 0xc6042218  ! 1: LDUW_I	lduw	[%r16 + 0x0218], %r3
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xdc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r14
	.word 0xd44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r10
	brnz %r31,thr3_loop_cnt_728
	dec %r31
	.word 0x9e0c28d4  ! 1: AND_I	and 	%r16, 0x08d4, %r15
        mov 0xc1, %r31
thr3_loop_cnt_729:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r28
	.word 0xc6c426a4  ! 1: LDSWA_I	ldswa	[%r16, + 0x06a4] %asi, %r3
	.word 0xd2cc25c5  ! 1: LDSBA_I	ldsba	[%r16, + 0x05c5] %asi, %r9
	.word 0xfa542f32  ! 1: LDSH_I	ldsh	[%r16 + 0x0f32], %r29
	.word 0xc6c426e8  ! 1: LDSWA_I	ldswa	[%r16, + 0x06e8] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_729
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0xbc24268d  ! 1: SUB_I	sub 	%r16, 0x068d, %r30
	.word 0x933c0002  ! 1: SRA_R	sra 	%r16, %r2, %r9
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x80, %r31
thr3_loop_cnt_730:
	.word 0xd0dc2078  ! 1: LDXA_I	ldxa	[%r16, + 0x0078] %asi, %r8
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xda841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r13
	.word 0xd6042278  ! 1: LDUW_I	lduw	[%r16 + 0x0278], %r11
	.word 0xd4c42a98  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a98] %asi, %r10
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6142510  ! 1: LDUH_I	lduh	[%r16 + 0x0510], %r3
	.word 0xc6442f38  ! 1: LDSW_I	ldsw	[%r16 + 0x0f38], %r3
	.word 0xc6c421f8  ! 1: LDSWA_I	ldswa	[%r16, + 0x01f8] %asi, %r3
	.word 0xc6942628  ! 1: LDUHA_I	lduha	[%r16, + 0x0628] %asi, %r3
	brnz %r31,thr3_loop_cnt_730
	dec %r31
	.word 0x92142fe9  ! 1: OR_I	or 	%r16, 0x0fe9, %r9
        mov 0x58, %r31
thr3_loop_cnt_731:
	.word 0xe4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r18
	.word 0xc60c2110  ! 1: LDUB_I	ldub	[%r16 + 0x0110], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r17
	.word 0xc6942216  ! 1: LDUHA_I	lduha	[%r16, + 0x0216] %asi, %r3
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	brnz %r31,thr3_loop_cnt_731
	dec %r31
	.word 0x98140002  ! 1: OR_R	or 	%r16, %r2, %r12
	.word 0x863c2c12  ! 1: XNOR_I	xnor 	%r16, 0x0c12, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x29, %r31
thr3_loop_cnt_732:
	.word 0xc65420fa  ! 1: LDSH_I	ldsh	[%r16 + 0x00fa], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd0442284  ! 1: LDSW_I	ldsw	[%r16 + 0x0284], %r8
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_732
	dec %r31
        mov 0xb0, %r31
thr3_loop_cnt_733:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xdc0427c0  ! 1: LDUW_I	lduw	[%r16 + 0x07c0], %r14
	.word 0xc69420d0  ! 1: LDUHA_I	lduha	[%r16, + 0x00d0] %asi, %r3
	.word 0xe8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r20
	.word 0xc694287a  ! 1: LDUHA_I	lduha	[%r16, + 0x087a] %asi, %r3
	.word 0xc6cc2c10  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c10] %asi, %r3
	.word 0xdadc2e20  ! 1: LDXA_I	ldxa	[%r16, + 0x0e20] %asi, %r13
	.word 0xda5c2ae8  ! 1: LDX_I	ldx	[%r16 + 0x0ae8], %r13
	.word 0xd8d42ebe  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ebe] %asi, %r12
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_733
	dec %r31
	.word 0xa61c0002  ! 1: XOR_R	xor 	%r16, %r2, %r19
	.word 0x943c202f  ! 1: XNOR_I	xnor 	%r16, 0x002f, %r10
        mov 0x1e, %r31
thr3_loop_cnt_734:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xecc4250c  ! 1: LDSWA_I	ldswa	[%r16, + 0x050c] %asi, %r22
	.word 0xc6c42274  ! 1: LDSWA_I	ldswa	[%r16, + 0x0274] %asi, %r3
	.word 0xe6042900  ! 1: LDUW_I	lduw	[%r16 + 0x0900], %r19
	.word 0xcc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r6
	.word 0xc6142806  ! 1: LDUH_I	lduh	[%r16 + 0x0806], %r3
	.word 0xdedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r15
	.word 0xe65c2dd0  ! 1: LDX_I	ldx	[%r16 + 0x0dd0], %r19
	.word 0xc64421b0  ! 1: LDSW_I	ldsw	[%r16 + 0x01b0], %r3
	.word 0xc6842064  ! 1: LDUWA_I	lduwa	[%r16, + 0x0064] %asi, %r3
	.word 0xe8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r20
	brnz %r31,thr3_loop_cnt_734
	dec %r31
        mov 0x2d, %r31
thr3_loop_cnt_735:
	.word 0xfadc2020  ! 1: LDXA_I	ldxa	[%r16, + 0x0020] %asi, %r29
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc68c2420  ! 1: LDUBA_I	lduba	[%r16, + 0x0420] %asi, %r3
	.word 0xe2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r17
	.word 0xd6942b68  ! 1: LDUHA_I	lduha	[%r16, + 0x0b68] %asi, %r11
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6442774  ! 1: LDSW_I	ldsw	[%r16 + 0x0774], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc68c2463  ! 1: LDUBA_I	lduba	[%r16, + 0x0463] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xfa140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r29
	brnz %r31,thr3_loop_cnt_735
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0xa73c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r19
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0xbf, %r31
thr3_loop_cnt_736:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc69428c6  ! 1: LDUHA_I	lduha	[%r16, + 0x08c6] %asi, %r3
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xee4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r23
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe6d4234e  ! 1: LDSHA_I	ldsha	[%r16, + 0x034e] %asi, %r19
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	brnz %r31,thr3_loop_cnt_736
	dec %r31
        mov 0x8a, %r31
thr3_loop_cnt_737:
	.word 0xf08426a0  ! 1: LDUWA_I	lduwa	[%r16, + 0x06a0] %asi, %r24
	.word 0xc60c2954  ! 1: LDUB_I	ldub	[%r16 + 0x0954], %r3
	.word 0xf6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r27
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xfa540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r29
	.word 0xc6c42f9c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f9c] %asi, %r3
	.word 0xf2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r25
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xe25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r17
	brnz %r31,thr3_loop_cnt_737
	dec %r31
	.word 0xa2340002  ! 1: SUBC_R	orn 	%r16, %r2, %r17
	.word 0xb7343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r27
	.word 0x861c2268  ! 1: XOR_I	xor 	%r16, 0x0268, %r3
        mov 0xa, %r31
thr3_loop_cnt_738:
	.word 0xfc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r30
	.word 0xfc5c21d0  ! 1: LDX_I	ldx	[%r16 + 0x01d0], %r30
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd0142864  ! 1: LDUH_I	lduh	[%r16 + 0x0864], %r8
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd4d42908  ! 1: LDSHA_I	ldsha	[%r16, + 0x0908] %asi, %r10
	.word 0xeed41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r23
	.word 0xd0142082  ! 1: LDUH_I	lduh	[%r16 + 0x0082], %r8
	.word 0xc6042360  ! 1: LDUW_I	lduw	[%r16 + 0x0360], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xfc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r30
	brnz %r31,thr3_loop_cnt_738
	dec %r31
	.word 0x97342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r11
	.word 0x86242782  ! 1: SUB_I	sub 	%r16, 0x0782, %r3
        mov 0xbb, %r31
thr3_loop_cnt_739:
	.word 0xc6042fac  ! 1: LDUW_I	lduw	[%r16 + 0x0fac], %r3
	.word 0xe25c2f88  ! 1: LDX_I	ldx	[%r16 + 0x0f88], %r17
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd2942d9a  ! 1: LDUHA_I	lduha	[%r16, + 0x0d9a] %asi, %r9
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe65c2dd8  ! 1: LDX_I	ldx	[%r16 + 0x0dd8], %r19
	.word 0xda442174  ! 1: LDSW_I	ldsw	[%r16 + 0x0174], %r13
	.word 0xc65c2c38  ! 1: LDX_I	ldx	[%r16 + 0x0c38], %r3
	brnz %r31,thr3_loop_cnt_739
	dec %r31
        mov 0x62, %r31
thr3_loop_cnt_740:
	.word 0xd6442b54  ! 1: LDSW_I	ldsw	[%r16 + 0x0b54], %r11
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf85c2dd8  ! 1: LDX_I	ldx	[%r16 + 0x0dd8], %r28
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6dc2ed8  ! 1: LDXA_I	ldxa	[%r16, + 0x0ed8] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc61427ac  ! 1: LDUH_I	lduh	[%r16 + 0x07ac], %r3
	.word 0xc6dc2f50  ! 1: LDXA_I	ldxa	[%r16, + 0x0f50] %asi, %r3
	.word 0xd8142ce4  ! 1: LDUH_I	lduh	[%r16 + 0x0ce4], %r12
	.word 0xc6c42178  ! 1: LDSWA_I	ldswa	[%r16, + 0x0178] %asi, %r3
	.word 0xfc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r30
	.word 0xda04287c  ! 1: LDUW_I	lduw	[%r16 + 0x087c], %r13
	brnz %r31,thr3_loop_cnt_740
	dec %r31
	.word 0x902c2132  ! 1: ANDN_I	andn 	%r16, 0x0132, %r8
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0xb80c0002  ! 1: AND_R	and 	%r16, %r2, %r28
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x53, %r31
thr3_loop_cnt_741:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xda4427dc  ! 1: LDSW_I	ldsw	[%r16 + 0x07dc], %r13
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe6c42df0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0df0] %asi, %r19
	.word 0xe4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r18
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xc6042d3c  ! 1: LDUW_I	lduw	[%r16 + 0x0d3c], %r3
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	brnz %r31,thr3_loop_cnt_741
	dec %r31
        mov 0xac, %r31
thr3_loop_cnt_742:
	.word 0xec440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r22
	.word 0xc60c2bca  ! 1: LDUB_I	ldub	[%r16 + 0x0bca], %r3
	.word 0xd05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r8
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xdc8c20b7  ! 1: LDUBA_I	lduba	[%r16, + 0x00b7] %asi, %r14
	.word 0xc64c2eb9  ! 1: LDSB_I	ldsb	[%r16 + 0x0eb9], %r3
	brnz %r31,thr3_loop_cnt_742
	dec %r31
	.word 0xa60c2123  ! 1: AND_I	and 	%r16, 0x0123, %r19
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0xac340002  ! 1: SUBC_R	orn 	%r16, %r2, %r22
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x78, %r31
thr3_loop_cnt_743:
	.word 0xc654292a  ! 1: LDSH_I	ldsh	[%r16 + 0x092a], %r3
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	.word 0xda0c2477  ! 1: LDUB_I	ldub	[%r16 + 0x0477], %r13
	.word 0xc60c2368  ! 1: LDUB_I	ldub	[%r16 + 0x0368], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf00c2a85  ! 1: LDUB_I	ldub	[%r16 + 0x0a85], %r24
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2f6d  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f6d] %asi, %r3
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	.word 0xc6cc2070  ! 1: LDSBA_I	ldsba	[%r16, + 0x0070] %asi, %r3
	brnz %r31,thr3_loop_cnt_743
	dec %r31
        mov 0x59, %r31
thr3_loop_cnt_744:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r25
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd4542580  ! 1: LDSH_I	ldsh	[%r16 + 0x0580], %r10
	.word 0xc6c42c0c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c0c] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6c42b14  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b14] %asi, %r3
	.word 0xf64c273a  ! 1: LDSB_I	ldsb	[%r16 + 0x073a], %r27
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc65c2358  ! 1: LDX_I	ldx	[%r16 + 0x0358], %r3
	.word 0xf4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r26
	brnz %r31,thr3_loop_cnt_744
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0xb6442ec0  ! 1: ADDC_I	addc 	%r16, 0x0ec0, %r27
	.word 0x92040002  ! 1: ADD_R	add 	%r16, %r2, %r9
	.word 0xb92c0002  ! 1: SLL_R	sll 	%r16, %r2, %r28
        mov 0x2d, %r31
thr3_loop_cnt_745:
	.word 0xda14278e  ! 1: LDUH_I	lduh	[%r16 + 0x078e], %r13
	.word 0xc68c2b2d  ! 1: LDUBA_I	lduba	[%r16, + 0x0b2d] %asi, %r3
	.word 0xc6dc2db0  ! 1: LDXA_I	ldxa	[%r16, + 0x0db0] %asi, %r3
	.word 0xf2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r25
	.word 0xe6c42134  ! 1: LDSWA_I	ldswa	[%r16, + 0x0134] %asi, %r19
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xec0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r22
	.word 0xdc5c2ba8  ! 1: LDX_I	ldx	[%r16 + 0x0ba8], %r14
	.word 0xc6dc2d28  ! 1: LDXA_I	ldxa	[%r16, + 0x0d28] %asi, %r3
	brnz %r31,thr3_loop_cnt_745
	dec %r31
	.word 0x86042dea  ! 1: ADD_I	add 	%r16, 0x0dea, %r3
	.word 0x860c2226  ! 1: AND_I	and 	%r16, 0x0226, %r3
        mov 0x7c, %r31
thr3_loop_cnt_746:
	.word 0xe2d42aa4  ! 1: LDSHA_I	ldsha	[%r16, + 0x0aa4] %asi, %r17
	.word 0xce9421ca  ! 1: LDUHA_I	lduha	[%r16, + 0x01ca] %asi, %r7
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe4942dea  ! 1: LDUHA_I	lduha	[%r16, + 0x0dea] %asi, %r18
	.word 0xc6842764  ! 1: LDUWA_I	lduwa	[%r16, + 0x0764] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xdc54268c  ! 1: LDSH_I	ldsh	[%r16 + 0x068c], %r14
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_746
	dec %r31
	.word 0xb40c2836  ! 1: AND_I	and 	%r16, 0x0836, %r26
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0xb8, %r31
thr3_loop_cnt_747:
	.word 0xfccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r30
	.word 0xc6042d30  ! 1: LDUW_I	lduw	[%r16 + 0x0d30], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	.word 0xc6142cc0  ! 1: LDUH_I	lduh	[%r16 + 0x0cc0], %r3
	.word 0xc68423d8  ! 1: LDUWA_I	lduwa	[%r16, + 0x03d8] %asi, %r3
	brnz %r31,thr3_loop_cnt_747
	dec %r31
        mov 0xad, %r31
thr3_loop_cnt_748:
	.word 0xf0842aac  ! 1: LDUWA_I	lduwa	[%r16, + 0x0aac] %asi, %r24
	.word 0xc6c42ed8  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ed8] %asi, %r3
	.word 0xe6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r19
	.word 0xc6842634  ! 1: LDUWA_I	lduwa	[%r16, + 0x0634] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe4542d7a  ! 1: LDSH_I	ldsh	[%r16 + 0x0d7a], %r18
	.word 0xc60c242e  ! 1: LDUB_I	ldub	[%r16 + 0x042e], %r3
	brnz %r31,thr3_loop_cnt_748
	dec %r31
        mov 0xae, %r31
thr3_loop_cnt_749:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r19
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc64c2241  ! 1: LDSB_I	ldsb	[%r16 + 0x0241], %r3
	.word 0xfac42304  ! 1: LDSWA_I	ldswa	[%r16, + 0x0304] %asi, %r29
	.word 0xe48426b8  ! 1: LDUWA_I	lduwa	[%r16, + 0x06b8] %asi, %r18
	.word 0xc654260c  ! 1: LDSH_I	ldsh	[%r16 + 0x060c], %r3
	.word 0xcecc28e2  ! 1: LDSBA_I	ldsba	[%r16, + 0x08e2] %asi, %r7
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xe6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r19
	brnz %r31,thr3_loop_cnt_749
	dec %r31
	.word 0x8c1c2316  ! 1: XOR_I	xor 	%r16, 0x0316, %r6
	.word 0x862c29cb  ! 1: ANDN_I	andn 	%r16, 0x09cb, %r3
	.word 0x9a2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r13
	.word 0xb9340002  ! 1: SRL_R	srl 	%r16, %r2, %r28
        mov 0x83, %r31
thr3_loop_cnt_750:
	.word 0xc6442b24  ! 1: LDSW_I	ldsw	[%r16 + 0x0b24], %r3
	.word 0xc6542434  ! 1: LDSH_I	ldsh	[%r16 + 0x0434], %r3
	.word 0xda8c2caf  ! 1: LDUBA_I	lduba	[%r16, + 0x0caf] %asi, %r13
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd68c28c1  ! 1: LDUBA_I	lduba	[%r16, + 0x08c1] %asi, %r11
	.word 0xc6842bbc  ! 1: LDUWA_I	lduwa	[%r16, + 0x0bbc] %asi, %r3
	.word 0xcc442950  ! 1: LDSW_I	ldsw	[%r16 + 0x0950], %r6
	.word 0xc60c2421  ! 1: LDUB_I	ldub	[%r16 + 0x0421], %r3
	.word 0xc654230c  ! 1: LDSH_I	ldsh	[%r16 + 0x030c], %r3
	.word 0xc684244c  ! 1: LDUWA_I	lduwa	[%r16, + 0x044c] %asi, %r3
	.word 0xc6c4228c  ! 1: LDSWA_I	ldswa	[%r16, + 0x028c] %asi, %r3
	brnz %r31,thr3_loop_cnt_750
	dec %r31
	.word 0x86342e00  ! 1: ORN_I	orn 	%r16, 0x0e00, %r3
	.word 0xb8242dd8  ! 1: SUB_I	sub 	%r16, 0x0dd8, %r28
	.word 0x861c2085  ! 1: XOR_I	xor 	%r16, 0x0085, %r3
        mov 0x8, %r31
thr3_loop_cnt_751:
	.word 0xeedc2b68  ! 1: LDXA_I	ldxa	[%r16, + 0x0b68] %asi, %r23
	.word 0xe4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r18
	.word 0xc65424e4  ! 1: LDSH_I	ldsh	[%r16 + 0x04e4], %r3
	.word 0xd89423b4  ! 1: LDUHA_I	lduha	[%r16, + 0x03b4] %asi, %r12
	.word 0xe6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r19
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd04c21d1  ! 1: LDSB_I	ldsb	[%r16 + 0x01d1], %r8
	.word 0xe2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r17
	brnz %r31,thr3_loop_cnt_751
	dec %r31
        mov 0x83, %r31
thr3_loop_cnt_752:
	.word 0xe8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r20
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r27
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	.word 0xc6c42328  ! 1: LDSWA_I	ldswa	[%r16, + 0x0328] %asi, %r3
	.word 0xde540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r15
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd0d42b50  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b50] %asi, %r8
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_752
	dec %r31
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
        mov 0x55, %r31
thr3_loop_cnt_753:
	.word 0xc64420f4  ! 1: LDSW_I	ldsw	[%r16 + 0x00f4], %r3
	.word 0xee942b60  ! 1: LDUHA_I	lduha	[%r16, + 0x0b60] %asi, %r23
	.word 0xc6542dc4  ! 1: LDSH_I	ldsh	[%r16 + 0x0dc4], %r3
	.word 0xc6542696  ! 1: LDSH_I	ldsh	[%r16 + 0x0696], %r3
	.word 0xf4cc201c  ! 1: LDSBA_I	ldsba	[%r16, + 0x001c] %asi, %r26
	.word 0xe614273a  ! 1: LDUH_I	lduh	[%r16 + 0x073a], %r19
	.word 0xe6cc2bf7  ! 1: LDSBA_I	ldsba	[%r16, + 0x0bf7] %asi, %r19
	.word 0xe45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r18
	.word 0xc6cc26da  ! 1: LDSBA_I	ldsba	[%r16, + 0x06da] %asi, %r3
	.word 0xee0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r23
	.word 0xe44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r18
	brnz %r31,thr3_loop_cnt_753
	dec %r31
	.word 0x86242043  ! 1: SUB_I	sub 	%r16, 0x0043, %r3
	.word 0xac342266  ! 1: ORN_I	orn 	%r16, 0x0266, %r22
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0xb, %r31
thr3_loop_cnt_754:
	.word 0xc6442cc4  ! 1: LDSW_I	ldsw	[%r16 + 0x0cc4], %r3
	.word 0xe6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r19
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r18
	.word 0xce142366  ! 1: LDUH_I	lduh	[%r16 + 0x0366], %r7
	.word 0xde841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r15
	.word 0xcccc2857  ! 1: LDSBA_I	ldsba	[%r16, + 0x0857] %asi, %r6
	.word 0xc6cc255b  ! 1: LDSBA_I	ldsba	[%r16, + 0x055b] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xe4c4227c  ! 1: LDSWA_I	ldswa	[%r16, + 0x027c] %asi, %r18
	brnz %r31,thr3_loop_cnt_754
	dec %r31
	.word 0xb0140002  ! 1: OR_R	or 	%r16, %r2, %r24
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0x85, %r31
thr3_loop_cnt_755:
	.word 0xdcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r14
	.word 0xc6c42884  ! 1: LDSWA_I	ldswa	[%r16, + 0x0884] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xec941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r22
	.word 0xd2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r9
	.word 0xe45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r18
	.word 0xc64c2f7f  ! 1: LDSB_I	ldsb	[%r16 + 0x0f7f], %r3
	.word 0xfcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r30
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6542250  ! 1: LDSH_I	ldsh	[%r16 + 0x0250], %r3
	brnz %r31,thr3_loop_cnt_755
	dec %r31
	.word 0x8e342f80  ! 1: ORN_I	orn 	%r16, 0x0f80, %r7
	.word 0x9e0c2064  ! 1: AND_I	and 	%r16, 0x0064, %r15
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0x14, %r31
thr3_loop_cnt_756:
	.word 0xf4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r26
	.word 0xf8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r28
	.word 0xde540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r15
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6042b84  ! 1: LDUW_I	lduw	[%r16 + 0x0b84], %r3
	.word 0xd4142606  ! 1: LDUH_I	lduh	[%r16 + 0x0606], %r10
	.word 0xc69420f6  ! 1: LDUHA_I	lduha	[%r16, + 0x00f6] %asi, %r3
	.word 0xeac42278  ! 1: LDSWA_I	ldswa	[%r16, + 0x0278] %asi, %r21
	brnz %r31,thr3_loop_cnt_756
	dec %r31
        mov 0x17, %r31
thr3_loop_cnt_757:
	.word 0xc60c28b3  ! 1: LDUB_I	ldub	[%r16 + 0x08b3], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe45c2b30  ! 1: LDX_I	ldx	[%r16 + 0x0b30], %r18
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd8042344  ! 1: LDUW_I	lduw	[%r16 + 0x0344], %r12
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd28c2015  ! 1: LDUBA_I	lduba	[%r16, + 0x0015] %asi, %r9
	.word 0xf44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r26
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_757
	dec %r31
	.word 0x9d2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r14
	.word 0x992c0002  ! 1: SLL_R	sll 	%r16, %r2, %r12
	.word 0xac042039  ! 1: ADD_I	add 	%r16, 0x0039, %r22
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0xa, %r31
thr3_loop_cnt_758:
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xf24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r25
	.word 0xf2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r25
	.word 0xc6cc23de  ! 1: LDSBA_I	ldsba	[%r16, + 0x03de] %asi, %r3
	.word 0xee0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r23
	.word 0xd2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r9
	.word 0xf64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r27
	.word 0xf40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r26
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_758
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0xb40422e1  ! 1: ADD_I	add 	%r16, 0x02e1, %r26
        mov 0x18, %r31
thr3_loop_cnt_759:
	.word 0xc6442a8c  ! 1: LDSW_I	ldsw	[%r16 + 0x0a8c], %r3
	.word 0xc64429f4  ! 1: LDSW_I	ldsw	[%r16 + 0x09f4], %r3
	.word 0xc65c25c8  ! 1: LDX_I	ldx	[%r16 + 0x05c8], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xea841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r21
	.word 0xf0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r24
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r11
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6c42a5c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a5c] %asi, %r3
	.word 0xd6cc2b5a  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b5a] %asi, %r11
	.word 0xd6cc2f8a  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f8a] %asi, %r11
	brnz %r31,thr3_loop_cnt_759
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x9a0c0002  ! 1: AND_R	and 	%r16, %r2, %r13
	.word 0x9d2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r14
        mov 0x6e, %r31
thr3_loop_cnt_760:
	.word 0xdc0c2b7a  ! 1: LDUB_I	ldub	[%r16 + 0x0b7a], %r14
	.word 0xdc04230c  ! 1: LDUW_I	lduw	[%r16 + 0x030c], %r14
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6842540  ! 1: LDUWA_I	lduwa	[%r16, + 0x0540] %asi, %r3
	.word 0xec5c2c10  ! 1: LDX_I	ldx	[%r16 + 0x0c10], %r22
	.word 0xf4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r26
	.word 0xcc54264e  ! 1: LDSH_I	ldsh	[%r16 + 0x064e], %r6
	.word 0xf6d42b7c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b7c] %asi, %r27
	brnz %r31,thr3_loop_cnt_760
	dec %r31
	.word 0xae040002  ! 1: ADD_R	add 	%r16, %r2, %r23
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x863c2586  ! 1: XNOR_I	xnor 	%r16, 0x0586, %r3
        mov 0xbc, %r31
thr3_loop_cnt_761:
	.word 0xc68c2519  ! 1: LDUBA_I	lduba	[%r16, + 0x0519] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6dc2ce8  ! 1: LDXA_I	ldxa	[%r16, + 0x0ce8] %asi, %r3
	.word 0xc61422a6  ! 1: LDUH_I	lduh	[%r16 + 0x02a6], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6d42d52  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d52] %asi, %r3
	.word 0xd2c42ce0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ce0] %asi, %r9
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xde5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r15
	.word 0xc6cc2ca0  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ca0] %asi, %r3
	brnz %r31,thr3_loop_cnt_761
	dec %r31
	.word 0x9d3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r14
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x23, %r31
thr3_loop_cnt_762:
	.word 0xfc4c2d96  ! 1: LDSB_I	ldsb	[%r16 + 0x0d96], %r30
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc64c2322  ! 1: LDSB_I	ldsb	[%r16 + 0x0322], %r3
	.word 0xdecc26ee  ! 1: LDSBA_I	ldsba	[%r16, + 0x06ee] %asi, %r15
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xfcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r30
	.word 0xc6842524  ! 1: LDUWA_I	lduwa	[%r16, + 0x0524] %asi, %r3
	.word 0xe64c2589  ! 1: LDSB_I	ldsb	[%r16 + 0x0589], %r19
	.word 0xc64c2990  ! 1: LDSB_I	ldsb	[%r16 + 0x0990], %r3
	brnz %r31,thr3_loop_cnt_762
	dec %r31
	.word 0x9e440002  ! 1: ADDC_R	addc 	%r16, %r2, %r15
	.word 0xa72c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r19
        mov 0x23, %r31
thr3_loop_cnt_763:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6c42770  ! 1: LDSWA_I	ldswa	[%r16, + 0x0770] %asi, %r3
	.word 0xc6442420  ! 1: LDSW_I	ldsw	[%r16 + 0x0420], %r3
	.word 0xee0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r23
	.word 0xd45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r10
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r17
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6942742  ! 1: LDUHA_I	lduha	[%r16, + 0x0742] %asi, %r3
	brnz %r31,thr3_loop_cnt_763
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x15, %r31
thr3_loop_cnt_764:
	.word 0xe68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r19
	.word 0xced4259a  ! 1: LDSHA_I	ldsha	[%r16, + 0x059a] %asi, %r7
	.word 0xd6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r11
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf6cc2b00  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b00] %asi, %r27
	.word 0xd0d4277c  ! 1: LDSHA_I	ldsha	[%r16, + 0x077c] %asi, %r8
	.word 0xc6c42234  ! 1: LDSWA_I	ldswa	[%r16, + 0x0234] %asi, %r3
	.word 0xf88c29b3  ! 1: LDUBA_I	lduba	[%r16, + 0x09b3] %asi, %r28
	.word 0xec8c2123  ! 1: LDUBA_I	lduba	[%r16, + 0x0123] %asi, %r22
	.word 0xe28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r17
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_764
	dec %r31
        mov 0xb, %r31
thr3_loop_cnt_765:
	.word 0xfc4c27dc  ! 1: LDSB_I	ldsb	[%r16 + 0x07dc], %r30
	.word 0xcc14282a  ! 1: LDUH_I	lduh	[%r16 + 0x082a], %r6
	.word 0xc60c2a29  ! 1: LDUB_I	ldub	[%r16 + 0x0a29], %r3
	.word 0xda5c22a0  ! 1: LDX_I	ldx	[%r16 + 0x02a0], %r13
	.word 0xc68426d4  ! 1: LDUWA_I	lduwa	[%r16, + 0x06d4] %asi, %r3
	.word 0xf05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r24
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xc6d424ee  ! 1: LDSHA_I	ldsha	[%r16, + 0x04ee] %asi, %r3
	.word 0xc6842b28  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b28] %asi, %r3
	.word 0xf0d42794  ! 1: LDSHA_I	ldsha	[%r16, + 0x0794] %asi, %r24
	brnz %r31,thr3_loop_cnt_765
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x7a, %r31
thr3_loop_cnt_766:
	.word 0xde5c2c80  ! 1: LDX_I	ldx	[%r16 + 0x0c80], %r15
	.word 0xe48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r18
	.word 0xc6142f2e  ! 1: LDUH_I	lduh	[%r16 + 0x0f2e], %r3
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc65c2598  ! 1: LDX_I	ldx	[%r16 + 0x0598], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xec5c2f08  ! 1: LDX_I	ldx	[%r16 + 0x0f08], %r22
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_766
	dec %r31
        mov 0x3f, %r31
thr3_loop_cnt_767:
	.word 0xd8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r12
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf20c2b22  ! 1: LDUB_I	ldub	[%r16 + 0x0b22], %r25
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf28c21ad  ! 1: LDUBA_I	lduba	[%r16, + 0x01ad] %asi, %r25
	.word 0xc6842ad8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ad8] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r8
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf80c20a3  ! 1: LDUB_I	ldub	[%r16 + 0x00a3], %r28
	.word 0xd8442158  ! 1: LDSW_I	ldsw	[%r16 + 0x0158], %r12
	.word 0xc60c27cc  ! 1: LDUB_I	ldub	[%r16 + 0x07cc], %r3
	brnz %r31,thr3_loop_cnt_767
	dec %r31
	.word 0xa20c0002  ! 1: AND_R	and 	%r16, %r2, %r17
	.word 0x9e2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r15
        mov 0xb7, %r31
thr3_loop_cnt_768:
	.word 0xe8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r20
	.word 0xc6d42a4a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a4a] %asi, %r3
	.word 0xf8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r28
	.word 0xec841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r22
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6542fec  ! 1: LDSH_I	ldsh	[%r16 + 0x0fec], %r3
	.word 0xdc0c2a00  ! 1: LDUB_I	ldub	[%r16 + 0x0a00], %r14
	.word 0xc6142b80  ! 1: LDUH_I	lduh	[%r16 + 0x0b80], %r3
	.word 0xee8421f4  ! 1: LDUWA_I	lduwa	[%r16, + 0x01f4] %asi, %r23
	.word 0xda440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r13
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_768
	dec %r31
        mov 0x58, %r31
thr3_loop_cnt_769:
	.word 0xd6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r11
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xea9428da  ! 1: LDUHA_I	lduha	[%r16, + 0x08da] %asi, %r21
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	.word 0xf00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r24
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc60c2fa8  ! 1: LDUB_I	ldub	[%r16 + 0x0fa8], %r3
	.word 0xdadc2b80  ! 1: LDXA_I	ldxa	[%r16, + 0x0b80] %asi, %r13
	.word 0xc61420d0  ! 1: LDUH_I	lduh	[%r16 + 0x00d0], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6942f06  ! 1: LDUHA_I	lduha	[%r16, + 0x0f06] %asi, %r3
	brnz %r31,thr3_loop_cnt_769
	dec %r31
	.word 0xb8042785  ! 1: ADD_I	add 	%r16, 0x0785, %r28
        mov 0x37, %r31
thr3_loop_cnt_770:
	.word 0xeac42468  ! 1: LDSWA_I	ldswa	[%r16, + 0x0468] %asi, %r21
	.word 0xde1424d2  ! 1: LDUH_I	lduh	[%r16 + 0x04d2], %r15
	.word 0xc64c26a6  ! 1: LDSB_I	ldsb	[%r16 + 0x06a6], %r3
	.word 0xe84c24c1  ! 1: LDSB_I	ldsb	[%r16 + 0x04c1], %r20
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2e28  ! 1: LDXA_I	ldxa	[%r16, + 0x0e28] %asi, %r3
	.word 0xd4cc2922  ! 1: LDSBA_I	ldsba	[%r16, + 0x0922] %asi, %r10
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	.word 0xc6142cf4  ! 1: LDUH_I	lduh	[%r16 + 0x0cf4], %r3
	.word 0xc6542c68  ! 1: LDSH_I	ldsh	[%r16 + 0x0c68], %r3
	.word 0xfa942034  ! 1: LDUHA_I	lduha	[%r16, + 0x0034] %asi, %r29
	brnz %r31,thr3_loop_cnt_770
	dec %r31
        mov 0x83, %r31
thr3_loop_cnt_771:
	.word 0xf85c26a0  ! 1: LDX_I	ldx	[%r16 + 0x06a0], %r28
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xf24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r25
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xde8c2e4d  ! 1: LDUBA_I	lduba	[%r16, + 0x0e4d] %asi, %r15
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xf68420c0  ! 1: LDUWA_I	lduwa	[%r16, + 0x00c0] %asi, %r27
	brnz %r31,thr3_loop_cnt_771
	dec %r31
	.word 0x863c23f3  ! 1: XNOR_I	xnor 	%r16, 0x03f3, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x9d2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r14
        mov 0x65, %r31
thr3_loop_cnt_772:
	.word 0xc6cc2c3a  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c3a] %asi, %r3
	.word 0xc68427d4  ! 1: LDUWA_I	lduwa	[%r16, + 0x07d4] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	.word 0xfa540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r29
	.word 0xd0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r8
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xda841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r13
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_772
	dec %r31
        mov 0x73, %r31
thr3_loop_cnt_773:
	.word 0xc6cc2dd1  ! 1: LDSBA_I	ldsba	[%r16, + 0x0dd1] %asi, %r3
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xd214214c  ! 1: LDUH_I	lduh	[%r16 + 0x014c], %r9
	.word 0xd28c2696  ! 1: LDUBA_I	lduba	[%r16, + 0x0696] %asi, %r9
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xde540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r15
	.word 0xc6042fd8  ! 1: LDUW_I	lduw	[%r16 + 0x0fd8], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xdadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r13
	.word 0xd0dc2dd8  ! 1: LDXA_I	ldxa	[%r16, + 0x0dd8] %asi, %r8
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_773
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0xa63c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r19
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x1b, %r31
thr3_loop_cnt_774:
	.word 0xdc4c2d9a  ! 1: LDSB_I	ldsb	[%r16 + 0x0d9a], %r14
	.word 0xf2842934  ! 1: LDUWA_I	lduwa	[%r16, + 0x0934] %asi, %r25
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xce042aa8  ! 1: LDUW_I	lduw	[%r16 + 0x0aa8], %r7
	.word 0xde841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r15
	.word 0xcedc29c8  ! 1: LDXA_I	ldxa	[%r16, + 0x09c8] %asi, %r7
	.word 0xfcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r30
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc694233c  ! 1: LDUHA_I	lduha	[%r16, + 0x033c] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r26
	.word 0xd8542a68  ! 1: LDSH_I	ldsh	[%r16 + 0x0a68], %r12
	brnz %r31,thr3_loop_cnt_774
	dec %r31
	.word 0xb12c0002  ! 1: SLL_R	sll 	%r16, %r2, %r24
	.word 0xb12c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r24
        mov 0xe, %r31
thr3_loop_cnt_775:
	.word 0xd0042c14  ! 1: LDUW_I	lduw	[%r16 + 0x0c14], %r8
	.word 0xfadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r29
	.word 0xc614263a  ! 1: LDUH_I	lduh	[%r16 + 0x063a], %r3
	.word 0xf8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r28
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r27
	.word 0xd0c42cb0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0cb0] %asi, %r8
	brnz %r31,thr3_loop_cnt_775
	dec %r31
	.word 0x86442fb8  ! 1: ADDC_I	addc 	%r16, 0x0fb8, %r3
	.word 0xa40c29b8  ! 1: AND_I	and 	%r16, 0x09b8, %r18
	.word 0xb20c0002  ! 1: AND_R	and 	%r16, %r2, %r25
        mov 0x92, %r31
thr3_loop_cnt_776:
	.word 0xe4d42868  ! 1: LDSHA_I	ldsha	[%r16, + 0x0868] %asi, %r18
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xfa94286c  ! 1: LDUHA_I	lduha	[%r16, + 0x086c] %asi, %r29
	.word 0xc6942426  ! 1: LDUHA_I	lduha	[%r16, + 0x0426] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r12
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_776
	dec %r31
	.word 0x992c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r12
	.word 0xac440002  ! 1: ADDC_R	addc 	%r16, %r2, %r22
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0xb1, %r31
thr3_loop_cnt_777:
	.word 0xe2dc2db0  ! 1: LDXA_I	ldxa	[%r16, + 0x0db0] %asi, %r17
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xda442cf8  ! 1: LDSW_I	ldsw	[%r16 + 0x0cf8], %r13
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd21422d8  ! 1: LDUH_I	lduh	[%r16 + 0x02d8], %r9
	.word 0xf6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r27
	.word 0xd24c206e  ! 1: LDSB_I	ldsb	[%r16 + 0x006e], %r9
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_777
	dec %r31
	.word 0x861c2150  ! 1: XOR_I	xor 	%r16, 0x0150, %r3
        mov 0x8, %r31
thr3_loop_cnt_778:
	.word 0xf41428a6  ! 1: LDUH_I	lduh	[%r16 + 0x08a6], %r26
	.word 0xeacc2d48  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d48] %asi, %r21
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf24422f4  ! 1: LDSW_I	ldsw	[%r16 + 0x02f4], %r25
	.word 0xc64422d4  ! 1: LDSW_I	ldsw	[%r16 + 0x02d4], %r3
	.word 0xc684285c  ! 1: LDUWA_I	lduwa	[%r16, + 0x085c] %asi, %r3
	.word 0xf6042c70  ! 1: LDUW_I	lduw	[%r16 + 0x0c70], %r27
	.word 0xd8d42d44  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d44] %asi, %r12
	.word 0xda942a36  ! 1: LDUHA_I	lduha	[%r16, + 0x0a36] %asi, %r13
	.word 0xc6442398  ! 1: LDSW_I	ldsw	[%r16 + 0x0398], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6c42190  ! 1: LDSWA_I	ldswa	[%r16, + 0x0190] %asi, %r3
	brnz %r31,thr3_loop_cnt_778
	dec %r31
	.word 0x903c2ead  ! 1: XNOR_I	xnor 	%r16, 0x0ead, %r8
	.word 0x913c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r8
        mov 0xa0, %r31
thr3_loop_cnt_779:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r19
	.word 0xf80c2e2e  ! 1: LDUB_I	ldub	[%r16 + 0x0e2e], %r28
	.word 0xc64c252c  ! 1: LDSB_I	ldsb	[%r16 + 0x052c], %r3
	.word 0xdc0c26fb  ! 1: LDUB_I	ldub	[%r16 + 0x06fb], %r14
	.word 0xe2cc226d  ! 1: LDSBA_I	ldsba	[%r16, + 0x026d] %asi, %r17
	.word 0xec942614  ! 1: LDUHA_I	lduha	[%r16, + 0x0614] %asi, %r22
	brnz %r31,thr3_loop_cnt_779
	dec %r31
	.word 0x93343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r9
	.word 0x940c0002  ! 1: AND_R	and 	%r16, %r2, %r10
	.word 0x98242b59  ! 1: SUB_I	sub 	%r16, 0x0b59, %r12
	.word 0x993c0002  ! 1: SRA_R	sra 	%r16, %r2, %r12
        mov 0xc, %r31
thr3_loop_cnt_780:
	.word 0xe60c2986  ! 1: LDUB_I	ldub	[%r16 + 0x0986], %r19
	.word 0xf6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r27
	.word 0xea040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r21
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xfc5c2ef8  ! 1: LDX_I	ldx	[%r16 + 0x0ef8], %r30
	.word 0xc68c2a9a  ! 1: LDUBA_I	lduba	[%r16, + 0x0a9a] %asi, %r3
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	.word 0xc6dc2e88  ! 1: LDXA_I	ldxa	[%r16, + 0x0e88] %asi, %r3
	.word 0xe4cc2232  ! 1: LDSBA_I	ldsba	[%r16, + 0x0232] %asi, %r18
	brnz %r31,thr3_loop_cnt_780
	dec %r31
	.word 0x9004245d  ! 1: ADD_I	add 	%r16, 0x045d, %r8
        mov 0x2, %r31
thr3_loop_cnt_781:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	.word 0xc6142dae  ! 1: LDUH_I	lduh	[%r16 + 0x0dae], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xdec42278  ! 1: LDSWA_I	ldswa	[%r16, + 0x0278] %asi, %r15
	.word 0xee8c2e25  ! 1: LDUBA_I	lduba	[%r16, + 0x0e25] %asi, %r23
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_781
	dec %r31
	.word 0xb13c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r24
	.word 0x86342987  ! 1: SUBC_I	orn 	%r16, 0x0987, %r3
        mov 0xb, %r31
thr3_loop_cnt_782:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r10
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xfcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r30
	.word 0xc6442c08  ! 1: LDSW_I	ldsw	[%r16 + 0x0c08], %r3
	.word 0xc60424ac  ! 1: LDUW_I	lduw	[%r16 + 0x04ac], %r3
	.word 0xd6dc2f20  ! 1: LDXA_I	ldxa	[%r16, + 0x0f20] %asi, %r11
	.word 0xccd429aa  ! 1: LDSHA_I	ldsha	[%r16, + 0x09aa] %asi, %r6
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6cc2035  ! 1: LDSBA_I	ldsba	[%r16, + 0x0035] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_782
	dec %r31
	.word 0xb6340002  ! 1: ORN_R	orn 	%r16, %r2, %r27
	.word 0x9b2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r13
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x993c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r12
        mov 0xae, %r31
thr3_loop_cnt_783:
	.word 0xc6d4264a  ! 1: LDSHA_I	ldsha	[%r16, + 0x064a] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r27
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xfac429f0  ! 1: LDSWA_I	ldswa	[%r16, + 0x09f0] %asi, %r29
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6d427a6  ! 1: LDSHA_I	ldsha	[%r16, + 0x07a6] %asi, %r3
	.word 0xc6d42a44  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a44] %asi, %r3
	brnz %r31,thr3_loop_cnt_783
	dec %r31
	.word 0x90442364  ! 1: ADDC_I	addc 	%r16, 0x0364, %r8
	.word 0x8e142b12  ! 1: OR_I	or 	%r16, 0x0b12, %r7
        mov 0xa7, %r31
thr3_loop_cnt_784:
	.word 0xc68c27f0  ! 1: LDUBA_I	lduba	[%r16, + 0x07f0] %asi, %r3
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xda540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r13
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc65c27e8  ! 1: LDX_I	ldx	[%r16 + 0x07e8], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc69423ae  ! 1: LDUHA_I	lduha	[%r16, + 0x03ae] %asi, %r3
	.word 0xe4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r18
	.word 0xc6d42012  ! 1: LDSHA_I	ldsha	[%r16, + 0x0012] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe88c2450  ! 1: LDUBA_I	lduba	[%r16, + 0x0450] %asi, %r20
	.word 0xeadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r21
	brnz %r31,thr3_loop_cnt_784
	dec %r31
	.word 0x8c340002  ! 1: SUBC_R	orn 	%r16, %r2, %r6
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0xd, %r31
thr3_loop_cnt_785:
	.word 0xc68c252a  ! 1: LDUBA_I	lduba	[%r16, + 0x052a] %asi, %r3
	.word 0xe6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r19
	.word 0xf8dc2e10  ! 1: LDXA_I	ldxa	[%r16, + 0x0e10] %asi, %r28
	.word 0xc65c2cb0  ! 1: LDX_I	ldx	[%r16 + 0x0cb0], %r3
	.word 0xccdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r6
	.word 0xc604292c  ! 1: LDUW_I	lduw	[%r16 + 0x092c], %r3
	.word 0xc654261a  ! 1: LDSH_I	ldsh	[%r16 + 0x061a], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc251c  ! 1: LDSBA_I	ldsba	[%r16, + 0x051c] %asi, %r3
	brnz %r31,thr3_loop_cnt_785
	dec %r31
	.word 0xac3c2778  ! 1: XNOR_I	xnor 	%r16, 0x0778, %r22
	.word 0xa6040002  ! 1: ADD_R	add 	%r16, %r2, %r19
        mov 0x8, %r31
thr3_loop_cnt_786:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc614257c  ! 1: LDUH_I	lduh	[%r16 + 0x057c], %r3
	.word 0xee142580  ! 1: LDUH_I	lduh	[%r16 + 0x0580], %r23
	.word 0xc6942f16  ! 1: LDUHA_I	lduha	[%r16, + 0x0f16] %asi, %r3
	.word 0xc60c2c54  ! 1: LDUB_I	ldub	[%r16 + 0x0c54], %r3
	.word 0xe2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r17
	.word 0xc694289a  ! 1: LDUHA_I	lduha	[%r16, + 0x089a] %asi, %r3
	.word 0xee140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r23
	.word 0xc60c2e40  ! 1: LDUB_I	ldub	[%r16 + 0x0e40], %r3
	.word 0xcc8c2f5a  ! 1: LDUBA_I	lduba	[%r16, + 0x0f5a] %asi, %r6
	brnz %r31,thr3_loop_cnt_786
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x82, %r31
thr3_loop_cnt_787:
	.word 0xdc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r14
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r10
	.word 0xd81428ec  ! 1: LDUH_I	lduh	[%r16 + 0x08ec], %r12
	.word 0xc65c28e8  ! 1: LDX_I	ldx	[%r16 + 0x08e8], %r3
	.word 0xe45c24a8  ! 1: LDX_I	ldx	[%r16 + 0x04a8], %r18
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xdccc22d0  ! 1: LDSBA_I	ldsba	[%r16, + 0x02d0] %asi, %r14
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_787
	dec %r31
	.word 0x993c1002  ! 1: SRAX_R	srax	%r16, %r2, %r12
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x64, %r31
thr3_loop_cnt_788:
	.word 0xec440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r22
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc68c27ba  ! 1: LDUBA_I	lduba	[%r16, + 0x07ba] %asi, %r3
	.word 0xc65c20f8  ! 1: LDX_I	ldx	[%r16 + 0x00f8], %r3
	.word 0xea042940  ! 1: LDUW_I	lduw	[%r16 + 0x0940], %r21
	.word 0xe444273c  ! 1: LDSW_I	ldsw	[%r16 + 0x073c], %r18
	.word 0xce542594  ! 1: LDSH_I	ldsh	[%r16 + 0x0594], %r7
	.word 0xc64c2630  ! 1: LDSB_I	ldsb	[%r16 + 0x0630], %r3
	.word 0xf6c42b3c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b3c] %asi, %r27
	brnz %r31,thr3_loop_cnt_788
	dec %r31
	.word 0x8c240002  ! 1: SUB_R	sub 	%r16, %r2, %r6
	.word 0xb93c0002  ! 1: SRA_R	sra 	%r16, %r2, %r28
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0xb42c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r26
        mov 0x63, %r31
thr3_loop_cnt_789:
	.word 0xf8cc2a61  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a61] %asi, %r28
	.word 0xc64c25c0  ! 1: LDSB_I	ldsb	[%r16 + 0x05c0], %r3
	.word 0xf68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r27
	.word 0xc6d428c6  ! 1: LDSHA_I	ldsha	[%r16, + 0x08c6] %asi, %r3
	.word 0xfacc27bc  ! 1: LDSBA_I	ldsba	[%r16, + 0x07bc] %asi, %r29
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6dc2298  ! 1: LDXA_I	ldxa	[%r16, + 0x0298] %asi, %r3
	.word 0xda841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r13
	brnz %r31,thr3_loop_cnt_789
	dec %r31
        mov 0x67, %r31
thr3_loop_cnt_790:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd8542c58  ! 1: LDSH_I	ldsh	[%r16 + 0x0c58], %r12
	.word 0xfa8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r29
	.word 0xe4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r18
	.word 0xc68c29c2  ! 1: LDUBA_I	lduba	[%r16, + 0x09c2] %asi, %r3
	.word 0xe6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r19
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	brnz %r31,thr3_loop_cnt_790
	dec %r31
	.word 0x983c2fa9  ! 1: XNOR_I	xnor 	%r16, 0x0fa9, %r12
        mov 0x6, %r31
thr3_loop_cnt_791:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf8d427aa  ! 1: LDSHA_I	ldsha	[%r16, + 0x07aa] %asi, %r28
	.word 0xc6442c54  ! 1: LDSW_I	ldsw	[%r16 + 0x0c54], %r3
	.word 0xd4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r10
	.word 0xc6442170  ! 1: LDSW_I	ldsw	[%r16 + 0x0170], %r3
	.word 0xf2c42760  ! 1: LDSWA_I	ldswa	[%r16, + 0x0760] %asi, %r25
	.word 0xc60429fc  ! 1: LDUW_I	lduw	[%r16 + 0x09fc], %r3
	.word 0xf0042c10  ! 1: LDUW_I	lduw	[%r16 + 0x0c10], %r24
	.word 0xf0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r24
	brnz %r31,thr3_loop_cnt_791
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0x0, %r31
thr3_loop_cnt_792:
	.word 0xda442208  ! 1: LDSW_I	ldsw	[%r16 + 0x0208], %r13
	.word 0xec4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r22
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6c42c78  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c78] %asi, %r3
	.word 0xe65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r19
	.word 0xe64c2bab  ! 1: LDSB_I	ldsb	[%r16 + 0x0bab], %r19
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	.word 0xe4dc2588  ! 1: LDXA_I	ldxa	[%r16, + 0x0588] %asi, %r18
	.word 0xfc9425cc  ! 1: LDUHA_I	lduha	[%r16, + 0x05cc] %asi, %r30
	brnz %r31,thr3_loop_cnt_792
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x3, %r31
thr3_loop_cnt_793:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc65428c0  ! 1: LDSH_I	ldsh	[%r16 + 0x08c0], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6cc2b65  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b65] %asi, %r3
	.word 0xc6442720  ! 1: LDSW_I	ldsw	[%r16 + 0x0720], %r3
	.word 0xcc0c2d4a  ! 1: LDUB_I	ldub	[%r16 + 0x0d4a], %r6
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd2d429c4  ! 1: LDSHA_I	ldsha	[%r16, + 0x09c4] %asi, %r9
	brnz %r31,thr3_loop_cnt_793
	dec %r31
	.word 0xa22c2d54  ! 1: ANDN_I	andn 	%r16, 0x0d54, %r17
	.word 0x993c0002  ! 1: SRA_R	sra 	%r16, %r2, %r12
        mov 0x9c, %r31
thr3_loop_cnt_794:
	.word 0xe48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r18
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	.word 0xfc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r30
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xea142324  ! 1: LDUH_I	lduh	[%r16 + 0x0324], %r21
	.word 0xd804252c  ! 1: LDUW_I	lduw	[%r16 + 0x052c], %r12
	.word 0xf8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r28
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xc6042014  ! 1: LDUW_I	lduw	[%r16 + 0x0014], %r3
	brnz %r31,thr3_loop_cnt_794
	dec %r31
	.word 0x9c3c2727  ! 1: XNOR_I	xnor 	%r16, 0x0727, %r14
        mov 0x18, %r31
thr3_loop_cnt_795:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf614296c  ! 1: LDUH_I	lduh	[%r16 + 0x096c], %r27
	.word 0xda540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r13
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xdacc2708  ! 1: LDSBA_I	ldsba	[%r16, + 0x0708] %asi, %r13
	.word 0xf8042630  ! 1: LDUW_I	lduw	[%r16 + 0x0630], %r28
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd004212c  ! 1: LDUW_I	lduw	[%r16 + 0x012c], %r8
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xf05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r24
	brnz %r31,thr3_loop_cnt_795
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x9224291d  ! 1: SUB_I	sub 	%r16, 0x091d, %r9
	.word 0x9a0c201e  ! 1: AND_I	and 	%r16, 0x001e, %r13
        mov 0xaf, %r31
thr3_loop_cnt_796:
	.word 0xc64c2010  ! 1: LDSB_I	ldsb	[%r16 + 0x0010], %r3
	.word 0xfc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r30
	.word 0xc6c429e0  ! 1: LDSWA_I	ldswa	[%r16, + 0x09e0] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc64c24b6  ! 1: LDSB_I	ldsb	[%r16 + 0x04b6], %r3
	.word 0xc60c25fb  ! 1: LDUB_I	ldub	[%r16 + 0x05fb], %r3
	.word 0xc60c23df  ! 1: LDUB_I	ldub	[%r16 + 0x03df], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xfa5c2a08  ! 1: LDX_I	ldx	[%r16 + 0x0a08], %r29
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc69425ee  ! 1: LDUHA_I	lduha	[%r16, + 0x05ee] %asi, %r3
	brnz %r31,thr3_loop_cnt_796
	dec %r31
	.word 0x9e440002  ! 1: ADDC_R	addc 	%r16, %r2, %r15
        mov 0x81, %r31
thr3_loop_cnt_797:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xccc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r6
	.word 0xc68c27c9  ! 1: LDUBA_I	lduba	[%r16, + 0x07c9] %asi, %r3
	.word 0xc65c2e48  ! 1: LDX_I	ldx	[%r16 + 0x0e48], %r3
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xd4d4289c  ! 1: LDSHA_I	ldsha	[%r16, + 0x089c] %asi, %r10
	.word 0xfc442e64  ! 1: LDSW_I	ldsw	[%r16 + 0x0e64], %r30
	.word 0xc65c2168  ! 1: LDX_I	ldx	[%r16 + 0x0168], %r3
	.word 0xe6542010  ! 1: LDSH_I	ldsh	[%r16 + 0x0010], %r19
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_797
	dec %r31
	.word 0xa73c1002  ! 1: SRAX_R	srax	%r16, %r2, %r19
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0xbc440002  ! 1: ADDC_R	addc 	%r16, %r2, %r30
        mov 0x2e, %r31
thr3_loop_cnt_798:
	.word 0xec0c29ae  ! 1: LDUB_I	ldub	[%r16 + 0x09ae], %r22
	.word 0xd254248e  ! 1: LDSH_I	ldsh	[%r16 + 0x048e], %r9
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd41421b4  ! 1: LDUH_I	lduh	[%r16 + 0x01b4], %r10
	.word 0xc60c2f42  ! 1: LDUB_I	ldub	[%r16 + 0x0f42], %r3
	.word 0xc64427c8  ! 1: LDSW_I	ldsw	[%r16 + 0x07c8], %r3
	.word 0xc68c23bc  ! 1: LDUBA_I	lduba	[%r16, + 0x03bc] %asi, %r3
	.word 0xc6842dcc  ! 1: LDUWA_I	lduwa	[%r16, + 0x0dcc] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc61426ee  ! 1: LDUH_I	lduh	[%r16 + 0x06ee], %r3
	brnz %r31,thr3_loop_cnt_798
	dec %r31
	.word 0x92240002  ! 1: SUB_R	sub 	%r16, %r2, %r9
	.word 0x963424bd  ! 1: ORN_I	orn 	%r16, 0x04bd, %r11
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x69, %r31
thr3_loop_cnt_799:
	.word 0xfc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r30
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6942af2  ! 1: LDUHA_I	lduha	[%r16, + 0x0af2] %asi, %r3
	.word 0xde5c2b10  ! 1: LDX_I	ldx	[%r16 + 0x0b10], %r15
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe2142fc2  ! 1: LDUH_I	lduh	[%r16 + 0x0fc2], %r17
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r9
	brnz %r31,thr3_loop_cnt_799
	dec %r31
	.word 0xaa440002  ! 1: ADDC_R	addc 	%r16, %r2, %r21
	.word 0x9a0c0002  ! 1: AND_R	and 	%r16, %r2, %r13
        mov 0x16, %r31
thr3_loop_cnt_800:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xda841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r13
	.word 0xce042ff0  ! 1: LDUW_I	lduw	[%r16 + 0x0ff0], %r7
	.word 0xc6dc2348  ! 1: LDXA_I	ldxa	[%r16, + 0x0348] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2b05  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b05] %asi, %r3
	.word 0xf8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r28
	brnz %r31,thr3_loop_cnt_800
	dec %r31
        mov 0x1b, %r31
thr3_loop_cnt_801:
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xc6c42d34  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d34] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xea142e1e  ! 1: LDUH_I	lduh	[%r16 + 0x0e1e], %r21
	.word 0xc6542328  ! 1: LDSH_I	ldsh	[%r16 + 0x0328], %r3
	.word 0xce941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r7
	.word 0xf6c423a8  ! 1: LDSWA_I	ldswa	[%r16, + 0x03a8] %asi, %r27
	.word 0xe6142702  ! 1: LDUH_I	lduh	[%r16 + 0x0702], %r19
	brnz %r31,thr3_loop_cnt_801
	dec %r31
	.word 0x92240002  ! 1: SUB_R	sub 	%r16, %r2, %r9
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0xba140002  ! 1: OR_R	or 	%r16, %r2, %r29
        mov 0x7b, %r31
thr3_loop_cnt_802:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf24c2788  ! 1: LDSB_I	ldsb	[%r16 + 0x0788], %r25
	.word 0xf8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r28
	.word 0xeecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r23
	.word 0xe8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r20
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xda942c68  ! 1: LDUHA_I	lduha	[%r16, + 0x0c68] %asi, %r13
	.word 0xd44426cc  ! 1: LDSW_I	ldsw	[%r16 + 0x06cc], %r10
	.word 0xf6042f18  ! 1: LDUW_I	lduw	[%r16 + 0x0f18], %r27
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	brnz %r31,thr3_loop_cnt_802
	dec %r31
        mov 0xbf, %r31
thr3_loop_cnt_803:
	.word 0xd25c2038  ! 1: LDX_I	ldx	[%r16 + 0x0038], %r9
	.word 0xe24c2e2d  ! 1: LDSB_I	ldsb	[%r16 + 0x0e2d], %r17
	.word 0xce0425d8  ! 1: LDUW_I	lduw	[%r16 + 0x05d8], %r7
	.word 0xf0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r24
	.word 0xe4c42394  ! 1: LDSWA_I	ldswa	[%r16, + 0x0394] %asi, %r18
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc65c2340  ! 1: LDX_I	ldx	[%r16 + 0x0340], %r3
	.word 0xf0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r24
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	brnz %r31,thr3_loop_cnt_803
	dec %r31
        mov 0x33, %r31
thr3_loop_cnt_804:
	.word 0xe8042db8  ! 1: LDUW_I	lduw	[%r16 + 0x0db8], %r20
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r17
	.word 0xee142eaa  ! 1: LDUH_I	lduh	[%r16 + 0x0eaa], %r23
	.word 0xd2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r9
	.word 0xdccc2010  ! 1: LDSBA_I	ldsba	[%r16, + 0x0010] %asi, %r14
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xd2dc2550  ! 1: LDXA_I	ldxa	[%r16, + 0x0550] %asi, %r9
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xea0c2bab  ! 1: LDUB_I	ldub	[%r16 + 0x0bab], %r21
	brnz %r31,thr3_loop_cnt_804
	dec %r31
	.word 0x862c2ab2  ! 1: ANDN_I	andn 	%r16, 0x0ab2, %r3
        mov 0x3f, %r31
thr3_loop_cnt_805:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc65c21a8  ! 1: LDX_I	ldx	[%r16 + 0x01a8], %r3
	.word 0xeedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r23
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc65c2358  ! 1: LDX_I	ldx	[%r16 + 0x0358], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xe2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r17
	.word 0xc6dc21f0  ! 1: LDXA_I	ldxa	[%r16, + 0x01f0] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_805
	dec %r31
	.word 0x860c2307  ! 1: AND_I	and 	%r16, 0x0307, %r3
        mov 0x88, %r31
thr3_loop_cnt_806:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe6142c02  ! 1: LDUH_I	lduh	[%r16 + 0x0c02], %r19
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe8d42f6e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f6e] %asi, %r20
	.word 0xc6442088  ! 1: LDSW_I	ldsw	[%r16 + 0x0088], %r3
	.word 0xe60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r19
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xce5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r7
	.word 0xda042808  ! 1: LDUW_I	lduw	[%r16 + 0x0808], %r13
	.word 0xc694201a  ! 1: LDUHA_I	lduha	[%r16, + 0x001a] %asi, %r3
	.word 0xf28426c8  ! 1: LDUWA_I	lduwa	[%r16, + 0x06c8] %asi, %r25
	brnz %r31,thr3_loop_cnt_806
	dec %r31
	.word 0xb4442145  ! 1: ADDC_I	addc 	%r16, 0x0145, %r26
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0xad, %r31
thr3_loop_cnt_807:
	.word 0xd28c257b  ! 1: LDUBA_I	lduba	[%r16, + 0x057b] %asi, %r9
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xdecc2abb  ! 1: LDSBA_I	ldsba	[%r16, + 0x0abb] %asi, %r15
	.word 0xf294264a  ! 1: LDUHA_I	lduha	[%r16, + 0x064a] %asi, %r25
	.word 0xfc142f52  ! 1: LDUH_I	lduh	[%r16 + 0x0f52], %r30
	.word 0xde5c2ee8  ! 1: LDX_I	ldx	[%r16 + 0x0ee8], %r15
	.word 0xce8c2a56  ! 1: LDUBA_I	lduba	[%r16, + 0x0a56] %asi, %r7
	.word 0xe24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r17
	.word 0xe20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r17
	.word 0xc6042f6c  ! 1: LDUW_I	lduw	[%r16 + 0x0f6c], %r3
	.word 0xec44262c  ! 1: LDSW_I	ldsw	[%r16 + 0x062c], %r22
	brnz %r31,thr3_loop_cnt_807
	dec %r31
	.word 0x91340002  ! 1: SRL_R	srl 	%r16, %r2, %r8
        mov 0x20, %r31
thr3_loop_cnt_808:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r8
	.word 0xf014251a  ! 1: LDUH_I	lduh	[%r16 + 0x051a], %r24
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xdc5c2310  ! 1: LDX_I	ldx	[%r16 + 0x0310], %r14
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xfa4c221f  ! 1: LDSB_I	ldsb	[%r16 + 0x021f], %r29
	.word 0xea140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r21
	.word 0xea0c242e  ! 1: LDUB_I	ldub	[%r16 + 0x042e], %r21
	.word 0xe6042f94  ! 1: LDUW_I	lduw	[%r16 + 0x0f94], %r19
	brnz %r31,thr3_loop_cnt_808
	dec %r31
	.word 0x9b341002  ! 1: SRLX_R	srlx	%r16, %r2, %r13
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0xba442412  ! 1: ADDC_I	addc 	%r16, 0x0412, %r29
        mov 0x54, %r31
thr3_loop_cnt_809:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc61424fa  ! 1: LDUH_I	lduh	[%r16 + 0x04fa], %r3
	.word 0xe60426f4  ! 1: LDUW_I	lduw	[%r16 + 0x06f4], %r19
	.word 0xea5c2670  ! 1: LDX_I	ldx	[%r16 + 0x0670], %r21
	.word 0xe25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r17
	.word 0xdc5c2228  ! 1: LDX_I	ldx	[%r16 + 0x0228], %r14
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6d42b6a  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b6a] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xea841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r21
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_809
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x8f2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r7
	.word 0x861c2d3d  ! 1: XOR_I	xor 	%r16, 0x0d3d, %r3
	.word 0x94140002  ! 1: OR_R	or 	%r16, %r2, %r10
        mov 0x4e, %r31
thr3_loop_cnt_810:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc64429d4  ! 1: LDSW_I	ldsw	[%r16 + 0x09d4], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xc65429ee  ! 1: LDSH_I	ldsh	[%r16 + 0x09ee], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc68c2a1d  ! 1: LDUBA_I	lduba	[%r16, + 0x0a1d] %asi, %r3
	.word 0xc6cc2110  ! 1: LDSBA_I	ldsba	[%r16, + 0x0110] %asi, %r3
	brnz %r31,thr3_loop_cnt_810
	dec %r31
        mov 0x82, %r31
thr3_loop_cnt_811:
	.word 0xc65c2330  ! 1: LDX_I	ldx	[%r16 + 0x0330], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6942462  ! 1: LDUHA_I	lduha	[%r16, + 0x0462] %asi, %r3
	.word 0xc69421f6  ! 1: LDUHA_I	lduha	[%r16, + 0x01f6] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r27
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	.word 0xf2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r25
	brnz %r31,thr3_loop_cnt_811
	dec %r31
	.word 0x8f3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r7
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0xb80425bd  ! 1: ADD_I	add 	%r16, 0x05bd, %r28
	.word 0x860c2282  ! 1: AND_I	and 	%r16, 0x0282, %r3
        mov 0x67, %r31
thr3_loop_cnt_812:
	.word 0xd49425a4  ! 1: LDUHA_I	lduha	[%r16, + 0x05a4] %asi, %r10
	.word 0xd884228c  ! 1: LDUWA_I	lduwa	[%r16, + 0x028c] %asi, %r12
	.word 0xfa8c2f5a  ! 1: LDUBA_I	lduba	[%r16, + 0x0f5a] %asi, %r29
	.word 0xe8c42b8c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b8c] %asi, %r20
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd00c2641  ! 1: LDUB_I	ldub	[%r16 + 0x0641], %r8
	.word 0xc6d42e86  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e86] %asi, %r3
	.word 0xc6542548  ! 1: LDSH_I	ldsh	[%r16 + 0x0548], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc65c2060  ! 1: LDX_I	ldx	[%r16 + 0x0060], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xccd42788  ! 1: LDSHA_I	ldsha	[%r16, + 0x0788] %asi, %r6
	brnz %r31,thr3_loop_cnt_812
	dec %r31
        mov 0x92, %r31
thr3_loop_cnt_813:
	.word 0xd0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r8
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6442904  ! 1: LDSW_I	ldsw	[%r16 + 0x0904], %r3
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	.word 0xc6c423b4  ! 1: LDSWA_I	ldswa	[%r16, + 0x03b4] %asi, %r3
	.word 0xf6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r27
	.word 0xc684213c  ! 1: LDUWA_I	lduwa	[%r16, + 0x013c] %asi, %r3
	.word 0xf6042cac  ! 1: LDUW_I	lduw	[%r16 + 0x0cac], %r27
	brnz %r31,thr3_loop_cnt_813
	dec %r31
	.word 0xba2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r29
	.word 0x92342863  ! 1: ORN_I	orn 	%r16, 0x0863, %r9
	.word 0xbc0c23bc  ! 1: AND_I	and 	%r16, 0x03bc, %r30
	.word 0x862c287b  ! 1: ANDN_I	andn 	%r16, 0x087b, %r3
        mov 0x45, %r31
thr3_loop_cnt_814:
	.word 0xc6c42a88  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a88] %asi, %r3
	.word 0xc6dc2478  ! 1: LDXA_I	ldxa	[%r16, + 0x0478] %asi, %r3
	.word 0xd8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r12
	.word 0xce8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r7
	.word 0xf4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r26
	.word 0xde140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r15
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xe24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r17
	.word 0xe20c2abc  ! 1: LDUB_I	ldub	[%r16 + 0x0abc], %r17
	.word 0xeec42f38  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f38] %asi, %r23
	.word 0xc6142f88  ! 1: LDUH_I	lduh	[%r16 + 0x0f88], %r3
	brnz %r31,thr3_loop_cnt_814
	dec %r31
	.word 0x921c22be  ! 1: XOR_I	xor 	%r16, 0x02be, %r9
	.word 0x8d3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r6
	.word 0x86342209  ! 1: ORN_I	orn 	%r16, 0x0209, %r3
	.word 0x86342dc7  ! 1: ORN_I	orn 	%r16, 0x0dc7, %r3
        mov 0x10, %r31
thr3_loop_cnt_815:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6c42c20  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c20] %asi, %r3
	.word 0xcc142604  ! 1: LDUH_I	lduh	[%r16 + 0x0604], %r6
	.word 0xd4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r10
	.word 0xe6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r19
	.word 0xd0c422b4  ! 1: LDSWA_I	ldswa	[%r16, + 0x02b4] %asi, %r8
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xd8042be8  ! 1: LDUW_I	lduw	[%r16 + 0x0be8], %r12
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xc6942cd8  ! 1: LDUHA_I	lduha	[%r16, + 0x0cd8] %asi, %r3
	brnz %r31,thr3_loop_cnt_815
	dec %r31
	.word 0xbc342291  ! 1: ORN_I	orn 	%r16, 0x0291, %r30
        mov 0x27, %r31
thr3_loop_cnt_816:
	.word 0xec440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r22
	.word 0xec4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r22
	.word 0xc6042780  ! 1: LDUW_I	lduw	[%r16 + 0x0780], %r3
	.word 0xded429b2  ! 1: LDSHA_I	ldsha	[%r16, + 0x09b2] %asi, %r15
	.word 0xde140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r15
	.word 0xce4c2439  ! 1: LDSB_I	ldsb	[%r16 + 0x0439], %r7
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xce442ce0  ! 1: LDSW_I	ldsw	[%r16 + 0x0ce0], %r7
	brnz %r31,thr3_loop_cnt_816
	dec %r31
	.word 0x86342b16  ! 1: SUBC_I	orn 	%r16, 0x0b16, %r3
        mov 0x82, %r31
thr3_loop_cnt_817:
	.word 0xc68c2ee1  ! 1: LDUBA_I	lduba	[%r16, + 0x0ee1] %asi, %r3
	.word 0xe8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r20
	.word 0xc68c2c28  ! 1: LDUBA_I	lduba	[%r16, + 0x0c28] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	.word 0xc6142ade  ! 1: LDUH_I	lduh	[%r16 + 0x0ade], %r3
	.word 0xfa440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r29
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_817
	dec %r31
        mov 0xba, %r31
thr3_loop_cnt_818:
	.word 0xc6c42338  ! 1: LDSWA_I	ldswa	[%r16, + 0x0338] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xec841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r22
	.word 0xd2c42080  ! 1: LDSWA_I	ldswa	[%r16, + 0x0080] %asi, %r9
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r18
	.word 0xfa442d28  ! 1: LDSW_I	ldsw	[%r16 + 0x0d28], %r29
	brnz %r31,thr3_loop_cnt_818
	dec %r31
        mov 0xb2, %r31
thr3_loop_cnt_819:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xd2c42280  ! 1: LDSWA_I	ldswa	[%r16, + 0x0280] %asi, %r9
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd84c2f20  ! 1: LDSB_I	ldsb	[%r16 + 0x0f20], %r12
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xfc942822  ! 1: LDUHA_I	lduha	[%r16, + 0x0822] %asi, %r30
	.word 0xde442924  ! 1: LDSW_I	ldsw	[%r16 + 0x0924], %r15
	.word 0xc614204a  ! 1: LDUH_I	lduh	[%r16 + 0x004a], %r3
	.word 0xfccc2683  ! 1: LDSBA_I	ldsba	[%r16, + 0x0683] %asi, %r30
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_819
	dec %r31
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x91343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r8
	.word 0x86342afa  ! 1: SUBC_I	orn 	%r16, 0x0afa, %r3
	.word 0x8f2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r7
        mov 0x24, %r31
thr3_loop_cnt_820:
	.word 0xd2d427e0  ! 1: LDSHA_I	ldsha	[%r16, + 0x07e0] %asi, %r9
	.word 0xcc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r6
	.word 0xe2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r17
	.word 0xc6442cf4  ! 1: LDSW_I	ldsw	[%r16 + 0x0cf4], %r3
	.word 0xc6dc2028  ! 1: LDXA_I	ldxa	[%r16, + 0x0028] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r19
	.word 0xd85c2128  ! 1: LDX_I	ldx	[%r16 + 0x0128], %r12
	brnz %r31,thr3_loop_cnt_820
	dec %r31
        mov 0x6c, %r31
thr3_loop_cnt_821:
	.word 0xe2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r17
	.word 0xc6d421fe  ! 1: LDSHA_I	ldsha	[%r16, + 0x01fe] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6cc2c07  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c07] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xdcc42e8c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e8c] %asi, %r14
	.word 0xd0442e78  ! 1: LDSW_I	ldsw	[%r16 + 0x0e78], %r8
	.word 0xc6042c80  ! 1: LDUW_I	lduw	[%r16 + 0x0c80], %r3
	.word 0xc6dc2780  ! 1: LDXA_I	ldxa	[%r16, + 0x0780] %asi, %r3
	.word 0xf00c252a  ! 1: LDUB_I	ldub	[%r16 + 0x052a], %r24
	.word 0xe6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r19
	.word 0xf60c25ff  ! 1: LDUB_I	ldub	[%r16 + 0x05ff], %r27
	brnz %r31,thr3_loop_cnt_821
	dec %r31
	.word 0x98242e47  ! 1: SUB_I	sub 	%r16, 0x0e47, %r12
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0x2f, %r31
thr3_loop_cnt_822:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xde042d64  ! 1: LDUW_I	lduw	[%r16 + 0x0d64], %r15
	.word 0xde042378  ! 1: LDUW_I	lduw	[%r16 + 0x0378], %r15
	.word 0xc64c276f  ! 1: LDSB_I	ldsb	[%r16 + 0x076f], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xda542246  ! 1: LDSH_I	ldsh	[%r16 + 0x0246], %r13
	.word 0xf6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r27
	.word 0xc604217c  ! 1: LDUW_I	lduw	[%r16 + 0x017c], %r3
	.word 0xdcc42338  ! 1: LDSWA_I	ldswa	[%r16, + 0x0338] %asi, %r14
	.word 0xf8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r28
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	brnz %r31,thr3_loop_cnt_822
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0xb5343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r26
        mov 0x6b, %r31
thr3_loop_cnt_823:
	.word 0xd8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r12
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc65c2488  ! 1: LDX_I	ldx	[%r16 + 0x0488], %r3
	.word 0xc6442640  ! 1: LDSW_I	ldsw	[%r16 + 0x0640], %r3
	.word 0xc6142c26  ! 1: LDUH_I	lduh	[%r16 + 0x0c26], %r3
	.word 0xf6942e52  ! 1: LDUHA_I	lduha	[%r16, + 0x0e52] %asi, %r27
	.word 0xde142cf8  ! 1: LDUH_I	lduh	[%r16 + 0x0cf8], %r15
	brnz %r31,thr3_loop_cnt_823
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x86142441  ! 1: OR_I	or 	%r16, 0x0441, %r3
        mov 0xc2, %r31
thr3_loop_cnt_824:
	.word 0xdc4c2af2  ! 1: LDSB_I	ldsb	[%r16 + 0x0af2], %r14
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc69429b6  ! 1: LDUHA_I	lduha	[%r16, + 0x09b6] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xfcd423fa  ! 1: LDSHA_I	ldsha	[%r16, + 0x03fa] %asi, %r30
	.word 0xd8d428f8  ! 1: LDSHA_I	ldsha	[%r16, + 0x08f8] %asi, %r12
	.word 0xce5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r7
	.word 0xc6cc2109  ! 1: LDSBA_I	ldsba	[%r16, + 0x0109] %asi, %r3
	.word 0xc69424bc  ! 1: LDUHA_I	lduha	[%r16, + 0x04bc] %asi, %r3
	.word 0xc68c2a74  ! 1: LDUBA_I	lduba	[%r16, + 0x0a74] %asi, %r3
	.word 0xcc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r6
	.word 0xc64c21a1  ! 1: LDSB_I	ldsb	[%r16 + 0x01a1], %r3
	brnz %r31,thr3_loop_cnt_824
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x8e142435  ! 1: OR_I	or 	%r16, 0x0435, %r7
        mov 0x6e, %r31
thr3_loop_cnt_825:
	.word 0xc6442368  ! 1: LDSW_I	ldsw	[%r16 + 0x0368], %r3
	.word 0xda5c22f0  ! 1: LDX_I	ldx	[%r16 + 0x02f0], %r13
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc69427f8  ! 1: LDUHA_I	lduha	[%r16, + 0x07f8] %asi, %r3
	.word 0xf2c420b4  ! 1: LDSWA_I	ldswa	[%r16, + 0x00b4] %asi, %r25
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6c421c0  ! 1: LDSWA_I	ldswa	[%r16, + 0x01c0] %asi, %r3
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	brnz %r31,thr3_loop_cnt_825
	dec %r31
	.word 0xa72c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r19
        mov 0x6f, %r31
thr3_loop_cnt_826:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6dc2270  ! 1: LDXA_I	ldxa	[%r16, + 0x0270] %asi, %r3
	.word 0xdad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r13
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xfac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r29
	.word 0xd2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r9
	.word 0xc6d42414  ! 1: LDSHA_I	ldsha	[%r16, + 0x0414] %asi, %r3
	brnz %r31,thr3_loop_cnt_826
	dec %r31
	.word 0x98042d6a  ! 1: ADD_I	add 	%r16, 0x0d6a, %r12
	.word 0xb13c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r24
        mov 0x13, %r31
thr3_loop_cnt_827:
	.word 0xfc5c20c0  ! 1: LDX_I	ldx	[%r16 + 0x00c0], %r30
	.word 0xcc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r6
	.word 0xc6142978  ! 1: LDUH_I	lduh	[%r16 + 0x0978], %r3
	.word 0xf0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r24
	.word 0xf2142724  ! 1: LDUH_I	lduh	[%r16 + 0x0724], %r25
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6cc22e0  ! 1: LDSBA_I	ldsba	[%r16, + 0x02e0] %asi, %r3
	brnz %r31,thr3_loop_cnt_827
	dec %r31
	.word 0x96442d2d  ! 1: ADDC_I	addc 	%r16, 0x0d2d, %r11
        mov 0x36, %r31
thr3_loop_cnt_828:
	.word 0xc6dc2368  ! 1: LDXA_I	ldxa	[%r16, + 0x0368] %asi, %r3
	.word 0xd68c2d34  ! 1: LDUBA_I	lduba	[%r16, + 0x0d34] %asi, %r11
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c42ee0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ee0] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc60c2654  ! 1: LDUB_I	ldub	[%r16 + 0x0654], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc65c2460  ! 1: LDX_I	ldx	[%r16 + 0x0460], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6d42b26  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b26] %asi, %r3
	brnz %r31,thr3_loop_cnt_828
	dec %r31
	.word 0x90242f38  ! 1: SUB_I	sub 	%r16, 0x0f38, %r8
        mov 0x94, %r31
thr3_loop_cnt_829:
	.word 0xfcdc20b0  ! 1: LDXA_I	ldxa	[%r16, + 0x00b0] %asi, %r30
	.word 0xc6d4236a  ! 1: LDSHA_I	ldsha	[%r16, + 0x036a] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd4c42228  ! 1: LDSWA_I	ldswa	[%r16, + 0x0228] %asi, %r10
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xcec4216c  ! 1: LDSWA_I	ldswa	[%r16, + 0x016c] %asi, %r7
	.word 0xc64c2d56  ! 1: LDSB_I	ldsb	[%r16 + 0x0d56], %r3
	.word 0xd4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r10
	.word 0xd20426bc  ! 1: LDUW_I	lduw	[%r16 + 0x06bc], %r9
	brnz %r31,thr3_loop_cnt_829
	dec %r31
        mov 0x57, %r31
thr3_loop_cnt_830:
	.word 0xc6cc2ba9  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ba9] %asi, %r3
	.word 0xf48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r26
	.word 0xd05425d8  ! 1: LDSH_I	ldsh	[%r16 + 0x05d8], %r8
	.word 0xc65423a2  ! 1: LDSH_I	ldsh	[%r16 + 0x03a2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc65c2ae8  ! 1: LDX_I	ldx	[%r16 + 0x0ae8], %r3
	.word 0xc6dc2528  ! 1: LDXA_I	ldxa	[%r16, + 0x0528] %asi, %r3
	.word 0xd8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r12
	brnz %r31,thr3_loop_cnt_830
	dec %r31
	.word 0x980c0002  ! 1: AND_R	and 	%r16, %r2, %r12
	.word 0x9e0c24b2  ! 1: AND_I	and 	%r16, 0x04b2, %r15
        mov 0x15, %r31
thr3_loop_cnt_831:
	.word 0xc65c25b0  ! 1: LDX_I	ldx	[%r16 + 0x05b0], %r3
	.word 0xc6442a9c  ! 1: LDSW_I	ldsw	[%r16 + 0x0a9c], %r3
	.word 0xc6842a4c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a4c] %asi, %r3
	.word 0xea040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r21
	.word 0xf44422f0  ! 1: LDSW_I	ldsw	[%r16 + 0x02f0], %r26
	.word 0xc64425bc  ! 1: LDSW_I	ldsw	[%r16 + 0x05bc], %r3
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	.word 0xc6442c38  ! 1: LDSW_I	ldsw	[%r16 + 0x0c38], %r3
	.word 0xc64424e4  ! 1: LDSW_I	ldsw	[%r16 + 0x04e4], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6442ae4  ! 1: LDSW_I	ldsw	[%r16 + 0x0ae4], %r3
	brnz %r31,thr3_loop_cnt_831
	dec %r31
        mov 0x24, %r31
thr3_loop_cnt_832:
	.word 0xc60c2416  ! 1: LDUB_I	ldub	[%r16 + 0x0416], %r3
	.word 0xe2142230  ! 1: LDUH_I	lduh	[%r16 + 0x0230], %r17
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6942e0c  ! 1: LDUHA_I	lduha	[%r16, + 0x0e0c] %asi, %r3
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r17
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6cc28e7  ! 1: LDSBA_I	ldsba	[%r16, + 0x08e7] %asi, %r3
	.word 0xc69420ba  ! 1: LDUHA_I	lduha	[%r16, + 0x00ba] %asi, %r3
	.word 0xc6042bec  ! 1: LDUW_I	lduw	[%r16 + 0x0bec], %r3
	.word 0xe814283a  ! 1: LDUH_I	lduh	[%r16 + 0x083a], %r20
	brnz %r31,thr3_loop_cnt_832
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x8c240002  ! 1: SUB_R	sub 	%r16, %r2, %r6
	.word 0xbb2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r29
        mov 0x33, %r31
thr3_loop_cnt_833:
	.word 0xf6042a60  ! 1: LDUW_I	lduw	[%r16 + 0x0a60], %r27
	.word 0xfc8c20f4  ! 1: LDUBA_I	lduba	[%r16, + 0x00f4] %asi, %r30
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xde0c2f9e  ! 1: LDUB_I	ldub	[%r16 + 0x0f9e], %r15
	.word 0xde5c2cf8  ! 1: LDX_I	ldx	[%r16 + 0x0cf8], %r15
	.word 0xf6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r27
	.word 0xc6842ba8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ba8] %asi, %r3
	.word 0xcc0427c4  ! 1: LDUW_I	lduw	[%r16 + 0x07c4], %r6
	.word 0xf6942390  ! 1: LDUHA_I	lduha	[%r16, + 0x0390] %asi, %r27
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xda4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r13
	.word 0xf20c210a  ! 1: LDUB_I	ldub	[%r16 + 0x010a], %r25
	brnz %r31,thr3_loop_cnt_833
	dec %r31
	.word 0xbc240002  ! 1: SUB_R	sub 	%r16, %r2, %r30
        mov 0x5e, %r31
thr3_loop_cnt_834:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xec4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r22
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xf0cc2a3c  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a3c] %asi, %r24
	.word 0xd45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r10
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe4cc249b  ! 1: LDSBA_I	ldsba	[%r16, + 0x049b] %asi, %r18
	.word 0xf0c42f58  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f58] %asi, %r24
	.word 0xdc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r14
	brnz %r31,thr3_loop_cnt_834
	dec %r31
	.word 0xbc340002  ! 1: SUBC_R	orn 	%r16, %r2, %r30
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x86442a50  ! 1: ADDC_I	addc 	%r16, 0x0a50, %r3
        mov 0xb5, %r31
thr3_loop_cnt_835:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc68c26b5  ! 1: LDUBA_I	lduba	[%r16, + 0x06b5] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r18
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc64c2276  ! 1: LDSB_I	ldsb	[%r16 + 0x0276], %r3
	.word 0xc60c20fc  ! 1: LDUB_I	ldub	[%r16 + 0x00fc], %r3
	.word 0xf04c2111  ! 1: LDSB_I	ldsb	[%r16 + 0x0111], %r24
	.word 0xf6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r27
	brnz %r31,thr3_loop_cnt_835
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0xa3343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r17
	.word 0x943c2a2b  ! 1: XNOR_I	xnor 	%r16, 0x0a2b, %r10
        mov 0x24, %r31
thr3_loop_cnt_836:
	.word 0xcc5c2510  ! 1: LDX_I	ldx	[%r16 + 0x0510], %r6
	.word 0xc6cc255a  ! 1: LDSBA_I	ldsba	[%r16, + 0x055a] %asi, %r3
	.word 0xc64c26a0  ! 1: LDSB_I	ldsb	[%r16 + 0x06a0], %r3
	.word 0xf6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r27
	.word 0xc60423c8  ! 1: LDUW_I	lduw	[%r16 + 0x03c8], %r3
	.word 0xccc42294  ! 1: LDSWA_I	ldswa	[%r16, + 0x0294] %asi, %r6
	.word 0xda9424f8  ! 1: LDUHA_I	lduha	[%r16, + 0x04f8] %asi, %r13
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd6dc2388  ! 1: LDXA_I	ldxa	[%r16, + 0x0388] %asi, %r11
	.word 0xcc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r6
	.word 0xc6c42618  ! 1: LDSWA_I	ldswa	[%r16, + 0x0618] %asi, %r3
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	brnz %r31,thr3_loop_cnt_836
	dec %r31
        mov 0x61, %r31
thr3_loop_cnt_837:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xeec422a8  ! 1: LDSWA_I	ldswa	[%r16, + 0x02a8] %asi, %r23
	.word 0xf08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r24
	.word 0xd0842550  ! 1: LDUWA_I	lduwa	[%r16, + 0x0550] %asi, %r8
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc65c2e98  ! 1: LDX_I	ldx	[%r16 + 0x0e98], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	brnz %r31,thr3_loop_cnt_837
	dec %r31
	.word 0x86342df0  ! 1: ORN_I	orn 	%r16, 0x0df0, %r3
	.word 0x8d2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r6
	.word 0x86242000  ! 1: SUB_I	sub 	%r16, 0x0000, %r3
        mov 0x40, %r31
thr3_loop_cnt_838:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xdec427a4  ! 1: LDSWA_I	ldswa	[%r16, + 0x07a4] %asi, %r15
	.word 0xc65c2640  ! 1: LDX_I	ldx	[%r16 + 0x0640], %r3
	.word 0xda440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r13
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xc68c2392  ! 1: LDUBA_I	lduba	[%r16, + 0x0392] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc614209e  ! 1: LDUH_I	lduh	[%r16 + 0x009e], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xce440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r7
	brnz %r31,thr3_loop_cnt_838
	dec %r31
        mov 0x9b, %r31
thr3_loop_cnt_839:
	.word 0xc6cc2107  ! 1: LDSBA_I	ldsba	[%r16, + 0x0107] %asi, %r3
	.word 0xfa8c2e64  ! 1: LDUBA_I	lduba	[%r16, + 0x0e64] %asi, %r29
	.word 0xee4c22a2  ! 1: LDSB_I	ldsb	[%r16 + 0x02a2], %r23
	.word 0xe2d42122  ! 1: LDSHA_I	ldsha	[%r16, + 0x0122] %asi, %r17
	.word 0xfa040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r29
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6542e38  ! 1: LDSH_I	ldsh	[%r16 + 0x0e38], %r3
	.word 0xda1420e2  ! 1: LDUH_I	lduh	[%r16 + 0x00e2], %r13
	.word 0xc68c29fc  ! 1: LDUBA_I	lduba	[%r16, + 0x09fc] %asi, %r3
	brnz %r31,thr3_loop_cnt_839
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0x94, %r31
thr3_loop_cnt_840:
	.word 0xc6142c8a  ! 1: LDUH_I	lduh	[%r16 + 0x0c8a], %r3
	.word 0xc6942a3c  ! 1: LDUHA_I	lduha	[%r16, + 0x0a3c] %asi, %r3
	.word 0xde8c2f28  ! 1: LDUBA_I	lduba	[%r16, + 0x0f28] %asi, %r15
	.word 0xc69424dc  ! 1: LDUHA_I	lduha	[%r16, + 0x04dc] %asi, %r3
	.word 0xf2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r25
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r10
	.word 0xe48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r18
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xec0429e4  ! 1: LDUW_I	lduw	[%r16 + 0x09e4], %r22
	brnz %r31,thr3_loop_cnt_840
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x1d, %r31
thr3_loop_cnt_841:
	.word 0xc6442a68  ! 1: LDSW_I	ldsw	[%r16 + 0x0a68], %r3
	.word 0xda0c2f0f  ! 1: LDUB_I	ldub	[%r16 + 0x0f0f], %r13
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r27
	.word 0xc6442bc4  ! 1: LDSW_I	ldsw	[%r16 + 0x0bc4], %r3
	.word 0xf4442364  ! 1: LDSW_I	ldsw	[%r16 + 0x0364], %r26
	.word 0xc6cc2eb7  ! 1: LDSBA_I	ldsba	[%r16, + 0x0eb7] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc61423fe  ! 1: LDUH_I	lduh	[%r16 + 0x03fe], %r3
	.word 0xdedc22f0  ! 1: LDXA_I	ldxa	[%r16, + 0x02f0] %asi, %r15
	brnz %r31,thr3_loop_cnt_841
	dec %r31
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0xa92c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r20
	.word 0xbd2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r30
        mov 0x76, %r31
thr3_loop_cnt_842:
	.word 0xe6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r19
	.word 0xc6d42d60  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d60] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r28
	.word 0xdc8c2cd2  ! 1: LDUBA_I	lduba	[%r16, + 0x0cd2] %asi, %r14
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6d426aa  ! 1: LDSHA_I	ldsha	[%r16, + 0x06aa] %asi, %r3
	.word 0xde040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r15
	.word 0xf294282e  ! 1: LDUHA_I	lduha	[%r16, + 0x082e] %asi, %r25
	brnz %r31,thr3_loop_cnt_842
	dec %r31
        mov 0x30, %r31
thr3_loop_cnt_843:
	.word 0xde841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r15
	.word 0xcc14286c  ! 1: LDUH_I	lduh	[%r16 + 0x086c], %r6
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6042514  ! 1: LDUW_I	lduw	[%r16 + 0x0514], %r3
	.word 0xd80c21e7  ! 1: LDUB_I	ldub	[%r16 + 0x01e7], %r12
	.word 0xc6d42502  ! 1: LDSHA_I	ldsha	[%r16, + 0x0502] %asi, %r3
	.word 0xda142646  ! 1: LDUH_I	lduh	[%r16 + 0x0646], %r13
	.word 0xecd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r22
	.word 0xc68c2f8f  ! 1: LDUBA_I	lduba	[%r16, + 0x0f8f] %asi, %r3
	.word 0xde841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r15
	brnz %r31,thr3_loop_cnt_843
	dec %r31
	.word 0xb2340002  ! 1: ORN_R	orn 	%r16, %r2, %r25
	.word 0x861c2093  ! 1: XOR_I	xor 	%r16, 0x0093, %r3
	.word 0x9d341002  ! 1: SRLX_R	srlx	%r16, %r2, %r14
        mov 0x2f, %r31
thr3_loop_cnt_844:
	.word 0xc6d420de  ! 1: LDSHA_I	ldsha	[%r16, + 0x00de] %asi, %r3
	.word 0xde442888  ! 1: LDSW_I	ldsw	[%r16 + 0x0888], %r15
	.word 0xfcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r30
	.word 0xd2d42778  ! 1: LDSHA_I	ldsha	[%r16, + 0x0778] %asi, %r9
	.word 0xc64c2c28  ! 1: LDSB_I	ldsb	[%r16 + 0x0c28], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xfa442c54  ! 1: LDSW_I	ldsw	[%r16 + 0x0c54], %r29
	brnz %r31,thr3_loop_cnt_844
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x98, %r31
thr3_loop_cnt_845:
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xec0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r22
	.word 0xe8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r20
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xee442278  ! 1: LDSW_I	ldsw	[%r16 + 0x0278], %r23
	brnz %r31,thr3_loop_cnt_845
	dec %r31
	.word 0x920429fc  ! 1: ADD_I	add 	%r16, 0x09fc, %r9
	.word 0x912c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r8
	.word 0xa214201f  ! 1: OR_I	or 	%r16, 0x001f, %r17
	.word 0xa2342349  ! 1: ORN_I	orn 	%r16, 0x0349, %r17
        mov 0x3c, %r31
thr3_loop_cnt_846:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc64c2c46  ! 1: LDSB_I	ldsb	[%r16 + 0x0c46], %r3
	.word 0xc654239e  ! 1: LDSH_I	ldsh	[%r16 + 0x039e], %r3
	.word 0xd89421ac  ! 1: LDUHA_I	lduha	[%r16, + 0x01ac] %asi, %r12
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2770  ! 1: LDSBA_I	ldsba	[%r16, + 0x0770] %asi, %r3
	.word 0xec9425dc  ! 1: LDUHA_I	lduha	[%r16, + 0x05dc] %asi, %r22
	.word 0xd20c2e67  ! 1: LDUB_I	ldub	[%r16 + 0x0e67], %r9
	.word 0xf4542aa4  ! 1: LDSH_I	ldsh	[%r16 + 0x0aa4], %r26
	brnz %r31,thr3_loop_cnt_846
	dec %r31
	.word 0xa93c0002  ! 1: SRA_R	sra 	%r16, %r2, %r20
        mov 0x58, %r31
thr3_loop_cnt_847:
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xc60422e4  ! 1: LDUW_I	lduw	[%r16 + 0x02e4], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6cc2ef0  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ef0] %asi, %r3
	.word 0xf094238c  ! 1: LDUHA_I	lduha	[%r16, + 0x038c] %asi, %r24
	.word 0xf8c421b4  ! 1: LDSWA_I	ldswa	[%r16, + 0x01b4] %asi, %r28
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	.word 0xea8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r21
	.word 0xc6042794  ! 1: LDUW_I	lduw	[%r16 + 0x0794], %r3
	.word 0xcc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r6
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc64c2ad9  ! 1: LDSB_I	ldsb	[%r16 + 0x0ad9], %r3
	brnz %r31,thr3_loop_cnt_847
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x48, %r31
thr3_loop_cnt_848:
	.word 0xc61425da  ! 1: LDUH_I	lduh	[%r16 + 0x05da], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc68c28eb  ! 1: LDUBA_I	lduba	[%r16, + 0x08eb] %asi, %r3
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xe2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r17
	.word 0xec442644  ! 1: LDSW_I	ldsw	[%r16 + 0x0644], %r22
	.word 0xdecc2526  ! 1: LDSBA_I	ldsba	[%r16, + 0x0526] %asi, %r15
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xde941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r15
	.word 0xccd42fa6  ! 1: LDSHA_I	ldsha	[%r16, + 0x0fa6] %asi, %r6
	.word 0xe2cc2832  ! 1: LDSBA_I	ldsba	[%r16, + 0x0832] %asi, %r17
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_848
	dec %r31
	.word 0x862c2b5c  ! 1: ANDN_I	andn 	%r16, 0x0b5c, %r3
	.word 0x863c2f6f  ! 1: XNOR_I	xnor 	%r16, 0x0f6f, %r3
        mov 0x5f, %r31
thr3_loop_cnt_849:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r19
	.word 0xc6442ec8  ! 1: LDSW_I	ldsw	[%r16 + 0x0ec8], %r3
	.word 0xf4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r26
	.word 0xde540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r15
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd2942e7c  ! 1: LDUHA_I	lduha	[%r16, + 0x0e7c] %asi, %r9
	.word 0xda94230e  ! 1: LDUHA_I	lduha	[%r16, + 0x030e] %asi, %r13
	.word 0xf8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r28
	brnz %r31,thr3_loop_cnt_849
	dec %r31
        mov 0x88, %r31
thr3_loop_cnt_850:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6d42c8c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c8c] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc60c24b5  ! 1: LDUB_I	ldub	[%r16 + 0x04b5], %r3
	.word 0xc6542000  ! 1: LDSH_I	ldsh	[%r16 + 0x0000], %r3
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xc6542a0c  ! 1: LDSH_I	ldsh	[%r16 + 0x0a0c], %r3
	.word 0xd4d422bc  ! 1: LDSHA_I	ldsha	[%r16, + 0x02bc] %asi, %r10
	.word 0xf8dc22c0  ! 1: LDXA_I	ldxa	[%r16, + 0x02c0] %asi, %r28
	brnz %r31,thr3_loop_cnt_850
	dec %r31
	.word 0xaf3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r23
        mov 0x89, %r31
thr3_loop_cnt_851:
	.word 0xe2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r17
	.word 0xd0dc23a8  ! 1: LDXA_I	ldxa	[%r16, + 0x03a8] %asi, %r8
	.word 0xf85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r28
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xea8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r21
	.word 0xc65c29b8  ! 1: LDX_I	ldx	[%r16 + 0x09b8], %r3
	.word 0xd4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r10
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_851
	dec %r31
	.word 0xa8342bd5  ! 1: SUBC_I	orn 	%r16, 0x0bd5, %r20
	.word 0x86442b9d  ! 1: ADDC_I	addc 	%r16, 0x0b9d, %r3
	.word 0x86442210  ! 1: ADDC_I	addc 	%r16, 0x0210, %r3
        mov 0xa5, %r31
thr3_loop_cnt_852:
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	.word 0xf8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r28
	.word 0xf0142bca  ! 1: LDUH_I	lduh	[%r16 + 0x0bca], %r24
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	.word 0xd2dc2680  ! 1: LDXA_I	ldxa	[%r16, + 0x0680] %asi, %r9
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6c42340  ! 1: LDSWA_I	ldswa	[%r16, + 0x0340] %asi, %r3
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xc6c42074  ! 1: LDSWA_I	ldswa	[%r16, + 0x0074] %asi, %r3
	.word 0xcc142e06  ! 1: LDUH_I	lduh	[%r16 + 0x0e06], %r6
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc65c2948  ! 1: LDX_I	ldx	[%r16 + 0x0948], %r3
	brnz %r31,thr3_loop_cnt_852
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x98342d4b  ! 1: SUBC_I	orn 	%r16, 0x0d4b, %r12
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x4b, %r31
thr3_loop_cnt_853:
	.word 0xc64c20e0  ! 1: LDSB_I	ldsb	[%r16 + 0x00e0], %r3
	.word 0xe4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r18
	.word 0xc6942210  ! 1: LDUHA_I	lduha	[%r16, + 0x0210] %asi, %r3
	.word 0xf8842c64  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c64] %asi, %r28
	.word 0xe6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r19
	.word 0xe85c2bc8  ! 1: LDX_I	ldx	[%r16 + 0x0bc8], %r20
	.word 0xe8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r20
	.word 0xcc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r6
	.word 0xc6542c32  ! 1: LDSH_I	ldsh	[%r16 + 0x0c32], %r3
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	brnz %r31,thr3_loop_cnt_853
	dec %r31
	.word 0x9e0c273f  ! 1: AND_I	and 	%r16, 0x073f, %r15
	.word 0x940c0002  ! 1: AND_R	and 	%r16, %r2, %r10
        mov 0x9b, %r31
thr3_loop_cnt_854:
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xf85c2180  ! 1: LDX_I	ldx	[%r16 + 0x0180], %r28
	.word 0xc6142f9a  ! 1: LDUH_I	lduh	[%r16 + 0x0f9a], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r17
	.word 0xd2c42f5c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f5c] %asi, %r9
	.word 0xd8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r12
	.word 0xce440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r7
	brnz %r31,thr3_loop_cnt_854
	dec %r31
	.word 0xbb3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r29
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0xbd, %r31
thr3_loop_cnt_855:
	.word 0xd6042f40  ! 1: LDUW_I	lduw	[%r16 + 0x0f40], %r11
	.word 0xc64c2926  ! 1: LDSB_I	ldsb	[%r16 + 0x0926], %r3
	.word 0xc6c4277c  ! 1: LDSWA_I	ldswa	[%r16, + 0x077c] %asi, %r3
	.word 0xd0142cc6  ! 1: LDUH_I	lduh	[%r16 + 0x0cc6], %r8
	.word 0xde4c2dd2  ! 1: LDSB_I	ldsb	[%r16 + 0x0dd2], %r15
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd4cc2f12  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f12] %asi, %r10
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_855
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x9a342bf3  ! 1: ORN_I	orn 	%r16, 0x0bf3, %r13
	.word 0x972c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r11
        mov 0x2d, %r31
thr3_loop_cnt_856:
	.word 0xde442530  ! 1: LDSW_I	ldsw	[%r16 + 0x0530], %r15
	.word 0xdc042794  ! 1: LDUW_I	lduw	[%r16 + 0x0794], %r14
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc64c290d  ! 1: LDSB_I	ldsb	[%r16 + 0x090d], %r3
	.word 0xc6dc24a8  ! 1: LDXA_I	ldxa	[%r16, + 0x04a8] %asi, %r3
	.word 0xe214297e  ! 1: LDUH_I	lduh	[%r16 + 0x097e], %r17
	.word 0xf294275e  ! 1: LDUHA_I	lduha	[%r16, + 0x075e] %asi, %r25
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6d42a8e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a8e] %asi, %r3
	.word 0xc6dc28a0  ! 1: LDXA_I	ldxa	[%r16, + 0x08a0] %asi, %r3
	brnz %r31,thr3_loop_cnt_856
	dec %r31
        mov 0x81, %r31
thr3_loop_cnt_857:
	.word 0xce842c14  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c14] %asi, %r7
	.word 0xc65c2920  ! 1: LDX_I	ldx	[%r16 + 0x0920], %r3
	.word 0xf4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r26
	.word 0xc684227c  ! 1: LDUWA_I	lduwa	[%r16, + 0x027c] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xee841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r23
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc68428b4  ! 1: LDUWA_I	lduwa	[%r16, + 0x08b4] %asi, %r3
	.word 0xec84246c  ! 1: LDUWA_I	lduwa	[%r16, + 0x046c] %asi, %r22
	.word 0xce5c23f8  ! 1: LDX_I	ldx	[%r16 + 0x03f8], %r7
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_857
	dec %r31
	.word 0x8604203e  ! 1: ADD_I	add 	%r16, 0x003e, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x8d340002  ! 1: SRL_R	srl 	%r16, %r2, %r6
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x4, %r31
thr3_loop_cnt_858:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd414217a  ! 1: LDUH_I	lduh	[%r16 + 0x017a], %r10
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xce5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r7
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xe28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r17
	.word 0xdecc2a5f  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a5f] %asi, %r15
	brnz %r31,thr3_loop_cnt_858
	dec %r31
	.word 0xb52c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r26
	.word 0xa33c1002  ! 1: SRAX_R	srax	%r16, %r2, %r17
	.word 0x913c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r8
        mov 0x1, %r31
thr3_loop_cnt_859:
	.word 0xf68c200b  ! 1: LDUBA_I	lduba	[%r16, + 0x000b] %asi, %r27
	.word 0xc64c2080  ! 1: LDSB_I	ldsb	[%r16 + 0x0080], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xe2542be8  ! 1: LDSH_I	ldsh	[%r16 + 0x0be8], %r17
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xc6842a70  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a70] %asi, %r3
	.word 0xc65c2b78  ! 1: LDX_I	ldx	[%r16 + 0x0b78], %r3
	.word 0xee94233e  ! 1: LDUHA_I	lduha	[%r16, + 0x033e] %asi, %r23
	.word 0xccdc2140  ! 1: LDXA_I	ldxa	[%r16, + 0x0140] %asi, %r6
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r27
	.word 0xc6cc2811  ! 1: LDSBA_I	ldsba	[%r16, + 0x0811] %asi, %r3
	brnz %r31,thr3_loop_cnt_859
	dec %r31
	.word 0xb4140002  ! 1: OR_R	or 	%r16, %r2, %r26
	.word 0xba1c0002  ! 1: XOR_R	xor 	%r16, %r2, %r29
	.word 0x9e342740  ! 1: SUBC_I	orn 	%r16, 0x0740, %r15
	.word 0x9a040002  ! 1: ADD_R	add 	%r16, %r2, %r13
        mov 0x2f, %r31
thr3_loop_cnt_860:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe4142282  ! 1: LDUH_I	lduh	[%r16 + 0x0282], %r18
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xfc842680  ! 1: LDUWA_I	lduwa	[%r16, + 0x0680] %asi, %r30
	.word 0xc6c42480  ! 1: LDSWA_I	ldswa	[%r16, + 0x0480] %asi, %r3
	.word 0xfac423b0  ! 1: LDSWA_I	ldswa	[%r16, + 0x03b0] %asi, %r29
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_860
	dec %r31
	.word 0x86342108  ! 1: ORN_I	orn 	%r16, 0x0108, %r3
	.word 0xb6242e6d  ! 1: SUB_I	sub 	%r16, 0x0e6d, %r27
	.word 0x96040002  ! 1: ADD_R	add 	%r16, %r2, %r11
	.word 0x98340002  ! 1: SUBC_R	orn 	%r16, %r2, %r12
        mov 0xb6, %r31
thr3_loop_cnt_861:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xfa140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r29
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xdcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r14
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xda941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r13
	.word 0xc654284e  ! 1: LDSH_I	ldsh	[%r16 + 0x084e], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd00c2d23  ! 1: LDUB_I	ldub	[%r16 + 0x0d23], %r8
	.word 0xc6942ea4  ! 1: LDUHA_I	lduha	[%r16, + 0x0ea4] %asi, %r3
	brnz %r31,thr3_loop_cnt_861
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x86142286  ! 1: OR_I	or 	%r16, 0x0286, %r3
	.word 0xb7341002  ! 1: SRLX_R	srlx	%r16, %r2, %r27
	.word 0x860421ad  ! 1: ADD_I	add 	%r16, 0x01ad, %r3
        mov 0x11, %r31
thr3_loop_cnt_862:
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xd89426bc  ! 1: LDUHA_I	lduha	[%r16, + 0x06bc] %asi, %r12
	.word 0xc65c2578  ! 1: LDX_I	ldx	[%r16 + 0x0578], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xda5c2d30  ! 1: LDX_I	ldx	[%r16 + 0x0d30], %r13
	.word 0xc64c2f06  ! 1: LDSB_I	ldsb	[%r16 + 0x0f06], %r3
	.word 0xd6dc2e20  ! 1: LDXA_I	ldxa	[%r16, + 0x0e20] %asi, %r11
	.word 0xee140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r23
	brnz %r31,thr3_loop_cnt_862
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x972c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r11
        mov 0x2b, %r31
thr3_loop_cnt_863:
	.word 0xe8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r20
	.word 0xc65423e8  ! 1: LDSH_I	ldsh	[%r16 + 0x03e8], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c21cd  ! 1: LDSB_I	ldsb	[%r16 + 0x01cd], %r3
	.word 0xf6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r27
	.word 0xea0c21e4  ! 1: LDUB_I	ldub	[%r16 + 0x01e4], %r21
	.word 0xcc142cbc  ! 1: LDUH_I	lduh	[%r16 + 0x0cbc], %r6
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc68c2361  ! 1: LDUBA_I	lduba	[%r16, + 0x0361] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xec542766  ! 1: LDSH_I	ldsh	[%r16 + 0x0766], %r22
	brnz %r31,thr3_loop_cnt_863
	dec %r31
	.word 0x9d2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r14
	.word 0x9a142384  ! 1: OR_I	or 	%r16, 0x0384, %r13
        mov 0x9e, %r31
thr3_loop_cnt_864:
	.word 0xc61423f6  ! 1: LDUH_I	lduh	[%r16 + 0x03f6], %r3
	.word 0xea941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r21
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xc6442844  ! 1: LDSW_I	ldsw	[%r16 + 0x0844], %r3
	.word 0xc65c28e0  ! 1: LDX_I	ldx	[%r16 + 0x08e0], %r3
	.word 0xc6cc2ba6  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ba6] %asi, %r3
	.word 0xc604239c  ! 1: LDUW_I	lduw	[%r16 + 0x039c], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r20
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	brnz %r31,thr3_loop_cnt_864
	dec %r31
        mov 0x1c, %r31
thr3_loop_cnt_865:
	.word 0xc64c2d5f  ! 1: LDSB_I	ldsb	[%r16 + 0x0d5f], %r3
	.word 0xe6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r19
	.word 0xc6cc2e00  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e00] %asi, %r3
	.word 0xc68429c8  ! 1: LDUWA_I	lduwa	[%r16, + 0x09c8] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xce4c2005  ! 1: LDSB_I	ldsb	[%r16 + 0x0005], %r7
	.word 0xf2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r25
	.word 0xc65c2fd8  ! 1: LDX_I	ldx	[%r16 + 0x0fd8], %r3
	.word 0xdc8c2947  ! 1: LDUBA_I	lduba	[%r16, + 0x0947] %asi, %r14
	.word 0xf84c2f92  ! 1: LDSB_I	ldsb	[%r16 + 0x0f92], %r28
	.word 0xc6442c40  ! 1: LDSW_I	ldsw	[%r16 + 0x0c40], %r3
	brnz %r31,thr3_loop_cnt_865
	dec %r31
        mov 0x7, %r31
thr3_loop_cnt_866:
	.word 0xf25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r25
	.word 0xc68c242a  ! 1: LDUBA_I	lduba	[%r16, + 0x042a] %asi, %r3
	.word 0xce040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r7
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xec842ee8  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ee8] %asi, %r22
	.word 0xc64c2ab3  ! 1: LDSB_I	ldsb	[%r16 + 0x0ab3], %r3
	.word 0xc60425b0  ! 1: LDUW_I	lduw	[%r16 + 0x05b0], %r3
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xde5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r15
	.word 0xf80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r28
	.word 0xecc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r22
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_866
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x9e2c2ad9  ! 1: ANDN_I	andn 	%r16, 0x0ad9, %r15
	.word 0x92240002  ! 1: SUB_R	sub 	%r16, %r2, %r9
        mov 0x65, %r31
thr3_loop_cnt_867:
	.word 0xc6dc2518  ! 1: LDXA_I	ldxa	[%r16, + 0x0518] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc64c2327  ! 1: LDSB_I	ldsb	[%r16 + 0x0327], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xc60c289f  ! 1: LDUB_I	ldub	[%r16 + 0x089f], %r3
	.word 0xda042b20  ! 1: LDUW_I	lduw	[%r16 + 0x0b20], %r13
	.word 0xf2cc24a0  ! 1: LDSBA_I	ldsba	[%r16, + 0x04a0] %asi, %r25
	brnz %r31,thr3_loop_cnt_867
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x862428e1  ! 1: SUB_I	sub 	%r16, 0x08e1, %r3
	.word 0x86442466  ! 1: ADDC_I	addc 	%r16, 0x0466, %r3
	.word 0x86342389  ! 1: SUBC_I	orn 	%r16, 0x0389, %r3
        mov 0xc2, %r31
thr3_loop_cnt_868:
	.word 0xf40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r26
	.word 0xc6dc21a0  ! 1: LDXA_I	ldxa	[%r16, + 0x01a0] %asi, %r3
	.word 0xc65427cc  ! 1: LDSH_I	ldsh	[%r16 + 0x07cc], %r3
	.word 0xdcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r14
	.word 0xc6c42ed8  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ed8] %asi, %r3
	.word 0xc6442920  ! 1: LDSW_I	ldsw	[%r16 + 0x0920], %r3
	.word 0xdc04202c  ! 1: LDUW_I	lduw	[%r16 + 0x002c], %r14
	.word 0xfc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r30
	brnz %r31,thr3_loop_cnt_868
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0x3b, %r31
thr3_loop_cnt_869:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xf08c2a0e  ! 1: LDUBA_I	lduba	[%r16, + 0x0a0e] %asi, %r24
	.word 0xf0142b3e  ! 1: LDUH_I	lduh	[%r16 + 0x0b3e], %r24
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xf6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r27
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6942d24  ! 1: LDUHA_I	lduha	[%r16, + 0x0d24] %asi, %r3
	.word 0xe8442370  ! 1: LDSW_I	ldsw	[%r16 + 0x0370], %r20
	.word 0xd2842c0c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c0c] %asi, %r9
	brnz %r31,thr3_loop_cnt_869
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
        mov 0x90, %r31
thr3_loop_cnt_870:
	.word 0xc6c42610  ! 1: LDSWA_I	ldswa	[%r16, + 0x0610] %asi, %r3
	.word 0xf00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r24
	.word 0xd45c2c20  ! 1: LDX_I	ldx	[%r16 + 0x0c20], %r10
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xc6cc271f  ! 1: LDSBA_I	ldsba	[%r16, + 0x071f] %asi, %r3
	.word 0xe4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r18
	.word 0xc65c28d0  ! 1: LDX_I	ldx	[%r16 + 0x08d0], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc60c2e4a  ! 1: LDUB_I	ldub	[%r16 + 0x0e4a], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_870
	dec %r31
	.word 0x8c0c0002  ! 1: AND_R	and 	%r16, %r2, %r6
        mov 0x6d, %r31
thr3_loop_cnt_871:
	.word 0xc6cc22e8  ! 1: LDSBA_I	ldsba	[%r16, + 0x02e8] %asi, %r3
	.word 0xd8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r12
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r18
	.word 0xfa0c2667  ! 1: LDUB_I	ldub	[%r16 + 0x0667], %r29
	.word 0xf0cc2175  ! 1: LDSBA_I	ldsba	[%r16, + 0x0175] %asi, %r24
	.word 0xf8042728  ! 1: LDUW_I	lduw	[%r16 + 0x0728], %r28
	.word 0xf894291e  ! 1: LDUHA_I	lduha	[%r16, + 0x091e] %asi, %r28
	.word 0xf6d42a92  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a92] %asi, %r27
	brnz %r31,thr3_loop_cnt_871
	dec %r31
	.word 0x942c2801  ! 1: ANDN_I	andn 	%r16, 0x0801, %r10
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x6a, %r31
thr3_loop_cnt_872:
	.word 0xd294202e  ! 1: LDUHA_I	lduha	[%r16, + 0x002e] %asi, %r9
	.word 0xe60c2c8f  ! 1: LDUB_I	ldub	[%r16 + 0x0c8f], %r19
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xc60c20fa  ! 1: LDUB_I	ldub	[%r16 + 0x00fa], %r3
	.word 0xdadc2908  ! 1: LDXA_I	ldxa	[%r16, + 0x0908] %asi, %r13
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	.word 0xf4142eea  ! 1: LDUH_I	lduh	[%r16 + 0x0eea], %r26
	.word 0xf45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r26
	brnz %r31,thr3_loop_cnt_872
	dec %r31
	.word 0xb4442c2c  ! 1: ADDC_I	addc 	%r16, 0x0c2c, %r26
	.word 0x8f2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r7
	.word 0xbd342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r30
        mov 0xc7, %r31
thr3_loop_cnt_873:
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xd2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r9
	.word 0xc61422f0  ! 1: LDUH_I	lduh	[%r16 + 0x02f0], %r3
	.word 0xe65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r19
	.word 0xf8d42fdc  ! 1: LDSHA_I	ldsha	[%r16, + 0x0fdc] %asi, %r28
	.word 0xcc5c2268  ! 1: LDX_I	ldx	[%r16 + 0x0268], %r6
	.word 0xd65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r11
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6dc23a0  ! 1: LDXA_I	ldxa	[%r16, + 0x03a0] %asi, %r3
	.word 0xe6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r19
	brnz %r31,thr3_loop_cnt_873
	dec %r31
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
        mov 0xc7, %r31
thr3_loop_cnt_874:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc604220c  ! 1: LDUW_I	lduw	[%r16 + 0x020c], %r3
	.word 0xc65c2f80  ! 1: LDX_I	ldx	[%r16 + 0x0f80], %r3
	.word 0xce4c22d6  ! 1: LDSB_I	ldsb	[%r16 + 0x02d6], %r7
	.word 0xe6942104  ! 1: LDUHA_I	lduha	[%r16, + 0x0104] %asi, %r19
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r20
	.word 0xf8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r28
	brnz %r31,thr3_loop_cnt_874
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x9e342bf6  ! 1: ORN_I	orn 	%r16, 0x0bf6, %r15
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x30, %r31
thr3_loop_cnt_875:
	.word 0xfa54238a  ! 1: LDSH_I	ldsh	[%r16 + 0x038a], %r29
	.word 0xdcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r14
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r26
	.word 0xf28424d8  ! 1: LDUWA_I	lduwa	[%r16, + 0x04d8] %asi, %r25
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xd2dc27d0  ! 1: LDXA_I	ldxa	[%r16, + 0x07d0] %asi, %r9
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r8
	.word 0xc65c2700  ! 1: LDX_I	ldx	[%r16 + 0x0700], %r3
	brnz %r31,thr3_loop_cnt_875
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0xa21c2f10  ! 1: XOR_I	xor 	%r16, 0x0f10, %r17
	.word 0x90340002  ! 1: ORN_R	orn 	%r16, %r2, %r8
        mov 0x33, %r31
thr3_loop_cnt_876:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe24c2c9e  ! 1: LDSB_I	ldsb	[%r16 + 0x0c9e], %r17
	.word 0xf8042fe0  ! 1: LDUW_I	lduw	[%r16 + 0x0fe0], %r28
	.word 0xd08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r8
	.word 0xc6042998  ! 1: LDUW_I	lduw	[%r16 + 0x0998], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	.word 0xce0c28ac  ! 1: LDUB_I	ldub	[%r16 + 0x08ac], %r7
	brnz %r31,thr3_loop_cnt_876
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x86142316  ! 1: OR_I	or 	%r16, 0x0316, %r3
	.word 0xb33c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r25
	.word 0xa5340002  ! 1: SRL_R	srl 	%r16, %r2, %r18
        mov 0x51, %r31
thr3_loop_cnt_877:
	.word 0xc6cc2494  ! 1: LDSBA_I	ldsba	[%r16, + 0x0494] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6042688  ! 1: LDUW_I	lduw	[%r16 + 0x0688], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd20c24a6  ! 1: LDUB_I	ldub	[%r16 + 0x04a6], %r9
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc68c2816  ! 1: LDUBA_I	lduba	[%r16, + 0x0816] %asi, %r3
	.word 0xc684210c  ! 1: LDUWA_I	lduwa	[%r16, + 0x010c] %asi, %r3
	.word 0xc60c2311  ! 1: LDUB_I	ldub	[%r16 + 0x0311], %r3
	brnz %r31,thr3_loop_cnt_877
	dec %r31
	.word 0x86042c0d  ! 1: ADD_I	add 	%r16, 0x0c0d, %r3
	.word 0xa61c0002  ! 1: XOR_R	xor 	%r16, %r2, %r19
	.word 0xa8442edc  ! 1: ADDC_I	addc 	%r16, 0x0edc, %r20
	.word 0xa8040002  ! 1: ADD_R	add 	%r16, %r2, %r20
        mov 0xaa, %r31
thr3_loop_cnt_878:
	.word 0xf68c26ae  ! 1: LDUBA_I	lduba	[%r16, + 0x06ae] %asi, %r27
	.word 0xf2c422d0  ! 1: LDSWA_I	ldswa	[%r16, + 0x02d0] %asi, %r25
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	.word 0xc6cc254f  ! 1: LDSBA_I	ldsba	[%r16, + 0x054f] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc644271c  ! 1: LDSW_I	ldsw	[%r16 + 0x071c], %r3
	.word 0xee140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r23
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd0d420b6  ! 1: LDSHA_I	ldsha	[%r16, + 0x00b6] %asi, %r8
	.word 0xc6c427ec  ! 1: LDSWA_I	ldswa	[%r16, + 0x07ec] %asi, %r3
	.word 0xc65c28e8  ! 1: LDX_I	ldx	[%r16 + 0x08e8], %r3
	.word 0xc6dc2970  ! 1: LDXA_I	ldxa	[%r16, + 0x0970] %asi, %r3
	brnz %r31,thr3_loop_cnt_878
	dec %r31
        mov 0x14, %r31
thr3_loop_cnt_879:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6cc2240  ! 1: LDSBA_I	ldsba	[%r16, + 0x0240] %asi, %r3
	.word 0xe4042cc8  ! 1: LDUW_I	lduw	[%r16 + 0x0cc8], %r18
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	.word 0xde140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r15
	.word 0xd2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r9
	.word 0xc6cc2059  ! 1: LDSBA_I	ldsba	[%r16, + 0x0059] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc60c2611  ! 1: LDUB_I	ldub	[%r16 + 0x0611], %r3
	.word 0xc6142e56  ! 1: LDUH_I	lduh	[%r16 + 0x0e56], %r3
	.word 0xde040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r15
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_879
	dec %r31
	.word 0x9a440002  ! 1: ADDC_R	addc 	%r16, %r2, %r13
        mov 0xaf, %r31
thr3_loop_cnt_880:
	.word 0xcc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r6
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd64c2c5c  ! 1: LDSB_I	ldsb	[%r16 + 0x0c5c], %r11
	.word 0xc6d427ea  ! 1: LDSHA_I	ldsha	[%r16, + 0x07ea] %asi, %r3
	.word 0xf454224a  ! 1: LDSH_I	ldsh	[%r16 + 0x024a], %r26
	.word 0xc68c2e28  ! 1: LDUBA_I	lduba	[%r16, + 0x0e28] %asi, %r3
	.word 0xde040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r15
	.word 0xc64c2ef5  ! 1: LDSB_I	ldsb	[%r16 + 0x0ef5], %r3
	.word 0xd8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r12
	brnz %r31,thr3_loop_cnt_880
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x962427ce  ! 1: SUB_I	sub 	%r16, 0x07ce, %r11
	.word 0x86342754  ! 1: ORN_I	orn 	%r16, 0x0754, %r3
	.word 0x860c2f6c  ! 1: AND_I	and 	%r16, 0x0f6c, %r3
        mov 0xb4, %r31
thr3_loop_cnt_881:
	.word 0xfa0c283e  ! 1: LDUB_I	ldub	[%r16 + 0x083e], %r29
	.word 0xec440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r22
	.word 0xc6442cd4  ! 1: LDSW_I	ldsw	[%r16 + 0x0cd4], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xcc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r6
	.word 0xc6842ff0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ff0] %asi, %r3
	.word 0xf04427a4  ! 1: LDSW_I	ldsw	[%r16 + 0x07a4], %r24
	.word 0xc6cc2e56  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e56] %asi, %r3
	.word 0xfa8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r29
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_881
	dec %r31
	.word 0x8d3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r6
	.word 0xba442f53  ! 1: ADDC_I	addc 	%r16, 0x0f53, %r29
	.word 0x9e242f2a  ! 1: SUB_I	sub 	%r16, 0x0f2a, %r15
        mov 0x3a, %r31
thr3_loop_cnt_882:
	.word 0xf8dc2a10  ! 1: LDXA_I	ldxa	[%r16, + 0x0a10] %asi, %r28
	.word 0xc694271c  ! 1: LDUHA_I	lduha	[%r16, + 0x071c] %asi, %r3
	.word 0xdcd42654  ! 1: LDSHA_I	ldsha	[%r16, + 0x0654] %asi, %r14
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r8
	.word 0xc65423c0  ! 1: LDSH_I	ldsh	[%r16 + 0x03c0], %r3
	brnz %r31,thr3_loop_cnt_882
	dec %r31
	.word 0xbc340002  ! 1: ORN_R	orn 	%r16, %r2, %r30
	.word 0x98340002  ! 1: SUBC_R	orn 	%r16, %r2, %r12
	.word 0xbc142465  ! 1: OR_I	or 	%r16, 0x0465, %r30
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0xa, %r31
thr3_loop_cnt_883:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xcc4c2c69  ! 1: LDSB_I	ldsb	[%r16 + 0x0c69], %r6
	.word 0xf8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r28
	.word 0xc6cc281e  ! 1: LDSBA_I	ldsba	[%r16, + 0x081e] %asi, %r3
	.word 0xd08c270b  ! 1: LDUBA_I	lduba	[%r16, + 0x070b] %asi, %r8
	.word 0xde941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r15
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xce5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r7
	.word 0xce440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r7
	.word 0xe6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r19
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	brnz %r31,thr3_loop_cnt_883
	dec %r31
	.word 0x8d3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r6
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x863c2054  ! 1: XNOR_I	xnor 	%r16, 0x0054, %r3
        mov 0x4d, %r31
thr3_loop_cnt_884:
	.word 0xc65c2678  ! 1: LDX_I	ldx	[%r16 + 0x0678], %r3
	.word 0xe2842a38  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a38] %asi, %r17
	.word 0xee941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r23
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd6542590  ! 1: LDSH_I	ldsh	[%r16 + 0x0590], %r11
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	.word 0xf804254c  ! 1: LDUW_I	lduw	[%r16 + 0x054c], %r28
	.word 0xc6cc248f  ! 1: LDSBA_I	ldsba	[%r16, + 0x048f] %asi, %r3
	.word 0xfc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r30
	brnz %r31,thr3_loop_cnt_884
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x862c23dc  ! 1: ANDN_I	andn 	%r16, 0x03dc, %r3
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0x54, %r31
thr3_loop_cnt_885:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc68c2ebb  ! 1: LDUBA_I	lduba	[%r16, + 0x0ebb] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe4c42ab8  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ab8] %asi, %r18
	.word 0xfcc42de8  ! 1: LDSWA_I	ldswa	[%r16, + 0x0de8] %asi, %r30
	.word 0xc65c2920  ! 1: LDX_I	ldx	[%r16 + 0x0920], %r3
	brnz %r31,thr3_loop_cnt_885
	dec %r31
        mov 0x82, %r31
thr3_loop_cnt_886:
	.word 0xc6d423ba  ! 1: LDSHA_I	ldsha	[%r16, + 0x03ba] %asi, %r3
	.word 0xfad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r29
	.word 0xd28c20ba  ! 1: LDUBA_I	lduba	[%r16, + 0x00ba] %asi, %r9
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	.word 0xd24c242c  ! 1: LDSB_I	ldsb	[%r16 + 0x042c], %r9
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe24c2227  ! 1: LDSB_I	ldsb	[%r16 + 0x0227], %r17
	.word 0xd00424bc  ! 1: LDUW_I	lduw	[%r16 + 0x04bc], %r8
	.word 0xea1428d6  ! 1: LDUH_I	lduh	[%r16 + 0x08d6], %r21
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_886
	dec %r31
	.word 0x86342c5a  ! 1: ORN_I	orn 	%r16, 0x0c5a, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x59, %r31
thr3_loop_cnt_887:
	.word 0xc60c2ffb  ! 1: LDUB_I	ldub	[%r16 + 0x0ffb], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2f50  ! 1: LDXA_I	ldxa	[%r16, + 0x0f50] %asi, %r3
	.word 0xdc5c26d8  ! 1: LDX_I	ldx	[%r16 + 0x06d8], %r14
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xfc042530  ! 1: LDUW_I	lduw	[%r16 + 0x0530], %r30
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xc684272c  ! 1: LDUWA_I	lduwa	[%r16, + 0x072c] %asi, %r3
	.word 0xc60424bc  ! 1: LDUW_I	lduw	[%r16 + 0x04bc], %r3
	.word 0xce842d98  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d98] %asi, %r7
	brnz %r31,thr3_loop_cnt_887
	dec %r31
        mov 0x45, %r31
thr3_loop_cnt_888:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd814295e  ! 1: LDUH_I	lduh	[%r16 + 0x095e], %r12
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf0942814  ! 1: LDUHA_I	lduha	[%r16, + 0x0814] %asi, %r24
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_888
	dec %r31
        mov 0x88, %r31
thr3_loop_cnt_889:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xfa540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r29
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xcc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r6
	.word 0xc60c2363  ! 1: LDUB_I	ldub	[%r16 + 0x0363], %r3
	.word 0xd2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r9
	.word 0xcc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r6
	brnz %r31,thr3_loop_cnt_889
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0xa6340002  ! 1: ORN_R	orn 	%r16, %r2, %r19
        mov 0x6e, %r31
thr3_loop_cnt_890:
	.word 0xdac42608  ! 1: LDSWA_I	ldswa	[%r16, + 0x0608] %asi, %r13
	.word 0xc64c227e  ! 1: LDSB_I	ldsb	[%r16 + 0x027e], %r3
	.word 0xc6142d32  ! 1: LDUH_I	lduh	[%r16 + 0x0d32], %r3
	.word 0xc6142784  ! 1: LDUH_I	lduh	[%r16 + 0x0784], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2664  ! 1: LDSBA_I	ldsba	[%r16, + 0x0664] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_890
	dec %r31
	.word 0xa21c0002  ! 1: XOR_R	xor 	%r16, %r2, %r17
	.word 0xb3341002  ! 1: SRLX_R	srlx	%r16, %r2, %r25
        mov 0x7f, %r31
thr3_loop_cnt_891:
	.word 0xd4cc260f  ! 1: LDSBA_I	ldsba	[%r16, + 0x060f] %asi, %r10
	.word 0xfcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r30
	.word 0xdc4c2e2d  ! 1: LDSB_I	ldsb	[%r16 + 0x0e2d], %r14
	.word 0xc64c22cc  ! 1: LDSB_I	ldsb	[%r16 + 0x02cc], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c420c4  ! 1: LDSWA_I	ldswa	[%r16, + 0x00c4] %asi, %r3
	.word 0xcc0c2d19  ! 1: LDUB_I	ldub	[%r16 + 0x0d19], %r6
	.word 0xce842098  ! 1: LDUWA_I	lduwa	[%r16, + 0x0098] %asi, %r7
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf2542dc6  ! 1: LDSH_I	ldsh	[%r16 + 0x0dc6], %r25
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	brnz %r31,thr3_loop_cnt_891
	dec %r31
        mov 0x89, %r31
thr3_loop_cnt_892:
	.word 0xc6842178  ! 1: LDUWA_I	lduwa	[%r16, + 0x0178] %asi, %r3
	.word 0xc6142e54  ! 1: LDUH_I	lduh	[%r16 + 0x0e54], %r3
	.word 0xf4942c02  ! 1: LDUHA_I	lduha	[%r16, + 0x0c02] %asi, %r26
	.word 0xf80c26cd  ! 1: LDUB_I	ldub	[%r16 + 0x06cd], %r28
	.word 0xfa542ef2  ! 1: LDSH_I	ldsh	[%r16 + 0x0ef2], %r29
	.word 0xeedc2970  ! 1: LDXA_I	ldxa	[%r16, + 0x0970] %asi, %r23
	.word 0xf08422a8  ! 1: LDUWA_I	lduwa	[%r16, + 0x02a8] %asi, %r24
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r9
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6942e5e  ! 1: LDUHA_I	lduha	[%r16, + 0x0e5e] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_892
	dec %r31
	.word 0x8d340002  ! 1: SRL_R	srl 	%r16, %r2, %r6
	.word 0x91341002  ! 1: SRLX_R	srlx	%r16, %r2, %r8
	.word 0x86342c0b  ! 1: ORN_I	orn 	%r16, 0x0c0b, %r3
        mov 0xb9, %r31
thr3_loop_cnt_893:
	.word 0xe64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r19
	.word 0xda542f96  ! 1: LDSH_I	ldsh	[%r16 + 0x0f96], %r13
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d4222a  ! 1: LDSHA_I	ldsha	[%r16, + 0x022a] %asi, %r3
	.word 0xe65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r19
	.word 0xd6cc2b36  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b36] %asi, %r11
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2a81  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a81] %asi, %r3
	brnz %r31,thr3_loop_cnt_893
	dec %r31
	.word 0x862428ff  ! 1: SUB_I	sub 	%r16, 0x08ff, %r3
	.word 0x860c24c3  ! 1: AND_I	and 	%r16, 0x04c3, %r3
	.word 0x860c2b56  ! 1: AND_I	and 	%r16, 0x0b56, %r3
        mov 0x4, %r31
thr3_loop_cnt_894:
	.word 0xf48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r26
	.word 0xea4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r21
	.word 0xc6842150  ! 1: LDUWA_I	lduwa	[%r16, + 0x0150] %asi, %r3
	.word 0xc6542490  ! 1: LDSH_I	ldsh	[%r16 + 0x0490], %r3
	.word 0xf6442acc  ! 1: LDSW_I	ldsw	[%r16 + 0x0acc], %r27
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r27
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe85c28c0  ! 1: LDX_I	ldx	[%r16 + 0x08c0], %r20
	brnz %r31,thr3_loop_cnt_894
	dec %r31
	.word 0x864420d3  ! 1: ADDC_I	addc 	%r16, 0x00d3, %r3
	.word 0x9d2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r14
        mov 0x25, %r31
thr3_loop_cnt_895:
	.word 0xc64c2c17  ! 1: LDSB_I	ldsb	[%r16 + 0x0c17], %r3
	.word 0xe68c2be4  ! 1: LDUBA_I	lduba	[%r16, + 0x0be4] %asi, %r19
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xfa941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r29
	.word 0xcc042064  ! 1: LDUW_I	lduw	[%r16 + 0x0064], %r6
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xc60c2d22  ! 1: LDUB_I	ldub	[%r16 + 0x0d22], %r3
	.word 0xc6cc2e7a  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e7a] %asi, %r3
	.word 0xc604212c  ! 1: LDUW_I	lduw	[%r16 + 0x012c], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_895
	dec %r31
	.word 0x9e14261a  ! 1: OR_I	or 	%r16, 0x061a, %r15
        mov 0xb5, %r31
thr3_loop_cnt_896:
	.word 0xd04c2f5f  ! 1: LDSB_I	ldsb	[%r16 + 0x0f5f], %r8
	.word 0xc6c42350  ! 1: LDSWA_I	ldswa	[%r16, + 0x0350] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2800  ! 1: LDXA_I	ldxa	[%r16, + 0x0800] %asi, %r3
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xe2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r17
	.word 0xf2042e20  ! 1: LDUW_I	lduw	[%r16 + 0x0e20], %r25
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe4dc2050  ! 1: LDXA_I	ldxa	[%r16, + 0x0050] %asi, %r18
	.word 0xde0c2780  ! 1: LDUB_I	ldub	[%r16 + 0x0780], %r15
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_896
	dec %r31
        mov 0xab, %r31
thr3_loop_cnt_897:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf85c2de8  ! 1: LDX_I	ldx	[%r16 + 0x0de8], %r28
	.word 0xccdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r6
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xc6dc2708  ! 1: LDXA_I	ldxa	[%r16, + 0x0708] %asi, %r3
	.word 0xcc142c9e  ! 1: LDUH_I	lduh	[%r16 + 0x0c9e], %r6
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_897
	dec %r31
	.word 0x860c2725  ! 1: AND_I	and 	%r16, 0x0725, %r3
        mov 0x92, %r31
thr3_loop_cnt_898:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6842688  ! 1: LDUWA_I	lduwa	[%r16, + 0x0688] %asi, %r3
	.word 0xe2842c54  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c54] %asi, %r17
	.word 0xd0042590  ! 1: LDUW_I	lduw	[%r16 + 0x0590], %r8
	.word 0xc6cc269b  ! 1: LDSBA_I	ldsba	[%r16, + 0x069b] %asi, %r3
	.word 0xd48c213c  ! 1: LDUBA_I	lduba	[%r16, + 0x013c] %asi, %r10
	.word 0xc6042b10  ! 1: LDUW_I	lduw	[%r16 + 0x0b10], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6dc2b48  ! 1: LDXA_I	ldxa	[%r16, + 0x0b48] %asi, %r3
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	brnz %r31,thr3_loop_cnt_898
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0x47, %r31
thr3_loop_cnt_899:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r26
	.word 0xc6942cc2  ! 1: LDUHA_I	lduha	[%r16, + 0x0cc2] %asi, %r3
	.word 0xc6cc2d1c  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d1c] %asi, %r3
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xfc942250  ! 1: LDUHA_I	lduha	[%r16, + 0x0250] %asi, %r30
	.word 0xc6542068  ! 1: LDSH_I	ldsh	[%r16 + 0x0068], %r3
	.word 0xce5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r7
	.word 0xc6842724  ! 1: LDUWA_I	lduwa	[%r16, + 0x0724] %asi, %r3
	.word 0xf04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r24
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_899
	dec %r31
	.word 0x9f341002  ! 1: SRLX_R	srlx	%r16, %r2, %r15
	.word 0x861c2911  ! 1: XOR_I	xor 	%r16, 0x0911, %r3
        mov 0x86, %r31
thr3_loop_cnt_900:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xec8c2a7b  ! 1: LDUBA_I	lduba	[%r16, + 0x0a7b] %asi, %r22
	.word 0xeadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r21
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe2042304  ! 1: LDUW_I	lduw	[%r16 + 0x0304], %r17
	.word 0xe81429d8  ! 1: LDUH_I	lduh	[%r16 + 0x09d8], %r20
	.word 0xcc0427a8  ! 1: LDUW_I	lduw	[%r16 + 0x07a8], %r6
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc69422f8  ! 1: LDUHA_I	lduha	[%r16, + 0x02f8] %asi, %r3
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xd4442e04  ! 1: LDSW_I	ldsw	[%r16 + 0x0e04], %r10
	.word 0xf60c280e  ! 1: LDUB_I	ldub	[%r16 + 0x080e], %r27
	brnz %r31,thr3_loop_cnt_900
	dec %r31
	.word 0xa53c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r18
	.word 0x90340002  ! 1: ORN_R	orn 	%r16, %r2, %r8
        mov 0x61, %r31
thr3_loop_cnt_901:
	.word 0xd4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r10
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xced429ca  ! 1: LDSHA_I	ldsha	[%r16, + 0x09ca] %asi, %r7
	.word 0xd2042d54  ! 1: LDUW_I	lduw	[%r16 + 0x0d54], %r9
	.word 0xe84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r20
	.word 0xd2c4271c  ! 1: LDSWA_I	ldswa	[%r16, + 0x071c] %asi, %r9
	.word 0xf2d42542  ! 1: LDSHA_I	ldsha	[%r16, + 0x0542] %asi, %r25
	.word 0xd2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r9
	.word 0xc64c26f7  ! 1: LDSB_I	ldsb	[%r16 + 0x06f7], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf8cc2b34  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b34] %asi, %r28
	.word 0xde942480  ! 1: LDUHA_I	lduha	[%r16, + 0x0480] %asi, %r15
	brnz %r31,thr3_loop_cnt_901
	dec %r31
	.word 0xb12c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r24
	.word 0x93342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r9
	.word 0x86442d7f  ! 1: ADDC_I	addc 	%r16, 0x0d7f, %r3
        mov 0xa0, %r31
thr3_loop_cnt_902:
	.word 0xc65c2a60  ! 1: LDX_I	ldx	[%r16 + 0x0a60], %r3
	.word 0xc614216a  ! 1: LDUH_I	lduh	[%r16 + 0x016a], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6042650  ! 1: LDUW_I	lduw	[%r16 + 0x0650], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc60c212b  ! 1: LDUB_I	ldub	[%r16 + 0x012b], %r3
	.word 0xc6542bea  ! 1: LDSH_I	ldsh	[%r16 + 0x0bea], %r3
	.word 0xe8dc2d78  ! 1: LDXA_I	ldxa	[%r16, + 0x0d78] %asi, %r20
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xd4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r10
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_902
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0xba, %r31
thr3_loop_cnt_903:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r17
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xcecc2310  ! 1: LDSBA_I	ldsba	[%r16, + 0x0310] %asi, %r7
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xcc8c2af0  ! 1: LDUBA_I	lduba	[%r16, + 0x0af0] %asi, %r6
	.word 0xf44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r26
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	brnz %r31,thr3_loop_cnt_903
	dec %r31
	.word 0x86342dcb  ! 1: ORN_I	orn 	%r16, 0x0dcb, %r3
	.word 0x9f340002  ! 1: SRL_R	srl 	%r16, %r2, %r15
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x9b2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r13
        mov 0x18, %r31
thr3_loop_cnt_904:
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xc6042690  ! 1: LDUW_I	lduw	[%r16 + 0x0690], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xcc4c2369  ! 1: LDSB_I	ldsb	[%r16 + 0x0369], %r6
	.word 0xe28421e8  ! 1: LDUWA_I	lduwa	[%r16, + 0x01e8] %asi, %r17
	.word 0xc6142e80  ! 1: LDUH_I	lduh	[%r16 + 0x0e80], %r3
	.word 0xc60c259c  ! 1: LDUB_I	ldub	[%r16 + 0x059c], %r3
	.word 0xc64c270c  ! 1: LDSB_I	ldsb	[%r16 + 0x070c], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_904
	dec %r31
	.word 0x862c22ab  ! 1: ANDN_I	andn 	%r16, 0x02ab, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x56, %r31
thr3_loop_cnt_905:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xda140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r13
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xce941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r7
	.word 0xc60c24f0  ! 1: LDUB_I	ldub	[%r16 + 0x04f0], %r3
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xeacc2cf9  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cf9] %asi, %r21
	brnz %r31,thr3_loop_cnt_905
	dec %r31
	.word 0xaf343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r23
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0xb42c240a  ! 1: ANDN_I	andn 	%r16, 0x040a, %r26
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x32, %r31
thr3_loop_cnt_906:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe2142a58  ! 1: LDUH_I	lduh	[%r16 + 0x0a58], %r17
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf6942dca  ! 1: LDUHA_I	lduha	[%r16, + 0x0dca] %asi, %r27
	.word 0xf4942e98  ! 1: LDUHA_I	lduha	[%r16, + 0x0e98] %asi, %r26
	.word 0xf2cc220d  ! 1: LDSBA_I	ldsba	[%r16, + 0x020d] %asi, %r25
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_906
	dec %r31
	.word 0x863c2875  ! 1: XNOR_I	xnor 	%r16, 0x0875, %r3
        mov 0x9e, %r31
thr3_loop_cnt_907:
	.word 0xd6442100  ! 1: LDSW_I	ldsw	[%r16 + 0x0100], %r11
	.word 0xd4142ae0  ! 1: LDUH_I	lduh	[%r16 + 0x0ae0], %r10
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe81428f8  ! 1: LDUH_I	lduh	[%r16 + 0x08f8], %r20
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6042074  ! 1: LDUW_I	lduw	[%r16 + 0x0074], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc684252c  ! 1: LDUWA_I	lduwa	[%r16, + 0x052c] %asi, %r3
	.word 0xcc442228  ! 1: LDSW_I	ldsw	[%r16 + 0x0228], %r6
	brnz %r31,thr3_loop_cnt_907
	dec %r31
	.word 0xa2440002  ! 1: ADDC_R	addc 	%r16, %r2, %r17
	.word 0xb4440002  ! 1: ADDC_R	addc 	%r16, %r2, %r26
	.word 0x9d2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r14
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0xa, %r31
thr3_loop_cnt_908:
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xf6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r27
	.word 0xe2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r17
	.word 0xe4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r18
	.word 0xdad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r13
	.word 0xecdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r22
	.word 0xfa8c21c0  ! 1: LDUBA_I	lduba	[%r16, + 0x01c0] %asi, %r29
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc261f  ! 1: LDSBA_I	ldsba	[%r16, + 0x061f] %asi, %r3
	.word 0xc65c21e0  ! 1: LDX_I	ldx	[%r16 + 0x01e0], %r3
	.word 0xc6c42ba8  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ba8] %asi, %r3
	.word 0xda4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r13
	brnz %r31,thr3_loop_cnt_908
	dec %r31
	.word 0xa8242304  ! 1: SUB_I	sub 	%r16, 0x0304, %r20
        mov 0x22, %r31
thr3_loop_cnt_909:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6142040  ! 1: LDUH_I	lduh	[%r16 + 0x0040], %r3
	.word 0xc6142166  ! 1: LDUH_I	lduh	[%r16 + 0x0166], %r3
	.word 0xd0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r8
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd2dc2208  ! 1: LDXA_I	ldxa	[%r16, + 0x0208] %asi, %r9
	.word 0xfa4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r29
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xf2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r25
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_909
	dec %r31
	.word 0x86342ce9  ! 1: SUBC_I	orn 	%r16, 0x0ce9, %r3
	.word 0x862c222c  ! 1: ANDN_I	andn 	%r16, 0x022c, %r3
        mov 0x9e, %r31
thr3_loop_cnt_910:
	.word 0xe4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r18
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xeedc29c0  ! 1: LDXA_I	ldxa	[%r16, + 0x09c0] %asi, %r23
	.word 0xd4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r10
	.word 0xde540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r15
	.word 0xd2042c84  ! 1: LDUW_I	lduw	[%r16 + 0x0c84], %r9
	.word 0xdecc2873  ! 1: LDSBA_I	ldsba	[%r16, + 0x0873] %asi, %r15
	.word 0xeed42cf0  ! 1: LDSHA_I	ldsha	[%r16, + 0x0cf0] %asi, %r23
	.word 0xce4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r7
	brnz %r31,thr3_loop_cnt_910
	dec %r31
	.word 0x993c1002  ! 1: SRAX_R	srax	%r16, %r2, %r12
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x4c, %r31
thr3_loop_cnt_911:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xfcd424b0  ! 1: LDSHA_I	ldsha	[%r16, + 0x04b0] %asi, %r30
	.word 0xea4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r21
	.word 0xc6dc2f50  ! 1: LDXA_I	ldxa	[%r16, + 0x0f50] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe2c426b4  ! 1: LDSWA_I	ldswa	[%r16, + 0x06b4] %asi, %r17
	.word 0xf04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r24
	.word 0xda8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r13
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r17
	.word 0xc65c2da0  ! 1: LDX_I	ldx	[%r16 + 0x0da0], %r3
	.word 0xe80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r20
	brnz %r31,thr3_loop_cnt_911
	dec %r31
	.word 0xb44425fb  ! 1: ADDC_I	addc 	%r16, 0x05fb, %r26
	.word 0x8f2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r7
	.word 0x860c2d4f  ! 1: AND_I	and 	%r16, 0x0d4f, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0xc2, %r31
thr3_loop_cnt_912:
	.word 0xc65c2518  ! 1: LDX_I	ldx	[%r16 + 0x0518], %r3
	.word 0xde040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r15
	.word 0xda442244  ! 1: LDSW_I	ldsw	[%r16 + 0x0244], %r13
	.word 0xf0442af8  ! 1: LDSW_I	ldsw	[%r16 + 0x0af8], %r24
	.word 0xc6c42600  ! 1: LDSWA_I	ldswa	[%r16, + 0x0600] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r18
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xccdc2e38  ! 1: LDXA_I	ldxa	[%r16, + 0x0e38] %asi, %r6
	.word 0xe2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r17
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe8142dc8  ! 1: LDUH_I	lduh	[%r16 + 0x0dc8], %r20
	brnz %r31,thr3_loop_cnt_912
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x9d3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r14
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0x49, %r31
thr3_loop_cnt_913:
	.word 0xdc842b8c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b8c] %asi, %r14
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe2cc2cfb  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cfb] %asi, %r17
	.word 0xc65420e6  ! 1: LDSH_I	ldsh	[%r16 + 0x00e6], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xc65c2010  ! 1: LDX_I	ldx	[%r16 + 0x0010], %r3
	.word 0xc6cc2000  ! 1: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r3
	.word 0xdccc20a0  ! 1: LDSBA_I	ldsba	[%r16, + 0x00a0] %asi, %r14
	.word 0xc60c2205  ! 1: LDUB_I	ldub	[%r16 + 0x0205], %r3
	.word 0xd2c42c10  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c10] %asi, %r9
	brnz %r31,thr3_loop_cnt_913
	dec %r31
	.word 0x8d2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r6
	.word 0x864429b9  ! 1: ADDC_I	addc 	%r16, 0x09b9, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x3f, %r31
thr3_loop_cnt_914:
	.word 0xc6c42674  ! 1: LDSWA_I	ldswa	[%r16, + 0x0674] %asi, %r3
	.word 0xf6142220  ! 1: LDUH_I	lduh	[%r16 + 0x0220], %r27
	.word 0xdccc29c3  ! 1: LDSBA_I	ldsba	[%r16, + 0x09c3] %asi, %r14
	.word 0xc604283c  ! 1: LDUW_I	lduw	[%r16 + 0x083c], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c42160  ! 1: LDSWA_I	ldswa	[%r16, + 0x0160] %asi, %r3
	.word 0xcc5c2d30  ! 1: LDX_I	ldx	[%r16 + 0x0d30], %r6
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_914
	dec %r31
        mov 0x0, %r31
thr3_loop_cnt_915:
	.word 0xdcdc2910  ! 1: LDXA_I	ldxa	[%r16, + 0x0910] %asi, %r14
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xfc94294e  ! 1: LDUHA_I	lduha	[%r16, + 0x094e] %asi, %r30
	.word 0xd6942958  ! 1: LDUHA_I	lduha	[%r16, + 0x0958] %asi, %r11
	.word 0xd4dc2078  ! 1: LDXA_I	ldxa	[%r16, + 0x0078] %asi, %r10
	.word 0xf2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r25
	.word 0xf0c42f5c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f5c] %asi, %r24
	.word 0xdcd423aa  ! 1: LDSHA_I	ldsha	[%r16, + 0x03aa] %asi, %r14
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xc6042224  ! 1: LDUW_I	lduw	[%r16 + 0x0224], %r3
	brnz %r31,thr3_loop_cnt_915
	dec %r31
        mov 0x77, %r31
thr3_loop_cnt_916:
	.word 0xc684217c  ! 1: LDUWA_I	lduwa	[%r16, + 0x017c] %asi, %r3
	.word 0xea8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r21
	.word 0xfcd4259c  ! 1: LDSHA_I	ldsha	[%r16, + 0x059c] %asi, %r30
	.word 0xc61421e6  ! 1: LDUH_I	lduh	[%r16 + 0x01e6], %r3
	.word 0xe45c2e30  ! 1: LDX_I	ldx	[%r16 + 0x0e30], %r18
	.word 0xf6542c5a  ! 1: LDSH_I	ldsh	[%r16 + 0x0c5a], %r27
	.word 0xc68424c0  ! 1: LDUWA_I	lduwa	[%r16, + 0x04c0] %asi, %r3
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xf014223e  ! 1: LDUH_I	lduh	[%r16 + 0x023e], %r24
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_916
	dec %r31
	.word 0x863c282f  ! 1: XNOR_I	xnor 	%r16, 0x082f, %r3
	.word 0xb8242fc8  ! 1: SUB_I	sub 	%r16, 0x0fc8, %r28
	.word 0x97342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r11
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x2f, %r31
thr3_loop_cnt_917:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	.word 0xc684220c  ! 1: LDUWA_I	lduwa	[%r16, + 0x020c] %asi, %r3
	.word 0xd2442278  ! 1: LDSW_I	ldsw	[%r16 + 0x0278], %r9
	.word 0xc64c204d  ! 1: LDSB_I	ldsb	[%r16 + 0x004d], %r3
	.word 0xc64c2a27  ! 1: LDSB_I	ldsb	[%r16 + 0x0a27], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf6c42260  ! 1: LDSWA_I	ldswa	[%r16, + 0x0260] %asi, %r27
	.word 0xc64c2f57  ! 1: LDSB_I	ldsb	[%r16 + 0x0f57], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_917
	dec %r31
	.word 0x9c340002  ! 1: SUBC_R	orn 	%r16, %r2, %r14
	.word 0x972c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r11
        mov 0x5e, %r31
thr3_loop_cnt_918:
	.word 0xd2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r9
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf0042dfc  ! 1: LDUW_I	lduw	[%r16 + 0x0dfc], %r24
	.word 0xe4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r18
	.word 0xd694241c  ! 1: LDUHA_I	lduha	[%r16, + 0x041c] %asi, %r11
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xec8c2e40  ! 1: LDUBA_I	lduba	[%r16, + 0x0e40] %asi, %r22
	.word 0xc68c2cdd  ! 1: LDUBA_I	lduba	[%r16, + 0x0cdd] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_918
	dec %r31
	.word 0xb2142e0d  ! 1: OR_I	or 	%r16, 0x0e0d, %r25
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x98140002  ! 1: OR_R	or 	%r16, %r2, %r12
        mov 0x5a, %r31
thr3_loop_cnt_919:
	.word 0xde5c2798  ! 1: LDX_I	ldx	[%r16 + 0x0798], %r15
	.word 0xc69424be  ! 1: LDUHA_I	lduha	[%r16, + 0x04be] %asi, %r3
	.word 0xfc942406  ! 1: LDUHA_I	lduha	[%r16, + 0x0406] %asi, %r30
	.word 0xc6042da4  ! 1: LDUW_I	lduw	[%r16 + 0x0da4], %r3
	.word 0xd0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r8
	.word 0xc60c2f0a  ! 1: LDUB_I	ldub	[%r16 + 0x0f0a], %r3
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc65c27f0  ! 1: LDX_I	ldx	[%r16 + 0x07f0], %r3
	.word 0xc6042a38  ! 1: LDUW_I	lduw	[%r16 + 0x0a38], %r3
	.word 0xe4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r18
	brnz %r31,thr3_loop_cnt_919
	dec %r31
	.word 0x9e442521  ! 1: ADDC_I	addc 	%r16, 0x0521, %r15
	.word 0x992c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r12
        mov 0xb7, %r31
thr3_loop_cnt_920:
	.word 0xe6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r19
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xeac426ec  ! 1: LDSWA_I	ldswa	[%r16, + 0x06ec] %asi, %r21
	.word 0xce4426e8  ! 1: LDSW_I	ldsw	[%r16 + 0x06e8], %r7
	.word 0xd654204a  ! 1: LDSH_I	ldsh	[%r16 + 0x004a], %r11
	.word 0xd45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r10
	.word 0xd614216c  ! 1: LDUH_I	lduh	[%r16 + 0x016c], %r11
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	brnz %r31,thr3_loop_cnt_920
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x92440002  ! 1: ADDC_R	addc 	%r16, %r2, %r9
	.word 0xa8340002  ! 1: SUBC_R	orn 	%r16, %r2, %r20
	.word 0xb7343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r27
        mov 0xad, %r31
thr3_loop_cnt_921:
	.word 0xc6dc2218  ! 1: LDXA_I	ldxa	[%r16, + 0x0218] %asi, %r3
	.word 0xeadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r21
	.word 0xe4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r18
	.word 0xc6042b60  ! 1: LDUW_I	lduw	[%r16 + 0x0b60], %r3
	.word 0xf4d42066  ! 1: LDSHA_I	ldsha	[%r16, + 0x0066] %asi, %r26
	.word 0xc61427b8  ! 1: LDUH_I	lduh	[%r16 + 0x07b8], %r3
	.word 0xc6c4273c  ! 1: LDSWA_I	ldswa	[%r16, + 0x073c] %asi, %r3
	.word 0xdac421e0  ! 1: LDSWA_I	ldswa	[%r16, + 0x01e0] %asi, %r13
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	brnz %r31,thr3_loop_cnt_921
	dec %r31
	.word 0x962c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r11
        mov 0xa1, %r31
thr3_loop_cnt_922:
	.word 0xd48c2876  ! 1: LDUBA_I	lduba	[%r16, + 0x0876] %asi, %r10
	.word 0xf65420e2  ! 1: LDSH_I	ldsh	[%r16 + 0x00e2], %r27
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6c42eb4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0eb4] %asi, %r3
	.word 0xf2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r25
	.word 0xc6942b8a  ! 1: LDUHA_I	lduha	[%r16, + 0x0b8a] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r12
	brnz %r31,thr3_loop_cnt_922
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0xbc3c26c9  ! 1: XNOR_I	xnor 	%r16, 0x06c9, %r30
        mov 0x30, %r31
thr3_loop_cnt_923:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xe6dc2480  ! 1: LDXA_I	ldxa	[%r16, + 0x0480] %asi, %r19
	.word 0xc6042694  ! 1: LDUW_I	lduw	[%r16 + 0x0694], %r3
	.word 0xc64c2952  ! 1: LDSB_I	ldsb	[%r16 + 0x0952], %r3
	.word 0xda442a08  ! 1: LDSW_I	ldsw	[%r16 + 0x0a08], %r13
	.word 0xd8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r12
	.word 0xc6dc27b8  ! 1: LDXA_I	ldxa	[%r16, + 0x07b8] %asi, %r3
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	brnz %r31,thr3_loop_cnt_923
	dec %r31
	.word 0x9e142093  ! 1: OR_I	or 	%r16, 0x0093, %r15
	.word 0x8644205c  ! 1: ADDC_I	addc 	%r16, 0x005c, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0x11, %r31
thr3_loop_cnt_924:
	.word 0xdcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r14
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc64c2108  ! 1: LDSB_I	ldsb	[%r16 + 0x0108], %r3
	.word 0xd8dc2b10  ! 1: LDXA_I	ldxa	[%r16, + 0x0b10] %asi, %r12
	.word 0xda5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r13
	.word 0xee540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r23
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_924
	dec %r31
        mov 0x99, %r31
thr3_loop_cnt_925:
	.word 0xecdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r22
	.word 0xda44220c  ! 1: LDSW_I	ldsw	[%r16 + 0x020c], %r13
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xfc0c2976  ! 1: LDUB_I	ldub	[%r16 + 0x0976], %r30
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_925
	dec %r31
	.word 0x86042ccc  ! 1: ADD_I	add 	%r16, 0x0ccc, %r3
	.word 0xa6442082  ! 1: ADDC_I	addc 	%r16, 0x0082, %r19
        mov 0x8b, %r31
thr3_loop_cnt_926:
	.word 0xec8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r22
	.word 0xeedc2538  ! 1: LDXA_I	ldxa	[%r16, + 0x0538] %asi, %r23
	.word 0xc65c2ff8  ! 1: LDX_I	ldx	[%r16 + 0x0ff8], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xccc42534  ! 1: LDSWA_I	ldswa	[%r16, + 0x0534] %asi, %r6
	.word 0xe20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r17
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xecd42046  ! 1: LDSHA_I	ldsha	[%r16, + 0x0046] %asi, %r22
	.word 0xc654256a  ! 1: LDSH_I	ldsh	[%r16 + 0x056a], %r3
	brnz %r31,thr3_loop_cnt_926
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x1a, %r31
thr3_loop_cnt_927:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xd8442e44  ! 1: LDSW_I	ldsw	[%r16 + 0x0e44], %r12
	.word 0xc6dc25a0  ! 1: LDXA_I	ldxa	[%r16, + 0x05a0] %asi, %r3
	.word 0xe48c2249  ! 1: LDUBA_I	lduba	[%r16, + 0x0249] %asi, %r18
	.word 0xec0c280c  ! 1: LDUB_I	ldub	[%r16 + 0x080c], %r22
	.word 0xcc842780  ! 1: LDUWA_I	lduwa	[%r16, + 0x0780] %asi, %r6
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_927
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0xc5, %r31
thr3_loop_cnt_928:
	.word 0xc6042e2c  ! 1: LDUW_I	lduw	[%r16 + 0x0e2c], %r3
	.word 0xded42ce6  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ce6] %asi, %r15
	.word 0xd0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r8
	.word 0xd25c2158  ! 1: LDX_I	ldx	[%r16 + 0x0158], %r9
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc65c2060  ! 1: LDX_I	ldx	[%r16 + 0x0060], %r3
	.word 0xc6842e84  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e84] %asi, %r3
	.word 0xc6042edc  ! 1: LDUW_I	lduw	[%r16 + 0x0edc], %r3
	.word 0xc60c29de  ! 1: LDUB_I	ldub	[%r16 + 0x09de], %r3
	.word 0xc68c2153  ! 1: LDUBA_I	lduba	[%r16, + 0x0153] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd4dc29d0  ! 1: LDXA_I	ldxa	[%r16, + 0x09d0] %asi, %r10
	brnz %r31,thr3_loop_cnt_928
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0xba040002  ! 1: ADD_R	add 	%r16, %r2, %r29
	.word 0x861423a0  ! 1: OR_I	or 	%r16, 0x03a0, %r3
        mov 0xa3, %r31
thr3_loop_cnt_929:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xe6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r19
	.word 0xdc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r14
	.word 0xf48c296b  ! 1: LDUBA_I	lduba	[%r16, + 0x096b] %asi, %r26
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6d42c0e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c0e] %asi, %r3
	.word 0xe20c2d19  ! 1: LDUB_I	ldub	[%r16 + 0x0d19], %r17
	brnz %r31,thr3_loop_cnt_929
	dec %r31
	.word 0x863c2561  ! 1: XNOR_I	xnor 	%r16, 0x0561, %r3
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0xab, %r31
thr3_loop_cnt_930:
	.word 0xd6842798  ! 1: LDUWA_I	lduwa	[%r16, + 0x0798] %asi, %r11
	.word 0xd08c2bbb  ! 1: LDUBA_I	lduba	[%r16, + 0x0bbb] %asi, %r8
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xdacc20b7  ! 1: LDSBA_I	ldsba	[%r16, + 0x00b7] %asi, %r13
	.word 0xf05c2708  ! 1: LDX_I	ldx	[%r16 + 0x0708], %r24
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xc60c29af  ! 1: LDUB_I	ldub	[%r16 + 0x09af], %r3
	.word 0xd28c2a07  ! 1: LDUBA_I	lduba	[%r16, + 0x0a07] %asi, %r9
	.word 0xc68c20ab  ! 1: LDUBA_I	lduba	[%r16, + 0x00ab] %asi, %r3
	.word 0xc6442f58  ! 1: LDSW_I	ldsw	[%r16 + 0x0f58], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_930
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x8624243c  ! 1: SUB_I	sub 	%r16, 0x043c, %r3
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x70, %r31
thr3_loop_cnt_931:
	.word 0xe6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r19
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	.word 0xea4c22c5  ! 1: LDSB_I	ldsb	[%r16 + 0x02c5], %r21
	.word 0xf604202c  ! 1: LDUW_I	lduw	[%r16 + 0x002c], %r27
	.word 0xc6cc2863  ! 1: LDSBA_I	ldsba	[%r16, + 0x0863] %asi, %r3
	.word 0xf8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r28
	.word 0xc61429ee  ! 1: LDUH_I	lduh	[%r16 + 0x09ee], %r3
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	brnz %r31,thr3_loop_cnt_931
	dec %r31
	.word 0x9a242703  ! 1: SUB_I	sub 	%r16, 0x0703, %r13
        mov 0xb3, %r31
thr3_loop_cnt_932:
	.word 0xde841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r15
	.word 0xc6cc2531  ! 1: LDSBA_I	ldsba	[%r16, + 0x0531] %asi, %r3
	.word 0xf8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r28
	.word 0xe80426c0  ! 1: LDUW_I	lduw	[%r16 + 0x06c0], %r20
	.word 0xe6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r19
	.word 0xfc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r30
	.word 0xdc9420f6  ! 1: LDUHA_I	lduha	[%r16, + 0x00f6] %asi, %r14
	.word 0xdc142a26  ! 1: LDUH_I	lduh	[%r16 + 0x0a26], %r14
	brnz %r31,thr3_loop_cnt_932
	dec %r31
	.word 0x920c259a  ! 1: AND_I	and 	%r16, 0x059a, %r9
        mov 0xb1, %r31
thr3_loop_cnt_933:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xee140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r23
	.word 0xd2142f54  ! 1: LDUH_I	lduh	[%r16 + 0x0f54], %r9
	.word 0xde4c20ba  ! 1: LDSB_I	ldsb	[%r16 + 0x00ba], %r15
	.word 0xc6442e60  ! 1: LDSW_I	ldsw	[%r16 + 0x0e60], %r3
	.word 0xc65c2948  ! 1: LDX_I	ldx	[%r16 + 0x0948], %r3
	.word 0xde8c238d  ! 1: LDUBA_I	lduba	[%r16, + 0x038d] %asi, %r15
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xce842450  ! 1: LDUWA_I	lduwa	[%r16, + 0x0450] %asi, %r7
	brnz %r31,thr3_loop_cnt_933
	dec %r31
        mov 0x2f, %r31
thr3_loop_cnt_934:
	.word 0xfc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r30
	.word 0xe6942188  ! 1: LDUHA_I	lduha	[%r16, + 0x0188] %asi, %r19
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc614288c  ! 1: LDUH_I	lduh	[%r16 + 0x088c], %r3
	.word 0xf89420b8  ! 1: LDUHA_I	lduha	[%r16, + 0x00b8] %asi, %r28
	.word 0xc6c42868  ! 1: LDSWA_I	ldswa	[%r16, + 0x0868] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xcc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r6
	brnz %r31,thr3_loop_cnt_934
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x861c2709  ! 1: XOR_I	xor 	%r16, 0x0709, %r3
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x3d, %r31
thr3_loop_cnt_935:
	.word 0xe6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r19
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xea040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r21
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xc65c2ff8  ! 1: LDX_I	ldx	[%r16 + 0x0ff8], %r3
	.word 0xc644220c  ! 1: LDSW_I	ldsw	[%r16 + 0x020c], %r3
	.word 0xc6c4281c  ! 1: LDSWA_I	ldswa	[%r16, + 0x081c] %asi, %r3
	.word 0xd4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r10
	brnz %r31,thr3_loop_cnt_935
	dec %r31
	.word 0xa204231e  ! 1: ADD_I	add 	%r16, 0x031e, %r17
	.word 0xb4340002  ! 1: ORN_R	orn 	%r16, %r2, %r26
        mov 0xa6, %r31
thr3_loop_cnt_936:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xdc9421b2  ! 1: LDUHA_I	lduha	[%r16, + 0x01b2] %asi, %r14
	.word 0xf6d421b0  ! 1: LDSHA_I	ldsha	[%r16, + 0x01b0] %asi, %r27
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6c42ed0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ed0] %asi, %r3
	.word 0xf4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r26
	.word 0xc6042574  ! 1: LDUW_I	lduw	[%r16 + 0x0574], %r3
	.word 0xd85425b2  ! 1: LDSH_I	ldsh	[%r16 + 0x05b2], %r12
	.word 0xc68c2203  ! 1: LDUBA_I	lduba	[%r16, + 0x0203] %asi, %r3
	.word 0xdec42b70  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b70] %asi, %r15
	brnz %r31,thr3_loop_cnt_936
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0xac3429e7  ! 1: ORN_I	orn 	%r16, 0x09e7, %r22
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0xc5, %r31
thr3_loop_cnt_937:
	.word 0xfa540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r29
	.word 0xf6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r27
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xc60c2b44  ! 1: LDUB_I	ldub	[%r16 + 0x0b44], %r3
	.word 0xee8c22ec  ! 1: LDUBA_I	lduba	[%r16, + 0x02ec] %asi, %r23
	.word 0xf08c2290  ! 1: LDUBA_I	lduba	[%r16, + 0x0290] %asi, %r24
	.word 0xe45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r18
	.word 0xf88c2b7f  ! 1: LDUBA_I	lduba	[%r16, + 0x0b7f] %asi, %r28
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xe2c42d64  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d64] %asi, %r17
	brnz %r31,thr3_loop_cnt_937
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0xaa240002  ! 1: SUB_R	sub 	%r16, %r2, %r21
        mov 0x76, %r31
thr3_loop_cnt_938:
	.word 0xf25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r25
	.word 0xc6cc2fc2  ! 1: LDSBA_I	ldsba	[%r16, + 0x0fc2] %asi, %r3
	.word 0xc644245c  ! 1: LDSW_I	ldsw	[%r16 + 0x045c], %r3
	.word 0xec5c22b0  ! 1: LDX_I	ldx	[%r16 + 0x02b0], %r22
	.word 0xc68421fc  ! 1: LDUWA_I	lduwa	[%r16, + 0x01fc] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xfc942a22  ! 1: LDUHA_I	lduha	[%r16, + 0x0a22] %asi, %r30
	.word 0xd8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r12
	brnz %r31,thr3_loop_cnt_938
	dec %r31
        mov 0x73, %r31
thr3_loop_cnt_939:
	.word 0xe8c42ca4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ca4] %asi, %r20
	.word 0xe8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r20
	.word 0xc6dc20a0  ! 1: LDXA_I	ldxa	[%r16, + 0x00a0] %asi, %r3
	.word 0xc6c425fc  ! 1: LDSWA_I	ldswa	[%r16, + 0x05fc] %asi, %r3
	.word 0xd6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r11
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xee042a98  ! 1: LDUW_I	lduw	[%r16 + 0x0a98], %r23
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xec542440  ! 1: LDSH_I	ldsh	[%r16 + 0x0440], %r22
	brnz %r31,thr3_loop_cnt_939
	dec %r31
	.word 0xbc3428a0  ! 1: SUBC_I	orn 	%r16, 0x08a0, %r30
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0xb0, %r31
thr3_loop_cnt_940:
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xf0942de0  ! 1: LDUHA_I	lduha	[%r16, + 0x0de0] %asi, %r24
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xfa442c58  ! 1: LDSW_I	ldsw	[%r16 + 0x0c58], %r29
	.word 0xdacc29fc  ! 1: LDSBA_I	ldsba	[%r16, + 0x09fc] %asi, %r13
	.word 0xc64c26e5  ! 1: LDSB_I	ldsb	[%r16 + 0x06e5], %r3
	.word 0xc6dc2d40  ! 1: LDXA_I	ldxa	[%r16, + 0x0d40] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc64c28ba  ! 1: LDSB_I	ldsb	[%r16 + 0x08ba], %r3
	.word 0xe48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r18
	.word 0xecc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r22
	.word 0xc6d42286  ! 1: LDSHA_I	ldsha	[%r16, + 0x0286] %asi, %r3
	brnz %r31,thr3_loop_cnt_940
	dec %r31
	.word 0xac2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r22
	.word 0xb20c285b  ! 1: AND_I	and 	%r16, 0x085b, %r25
	.word 0x863c280f  ! 1: XNOR_I	xnor 	%r16, 0x080f, %r3
        mov 0x9a, %r31
thr3_loop_cnt_941:
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xc64426d0  ! 1: LDSW_I	ldsw	[%r16 + 0x06d0], %r3
	.word 0xccd42eca  ! 1: LDSHA_I	ldsha	[%r16, + 0x0eca] %asi, %r6
	.word 0xc68c28f1  ! 1: LDUBA_I	lduba	[%r16, + 0x08f1] %asi, %r3
	.word 0xc68c2c8b  ! 1: LDUBA_I	lduba	[%r16, + 0x0c8b] %asi, %r3
	.word 0xc6542582  ! 1: LDSH_I	ldsh	[%r16 + 0x0582], %r3
	.word 0xd4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r10
	.word 0xe6042044  ! 1: LDUW_I	lduw	[%r16 + 0x0044], %r19
	brnz %r31,thr3_loop_cnt_941
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0xaa, %r31
thr3_loop_cnt_942:
	.word 0xc6dc21f0  ! 1: LDXA_I	ldxa	[%r16, + 0x01f0] %asi, %r3
	.word 0xc6cc2dd5  ! 1: LDSBA_I	ldsba	[%r16, + 0x0dd5] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xda4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r13
	.word 0xde941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r15
	.word 0xdc9423b0  ! 1: LDUHA_I	lduha	[%r16, + 0x03b0] %asi, %r14
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_942
	dec %r31
	.word 0x9e440002  ! 1: ADDC_R	addc 	%r16, %r2, %r15
        mov 0x9a, %r31
thr3_loop_cnt_943:
	.word 0xc6942a40  ! 1: LDUHA_I	lduha	[%r16, + 0x0a40] %asi, %r3
	.word 0xc64c2945  ! 1: LDSB_I	ldsb	[%r16 + 0x0945], %r3
	.word 0xdc0c2271  ! 1: LDUB_I	ldub	[%r16 + 0x0271], %r14
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc65c2ef8  ! 1: LDX_I	ldx	[%r16 + 0x0ef8], %r3
	.word 0xc68423c8  ! 1: LDUWA_I	lduwa	[%r16, + 0x03c8] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xcc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r6
	brnz %r31,thr3_loop_cnt_943
	dec %r31
        mov 0xc3, %r31
thr3_loop_cnt_944:
	.word 0xe24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r17
	.word 0xc68428bc  ! 1: LDUWA_I	lduwa	[%r16, + 0x08bc] %asi, %r3
	.word 0xe69429c2  ! 1: LDUHA_I	lduha	[%r16, + 0x09c2] %asi, %r19
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc614205a  ! 1: LDUH_I	lduh	[%r16 + 0x005a], %r3
	brnz %r31,thr3_loop_cnt_944
	dec %r31
	.word 0xa9341002  ! 1: SRLX_R	srlx	%r16, %r2, %r20
        mov 0x78, %r31
thr3_loop_cnt_945:
	.word 0xdcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r14
	.word 0xc6cc21ea  ! 1: LDSBA_I	ldsba	[%r16, + 0x01ea] %asi, %r3
	.word 0xda8c20f8  ! 1: LDUBA_I	lduba	[%r16, + 0x00f8] %asi, %r13
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xfa9424fc  ! 1: LDUHA_I	lduha	[%r16, + 0x04fc] %asi, %r29
	.word 0xc6d422e8  ! 1: LDSHA_I	ldsha	[%r16, + 0x02e8] %asi, %r3
	brnz %r31,thr3_loop_cnt_945
	dec %r31
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x72, %r31
thr3_loop_cnt_946:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc69425b4  ! 1: LDUHA_I	lduha	[%r16, + 0x05b4] %asi, %r3
	.word 0xf0542f40  ! 1: LDSH_I	ldsh	[%r16 + 0x0f40], %r24
	.word 0xfc4c250d  ! 1: LDSB_I	ldsb	[%r16 + 0x050d], %r30
	.word 0xc6dc2790  ! 1: LDXA_I	ldxa	[%r16, + 0x0790] %asi, %r3
	.word 0xf04c20d7  ! 1: LDSB_I	ldsb	[%r16 + 0x00d7], %r24
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6c425e0  ! 1: LDSWA_I	ldswa	[%r16, + 0x05e0] %asi, %r3
	.word 0xf8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r28
	brnz %r31,thr3_loop_cnt_946
	dec %r31
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0xaa340002  ! 1: SUBC_R	orn 	%r16, %r2, %r21
        mov 0xaa, %r31
thr3_loop_cnt_947:
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xeed41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r23
	.word 0xe68420d4  ! 1: LDUWA_I	lduwa	[%r16, + 0x00d4] %asi, %r19
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r20
	.word 0xf4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r26
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xfc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r30
	brnz %r31,thr3_loop_cnt_947
	dec %r31
	.word 0x9a140002  ! 1: OR_R	or 	%r16, %r2, %r13
	.word 0x8f340002  ! 1: SRL_R	srl 	%r16, %r2, %r7
	.word 0xaf2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r23
	.word 0x96340002  ! 1: SUBC_R	orn 	%r16, %r2, %r11
        mov 0xbe, %r31
thr3_loop_cnt_948:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xd2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r9
	.word 0xda94205e  ! 1: LDUHA_I	lduha	[%r16, + 0x005e] %asi, %r13
	.word 0xc6442cbc  ! 1: LDSW_I	ldsw	[%r16 + 0x0cbc], %r3
	.word 0xc64c28a2  ! 1: LDSB_I	ldsb	[%r16 + 0x08a2], %r3
	.word 0xda5c2c30  ! 1: LDX_I	ldx	[%r16 + 0x0c30], %r13
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xeac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r21
	.word 0xdc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r14
	.word 0xf44420b0  ! 1: LDSW_I	ldsw	[%r16 + 0x00b0], %r26
	brnz %r31,thr3_loop_cnt_948
	dec %r31
	.word 0x9f3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r15
	.word 0x860c2469  ! 1: AND_I	and 	%r16, 0x0469, %r3
	.word 0xa9343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r20
        mov 0x80, %r31
thr3_loop_cnt_949:
	.word 0xf4d429d6  ! 1: LDSHA_I	ldsha	[%r16, + 0x09d6] %asi, %r26
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd8cc2f5d  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f5d] %asi, %r12
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xce040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r7
	.word 0xfc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r30
	.word 0xc694221c  ! 1: LDUHA_I	lduha	[%r16, + 0x021c] %asi, %r3
	brnz %r31,thr3_loop_cnt_949
	dec %r31
	.word 0x921c2645  ! 1: XOR_I	xor 	%r16, 0x0645, %r9
        mov 0xa5, %r31
thr3_loop_cnt_950:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6842f94  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f94] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc64c2126  ! 1: LDSB_I	ldsb	[%r16 + 0x0126], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf84424e8  ! 1: LDSW_I	ldsw	[%r16 + 0x04e8], %r28
	brnz %r31,thr3_loop_cnt_950
	dec %r31
	.word 0x933c0002  ! 1: SRA_R	sra 	%r16, %r2, %r9
        mov 0x95, %r31
thr3_loop_cnt_951:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xde5c2550  ! 1: LDX_I	ldx	[%r16 + 0x0550], %r15
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xfcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r30
	.word 0xf0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r24
	.word 0xe4842920  ! 1: LDUWA_I	lduwa	[%r16, + 0x0920] %asi, %r18
	.word 0xcccc291f  ! 1: LDSBA_I	ldsba	[%r16, + 0x091f] %asi, %r6
	.word 0xc6dc2400  ! 1: LDXA_I	ldxa	[%r16, + 0x0400] %asi, %r3
	.word 0xd8442eac  ! 1: LDSW_I	ldsw	[%r16 + 0x0eac], %r12
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6442b2c  ! 1: LDSW_I	ldsw	[%r16 + 0x0b2c], %r3
	.word 0xd4942954  ! 1: LDUHA_I	lduha	[%r16, + 0x0954] %asi, %r10
	brnz %r31,thr3_loop_cnt_951
	dec %r31
	.word 0xad2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r22
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0xb73c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r27
        mov 0x42, %r31
thr3_loop_cnt_952:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc69422d8  ! 1: LDUHA_I	lduha	[%r16, + 0x02d8] %asi, %r3
	.word 0xf00c2fc4  ! 1: LDUB_I	ldub	[%r16 + 0x0fc4], %r24
	.word 0xea841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r21
	.word 0xfcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r30
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc64c2f67  ! 1: LDSB_I	ldsb	[%r16 + 0x0f67], %r3
	.word 0xf8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r28
	brnz %r31,thr3_loop_cnt_952
	dec %r31
        mov 0xb3, %r31
thr3_loop_cnt_953:
	.word 0xce842ecc  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ecc] %asi, %r7
	.word 0xd214217e  ! 1: LDUH_I	lduh	[%r16 + 0x017e], %r9
	.word 0xe4942a90  ! 1: LDUHA_I	lduha	[%r16, + 0x0a90] %asi, %r18
	.word 0xc65c26f0  ! 1: LDX_I	ldx	[%r16 + 0x06f0], %r3
	.word 0xdc8c26c9  ! 1: LDUBA_I	lduba	[%r16, + 0x06c9] %asi, %r14
	.word 0xea540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r21
	.word 0xe6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r19
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd0d42dca  ! 1: LDSHA_I	ldsha	[%r16, + 0x0dca] %asi, %r8
	.word 0xc64422c8  ! 1: LDSW_I	ldsw	[%r16 + 0x02c8], %r3
	brnz %r31,thr3_loop_cnt_953
	dec %r31
	.word 0x861427fb  ! 1: OR_I	or 	%r16, 0x07fb, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0x59, %r31
thr3_loop_cnt_954:
	.word 0xc6cc2bf5  ! 1: LDSBA_I	ldsba	[%r16, + 0x0bf5] %asi, %r3
	.word 0xd85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r12
	.word 0xf2dc2c30  ! 1: LDXA_I	ldxa	[%r16, + 0x0c30] %asi, %r25
	.word 0xe44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r18
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2421  ! 1: LDSBA_I	ldsba	[%r16, + 0x0421] %asi, %r3
	.word 0xe2cc269b  ! 1: LDSBA_I	ldsba	[%r16, + 0x069b] %asi, %r17
	.word 0xc6cc2e38  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e38] %asi, %r3
	.word 0xc60c236d  ! 1: LDUB_I	ldub	[%r16 + 0x036d], %r3
	.word 0xde442608  ! 1: LDSW_I	ldsw	[%r16 + 0x0608], %r15
	brnz %r31,thr3_loop_cnt_954
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x24, %r31
thr3_loop_cnt_955:
	.word 0xf20c21d1  ! 1: LDUB_I	ldub	[%r16 + 0x01d1], %r25
	.word 0xfc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r30
	.word 0xcc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r6
	.word 0xc68c2733  ! 1: LDUBA_I	lduba	[%r16, + 0x0733] %asi, %r3
	.word 0xee8c2e47  ! 1: LDUBA_I	lduba	[%r16, + 0x0e47] %asi, %r23
	.word 0xe2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r17
	.word 0xce842a3c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a3c] %asi, %r7
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_955
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x99340002  ! 1: SRL_R	srl 	%r16, %r2, %r12
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x1a, %r31
thr3_loop_cnt_956:
	.word 0xc64c2511  ! 1: LDSB_I	ldsb	[%r16 + 0x0511], %r3
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6d42e06  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e06] %asi, %r3
	.word 0xf6d42ece  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ece] %asi, %r27
	.word 0xee8c28c7  ! 1: LDUBA_I	lduba	[%r16, + 0x08c7] %asi, %r23
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6442f2c  ! 1: LDSW_I	ldsw	[%r16 + 0x0f2c], %r3
	brnz %r31,thr3_loop_cnt_956
	dec %r31
	.word 0x9c3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r14
        mov 0x25, %r31
thr3_loop_cnt_957:
	.word 0xc65c28f8  ! 1: LDX_I	ldx	[%r16 + 0x08f8], %r3
	.word 0xe6542ea4  ! 1: LDSH_I	ldsh	[%r16 + 0x0ea4], %r19
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf48c237b  ! 1: LDUBA_I	lduba	[%r16, + 0x037b] %asi, %r26
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe6cc2485  ! 1: LDSBA_I	ldsba	[%r16, + 0x0485] %asi, %r19
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc64c21ae  ! 1: LDSB_I	ldsb	[%r16 + 0x01ae], %r3
	.word 0xde941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r15
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_957
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0xb6440002  ! 1: ADDC_R	addc 	%r16, %r2, %r27
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0xc5, %r31
thr3_loop_cnt_958:
	.word 0xde8c2436  ! 1: LDUBA_I	lduba	[%r16, + 0x0436] %asi, %r15
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xea841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r21
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xc6442bf8  ! 1: LDSW_I	ldsw	[%r16 + 0x0bf8], %r3
	.word 0xc6042204  ! 1: LDUW_I	lduw	[%r16 + 0x0204], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf64c2416  ! 1: LDSB_I	ldsb	[%r16 + 0x0416], %r27
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	.word 0xf8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r28
	.word 0xe6d423fc  ! 1: LDSHA_I	ldsha	[%r16, + 0x03fc] %asi, %r19
	brnz %r31,thr3_loop_cnt_958
	dec %r31
        mov 0x7e, %r31
thr3_loop_cnt_959:
	.word 0xc6042c54  ! 1: LDUW_I	lduw	[%r16 + 0x0c54], %r3
	.word 0xf60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r27
	.word 0xc6542422  ! 1: LDSH_I	ldsh	[%r16 + 0x0422], %r3
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	.word 0xc60420a4  ! 1: LDUW_I	lduw	[%r16 + 0x00a4], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe65429da  ! 1: LDSH_I	ldsh	[%r16 + 0x09da], %r19
	.word 0xc6942c62  ! 1: LDUHA_I	lduha	[%r16, + 0x0c62] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_959
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0xb2040002  ! 1: ADD_R	add 	%r16, %r2, %r25
        mov 0x73, %r31
thr3_loop_cnt_960:
	.word 0xc6842db4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0db4] %asi, %r3
	.word 0xe2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r17
	.word 0xc6cc2d58  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d58] %asi, %r3
	.word 0xd64c2d8c  ! 1: LDSB_I	ldsb	[%r16 + 0x0d8c], %r11
	.word 0xc604235c  ! 1: LDUW_I	lduw	[%r16 + 0x035c], %r3
	.word 0xd45c23d0  ! 1: LDX_I	ldx	[%r16 + 0x03d0], %r10
	.word 0xc64c2200  ! 1: LDSB_I	ldsb	[%r16 + 0x0200], %r3
	.word 0xfc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r30
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_960
	dec %r31
        mov 0x95, %r31
thr3_loop_cnt_961:
	.word 0xc6442640  ! 1: LDSW_I	ldsw	[%r16 + 0x0640], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r8
	.word 0xf8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r28
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc60c2734  ! 1: LDUB_I	ldub	[%r16 + 0x0734], %r3
	.word 0xdc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r14
	.word 0xf28c2845  ! 1: LDUBA_I	lduba	[%r16, + 0x0845] %asi, %r25
	brnz %r31,thr3_loop_cnt_961
	dec %r31
	.word 0x8f340002  ! 1: SRL_R	srl 	%r16, %r2, %r7
	.word 0x92042c9e  ! 1: ADD_I	add 	%r16, 0x0c9e, %r9
        mov 0xbf, %r31
thr3_loop_cnt_962:
	.word 0xe6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r19
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xea0c2d61  ! 1: LDUB_I	ldub	[%r16 + 0x0d61], %r21
	.word 0xd44c2a78  ! 1: LDSB_I	ldsb	[%r16 + 0x0a78], %r10
	.word 0xe44c223a  ! 1: LDSB_I	ldsb	[%r16 + 0x023a], %r18
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6c424e4  ! 1: LDSWA_I	ldswa	[%r16, + 0x04e4] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xee5c2368  ! 1: LDX_I	ldx	[%r16 + 0x0368], %r23
	brnz %r31,thr3_loop_cnt_962
	dec %r31
	.word 0x933c1002  ! 1: SRAX_R	srax	%r16, %r2, %r9
	.word 0x862c2631  ! 1: ANDN_I	andn 	%r16, 0x0631, %r3
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x9d2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r14
        mov 0xa5, %r31
thr3_loop_cnt_963:
	.word 0xd68c22b7  ! 1: LDUBA_I	lduba	[%r16, + 0x02b7] %asi, %r11
	.word 0xd6d42d04  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d04] %asi, %r11
	.word 0xec5c2f00  ! 1: LDX_I	ldx	[%r16 + 0x0f00], %r22
	.word 0xc6942c86  ! 1: LDUHA_I	lduha	[%r16, + 0x0c86] %asi, %r3
	.word 0xcc8423fc  ! 1: LDUWA_I	lduwa	[%r16, + 0x03fc] %asi, %r6
	.word 0xc60c24ca  ! 1: LDUB_I	ldub	[%r16 + 0x04ca], %r3
	.word 0xd8542948  ! 1: LDSH_I	ldsh	[%r16 + 0x0948], %r12
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	brnz %r31,thr3_loop_cnt_963
	dec %r31
        mov 0x4d, %r31
thr3_loop_cnt_964:
	.word 0xc68426a4  ! 1: LDUWA_I	lduwa	[%r16, + 0x06a4] %asi, %r3
	.word 0xc6942524  ! 1: LDUHA_I	lduha	[%r16, + 0x0524] %asi, %r3
	.word 0xc6442010  ! 1: LDSW_I	ldsw	[%r16 + 0x0010], %r3
	.word 0xc6d4210a  ! 1: LDSHA_I	ldsha	[%r16, + 0x010a] %asi, %r3
	.word 0xea8c2720  ! 1: LDUBA_I	lduba	[%r16, + 0x0720] %asi, %r21
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf6842d50  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d50] %asi, %r27
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_964
	dec %r31
	.word 0x983c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r12
	.word 0xb4442938  ! 1: ADDC_I	addc 	%r16, 0x0938, %r26
	.word 0x981c2635  ! 1: XOR_I	xor 	%r16, 0x0635, %r12
        mov 0x7a, %r31
thr3_loop_cnt_965:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xde5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r15
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc604207c  ! 1: LDUW_I	lduw	[%r16 + 0x007c], %r3
	.word 0xe6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r19
	.word 0xda4c2fc9  ! 1: LDSB_I	ldsb	[%r16 + 0x0fc9], %r13
	.word 0xf4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r26
	.word 0xf65427be  ! 1: LDSH_I	ldsh	[%r16 + 0x07be], %r27
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_965
	dec %r31
        mov 0x50, %r31
thr3_loop_cnt_966:
	.word 0xcc842a08  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a08] %asi, %r6
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r8
	.word 0xf24c27e4  ! 1: LDSB_I	ldsb	[%r16 + 0x07e4], %r25
	.word 0xd4442d60  ! 1: LDSW_I	ldsw	[%r16 + 0x0d60], %r10
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r24
	.word 0xc6cc244b  ! 1: LDSBA_I	ldsba	[%r16, + 0x044b] %asi, %r3
	brnz %r31,thr3_loop_cnt_966
	dec %r31
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0xb1343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r24
	.word 0xa20c0002  ! 1: AND_R	and 	%r16, %r2, %r17
	.word 0xba440002  ! 1: ADDC_R	addc 	%r16, %r2, %r29
        mov 0x8d, %r31
thr3_loop_cnt_967:
	.word 0xec4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r22
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc65c2310  ! 1: LDX_I	ldx	[%r16 + 0x0310], %r3
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xc64c21c3  ! 1: LDSB_I	ldsb	[%r16 + 0x01c3], %r3
	.word 0xdc5429b8  ! 1: LDSH_I	ldsh	[%r16 + 0x09b8], %r14
	.word 0xfc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r30
	.word 0xc64c2641  ! 1: LDSB_I	ldsb	[%r16 + 0x0641], %r3
	.word 0xe2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r17
	brnz %r31,thr3_loop_cnt_967
	dec %r31
        mov 0x7b, %r31
thr3_loop_cnt_968:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r8
	.word 0xc644233c  ! 1: LDSW_I	ldsw	[%r16 + 0x033c], %r3
	.word 0xc60c2d72  ! 1: LDUB_I	ldub	[%r16 + 0x0d72], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd8042f6c  ! 1: LDUW_I	lduw	[%r16 + 0x0f6c], %r12
	.word 0xdacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r13
	brnz %r31,thr3_loop_cnt_968
	dec %r31
        mov 0x7e, %r31
thr3_loop_cnt_969:
	.word 0xee540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r23
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6942218  ! 1: LDUHA_I	lduha	[%r16, + 0x0218] %asi, %r3
	.word 0xc68c24db  ! 1: LDUBA_I	lduba	[%r16, + 0x04db] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r25
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_969
	dec %r31
        mov 0x49, %r31
thr3_loop_cnt_970:
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xc6d42f92  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f92] %asi, %r3
	.word 0xf25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r25
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xdc0c20ec  ! 1: LDUB_I	ldub	[%r16 + 0x00ec], %r14
	.word 0xc6dc2f38  ! 1: LDXA_I	ldxa	[%r16, + 0x0f38] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	brnz %r31,thr3_loop_cnt_970
	dec %r31
	.word 0xaa3c2146  ! 1: XNOR_I	xnor 	%r16, 0x0146, %r21
	.word 0x8614210f  ! 1: OR_I	or 	%r16, 0x010f, %r3
	.word 0x860c29c9  ! 1: AND_I	and 	%r16, 0x09c9, %r3
	.word 0x86442b0b  ! 1: ADDC_I	addc 	%r16, 0x0b0b, %r3
        mov 0xa5, %r31
thr3_loop_cnt_971:
	.word 0xc68c2dd9  ! 1: LDUBA_I	lduba	[%r16, + 0x0dd9] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6142762  ! 1: LDUH_I	lduh	[%r16 + 0x0762], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2f98  ! 1: LDXA_I	ldxa	[%r16, + 0x0f98] %asi, %r3
	.word 0xd2142e6e  ! 1: LDUH_I	lduh	[%r16 + 0x0e6e], %r9
	.word 0xe2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r17
	brnz %r31,thr3_loop_cnt_971
	dec %r31
	.word 0x94240002  ! 1: SUB_R	sub 	%r16, %r2, %r10
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x28, %r31
thr3_loop_cnt_972:
	.word 0xfa8c28d4  ! 1: LDUBA_I	lduba	[%r16, + 0x08d4] %asi, %r29
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc654289e  ! 1: LDSH_I	ldsh	[%r16 + 0x089e], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xcc1426f0  ! 1: LDUH_I	lduh	[%r16 + 0x06f0], %r6
	.word 0xea4c2c49  ! 1: LDSB_I	ldsb	[%r16 + 0x0c49], %r21
	.word 0xdc5c2010  ! 1: LDX_I	ldx	[%r16 + 0x0010], %r14
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd48426c4  ! 1: LDUWA_I	lduwa	[%r16, + 0x06c4] %asi, %r10
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_972
	dec %r31
	.word 0xa32c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r17
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0xaf2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r23
	.word 0xa61c2f89  ! 1: XOR_I	xor 	%r16, 0x0f89, %r19
        mov 0x48, %r31
thr3_loop_cnt_973:
	.word 0xd65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r11
	.word 0xecd4217c  ! 1: LDSHA_I	ldsha	[%r16, + 0x017c] %asi, %r22
	.word 0xe8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r20
	.word 0xc6842c44  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c44] %asi, %r3
	.word 0xc60c22eb  ! 1: LDUB_I	ldub	[%r16 + 0x02eb], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6842208  ! 1: LDUWA_I	lduwa	[%r16, + 0x0208] %asi, %r3
	.word 0xc6042c0c  ! 1: LDUW_I	lduw	[%r16 + 0x0c0c], %r3
	.word 0xee8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r23
	.word 0xec5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r22
	.word 0xf6942ef6  ! 1: LDUHA_I	lduha	[%r16, + 0x0ef6] %asi, %r27
	brnz %r31,thr3_loop_cnt_973
	dec %r31
        mov 0x6d, %r31
thr3_loop_cnt_974:
	.word 0xc6842ae0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ae0] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xdedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r15
	.word 0xc6dc2958  ! 1: LDXA_I	ldxa	[%r16, + 0x0958] %asi, %r3
	.word 0xd8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r12
	.word 0xc6542f60  ! 1: LDSH_I	ldsh	[%r16 + 0x0f60], %r3
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	.word 0xc6d42280  ! 1: LDSHA_I	ldsha	[%r16, + 0x0280] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xce440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r7
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_974
	dec %r31
        mov 0x87, %r31
thr3_loop_cnt_975:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xde941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r15
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xf8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r28
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r12
	.word 0xfad42eec  ! 1: LDSHA_I	ldsha	[%r16, + 0x0eec] %asi, %r29
	.word 0xd4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r10
	.word 0xde542842  ! 1: LDSH_I	ldsh	[%r16 + 0x0842], %r15
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd40c2065  ! 1: LDUB_I	ldub	[%r16 + 0x0065], %r10
	.word 0xee440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r23
	brnz %r31,thr3_loop_cnt_975
	dec %r31
	.word 0xac0c29fe  ! 1: AND_I	and 	%r16, 0x09fe, %r22
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x96440002  ! 1: ADDC_R	addc 	%r16, %r2, %r11
        mov 0x8, %r31
thr3_loop_cnt_976:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6042714  ! 1: LDUW_I	lduw	[%r16 + 0x0714], %r3
	.word 0xf6842288  ! 1: LDUWA_I	lduwa	[%r16, + 0x0288] %asi, %r27
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc68c2aec  ! 1: LDUBA_I	lduba	[%r16, + 0x0aec] %asi, %r3
	.word 0xf8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r28
	.word 0xf8042390  ! 1: LDUW_I	lduw	[%r16 + 0x0390], %r28
	brnz %r31,thr3_loop_cnt_976
	dec %r31
	.word 0xa3343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r17
	.word 0x8e042a7f  ! 1: ADD_I	add 	%r16, 0x0a7f, %r7
	.word 0x8624235a  ! 1: SUB_I	sub 	%r16, 0x035a, %r3
	.word 0x902c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r8
        mov 0x31, %r31
thr3_loop_cnt_977:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc684205c  ! 1: LDUWA_I	lduwa	[%r16, + 0x005c] %asi, %r3
	.word 0xd2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r9
	.word 0xc6442ebc  ! 1: LDSW_I	ldsw	[%r16 + 0x0ebc], %r3
	.word 0xde540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r15
	.word 0xe2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r17
	.word 0xfc8c212b  ! 1: LDUBA_I	lduba	[%r16, + 0x012b] %asi, %r30
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6842298  ! 1: LDUWA_I	lduwa	[%r16, + 0x0298] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd0c42740  ! 1: LDSWA_I	ldswa	[%r16, + 0x0740] %asi, %r8
	.word 0xe4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r18
	brnz %r31,thr3_loop_cnt_977
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0xb2140002  ! 1: OR_R	or 	%r16, %r2, %r25
        mov 0x3b, %r31
thr3_loop_cnt_978:
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xc6142294  ! 1: LDUH_I	lduh	[%r16 + 0x0294], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2890  ! 1: LDXA_I	ldxa	[%r16, + 0x0890] %asi, %r3
	.word 0xf2042d74  ! 1: LDUW_I	lduw	[%r16 + 0x0d74], %r25
	.word 0xc604298c  ! 1: LDUW_I	lduw	[%r16 + 0x098c], %r3
	.word 0xce142eb8  ! 1: LDUH_I	lduh	[%r16 + 0x0eb8], %r7
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	brnz %r31,thr3_loop_cnt_978
	dec %r31
        mov 0x96, %r31
thr3_loop_cnt_979:
	.word 0xd80c2a7e  ! 1: LDUB_I	ldub	[%r16 + 0x0a7e], %r12
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf2dc2a50  ! 1: LDXA_I	ldxa	[%r16, + 0x0a50] %asi, %r25
	.word 0xdcc42974  ! 1: LDSWA_I	ldswa	[%r16, + 0x0974] %asi, %r14
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf2cc214d  ! 1: LDSBA_I	ldsba	[%r16, + 0x014d] %asi, %r25
	.word 0xd05c2440  ! 1: LDX_I	ldx	[%r16 + 0x0440], %r8
	.word 0xc6042ee8  ! 1: LDUW_I	lduw	[%r16 + 0x0ee8], %r3
	brnz %r31,thr3_loop_cnt_979
	dec %r31
	.word 0x861c2e0a  ! 1: XOR_I	xor 	%r16, 0x0e0a, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0xa2440002  ! 1: ADDC_R	addc 	%r16, %r2, %r17
        mov 0x5d, %r31
thr3_loop_cnt_980:
	.word 0xd0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r8
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c2b41  ! 1: LDSB_I	ldsb	[%r16 + 0x0b41], %r3
	.word 0xde942262  ! 1: LDUHA_I	lduha	[%r16, + 0x0262] %asi, %r15
	.word 0xcc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r6
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r9
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r28
	brnz %r31,thr3_loop_cnt_980
	dec %r31
	.word 0x8c240002  ! 1: SUB_R	sub 	%r16, %r2, %r6
        mov 0x24, %r31
thr3_loop_cnt_981:
	.word 0xe6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r19
	.word 0xf2cc2bee  ! 1: LDSBA_I	ldsba	[%r16, + 0x0bee] %asi, %r25
	.word 0xc6dc2b30  ! 1: LDXA_I	ldxa	[%r16, + 0x0b30] %asi, %r3
	.word 0xc68c2a86  ! 1: LDUBA_I	lduba	[%r16, + 0x0a86] %asi, %r3
	.word 0xc6942a22  ! 1: LDUHA_I	lduha	[%r16, + 0x0a22] %asi, %r3
	.word 0xde0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r15
	.word 0xd8942a70  ! 1: LDUHA_I	lduha	[%r16, + 0x0a70] %asi, %r12
	.word 0xc6c425b8  ! 1: LDSWA_I	ldswa	[%r16, + 0x05b8] %asi, %r3
	.word 0xd24c2c6e  ! 1: LDSB_I	ldsb	[%r16 + 0x0c6e], %r9
	.word 0xfad42114  ! 1: LDSHA_I	ldsha	[%r16, + 0x0114] %asi, %r29
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	.word 0xea540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r21
	brnz %r31,thr3_loop_cnt_981
	dec %r31
	.word 0xac440002  ! 1: ADDC_R	addc 	%r16, %r2, %r22
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x86042a97  ! 1: ADD_I	add 	%r16, 0x0a97, %r3
        mov 0x40, %r31
thr3_loop_cnt_982:
	.word 0xc65424c0  ! 1: LDSH_I	ldsh	[%r16 + 0x04c0], %r3
	.word 0xe45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r18
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r20
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xecdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r22
	.word 0xe2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r17
	.word 0xc6142f08  ! 1: LDUH_I	lduh	[%r16 + 0x0f08], %r3
	.word 0xda142326  ! 1: LDUH_I	lduh	[%r16 + 0x0326], %r13
	.word 0xc68c2d65  ! 1: LDUBA_I	lduba	[%r16, + 0x0d65] %asi, %r3
	brnz %r31,thr3_loop_cnt_982
	dec %r31
	.word 0xb6442cd0  ! 1: ADDC_I	addc 	%r16, 0x0cd0, %r27
	.word 0x86242646  ! 1: SUB_I	sub 	%r16, 0x0646, %r3
        mov 0x3e, %r31
thr3_loop_cnt_983:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xde8c2ea0  ! 1: LDUBA_I	lduba	[%r16, + 0x0ea0] %asi, %r15
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6142f3a  ! 1: LDUH_I	lduh	[%r16 + 0x0f3a], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd6442554  ! 1: LDSW_I	ldsw	[%r16 + 0x0554], %r11
	.word 0xc654296a  ! 1: LDSH_I	ldsh	[%r16 + 0x096a], %r3
	brnz %r31,thr3_loop_cnt_983
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x861c20fc  ! 1: XOR_I	xor 	%r16, 0x00fc, %r3
	.word 0x9b3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r13
	.word 0x86342508  ! 1: ORN_I	orn 	%r16, 0x0508, %r3
        mov 0x40, %r31
thr3_loop_cnt_984:
	.word 0xee942372  ! 1: LDUHA_I	lduha	[%r16, + 0x0372] %asi, %r23
	.word 0xf85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r28
	.word 0xe84c258b  ! 1: LDSB_I	ldsb	[%r16 + 0x058b], %r20
	.word 0xd0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r8
	.word 0xce941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r7
	.word 0xcc542892  ! 1: LDSH_I	ldsh	[%r16 + 0x0892], %r6
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf2d426e2  ! 1: LDSHA_I	ldsha	[%r16, + 0x06e2] %asi, %r25
	.word 0xd6dc2598  ! 1: LDXA_I	ldxa	[%r16, + 0x0598] %asi, %r11
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc60c2045  ! 1: LDUB_I	ldub	[%r16 + 0x0045], %r3
	brnz %r31,thr3_loop_cnt_984
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x9c242a3b  ! 1: SUB_I	sub 	%r16, 0x0a3b, %r14
        mov 0x4a, %r31
thr3_loop_cnt_985:
	.word 0xf89425c8  ! 1: LDUHA_I	lduha	[%r16, + 0x05c8] %asi, %r28
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r8
	.word 0xd4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r10
	.word 0xf0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r24
	.word 0xc64c28af  ! 1: LDSB_I	ldsb	[%r16 + 0x08af], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xea0c299c  ! 1: LDUB_I	ldub	[%r16 + 0x099c], %r21
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc68c2a81  ! 1: LDUBA_I	lduba	[%r16, + 0x0a81] %asi, %r3
	brnz %r31,thr3_loop_cnt_985
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x8634285f  ! 1: SUBC_I	orn 	%r16, 0x085f, %r3
	.word 0x863c2c4b  ! 1: XNOR_I	xnor 	%r16, 0x0c4b, %r3
        mov 0x8a, %r31
thr3_loop_cnt_986:
	.word 0xc65c2c00  ! 1: LDX_I	ldx	[%r16 + 0x0c00], %r3
	.word 0xc6442ae8  ! 1: LDSW_I	ldsw	[%r16 + 0x0ae8], %r3
	.word 0xc6d4238a  ! 1: LDSHA_I	ldsha	[%r16, + 0x038a] %asi, %r3
	.word 0xf65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r27
	.word 0xc65c2bf0  ! 1: LDX_I	ldx	[%r16 + 0x0bf0], %r3
	.word 0xf80c2f3a  ! 1: LDUB_I	ldub	[%r16 + 0x0f3a], %r28
	.word 0xc6dc2e78  ! 1: LDXA_I	ldxa	[%r16, + 0x0e78] %asi, %r3
	.word 0xda941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r13
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc68c2a33  ! 1: LDUBA_I	lduba	[%r16, + 0x0a33] %asi, %r3
	.word 0xf4cc24c8  ! 1: LDSBA_I	ldsba	[%r16, + 0x04c8] %asi, %r26
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_986
	dec %r31
	.word 0x99343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r12
	.word 0xb83c250a  ! 1: XNOR_I	xnor 	%r16, 0x050a, %r28
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x863420dc  ! 1: SUBC_I	orn 	%r16, 0x00dc, %r3
        mov 0x90, %r31
thr3_loop_cnt_987:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc60c25b3  ! 1: LDUB_I	ldub	[%r16 + 0x05b3], %r3
	.word 0xe2cc204d  ! 1: LDSBA_I	ldsba	[%r16, + 0x004d] %asi, %r17
	.word 0xce84225c  ! 1: LDUWA_I	lduwa	[%r16, + 0x025c] %asi, %r7
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xc68c28c9  ! 1: LDUBA_I	lduba	[%r16, + 0x08c9] %asi, %r3
	.word 0xc64c245f  ! 1: LDSB_I	ldsb	[%r16 + 0x045f], %r3
	.word 0xc6942746  ! 1: LDUHA_I	lduha	[%r16, + 0x0746] %asi, %r3
	brnz %r31,thr3_loop_cnt_987
	dec %r31
	.word 0x904421d8  ! 1: ADDC_I	addc 	%r16, 0x01d8, %r8
        mov 0x32, %r31
thr3_loop_cnt_988:
	.word 0xc6042284  ! 1: LDUW_I	lduw	[%r16 + 0x0284], %r3
	.word 0xee0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r23
	.word 0xce5426a4  ! 1: LDSH_I	ldsh	[%r16 + 0x06a4], %r7
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc65c2160  ! 1: LDX_I	ldx	[%r16 + 0x0160], %r3
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	.word 0xc6cc2af1  ! 1: LDSBA_I	ldsba	[%r16, + 0x0af1] %asi, %r3
	.word 0xf6542196  ! 1: LDSH_I	ldsh	[%r16 + 0x0196], %r27
	.word 0xc6842cc4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0cc4] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6942c04  ! 1: LDUHA_I	lduha	[%r16, + 0x0c04] %asi, %r3
	.word 0xee140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r23
	brnz %r31,thr3_loop_cnt_988
	dec %r31
	.word 0xb0240002  ! 1: SUB_R	sub 	%r16, %r2, %r24
	.word 0xac142dab  ! 1: OR_I	or 	%r16, 0x0dab, %r22
        mov 0xc6, %r31
thr3_loop_cnt_989:
	.word 0xe8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r20
	.word 0xc6c42c84  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c84] %asi, %r3
	.word 0xc6dc20a0  ! 1: LDXA_I	ldxa	[%r16, + 0x00a0] %asi, %r3
	.word 0xc6042408  ! 1: LDUW_I	lduw	[%r16 + 0x0408], %r3
	.word 0xe80c2e9a  ! 1: LDUB_I	ldub	[%r16 + 0x0e9a], %r20
	.word 0xc6c42f00  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f00] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xccc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r6
	brnz %r31,thr3_loop_cnt_989
	dec %r31
	.word 0x8634247f  ! 1: SUBC_I	orn 	%r16, 0x047f, %r3
	.word 0xb21c0002  ! 1: XOR_R	xor 	%r16, %r2, %r25
	.word 0x8634276d  ! 1: ORN_I	orn 	%r16, 0x076d, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0x28, %r31
thr3_loop_cnt_990:
	.word 0xc654281c  ! 1: LDSH_I	ldsh	[%r16 + 0x081c], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r28
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd45c2db0  ! 1: LDX_I	ldx	[%r16 + 0x0db0], %r10
	.word 0xe40c29e3  ! 1: LDUB_I	ldub	[%r16 + 0x09e3], %r18
	.word 0xe6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r19
	.word 0xc6842388  ! 1: LDUWA_I	lduwa	[%r16, + 0x0388] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_990
	dec %r31
	.word 0x8c240002  ! 1: SUB_R	sub 	%r16, %r2, %r6
        mov 0x3c, %r31
thr3_loop_cnt_991:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc60c2bf1  ! 1: LDUB_I	ldub	[%r16 + 0x0bf1], %r3
	.word 0xecd42f06  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f06] %asi, %r22
	.word 0xe4dc2618  ! 1: LDXA_I	ldxa	[%r16, + 0x0618] %asi, %r18
	.word 0xc60424ac  ! 1: LDUW_I	lduw	[%r16 + 0x04ac], %r3
	.word 0xc64426a4  ! 1: LDSW_I	ldsw	[%r16 + 0x06a4], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xdc042b10  ! 1: LDUW_I	lduw	[%r16 + 0x0b10], %r14
	brnz %r31,thr3_loop_cnt_991
	dec %r31
	.word 0x98042728  ! 1: ADD_I	add 	%r16, 0x0728, %r12
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0x2a, %r31
thr3_loop_cnt_992:
	.word 0xc64c2716  ! 1: LDSB_I	ldsb	[%r16 + 0x0716], %r3
	.word 0xe6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r19
	.word 0xd8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r12
	.word 0xc6cc2cd4  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cd4] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6d42c74  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c74] %asi, %r3
	.word 0xc68c25b6  ! 1: LDUBA_I	lduba	[%r16, + 0x05b6] %asi, %r3
	.word 0xf2542d9e  ! 1: LDSH_I	ldsh	[%r16 + 0x0d9e], %r25
	.word 0xd48c2fd9  ! 1: LDUBA_I	lduba	[%r16, + 0x0fd9] %asi, %r10
	.word 0xc64c2106  ! 1: LDSB_I	ldsb	[%r16 + 0x0106], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_992
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x3f, %r31
thr3_loop_cnt_993:
	.word 0xc60c2fb2  ! 1: LDUB_I	ldub	[%r16 + 0x0fb2], %r3
	.word 0xea8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r21
	.word 0xeec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r23
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xdc0c25ac  ! 1: LDUB_I	ldub	[%r16 + 0x05ac], %r14
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xc6cc24ed  ! 1: LDSBA_I	ldsba	[%r16, + 0x04ed] %asi, %r3
	.word 0xd6c42bcc  ! 1: LDSWA_I	ldswa	[%r16, + 0x0bcc] %asi, %r11
	.word 0xc6d42856  ! 1: LDSHA_I	ldsha	[%r16, + 0x0856] %asi, %r3
	brnz %r31,thr3_loop_cnt_993
	dec %r31
        mov 0x54, %r31
thr3_loop_cnt_994:
	.word 0xf00c256f  ! 1: LDUB_I	ldub	[%r16 + 0x056f], %r24
	.word 0xd2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r9
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xde4428a8  ! 1: LDSW_I	ldsw	[%r16 + 0x08a8], %r15
	.word 0xd08425ac  ! 1: LDUWA_I	lduwa	[%r16, + 0x05ac] %asi, %r8
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_994
	dec %r31
	.word 0xa93c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r20
	.word 0xb2340002  ! 1: SUBC_R	orn 	%r16, %r2, %r25
	.word 0x86042587  ! 1: ADD_I	add 	%r16, 0x0587, %r3
        mov 0x3a, %r31
thr3_loop_cnt_995:
	.word 0xfa841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r29
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xdecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r15
	.word 0xd80426ec  ! 1: LDUW_I	lduw	[%r16 + 0x06ec], %r12
	.word 0xc6042738  ! 1: LDUW_I	lduw	[%r16 + 0x0738], %r3
	.word 0xe844231c  ! 1: LDSW_I	ldsw	[%r16 + 0x031c], %r20
	.word 0xd2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r9
	.word 0xeadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r21
	brnz %r31,thr3_loop_cnt_995
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x9b342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r13
        mov 0x0, %r31
thr3_loop_cnt_996:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xee540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r23
	.word 0xc60c2dd8  ! 1: LDUB_I	ldub	[%r16 + 0x0dd8], %r3
	.word 0xc65c26b0  ! 1: LDX_I	ldx	[%r16 + 0x06b0], %r3
	.word 0xf2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r25
	.word 0xd0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r8
	.word 0xdec42540  ! 1: LDSWA_I	ldswa	[%r16, + 0x0540] %asi, %r15
	.word 0xc6042fb4  ! 1: LDUW_I	lduw	[%r16 + 0x0fb4], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_996
	dec %r31
	.word 0xaf341002  ! 1: SRLX_R	srlx	%r16, %r2, %r23
	.word 0x8c042707  ! 1: ADD_I	add 	%r16, 0x0707, %r6
	.word 0x9b3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r13
	.word 0xb7343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r27
        mov 0x75, %r31
thr3_loop_cnt_997:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xce8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r7
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf8c42a30  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a30] %asi, %r28
	.word 0xcc442f8c  ! 1: LDSW_I	ldsw	[%r16 + 0x0f8c], %r6
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc64c2070  ! 1: LDSB_I	ldsb	[%r16 + 0x0070], %r3
	.word 0xf2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r25
	.word 0xfacc2cac  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cac] %asi, %r29
	.word 0xde8429dc  ! 1: LDUWA_I	lduwa	[%r16, + 0x09dc] %asi, %r15
	brnz %r31,thr3_loop_cnt_997
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0xa3, %r31
thr3_loop_cnt_998:
	.word 0xc64c290d  ! 1: LDSB_I	ldsb	[%r16 + 0x090d], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6c42918  ! 1: LDSWA_I	ldswa	[%r16, + 0x0918] %asi, %r3
	.word 0xcc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r6
	.word 0xce4c2f4e  ! 1: LDSB_I	ldsb	[%r16 + 0x0f4e], %r7
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r18
	.word 0xd8142920  ! 1: LDUH_I	lduh	[%r16 + 0x0920], %r12
	.word 0xe48424e0  ! 1: LDUWA_I	lduwa	[%r16, + 0x04e0] %asi, %r18
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	.word 0xc6142064  ! 1: LDUH_I	lduh	[%r16 + 0x0064], %r3
	brnz %r31,thr3_loop_cnt_998
	dec %r31
	.word 0xb12c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r24
	.word 0x9f3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r15
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x86342f01  ! 1: ORN_I	orn 	%r16, 0x0f01, %r3
        mov 0x88, %r31
thr3_loop_cnt_999:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd254287e  ! 1: LDSH_I	ldsh	[%r16 + 0x087e], %r9
	.word 0xea0c27a0  ! 1: LDUB_I	ldub	[%r16 + 0x07a0], %r21
	.word 0xe4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r18
	.word 0xc60c2be3  ! 1: LDUB_I	ldub	[%r16 + 0x0be3], %r3
	.word 0xd40c2e62  ! 1: LDUB_I	ldub	[%r16 + 0x0e62], %r10
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc604292c  ! 1: LDUW_I	lduw	[%r16 + 0x092c], %r3
	.word 0xc60c23b6  ! 1: LDUB_I	ldub	[%r16 + 0x03b6], %r3
	.word 0xd2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r9
	brnz %r31,thr3_loop_cnt_999
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0x4c, %r31
thr3_loop_cnt_1000:
	.word 0xfc4c2185  ! 1: LDSB_I	ldsb	[%r16 + 0x0185], %r30
	.word 0xc60c2f95  ! 1: LDUB_I	ldub	[%r16 + 0x0f95], %r3
	.word 0xd60426bc  ! 1: LDUW_I	lduw	[%r16 + 0x06bc], %r11
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6942fa6  ! 1: LDUHA_I	lduha	[%r16, + 0x0fa6] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	.word 0xc64c2671  ! 1: LDSB_I	ldsb	[%r16 + 0x0671], %r3
	.word 0xe8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r20
	brnz %r31,thr3_loop_cnt_1000
	dec %r31
	.word 0xb92c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r28
	.word 0x98340002  ! 1: SUBC_R	orn 	%r16, %r2, %r12
	.word 0x981c2e82  ! 1: XOR_I	xor 	%r16, 0x0e82, %r12
        mov 0x6, %r31
thr3_loop_cnt_1001:
	.word 0xc61428ec  ! 1: LDUH_I	lduh	[%r16 + 0x08ec], %r3
	.word 0xc60c258f  ! 1: LDUB_I	ldub	[%r16 + 0x058f], %r3
	.word 0xd2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r9
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6942f18  ! 1: LDUHA_I	lduha	[%r16, + 0x0f18] %asi, %r3
	.word 0xd2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r9
	.word 0xc60c20d9  ! 1: LDUB_I	ldub	[%r16 + 0x00d9], %r3
	.word 0xc6d42256  ! 1: LDSHA_I	ldsha	[%r16, + 0x0256] %asi, %r3
	brnz %r31,thr3_loop_cnt_1001
	dec %r31
	.word 0x922c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r9
	.word 0xa60c0002  ! 1: AND_R	and 	%r16, %r2, %r19
	.word 0x861c2b9c  ! 1: XOR_I	xor 	%r16, 0x0b9c, %r3
	.word 0x943c2d29  ! 1: XNOR_I	xnor 	%r16, 0x0d29, %r10
        mov 0x58, %r31
thr3_loop_cnt_1002:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc64c2803  ! 1: LDSB_I	ldsb	[%r16 + 0x0803], %r3
	.word 0xc68c21c7  ! 1: LDUBA_I	lduba	[%r16, + 0x01c7] %asi, %r3
	.word 0xd8cc2a3e  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a3e] %asi, %r12
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r27
	.word 0xc6842108  ! 1: LDUWA_I	lduwa	[%r16, + 0x0108] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1002
	dec %r31
	.word 0xb92c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r28
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x8634213b  ! 1: ORN_I	orn 	%r16, 0x013b, %r3
        mov 0x97, %r31
thr3_loop_cnt_1003:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xd054201a  ! 1: LDSH_I	ldsh	[%r16 + 0x001a], %r8
	.word 0xc6cc2e4a  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e4a] %asi, %r3
	.word 0xf4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r26
	.word 0xf0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r24
	.word 0xea0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r21
	.word 0xe40c2cdf  ! 1: LDUB_I	ldub	[%r16 + 0x0cdf], %r18
	.word 0xc644213c  ! 1: LDSW_I	ldsw	[%r16 + 0x013c], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1003
	dec %r31
	.word 0xba140002  ! 1: OR_R	or 	%r16, %r2, %r29
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0xa9, %r31
thr3_loop_cnt_1004:
	.word 0xf0d42fe2  ! 1: LDSHA_I	ldsha	[%r16, + 0x0fe2] %asi, %r24
	.word 0xf64423a0  ! 1: LDSW_I	ldsw	[%r16 + 0x03a0], %r27
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe60427d8  ! 1: LDUW_I	lduw	[%r16 + 0x07d8], %r19
	.word 0xc6cc236d  ! 1: LDSBA_I	ldsba	[%r16, + 0x036d] %asi, %r3
	.word 0xc614278c  ! 1: LDUH_I	lduh	[%r16 + 0x078c], %r3
	.word 0xc60c2790  ! 1: LDUB_I	ldub	[%r16 + 0x0790], %r3
	.word 0xf8d4223c  ! 1: LDSHA_I	ldsha	[%r16, + 0x023c] %asi, %r28
	brnz %r31,thr3_loop_cnt_1004
	dec %r31
	.word 0x862425cd  ! 1: SUB_I	sub 	%r16, 0x05cd, %r3
        mov 0x8b, %r31
thr3_loop_cnt_1005:
	.word 0xe2cc21e8  ! 1: LDSBA_I	ldsba	[%r16, + 0x01e8] %asi, %r17
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6042734  ! 1: LDUW_I	lduw	[%r16 + 0x0734], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xfc0c23f8  ! 1: LDUB_I	ldub	[%r16 + 0x03f8], %r30
	.word 0xd25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r9
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xda540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r13
	brnz %r31,thr3_loop_cnt_1005
	dec %r31
	.word 0x9c440002  ! 1: ADDC_R	addc 	%r16, %r2, %r14
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0xb41c26a7  ! 1: XOR_I	xor 	%r16, 0x06a7, %r26
        mov 0x98, %r31
thr3_loop_cnt_1006:
	.word 0xe6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r19
	.word 0xd0cc2b27  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b27] %asi, %r8
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd654243e  ! 1: LDSH_I	ldsh	[%r16 + 0x043e], %r11
	.word 0xe4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r18
	.word 0xd0cc2f16  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f16] %asi, %r8
	.word 0xf64422f0  ! 1: LDSW_I	ldsw	[%r16 + 0x02f0], %r27
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6c42ae4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ae4] %asi, %r3
	.word 0xda8c2ceb  ! 1: LDUBA_I	lduba	[%r16, + 0x0ceb] %asi, %r13
	.word 0xc6d42994  ! 1: LDSHA_I	ldsha	[%r16, + 0x0994] %asi, %r3
	brnz %r31,thr3_loop_cnt_1006
	dec %r31
	.word 0x99343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r12
	.word 0x862c2a72  ! 1: ANDN_I	andn 	%r16, 0x0a72, %r3
	.word 0x9e240002  ! 1: SUB_R	sub 	%r16, %r2, %r15
        mov 0x5, %r31
thr3_loop_cnt_1007:
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	.word 0xc64420fc  ! 1: LDSW_I	ldsw	[%r16 + 0x00fc], %r3
	.word 0xc68c2050  ! 1: LDUBA_I	lduba	[%r16, + 0x0050] %asi, %r3
	.word 0xc60426ec  ! 1: LDUW_I	lduw	[%r16 + 0x06ec], %r3
	.word 0xf8d42092  ! 1: LDSHA_I	ldsha	[%r16, + 0x0092] %asi, %r28
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1007
	dec %r31
	.word 0xb13c0002  ! 1: SRA_R	sra 	%r16, %r2, %r24
        mov 0x60, %r31
thr3_loop_cnt_1008:
	.word 0xd84c25f0  ! 1: LDSB_I	ldsb	[%r16 + 0x05f0], %r12
	.word 0xc6d4258a  ! 1: LDSHA_I	ldsha	[%r16, + 0x058a] %asi, %r3
	.word 0xf8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r28
	.word 0xc68c2a55  ! 1: LDUBA_I	lduba	[%r16, + 0x0a55] %asi, %r3
	.word 0xc68c28c1  ! 1: LDUBA_I	lduba	[%r16, + 0x08c1] %asi, %r3
	.word 0xde841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r15
	.word 0xc6cc291d  ! 1: LDSBA_I	ldsba	[%r16, + 0x091d] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe2542054  ! 1: LDSH_I	ldsh	[%r16 + 0x0054], %r17
	brnz %r31,thr3_loop_cnt_1008
	dec %r31
	.word 0x962c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r11
	.word 0x8e040002  ! 1: ADD_R	add 	%r16, %r2, %r7
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0x5a, %r31
thr3_loop_cnt_1009:
	.word 0xf4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r26
	.word 0xc65c2038  ! 1: LDX_I	ldx	[%r16 + 0x0038], %r3
	.word 0xc6d420a6  ! 1: LDSHA_I	ldsha	[%r16, + 0x00a6] %asi, %r3
	.word 0xf8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r28
	.word 0xc6c425f4  ! 1: LDSWA_I	ldswa	[%r16, + 0x05f4] %asi, %r3
	.word 0xfa8426bc  ! 1: LDUWA_I	lduwa	[%r16, + 0x06bc] %asi, %r29
	.word 0xdcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r14
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6c42fa4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0fa4] %asi, %r3
	.word 0xfc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r30
	.word 0xd244279c  ! 1: LDSW_I	ldsw	[%r16 + 0x079c], %r9
	.word 0xd45c2998  ! 1: LDX_I	ldx	[%r16 + 0x0998], %r10
	brnz %r31,thr3_loop_cnt_1009
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
        mov 0x5a, %r31
thr3_loop_cnt_1010:
	.word 0xf8942b10  ! 1: LDUHA_I	lduha	[%r16, + 0x0b10] %asi, %r28
	.word 0xfacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r29
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	.word 0xc65c2d38  ! 1: LDX_I	ldx	[%r16 + 0x0d38], %r3
	.word 0xc64c2145  ! 1: LDSB_I	ldsb	[%r16 + 0x0145], %r3
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xc6c42874  ! 1: LDSWA_I	ldswa	[%r16, + 0x0874] %asi, %r3
	.word 0xc64c280c  ! 1: LDSB_I	ldsb	[%r16 + 0x080c], %r3
	.word 0xf2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r25
	.word 0xc6042068  ! 1: LDUW_I	lduw	[%r16 + 0x0068], %r3
	.word 0xfc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r30
	brnz %r31,thr3_loop_cnt_1010
	dec %r31
	.word 0x90042621  ! 1: ADD_I	add 	%r16, 0x0621, %r8
	.word 0x9f3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r15
	.word 0x861c2ae6  ! 1: XOR_I	xor 	%r16, 0x0ae6, %r3
	.word 0xac242f50  ! 1: SUB_I	sub 	%r16, 0x0f50, %r22
        mov 0x53, %r31
thr3_loop_cnt_1011:
	.word 0xf8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r28
	.word 0xe21427e8  ! 1: LDUH_I	lduh	[%r16 + 0x07e8], %r17
	.word 0xee1421a2  ! 1: LDUH_I	lduh	[%r16 + 0x01a2], %r23
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe8442854  ! 1: LDSW_I	ldsw	[%r16 + 0x0854], %r20
	.word 0xe48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r18
	.word 0xfa4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r29
	.word 0xea8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r21
	brnz %r31,thr3_loop_cnt_1011
	dec %r31
        mov 0x3d, %r31
thr3_loop_cnt_1012:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd8942994  ! 1: LDUHA_I	lduha	[%r16, + 0x0994] %asi, %r12
	.word 0xc68c2e30  ! 1: LDUBA_I	lduba	[%r16, + 0x0e30] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf65423d2  ! 1: LDSH_I	ldsh	[%r16 + 0x03d2], %r27
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6542376  ! 1: LDSH_I	ldsh	[%r16 + 0x0376], %r3
	brnz %r31,thr3_loop_cnt_1012
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x863c2063  ! 1: XNOR_I	xnor 	%r16, 0x0063, %r3
	.word 0xb60c2d0a  ! 1: AND_I	and 	%r16, 0x0d0a, %r27
        mov 0x74, %r31
thr3_loop_cnt_1013:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc60c2ca8  ! 1: LDUB_I	ldub	[%r16 + 0x0ca8], %r3
	.word 0xc6442b70  ! 1: LDSW_I	ldsw	[%r16 + 0x0b70], %r3
	.word 0xc65c2f00  ! 1: LDX_I	ldx	[%r16 + 0x0f00], %r3
	.word 0xc6142764  ! 1: LDUH_I	lduh	[%r16 + 0x0764], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6542176  ! 1: LDSH_I	ldsh	[%r16 + 0x0176], %r3
	.word 0xd4dc2730  ! 1: LDXA_I	ldxa	[%r16, + 0x0730] %asi, %r10
	.word 0xc6142bfa  ! 1: LDUH_I	lduh	[%r16 + 0x0bfa], %r3
	brnz %r31,thr3_loop_cnt_1013
	dec %r31
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
        mov 0x31, %r31
thr3_loop_cnt_1014:
	.word 0xd6d42eee  ! 1: LDSHA_I	ldsha	[%r16, + 0x0eee] %asi, %r11
	.word 0xd08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r8
	.word 0xde142582  ! 1: LDUH_I	lduh	[%r16 + 0x0582], %r15
	.word 0xc6142d4c  ! 1: LDUH_I	lduh	[%r16 + 0x0d4c], %r3
	.word 0xd0c42b40  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b40] %asi, %r8
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xee140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r23
	.word 0xe84c2848  ! 1: LDSB_I	ldsb	[%r16 + 0x0848], %r20
	brnz %r31,thr3_loop_cnt_1014
	dec %r31
	.word 0x86342692  ! 1: SUBC_I	orn 	%r16, 0x0692, %r3
        mov 0x48, %r31
thr3_loop_cnt_1015:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r26
	.word 0xec5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r22
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6942108  ! 1: LDUHA_I	lduha	[%r16, + 0x0108] %asi, %r3
	.word 0xf0dc2738  ! 1: LDXA_I	ldxa	[%r16, + 0x0738] %asi, %r24
	.word 0xe2dc2808  ! 1: LDXA_I	ldxa	[%r16, + 0x0808] %asi, %r17
	brnz %r31,thr3_loop_cnt_1015
	dec %r31
	.word 0x9844206e  ! 1: ADDC_I	addc 	%r16, 0x006e, %r12
        mov 0x89, %r31
thr3_loop_cnt_1016:
	.word 0xc6dc2388  ! 1: LDXA_I	ldxa	[%r16, + 0x0388] %asi, %r3
	.word 0xc60c228e  ! 1: LDUB_I	ldub	[%r16 + 0x028e], %r3
	.word 0xdecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r15
	.word 0xdecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r15
	.word 0xc65c2528  ! 1: LDX_I	ldx	[%r16 + 0x0528], %r3
	.word 0xfc442a40  ! 1: LDSW_I	ldsw	[%r16 + 0x0a40], %r30
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1016
	dec %r31
        mov 0x33, %r31
thr3_loop_cnt_1017:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6842328  ! 1: LDUWA_I	lduwa	[%r16, + 0x0328] %asi, %r3
	.word 0xda0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r13
	.word 0xec5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r22
	.word 0xe4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r18
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc65c2490  ! 1: LDX_I	ldx	[%r16 + 0x0490], %r3
	brnz %r31,thr3_loop_cnt_1017
	dec %r31
	.word 0xb2240002  ! 1: SUB_R	sub 	%r16, %r2, %r25
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x98342877  ! 1: ORN_I	orn 	%r16, 0x0877, %r12
        mov 0x76, %r31
thr3_loop_cnt_1018:
	.word 0xf40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r26
	.word 0xc64c274d  ! 1: LDSB_I	ldsb	[%r16 + 0x074d], %r3
	.word 0xfa142a2a  ! 1: LDUH_I	lduh	[%r16 + 0x0a2a], %r29
	.word 0xf4c42848  ! 1: LDSWA_I	ldswa	[%r16, + 0x0848] %asi, %r26
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xea9426fc  ! 1: LDUHA_I	lduha	[%r16, + 0x06fc] %asi, %r21
	.word 0xc65c2008  ! 1: LDX_I	ldx	[%r16 + 0x0008], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xdedc20c0  ! 1: LDXA_I	ldxa	[%r16, + 0x00c0] %asi, %r15
	.word 0xcc542fc4  ! 1: LDSH_I	ldsh	[%r16 + 0x0fc4], %r6
	brnz %r31,thr3_loop_cnt_1018
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0xb1342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r24
        mov 0x89, %r31
thr3_loop_cnt_1019:
	.word 0xd6442b74  ! 1: LDSW_I	ldsw	[%r16 + 0x0b74], %r11
	.word 0xf25c2290  ! 1: LDX_I	ldx	[%r16 + 0x0290], %r25
	.word 0xe4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r18
	.word 0xea8c2f14  ! 1: LDUBA_I	lduba	[%r16, + 0x0f14] %asi, %r21
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xda5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r13
	.word 0xe2c4291c  ! 1: LDSWA_I	ldswa	[%r16, + 0x091c] %asi, %r17
	brnz %r31,thr3_loop_cnt_1019
	dec %r31
        mov 0x8d, %r31
thr3_loop_cnt_1020:
	.word 0xc60429bc  ! 1: LDUW_I	lduw	[%r16 + 0x09bc], %r3
	.word 0xc654261c  ! 1: LDSH_I	ldsh	[%r16 + 0x061c], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xfc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r30
	.word 0xc65c2940  ! 1: LDX_I	ldx	[%r16 + 0x0940], %r3
	.word 0xc6d42512  ! 1: LDSHA_I	ldsha	[%r16, + 0x0512] %asi, %r3
	.word 0xc6542ed2  ! 1: LDSH_I	ldsh	[%r16 + 0x0ed2], %r3
	.word 0xc61423f6  ! 1: LDUH_I	lduh	[%r16 + 0x03f6], %r3
	.word 0xe8442ec4  ! 1: LDSW_I	ldsw	[%r16 + 0x0ec4], %r20
	.word 0xf24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r25
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1020
	dec %r31
	.word 0xb8240002  ! 1: SUB_R	sub 	%r16, %r2, %r28
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x861c2d52  ! 1: XOR_I	xor 	%r16, 0x0d52, %r3
        mov 0xbd, %r31
thr3_loop_cnt_1021:
	.word 0xf80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r28
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xe45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r18
	.word 0xeec42754  ! 1: LDSWA_I	ldswa	[%r16, + 0x0754] %asi, %r23
	.word 0xf65c2588  ! 1: LDX_I	ldx	[%r16 + 0x0588], %r27
	.word 0xf0842d48  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d48] %asi, %r24
	.word 0xc68c26e6  ! 1: LDUBA_I	lduba	[%r16, + 0x06e6] %asi, %r3
	.word 0xecc42b40  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b40] %asi, %r22
	.word 0xf80c285c  ! 1: LDUB_I	ldub	[%r16 + 0x085c], %r28
	.word 0xc65c2000  ! 1: LDX_I	ldx	[%r16 + 0x0000], %r3
	.word 0xc61426be  ! 1: LDUH_I	lduh	[%r16 + 0x06be], %r3
	brnz %r31,thr3_loop_cnt_1021
	dec %r31
	.word 0x8e0c22a1  ! 1: AND_I	and 	%r16, 0x02a1, %r7
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0xa8, %r31
thr3_loop_cnt_1022:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r17
	.word 0xc6d42ba6  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ba6] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc61425e6  ! 1: LDUH_I	lduh	[%r16 + 0x05e6], %r3
	.word 0xd0d4257a  ! 1: LDSHA_I	ldsha	[%r16, + 0x057a] %asi, %r8
	.word 0xd28c2a3f  ! 1: LDUBA_I	lduba	[%r16, + 0x0a3f] %asi, %r9
	.word 0xfc442680  ! 1: LDSW_I	ldsw	[%r16 + 0x0680], %r30
	.word 0xd49425c4  ! 1: LDUHA_I	lduha	[%r16, + 0x05c4] %asi, %r10
	.word 0xe2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r17
	.word 0xe60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r19
	.word 0xd2d4276c  ! 1: LDSHA_I	ldsha	[%r16, + 0x076c] %asi, %r9
	brnz %r31,thr3_loop_cnt_1022
	dec %r31
	.word 0x8e0c246b  ! 1: AND_I	and 	%r16, 0x046b, %r7
	.word 0xaf3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r23
        mov 0x95, %r31
thr3_loop_cnt_1023:
	.word 0xdc842e64  ! 1: LDUWA_I	lduwa	[%r16, + 0x0e64] %asi, %r14
	.word 0xd8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r12
	.word 0xde1421aa  ! 1: LDUH_I	lduh	[%r16 + 0x01aa], %r15
	.word 0xce5c2780  ! 1: LDX_I	ldx	[%r16 + 0x0780], %r7
	.word 0xdacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r13
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xdcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r14
	brnz %r31,thr3_loop_cnt_1023
	dec %r31
        mov 0x8f, %r31
thr3_loop_cnt_1024:
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	.word 0xe6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r19
	.word 0xc6dc26f8  ! 1: LDXA_I	ldxa	[%r16, + 0x06f8] %asi, %r3
	.word 0xc64c2a3f  ! 1: LDSB_I	ldsb	[%r16 + 0x0a3f], %r3
	.word 0xcc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r6
	.word 0xeecc2432  ! 1: LDSBA_I	ldsba	[%r16, + 0x0432] %asi, %r23
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc694272e  ! 1: LDUHA_I	lduha	[%r16, + 0x072e] %asi, %r3
	.word 0xfc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r30
	.word 0xc6842a78  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a78] %asi, %r3
	brnz %r31,thr3_loop_cnt_1024
	dec %r31
        mov 0x2c, %r31
thr3_loop_cnt_1025:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xe64c221e  ! 1: LDSB_I	ldsb	[%r16 + 0x021e], %r19
	.word 0xe4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r18
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xfc942e8c  ! 1: LDUHA_I	lduha	[%r16, + 0x0e8c] %asi, %r30
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc65c2e00  ! 1: LDX_I	ldx	[%r16 + 0x0e00], %r3
	.word 0xc6942b48  ! 1: LDUHA_I	lduha	[%r16, + 0x0b48] %asi, %r3
	brnz %r31,thr3_loop_cnt_1025
	dec %r31
	.word 0xa83c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r20
	.word 0x861428da  ! 1: OR_I	or 	%r16, 0x08da, %r3
	.word 0x864426c2  ! 1: ADDC_I	addc 	%r16, 0x06c2, %r3
	.word 0x9c1c2cbd  ! 1: XOR_I	xor 	%r16, 0x0cbd, %r14
        mov 0x38, %r31
thr3_loop_cnt_1026:
	.word 0xf4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r26
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc60c2eb7  ! 1: LDUB_I	ldub	[%r16 + 0x0eb7], %r3
	.word 0xfadc2a70  ! 1: LDXA_I	ldxa	[%r16, + 0x0a70] %asi, %r29
	.word 0xec5c2c90  ! 1: LDX_I	ldx	[%r16 + 0x0c90], %r22
	.word 0xf2142140  ! 1: LDUH_I	lduh	[%r16 + 0x0140], %r25
	.word 0xf49425ee  ! 1: LDUHA_I	lduha	[%r16, + 0x05ee] %asi, %r26
	.word 0xe4542662  ! 1: LDSH_I	ldsh	[%r16 + 0x0662], %r18
	.word 0xf20c2484  ! 1: LDUB_I	ldub	[%r16 + 0x0484], %r25
	brnz %r31,thr3_loop_cnt_1026
	dec %r31
	.word 0x86442e7d  ! 1: ADDC_I	addc 	%r16, 0x0e7d, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x862c28cc  ! 1: ANDN_I	andn 	%r16, 0x08cc, %r3
	.word 0x862c2dc9  ! 1: ANDN_I	andn 	%r16, 0x0dc9, %r3
        mov 0x56, %r31
thr3_loop_cnt_1027:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd604267c  ! 1: LDUW_I	lduw	[%r16 + 0x067c], %r11
	.word 0xfcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r30
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xea040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r21
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xec5c2ae8  ! 1: LDX_I	ldx	[%r16 + 0x0ae8], %r22
	.word 0xc60c2dfe  ! 1: LDUB_I	ldub	[%r16 + 0x0dfe], %r3
	.word 0xc6842164  ! 1: LDUWA_I	lduwa	[%r16, + 0x0164] %asi, %r3
	brnz %r31,thr3_loop_cnt_1027
	dec %r31
        mov 0x55, %r31
thr3_loop_cnt_1028:
	.word 0xf4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r26
	.word 0xce8c220f  ! 1: LDUBA_I	lduba	[%r16, + 0x020f] %asi, %r7
	.word 0xea4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r21
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	.word 0xf6142798  ! 1: LDUH_I	lduh	[%r16 + 0x0798], %r27
	.word 0xee5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r23
	.word 0xd0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r8
	brnz %r31,thr3_loop_cnt_1028
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0x9f343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r15
	.word 0x862c2a49  ! 1: ANDN_I	andn 	%r16, 0x0a49, %r3
	.word 0x912c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r8
        mov 0xf, %r31
thr3_loop_cnt_1029:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc64c2fda  ! 1: LDSB_I	ldsb	[%r16 + 0x0fda], %r3
	.word 0xce941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r7
	.word 0xc6dc2cc8  ! 1: LDXA_I	ldxa	[%r16, + 0x0cc8] %asi, %r3
	.word 0xc60c2a9e  ! 1: LDUB_I	ldub	[%r16 + 0x0a9e], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe25c2488  ! 1: LDX_I	ldx	[%r16 + 0x0488], %r17
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d42f02  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f02] %asi, %r3
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	brnz %r31,thr3_loop_cnt_1029
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0x9e, %r31
thr3_loop_cnt_1030:
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	.word 0xe6d42c52  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c52] %asi, %r19
	.word 0xd4c42718  ! 1: LDSWA_I	ldswa	[%r16, + 0x0718] %asi, %r10
	.word 0xda4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r13
	.word 0xc65c2e18  ! 1: LDX_I	ldx	[%r16 + 0x0e18], %r3
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xde8422d0  ! 1: LDUWA_I	lduwa	[%r16, + 0x02d0] %asi, %r15
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	.word 0xd0d42020  ! 1: LDSHA_I	ldsha	[%r16, + 0x0020] %asi, %r8
	.word 0xe6142372  ! 1: LDUH_I	lduh	[%r16 + 0x0372], %r19
	.word 0xf0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r24
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1030
	dec %r31
        mov 0x73, %r31
thr3_loop_cnt_1031:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd65423ea  ! 1: LDSH_I	ldsh	[%r16 + 0x03ea], %r11
	.word 0xe48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r18
	.word 0xc69420d6  ! 1: LDUHA_I	lduha	[%r16, + 0x00d6] %asi, %r3
	.word 0xf84c20bb  ! 1: LDSB_I	ldsb	[%r16 + 0x00bb], %r28
	.word 0xc60424dc  ! 1: LDUW_I	lduw	[%r16 + 0x04dc], %r3
	.word 0xd45c2098  ! 1: LDX_I	ldx	[%r16 + 0x0098], %r10
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xe4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r18
	brnz %r31,thr3_loop_cnt_1031
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x862c28fa  ! 1: ANDN_I	andn 	%r16, 0x08fa, %r3
	.word 0x862429cf  ! 1: SUB_I	sub 	%r16, 0x09cf, %r3
        mov 0xbd, %r31
thr3_loop_cnt_1032:
	.word 0xc68c28ba  ! 1: LDUBA_I	lduba	[%r16, + 0x08ba] %asi, %r3
	.word 0xc6d42d30  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d30] %asi, %r3
	.word 0xc6442c0c  ! 1: LDSW_I	ldsw	[%r16 + 0x0c0c], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xfccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r30
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd60c22f9  ! 1: LDUB_I	ldub	[%r16 + 0x02f9], %r11
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r25
	brnz %r31,thr3_loop_cnt_1032
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0xbd3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r30
	.word 0xb6040002  ! 1: ADD_R	add 	%r16, %r2, %r27
	.word 0x8f2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r7
        mov 0x8a, %r31
thr3_loop_cnt_1033:
	.word 0xfcc423d8  ! 1: LDSWA_I	ldswa	[%r16, + 0x03d8] %asi, %r30
	.word 0xd2142f56  ! 1: LDUH_I	lduh	[%r16 + 0x0f56], %r9
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	.word 0xc6042a24  ! 1: LDUW_I	lduw	[%r16 + 0x0a24], %r3
	.word 0xe64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r19
	.word 0xc6cc2a65  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a65] %asi, %r3
	.word 0xd88c2675  ! 1: LDUBA_I	lduba	[%r16, + 0x0675] %asi, %r12
	.word 0xfc142628  ! 1: LDUH_I	lduh	[%r16 + 0x0628], %r30
	.word 0xc6142682  ! 1: LDUH_I	lduh	[%r16 + 0x0682], %r3
	.word 0xe2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r17
	.word 0xc60c225f  ! 1: LDUB_I	ldub	[%r16 + 0x025f], %r3
	brnz %r31,thr3_loop_cnt_1033
	dec %r31
        mov 0xc0, %r31
thr3_loop_cnt_1034:
	.word 0xc61426e6  ! 1: LDUH_I	lduh	[%r16 + 0x06e6], %r3
	.word 0xfa94258e  ! 1: LDUHA_I	lduha	[%r16, + 0x058e] %asi, %r29
	.word 0xe6542fbc  ! 1: LDSH_I	ldsh	[%r16 + 0x0fbc], %r19
	.word 0xe8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r20
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6842334  ! 1: LDUWA_I	lduwa	[%r16, + 0x0334] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6842c08  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c08] %asi, %r3
	.word 0xf4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r26
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc65428d6  ! 1: LDSH_I	ldsh	[%r16 + 0x08d6], %r3
	brnz %r31,thr3_loop_cnt_1034
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x86042f2e  ! 1: ADD_I	add 	%r16, 0x0f2e, %r3
        mov 0x1f, %r31
thr3_loop_cnt_1035:
	.word 0xd2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r9
	.word 0xf0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r24
	.word 0xd6842350  ! 1: LDUWA_I	lduwa	[%r16, + 0x0350] %asi, %r11
	.word 0xc6442190  ! 1: LDSW_I	ldsw	[%r16 + 0x0190], %r3
	.word 0xf8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r28
	.word 0xc60420bc  ! 1: LDUW_I	lduw	[%r16 + 0x00bc], %r3
	.word 0xc6dc24b8  ! 1: LDXA_I	ldxa	[%r16, + 0x04b8] %asi, %r3
	.word 0xd68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r11
	.word 0xd85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r12
	.word 0xcc942b92  ! 1: LDUHA_I	lduha	[%r16, + 0x0b92] %asi, %r6
	brnz %r31,thr3_loop_cnt_1035
	dec %r31
        mov 0x80, %r31
thr3_loop_cnt_1036:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf8c423b8  ! 1: LDSWA_I	ldswa	[%r16, + 0x03b8] %asi, %r28
	.word 0xf2d42d30  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d30] %asi, %r25
	.word 0xf4c42ef4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ef4] %asi, %r26
	.word 0xea8c2a21  ! 1: LDUBA_I	lduba	[%r16, + 0x0a21] %asi, %r21
	.word 0xfc5c25a0  ! 1: LDX_I	ldx	[%r16 + 0x05a0], %r30
	.word 0xf4d42a30  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a30] %asi, %r26
	.word 0xf88c2600  ! 1: LDUBA_I	lduba	[%r16, + 0x0600] %asi, %r28
	brnz %r31,thr3_loop_cnt_1036
	dec %r31
	.word 0xae3c2f0d  ! 1: XNOR_I	xnor 	%r16, 0x0f0d, %r23
        mov 0xb1, %r31
thr3_loop_cnt_1037:
	.word 0xc6c424ec  ! 1: LDSWA_I	ldswa	[%r16, + 0x04ec] %asi, %r3
	.word 0xf4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r26
	.word 0xfc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r30
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc68c2336  ! 1: LDUBA_I	lduba	[%r16, + 0x0336] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xdacc2816  ! 1: LDSBA_I	ldsba	[%r16, + 0x0816] %asi, %r13
	.word 0xd4542586  ! 1: LDSH_I	ldsh	[%r16 + 0x0586], %r10
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc68421e8  ! 1: LDUWA_I	lduwa	[%r16, + 0x01e8] %asi, %r3
	.word 0xf294291e  ! 1: LDUHA_I	lduha	[%r16, + 0x091e] %asi, %r25
	brnz %r31,thr3_loop_cnt_1037
	dec %r31
	.word 0x8e1c0002  ! 1: XOR_R	xor 	%r16, %r2, %r7
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0x7e, %r31
thr3_loop_cnt_1038:
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xf0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r24
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xda0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r13
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xdc8c24c4  ! 1: LDUBA_I	lduba	[%r16, + 0x04c4] %asi, %r14
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	.word 0xde84206c  ! 1: LDUWA_I	lduwa	[%r16, + 0x006c] %asi, %r15
	.word 0xc6142ab6  ! 1: LDUH_I	lduh	[%r16 + 0x0ab6], %r3
	.word 0xdc042bf4  ! 1: LDUW_I	lduw	[%r16 + 0x0bf4], %r14
	.word 0xec542820  ! 1: LDSH_I	ldsh	[%r16 + 0x0820], %r22
	brnz %r31,thr3_loop_cnt_1038
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0xa3342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r17
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0x4d, %r31
thr3_loop_cnt_1039:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc65c2dd8  ! 1: LDX_I	ldx	[%r16 + 0x0dd8], %r3
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	.word 0xc6dc2300  ! 1: LDXA_I	ldxa	[%r16, + 0x0300] %asi, %r3
	.word 0xe8042ec4  ! 1: LDUW_I	lduw	[%r16 + 0x0ec4], %r20
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe80c24b1  ! 1: LDUB_I	ldub	[%r16 + 0x04b1], %r20
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1039
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0x71, %r31
thr3_loop_cnt_1040:
	.word 0xc60c2bd6  ! 1: LDUB_I	ldub	[%r16 + 0x0bd6], %r3
	.word 0xf0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r24
	.word 0xf60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r27
	.word 0xd4542e9a  ! 1: LDSH_I	ldsh	[%r16 + 0x0e9a], %r10
	.word 0xf84c210b  ! 1: LDSB_I	ldsb	[%r16 + 0x010b], %r28
	.word 0xc6dc2b58  ! 1: LDXA_I	ldxa	[%r16, + 0x0b58] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r17
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1040
	dec %r31
	.word 0xb8442070  ! 1: ADDC_I	addc 	%r16, 0x0070, %r28
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0xc1, %r31
thr3_loop_cnt_1041:
	.word 0xd4dc2a08  ! 1: LDXA_I	ldxa	[%r16, + 0x0a08] %asi, %r10
	.word 0xe4142dc4  ! 1: LDUH_I	lduh	[%r16 + 0x0dc4], %r18
	.word 0xdecc26e7  ! 1: LDSBA_I	ldsba	[%r16, + 0x06e7] %asi, %r15
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc65c2c50  ! 1: LDX_I	ldx	[%r16 + 0x0c50], %r3
	.word 0xc6842b58  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b58] %asi, %r3
	.word 0xeec428b4  ! 1: LDSWA_I	ldswa	[%r16, + 0x08b4] %asi, %r23
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1041
	dec %r31
        mov 0x2b, %r31
thr3_loop_cnt_1042:
	.word 0xd00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r8
	.word 0xd2d42afa  ! 1: LDSHA_I	ldsha	[%r16, + 0x0afa] %asi, %r9
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xcc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r6
	.word 0xf0142990  ! 1: LDUH_I	lduh	[%r16 + 0x0990], %r24
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc68c2e7e  ! 1: LDUBA_I	lduba	[%r16, + 0x0e7e] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6542468  ! 1: LDSH_I	ldsh	[%r16 + 0x0468], %r3
	brnz %r31,thr3_loop_cnt_1042
	dec %r31
        mov 0xc7, %r31
thr3_loop_cnt_1043:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd88c2e9e  ! 1: LDUBA_I	lduba	[%r16, + 0x0e9e] %asi, %r12
	.word 0xd0c425a0  ! 1: LDSWA_I	ldswa	[%r16, + 0x05a0] %asi, %r8
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xde040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r15
	.word 0xc694282a  ! 1: LDUHA_I	lduha	[%r16, + 0x082a] %asi, %r3
	.word 0xfacc27fc  ! 1: LDSBA_I	ldsba	[%r16, + 0x07fc] %asi, %r29
	.word 0xfc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r30
	.word 0xc69428c2  ! 1: LDUHA_I	lduha	[%r16, + 0x08c2] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xea540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r21
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1043
	dec %r31
	.word 0x86442a15  ! 1: ADDC_I	addc 	%r16, 0x0a15, %r3
	.word 0xb0340002  ! 1: SUBC_R	orn 	%r16, %r2, %r24
        mov 0xf, %r31
thr3_loop_cnt_1044:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xec941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r22
	.word 0xccd42dec  ! 1: LDSHA_I	ldsha	[%r16, + 0x0dec] %asi, %r6
	.word 0xf0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r24
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r9
	.word 0xfc842ff4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ff4] %asi, %r30
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	brnz %r31,thr3_loop_cnt_1044
	dec %r31
	.word 0xac0c2940  ! 1: AND_I	and 	%r16, 0x0940, %r22
	.word 0xb72c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r27
        mov 0x4a, %r31
thr3_loop_cnt_1045:
	.word 0xc6442d6c  ! 1: LDSW_I	ldsw	[%r16 + 0x0d6c], %r3
	.word 0xce542f1a  ! 1: LDSH_I	ldsh	[%r16 + 0x0f1a], %r7
	.word 0xda5c2cb0  ! 1: LDX_I	ldx	[%r16 + 0x0cb0], %r13
	.word 0xf48c2505  ! 1: LDUBA_I	lduba	[%r16, + 0x0505] %asi, %r26
	.word 0xd0cc24a1  ! 1: LDSBA_I	ldsba	[%r16, + 0x04a1] %asi, %r8
	.word 0xcc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r6
	.word 0xf60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r27
	.word 0xc60424f0  ! 1: LDUW_I	lduw	[%r16 + 0x04f0], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xcedc2590  ! 1: LDXA_I	ldxa	[%r16, + 0x0590] %asi, %r7
	.word 0xde0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r15
	brnz %r31,thr3_loop_cnt_1045
	dec %r31
	.word 0x863c2bc3  ! 1: XNOR_I	xnor 	%r16, 0x0bc3, %r3
	.word 0xa63427f2  ! 1: ORN_I	orn 	%r16, 0x07f2, %r19
        mov 0x65, %r31
thr3_loop_cnt_1046:
	.word 0xe4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r18
	.word 0xc6cc2952  ! 1: LDSBA_I	ldsba	[%r16, + 0x0952] %asi, %r3
	.word 0xe6142a28  ! 1: LDUH_I	lduh	[%r16 + 0x0a28], %r19
	.word 0xcc5c2e58  ! 1: LDX_I	ldx	[%r16 + 0x0e58], %r6
	.word 0xe8942484  ! 1: LDUHA_I	lduha	[%r16, + 0x0484] %asi, %r20
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xd8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r12
	.word 0xc6dc2cb8  ! 1: LDXA_I	ldxa	[%r16, + 0x0cb8] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd4dc22f0  ! 1: LDXA_I	ldxa	[%r16, + 0x02f0] %asi, %r10
	.word 0xe64c2311  ! 1: LDSB_I	ldsb	[%r16 + 0x0311], %r19
	brnz %r31,thr3_loop_cnt_1046
	dec %r31
	.word 0xa82c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r20
	.word 0x861c2373  ! 1: XOR_I	xor 	%r16, 0x0373, %r3
	.word 0x8f340002  ! 1: SRL_R	srl 	%r16, %r2, %r7
        mov 0x0, %r31
thr3_loop_cnt_1047:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc64c25fc  ! 1: LDSB_I	ldsb	[%r16 + 0x05fc], %r3
	.word 0xd09429c6  ! 1: LDUHA_I	lduha	[%r16, + 0x09c6] %asi, %r8
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc65c2908  ! 1: LDX_I	ldx	[%r16 + 0x0908], %r3
	.word 0xc60c2eca  ! 1: LDUB_I	ldub	[%r16 + 0x0eca], %r3
	brnz %r31,thr3_loop_cnt_1047
	dec %r31
        mov 0xb3, %r31
thr3_loop_cnt_1048:
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xe4842cf4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0cf4] %asi, %r18
	.word 0xce5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r7
	.word 0xc694295a  ! 1: LDUHA_I	lduha	[%r16, + 0x095a] %asi, %r3
	.word 0xc68c2491  ! 1: LDUBA_I	lduba	[%r16, + 0x0491] %asi, %r3
	.word 0xf65c24c0  ! 1: LDX_I	ldx	[%r16 + 0x04c0], %r27
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	brnz %r31,thr3_loop_cnt_1048
	dec %r31
	.word 0xac1c0002  ! 1: XOR_R	xor 	%r16, %r2, %r22
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0x17, %r31
thr3_loop_cnt_1049:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc68c219e  ! 1: LDUBA_I	lduba	[%r16, + 0x019e] %asi, %r3
	.word 0xe8dc2848  ! 1: LDXA_I	ldxa	[%r16, + 0x0848] %asi, %r20
	.word 0xc6cc2ede  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ede] %asi, %r3
	.word 0xd65c2110  ! 1: LDX_I	ldx	[%r16 + 0x0110], %r11
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf05c2148  ! 1: LDX_I	ldx	[%r16 + 0x0148], %r24
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd4042c58  ! 1: LDUW_I	lduw	[%r16 + 0x0c58], %r10
	brnz %r31,thr3_loop_cnt_1049
	dec %r31
	.word 0x900c0002  ! 1: AND_R	and 	%r16, %r2, %r8
	.word 0x861c2d9c  ! 1: XOR_I	xor 	%r16, 0x0d9c, %r3
        mov 0x11, %r31
thr3_loop_cnt_1050:
	.word 0xe25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r17
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd84420d8  ! 1: LDSW_I	ldsw	[%r16 + 0x00d8], %r12
	.word 0xd28c2256  ! 1: LDUBA_I	lduba	[%r16, + 0x0256] %asi, %r9
	.word 0xd60427ec  ! 1: LDUW_I	lduw	[%r16 + 0x07ec], %r11
	.word 0xe8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r20
	.word 0xda540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r13
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc60c22a4  ! 1: LDUB_I	ldub	[%r16 + 0x02a4], %r3
	.word 0xea4c220f  ! 1: LDSB_I	ldsb	[%r16 + 0x020f], %r21
	.word 0xce042e38  ! 1: LDUW_I	lduw	[%r16 + 0x0e38], %r7
	brnz %r31,thr3_loop_cnt_1050
	dec %r31
        mov 0xb8, %r31
thr3_loop_cnt_1051:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xdcd42ca2  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ca2] %asi, %r14
	.word 0xee841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r23
	.word 0xc6dc2540  ! 1: LDXA_I	ldxa	[%r16, + 0x0540] %asi, %r3
	.word 0xf60c230e  ! 1: LDUB_I	ldub	[%r16 + 0x030e], %r27
	.word 0xf04c21ae  ! 1: LDSB_I	ldsb	[%r16 + 0x01ae], %r24
	brnz %r31,thr3_loop_cnt_1051
	dec %r31
	.word 0x862c2297  ! 1: ANDN_I	andn 	%r16, 0x0297, %r3
	.word 0x980c0002  ! 1: AND_R	and 	%r16, %r2, %r12
	.word 0x8d2c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r6
        mov 0x8c, %r31
thr3_loop_cnt_1052:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc60c2ef5  ! 1: LDUB_I	ldub	[%r16 + 0x0ef5], %r3
	.word 0xd69425a2  ! 1: LDUHA_I	lduha	[%r16, + 0x05a2] %asi, %r11
	.word 0xc694289c  ! 1: LDUHA_I	lduha	[%r16, + 0x089c] %asi, %r3
	.word 0xee0c2ce8  ! 1: LDUB_I	ldub	[%r16 + 0x0ce8], %r23
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xde941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r15
	.word 0xe8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r20
	.word 0xc64c2328  ! 1: LDSB_I	ldsb	[%r16 + 0x0328], %r3
	.word 0xc6442650  ! 1: LDSW_I	ldsw	[%r16 + 0x0650], %r3
	.word 0xc68c28e2  ! 1: LDUBA_I	lduba	[%r16, + 0x08e2] %asi, %r3
	brnz %r31,thr3_loop_cnt_1052
	dec %r31
	.word 0x9e04257f  ! 1: ADD_I	add 	%r16, 0x057f, %r15
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x96242358  ! 1: SUB_I	sub 	%r16, 0x0358, %r11
        mov 0x4b, %r31
thr3_loop_cnt_1053:
	.word 0xc6dc2c00  ! 1: LDXA_I	ldxa	[%r16, + 0x0c00] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc60c2640  ! 1: LDUB_I	ldub	[%r16 + 0x0640], %r3
	.word 0xd08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r8
	.word 0xec942f3c  ! 1: LDUHA_I	lduha	[%r16, + 0x0f3c] %asi, %r22
	.word 0xc60c2f97  ! 1: LDUB_I	ldub	[%r16 + 0x0f97], %r3
	.word 0xd25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r9
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc68c2fec  ! 1: LDUBA_I	lduba	[%r16, + 0x0fec] %asi, %r3
	brnz %r31,thr3_loop_cnt_1053
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x1f, %r31
thr3_loop_cnt_1054:
	.word 0xd2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r9
	.word 0xc6942f06  ! 1: LDUHA_I	lduha	[%r16, + 0x0f06] %asi, %r3
	.word 0xfcd42066  ! 1: LDSHA_I	ldsha	[%r16, + 0x0066] %asi, %r30
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xcc542c42  ! 1: LDSH_I	ldsh	[%r16 + 0x0c42], %r6
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xc64c2539  ! 1: LDSB_I	ldsb	[%r16 + 0x0539], %r3
	.word 0xdcdc2e60  ! 1: LDXA_I	ldxa	[%r16, + 0x0e60] %asi, %r14
	.word 0xd84c2886  ! 1: LDSB_I	ldsb	[%r16 + 0x0886], %r12
	brnz %r31,thr3_loop_cnt_1054
	dec %r31
        mov 0x4a, %r31
thr3_loop_cnt_1055:
	.word 0xf6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r27
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2c89  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c89] %asi, %r3
	.word 0xc68c2ab5  ! 1: LDUBA_I	lduba	[%r16, + 0x0ab5] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc69420be  ! 1: LDUHA_I	lduha	[%r16, + 0x00be] %asi, %r3
	.word 0xec0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r22
	.word 0xf0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r24
	.word 0xd2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r9
	brnz %r31,thr3_loop_cnt_1055
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x86442001  ! 1: ADDC_I	addc 	%r16, 0x0001, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0xa7, %r31
thr3_loop_cnt_1056:
	.word 0xc64c2b51  ! 1: LDSB_I	ldsb	[%r16 + 0x0b51], %r3
	.word 0xc64c21c3  ! 1: LDSB_I	ldsb	[%r16 + 0x01c3], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xde440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r15
	.word 0xcc5c2d68  ! 1: LDX_I	ldx	[%r16 + 0x0d68], %r6
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	.word 0xe28c27ee  ! 1: LDUBA_I	lduba	[%r16, + 0x07ee] %asi, %r17
	brnz %r31,thr3_loop_cnt_1056
	dec %r31
        mov 0x47, %r31
thr3_loop_cnt_1057:
	.word 0xe80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r20
	.word 0xe69422a8  ! 1: LDUHA_I	lduha	[%r16, + 0x02a8] %asi, %r19
	.word 0xdc042788  ! 1: LDUW_I	lduw	[%r16 + 0x0788], %r14
	.word 0xc65428e4  ! 1: LDSH_I	ldsh	[%r16 + 0x08e4], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6d422f8  ! 1: LDSHA_I	ldsha	[%r16, + 0x02f8] %asi, %r3
	.word 0xe2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r17
	.word 0xf8cc2e9e  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e9e] %asi, %r28
	.word 0xc60c2d70  ! 1: LDUB_I	ldub	[%r16 + 0x0d70], %r3
	.word 0xf2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r25
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc65c26d8  ! 1: LDX_I	ldx	[%r16 + 0x06d8], %r3
	brnz %r31,thr3_loop_cnt_1057
	dec %r31
	.word 0x9f2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r15
	.word 0xba342303  ! 1: ORN_I	orn 	%r16, 0x0303, %r29
	.word 0xae1c2283  ! 1: XOR_I	xor 	%r16, 0x0283, %r23
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x5f, %r31
thr3_loop_cnt_1058:
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xda94283e  ! 1: LDUHA_I	lduha	[%r16, + 0x083e] %asi, %r13
	.word 0xe88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r20
	.word 0xc614276a  ! 1: LDUH_I	lduh	[%r16 + 0x076a], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r19
	.word 0xf08c2af8  ! 1: LDUBA_I	lduba	[%r16, + 0x0af8] %asi, %r24
	.word 0xd0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r8
	brnz %r31,thr3_loop_cnt_1058
	dec %r31
        mov 0x58, %r31
thr3_loop_cnt_1059:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2835  ! 1: LDSBA_I	ldsba	[%r16, + 0x0835] %asi, %r3
	.word 0xf65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r27
	.word 0xf4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r26
	.word 0xc644246c  ! 1: LDSW_I	ldsw	[%r16 + 0x046c], %r3
	.word 0xf0cc2874  ! 1: LDSBA_I	ldsba	[%r16, + 0x0874] %asi, %r24
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6842c98  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c98] %asi, %r3
	.word 0xc694269e  ! 1: LDUHA_I	lduha	[%r16, + 0x069e] %asi, %r3
	.word 0xd05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r8
	.word 0xc65425a8  ! 1: LDSH_I	ldsh	[%r16 + 0x05a8], %r3
	brnz %r31,thr3_loop_cnt_1059
	dec %r31
	.word 0x973c1002  ! 1: SRAX_R	srax	%r16, %r2, %r11
	.word 0xb03c2473  ! 1: XNOR_I	xnor 	%r16, 0x0473, %r24
	.word 0x8f342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r7
	.word 0x8c240002  ! 1: SUB_R	sub 	%r16, %r2, %r6
        mov 0xb0, %r31
thr3_loop_cnt_1060:
	.word 0xee8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r23
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc61429fe  ! 1: LDUH_I	lduh	[%r16 + 0x09fe], %r3
	.word 0xc694201c  ! 1: LDUHA_I	lduha	[%r16, + 0x001c] %asi, %r3
	.word 0xc6c42424  ! 1: LDSWA_I	ldswa	[%r16, + 0x0424] %asi, %r3
	.word 0xf84c21e2  ! 1: LDSB_I	ldsb	[%r16 + 0x01e2], %r28
	.word 0xe84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r20
	.word 0xc68c2cdc  ! 1: LDUBA_I	lduba	[%r16, + 0x0cdc] %asi, %r3
	.word 0xc6d42284  ! 1: LDSHA_I	ldsha	[%r16, + 0x0284] %asi, %r3
	brnz %r31,thr3_loop_cnt_1060
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x7b, %r31
thr3_loop_cnt_1061:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc68c2b55  ! 1: LDUBA_I	lduba	[%r16, + 0x0b55] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd214265c  ! 1: LDUH_I	lduh	[%r16 + 0x065c], %r9
	.word 0xf48c2cef  ! 1: LDUBA_I	lduba	[%r16, + 0x0cef] %asi, %r26
	brnz %r31,thr3_loop_cnt_1061
	dec %r31
	.word 0x982420b4  ! 1: SUB_I	sub 	%r16, 0x00b4, %r12
        mov 0x70, %r31
thr3_loop_cnt_1062:
	.word 0xc6142fda  ! 1: LDUH_I	lduh	[%r16 + 0x0fda], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc68426b4  ! 1: LDUWA_I	lduwa	[%r16, + 0x06b4] %asi, %r3
	.word 0xec8c2b46  ! 1: LDUBA_I	lduba	[%r16, + 0x0b46] %asi, %r22
	.word 0xc6042f48  ! 1: LDUW_I	lduw	[%r16 + 0x0f48], %r3
	.word 0xc64c2234  ! 1: LDSB_I	ldsb	[%r16 + 0x0234], %r3
	.word 0xf8042298  ! 1: LDUW_I	lduw	[%r16 + 0x0298], %r28
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1062
	dec %r31
	.word 0x86242678  ! 1: SUB_I	sub 	%r16, 0x0678, %r3
	.word 0xa8342de4  ! 1: ORN_I	orn 	%r16, 0x0de4, %r20
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0x35, %r31
thr3_loop_cnt_1063:
	.word 0xc65c27a8  ! 1: LDX_I	ldx	[%r16 + 0x07a8], %r3
	.word 0xd04c29fe  ! 1: LDSB_I	ldsb	[%r16 + 0x09fe], %r8
	.word 0xe64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r19
	.word 0xc6dc22d8  ! 1: LDXA_I	ldxa	[%r16, + 0x02d8] %asi, %r3
	.word 0xda841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r13
	.word 0xc6142248  ! 1: LDUH_I	lduh	[%r16 + 0x0248], %r3
	.word 0xd8cc2ec7  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ec7] %asi, %r12
	.word 0xce542f24  ! 1: LDSH_I	ldsh	[%r16 + 0x0f24], %r7
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6d42cac  ! 1: LDSHA_I	ldsha	[%r16, + 0x0cac] %asi, %r3
	.word 0xc65c2160  ! 1: LDX_I	ldx	[%r16 + 0x0160], %r3
	brnz %r31,thr3_loop_cnt_1063
	dec %r31
        mov 0x5c, %r31
thr3_loop_cnt_1064:
	.word 0xd8442484  ! 1: LDSW_I	ldsw	[%r16 + 0x0484], %r12
	.word 0xce5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r7
	.word 0xd0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r8
	.word 0xce440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r7
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c42d34  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d34] %asi, %r3
	.word 0xdc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r14
	.word 0xe2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r17
	brnz %r31,thr3_loop_cnt_1064
	dec %r31
	.word 0x86342acb  ! 1: SUBC_I	orn 	%r16, 0x0acb, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x94, %r31
thr3_loop_cnt_1065:
	.word 0xc60429cc  ! 1: LDUW_I	lduw	[%r16 + 0x09cc], %r3
	.word 0xd2cc2774  ! 1: LDSBA_I	ldsba	[%r16, + 0x0774] %asi, %r9
	.word 0xdc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r14
	.word 0xc68c24a8  ! 1: LDUBA_I	lduba	[%r16, + 0x04a8] %asi, %r3
	.word 0xeacc246c  ! 1: LDSBA_I	ldsba	[%r16, + 0x046c] %asi, %r21
	.word 0xc6cc2bc9  ! 1: LDSBA_I	ldsba	[%r16, + 0x0bc9] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf60c22f6  ! 1: LDUB_I	ldub	[%r16 + 0x02f6], %r27
	.word 0xc6042a40  ! 1: LDUW_I	lduw	[%r16 + 0x0a40], %r3
	brnz %r31,thr3_loop_cnt_1065
	dec %r31
	.word 0xab2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r21
	.word 0xa7343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r19
        mov 0x55, %r31
thr3_loop_cnt_1066:
	.word 0xd08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r8
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xc60c2cfb  ! 1: LDUB_I	ldub	[%r16 + 0x0cfb], %r3
	.word 0xcc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r6
	.word 0xda4c2409  ! 1: LDSB_I	ldsb	[%r16 + 0x0409], %r13
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xcedc29f0  ! 1: LDXA_I	ldxa	[%r16, + 0x09f0] %asi, %r7
	.word 0xd2942bd4  ! 1: LDUHA_I	lduha	[%r16, + 0x0bd4] %asi, %r9
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1066
	dec %r31
	.word 0x9e1c25d6  ! 1: XOR_I	xor 	%r16, 0x05d6, %r15
	.word 0xba1c2e69  ! 1: XOR_I	xor 	%r16, 0x0e69, %r29
	.word 0x8f3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r7
	.word 0xa92c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r20
        mov 0x7e, %r31
thr3_loop_cnt_1067:
	.word 0xfa941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r29
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc61428b6  ! 1: LDUH_I	lduh	[%r16 + 0x08b6], %r3
	.word 0xc6cc22de  ! 1: LDSBA_I	ldsba	[%r16, + 0x02de] %asi, %r3
	.word 0xc6cc2c72  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c72] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd054289c  ! 1: LDSH_I	ldsh	[%r16 + 0x089c], %r8
	.word 0xc694292c  ! 1: LDUHA_I	lduha	[%r16, + 0x092c] %asi, %r3
	.word 0xe84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r20
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc65c2640  ! 1: LDX_I	ldx	[%r16 + 0x0640], %r3
	brnz %r31,thr3_loop_cnt_1067
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x9c1c2799  ! 1: XOR_I	xor 	%r16, 0x0799, %r14
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0x8f, %r31
thr3_loop_cnt_1068:
	.word 0xee8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r23
	.word 0xc6042e20  ! 1: LDUW_I	lduw	[%r16 + 0x0e20], %r3
	.word 0xc64c2e89  ! 1: LDSB_I	ldsb	[%r16 + 0x0e89], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xccdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r6
	.word 0xfa440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r29
	.word 0xfc942afa  ! 1: LDUHA_I	lduha	[%r16, + 0x0afa] %asi, %r30
	.word 0xea4423c8  ! 1: LDSW_I	ldsw	[%r16 + 0x03c8], %r21
	brnz %r31,thr3_loop_cnt_1068
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0xbc242591  ! 1: SUB_I	sub 	%r16, 0x0591, %r30
	.word 0x8e1c2b3d  ! 1: XOR_I	xor 	%r16, 0x0b3d, %r7
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0xf, %r31
thr3_loop_cnt_1069:
	.word 0xda4c2c96  ! 1: LDSB_I	ldsb	[%r16 + 0x0c96], %r13
	.word 0xc65c2060  ! 1: LDX_I	ldx	[%r16 + 0x0060], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xdcdc2640  ! 1: LDXA_I	ldxa	[%r16, + 0x0640] %asi, %r14
	.word 0xded42b22  ! 1: LDSHA_I	ldsha	[%r16, + 0x0b22] %asi, %r15
	.word 0xe8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r20
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r8
	brnz %r31,thr3_loop_cnt_1069
	dec %r31
        mov 0x1f, %r31
thr3_loop_cnt_1070:
	.word 0xe8c42a9c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a9c] %asi, %r20
	.word 0xc6dc23a0  ! 1: LDXA_I	ldxa	[%r16, + 0x03a0] %asi, %r3
	.word 0xcc5c2510  ! 1: LDX_I	ldx	[%r16 + 0x0510], %r6
	.word 0xf4d42c82  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c82] %asi, %r26
	.word 0xd4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r10
	.word 0xde941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r15
	.word 0xc6842548  ! 1: LDUWA_I	lduwa	[%r16, + 0x0548] %asi, %r3
	.word 0xda8c2a7e  ! 1: LDUBA_I	lduba	[%r16, + 0x0a7e] %asi, %r13
	brnz %r31,thr3_loop_cnt_1070
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x86342537  ! 1: ORN_I	orn 	%r16, 0x0537, %r3
        mov 0x5a, %r31
thr3_loop_cnt_1071:
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xec042a30  ! 1: LDUW_I	lduw	[%r16 + 0x0a30], %r22
	.word 0xc6cc20a5  ! 1: LDSBA_I	ldsba	[%r16, + 0x00a5] %asi, %r3
	.word 0xea042724  ! 1: LDUW_I	lduw	[%r16 + 0x0724], %r21
	.word 0xd6442c68  ! 1: LDSW_I	ldsw	[%r16 + 0x0c68], %r11
	.word 0xfa4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r29
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1071
	dec %r31
	.word 0xb62426ea  ! 1: SUB_I	sub 	%r16, 0x06ea, %r27
	.word 0x98442c2d  ! 1: ADDC_I	addc 	%r16, 0x0c2d, %r12
	.word 0xab2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r21
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
        mov 0x1, %r31
thr3_loop_cnt_1072:
	.word 0xc60427e0  ! 1: LDUW_I	lduw	[%r16 + 0x07e0], %r3
	.word 0xc6842bfc  ! 1: LDUWA_I	lduwa	[%r16, + 0x0bfc] %asi, %r3
	.word 0xc6142cb2  ! 1: LDUH_I	lduh	[%r16 + 0x0cb2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6d421f0  ! 1: LDSHA_I	ldsha	[%r16, + 0x01f0] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf8542088  ! 1: LDSH_I	ldsh	[%r16 + 0x0088], %r28
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc22d8  ! 1: LDSBA_I	ldsba	[%r16, + 0x02d8] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1072
	dec %r31
        mov 0x67, %r31
thr3_loop_cnt_1073:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c2c77  ! 1: LDSB_I	ldsb	[%r16 + 0x0c77], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xeedc2720  ! 1: LDXA_I	ldxa	[%r16, + 0x0720] %asi, %r23
	.word 0xe24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r17
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r27
	.word 0xfc842c18  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c18] %asi, %r30
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xcc0c293b  ! 1: LDUB_I	ldub	[%r16 + 0x093b], %r6
	.word 0xfac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r29
	brnz %r31,thr3_loop_cnt_1073
	dec %r31
        mov 0x61, %r31
thr3_loop_cnt_1074:
	.word 0xd0dc2988  ! 1: LDXA_I	ldxa	[%r16, + 0x0988] %asi, %r8
	.word 0xd65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r11
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6cc22f8  ! 1: LDSBA_I	ldsba	[%r16, + 0x02f8] %asi, %r3
	.word 0xc6cc2372  ! 1: LDSBA_I	ldsba	[%r16, + 0x0372] %asi, %r3
	.word 0xf8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r28
	.word 0xd68c2599  ! 1: LDUBA_I	lduba	[%r16, + 0x0599] %asi, %r11
	.word 0xe8c42b00  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b00] %asi, %r20
	brnz %r31,thr3_loop_cnt_1074
	dec %r31
	.word 0xb4340002  ! 1: SUBC_R	orn 	%r16, %r2, %r26
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0xb03c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r24
	.word 0x863c287c  ! 1: XNOR_I	xnor 	%r16, 0x087c, %r3
        mov 0x95, %r31
thr3_loop_cnt_1075:
	.word 0xd0d424b4  ! 1: LDSHA_I	ldsha	[%r16, + 0x04b4] %asi, %r8
	.word 0xe2d42cf2  ! 1: LDSHA_I	ldsha	[%r16, + 0x0cf2] %asi, %r17
	.word 0xc6d42540  ! 1: LDSHA_I	ldsha	[%r16, + 0x0540] %asi, %r3
	.word 0xde942864  ! 1: LDUHA_I	lduha	[%r16, + 0x0864] %asi, %r15
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe65428d8  ! 1: LDSH_I	ldsh	[%r16 + 0x08d8], %r19
	.word 0xc6cc2c38  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c38] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xc6cc2518  ! 1: LDSBA_I	ldsba	[%r16, + 0x0518] %asi, %r3
	.word 0xcc4c2dd3  ! 1: LDSB_I	ldsb	[%r16 + 0x0dd3], %r6
	.word 0xf8442d80  ! 1: LDSW_I	ldsw	[%r16 + 0x0d80], %r28
	brnz %r31,thr3_loop_cnt_1075
	dec %r31
	.word 0x98342092  ! 1: ORN_I	orn 	%r16, 0x0092, %r12
        mov 0x5a, %r31
thr3_loop_cnt_1076:
	.word 0xfacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r29
	.word 0xc604291c  ! 1: LDUW_I	lduw	[%r16 + 0x091c], %r3
	.word 0xe40c2a36  ! 1: LDUB_I	ldub	[%r16 + 0x0a36], %r18
	.word 0xe80c2693  ! 1: LDUB_I	ldub	[%r16 + 0x0693], %r20
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xecc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r22
	.word 0xce4421d8  ! 1: LDSW_I	ldsw	[%r16 + 0x01d8], %r7
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1076
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0xb0140002  ! 1: OR_R	or 	%r16, %r2, %r24
        mov 0xc, %r31
thr3_loop_cnt_1077:
	.word 0xc6042494  ! 1: LDUW_I	lduw	[%r16 + 0x0494], %r3
	.word 0xc60c245b  ! 1: LDUB_I	ldub	[%r16 + 0x045b], %r3
	.word 0xf0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r24
	.word 0xd45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r10
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	.word 0xe64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r19
	.word 0xea841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r21
	brnz %r31,thr3_loop_cnt_1077
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x26, %r31
thr3_loop_cnt_1078:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd854228a  ! 1: LDSH_I	ldsh	[%r16 + 0x028a], %r12
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc694245c  ! 1: LDUHA_I	lduha	[%r16, + 0x045c] %asi, %r3
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xc6c428dc  ! 1: LDSWA_I	ldswa	[%r16, + 0x08dc] %asi, %r3
	.word 0xc64c2c38  ! 1: LDSB_I	ldsb	[%r16 + 0x0c38], %r3
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xded423ba  ! 1: LDSHA_I	ldsha	[%r16, + 0x03ba] %asi, %r15
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1078
	dec %r31
        mov 0x3, %r31
thr3_loop_cnt_1079:
	.word 0xc6442a34  ! 1: LDSW_I	ldsw	[%r16 + 0x0a34], %r3
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xc6c42d8c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d8c] %asi, %r3
	.word 0xc60c280d  ! 1: LDUB_I	ldub	[%r16 + 0x080d], %r3
	.word 0xd05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r8
	.word 0xd40427dc  ! 1: LDUW_I	lduw	[%r16 + 0x07dc], %r10
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd8942bce  ! 1: LDUHA_I	lduha	[%r16, + 0x0bce] %asi, %r12
	.word 0xd0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r8
	.word 0xf08c2657  ! 1: LDUBA_I	lduba	[%r16, + 0x0657] %asi, %r24
	.word 0xc69429c6  ! 1: LDUHA_I	lduha	[%r16, + 0x09c6] %asi, %r3
	brnz %r31,thr3_loop_cnt_1079
	dec %r31
	.word 0xb3343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r25
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x90, %r31
thr3_loop_cnt_1080:
	.word 0xc68c20c0  ! 1: LDUBA_I	lduba	[%r16, + 0x00c0] %asi, %r3
	.word 0xc6142414  ! 1: LDUH_I	lduh	[%r16 + 0x0414], %r3
	.word 0xf60c2cbf  ! 1: LDUB_I	ldub	[%r16 + 0x0cbf], %r27
	.word 0xc6942d0e  ! 1: LDUHA_I	lduha	[%r16, + 0x0d0e] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	brnz %r31,thr3_loop_cnt_1080
	dec %r31
	.word 0xab342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r21
	.word 0x940c2b2e  ! 1: AND_I	and 	%r16, 0x0b2e, %r10
	.word 0x981c2838  ! 1: XOR_I	xor 	%r16, 0x0838, %r12
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0x66, %r31
thr3_loop_cnt_1081:
	.word 0xc65c22e8  ! 1: LDX_I	ldx	[%r16 + 0x02e8], %r3
	.word 0xeedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r23
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xc6842a18  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a18] %asi, %r3
	.word 0xd45c2488  ! 1: LDX_I	ldx	[%r16 + 0x0488], %r10
	.word 0xeadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r21
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	brnz %r31,thr3_loop_cnt_1081
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0xa9, %r31
thr3_loop_cnt_1082:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6142854  ! 1: LDUH_I	lduh	[%r16 + 0x0854], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xcc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r6
	.word 0xde0420bc  ! 1: LDUW_I	lduw	[%r16 + 0x00bc], %r15
	.word 0xc6c4230c  ! 1: LDSWA_I	ldswa	[%r16, + 0x030c] %asi, %r3
	.word 0xc6d42412  ! 1: LDSHA_I	ldsha	[%r16, + 0x0412] %asi, %r3
	.word 0xe2142c6e  ! 1: LDUH_I	lduh	[%r16 + 0x0c6e], %r17
	brnz %r31,thr3_loop_cnt_1082
	dec %r31
	.word 0x9e442c40  ! 1: ADDC_I	addc 	%r16, 0x0c40, %r15
	.word 0x863c2ae6  ! 1: XNOR_I	xnor 	%r16, 0x0ae6, %r3
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x27, %r31
thr3_loop_cnt_1083:
	.word 0xd2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r9
	.word 0xf20c2809  ! 1: LDUB_I	ldub	[%r16 + 0x0809], %r25
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc64c2150  ! 1: LDSB_I	ldsb	[%r16 + 0x0150], %r3
	.word 0xc61425c0  ! 1: LDUH_I	lduh	[%r16 + 0x05c0], %r3
	.word 0xe4c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r18
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6942808  ! 1: LDUHA_I	lduha	[%r16, + 0x0808] %asi, %r3
	brnz %r31,thr3_loop_cnt_1083
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x50, %r31
thr3_loop_cnt_1084:
	.word 0xf81420bc  ! 1: LDUH_I	lduh	[%r16 + 0x00bc], %r28
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2460  ! 1: LDXA_I	ldxa	[%r16, + 0x0460] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc65c2c30  ! 1: LDX_I	ldx	[%r16 + 0x0c30], %r3
	.word 0xdc5c2500  ! 1: LDX_I	ldx	[%r16 + 0x0500], %r14
	brnz %r31,thr3_loop_cnt_1084
	dec %r31
	.word 0xa33c1002  ! 1: SRAX_R	srax	%r16, %r2, %r17
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x8e240002  ! 1: SUB_R	sub 	%r16, %r2, %r7
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0x64, %r31
thr3_loop_cnt_1085:
	.word 0xc6942e60  ! 1: LDUHA_I	lduha	[%r16, + 0x0e60] %asi, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r19
	.word 0xc65c2178  ! 1: LDX_I	ldx	[%r16 + 0x0178], %r3
	.word 0xc6c42290  ! 1: LDSWA_I	ldswa	[%r16, + 0x0290] %asi, %r3
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xc65427c4  ! 1: LDSH_I	ldsh	[%r16 + 0x07c4], %r3
	.word 0xc65c22c8  ! 1: LDX_I	ldx	[%r16 + 0x02c8], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd80c2c9f  ! 1: LDUB_I	ldub	[%r16 + 0x0c9f], %r12
	.word 0xcc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r6
	.word 0xf8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r28
	brnz %r31,thr3_loop_cnt_1085
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0x78, %r31
thr3_loop_cnt_1086:
	.word 0xdac42b84  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b84] %asi, %r13
	.word 0xf4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r26
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xe2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r17
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r17
	.word 0xc6942084  ! 1: LDUHA_I	lduha	[%r16, + 0x0084] %asi, %r3
	.word 0xd854207c  ! 1: LDSH_I	ldsh	[%r16 + 0x007c], %r12
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6dc26d0  ! 1: LDXA_I	ldxa	[%r16, + 0x06d0] %asi, %r3
	brnz %r31,thr3_loop_cnt_1086
	dec %r31
	.word 0x9c3c263c  ! 1: XNOR_I	xnor 	%r16, 0x063c, %r14
	.word 0x861c2e8b  ! 1: XOR_I	xor 	%r16, 0x0e8b, %r3
	.word 0x9204290c  ! 1: ADD_I	add 	%r16, 0x090c, %r9
	.word 0x86042f34  ! 1: ADD_I	add 	%r16, 0x0f34, %r3
        mov 0x12, %r31
thr3_loop_cnt_1087:
	.word 0xd6cc2f1d  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f1d] %asi, %r11
	.word 0xd4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r10
	.word 0xe6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r19
	.word 0xd0c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r8
	.word 0xd2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r9
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc65c2e50  ! 1: LDX_I	ldx	[%r16 + 0x0e50], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xfc142546  ! 1: LDUH_I	lduh	[%r16 + 0x0546], %r30
	brnz %r31,thr3_loop_cnt_1087
	dec %r31
	.word 0x94340002  ! 1: ORN_R	orn 	%r16, %r2, %r10
        mov 0xba, %r31
thr3_loop_cnt_1088:
	.word 0xd44c2b46  ! 1: LDSB_I	ldsb	[%r16 + 0x0b46], %r10
	.word 0xc6d42182  ! 1: LDSHA_I	ldsha	[%r16, + 0x0182] %asi, %r3
	.word 0xfcdc2630  ! 1: LDXA_I	ldxa	[%r16, + 0x0630] %asi, %r30
	.word 0xf0cc24f7  ! 1: LDSBA_I	ldsba	[%r16, + 0x04f7] %asi, %r24
	.word 0xe45c2180  ! 1: LDX_I	ldx	[%r16 + 0x0180], %r18
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe4440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r18
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xf6842b04  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b04] %asi, %r27
	.word 0xfa5426ea  ! 1: LDSH_I	ldsh	[%r16 + 0x06ea], %r29
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	brnz %r31,thr3_loop_cnt_1088
	dec %r31
	.word 0x9034226c  ! 1: ORN_I	orn 	%r16, 0x026c, %r8
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x860420f0  ! 1: ADD_I	add 	%r16, 0x00f0, %r3
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0xa5, %r31
thr3_loop_cnt_1089:
	.word 0xe40420c0  ! 1: LDUW_I	lduw	[%r16 + 0x00c0], %r18
	.word 0xc6142032  ! 1: LDUH_I	lduh	[%r16 + 0x0032], %r3
	.word 0xda0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r13
	.word 0xc64c239a  ! 1: LDSB_I	ldsb	[%r16 + 0x039a], %r3
	.word 0xda5c2958  ! 1: LDX_I	ldx	[%r16 + 0x0958], %r13
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc64c2ec8  ! 1: LDSB_I	ldsb	[%r16 + 0x0ec8], %r3
	brnz %r31,thr3_loop_cnt_1089
	dec %r31
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x864427f6  ! 1: ADDC_I	addc 	%r16, 0x07f6, %r3
	.word 0xa60c0002  ! 1: AND_R	and 	%r16, %r2, %r19
        mov 0x2e, %r31
thr3_loop_cnt_1090:
	.word 0xc6cc2aa6  ! 1: LDSBA_I	ldsba	[%r16, + 0x0aa6] %asi, %r3
	.word 0xcc9423d4  ! 1: LDUHA_I	lduha	[%r16, + 0x03d4] %asi, %r6
	.word 0xe25429ac  ! 1: LDSH_I	ldsh	[%r16 + 0x09ac], %r17
	.word 0xd05420e6  ! 1: LDSH_I	ldsh	[%r16 + 0x00e6], %r8
	.word 0xe44427dc  ! 1: LDSW_I	ldsw	[%r16 + 0x07dc], %r18
	.word 0xcc8c28e4  ! 1: LDUBA_I	lduba	[%r16, + 0x08e4] %asi, %r6
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc68c2646  ! 1: LDUBA_I	lduba	[%r16, + 0x0646] %asi, %r3
	brnz %r31,thr3_loop_cnt_1090
	dec %r31
	.word 0xb00c0002  ! 1: AND_R	and 	%r16, %r2, %r24
	.word 0x863425cc  ! 1: ORN_I	orn 	%r16, 0x05cc, %r3
	.word 0xb0042047  ! 1: ADD_I	add 	%r16, 0x0047, %r24
        mov 0x4a, %r31
thr3_loop_cnt_1091:
	.word 0xcc142d74  ! 1: LDUH_I	lduh	[%r16 + 0x0d74], %r6
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd04426b0  ! 1: LDSW_I	ldsw	[%r16 + 0x06b0], %r8
	.word 0xc65c23c0  ! 1: LDX_I	ldx	[%r16 + 0x03c0], %r3
	.word 0xf00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r24
	.word 0xe6842330  ! 1: LDUWA_I	lduwa	[%r16, + 0x0330] %asi, %r19
	brnz %r31,thr3_loop_cnt_1091
	dec %r31
	.word 0xbb343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r29
	.word 0xb92c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r28
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0x8, %r31
thr3_loop_cnt_1092:
	.word 0xdecc2c12  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c12] %asi, %r15
	.word 0xd45c2ba8  ! 1: LDX_I	ldx	[%r16 + 0x0ba8], %r10
	.word 0xc69421b0  ! 1: LDUHA_I	lduha	[%r16, + 0x01b0] %asi, %r3
	.word 0xc60423d8  ! 1: LDUW_I	lduw	[%r16 + 0x03d8], %r3
	.word 0xc6942056  ! 1: LDUHA_I	lduha	[%r16, + 0x0056] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe20424ec  ! 1: LDUW_I	lduw	[%r16 + 0x04ec], %r17
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf40c2ac0  ! 1: LDUB_I	ldub	[%r16 + 0x0ac0], %r26
	.word 0xf414216c  ! 1: LDUH_I	lduh	[%r16 + 0x016c], %r26
	brnz %r31,thr3_loop_cnt_1092
	dec %r31
	.word 0x9d3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r14
	.word 0xae3c22d8  ! 1: XNOR_I	xnor 	%r16, 0x02d8, %r23
	.word 0x8c1c2813  ! 1: XOR_I	xor 	%r16, 0x0813, %r6
        mov 0x7b, %r31
thr3_loop_cnt_1093:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc2bca  ! 1: LDSBA_I	ldsba	[%r16, + 0x0bca] %asi, %r3
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xded420fc  ! 1: LDSHA_I	ldsha	[%r16, + 0x00fc] %asi, %r15
	.word 0xd6142efa  ! 1: LDUH_I	lduh	[%r16 + 0x0efa], %r11
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc60420d0  ! 1: LDUW_I	lduw	[%r16 + 0x00d0], %r3
	brnz %r31,thr3_loop_cnt_1093
	dec %r31
        mov 0x20, %r31
thr3_loop_cnt_1094:
	.word 0xce1426ac  ! 1: LDUH_I	lduh	[%r16 + 0x06ac], %r7
	.word 0xc6cc2041  ! 1: LDSBA_I	ldsba	[%r16, + 0x0041] %asi, %r3
	.word 0xc69420f6  ! 1: LDUHA_I	lduha	[%r16, + 0x00f6] %asi, %r3
	.word 0xc6c429d8  ! 1: LDSWA_I	ldswa	[%r16, + 0x09d8] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6542b20  ! 1: LDSH_I	ldsh	[%r16 + 0x0b20], %r3
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xdc1423c8  ! 1: LDUH_I	lduh	[%r16 + 0x03c8], %r14
	.word 0xec042034  ! 1: LDUW_I	lduw	[%r16 + 0x0034], %r22
	brnz %r31,thr3_loop_cnt_1094
	dec %r31
	.word 0xad343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r22
	.word 0x962c2726  ! 1: ANDN_I	andn 	%r16, 0x0726, %r11
        mov 0x77, %r31
thr3_loop_cnt_1095:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r10
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6442140  ! 1: LDSW_I	ldsw	[%r16 + 0x0140], %r3
	.word 0xc6cc294c  ! 1: LDSBA_I	ldsba	[%r16, + 0x094c] %asi, %r3
	.word 0xeadc2598  ! 1: LDXA_I	ldxa	[%r16, + 0x0598] %asi, %r21
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xce142146  ! 1: LDUH_I	lduh	[%r16 + 0x0146], %r7
	.word 0xd20c200d  ! 1: LDUB_I	ldub	[%r16 + 0x000d], %r9
	.word 0xe8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r20
	brnz %r31,thr3_loop_cnt_1095
	dec %r31
	.word 0xa5341002  ! 1: SRLX_R	srlx	%r16, %r2, %r18
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0xb3343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r25
        mov 0x4f, %r31
thr3_loop_cnt_1096:
	.word 0xc69424d4  ! 1: LDUHA_I	lduha	[%r16, + 0x04d4] %asi, %r3
	.word 0xfcd42598  ! 1: LDSHA_I	ldsha	[%r16, + 0x0598] %asi, %r30
	.word 0xce94223c  ! 1: LDUHA_I	lduha	[%r16, + 0x023c] %asi, %r7
	.word 0xde0c2c94  ! 1: LDUB_I	ldub	[%r16 + 0x0c94], %r15
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc65c2518  ! 1: LDX_I	ldx	[%r16 + 0x0518], %r3
	brnz %r31,thr3_loop_cnt_1096
	dec %r31
	.word 0x863421b4  ! 1: SUBC_I	orn 	%r16, 0x01b4, %r3
        mov 0x7, %r31
thr3_loop_cnt_1097:
	.word 0xd05422c6  ! 1: LDSH_I	ldsh	[%r16 + 0x02c6], %r8
	.word 0xd0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r8
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc64c249a  ! 1: LDSB_I	ldsb	[%r16 + 0x049a], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6842b00  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b00] %asi, %r3
	.word 0xc6942136  ! 1: LDUHA_I	lduha	[%r16, + 0x0136] %asi, %r3
	.word 0xc6cc2365  ! 1: LDSBA_I	ldsba	[%r16, + 0x0365] %asi, %r3
	.word 0xc68c2392  ! 1: LDUBA_I	lduba	[%r16, + 0x0392] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1097
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0x59, %r31
thr3_loop_cnt_1098:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r12
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xeecc2422  ! 1: LDSBA_I	ldsba	[%r16, + 0x0422] %asi, %r23
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	.word 0xc68c2b56  ! 1: LDUBA_I	lduba	[%r16, + 0x0b56] %asi, %r3
	.word 0xced425d4  ! 1: LDSHA_I	ldsha	[%r16, + 0x05d4] %asi, %r7
	brnz %r31,thr3_loop_cnt_1098
	dec %r31
	.word 0x86242831  ! 1: SUB_I	sub 	%r16, 0x0831, %r3
	.word 0x9c0c2908  ! 1: AND_I	and 	%r16, 0x0908, %r14
        mov 0xb5, %r31
thr3_loop_cnt_1099:
	.word 0xd2942d24  ! 1: LDUHA_I	lduha	[%r16, + 0x0d24] %asi, %r9
	.word 0xc6dc2ab8  ! 1: LDXA_I	ldxa	[%r16, + 0x0ab8] %asi, %r3
	.word 0xc6942cce  ! 1: LDUHA_I	lduha	[%r16, + 0x0cce] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r27
	.word 0xd40c2071  ! 1: LDUB_I	ldub	[%r16 + 0x0071], %r10
	.word 0xc64c2ae5  ! 1: LDSB_I	ldsb	[%r16 + 0x0ae5], %r3
	.word 0xce540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r7
	.word 0xda4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r13
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd65c2478  ! 1: LDX_I	ldx	[%r16 + 0x0478], %r11
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1099
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x9e042d56  ! 1: ADD_I	add 	%r16, 0x0d56, %r15
        mov 0x99, %r31
thr3_loop_cnt_1100:
	.word 0xf64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r27
	.word 0xd254245a  ! 1: LDSH_I	ldsh	[%r16 + 0x045a], %r9
	.word 0xc6442a80  ! 1: LDSW_I	ldsw	[%r16 + 0x0a80], %r3
	.word 0xcc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r6
	.word 0xc60c21f4  ! 1: LDUB_I	ldub	[%r16 + 0x01f4], %r3
	.word 0xf0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r24
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	.word 0xc6d42db4  ! 1: LDSHA_I	ldsha	[%r16, + 0x0db4] %asi, %r3
	.word 0xd4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r10
	brnz %r31,thr3_loop_cnt_1100
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x861c233b  ! 1: XOR_I	xor 	%r16, 0x033b, %r3
	.word 0x861c231b  ! 1: XOR_I	xor 	%r16, 0x031b, %r3
	.word 0x8d2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r6
        mov 0x19, %r31
thr3_loop_cnt_1101:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd65c2ff8  ! 1: LDX_I	ldx	[%r16 + 0x0ff8], %r11
	.word 0xf0442168  ! 1: LDSW_I	ldsw	[%r16 + 0x0168], %r24
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xde0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r15
	.word 0xd8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r12
	.word 0xdc942ce4  ! 1: LDUHA_I	lduha	[%r16, + 0x0ce4] %asi, %r14
	.word 0xfccc264a  ! 1: LDSBA_I	ldsba	[%r16, + 0x064a] %asi, %r30
	.word 0xe40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r18
	.word 0xf8942324  ! 1: LDUHA_I	lduha	[%r16, + 0x0324] %asi, %r28
	.word 0xf2042a40  ! 1: LDUW_I	lduw	[%r16 + 0x0a40], %r25
	brnz %r31,thr3_loop_cnt_1101
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0xf, %r31
thr3_loop_cnt_1102:
	.word 0xcc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r6
	.word 0xdcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r14
	.word 0xded42ebe  ! 1: LDSHA_I	ldsha	[%r16, + 0x0ebe] %asi, %r15
	.word 0xf65c25e0  ! 1: LDX_I	ldx	[%r16 + 0x05e0], %r27
	.word 0xf4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r26
	.word 0xce0c210d  ! 1: LDUB_I	ldub	[%r16 + 0x010d], %r7
	.word 0xc6542aa2  ! 1: LDSH_I	ldsh	[%r16 + 0x0aa2], %r3
	.word 0xce040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r7
	brnz %r31,thr3_loop_cnt_1102
	dec %r31
	.word 0x863c2784  ! 1: XNOR_I	xnor 	%r16, 0x0784, %r3
        mov 0x82, %r31
thr3_loop_cnt_1103:
	.word 0xd2442e84  ! 1: LDSW_I	ldsw	[%r16 + 0x0e84], %r9
	.word 0xd8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r12
	.word 0xe6442298  ! 1: LDSW_I	ldsw	[%r16 + 0x0298], %r19
	.word 0xd054217c  ! 1: LDSH_I	ldsh	[%r16 + 0x017c], %r8
	.word 0xe60421c0  ! 1: LDUW_I	lduw	[%r16 + 0x01c0], %r19
	.word 0xfc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r30
	.word 0xd8042480  ! 1: LDUW_I	lduw	[%r16 + 0x0480], %r12
	.word 0xe2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r17
	.word 0xfa5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r29
	.word 0xe25c2958  ! 1: LDX_I	ldx	[%r16 + 0x0958], %r17
	brnz %r31,thr3_loop_cnt_1103
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x9e4424d8  ! 1: ADDC_I	addc 	%r16, 0x04d8, %r15
        mov 0x1c, %r31
thr3_loop_cnt_1104:
	.word 0xe4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r18
	.word 0xd6542842  ! 1: LDSH_I	ldsh	[%r16 + 0x0842], %r11
	.word 0xc6442eb0  ! 1: LDSW_I	ldsw	[%r16 + 0x0eb0], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xdedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r15
	.word 0xf2542c7a  ! 1: LDSH_I	ldsh	[%r16 + 0x0c7a], %r25
	.word 0xfa4c280d  ! 1: LDSB_I	ldsb	[%r16 + 0x080d], %r29
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1104
	dec %r31
	.word 0xb2440002  ! 1: ADDC_R	addc 	%r16, %r2, %r25
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0xa8, %r31
thr3_loop_cnt_1105:
	.word 0xcc84223c  ! 1: LDUWA_I	lduwa	[%r16, + 0x023c] %asi, %r6
	.word 0xc61428a2  ! 1: LDUH_I	lduh	[%r16 + 0x08a2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r25
	.word 0xc6d42468  ! 1: LDSHA_I	ldsha	[%r16, + 0x0468] %asi, %r3
	.word 0xd0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r8
	.word 0xc6542f4e  ! 1: LDSH_I	ldsh	[%r16 + 0x0f4e], %r3
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xfadc2db0  ! 1: LDXA_I	ldxa	[%r16, + 0x0db0] %asi, %r29
	.word 0xc6042d8c  ! 1: LDUW_I	lduw	[%r16 + 0x0d8c], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1105
	dec %r31
	.word 0xb5340002  ! 1: SRL_R	srl 	%r16, %r2, %r26
        mov 0xa5, %r31
thr3_loop_cnt_1106:
	.word 0xc6842d20  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d20] %asi, %r3
	.word 0xd2dc2b20  ! 1: LDXA_I	ldxa	[%r16, + 0x0b20] %asi, %r9
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xf04c2586  ! 1: LDSB_I	ldsb	[%r16 + 0x0586], %r24
	.word 0xea040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r21
	.word 0xde140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r15
	.word 0xf0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r24
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1106
	dec %r31
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x861422eb  ! 1: OR_I	or 	%r16, 0x02eb, %r3
	.word 0x902c2001  ! 1: ANDN_I	andn 	%r16, 0x0001, %r8
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0x50, %r31
thr3_loop_cnt_1107:
	.word 0xc6c423a0  ! 1: LDSWA_I	ldswa	[%r16, + 0x03a0] %asi, %r3
	.word 0xf8dc2fd8  ! 1: LDXA_I	ldxa	[%r16, + 0x0fd8] %asi, %r28
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6042bf8  ! 1: LDUW_I	lduw	[%r16 + 0x0bf8], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd2942002  ! 1: LDUHA_I	lduha	[%r16, + 0x0002] %asi, %r9
	.word 0xda440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r13
	.word 0xc6cc200b  ! 1: LDSBA_I	ldsba	[%r16, + 0x000b] %asi, %r3
	brnz %r31,thr3_loop_cnt_1107
	dec %r31
	.word 0xb20c275b  ! 1: AND_I	and 	%r16, 0x075b, %r25
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x9e, %r31
thr3_loop_cnt_1108:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xd44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r10
	.word 0xcecc2949  ! 1: LDSBA_I	ldsba	[%r16, + 0x0949] %asi, %r7
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6942982  ! 1: LDUHA_I	lduha	[%r16, + 0x0982] %asi, %r3
	.word 0xf8dc2b70  ! 1: LDXA_I	ldxa	[%r16, + 0x0b70] %asi, %r28
	.word 0xc6cc22a6  ! 1: LDSBA_I	ldsba	[%r16, + 0x02a6] %asi, %r3
	.word 0xd08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r8
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc68c2a2f  ! 1: LDUBA_I	lduba	[%r16, + 0x0a2f] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1108
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x8634253a  ! 1: ORN_I	orn 	%r16, 0x053a, %r3
	.word 0x86142e2b  ! 1: OR_I	or 	%r16, 0x0e2b, %r3
        mov 0x6d, %r31
thr3_loop_cnt_1109:
	.word 0xc64c26cc  ! 1: LDSB_I	ldsb	[%r16 + 0x06cc], %r3
	.word 0xd2142e0a  ! 1: LDUH_I	lduh	[%r16 + 0x0e0a], %r9
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe4842628  ! 1: LDUWA_I	lduwa	[%r16, + 0x0628] %asi, %r18
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r28
	.word 0xded42c6e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c6e] %asi, %r15
	brnz %r31,thr3_loop_cnt_1109
	dec %r31
	.word 0x902c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r8
	.word 0x960c0002  ! 1: AND_R	and 	%r16, %r2, %r11
        mov 0x73, %r31
thr3_loop_cnt_1110:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xce0c25c6  ! 1: LDUB_I	ldub	[%r16 + 0x05c6], %r7
	.word 0xc6142c90  ! 1: LDUH_I	lduh	[%r16 + 0x0c90], %r3
	.word 0xf64c2579  ! 1: LDSB_I	ldsb	[%r16 + 0x0579], %r27
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r8
	.word 0xc6442550  ! 1: LDSW_I	ldsw	[%r16 + 0x0550], %r3
	.word 0xce8c2b1a  ! 1: LDUBA_I	lduba	[%r16, + 0x0b1a] %asi, %r7
	.word 0xc694231e  ! 1: LDUHA_I	lduha	[%r16, + 0x031e] %asi, %r3
	.word 0xc6142c34  ! 1: LDUH_I	lduh	[%r16 + 0x0c34], %r3
	.word 0xeac42e40  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e40] %asi, %r21
	.word 0xc68423cc  ! 1: LDUWA_I	lduwa	[%r16, + 0x03cc] %asi, %r3
	brnz %r31,thr3_loop_cnt_1110
	dec %r31
        mov 0xb5, %r31
thr3_loop_cnt_1111:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xfadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r29
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2f78  ! 1: LDXA_I	ldxa	[%r16, + 0x0f78] %asi, %r3
	.word 0xd44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r10
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xf0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r24
	.word 0xc6dc2508  ! 1: LDXA_I	ldxa	[%r16, + 0x0508] %asi, %r3
	.word 0xda140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r13
	.word 0xc6cc2141  ! 1: LDSBA_I	ldsba	[%r16, + 0x0141] %asi, %r3
	brnz %r31,thr3_loop_cnt_1111
	dec %r31
	.word 0xa4040002  ! 1: ADD_R	add 	%r16, %r2, %r18
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x993c1002  ! 1: SRAX_R	srax	%r16, %r2, %r12
        mov 0xc2, %r31
thr3_loop_cnt_1112:
	.word 0xc65420be  ! 1: LDSH_I	ldsh	[%r16 + 0x00be], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xea142eb0  ! 1: LDUH_I	lduh	[%r16 + 0x0eb0], %r21
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6d42dec  ! 1: LDSHA_I	ldsha	[%r16, + 0x0dec] %asi, %r3
	.word 0xfa841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r29
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1112
	dec %r31
        mov 0xae, %r31
thr3_loop_cnt_1113:
	.word 0xc6542f1e  ! 1: LDSH_I	ldsh	[%r16 + 0x0f1e], %r3
	.word 0xde842de0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0de0] %asi, %r15
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xce4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r7
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xf2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r25
	.word 0xd0842458  ! 1: LDUWA_I	lduwa	[%r16, + 0x0458] %asi, %r8
	.word 0xc6c42e14  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e14] %asi, %r3
	brnz %r31,thr3_loop_cnt_1113
	dec %r31
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x13, %r31
thr3_loop_cnt_1114:
	.word 0xc694205a  ! 1: LDUHA_I	lduha	[%r16, + 0x005a] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xcc842a0c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a0c] %asi, %r6
	.word 0xd6842ba0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0ba0] %asi, %r11
	.word 0xea1429b6  ! 1: LDUH_I	lduh	[%r16 + 0x09b6], %r21
	.word 0xeadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r21
	.word 0xc6842d04  ! 1: LDUWA_I	lduwa	[%r16, + 0x0d04] %asi, %r3
	brnz %r31,thr3_loop_cnt_1114
	dec %r31
	.word 0x9d2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r14
	.word 0xaa1c0002  ! 1: XOR_R	xor 	%r16, %r2, %r21
        mov 0x6c, %r31
thr3_loop_cnt_1115:
	.word 0xf4d42e86  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e86] %asi, %r26
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r27
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc64c2dfa  ! 1: LDSB_I	ldsb	[%r16 + 0x0dfa], %r3
	.word 0xc6942d98  ! 1: LDUHA_I	lduha	[%r16, + 0x0d98] %asi, %r3
	.word 0xc60c2cec  ! 1: LDUB_I	ldub	[%r16 + 0x0cec], %r3
	.word 0xf6442030  ! 1: LDSW_I	ldsw	[%r16 + 0x0030], %r27
	.word 0xe6942310  ! 1: LDUHA_I	lduha	[%r16, + 0x0310] %asi, %r19
	.word 0xf0142306  ! 1: LDUH_I	lduh	[%r16 + 0x0306], %r24
	.word 0xdc4c2dcf  ! 1: LDSB_I	ldsb	[%r16 + 0x0dcf], %r14
	brnz %r31,thr3_loop_cnt_1115
	dec %r31
        mov 0xa4, %r31
thr3_loop_cnt_1116:
	.word 0xc6942984  ! 1: LDUHA_I	lduha	[%r16, + 0x0984] %asi, %r3
	.word 0xc6dc22a0  ! 1: LDXA_I	ldxa	[%r16, + 0x02a0] %asi, %r3
	.word 0xf45c2cf0  ! 1: LDX_I	ldx	[%r16 + 0x0cf0], %r26
	.word 0xe85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r20
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xf45c2270  ! 1: LDX_I	ldx	[%r16 + 0x0270], %r26
	.word 0xf4cc2aec  ! 1: LDSBA_I	ldsba	[%r16, + 0x0aec] %asi, %r26
	.word 0xd4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r10
	brnz %r31,thr3_loop_cnt_1116
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0xa8140002  ! 1: OR_R	or 	%r16, %r2, %r20
        mov 0x36, %r31
thr3_loop_cnt_1117:
	.word 0xd6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r11
	.word 0xd6cc21c0  ! 1: LDSBA_I	ldsba	[%r16, + 0x01c0] %asi, %r11
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xd6d42d9c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d9c] %asi, %r11
	.word 0xd4c42114  ! 1: LDSWA_I	ldswa	[%r16, + 0x0114] %asi, %r10
	.word 0xc6842788  ! 1: LDUWA_I	lduwa	[%r16, + 0x0788] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc68c2e1c  ! 1: LDUBA_I	lduba	[%r16, + 0x0e1c] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1117
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0xa6040002  ! 1: ADD_R	add 	%r16, %r2, %r19
	.word 0x861c2562  ! 1: XOR_I	xor 	%r16, 0x0562, %r3
        mov 0x3c, %r31
thr3_loop_cnt_1118:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe45c2560  ! 1: LDX_I	ldx	[%r16 + 0x0560], %r18
	.word 0xe8dc2968  ! 1: LDXA_I	ldxa	[%r16, + 0x0968] %asi, %r20
	.word 0xcc842c9c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c9c] %asi, %r6
	.word 0xc60c2a79  ! 1: LDUB_I	ldub	[%r16 + 0x0a79], %r3
	.word 0xc60c2814  ! 1: LDUB_I	ldub	[%r16 + 0x0814], %r3
	.word 0xc60c2bd6  ! 1: LDUB_I	ldub	[%r16 + 0x0bd6], %r3
	.word 0xde140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r15
	brnz %r31,thr3_loop_cnt_1118
	dec %r31
        mov 0x41, %r31
thr3_loop_cnt_1119:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6d421c8  ! 1: LDSHA_I	ldsha	[%r16, + 0x01c8] %asi, %r3
	.word 0xc64c233a  ! 1: LDSB_I	ldsb	[%r16 + 0x033a], %r3
	.word 0xd80c27d3  ! 1: LDUB_I	ldub	[%r16 + 0x07d3], %r12
	.word 0xf84c23f6  ! 1: LDSB_I	ldsb	[%r16 + 0x03f6], %r28
	.word 0xc64c2ad0  ! 1: LDSB_I	ldsb	[%r16 + 0x0ad0], %r3
	.word 0xc6d427ba  ! 1: LDSHA_I	ldsha	[%r16, + 0x07ba] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf6542832  ! 1: LDSH_I	ldsh	[%r16 + 0x0832], %r27
	.word 0xd2942ff2  ! 1: LDUHA_I	lduha	[%r16, + 0x0ff2] %asi, %r9
	brnz %r31,thr3_loop_cnt_1119
	dec %r31
        mov 0x39, %r31
thr3_loop_cnt_1120:
	.word 0xc6842124  ! 1: LDUWA_I	lduwa	[%r16, + 0x0124] %asi, %r3
	.word 0xd494236a  ! 1: LDUHA_I	lduha	[%r16, + 0x036a] %asi, %r10
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1120
	dec %r31
	.word 0x86442584  ! 1: ADDC_I	addc 	%r16, 0x0584, %r3
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x56, %r31
thr3_loop_cnt_1121:
	.word 0xc6c4272c  ! 1: LDSWA_I	ldswa	[%r16, + 0x072c] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xe20c2e04  ! 1: LDUB_I	ldub	[%r16 + 0x0e04], %r17
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6cc2cec  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cec] %asi, %r3
	.word 0xfac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r29
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1121
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0x9f, %r31
thr3_loop_cnt_1122:
	.word 0xee941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r23
	.word 0xc68c2519  ! 1: LDUBA_I	lduba	[%r16, + 0x0519] %asi, %r3
	.word 0xdc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r14
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xdc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r14
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xee4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r23
	.word 0xf0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r24
	brnz %r31,thr3_loop_cnt_1122
	dec %r31
        mov 0x55, %r31
thr3_loop_cnt_1123:
	.word 0xe88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r20
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xfcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r30
	.word 0xc6842efc  ! 1: LDUWA_I	lduwa	[%r16, + 0x0efc] %asi, %r3
	.word 0xde5c25e0  ! 1: LDX_I	ldx	[%r16 + 0x05e0], %r15
	.word 0xc68c2bd9  ! 1: LDUBA_I	lduba	[%r16, + 0x0bd9] %asi, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xcc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r6
	.word 0xc60c2772  ! 1: LDUB_I	ldub	[%r16 + 0x0772], %r3
	brnz %r31,thr3_loop_cnt_1123
	dec %r31
	.word 0x963c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r11
        mov 0xb2, %r31
thr3_loop_cnt_1124:
	.word 0xc6042568  ! 1: LDUW_I	lduw	[%r16 + 0x0568], %r3
	.word 0xd0142914  ! 1: LDUH_I	lduh	[%r16 + 0x0914], %r8
	.word 0xd0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r8
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc65c2790  ! 1: LDX_I	ldx	[%r16 + 0x0790], %r3
	.word 0xd65c24e8  ! 1: LDX_I	ldx	[%r16 + 0x04e8], %r11
	.word 0xc6cc2226  ! 1: LDSBA_I	ldsba	[%r16, + 0x0226] %asi, %r3
	brnz %r31,thr3_loop_cnt_1124
	dec %r31
	.word 0x960420d1  ! 1: ADD_I	add 	%r16, 0x00d1, %r11
        mov 0x26, %r31
thr3_loop_cnt_1125:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xec0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r22
	.word 0xce442630  ! 1: LDSW_I	ldsw	[%r16 + 0x0630], %r7
	.word 0xda5c21b8  ! 1: LDX_I	ldx	[%r16 + 0x01b8], %r13
	.word 0xc6042448  ! 1: LDUW_I	lduw	[%r16 + 0x0448], %r3
	.word 0xcc042140  ! 1: LDUW_I	lduw	[%r16 + 0x0140], %r6
	.word 0xc614209e  ! 1: LDUH_I	lduh	[%r16 + 0x009e], %r3
	.word 0xc6542cee  ! 1: LDSH_I	ldsh	[%r16 + 0x0cee], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1125
	dec %r31
        mov 0x69, %r31
thr3_loop_cnt_1126:
	.word 0xe40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r18
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc64c2c32  ! 1: LDSB_I	ldsb	[%r16 + 0x0c32], %r3
	.word 0xd2d42a12  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a12] %asi, %r9
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd08c21bf  ! 1: LDUBA_I	lduba	[%r16, + 0x01bf] %asi, %r8
	.word 0xc68422e4  ! 1: LDUWA_I	lduwa	[%r16, + 0x02e4] %asi, %r3
	brnz %r31,thr3_loop_cnt_1126
	dec %r31
	.word 0x903428c1  ! 1: ORN_I	orn 	%r16, 0x08c1, %r8
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
        mov 0x9f, %r31
thr3_loop_cnt_1127:
	.word 0xced4253e  ! 1: LDSHA_I	ldsha	[%r16, + 0x053e] %asi, %r7
	.word 0xe80c217a  ! 1: LDUB_I	ldub	[%r16 + 0x017a], %r20
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xea8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r21
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd6cc23da  ! 1: LDSBA_I	ldsba	[%r16, + 0x03da] %asi, %r11
	.word 0xe8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r20
	.word 0xe8cc2643  ! 1: LDSBA_I	ldsba	[%r16, + 0x0643] %asi, %r20
	.word 0xf0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r24
	brnz %r31,thr3_loop_cnt_1127
	dec %r31
        mov 0xb9, %r31
thr3_loop_cnt_1128:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xfc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r30
	.word 0xc6c42c18  ! 1: LDSWA_I	ldswa	[%r16, + 0x0c18] %asi, %r3
	.word 0xc60c21b1  ! 1: LDUB_I	ldub	[%r16 + 0x01b1], %r3
	.word 0xdecc2c32  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c32] %asi, %r15
	.word 0xc6042a18  ! 1: LDUW_I	lduw	[%r16 + 0x0a18], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xce942d08  ! 1: LDUHA_I	lduha	[%r16, + 0x0d08] %asi, %r7
	.word 0xda4c23c2  ! 1: LDSB_I	ldsb	[%r16 + 0x03c2], %r13
	brnz %r31,thr3_loop_cnt_1128
	dec %r31
	.word 0x862c2a9d  ! 1: ANDN_I	andn 	%r16, 0x0a9d, %r3
	.word 0x90340002  ! 1: SUBC_R	orn 	%r16, %r2, %r8
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
        mov 0xa7, %r31
thr3_loop_cnt_1129:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6042ce4  ! 1: LDUW_I	lduw	[%r16 + 0x0ce4], %r3
	.word 0xc6cc2556  ! 1: LDSBA_I	ldsba	[%r16, + 0x0556] %asi, %r3
	.word 0xc6442c40  ! 1: LDSW_I	ldsw	[%r16 + 0x0c40], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc60c20f2  ! 1: LDUB_I	ldub	[%r16 + 0x00f2], %r3
	.word 0xfa0429e0  ! 1: LDUW_I	lduw	[%r16 + 0x09e0], %r29
	.word 0xd24c2047  ! 1: LDSB_I	ldsb	[%r16 + 0x0047], %r9
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xfcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r30
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1129
	dec %r31
        mov 0x73, %r31
thr3_loop_cnt_1130:
	.word 0xe2dc2c48  ! 1: LDXA_I	ldxa	[%r16, + 0x0c48] %asi, %r17
	.word 0xdcdc2d20  ! 1: LDXA_I	ldxa	[%r16, + 0x0d20] %asi, %r14
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6842a58  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a58] %asi, %r3
	.word 0xf4cc2ed1  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ed1] %asi, %r26
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xf6d42adc  ! 1: LDSHA_I	ldsha	[%r16, + 0x0adc] %asi, %r27
	.word 0xce8429d0  ! 1: LDUWA_I	lduwa	[%r16, + 0x09d0] %asi, %r7
	brnz %r31,thr3_loop_cnt_1130
	dec %r31
	.word 0x96342a0c  ! 1: ORN_I	orn 	%r16, 0x0a0c, %r11
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0xbd342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r30
        mov 0x40, %r31
thr3_loop_cnt_1131:
	.word 0xc61421ba  ! 1: LDUH_I	lduh	[%r16 + 0x01ba], %r3
	.word 0xc60c20b3  ! 1: LDUB_I	ldub	[%r16 + 0x00b3], %r3
	.word 0xc64c2faa  ! 1: LDSB_I	ldsb	[%r16 + 0x0faa], %r3
	.word 0xc68c255a  ! 1: LDUBA_I	lduba	[%r16, + 0x055a] %asi, %r3
	.word 0xee540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r23
	.word 0xc6cc2d1c  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d1c] %asi, %r3
	.word 0xd65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r11
	.word 0xec140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r22
	.word 0xc6c420dc  ! 1: LDSWA_I	ldswa	[%r16, + 0x00dc] %asi, %r3
	brnz %r31,thr3_loop_cnt_1131
	dec %r31
	.word 0xaa4426de  ! 1: ADDC_I	addc 	%r16, 0x06de, %r21
	.word 0x863429b9  ! 1: SUBC_I	orn 	%r16, 0x09b9, %r3
	.word 0xb8340002  ! 1: ORN_R	orn 	%r16, %r2, %r28
	.word 0x9234224e  ! 1: SUBC_I	orn 	%r16, 0x024e, %r9
        mov 0x85, %r31
thr3_loop_cnt_1132:
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xeadc2090  ! 1: LDXA_I	ldxa	[%r16, + 0x0090] %asi, %r21
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	.word 0xc60c2ea8  ! 1: LDUB_I	ldub	[%r16 + 0x0ea8], %r3
	.word 0xe88422e0  ! 1: LDUWA_I	lduwa	[%r16, + 0x02e0] %asi, %r20
	.word 0xc6142faa  ! 1: LDUH_I	lduh	[%r16 + 0x0faa], %r3
	.word 0xe6d429e0  ! 1: LDSHA_I	ldsha	[%r16, + 0x09e0] %asi, %r19
	.word 0xeacc26cd  ! 1: LDSBA_I	ldsba	[%r16, + 0x06cd] %asi, %r21
	.word 0xf00c2869  ! 1: LDUB_I	ldub	[%r16 + 0x0869], %r24
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xfa841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r29
	brnz %r31,thr3_loop_cnt_1132
	dec %r31
	.word 0xaa040002  ! 1: ADD_R	add 	%r16, %r2, %r21
	.word 0xb23c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r25
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x3b, %r31
thr3_loop_cnt_1133:
	.word 0xc6842bf4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0bf4] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xd21422a2  ! 1: LDUH_I	lduh	[%r16 + 0x02a2], %r9
	.word 0xc65c23d8  ! 1: LDX_I	ldx	[%r16 + 0x03d8], %r3
	.word 0xfc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r30
	.word 0xc60c22ee  ! 1: LDUB_I	ldub	[%r16 + 0x02ee], %r3
	.word 0xd8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r12
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xda9424da  ! 1: LDUHA_I	lduha	[%r16, + 0x04da] %asi, %r13
	brnz %r31,thr3_loop_cnt_1133
	dec %r31
	.word 0xa3343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r17
	.word 0xb43c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r26
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0xb4, %r31
thr3_loop_cnt_1134:
	.word 0xf4442ad4  ! 1: LDSW_I	ldsw	[%r16 + 0x0ad4], %r26
	.word 0xd64c2513  ! 1: LDSB_I	ldsb	[%r16 + 0x0513], %r11
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xda8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r13
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	.word 0xccdc2fc0  ! 1: LDXA_I	ldxa	[%r16, + 0x0fc0] %asi, %r6
	brnz %r31,thr3_loop_cnt_1134
	dec %r31
        mov 0x65, %r31
thr3_loop_cnt_1135:
	.word 0xf0442f70  ! 1: LDSW_I	ldsw	[%r16 + 0x0f70], %r24
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd8942f08  ! 1: LDUHA_I	lduha	[%r16, + 0x0f08] %asi, %r12
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe44c293a  ! 1: LDSB_I	ldsb	[%r16 + 0x093a], %r18
	.word 0xe6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r19
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1135
	dec %r31
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0x98340002  ! 1: SUBC_R	orn 	%r16, %r2, %r12
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0x30, %r31
thr3_loop_cnt_1136:
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xd65c2650  ! 1: LDX_I	ldx	[%r16 + 0x0650], %r11
	.word 0xc6dc2cd0  ! 1: LDXA_I	ldxa	[%r16, + 0x0cd0] %asi, %r3
	.word 0xec4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r22
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r12
	.word 0xc6142a02  ! 1: LDUH_I	lduh	[%r16 + 0x0a02], %r3
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xea142d7e  ! 1: LDUH_I	lduh	[%r16 + 0x0d7e], %r21
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc64c28b4  ! 1: LDSB_I	ldsb	[%r16 + 0x08b4], %r3
	brnz %r31,thr3_loop_cnt_1136
	dec %r31
        mov 0x80, %r31
thr3_loop_cnt_1137:
	.word 0xf45426ae  ! 1: LDSH_I	ldsh	[%r16 + 0x06ae], %r26
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xdcd421e4  ! 1: LDSHA_I	ldsha	[%r16, + 0x01e4] %asi, %r14
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r10
	.word 0xc6dc2540  ! 1: LDXA_I	ldxa	[%r16, + 0x0540] %asi, %r3
	.word 0xd00421f4  ! 1: LDUW_I	lduw	[%r16 + 0x01f4], %r8
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xfa4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r29
	brnz %r31,thr3_loop_cnt_1137
	dec %r31
	.word 0xb04427dd  ! 1: ADDC_I	addc 	%r16, 0x07dd, %r24
	.word 0x860c29ff  ! 1: AND_I	and 	%r16, 0x09ff, %r3
        mov 0xc4, %r31
thr3_loop_cnt_1138:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r9
	.word 0xe4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r18
	.word 0xfcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r30
	.word 0xd0442dd0  ! 1: LDSW_I	ldsw	[%r16 + 0x0dd0], %r8
	.word 0xdc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r14
	.word 0xf0142d8e  ! 1: LDUH_I	lduh	[%r16 + 0x0d8e], %r24
	.word 0xec4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r22
	brnz %r31,thr3_loop_cnt_1138
	dec %r31
	.word 0x8c1c2152  ! 1: XOR_I	xor 	%r16, 0x0152, %r6
	.word 0xac1c2822  ! 1: XOR_I	xor 	%r16, 0x0822, %r22
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0x18, %r31
thr3_loop_cnt_1139:
	.word 0xde5c26d0  ! 1: LDX_I	ldx	[%r16 + 0x06d0], %r15
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf2442150  ! 1: LDSW_I	ldsw	[%r16 + 0x0150], %r25
	.word 0xc60c2161  ! 1: LDUB_I	ldub	[%r16 + 0x0161], %r3
	.word 0xc654217a  ! 1: LDSH_I	ldsh	[%r16 + 0x017a], %r3
	.word 0xd2dc2bb8  ! 1: LDXA_I	ldxa	[%r16, + 0x0bb8] %asi, %r9
	.word 0xc6042cec  ! 1: LDUW_I	lduw	[%r16 + 0x0cec], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe2142b84  ! 1: LDUH_I	lduh	[%r16 + 0x0b84], %r17
	brnz %r31,thr3_loop_cnt_1139
	dec %r31
	.word 0xae342e63  ! 1: SUBC_I	orn 	%r16, 0x0e63, %r23
	.word 0xa43429fa  ! 1: SUBC_I	orn 	%r16, 0x09fa, %r18
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
        mov 0x7f, %r31
thr3_loop_cnt_1140:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xee040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r23
	.word 0xc604237c  ! 1: LDUW_I	lduw	[%r16 + 0x037c], %r3
	.word 0xf214212e  ! 1: LDUH_I	lduh	[%r16 + 0x012e], %r25
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc64427bc  ! 1: LDSW_I	ldsw	[%r16 + 0x07bc], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	brnz %r31,thr3_loop_cnt_1140
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x9a, %r31
thr3_loop_cnt_1141:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6c42d78  ! 1: LDSWA_I	ldswa	[%r16, + 0x0d78] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xc6cc26d5  ! 1: LDSBA_I	ldsba	[%r16, + 0x06d5] %asi, %r3
	.word 0xc6c429c8  ! 1: LDSWA_I	ldswa	[%r16, + 0x09c8] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xd2dc2e40  ! 1: LDXA_I	ldxa	[%r16, + 0x0e40] %asi, %r9
	.word 0xd44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r10
	brnz %r31,thr3_loop_cnt_1141
	dec %r31
	.word 0x912c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r8
        mov 0x1, %r31
thr3_loop_cnt_1142:
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xf6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r27
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xce04296c  ! 1: LDUW_I	lduw	[%r16 + 0x096c], %r7
	.word 0xce5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r7
	.word 0xc65429cc  ! 1: LDSH_I	ldsh	[%r16 + 0x09cc], %r3
	.word 0xee8424a0  ! 1: LDUWA_I	lduwa	[%r16, + 0x04a0] %asi, %r23
	brnz %r31,thr3_loop_cnt_1142
	dec %r31
	.word 0x98140002  ! 1: OR_R	or 	%r16, %r2, %r12
        mov 0x92, %r31
thr3_loop_cnt_1143:
	.word 0xd08c237e  ! 1: LDUBA_I	lduba	[%r16, + 0x037e] %asi, %r8
	.word 0xd6942ae2  ! 1: LDUHA_I	lduha	[%r16, + 0x0ae2] %asi, %r11
	.word 0xf8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r28
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r19
	.word 0xc6842c24  ! 1: LDUWA_I	lduwa	[%r16, + 0x0c24] %asi, %r3
	.word 0xd85c27a8  ! 1: LDX_I	ldx	[%r16 + 0x07a8], %r12
	.word 0xccc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r6
	.word 0xc6942c2c  ! 1: LDUHA_I	lduha	[%r16, + 0x0c2c] %asi, %r3
	.word 0xe8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r20
	brnz %r31,thr3_loop_cnt_1143
	dec %r31
	.word 0x86042425  ! 1: ADD_I	add 	%r16, 0x0425, %r3
	.word 0xa6340002  ! 1: ORN_R	orn 	%r16, %r2, %r19
	.word 0x860c2d8e  ! 1: AND_I	and 	%r16, 0x0d8e, %r3
        mov 0xb1, %r31
thr3_loop_cnt_1144:
	.word 0xee1420ea  ! 1: LDUH_I	lduh	[%r16 + 0x00ea], %r23
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xfc0429a0  ! 1: LDUW_I	lduw	[%r16 + 0x09a0], %r30
	.word 0xc64c259f  ! 1: LDSB_I	ldsb	[%r16 + 0x059f], %r3
	.word 0xc604287c  ! 1: LDUW_I	lduw	[%r16 + 0x087c], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xcedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r7
	.word 0xe8042da4  ! 1: LDUW_I	lduw	[%r16 + 0x0da4], %r20
	brnz %r31,thr3_loop_cnt_1144
	dec %r31
	.word 0xa4440002  ! 1: ADDC_R	addc 	%r16, %r2, %r18
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x862c258c  ! 1: ANDN_I	andn 	%r16, 0x058c, %r3
	.word 0xba1c2260  ! 1: XOR_I	xor 	%r16, 0x0260, %r29
        mov 0x43, %r31
thr3_loop_cnt_1145:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc604234c  ! 1: LDUW_I	lduw	[%r16 + 0x034c], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r12
	.word 0xd6d42446  ! 1: LDSHA_I	ldsha	[%r16, + 0x0446] %asi, %r11
	.word 0xc64c2a89  ! 1: LDSB_I	ldsb	[%r16 + 0x0a89], %r3
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xf84c29f3  ! 1: LDSB_I	ldsb	[%r16 + 0x09f3], %r28
	.word 0xd85c2250  ! 1: LDX_I	ldx	[%r16 + 0x0250], %r12
	brnz %r31,thr3_loop_cnt_1145
	dec %r31
	.word 0xb6340002  ! 1: ORN_R	orn 	%r16, %r2, %r27
	.word 0x860c2b17  ! 1: AND_I	and 	%r16, 0x0b17, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x4c, %r31
thr3_loop_cnt_1146:
	.word 0xd25c2950  ! 1: LDX_I	ldx	[%r16 + 0x0950], %r9
	.word 0xf44423b4  ! 1: LDSW_I	ldsw	[%r16 + 0x03b4], %r26
	.word 0xf0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r24
	.word 0xce941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r7
	.word 0xd8442b28  ! 1: LDSW_I	ldsw	[%r16 + 0x0b28], %r12
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6d42318  ! 1: LDSHA_I	ldsha	[%r16, + 0x0318] %asi, %r3
	.word 0xfacc2b07  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b07] %asi, %r29
	brnz %r31,thr3_loop_cnt_1146
	dec %r31
	.word 0x8e0c2856  ! 1: AND_I	and 	%r16, 0x0856, %r7
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x9c1c2b74  ! 1: XOR_I	xor 	%r16, 0x0b74, %r14
        mov 0x2b, %r31
thr3_loop_cnt_1147:
	.word 0xc6142e38  ! 1: LDUH_I	lduh	[%r16 + 0x0e38], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd054266a  ! 1: LDSH_I	ldsh	[%r16 + 0x066a], %r8
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xcc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r6
	.word 0xea941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r21
	.word 0xfa4c24d6  ! 1: LDSB_I	ldsb	[%r16 + 0x04d6], %r29
	.word 0xf89429f0  ! 1: LDUHA_I	lduha	[%r16, + 0x09f0] %asi, %r28
	.word 0xf2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r25
	brnz %r31,thr3_loop_cnt_1147
	dec %r31
	.word 0xba340002  ! 1: SUBC_R	orn 	%r16, %r2, %r29
        mov 0x9, %r31
thr3_loop_cnt_1148:
	.word 0xc684219c  ! 1: LDUWA_I	lduwa	[%r16, + 0x019c] %asi, %r3
	.word 0xd8442470  ! 1: LDSW_I	ldsw	[%r16 + 0x0470], %r12
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xfc8c24d0  ! 1: LDUBA_I	lduba	[%r16, + 0x04d0] %asi, %r30
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xda140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r13
	.word 0xc6dc27b8  ! 1: LDXA_I	ldxa	[%r16, + 0x07b8] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d42e22  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e22] %asi, %r3
	brnz %r31,thr3_loop_cnt_1148
	dec %r31
	.word 0x942c2ffe  ! 1: ANDN_I	andn 	%r16, 0x0ffe, %r10
	.word 0x873c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r3
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0xa0, %r31
thr3_loop_cnt_1149:
	.word 0xda040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r13
	.word 0xc6142d0a  ! 1: LDUH_I	lduh	[%r16 + 0x0d0a], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xde5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r15
	.word 0xe8542a98  ! 1: LDSH_I	ldsh	[%r16 + 0x0a98], %r20
	.word 0xc60c24ca  ! 1: LDUB_I	ldub	[%r16 + 0x04ca], %r3
	.word 0xde442a58  ! 1: LDSW_I	ldsw	[%r16 + 0x0a58], %r15
	.word 0xc60c2b89  ! 1: LDUB_I	ldub	[%r16 + 0x0b89], %r3
	.word 0xd8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r12
	.word 0xda5c2580  ! 1: LDX_I	ldx	[%r16 + 0x0580], %r13
	.word 0xe49428e4  ! 1: LDUHA_I	lduha	[%r16, + 0x08e4] %asi, %r18
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1149
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x9e142e42  ! 1: OR_I	or 	%r16, 0x0e42, %r15
        mov 0x75, %r31
thr3_loop_cnt_1150:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xdc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r14
	.word 0xc64c2c80  ! 1: LDSB_I	ldsb	[%r16 + 0x0c80], %r3
	.word 0xd8c42e64  ! 1: LDSWA_I	ldswa	[%r16, + 0x0e64] %asi, %r12
	.word 0xc6942790  ! 1: LDUHA_I	lduha	[%r16, + 0x0790] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc69421aa  ! 1: LDUHA_I	lduha	[%r16, + 0x01aa] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6c42ba0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ba0] %asi, %r3
	brnz %r31,thr3_loop_cnt_1150
	dec %r31
	.word 0xac3c2695  ! 1: XNOR_I	xnor 	%r16, 0x0695, %r22
	.word 0xa6340002  ! 1: ORN_R	orn 	%r16, %r2, %r19
        mov 0xb9, %r31
thr3_loop_cnt_1151:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xd0942a48  ! 1: LDUHA_I	lduha	[%r16, + 0x0a48] %asi, %r8
	.word 0xd4942988  ! 1: LDUHA_I	lduha	[%r16, + 0x0988] %asi, %r10
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xce4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r7
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xfa842204  ! 1: LDUWA_I	lduwa	[%r16, + 0x0204] %asi, %r29
	.word 0xc69421de  ! 1: LDUHA_I	lduha	[%r16, + 0x01de] %asi, %r3
	brnz %r31,thr3_loop_cnt_1151
	dec %r31
	.word 0x8634232c  ! 1: SUBC_I	orn 	%r16, 0x032c, %r3
	.word 0xb5341002  ! 1: SRLX_R	srlx	%r16, %r2, %r26
        mov 0x63, %r31
thr3_loop_cnt_1152:
	.word 0xd24421d8  ! 1: LDSW_I	ldsw	[%r16 + 0x01d8], %r9
	.word 0xf0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r24
	.word 0xc64427e4  ! 1: LDSW_I	ldsw	[%r16 + 0x07e4], %r3
	.word 0xd6842b48  ! 1: LDUWA_I	lduwa	[%r16, + 0x0b48] %asi, %r11
	.word 0xc64c2536  ! 1: LDSB_I	ldsb	[%r16 + 0x0536], %r3
	.word 0xf6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r27
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r28
	.word 0xd4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r10
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xdad420ee  ! 1: LDSHA_I	ldsha	[%r16, + 0x00ee] %asi, %r13
	.word 0xf60c2de9  ! 1: LDUB_I	ldub	[%r16 + 0x0de9], %r27
	brnz %r31,thr3_loop_cnt_1152
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x992c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r12
        mov 0x18, %r31
thr3_loop_cnt_1153:
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xdadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r13
	.word 0xee5c2be0  ! 1: LDX_I	ldx	[%r16 + 0x0be0], %r23
	.word 0xc69425ba  ! 1: LDUHA_I	lduha	[%r16, + 0x05ba] %asi, %r3
	.word 0xdc9423b2  ! 1: LDUHA_I	lduha	[%r16, + 0x03b2] %asi, %r14
	.word 0xc6cc2678  ! 1: LDSBA_I	ldsba	[%r16, + 0x0678] %asi, %r3
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	brnz %r31,thr3_loop_cnt_1153
	dec %r31
	.word 0x92040002  ! 1: ADD_R	add 	%r16, %r2, %r9
	.word 0x86142a49  ! 1: OR_I	or 	%r16, 0x0a49, %r3
	.word 0x9e1c0002  ! 1: XOR_R	xor 	%r16, %r2, %r15
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
        mov 0x31, %r31
thr3_loop_cnt_1154:
	.word 0xc69421dc  ! 1: LDUHA_I	lduha	[%r16, + 0x01dc] %asi, %r3
	.word 0xce042ec0  ! 1: LDUW_I	lduw	[%r16 + 0x0ec0], %r7
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xf8cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r28
	.word 0xc6842bf0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0bf0] %asi, %r3
	.word 0xc6c42f94  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f94] %asi, %r3
	.word 0xc6dc2da0  ! 1: LDXA_I	ldxa	[%r16, + 0x0da0] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xdc442fd8  ! 1: LDSW_I	ldsw	[%r16 + 0x0fd8], %r14
	.word 0xe80c2faa  ! 1: LDUB_I	ldub	[%r16 + 0x0faa], %r20
	.word 0xd8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r12
	brnz %r31,thr3_loop_cnt_1154
	dec %r31
	.word 0x863422ae  ! 1: SUBC_I	orn 	%r16, 0x02ae, %r3
        mov 0x85, %r31
thr3_loop_cnt_1155:
	.word 0xc60c274e  ! 1: LDUB_I	ldub	[%r16 + 0x074e], %r3
	.word 0xc6d42570  ! 1: LDSHA_I	ldsha	[%r16, + 0x0570] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r18
	.word 0xc65c2b40  ! 1: LDX_I	ldx	[%r16 + 0x0b40], %r3
	.word 0xfc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r30
	.word 0xeacc282f  ! 1: LDSBA_I	ldsba	[%r16, + 0x082f] %asi, %r21
	.word 0xd2cc2cad  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cad] %asi, %r9
	.word 0xc6d42144  ! 1: LDSHA_I	ldsha	[%r16, + 0x0144] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1155
	dec %r31
        mov 0xb4, %r31
thr3_loop_cnt_1156:
	.word 0xc65c2af8  ! 1: LDX_I	ldx	[%r16 + 0x0af8], %r3
	.word 0xf44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r26
	.word 0xee5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r23
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd0442f24  ! 1: LDSW_I	ldsw	[%r16 + 0x0f24], %r8
	.word 0xc6042a5c  ! 1: LDUW_I	lduw	[%r16 + 0x0a5c], %r3
	.word 0xec140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r22
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1156
	dec %r31
	.word 0xb52c0002  ! 1: SLL_R	sll 	%r16, %r2, %r26
        mov 0x69, %r31
thr3_loop_cnt_1157:
	.word 0xfa841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r29
	.word 0xc6842130  ! 1: LDUWA_I	lduwa	[%r16, + 0x0130] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r27
	.word 0xf2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r25
	.word 0xee540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r23
	.word 0xf00c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r24
	.word 0xeedc26a0  ! 1: LDXA_I	ldxa	[%r16, + 0x06a0] %asi, %r23
	.word 0xd69426d2  ! 1: LDUHA_I	lduha	[%r16, + 0x06d2] %asi, %r11
	.word 0xd2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r9
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xc6c42a14  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a14] %asi, %r3
	brnz %r31,thr3_loop_cnt_1157
	dec %r31
	.word 0xb00424ca  ! 1: ADD_I	add 	%r16, 0x04ca, %r24
	.word 0x8c3423ba  ! 1: ORN_I	orn 	%r16, 0x03ba, %r6
	.word 0x863c280a  ! 1: XNOR_I	xnor 	%r16, 0x080a, %r3
        mov 0x1c, %r31
thr3_loop_cnt_1158:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xdc0c2487  ! 1: LDUB_I	ldub	[%r16 + 0x0487], %r14
	.word 0xdc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r14
	.word 0xc6542e52  ! 1: LDSH_I	ldsh	[%r16 + 0x0e52], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6442808  ! 1: LDSW_I	ldsw	[%r16 + 0x0808], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xe4542556  ! 1: LDSH_I	ldsh	[%r16 + 0x0556], %r18
	brnz %r31,thr3_loop_cnt_1158
	dec %r31
	.word 0x9f3c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r15
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x9a2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r13
	.word 0xb32c0002  ! 1: SLL_R	sll 	%r16, %r2, %r25
        mov 0x9d, %r31
thr3_loop_cnt_1159:
	.word 0xc64c2bad  ! 1: LDSB_I	ldsb	[%r16 + 0x0bad], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r8
	.word 0xea5c2908  ! 1: LDX_I	ldx	[%r16 + 0x0908], %r21
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe844218c  ! 1: LDSW_I	ldsw	[%r16 + 0x018c], %r20
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xe4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r18
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2258  ! 1: LDXA_I	ldxa	[%r16, + 0x0258] %asi, %r3
	brnz %r31,thr3_loop_cnt_1159
	dec %r31
	.word 0x86342958  ! 1: ORN_I	orn 	%r16, 0x0958, %r3
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
        mov 0x85, %r31
thr3_loop_cnt_1160:
	.word 0xe6d427c4  ! 1: LDSHA_I	ldsha	[%r16, + 0x07c4] %asi, %r19
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xe8542348  ! 1: LDSH_I	ldsh	[%r16 + 0x0348], %r20
	.word 0xc6942b90  ! 1: LDUHA_I	lduha	[%r16, + 0x0b90] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1160
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x933c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r9
	.word 0xb83c259d  ! 1: XNOR_I	xnor 	%r16, 0x059d, %r28
        mov 0xa3, %r31
thr3_loop_cnt_1161:
	.word 0xe6142208  ! 1: LDUH_I	lduh	[%r16 + 0x0208], %r19
	.word 0xfcd42c5c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c5c] %asi, %r30
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r25
	.word 0xc61422c8  ! 1: LDUH_I	lduh	[%r16 + 0x02c8], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xfcdc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r30
	.word 0xc60429c4  ! 1: LDUW_I	lduw	[%r16 + 0x09c4], %r3
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	brnz %r31,thr3_loop_cnt_1161
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x86442067  ! 1: ADDC_I	addc 	%r16, 0x0067, %r3
        mov 0x7e, %r31
thr3_loop_cnt_1162:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xee5c2558  ! 1: LDX_I	ldx	[%r16 + 0x0558], %r23
	.word 0xd2c42fd0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0fd0] %asi, %r9
	.word 0xc68c2ce3  ! 1: LDUBA_I	lduba	[%r16, + 0x0ce3] %asi, %r3
	.word 0xc6dc2e00  ! 1: LDXA_I	ldxa	[%r16, + 0x0e00] %asi, %r3
	.word 0xd0d42d34  ! 1: LDSHA_I	ldsha	[%r16, + 0x0d34] %asi, %r8
	.word 0xfc4c234d  ! 1: LDSB_I	ldsb	[%r16 + 0x034d], %r30
	.word 0xcc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r6
	.word 0xf8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r28
	.word 0xf0942ef4  ! 1: LDUHA_I	lduha	[%r16, + 0x0ef4] %asi, %r24
	brnz %r31,thr3_loop_cnt_1162
	dec %r31
	.word 0xa32c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r17
	.word 0xac340002  ! 1: SUBC_R	orn 	%r16, %r2, %r22
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x920c29c0  ! 1: AND_I	and 	%r16, 0x09c0, %r9
        mov 0x3, %r31
thr3_loop_cnt_1163:
	.word 0xd8842a00  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a00] %asi, %r12
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xfc0422fc  ! 1: LDUW_I	lduw	[%r16 + 0x02fc], %r30
	.word 0xded41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r15
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6c42a14  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a14] %asi, %r3
	.word 0xe4442c8c  ! 1: LDSW_I	ldsw	[%r16 + 0x0c8c], %r18
	.word 0xce5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r7
	.word 0xf8842bb0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0bb0] %asi, %r28
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	.word 0xd45c2de8  ! 1: LDX_I	ldx	[%r16 + 0x0de8], %r10
	brnz %r31,thr3_loop_cnt_1163
	dec %r31
	.word 0xba142cba  ! 1: OR_I	or 	%r16, 0x0cba, %r29
	.word 0x9e040002  ! 1: ADD_R	add 	%r16, %r2, %r15
	.word 0x86242162  ! 1: SUB_I	sub 	%r16, 0x0162, %r3
        mov 0x11, %r31
thr3_loop_cnt_1164:
	.word 0xc64c24a7  ! 1: LDSB_I	ldsb	[%r16 + 0x04a7], %r3
	.word 0xc60c2614  ! 1: LDUB_I	ldub	[%r16 + 0x0614], %r3
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	.word 0xc6942d4c  ! 1: LDUHA_I	lduha	[%r16, + 0x0d4c] %asi, %r3
	.word 0xe2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r17
	.word 0xd6142330  ! 1: LDUH_I	lduh	[%r16 + 0x0330], %r11
	.word 0xf4d42686  ! 1: LDSHA_I	ldsha	[%r16, + 0x0686] %asi, %r26
	.word 0xf0540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r24
	brnz %r31,thr3_loop_cnt_1164
	dec %r31
	.word 0x86042d33  ! 1: ADD_I	add 	%r16, 0x0d33, %r3
        mov 0x81, %r31
thr3_loop_cnt_1165:
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	.word 0xd6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r11
	.word 0xc60c2138  ! 1: LDUB_I	ldub	[%r16 + 0x0138], %r3
	.word 0xc68c2061  ! 1: LDUBA_I	lduba	[%r16, + 0x0061] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d420e2  ! 1: LDSHA_I	ldsha	[%r16, + 0x00e2] %asi, %r3
	.word 0xd84c2bdc  ! 1: LDSB_I	ldsb	[%r16 + 0x0bdc], %r12
	.word 0xc6442420  ! 1: LDSW_I	ldsw	[%r16 + 0x0420], %r3
	.word 0xc68c2848  ! 1: LDUBA_I	lduba	[%r16, + 0x0848] %asi, %r3
	brnz %r31,thr3_loop_cnt_1165
	dec %r31
	.word 0x861c2053  ! 1: XOR_I	xor 	%r16, 0x0053, %r3
        mov 0xb7, %r31
thr3_loop_cnt_1166:
	.word 0xc65c2380  ! 1: LDX_I	ldx	[%r16 + 0x0380], %r3
	.word 0xc6d426e4  ! 1: LDSHA_I	ldsha	[%r16, + 0x06e4] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6042b54  ! 1: LDUW_I	lduw	[%r16 + 0x0b54], %r3
	.word 0xc61428d6  ! 1: LDUH_I	lduh	[%r16 + 0x08d6], %r3
	.word 0xdadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r13
	.word 0xe69426d4  ! 1: LDUHA_I	lduha	[%r16, + 0x06d4] %asi, %r19
	.word 0xc6142cd6  ! 1: LDUH_I	lduh	[%r16 + 0x0cd6], %r3
	brnz %r31,thr3_loop_cnt_1166
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x9e140002  ! 1: OR_R	or 	%r16, %r2, %r15
        mov 0xb4, %r31
thr3_loop_cnt_1167:
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xdac4295c  ! 1: LDSWA_I	ldswa	[%r16, + 0x095c] %asi, %r13
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xf89422c2  ! 1: LDUHA_I	lduha	[%r16, + 0x02c2] %asi, %r28
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xfc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r30
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	brnz %r31,thr3_loop_cnt_1167
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
        mov 0x6a, %r31
thr3_loop_cnt_1168:
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6042740  ! 1: LDUW_I	lduw	[%r16 + 0x0740], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd09424c6  ! 1: LDUHA_I	lduha	[%r16, + 0x04c6] %asi, %r8
	.word 0xdcc429a0  ! 1: LDSWA_I	ldswa	[%r16, + 0x09a0] %asi, %r14
	brnz %r31,thr3_loop_cnt_1168
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
        mov 0x5f, %r31
thr3_loop_cnt_1169:
	.word 0xc6dc20d8  ! 1: LDXA_I	ldxa	[%r16, + 0x00d8] %asi, %r3
	.word 0xe6442334  ! 1: LDSW_I	ldsw	[%r16 + 0x0334], %r19
	.word 0xf6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r27
	.word 0xfc842bb0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0bb0] %asi, %r30
	.word 0xe8842868  ! 1: LDUWA_I	lduwa	[%r16, + 0x0868] %asi, %r20
	.word 0xc684245c  ! 1: LDUWA_I	lduwa	[%r16, + 0x045c] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xcc4c2964  ! 1: LDSB_I	ldsb	[%r16 + 0x0964], %r6
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1169
	dec %r31
	.word 0x980c2264  ! 1: AND_I	and 	%r16, 0x0264, %r12
	.word 0x982c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r12
        mov 0xb3, %r31
thr3_loop_cnt_1170:
	.word 0xd84c2f74  ! 1: LDSB_I	ldsb	[%r16 + 0x0f74], %r12
	.word 0xf2d422c6  ! 1: LDSHA_I	ldsha	[%r16, + 0x02c6] %asi, %r25
	.word 0xfc5c2b60  ! 1: LDX_I	ldx	[%r16 + 0x0b60], %r30
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd6442860  ! 1: LDSW_I	ldsw	[%r16 + 0x0860], %r11
	.word 0xc60c22ff  ! 1: LDUB_I	ldub	[%r16 + 0x02ff], %r3
	.word 0xc694203e  ! 1: LDUHA_I	lduha	[%r16, + 0x003e] %asi, %r3
	.word 0xfc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r30
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1170
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x8e2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r7
	.word 0x861c2571  ! 1: XOR_I	xor 	%r16, 0x0571, %r3
	.word 0xb7341002  ! 1: SRLX_R	srlx	%r16, %r2, %r27
        mov 0x9a, %r31
thr3_loop_cnt_1171:
	.word 0xe40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r18
	.word 0xc64c258e  ! 1: LDSB_I	ldsb	[%r16 + 0x058e], %r3
	.word 0xfa4c2337  ! 1: LDSB_I	ldsb	[%r16 + 0x0337], %r29
	.word 0xd2d4241c  ! 1: LDSHA_I	ldsha	[%r16, + 0x041c] %asi, %r9
	.word 0xf254291e  ! 1: LDSH_I	ldsh	[%r16 + 0x091e], %r25
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6142ff4  ! 1: LDUH_I	lduh	[%r16 + 0x0ff4], %r3
	.word 0xe25c2b98  ! 1: LDX_I	ldx	[%r16 + 0x0b98], %r17
	brnz %r31,thr3_loop_cnt_1171
	dec %r31
	.word 0x993c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r12
        mov 0x46, %r31
thr3_loop_cnt_1172:
	.word 0xf2cc2d25  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d25] %asi, %r25
	.word 0xd694283c  ! 1: LDUHA_I	lduha	[%r16, + 0x083c] %asi, %r11
	.word 0xd88c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r12
	.word 0xc6942a7a  ! 1: LDUHA_I	lduha	[%r16, + 0x0a7a] %asi, %r3
	.word 0xfac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r29
	.word 0xf6842754  ! 1: LDUWA_I	lduwa	[%r16, + 0x0754] %asi, %r27
	.word 0xc65425f2  ! 1: LDSH_I	ldsh	[%r16 + 0x05f2], %r3
	.word 0xd2dc22a0  ! 1: LDXA_I	ldxa	[%r16, + 0x02a0] %asi, %r9
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf88428a0  ! 1: LDUWA_I	lduwa	[%r16, + 0x08a0] %asi, %r28
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1172
	dec %r31
	.word 0x8d3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r6
        mov 0x50, %r31
thr3_loop_cnt_1173:
	.word 0xee941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r23
	.word 0xd0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r8
	.word 0xfa0c24f3  ! 1: LDUB_I	ldub	[%r16 + 0x04f3], %r29
	.word 0xc6842360  ! 1: LDUWA_I	lduwa	[%r16, + 0x0360] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xf84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r28
	.word 0xc6cc2cc1  ! 1: LDSBA_I	ldsba	[%r16, + 0x0cc1] %asi, %r3
	.word 0xf6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r27
	brnz %r31,thr3_loop_cnt_1173
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x90, %r31
thr3_loop_cnt_1174:
	.word 0xdc0c2320  ! 1: LDUB_I	ldub	[%r16 + 0x0320], %r14
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xec440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r22
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xda042584  ! 1: LDUW_I	lduw	[%r16 + 0x0584], %r13
	.word 0xfa040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r29
	.word 0xde942918  ! 1: LDUHA_I	lduha	[%r16, + 0x0918] %asi, %r15
	.word 0xea140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r21
	brnz %r31,thr3_loop_cnt_1174
	dec %r31
	.word 0x97341002  ! 1: SRLX_R	srlx	%r16, %r2, %r11
	.word 0x940c0002  ! 1: AND_R	and 	%r16, %r2, %r10
        mov 0x5e, %r31
thr3_loop_cnt_1175:
	.word 0xc6442138  ! 1: LDSW_I	ldsw	[%r16 + 0x0138], %r3
	.word 0xfad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r29
	.word 0xf8042cc8  ! 1: LDUW_I	lduw	[%r16 + 0x0cc8], %r28
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc64c2468  ! 1: LDSB_I	ldsb	[%r16 + 0x0468], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6842268  ! 1: LDUWA_I	lduwa	[%r16, + 0x0268] %asi, %r3
	.word 0xdcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r14
	brnz %r31,thr3_loop_cnt_1175
	dec %r31
	.word 0x8c140002  ! 1: OR_R	or 	%r16, %r2, %r6
	.word 0x863427e5  ! 1: SUBC_I	orn 	%r16, 0x07e5, %r3
	.word 0x860c272c  ! 1: AND_I	and 	%r16, 0x072c, %r3
        mov 0x4d, %r31
thr3_loop_cnt_1176:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xee8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r23
	.word 0xf2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r25
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	.word 0xd8042e98  ! 1: LDUW_I	lduw	[%r16 + 0x0e98], %r12
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc64c2091  ! 1: LDSB_I	ldsb	[%r16 + 0x0091], %r3
	.word 0xe8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r20
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	brnz %r31,thr3_loop_cnt_1176
	dec %r31
	.word 0xb62c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r27
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0xac1c0002  ! 1: XOR_R	xor 	%r16, %r2, %r22
        mov 0x5f, %r31
thr3_loop_cnt_1177:
	.word 0xd4d4299c  ! 1: LDSHA_I	ldsha	[%r16, + 0x099c] %asi, %r10
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6042f40  ! 1: LDUW_I	lduw	[%r16 + 0x0f40], %r3
	.word 0xc6cc2edf  ! 1: LDSBA_I	ldsba	[%r16, + 0x0edf] %asi, %r3
	.word 0xcc942a40  ! 1: LDUHA_I	lduha	[%r16, + 0x0a40] %asi, %r6
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	.word 0xf4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r26
	.word 0xd8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r12
	.word 0xc68c2d30  ! 1: LDUBA_I	lduba	[%r16, + 0x0d30] %asi, %r3
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	brnz %r31,thr3_loop_cnt_1177
	dec %r31
        mov 0x36, %r31
thr3_loop_cnt_1178:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xee841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r23
	.word 0xd44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r10
	.word 0xc6442988  ! 1: LDSW_I	ldsw	[%r16 + 0x0988], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	.word 0xd44c2fe9  ! 1: LDSB_I	ldsb	[%r16 + 0x0fe9], %r10
	.word 0xfc0c2498  ! 1: LDUB_I	ldub	[%r16 + 0x0498], %r30
	.word 0xde8c2284  ! 1: LDUBA_I	lduba	[%r16, + 0x0284] %asi, %r15
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r18
	brnz %r31,thr3_loop_cnt_1178
	dec %r31
	.word 0x860c2c3e  ! 1: AND_I	and 	%r16, 0x0c3e, %r3
        mov 0xc4, %r31
thr3_loop_cnt_1179:
	.word 0xf4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r26
	.word 0xda8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r13
	.word 0xce5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r7
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xdcc4286c  ! 1: LDSWA_I	ldswa	[%r16, + 0x086c] %asi, %r14
	.word 0xc68c248a  ! 1: LDUBA_I	lduba	[%r16, + 0x048a] %asi, %r3
	.word 0xf64c29de  ! 1: LDSB_I	ldsb	[%r16 + 0x09de], %r27
	.word 0xd05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r8
	.word 0xec8c236c  ! 1: LDUBA_I	lduba	[%r16, + 0x036c] %asi, %r22
	brnz %r31,thr3_loop_cnt_1179
	dec %r31
        mov 0x35, %r31
thr3_loop_cnt_1180:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r17
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6cc21a8  ! 1: LDSBA_I	ldsba	[%r16, + 0x01a8] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r19
	.word 0xc60c2474  ! 1: LDUB_I	ldub	[%r16 + 0x0474], %r3
	.word 0xc64c2417  ! 1: LDSB_I	ldsb	[%r16 + 0x0417], %r3
	.word 0xc68c2c30  ! 1: LDUBA_I	lduba	[%r16, + 0x0c30] %asi, %r3
	.word 0xeadc2c20  ! 1: LDXA_I	ldxa	[%r16, + 0x0c20] %asi, %r21
	brnz %r31,thr3_loop_cnt_1180
	dec %r31
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0xac342c9b  ! 1: SUBC_I	orn 	%r16, 0x0c9b, %r22
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0xba, %r31
thr3_loop_cnt_1181:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe2942c0e  ! 1: LDUHA_I	lduha	[%r16, + 0x0c0e] %asi, %r17
	.word 0xc6c42a5c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a5c] %asi, %r3
	.word 0xfc04290c  ! 1: LDUW_I	lduw	[%r16 + 0x090c], %r30
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xe6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r19
	.word 0xdac4238c  ! 1: LDSWA_I	ldswa	[%r16, + 0x038c] %asi, %r13
	.word 0xe8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r20
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6442338  ! 1: LDSW_I	ldsw	[%r16 + 0x0338], %r3
	brnz %r31,thr3_loop_cnt_1181
	dec %r31
	.word 0xb93c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r28
	.word 0xb20c0002  ! 1: AND_R	and 	%r16, %r2, %r25
	.word 0x901c0002  ! 1: XOR_R	xor 	%r16, %r2, %r8
	.word 0x86042f2a  ! 1: ADD_I	add 	%r16, 0x0f2a, %r3
        mov 0xa7, %r31
thr3_loop_cnt_1182:
	.word 0xfc142852  ! 1: LDUH_I	lduh	[%r16 + 0x0852], %r30
	.word 0xec941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r22
	.word 0xc6cc254c  ! 1: LDSBA_I	ldsba	[%r16, + 0x054c] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6d42300  ! 1: LDSHA_I	ldsha	[%r16, + 0x0300] %asi, %r3
	.word 0xc6dc2050  ! 1: LDXA_I	ldxa	[%r16, + 0x0050] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xde0426a0  ! 1: LDUW_I	lduw	[%r16 + 0x06a0], %r15
	.word 0xc6442360  ! 1: LDSW_I	ldsw	[%r16 + 0x0360], %r3
	.word 0xd8042bc8  ! 1: LDUW_I	lduw	[%r16 + 0x0bc8], %r12
	.word 0xfc4c2a2f  ! 1: LDSB_I	ldsb	[%r16 + 0x0a2f], %r30
	brnz %r31,thr3_loop_cnt_1182
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x862c23ca  ! 1: ANDN_I	andn 	%r16, 0x03ca, %r3
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
        mov 0x5f, %r31
thr3_loop_cnt_1183:
	.word 0xfc8c2aa2  ! 1: LDUBA_I	lduba	[%r16, + 0x0aa2] %asi, %r30
	.word 0xc64c27b6  ! 1: LDSB_I	ldsb	[%r16 + 0x07b6], %r3
	.word 0xc6cc260b  ! 1: LDSBA_I	ldsba	[%r16, + 0x060b] %asi, %r3
	.word 0xde5c21d8  ! 1: LDX_I	ldx	[%r16 + 0x01d8], %r15
	.word 0xf04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r24
	.word 0xd0841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r8
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xe6d4279e  ! 1: LDSHA_I	ldsha	[%r16, + 0x079e] %asi, %r19
	.word 0xd2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r9
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xdccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r14
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1183
	dec %r31
        mov 0x71, %r31
thr3_loop_cnt_1184:
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	.word 0xdccc2ace  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ace] %asi, %r14
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6142af0  ! 1: LDUH_I	lduh	[%r16 + 0x0af0], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6442b90  ! 1: LDSW_I	ldsw	[%r16 + 0x0b90], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1184
	dec %r31
	.word 0x8f2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r7
        mov 0x6d, %r31
thr3_loop_cnt_1185:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xce0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r7
	.word 0xf81425b8  ! 1: LDUH_I	lduh	[%r16 + 0x05b8], %r28
	.word 0xd6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r11
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xecdc2950  ! 1: LDXA_I	ldxa	[%r16, + 0x0950] %asi, %r22
	.word 0xc64c2d72  ! 1: LDSB_I	ldsb	[%r16 + 0x0d72], %r3
	.word 0xc6cc2ea4  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ea4] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xdc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r14
	brnz %r31,thr3_loop_cnt_1185
	dec %r31
        mov 0x3d, %r31
thr3_loop_cnt_1186:
	.word 0xdac42380  ! 1: LDSWA_I	ldswa	[%r16, + 0x0380] %asi, %r13
	.word 0xd8d42f58  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f58] %asi, %r12
	.word 0xce042598  ! 1: LDUW_I	lduw	[%r16 + 0x0598], %r7
	.word 0xec8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r22
	.word 0xd0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r8
	.word 0xf61427d6  ! 1: LDUH_I	lduh	[%r16 + 0x07d6], %r27
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xcecc2dc6  ! 1: LDSBA_I	ldsba	[%r16, + 0x0dc6] %asi, %r7
	.word 0xc6c42404  ! 1: LDSWA_I	ldswa	[%r16, + 0x0404] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1186
	dec %r31
        mov 0xf, %r31
thr3_loop_cnt_1187:
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6d42730  ! 1: LDSHA_I	ldsha	[%r16, + 0x0730] %asi, %r3
	.word 0xec8c20a4  ! 1: LDUBA_I	lduba	[%r16, + 0x00a4] %asi, %r22
	.word 0xf44c2fa0  ! 1: LDSB_I	ldsb	[%r16 + 0x0fa0], %r26
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf2d42f20  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f20] %asi, %r25
	.word 0xdacc20a7  ! 1: LDSBA_I	ldsba	[%r16, + 0x00a7] %asi, %r13
	.word 0xc6d42dd0  ! 1: LDSHA_I	ldsha	[%r16, + 0x0dd0] %asi, %r3
	.word 0xc6cc2ad6  ! 1: LDSBA_I	ldsba	[%r16, + 0x0ad6] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1187
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0xad341002  ! 1: SRLX_R	srlx	%r16, %r2, %r22
        mov 0x56, %r31
thr3_loop_cnt_1188:
	.word 0xfc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r30
	.word 0xe4442c78  ! 1: LDSW_I	ldsw	[%r16 + 0x0c78], %r18
	.word 0xccd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r6
	.word 0xc68c280f  ! 1: LDUBA_I	lduba	[%r16, + 0x080f] %asi, %r3
	.word 0xc65c2008  ! 1: LDX_I	ldx	[%r16 + 0x0008], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xea0c2805  ! 1: LDUB_I	ldub	[%r16 + 0x0805], %r21
	.word 0xe28c27ae  ! 1: LDUBA_I	lduba	[%r16, + 0x07ae] %asi, %r17
	.word 0xc6042f94  ! 1: LDUW_I	lduw	[%r16 + 0x0f94], %r3
	brnz %r31,thr3_loop_cnt_1188
	dec %r31
        mov 0xbe, %r31
thr3_loop_cnt_1189:
	.word 0xc64c2797  ! 1: LDSB_I	ldsb	[%r16 + 0x0797], %r3
	.word 0xd60c25cb  ! 1: LDUB_I	ldub	[%r16 + 0x05cb], %r11
	.word 0xee040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r23
	.word 0xdc4c2e6c  ! 1: LDSB_I	ldsb	[%r16 + 0x0e6c], %r14
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	.word 0xd2142a0e  ! 1: LDUH_I	lduh	[%r16 + 0x0a0e], %r9
	.word 0xd0140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r8
	.word 0xe6c42958  ! 1: LDSWA_I	ldswa	[%r16, + 0x0958] %asi, %r19
	.word 0xe65423bc  ! 1: LDSH_I	ldsh	[%r16 + 0x03bc], %r19
	brnz %r31,thr3_loop_cnt_1189
	dec %r31
	.word 0x8604277e  ! 1: ADD_I	add 	%r16, 0x077e, %r3
	.word 0x9b341002  ! 1: SRLX_R	srlx	%r16, %r2, %r13
	.word 0xb0142c62  ! 1: OR_I	or 	%r16, 0x0c62, %r24
        mov 0x7b, %r31
thr3_loop_cnt_1190:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6c42ff0  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ff0] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6dc2348  ! 1: LDXA_I	ldxa	[%r16, + 0x0348] %asi, %r3
	.word 0xf4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r26
	.word 0xc68c26f2  ! 1: LDUBA_I	lduba	[%r16, + 0x06f2] %asi, %r3
	brnz %r31,thr3_loop_cnt_1190
	dec %r31
        mov 0xc7, %r31
thr3_loop_cnt_1191:
	.word 0xe4942da0  ! 1: LDUHA_I	lduha	[%r16, + 0x0da0] %asi, %r18
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xdecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r15
	.word 0xd65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r11
	.word 0xda5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r13
	.word 0xc60c26d5  ! 1: LDUB_I	ldub	[%r16 + 0x06d5], %r3
	.word 0xc6dc29d0  ! 1: LDXA_I	ldxa	[%r16, + 0x09d0] %asi, %r3
	.word 0xf2442ff0  ! 1: LDSW_I	ldsw	[%r16 + 0x0ff0], %r25
	.word 0xc69420b0  ! 1: LDUHA_I	lduha	[%r16, + 0x00b0] %asi, %r3
	.word 0xde0c2b0c  ! 1: LDUB_I	ldub	[%r16 + 0x0b0c], %r15
	brnz %r31,thr3_loop_cnt_1191
	dec %r31
	.word 0x9d341002  ! 1: SRLX_R	srlx	%r16, %r2, %r14
	.word 0xa40c2f3b  ! 1: AND_I	and 	%r16, 0x0f3b, %r18
	.word 0x860c2c6e  ! 1: AND_I	and 	%r16, 0x0c6e, %r3
        mov 0xc4, %r31
thr3_loop_cnt_1192:
	.word 0xe6442490  ! 1: LDSW_I	ldsw	[%r16 + 0x0490], %r19
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xd604289c  ! 1: LDUW_I	lduw	[%r16 + 0x089c], %r11
	.word 0xeecc262c  ! 1: LDSBA_I	ldsba	[%r16, + 0x062c] %asi, %r23
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xc6cc2002  ! 1: LDSBA_I	ldsba	[%r16, + 0x0002] %asi, %r3
	.word 0xc6cc26e9  ! 1: LDSBA_I	ldsba	[%r16, + 0x06e9] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd8142efc  ! 1: LDUH_I	lduh	[%r16 + 0x0efc], %r12
	.word 0xfa4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r29
	brnz %r31,thr3_loop_cnt_1192
	dec %r31
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
	.word 0x862420ef  ! 1: SUB_I	sub 	%r16, 0x00ef, %r3
        mov 0x7e, %r31
thr3_loop_cnt_1193:
	.word 0xf0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r24
	.word 0xfadc2c40  ! 1: LDXA_I	ldxa	[%r16, + 0x0c40] %asi, %r29
	.word 0xd4942e28  ! 1: LDUHA_I	lduha	[%r16, + 0x0e28] %asi, %r10
	.word 0xd84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r12
	.word 0xc60c24cf  ! 1: LDUB_I	ldub	[%r16 + 0x04cf], %r3
	.word 0xc65c27f8  ! 1: LDX_I	ldx	[%r16 + 0x07f8], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xec0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r22
	.word 0xccc42754  ! 1: LDSWA_I	ldswa	[%r16, + 0x0754] %asi, %r6
	.word 0xda140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r13
	.word 0xc6d42a4e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a4e] %asi, %r3
	.word 0xd484252c  ! 1: LDUWA_I	lduwa	[%r16, + 0x052c] %asi, %r10
	brnz %r31,thr3_loop_cnt_1193
	dec %r31
        mov 0xc0, %r31
thr3_loop_cnt_1194:
	.word 0xf2c42850  ! 1: LDSWA_I	ldswa	[%r16, + 0x0850] %asi, %r25
	.word 0xeac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r21
	.word 0xc6042d8c  ! 1: LDUW_I	lduw	[%r16 + 0x0d8c], %r3
	.word 0xfa442590  ! 1: LDSW_I	ldsw	[%r16 + 0x0590], %r29
	.word 0xd6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r11
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xd45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r10
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd8942716  ! 1: LDUHA_I	lduha	[%r16, + 0x0716] %asi, %r12
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc68c2c55  ! 1: LDUBA_I	lduba	[%r16, + 0x0c55] %asi, %r3
	brnz %r31,thr3_loop_cnt_1194
	dec %r31
        mov 0x55, %r31
thr3_loop_cnt_1195:
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe6442038  ! 1: LDSW_I	ldsw	[%r16 + 0x0038], %r19
	.word 0xdad42898  ! 1: LDSHA_I	ldsha	[%r16, + 0x0898] %asi, %r13
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	.word 0xc6842edc  ! 1: LDUWA_I	lduwa	[%r16, + 0x0edc] %asi, %r3
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xc6142218  ! 1: LDUH_I	lduh	[%r16 + 0x0218], %r3
	.word 0xd28c286b  ! 1: LDUBA_I	lduba	[%r16, + 0x086b] %asi, %r9
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	brnz %r31,thr3_loop_cnt_1195
	dec %r31
	.word 0xb5343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r26
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x9f2c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r15
        mov 0xac, %r31
thr3_loop_cnt_1196:
	.word 0xf4dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r26
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc64c2f4b  ! 1: LDSB_I	ldsb	[%r16 + 0x0f4b], %r3
	.word 0xc64c236d  ! 1: LDSB_I	ldsb	[%r16 + 0x036d], %r3
	.word 0xee142c6c  ! 1: LDUH_I	lduh	[%r16 + 0x0c6c], %r23
	.word 0xc6942560  ! 1: LDUHA_I	lduha	[%r16, + 0x0560] %asi, %r3
	.word 0xc60c2104  ! 1: LDUB_I	ldub	[%r16 + 0x0104], %r3
	brnz %r31,thr3_loop_cnt_1196
	dec %r31
	.word 0xae342f6e  ! 1: ORN_I	orn 	%r16, 0x0f6e, %r23
	.word 0x863429fd  ! 1: SUBC_I	orn 	%r16, 0x09fd, %r3
	.word 0x9e0428ec  ! 1: ADD_I	add 	%r16, 0x08ec, %r15
	.word 0x97341002  ! 1: SRLX_R	srlx	%r16, %r2, %r11
        mov 0x7b, %r31
thr3_loop_cnt_1197:
	.word 0xc6dc2338  ! 1: LDXA_I	ldxa	[%r16, + 0x0338] %asi, %r3
	.word 0xce0c239d  ! 1: LDUB_I	ldub	[%r16 + 0x039d], %r7
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xd25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r9
	.word 0xc6042a04  ! 1: LDUW_I	lduw	[%r16 + 0x0a04], %r3
	.word 0xdcc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r14
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xea140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r21
	.word 0xd05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r8
	brnz %r31,thr3_loop_cnt_1197
	dec %r31
	.word 0xa4340002  ! 1: SUBC_R	orn 	%r16, %r2, %r18
	.word 0x98040002  ! 1: ADD_R	add 	%r16, %r2, %r12
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0x22, %r31
thr3_loop_cnt_1198:
	.word 0xd40421a8  ! 1: LDUW_I	lduw	[%r16 + 0x01a8], %r10
	.word 0xc68425e8  ! 1: LDUWA_I	lduwa	[%r16, + 0x05e8] %asi, %r3
	.word 0xeac42b70  ! 1: LDSWA_I	ldswa	[%r16, + 0x0b70] %asi, %r21
	.word 0xec440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r22
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xf0dc2430  ! 1: LDXA_I	ldxa	[%r16, + 0x0430] %asi, %r24
	.word 0xd40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r10
	.word 0xc64c20a7  ! 1: LDSB_I	ldsb	[%r16 + 0x00a7], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc65c2df0  ! 1: LDX_I	ldx	[%r16 + 0x0df0], %r3
	.word 0xd0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r8
	.word 0xc6c427c0  ! 1: LDSWA_I	ldswa	[%r16, + 0x07c0] %asi, %r3
	brnz %r31,thr3_loop_cnt_1198
	dec %r31
        mov 0x10, %r31
thr3_loop_cnt_1199:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xce440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r7
	.word 0xeecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r23
	.word 0xf0042318  ! 1: LDUW_I	lduw	[%r16 + 0x0318], %r24
	.word 0xd6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r11
	.word 0xc6d42bac  ! 1: LDSHA_I	ldsha	[%r16, + 0x0bac] %asi, %r3
	.word 0xc6cc26e1  ! 1: LDSBA_I	ldsba	[%r16, + 0x06e1] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xde841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r15
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xee140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r23
	brnz %r31,thr3_loop_cnt_1199
	dec %r31
	.word 0xa43427cd  ! 1: SUBC_I	orn 	%r16, 0x07cd, %r18
	.word 0x983c2be6  ! 1: XNOR_I	xnor 	%r16, 0x0be6, %r12
        mov 0x9c, %r31
thr3_loop_cnt_1200:
	.word 0xc6042b24  ! 1: LDUW_I	lduw	[%r16 + 0x0b24], %r3
	.word 0xf6042c74  ! 1: LDUW_I	lduw	[%r16 + 0x0c74], %r27
	.word 0xc614272a  ! 1: LDUH_I	lduh	[%r16 + 0x072a], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xe80c2a2b  ! 1: LDUB_I	ldub	[%r16 + 0x0a2b], %r20
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1200
	dec %r31
	.word 0x873c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
        mov 0x73, %r31
thr3_loop_cnt_1201:
	.word 0xec8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r22
	.word 0xc60c26e8  ! 1: LDUB_I	ldub	[%r16 + 0x06e8], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6dc2dc0  ! 1: LDXA_I	ldxa	[%r16, + 0x0dc0] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6cc226e  ! 1: LDSBA_I	ldsba	[%r16, + 0x026e] %asi, %r3
	.word 0xf0dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r24
	.word 0xc6d4221e  ! 1: LDSHA_I	ldsha	[%r16, + 0x021e] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1201
	dec %r31
	.word 0xa5343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r18
	.word 0xa8040002  ! 1: ADD_R	add 	%r16, %r2, %r20
        mov 0x65, %r31
thr3_loop_cnt_1202:
	.word 0xccc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r6
	.word 0xec442b0c  ! 1: LDSW_I	ldsw	[%r16 + 0x0b0c], %r22
	.word 0xc6942768  ! 1: LDUHA_I	lduha	[%r16, + 0x0768] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc64424f4  ! 1: LDSW_I	ldsw	[%r16 + 0x04f4], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xda140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r13
	.word 0xc6cc2c25  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c25] %asi, %r3
	.word 0xf4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r26
	.word 0xfa5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r29
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc64426e4  ! 1: LDSW_I	ldsw	[%r16 + 0x06e4], %r3
	brnz %r31,thr3_loop_cnt_1202
	dec %r31
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x9c342bda  ! 1: SUBC_I	orn 	%r16, 0x0bda, %r14
        mov 0x6d, %r31
thr3_loop_cnt_1203:
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xd80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r12
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r12
	.word 0xc65c2668  ! 1: LDX_I	ldx	[%r16 + 0x0668], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xee440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r23
	.word 0xc6542392  ! 1: LDSH_I	ldsh	[%r16 + 0x0392], %r3
	brnz %r31,thr3_loop_cnt_1203
	dec %r31
	.word 0x86142e3b  ! 1: OR_I	or 	%r16, 0x0e3b, %r3
	.word 0xac1c28c3  ! 1: XOR_I	xor 	%r16, 0x08c3, %r22
	.word 0xa32c0002  ! 1: SLL_R	sll 	%r16, %r2, %r17
        mov 0x22, %r31
thr3_loop_cnt_1204:
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	.word 0xdc0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r14
	.word 0xd21421c6  ! 1: LDUH_I	lduh	[%r16 + 0x01c6], %r9
	.word 0xc60c2048  ! 1: LDUB_I	ldub	[%r16 + 0x0048], %r3
	.word 0xecd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r22
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r27
	brnz %r31,thr3_loop_cnt_1204
	dec %r31
	.word 0x912c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r8
	.word 0x92342076  ! 1: ORN_I	orn 	%r16, 0x0076, %r9
	.word 0x861c0002  ! 1: XOR_R	xor 	%r16, %r2, %r3
	.word 0xb53c1002  ! 1: SRAX_R	srax	%r16, %r2, %r26
        mov 0x1a, %r31
thr3_loop_cnt_1205:
	.word 0xc6542f34  ! 1: LDSH_I	ldsh	[%r16 + 0x0f34], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xdac42ae8  ! 1: LDSWA_I	ldswa	[%r16, + 0x0ae8] %asi, %r13
	.word 0xda442ff8  ! 1: LDSW_I	ldsw	[%r16 + 0x0ff8], %r13
	.word 0xd4142fcc  ! 1: LDUH_I	lduh	[%r16 + 0x0fcc], %r10
	.word 0xf4942f06  ! 1: LDUHA_I	lduha	[%r16, + 0x0f06] %asi, %r26
	.word 0xf6542bee  ! 1: LDSH_I	ldsh	[%r16 + 0x0bee], %r27
	.word 0xc65c26b0  ! 1: LDX_I	ldx	[%r16 + 0x06b0], %r3
	.word 0xc654221c  ! 1: LDSH_I	ldsh	[%r16 + 0x021c], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1205
	dec %r31
	.word 0xa52c0002  ! 1: SLL_R	sll 	%r16, %r2, %r18
        mov 0xaf, %r31
thr3_loop_cnt_1206:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc644271c  ! 1: LDSW_I	ldsw	[%r16 + 0x071c], %r3
	.word 0xf64420c8  ! 1: LDSW_I	ldsw	[%r16 + 0x00c8], %r27
	.word 0xea4c2cb2  ! 1: LDSB_I	ldsb	[%r16 + 0x0cb2], %r21
	.word 0xdec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r15
	.word 0xc68c2f45  ! 1: LDUBA_I	lduba	[%r16, + 0x0f45] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1206
	dec %r31
        mov 0xb0, %r31
thr3_loop_cnt_1207:
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6c428f0  ! 1: LDSWA_I	ldswa	[%r16, + 0x08f0] %asi, %r3
	.word 0xda5c2d08  ! 1: LDX_I	ldx	[%r16 + 0x0d08], %r13
	.word 0xf4dc2290  ! 1: LDXA_I	ldxa	[%r16, + 0x0290] %asi, %r26
	.word 0xcc042aa0  ! 1: LDUW_I	lduw	[%r16 + 0x0aa0], %r6
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xde5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r15
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd6942e8a  ! 1: LDUHA_I	lduha	[%r16, + 0x0e8a] %asi, %r11
	.word 0xde440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r15
	.word 0xdacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r13
	brnz %r31,thr3_loop_cnt_1207
	dec %r31
	.word 0x8d341002  ! 1: SRLX_R	srlx	%r16, %r2, %r6
	.word 0xb12c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r24
	.word 0xa9341002  ! 1: SRLX_R	srlx	%r16, %r2, %r20
        mov 0xb2, %r31
thr3_loop_cnt_1208:
	.word 0xd6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r11
	.word 0xdc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r14
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xeadc2c10  ! 1: LDXA_I	ldxa	[%r16, + 0x0c10] %asi, %r21
	.word 0xc6942296  ! 1: LDUHA_I	lduha	[%r16, + 0x0296] %asi, %r3
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xc6542b98  ! 1: LDSH_I	ldsh	[%r16 + 0x0b98], %r3
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xde0c2788  ! 1: LDUB_I	ldub	[%r16 + 0x0788], %r15
	.word 0xd4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r10
	brnz %r31,thr3_loop_cnt_1208
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x980c0002  ! 1: AND_R	and 	%r16, %r2, %r12
        mov 0x6e, %r31
thr3_loop_cnt_1209:
	.word 0xc6942b6a  ! 1: LDUHA_I	lduha	[%r16, + 0x0b6a] %asi, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc64c2d3b  ! 1: LDSB_I	ldsb	[%r16 + 0x0d3b], %r3
	.word 0xc6442b1c  ! 1: LDSW_I	ldsw	[%r16 + 0x0b1c], %r3
	.word 0xc68c2e43  ! 1: LDUBA_I	lduba	[%r16, + 0x0e43] %asi, %r3
	.word 0xfc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r30
	brnz %r31,thr3_loop_cnt_1209
	dec %r31
	.word 0xb93c0002  ! 1: SRA_R	sra 	%r16, %r2, %r28
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0x52, %r31
thr3_loop_cnt_1210:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xfc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r30
	.word 0xc64c20cc  ! 1: LDSB_I	ldsb	[%r16 + 0x00cc], %r3
	.word 0xe6542772  ! 1: LDSH_I	ldsh	[%r16 + 0x0772], %r19
	.word 0xc68c27dd  ! 1: LDUBA_I	lduba	[%r16, + 0x07dd] %asi, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xfacc2d53  ! 1: LDSBA_I	ldsba	[%r16, + 0x0d53] %asi, %r29
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1210
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x96342e2b  ! 1: SUBC_I	orn 	%r16, 0x0e2b, %r11
	.word 0x8624228b  ! 1: SUB_I	sub 	%r16, 0x028b, %r3
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x8f, %r31
thr3_loop_cnt_1211:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xee0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r23
	.word 0xdecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r15
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe88c2d5a  ! 1: LDUBA_I	lduba	[%r16, + 0x0d5a] %asi, %r20
	.word 0xc64c2669  ! 1: LDSB_I	ldsb	[%r16 + 0x0669], %r3
	.word 0xee442f54  ! 1: LDSW_I	ldsw	[%r16 + 0x0f54], %r23
	.word 0xccc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r6
	brnz %r31,thr3_loop_cnt_1211
	dec %r31
	.word 0x9a2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r13
        mov 0x16, %r31
thr3_loop_cnt_1212:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe25422a0  ! 1: LDSH_I	ldsh	[%r16 + 0x02a0], %r17
	.word 0xc65c2bc0  ! 1: LDX_I	ldx	[%r16 + 0x0bc0], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xfa0c2f85  ! 1: LDUB_I	ldub	[%r16 + 0x0f85], %r29
	.word 0xec8c2661  ! 1: LDUBA_I	lduba	[%r16, + 0x0661] %asi, %r22
	.word 0xea942684  ! 1: LDUHA_I	lduha	[%r16, + 0x0684] %asi, %r21
	.word 0xf68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r27
	.word 0xf0040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r24
	brnz %r31,thr3_loop_cnt_1212
	dec %r31
	.word 0xb40c0002  ! 1: AND_R	and 	%r16, %r2, %r26
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x9d3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r14
        mov 0x6f, %r31
thr3_loop_cnt_1213:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r12
	.word 0xf2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r25
	.word 0xd84c2d44  ! 1: LDSB_I	ldsb	[%r16 + 0x0d44], %r12
	.word 0xdac41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r13
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xf4042ffc  ! 1: LDUW_I	lduw	[%r16 + 0x0ffc], %r26
	.word 0xdadc2200  ! 1: LDXA_I	ldxa	[%r16, + 0x0200] %asi, %r13
	.word 0xc6042204  ! 1: LDUW_I	lduw	[%r16 + 0x0204], %r3
	brnz %r31,thr3_loop_cnt_1213
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x9c14279d  ! 1: OR_I	or 	%r16, 0x079d, %r14
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
        mov 0x2e, %r31
thr3_loop_cnt_1214:
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xdc14245c  ! 1: LDUH_I	lduh	[%r16 + 0x045c], %r14
	.word 0xc6042a5c  ! 1: LDUW_I	lduw	[%r16 + 0x0a5c], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc60c2dc3  ! 1: LDUB_I	ldub	[%r16 + 0x0dc3], %r3
	.word 0xc6542e8e  ! 1: LDSH_I	ldsh	[%r16 + 0x0e8e], %r3
	.word 0xea0c2359  ! 1: LDUB_I	ldub	[%r16 + 0x0359], %r21
	brnz %r31,thr3_loop_cnt_1214
	dec %r31
	.word 0x862c2cc9  ! 1: ANDN_I	andn 	%r16, 0x0cc9, %r3
        mov 0x9c, %r31
thr3_loop_cnt_1215:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd80c22c5  ! 1: LDUB_I	ldub	[%r16 + 0x02c5], %r12
	.word 0xc60c2f65  ! 1: LDUB_I	ldub	[%r16 + 0x0f65], %r3
	.word 0xe6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r19
	.word 0xd84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r12
	.word 0xc6842338  ! 1: LDUWA_I	lduwa	[%r16, + 0x0338] %asi, %r3
	.word 0xf4c4235c  ! 1: LDSWA_I	ldswa	[%r16, + 0x035c] %asi, %r26
	.word 0xc6542b18  ! 1: LDSH_I	ldsh	[%r16 + 0x0b18], %r3
	.word 0xc6cc2884  ! 1: LDSBA_I	ldsba	[%r16, + 0x0884] %asi, %r3
	brnz %r31,thr3_loop_cnt_1215
	dec %r31
        mov 0xa7, %r31
thr3_loop_cnt_1216:
	.word 0xf2042588  ! 1: LDUW_I	lduw	[%r16 + 0x0588], %r25
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r11
	.word 0xea542a46  ! 1: LDSH_I	ldsh	[%r16 + 0x0a46], %r21
	.word 0xc60c21ad  ! 1: LDUB_I	ldub	[%r16 + 0x01ad], %r3
	.word 0xfc5c2968  ! 1: LDX_I	ldx	[%r16 + 0x0968], %r30
	.word 0xc60c2cf7  ! 1: LDUB_I	ldub	[%r16 + 0x0cf7], %r3
	.word 0xc64c2943  ! 1: LDSB_I	ldsb	[%r16 + 0x0943], %r3
	.word 0xc68420a4  ! 1: LDUWA_I	lduwa	[%r16, + 0x00a4] %asi, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xde040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r15
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	brnz %r31,thr3_loop_cnt_1216
	dec %r31
	.word 0x860c2122  ! 1: AND_I	and 	%r16, 0x0122, %r3
        mov 0xf, %r31
thr3_loop_cnt_1217:
	.word 0xf84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r28
	.word 0xf05c2ac0  ! 1: LDX_I	ldx	[%r16 + 0x0ac0], %r24
	.word 0xec942406  ! 1: LDUHA_I	lduha	[%r16, + 0x0406] %asi, %r22
	.word 0xc6842f58  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f58] %asi, %r3
	.word 0xf05c2720  ! 1: LDX_I	ldx	[%r16 + 0x0720], %r24
	.word 0xd05c29f0  ! 1: LDX_I	ldx	[%r16 + 0x09f0], %r8
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xde0429cc  ! 1: LDUW_I	lduw	[%r16 + 0x09cc], %r15
	.word 0xe6c42f64  ! 1: LDSWA_I	ldswa	[%r16, + 0x0f64] %asi, %r19
	.word 0xc6142eb2  ! 1: LDUH_I	lduh	[%r16 + 0x0eb2], %r3
	.word 0xce842334  ! 1: LDUWA_I	lduwa	[%r16, + 0x0334] %asi, %r7
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1217
	dec %r31
        mov 0x44, %r31
thr3_loop_cnt_1218:
	.word 0xc6042eb4  ! 1: LDUW_I	lduw	[%r16 + 0x0eb4], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc64c21aa  ! 1: LDSB_I	ldsb	[%r16 + 0x01aa], %r3
	.word 0xc694215e  ! 1: LDUHA_I	lduha	[%r16, + 0x015e] %asi, %r3
	.word 0xd2542110  ! 1: LDSH_I	ldsh	[%r16 + 0x0110], %r9
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xe68c28a8  ! 1: LDUBA_I	lduba	[%r16, + 0x08a8] %asi, %r19
	.word 0xf2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r25
	brnz %r31,thr3_loop_cnt_1218
	dec %r31
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x86242234  ! 1: SUB_I	sub 	%r16, 0x0234, %r3
        mov 0xa, %r31
thr3_loop_cnt_1219:
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xe4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r18
	.word 0xc6142994  ! 1: LDUH_I	lduh	[%r16 + 0x0994], %r3
	.word 0xf00424d0  ! 1: LDUW_I	lduw	[%r16 + 0x04d0], %r24
	.word 0xf8841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r28
	.word 0xf68424bc  ! 1: LDUWA_I	lduwa	[%r16, + 0x04bc] %asi, %r27
	.word 0xf4cc26a0  ! 1: LDSBA_I	ldsba	[%r16, + 0x06a0] %asi, %r26
	.word 0xe2841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r17
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc60c274b  ! 1: LDUB_I	ldub	[%r16 + 0x074b], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf2941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r25
	brnz %r31,thr3_loop_cnt_1219
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0xb7341002  ! 1: SRLX_R	srlx	%r16, %r2, %r27
        mov 0x4, %r31
thr3_loop_cnt_1220:
	.word 0xf40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r26
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xf2842304  ! 1: LDUWA_I	lduwa	[%r16, + 0x0304] %asi, %r25
	.word 0xd8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r12
	.word 0xfc042240  ! 1: LDUW_I	lduw	[%r16 + 0x0240], %r30
	.word 0xc6042a2c  ! 1: LDUW_I	lduw	[%r16 + 0x0a2c], %r3
	.word 0xf4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r26
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xcccc268a  ! 1: LDSBA_I	ldsba	[%r16, + 0x068a] %asi, %r6
	.word 0xc68c2a8e  ! 1: LDUBA_I	lduba	[%r16, + 0x0a8e] %asi, %r3
	brnz %r31,thr3_loop_cnt_1220
	dec %r31
	.word 0x97340002  ! 1: SRL_R	srl 	%r16, %r2, %r11
        mov 0xc6, %r31
thr3_loop_cnt_1221:
	.word 0xd20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r9
	.word 0xee4c2ea1  ! 1: LDSB_I	ldsb	[%r16 + 0x0ea1], %r23
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xfc0c2ef3  ! 1: LDUB_I	ldub	[%r16 + 0x0ef3], %r30
	.word 0xd24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r9
	.word 0xc60c2240  ! 1: LDUB_I	ldub	[%r16 + 0x0240], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe69422c2  ! 1: LDUHA_I	lduha	[%r16, + 0x02c2] %asi, %r19
	.word 0xe24c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r17
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc68c200e  ! 1: LDUBA_I	lduba	[%r16, + 0x000e] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1221
	dec %r31
	.word 0x872c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x860c28b1  ! 1: AND_I	and 	%r16, 0x08b1, %r3
        mov 0x3b, %r31
thr3_loop_cnt_1222:
	.word 0xeedc2118  ! 1: LDXA_I	ldxa	[%r16, + 0x0118] %asi, %r23
	.word 0xc68c2207  ! 1: LDUBA_I	lduba	[%r16, + 0x0207] %asi, %r3
	.word 0xc6042d48  ! 1: LDUW_I	lduw	[%r16 + 0x0d48], %r3
	.word 0xd4442010  ! 1: LDSW_I	ldsw	[%r16 + 0x0010], %r10
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc654272a  ! 1: LDSH_I	ldsh	[%r16 + 0x072a], %r3
	.word 0xde042418  ! 1: LDUW_I	lduw	[%r16 + 0x0418], %r15
	.word 0xf2cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r25
	brnz %r31,thr3_loop_cnt_1222
	dec %r31
        mov 0x3e, %r31
thr3_loop_cnt_1223:
	.word 0xe2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r17
	.word 0xc6542718  ! 1: LDSH_I	ldsh	[%r16 + 0x0718], %r3
	.word 0xc6442a3c  ! 1: LDSW_I	ldsw	[%r16 + 0x0a3c], %r3
	.word 0xc64c2ef0  ! 1: LDSB_I	ldsb	[%r16 + 0x0ef0], %r3
	.word 0xce84258c  ! 1: LDUWA_I	lduwa	[%r16, + 0x058c] %asi, %r7
	.word 0xc65427dc  ! 1: LDSH_I	ldsh	[%r16 + 0x07dc], %r3
	.word 0xc6d423d4  ! 1: LDSHA_I	ldsha	[%r16, + 0x03d4] %asi, %r3
	.word 0xded42f4c  ! 1: LDSHA_I	ldsha	[%r16, + 0x0f4c] %asi, %r15
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd88c2d56  ! 1: LDUBA_I	lduba	[%r16, + 0x0d56] %asi, %r12
	.word 0xe84c285b  ! 1: LDSB_I	ldsb	[%r16 + 0x085b], %r20
	.word 0xded42c6e  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c6e] %asi, %r15
	brnz %r31,thr3_loop_cnt_1223
	dec %r31
	.word 0x8644273e  ! 1: ADDC_I	addc 	%r16, 0x073e, %r3
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x86342959  ! 1: ORN_I	orn 	%r16, 0x0959, %r3
	.word 0xba342783  ! 1: ORN_I	orn 	%r16, 0x0783, %r29
        mov 0xc6, %r31
thr3_loop_cnt_1224:
	.word 0xc6442708  ! 1: LDSW_I	ldsw	[%r16 + 0x0708], %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc60c27f0  ! 1: LDUB_I	ldub	[%r16 + 0x07f0], %r3
	.word 0xc68c252a  ! 1: LDUBA_I	lduba	[%r16, + 0x052a] %asi, %r3
	.word 0xc65c2468  ! 1: LDX_I	ldx	[%r16 + 0x0468], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6142734  ! 1: LDUH_I	lduh	[%r16 + 0x0734], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xf85428d6  ! 1: LDSH_I	ldsh	[%r16 + 0x08d6], %r28
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1224
	dec %r31
	.word 0x86342d0b  ! 1: ORN_I	orn 	%r16, 0x0d0b, %r3
	.word 0x98342679  ! 1: SUBC_I	orn 	%r16, 0x0679, %r12
	.word 0xb8440002  ! 1: ADDC_R	addc 	%r16, %r2, %r28
        mov 0x40, %r31
thr3_loop_cnt_1225:
	.word 0xdc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r14
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xe4dc22d0  ! 1: LDXA_I	ldxa	[%r16, + 0x02d0] %asi, %r18
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xd8542bb2  ! 1: LDSH_I	ldsh	[%r16 + 0x0bb2], %r12
	.word 0xf40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r26
	.word 0xd6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r11
	.word 0xf0cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r24
	.word 0xc6c42108  ! 1: LDSWA_I	ldswa	[%r16, + 0x0108] %asi, %r3
	.word 0xf4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r26
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xec0c2e96  ! 1: LDUB_I	ldub	[%r16 + 0x0e96], %r22
	brnz %r31,thr3_loop_cnt_1225
	dec %r31
	.word 0xad3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r22
	.word 0x9f3c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r15
        mov 0xab, %r31
thr3_loop_cnt_1226:
	.word 0xc6dc2718  ! 1: LDXA_I	ldxa	[%r16, + 0x0718] %asi, %r3
	.word 0xfacc28e8  ! 1: LDSBA_I	ldsba	[%r16, + 0x08e8] %asi, %r29
	.word 0xee5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r23
	.word 0xc68c2867  ! 1: LDUBA_I	lduba	[%r16, + 0x0867] %asi, %r3
	.word 0xde0c2c4f  ! 1: LDUB_I	ldub	[%r16 + 0x0c4f], %r15
	.word 0xf8540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r28
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xeedc2020  ! 1: LDXA_I	ldxa	[%r16, + 0x0020] %asi, %r23
	.word 0xfc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r30
	brnz %r31,thr3_loop_cnt_1226
	dec %r31
        mov 0x66, %r31
thr3_loop_cnt_1227:
	.word 0xdc142fc0  ! 1: LDUH_I	lduh	[%r16 + 0x0fc0], %r14
	.word 0xe6942456  ! 1: LDUHA_I	lduha	[%r16, + 0x0456] %asi, %r19
	.word 0xc64c26cf  ! 1: LDSB_I	ldsb	[%r16 + 0x06cf], %r3
	.word 0xc6542710  ! 1: LDSH_I	ldsh	[%r16 + 0x0710], %r3
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	.word 0xda9429b0  ! 1: LDUHA_I	lduha	[%r16, + 0x09b0] %asi, %r13
	.word 0xc60c2a89  ! 1: LDUB_I	ldub	[%r16 + 0x0a89], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6d42826  ! 1: LDSHA_I	ldsha	[%r16, + 0x0826] %asi, %r3
	.word 0xeacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r21
	.word 0xc6d42316  ! 1: LDSHA_I	ldsha	[%r16, + 0x0316] %asi, %r3
	.word 0xc68c2023  ! 1: LDUBA_I	lduba	[%r16, + 0x0023] %asi, %r3
	brnz %r31,thr3_loop_cnt_1227
	dec %r31
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0x9b2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r13
	.word 0x861c258a  ! 1: XOR_I	xor 	%r16, 0x058a, %r3
        mov 0x3e, %r31
thr3_loop_cnt_1228:
	.word 0xce040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r7
	.word 0xc6042f6c  ! 1: LDUW_I	lduw	[%r16 + 0x0f6c], %r3
	.word 0xc69421cc  ! 1: LDUHA_I	lduha	[%r16, + 0x01cc] %asi, %r3
	.word 0xfccc2eb1  ! 1: LDSBA_I	ldsba	[%r16, + 0x0eb1] %asi, %r30
	.word 0xeacc2f4c  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f4c] %asi, %r21
	.word 0xd0dc2c30  ! 1: LDXA_I	ldxa	[%r16, + 0x0c30] %asi, %r8
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe45c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r18
	.word 0xd8040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r12
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6c42cb4  ! 1: LDSWA_I	ldswa	[%r16, + 0x0cb4] %asi, %r3
	brnz %r31,thr3_loop_cnt_1228
	dec %r31
	.word 0xb4240002  ! 1: SUB_R	sub 	%r16, %r2, %r26
	.word 0xb52c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r26
	.word 0xaa240002  ! 1: SUB_R	sub 	%r16, %r2, %r21
	.word 0xbd343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r30
        mov 0xf, %r31
thr3_loop_cnt_1229:
	.word 0xde442bec  ! 1: LDSW_I	ldsw	[%r16 + 0x0bec], %r15
	.word 0xc6542020  ! 1: LDSH_I	ldsh	[%r16 + 0x0020], %r3
	.word 0xc64c2748  ! 1: LDSB_I	ldsb	[%r16 + 0x0748], %r3
	.word 0xc60c2a3c  ! 1: LDUB_I	ldub	[%r16 + 0x0a3c], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xcc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r6
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1229
	dec %r31
	.word 0x8614271b  ! 1: OR_I	or 	%r16, 0x071b, %r3
	.word 0x9a440002  ! 1: ADDC_R	addc 	%r16, %r2, %r13
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x8634274c  ! 1: ORN_I	orn 	%r16, 0x074c, %r3
        mov 0x67, %r31
thr3_loop_cnt_1230:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xcc440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r6
	.word 0xdc442f0c  ! 1: LDSW_I	ldsw	[%r16 + 0x0f0c], %r14
	.word 0xee140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r23
	.word 0xc64c2832  ! 1: LDSB_I	ldsb	[%r16 + 0x0832], %r3
	.word 0xd4dc20d0  ! 1: LDXA_I	ldxa	[%r16, + 0x00d0] %asi, %r10
	.word 0xc6cc2da6  ! 1: LDSBA_I	ldsba	[%r16, + 0x0da6] %asi, %r3
	.word 0xe44c27ee  ! 1: LDSB_I	ldsb	[%r16 + 0x07ee], %r18
	.word 0xc6c42090  ! 1: LDSWA_I	ldswa	[%r16, + 0x0090] %asi, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xce0421ac  ! 1: LDUW_I	lduw	[%r16 + 0x01ac], %r7
	brnz %r31,thr3_loop_cnt_1230
	dec %r31
	.word 0x863c2fe0  ! 1: XNOR_I	xnor 	%r16, 0x0fe0, %r3
	.word 0xb82c20db  ! 1: ANDN_I	andn 	%r16, 0x00db, %r28
        mov 0x7d, %r31
thr3_loop_cnt_1231:
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	.word 0xe4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r18
	.word 0xc65c2470  ! 1: LDX_I	ldx	[%r16 + 0x0470], %r3
	.word 0xc68422e4  ! 1: LDUWA_I	lduwa	[%r16, + 0x02e4] %asi, %r3
	.word 0xf24c23ec  ! 1: LDSB_I	ldsb	[%r16 + 0x03ec], %r25
	.word 0xec142e94  ! 1: LDUH_I	lduh	[%r16 + 0x0e94], %r22
	.word 0xc6942174  ! 1: LDUHA_I	lduha	[%r16, + 0x0174] %asi, %r3
	.word 0xdc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r14
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xce4c25fe  ! 1: LDSB_I	ldsb	[%r16 + 0x05fe], %r7
	brnz %r31,thr3_loop_cnt_1231
	dec %r31
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0x47, %r31
thr3_loop_cnt_1232:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc65c2388  ! 1: LDX_I	ldx	[%r16 + 0x0388], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xe4cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r18
	.word 0xe2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r17
	.word 0xc6dc22b8  ! 1: LDXA_I	ldxa	[%r16, + 0x02b8] %asi, %r3
	.word 0xeed42022  ! 1: LDSHA_I	ldsha	[%r16, + 0x0022] %asi, %r23
	.word 0xc65c2c78  ! 1: LDX_I	ldx	[%r16 + 0x0c78], %r3
	.word 0xf2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r25
	brnz %r31,thr3_loop_cnt_1232
	dec %r31
	.word 0xa32c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r17
	.word 0x86340002  ! 1: SUBC_R	orn 	%r16, %r2, %r3
	.word 0x9e3c23de  ! 1: XNOR_I	xnor 	%r16, 0x03de, %r15
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
        mov 0x97, %r31
thr3_loop_cnt_1233:
	.word 0xf6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r27
	.word 0xf4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r26
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc6dc2c18  ! 1: LDXA_I	ldxa	[%r16, + 0x0c18] %asi, %r3
	.word 0xd2d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r9
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	brnz %r31,thr3_loop_cnt_1233
	dec %r31
	.word 0x860c2c87  ! 1: AND_I	and 	%r16, 0x0c87, %r3
	.word 0xb63c2984  ! 1: XNOR_I	xnor 	%r16, 0x0984, %r27
	.word 0x863426cf  ! 1: ORN_I	orn 	%r16, 0x06cf, %r3
        mov 0x4d, %r31
thr3_loop_cnt_1234:
	.word 0xd4cc2864  ! 1: LDSBA_I	ldsba	[%r16, + 0x0864] %asi, %r10
	.word 0xde8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r15
	.word 0xfccc202d  ! 1: LDSBA_I	ldsba	[%r16, + 0x002d] %asi, %r30
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xeac42258  ! 1: LDSWA_I	ldswa	[%r16, + 0x0258] %asi, %r21
	.word 0xdadc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r13
	.word 0xd04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r8
	.word 0xd6cc2468  ! 1: LDSBA_I	ldsba	[%r16, + 0x0468] %asi, %r11
	.word 0xf2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r25
	.word 0xfc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r30
	brnz %r31,thr3_loop_cnt_1234
	dec %r31
	.word 0x87341002  ! 1: SRLX_R	srlx	%r16, %r2, %r3
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
	.word 0x86242b63  ! 1: SUB_I	sub 	%r16, 0x0b63, %r3
        mov 0x58, %r31
thr3_loop_cnt_1235:
	.word 0xcc142f54  ! 1: LDUH_I	lduh	[%r16 + 0x0f54], %r6
	.word 0xc61428f8  ! 1: LDUH_I	lduh	[%r16 + 0x08f8], %r3
	.word 0xc6dc2780  ! 1: LDXA_I	ldxa	[%r16, + 0x0780] %asi, %r3
	.word 0xf44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r26
	.word 0xc64c2f36  ! 1: LDSB_I	ldsb	[%r16 + 0x0f36], %r3
	.word 0xd4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r10
	.word 0xce9423ec  ! 1: LDUHA_I	lduha	[%r16, + 0x03ec] %asi, %r7
	.word 0xda0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r13
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xd29429da  ! 1: LDUHA_I	lduha	[%r16, + 0x09da] %asi, %r9
	brnz %r31,thr3_loop_cnt_1235
	dec %r31
	.word 0x862c24a2  ! 1: ANDN_I	andn 	%r16, 0x04a2, %r3
        mov 0x6f, %r31
thr3_loop_cnt_1236:
	.word 0xc6942458  ! 1: LDUHA_I	lduha	[%r16, + 0x0458] %asi, %r3
	.word 0xf8d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r28
	.word 0xda842070  ! 1: LDUWA_I	lduwa	[%r16, + 0x0070] %asi, %r13
	.word 0xc6c4267c  ! 1: LDSWA_I	ldswa	[%r16, + 0x067c] %asi, %r3
	.word 0xd68c296a  ! 1: LDUBA_I	lduba	[%r16, + 0x096a] %asi, %r11
	.word 0xd85c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r12
	.word 0xfa540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r29
	.word 0xd60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r11
	.word 0xe2dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r17
	.word 0xf24c26d9  ! 1: LDSB_I	ldsb	[%r16 + 0x06d9], %r25
	.word 0xea841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r21
	brnz %r31,thr3_loop_cnt_1236
	dec %r31
	.word 0x973c2001  ! 1: SRA_I	sra 	%r16, 0x0001, %r11
        mov 0x1f, %r31
thr3_loop_cnt_1237:
	.word 0xfc842100  ! 1: LDUWA_I	lduwa	[%r16, + 0x0100] %asi, %r30
	.word 0xda0c2f92  ! 1: LDUB_I	ldub	[%r16 + 0x0f92], %r13
	.word 0xce140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r7
	.word 0xe8cc2c01  ! 1: LDSBA_I	ldsba	[%r16, + 0x0c01] %asi, %r20
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xd0cc2177  ! 1: LDSBA_I	ldsba	[%r16, + 0x0177] %asi, %r8
	.word 0xc694200a  ! 1: LDUHA_I	lduha	[%r16, + 0x000a] %asi, %r3
	.word 0xc60c2b41  ! 1: LDUB_I	ldub	[%r16 + 0x0b41], %r3
	brnz %r31,thr3_loop_cnt_1237
	dec %r31
	.word 0xa20c0002  ! 1: AND_R	and 	%r16, %r2, %r17
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0xb03c2439  ! 1: XNOR_I	xnor 	%r16, 0x0439, %r24
        mov 0x70, %r31
thr3_loop_cnt_1238:
	.word 0xc6dc2538  ! 1: LDXA_I	ldxa	[%r16, + 0x0538] %asi, %r3
	.word 0xdc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r14
	.word 0xc6d42320  ! 1: LDSHA_I	ldsha	[%r16, + 0x0320] %asi, %r3
	.word 0xec4c2cfe  ! 1: LDSB_I	ldsb	[%r16 + 0x0cfe], %r22
	.word 0xd6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r11
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf0d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r24
	.word 0xecdc2680  ! 1: LDXA_I	ldxa	[%r16, + 0x0680] %asi, %r22
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1238
	dec %r31
	.word 0xb73c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r27
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0xf, %r31
thr3_loop_cnt_1239:
	.word 0xc6442d4c  ! 1: LDSW_I	ldsw	[%r16 + 0x0d4c], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6d42738  ! 1: LDSHA_I	ldsha	[%r16, + 0x0738] %asi, %r3
	.word 0xc64c2eba  ! 1: LDSB_I	ldsb	[%r16 + 0x0eba], %r3
	.word 0xf4d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r26
	.word 0xd6142b9c  ! 1: LDUH_I	lduh	[%r16 + 0x0b9c], %r11
	.word 0xf21426ba  ! 1: LDUH_I	lduh	[%r16 + 0x06ba], %r25
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	brnz %r31,thr3_loop_cnt_1239
	dec %r31
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
        mov 0x56, %r31
thr3_loop_cnt_1240:
	.word 0xc6042568  ! 1: LDUW_I	lduw	[%r16 + 0x0568], %r3
	.word 0xc60c2ecb  ! 1: LDUB_I	ldub	[%r16 + 0x0ecb], %r3
	.word 0xf0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r24
	.word 0xc694246e  ! 1: LDUHA_I	lduha	[%r16, + 0x046e] %asi, %r3
	.word 0xfc941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r30
	.word 0xc65427d0  ! 1: LDSH_I	ldsh	[%r16 + 0x07d0], %r3
	.word 0xe64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r19
	.word 0xdc442688  ! 1: LDSW_I	ldsw	[%r16 + 0x0688], %r14
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xea8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r21
	brnz %r31,thr3_loop_cnt_1240
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x872c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r3
	.word 0x86242e2c  ! 1: SUB_I	sub 	%r16, 0x0e2c, %r3
	.word 0x961c2356  ! 1: XOR_I	xor 	%r16, 0x0356, %r11
        mov 0x1f, %r31
thr3_loop_cnt_1241:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6942ebe  ! 1: LDUHA_I	lduha	[%r16, + 0x0ebe] %asi, %r3
	.word 0xc6842be4  ! 1: LDUWA_I	lduwa	[%r16, + 0x0be4] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xcec41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r7
	.word 0xc65c2c28  ! 1: LDX_I	ldx	[%r16 + 0x0c28], %r3
	.word 0xc6142448  ! 1: LDUH_I	lduh	[%r16 + 0x0448], %r3
	.word 0xda542f12  ! 1: LDSH_I	ldsh	[%r16 + 0x0f12], %r13
	.word 0xf0842a34  ! 1: LDUWA_I	lduwa	[%r16, + 0x0a34] %asi, %r24
	brnz %r31,thr3_loop_cnt_1241
	dec %r31
	.word 0x863c2949  ! 1: XNOR_I	xnor 	%r16, 0x0949, %r3
	.word 0x9c342540  ! 1: SUBC_I	orn 	%r16, 0x0540, %r14
        mov 0x38, %r31
thr3_loop_cnt_1242:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xde140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r15
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xf25c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r25
	.word 0xc6442358  ! 1: LDSW_I	ldsw	[%r16 + 0x0358], %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6842620  ! 1: LDUWA_I	lduwa	[%r16, + 0x0620] %asi, %r3
	brnz %r31,thr3_loop_cnt_1242
	dec %r31
        mov 0x6b, %r31
thr3_loop_cnt_1243:
	.word 0xc6142d22  ! 1: LDUH_I	lduh	[%r16 + 0x0d22], %r3
	.word 0xe84c2418  ! 1: LDSB_I	ldsb	[%r16 + 0x0418], %r20
	.word 0xd8dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r12
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6dc2f98  ! 1: LDXA_I	ldxa	[%r16, + 0x0f98] %asi, %r3
	.word 0xeacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r21
	.word 0xc6142232  ! 1: LDUH_I	lduh	[%r16 + 0x0232], %r3
	.word 0xc6c42308  ! 1: LDSWA_I	ldswa	[%r16, + 0x0308] %asi, %r3
	brnz %r31,thr3_loop_cnt_1243
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0xa6340002  ! 1: SUBC_R	orn 	%r16, %r2, %r19
	.word 0x9634227b  ! 1: SUBC_I	orn 	%r16, 0x027b, %r11
	.word 0x86040002  ! 1: ADD_R	add 	%r16, %r2, %r3
        mov 0x57, %r31
thr3_loop_cnt_1244:
	.word 0xf2c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r25
	.word 0xc68423d8  ! 1: LDUWA_I	lduwa	[%r16, + 0x03d8] %asi, %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xf484211c  ! 1: LDUWA_I	lduwa	[%r16, + 0x011c] %asi, %r26
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xfa0c244b  ! 1: LDUB_I	ldub	[%r16 + 0x044b], %r29
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xcc5c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r6
	brnz %r31,thr3_loop_cnt_1244
	dec %r31
	.word 0xb3343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r25
	.word 0x87340002  ! 1: SRL_R	srl 	%r16, %r2, %r3
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
        mov 0xa4, %r31
thr3_loop_cnt_1245:
	.word 0xcc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r6
	.word 0xd8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r12
	.word 0xf0042614  ! 1: LDUW_I	lduw	[%r16 + 0x0614], %r24
	.word 0xd89420ba  ! 1: LDUHA_I	lduha	[%r16, + 0x00ba] %asi, %r12
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6d42670  ! 1: LDSHA_I	ldsha	[%r16, + 0x0670] %asi, %r3
	.word 0xf0941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r24
	.word 0xe4542968  ! 1: LDSH_I	ldsh	[%r16 + 0x0968], %r18
	.word 0xf08c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r24
	brnz %r31,thr3_loop_cnt_1245
	dec %r31
	.word 0xbb2c0002  ! 1: SLL_R	sll 	%r16, %r2, %r29
        mov 0x10, %r31
thr3_loop_cnt_1246:
	.word 0xdcdc2db0  ! 1: LDXA_I	ldxa	[%r16, + 0x0db0] %asi, %r14
	.word 0xc6c4261c  ! 1: LDSWA_I	ldswa	[%r16, + 0x061c] %asi, %r3
	.word 0xc6442948  ! 1: LDSW_I	ldsw	[%r16 + 0x0948], %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xf65c27a0  ! 1: LDX_I	ldx	[%r16 + 0x07a0], %r27
	.word 0xe40c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r18
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf8440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r28
	.word 0xc6dc20a8  ! 1: LDXA_I	ldxa	[%r16, + 0x00a8] %asi, %r3
	.word 0xc60c2ddf  ! 1: LDUB_I	ldub	[%r16 + 0x0ddf], %r3
	.word 0xf6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r27
	brnz %r31,thr3_loop_cnt_1246
	dec %r31
        mov 0x2c, %r31
thr3_loop_cnt_1247:
	.word 0xc6c42378  ! 1: LDSWA_I	ldswa	[%r16, + 0x0378] %asi, %r3
	.word 0xd8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r12
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xd2042120  ! 1: LDUW_I	lduw	[%r16 + 0x0120], %r9
	.word 0xeadc2c90  ! 1: LDXA_I	ldxa	[%r16, + 0x0c90] %asi, %r21
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd44c2162  ! 1: LDSB_I	ldsb	[%r16 + 0x0162], %r10
	.word 0xc6d42842  ! 1: LDSHA_I	ldsha	[%r16, + 0x0842] %asi, %r3
	.word 0xcc040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r6
	.word 0xc6042724  ! 1: LDUW_I	lduw	[%r16 + 0x0724], %r3
	brnz %r31,thr3_loop_cnt_1247
	dec %r31
	.word 0x862c20ff  ! 1: ANDN_I	andn 	%r16, 0x00ff, %r3
	.word 0xb0442c9e  ! 1: ADDC_I	addc 	%r16, 0x0c9e, %r24
	.word 0xa42c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r18
	.word 0xac2c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r22
        mov 0x3, %r31
thr3_loop_cnt_1248:
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	.word 0xc60c2026  ! 1: LDUB_I	ldub	[%r16 + 0x0026], %r3
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc68c2ab5  ! 1: LDUBA_I	lduba	[%r16, + 0x0ab5] %asi, %r3
	.word 0xf2040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r25
	.word 0xce440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r7
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xced42378  ! 1: LDSHA_I	ldsha	[%r16, + 0x0378] %asi, %r7
	.word 0xd45c2530  ! 1: LDX_I	ldx	[%r16 + 0x0530], %r10
	.word 0xd8042fe8  ! 1: LDUW_I	lduw	[%r16 + 0x0fe8], %r12
	.word 0xfa142bd8  ! 1: LDUH_I	lduh	[%r16 + 0x0bd8], %r29
	brnz %r31,thr3_loop_cnt_1248
	dec %r31
	.word 0xb414226c  ! 1: OR_I	or 	%r16, 0x026c, %r26
	.word 0xba040002  ! 1: ADD_R	add 	%r16, %r2, %r29
        mov 0x20, %r31
thr3_loop_cnt_1249:
	.word 0xd4540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r10
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xda8c2624  ! 1: LDUBA_I	lduba	[%r16, + 0x0624] %asi, %r13
	.word 0xe48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r18
	.word 0xd8942896  ! 1: LDUHA_I	lduha	[%r16, + 0x0896] %asi, %r12
	.word 0xcc942206  ! 1: LDUHA_I	lduha	[%r16, + 0x0206] %asi, %r6
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xde140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r15
	.word 0xf04c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r24
	brnz %r31,thr3_loop_cnt_1249
	dec %r31
	.word 0x9e3427c5  ! 1: SUBC_I	orn 	%r16, 0x07c5, %r15
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
        mov 0x8b, %r31
thr3_loop_cnt_1250:
	.word 0xc68c2f83  ! 1: LDUBA_I	lduba	[%r16, + 0x0f83] %asi, %r3
	.word 0xc6142f50  ! 1: LDUH_I	lduh	[%r16 + 0x0f50], %r3
	.word 0xc6542b9c  ! 1: LDSH_I	ldsh	[%r16 + 0x0b9c], %r3
	.word 0xc694252c  ! 1: LDUHA_I	lduha	[%r16, + 0x052c] %asi, %r3
	.word 0xc6042b3c  ! 1: LDUW_I	lduw	[%r16 + 0x0b3c], %r3
	.word 0xd04c28c2  ! 1: LDSB_I	ldsb	[%r16 + 0x08c2], %r8
	.word 0xea0c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r21
	.word 0xc6942dc2  ! 1: LDUHA_I	lduha	[%r16, + 0x0dc2] %asi, %r3
	brnz %r31,thr3_loop_cnt_1250
	dec %r31
	.word 0x862c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r3
	.word 0x98440002  ! 1: ADDC_R	addc 	%r16, %r2, %r12
        mov 0x67, %r31
thr3_loop_cnt_1251:
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	.word 0xd6842dcc  ! 1: LDUWA_I	lduwa	[%r16, + 0x0dcc] %asi, %r11
	.word 0xc60427c0  ! 1: LDUW_I	lduw	[%r16 + 0x07c0], %r3
	.word 0xf8941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r28
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xda542006  ! 1: LDSH_I	ldsh	[%r16 + 0x0006], %r13
	.word 0xc61429f6  ! 1: LDUH_I	lduh	[%r16 + 0x09f6], %r3
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xde4c2c88  ! 1: LDSB_I	ldsb	[%r16 + 0x0c88], %r15
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1251
	dec %r31
        mov 0x40, %r31
thr3_loop_cnt_1252:
	.word 0xfc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r30
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xec942ed2  ! 1: LDUHA_I	lduha	[%r16, + 0x0ed2] %asi, %r22
	.word 0xfc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r30
	.word 0xe2440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r17
	.word 0xde4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r15
	.word 0xec8c204f  ! 1: LDUBA_I	lduba	[%r16, + 0x004f] %asi, %r22
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xe25427ec  ! 1: LDSH_I	ldsh	[%r16 + 0x07ec], %r17
	brnz %r31,thr3_loop_cnt_1252
	dec %r31
	.word 0x86142d24  ! 1: OR_I	or 	%r16, 0x0d24, %r3
	.word 0x87343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r3
	.word 0x8d2c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r6
        mov 0x94, %r31
thr3_loop_cnt_1253:
	.word 0xd24423c4  ! 1: LDSW_I	ldsw	[%r16 + 0x03c4], %r9
	.word 0xc6142cac  ! 1: LDUH_I	lduh	[%r16 + 0x0cac], %r3
	.word 0xc604271c  ! 1: LDUW_I	lduw	[%r16 + 0x071c], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xfc142a5c  ! 1: LDUH_I	lduh	[%r16 + 0x0a5c], %r30
	.word 0xcc0429ac  ! 1: LDUW_I	lduw	[%r16 + 0x09ac], %r6
	.word 0xc65420ee  ! 1: LDSH_I	ldsh	[%r16 + 0x00ee], %r3
	.word 0xf60c24cc  ! 1: LDUB_I	ldub	[%r16 + 0x04cc], %r27
	.word 0xfa9427fc  ! 1: LDUHA_I	lduha	[%r16, + 0x07fc] %asi, %r29
	.word 0xda8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r13
	.word 0xd8442a94  ! 1: LDSW_I	ldsw	[%r16 + 0x0a94], %r12
	.word 0xdad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r13
	brnz %r31,thr3_loop_cnt_1253
	dec %r31
	.word 0x953c1002  ! 1: SRAX_R	srax	%r16, %r2, %r10
	.word 0x912c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r8
        mov 0x4e, %r31
thr3_loop_cnt_1254:
	.word 0xe48c251b  ! 1: LDUBA_I	lduba	[%r16, + 0x051b] %asi, %r18
	.word 0xc6842948  ! 1: LDUWA_I	lduwa	[%r16, + 0x0948] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf20c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r25
	.word 0xec542a16  ! 1: LDSH_I	ldsh	[%r16 + 0x0a16], %r22
	.word 0xe4040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r18
	.word 0xc6d421de  ! 1: LDSHA_I	ldsha	[%r16, + 0x01de] %asi, %r3
	.word 0xc6841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1254
	dec %r31
	.word 0xac140002  ! 1: OR_R	or 	%r16, %r2, %r22
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
        mov 0x19, %r31
thr3_loop_cnt_1255:
	.word 0xd4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r10
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc6c428dc  ! 1: LDSWA_I	ldswa	[%r16, + 0x08dc] %asi, %r3
	.word 0xc6d42c74  ! 1: LDSHA_I	ldsha	[%r16, + 0x0c74] %asi, %r3
	brnz %r31,thr3_loop_cnt_1255
	dec %r31
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
	.word 0xac0c2ae8  ! 1: AND_I	and 	%r16, 0x0ae8, %r22
	.word 0x982c0002  ! 1: ANDN_R	andn 	%r16, %r2, %r12
        mov 0x91, %r31
thr3_loop_cnt_1256:
	.word 0xcc841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r6
	.word 0xfa540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r29
	.word 0xc6dc2e48  ! 1: LDXA_I	ldxa	[%r16, + 0x0e48] %asi, %r3
	.word 0xc68c2e8a  ! 1: LDUBA_I	lduba	[%r16, + 0x0e8a] %asi, %r3
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6cc2f74  ! 1: LDSBA_I	ldsba	[%r16, + 0x0f74] %asi, %r3
	.word 0xc6942a2c  ! 1: LDUHA_I	lduha	[%r16, + 0x0a2c] %asi, %r3
	.word 0xdc140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r14
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xdc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r14
	.word 0xd2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r9
	brnz %r31,thr3_loop_cnt_1256
	dec %r31
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
	.word 0xb2040002  ! 1: ADD_R	add 	%r16, %r2, %r25
	.word 0xb0440002  ! 1: ADDC_R	addc 	%r16, %r2, %r24
	.word 0x9e1c2692  ! 1: XOR_I	xor 	%r16, 0x0692, %r15
        mov 0x43, %r31
thr3_loop_cnt_1257:
	.word 0xec842bd0  ! 1: LDUWA_I	lduwa	[%r16, + 0x0bd0] %asi, %r22
	.word 0xfc0c2135  ! 1: LDUB_I	ldub	[%r16 + 0x0135], %r30
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xd4542d36  ! 1: LDSH_I	ldsh	[%r16 + 0x0d36], %r10
	.word 0xf6442934  ! 1: LDSW_I	ldsw	[%r16 + 0x0934], %r27
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc64c2924  ! 1: LDSB_I	ldsb	[%r16 + 0x0924], %r3
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	brnz %r31,thr3_loop_cnt_1257
	dec %r31
        mov 0x57, %r31
thr3_loop_cnt_1258:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xfa0c20ec  ! 1: LDUB_I	ldub	[%r16 + 0x00ec], %r29
	.word 0xce5c22c8  ! 1: LDX_I	ldx	[%r16 + 0x02c8], %r7
	.word 0xc6c42480  ! 1: LDSWA_I	ldswa	[%r16, + 0x0480] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xf8c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r28
	.word 0xda8c2a3e  ! 1: LDUBA_I	lduba	[%r16, + 0x0a3e] %asi, %r13
	.word 0xdc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r14
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xc61429c0  ! 1: LDUH_I	lduh	[%r16 + 0x09c0], %r3
	.word 0xfa142650  ! 1: LDUH_I	lduh	[%r16 + 0x0650], %r29
	brnz %r31,thr3_loop_cnt_1258
	dec %r31
	.word 0x86440002  ! 1: ADDC_R	addc 	%r16, %r2, %r3
	.word 0xaa042bbb  ! 1: ADD_I	add 	%r16, 0x0bbb, %r21
	.word 0x86240002  ! 1: SUB_R	sub 	%r16, %r2, %r3
        mov 0x42, %r31
thr3_loop_cnt_1259:
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xc6d42a32  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a32] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xc69427e2  ! 1: LDUHA_I	lduha	[%r16, + 0x07e2] %asi, %r3
	.word 0xf80423a8  ! 1: LDUW_I	lduw	[%r16 + 0x03a8], %r28
	.word 0xc68c2966  ! 1: LDUBA_I	lduba	[%r16, + 0x0966] %asi, %r3
	.word 0xde540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r15
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xccc41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r6
	.word 0xc6442258  ! 1: LDSW_I	ldsw	[%r16 + 0x0258], %r3
	brnz %r31,thr3_loop_cnt_1259
	dec %r31
	.word 0xb13c0002  ! 1: SRA_R	sra 	%r16, %r2, %r24
        mov 0x73, %r31
thr3_loop_cnt_1260:
	.word 0xfc540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r30
	.word 0xd6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r11
	.word 0xcccc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r6
	.word 0xf00c2a5b  ! 1: LDUB_I	ldub	[%r16 + 0x0a5b], %r24
	.word 0xf8d4236e  ! 1: LDSHA_I	ldsha	[%r16, + 0x036e] %asi, %r28
	.word 0xc65c2a50  ! 1: LDX_I	ldx	[%r16 + 0x0a50], %r3
	.word 0xc68421f0  ! 1: LDUWA_I	lduwa	[%r16, + 0x01f0] %asi, %r3
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xe6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r19
	brnz %r31,thr3_loop_cnt_1260
	dec %r31
	.word 0x8e0c2574  ! 1: AND_I	and 	%r16, 0x0574, %r7
	.word 0xb72c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r27
	.word 0x9f3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r15
	.word 0x90140002  ! 1: OR_R	or 	%r16, %r2, %r8
        mov 0x5, %r31
thr3_loop_cnt_1261:
	.word 0xd65c2050  ! 1: LDX_I	ldx	[%r16 + 0x0050], %r11
	.word 0xe6cc2da7  ! 1: LDSBA_I	ldsba	[%r16, + 0x0da7] %asi, %r19
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xd8042140  ! 1: LDUW_I	lduw	[%r16 + 0x0140], %r12
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xe60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r19
	.word 0xc6c42530  ! 1: LDSWA_I	ldswa	[%r16, + 0x0530] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xc6142484  ! 1: LDUH_I	lduh	[%r16 + 0x0484], %r3
	.word 0xe85c2020  ! 1: LDX_I	ldx	[%r16 + 0x0020], %r20
	.word 0xc6dc2f18  ! 1: LDXA_I	ldxa	[%r16, + 0x0f18] %asi, %r3
	brnz %r31,thr3_loop_cnt_1261
	dec %r31
	.word 0x863c29ec  ! 1: XNOR_I	xnor 	%r16, 0x09ec, %r3
        mov 0xc6, %r31
thr3_loop_cnt_1262:
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xe81429dc  ! 1: LDUH_I	lduh	[%r16 + 0x09dc], %r20
	.word 0xdc5c22d0  ! 1: LDX_I	ldx	[%r16 + 0x02d0], %r14
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xc64c231a  ! 1: LDSB_I	ldsb	[%r16 + 0x031a], %r3
	.word 0xe84c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r20
	.word 0xe40c2cf2  ! 1: LDUB_I	ldub	[%r16 + 0x0cf2], %r18
	.word 0xc6dc25c8  ! 1: LDXA_I	ldxa	[%r16, + 0x05c8] %asi, %r3
	.word 0xd64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r11
	brnz %r31,thr3_loop_cnt_1262
	dec %r31
        mov 0x5c, %r31
thr3_loop_cnt_1263:
	.word 0xcecc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r7
	.word 0xcecc2b31  ! 1: LDSBA_I	ldsba	[%r16, + 0x0b31] %asi, %r7
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xfcc421e4  ! 1: LDSWA_I	ldswa	[%r16, + 0x01e4] %asi, %r30
	.word 0xee8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r23
	.word 0xfa040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r29
	.word 0xc68c2e75  ! 1: LDUBA_I	lduba	[%r16, + 0x0e75] %asi, %r3
	.word 0xf88c2777  ! 1: LDUBA_I	lduba	[%r16, + 0x0777] %asi, %r28
	.word 0xc6dc2de8  ! 1: LDXA_I	ldxa	[%r16, + 0x0de8] %asi, %r3
	brnz %r31,thr3_loop_cnt_1263
	dec %r31
	.word 0x861425a5  ! 1: OR_I	or 	%r16, 0x05a5, %r3
	.word 0x8e3c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r7
	.word 0xad3c1002  ! 1: SRAX_R	srax	%r16, %r2, %r22
	.word 0x87342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r3
        mov 0x69, %r31
thr3_loop_cnt_1264:
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xc694298e  ! 1: LDUHA_I	lduha	[%r16, + 0x098e] %asi, %r3
	.word 0xc6d42e60  ! 1: LDSHA_I	ldsha	[%r16, + 0x0e60] %asi, %r3
	.word 0xce042794  ! 1: LDUW_I	lduw	[%r16 + 0x0794], %r7
	.word 0xde0c2528  ! 1: LDUB_I	ldub	[%r16 + 0x0528], %r15
	.word 0xc61423c0  ! 1: LDUH_I	lduh	[%r16 + 0x03c0], %r3
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xd2540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r9
	.word 0xc65c2a18  ! 1: LDX_I	ldx	[%r16 + 0x0a18], %r3
	brnz %r31,thr3_loop_cnt_1264
	dec %r31
	.word 0x961c2af2  ! 1: XOR_I	xor 	%r16, 0x0af2, %r11
	.word 0x92042d6a  ! 1: ADD_I	add 	%r16, 0x0d6a, %r9
	.word 0x872c2001  ! 1: SLL_I	sll 	%r16, 0x0001, %r3
	.word 0x86042abb  ! 1: ADD_I	add 	%r16, 0x0abb, %r3
        mov 0xa1, %r31
thr3_loop_cnt_1265:
	.word 0xd6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r11
	.word 0xc6dc22a8  ! 1: LDXA_I	ldxa	[%r16, + 0x02a8] %asi, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	.word 0xfacc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r29
	.word 0xe2140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r17
	.word 0xf25428e2  ! 1: LDSH_I	ldsh	[%r16 + 0x08e2], %r25
	.word 0xc6dc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r3
	.word 0xc68c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1265
	dec %r31
	.word 0x863c2b06  ! 1: XNOR_I	xnor 	%r16, 0x0b06, %r3
	.word 0xbb3c0002  ! 1: SRA_R	sra 	%r16, %r2, %r29
	.word 0x873c0002  ! 1: SRA_R	sra 	%r16, %r2, %r3
	.word 0xa42c2a58  ! 1: ANDN_I	andn 	%r16, 0x0a58, %r18
        mov 0xbb, %r31
thr3_loop_cnt_1266:
	.word 0xf4c42a1c  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a1c] %asi, %r26
	.word 0xf4841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r26
	.word 0xe8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r20
	.word 0xc6140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r3
	.word 0xec84221c  ! 1: LDUWA_I	lduwa	[%r16, + 0x021c] %asi, %r22
	.word 0xce440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r7
	.word 0xf4140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r26
	.word 0xce442334  ! 1: LDSW_I	ldsw	[%r16 + 0x0334], %r7
	.word 0xdcd4202e  ! 1: LDSHA_I	ldsha	[%r16, + 0x002e] %asi, %r14
	.word 0xe80c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r20
	.word 0xdcdc2518  ! 1: LDXA_I	ldxa	[%r16, + 0x0518] %asi, %r14
	.word 0xc60c2a20  ! 1: LDUB_I	ldub	[%r16 + 0x0a20], %r3
	brnz %r31,thr3_loop_cnt_1266
	dec %r31
	.word 0x86140002  ! 1: OR_R	or 	%r16, %r2, %r3
	.word 0x872c0002  ! 1: SLL_R	sll 	%r16, %r2, %r3
	.word 0xb32c1002  ! 1: SLLX_R	sllx	%r16, %r2, %r25
        mov 0xc, %r31
thr3_loop_cnt_1267:
	.word 0xd08c2c20  ! 1: LDUBA_I	lduba	[%r16, + 0x0c20] %asi, %r8
	.word 0xd44c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r10
	.word 0xc694200c  ! 1: LDUHA_I	lduha	[%r16, + 0x000c] %asi, %r3
	.word 0xce841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r7
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xfc8c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r30
	.word 0xc64c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r3
	.word 0xf8140002  ! 1: LDUH_R	lduh	[%r16 + %r2], %r28
	.word 0xc6142fca  ! 1: LDUH_I	lduh	[%r16 + 0x0fca], %r3
	.word 0xc6c42a68  ! 1: LDSWA_I	ldswa	[%r16, + 0x0a68] %asi, %r3
	.word 0xd48c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r10
	brnz %r31,thr3_loop_cnt_1267
	dec %r31
	.word 0x8d343001  ! 1: SRLX_I	srlx	%r16, 0x0001, %r6
	.word 0x8e2c25ba  ! 1: ANDN_I	andn 	%r16, 0x05ba, %r7
	.word 0x860c0002  ! 1: AND_R	and 	%r16, %r2, %r3
	.word 0xbd342001  ! 1: SRL_I	srl 	%r16, 0x0001, %r30
        mov 0x90, %r31
thr3_loop_cnt_1268:
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xce44289c  ! 1: LDSW_I	ldsw	[%r16 + 0x089c], %r7
	.word 0xee841002  ! 1: LDUWA_R	lduwa	[%r16, %r2] 0x80, %r23
	.word 0xee942fee  ! 1: LDUHA_I	lduha	[%r16, + 0x0fee] %asi, %r23
	.word 0xcccc25b9  ! 1: LDSBA_I	ldsba	[%r16, + 0x05b9] %asi, %r6
	.word 0xce040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r7
	.word 0xc6d42052  ! 1: LDSHA_I	ldsha	[%r16, + 0x0052] %asi, %r3
	.word 0xc6542e8e  ! 1: LDSH_I	ldsh	[%r16 + 0x0e8e], %r3
	.word 0xc6c4230c  ! 1: LDSWA_I	ldswa	[%r16, + 0x030c] %asi, %r3
	.word 0xc6cc2a62  ! 1: LDSBA_I	ldsba	[%r16, + 0x0a62] %asi, %r3
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1268
	dec %r31
	.word 0x90142ba6  ! 1: OR_I	or 	%r16, 0x0ba6, %r8
	.word 0xaa0c0002  ! 1: AND_R	and 	%r16, %r2, %r21
	.word 0x860c29db  ! 1: AND_I	and 	%r16, 0x09db, %r3
        mov 0x69, %r31
thr3_loop_cnt_1269:
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xe85c2588  ! 1: LDX_I	ldx	[%r16 + 0x0588], %r20
	.word 0xc65c2290  ! 1: LDX_I	ldx	[%r16 + 0x0290], %r3
	.word 0xc60422a4  ! 1: LDUW_I	lduw	[%r16 + 0x02a4], %r3
	.word 0xd28c1002  ! 1: LDUBA_R	lduba	[%r16, %r2] 0x80, %r9
	.word 0xc6440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r3
	.word 0xfc4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r30
	.word 0xc6cc1002  ! 1: LDSBA_R	ldsba	[%r16, %r2] 0x80, %r3
	.word 0xda842f1c  ! 1: LDUWA_I	lduwa	[%r16, + 0x0f1c] %asi, %r13
	brnz %r31,thr3_loop_cnt_1269
	dec %r31
	.word 0x86340002  ! 1: ORN_R	orn 	%r16, %r2, %r3
        mov 0xb2, %r31
thr3_loop_cnt_1270:
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xdc042614  ! 1: LDUW_I	lduw	[%r16 + 0x0614], %r14
	.word 0xc6dc29f0  ! 1: LDXA_I	ldxa	[%r16, + 0x09f0] %asi, %r3
	.word 0xc6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r3
	.word 0xeacc2e90  ! 1: LDSBA_I	ldsba	[%r16, + 0x0e90] %asi, %r21
	.word 0xc61429f0  ! 1: LDUH_I	lduh	[%r16 + 0x09f0], %r3
	.word 0xda042660  ! 1: LDUW_I	lduw	[%r16 + 0x0660], %r13
	.word 0xfa4c257b  ! 1: LDSB_I	ldsb	[%r16 + 0x057b], %r29
	.word 0xc684257c  ! 1: LDUWA_I	lduwa	[%r16, + 0x057c] %asi, %r3
	.word 0xc6d427ae  ! 1: LDSHA_I	ldsha	[%r16, + 0x07ae] %asi, %r3
	brnz %r31,thr3_loop_cnt_1270
	dec %r31
	.word 0x8c140002  ! 1: OR_R	or 	%r16, %r2, %r6
        mov 0x42, %r31
thr3_loop_cnt_1271:
	.word 0xc65c2138  ! 1: LDX_I	ldx	[%r16 + 0x0138], %r3
	.word 0xd2dc2c30  ! 1: LDXA_I	ldxa	[%r16, + 0x0c30] %asi, %r9
	.word 0xc6442b58  ! 1: LDSW_I	ldsw	[%r16 + 0x0b58], %r3
	.word 0xf4941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r26
	.word 0xd0cc25d6  ! 1: LDSBA_I	ldsba	[%r16, + 0x05d6] %asi, %r8
	.word 0xf60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r27
	.word 0xc65c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r3
	.word 0xc60c2b15  ! 1: LDUB_I	ldub	[%r16 + 0x0b15], %r3
	.word 0xc6cc20b6  ! 1: LDSBA_I	ldsba	[%r16, + 0x00b6] %asi, %r3
	.word 0xe6540002  ! 1: LDSH_R	ldsh	[%r16 + %r2], %r19
	.word 0xc6d41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r3
	.word 0xfc442f98  ! 1: LDSW_I	ldsw	[%r16 + 0x0f98], %r30
	brnz %r31,thr3_loop_cnt_1271
	dec %r31
	.word 0xa32c3001  ! 1: SLLX_I	sllx	%r16, 0x0001, %r17
        mov 0x24, %r31
thr3_loop_cnt_1272:
	.word 0xc6040002  ! 1: LDUW_R	lduw	[%r16 + %r2], %r3
	.word 0xe2c42548  ! 1: LDSWA_I	ldswa	[%r16, + 0x0548] %asi, %r17
	.word 0xd0440002  ! 1: LDSW_R	ldsw	[%r16 + %r2], %r8
	.word 0xea442934  ! 1: LDSW_I	ldsw	[%r16 + 0x0934], %r21
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xdc942ef2  ! 1: LDUHA_I	lduha	[%r16, + 0x0ef2] %asi, %r14
	.word 0xf05c2f38  ! 1: LDX_I	ldx	[%r16 + 0x0f38], %r24
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	brnz %r31,thr3_loop_cnt_1272
	dec %r31
	.word 0xb33c3001  ! 1: SRAX_I	srax	%r16, 0x0001, %r25
	.word 0x863c0002  ! 1: XNOR_R	xnor 	%r16, %r2, %r3
        mov 0x7b, %r31
thr3_loop_cnt_1273:
	.word 0xc65c2da0  ! 1: LDX_I	ldx	[%r16 + 0x0da0], %r3
	.word 0xe6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r19
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xe2d42a14  ! 1: LDSHA_I	ldsha	[%r16, + 0x0a14] %asi, %r17
	.word 0xd28c225b  ! 1: LDUBA_I	lduba	[%r16, + 0x025b] %asi, %r9
	.word 0xdc4c23a5  ! 1: LDSB_I	ldsb	[%r16 + 0x03a5], %r14
	.word 0xc6941002  ! 1: LDUHA_R	lduha	[%r16, %r2] 0x80, %r3
	.word 0xdcd41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r14
	.word 0xde942c04  ! 1: LDUHA_I	lduha	[%r16, + 0x0c04] %asi, %r15
	brnz %r31,thr3_loop_cnt_1273
	dec %r31
	.word 0x9c140002  ! 1: OR_R	or 	%r16, %r2, %r14
	.word 0x873c1002  ! 1: SRAX_R	srax	%r16, %r2, %r3
	.word 0x86342e36  ! 1: SUBC_I	orn 	%r16, 0x0e36, %r3
        mov 0x9b, %r31
thr3_loop_cnt_1274:
	.word 0xea4c0002  ! 1: LDSB_R	ldsb	[%r16 + %r2], %r21
	.word 0xe294239a  ! 1: LDUHA_I	lduha	[%r16, + 0x039a] %asi, %r17
	.word 0xc6dc26d8  ! 1: LDXA_I	ldxa	[%r16, + 0x06d8] %asi, %r3
	.word 0xc6c41002  ! 1: LDSWA_R	ldswa	[%r16, %r2] 0x80, %r3
	.word 0xd05c0002  ! 1: LDX_R	ldx	[%r16 + %r2], %r8
	.word 0xc60c0002  ! 1: LDUB_R	ldub	[%r16 + %r2], %r3
	.word 0xc6dc2d90  ! 1: LDXA_I	ldxa	[%r16, + 0x0d90] %asi, %r3
	.word 0xdad41002  ! 1: LDSHA_R	ldsha	[%r16, %r2] 0x80, %r13
	.word 0xdedc1002  ! 1: LDXA_R	ldxa	[%r16, %r2] 0x80, %r15
	.word 0xc65c2d10  ! 1: LDX_I	ldx	[%r16 + 0x0d10], %r3
	brnz %r31,thr3_loop_cnt_1274
	dec %r31
	.word 0xb81c0002  ! 1: XOR_R	xor 	%r16, %r2, %r28
	.word 0xa6442d0b  ! 1: ADDC_I	addc 	%r16, 0x0d0b, %r19
	.word 0xaa3428cb  ! 1: SUBC_I	orn 	%r16, 0x08cb, %r21
	.word 0x862c2334  ! 1: ANDN_I	andn 	%r16, 0x0334, %r3
        mov 0x4f, %r31
th