// Modified by Princeton University on June 9th, 2015
/*
* ========== Copyright Header Begin ==========================================
* 
* OpenSPARC T1 Processor File: tlu_asi_access_mt_2_rand_12_s2.s
* Copyright (c) 2006 Sun Microsystems, Inc.  All Rights Reserved.
* DO NOT ALTER OR REMOVE COPYRIGHT NOTICES.
* 
* The above named program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License version 2 as published by the Free Software Foundation.
* 
* The above named program is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
* 
* You should have received a copy of the GNU General Public
* License along with this work; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
* 
* ========== Copyright Header End ============================================
*/
/*
********************************************************************************
   random seed:	89322208
   Jal tlu_asi_access_mt_2.j:	
********************************************************************************/



#define PCONTEXT	0x10
#define SCONTEXT	0x10

#define MAIN_PAGE_NUCLEUS_ALSO
#define MAIN_PAGE_HV_ALSO

#define ALL_MY_INTR_HANDLERS
#include "my_intr_handlers.s"
#include "my_trap_handlers.s"
#include "tlu_custom_trap_handlers.s"

#include "enable_traps.h"
#include "boot.s"

.text
.global main

main:

	ta 	%icc, T_CHANGE_HPRIV
	mov	0x123, %g1
	wr	%g0, 0x20, %asi
	stxa	%g1, [0x00] %asi
	stxa	%g1, [0x08] %asi
	stxa	%g1, [0x10] %asi
	stxa	%g1, [0x18] %asi
	stxa	%g1, [0x20] %asi
	stxa	%g1, [0x28] %asi
	stxa	%g1, [0x30] %asi
	stxa	%g1, [0x38] %asi
	ta 	%icc, T_CHANGE_NONHPRIV

! Register init code

	setx 0xd1e2062c0000a2f0, %g1, %g0
	setx 0x64e85579000022cc, %g1, %g1
	setx 0x354f5b2a0000c3d4, %g1, %g2
	setx 0xada4ac6100002128, %g1, %g3
	setx 0xa04a438f0000e0b8, %g1, %g4
	setx 0x349989c00000c224, %g1, %g5
	setx 0xadc9f91a00004372, %g1, %g6
	setx 0x7f15ca8900000070, %g1, %g7
	setx 0x2ff0bff100006302, %g1, %r16
	setx 0x547fa1630000824a, %g1, %r17
	setx 0x7d6076a10000c267, %g1, %r18
	setx 0x1f7376cf0000a04e, %g1, %r19
	setx 0xaac455920000e0a8, %g1, %r20
	setx 0x32af130e0000a330, %g1, %r21
	setx 0x97e0f14c0000e0d1, %g1, %r22
	setx 0x89dc62d40000a231, %g1, %r23
	setx 0xb498a83500004357, %g1, %r24
	setx 0xe76074c5000023b0, %g1, %r25
	setx 0xa8dd69820000a14f, %g1, %r26
	setx 0x7288e6fc0000e3b9, %g1, %r27
	setx 0x8472aa9d00004200, %g1, %r28
	setx 0x9f06942b00000229, %g1, %r29
	setx 0x51e68774000021f3, %g1, %r30
	setx 0xcced70d0000060a4, %g1, %r31
	save
	setx 0x8f8444750000c03e, %g1, %r16
	setx 0xdb9b7a3c0000021e, %g1, %r17
	setx 0x8e90c8180000c3f6, %g1, %r18
	setx 0x98d990a80000806b, %g1, %r19
	setx 0x7ec37bb800004140, %g1, %r20
	setx 0xd8cb533d0000e343, %g1, %r21
	setx 0xd3673713000062df, %g1, %r22
	setx 0xed8ff8e40000e1b2, %g1, %r23
	setx 0x26fc244b000022ac, %g1, %r24
	setx 0x3dd086ed00000393, %g1, %r25
	setx 0x49ec7e7900008257, %g1, %r26
	setx 0x2e3e79390000c0df, %g1, %r27
	setx 0x46da6607000060c7, %g1, %r28
	setx 0x6f4ce79300008307, %g1, %r29
	setx 0xf77fb31400000260, %g1, %r30
	setx 0x4482f1c70000c300, %g1, %r31
	save
	setx 0x40dc061f000080b2, %g1, %r16
	setx 0x11eb9f710000a104, %g1, %r17
	setx 0x14d55ade00000329, %g1, %r18
	setx 0x734063040000a2d7, %g1, %r19
	setx 0xc5fc2ece0000213a, %g1, %r20
	setx 0xf1f18ec6000000d5, %g1, %r21
	setx 0xaa3f47a30000222c, %g1, %r22
	setx 0x5eb6734a000003e4, %g1, %r23
	setx 0x1eaeaa9a0000638f, %g1, %r24
	setx 0x911ba8a90000a338, %g1, %r25
	setx 0xfab16caa0000a080, %g1, %r26
	setx 0x429db2720000a030, %g1, %r27
	setx 0x26bcefaf000080bd, %g1, %r28
	setx 0x996245930000c290, %g1, %r29
	setx 0x9b86b64d0000a2a3, %g1, %r30
	setx 0x7fd00a240000e0da, %g1, %r31
	restore
#ifdef PORTABLE_CORE
	mov	PORTABLE_CORE, %g1
	sllx	%g1, 10, %g1
	or	%r8, %g1, %r8
	or	%r9, %g1, %r9
	or	%r10, %g1, %r10
	or	%r11, %g1, %r11
	or	%r12, %g1, %r12
	or	%r13, %g1, %r13
	or	%r14, %g1, %r14
	or	%r15, %g1, %r15
#endif
	mov	0x58, %r16
	mov	0x48, %r17
	mov	0x18, %r18
	mov	0x18, %r19
	mov	0x3c0, %r20
	mov	0x7c8, %r21
	mov	0x3f8, %r22
	mov	0x7c0, %r23
	mov	0x70, %r24
	mov	0x8, %r25
	mov	0x58, %r26
	mov	0x38, %r27
	mov	0, %r28
	mov	0, %r29
	mov	0, %r30
	mov	0, %r31
	ta	%icc, T_CHANGE_HPRIV
	wr	%g0, 0x73, %asi
	stxa	%g0, [%g0] 0x42
	mov	0x38, %g1
	stxa	%g0, [%g1] 0x58
	ta	%icc, T_RD_THID
! fork: source strm = 0xffffffff; target strm = 0x2
	cmp	%o1, 1
	setx	fork_lbl_0_1, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x4
	cmp	%o1, 2
	setx	fork_lbl_0_2, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x8
	cmp	%o1, 3
	setx	fork_lbl_0_3, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
	mov	0x10, %r27
	mov	0x7e8, %r21
	mov	0x30, %r18
	.word 0x87802025  ! 4: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d0, %r23
	.word 0xdcd52000  ! 6: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r14
	.word 0xdc9da000  ! 7: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r14
	mov	0x0, %r16
	.word 0x87802073  ! 9: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d8, %r20
	.word 0xdcbfe000  ! 11: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 12: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 13: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r25
	mov	0x10, %r24
	.word 0xdcaf2000  ! 16: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xd69f4e80  ! 17: LDDA_R	ldda	[%r29, %r0] 0x74, %r11
	mov	0x8, %r27
	.word 0xd6af6000  ! 19: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x20, %r25
	.word 0xd6d7a000  ! 21: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	mov	0x60, %r27
	.word 0xd4b7ce60  ! 23: STHA_R	stha	%r10, [%r31 + %r0] 0x73
	mov	0x3c8, %r21
	.word 0x8780204f  ! 25: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd496a000  ! 26: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r10
	.word 0xd4ae6000  ! 27: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	mov	0x70, %r24
	.word 0xd4be2000  ! 29: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	mov	0x3f8, %r22
	.word 0xd4bea000  ! 31: STDA_I	stda	%r10, [%r26 + 0x0000] %asi
	mov	0x78, %r16
	mov	0x0, %r17
	.word 0x8780204f  ! 34: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r25
	.word 0x87802073  ! 36: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 37: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9f8e80  ! 38: LDDA_R	ldda	[%r30, %r0] 0x74, %r14
	.word 0xd0a70e40  ! 39: STWA_R	stwa	%r8, [%r28 + %r0] 0x72
	mov	0x3c0, %r20
	.word 0xd0bce000  ! 41: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0xd08c2000  ! 42: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0xd0c46000  ! 43: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r8
	mov	0x28, %r16
	mov	0x40, %r16
	.word 0xd0946000  ! 46: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0xd0846000  ! 47: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0x87802025  ! 48: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r24
	.word 0xd0b5a000  ! 50: STHA_I	stha	%r8, [%r22 + 0x0000] %asi
	.word 0x8780204f  ! 51: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r25
	.word 0x87802020  ! 53: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd094e000  ! 54: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0xd0f42000  ! 55: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 56: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdccfce80  ! 57: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r14
	mov	0x40, %r27
	.word 0xdcd66000  ! 59: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r14
	mov	0x38, %r18
	mov	0x3c8, %r23
	.word 0xd0af0e80  ! 62: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	.word 0xd0be2000  ! 63: STDA_I	stda	%r8, [%r24 + 0x0000] %asi
	.word 0xd6ad04a0  ! 64: STBA_R	stba	%r11, [%r20 + %r0] 0x25
	.word 0xd6f62000  ! 65: STXA_I	stxa	%r11, [%r24 + 0x0000] %asi
	mov	0x60, %r19
	.word 0xdec4c400  ! 67: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	.word 0xd4cc4400  ! 68: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r10
	mov	0x3e0, %r20
	.word 0xdcb78e40  ! 70: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xdcae2000  ! 71: STBA_I	stba	%r14, [%r24 + 0x0000] %asi
	.word 0xdcbf8e80  ! 72: STDA_R	stda	%r14, [%r30 + %r0] 0x74
	.word 0xdcaee000  ! 73: STBA_I	stba	%r14, [%r27 + 0x0000] %asi
	.word 0xdcb66000  ! 74: STHA_I	stha	%r14, [%r25 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xdcdee000  ! 76: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r14
	mov	0x18, %r17
	.word 0xd8b6c9e0  ! 78: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	.word 0xd6cd44a0  ! 79: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r11
	.word 0x87802025  ! 80: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 81: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde9f0e40  ! 82: LDDA_R	ldda	[%r28, %r0] 0x72, %r15
	.word 0xdeb7a000  ! 83: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xd6df8e60  ! 84: LDXA_R	ldxa	[%r30, %r0] 0x73, %r11
	.word 0xd6a72000  ! 85: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6976000  ! 86: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	mov	0x7f8, %r22
	.word 0xdacfce60  ! 88: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r13
	.word 0x87802025  ! 89: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a78e60  ! 90: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0xd6ad2000  ! 91: STBA_I	stba	%r11, [%r20 + 0x0000] %asi
	.word 0xd2d78e60  ! 92: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r9
	mov	0x58, %r26
	.word 0x87802020  ! 94: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r23
	.word 0xd08cc400  ! 96: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	.word 0xd0a46000  ! 97: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0xd09c2000  ! 99: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r8
	mov	0x40, %r19
	mov	0x10, %r17
	mov	0x78, %r19
	mov	0x0, %r16
	.word 0xd0dc2000  ! 104: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	.word 0x87802072  ! 105: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa7ce40  ! 106: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	mov	0x68, %r25
	mov	0x3d0, %r20
	.word 0xd4a70e60  ! 109: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	mov	0x30, %r24
	mov	0x60, %r24
	.word 0xd4afa000  ! 112: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd4a40400  ! 113: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	mov	0x3e0, %r21
	.word 0xd2df4e80  ! 115: LDXA_R	ldxa	[%r29, %r0] 0x74, %r9
	.word 0xd2876000  ! 116: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0x87802073  ! 117: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4bf0e60  ! 118: STDA_R	stda	%r10, [%r28 + %r0] 0x73
	.word 0xd487e000  ! 119: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xda9fce60  ! 120: LDDA_R	ldda	[%r31, %r0] 0x73, %r13
	.word 0xda872000  ! 121: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0xda87a000  ! 122: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	mov	0x8, %r27
	mov	0x7f0, %r20
	.word 0xd2af4e60  ! 125: STBA_R	stba	%r9, [%r29 + %r0] 0x73
	.word 0xd0bcc400  ! 126: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0xd09f2000  ! 127: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0xd0afe000  ! 128: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0a72000  ! 129: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xd0a7e000  ! 130: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 131: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xded44400  ! 132: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	.word 0xde9fa000  ! 133: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	mov	0x3d8, %r20
	mov	0x7c8, %r22
	.word 0xd2af8e80  ! 136: STBA_R	stba	%r9, [%r30 + %r0] 0x74
	.word 0xd2a7e000  ! 137: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xdea74e80  ! 138: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	mov	0x7f8, %r23
	.word 0xdedfa000  ! 140: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x50, %r25
	.word 0xd2dc8400  ! 142: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0x87802025  ! 143: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2ac4400  ! 144: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	mov	0x18, %r18
	.word 0xd2d52000  ! 146: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r9
	.word 0xd69f8e40  ! 147: LDDA_R	ldda	[%r30, %r0] 0x72, %r11
	.word 0x87802020  ! 148: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c42000  ! 149: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r11
	.word 0xd6c46000  ! 150: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r11
	mov	0x3e8, %r20
	mov	0x7f8, %r22
	.word 0xdacc4400  ! 153: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	.word 0xd49c4400  ! 154: LDDA_R	ldda	[%r17, %r0] 0x20, %r10
	.word 0x87802072  ! 155: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd297ce40  ! 156: LDUHA_R	lduha	[%r31, %r0] 0x72, %r9
	mov	0x3c8, %r21
	.word 0xd2cf2000  ! 158: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r9
	.word 0xd2a7e000  ! 159: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	mov	0x10, %r25
	.word 0x87802025  ! 161: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cf4e80  ! 162: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r10
	mov	0x10, %r18
	mov	0x50, %r17
	.word 0xd2df8e60  ! 165: LDXA_R	ldxa	[%r30, %r0] 0x73, %r9
	.word 0xd2c5a000  ! 166: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r9
	.word 0xd6f609e0  ! 167: STXA_R	stxa	%r11, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 168: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6be6000  ! 169: STDA_I	stda	%r11, [%r25 + 0x0000] %asi
	.word 0xd696e000  ! 170: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	.word 0x87802073  ! 171: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f7e000  ! 172: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd2af8e80  ! 173: STBA_R	stba	%r9, [%r30 + %r0] 0x74
	mov	0x38, %r25
	mov	0x30, %r18
	.word 0xd2bf8e40  ! 176: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	.word 0xdedfce40  ! 177: LDXA_R	ldxa	[%r31, %r0] 0x72, %r15
	.word 0xdedfe000  ! 178: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xdeb72000  ! 179: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	wr_tick_cmpr_0_0:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xfd, %g2
	or	%g4, 0xd8, %g4
	or	%g6, 0xb0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdeaf2000  ! 181: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xdab6c9e0  ! 183: STHA_R	stha	%r13, [%r27 + %r0] 0x4f
	.word 0xdab7ce80  ! 184: STHA_R	stha	%r13, [%r31 + %r0] 0x74
	.word 0xdaf76000  ! 185: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdade89e0  ! 186: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r13
	.word 0xdaafa000  ! 187: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 188: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08c0400  ! 189: LDUBA_R	lduba	[%r16, %r0] 0x20, %r8
	mov	0x38, %r19
	.word 0xdeb44400  ! 191: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	mov	0x3f0, %r21
	.word 0xd2b78e60  ! 193: STHA_R	stha	%r9, [%r30 + %r0] 0x73
	.word 0x8780204f  ! 194: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2d6e000  ! 195: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r9
	.word 0xd6978e80  ! 196: LDUHA_R	lduha	[%r30, %r0] 0x74, %r11
	mov	0x70, %r25
	.word 0xd6b66000  ! 198: STHA_I	stha	%r11, [%r25 + 0x0000] %asi
	.word 0xd6bf4e80  ! 199: STDA_R	stda	%r11, [%r29 + %r0] 0x74
	mov	0x48, %r26
	mov	0x10, %r27
	.word 0x87802073  ! 202: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r18
	.word 0xd89f8e60  ! 204: LDDA_R	ldda	[%r30, %r0] 0x73, %r12
	.word 0xd0b40400  ! 205: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0x87802020  ! 206: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bf8e40  ! 207: STDA_R	stda	%r10, [%r30 + %r0] 0x72
	.word 0x87802020  ! 208: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9ec9e0  ! 209: LDDA_R	ldda	[%r27, %r0] 0x4f, %r14
	.word 0xdcace000  ! 210: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	mov	0x20, %r19
	.word 0xd6a584a0  ! 212: STWA_R	stwa	%r11, [%r22 + %r0] 0x25
	.word 0x87802072  ! 213: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd68fa000  ! 214: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	mov	0x68, %r25
	mov	0x48, %r16
	.word 0xd68f6000  ! 217: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xd4b48400  ! 218: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd4976000  ! 219: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r10
	.word 0x87802074  ! 220: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4afa000  ! 221: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd4dfe000  ! 222: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4bf6000  ! 223: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd4f7a000  ! 224: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 225: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4aee000  ! 226: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	.word 0xd8f74e80  ! 227: STXA_R	stxa	%r12, [%r29 + %r0] 0x74
	.word 0xd0f7ce40  ! 228: STXA_R	stxa	%r8, [%r31 + %r0] 0x72
	.word 0xd6c40400  ! 229: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r11
	.word 0xda944400  ! 230: LDUHA_R	lduha	[%r17, %r0] 0x20, %r13
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd6d78e60  ! 232: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r11
	mov	0x0, %r25
	.word 0xd69ea000  ! 234: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r11
	mov	0x40, %r27
	.word 0xd4d6c9e0  ! 236: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r10
	mov	0x3c0, %r23
	mov	0x3f0, %r23
	.word 0x87802025  ! 239: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4856000  ! 240: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r10
	.word 0xdaf4c400  ! 241: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xdaf5e000  ! 242: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0xdadd6000  ! 243: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r13
	.word 0xd4f689e0  ! 244: STXA_R	stxa	%r10, [%r26 + %r0] 0x4f
	.word 0xd0a7ce40  ! 245: STWA_R	stwa	%r8, [%r31 + %r0] 0x72
	.word 0x87802072  ! 246: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d8, %r23
	.word 0xd0dfa000  ! 248: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0xd684c400  ! 249: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	.word 0xde970e40  ! 250: LDUHA_R	lduha	[%r28, %r0] 0x72, %r15
	.word 0xdea72000  ! 251: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xdcb40400  ! 252: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xd2b584a0  ! 253: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	mov	0x38, %r26
	.word 0xd89f4e40  ! 255: LDDA_R	ldda	[%r29, %r0] 0x72, %r12
	mov	0x18, %r17
	mov	0x8, %r26
	.word 0xd8bf2000  ! 258: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd8af2000  ! 259: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xdab78e60  ! 260: STHA_R	stha	%r13, [%r30 + %r0] 0x73
	.word 0xdcdf0e80  ! 261: LDXA_R	ldxa	[%r28, %r0] 0x74, %r14
	.word 0xda8f4e60  ! 262: LDUBA_R	lduba	[%r29, %r0] 0x73, %r13
	.word 0xd0bd84a0  ! 263: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0xd08609e0  ! 264: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r8
	.word 0xd0c7ce40  ! 265: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r8
	mov	0x30, %r25
	.word 0xd28ec9e0  ! 267: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r9
	.word 0xd49c4400  ! 268: LDDA_R	ldda	[%r17, %r0] 0x20, %r10
	.word 0xd4bfe000  ! 269: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x50, %r25
	.word 0x87802074  ! 271: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r16
	.word 0xd6bf0e60  ! 273: STDA_R	stda	%r11, [%r28 + %r0] 0x73
	.word 0x87802025  ! 274: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 275: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcdfce40  ! 276: LDXA_R	ldxa	[%r31, %r0] 0x72, %r14
	.word 0xdcdea000  ! 277: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r14
	mov	0x60, %r25
	mov	0x60, %r24
	.word 0xd0a649e0  ! 280: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	.word 0xdcacc400  ! 281: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0xdeb609e0  ! 282: STHA_R	stha	%r15, [%r24 + %r0] 0x4f
	.word 0xd29fce40  ! 283: LDDA_R	ldda	[%r31, %r0] 0x72, %r9
	.word 0xd2de6000  ! 284: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r9
	mov	0x78, %r16
	.word 0xd0ac4400  ! 286: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0xd4bc0400  ! 287: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 288: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 289: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaad84a0  ! 290: STBA_R	stba	%r13, [%r22 + %r0] 0x25
	.word 0xdab52000  ! 291: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	.word 0xdca4c400  ! 292: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	mov	0x18, %r25
	mov	0x7e8, %r23
	mov	0x70, %r27
	.word 0xdec584a0  ! 296: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r15
	.word 0xd8870e80  ! 297: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r12
	mov	0x20, %r16
	.word 0xd2b44400  ! 299: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	mov	0x48, %r16
	.word 0xd295a000  ! 301: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r9
	.word 0xd2ad2000  ! 302: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xd0f7ce60  ! 303: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	.word 0x87802073  ! 304: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c8, %r22
	mov	0x38, %r18
	mov	0x40, %r27
	.word 0x87802072  ! 308: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde9f4e60  ! 309: LDDA_R	ldda	[%r29, %r0] 0x73, %r15
	mov	0x38, %r19
	.word 0x87802020  ! 311: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r24
	.word 0xdeaca000  ! 313: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xdabcc400  ! 314: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	mov	0x3f0, %r21
	mov	0x7f8, %r22
	.word 0xdab4e000  ! 317: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	mov	0x3c8, %r20
	mov	0x58, %r18
	.word 0xd2dc8400  ! 320: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0xd2a46000  ! 321: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	mov	0x3d8, %r20
	mov	0x40, %r27
	mov	0x78, %r27
	.word 0xd2b4a000  ! 325: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0xd2942000  ! 326: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2942000  ! 327: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd0f78e60  ! 328: STXA_R	stxa	%r8, [%r30 + %r0] 0x73
	mov	0x30, %r16
	mov	0x60, %r16
	mov	0x68, %r17
	mov	0x50, %r27
	mov	0x7f8, %r21
	.word 0xd28f0e80  ! 334: LDUBA_R	lduba	[%r28, %r0] 0x74, %r9
	.word 0xd0bc8400  ! 335: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0x87802072  ! 336: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r18
	mov	0x7d8, %r21
	.word 0x87802025  ! 339: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0b48400  ! 340: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	mov	0x30, %r17
	mov	0x38, %r24
	.word 0xd0b5a000  ! 343: STHA_I	stha	%r8, [%r22 + 0x0000] %asi
	mov	0x78, %r27
	mov	0x3d0, %r23
	.word 0x87802074  ! 346: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd08d04a0  ! 347: LDUBA_R	lduba	[%r20, %r0] 0x25, %r8
	.word 0xd0a76000  ! 348: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd28fce80  ! 349: LDUBA_R	lduba	[%r31, %r0] 0x74, %r9
	.word 0xd2872000  ! 350: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	mov	0x10, %r27
	.word 0x87802074  ! 352: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6d48400  ! 353: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0x87802073  ! 354: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r25
	.word 0xd6c72000  ! 356: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0xd69fe000  ! 357: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	.word 0x87802072  ! 358: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2df8e60  ! 359: LDXA_R	ldxa	[%r30, %r0] 0x73, %r9
	.word 0xdca70e80  ! 360: STWA_R	stwa	%r14, [%r28 + %r0] 0x74
	.word 0xd4af0e40  ! 361: STBA_R	stba	%r10, [%r28 + %r0] 0x72
	mov	0x3e0, %r21
	.word 0xd49f6000  ! 363: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0xd4d76000  ! 364: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	mov	0x68, %r27
	.word 0xd0978e40  ! 366: LDUHA_R	lduha	[%r30, %r0] 0x72, %r8
	.word 0xd0f7a000  ! 367: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xdc97ce40  ! 368: LDUHA_R	lduha	[%r31, %r0] 0x72, %r14
	.word 0xdc8fa000  ! 369: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	mov	0x70, %r26
	.word 0xd6f78e60  ! 371: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	.word 0x87802025  ! 372: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6c56000  ! 373: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r11
	.word 0xd6952000  ! 374: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r11
	mov	0x3e0, %r21
	.word 0xd4adc4a0  ! 376: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0xd4ada000  ! 377: STBA_I	stba	%r10, [%r22 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0xd4852000  ! 379: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r10
	.word 0xd49d2000  ! 380: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r10
	.word 0xd0a544a0  ! 381: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	.word 0xd0f52000  ! 382: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	.word 0xd09d6000  ! 383: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r8
	.word 0xd8a74e80  ! 384: STWA_R	stwa	%r12, [%r29 + %r0] 0x74
	mov	0x3c0, %r20
	mov	0x10, %r18
	.word 0xd8ad2000  ! 387: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xd8970e40  ! 389: LDUHA_R	lduha	[%r28, %r0] 0x72, %r12
	.word 0xd2dd04a0  ! 390: LDXA_R	ldxa	[%r20, %r0] 0x25, %r9
	.word 0xdaafce40  ! 391: STBA_R	stba	%r13, [%r31 + %r0] 0x72
	mov	0x78, %r25
	mov	0x7d0, %r23
	.word 0xda8da000  ! 394: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r13
	.word 0xda952000  ! 395: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r13
	.word 0xdab5e000  ! 396: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 397: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdab6a000  ! 398: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	.word 0xdad6e000  ! 399: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r13
	.word 0x87802020  ! 400: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8fce60  ! 401: LDUBA_R	lduba	[%r31, %r0] 0x73, %r15
	.word 0xdec42000  ! 402: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0xdeb46000  ! 403: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0xded4a000  ! 404: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	.word 0x87802025  ! 405: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 406: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f8, %r21
	.word 0xd8d48400  ! 408: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0xdaa70e80  ! 409: STWA_R	stwa	%r13, [%r28 + %r0] 0x74
	.word 0xdabfe000  ! 410: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xda87e000  ! 411: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 412: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabea000  ! 413: STDA_I	stda	%r13, [%r26 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xd6be49e0  ! 415: STDA_R	stda	%r11, [%r25 + %r0] 0x4f
	.word 0xd686a000  ! 416: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r11
	mov	0x7f8, %r21
	mov	0x78, %r17
	.word 0xd28f0e80  ! 419: LDUBA_R	lduba	[%r28, %r0] 0x74, %r9
	.word 0xd6af8e40  ! 420: STBA_R	stba	%r11, [%r30 + %r0] 0x72
	mov	0x60, %r25
	.word 0xd6b66000  ! 422: STHA_I	stha	%r11, [%r25 + 0x0000] %asi
	mov	0x60, %r26
	.word 0xd0bf0e60  ! 424: STDA_R	stda	%r8, [%r28 + %r0] 0x73
	mov	0x18, %r18
	.word 0x87802072  ! 426: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r17
	.word 0xd09fe000  ! 428: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	.word 0xd0a72000  ! 429: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xd6978e80  ! 430: LDUHA_R	lduha	[%r30, %r0] 0x74, %r11
	.word 0x87802025  ! 431: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6ad2000  ! 432: STBA_I	stba	%r11, [%r20 + 0x0000] %asi
	.word 0xd68de000  ! 433: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 434: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd696e000  ! 436: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	mov	0x28, %r26
	.word 0xdcad04a0  ! 438: STBA_R	stba	%r14, [%r20 + %r0] 0x25
	mov	0x3c0, %r22
	.word 0xdcc6e000  ! 440: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r14
	.word 0xd4bf0e80  ! 441: STDA_R	stda	%r10, [%r28 + %r0] 0x74
	.word 0xdef584a0  ! 442: STXA_R	stxa	%r15, [%r22 + %r0] 0x25
	mov	0x68, %r19
	.word 0xdea6a000  ! 444: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	mov	0x18, %r25
	mov	0x60, %r17
	.word 0xdeb6a000  ! 447: STHA_I	stha	%r15, [%r26 + 0x0000] %asi
	.word 0xdadf8e80  ! 448: LDXA_R	ldxa	[%r30, %r0] 0x74, %r13
	mov	0x0, %r18
	.word 0xdaf7ce80  ! 450: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	.word 0x87802020  ! 451: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd895c4a0  ! 452: LDUHA_R	lduha	[%r23, %r0] 0x25, %r12
	mov	0x60, %r27
	.word 0xd8cc2000  ! 454: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r12
	mov	0x58, %r26
	.word 0xd6a4c400  ! 456: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0xd484c400  ! 457: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	mov	0x3e8, %r20
	.word 0xdabf8e40  ! 459: STDA_R	stda	%r13, [%r30 + %r0] 0x72
	.word 0xdacc6000  ! 460: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	.word 0xd6af0e80  ! 461: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	mov	0x3e8, %r22
	.word 0xdabec9e0  ! 463: STDA_R	stda	%r13, [%r27 + %r0] 0x4f
	.word 0xd0aec9e0  ! 464: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	.word 0xd2870e40  ! 465: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r9
	ta	T_CHANGE_PRIV	! macro
	ta	T_CHANGE_HPRIV	! macro
	mov	0x0, %r26
	mov	0x3c8, %r23
	.word 0xd2ac2000  ! 470: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd2c46000  ! 471: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	mov	0x20, %r26
	.word 0xda9c8400  ! 473: LDDA_R	ldda	[%r18, %r0] 0x20, %r13
	.word 0xdab4e000  ! 474: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xd6f584a0  ! 475: STXA_R	stxa	%r11, [%r22 + %r0] 0x25
	.word 0xd69ca000  ! 476: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r11
	.word 0x87802020  ! 477: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bce000  ! 478: STDA_I	stda	%r11, [%r19 + 0x0000] %asi
	.word 0xd6bc6000  ! 479: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0xdab74e40  ! 480: STHA_R	stha	%r13, [%r29 + %r0] 0x72
	.word 0xda942000  ! 481: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0xd6df8e60  ! 482: LDXA_R	ldxa	[%r30, %r0] 0x73, %r11
	ta	T_CHANGE_HPRIV	! macro
	mov	0x3f0, %r21
	.word 0xd89f0e80  ! 485: LDDA_R	ldda	[%r28, %r0] 0x74, %r12
	mov	0x3c0, %r21
	mov	0x7c8, %r20
	.word 0x87802074  ! 488: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d0, %r20
	.word 0xdc94c400  ! 490: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	mov	0x3d0, %r22
	.word 0x87802020  ! 492: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6dfce40  ! 493: LDXA_R	ldxa	[%r31, %r0] 0x72, %r11
	.word 0xd6bc6000  ! 494: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0xd2af0e80  ! 495: STBA_R	stba	%r9, [%r28 + %r0] 0x74
	.word 0xd6878e60  ! 496: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r11
	mov	0x40, %r27
	mov	0x18, %r19
	.word 0xd6b42000  ! 499: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0xd09f0e40  ! 500: LDDA_R	ldda	[%r28, %r0] 0x72, %r8
	.word 0xd28d84a0  ! 501: LDUBA_R	lduba	[%r22, %r0] 0x25, %r9
	mov	0x0, %r24
	.word 0xd2bdc4a0  ! 503: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x78, %r17
	.word 0x87802072  ! 506: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2df6000  ! 507: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0x87802020  ! 508: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabd04a0  ! 509: STDA_R	stda	%r13, [%r20 + %r0] 0x25
	.word 0xdabc8400  ! 510: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	.word 0x87802072  ! 511: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde86c9e0  ! 512: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r15
	.word 0x87802074  ! 513: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4cfce60  ! 514: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r10
	.word 0xd4f7a000  ! 515: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4d44400  ! 516: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0xd4b7a000  ! 517: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd4f7a000  ! 518: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xdeb4c400  ! 519: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xdedfa000  ! 520: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x60, %r19
	.word 0xd68d84a0  ! 522: LDUBA_R	lduba	[%r22, %r0] 0x25, %r11
	mov	0x7f8, %r22
	.word 0xd2cc4400  ! 524: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r9
	.word 0xd2dc8400  ! 525: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0xd2b76000  ! 526: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2b7a000  ! 527: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd4dc0400  ! 528: LDXA_R	ldxa	[%r16, %r0] 0x20, %r10
	wr_tick_cmpr_0_1:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x92, %g2
	or	%g4, 0xca, %g4
	or	%g6, 0xb0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802025  ! 530: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4f5a000  ! 531: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	mov	0x50, %r24
	.word 0xd495e000  ! 533: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r10
	.word 0xdabf8e60  ! 534: STDA_R	stda	%r13, [%r30 + %r0] 0x73
	.word 0xd2f48400  ! 535: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0xd2ad6000  ! 536: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	mov	0x18, %r16
	.word 0xd2bde000  ! 538: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	mov	0x40, %r19
	.word 0xdef78e40  ! 540: STXA_R	stxa	%r15, [%r30 + %r0] 0x72
	.word 0xdab40400  ! 541: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xd6d689e0  ! 542: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r11
	.word 0x87802073  ! 543: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f7e000  ! 544: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	mov	0x28, %r24
	.word 0xd6c7e000  ! 546: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xd48f8e80  ! 547: LDUBA_R	lduba	[%r30, %r0] 0x74, %r10
	.word 0xd4a72000  ! 548: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xdecf8e40  ! 549: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r15
	.word 0x87802020  ! 550: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8e09e0  ! 551: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r13
	mov	0x78, %r26
	.word 0xdadca000  ! 553: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	mov	0x3c8, %r20
	mov	0x78, %r26
	.word 0xdef74e60  ! 556: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	.word 0xded42000  ! 557: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	mov	0x58, %r19
	.word 0xdeace000  ! 559: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xdedc2000  ! 560: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r15
	mov	0x50, %r24
	.word 0x87802073  ! 562: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd88609e0  ! 563: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r12
	mov	0x40, %r25
	.word 0x87802025  ! 565: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8ad2000  ! 566: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	.word 0xd4b7ce80  ! 567: STHA_R	stha	%r10, [%r31 + %r0] 0x74
	.word 0xd8d5c4a0  ! 568: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r12
	.word 0xd89d6000  ! 569: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r12
	.word 0xdeb74e40  ! 570: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	mov	0x58, %r25
	.word 0xd8a70e60  ! 572: STWA_R	stwa	%r12, [%r28 + %r0] 0x73
	mov	0x3c0, %r23
	.word 0x87802020  ! 574: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd69dc4a0  ! 576: LDDA_R	ldda	[%r23, %r0] 0x25, %r11
	mov	0x58, %r18
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd69c2000  ! 579: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r11
	mov	0x60, %r16
	.word 0xd2b78e80  ! 581: STHA_R	stha	%r9, [%r30 + %r0] 0x74
	.word 0xd0840400  ! 582: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	.word 0xd0b4a000  ! 583: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xd49dc4a0  ! 584: LDDA_R	ldda	[%r23, %r0] 0x25, %r10
	mov	0x0, %r27
	.word 0xd484e000  ! 586: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r10
	.word 0xd4bc6000  ! 587: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xd4dc6000  ! 589: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	.word 0xd4f74e60  ! 590: STXA_R	stxa	%r10, [%r29 + %r0] 0x73
	mov	0x18, %r16
	mov	0x30, %r25
	.word 0xde8f0e60  ! 593: LDUBA_R	lduba	[%r28, %r0] 0x73, %r15
	mov	0x3c8, %r21
	.word 0xdca544a0  ! 595: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	mov	0x40, %r17
	.word 0xdcb4a000  ! 597: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xd6d6c9e0  ! 598: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r11
	.word 0xdcbc8400  ! 599: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xdcd46000  ! 600: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	mov	0x0, %r18
	.word 0xdc9ce000  ! 602: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r14
	mov	0x38, %r16
	mov	0x18, %r18
	.word 0xdcb4c400  ! 605: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xd8d7ce80  ! 606: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r12
	.word 0xd2a544a0  ! 607: STWA_R	stwa	%r9, [%r21 + %r0] 0x25
	.word 0x87802072  ! 608: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b76000  ! 609: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2f72000  ! 610: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 611: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f4c400  ! 612: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 613: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b74e80  ! 614: STHA_R	stha	%r8, [%r29 + %r0] 0x74
	.word 0xd096a000  ! 615: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r8
	.word 0xda978e40  ! 616: LDUHA_R	lduha	[%r30, %r0] 0x72, %r13
	.word 0xdaaee000  ! 617: STBA_I	stba	%r13, [%r27 + 0x0000] %asi
	.word 0x87802074  ! 618: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2dd84a0  ! 619: LDXA_R	ldxa	[%r22, %r0] 0x25, %r9
	.word 0xd2af2000  ! 620: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	mov	0x78, %r27
	.word 0x87802025  ! 622: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r16
	mov	0x60, %r27
	.word 0xd8bf8e80  ! 625: STDA_R	stda	%r12, [%r30 + %r0] 0x74
	.word 0xdcf504a0  ! 626: STXA_R	stxa	%r14, [%r20 + %r0] 0x25
	.word 0xdcbd6000  ! 627: STDA_I	stda	%r14, [%r21 + 0x0000] %asi
	.word 0xdcc5a000  ! 628: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r14
	.word 0xdcbd2000  ! 629: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	mov	0x78, %r26
	mov	0x7d0, %r21
	.word 0xdca52000  ! 632: STWA_I	stwa	%r14, [%r20 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xdab40400  ! 634: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xd48f8e40  ! 635: LDUBA_R	lduba	[%r30, %r0] 0x72, %r10
	.word 0xd48de000  ! 636: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r10
	.word 0xdcb44400  ! 637: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	mov	0x10, %r17
	.word 0xdc852000  ! 639: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r14
	.word 0xdeac0400  ! 640: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xdebda000  ! 641: STDA_I	stda	%r15, [%r22 + 0x0000] %asi
	.word 0xd4b584a0  ! 642: STHA_R	stha	%r10, [%r22 + %r0] 0x25
	.word 0xd2c40400  ! 643: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r9
	.word 0xd2b40400  ! 644: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 645: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2ce6000  ! 646: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r9
	.word 0xd8970e80  ! 647: LDUHA_R	lduha	[%r28, %r0] 0x74, %r12
	wr_tick_cmpr_0_2:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x98, %g2
	or	%g4, 0xc8, %g4
	or	%g6, 0xea, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3c8, %r21
	.word 0xd8a6a000  ! 650: STWA_I	stwa	%r12, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 651: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88c2000  ! 652: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	.word 0xd8b4a000  ! 653: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 654: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b46000  ! 655: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 656: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r17
	mov	0x48, %r25
	.word 0xd0bd84a0  ! 659: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	mov	0x78, %r26
	.word 0xd0974e60  ! 661: LDUHA_R	lduha	[%r29, %r0] 0x73, %r8
	.word 0xd09f6000  ! 662: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	.word 0xdcdf8e80  ! 663: LDXA_R	ldxa	[%r30, %r0] 0x74, %r14
	.word 0xdc9fe000  ! 664: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0x87802025  ! 665: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d8, %r22
	mov	0x7e0, %r20
	mov	0x30, %r24
	.word 0xdcada000  ! 669: STBA_I	stba	%r14, [%r22 + 0x0000] %asi
	.word 0xd48f8e60  ! 670: LDUBA_R	lduba	[%r30, %r0] 0x73, %r10
	.word 0xd4a74e40  ! 671: STWA_R	stwa	%r10, [%r29 + %r0] 0x72
	.word 0xd0bdc4a0  ! 672: STDA_R	stda	%r8, [%r23 + %r0] 0x25
	.word 0x87802020  ! 673: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f42000  ! 674: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 675: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 676: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0cfa000  ! 677: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0x87802025  ! 678: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c8, %r20
	.word 0xd8aec9e0  ! 680: STBA_R	stba	%r12, [%r27 + %r0] 0x4f
	mov	0x38, %r24
	.word 0xd8ad2000  ! 682: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	mov	0x8, %r24
	.word 0xd094c400  ! 684: LDUHA_R	lduha	[%r19, %r0] 0x20, %r8
	.word 0xd0b544a0  ! 685: STHA_R	stha	%r8, [%r21 + %r0] 0x25
	.word 0x87802072  ! 686: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 687: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 688: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b689e0  ! 689: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 690: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d0, %r23
	.word 0xdc8e89e0  ! 692: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r14
	mov	0x3c0, %r21
	.word 0xdc952000  ! 694: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r14
	.word 0xd0c70e40  ! 695: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r8
	.word 0xde944400  ! 696: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	.word 0xdedda000  ! 697: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r15
	.word 0xde9d6000  ! 698: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r15
	.word 0x87802025  ! 699: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb56000  ! 700: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	.word 0xde874e80  ! 701: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r15
	mov	0x18, %r17
	.word 0x87802025  ! 703: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8c4400  ! 704: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0xdcdd84a0  ! 705: LDXA_R	ldxa	[%r22, %r0] 0x25, %r14
	.word 0x87802074  ! 706: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcaf2000  ! 707: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdcdfe000  ! 708: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xd0f40400  ! 709: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xd0af2000  ! 710: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	wr_tick_cmpr_0_3:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x85, %g2
	or	%g4, 0xed, %g4
	or	%g6, 0xb6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x78, %r25
	.word 0xd2c48400  ! 713: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0x8780204f  ! 714: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd28e6000  ! 715: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r9
	mov	0x58, %r27
	.word 0xd2c6e000  ! 717: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r9
	.word 0xd2cee000  ! 718: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	.word 0x87802020  ! 719: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r22
	.word 0xd28ce000  ! 721: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	.word 0x87802020  ! 722: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r24
	.word 0xd8d48400  ! 724: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0xd4afce40  ! 725: STBA_R	stba	%r10, [%r31 + %r0] 0x72
	mov	0x28, %r19
	.word 0xd4dc6000  ! 727: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	.word 0x87802074  ! 728: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4df2000  ! 729: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0xd2f70e60  ! 730: STXA_R	stxa	%r9, [%r28 + %r0] 0x73
	.word 0x87802020  ! 731: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r22
	.word 0xd2aca000  ! 733: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0xd4d4c400  ! 734: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	wr_tick_cmpr_0_4:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf1, %g2
	or	%g4, 0xdc, %g4
	or	%g6, 0xec, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdef74e40  ! 736: STXA_R	stxa	%r15, [%r29 + %r0] 0x72
	mov	0x3c8, %r20
	mov	0x78, %r27
	.word 0xd0dc4400  ! 739: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	.word 0xd8a40400  ! 740: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0xd8842000  ! 741: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	mov	0x20, %r26
	.word 0xd884e000  ! 743: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r12
	.word 0xd4b649e0  ! 744: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	.word 0xd4bca000  ! 745: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0xd4bca000  ! 746: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	mov	0x68, %r19
	.word 0xdec544a0  ! 748: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r15
	mov	0x68, %r18
	mov	0x7f0, %r22
	.word 0x87802072  ! 751: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 752: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeaf6000  ! 753: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xdadc4400  ! 754: LDXA_R	ldxa	[%r17, %r0] 0x20, %r13
	.word 0x8780204f  ! 755: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f8, %r21
	mov	0x10, %r27
	mov	0x50, %r18
	.word 0xdc9c8400  ! 759: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0xdcc6a000  ! 760: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r14
	.word 0xd4bf0e80  ! 761: STDA_R	stda	%r10, [%r28 + %r0] 0x74
	.word 0xd4dea000  ! 762: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	.word 0xdeb7ce60  ! 763: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	.word 0xdec74e80  ! 764: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r15
	.word 0x87802074  ! 765: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde872000  ! 766: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xdeaf2000  ! 767: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	mov	0x3f0, %r20
	.word 0x87802074  ! 769: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r17
	.word 0x87802073  ! 771: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4d4c400  ! 772: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0xd48f6000  ! 773: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xd4f76000  ! 774: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4c72000  ! 775: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4a72000  ! 776: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4b7e000  ! 777: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	mov	0x3f8, %r23
	.word 0xd4dfe000  ! 779: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4a7a000  ! 780: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd487a000  ! 781: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	.word 0xd6c504a0  ! 782: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r11
	.word 0xd0f7ce80  ! 783: STXA_R	stxa	%r8, [%r31 + %r0] 0x74
	.word 0xdea7ce40  ! 784: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	mov	0x3e0, %r22
	.word 0xd0878e80  ! 786: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r8
	mov	0x3f8, %r22
	.word 0xd08fa000  ! 788: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	mov	0x10, %r16
	.word 0xd4bf0e60  ! 790: STDA_R	stda	%r10, [%r28 + %r0] 0x73
	.word 0xd4dfa000  ! 791: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	mov	0x7d8, %r22
	mov	0x40, %r18
	.word 0xdebf0e80  ! 794: STDA_R	stda	%r15, [%r28 + %r0] 0x74
	mov	0x50, %r16
	.word 0xdeb7e000  ! 796: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xde9fe000  ! 797: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0xd0de89e0  ! 798: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r8
	.word 0xd087e000  ! 799: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0xd6a7ce60  ! 800: STWA_R	stwa	%r11, [%r31 + %r0] 0x73
	.word 0xd6cf6000  ! 801: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6afa000  ! 802: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x10, %r19
	.word 0xdecf0e60  ! 804: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r15
	.word 0xded76000  ! 805: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	mov	0x48, %r25
	.word 0x87802020  ! 807: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r17
	.word 0xdeb46000  ! 809: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	wr_tick_cmpr_0_5:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe7, %g2
	or	%g4, 0xe2, %g4
	or	%g6, 0xab, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdedce000  ! 811: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r15
	.word 0xdef46000  ! 812: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xde84e000  ! 813: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	.word 0x87802074  ! 814: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb609e0  ! 815: STHA_R	stha	%r14, [%r24 + %r0] 0x4f
	.word 0xd8c504a0  ! 816: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r12
	mov	0x7f8, %r20
	.word 0xd2f48400  ! 818: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0xd6cec9e0  ! 819: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r11
	mov	0x3c8, %r22
	.word 0x87802025  ! 821: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6ad2000  ! 822: STBA_I	stba	%r11, [%r20 + 0x0000] %asi
	.word 0xd4d609e0  ! 823: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r10
	mov	0x70, %r27
	mov	0x28, %r16
	.word 0x87802074  ! 826: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 827: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r17
	mov	0x8, %r27
	.word 0xd4bc6000  ! 830: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	mov	0x50, %r25
	mov	0x7e8, %r22
	mov	0x3e0, %r22
	.word 0xdebf0e60  ! 834: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	.word 0xdadec9e0  ! 835: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r13
	.word 0xd4c7ce80  ! 836: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r10
	mov	0x30, %r27
	.word 0xd4ace000  ! 838: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0xd49ce000  ! 839: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0xd8d74e40  ! 840: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r12
	.word 0xd0ac4400  ! 841: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0xd084e000  ! 842: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	.word 0xd8dc8400  ! 843: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0x87802020  ! 844: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 845: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r19
	mov	0x3c8, %r22
	.word 0x87802020  ! 848: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88c0400  ! 849: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	mov	0x7c8, %r20
	.word 0xdcb4c400  ! 851: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xdcbce000  ! 852: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xdcbc2000  ! 853: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	mov	0x48, %r26
	mov	0x70, %r27
	.word 0xdca42000  ! 856: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 857: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf4e000  ! 858: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xd0940400  ! 859: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	.word 0x8780204f  ! 860: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f62000  ! 861: STXA_I	stxa	%r8, [%r24 + 0x0000] %asi
	.word 0xd0dee000  ! 862: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r8
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdebfce40  ! 864: STDA_R	stda	%r15, [%r31 + %r0] 0x72
	.word 0x87802020  ! 865: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded4a000  ! 866: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	.word 0xdecca000  ! 867: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	.word 0xdef46000  ! 868: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	mov	0x7e0, %r22
	.word 0xdadf8e60  ! 870: LDXA_R	ldxa	[%r30, %r0] 0x73, %r13
	.word 0xda846000  ! 871: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r13
	mov	0x20, %r24
	.word 0x87802074  ! 873: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r24
	mov	0x30, %r18
	.word 0xdaa7ce60  ! 876: STWA_R	stwa	%r13, [%r31 + %r0] 0x73
	.word 0x87802072  ! 877: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 878: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r26
	.word 0x87802072  ! 880: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29c8400  ! 881: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	.word 0xd8bcc400  ! 882: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 883: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 884: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f0, %r22
	.word 0xd8a70e60  ! 886: STWA_R	stwa	%r12, [%r28 + %r0] 0x73
	.word 0xd4a5c4a0  ! 887: STWA_R	stwa	%r10, [%r23 + %r0] 0x25
	.word 0xd49e2000  ! 888: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r10
	mov	0x38, %r18
	.word 0xdea7ce40  ! 890: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	.word 0xd6974e60  ! 891: LDUHA_R	lduha	[%r29, %r0] 0x73, %r11
	.word 0xd69e6000  ! 892: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r11
	.word 0xd6b6a000  ! 893: STHA_I	stha	%r11, [%r26 + 0x0000] %asi
	.word 0xd8c78e40  ! 894: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r12
	.word 0xda9f0e60  ! 895: LDDA_R	ldda	[%r28, %r0] 0x73, %r13
	.word 0xdedf8e40  ! 896: LDXA_R	ldxa	[%r30, %r0] 0x72, %r15
	.word 0xdea66000  ! 897: STWA_I	stwa	%r15, [%r25 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xdece2000  ! 899: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r15
	.word 0x87802074  ! 900: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d8, %r22
	.word 0xdea7a000  ! 902: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	mov	0x3d0, %r23
	mov	0x8, %r26
	.word 0x87802020  ! 905: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 906: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f44400  ! 907: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xdeb689e0  ! 908: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	.word 0xdecce000  ! 909: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	.word 0xdec4e000  ! 910: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	.word 0xdecca000  ! 911: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	.word 0xde84a000  ! 912: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	mov	0x8, %r18
	.word 0xd0df4e80  ! 914: LDXA_R	ldxa	[%r29, %r0] 0x74, %r8
	.word 0x87802025  ! 915: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f0, %r22
	.word 0xd0bd6000  ! 917: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0xd2bf4e80  ! 918: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	.word 0xd2ad2000  ! 919: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xd0c78e80  ! 920: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r8
	.word 0xded689e0  ! 921: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r15
	.word 0xd2b74e40  ! 922: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	.word 0xd2b52000  ! 923: STHA_I	stha	%r9, [%r20 + 0x0000] %asi
	.word 0xd4f6c9e0  ! 924: STXA_R	stxa	%r10, [%r27 + %r0] 0x4f
	mov	0x40, %r25
	mov	0x3e0, %r23
	.word 0xd6f6c9e0  ! 927: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	mov	0x40, %r25
	mov	0x7c0, %r21
	.word 0xd6956000  ! 930: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r11
	.word 0xd6a52000  ! 931: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	.word 0xd69da000  ! 932: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r11
	.word 0xdc8f0e80  ! 933: LDUBA_R	lduba	[%r28, %r0] 0x74, %r14
	mov	0x7d8, %r23
	mov	0x3d8, %r22
	.word 0xdcd56000  ! 936: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r14
	.word 0xd4b74e80  ! 937: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	.word 0xd4dda000  ! 938: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r10
	.word 0xd4852000  ! 939: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r10
	.word 0xd48d2000  ! 940: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	mov	0x10, %r17
	mov	0x30, %r17
	.word 0xd4d52000  ! 943: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r10
	.word 0xd6d7ce60  ! 944: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r11
	.word 0xd6d5a000  ! 945: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r11
	.word 0xd6bfce60  ! 946: STDA_R	stda	%r11, [%r31 + %r0] 0x73
	.word 0xded609e0  ! 947: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r15
	.word 0xdeb52000  ! 948: STHA_I	stha	%r15, [%r20 + 0x0000] %asi
	mov	0x28, %r19
	.word 0xd2b78e40  ! 950: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	mov	0x28, %r27
	.word 0xd28de000  ! 952: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r9
	.word 0xd6978e80  ! 953: LDUHA_R	lduha	[%r30, %r0] 0x74, %r11
	.word 0xdecc4400  ! 954: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r15
	.word 0xdeb5e000  ! 955: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	mov	0x30, %r16
	.word 0xdcbc0400  ! 957: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0x87802074  ! 958: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r19
	.word 0xdcbf6000  ! 960: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 961: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf72000  ! 962: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xd2b7ce60  ! 963: STHA_R	stha	%r9, [%r31 + %r0] 0x73
	.word 0xd287a000  ! 964: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0xd28f2000  ! 965: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	mov	0x7e8, %r20
	.word 0xd2bfa000  ! 967: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 968: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x48, %r25
	mov	0x30, %r18
	.word 0xdccf8e80  ! 971: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r14
	.word 0xdcbe6000  ! 972: STDA_I	stda	%r14, [%r25 + 0x0000] %asi
	mov	0x20, %r16
	mov	0x0, %r24
	.word 0x87802072  ! 975: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcc76000  ! 976: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xdad48400  ! 977: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0xd2b70e40  ! 978: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	.word 0xd2afa000  ! 979: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xda8ec9e0  ! 980: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r13
	.word 0xd487ce80  ! 981: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r10
	.word 0x87802025  ! 982: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 983: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r16
	.word 0xd4a7ce40  ! 985: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	.word 0xd4d76000  ! 986: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0xd6adc4a0  ! 987: STBA_R	stba	%r11, [%r23 + %r0] 0x25
	.word 0xd6afe000  ! 988: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xd6afa000  ! 990: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x7d0, %r20
	ta	T_CHANGE_PRIV	! macro
	.word 0xd0b70e80  ! 993: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	.word 0xdec689e0  ! 994: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r15
	.word 0x87802020  ! 995: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r22
	.word 0xd6b70e60  ! 997: STHA_R	stha	%r11, [%r28 + %r0] 0x73
	.word 0x8780204f  ! 998: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 999: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r26
	.word 0xd697a000  ! 1001: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	mov	0x58, %r19
	.word 0x87802072  ! 1003: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r26
	.word 0x87802025  ! 1005: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6870e80  ! 1006: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r11
	mov	0x7f0, %r21
	.word 0xd685e000  ! 1008: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r11
	mov	0x40, %r18
	mov	0x60, %r16
	.word 0xdcdcc400  ! 1011: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	.word 0xdc8d6000  ! 1012: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r14
	.word 0xdc9c8400  ! 1013: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0x87802020  ! 1014: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb4a000  ! 1015: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 1016: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1017: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc946000  ! 1018: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r14
	.word 0x87802020  ! 1019: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08f0e60  ! 1020: LDUBA_R	lduba	[%r28, %r0] 0x73, %r8
	.word 0xd0f46000  ! 1021: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xd29544a0  ! 1022: LDUHA_R	lduha	[%r21, %r0] 0x25, %r9
	mov	0x7f0, %r23
	mov	0x78, %r25
	.word 0xd2942000  ! 1025: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2cc6000  ! 1026: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	mov	0x0, %r18
	.word 0xd28ca000  ! 1028: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2a42000  ! 1029: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	.word 0xd2bca000  ! 1030: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	.word 0xdcb74e40  ! 1031: STHA_R	stha	%r14, [%r29 + %r0] 0x72
	.word 0xde8f8e80  ! 1032: LDUBA_R	lduba	[%r30, %r0] 0x74, %r15
	.word 0xd0c7ce80  ! 1033: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r8
	.word 0xda870e60  ! 1034: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r13
	.word 0xded48400  ! 1035: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	.word 0xde8ca000  ! 1036: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0xdabc0400  ! 1037: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	mov	0x68, %r16
	.word 0xd8dc0400  ! 1039: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0xd8ace000  ! 1040: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	mov	0x50, %r26
	mov	0x7d0, %r22
	.word 0xd2bf8e80  ! 1043: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	mov	0x3f0, %r23
	.word 0xd094c400  ! 1045: LDUHA_R	lduha	[%r19, %r0] 0x20, %r8
	.word 0xd084a000  ! 1046: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	.word 0xd88f8e80  ! 1047: LDUBA_R	lduba	[%r30, %r0] 0x74, %r12
	mov	0x18, %r19
	.word 0xd8ac2000  ! 1049: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	mov	0x78, %r16
	.word 0xd8a4a000  ! 1051: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd88c6000  ! 1052: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	.word 0xd2c78e60  ! 1053: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r9
	.word 0xd28ce000  ! 1054: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1055: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1056: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 1057: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c46000  ! 1058: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0xd2bca000  ! 1059: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	.word 0xd2f46000  ! 1060: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2f46000  ! 1061: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2cc2000  ! 1062: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r9
	.word 0xd2cc6000  ! 1063: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	mov	0x38, %r18
	.word 0xd2c46000  ! 1065: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0xd28c6000  ! 1066: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0xd8b70e40  ! 1067: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0xd8b46000  ! 1068: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	mov	0x28, %r17
	.word 0xd8bc6000  ! 1070: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 1071: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r26
	mov	0x58, %r26
	.word 0xdac70e80  ! 1074: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r13
	.word 0x87802072  ! 1075: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda972000  ! 1076: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0xda876000  ! 1077: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0xdaaf6000  ! 1078: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xd0f649e0  ! 1079: STXA_R	stxa	%r8, [%r25 + %r0] 0x4f
	mov	0x58, %r25
	.word 0xd0bfe000  ! 1081: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd0afe000  ! 1082: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	mov	0x48, %r19
	.word 0xd0b544a0  ! 1084: STHA_R	stha	%r8, [%r21 + %r0] 0x25
	wr_tick_cmpr_0_6:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xab, %g2
	or	%g4, 0xa3, %g4
	or	%g6, 0xb8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0f7a000  ! 1086: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	mov	0x60, %r24
	mov	0x3d8, %r22
	.word 0xd4878e80  ! 1089: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r10
	.word 0xd4a544a0  ! 1090: STWA_R	stwa	%r10, [%r21 + %r0] 0x25
	.word 0xd4cf2000  ! 1091: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd2940400  ! 1092: LDUHA_R	lduha	[%r16, %r0] 0x20, %r9
	mov	0x8, %r17
	wr_tick_cmpr_0_7:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x99, %g2
	or	%g4, 0xe8, %g4
	or	%g6, 0xdb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2dfa000  ! 1095: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1096: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28c6000  ! 1097: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0xd29ce000  ! 1098: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	mov	0x0, %r19
	mov	0x70, %r27
	.word 0xd2a4a000  ! 1101: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	mov	0x20, %r16
	.word 0x8780204f  ! 1103: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6df0e80  ! 1104: LDXA_R	ldxa	[%r28, %r0] 0x74, %r11
	.word 0xdedf4e40  ! 1105: LDXA_R	ldxa	[%r29, %r0] 0x72, %r15
	.word 0xded6a000  ! 1106: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r15
	mov	0x8, %r24
	.word 0x87802020  ! 1108: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeac6000  ! 1109: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xdec4e000  ! 1110: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	ta	T_CHANGE_PRIV	! macro
	.word 0xdef42000  ! 1112: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 1113: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68f8e40  ! 1114: LDUBA_R	lduba	[%r30, %r0] 0x72, %r11
	.word 0xd6b42000  ! 1115: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0xd8b40400  ! 1116: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xdaac4400  ! 1117: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	.word 0xdaa4a000  ! 1118: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xdaf4e000  ! 1119: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xda9c2000  ! 1120: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	.word 0xda846000  ! 1121: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r13
	.word 0xdef4c400  ! 1122: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	mov	0x10, %r24
	.word 0xdeac2000  ! 1124: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xdecca000  ! 1125: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	.word 0xdea42000  ! 1126: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	mov	0x78, %r25
	.word 0xd4c40400  ! 1128: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	mov	0x7e8, %r23
	.word 0xd4cca000  ! 1130: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r10
	mov	0x3f8, %r20
	.word 0xd4a42000  ! 1132: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 1133: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f40400  ! 1134: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xde9c4400  ! 1135: LDDA_R	ldda	[%r17, %r0] 0x20, %r15
	.word 0xdef72000  ! 1136: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 1137: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xded72000  ! 1138: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xd2dc4400  ! 1139: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xdc9e09e0  ! 1140: LDDA_R	ldda	[%r24, %r0] 0x4f, %r14
	.word 0x87802025  ! 1141: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c0, %r23
	mov	0x10, %r26
	.word 0xdcf5e000  ! 1144: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 1145: WRASI_I	wr	%r0, 0x0072, %asi
	wr_tick_cmpr_0_8:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe4, %g2
	or	%g4, 0xd6, %g4
	or	%g6, 0xca, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x20, %r25
	.word 0xdcb7a000  ! 1148: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xdcd544a0  ! 1149: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r14
	.word 0x87802025  ! 1150: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r16
	.word 0xdcade000  ! 1152: STBA_I	stba	%r14, [%r23 + 0x0000] %asi
	.word 0xdcdda000  ! 1153: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r14
	.word 0xdcc56000  ! 1154: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r14
	ta	T_CHANGE_PRIV	! macro
	.word 0xdcdd6000  ! 1156: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r14
	.word 0xdcbda000  ! 1157: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	.word 0xd2acc400  ! 1158: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0x87802072  ! 1159: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r19
	.word 0xdeacc400  ! 1161: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	mov	0x3c0, %r21
	mov	0x60, %r19
	.word 0xdeadc4a0  ! 1164: STBA_R	stba	%r15, [%r23 + %r0] 0x25
	mov	0x60, %r26
	.word 0xd48c0400  ! 1166: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	.word 0xd4a78e40  ! 1167: STWA_R	stwa	%r10, [%r30 + %r0] 0x72
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xde8d44a0  ! 1169: LDUBA_R	lduba	[%r21, %r0] 0x25, %r15
	mov	0x0, %r17
	.word 0xdef76000  ! 1171: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdea7e000  ! 1172: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xdef72000  ! 1173: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xd2ce89e0  ! 1174: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r9
	.word 0xd2b7a000  ! 1175: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	mov	0x18, %r19
	.word 0xda840400  ! 1177: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	mov	0x3e0, %r22
	.word 0x87802073  ! 1179: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd48c8400  ! 1180: LDUBA_R	lduba	[%r18, %r0] 0x20, %r10
	.word 0x87802074  ! 1181: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r17
	mov	0x30, %r27
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6848400  ! 1185: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	.word 0xd0bf8e40  ! 1186: STDA_R	stda	%r8, [%r30 + %r0] 0x72
	.word 0xd0af8e40  ! 1187: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	mov	0x20, %r27
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802020  ! 1190: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1191: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdccfce60  ! 1192: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r14
	.word 0x87802072  ! 1193: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc97a000  ! 1194: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	.word 0xdcbfa000  ! 1195: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xd0cf4e80  ! 1196: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r8
	.word 0xd0bf4e40  ! 1197: STDA_R	stda	%r8, [%r29 + %r0] 0x72
	.word 0xd2f74e80  ! 1198: STXA_R	stxa	%r9, [%r29 + %r0] 0x74
	.word 0xd2b7a000  ! 1199: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd08e09e0  ! 1200: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r8
	.word 0xd0bfa000  ! 1201: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0xd0d584a0  ! 1202: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r8
	.word 0xd09f2000  ! 1203: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0xd09f6000  ! 1204: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	.word 0xd6b40400  ! 1205: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xd6cfa000  ! 1206: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	mov	0x58, %r26
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd69f6000  ! 1209: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	.word 0xd6b649e0  ! 1210: STHA_R	stha	%r11, [%r25 + %r0] 0x4f
	mov	0x10, %r27
	mov	0x8, %r19
	.word 0xd6af2000  ! 1213: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x7c8, %r21
	.word 0xd6b76000  ! 1215: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 1216: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6de2000  ! 1217: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r11
	.word 0xd6cea000  ! 1218: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	.word 0xd6b66000  ! 1219: STHA_I	stha	%r11, [%r25 + 0x0000] %asi
	.word 0xd0cf4e40  ! 1220: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	.word 0xd0b66000  ! 1221: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	.word 0xd4af8e60  ! 1222: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	mov	0x30, %r25
	.word 0xd4bee000  ! 1224: STDA_I	stda	%r10, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 1225: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r22
	.word 0x87802073  ! 1227: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r19
	.word 0xdec70e60  ! 1229: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r15
	.word 0xdecc0400  ! 1230: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r15
	mov	0x3f8, %r21
	.word 0xdaaf4e80  ! 1232: STBA_R	stba	%r13, [%r29 + %r0] 0x74
	mov	0x3c8, %r20
	mov	0x7e8, %r22
	mov	0x58, %r24
	.word 0xdcd6c9e0  ! 1236: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r14
	mov	0x3c0, %r21
	.word 0xd0a584a0  ! 1238: STWA_R	stwa	%r8, [%r22 + %r0] 0x25
	.word 0xd0f7e000  ! 1239: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1240: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1241: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r17
	.word 0xd295c4a0  ! 1243: LDUHA_R	lduha	[%r23, %r0] 0x25, %r9
	mov	0x7e0, %r21
	.word 0xd2876000  ! 1245: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2af6000  ! 1246: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd2c7a000  ! 1247: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2bf6000  ! 1248: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd2bf2000  ! 1249: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd2df0e60  ! 1250: LDXA_R	ldxa	[%r28, %r0] 0x73, %r9
	.word 0x87802073  ! 1251: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r19
	.word 0xdcdc8400  ! 1253: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	.word 0xdc8fa000  ! 1254: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdc8fe000  ! 1255: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xdcb76000  ! 1256: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xd8b40400  ! 1257: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xd8cfa000  ! 1258: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	wr_tick_cmpr_0_9:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xbf, %g2
	or	%g4, 0xff, %g4
	or	%g6, 0xae, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdc848400  ! 1260: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	.word 0xdc8fe000  ! 1261: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xdc970e60  ! 1262: LDUHA_R	lduha	[%r28, %r0] 0x73, %r14
	.word 0xdccf6000  ! 1263: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xd6adc4a0  ! 1264: STBA_R	stba	%r11, [%r23 + %r0] 0x25
	mov	0x70, %r16
	mov	0x18, %r18
	.word 0xdcac8400  ! 1267: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xd4b44400  ! 1268: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	wr_tick_cmpr_0_10:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xdd, %g2
	or	%g4, 0xed, %g4
	or	%g6, 0xaf, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4f76000  ! 1270: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 1271: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 1272: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4956000  ! 1273: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r10
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7c8, %r21
	.word 0xd2af0e60  ! 1276: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	.word 0x87802072  ! 1277: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1278: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r16
	mov	0x3c0, %r21
	.word 0xd28ca000  ! 1281: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0x87802074  ! 1282: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd88fce80  ! 1283: LDUBA_R	lduba	[%r31, %r0] 0x74, %r12
	.word 0xd8c72000  ! 1284: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd0874e80  ! 1285: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r8
	mov	0x8, %r17
	.word 0x87802074  ! 1287: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0df6000  ! 1288: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0x87802074  ! 1289: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdead04a0  ! 1290: STBA_R	stba	%r15, [%r20 + %r0] 0x25
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x18, %r16
	.word 0xd6dc0400  ! 1293: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	.word 0x87802073  ! 1294: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f7ce60  ! 1295: STXA_R	stxa	%r11, [%r31 + %r0] 0x73
	.word 0xd6ccc400  ! 1296: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	.word 0xd6a7a000  ! 1297: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	mov	0x20, %r25
	.word 0xdcaf8e80  ! 1299: STBA_R	stba	%r14, [%r30 + %r0] 0x74
	.word 0xdca76000  ! 1300: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xd0bc4400  ! 1301: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	mov	0x3e0, %r22
	.word 0x87802025  ! 1303: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1304: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r21
	.word 0xd0842000  ! 1306: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r8
	.word 0xd0b649e0  ! 1307: STHA_R	stha	%r8, [%r25 + %r0] 0x4f
	mov	0x60, %r17
	.word 0x87802025  ! 1309: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r25
	.word 0xd8c74e60  ! 1311: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r12
	.word 0xd8dde000  ! 1312: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r12
	.word 0xdecf4e80  ! 1313: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r15
	mov	0x20, %r17
	.word 0xdeade000  ! 1315: STBA_I	stba	%r15, [%r23 + 0x0000] %asi
	.word 0xdaa7ce40  ! 1316: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	mov	0x60, %r17
	mov	0x10, %r26
	.word 0x87802020  ! 1319: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8689e0  ! 1320: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r15
	.word 0xd88d04a0  ! 1321: LDUBA_R	lduba	[%r20, %r0] 0x25, %r12
	.word 0xd4bcc400  ! 1322: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0xd4bca000  ! 1323: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0xd4ace000  ! 1324: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0xd4842000  ! 1325: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	mov	0x10, %r16
	.word 0xd4f649e0  ! 1327: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	.word 0xd4f46000  ! 1328: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 1329: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08d44a0  ! 1330: LDUBA_R	lduba	[%r21, %r0] 0x25, %r8
	.word 0xd0d4e000  ! 1331: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	.word 0xda8d04a0  ! 1332: LDUBA_R	lduba	[%r20, %r0] 0x25, %r13
	mov	0x50, %r19
	.word 0xda9c6000  ! 1334: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	wr_tick_cmpr_0_11:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x94, %g2
	or	%g4, 0xaf, %g4
	or	%g6, 0xe6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802025  ! 1336: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdadde000  ! 1337: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r13
	.word 0xd89ec9e0  ! 1338: LDDA_R	ldda	[%r27, %r0] 0x4f, %r12
	.word 0xd8f56000  ! 1339: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	.word 0xd8f44400  ! 1340: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xd8b52000  ! 1341: STHA_I	stha	%r12, [%r20 + 0x0000] %asi
	.word 0xda944400  ! 1342: LDUHA_R	lduha	[%r17, %r0] 0x20, %r13
	.word 0xdaf52000  ! 1343: STXA_I	stxa	%r13, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 1344: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca4c400  ! 1345: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	mov	0x50, %r25
	mov	0x40, %r17
	.word 0xdcc42000  ! 1348: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r14
	.word 0xdc94a000  ! 1349: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xd0a609e0  ! 1350: STWA_R	stwa	%r8, [%r24 + %r0] 0x4f
	mov	0x7c8, %r20
	mov	0x8, %r27
	.word 0xd0bce000  ! 1353: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0xd0ac6000  ! 1354: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0xdc87ce60  ! 1355: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r14
	.word 0xdc94e000  ! 1356: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	mov	0x7c0, %r22
	.word 0xd6c609e0  ! 1358: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r11
	.word 0x87802020  ! 1359: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r22
	.word 0xd6ac6000  ! 1361: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	mov	0x78, %r16
	.word 0x87802020  ! 1363: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f4e000  ! 1364: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	mov	0x0, %r24
	.word 0xdea70e40  ! 1366: STWA_R	stwa	%r15, [%r28 + %r0] 0x72
	.word 0x87802074  ! 1367: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f584a0  ! 1368: STXA_R	stxa	%r12, [%r22 + %r0] 0x25
	.word 0xd8b72000  ! 1369: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 1370: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdadf0e80  ! 1371: LDXA_R	ldxa	[%r28, %r0] 0x74, %r13
	.word 0xd2a609e0  ! 1372: STWA_R	stwa	%r9, [%r24 + %r0] 0x4f
	.word 0xd2876000  ! 1373: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xd08544a0  ! 1374: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r8
	mov	0x7c8, %r20
	.word 0xd8970e80  ! 1376: LDUHA_R	lduha	[%r28, %r0] 0x74, %r12
	.word 0xd8f76000  ! 1377: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xdcbe09e0  ! 1378: STDA_R	stda	%r14, [%r24 + %r0] 0x4f
	.word 0xdcbe89e0  ! 1379: STDA_R	stda	%r14, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 1380: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1381: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r18
	.word 0xd8b74e40  ! 1383: STHA_R	stha	%r12, [%r29 + %r0] 0x72
	.word 0xd6b78e80  ! 1384: STHA_R	stha	%r11, [%r30 + %r0] 0x74
	.word 0xd6942000  ! 1385: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r11
	.word 0x87802074  ! 1386: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 1387: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r27
	mov	0x7e8, %r20
	.word 0xdab6c9e0  ! 1390: STHA_R	stha	%r13, [%r27 + %r0] 0x4f
	.word 0xd4b40400  ! 1391: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0xd0f44400  ! 1392: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd2bcc400  ! 1393: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xdc8f4e60  ! 1394: LDUBA_R	lduba	[%r29, %r0] 0x73, %r14
	mov	0x28, %r18
	.word 0xdcf74e80  ! 1396: STXA_R	stxa	%r14, [%r29 + %r0] 0x74
	.word 0xdcd72000  ! 1397: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	mov	0x40, %r16
	.word 0x87802020  ! 1399: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r24
	mov	0x68, %r27
	.word 0xd2f70e60  ! 1402: STXA_R	stxa	%r9, [%r28 + %r0] 0x73
	.word 0xd2978e80  ! 1403: LDUHA_R	lduha	[%r30, %r0] 0x74, %r9
	.word 0xdca48400  ! 1404: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	mov	0x28, %r19
	.word 0xdcad84a0  ! 1406: STBA_R	stba	%r14, [%r22 + %r0] 0x25
	.word 0xdc84e000  ! 1407: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r14
	.word 0xd285c4a0  ! 1408: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r9
	.word 0xd2bca000  ! 1409: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	.word 0xdcbd84a0  ! 1410: STDA_R	stda	%r14, [%r22 + %r0] 0x25
	mov	0x58, %r18
	mov	0x10, %r17
	.word 0xdc8ca000  ! 1413: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r14
	.word 0xd6bfce40  ! 1414: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	.word 0xd6f4a000  ! 1415: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 1416: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b48400  ! 1417: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd0acc400  ! 1418: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd0f70e40  ! 1419: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	.word 0xd0bf6000  ! 1420: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	mov	0x7f8, %r23
	.word 0xd097a000  ! 1422: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	.word 0xd0c76000  ! 1423: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0x87802072  ! 1424: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0c76000  ! 1425: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0af6000  ! 1426: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1427: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ac8400  ! 1428: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	mov	0x60, %r26
	.word 0xde8f4e80  ! 1430: LDUBA_R	lduba	[%r29, %r0] 0x74, %r15
	wr_tick_cmpr_0_12:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xfe, %g2
	or	%g4, 0xbf, %g4
	or	%g6, 0xe6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7f0, %r20
	.word 0x8780204f  ! 1433: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde9e6000  ! 1434: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r15
	.word 0x87802072  ! 1435: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde872000  ! 1436: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xd49c4400  ! 1437: LDDA_R	ldda	[%r17, %r0] 0x20, %r10
	.word 0x87802072  ! 1438: WRASI_I	wr	%r0, 0x0072, %asi
	wr_tick_cmpr_0_13:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xcf, %g2
	or	%g4, 0x8a, %g4
	or	%g6, 0xa4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0bf0e60  ! 1440: STDA_R	stda	%r8, [%r28 + %r0] 0x73
	.word 0xd0dfe000  ! 1441: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	mov	0x3e8, %r21
	.word 0xd09f2000  ! 1443: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0x87802072  ! 1444: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0bf6000  ! 1445: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd48d44a0  ! 1446: LDUBA_R	lduba	[%r21, %r0] 0x25, %r10
	.word 0xd09504a0  ! 1447: LDUHA_R	lduha	[%r20, %r0] 0x25, %r8
	.word 0xd09f6000  ! 1448: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	mov	0x78, %r25
	mov	0x3e0, %r23
	mov	0x28, %r19
	.word 0xd4ad04a0  ! 1452: STBA_R	stba	%r10, [%r20 + %r0] 0x25
	.word 0xd4b76000  ! 1453: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd49f2000  ! 1454: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd09c4400  ! 1455: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	mov	0x3e0, %r21
	.word 0x87802072  ! 1457: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29e09e0  ! 1458: LDDA_R	ldda	[%r24, %r0] 0x4f, %r9
	.word 0xd2b7a000  ! 1459: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd49d84a0  ! 1460: LDDA_R	ldda	[%r22, %r0] 0x25, %r10
	.word 0xd4cfa000  ! 1461: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0x87802072  ! 1462: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4b76000  ! 1463: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd0ccc400  ! 1464: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	mov	0x20, %r16
	.word 0xd0cf6000  ! 1466: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	mov	0x40, %r19
	.word 0xd0f7a000  ! 1468: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0f7e000  ! 1469: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd89dc4a0  ! 1470: LDDA_R	ldda	[%r23, %r0] 0x25, %r12
	.word 0x87802020  ! 1471: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d7ce60  ! 1472: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r12
	.word 0xd6afce80  ! 1473: STBA_R	stba	%r11, [%r31 + %r0] 0x74
	.word 0xd88d04a0  ! 1474: LDUBA_R	lduba	[%r20, %r0] 0x25, %r12
	mov	0x30, %r18
	.word 0xd88ca000  ! 1476: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	.word 0xd8b42000  ! 1477: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	mov	0x50, %r24
	mov	0x7d0, %r22
	.word 0xd8f4e000  ! 1480: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xd8dce000  ! 1481: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	.word 0x87802025  ! 1482: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd88d6000  ! 1483: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r12
	mov	0x50, %r18
	.word 0xd8c5a000  ! 1485: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1486: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bf0e60  ! 1487: STDA_R	stda	%r8, [%r28 + %r0] 0x73
	mov	0x8, %r19
	.word 0xd09c6000  ! 1489: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r8
	mov	0x8, %r18
	.word 0xd0cf0e60  ! 1491: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r8
	.word 0xd0b42000  ! 1492: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 1493: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 1494: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bfce80  ! 1495: STDA_R	stda	%r9, [%r31 + %r0] 0x74
	.word 0xd4bc8400  ! 1496: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	.word 0x87802020  ! 1497: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r27
	.word 0x87802072  ! 1499: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6bd84a0  ! 1500: STDA_R	stda	%r11, [%r22 + %r0] 0x25
	.word 0xdc978e80  ! 1501: LDUHA_R	lduha	[%r30, %r0] 0x74, %r14
	mov	0x58, %r18
	.word 0x87802020  ! 1503: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1504: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1505: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbf4e80  ! 1506: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	mov	0x7f8, %r22
	.word 0xdccca000  ! 1508: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	.word 0xd8afce80  ! 1509: STBA_R	stba	%r12, [%r31 + %r0] 0x74
	.word 0xd8bc2000  ! 1510: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd8bc2000  ! 1511: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd8a46000  ! 1512: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	mov	0x30, %r26
	.word 0xd4f70e60  ! 1514: STXA_R	stxa	%r10, [%r28 + %r0] 0x73
	.word 0xd0ad44a0  ! 1515: STBA_R	stba	%r8, [%r21 + %r0] 0x25
	.word 0xd0a42000  ! 1516: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xd0d46000  ! 1517: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 1518: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdccfce40  ! 1519: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r14
	.word 0xd2a78e60  ! 1520: STWA_R	stwa	%r9, [%r30 + %r0] 0x73
	wr_tick_cmpr_0_14:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x84, %g2
	or	%g4, 0x81, %g4
	or	%g6, 0xb6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd89e89e0  ! 1522: LDDA_R	ldda	[%r26, %r0] 0x4f, %r12
	.word 0x87802025  ! 1523: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd09fce60  ! 1524: LDDA_R	ldda	[%r31, %r0] 0x73, %r8
	.word 0xd0bda000  ! 1525: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	mov	0x8, %r16
	mov	0x68, %r18
	.word 0x87802025  ! 1528: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f544a0  ! 1529: STXA_R	stxa	%r8, [%r21 + %r0] 0x25
	.word 0xd6cfce60  ! 1530: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r11
	.word 0xd6c52000  ! 1531: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r11
	.word 0xd09fce60  ! 1532: LDDA_R	ldda	[%r31, %r0] 0x73, %r8
	mov	0x0, %r24
	.word 0xd0b56000  ! 1534: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	.word 0xd6d44400  ! 1535: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r11
	.word 0xdec40400  ! 1536: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xde85a000  ! 1537: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r15
	.word 0xdebd6000  ! 1538: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	.word 0xd6a74e40  ! 1539: STWA_R	stwa	%r11, [%r29 + %r0] 0x72
	.word 0x87802073  ! 1540: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r16
	mov	0x30, %r17
	mov	0x3d8, %r21
	mov	0x58, %r18
	.word 0xd6cf2000  ! 1545: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	mov	0x7f8, %r22
	.word 0xdca4c400  ! 1547: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0x87802020  ! 1548: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccc6000  ! 1549: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	.word 0xdc8c2000  ! 1550: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r14
	.word 0xdc94e000  ! 1551: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	.word 0xd0bf4e40  ! 1552: STDA_R	stda	%r8, [%r29 + %r0] 0x72
	.word 0xd0dce000  ! 1553: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r8
	.word 0xd0bc4400  ! 1554: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xd09ca000  ! 1555: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	.word 0xd0ac2000  ! 1556: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 1557: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r16
	mov	0x7c0, %r21
	.word 0xd0cca000  ! 1560: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	.word 0xd4ac8400  ! 1561: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0xd2afce60  ! 1562: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	.word 0xd6d48400  ! 1563: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	mov	0x48, %r18
	.word 0x87802073  ! 1565: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6dfa000  ! 1566: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0xd0dcc400  ! 1567: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0xd0a7e000  ! 1568: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xd4acc400  ! 1569: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xd4a72000  ! 1570: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4afe000  ! 1571: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 1572: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xdaf74e60  ! 1574: STXA_R	stxa	%r13, [%r29 + %r0] 0x73
	.word 0x87802074  ! 1575: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaafa000  ! 1576: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdef70e40  ! 1577: STXA_R	stxa	%r15, [%r28 + %r0] 0x72
	.word 0xd0a74e60  ! 1578: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	.word 0xde96c9e0  ! 1579: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r15
	.word 0xded7e000  ! 1580: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	mov	0x7c8, %r20
	.word 0xdef76000  ! 1582: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdea74e40  ! 1583: STWA_R	stwa	%r15, [%r29 + %r0] 0x72
	.word 0xdeb72000  ! 1584: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xd28f4e60  ! 1585: LDUBA_R	lduba	[%r29, %r0] 0x73, %r9
	.word 0xd2a7a000  ! 1586: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xd6c48400  ! 1587: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	.word 0xd6c76000  ! 1588: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6afe000  ! 1589: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xde96c9e0  ! 1590: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r15
	.word 0xde87e000  ! 1591: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdea504a0  ! 1592: STWA_R	stwa	%r15, [%r20 + %r0] 0x25
	.word 0xdeb7a000  ! 1593: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xd2d4c400  ! 1594: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r9
	.word 0xdcbc4400  ! 1595: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0xdcdc4400  ! 1596: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	.word 0x87802020  ! 1597: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r18
	.word 0xd0f544a0  ! 1599: STXA_R	stxa	%r8, [%r21 + %r0] 0x25
	.word 0xd0ac2000  ! 1600: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xd0bc2000  ! 1601: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 1602: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd88f4e40  ! 1603: LDUBA_R	lduba	[%r29, %r0] 0x72, %r12
	.word 0xd6c7ce40  ! 1604: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r11
	.word 0xd6bfa000  ! 1605: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 1606: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r26
	.word 0xd6b7e000  ! 1608: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd69f2000  ! 1609: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xd6f7e000  ! 1610: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xdcb44400  ! 1611: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0xdcb7a000  ! 1612: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xd09584a0  ! 1613: LDUHA_R	lduha	[%r22, %r0] 0x25, %r8
	.word 0xd0c72000  ! 1614: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	mov	0x0, %r17
	.word 0xd0d76000  ! 1616: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0bfa000  ! 1617: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0xd0b7ce60  ! 1618: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	.word 0xd68d44a0  ! 1619: LDUBA_R	lduba	[%r21, %r0] 0x25, %r11
	.word 0xd28dc4a0  ! 1620: LDUBA_R	lduba	[%r23, %r0] 0x25, %r9
	.word 0xd2d72000  ! 1621: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0x87802072  ! 1622: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a74e40  ! 1623: STWA_R	stwa	%r12, [%r29 + %r0] 0x72
	mov	0x3e0, %r20
	.word 0x87802073  ! 1625: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r19
	.word 0xd8dfa000  ! 1627: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd88fa000  ! 1628: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1629: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9c8400  ! 1630: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0x87802074  ! 1631: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb72000  ! 1632: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xdcbc8400  ! 1633: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xd8dec9e0  ! 1634: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r12
	.word 0xd09c0400  ! 1635: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	.word 0xd087e000  ! 1636: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1637: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08ce000  ! 1638: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xd09ca000  ! 1639: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	mov	0x3c0, %r22
	.word 0x87802072  ! 1641: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 1642: WRASI_I	wr	%r0, 0x0072, %asi
	wr_tick_cmpr_0_15:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x99, %g2
	or	%g4, 0x85, %g4
	or	%g6, 0xef, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x18, %r19
	.word 0xd2c689e0  ! 1645: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r9
	.word 0xd49f8e80  ! 1646: LDDA_R	ldda	[%r30, %r0] 0x74, %r10
	mov	0x38, %r27
	mov	0x3f0, %r20
	.word 0xd4a76000  ! 1649: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xdc8d04a0  ! 1650: LDUBA_R	lduba	[%r20, %r0] 0x25, %r14
	.word 0xdabf4e40  ! 1651: STDA_R	stda	%r13, [%r29 + %r0] 0x72
	.word 0xd8a70e40  ! 1652: STWA_R	stwa	%r12, [%r28 + %r0] 0x72
	.word 0xd497ce60  ! 1653: LDUHA_R	lduha	[%r31, %r0] 0x73, %r10
	.word 0xd4af6000  ! 1654: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xda9f4e60  ! 1655: LDDA_R	ldda	[%r29, %r0] 0x73, %r13
	.word 0xda87e000  ! 1656: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdab72000  ! 1658: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdab7e000  ! 1659: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xdabf6000  ! 1660: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xdab7e000  ! 1661: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdc8d44a0  ! 1663: LDUBA_R	lduba	[%r21, %r0] 0x25, %r14
	.word 0xd88c4400  ! 1664: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0xdeac0400  ! 1665: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	mov	0x0, %r18
	.word 0xde872000  ! 1667: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xdecf2000  ! 1668: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xdef76000  ! 1669: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdea7e000  ! 1670: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xd4c40400  ! 1671: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	.word 0xdeb44400  ! 1672: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0xdadc0400  ! 1673: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	mov	0x7f8, %r20
	.word 0xdabf2000  ! 1675: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xdadfe000  ! 1676: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0xdaafe000  ! 1677: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xd0de89e0  ! 1679: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r8
	.word 0xdadd44a0  ! 1680: LDXA_R	ldxa	[%r21, %r0] 0x25, %r13
	mov	0x8, %r25
	.word 0xd8df8e80  ! 1682: LDXA_R	ldxa	[%r30, %r0] 0x74, %r12
	.word 0xd4cec9e0  ! 1683: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r10
	.word 0xd0b584a0  ! 1684: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	.word 0xd0cc8400  ! 1685: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0xd09f2000  ! 1686: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0xdab74e80  ! 1687: STHA_R	stha	%r13, [%r29 + %r0] 0x74
	.word 0xdab74e60  ! 1688: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	mov	0x38, %r18
	.word 0xd6dec9e0  ! 1690: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r11
	mov	0x3e0, %r21
	.word 0xd887ce80  ! 1692: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r12
	.word 0xd08e09e0  ! 1693: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r8
	.word 0xd0cf2000  ! 1694: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0xdccec9e0  ! 1695: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r14
	mov	0x50, %r19
	mov	0x7f8, %r20
	.word 0xdc9f6000  ! 1698: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0x87802020  ! 1699: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2d70e60  ! 1701: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r9
	.word 0xdccd84a0  ! 1702: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r14
	mov	0x30, %r19
	.word 0xdcbca000  ! 1704: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdcbc2000  ! 1705: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xdcf4a000  ! 1706: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcc4e000  ! 1707: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r14
	.word 0xda8cc400  ! 1708: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	mov	0x38, %r17
	mov	0x28, %r19
	.word 0xdabc6000  ! 1711: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	mov	0x18, %r16
	.word 0xda9ce000  ! 1713: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r13
	.word 0xdaaca000  ! 1714: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0xd6b6c9e0  ! 1715: STHA_R	stha	%r11, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 1716: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28ec9e0  ! 1717: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r9
	wr_tick_cmpr_0_16:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x84, %g2
	or	%g4, 0x86, %g4
	or	%g6, 0xe7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0cc4400  ! 1719: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	.word 0xd0cce000  ! 1720: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0xd4c40400  ! 1721: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	mov	0x48, %r27
	.word 0x8780204f  ! 1723: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x0, %r26
	mov	0x0, %r27
	.word 0xd6dc8400  ! 1726: LDXA_R	ldxa	[%r18, %r0] 0x20, %r11
	.word 0xd6ae2000  ! 1727: STBA_I	stba	%r11, [%r24 + 0x0000] %asi
	.word 0xdcbf0e80  ! 1728: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	mov	0x20, %r19
	.word 0x87802025  ! 1730: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2974e60  ! 1731: LDUHA_R	lduha	[%r29, %r0] 0x73, %r9
	mov	0x10, %r17
	.word 0xd2c5a000  ! 1733: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r9
	.word 0xdca4c400  ! 1734: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	mov	0x28, %r27
	mov	0x18, %r26
	.word 0xdca56000  ! 1737: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdcbde000  ! 1739: STDA_I	stda	%r14, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 1740: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 1741: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcb62000  ! 1742: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	mov	0x3c8, %r22
	mov	0x20, %r19
	.word 0xd0b74e40  ! 1745: STHA_R	stha	%r8, [%r29 + %r0] 0x72
	.word 0xd0a6a000  ! 1746: STWA_I	stwa	%r8, [%r26 + 0x0000] %asi
	mov	0x20, %r18
	.word 0xd0ce2000  ! 1748: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r8
	mov	0x60, %r26
	mov	0x30, %r25
	mov	0x7c8, %r21
	.word 0xd4d584a0  ! 1752: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r10
	.word 0x87802025  ! 1753: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 1754: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r26
	mov	0x7f0, %r20
	.word 0xd6ac0400  ! 1757: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0x87802073  ! 1758: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd49c8400  ! 1759: LDDA_R	ldda	[%r18, %r0] 0x20, %r10
	.word 0xd4a7e000  ! 1760: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4df2000  ! 1761: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 1762: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8c7ce80  ! 1763: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r12
	.word 0x87802072  ! 1764: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8c7a000  ! 1765: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	wr_tick_cmpr_0_17:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xbc, %g2
	or	%g4, 0x9a, %g4
	or	%g6, 0xe8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x18, %r26
	.word 0xd8b76000  ! 1768: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0xd09504a0  ! 1770: LDUHA_R	lduha	[%r20, %r0] 0x25, %r8
	mov	0x3c8, %r23
	mov	0x20, %r26
	mov	0x18, %r16
	mov	0x20, %r16
	.word 0xd4df8e80  ! 1775: LDXA_R	ldxa	[%r30, %r0] 0x74, %r10
	.word 0xd4d72000  ! 1776: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	.word 0xdcbcc400  ! 1777: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xdc876000  ! 1778: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0xded44400  ! 1779: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	mov	0x50, %r26
	.word 0xd69f8e40  ! 1781: LDDA_R	ldda	[%r30, %r0] 0x72, %r11
	.word 0xd6d7e000  ! 1782: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	.word 0xd0848400  ! 1783: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r8
	mov	0x38, %r26
	.word 0xd0972000  ! 1785: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 1786: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r18
	.word 0xdcb5c4a0  ! 1788: STHA_R	stha	%r14, [%r23 + %r0] 0x25
	mov	0x3d0, %r20
	.word 0xdcae6000  ! 1790: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	.word 0xd6bc8400  ! 1791: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xd2a48400  ! 1792: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	mov	0x58, %r24
	.word 0xd2be2000  ! 1794: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	.word 0xd2aea000  ! 1795: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0x87802025  ! 1796: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r19
	.word 0x8780204f  ! 1798: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0cc0400  ! 1799: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	mov	0x58, %r26
	.word 0xd0a62000  ! 1801: STWA_I	stwa	%r8, [%r24 + 0x0000] %asi
	.word 0xd2944400  ! 1802: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	.word 0xd69f0e80  ! 1803: LDDA_R	ldda	[%r28, %r0] 0x74, %r11
	.word 0xda9fce60  ! 1804: LDDA_R	ldda	[%r31, %r0] 0x73, %r13
	.word 0x87802073  ! 1805: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdad72000  ! 1806: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0xd6974e40  ! 1807: LDUHA_R	lduha	[%r29, %r0] 0x72, %r11
	.word 0xdca544a0  ! 1808: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0xd2bfce80  ! 1809: STDA_R	stda	%r9, [%r31 + %r0] 0x74
	.word 0xd2a7e000  ! 1810: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xdcd7ce40  ! 1811: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r14
	.word 0xdc9fe000  ! 1812: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xde870e60  ! 1813: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r15
	.word 0xdea7a000  ! 1814: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	mov	0x8, %r16
	.word 0xdec544a0  ! 1816: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r15
	.word 0xded7e000  ! 1817: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0x87802074  ! 1818: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 1819: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabf4e60  ! 1820: STDA_R	stda	%r13, [%r29 + %r0] 0x73
	.word 0xda966000  ! 1821: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r13
	.word 0xdca70e40  ! 1822: STWA_R	stwa	%r14, [%r28 + %r0] 0x72
	mov	0x7d8, %r20
	.word 0xdab6c9e0  ! 1824: STHA_R	stha	%r13, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 1825: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabf6000  ! 1826: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	mov	0x60, %r19
	.word 0xdac7e000  ! 1828: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xd48f0e40  ! 1829: LDUBA_R	lduba	[%r28, %r0] 0x72, %r10
	.word 0x87802025  ! 1830: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4c52000  ! 1831: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r10
	.word 0xd48d2000  ! 1832: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0x87802073  ! 1833: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4a7a000  ! 1834: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xdcb74e60  ! 1835: STHA_R	stha	%r14, [%r29 + %r0] 0x73
	.word 0xd684c400  ! 1836: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	mov	0x7d0, %r20
	.word 0xd6f7e000  ! 1838: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	mov	0x78, %r16
	.word 0xd6bf6000  ! 1840: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd0bf4e40  ! 1841: STDA_R	stda	%r8, [%r29 + %r0] 0x72
	.word 0xd0b7e000  ! 1842: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0xd89cc400  ! 1843: LDDA_R	ldda	[%r19, %r0] 0x20, %r12
	.word 0x87802073  ! 1844: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd8c40400  ! 1846: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	mov	0x50, %r25
	.word 0xd8f7a000  ! 1848: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8bfa000  ! 1849: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd69c0400  ! 1850: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	.word 0xdcbf8e60  ! 1851: STDA_R	stda	%r14, [%r30 + %r0] 0x73
	.word 0xdef7ce80  ! 1852: STXA_R	stxa	%r15, [%r31 + %r0] 0x74
	.word 0xdea76000  ! 1853: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0x87802072  ! 1855: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf7ce40  ! 1856: STXA_R	stxa	%r13, [%r31 + %r0] 0x72
	.word 0xdaaf2000  ! 1857: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	mov	0x20, %r25
	mov	0x3d0, %r22
	.word 0xda9f2000  ! 1860: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xd8bf0e60  ! 1861: STDA_R	stda	%r12, [%r28 + %r0] 0x73
	.word 0x87802020  ! 1862: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdace09e0  ! 1863: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r13
	.word 0x87802073  ! 1864: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf6c9e0  ! 1865: STXA_R	stxa	%r13, [%r27 + %r0] 0x4f
	mov	0x0, %r17
	mov	0x68, %r17
	.word 0xdaf72000  ! 1868: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 1869: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda972000  ! 1870: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0xdabfa000  ! 1871: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xd6d4c400  ! 1872: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	mov	0x3d0, %r22
	.word 0x8780204f  ! 1874: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd68e2000  ! 1875: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r11
	.word 0xd6d6e000  ! 1876: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r11
	.word 0xd6f62000  ! 1877: STXA_I	stxa	%r11, [%r24 + 0x0000] %asi
	.word 0xd6b66000  ! 1878: STHA_I	stha	%r11, [%r25 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xdccf4e60  ! 1880: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r14
	.word 0xd2d609e0  ! 1881: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r9
	.word 0xd2aea000  ! 1882: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0xd29e09e0  ! 1883: LDDA_R	ldda	[%r24, %r0] 0x4f, %r9
	mov	0x50, %r16
	.word 0xdcce89e0  ! 1885: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r14
	.word 0xd6b4c400  ! 1886: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xd6a62000  ! 1887: STWA_I	stwa	%r11, [%r24 + 0x0000] %asi
	.word 0x87802073  ! 1888: WRASI_I	wr	%r0, 0x0073, %asi
	wr_tick_cmpr_0_18:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xbb, %g2
	or	%g4, 0xe4, %g4
	or	%g6, 0xb3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xde8584a0  ! 1890: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r15
	mov	0x30, %r25
	.word 0xd8be89e0  ! 1892: STDA_R	stda	%r12, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 1893: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef4c400  ! 1894: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xdef42000  ! 1895: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	mov	0x8, %r24
	.word 0xdcdf8e80  ! 1897: LDXA_R	ldxa	[%r30, %r0] 0x74, %r14
	.word 0x87802073  ! 1898: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdccf6000  ! 1899: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcc76000  ! 1900: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xdcaf2000  ! 1901: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xd4a40400  ! 1902: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	mov	0x68, %r19
	.word 0xd4af2000  ! 1904: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	mov	0x28, %r16
	.word 0xd8d40400  ! 1906: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	.word 0x8780204f  ! 1907: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b66000  ! 1908: STHA_I	stha	%r12, [%r25 + 0x0000] %asi
	.word 0xd8be6000  ! 1909: STDA_I	stda	%r12, [%r25 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2bd84a0  ! 1911: STDA_R	stda	%r9, [%r22 + %r0] 0x25
	mov	0x3e8, %r23
	mov	0x7d8, %r21
	.word 0xd2be2000  ! 1914: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	.word 0xd2966000  ! 1915: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r9
	.word 0xd2ae2000  ! 1916: STBA_I	stba	%r9, [%r24 + 0x0000] %asi
	.word 0xd4b584a0  ! 1917: STHA_R	stha	%r10, [%r22 + %r0] 0x25
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd4d6e000  ! 1919: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r10
	.word 0xd49ea000  ! 1920: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	mov	0x68, %r16
	.word 0x87802072  ! 1922: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c8, %r21
	.word 0xd4976000  ! 1924: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r10
	.word 0xd4f7e000  ! 1925: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	wr_tick_cmpr_0_19:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb3, %g2
	or	%g4, 0x9e, %g4
	or	%g6, 0xdc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 1927: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2aec9e0  ! 1928: STBA_R	stba	%r9, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 1929: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 1930: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 1931: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r25
	mov	0x38, %r24
	mov	0x8, %r19
	.word 0xd2a7ce80  ! 1935: STWA_R	stwa	%r9, [%r31 + %r0] 0x74
	.word 0xd8b6c9e0  ! 1936: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 1937: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d8, %r20
	mov	0x7e8, %r21
	.word 0xd8dfa000  ! 1940: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd2c48400  ! 1941: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0xdcb70e80  ! 1942: STHA_R	stha	%r14, [%r28 + %r0] 0x74
	.word 0xdc8f2000  ! 1943: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0x87802025  ! 1944: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c0, %r20
	.word 0xd4a7ce40  ! 1946: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	.word 0xd4c52000  ! 1947: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r10
	mov	0x7f8, %r21
	.word 0xdabc8400  ! 1949: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	.word 0xda852000  ! 1950: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r13
	.word 0xdea70e60  ! 1951: STWA_R	stwa	%r15, [%r28 + %r0] 0x73
	.word 0x87802020  ! 1952: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bfce60  ! 1953: STDA_R	stda	%r10, [%r31 + %r0] 0x73
	.word 0x87802072  ! 1954: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d0, %r23
	.word 0x87802073  ! 1956: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbf8e60  ! 1957: STDA_R	stda	%r14, [%r30 + %r0] 0x73
	mov	0x28, %r25
	.word 0xd2de49e0  ! 1959: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r9
	.word 0x87802074  ! 1960: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b649e0  ! 1961: STHA_R	stha	%r11, [%r25 + %r0] 0x4f
	.word 0xd4acc400  ! 1962: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xd4a72000  ! 1963: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xdebfce60  ! 1964: STDA_R	stda	%r15, [%r31 + %r0] 0x73
	.word 0x87802074  ! 1965: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a78e80  ! 1966: STWA_R	stwa	%r8, [%r30 + %r0] 0x74
	.word 0xdabc4400  ! 1967: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xda8cc400  ! 1968: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	.word 0xdabf6000  ! 1969: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	mov	0x78, %r16
	.word 0xda8fa000  ! 1971: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	mov	0x3c8, %r23
	.word 0xdaf504a0  ! 1973: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	mov	0x8, %r26
	mov	0x8, %r24
	.word 0xdaaf2000  ! 1976: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xda87a000  ! 1977: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0xda8f2000  ! 1978: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xdacfce80  ! 1979: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r13
	.word 0x87802072  ! 1980: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d0, %r20
	.word 0xd08f0e60  ! 1982: LDUBA_R	lduba	[%r28, %r0] 0x73, %r8
	.word 0x87802074  ! 1983: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d8, %r20
	mov	0x18, %r24
	mov	0x7e0, %r20
	mov	0x7d8, %r22
	mov	0x70, %r17
	.word 0xdab4c400  ! 1989: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xdad7e000  ! 1990: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xde970e40  ! 1991: LDUHA_R	lduha	[%r28, %r0] 0x72, %r15
	.word 0xd6af0e40  ! 1992: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	.word 0xdaf70e80  ! 1993: STXA_R	stxa	%r13, [%r28 + %r0] 0x74
	.word 0xdca74e80  ! 1994: STWA_R	stwa	%r14, [%r29 + %r0] 0x74
	.word 0x87802020  ! 1995: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1996: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6a544a0  ! 1997: STWA_R	stwa	%r11, [%r21 + %r0] 0x25
	mov	0x7e8, %r21
	mov	0x48, %r26
	mov	0x18, %r16
	mov	0x3e8, %r23
	.word 0xd8cf4e80  ! 2002: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r12
	.word 0xd8f7a000  ! 2003: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8d7e000  ! 2004: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0xd887a000  ! 2005: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8f7e000  ! 2006: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xdab40400  ! 2007: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	mov	0x8, %r19
	.word 0xde9f0e40  ! 2009: LDDA_R	ldda	[%r28, %r0] 0x72, %r15
	.word 0xdecf2000  ! 2010: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xdc978e40  ! 2011: LDUHA_R	lduha	[%r30, %r0] 0x72, %r14
	.word 0xd2bc4400  ! 2012: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	ta	T_CHANGE_PRIV	! macro
	.word 0xdcc689e0  ! 2014: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r14
	.word 0xdcf76000  ! 2015: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x8, %r27
	.word 0xdcb76000  ! 2017: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xdc9f2000  ! 2018: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	mov	0x18, %r19
	.word 0xdc9f2000  ! 2020: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xd2a649e0  ! 2021: STWA_R	stwa	%r9, [%r25 + %r0] 0x4f
	.word 0xdcf7ce80  ! 2022: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	.word 0xd6d5c4a0  ! 2023: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r11
	.word 0xd6d72000  ! 2024: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r11
	.word 0xd8d7ce60  ! 2025: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r12
	.word 0x87802073  ! 2026: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb609e0  ! 2027: STHA_R	stha	%r14, [%r24 + %r0] 0x4f
	.word 0xda8f8e40  ! 2028: LDUBA_R	lduba	[%r30, %r0] 0x72, %r13
	.word 0xdacfe000  ! 2029: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0xda876000  ! 2030: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0xd0d78e60  ! 2031: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r8
	.word 0x87802074  ! 2032: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2033: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08f0e40  ! 2034: LDUBA_R	lduba	[%r28, %r0] 0x72, %r8
	.word 0xd0f46000  ! 2035: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 2036: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0ae6000  ! 2037: STBA_I	stba	%r8, [%r25 + 0x0000] %asi
	.word 0xd0ae2000  ! 2038: STBA_I	stba	%r8, [%r24 + 0x0000] %asi
	.word 0xd0962000  ! 2039: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r8
	mov	0x7f0, %r20
	.word 0xd0962000  ! 2041: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 2042: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd08ee000  ! 2043: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r8
	.word 0xd0862000  ! 2044: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r8
	mov	0x70, %r18
	.word 0x87802020  ! 2046: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9f0e40  ! 2047: LDDA_R	ldda	[%r28, %r0] 0x72, %r13
	.word 0xd89e09e0  ! 2048: LDDA_R	ldda	[%r24, %r0] 0x4f, %r12
	mov	0x58, %r26
	.word 0xd6ac4400  ! 2050: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	mov	0x0, %r25
	.word 0xd6a78e40  ! 2052: STWA_R	stwa	%r11, [%r30 + %r0] 0x72
	.word 0x87802020  ! 2053: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8dc4400  ! 2054: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0xdabcc400  ! 2055: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	.word 0xdadce000  ! 2056: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xdcd40400  ! 2057: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	.word 0xd4c70e40  ! 2058: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r10
	.word 0xd4a544a0  ! 2059: STWA_R	stwa	%r10, [%r21 + %r0] 0x25
	.word 0x87802072  ! 2060: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a7e000  ! 2061: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	mov	0x20, %r27
	mov	0x7f8, %r22
	.word 0xd2d5c4a0  ! 2064: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r9
	mov	0x3e0, %r21
	.word 0xd2bf6000  ! 2066: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 2067: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d4e000  ! 2068: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0xd2bc6000  ! 2069: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0xdaf609e0  ! 2070: STXA_R	stxa	%r13, [%r24 + %r0] 0x4f
	.word 0x87802074  ! 2071: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacfa000  ! 2072: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xd8a74e40  ! 2073: STWA_R	stwa	%r12, [%r29 + %r0] 0x72
	.word 0xd8bf2000  ! 2074: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd8cfe000  ! 2075: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xdebc8400  ! 2076: STDA_R	stda	%r15, [%r18 + %r0] 0x20
	.word 0xdea72000  ! 2077: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	mov	0x3f8, %r20
	mov	0x68, %r26
	.word 0xd2a7ce60  ! 2080: STWA_R	stwa	%r9, [%r31 + %r0] 0x73
	.word 0xd2a76000  ! 2081: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	mov	0x50, %r16
	.word 0xd2df6000  ! 2083: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0xd8a4c400  ! 2084: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	mov	0x10, %r26
	.word 0xd88fa000  ! 2086: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	mov	0x38, %r25
	.word 0xdca7ce60  ! 2088: STWA_R	stwa	%r14, [%r31 + %r0] 0x73
	.word 0xdc97a000  ! 2089: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	mov	0x3c0, %r20
	.word 0xdc876000  ! 2091: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0xdccf6000  ! 2092: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 2093: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeb7ce60  ! 2094: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	.word 0x87802074  ! 2095: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r19
	.word 0xded76000  ! 2097: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0xdc870e40  ! 2098: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r14
	.word 0xdcbf2000  ! 2099: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	mov	0x20, %r25
	.word 0x8780204f  ! 2101: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r19
	.word 0xdca6e000  ! 2103: STWA_I	stwa	%r14, [%r27 + 0x0000] %asi
	.word 0xdcb62000  ! 2104: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	.word 0xde9f4e40  ! 2105: LDDA_R	ldda	[%r29, %r0] 0x72, %r15
	.word 0xde87ce60  ! 2106: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r15
	mov	0x38, %r16
	mov	0x18, %r25
	.word 0xdebee000  ! 2109: STDA_I	stda	%r15, [%r27 + 0x0000] %asi
	.word 0xdec6e000  ! 2110: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r15
	.word 0xdcadc4a0  ! 2111: STBA_R	stba	%r14, [%r23 + %r0] 0x25
	.word 0xd4a609e0  ! 2112: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	.word 0xd4ce6000  ! 2113: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r10
	.word 0xd4a66000  ! 2114: STWA_I	stwa	%r10, [%r25 + 0x0000] %asi
	.word 0xdcbcc400  ! 2115: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xd2f70e80  ! 2116: STXA_R	stxa	%r9, [%r28 + %r0] 0x74
	.word 0xd6a48400  ! 2117: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0xd6a78e60  ! 2118: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	mov	0x60, %r24
	.word 0xd2b44400  ! 2120: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0xd2f62000  ! 2121: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	mov	0x7e0, %r23
	mov	0x10, %r19
	mov	0x18, %r18
	.word 0xd2f6e000  ! 2125: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	.word 0xd29ea000  ! 2126: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r9
	.word 0xd8dc8400  ! 2127: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0x87802025  ! 2128: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r18
	mov	0x50, %r25
	.word 0xdef544a0  ! 2131: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	.word 0xda9c4400  ! 2132: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	.word 0xde8fce40  ! 2133: LDUBA_R	lduba	[%r31, %r0] 0x72, %r15
	mov	0x7f8, %r22
	.word 0xdef5a000  ! 2135: STXA_I	stxa	%r15, [%r22 + 0x0000] %asi
	.word 0xdcf70e60  ! 2136: STXA_R	stxa	%r14, [%r28 + %r0] 0x73
	.word 0xdcad2000  ! 2137: STBA_I	stba	%r14, [%r20 + 0x0000] %asi
	.word 0x87802072  ! 2138: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc87e000  ! 2139: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0x87802072  ! 2140: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r17
	.word 0xdcbf6000  ! 2142: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdad4c400  ! 2143: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xda976000  ! 2144: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	.word 0xdc840400  ! 2145: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	.word 0x87802025  ! 2146: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6c48400  ! 2147: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	mov	0x8, %r16
	.word 0xd68d6000  ! 2149: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r11
	.word 0xd6dd04a0  ! 2150: LDXA_R	ldxa	[%r20, %r0] 0x25, %r11
	.word 0xd2cf8e40  ! 2151: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r9
	.word 0xd2a5e000  ! 2152: STWA_I	stwa	%r9, [%r23 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0xd29da000  ! 2154: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r9
	.word 0xd6dd44a0  ! 2155: LDXA_R	ldxa	[%r21, %r0] 0x25, %r11
	.word 0xd8c544a0  ! 2156: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r12
	.word 0xd8b5e000  ! 2157: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	.word 0xd8dd6000  ! 2158: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r12
	mov	0x60, %r16
	.word 0xd2dd44a0  ! 2160: LDXA_R	ldxa	[%r21, %r0] 0x25, %r9
	mov	0x18, %r25
	.word 0xd4f649e0  ! 2162: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	.word 0xd4dd2000  ! 2163: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r10
	mov	0x18, %r27
	.word 0x8780204f  ! 2165: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4be6000  ! 2166: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	mov	0x10, %r16
	.word 0x87802025  ! 2168: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d8, %r22
	mov	0x7e0, %r23
	mov	0x30, %r18
	mov	0x0, %r19
	mov	0x7f0, %r23
	.word 0x87802020  ! 2174: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cc2000  ! 2175: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	.word 0xd4bc6000  ! 2176: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xd4bca000  ! 2177: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0xd4dca000  ! 2178: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	.word 0xd4f42000  ! 2179: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd4b78e40  ! 2180: STHA_R	stha	%r10, [%r30 + %r0] 0x72
	.word 0xd6b70e60  ! 2181: STHA_R	stha	%r11, [%r28 + %r0] 0x73
	mov	0x58, %r16
	mov	0x3f0, %r22
	.word 0xd6aca000  ! 2184: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xd6d48400  ! 2185: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0xd694c400  ! 2186: LDUHA_R	lduha	[%r19, %r0] 0x20, %r11
	.word 0x87802020  ! 2187: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r27
	.word 0xd8a78e40  ! 2189: STWA_R	stwa	%r12, [%r30 + %r0] 0x72
	.word 0xd6bc8400  ! 2190: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xd0bf0e60  ! 2191: STDA_R	stda	%r8, [%r28 + %r0] 0x73
	.word 0xd0970e80  ! 2192: LDUHA_R	lduha	[%r28, %r0] 0x74, %r8
	.word 0xd2f44400  ! 2193: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	.word 0xd2cc6000  ! 2194: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	.word 0xd2f42000  ! 2195: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0xd2f4a000  ! 2196: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0xd29ca000  ! 2197: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	mov	0x28, %r26
	mov	0x3f8, %r23
	.word 0xd8a5c4a0  ! 2200: STWA_R	stwa	%r12, [%r23 + %r0] 0x25
	.word 0xd0bc8400  ! 2201: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0xd08ce000  ! 2202: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	mov	0x18, %r24
	mov	0x60, %r24
	.word 0xd0ace000  ! 2205: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0xd2b70e40  ! 2206: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	.word 0xd294a000  ! 2207: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r9
	.word 0xd2b46000  ! 2208: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0xd6948400  ! 2209: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	.word 0xd6a4a000  ! 2210: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	.word 0xd4de09e0  ! 2211: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r10
	.word 0xd4b4a000  ! 2212: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	mov	0x38, %r24
	.word 0xd8b7ce80  ! 2214: STHA_R	stha	%r12, [%r31 + %r0] 0x74
	.word 0xd8a46000  ! 2215: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xd48c4400  ! 2217: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0x87802072  ! 2218: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 2219: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4bfa000  ! 2220: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	mov	0x8, %r26
	.word 0x87802074  ! 2222: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r18
	.word 0xd4f7e000  ! 2224: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xd6f6c9e0  ! 2225: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	.word 0xd6a74e80  ! 2226: STWA_R	stwa	%r11, [%r29 + %r0] 0x74
	.word 0xd2a4c400  ! 2227: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0xd29fa000  ! 2228: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd28f2000  ! 2229: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	mov	0x40, %r19
	.word 0x87802074  ! 2231: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2232: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48f0e80  ! 2233: LDUBA_R	lduba	[%r28, %r0] 0x74, %r10
	.word 0xd0bf8e60  ! 2234: STDA_R	stda	%r8, [%r30 + %r0] 0x73
	mov	0x70, %r16
	.word 0x87802072  ! 2236: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2237: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2238: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0cfe000  ! 2239: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	mov	0x7d0, %r20
	.word 0x87802020  ! 2241: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f74e60  ! 2242: STXA_R	stxa	%r9, [%r29 + %r0] 0x73
	.word 0x87802025  ! 2243: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0cc0400  ! 2244: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xd0bd6000  ! 2245: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	mov	0x8, %r18
	.word 0xde8f4e40  ! 2247: LDUBA_R	lduba	[%r29, %r0] 0x72, %r15
	.word 0xdecda000  ! 2248: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r15
	mov	0x0, %r18
	mov	0x78, %r16
	mov	0x20, %r27
	.word 0xdadf4e60  ! 2252: LDXA_R	ldxa	[%r29, %r0] 0x73, %r13
	mov	0x3f8, %r23
	.word 0xd8b544a0  ! 2254: STHA_R	stha	%r12, [%r21 + %r0] 0x25
	mov	0x38, %r16
	.word 0xd8bde000  ! 2256: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0xd8ad6000  ! 2257: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 2258: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r25
	mov	0x30, %r17
	.word 0xd0af4e40  ! 2261: STBA_R	stba	%r8, [%r29 + %r0] 0x72
	.word 0x87802020  ! 2262: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabf8e80  ! 2263: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	.word 0xdaac6000  ! 2264: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	.word 0xdac42000  ! 2265: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0xd6f689e0  ! 2266: STXA_R	stxa	%r11, [%r26 + %r0] 0x4f
	.word 0xd6b48400  ! 2267: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd8d74e40  ! 2268: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r12
	.word 0xd8f689e0  ! 2269: STXA_R	stxa	%r12, [%r26 + %r0] 0x4f
	mov	0x78, %r24
	.word 0xd8aca000  ! 2271: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0xd8a46000  ! 2272: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xd89ca000  ! 2273: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r12
	mov	0x38, %r17
	.word 0xd8942000  ! 2275: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r12
	.word 0xd2f504a0  ! 2276: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	.word 0xd2b46000  ! 2277: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0xd29f0e80  ! 2278: LDDA_R	ldda	[%r28, %r0] 0x74, %r9
	.word 0x87802074  ! 2279: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd69c0400  ! 2280: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	.word 0xd6a7e000  ! 2281: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xdccfce40  ! 2282: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r14
	.word 0xdc8f6000  ! 2283: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2284: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9c6000  ! 2285: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r14
	.word 0xdc942000  ! 2286: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	.word 0xdc94e000  ! 2287: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	.word 0xdcdc6000  ! 2288: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 2289: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdca78e80  ! 2290: STWA_R	stwa	%r14, [%r30 + %r0] 0x74
	.word 0x87802020  ! 2291: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccc2000  ! 2292: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r14
	.word 0xdc942000  ! 2293: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	.word 0xded44400  ! 2294: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	mov	0x8, %r24
	.word 0xde942000  ! 2296: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	.word 0xde9c6000  ! 2297: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0xd2af4e80  ! 2298: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	mov	0x8, %r19
	.word 0xd29ca000  ! 2300: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	.word 0xd2aca000  ! 2301: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 2302: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r25
	.word 0x87802020  ! 2304: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde874e60  ! 2305: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r15
	mov	0x58, %r19
	mov	0x7f0, %r23
	.word 0xd8b689e0  ! 2308: STHA_R	stha	%r12, [%r26 + %r0] 0x4f
	mov	0x28, %r18
	.word 0xdaf7ce40  ! 2310: STXA_R	stxa	%r13, [%r31 + %r0] 0x72
	.word 0xd0d78e60  ! 2311: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r8
	mov	0x60, %r24
	.word 0xd6a584a0  ! 2313: STWA_R	stwa	%r11, [%r22 + %r0] 0x25
	.word 0xd8b7ce40  ! 2314: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0xd8a4a000  ! 2315: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8aca000  ! 2316: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	mov	0x50, %r27
	.word 0xd8dca000  ! 2318: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	.word 0xd8a4a000  ! 2319: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8f4a000  ! 2320: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 2321: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r20
	wr_tick_cmpr_0_20:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x8d, %g2
	or	%g4, 0xce, %g4
	or	%g6, 0xd3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd894a000  ! 2324: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r12
	.word 0xd6af4e60  ! 2325: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	.word 0xd6ace000  ! 2326: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0xd6cc2000  ! 2327: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	.word 0xd4cec9e0  ! 2328: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r10
	.word 0xd0874e80  ! 2329: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r8
	mov	0x10, %r25
	.word 0xd0b74e40  ! 2331: STHA_R	stha	%r8, [%r29 + %r0] 0x72
	.word 0xd0842000  ! 2332: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r8
	.word 0x87802025  ! 2333: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8a689e0  ! 2334: STWA_R	stwa	%r12, [%r26 + %r0] 0x4f
	.word 0xd8d5e000  ! 2335: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r12
	.word 0xd8a52000  ! 2336: STWA_I	stwa	%r12, [%r20 + 0x0000] %asi
	.word 0xd8bda000  ! 2337: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	.word 0xd895e000  ! 2338: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r12
	.word 0xd8a5a000  ! 2339: STWA_I	stwa	%r12, [%r22 + 0x0000] %asi
	.word 0xd8a5e000  ! 2340: STWA_I	stwa	%r12, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 2341: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f0, %r23
	.word 0xd6be89e0  ! 2343: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	.word 0xd6dee000  ! 2344: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r11
	.word 0xd6a6e000  ! 2345: STWA_I	stwa	%r11, [%r27 + 0x0000] %asi
	mov	0x7d8, %r22
	mov	0x18, %r16
	.word 0xd8b544a0  ! 2348: STHA_R	stha	%r12, [%r21 + %r0] 0x25
	.word 0xd4bf4e40  ! 2349: STDA_R	stda	%r10, [%r29 + %r0] 0x72
	mov	0x18, %r18
	.word 0xd4f6a000  ! 2351: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	.word 0xd2a6c9e0  ! 2352: STWA_R	stwa	%r9, [%r27 + %r0] 0x4f
	.word 0xde970e80  ! 2353: LDUHA_R	lduha	[%r28, %r0] 0x74, %r15
	.word 0xde866000  ! 2354: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r15
	.word 0x87802020  ! 2355: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea46000  ! 2356: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xd4b48400  ! 2357: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0x87802073  ! 2358: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2359: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4dca000  ! 2360: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	.word 0xd48ce000  ! 2361: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r10
	.word 0xd4ac6000  ! 2362: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 2363: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r27
	mov	0x68, %r27
	mov	0x70, %r17
	.word 0xd8c74e60  ! 2367: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r12
	.word 0xd887a000  ! 2368: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xde97ce60  ! 2369: LDUHA_R	lduha	[%r31, %r0] 0x73, %r15
	.word 0xdef7e000  ! 2370: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xdeb78e80  ! 2371: STHA_R	stha	%r15, [%r30 + %r0] 0x74
	mov	0x3e8, %r20
	.word 0xd8ae49e0  ! 2373: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0x87802072  ! 2374: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r18
	.word 0xd2f4c400  ! 2376: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xd2d7e000  ! 2377: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xd2bf2000  ! 2378: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd2f76000  ! 2379: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xd2b7a000  ! 2380: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd2b76000  ! 2381: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xd29f2000  ! 2383: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xdede89e0  ! 2384: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r15
	.word 0xd29fce40  ! 2385: LDDA_R	ldda	[%r31, %r0] 0x72, %r9
	mov	0x70, %r16
	mov	0x7c8, %r20
	.word 0xdacf8e40  ! 2388: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r13
	.word 0x87802025  ! 2389: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad5a000  ! 2390: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r13
	.word 0xd0cf4e80  ! 2391: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r8
	.word 0xd0dda000  ! 2392: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r8
	.word 0xd0b52000  ! 2393: STHA_I	stha	%r8, [%r20 + 0x0000] %asi
	.word 0xd085e000  ! 2394: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r8
	.word 0xd6f4c400  ! 2395: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	mov	0x10, %r18
	.word 0xd6f5e000  ! 2397: STXA_I	stxa	%r11, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 2398: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd68f6000  ! 2399: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6dfa000  ! 2400: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6afe000  ! 2401: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 2402: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f7e000  ! 2403: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xdea544a0  ! 2404: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	.word 0xd6d74e40  ! 2405: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r11
	mov	0x28, %r17
	.word 0xd8d544a0  ! 2407: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r12
	mov	0x7d0, %r23
	mov	0x3e8, %r21
	.word 0xd2dcc400  ! 2410: LDXA_R	ldxa	[%r19, %r0] 0x20, %r9
	.word 0x87802020  ! 2411: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b46000  ! 2412: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0xd2b4a000  ! 2413: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	mov	0x78, %r19
	.word 0x87802020  ! 2415: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cca000  ! 2416: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	mov	0x20, %r17
	mov	0x50, %r19
	.word 0xd294e000  ! 2419: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	.word 0xd2c44400  ! 2420: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	.word 0xd4bd44a0  ! 2421: STDA_R	stda	%r10, [%r21 + %r0] 0x25
	.word 0xd4a4e000  ! 2422: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	mov	0x3f0, %r23
	.word 0x87802025  ! 2424: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r18
	.word 0xd4974e40  ! 2426: LDUHA_R	lduha	[%r29, %r0] 0x72, %r10
	.word 0xd2cfce40  ! 2427: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r9
	wr_tick_cmpr_0_21:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xed, %g2
	or	%g4, 0x8f, %g4
	or	%g6, 0xc1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd68f4e80  ! 2429: LDUBA_R	lduba	[%r29, %r0] 0x74, %r11
	.word 0xd6f5e000  ! 2430: STXA_I	stxa	%r11, [%r23 + 0x0000] %asi
	.word 0xd0b7ce80  ! 2431: STHA_R	stha	%r8, [%r31 + %r0] 0x74
	.word 0xdeb40400  ! 2432: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0xdeb5a000  ! 2433: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	.word 0xded52000  ! 2434: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r15
	.word 0xdca504a0  ! 2435: STWA_R	stwa	%r14, [%r20 + %r0] 0x25
	.word 0xdccde000  ! 2436: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r14
	.word 0xdcb5a000  ! 2437: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0xdcc52000  ! 2438: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 2439: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f44400  ! 2440: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0xd6aee000  ! 2441: STBA_I	stba	%r11, [%r27 + 0x0000] %asi
	.word 0xd0f74e80  ! 2442: STXA_R	stxa	%r8, [%r29 + %r0] 0x74
	.word 0xd0966000  ! 2443: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r8
	.word 0xd4bf8e60  ! 2444: STDA_R	stda	%r10, [%r30 + %r0] 0x73
	.word 0xd4862000  ! 2445: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r10
	.word 0xd4ce6000  ! 2446: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r10
	mov	0x70, %r19
	.word 0xd48f8e40  ! 2448: LDUBA_R	lduba	[%r30, %r0] 0x72, %r10
	.word 0xd4866000  ! 2449: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 2450: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6de89e0  ! 2451: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r11
	.word 0xdef609e0  ! 2452: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	.word 0xd6c78e40  ! 2453: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	mov	0x18, %r24
	.word 0xd09d04a0  ! 2455: LDDA_R	ldda	[%r20, %r0] 0x25, %r8
	.word 0xd0ae2000  ! 2456: STBA_I	stba	%r8, [%r24 + 0x0000] %asi
	.word 0xd0c66000  ! 2457: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r8
	mov	0x10, %r17
	mov	0x38, %r25
	mov	0x18, %r25
	.word 0xdccc8400  ! 2461: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	.word 0xdead04a0  ! 2462: STBA_R	stba	%r15, [%r20 + %r0] 0x25
	.word 0x87802074  ! 2463: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef7e000  ! 2464: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	mov	0x78, %r25
	.word 0x87802020  ! 2466: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb40400  ! 2467: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0xd8f74e40  ! 2468: STXA_R	stxa	%r12, [%r29 + %r0] 0x72
	mov	0x7f0, %r21
	.word 0xde8fce60  ! 2470: LDUBA_R	lduba	[%r31, %r0] 0x73, %r15
	.word 0x8780204f  ! 2471: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd08e89e0  ! 2472: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r8
	.word 0xd0862000  ! 2473: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r8
	.word 0xdcb74e80  ! 2474: STHA_R	stha	%r14, [%r29 + %r0] 0x74
	.word 0xdcb62000  ! 2475: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	.word 0xdcaea000  ! 2476: STBA_I	stba	%r14, [%r26 + 0x0000] %asi
	.word 0xd0c48400  ! 2477: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r8
	.word 0xd0dee000  ! 2478: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r8
	mov	0x3c0, %r21
	.word 0x87802072  ! 2480: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0dfa000  ! 2481: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0xd087e000  ! 2482: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	mov	0x68, %r24
	mov	0x7c0, %r22
	.word 0x87802074  ! 2485: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcae49e0  ! 2486: STBA_R	stba	%r14, [%r25 + %r0] 0x4f
	.word 0xda9e89e0  ! 2487: LDDA_R	ldda	[%r26, %r0] 0x4f, %r13
	.word 0xdaf7a000  ! 2488: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xd2bf0e60  ! 2489: STDA_R	stda	%r9, [%r28 + %r0] 0x73
	.word 0xd2cd44a0  ! 2490: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r9
	mov	0x48, %r17
	.word 0xd4ad44a0  ! 2492: STBA_R	stba	%r10, [%r21 + %r0] 0x25
	.word 0xdeaec9e0  ! 2493: STBA_R	stba	%r15, [%r27 + %r0] 0x4f
	.word 0xdcb78e80  ! 2494: STHA_R	stha	%r14, [%r30 + %r0] 0x74
	.word 0xdeb7ce60  ! 2495: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	mov	0x3f0, %r22
	.word 0xdea76000  ! 2497: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 2498: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 2499: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 2500: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r27
	.word 0x87802072  ! 2502: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r16
	.word 0xdab70e60  ! 2504: STHA_R	stha	%r13, [%r28 + %r0] 0x73
	.word 0xda976000  ! 2505: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	.word 0xdad7a000  ! 2506: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0xd29f8e60  ! 2507: LDDA_R	ldda	[%r30, %r0] 0x73, %r9
	.word 0xdebf4e40  ! 2508: STDA_R	stda	%r15, [%r29 + %r0] 0x72
	mov	0x3d0, %r20
	.word 0xdeb7a000  ! 2510: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xd8ae49e0  ! 2511: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 2512: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8dce000  ! 2513: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	.word 0x87802074  ! 2514: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd897e000  ! 2515: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	.word 0x87802025  ! 2516: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r17
	.word 0xd8bd2000  ! 2518: STDA_I	stda	%r12, [%r20 + 0x0000] %asi
	.word 0xd8c5e000  ! 2519: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r12
	mov	0x0, %r27
	.word 0xd8a52000  ! 2521: STWA_I	stwa	%r12, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 2522: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c8, %r23
	mov	0x68, %r26
	mov	0x8, %r25
	.word 0x8780204f  ! 2526: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f74e40  ! 2527: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	.word 0xd0bec9e0  ! 2528: STDA_R	stda	%r8, [%r27 + %r0] 0x4f
	.word 0xd08e2000  ! 2529: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r8
	.word 0xd0cc4400  ! 2530: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	.word 0xd4d70e40  ! 2531: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r10
	.word 0xd8d78e60  ! 2532: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r12
	mov	0x38, %r25
	.word 0xd8d6e000  ! 2534: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r12
	mov	0x28, %r18
	.word 0x87802025  ! 2536: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8a5a000  ! 2537: STWA_I	stwa	%r12, [%r22 + 0x0000] %asi
	.word 0xd2df8e40  ! 2538: LDXA_R	ldxa	[%r30, %r0] 0x72, %r9
	.word 0x87802073  ! 2539: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4c74e80  ! 2540: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r10
	.word 0x87802074  ! 2541: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8d48400  ! 2542: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0xded7ce60  ! 2543: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r15
	.word 0xd6cfce80  ! 2544: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r11
	.word 0xd2b78e60  ! 2545: STHA_R	stha	%r9, [%r30 + %r0] 0x73
	.word 0xd2b78e40  ! 2546: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	.word 0x8780204f  ! 2547: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_HPRIV	! macro
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2ce2000  ! 2550: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r9
	.word 0xd2ae2000  ! 2551: STBA_I	stba	%r9, [%r24 + 0x0000] %asi
	.word 0xd8a504a0  ! 2552: STWA_R	stwa	%r12, [%r20 + %r0] 0x25
	.word 0xd886a000  ! 2553: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r12
	mov	0x30, %r18
	mov	0x3f8, %r23
	mov	0x8, %r18
	.word 0xdcd4c400  ! 2557: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	.word 0xd8b78e40  ! 2558: STHA_R	stha	%r12, [%r30 + %r0] 0x72
	.word 0xd8a6e000  ! 2559: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	.word 0xd8de2000  ! 2560: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r12
	.word 0xd8bc0400  ! 2561: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	mov	0x7c8, %r20
	.word 0xd8866000  ! 2563: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r12
	.word 0xd89e6000  ! 2564: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r12
	.word 0xd8bee000  ! 2565: STDA_I	stda	%r12, [%r27 + 0x0000] %asi
	.word 0xd4b609e0  ! 2566: STHA_R	stha	%r10, [%r24 + %r0] 0x4f
	.word 0xd48ea000  ! 2567: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r10
	.word 0x87802072  ! 2568: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r27
	.word 0xdccd04a0  ! 2570: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r14
	.word 0xdaf48400  ! 2571: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	ta	T_CHANGE_HPRIV	! macro
	.word 0xda976000  ! 2573: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	.word 0xd2b544a0  ! 2574: STHA_R	stha	%r9, [%r21 + %r0] 0x25
	.word 0xd8a70e80  ! 2575: STWA_R	stwa	%r12, [%r28 + %r0] 0x74
	.word 0xd0b40400  ! 2576: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0xd0d72000  ! 2577: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd497ce60  ! 2578: LDUHA_R	lduha	[%r31, %r0] 0x73, %r10
	mov	0x3c8, %r23
	.word 0x87802073  ! 2580: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 2581: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 2582: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b66000  ! 2583: STHA_I	stha	%r10, [%r25 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0xda9609e0  ! 2585: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r13
	mov	0x68, %r19
	.word 0xd0b7ce40  ! 2587: STHA_R	stha	%r8, [%r31 + %r0] 0x72
	.word 0x87802020  ! 2588: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ac6000  ! 2589: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 2590: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2591: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab48400  ! 2592: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0xdab7a000  ! 2593: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xd8a544a0  ! 2594: STWA_R	stwa	%r12, [%r21 + %r0] 0x25
	.word 0xd8d76000  ! 2595: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	mov	0x70, %r18
	.word 0xd8a7a000  ! 2597: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xdec7ce80  ! 2598: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r15
	mov	0x7e8, %r21
	.word 0xdef7a000  ! 2600: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xd4c44400  ! 2601: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r10
	.word 0xd4c7a000  ! 2602: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	mov	0x20, %r18
	mov	0x7e8, %r23
	.word 0xd4b76000  ! 2605: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0x87802020  ! 2607: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4842000  ! 2608: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	.word 0x87802025  ! 2609: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdadcc400  ! 2610: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	mov	0x78, %r19
	.word 0xdab5e000  ! 2612: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0xdadd6000  ! 2613: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r13
	mov	0x10, %r17
	.word 0xdad5a000  ! 2615: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 2616: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2617: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c6c9e0  ! 2618: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r12
	.word 0xd8d46000  ! 2619: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	.word 0xd8ac6000  ! 2620: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xd4a44400  ! 2621: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0x87802020  ! 2622: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2623: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a7ce60  ! 2624: STWA_R	stwa	%r12, [%r31 + %r0] 0x73
	mov	0x7d8, %r22
	mov	0x50, %r19
	.word 0x87802020  ! 2627: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r17
	.word 0xd8b46000  ! 2629: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xd8bc2000  ! 2631: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd8bce000  ! 2632: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd8b4a000  ! 2633: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 2634: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd88fe000  ! 2635: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8f7e000  ! 2636: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	mov	0x58, %r18
	mov	0x7e0, %r21
	mov	0x40, %r27
	.word 0xd0f74e40  ! 2640: STXA_R	stxa	%r8, [%r29 + %r0] 0x72
	.word 0xd0d74e40  ! 2641: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r8
	.word 0xd0a72000  ! 2642: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xd0f7a000  ! 2643: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	mov	0x30, %r24
	.word 0xdef78e60  ! 2645: STXA_R	stxa	%r15, [%r30 + %r0] 0x73
	mov	0x18, %r24
	.word 0xded74e60  ! 2647: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r15
	.word 0x87802074  ! 2648: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r16
	.word 0x87802073  ! 2650: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c8, %r22
	mov	0x78, %r27
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802025  ! 2654: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r25
	.word 0xd6cf0e60  ! 2656: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r11
	.word 0xd6bd6000  ! 2657: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 2658: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f44400  ! 2659: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	.word 0xd2bee000  ! 2660: STDA_I	stda	%r9, [%r27 + 0x0000] %asi
	mov	0x78, %r18
	.word 0x87802073  ! 2662: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda8dc4a0  ! 2663: LDUBA_R	lduba	[%r23, %r0] 0x25, %r13
	.word 0xdab7a000  ! 2664: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdacf6000  ! 2665: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	mov	0x7d8, %r21
	.word 0xd0948400  ! 2667: LDUHA_R	lduha	[%r18, %r0] 0x20, %r8
	.word 0xd0bf0e60  ! 2668: STDA_R	stda	%r8, [%r28 + %r0] 0x73
	.word 0xd087a000  ! 2669: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0xd29689e0  ! 2670: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r9
	mov	0x50, %r16
	.word 0x87802073  ! 2672: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c0, %r20
	.word 0xd2d7a000  ! 2674: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	mov	0x7d0, %r21
	mov	0x3e0, %r21
	.word 0x87802020  ! 2677: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2f46000  ! 2679: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2bce000  ! 2680: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xd2f689e0  ! 2681: STXA_R	stxa	%r9, [%r26 + %r0] 0x4f
	.word 0xd8b48400  ! 2682: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0xd0d40400  ! 2683: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	.word 0x87802073  ! 2684: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b584a0  ! 2685: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	.word 0xd08fe000  ! 2686: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	.word 0xdcb4c400  ! 2687: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xdca689e0  ! 2688: STWA_R	stwa	%r14, [%r26 + %r0] 0x4f
	mov	0x38, %r27
	.word 0xdcbfe000  ! 2690: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2691: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9c6000  ! 2692: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r14
	.word 0xd2bf0e40  ! 2693: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	wr_tick_cmpr_0_22:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x96, %g2
	or	%g4, 0xfe, %g4
	or	%g6, 0xe5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802025  ! 2695: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 2696: WRASI_I	wr	%r0, 0x004f, %asi
	wr_tick_cmpr_0_23:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x80, %g2
	or	%g4, 0xc5, %g4
	or	%g6, 0x95, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2b66000  ! 2698: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	.word 0x87802074  ! 2699: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2c76000  ! 2700: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0xdacf8e80  ! 2701: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r13
	.word 0xd4b7ce60  ! 2702: STHA_R	stha	%r10, [%r31 + %r0] 0x73
	.word 0x87802072  ! 2703: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd687ce40  ! 2704: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r11
	.word 0xd2a584a0  ! 2705: STWA_R	stwa	%r9, [%r22 + %r0] 0x25
	.word 0xd2b72000  ! 2706: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd29f2000  ! 2707: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd2dfa000  ! 2708: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0x87802072  ! 2709: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2a76000  ! 2710: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	mov	0x28, %r19
	.word 0xd2b7e000  ! 2712: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd29fa000  ! 2713: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	mov	0x3c0, %r21
	.word 0xd2b72000  ! 2715: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0x8780204f  ! 2717: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd29ee000  ! 2718: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r9
	mov	0x3e0, %r21
	.word 0xd2be6000  ! 2720: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	.word 0xd8a74e40  ! 2721: STWA_R	stwa	%r12, [%r29 + %r0] 0x72
	.word 0xdab7ce60  ! 2722: STHA_R	stha	%r13, [%r31 + %r0] 0x73
	.word 0xdabea000  ! 2723: STDA_I	stda	%r13, [%r26 + 0x0000] %asi
	mov	0x18, %r16
	.word 0xdaae2000  ! 2725: STBA_I	stba	%r13, [%r24 + 0x0000] %asi
	.word 0xd2afce80  ! 2726: STBA_R	stba	%r9, [%r31 + %r0] 0x74
	mov	0x8, %r19
	.word 0xdeb6c9e0  ! 2728: STHA_R	stha	%r15, [%r27 + %r0] 0x4f
	.word 0x8780204f  ! 2729: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcdc0400  ! 2730: LDXA_R	ldxa	[%r16, %r0] 0x20, %r14
	.word 0xdcbe2000  ! 2731: STDA_I	stda	%r14, [%r24 + 0x0000] %asi
	.word 0x87802074  ! 2732: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r24
	.word 0xd896c9e0  ! 2734: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r12
	.word 0xdcd70e40  ! 2735: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r14
	.word 0xd6d649e0  ! 2736: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r11
	.word 0xd4d44400  ! 2737: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0x87802020  ! 2738: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r16
	.word 0xd4ace000  ! 2740: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 2741: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r26
	mov	0x3f0, %r20
	.word 0xd2a4c400  ! 2744: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0xd2cd2000  ! 2745: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r9
	mov	0x3e8, %r23
	.word 0xd2ade000  ! 2747: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0xd2956000  ! 2748: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r9
	.word 0xd8c44400  ! 2749: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r12
	mov	0x70, %r25
	.word 0xdeb74e60  ! 2751: STHA_R	stha	%r15, [%r29 + %r0] 0x73
	wr_tick_cmpr_0_24:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xdf, %g2
	or	%g4, 0xe8, %g4
	or	%g6, 0x91, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2f6c9e0  ! 2753: STXA_R	stxa	%r9, [%r27 + %r0] 0x4f
	.word 0xdea78e60  ! 2754: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	.word 0xd2ac4400  ! 2755: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xd2dd2000  ! 2756: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r9
	mov	0x0, %r26
	.word 0xd6df4e60  ! 2758: LDXA_R	ldxa	[%r29, %r0] 0x73, %r11
	mov	0x38, %r16
	mov	0x60, %r25
	.word 0xd88c8400  ! 2761: LDUBA_R	lduba	[%r18, %r0] 0x20, %r12
	mov	0x28, %r27
	.word 0xd8956000  ! 2763: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r12
	.word 0xd8c52000  ! 2764: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 2765: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8d6a000  ! 2766: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r12
	.word 0xdcb74e40  ! 2767: STHA_R	stha	%r14, [%r29 + %r0] 0x72
	.word 0xdcb6e000  ! 2768: STHA_I	stha	%r14, [%r27 + 0x0000] %asi
	.word 0xdcc62000  ! 2769: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r14
	.word 0xd0d4c400  ! 2770: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	mov	0x7f0, %r21
	.word 0x87802073  ! 2772: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd087e000  ! 2773: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0xdc9d84a0  ! 2774: LDDA_R	ldda	[%r22, %r0] 0x25, %r14
	.word 0xd6840400  ! 2775: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0x87802072  ! 2776: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f5c4a0  ! 2777: STXA_R	stxa	%r10, [%r23 + %r0] 0x25
	.word 0x87802025  ! 2778: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cd6000  ! 2779: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r10
	.word 0xd4d56000  ! 2780: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r10
	.word 0xd4b5a000  ! 2781: STHA_I	stha	%r10, [%r22 + 0x0000] %asi
	.word 0xd6a70e80  ! 2782: STWA_R	stwa	%r11, [%r28 + %r0] 0x74
	.word 0xd6ad2000  ! 2783: STBA_I	stba	%r11, [%r20 + 0x0000] %asi
	.word 0xd0df4e60  ! 2784: LDXA_R	ldxa	[%r29, %r0] 0x73, %r8
	mov	0x58, %r25
	.word 0xd085e000  ! 2786: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r8
	mov	0x0, %r17
	.word 0x8780204f  ! 2788: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd097ce60  ! 2789: LDUHA_R	lduha	[%r31, %r0] 0x73, %r8
	.word 0xd4f74e40  ! 2790: STXA_R	stxa	%r10, [%r29 + %r0] 0x72
	mov	0x30, %r17
	.word 0xd48e6000  ! 2792: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r10
	.word 0xd4dea000  ! 2793: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	.word 0x87802020  ! 2794: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2795: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd484e000  ! 2796: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r10
	.word 0x87802074  ! 2797: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4d72000  ! 2798: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	mov	0x78, %r25
	mov	0x40, %r18
	.word 0x87802074  ! 2801: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2802: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd49f2000  ! 2803: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd4df6000  ! 2804: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	mov	0x20, %r16
	.word 0x87802073  ! 2806: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d0, %r23
	.word 0xd4b76000  ! 2808: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	mov	0x70, %r24
	mov	0x40, %r24
	mov	0x70, %r24
	mov	0x7c0, %r23
	.word 0xd6cec9e0  ! 2813: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r11
	.word 0xd6dfa000  ! 2814: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	mov	0x58, %r19
	.word 0xd6976000  ! 2816: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	.word 0xd697a000  ! 2817: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0x87802072  ! 2818: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8ac0400  ! 2819: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0x87802073  ! 2820: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd89f6000  ! 2821: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	.word 0x87802072  ! 2822: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 2823: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a6a000  ! 2824: STWA_I	stwa	%r12, [%r26 + 0x0000] %asi
	.word 0xd2a48400  ! 2825: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0x87802072  ! 2826: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2af6000  ! 2827: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 2828: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r24
	mov	0x68, %r17
	mov	0x7e0, %r21
	.word 0xd29ee000  ! 2832: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r9
	.word 0xd49dc4a0  ! 2833: LDDA_R	ldda	[%r23, %r0] 0x25, %r10
	.word 0xd6be89e0  ! 2834: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	.word 0xd6c584a0  ! 2835: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r11
	mov	0x3f0, %r21
	ta	T_CHANGE_PRIV	! macro
	mov	0x70, %r25
	.word 0xd686e000  ! 2839: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r11
	.word 0x87802074  ! 2840: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b7e000  ! 2841: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xd6f7e000  ! 2843: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 2844: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2845: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6872000  ! 2846: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6afe000  ! 2847: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xdaf78e80  ! 2848: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	mov	0x28, %r17
	.word 0xdaf7e000  ! 2850: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 2851: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c0, %r20
	.word 0x87802072  ! 2853: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda972000  ! 2854: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0x87802074  ! 2855: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6ae09e0  ! 2856: STBA_R	stba	%r11, [%r24 + %r0] 0x4f
	mov	0x70, %r18
	.word 0xdcb6c9e0  ! 2858: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	mov	0x60, %r27
	.word 0xd8f6c9e0  ! 2860: STXA_R	stxa	%r12, [%r27 + %r0] 0x4f
	.word 0xd4a689e0  ! 2861: STWA_R	stwa	%r10, [%r26 + %r0] 0x4f
	.word 0xd4df6000  ! 2862: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0xd0878e40  ! 2863: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r8
	.word 0xdcbf4e60  ! 2864: STDA_R	stda	%r14, [%r29 + %r0] 0x73
	mov	0x7e0, %r23
	.word 0xdef40400  ! 2866: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0xd8b40400  ! 2867: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	mov	0x58, %r18
	mov	0x28, %r26
	.word 0xde8504a0  ! 2870: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r15
	mov	0x68, %r27
	mov	0x58, %r16
	.word 0xdcf70e60  ! 2873: STXA_R	stxa	%r14, [%r28 + %r0] 0x73
	.word 0xdca7a000  ! 2874: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 2875: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb46000  ! 2876: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	mov	0x18, %r18
	.word 0xd0df8e80  ! 2878: LDXA_R	ldxa	[%r30, %r0] 0x74, %r8
	.word 0x87802020  ! 2879: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b689e0  ! 2880: STHA_R	stha	%r10, [%r26 + %r0] 0x4f
	.word 0xd6aec9e0  ! 2881: STBA_R	stba	%r11, [%r27 + %r0] 0x4f
	.word 0xdac5c4a0  ! 2882: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r13
	mov	0x68, %r19
	.word 0x87802072  ! 2884: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabf6000  ! 2885: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	mov	0x7d0, %r20
	.word 0x87802073  ! 2887: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2888: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaac2000  ! 2889: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	mov	0x70, %r26
	.word 0xd4a74e80  ! 2891: STWA_R	stwa	%r10, [%r29 + %r0] 0x74
	.word 0xd4cc6000  ! 2892: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	mov	0x10, %r17
	mov	0x7e8, %r22
	.word 0xd0a48400  ! 2895: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0xdcaf0e40  ! 2896: STBA_R	stba	%r14, [%r28 + %r0] 0x72
	.word 0xdc946000  ! 2897: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r14
	mov	0x7f8, %r20
	.word 0x87802073  ! 2899: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf72000  ! 2900: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcbfe000  ! 2901: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0x87802073  ! 2903: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb72000  ! 2904: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	mov	0x28, %r24
	.word 0xdcc7a000  ! 2906: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xded689e0  ! 2907: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r15
	.word 0x87802020  ! 2908: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2909: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4ccc400  ! 2910: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0x87802020  ! 2911: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2912: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r17
	.word 0xd4b7e000  ! 2914: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 2915: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2ac0400  ! 2916: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0xd6b6c9e0  ! 2917: STHA_R	stha	%r11, [%r27 + %r0] 0x4f
	.word 0xd28f8e60  ! 2918: LDUBA_R	lduba	[%r30, %r0] 0x73, %r9
	.word 0xd6dc4400  ! 2919: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xda8689e0  ! 2920: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r13
	.word 0xd69649e0  ! 2921: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r11
	.word 0xd6d56000  ! 2922: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r11
	.word 0xdcbfce60  ! 2923: STDA_R	stda	%r14, [%r31 + %r0] 0x73
	.word 0xdcf52000  ! 2924: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	.word 0xd0a74e40  ! 2925: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	.word 0xde9fce80  ! 2926: LDDA_R	ldda	[%r31, %r0] 0x74, %r15
	mov	0x50, %r18
	.word 0xdef70e60  ! 2928: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	mov	0x40, %r16
	.word 0x87802020  ! 2930: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r16
	.word 0xde842000  ! 2932: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	mov	0x10, %r18
	.word 0xde8c2000  ! 2934: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	mov	0x7f8, %r22
	.word 0xded4e000  ! 2936: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	.word 0xdeac0400  ! 2937: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	mov	0x58, %r27
	.word 0xdec42000  ! 2939: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	mov	0x3c8, %r21
	.word 0xd6bfce60  ! 2941: STDA_R	stda	%r11, [%r31 + %r0] 0x73
	mov	0x30, %r17
	mov	0x8, %r19
	mov	0x60, %r26
	.word 0xd6dce000  ! 2945: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0xd6f42000  ! 2946: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	mov	0x50, %r17
	.word 0x87802025  ! 2948: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd68d2000  ! 2949: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r11
	.word 0xd6af0e40  ! 2950: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	.word 0xd6a56000  ! 2951: STWA_I	stwa	%r11, [%r21 + 0x0000] %asi
	.word 0xd4944400  ! 2952: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	mov	0x30, %r16
	.word 0xd4a649e0  ! 2954: STWA_R	stwa	%r10, [%r25 + %r0] 0x4f
	.word 0xd4bd6000  ! 2955: STDA_I	stda	%r10, [%r21 + 0x0000] %asi
	.word 0xd49d6000  ! 2956: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r10
	.word 0xd2970e80  ! 2957: LDUHA_R	lduha	[%r28, %r0] 0x74, %r9
	.word 0xd2bd6000  ! 2958: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	.word 0xd8b44400  ! 2959: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	mov	0x10, %r17
	mov	0x7c8, %r22
	.word 0xd6dfce80  ! 2962: LDXA_R	ldxa	[%r31, %r0] 0x74, %r11
	.word 0xd6b52000  ! 2963: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	.word 0xd6ade000  ! 2964: STBA_I	stba	%r11, [%r23 + 0x0000] %asi
	.word 0x87802073  ! 2965: WRASI_I	wr	%r0, 0x0073, %asi
	wr_tick_cmpr_0_25:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xdd, %g2
	or	%g4, 0x97, %g4
	or	%g6, 0xe0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7d8, %r22
	mov	0x0, %r26
	.word 0xd2a70e60  ! 2969: STWA_R	stwa	%r9, [%r28 + %r0] 0x73
	.word 0xdad7ce40  ! 2970: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r13
	.word 0xde8f8e60  ! 2971: LDUBA_R	lduba	[%r30, %r0] 0x73, %r15
	.word 0xda8e49e0  ! 2972: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r13
	mov	0x20, %r18
	.word 0xdef48400  ! 2974: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xd48f0e40  ! 2975: LDUBA_R	lduba	[%r28, %r0] 0x72, %r10
	.word 0xd4876000  ! 2976: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4ac4400  ! 2977: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0x87802020  ! 2978: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a7ce80  ! 2979: STWA_R	stwa	%r9, [%r31 + %r0] 0x74
	.word 0xd29ce000  ! 2980: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xd8ad44a0  ! 2981: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	.word 0xd8bca000  ! 2982: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd8a46000  ! 2983: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xd89c2000  ! 2984: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	.word 0xd8bc2000  ! 2985: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd88ca000  ! 2986: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	.word 0xd8dc6000  ! 2987: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	.word 0xd49c8400  ! 2988: LDDA_R	ldda	[%r18, %r0] 0x20, %r10
	.word 0xd4bc2000  ! 2989: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	mov	0x0, %r16
	.word 0x87802073  ! 2991: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 2992: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e8, %r20
	.word 0xdeb48400  ! 2994: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0x87802073  ! 2995: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d8, %r22
	.word 0xd29c4400  ! 2997: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	mov	0x7e8, %r21
	.word 0xdcbe09e0  ! 2999: STDA_R	stda	%r14, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 3000: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3001: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r19
	.word 0x87802073  ! 3003: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0f544a0  ! 3004: STXA_R	stxa	%r8, [%r21 + %r0] 0x25
	.word 0xdcbf8e60  ! 3005: STDA_R	stda	%r14, [%r30 + %r0] 0x73
	.word 0x87802020  ! 3006: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r26
	mov	0x20, %r27
	.word 0xd4b44400  ! 3009: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	.word 0xd0f44400  ! 3010: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd0f42000  ! 3011: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	mov	0x3d0, %r21
	.word 0xd2bf8e80  ! 3013: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	.word 0x87802072  ! 3014: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2cf0e80  ! 3015: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r9
	.word 0xd2bfe000  ! 3016: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd4978e60  ! 3017: LDUHA_R	lduha	[%r30, %r0] 0x73, %r10
	.word 0xdeb504a0  ! 3018: STHA_R	stha	%r15, [%r20 + %r0] 0x25
	.word 0xdaf504a0  ! 3019: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	.word 0x87802072  ! 3020: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6d7ce60  ! 3021: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r11
	.word 0xd6df2000  ! 3022: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6af2000  ! 3023: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd8d544a0  ! 3024: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r12
	mov	0x7f8, %r21
	.word 0xd8a70e80  ! 3026: STWA_R	stwa	%r12, [%r28 + %r0] 0x74
	.word 0xd8cf2000  ! 3027: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0xd897e000  ! 3028: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	.word 0xd8c7e000  ! 3029: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0xdcb5c4a0  ! 3030: STHA_R	stha	%r14, [%r23 + %r0] 0x25
	.word 0xdca74e80  ! 3031: STWA_R	stwa	%r14, [%r29 + %r0] 0x74
	.word 0xd8ad04a0  ! 3032: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	.word 0x8780204f  ! 3033: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r26
	.word 0xd88e6000  ! 3035: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r12
	.word 0x87802072  ! 3036: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3037: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd884c400  ! 3038: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	.word 0x87802020  ! 3039: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ace000  ! 3040: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 3041: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdccfce60  ! 3042: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r14
	.word 0xdef5c4a0  ! 3043: STXA_R	stxa	%r15, [%r23 + %r0] 0x25
	.word 0xdead6000  ! 3044: STBA_I	stba	%r15, [%r21 + 0x0000] %asi
	.word 0x87802074  ! 3045: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r24
	mov	0x7e0, %r22
	.word 0xdeb7a000  ! 3048: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xd0bc4400  ! 3049: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xd6d70e60  ! 3050: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r11
	.word 0x87802074  ! 3051: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb40400  ! 3052: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	mov	0x7f8, %r23
	mov	0x7c0, %r23
	.word 0xd8cfce80  ! 3055: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r12
	.word 0xd6adc4a0  ! 3056: STBA_R	stba	%r11, [%r23 + %r0] 0x25
	mov	0x7f8, %r20
	.word 0xd4d4c400  ! 3058: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0xd2f44400  ! 3059: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	mov	0x10, %r17
	.word 0xd29fa000  ! 3061: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3062: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f74e80  ! 3063: STXA_R	stxa	%r10, [%r29 + %r0] 0x74
	.word 0xd4b42000  ! 3064: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	.word 0xda940400  ! 3065: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	.word 0x87802020  ! 3066: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda946000  ! 3067: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	.word 0x87802074  ! 3068: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda87a000  ! 3069: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3070: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedf8e40  ! 3071: LDXA_R	ldxa	[%r30, %r0] 0x72, %r15
	.word 0xdeccc400  ! 3072: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r15
	mov	0x50, %r19
	.word 0xd2d504a0  ! 3074: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r9
	.word 0xd2b4e000  ! 3075: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	mov	0x58, %r26
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802020  ! 3078: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r24
	.word 0xd6d689e0  ! 3080: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r11
	.word 0xd6dc0400  ! 3081: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	mov	0x0, %r16
	.word 0x87802020  ! 3083: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r18
	.word 0xd6dc2000  ! 3085: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r11
	.word 0xd6b46000  ! 3086: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 3087: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6972000  ! 3088: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	.word 0xd6f72000  ! 3089: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	mov	0x0, %r25
	.word 0xd28ec9e0  ! 3091: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r9
	.word 0xd2cf2000  ! 3092: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r9
	.word 0xd287e000  ! 3093: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0xd28504a0  ! 3094: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r9
	.word 0x87802020  ! 3095: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r21
	.word 0xd2c46000  ! 3097: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	mov	0x78, %r25
	.word 0x87802025  ! 3099: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2a7ce60  ! 3100: STWA_R	stwa	%r9, [%r31 + %r0] 0x73
	.word 0xdc9689e0  ! 3101: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r14
	.word 0xd68504a0  ! 3102: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r11
	.word 0xd685a000  ! 3103: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r11
	.word 0x87802072  ! 3104: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6d76000  ! 3105: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	.word 0xde974e60  ! 3106: LDUHA_R	lduha	[%r29, %r0] 0x73, %r15
	.word 0xd0f78e60  ! 3107: STXA_R	stxa	%r8, [%r30 + %r0] 0x73
	.word 0xd4948400  ! 3108: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	.word 0xd4f72000  ! 3109: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	mov	0x7c0, %r21
	mov	0x8, %r16
	.word 0x87802072  ! 3112: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3113: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3114: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r24
	.word 0xdc94c400  ! 3116: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	.word 0xdc8f6000  ! 3117: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xd0de89e0  ! 3118: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r8
	.word 0xd2dc8400  ! 3119: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0xde970e60  ! 3120: LDUHA_R	lduha	[%r28, %r0] 0x73, %r15
	mov	0x60, %r16
	.word 0xdebfa000  ! 3122: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xdecd84a0  ! 3124: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r15
	.word 0xd2cfce80  ! 3125: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r9
	.word 0xd297e000  ! 3126: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	mov	0x60, %r16
	.word 0x87802025  ! 3128: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3129: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r20
	mov	0x58, %r19
	.word 0xd29c6000  ! 3132: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	.word 0xd2f46000  ! 3133: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 3134: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdec44400  ! 3135: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0xdeafa000  ! 3136: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 3137: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 3138: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3139: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdecc2000  ! 3140: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	.word 0x87802025  ! 3141: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdead6000  ! 3142: STBA_I	stba	%r15, [%r21 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0x87802074  ! 3144: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r16
	mov	0x0, %r25
	.word 0x8780204f  ! 3147: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0d6c9e0  ! 3148: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r8
	.word 0xd0962000  ! 3149: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r8
	.word 0xd0be2000  ! 3150: STDA_I	stda	%r8, [%r24 + 0x0000] %asi
	.word 0x87802073  ! 3151: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 3152: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd88dc4a0  ! 3153: LDUBA_R	lduba	[%r23, %r0] 0x25, %r12
	mov	0x3c8, %r23
	mov	0x78, %r27
	.word 0xd8b7e000  ! 3156: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xda8e89e0  ! 3158: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r13
	.word 0xd4df8e60  ! 3159: LDXA_R	ldxa	[%r30, %r0] 0x73, %r10
	mov	0x3c8, %r21
	.word 0xd49fe000  ! 3161: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0x87802073  ! 3162: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 3163: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f8, %r23
	.word 0xd4c5e000  ! 3165: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r10
	.word 0xd4bc8400  ! 3166: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	.word 0xd485e000  ! 3167: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r10
	.word 0xd48d6000  ! 3168: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r10
	.word 0xd49da000  ! 3169: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r10
	mov	0x48, %r17
	.word 0xd8f7ce40  ! 3171: STXA_R	stxa	%r12, [%r31 + %r0] 0x72
	.word 0xd89da000  ! 3172: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r12
	.word 0xd6af0e40  ! 3173: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	.word 0xdcb48400  ! 3174: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	mov	0x7d0, %r22
	.word 0xdcdd6000  ! 3176: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r14
	mov	0x40, %r18
	.word 0xdcf56000  ! 3178: STXA_I	stxa	%r14, [%r21 + 0x0000] %asi
	.word 0xdea689e0  ! 3179: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	mov	0x28, %r24
	.word 0x87802073  ! 3181: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeafa000  ! 3182: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	mov	0x60, %r26
	.word 0x87802073  ! 3184: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2a7ce60  ! 3185: STWA_R	stwa	%r9, [%r31 + %r0] 0x73
	.word 0xdcdf8e40  ! 3186: LDXA_R	ldxa	[%r30, %r0] 0x72, %r14
	.word 0xd88c8400  ! 3187: LDUBA_R	lduba	[%r18, %r0] 0x20, %r12
	.word 0x87802025  ! 3188: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bda000  ! 3189: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	.word 0xd6ce09e0  ! 3190: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r11
	mov	0x7e8, %r22
	.word 0xd6c5a000  ! 3192: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r11
	.word 0xd6bd2000  ! 3193: STDA_I	stda	%r11, [%r20 + 0x0000] %asi
	.word 0xd2bf0e40  ! 3194: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	.word 0x87802073  ! 3195: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r19
	mov	0x3e0, %r22
	mov	0x7c0, %r20
	.word 0xded78e80  ! 3199: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r15
	mov	0x10, %r24
	.word 0xdec72000  ! 3201: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	mov	0x58, %r27
	.word 0xdeb76000  ! 3203: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xd8af0e40  ! 3204: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	.word 0xd8d7a000  ! 3205: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0xdc8d84a0  ! 3206: LDUBA_R	lduba	[%r22, %r0] 0x25, %r14
	.word 0xdcbfe000  ! 3207: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdcbf6000  ! 3208: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdc8f6000  ! 3209: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdccfa000  ! 3210: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xdccf6000  ! 3211: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcb7e000  ! 3212: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xdef7ce80  ! 3213: STXA_R	stxa	%r15, [%r31 + %r0] 0x74
	.word 0xdedf0e60  ! 3214: LDXA_R	ldxa	[%r28, %r0] 0x73, %r15
	.word 0xd6df0e40  ! 3215: LDXA_R	ldxa	[%r28, %r0] 0x72, %r11
	.word 0xd0f4c400  ! 3216: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	wr_tick_cmpr_0_26:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x9e, %g2
	or	%g4, 0x9c, %g4
	or	%g6, 0xcb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd08fe000  ! 3218: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	.word 0x87802074  ! 3219: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0bf2000  ! 3220: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xdcb504a0  ! 3221: STHA_R	stha	%r14, [%r20 + %r0] 0x25
	.word 0xd2af4e80  ! 3222: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	mov	0x48, %r27
	.word 0xdc8ec9e0  ! 3224: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r14
	.word 0xdcafa000  ! 3225: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	mov	0x3c8, %r20
	mov	0x7c8, %r20
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd4f78e80  ! 3229: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	wr_tick_cmpr_0_27:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xd8, %g2
	or	%g4, 0xe4, %g4
	or	%g6, 0x91, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4b7e000  ! 3231: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd4afa000  ! 3232: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 3233: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2ce49e0  ! 3234: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r9
	mov	0x60, %r19
	.word 0xd8d74e80  ! 3236: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r12
	mov	0x10, %r17
	.word 0xd8a6a000  ! 3238: STWA_I	stwa	%r12, [%r26 + 0x0000] %asi
	.word 0x87802025  ! 3239: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r26
	.word 0xd0f44400  ! 3241: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd0f56000  ! 3242: STXA_I	stxa	%r8, [%r21 + 0x0000] %asi
	mov	0x10, %r27
	.word 0xd2a44400  ! 3244: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xd2b52000  ! 3245: STHA_I	stha	%r9, [%r20 + 0x0000] %asi
	.word 0xd8be09e0  ! 3246: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	.word 0xd097ce80  ! 3247: LDUHA_R	lduha	[%r31, %r0] 0x74, %r8
	.word 0xd0bec9e0  ! 3248: STDA_R	stda	%r8, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 3249: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3250: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c0, %r23
	.word 0xdebf0e40  ! 3252: STDA_R	stda	%r15, [%r28 + %r0] 0x72
	.word 0xd6afce80  ! 3253: STBA_R	stba	%r11, [%r31 + %r0] 0x74
	.word 0xd6afe000  ! 3254: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xdab74e40  ! 3255: STHA_R	stha	%r13, [%r29 + %r0] 0x72
	mov	0x50, %r26
	.word 0xd2bf8e80  ! 3257: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	.word 0x87802025  ! 3258: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2cd2000  ! 3259: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r9
	.word 0xd0f7ce40  ! 3260: STXA_R	stxa	%r8, [%r31 + %r0] 0x72
	.word 0xd0d56000  ! 3261: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r8
	.word 0x87802020  ! 3262: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_0_28:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf3, %g2
	or	%g4, 0xac, %g4
	or	%g6, 0xfc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0bca000  ! 3264: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0xd28f8e40  ! 3265: LDUBA_R	lduba	[%r30, %r0] 0x72, %r9
	.word 0xd2cc6000  ! 3266: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	mov	0x18, %r17
	.word 0xd8bcc400  ! 3268: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0xd8dca000  ! 3269: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	mov	0x7d0, %r21
	mov	0x18, %r26
	.word 0xdacec9e0  ! 3272: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r13
	.word 0x8780204f  ! 3273: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3274: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa42000  ! 3275: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	mov	0x8, %r26
	mov	0x3c8, %r23
	.word 0xdabca000  ! 3278: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xd4b6c9e0  ! 3279: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0xd4bc6000  ! 3280: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xd4cce000  ! 3281: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	mov	0x38, %r16
	.word 0xd0848400  ! 3283: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r8
	.word 0x87802073  ! 3284: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb5c4a0  ! 3285: STHA_R	stha	%r15, [%r23 + %r0] 0x25
	mov	0x0, %r19
	.word 0xd6cc0400  ! 3287: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r11
	.word 0x87802074  ! 3288: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 3289: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4af8e80  ! 3290: STBA_R	stba	%r10, [%r30 + %r0] 0x74
	.word 0xda8f8e40  ! 3291: LDUBA_R	lduba	[%r30, %r0] 0x72, %r13
	.word 0xd8a74e80  ! 3292: STWA_R	stwa	%r12, [%r29 + %r0] 0x74
	.word 0xd8f56000  ! 3293: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 3294: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8aca000  ! 3295: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0xd88c6000  ! 3296: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	.word 0xd8a584a0  ! 3297: STWA_R	stwa	%r12, [%r22 + %r0] 0x25
	mov	0x30, %r17
	.word 0xdacc8400  ! 3299: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r13
	.word 0xdac4e000  ! 3300: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r13
	.word 0xd0d4c400  ! 3301: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	.word 0xdebf8e80  ! 3302: STDA_R	stda	%r15, [%r30 + %r0] 0x74
	.word 0x87802072  ! 3303: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7e0, %r20
	mov	0x3e8, %r20
	.word 0xdef7e000  ! 3306: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xdef7e000  ! 3307: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xde9f2000  ! 3308: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	mov	0x18, %r27
	.word 0xd0f4c400  ! 3310: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0xd0a7a000  ! 3311: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0xd08c8400  ! 3313: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0xd097e000  ! 3314: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xdccc8400  ! 3315: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	.word 0x87802074  ! 3316: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcdfe000  ! 3317: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xdab74e80  ! 3318: STHA_R	stha	%r13, [%r29 + %r0] 0x74
	.word 0xdea4c400  ! 3319: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	.word 0xd8d4c400  ! 3320: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0x87802074  ! 3321: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6c74e40  ! 3322: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r11
	mov	0x20, %r27
	mov	0x3f0, %r20
	.word 0xd6f7e000  ! 3325: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xd6972000  ! 3327: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	.word 0xd68fa000  ! 3328: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	mov	0x30, %r26
	.word 0xd8a609e0  ! 3330: STWA_R	stwa	%r12, [%r24 + %r0] 0x4f
	.word 0xd0af4e80  ! 3331: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	.word 0xde97ce80  ! 3332: LDUHA_R	lduha	[%r31, %r0] 0x74, %r15
	.word 0xdebc0400  ! 3333: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0xdecfa000  ! 3334: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	wr_tick_cmpr_0_29:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xcd, %g2
	or	%g4, 0xd2, %g4
	or	%g6, 0xe0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 3336: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f609e0  ! 3337: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	.word 0xd0b46000  ! 3338: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	mov	0x8, %r17
	.word 0xd0cc2000  ! 3340: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	.word 0xdadc0400  ! 3341: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	.word 0xdad4a000  ! 3342: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0x87802072  ! 3343: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f0, %r22
	.word 0xdaa72000  ! 3345: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xda9fa000  ! 3347: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	mov	0x8, %r27
	.word 0xdac76000  ! 3349: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3350: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r25
	.word 0xdabca000  ! 3352: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdebf4e60  ! 3353: STDA_R	stda	%r15, [%r29 + %r0] 0x73
	.word 0xdeac6000  ! 3354: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0xdaf40400  ! 3356: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	mov	0x70, %r27
	mov	0x40, %r27
	mov	0x28, %r17
	.word 0xda942000  ! 3360: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	mov	0x3e8, %r23
	.word 0xd6f70e60  ! 3362: STXA_R	stxa	%r11, [%r28 + %r0] 0x73
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd6cce000  ! 3364: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r11
	.word 0xd4f504a0  ! 3365: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0xd6cfce80  ! 3366: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r11
	.word 0xd68c2000  ! 3367: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r11
	mov	0x60, %r19
	.word 0xdeacc400  ! 3369: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0x87802074  ! 3370: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdebfe000  ! 3371: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xd0bcc400  ! 3372: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0xd0afe000  ! 3373: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xdca74e40  ! 3374: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	.word 0xdc8f6000  ! 3375: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdebc0400  ! 3376: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0x87802072  ! 3377: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc8fce40  ! 3378: LDUBA_R	lduba	[%r31, %r0] 0x72, %r14
	.word 0x8780204f  ! 3379: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc966000  ! 3380: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r14
	mov	0x50, %r19
	mov	0x70, %r18
	.word 0xd8af8e80  ! 3383: STBA_R	stba	%r12, [%r30 + %r0] 0x74
	mov	0x10, %r19
	.word 0xdedd04a0  ! 3385: LDXA_R	ldxa	[%r20, %r0] 0x25, %r15
	.word 0xded40400  ! 3386: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	.word 0xdab609e0  ! 3387: STHA_R	stha	%r13, [%r24 + %r0] 0x4f
	.word 0xd4870e40  ! 3388: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r10
	.word 0xd4d6a000  ! 3389: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r10
	.word 0xd8df0e40  ! 3390: LDXA_R	ldxa	[%r28, %r0] 0x72, %r12
	.word 0xd896a000  ! 3391: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r12
	.word 0xd8f6a000  ! 3392: STXA_I	stxa	%r12, [%r26 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd4f48400  ! 3394: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xd48ee000  ! 3395: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 3396: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r26
	.word 0xded609e0  ! 3398: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r15
	mov	0x38, %r19
	.word 0x87802072  ! 3400: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3401: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3402: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3403: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde976000  ! 3404: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	mov	0x0, %r26
	.word 0xdebfe000  ! 3406: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xd4948400  ! 3407: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	.word 0xd4f7ce80  ! 3408: STXA_R	stxa	%r10, [%r31 + %r0] 0x74
	.word 0xd4afe000  ! 3409: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd497e000  ! 3410: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	mov	0x78, %r27
	.word 0xd4a72000  ! 3412: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd497a000  ! 3413: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	mov	0x7e8, %r23
	.word 0xd4978e40  ! 3415: LDUHA_R	lduha	[%r30, %r0] 0x72, %r10
	.word 0xd0d7ce80  ! 3416: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r8
	.word 0x8780204f  ! 3417: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f6a000  ! 3418: STXA_I	stxa	%r8, [%r26 + 0x0000] %asi
	mov	0x3f0, %r20
	.word 0x87802072  ! 3420: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0cfa000  ! 3421: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0xdac40400  ! 3422: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	.word 0xd8bf8e60  ! 3423: STDA_R	stda	%r12, [%r30 + %r0] 0x73
	.word 0xd8bf2000  ! 3424: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd0af0e40  ! 3425: STBA_R	stba	%r8, [%r28 + %r0] 0x72
	mov	0x70, %r19
	.word 0x87802072  ! 3427: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0d76000  ! 3428: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	mov	0x0, %r27
	mov	0x20, %r16
	.word 0xd0c76000  ! 3431: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0x87802074  ! 3432: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f70e80  ! 3433: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	.word 0xd2c649e0  ! 3434: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r9
	.word 0x87802020  ! 3435: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a4e000  ! 3436: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	mov	0x70, %r26
	mov	0x60, %r19
	.word 0xdec40400  ! 3439: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xde84a000  ! 3440: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	mov	0x18, %r17
	mov	0x8, %r18
	mov	0x40, %r18
	mov	0x3c0, %r22
	mov	0x7d8, %r23
	.word 0xdebce000  ! 3446: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xd2c48400  ! 3447: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0xd2846000  ! 3448: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r9
	.word 0xd8dc0400  ! 3449: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0xdecc8400  ! 3450: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	.word 0xde846000  ! 3451: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3452: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde842000  ! 3453: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	.word 0xd2a44400  ! 3454: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xdad48400  ! 3455: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0xdadce000  ! 3456: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0x87802074  ! 3457: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bd84a0  ! 3458: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	mov	0x68, %r26
	.word 0x8780204f  ! 3460: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8dea000  ! 3461: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r12
	mov	0x30, %r18
	.word 0xd8b6a000  ! 3463: STHA_I	stha	%r12, [%r26 + 0x0000] %asi
	.word 0xd6a70e40  ! 3464: STWA_R	stwa	%r11, [%r28 + %r0] 0x72
	.word 0x87802074  ! 3465: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcd4c400  ! 3466: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	mov	0x40, %r24
	.word 0xdcd7e000  ! 3468: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	mov	0x40, %r19
	.word 0xdcdf2000  ! 3470: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xd0afce60  ! 3471: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	mov	0x20, %r19
	.word 0xd0d7e000  ! 3473: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0b72000  ! 3474: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd8bdc4a0  ! 3475: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	.word 0x87802020  ! 3476: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b42000  ! 3477: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0x87802072  ! 3479: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8c7a000  ! 3480: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xdcbf8e40  ! 3481: STDA_R	stda	%r14, [%r30 + %r0] 0x72
	.word 0x87802020  ! 3482: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcac6000  ! 3483: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xdcb4e000  ! 3484: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xdc942000  ! 3485: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	mov	0x48, %r27
	mov	0x18, %r27
	.word 0xded44400  ! 3488: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	mov	0x3f0, %r21
	.word 0xde94a000  ! 3490: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	mov	0x7e8, %r20
	.word 0xdeaca000  ! 3492: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	mov	0x48, %r16
	.word 0xdeb46000  ! 3494: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 3495: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f40400  ! 3496: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xd4af8e60  ! 3497: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	.word 0x87802020  ! 3498: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd287ce40  ! 3499: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r9
	.word 0xd2ac6000  ! 3500: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	mov	0x3d8, %r21
	.word 0xd6f48400  ! 3502: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xd6b4a000  ! 3503: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd6f42000  ! 3504: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 3505: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b52000  ! 3506: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	.word 0xd2ac4400  ! 3507: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xd2f56000  ! 3508: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	.word 0xd2d5e000  ! 3509: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r9
	mov	0x40, %r17
	mov	0x78, %r19
	mov	0x7d0, %r23
	mov	0x48, %r24
	.word 0xd2c5e000  ! 3514: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r9
	mov	0x3c8, %r20
	.word 0x87802025  ! 3516: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r27
	.word 0x87802073  ! 3518: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb4c400  ! 3519: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0x87802074  ! 3520: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 3521: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r19
	.word 0x87802074  ! 3523: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc9f2000  ! 3524: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xd8b40400  ! 3525: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xd4c609e0  ! 3526: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r10
	mov	0x28, %r19
	.word 0xde8e09e0  ! 3528: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r15
	.word 0xdec72000  ! 3529: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0x87802025  ! 3530: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd4b40400  ! 3532: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0x87802074  ! 3533: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0cf0e80  ! 3534: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r8
	mov	0x3e0, %r20
	mov	0x3d0, %r20
	wr_tick_cmpr_0_30:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa9, %g2
	or	%g4, 0xcd, %g4
	or	%g6, 0x9b, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802074  ! 3538: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 3539: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0976000  ! 3540: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd087a000  ! 3541: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	mov	0x3e8, %r20
	.word 0xd0cfa000  ! 3543: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	mov	0x68, %r26
	.word 0xd0c7a000  ! 3545: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0afe000  ! 3546: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0xdc940400  ! 3548: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0xdc9fe000  ! 3549: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xdc872000  ! 3550: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcaf6000  ! 3551: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 3552: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca4a000  ! 3553: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0xd8f70e40  ! 3554: STXA_R	stxa	%r12, [%r28 + %r0] 0x72
	.word 0xd8bce000  ! 3555: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	mov	0x0, %r27
	.word 0xd8c46000  ! 3557: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r12
	.word 0x87802074  ! 3558: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 3559: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 3560: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 3561: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8af6000  ! 3562: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 3563: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f0, %r23
	.word 0xd4df8e60  ! 3565: LDXA_R	ldxa	[%r30, %r0] 0x73, %r10
	.word 0xdec48400  ! 3566: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	.word 0xd4c44400  ! 3567: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r10
	.word 0xdaaf4e60  ! 3568: STBA_R	stba	%r13, [%r29 + %r0] 0x73
	.word 0xda862000  ! 3569: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r13
	.word 0xdace09e0  ! 3570: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r13
	.word 0xdab6e000  ! 3571: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	.word 0x8780204f  ! 3572: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r27
	.word 0xd69f4e60  ! 3574: LDDA_R	ldda	[%r29, %r0] 0x73, %r11
	.word 0xdaaf0e80  ! 3575: STBA_R	stba	%r13, [%r28 + %r0] 0x74
	.word 0xd0af8e40  ! 3576: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	mov	0x7c8, %r22
	mov	0x3f8, %r21
	.word 0xd0862000  ! 3579: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r8
	.word 0xd08e2000  ! 3580: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r8
	.word 0xd0f62000  ! 3581: STXA_I	stxa	%r8, [%r24 + 0x0000] %asi
	mov	0x7d0, %r22
	mov	0x7d0, %r23
	.word 0x87802074  ! 3584: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0cfa000  ! 3585: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	mov	0x7d8, %r21
	mov	0x38, %r26
	.word 0xd08f6000  ! 3588: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r8
	mov	0x28, %r18
	.word 0xdea44400  ! 3590: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xda848400  ! 3591: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r13
	.word 0xdef70e40  ! 3592: STXA_R	stxa	%r15, [%r28 + %r0] 0x72
	.word 0xded7a000  ! 3593: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xde8f2000  ! 3594: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xdebfa000  ! 3595: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xd4d7ce60  ! 3596: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r10
	mov	0x30, %r17
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x0, %r26
	.word 0x87802073  ! 3600: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda9f0e60  ! 3601: LDDA_R	ldda	[%r28, %r0] 0x73, %r13
	.word 0xda9f6000  ! 3602: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xda8fe000  ! 3603: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xdab7a000  ! 3604: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xde87ce60  ! 3605: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r15
	.word 0xdedf6000  ! 3606: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xdef7a000  ! 3607: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdeb7e000  ! 3608: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xde8fa000  ! 3609: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	mov	0x18, %r17
	mov	0x8, %r26
	.word 0xde8f6000  ! 3612: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	.word 0xdec76000  ! 3613: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xded7a000  ! 3614: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	mov	0x10, %r19
	.word 0xde97e000  ! 3616: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3617: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f689e0  ! 3618: STXA_R	stxa	%r9, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 3619: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3620: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd887ce80  ! 3621: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r12
	mov	0x78, %r17
	.word 0xd8bc6000  ! 3623: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3624: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r21
	.word 0xd6d70e40  ! 3626: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r11
	.word 0xd2a70e40  ! 3627: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	.word 0xd284a000  ! 3628: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	mov	0x3d0, %r22
	mov	0x20, %r17
	.word 0xde978e80  ! 3631: LDUHA_R	lduha	[%r30, %r0] 0x74, %r15
	.word 0xdedce000  ! 3632: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r15
	.word 0xd0f40400  ! 3633: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	mov	0x7c0, %r21
	mov	0x78, %r19
	.word 0xdcc544a0  ! 3636: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r14
	.word 0xd8d584a0  ! 3637: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r12
	mov	0x3e0, %r22
	.word 0xd2bd44a0  ! 3639: STDA_R	stda	%r9, [%r21 + %r0] 0x25
	.word 0xd4944400  ! 3640: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	mov	0x78, %r25
	.word 0xd4a7ce80  ! 3642: STWA_R	stwa	%r10, [%r31 + %r0] 0x74
	mov	0x58, %r27
	.word 0xd4a4a000  ! 3644: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xd4f4a000  ! 3645: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 3646: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b46000  ! 3647: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xd2b78e80  ! 3648: STHA_R	stha	%r9, [%r30 + %r0] 0x74
	.word 0xdef4c400  ! 3649: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xd2f6c9e0  ! 3650: STXA_R	stxa	%r9, [%r27 + %r0] 0x4f
	.word 0xdad7ce60  ! 3651: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r13
	wr_tick_cmpr_0_31:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xef, %g2
	or	%g4, 0xdb, %g4
	or	%g6, 0x9c, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0bdc4a0  ! 3653: STDA_R	stda	%r8, [%r23 + %r0] 0x25
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802020  ! 3655: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda944400  ! 3656: LDUHA_R	lduha	[%r17, %r0] 0x20, %r13
	mov	0x70, %r18
	.word 0xdaf4a000  ! 3658: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0xd6f70e60  ! 3659: STXA_R	stxa	%r11, [%r28 + %r0] 0x73
	.word 0xd6bc2000  ! 3660: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0xd0ad84a0  ! 3661: STBA_R	stba	%r8, [%r22 + %r0] 0x25
	.word 0xd0dca000  ! 3662: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	.word 0xda97ce60  ! 3663: LDUHA_R	lduha	[%r31, %r0] 0x73, %r13
	.word 0xd2ce89e0  ! 3664: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r9
	mov	0x10, %r25
	.word 0xd28c2000  ! 3666: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	mov	0x50, %r19
	.word 0x87802025  ! 3668: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x3d8, %r20
	.word 0xd2a56000  ! 3671: STWA_I	stwa	%r9, [%r21 + 0x0000] %asi
	.word 0xd2bde000  ! 3672: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	.word 0xd2cd2000  ! 3673: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r9
	mov	0x58, %r17
	.word 0xd29d6000  ! 3675: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r9
	.word 0xd29d6000  ! 3676: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3677: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b70e80  ! 3678: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	mov	0x70, %r16
	.word 0xd6ace000  ! 3680: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	mov	0x0, %r27
	.word 0xd6ac6000  ! 3682: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	mov	0x28, %r16
	mov	0x60, %r18
	.word 0xd6ace000  ! 3685: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0xd68ca000  ! 3686: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r11
	.word 0xd6bce000  ! 3687: STDA_I	stda	%r11, [%r19 + 0x0000] %asi
	mov	0x38, %r16
	.word 0xdaa7ce60  ! 3689: STWA_R	stwa	%r13, [%r31 + %r0] 0x73
	.word 0x87802025  ! 3690: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 3691: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d0, %r20
	.word 0xd8b70e60  ! 3693: STHA_R	stha	%r12, [%r28 + %r0] 0x73
	.word 0xd6d70e60  ! 3694: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r11
	.word 0x87802020  ! 3695: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cc6000  ! 3696: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r11
	.word 0xd2f5c4a0  ! 3697: STXA_R	stxa	%r9, [%r23 + %r0] 0x25
	.word 0xd2f42000  ! 3698: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x3e8, %r23
	.word 0xd4f44400  ! 3701: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0x87802074  ! 3702: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b76000  ! 3703: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd8f584a0  ! 3704: STXA_R	stxa	%r12, [%r22 + %r0] 0x25
	.word 0xd8b72000  ! 3705: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd4ac0400  ! 3706: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	mov	0x28, %r27
	.word 0xd0de49e0  ! 3708: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r8
	.word 0xdaa78e80  ! 3709: STWA_R	stwa	%r13, [%r30 + %r0] 0x74
	mov	0x38, %r19
	mov	0x7c8, %r20
	.word 0xdabf6000  ! 3712: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xdaa7a000  ! 3713: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	mov	0x3d8, %r22
	.word 0xdaafa000  ! 3715: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 3716: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda9d6000  ! 3717: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r13
	.word 0xd0d544a0  ! 3718: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r8
	.word 0x87802025  ! 3719: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde9c0400  ! 3720: LDDA_R	ldda	[%r16, %r0] 0x20, %r15
	.word 0xdebd6000  ! 3721: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	.word 0xdea5e000  ! 3722: STWA_I	stwa	%r15, [%r23 + 0x0000] %asi
	.word 0xdeb5e000  ! 3723: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	.word 0xd2ccc400  ! 3724: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	.word 0xd2bc0400  ! 3725: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	mov	0x3e0, %r20
	.word 0xd2f5a000  ! 3727: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	mov	0x0, %r27
	.word 0xd6bec9e0  ! 3729: STDA_R	stda	%r11, [%r27 + %r0] 0x4f
	.word 0xd4af4e60  ! 3730: STBA_R	stba	%r10, [%r29 + %r0] 0x73
	.word 0xd49de000  ! 3731: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r10
	.word 0xd4c56000  ! 3732: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r10
	.word 0xd4ade000  ! 3733: STBA_I	stba	%r10, [%r23 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xd4cd2000  ! 3735: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r10
	.word 0x87802020  ! 3736: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ac4400  ! 3737: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	mov	0x3e8, %r20
	.word 0xd68ce000  ! 3739: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	.word 0xd6ace000  ! 3740: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 3741: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6bfa000  ! 3742: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd29d04a0  ! 3743: LDDA_R	ldda	[%r20, %r0] 0x25, %r9
	.word 0xd2f4c400  ! 3744: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0x87802074  ! 3745: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a74e40  ! 3746: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	.word 0xd4ddc4a0  ! 3747: LDXA_R	ldxa	[%r23, %r0] 0x25, %r10
	.word 0xd49f2000  ! 3748: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0x87802073  ! 3749: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf44400  ! 3750: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0xdaaf6000  ! 3751: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xd8b48400  ! 3752: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0xd8cf6000  ! 3753: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0xd8d7e000  ! 3754: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0xd89fe000  ! 3755: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0xd8b48400  ! 3756: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0xdc9c4400  ! 3757: LDDA_R	ldda	[%r17, %r0] 0x20, %r14
	.word 0xdc8f6000  ! 3758: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xd68ec9e0  ! 3759: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r11
	mov	0x7e8, %r22
	.word 0x87802072  ! 3761: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a78e60  ! 3762: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	.word 0xd49fa000  ! 3763: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0xd4cfa000  ! 3764: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0xdea48400  ! 3765: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xd4874e80  ! 3766: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r10
	.word 0xd4afe000  ! 3767: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd4dfe000  ! 3768: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802025  ! 3769: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd49d2000  ! 3770: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r10
	mov	0x48, %r25
	mov	0x58, %r17
	.word 0xd4a52000  ! 3773: STWA_I	stwa	%r10, [%r20 + 0x0000] %asi
	.word 0xd4bde000  ! 3774: STDA_I	stda	%r10, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 3775: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r16
	.word 0xda844400  ! 3777: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r13
	mov	0x8, %r27
	.word 0xdac7e000  ! 3779: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xdac7e000  ! 3780: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xda9f2000  ! 3781: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	mov	0x3f0, %r23
	.word 0x87802073  ! 3783: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f70e40  ! 3784: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	.word 0xdeaf8e40  ! 3785: STBA_R	stba	%r15, [%r30 + %r0] 0x72
	.word 0xd694c400  ! 3786: LDUHA_R	lduha	[%r19, %r0] 0x20, %r11
	mov	0x8, %r19
	.word 0xdabc0400  ! 3788: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xd09d84a0  ! 3789: LDDA_R	ldda	[%r22, %r0] 0x25, %r8
	.word 0x87802020  ! 3790: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef544a0  ! 3791: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	.word 0xd8ac4400  ! 3792: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	mov	0x8, %r26
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x10, %r19
	.word 0xd8dca000  ! 3796: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	.word 0x87802073  ! 3797: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8bfa000  ! 3798: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd8b7e000  ! 3799: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0xd8dfe000  ! 3800: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xd88f6000  ! 3801: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xd88fa000  ! 3802: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	mov	0x3e8, %r21
	.word 0xd8f72000  ! 3804: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 3805: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r27
	.word 0xd89ce000  ! 3807: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	.word 0x87802072  ! 3808: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29d44a0  ! 3809: LDDA_R	ldda	[%r21, %r0] 0x25, %r9
	.word 0xd2c7a000  ! 3810: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	.word 0xd48649e0  ! 3811: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r10
	.word 0xdeae09e0  ! 3812: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	.word 0xdebf2000  ! 3813: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xde9c8400  ! 3814: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	.word 0xde9f6000  ! 3815: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0xdea7e000  ! 3816: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xdef7a000  ! 3817: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdece89e0  ! 3818: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r15
	mov	0x38, %r25
	.word 0xdebf2000  ! 3820: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xdea7e000  ! 3821: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	mov	0x30, %r19
	.word 0xdebfa000  ! 3823: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xdedf6000  ! 3824: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xdea72000  ! 3825: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	mov	0x68, %r26
	mov	0x3c0, %r21
	.word 0x8780204f  ! 3828: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xded62000  ! 3829: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r15
	.word 0xdc940400  ! 3830: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0xdcf6a000  ! 3831: STXA_I	stxa	%r14, [%r26 + 0x0000] %asi
	.word 0xdcf6e000  ! 3832: STXA_I	stxa	%r14, [%r27 + 0x0000] %asi
	.word 0xd6b48400  ! 3833: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd6cee000  ! 3834: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r11
	.word 0x87802072  ! 3835: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 3836: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f76000  ! 3837: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 3838: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdac78e60  ! 3839: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r13
	.word 0xda8fa000  ! 3840: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xdac7a000  ! 3841: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	mov	0x7e0, %r20
	mov	0x7e8, %r23
	.word 0xd29d84a0  ! 3844: LDDA_R	ldda	[%r22, %r0] 0x25, %r9
	mov	0x10, %r25
	.word 0x87802073  ! 3846: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r19
	.word 0x8780204f  ! 3848: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xded4c400  ! 3849: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r15
	.word 0xd8c78e40  ! 3850: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r12
	mov	0x38, %r27
	mov	0x7f8, %r22
	.word 0xd8ae6000  ! 3853: STBA_I	stba	%r12, [%r25 + 0x0000] %asi
	.word 0xdcf74e40  ! 3854: STXA_R	stxa	%r14, [%r29 + %r0] 0x72
	.word 0xdcde6000  ! 3855: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r14
	.word 0xd8ce09e0  ! 3856: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r12
	.word 0xd8866000  ! 3857: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r12
	.word 0xd8d6a000  ! 3858: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r12
	.word 0x87802025  ! 3859: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8852000  ! 3860: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r12
	mov	0x68, %r25
	.word 0xd8ad6000  ! 3862: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	.word 0xd8f52000  ! 3863: STXA_I	stxa	%r12, [%r20 + 0x0000] %asi
	.word 0x87802072  ! 3864: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r25
	.word 0x87802020  ! 3866: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r24
	.word 0xd6df0e60  ! 3868: LDXA_R	ldxa	[%r28, %r0] 0x73, %r11
	.word 0xd684e000  ! 3869: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r11
	.word 0xd6dc2000  ! 3870: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r11
	.word 0xd68c6000  ! 3871: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r11
	mov	0x68, %r24
	.word 0xd6c46000  ! 3873: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r11
	.word 0xd6ac6000  ! 3874: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xd4df0e80  ! 3875: LDXA_R	ldxa	[%r28, %r0] 0x74, %r10
	.word 0xd8f40400  ! 3876: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xd884c400  ! 3877: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	.word 0x87802074  ! 3878: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r19
	mov	0x7e8, %r23
	.word 0xdac44400  ! 3881: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r13
	.word 0xdad72000  ! 3882: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	wr_tick_cmpr_0_32:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe2, %g2
	or	%g4, 0xe1, %g4
	or	%g6, 0xe3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 3884: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r25
	.word 0xd4f7ce80  ! 3886: STXA_R	stxa	%r10, [%r31 + %r0] 0x74
	.word 0xd48fa000  ! 3887: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xd4df6000  ! 3888: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0xdcbe09e0  ! 3889: STDA_R	stda	%r14, [%r24 + %r0] 0x4f
	.word 0xdc87a000  ! 3890: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xd2b584a0  ! 3891: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0xd2bfe000  ! 3892: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd29f2000  ! 3893: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xdecc4400  ! 3894: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r15
	.word 0xde876000  ! 3895: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xd6bdc4a0  ! 3896: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	mov	0x0, %r19
	.word 0xd8ae49e0  ! 3898: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0xd8bfa000  ! 3899: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd8cfa000  ! 3900: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd8bfa000  ! 3901: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd887e000  ! 3902: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	mov	0x7c0, %r22
	.word 0xd88f2000  ! 3904: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0xd0afce60  ! 3905: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	mov	0x8, %r18
	.word 0x87802074  ! 3907: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0872000  ! 3908: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xdea74e60  ! 3909: STWA_R	stwa	%r15, [%r29 + %r0] 0x73
	.word 0xd68e49e0  ! 3910: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r11
	.word 0xd697a000  ! 3911: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0xd0ac0400  ! 3912: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	mov	0x30, %r18
	mov	0x30, %r19
	.word 0xd0bf6000  ! 3915: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 3916: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f76000  ! 3917: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0bf6000  ! 3918: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	mov	0x70, %r19
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xde9c8400  ! 3921: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	.word 0xd6a7ce60  ! 3922: STWA_R	stwa	%r11, [%r31 + %r0] 0x73
	.word 0x87802072  ! 3923: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3924: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd696e000  ! 3925: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	.word 0xdcdc0400  ! 3926: LDXA_R	ldxa	[%r16, %r0] 0x20, %r14
	.word 0xdcc6a000  ! 3927: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r14
	mov	0x68, %r25
	.word 0xdc9e6000  ! 3929: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r14
	mov	0x7c0, %r23
	.word 0xdcf6e000  ! 3931: STXA_I	stxa	%r14, [%r27 + 0x0000] %asi
	.word 0xdac7ce60  ! 3932: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r13
	.word 0xdabe6000  ! 3933: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	.word 0xdaf70e80  ! 3934: STXA_R	stxa	%r13, [%r28 + %r0] 0x74
	.word 0xdcc649e0  ! 3935: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r14
	.word 0xdcf6a000  ! 3936: STXA_I	stxa	%r14, [%r26 + 0x0000] %asi
	.word 0xdc8f8e60  ! 3937: LDUBA_R	lduba	[%r30, %r0] 0x73, %r14
	.word 0xdcf78e40  ! 3938: STXA_R	stxa	%r14, [%r30 + %r0] 0x72
	mov	0x18, %r25
	mov	0x7f8, %r20
	.word 0xdcb6e000  ! 3941: STHA_I	stha	%r14, [%r27 + 0x0000] %asi
	.word 0xdcb6c9e0  ! 3942: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	mov	0x20, %r24
	.word 0xdc866000  ! 3944: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r14
	.word 0xd0bd04a0  ! 3945: STDA_R	stda	%r8, [%r20 + %r0] 0x25
	.word 0x8780204f  ! 3946: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f0, %r21
	mov	0x58, %r26
	.word 0xd0862000  ! 3949: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r8
	.word 0xd0b6e000  ! 3950: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	mov	0x28, %r17
	.word 0xd0b6e000  ! 3952: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd0c6a000  ! 3954: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r8
	.word 0xd89f0e40  ! 3955: LDDA_R	ldda	[%r28, %r0] 0x72, %r12
	mov	0x50, %r17
	mov	0x3d8, %r20
	.word 0xd8d66000  ! 3958: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r12
	.word 0x87802074  ! 3959: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r16
	mov	0x68, %r26
	.word 0x87802072  ! 3962: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r25
	mov	0x50, %r19
	.word 0x87802025  ! 3965: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c0, %r22
	.word 0xd4b70e40  ! 3967: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	mov	0x30, %r24
	.word 0xd4f5a000  ! 3969: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	mov	0x7c8, %r23
	.word 0xdaf504a0  ! 3971: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	.word 0x87802074  ! 3972: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdac7a000  ! 3973: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xd4c74e40  ! 3974: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r10
	.word 0xd4972000  ! 3975: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0xd0d5c4a0  ! 3976: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r8
	.word 0xdcae09e0  ! 3977: STBA_R	stba	%r14, [%r24 + %r0] 0x4f
	.word 0xdeb44400  ! 3978: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	mov	0x70, %r16
	.word 0x87802020  ! 3980: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a78e80  ! 3981: STWA_R	stwa	%r12, [%r30 + %r0] 0x74
	.word 0xdaacc400  ! 3982: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0xda8c6000  ! 3983: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r13
	mov	0x3c8, %r20
	mov	0x78, %r16
	.word 0xdac42000  ! 3986: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	mov	0x30, %r26
	.word 0xdabce000  ! 3988: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0xd68c4400  ! 3989: LDUBA_R	lduba	[%r17, %r0] 0x20, %r11
	.word 0xd6aca000  ! 3990: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xd6bca000  ! 3991: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 3992: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc9cc400  ! 3993: LDDA_R	ldda	[%r19, %r0] 0x20, %r14
	.word 0xdcaf0e40  ! 3994: STBA_R	stba	%r14, [%r28 + %r0] 0x72
	.word 0xdcb76000  ! 3995: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 3996: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bd44a0  ! 3997: STDA_R	stda	%r11, [%r21 + %r0] 0x25
	.word 0xdc84c400  ! 3998: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	mov	0x7e8, %r22
	.word 0xdcb4e000  ! 4000: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	mov	0x7c0, %r20
	.word 0x87802025  ! 4002: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcdde000  ! 4003: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	.word 0xd48fce40  ! 4004: LDUBA_R	lduba	[%r31, %r0] 0x72, %r10
	.word 0xd4f5e000  ! 4005: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 4006: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r19
	.word 0x87802073  ! 4008: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 4009: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd486e000  ! 4010: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	.word 0xd2a4c400  ! 4011: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	mov	0x28, %r24
	.word 0x87802020  ! 4013: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4014: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f584a0  ! 4015: STXA_R	stxa	%r9, [%r22 + %r0] 0x25
	.word 0xde8544a0  ! 4016: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r15
	.word 0xdeb46000  ! 4017: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0xde842000  ! 4018: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	mov	0x30, %r17
	mov	0x28, %r27
	mov	0x28, %r24
	.word 0xdcdf0e40  ! 4022: LDXA_R	ldxa	[%r28, %r0] 0x72, %r14
	.word 0xdcdc6000  ! 4023: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	.word 0xda9f0e80  ! 4024: LDDA_R	ldda	[%r28, %r0] 0x74, %r13
	mov	0x68, %r25
	.word 0xdadce000  ! 4026: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	mov	0x7c0, %r23
	.word 0xdaf4e000  ! 4028: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xdadce000  ! 4029: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xdeb74e60  ! 4030: STHA_R	stha	%r15, [%r29 + %r0] 0x73
	.word 0xde846000  ! 4031: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0xdec4e000  ! 4032: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	mov	0x18, %r16
	mov	0x3e0, %r21
	mov	0x48, %r26
	.word 0xdef4a000  ! 4036: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 4037: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r16
	.word 0xdeb7a000  ! 4039: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xd6f48400  ! 4040: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	mov	0x60, %r18
	.word 0x87802020  ! 4042: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef689e0  ! 4043: STXA_R	stxa	%r15, [%r26 + %r0] 0x4f
	mov	0x10, %r16
	.word 0x87802025  ! 4045: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdef56000  ! 4046: STXA_I	stxa	%r15, [%r21 + 0x0000] %asi
	.word 0xdedf0e80  ! 4047: LDXA_R	ldxa	[%r28, %r0] 0x74, %r15
	.word 0xd8974e80  ! 4048: LDUHA_R	lduha	[%r29, %r0] 0x74, %r12
	.word 0xd09d04a0  ! 4049: LDDA_R	ldda	[%r20, %r0] 0x25, %r8
	.word 0xd0f52000  ! 4050: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	.word 0xd2be49e0  ! 4051: STDA_R	stda	%r9, [%r25 + %r0] 0x4f
	.word 0xd2d52000  ! 4052: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r9
	mov	0x50, %r17
	.word 0xd2c5e000  ! 4054: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r9
	mov	0x50, %r26
	.word 0x87802020  ! 4056: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29ca000  ! 4057: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	.word 0xdc8f0e80  ! 4058: LDUBA_R	lduba	[%r28, %r0] 0x74, %r14
	mov	0x58, %r18
	.word 0xdcac6000  ! 4060: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	mov	0x3e8, %r21
	mov	0x10, %r18
	.word 0xdcf46000  ! 4063: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	mov	0x68, %r27
	.word 0xdcc4e000  ! 4065: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r14
	.word 0xdcd4e000  ! 4066: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	wr_tick_cmpr_0_33:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x89, %g2
	or	%g4, 0x80, %g4
	or	%g6, 0xba, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdcdce000  ! 4068: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r14
	.word 0xd88c4400  ! 4069: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	mov	0x58, %r18
	.word 0xd8bce000  ! 4071: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd88ca000  ! 4072: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	.word 0xd8d4e000  ! 4073: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4074: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bc2000  ! 4075: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	mov	0x10, %r19
	.word 0xd8a4e000  ! 4077: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xd2a609e0  ! 4078: STWA_R	stwa	%r9, [%r24 + %r0] 0x4f
	.word 0xd294e000  ! 4079: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	.word 0xd2c4e000  ! 4080: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xd8a649e0  ! 4081: STWA_R	stwa	%r12, [%r25 + %r0] 0x4f
	.word 0xd89ca000  ! 4082: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r12
	.word 0xd8dc6000  ! 4083: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	.word 0xd0afce80  ! 4084: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0dc6000  ! 4086: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	.word 0xdadec9e0  ! 4087: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r13
	.word 0x87802020  ! 4088: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcc5c4a0  ! 4089: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r14
	.word 0xdc94e000  ! 4090: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 4091: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f0, %r21
	wr_tick_cmpr_0_34:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xfc, %g2
	or	%g4, 0x94, %g4
	or	%g6, 0xcd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdcbee000  ! 4094: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	.word 0x87802072  ! 4095: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r27
	.word 0xd2ccc400  ! 4097: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	.word 0xd6940400  ! 4098: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	mov	0x8, %r26
	.word 0xd6b76000  ! 4100: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 4101: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4102: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6d76000  ! 4103: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	.word 0xd6b7a000  ! 4104: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xdcbfce80  ! 4105: STDA_R	stda	%r14, [%r31 + %r0] 0x74
	mov	0x3c0, %r22
	.word 0xded74e60  ! 4107: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r15
	.word 0x87802020  ! 4108: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8c2000  ! 4109: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	.word 0xd68fce60  ! 4110: LDUBA_R	lduba	[%r31, %r0] 0x73, %r11
	.word 0xdcf609e0  ! 4111: STXA_R	stxa	%r14, [%r24 + %r0] 0x4f
	.word 0xd2f48400  ! 4112: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0xd2ace000  ! 4113: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0xd2bc2000  ! 4114: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xd2846000  ! 4115: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r9
	mov	0x20, %r27
	.word 0xd2946000  ! 4117: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r9
	.word 0xd08649e0  ! 4118: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r8
	.word 0xd0a4a000  ! 4119: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	mov	0x20, %r24
	.word 0x87802074  ! 4121: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 4122: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 4123: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c0, %r22
	mov	0x7d0, %r20
	mov	0x40, %r16
	.word 0xd085a000  ! 4127: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r8
	.word 0xd0d5a000  ! 4128: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r8
	mov	0x48, %r17
	.word 0x87802025  ! 4130: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0d52000  ! 4131: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r8
	.word 0xd0c5a000  ! 4132: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r8
	.word 0xd0ada000  ! 4133: STBA_I	stba	%r8, [%r22 + 0x0000] %asi
	.word 0xdad44400  ! 4134: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	wr_tick_cmpr_0_35:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xa9, %g2
	or	%g4, 0xae, %g4
	or	%g6, 0x9c, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8af8e60  ! 4136: STBA_R	stba	%r12, [%r30 + %r0] 0x73
	wr_tick_cmpr_0_36:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xac, %g2
	or	%g4, 0x9f, %g4
	or	%g6, 0xa7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0bf4e40  ! 4138: STDA_R	stda	%r8, [%r29 + %r0] 0x72
	mov	0x3f8, %r21
	.word 0xd0dd6000  ! 4140: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r8
	.word 0xd8a7ce80  ! 4141: STWA_R	stwa	%r12, [%r31 + %r0] 0x74
	mov	0x0, %r17
	.word 0xd8b52000  ! 4143: STHA_I	stha	%r12, [%r20 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xd8bd6000  ! 4145: STDA_I	stda	%r12, [%r21 + 0x0000] %asi
	.word 0xd8f52000  ! 4146: STXA_I	stxa	%r12, [%r20 + 0x0000] %asi
	.word 0x8780204f  ! 4147: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2d7ce80  ! 4148: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r9
	wr_tick_cmpr_0_37:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xbf, %g2
	or	%g4, 0xee, %g4
	or	%g6, 0xb9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7d0, %r20
	.word 0xd2948400  ! 4151: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	mov	0x68, %r26
	mov	0x18, %r19
	.word 0xd28e6000  ! 4154: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r9
	.word 0xd4b78e40  ! 4155: STHA_R	stha	%r10, [%r30 + %r0] 0x72
	.word 0xd4aee000  ! 4156: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	.word 0xd6b689e0  ! 4157: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	.word 0xd0b7ce60  ! 4158: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 4159: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 4160: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 4161: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0bee000  ! 4162: STDA_I	stda	%r8, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 4163: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f5c4a0  ! 4164: STXA_R	stxa	%r12, [%r23 + %r0] 0x25
	.word 0x87802072  ! 4165: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc970e40  ! 4166: LDUHA_R	lduha	[%r28, %r0] 0x72, %r14
	wr_tick_cmpr_0_38:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xfa, %g2
	or	%g4, 0x8e, %g4
	or	%g6, 0xe1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0948400  ! 4168: LDUHA_R	lduha	[%r18, %r0] 0x20, %r8
	.word 0xd2ae89e0  ! 4169: STBA_R	stba	%r9, [%r26 + %r0] 0x4f
	.word 0xd2b7e000  ! 4170: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 4171: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bf2000  ! 4172: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 4173: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2c7a000  ! 4174: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	mov	0x20, %r27
	.word 0xd2d76000  ! 4176: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0xd2b544a0  ! 4177: STHA_R	stha	%r9, [%r21 + %r0] 0x25
	.word 0xd6de89e0  ! 4178: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r11
	.word 0xd69f2000  ! 4179: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	mov	0x18, %r25
	.word 0xd0bdc4a0  ! 4181: STDA_R	stda	%r8, [%r23 + %r0] 0x25
	.word 0xd0b76000  ! 4182: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 4183: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c8, %r21
	.word 0xd0b66000  ! 4185: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	.word 0xde9c0400  ! 4186: LDDA_R	ldda	[%r16, %r0] 0x20, %r15
	.word 0xd6af0e40  ! 4187: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	mov	0x3e8, %r22
	mov	0x7c8, %r23
	.word 0xd6a66000  ! 4190: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	.word 0xd2b78e40  ! 4191: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	.word 0x87802074  ! 4192: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4974e80  ! 4193: LDUHA_R	lduha	[%r29, %r0] 0x74, %r10
	.word 0xd4bf2000  ! 4194: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd48f2000  ! 4195: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4f609e0  ! 4196: STXA_R	stxa	%r10, [%r24 + %r0] 0x4f
	.word 0xd2a70e80  ! 4197: STWA_R	stwa	%r9, [%r28 + %r0] 0x74
	.word 0xdabfce40  ! 4198: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	.word 0xdaa7e000  ! 4199: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xdad70e40  ! 4200: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r13
	.word 0xdef7ce60  ! 4201: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0xd8ac8400  ! 4202: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0xdcd74e60  ! 4203: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r14
	.word 0xd88c0400  ! 4204: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	.word 0x8780204f  ! 4205: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde9649e0  ! 4206: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r15
	mov	0x0, %r25
	.word 0xdacfce60  ! 4208: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r13
	.word 0xdcbf0e80  ! 4209: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	.word 0x87802020  ! 4210: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaafce60  ! 4211: STBA_R	stba	%r13, [%r31 + %r0] 0x73
	.word 0xdaaca000  ! 4212: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0xdab46000  ! 4213: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0xda8ce000  ! 4214: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	mov	0x20, %r16
	mov	0x18, %r25
	.word 0xdad42000  ! 4217: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r13
	mov	0x7e8, %r21
	.word 0xd4a70e60  ! 4219: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	mov	0x7f0, %r21
	.word 0xd0dec9e0  ! 4221: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r8
	mov	0x40, %r19
	.word 0xdebf8e40  ! 4223: STDA_R	stda	%r15, [%r30 + %r0] 0x72
	.word 0xde94e000  ! 4224: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	.word 0xde8ce000  ! 4225: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	.word 0xdc8ec9e0  ! 4226: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r14
	.word 0xdca42000  ! 4227: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xdccfce60  ! 4228: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r14
	wr_tick_cmpr_0_39:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xad, %g2
	or	%g4, 0xe6, %g4
	or	%g6, 0xf5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2ad04a0  ! 4230: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	.word 0xd2d4a000  ! 4231: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	.word 0x87802074  ! 4232: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d8, %r21
	.word 0xd694c400  ! 4234: LDUHA_R	lduha	[%r19, %r0] 0x20, %r11
	.word 0xd6c7e000  ! 4235: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xd2dc4400  ! 4236: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	mov	0x28, %r18
	mov	0x8, %r17
	.word 0xd29fe000  ! 4239: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd2dfa000  ! 4240: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xded584a0  ! 4241: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r15
	mov	0x20, %r25
	mov	0x18, %r24
	.word 0xd4f44400  ! 4244: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0x87802072  ! 4245: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2974e60  ! 4246: LDUHA_R	lduha	[%r29, %r0] 0x73, %r9
	.word 0x87802072  ! 4247: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2a72000  ! 4248: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 4249: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd69d84a0  ! 4250: LDDA_R	ldda	[%r22, %r0] 0x25, %r11
	.word 0xd6a7a000  ! 4251: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	mov	0x20, %r18
	mov	0x7f0, %r23
	.word 0xd687e000  ! 4254: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xd68f6000  ! 4255: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	mov	0x3e8, %r23
	.word 0xdc8f0e40  ! 4257: LDUBA_R	lduba	[%r28, %r0] 0x72, %r14
	.word 0xde874e40  ! 4258: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r15
	.word 0x87802072  ! 4259: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde8f0e60  ! 4260: LDUBA_R	lduba	[%r28, %r0] 0x73, %r15
	mov	0x18, %r26
	.word 0xde87a000  ! 4262: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xde87e000  ! 4263: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	mov	0x3c8, %r23
	.word 0xdabdc4a0  ! 4265: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	.word 0xdabfa000  ! 4266: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdaf7e000  ! 4267: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xda87a000  ! 4268: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0xd0c7ce80  ! 4269: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r8
	.word 0xd08f6000  ! 4270: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r8
	mov	0x3c0, %r22
	.word 0xd69f8e80  ! 4272: LDDA_R	ldda	[%r30, %r0] 0x74, %r11
	mov	0x7f8, %r23
	.word 0xd6cfe000  ! 4274: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0xd6f7a000  ! 4275: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xdcacc400  ! 4276: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0xd29ec9e0  ! 4277: LDDA_R	ldda	[%r27, %r0] 0x4f, %r9
	mov	0x0, %r27
	mov	0x30, %r19
	.word 0xd2bf2000  ! 4280: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd2bcc400  ! 4281: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xd8a4c400  ! 4282: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xd89f6000  ! 4283: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	mov	0x78, %r27
	.word 0xd8afa000  ! 4285: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xd8afa000  ! 4286: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xd8bf6000  ! 4287: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	mov	0x70, %r26
	.word 0xd8c7e000  ! 4289: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	mov	0x3d0, %r23
	.word 0xd8b7e000  ! 4291: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0xdcc7ce40  ! 4292: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r14
	.word 0xdcd72000  ! 4293: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xdcb7a000  ! 4294: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 4295: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r27
	.word 0xdcb42000  ! 4297: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xdcc46000  ! 4298: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r14
	.word 0xd29cc400  ! 4299: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	.word 0xd2af0e60  ! 4300: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	mov	0x10, %r18
	.word 0xd894c400  ! 4302: LDUHA_R	lduha	[%r19, %r0] 0x20, %r12
	.word 0xdabd04a0  ! 4303: STDA_R	stda	%r13, [%r20 + %r0] 0x25
	.word 0x87802020  ! 4304: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r16
	mov	0x38, %r27
	.word 0xda846000  ! 4307: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r13
	.word 0xd28544a0  ! 4308: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r9
	mov	0x30, %r18
	.word 0xd8ae09e0  ! 4310: STBA_R	stba	%r12, [%r24 + %r0] 0x4f
	.word 0xd8a42000  ! 4311: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd4dd04a0  ! 4312: LDXA_R	ldxa	[%r20, %r0] 0x25, %r10
	.word 0xd48c2000  ! 4313: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r10
	.word 0x87802074  ! 4314: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4dfe000  ! 4315: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	mov	0x78, %r26
	.word 0xd4a76000  ! 4317: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4bf2000  ! 4318: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 4319: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r25
	.word 0xdcb70e80  ! 4321: STHA_R	stha	%r14, [%r28 + %r0] 0x74
	.word 0x87802074  ! 4322: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc8fa000  ! 4323: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdcafe000  ! 4324: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdcdf6000  ! 4325: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	mov	0x60, %r19
	.word 0xdeb649e0  ! 4327: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	.word 0xdc9c4400  ! 4328: LDDA_R	ldda	[%r17, %r0] 0x20, %r14
	.word 0xdcafa000  ! 4329: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0xd8ac0400  ! 4331: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 4332: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd08fce60  ! 4333: LDUBA_R	lduba	[%r31, %r0] 0x73, %r8
	.word 0xdcc78e80  ! 4334: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r14
	.word 0x87802020  ! 4335: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r22
	.word 0xdc8c6000  ! 4337: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r14
	.word 0xdcf42000  ! 4338: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0xdcbca000  ! 4339: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0xdc846000  ! 4341: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	.word 0xd28f4e60  ! 4342: LDUBA_R	lduba	[%r29, %r0] 0x73, %r9
	.word 0x87802074  ! 4343: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bfa000  ! 4344: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd0b40400  ! 4345: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	mov	0x7e0, %r23
	mov	0x18, %r26
	.word 0xd0cd04a0  ! 4348: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r8
	.word 0xd0a7a000  ! 4349: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0df2000  ! 4350: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0xd8bf4e60  ! 4351: STDA_R	stda	%r12, [%r29 + %r0] 0x73
	mov	0x8, %r24
	mov	0x7c8, %r22
	.word 0xd8f74e40  ! 4354: STXA_R	stxa	%r12, [%r29 + %r0] 0x72
	.word 0xda8d44a0  ! 4355: LDUBA_R	lduba	[%r21, %r0] 0x25, %r13
	.word 0xd6848400  ! 4356: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	mov	0x3c8, %r23
	.word 0xdef7ce60  ! 4358: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0xdeaf2000  ! 4359: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xd2b74e60  ! 4360: STHA_R	stha	%r9, [%r29 + %r0] 0x73
	mov	0x7f0, %r22
	.word 0xd2bfe000  ! 4362: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd2cfe000  ! 4363: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	.word 0xd0b48400  ! 4364: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	mov	0x7f8, %r21
	.word 0xd484c400  ! 4366: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	mov	0x20, %r25
	.word 0xdca6c9e0  ! 4368: STWA_R	stwa	%r14, [%r27 + %r0] 0x4f
	.word 0xdcf76000  ! 4369: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x0, %r18
	mov	0x3e0, %r23
	.word 0xdcd72000  ! 4372: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xdcf7e000  ! 4373: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcb76000  ! 4374: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	mov	0x3c0, %r20
	mov	0x28, %r26
	.word 0x87802025  ! 4377: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf56000  ! 4378: STXA_I	stxa	%r14, [%r21 + 0x0000] %asi
	.word 0xdea40400  ! 4379: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xdecf0e60  ! 4380: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r15
	.word 0xdead6000  ! 4381: STBA_I	stba	%r15, [%r21 + 0x0000] %asi
	.word 0xde8d2000  ! 4382: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r15
	.word 0xdaacc400  ! 4383: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	mov	0x78, %r24
	.word 0xde874e80  ! 4385: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r15
	.word 0xdeada000  ! 4386: STBA_I	stba	%r15, [%r22 + 0x0000] %asi
	.word 0xdcc44400  ! 4387: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xdcbf8e40  ! 4388: STDA_R	stda	%r14, [%r30 + %r0] 0x72
	.word 0xdccd2000  ! 4389: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r14
	mov	0x8, %r17
	.word 0xdccd2000  ! 4391: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r14
	.word 0x87802072  ! 4392: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdccf6000  ! 4393: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdace49e0  ! 4394: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r13
	.word 0xd4f70e40  ! 4395: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	.word 0xd4d7a000  ! 4396: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	.word 0x87802020  ! 4397: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4dc2000  ! 4398: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	mov	0x7c0, %r21
	.word 0xd4c4a000  ! 4400: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	.word 0xd484a000  ! 4401: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r10
	.word 0xd2be89e0  ! 4402: STDA_R	stda	%r9, [%r26 + %r0] 0x4f
	mov	0x8, %r27
	mov	0x8, %r25
	mov	0x10, %r18
	.word 0x87802074  ! 4406: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaae49e0  ! 4407: STBA_R	stba	%r13, [%r25 + %r0] 0x4f
	.word 0xda872000  ! 4408: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0x87802073  ! 4409: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f0, %r21
	mov	0x30, %r26
	.word 0xdaaf6000  ! 4412: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xdaaf4e60  ! 4413: STBA_R	stba	%r13, [%r29 + %r0] 0x73
	.word 0x87802020  ! 4414: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r24
	.word 0xdc9504a0  ! 4416: LDUHA_R	lduha	[%r20, %r0] 0x25, %r14
	.word 0xdca42000  ! 4417: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xd6a584a0  ! 4418: STWA_R	stwa	%r11, [%r22 + %r0] 0x25
	.word 0xd6b4e000  ! 4419: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xde848400  ! 4420: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	.word 0xdedca000  ! 4421: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xdef4e000  ! 4422: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xdec4a000  ! 4423: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	mov	0x3f0, %r22
	.word 0x87802020  ! 4425: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded42000  ! 4426: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	.word 0x87802025  ! 4427: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebd2000  ! 4428: STDA_I	stda	%r15, [%r20 + 0x0000] %asi
	.word 0xd0dc0400  ! 4429: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xd0d52000  ! 4430: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r8
	.word 0xd0ada000  ! 4431: STBA_I	stba	%r8, [%r22 + 0x0000] %asi
	wr_tick_cmpr_0_40:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xbc, %g2
	or	%g4, 0xd5, %g4
	or	%g6, 0xc7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x60, %r19
	mov	0x30, %r26
	mov	0x28, %r26
	.word 0x8780204f  ! 4436: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r16
	.word 0x87802025  ! 4438: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f5a000  ! 4439: STXA_I	stxa	%r8, [%r22 + 0x0000] %asi
	mov	0x50, %r18
	.word 0xd28f8e80  ! 4441: LDUBA_R	lduba	[%r30, %r0] 0x74, %r9
	mov	0x7f0, %r21
	mov	0x0, %r19
	.word 0xd6dc4400  ! 4444: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xd6ada000  ! 4445: STBA_I	stba	%r11, [%r22 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xdadc8400  ! 4447: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	mov	0x38, %r19
	.word 0x87802072  ! 4449: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a70e60  ! 4450: STWA_R	stwa	%r12, [%r28 + %r0] 0x73
	.word 0xd8c7a000  ! 4451: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	mov	0x68, %r27
	.word 0xd887e000  ! 4453: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8976000  ! 4454: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0xd2c4c400  ! 4455: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0xd0d7ce60  ! 4456: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r8
	mov	0x10, %r18
	.word 0xdec78e60  ! 4458: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r15
	mov	0x8, %r26
	.word 0x87802072  ! 4460: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 4461: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdec72000  ! 4462: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xd0c74e60  ! 4463: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r8
	.word 0x8780204f  ! 4464: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a62000  ! 4465: STWA_I	stwa	%r8, [%r24 + 0x0000] %asi
	.word 0x87802025  ! 4466: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4d44400  ! 4467: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0xd8c40400  ! 4468: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	.word 0xd8dda000  ! 4469: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r12
	.word 0xd2b78e40  ! 4470: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	mov	0x40, %r27
	.word 0xd2dd6000  ! 4472: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r9
	.word 0xd295e000  ! 4473: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r9
	.word 0xd2ad6000  ! 4474: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 4475: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 4476: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2f5e000  ! 4477: STXA_I	stxa	%r9, [%r23 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0xd29d2000  ! 4479: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r9
	.word 0xd2ade000  ! 4480: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0xd2b5e000  ! 4481: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	.word 0xd295e000  ! 4482: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r9
	.word 0xd48c4400  ! 4483: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0x87802025  ! 4484: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4485: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb6c9e0  ! 4486: STHA_R	stha	%r15, [%r27 + %r0] 0x4f
	.word 0xde8c2000  ! 4487: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	mov	0x7e8, %r21
	mov	0x20, %r19
	mov	0x68, %r18
	.word 0xdef4a000  ! 4491: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0xd6bdc4a0  ! 4492: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	.word 0xd6c4a000  ! 4493: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r11
	.word 0xd6dca000  ! 4494: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r11
	.word 0xd694e000  ! 4495: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r11
	.word 0xd6d46000  ! 4496: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 4497: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6ce2000  ! 4498: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	mov	0x7c8, %r22
	.word 0xd6a62000  ! 4500: STWA_I	stwa	%r11, [%r24 + 0x0000] %asi
	.word 0xdc84c400  ! 4501: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	.word 0xd2b78e40  ! 4502: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	mov	0x3f8, %r23
	.word 0xd2d6e000  ! 4504: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r9
	.word 0xd2f6e000  ! 4505: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	mov	0x8, %r24
	.word 0x87802020  ! 4507: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa74e80  ! 4508: STWA_R	stwa	%r13, [%r29 + %r0] 0x74
	.word 0xdabdc4a0  ! 4509: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	.word 0x8780204f  ! 4510: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda862000  ! 4511: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r13
	.word 0xda86e000  ! 4512: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r13
	mov	0x7c0, %r21
	mov	0x7f8, %r20
	.word 0xd8f70e40  ! 4515: STXA_R	stxa	%r12, [%r28 + %r0] 0x72
	.word 0xd0bcc400  ! 4516: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0xd0c66000  ! 4517: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r8
	mov	0x7c0, %r21
	wr_tick_cmpr_0_41:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x90, %g2
	or	%g4, 0x97, %g4
	or	%g6, 0x94, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802072  ! 4520: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde840400  ! 4521: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	.word 0xde9fa000  ! 4522: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdea76000  ! 4524: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xda840400  ! 4525: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	.word 0xdabf2000  ! 4526: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xdabfe000  ! 4527: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xdcf70e60  ! 4528: STXA_R	stxa	%r14, [%r28 + %r0] 0x73
	mov	0x28, %r17
	.word 0x87802020  ! 4530: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4531: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf76000  ! 4532: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xd4f6c9e0  ! 4533: STXA_R	stxa	%r10, [%r27 + %r0] 0x4f
	.word 0xd6b609e0  ! 4534: STHA_R	stha	%r11, [%r24 + %r0] 0x4f
	.word 0x87802025  ! 4535: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r16
	.word 0xdcce09e0  ! 4537: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r14
	.word 0xd2bf8e40  ! 4538: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	mov	0x10, %r27
	.word 0xd2ada000  ! 4540: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xd2bda000  ! 4541: STDA_I	stda	%r9, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 4542: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48f8e80  ! 4543: LDUBA_R	lduba	[%r30, %r0] 0x74, %r10
	.word 0xde8c0400  ! 4544: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0xd2974e40  ! 4545: LDUHA_R	lduha	[%r29, %r0] 0x72, %r9
	.word 0xd2dce000  ! 4546: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r9
	.word 0xd2c46000  ! 4547: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0xd29ca000  ! 4548: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	.word 0x87802025  ! 4549: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdef78e60  ! 4550: STXA_R	stxa	%r15, [%r30 + %r0] 0x73
	.word 0x8780204f  ! 4551: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 4552: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r25
	.word 0xdedf2000  ! 4554: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0x87802072  ! 4555: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeafa000  ! 4556: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xdedfe000  ! 4557: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd29d04a0  ! 4559: LDDA_R	ldda	[%r20, %r0] 0x25, %r9
	.word 0xda8c0400  ! 4560: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	.word 0xdaaf6000  ! 4561: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdadfe000  ! 4563: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0xdad7a000  ! 4564: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0xdaf48400  ! 4565: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0x87802074  ! 4566: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabfe000  ! 4567: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xd2cfce80  ! 4568: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r9
	.word 0xd0f70e80  ! 4569: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0xd0d72000  ! 4570: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0c72000  ! 4571: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0f72000  ! 4572: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	mov	0x38, %r24
	.word 0xd0dfa000  ! 4574: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0c72000  ! 4575: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xdabe89e0  ! 4576: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	mov	0x18, %r16
	mov	0x48, %r27
	.word 0xdad7e000  ! 4579: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	mov	0x7c0, %r22
	.word 0xd2cec9e0  ! 4581: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r9
	.word 0xd2f7a000  ! 4582: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xd4c504a0  ! 4583: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r10
	.word 0x87802072  ! 4584: WRASI_I	wr	%r0, 0x0072, %asi
	wr_tick_cmpr_0_42:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xc7, %g2
	or	%g4, 0xbd, %g4
	or	%g6, 0xc3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd487e000  ! 4586: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802074  ! 4587: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd88c0400  ! 4588: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	.word 0xd0d649e0  ! 4589: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r8
	mov	0x7c8, %r21
	mov	0x50, %r19
	.word 0xd0b72000  ! 4592: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd0cf6000  ! 4593: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xda96c9e0  ! 4594: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r13
	.word 0xdad7ce80  ! 4595: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r13
	.word 0xd6bf8e60  ! 4596: STDA_R	stda	%r11, [%r30 + %r0] 0x73
	.word 0x87802020  ! 4597: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b42000  ! 4598: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 4599: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r25
	mov	0x70, %r26
	.word 0xd69fa000  ! 4602: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0xd6cfa000  ! 4603: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0xdef4c400  ! 4604: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xd8b70e80  ! 4605: STHA_R	stha	%r12, [%r28 + %r0] 0x74
	.word 0x8780204f  ! 4606: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a6a000  ! 4607: STWA_I	stwa	%r12, [%r26 + 0x0000] %asi
	mov	0x10, %r17
	.word 0x87802020  ! 4609: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf74e40  ! 4610: STXA_R	stxa	%r13, [%r29 + %r0] 0x72
	.word 0xd2c544a0  ! 4611: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r9
	.word 0xd0a78e80  ! 4612: STWA_R	stwa	%r8, [%r30 + %r0] 0x74
	.word 0xd6bf4e60  ! 4613: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	.word 0xd6a46000  ! 4614: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0xd6a4a000  ! 4615: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	.word 0xd6ace000  ! 4616: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0xd8ce49e0  ! 4617: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r12
	.word 0xdaaf0e80  ! 4618: STBA_R	stba	%r13, [%r28 + %r0] 0x74
	.word 0xdaf42000  ! 4619: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 4620: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 4621: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f8, %r20
	.word 0xde9609e0  ! 4623: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r15
	.word 0xdef7e000  ! 4624: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 4625: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacf0e60  ! 4626: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r13
	mov	0x3d0, %r22
	.word 0x87802020  ! 4628: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9ca000  ! 4629: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	.word 0xd8970e60  ! 4630: LDUHA_R	lduha	[%r28, %r0] 0x73, %r12
	.word 0xd884c400  ! 4631: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	mov	0x0, %r18
	.word 0x8780204f  ! 4633: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 4634: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r24
	.word 0xdaa544a0  ! 4636: STWA_R	stwa	%r13, [%r21 + %r0] 0x25
	.word 0xdea6c9e0  ! 4637: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 4638: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4639: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r21
	.word 0xded46000  ! 4641: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	mov	0x78, %r17
	.word 0xdea42000  ! 4643: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xd6a7ce60  ! 4644: STWA_R	stwa	%r11, [%r31 + %r0] 0x73
	.word 0xd6c46000  ! 4645: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r11
	.word 0xd8b70e60  ! 4646: STHA_R	stha	%r12, [%r28 + %r0] 0x73
	mov	0x0, %r18
	.word 0xd8a46000  ! 4648: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8cd04a0  ! 4649: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r12
	.word 0xd8c44400  ! 4650: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r12
	.word 0xd8c4a000  ! 4651: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r12
	mov	0x7f0, %r20
	.word 0xd8cc2000  ! 4653: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r12
	mov	0x7c0, %r21
	.word 0x8780204f  ! 4655: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2af4e60  ! 4656: STBA_R	stba	%r9, [%r29 + %r0] 0x73
	.word 0xd29e2000  ! 4657: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r9
	mov	0x3f0, %r20
	.word 0xd2d6e000  ! 4659: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r9
	.word 0xd2cee000  ! 4660: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	.word 0xd4c40400  ! 4661: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	.word 0xd4cee000  ! 4662: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r10
	.word 0xd6c44400  ! 4663: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r11
	.word 0xd6dee000  ! 4664: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r11
	mov	0x0, %r24
	.word 0x87802025  ! 4666: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b5a000  ! 4667: STHA_I	stha	%r11, [%r22 + 0x0000] %asi
	.word 0xd89dc4a0  ! 4668: LDDA_R	ldda	[%r23, %r0] 0x25, %r12
	.word 0xd4f40400  ! 4669: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	mov	0x18, %r16
	.word 0xd49d2000  ! 4671: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r10
	.word 0x87802072  ! 4672: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4bf8e60  ! 4673: STDA_R	stda	%r10, [%r30 + %r0] 0x73
	.word 0xd4944400  ! 4674: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	.word 0xd2a74e60  ! 4675: STWA_R	stwa	%r9, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 4676: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2b62000  ! 4677: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	.word 0xd0f4c400  ! 4678: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	mov	0x58, %r17
	.word 0xda8d44a0  ! 4680: LDUBA_R	lduba	[%r21, %r0] 0x25, %r13
	.word 0x87802020  ! 4681: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdacc6000  ! 4682: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 4683: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r24
	.word 0xd2a44400  ! 4685: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2a6e000  ! 4687: STWA_I	stwa	%r9, [%r27 + 0x0000] %asi
	.word 0xd2a6e000  ! 4688: STWA_I	stwa	%r9, [%r27 + 0x0000] %asi
	mov	0x8, %r19
	.word 0x87802020  ! 4690: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bc4400  ! 4691: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0x87802072  ! 4692: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd09f6000  ! 4693: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	.word 0xd0bfe000  ! 4694: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd0f7a000  ! 4695: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	mov	0x50, %r19
	.word 0xd0cfa000  ! 4697: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	mov	0x28, %r24
	.word 0xd6dc8400  ! 4699: LDXA_R	ldxa	[%r18, %r0] 0x20, %r11
	.word 0xd6a76000  ! 4700: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xdead04a0  ! 4701: STBA_R	stba	%r15, [%r20 + %r0] 0x25
	.word 0x87802074  ! 4702: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 4703: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r24
	.word 0x87802025  ! 4705: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad4c400  ! 4706: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xdaade000  ! 4707: STBA_I	stba	%r13, [%r23 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xdacd6000  ! 4709: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r13
	.word 0xda956000  ! 4710: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r13
	.word 0x87802072  ! 4711: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7e0, %r23
	.word 0xda9fe000  ! 4713: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xdabf8e40  ! 4714: STDA_R	stda	%r13, [%r30 + %r0] 0x72
	.word 0xd2a44400  ! 4715: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	mov	0x78, %r17
	.word 0xdeb7ce80  ! 4717: STHA_R	stha	%r15, [%r31 + %r0] 0x74
	mov	0x3e8, %r21
	.word 0xde9f2000  ! 4719: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xdcf48400  ! 4720: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xd8b504a0  ! 4721: STHA_R	stha	%r12, [%r20 + %r0] 0x25
	.word 0xd8d7e000  ! 4722: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0xd8a76000  ! 4723: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	mov	0x70, %r19
	mov	0x0, %r26
	mov	0x50, %r24
	.word 0xd8a7a000  ! 4727: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8f76000  ! 4728: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8a7a000  ! 4729: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8876000  ! 4730: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0xdecfce60  ! 4731: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r15
	.word 0x87802020  ! 4732: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68f4e80  ! 4733: LDUBA_R	lduba	[%r29, %r0] 0x74, %r11
	mov	0x60, %r18
	mov	0x30, %r26
	.word 0x87802020  ! 4736: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4737: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d0, %r22
	mov	0x70, %r19
	.word 0xdcaf4e40  ! 4740: STBA_R	stba	%r14, [%r29 + %r0] 0x72
	.word 0xda848400  ! 4741: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r13
	mov	0x78, %r16
	mov	0x18, %r27
	.word 0xdaa76000  ! 4744: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 4745: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88d04a0  ! 4746: LDUBA_R	lduba	[%r20, %r0] 0x25, %r12
	.word 0x8780204f  ! 4747: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 4748: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 4749: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8d6a000  ! 4750: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r12
	.word 0x87802073  ! 4751: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c8, %r23
	.word 0xda9c4400  ! 4753: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	mov	0x30, %r27
	.word 0xd2bc4400  ! 4755: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	mov	0x60, %r19
	mov	0x7d0, %r23
	.word 0xd2afe000  ! 4758: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd2f7e000  ! 4759: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	mov	0x58, %r19
	.word 0x87802073  ! 4761: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d8, %r22
	.word 0xde8c4400  ! 4763: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	.word 0x87802020  ! 4764: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb40400  ! 4765: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0x87802020  ! 4766: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r25
	mov	0x0, %r16
	.word 0x87802074  ! 4769: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde9fe000  ! 4770: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	mov	0x3d8, %r22
	.word 0xd8b584a0  ! 4772: STHA_R	stha	%r12, [%r22 + %r0] 0x25
	.word 0x87802025  ! 4773: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r19
	.word 0xd8a5e000  ! 4775: STWA_I	stwa	%r12, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 4776: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r19
	mov	0x0, %r25
	.word 0xd8c6a000  ! 4779: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r12
	mov	0x3c8, %r20
	mov	0x3f8, %r23
	.word 0xd8862000  ! 4782: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r12
	.word 0x87802073  ! 4783: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 4784: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r24
	.word 0xd8afe000  ! 4786: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0xd8f7a000  ! 4788: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xdef7ce40  ! 4789: STXA_R	stxa	%r15, [%r31 + %r0] 0x72
	mov	0x8, %r17
	.word 0x87802074  ! 4791: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeb7a000  ! 4792: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	mov	0x58, %r17
	mov	0x3c0, %r20
	.word 0xdedf2000  ! 4795: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	wr_tick_cmpr_0_43:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x8f, %g2
	or	%g4, 0x80, %g4
	or	%g6, 0xa6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0bc4400  ! 4797: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xd297ce80  ! 4798: LDUHA_R	lduha	[%r31, %r0] 0x74, %r9
	.word 0xd297e000  ! 4799: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	mov	0x7f0, %r20
	mov	0x70, %r24
	.word 0xdcc44400  ! 4802: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xd6bc8400  ! 4803: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xd2948400  ! 4804: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	mov	0x68, %r18
	.word 0xd2cfa000  ! 4806: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	.word 0xd8f74e40  ! 4807: STXA_R	stxa	%r12, [%r29 + %r0] 0x72
	.word 0xdeaf0e80  ! 4808: STBA_R	stba	%r15, [%r28 + %r0] 0x74
	mov	0x68, %r25
	.word 0xdac70e60  ! 4810: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r13
	.word 0xdcf4c400  ! 4811: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xdcd72000  ! 4812: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	mov	0x7d8, %r23
	.word 0xd6878e80  ! 4814: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r11
	.word 0xd2cec9e0  ! 4815: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r9
	.word 0xd2a7a000  ! 4816: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xd4a74e80  ! 4817: STWA_R	stwa	%r10, [%r29 + %r0] 0x74
	.word 0x87802072  ! 4818: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cfa000  ! 4819: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0xd8d649e0  ! 4820: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r12
	.word 0xd0cf4e80  ! 4821: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r8
	.word 0xd0f72000  ! 4822: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	mov	0x58, %r19
	.word 0xd0a7a000  ! 4824: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0f7e000  ! 4825: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xd2cf8e80  ! 4827: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r9
	.word 0x87802020  ! 4828: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29c6000  ! 4829: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	.word 0xd2c42000  ! 4830: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x7d0, %r22
	.word 0xd4ac0400  ! 4833: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xdef44400  ! 4834: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xdeaca000  ! 4835: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xd6afce40  ! 4836: STBA_R	stba	%r11, [%r31 + %r0] 0x72
	mov	0x30, %r27
	.word 0xd6aca000  ! 4838: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	mov	0x50, %r19
	.word 0xd6a42000  ! 4840: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	mov	0x48, %r18
	mov	0x60, %r17
	.word 0xd6b46000  ! 4843: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 4844: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd68584a0  ! 4845: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r11
	.word 0xd6cf6000  ! 4846: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xdcc44400  ! 4847: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xdabcc400  ! 4848: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	mov	0x20, %r27
	mov	0x20, %r26
	mov	0x0, %r24
	mov	0x48, %r25
	mov	0x18, %r17
	mov	0x68, %r24
	.word 0xdadf6000  ! 4855: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xdadf2000  ! 4856: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0xd6ac8400  ! 4857: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xd4dfce80  ! 4858: LDXA_R	ldxa	[%r31, %r0] 0x74, %r10
	.word 0xda874e40  ! 4859: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r13
	.word 0xdaf72000  ! 4860: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 4861: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8afce80  ! 4862: STBA_R	stba	%r12, [%r31 + %r0] 0x74
	.word 0x8780204f  ! 4863: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f8, %r23
	.word 0xd8d62000  ! 4865: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r12
	.word 0xd8966000  ! 4866: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r12
	.word 0xd88ee000  ! 4867: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4868: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28ec9e0  ! 4869: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r9
	mov	0x38, %r16
	mov	0x28, %r17
	.word 0xd2a42000  ! 4872: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	mov	0x40, %r18
	mov	0x48, %r25
	.word 0xd2f42000  ! 4875: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0xd284a000  ! 4876: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	.word 0xd2dc2000  ! 4877: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r9
	.word 0xd2dc6000  ! 4878: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r9
	.word 0xd284e000  ! 4879: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r9
	.word 0xd2c4e000  ! 4880: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xdcdf8e40  ! 4881: LDXA_R	ldxa	[%r30, %r0] 0x72, %r14
	.word 0xdcbc2000  ! 4882: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xdcb42000  ! 4883: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xd0b584a0  ! 4884: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	.word 0xd4bc0400  ! 4885: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	mov	0x0, %r26
	.word 0xd4f4a000  ! 4887: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0xd4cc4400  ! 4889: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r10
	mov	0x68, %r26
	.word 0xd6de89e0  ! 4891: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r11
	.word 0xd6a4e000  ! 4892: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0xdea4c400  ! 4893: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	.word 0xd6bc8400  ! 4894: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xd68c4400  ! 4895: LDUBA_R	lduba	[%r17, %r0] 0x20, %r11
	.word 0xd2ae49e0  ! 4896: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	.word 0xd2dc6000  ! 4897: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r9
	mov	0x3d0, %r23
	.word 0x87802020  ! 4899: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4900: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4901: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r25
	.word 0xd287a000  ! 4903: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0xd29fa000  ! 4904: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd2c689e0  ! 4905: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r9
	.word 0xd2b76000  ! 4906: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	mov	0x3d0, %r23
	.word 0xdebf4e60  ! 4908: STDA_R	stda	%r15, [%r29 + %r0] 0x73
	.word 0xdec76000  ! 4909: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xdeafe000  ! 4910: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xdeb7a000  ! 4911: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xdea7e000  ! 4912: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xda9c4400  ! 4913: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	.word 0xd0af4e80  ! 4914: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	mov	0x48, %r25
	mov	0x3f0, %r20
	.word 0xd887ce40  ! 4917: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r12
	.word 0xdcf48400  ! 4918: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0x87802020  ! 4919: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dfce40  ! 4920: LDXA_R	ldxa	[%r31, %r0] 0x72, %r9
	.word 0xd4c78e40  ! 4921: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r10
	.word 0x8780204f  ! 4922: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4ce6000  ! 4923: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r10
	.word 0xd4f66000  ! 4924: STXA_I	stxa	%r10, [%r25 + 0x0000] %asi
	.word 0xd8de49e0  ! 4925: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r12
	.word 0xd8f66000  ! 4926: STXA_I	stxa	%r12, [%r25 + 0x0000] %asi
	.word 0xd4cf4e80  ! 4927: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r10
	.word 0xdac5c4a0  ! 4928: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r13
	.word 0xd0974e40  ! 4929: LDUHA_R	lduha	[%r29, %r0] 0x72, %r8
	mov	0x68, %r24
	.word 0xd0cea000  ! 4931: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r8
	mov	0x3e0, %r21
	.word 0xd0aea000  ! 4933: STBA_I	stba	%r8, [%r26 + 0x0000] %asi
	mov	0x0, %r16
	.word 0xd2bc0400  ! 4935: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	mov	0x10, %r16
	.word 0xd2862000  ! 4937: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r9
	.word 0xd6df4e80  ! 4938: LDXA_R	ldxa	[%r29, %r0] 0x74, %r11
	mov	0x7c0, %r23
	ta	T_CHANGE_PRIV	! macro
	.word 0xdcd78e40  ! 4941: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r14
	.word 0xd4dcc400  ! 4942: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0x87802020  ! 4943: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r19
	.word 0xd6f78e60  ! 4945: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	.word 0xd6b46000  ! 4946: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd8a544a0  ! 4947: STWA_R	stwa	%r12, [%r21 + %r0] 0x25
	mov	0x60, %r26
	mov	0x20, %r16
	.word 0xd88c6000  ! 4950: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	mov	0x48, %r27
	mov	0x0, %r27
	.word 0xd8b78e60  ! 4953: STHA_R	stha	%r12, [%r30 + %r0] 0x73
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdebc8400  ! 4955: STDA_R	stda	%r15, [%r18 + %r0] 0x20
	.word 0xde942000  ! 4956: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	.word 0xdedca000  ! 4957: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xd0f544a0  ! 4958: STXA_R	stxa	%r8, [%r21 + %r0] 0x25
	.word 0xd4c504a0  ! 4959: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r10
	.word 0xd4b4e000  ! 4960: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xd4ac2000  ! 4961: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	mov	0x20, %r24
	wr_tick_cmpr_0_44:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa6, %g2
	or	%g4, 0xe7, %g4
	or	%g6, 0x9e, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4cce000  ! 4964: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	.word 0xd4d42000  ! 4965: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	.word 0x87802025  ! 4966: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6be09e0  ! 4967: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	.word 0xd8f649e0  ! 4968: STXA_R	stxa	%r12, [%r25 + %r0] 0x4f
	.word 0xd0cc8400  ! 4969: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0xd0956000  ! 4970: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r8
	.word 0xd2ad04a0  ! 4971: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	.word 0xd2ada000  ! 4972: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xd4f4c400  ! 4973: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd2f504a0  ! 4974: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	.word 0xd2c5e000  ! 4975: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r9
	.word 0xd2ada000  ! 4976: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xd2dd2000  ! 4977: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 4978: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd286a000  ! 4979: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r9
	.word 0xda840400  ! 4980: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	mov	0x0, %r24
	wr_tick_cmpr_0_45:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe9, %g2
	or	%g4, 0xfc, %g4
	or	%g6, 0xca, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3c8, %r20
	.word 0xd6bfce80  ! 4984: STDA_R	stda	%r11, [%r31 + %r0] 0x74
	.word 0xd6ac8400  ! 4985: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xd4d44400  ! 4986: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0xd4862000  ! 4987: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r10
	.word 0x87802072  ! 4988: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4c72000  ! 4989: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r10
	.word 0xd49fe000  ! 4990: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd4c76000  ! 4991: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	mov	0x48, %r19
	.word 0xdcc7ce40  ! 4993: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r14
	.word 0xdc9fe000  ! 4994: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xdc97e000  ! 4995: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xdcf7e000  ! 4996: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcf7a000  ! 4997: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x48, %r25
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_3:
	mov	0x18, %r24
	mov	0x3f0, %r22
	mov	0x38, %r19
	.word 0x87802074  ! 4: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e0, %r22
	.word 0xdcd52000  ! 6: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r14
	.word 0xdc9d6000  ! 7: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r14
	mov	0x30, %r17
	.word 0x87802073  ! 9: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d0, %r20
	.word 0xdcbfa000  ! 11: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 12: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 13: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r25
	mov	0x78, %r26
	.word 0xdcaf6000  ! 16: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdc9d84a0  ! 17: LDDA_R	ldda	[%r22, %r0] 0x25, %r14
	mov	0x20, %r27
	.word 0xd6af2000  ! 19: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x38, %r24
	.word 0xd6d7e000  ! 21: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	mov	0x58, %r24
	.word 0xd0b7ce40  ! 23: STHA_R	stha	%r8, [%r31 + %r0] 0x72
	mov	0x7c0, %r23
	.word 0x87802072  ! 25: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4966000  ! 26: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r10
	.word 0xd4ae6000  ! 27: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	mov	0x60, %r24
	.word 0xd4bea000  ! 29: STDA_I	stda	%r10, [%r26 + 0x0000] %asi
	mov	0x3d0, %r23
	.word 0xd4be2000  ! 31: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	mov	0x70, %r16
	mov	0x40, %r16
	.word 0x87802072  ! 34: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r25
	.word 0x87802020  ! 36: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 37: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd89f4e40  ! 38: LDDA_R	ldda	[%r29, %r0] 0x72, %r12
	.word 0xdca78e40  ! 39: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	mov	0x3d0, %r23
	.word 0xd0bce000  ! 41: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0xd08ca000  ! 42: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xd0c4e000  ! 43: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	mov	0x28, %r19
	mov	0x18, %r18
	.word 0xd094e000  ! 46: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0xd0846000  ! 47: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0x87802074  ! 48: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r24
	.word 0xd0b5e000  ! 50: STHA_I	stha	%r8, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 51: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r26
	.word 0x8780204f  ! 53: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd094a000  ! 54: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	.word 0xd0f4e000  ! 55: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 56: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2cc8400  ! 57: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	mov	0x10, %r24
	.word 0xdcd62000  ! 59: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r14
	mov	0x18, %r17
	mov	0x7d8, %r23
	.word 0xdaacc400  ! 62: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0xd0bea000  ! 63: STDA_I	stda	%r8, [%r26 + 0x0000] %asi
	.word 0xd6ac8400  ! 64: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xd6f62000  ! 65: STXA_I	stxa	%r11, [%r24 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xd6c649e0  ! 67: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r11
	.word 0xd6cfce60  ! 68: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r11
	mov	0x7e0, %r20
	.word 0xdcb544a0  ! 70: STHA_R	stha	%r14, [%r21 + %r0] 0x25
	.word 0xdcaea000  ! 71: STBA_I	stba	%r14, [%r26 + 0x0000] %asi
	.word 0xdabc0400  ! 72: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xdcaea000  ! 73: STBA_I	stba	%r14, [%r26 + 0x0000] %asi
	.word 0xdcb6e000  ! 74: STHA_I	stha	%r14, [%r27 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xdcdee000  ! 76: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r14
	mov	0x58, %r19
	.word 0xd2b74e80  ! 78: STHA_R	stha	%r9, [%r29 + %r0] 0x74
	.word 0xd4cf8e60  ! 79: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r10
	.word 0x87802074  ! 80: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 81: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29f8e60  ! 82: LDDA_R	ldda	[%r30, %r0] 0x73, %r9
	.word 0xdeb7e000  ! 83: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xd0df0e80  ! 84: LDXA_R	ldxa	[%r28, %r0] 0x74, %r8
	.word 0xd6a7a000  ! 85: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd697a000  ! 86: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	mov	0x3d0, %r20
	.word 0xd8cc4400  ! 88: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r12
	.word 0x87802073  ! 89: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2a44400  ! 90: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xd6ade000  ! 91: STBA_I	stba	%r11, [%r23 + 0x0000] %asi
	.word 0xd8d5c4a0  ! 92: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r12
	mov	0x30, %r27
	.word 0x87802020  ! 94: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r23
	.word 0xd48d84a0  ! 96: LDUBA_R	lduba	[%r22, %r0] 0x25, %r10
	.word 0xd0a4e000  ! 97: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	mov	0x3c8, %r22
	.word 0xd09c6000  ! 99: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r8
	mov	0x10, %r19
	mov	0x18, %r16
	mov	0x70, %r18
	mov	0x50, %r17
	.word 0xd0dc6000  ! 104: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	.word 0x87802025  ! 105: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca6c9e0  ! 106: STWA_R	stwa	%r14, [%r27 + %r0] 0x4f
	mov	0x20, %r27
	mov	0x7c8, %r20
	.word 0xdca78e80  ! 109: STWA_R	stwa	%r14, [%r30 + %r0] 0x74
	mov	0x50, %r27
	mov	0x48, %r27
	.word 0xd4afa000  ! 112: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd8a544a0  ! 113: STWA_R	stwa	%r12, [%r21 + %r0] 0x25
	mov	0x3f8, %r20
	.word 0xd6dfce40  ! 115: LDXA_R	ldxa	[%r31, %r0] 0x72, %r11
	.word 0xd287a000  ! 116: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0x87802025  ! 117: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bf0e80  ! 118: STDA_R	stda	%r9, [%r28 + %r0] 0x74
	.word 0xd4872000  ! 119: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0xda9fce60  ! 120: LDDA_R	ldda	[%r31, %r0] 0x73, %r13
	.word 0xda87e000  ! 121: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0xda872000  ! 122: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	mov	0x78, %r25
	mov	0x7d0, %r21
	.word 0xd2af8e80  ! 125: STBA_R	stba	%r9, [%r30 + %r0] 0x74
	.word 0xdabc8400  ! 126: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	.word 0xd09fa000  ! 127: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	.word 0xd0afe000  ! 128: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0a7a000  ! 129: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0a7a000  ! 130: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 131: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8d74e80  ! 132: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r12
	.word 0xde9fe000  ! 133: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	mov	0x3c8, %r23
	mov	0x3f8, %r22
	.word 0xd0ad04a0  ! 136: STBA_R	stba	%r8, [%r20 + %r0] 0x25
	.word 0xd2a7a000  ! 137: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xdaa78e60  ! 138: STWA_R	stwa	%r13, [%r30 + %r0] 0x73
	mov	0x3e8, %r21
	.word 0xdedfa000  ! 140: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x30, %r24
	.word 0xd4ddc4a0  ! 142: LDXA_R	ldxa	[%r23, %r0] 0x25, %r10
	.word 0x87802073  ! 143: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8ad04a0  ! 144: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	mov	0x28, %r18
	.word 0xd2d5a000  ! 146: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r9
	.word 0xd49e49e0  ! 147: LDDA_R	ldda	[%r25, %r0] 0x4f, %r10
	.word 0x87802020  ! 148: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c4e000  ! 149: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r11
	.word 0xd6c4e000  ! 150: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r11
	mov	0x3d8, %r22
	mov	0x7e0, %r21
	.word 0xd2cfce40  ! 153: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r9
	.word 0xda9fce80  ! 154: LDDA_R	ldda	[%r31, %r0] 0x74, %r13
	.word 0x87802025  ! 155: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc948400  ! 156: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	mov	0x7c8, %r21
	.word 0xd2cfe000  ! 158: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	.word 0xd2a7e000  ! 159: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	mov	0x0, %r27
	.word 0x87802025  ! 161: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2cfce60  ! 162: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r9
	mov	0x40, %r16
	mov	0x0, %r17
	.word 0xd0dd44a0  ! 165: LDXA_R	ldxa	[%r21, %r0] 0x25, %r8
	.word 0xd2c56000  ! 166: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r9
	.word 0xdaf649e0  ! 167: STXA_R	stxa	%r13, [%r25 + %r0] 0x4f
	.word 0x87802072  ! 168: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6be6000  ! 169: STDA_I	stda	%r11, [%r25 + 0x0000] %asi
	.word 0xd696e000  ! 170: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 171: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f72000  ! 172: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd0ac8400  ! 173: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	mov	0x58, %r26
	mov	0x18, %r16
	.word 0xd2bd04a0  ! 176: STDA_R	stda	%r9, [%r20 + %r0] 0x25
	.word 0xd6dc0400  ! 177: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	.word 0xdedfe000  ! 178: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xdeb7e000  ! 179: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	wr_tick_cmpr_3_0:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xda, %g2
	or	%g4, 0xf4, %g4
	or	%g6, 0x94, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdeaf2000  ! 181: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xd0b7ce80  ! 183: STHA_R	stha	%r8, [%r31 + %r0] 0x74
	.word 0xdab44400  ! 184: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0xdaf7e000  ! 185: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xd8df4e60  ! 186: LDXA_R	ldxa	[%r29, %r0] 0x73, %r12
	.word 0xdaaf2000  ! 187: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 188: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd08ec9e0  ! 189: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r8
	mov	0x60, %r17
	.word 0xd4b689e0  ! 191: STHA_R	stha	%r10, [%r26 + %r0] 0x4f
	mov	0x7f8, %r20
	.word 0xdab48400  ! 193: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0x87802020  ! 194: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d6e000  ! 195: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r9
	.word 0xd0940400  ! 196: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	mov	0x70, %r27
	.word 0xd6b62000  ! 198: STHA_I	stha	%r11, [%r24 + 0x0000] %asi
	.word 0xd2bd84a0  ! 199: STDA_R	stda	%r9, [%r22 + %r0] 0x25
	mov	0x38, %r24
	mov	0x60, %r25
	.word 0x87802072  ! 202: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r16
	.word 0xd89d04a0  ! 204: LDDA_R	ldda	[%r20, %r0] 0x25, %r12
	.word 0xd6b48400  ! 205: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0x87802020  ! 206: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabf4e40  ! 207: STDA_R	stda	%r13, [%r29 + %r0] 0x72
	.word 0x87802074  ! 208: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc9fce40  ! 209: LDDA_R	ldda	[%r31, %r0] 0x72, %r14
	.word 0xdcac2000  ! 210: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	mov	0x8, %r16
	.word 0xd0a44400  ! 212: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0x87802074  ! 213: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd68fa000  ! 214: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	mov	0x18, %r26
	mov	0x28, %r16
	.word 0xd68fa000  ! 217: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0xd6b7ce40  ! 218: STHA_R	stha	%r11, [%r31 + %r0] 0x72
	.word 0xd497a000  ! 219: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0x87802073  ! 220: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4afe000  ! 221: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd4df6000  ! 222: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4bf6000  ! 223: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd4f7e000  ! 224: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 225: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4aea000  ! 226: STBA_I	stba	%r10, [%r26 + 0x0000] %asi
	.word 0xd2f70e60  ! 227: STXA_R	stxa	%r9, [%r28 + %r0] 0x73
	.word 0xdef40400  ! 228: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0xd0c40400  ! 229: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	.word 0xd4948400  ! 230: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd6d48400  ! 232: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	mov	0x30, %r26
	.word 0xd69ea000  ! 234: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r11
	mov	0x48, %r25
	.word 0xd8d689e0  ! 236: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r12
	mov	0x7d0, %r20
	mov	0x7f0, %r23
	.word 0x87802074  ! 239: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd485e000  ! 240: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r10
	.word 0xd4f5c4a0  ! 241: STXA_R	stxa	%r10, [%r23 + %r0] 0x25
	.word 0xdaf5a000  ! 242: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xdadd6000  ! 243: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r13
	.word 0xdef78e60  ! 244: STXA_R	stxa	%r15, [%r30 + %r0] 0x73
	.word 0xd2a584a0  ! 245: STWA_R	stwa	%r9, [%r22 + %r0] 0x25
	.word 0x87802020  ! 246: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r22
	.word 0xd0df2000  ! 248: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0xd684c400  ! 249: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	.word 0xd8978e40  ! 250: LDUHA_R	lduha	[%r30, %r0] 0x72, %r12
	.word 0xdea72000  ! 251: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xdab7ce80  ! 252: STHA_R	stha	%r13, [%r31 + %r0] 0x74
	.word 0xdab40400  ! 253: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	mov	0x28, %r26
	.word 0xde9d84a0  ! 255: LDDA_R	ldda	[%r22, %r0] 0x25, %r15
	mov	0x0, %r18
	mov	0x20, %r24
	.word 0xd8bfe000  ! 258: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd8afe000  ! 259: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd4b74e40  ! 260: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	.word 0xd8de89e0  ! 261: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r12
	.word 0xd88ec9e0  ! 262: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r12
	.word 0xd6bc4400  ! 263: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	.word 0xd88544a0  ! 264: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r12
	.word 0xdec74e60  ! 265: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r15
	mov	0x78, %r25
	.word 0xd88f0e60  ! 267: LDUBA_R	lduba	[%r28, %r0] 0x73, %r12
	.word 0xdc9c8400  ! 268: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0xd4bfa000  ! 269: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	mov	0x60, %r26
	.word 0x87802074  ! 271: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r16
	.word 0xdcbc4400  ! 273: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0x87802020  ! 274: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 275: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0df8e60  ! 276: LDXA_R	ldxa	[%r30, %r0] 0x73, %r8
	.word 0xdcde6000  ! 277: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r14
	mov	0x8, %r27
	mov	0x68, %r26
	.word 0xdaa584a0  ! 280: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	.word 0xd2af8e60  ! 281: STBA_R	stba	%r9, [%r30 + %r0] 0x73
	.word 0xd0b40400  ! 282: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0xda9f0e60  ! 283: LDDA_R	ldda	[%r28, %r0] 0x73, %r13
	.word 0xd2dee000  ! 284: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r9
	mov	0x68, %r18
	.word 0xdaafce60  ! 286: STBA_R	stba	%r13, [%r31 + %r0] 0x73
	.word 0xdebc4400  ! 287: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0x87802073  ! 288: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 289: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2ad44a0  ! 290: STBA_R	stba	%r9, [%r21 + %r0] 0x25
	.word 0xdab56000  ! 291: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	.word 0xd6a544a0  ! 292: STWA_R	stwa	%r11, [%r21 + %r0] 0x25
	mov	0x18, %r27
	mov	0x3e0, %r23
	mov	0x10, %r27
	.word 0xd2c48400  ! 296: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0xd4844400  ! 297: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	mov	0x78, %r18
	.word 0xdab5c4a0  ! 299: STHA_R	stha	%r13, [%r23 + %r0] 0x25
	mov	0x50, %r18
	.word 0xd2956000  ! 301: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r9
	.word 0xd2ad6000  ! 302: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0xd4f4c400  ! 303: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 304: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r23
	mov	0x40, %r19
	mov	0x30, %r26
	.word 0x87802020  ! 308: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09c4400  ! 309: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	mov	0x30, %r18
	.word 0x8780204f  ! 311: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x48, %r26
	.word 0xdeac6000  ! 313: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xd8bfce80  ! 314: STDA_R	stda	%r12, [%r31 + %r0] 0x74
	mov	0x3d0, %r22
	mov	0x3e0, %r22
	.word 0xdab42000  ! 317: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	mov	0x7d8, %r22
	mov	0x58, %r16
	.word 0xd6dd04a0  ! 320: LDXA_R	ldxa	[%r20, %r0] 0x25, %r11
	.word 0xd2a42000  ! 321: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	mov	0x3c8, %r23
	mov	0x60, %r25
	mov	0x70, %r24
	.word 0xd2b4a000  ! 325: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0xd294e000  ! 326: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	.word 0xd294e000  ! 327: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	.word 0xdaf7ce60  ! 328: STXA_R	stxa	%r13, [%r31 + %r0] 0x73
	mov	0x10, %r18
	mov	0x20, %r17
	mov	0x50, %r17
	mov	0x10, %r25
	mov	0x3c8, %r20
	.word 0xd28f0e60  ! 334: LDUBA_R	lduba	[%r28, %r0] 0x73, %r9
	.word 0xdabd84a0  ! 335: STDA_R	stda	%r13, [%r22 + %r0] 0x25
	.word 0x87802025  ! 336: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r19
	mov	0x7c8, %r21
	.word 0x87802025  ! 339: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb44400  ! 340: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	mov	0x48, %r16
	mov	0x0, %r27
	.word 0xd0b5e000  ! 343: STHA_I	stha	%r8, [%r23 + 0x0000] %asi
	mov	0x70, %r27
	mov	0x3c8, %r21
	.word 0x87802020  ! 346: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc8c4400  ! 347: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0xd0a7a000  ! 348: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd68f8e60  ! 349: LDUBA_R	lduba	[%r30, %r0] 0x73, %r11
	.word 0xd287e000  ! 350: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	mov	0x70, %r27
	.word 0x8780204f  ! 352: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8d7ce80  ! 353: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r12
	.word 0x87802074  ! 354: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r24
	.word 0xd6c7a000  ! 356: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	.word 0xd69fa000  ! 357: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0x87802020  ! 358: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6dc4400  ! 359: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xd0a6c9e0  ! 360: STWA_R	stwa	%r8, [%r27 + %r0] 0x4f
	.word 0xdcac4400  ! 361: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	mov	0x3d8, %r23
	.word 0xd49fe000  ! 363: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd4d76000  ! 364: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	mov	0x40, %r25
	.word 0xdc974e40  ! 366: LDUHA_R	lduha	[%r29, %r0] 0x72, %r14
	.word 0xd0f72000  ! 367: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xdc9584a0  ! 368: LDUHA_R	lduha	[%r22, %r0] 0x25, %r14
	.word 0xdc8f2000  ! 369: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	mov	0x40, %r24
	.word 0xd8f40400  ! 371: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0x87802074  ! 372: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6c5e000  ! 373: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r11
	.word 0xd6956000  ! 374: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r11
	mov	0x3e8, %r23
	.word 0xd8ae09e0  ! 376: STBA_R	stba	%r12, [%r24 + %r0] 0x4f
	.word 0xd4ada000  ! 377: STBA_I	stba	%r10, [%r22 + 0x0000] %asi
	mov	0x3e0, %r21
	.word 0xd4852000  ! 379: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r10
	.word 0xd49d2000  ! 380: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r10
	.word 0xdea5c4a0  ! 381: STWA_R	stwa	%r15, [%r23 + %r0] 0x25
	.word 0xd0f5e000  ! 382: STXA_I	stxa	%r8, [%r23 + 0x0000] %asi
	.word 0xd09da000  ! 383: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r8
	.word 0xdaa44400  ! 384: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	mov	0x7f0, %r20
	mov	0x20, %r19
	.word 0xd8ad2000  ! 387: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	mov	0x3d8, %r21
	.word 0xd8944400  ! 389: LDUHA_R	lduha	[%r17, %r0] 0x20, %r12
	.word 0xdedd04a0  ! 390: LDXA_R	ldxa	[%r20, %r0] 0x25, %r15
	.word 0xdcaf4e40  ! 391: STBA_R	stba	%r14, [%r29 + %r0] 0x72
	mov	0x60, %r27
	mov	0x7c0, %r23
	.word 0xda8da000  ! 394: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r13
	.word 0xda956000  ! 395: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r13
	.word 0xdab56000  ! 396: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	.word 0x87802074  ! 397: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdab6a000  ! 398: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	.word 0xdad66000  ! 399: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r13
	.word 0x87802074  ! 400: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd48fce40  ! 401: LDUBA_R	lduba	[%r31, %r0] 0x72, %r10
	.word 0xdec4a000  ! 402: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xdeb42000  ! 403: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0xded4a000  ! 404: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	.word 0x87802074  ! 405: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 406: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7e0, %r20
	.word 0xdad609e0  ! 408: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r13
	.word 0xdca6c9e0  ! 409: STWA_R	stwa	%r14, [%r27 + %r0] 0x4f
	.word 0xdabfe000  ! 410: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xda876000  ! 411: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0x87802072  ! 412: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabea000  ! 413: STDA_I	stda	%r13, [%r26 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xdcbe49e0  ! 415: STDA_R	stda	%r14, [%r25 + %r0] 0x4f
	.word 0xd6866000  ! 416: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r11
	mov	0x7f0, %r20
	mov	0x20, %r19
	.word 0xd68d44a0  ! 419: LDUBA_R	lduba	[%r21, %r0] 0x25, %r11
	.word 0xd0ac0400  ! 420: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	mov	0x18, %r26
	.word 0xd6b6e000  ! 422: STHA_I	stha	%r11, [%r27 + 0x0000] %asi
	mov	0x50, %r24
	.word 0xd2bd04a0  ! 424: STDA_R	stda	%r9, [%r20 + %r0] 0x25
	mov	0x70, %r17
	.word 0x87802074  ! 426: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r17
	.word 0xd09fe000  ! 428: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	.word 0xd0a7e000  ! 429: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xd6948400  ! 430: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	.word 0x87802025  ! 431: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6ad6000  ! 432: STBA_I	stba	%r11, [%r21 + 0x0000] %asi
	.word 0xd68d2000  ! 433: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r11
	.word 0x87802072  ! 434: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd696a000  ! 436: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r11
	mov	0x18, %r27
	.word 0xdaae09e0  ! 438: STBA_R	stba	%r13, [%r24 + %r0] 0x4f
	mov	0x7f0, %r22
	.word 0xdcc66000  ! 440: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	.word 0xd8bf0e40  ! 441: STDA_R	stda	%r12, [%r28 + %r0] 0x72
	.word 0xd0f70e40  ! 442: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	mov	0x40, %r17
	.word 0xdea66000  ! 444: STWA_I	stwa	%r15, [%r25 + 0x0000] %asi
	mov	0x40, %r24
	mov	0x70, %r16
	.word 0xdeb66000  ! 447: STHA_I	stha	%r15, [%r25 + 0x0000] %asi
	.word 0xd4df4e80  ! 448: LDXA_R	ldxa	[%r29, %r0] 0x74, %r10
	mov	0x40, %r18
	.word 0xd8f544a0  ! 450: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	.word 0x87802072  ! 451: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc970e40  ! 452: LDUHA_R	lduha	[%r28, %r0] 0x72, %r14
	mov	0x10, %r24
	.word 0xd8cce000  ! 454: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r12
	mov	0x60, %r25
	.word 0xd6a4c400  ! 456: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0xd8870e40  ! 457: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r12
	mov	0x7e0, %r21
	.word 0xd8bc0400  ! 459: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xdacc2000  ! 460: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xd6ac8400  ! 461: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	mov	0x3f0, %r20
	.word 0xd4bfce40  ! 463: STDA_R	stda	%r10, [%r31 + %r0] 0x72
	.word 0xd4ae89e0  ! 464: STBA_R	stba	%r10, [%r26 + %r0] 0x4f
	.word 0xd0848400  ! 465: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r8
	ta	T_CHANGE_PRIV	! macro
	ta	T_CHANGE_HPRIV	! macro
	mov	0x40, %r25
	mov	0x7f0, %r23
	.word 0xd2ac2000  ! 470: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd2c46000  ! 471: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	mov	0x38, %r26
	.word 0xd89d44a0  ! 473: LDDA_R	ldda	[%r21, %r0] 0x25, %r12
	.word 0xdab46000  ! 474: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0xd6f544a0  ! 475: STXA_R	stxa	%r11, [%r21 + %r0] 0x25
	.word 0xd69ca000  ! 476: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r11
	.word 0x87802020  ! 477: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bc2000  ! 478: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0xd6bc2000  ! 479: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0xdcb70e40  ! 480: STHA_R	stha	%r14, [%r28 + %r0] 0x72
	.word 0xda942000  ! 481: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0xd4dc8400  ! 482: LDXA_R	ldxa	[%r18, %r0] 0x20, %r10
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7f0, %r23
	.word 0xda9e49e0  ! 485: LDDA_R	ldda	[%r25, %r0] 0x4f, %r13
	mov	0x7d0, %r20
	mov	0x3d8, %r20
	.word 0x87802025  ! 488: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f8, %r23
	.word 0xd8948400  ! 490: LDUHA_R	lduha	[%r18, %r0] 0x20, %r12
	mov	0x3d8, %r23
	.word 0x87802020  ! 492: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dc8400  ! 493: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0xd6bca000  ! 494: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	.word 0xd8ae49e0  ! 495: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0xd48609e0  ! 496: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r10
	mov	0x50, %r25
	mov	0x70, %r17
	.word 0xd6b4a000  ! 499: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd69fce80  ! 500: LDDA_R	ldda	[%r31, %r0] 0x74, %r11
	.word 0xd48e89e0  ! 501: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r10
	mov	0x68, %r27
	.word 0xd4bd04a0  ! 503: STDA_R	stda	%r10, [%r20 + %r0] 0x25
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x0, %r18
	.word 0x87802020  ! 506: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dfa000  ! 507: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0x87802020  ! 508: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebc8400  ! 509: STDA_R	stda	%r15, [%r18 + %r0] 0x20
	.word 0xd2bcc400  ! 510: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0x87802020  ! 511: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0840400  ! 512: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	.word 0x87802020  ! 513: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cc8400  ! 514: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0xd4f72000  ! 515: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xdcd544a0  ! 516: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r14
	.word 0xd4b7e000  ! 517: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd4f76000  ! 518: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd2b74e40  ! 519: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	.word 0xdedf2000  ! 520: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	mov	0x48, %r17
	.word 0xd88dc4a0  ! 522: LDUBA_R	lduba	[%r23, %r0] 0x25, %r12
	mov	0x3f0, %r20
	.word 0xdecf4e60  ! 524: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r15
	.word 0xd8dcc400  ! 525: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	.word 0xd2b7e000  ! 526: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2b76000  ! 527: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd0dc8400  ! 528: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	wr_tick_cmpr_3_1:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xd7, %g2
	or	%g4, 0xd5, %g4
	or	%g6, 0xd0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802074  ! 530: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f5e000  ! 531: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	mov	0x40, %r25
	.word 0xd4956000  ! 533: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r10
	.word 0xd2bfce40  ! 534: STDA_R	stda	%r9, [%r31 + %r0] 0x72
	.word 0xdef544a0  ! 535: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	.word 0xd2ada000  ! 536: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	mov	0x20, %r19
	.word 0xd2bde000  ! 538: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	mov	0x78, %r17
	.word 0xdef7ce60  ! 540: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0xd0b70e60  ! 541: STHA_R	stha	%r8, [%r28 + %r0] 0x73
	.word 0xd8d4c400  ! 542: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0x8780204f  ! 543: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f7e000  ! 544: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	mov	0x38, %r25
	.word 0xd6c7e000  ! 546: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xd48fce60  ! 547: LDUBA_R	lduba	[%r31, %r0] 0x73, %r10
	.word 0xd4a76000  ! 548: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xdccd04a0  ! 549: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r14
	.word 0x8780204f  ! 550: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde8fce80  ! 551: LDUBA_R	lduba	[%r31, %r0] 0x74, %r15
	mov	0x18, %r27
	.word 0xdadce000  ! 553: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	mov	0x7e0, %r22
	mov	0x8, %r26
	.word 0xd6f609e0  ! 556: STXA_R	stxa	%r11, [%r24 + %r0] 0x4f
	.word 0xded42000  ! 557: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	mov	0x40, %r18
	.word 0xdeac2000  ! 559: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xdedce000  ! 560: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r15
	mov	0x68, %r27
	.word 0x87802020  ! 562: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc85c4a0  ! 563: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r14
	mov	0x60, %r24
	.word 0x8780204f  ! 565: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ad6000  ! 566: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	.word 0xd8b544a0  ! 567: STHA_R	stha	%r12, [%r21 + %r0] 0x25
	.word 0xded649e0  ! 568: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r15
	.word 0xd89d2000  ! 569: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r12
	.word 0xd4b544a0  ! 570: STHA_R	stha	%r10, [%r21 + %r0] 0x25
	mov	0x60, %r25
	.word 0xdea5c4a0  ! 572: STWA_R	stwa	%r15, [%r23 + %r0] 0x25
	mov	0x3d8, %r23
	.word 0x87802020  ! 574: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd89c4400  ! 576: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	mov	0x20, %r17
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd69c2000  ! 579: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r11
	mov	0x68, %r17
	.word 0xdcb609e0  ! 581: STHA_R	stha	%r14, [%r24 + %r0] 0x4f
	.word 0xd687ce40  ! 582: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r11
	.word 0xd0b42000  ! 583: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xd49f0e80  ! 584: LDDA_R	ldda	[%r28, %r0] 0x74, %r10
	mov	0x18, %r24
	.word 0xd4842000  ! 586: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	.word 0xd4bce000  ! 587: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	mov	0x58, %r26
	.word 0xd4dce000  ! 589: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	.word 0xd2f4c400  ! 590: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	mov	0x60, %r19
	mov	0x48, %r25
	.word 0xda8f0e60  ! 593: LDUBA_R	lduba	[%r28, %r0] 0x73, %r13
	mov	0x7e8, %r22
	.word 0xdca544a0  ! 595: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	mov	0x78, %r18
	.word 0xdcb4a000  ! 597: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xd4d48400  ! 598: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	.word 0xdabf4e60  ! 599: STDA_R	stda	%r13, [%r29 + %r0] 0x73
	.word 0xdcd4e000  ! 600: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	mov	0x70, %r17
	.word 0xdc9ca000  ! 602: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r14
	mov	0x38, %r18
	mov	0x78, %r17
	.word 0xd0b70e80  ! 605: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	.word 0xd4d74e40  ! 606: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r10
	.word 0xdaa40400  ! 607: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0x87802074  ! 608: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b7e000  ! 609: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2f7e000  ! 610: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 611: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f44400  ! 612: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0x87802020  ! 613: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b70e80  ! 614: STHA_R	stha	%r9, [%r28 + %r0] 0x74
	.word 0xd096a000  ! 615: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r8
	.word 0xde9504a0  ! 616: LDUHA_R	lduha	[%r20, %r0] 0x25, %r15
	.word 0xdaaea000  ! 617: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	.word 0x87802072  ! 618: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcdf8e80  ! 619: LDXA_R	ldxa	[%r30, %r0] 0x74, %r14
	.word 0xd2af2000  ! 620: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	mov	0x58, %r26
	.word 0x87802073  ! 622: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r17
	mov	0x60, %r27
	.word 0xd2bf4e80  ! 625: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	.word 0xdcf74e80  ! 626: STXA_R	stxa	%r14, [%r29 + %r0] 0x74
	.word 0xdcbda000  ! 627: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	.word 0xdcc52000  ! 628: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r14
	.word 0xdcbd6000  ! 629: STDA_I	stda	%r14, [%r21 + 0x0000] %asi
	mov	0x28, %r27
	mov	0x3c0, %r21
	.word 0xdca56000  ! 632: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	mov	0x48, %r16
	.word 0xd2b74e60  ! 634: STHA_R	stha	%r9, [%r29 + %r0] 0x73
	.word 0xd08e49e0  ! 635: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r8
	.word 0xd48d2000  ! 636: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0xd6b78e40  ! 637: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	mov	0x60, %r17
	.word 0xdc852000  ! 639: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r14
	.word 0xd6afce40  ! 640: STBA_R	stba	%r11, [%r31 + %r0] 0x72
	.word 0xdebde000  ! 641: STDA_I	stda	%r15, [%r23 + 0x0000] %asi
	.word 0xdeb74e60  ! 642: STHA_R	stha	%r15, [%r29 + %r0] 0x73
	.word 0xd8c7ce60  ! 643: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r12
	.word 0xd2b78e40  ! 644: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	.word 0x87802020  ! 645: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cee000  ! 646: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	.word 0xdc94c400  ! 647: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	wr_tick_cmpr_3_2:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb2, %g2
	or	%g4, 0xd4, %g4
	or	%g6, 0xa1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7e8, %r21
	.word 0xd8a6e000  ! 650: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	.word 0x87802074  ! 651: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd88ca000  ! 652: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	.word 0xd8b42000  ! 653: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 654: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8b4e000  ! 655: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 656: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r16
	mov	0x38, %r25
	.word 0xd4bd84a0  ! 659: STDA_R	stda	%r10, [%r22 + %r0] 0x25
	mov	0x10, %r27
	.word 0xd0940400  ! 661: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	.word 0xd09f6000  ! 662: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	.word 0xdadcc400  ! 663: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xdc9f2000  ! 664: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0x87802072  ! 665: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7c8, %r23
	mov	0x3e0, %r23
	mov	0x38, %r24
	.word 0xdcad2000  ! 669: STBA_I	stba	%r14, [%r20 + 0x0000] %asi
	.word 0xde8f8e60  ! 670: LDUBA_R	lduba	[%r30, %r0] 0x73, %r15
	.word 0xd2a40400  ! 671: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xdcbf4e60  ! 672: STDA_R	stda	%r14, [%r29 + %r0] 0x73
	.word 0x87802074  ! 673: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f4e000  ! 674: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 675: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 676: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cf2000  ! 677: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0x87802073  ! 678: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c8, %r21
	.word 0xd8ad04a0  ! 680: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	mov	0x70, %r25
	.word 0xd8ade000  ! 682: STBA_I	stba	%r12, [%r23 + 0x0000] %asi
	mov	0x10, %r27
	.word 0xd2944400  ! 684: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	.word 0xdeb48400  ! 685: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0x87802020  ! 686: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 687: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 688: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b70e80  ! 689: STHA_R	stha	%r9, [%r28 + %r0] 0x74
	.word 0x87802020  ! 690: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r22
	.word 0xda8f0e60  ! 692: LDUBA_R	lduba	[%r28, %r0] 0x73, %r13
	mov	0x7c8, %r20
	.word 0xdc95a000  ! 694: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r14
	.word 0xdcc4c400  ! 695: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	.word 0xd09689e0  ! 696: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r8
	.word 0xdedde000  ! 697: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r15
	.word 0xde9d2000  ! 698: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r15
	.word 0x87802074  ! 699: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeb5a000  ! 700: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	.word 0xd8874e80  ! 701: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r12
	mov	0x70, %r16
	.word 0x8780204f  ! 703: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd48c8400  ! 704: LDUBA_R	lduba	[%r18, %r0] 0x20, %r10
	.word 0xd6dcc400  ! 705: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	.word 0x87802074  ! 706: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcafe000  ! 707: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdcdf2000  ! 708: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xd4f649e0  ! 709: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	.word 0xd0afa000  ! 710: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	wr_tick_cmpr_3_3:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xc8, %g2
	or	%g4, 0xd9, %g4
	or	%g6, 0xca, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x70, %r26
	.word 0xd4c7ce60  ! 713: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r10
	.word 0x87802072  ! 714: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd28e2000  ! 715: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	mov	0x20, %r25
	.word 0xd2c6e000  ! 717: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r9
	.word 0xd2ce6000  ! 718: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r9
	.word 0x87802020  ! 719: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r20
	.word 0xd28ce000  ! 721: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	.word 0x87802072  ! 722: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r25
	.word 0xded48400  ! 724: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	.word 0xd6ac8400  ! 725: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	mov	0x68, %r17
	.word 0xd4dc6000  ! 727: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 728: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4dfa000  ! 729: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd0f6c9e0  ! 730: STXA_R	stxa	%r8, [%r27 + %r0] 0x4f
	.word 0x87802073  ! 731: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d8, %r21
	.word 0xd2ac6000  ! 733: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xded40400  ! 734: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	wr_tick_cmpr_3_4:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x93, %g2
	or	%g4, 0xd8, %g4
	or	%g6, 0xe7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdcf44400  ! 736: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	mov	0x7e8, %r23
	mov	0x78, %r24
	.word 0xd6de89e0  ! 739: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r11
	.word 0xdaa649e0  ! 740: STWA_R	stwa	%r13, [%r25 + %r0] 0x4f
	.word 0xd8842000  ! 741: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	mov	0x20, %r26
	.word 0xd884e000  ! 743: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r12
	.word 0xdeb48400  ! 744: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xd4bc6000  ! 745: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xd4bca000  ! 746: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	mov	0x10, %r16
	.word 0xdac544a0  ! 748: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r13
	mov	0x50, %r16
	mov	0x7e0, %r23
	.word 0x87802020  ! 751: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 752: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeafe000  ! 753: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xdede49e0  ! 754: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r15
	.word 0x87802073  ! 755: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c0, %r22
	mov	0x78, %r24
	mov	0x28, %r16
	.word 0xda9c4400  ! 759: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	.word 0xdcc66000  ! 760: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	.word 0xdabe49e0  ! 761: STDA_R	stda	%r13, [%r25 + %r0] 0x4f
	.word 0xd4dee000  ! 762: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r10
	.word 0xd8b7ce40  ! 763: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0xd0c74e40  ! 764: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r8
	.word 0x87802020  ! 765: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde876000  ! 766: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xdeafe000  ! 767: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	mov	0x3f0, %r20
	.word 0x87802025  ! 769: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r18
	.word 0x87802074  ! 771: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xded6c9e0  ! 772: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r15
	.word 0xd48fe000  ! 773: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xd4f7e000  ! 774: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4c72000  ! 775: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4a7e000  ! 776: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4b7e000  ! 777: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xd4df6000  ! 779: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4a72000  ! 780: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd487a000  ! 781: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4c70e60  ! 782: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r10
	.word 0xdef584a0  ! 783: STXA_R	stxa	%r15, [%r22 + %r0] 0x25
	.word 0xdea70e60  ! 784: STWA_R	stwa	%r15, [%r28 + %r0] 0x73
	mov	0x7d8, %r23
	.word 0xd4870e40  ! 786: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r10
	mov	0x7f8, %r21
	.word 0xd08f2000  ! 788: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	mov	0x28, %r16
	.word 0xd6bf8e80  ! 790: STDA_R	stda	%r11, [%r30 + %r0] 0x74
	.word 0xd4dfe000  ! 791: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	mov	0x7f8, %r22
	mov	0x10, %r18
	.word 0xd8bcc400  ! 794: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	mov	0x60, %r17
	.word 0xdeb76000  ! 796: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xde9fa000  ! 797: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	.word 0xd4df4e40  ! 798: LDXA_R	ldxa	[%r29, %r0] 0x72, %r10
	.word 0xd087e000  ! 799: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0xd4a584a0  ! 800: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	.word 0xd6cfa000  ! 801: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0xd6afe000  ! 802: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x18, %r18
	.word 0xd0cfce60  ! 804: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r8
	.word 0xded7e000  ! 805: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	mov	0x48, %r26
	.word 0x8780204f  ! 807: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x0, %r19
	.word 0xdeb46000  ! 809: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	wr_tick_cmpr_3_5:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x80, %g2
	or	%g4, 0x8e, %g4
	or	%g6, 0xd4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdedc6000  ! 811: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r15
	.word 0xdef4a000  ! 812: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0xde846000  ! 813: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 814: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b44400  ! 815: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0xd8c4c400  ! 816: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r12
	mov	0x3f8, %r20
	.word 0xdef74e60  ! 818: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	.word 0xdccf8e60  ! 819: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r14
	mov	0x3c8, %r23
	.word 0x87802073  ! 821: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6ad6000  ! 822: STBA_I	stba	%r11, [%r21 + 0x0000] %asi
	.word 0xd0d74e40  ! 823: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r8
	mov	0x60, %r25
	mov	0x60, %r16
	.word 0x87802073  ! 826: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 827: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r19
	mov	0x78, %r27
	.word 0xd4bc6000  ! 830: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	mov	0x48, %r26
	mov	0x3e8, %r21
	mov	0x7f0, %r23
	.word 0xdabe49e0  ! 834: STDA_R	stda	%r13, [%r25 + %r0] 0x4f
	.word 0xd6df8e40  ! 835: LDXA_R	ldxa	[%r30, %r0] 0x72, %r11
	.word 0xd0c44400  ! 836: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r8
	mov	0x48, %r24
	.word 0xd4ace000  ! 838: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0xd49ca000  ! 839: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd2d7ce60  ! 840: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r9
	.word 0xdcacc400  ! 841: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0xd0846000  ! 842: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0xd0dd84a0  ! 843: LDXA_R	ldxa	[%r22, %r0] 0x25, %r8
	.word 0x87802020  ! 844: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 845: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r17
	mov	0x3d0, %r20
	.word 0x87802020  ! 848: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28f4e80  ! 849: LDUBA_R	lduba	[%r29, %r0] 0x74, %r9
	mov	0x7d8, %r20
	.word 0xdeb584a0  ! 851: STHA_R	stha	%r15, [%r22 + %r0] 0x25
	.word 0xdcbc6000  ! 852: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xdcbc6000  ! 853: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	mov	0x48, %r27
	mov	0x78, %r25
	.word 0xdca46000  ! 856: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 857: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf4a000  ! 858: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xd49689e0  ! 859: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r10
	.word 0x87802074  ! 860: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f66000  ! 861: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	.word 0xd0dee000  ! 862: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r8
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdebcc400  ! 864: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	.word 0x87802072  ! 865: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xded4e000  ! 866: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	.word 0xdecca000  ! 867: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	.word 0xdef4a000  ! 868: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	mov	0x3c0, %r20
	.word 0xd4dcc400  ! 870: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0xda84a000  ! 871: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	mov	0x70, %r25
	.word 0x87802072  ! 873: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r27
	mov	0x60, %r16
	.word 0xdea544a0  ! 876: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	.word 0x87802073  ! 877: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 878: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r24
	.word 0x87802073  ! 880: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda9ec9e0  ! 881: LDDA_R	ldda	[%r27, %r0] 0x4f, %r13
	.word 0xd0bf8e40  ! 882: STDA_R	stda	%r8, [%r30 + %r0] 0x72
	.word 0x8780204f  ! 883: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 884: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3f8, %r23
	.word 0xdca584a0  ! 886: STWA_R	stwa	%r14, [%r22 + %r0] 0x25
	.word 0xd0a74e40  ! 887: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	.word 0xd49ea000  ! 888: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	mov	0x10, %r19
	.word 0xd0a44400  ! 890: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xd697ce60  ! 891: LDUHA_R	lduha	[%r31, %r0] 0x73, %r11
	.word 0xd69ea000  ! 892: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r11
	.word 0xd6b6a000  ! 893: STHA_I	stha	%r11, [%r26 + 0x0000] %asi
	.word 0xdec649e0  ! 894: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r15
	.word 0xdc9f0e80  ! 895: LDDA_R	ldda	[%r28, %r0] 0x74, %r14
	.word 0xd8dfce60  ! 896: LDXA_R	ldxa	[%r31, %r0] 0x73, %r12
	.word 0xdea66000  ! 897: STWA_I	stwa	%r15, [%r25 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0xdece2000  ! 899: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r15
	.word 0x87802020  ! 900: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r21
	.word 0xdea7e000  ! 902: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	mov	0x3f8, %r20
	mov	0x28, %r25
	.word 0x87802025  ! 905: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 906: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf48400  ! 907: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xdcb74e60  ! 908: STHA_R	stha	%r14, [%r29 + %r0] 0x73
	.word 0xdecc6000  ! 909: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r15
	.word 0xdec4a000  ! 910: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xdecca000  ! 911: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	.word 0xde84e000  ! 912: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	mov	0x10, %r16
	.word 0xdadcc400  ! 914: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0x8780204f  ! 915: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c8, %r22
	.word 0xd0bda000  ! 917: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	.word 0xd4bfce60  ! 918: STDA_R	stda	%r10, [%r31 + %r0] 0x73
	.word 0xd2ad2000  ! 919: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xdcc48400  ! 920: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r14
	.word 0xd8d649e0  ! 921: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r12
	.word 0xd8b74e80  ! 922: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	.word 0xd2b52000  ! 923: STHA_I	stha	%r9, [%r20 + 0x0000] %asi
	.word 0xdcf70e40  ! 924: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	mov	0x50, %r27
	mov	0x3f0, %r20
	.word 0xdaf48400  ! 927: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	mov	0x10, %r26
	mov	0x7c8, %r20
	.word 0xd695e000  ! 930: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r11
	.word 0xd6a5e000  ! 931: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	.word 0xd69d6000  ! 932: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r11
	.word 0xde8f8e80  ! 933: LDUBA_R	lduba	[%r30, %r0] 0x74, %r15
	mov	0x3d8, %r22
	mov	0x7c8, %r20
	.word 0xdcd56000  ! 936: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r14
	.word 0xdeb44400  ! 937: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0xd4dd6000  ! 938: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r10
	.word 0xd485a000  ! 939: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r10
	.word 0xd48de000  ! 940: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r10
	mov	0x70, %r17
	mov	0x48, %r17
	.word 0xd4d5e000  ! 943: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r10
	.word 0xded40400  ! 944: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	.word 0xd6d5e000  ! 945: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r11
	.word 0xd2bf0e80  ! 946: STDA_R	stda	%r9, [%r28 + %r0] 0x74
	.word 0xd0d584a0  ! 947: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r8
	.word 0xdeb5e000  ! 948: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	mov	0x20, %r16
	.word 0xd6b70e40  ! 950: STHA_R	stha	%r11, [%r28 + %r0] 0x72
	mov	0x78, %r27
	.word 0xd28d6000  ! 952: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r9
	.word 0xd897ce80  ! 953: LDUHA_R	lduha	[%r31, %r0] 0x74, %r12
	.word 0xd4cf8e60  ! 954: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r10
	.word 0xdeb5a000  ! 955: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xdebf0e60  ! 957: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	.word 0x87802020  ! 958: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r17
	.word 0xdcbf6000  ! 960: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 961: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf7e000  ! 962: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xd8b70e60  ! 963: STHA_R	stha	%r12, [%r28 + %r0] 0x73
	.word 0xd2872000  ! 964: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	.word 0xd28fa000  ! 965: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	mov	0x7c8, %r22
	.word 0xd2bfe000  ! 967: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 968: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r24
	mov	0x20, %r17
	.word 0xd0cf4e40  ! 971: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	.word 0xdcbee000  ! 972: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	mov	0x0, %r16
	mov	0x70, %r27
	.word 0x87802074  ! 975: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcc72000  ! 976: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xd0d584a0  ! 977: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r8
	.word 0xd4b504a0  ! 978: STHA_R	stha	%r10, [%r20 + %r0] 0x25
	.word 0xd2af6000  ! 979: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd08f0e80  ! 980: LDUBA_R	lduba	[%r28, %r0] 0x74, %r8
	.word 0xd08609e0  ! 981: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r8
	.word 0x87802074  ! 982: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 983: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r18
	.word 0xdaa70e40  ! 985: STWA_R	stwa	%r13, [%r28 + %r0] 0x72
	.word 0xd4d72000  ! 986: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	.word 0xd8ad84a0  ! 987: STBA_R	stba	%r12, [%r22 + %r0] 0x25
	.word 0xd6af2000  ! 988: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x8, %r27
	.word 0xd6af2000  ! 990: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x3d8, %r22
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2b7ce80  ! 993: STHA_R	stha	%r9, [%r31 + %r0] 0x74
	.word 0xd4c74e60  ! 994: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r10
	.word 0x87802020  ! 995: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r23
	.word 0xdcb649e0  ! 997: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	.word 0x87802074  ! 998: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 999: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r24
	.word 0xd697a000  ! 1001: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	mov	0x38, %r18
	.word 0x87802025  ! 1003: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r27
	.word 0x8780204f  ! 1005: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0878e40  ! 1006: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r8
	mov	0x7e0, %r22
	.word 0xd685e000  ! 1008: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r11
	mov	0x8, %r16
	mov	0x28, %r18
	.word 0xdedfce40  ! 1011: LDXA_R	ldxa	[%r31, %r0] 0x72, %r15
	.word 0xdc8d6000  ! 1012: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r14
	.word 0xda9c4400  ! 1013: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	.word 0x87802072  ! 1014: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb46000  ! 1015: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 1016: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1017: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc942000  ! 1018: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 1019: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc8f4e60  ! 1020: LDUBA_R	lduba	[%r29, %r0] 0x73, %r14
	.word 0xd0f42000  ! 1021: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0xde9689e0  ! 1022: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r15
	mov	0x3c0, %r22
	mov	0x30, %r25
	.word 0xd294e000  ! 1025: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	.word 0xd2cca000  ! 1026: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	mov	0x30, %r19
	.word 0xd28c2000  ! 1028: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xd2a42000  ! 1029: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	.word 0xd2bc2000  ! 1030: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xdeb4c400  ! 1031: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xd08e09e0  ! 1032: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r8
	.word 0xdac504a0  ! 1033: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r13
	.word 0xd2878e80  ! 1034: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r9
	.word 0xdad74e80  ! 1035: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r13
	.word 0xde8c2000  ! 1036: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	.word 0xd0bf8e80  ! 1037: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	mov	0x30, %r18
	.word 0xdedcc400  ! 1039: LDXA_R	ldxa	[%r19, %r0] 0x20, %r15
	.word 0xd8ac2000  ! 1040: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	mov	0x10, %r26
	mov	0x7f0, %r23
	.word 0xdabf4e60  ! 1043: STDA_R	stda	%r13, [%r29 + %r0] 0x73
	mov	0x7e0, %r21
	.word 0xd8974e40  ! 1045: LDUHA_R	lduha	[%r29, %r0] 0x72, %r12
	.word 0xd084a000  ! 1046: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	.word 0xd28f0e80  ! 1047: LDUBA_R	lduba	[%r28, %r0] 0x74, %r9
	mov	0x50, %r18
	.word 0xd8ac6000  ! 1049: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	mov	0x68, %r17
	.word 0xd8a46000  ! 1051: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xd88c2000  ! 1052: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	.word 0xd8c70e40  ! 1053: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r12
	.word 0xd28ca000  ! 1054: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0x87802073  ! 1055: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 1056: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 1057: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2c4a000  ! 1058: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	.word 0xd2bce000  ! 1059: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xd2f46000  ! 1060: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2f42000  ! 1061: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0xd2cca000  ! 1062: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2cce000  ! 1063: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	mov	0x68, %r16
	.word 0xd2c42000  ! 1065: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	.word 0xd28ce000  ! 1066: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	.word 0xd4b48400  ! 1067: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd8b4a000  ! 1068: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xd8bc2000  ! 1070: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 1071: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r24
	mov	0x8, %r26
	.word 0xd2c7ce60  ! 1074: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r9
	.word 0x87802020  ! 1075: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda972000  ! 1076: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0xda876000  ! 1077: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0xdaaf2000  ! 1078: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xd8f689e0  ! 1079: STXA_R	stxa	%r12, [%r26 + %r0] 0x4f
	mov	0x0, %r27
	.word 0xd0bfe000  ! 1081: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd0af6000  ! 1082: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xd4b584a0  ! 1084: STHA_R	stha	%r10, [%r22 + %r0] 0x25
	wr_tick_cmpr_3_6:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x91, %g2
	or	%g4, 0xf9, %g4
	or	%g6, 0xba, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0f72000  ! 1086: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	mov	0x8, %r24
	mov	0x7f0, %r20
	.word 0xdc8504a0  ! 1089: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r14
	.word 0xdca40400  ! 1090: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xd4cfe000  ! 1091: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0xde978e40  ! 1092: LDUHA_R	lduha	[%r30, %r0] 0x72, %r15
	mov	0x60, %r19
	wr_tick_cmpr_3_7:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb6, %g2
	or	%g4, 0xfd, %g4
	or	%g6, 0x8d, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2dfe000  ! 1095: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0x87802074  ! 1096: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28c6000  ! 1097: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0xd29c6000  ! 1098: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	mov	0x78, %r16
	mov	0x20, %r25
	.word 0xd2a42000  ! 1101: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	mov	0x50, %r16
	.word 0x8780204f  ! 1103: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4dcc400  ! 1104: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0xd8df0e40  ! 1105: LDXA_R	ldxa	[%r28, %r0] 0x72, %r12
	.word 0xded66000  ! 1106: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r15
	mov	0x58, %r24
	.word 0x87802020  ! 1108: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeac2000  ! 1109: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xdec46000  ! 1110: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	ta	T_CHANGE_PRIV	! macro
	.word 0xdef4a000  ! 1112: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 1113: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd48f4e80  ! 1114: LDUBA_R	lduba	[%r29, %r0] 0x74, %r10
	.word 0xd6b4e000  ! 1115: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xd0b78e60  ! 1116: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	.word 0xdaad84a0  ! 1117: STBA_R	stba	%r13, [%r22 + %r0] 0x25
	.word 0xdaa4a000  ! 1118: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xdaf42000  ! 1119: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0xda9ce000  ! 1120: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r13
	.word 0xda84e000  ! 1121: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r13
	.word 0xdef74e60  ! 1122: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	mov	0x58, %r26
	.word 0xdeac2000  ! 1124: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xdecc6000  ! 1125: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r15
	.word 0xdea4a000  ! 1126: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	mov	0x68, %r26
	.word 0xdcc48400  ! 1128: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r14
	mov	0x7c8, %r23
	.word 0xd4cc6000  ! 1130: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	mov	0x3c8, %r20
	.word 0xd4a42000  ! 1132: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 1133: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f44400  ! 1134: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	.word 0xde9f8e40  ! 1135: LDDA_R	ldda	[%r30, %r0] 0x72, %r15
	.word 0xdef7e000  ! 1136: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 1137: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xded72000  ! 1138: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xdadc8400  ! 1139: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	.word 0xd09fce80  ! 1140: LDDA_R	ldda	[%r31, %r0] 0x74, %r8
	.word 0x87802020  ! 1141: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r21
	mov	0x20, %r27
	.word 0xdcf52000  ! 1144: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 1145: WRASI_I	wr	%r0, 0x0074, %asi
	wr_tick_cmpr_3_8:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xcb, %g2
	or	%g4, 0x9c, %g4
	or	%g6, 0xd4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x20, %r24
	.word 0xdcb76000  ! 1148: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xd2d40400  ! 1149: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	.word 0x87802020  ! 1150: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r16
	.word 0xdcad2000  ! 1152: STBA_I	stba	%r14, [%r20 + 0x0000] %asi
	.word 0xdcdde000  ! 1153: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	.word 0xdcc52000  ! 1154: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r14
	ta	T_CHANGE_PRIV	! macro
	.word 0xdcdde000  ! 1156: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	.word 0xdcbd6000  ! 1157: STDA_I	stda	%r14, [%r21 + 0x0000] %asi
	.word 0xd8afce40  ! 1158: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 1159: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x0, %r16
	.word 0xd6ad44a0  ! 1161: STBA_R	stba	%r11, [%r21 + %r0] 0x25
	mov	0x7c0, %r23
	mov	0x18, %r17
	.word 0xd6ad04a0  ! 1164: STBA_R	stba	%r11, [%r20 + %r0] 0x25
	mov	0x0, %r26
	.word 0xd88fce80  ! 1166: LDUBA_R	lduba	[%r31, %r0] 0x74, %r12
	.word 0xdca689e0  ! 1167: STWA_R	stwa	%r14, [%r26 + %r0] 0x4f
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd88ec9e0  ! 1169: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r12
	mov	0x60, %r17
	.word 0xdef7a000  ! 1171: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdea7e000  ! 1172: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xdef7e000  ! 1173: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xdccfce40  ! 1174: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r14
	.word 0xd2b7e000  ! 1175: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	mov	0x50, %r19
	.word 0xd28689e0  ! 1177: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r9
	mov	0x7e0, %r22
	.word 0x8780204f  ! 1179: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd28f8e40  ! 1180: LDUBA_R	lduba	[%r30, %r0] 0x72, %r9
	.word 0x87802025  ! 1181: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r19
	mov	0x68, %r26
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdc8689e0  ! 1185: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r14
	.word 0xd8bf0e40  ! 1186: STDA_R	stda	%r12, [%r28 + %r0] 0x72
	.word 0xd4ae49e0  ! 1187: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	mov	0x78, %r26
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802074  ! 1190: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 1191: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdecf4e80  ! 1192: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r15
	.word 0x8780204f  ! 1193: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc97a000  ! 1194: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	.word 0xdcbf6000  ! 1195: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdecf4e40  ! 1196: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r15
	.word 0xd8bfce60  ! 1197: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	.word 0xd4f70e60  ! 1198: STXA_R	stxa	%r10, [%r28 + %r0] 0x73
	.word 0xd2b72000  ! 1199: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xde8c0400  ! 1200: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0xd0bf2000  ! 1201: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xd6d7ce60  ! 1202: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r11
	.word 0xd09f2000  ! 1203: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0xd09f2000  ! 1204: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0xdcb544a0  ! 1205: STHA_R	stha	%r14, [%r21 + %r0] 0x25
	.word 0xd6cf6000  ! 1206: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	mov	0x58, %r24
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd69f6000  ! 1209: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	.word 0xd4b5c4a0  ! 1210: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	mov	0x8, %r26
	mov	0x10, %r19
	.word 0xd6af6000  ! 1213: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0xd6b7a000  ! 1215: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1216: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6dee000  ! 1217: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r11
	.word 0xd6ce6000  ! 1218: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r11
	.word 0xd6b6e000  ! 1219: STHA_I	stha	%r11, [%r27 + 0x0000] %asi
	.word 0xdacf0e40  ! 1220: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r13
	.word 0xd0b62000  ! 1221: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0xdeac8400  ! 1222: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	mov	0x10, %r25
	.word 0xd4be6000  ! 1224: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0x87802074  ! 1225: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e8, %r20
	.word 0x87802073  ! 1227: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r16
	.word 0xd6c689e0  ! 1229: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r11
	.word 0xd2cfce80  ! 1230: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r9
	mov	0x7e8, %r22
	.word 0xd8ae09e0  ! 1232: STBA_R	stba	%r12, [%r24 + %r0] 0x4f
	mov	0x7d0, %r22
	mov	0x3c0, %r21
	mov	0x48, %r26
	.word 0xd0d7ce40  ! 1236: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r8
	mov	0x3e8, %r23
	.word 0xd4a70e40  ! 1238: STWA_R	stwa	%r10, [%r28 + %r0] 0x72
	.word 0xd0f7e000  ! 1239: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1240: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1241: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r19
	.word 0xd6974e60  ! 1243: LDUHA_R	lduha	[%r29, %r0] 0x73, %r11
	mov	0x7e8, %r21
	.word 0xd287e000  ! 1245: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2af2000  ! 1246: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd2c76000  ! 1247: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2bfa000  ! 1248: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd2bf6000  ! 1249: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xdadcc400  ! 1250: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0x87802073  ! 1251: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r16
	.word 0xd6df8e60  ! 1253: LDXA_R	ldxa	[%r30, %r0] 0x73, %r11
	.word 0xdc8fe000  ! 1254: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xdc8f2000  ! 1255: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0xdcb7a000  ! 1256: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xd2b70e40  ! 1257: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	.word 0xd8cf6000  ! 1258: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	wr_tick_cmpr_3_9:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x8a, %g2
	or	%g4, 0x97, %g4
	or	%g6, 0x8a, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2848400  ! 1260: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r9
	.word 0xdc8f6000  ! 1261: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdc970e60  ! 1262: LDUHA_R	lduha	[%r28, %r0] 0x73, %r14
	.word 0xdccf2000  ! 1263: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xd4afce80  ! 1264: STBA_R	stba	%r10, [%r31 + %r0] 0x74
	mov	0x40, %r17
	mov	0x70, %r16
	.word 0xd2af0e60  ! 1267: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	.word 0xd6b544a0  ! 1268: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	wr_tick_cmpr_3_10:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x86, %g2
	or	%g4, 0x8f, %g4
	or	%g6, 0xd4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4f72000  ! 1270: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 1271: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 1272: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd495a000  ! 1273: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r10
	ta	T_CHANGE_HPRIV	! macro
	mov	0x3d8, %r20
	.word 0xd2af0e80  ! 1276: STBA_R	stba	%r9, [%r28 + %r0] 0x74
	.word 0x87802025  ! 1277: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1278: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r16
	mov	0x7e0, %r23
	.word 0xd28c6000  ! 1281: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0x87802074  ! 1282: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd48e89e0  ! 1283: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r10
	.word 0xd8c7a000  ! 1284: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xd0844400  ! 1285: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r8
	mov	0x38, %r19
	.word 0x87802020  ! 1287: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0df2000  ! 1288: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1289: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4af8e60  ! 1290: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x38, %r17
	.word 0xd6de89e0  ! 1293: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r11
	.word 0x87802025  ! 1294: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f78e80  ! 1295: STXA_R	stxa	%r11, [%r30 + %r0] 0x74
	.word 0xd0cc8400  ! 1296: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0xd6a7a000  ! 1297: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	mov	0x68, %r26
	.word 0xdcaf8e40  ! 1299: STBA_R	stba	%r14, [%r30 + %r0] 0x72
	.word 0xdca72000  ! 1300: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcbcc400  ! 1301: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	mov	0x7c8, %r20
	.word 0x87802074  ! 1303: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1304: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r22
	.word 0xd084e000  ! 1306: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	.word 0xd2b40400  ! 1307: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	mov	0x60, %r16
	.word 0x87802073  ! 1309: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r26
	.word 0xd0c6c9e0  ! 1311: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r8
	.word 0xd8dda000  ! 1312: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r12
	.word 0xdecfce80  ! 1313: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r15
	mov	0x70, %r16
	.word 0xdeade000  ! 1315: STBA_I	stba	%r15, [%r23 + 0x0000] %asi
	.word 0xd4a48400  ! 1316: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	mov	0x10, %r16
	mov	0x20, %r24
	.word 0x87802073  ! 1319: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc86c9e0  ! 1320: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r14
	.word 0xdc8ec9e0  ! 1321: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r14
	.word 0xd8bfce80  ! 1322: STDA_R	stda	%r12, [%r31 + %r0] 0x74
	.word 0xd4bc6000  ! 1323: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xd4ace000  ! 1324: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0xd4842000  ! 1325: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	mov	0x10, %r17
	.word 0xdcf70e60  ! 1327: STXA_R	stxa	%r14, [%r28 + %r0] 0x73
	.word 0xd4f4e000  ! 1328: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 1329: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde8d84a0  ! 1330: LDUBA_R	lduba	[%r22, %r0] 0x25, %r15
	.word 0xd0d4a000  ! 1331: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	.word 0xda8f4e80  ! 1332: LDUBA_R	lduba	[%r29, %r0] 0x74, %r13
	mov	0x60, %r16
	.word 0xda9c6000  ! 1334: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	wr_tick_cmpr_3_11:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe4, %g2
	or	%g4, 0x90, %g4
	or	%g6, 0xf3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802072  ! 1336: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdadd6000  ! 1337: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r13
	.word 0xde9d44a0  ! 1338: LDDA_R	ldda	[%r21, %r0] 0x25, %r15
	.word 0xd8f5e000  ! 1339: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	.word 0xdaf74e60  ! 1340: STXA_R	stxa	%r13, [%r29 + %r0] 0x73
	.word 0xd8b56000  ! 1341: STHA_I	stha	%r12, [%r21 + 0x0000] %asi
	.word 0xda944400  ! 1342: LDUHA_R	lduha	[%r17, %r0] 0x20, %r13
	.word 0xdaf5e000  ! 1343: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 1344: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a44400  ! 1345: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	mov	0x28, %r27
	mov	0x40, %r17
	.word 0xdcc42000  ! 1348: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r14
	.word 0xdc94e000  ! 1349: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	.word 0xd6a6c9e0  ! 1350: STWA_R	stwa	%r11, [%r27 + %r0] 0x4f
	mov	0x7f8, %r20
	mov	0x0, %r24
	.word 0xd0bc6000  ! 1353: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	.word 0xd0ac2000  ! 1354: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xde87ce40  ! 1355: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r15
	.word 0xdc94e000  ! 1356: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	mov	0x7e0, %r23
	.word 0xd8c4c400  ! 1358: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r12
	.word 0x87802074  ! 1359: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f0, %r20
	.word 0xd6aca000  ! 1361: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	mov	0x18, %r17
	.word 0x8780204f  ! 1363: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f4a000  ! 1364: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xd0a48400  ! 1366: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 1367: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f7ce80  ! 1368: STXA_R	stxa	%r11, [%r31 + %r0] 0x74
	.word 0xd8b7e000  ! 1369: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 1370: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0dfce80  ! 1371: LDXA_R	ldxa	[%r31, %r0] 0x74, %r8
	.word 0xd6a48400  ! 1372: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0xd2876000  ! 1373: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xda85c4a0  ! 1374: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r13
	mov	0x3f8, %r23
	.word 0xde948400  ! 1376: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	.word 0xd8f76000  ! 1377: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd2bcc400  ! 1378: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xdebf0e80  ! 1379: STDA_R	stda	%r15, [%r28 + %r0] 0x74
	.word 0x87802020  ! 1380: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1381: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r18
	.word 0xdeb74e40  ! 1383: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	.word 0xdeb649e0  ! 1384: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	.word 0xd6942000  ! 1385: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r11
	.word 0x87802073  ! 1386: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 1387: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r25
	mov	0x3c0, %r20
	.word 0xd0b78e80  ! 1390: STHA_R	stha	%r8, [%r30 + %r0] 0x74
	.word 0xd2b584a0  ! 1391: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0xdcf7ce40  ! 1392: STXA_R	stxa	%r14, [%r31 + %r0] 0x72
	.word 0xd8bfce80  ! 1393: STDA_R	stda	%r12, [%r31 + %r0] 0x74
	.word 0xd68fce40  ! 1394: LDUBA_R	lduba	[%r31, %r0] 0x72, %r11
	mov	0x70, %r17
	.word 0xd8f44400  ! 1396: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xdcd7a000  ! 1397: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	mov	0x20, %r16
	.word 0x87802074  ! 1399: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r25
	mov	0x78, %r24
	.word 0xd2f48400  ! 1402: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0xd0944400  ! 1403: LDUHA_R	lduha	[%r17, %r0] 0x20, %r8
	.word 0xdaa78e80  ! 1404: STWA_R	stwa	%r13, [%r30 + %r0] 0x74
	mov	0x8, %r16
	.word 0xd0ad44a0  ! 1406: STBA_R	stba	%r8, [%r21 + %r0] 0x25
	.word 0xdc84e000  ! 1407: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r14
	.word 0xd4870e40  ! 1408: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r10
	.word 0xd2bc2000  ! 1409: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xdabcc400  ! 1410: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	mov	0x58, %r19
	mov	0x10, %r16
	.word 0xdc8ca000  ! 1413: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r14
	.word 0xdebc4400  ! 1414: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0xd6f46000  ! 1415: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 1416: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b7ce40  ! 1417: STHA_R	stha	%r9, [%r31 + %r0] 0x72
	.word 0xdeaf0e80  ! 1418: STBA_R	stba	%r15, [%r28 + %r0] 0x74
	.word 0xd8f4c400  ! 1419: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xd0bf6000  ! 1420: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0xd0972000  ! 1422: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0c76000  ! 1423: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1424: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0c7a000  ! 1425: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0af2000  ! 1426: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 1427: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6ad44a0  ! 1428: STBA_R	stba	%r11, [%r21 + %r0] 0x25
	mov	0x38, %r25
	.word 0xde8f4e40  ! 1430: LDUBA_R	lduba	[%r29, %r0] 0x72, %r15
	wr_tick_cmpr_3_12:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x8d, %g2
	or	%g4, 0xa4, %g4
	or	%g6, 0x9b, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7e8, %r23
	.word 0x87802072  ! 1433: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde9ee000  ! 1434: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r15
	.word 0x87802074  ! 1435: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde872000  ! 1436: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xdc9e89e0  ! 1437: LDDA_R	ldda	[%r26, %r0] 0x4f, %r14
	.word 0x8780204f  ! 1438: WRASI_I	wr	%r0, 0x004f, %asi
	wr_tick_cmpr_3_13:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xc9, %g2
	or	%g4, 0xb2, %g4
	or	%g6, 0xf5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4bc4400  ! 1440: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0xd0dfe000  ! 1441: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	mov	0x3e0, %r20
	.word 0xd09fa000  ! 1443: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 1444: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0bf2000  ! 1445: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xd88f0e40  ! 1446: LDUBA_R	lduba	[%r28, %r0] 0x72, %r12
	.word 0xd2970e80  ! 1447: LDUHA_R	lduha	[%r28, %r0] 0x74, %r9
	.word 0xd09fe000  ! 1448: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	mov	0x78, %r26
	mov	0x3c8, %r21
	mov	0x58, %r16
	.word 0xdcacc400  ! 1452: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0xd4b7e000  ! 1453: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd49f6000  ! 1454: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0xda9f4e40  ! 1455: LDDA_R	ldda	[%r29, %r0] 0x72, %r13
	mov	0x3e0, %r20
	.word 0x87802020  ! 1457: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69f4e80  ! 1458: LDDA_R	ldda	[%r29, %r0] 0x74, %r11
	.word 0xd2b7e000  ! 1459: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xdc9f8e40  ! 1460: LDDA_R	ldda	[%r30, %r0] 0x72, %r14
	.word 0xd4cfa000  ! 1461: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0x87802025  ! 1462: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4b7e000  ! 1463: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xdeccc400  ! 1464: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r15
	mov	0x50, %r19
	.word 0xd0cfa000  ! 1466: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	mov	0x78, %r19
	.word 0xd0f7e000  ! 1468: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0f7a000  ! 1469: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xde9c8400  ! 1470: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	.word 0x87802020  ! 1471: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d48400  ! 1472: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0xd8aec9e0  ! 1473: STBA_R	stba	%r12, [%r27 + %r0] 0x4f
	.word 0xd88e89e0  ! 1474: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r12
	mov	0x38, %r18
	.word 0xd88ce000  ! 1476: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	.word 0xd8b42000  ! 1477: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	mov	0x0, %r27
	mov	0x3e0, %r21
	.word 0xd8f42000  ! 1480: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8dce000  ! 1481: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	.word 0x87802074  ! 1482: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd88d2000  ! 1483: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r12
	mov	0x30, %r17
	.word 0xd8c52000  ! 1485: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1486: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bc4400  ! 1487: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	mov	0x60, %r18
	.word 0xd09c2000  ! 1489: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r8
	mov	0x18, %r17
	.word 0xd0cd84a0  ! 1491: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r8
	.word 0xd0b42000  ! 1492: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 1493: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 1494: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbd04a0  ! 1495: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	.word 0xdabd84a0  ! 1496: STDA_R	stda	%r13, [%r22 + %r0] 0x25
	.word 0x87802025  ! 1497: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r26
	.word 0x87802074  ! 1499: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bf0e80  ! 1500: STDA_R	stda	%r9, [%r28 + %r0] 0x74
	.word 0xdc978e60  ! 1501: LDUHA_R	lduha	[%r30, %r0] 0x73, %r14
	mov	0x48, %r16
	.word 0x87802072  ! 1503: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 1504: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 1505: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bd84a0  ! 1506: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	mov	0x3c0, %r22
	.word 0xdccc6000  ! 1508: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	.word 0xd0acc400  ! 1509: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd8bca000  ! 1510: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd8bc2000  ! 1511: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd8a4a000  ! 1512: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	mov	0x78, %r26
	.word 0xdcf48400  ! 1514: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xdaacc400  ! 1515: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0xd0a42000  ! 1516: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xd0d42000  ! 1517: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1518: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cfce40  ! 1519: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r8
	.word 0xd8a48400  ! 1520: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	wr_tick_cmpr_3_14:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x96, %g2
	or	%g4, 0xe9, %g4
	or	%g6, 0xb5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd69f0e40  ! 1522: LDDA_R	ldda	[%r28, %r0] 0x72, %r11
	.word 0x87802020  ! 1523: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9f0e80  ! 1524: LDDA_R	ldda	[%r28, %r0] 0x74, %r15
	.word 0xd0bde000  ! 1525: STDA_I	stda	%r8, [%r23 + 0x0000] %asi
	mov	0x60, %r19
	mov	0x30, %r19
	.word 0x87802020  ! 1528: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef689e0  ! 1529: STXA_R	stxa	%r15, [%r26 + %r0] 0x4f
	.word 0xd0cd44a0  ! 1530: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r8
	.word 0xd6c56000  ! 1531: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r11
	.word 0xd69cc400  ! 1532: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	mov	0x20, %r27
	.word 0xd0b5a000  ! 1534: STHA_I	stha	%r8, [%r22 + 0x0000] %asi
	.word 0xd4d44400  ! 1535: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0xd4c689e0  ! 1536: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r10
	.word 0xde85e000  ! 1537: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r15
	.word 0xdebd6000  ! 1538: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	.word 0xd4a70e80  ! 1539: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	.word 0x8780204f  ! 1540: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r18
	mov	0x10, %r17
	mov	0x7d8, %r20
	mov	0x40, %r19
	.word 0xd6cfa000  ! 1545: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	mov	0x7c8, %r22
	.word 0xd2a5c4a0  ! 1547: STWA_R	stwa	%r9, [%r23 + %r0] 0x25
	.word 0x87802020  ! 1548: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccc6000  ! 1549: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	.word 0xdc8c2000  ! 1550: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r14
	.word 0xdc94a000  ! 1551: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xd4be09e0  ! 1552: STDA_R	stda	%r10, [%r24 + %r0] 0x4f
	.word 0xd0dca000  ! 1553: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	.word 0xd8bc8400  ! 1554: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xd09ca000  ! 1555: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	.word 0xd0aca000  ! 1556: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 1557: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r19
	mov	0x7c8, %r21
	.word 0xd0cce000  ! 1560: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0af8e40  ! 1561: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0xdaafce40  ! 1562: STBA_R	stba	%r13, [%r31 + %r0] 0x72
	.word 0xd4d4c400  ! 1563: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	mov	0x58, %r16
	.word 0x87802072  ! 1565: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6df2000  ! 1566: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xdedf8e40  ! 1567: LDXA_R	ldxa	[%r30, %r0] 0x72, %r15
	.word 0xd0a76000  ! 1568: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd8af4e80  ! 1569: STBA_R	stba	%r12, [%r29 + %r0] 0x74
	.word 0xd4a7e000  ! 1570: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4af6000  ! 1571: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 1572: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xdcf78e60  ! 1574: STXA_R	stxa	%r14, [%r30 + %r0] 0x73
	.word 0x87802020  ! 1575: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaafe000  ! 1576: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xd4f48400  ! 1577: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xdca544a0  ! 1578: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0xd0970e60  ! 1579: LDUHA_R	lduha	[%r28, %r0] 0x73, %r8
	.word 0xded7a000  ! 1580: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	mov	0x3f8, %r22
	.word 0xdef7a000  ! 1582: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdca40400  ! 1583: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xdeb72000  ! 1584: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xd48c8400  ! 1585: LDUBA_R	lduba	[%r18, %r0] 0x20, %r10
	.word 0xd2a76000  ! 1586: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd8c40400  ! 1587: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	.word 0xd6c7e000  ! 1588: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6afa000  ! 1589: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd897ce80  ! 1590: LDUHA_R	lduha	[%r31, %r0] 0x74, %r12
	.word 0xde876000  ! 1591: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xd2a584a0  ! 1592: STWA_R	stwa	%r9, [%r22 + %r0] 0x25
	.word 0xdeb76000  ! 1593: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xdcd649e0  ! 1594: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r14
	.word 0xd6bec9e0  ! 1595: STDA_R	stda	%r11, [%r27 + %r0] 0x4f
	.word 0xd2dc8400  ! 1596: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0x87802020  ! 1597: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r16
	.word 0xd4f70e60  ! 1599: STXA_R	stxa	%r10, [%r28 + %r0] 0x73
	.word 0xd0ac2000  ! 1600: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xd0bce000  ! 1601: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 1602: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd88fce60  ! 1603: LDUBA_R	lduba	[%r31, %r0] 0x73, %r12
	.word 0xdcc74e40  ! 1604: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r14
	.word 0xd6bf6000  ! 1605: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 1606: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r27
	.word 0xd6b7e000  ! 1608: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd69f6000  ! 1609: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	.word 0xd6f72000  ! 1610: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xdcb40400  ! 1611: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xdcb76000  ! 1612: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xda9689e0  ! 1613: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r13
	.word 0xd0c7a000  ! 1614: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	mov	0x18, %r18
	.word 0xd0d76000  ! 1616: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0bf2000  ! 1617: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xdcb48400  ! 1618: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xd88f4e80  ! 1619: LDUBA_R	lduba	[%r29, %r0] 0x74, %r12
	.word 0xd08f0e40  ! 1620: LDUBA_R	lduba	[%r28, %r0] 0x72, %r8
	.word 0xd2d76000  ! 1621: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0x87802073  ! 1622: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a4c400  ! 1623: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	mov	0x3e8, %r20
	.word 0x87802020  ! 1625: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r17
	.word 0xd8dfa000  ! 1627: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd88fe000  ! 1628: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 1629: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd29c4400  ! 1630: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	.word 0x87802020  ! 1631: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb72000  ! 1632: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xdabfce60  ! 1633: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	.word 0xd6df0e80  ! 1634: LDXA_R	ldxa	[%r28, %r0] 0x74, %r11
	.word 0xd69cc400  ! 1635: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	.word 0xd087e000  ! 1636: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1637: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08c2000  ! 1638: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0xd09c6000  ! 1639: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r8
	mov	0x3d0, %r23
	.word 0x87802073  ! 1641: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 1642: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_3_15:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x93, %g2
	or	%g4, 0x99, %g4
	or	%g6, 0xb6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x10, %r17
	.word 0xd2c74e40  ! 1645: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r9
	.word 0xd09f0e40  ! 1646: LDDA_R	ldda	[%r28, %r0] 0x72, %r8
	mov	0x18, %r24
	mov	0x7d0, %r21
	.word 0xd4a7a000  ! 1649: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xde8e89e0  ! 1650: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r15
	.word 0xd6be49e0  ! 1651: STDA_R	stda	%r11, [%r25 + %r0] 0x4f
	.word 0xd8a584a0  ! 1652: STWA_R	stwa	%r12, [%r22 + %r0] 0x25
	.word 0xdc9689e0  ! 1653: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r14
	.word 0xd4af2000  ! 1654: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd89d04a0  ! 1655: LDDA_R	ldda	[%r20, %r0] 0x25, %r12
	.word 0xda87e000  ! 1656: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdab72000  ! 1658: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdab7e000  ! 1659: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xdabf2000  ! 1660: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xdab7e000  ! 1661: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd68f0e80  ! 1663: LDUBA_R	lduba	[%r28, %r0] 0x74, %r11
	.word 0xd88f4e60  ! 1664: LDUBA_R	lduba	[%r29, %r0] 0x73, %r12
	.word 0xdaafce40  ! 1665: STBA_R	stba	%r13, [%r31 + %r0] 0x72
	mov	0x8, %r16
	.word 0xde87e000  ! 1667: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdecf2000  ! 1668: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xdef7a000  ! 1669: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdea72000  ! 1670: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xd8c44400  ! 1671: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r12
	.word 0xdcb74e40  ! 1672: STHA_R	stha	%r14, [%r29 + %r0] 0x72
	.word 0xd4df8e60  ! 1673: LDXA_R	ldxa	[%r30, %r0] 0x73, %r10
	mov	0x3c0, %r21
	.word 0xdabfe000  ! 1675: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xdadfa000  ! 1676: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xdaafe000  ! 1677: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0xd0dd84a0  ! 1679: LDXA_R	ldxa	[%r22, %r0] 0x25, %r8
	.word 0xd2dfce40  ! 1680: LDXA_R	ldxa	[%r31, %r0] 0x72, %r9
	mov	0x10, %r24
	.word 0xd4df0e60  ! 1682: LDXA_R	ldxa	[%r28, %r0] 0x73, %r10
	.word 0xd0cf0e80  ! 1683: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r8
	.word 0xdab74e80  ! 1684: STHA_R	stha	%r13, [%r29 + %r0] 0x74
	.word 0xdacd04a0  ! 1685: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r13
	.word 0xd09f6000  ! 1686: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	.word 0xd4b609e0  ! 1687: STHA_R	stha	%r10, [%r24 + %r0] 0x4f
	.word 0xd6b78e80  ! 1688: STHA_R	stha	%r11, [%r30 + %r0] 0x74
	mov	0x50, %r19
	.word 0xd4df8e60  ! 1690: LDXA_R	ldxa	[%r30, %r0] 0x73, %r10
	mov	0x7e0, %r22
	.word 0xd88689e0  ! 1692: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r12
	.word 0xde8d84a0  ! 1693: LDUBA_R	lduba	[%r22, %r0] 0x25, %r15
	.word 0xd0cf6000  ! 1694: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd8cf8e80  ! 1695: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r12
	mov	0x40, %r16
	mov	0x3d0, %r21
	.word 0xdc9fa000  ! 1698: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0x87802073  ! 1699: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0d74e40  ! 1701: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r8
	.word 0xd2ce49e0  ! 1702: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r9
	mov	0x40, %r18
	.word 0xdcbc2000  ! 1704: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xdcbc6000  ! 1705: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xdcf4e000  ! 1706: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcc4e000  ! 1707: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r14
	.word 0xde8fce80  ! 1708: LDUBA_R	lduba	[%r31, %r0] 0x74, %r15
	mov	0x10, %r16
	mov	0x50, %r17
	.word 0xdabc2000  ! 1711: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	mov	0x58, %r19
	.word 0xda9ce000  ! 1713: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r13
	.word 0xdaac2000  ! 1714: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0xd0b40400  ! 1715: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0x87802020  ! 1716: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8fce60  ! 1717: LDUBA_R	lduba	[%r31, %r0] 0x73, %r15
	wr_tick_cmpr_3_16:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe7, %g2
	or	%g4, 0xe7, %g4
	or	%g6, 0xba, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4ccc400  ! 1719: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0xd0cca000  ! 1720: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	.word 0xd4c7ce40  ! 1721: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r10
	mov	0x28, %r26
	.word 0x87802072  ! 1723: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r27
	mov	0x60, %r26
	.word 0xdedc0400  ! 1726: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	.word 0xd6ae6000  ! 1727: STBA_I	stba	%r11, [%r25 + 0x0000] %asi
	.word 0xdebdc4a0  ! 1728: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	mov	0x18, %r17
	.word 0x87802025  ! 1730: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2944400  ! 1731: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	mov	0x40, %r17
	.word 0xd2c5e000  ! 1733: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r9
	.word 0xd0a649e0  ! 1734: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	mov	0x50, %r27
	mov	0x40, %r26
	.word 0xdca56000  ! 1737: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdcbde000  ! 1739: STDA_I	stda	%r14, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 1740: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1741: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb66000  ! 1742: STHA_I	stha	%r14, [%r25 + 0x0000] %asi
	mov	0x3f0, %r20
	mov	0x18, %r19
	.word 0xd6b44400  ! 1745: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xd0a62000  ! 1746: STWA_I	stwa	%r8, [%r24 + 0x0000] %asi
	mov	0x38, %r17
	.word 0xd0ce2000  ! 1748: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r8
	mov	0x10, %r27
	mov	0x50, %r24
	mov	0x3f0, %r23
	.word 0xdcd40400  ! 1752: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	.word 0x87802020  ! 1753: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1754: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r25
	mov	0x7d8, %r21
	.word 0xd2adc4a0  ! 1757: STBA_R	stba	%r9, [%r23 + %r0] 0x25
	.word 0x87802072  ! 1758: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd89f0e80  ! 1759: LDDA_R	ldda	[%r28, %r0] 0x74, %r12
	.word 0xd4a72000  ! 1760: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4df2000  ! 1761: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 1762: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6c74e40  ! 1763: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r11
	.word 0x87802073  ! 1764: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8c76000  ! 1765: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	wr_tick_cmpr_3_17:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xce, %g2
	or	%g4, 0x98, %g4
	or	%g6, 0xf6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x58, %r26
	.word 0xd8b7a000  ! 1768: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	mov	0x3c0, %r20
	.word 0xdc940400  ! 1770: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	mov	0x7e8, %r23
	mov	0x58, %r25
	mov	0x8, %r16
	mov	0x0, %r19
	.word 0xd6de89e0  ! 1775: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r11
	.word 0xd4d7a000  ! 1776: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	.word 0xd0bf4e40  ! 1777: STDA_R	stda	%r8, [%r29 + %r0] 0x72
	.word 0xdc87e000  ! 1778: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcd504a0  ! 1779: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r14
	mov	0x18, %r25
	.word 0xd49d04a0  ! 1781: LDDA_R	ldda	[%r20, %r0] 0x25, %r10
	.word 0xd6d72000  ! 1782: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r11
	.word 0xd88504a0  ! 1783: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r12
	mov	0x40, %r24
	.word 0xd097a000  ! 1785: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1786: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r18
	.word 0xdcb40400  ! 1788: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	mov	0x7f0, %r21
	.word 0xdcaea000  ! 1790: STBA_I	stba	%r14, [%r26 + 0x0000] %asi
	.word 0xdcbc4400  ! 1791: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0xdca70e60  ! 1792: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	mov	0x30, %r27
	.word 0xd2bee000  ! 1794: STDA_I	stda	%r9, [%r27 + 0x0000] %asi
	.word 0xd2ae6000  ! 1795: STBA_I	stba	%r9, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 1796: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r16
	.word 0x87802073  ! 1798: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2cf4e60  ! 1799: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r9
	mov	0x68, %r25
	.word 0xd0a66000  ! 1801: STWA_I	stwa	%r8, [%r25 + 0x0000] %asi
	.word 0xd894c400  ! 1802: LDUHA_R	lduha	[%r19, %r0] 0x20, %r12
	.word 0xd09f0e60  ! 1803: LDDA_R	ldda	[%r28, %r0] 0x73, %r8
	.word 0xd09e89e0  ! 1804: LDDA_R	ldda	[%r26, %r0] 0x4f, %r8
	.word 0x87802020  ! 1805: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad7e000  ! 1806: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xde970e60  ! 1807: LDUHA_R	lduha	[%r28, %r0] 0x73, %r15
	.word 0xdaa74e40  ! 1808: STWA_R	stwa	%r13, [%r29 + %r0] 0x72
	.word 0xd6bf0e40  ! 1809: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	.word 0xd2a7e000  ! 1810: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xd8d44400  ! 1811: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	.word 0xdc9fe000  ! 1812: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xd8844400  ! 1813: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r12
	.word 0xdea7e000  ! 1814: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	mov	0x30, %r16
	.word 0xd8c70e80  ! 1816: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r12
	.word 0xded72000  ! 1817: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0x87802020  ! 1818: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1819: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bf8e40  ! 1820: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	.word 0xda96e000  ! 1821: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r13
	.word 0xd6a7ce60  ! 1822: STWA_R	stwa	%r11, [%r31 + %r0] 0x73
	mov	0x3e0, %r22
	.word 0xd8b74e60  ! 1824: STHA_R	stha	%r12, [%r29 + %r0] 0x73
	.word 0x87802074  ! 1825: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabfa000  ! 1826: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	mov	0x28, %r17
	.word 0xdac7a000  ! 1828: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xde8cc400  ! 1829: LDUBA_R	lduba	[%r19, %r0] 0x20, %r15
	.word 0x87802025  ! 1830: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4c56000  ! 1831: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r10
	.word 0xd48d2000  ! 1832: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1833: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a7a000  ! 1834: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd2b7ce80  ! 1835: STHA_R	stha	%r9, [%r31 + %r0] 0x74
	.word 0xda840400  ! 1836: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	mov	0x3f8, %r22
	.word 0xd6f7a000  ! 1838: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xd6bf2000  ! 1840: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xdcbc8400  ! 1841: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xd0b7a000  ! 1842: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xda9c8400  ! 1843: LDDA_R	ldda	[%r18, %r0] 0x20, %r13
	.word 0x87802020  ! 1844: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2c504a0  ! 1846: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r9
	mov	0x20, %r24
	.word 0xd8f76000  ! 1848: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8bf2000  ! 1849: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd29f4e80  ! 1850: LDDA_R	ldda	[%r29, %r0] 0x74, %r9
	.word 0xd2bcc400  ! 1851: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xdaf40400  ! 1852: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xdea7a000  ! 1853: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	mov	0x7c8, %r21
	.word 0x87802020  ! 1855: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef70e40  ! 1856: STXA_R	stxa	%r15, [%r28 + %r0] 0x72
	.word 0xdaaf6000  ! 1857: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	mov	0x60, %r27
	mov	0x3c0, %r23
	.word 0xda9f6000  ! 1860: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xd4bd04a0  ! 1861: STDA_R	stda	%r10, [%r20 + %r0] 0x25
	.word 0x87802020  ! 1862: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cc4400  ! 1863: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r10
	.word 0x87802020  ! 1864: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f74e60  ! 1865: STXA_R	stxa	%r11, [%r29 + %r0] 0x73
	mov	0x48, %r16
	mov	0x50, %r17
	.word 0xdaf72000  ! 1868: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 1869: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda97e000  ! 1870: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	.word 0xdabfe000  ! 1871: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xded44400  ! 1872: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	mov	0x7e0, %r20
	.word 0x87802020  ! 1874: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68e2000  ! 1875: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r11
	.word 0xd6d66000  ! 1876: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r11
	.word 0xd6f6a000  ! 1877: STXA_I	stxa	%r11, [%r26 + 0x0000] %asi
	.word 0xd6b62000  ! 1878: STHA_I	stha	%r11, [%r24 + 0x0000] %asi
	mov	0x70, %r25
	.word 0xd6ccc400  ! 1880: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	.word 0xdad4c400  ! 1881: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xd2aee000  ! 1882: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	.word 0xd09e09e0  ! 1883: LDDA_R	ldda	[%r24, %r0] 0x4f, %r8
	mov	0x18, %r16
	.word 0xd2cf0e80  ! 1885: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r9
	.word 0xd0b70e40  ! 1886: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	.word 0xd6a6e000  ! 1887: STWA_I	stwa	%r11, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 1888: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_3_18:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x88, %g2
	or	%g4, 0x89, %g4
	or	%g6, 0xe0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd887ce40  ! 1890: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r12
	mov	0x68, %r26
	.word 0xdebf0e40  ! 1892: STDA_R	stda	%r15, [%r28 + %r0] 0x72
	.word 0x87802020  ! 1893: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf78e40  ! 1894: STXA_R	stxa	%r13, [%r30 + %r0] 0x72
	.word 0xdef4a000  ! 1895: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	mov	0x8, %r25
	.word 0xd8dc4400  ! 1897: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0x87802020  ! 1898: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccf6000  ! 1899: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcc7a000  ! 1900: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcafe000  ! 1901: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xd2a40400  ! 1902: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	mov	0x28, %r18
	.word 0xd4afe000  ! 1904: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	mov	0x58, %r19
	.word 0xdcd609e0  ! 1906: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r14
	.word 0x8780204f  ! 1907: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b62000  ! 1908: STHA_I	stha	%r12, [%r24 + 0x0000] %asi
	.word 0xd8bee000  ! 1909: STDA_I	stda	%r12, [%r27 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0bfce60  ! 1911: STDA_R	stda	%r8, [%r31 + %r0] 0x73
	mov	0x3e8, %r21
	mov	0x7d8, %r21
	.word 0xd2bee000  ! 1914: STDA_I	stda	%r9, [%r27 + 0x0000] %asi
	.word 0xd2962000  ! 1915: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r9
	.word 0xd2aea000  ! 1916: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0xd6b74e40  ! 1917: STHA_R	stha	%r11, [%r29 + %r0] 0x72
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd4d6e000  ! 1919: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r10
	.word 0xd49ea000  ! 1920: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	mov	0x10, %r16
	.word 0x8780204f  ! 1922: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c0, %r22
	.word 0xd4972000  ! 1924: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0xd4f7a000  ! 1925: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	wr_tick_cmpr_3_19:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd8, %g2
	or	%g4, 0xda, %g4
	or	%g6, 0xef, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802025  ! 1927: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0af0e80  ! 1928: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	.word 0x87802020  ! 1929: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1930: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1931: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r26
	mov	0x0, %r24
	mov	0x58, %r19
	.word 0xdea6c9e0  ! 1935: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	.word 0xdcb74e40  ! 1936: STHA_R	stha	%r14, [%r29 + %r0] 0x72
	.word 0x87802020  ! 1937: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r21
	mov	0x7c0, %r21
	.word 0xd8dfa000  ! 1940: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd0c689e0  ! 1941: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r8
	.word 0xdcb504a0  ! 1942: STHA_R	stha	%r14, [%r20 + %r0] 0x25
	.word 0xdc8fa000  ! 1943: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0x87802073  ! 1944: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f0, %r22
	.word 0xd2a70e80  ! 1946: STWA_R	stwa	%r9, [%r28 + %r0] 0x74
	.word 0xd4c5e000  ! 1947: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r10
	mov	0x7e0, %r21
	.word 0xd6be09e0  ! 1949: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	.word 0xda85e000  ! 1950: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	.word 0xd4a544a0  ! 1951: STWA_R	stwa	%r10, [%r21 + %r0] 0x25
	.word 0x87802025  ! 1952: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbc0400  ! 1953: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 1954: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c8, %r22
	.word 0x87802072  ! 1956: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6bc8400  ! 1957: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	mov	0x50, %r24
	.word 0xd6ddc4a0  ! 1959: LDXA_R	ldxa	[%r23, %r0] 0x25, %r11
	.word 0x87802020  ! 1960: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab7ce40  ! 1961: STHA_R	stha	%r13, [%r31 + %r0] 0x72
	.word 0xd8ac0400  ! 1962: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xd4a76000  ! 1963: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xdcbe09e0  ! 1964: STDA_R	stda	%r14, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 1965: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca74e60  ! 1966: STWA_R	stwa	%r14, [%r29 + %r0] 0x73
	.word 0xdabf4e60  ! 1967: STDA_R	stda	%r13, [%r29 + %r0] 0x73
	.word 0xdc8cc400  ! 1968: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	.word 0xdabf2000  ! 1969: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	mov	0x18, %r17
	.word 0xda8f6000  ! 1971: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	mov	0x3e0, %r20
	.word 0xd0f40400  ! 1973: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	mov	0x78, %r24
	mov	0x48, %r24
	.word 0xdaafa000  ! 1976: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xda87e000  ! 1977: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0xda8f6000  ! 1978: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xd2cc0400  ! 1979: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r9
	.word 0x87802074  ! 1980: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c0, %r20
	.word 0xd88c8400  ! 1982: LDUBA_R	lduba	[%r18, %r0] 0x20, %r12
	.word 0x87802020  ! 1983: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r23
	mov	0x18, %r26
	mov	0x7d0, %r23
	mov	0x7d0, %r23
	mov	0x0, %r18
	.word 0xd0b584a0  ! 1989: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	.word 0xdad76000  ! 1990: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0xda970e80  ! 1991: LDUHA_R	lduha	[%r28, %r0] 0x74, %r13
	.word 0xdeac4400  ! 1992: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0xd2f4c400  ! 1993: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xdaa74e40  ! 1994: STWA_R	stwa	%r13, [%r29 + %r0] 0x72
	.word 0x87802072  ! 1995: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 1996: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca40400  ! 1997: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	mov	0x7c8, %r20
	mov	0x70, %r26
	mov	0x78, %r17
	mov	0x3d0, %r21
	.word 0xd0cf4e80  ! 2002: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r8
	.word 0xd8f7a000  ! 2003: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8d7e000  ! 2004: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0xd8876000  ! 2005: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8f7a000  ! 2006: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8b7ce60  ! 2007: STHA_R	stha	%r12, [%r31 + %r0] 0x73
	mov	0x48, %r16
	.word 0xd29f8e40  ! 2009: LDDA_R	ldda	[%r30, %r0] 0x72, %r9
	.word 0xdecfa000  ! 2010: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xda974e80  ! 2011: LDUHA_R	lduha	[%r29, %r0] 0x74, %r13
	.word 0xdcbfce80  ! 2012: STDA_R	stda	%r14, [%r31 + %r0] 0x74
	ta	T_CHANGE_PRIV	! macro
	.word 0xdac4c400  ! 2014: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r13
	.word 0xdcf76000  ! 2015: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xdcb7a000  ! 2017: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xdc9fe000  ! 2018: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	mov	0x48, %r18
	.word 0xdc9f2000  ! 2020: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xd6a74e60  ! 2021: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	.word 0xd6f7ce40  ! 2022: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	.word 0xd8d78e80  ! 2023: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r12
	.word 0xd6d76000  ! 2024: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	.word 0xd2d689e0  ! 2025: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r9
	.word 0x8780204f  ! 2026: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeb5c4a0  ! 2027: STHA_R	stha	%r15, [%r23 + %r0] 0x25
	.word 0xd08d84a0  ! 2028: LDUBA_R	lduba	[%r22, %r0] 0x25, %r8
	.word 0xdacf2000  ! 2029: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xda872000  ! 2030: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0xdad504a0  ! 2031: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r13
	.word 0x87802074  ! 2032: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2033: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd88d04a0  ! 2034: LDUBA_R	lduba	[%r20, %r0] 0x25, %r12
	.word 0xd0f46000  ! 2035: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 2036: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0aee000  ! 2037: STBA_I	stba	%r8, [%r27 + 0x0000] %asi
	.word 0xd0aea000  ! 2038: STBA_I	stba	%r8, [%r26 + 0x0000] %asi
	.word 0xd096e000  ! 2039: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r8
	mov	0x3e8, %r21
	.word 0xd0962000  ! 2041: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r8
	.word 0x87802074  ! 2042: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd08e6000  ! 2043: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r8
	.word 0xd0862000  ! 2044: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r8
	mov	0x18, %r19
	.word 0x87802074  ! 2046: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd09fce60  ! 2047: LDDA_R	ldda	[%r31, %r0] 0x73, %r8
	.word 0xdc9e89e0  ! 2048: LDDA_R	ldda	[%r26, %r0] 0x4f, %r14
	mov	0x38, %r27
	.word 0xdaaf0e60  ! 2050: STBA_R	stba	%r13, [%r28 + %r0] 0x73
	mov	0x30, %r26
	.word 0xd4a649e0  ! 2052: STWA_R	stwa	%r10, [%r25 + %r0] 0x4f
	.word 0x87802072  ! 2053: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcdd04a0  ! 2054: LDXA_R	ldxa	[%r20, %r0] 0x25, %r14
	.word 0xdcbf4e60  ! 2055: STDA_R	stda	%r14, [%r29 + %r0] 0x73
	.word 0xdadc2000  ! 2056: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r13
	.word 0xd0d74e60  ! 2057: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r8
	.word 0xd4c649e0  ! 2058: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r10
	.word 0xd6a48400  ! 2059: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0x87802074  ! 2060: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a72000  ! 2061: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	mov	0x38, %r24
	mov	0x7f8, %r23
	.word 0xd8d74e40  ! 2064: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r12
	mov	0x7f0, %r22
	.word 0xd2bfa000  ! 2066: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 2067: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2d4e000  ! 2068: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0xd2bc2000  ! 2069: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xd0f74e60  ! 2070: STXA_R	stxa	%r8, [%r29 + %r0] 0x73
	.word 0x87802074  ! 2071: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacf2000  ! 2072: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xd8a6c9e0  ! 2073: STWA_R	stwa	%r12, [%r27 + %r0] 0x4f
	.word 0xd8bfa000  ! 2074: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd8cf2000  ! 2075: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0xd0bec9e0  ! 2076: STDA_R	stda	%r8, [%r27 + %r0] 0x4f
	.word 0xdea76000  ! 2077: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	mov	0x3f8, %r22
	mov	0x70, %r27
	.word 0xd4a70e80  ! 2080: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	.word 0xd2a76000  ! 2081: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	mov	0x18, %r16
	.word 0xd2dfe000  ! 2083: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0xdea4c400  ! 2084: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	mov	0x8, %r26
	.word 0xd88fe000  ! 2086: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	mov	0x10, %r25
	.word 0xdaa649e0  ! 2088: STWA_R	stwa	%r13, [%r25 + %r0] 0x4f
	.word 0xdc976000  ! 2089: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	mov	0x3d8, %r22
	.word 0xdc876000  ! 2091: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0xdccf6000  ! 2092: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2093: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b4c400  ! 2094: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0x87802072  ! 2095: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r16
	.word 0xded72000  ! 2097: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xd085c4a0  ! 2098: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r8
	.word 0xdcbfa000  ! 2099: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	mov	0x60, %r27
	.word 0x87802020  ! 2101: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r19
	.word 0xdca62000  ! 2103: STWA_I	stwa	%r14, [%r24 + 0x0000] %asi
	.word 0xdcb6e000  ! 2104: STHA_I	stha	%r14, [%r27 + 0x0000] %asi
	.word 0xde9e09e0  ! 2105: LDDA_R	ldda	[%r24, %r0] 0x4f, %r15
	.word 0xd487ce80  ! 2106: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r10
	mov	0x58, %r19
	mov	0x60, %r25
	.word 0xdebee000  ! 2109: STDA_I	stda	%r15, [%r27 + 0x0000] %asi
	.word 0xdec6e000  ! 2110: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r15
	.word 0xd2ae49e0  ! 2111: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	.word 0xd0a4c400  ! 2112: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xd4ce2000  ! 2113: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r10
	.word 0xd4a6a000  ! 2114: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	.word 0xdabf4e40  ! 2115: STDA_R	stda	%r13, [%r29 + %r0] 0x72
	.word 0xdef649e0  ! 2116: STXA_R	stxa	%r15, [%r25 + %r0] 0x4f
	.word 0xd4a78e40  ! 2117: STWA_R	stwa	%r10, [%r30 + %r0] 0x72
	.word 0xdaa5c4a0  ! 2118: STWA_R	stwa	%r13, [%r23 + %r0] 0x25
	mov	0x8, %r25
	.word 0xd6b40400  ! 2120: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xd2f6e000  ! 2121: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	mov	0x7c0, %r22
	mov	0x18, %r17
	mov	0x68, %r19
	.word 0xd2f6e000  ! 2125: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	.word 0xd29ee000  ! 2126: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r9
	.word 0xd8dfce40  ! 2127: LDXA_R	ldxa	[%r31, %r0] 0x72, %r12
	.word 0x87802073  ! 2128: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r17
	mov	0x18, %r25
	.word 0xdcf5c4a0  ! 2131: STXA_R	stxa	%r14, [%r23 + %r0] 0x25
	.word 0xdc9d84a0  ! 2132: LDDA_R	ldda	[%r22, %r0] 0x25, %r14
	.word 0xd88ec9e0  ! 2133: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r12
	mov	0x3d0, %r21
	.word 0xdef52000  ! 2135: STXA_I	stxa	%r15, [%r20 + 0x0000] %asi
	.word 0xd0f7ce60  ! 2136: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	.word 0xdcad2000  ! 2137: STBA_I	stba	%r14, [%r20 + 0x0000] %asi
	.word 0x87802072  ! 2138: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc876000  ! 2139: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0x87802025  ! 2140: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r17
	.word 0xdcbf2000  ! 2142: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xd2d70e60  ! 2143: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r9
	.word 0xda976000  ! 2144: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	.word 0xdc874e40  ! 2145: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r14
	.word 0x87802025  ! 2146: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8c74e40  ! 2147: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r12
	mov	0x68, %r16
	.word 0xd68d6000  ! 2149: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r11
	.word 0xdadc0400  ! 2150: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	.word 0xdecc8400  ! 2151: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	.word 0xd2a52000  ! 2152: STWA_I	stwa	%r9, [%r20 + 0x0000] %asi
	mov	0x3d0, %r21
	.word 0xd29d2000  ! 2154: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r9
	.word 0xd8df8e60  ! 2155: LDXA_R	ldxa	[%r30, %r0] 0x73, %r12
	.word 0xd6c74e60  ! 2156: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r11
	.word 0xd8b56000  ! 2157: STHA_I	stha	%r12, [%r21 + 0x0000] %asi
	.word 0xd8dd2000  ! 2158: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r12
	mov	0x18, %r16
	.word 0xd0dfce40  ! 2160: LDXA_R	ldxa	[%r31, %r0] 0x72, %r8
	mov	0x58, %r24
	.word 0xd6f584a0  ! 2162: STXA_R	stxa	%r11, [%r22 + %r0] 0x25
	.word 0xd4dd6000  ! 2163: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r10
	mov	0x20, %r25
	.word 0x8780204f  ! 2165: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4be6000  ! 2166: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	mov	0x78, %r17
	.word 0x87802073  ! 2168: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c0, %r23
	mov	0x7f8, %r20
	mov	0x10, %r16
	mov	0x68, %r17
	mov	0x3c0, %r21
	.word 0x87802025  ! 2174: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cc6000  ! 2175: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	.word 0xd4bc6000  ! 2176: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xd4bce000  ! 2177: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0xd4dce000  ! 2178: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	.word 0xd4f42000  ! 2179: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xdab40400  ! 2180: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xd2b48400  ! 2181: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	mov	0x8, %r19
	mov	0x3d0, %r23
	.word 0xd6ac2000  ! 2184: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	.word 0xd2d74e40  ! 2185: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r9
	.word 0xde94c400  ! 2186: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	.word 0x87802020  ! 2187: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r26
	.word 0xdaa7ce80  ! 2189: STWA_R	stwa	%r13, [%r31 + %r0] 0x74
	.word 0xdcbf4e40  ! 2190: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	.word 0xd6bf4e80  ! 2191: STDA_R	stda	%r11, [%r29 + %r0] 0x74
	.word 0xde9504a0  ! 2192: LDUHA_R	lduha	[%r20, %r0] 0x25, %r15
	.word 0xd6f48400  ! 2193: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xd2cca000  ! 2194: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2f4e000  ! 2195: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2f4e000  ! 2196: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd29ce000  ! 2197: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	mov	0x18, %r26
	mov	0x3d8, %r23
	.word 0xd2a4c400  ! 2200: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0xd6be09e0  ! 2201: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	.word 0xd08ca000  ! 2202: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	mov	0x28, %r25
	mov	0x58, %r26
	.word 0xd0ac2000  ! 2205: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xdab74e60  ! 2206: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	.word 0xd2942000  ! 2207: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2b46000  ! 2208: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0xde96c9e0  ! 2209: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r15
	.word 0xd6a46000  ! 2210: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0xd2dc8400  ! 2211: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0xd4b46000  ! 2212: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	mov	0x30, %r24
	.word 0xd8b70e80  ! 2214: STHA_R	stha	%r12, [%r28 + %r0] 0x74
	.word 0xd8a46000  ! 2215: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	mov	0x7f8, %r20
	.word 0xda8dc4a0  ! 2217: LDUBA_R	lduba	[%r23, %r0] 0x25, %r13
	.word 0x87802020  ! 2218: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2219: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4bf2000  ! 2220: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	mov	0x70, %r26
	.word 0x8780204f  ! 2222: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r19
	.word 0xd4f7a000  ! 2224: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd0f70e80  ! 2225: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0xd4a7ce40  ! 2226: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	.word 0xdea544a0  ! 2227: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	.word 0xd29fa000  ! 2228: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd28fa000  ! 2229: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	mov	0x58, %r18
	.word 0x87802072  ! 2231: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 2232: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28f8e60  ! 2233: LDUBA_R	lduba	[%r30, %r0] 0x73, %r9
	.word 0xdabf4e40  ! 2234: STDA_R	stda	%r13, [%r29 + %r0] 0x72
	mov	0x60, %r19
	.word 0x8780204f  ! 2236: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 2237: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2238: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cf2000  ! 2239: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	mov	0x3f0, %r23
	.word 0x87802020  ! 2241: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef78e80  ! 2242: STXA_R	stxa	%r15, [%r30 + %r0] 0x74
	.word 0x87802072  ! 2243: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2cfce60  ! 2244: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r9
	.word 0xd0bde000  ! 2245: STDA_I	stda	%r8, [%r23 + 0x0000] %asi
	mov	0x78, %r19
	.word 0xda8cc400  ! 2247: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	.word 0xdecde000  ! 2248: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r15
	mov	0x8, %r17
	mov	0x10, %r16
	mov	0x20, %r25
	.word 0xdadc8400  ! 2252: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	mov	0x7d0, %r23
	.word 0xdeb70e40  ! 2254: STHA_R	stha	%r15, [%r28 + %r0] 0x72
	mov	0x8, %r18
	.word 0xd8bde000  ! 2256: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0xd8ad2000  ! 2257: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 2258: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r27
	mov	0x30, %r19
	.word 0xd8af0e40  ! 2261: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	.word 0x87802073  ! 2262: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8bfce60  ! 2263: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	.word 0xdaaca000  ! 2264: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0xdac4a000  ! 2265: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	.word 0xdaf5c4a0  ! 2266: STXA_R	stxa	%r13, [%r23 + %r0] 0x25
	.word 0xdab70e60  ! 2267: STHA_R	stha	%r13, [%r28 + %r0] 0x73
	.word 0xdad40400  ! 2268: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	.word 0xd4f7ce60  ! 2269: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	mov	0x60, %r25
	.word 0xd8ace000  ! 2271: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0xd8a4e000  ! 2272: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xd89c6000  ! 2273: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r12
	mov	0x70, %r18
	.word 0xd894a000  ! 2275: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r12
	.word 0xdaf44400  ! 2276: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0xd2b4a000  ! 2277: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0xd29e09e0  ! 2278: LDDA_R	ldda	[%r24, %r0] 0x4f, %r9
	.word 0x87802072  ! 2279: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde9d04a0  ! 2280: LDDA_R	ldda	[%r20, %r0] 0x25, %r15
	.word 0xd6a72000  ! 2281: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd8ce89e0  ! 2282: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r12
	.word 0xdc8f6000  ! 2283: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2284: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9c2000  ! 2285: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r14
	.word 0xdc94e000  ! 2286: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	.word 0xdc94a000  ! 2287: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xdcdca000  ! 2288: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2289: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a504a0  ! 2290: STWA_R	stwa	%r9, [%r20 + %r0] 0x25
	.word 0x87802020  ! 2291: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccca000  ! 2292: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	.word 0xdc942000  ! 2293: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	.word 0xd0d4c400  ! 2294: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	mov	0x60, %r24
	.word 0xde946000  ! 2296: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r15
	.word 0xde9ca000  ! 2297: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	.word 0xdcaf0e80  ! 2298: STBA_R	stba	%r14, [%r28 + %r0] 0x74
	mov	0x0, %r18
	.word 0xd29c2000  ! 2300: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	.word 0xd2ace000  ! 2301: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 2302: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r24
	.word 0x87802025  ! 2304: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4840400  ! 2305: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	mov	0x38, %r17
	mov	0x7f8, %r20
	.word 0xd4b78e60  ! 2308: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	mov	0x38, %r18
	.word 0xd4f504a0  ! 2310: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0xd4d609e0  ! 2311: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r10
	mov	0x48, %r27
	.word 0xdca48400  ! 2313: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xd2b7ce80  ! 2314: STHA_R	stha	%r9, [%r31 + %r0] 0x74
	.word 0xd8a4e000  ! 2315: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xd8ace000  ! 2316: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	mov	0x0, %r24
	.word 0xd8dc6000  ! 2318: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	.word 0xd8a42000  ! 2319: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8f4a000  ! 2320: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 2321: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e8, %r23
	wr_tick_cmpr_3_20:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf0, %g2
	or	%g4, 0xd0, %g4
	or	%g6, 0xa2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8946000  ! 2324: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	.word 0xdeae09e0  ! 2325: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	.word 0xd6ac6000  ! 2326: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xd6cce000  ! 2327: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r11
	.word 0xdecfce40  ! 2328: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r15
	.word 0xd2874e40  ! 2329: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r9
	mov	0x48, %r25
	.word 0xd8b689e0  ! 2331: STHA_R	stha	%r12, [%r26 + %r0] 0x4f
	.word 0xd084a000  ! 2332: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	.word 0x87802074  ! 2333: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a649e0  ! 2334: STWA_R	stwa	%r10, [%r25 + %r0] 0x4f
	.word 0xd8d5a000  ! 2335: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r12
	.word 0xd8a5e000  ! 2336: STWA_I	stwa	%r12, [%r23 + 0x0000] %asi
	.word 0xd8bde000  ! 2337: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0xd8956000  ! 2338: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r12
	.word 0xd8a56000  ! 2339: STWA_I	stwa	%r12, [%r21 + 0x0000] %asi
	.word 0xd8a56000  ! 2340: STWA_I	stwa	%r12, [%r21 + 0x0000] %asi
	.word 0x87802072  ! 2341: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7e8, %r21
	.word 0xdabe49e0  ! 2343: STDA_R	stda	%r13, [%r25 + %r0] 0x4f
	.word 0xd6dea000  ! 2344: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r11
	.word 0xd6a62000  ! 2345: STWA_I	stwa	%r11, [%r24 + 0x0000] %asi
	mov	0x3d8, %r20
	mov	0x40, %r16
	.word 0xdcb649e0  ! 2348: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	.word 0xd0be49e0  ! 2349: STDA_R	stda	%r8, [%r25 + %r0] 0x4f
	mov	0x28, %r16
	.word 0xd4f6e000  ! 2351: STXA_I	stxa	%r10, [%r27 + 0x0000] %asi
	.word 0xdca7ce40  ! 2352: STWA_R	stwa	%r14, [%r31 + %r0] 0x72
	.word 0xd8974e40  ! 2353: LDUHA_R	lduha	[%r29, %r0] 0x72, %r12
	.word 0xde866000  ! 2354: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 2355: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea4a000  ! 2356: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xdeb504a0  ! 2357: STHA_R	stha	%r15, [%r20 + %r0] 0x25
	.word 0x87802025  ! 2358: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 2359: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4dce000  ! 2360: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	.word 0xd48ca000  ! 2361: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r10
	.word 0xd4ace000  ! 2362: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 2363: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r25
	mov	0x28, %r26
	mov	0x70, %r18
	.word 0xd0c48400  ! 2367: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r8
	.word 0xd887e000  ! 2368: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0xd897ce80  ! 2369: LDUHA_R	lduha	[%r31, %r0] 0x74, %r12
	.word 0xdef7e000  ! 2370: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xd0b78e60  ! 2371: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	mov	0x7e8, %r21
	.word 0xd8ac4400  ! 2373: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0x87802020  ! 2374: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r16
	.word 0xd2f44400  ! 2376: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	.word 0xd2d72000  ! 2377: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xd2bf6000  ! 2378: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd2f7e000  ! 2379: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd2b7a000  ! 2380: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd2b76000  ! 2381: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xd29fa000  ! 2383: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd8dc4400  ! 2384: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0xd09f8e60  ! 2385: LDDA_R	ldda	[%r30, %r0] 0x73, %r8
	mov	0x10, %r18
	mov	0x3f0, %r22
	.word 0xdccd84a0  ! 2388: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r14
	.word 0x87802072  ! 2389: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdad5e000  ! 2390: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r13
	.word 0xd4ce89e0  ! 2391: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r10
	.word 0xd0dda000  ! 2392: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r8
	.word 0xd0b5a000  ! 2393: STHA_I	stha	%r8, [%r22 + 0x0000] %asi
	.word 0xd0856000  ! 2394: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r8
	.word 0xd2f78e80  ! 2395: STXA_R	stxa	%r9, [%r30 + %r0] 0x74
	mov	0x18, %r19
	.word 0xd6f5a000  ! 2397: STXA_I	stxa	%r11, [%r22 + 0x0000] %asi
	.word 0x87802073  ! 2398: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd68f2000  ! 2399: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xd6df2000  ! 2400: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6afe000  ! 2401: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2402: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f72000  ! 2403: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6a7ce40  ! 2404: STWA_R	stwa	%r11, [%r31 + %r0] 0x72
	.word 0xdcd70e40  ! 2405: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r14
	mov	0x18, %r18
	.word 0xdcd40400  ! 2407: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	mov	0x3f8, %r21
	mov	0x3c0, %r22
	.word 0xd2df4e80  ! 2410: LDXA_R	ldxa	[%r29, %r0] 0x74, %r9
	.word 0x87802020  ! 2411: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b4e000  ! 2412: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0xd2b46000  ! 2413: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	mov	0x10, %r17
	.word 0x87802020  ! 2415: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cce000  ! 2416: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	mov	0x78, %r16
	mov	0x48, %r17
	.word 0xd294e000  ! 2419: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	.word 0xdac78e40  ! 2420: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r13
	.word 0xd4bd44a0  ! 2421: STDA_R	stda	%r10, [%r21 + %r0] 0x25
	.word 0xd4a4a000  ! 2422: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	mov	0x3d0, %r23
	.word 0x87802020  ! 2424: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r17
	.word 0xd897ce40  ! 2426: LDUHA_R	lduha	[%r31, %r0] 0x72, %r12
	.word 0xdccf0e60  ! 2427: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r14
	wr_tick_cmpr_3_21:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x8d, %g2
	or	%g4, 0xe5, %g4
	or	%g6, 0xdf, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd28ec9e0  ! 2429: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r9
	.word 0xd6f5a000  ! 2430: STXA_I	stxa	%r11, [%r22 + 0x0000] %asi
	.word 0xd2b40400  ! 2431: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0xd6b78e40  ! 2432: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	.word 0xdeb52000  ! 2433: STHA_I	stha	%r15, [%r20 + 0x0000] %asi
	.word 0xded5e000  ! 2434: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r15
	.word 0xdca78e40  ! 2435: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	.word 0xdccd2000  ! 2436: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r14
	.word 0xdcb5a000  ! 2437: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0xdcc52000  ! 2438: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2439: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef48400  ! 2440: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xd6ae6000  ! 2441: STBA_I	stba	%r11, [%r25 + 0x0000] %asi
	.word 0xd4f40400  ! 2442: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xd0962000  ! 2443: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r8
	.word 0xdabf0e40  ! 2444: STDA_R	stda	%r13, [%r28 + %r0] 0x72
	.word 0xd486a000  ! 2445: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r10
	.word 0xd4ce6000  ! 2446: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r10
	mov	0x38, %r19
	.word 0xda8f8e40  ! 2448: LDUBA_R	lduba	[%r30, %r0] 0x72, %r13
	.word 0xd486e000  ! 2449: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 2450: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdedd04a0  ! 2451: LDXA_R	ldxa	[%r20, %r0] 0x25, %r15
	.word 0xd6f609e0  ! 2452: STXA_R	stxa	%r11, [%r24 + %r0] 0x4f
	.word 0xd0c609e0  ! 2453: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r8
	mov	0x28, %r26
	.word 0xdc9f8e80  ! 2455: LDDA_R	ldda	[%r30, %r0] 0x74, %r14
	.word 0xd0aee000  ! 2456: STBA_I	stba	%r8, [%r27 + 0x0000] %asi
	.word 0xd0c6e000  ! 2457: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r8
	mov	0x50, %r16
	mov	0x48, %r25
	mov	0x18, %r27
	.word 0xd6cc4400  ! 2461: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	.word 0xd8af0e40  ! 2462: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	.word 0x87802072  ! 2463: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef7a000  ! 2464: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	mov	0x10, %r26
	.word 0x8780204f  ! 2466: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeb7ce60  ! 2467: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	.word 0xdaf74e80  ! 2468: STXA_R	stxa	%r13, [%r29 + %r0] 0x74
	mov	0x3c8, %r21
	.word 0xd28d84a0  ! 2470: LDUBA_R	lduba	[%r22, %r0] 0x25, %r9
	.word 0x87802025  ! 2471: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd28d04a0  ! 2472: LDUBA_R	lduba	[%r20, %r0] 0x25, %r9
	.word 0xd0862000  ! 2473: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r8
	.word 0xdeb4c400  ! 2474: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xdcb6e000  ! 2475: STHA_I	stha	%r14, [%r27 + 0x0000] %asi
	.word 0xdcae6000  ! 2476: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	.word 0xdcc544a0  ! 2477: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r14
	.word 0xd0de2000  ! 2478: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r8
	mov	0x3e8, %r20
	.word 0x87802020  ! 2480: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0df2000  ! 2481: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0876000  ! 2482: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	mov	0x58, %r24
	mov	0x3c0, %r22
	.word 0x87802020  ! 2485: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4aec9e0  ! 2486: STBA_R	stba	%r10, [%r27 + %r0] 0x4f
	.word 0xd09fce40  ! 2487: LDDA_R	ldda	[%r31, %r0] 0x72, %r8
	.word 0xdaf7a000  ! 2488: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdebcc400  ! 2489: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	.word 0xd8cec9e0  ! 2490: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r12
	mov	0x78, %r16
	.word 0xd2afce40  ! 2492: STBA_R	stba	%r9, [%r31 + %r0] 0x72
	.word 0xd8afce40  ! 2493: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	.word 0xdab40400  ! 2494: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xd4b44400  ! 2495: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	mov	0x7d8, %r23
	.word 0xdea7a000  ! 2497: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 2498: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2499: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2500: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r27
	.word 0x87802025  ! 2502: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r17
	.word 0xd0b544a0  ! 2504: STHA_R	stha	%r8, [%r21 + %r0] 0x25
	.word 0xda97a000  ! 2505: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xdad7e000  ! 2506: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xde9c4400  ! 2507: LDDA_R	ldda	[%r17, %r0] 0x20, %r15
	.word 0xdcbe49e0  ! 2508: STDA_R	stda	%r14, [%r25 + %r0] 0x4f
	mov	0x3f0, %r23
	.word 0xdeb76000  ! 2510: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xd4af4e80  ! 2511: STBA_R	stba	%r10, [%r29 + %r0] 0x74
	.word 0x87802074  ! 2512: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8dc2000  ! 2513: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0x87802025  ! 2514: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd897a000  ! 2515: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2516: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r18
	.word 0xd8bd6000  ! 2518: STDA_I	stda	%r12, [%r21 + 0x0000] %asi
	.word 0xd8c5e000  ! 2519: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r12
	mov	0x58, %r24
	.word 0xd8a5a000  ! 2521: STWA_I	stwa	%r12, [%r22 + 0x0000] %asi
	.word 0x87802073  ! 2522: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e0, %r20
	mov	0x48, %r26
	mov	0x70, %r25
	.word 0x87802073  ! 2526: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef584a0  ! 2527: STXA_R	stxa	%r15, [%r22 + %r0] 0x25
	.word 0xd6bc0400  ! 2528: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xd08ee000  ! 2529: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r8
	.word 0xd0ccc400  ! 2530: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	.word 0xd2d78e80  ! 2531: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r9
	.word 0xd4d48400  ! 2532: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	mov	0x78, %r27
	.word 0xd8d6a000  ! 2534: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r12
	mov	0x8, %r16
	.word 0x87802073  ! 2536: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8a5e000  ! 2537: STWA_I	stwa	%r12, [%r23 + 0x0000] %asi
	.word 0xdcdf8e80  ! 2538: LDXA_R	ldxa	[%r30, %r0] 0x74, %r14
	.word 0x87802073  ! 2539: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdec40400  ! 2540: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0x87802020  ! 2541: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0d78e60  ! 2542: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r8
	.word 0xd6d7ce60  ! 2543: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r11
	.word 0xd2cd44a0  ! 2544: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r9
	.word 0xd0b78e80  ! 2545: STHA_R	stha	%r8, [%r30 + %r0] 0x74
	.word 0xdab48400  ! 2546: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0x87802072  ! 2547: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_HPRIV	! macro
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2ce6000  ! 2550: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r9
	.word 0xd2ae6000  ! 2551: STBA_I	stba	%r9, [%r25 + 0x0000] %asi
	.word 0xdea6c9e0  ! 2552: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	.word 0xd8862000  ! 2553: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r12
	mov	0x18, %r18
	mov	0x3e0, %r23
	mov	0x50, %r17
	.word 0xdcd40400  ! 2557: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	.word 0xd2b40400  ! 2558: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0xd8a62000  ! 2559: STWA_I	stwa	%r12, [%r24 + 0x0000] %asi
	.word 0xd8dea000  ! 2560: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r12
	.word 0xd6bfce60  ! 2561: STDA_R	stda	%r11, [%r31 + %r0] 0x73
	mov	0x3d8, %r22
	.word 0xd886a000  ! 2563: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r12
	.word 0xd89e2000  ! 2564: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r12
	.word 0xd8bee000  ! 2565: STDA_I	stda	%r12, [%r27 + 0x0000] %asi
	.word 0xd4b544a0  ! 2566: STHA_R	stha	%r10, [%r21 + %r0] 0x25
	.word 0xd48ea000  ! 2567: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 2568: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r26
	.word 0xd8cfce60  ! 2570: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r12
	.word 0xdaf584a0  ! 2571: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	ta	T_CHANGE_HPRIV	! macro
	.word 0xda97a000  ! 2573: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xd0b78e40  ! 2574: STHA_R	stha	%r8, [%r30 + %r0] 0x72
	.word 0xd2a48400  ! 2575: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0xd8b7ce80  ! 2576: STHA_R	stha	%r12, [%r31 + %r0] 0x74
	.word 0xd0d7a000  ! 2577: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0xda974e40  ! 2578: LDUHA_R	lduha	[%r29, %r0] 0x72, %r13
	mov	0x3d0, %r22
	.word 0x87802073  ! 2580: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 2581: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 2582: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b66000  ! 2583: STHA_I	stha	%r10, [%r25 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0xd09584a0  ! 2585: LDUHA_R	lduha	[%r22, %r0] 0x25, %r8
	mov	0x60, %r18
	.word 0xdcb78e40  ! 2587: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0x87802073  ! 2588: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0ac6000  ! 2589: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 2590: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2591: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb6c9e0  ! 2592: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	.word 0xdab72000  ! 2593: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdca78e40  ! 2594: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	.word 0xd8d72000  ! 2595: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	mov	0x0, %r19
	.word 0xd8a7a000  ! 2597: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8c584a0  ! 2598: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r12
	mov	0x3c8, %r23
	.word 0xdef7e000  ! 2600: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xd6c5c4a0  ! 2601: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r11
	.word 0xd4c7e000  ! 2602: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	mov	0x50, %r17
	mov	0x7e0, %r21
	.word 0xd4b7e000  ! 2605: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	mov	0x3c0, %r23
	.word 0x87802072  ! 2607: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4842000  ! 2608: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 2609: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8dcc400  ! 2610: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	mov	0x60, %r17
	.word 0xdab5a000  ! 2612: STHA_I	stha	%r13, [%r22 + 0x0000] %asi
	.word 0xdadd6000  ! 2613: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r13
	mov	0x68, %r17
	.word 0xdad5e000  ! 2615: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2616: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2617: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6c689e0  ! 2618: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r11
	.word 0xd8d46000  ! 2619: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	.word 0xd8ac2000  ! 2620: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0xd0a7ce40  ! 2621: STWA_R	stwa	%r8, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 2622: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 2623: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdea7ce80  ! 2624: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	mov	0x3d0, %r21
	mov	0x48, %r17
	.word 0x87802025  ! 2627: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r17
	.word 0xd8b42000  ! 2629: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	mov	0x3d8, %r22
	.word 0xd8bc2000  ! 2631: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd8bca000  ! 2632: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd8b46000  ! 2633: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 2634: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88f2000  ! 2635: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0xd8f76000  ! 2636: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	mov	0x40, %r16
	mov	0x7e0, %r22
	mov	0x40, %r27
	.word 0xd4f4c400  ! 2640: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd0d40400  ! 2641: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	.word 0xd0a76000  ! 2642: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0f7a000  ! 2643: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	mov	0x50, %r24
	.word 0xd6f70e80  ! 2645: STXA_R	stxa	%r11, [%r28 + %r0] 0x74
	mov	0x50, %r25
	.word 0xd8d504a0  ! 2647: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r12
	.word 0x87802020  ! 2648: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r17
	.word 0x87802025  ! 2650: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e0, %r21
	mov	0x18, %r26
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802072  ! 2654: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r27
	.word 0xd8cf0e60  ! 2656: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r12
	.word 0xd6bd6000  ! 2657: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0x87802074  ! 2658: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef7ce40  ! 2659: STXA_R	stxa	%r15, [%r31 + %r0] 0x72
	.word 0xd2be2000  ! 2660: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	mov	0x70, %r17
	.word 0x87802020  ! 2662: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc8f8e40  ! 2663: LDUBA_R	lduba	[%r30, %r0] 0x72, %r14
	.word 0xdab72000  ! 2664: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdacfa000  ! 2665: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	mov	0x3c8, %r20
	.word 0xd49689e0  ! 2667: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r10
	.word 0xd6bc0400  ! 2668: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xd0872000  ! 2669: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xd6944400  ! 2670: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	mov	0x48, %r17
	.word 0x87802020  ! 2672: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r21
	.word 0xd2d7e000  ! 2674: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	mov	0x3c0, %r21
	mov	0x7e8, %r21
	.word 0x87802020  ! 2677: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2f46000  ! 2679: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2bc2000  ! 2680: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xdaf70e80  ! 2681: STXA_R	stxa	%r13, [%r28 + %r0] 0x74
	.word 0xd0b5c4a0  ! 2682: STHA_R	stha	%r8, [%r23 + %r0] 0x25
	.word 0xd6d48400  ! 2683: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0x87802074  ! 2684: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b74e40  ! 2685: STHA_R	stha	%r11, [%r29 + %r0] 0x72
	.word 0xd08f2000  ! 2686: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	.word 0xdcb6c9e0  ! 2687: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	.word 0xd0a7ce80  ! 2688: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	mov	0x30, %r27
	.word 0xdcbf2000  ! 2690: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 2691: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc9c2000  ! 2692: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r14
	.word 0xdcbe09e0  ! 2693: STDA_R	stda	%r14, [%r24 + %r0] 0x4f
	wr_tick_cmpr_3_22:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf5, %g2
	or	%g4, 0xb0, %g4
	or	%g6, 0x87, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802072  ! 2695: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 2696: WRASI_I	wr	%r0, 0x0072, %asi
	wr_tick_cmpr_3_23:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x91, %g2
	or	%g4, 0xd2, %g4
	or	%g6, 0x82, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2b66000  ! 2698: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	.word 0x87802074  ! 2699: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2c7e000  ! 2700: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0xd8ccc400  ! 2701: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r12
	.word 0xd0b40400  ! 2702: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0x87802072  ! 2703: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8844400  ! 2704: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r12
	.word 0xdaa70e40  ! 2705: STWA_R	stwa	%r13, [%r28 + %r0] 0x72
	.word 0xd2b76000  ! 2706: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd29fe000  ! 2707: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd2df6000  ! 2708: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0x87802073  ! 2709: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2a7a000  ! 2710: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	mov	0x28, %r16
	.word 0xd2b7e000  ! 2712: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd29f2000  ! 2713: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	mov	0x3f8, %r21
	.word 0xd2b7a000  ! 2715: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	mov	0x3e0, %r20
	.word 0x87802073  ! 2717: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd29ee000  ! 2718: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r9
	mov	0x7e0, %r20
	.word 0xd2be6000  ! 2720: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	.word 0xd0a74e80  ! 2721: STWA_R	stwa	%r8, [%r29 + %r0] 0x74
	.word 0xd0b74e40  ! 2722: STHA_R	stha	%r8, [%r29 + %r0] 0x72
	.word 0xdabea000  ! 2723: STDA_I	stda	%r13, [%r26 + 0x0000] %asi
	mov	0x78, %r16
	.word 0xdaae6000  ! 2725: STBA_I	stba	%r13, [%r25 + 0x0000] %asi
	.word 0xd2ad04a0  ! 2726: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	mov	0x60, %r16
	.word 0xd4b40400  ! 2728: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0x87802072  ! 2729: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcdf4e40  ! 2730: LDXA_R	ldxa	[%r29, %r0] 0x72, %r14
	.word 0xdcbee000  ! 2731: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 2732: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r26
	.word 0xdc948400  ! 2734: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	.word 0xdad4c400  ! 2735: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xd6d40400  ! 2736: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	.word 0xd8d74e40  ! 2737: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r12
	.word 0x87802020  ! 2738: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r16
	.word 0xd4ac2000  ! 2740: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 2741: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r26
	mov	0x7e0, %r23
	.word 0xd4a584a0  ! 2744: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	.word 0xd2cde000  ! 2745: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r9
	mov	0x7f8, %r22
	.word 0xd2ade000  ! 2747: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0xd295e000  ! 2748: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r9
	.word 0xd6c78e40  ! 2749: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	mov	0x50, %r24
	.word 0xdcb44400  ! 2751: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	wr_tick_cmpr_3_24:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x98, %g2
	or	%g4, 0xb6, %g4
	or	%g6, 0xca, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdcf7ce80  ! 2753: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	.word 0xd6a78e40  ! 2754: STWA_R	stwa	%r11, [%r30 + %r0] 0x72
	.word 0xd8ae89e0  ! 2755: STBA_R	stba	%r12, [%r26 + %r0] 0x4f
	.word 0xd2dda000  ! 2756: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r9
	mov	0x70, %r27
	.word 0xd8dd04a0  ! 2758: LDXA_R	ldxa	[%r20, %r0] 0x25, %r12
	mov	0x78, %r16
	mov	0x48, %r25
	.word 0xd68fce80  ! 2761: LDUBA_R	lduba	[%r31, %r0] 0x74, %r11
	mov	0x50, %r25
	.word 0xd895a000  ! 2763: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r12
	.word 0xd8c5e000  ! 2764: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2765: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d6e000  ! 2766: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r12
	.word 0xd8b649e0  ! 2767: STHA_R	stha	%r12, [%r25 + %r0] 0x4f
	.word 0xdcb66000  ! 2768: STHA_I	stha	%r14, [%r25 + 0x0000] %asi
	.word 0xdcc62000  ! 2769: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r14
	.word 0xd0d78e60  ! 2770: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r8
	mov	0x3f8, %r20
	.word 0x87802020  ! 2772: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0872000  ! 2773: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xda9d04a0  ! 2774: LDDA_R	ldda	[%r20, %r0] 0x25, %r13
	.word 0xd8870e80  ! 2775: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r12
	.word 0x87802072  ! 2776: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0f689e0  ! 2777: STXA_R	stxa	%r8, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 2778: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cd6000  ! 2779: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r10
	.word 0xd4d5a000  ! 2780: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r10
	.word 0xd4b5e000  ! 2781: STHA_I	stha	%r10, [%r23 + 0x0000] %asi
	.word 0xdaa74e40  ! 2782: STWA_R	stwa	%r13, [%r29 + %r0] 0x72
	.word 0xd6ada000  ! 2783: STBA_I	stba	%r11, [%r22 + 0x0000] %asi
	.word 0xdcdf0e40  ! 2784: LDXA_R	ldxa	[%r28, %r0] 0x72, %r14
	mov	0x0, %r27
	.word 0xd0852000  ! 2786: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r8
	mov	0x58, %r18
	.word 0x87802020  ! 2788: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9609e0  ! 2789: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r14
	.word 0xdaf44400  ! 2790: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	mov	0x40, %r19
	.word 0xd48ea000  ! 2792: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r10
	.word 0xd4dee000  ! 2793: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r10
	.word 0x87802020  ! 2794: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2795: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4842000  ! 2796: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	.word 0x87802074  ! 2797: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4d7a000  ! 2798: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	mov	0x40, %r27
	mov	0x78, %r19
	.word 0x8780204f  ! 2801: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 2802: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49fe000  ! 2803: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd4df6000  ! 2804: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	mov	0x48, %r16
	.word 0x87802020  ! 2806: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r23
	.word 0xd4b7a000  ! 2808: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	mov	0x10, %r27
	mov	0x70, %r25
	mov	0x38, %r24
	mov	0x3d0, %r22
	.word 0xdacdc4a0  ! 2813: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r13
	.word 0xd6df2000  ! 2814: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	mov	0x68, %r17
	.word 0xd697a000  ! 2816: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0xd6976000  ! 2817: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	.word 0x87802072  ! 2818: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeaf0e60  ! 2819: STBA_R	stba	%r15, [%r28 + %r0] 0x73
	.word 0x87802020  ! 2820: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd89fe000  ! 2821: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0x87802074  ! 2822: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2823: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a6e000  ! 2824: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	.word 0xdea7ce40  ! 2825: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	.word 0x87802020  ! 2826: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2af2000  ! 2827: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 2828: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r25
	mov	0x50, %r17
	mov	0x7c0, %r21
	.word 0xd29ee000  ! 2832: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r9
	.word 0xda9c4400  ! 2833: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	.word 0xdcbcc400  ! 2834: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xdcc649e0  ! 2835: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r14
	mov	0x3d8, %r22
	ta	T_CHANGE_PRIV	! macro
	mov	0x48, %r26
	.word 0xd6862000  ! 2839: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2840: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b76000  ! 2841: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	mov	0x68, %r18
	.word 0xd6f7e000  ! 2843: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 2844: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 2845: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd687e000  ! 2846: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6afe000  ! 2847: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd0f7ce40  ! 2848: STXA_R	stxa	%r8, [%r31 + %r0] 0x72
	mov	0x38, %r18
	.word 0xdaf72000  ! 2850: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 2851: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d0, %r22
	.word 0x87802020  ! 2853: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda97e000  ! 2854: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 2855: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6ad84a0  ! 2856: STBA_R	stba	%r11, [%r22 + %r0] 0x25
	mov	0x78, %r19
	.word 0xdab78e60  ! 2858: STHA_R	stha	%r13, [%r30 + %r0] 0x73
	mov	0x30, %r26
	.word 0xdaf4c400  ! 2860: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xd4a70e80  ! 2861: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	.word 0xd4dfe000  ! 2862: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd887ce40  ! 2863: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r12
	.word 0xd2bfce60  ! 2864: STDA_R	stda	%r9, [%r31 + %r0] 0x73
	mov	0x7c8, %r22
	.word 0xdcf78e60  ! 2866: STXA_R	stxa	%r14, [%r30 + %r0] 0x73
	.word 0xdeb74e40  ! 2867: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	mov	0x50, %r19
	mov	0x58, %r27
	.word 0xd48504a0  ! 2870: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r10
	mov	0x8, %r27
	mov	0x50, %r16
	.word 0xdcf44400  ! 2873: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xdca7e000  ! 2874: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 2875: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcb4a000  ! 2876: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	mov	0x38, %r18
	.word 0xdedd84a0  ! 2878: LDXA_R	ldxa	[%r22, %r0] 0x25, %r15
	.word 0x8780204f  ! 2879: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdab74e60  ! 2880: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	.word 0xd2ae09e0  ! 2881: STBA_R	stba	%r9, [%r24 + %r0] 0x4f
	.word 0xdcc5c4a0  ! 2882: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r14
	mov	0x20, %r16
	.word 0x87802020  ! 2884: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabf2000  ! 2885: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	mov	0x3c8, %r22
	.word 0x87802072  ! 2887: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 2888: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaac2000  ! 2889: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	mov	0x78, %r26
	.word 0xd0a584a0  ! 2891: STWA_R	stwa	%r8, [%r22 + %r0] 0x25
	.word 0xd4cc6000  ! 2892: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	mov	0x78, %r16
	mov	0x7d0, %r22
	.word 0xd4a44400  ! 2895: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xd4acc400  ! 2896: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xdc94e000  ! 2897: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	mov	0x7c8, %r22
	.word 0x87802020  ! 2899: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf72000  ! 2900: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcbfa000  ! 2901: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	mov	0x7d0, %r20
	.word 0x87802074  ! 2903: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb76000  ! 2904: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	mov	0x18, %r25
	.word 0xdcc7a000  ! 2906: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xded78e40  ! 2907: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r15
	.word 0x87802025  ! 2908: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2909: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cf4e80  ! 2910: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r11
	.word 0x87802072  ! 2911: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2912: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r16
	.word 0xd4b7a000  ! 2914: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 2915: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0ac8400  ! 2916: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xdcb78e40  ! 2917: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xd08c4400  ! 2918: LDUBA_R	lduba	[%r17, %r0] 0x20, %r8
	.word 0xdedd44a0  ! 2919: LDXA_R	ldxa	[%r21, %r0] 0x25, %r15
	.word 0xde870e80  ! 2920: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r15
	.word 0xd495c4a0  ! 2921: LDUHA_R	lduha	[%r23, %r0] 0x25, %r10
	.word 0xd6d5e000  ! 2922: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r11
	.word 0xd2bdc4a0  ! 2923: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	.word 0xdcf56000  ! 2924: STXA_I	stxa	%r14, [%r21 + 0x0000] %asi
	.word 0xd2a40400  ! 2925: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xd09e49e0  ! 2926: LDDA_R	ldda	[%r25, %r0] 0x4f, %r8
	mov	0x8, %r19
	.word 0xdcf7ce60  ! 2928: STXA_R	stxa	%r14, [%r31 + %r0] 0x73
	mov	0x30, %r19
	.word 0x87802020  ! 2930: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r16
	.word 0xde84a000  ! 2932: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	mov	0x20, %r18
	.word 0xde8c2000  ! 2934: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	mov	0x7e8, %r21
	.word 0xded42000  ! 2936: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	.word 0xd6af8e80  ! 2937: STBA_R	stba	%r11, [%r30 + %r0] 0x74
	mov	0x20, %r27
	.word 0xdec46000  ! 2939: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	mov	0x7d0, %r20
	.word 0xd0bf0e60  ! 2941: STDA_R	stda	%r8, [%r28 + %r0] 0x73
	mov	0x18, %r17
	mov	0x30, %r18
	mov	0x50, %r25
	.word 0xd6dce000  ! 2945: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0xd6f42000  ! 2946: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	mov	0x78, %r16
	.word 0x87802020  ! 2948: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68d6000  ! 2949: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r11
	.word 0xdeac4400  ! 2950: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0xd6a5a000  ! 2951: STWA_I	stwa	%r11, [%r22 + 0x0000] %asi
	.word 0xda974e80  ! 2952: LDUHA_R	lduha	[%r29, %r0] 0x74, %r13
	mov	0x58, %r19
	.word 0xd4a44400  ! 2954: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xd4bde000  ! 2955: STDA_I	stda	%r10, [%r23 + 0x0000] %asi
	.word 0xd49d2000  ! 2956: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r10
	.word 0xdc94c400  ! 2957: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	.word 0xd2bd6000  ! 2958: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	.word 0xd4b7ce60  ! 2959: STHA_R	stha	%r10, [%r31 + %r0] 0x73
	mov	0x60, %r19
	mov	0x3e0, %r21
	.word 0xd2df0e80  ! 2962: LDXA_R	ldxa	[%r28, %r0] 0x74, %r9
	.word 0xd6b5e000  ! 2963: STHA_I	stha	%r11, [%r23 + 0x0000] %asi
	.word 0xd6ada000  ! 2964: STBA_I	stba	%r11, [%r22 + 0x0000] %asi
	.word 0x87802025  ! 2965: WRASI_I	wr	%r0, 0x0025, %asi
	wr_tick_cmpr_3_25:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xbd, %g2
	or	%g4, 0xb3, %g4
	or	%g6, 0xb2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7c8, %r23
	mov	0x50, %r25
	.word 0xdea4c400  ! 2969: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	.word 0xd0d5c4a0  ! 2970: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r8
	.word 0xd68d44a0  ! 2971: LDUBA_R	lduba	[%r21, %r0] 0x25, %r11
	.word 0xd88dc4a0  ! 2972: LDUBA_R	lduba	[%r23, %r0] 0x25, %r12
	mov	0x30, %r17
	.word 0xd8f40400  ! 2974: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xd08f4e60  ! 2975: LDUBA_R	lduba	[%r29, %r0] 0x73, %r8
	.word 0xd487e000  ! 2976: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xdeaf0e80  ! 2977: STBA_R	stba	%r15, [%r28 + %r0] 0x74
	.word 0x87802074  ! 2978: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca584a0  ! 2979: STWA_R	stwa	%r14, [%r22 + %r0] 0x25
	.word 0xd29ce000  ! 2980: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xd0ac8400  ! 2981: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xd8bc6000  ! 2982: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0xd8a4a000  ! 2983: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd89ce000  ! 2984: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	.word 0xd8bc2000  ! 2985: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd88ca000  ! 2986: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	.word 0xd8dc2000  ! 2987: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0xde9c8400  ! 2988: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	.word 0xd4bce000  ! 2989: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	mov	0x20, %r19
	.word 0x87802072  ! 2991: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2992: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r22
	.word 0xd6b44400  ! 2994: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0x87802073  ! 2995: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f0, %r21
	.word 0xd29d84a0  ! 2997: LDDA_R	ldda	[%r22, %r0] 0x25, %r9
	mov	0x7c8, %r23
	.word 0xd8bfce80  ! 2999: STDA_R	stda	%r12, [%r31 + %r0] 0x74
	.word 0x87802074  ! 3000: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3001: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r19
	.word 0x87802072  ! 3003: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf7ce80  ! 3004: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	.word 0xdabd04a0  ! 3005: STDA_R	stda	%r13, [%r20 + %r0] 0x25
	.word 0x8780204f  ! 3006: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r27
	mov	0x58, %r24
	.word 0xd6b70e80  ! 3009: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	.word 0xd6f70e80  ! 3010: STXA_R	stxa	%r11, [%r28 + %r0] 0x74
	.word 0xd0f46000  ! 3011: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0xd2bc0400  ! 3013: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0x87802025  ! 3014: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0cf4e40  ! 3015: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	.word 0xd2bfa000  ! 3016: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd8970e80  ! 3017: LDUHA_R	lduha	[%r28, %r0] 0x74, %r12
	.word 0xd4b504a0  ! 3018: STHA_R	stha	%r10, [%r20 + %r0] 0x25
	.word 0xd4f48400  ! 3019: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0x87802074  ! 3020: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0d689e0  ! 3021: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r8
	.word 0xd6df6000  ! 3022: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6afa000  ! 3023: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6d40400  ! 3024: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	mov	0x7e0, %r23
	.word 0xdca5c4a0  ! 3026: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	.word 0xd8cf2000  ! 3027: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0xd8972000  ! 3028: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	.word 0xd8c7a000  ! 3029: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xd2b70e60  ! 3030: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	.word 0xd2a74e40  ! 3031: STWA_R	stwa	%r9, [%r29 + %r0] 0x72
	.word 0xd4ac8400  ! 3032: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0x87802074  ! 3033: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r25
	.word 0xd88e6000  ! 3035: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r12
	.word 0x87802074  ! 3036: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 3037: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6844400  ! 3038: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r11
	.word 0x87802073  ! 3039: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8ace000  ! 3040: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 3041: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2cfce40  ! 3042: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r9
	.word 0xd0f70e60  ! 3043: STXA_R	stxa	%r8, [%r28 + %r0] 0x73
	.word 0xdeada000  ! 3044: STBA_I	stba	%r15, [%r22 + 0x0000] %asi
	.word 0x87802073  ! 3045: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r25
	mov	0x3c0, %r20
	.word 0xdeb72000  ! 3048: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xd8bdc4a0  ! 3049: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	.word 0xd6d78e40  ! 3050: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r11
	.word 0x8780204f  ! 3051: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b609e0  ! 3052: STHA_R	stha	%r11, [%r24 + %r0] 0x4f
	mov	0x7e8, %r21
	mov	0x3e0, %r22
	.word 0xd0cd44a0  ! 3055: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r8
	.word 0xd0ac4400  ! 3056: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	mov	0x7d0, %r22
	.word 0xded609e0  ! 3058: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r15
	.word 0xdef40400  ! 3059: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	mov	0x58, %r18
	.word 0xd29fe000  ! 3061: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0x87802025  ! 3062: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf649e0  ! 3063: STXA_R	stxa	%r14, [%r25 + %r0] 0x4f
	.word 0xd4b4a000  ! 3064: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0xdc970e80  ! 3065: LDUHA_R	lduha	[%r28, %r0] 0x74, %r14
	.word 0x87802020  ! 3066: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda946000  ! 3067: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	.word 0x87802025  ! 3068: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda876000  ! 3069: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 3070: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcde49e0  ! 3071: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r14
	.word 0xdcce09e0  ! 3072: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r14
	mov	0x38, %r18
	.word 0xd4d504a0  ! 3074: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r10
	.word 0xd2b4a000  ! 3075: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	mov	0x8, %r25
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802074  ! 3078: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r26
	.word 0xdcd44400  ! 3080: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	.word 0xd4dfce80  ! 3081: LDXA_R	ldxa	[%r31, %r0] 0x74, %r10
	mov	0x20, %r17
	.word 0x87802073  ! 3083: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r16
	.word 0xd6dca000  ! 3085: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r11
	.word 0xd6b46000  ! 3086: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3087: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd697e000  ! 3088: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0xd6f7a000  ! 3089: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	mov	0x18, %r27
	.word 0xd08f4e40  ! 3091: LDUBA_R	lduba	[%r29, %r0] 0x72, %r8
	.word 0xd2cfe000  ! 3092: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	.word 0xd2876000  ! 3093: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xd0878e60  ! 3094: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r8
	.word 0x87802073  ! 3095: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e8, %r20
	.word 0xd2c42000  ! 3097: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	mov	0x0, %r24
	.word 0x87802074  ! 3099: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdea40400  ! 3100: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xda974e80  ! 3101: LDUHA_R	lduha	[%r29, %r0] 0x74, %r13
	.word 0xda8504a0  ! 3102: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r13
	.word 0xd6852000  ! 3103: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r11
	.word 0x87802072  ! 3104: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6d72000  ! 3105: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r11
	.word 0xd6970e40  ! 3106: LDUHA_R	lduha	[%r28, %r0] 0x72, %r11
	.word 0xd2f48400  ! 3107: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0xd8970e40  ! 3108: LDUHA_R	lduha	[%r28, %r0] 0x72, %r12
	.word 0xd4f7e000  ! 3109: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	mov	0x3d0, %r23
	mov	0x68, %r16
	.word 0x87802072  ! 3112: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3113: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 3114: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r27
	.word 0xd0978e60  ! 3116: LDUHA_R	lduha	[%r30, %r0] 0x73, %r8
	.word 0xdc8f2000  ! 3117: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0xd2dd04a0  ! 3118: LDXA_R	ldxa	[%r20, %r0] 0x25, %r9
	.word 0xdadd84a0  ! 3119: LDXA_R	ldxa	[%r22, %r0] 0x25, %r13
	.word 0xd297ce40  ! 3120: LDUHA_R	lduha	[%r31, %r0] 0x72, %r9
	mov	0x40, %r19
	.word 0xdebfe000  ! 3122: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xd2cf4e80  ! 3124: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r9
	.word 0xd6cd84a0  ! 3125: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r11
	.word 0xd297e000  ! 3126: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	mov	0x50, %r19
	.word 0x87802020  ! 3128: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3129: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c0, %r20
	mov	0x0, %r18
	.word 0xd29ce000  ! 3132: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xd2f4e000  ! 3133: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 3134: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdec70e60  ! 3135: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r15
	.word 0xdeaf2000  ! 3136: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 3137: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3138: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3139: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdecc2000  ! 3140: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	.word 0x87802025  ! 3141: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeada000  ! 3142: STBA_I	stba	%r15, [%r22 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0x87802073  ! 3144: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r17
	mov	0x68, %r26
	.word 0x87802025  ! 3147: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2d4c400  ! 3148: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r9
	.word 0xd096e000  ! 3149: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r8
	.word 0xd0bee000  ! 3150: STDA_I	stda	%r8, [%r27 + 0x0000] %asi
	.word 0x87802074  ! 3151: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3152: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8cc400  ! 3153: LDUBA_R	lduba	[%r19, %r0] 0x20, %r15
	mov	0x3e0, %r22
	mov	0x38, %r24
	.word 0xd8b7a000  ! 3156: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	mov	0x70, %r26
	.word 0xda8c8400  ! 3158: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	.word 0xdedd84a0  ! 3159: LDXA_R	ldxa	[%r22, %r0] 0x25, %r15
	mov	0x3d8, %r23
	.word 0xd49f6000  ! 3161: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0x87802073  ! 3162: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3163: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r22
	.word 0xd4c5e000  ! 3165: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r10
	.word 0xd0bc4400  ! 3166: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xd4856000  ! 3167: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r10
	.word 0xd48de000  ! 3168: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r10
	.word 0xd49d6000  ! 3169: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r10
	mov	0x10, %r17
	.word 0xd0f78e80  ! 3171: STXA_R	stxa	%r8, [%r30 + %r0] 0x74
	.word 0xd89da000  ! 3172: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r12
	.word 0xd6ac8400  ! 3173: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xd2b7ce80  ! 3174: STHA_R	stha	%r9, [%r31 + %r0] 0x74
	mov	0x7d0, %r21
	.word 0xdcdde000  ! 3176: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	mov	0x60, %r19
	.word 0xdcf52000  ! 3178: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	.word 0xd0a70e60  ! 3179: STWA_R	stwa	%r8, [%r28 + %r0] 0x73
	mov	0x60, %r26
	.word 0x87802025  ! 3181: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeaf2000  ! 3182: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	mov	0x68, %r27
	.word 0x87802072  ! 3184: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdea78e40  ! 3185: STWA_R	stwa	%r15, [%r30 + %r0] 0x72
	.word 0xd2de09e0  ! 3186: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r9
	.word 0xd68f0e40  ! 3187: LDUBA_R	lduba	[%r28, %r0] 0x72, %r11
	.word 0x87802074  ! 3188: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bda000  ! 3189: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	.word 0xd0cf8e80  ! 3190: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r8
	mov	0x7c8, %r21
	.word 0xd6c56000  ! 3192: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r11
	.word 0xd6bde000  ! 3193: STDA_I	stda	%r11, [%r23 + 0x0000] %asi
	.word 0xd4be09e0  ! 3194: STDA_R	stda	%r10, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 3195: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r19
	mov	0x7f0, %r20
	mov	0x7d8, %r21
	.word 0xded48400  ! 3199: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	mov	0x40, %r25
	.word 0xdec7a000  ! 3201: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	mov	0x38, %r27
	.word 0xdeb7a000  ! 3203: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xdcad44a0  ! 3204: STBA_R	stba	%r14, [%r21 + %r0] 0x25
	.word 0xd8d7a000  ! 3205: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0xd48dc4a0  ! 3206: LDUBA_R	lduba	[%r23, %r0] 0x25, %r10
	.word 0xdcbfe000  ! 3207: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdcbf6000  ! 3208: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdc8fe000  ! 3209: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xdccfe000  ! 3210: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xdccfe000  ! 3211: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xdcb7a000  ! 3212: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xd8f649e0  ! 3213: STXA_R	stxa	%r12, [%r25 + %r0] 0x4f
	.word 0xdcdf0e60  ! 3214: LDXA_R	ldxa	[%r28, %r0] 0x73, %r14
	.word 0xdedc4400  ! 3215: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	.word 0xd2f689e0  ! 3216: STXA_R	stxa	%r9, [%r26 + %r0] 0x4f
	wr_tick_cmpr_3_26:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xa3, %g2
	or	%g4, 0xe5, %g4
	or	%g6, 0xfc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd08f2000  ! 3218: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 3219: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0bfe000  ! 3220: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd6b504a0  ! 3221: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	.word 0xdaadc4a0  ! 3222: STBA_R	stba	%r13, [%r23 + %r0] 0x25
	mov	0x68, %r26
	.word 0xd48fce60  ! 3224: LDUBA_R	lduba	[%r31, %r0] 0x73, %r10
	.word 0xdcafe000  ! 3225: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	mov	0x3c8, %r21
	mov	0x7d8, %r22
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdef609e0  ! 3229: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	wr_tick_cmpr_3_27:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xea, %g2
	or	%g4, 0xfa, %g4
	or	%g6, 0xd3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4b7a000  ! 3231: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd4afe000  ! 3232: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 3233: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8cdc4a0  ! 3234: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r12
	mov	0x50, %r16
	.word 0xd0d78e40  ! 3236: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r8
	mov	0x18, %r18
	.word 0xd8a6a000  ! 3238: STWA_I	stwa	%r12, [%r26 + 0x0000] %asi
	.word 0x87802072  ! 3239: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r26
	.word 0xd0f649e0  ! 3241: STXA_R	stxa	%r8, [%r25 + %r0] 0x4f
	.word 0xd0f52000  ! 3242: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	mov	0x78, %r26
	.word 0xdca48400  ! 3244: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xd2b5a000  ! 3245: STHA_I	stha	%r9, [%r22 + 0x0000] %asi
	.word 0xd4bf0e80  ! 3246: STDA_R	stda	%r10, [%r28 + %r0] 0x74
	.word 0xd4974e80  ! 3247: LDUHA_R	lduha	[%r29, %r0] 0x74, %r10
	.word 0xdebd04a0  ! 3248: STDA_R	stda	%r15, [%r20 + %r0] 0x25
	.word 0x87802072  ! 3249: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 3250: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c0, %r23
	.word 0xd2bc4400  ! 3252: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0xdeac8400  ! 3253: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xd6afa000  ! 3254: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd8b44400  ! 3255: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	mov	0x58, %r27
	.word 0xdcbf4e60  ! 3257: STDA_R	stda	%r14, [%r29 + %r0] 0x73
	.word 0x87802025  ! 3258: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2cd2000  ! 3259: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r9
	.word 0xd6f44400  ! 3260: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0xd0d5a000  ! 3261: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r8
	.word 0x87802025  ! 3262: WRASI_I	wr	%r0, 0x0025, %asi
	wr_tick_cmpr_3_28:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xdb, %g2
	or	%g4, 0xbf, %g4
	or	%g6, 0x8c, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0bc6000  ! 3264: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	.word 0xda8f4e80  ! 3265: LDUBA_R	lduba	[%r29, %r0] 0x74, %r13
	.word 0xd2cca000  ! 3266: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	mov	0x48, %r17
	.word 0xdabc8400  ! 3268: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	.word 0xd8dce000  ! 3269: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	mov	0x7c8, %r20
	mov	0x40, %r26
	.word 0xd8cc8400  ! 3272: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0x87802072  ! 3273: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3274: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa46000  ! 3275: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	mov	0x48, %r27
	mov	0x7e8, %r22
	.word 0xdabc6000  ! 3278: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xd0b78e40  ! 3279: STHA_R	stha	%r8, [%r30 + %r0] 0x72
	.word 0xd4bca000  ! 3280: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0xd4cc2000  ! 3281: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	mov	0x70, %r16
	.word 0xdc840400  ! 3283: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	.word 0x87802020  ! 3284: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b6c9e0  ! 3285: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	mov	0x70, %r18
	.word 0xdeccc400  ! 3287: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r15
	.word 0x87802073  ! 3288: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3289: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ad44a0  ! 3290: STBA_R	stba	%r10, [%r21 + %r0] 0x25
	.word 0xd08f0e60  ! 3291: LDUBA_R	lduba	[%r28, %r0] 0x73, %r8
	.word 0xd0a7ce60  ! 3292: STWA_R	stwa	%r8, [%r31 + %r0] 0x73
	.word 0xd8f5a000  ! 3293: STXA_I	stxa	%r12, [%r22 + 0x0000] %asi
	.word 0x87802025  ! 3294: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8ac2000  ! 3295: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0xd88c6000  ! 3296: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	.word 0xd2a4c400  ! 3297: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	mov	0x50, %r17
	.word 0xd8cdc4a0  ! 3299: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r12
	.word 0xdac4a000  ! 3300: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	.word 0xd8d7ce60  ! 3301: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r12
	.word 0xdebdc4a0  ! 3302: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	.word 0x87802074  ! 3303: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e8, %r21
	mov	0x7e8, %r22
	.word 0xdef7a000  ! 3306: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdef76000  ! 3307: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xde9fa000  ! 3308: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	mov	0x68, %r24
	.word 0xd2f78e40  ! 3310: STXA_R	stxa	%r9, [%r30 + %r0] 0x72
	.word 0xd0a76000  ! 3311: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	mov	0x7f8, %r20
	.word 0xd88e49e0  ! 3313: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r12
	.word 0xd097e000  ! 3314: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xdacfce60  ! 3315: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r13
	.word 0x87802020  ! 3316: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdf6000  ! 3317: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xdab78e40  ! 3318: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	.word 0xdaa78e40  ! 3319: STWA_R	stwa	%r13, [%r30 + %r0] 0x72
	.word 0xd4d74e80  ! 3320: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r10
	.word 0x87802072  ! 3321: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2c649e0  ! 3322: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r9
	mov	0x70, %r24
	mov	0x3e0, %r22
	.word 0xd6f72000  ! 3325: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	mov	0x7f0, %r22
	.word 0xd697e000  ! 3327: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0xd68f2000  ! 3328: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	mov	0x8, %r24
	.word 0xd0a70e80  ! 3330: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0xd6af4e60  ! 3331: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	.word 0xd2970e40  ! 3332: LDUHA_R	lduha	[%r28, %r0] 0x72, %r9
	.word 0xdcbf0e80  ! 3333: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	.word 0xdecf6000  ! 3334: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	wr_tick_cmpr_3_29:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xca, %g2
	or	%g4, 0x89, %g4
	or	%g6, 0x86, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 3336: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f6c9e0  ! 3337: STXA_R	stxa	%r8, [%r27 + %r0] 0x4f
	.word 0xd0b42000  ! 3338: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	mov	0x60, %r18
	.word 0xd0cce000  ! 3340: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0xd6df8e40  ! 3341: LDXA_R	ldxa	[%r30, %r0] 0x72, %r11
	.word 0xdad4a000  ! 3342: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0x87802073  ! 3343: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e8, %r23
	.word 0xdaa76000  ! 3345: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	mov	0x68, %r16
	.word 0xda9f2000  ! 3347: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	mov	0x60, %r27
	.word 0xdac7e000  ! 3349: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0x87802072  ! 3350: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r26
	.word 0xdabc6000  ! 3352: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xd0bf8e60  ! 3353: STDA_R	stda	%r8, [%r30 + %r0] 0x73
	.word 0xdeac2000  ! 3354: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0xdaf4c400  ! 3356: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	mov	0x38, %r26
	mov	0x28, %r24
	mov	0x78, %r17
	.word 0xda94a000  ! 3360: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	mov	0x3d0, %r21
	.word 0xd6f4c400  ! 3362: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd6cc2000  ! 3364: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	.word 0xdef5c4a0  ! 3365: STXA_R	stxa	%r15, [%r23 + %r0] 0x25
	.word 0xdacd04a0  ! 3366: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r13
	.word 0xd68c2000  ! 3367: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r11
	mov	0x18, %r17
	.word 0xd6ac4400  ! 3369: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0x87802072  ! 3370: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebf2000  ! 3371: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xd0bc0400  ! 3372: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0xd0af2000  ! 3373: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd2a7ce40  ! 3374: STWA_R	stwa	%r9, [%r31 + %r0] 0x72
	.word 0xdc8fe000  ! 3375: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xd4bfce40  ! 3376: STDA_R	stda	%r10, [%r31 + %r0] 0x72
	.word 0x87802020  ! 3377: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68c4400  ! 3378: LDUBA_R	lduba	[%r17, %r0] 0x20, %r11
	.word 0x87802073  ! 3379: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc962000  ! 3380: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r14
	mov	0x0, %r17
	mov	0x10, %r18
	.word 0xdeae49e0  ! 3383: STBA_R	stba	%r15, [%r25 + %r0] 0x4f
	mov	0x18, %r16
	.word 0xdcdc0400  ! 3385: LDXA_R	ldxa	[%r16, %r0] 0x20, %r14
	.word 0xd8d74e40  ! 3386: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r12
	.word 0xd4b649e0  ! 3387: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	.word 0xd08689e0  ! 3388: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r8
	.word 0xd4d62000  ! 3389: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r10
	.word 0xd8df4e40  ! 3390: LDXA_R	ldxa	[%r29, %r0] 0x72, %r12
	.word 0xd8966000  ! 3391: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r12
	.word 0xd8f62000  ! 3392: STXA_I	stxa	%r12, [%r24 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdaf74e60  ! 3394: STXA_R	stxa	%r13, [%r29 + %r0] 0x73
	.word 0xd48e2000  ! 3395: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r10
	.word 0x87802020  ! 3396: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r27
	.word 0xded74e40  ! 3398: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r15
	mov	0x78, %r19
	.word 0x87802020  ! 3400: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3401: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3402: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3403: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde97a000  ! 3404: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	mov	0x78, %r27
	.word 0xdebfa000  ! 3406: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xdc940400  ! 3407: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0xd6f7ce80  ! 3408: STXA_R	stxa	%r11, [%r31 + %r0] 0x74
	.word 0xd4af2000  ! 3409: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd4972000  ! 3410: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	mov	0x68, %r25
	.word 0xd4a76000  ! 3412: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd497e000  ! 3413: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	mov	0x7c8, %r20
	.word 0xda9504a0  ! 3415: LDUHA_R	lduha	[%r20, %r0] 0x25, %r13
	.word 0xd8d40400  ! 3416: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	.word 0x87802020  ! 3417: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f66000  ! 3418: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0x87802020  ! 3420: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cfa000  ! 3421: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0xdec40400  ! 3422: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xdcbc0400  ! 3423: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0xd8bf2000  ! 3424: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xdcacc400  ! 3425: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	mov	0x10, %r17
	.word 0x87802020  ! 3427: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0d7a000  ! 3428: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	mov	0x48, %r26
	mov	0x8, %r16
	.word 0xd0c72000  ! 3431: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0x87802020  ! 3432: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f609e0  ! 3433: STXA_R	stxa	%r12, [%r24 + %r0] 0x4f
	.word 0xd2c70e60  ! 3434: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r9
	.word 0x87802020  ! 3435: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a4a000  ! 3436: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	mov	0x48, %r26
	mov	0x48, %r19
	.word 0xd6c78e40  ! 3439: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	.word 0xde846000  ! 3440: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	mov	0x68, %r18
	mov	0x38, %r16
	mov	0x48, %r17
	mov	0x3f0, %r21
	mov	0x3c8, %r23
	.word 0xdebca000  ! 3446: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xd6c44400  ! 3447: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r11
	.word 0xd284e000  ! 3448: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r9
	.word 0xd4df0e80  ! 3449: LDXA_R	ldxa	[%r28, %r0] 0x74, %r10
	.word 0xd0cc4400  ! 3450: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	.word 0xde84a000  ! 3451: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	.word 0x87802074  ! 3452: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde846000  ! 3453: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0xdaa4c400  ! 3454: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0xd0d7ce80  ! 3455: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r8
	.word 0xdadce000  ! 3456: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3457: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4be89e0  ! 3458: STDA_R	stda	%r10, [%r26 + %r0] 0x4f
	mov	0x8, %r25
	.word 0x87802073  ! 3460: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8de6000  ! 3461: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r12
	mov	0x28, %r17
	.word 0xd8b6a000  ! 3463: STHA_I	stha	%r12, [%r26 + 0x0000] %asi
	.word 0xd6a78e40  ! 3464: STWA_R	stwa	%r11, [%r30 + %r0] 0x72
	.word 0x87802025  ! 3465: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xded40400  ! 3466: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	mov	0x50, %r27
	.word 0xdcd76000  ! 3468: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	mov	0x30, %r18
	.word 0xdcdf6000  ! 3470: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xdaaf4e40  ! 3471: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	mov	0x60, %r19
	.word 0xd0d72000  ! 3473: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0b72000  ! 3474: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd2bd44a0  ! 3475: STDA_R	stda	%r9, [%r21 + %r0] 0x25
	.word 0x87802072  ! 3476: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b42000  ! 3477: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	mov	0x3d0, %r21
	.word 0x87802020  ! 3479: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c72000  ! 3480: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd4bfce80  ! 3481: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	.word 0x87802020  ! 3482: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcac6000  ! 3483: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xdcb4e000  ! 3484: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xdc942000  ! 3485: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	mov	0x38, %r27
	mov	0x60, %r27
	.word 0xdad649e0  ! 3488: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r13
	mov	0x3e8, %r22
	.word 0xde942000  ! 3490: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	mov	0x7c0, %r21
	.word 0xdeac6000  ! 3492: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	mov	0x30, %r18
	.word 0xdeb46000  ! 3494: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3495: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf4c400  ! 3496: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xd8afce60  ! 3497: STBA_R	stba	%r12, [%r31 + %r0] 0x73
	.word 0x87802020  ! 3498: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2878e60  ! 3499: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r9
	.word 0xd2ac6000  ! 3500: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0xd4f689e0  ! 3502: STXA_R	stxa	%r10, [%r26 + %r0] 0x4f
	.word 0xd6b4e000  ! 3503: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xd6f4e000  ! 3504: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 3505: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b5e000  ! 3506: STHA_I	stha	%r11, [%r23 + 0x0000] %asi
	.word 0xd2adc4a0  ! 3507: STBA_R	stba	%r9, [%r23 + %r0] 0x25
	.word 0xd2f52000  ! 3508: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	.word 0xd2d52000  ! 3509: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r9
	mov	0x78, %r19
	mov	0x18, %r17
	mov	0x3c8, %r23
	mov	0x50, %r26
	.word 0xd2c56000  ! 3514: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r9
	mov	0x7c8, %r23
	.word 0x87802072  ! 3516: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r27
	.word 0x87802020  ! 3518: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b4c400  ! 3519: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0x87802074  ! 3520: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 3521: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r19
	.word 0x8780204f  ! 3523: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc9f6000  ! 3524: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xdab78e40  ! 3525: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	.word 0xd6c70e80  ! 3526: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r11
	mov	0x60, %r17
	.word 0xd28d04a0  ! 3528: LDUBA_R	lduba	[%r20, %r0] 0x25, %r9
	.word 0xdec72000  ! 3529: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0x87802025  ! 3530: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd8b584a0  ! 3532: STHA_R	stha	%r12, [%r22 + %r0] 0x25
	.word 0x87802020  ! 3533: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cc0400  ! 3534: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r11
	mov	0x7f0, %r20
	mov	0x3d8, %r23
	wr_tick_cmpr_3_30:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x96, %g2
	or	%g4, 0x89, %g4
	or	%g6, 0x89, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 3538: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 3539: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0976000  ! 3540: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd087e000  ! 3541: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	mov	0x7e8, %r20
	.word 0xd0cf2000  ! 3543: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	mov	0x18, %r27
	.word 0xd0c7a000  ! 3545: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0af2000  ! 3546: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0xde974e60  ! 3548: LDUHA_R	lduha	[%r29, %r0] 0x73, %r15
	.word 0xdc9f2000  ! 3549: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xdc872000  ! 3550: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcafa000  ! 3551: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 3552: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca4e000  ! 3553: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcf40400  ! 3554: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xd8bca000  ! 3555: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	mov	0x30, %r26
	.word 0xd8c4a000  ! 3557: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r12
	.word 0x87802025  ! 3558: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 3559: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3560: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3561: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8afa000  ! 3562: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 3563: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c8, %r20
	.word 0xdcdfce80  ! 3565: LDXA_R	ldxa	[%r31, %r0] 0x74, %r14
	.word 0xdec74e80  ! 3566: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r15
	.word 0xd4c40400  ! 3567: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	.word 0xdeac0400  ! 3568: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xda86a000  ! 3569: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r13
	.word 0xdccf4e40  ! 3570: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r14
	.word 0xdab66000  ! 3571: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0x8780204f  ! 3572: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r27
	.word 0xd29ec9e0  ! 3574: LDDA_R	ldda	[%r27, %r0] 0x4f, %r9
	.word 0xdcac0400  ! 3575: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xd8ac8400  ! 3576: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	mov	0x7c8, %r20
	mov	0x7e8, %r20
	.word 0xd086e000  ! 3579: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r8
	.word 0xd08e2000  ! 3580: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r8
	.word 0xd0f6e000  ! 3581: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	mov	0x7e8, %r23
	mov	0x7d0, %r20
	.word 0x87802020  ! 3584: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cf6000  ! 3585: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	mov	0x7e8, %r21
	mov	0x28, %r27
	.word 0xd08f2000  ! 3588: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	mov	0x18, %r19
	.word 0xd6a40400  ! 3590: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0xd084c400  ! 3591: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r8
	.word 0xdaf78e40  ! 3592: STXA_R	stxa	%r13, [%r30 + %r0] 0x72
	.word 0xded7a000  ! 3593: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xde8fa000  ! 3594: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0xdebf2000  ! 3595: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xd8d44400  ! 3596: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	mov	0x38, %r19
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x58, %r24
	.word 0x87802020  ! 3600: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69ec9e0  ! 3601: LDDA_R	ldda	[%r27, %r0] 0x4f, %r11
	.word 0xda9fa000  ! 3602: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xda8fa000  ! 3603: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xdab7a000  ! 3604: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xd8870e80  ! 3605: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r12
	.word 0xdedfe000  ! 3606: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xdef7e000  ! 3607: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xdeb7e000  ! 3608: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xde8f2000  ! 3609: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	mov	0x28, %r16
	mov	0x40, %r25
	.word 0xde8f2000  ! 3612: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xdec7a000  ! 3613: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xded7e000  ! 3614: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	mov	0x60, %r17
	.word 0xde97e000  ! 3616: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3617: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f70e80  ! 3618: STXA_R	stxa	%r10, [%r28 + %r0] 0x74
	.word 0x87802073  ! 3619: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 3620: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2870e80  ! 3621: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r9
	mov	0x78, %r16
	.word 0xd8bc6000  ! 3623: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3624: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r22
	.word 0xd6d78e80  ! 3626: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r11
	.word 0xd4a649e0  ! 3627: STWA_R	stwa	%r10, [%r25 + %r0] 0x4f
	.word 0xd2842000  ! 3628: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r9
	mov	0x3d0, %r21
	mov	0x10, %r18
	.word 0xd69689e0  ! 3631: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r11
	.word 0xdedca000  ! 3632: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xdaf504a0  ! 3633: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	mov	0x7e8, %r23
	mov	0x30, %r18
	.word 0xd2c6c9e0  ! 3636: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r9
	.word 0xd4d4c400  ! 3637: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	mov	0x7d0, %r20
	.word 0xd8bf8e80  ! 3639: STDA_R	stda	%r12, [%r30 + %r0] 0x74
	.word 0xde97ce80  ! 3640: LDUHA_R	lduha	[%r31, %r0] 0x74, %r15
	mov	0x30, %r26
	.word 0xd4a40400  ! 3642: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	mov	0x20, %r26
	.word 0xd4a4e000  ! 3644: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xd4f4e000  ! 3645: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 3646: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b4a000  ! 3647: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0xdeb7ce40  ! 3648: STHA_R	stha	%r15, [%r31 + %r0] 0x72
	.word 0xdcf4c400  ! 3649: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xdef70e60  ! 3650: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	.word 0xd8d609e0  ! 3651: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r12
	wr_tick_cmpr_3_31:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xac, %g2
	or	%g4, 0xea, %g4
	or	%g6, 0x82, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdebec9e0  ! 3653: STDA_R	stda	%r15, [%r27 + %r0] 0x4f
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802072  ! 3655: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29504a0  ! 3656: LDUHA_R	lduha	[%r20, %r0] 0x25, %r9
	mov	0x0, %r19
	.word 0xdaf46000  ! 3658: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0xd2f4c400  ! 3659: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xd6bca000  ! 3660: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	.word 0xd0af0e40  ! 3661: STBA_R	stba	%r8, [%r28 + %r0] 0x72
	.word 0xd0dca000  ! 3662: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	.word 0xd69544a0  ! 3663: LDUHA_R	lduha	[%r21, %r0] 0x25, %r11
	.word 0xd2ccc400  ! 3664: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	mov	0x38, %r26
	.word 0xd28c6000  ! 3666: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	mov	0x8, %r18
	.word 0x87802074  ! 3668: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7d8, %r23
	.word 0xd2a5e000  ! 3671: STWA_I	stwa	%r9, [%r23 + 0x0000] %asi
	.word 0xd2bde000  ! 3672: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	.word 0xd2cd6000  ! 3673: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r9
	mov	0x10, %r16
	.word 0xd29de000  ! 3675: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r9
	.word 0xd29de000  ! 3676: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3677: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b44400  ! 3678: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	mov	0x28, %r16
	.word 0xd6ace000  ! 3680: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	mov	0x60, %r24
	.word 0xd6aca000  ! 3682: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	mov	0x28, %r18
	mov	0x68, %r16
	.word 0xd6ac6000  ! 3685: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xd68ce000  ! 3686: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	.word 0xd6bca000  ! 3687: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	mov	0x20, %r16
	.word 0xd8a584a0  ! 3689: STWA_R	stwa	%r12, [%r22 + %r0] 0x25
	.word 0x87802072  ! 3690: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 3691: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c8, %r20
	.word 0xdeb4c400  ! 3693: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xd4d48400  ! 3694: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	.word 0x87802020  ! 3695: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cce000  ! 3696: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r11
	.word 0xdcf40400  ! 3697: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xd2f46000  ! 3698: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x7e0, %r22
	.word 0xdcf48400  ! 3701: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 3702: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b7e000  ! 3703: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xdcf4c400  ! 3704: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xd8b72000  ! 3705: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd0ae89e0  ! 3706: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	mov	0x50, %r24
	.word 0xd2df8e80  ! 3708: LDXA_R	ldxa	[%r30, %r0] 0x74, %r9
	.word 0xd8a48400  ! 3709: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	mov	0x10, %r19
	mov	0x7e0, %r22
	.word 0xdabf6000  ! 3712: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xdaa72000  ! 3713: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	mov	0x3e0, %r21
	.word 0xdaafa000  ! 3715: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 3716: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda9d6000  ! 3717: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r13
	.word 0xdad70e40  ! 3718: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r13
	.word 0x87802073  ! 3719: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd69d44a0  ! 3720: LDDA_R	ldda	[%r21, %r0] 0x25, %r11
	.word 0xdebd2000  ! 3721: STDA_I	stda	%r15, [%r20 + 0x0000] %asi
	.word 0xdea5a000  ! 3722: STWA_I	stwa	%r15, [%r22 + 0x0000] %asi
	.word 0xdeb52000  ! 3723: STHA_I	stha	%r15, [%r20 + 0x0000] %asi
	.word 0xd4ce09e0  ! 3724: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r10
	.word 0xdabf8e40  ! 3725: STDA_R	stda	%r13, [%r30 + %r0] 0x72
	mov	0x3d0, %r23
	.word 0xd2f56000  ! 3727: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	mov	0x20, %r26
	.word 0xd2bf0e80  ! 3729: STDA_R	stda	%r9, [%r28 + %r0] 0x74
	.word 0xd2af4e40  ! 3730: STBA_R	stba	%r9, [%r29 + %r0] 0x72
	.word 0xd49da000  ! 3731: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r10
	.word 0xd4c52000  ! 3732: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r10
	.word 0xd4ad6000  ! 3733: STBA_I	stba	%r10, [%r21 + 0x0000] %asi
	mov	0x0, %r27
	.word 0xd4cd2000  ! 3735: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r10
	.word 0x87802072  ! 3736: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaafce60  ! 3737: STBA_R	stba	%r13, [%r31 + %r0] 0x73
	mov	0x3f8, %r22
	.word 0xd68ce000  ! 3739: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	.word 0xd6ac2000  ! 3740: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 3741: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6bf6000  ! 3742: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd29d84a0  ! 3743: LDDA_R	ldda	[%r22, %r0] 0x25, %r9
	.word 0xdef40400  ! 3744: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 3745: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a504a0  ! 3746: STWA_R	stwa	%r12, [%r20 + %r0] 0x25
	.word 0xd2df8e80  ! 3747: LDXA_R	ldxa	[%r30, %r0] 0x74, %r9
	.word 0xd49f6000  ! 3748: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0x87802025  ! 3749: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2f7ce40  ! 3750: STXA_R	stxa	%r9, [%r31 + %r0] 0x72
	.word 0xdaaf2000  ! 3751: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdcb78e40  ! 3752: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xd8cf6000  ! 3753: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0xd8d72000  ! 3754: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xd89fe000  ! 3755: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0xdeb4c400  ! 3756: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xd69f8e40  ! 3757: LDDA_R	ldda	[%r30, %r0] 0x72, %r11
	.word 0xdc8fe000  ! 3758: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xd28c0400  ! 3759: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	mov	0x3d0, %r20
	.word 0x87802020  ! 3761: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa544a0  ! 3762: STWA_R	stwa	%r13, [%r21 + %r0] 0x25
	.word 0xd49fe000  ! 3763: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd4cf2000  ! 3764: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xdaa7ce80  ! 3765: STWA_R	stwa	%r13, [%r31 + %r0] 0x74
	.word 0xde85c4a0  ! 3766: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r15
	.word 0xd4af6000  ! 3767: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd4df2000  ! 3768: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0x87802072  ! 3769: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49da000  ! 3770: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r10
	mov	0x20, %r25
	mov	0x28, %r16
	.word 0xd4a5a000  ! 3773: STWA_I	stwa	%r10, [%r22 + 0x0000] %asi
	.word 0xd4bd6000  ! 3774: STDA_I	stda	%r10, [%r21 + 0x0000] %asi
	.word 0x87802074  ! 3775: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r16
	.word 0xd4874e40  ! 3777: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r10
	mov	0x0, %r24
	.word 0xdac7a000  ! 3779: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xdac7e000  ! 3780: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xda9f6000  ! 3781: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	mov	0x3d8, %r23
	.word 0x87802072  ! 3783: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0f74e80  ! 3784: STXA_R	stxa	%r8, [%r29 + %r0] 0x74
	.word 0xd4afce80  ! 3785: STBA_R	stba	%r10, [%r31 + %r0] 0x74
	.word 0xde9504a0  ! 3786: LDUHA_R	lduha	[%r20, %r0] 0x25, %r15
	mov	0x8, %r18
	.word 0xd8bf0e60  ! 3788: STDA_R	stda	%r12, [%r28 + %r0] 0x73
	.word 0xde9e09e0  ! 3789: LDDA_R	ldda	[%r24, %r0] 0x4f, %r15
	.word 0x87802072  ! 3790: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f44400  ! 3791: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0xdeac8400  ! 3792: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	mov	0x8, %r27
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x40, %r17
	.word 0xd8dc2000  ! 3796: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0x87802025  ! 3797: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bfe000  ! 3798: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd8b7a000  ! 3799: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xd8dfa000  ! 3800: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd88f6000  ! 3801: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xd88f2000  ! 3802: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	mov	0x7d8, %r21
	.word 0xd8f76000  ! 3804: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 3805: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r25
	.word 0xd89c6000  ! 3807: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r12
	.word 0x87802025  ! 3808: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd29c0400  ! 3809: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	.word 0xd2c76000  ! 3810: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0xd287ce80  ! 3811: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r9
	.word 0xdcacc400  ! 3812: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0xdebfa000  ! 3813: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xd09f8e40  ! 3814: LDDA_R	ldda	[%r30, %r0] 0x72, %r8
	.word 0xde9fe000  ! 3815: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0xdea7a000  ! 3816: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xdef7a000  ! 3817: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdacd04a0  ! 3818: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r13
	mov	0x28, %r26
	.word 0xdebf2000  ! 3820: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xdea72000  ! 3821: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xdebf2000  ! 3823: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xdedf6000  ! 3824: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xdea72000  ! 3825: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	mov	0x50, %r25
	mov	0x3d0, %r21
	.word 0x87802072  ! 3828: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xded6a000  ! 3829: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r15
	.word 0xd09544a0  ! 3830: LDUHA_R	lduha	[%r21, %r0] 0x25, %r8
	.word 0xdcf66000  ! 3831: STXA_I	stxa	%r14, [%r25 + 0x0000] %asi
	.word 0xdcf66000  ! 3832: STXA_I	stxa	%r14, [%r25 + 0x0000] %asi
	.word 0xdeb7ce80  ! 3833: STHA_R	stha	%r15, [%r31 + %r0] 0x74
	.word 0xd6cea000  ! 3834: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	.word 0x87802025  ! 3835: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3836: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f7a000  ! 3837: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 3838: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcc78e40  ! 3839: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r14
	.word 0xda8fe000  ! 3840: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xdac7a000  ! 3841: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	mov	0x7f8, %r20
	mov	0x7f8, %r20
	.word 0xd29ec9e0  ! 3844: LDDA_R	ldda	[%r27, %r0] 0x4f, %r9
	mov	0x68, %r24
	.word 0x87802020  ! 3846: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r19
	.word 0x87802025  ! 3848: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2d6c9e0  ! 3849: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r9
	.word 0xd0c6c9e0  ! 3850: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r8
	mov	0x60, %r27
	mov	0x3f0, %r20
	.word 0xd8ae6000  ! 3853: STBA_I	stba	%r12, [%r25 + 0x0000] %asi
	.word 0xd4f74e60  ! 3854: STXA_R	stxa	%r10, [%r29 + %r0] 0x73
	.word 0xdcdee000  ! 3855: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r14
	.word 0xd6cfce40  ! 3856: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r11
	.word 0xd886e000  ! 3857: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r12
	.word 0xd8d6e000  ! 3858: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 3859: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8852000  ! 3860: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r12
	mov	0x0, %r27
	.word 0xd8ad6000  ! 3862: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	.word 0xd8f56000  ! 3863: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	.word 0x87802073  ! 3864: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r24
	.word 0x87802074  ! 3866: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r26
	.word 0xd6dcc400  ! 3868: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	.word 0xd6842000  ! 3869: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r11
	.word 0xd6dce000  ! 3870: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0xd68c2000  ! 3871: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r11
	mov	0x68, %r27
	.word 0xd6c42000  ! 3873: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r11
	.word 0xd6aca000  ! 3874: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xd2df8e40  ! 3875: LDXA_R	ldxa	[%r30, %r0] 0x72, %r9
	.word 0xd0f70e40  ! 3876: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	.word 0xde878e40  ! 3877: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r15
	.word 0x87802025  ! 3878: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r18
	mov	0x3e0, %r23
	.word 0xd0c78e80  ! 3881: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r8
	.word 0xdad76000  ! 3882: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	wr_tick_cmpr_3_32:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xef, %g2
	or	%g4, 0xa9, %g4
	or	%g6, 0xa5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802072  ! 3884: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r27
	.word 0xd0f70e80  ! 3886: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0xd48fa000  ! 3887: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xd4df6000  ! 3888: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0xd0bfce80  ! 3889: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	.word 0xdc87a000  ! 3890: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcb48400  ! 3891: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xd2bf6000  ! 3892: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd29f2000  ! 3893: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd8cdc4a0  ! 3894: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r12
	.word 0xde872000  ! 3895: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xdebd44a0  ! 3896: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	mov	0x60, %r17
	.word 0xd2afce60  ! 3898: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	.word 0xd8bfe000  ! 3899: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd8cf2000  ! 3900: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0xd8bf6000  ! 3901: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd8876000  ! 3902: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	mov	0x7f8, %r21
	.word 0xd88f2000  ! 3904: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0xd6ae89e0  ! 3905: STBA_R	stba	%r11, [%r26 + %r0] 0x4f
	mov	0x60, %r17
	.word 0x87802074  ! 3907: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0876000  ! 3908: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0a7ce80  ! 3909: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	.word 0xd68cc400  ! 3910: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	.word 0xd697a000  ! 3911: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0xd8af0e40  ! 3912: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	mov	0x18, %r18
	mov	0x70, %r19
	.word 0xd0bfa000  ! 3915: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3916: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f76000  ! 3917: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0bfa000  ! 3918: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	mov	0x48, %r16
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd29c8400  ! 3921: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	.word 0xd4a74e40  ! 3922: STWA_R	stwa	%r10, [%r29 + %r0] 0x72
	.word 0x87802025  ! 3923: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 3924: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd696a000  ! 3925: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r11
	.word 0xd0dc0400  ! 3926: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xdcc62000  ! 3927: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r14
	mov	0x10, %r27
	.word 0xdc9ee000  ! 3929: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r14
	mov	0x3f8, %r20
	.word 0xdcf6a000  ! 3931: STXA_I	stxa	%r14, [%r26 + 0x0000] %asi
	.word 0xdcc7ce80  ! 3932: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r14
	.word 0xdabee000  ! 3933: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	.word 0xd0f7ce60  ! 3934: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	.word 0xd4c74e40  ! 3935: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r10
	.word 0xdcf66000  ! 3936: STXA_I	stxa	%r14, [%r25 + 0x0000] %asi
	.word 0xd48d04a0  ! 3937: LDUBA_R	lduba	[%r20, %r0] 0x25, %r10
	.word 0xd4f48400  ! 3938: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	mov	0x50, %r27
	mov	0x7e0, %r23
	.word 0xdcb62000  ! 3941: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	.word 0xd0b44400  ! 3942: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	mov	0x30, %r25
	.word 0xdc86e000  ! 3944: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r14
	.word 0xdabfce60  ! 3945: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	.word 0x87802073  ! 3946: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d0, %r22
	mov	0x58, %r25
	.word 0xd0862000  ! 3949: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r8
	.word 0xd0b6e000  ! 3950: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	mov	0x68, %r16
	.word 0xd0b6a000  ! 3952: STHA_I	stha	%r8, [%r26 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd0c6e000  ! 3954: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r8
	.word 0xd09f0e60  ! 3955: LDDA_R	ldda	[%r28, %r0] 0x73, %r8
	mov	0x68, %r19
	mov	0x7d8, %r22
	.word 0xd8d6e000  ! 3958: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r12
	.word 0x87802072  ! 3959: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r19
	mov	0x18, %r27
	.word 0x87802020  ! 3962: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r25
	mov	0x0, %r19
	.word 0x8780204f  ! 3965: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r21
	.word 0xd0b584a0  ! 3967: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	mov	0x60, %r25
	.word 0xd4f52000  ! 3969: STXA_I	stxa	%r10, [%r20 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0xd2f40400  ! 3971: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0x87802020  ! 3972: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac7a000  ! 3973: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xd8c5c4a0  ! 3974: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r12
	.word 0xd4976000  ! 3975: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r10
	.word 0xdcd544a0  ! 3976: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r14
	.word 0xdcac8400  ! 3977: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xdeb649e0  ! 3978: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	mov	0x68, %r18
	.word 0x8780204f  ! 3980: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdca48400  ! 3981: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xd6af8e40  ! 3982: STBA_R	stba	%r11, [%r30 + %r0] 0x72
	.word 0xda8ce000  ! 3983: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	mov	0x3f8, %r22
	mov	0x0, %r16
	.word 0xdac4a000  ! 3986: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	mov	0x30, %r24
	.word 0xdabc2000  ! 3988: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xd28c0400  ! 3989: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	.word 0xd6aca000  ! 3990: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xd6bce000  ! 3991: STDA_I	stda	%r11, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 3992: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69f8e40  ! 3993: LDDA_R	ldda	[%r30, %r0] 0x72, %r11
	.word 0xd8af0e40  ! 3994: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	.word 0xdcb7a000  ! 3995: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3996: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbfce80  ! 3997: STDA_R	stda	%r14, [%r31 + %r0] 0x74
	.word 0xda878e40  ! 3998: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r13
	mov	0x7d0, %r22
	.word 0xdcb42000  ! 4000: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0x87802074  ! 4002: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcdd6000  ! 4003: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r14
	.word 0xd08f4e80  ! 4004: LDUBA_R	lduba	[%r29, %r0] 0x74, %r8
	.word 0xd4f5e000  ! 4005: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 4006: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r16
	.word 0x87802025  ! 4008: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 4009: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd486e000  ! 4010: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	.word 0xd6a689e0  ! 4011: STWA_R	stwa	%r11, [%r26 + %r0] 0x4f
	mov	0x40, %r27
	.word 0x87802072  ! 4013: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4014: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf48400  ! 4015: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xd88649e0  ! 4016: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r12
	.word 0xdeb4e000  ! 4017: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0xde84a000  ! 4018: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	mov	0x68, %r17
	mov	0x20, %r27
	mov	0x58, %r26
	.word 0xdedf4e40  ! 4022: LDXA_R	ldxa	[%r29, %r0] 0x72, %r15
	.word 0xdcdca000  ! 4023: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xda9c8400  ! 4024: LDDA_R	ldda	[%r18, %r0] 0x20, %r13
	mov	0x0, %r26
	.word 0xdadc2000  ! 4026: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r13
	mov	0x7d0, %r21
	.word 0xdaf4e000  ! 4028: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xdadce000  ! 4029: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xdcb48400  ! 4030: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xde842000  ! 4031: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	.word 0xdec4a000  ! 4032: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	mov	0x10, %r16
	mov	0x7c0, %r20
	mov	0x30, %r25
	.word 0xdef4e000  ! 4036: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 4037: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r16
	.word 0xdeb7a000  ! 4039: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xdaf6c9e0  ! 4040: STXA_R	stxa	%r13, [%r27 + %r0] 0x4f
	mov	0x10, %r16
	.word 0x87802073  ! 4042: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf74e40  ! 4043: STXA_R	stxa	%r14, [%r29 + %r0] 0x72
	mov	0x60, %r18
	.word 0x87802073  ! 4045: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef52000  ! 4046: STXA_I	stxa	%r15, [%r20 + 0x0000] %asi
	.word 0xdedf4e80  ! 4047: LDXA_R	ldxa	[%r29, %r0] 0x74, %r15
	.word 0xdc974e80  ! 4048: LDUHA_R	lduha	[%r29, %r0] 0x74, %r14
	.word 0xd49e89e0  ! 4049: LDDA_R	ldda	[%r26, %r0] 0x4f, %r10
	.word 0xd0f52000  ! 4050: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	.word 0xdcbf0e40  ! 4051: STDA_R	stda	%r14, [%r28 + %r0] 0x72
	.word 0xd2d5a000  ! 4052: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r9
	mov	0x8, %r18
	.word 0xd2c52000  ! 4054: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r9
	mov	0x28, %r24
	.word 0x87802074  ! 4056: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd29ca000  ! 4057: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	.word 0xd08ec9e0  ! 4058: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r8
	mov	0x48, %r16
	.word 0xdcace000  ! 4060: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	mov	0x3c0, %r22
	mov	0x68, %r17
	.word 0xdcf4a000  ! 4063: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	mov	0x70, %r24
	.word 0xdcc46000  ! 4065: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r14
	.word 0xdcd46000  ! 4066: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	wr_tick_cmpr_3_33:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xcb, %g2
	or	%g4, 0xd3, %g4
	or	%g6, 0x95, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdcdce000  ! 4068: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r14
	.word 0xd88cc400  ! 4069: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	mov	0x48, %r16
	.word 0xd8bc2000  ! 4071: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd88ce000  ! 4072: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	.word 0xd8d4a000  ! 4073: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0x87802073  ! 4074: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8bce000  ! 4075: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xd8a4a000  ! 4077: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xdca4c400  ! 4078: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xd294a000  ! 4079: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r9
	.word 0xd2c4a000  ! 4080: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	.word 0xd4a7ce60  ! 4081: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	.word 0xd89ce000  ! 4082: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	.word 0xd8dce000  ! 4083: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	.word 0xdaaf0e80  ! 4084: STBA_R	stba	%r13, [%r28 + %r0] 0x74
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0dca000  ! 4086: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	.word 0xd8df0e40  ! 4087: LDXA_R	ldxa	[%r28, %r0] 0x72, %r12
	.word 0x87802072  ! 4088: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdec7ce60  ! 4089: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r15
	.word 0xdc94a000  ! 4090: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0x87802073  ! 4091: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e0, %r21
	wr_tick_cmpr_3_34:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe4, %g2
	or	%g4, 0xbe, %g4
	or	%g6, 0xf6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdcbe2000  ! 4094: STDA_I	stda	%r14, [%r24 + 0x0000] %asi
	.word 0x87802072  ! 4095: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r27
	.word 0xd4ce49e0  ! 4097: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r10
	.word 0xd09584a0  ! 4098: LDUHA_R	lduha	[%r22, %r0] 0x25, %r8
	mov	0x40, %r24
	.word 0xd6b72000  ! 4100: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 4101: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 4102: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6d7e000  ! 4103: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	.word 0xd6b76000  ! 4104: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xdebe09e0  ! 4105: STDA_R	stda	%r15, [%r24 + %r0] 0x4f
	mov	0x7d8, %r22
	.word 0xdcd7ce40  ! 4107: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r14
	.word 0x87802074  ! 4108: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde8ca000  ! 4109: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0xda8cc400  ! 4110: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	.word 0xd0f40400  ! 4111: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xd2f544a0  ! 4112: STXA_R	stxa	%r9, [%r21 + %r0] 0x25
	.word 0xd2ac6000  ! 4113: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd2bc2000  ! 4114: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xd2846000  ! 4115: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r9
	mov	0x68, %r26
	.word 0xd2942000  ! 4117: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xde8649e0  ! 4118: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r15
	.word 0xd0a4e000  ! 4119: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	mov	0x70, %r27
	.word 0x8780204f  ! 4121: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 4122: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 4123: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c8, %r21
	mov	0x7c8, %r23
	mov	0x68, %r19
	.word 0xd085e000  ! 4127: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r8
	.word 0xd0d56000  ! 4128: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r8
	mov	0x60, %r17
	.word 0x87802073  ! 4130: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0d52000  ! 4131: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r8
	.word 0xd0c52000  ! 4132: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r8
	.word 0xd0ade000  ! 4133: STBA_I	stba	%r8, [%r23 + 0x0000] %asi
	.word 0xd8d48400  ! 4134: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	wr_tick_cmpr_3_35:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xeb, %g2
	or	%g4, 0xb7, %g4
	or	%g6, 0xcc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdcaf0e60  ! 4136: STBA_R	stba	%r14, [%r28 + %r0] 0x73
	wr_tick_cmpr_3_36:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb6, %g2
	or	%g4, 0xba, %g4
	or	%g6, 0x96, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdcbcc400  ! 4138: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	mov	0x3f8, %r22
	.word 0xd0dde000  ! 4140: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r8
	.word 0xdaa70e80  ! 4141: STWA_R	stwa	%r13, [%r28 + %r0] 0x74
	mov	0x60, %r16
	.word 0xd8b5a000  ! 4143: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	mov	0x68, %r27
	.word 0xd8bda000  ! 4145: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	.word 0xd8f56000  ! 4146: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	.word 0x87802025  ! 4147: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0d48400  ! 4148: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	wr_tick_cmpr_3_37:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xea, %g2
	or	%g4, 0x82, %g4
	or	%g6, 0x89, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7f8, %r21
	.word 0xda9609e0  ! 4151: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r13
	mov	0x10, %r26
	mov	0x78, %r16
	.word 0xd28e2000  ! 4154: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	.word 0xd2b649e0  ! 4155: STHA_R	stha	%r9, [%r25 + %r0] 0x4f
	.word 0xd4ae2000  ! 4156: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	.word 0xd6b7ce60  ! 4157: STHA_R	stha	%r11, [%r31 + %r0] 0x73
	.word 0xd2b7ce80  ! 4158: STHA_R	stha	%r9, [%r31 + %r0] 0x74
	.word 0x87802025  ! 4159: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 4160: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 4161: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0be6000  ! 4162: STDA_I	stda	%r8, [%r25 + 0x0000] %asi
	.word 0x87802072  ! 4163: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8f649e0  ! 4164: STXA_R	stxa	%r12, [%r25 + %r0] 0x4f
	.word 0x87802025  ! 4165: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc94c400  ! 4166: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	wr_tick_cmpr_3_38:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe7, %g2
	or	%g4, 0xbc, %g4
	or	%g6, 0xe7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd29584a0  ! 4168: LDUHA_R	lduha	[%r22, %r0] 0x25, %r9
	.word 0xd6afce60  ! 4169: STBA_R	stba	%r11, [%r31 + %r0] 0x73
	.word 0xd2b76000  ! 4170: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 4171: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bf2000  ! 4172: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 4173: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c7a000  ! 4174: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	mov	0x10, %r26
	.word 0xd2d7e000  ! 4176: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xdcb78e80  ! 4177: STHA_R	stha	%r14, [%r30 + %r0] 0x74
	.word 0xd4dec9e0  ! 4178: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r10
	.word 0xd69fe000  ! 4179: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	mov	0x60, %r25
	.word 0xdabfce60  ! 4181: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	.word 0xd0b7e000  ! 4182: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 4183: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f8, %r22
	.word 0xd0b6a000  ! 4185: STHA_I	stha	%r8, [%r26 + 0x0000] %asi
	.word 0xd89f4e60  ! 4186: LDDA_R	ldda	[%r29, %r0] 0x73, %r12
	.word 0xd6ad44a0  ! 4187: STBA_R	stba	%r11, [%r21 + %r0] 0x25
	mov	0x7f8, %r20
	mov	0x3d8, %r22
	.word 0xd6a66000  ! 4190: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	.word 0xdab70e80  ! 4191: STHA_R	stha	%r13, [%r28 + %r0] 0x74
	.word 0x87802020  ! 4192: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69649e0  ! 4193: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r11
	.word 0xd4bfe000  ! 4194: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd48fa000  ! 4195: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xdaf7ce40  ! 4196: STXA_R	stxa	%r13, [%r31 + %r0] 0x72
	.word 0xdaa689e0  ! 4197: STWA_R	stwa	%r13, [%r26 + %r0] 0x4f
	.word 0xdabec9e0  ! 4198: STDA_R	stda	%r13, [%r27 + %r0] 0x4f
	.word 0xdaa76000  ! 4199: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xd2d544a0  ! 4200: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r9
	.word 0xd6f504a0  ! 4201: STXA_R	stxa	%r11, [%r20 + %r0] 0x25
	.word 0xd8ac0400  ! 4202: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xd0d584a0  ! 4203: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r8
	.word 0xdc8c0400  ! 4204: LDUBA_R	lduba	[%r16, %r0] 0x20, %r14
	.word 0x87802020  ! 4205: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd694c400  ! 4206: LDUHA_R	lduha	[%r19, %r0] 0x20, %r11
	mov	0x18, %r27
	.word 0xdacf8e40  ! 4208: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r13
	.word 0xd0bdc4a0  ! 4209: STDA_R	stda	%r8, [%r23 + %r0] 0x25
	.word 0x87802020  ! 4210: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ad04a0  ! 4211: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	.word 0xdaac2000  ! 4212: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0xdab4e000  ! 4213: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xda8ce000  ! 4214: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	mov	0x38, %r18
	mov	0x38, %r25
	.word 0xdad4a000  ! 4217: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	mov	0x7e8, %r20
	.word 0xd4a544a0  ! 4219: STWA_R	stwa	%r10, [%r21 + %r0] 0x25
	mov	0x3c0, %r22
	.word 0xd2dc0400  ! 4221: LDXA_R	ldxa	[%r16, %r0] 0x20, %r9
	mov	0x10, %r19
	.word 0xd8be49e0  ! 4223: STDA_R	stda	%r12, [%r25 + %r0] 0x4f
	.word 0xde94e000  ! 4224: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	.word 0xde8c6000  ! 4225: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0xde8dc4a0  ! 4226: LDUBA_R	lduba	[%r23, %r0] 0x25, %r15
	.word 0xdca4a000  ! 4227: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0xdacf0e40  ! 4228: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r13
	wr_tick_cmpr_3_39:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xfa, %g2
	or	%g4, 0xef, %g4
	or	%g6, 0x85, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2ac4400  ! 4230: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xd2d42000  ! 4231: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0x87802074  ! 4232: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c8, %r20
	.word 0xd897ce60  ! 4234: LDUHA_R	lduha	[%r31, %r0] 0x73, %r12
	.word 0xd6c7a000  ! 4235: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	.word 0xd2dd44a0  ! 4236: LDXA_R	ldxa	[%r21, %r0] 0x25, %r9
	mov	0x40, %r19
	mov	0x70, %r16
	.word 0xd29f6000  ! 4239: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xd2dfa000  ! 4240: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xdad74e80  ! 4241: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r13
	mov	0x48, %r27
	mov	0x18, %r25
	.word 0xdaf544a0  ! 4244: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	.word 0x87802025  ! 4245: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd294c400  ! 4246: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	.word 0x87802074  ! 4247: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2a76000  ! 4248: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 4249: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9e09e0  ! 4250: LDDA_R	ldda	[%r24, %r0] 0x4f, %r13
	.word 0xd6a72000  ! 4251: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	mov	0x78, %r16
	mov	0x3c0, %r21
	.word 0xd687e000  ! 4254: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xd68fe000  ! 4255: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	mov	0x7d8, %r20
	.word 0xd28fce80  ! 4257: LDUBA_R	lduba	[%r31, %r0] 0x74, %r9
	.word 0xde85c4a0  ! 4258: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r15
	.word 0x8780204f  ! 4259: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd68f0e60  ! 4260: LDUBA_R	lduba	[%r28, %r0] 0x73, %r11
	mov	0x58, %r25
	.word 0xde87a000  ! 4262: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xde872000  ! 4263: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	mov	0x7d8, %r21
	.word 0xdcbcc400  ! 4265: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xdabf6000  ! 4266: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xdaf7e000  ! 4267: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xda872000  ! 4268: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0xd2c78e80  ! 4269: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r9
	.word 0xd08fa000  ! 4270: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	mov	0x7f0, %r23
	.word 0xd69f4e60  ! 4272: LDDA_R	ldda	[%r29, %r0] 0x73, %r11
	mov	0x3c8, %r23
	.word 0xd6cf6000  ! 4274: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6f7e000  ! 4275: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd4af0e60  ! 4276: STBA_R	stba	%r10, [%r28 + %r0] 0x73
	.word 0xda9ec9e0  ! 4277: LDDA_R	ldda	[%r27, %r0] 0x4f, %r13
	mov	0x68, %r24
	mov	0x0, %r19
	.word 0xd2bf2000  ! 4280: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd0bf8e80  ! 4281: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	.word 0xdca78e60  ! 4282: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	.word 0xd89f2000  ! 4283: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	mov	0x70, %r26
	.word 0xd8af2000  ! 4285: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xd8afa000  ! 4286: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xd8bfa000  ! 4287: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xd8c72000  ! 4289: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	mov	0x3f0, %r20
	.word 0xd8b76000  ! 4291: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd0c6c9e0  ! 4292: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r8
	.word 0xdcd76000  ! 4293: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	.word 0xdcb7a000  ! 4294: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 4295: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r24
	.word 0xdcb4e000  ! 4297: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xdcc4e000  ! 4298: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r14
	.word 0xda9f4e40  ! 4299: LDDA_R	ldda	[%r29, %r0] 0x72, %r13
	.word 0xdcad44a0  ! 4300: STBA_R	stba	%r14, [%r21 + %r0] 0x25
	mov	0x70, %r19
	.word 0xd4970e40  ! 4302: LDUHA_R	lduha	[%r28, %r0] 0x72, %r10
	.word 0xdebd84a0  ! 4303: STDA_R	stda	%r15, [%r22 + %r0] 0x25
	.word 0x87802074  ! 4304: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r16
	mov	0x0, %r27
	.word 0xda846000  ! 4307: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r13
	.word 0xde878e40  ! 4308: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r15
	mov	0x18, %r18
	.word 0xdcaf8e80  ! 4310: STBA_R	stba	%r14, [%r30 + %r0] 0x74
	.word 0xd8a46000  ! 4311: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xdcdfce60  ! 4312: LDXA_R	ldxa	[%r31, %r0] 0x73, %r14
	.word 0xd48ce000  ! 4313: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r10
	.word 0x87802025  ! 4314: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4dfe000  ! 4315: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	mov	0x58, %r24
	.word 0xd4a72000  ! 4317: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4bfa000  ! 4318: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 4319: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r24
	.word 0xdeb609e0  ! 4321: STHA_R	stha	%r15, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 4322: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc8fa000  ! 4323: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdcaf6000  ! 4324: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdcdf6000  ! 4325: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	mov	0x38, %r19
	.word 0xdeb40400  ! 4327: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0xd89dc4a0  ! 4328: LDDA_R	ldda	[%r23, %r0] 0x25, %r12
	.word 0xdcafa000  ! 4329: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	mov	0x3d8, %r21
	.word 0xdaaf8e40  ! 4331: STBA_R	stba	%r13, [%r30 + %r0] 0x72
	.word 0x8780204f  ! 4332: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd28d44a0  ! 4333: LDUBA_R	lduba	[%r21, %r0] 0x25, %r9
	.word 0xdac48400  ! 4334: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	.word 0x87802020  ! 4335: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r22
	.word 0xdc8c6000  ! 4337: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r14
	.word 0xdcf46000  ! 4338: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdcbce000  ! 4339: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xdc84a000  ! 4341: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	.word 0xd88f8e60  ! 4342: LDUBA_R	lduba	[%r30, %r0] 0x73, %r12
	.word 0x87802025  ! 4343: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bfa000  ! 4344: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd0b4c400  ! 4345: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	mov	0x7d8, %r22
	mov	0x0, %r26
	.word 0xdcce09e0  ! 4348: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r14
	.word 0xd0a7a000  ! 4349: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0df2000  ! 4350: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0xd6bc0400  ! 4351: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	mov	0x60, %r25
	mov	0x7d8, %r23
	.word 0xd0f70e40  ! 4354: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	.word 0xd28fce80  ! 4355: LDUBA_R	lduba	[%r31, %r0] 0x74, %r9
	.word 0xde878e60  ! 4356: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r15
	mov	0x7c0, %r22
	.word 0xd4f48400  ! 4358: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xdeafa000  ! 4359: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xd6b584a0  ! 4360: STHA_R	stha	%r11, [%r22 + %r0] 0x25
	mov	0x7f8, %r20
	.word 0xd2bfe000  ! 4362: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd2cf6000  ! 4363: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	.word 0xdeb70e40  ! 4364: STHA_R	stha	%r15, [%r28 + %r0] 0x72
	mov	0x3e0, %r23
	.word 0xd286c9e0  ! 4366: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r9
	mov	0x58, %r27
	.word 0xdaa4c400  ! 4368: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0xdcf7e000  ! 4369: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x18, %r16
	mov	0x7c8, %r21
	.word 0xdcd76000  ! 4372: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	.word 0xdcf7a000  ! 4373: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcb7a000  ! 4374: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	mov	0x3c0, %r20
	mov	0x48, %r24
	.word 0x87802020  ! 4377: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf52000  ! 4378: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	.word 0xdea6c9e0  ! 4379: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	.word 0xd4ccc400  ! 4380: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0xdeade000  ! 4381: STBA_I	stba	%r15, [%r23 + 0x0000] %asi
	.word 0xde8de000  ! 4382: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r15
	.word 0xd8ac0400  ! 4383: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	mov	0x48, %r25
	.word 0xd8870e80  ! 4385: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r12
	.word 0xdead2000  ! 4386: STBA_I	stba	%r15, [%r20 + 0x0000] %asi
	.word 0xdac609e0  ! 4387: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r13
	.word 0xd2bc4400  ! 4388: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0xdccd2000  ! 4389: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r14
	mov	0x50, %r16
	.word 0xdccd2000  ! 4391: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 4392: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdccfa000  ! 4393: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xdecd44a0  ! 4394: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r15
	.word 0xdef689e0  ! 4395: STXA_R	stxa	%r15, [%r26 + %r0] 0x4f
	.word 0xd4d76000  ! 4396: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0x87802020  ! 4397: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4dca000  ! 4398: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	mov	0x3f8, %r20
	.word 0xd4c4e000  ! 4400: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r10
	.word 0xd4842000  ! 4401: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	.word 0xd4bf8e40  ! 4402: STDA_R	stda	%r10, [%r30 + %r0] 0x72
	mov	0x20, %r25
	mov	0x50, %r25
	mov	0x0, %r18
	.word 0x87802073  ! 4406: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8adc4a0  ! 4407: STBA_R	stba	%r12, [%r23 + %r0] 0x25
	.word 0xda87e000  ! 4408: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4409: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r23
	mov	0x58, %r27
	.word 0xdaafe000  ! 4412: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xdcaf4e60  ! 4413: STBA_R	stba	%r14, [%r29 + %r0] 0x73
	.word 0x87802020  ! 4414: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r24
	.word 0xd89609e0  ! 4416: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r12
	.word 0xdca46000  ! 4417: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xd8a4c400  ! 4418: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xd6b4a000  ! 4419: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd6874e40  ! 4420: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r11
	.word 0xdedce000  ! 4421: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r15
	.word 0xdef42000  ! 4422: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xdec4a000  ! 4423: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	mov	0x3f0, %r21
	.word 0x87802074  ! 4425: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xded4a000  ! 4426: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 4427: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebde000  ! 4428: STDA_I	stda	%r15, [%r23 + 0x0000] %asi
	.word 0xd0dc0400  ! 4429: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xd0d56000  ! 4430: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r8
	.word 0xd0ada000  ! 4431: STBA_I	stba	%r8, [%r22 + 0x0000] %asi
	wr_tick_cmpr_3_40:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf1, %g2
	or	%g4, 0xa6, %g4
	or	%g6, 0xbb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x30, %r18
	mov	0x70, %r25
	mov	0x8, %r24
	.word 0x8780204f  ! 4436: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r17
	.word 0x87802020  ! 4438: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f56000  ! 4439: STXA_I	stxa	%r8, [%r21 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xda8e89e0  ! 4441: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r13
	mov	0x7d0, %r22
	mov	0x58, %r16
	.word 0xd4dd04a0  ! 4444: LDXA_R	ldxa	[%r20, %r0] 0x25, %r10
	.word 0xd6ad6000  ! 4445: STBA_I	stba	%r11, [%r21 + 0x0000] %asi
	mov	0x40, %r18
	.word 0xd4df4e80  ! 4447: LDXA_R	ldxa	[%r29, %r0] 0x74, %r10
	mov	0x10, %r19
	.word 0x87802074  ! 4449: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a584a0  ! 4450: STWA_R	stwa	%r8, [%r22 + %r0] 0x25
	.word 0xd8c7e000  ! 4451: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	mov	0x70, %r24
	.word 0xd887e000  ! 4453: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0xd897e000  ! 4454: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	.word 0xdec78e80  ! 4455: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r15
	.word 0xdad78e40  ! 4456: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r13
	mov	0x58, %r19
	.word 0xd8c504a0  ! 4458: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r12
	mov	0x20, %r26
	.word 0x8780204f  ! 4460: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 4461: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdec7a000  ! 4462: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xd0c70e40  ! 4463: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r8
	.word 0x8780204f  ! 4464: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a6e000  ! 4465: STWA_I	stwa	%r8, [%r27 + 0x0000] %asi
	.word 0x87802073  ! 4466: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcd5c4a0  ! 4467: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r14
	.word 0xd4c584a0  ! 4468: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r10
	.word 0xd8dde000  ! 4469: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r12
	.word 0xdab48400  ! 4470: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	mov	0x60, %r26
	.word 0xd2dd6000  ! 4472: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r9
	.word 0xd295a000  ! 4473: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r9
	.word 0xd2ad6000  ! 4474: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 4475: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 4476: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f5e000  ! 4477: STXA_I	stxa	%r9, [%r23 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0xd29de000  ! 4479: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r9
	.word 0xd2ada000  ! 4480: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xd2b52000  ! 4481: STHA_I	stha	%r9, [%r20 + 0x0000] %asi
	.word 0xd2952000  ! 4482: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r9
	.word 0xde8f8e40  ! 4483: LDUBA_R	lduba	[%r30, %r0] 0x72, %r15
	.word 0x87802020  ! 4484: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4485: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6b44400  ! 4486: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xde8c2000  ! 4487: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	mov	0x3e0, %r20
	mov	0x50, %r18
	mov	0x28, %r16
	.word 0xdef42000  ! 4491: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xd6bd44a0  ! 4492: STDA_R	stda	%r11, [%r21 + %r0] 0x25
	.word 0xd6c4a000  ! 4493: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r11
	.word 0xd6dc2000  ! 4494: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r11
	.word 0xd6946000  ! 4495: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r11
	.word 0xd6d4e000  ! 4496: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r11
	.word 0x87802072  ! 4497: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6ce2000  ! 4498: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	mov	0x7e0, %r20
	.word 0xd6a6e000  ! 4500: STWA_I	stwa	%r11, [%r27 + 0x0000] %asi
	.word 0xde8504a0  ! 4501: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r15
	.word 0xdeb70e80  ! 4502: STHA_R	stha	%r15, [%r28 + %r0] 0x74
	mov	0x7c0, %r21
	.word 0xd2d62000  ! 4504: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r9
	.word 0xd2f62000  ! 4505: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	mov	0x28, %r26
	.word 0x8780204f  ! 4507: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdca7ce80  ! 4508: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	.word 0xd4bf8e40  ! 4509: STDA_R	stda	%r10, [%r30 + %r0] 0x72
	.word 0x87802073  ! 4510: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda862000  ! 4511: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r13
	.word 0xda866000  ! 4512: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r13
	mov	0x7c0, %r20
	mov	0x7c8, %r20
	.word 0xd0f40400  ! 4515: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xd0bf8e40  ! 4516: STDA_R	stda	%r8, [%r30 + %r0] 0x72
	.word 0xd0c62000  ! 4517: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r8
	mov	0x7c8, %r21
	wr_tick_cmpr_3_41:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x83, %g2
	or	%g4, 0xbc, %g4
	or	%g6, 0x86, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 4520: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4844400  ! 4521: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0xde9fa000  ! 4522: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdea7a000  ! 4524: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xd68504a0  ! 4525: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r11
	.word 0xdabf6000  ! 4526: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xdabfe000  ! 4527: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xd8f70e40  ! 4528: STXA_R	stxa	%r12, [%r28 + %r0] 0x72
	mov	0x0, %r17
	.word 0x8780204f  ! 4530: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4531: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf72000  ! 4532: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xd8f48400  ! 4533: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xd6b6c9e0  ! 4534: STHA_R	stha	%r11, [%r27 + %r0] 0x4f
	.word 0x87802025  ! 4535: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r17
	.word 0xd4cf4e60  ! 4537: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r10
	.word 0xd0bd44a0  ! 4538: STDA_R	stda	%r8, [%r21 + %r0] 0x25
	mov	0x60, %r26
	.word 0xd2ade000  ! 4540: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0xd2bd6000  ! 4541: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	.word 0x87802025  ! 4542: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc8dc4a0  ! 4543: LDUBA_R	lduba	[%r23, %r0] 0x25, %r14
	.word 0xdc8c8400  ! 4544: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0xd09584a0  ! 4545: LDUHA_R	lduha	[%r22, %r0] 0x25, %r8
	.word 0xd2dca000  ! 4546: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r9
	.word 0xd2c4a000  ! 4547: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	.word 0xd29c6000  ! 4548: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	.word 0x87802074  ! 4549: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf70e60  ! 4550: STXA_R	stxa	%r14, [%r28 + %r0] 0x73
	.word 0x87802025  ! 4551: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 4552: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r27
	.word 0xdedf6000  ! 4554: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0x87802020  ! 4555: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeafe000  ! 4556: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xdedf2000  ! 4557: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xde9ec9e0  ! 4559: LDDA_R	ldda	[%r27, %r0] 0x4f, %r15
	.word 0xd28c0400  ! 4560: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	.word 0xdaaf6000  ! 4561: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdadf6000  ! 4563: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xdad76000  ! 4564: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0xdaf4c400  ! 4565: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0x87802020  ! 4566: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabfa000  ! 4567: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdacf8e40  ! 4568: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r13
	.word 0xdaf78e60  ! 4569: STXA_R	stxa	%r13, [%r30 + %r0] 0x73
	.word 0xd0d76000  ! 4570: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0c7e000  ! 4571: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0f72000  ! 4572: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	mov	0x78, %r24
	.word 0xd0dfa000  ! 4574: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0c7a000  ! 4575: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0bf8e80  ! 4576: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	mov	0x40, %r17
	mov	0x60, %r26
	.word 0xdad7e000  ! 4579: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	mov	0x7d0, %r20
	.word 0xd6cfce60  ! 4581: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r11
	.word 0xd2f7e000  ! 4582: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd2c70e40  ! 4583: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r9
	.word 0x87802025  ! 4584: WRASI_I	wr	%r0, 0x0025, %asi
	wr_tick_cmpr_3_42:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x9b, %g2
	or	%g4, 0xc8, %g4
	or	%g6, 0x80, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd487e000  ! 4586: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802025  ! 4587: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc8e49e0  ! 4588: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r14
	.word 0xd0d44400  ! 4589: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r8
	mov	0x3f0, %r20
	mov	0x60, %r16
	.word 0xd0b7e000  ! 4592: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0xd0cf6000  ! 4593: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xde978e40  ! 4594: LDUHA_R	lduha	[%r30, %r0] 0x72, %r15
	.word 0xd4d48400  ! 4595: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	.word 0xdcbc4400  ! 4596: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 4597: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b4a000  ! 4598: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 4599: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r25
	mov	0x70, %r27
	.word 0xd69f6000  ! 4602: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	.word 0xd6cfe000  ! 4603: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0xd4f544a0  ! 4604: STXA_R	stxa	%r10, [%r21 + %r0] 0x25
	.word 0xd6b689e0  ! 4605: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	.word 0x8780204f  ! 4606: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a6a000  ! 4607: STWA_I	stwa	%r12, [%r26 + 0x0000] %asi
	mov	0x48, %r17
	.word 0x87802020  ! 4609: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef48400  ! 4610: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xdcc78e80  ! 4611: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r14
	.word 0xdca609e0  ! 4612: STWA_R	stwa	%r14, [%r24 + %r0] 0x4f
	.word 0xd8bf0e60  ! 4613: STDA_R	stda	%r12, [%r28 + %r0] 0x73
	.word 0xd6a4a000  ! 4614: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	.word 0xd6a4e000  ! 4615: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0xd6ace000  ! 4616: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0xdecc0400  ! 4617: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r15
	.word 0xd2ac8400  ! 4618: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xdaf42000  ! 4619: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 4620: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 4621: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f8, %r20
	.word 0xd49584a0  ! 4623: LDUHA_R	lduha	[%r22, %r0] 0x25, %r10
	.word 0xdef76000  ! 4624: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 4625: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0cc8400  ! 4626: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	mov	0x3e8, %r20
	.word 0x8780204f  ! 4628: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9ce000  ! 4629: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r13
	.word 0xd8974e40  ! 4630: LDUHA_R	lduha	[%r29, %r0] 0x72, %r12
	.word 0xde878e80  ! 4631: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r15
	mov	0x30, %r19
	.word 0x87802020  ! 4633: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 4634: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r26
	.word 0xdca70e40  ! 4636: STWA_R	stwa	%r14, [%r28 + %r0] 0x72
	.word 0xd4a40400  ! 4637: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	.word 0x87802025  ! 4638: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 4639: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f0, %r22
	.word 0xded46000  ! 4641: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	mov	0x60, %r18
	.word 0xdea42000  ! 4643: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xdea74e60  ! 4644: STWA_R	stwa	%r15, [%r29 + %r0] 0x73
	.word 0xd6c46000  ! 4645: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r11
	.word 0xd2b78e60  ! 4646: STHA_R	stha	%r9, [%r30 + %r0] 0x73
	mov	0x18, %r16
	.word 0xd8a4a000  ! 4648: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8ce09e0  ! 4649: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r12
	.word 0xd6c48400  ! 4650: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	.word 0xd8c4a000  ! 4651: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r12
	mov	0x7e0, %r23
	.word 0xd8cce000  ! 4653: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r12
	mov	0x3f0, %r22
	.word 0x87802073  ! 4655: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0ac4400  ! 4656: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0xd29e6000  ! 4657: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r9
	mov	0x3c8, %r23
	.word 0xd2d62000  ! 4659: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r9
	.word 0xd2ce2000  ! 4660: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r9
	.word 0xdec5c4a0  ! 4661: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r15
	.word 0xd4ce2000  ! 4662: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r10
	.word 0xd2c649e0  ! 4663: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r9
	.word 0xd6dee000  ! 4664: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r11
	mov	0x70, %r24
	.word 0x87802073  ! 4666: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6b56000  ! 4667: STHA_I	stha	%r11, [%r21 + 0x0000] %asi
	.word 0xda9d44a0  ! 4668: LDDA_R	ldda	[%r21, %r0] 0x25, %r13
	.word 0xd2f609e0  ! 4669: STXA_R	stxa	%r9, [%r24 + %r0] 0x4f
	mov	0x68, %r17
	.word 0xd49da000  ! 4671: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r10
	.word 0x87802020  ! 4672: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bf4e60  ! 4673: STDA_R	stda	%r12, [%r29 + %r0] 0x73
	.word 0xd4978e40  ! 4674: LDUHA_R	lduha	[%r30, %r0] 0x72, %r10
	.word 0xdca544a0  ! 4675: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0x8780204f  ! 4676: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2b6e000  ! 4677: STHA_I	stha	%r9, [%r27 + 0x0000] %asi
	.word 0xdcf609e0  ! 4678: STXA_R	stxa	%r14, [%r24 + %r0] 0x4f
	mov	0x10, %r19
	.word 0xdc8f4e80  ! 4680: LDUBA_R	lduba	[%r29, %r0] 0x74, %r14
	.word 0x87802025  ! 4681: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdacc6000  ! 4682: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	.word 0x87802025  ! 4683: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r27
	.word 0xd4a504a0  ! 4685: STWA_R	stwa	%r10, [%r20 + %r0] 0x25
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2a6e000  ! 4687: STWA_I	stwa	%r9, [%r27 + 0x0000] %asi
	.word 0xd2a66000  ! 4688: STWA_I	stwa	%r9, [%r25 + 0x0000] %asi
	mov	0x50, %r18
	.word 0x87802074  ! 4690: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bd04a0  ! 4691: STDA_R	stda	%r12, [%r20 + %r0] 0x25
	.word 0x87802074  ! 4692: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd09f2000  ! 4693: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0xd0bfe000  ! 4694: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd0f76000  ! 4695: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	mov	0x48, %r16
	.word 0xd0cf2000  ! 4697: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	mov	0x48, %r25
	.word 0xdadd84a0  ! 4699: LDXA_R	ldxa	[%r22, %r0] 0x25, %r13
	.word 0xd6a72000  ! 4700: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xdcafce60  ! 4701: STBA_R	stba	%r14, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 4702: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 4703: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r24
	.word 0x87802072  ! 4705: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6d584a0  ! 4706: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r11
	.word 0xdaad6000  ! 4707: STBA_I	stba	%r13, [%r21 + 0x0000] %asi
	mov	0x7e0, %r22
	.word 0xdacda000  ! 4709: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r13
	.word 0xda95a000  ! 4710: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4711: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r23
	.word 0xda9fa000  ! 4713: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xd4bc4400  ! 4714: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0xdea48400  ! 4715: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	mov	0x8, %r18
	.word 0xd4b48400  ! 4717: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	mov	0x7c8, %r20
	.word 0xde9f2000  ! 4719: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xdaf70e80  ! 4720: STXA_R	stxa	%r13, [%r28 + %r0] 0x74
	.word 0xdeb70e60  ! 4721: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	.word 0xd8d72000  ! 4722: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xd8a72000  ! 4723: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	mov	0x48, %r17
	mov	0x70, %r26
	mov	0x50, %r27
	.word 0xd8a76000  ! 4727: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8f72000  ! 4728: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8a7a000  ! 4729: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8876000  ! 4730: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0xd4ccc400  ! 4731: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0x87802072  ! 4732: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd08f8e80  ! 4733: LDUBA_R	lduba	[%r30, %r0] 0x74, %r8
	mov	0x28, %r19
	mov	0x60, %r27
	.word 0x8780204f  ! 4736: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 4737: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d8, %r21
	mov	0x60, %r18
	.word 0xdaaf8e40  ! 4740: STBA_R	stba	%r13, [%r30 + %r0] 0x72
	.word 0xd8870e40  ! 4741: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r12
	mov	0x50, %r19
	mov	0x60, %r24
	.word 0xdaa72000  ! 4744: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 4745: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8f8e60  ! 4746: LDUBA_R	lduba	[%r30, %r0] 0x73, %r13
	.word 0x87802074  ! 4747: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 4748: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4749: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d62000  ! 4750: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4751: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r20
	.word 0xdc9c0400  ! 4753: LDDA_R	ldda	[%r16, %r0] 0x20, %r14
	mov	0x28, %r27
	.word 0xd2bf0e60  ! 4755: STDA_R	stda	%r9, [%r28 + %r0] 0x73
	mov	0x28, %r16
	mov	0x3d0, %r23
	.word 0xd2afa000  ! 4758: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xd2f7e000  ! 4759: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	mov	0x48, %r18
	.word 0x8780204f  ! 4761: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e0, %r21
	.word 0xde8d04a0  ! 4763: LDUBA_R	lduba	[%r20, %r0] 0x25, %r15
	.word 0x87802020  ! 4764: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b6c9e0  ! 4765: STHA_R	stha	%r11, [%r27 + %r0] 0x4f
	.word 0x87802073  ! 4766: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r25
	mov	0x50, %r17
	.word 0x87802020  ! 4769: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9fa000  ! 4770: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	mov	0x7d8, %r22
	.word 0xdab609e0  ! 4772: STHA_R	stha	%r13, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 4773: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r19
	.word 0xd8a56000  ! 4775: STWA_I	stwa	%r12, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 4776: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r17
	mov	0x48, %r25
	.word 0xd8c6a000  ! 4779: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r12
	mov	0x7d8, %r21
	mov	0x7e8, %r23
	.word 0xd8862000  ! 4782: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4783: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 4784: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r27
	.word 0xd8af2000  ! 4786: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0xd8f76000  ! 4788: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8f7ce40  ! 4789: STXA_R	stxa	%r12, [%r31 + %r0] 0x72
	mov	0x58, %r16
	.word 0x87802025  ! 4791: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb7a000  ! 4792: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	mov	0x60, %r18
	mov	0x7f0, %r23
	.word 0xdedfa000  ! 4795: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	wr_tick_cmpr_3_43:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x93, %g2
	or	%g4, 0xbb, %g4
	or	%g6, 0x9a, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2bf0e40  ! 4797: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	.word 0xd2970e80  ! 4798: LDUHA_R	lduha	[%r28, %r0] 0x74, %r9
	.word 0xd2972000  ! 4799: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	mov	0x7e8, %r23
	mov	0x18, %r26
	.word 0xdec584a0  ! 4802: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r15
	.word 0xdcbcc400  ! 4803: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xd4948400  ! 4804: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	mov	0x60, %r19
	.word 0xd2cfa000  ! 4806: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	.word 0xd2f78e80  ! 4807: STXA_R	stxa	%r9, [%r30 + %r0] 0x74
	.word 0xd0ae89e0  ! 4808: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	mov	0x40, %r27
	.word 0xd2c504a0  ! 4810: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r9
	.word 0xd8f649e0  ! 4811: STXA_R	stxa	%r12, [%r25 + %r0] 0x4f
	.word 0xdcd7e000  ! 4812: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	mov	0x7d0, %r22
	.word 0xde8649e0  ! 4814: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r15
	.word 0xd0cf4e60  ! 4815: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r8
	.word 0xd2a76000  ! 4816: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xdaa74e80  ! 4817: STWA_R	stwa	%r13, [%r29 + %r0] 0x74
	.word 0x87802025  ! 4818: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cfe000  ! 4819: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0xd4d609e0  ! 4820: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r10
	.word 0xdacd44a0  ! 4821: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r13
	.word 0xd0f7a000  ! 4822: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xd0a76000  ! 4824: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0f76000  ! 4825: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	mov	0x3c8, %r20
	.word 0xd8ce49e0  ! 4827: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r12
	.word 0x87802025  ! 4828: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd29c2000  ! 4829: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	.word 0xd2c4e000  ! 4830: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x3f8, %r22
	.word 0xd4ae09e0  ! 4833: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0xdaf70e60  ! 4834: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	.word 0xdeac2000  ! 4835: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xdaaec9e0  ! 4836: STBA_R	stba	%r13, [%r27 + %r0] 0x4f
	mov	0x30, %r25
	.word 0xd6aca000  ! 4838: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	mov	0x48, %r16
	.word 0xd6a42000  ! 4840: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	mov	0x0, %r18
	mov	0x28, %r17
	.word 0xd6b4e000  ! 4843: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 4844: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6874e80  ! 4845: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r11
	.word 0xd6cfe000  ! 4846: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0xd2c40400  ! 4847: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r9
	.word 0xd6bc4400  ! 4848: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	mov	0x48, %r24
	mov	0x58, %r27
	mov	0x28, %r26
	mov	0x18, %r26
	mov	0x10, %r16
	mov	0x50, %r26
	.word 0xdadf2000  ! 4855: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0xdadfa000  ! 4856: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xd6adc4a0  ! 4857: STBA_R	stba	%r11, [%r23 + %r0] 0x25
	.word 0xd8dc0400  ! 4858: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0xd8844400  ! 4859: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r12
	.word 0xdaf76000  ! 4860: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 4861: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6ad04a0  ! 4862: STBA_R	stba	%r11, [%r20 + %r0] 0x25
	.word 0x87802072  ! 4863: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d0, %r22
	.word 0xd8d66000  ! 4865: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r12
	.word 0xd896a000  ! 4866: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r12
	.word 0xd88e2000  ! 4867: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4868: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28ec9e0  ! 4869: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r9
	mov	0x48, %r17
	mov	0x30, %r18
	.word 0xd2a46000  ! 4872: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	mov	0x58, %r17
	mov	0x60, %r25
	.word 0xd2f4a000  ! 4875: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0xd284e000  ! 4876: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r9
	.word 0xd2dc6000  ! 4877: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r9
	.word 0xd2dce000  ! 4878: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r9
	.word 0xd2842000  ! 4879: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r9
	.word 0xd2c42000  ! 4880: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	.word 0xd2dd44a0  ! 4881: LDXA_R	ldxa	[%r21, %r0] 0x25, %r9
	.word 0xdcbc6000  ! 4882: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xdcb4a000  ! 4883: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xd2b5c4a0  ! 4884: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	.word 0xdebcc400  ! 4885: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	mov	0x60, %r26
	.word 0xd4f42000  ! 4887: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	mov	0x3c8, %r22
	.word 0xdacf4e60  ! 4889: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r13
	mov	0x30, %r25
	.word 0xdadcc400  ! 4891: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xd6a46000  ! 4892: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0xdaa40400  ! 4893: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0xdabd44a0  ! 4894: STDA_R	stda	%r13, [%r21 + %r0] 0x25
	.word 0xd88ec9e0  ! 4895: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r12
	.word 0xd6ae89e0  ! 4896: STBA_R	stba	%r11, [%r26 + %r0] 0x4f
	.word 0xd2dce000  ! 4897: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r9
	mov	0x3f0, %r20
	.word 0x87802020  ! 4899: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4900: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 4901: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r24
	.word 0xd2876000  ! 4903: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xd29f2000  ! 4904: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd2c70e80  ! 4905: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r9
	.word 0xd2b7e000  ! 4906: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	mov	0x7c0, %r22
	.word 0xd8bf8e60  ! 4908: STDA_R	stda	%r12, [%r30 + %r0] 0x73
	.word 0xdec72000  ! 4909: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xdeaf6000  ! 4910: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xdeb72000  ! 4911: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xdea7a000  ! 4912: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xd49d44a0  ! 4913: LDDA_R	ldda	[%r21, %r0] 0x25, %r10
	.word 0xdaaf4e60  ! 4914: STBA_R	stba	%r13, [%r29 + %r0] 0x73
	mov	0x78, %r26
	mov	0x7e8, %r22
	.word 0xdc86c9e0  ! 4917: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r14
	.word 0xd8f48400  ! 4918: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0x87802020  ! 4919: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadf0e60  ! 4920: LDXA_R	ldxa	[%r28, %r0] 0x73, %r13
	.word 0xd6c649e0  ! 4921: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r11
	.word 0x87802074  ! 4922: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4cea000  ! 4923: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r10
	.word 0xd4f6a000  ! 4924: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	.word 0xd2df8e60  ! 4925: LDXA_R	ldxa	[%r30, %r0] 0x73, %r9
	.word 0xd8f66000  ! 4926: STXA_I	stxa	%r12, [%r25 + 0x0000] %asi
	.word 0xd8cc4400  ! 4927: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r12
	.word 0xdcc7ce60  ! 4928: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r14
	.word 0xd6974e60  ! 4929: LDUHA_R	lduha	[%r29, %r0] 0x73, %r11
	mov	0x38, %r25
	.word 0xd0cee000  ! 4931: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r8
	mov	0x3f0, %r23
	.word 0xd0ae2000  ! 4933: STBA_I	stba	%r8, [%r24 + 0x0000] %asi
	mov	0x48, %r16
	.word 0xd0bcc400  ! 4935: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	mov	0x38, %r19
	.word 0xd286a000  ! 4937: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r9
	.word 0xd6dc0400  ! 4938: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	mov	0x3f8, %r22
	ta	T_CHANGE_PRIV	! macro
	.word 0xd6d74e60  ! 4941: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r11
	.word 0xd2df4e40  ! 4942: LDXA_R	ldxa	[%r29, %r0] 0x72, %r9
	.word 0x8780204f  ! 4943: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r16
	.word 0xd4f78e80  ! 4945: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	.word 0xd6b46000  ! 4946: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd2a74e60  ! 4947: STWA_R	stwa	%r9, [%r29 + %r0] 0x73
	mov	0x38, %r25
	mov	0x18, %r19
	.word 0xd88c6000  ! 4950: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	mov	0x70, %r26
	mov	0x38, %r24
	.word 0xd2b78e40  ! 4953: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdcbc0400  ! 4955: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0xde94e000  ! 4956: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	.word 0xdedc6000  ! 4957: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r15
	.word 0xd8f70e60  ! 4958: STXA_R	stxa	%r12, [%r28 + %r0] 0x73
	.word 0xd0c40400  ! 4959: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	.word 0xd4b46000  ! 4960: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xd4aca000  ! 4961: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	mov	0x20, %r27
	wr_tick_cmpr_3_44:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xcf, %g2
	or	%g4, 0x81, %g4
	or	%g6, 0xbe, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4cc2000  ! 4964: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	.word 0xd4d4e000  ! 4965: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 4966: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebd44a0  ! 4967: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	.word 0xdaf609e0  ! 4968: STXA_R	stxa	%r13, [%r24 + %r0] 0x4f
	.word 0xd0cf4e60  ! 4969: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r8
	.word 0xd0952000  ! 4970: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r8
	.word 0xd4af8e60  ! 4971: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	.word 0xd2ad6000  ! 4972: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0xdef70e80  ! 4973: STXA_R	stxa	%r15, [%r28 + %r0] 0x74
	.word 0xdaf70e80  ! 4974: STXA_R	stxa	%r13, [%r28 + %r0] 0x74
	.word 0xd2c52000  ! 4975: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r9
	.word 0xd2ad2000  ! 4976: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xd2dda000  ! 4977: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r9
	.word 0x87802073  ! 4978: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2862000  ! 4979: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r9
	.word 0xd2878e60  ! 4980: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r9
	mov	0x0, %r25
	wr_tick_cmpr_3_45:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xbe, %g2
	or	%g4, 0x82, %g4
	or	%g6, 0xc5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3d8, %r23
	.word 0xd6be09e0  ! 4984: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	.word 0xdeaec9e0  ! 4985: STBA_R	stba	%r15, [%r27 + %r0] 0x4f
	.word 0xd8d584a0  ! 4986: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r12
	.word 0xd4862000  ! 4987: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r10
	.word 0x87802020  ! 4988: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c7e000  ! 4989: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	.word 0xd49fa000  ! 4990: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0xd4c7a000  ! 4991: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	mov	0x38, %r18
	.word 0xd2c649e0  ! 4993: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r9
	.word 0xdc9fe000  ! 4994: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xdc976000  ! 4995: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	.word 0xdcf7e000  ! 4996: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcf7e000  ! 4997: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x30, %r25
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_2:
	mov	0x68, %r27
	mov	0x3d8, %r21
	mov	0x60, %r18
	.word 0x87802072  ! 4: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d8, %r21
	.word 0xdcd52000  ! 6: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r14
	.word 0xdc9da000  ! 7: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r14
	mov	0x70, %r17
	.word 0x87802073  ! 9: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c8, %r22
	.word 0xdcbf6000  ! 11: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 12: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 13: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r25
	mov	0x68, %r25
	.word 0xdcaf6000  ! 16: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xda9f4e40  ! 17: LDDA_R	ldda	[%r29, %r0] 0x72, %r13
	mov	0x40, %r26
	.word 0xd6afa000  ! 19: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x40, %r24
	.word 0xd6d72000  ! 21: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r11
	mov	0x20, %r24
	.word 0xd2b78e40  ! 23: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	mov	0x3f0, %r20
	.word 0x87802025  ! 25: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd496e000  ! 26: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r10
	.word 0xd4aea000  ! 27: STBA_I	stba	%r10, [%r26 + 0x0000] %asi
	mov	0x20, %r24
	.word 0xd4bea000  ! 29: STDA_I	stda	%r10, [%r26 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0xd4be2000  ! 31: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	mov	0x70, %r16
	mov	0x78, %r19
	.word 0x87802073  ! 34: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r27
	.word 0x87802072  ! 36: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 37: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29f4e60  ! 38: LDDA_R	ldda	[%r29, %r0] 0x73, %r9
	.word 0xd0a44400  ! 39: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	mov	0x7f8, %r20
	.word 0xd0bce000  ! 41: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0xd08c2000  ! 42: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0xd0c4a000  ! 43: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	mov	0x28, %r17
	mov	0x60, %r17
	.word 0xd0946000  ! 46: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0xd084a000  ! 47: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	.word 0x87802020  ! 48: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r26
	.word 0xd0b5a000  ! 50: STHA_I	stha	%r8, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 51: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r26
	.word 0x87802074  ! 53: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd094e000  ! 54: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0xd0f4e000  ! 55: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 56: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdccc0400  ! 57: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r14
	mov	0x18, %r26
	.word 0xdcd66000  ! 59: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r14
	mov	0x20, %r17
	mov	0x7c8, %r20
	.word 0xd2af0e80  ! 62: STBA_R	stba	%r9, [%r28 + %r0] 0x74
	.word 0xd0be6000  ! 63: STDA_I	stda	%r8, [%r25 + 0x0000] %asi
	.word 0xd2afce60  ! 64: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	.word 0xd6f66000  ! 65: STXA_I	stxa	%r11, [%r25 + 0x0000] %asi
	mov	0x38, %r19
	.word 0xdcc4c400  ! 67: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	.word 0xd2cec9e0  ! 68: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r9
	mov	0x3d0, %r20
	.word 0xdeb44400  ! 70: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0xdcaee000  ! 71: STBA_I	stba	%r14, [%r27 + 0x0000] %asi
	.word 0xd0bf4e80  ! 72: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	.word 0xdcae6000  ! 73: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	.word 0xdcb6e000  ! 74: STHA_I	stha	%r14, [%r27 + 0x0000] %asi
	mov	0x3f0, %r21
	.word 0xdcdee000  ! 76: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r14
	mov	0x50, %r18
	.word 0xd4b70e80  ! 78: STHA_R	stha	%r10, [%r28 + %r0] 0x74
	.word 0xd6cf8e80  ! 79: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r11
	.word 0x87802073  ! 80: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 81: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29c8400  ! 82: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	.word 0xdeb72000  ! 83: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xd0dd04a0  ! 84: LDXA_R	ldxa	[%r20, %r0] 0x25, %r8
	.word 0xd6a7a000  ! 85: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6972000  ! 86: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	mov	0x3e8, %r23
	.word 0xd4ce09e0  ! 88: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r10
	.word 0x8780204f  ! 89: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea44400  ! 90: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xd6ad6000  ! 91: STBA_I	stba	%r11, [%r21 + 0x0000] %asi
	.word 0xd8d5c4a0  ! 92: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r12
	mov	0x58, %r25
	.word 0x8780204f  ! 94: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d0, %r23
	.word 0xd48d84a0  ! 96: LDUBA_R	lduba	[%r22, %r0] 0x25, %r10
	.word 0xd0a46000  ! 97: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0xd09ca000  ! 99: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	mov	0x30, %r19
	mov	0x70, %r17
	mov	0x68, %r19
	mov	0x28, %r16
	.word 0xd0dca000  ! 104: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	.word 0x87802020  ! 105: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a70e80  ! 106: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	mov	0x30, %r27
	mov	0x7e0, %r21
	.word 0xdaa4c400  ! 109: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	mov	0x78, %r25
	mov	0x60, %r25
	.word 0xd4af2000  ! 112: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xdca7ce40  ! 113: STWA_R	stwa	%r14, [%r31 + %r0] 0x72
	mov	0x3c8, %r20
	.word 0xdcdc0400  ! 115: LDXA_R	ldxa	[%r16, %r0] 0x20, %r14
	.word 0xd2876000  ! 116: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0x87802020  ! 117: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bfce60  ! 118: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	.word 0xd4876000  ! 119: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xda9d44a0  ! 120: LDDA_R	ldda	[%r21, %r0] 0x25, %r13
	.word 0xda87e000  ! 121: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0xda872000  ! 122: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	mov	0x0, %r24
	mov	0x7e0, %r22
	.word 0xd0af0e60  ! 125: STBA_R	stba	%r8, [%r28 + %r0] 0x73
	.word 0xdcbcc400  ! 126: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xd09f6000  ! 127: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	.word 0xd0afe000  ! 128: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0a7a000  ! 129: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0a72000  ! 130: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 131: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4d7ce40  ! 132: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r10
	.word 0xde9f2000  ! 133: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	mov	0x3d8, %r22
	mov	0x7f8, %r22
	.word 0xdcad84a0  ! 136: STBA_R	stba	%r14, [%r22 + %r0] 0x25
	.word 0xd2a76000  ! 137: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd8a70e60  ! 138: STWA_R	stwa	%r12, [%r28 + %r0] 0x73
	mov	0x3f0, %r20
	.word 0xdedfa000  ! 140: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x48, %r25
	.word 0xd6df4e60  ! 142: LDXA_R	ldxa	[%r29, %r0] 0x73, %r11
	.word 0x87802073  ! 143: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0acc400  ! 144: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	mov	0x60, %r19
	.word 0xd2d5a000  ! 146: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r9
	.word 0xde9d44a0  ! 147: LDDA_R	ldda	[%r21, %r0] 0x25, %r15
	.word 0x87802020  ! 148: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c46000  ! 149: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r11
	.word 0xd6c4a000  ! 150: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r11
	mov	0x7d0, %r21
	mov	0x7e0, %r21
	.word 0xd2cf0e80  ! 153: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r9
	.word 0xd29f0e40  ! 154: LDDA_R	ldda	[%r28, %r0] 0x72, %r9
	.word 0x87802072  ! 155: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd09504a0  ! 156: LDUHA_R	lduha	[%r20, %r0] 0x25, %r8
	mov	0x3e8, %r23
	.word 0xd2cf6000  ! 158: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	.word 0xd2a72000  ! 159: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	mov	0x60, %r26
	.word 0x87802073  ! 161: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdccfce80  ! 162: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r14
	mov	0x78, %r18
	mov	0x48, %r16
	.word 0xd4dcc400  ! 165: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0xd2c5a000  ! 166: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r9
	.word 0xd8f44400  ! 167: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0x87802020  ! 168: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bea000  ! 169: STDA_I	stda	%r11, [%r26 + 0x0000] %asi
	.word 0xd696e000  ! 170: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	.word 0x87802073  ! 171: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f7a000  ! 172: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd0af4e40  ! 173: STBA_R	stba	%r8, [%r29 + %r0] 0x72
	mov	0x40, %r26
	mov	0x60, %r19
	.word 0xd6bf0e40  ! 176: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	.word 0xdadd84a0  ! 177: LDXA_R	ldxa	[%r22, %r0] 0x25, %r13
	.word 0xdedfa000  ! 178: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xdeb72000  ! 179: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	wr_tick_cmpr_2_0:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb9, %g2
	or	%g4, 0xc1, %g4
	or	%g6, 0xf7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdeafa000  ! 181: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	mov	0x10, %r26
	.word 0xdeb44400  ! 183: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0xd6b584a0  ! 184: STHA_R	stha	%r11, [%r22 + %r0] 0x25
	.word 0xdaf72000  ! 185: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xd6df0e40  ! 186: LDXA_R	ldxa	[%r28, %r0] 0x72, %r11
	.word 0xdaaf6000  ! 187: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 188: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd28fce80  ! 189: LDUBA_R	lduba	[%r31, %r0] 0x74, %r9
	mov	0x8, %r19
	.word 0xd8b78e40  ! 191: STHA_R	stha	%r12, [%r30 + %r0] 0x72
	mov	0x3f0, %r20
	.word 0xdeb78e80  ! 193: STHA_R	stha	%r15, [%r30 + %r0] 0x74
	.word 0x87802073  ! 194: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2d6e000  ! 195: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r9
	.word 0xdc978e80  ! 196: LDUHA_R	lduha	[%r30, %r0] 0x74, %r14
	mov	0x30, %r27
	.word 0xd6b62000  ! 198: STHA_I	stha	%r11, [%r24 + 0x0000] %asi
	.word 0xd6bf0e80  ! 199: STDA_R	stda	%r11, [%r28 + %r0] 0x74
	mov	0x8, %r25
	mov	0x48, %r25
	.word 0x87802025  ! 202: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r19
	.word 0xd29e09e0  ! 204: LDDA_R	ldda	[%r24, %r0] 0x4f, %r9
	.word 0xdab78e60  ! 205: STHA_R	stha	%r13, [%r30 + %r0] 0x73
	.word 0x8780204f  ! 206: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbe89e0  ! 207: STDA_R	stda	%r14, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 208: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd29fce60  ! 209: LDDA_R	ldda	[%r31, %r0] 0x73, %r9
	.word 0xdcac2000  ! 210: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	mov	0x30, %r16
	.word 0xd6a7ce80  ! 212: STWA_R	stwa	%r11, [%r31 + %r0] 0x74
	.word 0x87802025  ! 213: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd68fa000  ! 214: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	mov	0x38, %r25
	mov	0x18, %r17
	.word 0xd68fe000  ! 217: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xd8b609e0  ! 218: STHA_R	stha	%r12, [%r24 + %r0] 0x4f
	.word 0xd4972000  ! 219: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0x87802073  ! 220: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4af2000  ! 221: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd4dfa000  ! 222: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4bf6000  ! 223: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd4f72000  ! 224: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 225: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4aee000  ! 226: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	.word 0xdcf48400  ! 227: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xd2f4c400  ! 228: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xdcc504a0  ! 229: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r14
	.word 0xd2974e80  ! 230: LDUHA_R	lduha	[%r29, %r0] 0x74, %r9
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd4d40400  ! 232: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	mov	0x18, %r27
	.word 0xd69ee000  ! 234: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r11
	mov	0x50, %r26
	.word 0xd8d7ce40  ! 236: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r12
	mov	0x7d0, %r23
	mov	0x7f0, %r20
	.word 0x87802025  ! 239: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd485a000  ! 240: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r10
	.word 0xd2f4c400  ! 241: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xdaf56000  ! 242: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	.word 0xdadde000  ! 243: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r13
	.word 0xdcf40400  ! 244: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xd6a584a0  ! 245: STWA_R	stwa	%r11, [%r22 + %r0] 0x25
	.word 0x87802020  ! 246: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r23
	.word 0xd0df2000  ! 248: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0874e40  ! 249: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r8
	.word 0xde978e80  ! 250: LDUHA_R	lduha	[%r30, %r0] 0x74, %r15
	.word 0xdea7e000  ! 251: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xd2b48400  ! 252: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd2b48400  ! 253: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	mov	0x60, %r24
	.word 0xd89fce40  ! 255: LDDA_R	ldda	[%r31, %r0] 0x72, %r12
	mov	0x60, %r17
	mov	0x60, %r27
	.word 0xd8bf6000  ! 258: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd8afe000  ! 259: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xdcb4c400  ! 260: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xd4de89e0  ! 261: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r10
	.word 0xda8c4400  ! 262: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0xdcbc0400  ! 263: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0xd8874e60  ! 264: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r12
	.word 0xd6c78e40  ! 265: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	mov	0x78, %r26
	.word 0xd48c0400  ! 267: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	.word 0xd29f8e40  ! 268: LDDA_R	ldda	[%r30, %r0] 0x72, %r9
	.word 0xd4bf6000  ! 269: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	mov	0x60, %r27
	.word 0x87802020  ! 271: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r17
	.word 0xdcbdc4a0  ! 273: STDA_R	stda	%r14, [%r23 + %r0] 0x25
	.word 0x87802072  ! 274: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 275: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4dc0400  ! 276: LDXA_R	ldxa	[%r16, %r0] 0x20, %r10
	.word 0xdcdee000  ! 277: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r14
	mov	0x50, %r27
	mov	0x30, %r24
	.word 0xd2a74e80  ! 280: STWA_R	stwa	%r9, [%r29 + %r0] 0x74
	.word 0xdcac0400  ! 281: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xdcb48400  ! 282: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xd89f0e80  ! 283: LDDA_R	ldda	[%r28, %r0] 0x74, %r12
	.word 0xd2de6000  ! 284: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r9
	mov	0x10, %r19
	.word 0xdaaf4e40  ! 286: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	.word 0xd8bec9e0  ! 287: STDA_R	stda	%r12, [%r27 + %r0] 0x4f
	.word 0x87802073  ! 288: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 289: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdead84a0  ! 290: STBA_R	stba	%r15, [%r22 + %r0] 0x25
	.word 0xdab5a000  ! 291: STHA_I	stha	%r13, [%r22 + 0x0000] %asi
	.word 0xd8a78e40  ! 292: STWA_R	stwa	%r12, [%r30 + %r0] 0x72
	mov	0x70, %r26
	mov	0x7d8, %r21
	mov	0x58, %r27
	.word 0xdcc7ce80  ! 296: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r14
	.word 0xd28689e0  ! 297: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r9
	mov	0x40, %r19
	.word 0xd4b5c4a0  ! 299: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	mov	0x70, %r18
	.word 0xd295e000  ! 301: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r9
	.word 0xd2ade000  ! 302: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0xdaf70e40  ! 303: STXA_R	stxa	%r13, [%r28 + %r0] 0x72
	.word 0x87802020  ! 304: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r21
	mov	0x10, %r19
	mov	0x38, %r27
	.word 0x87802072  ! 308: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde9ec9e0  ! 309: LDDA_R	ldda	[%r27, %r0] 0x4f, %r15
	mov	0x28, %r18
	.word 0x87802072  ! 311: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r25
	.word 0xdeac2000  ! 313: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xdcbf0e80  ! 314: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	mov	0x7f8, %r21
	mov	0x3f8, %r20
	.word 0xdab4a000  ! 317: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	mov	0x7e8, %r21
	mov	0x70, %r18
	.word 0xdedcc400  ! 320: LDXA_R	ldxa	[%r19, %r0] 0x20, %r15
	.word 0xd2a4a000  ! 321: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	mov	0x7e0, %r23
	mov	0x70, %r25
	mov	0x68, %r27
	.word 0xd2b4a000  ! 325: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0xd2942000  ! 326: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2946000  ! 327: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r9
	.word 0xdcf504a0  ! 328: STXA_R	stxa	%r14, [%r20 + %r0] 0x25
	mov	0x8, %r16
	mov	0x8, %r18
	mov	0x8, %r17
	mov	0x78, %r25
	mov	0x3e0, %r21
	.word 0xd88d04a0  ! 334: LDUBA_R	lduba	[%r20, %r0] 0x25, %r12
	.word 0xd2bfce80  ! 335: STDA_R	stda	%r9, [%r31 + %r0] 0x74
	.word 0x87802073  ! 336: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r19
	mov	0x7f8, %r22
	.word 0x87802020  ! 339: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab40400  ! 340: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	mov	0x70, %r17
	mov	0x10, %r25
	.word 0xd0b56000  ! 343: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	mov	0x58, %r25
	mov	0x7d0, %r20
	.word 0x87802020  ! 346: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68fce60  ! 347: LDUBA_R	lduba	[%r31, %r0] 0x73, %r11
	.word 0xd0a72000  ! 348: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xd08c8400  ! 349: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0xd2872000  ! 350: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	mov	0x8, %r24
	.word 0x87802025  ! 352: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad70e80  ! 353: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r13
	.word 0x87802025  ! 354: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r26
	.word 0xd6c76000  ! 356: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd69fa000  ! 357: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0x87802020  ! 358: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdede49e0  ! 359: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r15
	.word 0xdea48400  ! 360: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xdeaf0e40  ! 361: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	mov	0x7f8, %r20
	.word 0xd49fe000  ! 363: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd4d76000  ! 364: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	mov	0x18, %r26
	.word 0xd49504a0  ! 366: LDUHA_R	lduha	[%r20, %r0] 0x25, %r10
	.word 0xd0f72000  ! 367: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xd89609e0  ! 368: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r12
	.word 0xdc8fe000  ! 369: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	mov	0x18, %r25
	.word 0xd0f48400  ! 371: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0x87802020  ! 372: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c56000  ! 373: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r11
	.word 0xd6952000  ! 374: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r11
	mov	0x3e8, %r20
	.word 0xd8afce80  ! 376: STBA_R	stba	%r12, [%r31 + %r0] 0x74
	.word 0xd4ade000  ! 377: STBA_I	stba	%r10, [%r23 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xd485e000  ! 379: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r10
	.word 0xd49d6000  ! 380: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r10
	.word 0xdea78e80  ! 381: STWA_R	stwa	%r15, [%r30 + %r0] 0x74
	.word 0xd0f5a000  ! 382: STXA_I	stxa	%r8, [%r22 + 0x0000] %asi
	.word 0xd09d6000  ! 383: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r8
	.word 0xd4a504a0  ! 384: STWA_R	stwa	%r10, [%r20 + %r0] 0x25
	mov	0x3e0, %r23
	mov	0x60, %r16
	.word 0xd8ad6000  ! 387: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0xd69584a0  ! 389: LDUHA_R	lduha	[%r22, %r0] 0x25, %r11
	.word 0xd2df4e60  ! 390: LDXA_R	ldxa	[%r29, %r0] 0x73, %r9
	.word 0xd6ae09e0  ! 391: STBA_R	stba	%r11, [%r24 + %r0] 0x4f
	mov	0x0, %r25
	mov	0x7c8, %r21
	.word 0xda8d2000  ! 394: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r13
	.word 0xda956000  ! 395: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r13
	.word 0xdab56000  ! 396: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 397: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab6e000  ! 398: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	.word 0xdad66000  ! 399: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r13
	.word 0x87802072  ! 400: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd48e89e0  ! 401: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r10
	.word 0xdec4e000  ! 402: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	.word 0xdeb46000  ! 403: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0xded42000  ! 404: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	.word 0x87802073  ! 405: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 406: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d8, %r20
	.word 0xdad78e60  ! 408: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r13
	.word 0xdaa44400  ! 409: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0xdabf6000  ! 410: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xda872000  ! 411: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0x87802020  ! 412: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabe2000  ! 413: STDA_I	stda	%r13, [%r24 + 0x0000] %asi
	mov	0x20, %r18
	.word 0xd6be89e0  ! 415: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	.word 0xd686a000  ! 416: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r11
	mov	0x7c0, %r20
	mov	0x70, %r18
	.word 0xda8f0e60  ! 419: LDUBA_R	lduba	[%r28, %r0] 0x73, %r13
	.word 0xdead44a0  ! 420: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	mov	0x40, %r25
	.word 0xd6b6e000  ! 422: STHA_I	stha	%r11, [%r27 + 0x0000] %asi
	mov	0x60, %r27
	.word 0xd2bf8e80  ! 424: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	mov	0x10, %r18
	.word 0x87802025  ! 426: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r19
	.word 0xd09f6000  ! 428: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	.word 0xd0a7a000  ! 429: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd894c400  ! 430: LDUHA_R	lduha	[%r19, %r0] 0x20, %r12
	.word 0x8780204f  ! 431: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6ad6000  ! 432: STBA_I	stba	%r11, [%r21 + 0x0000] %asi
	.word 0xd68de000  ! 433: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 434: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd696e000  ! 436: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	mov	0x28, %r25
	.word 0xd6adc4a0  ! 438: STBA_R	stba	%r11, [%r23 + %r0] 0x25
	mov	0x3d8, %r23
	.word 0xdcc6a000  ! 440: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r14
	.word 0xd4bd04a0  ! 441: STDA_R	stda	%r10, [%r20 + %r0] 0x25
	.word 0xd2f40400  ! 442: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	mov	0x48, %r19
	.word 0xdea66000  ! 444: STWA_I	stwa	%r15, [%r25 + 0x0000] %asi
	mov	0x68, %r25
	mov	0x60, %r16
	.word 0xdeb66000  ! 447: STHA_I	stha	%r15, [%r25 + 0x0000] %asi
	.word 0xdedf8e40  ! 448: LDXA_R	ldxa	[%r30, %r0] 0x72, %r15
	mov	0x28, %r19
	.word 0xd4f7ce40  ! 450: STXA_R	stxa	%r10, [%r31 + %r0] 0x72
	.word 0x87802074  ! 451: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc944400  ! 452: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	mov	0x30, %r25
	.word 0xd8cc6000  ! 454: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r12
	mov	0x68, %r26
	.word 0xd2a4c400  ! 456: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0xd6874e40  ! 457: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r11
	mov	0x7c8, %r22
	.word 0xdabf0e60  ! 459: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	.word 0xdacc6000  ! 460: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	.word 0xd2afce60  ! 461: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	mov	0x3e0, %r23
	.word 0xdabc0400  ! 463: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xdaafce80  ! 464: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	.word 0xd28649e0  ! 465: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r9
	ta	T_CHANGE_PRIV	! macro
	ta	T_CHANGE_HPRIV	! macro
	mov	0x8, %r27
	mov	0x3d0, %r21
	.word 0xd2ac6000  ! 470: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd2c4e000  ! 471: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	mov	0x40, %r24
	.word 0xdc9f0e80  ! 473: LDDA_R	ldda	[%r28, %r0] 0x74, %r14
	.word 0xdab46000  ! 474: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0xd0f70e60  ! 475: STXA_R	stxa	%r8, [%r28 + %r0] 0x73
	.word 0xd69ce000  ! 476: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r11
	.word 0x87802025  ! 477: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6bca000  ! 478: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	.word 0xd6bc6000  ! 479: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0xd0b7ce40  ! 480: STHA_R	stha	%r8, [%r31 + %r0] 0x72
	.word 0xda94e000  ! 481: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r13
	.word 0xd6dc0400  ! 482: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7c8, %r21
	.word 0xde9f8e60  ! 485: LDDA_R	ldda	[%r30, %r0] 0x73, %r15
	mov	0x7e8, %r23
	mov	0x3c8, %r20
	.word 0x8780204f  ! 488: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f0, %r22
	.word 0xde9689e0  ! 490: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r15
	mov	0x3f0, %r20
	.word 0x87802072  ! 492: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4dfce80  ! 493: LDXA_R	ldxa	[%r31, %r0] 0x74, %r10
	.word 0xd6bce000  ! 494: STDA_I	stda	%r11, [%r19 + 0x0000] %asi
	.word 0xd0af0e80  ! 495: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	.word 0xd08504a0  ! 496: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r8
	mov	0x0, %r24
	mov	0x60, %r17
	.word 0xd6b46000  ! 499: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xda9c0400  ! 500: LDDA_R	ldda	[%r16, %r0] 0x20, %r13
	.word 0xd88fce40  ! 501: LDUBA_R	lduba	[%r31, %r0] 0x72, %r12
	mov	0x70, %r26
	.word 0xd8bcc400  ! 503: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x38, %r18
	.word 0x87802020  ! 506: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2df6000  ! 507: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0x87802073  ! 508: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2bf0e60  ! 509: STDA_R	stda	%r9, [%r28 + %r0] 0x73
	.word 0xdebf8e40  ! 510: STDA_R	stda	%r15, [%r30 + %r0] 0x72
	.word 0x87802072  ! 511: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd687ce40  ! 512: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r11
	.word 0x87802073  ! 513: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0cc8400  ! 514: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0xd4f7e000  ! 515: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xd2d48400  ! 516: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	.word 0xd4b7e000  ! 517: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd4f7e000  ! 518: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xd6b74e60  ! 519: STHA_R	stha	%r11, [%r29 + %r0] 0x73
	.word 0xdedfa000  ! 520: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x50, %r19
	.word 0xd28f0e40  ! 522: LDUBA_R	lduba	[%r28, %r0] 0x72, %r9
	mov	0x7f0, %r21
	.word 0xd8cf4e80  ! 524: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r12
	.word 0xd0dcc400  ! 525: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0xd2b76000  ! 526: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2b7e000  ! 527: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xdadc8400  ! 528: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	wr_tick_cmpr_2_1:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xdb, %g2
	or	%g4, 0xbb, %g4
	or	%g6, 0xe4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 530: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f56000  ! 531: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	mov	0x40, %r27
	.word 0xd4952000  ! 533: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r10
	.word 0xdebe89e0  ! 534: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	.word 0xd4f5c4a0  ! 535: STXA_R	stxa	%r10, [%r23 + %r0] 0x25
	.word 0xd2ad6000  ! 536: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	mov	0x10, %r17
	.word 0xd2bd2000  ! 538: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	mov	0x30, %r19
	.word 0xdef4c400  ! 540: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xdab689e0  ! 541: STHA_R	stha	%r13, [%r26 + %r0] 0x4f
	.word 0xdcd7ce60  ! 542: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r14
	.word 0x87802073  ! 543: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f76000  ! 544: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	mov	0x50, %r24
	.word 0xd6c76000  ! 546: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd48d04a0  ! 547: LDUBA_R	lduba	[%r20, %r0] 0x25, %r10
	.word 0xd4a72000  ! 548: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xdcccc400  ! 549: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	.word 0x87802020  ! 550: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48c4400  ! 551: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	mov	0x30, %r26
	.word 0xdadce000  ! 553: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	mov	0x3d0, %r21
	mov	0x60, %r27
	.word 0xdef74e60  ! 556: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	.word 0xded46000  ! 557: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	mov	0x8, %r17
	.word 0xdeace000  ! 559: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xdedc6000  ! 560: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r15
	mov	0x68, %r24
	.word 0x87802072  ! 562: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4878e40  ! 563: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r10
	mov	0x78, %r26
	.word 0x87802020  ! 565: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ada000  ! 566: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0xdab44400  ! 567: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0xd6d649e0  ! 568: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r11
	.word 0xd89da000  ! 569: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r12
	.word 0xdab74e60  ! 570: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	mov	0x18, %r26
	.word 0xd0a44400  ! 572: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	mov	0x3c8, %r23
	.word 0x87802073  ! 574: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xde9f8e60  ! 576: LDDA_R	ldda	[%r30, %r0] 0x73, %r15
	mov	0x50, %r17
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd69c6000  ! 579: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r11
	mov	0x68, %r19
	.word 0xd0b78e40  ! 581: STHA_R	stha	%r8, [%r30 + %r0] 0x72
	.word 0xd4840400  ! 582: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	.word 0xd0b4a000  ! 583: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xdc9f8e40  ! 584: LDDA_R	ldda	[%r30, %r0] 0x72, %r14
	mov	0x18, %r27
	.word 0xd4842000  ! 586: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	.word 0xd4bce000  ! 587: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xd4dc2000  ! 589: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	.word 0xd6f74e80  ! 590: STXA_R	stxa	%r11, [%r29 + %r0] 0x74
	mov	0x10, %r16
	mov	0x20, %r25
	.word 0xd48f8e40  ! 593: LDUBA_R	lduba	[%r30, %r0] 0x72, %r10
	mov	0x7c0, %r20
	.word 0xd6a70e80  ! 595: STWA_R	stwa	%r11, [%r28 + %r0] 0x74
	mov	0x0, %r18
	.word 0xdcb46000  ! 597: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xd8d74e80  ! 598: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r12
	.word 0xd6bf0e40  ! 599: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	.word 0xdcd4a000  ! 600: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	mov	0x60, %r16
	.word 0xdc9c2000  ! 602: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r14
	mov	0x40, %r17
	mov	0x40, %r17
	.word 0xd4b78e80  ! 605: STHA_R	stha	%r10, [%r30 + %r0] 0x74
	.word 0xded78e80  ! 606: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r15
	.word 0xd2a40400  ! 607: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0x87802074  ! 608: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b7a000  ! 609: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd2f7e000  ! 610: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 611: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf7ce80  ! 612: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	.word 0x87802072  ! 613: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b40400  ! 614: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0xd096a000  ! 615: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r8
	.word 0xd4978e60  ! 616: LDUHA_R	lduha	[%r30, %r0] 0x73, %r10
	.word 0xdaae2000  ! 617: STBA_I	stba	%r13, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 618: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4dc4400  ! 619: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	.word 0xd2afe000  ! 620: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	mov	0x0, %r27
	.word 0x87802073  ! 622: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r18
	mov	0x0, %r24
	.word 0xdcbfce60  ! 625: STDA_R	stda	%r14, [%r31 + %r0] 0x73
	.word 0xd6f544a0  ! 626: STXA_R	stxa	%r11, [%r21 + %r0] 0x25
	.word 0xdcbde000  ! 627: STDA_I	stda	%r14, [%r23 + 0x0000] %asi
	.word 0xdcc5a000  ! 628: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r14
	.word 0xdcbda000  ! 629: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	mov	0x58, %r25
	mov	0x3e0, %r21
	.word 0xdca56000  ! 632: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	mov	0x0, %r17
	.word 0xdeb544a0  ! 634: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	.word 0xdc8fce60  ! 635: LDUBA_R	lduba	[%r31, %r0] 0x73, %r14
	.word 0xd48d6000  ! 636: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r10
	.word 0xdeb74e40  ! 637: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	mov	0x30, %r19
	.word 0xdc852000  ! 639: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r14
	.word 0xdeac0400  ! 640: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xdebde000  ! 641: STDA_I	stda	%r15, [%r23 + 0x0000] %asi
	.word 0xdeb48400  ! 642: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xdac74e80  ! 643: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r13
	.word 0xd4b48400  ! 644: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0x87802074  ! 645: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2cea000  ! 646: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r9
	.word 0xd4970e80  ! 647: LDUHA_R	lduha	[%r28, %r0] 0x74, %r10
	wr_tick_cmpr_2_2:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf7, %g2
	or	%g4, 0xf8, %g4
	or	%g6, 0xa2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7c0, %r23
	.word 0xd8a6e000  ! 650: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 651: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88ca000  ! 652: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	.word 0xd8b46000  ! 653: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 654: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8b4a000  ! 655: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 656: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r18
	mov	0x58, %r26
	.word 0xd2bf8e80  ! 659: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	mov	0x58, %r27
	.word 0xde978e80  ! 661: LDUHA_R	lduha	[%r30, %r0] 0x74, %r15
	.word 0xd09fe000  ! 662: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	.word 0xd4df0e40  ! 663: LDXA_R	ldxa	[%r28, %r0] 0x72, %r10
	.word 0xdc9f2000  ! 664: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0x87802025  ! 665: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f0, %r23
	mov	0x3f0, %r20
	mov	0x68, %r24
	.word 0xdcad2000  ! 669: STBA_I	stba	%r14, [%r20 + 0x0000] %asi
	.word 0xd08dc4a0  ! 670: LDUBA_R	lduba	[%r23, %r0] 0x25, %r8
	.word 0xd4a70e60  ! 671: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	.word 0xdcbc0400  ! 672: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0x87802020  ! 673: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f46000  ! 674: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 675: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 676: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0cfe000  ! 677: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0x87802074  ! 678: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e8, %r21
	.word 0xdeac0400  ! 680: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	mov	0x0, %r27
	.word 0xd8ada000  ! 682: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xda974e80  ! 684: LDUHA_R	lduha	[%r29, %r0] 0x74, %r13
	.word 0xd0b78e60  ! 685: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	.word 0x87802074  ! 686: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 687: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 688: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b78e40  ! 689: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	.word 0x87802074  ! 690: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r22
	.word 0xde8cc400  ! 692: LDUBA_R	lduba	[%r19, %r0] 0x20, %r15
	mov	0x3e8, %r20
	.word 0xdc95e000  ! 694: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r14
	.word 0xd8c74e40  ! 695: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r12
	.word 0xde974e80  ! 696: LDUHA_R	lduha	[%r29, %r0] 0x74, %r15
	.word 0xdedd6000  ! 697: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r15
	.word 0xde9de000  ! 698: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r15
	.word 0x87802025  ! 699: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb56000  ! 700: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	.word 0xd4874e80  ! 701: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r10
	mov	0x30, %r19
	.word 0x87802074  ! 703: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda8d44a0  ! 704: LDUBA_R	lduba	[%r21, %r0] 0x25, %r13
	.word 0xd2df4e40  ! 705: LDXA_R	ldxa	[%r29, %r0] 0x72, %r9
	.word 0x87802074  ! 706: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcafe000  ! 707: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdcdfe000  ! 708: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xd4f4c400  ! 709: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd0af2000  ! 710: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	wr_tick_cmpr_2_3:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xff, %g2
	or	%g4, 0xc6, %g4
	or	%g6, 0xf0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x0, %r24
	.word 0xdec4c400  ! 713: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	.word 0x87802073  ! 714: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd28e2000  ! 715: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	mov	0x0, %r25
	.word 0xd2c62000  ! 717: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r9
	.word 0xd2ce2000  ! 718: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 719: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f0, %r20
	.word 0xd28ca000  ! 721: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0x87802074  ! 722: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r26
	.word 0xd0d78e40  ! 724: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r8
	.word 0xd8ae89e0  ! 725: STBA_R	stba	%r12, [%r26 + %r0] 0x4f
	mov	0x78, %r16
	.word 0xd4dce000  ! 727: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	.word 0x87802020  ! 728: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4df6000  ! 729: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0xdef48400  ! 730: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0x87802020  ! 731: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r20
	.word 0xd2ac6000  ! 733: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd6d649e0  ! 734: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r11
	wr_tick_cmpr_2_4:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x97, %g2
	or	%g4, 0xce, %g4
	or	%g6, 0xa9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd6f7ce80  ! 736: STXA_R	stxa	%r11, [%r31 + %r0] 0x74
	mov	0x7c8, %r20
	mov	0x58, %r25
	.word 0xdadc4400  ! 739: LDXA_R	ldxa	[%r17, %r0] 0x20, %r13
	.word 0xd2a7ce60  ! 740: STWA_R	stwa	%r9, [%r31 + %r0] 0x73
	.word 0xd884e000  ! 741: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r12
	mov	0x58, %r26
	.word 0xd884e000  ! 743: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r12
	.word 0xd6b7ce40  ! 744: STHA_R	stha	%r11, [%r31 + %r0] 0x72
	.word 0xd4bc2000  ! 745: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0xd4bce000  ! 746: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	mov	0x50, %r16
	.word 0xd8c70e80  ! 748: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r12
	mov	0x40, %r19
	mov	0x7d0, %r21
	.word 0x87802072  ! 751: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 752: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeafa000  ! 753: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xd4dc0400  ! 754: LDXA_R	ldxa	[%r16, %r0] 0x20, %r10
	.word 0x87802025  ! 755: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d8, %r22
	mov	0x40, %r26
	mov	0x68, %r19
	.word 0xd29d04a0  ! 759: LDDA_R	ldda	[%r20, %r0] 0x25, %r9
	.word 0xdcc66000  ! 760: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	.word 0xdebd04a0  ! 761: STDA_R	stda	%r15, [%r20 + %r0] 0x25
	.word 0xd4de2000  ! 762: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r10
	.word 0xdab70e80  ! 763: STHA_R	stha	%r13, [%r28 + %r0] 0x74
	.word 0xdac70e80  ! 764: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r13
	.word 0x8780204f  ! 765: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde87a000  ! 766: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xdeafe000  ! 767: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0x87802020  ! 769: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r16
	.word 0x87802020  ! 771: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad78e60  ! 772: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r13
	.word 0xd48fa000  ! 773: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xd4f72000  ! 774: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4c76000  ! 775: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4a7a000  ! 776: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4b72000  ! 777: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	mov	0x3f0, %r20
	.word 0xd4df6000  ! 779: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4a72000  ! 780: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4872000  ! 781: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0xd6c70e80  ! 782: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r11
	.word 0xd8f74e80  ! 783: STXA_R	stxa	%r12, [%r29 + %r0] 0x74
	.word 0xdaa7ce40  ! 784: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	mov	0x7e8, %r20
	.word 0xd0844400  ! 786: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r8
	mov	0x3f8, %r22
	.word 0xd08fe000  ! 788: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	mov	0x48, %r19
	.word 0xd6bc8400  ! 790: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xd4df6000  ! 791: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	mov	0x7c0, %r23
	mov	0x20, %r17
	.word 0xd0bf4e40  ! 794: STDA_R	stda	%r8, [%r29 + %r0] 0x72
	mov	0x40, %r19
	.word 0xdeb72000  ! 796: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xde9fe000  ! 797: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0xdedc4400  ! 798: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	.word 0xd087a000  ! 799: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0xdca504a0  ! 800: STWA_R	stwa	%r14, [%r20 + %r0] 0x25
	.word 0xd6cfa000  ! 801: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0xd6af6000  ! 802: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xd4cf0e80  ! 804: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r10
	.word 0xded7e000  ! 805: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	mov	0x18, %r25
	.word 0x87802025  ! 807: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r16
	.word 0xdeb4a000  ! 809: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	wr_tick_cmpr_2_5:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x84, %g2
	or	%g4, 0xe3, %g4
	or	%g6, 0xfb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdedca000  ! 811: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xdef4e000  ! 812: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xde846000  ! 813: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0x87802072  ! 814: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b5c4a0  ! 815: STHA_R	stha	%r8, [%r23 + %r0] 0x25
	.word 0xdcc584a0  ! 816: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r14
	mov	0x3f8, %r21
	.word 0xdcf48400  ! 818: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xd4cf4e40  ! 819: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r10
	mov	0x3f8, %r20
	.word 0x8780204f  ! 821: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6ada000  ! 822: STBA_I	stba	%r11, [%r22 + 0x0000] %asi
	.word 0xd2d7ce40  ! 823: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r9
	mov	0x48, %r26
	mov	0x70, %r19
	.word 0x87802073  ! 826: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 827: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r18
	mov	0x48, %r25
	.word 0xd4bca000  ! 830: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	mov	0x8, %r24
	mov	0x3c8, %r23
	mov	0x3f0, %r22
	.word 0xdebf4e60  ! 834: STDA_R	stda	%r15, [%r29 + %r0] 0x73
	.word 0xdede89e0  ! 835: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r15
	.word 0xd8c48400  ! 836: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	mov	0x18, %r26
	.word 0xd4ac2000  ! 838: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0xd49ca000  ! 839: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xded609e0  ! 840: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r15
	.word 0xd8af0e60  ! 841: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	.word 0xd084a000  ! 842: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	.word 0xd4dfce80  ! 843: LDXA_R	ldxa	[%r31, %r0] 0x74, %r10
	.word 0x87802020  ! 844: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 845: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r16
	mov	0x3d0, %r22
	.word 0x87802020  ! 848: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8f8e80  ! 849: LDUBA_R	lduba	[%r30, %r0] 0x74, %r13
	mov	0x7e8, %r22
	.word 0xd6b6c9e0  ! 851: STHA_R	stha	%r11, [%r27 + %r0] 0x4f
	.word 0xdcbc6000  ! 852: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xdcbce000  ! 853: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	mov	0x10, %r24
	mov	0x48, %r25
	.word 0xdca46000  ! 856: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 857: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf4a000  ! 858: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xde9584a0  ! 859: LDUHA_R	lduha	[%r22, %r0] 0x25, %r15
	.word 0x8780204f  ! 860: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f62000  ! 861: STXA_I	stxa	%r8, [%r24 + 0x0000] %asi
	.word 0xd0dea000  ! 862: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r8
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdcbf8e60  ! 864: STDA_R	stda	%r14, [%r30 + %r0] 0x73
	.word 0x87802025  ! 865: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xded4a000  ! 866: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	.word 0xdecc2000  ! 867: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	.word 0xdef46000  ! 868: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	mov	0x7f8, %r20
	.word 0xd6de09e0  ! 870: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r11
	.word 0xda842000  ! 871: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r13
	mov	0x60, %r26
	.word 0x8780204f  ! 873: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r26
	mov	0x70, %r17
	.word 0xdca44400  ! 876: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0x87802025  ! 877: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 878: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r27
	.word 0x87802074  ! 880: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc9e89e0  ! 881: LDDA_R	ldda	[%r26, %r0] 0x4f, %r14
	.word 0xd8be89e0  ! 882: STDA_R	stda	%r12, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 883: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 884: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f0, %r20
	.word 0xd4a44400  ! 886: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xdca74e40  ! 887: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	.word 0xd49ea000  ! 888: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	mov	0x70, %r17
	.word 0xd4a48400  ! 890: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xd2944400  ! 891: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	.word 0xd69e6000  ! 892: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r11
	.word 0xd6b6a000  ! 893: STHA_I	stha	%r11, [%r26 + 0x0000] %asi
	.word 0xd2c5c4a0  ! 894: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r9
	.word 0xd89dc4a0  ! 895: LDDA_R	ldda	[%r23, %r0] 0x25, %r12
	.word 0xd8dfce80  ! 896: LDXA_R	ldxa	[%r31, %r0] 0x74, %r12
	.word 0xdea6a000  ! 897: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0xdece2000  ! 899: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r15
	.word 0x87802020  ! 900: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r22
	.word 0xdea76000  ! 902: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	mov	0x3f8, %r21
	mov	0x38, %r25
	.word 0x87802020  ! 905: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 906: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f70e40  ! 907: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	.word 0xdcb7ce40  ! 908: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	.word 0xdecc6000  ! 909: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r15
	.word 0xdec4e000  ! 910: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	.word 0xdecc6000  ! 911: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r15
	.word 0xde842000  ! 912: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	mov	0x28, %r17
	.word 0xd8df8e40  ! 914: LDXA_R	ldxa	[%r30, %r0] 0x72, %r12
	.word 0x87802025  ! 915: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e0, %r23
	.word 0xd0bd6000  ! 917: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0xd4bc4400  ! 918: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0xd2ada000  ! 919: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xd8c40400  ! 920: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	.word 0xd8d4c400  ! 921: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0xd4b7ce60  ! 922: STHA_R	stha	%r10, [%r31 + %r0] 0x73
	.word 0xd2b52000  ! 923: STHA_I	stha	%r9, [%r20 + 0x0000] %asi
	.word 0xd2f40400  ! 924: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	mov	0x20, %r27
	mov	0x3d8, %r22
	.word 0xdaf544a0  ! 927: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	mov	0x70, %r25
	mov	0x3e0, %r20
	.word 0xd6952000  ! 930: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r11
	.word 0xd6a56000  ! 931: STWA_I	stwa	%r11, [%r21 + 0x0000] %asi
	.word 0xd69d6000  ! 932: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r11
	.word 0xd48c8400  ! 933: LDUBA_R	lduba	[%r18, %r0] 0x20, %r10
	mov	0x7d0, %r22
	mov	0x3f8, %r23
	.word 0xdcd52000  ! 936: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r14
	.word 0xd4b70e40  ! 937: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	.word 0xd4dd2000  ! 938: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r10
	.word 0xd485e000  ! 939: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r10
	.word 0xd48da000  ! 940: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r10
	mov	0x38, %r16
	mov	0x40, %r16
	.word 0xd4d56000  ! 943: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r10
	.word 0xd6d689e0  ! 944: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r11
	.word 0xd6d5e000  ! 945: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r11
	.word 0xdebe89e0  ! 946: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	.word 0xd8d74e80  ! 947: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r12
	.word 0xdeb5a000  ! 948: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	mov	0x48, %r19
	.word 0xd4b4c400  ! 950: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	mov	0x10, %r24
	.word 0xd28de000  ! 952: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r9
	.word 0xd2970e40  ! 953: LDUHA_R	lduha	[%r28, %r0] 0x72, %r9
	.word 0xd4cf0e60  ! 954: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r10
	.word 0xdeb5e000  ! 955: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xd6bc8400  ! 957: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0x87802025  ! 958: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r19
	.word 0xdcbfe000  ! 960: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 961: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf7e000  ! 962: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xd2b70e80  ! 963: STHA_R	stha	%r9, [%r28 + %r0] 0x74
	.word 0xd287e000  ! 964: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0xd28fe000  ! 965: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	mov	0x3e8, %r20
	.word 0xd2bf2000  ! 967: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 968: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r26
	mov	0x48, %r17
	.word 0xdecfce60  ! 971: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r15
	.word 0xdcbea000  ! 972: STDA_I	stda	%r14, [%r26 + 0x0000] %asi
	mov	0x18, %r18
	mov	0x30, %r24
	.word 0x8780204f  ! 975: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcc76000  ! 976: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xded74e60  ! 977: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r15
	.word 0xd6b74e40  ! 978: STHA_R	stha	%r11, [%r29 + %r0] 0x72
	.word 0xd2afa000  ! 979: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xdc8c8400  ! 980: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0xda85c4a0  ! 981: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r13
	.word 0x87802020  ! 982: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 983: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r17
	.word 0xd6a74e80  ! 985: STWA_R	stwa	%r11, [%r29 + %r0] 0x74
	.word 0xd4d7e000  ! 986: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	.word 0xd6ad84a0  ! 987: STBA_R	stba	%r11, [%r22 + %r0] 0x25
	.word 0xd6af2000  ! 988: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x28, %r25
	.word 0xd6af2000  ! 990: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x3e8, %r22
	ta	T_CHANGE_PRIV	! macro
	.word 0xd6b40400  ! 993: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xd6c544a0  ! 994: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r11
	.word 0x87802020  ! 995: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r20
	.word 0xd8b44400  ! 997: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0x87802073  ! 998: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 999: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r26
	.word 0xd697e000  ! 1001: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	mov	0x10, %r19
	.word 0x87802072  ! 1003: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r26
	.word 0x8780204f  ! 1005: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4874e80  ! 1006: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r10
	mov	0x7d8, %r21
	.word 0xd6856000  ! 1008: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r11
	mov	0x68, %r18
	mov	0x28, %r18
	.word 0xd0de49e0  ! 1011: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r8
	.word 0xdc8d6000  ! 1012: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r14
	.word 0xd29fce80  ! 1013: LDDA_R	ldda	[%r31, %r0] 0x74, %r9
	.word 0x87802072  ! 1014: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb42000  ! 1015: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 1016: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1017: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc942000  ! 1018: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	.word 0x87802074  ! 1019: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28f4e60  ! 1020: LDUBA_R	lduba	[%r29, %r0] 0x73, %r9
	.word 0xd0f46000  ! 1021: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0940400  ! 1022: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	mov	0x7d8, %r20
	mov	0x8, %r25
	.word 0xd2942000  ! 1025: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2cc6000  ! 1026: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	mov	0x48, %r18
	.word 0xd28ce000  ! 1028: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	.word 0xd2a46000  ! 1029: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2bc2000  ! 1030: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xd2b504a0  ! 1031: STHA_R	stha	%r9, [%r20 + %r0] 0x25
	.word 0xda8e09e0  ! 1032: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r13
	.word 0xd0c584a0  ! 1033: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r8
	.word 0xd68649e0  ! 1034: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r11
	.word 0xdcd74e40  ! 1035: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r14
	.word 0xde8ca000  ! 1036: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0xd4bc0400  ! 1037: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	mov	0x60, %r17
	.word 0xd4df8e80  ! 1039: LDXA_R	ldxa	[%r30, %r0] 0x74, %r10
	.word 0xd8ac6000  ! 1040: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	mov	0x50, %r27
	mov	0x3e0, %r21
	.word 0xd2bc0400  ! 1043: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	mov	0x7c8, %r22
	.word 0xd49584a0  ! 1045: LDUHA_R	lduha	[%r22, %r0] 0x25, %r10
	.word 0xd084a000  ! 1046: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	.word 0xd68f0e40  ! 1047: LDUBA_R	lduba	[%r28, %r0] 0x72, %r11
	mov	0x0, %r19
	.word 0xd8ace000  ! 1049: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	mov	0x20, %r18
	.word 0xd8a4a000  ! 1051: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd88ce000  ! 1052: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	.word 0xdec40400  ! 1053: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xd28ce000  ! 1054: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	.word 0x87802072  ! 1055: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 1056: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 1057: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2c4e000  ! 1058: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xd2bce000  ! 1059: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xd2f42000  ! 1060: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0xd2f4e000  ! 1061: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2cce000  ! 1062: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	.word 0xd2cc2000  ! 1063: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r9
	mov	0x18, %r16
	.word 0xd2c4e000  ! 1065: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xd28c6000  ! 1066: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0xdeb40400  ! 1067: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0xd8b4a000  ! 1068: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	mov	0x30, %r16
	.word 0xd8bce000  ! 1070: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 1071: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r26
	mov	0x0, %r25
	.word 0xdcc40400  ! 1074: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	.word 0x87802073  ! 1075: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda976000  ! 1076: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	.word 0xda87e000  ! 1077: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0xdaafe000  ! 1078: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xd2f48400  ! 1079: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	mov	0x30, %r24
	.word 0xd0bfe000  ! 1081: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd0af2000  ! 1082: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	mov	0x28, %r19
	.word 0xdab544a0  ! 1084: STHA_R	stha	%r13, [%r21 + %r0] 0x25
	wr_tick_cmpr_2_6:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe6, %g2
	or	%g4, 0xe6, %g4
	or	%g6, 0x8f, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0f7e000  ! 1086: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	mov	0x70, %r25
	mov	0x7f0, %r21
	.word 0xd885c4a0  ! 1089: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r12
	.word 0xd6a78e80  ! 1090: STWA_R	stwa	%r11, [%r30 + %r0] 0x74
	.word 0xd4cf2000  ! 1091: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd895c4a0  ! 1092: LDUHA_R	lduha	[%r23, %r0] 0x25, %r12
	mov	0x68, %r19
	wr_tick_cmpr_2_7:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xcf, %g2
	or	%g4, 0x97, %g4
	or	%g6, 0xf9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2dfa000  ! 1095: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0x87802025  ! 1096: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd28c6000  ! 1097: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0xd29ca000  ! 1098: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	mov	0x8, %r19
	mov	0x18, %r26
	.word 0xd2a42000  ! 1101: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	mov	0x68, %r18
	.word 0x87802073  ! 1103: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6df4e80  ! 1104: LDXA_R	ldxa	[%r29, %r0] 0x74, %r11
	.word 0xdcdf8e80  ! 1105: LDXA_R	ldxa	[%r30, %r0] 0x74, %r14
	.word 0xded6a000  ! 1106: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r15
	mov	0x50, %r26
	.word 0x87802020  ! 1108: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeac2000  ! 1109: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xdec42000  ! 1110: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	ta	T_CHANGE_PRIV	! macro
	.word 0xdef46000  ! 1112: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 1113: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde8fce80  ! 1114: LDUBA_R	lduba	[%r31, %r0] 0x74, %r15
	.word 0xd6b42000  ! 1115: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0xd6b74e40  ! 1116: STHA_R	stha	%r11, [%r29 + %r0] 0x72
	.word 0xdaac8400  ! 1117: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0xdaa4e000  ! 1118: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0xdaf42000  ! 1119: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0xda9c6000  ! 1120: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xda842000  ! 1121: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r13
	.word 0xd8f609e0  ! 1122: STXA_R	stxa	%r12, [%r24 + %r0] 0x4f
	mov	0x38, %r27
	.word 0xdeace000  ! 1124: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xdecce000  ! 1125: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	.word 0xdea46000  ! 1126: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	mov	0x40, %r25
	.word 0xd8c5c4a0  ! 1128: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r12
	mov	0x3e0, %r23
	.word 0xd4cca000  ! 1130: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r10
	mov	0x3f0, %r20
	.word 0xd4a46000  ! 1132: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 1133: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f4c400  ! 1134: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xd09f0e60  ! 1135: LDDA_R	ldda	[%r28, %r0] 0x73, %r8
	.word 0xdef7a000  ! 1136: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 1137: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xded76000  ! 1138: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0xdadcc400  ! 1139: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xd29c4400  ! 1140: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	.word 0x87802020  ! 1141: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r22
	mov	0x10, %r24
	.word 0xdcf5e000  ! 1144: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 1145: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_2_8:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe1, %g2
	or	%g4, 0xfd, %g4
	or	%g6, 0x99, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x78, %r26
	.word 0xdcb76000  ! 1148: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xd6d78e80  ! 1149: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r11
	.word 0x87802073  ! 1150: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r16
	.word 0xdcada000  ! 1152: STBA_I	stba	%r14, [%r22 + 0x0000] %asi
	.word 0xdcdd2000  ! 1153: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r14
	.word 0xdcc56000  ! 1154: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r14
	ta	T_CHANGE_PRIV	! macro
	.word 0xdcdd2000  ! 1156: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r14
	.word 0xdcbda000  ! 1157: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	.word 0xd0aec9e0  ! 1158: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	.word 0x87802073  ! 1159: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r19
	.word 0xdcafce80  ! 1161: STBA_R	stba	%r14, [%r31 + %r0] 0x74
	mov	0x3c0, %r22
	mov	0x40, %r19
	.word 0xd2ac8400  ! 1164: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	mov	0x48, %r26
	.word 0xde8e89e0  ! 1166: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r15
	.word 0xdea74e80  ! 1167: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xda8f4e60  ! 1169: LDUBA_R	lduba	[%r29, %r0] 0x73, %r13
	mov	0x0, %r19
	.word 0xdef76000  ! 1171: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdea7a000  ! 1172: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xdef72000  ! 1173: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xd4cf0e60  ! 1174: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r10
	.word 0xd2b72000  ! 1175: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	mov	0x30, %r18
	.word 0xd685c4a0  ! 1177: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r11
	mov	0x3c8, %r20
	.word 0x87802025  ! 1179: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd08f4e80  ! 1180: LDUBA_R	lduba	[%r29, %r0] 0x74, %r8
	.word 0x87802020  ! 1181: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r18
	mov	0x78, %r24
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd087ce80  ! 1185: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r8
	.word 0xd4bfce80  ! 1186: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	.word 0xd8ae09e0  ! 1187: STBA_R	stba	%r12, [%r24 + %r0] 0x4f
	mov	0x28, %r27
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802020  ! 1190: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1191: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4cf8e80  ! 1192: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r10
	.word 0x87802020  ! 1193: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc97a000  ! 1194: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	.word 0xdcbf2000  ! 1195: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xd2cfce80  ! 1196: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r9
	.word 0xdebd44a0  ! 1197: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	.word 0xdef78e60  ! 1198: STXA_R	stxa	%r15, [%r30 + %r0] 0x73
	.word 0xd2b7e000  ! 1199: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xde8d44a0  ! 1200: LDUBA_R	lduba	[%r21, %r0] 0x25, %r15
	.word 0xd0bfa000  ! 1201: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0xdad689e0  ! 1202: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r13
	.word 0xd09fa000  ! 1203: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	.word 0xd09fe000  ! 1204: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	.word 0xdeb544a0  ! 1205: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	.word 0xd6cf2000  ! 1206: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	mov	0x78, %r27
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd69f2000  ! 1209: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xd6b4c400  ! 1210: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	mov	0x58, %r27
	mov	0x38, %r17
	.word 0xd6afe000  ! 1213: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0xd6b76000  ! 1215: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1216: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6dee000  ! 1217: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r11
	.word 0xd6cea000  ! 1218: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	.word 0xd6b62000  ! 1219: STHA_I	stha	%r11, [%r24 + 0x0000] %asi
	.word 0xd8cf4e80  ! 1220: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r12
	.word 0xd0b62000  ! 1221: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0xd0ae89e0  ! 1222: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	mov	0x58, %r27
	.word 0xd4be6000  ! 1224: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 1225: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r21
	.word 0x87802072  ! 1227: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r16
	.word 0xd8c74e60  ! 1229: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r12
	.word 0xdece09e0  ! 1230: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r15
	mov	0x7e8, %r22
	.word 0xd4ae09e0  ! 1232: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	mov	0x7f0, %r23
	mov	0x3e0, %r20
	mov	0x10, %r25
	.word 0xd2d74e40  ! 1236: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r9
	mov	0x3e0, %r22
	.word 0xdca48400  ! 1238: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xd0f76000  ! 1239: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 1240: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 1241: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r16
	.word 0xd296c9e0  ! 1243: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r9
	mov	0x7e0, %r23
	.word 0xd2876000  ! 1245: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2af6000  ! 1246: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd2c72000  ! 1247: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2bfe000  ! 1248: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd2bfe000  ! 1249: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xdcdd44a0  ! 1250: LDXA_R	ldxa	[%r21, %r0] 0x25, %r14
	.word 0x87802072  ! 1251: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r19
	.word 0xd8dc8400  ! 1253: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xdc8f2000  ! 1254: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0xdc8fa000  ! 1255: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdcb7a000  ! 1256: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xd6b70e40  ! 1257: STHA_R	stha	%r11, [%r28 + %r0] 0x72
	.word 0xd8cf2000  ! 1258: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	wr_tick_cmpr_2_9:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xbd, %g2
	or	%g4, 0xa9, %g4
	or	%g6, 0xe0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xde874e80  ! 1260: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r15
	.word 0xdc8fa000  ! 1261: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xd2948400  ! 1262: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	.word 0xdccf2000  ! 1263: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xdcaf4e40  ! 1264: STBA_R	stba	%r14, [%r29 + %r0] 0x72
	mov	0x10, %r19
	mov	0x60, %r17
	.word 0xdaae49e0  ! 1267: STBA_R	stba	%r13, [%r25 + %r0] 0x4f
	.word 0xdab48400  ! 1268: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	wr_tick_cmpr_2_10:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe3, %g2
	or	%g4, 0x97, %g4
	or	%g6, 0xae, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4f72000  ! 1270: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 1271: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 1272: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd495e000  ! 1273: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r10
	ta	T_CHANGE_HPRIV	! macro
	mov	0x3d0, %r23
	.word 0xd0af4e80  ! 1276: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	.word 0x87802074  ! 1277: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 1278: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r18
	mov	0x7f8, %r20
	.word 0xd28ce000  ! 1281: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1282: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08d44a0  ! 1283: LDUBA_R	lduba	[%r21, %r0] 0x25, %r8
	.word 0xd8c72000  ! 1284: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd4870e60  ! 1285: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r10
	mov	0x30, %r17
	.word 0x87802025  ! 1287: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0df2000  ! 1288: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0x87802072  ! 1289: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6ac8400  ! 1290: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x70, %r19
	.word 0xd4df0e60  ! 1293: LDXA_R	ldxa	[%r28, %r0] 0x73, %r10
	.word 0x87802020  ! 1294: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f4c400  ! 1295: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xdccdc4a0  ! 1296: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r14
	.word 0xd6a72000  ! 1297: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	mov	0x78, %r27
	.word 0xd4ac8400  ! 1299: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0xdca72000  ! 1300: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xd0bcc400  ! 1301: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	mov	0x7f8, %r22
	.word 0x87802020  ! 1303: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1304: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r21
	.word 0xd0842000  ! 1306: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r8
	.word 0xdcb584a0  ! 1307: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	mov	0x30, %r19
	.word 0x8780204f  ! 1309: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r25
	.word 0xd8c48400  ! 1311: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	.word 0xd8dde000  ! 1312: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r12
	.word 0xd2cf0e60  ! 1313: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r9
	mov	0x8, %r19
	.word 0xdeada000  ! 1315: STBA_I	stba	%r15, [%r22 + 0x0000] %asi
	.word 0xd6a7ce40  ! 1316: STWA_R	stwa	%r11, [%r31 + %r0] 0x72
	mov	0x28, %r17
	mov	0x70, %r24
	.word 0x8780204f  ! 1319: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4870e80  ! 1320: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r10
	.word 0xd68c4400  ! 1321: LDUBA_R	lduba	[%r17, %r0] 0x20, %r11
	.word 0xdcbf8e40  ! 1322: STDA_R	stda	%r14, [%r30 + %r0] 0x72
	.word 0xd4bca000  ! 1323: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0xd4ac6000  ! 1324: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	.word 0xd4846000  ! 1325: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r10
	mov	0x78, %r17
	.word 0xdaf78e80  ! 1327: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	.word 0xd4f42000  ! 1328: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 1329: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48e49e0  ! 1330: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r10
	.word 0xd0d4a000  ! 1331: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	.word 0xd68f4e40  ! 1332: LDUBA_R	lduba	[%r29, %r0] 0x72, %r11
	mov	0x28, %r16
	.word 0xda9c2000  ! 1334: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	wr_tick_cmpr_2_11:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe3, %g2
	or	%g4, 0xe5, %g4
	or	%g6, 0xe8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 1336: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdadda000  ! 1337: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r13
	.word 0xd69f8e40  ! 1338: LDDA_R	ldda	[%r30, %r0] 0x72, %r11
	.word 0xd8f56000  ! 1339: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	.word 0xd8f44400  ! 1340: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xd8b5e000  ! 1341: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	.word 0xd8978e40  ! 1342: LDUHA_R	lduha	[%r30, %r0] 0x72, %r12
	.word 0xdaf5e000  ! 1343: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 1344: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca4c400  ! 1345: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	mov	0x30, %r26
	mov	0x60, %r18
	.word 0xdcc4e000  ! 1348: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r14
	.word 0xdc94e000  ! 1349: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	.word 0xd2a689e0  ! 1350: STWA_R	stwa	%r9, [%r26 + %r0] 0x4f
	mov	0x3e8, %r23
	mov	0x78, %r25
	.word 0xd0bca000  ! 1353: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0xd0aca000  ! 1354: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xd6878e80  ! 1355: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r11
	.word 0xdc942000  ! 1356: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	mov	0x7f0, %r20
	.word 0xdac70e80  ! 1358: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r13
	.word 0x87802020  ! 1359: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r22
	.word 0xd6aca000  ! 1361: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	mov	0x60, %r17
	.word 0x87802073  ! 1363: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f42000  ! 1364: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	mov	0x60, %r26
	.word 0xd0a7ce40  ! 1366: STWA_R	stwa	%r8, [%r31 + %r0] 0x72
	.word 0x87802073  ! 1367: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf40400  ! 1368: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xd8b7e000  ! 1369: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 1370: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8dcc400  ! 1371: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	.word 0xd2a4c400  ! 1372: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0xd2876000  ! 1373: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xd08689e0  ! 1374: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r8
	mov	0x7f8, %r22
	.word 0xdc978e80  ! 1376: LDUHA_R	lduha	[%r30, %r0] 0x74, %r14
	.word 0xd8f76000  ! 1377: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd2bd44a0  ! 1378: STDA_R	stda	%r9, [%r21 + %r0] 0x25
	.word 0xdabcc400  ! 1379: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	.word 0x87802020  ! 1380: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1381: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r17
	.word 0xdcb70e40  ! 1383: STHA_R	stha	%r14, [%r28 + %r0] 0x72
	.word 0xd2b48400  ! 1384: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd6946000  ! 1385: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 1386: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1387: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r24
	mov	0x3c8, %r21
	.word 0xdcb40400  ! 1390: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xd4b44400  ! 1391: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	.word 0xd4f4c400  ! 1392: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd8bf4e40  ! 1393: STDA_R	stda	%r12, [%r29 + %r0] 0x72
	.word 0xd08f0e60  ! 1394: LDUBA_R	lduba	[%r28, %r0] 0x73, %r8
	mov	0x28, %r18
	.word 0xd6f70e40  ! 1396: STXA_R	stxa	%r11, [%r28 + %r0] 0x72
	.word 0xdcd7e000  ! 1397: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	mov	0x28, %r18
	.word 0x87802073  ! 1399: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r25
	mov	0x78, %r25
	.word 0xdcf48400  ! 1402: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xd4978e60  ! 1403: LDUHA_R	lduha	[%r30, %r0] 0x73, %r10
	.word 0xd8a78e40  ! 1404: STWA_R	stwa	%r12, [%r30 + %r0] 0x72
	mov	0x28, %r19
	.word 0xd2ad84a0  ! 1406: STBA_R	stba	%r9, [%r22 + %r0] 0x25
	.word 0xdc846000  ! 1407: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	.word 0xd8870e80  ! 1408: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r12
	.word 0xd2bce000  ! 1409: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xd0be89e0  ! 1410: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	mov	0x10, %r17
	mov	0x28, %r17
	.word 0xdc8ce000  ! 1413: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	.word 0xd6be09e0  ! 1414: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	.word 0xd6f42000  ! 1415: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 1416: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb74e40  ! 1417: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	.word 0xd6afce40  ! 1418: STBA_R	stba	%r11, [%r31 + %r0] 0x72
	.word 0xd4f4c400  ! 1419: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd0bfa000  ! 1420: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0xd0976000  ! 1422: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0c72000  ! 1423: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0x87802074  ! 1424: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0c7e000  ! 1425: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0af6000  ! 1426: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 1427: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0af4e80  ! 1428: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	mov	0x50, %r25
	.word 0xd28c4400  ! 1430: LDUBA_R	lduba	[%r17, %r0] 0x20, %r9
	wr_tick_cmpr_2_12:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xa8, %g2
	or	%g4, 0xdc, %g4
	or	%g6, 0xd7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3c8, %r21
	.word 0x87802073  ! 1433: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde9e2000  ! 1434: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r15
	.word 0x87802072  ! 1435: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde876000  ! 1436: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xdc9dc4a0  ! 1437: LDDA_R	ldda	[%r23, %r0] 0x25, %r14
	.word 0x87802074  ! 1438: WRASI_I	wr	%r0, 0x0074, %asi
	wr_tick_cmpr_2_13:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc5, %g2
	or	%g4, 0xe7, %g4
	or	%g6, 0xf6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0bcc400  ! 1440: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0xd0df6000  ! 1441: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	mov	0x3f0, %r23
	.word 0xd09f2000  ! 1443: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0x87802072  ! 1444: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0bf6000  ! 1445: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd48fce60  ! 1446: LDUBA_R	lduba	[%r31, %r0] 0x73, %r10
	.word 0xde97ce40  ! 1447: LDUHA_R	lduha	[%r31, %r0] 0x72, %r15
	.word 0xd09f6000  ! 1448: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	mov	0x18, %r24
	mov	0x3f8, %r21
	mov	0x8, %r19
	.word 0xd2ad04a0  ! 1452: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	.word 0xd4b72000  ! 1453: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd49f2000  ! 1454: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xde9e49e0  ! 1455: LDDA_R	ldda	[%r25, %r0] 0x4f, %r15
	mov	0x3c8, %r20
	.word 0x8780204f  ! 1457: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd49fce40  ! 1458: LDDA_R	ldda	[%r31, %r0] 0x72, %r10
	.word 0xd2b76000  ! 1459: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xdc9f0e40  ! 1460: LDDA_R	ldda	[%r28, %r0] 0x72, %r14
	.word 0xd4cfa000  ! 1461: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1462: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b72000  ! 1463: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd0ce49e0  ! 1464: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r8
	mov	0x0, %r19
	.word 0xd0cfe000  ! 1466: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	mov	0x10, %r16
	.word 0xd0f7e000  ! 1468: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0f7e000  ! 1469: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd09fce60  ! 1470: LDDA_R	ldda	[%r31, %r0] 0x73, %r8
	.word 0x87802072  ! 1471: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xded44400  ! 1472: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	.word 0xdcafce80  ! 1473: STBA_R	stba	%r14, [%r31 + %r0] 0x74
	.word 0xd28fce80  ! 1474: LDUBA_R	lduba	[%r31, %r0] 0x74, %r9
	mov	0x30, %r19
	.word 0xd88ca000  ! 1476: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	.word 0xd8b42000  ! 1477: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	mov	0x58, %r27
	mov	0x3d0, %r21
	.word 0xd8f42000  ! 1480: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8dce000  ! 1481: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	.word 0x87802074  ! 1482: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd88d6000  ! 1483: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r12
	mov	0x48, %r17
	.word 0xd8c5a000  ! 1485: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 1486: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bf4e80  ! 1487: STDA_R	stda	%r10, [%r29 + %r0] 0x74
	mov	0x50, %r16
	.word 0xd09c2000  ! 1489: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r8
	mov	0x50, %r19
	.word 0xd2cf0e40  ! 1491: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r9
	.word 0xd0b42000  ! 1492: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 1493: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 1494: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbf4e40  ! 1495: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	.word 0xd4be49e0  ! 1496: STDA_R	stda	%r10, [%r25 + %r0] 0x4f
	.word 0x87802025  ! 1497: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r25
	.word 0x87802025  ! 1499: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0bf0e60  ! 1500: STDA_R	stda	%r8, [%r28 + %r0] 0x73
	.word 0xd497ce80  ! 1501: LDUHA_R	lduha	[%r31, %r0] 0x74, %r10
	mov	0x78, %r19
	.word 0x87802025  ! 1503: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 1504: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 1505: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbf0e60  ! 1506: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	mov	0x7e8, %r23
	.word 0xdccce000  ! 1508: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r14
	.word 0xd2afce40  ! 1509: STBA_R	stba	%r9, [%r31 + %r0] 0x72
	.word 0xd8bc6000  ! 1510: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0xd8bca000  ! 1511: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd8a4a000  ! 1512: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	mov	0x10, %r27
	.word 0xdef44400  ! 1514: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xd8ad04a0  ! 1515: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	.word 0xd0a4e000  ! 1516: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0d4a000  ! 1517: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1518: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdacc0400  ! 1519: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r13
	.word 0xd8a74e80  ! 1520: STWA_R	stwa	%r12, [%r29 + %r0] 0x74
	wr_tick_cmpr_2_14:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x8e, %g2
	or	%g4, 0xf3, %g4
	or	%g6, 0x9c, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd89d84a0  ! 1522: LDDA_R	ldda	[%r22, %r0] 0x25, %r12
	.word 0x87802074  ! 1523: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde9d84a0  ! 1524: LDDA_R	ldda	[%r22, %r0] 0x25, %r15
	.word 0xd0bde000  ! 1525: STDA_I	stda	%r8, [%r23 + 0x0000] %asi
	mov	0x68, %r17
	mov	0x38, %r18
	.word 0x8780204f  ! 1528: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f74e60  ! 1529: STXA_R	stxa	%r11, [%r29 + %r0] 0x73
	.word 0xdcccc400  ! 1530: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	.word 0xd6c5e000  ! 1531: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r11
	.word 0xd29c0400  ! 1532: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	mov	0x28, %r24
	.word 0xd0b5a000  ! 1534: STHA_I	stha	%r8, [%r22 + 0x0000] %asi
	.word 0xd4d78e80  ! 1535: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r10
	.word 0xd2c689e0  ! 1536: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r9
	.word 0xde856000  ! 1537: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r15
	.word 0xdebd6000  ! 1538: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	.word 0xd0a70e40  ! 1539: STWA_R	stwa	%r8, [%r28 + %r0] 0x72
	.word 0x87802020  ! 1540: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r18
	mov	0x18, %r18
	mov	0x7e8, %r22
	mov	0x28, %r17
	.word 0xd6cfa000  ! 1545: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	mov	0x3c8, %r21
	.word 0xd6a649e0  ! 1547: STWA_R	stwa	%r11, [%r25 + %r0] 0x4f
	.word 0x8780204f  ! 1548: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdccc6000  ! 1549: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	.word 0xdc8ce000  ! 1550: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	.word 0xdc942000  ! 1551: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	.word 0xd0bec9e0  ! 1552: STDA_R	stda	%r8, [%r27 + %r0] 0x4f
	.word 0xd0dc2000  ! 1553: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	.word 0xd4bd44a0  ! 1554: STDA_R	stda	%r10, [%r21 + %r0] 0x25
	.word 0xd09ca000  ! 1555: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	.word 0xd0ac2000  ! 1556: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 1557: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r19
	mov	0x7e8, %r21
	.word 0xd0cce000  ! 1560: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0xd8af8e40  ! 1561: STBA_R	stba	%r12, [%r30 + %r0] 0x72
	.word 0xd2ae09e0  ! 1562: STBA_R	stba	%r9, [%r24 + %r0] 0x4f
	.word 0xd8d7ce60  ! 1563: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r12
	mov	0x8, %r18
	.word 0x87802072  ! 1565: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6df6000  ! 1566: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0xdadf0e60  ! 1567: LDXA_R	ldxa	[%r28, %r0] 0x73, %r13
	.word 0xd0a7a000  ! 1568: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0afce80  ! 1569: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	.word 0xd4a72000  ! 1570: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4afa000  ! 1571: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1572: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd4f74e60  ! 1574: STXA_R	stxa	%r10, [%r29 + %r0] 0x73
	.word 0x87802074  ! 1575: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaaf6000  ! 1576: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xd8f504a0  ! 1577: STXA_R	stxa	%r12, [%r20 + %r0] 0x25
	.word 0xd4a504a0  ! 1578: STWA_R	stwa	%r10, [%r20 + %r0] 0x25
	.word 0xde9544a0  ! 1579: LDUHA_R	lduha	[%r21, %r0] 0x25, %r15
	.word 0xded72000  ! 1580: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	mov	0x7c0, %r20
	.word 0xdef76000  ! 1582: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xd4a609e0  ! 1583: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	.word 0xdeb7a000  ! 1584: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xdc8c4400  ! 1585: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0xd2a72000  ! 1586: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0xd0c5c4a0  ! 1587: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r8
	.word 0xd6c72000  ! 1588: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6af2000  ! 1589: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xde9544a0  ! 1590: LDUHA_R	lduha	[%r21, %r0] 0x25, %r15
	.word 0xde876000  ! 1591: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xdca649e0  ! 1592: STWA_R	stwa	%r14, [%r25 + %r0] 0x4f
	.word 0xdeb72000  ! 1593: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xd2d544a0  ! 1594: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r9
	.word 0xd4bf8e40  ! 1595: STDA_R	stda	%r10, [%r30 + %r0] 0x72
	.word 0xdadc8400  ! 1596: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	.word 0x87802073  ! 1597: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r19
	.word 0xd6f70e60  ! 1599: STXA_R	stxa	%r11, [%r28 + %r0] 0x73
	.word 0xd0aca000  ! 1600: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xd0bc2000  ! 1601: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 1602: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd48e89e0  ! 1603: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r10
	.word 0xdcc44400  ! 1604: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xd6bf6000  ! 1605: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 1606: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r24
	.word 0xd6b7e000  ! 1608: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd69f6000  ! 1609: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	.word 0xd6f7a000  ! 1610: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xdcb4c400  ! 1611: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xdcb76000  ! 1612: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xd4948400  ! 1613: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	.word 0xd0c72000  ! 1614: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	mov	0x50, %r17
	.word 0xd0d7e000  ! 1616: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0bfe000  ! 1617: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xdcb4c400  ! 1618: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xdc8f8e40  ! 1619: LDUBA_R	lduba	[%r30, %r0] 0x72, %r14
	.word 0xd48f4e60  ! 1620: LDUBA_R	lduba	[%r29, %r0] 0x73, %r10
	.word 0xd2d7e000  ! 1621: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1622: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a5c4a0  ! 1623: STWA_R	stwa	%r12, [%r23 + %r0] 0x25
	mov	0x7e0, %r20
	.word 0x87802073  ! 1625: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r18
	.word 0xd8dfe000  ! 1627: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xd88fe000  ! 1628: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1629: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09c0400  ! 1630: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	.word 0x87802025  ! 1631: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb7e000  ! 1632: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xd6bcc400  ! 1633: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0xdcdd84a0  ! 1634: LDXA_R	ldxa	[%r22, %r0] 0x25, %r14
	.word 0xdc9f0e40  ! 1635: LDDA_R	ldda	[%r28, %r0] 0x72, %r14
	.word 0xd0876000  ! 1636: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1637: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08ce000  ! 1638: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xd09c6000  ! 1639: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r8
	mov	0x7f0, %r20
	.word 0x87802020  ! 1641: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1642: WRASI_I	wr	%r0, 0x004f, %asi
	wr_tick_cmpr_2_15:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa5, %g2
	or	%g4, 0xe1, %g4
	or	%g6, 0xae, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x28, %r19
	.word 0xdac44400  ! 1645: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r13
	.word 0xda9dc4a0  ! 1646: LDDA_R	ldda	[%r23, %r0] 0x25, %r13
	mov	0x70, %r27
	mov	0x7d0, %r23
	.word 0xd4a76000  ! 1649: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd28d44a0  ! 1650: LDUBA_R	lduba	[%r21, %r0] 0x25, %r9
	.word 0xdabfce60  ! 1651: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	.word 0xd6a44400  ! 1652: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0xde9609e0  ! 1653: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r15
	.word 0xd4af6000  ! 1654: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xda9f0e80  ! 1655: LDDA_R	ldda	[%r28, %r0] 0x74, %r13
	.word 0xda872000  ! 1656: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdab72000  ! 1658: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdab7e000  ! 1659: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xdabf2000  ! 1660: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xdab7a000  ! 1661: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd48f8e60  ! 1663: LDUBA_R	lduba	[%r30, %r0] 0x73, %r10
	.word 0xd68c0400  ! 1664: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	.word 0xd0ac0400  ! 1665: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	mov	0x18, %r18
	.word 0xde87a000  ! 1667: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xdecfe000  ! 1668: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xdef7a000  ! 1669: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdea76000  ! 1670: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xdec78e40  ! 1671: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r15
	.word 0xdcb5c4a0  ! 1672: STHA_R	stha	%r14, [%r23 + %r0] 0x25
	.word 0xd8df8e80  ! 1673: LDXA_R	ldxa	[%r30, %r0] 0x74, %r12
	mov	0x7f0, %r23
	.word 0xdabfa000  ! 1675: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdadf2000  ! 1676: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0xdaaf6000  ! 1677: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	mov	0x7e0, %r21
	.word 0xd8dc8400  ! 1679: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xdcdf8e80  ! 1680: LDXA_R	ldxa	[%r30, %r0] 0x74, %r14
	mov	0x70, %r27
	.word 0xd2dd44a0  ! 1682: LDXA_R	ldxa	[%r21, %r0] 0x25, %r9
	.word 0xd0cf4e40  ! 1683: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	.word 0xdab48400  ! 1684: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0xd4cf4e80  ! 1685: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r10
	.word 0xd09fa000  ! 1686: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	.word 0xd0b4c400  ! 1687: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0xd6b74e60  ! 1688: STHA_R	stha	%r11, [%r29 + %r0] 0x73
	mov	0x18, %r19
	.word 0xd2dc8400  ! 1690: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	mov	0x3d8, %r20
	.word 0xdc8689e0  ! 1692: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r14
	.word 0xd68e89e0  ! 1693: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r11
	.word 0xd0cf2000  ! 1694: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0xd6cf4e40  ! 1695: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r11
	mov	0x30, %r19
	mov	0x3f8, %r20
	.word 0xdc9fa000  ! 1698: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0x87802020  ! 1699: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2d5c4a0  ! 1701: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r9
	.word 0xdacd44a0  ! 1702: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r13
	mov	0x10, %r16
	.word 0xdcbc2000  ! 1704: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xdcbc6000  ! 1705: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xdcf4e000  ! 1706: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcc4e000  ! 1707: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r14
	.word 0xd68c4400  ! 1708: LDUBA_R	lduba	[%r17, %r0] 0x20, %r11
	mov	0x50, %r18
	mov	0x48, %r16
	.word 0xdabce000  ! 1711: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xda9ca000  ! 1713: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	.word 0xdaace000  ! 1714: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0xdeb70e60  ! 1715: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	.word 0x87802020  ! 1716: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28f4e40  ! 1717: LDUBA_R	lduba	[%r29, %r0] 0x72, %r9
	wr_tick_cmpr_2_16:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x8a, %g2
	or	%g4, 0x94, %g4
	or	%g6, 0x94, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdacd04a0  ! 1719: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r13
	.word 0xd0cce000  ! 1720: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0xdec7ce40  ! 1721: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r15
	mov	0x48, %r27
	.word 0x87802074  ! 1723: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r27
	mov	0x28, %r24
	.word 0xdadec9e0  ! 1726: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r13
	.word 0xd6aea000  ! 1727: STBA_I	stba	%r11, [%r26 + 0x0000] %asi
	.word 0xdebf8e60  ! 1728: STDA_R	stda	%r15, [%r30 + %r0] 0x73
	mov	0x8, %r19
	.word 0x87802072  ! 1730: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0974e60  ! 1731: LDUHA_R	lduha	[%r29, %r0] 0x73, %r8
	mov	0x28, %r18
	.word 0xd2c5e000  ! 1733: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r9
	.word 0xdaa649e0  ! 1734: STWA_R	stwa	%r13, [%r25 + %r0] 0x4f
	mov	0x30, %r27
	mov	0x70, %r25
	.word 0xdca5a000  ! 1737: STWA_I	stwa	%r14, [%r22 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdcbd6000  ! 1739: STDA_I	stda	%r14, [%r21 + 0x0000] %asi
	.word 0x87802025  ! 1740: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 1741: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb62000  ! 1742: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	mov	0x7d8, %r21
	mov	0x48, %r19
	.word 0xd0b78e60  ! 1745: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	.word 0xd0a66000  ! 1746: STWA_I	stwa	%r8, [%r25 + 0x0000] %asi
	mov	0x48, %r17
	.word 0xd0cee000  ! 1748: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r8
	mov	0x60, %r26
	mov	0x30, %r26
	mov	0x7e0, %r23
	.word 0xd8d44400  ! 1752: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	.word 0x87802072  ! 1753: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1754: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r26
	mov	0x7e0, %r20
	.word 0xdeaf4e80  ! 1757: STBA_R	stba	%r15, [%r29 + %r0] 0x74
	.word 0x87802072  ! 1758: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda9f4e40  ! 1759: LDDA_R	ldda	[%r29, %r0] 0x72, %r13
	.word 0xd4a76000  ! 1760: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4df2000  ! 1761: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1762: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac78e60  ! 1763: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r13
	.word 0x87802072  ! 1764: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8c72000  ! 1765: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	wr_tick_cmpr_2_17:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb7, %g2
	or	%g4, 0xc4, %g4
	or	%g6, 0xc4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x30, %r25
	.word 0xd8b7e000  ! 1768: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0xd89689e0  ! 1770: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r12
	mov	0x3c8, %r22
	mov	0x60, %r25
	mov	0x60, %r16
	mov	0x58, %r16
	.word 0xdedd04a0  ! 1775: LDXA_R	ldxa	[%r20, %r0] 0x25, %r15
	.word 0xd4d76000  ! 1776: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0xd0bc0400  ! 1777: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0xdc872000  ! 1778: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xded584a0  ! 1779: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r15
	mov	0x38, %r24
	.word 0xd09c0400  ! 1781: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	.word 0xd6d76000  ! 1782: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	.word 0xda844400  ! 1783: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r13
	mov	0x68, %r26
	.word 0xd097a000  ! 1785: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1786: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r16
	.word 0xd0b78e80  ! 1788: STHA_R	stha	%r8, [%r30 + %r0] 0x74
	mov	0x3f0, %r21
	.word 0xdcae2000  ! 1790: STBA_I	stba	%r14, [%r24 + 0x0000] %asi
	.word 0xdcbf4e60  ! 1791: STDA_R	stda	%r14, [%r29 + %r0] 0x73
	.word 0xd0a70e60  ! 1792: STWA_R	stwa	%r8, [%r28 + %r0] 0x73
	mov	0x18, %r27
	.word 0xd2be6000  ! 1794: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	.word 0xd2ae6000  ! 1795: STBA_I	stba	%r9, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 1796: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r17
	.word 0x87802020  ! 1798: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdacdc4a0  ! 1799: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r13
	mov	0x68, %r24
	.word 0xd0a62000  ! 1801: STWA_I	stwa	%r8, [%r24 + 0x0000] %asi
	.word 0xd4940400  ! 1802: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	.word 0xd69e09e0  ! 1803: LDDA_R	ldda	[%r24, %r0] 0x4f, %r11
	.word 0xd69c8400  ! 1804: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	.word 0x87802025  ! 1805: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad76000  ! 1806: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0xd4978e40  ! 1807: LDUHA_R	lduha	[%r30, %r0] 0x72, %r10
	.word 0xdea609e0  ! 1808: STWA_R	stwa	%r15, [%r24 + %r0] 0x4f
	.word 0xd6bcc400  ! 1809: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0xd2a7e000  ! 1810: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xdcd7ce60  ! 1811: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r14
	.word 0xdc9fe000  ! 1812: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xd48649e0  ! 1813: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r10
	.word 0xdea76000  ! 1814: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	mov	0x48, %r19
	.word 0xd8c70e80  ! 1816: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r12
	.word 0xded72000  ! 1817: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 1818: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1819: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bc4400  ! 1820: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xda966000  ! 1821: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r13
	.word 0xd6a78e80  ! 1822: STWA_R	stwa	%r11, [%r30 + %r0] 0x74
	mov	0x7d0, %r22
	.word 0xdcb40400  ! 1824: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0x87802020  ! 1825: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabfa000  ! 1826: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	mov	0x78, %r19
	.word 0xdac72000  ! 1828: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0xde8d04a0  ! 1829: LDUBA_R	lduba	[%r20, %r0] 0x25, %r15
	.word 0x87802072  ! 1830: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4c5a000  ! 1831: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r10
	.word 0xd48da000  ! 1832: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r10
	.word 0x87802074  ! 1833: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a7e000  ! 1834: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd0b74e60  ! 1835: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	.word 0xd4840400  ! 1836: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	mov	0x7f8, %r20
	.word 0xd6f72000  ! 1838: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	mov	0x68, %r17
	.word 0xd6bf2000  ! 1840: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xdcbd04a0  ! 1841: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	.word 0xd0b76000  ! 1842: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xde9d04a0  ! 1843: LDDA_R	ldda	[%r20, %r0] 0x25, %r15
	.word 0x87802020  ! 1844: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6c649e0  ! 1846: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r11
	mov	0x30, %r27
	.word 0xd8f7a000  ! 1848: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8bfe000  ! 1849: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xda9c4400  ! 1850: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	.word 0xdcbc8400  ! 1851: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xd6f78e40  ! 1852: STXA_R	stxa	%r11, [%r30 + %r0] 0x72
	.word 0xdea7e000  ! 1853: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	mov	0x3e0, %r23
	.word 0x87802025  ! 1855: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf40400  ! 1856: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xdaafe000  ! 1857: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	mov	0x50, %r26
	mov	0x7c0, %r20
	.word 0xda9fe000  ! 1860: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xdcbc8400  ! 1861: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0x87802025  ! 1862: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cf0e80  ! 1863: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r10
	.word 0x87802025  ! 1864: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4f78e80  ! 1865: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	mov	0x8, %r17
	mov	0x40, %r19
	.word 0xdaf7a000  ! 1868: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 1869: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda976000  ! 1870: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	.word 0xdabfe000  ! 1871: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xdcd7ce40  ! 1872: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r14
	mov	0x7d0, %r23
	.word 0x8780204f  ! 1874: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd68ee000  ! 1875: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r11
	.word 0xd6d6a000  ! 1876: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r11
	.word 0xd6f6e000  ! 1877: STXA_I	stxa	%r11, [%r27 + 0x0000] %asi
	.word 0xd6b62000  ! 1878: STHA_I	stha	%r11, [%r24 + 0x0000] %asi
	mov	0x18, %r25
	.word 0xdecc4400  ! 1880: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r15
	.word 0xded7ce60  ! 1881: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r15
	.word 0xd2aee000  ! 1882: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	.word 0xd69e89e0  ! 1883: LDDA_R	ldda	[%r26, %r0] 0x4f, %r11
	mov	0x68, %r18
	.word 0xd0cc0400  ! 1885: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xd2b74e60  ! 1886: STHA_R	stha	%r9, [%r29 + %r0] 0x73
	.word 0xd6a6a000  ! 1887: STWA_I	stwa	%r11, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 1888: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_2_18:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x9a, %g2
	or	%g4, 0xb1, %g4
	or	%g6, 0xfa, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xda87ce60  ! 1890: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r13
	mov	0x20, %r26
	.word 0xdcbf4e40  ! 1892: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	.word 0x87802020  ! 1893: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f70e40  ! 1894: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	.word 0xdef42000  ! 1895: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	mov	0x48, %r25
	.word 0xd6dcc400  ! 1897: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	.word 0x8780204f  ! 1898: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdccfa000  ! 1899: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xdcc72000  ! 1900: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcafe000  ! 1901: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xd0a7ce80  ! 1902: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	mov	0x30, %r16
	.word 0xd4afa000  ! 1904: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	mov	0x58, %r18
	.word 0xdad584a0  ! 1906: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r13
	.word 0x87802072  ! 1907: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b66000  ! 1908: STHA_I	stha	%r12, [%r25 + 0x0000] %asi
	.word 0xd8bee000  ! 1909: STDA_I	stda	%r12, [%r27 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdcbc4400  ! 1911: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	mov	0x3c0, %r20
	mov	0x3c0, %r21
	.word 0xd2bee000  ! 1914: STDA_I	stda	%r9, [%r27 + 0x0000] %asi
	.word 0xd296e000  ! 1915: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r9
	.word 0xd2aee000  ! 1916: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	.word 0xd4b689e0  ! 1917: STHA_R	stha	%r10, [%r26 + %r0] 0x4f
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd4d6e000  ! 1919: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r10
	.word 0xd49ea000  ! 1920: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	mov	0x70, %r16
	.word 0x87802025  ! 1922: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e0, %r21
	.word 0xd4976000  ! 1924: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r10
	.word 0xd4f7a000  ! 1925: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	wr_tick_cmpr_2_19:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x83, %g2
	or	%g4, 0xcc, %g4
	or	%g6, 0xf9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802072  ! 1927: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4af0e40  ! 1928: STBA_R	stba	%r10, [%r28 + %r0] 0x72
	.word 0x87802020  ! 1929: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1930: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1931: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r27
	mov	0x58, %r25
	mov	0x10, %r17
	.word 0xd4a5c4a0  ! 1935: STWA_R	stwa	%r10, [%r23 + %r0] 0x25
	.word 0xd0b70e80  ! 1936: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	.word 0x87802020  ! 1937: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r21
	mov	0x3e0, %r20
	.word 0xd8dfa000  ! 1940: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xdec78e40  ! 1941: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r15
	.word 0xd8b70e60  ! 1942: STHA_R	stha	%r12, [%r28 + %r0] 0x73
	.word 0xdc8fe000  ! 1943: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0x87802025  ! 1944: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f0, %r22
	.word 0xd2a609e0  ! 1946: STWA_R	stwa	%r9, [%r24 + %r0] 0x4f
	.word 0xd4c52000  ! 1947: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r10
	mov	0x7e0, %r22
	.word 0xd2bfce60  ! 1949: STDA_R	stda	%r9, [%r31 + %r0] 0x73
	.word 0xda856000  ! 1950: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r13
	.word 0xd8a74e60  ! 1951: STWA_R	stwa	%r12, [%r29 + %r0] 0x73
	.word 0x87802074  ! 1952: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0bfce60  ! 1953: STDA_R	stda	%r8, [%r31 + %r0] 0x73
	.word 0x87802025  ! 1954: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f8, %r22
	.word 0x87802073  ! 1956: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4bc0400  ! 1957: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	mov	0x30, %r27
	.word 0xdadf8e40  ! 1959: LDXA_R	ldxa	[%r30, %r0] 0x72, %r13
	.word 0x87802074  ! 1960: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeb44400  ! 1961: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0xdaad44a0  ! 1962: STBA_R	stba	%r13, [%r21 + %r0] 0x25
	.word 0xd4a7a000  ! 1963: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xdebf0e40  ! 1964: STDA_R	stda	%r15, [%r28 + %r0] 0x72
	.word 0x87802020  ! 1965: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a78e80  ! 1966: STWA_R	stwa	%r11, [%r30 + %r0] 0x74
	.word 0xdabc4400  ! 1967: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xde8fce60  ! 1968: LDUBA_R	lduba	[%r31, %r0] 0x73, %r15
	.word 0xdabf2000  ! 1969: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	mov	0x18, %r16
	.word 0xda8fe000  ! 1971: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	mov	0x3e0, %r20
	.word 0xd0f584a0  ! 1973: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	mov	0x28, %r26
	mov	0x40, %r27
	.word 0xdaaf2000  ! 1976: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xda876000  ! 1977: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0xda8fa000  ! 1978: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xdccdc4a0  ! 1979: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r14
	.word 0x87802020  ! 1980: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r23
	.word 0xde8c0400  ! 1982: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0x87802025  ! 1983: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f0, %r20
	mov	0x0, %r24
	mov	0x3e8, %r21
	mov	0x3c0, %r23
	mov	0x48, %r18
	.word 0xdab70e60  ! 1989: STHA_R	stha	%r13, [%r28 + %r0] 0x73
	.word 0xdad72000  ! 1990: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0xde978e40  ! 1991: LDUHA_R	lduha	[%r30, %r0] 0x72, %r15
	.word 0xd6af4e60  ! 1992: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	.word 0xd2f544a0  ! 1993: STXA_R	stxa	%r9, [%r21 + %r0] 0x25
	.word 0xdaa7ce40  ! 1994: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	.word 0x87802025  ! 1995: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 1996: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca7ce40  ! 1997: STWA_R	stwa	%r14, [%r31 + %r0] 0x72
	mov	0x7c0, %r22
	mov	0x0, %r26
	mov	0x68, %r18
	mov	0x3f8, %r20
	.word 0xdacd84a0  ! 2002: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r13
	.word 0xd8f7a000  ! 2003: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8d7e000  ! 2004: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0xd887a000  ! 2005: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8f76000  ! 2006: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd2b689e0  ! 2007: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	mov	0x58, %r17
	.word 0xde9e09e0  ! 2009: LDDA_R	ldda	[%r24, %r0] 0x4f, %r15
	.word 0xdecfe000  ! 2010: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xd0970e60  ! 2011: LDUHA_R	lduha	[%r28, %r0] 0x73, %r8
	.word 0xdabfce60  ! 2012: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2c74e40  ! 2014: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r9
	.word 0xdcf76000  ! 2015: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x28, %r24
	.word 0xdcb76000  ! 2017: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xdc9fe000  ! 2018: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	mov	0x40, %r17
	.word 0xdc9fe000  ! 2020: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xd4a7ce60  ! 2021: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	.word 0xd2f544a0  ! 2022: STXA_R	stxa	%r9, [%r21 + %r0] 0x25
	.word 0xdcd544a0  ! 2023: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r14
	.word 0xd6d76000  ! 2024: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	.word 0xded44400  ! 2025: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	.word 0x87802020  ! 2026: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b584a0  ! 2027: STHA_R	stha	%r10, [%r22 + %r0] 0x25
	.word 0xd28f0e40  ! 2028: LDUBA_R	lduba	[%r28, %r0] 0x72, %r9
	.word 0xdacf6000  ! 2029: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xda87a000  ! 2030: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0xdad74e80  ! 2031: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r13
	.word 0x87802025  ! 2032: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 2033: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc8c4400  ! 2034: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0xd0f42000  ! 2035: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 2036: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0ae2000  ! 2037: STBA_I	stba	%r8, [%r24 + 0x0000] %asi
	.word 0xd0ae2000  ! 2038: STBA_I	stba	%r8, [%r24 + 0x0000] %asi
	.word 0xd096e000  ! 2039: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r8
	mov	0x7d0, %r21
	.word 0xd0966000  ! 2041: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r8
	.word 0x87802072  ! 2042: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd08e2000  ! 2043: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r8
	.word 0xd086e000  ! 2044: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r8
	mov	0x70, %r16
	.word 0x87802073  ! 2046: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd09f8e40  ! 2047: LDDA_R	ldda	[%r30, %r0] 0x72, %r8
	.word 0xd09cc400  ! 2048: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	mov	0x78, %r26
	.word 0xd0af0e60  ! 2050: STBA_R	stba	%r8, [%r28 + %r0] 0x73
	mov	0x18, %r26
	.word 0xdaa70e80  ! 2052: STWA_R	stwa	%r13, [%r28 + %r0] 0x74
	.word 0x87802025  ! 2053: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4dc4400  ! 2054: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	.word 0xdcbf0e40  ! 2055: STDA_R	stda	%r14, [%r28 + %r0] 0x72
	.word 0xdadc6000  ! 2056: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xd8d44400  ! 2057: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	.word 0xdec48400  ! 2058: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	.word 0xd2a70e80  ! 2059: STWA_R	stwa	%r9, [%r28 + %r0] 0x74
	.word 0x8780204f  ! 2060: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a7e000  ! 2061: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	mov	0x18, %r25
	mov	0x7f0, %r22
	.word 0xdad74e60  ! 2064: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r13
	mov	0x3e8, %r20
	.word 0xd2bf2000  ! 2066: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 2067: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2d4e000  ! 2068: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0xd2bce000  ! 2069: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xdaf7ce40  ! 2070: STXA_R	stxa	%r13, [%r31 + %r0] 0x72
	.word 0x87802073  ! 2071: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdacf6000  ! 2072: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xd0a48400  ! 2073: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0xd8bfe000  ! 2074: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd8cf2000  ! 2075: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0xd4be89e0  ! 2076: STDA_R	stda	%r10, [%r26 + %r0] 0x4f
	.word 0xdea76000  ! 2077: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	mov	0x3c8, %r23
	mov	0x68, %r27
	.word 0xdaa689e0  ! 2080: STWA_R	stwa	%r13, [%r26 + %r0] 0x4f
	.word 0xd2a7e000  ! 2081: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	mov	0x38, %r17
	.word 0xd2dfa000  ! 2083: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xdca5c4a0  ! 2084: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	mov	0x40, %r26
	.word 0xd88fe000  ! 2086: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	mov	0x28, %r24
	.word 0xd0a74e60  ! 2088: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	.word 0xdc972000  ! 2089: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	mov	0x3d0, %r23
	.word 0xdc872000  ! 2091: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xdccfa000  ! 2092: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0x87802074  ! 2093: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb649e0  ! 2094: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	.word 0x87802025  ! 2095: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r18
	.word 0xded76000  ! 2097: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0xdc878e80  ! 2098: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r14
	.word 0xdcbfa000  ! 2099: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	mov	0x8, %r26
	.word 0x87802073  ! 2101: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r19
	.word 0xdca6e000  ! 2103: STWA_I	stwa	%r14, [%r27 + 0x0000] %asi
	.word 0xdcb66000  ! 2104: STHA_I	stha	%r14, [%r25 + 0x0000] %asi
	.word 0xde9d04a0  ! 2105: LDDA_R	ldda	[%r20, %r0] 0x25, %r15
	.word 0xda8689e0  ! 2106: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r13
	mov	0x38, %r19
	mov	0x68, %r26
	.word 0xdebea000  ! 2109: STDA_I	stda	%r15, [%r26 + 0x0000] %asi
	.word 0xdec6a000  ! 2110: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r15
	.word 0xd6af4e40  ! 2111: STBA_R	stba	%r11, [%r29 + %r0] 0x72
	.word 0xdaa70e80  ! 2112: STWA_R	stwa	%r13, [%r28 + %r0] 0x74
	.word 0xd4cee000  ! 2113: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r10
	.word 0xd4a6a000  ! 2114: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	.word 0xd6bfce40  ! 2115: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	.word 0xd0f504a0  ! 2116: STXA_R	stxa	%r8, [%r20 + %r0] 0x25
	.word 0xd2a504a0  ! 2117: STWA_R	stwa	%r9, [%r20 + %r0] 0x25
	.word 0xdca609e0  ! 2118: STWA_R	stwa	%r14, [%r24 + %r0] 0x4f
	mov	0x60, %r25
	.word 0xd0b40400  ! 2120: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0xd2f66000  ! 2121: STXA_I	stxa	%r9, [%r25 + 0x0000] %asi
	mov	0x3d0, %r23
	mov	0x48, %r17
	mov	0x18, %r19
	.word 0xd2f66000  ! 2125: STXA_I	stxa	%r9, [%r25 + 0x0000] %asi
	.word 0xd29e6000  ! 2126: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r9
	.word 0xd8df0e80  ! 2127: LDXA_R	ldxa	[%r28, %r0] 0x74, %r12
	.word 0x87802020  ! 2128: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r19
	mov	0x10, %r25
	.word 0xd6f48400  ! 2131: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xd29cc400  ! 2132: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	.word 0xda8d44a0  ! 2133: LDUBA_R	lduba	[%r21, %r0] 0x25, %r13
	mov	0x7f0, %r23
	.word 0xdef5a000  ! 2135: STXA_I	stxa	%r15, [%r22 + 0x0000] %asi
	.word 0xd8f544a0  ! 2136: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	.word 0xdcada000  ! 2137: STBA_I	stba	%r14, [%r22 + 0x0000] %asi
	.word 0x87802073  ! 2138: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc876000  ! 2139: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2140: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r16
	.word 0xdcbf6000  ! 2142: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xded70e40  ! 2143: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r15
	.word 0xda97a000  ! 2144: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xd0848400  ! 2145: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r8
	.word 0x87802020  ! 2146: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c70e80  ! 2147: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r12
	mov	0x50, %r17
	.word 0xd68d6000  ! 2149: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r11
	.word 0xd2df0e80  ! 2150: LDXA_R	ldxa	[%r28, %r0] 0x74, %r9
	.word 0xd2cf0e60  ! 2151: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r9
	.word 0xd2a5a000  ! 2152: STWA_I	stwa	%r9, [%r22 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0xd29d6000  ! 2154: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r9
	.word 0xdadd04a0  ! 2155: LDXA_R	ldxa	[%r20, %r0] 0x25, %r13
	.word 0xd0c6c9e0  ! 2156: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r8
	.word 0xd8b5a000  ! 2157: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	.word 0xd8dd6000  ! 2158: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r12
	mov	0x38, %r19
	.word 0xdcdd44a0  ! 2160: LDXA_R	ldxa	[%r21, %r0] 0x25, %r14
	mov	0x68, %r26
	.word 0xd0f7ce80  ! 2162: STXA_R	stxa	%r8, [%r31 + %r0] 0x74
	.word 0xd4dda000  ! 2163: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r10
	mov	0x0, %r24
	.word 0x87802074  ! 2165: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4bea000  ! 2166: STDA_I	stda	%r10, [%r26 + 0x0000] %asi
	mov	0x70, %r16
	.word 0x87802020  ! 2168: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r21
	mov	0x3e0, %r23
	mov	0x70, %r19
	mov	0x78, %r17
	mov	0x7d0, %r20
	.word 0x87802025  ! 2174: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cc6000  ! 2175: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	.word 0xd4bca000  ! 2176: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0xd4bc2000  ! 2177: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0xd4dc6000  ! 2178: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	.word 0xd4f4a000  ! 2179: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0xdeb78e40  ! 2180: STHA_R	stha	%r15, [%r30 + %r0] 0x72
	.word 0xdcb40400  ! 2181: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	mov	0x58, %r17
	mov	0x3f0, %r20
	.word 0xd6ac6000  ! 2184: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xd6d44400  ! 2185: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r11
	.word 0xd497ce40  ! 2186: LDUHA_R	lduha	[%r31, %r0] 0x72, %r10
	.word 0x87802073  ! 2187: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r27
	.word 0xd6a74e60  ! 2189: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	.word 0xdcbf4e60  ! 2190: STDA_R	stda	%r14, [%r29 + %r0] 0x73
	.word 0xdebe09e0  ! 2191: STDA_R	stda	%r15, [%r24 + %r0] 0x4f
	.word 0xd09609e0  ! 2192: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r8
	.word 0xdaf584a0  ! 2193: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	.word 0xd2cc6000  ! 2194: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	.word 0xd2f46000  ! 2195: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2f4a000  ! 2196: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0xd29ca000  ! 2197: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	mov	0x70, %r24
	mov	0x7c0, %r22
	.word 0xdea70e60  ! 2200: STWA_R	stwa	%r15, [%r28 + %r0] 0x73
	.word 0xd6bf4e40  ! 2201: STDA_R	stda	%r11, [%r29 + %r0] 0x72
	.word 0xd08c2000  ! 2202: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	mov	0x78, %r26
	mov	0x50, %r27
	.word 0xd0ac2000  ! 2205: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xd4b70e40  ! 2206: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	.word 0xd2942000  ! 2207: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2b46000  ! 2208: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0xd8970e60  ! 2209: LDUHA_R	lduha	[%r28, %r0] 0x73, %r12
	.word 0xd6a4e000  ! 2210: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0xd6dcc400  ! 2211: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	.word 0xd4b4a000  ! 2212: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xd0b78e60  ! 2214: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	.word 0xd8a4a000  ! 2215: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	mov	0x7d0, %r20
	.word 0xd28c8400  ! 2217: LDUBA_R	lduba	[%r18, %r0] 0x20, %r9
	.word 0x87802073  ! 2218: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2219: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bf6000  ! 2220: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	mov	0x8, %r26
	.word 0x8780204f  ! 2222: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r17
	.word 0xd4f76000  ! 2224: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xdcf74e40  ! 2225: STXA_R	stxa	%r14, [%r29 + %r0] 0x72
	.word 0xdea78e40  ! 2226: STWA_R	stwa	%r15, [%r30 + %r0] 0x72
	.word 0xd4a70e60  ! 2227: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	.word 0xd29f6000  ! 2228: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xd28f6000  ! 2229: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	mov	0x18, %r16
	.word 0x87802020  ! 2231: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2232: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda8f8e80  ! 2233: LDUBA_R	lduba	[%r30, %r0] 0x74, %r13
	.word 0xd0bf0e40  ! 2234: STDA_R	stda	%r8, [%r28 + %r0] 0x72
	mov	0x48, %r16
	.word 0x8780204f  ! 2236: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2237: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2238: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0cf2000  ! 2239: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	mov	0x7e0, %r22
	.word 0x87802073  ! 2241: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f4c400  ! 2242: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0x87802072  ! 2243: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdecf4e60  ! 2244: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r15
	.word 0xd0bd6000  ! 2245: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xd28e89e0  ! 2247: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r9
	.word 0xdecda000  ! 2248: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r15
	mov	0x18, %r16
	mov	0x68, %r17
	mov	0x38, %r24
	.word 0xdadf4e40  ! 2252: LDXA_R	ldxa	[%r29, %r0] 0x72, %r13
	mov	0x7f8, %r23
	.word 0xdcb74e80  ! 2254: STHA_R	stha	%r14, [%r29 + %r0] 0x74
	mov	0x78, %r19
	.word 0xd8bda000  ! 2256: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	.word 0xd8ade000  ! 2257: STBA_I	stba	%r12, [%r23 + 0x0000] %asi
	.word 0x87802073  ! 2258: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r25
	mov	0x40, %r19
	.word 0xd0af0e80  ! 2261: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	.word 0x87802072  ! 2262: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2bc0400  ! 2263: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xdaac6000  ! 2264: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	.word 0xdac42000  ! 2265: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0xd0f44400  ! 2266: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd8b7ce40  ! 2267: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0xd2d584a0  ! 2268: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r9
	.word 0xd0f74e80  ! 2269: STXA_R	stxa	%r8, [%r29 + %r0] 0x74
	mov	0x38, %r24
	.word 0xd8ace000  ! 2271: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0xd8a4e000  ! 2272: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xd89c2000  ! 2273: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	mov	0x58, %r19
	.word 0xd8946000  ! 2275: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	.word 0xd8f74e40  ! 2276: STXA_R	stxa	%r12, [%r29 + %r0] 0x72
	.word 0xd2b42000  ! 2277: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0xdc9f8e80  ! 2278: LDDA_R	ldda	[%r30, %r0] 0x74, %r14
	.word 0x8780204f  ! 2279: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc9f0e80  ! 2280: LDDA_R	ldda	[%r28, %r0] 0x74, %r14
	.word 0xd6a7a000  ! 2281: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd0cc0400  ! 2282: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xdc8fe000  ! 2283: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0x87802073  ! 2284: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc9c2000  ! 2285: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r14
	.word 0xdc94a000  ! 2286: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xdc94a000  ! 2287: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xdcdca000  ! 2288: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2289: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a5c4a0  ! 2290: STWA_R	stwa	%r12, [%r23 + %r0] 0x25
	.word 0x87802074  ! 2291: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdccc6000  ! 2292: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	.word 0xdc94a000  ! 2293: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xd2d6c9e0  ! 2294: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r9
	mov	0x10, %r26
	.word 0xde94e000  ! 2296: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	.word 0xde9c6000  ! 2297: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0xd2af8e40  ! 2298: STBA_R	stba	%r9, [%r30 + %r0] 0x72
	mov	0x70, %r19
	.word 0xd29ce000  ! 2300: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xd2aca000  ! 2301: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 2302: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r25
	.word 0x87802074  ! 2304: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd686c9e0  ! 2305: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r11
	mov	0x48, %r18
	mov	0x3d8, %r21
	.word 0xdcb689e0  ! 2308: STHA_R	stha	%r14, [%r26 + %r0] 0x4f
	mov	0x30, %r19
	.word 0xdaf7ce80  ! 2310: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	.word 0xdcd584a0  ! 2311: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r14
	mov	0x68, %r27
	.word 0xd6a504a0  ! 2313: STWA_R	stwa	%r11, [%r20 + %r0] 0x25
	.word 0xd0b504a0  ! 2314: STHA_R	stha	%r8, [%r20 + %r0] 0x25
	.word 0xd8a42000  ! 2315: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8ac6000  ! 2316: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	mov	0x60, %r25
	.word 0xd8dc6000  ! 2318: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	.word 0xd8a46000  ! 2319: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8f4e000  ! 2320: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 2321: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e8, %r23
	wr_tick_cmpr_2_20:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xdf, %g2
	or	%g4, 0xa8, %g4
	or	%g6, 0xbc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8946000  ! 2324: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	.word 0xd6af0e80  ! 2325: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	.word 0xd6ace000  ! 2326: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0xd6cca000  ! 2327: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r11
	.word 0xdacf0e40  ! 2328: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r13
	.word 0xde87ce40  ! 2329: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r15
	mov	0x10, %r25
	.word 0xdcb7ce60  ! 2331: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	.word 0xd0842000  ! 2332: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 2333: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a40400  ! 2334: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0xd8d5a000  ! 2335: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r12
	.word 0xd8a52000  ! 2336: STWA_I	stwa	%r12, [%r20 + 0x0000] %asi
	.word 0xd8bd6000  ! 2337: STDA_I	stda	%r12, [%r21 + 0x0000] %asi
	.word 0xd895a000  ! 2338: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r12
	.word 0xd8a5a000  ! 2339: STWA_I	stwa	%r12, [%r22 + 0x0000] %asi
	.word 0xd8a52000  ! 2340: STWA_I	stwa	%r12, [%r20 + 0x0000] %asi
	.word 0x8780204f  ! 2341: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c0, %r21
	.word 0xdebf8e40  ! 2343: STDA_R	stda	%r15, [%r30 + %r0] 0x72
	.word 0xd6dea000  ! 2344: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r11
	.word 0xd6a62000  ! 2345: STWA_I	stwa	%r11, [%r24 + 0x0000] %asi
	mov	0x7d8, %r22
	mov	0x50, %r19
	.word 0xd2b584a0  ! 2348: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0xdebe09e0  ! 2349: STDA_R	stda	%r15, [%r24 + %r0] 0x4f
	mov	0x68, %r18
	.word 0xd4f66000  ! 2351: STXA_I	stxa	%r10, [%r25 + 0x0000] %asi
	.word 0xd0a74e80  ! 2352: STWA_R	stwa	%r8, [%r29 + %r0] 0x74
	.word 0xde95c4a0  ! 2353: LDUHA_R	lduha	[%r23, %r0] 0x25, %r15
	.word 0xde862000  ! 2354: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 2355: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea46000  ! 2356: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xd4b4c400  ! 2357: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0x87802072  ! 2358: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 2359: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4dce000  ! 2360: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	.word 0xd48ca000  ! 2361: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r10
	.word 0xd4ac2000  ! 2362: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 2363: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r26
	mov	0x58, %r24
	mov	0x30, %r17
	.word 0xd4c584a0  ! 2367: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r10
	.word 0xd8876000  ! 2368: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8970e80  ! 2369: LDUHA_R	lduha	[%r28, %r0] 0x74, %r12
	.word 0xdef76000  ! 2370: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xd2b44400  ! 2371: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	mov	0x7d8, %r21
	.word 0xd8acc400  ! 2373: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0x87802020  ! 2374: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r17
	.word 0xdcf7ce60  ! 2376: STXA_R	stxa	%r14, [%r31 + %r0] 0x73
	.word 0xd2d7a000  ! 2377: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0xd2bfa000  ! 2378: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd2f7e000  ! 2379: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd2b7e000  ! 2380: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2b7e000  ! 2381: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0xd29fa000  ! 2383: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd0dc8400  ! 2384: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0xdc9d04a0  ! 2385: LDDA_R	ldda	[%r20, %r0] 0x25, %r14
	mov	0x38, %r17
	mov	0x3f0, %r21
	.word 0xd8cf4e40  ! 2388: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r12
	.word 0x8780204f  ! 2389: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdad5e000  ! 2390: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r13
	.word 0xdccd44a0  ! 2391: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r14
	.word 0xd0dda000  ! 2392: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r8
	.word 0xd0b52000  ! 2393: STHA_I	stha	%r8, [%r20 + 0x0000] %asi
	.word 0xd085e000  ! 2394: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r8
	.word 0xd8f44400  ! 2395: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	mov	0x40, %r18
	.word 0xd6f5a000  ! 2397: STXA_I	stxa	%r11, [%r22 + 0x0000] %asi
	.word 0x8780204f  ! 2398: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd68f6000  ! 2399: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6df2000  ! 2400: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6af6000  ! 2401: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 2402: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f7e000  ! 2403: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd2a4c400  ! 2404: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0xd2d70e80  ! 2405: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r9
	mov	0x50, %r18
	.word 0xd0d40400  ! 2407: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	mov	0x7e8, %r23
	mov	0x3c8, %r23
	.word 0xdedc4400  ! 2410: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	.word 0x87802020  ! 2411: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b46000  ! 2412: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0xd2b4e000  ! 2413: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	mov	0x48, %r18
	.word 0x87802072  ! 2415: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2cc6000  ! 2416: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	mov	0x0, %r17
	mov	0x18, %r19
	.word 0xd294a000  ! 2419: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r9
	.word 0xd6c6c9e0  ! 2420: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r11
	.word 0xdabc4400  ! 2421: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xd4a46000  ! 2422: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	mov	0x7c0, %r21
	.word 0x8780204f  ! 2424: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r17
	.word 0xd2944400  ! 2426: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	.word 0xd6ce89e0  ! 2427: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r11
	wr_tick_cmpr_2_21:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe1, %g2
	or	%g4, 0x8d, %g4
	or	%g6, 0x85, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xde8f8e40  ! 2429: LDUBA_R	lduba	[%r30, %r0] 0x72, %r15
	.word 0xd6f56000  ! 2430: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	.word 0xdeb78e60  ! 2431: STHA_R	stha	%r15, [%r30 + %r0] 0x73
	.word 0xdcb70e60  ! 2432: STHA_R	stha	%r14, [%r28 + %r0] 0x73
	.word 0xdeb56000  ! 2433: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	.word 0xded5a000  ! 2434: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r15
	.word 0xdaa78e40  ! 2435: STWA_R	stwa	%r13, [%r30 + %r0] 0x72
	.word 0xdccd2000  ! 2436: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r14
	.word 0xdcb52000  ! 2437: STHA_I	stha	%r14, [%r20 + 0x0000] %asi
	.word 0xdcc5a000  ! 2438: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r14
	.word 0x87802025  ! 2439: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf74e40  ! 2440: STXA_R	stxa	%r14, [%r29 + %r0] 0x72
	.word 0xd6aea000  ! 2441: STBA_I	stba	%r11, [%r26 + 0x0000] %asi
	.word 0xd8f78e40  ! 2442: STXA_R	stxa	%r12, [%r30 + %r0] 0x72
	.word 0xd0966000  ! 2443: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r8
	.word 0xdebe49e0  ! 2444: STDA_R	stda	%r15, [%r25 + %r0] 0x4f
	.word 0xd4862000  ! 2445: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r10
	.word 0xd4ce6000  ! 2446: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r10
	mov	0x28, %r19
	.word 0xdc8fce80  ! 2448: LDUBA_R	lduba	[%r31, %r0] 0x74, %r14
	.word 0xd4862000  ! 2449: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r10
	.word 0x87802025  ! 2450: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6df4e40  ! 2451: LDXA_R	ldxa	[%r29, %r0] 0x72, %r11
	.word 0xdaf74e60  ! 2452: STXA_R	stxa	%r13, [%r29 + %r0] 0x73
	.word 0xd6c504a0  ! 2453: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r11
	mov	0x10, %r26
	.word 0xd09ec9e0  ! 2455: LDDA_R	ldda	[%r27, %r0] 0x4f, %r8
	.word 0xd0ae2000  ! 2456: STBA_I	stba	%r8, [%r24 + 0x0000] %asi
	.word 0xd0c6a000  ! 2457: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r8
	mov	0x18, %r16
	mov	0x28, %r25
	mov	0x48, %r26
	.word 0xd4cf0e40  ! 2461: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r10
	.word 0xd0af0e60  ! 2462: STBA_R	stba	%r8, [%r28 + %r0] 0x73
	.word 0x87802074  ! 2463: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef76000  ! 2464: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	mov	0x20, %r26
	.word 0x87802074  ! 2466: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8b44400  ! 2467: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0xdaf5c4a0  ! 2468: STXA_R	stxa	%r13, [%r23 + %r0] 0x25
	mov	0x7e0, %r22
	.word 0xda8d04a0  ! 2470: LDUBA_R	lduba	[%r20, %r0] 0x25, %r13
	.word 0x87802020  ! 2471: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08fce40  ! 2472: LDUBA_R	lduba	[%r31, %r0] 0x72, %r8
	.word 0xd0866000  ! 2473: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r8
	.word 0xd6b6c9e0  ! 2474: STHA_R	stha	%r11, [%r27 + %r0] 0x4f
	.word 0xdcb66000  ! 2475: STHA_I	stha	%r14, [%r25 + 0x0000] %asi
	.word 0xdcaee000  ! 2476: STBA_I	stba	%r14, [%r27 + 0x0000] %asi
	.word 0xd8c40400  ! 2477: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	.word 0xd0dea000  ! 2478: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r8
	mov	0x3c8, %r20
	.word 0x87802025  ! 2480: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0df2000  ! 2481: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0872000  ! 2482: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	mov	0x40, %r26
	mov	0x3c8, %r22
	.word 0x87802020  ! 2485: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ac4400  ! 2486: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xdc9cc400  ! 2487: LDDA_R	ldda	[%r19, %r0] 0x20, %r14
	.word 0xdaf76000  ! 2488: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xd4bc4400  ! 2489: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0xd4cf0e40  ! 2490: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r10
	mov	0x68, %r18
	.word 0xdeaf4e40  ! 2492: STBA_R	stba	%r15, [%r29 + %r0] 0x72
	.word 0xd6af0e80  ! 2493: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	.word 0xdab7ce80  ! 2494: STHA_R	stha	%r13, [%r31 + %r0] 0x74
	.word 0xdeb584a0  ! 2495: STHA_R	stha	%r15, [%r22 + %r0] 0x25
	mov	0x7e8, %r21
	.word 0xdea76000  ! 2497: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 2498: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 2499: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2500: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r24
	.word 0x87802025  ! 2502: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r18
	.word 0xd6b44400  ! 2504: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xda97e000  ! 2505: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	.word 0xdad7e000  ! 2506: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xd29cc400  ! 2507: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	.word 0xdcbec9e0  ! 2508: STDA_R	stda	%r14, [%r27 + %r0] 0x4f
	mov	0x3f0, %r22
	.word 0xdeb76000  ! 2510: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xd4af8e80  ! 2511: STBA_R	stba	%r10, [%r30 + %r0] 0x74
	.word 0x87802020  ! 2512: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8dca000  ! 2513: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2514: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8972000  ! 2515: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	.word 0x87802073  ! 2516: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r18
	.word 0xd8bd2000  ! 2518: STDA_I	stda	%r12, [%r20 + 0x0000] %asi
	.word 0xd8c5e000  ! 2519: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r12
	mov	0x20, %r26
	.word 0xd8a56000  ! 2521: STWA_I	stwa	%r12, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 2522: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r20
	mov	0x8, %r26
	mov	0x40, %r25
	.word 0x87802020  ! 2526: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f4c400  ! 2527: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xdabe49e0  ! 2528: STDA_R	stda	%r13, [%r25 + %r0] 0x4f
	.word 0xd08e6000  ! 2529: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r8
	.word 0xdecf4e40  ! 2530: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r15
	.word 0xd6d74e40  ! 2531: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r11
	.word 0xd0d78e40  ! 2532: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r8
	mov	0x10, %r27
	.word 0xd8d62000  ! 2534: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r12
	mov	0x28, %r18
	.word 0x8780204f  ! 2536: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a52000  ! 2537: STWA_I	stwa	%r12, [%r20 + 0x0000] %asi
	.word 0xd4ddc4a0  ! 2538: LDXA_R	ldxa	[%r23, %r0] 0x25, %r10
	.word 0x87802020  ! 2539: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c609e0  ! 2540: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r11
	.word 0x87802020  ! 2541: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d5c4a0  ! 2542: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r11
	.word 0xd6d44400  ! 2543: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r11
	.word 0xdacfce60  ! 2544: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r13
	.word 0xdab40400  ! 2545: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xdeb70e80  ! 2546: STHA_R	stha	%r15, [%r28 + %r0] 0x74
	.word 0x87802074  ! 2547: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_HPRIV	! macro
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2ce2000  ! 2550: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r9
	.word 0xd2ae6000  ! 2551: STBA_I	stba	%r9, [%r25 + 0x0000] %asi
	.word 0xd8a48400  ! 2552: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	.word 0xd886a000  ! 2553: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r12
	mov	0x60, %r16
	mov	0x7c0, %r23
	mov	0x78, %r18
	.word 0xd2d78e60  ! 2557: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r9
	.word 0xd6b48400  ! 2558: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd8a66000  ! 2559: STWA_I	stwa	%r12, [%r25 + 0x0000] %asi
	.word 0xd8dee000  ! 2560: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r12
	.word 0xd6bfce80  ! 2561: STDA_R	stda	%r11, [%r31 + %r0] 0x74
	mov	0x7c0, %r20
	.word 0xd886e000  ! 2563: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r12
	.word 0xd89ee000  ! 2564: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r12
	.word 0xd8bea000  ! 2565: STDA_I	stda	%r12, [%r26 + 0x0000] %asi
	.word 0xdcb4c400  ! 2566: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xd48ea000  ! 2567: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 2568: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r26
	.word 0xd4cc0400  ! 2570: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r10
	.word 0xdaf584a0  ! 2571: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	ta	T_CHANGE_HPRIV	! macro
	.word 0xda976000  ! 2573: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	.word 0xdeb5c4a0  ! 2574: STHA_R	stha	%r15, [%r23 + %r0] 0x25
	.word 0xd2a7ce40  ! 2575: STWA_R	stwa	%r9, [%r31 + %r0] 0x72
	.word 0xdeb70e60  ! 2576: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	.word 0xd0d72000  ! 2577: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0940400  ! 2578: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	mov	0x7d8, %r23
	.word 0x87802073  ! 2580: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 2581: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 2582: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b62000  ! 2583: STHA_I	stha	%r10, [%r24 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xda97ce40  ! 2585: LDUHA_R	lduha	[%r31, %r0] 0x72, %r13
	mov	0x68, %r19
	.word 0xd2b78e60  ! 2587: STHA_R	stha	%r9, [%r30 + %r0] 0x73
	.word 0x87802025  ! 2588: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0ace000  ! 2589: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 2590: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2591: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b78e60  ! 2592: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	.word 0xdab7a000  ! 2593: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xd0a504a0  ! 2594: STWA_R	stwa	%r8, [%r20 + %r0] 0x25
	.word 0xd8d7e000  ! 2595: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	mov	0x18, %r18
	.word 0xd8a7e000  ! 2597: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd2c74e80  ! 2598: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r9
	mov	0x3c8, %r22
	.word 0xdef76000  ! 2600: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdac544a0  ! 2601: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r13
	.word 0xd4c7a000  ! 2602: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	mov	0x8, %r17
	mov	0x3e8, %r22
	.word 0xd4b7e000  ! 2605: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0x8780204f  ! 2607: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4846000  ! 2608: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r10
	.word 0x87802073  ! 2609: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8dc0400  ! 2610: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	mov	0x58, %r16
	.word 0xdab52000  ! 2612: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	.word 0xdadde000  ! 2613: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r13
	mov	0x28, %r19
	.word 0xdad52000  ! 2615: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r13
	.word 0x87802025  ! 2616: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 2617: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0c544a0  ! 2618: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r8
	.word 0xd8d42000  ! 2619: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0xd8aca000  ! 2620: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0xd0a7ce60  ! 2621: STWA_R	stwa	%r8, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 2622: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 2623: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa4c400  ! 2624: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	mov	0x7e8, %r22
	mov	0x48, %r17
	.word 0x87802020  ! 2627: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r19
	.word 0xd8b4a000  ! 2629: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	mov	0x7f8, %r23
	.word 0xd8bc2000  ! 2631: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd8bc2000  ! 2632: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd8b46000  ! 2633: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 2634: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd88fe000  ! 2635: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8f76000  ! 2636: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	mov	0x28, %r18
	mov	0x7c0, %r20
	mov	0x8, %r24
	.word 0xd4f609e0  ! 2640: STXA_R	stxa	%r10, [%r24 + %r0] 0x4f
	.word 0xdad44400  ! 2641: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0xd0a7a000  ! 2642: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0f72000  ! 2643: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xd4f689e0  ! 2645: STXA_R	stxa	%r10, [%r26 + %r0] 0x4f
	mov	0x70, %r25
	.word 0xd2d44400  ! 2647: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r9
	.word 0x87802073  ! 2648: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r18
	.word 0x8780204f  ! 2650: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r22
	mov	0x50, %r26
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x8780204f  ! 2654: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r24
	.word 0xdacf4e60  ! 2656: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r13
	.word 0xd6bd2000  ! 2657: STDA_I	stda	%r11, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 2658: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f5c4a0  ! 2659: STXA_R	stxa	%r11, [%r23 + %r0] 0x25
	.word 0xd2be6000  ! 2660: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	mov	0x58, %r17
	.word 0x87802020  ! 2662: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8cc400  ! 2663: LDUBA_R	lduba	[%r19, %r0] 0x20, %r15
	.word 0xdab76000  ! 2664: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdacfe000  ! 2665: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	mov	0x7c0, %r21
	.word 0xd297ce40  ! 2667: LDUHA_R	lduha	[%r31, %r0] 0x72, %r9
	.word 0xdabc0400  ! 2668: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xd0876000  ! 2669: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	.word 0xd8944400  ! 2670: LDUHA_R	lduha	[%r17, %r0] 0x20, %r12
	mov	0x0, %r17
	.word 0x87802025  ! 2672: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c8, %r22
	.word 0xd2d7e000  ! 2674: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	mov	0x3e8, %r23
	mov	0x3f8, %r21
	.word 0x87802025  ! 2677: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2f46000  ! 2679: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2bc2000  ! 2680: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xd0f70e40  ! 2681: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	.word 0xd2b584a0  ! 2682: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0xd2d74e80  ! 2683: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r9
	.word 0x87802072  ! 2684: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb48400  ! 2685: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xd08f2000  ! 2686: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	.word 0xd2b48400  ! 2687: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xdaa5c4a0  ! 2688: STWA_R	stwa	%r13, [%r23 + %r0] 0x25
	mov	0x70, %r26
	.word 0xdcbf2000  ! 2690: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 2691: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc9c6000  ! 2692: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r14
	.word 0xdebcc400  ! 2693: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	wr_tick_cmpr_2_22:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xac, %g2
	or	%g4, 0x9e, %g4
	or	%g6, 0x95, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802072  ! 2695: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 2696: WRASI_I	wr	%r0, 0x0074, %asi
	wr_tick_cmpr_2_23:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb6, %g2
	or	%g4, 0xdd, %g4
	or	%g6, 0xc9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2b66000  ! 2698: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	.word 0x87802074  ! 2699: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2c76000  ! 2700: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0xd0cf0e40  ! 2701: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r8
	.word 0xd0b48400  ! 2702: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0x87802074  ! 2703: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda87ce40  ! 2704: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r13
	.word 0xd0a70e80  ! 2705: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0xd2b76000  ! 2706: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd29f2000  ! 2707: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd2dfe000  ! 2708: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0x87802072  ! 2709: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2a7a000  ! 2710: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	mov	0x58, %r19
	.word 0xd2b7e000  ! 2712: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd29fa000  ! 2713: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	mov	0x3f8, %r22
	.word 0xd2b7a000  ! 2715: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0x87802025  ! 2717: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd29ee000  ! 2718: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r9
	mov	0x7d0, %r21
	.word 0xd2be6000  ! 2720: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	.word 0xdea74e40  ! 2721: STWA_R	stwa	%r15, [%r29 + %r0] 0x72
	.word 0xdcb40400  ! 2722: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xdabe2000  ! 2723: STDA_I	stda	%r13, [%r24 + 0x0000] %asi
	mov	0x70, %r16
	.word 0xdaae6000  ! 2725: STBA_I	stba	%r13, [%r25 + 0x0000] %asi
	.word 0xd4ae89e0  ! 2726: STBA_R	stba	%r10, [%r26 + %r0] 0x4f
	mov	0x28, %r19
	.word 0xd0b609e0  ! 2728: STHA_R	stha	%r8, [%r24 + %r0] 0x4f
	.word 0x87802074  ! 2729: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdedfce40  ! 2730: LDXA_R	ldxa	[%r31, %r0] 0x72, %r15
	.word 0xdcbea000  ! 2731: STDA_I	stda	%r14, [%r26 + 0x0000] %asi
	.word 0x87802072  ! 2732: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r25
	.word 0xd0944400  ! 2734: LDUHA_R	lduha	[%r17, %r0] 0x20, %r8
	.word 0xded40400  ! 2735: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	.word 0xd6d70e60  ! 2736: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r11
	.word 0xd8d4c400  ! 2737: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0x87802025  ! 2738: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r17
	.word 0xd4ace000  ! 2740: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 2741: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r24
	mov	0x3e8, %r20
	.word 0xd0a78e40  ! 2744: STWA_R	stwa	%r8, [%r30 + %r0] 0x72
	.word 0xd2cd6000  ! 2745: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r9
	mov	0x3e0, %r22
	.word 0xd2ad2000  ! 2747: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xd2952000  ! 2748: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r9
	.word 0xdcc70e40  ! 2749: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r14
	mov	0x60, %r27
	.word 0xdeb7ce80  ! 2751: STHA_R	stha	%r15, [%r31 + %r0] 0x74
	wr_tick_cmpr_2_24:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xc2, %g2
	or	%g4, 0xfa, %g4
	or	%g6, 0xcf, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdef5c4a0  ! 2753: STXA_R	stxa	%r15, [%r23 + %r0] 0x25
	.word 0xdaa44400  ! 2754: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0xdead44a0  ! 2755: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	.word 0xd2dda000  ! 2756: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r9
	mov	0x10, %r25
	.word 0xdcdf0e60  ! 2758: LDXA_R	ldxa	[%r28, %r0] 0x73, %r14
	mov	0x58, %r16
	mov	0x10, %r26
	.word 0xde8d84a0  ! 2761: LDUBA_R	lduba	[%r22, %r0] 0x25, %r15
	mov	0x10, %r24
	.word 0xd8952000  ! 2763: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r12
	.word 0xd8c52000  ! 2764: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r12
	.word 0x87802020  ! 2765: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d6e000  ! 2766: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r12
	.word 0xdeb44400  ! 2767: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0xdcb6e000  ! 2768: STHA_I	stha	%r14, [%r27 + 0x0000] %asi
	.word 0xdcc66000  ! 2769: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	.word 0xd2d78e60  ! 2770: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r9
	mov	0x3f0, %r21
	.word 0x8780204f  ! 2772: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd087a000  ! 2773: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0xd49e89e0  ! 2774: LDDA_R	ldda	[%r26, %r0] 0x4f, %r10
	.word 0xd8878e40  ! 2775: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r12
	.word 0x87802020  ! 2776: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f78e40  ! 2777: STXA_R	stxa	%r11, [%r30 + %r0] 0x72
	.word 0x87802074  ! 2778: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4cd2000  ! 2779: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r10
	.word 0xd4d52000  ! 2780: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r10
	.word 0xd4b52000  ! 2781: STHA_I	stha	%r10, [%r20 + 0x0000] %asi
	.word 0xdaa70e60  ! 2782: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	.word 0xd6ad6000  ! 2783: STBA_I	stba	%r11, [%r21 + 0x0000] %asi
	.word 0xd2df0e60  ! 2784: LDXA_R	ldxa	[%r28, %r0] 0x73, %r9
	mov	0x60, %r26
	.word 0xd085a000  ! 2786: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r8
	mov	0x50, %r16
	.word 0x8780204f  ! 2788: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6978e60  ! 2789: LDUHA_R	lduha	[%r30, %r0] 0x73, %r11
	.word 0xd4f5c4a0  ! 2790: STXA_R	stxa	%r10, [%r23 + %r0] 0x25
	mov	0x48, %r17
	.word 0xd48ea000  ! 2792: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r10
	.word 0xd4de6000  ! 2793: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r10
	.word 0x87802020  ! 2794: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2795: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd484a000  ! 2796: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 2797: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4d7e000  ! 2798: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	mov	0x38, %r25
	mov	0x78, %r19
	.word 0x87802073  ! 2801: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 2802: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd49f2000  ! 2803: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd4df6000  ! 2804: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	mov	0x38, %r18
	.word 0x87802020  ! 2806: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r20
	.word 0xd4b7a000  ! 2808: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	mov	0x28, %r27
	mov	0x20, %r27
	mov	0x10, %r26
	mov	0x7f8, %r21
	.word 0xd4cc8400  ! 2813: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	.word 0xd6dfe000  ! 2814: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	mov	0x48, %r17
	.word 0xd697e000  ! 2816: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0xd697e000  ! 2817: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 2818: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ae09e0  ! 2819: STBA_R	stba	%r12, [%r24 + %r0] 0x4f
	.word 0x87802074  ! 2820: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd89fa000  ! 2821: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	.word 0x87802074  ! 2822: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 2823: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a62000  ! 2824: STWA_I	stwa	%r12, [%r24 + 0x0000] %asi
	.word 0xdaa74e60  ! 2825: STWA_R	stwa	%r13, [%r29 + %r0] 0x73
	.word 0x87802020  ! 2826: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2afa000  ! 2827: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 2828: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r25
	mov	0x10, %r18
	mov	0x3c8, %r22
	.word 0xd29e2000  ! 2832: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r9
	.word 0xd29dc4a0  ! 2833: LDDA_R	ldda	[%r23, %r0] 0x25, %r9
	.word 0xd6bc8400  ! 2834: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xd8c7ce60  ! 2835: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r12
	mov	0x3c8, %r21
	ta	T_CHANGE_PRIV	! macro
	mov	0x50, %r26
	.word 0xd686a000  ! 2839: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2840: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b76000  ! 2841: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	mov	0x50, %r17
	.word 0xd6f7a000  ! 2843: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 2844: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 2845: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6876000  ! 2846: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6afe000  ! 2847: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd8f70e40  ! 2848: STXA_R	stxa	%r12, [%r28 + %r0] 0x72
	mov	0x60, %r19
	.word 0xdaf76000  ! 2850: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 2851: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c0, %r22
	.word 0x87802020  ! 2853: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda972000  ! 2854: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0x87802074  ! 2855: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8afce40  ! 2856: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	mov	0x38, %r18
	.word 0xdcb74e80  ! 2858: STHA_R	stha	%r14, [%r29 + %r0] 0x74
	mov	0x58, %r25
	.word 0xdcf78e40  ! 2860: STXA_R	stxa	%r14, [%r30 + %r0] 0x72
	.word 0xd8a504a0  ! 2861: STWA_R	stwa	%r12, [%r20 + %r0] 0x25
	.word 0xd4dfe000  ! 2862: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd08689e0  ! 2863: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r8
	.word 0xd6bd44a0  ! 2864: STDA_R	stda	%r11, [%r21 + %r0] 0x25
	mov	0x3d8, %r23
	.word 0xd6f7ce40  ! 2866: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	.word 0xdcb48400  ! 2867: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	mov	0x50, %r19
	mov	0x18, %r24
	.word 0xd484c400  ! 2870: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	mov	0x10, %r26
	mov	0x78, %r18
	.word 0xd6f544a0  ! 2873: STXA_R	stxa	%r11, [%r21 + %r0] 0x25
	.word 0xdca76000  ! 2874: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 2875: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb46000  ! 2876: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	mov	0x10, %r19
	.word 0xdedf8e40  ! 2878: LDXA_R	ldxa	[%r30, %r0] 0x72, %r15
	.word 0x87802073  ! 2879: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6b78e40  ! 2880: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	.word 0xd8af0e40  ! 2881: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	.word 0xd4c4c400  ! 2882: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r10
	mov	0x48, %r19
	.word 0x87802020  ! 2884: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabf2000  ! 2885: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0x87802025  ! 2887: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2888: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaac2000  ! 2889: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	mov	0x60, %r26
	.word 0xdaa78e40  ! 2891: STWA_R	stwa	%r13, [%r30 + %r0] 0x72
	.word 0xd4cc6000  ! 2892: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	mov	0x0, %r16
	mov	0x3e0, %r21
	.word 0xd6a4c400  ! 2895: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0xdcac8400  ! 2896: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xdc942000  ! 2897: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	mov	0x3e8, %r20
	.word 0x87802073  ! 2899: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf7e000  ! 2900: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcbfe000  ! 2901: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0x87802020  ! 2903: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb7e000  ! 2904: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xdcc72000  ! 2906: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xd8d48400  ! 2907: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0x87802025  ! 2908: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 2909: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdece49e0  ! 2910: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r15
	.word 0x87802073  ! 2911: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2912: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r19
	.word 0xd4b7a000  ! 2914: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 2915: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0afce60  ! 2916: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	.word 0xd4b78e80  ! 2917: STHA_R	stha	%r10, [%r30 + %r0] 0x74
	.word 0xda8cc400  ! 2918: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	.word 0xd2dc8400  ! 2919: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0xd28504a0  ! 2920: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r9
	.word 0xde95c4a0  ! 2921: LDUHA_R	lduha	[%r23, %r0] 0x25, %r15
	.word 0xd6d5a000  ! 2922: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r11
	.word 0xdcbc4400  ! 2923: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0xdcf56000  ! 2924: STXA_I	stxa	%r14, [%r21 + 0x0000] %asi
	.word 0xdca70e60  ! 2925: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	.word 0xd09e09e0  ! 2926: LDDA_R	ldda	[%r24, %r0] 0x4f, %r8
	mov	0x38, %r18
	.word 0xdcf6c9e0  ! 2928: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	mov	0x28, %r16
	.word 0x87802025  ! 2930: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r18
	.word 0xde846000  ! 2932: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	mov	0x0, %r19
	.word 0xde8c6000  ! 2934: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	mov	0x3c8, %r20
	.word 0xded42000  ! 2936: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	.word 0xd0af4e40  ! 2937: STBA_R	stba	%r8, [%r29 + %r0] 0x72
	mov	0x40, %r27
	.word 0xdec4a000  ! 2939: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	mov	0x3c8, %r21
	.word 0xdcbc0400  ! 2941: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	mov	0x30, %r18
	mov	0x78, %r17
	mov	0x0, %r25
	.word 0xd6dc6000  ! 2945: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r11
	.word 0xd6f42000  ! 2946: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	mov	0x50, %r19
	.word 0x87802072  ! 2948: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd68d2000  ! 2949: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r11
	.word 0xdcafce40  ! 2950: STBA_R	stba	%r14, [%r31 + %r0] 0x72
	.word 0xd6a5a000  ! 2951: STWA_I	stwa	%r11, [%r22 + 0x0000] %asi
	.word 0xd0940400  ! 2952: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	mov	0x0, %r16
	.word 0xdca609e0  ! 2954: STWA_R	stwa	%r14, [%r24 + %r0] 0x4f
	.word 0xd4bd2000  ! 2955: STDA_I	stda	%r10, [%r20 + 0x0000] %asi
	.word 0xd49da000  ! 2956: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r10
	.word 0xdc970e60  ! 2957: LDUHA_R	lduha	[%r28, %r0] 0x73, %r14
	.word 0xd2bde000  ! 2958: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	.word 0xdcb7ce80  ! 2959: STHA_R	stha	%r14, [%r31 + %r0] 0x74
	mov	0x60, %r19
	mov	0x3e8, %r21
	.word 0xd6df4e40  ! 2962: LDXA_R	ldxa	[%r29, %r0] 0x72, %r11
	.word 0xd6b52000  ! 2963: STHA_I	stha	%r11, [%r20 + 0x0000] %asi
	.word 0xd6ad6000  ! 2964: STBA_I	stba	%r11, [%r21 + 0x0000] %asi
	.word 0x87802072  ! 2965: WRASI_I	wr	%r0, 0x0072, %asi
	wr_tick_cmpr_2_25:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xde, %g2
	or	%g4, 0x9e, %g4
	or	%g6, 0x9c, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3d8, %r20
	mov	0x10, %r26
	.word 0xdca689e0  ! 2969: STWA_R	stwa	%r14, [%r26 + %r0] 0x4f
	.word 0xd4d584a0  ! 2970: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r10
	.word 0xde8f4e40  ! 2971: LDUBA_R	lduba	[%r29, %r0] 0x72, %r15
	.word 0xd28cc400  ! 2972: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	mov	0x68, %r17
	.word 0xdef74e60  ! 2974: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	.word 0xdc8f0e80  ! 2975: LDUBA_R	lduba	[%r28, %r0] 0x74, %r14
	.word 0xd487e000  ! 2976: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd6af4e60  ! 2977: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	.word 0x87802072  ! 2978: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0a74e60  ! 2979: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	.word 0xd29c2000  ! 2980: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	.word 0xdcacc400  ! 2981: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0xd8bc2000  ! 2982: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd8a42000  ! 2983: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd89c6000  ! 2984: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r12
	.word 0xd8bca000  ! 2985: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd88ca000  ! 2986: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	.word 0xd8dca000  ! 2987: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	.word 0xd09c4400  ! 2988: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	.word 0xd4bc6000  ! 2989: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	mov	0x38, %r18
	.word 0x8780204f  ! 2991: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2992: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r22
	.word 0xd2b74e40  ! 2994: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	.word 0x87802020  ! 2995: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r21
	.word 0xde9f8e80  ! 2997: LDDA_R	ldda	[%r30, %r0] 0x74, %r15
	mov	0x7d0, %r22
	.word 0xdabf0e60  ! 2999: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	.word 0x8780204f  ! 3000: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3001: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r18
	.word 0x87802020  ! 3003: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f6c9e0  ! 3004: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	.word 0xd0bf4e80  ! 3005: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	.word 0x87802020  ! 3006: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r26
	mov	0x60, %r26
	.word 0xd6b48400  ! 3009: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xdef40400  ! 3010: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0xd0f42000  ! 3011: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	mov	0x3e0, %r20
	.word 0xdebf0e40  ! 3013: STDA_R	stda	%r15, [%r28 + %r0] 0x72
	.word 0x87802073  ! 3014: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdccf0e80  ! 3015: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r14
	.word 0xd2bfa000  ! 3016: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd6978e80  ! 3017: LDUHA_R	lduha	[%r30, %r0] 0x74, %r11
	.word 0xd6b584a0  ! 3018: STHA_R	stha	%r11, [%r22 + %r0] 0x25
	.word 0xd4f689e0  ! 3019: STXA_R	stxa	%r10, [%r26 + %r0] 0x4f
	.word 0x8780204f  ! 3020: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xded5c4a0  ! 3021: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r15
	.word 0xd6df6000  ! 3022: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6af6000  ! 3023: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd0d48400  ! 3024: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	mov	0x3e8, %r23
	.word 0xd4a48400  ! 3026: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xd8cfa000  ! 3027: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd897a000  ! 3028: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0xd8c76000  ! 3029: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	.word 0xd6b5c4a0  ! 3030: STHA_R	stha	%r11, [%r23 + %r0] 0x25
	.word 0xd2a48400  ! 3031: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0xd4af8e80  ! 3032: STBA_R	stba	%r10, [%r30 + %r0] 0x74
	.word 0x87802072  ! 3033: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r25
	.word 0xd88e2000  ! 3035: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r12
	.word 0x87802020  ! 3036: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3037: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd48584a0  ! 3038: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r10
	.word 0x87802025  ! 3039: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8ac2000  ! 3040: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 3041: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdacd44a0  ! 3042: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r13
	.word 0xdef44400  ! 3043: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xdeada000  ! 3044: STBA_I	stba	%r15, [%r22 + 0x0000] %asi
	.word 0x87802073  ! 3045: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r26
	mov	0x3c8, %r22
	.word 0xdeb7e000  ! 3048: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xd4bf8e40  ! 3049: STDA_R	stda	%r10, [%r30 + %r0] 0x72
	.word 0xd0d70e80  ! 3050: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r8
	.word 0x87802025  ! 3051: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0b70e80  ! 3052: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	mov	0x7e0, %r23
	mov	0x7c0, %r20
	.word 0xdeccc400  ! 3055: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r15
	.word 0xd2ac8400  ! 3056: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	mov	0x3c8, %r20
	.word 0xded6c9e0  ! 3058: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r15
	.word 0xdef70e40  ! 3059: STXA_R	stxa	%r15, [%r28 + %r0] 0x72
	mov	0x28, %r16
	.word 0xd29fe000  ! 3061: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3062: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf48400  ! 3063: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xd4b4e000  ! 3064: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xde9584a0  ! 3065: LDUHA_R	lduha	[%r22, %r0] 0x25, %r15
	.word 0x8780204f  ! 3066: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda94a000  ! 3067: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3068: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda87e000  ! 3069: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0x87802072  ! 3070: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8df4e40  ! 3071: LDXA_R	ldxa	[%r29, %r0] 0x72, %r12
	.word 0xdccd44a0  ! 3072: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r14
	mov	0x48, %r19
	.word 0xded689e0  ! 3074: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r15
	.word 0xd2b4e000  ! 3075: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	mov	0x38, %r25
	ta	T_CHANGE_PRIV	! macro
	.word 0x8780204f  ! 3078: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r26
	.word 0xded70e40  ! 3080: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r15
	.word 0xd6dc4400  ! 3081: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	mov	0x48, %r18
	.word 0x87802020  ! 3083: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r17
	.word 0xd6dce000  ! 3085: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0xd6b46000  ! 3086: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3087: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd697a000  ! 3088: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0xd6f76000  ! 3089: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	mov	0x20, %r26
	.word 0xd28c0400  ! 3091: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	.word 0xd2cf6000  ! 3092: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	.word 0xd2876000  ! 3093: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xde878e40  ! 3094: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r15
	.word 0x87802072  ! 3095: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f8, %r21
	.word 0xd2c42000  ! 3097: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	mov	0x50, %r24
	.word 0x87802020  ! 3099: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a48400  ! 3100: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0xd2944400  ! 3101: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	.word 0xd2848400  ! 3102: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r9
	.word 0xd6852000  ! 3103: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r11
	.word 0x87802073  ! 3104: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6d72000  ! 3105: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r11
	.word 0xda9544a0  ! 3106: LDUHA_R	lduha	[%r21, %r0] 0x25, %r13
	.word 0xdcf6c9e0  ! 3107: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	.word 0xda978e40  ! 3108: LDUHA_R	lduha	[%r30, %r0] 0x72, %r13
	.word 0xd4f7a000  ! 3109: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	mov	0x7d0, %r23
	mov	0x0, %r16
	.word 0x87802020  ! 3112: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3113: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 3114: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r25
	.word 0xd497ce80  ! 3116: LDUHA_R	lduha	[%r31, %r0] 0x74, %r10
	.word 0xdc8fa000  ! 3117: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xd8df4e60  ! 3118: LDXA_R	ldxa	[%r29, %r0] 0x73, %r12
	.word 0xdede09e0  ! 3119: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r15
	.word 0xdc96c9e0  ! 3120: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r14
	mov	0x8, %r18
	.word 0xdebfa000  ! 3122: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	mov	0x60, %r17
	.word 0xd6cc8400  ! 3124: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	.word 0xd2cc8400  ! 3125: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0xd297a000  ! 3126: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	mov	0x18, %r19
	.word 0x87802074  ! 3128: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3129: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r22
	mov	0x20, %r19
	.word 0xd29c2000  ! 3132: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	.word 0xd2f4a000  ! 3133: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 3134: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c74e80  ! 3135: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r12
	.word 0xdeaf6000  ! 3136: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 3137: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 3138: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 3139: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdecce000  ! 3140: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	.word 0x87802073  ! 3141: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdead6000  ! 3142: STBA_I	stba	%r15, [%r21 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0x8780204f  ! 3144: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r17
	mov	0x60, %r24
	.word 0x87802020  ! 3147: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d70e80  ! 3148: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r11
	.word 0xd0966000  ! 3149: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r8
	.word 0xd0bea000  ! 3150: STDA_I	stda	%r8, [%r26 + 0x0000] %asi
	.word 0x87802025  ! 3151: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 3152: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd88c4400  ! 3153: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	mov	0x7d8, %r21
	mov	0x10, %r27
	.word 0xd8b7a000  ! 3156: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	mov	0x60, %r25
	.word 0xd08dc4a0  ! 3158: LDUBA_R	lduba	[%r23, %r0] 0x25, %r8
	.word 0xdcdf0e80  ! 3159: LDXA_R	ldxa	[%r28, %r0] 0x74, %r14
	mov	0x7d8, %r23
	.word 0xd49f6000  ! 3161: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0x87802072  ! 3162: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3163: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r22
	.word 0xd4c56000  ! 3165: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r10
	.word 0xd6bf0e80  ! 3166: STDA_R	stda	%r11, [%r28 + %r0] 0x74
	.word 0xd485a000  ! 3167: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r10
	.word 0xd48de000  ! 3168: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r10
	.word 0xd49da000  ! 3169: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r10
	mov	0x50, %r19
	.word 0xd8f7ce40  ! 3171: STXA_R	stxa	%r12, [%r31 + %r0] 0x72
	.word 0xd89da000  ! 3172: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r12
	.word 0xd4ae89e0  ! 3173: STBA_R	stba	%r10, [%r26 + %r0] 0x4f
	.word 0xd8b504a0  ! 3174: STHA_R	stha	%r12, [%r20 + %r0] 0x25
	mov	0x7c0, %r22
	.word 0xdcdd2000  ! 3176: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r14
	mov	0x0, %r17
	.word 0xdcf5e000  ! 3178: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0xd8a609e0  ! 3179: STWA_R	stwa	%r12, [%r24 + %r0] 0x4f
	mov	0x78, %r27
	.word 0x8780204f  ! 3181: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeafe000  ! 3182: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	mov	0x50, %r26
	.word 0x87802072  ! 3184: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca584a0  ! 3185: STWA_R	stwa	%r14, [%r22 + %r0] 0x25
	.word 0xdedf0e80  ! 3186: LDXA_R	ldxa	[%r28, %r0] 0x74, %r15
	.word 0xd28e49e0  ! 3187: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r9
	.word 0x87802020  ! 3188: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bd2000  ! 3189: STDA_I	stda	%r12, [%r20 + 0x0000] %asi
	.word 0xd4cf8e60  ! 3190: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r10
	mov	0x7e0, %r23
	.word 0xd6c5a000  ! 3192: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r11
	.word 0xd6bda000  ! 3193: STDA_I	stda	%r11, [%r22 + 0x0000] %asi
	.word 0xd8be89e0  ! 3194: STDA_R	stda	%r12, [%r26 + %r0] 0x4f
	.word 0x87802073  ! 3195: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r16
	mov	0x3d0, %r23
	mov	0x7d8, %r22
	.word 0xdcd7ce40  ! 3199: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r14
	mov	0x68, %r24
	.word 0xdec7e000  ! 3201: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	mov	0x18, %r27
	.word 0xdeb76000  ! 3203: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xd6ac8400  ! 3204: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xd8d72000  ! 3205: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xd28f4e40  ! 3206: LDUBA_R	lduba	[%r29, %r0] 0x72, %r9
	.word 0xdcbf6000  ! 3207: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdcbf6000  ! 3208: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdc8fe000  ! 3209: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xdccfa000  ! 3210: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xdccf6000  ! 3211: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcb72000  ! 3212: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xdef48400  ! 3213: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xd0dd84a0  ! 3214: LDXA_R	ldxa	[%r22, %r0] 0x25, %r8
	.word 0xd6dc0400  ! 3215: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	.word 0xd6f74e80  ! 3216: STXA_R	stxa	%r11, [%r29 + %r0] 0x74
	wr_tick_cmpr_2_26:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xfc, %g2
	or	%g4, 0xc3, %g4
	or	%g6, 0xf7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd08fe000  ! 3218: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 3219: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0bfe000  ! 3220: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xdcb48400  ! 3221: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xdead84a0  ! 3222: STBA_R	stba	%r15, [%r22 + %r0] 0x25
	mov	0x20, %r26
	.word 0xda8dc4a0  ! 3224: LDUBA_R	lduba	[%r23, %r0] 0x25, %r13
	.word 0xdcaf2000  ! 3225: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	mov	0x7d0, %r20
	mov	0x3f8, %r20
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdaf544a0  ! 3229: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	wr_tick_cmpr_2_27:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf1, %g2
	or	%g4, 0x81, %g4
	or	%g6, 0xac, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4b72000  ! 3231: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd4af2000  ! 3232: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 3233: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdacc8400  ! 3234: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r13
	mov	0x28, %r18
	.word 0xdcd74e80  ! 3236: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r14
	mov	0x28, %r19
	.word 0xd8a62000  ! 3238: STWA_I	stwa	%r12, [%r24 + 0x0000] %asi
	.word 0x87802072  ! 3239: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r27
	.word 0xd4f70e80  ! 3241: STXA_R	stxa	%r10, [%r28 + %r0] 0x74
	.word 0xd0f56000  ! 3242: STXA_I	stxa	%r8, [%r21 + 0x0000] %asi
	mov	0x40, %r26
	.word 0xd2a48400  ! 3244: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0xd2b52000  ! 3245: STHA_I	stha	%r9, [%r20 + 0x0000] %asi
	.word 0xd6be49e0  ! 3246: STDA_R	stda	%r11, [%r25 + %r0] 0x4f
	.word 0xda948400  ! 3247: LDUHA_R	lduha	[%r18, %r0] 0x20, %r13
	.word 0xdebfce40  ! 3248: STDA_R	stda	%r15, [%r31 + %r0] 0x72
	.word 0x87802025  ! 3249: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 3250: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c0, %r21
	.word 0xd2bf0e60  ! 3252: STDA_R	stda	%r9, [%r28 + %r0] 0x73
	.word 0xd2af4e40  ! 3253: STBA_R	stba	%r9, [%r29 + %r0] 0x72
	.word 0xd6afa000  ! 3254: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6b649e0  ! 3255: STHA_R	stha	%r11, [%r25 + %r0] 0x4f
	mov	0x70, %r26
	.word 0xd0bcc400  ! 3257: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0x87802074  ! 3258: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2cd2000  ! 3259: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r9
	.word 0xdcf4c400  ! 3260: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xd0d56000  ! 3261: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r8
	.word 0x87802074  ! 3262: WRASI_I	wr	%r0, 0x0074, %asi
	wr_tick_cmpr_2_28:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xfb, %g2
	or	%g4, 0xf9, %g4
	or	%g6, 0xc9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0bc2000  ! 3264: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	.word 0xdc8f8e80  ! 3265: LDUBA_R	lduba	[%r30, %r0] 0x74, %r14
	.word 0xd2cca000  ! 3266: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	mov	0x60, %r19
	.word 0xd0bf8e80  ! 3268: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	.word 0xd8dca000  ! 3269: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	mov	0x7d0, %r20
	mov	0x58, %r26
	.word 0xd6cf8e40  ! 3272: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r11
	.word 0x8780204f  ! 3273: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 3274: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa46000  ! 3275: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	mov	0x0, %r26
	mov	0x7c8, %r22
	.word 0xdabce000  ! 3278: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0xd0b4c400  ! 3279: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0xd4bca000  ! 3280: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0xd4cce000  ! 3281: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	mov	0x20, %r19
	.word 0xda874e60  ! 3283: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r13
	.word 0x8780204f  ! 3284: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b78e40  ! 3285: STHA_R	stha	%r10, [%r30 + %r0] 0x72
	mov	0x48, %r17
	.word 0xdecc8400  ! 3287: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	.word 0x87802074  ! 3288: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3289: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ac0400  ! 3290: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0xde8f4e80  ! 3291: LDUBA_R	lduba	[%r29, %r0] 0x74, %r15
	.word 0xdaa40400  ! 3292: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0xd8f5e000  ! 3293: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	.word 0x87802073  ! 3294: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8aca000  ! 3295: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0xd88c2000  ! 3296: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	.word 0xdaa78e80  ! 3297: STWA_R	stwa	%r13, [%r30 + %r0] 0x74
	mov	0x40, %r17
	.word 0xdece49e0  ! 3299: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r15
	.word 0xdac42000  ! 3300: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0xd2d40400  ! 3301: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	.word 0xd8bc8400  ! 3302: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0x87802073  ! 3303: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c8, %r23
	mov	0x3f0, %r21
	.word 0xdef72000  ! 3306: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xdef7e000  ! 3307: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xde9fa000  ! 3308: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	mov	0x48, %r26
	.word 0xdcf5c4a0  ! 3310: STXA_R	stxa	%r14, [%r23 + %r0] 0x25
	.word 0xd0a72000  ! 3311: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0xd08cc400  ! 3313: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	.word 0xd0972000  ! 3314: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xd2cfce60  ! 3315: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r9
	.word 0x87802072  ! 3316: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcdf6000  ! 3317: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xd4b74e40  ! 3318: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	.word 0xd4a40400  ! 3319: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	.word 0xd0d70e80  ! 3320: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r8
	.word 0x87802020  ! 3321: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c74e40  ! 3322: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r9
	mov	0x78, %r25
	mov	0x3c8, %r22
	.word 0xd6f7e000  ! 3325: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0xd697a000  ! 3327: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0xd68fa000  ! 3328: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	mov	0x48, %r25
	.word 0xd0a70e60  ! 3330: STWA_R	stwa	%r8, [%r28 + %r0] 0x73
	.word 0xd0aec9e0  ! 3331: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	.word 0xd097ce40  ! 3332: LDUHA_R	lduha	[%r31, %r0] 0x72, %r8
	.word 0xdabf4e80  ! 3333: STDA_R	stda	%r13, [%r29 + %r0] 0x74
	.word 0xdecf6000  ! 3334: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	wr_tick_cmpr_2_29:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xab, %g2
	or	%g4, 0x9d, %g4
	or	%g6, 0x9a, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802074  ! 3336: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f4c400  ! 3337: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0xd0b42000  ! 3338: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	mov	0x28, %r17
	.word 0xd0cc2000  ! 3340: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	.word 0xdcdf0e60  ! 3341: LDXA_R	ldxa	[%r28, %r0] 0x73, %r14
	.word 0xdad4a000  ! 3342: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0x87802073  ! 3343: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c8, %r20
	.word 0xdaa72000  ! 3345: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xda9fe000  ! 3347: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	mov	0x18, %r25
	.word 0xdac72000  ! 3349: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0x87802074  ! 3350: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r24
	.word 0xdabc6000  ! 3352: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xd4bf0e60  ! 3353: STDA_R	stda	%r10, [%r28 + %r0] 0x73
	.word 0xdeac2000  ! 3354: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	mov	0x7c0, %r21
	.word 0xd0f649e0  ! 3356: STXA_R	stxa	%r8, [%r25 + %r0] 0x4f
	mov	0x20, %r25
	mov	0x38, %r26
	mov	0x28, %r18
	.word 0xda942000  ! 3360: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	mov	0x3f0, %r22
	.word 0xd8f7ce40  ! 3362: STXA_R	stxa	%r12, [%r31 + %r0] 0x72
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd6cc6000  ! 3364: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r11
	.word 0xdcf7ce80  ! 3365: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	.word 0xdacf8e60  ! 3366: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r13
	.word 0xd68c6000  ! 3367: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r11
	mov	0x48, %r18
	.word 0xdaac4400  ! 3369: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	.word 0x87802073  ! 3370: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdebfa000  ! 3371: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xd2bf0e40  ! 3372: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	.word 0xd0af2000  ! 3373: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd4a70e40  ! 3374: STWA_R	stwa	%r10, [%r28 + %r0] 0x72
	.word 0xdc8f2000  ! 3375: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0xdebe49e0  ! 3376: STDA_R	stda	%r15, [%r25 + %r0] 0x4f
	.word 0x87802025  ! 3377: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd68cc400  ! 3378: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	.word 0x87802025  ! 3379: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc966000  ! 3380: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r14
	mov	0x10, %r19
	mov	0x50, %r17
	.word 0xd0ad84a0  ! 3383: STBA_R	stba	%r8, [%r22 + %r0] 0x25
	mov	0x70, %r16
	.word 0xdade49e0  ! 3385: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r13
	.word 0xd2d504a0  ! 3386: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r9
	.word 0xdeb78e40  ! 3387: STHA_R	stha	%r15, [%r30 + %r0] 0x72
	.word 0xda8584a0  ! 3388: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r13
	.word 0xd4d62000  ! 3389: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r10
	.word 0xd8df8e60  ! 3390: LDXA_R	ldxa	[%r30, %r0] 0x73, %r12
	.word 0xd896e000  ! 3391: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r12
	.word 0xd8f66000  ! 3392: STXA_I	stxa	%r12, [%r25 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd8f4c400  ! 3394: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xd48ee000  ! 3395: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r10
	.word 0x87802025  ! 3396: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r24
	.word 0xd0d48400  ! 3398: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	mov	0x68, %r16
	.word 0x8780204f  ! 3400: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3401: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3402: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3403: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde976000  ! 3404: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	mov	0x38, %r26
	.word 0xdebf6000  ! 3406: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xd495c4a0  ! 3407: LDUHA_R	lduha	[%r23, %r0] 0x25, %r10
	.word 0xd0f74e40  ! 3408: STXA_R	stxa	%r8, [%r29 + %r0] 0x72
	.word 0xd4af6000  ! 3409: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd497a000  ! 3410: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	mov	0x48, %r26
	.word 0xd4a76000  ! 3412: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4976000  ! 3413: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r10
	mov	0x3c0, %r22
	.word 0xd2970e80  ! 3415: LDUHA_R	lduha	[%r28, %r0] 0x74, %r9
	.word 0xd0d74e80  ! 3416: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r8
	.word 0x87802020  ! 3417: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f6e000  ! 3418: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	mov	0x7c8, %r21
	.word 0x87802074  ! 3420: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0cf6000  ! 3421: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xdac689e0  ! 3422: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r13
	.word 0xdabf0e40  ! 3423: STDA_R	stda	%r13, [%r28 + %r0] 0x72
	.word 0xd8bf6000  ! 3424: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd8af0e80  ! 3425: STBA_R	stba	%r12, [%r28 + %r0] 0x74
	mov	0x68, %r19
	.word 0x87802074  ! 3427: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0d7a000  ! 3428: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	mov	0x38, %r24
	mov	0x40, %r18
	.word 0xd0c7e000  ! 3431: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0x87802025  ! 3432: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f48400  ! 3433: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xdec70e40  ! 3434: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r15
	.word 0x87802073  ! 3435: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2a4a000  ! 3436: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	mov	0x78, %r27
	mov	0x48, %r16
	.word 0xd4c7ce60  ! 3439: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r10
	.word 0xde842000  ! 3440: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	mov	0x0, %r16
	mov	0x18, %r16
	mov	0x18, %r17
	mov	0x3d0, %r20
	mov	0x3e0, %r22
	.word 0xdebca000  ! 3446: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xdec78e40  ! 3447: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r15
	.word 0xd2846000  ! 3448: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r9
	.word 0xd6de09e0  ! 3449: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r11
	.word 0xdecf4e60  ! 3450: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r15
	.word 0xde84a000  ! 3451: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	.word 0x87802072  ! 3452: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde84e000  ! 3453: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	.word 0xd2a4c400  ! 3454: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0xd8d48400  ! 3455: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0xdadc2000  ! 3456: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3457: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabd84a0  ! 3458: STDA_R	stda	%r13, [%r22 + %r0] 0x25
	mov	0x50, %r27
	.word 0x87802073  ! 3460: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8de6000  ! 3461: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r12
	mov	0x58, %r17
	.word 0xd8b6e000  ! 3463: STHA_I	stha	%r12, [%r27 + 0x0000] %asi
	.word 0xd0a74e40  ! 3464: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	.word 0x87802025  ! 3465: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcd7ce40  ! 3466: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r14
	mov	0x68, %r26
	.word 0xdcd7a000  ! 3468: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	mov	0x70, %r18
	.word 0xdcdfe000  ! 3470: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xd2ac4400  ! 3471: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	mov	0x28, %r19
	.word 0xd0d76000  ! 3473: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0b7e000  ! 3474: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0xdebf0e80  ! 3475: STDA_R	stda	%r15, [%r28 + %r0] 0x74
	.word 0x87802025  ! 3476: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8b46000  ! 3477: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0x87802020  ! 3479: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c7a000  ! 3480: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xd0bd44a0  ! 3481: STDA_R	stda	%r8, [%r21 + %r0] 0x25
	.word 0x87802020  ! 3482: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcac2000  ! 3483: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0xdcb4e000  ! 3484: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xdc946000  ! 3485: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r14
	mov	0x58, %r26
	mov	0x60, %r24
	.word 0xd8d4c400  ! 3488: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	mov	0x7d0, %r21
	.word 0xde942000  ! 3490: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	mov	0x7c0, %r22
	.word 0xdeace000  ! 3492: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	mov	0x0, %r17
	.word 0xdeb46000  ! 3494: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3495: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef70e40  ! 3496: STXA_R	stxa	%r15, [%r28 + %r0] 0x72
	.word 0xd0ad84a0  ! 3497: STBA_R	stba	%r8, [%r22 + %r0] 0x25
	.word 0x87802020  ! 3498: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd084c400  ! 3499: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r8
	.word 0xd2ac6000  ! 3500: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xd0f78e40  ! 3502: STXA_R	stxa	%r8, [%r30 + %r0] 0x72
	.word 0xd6b46000  ! 3503: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd6f46000  ! 3504: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 3505: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b5a000  ! 3506: STHA_I	stha	%r11, [%r22 + 0x0000] %asi
	.word 0xd0ac8400  ! 3507: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xd2f56000  ! 3508: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	.word 0xd2d56000  ! 3509: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r9
	mov	0x10, %r17
	mov	0x38, %r18
	mov	0x3d8, %r22
	mov	0x28, %r27
	.word 0xd2c5a000  ! 3514: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r9
	mov	0x7c0, %r23
	.word 0x87802025  ! 3516: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r25
	.word 0x87802073  ! 3518: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b544a0  ! 3519: STHA_R	stha	%r8, [%r21 + %r0] 0x25
	.word 0x87802073  ! 3520: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 3521: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r18
	.word 0x87802074  ! 3523: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc9f6000  ! 3524: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xd2b40400  ! 3525: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0xd8c74e40  ! 3526: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r12
	mov	0x78, %r19
	.word 0xd28ec9e0  ! 3528: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r9
	.word 0xdec7e000  ! 3529: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3530: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0b689e0  ! 3532: STHA_R	stha	%r8, [%r26 + %r0] 0x4f
	.word 0x8780204f  ! 3533: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0ccc400  ! 3534: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	mov	0x7f0, %r23
	mov	0x3c0, %r22
	wr_tick_cmpr_2_30:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xa1, %g2
	or	%g4, 0xba, %g4
	or	%g6, 0xa2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x8780204f  ! 3538: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3539: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0972000  ! 3540: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0872000  ! 3541: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	mov	0x3d0, %r21
	.word 0xd0cf2000  ! 3543: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	mov	0x10, %r26
	.word 0xd0c72000  ! 3545: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0af6000  ! 3546: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0xd89544a0  ! 3548: LDUHA_R	lduha	[%r21, %r0] 0x25, %r12
	.word 0xdc9f6000  ! 3549: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xdc87e000  ! 3550: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcaf6000  ! 3551: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 3552: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca46000  ! 3553: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xdaf6c9e0  ! 3554: STXA_R	stxa	%r13, [%r27 + %r0] 0x4f
	.word 0xd8bca000  ! 3555: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	mov	0x58, %r26
	.word 0xd8c42000  ! 3557: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r12
	.word 0x87802025  ! 3558: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 3559: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 3560: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3561: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8af2000  ! 3562: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 3563: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d0, %r22
	.word 0xd0dd44a0  ! 3565: LDXA_R	ldxa	[%r21, %r0] 0x25, %r8
	.word 0xd6c78e40  ! 3566: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	.word 0xd6c7ce60  ! 3567: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r11
	.word 0xdaafce80  ! 3568: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	.word 0xda862000  ! 3569: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r13
	.word 0xdece09e0  ! 3570: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r15
	.word 0xdab62000  ! 3571: STHA_I	stha	%r13, [%r24 + 0x0000] %asi
	.word 0x87802073  ! 3572: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r27
	.word 0xde9fce40  ! 3574: LDDA_R	ldda	[%r31, %r0] 0x72, %r15
	.word 0xd8ac4400  ! 3575: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xdcac0400  ! 3576: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	mov	0x3e0, %r20
	mov	0x3e0, %r23
	.word 0xd0862000  ! 3579: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r8
	.word 0xd08e2000  ! 3580: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r8
	.word 0xd0f6e000  ! 3581: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	mov	0x7d0, %r21
	mov	0x3d8, %r21
	.word 0x87802025  ! 3584: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0cfe000  ! 3585: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	mov	0x7e8, %r21
	mov	0x28, %r26
	.word 0xd08fa000  ! 3588: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	mov	0x50, %r18
	.word 0xd0a74e40  ! 3590: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	.word 0xda8504a0  ! 3591: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r13
	.word 0xdcf70e80  ! 3592: STXA_R	stxa	%r14, [%r28 + %r0] 0x74
	.word 0xded7a000  ! 3593: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xde8f2000  ! 3594: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xdebf2000  ! 3595: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xded48400  ! 3596: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	mov	0x78, %r17
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x30, %r25
	.word 0x87802020  ! 3600: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9f8e80  ! 3601: LDDA_R	ldda	[%r30, %r0] 0x74, %r14
	.word 0xda9f2000  ! 3602: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xda8f2000  ! 3603: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xdab72000  ! 3604: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xd085c4a0  ! 3605: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r8
	.word 0xdedfe000  ! 3606: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xdef72000  ! 3607: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xdeb76000  ! 3608: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xde8fe000  ! 3609: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	mov	0x20, %r19
	mov	0x38, %r27
	.word 0xde8fe000  ! 3612: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0xdec72000  ! 3613: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xded72000  ! 3614: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	mov	0x60, %r17
	.word 0xde976000  ! 3616: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3617: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f44400  ! 3618: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 3619: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 3620: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd885c4a0  ! 3621: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r12
	mov	0x60, %r16
	.word 0xd8bca000  ! 3623: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 3624: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r20
	.word 0xd2d70e60  ! 3626: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r9
	.word 0xd4a78e40  ! 3627: STWA_R	stwa	%r10, [%r30 + %r0] 0x72
	.word 0xd2846000  ! 3628: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r9
	mov	0x7e0, %r21
	mov	0x30, %r17
	.word 0xd695c4a0  ! 3631: LDUHA_R	lduha	[%r23, %r0] 0x25, %r11
	.word 0xdedc2000  ! 3632: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r15
	.word 0xd0f5c4a0  ! 3633: STXA_R	stxa	%r8, [%r23 + %r0] 0x25
	mov	0x7e0, %r20
	mov	0x48, %r19
	.word 0xdac48400  ! 3636: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	.word 0xd8d6c9e0  ! 3637: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r12
	mov	0x7f0, %r22
	.word 0xdebcc400  ! 3639: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	.word 0xd8970e60  ! 3640: LDUHA_R	lduha	[%r28, %r0] 0x73, %r12
	mov	0x20, %r24
	.word 0xd0a7ce60  ! 3642: STWA_R	stwa	%r8, [%r31 + %r0] 0x73
	mov	0x60, %r26
	.word 0xd4a4e000  ! 3644: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xd4f46000  ! 3645: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 3646: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4b46000  ! 3647: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xdeb40400  ! 3648: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0xdaf78e60  ! 3649: STXA_R	stxa	%r13, [%r30 + %r0] 0x73
	.word 0xd0f609e0  ! 3650: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	.word 0xd2d689e0  ! 3651: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r9
	wr_tick_cmpr_2_31:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa4, %g2
	or	%g4, 0xd0, %g4
	or	%g6, 0xa1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8bf4e60  ! 3653: STDA_R	stda	%r12, [%r29 + %r0] 0x73
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802072  ! 3655: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd294c400  ! 3656: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	mov	0x78, %r18
	.word 0xdaf4a000  ! 3658: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0xd8f7ce80  ! 3659: STXA_R	stxa	%r12, [%r31 + %r0] 0x74
	.word 0xd6bc6000  ! 3660: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0xd2af0e40  ! 3661: STBA_R	stba	%r9, [%r28 + %r0] 0x72
	.word 0xd0dce000  ! 3662: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r8
	.word 0xd694c400  ! 3663: LDUHA_R	lduha	[%r19, %r0] 0x20, %r11
	.word 0xd0ce89e0  ! 3664: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r8
	mov	0x70, %r26
	.word 0xd28ca000  ! 3666: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	mov	0x50, %r18
	.word 0x87802073  ! 3668: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x3e8, %r23
	.word 0xd2a56000  ! 3671: STWA_I	stwa	%r9, [%r21 + 0x0000] %asi
	.word 0xd2bd2000  ! 3672: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	.word 0xd2cd6000  ! 3673: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r9
	mov	0x58, %r19
	.word 0xd29d6000  ! 3675: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r9
	.word 0xd29da000  ! 3676: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3677: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b7ce80  ! 3678: STHA_R	stha	%r11, [%r31 + %r0] 0x74
	mov	0x38, %r19
	.word 0xd6ac6000  ! 3680: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	mov	0x20, %r26
	.word 0xd6ac6000  ! 3682: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	mov	0x8, %r19
	mov	0x20, %r17
	.word 0xd6ac6000  ! 3685: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xd68ce000  ! 3686: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	.word 0xd6bce000  ! 3687: STDA_I	stda	%r11, [%r19 + 0x0000] %asi
	mov	0x18, %r16
	.word 0xd8a649e0  ! 3689: STWA_R	stwa	%r12, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 3690: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3691: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d0, %r20
	.word 0xdab7ce40  ! 3693: STHA_R	stha	%r13, [%r31 + %r0] 0x72
	.word 0xd6d7ce40  ! 3694: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r11
	.word 0x87802072  ! 3695: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6cca000  ! 3696: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r11
	.word 0xdcf7ce60  ! 3697: STXA_R	stxa	%r14, [%r31 + %r0] 0x73
	.word 0xd2f4a000  ! 3698: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x3e8, %r23
	.word 0xd8f48400  ! 3701: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 3702: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b7e000  ! 3703: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xdcf504a0  ! 3704: STXA_R	stxa	%r14, [%r20 + %r0] 0x25
	.word 0xd8b7a000  ! 3705: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xd2ae49e0  ! 3706: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	mov	0x70, %r27
	.word 0xdedc0400  ! 3708: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	.word 0xd2a7ce80  ! 3709: STWA_R	stwa	%r9, [%r31 + %r0] 0x74
	mov	0x48, %r19
	mov	0x3d0, %r20
	.word 0xdabfe000  ! 3712: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xdaa76000  ! 3713: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0xdaafe000  ! 3715: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 3716: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9de000  ! 3717: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r13
	.word 0xd4d4c400  ! 3718: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0x8780204f  ! 3719: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9dc4a0  ! 3720: LDDA_R	ldda	[%r23, %r0] 0x25, %r13
	.word 0xdebda000  ! 3721: STDA_I	stda	%r15, [%r22 + 0x0000] %asi
	.word 0xdea5e000  ! 3722: STWA_I	stwa	%r15, [%r23 + 0x0000] %asi
	.word 0xdeb56000  ! 3723: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	.word 0xd4cd84a0  ! 3724: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r10
	.word 0xdabf0e60  ! 3725: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	mov	0x7d8, %r23
	.word 0xd2f5e000  ! 3727: STXA_I	stxa	%r9, [%r23 + 0x0000] %asi
	mov	0x58, %r24
	.word 0xd8be49e0  ! 3729: STDA_R	stda	%r12, [%r25 + %r0] 0x4f
	.word 0xdeaec9e0  ! 3730: STBA_R	stba	%r15, [%r27 + %r0] 0x4f
	.word 0xd49da000  ! 3731: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r10
	.word 0xd4c56000  ! 3732: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r10
	.word 0xd4ade000  ! 3733: STBA_I	stba	%r10, [%r23 + 0x0000] %asi
	mov	0x0, %r25
	.word 0xd4cda000  ! 3735: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r10
	.word 0x87802025  ! 3736: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8ad44a0  ! 3737: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	mov	0x7c0, %r20
	.word 0xd68ca000  ! 3739: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r11
	.word 0xd6aca000  ! 3740: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 3741: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bf2000  ! 3742: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd49f4e40  ! 3743: LDDA_R	ldda	[%r29, %r0] 0x72, %r10
	.word 0xdcf78e40  ! 3744: STXA_R	stxa	%r14, [%r30 + %r0] 0x72
	.word 0x8780204f  ! 3745: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a5c4a0  ! 3746: STWA_R	stwa	%r8, [%r23 + %r0] 0x25
	.word 0xd0dc0400  ! 3747: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xd49fa000  ! 3748: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0x87802074  ! 3749: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f7ce40  ! 3750: STXA_R	stxa	%r8, [%r31 + %r0] 0x72
	.word 0xdaaf6000  ! 3751: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xd8b7ce40  ! 3752: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0xd8cfa000  ! 3753: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd8d7e000  ! 3754: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0xd89fa000  ! 3755: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	.word 0xdeb544a0  ! 3756: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	.word 0xd09c0400  ! 3757: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	.word 0xdc8fe000  ! 3758: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xdc8d84a0  ! 3759: LDUBA_R	lduba	[%r22, %r0] 0x25, %r14
	mov	0x7f8, %r21
	.word 0x87802020  ! 3761: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca40400  ! 3762: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xd49fa000  ! 3763: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0xd4cf6000  ! 3764: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0xdca48400  ! 3765: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xda8544a0  ! 3766: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r13
	.word 0xd4af6000  ! 3767: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd4df2000  ! 3768: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0x87802072  ! 3769: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49da000  ! 3770: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r10
	mov	0x48, %r27
	mov	0x60, %r16
	.word 0xd4a5a000  ! 3773: STWA_I	stwa	%r10, [%r22 + 0x0000] %asi
	.word 0xd4bd2000  ! 3774: STDA_I	stda	%r10, [%r20 + 0x0000] %asi
	.word 0x8780204f  ! 3775: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r18
	.word 0xd28584a0  ! 3777: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r9
	mov	0x78, %r25
	.word 0xdac7a000  ! 3779: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xdac7a000  ! 3780: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xda9fa000  ! 3781: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	mov	0x3f0, %r22
	.word 0x87802020  ! 3783: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f4c400  ! 3784: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xdaac0400  ! 3785: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xd09689e0  ! 3786: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r8
	mov	0x10, %r19
	.word 0xdabec9e0  ! 3788: STDA_R	stda	%r13, [%r27 + %r0] 0x4f
	.word 0xdc9c8400  ! 3789: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0x87802072  ! 3790: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f4c400  ! 3791: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0xd2ac4400  ! 3792: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	mov	0x18, %r25
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x48, %r17
	.word 0xd8dce000  ! 3796: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 3797: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bf2000  ! 3798: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd8b72000  ! 3799: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd8df6000  ! 3800: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0xd88f6000  ! 3801: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xd88f2000  ! 3802: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	mov	0x7f8, %r22
	.word 0xd8f72000  ! 3804: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 3805: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r27
	.word 0xd89ce000  ! 3807: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	.word 0x87802073  ! 3808: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc9ec9e0  ! 3809: LDDA_R	ldda	[%r27, %r0] 0x4f, %r14
	.word 0xd2c72000  ! 3810: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd0878e60  ! 3811: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r8
	.word 0xd0af8e40  ! 3812: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0xdebfe000  ! 3813: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xdc9c8400  ! 3814: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0xde9fa000  ! 3815: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	.word 0xdea72000  ! 3816: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xdef7e000  ! 3817: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xd4cf8e80  ! 3818: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r10
	mov	0x40, %r25
	.word 0xdebf2000  ! 3820: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xdea76000  ! 3821: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	mov	0x38, %r16
	.word 0xdebfa000  ! 3823: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xdedfa000  ! 3824: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xdea76000  ! 3825: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	mov	0x8, %r24
	mov	0x3c0, %r20
	.word 0x8780204f  ! 3828: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xded62000  ! 3829: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r15
	.word 0xde978e80  ! 3830: LDUHA_R	lduha	[%r30, %r0] 0x74, %r15
	.word 0xdcf6a000  ! 3831: STXA_I	stxa	%r14, [%r26 + 0x0000] %asi
	.word 0xdcf66000  ! 3832: STXA_I	stxa	%r14, [%r25 + 0x0000] %asi
	.word 0xd0b5c4a0  ! 3833: STHA_R	stha	%r8, [%r23 + %r0] 0x25
	.word 0xd6ce2000  ! 3834: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3835: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3836: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f7e000  ! 3837: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 3838: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4c48400  ! 3839: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r10
	.word 0xda8fe000  ! 3840: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xdac72000  ! 3841: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	mov	0x7e8, %r20
	mov	0x3f8, %r21
	.word 0xd49cc400  ! 3844: LDDA_R	ldda	[%r19, %r0] 0x20, %r10
	mov	0x28, %r27
	.word 0x87802025  ! 3846: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r18
	.word 0x87802025  ! 3848: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad48400  ! 3849: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0xdec6c9e0  ! 3850: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r15
	mov	0x30, %r27
	mov	0x7e0, %r21
	.word 0xd8ae2000  ! 3853: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	.word 0xd6f48400  ! 3854: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xdcde6000  ! 3855: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r14
	.word 0xd8cf4e60  ! 3856: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r12
	.word 0xd886e000  ! 3857: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r12
	.word 0xd8d6a000  ! 3858: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r12
	.word 0x87802020  ! 3859: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8856000  ! 3860: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	mov	0x48, %r26
	.word 0xd8ad6000  ! 3862: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	.word 0xd8f5e000  ! 3863: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	.word 0x87802073  ! 3864: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r27
	.word 0x87802020  ! 3866: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r26
	.word 0xd2df4e80  ! 3868: LDXA_R	ldxa	[%r29, %r0] 0x74, %r9
	.word 0xd684a000  ! 3869: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r11
	.word 0xd6dce000  ! 3870: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0xd68c2000  ! 3871: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r11
	mov	0x30, %r27
	.word 0xd6c42000  ! 3873: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r11
	.word 0xd6aca000  ! 3874: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xd6dd44a0  ! 3875: LDXA_R	ldxa	[%r21, %r0] 0x25, %r11
	.word 0xdcf70e60  ! 3876: STXA_R	stxa	%r14, [%r28 + %r0] 0x73
	.word 0xde848400  ! 3877: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	.word 0x87802073  ! 3878: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r17
	mov	0x7d0, %r21
	.word 0xd8c70e60  ! 3881: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r12
	.word 0xdad7a000  ! 3882: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	wr_tick_cmpr_2_32:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf7, %g2
	or	%g4, 0xc9, %g4
	or	%g6, 0xfe, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 3884: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r27
	.word 0xd0f40400  ! 3886: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xd48fe000  ! 3887: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xd4df6000  ! 3888: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0xd6bc0400  ! 3889: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xdc87e000  ! 3890: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcb7ce80  ! 3891: STHA_R	stha	%r14, [%r31 + %r0] 0x74
	.word 0xd2bfa000  ! 3892: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd29fe000  ! 3893: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xdccf8e60  ! 3894: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r14
	.word 0xde87a000  ! 3895: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xd0bfce60  ! 3896: STDA_R	stda	%r8, [%r31 + %r0] 0x73
	mov	0x30, %r17
	.word 0xd0aec9e0  ! 3898: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	.word 0xd8bf2000  ! 3899: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd8cfe000  ! 3900: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8bfa000  ! 3901: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd887a000  ! 3902: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	mov	0x7f8, %r22
	.word 0xd88f6000  ! 3904: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xd0ae49e0  ! 3905: STBA_R	stba	%r8, [%r25 + %r0] 0x4f
	mov	0x8, %r17
	.word 0x87802074  ! 3907: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0872000  ! 3908: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xd6a4c400  ! 3909: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0xd48d04a0  ! 3910: LDUBA_R	lduba	[%r20, %r0] 0x25, %r10
	.word 0xd6972000  ! 3911: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	.word 0xdaafce60  ! 3912: STBA_R	stba	%r13, [%r31 + %r0] 0x73
	mov	0x70, %r19
	mov	0x30, %r18
	.word 0xd0bfe000  ! 3915: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 3916: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f7a000  ! 3917: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0bf6000  ! 3918: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	mov	0x78, %r19
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd29c0400  ! 3921: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	.word 0xdaa689e0  ! 3922: STWA_R	stwa	%r13, [%r26 + %r0] 0x4f
	.word 0x87802072  ! 3923: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3924: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd696a000  ! 3925: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r11
	.word 0xd2dec9e0  ! 3926: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r9
	.word 0xdcc6a000  ! 3927: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r14
	mov	0x60, %r25
	.word 0xdc9e2000  ! 3929: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r14
	mov	0x7d8, %r20
	.word 0xdcf6a000  ! 3931: STXA_I	stxa	%r14, [%r26 + 0x0000] %asi
	.word 0xdcc44400  ! 3932: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xdabe6000  ! 3933: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	.word 0xd2f78e40  ! 3934: STXA_R	stxa	%r9, [%r30 + %r0] 0x72
	.word 0xd8c48400  ! 3935: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	.word 0xdcf6a000  ! 3936: STXA_I	stxa	%r14, [%r26 + 0x0000] %asi
	.word 0xd68cc400  ! 3937: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	.word 0xd6f4c400  ! 3938: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	mov	0x38, %r26
	mov	0x7d8, %r21
	.word 0xdcb62000  ! 3941: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	.word 0xd4b74e40  ! 3942: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	mov	0x18, %r24
	.word 0xdc86e000  ! 3944: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r14
	.word 0xd2bf8e40  ! 3945: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	.word 0x87802020  ! 3946: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r23
	mov	0x28, %r24
	.word 0xd086e000  ! 3949: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r8
	.word 0xd0b66000  ! 3950: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	mov	0x0, %r16
	.word 0xd0b6e000  ! 3952: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd0c66000  ! 3954: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r8
	.word 0xde9f0e40  ! 3955: LDDA_R	ldda	[%r28, %r0] 0x72, %r15
	mov	0x18, %r16
	mov	0x7d8, %r21
	.word 0xd8d6a000  ! 3958: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r12
	.word 0x87802072  ! 3959: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r17
	mov	0x48, %r24
	.word 0x87802025  ! 3962: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r24
	mov	0x68, %r18
	.word 0x87802020  ! 3965: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r22
	.word 0xd6b70e80  ! 3967: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	mov	0x40, %r25
	.word 0xd4f5e000  ! 3969: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0xd6f74e40  ! 3971: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	.word 0x87802074  ! 3972: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdac76000  ! 3973: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0xdac4c400  ! 3974: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r13
	.word 0xd497e000  ! 3975: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	.word 0xd2d7ce40  ! 3976: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r9
	.word 0xd6ac8400  ! 3977: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xdab4c400  ! 3978: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	mov	0x10, %r18
	.word 0x87802073  ! 3980: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a5c4a0  ! 3981: STWA_R	stwa	%r8, [%r23 + %r0] 0x25
	.word 0xd4ae49e0  ! 3982: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0xda8ce000  ! 3983: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	mov	0x3e8, %r23
	mov	0x38, %r17
	.word 0xdac42000  ! 3986: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	mov	0x78, %r24
	.word 0xdabce000  ! 3988: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0xd88f4e60  ! 3989: LDUBA_R	lduba	[%r29, %r0] 0x73, %r12
	.word 0xd6aca000  ! 3990: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xd6bca000  ! 3991: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 3992: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd09d44a0  ! 3993: LDDA_R	ldda	[%r21, %r0] 0x25, %r8
	.word 0xd0aec9e0  ! 3994: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	.word 0xdcb7e000  ! 3995: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 3996: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bf4e60  ! 3997: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	.word 0xd886c9e0  ! 3998: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r12
	mov	0x7c0, %r21
	.word 0xdcb4e000  ! 4000: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	mov	0x3d8, %r21
	.word 0x87802025  ! 4002: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcdd6000  ! 4003: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r14
	.word 0xd88fce40  ! 4004: LDUBA_R	lduba	[%r31, %r0] 0x72, %r12
	.word 0xd4f5e000  ! 4005: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 4006: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r19
	.word 0x87802072  ! 4008: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 4009: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4866000  ! 4010: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r10
	.word 0xd8a5c4a0  ! 4011: STWA_R	stwa	%r12, [%r23 + %r0] 0x25
	mov	0x30, %r27
	.word 0x87802020  ! 4013: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4014: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f70e40  ! 4015: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	.word 0xd6874e60  ! 4016: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r11
	.word 0xdeb46000  ! 4017: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0xde846000  ! 4018: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	mov	0x70, %r19
	mov	0x68, %r24
	mov	0x0, %r27
	.word 0xd2dc0400  ! 4022: LDXA_R	ldxa	[%r16, %r0] 0x20, %r9
	.word 0xdcdc2000  ! 4023: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r14
	.word 0xda9d84a0  ! 4024: LDDA_R	ldda	[%r22, %r0] 0x25, %r13
	mov	0x60, %r26
	.word 0xdadca000  ! 4026: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	mov	0x7c0, %r22
	.word 0xdaf46000  ! 4028: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0xdadce000  ! 4029: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xdcb74e60  ! 4030: STHA_R	stha	%r14, [%r29 + %r0] 0x73
	.word 0xde84a000  ! 4031: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	.word 0xdec4a000  ! 4032: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	mov	0x58, %r16
	mov	0x3d8, %r21
	mov	0x68, %r27
	.word 0xdef42000  ! 4036: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4037: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r18
	.word 0xdeb7a000  ! 4039: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xdcf544a0  ! 4040: STXA_R	stxa	%r14, [%r21 + %r0] 0x25
	mov	0x60, %r17
	.word 0x87802072  ! 4042: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef78e60  ! 4043: STXA_R	stxa	%r15, [%r30 + %r0] 0x73
	mov	0x68, %r18
	.word 0x87802074  ! 4045: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef52000  ! 4046: STXA_I	stxa	%r15, [%r20 + 0x0000] %asi
	.word 0xdcdcc400  ! 4047: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	.word 0xd0944400  ! 4048: LDUHA_R	lduha	[%r17, %r0] 0x20, %r8
	.word 0xd09d84a0  ! 4049: LDDA_R	ldda	[%r22, %r0] 0x25, %r8
	.word 0xd0f5a000  ! 4050: STXA_I	stxa	%r8, [%r22 + 0x0000] %asi
	.word 0xdabdc4a0  ! 4051: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	.word 0xd2d5e000  ! 4052: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r9
	mov	0x68, %r19
	.word 0xd2c52000  ! 4054: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r9
	mov	0x68, %r25
	.word 0x87802020  ! 4056: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29c2000  ! 4057: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	.word 0xda8f8e60  ! 4058: LDUBA_R	lduba	[%r30, %r0] 0x73, %r13
	mov	0x40, %r17
	.word 0xdcace000  ! 4060: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	mov	0x7e0, %r22
	mov	0x68, %r16
	.word 0xdcf42000  ! 4063: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	mov	0x78, %r27
	.word 0xdcc46000  ! 4065: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r14
	.word 0xdcd46000  ! 4066: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	wr_tick_cmpr_2_33:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xac, %g2
	or	%g4, 0x9a, %g4
	or	%g6, 0xa9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdcdc2000  ! 4068: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r14
	.word 0xdc8e09e0  ! 4069: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r14
	mov	0x70, %r16
	.word 0xd8bca000  ! 4071: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd88c6000  ! 4072: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	.word 0xd8d42000  ! 4073: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0x87802072  ! 4074: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8bca000  ! 4075: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	mov	0x0, %r17
	.word 0xd8a4a000  ! 4077: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd6a649e0  ! 4078: STWA_R	stwa	%r11, [%r25 + %r0] 0x4f
	.word 0xd294a000  ! 4079: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r9
	.word 0xd2c46000  ! 4080: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0xdea74e60  ! 4081: STWA_R	stwa	%r15, [%r29 + %r0] 0x73
	.word 0xd89c6000  ! 4082: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r12
	.word 0xd8dca000  ! 4083: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	.word 0xd0afce80  ! 4084: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0dc6000  ! 4086: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	.word 0xdadf8e40  ! 4087: LDXA_R	ldxa	[%r30, %r0] 0x72, %r13
	.word 0x87802020  ! 4088: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c78e40  ! 4089: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r9
	.word 0xdc94a000  ! 4090: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4091: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r21
	wr_tick_cmpr_2_34:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xba, %g2
	or	%g4, 0xed, %g4
	or	%g6, 0x96, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdcbe2000  ! 4094: STDA_I	stda	%r14, [%r24 + 0x0000] %asi
	.word 0x8780204f  ! 4095: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r26
	.word 0xd4cfce80  ! 4097: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r10
	.word 0xd6944400  ! 4098: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	mov	0x50, %r26
	.word 0xd6b76000  ! 4100: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 4101: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4102: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d7a000  ! 4103: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	.word 0xd6b7e000  ! 4104: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xdebd84a0  ! 4105: STDA_R	stda	%r15, [%r22 + %r0] 0x25
	mov	0x3c8, %r22
	.word 0xdcd4c400  ! 4107: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	.word 0x87802073  ! 4108: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde8c6000  ! 4109: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0xdc8c8400  ! 4110: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0xd0f74e80  ! 4111: STXA_R	stxa	%r8, [%r29 + %r0] 0x74
	.word 0xdef48400  ! 4112: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xd2ac2000  ! 4113: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd2bc6000  ! 4114: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0xd284a000  ! 4115: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	mov	0x48, %r25
	.word 0xd294a000  ! 4117: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r9
	.word 0xd0848400  ! 4118: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r8
	.word 0xd0a4a000  ! 4119: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	mov	0x0, %r24
	.word 0x87802020  ! 4121: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4122: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 4123: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f0, %r22
	mov	0x7f0, %r22
	mov	0x20, %r18
	.word 0xd0856000  ! 4127: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r8
	.word 0xd0d56000  ! 4128: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r8
	mov	0x50, %r16
	.word 0x87802074  ! 4130: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0d5e000  ! 4131: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r8
	.word 0xd0c5a000  ! 4132: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r8
	.word 0xd0ade000  ! 4133: STBA_I	stba	%r8, [%r23 + 0x0000] %asi
	.word 0xdcd609e0  ! 4134: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r14
	wr_tick_cmpr_2_35:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x90, %g2
	or	%g4, 0x92, %g4
	or	%g6, 0x8e, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd6afce60  ! 4136: STBA_R	stba	%r11, [%r31 + %r0] 0x73
	wr_tick_cmpr_2_36:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x91, %g2
	or	%g4, 0xf9, %g4
	or	%g6, 0xea, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd6bf8e60  ! 4138: STDA_R	stda	%r11, [%r30 + %r0] 0x73
	mov	0x3d8, %r21
	.word 0xd0dda000  ! 4140: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r8
	.word 0xd4a649e0  ! 4141: STWA_R	stwa	%r10, [%r25 + %r0] 0x4f
	mov	0x58, %r18
	.word 0xd8b52000  ! 4143: STHA_I	stha	%r12, [%r20 + 0x0000] %asi
	mov	0x20, %r26
	.word 0xd8bd2000  ! 4145: STDA_I	stda	%r12, [%r20 + 0x0000] %asi
	.word 0xd8f5e000  ! 4146: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	.word 0x87802073  ! 4147: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8d4c400  ! 4148: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	wr_tick_cmpr_2_37:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd8, %g2
	or	%g4, 0x94, %g4
	or	%g6, 0x91, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7f0, %r20
	.word 0xda978e40  ! 4151: LDUHA_R	lduha	[%r30, %r0] 0x72, %r13
	mov	0x50, %r27
	mov	0x40, %r19
	.word 0xd28e6000  ! 4154: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r9
	.word 0xd2b70e60  ! 4155: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	.word 0xd4aee000  ! 4156: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	.word 0xd6b44400  ! 4157: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xd2b40400  ! 4158: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0x87802025  ! 4159: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4160: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4161: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0be2000  ! 4162: STDA_I	stda	%r8, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 4163: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f74e60  ! 4164: STXA_R	stxa	%r11, [%r29 + %r0] 0x73
	.word 0x87802020  ! 4165: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda97ce40  ! 4166: LDUHA_R	lduha	[%r31, %r0] 0x72, %r13
	wr_tick_cmpr_2_38:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x9b, %g2
	or	%g4, 0xf5, %g4
	or	%g6, 0xf3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4974e80  ! 4168: LDUHA_R	lduha	[%r29, %r0] 0x74, %r10
	.word 0xd6ad84a0  ! 4169: STBA_R	stba	%r11, [%r22 + %r0] 0x25
	.word 0xd2b72000  ! 4170: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 4171: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bfa000  ! 4172: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 4173: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2c76000  ! 4174: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	mov	0x0, %r26
	.word 0xd2d72000  ! 4176: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xdab48400  ! 4177: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0xd6df8e80  ! 4178: LDXA_R	ldxa	[%r30, %r0] 0x74, %r11
	.word 0xd69f2000  ! 4179: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	mov	0x58, %r27
	.word 0xdcbc0400  ! 4181: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0xd0b72000  ! 4182: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 4183: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c8, %r21
	.word 0xd0b6e000  ! 4185: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	.word 0xd09c8400  ! 4186: LDDA_R	ldda	[%r18, %r0] 0x20, %r8
	.word 0xd0ae09e0  ! 4187: STBA_R	stba	%r8, [%r24 + %r0] 0x4f
	mov	0x7c8, %r21
	mov	0x3f8, %r22
	.word 0xd6a6e000  ! 4190: STWA_I	stwa	%r11, [%r27 + 0x0000] %asi
	.word 0xd0b584a0  ! 4191: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	.word 0x87802073  ! 4192: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd89584a0  ! 4193: LDUHA_R	lduha	[%r22, %r0] 0x25, %r12
	.word 0xd4bfe000  ! 4194: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd48fe000  ! 4195: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xd8f48400  ! 4196: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xdca689e0  ! 4197: STWA_R	stwa	%r14, [%r26 + %r0] 0x4f
	.word 0xdcbf8e60  ! 4198: STDA_R	stda	%r14, [%r30 + %r0] 0x73
	.word 0xdaa7a000  ! 4199: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xdad48400  ! 4200: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0xdaf689e0  ! 4201: STXA_R	stxa	%r13, [%r26 + %r0] 0x4f
	.word 0xdead04a0  ! 4202: STBA_R	stba	%r15, [%r20 + %r0] 0x25
	.word 0xd4d48400  ! 4203: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	.word 0xdc8f4e80  ! 4204: LDUBA_R	lduba	[%r29, %r0] 0x74, %r14
	.word 0x8780204f  ! 4205: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc9689e0  ! 4206: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r14
	mov	0x48, %r24
	.word 0xd8cc8400  ! 4208: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0xdabf4e40  ! 4209: STDA_R	stda	%r13, [%r29 + %r0] 0x72
	.word 0x87802072  ! 4210: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaaec9e0  ! 4211: STBA_R	stba	%r13, [%r27 + %r0] 0x4f
	.word 0xdaace000  ! 4212: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0xdab4e000  ! 4213: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xda8c6000  ! 4214: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r13
	mov	0x8, %r16
	mov	0x48, %r26
	.word 0xdad46000  ! 4217: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	mov	0x3c0, %r23
	.word 0xd4a78e60  ! 4219: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	mov	0x3e8, %r20
	.word 0xd2df4e80  ! 4221: LDXA_R	ldxa	[%r29, %r0] 0x74, %r9
	mov	0x10, %r18
	.word 0xdcbf0e80  ! 4223: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	.word 0xde942000  ! 4224: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	.word 0xde8c2000  ! 4225: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	.word 0xda8d04a0  ! 4226: LDUBA_R	lduba	[%r20, %r0] 0x25, %r13
	.word 0xdca4a000  ! 4227: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0xd2cc8400  ! 4228: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	wr_tick_cmpr_2_39:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xc3, %g2
	or	%g4, 0xdc, %g4
	or	%g6, 0x9a, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8ac0400  ! 4230: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xd2d4a000  ! 4231: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	.word 0x87802020  ! 4232: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r21
	.word 0xdc940400  ! 4234: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0xd6c76000  ! 4235: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd8de49e0  ! 4236: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r12
	mov	0x10, %r19
	mov	0x0, %r19
	.word 0xd29f2000  ! 4239: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd2dfe000  ! 4240: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0xdad7ce40  ! 4241: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r13
	mov	0x18, %r24
	mov	0x50, %r24
	.word 0xdaf4c400  ! 4244: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 4245: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd29544a0  ! 4246: LDUHA_R	lduha	[%r21, %r0] 0x25, %r9
	.word 0x87802074  ! 4247: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2a7e000  ! 4248: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 4249: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd29ec9e0  ! 4250: LDDA_R	ldda	[%r27, %r0] 0x4f, %r9
	.word 0xd6a7a000  ! 4251: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	mov	0x30, %r18
	mov	0x7c0, %r20
	.word 0xd687a000  ! 4254: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0xd68f6000  ! 4255: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	mov	0x3d8, %r20
	.word 0xd88fce40  ! 4257: LDUBA_R	lduba	[%r31, %r0] 0x72, %r12
	.word 0xda874e60  ! 4258: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r13
	.word 0x8780204f  ! 4259: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd68fce40  ! 4260: LDUBA_R	lduba	[%r31, %r0] 0x72, %r11
	mov	0x78, %r27
	.word 0xde872000  ! 4262: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xde87e000  ! 4263: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	mov	0x3d0, %r21
	.word 0xd8bfce40  ! 4265: STDA_R	stda	%r12, [%r31 + %r0] 0x72
	.word 0xdabfa000  ! 4266: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdaf72000  ! 4267: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xda87a000  ! 4268: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0xdec74e80  ! 4269: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r15
	.word 0xd08f2000  ! 4270: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	mov	0x7d0, %r20
	.word 0xd09f0e80  ! 4272: LDDA_R	ldda	[%r28, %r0] 0x74, %r8
	mov	0x3d0, %r21
	.word 0xd6cf2000  ! 4274: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0xd6f76000  ! 4275: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd0aec9e0  ! 4276: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	.word 0xde9f8e60  ! 4277: LDDA_R	ldda	[%r30, %r0] 0x73, %r15
	mov	0x30, %r26
	mov	0x0, %r19
	.word 0xd2bf6000  ! 4280: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd2bcc400  ! 4281: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xd2a48400  ! 4282: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0xd89f6000  ! 4283: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	mov	0x8, %r26
	.word 0xd8af6000  ! 4285: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd8af6000  ! 4286: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd8bfe000  ! 4287: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	mov	0x68, %r24
	.word 0xd8c76000  ! 4289: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	mov	0x3c8, %r20
	.word 0xd8b72000  ! 4291: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd2c6c9e0  ! 4292: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r9
	.word 0xdcd7a000  ! 4293: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0xdcb72000  ! 4294: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 4295: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r25
	.word 0xdcb4a000  ! 4297: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xdcc46000  ! 4298: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r14
	.word 0xd09e89e0  ! 4299: LDDA_R	ldda	[%r26, %r0] 0x4f, %r8
	.word 0xd6ac8400  ! 4300: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	mov	0x48, %r17
	.word 0xd89649e0  ! 4302: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r12
	.word 0xdebe09e0  ! 4303: STDA_R	stda	%r15, [%r24 + %r0] 0x4f
	.word 0x87802074  ! 4304: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r16
	mov	0x18, %r27
	.word 0xda846000  ! 4307: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r13
	.word 0xd0870e40  ! 4308: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r8
	mov	0x8, %r18
	.word 0xdaac4400  ! 4310: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	.word 0xd8a42000  ! 4311: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xdadc4400  ! 4312: LDXA_R	ldxa	[%r17, %r0] 0x20, %r13
	.word 0xd48ce000  ! 4313: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r10
	.word 0x87802073  ! 4314: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4dfa000  ! 4315: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	mov	0x70, %r26
	.word 0xd4a76000  ! 4317: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4bfe000  ! 4318: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 4319: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r24
	.word 0xd4b6c9e0  ! 4321: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 4322: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc8fe000  ! 4323: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xdcaf6000  ! 4324: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdcdf2000  ! 4325: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	mov	0x68, %r16
	.word 0xd2b40400  ! 4327: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0xd89f0e60  ! 4328: LDDA_R	ldda	[%r28, %r0] 0x73, %r12
	.word 0xdcafa000  ! 4329: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	mov	0x7c0, %r20
	.word 0xd4ac4400  ! 4331: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0x87802020  ! 4332: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8c8400  ! 4333: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	.word 0xd4c7ce60  ! 4334: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r10
	.word 0x87802072  ! 4335: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c0, %r22
	.word 0xdc8ce000  ! 4337: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	.word 0xdcf4a000  ! 4338: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcbc6000  ! 4339: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	mov	0x7f0, %r21
	.word 0xdc846000  ! 4341: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	.word 0xde8fce60  ! 4342: LDUBA_R	lduba	[%r31, %r0] 0x73, %r15
	.word 0x87802072  ! 4343: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2bfa000  ! 4344: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd6b44400  ! 4345: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	mov	0x7e0, %r22
	mov	0x0, %r24
	.word 0xdecf8e80  ! 4348: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r15
	.word 0xd0a7e000  ! 4349: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0dfe000  ! 4350: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0bc0400  ! 4351: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	mov	0x38, %r24
	mov	0x7c8, %r21
	.word 0xdef7ce60  ! 4354: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0xda8c4400  ! 4355: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0xd48689e0  ! 4356: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r10
	mov	0x7e0, %r22
	.word 0xd6f74e40  ! 4358: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	.word 0xdeafa000  ! 4359: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xd2b78e40  ! 4360: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	mov	0x3d8, %r23
	.word 0xd2bfa000  ! 4362: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd2cf6000  ! 4363: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	.word 0xd8b7ce80  ! 4364: STHA_R	stha	%r12, [%r31 + %r0] 0x74
	mov	0x3e0, %r22
	.word 0xd6874e60  ! 4366: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r11
	mov	0x78, %r25
	.word 0xd2a70e60  ! 4368: STWA_R	stwa	%r9, [%r28 + %r0] 0x73
	.word 0xdcf76000  ! 4369: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x10, %r19
	mov	0x3c0, %r21
	.word 0xdcd7a000  ! 4372: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0xdcf7e000  ! 4373: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcb72000  ! 4374: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	mov	0x7c8, %r21
	mov	0x18, %r27
	.word 0x87802020  ! 4377: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf5e000  ! 4378: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0xd0a5c4a0  ! 4379: STWA_R	stwa	%r8, [%r23 + %r0] 0x25
	.word 0xd6cd84a0  ! 4380: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r11
	.word 0xdeada000  ! 4381: STBA_I	stba	%r15, [%r22 + 0x0000] %asi
	.word 0xde8de000  ! 4382: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r15
	.word 0xd2acc400  ! 4383: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	mov	0x28, %r24
	.word 0xd084c400  ! 4385: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r8
	.word 0xdeada000  ! 4386: STBA_I	stba	%r15, [%r22 + 0x0000] %asi
	.word 0xdec40400  ! 4387: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xd2bcc400  ! 4388: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xdccd2000  ! 4389: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r14
	mov	0x50, %r16
	.word 0xdccd2000  ! 4391: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 4392: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdccfa000  ! 4393: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xd0cf8e60  ! 4394: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r8
	.word 0xdef504a0  ! 4395: STXA_R	stxa	%r15, [%r20 + %r0] 0x25
	.word 0xd4d7a000  ! 4396: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 4397: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4dca000  ! 4398: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	mov	0x3e8, %r23
	.word 0xd4c42000  ! 4400: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r10
	.word 0xd484a000  ! 4401: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r10
	.word 0xd0bfce80  ! 4402: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	mov	0x70, %r27
	mov	0x28, %r24
	mov	0x0, %r17
	.word 0x87802072  ! 4406: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4ac4400  ! 4407: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xda87e000  ! 4408: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4409: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r23
	mov	0x60, %r25
	.word 0xdaafe000  ! 4412: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xd6af0e80  ! 4413: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	.word 0x87802074  ! 4414: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r24
	.word 0xda940400  ! 4416: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	.word 0xdca46000  ! 4417: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xd4a7ce40  ! 4418: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	.word 0xd6b46000  ! 4419: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd0870e40  ! 4420: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r8
	.word 0xdedc6000  ! 4421: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r15
	.word 0xdef42000  ! 4422: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xdec42000  ! 4423: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	mov	0x7d8, %r21
	.word 0x87802074  ! 4425: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xded4e000  ! 4426: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	.word 0x87802025  ! 4427: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebd6000  ! 4428: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	.word 0xd8dec9e0  ! 4429: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r12
	.word 0xd0d52000  ! 4430: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r8
	.word 0xd0ade000  ! 4431: STBA_I	stba	%r8, [%r23 + 0x0000] %asi
	wr_tick_cmpr_2_40:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xdd, %g2
	or	%g4, 0xc0, %g4
	or	%g6, 0xd8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x10, %r18
	mov	0x18, %r25
	mov	0x10, %r25
	.word 0x87802072  ! 4436: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r17
	.word 0x87802025  ! 4438: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f5e000  ! 4439: STXA_I	stxa	%r8, [%r23 + 0x0000] %asi
	mov	0x58, %r19
	.word 0xd88c8400  ! 4441: LDUBA_R	lduba	[%r18, %r0] 0x20, %r12
	mov	0x7f8, %r23
	mov	0x70, %r19
	.word 0xd8dc4400  ! 4444: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0xd6ad2000  ! 4445: STBA_I	stba	%r11, [%r20 + 0x0000] %asi
	mov	0x48, %r19
	.word 0xd8dc0400  ! 4447: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	mov	0x50, %r18
	.word 0x87802073  ! 4449: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8a70e80  ! 4450: STWA_R	stwa	%r12, [%r28 + %r0] 0x74
	.word 0xd8c7e000  ! 4451: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	mov	0x50, %r27
	.word 0xd8876000  ! 4453: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8976000  ! 4454: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0xd4c7ce80  ! 4455: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r10
	.word 0xd4d74e80  ! 4456: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r10
	mov	0x0, %r18
	.word 0xd4c40400  ! 4458: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	mov	0x50, %r26
	.word 0x87802073  ! 4460: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 4461: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdec76000  ! 4462: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xd2c4c400  ! 4463: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0x8780204f  ! 4464: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a66000  ! 4465: STWA_I	stwa	%r8, [%r25 + 0x0000] %asi
	.word 0x87802073  ! 4466: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6d689e0  ! 4467: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r11
	.word 0xdec609e0  ! 4468: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r15
	.word 0xd8dda000  ! 4469: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r12
	.word 0xdab5c4a0  ! 4470: STHA_R	stha	%r13, [%r23 + %r0] 0x25
	mov	0x28, %r26
	.word 0xd2dd2000  ! 4472: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r9
	.word 0xd295a000  ! 4473: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r9
	.word 0xd2ada000  ! 4474: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 4475: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4476: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f52000  ! 4477: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0xd29d6000  ! 4479: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r9
	.word 0xd2ada000  ! 4480: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xd2b56000  ! 4481: STHA_I	stha	%r9, [%r21 + 0x0000] %asi
	.word 0xd2952000  ! 4482: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r9
	.word 0xdc8ec9e0  ! 4483: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r14
	.word 0x87802020  ! 4484: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4485: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b40400  ! 4486: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0xde8ce000  ! 4487: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	mov	0x7c8, %r21
	mov	0x68, %r19
	mov	0x18, %r18
	.word 0xdef42000  ! 4491: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xd4bfce40  ! 4492: STDA_R	stda	%r10, [%r31 + %r0] 0x72
	.word 0xd6c4e000  ! 4493: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r11
	.word 0xd6dc6000  ! 4494: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r11
	.word 0xd6942000  ! 4495: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r11
	.word 0xd6d4a000  ! 4496: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r11
	.word 0x87802025  ! 4497: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6ce6000  ! 4498: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r11
	mov	0x3d0, %r20
	.word 0xd6a66000  ! 4500: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	.word 0xd6840400  ! 4501: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0xd2b48400  ! 4502: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	mov	0x3e0, %r23
	.word 0xd2d62000  ! 4504: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r9
	.word 0xd2f62000  ! 4505: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	mov	0x60, %r27
	.word 0x87802020  ! 4507: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea44400  ! 4508: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xd4bf0e60  ! 4509: STDA_R	stda	%r10, [%r28 + %r0] 0x73
	.word 0x87802020  ! 4510: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda86e000  ! 4511: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r13
	.word 0xda86a000  ! 4512: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r13
	mov	0x7d8, %r23
	mov	0x7e8, %r22
	.word 0xd0f5c4a0  ! 4515: STXA_R	stxa	%r8, [%r23 + %r0] 0x25
	.word 0xd6be09e0  ! 4516: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	.word 0xd0c62000  ! 4517: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r8
	mov	0x7e8, %r22
	wr_tick_cmpr_2_41:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf6, %g2
	or	%g4, 0xeb, %g4
	or	%g6, 0xb0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802025  ! 4520: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2874e80  ! 4521: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r9
	.word 0xde9f6000  ! 4522: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdea7e000  ! 4524: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xdc874e80  ! 4525: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r14
	.word 0xdabf2000  ! 4526: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xdabfe000  ! 4527: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xdef584a0  ! 4528: STXA_R	stxa	%r15, [%r22 + %r0] 0x25
	mov	0x0, %r19
	.word 0x87802020  ! 4530: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 4531: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf76000  ! 4532: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xd6f7ce60  ! 4533: STXA_R	stxa	%r11, [%r31 + %r0] 0x73
	.word 0xd8b7ce60  ! 4534: STHA_R	stha	%r12, [%r31 + %r0] 0x73
	.word 0x87802073  ! 4535: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r19
	.word 0xdacf4e40  ! 4537: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r13
	.word 0xd0bcc400  ! 4538: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	mov	0x8, %r26
	.word 0xd2ad2000  ! 4540: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xd2bd2000  ! 4541: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 4542: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48c4400  ! 4543: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0xd08cc400  ! 4544: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	.word 0xd6940400  ! 4545: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	.word 0xd2dc2000  ! 4546: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r9
	.word 0xd2c4e000  ! 4547: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xd29c2000  ! 4548: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 4549: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf78e60  ! 4550: STXA_R	stxa	%r14, [%r30 + %r0] 0x73
	.word 0x8780204f  ! 4551: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 4552: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r25
	.word 0xdedfa000  ! 4554: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0x87802074  ! 4555: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeafe000  ! 4556: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xdedfa000  ! 4557: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd89fce60  ! 4559: LDDA_R	ldda	[%r31, %r0] 0x73, %r12
	.word 0xde8d44a0  ! 4560: LDUBA_R	lduba	[%r21, %r0] 0x25, %r15
	.word 0xdaaf6000  ! 4561: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdadf6000  ! 4563: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xdad72000  ! 4564: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0xd6f78e80  ! 4565: STXA_R	stxa	%r11, [%r30 + %r0] 0x74
	.word 0x87802072  ! 4566: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabfa000  ! 4567: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdccc8400  ! 4568: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	.word 0xd8f504a0  ! 4569: STXA_R	stxa	%r12, [%r20 + %r0] 0x25
	.word 0xd0d76000  ! 4570: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0c7e000  ! 4571: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0f7e000  ! 4572: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	mov	0x70, %r24
	.word 0xd0df2000  ! 4574: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0c72000  ! 4575: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xd6bc4400  ! 4576: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	mov	0x38, %r19
	mov	0x40, %r26
	.word 0xdad7e000  ! 4579: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	mov	0x7f8, %r23
	.word 0xd2cc0400  ! 4581: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r9
	.word 0xd2f72000  ! 4582: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd0c78e60  ! 4583: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r8
	.word 0x87802073  ! 4584: WRASI_I	wr	%r0, 0x0073, %asi
	wr_tick_cmpr_2_42:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb0, %g2
	or	%g4, 0xf5, %g4
	or	%g6, 0xdc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd487e000  ! 4586: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802072  ! 4587: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd68f8e60  ! 4588: LDUBA_R	lduba	[%r30, %r0] 0x73, %r11
	.word 0xded4c400  ! 4589: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r15
	mov	0x7f8, %r20
	mov	0x38, %r18
	.word 0xd0b7a000  ! 4592: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd0cfe000  ! 4593: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xd6978e60  ! 4594: LDUHA_R	lduha	[%r30, %r0] 0x73, %r11
	.word 0xd2d504a0  ! 4595: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r9
	.word 0xd6bc4400  ! 4596: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	.word 0x87802025  ! 4597: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b42000  ! 4598: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4599: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r27
	mov	0x78, %r26
	.word 0xd69fe000  ! 4602: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	.word 0xd6cfe000  ! 4603: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0xd2f504a0  ! 4604: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	.word 0xdeb689e0  ! 4605: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 4606: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8a6a000  ! 4607: STWA_I	stwa	%r12, [%r26 + 0x0000] %asi
	mov	0x20, %r19
	.word 0x8780204f  ! 4609: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f609e0  ! 4610: STXA_R	stxa	%r9, [%r24 + %r0] 0x4f
	.word 0xd0c40400  ! 4611: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	.word 0xd8a74e60  ! 4612: STWA_R	stwa	%r12, [%r29 + %r0] 0x73
	.word 0xd0bd44a0  ! 4613: STDA_R	stda	%r8, [%r21 + %r0] 0x25
	.word 0xd6a46000  ! 4614: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0xd6a42000  ! 4615: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xd6ac2000  ! 4616: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	.word 0xd8cc8400  ! 4617: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0xd8af0e80  ! 4618: STBA_R	stba	%r12, [%r28 + %r0] 0x74
	.word 0xdaf4a000  ! 4619: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 4620: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4621: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r22
	.word 0xd8944400  ! 4623: LDUHA_R	lduha	[%r17, %r0] 0x20, %r12
	.word 0xdef72000  ! 4624: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 4625: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdecf8e80  ! 4626: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r15
	mov	0x3d0, %r21
	.word 0x87802074  ! 4628: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda9ce000  ! 4629: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r13
	.word 0xd0974e80  ! 4630: LDUHA_R	lduha	[%r29, %r0] 0x74, %r8
	.word 0xd2840400  ! 4631: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r9
	mov	0x38, %r19
	.word 0x87802074  ! 4633: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 4634: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r26
	.word 0xdaa649e0  ! 4636: STWA_R	stwa	%r13, [%r25 + %r0] 0x4f
	.word 0xd0a689e0  ! 4637: STWA_R	stwa	%r8, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 4638: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 4639: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f0, %r21
	.word 0xded4e000  ! 4641: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	mov	0x30, %r17
	.word 0xdea42000  ! 4643: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xd6a44400  ! 4644: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0xd6c46000  ! 4645: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r11
	.word 0xd6b5c4a0  ! 4646: STHA_R	stha	%r11, [%r23 + %r0] 0x25
	mov	0x50, %r18
	.word 0xd8a4a000  ! 4648: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd2cf0e80  ! 4649: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r9
	.word 0xdcc609e0  ! 4650: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r14
	.word 0xd8c4e000  ! 4651: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	mov	0x7e8, %r21
	.word 0xd8cc6000  ! 4653: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r12
	mov	0x3e8, %r21
	.word 0x87802072  ! 4655: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4afce40  ! 4656: STBA_R	stba	%r10, [%r31 + %r0] 0x72
	.word 0xd29ee000  ! 4657: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r9
	mov	0x7e8, %r21
	.word 0xd2d6a000  ! 4659: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r9
	.word 0xd2ce2000  ! 4660: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r9
	.word 0xd6c649e0  ! 4661: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r11
	.word 0xd4cee000  ! 4662: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r10
	.word 0xd0c78e60  ! 4663: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r8
	.word 0xd6dea000  ! 4664: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r11
	mov	0x8, %r25
	.word 0x87802072  ! 4666: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b5a000  ! 4667: STHA_I	stha	%r11, [%r22 + 0x0000] %asi
	.word 0xdc9fce80  ! 4668: LDDA_R	ldda	[%r31, %r0] 0x74, %r14
	.word 0xd0f44400  ! 4669: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	mov	0x78, %r17
	.word 0xd49d6000  ! 4671: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 4672: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabd84a0  ! 4673: STDA_R	stda	%r13, [%r22 + %r0] 0x25
	.word 0xd8978e40  ! 4674: LDUHA_R	lduha	[%r30, %r0] 0x72, %r12
	.word 0xd8a689e0  ! 4675: STWA_R	stwa	%r12, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 4676: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b62000  ! 4677: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	.word 0xdef4c400  ! 4678: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	mov	0x50, %r17
	.word 0xd48e89e0  ! 4680: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r10
	.word 0x8780204f  ! 4681: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdacc2000  ! 4682: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4683: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r25
	.word 0xd2a70e40  ! 4685: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2a66000  ! 4687: STWA_I	stwa	%r9, [%r25 + 0x0000] %asi
	.word 0xd2a62000  ! 4688: STWA_I	stwa	%r9, [%r24 + 0x0000] %asi
	mov	0x50, %r18
	.word 0x87802025  ! 4690: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4bc0400  ! 4691: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0x87802020  ! 4692: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09f6000  ! 4693: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	.word 0xd0bfe000  ! 4694: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd0f76000  ! 4695: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	mov	0x50, %r16
	.word 0xd0cfe000  ! 4697: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	mov	0x68, %r25
	.word 0xdadd84a0  ! 4699: LDXA_R	ldxa	[%r22, %r0] 0x25, %r13
	.word 0xd6a7a000  ! 4700: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd4acc400  ! 4701: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0x87802025  ! 4702: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 4703: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r24
	.word 0x87802073  ! 4705: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8d44400  ! 4706: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	.word 0xdaade000  ! 4707: STBA_I	stba	%r13, [%r23 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0xdacda000  ! 4709: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r13
	.word 0xda952000  ! 4710: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r13
	.word 0x87802072  ! 4711: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f8, %r21
	.word 0xda9f2000  ! 4713: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xdabd44a0  ! 4714: STDA_R	stda	%r13, [%r21 + %r0] 0x25
	.word 0xd4a4c400  ! 4715: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	mov	0x20, %r16
	.word 0xdcb4c400  ! 4717: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	mov	0x7f8, %r23
	.word 0xde9f2000  ! 4719: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xdef78e80  ! 4720: STXA_R	stxa	%r15, [%r30 + %r0] 0x74
	.word 0xd4b7ce60  ! 4721: STHA_R	stha	%r10, [%r31 + %r0] 0x73
	.word 0xd8d7e000  ! 4722: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0xd8a7a000  ! 4723: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	mov	0x58, %r19
	mov	0x30, %r25
	mov	0x50, %r25
	.word 0xd8a7a000  ! 4727: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8f72000  ! 4728: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8a72000  ! 4729: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8876000  ! 4730: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0xdacd44a0  ! 4731: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r13
	.word 0x87802020  ! 4732: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88c4400  ! 4733: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	mov	0x10, %r18
	mov	0x50, %r27
	.word 0x87802025  ! 4736: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 4737: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f0, %r20
	mov	0x78, %r17
	.word 0xd6ac8400  ! 4740: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xda87ce60  ! 4741: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r13
	mov	0x48, %r18
	mov	0x10, %r24
	.word 0xdaa76000  ! 4744: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 4745: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68f0e80  ! 4746: LDUBA_R	lduba	[%r28, %r0] 0x74, %r11
	.word 0x87802020  ! 4747: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4748: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4749: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d66000  ! 4750: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r12
	.word 0x87802025  ! 4751: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d0, %r21
	.word 0xd69e89e0  ! 4753: LDDA_R	ldda	[%r26, %r0] 0x4f, %r11
	mov	0x48, %r27
	.word 0xd6bc4400  ! 4755: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	mov	0x68, %r19
	mov	0x3e8, %r21
	.word 0xd2af2000  ! 4758: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd2f72000  ! 4759: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	mov	0x38, %r16
	.word 0x87802074  ! 4761: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f0, %r22
	.word 0xd88cc400  ! 4763: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	.word 0x87802020  ! 4764: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b504a0  ! 4765: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	.word 0x87802020  ! 4766: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r26
	mov	0x0, %r19
	.word 0x87802072  ! 4769: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde9f2000  ! 4770: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	mov	0x3e8, %r21
	.word 0xd2b584a0  ! 4772: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0x87802074  ! 4773: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r17
	.word 0xd8a5a000  ! 4775: STWA_I	stwa	%r12, [%r22 + 0x0000] %asi
	.word 0x87802074  ! 4776: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r18
	mov	0x48, %r24
	.word 0xd8c62000  ! 4779: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r12
	mov	0x3f8, %r20
	mov	0x7d8, %r21
	.word 0xd8866000  ! 4782: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r12
	.word 0x87802072  ! 4783: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 4784: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r26
	.word 0xd8afe000  ! 4786: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0xd8f7e000  ! 4788: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xdaf7ce80  ! 4789: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	mov	0x70, %r18
	.word 0x87802072  ! 4791: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb76000  ! 4792: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	mov	0x38, %r18
	mov	0x3e0, %r20
	.word 0xdedf6000  ! 4795: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	wr_tick_cmpr_2_43:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x86, %g2
	or	%g4, 0xac, %g4
	or	%g6, 0xb4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdebc0400  ! 4797: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0xd4978e60  ! 4798: LDUHA_R	lduha	[%r30, %r0] 0x73, %r10
	.word 0xd297a000  ! 4799: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	mov	0x7c0, %r22
	mov	0x30, %r24
	.word 0xdcc584a0  ! 4802: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r14
	.word 0xd6bf8e60  ! 4803: STDA_R	stda	%r11, [%r30 + %r0] 0x73
	.word 0xde944400  ! 4804: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	mov	0x18, %r18
	.word 0xd2cf6000  ! 4806: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	.word 0xd8f4c400  ! 4807: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xd8af4e40  ! 4808: STBA_R	stba	%r12, [%r29 + %r0] 0x72
	mov	0x20, %r25
	.word 0xd0c544a0  ! 4810: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r8
	.word 0xdcf609e0  ! 4811: STXA_R	stxa	%r14, [%r24 + %r0] 0x4f
	.word 0xdcd72000  ! 4812: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	mov	0x3d8, %r20
	.word 0xd2844400  ! 4814: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	.word 0xd6cfce40  ! 4815: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r11
	.word 0xd2a76000  ! 4816: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd0a44400  ! 4817: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0x87802020  ! 4818: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cfa000  ! 4819: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0xded7ce60  ! 4820: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r15
	.word 0xd6cc0400  ! 4821: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r11
	.word 0xd0f72000  ! 4822: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	mov	0x8, %r17
	.word 0xd0a7e000  ! 4824: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0f7e000  ! 4825: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0xd8cf4e40  ! 4827: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r12
	.word 0x87802074  ! 4828: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd29c2000  ! 4829: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	.word 0xd2c4e000  ! 4830: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x7c8, %r21
	.word 0xdeaf8e40  ! 4833: STBA_R	stba	%r15, [%r30 + %r0] 0x72
	.word 0xdaf4c400  ! 4834: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xdeac6000  ! 4835: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xd8ad04a0  ! 4836: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	mov	0x50, %r24
	.word 0xd6ac6000  ! 4838: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	mov	0x28, %r16
	.word 0xd6a46000  ! 4840: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	mov	0x60, %r19
	mov	0x50, %r16
	.word 0xd6b4e000  ! 4843: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 4844: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc86c9e0  ! 4845: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r14
	.word 0xd6cf6000  ! 4846: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd2c4c400  ! 4847: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0xd0bf8e60  ! 4848: STDA_R	stda	%r8, [%r30 + %r0] 0x73
	mov	0x10, %r24
	mov	0x30, %r24
	mov	0x68, %r25
	mov	0x8, %r26
	mov	0x78, %r16
	mov	0x58, %r26
	.word 0xdadfa000  ! 4855: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xdadfe000  ! 4856: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0xd4ac4400  ! 4857: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xd8dc0400  ! 4858: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0xd285c4a0  ! 4859: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r9
	.word 0xdaf76000  ! 4860: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 4861: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ac8400  ! 4862: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 4863: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c0, %r22
	.word 0xd8d62000  ! 4865: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r12
	.word 0xd896e000  ! 4866: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r12
	.word 0xd88ee000  ! 4867: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 4868: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda8c0400  ! 4869: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	mov	0x58, %r18
	mov	0x38, %r19
	.word 0xd2a46000  ! 4872: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	mov	0x18, %r17
	mov	0x18, %r26
	.word 0xd2f42000  ! 4875: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0xd2846000  ! 4876: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r9
	.word 0xd2dca000  ! 4877: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r9
	.word 0xd2dca000  ! 4878: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r9
	.word 0xd284a000  ! 4879: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	.word 0xd2c42000  ! 4880: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	.word 0xd0dcc400  ! 4881: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0xdcbce000  ! 4882: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xdcb46000  ! 4883: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xd6b7ce60  ! 4884: STHA_R	stha	%r11, [%r31 + %r0] 0x73
	.word 0xdabdc4a0  ! 4885: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	mov	0x0, %r24
	.word 0xd4f4e000  ! 4887: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0xd4cf4e60  ! 4889: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r10
	mov	0x8, %r24
	.word 0xd6dd44a0  ! 4891: LDXA_R	ldxa	[%r21, %r0] 0x25, %r11
	.word 0xd6a46000  ! 4892: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0xd2a70e40  ! 4893: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	.word 0xdebfce40  ! 4894: STDA_R	stda	%r15, [%r31 + %r0] 0x72
	.word 0xda8c0400  ! 4895: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	.word 0xd0ae09e0  ! 4896: STBA_R	stba	%r8, [%r24 + %r0] 0x4f
	.word 0xd2dc2000  ! 4897: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r9
	mov	0x3e8, %r23
	.word 0x8780204f  ! 4899: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4900: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 4901: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r26
	.word 0xd2876000  ! 4903: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xd29f2000  ! 4904: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd6c70e40  ! 4905: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r11
	.word 0xd2b72000  ! 4906: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0xdabf8e80  ! 4908: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	.word 0xdec7a000  ! 4909: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xdeaf6000  ! 4910: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xdeb7e000  ! 4911: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xdea7e000  ! 4912: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xd89d44a0  ! 4913: LDDA_R	ldda	[%r21, %r0] 0x25, %r12
	.word 0xdcac8400  ! 4914: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	mov	0x60, %r27
	mov	0x3d0, %r22
	.word 0xd2878e60  ! 4917: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r9
	.word 0xd6f70e40  ! 4918: STXA_R	stxa	%r11, [%r28 + %r0] 0x72
	.word 0x87802073  ! 4919: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0de49e0  ! 4920: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r8
	.word 0xd0c74e60  ! 4921: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r8
	.word 0x87802072  ! 4922: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cee000  ! 4923: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r10
	.word 0xd4f66000  ! 4924: STXA_I	stxa	%r10, [%r25 + 0x0000] %asi
	.word 0xd6df4e40  ! 4925: LDXA_R	ldxa	[%r29, %r0] 0x72, %r11
	.word 0xd8f62000  ! 4926: STXA_I	stxa	%r12, [%r24 + 0x0000] %asi
	.word 0xdecfce80  ! 4927: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r15
	.word 0xd2c48400  ! 4928: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0xd6978e80  ! 4929: LDUHA_R	lduha	[%r30, %r0] 0x74, %r11
	mov	0x78, %r25
	.word 0xd0ce6000  ! 4931: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r8
	mov	0x3f8, %r22
	.word 0xd0aee000  ! 4933: STBA_I	stba	%r8, [%r27 + 0x0000] %asi
	mov	0x48, %r18
	.word 0xd0bf0e40  ! 4935: STDA_R	stda	%r8, [%r28 + %r0] 0x72
	mov	0x68, %r16
	.word 0xd2862000  ! 4937: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r9
	.word 0xd6dfce80  ! 4938: LDXA_R	ldxa	[%r31, %r0] 0x74, %r11
	mov	0x3c0, %r21
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8d78e80  ! 4941: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r12
	.word 0xdadfce60  ! 4942: LDXA_R	ldxa	[%r31, %r0] 0x73, %r13
	.word 0x87802073  ! 4943: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r18
	.word 0xd8f44400  ! 4945: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xd6b4e000  ! 4946: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xdca7ce60  ! 4947: STWA_R	stwa	%r14, [%r31 + %r0] 0x73
	mov	0x8, %r24
	mov	0x8, %r19
	.word 0xd88ca000  ! 4950: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	mov	0x60, %r24
	mov	0x68, %r26
	.word 0xdeb74e40  ! 4953: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2bfce80  ! 4955: STDA_R	stda	%r9, [%r31 + %r0] 0x74
	.word 0xde942000  ! 4956: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	.word 0xdedc6000  ! 4957: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r15
	.word 0xdaf78e80  ! 4958: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	.word 0xdac48400  ! 4959: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	.word 0xd4b42000  ! 4960: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	.word 0xd4aca000  ! 4961: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	mov	0x0, %r24
	wr_tick_cmpr_2_44:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb6, %g2
	or	%g4, 0x97, %g4
	or	%g6, 0x9f, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4cc6000  ! 4964: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	.word 0xd4d46000  ! 4965: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r10
	.word 0x87802072  ! 4966: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebc4400  ! 4967: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0xdaf7ce60  ! 4968: STXA_R	stxa	%r13, [%r31 + %r0] 0x73
	.word 0xdacf0e60  ! 4969: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r13
	.word 0xd0956000  ! 4970: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r8
	.word 0xdcafce60  ! 4971: STBA_R	stba	%r14, [%r31 + %r0] 0x73
	.word 0xd2ad2000  ! 4972: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xd2f48400  ! 4973: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0xd4f78e80  ! 4974: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	.word 0xd2c56000  ! 4975: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r9
	.word 0xd2ada000  ! 4976: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xd2dd2000  ! 4977: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 4978: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2862000  ! 4979: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r9
	.word 0xd2878e60  ! 4980: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r9
	mov	0x60, %r24
	wr_tick_cmpr_2_45:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xaf, %g2
	or	%g4, 0xb5, %g4
	or	%g6, 0xda, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3c8, %r22
	.word 0xd4bf8e60  ! 4984: STDA_R	stda	%r10, [%r30 + %r0] 0x73
	.word 0xd0af0e80  ! 4985: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	.word 0xd6d649e0  ! 4986: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r11
	.word 0xd4862000  ! 4987: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r10
	.word 0x87802074  ! 4988: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4c7e000  ! 4989: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	.word 0xd49fa000  ! 4990: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0xd4c7a000  ! 4991: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	mov	0x20, %r18
	.word 0xd0c74e40  ! 4993: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r8
	.word 0xdc9f6000  ! 4994: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xdc976000  ! 4995: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	.word 0xdcf72000  ! 4996: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcf76000  ! 4997: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x40, %r26
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_1:
	mov	0x30, %r27
	mov	0x7f8, %r22
	mov	0x38, %r17
	.word 0x87802072  ! 4: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7e0, %r23
	.word 0xdcd5e000  ! 6: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r14
	.word 0xdc9d6000  ! 7: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r14
	mov	0x68, %r18
	.word 0x87802073  ! 9: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e0, %r23
	.word 0xdcbf6000  ! 11: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 12: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 13: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r25
	mov	0x50, %r27
	.word 0xdcaf6000  ! 16: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xde9fce80  ! 17: LDDA_R	ldda	[%r31, %r0] 0x74, %r15
	mov	0x18, %r27
	.word 0xd6afe000  ! 19: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x30, %r25
	.word 0xd6d76000  ! 21: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	mov	0x70, %r26
	.word 0xd2b48400  ! 23: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	mov	0x7f0, %r23
	.word 0x87802072  ! 25: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd496e000  ! 26: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r10
	.word 0xd4ae2000  ! 27: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	mov	0x8, %r25
	.word 0xd4bea000  ! 29: STDA_I	stda	%r10, [%r26 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xd4bea000  ! 31: STDA_I	stda	%r10, [%r26 + 0x0000] %asi
	mov	0x28, %r19
	mov	0x8, %r18
	.word 0x87802025  ! 34: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r26
	.word 0x87802073  ! 36: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 37: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29f8e80  ! 38: LDDA_R	ldda	[%r30, %r0] 0x74, %r9
	.word 0xdea40400  ! 39: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	mov	0x3f0, %r22
	.word 0xd0bca000  ! 41: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0xd08ce000  ! 42: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0c4e000  ! 43: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	mov	0x0, %r17
	mov	0x30, %r17
	.word 0xd094e000  ! 46: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0xd084a000  ! 47: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	.word 0x87802025  ! 48: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r27
	.word 0xd0b5a000  ! 50: STHA_I	stha	%r8, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 51: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r27
	.word 0x87802020  ! 53: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd094a000  ! 54: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	.word 0xd0f4a000  ! 55: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 56: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6cc0400  ! 57: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r11
	mov	0x10, %r26
	.word 0xdcd6a000  ! 59: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r14
	mov	0x78, %r18
	mov	0x7c8, %r22
	.word 0xd8ac4400  ! 62: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xd0be2000  ! 63: STDA_I	stda	%r8, [%r24 + 0x0000] %asi
	.word 0xdcaf0e80  ! 64: STBA_R	stba	%r14, [%r28 + %r0] 0x74
	.word 0xd6f6e000  ! 65: STXA_I	stxa	%r11, [%r27 + 0x0000] %asi
	mov	0x40, %r18
	.word 0xd6c48400  ! 67: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	.word 0xd6cec9e0  ! 68: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r11
	mov	0x7d0, %r22
	.word 0xdcb48400  ! 70: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xdcae6000  ! 71: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	.word 0xdcbfce40  ! 72: STDA_R	stda	%r14, [%r31 + %r0] 0x72
	.word 0xdcae6000  ! 73: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	.word 0xdcb6a000  ! 74: STHA_I	stha	%r14, [%r26 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0xdcde6000  ! 76: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r14
	mov	0x30, %r19
	.word 0xdab78e40  ! 78: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	.word 0xd6cf0e80  ! 79: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r11
	.word 0x8780204f  ! 80: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 81: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda9dc4a0  ! 82: LDDA_R	ldda	[%r23, %r0] 0x25, %r13
	.word 0xdeb72000  ! 83: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xd6df0e40  ! 84: LDXA_R	ldxa	[%r28, %r0] 0x72, %r11
	.word 0xd6a76000  ! 85: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6972000  ! 86: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	mov	0x3c0, %r23
	.word 0xd6cf4e40  ! 88: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r11
	.word 0x87802020  ! 89: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa544a0  ! 90: STWA_R	stwa	%r13, [%r21 + %r0] 0x25
	.word 0xd6ad6000  ! 91: STBA_I	stba	%r11, [%r21 + 0x0000] %asi
	.word 0xd8d4c400  ! 92: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	mov	0x38, %r26
	.word 0x87802074  ! 94: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d0, %r23
	.word 0xd88cc400  ! 96: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	.word 0xd0a46000  ! 97: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0xd09ca000  ! 99: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	mov	0x78, %r16
	mov	0x18, %r19
	mov	0x40, %r17
	mov	0x30, %r16
	.word 0xd0dc6000  ! 104: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 105: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea649e0  ! 106: STWA_R	stwa	%r15, [%r25 + %r0] 0x4f
	mov	0x40, %r24
	mov	0x3e0, %r20
	.word 0xd2a74e60  ! 109: STWA_R	stwa	%r9, [%r29 + %r0] 0x73
	mov	0x48, %r27
	mov	0x18, %r24
	.word 0xd4afa000  ! 112: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xdea74e80  ! 113: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	mov	0x3f8, %r23
	.word 0xd8dc4400  ! 115: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0xd2872000  ! 116: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	.word 0x87802020  ! 117: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bcc400  ! 118: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0xd487e000  ! 119: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd89ec9e0  ! 120: LDDA_R	ldda	[%r27, %r0] 0x4f, %r12
	.word 0xda872000  ! 121: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0xda872000  ! 122: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	mov	0x28, %r26
	mov	0x7e8, %r21
	.word 0xd0af0e40  ! 125: STBA_R	stba	%r8, [%r28 + %r0] 0x72
	.word 0xdabc4400  ! 126: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xd09f6000  ! 127: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	.word 0xd0afe000  ! 128: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0a7a000  ! 129: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0a72000  ! 130: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 131: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4d70e40  ! 132: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r10
	.word 0xde9f2000  ! 133: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	mov	0x7e8, %r21
	mov	0x3c8, %r20
	.word 0xd2ad04a0  ! 136: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	.word 0xd2a76000  ! 137: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xdea44400  ! 138: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	mov	0x7e8, %r21
	.word 0xdedf6000  ! 140: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	mov	0x8, %r25
	.word 0xd8dc8400  ! 142: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0x87802073  ! 143: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6adc4a0  ! 144: STBA_R	stba	%r11, [%r23 + %r0] 0x25
	mov	0x78, %r19
	.word 0xd2d52000  ! 146: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r9
	.word 0xd49c8400  ! 147: LDDA_R	ldda	[%r18, %r0] 0x20, %r10
	.word 0x87802025  ! 148: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6c4a000  ! 149: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r11
	.word 0xd6c42000  ! 150: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r11
	mov	0x7f0, %r23
	mov	0x7f0, %r23
	.word 0xd4cc8400  ! 153: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	.word 0xd89c4400  ! 154: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	.word 0x87802074  ! 155: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc95c4a0  ! 156: LDUHA_R	lduha	[%r23, %r0] 0x25, %r14
	mov	0x7d8, %r21
	.word 0xd2cf6000  ! 158: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	.word 0xd2a72000  ! 159: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	mov	0x40, %r24
	.word 0x87802072  ! 161: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2cc4400  ! 162: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r9
	mov	0x50, %r19
	mov	0x78, %r18
	.word 0xd0df0e40  ! 165: LDXA_R	ldxa	[%r28, %r0] 0x72, %r8
	.word 0xd2c5a000  ! 166: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r9
	.word 0xd4f5c4a0  ! 167: STXA_R	stxa	%r10, [%r23 + %r0] 0x25
	.word 0x87802025  ! 168: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6be6000  ! 169: STDA_I	stda	%r11, [%r25 + 0x0000] %asi
	.word 0xd696a000  ! 170: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r11
	.word 0x87802074  ! 171: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f7e000  ! 172: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6ac0400  ! 173: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	mov	0x28, %r24
	mov	0x8, %r19
	.word 0xdcbfce60  ! 176: STDA_R	stda	%r14, [%r31 + %r0] 0x73
	.word 0xd4df0e80  ! 177: LDXA_R	ldxa	[%r28, %r0] 0x74, %r10
	.word 0xdedf6000  ! 178: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xdeb76000  ! 179: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	wr_tick_cmpr_1_0:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd2, %g2
	or	%g4, 0xd7, %g4
	or	%g6, 0xd6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdeafe000  ! 181: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	mov	0x20, %r27
	.word 0xd6b7ce80  ! 183: STHA_R	stha	%r11, [%r31 + %r0] 0x74
	.word 0xd2b7ce40  ! 184: STHA_R	stha	%r9, [%r31 + %r0] 0x72
	.word 0xdaf76000  ! 185: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdedc4400  ! 186: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	.word 0xdaafa000  ! 187: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 188: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc8f4e40  ! 189: LDUBA_R	lduba	[%r29, %r0] 0x72, %r14
	mov	0x8, %r18
	.word 0xd6b74e80  ! 191: STHA_R	stha	%r11, [%r29 + %r0] 0x74
	mov	0x7d0, %r22
	.word 0xdab48400  ! 193: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0x87802072  ! 194: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2d6a000  ! 195: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r9
	.word 0xde944400  ! 196: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	mov	0x40, %r24
	.word 0xd6b6a000  ! 198: STHA_I	stha	%r11, [%r26 + 0x0000] %asi
	.word 0xdcbc8400  ! 199: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	mov	0x20, %r27
	mov	0x20, %r27
	.word 0x87802020  ! 202: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r16
	.word 0xdc9d04a0  ! 204: LDDA_R	ldda	[%r20, %r0] 0x25, %r14
	.word 0xdeb40400  ! 205: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0x87802072  ! 206: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0bec9e0  ! 207: STDA_R	stda	%r8, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 208: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde9f4e80  ! 209: LDDA_R	ldda	[%r29, %r0] 0x74, %r15
	.word 0xdcac6000  ! 210: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	mov	0x0, %r18
	.word 0xd6a44400  ! 212: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0x87802073  ! 213: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd68f2000  ! 214: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	mov	0x48, %r27
	mov	0x78, %r18
	.word 0xd68fa000  ! 217: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0xdab504a0  ! 218: STHA_R	stha	%r13, [%r20 + %r0] 0x25
	.word 0xd497a000  ! 219: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0x87802072  ! 220: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4af6000  ! 221: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd4df6000  ! 222: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4bf6000  ! 223: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd4f72000  ! 224: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 225: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4aee000  ! 226: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	.word 0xd8f584a0  ! 227: STXA_R	stxa	%r12, [%r22 + %r0] 0x25
	.word 0xd4f584a0  ! 228: STXA_R	stxa	%r10, [%r22 + %r0] 0x25
	.word 0xd0c74e80  ! 229: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r8
	.word 0xd8974e40  ! 230: LDUHA_R	lduha	[%r29, %r0] 0x72, %r12
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdcd6c9e0  ! 232: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r14
	mov	0x48, %r26
	.word 0xd69e6000  ! 234: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r11
	mov	0x68, %r24
	.word 0xded70e80  ! 236: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r15
	mov	0x3d0, %r21
	mov	0x7e0, %r22
	.word 0x87802025  ! 239: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4852000  ! 240: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r10
	.word 0xdcf78e40  ! 241: STXA_R	stxa	%r14, [%r30 + %r0] 0x72
	.word 0xdaf52000  ! 242: STXA_I	stxa	%r13, [%r20 + 0x0000] %asi
	.word 0xdadda000  ! 243: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r13
	.word 0xd8f44400  ! 244: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xd4a44400  ! 245: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 246: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c0, %r20
	.word 0xd0df6000  ! 248: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0xda878e60  ! 249: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r13
	.word 0xdc974e80  ! 250: LDUHA_R	lduha	[%r29, %r0] 0x74, %r14
	.word 0xdea7e000  ! 251: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xd4b609e0  ! 252: STHA_R	stha	%r10, [%r24 + %r0] 0x4f
	.word 0xdcb78e40  ! 253: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	mov	0x8, %r27
	.word 0xdc9c4400  ! 255: LDDA_R	ldda	[%r17, %r0] 0x20, %r14
	mov	0x40, %r17
	mov	0x48, %r26
	.word 0xd8bf6000  ! 258: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd8afe000  ! 259: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd8b6c9e0  ! 260: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	.word 0xd2dc4400  ! 261: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xd68c4400  ! 262: LDUBA_R	lduba	[%r17, %r0] 0x20, %r11
	.word 0xdabc4400  ! 263: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xd0870e80  ! 264: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r8
	.word 0xd0c40400  ! 265: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	mov	0x0, %r27
	.word 0xd28fce80  ! 267: LDUBA_R	lduba	[%r31, %r0] 0x74, %r9
	.word 0xdc9c4400  ! 268: LDDA_R	ldda	[%r17, %r0] 0x20, %r14
	.word 0xd4bf2000  ! 269: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	mov	0x30, %r25
	.word 0x87802073  ! 271: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r19
	.word 0xd4bcc400  ! 273: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0x87802072  ! 274: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 275: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8dd84a0  ! 276: LDXA_R	ldxa	[%r22, %r0] 0x25, %r12
	.word 0xdcdea000  ! 277: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r14
	mov	0x8, %r27
	mov	0x48, %r27
	.word 0xd4a70e60  ! 280: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	.word 0xd4ac8400  ! 281: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0xd8b504a0  ! 282: STHA_R	stha	%r12, [%r20 + %r0] 0x25
	.word 0xd89f0e60  ! 283: LDDA_R	ldda	[%r28, %r0] 0x73, %r12
	.word 0xd2dea000  ! 284: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r9
	mov	0x78, %r19
	.word 0xd8ac0400  ! 286: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xdebe89e0  ! 287: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	.word 0x87802072  ! 288: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 289: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcaf4e80  ! 290: STBA_R	stba	%r14, [%r29 + %r0] 0x74
	.word 0xdab5a000  ! 291: STHA_I	stha	%r13, [%r22 + 0x0000] %asi
	.word 0xd2a74e80  ! 292: STWA_R	stwa	%r9, [%r29 + %r0] 0x74
	mov	0x20, %r27
	mov	0x7d0, %r20
	mov	0x30, %r26
	.word 0xd8c44400  ! 296: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r12
	.word 0xda870e80  ! 297: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r13
	mov	0x50, %r19
	.word 0xdab689e0  ! 299: STHA_R	stha	%r13, [%r26 + %r0] 0x4f
	mov	0x40, %r19
	.word 0xd295e000  ! 301: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r9
	.word 0xd2ada000  ! 302: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xdef70e80  ! 303: STXA_R	stxa	%r15, [%r28 + %r0] 0x74
	.word 0x87802020  ! 304: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r23
	mov	0x68, %r17
	mov	0x58, %r26
	.word 0x87802073  ! 308: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd49c8400  ! 309: LDDA_R	ldda	[%r18, %r0] 0x20, %r10
	mov	0x38, %r16
	.word 0x87802074  ! 311: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r24
	.word 0xdeac2000  ! 313: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xd4bcc400  ! 314: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	mov	0x3c0, %r22
	mov	0x7f0, %r20
	.word 0xdab46000  ! 317: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	mov	0x3c8, %r20
	mov	0x18, %r17
	.word 0xdedd04a0  ! 320: LDXA_R	ldxa	[%r20, %r0] 0x25, %r15
	.word 0xd2a42000  ! 321: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	mov	0x7f0, %r20
	mov	0x78, %r26
	mov	0x50, %r25
	.word 0xd2b4a000  ! 325: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0xd2946000  ! 326: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r9
	.word 0xd294a000  ! 327: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r9
	.word 0xdef40400  ! 328: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	mov	0x38, %r17
	mov	0x70, %r18
	mov	0x0, %r18
	mov	0x18, %r24
	mov	0x7e8, %r23
	.word 0xdc8f0e60  ! 334: LDUBA_R	lduba	[%r28, %r0] 0x73, %r14
	.word 0xd8bec9e0  ! 335: STDA_R	stda	%r12, [%r27 + %r0] 0x4f
	.word 0x8780204f  ! 336: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x48, %r17
	mov	0x3e8, %r22
	.word 0x87802072  ! 339: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b7ce80  ! 340: STHA_R	stha	%r12, [%r31 + %r0] 0x74
	mov	0x48, %r18
	mov	0x30, %r26
	.word 0xd0b5e000  ! 343: STHA_I	stha	%r8, [%r23 + 0x0000] %asi
	mov	0x50, %r25
	mov	0x7c8, %r21
	.word 0x87802072  ! 346: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde8d84a0  ! 347: LDUBA_R	lduba	[%r22, %r0] 0x25, %r15
	.word 0xd0a76000  ! 348: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xdc8f8e80  ! 349: LDUBA_R	lduba	[%r30, %r0] 0x74, %r14
	.word 0xd2876000  ! 350: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	mov	0x0, %r25
	.word 0x87802074  ! 352: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcd70e80  ! 353: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r14
	.word 0x8780204f  ! 354: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r27
	.word 0xd6c72000  ! 356: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0xd69f6000  ! 357: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	.word 0x87802025  ! 358: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0ddc4a0  ! 359: LDXA_R	ldxa	[%r23, %r0] 0x25, %r8
	.word 0xdea74e60  ! 360: STWA_R	stwa	%r15, [%r29 + %r0] 0x73
	.word 0xdcaf8e80  ! 361: STBA_R	stba	%r14, [%r30 + %r0] 0x74
	mov	0x7e0, %r23
	.word 0xd49f2000  ! 363: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd4d7e000  ! 364: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	mov	0x68, %r26
	.word 0xd69544a0  ! 366: LDUHA_R	lduha	[%r21, %r0] 0x25, %r11
	.word 0xd0f7a000  ! 367: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd497ce60  ! 368: LDUHA_R	lduha	[%r31, %r0] 0x73, %r10
	.word 0xdc8fe000  ! 369: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	mov	0x70, %r25
	.word 0xd2f504a0  ! 371: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	.word 0x87802072  ! 372: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6c5a000  ! 373: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r11
	.word 0xd6952000  ! 374: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r11
	mov	0x3f0, %r23
	.word 0xdcae09e0  ! 376: STBA_R	stba	%r14, [%r24 + %r0] 0x4f
	.word 0xd4ada000  ! 377: STBA_I	stba	%r10, [%r22 + 0x0000] %asi
	mov	0x3c0, %r23
	.word 0xd485e000  ! 379: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r10
	.word 0xd49de000  ! 380: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r10
	.word 0xd8a5c4a0  ! 381: STWA_R	stwa	%r12, [%r23 + %r0] 0x25
	.word 0xd0f5e000  ! 382: STXA_I	stxa	%r8, [%r23 + 0x0000] %asi
	.word 0xd09da000  ! 383: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r8
	.word 0xdea40400  ! 384: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	mov	0x7d8, %r20
	mov	0x20, %r19
	.word 0xd8ad2000  ! 387: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	mov	0x7e0, %r21
	.word 0xda96c9e0  ! 389: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r13
	.word 0xd6dc4400  ! 390: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xdeafce80  ! 391: STBA_R	stba	%r15, [%r31 + %r0] 0x74
	mov	0x30, %r26
	mov	0x3e0, %r20
	.word 0xda8d6000  ! 394: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r13
	.word 0xda95a000  ! 395: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r13
	.word 0xdab5a000  ! 396: STHA_I	stha	%r13, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 397: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab66000  ! 398: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0xdad6e000  ! 399: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r13
	.word 0x87802074  ! 400: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd88e49e0  ! 401: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r12
	.word 0xdec46000  ! 402: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	.word 0xdeb4e000  ! 403: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0xded42000  ! 404: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	.word 0x87802072  ! 405: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 406: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e8, %r23
	.word 0xd8d7ce80  ! 408: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r12
	.word 0xd4a70e40  ! 409: STWA_R	stwa	%r10, [%r28 + %r0] 0x72
	.word 0xdabf6000  ! 410: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xda87a000  ! 411: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 412: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabee000  ! 413: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xdcbd04a0  ! 415: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	.word 0xd6866000  ! 416: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r11
	mov	0x3e0, %r21
	mov	0x48, %r16
	.word 0xda8ec9e0  ! 419: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r13
	.word 0xd2ac0400  ! 420: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	mov	0x48, %r25
	.word 0xd6b6a000  ! 422: STHA_I	stha	%r11, [%r26 + 0x0000] %asi
	mov	0x40, %r26
	.word 0xd0bfce80  ! 424: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	mov	0x58, %r19
	.word 0x87802020  ! 426: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r16
	.word 0xd09fa000  ! 428: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	.word 0xd0a7a000  ! 429: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd697ce40  ! 430: LDUHA_R	lduha	[%r31, %r0] 0x72, %r11
	.word 0x87802020  ! 431: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ada000  ! 432: STBA_I	stba	%r11, [%r22 + 0x0000] %asi
	.word 0xd68de000  ! 433: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r11
	.word 0x87802073  ! 434: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6962000  ! 436: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r11
	mov	0x8, %r26
	.word 0xdcafce60  ! 438: STBA_R	stba	%r14, [%r31 + %r0] 0x73
	mov	0x3c0, %r20
	.word 0xdcc62000  ! 440: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r14
	.word 0xdabf8e80  ! 441: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	.word 0xdcf44400  ! 442: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	mov	0x0, %r16
	.word 0xdea6a000  ! 444: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	mov	0x18, %r24
	mov	0x48, %r17
	.word 0xdeb62000  ! 447: STHA_I	stha	%r15, [%r24 + 0x0000] %asi
	.word 0xdcdd04a0  ! 448: LDXA_R	ldxa	[%r20, %r0] 0x25, %r14
	mov	0x58, %r18
	.word 0xd6f44400  ! 450: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 451: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd294c400  ! 452: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	mov	0x78, %r26
	.word 0xd8cca000  ! 454: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r12
	mov	0x0, %r27
	.word 0xd4a70e60  ! 456: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	.word 0xdc8689e0  ! 457: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r14
	mov	0x3f0, %r20
	.word 0xd6bc0400  ! 459: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xdacc6000  ! 460: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	.word 0xd8ac0400  ! 461: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	mov	0x3d8, %r21
	.word 0xd6bc8400  ! 463: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xdaaf4e60  ! 464: STBA_R	stba	%r13, [%r29 + %r0] 0x73
	.word 0xd285c4a0  ! 465: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r9
	ta	T_CHANGE_PRIV	! macro
	ta	T_CHANGE_HPRIV	! macro
	mov	0x48, %r25
	mov	0x7f8, %r23
	.word 0xd2ace000  ! 470: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0xd2c4a000  ! 471: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	mov	0x70, %r25
	.word 0xde9fce60  ! 473: LDDA_R	ldda	[%r31, %r0] 0x73, %r15
	.word 0xdab4a000  ! 474: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0xd8f48400  ! 475: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xd69c6000  ! 476: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r11
	.word 0x87802025  ! 477: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6bc2000  ! 478: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0xd6bca000  ! 479: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	.word 0xdcb504a0  ! 480: STHA_R	stha	%r14, [%r20 + %r0] 0x25
	.word 0xda942000  ! 481: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0xdcdc0400  ! 482: LDXA_R	ldxa	[%r16, %r0] 0x20, %r14
	ta	T_CHANGE_HPRIV	! macro
	mov	0x3f8, %r21
	.word 0xdc9f4e80  ! 485: LDDA_R	ldda	[%r29, %r0] 0x74, %r14
	mov	0x3d8, %r22
	mov	0x7d8, %r21
	.word 0x87802020  ! 488: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r20
	.word 0xd89609e0  ! 490: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r12
	mov	0x7c8, %r20
	.word 0x87802020  ! 492: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2df4e80  ! 493: LDXA_R	ldxa	[%r29, %r0] 0x74, %r9
	.word 0xd6bce000  ! 494: STDA_I	stda	%r11, [%r19 + 0x0000] %asi
	.word 0xd0af0e40  ! 495: STBA_R	stba	%r8, [%r28 + %r0] 0x72
	.word 0xde87ce80  ! 496: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r15
	mov	0x8, %r24
	mov	0x40, %r17
	.word 0xd6b46000  ! 499: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd29e49e0  ! 500: LDDA_R	ldda	[%r25, %r0] 0x4f, %r9
	.word 0xd68f4e40  ! 501: LDUBA_R	lduba	[%r29, %r0] 0x72, %r11
	mov	0x40, %r26
	.word 0xd4bf4e60  ! 503: STDA_R	stda	%r10, [%r29 + %r0] 0x73
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x20, %r18
	.word 0x87802020  ! 506: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2df6000  ! 507: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0x87802074  ! 508: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bc8400  ! 509: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xd6bc0400  ! 510: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 511: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd68609e0  ! 512: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r11
	.word 0x87802072  ! 513: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2cf4e80  ! 514: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r9
	.word 0xd4f76000  ! 515: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd8d689e0  ! 516: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r12
	.word 0xd4b72000  ! 517: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd4f72000  ! 518: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xdab584a0  ! 519: STHA_R	stha	%r13, [%r22 + %r0] 0x25
	.word 0xdedf2000  ! 520: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	mov	0x28, %r18
	.word 0xda8d44a0  ! 522: LDUBA_R	lduba	[%r21, %r0] 0x25, %r13
	mov	0x7d8, %r21
	.word 0xdacf8e40  ! 524: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r13
	.word 0xd0dd84a0  ! 525: LDXA_R	ldxa	[%r22, %r0] 0x25, %r8
	.word 0xd2b72000  ! 526: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd2b72000  ! 527: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xdedf0e80  ! 528: LDXA_R	ldxa	[%r28, %r0] 0x74, %r15
	wr_tick_cmpr_1_1:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x91, %g2
	or	%g4, 0xd8, %g4
	or	%g6, 0xd9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802025  ! 530: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4f52000  ! 531: STXA_I	stxa	%r10, [%r20 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xd4956000  ! 533: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r10
	.word 0xd4bf0e60  ! 534: STDA_R	stda	%r10, [%r28 + %r0] 0x73
	.word 0xd4f504a0  ! 535: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0xd2ad6000  ! 536: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	mov	0x20, %r19
	.word 0xd2bd2000  ! 538: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	mov	0x40, %r17
	.word 0xdef48400  ! 540: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xd8b689e0  ! 541: STHA_R	stha	%r12, [%r26 + %r0] 0x4f
	.word 0xdcd649e0  ! 542: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r14
	.word 0x87802073  ! 543: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f7e000  ! 544: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	mov	0x38, %r26
	.word 0xd6c76000  ! 546: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xdc8c8400  ! 547: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0xd4a76000  ! 548: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd8cc0400  ! 549: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	.word 0x87802072  ! 550: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd88f4e80  ! 551: LDUBA_R	lduba	[%r29, %r0] 0x74, %r12
	mov	0x30, %r24
	.word 0xdadc2000  ! 553: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r13
	mov	0x3d8, %r20
	mov	0x10, %r24
	.word 0xd2f40400  ! 556: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xded4a000  ! 557: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	mov	0x58, %r18
	.word 0xdeac6000  ! 559: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xdedc6000  ! 560: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r15
	mov	0x48, %r24
	.word 0x87802072  ! 562: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda848400  ! 563: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r13
	mov	0x30, %r24
	.word 0x87802020  ! 565: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ad2000  ! 566: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	.word 0xdab44400  ! 567: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0xded504a0  ! 568: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r15
	.word 0xd89d2000  ! 569: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r12
	.word 0xdeb649e0  ! 570: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	mov	0x0, %r25
	.word 0xd0a40400  ! 572: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	mov	0x7d8, %r22
	.word 0x87802073  ! 574: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xdc9f0e60  ! 576: LDDA_R	ldda	[%r28, %r0] 0x73, %r14
	mov	0x30, %r18
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd69c2000  ! 579: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r11
	mov	0x50, %r16
	.word 0xdeb70e60  ! 581: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	.word 0xd087ce60  ! 582: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r8
	.word 0xd0b42000  ! 583: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xd09c4400  ! 584: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	mov	0x68, %r25
	.word 0xd4842000  ! 586: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	.word 0xd4bca000  ! 587: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	mov	0x0, %r27
	.word 0xd4dc6000  ! 589: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	.word 0xd2f48400  ! 590: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	mov	0x18, %r18
	mov	0x48, %r25
	.word 0xd08e89e0  ! 593: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r8
	mov	0x7e0, %r20
	.word 0xd6a74e40  ! 595: STWA_R	stwa	%r11, [%r29 + %r0] 0x72
	mov	0x28, %r18
	.word 0xdcb46000  ! 597: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xd8d44400  ! 598: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	.word 0xdebc4400  ! 599: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0xdcd42000  ! 600: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	mov	0x38, %r16
	.word 0xdc9ca000  ! 602: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r14
	mov	0x8, %r16
	mov	0x68, %r19
	.word 0xd8b40400  ! 605: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xd8d7ce40  ! 606: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r12
	.word 0xdca40400  ! 607: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0x87802074  ! 608: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b72000  ! 609: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd2f7a000  ! 610: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 611: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f44400  ! 612: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0x87802072  ! 613: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb7ce80  ! 614: STHA_R	stha	%r15, [%r31 + %r0] 0x74
	.word 0xd0962000  ! 615: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r8
	.word 0xd097ce40  ! 616: LDUHA_R	lduha	[%r31, %r0] 0x72, %r8
	.word 0xdaaee000  ! 617: STBA_I	stba	%r13, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 618: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedf0e80  ! 619: LDXA_R	ldxa	[%r28, %r0] 0x74, %r15
	.word 0xd2af6000  ! 620: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	mov	0x68, %r26
	.word 0x87802073  ! 622: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r16
	mov	0x28, %r24
	.word 0xdebd44a0  ! 625: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	.word 0xdef74e60  ! 626: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	.word 0xdcbd6000  ! 627: STDA_I	stda	%r14, [%r21 + 0x0000] %asi
	.word 0xdcc5e000  ! 628: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r14
	.word 0xdcbd2000  ! 629: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	mov	0x0, %r24
	mov	0x3e8, %r22
	.word 0xdca56000  ! 632: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	mov	0x50, %r19
	.word 0xdeb689e0  ! 634: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	.word 0xd88fce60  ! 635: LDUBA_R	lduba	[%r31, %r0] 0x73, %r12
	.word 0xd48d2000  ! 636: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0xdab7ce40  ! 637: STHA_R	stha	%r13, [%r31 + %r0] 0x72
	mov	0x48, %r17
	.word 0xdc852000  ! 639: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r14
	.word 0xdcaf8e60  ! 640: STBA_R	stba	%r14, [%r30 + %r0] 0x73
	.word 0xdebd6000  ! 641: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	.word 0xdab44400  ! 642: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0xdac74e40  ! 643: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r13
	.word 0xdcb70e40  ! 644: STHA_R	stha	%r14, [%r28 + %r0] 0x72
	.word 0x87802020  ! 645: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ce2000  ! 646: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r9
	.word 0xde97ce80  ! 647: LDUHA_R	lduha	[%r31, %r0] 0x74, %r15
	wr_tick_cmpr_1_2:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xff, %g2
	or	%g4, 0x8c, %g4
	or	%g6, 0xfa, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7f8, %r22
	.word 0xd8a6e000  ! 650: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	.word 0x87802072  ! 651: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd88ce000  ! 652: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	.word 0xd8b4e000  ! 653: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 654: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8b4a000  ! 655: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 656: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r16
	mov	0x28, %r26
	.word 0xd6bdc4a0  ! 659: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	mov	0x20, %r26
	.word 0xd2978e40  ! 661: LDUHA_R	lduha	[%r30, %r0] 0x72, %r9
	.word 0xd09fe000  ! 662: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	.word 0xd8dfce80  ! 663: LDXA_R	ldxa	[%r31, %r0] 0x74, %r12
	.word 0xdc9fa000  ! 664: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0x87802020  ! 665: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r21
	mov	0x7e0, %r21
	mov	0x60, %r25
	.word 0xdcad6000  ! 669: STBA_I	stba	%r14, [%r21 + 0x0000] %asi
	.word 0xd28dc4a0  ! 670: LDUBA_R	lduba	[%r23, %r0] 0x25, %r9
	.word 0xdea44400  ! 671: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xd8be09e0  ! 672: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 673: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f4a000  ! 674: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 675: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 676: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0cfa000  ! 677: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0x87802073  ! 678: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f8, %r20
	.word 0xd4af4e60  ! 680: STBA_R	stba	%r10, [%r29 + %r0] 0x73
	mov	0x68, %r24
	.word 0xd8ada000  ! 682: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	mov	0x68, %r26
	.word 0xda9544a0  ! 684: LDUHA_R	lduha	[%r21, %r0] 0x25, %r13
	.word 0xd8b78e80  ! 685: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	.word 0x87802072  ! 686: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 687: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 688: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4b609e0  ! 689: STHA_R	stha	%r10, [%r24 + %r0] 0x4f
	.word 0x87802072  ! 690: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7c8, %r21
	.word 0xd88d44a0  ! 692: LDUBA_R	lduba	[%r21, %r0] 0x25, %r12
	mov	0x3c0, %r21
	.word 0xdc952000  ! 694: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r14
	.word 0xdcc74e80  ! 695: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r14
	.word 0xd0970e80  ! 696: LDUHA_R	lduha	[%r28, %r0] 0x74, %r8
	.word 0xdedde000  ! 697: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r15
	.word 0xde9da000  ! 698: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r15
	.word 0x87802072  ! 699: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb56000  ! 700: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	.word 0xde87ce80  ! 701: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r15
	mov	0x38, %r16
	.word 0x8780204f  ! 703: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda8f8e60  ! 704: LDUBA_R	lduba	[%r30, %r0] 0x73, %r13
	.word 0xd0df4e60  ! 705: LDXA_R	ldxa	[%r29, %r0] 0x73, %r8
	.word 0x87802020  ! 706: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcaf2000  ! 707: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdcdfe000  ! 708: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xd4f40400  ! 709: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xd0af6000  ! 710: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	wr_tick_cmpr_1_3:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe4, %g2
	or	%g4, 0xbe, %g4
	or	%g6, 0xce, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x38, %r26
	.word 0xdac48400  ! 713: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	.word 0x87802020  ! 714: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28ea000  ! 715: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r9
	mov	0x70, %r24
	.word 0xd2c62000  ! 717: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r9
	.word 0xd2cea000  ! 718: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r9
	.word 0x87802074  ! 719: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d0, %r22
	.word 0xd28ca000  ! 721: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0x87802072  ! 722: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r27
	.word 0xd2d70e80  ! 724: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r9
	.word 0xd6ac4400  ! 725: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	mov	0x8, %r19
	.word 0xd4dca000  ! 727: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	.word 0x87802020  ! 728: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4dfa000  ! 729: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd0f7ce40  ! 730: STXA_R	stxa	%r8, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 731: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r22
	.word 0xd2ac2000  ! 733: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd2d5c4a0  ! 734: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r9
	wr_tick_cmpr_1_4:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe2, %g2
	or	%g4, 0xf7, %g4
	or	%g6, 0xb4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0f649e0  ! 736: STXA_R	stxa	%r8, [%r25 + %r0] 0x4f
	mov	0x3c0, %r23
	mov	0x20, %r26
	.word 0xd6df4e80  ! 739: LDXA_R	ldxa	[%r29, %r0] 0x74, %r11
	.word 0xd0a74e60  ! 740: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	.word 0xd884e000  ! 741: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r12
	mov	0x0, %r27
	.word 0xd8846000  ! 743: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	.word 0xd0b7ce40  ! 744: STHA_R	stha	%r8, [%r31 + %r0] 0x72
	.word 0xd4bc2000  ! 745: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0xd4bce000  ! 746: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xd0c609e0  ! 748: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r8
	mov	0x30, %r16
	mov	0x3e0, %r21
	.word 0x87802074  ! 751: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 752: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeafe000  ! 753: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xdcde49e0  ! 754: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r14
	.word 0x8780204f  ! 755: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e0, %r22
	mov	0x50, %r25
	mov	0x28, %r16
	.word 0xd49dc4a0  ! 759: LDDA_R	ldda	[%r23, %r0] 0x25, %r10
	.word 0xdcc66000  ! 760: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	.word 0xdebc8400  ! 761: STDA_R	stda	%r15, [%r18 + %r0] 0x20
	.word 0xd4dee000  ! 762: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r10
	.word 0xdab544a0  ! 763: STHA_R	stha	%r13, [%r21 + %r0] 0x25
	.word 0xdac609e0  ! 764: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r13
	.word 0x87802074  ! 765: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde87a000  ! 766: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xdeaf6000  ! 767: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0x87802074  ! 769: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r16
	.word 0x87802072  ! 771: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xded70e60  ! 772: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r15
	.word 0xd48f2000  ! 773: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4f76000  ! 774: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4c76000  ! 775: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4a76000  ! 776: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4b72000  ! 777: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	mov	0x7c0, %r20
	.word 0xd4df6000  ! 779: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4a72000  ! 780: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4872000  ! 781: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0xdcc649e0  ! 782: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r14
	.word 0xdef609e0  ! 783: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	.word 0xd0a6c9e0  ! 784: STWA_R	stwa	%r8, [%r27 + %r0] 0x4f
	mov	0x7d0, %r23
	.word 0xd4848400  ! 786: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r10
	mov	0x3c8, %r22
	.word 0xd08f6000  ! 788: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r8
	mov	0x8, %r19
	.word 0xd8be09e0  ! 790: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	.word 0xd4df6000  ! 791: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	mov	0x3e8, %r23
	mov	0x50, %r17
	.word 0xdebf8e80  ! 794: STDA_R	stda	%r15, [%r30 + %r0] 0x74
	mov	0x28, %r17
	.word 0xdeb7a000  ! 796: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xde9fe000  ! 797: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0xdcdf0e80  ! 798: LDXA_R	ldxa	[%r28, %r0] 0x74, %r14
	.word 0xd0872000  ! 799: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0a649e0  ! 800: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	.word 0xd6cf2000  ! 801: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0xd6af6000  ! 802: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x30, %r16
	.word 0xd8cf8e80  ! 804: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r12
	.word 0xded7a000  ! 805: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	mov	0x50, %r27
	.word 0x87802020  ! 807: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r19
	.word 0xdeb42000  ! 809: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	wr_tick_cmpr_1_5:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x8d, %g2
	or	%g4, 0xde, %g4
	or	%g6, 0x8f, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdedce000  ! 811: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r15
	.word 0xdef4a000  ! 812: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0xde84a000  ! 813: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	.word 0x87802020  ! 814: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b48400  ! 815: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd8c584a0  ! 816: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r12
	mov	0x3f0, %r21
	.word 0xd0f504a0  ! 818: STXA_R	stxa	%r8, [%r20 + %r0] 0x25
	.word 0xd2ce49e0  ! 819: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r9
	mov	0x3f0, %r21
	.word 0x8780204f  ! 821: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6ade000  ! 822: STBA_I	stba	%r11, [%r23 + 0x0000] %asi
	.word 0xded689e0  ! 823: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r15
	mov	0x28, %r25
	mov	0x78, %r17
	.word 0x87802072  ! 826: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 827: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r17
	mov	0x38, %r26
	.word 0xd4bce000  ! 830: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	mov	0x68, %r27
	mov	0x7c8, %r20
	mov	0x7f8, %r21
	.word 0xdebc4400  ! 834: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0xdcdec9e0  ! 835: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r14
	.word 0xdcc7ce40  ! 836: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r14
	mov	0x78, %r26
	.word 0xd4aca000  ! 838: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0xd49ca000  ! 839: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd6d40400  ! 840: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	.word 0xd4aec9e0  ! 841: STBA_R	stba	%r10, [%r27 + %r0] 0x4f
	.word 0xd084e000  ! 842: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	.word 0xd8df4e80  ! 843: LDXA_R	ldxa	[%r29, %r0] 0x74, %r12
	.word 0x87802073  ! 844: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 845: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r18
	mov	0x7c8, %r23
	.word 0x87802073  ! 848: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc8e89e0  ! 849: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r14
	mov	0x3d0, %r22
	.word 0xdcb74e60  ! 851: STHA_R	stha	%r14, [%r29 + %r0] 0x73
	.word 0xdcbca000  ! 852: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdcbc2000  ! 853: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	mov	0x40, %r24
	mov	0x30, %r26
	.word 0xdca42000  ! 856: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 857: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf4e000  ! 858: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xd8970e80  ! 859: LDUHA_R	lduha	[%r28, %r0] 0x74, %r12
	.word 0x87802074  ! 860: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f6e000  ! 861: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	.word 0xd0dea000  ! 862: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r8
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd4bf4e40  ! 864: STDA_R	stda	%r10, [%r29 + %r0] 0x72
	.word 0x87802020  ! 865: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded46000  ! 866: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	.word 0xdecce000  ! 867: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	.word 0xdef4e000  ! 868: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0xdadc0400  ! 870: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	.word 0xda84a000  ! 871: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	mov	0x20, %r26
	.word 0x87802072  ! 873: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r24
	mov	0x48, %r18
	.word 0xd4a44400  ! 876: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0x87802072  ! 877: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 878: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r26
	.word 0x87802073  ! 880: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc9dc4a0  ! 881: LDDA_R	ldda	[%r23, %r0] 0x25, %r14
	.word 0xd0bcc400  ! 882: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0x87802020  ! 883: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 884: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f8, %r23
	.word 0xd8a44400  ! 886: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xd8a70e60  ! 887: STWA_R	stwa	%r12, [%r28 + %r0] 0x73
	.word 0xd49ee000  ! 888: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r10
	mov	0x10, %r19
	.word 0xdca48400  ! 890: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xde978e40  ! 891: LDUHA_R	lduha	[%r30, %r0] 0x72, %r15
	.word 0xd69ea000  ! 892: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r11
	.word 0xd6b6e000  ! 893: STHA_I	stha	%r11, [%r27 + 0x0000] %asi
	.word 0xd8c609e0  ! 894: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r12
	.word 0xd89e49e0  ! 895: LDDA_R	ldda	[%r25, %r0] 0x4f, %r12
	.word 0xd2dd44a0  ! 896: LDXA_R	ldxa	[%r21, %r0] 0x25, %r9
	.word 0xdea66000  ! 897: STWA_I	stwa	%r15, [%r25 + 0x0000] %asi
	mov	0x3e0, %r21
	.word 0xdecee000  ! 899: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r15
	.word 0x87802073  ! 900: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c0, %r23
	.word 0xdea7a000  ! 902: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	mov	0x7c0, %r20
	mov	0x70, %r26
	.word 0x87802020  ! 905: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 906: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2f70e60  ! 907: STXA_R	stxa	%r9, [%r28 + %r0] 0x73
	.word 0xd2b74e80  ! 908: STHA_R	stha	%r9, [%r29 + %r0] 0x74
	.word 0xdecce000  ! 909: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	.word 0xdec4a000  ! 910: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xdecca000  ! 911: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	.word 0xde84e000  ! 912: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	mov	0x78, %r18
	.word 0xd6dc8400  ! 914: LDXA_R	ldxa	[%r18, %r0] 0x20, %r11
	.word 0x87802072  ! 915: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f8, %r22
	.word 0xd0bd6000  ! 917: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0xd2be49e0  ! 918: STDA_R	stda	%r9, [%r25 + %r0] 0x4f
	.word 0xd2ada000  ! 919: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xdac74e80  ! 920: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r13
	.word 0xd4d48400  ! 921: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	.word 0xd2b70e60  ! 922: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	.word 0xd2b5a000  ! 923: STHA_I	stha	%r9, [%r22 + 0x0000] %asi
	.word 0xd6f70e40  ! 924: STXA_R	stxa	%r11, [%r28 + %r0] 0x72
	mov	0x68, %r24
	mov	0x7c0, %r20
	.word 0xdaf7ce40  ! 927: STXA_R	stxa	%r13, [%r31 + %r0] 0x72
	mov	0x40, %r24
	mov	0x3e8, %r21
	.word 0xd695a000  ! 930: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r11
	.word 0xd6a5e000  ! 931: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	.word 0xd69de000  ! 932: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r11
	.word 0xd88e89e0  ! 933: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r12
	mov	0x7c8, %r21
	mov	0x7f8, %r23
	.word 0xdcd5a000  ! 936: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r14
	.word 0xd4b74e60  ! 937: STHA_R	stha	%r10, [%r29 + %r0] 0x73
	.word 0xd4dd2000  ! 938: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r10
	.word 0xd4856000  ! 939: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r10
	.word 0xd48de000  ! 940: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r10
	mov	0x8, %r18
	mov	0x18, %r16
	.word 0xd4d56000  ! 943: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r10
	.word 0xdad78e60  ! 944: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r13
	.word 0xd6d52000  ! 945: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r11
	.word 0xd8bc4400  ! 946: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xd4d544a0  ! 947: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r10
	.word 0xdeb5e000  ! 948: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	mov	0x38, %r19
	.word 0xdab44400  ! 950: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	mov	0x58, %r27
	.word 0xd28d2000  ! 952: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r9
	.word 0xd69649e0  ! 953: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r11
	.word 0xdacc4400  ! 954: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	.word 0xdeb56000  ! 955: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	mov	0x10, %r18
	.word 0xdabf0e60  ! 957: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	.word 0x87802020  ! 958: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r19
	.word 0xdcbfa000  ! 960: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 961: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf7a000  ! 962: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xdeb78e60  ! 963: STHA_R	stha	%r15, [%r30 + %r0] 0x73
	.word 0xd2872000  ! 964: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	.word 0xd28f6000  ! 965: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	mov	0x7c8, %r21
	.word 0xd2bfa000  ! 967: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 968: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r24
	mov	0x78, %r17
	.word 0xd8cc8400  ! 971: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0xdcbe2000  ! 972: STDA_I	stda	%r14, [%r24 + 0x0000] %asi
	mov	0x18, %r16
	mov	0x0, %r26
	.word 0x87802020  ! 975: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcc72000  ! 976: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xd8d78e40  ! 977: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r12
	.word 0xdeb78e40  ! 978: STHA_R	stha	%r15, [%r30 + %r0] 0x72
	.word 0xd2af2000  ! 979: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd28f8e40  ! 980: LDUBA_R	lduba	[%r30, %r0] 0x72, %r9
	.word 0xde8649e0  ! 981: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r15
	.word 0x87802020  ! 982: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 983: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r17
	.word 0xdca74e80  ! 985: STWA_R	stwa	%r14, [%r29 + %r0] 0x74
	.word 0xd4d7e000  ! 986: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	.word 0xd0af8e80  ! 987: STBA_R	stba	%r8, [%r30 + %r0] 0x74
	.word 0xd6afe000  ! 988: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x10, %r25
	.word 0xd6afe000  ! 990: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x3c8, %r20
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2b48400  ! 993: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xdcc48400  ! 994: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r14
	.word 0x87802074  ! 995: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c0, %r20
	.word 0xdeb4c400  ! 997: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0x87802074  ! 998: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 999: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r26
	.word 0xd697e000  ! 1001: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	mov	0x30, %r17
	.word 0x8780204f  ! 1003: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r24
	.word 0x87802025  ! 1005: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd887ce40  ! 1006: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r12
	mov	0x7e8, %r21
	.word 0xd6852000  ! 1008: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r11
	mov	0x10, %r16
	mov	0x38, %r17
	.word 0xdcdc4400  ! 1011: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	.word 0xdc8da000  ! 1012: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r14
	.word 0xd29dc4a0  ! 1013: LDDA_R	ldda	[%r23, %r0] 0x25, %r9
	.word 0x87802020  ! 1014: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb4e000  ! 1015: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 1016: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 1017: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc94a000  ! 1018: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0x87802020  ! 1019: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8f0e40  ! 1020: LDUBA_R	lduba	[%r28, %r0] 0x72, %r13
	.word 0xd0f46000  ! 1021: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xda9689e0  ! 1022: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r13
	mov	0x7e0, %r22
	mov	0x28, %r25
	.word 0xd294a000  ! 1025: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r9
	.word 0xd2cc2000  ! 1026: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r9
	mov	0x18, %r18
	.word 0xd28c2000  ! 1028: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xd2a4e000  ! 1029: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2bc6000  ! 1030: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0xd6b544a0  ! 1031: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	.word 0xda8c0400  ! 1032: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	.word 0xd8c70e40  ! 1033: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r12
	.word 0xd6844400  ! 1034: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r11
	.word 0xd2d649e0  ! 1035: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r9
	.word 0xde8ca000  ! 1036: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0xd4bfce60  ! 1037: STDA_R	stda	%r10, [%r31 + %r0] 0x73
	mov	0x70, %r17
	.word 0xd6dc0400  ! 1039: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	.word 0xd8ac6000  ! 1040: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	mov	0x68, %r26
	mov	0x3d8, %r22
	.word 0xd2bc4400  ! 1043: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	mov	0x3c0, %r23
	.word 0xd2974e40  ! 1045: LDUHA_R	lduha	[%r29, %r0] 0x72, %r9
	.word 0xd0842000  ! 1046: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r8
	.word 0xdc8c0400  ! 1047: LDUBA_R	lduba	[%r16, %r0] 0x20, %r14
	mov	0x0, %r18
	.word 0xd8aca000  ! 1049: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	mov	0x70, %r16
	.word 0xd8a4e000  ! 1051: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xd88ca000  ! 1052: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	.word 0xd4c48400  ! 1053: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r10
	.word 0xd28ca000  ! 1054: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0x87802072  ! 1055: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 1056: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1057: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c42000  ! 1058: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	.word 0xd2bc6000  ! 1059: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0xd2f4a000  ! 1060: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0xd2f4e000  ! 1061: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2cce000  ! 1062: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	.word 0xd2cc2000  ! 1063: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r9
	mov	0x40, %r18
	.word 0xd2c4e000  ! 1065: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xd28c2000  ! 1066: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xdeb70e80  ! 1067: STHA_R	stha	%r15, [%r28 + %r0] 0x74
	.word 0xd8b4e000  ! 1068: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	mov	0x48, %r16
	.word 0xd8bc2000  ! 1070: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 1071: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r25
	mov	0x68, %r25
	.word 0xd6c504a0  ! 1074: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r11
	.word 0x87802072  ! 1075: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda976000  ! 1076: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	.word 0xda876000  ! 1077: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0xdaaf2000  ! 1078: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xd6f78e80  ! 1079: STXA_R	stxa	%r11, [%r30 + %r0] 0x74
	mov	0x60, %r25
	.word 0xd0bf2000  ! 1081: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xd0af2000  ! 1082: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	mov	0x60, %r19
	.word 0xd4b7ce60  ! 1084: STHA_R	stha	%r10, [%r31 + %r0] 0x73
	wr_tick_cmpr_1_6:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x86, %g2
	or	%g4, 0xd4, %g4
	or	%g6, 0xed, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0f76000  ! 1086: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	mov	0x20, %r26
	mov	0x7c8, %r22
	.word 0xd4870e80  ! 1089: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r10
	.word 0xd6a74e40  ! 1090: STWA_R	stwa	%r11, [%r29 + %r0] 0x72
	.word 0xd4cf6000  ! 1091: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0xdc948400  ! 1092: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	mov	0x10, %r16
	wr_tick_cmpr_1_7:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa9, %g2
	or	%g4, 0xc5, %g4
	or	%g6, 0xfb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2dfa000  ! 1095: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0x87802073  ! 1096: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd28c6000  ! 1097: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0xd29ca000  ! 1098: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	mov	0x8, %r16
	mov	0x38, %r27
	.word 0xd2a4e000  ! 1101: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	mov	0x38, %r18
	.word 0x87802072  ! 1103: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2dfce60  ! 1104: LDXA_R	ldxa	[%r31, %r0] 0x73, %r9
	.word 0xd0dc4400  ! 1105: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	.word 0xded66000  ! 1106: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r15
	mov	0x70, %r25
	.word 0x87802025  ! 1108: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeac6000  ! 1109: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xdec46000  ! 1110: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	ta	T_CHANGE_PRIV	! macro
	.word 0xdef42000  ! 1112: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 1113: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde8c0400  ! 1114: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0xd6b42000  ! 1115: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0xd0b7ce80  ! 1116: STHA_R	stha	%r8, [%r31 + %r0] 0x74
	.word 0xd8afce80  ! 1117: STBA_R	stba	%r12, [%r31 + %r0] 0x74
	.word 0xdaa4a000  ! 1118: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xdaf42000  ! 1119: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0xda9ca000  ! 1120: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	.word 0xda842000  ! 1121: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r13
	.word 0xd4f504a0  ! 1122: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	mov	0x70, %r24
	.word 0xdeac6000  ! 1124: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xdecce000  ! 1125: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	.word 0xdea46000  ! 1126: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	mov	0x78, %r25
	.word 0xd4c78e60  ! 1128: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r10
	mov	0x7e0, %r23
	.word 0xd4cca000  ! 1130: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r10
	mov	0x3c0, %r20
	.word 0xd4a4a000  ! 1132: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 1133: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f40400  ! 1134: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	.word 0xd09c0400  ! 1135: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	.word 0xdef72000  ! 1136: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1137: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded72000  ! 1138: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xd6df4e40  ! 1139: LDXA_R	ldxa	[%r29, %r0] 0x72, %r11
	.word 0xd29c4400  ! 1140: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	.word 0x87802025  ! 1141: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c0, %r23
	mov	0x78, %r26
	.word 0xdcf5a000  ! 1144: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	.word 0x87802073  ! 1145: WRASI_I	wr	%r0, 0x0073, %asi
	wr_tick_cmpr_1_8:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd6, %g2
	or	%g4, 0xd0, %g4
	or	%g6, 0xcb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x50, %r26
	.word 0xdcb7e000  ! 1148: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xd0d689e0  ! 1149: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r8
	.word 0x8780204f  ! 1150: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x48, %r17
	.word 0xdcad2000  ! 1152: STBA_I	stba	%r14, [%r20 + 0x0000] %asi
	.word 0xdcdd6000  ! 1153: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r14
	.word 0xdcc5a000  ! 1154: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r14
	ta	T_CHANGE_PRIV	! macro
	.word 0xdcdd6000  ! 1156: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r14
	.word 0xdcbd6000  ! 1157: STDA_I	stda	%r14, [%r21 + 0x0000] %asi
	.word 0xdeacc400  ! 1158: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0x87802072  ! 1159: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r17
	.word 0xd8ad84a0  ! 1161: STBA_R	stba	%r12, [%r22 + %r0] 0x25
	mov	0x7d8, %r21
	mov	0x48, %r17
	.word 0xd0af4e80  ! 1164: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	mov	0x0, %r25
	.word 0xde8cc400  ! 1166: LDUBA_R	lduba	[%r19, %r0] 0x20, %r15
	.word 0xd8a74e40  ! 1167: STWA_R	stwa	%r12, [%r29 + %r0] 0x72
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd28c0400  ! 1169: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	mov	0x70, %r19
	.word 0xdef72000  ! 1171: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xdea7a000  ! 1172: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xdef72000  ! 1173: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xd2cf0e40  ! 1174: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r9
	.word 0xd2b7a000  ! 1175: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xd0848400  ! 1177: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r8
	mov	0x7d0, %r23
	.word 0x87802020  ! 1179: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8c4400  ! 1180: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	.word 0x87802025  ! 1181: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r16
	mov	0x38, %r27
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd48649e0  ! 1185: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r10
	.word 0xd4bcc400  ! 1186: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0xd6af0e60  ! 1187: STBA_R	stba	%r11, [%r28 + %r0] 0x73
	mov	0x30, %r25
	ta	T_CHANGE_HPRIV	! macro
	.word 0x8780204f  ! 1190: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 1191: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6cc4400  ! 1192: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	.word 0x8780204f  ! 1193: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc976000  ! 1194: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	.word 0xdcbf2000  ! 1195: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xd4cf0e40  ! 1196: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r10
	.word 0xd2bd44a0  ! 1197: STDA_R	stda	%r9, [%r21 + %r0] 0x25
	.word 0xdaf544a0  ! 1198: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	.word 0xd2b72000  ! 1199: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd48cc400  ! 1200: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	.word 0xd0bfe000  ! 1201: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd0d74e80  ! 1202: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r8
	.word 0xd09fa000  ! 1203: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	.word 0xd09fa000  ! 1204: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	.word 0xd2b6c9e0  ! 1205: STHA_R	stha	%r9, [%r27 + %r0] 0x4f
	.word 0xd6cfe000  ! 1206: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	mov	0x10, %r25
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd69fa000  ! 1209: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0xd6b4c400  ! 1210: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	mov	0x0, %r27
	mov	0x38, %r16
	.word 0xd6af6000  ! 1213: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x3c0, %r20
	.word 0xd6b7e000  ! 1215: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 1216: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6dee000  ! 1217: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r11
	.word 0xd6cea000  ! 1218: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	.word 0xd6b6e000  ! 1219: STHA_I	stha	%r11, [%r27 + 0x0000] %asi
	.word 0xd0cc0400  ! 1220: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xd0b6e000  ! 1221: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	.word 0xdcae89e0  ! 1222: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	mov	0x38, %r24
	.word 0xd4be2000  ! 1224: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	.word 0x8780204f  ! 1225: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e8, %r22
	.word 0x87802073  ! 1227: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r18
	.word 0xd4c7ce80  ! 1229: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r10
	.word 0xd2cfce40  ! 1230: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r9
	mov	0x7f8, %r23
	.word 0xd4afce80  ! 1232: STBA_R	stba	%r10, [%r31 + %r0] 0x74
	mov	0x3e8, %r20
	mov	0x7f8, %r21
	mov	0x28, %r26
	.word 0xd8d74e40  ! 1236: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r12
	mov	0x7d8, %r20
	.word 0xd4a7ce60  ! 1238: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	.word 0xd0f76000  ! 1239: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 1240: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1241: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r18
	.word 0xd097ce80  ! 1243: LDUHA_R	lduha	[%r31, %r0] 0x74, %r8
	mov	0x7e0, %r21
	.word 0xd287a000  ! 1245: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2af2000  ! 1246: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd2c7e000  ! 1247: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2bfe000  ! 1248: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd2bfe000  ! 1249: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xdcdf4e40  ! 1250: LDXA_R	ldxa	[%r29, %r0] 0x72, %r14
	.word 0x87802025  ! 1251: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r18
	.word 0xd2dc8400  ! 1253: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0xdc8f6000  ! 1254: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdc8fa000  ! 1255: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdcb7a000  ! 1256: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xd4b649e0  ! 1257: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	.word 0xd8cfa000  ! 1258: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	wr_tick_cmpr_1_9:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xd7, %g2
	or	%g4, 0xb3, %g4
	or	%g6, 0xdd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4874e80  ! 1260: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r10
	.word 0xdc8f2000  ! 1261: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0xd69689e0  ! 1262: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r11
	.word 0xdccf6000  ! 1263: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xd0ac4400  ! 1264: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	mov	0x20, %r17
	mov	0x10, %r16
	.word 0xd2ac8400  ! 1267: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xd8b504a0  ! 1268: STHA_R	stha	%r12, [%r20 + %r0] 0x25
	wr_tick_cmpr_1_10:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf7, %g2
	or	%g4, 0xa7, %g4
	or	%g6, 0xba, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4f7a000  ! 1270: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 1271: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1272: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd495e000  ! 1273: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r10
	ta	T_CHANGE_HPRIV	! macro
	mov	0x3d0, %r22
	.word 0xdeacc400  ! 1276: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0x87802073  ! 1277: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 1278: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r16
	mov	0x3c8, %r22
	.word 0xd28c2000  ! 1281: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1282: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88cc400  ! 1283: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	.word 0xd8c7e000  ! 1284: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0xd68584a0  ! 1285: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r11
	mov	0x10, %r16
	.word 0x87802072  ! 1287: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0df6000  ! 1288: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1289: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaac0400  ! 1290: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x38, %r17
	.word 0xd2df8e60  ! 1293: LDXA_R	ldxa	[%r30, %r0] 0x73, %r9
	.word 0x87802072  ! 1294: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8f40400  ! 1295: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xdecf0e40  ! 1296: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r15
	.word 0xd6a76000  ! 1297: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	mov	0x20, %r26
	.word 0xd2af4e40  ! 1299: STBA_R	stba	%r9, [%r29 + %r0] 0x72
	.word 0xdca7a000  ! 1300: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcbfce60  ! 1301: STDA_R	stda	%r14, [%r31 + %r0] 0x73
	mov	0x3c0, %r20
	.word 0x87802020  ! 1303: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1304: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e8, %r22
	.word 0xd084e000  ! 1306: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	.word 0xdab4c400  ! 1307: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	mov	0x20, %r19
	.word 0x87802025  ! 1309: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r26
	.word 0xd4c70e60  ! 1311: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r10
	.word 0xd8dda000  ! 1312: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r12
	.word 0xd6ccc400  ! 1313: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	mov	0x68, %r18
	.word 0xdeada000  ! 1315: STBA_I	stba	%r15, [%r22 + 0x0000] %asi
	.word 0xdea7ce80  ! 1316: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	mov	0x68, %r16
	mov	0x70, %r27
	.word 0x8780204f  ! 1319: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde844400  ! 1320: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	.word 0xda8c0400  ! 1321: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	.word 0xd6bc8400  ! 1322: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xd4bc2000  ! 1323: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0xd4ac6000  ! 1324: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	.word 0xd4842000  ! 1325: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	mov	0x48, %r18
	.word 0xdaf7ce60  ! 1327: STXA_R	stxa	%r13, [%r31 + %r0] 0x73
	.word 0xd4f4a000  ! 1328: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 1329: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc8f8e40  ! 1330: LDUBA_R	lduba	[%r30, %r0] 0x72, %r14
	.word 0xd0d4e000  ! 1331: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	.word 0xdc8cc400  ! 1332: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	mov	0x60, %r16
	.word 0xda9ca000  ! 1334: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	wr_tick_cmpr_1_11:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xee, %g2
	or	%g4, 0xb5, %g4
	or	%g6, 0xdb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 1336: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadda000  ! 1337: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r13
	.word 0xd49fce40  ! 1338: LDDA_R	ldda	[%r31, %r0] 0x72, %r10
	.word 0xd8f52000  ! 1339: STXA_I	stxa	%r12, [%r20 + 0x0000] %asi
	.word 0xdaf584a0  ! 1340: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	.word 0xd8b5e000  ! 1341: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	.word 0xd8978e40  ! 1342: LDUHA_R	lduha	[%r30, %r0] 0x72, %r12
	.word 0xdaf5a000  ! 1343: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 1344: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a609e0  ! 1345: STWA_R	stwa	%r12, [%r24 + %r0] 0x4f
	mov	0x38, %r27
	mov	0x50, %r19
	.word 0xdcc4a000  ! 1348: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r14
	.word 0xdc942000  ! 1349: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	.word 0xdea44400  ! 1350: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	mov	0x3e8, %r23
	mov	0x8, %r27
	.word 0xd0bca000  ! 1353: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0xd0ac6000  ! 1354: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0xde8649e0  ! 1355: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r15
	.word 0xdc94e000  ! 1356: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	mov	0x7e0, %r22
	.word 0xd2c78e40  ! 1358: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r9
	.word 0x87802025  ! 1359: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f8, %r21
	.word 0xd6aca000  ! 1361: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	mov	0x8, %r17
	.word 0x8780204f  ! 1363: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f4a000  ! 1364: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	mov	0x70, %r26
	.word 0xdea7ce40  ! 1366: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 1367: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf48400  ! 1368: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xd8b7e000  ! 1369: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 1370: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcdf0e80  ! 1371: LDXA_R	ldxa	[%r28, %r0] 0x74, %r14
	.word 0xdca40400  ! 1372: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xd2876000  ! 1373: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xd486c9e0  ! 1374: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r10
	mov	0x7c8, %r23
	.word 0xd696c9e0  ! 1376: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r11
	.word 0xd8f72000  ! 1377: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd4be89e0  ! 1378: STDA_R	stda	%r10, [%r26 + %r0] 0x4f
	.word 0xd0bf8e60  ! 1379: STDA_R	stda	%r8, [%r30 + %r0] 0x73
	.word 0x87802072  ! 1380: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 1381: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r18
	.word 0xdab44400  ! 1383: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0xd8b7ce40  ! 1384: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0xd6946000  ! 1385: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r11
	.word 0x87802025  ! 1386: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 1387: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r26
	mov	0x3e0, %r20
	.word 0xd4b544a0  ! 1390: STHA_R	stha	%r10, [%r21 + %r0] 0x25
	.word 0xdcb78e80  ! 1391: STHA_R	stha	%r14, [%r30 + %r0] 0x74
	.word 0xd6f70e80  ! 1392: STXA_R	stxa	%r11, [%r28 + %r0] 0x74
	.word 0xd4bf0e40  ! 1393: STDA_R	stda	%r10, [%r28 + %r0] 0x72
	.word 0xd68cc400  ! 1394: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	mov	0x8, %r18
	.word 0xd6f504a0  ! 1396: STXA_R	stxa	%r11, [%r20 + %r0] 0x25
	.word 0xdcd76000  ! 1397: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	mov	0x50, %r16
	.word 0x87802073  ! 1399: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r26
	mov	0x18, %r25
	.word 0xdcf44400  ! 1402: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xdc944400  ! 1403: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	.word 0xd8a78e40  ! 1404: STWA_R	stwa	%r12, [%r30 + %r0] 0x72
	mov	0x60, %r18
	.word 0xdeaf0e60  ! 1406: STBA_R	stba	%r15, [%r28 + %r0] 0x73
	.word 0xdc846000  ! 1407: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	.word 0xd2844400  ! 1408: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	.word 0xd2bce000  ! 1409: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xd8be49e0  ! 1410: STDA_R	stda	%r12, [%r25 + %r0] 0x4f
	mov	0x20, %r17
	mov	0x0, %r16
	.word 0xdc8ce000  ! 1413: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	.word 0xdebd84a0  ! 1414: STDA_R	stda	%r15, [%r22 + %r0] 0x25
	.word 0xd6f46000  ! 1415: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 1416: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb78e40  ! 1417: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xd4ad04a0  ! 1418: STBA_R	stba	%r10, [%r20 + %r0] 0x25
	.word 0xdef4c400  ! 1419: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xd0bfa000  ! 1420: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0xd097a000  ! 1422: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	.word 0xd0c76000  ! 1423: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0x87802073  ! 1424: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0c72000  ! 1425: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0af2000  ! 1426: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 1427: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8ae89e0  ! 1428: STBA_R	stba	%r12, [%r26 + %r0] 0x4f
	mov	0x40, %r26
	.word 0xd48f8e40  ! 1430: LDUBA_R	lduba	[%r30, %r0] 0x72, %r10
	wr_tick_cmpr_1_12:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe6, %g2
	or	%g4, 0x85, %g4
	or	%g6, 0xd6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3e0, %r20
	.word 0x87802073  ! 1433: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde9ee000  ! 1434: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r15
	.word 0x87802074  ! 1435: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde872000  ! 1436: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xd69c8400  ! 1437: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	.word 0x8780204f  ! 1438: WRASI_I	wr	%r0, 0x004f, %asi
	wr_tick_cmpr_1_13:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa6, %g2
	or	%g4, 0x93, %g4
	or	%g6, 0xe8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdebfce80  ! 1440: STDA_R	stda	%r15, [%r31 + %r0] 0x74
	.word 0xd0dfa000  ! 1441: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	mov	0x7e8, %r20
	.word 0xd09fe000  ! 1443: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	.word 0x87802073  ! 1444: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0bf6000  ! 1445: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xde8e49e0  ! 1446: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r15
	.word 0xde940400  ! 1447: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0xd09f6000  ! 1448: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	mov	0x50, %r27
	mov	0x3e0, %r21
	mov	0x40, %r17
	.word 0xdaac8400  ! 1452: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0xd4b7e000  ! 1453: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd49f2000  ! 1454: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd89f4e60  ! 1455: LDDA_R	ldda	[%r29, %r0] 0x73, %r12
	mov	0x3c0, %r21
	.word 0x8780204f  ! 1457: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd89c0400  ! 1458: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	.word 0xd2b7a000  ! 1459: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xda9c0400  ! 1460: LDDA_R	ldda	[%r16, %r0] 0x20, %r13
	.word 0xd4cf2000  ! 1461: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0x87802074  ! 1462: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b72000  ! 1463: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd2cd44a0  ! 1464: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r9
	mov	0x40, %r16
	.word 0xd0cf2000  ! 1466: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	mov	0x48, %r17
	.word 0xd0f76000  ! 1468: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0f7a000  ! 1469: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd69c4400  ! 1470: LDDA_R	ldda	[%r17, %r0] 0x20, %r11
	.word 0x87802074  ! 1471: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4d40400  ! 1472: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	.word 0xd6ad84a0  ! 1473: STBA_R	stba	%r11, [%r22 + %r0] 0x25
	.word 0xd88fce80  ! 1474: LDUBA_R	lduba	[%r31, %r0] 0x74, %r12
	mov	0x18, %r16
	.word 0xd88ce000  ! 1476: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	.word 0xd8b4a000  ! 1477: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	mov	0x28, %r27
	mov	0x7f8, %r21
	.word 0xd8f42000  ! 1480: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8dce000  ! 1481: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	.word 0x87802072  ! 1482: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd88d6000  ! 1483: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r12
	mov	0x10, %r19
	.word 0xd8c5e000  ! 1485: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r12
	.word 0x87802025  ! 1486: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbf0e40  ! 1487: STDA_R	stda	%r14, [%r28 + %r0] 0x72
	mov	0x30, %r19
	.word 0xd09ca000  ! 1489: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	mov	0x28, %r16
	.word 0xd2cf8e80  ! 1491: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r9
	.word 0xd0b4e000  ! 1492: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 1493: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1494: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8bf4e80  ! 1495: STDA_R	stda	%r12, [%r29 + %r0] 0x74
	.word 0xd2bfce60  ! 1496: STDA_R	stda	%r9, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 1497: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r25
	.word 0x87802025  ! 1499: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bd44a0  ! 1500: STDA_R	stda	%r12, [%r21 + %r0] 0x25
	.word 0xda9649e0  ! 1501: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r13
	mov	0x48, %r18
	.word 0x87802072  ! 1503: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 1504: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 1505: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebfce80  ! 1506: STDA_R	stda	%r15, [%r31 + %r0] 0x74
	mov	0x3c0, %r23
	.word 0xdccc6000  ! 1508: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	.word 0xdaafce80  ! 1509: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	.word 0xd8bca000  ! 1510: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd8bce000  ! 1511: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd8a4a000  ! 1512: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	mov	0x20, %r27
	.word 0xdcf7ce60  ! 1514: STXA_R	stxa	%r14, [%r31 + %r0] 0x73
	.word 0xd0ac8400  ! 1515: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xd0a46000  ! 1516: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0d4a000  ! 1517: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	.word 0x87802074  ! 1518: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdecc0400  ! 1519: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r15
	.word 0xd2a48400  ! 1520: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	wr_tick_cmpr_1_14:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf4, %g2
	or	%g4, 0xd7, %g4
	or	%g6, 0x9b, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xde9c4400  ! 1522: LDDA_R	ldda	[%r17, %r0] 0x20, %r15
	.word 0x87802020  ! 1523: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9c8400  ! 1524: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	.word 0xd0bde000  ! 1525: STDA_I	stda	%r8, [%r23 + 0x0000] %asi
	mov	0x48, %r17
	mov	0x38, %r18
	.word 0x87802025  ! 1528: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f44400  ! 1529: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0xd4cfce80  ! 1530: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r10
	.word 0xd6c5a000  ! 1531: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r11
	.word 0xd29c0400  ! 1532: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	mov	0x40, %r27
	.word 0xd0b52000  ! 1534: STHA_I	stha	%r8, [%r20 + 0x0000] %asi
	.word 0xd2d6c9e0  ! 1535: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r9
	.word 0xd2c7ce40  ! 1536: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r9
	.word 0xde85e000  ! 1537: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r15
	.word 0xdebd6000  ! 1538: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	.word 0xdca70e40  ! 1539: STWA_R	stwa	%r14, [%r28 + %r0] 0x72
	.word 0x87802072  ! 1540: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r17
	mov	0x18, %r16
	mov	0x7c8, %r20
	mov	0x48, %r19
	.word 0xd6cf6000  ! 1545: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	mov	0x7c0, %r23
	.word 0xd4a7ce40  ! 1547: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	.word 0x87802073  ! 1548: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdccca000  ! 1549: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	.word 0xdc8ce000  ! 1550: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	.word 0xdc94a000  ! 1551: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xd0bd44a0  ! 1552: STDA_R	stda	%r8, [%r21 + %r0] 0x25
	.word 0xd0dc6000  ! 1553: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	.word 0xdcbd44a0  ! 1554: STDA_R	stda	%r14, [%r21 + %r0] 0x25
	.word 0xd09c6000  ! 1555: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r8
	.word 0xd0aca000  ! 1556: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 1557: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r18
	mov	0x3f8, %r22
	.word 0xd0cc6000  ! 1560: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	.word 0xdcaf0e40  ! 1561: STBA_R	stba	%r14, [%r28 + %r0] 0x72
	.word 0xd6ac4400  ! 1562: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xdad40400  ! 1563: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	mov	0x50, %r18
	.word 0x87802073  ! 1565: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6df6000  ! 1566: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0xdadc4400  ! 1567: LDXA_R	ldxa	[%r17, %r0] 0x20, %r13
	.word 0xd0a76000  ! 1568: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0afce80  ! 1569: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	.word 0xd4a72000  ! 1570: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4afa000  ! 1571: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 1572: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd8f5c4a0  ! 1574: STXA_R	stxa	%r12, [%r23 + %r0] 0x25
	.word 0x87802073  ! 1575: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaaf2000  ! 1576: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xd0f7ce40  ! 1577: STXA_R	stxa	%r8, [%r31 + %r0] 0x72
	.word 0xd2a5c4a0  ! 1578: STWA_R	stwa	%r9, [%r23 + %r0] 0x25
	.word 0xde94c400  ! 1579: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	.word 0xded76000  ! 1580: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	mov	0x7e0, %r20
	.word 0xdef76000  ! 1582: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xd2a74e60  ! 1583: STWA_R	stwa	%r9, [%r29 + %r0] 0x73
	.word 0xdeb7e000  ! 1584: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xd68d84a0  ! 1585: LDUBA_R	lduba	[%r22, %r0] 0x25, %r11
	.word 0xd2a76000  ! 1586: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd2c74e60  ! 1587: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r9
	.word 0xd6c76000  ! 1588: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6afe000  ! 1589: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd0944400  ! 1590: LDUHA_R	lduha	[%r17, %r0] 0x20, %r8
	.word 0xde87e000  ! 1591: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdca40400  ! 1592: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xdeb76000  ! 1593: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xd8d7ce80  ! 1594: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r12
	.word 0xd4bc4400  ! 1595: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0xd4df8e80  ! 1596: LDXA_R	ldxa	[%r30, %r0] 0x74, %r10
	.word 0x8780204f  ! 1597: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r16
	.word 0xd8f7ce40  ! 1599: STXA_R	stxa	%r12, [%r31 + %r0] 0x72
	.word 0xd0ace000  ! 1600: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0xd0bce000  ! 1601: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 1602: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde8d04a0  ! 1603: LDUBA_R	lduba	[%r20, %r0] 0x25, %r15
	.word 0xdec70e40  ! 1604: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r15
	.word 0xd6bfa000  ! 1605: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 1606: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r26
	.word 0xd6b7e000  ! 1608: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd69fe000  ! 1609: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	.word 0xd6f76000  ! 1610: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd4b78e60  ! 1611: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	.word 0xdcb7e000  ! 1612: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xd494c400  ! 1613: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	.word 0xd0c7a000  ! 1614: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	mov	0x50, %r18
	.word 0xd0d7a000  ! 1616: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0xd0bf6000  ! 1617: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xdcb40400  ! 1618: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xd88f4e80  ! 1619: LDUBA_R	lduba	[%r29, %r0] 0x74, %r12
	.word 0xdc8c0400  ! 1620: LDUBA_R	lduba	[%r16, %r0] 0x20, %r14
	.word 0xd2d76000  ! 1621: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0x87802025  ! 1622: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a78e60  ! 1623: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	mov	0x3f8, %r23
	.word 0x87802020  ! 1625: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r18
	.word 0xd8dfe000  ! 1627: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xd88f6000  ! 1628: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0x87802073  ! 1629: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda9e09e0  ! 1630: LDDA_R	ldda	[%r24, %r0] 0x4f, %r13
	.word 0x87802074  ! 1631: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb76000  ! 1632: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xd0bc0400  ! 1633: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0xd4dfce40  ! 1634: LDXA_R	ldxa	[%r31, %r0] 0x72, %r10
	.word 0xd49d04a0  ! 1635: LDDA_R	ldda	[%r20, %r0] 0x25, %r10
	.word 0xd0876000  ! 1636: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	.word 0x87802074  ! 1637: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd08ca000  ! 1638: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xd09ce000  ! 1639: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r8
	mov	0x7d0, %r20
	.word 0x87802020  ! 1641: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1642: WRASI_I	wr	%r0, 0x004f, %asi
	wr_tick_cmpr_1_15:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xdd, %g2
	or	%g4, 0x86, %g4
	or	%g6, 0x98, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x8, %r19
	.word 0xdec70e80  ! 1645: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r15
	.word 0xd89f0e80  ! 1646: LDDA_R	ldda	[%r28, %r0] 0x74, %r12
	mov	0x28, %r27
	mov	0x3e8, %r22
	.word 0xd4a7a000  ! 1649: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xde8d44a0  ! 1650: LDUBA_R	lduba	[%r21, %r0] 0x25, %r15
	.word 0xd0bf0e40  ! 1651: STDA_R	stda	%r8, [%r28 + %r0] 0x72
	.word 0xdea5c4a0  ! 1652: STWA_R	stwa	%r15, [%r23 + %r0] 0x25
	.word 0xd496c9e0  ! 1653: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r10
	.word 0xd4af6000  ! 1654: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd89ec9e0  ! 1655: LDDA_R	ldda	[%r27, %r0] 0x4f, %r12
	.word 0xda87e000  ! 1656: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdab76000  ! 1658: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdab72000  ! 1659: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdabfa000  ! 1660: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdab7e000  ! 1661: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdc8d44a0  ! 1663: LDUBA_R	lduba	[%r21, %r0] 0x25, %r14
	.word 0xd08e49e0  ! 1664: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r8
	.word 0xdaad04a0  ! 1665: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	mov	0x18, %r19
	.word 0xde872000  ! 1667: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xdecfa000  ! 1668: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xdef7a000  ! 1669: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdea72000  ! 1670: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xdec44400  ! 1671: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0xdeb44400  ! 1672: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0xdedfce40  ! 1673: LDXA_R	ldxa	[%r31, %r0] 0x72, %r15
	mov	0x3d8, %r20
	.word 0xdabfa000  ! 1675: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdadfe000  ! 1676: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0xdaaf6000  ! 1677: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0xdcdc8400  ! 1679: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	.word 0xd8dc8400  ! 1680: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	mov	0x0, %r25
	.word 0xd0dd44a0  ! 1682: LDXA_R	ldxa	[%r21, %r0] 0x25, %r8
	.word 0xd6cf4e60  ! 1683: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r11
	.word 0xd0b504a0  ! 1684: STHA_R	stha	%r8, [%r20 + %r0] 0x25
	.word 0xdecec9e0  ! 1685: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r15
	.word 0xd09fe000  ! 1686: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	.word 0xd0b44400  ! 1687: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xd2b5c4a0  ! 1688: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	mov	0x78, %r18
	.word 0xdadc8400  ! 1690: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	mov	0x3f8, %r23
	.word 0xd8878e40  ! 1692: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r12
	.word 0xd88f8e80  ! 1693: LDUBA_R	lduba	[%r30, %r0] 0x74, %r12
	.word 0xd0cfe000  ! 1694: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xd8cc8400  ! 1695: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	mov	0x70, %r16
	mov	0x7c0, %r22
	.word 0xdc9fa000  ! 1698: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 1699: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd4d4c400  ! 1701: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0xdccd84a0  ! 1702: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r14
	mov	0x30, %r19
	.word 0xdcbca000  ! 1704: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdcbc2000  ! 1705: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xdcf46000  ! 1706: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdcc42000  ! 1707: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r14
	.word 0xd08c4400  ! 1708: LDUBA_R	lduba	[%r17, %r0] 0x20, %r8
	mov	0x68, %r19
	mov	0x28, %r19
	.word 0xdabca000  ! 1711: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	mov	0x28, %r17
	.word 0xda9c6000  ! 1713: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xdaac6000  ! 1714: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	.word 0xdcb78e60  ! 1715: STHA_R	stha	%r14, [%r30 + %r0] 0x73
	.word 0x87802073  ! 1716: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd88f0e80  ! 1717: LDUBA_R	lduba	[%r28, %r0] 0x74, %r12
	wr_tick_cmpr_1_16:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x9e, %g2
	or	%g4, 0xb4, %g4
	or	%g6, 0x9e, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdccdc4a0  ! 1719: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r14
	.word 0xd0cca000  ! 1720: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	.word 0xd2c7ce60  ! 1721: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r9
	mov	0x78, %r24
	.word 0x87802073  ! 1723: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r24
	mov	0x20, %r26
	.word 0xdcdf0e40  ! 1726: LDXA_R	ldxa	[%r28, %r0] 0x72, %r14
	.word 0xd6aee000  ! 1727: STBA_I	stba	%r11, [%r27 + 0x0000] %asi
	.word 0xd8bf4e40  ! 1728: STDA_R	stda	%r12, [%r29 + %r0] 0x72
	mov	0x40, %r17
	.word 0x87802020  ! 1730: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde97ce60  ! 1731: LDUHA_R	lduha	[%r31, %r0] 0x73, %r15
	mov	0x28, %r16
	.word 0xd2c56000  ! 1733: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r9
	.word 0xd8a504a0  ! 1734: STWA_R	stwa	%r12, [%r20 + %r0] 0x25
	mov	0x30, %r24
	mov	0x78, %r26
	.word 0xdca56000  ! 1737: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdcbda000  ! 1739: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	.word 0x87802025  ! 1740: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1741: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb66000  ! 1742: STHA_I	stha	%r14, [%r25 + 0x0000] %asi
	mov	0x7e0, %r23
	mov	0x18, %r19
	.word 0xdeb40400  ! 1745: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0xd0a62000  ! 1746: STWA_I	stwa	%r8, [%r24 + 0x0000] %asi
	mov	0x20, %r16
	.word 0xd0cee000  ! 1748: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r8
	mov	0x20, %r27
	mov	0x78, %r24
	mov	0x7f0, %r23
	.word 0xd6d504a0  ! 1752: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r11
	.word 0x87802073  ! 1753: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 1754: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r26
	mov	0x7e8, %r20
	.word 0xdaac8400  ! 1757: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0x87802073  ! 1758: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd09f0e80  ! 1759: LDDA_R	ldda	[%r28, %r0] 0x74, %r8
	.word 0xd4a7e000  ! 1760: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4dfe000  ! 1761: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1762: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c48400  ! 1763: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	.word 0x87802073  ! 1764: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8c72000  ! 1765: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	wr_tick_cmpr_1_17:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc0, %g2
	or	%g4, 0xa4, %g4
	or	%g6, 0xe0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x70, %r27
	.word 0xd8b7e000  ! 1768: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xda9544a0  ! 1770: LDUHA_R	lduha	[%r21, %r0] 0x25, %r13
	mov	0x7c0, %r22
	mov	0x18, %r26
	mov	0x18, %r18
	mov	0x0, %r17
	.word 0xdcdec9e0  ! 1775: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r14
	.word 0xd4d7a000  ! 1776: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	.word 0xdcbdc4a0  ! 1777: STDA_R	stda	%r14, [%r23 + %r0] 0x25
	.word 0xdc872000  ! 1778: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xded7ce60  ! 1779: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r15
	mov	0x20, %r24
	.word 0xde9f0e40  ! 1781: LDDA_R	ldda	[%r28, %r0] 0x72, %r15
	.word 0xd6d76000  ! 1782: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	.word 0xd287ce80  ! 1783: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r9
	mov	0x70, %r26
	.word 0xd0972000  ! 1785: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0x87802072  ! 1786: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r17
	.word 0xd6b44400  ! 1788: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	mov	0x7c0, %r20
	.word 0xdcae6000  ! 1790: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	.word 0xd2bf4e40  ! 1791: STDA_R	stda	%r9, [%r29 + %r0] 0x72
	.word 0xd4a70e60  ! 1792: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	mov	0x48, %r27
	.word 0xd2bee000  ! 1794: STDA_I	stda	%r9, [%r27 + 0x0000] %asi
	.word 0xd2ae2000  ! 1795: STBA_I	stba	%r9, [%r24 + 0x0000] %asi
	.word 0x8780204f  ! 1796: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r17
	.word 0x87802020  ! 1798: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccfce40  ! 1799: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r14
	mov	0x68, %r27
	.word 0xd0a6e000  ! 1801: STWA_I	stwa	%r8, [%r27 + 0x0000] %asi
	.word 0xd8970e80  ! 1802: LDUHA_R	lduha	[%r28, %r0] 0x74, %r12
	.word 0xd29c0400  ! 1803: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	.word 0xd29f4e60  ! 1804: LDDA_R	ldda	[%r29, %r0] 0x73, %r9
	.word 0x87802073  ! 1805: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdad7a000  ! 1806: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0xd2974e60  ! 1807: LDUHA_R	lduha	[%r29, %r0] 0x73, %r9
	.word 0xd2a44400  ! 1808: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xd0be49e0  ! 1809: STDA_R	stda	%r8, [%r25 + %r0] 0x4f
	.word 0xd2a7e000  ! 1810: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xd8d5c4a0  ! 1811: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r12
	.word 0xdc9fe000  ! 1812: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xd487ce80  ! 1813: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r10
	.word 0xdea72000  ! 1814: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xd8c7ce40  ! 1816: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r12
	.word 0xded7e000  ! 1817: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0x87802020  ! 1818: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1819: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0bd84a0  ! 1820: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0xda966000  ! 1821: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r13
	.word 0xd4a544a0  ! 1822: STWA_R	stwa	%r10, [%r21 + %r0] 0x25
	mov	0x7c0, %r23
	.word 0xd0b5c4a0  ! 1824: STHA_R	stha	%r8, [%r23 + %r0] 0x25
	.word 0x87802074  ! 1825: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabf2000  ! 1826: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	mov	0x20, %r17
	.word 0xdac76000  ! 1828: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0xd28e09e0  ! 1829: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r9
	.word 0x87802020  ! 1830: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c5e000  ! 1831: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r10
	.word 0xd48de000  ! 1832: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r10
	.word 0x87802074  ! 1833: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a7e000  ! 1834: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xdab5c4a0  ! 1835: STHA_R	stha	%r13, [%r23 + %r0] 0x25
	.word 0xde870e60  ! 1836: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r15
	mov	0x7f8, %r21
	.word 0xd6f72000  ! 1838: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	mov	0x28, %r17
	.word 0xd6bf6000  ! 1840: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd4bd04a0  ! 1841: STDA_R	stda	%r10, [%r20 + %r0] 0x25
	.word 0xd0b7a000  ! 1842: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd89fce40  ! 1843: LDDA_R	ldda	[%r31, %r0] 0x72, %r12
	.word 0x87802020  ! 1844: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6c4c400  ! 1846: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r11
	mov	0x60, %r24
	.word 0xd8f7a000  ! 1848: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8bf6000  ! 1849: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd69cc400  ! 1850: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	.word 0xd6bc4400  ! 1851: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	.word 0xd2f40400  ! 1852: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xdea7e000  ! 1853: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	mov	0x3f0, %r23
	.word 0x8780204f  ! 1855: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf74e40  ! 1856: STXA_R	stxa	%r13, [%r29 + %r0] 0x72
	.word 0xdaaf2000  ! 1857: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	mov	0x58, %r27
	mov	0x7c0, %r20
	.word 0xda9fe000  ! 1860: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xd6bf8e60  ! 1861: STDA_R	stda	%r11, [%r30 + %r0] 0x73
	.word 0x87802072  ! 1862: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cc4400  ! 1863: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r10
	.word 0x87802074  ! 1864: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f504a0  ! 1865: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	mov	0x78, %r18
	mov	0x60, %r18
	.word 0xdaf72000  ! 1868: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 1869: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda97a000  ! 1870: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xdabfe000  ! 1871: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xdad4c400  ! 1872: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	mov	0x3c8, %r22
	.word 0x87802025  ! 1874: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd68ee000  ! 1875: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r11
	.word 0xd6d62000  ! 1876: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r11
	.word 0xd6f66000  ! 1877: STXA_I	stxa	%r11, [%r25 + 0x0000] %asi
	.word 0xd6b66000  ! 1878: STHA_I	stha	%r11, [%r25 + 0x0000] %asi
	mov	0x68, %r26
	.word 0xd6cec9e0  ! 1880: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r11
	.word 0xd0d70e40  ! 1881: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r8
	.word 0xd2ae6000  ! 1882: STBA_I	stba	%r9, [%r25 + 0x0000] %asi
	.word 0xd29f0e60  ! 1883: LDDA_R	ldda	[%r28, %r0] 0x73, %r9
	mov	0x38, %r19
	.word 0xd6ce09e0  ! 1885: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r11
	.word 0xd6b584a0  ! 1886: STHA_R	stha	%r11, [%r22 + %r0] 0x25
	.word 0xd6a6a000  ! 1887: STWA_I	stwa	%r11, [%r26 + 0x0000] %asi
	.word 0x87802025  ! 1888: WRASI_I	wr	%r0, 0x0025, %asi
	wr_tick_cmpr_1_18:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf5, %g2
	or	%g4, 0xd1, %g4
	or	%g6, 0xab, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd484c400  ! 1890: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	mov	0x78, %r24
	.word 0xdcbe49e0  ! 1892: STDA_R	stda	%r14, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 1893: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f689e0  ! 1894: STXA_R	stxa	%r10, [%r26 + %r0] 0x4f
	.word 0xdef4e000  ! 1895: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	mov	0x10, %r25
	.word 0xdadf4e60  ! 1897: LDXA_R	ldxa	[%r29, %r0] 0x73, %r13
	.word 0x87802020  ! 1898: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccfa000  ! 1899: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xdcc7e000  ! 1900: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcafa000  ! 1901: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xd6a40400  ! 1902: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	mov	0x68, %r19
	.word 0xd4afe000  ! 1904: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	mov	0x48, %r18
	.word 0xd6d7ce80  ! 1906: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r11
	.word 0x87802020  ! 1907: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b66000  ! 1908: STHA_I	stha	%r12, [%r25 + 0x0000] %asi
	.word 0xd8be6000  ! 1909: STDA_I	stda	%r12, [%r25 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdebfce40  ! 1911: STDA_R	stda	%r15, [%r31 + %r0] 0x72
	mov	0x3f8, %r23
	mov	0x3f0, %r22
	.word 0xd2be6000  ! 1914: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	.word 0xd2962000  ! 1915: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r9
	.word 0xd2ae2000  ! 1916: STBA_I	stba	%r9, [%r24 + 0x0000] %asi
	.word 0xdab4c400  ! 1917: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd4d62000  ! 1919: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r10
	.word 0xd49ee000  ! 1920: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r10
	mov	0x18, %r19
	.word 0x87802074  ! 1922: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c8, %r22
	.word 0xd497e000  ! 1924: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	.word 0xd4f7a000  ! 1925: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	wr_tick_cmpr_1_19:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe1, %g2
	or	%g4, 0x99, %g4
	or	%g6, 0xbc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 1927: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4aec9e0  ! 1928: STBA_R	stba	%r10, [%r27 + %r0] 0x4f
	.word 0x87802073  ! 1929: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 1930: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 1931: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r26
	mov	0x38, %r25
	mov	0x60, %r18
	.word 0xd4a609e0  ! 1935: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	.word 0xdcb44400  ! 1936: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0x87802025  ! 1937: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c8, %r23
	mov	0x7d8, %r23
	.word 0xd8df2000  ! 1940: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xd0c74e60  ! 1941: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r8
	.word 0xdcb48400  ! 1942: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xdc8fa000  ! 1943: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0x87802020  ! 1944: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r22
	.word 0xdea40400  ! 1946: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xd4c5a000  ! 1947: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r10
	mov	0x3d0, %r20
	.word 0xd6bf8e40  ! 1949: STDA_R	stda	%r11, [%r30 + %r0] 0x72
	.word 0xda85e000  ! 1950: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	.word 0xd8a48400  ! 1951: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	.word 0x87802074  ! 1952: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabfce60  ! 1953: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 1954: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c8, %r20
	.word 0x87802020  ! 1956: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbf8e80  ! 1957: STDA_R	stda	%r14, [%r30 + %r0] 0x74
	mov	0x70, %r25
	.word 0xdedf8e40  ! 1959: LDXA_R	ldxa	[%r30, %r0] 0x72, %r15
	.word 0x87802020  ! 1960: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b70e80  ! 1961: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	.word 0xdead04a0  ! 1962: STBA_R	stba	%r15, [%r20 + %r0] 0x25
	.word 0xd4a72000  ! 1963: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd0be09e0  ! 1964: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0x87802074  ! 1965: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a70e80  ! 1966: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0xd8bdc4a0  ! 1967: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	.word 0xd88dc4a0  ! 1968: LDUBA_R	lduba	[%r23, %r0] 0x25, %r12
	.word 0xdabfe000  ! 1969: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	mov	0x40, %r19
	.word 0xda8fe000  ! 1971: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	mov	0x3e0, %r22
	.word 0xdcf74e60  ! 1973: STXA_R	stxa	%r14, [%r29 + %r0] 0x73
	mov	0x18, %r26
	mov	0x30, %r24
	.word 0xdaafe000  ! 1976: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xda876000  ! 1977: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0xda8fa000  ! 1978: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xd6cf4e60  ! 1979: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r11
	.word 0x8780204f  ! 1980: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e8, %r20
	.word 0xdc8f4e40  ! 1982: LDUBA_R	lduba	[%r29, %r0] 0x72, %r14
	.word 0x87802020  ! 1983: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r23
	mov	0x78, %r27
	mov	0x7d8, %r20
	mov	0x7e0, %r21
	mov	0x18, %r19
	.word 0xdab40400  ! 1989: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xdad76000  ! 1990: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0xde97ce40  ! 1991: LDUHA_R	lduha	[%r31, %r0] 0x72, %r15
	.word 0xd8af0e40  ! 1992: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	.word 0xd0f74e80  ! 1993: STXA_R	stxa	%r8, [%r29 + %r0] 0x74
	.word 0xd4a584a0  ! 1994: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	.word 0x87802072  ! 1995: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1996: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a584a0  ! 1997: STWA_R	stwa	%r12, [%r22 + %r0] 0x25
	mov	0x7c8, %r20
	mov	0x70, %r26
	mov	0x50, %r17
	mov	0x7d8, %r21
	.word 0xdccc4400  ! 2002: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r14
	.word 0xd8f76000  ! 2003: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8d7a000  ! 2004: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0xd8876000  ! 2005: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8f72000  ! 2006: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd6b44400  ! 2007: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	mov	0x10, %r19
	.word 0xd89fce80  ! 2009: LDDA_R	ldda	[%r31, %r0] 0x74, %r12
	.word 0xdecfa000  ! 2010: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xd0970e40  ! 2011: LDUHA_R	lduha	[%r28, %r0] 0x72, %r8
	.word 0xdebc0400  ! 2012: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	ta	T_CHANGE_PRIV	! macro
	.word 0xd0c6c9e0  ! 2014: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r8
	.word 0xdcf76000  ! 2015: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x50, %r26
	.word 0xdcb72000  ! 2017: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xdc9f6000  ! 2018: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	mov	0x8, %r19
	.word 0xdc9f2000  ! 2020: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xdea40400  ! 2021: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xd6f78e80  ! 2022: STXA_R	stxa	%r11, [%r30 + %r0] 0x74
	.word 0xded78e60  ! 2023: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r15
	.word 0xd6d7e000  ! 2024: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	.word 0xd2d40400  ! 2025: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	.word 0x87802073  ! 2026: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b48400  ! 2027: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xda8e09e0  ! 2028: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r13
	.word 0xdacfa000  ! 2029: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xda87e000  ! 2030: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0xdcd78e40  ! 2031: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r14
	.word 0x87802073  ! 2032: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 2033: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd08fce40  ! 2034: LDUBA_R	lduba	[%r31, %r0] 0x72, %r8
	.word 0xd0f4a000  ! 2035: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 2036: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0ae2000  ! 2037: STBA_I	stba	%r8, [%r24 + 0x0000] %asi
	.word 0xd0ae2000  ! 2038: STBA_I	stba	%r8, [%r24 + 0x0000] %asi
	.word 0xd0966000  ! 2039: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r8
	mov	0x3d0, %r21
	.word 0xd096a000  ! 2041: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r8
	.word 0x87802020  ! 2042: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08ee000  ! 2043: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r8
	.word 0xd086a000  ! 2044: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r8
	mov	0x60, %r17
	.word 0x87802072  ! 2046: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc9e49e0  ! 2047: LDDA_R	ldda	[%r25, %r0] 0x4f, %r14
	.word 0xd89d84a0  ! 2048: LDDA_R	ldda	[%r22, %r0] 0x25, %r12
	mov	0x0, %r26
	.word 0xd0ac4400  ! 2050: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	mov	0x78, %r26
	.word 0xd2a48400  ! 2052: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0x87802020  ! 2053: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0df4e60  ! 2054: LDXA_R	ldxa	[%r29, %r0] 0x73, %r8
	.word 0xdebf8e60  ! 2055: STDA_R	stda	%r15, [%r30 + %r0] 0x73
	.word 0xdadca000  ! 2056: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0xd0d609e0  ! 2057: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r8
	.word 0xd0c48400  ! 2058: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r8
	.word 0xd6a40400  ! 2059: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0x87802073  ! 2060: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4a7e000  ! 2061: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	mov	0x38, %r27
	mov	0x3f0, %r20
	.word 0xd4d70e40  ! 2064: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r10
	mov	0x7e8, %r23
	.word 0xd2bfa000  ! 2066: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 2067: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2d46000  ! 2068: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	.word 0xd2bca000  ! 2069: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	.word 0xd6f689e0  ! 2070: STXA_R	stxa	%r11, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 2071: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdacf6000  ! 2072: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xd0a544a0  ! 2073: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	.word 0xd8bf6000  ! 2074: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd8cfe000  ! 2075: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xdcbcc400  ! 2076: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xdea7e000  ! 2077: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	mov	0x7f0, %r22
	mov	0x50, %r26
	.word 0xdaa44400  ! 2080: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0xd2a76000  ! 2081: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xd2df2000  ! 2083: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xdaa74e60  ! 2084: STWA_R	stwa	%r13, [%r29 + %r0] 0x73
	mov	0x48, %r26
	.word 0xd88fe000  ! 2086: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	mov	0x78, %r24
	.word 0xdea4c400  ! 2088: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	.word 0xdc97e000  ! 2089: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	mov	0x7c0, %r21
	.word 0xdc87e000  ! 2091: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xdccf2000  ! 2092: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2093: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b689e0  ! 2094: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 2095: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r18
	.word 0xded72000  ! 2097: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xd6874e80  ! 2098: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r11
	.word 0xdcbfa000  ! 2099: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	mov	0x60, %r26
	.word 0x87802074  ! 2101: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r18
	.word 0xdca6e000  ! 2103: STWA_I	stwa	%r14, [%r27 + 0x0000] %asi
	.word 0xdcb62000  ! 2104: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	.word 0xd09d84a0  ! 2105: LDDA_R	ldda	[%r22, %r0] 0x25, %r8
	.word 0xda870e40  ! 2106: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r13
	mov	0x70, %r18
	mov	0x38, %r26
	.word 0xdebe2000  ! 2109: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	.word 0xdec66000  ! 2110: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r15
	.word 0xd4af0e60  ! 2111: STBA_R	stba	%r10, [%r28 + %r0] 0x73
	.word 0xd0a40400  ! 2112: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0xd4cee000  ! 2113: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r10
	.word 0xd4a6e000  ! 2114: STWA_I	stwa	%r10, [%r27 + 0x0000] %asi
	.word 0xd2bf0e60  ! 2115: STDA_R	stda	%r9, [%r28 + %r0] 0x73
	.word 0xd2f70e40  ! 2116: STXA_R	stxa	%r9, [%r28 + %r0] 0x72
	.word 0xd2a584a0  ! 2117: STWA_R	stwa	%r9, [%r22 + %r0] 0x25
	.word 0xd4a7ce60  ! 2118: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	mov	0x38, %r24
	.word 0xd0b609e0  ! 2120: STHA_R	stha	%r8, [%r24 + %r0] 0x4f
	.word 0xd2f6e000  ! 2121: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	mov	0x7f0, %r21
	mov	0x48, %r17
	mov	0x20, %r19
	.word 0xd2f66000  ! 2125: STXA_I	stxa	%r9, [%r25 + 0x0000] %asi
	.word 0xd29ee000  ! 2126: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r9
	.word 0xdedc0400  ! 2127: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	.word 0x87802020  ! 2128: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r18
	mov	0x58, %r27
	.word 0xd2f5c4a0  ! 2131: STXA_R	stxa	%r9, [%r23 + %r0] 0x25
	.word 0xd89dc4a0  ! 2132: LDDA_R	ldda	[%r23, %r0] 0x25, %r12
	.word 0xd68cc400  ! 2133: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	mov	0x7d8, %r22
	.word 0xdef5a000  ! 2135: STXA_I	stxa	%r15, [%r22 + 0x0000] %asi
	.word 0xd2f544a0  ! 2136: STXA_R	stxa	%r9, [%r21 + %r0] 0x25
	.word 0xdcade000  ! 2137: STBA_I	stba	%r14, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 2138: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc87e000  ! 2139: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2140: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r16
	.word 0xdcbf6000  ! 2142: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xd4d40400  ! 2143: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	.word 0xda97e000  ! 2144: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	.word 0xd8878e60  ! 2145: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r12
	.word 0x87802025  ! 2146: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8c7ce60  ! 2147: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r12
	mov	0x58, %r16
	.word 0xd68de000  ! 2149: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r11
	.word 0xdedc4400  ! 2150: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	.word 0xd0ccc400  ! 2151: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	.word 0xd2a56000  ! 2152: STWA_I	stwa	%r9, [%r21 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0xd29d2000  ! 2154: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r9
	.word 0xdadf0e60  ! 2155: LDXA_R	ldxa	[%r28, %r0] 0x73, %r13
	.word 0xdac689e0  ! 2156: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r13
	.word 0xd8b5a000  ! 2157: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	.word 0xd8dde000  ! 2158: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r12
	mov	0x50, %r17
	.word 0xdcdc8400  ! 2160: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	mov	0x78, %r25
	.word 0xd2f48400  ! 2162: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0xd4dd2000  ! 2163: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r10
	mov	0x58, %r24
	.word 0x87802073  ! 2165: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4be2000  ! 2166: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	mov	0x18, %r17
	.word 0x8780204f  ! 2168: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c8, %r21
	mov	0x7f8, %r20
	mov	0x50, %r17
	mov	0x48, %r19
	mov	0x3d8, %r21
	.word 0x87802072  ! 2174: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cca000  ! 2175: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r10
	.word 0xd4bca000  ! 2176: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0xd4bc6000  ! 2177: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xd4dce000  ! 2178: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	.word 0xd4f4e000  ! 2179: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0xdab7ce60  ! 2180: STHA_R	stha	%r13, [%r31 + %r0] 0x73
	.word 0xdcb78e40  ! 2181: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	mov	0x60, %r17
	mov	0x3e0, %r20
	.word 0xd6aca000  ! 2184: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xded7ce80  ! 2185: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r15
	.word 0xde9609e0  ! 2186: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r15
	.word 0x87802020  ! 2187: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r25
	.word 0xdaa7ce80  ! 2189: STWA_R	stwa	%r13, [%r31 + %r0] 0x74
	.word 0xd6be09e0  ! 2190: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	.word 0xd4bfce40  ! 2191: STDA_R	stda	%r10, [%r31 + %r0] 0x72
	.word 0xd2974e60  ! 2192: LDUHA_R	lduha	[%r29, %r0] 0x73, %r9
	.word 0xdef70e80  ! 2193: STXA_R	stxa	%r15, [%r28 + %r0] 0x74
	.word 0xd2cce000  ! 2194: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	.word 0xd2f46000  ! 2195: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2f4a000  ! 2196: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0xd29c2000  ! 2197: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	mov	0x60, %r24
	mov	0x3f0, %r21
	.word 0xd6a649e0  ! 2200: STWA_R	stwa	%r11, [%r25 + %r0] 0x4f
	.word 0xdabf4e60  ! 2201: STDA_R	stda	%r13, [%r29 + %r0] 0x73
	.word 0xd08c6000  ! 2202: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	mov	0x18, %r25
	mov	0x28, %r27
	.word 0xd0aca000  ! 2205: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xd2b689e0  ! 2206: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	.word 0xd2946000  ! 2207: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r9
	.word 0xd2b46000  ! 2208: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0xd494c400  ! 2209: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	.word 0xd6a46000  ! 2210: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0xd2de89e0  ! 2211: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r9
	.word 0xd4b4e000  ! 2212: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	mov	0x50, %r25
	.word 0xdab48400  ! 2214: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0xd8a4e000  ! 2215: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	mov	0x7c0, %r20
	.word 0xd88e09e0  ! 2217: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r12
	.word 0x87802025  ! 2218: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 2219: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bf6000  ! 2220: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	mov	0x78, %r24
	.word 0x87802073  ! 2222: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r16
	.word 0xd4f7e000  ! 2224: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xd2f78e60  ! 2225: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0xdca70e60  ! 2226: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	.word 0xd0a544a0  ! 2227: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	.word 0xd29f2000  ! 2228: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd28fa000  ! 2229: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	mov	0x0, %r19
	.word 0x87802073  ! 2231: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 2232: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd68d84a0  ! 2233: LDUBA_R	lduba	[%r22, %r0] 0x25, %r11
	.word 0xdabf8e40  ! 2234: STDA_R	stda	%r13, [%r30 + %r0] 0x72
	mov	0x10, %r19
	.word 0x87802020  ! 2236: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2237: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 2238: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0cf2000  ! 2239: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	mov	0x7d8, %r22
	.word 0x87802073  ! 2241: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f6c9e0  ! 2242: STXA_R	stxa	%r9, [%r27 + %r0] 0x4f
	.word 0x87802025  ! 2243: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdccf0e40  ! 2244: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r14
	.word 0xd0bd2000  ! 2245: STDA_I	stda	%r8, [%r20 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xd48f8e60  ! 2247: LDUBA_R	lduba	[%r30, %r0] 0x73, %r10
	.word 0xdecd2000  ! 2248: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r15
	mov	0x60, %r19
	mov	0x78, %r17
	mov	0x48, %r24
	.word 0xd4df4e40  ! 2252: LDXA_R	ldxa	[%r29, %r0] 0x72, %r10
	mov	0x3c0, %r21
	.word 0xdeb609e0  ! 2254: STHA_R	stha	%r15, [%r24 + %r0] 0x4f
	mov	0x58, %r17
	.word 0xd8bd6000  ! 2256: STDA_I	stda	%r12, [%r21 + 0x0000] %asi
	.word 0xd8ade000  ! 2257: STBA_I	stba	%r12, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 2258: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r27
	mov	0x48, %r19
	.word 0xdeaf4e60  ! 2261: STBA_R	stba	%r15, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 2262: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0bfce60  ! 2263: STDA_R	stda	%r8, [%r31 + %r0] 0x73
	.word 0xdaaca000  ! 2264: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0xdac4e000  ! 2265: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r13
	.word 0xd0f609e0  ! 2266: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	.word 0xd0b74e60  ! 2267: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	.word 0xd8d74e40  ! 2268: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r12
	.word 0xdcf40400  ! 2269: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	mov	0x40, %r25
	.word 0xd8ac6000  ! 2271: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xd8a4e000  ! 2272: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xd89ca000  ! 2273: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r12
	mov	0x30, %r17
	.word 0xd8942000  ! 2275: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r12
	.word 0xdef44400  ! 2276: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xd2b4e000  ! 2277: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0xd49f0e80  ! 2278: LDDA_R	ldda	[%r28, %r0] 0x74, %r10
	.word 0x87802073  ! 2279: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc9f8e60  ! 2280: LDDA_R	ldda	[%r30, %r0] 0x73, %r14
	.word 0xd6a7e000  ! 2281: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xdccf4e80  ! 2282: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r14
	.word 0xdc8f6000  ! 2283: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0x87802072  ! 2284: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc9c6000  ! 2285: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r14
	.word 0xdc94a000  ! 2286: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xdc942000  ! 2287: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	.word 0xdcdc2000  ! 2288: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2289: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a689e0  ! 2290: STWA_R	stwa	%r8, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 2291: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccc6000  ! 2292: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	.word 0xdc94e000  ! 2293: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	.word 0xd6d7ce80  ! 2294: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r11
	mov	0x70, %r26
	.word 0xde94e000  ! 2296: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	.word 0xde9c6000  ! 2297: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0xd6ac0400  ! 2298: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	mov	0x28, %r19
	.word 0xd29c6000  ! 2300: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	.word 0xd2ac2000  ! 2301: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 2302: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r26
	.word 0x87802020  ! 2304: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc840400  ! 2305: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	mov	0x0, %r18
	mov	0x3d8, %r22
	.word 0xdeb7ce60  ! 2308: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	mov	0x20, %r16
	.word 0xdef6c9e0  ! 2310: STXA_R	stxa	%r15, [%r27 + %r0] 0x4f
	.word 0xd4d544a0  ! 2311: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r10
	mov	0x78, %r24
	.word 0xdaa74e40  ! 2313: STWA_R	stwa	%r13, [%r29 + %r0] 0x72
	.word 0xd8b74e40  ! 2314: STHA_R	stha	%r12, [%r29 + %r0] 0x72
	.word 0xd8a42000  ! 2315: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8ace000  ! 2316: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	mov	0x78, %r24
	.word 0xd8dc2000  ! 2318: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0xd8a46000  ! 2319: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8f42000  ! 2320: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 2321: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r22
	wr_tick_cmpr_1_20:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb7, %g2
	or	%g4, 0xd8, %g4
	or	%g6, 0xc9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8942000  ! 2324: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r12
	.word 0xd4af8e60  ! 2325: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	.word 0xd6ace000  ! 2326: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0xd6cce000  ! 2327: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r11
	.word 0xdccd04a0  ! 2328: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r14
	.word 0xdc878e60  ! 2329: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r14
	mov	0x8, %r24
	.word 0xdcb689e0  ! 2331: STHA_R	stha	%r14, [%r26 + %r0] 0x4f
	.word 0xd0846000  ! 2332: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0x87802074  ! 2333: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca74e60  ! 2334: STWA_R	stwa	%r14, [%r29 + %r0] 0x73
	.word 0xd8d52000  ! 2335: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r12
	.word 0xd8a52000  ! 2336: STWA_I	stwa	%r12, [%r20 + 0x0000] %asi
	.word 0xd8bda000  ! 2337: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	.word 0xd895e000  ! 2338: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r12
	.word 0xd8a5a000  ! 2339: STWA_I	stwa	%r12, [%r22 + 0x0000] %asi
	.word 0xd8a52000  ! 2340: STWA_I	stwa	%r12, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 2341: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d8, %r22
	.word 0xd0bfce40  ! 2343: STDA_R	stda	%r8, [%r31 + %r0] 0x72
	.word 0xd6dee000  ! 2344: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r11
	.word 0xd6a66000  ! 2345: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	mov	0x3f0, %r22
	mov	0x70, %r18
	.word 0xd4b6c9e0  ! 2348: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0xd8bc4400  ! 2349: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	mov	0x0, %r19
	.word 0xd4f6a000  ! 2351: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	.word 0xdca4c400  ! 2352: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xd69584a0  ! 2353: LDUHA_R	lduha	[%r22, %r0] 0x25, %r11
	.word 0xde86a000  ! 2354: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r15
	.word 0x87802025  ! 2355: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdea42000  ! 2356: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xd8b70e80  ! 2357: STHA_R	stha	%r12, [%r28 + %r0] 0x74
	.word 0x87802020  ! 2358: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2359: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4dc2000  ! 2360: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	.word 0xd48ca000  ! 2361: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r10
	.word 0xd4aca000  ! 2362: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 2363: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r27
	mov	0x70, %r24
	mov	0x58, %r16
	.word 0xd2c6c9e0  ! 2367: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r9
	.word 0xd887e000  ! 2368: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0xd497ce40  ! 2369: LDUHA_R	lduha	[%r31, %r0] 0x72, %r10
	.word 0xdef76000  ! 2370: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xd6b504a0  ! 2371: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	mov	0x3e8, %r22
	.word 0xdaafce40  ! 2373: STBA_R	stba	%r13, [%r31 + %r0] 0x72
	.word 0x87802073  ! 2374: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r16
	.word 0xd8f70e60  ! 2376: STXA_R	stxa	%r12, [%r28 + %r0] 0x73
	.word 0xd2d76000  ! 2377: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0xd2bfe000  ! 2378: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd2f7a000  ! 2379: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xd2b76000  ! 2380: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2b7a000  ! 2381: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	mov	0x7c8, %r21
	.word 0xd29f2000  ! 2383: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xdedc0400  ! 2384: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	.word 0xd89e09e0  ! 2385: LDDA_R	ldda	[%r24, %r0] 0x4f, %r12
	mov	0x48, %r18
	mov	0x3e8, %r21
	.word 0xd2cec9e0  ! 2388: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r9
	.word 0x87802072  ! 2389: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdad5a000  ! 2390: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r13
	.word 0xdece89e0  ! 2391: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r15
	.word 0xd0dda000  ! 2392: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r8
	.word 0xd0b56000  ! 2393: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	.word 0xd085a000  ! 2394: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r8
	.word 0xdcf7ce60  ! 2395: STXA_R	stxa	%r14, [%r31 + %r0] 0x73
	mov	0x48, %r16
	.word 0xd6f5e000  ! 2397: STXA_I	stxa	%r11, [%r23 + 0x0000] %asi
	.word 0x87802073  ! 2398: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd68f2000  ! 2399: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xd6dfa000  ! 2400: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6af6000  ! 2401: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 2402: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f72000  ! 2403: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd4a7ce60  ! 2404: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	.word 0xded48400  ! 2405: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	mov	0x68, %r18
	.word 0xd8d44400  ! 2407: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	mov	0x3f0, %r21
	mov	0x3f0, %r23
	.word 0xd2dc8400  ! 2410: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0x87802020  ! 2411: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b46000  ! 2412: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0xd2b46000  ! 2413: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	mov	0x58, %r19
	.word 0x87802072  ! 2415: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2cce000  ! 2416: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	mov	0x28, %r17
	mov	0x48, %r18
	.word 0xd294e000  ! 2419: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	.word 0xdcc544a0  ! 2420: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r14
	.word 0xd6bdc4a0  ! 2421: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	.word 0xd4a46000  ! 2422: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0x87802072  ! 2424: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r18
	.word 0xd494c400  ! 2426: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	.word 0xdecf4e80  ! 2427: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r15
	wr_tick_cmpr_1_21:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x9d, %g2
	or	%g4, 0xdf, %g4
	or	%g6, 0xe4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xdc8f4e60  ! 2429: LDUBA_R	lduba	[%r29, %r0] 0x73, %r14
	.word 0xd6f56000  ! 2430: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	.word 0xd0b7ce60  ! 2431: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	.word 0xd4b44400  ! 2432: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	.word 0xdeb5a000  ! 2433: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	.word 0xded52000  ! 2434: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r15
	.word 0xdca70e40  ! 2435: STWA_R	stwa	%r14, [%r28 + %r0] 0x72
	.word 0xdccd2000  ! 2436: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r14
	.word 0xdcb52000  ! 2437: STHA_I	stha	%r14, [%r20 + 0x0000] %asi
	.word 0xdcc5a000  ! 2438: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2439: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f584a0  ! 2440: STXA_R	stxa	%r11, [%r22 + %r0] 0x25
	.word 0xd6aee000  ! 2441: STBA_I	stba	%r11, [%r27 + 0x0000] %asi
	.word 0xd8f6c9e0  ! 2442: STXA_R	stxa	%r12, [%r27 + %r0] 0x4f
	.word 0xd0966000  ! 2443: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r8
	.word 0xd8bf8e60  ! 2444: STDA_R	stda	%r12, [%r30 + %r0] 0x73
	.word 0xd486e000  ! 2445: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	.word 0xd4ce6000  ! 2446: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r10
	mov	0x58, %r16
	.word 0xd68d04a0  ! 2448: LDUBA_R	lduba	[%r20, %r0] 0x25, %r11
	.word 0xd486e000  ! 2449: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	.word 0x87802020  ! 2450: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dfce60  ! 2451: LDXA_R	ldxa	[%r31, %r0] 0x73, %r9
	.word 0xd8f609e0  ! 2452: STXA_R	stxa	%r12, [%r24 + %r0] 0x4f
	.word 0xd8c78e60  ! 2453: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r12
	mov	0x68, %r24
	.word 0xde9f8e80  ! 2455: LDDA_R	ldda	[%r30, %r0] 0x74, %r15
	.word 0xd0ae6000  ! 2456: STBA_I	stba	%r8, [%r25 + 0x0000] %asi
	.word 0xd0c6e000  ! 2457: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r8
	mov	0x28, %r16
	mov	0x60, %r27
	mov	0x78, %r24
	.word 0xd4cf8e80  ! 2461: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r10
	.word 0xd4ac4400  ! 2462: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0x87802025  ! 2463: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdef7a000  ! 2464: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	mov	0x0, %r26
	.word 0x87802020  ! 2466: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b44400  ! 2467: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0xdaf7ce80  ! 2468: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	mov	0x3c8, %r20
	.word 0xd68f8e40  ! 2470: LDUBA_R	lduba	[%r30, %r0] 0x72, %r11
	.word 0x87802020  ! 2471: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88f4e60  ! 2472: LDUBA_R	lduba	[%r29, %r0] 0x73, %r12
	.word 0xd0862000  ! 2473: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r8
	.word 0xdeb649e0  ! 2474: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	.word 0xdcb6a000  ! 2475: STHA_I	stha	%r14, [%r26 + 0x0000] %asi
	.word 0xdcae6000  ! 2476: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	.word 0xdcc6c9e0  ! 2477: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r14
	.word 0xd0dee000  ! 2478: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r8
	mov	0x3c8, %r22
	.word 0x87802020  ! 2480: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0dfe000  ! 2481: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0872000  ! 2482: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	mov	0x40, %r27
	mov	0x3e0, %r20
	.word 0x87802072  ! 2485: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcaf8e60  ! 2486: STBA_R	stba	%r14, [%r30 + %r0] 0x73
	.word 0xdc9fce80  ! 2487: LDDA_R	ldda	[%r31, %r0] 0x74, %r14
	.word 0xdaf7a000  ! 2488: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xd2bf8e40  ! 2489: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	.word 0xdacc8400  ! 2490: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r13
	mov	0x50, %r16
	.word 0xd0ac4400  ! 2492: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0xd2ae49e0  ! 2493: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	.word 0xd2b44400  ! 2494: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0xd6b609e0  ! 2495: STHA_R	stha	%r11, [%r24 + %r0] 0x4f
	mov	0x7e8, %r22
	.word 0xdea7e000  ! 2497: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 2498: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 2499: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 2500: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r25
	.word 0x87802072  ! 2502: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r18
	.word 0xd0b584a0  ! 2504: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	.word 0xda97a000  ! 2505: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xdad72000  ! 2506: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0xd29f4e40  ! 2507: LDDA_R	ldda	[%r29, %r0] 0x72, %r9
	.word 0xd4bf4e60  ! 2508: STDA_R	stda	%r10, [%r29 + %r0] 0x73
	mov	0x7c0, %r20
	.word 0xdeb7e000  ! 2510: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xd2aec9e0  ! 2511: STBA_R	stba	%r9, [%r27 + %r0] 0x4f
	.word 0x87802073  ! 2512: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8dc2000  ! 2513: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0x87802072  ! 2514: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8976000  ! 2515: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0x87802073  ! 2516: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r17
	.word 0xd8bd2000  ! 2518: STDA_I	stda	%r12, [%r20 + 0x0000] %asi
	.word 0xd8c52000  ! 2519: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r12
	mov	0x68, %r25
	.word 0xd8a5a000  ! 2521: STWA_I	stwa	%r12, [%r22 + 0x0000] %asi
	.word 0x87802074  ! 2522: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e0, %r23
	mov	0x70, %r26
	mov	0x40, %r27
	.word 0x87802073  ! 2526: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf4c400  ! 2527: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xdcbc0400  ! 2528: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0xd08ea000  ! 2529: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r8
	.word 0xd0ccc400  ! 2530: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	.word 0xd6d649e0  ! 2531: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r11
	.word 0xdad7ce80  ! 2532: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r13
	mov	0x8, %r24
	.word 0xd8d6a000  ! 2534: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r12
	mov	0x18, %r18
	.word 0x87802020  ! 2536: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a5e000  ! 2537: STWA_I	stwa	%r12, [%r23 + 0x0000] %asi
	.word 0xdadf8e80  ! 2538: LDXA_R	ldxa	[%r30, %r0] 0x74, %r13
	.word 0x87802025  ! 2539: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdec7ce60  ! 2540: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r15
	.word 0x87802020  ! 2541: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad6c9e0  ! 2542: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r13
	.word 0xd0d40400  ! 2543: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	.word 0xd6cf8e80  ! 2544: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r11
	.word 0xdcb78e80  ! 2545: STHA_R	stha	%r14, [%r30 + %r0] 0x74
	.word 0xd6b44400  ! 2546: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0x87802073  ! 2547: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_HPRIV	! macro
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2ce6000  ! 2550: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r9
	.word 0xd2aea000  ! 2551: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0xd0a7ce80  ! 2552: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	.word 0xd886a000  ! 2553: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r12
	mov	0x50, %r19
	mov	0x3c8, %r20
	mov	0x50, %r18
	.word 0xd2d74e60  ! 2557: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r9
	.word 0xdcb4c400  ! 2558: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xd8a66000  ! 2559: STWA_I	stwa	%r12, [%r25 + 0x0000] %asi
	.word 0xd8dee000  ! 2560: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r12
	.word 0xd0bc4400  ! 2561: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	mov	0x7f8, %r23
	.word 0xd8862000  ! 2563: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r12
	.word 0xd89e2000  ! 2564: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r12
	.word 0xd8be6000  ! 2565: STDA_I	stda	%r12, [%r25 + 0x0000] %asi
	.word 0xd4b7ce80  ! 2566: STHA_R	stha	%r10, [%r31 + %r0] 0x74
	.word 0xd48e6000  ! 2567: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r10
	.word 0x87802074  ! 2568: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r26
	.word 0xd8cc8400  ! 2570: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0xd6f40400  ! 2571: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	ta	T_CHANGE_HPRIV	! macro
	.word 0xda97a000  ! 2573: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xd0b48400  ! 2574: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xdca70e60  ! 2575: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	.word 0xdab4c400  ! 2576: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xd0d76000  ! 2577: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xd294c400  ! 2578: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	mov	0x7c0, %r23
	.word 0x87802074  ! 2580: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 2581: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 2582: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b66000  ! 2583: STHA_I	stha	%r10, [%r25 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0xd69609e0  ! 2585: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r11
	mov	0x60, %r19
	.word 0xd4b74e40  ! 2587: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	.word 0x87802074  ! 2588: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0ace000  ! 2589: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 2590: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 2591: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b649e0  ! 2592: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	.word 0xdab76000  ! 2593: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xdea44400  ! 2594: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xd8d76000  ! 2595: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	mov	0x58, %r17
	.word 0xd8a76000  ! 2597: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xd0c4c400  ! 2598: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	mov	0x3e0, %r20
	.word 0xdef7e000  ! 2600: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xd4c40400  ! 2601: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	.word 0xd4c7a000  ! 2602: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	mov	0x38, %r19
	mov	0x7e0, %r23
	.word 0xd4b7e000  ! 2605: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0x87802020  ! 2607: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd484e000  ! 2608: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r10
	.word 0x87802020  ! 2609: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dc0400  ! 2610: LDXA_R	ldxa	[%r16, %r0] 0x20, %r9
	mov	0x78, %r17
	.word 0xdab56000  ! 2612: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	.word 0xdadda000  ! 2613: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r13
	mov	0x48, %r17
	.word 0xdad5e000  ! 2615: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r13
	.word 0x87802074  ! 2616: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2617: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c44400  ! 2618: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r12
	.word 0xd8d42000  ! 2619: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0xd8ac2000  ! 2620: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0xd0a7ce60  ! 2621: STWA_R	stwa	%r8, [%r31 + %r0] 0x73
	.word 0x87802020  ! 2622: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2623: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa689e0  ! 2624: STWA_R	stwa	%r13, [%r26 + %r0] 0x4f
	mov	0x7f8, %r20
	mov	0x58, %r19
	.word 0x87802073  ! 2627: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r18
	.word 0xd8b4a000  ! 2629: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xd8bc6000  ! 2631: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0xd8bc6000  ! 2632: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0xd8b42000  ! 2633: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 2634: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd88f6000  ! 2635: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xd8f7a000  ! 2636: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	mov	0x68, %r17
	mov	0x3e8, %r21
	mov	0x70, %r25
	.word 0xd2f78e60  ! 2640: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0xd4d649e0  ! 2641: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r10
	.word 0xd0a76000  ! 2642: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0f76000  ! 2643: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	mov	0x50, %r24
	.word 0xd8f504a0  ! 2645: STXA_R	stxa	%r12, [%r20 + %r0] 0x25
	mov	0x40, %r26
	.word 0xd2d5c4a0  ! 2647: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r9
	.word 0x87802074  ! 2648: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r18
	.word 0x87802020  ! 2650: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r21
	mov	0x18, %r26
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802025  ! 2654: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r25
	.word 0xd0cc8400  ! 2656: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0xd6bd6000  ! 2657: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0x87802074  ! 2658: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f609e0  ! 2659: STXA_R	stxa	%r12, [%r24 + %r0] 0x4f
	.word 0xd2bee000  ! 2660: STDA_I	stda	%r9, [%r27 + 0x0000] %asi
	mov	0x30, %r17
	.word 0x87802072  ! 2662: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc8f8e60  ! 2663: LDUBA_R	lduba	[%r30, %r0] 0x73, %r14
	.word 0xdab7a000  ! 2664: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdacf2000  ! 2665: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	mov	0x7c0, %r23
	.word 0xde970e40  ! 2667: LDUHA_R	lduha	[%r28, %r0] 0x72, %r15
	.word 0xd6be09e0  ! 2668: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	.word 0xd0876000  ! 2669: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	.word 0xda974e80  ! 2670: LDUHA_R	lduha	[%r29, %r0] 0x74, %r13
	mov	0x10, %r16
	.word 0x87802074  ! 2672: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e0, %r22
	.word 0xd2d7e000  ! 2674: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	mov	0x3e0, %r22
	mov	0x7e0, %r20
	.word 0x87802020  ! 2677: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2f4e000  ! 2679: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2bce000  ! 2680: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xd4f609e0  ! 2681: STXA_R	stxa	%r10, [%r24 + %r0] 0x4f
	.word 0xd4b44400  ! 2682: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	.word 0xd8d609e0  ! 2683: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r12
	.word 0x87802072  ! 2684: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab6c9e0  ! 2685: STHA_R	stha	%r13, [%r27 + %r0] 0x4f
	.word 0xd08f2000  ! 2686: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	.word 0xd8b44400  ! 2687: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0xdea7ce80  ! 2688: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	mov	0x18, %r25
	.word 0xdcbf2000  ! 2690: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 2691: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc9ca000  ! 2692: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r14
	.word 0xdcbf4e80  ! 2693: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	wr_tick_cmpr_1_22:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xec, %g2
	or	%g4, 0xe6, %g4
	or	%g6, 0xb9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802074  ! 2695: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2696: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_1_23:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xc6, %g2
	or	%g4, 0x86, %g4
	or	%g6, 0xac, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd2b66000  ! 2698: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 2699: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c7e000  ! 2700: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0xdccf4e80  ! 2701: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r14
	.word 0xd4b689e0  ! 2702: STHA_R	stha	%r10, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 2703: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4870e60  ! 2704: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r10
	.word 0xdea70e60  ! 2705: STWA_R	stwa	%r15, [%r28 + %r0] 0x73
	.word 0xd2b7a000  ! 2706: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd29fe000  ! 2707: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd2dfa000  ! 2708: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2709: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a7a000  ! 2710: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xd2b7e000  ! 2712: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd29fa000  ! 2713: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	mov	0x3c0, %r21
	.word 0xd2b7e000  ! 2715: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	mov	0x3c8, %r22
	.word 0x87802020  ! 2717: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29ee000  ! 2718: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r9
	mov	0x7c0, %r20
	.word 0xd2be2000  ! 2720: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	.word 0xdca78e80  ! 2721: STWA_R	stwa	%r14, [%r30 + %r0] 0x74
	.word 0xdeb544a0  ! 2722: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	.word 0xdabe2000  ! 2723: STDA_I	stda	%r13, [%r24 + 0x0000] %asi
	mov	0x48, %r17
	.word 0xdaaea000  ! 2725: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	.word 0xd6af8e80  ! 2726: STBA_R	stba	%r11, [%r30 + %r0] 0x74
	mov	0x70, %r19
	.word 0xd8b70e80  ! 2728: STHA_R	stha	%r12, [%r28 + %r0] 0x74
	.word 0x87802074  ! 2729: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdedf0e80  ! 2730: LDXA_R	ldxa	[%r28, %r0] 0x74, %r15
	.word 0xdcbe6000  ! 2731: STDA_I	stda	%r14, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 2732: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r24
	.word 0xd0948400  ! 2734: LDUHA_R	lduha	[%r18, %r0] 0x20, %r8
	.word 0xd6d44400  ! 2735: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r11
	.word 0xd8d609e0  ! 2736: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r12
	.word 0xd0d44400  ! 2737: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r8
	.word 0x8780204f  ! 2738: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r18
	.word 0xd4aca000  ! 2740: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 2741: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r26
	mov	0x3f0, %r20
	.word 0xdaa74e40  ! 2744: STWA_R	stwa	%r13, [%r29 + %r0] 0x72
	.word 0xd2cd6000  ! 2745: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r9
	mov	0x3d8, %r20
	.word 0xd2ade000  ! 2747: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0xd2956000  ! 2748: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r9
	.word 0xd0c44400  ! 2749: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r8
	mov	0x8, %r25
	.word 0xdab44400  ! 2751: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	wr_tick_cmpr_1_24:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc1, %g2
	or	%g4, 0xb5, %g4
	or	%g6, 0xc4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd8f4c400  ! 2753: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xd6a70e60  ! 2754: STWA_R	stwa	%r11, [%r28 + %r0] 0x73
	.word 0xd2af8e60  ! 2755: STBA_R	stba	%r9, [%r30 + %r0] 0x73
	.word 0xd2dda000  ! 2756: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r9
	mov	0x68, %r26
	.word 0xd2dec9e0  ! 2758: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r9
	mov	0x48, %r17
	mov	0x50, %r25
	.word 0xde8cc400  ! 2761: LDUBA_R	lduba	[%r19, %r0] 0x20, %r15
	mov	0x8, %r26
	.word 0xd8956000  ! 2763: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r12
	.word 0xd8c5e000  ! 2764: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r12
	.word 0x87802072  ! 2765: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8d6a000  ! 2766: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r12
	.word 0xd4b609e0  ! 2767: STHA_R	stha	%r10, [%r24 + %r0] 0x4f
	.word 0xdcb6a000  ! 2768: STHA_I	stha	%r14, [%r26 + 0x0000] %asi
	.word 0xdcc6a000  ! 2769: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r14
	.word 0xd6d40400  ! 2770: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	mov	0x7c0, %r20
	.word 0x87802074  ! 2772: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd087e000  ! 2773: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0xda9dc4a0  ! 2774: LDDA_R	ldda	[%r23, %r0] 0x25, %r13
	.word 0xdc85c4a0  ! 2775: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r14
	.word 0x87802073  ! 2776: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf70e80  ! 2777: STXA_R	stxa	%r13, [%r28 + %r0] 0x74
	.word 0x8780204f  ! 2778: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4cda000  ! 2779: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r10
	.word 0xd4d52000  ! 2780: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r10
	.word 0xd4b56000  ! 2781: STHA_I	stha	%r10, [%r21 + 0x0000] %asi
	.word 0xd8a649e0  ! 2782: STWA_R	stwa	%r12, [%r25 + %r0] 0x4f
	.word 0xd6ad6000  ! 2783: STBA_I	stba	%r11, [%r21 + 0x0000] %asi
	.word 0xd2dd84a0  ! 2784: LDXA_R	ldxa	[%r22, %r0] 0x25, %r9
	mov	0x10, %r25
	.word 0xd085a000  ! 2786: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r8
	mov	0x28, %r18
	.word 0x87802020  ! 2788: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9544a0  ! 2789: LDUHA_R	lduha	[%r21, %r0] 0x25, %r14
	.word 0xdaf649e0  ! 2790: STXA_R	stxa	%r13, [%r25 + %r0] 0x4f
	mov	0x10, %r19
	.word 0xd48ea000  ! 2792: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r10
	.word 0xd4dea000  ! 2793: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	.word 0x87802020  ! 2794: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2795: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4842000  ! 2796: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 2797: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4d7e000  ! 2798: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	mov	0x78, %r24
	mov	0x68, %r19
	.word 0x8780204f  ! 2801: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2802: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49f6000  ! 2803: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0xd4dfe000  ! 2804: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	mov	0x48, %r19
	.word 0x8780204f  ! 2806: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d8, %r20
	.word 0xd4b7a000  ! 2808: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	mov	0x30, %r26
	mov	0x20, %r25
	mov	0x78, %r25
	mov	0x7d8, %r21
	.word 0xd2cc4400  ! 2813: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r9
	.word 0xd6dfa000  ! 2814: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	mov	0x8, %r19
	.word 0xd6976000  ! 2816: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	.word 0xd6976000  ! 2817: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 2818: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeac4400  ! 2819: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0x87802025  ! 2820: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd89f6000  ! 2821: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 2822: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 2823: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8a66000  ! 2824: STWA_I	stwa	%r12, [%r25 + 0x0000] %asi
	.word 0xdea74e80  ! 2825: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	.word 0x87802020  ! 2826: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2af6000  ! 2827: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 2828: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r25
	mov	0x30, %r16
	mov	0x3f0, %r22
	.word 0xd29ee000  ! 2832: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r9
	.word 0xde9ec9e0  ! 2833: LDDA_R	ldda	[%r27, %r0] 0x4f, %r15
	.word 0xdabc0400  ! 2834: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xd2c74e60  ! 2835: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r9
	mov	0x3f0, %r23
	ta	T_CHANGE_PRIV	! macro
	mov	0x18, %r24
	.word 0xd686a000  ! 2839: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2840: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b7e000  ! 2841: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	mov	0x18, %r16
	.word 0xd6f7e000  ! 2843: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2844: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2845: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6876000  ! 2846: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6afe000  ! 2847: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd0f584a0  ! 2848: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	mov	0x48, %r18
	.word 0xdaf72000  ! 2850: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 2851: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r20
	.word 0x87802025  ! 2853: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda976000  ! 2854: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	.word 0x87802073  ! 2855: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeac4400  ! 2856: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	mov	0x20, %r19
	.word 0xdeb4c400  ! 2858: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	mov	0x50, %r27
	.word 0xd8f78e40  ! 2860: STXA_R	stxa	%r12, [%r30 + %r0] 0x72
	.word 0xd6a48400  ! 2861: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0xd4dfa000  ! 2862: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xde840400  ! 2863: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	.word 0xd2bcc400  ! 2864: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	mov	0x7c0, %r20
	.word 0xdcf7ce60  ! 2866: STXA_R	stxa	%r14, [%r31 + %r0] 0x73
	.word 0xd4b74e80  ! 2867: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	mov	0x8, %r17
	mov	0x48, %r27
	.word 0xd8870e60  ! 2870: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r12
	mov	0x40, %r27
	mov	0x38, %r16
	.word 0xdcf48400  ! 2873: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xdca7e000  ! 2874: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 2875: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb46000  ! 2876: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	mov	0x30, %r18
	.word 0xd2df8e40  ! 2878: LDXA_R	ldxa	[%r30, %r0] 0x72, %r9
	.word 0x87802020  ! 2879: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b78e80  ! 2880: STHA_R	stha	%r10, [%r30 + %r0] 0x74
	.word 0xd2afce60  ! 2881: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	.word 0xd2c40400  ! 2882: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r9
	mov	0x38, %r18
	.word 0x87802074  ! 2884: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabfe000  ! 2885: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	mov	0x7e0, %r22
	.word 0x87802074  ! 2887: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2888: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaac2000  ! 2889: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	mov	0x50, %r25
	.word 0xd6a504a0  ! 2891: STWA_R	stwa	%r11, [%r20 + %r0] 0x25
	.word 0xd4cce000  ! 2892: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	mov	0x68, %r18
	mov	0x7c0, %r21
	.word 0xdca78e40  ! 2895: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	.word 0xd2af0e80  ! 2896: STBA_R	stba	%r9, [%r28 + %r0] 0x74
	.word 0xdc942000  ! 2897: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	mov	0x3e8, %r20
	.word 0x87802025  ! 2899: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf7e000  ! 2900: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcbf2000  ! 2901: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	mov	0x7c8, %r21
	.word 0x87802025  ! 2903: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb76000  ! 2904: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	mov	0x8, %r25
	.word 0xdcc72000  ! 2906: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xd4d4c400  ! 2907: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0x87802020  ! 2908: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2909: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cf4e80  ! 2910: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r10
	.word 0x87802020  ! 2911: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2912: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r17
	.word 0xd4b72000  ! 2914: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 2915: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8af0e80  ! 2916: STBA_R	stba	%r12, [%r28 + %r0] 0x74
	.word 0xd2b4c400  ! 2917: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xdc8c4400  ! 2918: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0xd8df8e40  ! 2919: LDXA_R	ldxa	[%r30, %r0] 0x72, %r12
	.word 0xd48649e0  ! 2920: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r10
	.word 0xd496c9e0  ! 2921: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r10
	.word 0xd6d56000  ! 2922: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r11
	.word 0xdebcc400  ! 2923: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	.word 0xdcf56000  ! 2924: STXA_I	stxa	%r14, [%r21 + 0x0000] %asi
	.word 0xdea40400  ! 2925: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xd89fce40  ! 2926: LDDA_R	ldda	[%r31, %r0] 0x72, %r12
	mov	0x48, %r19
	.word 0xd6f544a0  ! 2928: STXA_R	stxa	%r11, [%r21 + %r0] 0x25
	mov	0x58, %r18
	.word 0x87802020  ! 2930: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r19
	.word 0xde842000  ! 2932: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	mov	0x28, %r17
	.word 0xde8c6000  ! 2934: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	mov	0x7d0, %r21
	.word 0xded46000  ! 2936: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	.word 0xdaad84a0  ! 2937: STBA_R	stba	%r13, [%r22 + %r0] 0x25
	mov	0x28, %r25
	.word 0xdec4e000  ! 2939: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	mov	0x3f8, %r20
	.word 0xdebd44a0  ! 2941: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	mov	0x68, %r17
	mov	0x30, %r18
	mov	0x60, %r25
	.word 0xd6dc6000  ! 2945: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r11
	.word 0xd6f4e000  ! 2946: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	mov	0x70, %r16
	.word 0x8780204f  ! 2948: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd68da000  ! 2949: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r11
	.word 0xdcacc400  ! 2950: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0xd6a56000  ! 2951: STWA_I	stwa	%r11, [%r21 + 0x0000] %asi
	.word 0xda974e60  ! 2952: LDUHA_R	lduha	[%r29, %r0] 0x73, %r13
	mov	0x0, %r18
	.word 0xd0a40400  ! 2954: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0xd4bd2000  ! 2955: STDA_I	stda	%r10, [%r20 + 0x0000] %asi
	.word 0xd49d2000  ! 2956: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r10
	.word 0xda970e40  ! 2957: LDUHA_R	lduha	[%r28, %r0] 0x72, %r13
	.word 0xd2bd6000  ! 2958: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	.word 0xd2b609e0  ! 2959: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	mov	0x20, %r18
	mov	0x3e8, %r21
	.word 0xd0dfce40  ! 2962: LDXA_R	ldxa	[%r31, %r0] 0x72, %r8
	.word 0xd6b5e000  ! 2963: STHA_I	stha	%r11, [%r23 + 0x0000] %asi
	.word 0xd6ade000  ! 2964: STBA_I	stba	%r11, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 2965: WRASI_I	wr	%r0, 0x0074, %asi
	wr_tick_cmpr_1_25:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x89, %g2
	or	%g4, 0xc1, %g4
	or	%g6, 0xf6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7e8, %r23
	mov	0x40, %r25
	.word 0xd0a4c400  ! 2969: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xdad44400  ! 2970: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0xde8f4e40  ! 2971: LDUBA_R	lduba	[%r29, %r0] 0x72, %r15
	.word 0xd88f0e60  ! 2972: LDUBA_R	lduba	[%r28, %r0] 0x73, %r12
	mov	0x18, %r19
	.word 0xdef40400  ! 2974: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0xd28f8e40  ! 2975: LDUBA_R	lduba	[%r30, %r0] 0x72, %r9
	.word 0xd4876000  ! 2976: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xd0af0e60  ! 2977: STBA_R	stba	%r8, [%r28 + %r0] 0x73
	.word 0x87802020  ! 2978: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a6c9e0  ! 2979: STWA_R	stwa	%r9, [%r27 + %r0] 0x4f
	.word 0xd29c6000  ! 2980: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	.word 0xdaae89e0  ! 2981: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	.word 0xd8bc2000  ! 2982: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd8a42000  ! 2983: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd89ce000  ! 2984: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	.word 0xd8bce000  ! 2985: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd88c6000  ! 2986: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	.word 0xd8dca000  ! 2987: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	.word 0xd89e09e0  ! 2988: LDDA_R	ldda	[%r24, %r0] 0x4f, %r12
	.word 0xd4bca000  ! 2989: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	mov	0x68, %r18
	.word 0x87802025  ! 2991: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 2992: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3e0, %r23
	.word 0xd8b7ce80  ! 2994: STHA_R	stha	%r12, [%r31 + %r0] 0x74
	.word 0x87802073  ! 2995: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e8, %r20
	.word 0xd29f8e40  ! 2997: LDDA_R	ldda	[%r30, %r0] 0x72, %r9
	mov	0x7d8, %r21
	.word 0xd8bc8400  ! 2999: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 3000: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 3001: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r16
	.word 0x87802073  ! 3003: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f4c400  ! 3004: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xdebf0e60  ! 3005: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	.word 0x87802072  ! 3006: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r25
	mov	0x8, %r27
	.word 0xd6b74e60  ! 3009: STHA_R	stha	%r11, [%r29 + %r0] 0x73
	.word 0xd4f48400  ! 3010: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xd0f46000  ! 3011: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	mov	0x7c8, %r22
	.word 0xd0bc8400  ! 3013: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0x87802025  ! 3014: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4ccc400  ! 3015: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0xd2bfa000  ! 3016: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd095c4a0  ! 3017: LDUHA_R	lduha	[%r23, %r0] 0x25, %r8
	.word 0xd8b78e40  ! 3018: STHA_R	stha	%r12, [%r30 + %r0] 0x72
	.word 0xdef504a0  ! 3019: STXA_R	stxa	%r15, [%r20 + %r0] 0x25
	.word 0x87802025  ! 3020: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcd4c400  ! 3021: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	.word 0xd6df2000  ! 3022: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6af6000  ! 3023: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd8d609e0  ! 3024: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r12
	mov	0x7f0, %r22
	.word 0xd0a78e40  ! 3026: STWA_R	stwa	%r8, [%r30 + %r0] 0x72
	.word 0xd8cf2000  ! 3027: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0xd897a000  ! 3028: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0xd8c72000  ! 3029: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd6b649e0  ! 3030: STHA_R	stha	%r11, [%r25 + %r0] 0x4f
	.word 0xd6a7ce80  ! 3031: STWA_R	stwa	%r11, [%r31 + %r0] 0x74
	.word 0xdaaf0e80  ! 3032: STBA_R	stba	%r13, [%r28 + %r0] 0x74
	.word 0x87802020  ! 3033: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r24
	.word 0xd88e2000  ! 3035: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r12
	.word 0x87802074  ! 3036: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 3037: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2848400  ! 3038: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r9
	.word 0x87802072  ! 3039: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8ac6000  ! 3040: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 3041: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdccdc4a0  ! 3042: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r14
	.word 0xd6f70e40  ! 3043: STXA_R	stxa	%r11, [%r28 + %r0] 0x72
	.word 0xdead2000  ! 3044: STBA_I	stba	%r15, [%r20 + 0x0000] %asi
	.word 0x87802025  ! 3045: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r24
	mov	0x3c0, %r20
	.word 0xdeb7e000  ! 3048: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xd2bc0400  ! 3049: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xd2d544a0  ! 3050: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r9
	.word 0x87802073  ! 3051: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b70e60  ! 3052: STHA_R	stha	%r8, [%r28 + %r0] 0x73
	mov	0x7c8, %r20
	mov	0x3f8, %r22
	.word 0xd2cf8e60  ! 3055: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r9
	.word 0xdcaf0e80  ! 3056: STBA_R	stba	%r14, [%r28 + %r0] 0x74
	mov	0x3c0, %r22
	.word 0xd8d7ce80  ! 3058: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r12
	.word 0xdaf4c400  ! 3059: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	mov	0x30, %r17
	.word 0xd29f6000  ! 3061: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3062: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f609e0  ! 3063: STXA_R	stxa	%r9, [%r24 + %r0] 0x4f
	.word 0xd4b4e000  ! 3064: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xde940400  ! 3065: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0x87802025  ! 3066: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda94a000  ! 3067: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	.word 0x87802073  ! 3068: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda87e000  ! 3069: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0x87802072  ! 3070: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8dc8400  ! 3071: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xdecf0e60  ! 3072: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r15
	mov	0x78, %r16
	.word 0xdcd649e0  ! 3074: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r14
	.word 0xd2b42000  ! 3075: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	mov	0x38, %r27
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802025  ! 3078: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r24
	.word 0xd2d70e40  ! 3080: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r9
	.word 0xdadf8e40  ! 3081: LDXA_R	ldxa	[%r30, %r0] 0x72, %r13
	mov	0x0, %r16
	.word 0x87802025  ! 3083: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r17
	.word 0xd6dca000  ! 3085: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r11
	.word 0xd6b46000  ! 3086: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 3087: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6972000  ! 3088: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	.word 0xd6f76000  ! 3089: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	mov	0x40, %r26
	.word 0xd08c0400  ! 3091: LDUBA_R	lduba	[%r16, %r0] 0x20, %r8
	.word 0xd2cf2000  ! 3092: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r9
	.word 0xd287a000  ! 3093: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0xd4874e60  ! 3094: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r10
	.word 0x87802020  ! 3095: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r23
	.word 0xd2c42000  ! 3097: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	mov	0x30, %r25
	.word 0x87802020  ! 3099: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a7ce80  ! 3100: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	.word 0xd8944400  ! 3101: LDUHA_R	lduha	[%r17, %r0] 0x20, %r12
	.word 0xd48689e0  ! 3102: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r10
	.word 0xd6852000  ! 3103: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3104: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d76000  ! 3105: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	.word 0xd6948400  ! 3106: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	.word 0xdef70e80  ! 3107: STXA_R	stxa	%r15, [%r28 + %r0] 0x74
	.word 0xd097ce60  ! 3108: LDUHA_R	lduha	[%r31, %r0] 0x73, %r8
	.word 0xd4f72000  ! 3109: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	mov	0x3d0, %r20
	mov	0x8, %r19
	.word 0x87802020  ! 3112: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3113: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 3114: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r25
	.word 0xd697ce60  ! 3116: LDUHA_R	lduha	[%r31, %r0] 0x73, %r11
	.word 0xdc8f6000  ! 3117: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdedfce40  ! 3118: LDXA_R	ldxa	[%r31, %r0] 0x72, %r15
	.word 0xd0dcc400  ! 3119: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0xd2944400  ! 3120: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	mov	0x0, %r16
	.word 0xdebf6000  ! 3122: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xdccf4e40  ! 3124: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r14
	.word 0xdecfce40  ! 3125: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r15
	.word 0xd2976000  ! 3126: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	mov	0x38, %r19
	.word 0x8780204f  ! 3128: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3129: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r20
	mov	0x0, %r19
	.word 0xd29c6000  ! 3132: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	.word 0xd2f4a000  ! 3133: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 3134: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c4c400  ! 3135: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r10
	.word 0xdeafe000  ! 3136: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 3137: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 3138: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 3139: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdecce000  ! 3140: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	.word 0x87802073  ! 3141: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdead6000  ! 3142: STBA_I	stba	%r15, [%r21 + 0x0000] %asi
	mov	0x3e8, %r23
	.word 0x87802025  ! 3144: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r17
	mov	0x50, %r27
	.word 0x87802072  ! 3147: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0d4c400  ! 3148: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	.word 0xd096a000  ! 3149: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r8
	.word 0xd0bea000  ! 3150: STDA_I	stda	%r8, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 3151: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3152: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28f4e40  ! 3153: LDUBA_R	lduba	[%r29, %r0] 0x72, %r9
	mov	0x7c8, %r20
	mov	0x70, %r24
	.word 0xd8b7e000  ! 3156: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xd88cc400  ! 3158: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	.word 0xd4df8e60  ! 3159: LDXA_R	ldxa	[%r30, %r0] 0x73, %r10
	mov	0x3d8, %r23
	.word 0xd49f6000  ! 3161: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0x87802072  ! 3162: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3163: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r23
	.word 0xd4c5e000  ! 3165: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r10
	.word 0xd0bf0e60  ! 3166: STDA_R	stda	%r8, [%r28 + %r0] 0x73
	.word 0xd4852000  ! 3167: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r10
	.word 0xd48da000  ! 3168: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r10
	.word 0xd49d2000  ! 3169: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r10
	mov	0x0, %r16
	.word 0xd4f7ce60  ! 3171: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	.word 0xd89d2000  ! 3172: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r12
	.word 0xdeaec9e0  ! 3173: STBA_R	stba	%r15, [%r27 + %r0] 0x4f
	.word 0xd8b4c400  ! 3174: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	mov	0x7f0, %r20
	.word 0xdcdde000  ! 3176: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	mov	0x20, %r18
	.word 0xdcf5a000  ! 3178: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	.word 0xd8a70e80  ! 3179: STWA_R	stwa	%r12, [%r28 + %r0] 0x74
	mov	0x40, %r24
	.word 0x87802020  ! 3181: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeaf6000  ! 3182: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	mov	0x78, %r26
	.word 0x87802074  ! 3184: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8a40400  ! 3185: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0xd8de89e0  ! 3186: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r12
	.word 0xde8f0e40  ! 3187: LDUBA_R	lduba	[%r28, %r0] 0x72, %r15
	.word 0x87802074  ! 3188: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bde000  ! 3189: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0xd8cc0400  ! 3190: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	mov	0x3c8, %r22
	.word 0xd6c5a000  ! 3192: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r11
	.word 0xd6bde000  ! 3193: STDA_I	stda	%r11, [%r23 + 0x0000] %asi
	.word 0xdebe09e0  ! 3194: STDA_R	stda	%r15, [%r24 + %r0] 0x4f
	.word 0x87802074  ! 3195: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r16
	mov	0x7c8, %r20
	mov	0x3c8, %r22
	.word 0xd8d78e80  ! 3199: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r12
	mov	0x10, %r27
	.word 0xdec72000  ! 3201: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	mov	0x30, %r25
	.word 0xdeb76000  ! 3203: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xd8ac0400  ! 3204: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xd8d72000  ! 3205: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xd88f0e40  ! 3206: LDUBA_R	lduba	[%r28, %r0] 0x72, %r12
	.word 0xdcbf6000  ! 3207: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdcbfa000  ! 3208: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdc8fe000  ! 3209: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xdccfa000  ! 3210: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xdccfa000  ! 3211: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xdcb7a000  ! 3212: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xdaf44400  ! 3213: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0xd4dd04a0  ! 3214: LDXA_R	ldxa	[%r20, %r0] 0x25, %r10
	.word 0xdadd04a0  ! 3215: LDXA_R	ldxa	[%r20, %r0] 0x25, %r13
	.word 0xdaf689e0  ! 3216: STXA_R	stxa	%r13, [%r26 + %r0] 0x4f
	wr_tick_cmpr_1_26:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf8, %g2
	or	%g4, 0xa4, %g4
	or	%g6, 0xa1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd08fa000  ! 3218: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0x87802020  ! 3219: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bf6000  ! 3220: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd6b5c4a0  ! 3221: STHA_R	stha	%r11, [%r23 + %r0] 0x25
	.word 0xd4ae09e0  ! 3222: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	mov	0x70, %r27
	.word 0xda8cc400  ! 3224: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	.word 0xdcafa000  ! 3225: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	mov	0x7e0, %r20
	mov	0x3c0, %r21
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdaf4c400  ! 3229: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	wr_tick_cmpr_1_27:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xfd, %g2
	or	%g4, 0xba, %g4
	or	%g6, 0xe2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd4b76000  ! 3231: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd4afe000  ! 3232: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 3233: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaccc400  ! 3234: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r13
	mov	0x28, %r19
	.word 0xd2d78e80  ! 3236: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r9
	mov	0x48, %r17
	.word 0xd8a6e000  ! 3238: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 3239: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r24
	.word 0xdaf504a0  ! 3241: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	.word 0xd0f52000  ! 3242: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	mov	0x30, %r24
	.word 0xdea78e80  ! 3244: STWA_R	stwa	%r15, [%r30 + %r0] 0x74
	.word 0xd2b5a000  ! 3245: STHA_I	stha	%r9, [%r22 + 0x0000] %asi
	.word 0xd2bc4400  ! 3246: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0xd096c9e0  ! 3247: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r8
	.word 0xdcbdc4a0  ! 3248: STDA_R	stda	%r14, [%r23 + %r0] 0x25
	.word 0x87802025  ! 3249: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 3250: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d8, %r23
	.word 0xd4bf8e80  ! 3252: STDA_R	stda	%r10, [%r30 + %r0] 0x74
	.word 0xd0ac4400  ! 3253: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0xd6af6000  ! 3254: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd6b544a0  ! 3255: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	mov	0x48, %r24
	.word 0xd0bf4e80  ! 3257: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	.word 0x87802025  ! 3258: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2cda000  ! 3259: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r9
	.word 0xdef5c4a0  ! 3260: STXA_R	stxa	%r15, [%r23 + %r0] 0x25
	.word 0xd0d56000  ! 3261: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r8
	.word 0x87802072  ! 3262: WRASI_I	wr	%r0, 0x0072, %asi
	wr_tick_cmpr_1_28:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xa6, %g2
	or	%g4, 0xcf, %g4
	or	%g6, 0xa3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xd0bc2000  ! 3264: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	.word 0xda8f4e60  ! 3265: LDUBA_R	lduba	[%r29, %r0] 0x73, %r13
	.word 0xd2cc6000  ! 3266: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	mov	0x8, %r16
	.word 0xd8bf8e40  ! 3268: STDA_R	stda	%r12, [%r30 + %r0] 0x72
	.word 0xd8dc2000  ! 3269: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	mov	0x7c0, %r21
	mov	0x8, %r24
	.word 0xd4ce49e0  ! 3272: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r10
	.word 0x87802074  ! 3273: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 3274: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa42000  ! 3275: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	mov	0x8, %r24
	mov	0x3f8, %r20
	.word 0xdabc2000  ! 3278: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xd8b4c400  ! 3279: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0xd4bc2000  ! 3280: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0xd4cc2000  ! 3281: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	mov	0x48, %r18
	.word 0xd087ce40  ! 3283: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r8
	.word 0x8780204f  ! 3284: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcb44400  ! 3285: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	mov	0x30, %r16
	.word 0xd2ccc400  ! 3287: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	.word 0x87802074  ! 3288: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3289: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2af8e60  ! 3290: STBA_R	stba	%r9, [%r30 + %r0] 0x73
	.word 0xd48dc4a0  ! 3291: LDUBA_R	lduba	[%r23, %r0] 0x25, %r10
	.word 0xd8a78e40  ! 3292: STWA_R	stwa	%r12, [%r30 + %r0] 0x72
	.word 0xd8f5e000  ! 3293: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	.word 0x87802073  ! 3294: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8ac6000  ! 3295: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xd88c6000  ! 3296: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	.word 0xd4a74e80  ! 3297: STWA_R	stwa	%r10, [%r29 + %r0] 0x74
	mov	0x58, %r19
	.word 0xd4cc8400  ! 3299: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	.word 0xdac42000  ! 3300: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0xdad649e0  ! 3301: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r13
	.word 0xd4bdc4a0  ! 3302: STDA_R	stda	%r10, [%r23 + %r0] 0x25
	.word 0x87802020  ! 3303: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r22
	mov	0x3c8, %r23
	.word 0xdef76000  ! 3306: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdef7e000  ! 3307: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xde9fa000  ! 3308: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	mov	0x18, %r26
	.word 0xdef4c400  ! 3310: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xd0a76000  ! 3311: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	mov	0x3f0, %r20
	.word 0xd08dc4a0  ! 3313: LDUBA_R	lduba	[%r23, %r0] 0x25, %r8
	.word 0xd097e000  ! 3314: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xd2cf0e80  ! 3315: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r9
	.word 0x87802073  ! 3316: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcdfa000  ! 3317: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	.word 0xd4b78e80  ! 3318: STHA_R	stha	%r10, [%r30 + %r0] 0x74
	.word 0xd0a44400  ! 3319: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xd6d74e40  ! 3320: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r11
	.word 0x87802025  ! 3321: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4c4c400  ! 3322: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r10
	mov	0x0, %r26
	mov	0x3c8, %r22
	.word 0xd6f7e000  ! 3325: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0xd6972000  ! 3327: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	.word 0xd68fa000  ! 3328: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	mov	0x48, %r27
	.word 0xdaa44400  ! 3330: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0xd8af8e40  ! 3331: STBA_R	stba	%r12, [%r30 + %r0] 0x72
	.word 0xd2948400  ! 3332: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	.word 0xd6bcc400  ! 3333: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0xdecf2000  ! 3334: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	wr_tick_cmpr_1_29:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x85, %g2
	or	%g4, 0xf9, %g4
	or	%g6, 0xf0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 3336: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef48400  ! 3337: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xd0b42000  ! 3338: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	mov	0x68, %r19
	.word 0xd0cc6000  ! 3340: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	.word 0xd6dfce80  ! 3341: LDXA_R	ldxa	[%r31, %r0] 0x74, %r11
	.word 0xdad42000  ! 3342: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r13
	.word 0x87802025  ! 3343: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e8, %r21
	.word 0xdaa7e000  ! 3345: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	mov	0x50, %r19
	.word 0xda9fe000  ! 3347: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	mov	0x28, %r26
	.word 0xdac7e000  ! 3349: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0x87802072  ! 3350: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r24
	.word 0xdabca000  ! 3352: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdebdc4a0  ! 3353: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	.word 0xdeac2000  ! 3354: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	mov	0x3d0, %r23
	.word 0xd4f4c400  ! 3356: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	mov	0x38, %r26
	mov	0x38, %r24
	mov	0x10, %r19
	.word 0xda946000  ! 3360: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	mov	0x3c8, %r22
	.word 0xd0f689e0  ! 3362: STXA_R	stxa	%r8, [%r26 + %r0] 0x4f
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd6cc6000  ! 3364: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r11
	.word 0xd0f7ce40  ! 3365: STXA_R	stxa	%r8, [%r31 + %r0] 0x72
	.word 0xd4cf0e80  ! 3366: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r10
	.word 0xd68c6000  ! 3367: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r11
	mov	0x68, %r18
	.word 0xd8af8e40  ! 3369: STBA_R	stba	%r12, [%r30 + %r0] 0x72
	.word 0x8780204f  ! 3370: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebf2000  ! 3371: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xdabfce80  ! 3372: STDA_R	stda	%r13, [%r31 + %r0] 0x74
	.word 0xd0af6000  ! 3373: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd8a78e60  ! 3374: STWA_R	stwa	%r12, [%r30 + %r0] 0x73
	.word 0xdc8fe000  ! 3375: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xd4bfce40  ! 3376: STDA_R	st