// Modified by Princeton University on June 9th, 2015
/*
* ========== Copyright Header Begin ==========================================
* 
* OpenSPARC T1 Processor File: tlu_asi_access_mt_1_rand_31_s2.s
* Copyright (c) 2006 Sun Microsystems, Inc.  All Rights Reserved.
* DO NOT ALTER OR REMOVE COPYRIGHT NOTICES.
* 
* The above named program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License version 2 as published by the Free Software Foundation.
* 
* The above named program is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
* 
* You should have received a copy of the GNU General Public
* License along with this work; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
* 
* ========== Copyright Header End ============================================
*/
/*
********************************************************************************
   random seed:	720271735
   Jal tlu_asi_access_mt_1.j:	
********************************************************************************/



#define PCONTEXT	0x10
#define SCONTEXT	0x10

#define MAIN_PAGE_NUCLEUS_ALSO
#define MAIN_PAGE_HV_ALSO

#define ALL_MY_INTR_HANDLERS
#include "my_intr_handlers.s"
#include "my_trap_handlers.s"
#include "tlu_custom_trap_handlers.s"

#include "enable_traps.h"
#include "boot.s"

.text
.global main

main:

	ta 	%icc, T_CHANGE_HPRIV
	mov	0x123, %g1
	wr	%g0, 0x20, %asi
	stxa	%g1, [0x00] %asi
	stxa	%g1, [0x08] %asi
	stxa	%g1, [0x10] %asi
	stxa	%g1, [0x18] %asi
	stxa	%g1, [0x20] %asi
	stxa	%g1, [0x28] %asi
	stxa	%g1, [0x30] %asi
	stxa	%g1, [0x38] %asi
	ta 	%icc, T_CHANGE_NONHPRIV

! Register init code

	setx 0x9e60a5450000402f, %g1, %g0
	setx 0x831aa1930000e1c4, %g1, %g1
	setx 0x7f51a2710000e0aa, %g1, %g2
	setx 0x95b274e00000a3f3, %g1, %g3
	setx 0x27555006000021e9, %g1, %g4
	setx 0x3d6870690000a0d5, %g1, %g5
	setx 0x0896344200008383, %g1, %g6
	setx 0x420df3ea000023c9, %g1, %g7
	setx 0x789056b80000c1c0, %g1, %r16
	setx 0x0ed2be14000022df, %g1, %r17
	setx 0x03b6b4f50000c1ee, %g1, %r18
	setx 0x8ec789530000019b, %g1, %r19
	setx 0xfaa5524f00008036, %g1, %r20
	setx 0xf13604d10000c147, %g1, %r21
	setx 0x8790f0a70000a22d, %g1, %r22
	setx 0x4d92894c0000a0a5, %g1, %r23
	setx 0x9a33dd20000043ce, %g1, %r24
	setx 0xa40b2b5c0000429d, %g1, %r25
	setx 0xdef3561200008021, %g1, %r26
	setx 0xeee9e7110000e2bb, %g1, %r27
	setx 0x8010abaa0000c250, %g1, %r28
	setx 0x2ca3219b0000a088, %g1, %r29
	setx 0x14ec42a200008018, %g1, %r30
	setx 0x0689eccf000003af, %g1, %r31
	save
	setx 0x3c565f7d0000e1d5, %g1, %r16
	setx 0x58b5ea7600004014, %g1, %r17
	setx 0xaab7cfd80000a1d2, %g1, %r18
	setx 0x58341a890000c123, %g1, %r19
	setx 0x40e7c82e00000038, %g1, %r20
	setx 0xecb7ec240000233b, %g1, %r21
	setx 0x8ea8991b00004344, %g1, %r22
	setx 0xb8c7ca17000042c1, %g1, %r23
	setx 0x7c36f5e000006388, %g1, %r24
	setx 0x5016b27f00004139, %g1, %r25
	setx 0xd0f3412f0000c32c, %g1, %r26
	setx 0xe86f0ca10000e0c5, %g1, %r27
	setx 0x6997de230000432e, %g1, %r28
	setx 0x0e066fbc0000a09b, %g1, %r29
	setx 0x61c88ab000002024, %g1, %r30
	setx 0x80ee870b0000603a, %g1, %r31
	restore
#ifdef PORTABLE_CORE
	mov	PORTABLE_CORE, %g1
	sllx	%g1, 10, %g1
	or	%r8, %g1, %r8
	or	%r9, %g1, %r9
	or	%r10, %g1, %r10
	or	%r11, %g1, %r11
	or	%r12, %g1, %r12
	or	%r13, %g1, %r13
	or	%r14, %g1, %r14
	or	%r15, %g1, %r15
#endif
	mov	0x28, %r16
	mov	0x8, %r17
	mov	0x28, %r18
	mov	0x48, %r19
	mov	0x7e0, %r20
	mov	0x7f8, %r21
	mov	0x7d8, %r22
	mov	0x7d0, %r23
	mov	0x50, %r24
	mov	0x0, %r25
	mov	0x0, %r26
	mov	0x10, %r27
	mov	0, %r28
	mov	0, %r29
	mov	0, %r30
	mov	0, %r31
	ta	%icc, T_CHANGE_HPRIV
	wr	%g0, 0x25, %asi
	stxa	%g0, [%g0] 0x42
	mov	0x38, %g1
	stxa	%g0, [%g1] 0x58
	ta	%icc, T_RD_THID
! fork: source strm = 0xffffffff; target strm = 0x2
	cmp	%o1, 1
	setx	fork_lbl_0_1, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x4
	cmp	%o1, 2
	setx	fork_lbl_0_2, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x8
	cmp	%o1, 3
	setx	fork_lbl_0_3, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
	.word 0xd2ac0400  ! 1: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0xd2d5a000  ! 2: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r9
	.word 0xdcb7ce40  ! 3: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	mov	0x38, %r25
	mov	0x50, %r27
	.word 0xdca5a000  ! 6: STWA_I	stwa	%r14, [%r22 + 0x0000] %asi
	.word 0xdcb44400  ! 7: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0xdcb5e000  ! 8: STHA_I	stha	%r14, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 9: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09fce80  ! 10: LDDA_R	ldda	[%r31, %r0] 0x74, %r8
	mov	0x30, %r17
	.word 0xd0cc6000  ! 12: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	.word 0xd0b46000  ! 13: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 14: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2c74e60  ! 15: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r9
	mov	0x58, %r25
	.word 0xd0b4c400  ! 17: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	mov	0x7c8, %r23
	mov	0x28, %r25
	mov	0x3e8, %r22
	.word 0xd0dd6000  ! 21: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r8
	.word 0xd88cc400  ! 22: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	mov	0x18, %r19
	.word 0xd8dcc400  ! 24: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	mov	0x10, %r27
	.word 0xd8bde000  ! 26: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0xdacf8e40  ! 27: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r13
	.word 0x87802072  ! 28: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab7e000  ! 29: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	mov	0x28, %r16
	.word 0xda8f2000  ! 31: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	mov	0x18, %r24
	.word 0xda8fa000  ! 33: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xda876000  ! 34: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	mov	0x30, %r24
	.word 0x87802025  ! 36: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd89f4e80  ! 37: LDDA_R	ldda	[%r29, %r0] 0x74, %r12
	.word 0xd895e000  ! 38: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r12
	.word 0xdaaf0e80  ! 39: STBA_R	stba	%r13, [%r28 + %r0] 0x74
	.word 0xda852000  ! 40: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r13
	.word 0xda85a000  ! 41: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r13
	.word 0xda8c8400  ! 42: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	.word 0xdab56000  ! 43: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	.word 0xdabde000  ! 44: STDA_I	stda	%r13, [%r23 + 0x0000] %asi
	mov	0x58, %r25
	.word 0x87802020  ! 46: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa42000  ! 47: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0xdaa46000  ! 48: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 49: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaafa000  ! 50: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xd6a48400  ! 51: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0xd6dd44a0  ! 52: LDXA_R	ldxa	[%r21, %r0] 0x25, %r11
	.word 0xd6d72000  ! 53: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r11
	mov	0x7e0, %r23
	.word 0x87802073  ! 55: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6b7a000  ! 56: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd6b76000  ! 57: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd6af6000  ! 58: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0x87802072  ! 60: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd687a000  ! 61: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0xd697a000  ! 62: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	mov	0x30, %r25
	mov	0x68, %r18
	.word 0x87802074  ! 65: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb78e80  ! 66: STHA_R	stha	%r14, [%r30 + %r0] 0x74
	mov	0x0, %r27
	mov	0x7f8, %r23
	.word 0xdcd76000  ! 69: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	mov	0x0, %r16
	mov	0x38, %r24
	.word 0xdc8fe000  ! 72: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xd4af8e80  ! 73: STBA_R	stba	%r10, [%r30 + %r0] 0x74
	.word 0xdca649e0  ! 74: STWA_R	stwa	%r14, [%r25 + %r0] 0x4f
	.word 0xdcf7e000  ! 75: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcaf0e40  ! 76: STBA_R	stba	%r14, [%r28 + %r0] 0x72
	.word 0xd0f7ce60  ! 77: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	mov	0x28, %r16
	.word 0x87802073  ! 79: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 80: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 81: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a5a000  ! 82: STWA_I	stwa	%r8, [%r22 + 0x0000] %asi
	mov	0x7c8, %r22
	.word 0xd0dda000  ! 84: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r8
	.word 0xd0c52000  ! 85: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r8
	.word 0xd0f5e000  ! 86: STXA_I	stxa	%r8, [%r23 + 0x0000] %asi
	mov	0x8, %r24
	.word 0xd0ad2000  ! 88: STBA_I	stba	%r8, [%r20 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xd0bd2000  ! 90: STDA_I	stda	%r8, [%r20 + 0x0000] %asi
	.word 0xd0a52000  ! 91: STWA_I	stwa	%r8, [%r20 + 0x0000] %asi
	.word 0xd89d84a0  ! 92: LDDA_R	ldda	[%r22, %r0] 0x25, %r12
	mov	0x3d8, %r21
	.word 0xdcde09e0  ! 94: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r14
	.word 0xd2a504a0  ! 95: STWA_R	stwa	%r9, [%r20 + %r0] 0x25
	.word 0x87802073  ! 96: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6a689e0  ! 97: STWA_R	stwa	%r11, [%r26 + %r0] 0x4f
	ta	T_CHANGE_PRIV	! macro
	.word 0xd09f0e40  ! 99: LDDA_R	ldda	[%r28, %r0] 0x72, %r8
	.word 0xd6af4e80  ! 100: STBA_R	stba	%r11, [%r29 + %r0] 0x74
	.word 0xd6b76000  ! 101: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 102: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r16
	.word 0xd68ce000  ! 104: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	.word 0xd2bcc400  ! 105: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xd2a46000  ! 106: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd8c6c9e0  ! 107: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r12
	.word 0x87802025  ! 108: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd885e000  ! 109: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r12
	.word 0xd8d5e000  ! 110: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r12
	.word 0x87802073  ! 111: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8a7a000  ! 112: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8af2000  ! 113: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xdec544a0  ! 114: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r15
	.word 0x8780204f  ! 115: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 116: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdedfa000  ! 117: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x30, %r26
	mov	0x3d8, %r21
	.word 0xdedfe000  ! 120: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xdebf6000  ! 121: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xd6cfce60  ! 122: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r11
	mov	0x7c8, %r20
	.word 0xd6f76000  ! 124: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6d7a000  ! 125: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	.word 0xd6d70e80  ! 126: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r11
	.word 0xd6f7e000  ! 127: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6b7a000  ! 128: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd68dc4a0  ! 129: LDUBA_R	lduba	[%r23, %r0] 0x25, %r11
	.word 0xd687a000  ! 130: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	mov	0x7f0, %r22
	.word 0xd6cfe000  ! 132: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	mov	0x7f8, %r22
	.word 0x8780204f  ! 134: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 135: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r17
	.word 0xd6bfe000  ! 137: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd29cc400  ! 138: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	.word 0xd4ad44a0  ! 139: STBA_R	stba	%r10, [%r21 + %r0] 0x25
	.word 0xd0a584a0  ! 140: STWA_R	stwa	%r8, [%r22 + %r0] 0x25
	.word 0xd0a7a000  ! 141: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0dfe000  ! 142: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xd2ac4400  ! 143: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xd2a72000  ! 144: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 145: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd285e000  ! 146: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r9
	mov	0x38, %r17
	mov	0x68, %r16
	.word 0xd2bde000  ! 149: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	.word 0xd2f5e000  ! 150: STXA_I	stxa	%r9, [%r23 + 0x0000] %asi
	mov	0x3c8, %r22
	.word 0xdeafce40  ! 152: STBA_R	stba	%r15, [%r31 + %r0] 0x72
	.word 0x87802073  ! 153: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r27
	.word 0x8780204f  ! 155: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 156: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 157: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef7a000  ! 158: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	mov	0x3d0, %r23
	.word 0xdca504a0  ! 160: STWA_R	stwa	%r14, [%r20 + %r0] 0x25
	mov	0x30, %r26
	.word 0xdccf6000  ! 162: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	mov	0x48, %r25
	.word 0xdc9fe000  ! 164: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xdcc72000  ! 165: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcd7a000  ! 166: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0xdc876000  ! 167: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0x87802020  ! 168: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r19
	.word 0x87802073  ! 170: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8dc0400  ! 171: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0xd8876000  ! 172: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8af6000  ! 173: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd0af0e40  ! 174: STBA_R	stba	%r8, [%r28 + %r0] 0x72
	.word 0xd0cf2000  ! 175: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0x87802074  ! 176: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 177: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r17
	mov	0x20, %r18
	.word 0xd0bc2000  ! 180: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	mov	0x7c8, %r20
	mov	0x0, %r27
	.word 0xd0bc6000  ! 183: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	mov	0x30, %r16
	.word 0xd0cce000  ! 185: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0xde9f4e40  ! 186: LDDA_R	ldda	[%r29, %r0] 0x72, %r15
	mov	0x3c0, %r23
	mov	0x3d0, %r22
	.word 0xdebc6000  ! 189: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xd6b7ce80  ! 190: STHA_R	stha	%r11, [%r31 + %r0] 0x74
	.word 0xdabfce40  ! 191: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	.word 0x87802020  ! 192: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c70e80  ! 193: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r9
	.word 0xdc9d44a0  ! 194: LDDA_R	ldda	[%r21, %r0] 0x25, %r14
	mov	0x68, %r17
	mov	0x40, %r19
	.word 0xdc842000  ! 197: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	.word 0xdccce000  ! 198: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r14
	.word 0xdc8c6000  ! 199: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r14
	.word 0xdcb4a000  ! 200: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 201: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcade000  ! 202: STBA_I	stba	%r14, [%r23 + 0x0000] %asi
	.word 0xdcbd2000  ! 203: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	.word 0xdcb5a000  ! 204: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0xdcc5a000  ! 205: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r14
	.word 0xdc952000  ! 206: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r14
	.word 0xd2874e40  ! 207: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r9
	.word 0xdcdd44a0  ! 208: LDXA_R	ldxa	[%r21, %r0] 0x25, %r14
	.word 0xdc85a000  ! 209: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r14
	mov	0x3f8, %r22
	.word 0x87802025  ! 211: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r27
	.word 0xdc8de000  ! 213: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r14
	.word 0x87802073  ! 214: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r26
	mov	0x68, %r27
	.word 0xdc8f2000  ! 217: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	mov	0x7c0, %r20
	.word 0xd6f649e0  ! 219: STXA_R	stxa	%r11, [%r25 + %r0] 0x4f
	.word 0xdead84a0  ! 220: STBA_R	stba	%r15, [%r22 + %r0] 0x25
	mov	0x18, %r27
	.word 0xdecfce60  ! 222: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r15
	mov	0x48, %r18
	.word 0xded72000  ! 224: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	mov	0x7c0, %r21
	.word 0x87802025  ! 226: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4d70e40  ! 227: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r10
	.word 0x8780204f  ! 228: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 229: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r16
	mov	0x48, %r18
	.word 0xd69f0e40  ! 232: LDDA_R	ldda	[%r28, %r0] 0x72, %r11
	.word 0x87802020  ! 233: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r24
	mov	0x40, %r27
	.word 0xd69ca000  ! 236: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r11
	mov	0x78, %r16
	.word 0xd084c400  ! 238: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r8
	.word 0xd0f4e000  ! 239: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xd8bd04a0  ! 240: STDA_R	stda	%r12, [%r20 + %r0] 0x25
	.word 0x87802072  ! 241: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8bf2000  ! 242: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xdcf70e60  ! 243: STXA_R	stxa	%r14, [%r28 + %r0] 0x73
	.word 0xde9f4e60  ! 244: LDDA_R	ldda	[%r29, %r0] 0x73, %r15
	mov	0x50, %r24
	.word 0x87802073  ! 246: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 247: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49d04a0  ! 248: LDDA_R	ldda	[%r20, %r0] 0x25, %r10
	.word 0xd4a4a000  ! 249: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xd6944400  ! 250: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	.word 0x87802072  ! 251: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbc0400  ! 252: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0x87802025  ! 253: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6ac0400  ! 254: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0xd8b504a0  ! 255: STHA_R	stha	%r12, [%r20 + %r0] 0x25
	mov	0x50, %r16
	.word 0x8780204f  ! 257: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 258: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde878e40  ! 259: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r15
	mov	0x70, %r16
	.word 0xded7a000  ! 261: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xdedf2000  ! 262: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xd4cdc4a0  ! 263: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r10
	.word 0xd4f76000  ! 264: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4bf2000  ! 265: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd4dfe000  ! 266: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd28cc400  ! 267: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	.word 0x87802073  ! 268: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r27
	.word 0xde878e60  ! 270: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r15
	.word 0xded7e000  ! 271: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0x87802072  ! 272: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r17
	.word 0x87802074  ! 274: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bcc400  ! 275: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	mov	0x60, %r24
	.word 0xd68c4400  ! 277: LDUBA_R	lduba	[%r17, %r0] 0x20, %r11
	.word 0xd6bfce80  ! 278: STDA_R	stda	%r11, [%r31 + %r0] 0x74
	mov	0x60, %r16
	.word 0xd6b5c4a0  ! 280: STHA_R	stha	%r11, [%r23 + %r0] 0x25
	.word 0x87802020  ! 281: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 282: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8ce49e0  ! 283: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r12
	.word 0x87802074  ! 284: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8dfa000  ! 285: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	mov	0x50, %r19
	.word 0xd8bf4e80  ! 287: STDA_R	stda	%r12, [%r29 + %r0] 0x74
	.word 0x87802072  ! 288: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4bd44a0  ! 289: STDA_R	stda	%r10, [%r21 + %r0] 0x25
	mov	0x7e8, %r22
	.word 0xde8f0e40  ! 291: LDUBA_R	lduba	[%r28, %r0] 0x72, %r15
	.word 0x87802020  ! 292: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r21
	.word 0xdec4a000  ! 294: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xde9c2000  ! 296: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0x87802025  ! 297: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f6c9e0  ! 298: STXA_R	stxa	%r8, [%r27 + %r0] 0x4f
	.word 0xd0bda000  ! 299: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	.word 0xd085a000  ! 300: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r8
	mov	0x50, %r19
	.word 0xd4afce60  ! 302: STBA_R	stba	%r10, [%r31 + %r0] 0x73
	mov	0x70, %r25
	mov	0x3c0, %r22
	.word 0xd8b70e80  ! 305: STHA_R	stha	%r12, [%r28 + %r0] 0x74
	.word 0x87802073  ! 306: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd89fe000  ! 307: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	mov	0x0, %r18
	.word 0xd8b7a000  ! 309: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xdacfce60  ! 310: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r13
	.word 0xd2974e40  ! 311: LDUHA_R	lduha	[%r29, %r0] 0x72, %r9
	mov	0x70, %r26
	mov	0x0, %r27
	.word 0x87802020  ! 314: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f4e000  ! 315: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xdef78e40  ! 316: STXA_R	stxa	%r15, [%r30 + %r0] 0x72
	mov	0x3f0, %r22
	.word 0xdac40400  ! 318: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	.word 0xd6f40400  ! 319: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	.word 0xd6a609e0  ! 320: STWA_R	stwa	%r11, [%r24 + %r0] 0x4f
	.word 0xd2dc4400  ! 321: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xdccf0e40  ! 322: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r14
	.word 0xdcdca000  ! 323: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xda8ec9e0  ! 324: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r13
	.word 0xd4bdc4a0  ! 325: STDA_R	stda	%r10, [%r23 + %r0] 0x25
	mov	0x3c8, %r23
	.word 0xd48c6000  ! 327: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r10
	.word 0xdcbd04a0  ! 328: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	mov	0x50, %r17
	mov	0x30, %r17
	.word 0xdcf46000  ! 331: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdcaf0e60  ! 332: STBA_R	stba	%r14, [%r28 + %r0] 0x73
	.word 0x87802020  ! 333: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdade49e0  ! 334: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r13
	.word 0xdadc2000  ! 335: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r13
	.word 0xdab74e80  ! 336: STHA_R	stha	%r13, [%r29 + %r0] 0x74
	.word 0xdaf4a000  ! 337: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0xdab42000  ! 338: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xd48ec9e0  ! 339: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r10
	.word 0x8780204f  ! 340: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4de6000  ! 341: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r10
	.word 0xd4cea000  ! 342: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r10
	.word 0xd4ce6000  ! 343: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r10
	.word 0xdca78e60  ! 344: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	.word 0xdc86e000  ! 345: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r14
	.word 0xd4b4c400  ! 346: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0xdc8c8400  ! 347: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0xdcde2000  ! 348: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r14
	.word 0xdcdee000  ! 349: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r14
	.word 0xdcf66000  ! 350: STXA_I	stxa	%r14, [%r25 + 0x0000] %asi
	.word 0xd8b649e0  ! 351: STHA_R	stha	%r12, [%r25 + %r0] 0x4f
	mov	0x3e8, %r23
	.word 0xd8aee000  ! 353: STBA_I	stba	%r12, [%r27 + 0x0000] %asi
	.word 0xd8de2000  ! 354: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r12
	mov	0x8, %r24
	mov	0x50, %r27
	.word 0xd2c44400  ! 357: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	.word 0x87802020  ! 358: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac40400  ! 359: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	.word 0x87802020  ! 360: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdacc4400  ! 361: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	.word 0xda9c2000  ! 362: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	.word 0x87802073  ! 363: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0d74e60  ! 364: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r8
	.word 0x87802073  ! 365: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdedd84a0  ! 366: LDXA_R	ldxa	[%r22, %r0] 0x25, %r15
	mov	0x30, %r26
	.word 0xd6b7ce80  ! 368: STHA_R	stha	%r11, [%r31 + %r0] 0x74
	.word 0xd6d76000  ! 369: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	mov	0x30, %r27
	mov	0x58, %r24
	.word 0x87802020  ! 372: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r22
	.word 0x87802073  ! 374: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f70e80  ! 375: STXA_R	stxa	%r10, [%r28 + %r0] 0x74
	.word 0x87802072  ! 376: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 377: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 378: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4cf2000  ! 379: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0x87802073  ! 380: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r19
	.word 0xdeaf8e40  ! 382: STBA_R	stba	%r15, [%r30 + %r0] 0x72
	.word 0xdedfa000  ! 383: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x3d0, %r23
	.word 0xd8b74e40  ! 385: STHA_R	stha	%r12, [%r29 + %r0] 0x72
	.word 0x87802072  ! 386: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r26
	.word 0xd8f7e000  ! 388: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8976000  ! 389: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	mov	0x28, %r24
	mov	0x18, %r25
	.word 0xd294c400  ! 392: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	mov	0x78, %r24
	mov	0x60, %r16
	.word 0xd496c9e0  ! 395: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r10
	.word 0xd487a000  ! 396: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	.word 0xd8c70e80  ! 397: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r12
	mov	0x30, %r16
	mov	0x20, %r26
	.word 0xd8d76000  ! 400: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xd8872000  ! 401: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	.word 0x87802073  ! 402: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 403: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r25
	.word 0x87802074  ! 405: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdec70e80  ! 406: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r15
	.word 0xde8f6000  ! 407: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	.word 0xd8d48400  ! 408: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0xd897a000  ! 409: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0xdc9dc4a0  ! 410: LDDA_R	ldda	[%r23, %r0] 0x25, %r14
	.word 0x87802020  ! 411: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r16
	.word 0xdad4c400  ! 413: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	mov	0x20, %r17
	mov	0x8, %r17
	.word 0x87802073  ! 416: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4c5c4a0  ! 417: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r10
	mov	0x7d8, %r22
	.word 0xd4afa000  ! 419: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd4b76000  ! 420: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd2dc0400  ! 421: LDXA_R	ldxa	[%r16, %r0] 0x20, %r9
	mov	0x68, %r25
	.word 0xd2d72000  ! 423: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xd4874e40  ! 424: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r10
	.word 0x87802074  ! 425: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4cfe000  ! 426: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0xd4bf6000  ! 427: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd4a7e000  ! 428: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xdc8fce40  ! 429: LDUBA_R	lduba	[%r31, %r0] 0x72, %r14
	.word 0xd2dd04a0  ! 430: LDXA_R	ldxa	[%r20, %r0] 0x25, %r9
	.word 0xdea74e40  ! 431: STWA_R	stwa	%r15, [%r29 + %r0] 0x72
	.word 0xdeb72000  ! 432: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xde8f6000  ! 433: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	.word 0xdedfe000  ! 434: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xdecf0e80  ! 435: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r15
	.word 0xdef7e000  ! 436: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xded72000  ! 437: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0x87802025  ! 438: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6978e60  ! 439: LDUHA_R	lduha	[%r30, %r0] 0x73, %r11
	mov	0x3d0, %r21
	.word 0xded78e60  ! 441: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r15
	.word 0x87802025  ! 442: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r18
	.word 0xdebd6000  ! 444: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	mov	0x68, %r18
	.word 0xd6dec9e0  ! 446: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r11
	.word 0xdc97ce40  ! 447: LDUHA_R	lduha	[%r31, %r0] 0x72, %r14
	.word 0xdcb7ce80  ! 448: STHA_R	stha	%r14, [%r31 + %r0] 0x74
	.word 0x87802074  ! 449: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d8, %r21
	mov	0x3e0, %r21
	.word 0xdcb72000  ! 452: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xd6d70e40  ! 453: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r11
	.word 0xd6f76000  ! 454: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6f7a000  ! 455: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd69fe000  ! 456: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	mov	0x3d8, %r22
	mov	0x18, %r16
	.word 0xd6bc8400  ! 459: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xd4f74e40  ! 460: STXA_R	stxa	%r10, [%r29 + %r0] 0x72
	.word 0xd4bf6000  ! 461: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	mov	0x20, %r19
	mov	0x7e8, %r21
	.word 0xd49fa000  ! 464: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0xd487a000  ! 465: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	.word 0xdaa7ce40  ! 466: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	.word 0xdaa7a000  ! 467: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xdadfe000  ! 468: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0xdaac8400  ! 469: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	mov	0x40, %r16
	.word 0xdad72000  ! 471: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0xdaf74e60  ! 472: STXA_R	stxa	%r13, [%r29 + %r0] 0x73
	.word 0xdcf74e40  ! 473: STXA_R	stxa	%r14, [%r29 + %r0] 0x72
	.word 0xdcf7a000  ! 474: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xd88f8e60  ! 475: LDUBA_R	lduba	[%r30, %r0] 0x73, %r12
	.word 0xd8a7a000  ! 476: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 477: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f8, %r21
	mov	0x3e0, %r21
	.word 0xdaf504a0  ! 480: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	.word 0xdaa62000  ! 481: STWA_I	stwa	%r13, [%r24 + 0x0000] %asi
	mov	0x10, %r24
	.word 0xdaa62000  ! 483: STWA_I	stwa	%r13, [%r24 + 0x0000] %asi
	mov	0x18, %r17
	mov	0x28, %r25
	mov	0x7e8, %r21
	.word 0xda9ee000  ! 487: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r13
	mov	0x7d0, %r22
	mov	0x7c8, %r21
	.word 0xdaa6e000  ! 490: STWA_I	stwa	%r13, [%r27 + 0x0000] %asi
	.word 0xdaf66000  ! 491: STXA_I	stxa	%r13, [%r25 + 0x0000] %asi
	.word 0xdaa66000  ! 492: STWA_I	stwa	%r13, [%r25 + 0x0000] %asi
	.word 0xdace6000  ! 493: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r13
	.word 0xda8e6000  ! 494: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r13
	.word 0x87802025  ! 495: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r25
	.word 0xd8d74e60  ! 497: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r12
	mov	0x58, %r17
	.word 0xd8dda000  ! 499: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r12
	mov	0x3d0, %r20
	.word 0xd69609e0  ! 501: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r11
	mov	0x60, %r25
	mov	0x18, %r17
	.word 0xde944400  ! 504: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	.word 0xd4a78e60  ! 505: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	.word 0xdcf7ce60  ! 506: STXA_R	stxa	%r14, [%r31 + %r0] 0x73
	.word 0x87802073  ! 507: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6af8e40  ! 508: STBA_R	stba	%r11, [%r30 + %r0] 0x72
	.word 0xd6af6000  ! 509: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	mov	0x68, %r17
	mov	0x7e0, %r23
	.word 0xd68fa000  ! 512: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0xd2aec9e0  ! 513: STBA_R	stba	%r9, [%r27 + %r0] 0x4f
	.word 0xd2872000  ! 514: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	.word 0xde974e60  ! 515: LDUHA_R	lduha	[%r29, %r0] 0x73, %r15
	.word 0xd8c40400  ! 516: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	.word 0xd4f6c9e0  ! 517: STXA_R	stxa	%r10, [%r27 + %r0] 0x4f
	mov	0x40, %r16
	.word 0xd4c7a000  ! 519: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	mov	0x28, %r17
	mov	0x7c0, %r21
	.word 0xd4c76000  ! 522: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	.word 0xd2c689e0  ! 523: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r9
	.word 0x87802020  ! 524: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dc2000  ! 525: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r9
	.word 0xd2bce000  ! 526: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xd4b609e0  ! 527: STHA_R	stha	%r10, [%r24 + %r0] 0x4f
	.word 0xdc9544a0  ! 528: LDUHA_R	lduha	[%r21, %r0] 0x25, %r14
	.word 0xdcd42000  ! 529: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	mov	0x3d8, %r22
	.word 0x87802072  ! 531: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc840400  ! 532: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	mov	0x50, %r19
	mov	0x7c0, %r20
	.word 0xdc872000  ! 535: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xdc8f6000  ! 536: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdef74e80  ! 537: STXA_R	stxa	%r15, [%r29 + %r0] 0x74
	.word 0xde8f6000  ! 538: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdea76000  ! 540: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	mov	0x38, %r16
	mov	0x3c8, %r21
	.word 0xdeb76000  ! 543: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	mov	0x70, %r16
	.word 0xde9fe000  ! 545: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0xdaf78e80  ! 546: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	.word 0xda8fe000  ! 547: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	mov	0x50, %r16
	mov	0x50, %r16
	.word 0xdeaf8e80  ! 550: STBA_R	stba	%r15, [%r30 + %r0] 0x74
	mov	0x20, %r27
	.word 0x87802073  ! 552: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdebf2000  ! 553: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	mov	0x18, %r27
	.word 0x87802072  ! 555: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cc0400  ! 556: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r10
	.word 0x87802025  ! 557: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 558: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcac0400  ! 559: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xdaa609e0  ! 560: STWA_R	stwa	%r13, [%r24 + %r0] 0x4f
	.word 0xdabea000  ! 561: STDA_I	stda	%r13, [%r26 + 0x0000] %asi
	.word 0xdabf8e80  ! 562: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	.word 0xd08f4e60  ! 563: LDUBA_R	lduba	[%r29, %r0] 0x73, %r8
	.word 0xd2f70e80  ! 564: STXA_R	stxa	%r9, [%r28 + %r0] 0x74
	.word 0xd2be2000  ! 565: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	mov	0x78, %r24
	.word 0xd8b584a0  ! 567: STHA_R	stha	%r12, [%r22 + %r0] 0x25
	.word 0xd8bea000  ! 568: STDA_I	stda	%r12, [%r26 + 0x0000] %asi
	mov	0x3d0, %r21
	.word 0x87802020  ! 570: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29c0400  ! 571: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	.word 0xd2d46000  ! 572: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	.word 0xd2aca000  ! 573: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0xd2a4a000  ! 574: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0xd8b74e60  ! 575: STHA_R	stha	%r12, [%r29 + %r0] 0x73
	.word 0xdebc4400  ! 576: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	mov	0x7c8, %r20
	.word 0x87802073  ! 578: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd097ce60  ! 579: LDUHA_R	lduha	[%r31, %r0] 0x73, %r8
	.word 0xd0f7a000  ! 580: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0df2000  ! 581: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0x87802025  ! 582: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r24
	.word 0xd0a5e000  ! 584: STWA_I	stwa	%r8, [%r23 + 0x0000] %asi
	.word 0xdaf48400  ! 585: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xd0bf0e40  ! 586: STDA_R	stda	%r8, [%r28 + %r0] 0x72
	.word 0xd0af8e60  ! 587: STBA_R	stba	%r8, [%r30 + %r0] 0x73
	.word 0xd0a5e000  ! 588: STWA_I	stwa	%r8, [%r23 + 0x0000] %asi
	.word 0xded6c9e0  ! 589: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r15
	mov	0x70, %r18
	.word 0xde9d6000  ! 591: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r15
	.word 0xdef5e000  ! 592: STXA_I	stxa	%r15, [%r23 + 0x0000] %asi
	.word 0xdeb52000  ! 593: STHA_I	stha	%r15, [%r20 + 0x0000] %asi
	.word 0xde952000  ! 594: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r15
	.word 0xded5e000  ! 595: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r15
	.word 0xdc9f4e40  ! 596: LDDA_R	ldda	[%r29, %r0] 0x72, %r14
	.word 0xdcdde000  ! 597: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	.word 0xdc9d6000  ! 598: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r14
	.word 0xd4a504a0  ! 599: STWA_R	stwa	%r10, [%r20 + %r0] 0x25
	.word 0x87802073  ! 600: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r16
	.word 0xdac70e60  ! 602: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r13
	mov	0x20, %r19
	.word 0xdaf7e000  ! 604: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	mov	0x38, %r19
	.word 0xdaa7a000  ! 606: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xdaf7e000  ! 607: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xdab7a000  ! 608: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	mov	0x20, %r24
	.word 0xda8f2000  ! 610: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	mov	0x20, %r18
	mov	0x7c8, %r20
	mov	0x48, %r26
	.word 0xdaa40400  ! 614: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0xdad44400  ! 615: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	ta	T_CHANGE_PRIV	! macro
	.word 0xd28584a0  ! 617: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r9
	.word 0xd2af6000  ! 618: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 619: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2dde000  ! 620: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r9
	.word 0xd2a5e000  ! 621: STWA_I	stwa	%r9, [%r23 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xd2f5e000  ! 623: STXA_I	stxa	%r9, [%r23 + 0x0000] %asi
	.word 0xd2a5a000  ! 624: STWA_I	stwa	%r9, [%r22 + 0x0000] %asi
	mov	0x40, %r18
	.word 0xd4978e80  ! 626: LDUHA_R	lduha	[%r30, %r0] 0x74, %r10
	.word 0xd88c0400  ! 627: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	.word 0xd885a000  ! 628: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r12
	.word 0xd8a5e000  ! 629: STWA_I	stwa	%r12, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 630: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 631: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r25
	.word 0xd8dce000  ! 633: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	.word 0xda974e60  ! 634: LDUHA_R	lduha	[%r29, %r0] 0x73, %r13
	.word 0xd89c8400  ! 635: LDDA_R	ldda	[%r18, %r0] 0x20, %r12
	mov	0x18, %r24
	.word 0xd0940400  ! 637: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	.word 0xd8ac0400  ! 638: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xdec74e80  ! 639: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r15
	.word 0xdeaca000  ! 640: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	mov	0x3c0, %r20
	mov	0x3c0, %r22
	.word 0xde94a000  ! 643: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0xded4a000  ! 644: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	mov	0x18, %r17
	mov	0x78, %r25
	mov	0x7d8, %r23
	.word 0x8780204f  ! 648: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd487ce40  ! 649: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r10
	.word 0xd4f66000  ! 650: STXA_I	stxa	%r10, [%r25 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd4b6a000  ! 652: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 653: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf4c400  ! 654: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xda8ce000  ! 655: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	.word 0xda84e000  ! 656: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r13
	.word 0x87802074  ! 657: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd48d04a0  ! 658: LDUBA_R	lduba	[%r20, %r0] 0x25, %r10
	.word 0x87802074  ! 659: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4cf6000  ! 660: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0xd0bfce40  ! 661: STDA_R	stda	%r8, [%r31 + %r0] 0x72
	.word 0xd0a7e000  ! 662: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	mov	0x7d0, %r22
	mov	0x20, %r27
	.word 0xd6f78e40  ! 665: STXA_R	stxa	%r11, [%r30 + %r0] 0x72
	.word 0xd6afe000  ! 666: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd0d4c400  ! 667: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	.word 0xd08fa000  ! 668: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0xd6d7ce40  ! 669: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r11
	mov	0x58, %r27
	.word 0xd6a7e000  ! 671: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	mov	0x20, %r16
	.word 0xdcbcc400  ! 673: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xdcdfa000  ! 674: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	mov	0x60, %r17
	.word 0xde9f0e40  ! 676: LDDA_R	ldda	[%r28, %r0] 0x72, %r15
	.word 0xdca78e40  ! 677: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	.word 0xd2944400  ! 678: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	.word 0xd29fe000  ! 679: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd2dfe000  ! 680: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0x87802020  ! 681: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a74e40  ! 682: STWA_R	stwa	%r12, [%r29 + %r0] 0x72
	mov	0x28, %r27
	.word 0xdeaf0e40  ! 684: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	.word 0xde870e80  ! 685: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r15
	.word 0xd0b74e60  ! 686: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	.word 0x87802072  ! 687: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7c0, %r20
	.word 0xd0cfe000  ! 689: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xd0cfe000  ! 690: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xd097e000  ! 691: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0d7e000  ! 692: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xd4f44400  ! 693: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0xd4bf2000  ! 694: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd4b70e80  ! 695: STHA_R	stha	%r10, [%r28 + %r0] 0x74
	.word 0xd4dfa000  ! 696: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	mov	0x58, %r25
	.word 0xd29649e0  ! 698: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r9
	mov	0x28, %r27
	mov	0x58, %r24
	.word 0xd2bfe000  ! 701: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd8cd04a0  ! 702: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r12
	.word 0xd8d76000  ! 703: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	mov	0x3c0, %r20
	.word 0x8780204f  ! 705: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8966000  ! 706: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r12
	mov	0x68, %r17
	.word 0xd4dcc400  ! 708: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0xd4be6000  ! 709: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0xd48ee000  ! 710: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r10
	.word 0x87802072  ! 711: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7c8, %r22
	mov	0x8, %r24
	.word 0x87802025  ! 714: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4bd2000  ! 715: STDA_I	stda	%r10, [%r20 + 0x0000] %asi
	mov	0x8, %r17
	.word 0xd4b52000  ! 717: STHA_I	stha	%r10, [%r20 + 0x0000] %asi
	mov	0x50, %r27
	.word 0xd49d6000  ! 719: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r10
	.word 0xd48da000  ! 720: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r10
	.word 0xd4dda000  ! 721: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r10
	.word 0xd0bc4400  ! 722: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xd0dda000  ! 723: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r8
	.word 0xd8af4e40  ! 724: STBA_R	stba	%r12, [%r29 + %r0] 0x72
	.word 0xd8cc8400  ! 725: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0xd8c5e000  ! 726: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r12
	.word 0x87802020  ! 727: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 728: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6c44400  ! 729: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r11
	mov	0x48, %r17
	.word 0xd6afe000  ! 731: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xda878e40  ! 732: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r13
	.word 0xd2cf8e40  ! 733: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r9
	.word 0x87802020  ! 734: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r22
	.word 0x8780204f  ! 736: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2cea000  ! 737: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r9
	.word 0xd68cc400  ! 738: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	.word 0xd6f66000  ! 739: STXA_I	stxa	%r11, [%r25 + 0x0000] %asi
	.word 0xd0b40400  ! 740: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0xd0962000  ! 741: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r8
	.word 0xd08e6000  ! 742: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r8
	mov	0x18, %r27
	mov	0x40, %r26
	mov	0x58, %r26
	mov	0x30, %r17
	.word 0xdeb70e80  ! 747: STHA_R	stha	%r15, [%r28 + %r0] 0x74
	.word 0xdec62000  ! 748: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r15
	mov	0x3c0, %r22
	mov	0x50, %r19
	.word 0xdeb62000  ! 751: STHA_I	stha	%r15, [%r24 + 0x0000] %asi
	mov	0x40, %r24
	.word 0xd6af0e40  ! 753: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	.word 0xd4cfce80  ! 754: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r10
	.word 0xd4be6000  ! 755: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0x8780204f  ! 756: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f66000  ! 757: STXA_I	stxa	%r10, [%r25 + 0x0000] %asi
	.word 0x87802025  ! 758: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f0, %r21
	mov	0x18, %r19
	.word 0xd6bfce80  ! 761: STDA_R	stda	%r11, [%r31 + %r0] 0x74
	.word 0xd6bd6000  ! 762: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	mov	0x60, %r17
	.word 0xd4b7ce40  ! 764: STHA_R	stha	%r10, [%r31 + %r0] 0x72
	.word 0xdc8c4400  ! 765: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	mov	0x0, %r24
	mov	0x58, %r17
	.word 0xdcdda000  ! 768: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r14
	mov	0x58, %r17
	.word 0xdcad2000  ! 770: STBA_I	stba	%r14, [%r20 + 0x0000] %asi
	.word 0xdcf44400  ! 771: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xde96c9e0  ! 772: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r15
	.word 0xde878e80  ! 773: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r15
	.word 0xd6b40400  ! 774: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xde970e80  ! 775: LDUHA_R	lduha	[%r28, %r0] 0x74, %r15
	mov	0x78, %r26
	mov	0x10, %r26
	.word 0xdec5e000  ! 778: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r15
	.word 0xdef56000  ! 779: STXA_I	stxa	%r15, [%r21 + 0x0000] %asi
	.word 0xdea52000  ! 780: STWA_I	stwa	%r15, [%r20 + 0x0000] %asi
	.word 0x87802025  ! 781: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdccf0e60  ! 782: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r14
	.word 0xda940400  ! 783: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	.word 0x87802020  ! 784: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r20
	.word 0xda9ce000  ! 786: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r13
	.word 0xdab42000  ! 787: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	mov	0x58, %r26
	.word 0xdaadc4a0  ! 789: STBA_R	stba	%r13, [%r23 + %r0] 0x25
	mov	0x8, %r19
	.word 0xdadce000  ! 791: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xdea48400  ! 792: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xd28e49e0  ! 793: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r9
	.word 0x87802020  ! 794: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4874e80  ! 795: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r10
	.word 0xd4a42000  ! 796: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0xd4c4e000  ! 797: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r10
	.word 0xd0d48400  ! 798: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	.word 0xd0c42000  ! 799: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r8
	.word 0xd0dce000  ! 800: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r8
	.word 0xd49c0400  ! 801: LDDA_R	ldda	[%r16, %r0] 0x20, %r10
	.word 0xd4b4a000  ! 802: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 803: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 804: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r25
	.word 0xd4bfe000  ! 806: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0xd69c8400  ! 808: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	.word 0xd88f0e80  ! 809: LDUBA_R	lduba	[%r28, %r0] 0x74, %r12
	.word 0x87802073  ! 810: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8c7a000  ! 811: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xd6a70e40  ! 812: STWA_R	stwa	%r11, [%r28 + %r0] 0x72
	.word 0xded74e80  ! 813: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r15
	.word 0xdeaf2000  ! 814: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xdebf6000  ! 815: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xde972000  ! 816: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0x87802072  ! 817: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2bc0400  ! 818: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xd2af6000  ! 819: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd2df6000  ! 820: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2b7a000  ! 821: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	mov	0x3e0, %r20
	mov	0x10, %r16
	.word 0xd2f7e000  ! 824: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0x87802074  ! 826: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b649e0  ! 827: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	mov	0x3c0, %r20
	.word 0xdc9f0e40  ! 829: LDDA_R	ldda	[%r28, %r0] 0x72, %r14
	.word 0xdcf7a000  ! 830: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x8, %r25
	.word 0xdc8f4e80  ! 832: LDUBA_R	lduba	[%r29, %r0] 0x74, %r14
	.word 0x8780204f  ! 833: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 834: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 835: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcafe000  ! 836: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdc878e40  ! 837: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r14
	.word 0xdcf7e000  ! 838: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x38, %r19
	.word 0xdcdfa000  ! 840: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	.word 0xdca72000  ! 841: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdc876000  ! 842: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0xd2940400  ! 843: LDUHA_R	lduha	[%r16, %r0] 0x20, %r9
	.word 0x87802072  ! 844: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r17
	.word 0x87802020  ! 846: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab78e60  ! 847: STHA_R	stha	%r13, [%r30 + %r0] 0x73
	.word 0xdaa46000  ! 848: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0x87802020  ! 850: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 851: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r27
	.word 0x87802072  ! 853: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa7a000  ! 854: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xdacf6000  ! 855: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	mov	0x3c8, %r21
	.word 0xd6940400  ! 857: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	.word 0xd88f8e40  ! 858: LDUBA_R	lduba	[%r30, %r0] 0x72, %r12
	.word 0xd89609e0  ! 859: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r12
	.word 0xd8cf2000  ! 860: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	mov	0x70, %r24
	mov	0x48, %r17
	.word 0xd8cfa000  ! 863: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	mov	0x18, %r17
	mov	0x60, %r24
	.word 0x87802020  ! 866: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 867: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb70e80  ! 868: STHA_R	stha	%r15, [%r28 + %r0] 0x74
	.word 0xdeb5a000  ! 869: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	mov	0x68, %r16
	.word 0x87802073  ! 871: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 872: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdedee000  ! 873: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r15
	.word 0xd8c4c400  ! 874: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r12
	.word 0xdcd48400  ! 875: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	.word 0x87802073  ! 876: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6de89e0  ! 877: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r11
	.word 0xd6b7e000  ! 878: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd6d649e0  ! 879: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r11
	.word 0xd6bf6000  ! 880: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0xd6a72000  ! 882: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 883: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 884: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6afa000  ! 885: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd49f4e60  ! 886: LDDA_R	ldda	[%r29, %r0] 0x73, %r10
	.word 0xd4dfa000  ! 887: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	mov	0x28, %r27
	.word 0xd4b7a000  ! 889: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd2d504a0  ! 890: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r9
	mov	0x78, %r19
	.word 0x87802074  ! 892: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 893: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda87ce60  ! 894: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r13
	mov	0x3d8, %r23
	mov	0x50, %r27
	.word 0x87802072  ! 897: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbc0400  ! 898: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0x87802020  ! 899: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca46000  ! 900: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xdc946000  ! 901: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 902: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdca6e000  ! 903: STWA_I	stwa	%r14, [%r27 + 0x0000] %asi
	mov	0x7c0, %r22
	.word 0xdcdea000  ! 905: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r14
	mov	0x10, %r26
	.word 0xdcbee000  ! 907: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	mov	0x7e8, %r23
	mov	0x3c0, %r23
	.word 0xdc962000  ! 910: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r14
	.word 0xd0f6c9e0  ! 911: STXA_R	stxa	%r8, [%r27 + %r0] 0x4f
	mov	0x7f8, %r20
	.word 0x87802020  ! 913: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bca000  ! 914: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 915: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bf4e40  ! 916: STDA_R	stda	%r9, [%r29 + %r0] 0x72
	.word 0xd2b5a000  ! 917: STHA_I	stha	%r9, [%r22 + 0x0000] %asi
	.word 0xd2b56000  ! 918: STHA_I	stha	%r9, [%r21 + 0x0000] %asi
	.word 0xd2dde000  ! 919: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r9
	.word 0xda8cc400  ! 920: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	.word 0xda856000  ! 921: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r13
	.word 0xd0b74e80  ! 922: STHA_R	stha	%r8, [%r29 + %r0] 0x74
	.word 0xd4afce60  ! 923: STBA_R	stba	%r10, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 924: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a44400  ! 925: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	mov	0x3e0, %r22
	mov	0x78, %r26
	mov	0x68, %r17
	.word 0xd4de6000  ! 929: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r10
	mov	0x7f0, %r20
	.word 0xd4b6a000  ! 931: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	mov	0x48, %r16
	.word 0xd4c6a000  ! 933: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r10
	.word 0xde95c4a0  ! 934: LDUHA_R	lduha	[%r23, %r0] 0x25, %r15
	.word 0x87802074  ! 935: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6c689e0  ! 936: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r11
	.word 0x87802072  ! 937: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde874e60  ! 938: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r15
	.word 0xd6dd84a0  ! 939: LDXA_R	ldxa	[%r22, %r0] 0x25, %r11
	mov	0x10, %r25
	mov	0x3d8, %r21
	mov	0x38, %r24
	mov	0x3d0, %r20
	.word 0xd6c7e000  ! 944: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6876000  ! 945: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6dfa000  ! 946: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0xd4c6c9e0  ! 947: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r10
	mov	0x60, %r19
	mov	0x38, %r26
	ta	T_CHANGE_PRIV	! macro
	mov	0x10, %r16
	.word 0xd4cfa000  ! 952: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	mov	0x28, %r27
	.word 0x87802020  ! 954: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb44400  ! 955: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 956: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4d609e0  ! 957: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r10
	mov	0x8, %r24
	.word 0xd4be2000  ! 959: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0df0e40  ! 961: LDXA_R	ldxa	[%r28, %r0] 0x72, %r8
	.word 0xd0be6000  ! 962: STDA_I	stda	%r8, [%r25 + 0x0000] %asi
	.word 0xd0f689e0  ! 963: STXA_R	stxa	%r8, [%r26 + %r0] 0x4f
	.word 0xdebfce40  ! 964: STDA_R	stda	%r15, [%r31 + %r0] 0x72
	mov	0x8, %r27
	.word 0x87802020  ! 966: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdec4e000  ! 967: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	mov	0x8, %r27
	mov	0x28, %r16
	.word 0xde9ce000  ! 970: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0x87802025  ! 971: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde9da000  ! 972: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r15
	.word 0xd6d74e40  ! 973: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r11
	.word 0xd8cc0400  ! 974: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	.word 0xdcf4c400  ! 975: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xdcd56000  ! 976: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r14
	.word 0xd6a74e40  ! 977: STWA_R	stwa	%r11, [%r29 + %r0] 0x72
	.word 0xdca504a0  ! 978: STWA_R	stwa	%r14, [%r20 + %r0] 0x25
	.word 0xdcbd6000  ! 979: STDA_I	stda	%r14, [%r21 + 0x0000] %asi
	.word 0xdccde000  ! 980: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r14
	.word 0xd2d48400  ! 981: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	.word 0xd295e000  ! 982: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r9
	.word 0xdeb74e60  ! 983: STHA_R	stha	%r15, [%r29 + %r0] 0x73
	.word 0xd2d7ce80  ! 984: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r9
	.word 0xd2f56000  ! 985: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	.word 0xdcc70e80  ! 986: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r14
	mov	0x50, %r27
	.word 0xdcf5a000  ! 988: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	.word 0xd8cec9e0  ! 989: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r12
	.word 0xdaf78e80  ! 990: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	.word 0xda8d2000  ! 991: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r13
	.word 0x87802073  ! 992: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r26
	.word 0xdaafa000  ! 994: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 995: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdab52000  ! 996: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	.word 0xd2ac0400  ! 997: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0xd48649e0  ! 998: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r10
	.word 0xd4bde000  ! 999: STDA_I	stda	%r10, [%r23 + 0x0000] %asi
	.word 0xdebec9e0  ! 1000: STDA_R	stda	%r15, [%r27 + %r0] 0x4f
	mov	0x58, %r16
	.word 0x87802074  ! 1002: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3f0, %r22
	.word 0xd0d48400  ! 1004: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	.word 0xd8df4e80  ! 1005: LDXA_R	ldxa	[%r29, %r0] 0x74, %r12
	.word 0xdca40400  ! 1006: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xdcb7e000  ! 1007: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 1008: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r17
	.word 0xdcf52000  ! 1010: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	.word 0xd6f584a0  ! 1011: STXA_R	stxa	%r11, [%r22 + %r0] 0x25
	.word 0xd6d56000  ! 1012: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r11
	.word 0xdca7ce60  ! 1013: STWA_R	stwa	%r14, [%r31 + %r0] 0x73
	.word 0xdcdde000  ! 1014: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	.word 0xdcb5a000  ! 1015: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0xdcade000  ! 1016: STBA_I	stba	%r14, [%r23 + 0x0000] %asi
	.word 0x87802073  ! 1017: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r27
	.word 0xdcbf6000  ! 1019: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdc87a000  ! 1020: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcdf6000  ! 1021: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	mov	0x50, %r24
	.word 0xdcbfa000  ! 1023: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	mov	0x3f0, %r20
	.word 0xd68f4e80  ! 1025: LDUBA_R	lduba	[%r29, %r0] 0x74, %r11
	.word 0xd6b649e0  ! 1026: STHA_R	stha	%r11, [%r25 + %r0] 0x4f
	.word 0xd6cf4e80  ! 1027: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r11
	mov	0x20, %r19
	.word 0x87802025  ! 1029: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 1030: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r18
	.word 0xd0ae49e0  ! 1032: STBA_R	stba	%r8, [%r25 + %r0] 0x4f
	mov	0x40, %r19
	mov	0x18, %r18
	mov	0x40, %r24
	.word 0xd6bf0e60  ! 1036: STDA_R	stda	%r11, [%r28 + %r0] 0x73
	.word 0xdc874e40  ! 1037: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r14
	mov	0x28, %r17
	mov	0x8, %r17
	.word 0xdcdd6000  ! 1040: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 1041: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f504a0  ! 1042: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0xdc9584a0  ! 1043: LDUHA_R	lduha	[%r22, %r0] 0x25, %r14
	.word 0x87802074  ! 1044: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf76000  ! 1045: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdc8f6000  ! 1046: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xd8b78e80  ! 1047: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	.word 0x87802020  ! 1048: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a46000  ! 1049: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xd884e000  ! 1050: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r12
	.word 0xd884e000  ! 1051: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r12
	.word 0xd8f4e000  ! 1052: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xdad504a0  ! 1053: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r13
	.word 0xd4cfce40  ! 1054: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r10
	.word 0x8780204f  ! 1055: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b6a000  ! 1056: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	.word 0xd4ae6000  ! 1057: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0xd4b6e000  ! 1058: STHA_I	stha	%r10, [%r27 + 0x0000] %asi
	.word 0xd4ce2000  ! 1059: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r10
	.word 0xdeb609e0  ! 1060: STHA_R	stha	%r15, [%r24 + %r0] 0x4f
	.word 0xd4dc4400  ! 1061: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	.word 0x87802020  ! 1062: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cce000  ! 1063: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1064: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadc8400  ! 1065: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	mov	0x38, %r17
	.word 0xdad42000  ! 1067: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r13
	.word 0xd4a78e60  ! 1068: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	.word 0xd49c6000  ! 1069: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0x87802025  ! 1070: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad44400  ! 1071: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0xdadd6000  ! 1072: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r13
	mov	0x8, %r17
	.word 0x87802074  ! 1074: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4c70e80  ! 1075: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r10
	.word 0x87802020  ! 1076: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1077: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcdf0e40  ! 1078: LDXA_R	ldxa	[%r28, %r0] 0x72, %r14
	.word 0xdcbfe000  ! 1079: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0xd0b4c400  ! 1081: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0xd0944400  ! 1082: LDUHA_R	lduha	[%r17, %r0] 0x20, %r8
	.word 0xd4cf4e80  ! 1083: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r10
	.word 0xd49c8400  ! 1084: LDDA_R	ldda	[%r18, %r0] 0x20, %r10
	.word 0xdcbc0400  ! 1085: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0xdcc76000  ! 1086: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xd8bf8e40  ! 1087: STDA_R	stda	%r12, [%r30 + %r0] 0x72
	.word 0xdeac4400  ! 1088: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0xdecfe000  ! 1089: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	mov	0x8, %r27
	.word 0xd2cf4e80  ! 1091: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r9
	.word 0xdab609e0  ! 1092: STHA_R	stha	%r13, [%r24 + %r0] 0x4f
	.word 0xd4bd44a0  ! 1093: STDA_R	stda	%r10, [%r21 + %r0] 0x25
	mov	0x38, %r19
	.word 0xd4dfa000  ! 1095: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 1096: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1097: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1098: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6948400  ! 1099: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	mov	0x3e0, %r23
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6b76000  ! 1102: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 1103: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8c78e60  ! 1104: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r12
	.word 0x87802073  ! 1105: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r19
	.word 0xd8af2000  ! 1107: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1108: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x3d0, %r22
	.word 0xd2ac4400  ! 1111: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	mov	0x20, %r18
	.word 0x8780204f  ! 1113: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6bc0400  ! 1114: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0x87802073  ! 1115: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8c48400  ! 1116: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	.word 0xd887e000  ! 1117: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8c7a000  ! 1118: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8b76000  ! 1119: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd89f2000  ! 1120: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0xd8af6000  ! 1121: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xd8d7e000  ! 1123: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0xdab40400  ! 1124: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	mov	0x8, %r24
	mov	0x70, %r18
	.word 0xd6f44400  ! 1127: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0xd4b74e80  ! 1128: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	.word 0xd48f2000  ! 1129: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd49fa000  ! 1130: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0xd4b7a000  ! 1131: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xd4b40400  ! 1133: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 1134: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 1135: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r18
	.word 0x87802073  ! 1137: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd487e000  ! 1138: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4afa000  ! 1139: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	mov	0x48, %r16
	mov	0x3f8, %r22
	.word 0xd294c400  ! 1142: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	.word 0xdaae49e0  ! 1143: STBA_R	stba	%r13, [%r25 + %r0] 0x4f
	.word 0xd2bcc400  ! 1144: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xdc94c400  ! 1145: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	mov	0x7e8, %r20
	.word 0xdcae89e0  ! 1147: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	.word 0xdc9fe000  ! 1148: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xdcb72000  ! 1149: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xd4f7ce60  ! 1150: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	mov	0x10, %r25
	.word 0x87802073  ! 1152: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b7e000  ! 1153: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd49fa000  ! 1154: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x8, %r19
	mov	0x60, %r18
	mov	0x40, %r24
	.word 0xd49fa000  ! 1159: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 1160: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4be2000  ! 1161: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	.word 0xd4c62000  ! 1162: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r10
	.word 0xd28544a0  ! 1163: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r9
	.word 0x87802074  ! 1164: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c8, %r20
	mov	0x8, %r16
	.word 0xd29fa000  ! 1167: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd2a72000  ! 1168: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0xdef4c400  ! 1169: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0x87802073  ! 1170: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd48f0e40  ! 1171: LDUBA_R	lduba	[%r28, %r0] 0x72, %r10
	mov	0x7f0, %r23
	mov	0x58, %r18
	.word 0xd4944400  ! 1174: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	.word 0xd4c72000  ! 1175: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r10
	.word 0xdcac4400  ! 1176: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	.word 0x87802020  ! 1177: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r24
	.word 0xd6c544a0  ! 1179: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r11
	.word 0xd6bc6000  ! 1180: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0xd6bc6000  ! 1181: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0xd6b46000  ! 1182: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd694e000  ! 1183: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r11
	mov	0x30, %r19
	mov	0x70, %r19
	.word 0xd6bc6000  ! 1186: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0xd6946000  ! 1187: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r11
	.word 0xd6d4e000  ! 1188: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r11
	.word 0xdaf504a0  ! 1189: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	.word 0xdac46000  ! 1190: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r13
	.word 0xdaf46000  ! 1191: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0xdabce000  ! 1192: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	mov	0x7f0, %r21
	.word 0xdad42000  ! 1194: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 1195: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd897ce80  ! 1196: LDUHA_R	lduha	[%r31, %r0] 0x74, %r12
	.word 0xd8aee000  ! 1197: STBA_I	stba	%r12, [%r27 + 0x0000] %asi
	mov	0x30, %r25
	.word 0x8780204f  ! 1199: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ae6000  ! 1200: STBA_I	stba	%r12, [%r25 + 0x0000] %asi
	.word 0xda8504a0  ! 1201: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r13
	.word 0xda8ee000  ! 1202: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r13
	mov	0x40, %r26
	.word 0xd6ce09e0  ! 1204: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r11
	.word 0xd6be2000  ! 1205: STDA_I	stda	%r11, [%r24 + 0x0000] %asi
	.word 0xd097ce80  ! 1206: LDUHA_R	lduha	[%r31, %r0] 0x74, %r8
	mov	0x3c0, %r20
	.word 0xd0c62000  ! 1208: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1209: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1210: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9f8e40  ! 1211: LDDA_R	ldda	[%r30, %r0] 0x72, %r15
	.word 0x87802020  ! 1212: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r21
	.word 0xdecca000  ! 1214: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	.word 0xd4c70e40  ! 1215: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r10
	.word 0x87802074  ! 1216: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1217: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r16
	.word 0xd0f4c400  ! 1219: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0xdca74e60  ! 1220: STWA_R	stwa	%r14, [%r29 + %r0] 0x73
	.word 0x87802074  ! 1221: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2df8e80  ! 1222: LDXA_R	ldxa	[%r30, %r0] 0x74, %r9
	.word 0xdcdf8e40  ! 1223: LDXA_R	ldxa	[%r30, %r0] 0x72, %r14
	mov	0x70, %r25
	.word 0xdc9f6000  ! 1225: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xdcaf0e80  ! 1226: STBA_R	stba	%r14, [%r28 + %r0] 0x74
	mov	0x3c0, %r21
	.word 0xdcf7a000  ! 1228: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xd0d649e0  ! 1229: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r8
	.word 0xd6af0e80  ! 1230: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	.word 0x8780204f  ! 1231: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r18
	.word 0x87802074  ! 1233: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6bf6000  ! 1234: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	mov	0x48, %r24
	mov	0x28, %r17
	mov	0x50, %r19
	mov	0x3c8, %r22
	.word 0xd69f6000  ! 1239: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	.word 0xd69fe000  ! 1240: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	.word 0xd8dcc400  ! 1241: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	.word 0xd4df0e80  ! 1242: LDXA_R	ldxa	[%r28, %r0] 0x74, %r10
	.word 0x87802020  ! 1243: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d4a000  ! 1244: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1245: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r22
	.word 0xd4bce000  ! 1247: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0x87802073  ! 1249: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r18
	.word 0xd49c8400  ! 1251: LDDA_R	ldda	[%r18, %r0] 0x20, %r10
	.word 0xd4d76000  ! 1252: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0xd4afe000  ! 1253: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd88f0e60  ! 1254: LDUBA_R	lduba	[%r28, %r0] 0x73, %r12
	mov	0x3d0, %r22
	.word 0xd0b4c400  ! 1256: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0x87802074  ! 1257: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b7a000  ! 1258: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	mov	0x7e0, %r21
	.word 0xdca584a0  ! 1260: STWA_R	stwa	%r14, [%r22 + %r0] 0x25
	mov	0x3c0, %r21
	mov	0x7e0, %r20
	.word 0xdccf2000  ! 1263: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xdcbfe000  ! 1264: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1265: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebd44a0  ! 1266: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	mov	0x7c8, %r21
	.word 0x87802025  ! 1268: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4f504a0  ! 1269: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	mov	0x3c8, %r22
	.word 0xd4952000  ! 1271: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r10
	.word 0x87802073  ! 1272: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f504a0  ! 1273: STXA_R	stxa	%r11, [%r20 + %r0] 0x25
	mov	0x60, %r17
	mov	0x3f0, %r23
	mov	0x40, %r19
	.word 0xd6afa000  ! 1277: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6cf6000  ! 1278: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	mov	0x58, %r27
	.word 0xdc8584a0  ! 1280: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r14
	.word 0xdca7e000  ! 1281: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xd2afce40  ! 1282: STBA_R	stba	%r9, [%r31 + %r0] 0x72
	.word 0xdaa584a0  ! 1283: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	.word 0xdabfa000  ! 1284: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xd4be89e0  ! 1285: STDA_R	stda	%r10, [%r26 + %r0] 0x4f
	mov	0x38, %r27
	mov	0x40, %r24
	.word 0x8780204f  ! 1288: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x0, %r18
	mov	0x58, %r26
	.word 0xd4862000  ! 1291: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r10
	.word 0xdedfce40  ! 1292: LDXA_R	ldxa	[%r31, %r0] 0x72, %r15
	.word 0xd0f70e80  ! 1293: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0xd0de2000  ! 1294: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r8
	.word 0xdca504a0  ! 1295: STWA_R	stwa	%r14, [%r20 + %r0] 0x25
	.word 0x87802072  ! 1296: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29e89e0  ! 1297: LDDA_R	ldda	[%r26, %r0] 0x4f, %r9
	.word 0xd4f4c400  ! 1298: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	mov	0x38, %r16
	mov	0x40, %r26
	.word 0xd8b544a0  ! 1301: STHA_R	stha	%r12, [%r21 + %r0] 0x25
	.word 0x87802020  ! 1302: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d5c4a0  ! 1303: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r12
	.word 0xde8649e0  ! 1304: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r15
	.word 0xdeac6000  ! 1305: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	mov	0x3c0, %r22
	mov	0x3c8, %r20
	.word 0xdeb42000  ! 1308: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xd2dcc400  ! 1310: LDXA_R	ldxa	[%r19, %r0] 0x20, %r9
	.word 0xd2f42000  ! 1311: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0xd2ac2000  ! 1312: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd294e000  ! 1313: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	.word 0xd2c46000  ! 1314: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	mov	0x10, %r16
	.word 0xd2c4a000  ! 1316: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	.word 0xdcb78e40  ! 1317: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xd0878e60  ! 1318: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r8
	.word 0x87802072  ! 1319: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 1320: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b689e0  ! 1321: STHA_R	stha	%r10, [%r26 + %r0] 0x4f
	.word 0xd4b66000  ! 1322: STHA_I	stha	%r10, [%r25 + 0x0000] %asi
	.word 0xdecf8e80  ! 1323: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r15
	.word 0xd2878e80  ! 1324: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r9
	mov	0x10, %r16
	.word 0xd2a70e40  ! 1326: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	.word 0xda870e40  ! 1327: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r13
	mov	0x3d8, %r21
	.word 0xd8840400  ! 1329: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r12
	.word 0x87802020  ! 1330: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d70e40  ! 1331: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r10
	.word 0xd0f584a0  ! 1332: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	.word 0xd0cc6000  ! 1333: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	.word 0x87802072  ! 1334: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0cfe000  ! 1335: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xd0a7e000  ! 1336: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0b7a000  ! 1337: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xd0cf6000  ! 1339: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd0f7a000  ! 1340: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd4bf0e40  ! 1341: STDA_R	stda	%r10, [%r28 + %r0] 0x72
	.word 0xd4d7a000  ! 1342: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	mov	0x3f0, %r22
	mov	0x68, %r25
	.word 0xdaac0400  ! 1345: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xdaafa000  ! 1346: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xd2bc0400  ! 1347: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xd29fe000  ! 1348: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd4ae89e0  ! 1349: STBA_R	stba	%r10, [%r26 + %r0] 0x4f
	.word 0x8780204f  ! 1350: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f66000  ! 1351: STXA_I	stxa	%r10, [%r25 + 0x0000] %asi
	mov	0x60, %r17
	.word 0x87802072  ! 1353: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d0, %r20
	.word 0x87802074  ! 1355: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdecdc4a0  ! 1356: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r15
	mov	0x3e8, %r20
	.word 0xd6848400  ! 1358: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	mov	0x10, %r25
	.word 0xd0840400  ! 1360: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	.word 0xd4bf4e60  ! 1361: STDA_R	stda	%r10, [%r29 + %r0] 0x73
	.word 0xd4dfa000  ! 1362: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4bf2000  ! 1363: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 1364: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 1365: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4cf6000  ! 1366: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0x87802073  ! 1367: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f4c400  ! 1368: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0x87802020  ! 1369: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r16
	.word 0xd28c6000  ! 1371: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	mov	0x7d0, %r23
	mov	0x3e8, %r23
	.word 0xd2b4e000  ! 1374: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0xd2bca000  ! 1375: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	.word 0xd2f46000  ! 1376: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 1377: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2c6c9e0  ! 1378: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r9
	.word 0xd2c7a000  ! 1379: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1380: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29c6000  ! 1381: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	.word 0xd284e000  ! 1382: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r9
	.word 0xd2ce09e0  ! 1383: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r9
	.word 0x8780204f  ! 1384: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f0, %r21
	.word 0x87802072  ! 1386: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 1387: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 1388: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2c44400  ! 1389: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	.word 0x87802025  ! 1390: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 1391: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6ac4400  ! 1392: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xdabf4e40  ! 1393: STDA_R	stda	%r13, [%r29 + %r0] 0x72
	.word 0xdac76000  ! 1394: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	mov	0x0, %r18
	.word 0xdacf2000  ! 1396: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	mov	0x70, %r24
	.word 0x87802074  ! 1398: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdea7ce40  ! 1399: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	.word 0xdef76000  ! 1400: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1401: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea46000  ! 1402: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	mov	0x18, %r18
	.word 0xdebc2000  ! 1404: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xd6c48400  ! 1405: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	.word 0xd6f42000  ! 1406: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	mov	0x3c8, %r22
	.word 0xdea40400  ! 1408: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xd4878e60  ! 1409: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r10
	.word 0xd4d4a000  ! 1410: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	mov	0x0, %r25
	.word 0xd2b48400  ! 1412: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0x87802074  ! 1413: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2c7e000  ! 1414: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2afe000  ! 1415: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 1416: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r17
	.word 0xd6ac4400  ! 1418: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0x87802074  ! 1419: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e0, %r23
	mov	0x58, %r25
	.word 0xd69fe000  ! 1422: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	mov	0x78, %r18
	.word 0xd68fa000  ! 1424: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0xd08544a0  ! 1425: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r8
	.word 0x87802020  ! 1426: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cc2000  ! 1427: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	.word 0xd094a000  ! 1428: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	.word 0xd0842000  ! 1429: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r8
	.word 0xd6bdc4a0  ! 1430: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	.word 0xd69c6000  ! 1431: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r11
	.word 0xd684e000  ! 1432: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r11
	mov	0x8, %r16
	mov	0x3c0, %r23
	mov	0x40, %r25
	mov	0x68, %r26
	mov	0x78, %r27
	mov	0x68, %r17
	.word 0xd6f42000  ! 1439: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 1440: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b7e000  ! 1441: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xdeb44400  ! 1442: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0x87802073  ! 1443: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef7a000  ! 1444: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	mov	0x60, %r27
	mov	0x50, %r16
	.word 0xde8fe000  ! 1447: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0x87802020  ! 1448: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb4e000  ! 1449: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0xdec42000  ! 1450: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0xdef46000  ! 1451: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xde84e000  ! 1452: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	mov	0x48, %r26
	.word 0xdedce000  ! 1454: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r15
	.word 0xdcc7ce80  ! 1455: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r14
	.word 0x87802074  ! 1456: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r21
	.word 0xdcd72000  ! 1458: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xd0d48400  ! 1459: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	.word 0xd0bcc400  ! 1460: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0xd0af6000  ! 1461: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xdec544a0  ! 1462: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r15
	.word 0xd4974e40  ! 1463: LDUHA_R	lduha	[%r29, %r0] 0x72, %r10
	.word 0xdcf48400  ! 1464: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xdcbc4400  ! 1465: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	mov	0x50, %r26
	mov	0x8, %r25
	.word 0xdcc7e000  ! 1468: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcdf2000  ! 1469: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcf7e000  ! 1470: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xd8df4e60  ! 1471: LDXA_R	ldxa	[%r29, %r0] 0x73, %r12
	.word 0xd8af6000  ! 1472: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd89fa000  ! 1473: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	.word 0xd0a74e60  ! 1474: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	.word 0xd0c78e60  ! 1475: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r8
	.word 0xde9c8400  ! 1476: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	.word 0xdeb7e000  ! 1477: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xd485c4a0  ! 1478: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r10
	.word 0xd4bf2000  ! 1479: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 1480: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 1481: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r26
	.word 0xd4af6000  ! 1483: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd48f6000  ! 1484: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	mov	0x7d8, %r22
	mov	0x20, %r16
	.word 0xd4a76000  ! 1487: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd8a7ce60  ! 1488: STWA_R	stwa	%r12, [%r31 + %r0] 0x73
	.word 0xd0f4c400  ! 1489: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0xd09cc400  ! 1490: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	.word 0x87802074  ! 1491: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f7e000  ! 1492: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0bf2000  ! 1493: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 1494: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0a7e000  ! 1495: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xd6f504a0  ! 1496: STXA_R	stxa	%r11, [%r20 + %r0] 0x25
	.word 0xd69f6000  ! 1497: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	.word 0xdabf0e80  ! 1498: STDA_R	stda	%r13, [%r28 + %r0] 0x74
	.word 0xd2d74e80  ! 1499: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r9
	mov	0x3c0, %r21
	.word 0x87802025  ! 1501: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2ada000  ! 1502: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	mov	0x70, %r26
	.word 0xd2df0e40  ! 1504: LDXA_R	ldxa	[%r28, %r0] 0x72, %r9
	mov	0x58, %r24
	.word 0x87802073  ! 1506: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f72000  ! 1507: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 1508: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d0, %r21
	.word 0xd8de09e0  ! 1510: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r12
	.word 0x87802020  ! 1511: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcac8400  ! 1512: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	mov	0x7d0, %r23
	.word 0xdca42000  ! 1514: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xd4c70e80  ! 1515: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r10
	.word 0xd48ca000  ! 1516: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r10
	.word 0xd09f0e60  ! 1517: LDDA_R	ldda	[%r28, %r0] 0x73, %r8
	.word 0xde8f0e40  ! 1518: LDUBA_R	lduba	[%r28, %r0] 0x72, %r15
	.word 0xde84a000  ! 1519: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	.word 0xde970e80  ! 1520: LDUHA_R	lduha	[%r28, %r0] 0x74, %r15
	.word 0xdef4a000  ! 1521: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0xde8ca000  ! 1522: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	mov	0x0, %r27
	.word 0x8780204f  ! 1524: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e8, %r21
	.word 0xdef62000  ! 1526: STXA_I	stxa	%r15, [%r24 + 0x0000] %asi
	.word 0xde866000  ! 1527: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r15
	.word 0xdeb504a0  ! 1528: STHA_R	stha	%r15, [%r20 + %r0] 0x25
	.word 0xde86a000  ! 1529: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r15
	.word 0xdea48400  ! 1530: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xdeb6a000  ! 1531: STHA_I	stha	%r15, [%r26 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xdede6000  ! 1533: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r15
	mov	0x30, %r27
	.word 0xdeaea000  ! 1535: STBA_I	stba	%r15, [%r26 + 0x0000] %asi
	.word 0xdeb48400  ! 1536: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xd8de49e0  ! 1537: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r12
	.word 0xd2ac8400  ! 1538: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xd28e2000  ! 1539: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	.word 0xd8a4c400  ! 1540: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xd8a62000  ! 1541: STWA_I	stwa	%r12, [%r24 + 0x0000] %asi
	mov	0x38, %r27
	mov	0x18, %r25
	.word 0xd8b70e40  ! 1544: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0xd8ae2000  ! 1545: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	.word 0x8780204f  ! 1546: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdad4c400  ! 1547: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xdabe2000  ! 1548: STDA_I	stda	%r13, [%r24 + 0x0000] %asi
	.word 0xda966000  ! 1549: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r13
	.word 0xdaf6a000  ! 1550: STXA_I	stxa	%r13, [%r26 + 0x0000] %asi
	.word 0xd2bf8e60  ! 1551: STDA_R	stda	%r9, [%r30 + %r0] 0x73
	.word 0xd2f6e000  ! 1552: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	.word 0xdcc44400  ! 1553: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xdccea000  ! 1554: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r14
	.word 0xd4a74e60  ! 1555: STWA_R	stwa	%r10, [%r29 + %r0] 0x73
	.word 0xd4f6e000  ! 1556: STXA_I	stxa	%r10, [%r27 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xd0b78e40  ! 1558: STHA_R	stha	%r8, [%r30 + %r0] 0x72
	.word 0xd2b7ce80  ! 1559: STHA_R	stha	%r9, [%r31 + %r0] 0x74
	.word 0xd0f689e0  ! 1560: STXA_R	stxa	%r8, [%r26 + %r0] 0x4f
	.word 0xd0ae2000  ! 1561: STBA_I	stba	%r8, [%r24 + 0x0000] %asi
	mov	0x68, %r27
	mov	0x3c8, %r22
	mov	0x20, %r16
	.word 0xd0c70e40  ! 1565: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r8
	mov	0x20, %r25
	.word 0xdca544a0  ! 1567: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	mov	0x70, %r17
	mov	0x58, %r17
	.word 0xdccea000  ! 1570: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r14
	.word 0x87802072  ! 1571: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd28584a0  ! 1572: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r9
	mov	0x70, %r18
	.word 0xdeafce60  ! 1574: STBA_R	stba	%r15, [%r31 + %r0] 0x73
	.word 0xd0afce60  ! 1575: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	.word 0x87802072  ! 1576: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0bf8e40  ! 1577: STDA_R	stda	%r8, [%r30 + %r0] 0x72
	.word 0xda840400  ! 1578: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	.word 0x87802025  ! 1579: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdac52000  ! 1580: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1581: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1582: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r26
	mov	0x30, %r27
	.word 0x87802073  ! 1585: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c0, %r23
	.word 0xdad70e80  ! 1587: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r13
	.word 0xdaf72000  ! 1588: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0xdcc584a0  ! 1590: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r14
	.word 0xdcf7e000  ! 1591: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdc976000  ! 1592: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	.word 0xdcafe000  ! 1593: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdadf8e40  ! 1594: LDXA_R	ldxa	[%r30, %r0] 0x72, %r13
	.word 0x87802020  ! 1595: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c7ce80  ! 1596: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r9
	.word 0xd4b7ce60  ! 1597: STHA_R	stha	%r10, [%r31 + %r0] 0x73
	.word 0x87802025  ! 1598: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r16
	mov	0x7f0, %r21
	.word 0xd8b689e0  ! 1601: STHA_R	stha	%r12, [%r26 + %r0] 0x4f
	.word 0xd0a74e40  ! 1602: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	mov	0x40, %r18
	.word 0xd0856000  ! 1604: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r8
	.word 0xd0ad84a0  ! 1605: STBA_R	stba	%r8, [%r22 + %r0] 0x25
	.word 0x87802072  ! 1606: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0cfa000  ! 1607: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	mov	0x3d8, %r21
	mov	0x10, %r24
	.word 0xd0f7e000  ! 1610: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xda9d84a0  ! 1611: LDDA_R	ldda	[%r22, %r0] 0x25, %r13
	.word 0xdab7e000  ! 1612: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xdab72000  ! 1613: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xd8ce49e0  ! 1614: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r12
	.word 0xd4cec9e0  ! 1615: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r10
	.word 0xdaafce80  ! 1616: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	mov	0x3f8, %r20
	.word 0xd4cc8400  ! 1618: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	.word 0xd4bf6000  ! 1619: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd08cc400  ! 1620: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	.word 0xd0f7a000  ! 1621: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd8a70e40  ! 1622: STWA_R	stwa	%r12, [%r28 + %r0] 0x72
	.word 0x87802020  ! 1623: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r24
	.word 0x87802072  ! 1625: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd08649e0  ! 1626: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r8
	mov	0x7e0, %r20
	.word 0x87802020  ! 1628: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a48400  ! 1629: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xd484a000  ! 1630: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r10
	.word 0x87802072  ! 1631: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4afa000  ! 1632: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd88ec9e0  ! 1633: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r12
	mov	0x3c8, %r22
	mov	0x78, %r24
	mov	0x70, %r27
	.word 0xd8bfa000  ! 1637: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd8cfe000  ! 1638: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8c7e000  ! 1639: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802020  ! 1641: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r24
	.word 0x87802020  ! 1643: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd894e000  ! 1644: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r12
	.word 0xd8946000  ! 1645: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	mov	0x30, %r25
	.word 0xdeb544a0  ! 1647: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	.word 0x8780204f  ! 1648: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebea000  ! 1649: STDA_I	stda	%r15, [%r26 + 0x0000] %asi
	mov	0x3f8, %r23
	.word 0xd6bc8400  ! 1651: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	mov	0x48, %r16
	.word 0xd48c4400  ! 1653: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	mov	0x60, %r18
	.word 0xd4ce6000  ! 1655: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r10
	.word 0xd4be6000  ! 1656: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0xd49c4400  ! 1657: LDDA_R	ldda	[%r17, %r0] 0x20, %r10
	mov	0x70, %r24
	mov	0x7e0, %r22
	.word 0x87802073  ! 1660: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f74e80  ! 1661: STXA_R	stxa	%r11, [%r29 + %r0] 0x74
	.word 0xde8504a0  ! 1662: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r15
	.word 0x8780204f  ! 1663: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x30, %r18
	.word 0xdabf8e80  ! 1666: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	.word 0xdabee000  ! 1667: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	mov	0x48, %r16
	mov	0x3d0, %r23
	.word 0xdcb504a0  ! 1670: STHA_R	stha	%r14, [%r20 + %r0] 0x25
	.word 0xdc96a000  ! 1671: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r14
	.word 0xdcb66000  ! 1672: STHA_I	stha	%r14, [%r25 + 0x0000] %asi
	mov	0x50, %r16
	.word 0xdcbe6000  ! 1674: STDA_I	stda	%r14, [%r25 + 0x0000] %asi
	.word 0xdccea000  ! 1675: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r14
	mov	0x70, %r18
	.word 0x87802074  ! 1677: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdec6c9e0  ! 1678: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r15
	.word 0xdeb72000  ! 1679: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 1680: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb7a000  ! 1681: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xd6a48400  ! 1682: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0x87802072  ! 1683: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdad7ce80  ! 1684: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r13
	.word 0x87802072  ! 1685: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6c70e40  ! 1686: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r11
	mov	0x58, %r26
	.word 0x87802025  ! 1688: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8f4c400  ! 1689: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xd2ae09e0  ! 1690: STBA_R	stba	%r9, [%r24 + %r0] 0x4f
	mov	0x60, %r17
	.word 0xd0bfce60  ! 1692: STDA_R	stda	%r8, [%r31 + %r0] 0x73
	mov	0x0, %r16
	.word 0x8780204f  ! 1694: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 1695: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f6a000  ! 1696: STXA_I	stxa	%r8, [%r26 + 0x0000] %asi
	.word 0xdab44400  ! 1697: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 1698: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9ea000  ! 1699: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r13
	.word 0xd4a48400  ! 1700: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xd4d66000  ! 1701: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r10
	.word 0xd8bfce40  ! 1702: STDA_R	stda	%r12, [%r31 + %r0] 0x72
	.word 0xd0a70e40  ! 1703: STWA_R	stwa	%r8, [%r28 + %r0] 0x72
	.word 0xdab70e80  ! 1704: STHA_R	stha	%r13, [%r28 + %r0] 0x74
	mov	0x18, %r24
	mov	0x38, %r24
	.word 0xda9e6000  ! 1707: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1708: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r16
	.word 0xdaa42000  ! 1710: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0xdabce000  ! 1711: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0xdabce000  ! 1712: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 1713: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeadc4a0  ! 1714: STBA_R	stba	%r15, [%r23 + %r0] 0x25
	.word 0xde8c0400  ! 1715: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0xdcb4c400  ! 1716: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xdcdce000  ! 1717: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r14
	.word 0xdc8f8e40  ! 1718: LDUBA_R	lduba	[%r30, %r0] 0x72, %r14
	.word 0xd08c8400  ! 1719: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0xd0a4e000  ! 1720: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 1721: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bfce60  ! 1722: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	mov	0x8, %r24
	mov	0x8, %r16
	.word 0xd8c42000  ! 1725: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r12
	.word 0xd8d4a000  ! 1726: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xd0970e40  ! 1727: LDUHA_R	lduha	[%r28, %r0] 0x72, %r8
	.word 0xd4b70e80  ! 1728: STHA_R	stha	%r10, [%r28 + %r0] 0x74
	.word 0xd4cca000  ! 1729: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r10
	.word 0xd484e000  ! 1730: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r10
	.word 0xd29dc4a0  ! 1731: LDDA_R	ldda	[%r23, %r0] 0x25, %r9
	.word 0x87802073  ! 1732: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb48400  ! 1733: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xdcb7e000  ! 1734: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xd0bec9e0  ! 1735: STDA_R	stda	%r8, [%r27 + %r0] 0x4f
	.word 0xd0f7e000  ! 1736: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0afa000  ! 1737: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	mov	0x7f0, %r21
	.word 0xd0afa000  ! 1739: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd4a4c400  ! 1740: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0xda970e40  ! 1741: LDUHA_R	lduha	[%r28, %r0] 0x72, %r13
	.word 0x87802025  ! 1742: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d8, %r20
	.word 0xd4f70e60  ! 1744: STXA_R	stxa	%r10, [%r28 + %r0] 0x73
	.word 0xda84c400  ! 1745: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r13
	.word 0xd4b48400  ! 1746: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xde8e09e0  ! 1747: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r15
	.word 0xdecd2000  ! 1748: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r15
	.word 0xdeb5e000  ! 1749: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	.word 0xdaf7ce80  ! 1750: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	.word 0xda852000  ! 1751: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r13
	.word 0xd6a74e80  ! 1752: STWA_R	stwa	%r11, [%r29 + %r0] 0x74
	.word 0xd68de000  ! 1753: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r11
	.word 0xd6a52000  ! 1754: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	.word 0xdccfce80  ! 1755: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r14
	.word 0xdaa70e80  ! 1756: STWA_R	stwa	%r13, [%r28 + %r0] 0x74
	mov	0x10, %r25
	.word 0xda8da000  ! 1758: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1759: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabec9e0  ! 1760: STDA_R	stda	%r13, [%r27 + %r0] 0x4f
	mov	0x18, %r25
	.word 0x87802020  ! 1762: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1763: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1764: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4dd04a0  ! 1765: LDXA_R	ldxa	[%r20, %r0] 0x25, %r10
	.word 0xd4a4e000  ! 1766: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xd8bc4400  ! 1767: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xd48f0e80  ! 1768: LDUBA_R	lduba	[%r28, %r0] 0x74, %r10
	.word 0x87802072  ! 1769: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4af2000  ! 1770: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xded74e40  ! 1771: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r15
	mov	0x70, %r25
	.word 0xdef44400  ! 1773: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xdec76000  ! 1774: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xdca74e80  ! 1775: STWA_R	stwa	%r14, [%r29 + %r0] 0x74
	.word 0xdca7e000  ! 1776: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	mov	0x70, %r26
	.word 0xd49fce40  ! 1778: LDDA_R	ldda	[%r31, %r0] 0x72, %r10
	.word 0x87802025  ! 1779: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 1780: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde844400  ! 1781: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	mov	0x40, %r26
	mov	0x18, %r27
	.word 0xd4ccc400  ! 1784: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0x87802025  ! 1785: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb44400  ! 1786: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0xd2d7ce60  ! 1787: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r9
	.word 0xd2b52000  ! 1788: STHA_I	stha	%r9, [%r20 + 0x0000] %asi
	.word 0xdcd649e0  ! 1789: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r14
	.word 0xd4d78e60  ! 1790: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r10
	.word 0xd4bde000  ! 1791: STDA_I	stda	%r10, [%r23 + 0x0000] %asi
	mov	0x50, %r26
	.word 0xd4cd6000  ! 1793: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1794: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48ce000  ! 1795: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r10
	.word 0xd4ac6000  ! 1796: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	.word 0xd4dc6000  ! 1797: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	.word 0xde94c400  ! 1798: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	mov	0x10, %r27
	.word 0xdec46000  ! 1800: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	.word 0xde9ca000  ! 1801: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	.word 0xdef4e000  ! 1802: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xded42000  ! 1803: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	.word 0xde8ce000  ! 1804: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	.word 0xdecce000  ! 1805: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	mov	0x58, %r16
	.word 0x87802025  ! 1807: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebda000  ! 1808: STDA_I	stda	%r15, [%r22 + 0x0000] %asi
	.word 0xd2f40400  ! 1809: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xdec7ce40  ! 1810: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r15
	.word 0x8780204f  ! 1811: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdeb66000  ! 1813: STHA_I	stha	%r15, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 1814: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9544a0  ! 1815: LDUHA_R	lduha	[%r21, %r0] 0x25, %r14
	.word 0xdcaca000  ! 1816: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	mov	0x28, %r25
	.word 0xdabc0400  ! 1818: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0x87802072  ! 1819: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0ac8400  ! 1820: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xd0bc4400  ! 1821: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xd0df0e40  ! 1822: LDXA_R	ldxa	[%r28, %r0] 0x72, %r8
	.word 0xdecfce60  ! 1823: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r15
	.word 0x8780204f  ! 1824: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a6c9e0  ! 1825: STWA_R	stwa	%r12, [%r27 + %r0] 0x4f
	mov	0x3e8, %r22
	.word 0xdcbf4e40  ! 1827: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	.word 0xdcc6a000  ! 1828: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r14
	.word 0xda95c4a0  ! 1829: LDUHA_R	lduha	[%r23, %r0] 0x25, %r13
	mov	0x30, %r24
	.word 0xdaf66000  ! 1831: STXA_I	stxa	%r13, [%r25 + 0x0000] %asi
	.word 0xdab74e60  ! 1832: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	.word 0xdca74e40  ! 1833: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	.word 0xdcdec9e0  ! 1834: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r14
	.word 0x87802074  ! 1835: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbf4e40  ! 1836: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	mov	0x3d0, %r21
	mov	0x7e8, %r21
	.word 0xdcbfa000  ! 1839: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdcb72000  ! 1840: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 1841: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf52000  ! 1842: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	mov	0x78, %r19
	mov	0x18, %r17
	.word 0x87802020  ! 1845: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r20
	.word 0xdcf46000  ! 1847: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdca42000  ! 1848: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xdc84a000  ! 1849: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	.word 0xd4c44400  ! 1850: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r10
	.word 0xd4d4a000  ! 1851: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0xde9f0e60  ! 1852: LDDA_R	ldda	[%r28, %r0] 0x73, %r15
	.word 0xdebc2000  ! 1853: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xdecca000  ! 1854: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	mov	0x3f8, %r21
	.word 0x87802020  ! 1856: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1857: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r25
	.word 0xdc9f8e40  ! 1859: LDDA_R	ldda	[%r30, %r0] 0x72, %r14
	.word 0xdc94c400  ! 1860: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	.word 0x8780204f  ! 1861: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0aec9e0  ! 1862: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	.word 0xdeaf0e80  ! 1863: STBA_R	stba	%r15, [%r28 + %r0] 0x74
	.word 0xde86a000  ! 1864: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r15
	.word 0xdecee000  ! 1865: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r15
	.word 0xdec6a000  ! 1866: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r15
	mov	0x7d0, %r20
	.word 0xdacec9e0  ! 1868: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r13
	.word 0xdaaea000  ! 1869: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	.word 0xdeaf0e60  ! 1870: STBA_R	stba	%r15, [%r28 + %r0] 0x73
	.word 0xdebee000  ! 1871: STDA_I	stda	%r15, [%r27 + 0x0000] %asi
	.word 0xd2c649e0  ! 1872: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r9
	.word 0xdeae09e0  ! 1873: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	.word 0xd6bd44a0  ! 1874: STDA_R	stda	%r11, [%r21 + %r0] 0x25
	.word 0xd29fce80  ! 1875: LDDA_R	ldda	[%r31, %r0] 0x74, %r9
	.word 0x87802072  ! 1876: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 1877: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6c6c9e0  ! 1878: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r11
	.word 0xd6f7e000  ! 1879: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6d76000  ! 1880: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	.word 0xd6af6000  ! 1881: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd6dfe000  ! 1882: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	mov	0x58, %r26
	mov	0x38, %r18
	mov	0x28, %r26
	.word 0xd6bfa000  ! 1886: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xdcdfce80  ! 1887: LDXA_R	ldxa	[%r31, %r0] 0x74, %r14
	.word 0x87802020  ! 1888: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r16
	.word 0xdcace000  ! 1890: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0xdcb78e40  ! 1891: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xdcace000  ! 1892: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0xdcbca000  ! 1893: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdcf649e0  ! 1894: STXA_R	stxa	%r14, [%r25 + %r0] 0x4f
	.word 0xdcc4e000  ! 1895: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r14
	.word 0x87802073  ! 1896: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf72000  ! 1897: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdccf6000  ! 1898: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xd69f4e80  ! 1899: LDDA_R	ldda	[%r29, %r0] 0x74, %r11
	.word 0xd6b76000  ! 1900: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xdc978e60  ! 1901: LDUHA_R	lduha	[%r30, %r0] 0x73, %r14
	.word 0xdc872000  ! 1902: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xd0bf8e40  ! 1903: STDA_R	stda	%r8, [%r30 + %r0] 0x72
	mov	0x30, %r18
	mov	0x10, %r17
	mov	0x7c8, %r21
	.word 0xd097a000  ! 1907: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	mov	0x70, %r25
	.word 0xd097e000  ! 1909: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xdcce49e0  ! 1910: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r14
	.word 0xd8cf8e40  ! 1911: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r12
	.word 0x87802073  ! 1912: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r18
	mov	0x70, %r19
	.word 0xd8a74e40  ! 1915: STWA_R	stwa	%r12, [%r29 + %r0] 0x72
	mov	0x58, %r18
	.word 0xd8bf6000  ! 1917: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	mov	0x8, %r18
	.word 0xde8f8e80  ! 1919: LDUBA_R	lduba	[%r30, %r0] 0x74, %r15
	.word 0xd8974e80  ! 1920: LDUHA_R	lduha	[%r29, %r0] 0x74, %r12
	.word 0xd8bf6000  ! 1921: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd89fa000  ! 1922: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	.word 0xd8bfe000  ! 1923: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	mov	0x78, %r26
	mov	0x38, %r26
	.word 0xd8df6000  ! 1926: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8bf6000  ! 1927: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd8cfa000  ! 1928: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd0bfce80  ! 1929: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	.word 0xd8f70e60  ! 1930: STXA_R	stxa	%r12, [%r28 + %r0] 0x73
	.word 0xd694c400  ! 1931: LDUHA_R	lduha	[%r19, %r0] 0x20, %r11
	mov	0x48, %r17
	.word 0xd08c4400  ! 1933: LDUBA_R	lduba	[%r17, %r0] 0x20, %r8
	.word 0xd0bf6000  ! 1934: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 1935: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0f7ce40  ! 1936: STXA_R	stxa	%r8, [%r31 + %r0] 0x72
	mov	0x18, %r17
	.word 0xd0f76000  ! 1938: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd8a5c4a0  ! 1939: STWA_R	stwa	%r12, [%r23 + %r0] 0x25
	.word 0xd686c9e0  ! 1940: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r11
	mov	0x60, %r24
	mov	0x30, %r16
	.word 0xd6bfe000  ! 1943: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd6b76000  ! 1944: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 1945: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd08e09e0  ! 1946: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r8
	.word 0x87802073  ! 1947: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0afce60  ! 1948: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	.word 0xd0b76000  ! 1949: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xd097a000  ! 1951: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	mov	0x18, %r26
	.word 0xdcbcc400  ! 1953: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0x87802073  ! 1954: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 1955: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc9d84a0  ! 1956: LDDA_R	ldda	[%r22, %r0] 0x25, %r14
	.word 0xd0c74e40  ! 1957: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r8
	mov	0x58, %r24
	.word 0xd0bf2000  ! 1959: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xd6f70e80  ! 1960: STXA_R	stxa	%r11, [%r28 + %r0] 0x74
	.word 0x87802020  ! 1961: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bf4e60  ! 1962: STDA_R	stda	%r12, [%r29 + %r0] 0x73
	.word 0xd8cc6000  ! 1963: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r12
	.word 0xd8942000  ! 1964: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r12
	.word 0xd8d78e60  ! 1965: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r12
	mov	0x60, %r25
	.word 0xd8d4a000  ! 1967: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xd89ce000  ! 1968: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	.word 0xd8bc2000  ! 1969: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd8dca000  ! 1970: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1971: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8df0e80  ! 1972: LDXA_R	ldxa	[%r28, %r0] 0x74, %r12
	.word 0xd0af0e60  ! 1973: STBA_R	stba	%r8, [%r28 + %r0] 0x73
	.word 0x87802020  ! 1974: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1975: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b46000  ! 1976: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0xd8bc8400  ! 1977: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xd8dc2000  ! 1978: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0xd2b78e60  ! 1979: STHA_R	stha	%r9, [%r30 + %r0] 0x73
	.word 0xd09504a0  ! 1980: LDUHA_R	lduha	[%r20, %r0] 0x25, %r8
	mov	0x48, %r26
	mov	0x18, %r24
	mov	0x3e8, %r21
	.word 0x87802074  ! 1984: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f7e000  ! 1985: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xdcbe49e0  ! 1986: STDA_R	stda	%r14, [%r25 + %r0] 0x4f
	.word 0xdcafa000  ! 1987: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0xd69fce80  ! 1989: LDDA_R	ldda	[%r31, %r0] 0x74, %r11
	mov	0x70, %r27
	.word 0x87802025  ! 1991: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 1992: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd68f6000  ! 1993: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	mov	0x68, %r27
	mov	0x7f8, %r20
	.word 0xd6dfa000  ! 1996: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0xdeb7ce60  ! 1997: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	mov	0x7e0, %r23
	.word 0xde87a000  ! 1999: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xdecf6000  ! 2000: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0xdec76000  ! 2001: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xdef7a000  ! 2002: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xd2bf8e40  ! 2003: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	mov	0x7d8, %r21
	.word 0xd2b7e000  ! 2005: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2af6000  ! 2006: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd0a584a0  ! 2007: STWA_R	stwa	%r8, [%r22 + %r0] 0x25
	.word 0xd0bfa000  ! 2008: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0xdab4c400  ! 2009: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xdab7e000  ! 2010: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 2011: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f8, %r22
	.word 0xd09ec9e0  ! 2013: LDDA_R	ldda	[%r27, %r0] 0x4f, %r8
	.word 0xd0972000  ! 2014: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xdcdf0e60  ! 2015: LDXA_R	ldxa	[%r28, %r0] 0x73, %r14
	mov	0x78, %r24
	mov	0x3e8, %r21
	.word 0xdcd72000  ! 2018: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xdccfe000  ! 2019: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xdcd7e000  ! 2020: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xdc97a000  ! 2021: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	.word 0xdc8fa000  ! 2022: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdca76000  ! 2023: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdca76000  ! 2024: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdef70e60  ! 2025: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	.word 0xde9f6000  ! 2026: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0xd0b7ce80  ! 2027: STHA_R	stha	%r8, [%r31 + %r0] 0x74
	mov	0x7e0, %r23
	.word 0xd0df2000  ! 2029: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0xdcf44400  ! 2030: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xdc8f2000  ! 2031: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0xd48689e0  ! 2032: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r10
	.word 0xd4972000  ! 2033: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	mov	0x3c0, %r21
	.word 0x87802072  ! 2035: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2036: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r27
	.word 0x87802073  ! 2038: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4a72000  ! 2039: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 2040: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4acc400  ! 2041: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xd4bda000  ! 2042: STDA_I	stda	%r10, [%r22 + 0x0000] %asi
	.word 0xd48d2000  ! 2043: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0xd4f56000  ! 2044: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	.word 0xd2bc0400  ! 2045: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xd4c78e80  ! 2046: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r10
	mov	0x7e0, %r22
	.word 0xd4d5a000  ! 2048: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r10
	mov	0x58, %r26
	mov	0x10, %r17
	.word 0xd4b649e0  ! 2051: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	mov	0x50, %r27
	.word 0xde874e40  ! 2053: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r15
	.word 0x87802073  ! 2054: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde8f6000  ! 2055: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	.word 0xdecf2000  ! 2056: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	mov	0x58, %r19
	mov	0x3d8, %r21
	.word 0xd09c4400  ! 2059: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	.word 0xdecf4e60  ! 2060: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r15
	.word 0x8780204f  ! 2061: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeb6e000  ! 2062: STHA_I	stha	%r15, [%r27 + 0x0000] %asi
	.word 0xd0874e60  ! 2063: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r8
	.word 0xd0b6e000  ! 2064: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	.word 0xd0bee000  ! 2065: STDA_I	stda	%r8, [%r27 + 0x0000] %asi
	.word 0xd89c0400  ! 2066: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	mov	0x68, %r25
	mov	0x70, %r17
	.word 0x87802074  ! 2069: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8df2000  ! 2070: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8afa000  ! 2071: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xdef70e60  ! 2072: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	.word 0xdeb76000  ! 2073: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xdea7a000  ! 2074: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 2075: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde9f6000  ! 2076: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	mov	0x50, %r16
	mov	0x38, %r26
	.word 0xdecfa000  ! 2079: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdea72000  ! 2081: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2082: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r16
	.word 0xdedc2000  ! 2084: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r15
	.word 0xdea42000  ! 2085: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xdebca000  ! 2086: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 2087: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r18
	.word 0xdef4e000  ! 2089: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xdeace000  ! 2090: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 2091: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d78e40  ! 2092: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r11
	.word 0xd6bc6000  ! 2093: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0xd6dc6000  ! 2094: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r11
	mov	0x8, %r17
	.word 0xd4c48400  ! 2096: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r10
	.word 0xd4d4e000  ! 2097: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0xd4dc2000  ! 2098: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	.word 0xdab74e80  ! 2099: STHA_R	stha	%r13, [%r29 + %r0] 0x74
	.word 0x87802073  ! 2100: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdadfa000  ! 2101: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xdaf7a000  ! 2102: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdaa48400  ! 2103: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	ta	T_CHANGE_PRIV	! macro
	mov	0x7c0, %r21
	.word 0xda97a000  ! 2106: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xdabfa000  ! 2107: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xd88f8e60  ! 2108: LDUBA_R	lduba	[%r30, %r0] 0x73, %r12
	mov	0x60, %r26
	.word 0xd8b72000  ! 2110: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2111: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r21
	.word 0xd8cce000  ! 2113: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r12
	.word 0xd8f42000  ! 2114: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xd2bf8e80  ! 2115: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	mov	0x0, %r26
	.word 0xd0adc4a0  ! 2117: STBA_R	stba	%r8, [%r23 + %r0] 0x25
	.word 0xdace89e0  ! 2118: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r13
	mov	0x0, %r24
	.word 0xdaae09e0  ! 2120: STBA_R	stba	%r13, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 2121: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd084c400  ! 2122: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r8
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2c74e40  ! 2124: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r9
	.word 0xd8ac8400  ! 2125: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0xd8c46000  ! 2126: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r12
	mov	0x48, %r19
	.word 0xd8bca000  ! 2128: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	mov	0x38, %r26
	.word 0xd2c74e80  ! 2130: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r9
	.word 0xd28ca000  ! 2131: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2d42000  ! 2132: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	mov	0x78, %r26
	.word 0x87802074  ! 2134: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28f6000  ! 2135: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd29fe000  ! 2136: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd8ccc400  ! 2137: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r12
	.word 0xdca6c9e0  ! 2138: STWA_R	stwa	%r14, [%r27 + %r0] 0x4f
	.word 0xd6f44400  ! 2139: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0x87802020  ! 2140: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8af0e60  ! 2141: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	.word 0x87802072  ! 2142: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3e8, %r22
	.word 0xd08f0e80  ! 2144: LDUBA_R	lduba	[%r28, %r0] 0x74, %r8
	.word 0x87802025  ! 2145: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0b5e000  ! 2146: STHA_I	stha	%r8, [%r23 + 0x0000] %asi
	.word 0xd0c56000  ! 2147: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r8
	mov	0x8, %r24
	.word 0x87802073  ! 2149: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r16
	.word 0x8780204f  ! 2151: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd096e000  ! 2152: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r8
	.word 0xd0c66000  ! 2153: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r8
	.word 0x87802072  ! 2154: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcd7ce40  ! 2155: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r14
	.word 0x87802020  ! 2156: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r17
	mov	0x18, %r19
	.word 0xda8c4400  ! 2159: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0xda9ca000  ! 2160: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	.word 0xdacce000  ! 2161: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r13
	.word 0xdacc2000  ! 2162: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xdcf4c400  ! 2163: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xdcb42000  ! 2164: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	mov	0x38, %r25
	.word 0xdca46000  ! 2166: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xd0c5c4a0  ! 2167: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r8
	.word 0x87802020  ! 2168: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2169: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r17
	.word 0xd0f66000  ! 2171: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	.word 0xd0a6a000  ! 2172: STWA_I	stwa	%r8, [%r26 + 0x0000] %asi
	.word 0xd2ac0400  ! 2173: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0x87802020  ! 2174: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b609e0  ! 2175: STHA_R	stha	%r10, [%r24 + %r0] 0x4f
	.word 0xd2af0e80  ! 2176: STBA_R	stba	%r9, [%r28 + %r0] 0x74
	.word 0x87802072  ! 2177: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2972000  ! 2178: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2179: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b72000  ! 2180: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 2181: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd29ea000  ! 2182: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r9
	.word 0xdab40400  ! 2183: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	mov	0x28, %r25
	.word 0xdaa6e000  ! 2185: STWA_I	stwa	%r13, [%r27 + 0x0000] %asi
	.word 0xd4c78e80  ! 2186: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r10
	.word 0x87802074  ! 2187: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcafce40  ! 2188: STBA_R	stba	%r14, [%r31 + %r0] 0x72
	.word 0xdcb7e000  ! 2189: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xdcdc0400  ! 2190: LDXA_R	ldxa	[%r16, %r0] 0x20, %r14
	mov	0x38, %r26
	.word 0xdcdfe000  ! 2192: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xdaa78e60  ! 2193: STWA_R	stwa	%r13, [%r30 + %r0] 0x73
	.word 0xdadfa000  ! 2194: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xdabfa000  ! 2195: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	mov	0x3c0, %r22
	mov	0x20, %r24
	.word 0xda8f6000  ! 2198: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	mov	0x38, %r19
	.word 0xd89504a0  ! 2200: LDUHA_R	lduha	[%r20, %r0] 0x25, %r12
	mov	0x28, %r18
	.word 0xd48d84a0  ! 2202: LDUBA_R	lduba	[%r22, %r0] 0x25, %r10
	mov	0x3e0, %r20
	.word 0x8780204f  ! 2204: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c8, %r21
	.word 0xdc9cc400  ! 2206: LDDA_R	ldda	[%r19, %r0] 0x20, %r14
	mov	0x3c0, %r21
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdcaea000  ! 2209: STBA_I	stba	%r14, [%r26 + 0x0000] %asi
	.word 0xdcd66000  ! 2210: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r14
	.word 0xdcf78e60  ! 2211: STXA_R	stxa	%r14, [%r30 + %r0] 0x73
	mov	0x60, %r25
	.word 0xdc8ee000  ! 2213: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r14
	.word 0xdc9ee000  ! 2214: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r14
	.word 0xd2b70e60  ! 2215: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	.word 0xd2c66000  ! 2216: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r9
	mov	0x0, %r27
	.word 0x8780204f  ! 2218: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2219: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc974e60  ! 2220: LDUHA_R	lduha	[%r29, %r0] 0x73, %r14
	mov	0x60, %r17
	.word 0xdca78e80  ! 2222: STWA_R	stwa	%r14, [%r30 + %r0] 0x74
	.word 0xdcf4a000  ! 2223: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xd0a44400  ! 2224: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	mov	0x50, %r26
	.word 0x8780204f  ! 2226: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0866000  ! 2227: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r8
	.word 0xded74e60  ! 2228: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r15
	mov	0x7d0, %r20
	.word 0x87802074  ! 2230: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde9649e0  ! 2231: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r15
	.word 0x87802074  ! 2232: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 2233: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 2234: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xded76000  ! 2235: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0x87802074  ! 2236: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2237: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0f48400  ! 2238: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0x87802073  ! 2239: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0df6000  ! 2240: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 2241: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b62000  ! 2242: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0xd08ee000  ! 2243: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r8
	.word 0x87802073  ! 2244: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r24
	.word 0xdadec9e0  ! 2246: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r13
	.word 0xd2d40400  ! 2247: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	mov	0x20, %r26
	.word 0x8780204f  ! 2249: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 2250: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f72000  ! 2251: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd297e000  ! 2252: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	.word 0x87802072  ! 2253: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4b609e0  ! 2254: STHA_R	stha	%r10, [%r24 + %r0] 0x4f
	mov	0x30, %r24
	.word 0xd6a7ce80  ! 2256: STWA_R	stwa	%r11, [%r31 + %r0] 0x74
	.word 0xdaf48400  ! 2257: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0x87802074  ! 2258: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd49fce80  ! 2259: LDDA_R	ldda	[%r31, %r0] 0x74, %r10
	mov	0x7d0, %r23
	.word 0xd8dcc400  ! 2261: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	mov	0x7f0, %r23
	.word 0x87802074  ! 2263: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8a7a000  ! 2264: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8cf6000  ! 2265: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	mov	0x7f8, %r23
	mov	0x28, %r24
	.word 0xd89f2000  ! 2268: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0xd88f6000  ! 2269: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xd09f8e40  ! 2270: LDDA_R	ldda	[%r30, %r0] 0x72, %r8
	.word 0xd0a72000  ! 2271: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xdeb649e0  ! 2272: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	.word 0xded76000  ! 2273: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0xdc874e40  ! 2274: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r14
	mov	0x68, %r25
	.word 0xdccf2000  ! 2276: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xdcf76000  ! 2277: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xdc876000  ! 2279: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0xd4f48400  ! 2280: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	mov	0x10, %r19
	.word 0x87802073  ! 2282: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd48fa000  ! 2283: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xd2bc0400  ! 2284: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xdaf7ce40  ! 2285: STXA_R	stxa	%r13, [%r31 + %r0] 0x72
	.word 0xd0844400  ! 2286: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r8
	.word 0xd0f72000  ! 2287: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	mov	0x3f8, %r21
	mov	0x10, %r26
	mov	0x48, %r25
	.word 0x87802072  ! 2291: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2d48400  ! 2292: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	.word 0xd2b76000  ! 2293: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2a7a000  ! 2294: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 2295: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2296: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bfe000  ! 2297: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd8f504a0  ! 2298: STXA_R	stxa	%r12, [%r20 + %r0] 0x25
	.word 0xd8b7e000  ! 2299: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0xd2a78e80  ! 2301: STWA_R	stwa	%r9, [%r30 + %r0] 0x74
	.word 0xd6cc4400  ! 2302: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	.word 0x8780204f  ! 2303: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d8, %r22
	.word 0xd4f5c4a0  ! 2305: STXA_R	stxa	%r10, [%r23 + %r0] 0x25
	.word 0xdea609e0  ! 2306: STWA_R	stwa	%r15, [%r24 + %r0] 0x4f
	.word 0xde96a000  ! 2307: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r15
	.word 0xd29f0e60  ! 2308: LDDA_R	ldda	[%r28, %r0] 0x73, %r9
	mov	0x10, %r18
	.word 0x87802025  ! 2310: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cfce40  ! 2311: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r10
	.word 0xd8af8e60  ! 2312: STBA_R	stba	%r12, [%r30 + %r0] 0x73
	.word 0x87802020  ! 2313: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r27
	.word 0xd8b42000  ! 2315: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	.word 0xd2c78e80  ! 2316: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r9
	.word 0xd2946000  ! 2317: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r9
	.word 0xd2c4e000  ! 2318: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xd2c74e60  ! 2319: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r9
	.word 0x87802025  ! 2320: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8f44400  ! 2321: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xd8c5a000  ! 2322: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r12
	.word 0xdcc44400  ! 2323: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xdcbd6000  ! 2324: STDA_I	stda	%r14, [%r21 + 0x0000] %asi
	mov	0x30, %r26
	.word 0xd8dfce40  ! 2326: LDXA_R	ldxa	[%r31, %r0] 0x72, %r12
	mov	0x50, %r26
	.word 0xd8c70e80  ! 2328: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r12
	mov	0x40, %r26
	.word 0x87802025  ! 2330: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 2331: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6ac4400  ! 2332: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xd8b78e40  ! 2333: STHA_R	stha	%r12, [%r30 + %r0] 0x72
	mov	0x3c0, %r22
	mov	0x10, %r25
	.word 0xd4f44400  ! 2336: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0xd6adc4a0  ! 2337: STBA_R	stba	%r11, [%r23 + %r0] 0x25
	.word 0x87802073  ! 2338: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a40400  ! 2339: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0xd2ae89e0  ! 2340: STBA_R	stba	%r9, [%r26 + %r0] 0x4f
	.word 0xd2a7a000  ! 2341: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xdaa74e80  ! 2342: STWA_R	stwa	%r13, [%r29 + %r0] 0x74
	mov	0x68, %r25
	.word 0xd2d74e60  ! 2344: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r9
	.word 0xd2dd04a0  ! 2345: LDXA_R	ldxa	[%r20, %r0] 0x25, %r9
	.word 0x87802020  ! 2346: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r21
	.word 0xd6bfce40  ! 2348: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	.word 0xda9c0400  ! 2349: LDDA_R	ldda	[%r16, %r0] 0x20, %r13
	.word 0xd6848400  ! 2350: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	.word 0xd68f8e40  ! 2351: LDUBA_R	lduba	[%r30, %r0] 0x72, %r11
	.word 0xd6942000  ! 2352: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r11
	mov	0x48, %r26
	mov	0x70, %r19
	.word 0xd89c0400  ! 2355: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	mov	0x3c8, %r23
	.word 0x87802074  ! 2357: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f6c9e0  ! 2358: STXA_R	stxa	%r12, [%r27 + %r0] 0x4f
	.word 0xd8c76000  ! 2359: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8df2000  ! 2360: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	mov	0x38, %r18
	.word 0x87802020  ! 2362: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedf4e40  ! 2363: LDXA_R	ldxa	[%r29, %r0] 0x72, %r15
	.word 0x87802020  ! 2364: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a4c400  ! 2365: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0xd48ce000  ! 2366: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r10
	.word 0xd494a000  ! 2367: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r10
	.word 0xdc9dc4a0  ! 2368: LDDA_R	ldda	[%r23, %r0] 0x25, %r14
	.word 0xdcd46000  ! 2369: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	.word 0xdcc70e60  ! 2370: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r14
	.word 0xd0a689e0  ! 2371: STWA_R	stwa	%r8, [%r26 + %r0] 0x4f
	.word 0xd0a4e000  ! 2372: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0bce000  ! 2373: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0xd0942000  ! 2374: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r8
	.word 0xd6b7ce80  ! 2375: STHA_R	stha	%r11, [%r31 + %r0] 0x74
	.word 0xd8ce89e0  ! 2376: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r12
	.word 0xd88ce000  ! 2377: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	.word 0xdabf0e60  ! 2378: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	.word 0xdabc2000  ! 2379: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 2380: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea78e40  ! 2381: STWA_R	stwa	%r15, [%r30 + %r0] 0x72
	.word 0xdeaca000  ! 2382: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	mov	0x18, %r19
	.word 0x87802025  ! 2384: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde9e49e0  ! 2385: LDDA_R	ldda	[%r25, %r0] 0x4f, %r15
	.word 0xd6a689e0  ! 2386: STWA_R	stwa	%r11, [%r26 + %r0] 0x4f
	.word 0xd4afce80  ! 2387: STBA_R	stba	%r10, [%r31 + %r0] 0x74
	.word 0xd4a5e000  ! 2388: STWA_I	stwa	%r10, [%r23 + 0x0000] %asi
	.word 0xd4d5e000  ! 2389: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r10
	mov	0x78, %r27
	.word 0xd495a000  ! 2391: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r10
	.word 0xdaa40400  ! 2392: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	mov	0x58, %r26
	mov	0x3c0, %r21
	.word 0xdadd6000  ! 2395: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r13
	.word 0xd29c4400  ! 2396: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	mov	0x60, %r24
	.word 0xd2bd6000  ! 2398: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	.word 0xdeb44400  ! 2399: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	mov	0x8, %r26
	.word 0x87802020  ! 2401: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebc6000  ! 2402: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xd6b78e40  ! 2403: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	mov	0x7d0, %r23
	.word 0xd6dca000  ! 2405: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r11
	ta	T_CHANGE_PRIV	! macro
	.word 0xd694a000  ! 2407: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r11
	.word 0xd6aca000  ! 2408: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	mov	0x70, %r16
	mov	0x3e8, %r20
	mov	0x3f8, %r22
	.word 0xd48ec9e0  ! 2412: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r10
	.word 0xdcbcc400  ! 2413: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xdcb42000  ! 2414: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xd687ce60  ! 2415: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r11
	.word 0xd6b4a000  ! 2416: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xdcf504a0  ! 2417: STXA_R	stxa	%r14, [%r20 + %r0] 0x25
	mov	0x50, %r17
	.word 0xdc94a000  ! 2419: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xd8a70e40  ! 2420: STWA_R	stwa	%r12, [%r28 + %r0] 0x72
	mov	0x20, %r24
	.word 0xd6bc8400  ! 2422: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xd6dce000  ! 2423: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0xd8bfce40  ! 2424: STDA_R	stda	%r12, [%r31 + %r0] 0x72
	.word 0xd8dce000  ! 2425: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	.word 0xd49d44a0  ! 2426: LDDA_R	ldda	[%r21, %r0] 0x25, %r10
	.word 0xd6a78e40  ! 2427: STWA_R	stwa	%r11, [%r30 + %r0] 0x72
	mov	0x28, %r26
	.word 0xd2adc4a0  ! 2429: STBA_R	stba	%r9, [%r23 + %r0] 0x25
	.word 0xd284e000  ! 2430: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r9
	.word 0xd6cec9e0  ! 2431: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r11
	mov	0x50, %r18
	.word 0x8780204f  ! 2433: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r17
	.word 0xd6aea000  ! 2435: STBA_I	stba	%r11, [%r26 + 0x0000] %asi
	.word 0xd8d78e60  ! 2436: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r12
	.word 0xd8cea000  ! 2437: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r12
	mov	0x78, %r17
	.word 0x87802072  ! 2439: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 2440: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b78e60  ! 2441: STHA_R	stha	%r9, [%r30 + %r0] 0x73
	.word 0xdc978e80  ! 2442: LDUHA_R	lduha	[%r30, %r0] 0x74, %r14
	.word 0xd8af8e60  ! 2443: STBA_R	stba	%r12, [%r30 + %r0] 0x73
	.word 0xd8f76000  ! 2444: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 2445: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaaf0e40  ! 2446: STBA_R	stba	%r13, [%r28 + %r0] 0x72
	mov	0x60, %r19
	.word 0xdabd84a0  ! 2448: STDA_R	stda	%r13, [%r22 + %r0] 0x25
	.word 0xdea7ce80  ! 2449: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	.word 0xde87a000  ! 2450: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xd6a40400  ! 2451: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0xd2a4c400  ! 2452: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0xd8a504a0  ! 2453: STWA_R	stwa	%r12, [%r20 + %r0] 0x25
	mov	0x40, %r19
	.word 0xd8c7a000  ! 2455: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xd4bc8400  ! 2456: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	mov	0x38, %r16
	.word 0xdac584a0  ! 2458: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r13
	.word 0xde9d44a0  ! 2459: LDDA_R	ldda	[%r21, %r0] 0x25, %r15
	.word 0xdec7e000  ! 2460: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xded7e000  ! 2461: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0xdaac0400  ! 2462: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	mov	0x3f8, %r23
	mov	0x0, %r26
	.word 0xd6f78e60  ! 2465: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	.word 0xd697e000  ! 2466: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	mov	0x40, %r17
	.word 0xdaa70e40  ! 2468: STWA_R	stwa	%r13, [%r28 + %r0] 0x72
	mov	0x7e8, %r21
	.word 0xd09fce40  ! 2470: LDDA_R	ldda	[%r31, %r0] 0x72, %r8
	.word 0xd0cfa000  ! 2471: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0xd0d48400  ! 2472: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	.word 0xd0a72000  ! 2473: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 2474: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd08fe000  ! 2475: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	mov	0x8, %r18
	.word 0xd4b70e80  ! 2477: STHA_R	stha	%r10, [%r28 + %r0] 0x74
	.word 0xd4f7a000  ! 2478: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4bfe000  ! 2479: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2480: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r19
	.word 0xd4d42000  ! 2482: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	mov	0x48, %r19
	.word 0x87802074  ! 2484: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd49e09e0  ! 2485: LDDA_R	ldda	[%r24, %r0] 0x4f, %r10
	.word 0xdeb689e0  ! 2486: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	.word 0xd6f7ce40  ! 2487: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	.word 0xd6cf2000  ! 2488: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0xd4c7ce60  ! 2489: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r10
	mov	0x7f0, %r23
	.word 0xdaf4c400  ! 2491: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xdacfe000  ! 2492: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0xda9504a0  ! 2493: LDUHA_R	lduha	[%r20, %r0] 0x25, %r13
	.word 0xdebf8e60  ! 2494: STDA_R	stda	%r15, [%r30 + %r0] 0x73
	.word 0xdecfe000  ! 2495: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xd4bc8400  ! 2496: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	.word 0xd2c4c400  ! 2497: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0xd0d78e40  ! 2498: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r8
	.word 0xda9c4400  ! 2499: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	.word 0x87802072  ! 2500: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r19
	.word 0xda972000  ! 2502: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	mov	0x3c8, %r21
	.word 0xdaaf2000  ! 2504: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdaa7e000  ! 2505: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xdc978e40  ! 2506: LDUHA_R	lduha	[%r30, %r0] 0x72, %r14
	.word 0xdcd76000  ! 2507: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	.word 0xdc97a000  ! 2508: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	mov	0x7d8, %r22
	.word 0xdccfa000  ! 2510: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0x87802073  ! 2511: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2d74e80  ! 2512: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r9
	mov	0x3d8, %r20
	.word 0xdab74e40  ! 2514: STHA_R	stha	%r13, [%r29 + %r0] 0x72
	.word 0xdadfe000  ! 2515: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0xdaf72000  ! 2516: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdac7ce60  ! 2517: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r13
	mov	0x38, %r27
	.word 0xdaa72000  ! 2519: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2520: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8c0400  ! 2521: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0xdadfce80  ! 2522: LDXA_R	ldxa	[%r31, %r0] 0x74, %r13
	.word 0x87802074  ! 2523: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdac72000  ! 2524: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2525: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac46000  ! 2526: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r13
	mov	0x7f0, %r21
	mov	0x0, %r17
	.word 0xdab4a000  ! 2529: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	mov	0x3c8, %r20
	.word 0xdaa42000  ! 2531: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	mov	0x7e8, %r20
	mov	0x3e8, %r23
	mov	0x7d8, %r21
	mov	0x38, %r26
	.word 0xdaa4a000  ! 2536: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xda8ce000  ! 2538: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	.word 0xdcb40400  ! 2539: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xdcf4a000  ! 2540: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdca4a000  ! 2541: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcbc2000  ! 2542: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xd8a504a0  ! 2543: STWA_R	stwa	%r12, [%r20 + %r0] 0x25
	.word 0xd8ace000  ! 2544: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	mov	0x3c8, %r20
	mov	0x3d0, %r23
	.word 0xd8af0e80  ! 2547: STBA_R	stba	%r12, [%r28 + %r0] 0x74
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd88ca000  ! 2549: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	mov	0x40, %r19
	.word 0x87802074  ! 2551: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc94c400  ! 2552: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	.word 0x87802072  ! 2553: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbf6000  ! 2554: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdef7ce40  ! 2555: STXA_R	stxa	%r15, [%r31 + %r0] 0x72
	.word 0xdef7e000  ! 2556: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	mov	0x7f8, %r22
	mov	0x0, %r24
	.word 0x87802025  ! 2559: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad78e60  ! 2560: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r13
	.word 0xd0c70e40  ! 2561: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r8
	.word 0xd0ade000  ! 2562: STBA_I	stba	%r8, [%r23 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xd0b70e40  ! 2564: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	.word 0xd0a5e000  ! 2565: STWA_I	stwa	%r8, [%r23 + 0x0000] %asi
	.word 0xd0dd2000  ! 2566: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0xd0bd2000  ! 2567: STDA_I	stda	%r8, [%r20 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xd08d6000  ! 2569: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r8
	mov	0x28, %r27
	mov	0x70, %r25
	.word 0x87802025  ! 2572: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0b52000  ! 2573: STHA_I	stha	%r8, [%r20 + 0x0000] %asi
	.word 0xd0ad6000  ! 2574: STBA_I	stba	%r8, [%r21 + 0x0000] %asi
	.word 0xd0952000  ! 2575: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r8
	.word 0xdcdcc400  ! 2576: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	.word 0x87802020  ! 2577: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2578: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2579: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf78e40  ! 2580: STXA_R	stxa	%r13, [%r30 + %r0] 0x72
	.word 0xda872000  ! 2581: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	mov	0x8, %r16
	.word 0xd8dc4400  ! 2583: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0xd8b7a000  ! 2584: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 2585: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a48400  ! 2586: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0xd0bf0e40  ! 2587: STDA_R	stda	%r8, [%r28 + %r0] 0x72
	.word 0xd08ca000  ! 2588: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xd0ac2000  ! 2589: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xd08ce000  ! 2590: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0a4e000  ! 2591: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd08c2000  ! 2592: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0xd0d4e000  ! 2593: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	.word 0xd0b4e000  ! 2594: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xd8dc4400  ! 2595: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x7e8, %r21
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd8dce000  ! 2599: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	.word 0xd8ac2000  ! 2600: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0xd4c48400  ! 2601: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r10
	.word 0x87802072  ! 2602: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4974e40  ! 2603: LDUHA_R	lduha	[%r29, %r0] 0x72, %r10
	.word 0xd48f6000  ! 2604: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xde8e49e0  ! 2605: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r15
	.word 0xdeafe000  ! 2606: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 2607: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdecc0400  ! 2608: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r15
	.word 0x87802020  ! 2609: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeac2000  ! 2610: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xde8ce000  ! 2611: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	.word 0x87802073  ! 2612: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xded72000  ! 2613: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	mov	0x7e8, %r23
	.word 0xded72000  ! 2615: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	mov	0x3f0, %r21
	.word 0xdef76000  ! 2617: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdcbf8e60  ! 2618: STDA_R	stda	%r14, [%r30 + %r0] 0x73
	.word 0xdcaf4e80  ! 2619: STBA_R	stba	%r14, [%r29 + %r0] 0x74
	.word 0xdcf7e000  ! 2620: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdeac8400  ! 2621: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xdcaf4e60  ! 2622: STBA_R	stba	%r14, [%r29 + %r0] 0x73
	.word 0x87802025  ! 2623: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdea689e0  ! 2624: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	mov	0x7d8, %r23
	mov	0x70, %r18
	.word 0x87802073  ! 2627: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeafe000  ! 2628: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xdebfe000  ! 2629: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	mov	0x0, %r19
	mov	0x7f8, %r20
	.word 0xdecf2000  ! 2632: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xdef72000  ! 2633: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xda8f0e60  ! 2634: LDUBA_R	lduba	[%r28, %r0] 0x73, %r13
	.word 0xdaa72000  ! 2635: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2636: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbe49e0  ! 2637: STDA_R	stda	%r14, [%r25 + %r0] 0x4f
	.word 0xd8d4c400  ! 2638: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0xd8bce000  ! 2639: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd8b42000  ! 2640: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	mov	0x20, %r18
	.word 0x87802020  ! 2642: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bce000  ! 2643: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd8c42000  ! 2644: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r12
	mov	0x20, %r27
	mov	0x48, %r16
	.word 0xd8bfce40  ! 2647: STDA_R	stda	%r12, [%r31 + %r0] 0x72
	.word 0xd48c0400  ! 2648: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	.word 0xd4bca000  ! 2649: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0xdca504a0  ! 2650: STWA_R	stwa	%r14, [%r20 + %r0] 0x25
	.word 0x87802025  ! 2651: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0c4c400  ! 2652: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	.word 0xd0952000  ! 2653: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r8
	.word 0xd08c8400  ! 2654: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0x87802074  ! 2655: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2656: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd084a000  ! 2657: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	.word 0xd4de49e0  ! 2658: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r10
	.word 0xd6dc0400  ! 2659: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	.word 0x87802072  ! 2660: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 2661: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6d78e60  ! 2662: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r11
	.word 0x87802025  ! 2663: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 2664: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 2665: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6956000  ! 2666: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r11
	.word 0x87802073  ! 2667: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bc0400  ! 2668: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xdebe89e0  ! 2669: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	.word 0xdcdf8e80  ! 2670: LDXA_R	ldxa	[%r30, %r0] 0x74, %r14
	.word 0xdcdfa000  ! 2671: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	mov	0x7f0, %r20
	.word 0xd8f78e40  ! 2673: STXA_R	stxa	%r12, [%r30 + %r0] 0x72
	.word 0xd89f2000  ! 2674: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0xd8f72000  ! 2675: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8d72000  ! 2676: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xdab584a0  ! 2677: STHA_R	stha	%r13, [%r22 + %r0] 0x25
	mov	0x7f8, %r22
	.word 0xdab76000  ! 2679: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0xd4d48400  ! 2681: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	.word 0xd8bec9e0  ! 2682: STDA_R	stda	%r12, [%r27 + %r0] 0x4f
	.word 0xd4c70e40  ! 2683: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r10
	.word 0xd6a44400  ! 2684: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0xd6a76000  ! 2685: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6cfe000  ! 2686: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	mov	0x3f8, %r20
	.word 0x87802073  ! 2688: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r17
	.word 0xd0acc400  ! 2690: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 2691: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b66000  ! 2692: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	.word 0xd4ccc400  ! 2693: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0xd4c66000  ! 2694: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r10
	.word 0xd4be2000  ! 2695: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xd8874e40  ! 2697: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r12
	.word 0xd8866000  ! 2698: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r12
	.word 0xd6a4c400  ! 2699: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0xd0ac0400  ! 2700: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	.word 0xd08ea000  ! 2701: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r8
	.word 0xdadd84a0  ! 2702: LDXA_R	ldxa	[%r22, %r0] 0x25, %r13
	.word 0xdec70e80  ! 2703: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r15
	.word 0x87802020  ! 2704: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebc2000  ! 2705: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xdcb649e0  ! 2706: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	.word 0x87802074  ! 2707: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdecf4e40  ! 2708: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r15
	.word 0xdeb72000  ! 2709: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xde9e49e0  ! 2710: LDDA_R	ldda	[%r25, %r0] 0x4f, %r15
	mov	0x3e8, %r23
	.word 0xd4af0e80  ! 2712: STBA_R	stba	%r10, [%r28 + %r0] 0x74
	.word 0xde8c4400  ! 2713: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	.word 0x87802020  ! 2714: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdecc6000  ! 2715: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r15
	.word 0xde942000  ! 2716: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	mov	0x78, %r16
	.word 0xd0bc8400  ! 2718: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	mov	0x18, %r17
	.word 0xd0a4e000  ! 2720: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd4b48400  ! 2721: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd4d4e000  ! 2722: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0x87802072  ! 2723: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r27
	.word 0xd6840400  ! 2725: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0xd6cfe000  ! 2726: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0x87802072  ! 2727: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r27
	.word 0xd8878e60  ! 2729: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r12
	mov	0x3d8, %r23
	mov	0x3d0, %r20
	.word 0xd6bfce40  ! 2732: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	mov	0x3f0, %r22
	.word 0x87802025  ! 2734: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d0, %r21
	.word 0xd6dd2000  ! 2736: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r11
	mov	0x7d8, %r22
	mov	0x20, %r19
	.word 0xdcbd04a0  ! 2739: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	.word 0xdaf6c9e0  ! 2740: STXA_R	stxa	%r13, [%r27 + %r0] 0x4f
	mov	0x3d8, %r21
	.word 0xd6c48400  ! 2742: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	.word 0x87802025  ! 2743: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r26
	.word 0xd6dde000  ! 2745: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r11
	.word 0xd6f56000  ! 2746: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	.word 0xd685e000  ! 2747: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r11
	mov	0x50, %r24
	.word 0xd09689e0  ! 2749: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r8
	.word 0xdcf6c9e0  ! 2750: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	mov	0x70, %r24
	.word 0xdedfce40  ! 2752: LDXA_R	ldxa	[%r31, %r0] 0x72, %r15
	mov	0x3d8, %r21
	.word 0xd0d7ce60  ! 2754: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r8
	.word 0xde8f0e60  ! 2755: LDUBA_R	lduba	[%r28, %r0] 0x73, %r15
	mov	0x18, %r19
	.word 0xd2cf4e60  ! 2757: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r9
	.word 0xdef78e40  ! 2758: STXA_R	stxa	%r15, [%r30 + %r0] 0x72
	.word 0xd0ac8400  ! 2759: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	mov	0x48, %r16
	.word 0xd09da000  ! 2761: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r8
	.word 0xdaa7ce60  ! 2762: STWA_R	stwa	%r13, [%r31 + %r0] 0x73
	.word 0x87802074  ! 2763: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2764: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2765: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2af0e40  ! 2766: STBA_R	stba	%r9, [%r28 + %r0] 0x72
	.word 0xd28504a0  ! 2767: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r9
	.word 0x87802020  ! 2768: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28c6000  ! 2769: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0xd2942000  ! 2770: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 2771: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r19
	.word 0x87802074  ! 2773: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f584a0  ! 2774: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	mov	0x7e8, %r23
	mov	0x18, %r17
	mov	0x7c0, %r20
	.word 0xd0f7e000  ! 2778: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0x8780204f  ! 2780: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2acc400  ! 2781: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	mov	0x78, %r17
	.word 0xd2f6a000  ! 2783: STXA_I	stxa	%r9, [%r26 + 0x0000] %asi
	.word 0xd2de2000  ! 2784: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2b62000  ! 2786: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	.word 0xd0a44400  ! 2787: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xdcd74e40  ! 2788: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r14
	mov	0x7f0, %r23
	mov	0x38, %r25
	.word 0x87802025  ! 2791: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebc8400  ! 2792: STDA_R	stda	%r15, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 2793: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r26
	.word 0x8780204f  ! 2795: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeaea000  ! 2796: STBA_I	stba	%r15, [%r26 + 0x0000] %asi
	.word 0xd4a40400  ! 2797: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	.word 0x87802074  ! 2798: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2799: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdac40400  ! 2800: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	.word 0xda87a000  ! 2801: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0xdaccc400  ! 2802: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r13
	.word 0xdabfa000  ! 2803: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xd4acc400  ! 2804: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xd4f76000  ! 2805: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4a76000  ! 2806: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xdacf0e80  ! 2807: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r13
	mov	0x48, %r19
	.word 0x87802074  ! 2809: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r18
	.word 0xda87e000  ! 2811: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0xda8f2000  ! 2812: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xd4d40400  ! 2813: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	mov	0x3e0, %r21
	.word 0xd48f6000  ! 2815: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0x87802072  ! 2816: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 2817: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r17
	mov	0x50, %r19
	.word 0xd0bf8e60  ! 2820: STDA_R	stda	%r8, [%r30 + %r0] 0x73
	.word 0xd0d7a000  ! 2821: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0xd0a72000  ! 2822: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xd09f4e60  ! 2823: LDDA_R	ldda	[%r29, %r0] 0x73, %r8
	.word 0xd0976000  ! 2824: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd6dc4400  ! 2825: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xda8f8e80  ! 2826: LDUBA_R	lduba	[%r30, %r0] 0x74, %r13
	.word 0x87802020  ! 2827: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bf8e80  ! 2828: STDA_R	stda	%r10, [%r30 + %r0] 0x74
	.word 0xd49f0e80  ! 2829: LDDA_R	ldda	[%r28, %r0] 0x74, %r10
	mov	0x3d8, %r22
	.word 0xd494a000  ! 2831: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r10
	mov	0x40, %r27
	.word 0xdef689e0  ! 2833: STXA_R	stxa	%r15, [%r26 + %r0] 0x4f
	.word 0xde9c6000  ! 2834: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0xdebca000  ! 2835: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xdeace000  ! 2836: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xd2a40400  ! 2837: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	mov	0x10, %r19
	.word 0x87802020  ! 2839: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28ca000  ! 2840: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	mov	0x68, %r25
	mov	0x68, %r25
	.word 0xd284e000  ! 2843: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r9
	.word 0xd4df0e40  ! 2844: LDXA_R	ldxa	[%r28, %r0] 0x72, %r10
	.word 0xdc86c9e0  ! 2845: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r14
	.word 0x87802025  ! 2846: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 2847: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf7e000  ! 2848: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x68, %r19
	.word 0xdc872000  ! 2850: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 2851: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x8780204f  ! 2853: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2ad04a0  ! 2854: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	mov	0x7f0, %r22
	.word 0xdeb689e0  ! 2856: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	mov	0x7e8, %r22
	.word 0xd6bc0400  ! 2858: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xd6a40400  ! 2859: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0xd48f8e80  ! 2860: LDUBA_R	lduba	[%r30, %r0] 0x74, %r10
	.word 0xd4866000  ! 2861: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r10
	mov	0x3f8, %r23
	mov	0x7d8, %r23
	.word 0xd4a6e000  ! 2864: STWA_I	stwa	%r10, [%r27 + 0x0000] %asi
	mov	0x40, %r26
	.word 0xd4a6e000  ! 2866: STWA_I	stwa	%r10, [%r27 + 0x0000] %asi
	.word 0xdccf0e40  ! 2867: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r14
	.word 0xd29cc400  ! 2868: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	.word 0xd2ae6000  ! 2869: STBA_I	stba	%r9, [%r25 + 0x0000] %asi
	.word 0xd28e2000  ! 2870: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	mov	0x3c8, %r22
	.word 0xd2cee000  ! 2872: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	.word 0xd2de2000  ! 2873: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r9
	.word 0xdcd609e0  ! 2874: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r14
	.word 0xde8689e0  ! 2875: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r15
	.word 0xdea6e000  ! 2876: STWA_I	stwa	%r15, [%r27 + 0x0000] %asi
	.word 0xdef66000  ! 2877: STXA_I	stxa	%r15, [%r25 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xd8acc400  ! 2879: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	mov	0x3c8, %r20
	.word 0xdaa7ce80  ! 2881: STWA_R	stwa	%r13, [%r31 + %r0] 0x74
	ta	T_CHANGE_PRIV	! macro
	.word 0xd4c44400  ! 2883: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r10
	.word 0xd6a78e60  ! 2884: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0xd6bee000  ! 2885: STDA_I	stda	%r11, [%r27 + 0x0000] %asi
	.word 0xdeac8400  ! 2886: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	mov	0x38, %r16
	.word 0xdab74e40  ! 2888: STHA_R	stha	%r13, [%r29 + %r0] 0x72
	.word 0xdebfce60  ! 2889: STDA_R	stda	%r15, [%r31 + %r0] 0x73
	.word 0xde9c4400  ! 2890: LDDA_R	ldda	[%r17, %r0] 0x20, %r15
	.word 0x87802073  ! 2891: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d8, %r22
	.word 0xdac74e80  ! 2893: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r13
	.word 0xd6dc8400  ! 2894: LDXA_R	ldxa	[%r18, %r0] 0x20, %r11
	.word 0xd697a000  ! 2895: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0xd6d76000  ! 2896: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	mov	0x7f0, %r21
	.word 0xd4a70e40  ! 2898: STWA_R	stwa	%r10, [%r28 + %r0] 0x72
	.word 0xdaccc400  ! 2899: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r13
	.word 0xd88e09e0  ! 2900: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r12
	mov	0x60, %r19
	mov	0x60, %r17
	.word 0xdcac0400  ! 2903: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xdcce09e0  ! 2904: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r14
	.word 0xd087ce80  ! 2905: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r8
	.word 0xdaf74e60  ! 2906: STXA_R	stxa	%r13, [%r29 + %r0] 0x73
	mov	0x48, %r27
	.word 0xdabf6000  ! 2908: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	mov	0x68, %r18
	mov	0x78, %r17
	.word 0xd096c9e0  ! 2911: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r8
	.word 0xd0af6000  ! 2912: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd0bf6000  ! 2913: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 2914: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0972000  ! 2915: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xd2bf8e40  ! 2916: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	mov	0x58, %r27
	.word 0x87802025  ! 2918: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c8, %r21
	.word 0xdeadc4a0  ! 2920: STBA_R	stba	%r15, [%r23 + %r0] 0x25
	.word 0xdef56000  ! 2921: STXA_I	stxa	%r15, [%r21 + 0x0000] %asi
	.word 0xd6b504a0  ! 2922: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	.word 0xd6cde000  ! 2923: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r11
	.word 0xdecfce80  ! 2924: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r15
	ta	T_CHANGE_HPRIV	! macro
	mov	0x38, %r19
	.word 0xdeade000  ! 2927: STBA_I	stba	%r15, [%r23 + 0x0000] %asi
	.word 0xda84c400  ! 2928: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r13
	.word 0xdaada000  ! 2929: STBA_I	stba	%r13, [%r22 + 0x0000] %asi
	.word 0xdaade000  ! 2930: STBA_I	stba	%r13, [%r23 + 0x0000] %asi
	.word 0xda85e000  ! 2931: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	.word 0xdab56000  ! 2932: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	mov	0x0, %r25
	mov	0x8, %r17
	mov	0x28, %r27
	.word 0xd69e89e0  ! 2936: LDDA_R	ldda	[%r26, %r0] 0x4f, %r11
	.word 0xd2bfce40  ! 2937: STDA_R	stda	%r9, [%r31 + %r0] 0x72
	.word 0xdcdcc400  ! 2938: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd28fce60  ! 2940: LDUBA_R	lduba	[%r31, %r0] 0x73, %r9
	.word 0xdaccc400  ! 2941: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r13
	.word 0x87802072  ! 2942: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaad84a0  ! 2943: STBA_R	stba	%r13, [%r22 + %r0] 0x25
	.word 0xdaacc400  ! 2944: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0x87802074  ! 2945: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2946: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa78e80  ! 2947: STWA_R	stwa	%r13, [%r30 + %r0] 0x74
	.word 0xdadc6000  ! 2948: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xda9ca000  ! 2949: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	.word 0xdca44400  ! 2950: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0xdcb4e000  ! 2951: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xdcd4c400  ! 2952: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	mov	0x50, %r17
	.word 0xdaa78e80  ! 2954: STWA_R	stwa	%r13, [%r30 + %r0] 0x74
	mov	0x18, %r24
	.word 0xdaf78e80  ! 2956: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	.word 0xd6a649e0  ! 2957: STWA_R	stwa	%r11, [%r25 + %r0] 0x4f
	.word 0xd6a7ce40  ! 2958: STWA_R	stwa	%r11, [%r31 + %r0] 0x72
	.word 0xdc87ce80  ! 2959: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r14
	mov	0x3e8, %r21
	mov	0x70, %r16
	.word 0xdcb42000  ! 2962: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 2963: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2964: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2965: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r26
	.word 0xdc97e000  ! 2967: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xdca7a000  ! 2968: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcb7a000  ! 2969: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xd6bfce80  ! 2970: STDA_R	stda	%r11, [%r31 + %r0] 0x74
	mov	0x50, %r25
	.word 0xd69fa000  ! 2972: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0xd2dc0400  ! 2973: LDXA_R	ldxa	[%r16, %r0] 0x20, %r9
	.word 0xd2a76000  ! 2974: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xdad609e0  ! 2975: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r13
	.word 0xdc974e60  ! 2976: LDUHA_R	lduha	[%r29, %r0] 0x73, %r14
	mov	0x78, %r16
	.word 0xdadcc400  ! 2978: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xd4adc4a0  ! 2979: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0xd8cfce60  ! 2980: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r12
	.word 0xd6b78e60  ! 2981: STHA_R	stha	%r11, [%r30 + %r0] 0x73
	.word 0xd6d7e000  ! 2982: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	mov	0x30, %r19
	.word 0xd69fe000  ! 2984: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	.word 0xd2cd04a0  ! 2985: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r9
	.word 0xd2b72000  ! 2986: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xdeb4c400  ! 2987: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	mov	0x20, %r16
	.word 0xde97e000  ! 2989: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0xdcd48400  ! 2990: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	mov	0x60, %r26
	.word 0xdc876000  ! 2992: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0xdc974e80  ! 2993: LDUHA_R	lduha	[%r29, %r0] 0x74, %r14
	.word 0x87802072  ! 2994: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6c649e0  ! 2995: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r11
	.word 0xdc8e89e0  ! 2996: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r14
	.word 0x8780204f  ! 2997: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbee000  ! 2998: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xd494c400  ! 3000: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	.word 0x87802020  ! 3001: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b46000  ! 3002: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xd4a4e000  ! 3003: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xd49ca000  ! 3004: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd2bf4e80  ! 3005: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	.word 0x87802020  ! 3006: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a4e000  ! 3007: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2a42000  ! 3008: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	.word 0xdab7ce40  ! 3009: STHA_R	stha	%r13, [%r31 + %r0] 0x72
	.word 0xdabca000  ! 3010: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	mov	0x0, %r27
	.word 0xd2cf0e80  ! 3012: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r9
	.word 0xd68d04a0  ! 3013: LDUBA_R	lduba	[%r20, %r0] 0x25, %r11
	ta	T_CHANGE_PRIV	! macro
	mov	0x70, %r26
	.word 0xdcb7ce80  ! 3016: STHA_R	stha	%r14, [%r31 + %r0] 0x74
	.word 0xd4bd84a0  ! 3017: STDA_R	stda	%r10, [%r22 + %r0] 0x25
	.word 0xd4d46000  ! 3018: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r10
	.word 0xd0bf8e80  ! 3019: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	.word 0xd4bd04a0  ! 3020: STDA_R	stda	%r10, [%r20 + %r0] 0x25
	.word 0xd49c6000  ! 3021: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0xd4cce000  ! 3022: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	mov	0x28, %r16
	.word 0x8780204f  ! 3024: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a62000  ! 3025: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	.word 0xd2b504a0  ! 3026: STHA_R	stha	%r9, [%r20 + %r0] 0x25
	.word 0xd2c62000  ! 3027: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r9
	.word 0x87802072  ! 3028: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 3029: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r27
	mov	0x10, %r19
	.word 0xd8a689e0  ! 3032: STWA_R	stwa	%r12, [%r26 + %r0] 0x4f
	.word 0xd69ec9e0  ! 3033: LDDA_R	ldda	[%r27, %r0] 0x4f, %r11
	.word 0xd8af0e80  ! 3034: STBA_R	stba	%r12, [%r28 + %r0] 0x74
	.word 0x87802072  ! 3035: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r27
	mov	0x28, %r27
	.word 0xd8d76000  ! 3038: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xd89f6000  ! 3039: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	.word 0xd2b70e80  ! 3040: STHA_R	stha	%r9, [%r28 + %r0] 0x74
	.word 0xd2876000  ! 3041: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xd8c7ce60  ! 3042: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r12
	.word 0xd6c689e0  ! 3043: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r11
	.word 0x8780204f  ! 3044: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3045: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3046: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6a544a0  ! 3047: STWA_R	stwa	%r11, [%r21 + %r0] 0x25
	.word 0x87802073  ! 3048: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc9f0e80  ! 3049: LDDA_R	ldda	[%r28, %r0] 0x74, %r14
	.word 0xdcb4c400  ! 3050: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xd29d04a0  ! 3051: LDDA_R	ldda	[%r20, %r0] 0x25, %r9
	.word 0xd2af2000  ! 3052: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	mov	0x38, %r25
	.word 0x87802074  ! 3054: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd297a000  ! 3055: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	mov	0x7f8, %r22
	.word 0xde9f8e60  ! 3057: LDDA_R	ldda	[%r30, %r0] 0x73, %r15
	.word 0xd6ce09e0  ! 3058: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r11
	.word 0xd6bfe000  ! 3059: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0x8780204f  ! 3061: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0cc0400  ! 3062: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xd6c4c400  ! 3063: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r11
	.word 0xd6bc8400  ! 3064: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xd0b44400  ! 3065: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 3066: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e8, %r22
	.word 0xd0c6a000  ! 3068: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r8
	mov	0x7e0, %r22
	mov	0x10, %r17
	mov	0x38, %r26
	.word 0xd4b70e60  ! 3072: STHA_R	stha	%r10, [%r28 + %r0] 0x73
	mov	0x60, %r25
	mov	0x7c0, %r23
	.word 0xd4be2000  ! 3075: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	.word 0xd4bea000  ! 3076: STDA_I	stda	%r10, [%r26 + 0x0000] %asi
	mov	0x0, %r25
	.word 0xd68689e0  ! 3078: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r11
	mov	0x10, %r27
	.word 0xd0cec9e0  ! 3080: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r8
	.word 0xd4bf8e40  ! 3081: STDA_R	stda	%r10, [%r30 + %r0] 0x72
	.word 0x87802073  ! 3082: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f7a000  ! 3083: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4b7a000  ! 3084: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd4cf2000  ! 3085: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd8b70e40  ! 3086: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0xd8f76000  ! 3087: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd4a44400  ! 3088: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xd6cfce60  ! 3089: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r11
	.word 0xd6cfe000  ! 3090: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0xd6cf6000  ! 3091: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6bfa000  ! 3092: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xdcafce80  ! 3093: STBA_R	stba	%r14, [%r31 + %r0] 0x74
	mov	0x7d0, %r20
	.word 0xdcf7a000  ! 3095: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xdc976000  ! 3096: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	.word 0xdcd76000  ! 3097: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 3098: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbe6000  ! 3099: STDA_I	stda	%r14, [%r25 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0xdc86e000  ! 3101: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r14
	.word 0x87802020  ! 3102: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde870e80  ! 3103: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r15
	.word 0xd29cc400  ! 3104: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	.word 0xd2d4a000  ! 3105: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	.word 0xdabdc4a0  ! 3106: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	.word 0xd484c400  ! 3107: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	mov	0x78, %r26
	.word 0xd4ac2000  ! 3109: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 3110: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd68f8e80  ! 3111: LDUBA_R	lduba	[%r30, %r0] 0x74, %r11
	.word 0xd6bfe000  ! 3112: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd6a72000  ! 3113: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	mov	0x38, %r16
	.word 0xdcdc8400  ! 3115: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	.word 0xd2a649e0  ! 3116: STWA_R	stwa	%r9, [%r25 + %r0] 0x4f
	mov	0x8, %r27
	.word 0xdcccc400  ! 3118: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	.word 0x87802020  ! 3119: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc8cc400  ! 3120: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	mov	0x10, %r26
	.word 0xdca42000  ! 3122: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xdcac6000  ! 3123: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3124: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r21
	.word 0xdcac2000  ! 3126: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	mov	0x20, %r18
	mov	0x78, %r17
	.word 0xdcb7ce60  ! 3129: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	mov	0x3f0, %r21
	.word 0x87802020  ! 3131: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3132: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 3133: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc87e000  ! 3134: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0x87802025  ! 3135: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r27
	mov	0x7e0, %r23
	.word 0xd0b7ce80  ! 3138: STHA_R	stha	%r8, [%r31 + %r0] 0x74
	.word 0x87802020  ! 3139: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09ca000  ! 3140: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	.word 0xd0a4a000  ! 3141: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0xd89e89e0  ! 3142: LDDA_R	ldda	[%r26, %r0] 0x4f, %r12
	mov	0x18, %r19
	mov	0x28, %r24
	.word 0xd2b78e40  ! 3145: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	mov	0x20, %r16
	.word 0x87802074  ! 3147: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r24
	mov	0x8, %r24
	.word 0xd4dc0400  ! 3150: LDXA_R	ldxa	[%r16, %r0] 0x20, %r10
	.word 0xd4af2000  ! 3151: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd6b5c4a0  ! 3152: STHA_R	stha	%r11, [%r23 + %r0] 0x25
	.word 0x87802073  ! 3153: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d0, %r23
	.word 0xd68fa000  ! 3155: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 3156: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r16
	mov	0x78, %r26
	mov	0x38, %r17
	.word 0xd0af4e60  ! 3160: STBA_R	stba	%r8, [%r29 + %r0] 0x73
	.word 0x87802020  ! 3161: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09c2000  ! 3162: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r8
	.word 0xdac70e40  ! 3163: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r13
	.word 0x87802073  ! 3164: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8844400  ! 3165: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r12
	.word 0xdcb70e80  ! 3166: STHA_R	stha	%r14, [%r28 + %r0] 0x74
	.word 0xdcdf6000  ! 3167: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	mov	0x18, %r19
	.word 0xd8af0e80  ! 3169: STBA_R	stba	%r12, [%r28 + %r0] 0x74
	.word 0xdccfce80  ! 3170: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r14
	mov	0x78, %r16
	mov	0x58, %r18
	.word 0xd884c400  ! 3173: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	.word 0x8780204f  ! 3174: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r24
	mov	0x78, %r27
	.word 0xdeb70e40  ! 3177: STHA_R	stha	%r15, [%r28 + %r0] 0x72
	.word 0xded70e40  ! 3178: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r15
	mov	0x0, %r24
	.word 0xd0ac0400  ! 3180: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	.word 0xd0866000  ! 3181: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r8
	.word 0xd08e2000  ! 3182: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r8
	.word 0xd2de89e0  ! 3183: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r9
	.word 0xd49fce80  ! 3184: LDDA_R	ldda	[%r31, %r0] 0x74, %r10
	mov	0x70, %r18
	.word 0xdabfce80  ! 3186: STDA_R	stda	%r13, [%r31 + %r0] 0x74
	mov	0x3d8, %r21
	mov	0x0, %r18
	.word 0xdabe2000  ! 3189: STDA_I	stda	%r13, [%r24 + 0x0000] %asi
	.word 0xd89fce80  ! 3190: LDDA_R	ldda	[%r31, %r0] 0x74, %r12
	.word 0xd6acc400  ! 3191: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xdedf4e80  ! 3192: LDXA_R	ldxa	[%r29, %r0] 0x74, %r15
	.word 0x87802020  ! 3193: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r22
	mov	0x20, %r24
	.word 0xdeb4e000  ! 3196: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 3197: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x0, %r19
	.word 0xda8f0e60  ! 3199: LDUBA_R	lduba	[%r28, %r0] 0x73, %r13
	.word 0xded7ce40  ! 3200: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r15
	.word 0xd09f8e40  ! 3201: LDDA_R	ldda	[%r30, %r0] 0x72, %r8
	mov	0x68, %r17
	mov	0x38, %r26
	.word 0x87802074  ! 3204: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b72000  ! 3205: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd09fa000  ! 3206: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	.word 0xde94c400  ! 3207: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	.word 0xd2c78e40  ! 3208: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r9
	.word 0xd6d7ce60  ! 3209: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r11
	.word 0xd6bf0e60  ! 3210: STDA_R	stda	%r11, [%r28 + %r0] 0x73
	.word 0x87802073  ! 3211: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3212: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb70e40  ! 3213: STHA_R	stha	%r14, [%r28 + %r0] 0x72
	.word 0x87802020  ! 3214: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbd04a0  ! 3215: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	.word 0xdcbf0e60  ! 3216: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	.word 0x87802020  ! 3217: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc94a000  ! 3218: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	mov	0x7e8, %r23
	mov	0x28, %r16
	mov	0x7d8, %r21
	mov	0x3c0, %r22
	.word 0x87802020  ! 3223: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3224: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3225: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdccea000  ! 3226: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r14
	.word 0xd4a7ce40  ! 3227: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	.word 0xd4b6a000  ! 3228: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 3229: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3230: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r18
	.word 0xd4c544a0  ! 3232: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r10
	.word 0xd4df2000  ! 3233: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4bf2000  ! 3234: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd6844400  ! 3235: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r11
	mov	0x38, %r25
	.word 0x87802025  ! 3237: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3238: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r19
	.word 0xd6b42000  ! 3240: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0xd8d504a0  ! 3241: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r12
	.word 0xd6a70e60  ! 3242: STWA_R	stwa	%r11, [%r28 + %r0] 0x73
	.word 0xdef48400  ! 3243: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0x87802020  ! 3244: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a7ce80  ! 3245: STWA_R	stwa	%r9, [%r31 + %r0] 0x74
	.word 0xd2f4e000  ! 3246: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2ace000  ! 3247: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	mov	0x68, %r17
	mov	0x70, %r18
	.word 0x87802073  ! 3250: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 3251: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2d504a0  ! 3252: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r9
	mov	0x7c0, %r20
	mov	0x30, %r24
	.word 0xd29fa000  ! 3255: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd297a000  ! 3256: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	.word 0xd2b72000  ! 3257: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 3258: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28c6000  ! 3259: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0x87802073  ! 3260: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2c76000  ! 3261: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2b72000  ! 3262: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd2b44400  ! 3263: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0xdcbf4e60  ! 3264: STDA_R	stda	%r14, [%r29 + %r0] 0x73
	.word 0xd6dcc400  ! 3265: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	.word 0xd6afe000  ! 3266: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd6c7e000  ! 3267: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xdac4c400  ! 3268: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r13
	.word 0xdad7a000  ! 3269: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0xda97a000  ! 3270: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xde8f8e40  ! 3271: LDUBA_R	lduba	[%r30, %r0] 0x72, %r15
	mov	0x68, %r16
	.word 0xdea7e000  ! 3273: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xd09f0e40  ! 3274: LDDA_R	ldda	[%r28, %r0] 0x72, %r8
	.word 0xded48400  ! 3275: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	.word 0xdea40400  ! 3276: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xdeb7a000  ! 3277: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xded72000  ! 3279: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xdcb44400  ! 3280: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0xdcd7a000  ! 3281: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0xd6bf4e80  ! 3282: STDA_R	stda	%r11, [%r29 + %r0] 0x74
	.word 0xdebe49e0  ! 3283: STDA_R	stda	%r15, [%r25 + %r0] 0x4f
	.word 0xdebfa000  ! 3284: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xde8f6000  ! 3285: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3286: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r20
	.word 0x87802073  ! 3288: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef72000  ! 3289: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 3290: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdecd6000  ! 3291: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r15
	mov	0x7e8, %r22
	.word 0xde8d6000  ! 3293: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r15
	mov	0x40, %r19
	.word 0x87802073  ! 3295: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f40400  ! 3296: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xdeccc400  ! 3297: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r15
	.word 0xdeaf2000  ! 3298: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xd49e89e0  ! 3299: LDDA_R	ldda	[%r26, %r0] 0x4f, %r10
	mov	0x60, %r27
	mov	0x3c0, %r22
	.word 0xd28d44a0  ! 3302: LDUBA_R	lduba	[%r21, %r0] 0x25, %r9
	.word 0xd2df8e80  ! 3303: LDXA_R	ldxa	[%r30, %r0] 0x74, %r9
	.word 0x8780204f  ! 3304: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd28e2000  ! 3305: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	.word 0xd286a000  ! 3306: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r9
	.word 0xdad609e0  ! 3307: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r13
	.word 0xdad6e000  ! 3308: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r13
	.word 0xdac62000  ! 3309: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r13
	mov	0x60, %r16
	.word 0xdebdc4a0  ! 3311: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	.word 0xd6d70e60  ! 3312: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r11
	.word 0xdcb44400  ! 3313: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0xdc86e000  ! 3314: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r14
	.word 0x87802020  ! 3315: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28584a0  ! 3316: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r9
	.word 0xd2f4e000  ! 3317: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2ac2000  ! 3318: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xdef7ce40  ! 3319: STXA_R	stxa	%r15, [%r31 + %r0] 0x72
	.word 0xdebca000  ! 3320: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xdec4e000  ! 3321: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	.word 0xd2f48400  ! 3322: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0xd29fce60  ! 3323: LDDA_R	ldda	[%r31, %r0] 0x73, %r9
	mov	0x70, %r25
	.word 0xd2f4a000  ! 3325: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0xd2c4e000  ! 3326: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xd4840400  ! 3327: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	.word 0x87802020  ! 3328: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r27
	mov	0x3d8, %r22
	mov	0x7d0, %r23
	.word 0xdebfce40  ! 3332: STDA_R	stda	%r15, [%r31 + %r0] 0x72
	mov	0x40, %r27
	.word 0xdeac6000  ! 3334: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xdea42000  ! 3335: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xdebc2000  ! 3336: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	mov	0x3d0, %r23
	mov	0x8, %r26
	mov	0x7f8, %r23
	.word 0xd69504a0  ! 3340: LDUHA_R	lduha	[%r20, %r0] 0x25, %r11
	.word 0xdca74e40  ! 3341: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	.word 0x87802020  ! 3342: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcace000  ! 3343: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0xdca5c4a0  ! 3344: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	.word 0xdcbca000  ! 3345: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdcb4a000  ! 3346: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 3347: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r25
	mov	0x7f8, %r22
	.word 0xd2a70e40  ! 3350: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	.word 0xdcdc4400  ! 3351: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	.word 0xdcac4400  ! 3352: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	.word 0xdcc52000  ! 3353: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r14
	.word 0xdcdd6000  ! 3354: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r14
	mov	0x38, %r24
	.word 0xdcbd6000  ! 3356: STDA_I	stda	%r14, [%r21 + 0x0000] %asi
	mov	0x7f8, %r21
	mov	0x50, %r26
	.word 0xd69c0400  ! 3359: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	.word 0xd4de89e0  ! 3360: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r10
	.word 0xd4dda000  ! 3361: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r10
	.word 0xd4f5e000  ! 3362: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	.word 0xd4ada000  ! 3363: STBA_I	stba	%r10, [%r22 + 0x0000] %asi
	mov	0x48, %r26
	.word 0xd6aec9e0  ! 3365: STBA_R	stba	%r11, [%r27 + %r0] 0x4f
	mov	0x50, %r18
	mov	0x48, %r19
	.word 0xd6bda000  ! 3368: STDA_I	stda	%r11, [%r22 + 0x0000] %asi
	.word 0xd4cf8e40  ! 3369: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r10
	.word 0x8780204f  ! 3370: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd49ea000  ! 3371: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	mov	0x70, %r24
	.word 0xd4f62000  ! 3373: STXA_I	stxa	%r10, [%r24 + 0x0000] %asi
	.word 0xd4a62000  ! 3374: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	mov	0x10, %r24
	.word 0xd2af4e60  ! 3376: STBA_R	stba	%r9, [%r29 + %r0] 0x73
	.word 0x87802020  ! 3377: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r26
	.word 0xdad4c400  ! 3379: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xda9c2000  ! 3380: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	.word 0xd0a74e60  ! 3381: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	.word 0x87802020  ! 3382: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09c4400  ! 3383: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	.word 0xd0bca000  ! 3384: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	mov	0x20, %r16
	.word 0xdec4c400  ! 3386: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	.word 0xded42000  ! 3387: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	mov	0x10, %r27
	.word 0xdebc2000  ! 3389: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	mov	0x3f0, %r21
	mov	0x10, %r26
	.word 0xdedc2000  ! 3392: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r15
	mov	0x3f8, %r21
	mov	0x10, %r16
	mov	0x58, %r26
	.word 0xd88649e0  ! 3396: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r12
	.word 0xd6bc4400  ! 3397: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	.word 0xd6a7ce40  ! 3398: STWA_R	stwa	%r11, [%r31 + %r0] 0x72
	.word 0xdcdf8e80  ! 3399: LDXA_R	ldxa	[%r30, %r0] 0x74, %r14
	mov	0x3c0, %r23
	mov	0x0, %r17
	mov	0x70, %r16
	.word 0xdab74e80  ! 3403: STHA_R	stha	%r13, [%r29 + %r0] 0x74
	.word 0x87802025  ! 3404: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaf52000  ! 3405: STXA_I	stxa	%r13, [%r20 + 0x0000] %asi
	.word 0x87802025  ! 3406: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdadde000  ! 3407: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r13
	mov	0x58, %r16
	.word 0xdabde000  ! 3409: STDA_I	stda	%r13, [%r23 + 0x0000] %asi
	mov	0x20, %r26
	mov	0x7e8, %r20
	.word 0xdadde000  ! 3412: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r13
	.word 0xd0b44400  ! 3413: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	mov	0x18, %r17
	.word 0xd0dde000  ! 3415: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r8
	.word 0xd8ac0400  ! 3416: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xd8bc0400  ! 3417: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xdeb70e80  ! 3418: STHA_R	stha	%r15, [%r28 + %r0] 0x74
	.word 0xd4b74e40  ! 3419: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	.word 0xd4b5e000  ! 3420: STHA_I	stha	%r10, [%r23 + 0x0000] %asi
	.word 0xd4a52000  ! 3421: STWA_I	stwa	%r10, [%r20 + 0x0000] %asi
	.word 0xd8af4e80  ! 3422: STBA_R	stba	%r12, [%r29 + %r0] 0x74
	.word 0xd8dfce40  ! 3423: LDXA_R	ldxa	[%r31, %r0] 0x72, %r12
	.word 0xd8b52000  ! 3424: STHA_I	stha	%r12, [%r20 + 0x0000] %asi
	.word 0xd2d609e0  ! 3425: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r9
	.word 0xd6c7ce40  ! 3426: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r11
	mov	0x7e8, %r22
	mov	0x68, %r17
	.word 0xd6dc8400  ! 3429: LDXA_R	ldxa	[%r18, %r0] 0x20, %r11
	mov	0x20, %r27
	.word 0x87802020  ! 3431: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c4c400  ! 3432: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0x87802020  ! 3433: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3434: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f76000  ! 3435: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xd2bf6000  ! 3436: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	mov	0x3c8, %r20
	.word 0xd6bc0400  ! 3438: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	mov	0x68, %r19
	.word 0xd4b689e0  ! 3440: STHA_R	stha	%r10, [%r26 + %r0] 0x4f
	.word 0xdebc4400  ! 3441: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0xdebfa000  ! 3442: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xdca4c400  ! 3443: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0x87802072  ! 3444: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 3445: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r25
	.word 0xdca56000  ! 3447: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	.word 0xd4978e40  ! 3448: LDUHA_R	lduha	[%r30, %r0] 0x72, %r10
	.word 0xd2a74e40  ! 3449: STWA_R	stwa	%r9, [%r29 + %r0] 0x72
	.word 0xdcd44400  ! 3450: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	.word 0xdcade000  ! 3451: STBA_I	stba	%r14, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 3452: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf76000  ! 3453: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 3454: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r16
	mov	0x0, %r17
	.word 0xdcaf2000  ! 3457: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdc9f6000  ! 3458: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0x87802073  ! 3459: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3460: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb4e000  ! 3461: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xdcd4a000  ! 3463: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	mov	0x7d0, %r22
	.word 0x87802072  ! 3465: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8c4c400  ! 3466: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r12
	.word 0xd2d74e60  ! 3467: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r9
	.word 0xd28f6000  ! 3468: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd0dcc400  ! 3469: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0xdca4c400  ! 3470: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xdabc0400  ! 3471: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xda9f6000  ! 3472: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xdaaf2000  ! 3473: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 3474: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda8fa000  ! 3475: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	mov	0x0, %r17
	mov	0x0, %r16
	mov	0x58, %r16
	.word 0xdaaf2000  ! 3479: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xd684c400  ! 3480: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	.word 0xdef609e0  ! 3481: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	.word 0xd8bf8e40  ! 3482: STDA_R	stda	%r12, [%r30 + %r0] 0x72
	mov	0x50, %r27
	.word 0xd88fa000  ! 3484: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0xd8c7a000  ! 3485: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xd0df4e80  ! 3486: LDXA_R	ldxa	[%r29, %r0] 0x74, %r8
	mov	0x0, %r25
	.word 0xd0dfa000  ! 3488: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0xd2970e80  ! 3489: LDUHA_R	lduha	[%r28, %r0] 0x74, %r9
	.word 0x87802020  ! 3490: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcafce40  ! 3491: STBA_R	stba	%r14, [%r31 + %r0] 0x72
	.word 0xd4cfce40  ! 3492: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r10
	.word 0xdcbf4e80  ! 3493: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	.word 0xdcf4e000  ! 3494: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcd4a000  ! 3495: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	.word 0xd8afce40  ! 3496: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	.word 0xd4b5c4a0  ! 3497: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	.word 0x87802020  ! 3498: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bc2000  ! 3499: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0xd4942000  ! 3500: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r10
	.word 0xd4c4a000  ! 3501: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	mov	0x3f0, %r21
	.word 0x87802020  ! 3503: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0af8e80  ! 3504: STBA_R	stba	%r8, [%r30 + %r0] 0x74
	.word 0xd2c70e60  ! 3505: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r9
	.word 0x8780204f  ! 3506: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9f4e40  ! 3507: LDDA_R	ldda	[%r29, %r0] 0x72, %r13
	mov	0x3d8, %r20
	.word 0xde9f4e40  ! 3509: LDDA_R	ldda	[%r29, %r0] 0x72, %r15
	.word 0x87802020  ! 3510: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdec42000  ! 3511: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0xd6be49e0  ! 3512: STDA_R	stda	%r11, [%r25 + %r0] 0x4f
	mov	0x8, %r27
	mov	0x40, %r16
	.word 0xd4a78e60  ! 3515: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	.word 0xd48ce000  ! 3516: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r10
	.word 0xd4a46000  ! 3517: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xd4d7ce80  ! 3518: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r10
	.word 0xd8cf8e80  ! 3519: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r12
	.word 0xd0dc4400  ! 3520: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	.word 0xdcac4400  ! 3521: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	.word 0x87802072  ! 3522: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef7ce80  ! 3523: STXA_R	stxa	%r15, [%r31 + %r0] 0x74
	.word 0x87802020  ! 3524: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r17
	.word 0xd6be89e0  ! 3526: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	.word 0xd68c6000  ! 3527: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r11
	.word 0xd09dc4a0  ! 3528: LDDA_R	ldda	[%r23, %r0] 0x25, %r8
	.word 0xd0ac2000  ! 3529: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xd0f46000  ! 3530: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xde8d44a0  ! 3531: LDUBA_R	lduba	[%r21, %r0] 0x25, %r15
	.word 0xdec46000  ! 3532: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	.word 0xd8ad44a0  ! 3533: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	.word 0xd88ce000  ! 3534: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	.word 0xded4c400  ! 3535: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r15
	mov	0x68, %r24
	mov	0x78, %r18
	.word 0xda9f4e80  ! 3538: LDDA_R	ldda	[%r29, %r0] 0x74, %r13
	mov	0x48, %r24
	.word 0xda8f0e80  ! 3540: LDUBA_R	lduba	[%r28, %r0] 0x74, %r13
	.word 0xdaf42000  ! 3541: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	mov	0x40, %r19
	.word 0xdab42000  ! 3543: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xdaaf0e80  ! 3544: STBA_R	stba	%r13, [%r28 + %r0] 0x74
	.word 0xda8ce000  ! 3545: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	.word 0xda94e000  ! 3546: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r13
	.word 0xdaf4a000  ! 3547: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	mov	0x40, %r19
	.word 0xdcb78e40  ! 3549: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xd2a40400  ! 3550: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xd2b42000  ! 3551: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0xd0a584a0  ! 3552: STWA_R	stwa	%r8, [%r22 + %r0] 0x25
	.word 0xd0bc2000  ! 3553: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	.word 0xd2dec9e0  ! 3554: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r9
	mov	0x20, %r24
	mov	0x50, %r16
	.word 0xd28ce000  ! 3557: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	.word 0xd2cca000  ! 3558: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	mov	0x3c8, %r21
	.word 0xd2dc2000  ! 3560: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r9
	.word 0xd2ac2000  ! 3561: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd49f8e80  ! 3562: LDDA_R	ldda	[%r30, %r0] 0x74, %r10
	.word 0xda8f0e40  ! 3563: LDUBA_R	lduba	[%r28, %r0] 0x72, %r13
	.word 0xda94e000  ! 3564: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3565: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda848400  ! 3566: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r13
	.word 0xdadc6000  ! 3567: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xd69504a0  ! 3568: LDUHA_R	lduha	[%r20, %r0] 0x25, %r11
	.word 0xda8609e0  ! 3569: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r13
	mov	0x68, %r25
	.word 0x87802020  ! 3571: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadc6000  ! 3572: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0x87802025  ! 3573: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f0, %r22
	.word 0xda8d6000  ! 3575: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r13
	.word 0xda95e000  ! 3576: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r13
	.word 0xd6bcc400  ! 3577: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0xd4d7ce40  ! 3578: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r10
	.word 0xd4952000  ! 3579: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r10
	.word 0xd4af0e40  ! 3580: STBA_R	stba	%r10, [%r28 + %r0] 0x72
	.word 0xd2944400  ! 3581: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	mov	0x50, %r26
	.word 0x87802020  ! 3583: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0c6c9e0  ! 3584: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r8
	.word 0xd8f4c400  ! 3585: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xd8ac6000  ! 3586: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xd0c44400  ! 3587: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r8
	.word 0x87802074  ! 3588: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r26
	.word 0xd0d76000  ! 3590: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0a7a000  ! 3591: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd28609e0  ! 3592: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r9
	mov	0x28, %r19
	.word 0xd287e000  ! 3594: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	mov	0x48, %r26
	.word 0xd4f504a0  ! 3596: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	mov	0x18, %r27
	.word 0xd6bf4e80  ! 3598: STDA_R	stda	%r11, [%r29 + %r0] 0x74
	.word 0x87802020  ! 3599: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2848400  ! 3600: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r9
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd4dc4400  ! 3602: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	.word 0xd49c2000  ! 3603: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	.word 0xdaad44a0  ! 3604: STBA_R	stba	%r13, [%r21 + %r0] 0x25
	.word 0xdaac6000  ! 3605: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	.word 0xda87ce40  ! 3606: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r13
	.word 0x87802020  ! 3607: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bf8e40  ! 3608: STDA_R	stda	%r11, [%r30 + %r0] 0x72
	.word 0x87802020  ! 3609: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3610: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd68dc4a0  ! 3611: LDUBA_R	lduba	[%r23, %r0] 0x25, %r11
	.word 0xdeb78e40  ! 3612: STHA_R	stha	%r15, [%r30 + %r0] 0x72
	mov	0x7c0, %r21
	.word 0xdec72000  ! 3614: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xdecfe000  ! 3615: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xdef4c400  ! 3616: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0x87802020  ! 3617: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0970e60  ! 3618: LDUHA_R	lduha	[%r28, %r0] 0x73, %r8
	.word 0xd0f74e80  ! 3619: STXA_R	stxa	%r8, [%r29 + %r0] 0x74
	.word 0xd8f44400  ! 3620: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	mov	0x3f0, %r23
	.word 0xd894e000  ! 3622: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r12
	mov	0x60, %r27
	.word 0xdec74e60  ! 3624: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r15
	.word 0xd2c74e40  ! 3625: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r9
	mov	0x3d0, %r22
	.word 0xd8aec9e0  ! 3627: STBA_R	stba	%r12, [%r27 + %r0] 0x4f
	.word 0xdaac4400  ! 3628: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	.word 0xda9f8e40  ! 3629: LDDA_R	ldda	[%r30, %r0] 0x72, %r13
	.word 0xd0f70e80  ! 3630: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0xd0a46000  ! 3631: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	mov	0x3d8, %r22
	.word 0xd0a46000  ! 3633: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xd4be09e0  ! 3634: STDA_R	stda	%r10, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 3635: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 3636: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4972000  ! 3637: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0xd4a7e000  ! 3638: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd2ae49e0  ! 3639: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	.word 0xd2a7a000  ! 3640: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xdcad44a0  ! 3641: STBA_R	stba	%r14, [%r21 + %r0] 0x25
	mov	0x3e8, %r20
	.word 0xdaf78e80  ! 3643: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	.word 0xda8fe000  ! 3644: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 3645: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r16
	.word 0xdab6e000  ! 3647: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	.word 0x87802074  ! 3648: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdad70e40  ! 3649: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r13
	.word 0xd4adc4a0  ! 3650: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0xd4f72000  ! 3651: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 3652: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88d84a0  ! 3653: LDUBA_R	lduba	[%r22, %r0] 0x25, %r12
	mov	0x8, %r27
	.word 0x87802074  ! 3655: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r17
	.word 0x87802020  ! 3657: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f4e000  ! 3658: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xd8dc6000  ! 3659: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	.word 0xd8b4a000  ! 3660: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0xda874e80  ! 3661: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r13
	.word 0xd8cec9e0  ! 3662: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r12
	.word 0xd8ace000  ! 3663: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 3664: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8be09e0  ! 3665: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	.word 0xd8a4a000  ! 3666: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0xd8f4a000  ! 3668: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 3669: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2c4c400  ! 3670: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0xd2a72000  ! 3671: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0xd097ce40  ! 3672: LDUHA_R	lduha	[%r31, %r0] 0x72, %r8
	.word 0xd0b72000  ! 3673: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd0dfe000  ! 3674: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0x87802072  ! 3675: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r26
	.word 0xdab70e60  ! 3677: STHA_R	stha	%r13, [%r28 + %r0] 0x73
	.word 0x8780204f  ! 3678: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdadee000  ! 3679: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r13
	.word 0xd8f74e80  ! 3680: STXA_R	stxa	%r12, [%r29 + %r0] 0x74
	mov	0x7e0, %r21
	.word 0xdead84a0  ! 3682: STBA_R	stba	%r15, [%r22 + %r0] 0x25
	.word 0xdede6000  ! 3683: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r15
	.word 0xd09fce40  ! 3684: LDDA_R	ldda	[%r31, %r0] 0x72, %r8
	.word 0xd0f62000  ! 3685: STXA_I	stxa	%r8, [%r24 + 0x0000] %asi
	.word 0x87802073  ! 3686: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b40400  ! 3687: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0xd2d7a000  ! 3688: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	mov	0x3f0, %r21
	mov	0x7f8, %r21
	.word 0xd2afe000  ! 3691: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd28fa000  ! 3692: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	.word 0x87802074  ! 3693: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bfe000  ! 3694: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xd8940400  ! 3696: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	mov	0x58, %r27
	.word 0xd8c7e000  ! 3698: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0xd09c8400  ! 3699: LDDA_R	ldda	[%r18, %r0] 0x20, %r8
	.word 0xd0b76000  ! 3700: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd0c72000  ! 3701: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xd69c0400  ! 3702: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	.word 0xd49c0400  ! 3703: LDDA_R	ldda	[%r16, %r0] 0x20, %r10
	mov	0x60, %r26
	.word 0xd0cf0e60  ! 3705: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r8
	mov	0x0, %r25
	.word 0xdcbf0e60  ! 3707: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	.word 0xdcd76000  ! 3708: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	.word 0x87802025  ! 3709: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde940400  ! 3710: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0xd4b48400  ! 3711: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd4b56000  ! 3712: STHA_I	stha	%r10, [%r21 + 0x0000] %asi
	.word 0x87802072  ! 3713: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb74e60  ! 3714: STHA_R	stha	%r14, [%r29 + %r0] 0x73
	mov	0x3c8, %r23
	.word 0x87802025  ! 3716: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdadd04a0  ! 3717: LDXA_R	ldxa	[%r20, %r0] 0x25, %r13
	.word 0xda9de000  ! 3718: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r13
	.word 0x87802072  ! 3719: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda9f6000  ! 3720: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xd8a689e0  ! 3721: STWA_R	stwa	%r12, [%r26 + %r0] 0x4f
	.word 0xd09584a0  ! 3722: LDUHA_R	lduha	[%r22, %r0] 0x25, %r8
	.word 0xd4d78e80  ! 3723: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r10
	.word 0xd4a7e000  ! 3724: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 3725: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd48fa000  ! 3726: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xd0ae09e0  ! 3727: STBA_R	stba	%r8, [%r24 + %r0] 0x4f
	.word 0x87802074  ! 3728: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeaf4e60  ! 3729: STBA_R	stba	%r15, [%r29 + %r0] 0x73
	.word 0xdedf2000  ! 3730: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	mov	0x40, %r25
	.word 0x87802020  ! 3732: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3733: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3734: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2974e80  ! 3735: LDUHA_R	lduha	[%r29, %r0] 0x74, %r9
	mov	0x40, %r17
	.word 0x87802073  ! 3737: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r17
	.word 0xd2b76000  ! 3739: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd29fa000  ! 3740: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd8b70e80  ! 3741: STHA_R	stha	%r12, [%r28 + %r0] 0x74
	.word 0xd8a7e000  ! 3742: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xd2b6c9e0  ! 3744: STHA_R	stha	%r9, [%r27 + %r0] 0x4f
	.word 0xd4b40400  ! 3745: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0xd4f72000  ! 3746: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd2af8e80  ! 3747: STBA_R	stba	%r9, [%r30 + %r0] 0x74
	.word 0x87802073  ! 3748: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd49f4e40  ! 3749: LDDA_R	ldda	[%r29, %r0] 0x72, %r10
	.word 0xd4d76000  ! 3750: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	mov	0x7d0, %r22
	.word 0xdea48400  ! 3752: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xd0cc4400  ! 3753: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	.word 0xd0af6000  ! 3754: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd8f74e80  ! 3755: STXA_R	stxa	%r12, [%r29 + %r0] 0x74
	.word 0xd6d7ce80  ! 3756: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r11
	.word 0xd69c8400  ! 3757: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	.word 0xd6afe000  ! 3758: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xd0dc0400  ! 3760: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0x87802072  ! 3761: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r17
	.word 0xdca74e60  ! 3763: STWA_R	stwa	%r14, [%r29 + %r0] 0x73
	.word 0xdc8f4e60  ! 3764: LDUBA_R	lduba	[%r29, %r0] 0x73, %r14
	.word 0x87802020  ! 3765: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbca000  ! 3766: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	mov	0x8, %r24
	.word 0xdc9c6000  ! 3768: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r14
	.word 0x87802072  ! 3769: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab78e60  ! 3770: STHA_R	stha	%r13, [%r30 + %r0] 0x73
	mov	0x60, %r24
	.word 0xdad76000  ! 3772: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0x87802074  ! 3773: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf7a000  ! 3774: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	mov	0x30, %r27
	mov	0x28, %r27
	.word 0xd6cc0400  ! 3777: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r11
	.word 0xd6a7e000  ! 3778: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	mov	0x18, %r19
	.word 0xd6b76000  ! 3780: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	mov	0x68, %r24
	.word 0xdea74e80  ! 3782: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	.word 0xde8fa000  ! 3783: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0xd2a5c4a0  ! 3784: STWA_R	stwa	%r9, [%r23 + %r0] 0x25
	.word 0xdea40400  ! 3785: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xdebf6000  ! 3786: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	mov	0x30, %r24
	.word 0xdecfa000  ! 3788: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xd4f7ce60  ! 3789: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	.word 0xdabc0400  ! 3790: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xdac72000  ! 3791: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0xd2b40400  ! 3792: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	mov	0x20, %r26
	.word 0xd2b76000  ! 3794: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2af6000  ! 3795: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xdc8f0e60  ! 3796: LDUBA_R	lduba	[%r28, %r0] 0x73, %r14
	.word 0xd8b649e0  ! 3797: STHA_R	stha	%r12, [%r25 + %r0] 0x4f
	.word 0xd8d7a000  ! 3798: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	mov	0x18, %r25
	.word 0xd8df2000  ! 3800: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	mov	0x40, %r18
	.word 0xd897a000  ! 3802: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0xd8bfa000  ! 3803: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xdaf70e60  ! 3804: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	.word 0x87802074  ! 3805: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b40400  ! 3806: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xd6d7a000  ! 3807: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	.word 0xdeac8400  ! 3808: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	mov	0x58, %r19
	.word 0xda9c4400  ! 3810: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	mov	0x3f8, %r21
	.word 0xdaa72000  ! 3812: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xd69c8400  ! 3813: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	.word 0xd6c76000  ! 3814: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6972000  ! 3815: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	.word 0xd6bfe000  ! 3816: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd6b76000  ! 3817: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd6b72000  ! 3818: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd6872000  ! 3819: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6876000  ! 3820: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6bfe000  ! 3821: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd6b4c400  ! 3822: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xd6bd04a0  ! 3823: STDA_R	stda	%r11, [%r20 + %r0] 0x25
	.word 0xd6bfa000  ! 3824: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	mov	0x10, %r26
	.word 0xd6972000  ! 3826: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	.word 0xd6b4c400  ! 3827: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xd8f4c400  ! 3828: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xd89fa000  ! 3829: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	.word 0xd89fa000  ! 3830: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	mov	0x0, %r24
	mov	0x7c0, %r23
	mov	0x3d0, %r22
	.word 0xd8d74e80  ! 3834: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r12
	mov	0x0, %r17
	.word 0xd8cfa000  ! 3836: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd89f6000  ! 3837: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	.word 0xde840400  ! 3838: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	.word 0xde9fe000  ! 3839: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0xdeb76000  ! 3840: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xd4cf0e60  ! 3841: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r10
	mov	0x60, %r17
	mov	0x8, %r18
	.word 0xd4be49e0  ! 3844: STDA_R	stda	%r10, [%r25 + %r0] 0x4f
	.word 0xde974e60  ! 3845: LDUHA_R	lduha	[%r29, %r0] 0x73, %r15
	.word 0xdead44a0  ! 3846: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	.word 0xd4c7ce60  ! 3847: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r10
	.word 0xdaf649e0  ! 3848: STXA_R	stxa	%r13, [%r25 + %r0] 0x4f
	.word 0xdaaf6000  ! 3849: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xdaf76000  ! 3850: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdab7e000  ! 3851: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xda8f2000  ! 3852: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xd8ac8400  ! 3853: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0xd8b7a000  ! 3854: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xd8dd44a0  ! 3855: LDXA_R	ldxa	[%r21, %r0] 0x25, %r12
	.word 0xd8b72000  ! 3856: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd8bf4e40  ! 3857: STDA_R	stda	%r12, [%r29 + %r0] 0x72
	.word 0x87802020  ! 3858: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ac6000  ! 3859: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xd884a000  ! 3860: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r12
	mov	0x50, %r16
	.word 0x87802020  ! 3862: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9c0400  ! 3863: LDDA_R	ldda	[%r16, %r0] 0x20, %r13
	.word 0xdaa46000  ! 3864: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3865: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9ca000  ! 3866: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	.word 0xd4d48400  ! 3867: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	.word 0x87802020  ! 3868: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r20
	.word 0x87802020  ! 3870: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ace000  ! 3871: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0xd49ca000  ! 3872: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd2978e80  ! 3873: LDUHA_R	lduha	[%r30, %r0] 0x74, %r9
	.word 0x87802020  ! 3874: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca48400  ! 3875: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xdcbca000  ! 3876: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdcaca000  ! 3877: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xdcb42000  ! 3878: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 3879: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0bd84a0  ! 3880: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0xdaf70e80  ! 3881: STXA_R	stxa	%r13, [%r28 + %r0] 0x74
	.word 0xd28e09e0  ! 3882: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r9
	.word 0xd6b609e0  ! 3883: STHA_R	stha	%r11, [%r24 + %r0] 0x4f
	.word 0xd69f2000  ! 3884: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	mov	0x38, %r19
	.word 0xd087ce80  ! 3886: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r8
	.word 0xdeb70e80  ! 3887: STHA_R	stha	%r15, [%r28 + %r0] 0x74
	.word 0x87802072  ! 3888: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8bd84a0  ! 3889: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	.word 0xd887e000  ! 3890: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0xdcf689e0  ! 3891: STXA_R	stxa	%r14, [%r26 + %r0] 0x4f
	.word 0xd29d84a0  ! 3892: LDDA_R	ldda	[%r22, %r0] 0x25, %r9
	mov	0x3c8, %r23
	mov	0x18, %r16
	.word 0xd89f0e40  ! 3895: LDDA_R	ldda	[%r28, %r0] 0x72, %r12
	.word 0xd8dfa000  ! 3896: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8bf0e80  ! 3897: STDA_R	stda	%r12, [%r28 + %r0] 0x74
	.word 0xdcce49e0  ! 3898: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r14
	.word 0xdca76000  ! 3899: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcbf2000  ! 3900: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdcf76000  ! 3901: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcf7a000  ! 3902: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xd0ccc400  ! 3903: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	.word 0xd49fce40  ! 3904: LDDA_R	ldda	[%r31, %r0] 0x72, %r10
	.word 0xd497a000  ! 3905: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0xd08f0e40  ! 3906: LDUBA_R	lduba	[%r28, %r0] 0x72, %r8
	mov	0x70, %r18
	.word 0x87802074  ! 3908: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r17
	.word 0x87802074  ! 3910: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3911: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabe49e0  ! 3912: STDA_R	stda	%r13, [%r25 + %r0] 0x4f
	.word 0x87802025  ! 3913: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8da000  ! 3914: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r13
	.word 0xdaa5a000  ! 3915: STWA_I	stwa	%r13, [%r22 + 0x0000] %asi
	.word 0xdaad6000  ! 3916: STBA_I	stba	%r13, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 3917: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0944400  ! 3918: LDUHA_R	lduha	[%r17, %r0] 0x20, %r8
	.word 0x87802074  ! 3919: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r25
	.word 0xde8f4e60  ! 3921: LDUBA_R	lduba	[%r29, %r0] 0x73, %r15
	.word 0xd8ac4400  ! 3922: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xd8976000  ! 3923: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0xd0a4c400  ! 3924: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	mov	0x30, %r18
	.word 0xd4df0e40  ! 3926: LDXA_R	ldxa	[%r28, %r0] 0x72, %r10
	.word 0xd2f4c400  ! 3927: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xd0aec9e0  ! 3928: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	.word 0xdeae09e0  ! 3929: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	.word 0xdef72000  ! 3930: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xde876000  ! 3931: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xd28d04a0  ! 3932: LDUBA_R	lduba	[%r20, %r0] 0x25, %r9
	mov	0x18, %r17
	.word 0xdc8cc400  ! 3934: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	.word 0xdcb7a000  ! 3935: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	mov	0x78, %r19
	mov	0x60, %r25
	.word 0xd0cc0400  ! 3938: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xdea40400  ! 3939: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xd8b7ce40  ! 3940: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	mov	0x20, %r24
	.word 0xde8f0e80  ! 3942: LDUBA_R	lduba	[%r28, %r0] 0x74, %r15
	.word 0xde9f2000  ! 3943: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0x87802072  ! 3944: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3945: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r19
	mov	0x40, %r27
	.word 0xd68f4e60  ! 3948: LDUBA_R	lduba	[%r29, %r0] 0x73, %r11
	.word 0xd6bc6000  ! 3949: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 3950: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8b78e60  ! 3951: STHA_R	stha	%r12, [%r30 + %r0] 0x73
	.word 0x87802074  ! 3952: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd29544a0  ! 3953: LDUHA_R	lduha	[%r21, %r0] 0x25, %r9
	mov	0x7f8, %r21
	mov	0x68, %r17
	.word 0xd2dfa000  ! 3956: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0x87802072  ! 3957: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2872000  ! 3958: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2976000  ! 3959: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	mov	0x38, %r16
	.word 0xdadec9e0  ! 3961: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r13
	.word 0xdaa7a000  ! 3962: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xdacf2000  ! 3963: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	.word 0xd8dcc400  ! 3964: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	.word 0xd0bc4400  ! 3965: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0x87802074  ! 3966: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r18
	.word 0xd0876000  ! 3968: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	mov	0x38, %r24
	.word 0xd0afe000  ! 3970: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd8f74e40  ! 3971: STXA_R	stxa	%r12, [%r29 + %r0] 0x72
	mov	0x78, %r16
	.word 0xd8f7e000  ! 3973: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd6840400  ! 3974: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0xd68f6000  ! 3975: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6afe000  ! 3976: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd687a000  ! 3977: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6bf2000  ! 3978: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd6a7a000  ! 3979: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xdc97ce40  ! 3980: LDUHA_R	lduha	[%r31, %r0] 0x72, %r14
	mov	0x3c8, %r22
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802073  ! 3983: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdea78e40  ! 3984: STWA_R	stwa	%r15, [%r30 + %r0] 0x72
	mov	0x3f8, %r23
	.word 0xded76000  ! 3986: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3987: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded42000  ! 3988: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	.word 0xdeac6000  ! 3989: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xdec46000  ! 3991: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3992: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcc5c4a0  ! 3993: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r14
	.word 0xdcb42000  ! 3994: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xd2f609e0  ! 3995: STXA_R	stxa	%r9, [%r24 + %r0] 0x4f
	mov	0x58, %r27
	.word 0xdcf78e40  ! 3997: STXA_R	stxa	%r14, [%r30 + %r0] 0x72
	.word 0xd287ce80  ! 3998: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r9
	.word 0xd284a000  ! 3999: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	mov	0x7c0, %r20
	mov	0x78, %r18
	.word 0xd2ac2000  ! 4002: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd2dc6000  ! 4003: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r9
	.word 0xd2ac2000  ! 4004: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	mov	0x48, %r19
	.word 0xdeb7ce60  ! 4006: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	.word 0xd8ac4400  ! 4007: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xd884e000  ! 4008: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r12
	mov	0x38, %r16
	.word 0xd8a4e000  ! 4010: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xd8ac6000  ! 4011: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	mov	0x7c0, %r23
	mov	0x40, %r17
	.word 0xd68fce80  ! 4014: LDUBA_R	lduba	[%r31, %r0] 0x74, %r11
	.word 0xd6f4a000  ! 4015: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	.word 0xdec609e0  ! 4016: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r15
	mov	0x78, %r18
	mov	0x18, %r24
	.word 0xdaaf4e60  ! 4019: STBA_R	stba	%r13, [%r29 + %r0] 0x73
	.word 0xdaace000  ! 4020: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	mov	0x10, %r26
	mov	0x38, %r27
	.word 0xd88d84a0  ! 4023: LDUBA_R	lduba	[%r22, %r0] 0x25, %r12
	mov	0x60, %r18
	.word 0xd0a609e0  ! 4025: STWA_R	stwa	%r8, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 4026: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc9584a0  ! 4027: LDUHA_R	lduha	[%r22, %r0] 0x25, %r14
	.word 0xd69c0400  ! 4028: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	.word 0xd8dc0400  ! 4029: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0xd8866000  ! 4030: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r12
	.word 0xd6dd44a0  ! 4031: LDXA_R	ldxa	[%r21, %r0] 0x25, %r11
	.word 0xd68f4e40  ! 4032: LDUBA_R	lduba	[%r29, %r0] 0x72, %r11
	.word 0xd69ea000  ! 4033: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r11
	.word 0xd6f6e000  ! 4034: STXA_I	stxa	%r11, [%r27 + 0x0000] %asi
	.word 0xd6be2000  ! 4035: STDA_I	stda	%r11, [%r24 + 0x0000] %asi
	.word 0xd0c504a0  ! 4036: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r8
	.word 0xd0b66000  ! 4037: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	mov	0x3c8, %r20
	.word 0xd0c66000  ! 4039: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r8
	.word 0xd0c6a000  ! 4040: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r8
	.word 0x87802074  ! 4041: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0af6000  ! 4042: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	mov	0x28, %r19
	.word 0xd0cf2000  ! 4044: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0xd4dfce40  ! 4045: LDXA_R	ldxa	[%r31, %r0] 0x72, %r10
	.word 0xd2bf8e40  ! 4046: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	mov	0x70, %r18
	.word 0xd2afe000  ! 4048: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 4049: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f8, %r21
	.word 0xd2f6a000  ! 4051: STXA_I	stxa	%r9, [%r26 + 0x0000] %asi
	mov	0x3f0, %r21
	.word 0xd4bf8e80  ! 4053: STDA_R	stda	%r10, [%r30 + %r0] 0x74
	.word 0xd4b6a000  ! 4054: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	mov	0x38, %r18
	.word 0xd4a6a000  ! 4056: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	mov	0x3f8, %r23
	.word 0xd49ee000  ! 4058: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r10
	.word 0xdacf4e40  ! 4059: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r13
	.word 0xd0f40400  ! 4060: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xd8cf4e40  ! 4061: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r12
	.word 0xd8ae2000  ! 4062: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	.word 0xd6bf8e60  ! 4063: STDA_R	stda	%r11, [%r30 + %r0] 0x73
	.word 0xdc8c4400  ! 4064: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0xdcae2000  ! 4065: STBA_I	stba	%r14, [%r24 + 0x0000] %asi
	.word 0xdc8ea000  ! 4066: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r14
	.word 0xdcd62000  ! 4067: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r14
	.word 0xdcbc4400  ! 4068: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	mov	0x0, %r18
	.word 0x87802073  ! 4070: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r25
	.word 0xd08e49e0  ! 4072: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r8
	.word 0x8780204f  ! 4073: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f6e000  ! 4074: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	.word 0xd08e2000  ! 4075: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r8
	.word 0xd0966000  ! 4076: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r8
	.word 0xd096a000  ! 4077: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r8
	.word 0xd4c78e60  ! 4078: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r10
	mov	0x20, %r18
	.word 0xd486e000  ! 4080: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	mov	0x3d8, %r20
	mov	0x58, %r16
	.word 0xd8b689e0  ! 4083: STHA_R	stha	%r12, [%r26 + %r0] 0x4f
	.word 0xd8d6e000  ! 4084: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r12
	mov	0x0, %r25
	.word 0xd88e6000  ! 4086: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r12
	.word 0xd8be2000  ! 4087: STDA_I	stda	%r12, [%r24 + 0x0000] %asi
	.word 0x87802072  ! 4088: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8cf6000  ! 4089: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0x87802025  ! 4090: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd89de000  ! 4091: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r12
	.word 0xdeb70e40  ! 4092: STHA_R	stha	%r15, [%r28 + %r0] 0x72
	.word 0xdecf8e60  ! 4093: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r15
	.word 0xd8c689e0  ! 4094: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r12
	mov	0x30, %r26
	.word 0xd8bd2000  ! 4096: STDA_I	stda	%r12, [%r20 + 0x0000] %asi
	mov	0x18, %r17
	mov	0x10, %r16
	.word 0xd8ad2000  ! 4099: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	mov	0x0, %r18
	.word 0x87802074  ! 4101: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8b76000  ! 4102: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd0a544a0  ! 4103: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	.word 0xd0c7e000  ! 4104: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	mov	0x8, %r24
	mov	0x78, %r27
	.word 0x87802072  ! 4107: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd08f6000  ! 4108: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r8
	.word 0xdeb609e0  ! 4109: STHA_R	stha	%r15, [%r24 + %r0] 0x4f
	mov	0x7c0, %r20
	.word 0xd09649e0  ! 4111: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r8
	mov	0x48, %r24
	.word 0xdaadc4a0  ! 4113: STBA_R	stba	%r13, [%r23 + %r0] 0x25
	.word 0xd4bfce40  ! 4114: STDA_R	stda	%r10, [%r31 + %r0] 0x72
	.word 0xdcd7ce40  ! 4115: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r14
	.word 0xd6f78e60  ! 4116: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	.word 0xd6cf0e80  ! 4117: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r11
	.word 0xded48400  ! 4118: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	.word 0xde97a000  ! 4119: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	mov	0x8, %r24
	.word 0xdebf0e80  ! 4121: STDA_R	stda	%r15, [%r28 + %r0] 0x74
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802073  ! 4123: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 4124: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bd44a0  ! 4125: STDA_R	stda	%r9, [%r21 + %r0] 0x25
	.word 0x87802074  ! 4126: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf4c400  ! 4127: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 4128: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 4129: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc8f6000  ! 4130: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4131: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac70e40  ! 4132: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r13
	.word 0xd8af0e40  ! 4133: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	mov	0x50, %r25
	mov	0x70, %r27
	.word 0xd0a649e0  ! 4136: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	mov	0x60, %r26
	.word 0xdeae89e0  ! 4138: STBA_R	stba	%r15, [%r26 + %r0] 0x4f
	.word 0xdedce000  ! 4139: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r15
	.word 0xd0b74e60  ! 4140: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	mov	0x20, %r16
	.word 0xd0bce000  ! 4142: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0xd0d4e000  ! 4143: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	mov	0x7c0, %r21
	.word 0xd0a4e000  ! 4145: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd2c78e40  ! 4146: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r9
	.word 0x87802073  ! 4147: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf44400  ! 4148: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0xd8cfce80  ! 4149: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r12
	mov	0x10, %r25
	mov	0x3f0, %r20
	.word 0xd8d72000  ! 4152: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0x87802025  ! 4153: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8c5a000  ! 4154: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r12
	mov	0x28, %r27
	mov	0x8, %r24
	mov	0x68, %r27
	.word 0xdcc584a0  ! 4158: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r14
	.word 0xdc95a000  ! 4159: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r14
	.word 0xd88f8e80  ! 4160: LDUBA_R	lduba	[%r30, %r0] 0x74, %r12
	.word 0xdc9609e0  ! 4161: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r14
	.word 0xdcdc8400  ! 4162: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	.word 0xda94c400  ! 4163: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	.word 0xdaa5a000  ! 4164: STWA_I	stwa	%r13, [%r22 + 0x0000] %asi
	.word 0xdad56000  ! 4165: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r13
	.word 0xdacda000  ! 4166: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r13
	.word 0xda9d6000  ! 4167: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r13
	.word 0x87802025  ! 4168: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f8, %r22
	.word 0xdadd84a0  ! 4170: LDXA_R	ldxa	[%r22, %r0] 0x25, %r13
	.word 0x87802074  ! 4171: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2d70e60  ! 4172: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r9
	.word 0xd4ac4400  ! 4173: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xd4b72000  ! 4174: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd4a7a000  ! 4175: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd487e000  ! 4176: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802020  ! 4177: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r16
	.word 0xd4a42000  ! 4179: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0xdedf8e60  ! 4180: LDXA_R	ldxa	[%r30, %r0] 0x73, %r15
	.word 0x8780204f  ! 4181: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebe6000  ! 4182: STDA_I	stda	%r15, [%r25 + 0x0000] %asi
	.word 0x87802025  ! 4183: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde8da000  ! 4184: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r15
	.word 0xdead2000  ! 4185: STBA_I	stba	%r15, [%r20 + 0x0000] %asi
	mov	0x78, %r17
	.word 0xde9de000  ! 4187: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r15
	.word 0xdaf78e40  ! 4188: STXA_R	stxa	%r13, [%r30 + %r0] 0x72
	.word 0x87802025  ! 4189: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaa52000  ! 4190: STWA_I	stwa	%r13, [%r20 + 0x0000] %asi
	.word 0xde940400  ! 4191: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	mov	0x3c0, %r22
	.word 0xded5a000  ! 4193: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r15
	.word 0xdeb56000  ! 4194: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	.word 0x87802025  ! 4195: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda974e40  ! 4196: LDUHA_R	lduha	[%r29, %r0] 0x72, %r13
	.word 0xd4f74e60  ! 4197: STXA_R	stxa	%r10, [%r29 + %r0] 0x73
	.word 0xdac74e40  ! 4198: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r13
	.word 0x87802073  ! 4199: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdab7e000  ! 4200: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xd09f8e60  ! 4201: LDDA_R	ldda	[%r30, %r0] 0x73, %r8
	.word 0xd8cf4e80  ! 4202: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r12
	mov	0x10, %r16
	.word 0xd0848400  ! 4204: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r8
	.word 0x8780204f  ! 4205: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0bee000  ! 4206: STDA_I	stda	%r8, [%r27 + 0x0000] %asi
	mov	0x18, %r25
	.word 0xd486c9e0  ! 4208: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r10
	.word 0x87802074  ! 4209: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x20, %r24
	.word 0xd4dfa000  ! 4212: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	mov	0x18, %r18
	.word 0xd4f7a000  ! 4214: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4bf4e60  ! 4215: STDA_R	stda	%r10, [%r29 + %r0] 0x73
	.word 0xdaf78e40  ! 4216: STXA_R	stxa	%r13, [%r30 + %r0] 0x72
	mov	0x7d0, %r23
	.word 0x87802025  ! 4218: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad70e80  ! 4219: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r13
	.word 0x87802073  ! 4220: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xda97a000  ! 4222: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	mov	0x28, %r26
	.word 0xdab44400  ! 4224: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	mov	0x3c8, %r22
	.word 0x87802072  ! 4226: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f0, %r21
	.word 0xd0c5c4a0  ! 4228: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r8
	.word 0xd0972000  ! 4229: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	mov	0x8, %r17
	.word 0xd0af4e40  ! 4231: STBA_R	stba	%r8, [%r29 + %r0] 0x72
	mov	0x58, %r19
	mov	0x70, %r18
	.word 0xd087a000  ! 4234: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0d7a000  ! 4235: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0xd087e000  ! 4236: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	mov	0x3f8, %r20
	mov	0x40, %r16
	.word 0xd0d76000  ! 4239: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0f7e000  ! 4240: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xdacfce40  ! 4241: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r13
	.word 0x87802025  ! 4242: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b70e80  ! 4243: STHA_R	stha	%r9, [%r28 + %r0] 0x74
	.word 0xd2ad6000  ! 4244: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0x87802025  ! 4245: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b7ce80  ! 4246: STHA_R	stha	%r9, [%r31 + %r0] 0x74
	.word 0xd6b44400  ! 4247: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xdaa40400  ! 4248: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	mov	0x10, %r25
	.word 0xda95e000  ! 4250: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r13
	.word 0x87802073  ! 4251: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdadfe000  ! 4252: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	mov	0x7c0, %r23
	.word 0xd2d7ce80  ! 4254: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r9
	.word 0x87802020  ! 4255: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c46000  ! 4256: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0xd29ce000  ! 4257: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xdaf504a0  ! 4258: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	.word 0xdc974e80  ! 4259: LDUHA_R	lduha	[%r29, %r0] 0x74, %r14
	.word 0xd2bf0e60  ! 4260: STDA_R	stda	%r9, [%r28 + %r0] 0x73
	.word 0xd2dce000  ! 4261: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r9
	.word 0xdcd4c400  ! 4262: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	.word 0xd69689e0  ! 4263: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r11
	.word 0xdaf74e40  ! 4264: STXA_R	stxa	%r13, [%r29 + %r0] 0x72
	.word 0xdea74e40  ! 4265: STWA_R	stwa	%r15, [%r29 + %r0] 0x72
	mov	0x40, %r18
	mov	0x7e0, %r20
	.word 0xdeace000  ! 4268: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xdebca000  ! 4269: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	mov	0x7d8, %r21
	mov	0x58, %r19
	mov	0x3d8, %r23
	.word 0x87802020  ! 4273: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabfce60  ! 4274: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	mov	0x3c8, %r22
	.word 0xd0afce60  ! 4276: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	.word 0xd48544a0  ! 4277: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r10
	.word 0xd4cc6000  ! 4278: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	.word 0xd4946000  ! 4279: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r10
	mov	0x78, %r19
	.word 0xd4f4a000  ! 4281: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0xd2d584a0  ! 4282: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r9
	.word 0xd294e000  ! 4283: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	mov	0x28, %r24
	.word 0xd897ce80  ! 4285: LDUHA_R	lduha	[%r31, %r0] 0x74, %r12
	.word 0xd8f4a000  ! 4286: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xd2acc400  ! 4287: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0xd2a42000  ! 4288: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	mov	0x38, %r25
	.word 0xd2f46000  ! 4290: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xdaa584a0  ! 4291: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	.word 0x87802020  ! 4292: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabc6000  ! 4293: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 4294: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda946000  ! 4295: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	.word 0xdab42000  ! 4296: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	mov	0x48, %r16
	mov	0x7c8, %r21
	.word 0x8780204f  ! 4299: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdccc0400  ! 4300: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r14
	mov	0x58, %r24
	mov	0x3f0, %r23
	.word 0xdcdee000  ! 4303: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r14
	.word 0x87802025  ! 4304: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0cf0e80  ! 4305: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r8
	.word 0xd0852000  ! 4306: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r8
	mov	0x3e0, %r20
	mov	0x30, %r16
	.word 0xd0856000  ! 4309: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r8
	.word 0xd0a56000  ! 4310: STWA_I	stwa	%r8, [%r21 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xd0b5a000  ! 4312: STHA_I	stha	%r8, [%r22 + 0x0000] %asi
	.word 0xd2ac4400  ! 4313: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xdea70e60  ! 4314: STWA_R	stwa	%r15, [%r28 + %r0] 0x73
	.word 0x87802074  ! 4315: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 4316: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8f0e40  ! 4317: LDUBA_R	lduba	[%r28, %r0] 0x72, %r13
	.word 0xdac5e000  ! 4318: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r13
	.word 0xda952000  ! 4319: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r13
	mov	0x68, %r17
	.word 0xdab56000  ! 4321: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	.word 0xdad52000  ! 4322: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4323: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2870e60  ! 4324: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r9
	.word 0x87802020  ! 4325: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f48400  ! 4326: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xd0b4e000  ! 4327: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	mov	0x78, %r24
	.word 0xd6ccc400  ! 4329: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	.word 0xd6d46000  ! 4330: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r11
	.word 0xd6b4e000  ! 4331: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xd6bc6000  ! 4332: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0xd68c2000  ! 4333: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r11
	.word 0xd6b4e000  ! 4334: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 4335: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6a76000  ! 4336: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xdeaf0e40  ! 4337: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	mov	0x78, %r26
	mov	0x10, %r16
	.word 0xdeaf2000  ! 4340: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xdeb40400  ! 4341: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	mov	0x30, %r18
	mov	0x78, %r16
	.word 0xde972000  ! 4344: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0xdeb7e000  ! 4345: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xd4bf0e80  ! 4346: STDA_R	stda	%r10, [%r28 + %r0] 0x74
	.word 0xd4b72000  ! 4347: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd4bfe000  ! 4348: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x30, %r27
	.word 0x8780204f  ! 4350: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b66000  ! 4351: STHA_I	stha	%r10, [%r25 + 0x0000] %asi
	.word 0x8780204f  ! 4352: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r17
	.word 0xd2a74e80  ! 4354: STWA_R	stwa	%r9, [%r29 + %r0] 0x74
	mov	0x3c8, %r21
	.word 0x87802072  ! 4356: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd68f8e40  ! 4357: LDUBA_R	lduba	[%r30, %r0] 0x72, %r11
	.word 0xd6f7a000  ! 4358: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 4359: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6a76000  ! 4360: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd0a4c400  ! 4361: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xd0972000  ! 4362: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0x87802074  ! 4363: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f40400  ! 4364: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0x87802025  ! 4365: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8ad2000  ! 4366: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	.word 0xd8952000  ! 4367: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r12
	.word 0xd88de000  ! 4368: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r12
	.word 0xd885e000  ! 4369: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r12
	.word 0xd8cda000  ! 4370: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4371: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 4372: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd88fe000  ! 4373: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8f76000  ! 4374: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	mov	0x50, %r26
	.word 0xdec40400  ! 4376: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xd6b4c400  ! 4377: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	mov	0x3c8, %r21
	.word 0xd6de89e0  ! 4379: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r11
	.word 0xdeadc4a0  ! 4380: STBA_R	stba	%r15, [%r23 + %r0] 0x25
	.word 0xdeb44400  ! 4381: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0x87802073  ! 4382: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd89584a0  ! 4383: LDUHA_R	lduha	[%r22, %r0] 0x25, %r12
	.word 0xd8876000  ! 4384: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0x87802025  ! 4385: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4a6c9e0  ! 4386: STWA_R	stwa	%r10, [%r27 + %r0] 0x4f
	.word 0xd48d6000  ! 4387: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r10
	.word 0xd4c52000  ! 4388: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r10
	mov	0x78, %r16
	.word 0xdedf8e60  ! 4390: LDXA_R	ldxa	[%r30, %r0] 0x73, %r15
	mov	0x38, %r25
	.word 0xde9d2000  ! 4392: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r15
	.word 0xde874e60  ! 4393: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r15
	.word 0xd4a7ce80  ! 4394: STWA_R	stwa	%r10, [%r31 + %r0] 0x74
	.word 0xd0cc8400  ! 4395: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0x87802072  ! 4396: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r18
	.word 0xd0c7ce60  ! 4398: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r8
	.word 0xd0df6000  ! 4399: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	mov	0x48, %r16
	.word 0x87802025  ! 4401: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f40400  ! 4402: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	.word 0xd8cdc4a0  ! 4403: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r12
	mov	0x28, %r18
	.word 0xd8c52000  ! 4405: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r12
	mov	0x3d0, %r20
	.word 0xdc9e89e0  ! 4407: LDDA_R	ldda	[%r26, %r0] 0x4f, %r14
	.word 0xdcdd6000  ! 4408: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r14
	mov	0x3f0, %r21
	.word 0xdadf4e40  ! 4410: LDXA_R	ldxa	[%r29, %r0] 0x72, %r13
	.word 0xd49dc4a0  ! 4411: LDDA_R	ldda	[%r23, %r0] 0x25, %r10
	mov	0x78, %r16
	.word 0xd4f52000  ! 4413: STXA_I	stxa	%r10, [%r20 + 0x0000] %asi
	.word 0xd8a4c400  ! 4414: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	mov	0x48, %r26
	mov	0x0, %r27
	mov	0x78, %r27
	.word 0xd2d6c9e0  ! 4418: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r9
	mov	0x28, %r18
	.word 0xd2ac0400  ! 4420: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0xd28da000  ! 4421: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r9
	mov	0x3c0, %r20
	.word 0xd2bd6000  ! 4423: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	.word 0xd2bd6000  ! 4424: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	.word 0xd2f5e000  ! 4425: STXA_I	stxa	%r9, [%r23 + 0x0000] %asi
	.word 0xd2f56000  ! 4426: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	mov	0x30, %r17
	mov	0x58, %r16
	.word 0xd29d6000  ! 4429: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r9
	.word 0xd2bd6000  ! 4430: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	.word 0xd2f5e000  ! 4431: STXA_I	stxa	%r9, [%r23 + 0x0000] %asi
	mov	0x8, %r27
	.word 0xde8584a0  ! 4433: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r15
	.word 0xde95a000  ! 4434: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r15
	.word 0xdeb504a0  ! 4435: STHA_R	stha	%r15, [%r20 + %r0] 0x25
	.word 0xde852000  ! 4436: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r15
	mov	0x7c0, %r23
	.word 0xd6afce80  ! 4438: STBA_R	stba	%r11, [%r31 + %r0] 0x74
	mov	0x18, %r27
	.word 0xd0c74e40  ! 4440: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r8
	.word 0xd0856000  ! 4441: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r8
	mov	0x7e0, %r22
	.word 0xd0ada000  ! 4443: STBA_I	stba	%r8, [%r22 + 0x0000] %asi
	.word 0x8780204f  ! 4444: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0bee000  ! 4445: STDA_I	stda	%r8, [%r27 + 0x0000] %asi
	mov	0x50, %r17
	.word 0xd8a4c400  ! 4447: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xd8866000  ! 4448: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r12
	.word 0xd8f66000  ! 4449: STXA_I	stxa	%r12, [%r25 + 0x0000] %asi
	mov	0x7d0, %r23
	mov	0x7c0, %r21
	.word 0xd2844400  ! 4452: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	.word 0xd894c400  ! 4453: LDUHA_R	lduha	[%r19, %r0] 0x20, %r12
	.word 0xd8de6000  ! 4454: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r12
	.word 0xd8d6e000  ! 4455: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r12
	.word 0x87802074  ! 4456: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f78e60  ! 4457: STXA_R	stxa	%r8, [%r30 + %r0] 0x73
	.word 0xdad78e40  ! 4458: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r13
	.word 0xd6f74e40  ! 4459: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	mov	0x3f0, %r22
	.word 0xd6a544a0  ! 4461: STWA_R	stwa	%r11, [%r21 + %r0] 0x25
	.word 0xdea6c9e0  ! 4462: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	mov	0x7f0, %r21
	.word 0xd88d04a0  ! 4464: LDUBA_R	lduba	[%r20, %r0] 0x25, %r12
	.word 0xd8c7a000  ! 4465: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xd2974e80  ! 4466: LDUHA_R	lduha	[%r29, %r0] 0x74, %r9
	mov	0x78, %r25
	mov	0x7e8, %r22
	.word 0x87802025  ! 4469: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2f5e000  ! 4470: STXA_I	stxa	%r9, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 4471: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cdc4a0  ! 4472: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r10
	.word 0xd4f42000  ! 4473: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd4d4a000  ! 4474: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0xdac504a0  ! 4475: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r13
	.word 0xd4df0e40  ! 4476: LDXA_R	ldxa	[%r28, %r0] 0x72, %r10
	.word 0xd49c2000  ! 4477: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	.word 0xd4f42000  ! 4478: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd4ac2000  ! 4479: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0xd4ac2000  ! 4480: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 4481: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4482: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r23
	.word 0xd4944400  ! 4484: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	.word 0xd0dfce60  ! 4485: LDXA_R	ldxa	[%r31, %r0] 0x73, %r8
	.word 0xd0d4e000  ! 4486: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	.word 0xd08ce000  ! 4487: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0x87802072  ! 4488: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0a7a000  ! 4489: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	mov	0x3c0, %r23
	.word 0xdabd04a0  ! 4491: STDA_R	stda	%r13, [%r20 + %r0] 0x25
	.word 0xdc9f8e80  ! 4492: LDDA_R	ldda	[%r30, %r0] 0x74, %r14
	mov	0x3c8, %r22
	.word 0xd2978e60  ! 4494: LDUHA_R	lduha	[%r30, %r0] 0x73, %r9
	.word 0xd2bf6000  ! 4495: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	mov	0x0, %r27
	mov	0x7c8, %r23
	.word 0xd2b7a000  ! 4498: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 4499: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2a72000  ! 4500: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 4501: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2d56000  ! 4502: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r9
	.word 0xdcd689e0  ! 4503: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r14
	.word 0x87802073  ! 4504: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r25
	.word 0xd4b44400  ! 4506: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	.word 0xd4c7a000  ! 4507: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	mov	0x70, %r27
	mov	0x60, %r26
	.word 0xd2970e40  ! 4510: LDUHA_R	lduha	[%r28, %r0] 0x72, %r9
	.word 0xd2a7e000  ! 4511: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xd2af2000  ! 4512: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xde948400  ! 4513: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	.word 0x87802073  ! 4514: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4515: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebce000  ! 4516: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xdef4a000  ! 4518: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0xd4ac0400  ! 4519: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xd48e89e0  ! 4520: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r10
	.word 0xd4d46000  ! 4521: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r10
	.word 0x87802073  ! 4522: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r19
	.word 0xd6bf0e60  ! 4524: STDA_R	stda	%r11, [%r28 + %r0] 0x73
	.word 0xd8b7ce40  ! 4525: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0xd6970e60  ! 4526: LDUHA_R	lduha	[%r28, %r0] 0x73, %r11
	.word 0xd6c76000  ! 4527: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6c7e000  ! 4528: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xd295c4a0  ! 4529: LDUHA_R	lduha	[%r23, %r0] 0x25, %r9
	.word 0x87802020  ! 4530: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a4a000  ! 4531: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0xd28c6000  ! 4532: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0xd2f46000  ! 4533: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	mov	0x28, %r27
	.word 0x87802025  ! 4535: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6d40400  ! 4536: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	mov	0x3c8, %r22
	.word 0xd6c5e000  ! 4538: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r11
	.word 0xd2bfce80  ! 4539: STDA_R	stda	%r9, [%r31 + %r0] 0x74
	.word 0xd484c400  ! 4540: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	.word 0xd4f5e000  ! 4541: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	.word 0xd6f544a0  ! 4542: STXA_R	stxa	%r11, [%r21 + %r0] 0x25
	.word 0xdcb44400  ! 4543: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0xdcd5a000  ! 4544: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r14
	.word 0xdca56000  ! 4545: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	.word 0xdec544a0  ! 4546: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r15
	.word 0xd6ac4400  ! 4547: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xd4f44400  ! 4548: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802025  ! 4550: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r26
	.word 0xd4c5a000  ! 4552: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r10
	mov	0x60, %r19
	.word 0x87802073  ! 4554: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r27
	.word 0xd6dd44a0  ! 4556: LDXA_R	ldxa	[%r21, %r0] 0x25, %r11
	.word 0x8780204f  ! 4557: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2b544a0  ! 4558: STHA_R	stha	%r9, [%r21 + %r0] 0x25
	.word 0xded70e40  ! 4559: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r15
	.word 0xd4f78e40  ! 4560: STXA_R	stxa	%r10, [%r30 + %r0] 0x72
	mov	0x7e0, %r22
	.word 0xd4d70e60  ! 4562: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r10
	.word 0xd4ae2000  ! 4563: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	mov	0x70, %r19
	.word 0x87802020  ! 4565: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49ce000  ! 4566: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0xdef70e80  ! 4567: STXA_R	stxa	%r15, [%r28 + %r0] 0x74
	.word 0xdeb46000  ! 4568: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	mov	0x50, %r19
	.word 0xd8b70e60  ! 4570: STHA_R	stha	%r12, [%r28 + %r0] 0x73
	mov	0x48, %r25
	mov	0x3d0, %r21
	.word 0xd8f4e000  ! 4573: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xd8a46000  ! 4575: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8b42000  ! 4576: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	.word 0xdca7ce60  ! 4577: STWA_R	stwa	%r14, [%r31 + %r0] 0x73
	.word 0xd4be89e0  ! 4578: STDA_R	stda	%r10, [%r26 + %r0] 0x4f
	.word 0xd49c6000  ! 4579: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	mov	0x3f0, %r23
	mov	0x50, %r18
	mov	0x38, %r18
	.word 0xd2944400  ! 4583: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	mov	0x20, %r26
	.word 0xd2ace000  ! 4585: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0xd2bca000  ! 4586: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	.word 0xd2ace000  ! 4587: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 4588: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r19
	.word 0xd2aea000  ! 4590: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0xd2aee000  ! 4591: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	.word 0xd28ee000  ! 4592: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r9
	mov	0x3e0, %r21
	.word 0xd2aee000  ! 4594: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	.word 0x87802074  ! 4595: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 4596: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd29d6000  ! 4597: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r9
	.word 0xd2a5e000  ! 4598: STWA_I	stwa	%r9, [%r23 + 0x0000] %asi
	.word 0xd8bdc4a0  ! 4599: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	.word 0xd8a5a000  ! 4600: STWA_I	stwa	%r12, [%r22 + 0x0000] %asi
	.word 0xd895a000  ! 4601: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r12
	.word 0xd8f5e000  ! 4602: STXA_I	stxa	%r12, [%r23 + 0x0000] %asi
	.word 0xd8bde000  ! 4603: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0xd8d56000  ! 4604: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r12
	.word 0xdcd78e40  ! 4605: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r14
	.word 0x87802020  ! 4606: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 4607: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 4608: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca72000  ! 4609: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdc8f2000  ! 4610: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0xdcd76000  ! 4611: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	mov	0x70, %r25
	.word 0xdecd84a0  ! 4613: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r15
	.word 0xdcc40400  ! 4614: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	.word 0x8780204f  ! 4615: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a544a0  ! 4616: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	.word 0x8780204f  ! 4617: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f66000  ! 4618: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0xd2a7ce40  ! 4620: STWA_R	stwa	%r9, [%r31 + %r0] 0x72
	.word 0xd296e000  ! 4621: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r9
	.word 0xd2a66000  ! 4622: STWA_I	stwa	%r9, [%r25 + 0x0000] %asi
	.word 0xd2b74e40  ! 4623: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x8, %r27
	mov	0x7c0, %r23
	.word 0xd2f62000  ! 4627: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	.word 0xd2d66000  ! 4628: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r9
	.word 0xd2b6a000  ! 4629: STHA_I	stha	%r9, [%r26 + 0x0000] %asi
	.word 0xd4d74e40  ! 4630: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r10
	.word 0xd4ae2000  ! 4631: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	.word 0xde8f0e60  ! 4632: LDUBA_R	lduba	[%r28, %r0] 0x73, %r15
	.word 0x87802073  ! 4633: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8c609e0  ! 4634: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r12
	mov	0x3c8, %r20
	.word 0xd8b76000  ! 4636: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd8c72000  ! 4637: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8dfa000  ! 4638: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8f72000  ! 4639: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xd8c72000  ! 4641: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	mov	0x3d8, %r23
	mov	0x3f8, %r22
	mov	0x18, %r18
	.word 0xd6a584a0  ! 4645: STWA_R	stwa	%r11, [%r22 + %r0] 0x25
	.word 0xd0bc4400  ! 4646: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xd0f76000  ! 4647: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xd8a4c400  ! 4649: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	mov	0x10, %r25
	mov	0x3d0, %r23
	.word 0xd086c9e0  ! 4652: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r8
	.word 0xd0d72000  ! 4653: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0x87802073  ! 4654: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 4655: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd097e000  ! 4656: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xdcad04a0  ! 4657: STBA_R	stba	%r14, [%r20 + %r0] 0x25
	mov	0x3f8, %r22
	mov	0x3d0, %r21
	.word 0xd4a544a0  ! 4660: STWA_R	stwa	%r10, [%r21 + %r0] 0x25
	.word 0x87802020  ! 4661: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r17
	.word 0xd4cca000  ! 4663: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r10
	.word 0xd4b4e000  ! 4664: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xd6b689e0  ! 4665: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	.word 0xd88584a0  ! 4666: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r12
	.word 0xd8b46000  ! 4667: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0xd4f78e40  ! 4668: STXA_R	stxa	%r10, [%r30 + %r0] 0x72
	.word 0xd4aca000  ! 4669: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	mov	0x7f0, %r22
	.word 0xd2bf0e60  ! 4671: STDA_R	stda	%r9, [%r28 + %r0] 0x73
	.word 0x87802020  ! 4672: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r25
	.word 0xd2c42000  ! 4674: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	.word 0xd2b46000  ! 4675: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0xdac48400  ! 4676: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	.word 0x87802020  ! 4677: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08f4e80  ! 4678: LDUBA_R	lduba	[%r29, %r0] 0x74, %r8
	.word 0xd0b4a000  ! 4679: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 4680: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8bf4e80  ! 4681: STDA_R	stda	%r12, [%r29 + %r0] 0x74
	.word 0xd88f2000  ! 4682: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0xdec609e0  ! 4683: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r15
	mov	0x3e8, %r23
	mov	0x7f8, %r21
	.word 0xde876000  ! 4686: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xd8bd44a0  ! 4687: STDA_R	stda	%r12, [%r21 + %r0] 0x25
	.word 0xd8afa000  ! 4688: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 4689: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r19
	.word 0xd8f56000  ! 4691: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	.word 0xd0ac0400  ! 4692: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	.word 0xd0f5e000  ! 4693: STXA_I	stxa	%r8, [%r23 + 0x0000] %asi
	mov	0x3e8, %r20
	mov	0x3c0, %r20
	.word 0xd0b52000  ! 4696: STHA_I	stha	%r8, [%r20 + 0x0000] %asi
	mov	0x40, %r19
	mov	0x7e8, %r20
	.word 0xdec4c400  ! 4699: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	mov	0x50, %r18
	.word 0xdeb5e000  ! 4701: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	.word 0xdef5e000  ! 4702: STXA_I	stxa	%r15, [%r23 + 0x0000] %asi
	.word 0xdec52000  ! 4703: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r15
	.word 0x87802020  ! 4704: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4705: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9c2000  ! 4706: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	mov	0x3f0, %r20
	mov	0x20, %r19
	mov	0x70, %r19
	.word 0xdcdf0e40  ! 4710: LDXA_R	ldxa	[%r28, %r0] 0x72, %r14
	.word 0xdca4a000  ! 4711: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcc46000  ! 4712: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r14
	.word 0xdcd46000  ! 4713: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	.word 0xdc846000  ! 4714: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	mov	0x3c8, %r22
	.word 0xdc8c6000  ! 4716: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r14
	mov	0x7f8, %r22
	.word 0x8780204f  ! 4718: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbee000  ! 4719: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 4720: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4721: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c78e60  ! 4722: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r12
	mov	0x50, %r16
	mov	0x0, %r16
	.word 0xd6ad04a0  ! 4725: STBA_R	stba	%r11, [%r20 + %r0] 0x25
	.word 0xd2a78e40  ! 4726: STWA_R	stwa	%r9, [%r30 + %r0] 0x72
	.word 0xd0af4e80  ! 4727: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	mov	0x40, %r27
	.word 0xd29cc400  ! 4729: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	.word 0xdcd584a0  ! 4730: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r14
	.word 0x87802074  ! 4731: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca7e000  ! 4732: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	mov	0x30, %r19
	.word 0xda8f4e80  ! 4734: LDUBA_R	lduba	[%r29, %r0] 0x74, %r13
	.word 0x87802073  ! 4735: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdac76000  ! 4736: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0xda8fce60  ! 4737: LDUBA_R	lduba	[%r31, %r0] 0x73, %r13
	mov	0x78, %r17
	mov	0x60, %r17
	.word 0xd88fce40  ! 4740: LDUBA_R	lduba	[%r31, %r0] 0x72, %r12
	.word 0xd8872000  ! 4741: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	mov	0x68, %r27
	.word 0x87802020  ! 4743: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d504a0  ! 4744: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r12
	.word 0xd4f78e80  ! 4745: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	mov	0x3c0, %r22
	.word 0xdaac4400  ! 4747: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	.word 0x87802074  ! 4748: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd8a74e60  ! 4750: STWA_R	stwa	%r12, [%r29 + %r0] 0x73
	.word 0xd4f74e40  ! 4751: STXA_R	stxa	%r10, [%r29 + %r0] 0x72
	mov	0x48, %r27
	.word 0xd497a000  ! 4753: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd4af6000  ! 4755: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	mov	0x7c0, %r21
	.word 0xd4d72000  ! 4757: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	.word 0xdcccc400  ! 4758: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	.word 0xd8dc4400  ! 4759: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	mov	0x7c8, %r21
	mov	0x50, %r27
	.word 0xd8bfe000  ! 4762: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0x87802074  ! 4764: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r25
	.word 0xd0f48400  ! 4766: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xdaae49e0  ! 4767: STBA_R	stba	%r13, [%r25 + %r0] 0x4f
	mov	0x20, %r25
	.word 0x87802073  ! 4769: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6aec9e0  ! 4770: STBA_R	stba	%r11, [%r27 + %r0] 0x4f
	mov	0x7e0, %r20
	.word 0xd8aec9e0  ! 4772: STBA_R	stba	%r12, [%r27 + %r0] 0x4f
	.word 0xd8cf8e80  ! 4773: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r12
	.word 0xd8b74e80  ! 4774: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	.word 0x87802074  ! 4775: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bfa000  ! 4776: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd287ce80  ! 4777: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r9
	.word 0xdccf4e80  ! 4778: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r14
	.word 0x87802020  ! 4779: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbc6000  ! 4780: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xdcdca000  ! 4781: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xd8df4e60  ! 4782: LDXA_R	ldxa	[%r29, %r0] 0x73, %r12
	mov	0x18, %r26
	.word 0xd6b44400  ! 4784: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xd68c6000  ! 4785: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r11
	.word 0x87802072  ! 4786: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 4787: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e0, %r21
	.word 0x87802074  ! 4789: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 4790: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4b74e40  ! 4791: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	.word 0x87802073  ! 4792: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e0, %r20
	.word 0xd4c7a000  ! 4794: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4a72000  ! 4795: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x3d0, %r23
	mov	0x68, %r27
	mov	0x8, %r24
	mov	0x40, %r18
	mov	0x8, %r26
	.word 0xd4bf6000  ! 4802: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd4b76000  ! 4803: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	mov	0x68, %r19
	.word 0xd4b76000  ! 4805: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	mov	0x28, %r26
	.word 0x8780204f  ! 4807: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f66000  ! 4808: STXA_I	stxa	%r10, [%r25 + 0x0000] %asi
	mov	0x20, %r18
	.word 0x87802020  ! 4810: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd097ce60  ! 4811: LDUHA_R	lduha	[%r31, %r0] 0x73, %r8
	.word 0x87802020  ! 4812: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bf0e60  ! 4813: STDA_R	stda	%r8, [%r28 + %r0] 0x73
	.word 0xd0afce40  ! 4814: STBA_R	stba	%r8, [%r31 + %r0] 0x72
	.word 0xd4c70e60  ! 4815: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r10
	.word 0xd4a4a000  ! 4816: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xd4d4e000  ! 4817: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0xd4d7ce80  ! 4818: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r10
	.word 0xd4a42000  ! 4819: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xd4aca000  ! 4821: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	mov	0x8, %r26
	.word 0xd294c400  ! 4823: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	.word 0x87802020  ! 4824: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r16
	.word 0xd2ac2000  ! 4826: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xdacc0400  ! 4827: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r13
	mov	0x3f0, %r20
	.word 0xdaf46000  ! 4829: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0xdaa46000  ! 4830: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	.word 0xd6af4e80  ! 4831: STBA_R	stba	%r11, [%r29 + %r0] 0x74
	.word 0x87802020  ! 4832: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b4e000  ! 4833: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	mov	0x58, %r24
	.word 0x87802072  ! 4835: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f72000  ! 4836: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6f7ce60  ! 4837: STXA_R	stxa	%r11, [%r31 + %r0] 0x73
	.word 0xd6f72000  ! 4838: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd8f40400  ! 4839: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xd8bf6000  ! 4840: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd8af6000  ! 4841: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xdc8f4e40  ! 4842: LDUBA_R	lduba	[%r29, %r0] 0x72, %r14
	.word 0xdca6c9e0  ! 4843: STWA_R	stwa	%r14, [%r27 + %r0] 0x4f
	.word 0xd89f0e60  ! 4844: LDDA_R	ldda	[%r28, %r0] 0x73, %r12
	.word 0xdc9e49e0  ! 4845: LDDA_R	ldda	[%r25, %r0] 0x4f, %r14
	.word 0xd6af8e60  ! 4846: STBA_R	stba	%r11, [%r30 + %r0] 0x73
	.word 0xd4b40400  ! 4847: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0x87802074  ! 4848: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bf8e40  ! 4849: STDA_R	stda	%r12, [%r30 + %r0] 0x72
	.word 0xdc870e80  ! 4850: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r14
	.word 0x87802073  ! 4851: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda970e60  ! 4852: LDUHA_R	lduha	[%r28, %r0] 0x73, %r13
	.word 0xda9fce40  ! 4853: LDDA_R	ldda	[%r31, %r0] 0x72, %r13
	.word 0x87802073  ! 4854: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbc8400  ! 4855: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	mov	0x7c0, %r20
	.word 0xdc9f2000  ! 4857: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xd29504a0  ! 4858: LDUHA_R	lduha	[%r20, %r0] 0x25, %r9
	.word 0xd497ce80  ! 4859: LDUHA_R	lduha	[%r31, %r0] 0x74, %r10
	mov	0x40, %r18
	.word 0xdebcc400  ! 4861: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	mov	0x0, %r26
	.word 0xde972000  ! 4863: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0x87802020  ! 4864: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef4e000  ! 4865: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 4866: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd88f4e40  ! 4867: LDUBA_R	lduba	[%r29, %r0] 0x72, %r12
	.word 0x87802074  ! 4868: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8c7e000  ! 4869: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8a76000  ! 4870: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xdecc0400  ! 4871: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r15
	.word 0xded7a000  ! 4872: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xdad4c400  ! 4873: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xda870e40  ! 4874: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r13
	.word 0xd0c7ce40  ! 4875: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r8
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0d7e000  ! 4877: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	mov	0x68, %r25
	.word 0x8780204f  ! 4879: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2b609e0  ! 4880: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	.word 0xd2bea000  ! 4881: STDA_I	stda	%r9, [%r26 + 0x0000] %asi
	.word 0xd0ac0400  ! 4882: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	.word 0xd6f7ce40  ! 4883: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	mov	0x58, %r25
	.word 0x87802020  ! 4885: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r17
	.word 0xd6c544a0  ! 4887: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r11
	mov	0x3f0, %r21
	.word 0xd6b48400  ! 4889: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xdeacc400  ! 4890: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xdebc2000  ! 4891: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	mov	0x3f8, %r23
	.word 0x87802073  ! 4893: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdea72000  ! 4894: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 4895: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r21
	.word 0xdcbe49e0  ! 4897: STDA_R	stda	%r14, [%r25 + %r0] 0x4f
	.word 0xd4b48400  ! 4898: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	mov	0x60, %r24
	.word 0xd28609e0  ! 4900: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r9
	.word 0x87802073  ! 4901: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd287e000  ! 4902: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	mov	0x58, %r27
	mov	0x78, %r27
	.word 0xd29fa000  ! 4905: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xdeac8400  ! 4906: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xd0ac8400  ! 4907: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0x87802020  ! 4908: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cfce60  ! 4909: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r8
	.word 0xd2bf8e80  ! 4910: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	mov	0x40, %r17
	.word 0xdeac4400  ! 4912: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0xde84e000  ! 4913: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	.word 0x87802025  ! 4914: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f8, %r21
	.word 0xd4f74e80  ! 4916: STXA_R	stxa	%r10, [%r29 + %r0] 0x74
	.word 0xd4bda000  ! 4917: STDA_I	stda	%r10, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 4918: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4919: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4ae2000  ! 4920: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	.word 0xd48ea000  ! 4921: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r10
	.word 0xd6bc8400  ! 4922: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xd8f74e60  ! 4923: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	mov	0x48, %r24
	.word 0xd6c7ce40  ! 4925: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r11
	.word 0xd2a78e60  ! 4926: STWA_R	stwa	%r9, [%r30 + %r0] 0x73
	.word 0xd6b48400  ! 4927: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd6f66000  ! 4928: STXA_I	stxa	%r11, [%r25 + 0x0000] %asi
	.word 0xd6966000  ! 4929: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r11
	mov	0x0, %r25
	.word 0xd6dea000  ! 4931: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r11
	.word 0xd6a66000  ! 4932: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	.word 0xd6c66000  ! 4933: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r11
	.word 0xd6ce2000  ! 4934: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	.word 0x87802025  ! 4935: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f52000  ! 4936: STXA_I	stxa	%r11, [%r20 + 0x0000] %asi
	.word 0xd2dec9e0  ! 4937: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r9
	.word 0xd6d70e40  ! 4938: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r11
	.word 0xd6ad2000  ! 4939: STBA_I	stba	%r11, [%r20 + 0x0000] %asi
	.word 0xd6a5a000  ! 4940: STWA_I	stwa	%r11, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 4941: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6cfe000  ! 4942: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	mov	0x60, %r24
	mov	0x3f8, %r21
	.word 0xd6afe000  ! 4945: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd6a7e000  ! 4946: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xda9fce80  ! 4947: LDDA_R	ldda	[%r31, %r0] 0x74, %r13
	.word 0xdac72000  ! 4948: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0xd4a44400  ! 4949: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xd6b40400  ! 4950: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	mov	0x38, %r18
	.word 0xd6dfa000  ! 4952: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0xdcf40400  ! 4953: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xd8f74e60  ! 4954: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	.word 0x87802020  ! 4955: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b4a000  ! 4956: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xd88c2000  ! 4958: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	.word 0xd884a000  ! 4959: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4960: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8aca000  ! 4961: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 4962: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6de09e0  ! 4963: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r11
	.word 0xd6a42000  ! 4964: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xd68e49e0  ! 4965: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r11
	.word 0xd6be09e0  ! 4966: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	.word 0xd6f4a000  ! 4967: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	mov	0x18, %r16
	.word 0xd6bca000  ! 4969: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	.word 0xd6af0e80  ! 4970: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	.word 0xd8adc4a0  ! 4971: STBA_R	stba	%r12, [%r23 + %r0] 0x25
	.word 0xd88c6000  ! 4972: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	.word 0xd8848400  ! 4973: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r12
	.word 0xdede89e0  ! 4974: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r15
	mov	0x48, %r25
	mov	0x60, %r27
	.word 0xd0bf4e60  ! 4977: STDA_R	stda	%r8, [%r29 + %r0] 0x73
	.word 0xdccd84a0  ! 4978: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r14
	.word 0xdca46000  ! 4979: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xd084c400  ! 4980: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r8
	mov	0x7e0, %r20
	.word 0xdcb48400  ! 4982: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xdca42000  ! 4983: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xd0af0e60  ! 4984: STBA_R	stba	%r8, [%r28 + %r0] 0x73
	.word 0xdecd04a0  ! 4985: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r15
	.word 0xd29c8400  ! 4986: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	mov	0x50, %r25
	.word 0xd2d4a000  ! 4988: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	.word 0xdeac8400  ! 4989: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	mov	0x3f8, %r21
	.word 0xdea46000  ! 4991: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xdecce000  ! 4992: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	.word 0xdef4a000  ! 4993: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 4994: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8f0e60  ! 4995: LDUBA_R	lduba	[%r28, %r0] 0x73, %r13
	.word 0xd8a78e60  ! 4996: STWA_R	stwa	%r12, [%r30 + %r0] 0x73
	.word 0xd8f4a000  ! 4997: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xd2b5c4a0  ! 4998: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	mov	0x0, %r17
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_3:
	.word 0xd8ae09e0  ! 1: STBA_R	stba	%r12, [%r24 + %r0] 0x4f
	.word 0xd2d5e000  ! 2: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r9
	.word 0xdab74e40  ! 3: STHA_R	stha	%r13, [%r29 + %r0] 0x72
	mov	0x58, %r25
	mov	0x50, %r26
	.word 0xdca5a000  ! 6: STWA_I	stwa	%r14, [%r22 + 0x0000] %asi
	.word 0xdeb40400  ! 7: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0xdcb5e000  ! 8: STHA_I	stha	%r14, [%r23 + 0x0000] %asi
	.word 0x87802073  ! 9: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd09c0400  ! 10: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	mov	0x30, %r18
	.word 0xd0cc6000  ! 12: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	.word 0xd0b42000  ! 13: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 14: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c4c400  ! 15: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r11
	mov	0x68, %r24
	.word 0xdeb5c4a0  ! 17: STHA_R	stha	%r15, [%r23 + %r0] 0x25
	mov	0x3d0, %r21
	mov	0x28, %r25
	mov	0x7e8, %r23
	.word 0xd0dd2000  ! 21: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0xde8f4e80  ! 22: LDUBA_R	lduba	[%r29, %r0] 0x74, %r15
	mov	0x10, %r16
	.word 0xd2df8e40  ! 24: LDXA_R	ldxa	[%r30, %r0] 0x72, %r9
	mov	0x0, %r24
	.word 0xd8bda000  ! 26: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	.word 0xd8cf8e60  ! 27: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r12
	.word 0x87802020  ! 28: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab7a000  ! 29: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	mov	0x68, %r18
	.word 0xda8f6000  ! 31: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	mov	0x10, %r24
	.word 0xda8fe000  ! 33: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xda87a000  ! 34: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	mov	0x38, %r25
	.word 0x87802073  ! 36: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd09fce40  ! 37: LDDA_R	ldda	[%r31, %r0] 0x72, %r8
	.word 0xd895e000  ! 38: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r12
	.word 0xd6ac4400  ! 39: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xda856000  ! 40: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r13
	.word 0xda85e000  ! 41: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	.word 0xd08f0e40  ! 42: LDUBA_R	lduba	[%r28, %r0] 0x72, %r8
	.word 0xdab5e000  ! 43: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0xdabd6000  ! 44: STDA_I	stda	%r13, [%r21 + 0x0000] %asi
	mov	0x70, %r25
	.word 0x87802020  ! 46: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa4e000  ! 47: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0xdaa46000  ! 48: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 49: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaaf2000  ! 50: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xd4a74e40  ! 51: STWA_R	stwa	%r10, [%r29 + %r0] 0x72
	.word 0xd0df8e40  ! 52: LDXA_R	ldxa	[%r30, %r0] 0x72, %r8
	.word 0xd6d7e000  ! 53: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	mov	0x3f0, %r20
	.word 0x87802020  ! 55: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b7a000  ! 56: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd6b7e000  ! 57: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd6afe000  ! 58: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0x87802074  ! 60: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6876000  ! 61: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	.word 0xd697e000  ! 62: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	mov	0x60, %r27
	mov	0x38, %r19
	.word 0x87802074  ! 65: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b74e60  ! 66: STHA_R	stha	%r9, [%r29 + %r0] 0x73
	mov	0x40, %r25
	mov	0x3c8, %r21
	.word 0xdcd72000  ! 69: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	mov	0x48, %r16
	mov	0x50, %r25
	.word 0xdc8f6000  ! 72: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xd8ae89e0  ! 73: STBA_R	stba	%r12, [%r26 + %r0] 0x4f
	.word 0xd4a78e40  ! 74: STWA_R	stwa	%r10, [%r30 + %r0] 0x72
	.word 0xdcf7e000  ! 75: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xd8ad04a0  ! 76: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	.word 0xd6f689e0  ! 77: STXA_R	stxa	%r11, [%r26 + %r0] 0x4f
	mov	0x70, %r19
	.word 0x87802020  ! 79: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 80: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 81: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a5e000  ! 82: STWA_I	stwa	%r8, [%r23 + 0x0000] %asi
	mov	0x3f8, %r22
	.word 0xd0dde000  ! 84: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r8
	.word 0xd0c5e000  ! 85: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r8
	.word 0xd0f52000  ! 86: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	mov	0x30, %r26
	.word 0xd0ad2000  ! 88: STBA_I	stba	%r8, [%r20 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xd0bd2000  ! 90: STDA_I	stda	%r8, [%r20 + 0x0000] %asi
	.word 0xd0a56000  ! 91: STWA_I	stwa	%r8, [%r21 + 0x0000] %asi
	.word 0xda9c8400  ! 92: LDDA_R	ldda	[%r18, %r0] 0x20, %r13
	mov	0x7e0, %r22
	.word 0xdadc8400  ! 94: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	.word 0xd6a74e40  ! 95: STWA_R	stwa	%r11, [%r29 + %r0] 0x72
	.word 0x87802025  ! 96: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdea48400  ! 97: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	ta	T_CHANGE_PRIV	! macro
	.word 0xd69ec9e0  ! 99: LDDA_R	ldda	[%r27, %r0] 0x4f, %r11
	.word 0xd8ac8400  ! 100: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0xd6b76000  ! 101: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 102: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r19
	.word 0xd68ca000  ! 104: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r11
	.word 0xdcbc4400  ! 105: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0xd2a46000  ! 106: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd8c78e80  ! 107: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r12
	.word 0x87802025  ! 108: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8856000  ! 109: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	.word 0xd8d5a000  ! 110: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r12
	.word 0x87802025  ! 111: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8a76000  ! 112: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8afe000  ! 113: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd8c44400  ! 114: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r12
	.word 0x87802072  ! 115: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 116: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedfe000  ! 117: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	mov	0x68, %r25
	mov	0x3c0, %r20
	.word 0xdedfe000  ! 120: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xdebfe000  ! 121: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xdacec9e0  ! 122: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r13
	mov	0x3d0, %r20
	.word 0xd6f7e000  ! 124: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6d7e000  ! 125: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	.word 0xded78e40  ! 126: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r15
	.word 0xd6f76000  ! 127: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6b76000  ! 128: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd68cc400  ! 129: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	.word 0xd6876000  ! 130: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	mov	0x7d0, %r20
	.word 0xd6cfa000  ! 132: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	mov	0x3e8, %r21
	.word 0x87802025  ! 134: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 135: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r19
	.word 0xd6bf6000  ! 137: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd89c4400  ! 138: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	.word 0xd0ae49e0  ! 139: STBA_R	stba	%r8, [%r25 + %r0] 0x4f
	.word 0xd6a70e80  ! 140: STWA_R	stwa	%r11, [%r28 + %r0] 0x74
	.word 0xd0a7a000  ! 141: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0df6000  ! 142: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0xdcafce80  ! 143: STBA_R	stba	%r14, [%r31 + %r0] 0x74
	.word 0xd2a7a000  ! 144: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 145: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd285e000  ! 146: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r9
	mov	0x30, %r18
	mov	0x60, %r16
	.word 0xd2bda000  ! 149: STDA_I	stda	%r9, [%r22 + 0x0000] %asi
	.word 0xd2f56000  ! 150: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xd4acc400  ! 152: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0x87802073  ! 153: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r24
	.word 0x87802073  ! 155: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 156: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 157: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdef7e000  ! 158: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0xd0a4c400  ! 160: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	mov	0x10, %r27
	.word 0xdccfe000  ! 162: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	mov	0x40, %r27
	.word 0xdc9fa000  ! 164: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0xdcc72000  ! 165: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcd7e000  ! 166: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xdc87a000  ! 167: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0x87802020  ! 168: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r18
	.word 0x87802074  ! 170: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2dfce60  ! 171: LDXA_R	ldxa	[%r31, %r0] 0x73, %r9
	.word 0xd8876000  ! 172: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8afe000  ! 173: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xdaacc400  ! 174: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0xd0cfe000  ! 175: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0x87802020  ! 176: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 177: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r17
	mov	0x78, %r17
	.word 0xd0bc2000  ! 180: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	mov	0x3d0, %r20
	mov	0x40, %r24
	.word 0xd0bc6000  ! 183: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xd0cca000  ! 185: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	.word 0xdc9fce80  ! 186: LDDA_R	ldda	[%r31, %r0] 0x74, %r14
	mov	0x7f0, %r21
	mov	0x3d8, %r22
	.word 0xdebc6000  ! 189: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xd6b609e0  ! 190: STHA_R	stha	%r11, [%r24 + %r0] 0x4f
	.word 0xd8bf4e40  ! 191: STDA_R	stda	%r12, [%r29 + %r0] 0x72
	.word 0x87802072  ! 192: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdec78e40  ! 193: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r15
	.word 0xd69c8400  ! 194: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	mov	0x70, %r19
	mov	0x68, %r19
	.word 0xdc84a000  ! 197: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	.word 0xdccce000  ! 198: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r14
	.word 0xdc8c2000  ! 199: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r14
	.word 0xdcb42000  ! 200: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 201: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcad6000  ! 202: STBA_I	stba	%r14, [%r21 + 0x0000] %asi
	.word 0xdcbd2000  ! 203: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	.word 0xdcb5a000  ! 204: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0xdcc52000  ! 205: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r14
	.word 0xdc956000  ! 206: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r14
	.word 0xd6840400  ! 207: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0xd4de89e0  ! 208: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r10
	.word 0xdc85e000  ! 209: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r14
	mov	0x3d0, %r22
	.word 0x8780204f  ! 211: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r27
	.word 0xdc8d6000  ! 213: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r14
	.word 0x87802074  ! 214: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r26
	mov	0x18, %r24
	.word 0xdc8f2000  ! 217: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	mov	0x7e0, %r22
	.word 0xd0f609e0  ! 219: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	.word 0xd4ae09e0  ! 220: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	mov	0x78, %r27
	.word 0xdcce49e0  ! 222: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r14
	mov	0x68, %r18
	.word 0xded7a000  ! 224: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	mov	0x7e8, %r21
	.word 0x87802074  ! 226: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xded44400  ! 227: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	.word 0x87802074  ! 228: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 229: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r16
	mov	0x28, %r16
	.word 0xd89c0400  ! 232: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	.word 0x87802074  ! 233: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r26
	mov	0x18, %r24
	.word 0xd69ca000  ! 236: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r11
	mov	0x70, %r18
	.word 0xdc848400  ! 238: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	.word 0xd0f42000  ! 239: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0xd2bf0e40  ! 240: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	.word 0x87802072  ! 241: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8bfa000  ! 242: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xdef4c400  ! 243: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xd89d44a0  ! 244: LDDA_R	ldda	[%r21, %r0] 0x25, %r12
	mov	0x60, %r26
	.word 0x87802073  ! 246: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 247: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd09f0e40  ! 248: LDDA_R	ldda	[%r28, %r0] 0x72, %r8
	.word 0xd4a46000  ! 249: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xd8974e40  ! 250: LDUHA_R	lduha	[%r29, %r0] 0x72, %r12
	.word 0x87802020  ! 251: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4be09e0  ! 252: STDA_R	stda	%r10, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 253: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4af0e60  ! 254: STBA_R	stba	%r10, [%r28 + %r0] 0x73
	.word 0xd2b544a0  ! 255: STHA_R	stha	%r9, [%r21 + %r0] 0x25
	mov	0x70, %r17
	.word 0x87802025  ! 257: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 258: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0870e40  ! 259: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r8
	mov	0x70, %r18
	.word 0xded76000  ! 261: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0xdedf2000  ! 262: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xd8cc4400  ! 263: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r12
	.word 0xd4f7e000  ! 264: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4bfa000  ! 265: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd4dfa000  ! 266: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd08c0400  ! 267: LDUBA_R	lduba	[%r16, %r0] 0x20, %r8
	.word 0x8780204f  ! 268: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r27
	.word 0xd0848400  ! 270: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r8
	.word 0xded7e000  ! 271: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0x87802073  ! 272: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r16
	.word 0x87802020  ! 274: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebf8e60  ! 275: STDA_R	stda	%r15, [%r30 + %r0] 0x73
	mov	0x38, %r25
	.word 0xd28f0e60  ! 277: LDUBA_R	lduba	[%r28, %r0] 0x73, %r9
	.word 0xd6bf8e40  ! 278: STDA_R	stda	%r11, [%r30 + %r0] 0x72
	mov	0x40, %r19
	.word 0xdab584a0  ! 280: STHA_R	stha	%r13, [%r22 + %r0] 0x25
	.word 0x87802073  ! 281: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 282: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0cd84a0  ! 283: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r8
	.word 0x87802020  ! 284: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8df6000  ! 285: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	mov	0x58, %r19
	.word 0xdcbc4400  ! 287: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0x87802074  ! 288: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbc4400  ! 289: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	mov	0x3e0, %r23
	.word 0xd88c0400  ! 291: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	.word 0x87802072  ! 292: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c0, %r21
	.word 0xdec4e000  ! 294: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xde9c2000  ! 296: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0x87802074  ! 297: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f4c400  ! 298: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd0bda000  ! 299: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	.word 0xd085a000  ! 300: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r8
	mov	0x10, %r19
	.word 0xd2ad04a0  ! 302: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	mov	0x78, %r24
	mov	0x3e0, %r22
	.word 0xd4b40400  ! 305: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0x87802020  ! 306: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd89f2000  ! 307: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	mov	0x48, %r16
	.word 0xd8b7e000  ! 309: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0xd0cd04a0  ! 310: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r8
	.word 0xd497ce80  ! 311: LDUHA_R	lduha	[%r31, %r0] 0x74, %r10
	mov	0x10, %r25
	mov	0x58, %r25
	.word 0x87802074  ! 314: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f4a000  ! 315: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0xd6f4c400  ! 316: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	mov	0x3c0, %r22
	.word 0xd0c649e0  ! 318: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r8
	.word 0xd4f70e40  ! 319: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	.word 0xd0a5c4a0  ! 320: STWA_R	stwa	%r8, [%r23 + %r0] 0x25
	.word 0xd2dd84a0  ! 321: LDXA_R	ldxa	[%r22, %r0] 0x25, %r9
	.word 0xdacc8400  ! 322: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r13
	.word 0xdcdc2000  ! 323: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r14
	.word 0xd48c0400  ! 324: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	.word 0xdabe89e0  ! 325: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	mov	0x3c8, %r23
	.word 0xd48c2000  ! 327: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r10
	.word 0xdcbe49e0  ! 328: STDA_R	stda	%r14, [%r25 + %r0] 0x4f
	mov	0x18, %r17
	mov	0x10, %r18
	.word 0xdcf4a000  ! 331: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xd8af8e80  ! 332: STBA_R	stba	%r12, [%r30 + %r0] 0x74
	.word 0x87802073  ! 333: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2dc4400  ! 334: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xdadc6000  ! 335: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xd6b74e60  ! 336: STHA_R	stha	%r11, [%r29 + %r0] 0x73
	.word 0xdaf46000  ! 337: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0xdab4a000  ! 338: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0xdc8c8400  ! 339: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0x87802020  ! 340: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4de6000  ! 341: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r10
	.word 0xd4cee000  ! 342: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r10
	.word 0xd4ce2000  ! 343: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r10
	.word 0xd6a5c4a0  ! 344: STWA_R	stwa	%r11, [%r23 + %r0] 0x25
	.word 0xdc866000  ! 345: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r14
	.word 0xd2b44400  ! 346: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0xd28d44a0  ! 347: LDUBA_R	lduba	[%r21, %r0] 0x25, %r9
	.word 0xdcde6000  ! 348: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r14
	.word 0xdcdea000  ! 349: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r14
	.word 0xdcf6a000  ! 350: STXA_I	stxa	%r14, [%r26 + 0x0000] %asi
	.word 0xd4b48400  ! 351: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	mov	0x7c0, %r23
	.word 0xd8ae2000  ! 353: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	.word 0xd8dea000  ! 354: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r12
	mov	0x58, %r25
	mov	0x78, %r24
	.word 0xd8c78e60  ! 357: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r12
	.word 0x87802025  ! 358: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdec4c400  ! 359: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	.word 0x8780204f  ! 360: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4cf0e40  ! 361: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r10
	.word 0xda9c6000  ! 362: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0x87802020  ! 363: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d70e40  ! 364: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r11
	.word 0x87802074  ! 365: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8dc4400  ! 366: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	mov	0x68, %r26
	.word 0xd0b70e40  ! 368: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	.word 0xd6d7a000  ! 369: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	mov	0x8, %r27
	mov	0x20, %r24
	.word 0x87802025  ! 372: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d8, %r23
	.word 0x8780204f  ! 374: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdef7ce80  ! 375: STXA_R	stxa	%r15, [%r31 + %r0] 0x74
	.word 0x87802072  ! 376: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 377: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 378: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cfe000  ! 379: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0x87802020  ! 380: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r16
	.word 0xd2adc4a0  ! 382: STBA_R	stba	%r9, [%r23 + %r0] 0x25
	.word 0xdedfe000  ! 383: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	mov	0x7c8, %r20
	.word 0xdab5c4a0  ! 385: STHA_R	stha	%r13, [%r23 + %r0] 0x25
	.word 0x87802072  ! 386: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r25
	.word 0xd8f7e000  ! 388: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd897a000  ! 389: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	mov	0x28, %r27
	mov	0x30, %r25
	.word 0xd8948400  ! 392: LDUHA_R	lduha	[%r18, %r0] 0x20, %r12
	mov	0x28, %r24
	mov	0x40, %r16
	.word 0xdc940400  ! 395: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0xd487e000  ! 396: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd6c7ce80  ! 397: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r11
	mov	0x0, %r19
	mov	0x48, %r24
	.word 0xd8d7e000  ! 400: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0xd887a000  ! 401: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0x87802072  ! 402: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 403: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r25
	.word 0x8780204f  ! 405: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6c78e40  ! 406: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	.word 0xde8f2000  ! 407: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xd6d4c400  ! 408: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	.word 0xd897a000  ! 409: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0xd09c4400  ! 410: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	.word 0x87802073  ! 411: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r17
	.word 0xd6d70e40  ! 413: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r11
	mov	0x40, %r16
	mov	0x40, %r18
	.word 0x87802020  ! 416: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c504a0  ! 417: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r11
	mov	0x3c8, %r22
	.word 0xd4af6000  ! 419: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd4b72000  ! 420: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xdadc4400  ! 421: LDXA_R	ldxa	[%r17, %r0] 0x20, %r13
	mov	0x58, %r25
	.word 0xd2d7a000  ! 423: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0xd485c4a0  ! 424: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r10
	.word 0x87802074  ! 425: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4cfa000  ! 426: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0xd4bf2000  ! 427: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd4a7e000  ! 428: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd08c8400  ! 429: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0xdcdd84a0  ! 430: LDXA_R	ldxa	[%r22, %r0] 0x25, %r14
	.word 0xdaa7ce80  ! 431: STWA_R	stwa	%r13, [%r31 + %r0] 0x74
	.word 0xdeb7a000  ! 432: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xde8fe000  ! 433: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0xdedf6000  ! 434: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xdecec9e0  ! 435: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r15
	.word 0xdef72000  ! 436: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xded7e000  ! 437: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0x87802073  ! 438: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8944400  ! 439: LDUHA_R	lduha	[%r17, %r0] 0x20, %r12
	mov	0x7d8, %r23
	.word 0xd6d48400  ! 441: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0x87802020  ! 442: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r16
	.word 0xdebde000  ! 444: STDA_I	stda	%r15, [%r23 + 0x0000] %asi
	mov	0x20, %r18
	.word 0xdedd84a0  ! 446: LDXA_R	ldxa	[%r22, %r0] 0x25, %r15
	.word 0xd2970e80  ! 447: LDUHA_R	lduha	[%r28, %r0] 0x74, %r9
	.word 0xdeb4c400  ! 448: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0x87802073  ! 449: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d0, %r22
	mov	0x7f8, %r21
	.word 0xdcb7e000  ! 452: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xd8d40400  ! 453: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	.word 0xd6f7a000  ! 454: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6f7e000  ! 455: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd69fe000  ! 456: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	mov	0x3d0, %r20
	mov	0x8, %r18
	.word 0xd2bf0e60  ! 459: STDA_R	stda	%r9, [%r28 + %r0] 0x73
	.word 0xd8f74e40  ! 460: STXA_R	stxa	%r12, [%r29 + %r0] 0x72
	.word 0xd4bfe000  ! 461: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x50, %r18
	mov	0x7d8, %r20
	.word 0xd49fe000  ! 464: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd487e000  ! 465: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xdea7ce80  ! 466: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	.word 0xdaa7a000  ! 467: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xdadf2000  ! 468: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0xd6ae49e0  ! 469: STBA_R	stba	%r11, [%r25 + %r0] 0x4f
	mov	0x40, %r18
	.word 0xdad72000  ! 471: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0xd6f5c4a0  ! 472: STXA_R	stxa	%r11, [%r23 + %r0] 0x25
	.word 0xd4f48400  ! 473: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xdcf76000  ! 474: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdc8c4400  ! 475: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0xd8a72000  ! 476: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 477: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f8, %r22
	mov	0x7e8, %r21
	.word 0xd2f44400  ! 480: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	.word 0xdaa6e000  ! 481: STWA_I	stwa	%r13, [%r27 + 0x0000] %asi
	mov	0x60, %r27
	.word 0xdaa6e000  ! 483: STWA_I	stwa	%r13, [%r27 + 0x0000] %asi
	mov	0x0, %r17
	mov	0x28, %r24
	mov	0x3f0, %r22
	.word 0xda9e2000  ! 487: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r13
	mov	0x7e0, %r23
	mov	0x3f0, %r21
	.word 0xdaa66000  ! 490: STWA_I	stwa	%r13, [%r25 + 0x0000] %asi
	.word 0xdaf62000  ! 491: STXA_I	stxa	%r13, [%r24 + 0x0000] %asi
	.word 0xdaa66000  ! 492: STWA_I	stwa	%r13, [%r25 + 0x0000] %asi
	.word 0xdacea000  ! 493: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r13
	.word 0xda8ea000  ! 494: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r13
	.word 0x87802073  ! 495: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r26
	.word 0xd4d70e40  ! 497: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r10
	mov	0x18, %r18
	.word 0xd8dda000  ! 499: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r12
	mov	0x3f0, %r22
	.word 0xd6974e60  ! 501: LDUHA_R	lduha	[%r29, %r0] 0x73, %r11
	mov	0x28, %r25
	mov	0x8, %r17
	.word 0xd294c400  ! 504: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	.word 0xdca5c4a0  ! 505: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	.word 0xd0f48400  ! 506: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 507: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcaf4e40  ! 508: STBA_R	stba	%r14, [%r29 + %r0] 0x72
	.word 0xd6af2000  ! 509: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x60, %r16
	mov	0x3f0, %r21
	.word 0xd68f6000  ! 512: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xdaafce80  ! 513: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	.word 0xd2872000  ! 514: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2944400  ! 515: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	.word 0xd0c4c400  ! 516: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	.word 0xd4f48400  ! 517: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	mov	0x60, %r17
	.word 0xd4c7a000  ! 519: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	mov	0x18, %r17
	mov	0x3f8, %r20
	.word 0xd4c7e000  ! 522: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	.word 0xd0c7ce80  ! 523: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r8
	.word 0x87802020  ! 524: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dce000  ! 525: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r9
	.word 0xd2bc6000  ! 526: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0xdeb689e0  ! 527: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	.word 0xd897ce60  ! 528: LDUHA_R	lduha	[%r31, %r0] 0x73, %r12
	.word 0xdcd4a000  ! 529: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	mov	0x7f0, %r22
	.word 0x87802072  ! 531: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd28649e0  ! 532: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r9
	mov	0x38, %r17
	mov	0x3f0, %r20
	.word 0xdc87a000  ! 535: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xdc8f6000  ! 536: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcf4c400  ! 537: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xde8fe000  ! 538: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdea72000  ! 540: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	mov	0x18, %r17
	mov	0x3c0, %r22
	.word 0xdeb7a000  ! 543: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	mov	0x60, %r18
	.word 0xde9f6000  ! 545: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0xd2f74e40  ! 546: STXA_R	stxa	%r9, [%r29 + %r0] 0x72
	.word 0xda8f6000  ! 547: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	mov	0x40, %r19
	mov	0x40, %r18
	.word 0xdaae09e0  ! 550: STBA_R	stba	%r13, [%r24 + %r0] 0x4f
	mov	0x70, %r27
	.word 0x87802072  ! 552: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebfe000  ! 553: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	mov	0x48, %r27
	.word 0x87802020  ! 555: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cc8400  ! 556: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0x87802073  ! 557: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 558: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2ae09e0  ! 559: STBA_R	stba	%r9, [%r24 + %r0] 0x4f
	.word 0xd2a74e40  ! 560: STWA_R	stwa	%r9, [%r29 + %r0] 0x72
	.word 0xdabe6000  ! 561: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	.word 0xdcbc8400  ! 562: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xd68f0e40  ! 563: LDUBA_R	lduba	[%r28, %r0] 0x72, %r11
	.word 0xd8f689e0  ! 564: STXA_R	stxa	%r12, [%r26 + %r0] 0x4f
	.word 0xd2bea000  ! 565: STDA_I	stda	%r9, [%r26 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xd2b48400  ! 567: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd8be2000  ! 568: STDA_I	stda	%r12, [%r24 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0x87802073  ! 570: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd49ec9e0  ! 571: LDDA_R	ldda	[%r27, %r0] 0x4f, %r10
	.word 0xd2d46000  ! 572: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	.word 0xd2aca000  ! 573: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0xd2a4a000  ! 574: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0xd2b649e0  ! 575: STHA_R	stha	%r9, [%r25 + %r0] 0x4f
	.word 0xd6bc8400  ! 576: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	mov	0x7f8, %r21
	.word 0x87802073  ! 578: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde970e80  ! 579: LDUHA_R	lduha	[%r28, %r0] 0x74, %r15
	.word 0xd0f7e000  ! 580: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0df2000  ! 581: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0x87802073  ! 582: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r24
	.word 0xd0a52000  ! 584: STWA_I	stwa	%r8, [%r20 + 0x0000] %asi
	.word 0xd0f70e80  ! 585: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0xd0bcc400  ! 586: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0xdaaf8e80  ! 587: STBA_R	stba	%r13, [%r30 + %r0] 0x74
	.word 0xd0a52000  ! 588: STWA_I	stwa	%r8, [%r20 + 0x0000] %asi
	.word 0xdad70e60  ! 589: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r13
	mov	0x28, %r17
	.word 0xde9da000  ! 591: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r15
	.word 0xdef5a000  ! 592: STXA_I	stxa	%r15, [%r22 + 0x0000] %asi
	.word 0xdeb56000  ! 593: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	.word 0xde956000  ! 594: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r15
	.word 0xded52000  ! 595: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r15
	.word 0xde9fce80  ! 596: LDDA_R	ldda	[%r31, %r0] 0x74, %r15
	.word 0xdcdde000  ! 597: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	.word 0xdc9d2000  ! 598: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r14
	.word 0xd0a40400  ! 599: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0x87802025  ! 600: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r19
	.word 0xd8c6c9e0  ! 602: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r12
	mov	0x28, %r17
	.word 0xdaf7a000  ! 604: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xdaa7a000  ! 606: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xdaf76000  ! 607: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdab72000  ! 608: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	mov	0x20, %r24
	.word 0xda8f6000  ! 610: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	mov	0x40, %r18
	mov	0x3f0, %r20
	mov	0x38, %r25
	.word 0xd4a78e40  ! 614: STWA_R	stwa	%r10, [%r30 + %r0] 0x72
	.word 0xded7ce60  ! 615: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r15
	ta	T_CHANGE_PRIV	! macro
	.word 0xde840400  ! 617: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	.word 0xd2af6000  ! 618: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 619: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2dda000  ! 620: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r9
	.word 0xd2a5a000  ! 621: STWA_I	stwa	%r9, [%r22 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0xd2f5a000  ! 623: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	.word 0xd2a5e000  ! 624: STWA_I	stwa	%r9, [%r23 + 0x0000] %asi
	mov	0x78, %r19
	.word 0xde940400  ! 626: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0xd48d44a0  ! 627: LDUBA_R	lduba	[%r21, %r0] 0x25, %r10
	.word 0xd885a000  ! 628: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r12
	.word 0xd8a56000  ! 629: STWA_I	stwa	%r12, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 630: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 631: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r25
	.word 0xd8dc2000  ! 633: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0xde97ce80  ! 634: LDUHA_R	lduha	[%r31, %r0] 0x74, %r15
	.word 0xd89cc400  ! 635: LDDA_R	ldda	[%r19, %r0] 0x20, %r12
	mov	0x10, %r25
	.word 0xd2970e60  ! 637: LDUHA_R	lduha	[%r28, %r0] 0x73, %r9
	.word 0xd4acc400  ! 638: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xd0c78e80  ! 639: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r8
	.word 0xdeace000  ! 640: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	mov	0x3e0, %r21
	mov	0x3f8, %r21
	.word 0xde942000  ! 643: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	.word 0xded42000  ! 644: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	mov	0x20, %r18
	mov	0x60, %r25
	mov	0x7c8, %r20
	.word 0x87802020  ! 648: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4874e80  ! 649: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r10
	.word 0xd4f66000  ! 650: STXA_I	stxa	%r10, [%r25 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd4b6a000  ! 652: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	.word 0x87802025  ! 653: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaf544a0  ! 654: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	.word 0xda8c2000  ! 655: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r13
	.word 0xda84a000  ! 656: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	.word 0x87802073  ! 657: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd88e09e0  ! 658: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r12
	.word 0x87802073  ! 659: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4cf6000  ! 660: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0xdebcc400  ! 661: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	.word 0xd0a72000  ! 662: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x7f8, %r22
	mov	0x30, %r24
	.word 0xd2f40400  ! 665: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xd6af6000  ! 666: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd2d78e60  ! 667: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r9
	.word 0xd08f2000  ! 668: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	.word 0xded504a0  ! 669: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r15
	mov	0x58, %r26
	.word 0xd6a7a000  ! 671: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	mov	0x50, %r18
	.word 0xdebd44a0  ! 673: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	.word 0xdcdfa000  ! 674: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	mov	0x40, %r16
	.word 0xda9f8e40  ! 676: LDDA_R	ldda	[%r30, %r0] 0x72, %r13
	.word 0xd2a44400  ! 677: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xd8940400  ! 678: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	.word 0xd29f2000  ! 679: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd2dfa000  ! 680: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0x87802073  ! 681: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2a4c400  ! 682: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	mov	0x20, %r24
	.word 0xd2ae49e0  ! 684: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	.word 0xd88689e0  ! 685: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r12
	.word 0xdab649e0  ! 686: STHA_R	stha	%r13, [%r25 + %r0] 0x4f
	.word 0x87802073  ! 687: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e8, %r20
	.word 0xd0cf6000  ! 689: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd0cfa000  ! 690: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0xd0976000  ! 691: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0d76000  ! 692: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xdaf544a0  ! 693: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	.word 0xd4bf2000  ! 694: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd2b40400  ! 695: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0xd4dfe000  ! 696: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	mov	0x50, %r24
	.word 0xde944400  ! 698: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	mov	0x28, %r27
	mov	0x68, %r27
	.word 0xd2bf6000  ! 701: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd0cc4400  ! 702: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	.word 0xd8d7e000  ! 703: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	mov	0x3f0, %r21
	.word 0x87802020  ! 705: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8966000  ! 706: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r12
	mov	0x8, %r16
	.word 0xdcdfce60  ! 708: LDXA_R	ldxa	[%r31, %r0] 0x73, %r14
	.word 0xd4bea000  ! 709: STDA_I	stda	%r10, [%r26 + 0x0000] %asi
	.word 0xd48ee000  ! 710: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r10
	.word 0x87802020  ! 711: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r23
	mov	0x58, %r26
	.word 0x87802072  ! 714: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4bd6000  ! 715: STDA_I	stda	%r10, [%r21 + 0x0000] %asi
	mov	0x60, %r19
	.word 0xd4b5e000  ! 717: STHA_I	stha	%r10, [%r23 + 0x0000] %asi
	mov	0x68, %r26
	.word 0xd49de000  ! 719: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r10
	.word 0xd48da000  ! 720: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r10
	.word 0xd4dd2000  ! 721: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r10
	.word 0xd8bf8e40  ! 722: STDA_R	stda	%r12, [%r30 + %r0] 0x72
	.word 0xd0dda000  ! 723: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r8
	.word 0xdeaf4e60  ! 724: STBA_R	stba	%r15, [%r29 + %r0] 0x73
	.word 0xd6ccc400  ! 725: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	.word 0xd8c56000  ! 726: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r12
	.word 0x87802020  ! 727: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 728: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcc44400  ! 729: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	mov	0x48, %r17
	.word 0xd6afe000  ! 731: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd8844400  ! 732: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r12
	.word 0xd6ce89e0  ! 733: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r11
	.word 0x87802073  ! 734: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c8, %r21
	.word 0x87802073  ! 736: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2ce6000  ! 737: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r9
	.word 0xd48c8400  ! 738: LDUBA_R	lduba	[%r18, %r0] 0x20, %r10
	.word 0xd6f6a000  ! 739: STXA_I	stxa	%r11, [%r26 + 0x0000] %asi
	.word 0xd4b74e60  ! 740: STHA_R	stha	%r10, [%r29 + %r0] 0x73
	.word 0xd096e000  ! 741: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r8
	.word 0xd08ee000  ! 742: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r8
	mov	0x0, %r25
	mov	0x30, %r27
	mov	0x40, %r27
	mov	0x58, %r18
	.word 0xd4b70e60  ! 747: STHA_R	stha	%r10, [%r28 + %r0] 0x73
	.word 0xdec62000  ! 748: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r15
	mov	0x3d0, %r22
	mov	0x68, %r16
	.word 0xdeb6a000  ! 751: STHA_I	stha	%r15, [%r26 + 0x0000] %asi
	mov	0x30, %r27
	.word 0xd0af0e60  ! 753: STBA_R	stba	%r8, [%r28 + %r0] 0x73
	.word 0xdecf0e60  ! 754: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r15
	.word 0xd4be2000  ! 755: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 756: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f62000  ! 757: STXA_I	stxa	%r10, [%r24 + 0x0000] %asi
	.word 0x87802072  ! 758: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d8, %r20
	mov	0x0, %r16
	.word 0xd8bc4400  ! 761: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xd6bda000  ! 762: STDA_I	stda	%r11, [%r22 + 0x0000] %asi
	mov	0x38, %r18
	.word 0xd8b7ce60  ! 764: STHA_R	stha	%r12, [%r31 + %r0] 0x73
	.word 0xdc8f8e60  ! 765: LDUBA_R	lduba	[%r30, %r0] 0x73, %r14
	mov	0x38, %r25
	mov	0x30, %r18
	.word 0xdcdda000  ! 768: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r14
	mov	0x48, %r16
	.word 0xdcada000  ! 770: STBA_I	stba	%r14, [%r22 + 0x0000] %asi
	.word 0xdaf44400  ! 771: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0xda970e80  ! 772: LDUHA_R	lduha	[%r28, %r0] 0x74, %r13
	.word 0xd08649e0  ! 773: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r8
	.word 0xd2b649e0  ! 774: STHA_R	stha	%r9, [%r25 + %r0] 0x4f
	.word 0xd2948400  ! 775: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	mov	0x20, %r25
	mov	0x8, %r27
	.word 0xdec52000  ! 778: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r15
	.word 0xdef5e000  ! 779: STXA_I	stxa	%r15, [%r23 + 0x0000] %asi
	.word 0xdea56000  ! 780: STWA_I	stwa	%r15, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 781: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccf4e80  ! 782: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r14
	.word 0xd894c400  ! 783: LDUHA_R	lduha	[%r19, %r0] 0x20, %r12
	.word 0x87802072  ! 784: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7e0, %r22
	.word 0xda9ce000  ! 786: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r13
	.word 0xdab42000  ! 787: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	mov	0x50, %r26
	.word 0xd4ac4400  ! 789: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	mov	0x10, %r19
	.word 0xdadc2000  ! 791: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r13
	.word 0xdaa7ce40  ! 792: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	.word 0xd28f0e40  ! 793: LDUBA_R	lduba	[%r28, %r0] 0x72, %r9
	.word 0x87802072  ! 794: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd88689e0  ! 795: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r12
	.word 0xd4a4a000  ! 796: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xd4c4a000  ! 797: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	.word 0xdcd48400  ! 798: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	.word 0xd0c4e000  ! 799: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	.word 0xd0dc2000  ! 800: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	.word 0xd09f8e60  ! 801: LDDA_R	ldda	[%r30, %r0] 0x73, %r8
	.word 0xd4b46000  ! 802: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 803: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 804: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r26
	.word 0xd4bf6000  ! 806: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0xdc9e89e0  ! 808: LDDA_R	ldda	[%r26, %r0] 0x4f, %r14
	.word 0xd28c0400  ! 809: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	.word 0x87802020  ! 810: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c7a000  ! 811: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xd2a7ce40  ! 812: STWA_R	stwa	%r9, [%r31 + %r0] 0x72
	.word 0xd2d609e0  ! 813: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r9
	.word 0xdeafe000  ! 814: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xdebfa000  ! 815: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xde97a000  ! 816: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	.word 0x87802020  ! 817: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bf0e40  ! 818: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	.word 0xd2afe000  ! 819: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd2dfa000  ! 820: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2b72000  ! 821: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	mov	0x3e0, %r21
	mov	0x0, %r18
	.word 0xd2f7a000  ! 824: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	mov	0x3e8, %r23
	.word 0x87802074  ! 826: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdab70e40  ! 827: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	mov	0x7d8, %r23
	.word 0xdc9fce80  ! 829: LDDA_R	ldda	[%r31, %r0] 0x74, %r14
	.word 0xdcf7a000  ! 830: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x18, %r25
	.word 0xdc8c8400  ! 832: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0x87802074  ! 833: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 834: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 835: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcafe000  ! 836: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdc8504a0  ! 837: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r14
	.word 0xdcf76000  ! 838: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x40, %r19
	.word 0xdcdfe000  ! 840: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xdca76000  ! 841: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdc872000  ! 842: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xd097ce40  ! 843: LDUHA_R	lduha	[%r31, %r0] 0x72, %r8
	.word 0x87802020  ! 844: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r16
	.word 0x87802072  ! 846: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b7ce40  ! 847: STHA_R	stha	%r11, [%r31 + %r0] 0x72
	.word 0xdaa4e000  ! 848: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0x87802074  ! 850: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 851: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r24
	.word 0x87802074  ! 853: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa76000  ! 854: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xdacfa000  ! 855: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	mov	0x7f8, %r23
	.word 0xd0940400  ! 857: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	.word 0xde8c0400  ! 858: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0xd497ce80  ! 859: LDUHA_R	lduha	[%r31, %r0] 0x74, %r10
	.word 0xd8cf2000  ! 860: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	mov	0x18, %r24
	mov	0x68, %r19
	.word 0xd8cf6000  ! 863: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	mov	0x30, %r18
	mov	0x50, %r27
	.word 0x87802020  ! 866: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 867: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b48400  ! 868: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xdeb5a000  ! 869: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	mov	0x8, %r19
	.word 0x87802074  ! 871: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 872: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdedee000  ! 873: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r15
	.word 0xd8c78e60  ! 874: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r12
	.word 0xd0d6c9e0  ! 875: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r8
	.word 0x87802072  ! 876: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcdf8e60  ! 877: LDXA_R	ldxa	[%r30, %r0] 0x73, %r14
	.word 0xd6b76000  ! 878: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd0d7ce40  ! 879: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r8
	.word 0xd6bfa000  ! 880: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0xd6a76000  ! 882: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 883: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 884: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6af2000  ! 885: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd29dc4a0  ! 886: LDDA_R	ldda	[%r23, %r0] 0x25, %r9
	.word 0xd4df6000  ! 887: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	mov	0x70, %r27
	.word 0xd4b72000  ! 889: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd4d48400  ! 890: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	mov	0x48, %r18
	.word 0x87802073  ! 892: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 893: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2878e40  ! 894: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r9
	mov	0x3d8, %r21
	mov	0x18, %r25
	.word 0x87802025  ! 897: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bd04a0  ! 898: STDA_R	stda	%r9, [%r20 + %r0] 0x25
	.word 0x87802073  ! 899: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca46000  ! 900: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xdc946000  ! 901: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r14
	.word 0x87802074  ! 902: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca66000  ! 903: STWA_I	stwa	%r14, [%r25 + 0x0000] %asi
	mov	0x7c0, %r20
	.word 0xdcdee000  ! 905: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r14
	mov	0x78, %r25
	.word 0xdcbe6000  ! 907: STDA_I	stda	%r14, [%r25 + 0x0000] %asi
	mov	0x3c8, %r21
	mov	0x7f8, %r22
	.word 0xdc966000  ! 910: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r14
	.word 0xdef609e0  ! 911: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	mov	0x7d8, %r21
	.word 0x87802020  ! 913: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bce000  ! 914: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 915: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bcc400  ! 916: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0xd2b5a000  ! 917: STHA_I	stha	%r9, [%r22 + 0x0000] %asi
	.word 0xd2b52000  ! 918: STHA_I	stha	%r9, [%r20 + 0x0000] %asi
	.word 0xd2dda000  ! 919: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r9
	.word 0xd28c0400  ! 920: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	.word 0xda856000  ! 921: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r13
	.word 0xd2b78e40  ! 922: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	.word 0xd2ac0400  ! 923: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0x87802073  ! 924: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6a7ce60  ! 925: STWA_R	stwa	%r11, [%r31 + %r0] 0x73
	mov	0x7d0, %r22
	mov	0x78, %r25
	mov	0x48, %r18
	.word 0xd4dea000  ! 929: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	mov	0x3f8, %r22
	.word 0xd4b6e000  ! 931: STHA_I	stha	%r10, [%r27 + 0x0000] %asi
	mov	0x30, %r19
	.word 0xd4c62000  ! 933: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r10
	.word 0xd897ce40  ! 934: LDUHA_R	lduha	[%r31, %r0] 0x72, %r12
	.word 0x87802025  ! 935: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdac74e80  ! 936: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r13
	.word 0x87802020  ! 937: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda86c9e0  ! 938: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r13
	.word 0xd4df0e80  ! 939: LDXA_R	ldxa	[%r28, %r0] 0x74, %r10
	mov	0x38, %r25
	mov	0x3c0, %r22
	mov	0x50, %r25
	mov	0x3f8, %r23
	.word 0xd6c72000  ! 944: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0xd687a000  ! 945: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6df6000  ! 946: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0xdec584a0  ! 947: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r15
	mov	0x30, %r18
	mov	0x28, %r24
	ta	T_CHANGE_PRIV	! macro
	mov	0x38, %r18
	.word 0xd4cf6000  ! 952: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	mov	0x70, %r26
	.word 0x87802020  ! 954: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b70e80  ! 955: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	.word 0x87802074  ! 956: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2d70e60  ! 957: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r9
	mov	0x18, %r24
	.word 0xd4be2000  ! 959: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdcdf8e60  ! 961: LDXA_R	ldxa	[%r30, %r0] 0x73, %r14
	.word 0xd0bea000  ! 962: STDA_I	stda	%r8, [%r26 + 0x0000] %asi
	.word 0xdef4c400  ! 963: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xd4bfce40  ! 964: STDA_R	stda	%r10, [%r31 + %r0] 0x72
	mov	0x30, %r26
	.word 0x87802072  ! 966: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdec42000  ! 967: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	mov	0x70, %r26
	mov	0x18, %r19
	.word 0xde9ce000  ! 970: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0x87802020  ! 971: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9d2000  ! 972: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r15
	.word 0xd8d609e0  ! 973: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r12
	.word 0xdacc8400  ! 974: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r13
	.word 0xd0f5c4a0  ! 975: STXA_R	stxa	%r8, [%r23 + %r0] 0x25
	.word 0xdcd5e000  ! 976: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r14
	.word 0xd6a689e0  ! 977: STWA_R	stwa	%r11, [%r26 + %r0] 0x4f
	.word 0xd8a4c400  ! 978: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xdcbde000  ! 979: STDA_I	stda	%r14, [%r23 + 0x0000] %asi
	.word 0xdccd6000  ! 980: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r14
	.word 0xd6d504a0  ! 981: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r11
	.word 0xd295e000  ! 982: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r9
	.word 0xd4b70e80  ! 983: STHA_R	stha	%r10, [%r28 + %r0] 0x74
	.word 0xdcd74e80  ! 984: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r14
	.word 0xd2f56000  ! 985: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	.word 0xdac4c400  ! 986: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r13
	mov	0x68, %r26
	.word 0xdcf5e000  ! 988: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0xdcce09e0  ! 989: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r14
	.word 0xd8f7ce80  ! 990: STXA_R	stxa	%r12, [%r31 + %r0] 0x74
	.word 0xda8d6000  ! 991: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r13
	.word 0x87802072  ! 992: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r25
	.word 0xdaafa000  ! 994: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 995: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab5a000  ! 996: STHA_I	stha	%r13, [%r22 + 0x0000] %asi
	.word 0xdaac0400  ! 997: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xd4874e40  ! 998: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r10
	.word 0xd4bd2000  ! 999: STDA_I	stda	%r10, [%r20 + 0x0000] %asi
	.word 0xd4bfce60  ! 1000: STDA_R	stda	%r10, [%r31 + %r0] 0x73
	mov	0x20, %r18
	.word 0x87802072  ! 1002: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d0, %r22
	.word 0xd2d4c400  ! 1004: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r9
	.word 0xdcdc8400  ! 1005: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	.word 0xdca74e40  ! 1006: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	.word 0xdcb7e000  ! 1007: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1008: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r19
	.word 0xdcf56000  ! 1010: STXA_I	stxa	%r14, [%r21 + 0x0000] %asi
	.word 0xd6f6c9e0  ! 1011: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	.word 0xd6d5e000  ! 1012: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r11
	.word 0xd6a44400  ! 1013: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0xdcdd2000  ! 1014: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r14
	.word 0xdcb56000  ! 1015: STHA_I	stha	%r14, [%r21 + 0x0000] %asi
	.word 0xdcad2000  ! 1016: STBA_I	stba	%r14, [%r20 + 0x0000] %asi
	.word 0x8780204f  ! 1017: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r26
	.word 0xdcbf2000  ! 1019: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdc87a000  ! 1020: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcdfa000  ! 1021: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	mov	0x48, %r24
	.word 0xdcbf6000  ! 1023: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	mov	0x3d8, %r22
	.word 0xda8e89e0  ! 1025: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r13
	.word 0xdeb649e0  ! 1026: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	.word 0xdccfce80  ! 1027: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r14
	mov	0x60, %r17
	.word 0x8780204f  ! 1029: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 1030: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r17
	.word 0xdcafce40  ! 1032: STBA_R	stba	%r14, [%r31 + %r0] 0x72
	mov	0x20, %r17
	mov	0x40, %r17
	mov	0x30, %r26
	.word 0xd0bfce40  ! 1036: STDA_R	stda	%r8, [%r31 + %r0] 0x72
	.word 0xd684c400  ! 1037: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	mov	0x18, %r19
	mov	0x78, %r19
	.word 0xdcdde000  ! 1040: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	.word 0x87802025  ! 1041: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f78e40  ! 1042: STXA_R	stxa	%r11, [%r30 + %r0] 0x72
	.word 0xde944400  ! 1043: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	.word 0x87802074  ! 1044: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf76000  ! 1045: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdc8f6000  ! 1046: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdab7ce40  ! 1047: STHA_R	stha	%r13, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 1048: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a42000  ! 1049: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8846000  ! 1050: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	.word 0xd884a000  ! 1051: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r12
	.word 0xd8f4a000  ! 1052: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xd4d584a0  ! 1053: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r10
	.word 0xdecc8400  ! 1054: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	.word 0x87802072  ! 1055: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4b62000  ! 1056: STHA_I	stha	%r10, [%r24 + 0x0000] %asi
	.word 0xd4ae2000  ! 1057: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	.word 0xd4b6a000  ! 1058: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	.word 0xd4cea000  ! 1059: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r10
	.word 0xdab74e80  ! 1060: STHA_R	stha	%r13, [%r29 + %r0] 0x74
	.word 0xd0df4e60  ! 1061: LDXA_R	ldxa	[%r29, %r0] 0x73, %r8
	.word 0x87802073  ! 1062: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4cc2000  ! 1063: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1064: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0df4e60  ! 1065: LDXA_R	ldxa	[%r29, %r0] 0x73, %r8
	mov	0x28, %r16
	.word 0xdad4a000  ! 1067: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0xd6a74e40  ! 1068: STWA_R	stwa	%r11, [%r29 + %r0] 0x72
	.word 0xd49c6000  ! 1069: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0x87802072  ! 1070: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcd4c400  ! 1071: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	.word 0xdadd6000  ! 1072: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r13
	mov	0x48, %r16
	.word 0x87802020  ! 1074: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c5c4a0  ! 1075: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r9
	.word 0x8780204f  ! 1076: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 1077: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2de49e0  ! 1078: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r9
	.word 0xdcbf2000  ! 1079: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	mov	0x7c8, %r21
	.word 0xd6b40400  ! 1081: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xdc9649e0  ! 1082: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r14
	.word 0xd2cfce40  ! 1083: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r9
	.word 0xd29d84a0  ! 1084: LDDA_R	ldda	[%r22, %r0] 0x25, %r9
	.word 0xdcbf4e60  ! 1085: STDA_R	stda	%r14, [%r29 + %r0] 0x73
	.word 0xdcc72000  ! 1086: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xdabdc4a0  ! 1087: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	.word 0xd4afce60  ! 1088: STBA_R	stba	%r10, [%r31 + %r0] 0x73
	.word 0xdecf6000  ! 1089: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	mov	0x58, %r26
	.word 0xd0cf0e60  ! 1091: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r8
	.word 0xd4b584a0  ! 1092: STHA_R	stha	%r10, [%r22 + %r0] 0x25
	.word 0xdabfce80  ! 1093: STDA_R	stda	%r13, [%r31 + %r0] 0x74
	mov	0x30, %r18
	.word 0xd4df6000  ! 1095: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0x87802025  ! 1096: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1097: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1098: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4940400  ! 1099: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	mov	0x7c0, %r21
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6b7a000  ! 1102: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1103: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c40400  ! 1104: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r11
	.word 0x87802072  ! 1105: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r17
	.word 0xd8af2000  ! 1107: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 1108: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x3e0, %r22
	.word 0xdeaf0e60  ! 1111: STBA_R	stba	%r15, [%r28 + %r0] 0x73
	mov	0x38, %r17
	.word 0x8780204f  ! 1113: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0bf8e80  ! 1114: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	.word 0x87802074  ! 1115: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4c7ce80  ! 1116: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r10
	.word 0xd8872000  ! 1117: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8c7e000  ! 1118: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8b7a000  ! 1119: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xd89f6000  ! 1120: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	.word 0xd8afa000  ! 1121: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	mov	0x60, %r17
	.word 0xd8d7a000  ! 1123: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0xdab74e40  ! 1124: STHA_R	stha	%r13, [%r29 + %r0] 0x72
	mov	0x10, %r24
	mov	0x68, %r18
	.word 0xdaf74e80  ! 1127: STXA_R	stxa	%r13, [%r29 + %r0] 0x74
	.word 0xdeb70e80  ! 1128: STHA_R	stha	%r15, [%r28 + %r0] 0x74
	.word 0xd48f6000  ! 1129: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xd49f6000  ! 1130: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0xd4b7a000  ! 1131: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	mov	0x68, %r26
	.word 0xd2b689e0  ! 1133: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 1134: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 1135: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r19
	.word 0x87802073  ! 1137: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd487e000  ! 1138: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4af6000  ! 1139: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	mov	0x38, %r19
	mov	0x7e8, %r22
	.word 0xda9689e0  ! 1142: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r13
	.word 0xdeaf4e60  ! 1143: STBA_R	stba	%r15, [%r29 + %r0] 0x73
	.word 0xd6be49e0  ! 1144: STDA_R	stda	%r11, [%r25 + %r0] 0x4f
	.word 0xda9649e0  ! 1145: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r13
	mov	0x7e8, %r21
	.word 0xd6af8e80  ! 1147: STBA_R	stba	%r11, [%r30 + %r0] 0x74
	.word 0xdc9fe000  ! 1148: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xdcb76000  ! 1149: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xd6f78e60  ! 1150: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	mov	0x18, %r25
	.word 0x87802073  ! 1152: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b76000  ! 1153: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd49f2000  ! 1154: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x50, %r17
	mov	0x48, %r17
	mov	0x48, %r24
	.word 0xd49fe000  ! 1159: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0x87802073  ! 1160: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4be6000  ! 1161: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0xd4c6a000  ! 1162: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r10
	.word 0xd28504a0  ! 1163: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r9
	.word 0x87802072  ! 1164: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f0, %r23
	mov	0x78, %r17
	.word 0xd29fa000  ! 1167: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd2a7e000  ! 1168: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xd4f504a0  ! 1169: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0x8780204f  ! 1170: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd08dc4a0  ! 1171: LDUBA_R	lduba	[%r23, %r0] 0x25, %r8
	mov	0x7c0, %r20
	mov	0x28, %r19
	.word 0xd697ce60  ! 1174: LDUHA_R	lduha	[%r31, %r0] 0x73, %r11
	.word 0xd4c76000  ! 1175: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	.word 0xdeac8400  ! 1176: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 1177: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r25
	.word 0xd6c44400  ! 1179: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r11
	.word 0xd6bca000  ! 1180: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	.word 0xd6bc2000  ! 1181: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0xd6b46000  ! 1182: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd6946000  ! 1183: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r11
	mov	0x28, %r16
	mov	0x30, %r18
	.word 0xd6bc2000  ! 1186: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0xd6946000  ! 1187: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r11
	.word 0xd6d4a000  ! 1188: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r11
	.word 0xdaf70e60  ! 1189: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	.word 0xdac46000  ! 1190: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r13
	.word 0xdaf4e000  ! 1191: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xdabca000  ! 1192: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0xdad46000  ! 1194: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	.word 0x87802074  ! 1195: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde978e60  ! 1196: LDUHA_R	lduha	[%r30, %r0] 0x73, %r15
	.word 0xd8ae6000  ! 1197: STBA_I	stba	%r12, [%r25 + 0x0000] %asi
	mov	0x48, %r24
	.word 0x87802025  ! 1199: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8aea000  ! 1200: STBA_I	stba	%r12, [%r26 + 0x0000] %asi
	.word 0xd6848400  ! 1201: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	.word 0xda8ee000  ! 1202: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r13
	mov	0x10, %r27
	.word 0xd0cf8e40  ! 1204: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r8
	.word 0xd6bee000  ! 1205: STDA_I	stda	%r11, [%r27 + 0x0000] %asi
	.word 0xda940400  ! 1206: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	mov	0x3f8, %r22
	.word 0xd0c66000  ! 1208: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 1209: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 1210: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd29dc4a0  ! 1211: LDDA_R	ldda	[%r23, %r0] 0x25, %r9
	.word 0x87802072  ! 1212: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f0, %r22
	.word 0xdecce000  ! 1214: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	.word 0xd2c70e60  ! 1215: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r9
	.word 0x87802020  ! 1216: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1217: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r16
	.word 0xdaf40400  ! 1219: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xd6a609e0  ! 1220: STWA_R	stwa	%r11, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 1221: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dd04a0  ! 1222: LDXA_R	ldxa	[%r20, %r0] 0x25, %r9
	.word 0xd2de49e0  ! 1223: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r9
	mov	0x68, %r24
	.word 0xdc9fe000  ! 1225: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xd6ac4400  ! 1226: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	mov	0x7d0, %r22
	.word 0xdcf7e000  ! 1228: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xd6d74e80  ! 1229: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r11
	.word 0xd4af0e40  ! 1230: STBA_R	stba	%r10, [%r28 + %r0] 0x72
	.word 0x87802072  ! 1231: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r19
	.word 0x87802072  ! 1233: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6bf6000  ! 1234: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	mov	0x30, %r26
	mov	0x78, %r19
	mov	0x68, %r17
	mov	0x7d8, %r22
	.word 0xd69f6000  ! 1239: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	.word 0xd69f2000  ! 1240: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xd8de49e0  ! 1241: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r12
	.word 0xd2dc8400  ! 1242: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0x87802025  ! 1243: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4d46000  ! 1244: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 1245: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d0, %r20
	.word 0xd4bca000  ! 1247: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0x87802073  ! 1249: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r19
	.word 0xd29c4400  ! 1251: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	.word 0xd4d76000  ! 1252: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0xd4afe000  ! 1253: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xde8fce60  ! 1254: LDUBA_R	lduba	[%r31, %r0] 0x73, %r15
	mov	0x7f8, %r20
	.word 0xdab44400  ! 1256: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0x87802072  ! 1257: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b7e000  ! 1258: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	mov	0x7c0, %r20
	.word 0xd8a40400  ! 1260: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	mov	0x3d8, %r20
	mov	0x7c0, %r23
	.word 0xdccf2000  ! 1263: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xdcbf6000  ! 1264: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 1265: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabcc400  ! 1266: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	mov	0x7d0, %r22
	.word 0x8780204f  ! 1268: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdef649e0  ! 1269: STXA_R	stxa	%r15, [%r25 + %r0] 0x4f
	mov	0x7c0, %r22
	.word 0xd495e000  ! 1271: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r10
	.word 0x87802072  ! 1272: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8f7ce80  ! 1273: STXA_R	stxa	%r12, [%r31 + %r0] 0x74
	mov	0x78, %r17
	mov	0x7c0, %r20
	mov	0x40, %r16
	.word 0xd6af2000  ! 1277: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd6cf6000  ! 1278: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	mov	0x68, %r26
	.word 0xd884c400  ! 1280: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	.word 0xdca7e000  ! 1281: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xd4ac8400  ! 1282: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0xd8a6c9e0  ! 1283: STWA_R	stwa	%r12, [%r27 + %r0] 0x4f
	.word 0xdabfe000  ! 1284: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xd0bcc400  ! 1285: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	mov	0x68, %r24
	mov	0x68, %r26
	.word 0x87802074  ! 1288: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r19
	mov	0x10, %r27
	.word 0xd486e000  ! 1291: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	.word 0xd8dc8400  ! 1292: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xd2f584a0  ! 1293: STXA_R	stxa	%r9, [%r22 + %r0] 0x25
	.word 0xd0de2000  ! 1294: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r8
	.word 0xdea7ce40  ! 1295: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	.word 0x87802072  ! 1296: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd69fce80  ! 1297: LDDA_R	ldda	[%r31, %r0] 0x74, %r11
	.word 0xd6f4c400  ! 1298: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	mov	0x40, %r17
	mov	0x70, %r25
	.word 0xdeb40400  ! 1301: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0x87802020  ! 1302: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d544a0  ! 1303: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r11
	.word 0xd0874e80  ! 1304: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r8
	.word 0xdeac2000  ! 1305: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	mov	0x7f0, %r21
	mov	0x7e8, %r23
	.word 0xdeb42000  ! 1308: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xd4dfce60  ! 1310: LDXA_R	ldxa	[%r31, %r0] 0x73, %r10
	.word 0xd2f4e000  ! 1311: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2ac6000  ! 1312: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd2942000  ! 1313: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2c46000  ! 1314: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	mov	0x8, %r18
	.word 0xd2c4a000  ! 1316: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	.word 0xd8b78e60  ! 1317: STHA_R	stha	%r12, [%r30 + %r0] 0x73
	.word 0xdc86c9e0  ! 1318: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r14
	.word 0x87802025  ! 1319: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1320: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b40400  ! 1321: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0xd4b66000  ! 1322: STHA_I	stha	%r10, [%r25 + 0x0000] %asi
	.word 0xdecc8400  ! 1323: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	.word 0xd2844400  ! 1324: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	mov	0x48, %r17
	.word 0xd2a689e0  ! 1326: STWA_R	stwa	%r9, [%r26 + %r0] 0x4f
	.word 0xde87ce40  ! 1327: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r15
	mov	0x7d0, %r22
	.word 0xd2874e80  ! 1329: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r9
	.word 0x87802073  ! 1330: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xded689e0  ! 1331: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r15
	.word 0xdcf7ce60  ! 1332: STXA_R	stxa	%r14, [%r31 + %r0] 0x73
	.word 0xd0cce000  ! 1333: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1334: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cfe000  ! 1335: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xd0a7e000  ! 1336: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0b76000  ! 1337: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xd0cf6000  ! 1339: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd0f72000  ! 1340: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xdabf0e60  ! 1341: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	.word 0xd4d7a000  ! 1342: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	mov	0x3d0, %r22
	mov	0x68, %r26
	.word 0xd8af8e80  ! 1345: STBA_R	stba	%r12, [%r30 + %r0] 0x74
	.word 0xdaaf6000  ! 1346: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xd2bfce40  ! 1347: STDA_R	stda	%r9, [%r31 + %r0] 0x72
	.word 0xd29f6000  ! 1348: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xd0ac4400  ! 1349: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0x87802025  ! 1350: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4f62000  ! 1351: STXA_I	stxa	%r10, [%r24 + 0x0000] %asi
	mov	0x70, %r17
	.word 0x87802020  ! 1353: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r21
	.word 0x87802020  ! 1355: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ce49e0  ! 1356: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r12
	mov	0x3d0, %r20
	.word 0xdc8689e0  ! 1358: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r14
	mov	0x0, %r27
	.word 0xde86c9e0  ! 1360: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r15
	.word 0xdabe09e0  ! 1361: STDA_R	stda	%r13, [%r24 + %r0] 0x4f
	.word 0xd4df6000  ! 1362: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4bf6000  ! 1363: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 1364: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 1365: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cf6000  ! 1366: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0x87802072  ! 1367: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef7ce40  ! 1368: STXA_R	stxa	%r15, [%r31 + %r0] 0x72
	.word 0x87802020  ! 1369: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r18
	.word 0xd28c2000  ! 1371: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	mov	0x7d8, %r23
	mov	0x7d8, %r21
	.word 0xd2b4e000  ! 1374: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0xd2bc6000  ! 1375: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0xd2f42000  ! 1376: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 1377: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2c44400  ! 1378: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	.word 0xd2c76000  ! 1379: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0x87802073  ! 1380: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd29ca000  ! 1381: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	.word 0xd284a000  ! 1382: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	.word 0xd4cf0e80  ! 1383: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r10
	.word 0x87802025  ! 1384: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f8, %r20
	.word 0x8780204f  ! 1386: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 1387: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 1388: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8c78e60  ! 1389: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r12
	.word 0x87802074  ! 1390: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 1391: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaad04a0  ! 1392: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	.word 0xdebf8e40  ! 1393: STDA_R	stda	%r15, [%r30 + %r0] 0x72
	.word 0xdac72000  ! 1394: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	mov	0x48, %r19
	.word 0xdacf2000  ! 1396: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	mov	0x0, %r25
	.word 0x87802073  ! 1398: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa689e0  ! 1399: STWA_R	stwa	%r13, [%r26 + %r0] 0x4f
	.word 0xdef7e000  ! 1400: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1401: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea4a000  ! 1402: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	mov	0x38, %r19
	.word 0xdebc2000  ! 1404: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xd0c7ce60  ! 1405: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r8
	.word 0xd6f4e000  ! 1406: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xd0a74e40  ! 1408: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	.word 0xdc878e40  ! 1409: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r14
	.word 0xd4d4a000  ! 1410: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	mov	0x78, %r25
	.word 0xdcb7ce40  ! 1412: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 1413: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2c72000  ! 1414: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2af6000  ! 1415: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1416: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r16
	.word 0xdcad84a0  ! 1418: STBA_R	stba	%r14, [%r22 + %r0] 0x25
	.word 0x87802072  ! 1419: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f8, %r22
	mov	0x10, %r24
	.word 0xd69fa000  ! 1422: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	mov	0x20, %r19
	.word 0xd68fa000  ! 1424: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0xd0878e80  ! 1425: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r8
	.word 0x87802072  ! 1426: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0cc2000  ! 1427: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	.word 0xd094e000  ! 1428: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0xd0846000  ! 1429: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0xd8be49e0  ! 1430: STDA_R	stda	%r12, [%r25 + %r0] 0x4f
	.word 0xd69c6000  ! 1431: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r11
	.word 0xd6842000  ! 1432: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r11
	mov	0x10, %r19
	mov	0x7c8, %r21
	mov	0x58, %r26
	mov	0x10, %r25
	mov	0x40, %r26
	mov	0x20, %r17
	.word 0xd6f4e000  ! 1439: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 1440: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b7e000  ! 1441: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd2b40400  ! 1442: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0x87802020  ! 1443: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef7a000  ! 1444: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	mov	0x78, %r24
	mov	0x8, %r19
	.word 0xde8fa000  ! 1447: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0x87802020  ! 1448: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb46000  ! 1449: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0xdec42000  ! 1450: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0xdef4e000  ! 1451: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xde842000  ! 1452: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	mov	0x68, %r26
	.word 0xdedca000  ! 1454: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xd4c609e0  ! 1455: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r10
	.word 0x8780204f  ! 1456: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d8, %r20
	.word 0xdcd7e000  ! 1458: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xd2d70e40  ! 1459: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r9
	.word 0xd6bf4e60  ! 1460: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	.word 0xd0afa000  ! 1461: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd2c44400  ! 1462: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	.word 0xd094c400  ! 1463: LDUHA_R	lduha	[%r19, %r0] 0x20, %r8
	.word 0xd2f649e0  ! 1464: STXA_R	stxa	%r9, [%r25 + %r0] 0x4f
	.word 0xdebf8e60  ! 1465: STDA_R	stda	%r15, [%r30 + %r0] 0x73
	mov	0x50, %r27
	mov	0x0, %r24
	.word 0xdcc72000  ! 1468: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcdf2000  ! 1469: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcf7e000  ! 1470: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xd4df0e80  ! 1471: LDXA_R	ldxa	[%r28, %r0] 0x74, %r10
	.word 0xd8af2000  ! 1472: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xd89fe000  ! 1473: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0xdca78e40  ! 1474: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	.word 0xd6c40400  ! 1475: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r11
	.word 0xde9c0400  ! 1476: LDDA_R	ldda	[%r16, %r0] 0x20, %r15
	.word 0xdeb72000  ! 1477: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xd8874e80  ! 1478: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r12
	.word 0xd4bfa000  ! 1479: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 1480: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 1481: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r24
	.word 0xd4af2000  ! 1483: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd48f2000  ! 1484: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	mov	0x3e8, %r22
	mov	0x8, %r19
	.word 0xd4a7a000  ! 1487: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xdca7ce40  ! 1488: STWA_R	stwa	%r14, [%r31 + %r0] 0x72
	.word 0xdaf70e80  ! 1489: STXA_R	stxa	%r13, [%r28 + %r0] 0x74
	.word 0xd09f8e60  ! 1490: LDDA_R	ldda	[%r30, %r0] 0x73, %r8
	.word 0x87802025  ! 1491: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f76000  ! 1492: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0bf6000  ! 1493: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 1494: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a7e000  ! 1495: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xd4f70e80  ! 1496: STXA_R	stxa	%r10, [%r28 + %r0] 0x74
	.word 0xd69f6000  ! 1497: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	.word 0xdebf8e60  ! 1498: STDA_R	stda	%r15, [%r30 + %r0] 0x73
	.word 0xd0d7ce80  ! 1499: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r8
	mov	0x7c8, %r22
	.word 0x87802020  ! 1501: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ada000  ! 1502: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xd8df8e40  ! 1504: LDXA_R	ldxa	[%r30, %r0] 0x72, %r12
	mov	0x50, %r26
	.word 0x87802074  ! 1506: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f76000  ! 1507: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 1508: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e8, %r22
	.word 0xdade09e0  ! 1510: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r13
	.word 0x87802074  ! 1511: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8ae89e0  ! 1512: STBA_R	stba	%r12, [%r26 + %r0] 0x4f
	mov	0x3e0, %r22
	.word 0xdca4a000  ! 1514: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcc48400  ! 1515: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r14
	.word 0xd48ce000  ! 1516: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r10
	.word 0xd89f8e80  ! 1517: LDDA_R	ldda	[%r30, %r0] 0x74, %r12
	.word 0xd08fce40  ! 1518: LDUBA_R	lduba	[%r31, %r0] 0x72, %r8
	.word 0xde84e000  ! 1519: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	.word 0xdc944400  ! 1520: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	.word 0xdef46000  ! 1521: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xde8ca000  ! 1522: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	mov	0x10, %r25
	.word 0x87802020  ! 1524: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r21
	.word 0xdef6a000  ! 1526: STXA_I	stxa	%r15, [%r26 + 0x0000] %asi
	.word 0xde86e000  ! 1527: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r15
	.word 0xdcb74e80  ! 1528: STHA_R	stha	%r14, [%r29 + %r0] 0x74
	.word 0xde86e000  ! 1529: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r15
	.word 0xd2a40400  ! 1530: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xdeb6e000  ! 1531: STHA_I	stha	%r15, [%r27 + 0x0000] %asi
	mov	0x40, %r17
	.word 0xdede6000  ! 1533: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r15
	mov	0x28, %r27
	.word 0xdeae6000  ! 1535: STBA_I	stba	%r15, [%r25 + 0x0000] %asi
	.word 0xdcb6c9e0  ! 1536: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	.word 0xdedf4e40  ! 1537: LDXA_R	ldxa	[%r29, %r0] 0x72, %r15
	.word 0xd2af0e80  ! 1538: STBA_R	stba	%r9, [%r28 + %r0] 0x74
	.word 0xd28ea000  ! 1539: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r9
	.word 0xdca544a0  ! 1540: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0xd8a62000  ! 1541: STWA_I	stwa	%r12, [%r24 + 0x0000] %asi
	mov	0x28, %r25
	mov	0x38, %r25
	.word 0xd4b40400  ! 1544: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0xd8ae6000  ! 1545: STBA_I	stba	%r12, [%r25 + 0x0000] %asi
	.word 0x8780204f  ! 1546: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xded7ce40  ! 1547: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r15
	.word 0xdabea000  ! 1548: STDA_I	stda	%r13, [%r26 + 0x0000] %asi
	.word 0xda96e000  ! 1549: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r13
	.word 0xdaf62000  ! 1550: STXA_I	stxa	%r13, [%r24 + 0x0000] %asi
	.word 0xd8bf8e80  ! 1551: STDA_R	stda	%r12, [%r30 + %r0] 0x74
	.word 0xd2f66000  ! 1552: STXA_I	stxa	%r9, [%r25 + 0x0000] %asi
	.word 0xd0c74e40  ! 1553: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r8
	.word 0xdcce2000  ! 1554: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r14
	.word 0xdea44400  ! 1555: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xd4f66000  ! 1556: STXA_I	stxa	%r10, [%r25 + 0x0000] %asi
	mov	0x3f0, %r21
	.word 0xd4b74e60  ! 1558: STHA_R	stha	%r10, [%r29 + %r0] 0x73
	.word 0xd4b649e0  ! 1559: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	.word 0xdcf70e40  ! 1560: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	.word 0xd0ae6000  ! 1561: STBA_I	stba	%r8, [%r25 + 0x0000] %asi
	mov	0x40, %r25
	mov	0x7e0, %r23
	mov	0x68, %r16
	.word 0xdcc504a0  ! 1565: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r14
	mov	0x30, %r24
	.word 0xd2a70e60  ! 1567: STWA_R	stwa	%r9, [%r28 + %r0] 0x73
	mov	0x38, %r19
	mov	0x8, %r16
	.word 0xdcce6000  ! 1570: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r14
	.word 0x87802020  ! 1571: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd284c400  ! 1572: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r9
	mov	0x78, %r16
	.word 0xdeae09e0  ! 1574: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	.word 0xd2ad04a0  ! 1575: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	.word 0x87802074  ! 1576: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4bc0400  ! 1577: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xd88609e0  ! 1578: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r12
	.word 0x87802020  ! 1579: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac52000  ! 1580: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 1581: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 1582: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r26
	mov	0x20, %r25
	.word 0x8780204f  ! 1585: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f0, %r22
	.word 0xd2d74e80  ! 1587: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r9
	.word 0xdaf7e000  ! 1588: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	mov	0x3c0, %r20
	.word 0xd8c504a0  ! 1590: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r12
	.word 0xdcf76000  ! 1591: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdc97a000  ! 1592: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	.word 0xdcaf6000  ! 1593: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xd0dd44a0  ! 1594: LDXA_R	ldxa	[%r21, %r0] 0x25, %r8
	.word 0x87802074  ! 1595: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcc70e80  ! 1596: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r14
	.word 0xd4b584a0  ! 1597: STHA_R	stha	%r10, [%r22 + %r0] 0x25
	.word 0x8780204f  ! 1598: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r18
	mov	0x7c0, %r21
	.word 0xdab584a0  ! 1601: STHA_R	stha	%r13, [%r22 + %r0] 0x25
	.word 0xd0a70e40  ! 1602: STWA_R	stwa	%r8, [%r28 + %r0] 0x72
	mov	0x30, %r19
	.word 0xd085e000  ! 1604: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r8
	.word 0xd6ac4400  ! 1605: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0x87802072  ! 1606: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0cf2000  ! 1607: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	mov	0x7c0, %r21
	mov	0x60, %r24
	.word 0xd0f7e000  ! 1610: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd49d84a0  ! 1611: LDDA_R	ldda	[%r22, %r0] 0x25, %r10
	.word 0xdab72000  ! 1612: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdab7e000  ! 1613: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xd8cf0e40  ! 1614: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r12
	.word 0xdccd84a0  ! 1615: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r14
	.word 0xdcaec9e0  ! 1616: STBA_R	stba	%r14, [%r27 + %r0] 0x4f
	mov	0x3e8, %r22
	.word 0xdacd44a0  ! 1618: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r13
	.word 0xd4bf2000  ! 1619: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd28c0400  ! 1620: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	.word 0xd0f7a000  ! 1621: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd2a7ce80  ! 1622: STWA_R	stwa	%r9, [%r31 + %r0] 0x74
	.word 0x87802020  ! 1623: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r27
	.word 0x87802074  ! 1625: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6878e60  ! 1626: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r11
	mov	0x3d8, %r23
	.word 0x87802020  ! 1628: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea74e80  ! 1629: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	.word 0xd484a000  ! 1630: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1631: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4afe000  ! 1632: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd68f0e40  ! 1633: LDUBA_R	lduba	[%r28, %r0] 0x72, %r11
	mov	0x7c8, %r20
	mov	0x68, %r27
	mov	0x60, %r25
	.word 0xd8bf6000  ! 1637: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd8cfe000  ! 1638: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8c7a000  ! 1639: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802025  ! 1641: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r26
	.word 0x87802025  ! 1643: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8946000  ! 1644: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	.word 0xd894e000  ! 1645: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r12
	mov	0x50, %r26
	.word 0xd6b74e40  ! 1647: STHA_R	stha	%r11, [%r29 + %r0] 0x72
	.word 0x87802025  ! 1648: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebea000  ! 1649: STDA_I	stda	%r15, [%r26 + 0x0000] %asi
	mov	0x3f0, %r23
	.word 0xdcbc4400  ! 1651: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	mov	0x78, %r19
	.word 0xd08c8400  ! 1653: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	mov	0x50, %r19
	.word 0xd4ce2000  ! 1655: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r10
	.word 0xd4bea000  ! 1656: STDA_I	stda	%r10, [%r26 + 0x0000] %asi
	.word 0xd69fce60  ! 1657: LDDA_R	ldda	[%r31, %r0] 0x73, %r11
	mov	0x60, %r24
	mov	0x3c0, %r21
	.word 0x87802072  ! 1660: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef44400  ! 1661: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xd68584a0  ! 1662: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r11
	.word 0x87802025  ! 1663: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x10, %r16
	.word 0xd6bc4400  ! 1666: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	.word 0xdabe2000  ! 1667: STDA_I	stda	%r13, [%r24 + 0x0000] %asi
	mov	0x60, %r17
	mov	0x7c8, %r23
	.word 0xdcb4c400  ! 1670: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xdc96a000  ! 1671: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r14
	.word 0xdcb6e000  ! 1672: STHA_I	stha	%r14, [%r27 + 0x0000] %asi
	mov	0x30, %r19
	.word 0xdcbee000  ! 1674: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	.word 0xdcce6000  ! 1675: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r14
	mov	0x78, %r16
	.word 0x87802074  ! 1677: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2c44400  ! 1678: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	.word 0xdeb72000  ! 1679: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 1680: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb72000  ! 1681: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xd6a5c4a0  ! 1682: STWA_R	stwa	%r11, [%r23 + %r0] 0x25
	.word 0x87802072  ! 1683: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2d48400  ! 1684: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	.word 0x87802020  ! 1685: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcc544a0  ! 1686: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r14
	mov	0x8, %r25
	.word 0x8780204f  ! 1688: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8f48400  ! 1689: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xdeaf8e60  ! 1690: STBA_R	stba	%r15, [%r30 + %r0] 0x73
	mov	0x58, %r18
	.word 0xd4bf4e40  ! 1692: STDA_R	stda	%r10, [%r29 + %r0] 0x72
	mov	0x8, %r16
	.word 0x87802025  ! 1694: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1695: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f62000  ! 1696: STXA_I	stxa	%r8, [%r24 + 0x0000] %asi
	.word 0xdcb7ce60  ! 1697: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	.word 0x87802073  ! 1698: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda9ee000  ! 1699: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r13
	.word 0xd8a7ce80  ! 1700: STWA_R	stwa	%r12, [%r31 + %r0] 0x74
	.word 0xd4d6e000  ! 1701: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r10
	.word 0xd4bfce40  ! 1702: STDA_R	stda	%r10, [%r31 + %r0] 0x72
	.word 0xdca7ce80  ! 1703: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	.word 0xd6b544a0  ! 1704: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	mov	0x28, %r27
	mov	0x18, %r26
	.word 0xda9e6000  ! 1707: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r13
	.word 0x87802073  ! 1708: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r17
	.word 0xdaa4a000  ! 1710: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xdabca000  ! 1711: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdabce000  ! 1712: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 1713: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4af4e80  ! 1714: STBA_R	stba	%r10, [%r29 + %r0] 0x74
	.word 0xd88c0400  ! 1715: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	.word 0xdcb40400  ! 1716: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xdcdc6000  ! 1717: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	.word 0xd88ec9e0  ! 1718: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r12
	.word 0xd48f4e40  ! 1719: LDUBA_R	lduba	[%r29, %r0] 0x72, %r10
	.word 0xd0a46000  ! 1720: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 1721: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0bf0e80  ! 1722: STDA_R	stda	%r8, [%r28 + %r0] 0x74
	mov	0x30, %r26
	mov	0x28, %r19
	.word 0xd8c46000  ! 1725: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r12
	.word 0xd8d4a000  ! 1726: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xdc9649e0  ! 1727: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r14
	.word 0xd6b74e60  ! 1728: STHA_R	stha	%r11, [%r29 + %r0] 0x73
	.word 0xd4cc2000  ! 1729: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	.word 0xd484e000  ! 1730: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r10
	.word 0xd49f0e80  ! 1731: LDDA_R	ldda	[%r28, %r0] 0x74, %r10
	.word 0x87802020  ! 1732: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab78e40  ! 1733: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	.word 0xdcb7a000  ! 1734: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xd4bfce40  ! 1735: STDA_R	stda	%r10, [%r31 + %r0] 0x72
	.word 0xd0f7a000  ! 1736: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0afa000  ! 1737: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	mov	0x7f8, %r22
	.word 0xd0afe000  ! 1739: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd4a40400  ! 1740: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	.word 0xd894c400  ! 1741: LDUHA_R	lduha	[%r19, %r0] 0x20, %r12
	.word 0x87802025  ! 1742: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f8, %r20
	.word 0xd8f584a0  ! 1744: STXA_R	stxa	%r12, [%r22 + %r0] 0x25
	.word 0xd88544a0  ! 1745: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r12
	.word 0xdcb74e60  ! 1746: STHA_R	stha	%r14, [%r29 + %r0] 0x73
	.word 0xde8c0400  ! 1747: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0xdecd2000  ! 1748: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r15
	.word 0xdeb5e000  ! 1749: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	.word 0xd0f48400  ! 1750: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xda852000  ! 1751: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r13
	.word 0xd4a78e60  ! 1752: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	.word 0xd68d2000  ! 1753: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r11
	.word 0xd6a56000  ! 1754: STWA_I	stwa	%r11, [%r21 + 0x0000] %asi
	.word 0xdece09e0  ! 1755: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r15
	.word 0xd4a74e80  ! 1756: STWA_R	stwa	%r10, [%r29 + %r0] 0x74
	mov	0x70, %r24
	.word 0xda8d6000  ! 1758: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r13
	.word 0x87802025  ! 1759: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4bcc400  ! 1760: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	mov	0x28, %r27
	.word 0x8780204f  ! 1762: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 1763: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 1764: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdadc8400  ! 1765: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	.word 0xd4a42000  ! 1766: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0xd4bf8e80  ! 1767: STDA_R	stda	%r10, [%r30 + %r0] 0x74
	.word 0xd68d04a0  ! 1768: LDUBA_R	lduba	[%r20, %r0] 0x25, %r11
	.word 0x87802072  ! 1769: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4af2000  ! 1770: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xded584a0  ! 1771: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r15
	mov	0x50, %r27
	.word 0xd8f7ce60  ! 1773: STXA_R	stxa	%r12, [%r31 + %r0] 0x73
	.word 0xdec7e000  ! 1774: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xd2a48400  ! 1775: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0xdca7a000  ! 1776: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	mov	0x60, %r26
	.word 0xd09ec9e0  ! 1778: LDDA_R	ldda	[%r27, %r0] 0x4f, %r8
	.word 0x87802073  ! 1779: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 1780: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4840400  ! 1781: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	mov	0x30, %r24
	mov	0x50, %r26
	.word 0xdacf0e80  ! 1784: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r13
	.word 0x8780204f  ! 1785: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b544a0  ! 1786: STHA_R	stha	%r12, [%r21 + %r0] 0x25
	.word 0xd0d78e40  ! 1787: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r8
	.word 0xd2b52000  ! 1788: STHA_I	stha	%r9, [%r20 + 0x0000] %asi
	.word 0xdad70e60  ! 1789: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r13
	.word 0xd0d44400  ! 1790: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r8
	.word 0xd4bda000  ! 1791: STDA_I	stda	%r10, [%r22 + 0x0000] %asi
	mov	0x70, %r25
	.word 0xd4cd6000  ! 1793: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r10
	.word 0x87802074  ! 1794: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd48ce000  ! 1795: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r10
	.word 0xd4aca000  ! 1796: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0xd4dc2000  ! 1797: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r10
	.word 0xdc9649e0  ! 1798: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r14
	mov	0x68, %r26
	.word 0xdec4a000  ! 1800: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xde9ce000  ! 1801: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0xdef4e000  ! 1802: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xded4a000  ! 1803: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	.word 0xde8c2000  ! 1804: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	.word 0xdecc2000  ! 1805: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	mov	0x60, %r18
	.word 0x87802020  ! 1807: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebda000  ! 1808: STDA_I	stda	%r15, [%r22 + 0x0000] %asi
	.word 0xd8f5c4a0  ! 1809: STXA_R	stxa	%r12, [%r23 + %r0] 0x25
	.word 0xdac70e80  ! 1810: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r13
	.word 0x87802074  ! 1811: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdeb6e000  ! 1813: STHA_I	stha	%r15, [%r27 + 0x0000] %asi
	.word 0x87802025  ! 1814: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2970e60  ! 1815: LDUHA_R	lduha	[%r28, %r0] 0x73, %r9
	.word 0xdcac6000  ! 1816: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	mov	0x68, %r25
	.word 0xd6bc8400  ! 1818: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0x87802020  ! 1819: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ae89e0  ! 1820: STBA_R	stba	%r12, [%r26 + %r0] 0x4f
	.word 0xd0bc8400  ! 1821: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0xdedf0e80  ! 1822: LDXA_R	ldxa	[%r28, %r0] 0x74, %r15
	.word 0xd6cf0e80  ! 1823: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r11
	.word 0x87802072  ! 1824: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a689e0  ! 1825: STWA_R	stwa	%r12, [%r26 + %r0] 0x4f
	mov	0x7e8, %r21
	.word 0xd6bf0e60  ! 1827: STDA_R	stda	%r11, [%r28 + %r0] 0x73
	.word 0xdcc66000  ! 1828: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	.word 0xd0978e40  ! 1829: LDUHA_R	lduha	[%r30, %r0] 0x72, %r8
	mov	0x68, %r25
	.word 0xdaf6a000  ! 1831: STXA_I	stxa	%r13, [%r26 + 0x0000] %asi
	.word 0xd0b74e40  ! 1832: STHA_R	stha	%r8, [%r29 + %r0] 0x72
	.word 0xd6a4c400  ! 1833: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0xdcdf8e40  ! 1834: LDXA_R	ldxa	[%r30, %r0] 0x72, %r14
	.word 0x87802072  ! 1835: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0bd04a0  ! 1836: STDA_R	stda	%r8, [%r20 + %r0] 0x25
	mov	0x3f0, %r23
	mov	0x3c0, %r22
	.word 0xdcbfe000  ! 1839: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdcb72000  ! 1840: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 1841: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf5e000  ! 1842: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	mov	0x60, %r19
	mov	0x58, %r19
	.word 0x87802072  ! 1845: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7c0, %r21
	.word 0xdcf46000  ! 1847: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdca46000  ! 1848: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xdc84e000  ! 1849: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r14
	.word 0xd4c44400  ! 1850: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r10
	.word 0xd4d4e000  ! 1851: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0xd69f4e40  ! 1852: LDDA_R	ldda	[%r29, %r0] 0x72, %r11
	.word 0xdebce000  ! 1853: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xdecc6000  ! 1854: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r15
	mov	0x3d8, %r23
	.word 0x87802074  ! 1856: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 1857: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r24
	.word 0xdc9c8400  ! 1859: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0xd09689e0  ! 1860: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r8
	.word 0x87802025  ! 1861: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6afce40  ! 1862: STBA_R	stba	%r11, [%r31 + %r0] 0x72
	.word 0xdcac4400  ! 1863: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	.word 0xde862000  ! 1864: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r15
	.word 0xdecea000  ! 1865: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r15
	.word 0xdec6e000  ! 1866: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r15
	mov	0x3d0, %r21
	.word 0xd4cf8e40  ! 1868: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r10
	.word 0xdaaea000  ! 1869: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	.word 0xdcadc4a0  ! 1870: STBA_R	stba	%r14, [%r23 + %r0] 0x25
	.word 0xdebee000  ! 1871: STDA_I	stda	%r15, [%r27 + 0x0000] %asi
	.word 0xd8c78e40  ! 1872: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r12
	.word 0xd2adc4a0  ! 1873: STBA_R	stba	%r9, [%r23 + %r0] 0x25
	.word 0xd8bc8400  ! 1874: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xd09d44a0  ! 1875: LDDA_R	ldda	[%r21, %r0] 0x25, %r8
	.word 0x87802020  ! 1876: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1877: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0c5c4a0  ! 1878: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r8
	.word 0xd6f72000  ! 1879: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6d7e000  ! 1880: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	.word 0xd6af2000  ! 1881: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd6df2000  ! 1882: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	mov	0x20, %r25
	mov	0x38, %r18
	mov	0x28, %r26
	.word 0xd6bfe000  ! 1886: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd6df8e60  ! 1887: LDXA_R	ldxa	[%r30, %r0] 0x73, %r11
	.word 0x87802020  ! 1888: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r17
	.word 0xdcac2000  ! 1890: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0xdcb74e40  ! 1891: STHA_R	stha	%r14, [%r29 + %r0] 0x72
	.word 0xdcac6000  ! 1892: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xdcbc6000  ! 1893: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xdaf70e60  ! 1894: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	.word 0xdcc4e000  ! 1895: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r14
	.word 0x87802074  ! 1896: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf76000  ! 1897: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdccfe000  ! 1898: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xd69d84a0  ! 1899: LDDA_R	ldda	[%r22, %r0] 0x25, %r11
	.word 0xd6b76000  ! 1900: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd297ce60  ! 1901: LDUHA_R	lduha	[%r31, %r0] 0x73, %r9
	.word 0xdc872000  ! 1902: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xd8bf8e40  ! 1903: STDA_R	stda	%r12, [%r30 + %r0] 0x72
	mov	0x48, %r19
	mov	0x78, %r18
	mov	0x3c0, %r22
	.word 0xd0976000  ! 1907: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	mov	0x60, %r27
	.word 0xd0972000  ! 1909: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xdacf0e60  ! 1910: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r13
	.word 0xdacf0e60  ! 1911: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r13
	.word 0x87802072  ! 1912: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r16
	mov	0x58, %r18
	.word 0xd2a40400  ! 1915: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	mov	0x0, %r16
	.word 0xd8bf2000  ! 1917: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xde8c4400  ! 1919: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	.word 0xd6978e60  ! 1920: LDUHA_R	lduha	[%r30, %r0] 0x73, %r11
	.word 0xd8bfa000  ! 1921: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd89fa000  ! 1922: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	.word 0xd8bfa000  ! 1923: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	mov	0x20, %r25
	mov	0x60, %r25
	.word 0xd8dfe000  ! 1926: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8bfe000  ! 1927: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd8cf2000  ! 1928: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0xd6be89e0  ! 1929: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	.word 0xdcf48400  ! 1930: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xd2948400  ! 1931: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	mov	0x20, %r19
	.word 0xd28f0e60  ! 1933: LDUBA_R	lduba	[%r28, %r0] 0x73, %r9
	.word 0xd0bf2000  ! 1934: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 1935: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf74e80  ! 1936: STXA_R	stxa	%r14, [%r29 + %r0] 0x74
	mov	0x68, %r19
	.word 0xd0f72000  ! 1938: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xd0a70e80  ! 1939: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0xda87ce60  ! 1940: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r13
	mov	0x58, %r25
	mov	0x0, %r16
	.word 0xd6bf2000  ! 1943: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd6b7e000  ! 1944: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 1945: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd68f8e60  ! 1946: LDUBA_R	lduba	[%r30, %r0] 0x73, %r11
	.word 0x8780204f  ! 1947: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaac4400  ! 1948: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	.word 0xd0b7a000  ! 1949: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	mov	0x18, %r17
	.word 0xd097e000  ! 1951: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	mov	0x60, %r24
	.word 0xdcbf8e80  ! 1953: STDA_R	stda	%r14, [%r30 + %r0] 0x74
	.word 0x87802020  ! 1954: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1955: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda9d04a0  ! 1956: LDDA_R	ldda	[%r20, %r0] 0x25, %r13
	.word 0xd0c44400  ! 1957: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r8
	mov	0x20, %r27
	.word 0xd0bf6000  ! 1959: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd8f504a0  ! 1960: STXA_R	stxa	%r12, [%r20 + %r0] 0x25
	.word 0x8780204f  ! 1961: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bd84a0  ! 1962: STDA_R	stda	%r10, [%r22 + %r0] 0x25
	.word 0xd8cc2000  ! 1963: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r12
	.word 0xd8942000  ! 1964: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r12
	.word 0xd8d7ce80  ! 1965: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r12
	mov	0x10, %r27
	.word 0xd8d4e000  ! 1967: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0xd89ce000  ! 1968: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	.word 0xd8bc2000  ! 1969: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd8dca000  ! 1970: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	.word 0x87802072  ! 1971: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6df4e80  ! 1972: LDXA_R	ldxa	[%r29, %r0] 0x74, %r11
	.word 0xdcaf8e80  ! 1973: STBA_R	stba	%r14, [%r30 + %r0] 0x74
	.word 0x87802073  ! 1974: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 1975: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b4e000  ! 1976: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xdabd04a0  ! 1977: STDA_R	stda	%r13, [%r20 + %r0] 0x25
	.word 0xd8dc6000  ! 1978: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	.word 0xdab78e60  ! 1979: STHA_R	stha	%r13, [%r30 + %r0] 0x73
	.word 0xda9649e0  ! 1980: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r13
	mov	0x8, %r24
	mov	0x40, %r25
	mov	0x3e8, %r22
	.word 0x87802020  ! 1984: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f7e000  ! 1985: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xdcbfce40  ! 1986: STDA_R	stda	%r14, [%r31 + %r0] 0x72
	.word 0xdcafa000  ! 1987: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0xd29f4e40  ! 1989: LDDA_R	ldda	[%r29, %r0] 0x72, %r9
	mov	0x50, %r26
	.word 0x87802020  ! 1991: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1992: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68f2000  ! 1993: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	mov	0x8, %r26
	mov	0x3f0, %r22
	.word 0xd6df2000  ! 1996: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xdab5c4a0  ! 1997: STHA_R	stha	%r13, [%r23 + %r0] 0x25
	mov	0x3d0, %r21
	.word 0xde872000  ! 1999: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xdecf2000  ! 2000: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xdec7a000  ! 2001: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xdef7e000  ! 2002: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xdabf8e60  ! 2003: STDA_R	stda	%r13, [%r30 + %r0] 0x73
	mov	0x3d0, %r23
	.word 0xd2b7e000  ! 2005: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2af2000  ! 2006: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xdca70e40  ! 2007: STWA_R	stwa	%r14, [%r28 + %r0] 0x72
	.word 0xd0bf2000  ! 2008: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xd6b48400  ! 2009: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xdab72000  ! 2010: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 2011: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d0, %r21
	.word 0xd89d84a0  ! 2013: LDDA_R	ldda	[%r22, %r0] 0x25, %r12
	.word 0xd097e000  ! 2014: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xd6dc8400  ! 2015: LDXA_R	ldxa	[%r18, %r0] 0x20, %r11
	mov	0x0, %r27
	mov	0x7e0, %r20
	.word 0xdcd76000  ! 2018: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	.word 0xdccf2000  ! 2019: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xdcd7e000  ! 2020: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xdc97e000  ! 2021: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xdc8fa000  ! 2022: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdca7a000  ! 2023: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdca76000  ! 2024: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcf78e60  ! 2025: STXA_R	stxa	%r14, [%r30 + %r0] 0x73
	.word 0xde9f6000  ! 2026: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0xd6b584a0  ! 2027: STHA_R	stha	%r11, [%r22 + %r0] 0x25
	mov	0x3c8, %r22
	.word 0xd0dfe000  ! 2029: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xd4f40400  ! 2030: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xdc8fe000  ! 2031: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xd8878e40  ! 2032: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r12
	.word 0xd4976000  ! 2033: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r10
	mov	0x3d8, %r23
	.word 0x87802025  ! 2035: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2036: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r24
	.word 0x87802020  ! 2038: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a7e000  ! 2039: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 2040: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4af8e60  ! 2041: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	.word 0xd4bd2000  ! 2042: STDA_I	stda	%r10, [%r20 + 0x0000] %asi
	.word 0xd48d2000  ! 2043: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0xd4f5e000  ! 2044: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	.word 0xdcbf0e80  ! 2045: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	.word 0xd8c48400  ! 2046: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	mov	0x7c0, %r21
	.word 0xd4d5a000  ! 2048: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r10
	mov	0x30, %r27
	mov	0x18, %r19
	.word 0xdcb70e80  ! 2051: STHA_R	stha	%r14, [%r28 + %r0] 0x74
	mov	0x0, %r25
	.word 0xd88584a0  ! 2053: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r12
	.word 0x87802025  ! 2054: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde8fe000  ! 2055: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0xdecfe000  ! 2056: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	mov	0x10, %r16
	mov	0x7c8, %r21
	.word 0xd89e89e0  ! 2059: LDDA_R	ldda	[%r26, %r0] 0x4f, %r12
	.word 0xdecfce60  ! 2060: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r15
	.word 0x87802020  ! 2061: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb62000  ! 2062: STHA_I	stha	%r15, [%r24 + 0x0000] %asi
	.word 0xd6870e60  ! 2063: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r11
	.word 0xd0b66000  ! 2064: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	.word 0xd0be2000  ! 2065: STDA_I	stda	%r8, [%r24 + 0x0000] %asi
	.word 0xd09c0400  ! 2066: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	mov	0x0, %r26
	mov	0x58, %r17
	.word 0x87802072  ! 2069: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8df6000  ! 2070: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8afe000  ! 2071: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd6f649e0  ! 2072: STXA_R	stxa	%r11, [%r25 + %r0] 0x4f
	.word 0xdeb72000  ! 2073: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xdea76000  ! 2074: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 2075: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde9fe000  ! 2076: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	mov	0x70, %r19
	mov	0x0, %r25
	.word 0xdecf6000  ! 2079: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdea7e000  ! 2081: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2082: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r19
	.word 0xdedca000  ! 2084: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xdea4a000  ! 2085: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xdebce000  ! 2086: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 2087: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r16
	.word 0xdef4a000  ! 2089: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0xdeac6000  ! 2090: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 2091: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4d70e40  ! 2092: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r10
	.word 0xd6bce000  ! 2093: STDA_I	stda	%r11, [%r19 + 0x0000] %asi
	.word 0xd6dca000  ! 2094: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r11
	mov	0x78, %r16
	.word 0xd4c7ce60  ! 2096: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r10
	.word 0xd4d42000  ! 2097: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	.word 0xd4dca000  ! 2098: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	.word 0xd6b4c400  ! 2099: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0x87802020  ! 2100: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadfa000  ! 2101: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xdaf7e000  ! 2102: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xd0a78e40  ! 2103: STWA_R	stwa	%r8, [%r30 + %r0] 0x72
	ta	T_CHANGE_PRIV	! macro
	mov	0x3d8, %r23
	.word 0xda972000  ! 2106: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0xdabfe000  ! 2107: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xde8f0e80  ! 2108: LDUBA_R	lduba	[%r28, %r0] 0x74, %r15
	mov	0x8, %r27
	.word 0xd8b76000  ! 2110: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 2111: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r20
	.word 0xd8cc2000  ! 2113: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r12
	.word 0xd8f4a000  ! 2114: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8be09e0  ! 2115: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	mov	0x50, %r27
	.word 0xd0afce80  ! 2117: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	.word 0xd4ce89e0  ! 2118: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r10
	mov	0x78, %r27
	.word 0xdead84a0  ! 2120: STBA_R	stba	%r15, [%r22 + %r0] 0x25
	.word 0x8780204f  ! 2121: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6878e40  ! 2122: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r11
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdac74e60  ! 2124: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r13
	.word 0xd6ad44a0  ! 2125: STBA_R	stba	%r11, [%r21 + %r0] 0x25
	.word 0xd8c42000  ! 2126: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r12
	mov	0x28, %r19
	.word 0xd8bce000  ! 2128: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	mov	0x48, %r25
	.word 0xd8c609e0  ! 2130: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r12
	.word 0xd28ce000  ! 2131: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	.word 0xd2d4a000  ! 2132: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	mov	0x40, %r25
	.word 0x87802073  ! 2134: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd28fe000  ! 2135: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	.word 0xd29fe000  ! 2136: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd0cc0400  ! 2137: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xdea70e40  ! 2138: STWA_R	stwa	%r15, [%r28 + %r0] 0x72
	.word 0xd8f40400  ! 2139: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0x87802074  ! 2140: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeac8400  ! 2141: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0x87802025  ! 2142: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f0, %r20
	.word 0xd68c0400  ! 2144: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	.word 0x87802020  ! 2145: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b52000  ! 2146: STHA_I	stha	%r8, [%r20 + 0x0000] %asi
	.word 0xd0c52000  ! 2147: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r8
	mov	0x18, %r26
	.word 0x87802025  ! 2149: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r17
	.word 0x87802020  ! 2151: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd096e000  ! 2152: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r8
	.word 0xd0c6e000  ! 2153: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r8
	.word 0x87802020  ! 2154: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d48400  ! 2155: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0x8780204f  ! 2156: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r19
	mov	0x18, %r17
	.word 0xd28c0400  ! 2159: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	.word 0xda9ce000  ! 2160: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r13
	.word 0xdacce000  ! 2161: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r13
	.word 0xdacca000  ! 2162: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	.word 0xd2f40400  ! 2163: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xdcb4e000  ! 2164: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xdca46000  ! 2166: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xd2c6c9e0  ! 2167: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r9
	.word 0x87802072  ! 2168: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 2169: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r18
	.word 0xd0f6a000  ! 2171: STXA_I	stxa	%r8, [%r26 + 0x0000] %asi
	.word 0xd0a6e000  ! 2172: STWA_I	stwa	%r8, [%r27 + 0x0000] %asi
	.word 0xd6af4e60  ! 2173: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	.word 0x87802025  ! 2174: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb544a0  ! 2175: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	.word 0xdeafce40  ! 2176: STBA_R	stba	%r15, [%r31 + %r0] 0x72
	.word 0x87802074  ! 2177: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2972000  ! 2178: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2179: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b76000  ! 2180: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 2181: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29e2000  ! 2182: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r9
	.word 0xdcb7ce60  ! 2183: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	mov	0x0, %r24
	.word 0xdaa6a000  ! 2185: STWA_I	stwa	%r13, [%r26 + 0x0000] %asi
	.word 0xdcc78e60  ! 2186: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r14
	.word 0x87802073  ! 2187: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcac8400  ! 2188: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xdcb7e000  ! 2189: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xd2df0e40  ! 2190: LDXA_R	ldxa	[%r28, %r0] 0x72, %r9
	mov	0x60, %r25
	.word 0xdcdfa000  ! 2192: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	.word 0xdca7ce60  ! 2193: STWA_R	stwa	%r14, [%r31 + %r0] 0x73
	.word 0xdadf2000  ! 2194: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0xdabf6000  ! 2195: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	mov	0x3d0, %r21
	mov	0x8, %r27
	.word 0xda8fe000  ! 2198: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	mov	0x68, %r18
	.word 0xde948400  ! 2200: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	mov	0x18, %r18
	.word 0xd28f8e40  ! 2202: LDUBA_R	lduba	[%r30, %r0] 0x72, %r9
	mov	0x3c0, %r22
	.word 0x87802020  ! 2204: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r20
	.word 0xd69ec9e0  ! 2206: LDDA_R	ldda	[%r27, %r0] 0x4f, %r11
	mov	0x3e8, %r21
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdcae2000  ! 2209: STBA_I	stba	%r14, [%r24 + 0x0000] %asi
	.word 0xdcd62000  ! 2210: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r14
	.word 0xd8f74e40  ! 2211: STXA_R	stxa	%r12, [%r29 + %r0] 0x72
	mov	0x18, %r25
	.word 0xdc8e2000  ! 2213: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r14
	.word 0xdc9ea000  ! 2214: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r14
	.word 0xdcb78e40  ! 2215: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xd2c66000  ! 2216: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r9
	mov	0x18, %r25
	.word 0x87802020  ! 2218: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2219: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc978e40  ! 2220: LDUHA_R	lduha	[%r30, %r0] 0x72, %r14
	mov	0x48, %r16
	.word 0xd2a6c9e0  ! 2222: STWA_R	stwa	%r9, [%r27 + %r0] 0x4f
	.word 0xdcf4a000  ! 2223: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdea78e80  ! 2224: STWA_R	stwa	%r15, [%r30 + %r0] 0x74
	mov	0x78, %r27
	.word 0x87802020  ! 2226: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd086a000  ! 2227: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r8
	.word 0xd6d609e0  ! 2228: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r11
	mov	0x7c8, %r23
	.word 0x87802072  ! 2230: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8978e40  ! 2231: LDUHA_R	lduha	[%r30, %r0] 0x72, %r12
	.word 0x8780204f  ! 2232: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 2233: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2234: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xded72000  ! 2235: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0x87802074  ! 2236: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 2237: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf44400  ! 2238: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0x87802025  ! 2239: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0dfe000  ! 2240: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0x87802074  ! 2241: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b62000  ! 2242: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0xd08ee000  ! 2243: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 2244: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r24
	.word 0xdede49e0  ! 2246: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r15
	.word 0xd2d7ce80  ! 2247: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r9
	mov	0x48, %r27
	.word 0x87802020  ! 2249: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2250: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f7a000  ! 2251: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xd297e000  ! 2252: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2253: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb7ce80  ! 2254: STHA_R	stha	%r15, [%r31 + %r0] 0x74
	mov	0x10, %r27
	.word 0xd6a74e60  ! 2256: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	.word 0xd2f78e80  ! 2257: STXA_R	stxa	%r9, [%r30 + %r0] 0x74
	.word 0x87802025  ! 2258: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd49f8e60  ! 2259: LDDA_R	ldda	[%r30, %r0] 0x73, %r10
	mov	0x3e0, %r23
	.word 0xd8dc8400  ! 2261: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	mov	0x7f8, %r23
	.word 0x87802072  ! 2263: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a72000  ! 2264: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8cfe000  ! 2265: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	mov	0x7d0, %r20
	mov	0x60, %r26
	.word 0xd89fa000  ! 2268: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	.word 0xd88fa000  ! 2269: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0xdc9c8400  ! 2270: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0xd0a7a000  ! 2271: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xdeb5c4a0  ! 2272: STHA_R	stha	%r15, [%r23 + %r0] 0x25
	.word 0xded7e000  ! 2273: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0xd08649e0  ! 2274: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r8
	mov	0x58, %r24
	.word 0xdccfe000  ! 2276: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xdcf7e000  ! 2277: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x28, %r24
	.word 0xdc876000  ! 2279: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0xdef48400  ! 2280: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	mov	0x68, %r16
	.word 0x87802020  ! 2282: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48f2000  ! 2283: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd0be49e0  ! 2284: STDA_R	stda	%r8, [%r25 + %r0] 0x4f
	.word 0xdaf70e40  ! 2285: STXA_R	stxa	%r13, [%r28 + %r0] 0x72
	.word 0xde878e60  ! 2286: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r15
	.word 0xd0f72000  ! 2287: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	mov	0x7d8, %r21
	mov	0x40, %r25
	mov	0x50, %r24
	.word 0x87802020  ! 2291: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcd4c400  ! 2292: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	.word 0xd2b76000  ! 2293: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2a7e000  ! 2294: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 2295: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 2296: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bfe000  ! 2297: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd2f74e40  ! 2298: STXA_R	stxa	%r9, [%r29 + %r0] 0x72
	.word 0xd8b72000  ! 2299: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xd4a74e60  ! 2301: STWA_R	stwa	%r10, [%r29 + %r0] 0x73
	.word 0xd4cd04a0  ! 2302: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r10
	.word 0x87802073  ! 2303: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c8, %r23
	.word 0xdcf4c400  ! 2305: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xdca7ce40  ! 2306: STWA_R	stwa	%r14, [%r31 + %r0] 0x72
	.word 0xde966000  ! 2307: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r15
	.word 0xdc9c4400  ! 2308: LDDA_R	ldda	[%r17, %r0] 0x20, %r14
	mov	0x28, %r19
	.word 0x87802025  ! 2310: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8cf8e60  ! 2311: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r12
	.word 0xdaaf0e60  ! 2312: STBA_R	stba	%r13, [%r28 + %r0] 0x73
	.word 0x87802074  ! 2313: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r25
	.word 0xd8b4e000  ! 2315: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0xd4c504a0  ! 2316: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r10
	.word 0xd294e000  ! 2317: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	.word 0xd2c4e000  ! 2318: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xd2c584a0  ! 2319: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r9
	.word 0x87802074  ! 2320: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f48400  ! 2321: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xd8c5e000  ! 2322: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r12
	.word 0xd8c74e80  ! 2323: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r12
	.word 0xdcbd6000  ! 2324: STDA_I	stda	%r14, [%r21 + 0x0000] %asi
	mov	0x58, %r26
	.word 0xd6de89e0  ! 2326: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r11
	mov	0x58, %r27
	.word 0xd0c70e60  ! 2328: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r8
	mov	0x30, %r26
	.word 0x87802073  ! 2330: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 2331: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2ad84a0  ! 2332: STBA_R	stba	%r9, [%r22 + %r0] 0x25
	.word 0xdcb649e0  ! 2333: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	mov	0x7e8, %r21
	mov	0x20, %r25
	.word 0xd2f40400  ! 2336: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xd8ac4400  ! 2337: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0x87802073  ! 2338: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdea544a0  ! 2339: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	.word 0xdeac0400  ! 2340: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xd2a76000  ! 2341: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd6a504a0  ! 2342: STWA_R	stwa	%r11, [%r20 + %r0] 0x25
	mov	0x78, %r27
	.word 0xdcd544a0  ! 2344: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r14
	.word 0xd8dc4400  ! 2345: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0x87802073  ! 2346: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e8, %r22
	.word 0xd8bfce80  ! 2348: STDA_R	stda	%r12, [%r31 + %r0] 0x74
	.word 0xde9e09e0  ! 2349: LDDA_R	ldda	[%r24, %r0] 0x4f, %r15
	.word 0xd2874e80  ! 2350: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r9
	.word 0xda8d44a0  ! 2351: LDUBA_R	lduba	[%r21, %r0] 0x25, %r13
	.word 0xd694e000  ! 2352: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r11
	mov	0x8, %r27
	mov	0x10, %r19
	.word 0xd69c4400  ! 2355: LDDA_R	ldda	[%r17, %r0] 0x20, %r11
	mov	0x3e0, %r20
	.word 0x87802072  ! 2357: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf70e80  ! 2358: STXA_R	stxa	%r14, [%r28 + %r0] 0x74
	.word 0xd8c7a000  ! 2359: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8dfe000  ! 2360: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	mov	0x48, %r19
	.word 0x87802073  ! 2362: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdadf8e80  ! 2363: LDXA_R	ldxa	[%r30, %r0] 0x74, %r13
	.word 0x87802073  ! 2364: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4a70e80  ! 2365: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	.word 0xd48c6000  ! 2366: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r10
	.word 0xd4946000  ! 2367: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r10
	.word 0xd69f8e60  ! 2368: LDDA_R	ldda	[%r30, %r0] 0x73, %r11
	.word 0xdcd42000  ! 2369: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	.word 0xd2c544a0  ! 2370: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r9
	.word 0xd8a70e80  ! 2371: STWA_R	stwa	%r12, [%r28 + %r0] 0x74
	.word 0xd0a46000  ! 2372: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0bca000  ! 2373: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0xd0942000  ! 2374: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r8
	.word 0xd6b70e60  ! 2375: STHA_R	stha	%r11, [%r28 + %r0] 0x73
	.word 0xdecfce40  ! 2376: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r15
	.word 0xd88c2000  ! 2377: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	.word 0xdebf0e40  ! 2378: STDA_R	stda	%r15, [%r28 + %r0] 0x72
	.word 0xdabc2000  ! 2379: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 2380: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4a4c400  ! 2381: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0xdeaca000  ! 2382: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	mov	0x28, %r18
	.word 0x87802020  ! 2384: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd89c0400  ! 2385: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	.word 0xd0a74e40  ! 2386: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	.word 0xd0af0e60  ! 2387: STBA_R	stba	%r8, [%r28 + %r0] 0x73
	.word 0xd4a5a000  ! 2388: STWA_I	stwa	%r10, [%r22 + 0x0000] %asi
	.word 0xd4d56000  ! 2389: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r10
	mov	0x30, %r24
	.word 0xd495e000  ! 2391: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r10
	.word 0xdca7ce60  ! 2392: STWA_R	stwa	%r14, [%r31 + %r0] 0x73
	mov	0x78, %r27
	mov	0x3d0, %r21
	.word 0xdadd6000  ! 2395: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r13
	.word 0xdc9f0e60  ! 2396: LDDA_R	ldda	[%r28, %r0] 0x73, %r14
	mov	0x0, %r24
	.word 0xd2bda000  ! 2398: STDA_I	stda	%r9, [%r22 + 0x0000] %asi
	.word 0xd6b544a0  ! 2399: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	mov	0x18, %r26
	.word 0x87802020  ! 2401: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebca000  ! 2402: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xd6b4c400  ! 2403: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	mov	0x3c8, %r21
	.word 0xd6dce000  ! 2405: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	ta	T_CHANGE_PRIV	! macro
	.word 0xd694e000  ! 2407: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r11
	.word 0xd6aca000  ! 2408: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	mov	0x70, %r19
	mov	0x7e8, %r21
	mov	0x7f8, %r22
	.word 0xdc8f0e80  ! 2412: LDUBA_R	lduba	[%r28, %r0] 0x74, %r14
	.word 0xd2bc0400  ! 2413: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xdcb4a000  ! 2414: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xdc87ce80  ! 2415: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r14
	.word 0xd6b4a000  ! 2416: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd8f4c400  ! 2417: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	mov	0x60, %r18
	.word 0xdc942000  ! 2419: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	.word 0xdaa7ce60  ! 2420: STWA_R	stwa	%r13, [%r31 + %r0] 0x73
	mov	0x70, %r26
	.word 0xdabf4e40  ! 2422: STDA_R	stda	%r13, [%r29 + %r0] 0x72
	.word 0xd6dc2000  ! 2423: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r11
	.word 0xd6bf4e80  ! 2424: STDA_R	stda	%r11, [%r29 + %r0] 0x74
	.word 0xd8dce000  ! 2425: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	.word 0xd29c0400  ! 2426: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	.word 0xd4a48400  ! 2427: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	mov	0x38, %r26
	.word 0xd0afce80  ! 2429: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	.word 0xd2846000  ! 2430: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r9
	.word 0xd2cf8e40  ! 2431: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r9
	mov	0x20, %r18
	.word 0x87802074  ! 2433: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r18
	.word 0xd6ae6000  ! 2435: STBA_I	stba	%r11, [%r25 + 0x0000] %asi
	.word 0xd6d584a0  ! 2436: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r11
	.word 0xd8cea000  ! 2437: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r12
	mov	0x10, %r19
	.word 0x87802073  ! 2439: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2440: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b78e60  ! 2441: STHA_R	stha	%r11, [%r30 + %r0] 0x73
	.word 0xd09609e0  ! 2442: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r8
	.word 0xd0aec9e0  ! 2443: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	.word 0xd8f7e000  ! 2444: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2445: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ac8400  ! 2446: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	mov	0x28, %r17
	.word 0xdcbf0e80  ! 2448: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	.word 0xd6a70e80  ! 2449: STWA_R	stwa	%r11, [%r28 + %r0] 0x74
	.word 0xde876000  ! 2450: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xdca70e40  ! 2451: STWA_R	stwa	%r14, [%r28 + %r0] 0x72
	.word 0xdaa7ce80  ! 2452: STWA_R	stwa	%r13, [%r31 + %r0] 0x74
	.word 0xd0a70e40  ! 2453: STWA_R	stwa	%r8, [%r28 + %r0] 0x72
	mov	0x68, %r16
	.word 0xd8c7e000  ! 2455: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0xd2be49e0  ! 2456: STDA_R	stda	%r9, [%r25 + %r0] 0x4f
	mov	0x28, %r17
	.word 0xd6c74e60  ! 2458: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r11
	.word 0xd69e09e0  ! 2459: LDDA_R	ldda	[%r24, %r0] 0x4f, %r11
	.word 0xdec7a000  ! 2460: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xded7a000  ! 2461: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xdaaf4e40  ! 2462: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	mov	0x3e8, %r21
	mov	0x40, %r26
	.word 0xd6f7ce80  ! 2465: STXA_R	stxa	%r11, [%r31 + %r0] 0x74
	.word 0xd697e000  ! 2466: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	mov	0x30, %r16
	.word 0xdea504a0  ! 2468: STWA_R	stwa	%r15, [%r20 + %r0] 0x25
	mov	0x3e8, %r22
	.word 0xd49e89e0  ! 2470: LDDA_R	ldda	[%r26, %r0] 0x4f, %r10
	.word 0xd0cf6000  ! 2471: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd4d48400  ! 2472: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	.word 0xd0a7a000  ! 2473: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 2474: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd08fe000  ! 2475: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	mov	0x58, %r16
	.word 0xd8b70e40  ! 2477: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0xd4f7a000  ! 2478: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4bfe000  ! 2479: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 2480: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r16
	.word 0xd4d4e000  ! 2482: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	mov	0x38, %r16
	.word 0x87802020  ! 2484: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09c4400  ! 2485: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	.word 0xdcb48400  ! 2486: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xd4f7ce80  ! 2487: STXA_R	stxa	%r10, [%r31 + %r0] 0x74
	.word 0xd6cfe000  ! 2488: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0xdec7ce80  ! 2489: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r15
	mov	0x3c8, %r23
	.word 0xdcf7ce40  ! 2491: STXA_R	stxa	%r14, [%r31 + %r0] 0x72
	.word 0xdacf6000  ! 2492: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xd897ce80  ! 2493: LDUHA_R	lduha	[%r31, %r0] 0x74, %r12
	.word 0xdebc0400  ! 2494: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0xdecf2000  ! 2495: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xdabdc4a0  ! 2496: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	.word 0xd6c70e40  ! 2497: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r11
	.word 0xd8d48400  ! 2498: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0xd49cc400  ! 2499: LDDA_R	ldda	[%r19, %r0] 0x20, %r10
	.word 0x87802020  ! 2500: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r18
	.word 0xda972000  ! 2502: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	mov	0x3f0, %r23
	.word 0xdaaf2000  ! 2504: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdaa76000  ! 2505: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xda9649e0  ! 2506: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r13
	.word 0xdcd7a000  ! 2507: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0xdc976000  ! 2508: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	mov	0x7e8, %r20
	.word 0xdccfe000  ! 2510: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0x87802025  ! 2511: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8d44400  ! 2512: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	mov	0x3f0, %r23
	.word 0xd4b7ce80  ! 2514: STHA_R	stha	%r10, [%r31 + %r0] 0x74
	.word 0xdadfe000  ! 2515: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0xdaf7a000  ! 2516: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdcc74e60  ! 2517: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r14
	mov	0x58, %r25
	.word 0xdaa76000  ! 2519: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 2520: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc8c4400  ! 2521: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0xdcdfce60  ! 2522: LDXA_R	ldxa	[%r31, %r0] 0x73, %r14
	.word 0x87802025  ! 2523: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdac76000  ! 2524: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 2525: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdac46000  ! 2526: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r13
	mov	0x7f0, %r22
	mov	0x48, %r17
	.word 0xdab4a000  ! 2529: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0xdaa4a000  ! 2531: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	mov	0x3d0, %r23
	mov	0x3e0, %r20
	mov	0x3d8, %r23
	mov	0x30, %r24
	.word 0xdaa46000  ! 2536: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0xda8c2000  ! 2538: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r13
	.word 0xd6b70e60  ! 2539: STHA_R	stha	%r11, [%r28 + %r0] 0x73
	.word 0xdcf42000  ! 2540: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0xdca46000  ! 2541: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xdcbc2000  ! 2542: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xd0a78e80  ! 2543: STWA_R	stwa	%r8, [%r30 + %r0] 0x74
	.word 0xd8ac2000  ! 2544: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	mov	0x3c8, %r21
	mov	0x7e8, %r22
	.word 0xd6ac8400  ! 2547: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd88ce000  ! 2549: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	mov	0x48, %r16
	.word 0x87802020  ! 2551: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0940400  ! 2552: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	.word 0x87802020  ! 2553: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbf2000  ! 2554: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xd6f584a0  ! 2555: STXA_R	stxa	%r11, [%r22 + %r0] 0x25
	.word 0xdef72000  ! 2556: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	mov	0x7e8, %r21
	mov	0x58, %r25
	.word 0x8780204f  ! 2559: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6d70e40  ! 2560: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r11
	.word 0xd6c78e40  ! 2561: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	.word 0xd0ad6000  ! 2562: STBA_I	stba	%r8, [%r21 + 0x0000] %asi
	mov	0x60, %r18
	.word 0xd4b70e60  ! 2564: STHA_R	stha	%r10, [%r28 + %r0] 0x73
	.word 0xd0a5a000  ! 2565: STWA_I	stwa	%r8, [%r22 + 0x0000] %asi
	.word 0xd0dd2000  ! 2566: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0xd0bd6000  ! 2567: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	mov	0x20, %r17
	.word 0xd08d2000  ! 2569: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r8
	mov	0x18, %r24
	mov	0x8, %r24
	.word 0x87802020  ! 2572: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b52000  ! 2573: STHA_I	stha	%r8, [%r20 + 0x0000] %asi
	.word 0xd0ad6000  ! 2574: STBA_I	stba	%r8, [%r21 + 0x0000] %asi
	.word 0xd0956000  ! 2575: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r8
	.word 0xdadd84a0  ! 2576: LDXA_R	ldxa	[%r22, %r0] 0x25, %r13
	.word 0x87802074  ! 2577: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2578: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 2579: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8f584a0  ! 2580: STXA_R	stxa	%r12, [%r22 + %r0] 0x25
	.word 0xda872000  ! 2581: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	mov	0x8, %r16
	.word 0xd8dfce80  ! 2583: LDXA_R	ldxa	[%r31, %r0] 0x74, %r12
	.word 0xd8b7e000  ! 2584: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 2585: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a649e0  ! 2586: STWA_R	stwa	%r11, [%r25 + %r0] 0x4f
	.word 0xdebd84a0  ! 2587: STDA_R	stda	%r15, [%r22 + %r0] 0x25
	.word 0xd08c6000  ! 2588: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0xd0aca000  ! 2589: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xd08ca000  ! 2590: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xd0a4a000  ! 2591: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0xd08ce000  ! 2592: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0d42000  ! 2593: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r8
	.word 0xd0b42000  ! 2594: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xd4df8e60  ! 2595: LDXA_R	ldxa	[%r30, %r0] 0x73, %r10
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x3e8, %r23
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd8dca000  ! 2599: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	.word 0xd8ac2000  ! 2600: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0xd2c74e40  ! 2601: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r9
	.word 0x87802020  ! 2602: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda940400  ! 2603: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	.word 0xd48fa000  ! 2604: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xd68d84a0  ! 2605: LDUBA_R	lduba	[%r22, %r0] 0x25, %r11
	.word 0xdeafa000  ! 2606: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 2607: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2cc8400  ! 2608: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0x87802073  ! 2609: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeac2000  ! 2610: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xde8ce000  ! 2611: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	.word 0x87802020  ! 2612: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded7a000  ! 2613: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	mov	0x3e0, %r21
	.word 0xded72000  ! 2615: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	mov	0x3e8, %r22
	.word 0xdef76000  ! 2617: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xd4bc0400  ! 2618: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xd8af0e40  ! 2619: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	.word 0xdcf72000  ! 2620: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdaac8400  ! 2621: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0xdeae89e0  ! 2622: STBA_R	stba	%r15, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 2623: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa4c400  ! 2624: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	mov	0x7f0, %r21
	mov	0x0, %r18
	.word 0x87802073  ! 2627: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeaf6000  ! 2628: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xdebf2000  ! 2629: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	mov	0x68, %r18
	mov	0x7f8, %r20
	.word 0xdecf2000  ! 2632: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xdef7e000  ! 2633: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xd48cc400  ! 2634: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	.word 0xdaa7a000  ! 2635: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 2636: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6bc0400  ! 2637: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xded70e60  ! 2638: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r15
	.word 0xd8bc6000  ! 2639: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0xd8b42000  ! 2640: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	mov	0x20, %r18
	.word 0x87802073  ! 2642: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8bce000  ! 2643: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd8c42000  ! 2644: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r12
	mov	0x58, %r25
	mov	0x18, %r18
	.word 0xd0be09e0  ! 2647: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0xde8f0e60  ! 2648: LDUBA_R	lduba	[%r28, %r0] 0x73, %r15
	.word 0xd4bce000  ! 2649: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0xd0a74e60  ! 2650: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	.word 0x87802074  ! 2651: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2c70e40  ! 2652: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r9
	.word 0xd095a000  ! 2653: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r8
	.word 0xd08f4e80  ! 2654: LDUBA_R	lduba	[%r29, %r0] 0x74, %r8
	.word 0x87802020  ! 2655: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2656: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0842000  ! 2657: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r8
	.word 0xd0df4e40  ! 2658: LDXA_R	ldxa	[%r29, %r0] 0x72, %r8
	.word 0xd4de09e0  ! 2659: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r10
	.word 0x87802025  ! 2660: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 2661: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2d70e40  ! 2662: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r9
	.word 0x87802025  ! 2663: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2664: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2665: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd695e000  ! 2666: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2667: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bd84a0  ! 2668: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0xd8bec9e0  ! 2669: STDA_R	stda	%r12, [%r27 + %r0] 0x4f
	.word 0xd0de09e0  ! 2670: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r8
	.word 0xdcdfe000  ! 2671: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	mov	0x7c0, %r22
	.word 0xd2f504a0  ! 2673: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	.word 0xd89f6000  ! 2674: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	.word 0xd8f7e000  ! 2675: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8d72000  ! 2676: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xdab4c400  ! 2677: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	mov	0x3c0, %r23
	.word 0xdab76000  ! 2679: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0xd8d689e0  ! 2681: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r12
	.word 0xd2bf0e60  ! 2682: STDA_R	stda	%r9, [%r28 + %r0] 0x73
	.word 0xd4c7ce60  ! 2683: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r10
	.word 0xd4a74e40  ! 2684: STWA_R	stwa	%r10, [%r29 + %r0] 0x72
	.word 0xd6a72000  ! 2685: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6cfe000  ! 2686: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	mov	0x3e8, %r21
	.word 0x8780204f  ! 2688: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r17
	.word 0xd2afce60  ! 2690: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	.word 0x87802020  ! 2691: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b62000  ! 2692: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0xdecf0e80  ! 2693: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r15
	.word 0xd4c62000  ! 2694: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r10
	.word 0xd4be6000  ! 2695: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0xdc844400  ! 2697: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	.word 0xd886e000  ! 2698: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r12
	.word 0xd4a4c400  ! 2699: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0xdeaf0e60  ! 2700: STBA_R	stba	%r15, [%r28 + %r0] 0x73
	.word 0xd08ee000  ! 2701: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r8
	.word 0xd8dc8400  ! 2702: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xd6c70e60  ! 2703: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r11
	.word 0x8780204f  ! 2704: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebc2000  ! 2705: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xd8b44400  ! 2706: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0x87802072  ! 2707: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cd44a0  ! 2708: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r10
	.word 0xdeb76000  ! 2709: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xd49f8e80  ! 2710: LDDA_R	ldda	[%r30, %r0] 0x74, %r10
	mov	0x7f8, %r20
	.word 0xd2ac4400  ! 2712: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xd08f0e40  ! 2713: LDUBA_R	lduba	[%r28, %r0] 0x72, %r8
	.word 0x87802072  ! 2714: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdecca000  ! 2715: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	.word 0xde942000  ! 2716: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	mov	0x38, %r16
	.word 0xd2bfce80  ! 2718: STDA_R	stda	%r9, [%r31 + %r0] 0x74
	mov	0x10, %r17
	.word 0xd0a4e000  ! 2720: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd4b48400  ! 2721: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd4d4a000  ! 2722: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0x87802072  ! 2723: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r26
	.word 0xd4844400  ! 2725: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0xd6cf2000  ! 2726: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2727: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r24
	.word 0xd0840400  ! 2729: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	mov	0x3c8, %r23
	mov	0x3c0, %r23
	.word 0xdabf8e80  ! 2732: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	mov	0x3c0, %r23
	.word 0x87802072  ! 2734: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c0, %r22
	.word 0xd6dd6000  ! 2736: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r11
	mov	0x7d8, %r21
	mov	0x78, %r17
	.word 0xd0bf8e80  ! 2739: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	.word 0xd2f48400  ! 2740: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	mov	0x7c8, %r23
	.word 0xd2c70e80  ! 2742: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r9
	.word 0x87802074  ! 2743: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r26
	.word 0xd6dda000  ! 2745: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r11
	.word 0xd6f52000  ! 2746: STXA_I	stxa	%r11, [%r20 + 0x0000] %asi
	.word 0xd6852000  ! 2747: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r11
	mov	0x28, %r26
	.word 0xdc97ce80  ! 2749: LDUHA_R	lduha	[%r31, %r0] 0x74, %r14
	.word 0xd2f44400  ! 2750: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	mov	0x50, %r24
	.word 0xd4dc8400  ! 2752: LDXA_R	ldxa	[%r18, %r0] 0x20, %r10
	mov	0x7f0, %r23
	.word 0xd4d48400  ! 2754: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	.word 0xde8ec9e0  ! 2755: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r15
	mov	0x60, %r18
	.word 0xdace09e0  ! 2757: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r13
	.word 0xd4f504a0  ! 2758: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0xd8ac4400  ! 2759: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	mov	0x20, %r19
	.word 0xd09d2000  ! 2761: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r8
	.word 0xd4a649e0  ! 2762: STWA_R	stwa	%r10, [%r25 + %r0] 0x4f
	.word 0x87802025  ! 2763: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2764: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 2765: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2af4e60  ! 2766: STBA_R	stba	%r9, [%r29 + %r0] 0x73
	.word 0xda870e40  ! 2767: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r13
	.word 0x87802025  ! 2768: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd28c6000  ! 2769: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0xd2942000  ! 2770: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2771: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r17
	.word 0x87802025  ! 2773: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdef48400  ! 2774: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	mov	0x7d8, %r20
	mov	0x0, %r17
	mov	0x3f8, %r23
	.word 0xd0f72000  ! 2778: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0x87802020  ! 2780: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcaf8e60  ! 2781: STBA_R	stba	%r14, [%r30 + %r0] 0x73
	mov	0x48, %r19
	.word 0xd2f6e000  ! 2783: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	.word 0xd2dea000  ! 2784: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2b62000  ! 2786: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	.word 0xd2a74e80  ! 2787: STWA_R	stwa	%r9, [%r29 + %r0] 0x74
	.word 0xd8d70e60  ! 2788: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r12
	mov	0x3d8, %r22
	mov	0x60, %r24
	.word 0x87802073  ! 2791: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdabdc4a0  ! 2792: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	.word 0x8780204f  ! 2793: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x0, %r27
	.word 0x87802072  ! 2795: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeaea000  ! 2796: STBA_I	stba	%r15, [%r26 + 0x0000] %asi
	.word 0xdaa74e80  ! 2797: STWA_R	stwa	%r13, [%r29 + %r0] 0x74
	.word 0x87802073  ! 2798: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 2799: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdec40400  ! 2800: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xda872000  ! 2801: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0xd8cf0e80  ! 2802: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r12
	.word 0xdabf6000  ! 2803: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xd2af4e80  ! 2804: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	.word 0xd4f76000  ! 2805: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4a76000  ! 2806: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd8cc8400  ! 2807: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	mov	0x40, %r16
	.word 0x87802073  ! 2809: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r17
	.word 0xda87a000  ! 2811: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0xda8fa000  ! 2812: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xd8d544a0  ! 2813: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r12
	mov	0x3d0, %r23
	.word 0xd48fa000  ! 2815: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0x87802020  ! 2816: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2817: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r16
	mov	0x50, %r16
	.word 0xdcbf8e80  ! 2820: STDA_R	stda	%r14, [%r30 + %r0] 0x74
	.word 0xd0d7e000  ! 2821: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0a7a000  ! 2822: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd29f8e80  ! 2823: LDDA_R	ldda	[%r30, %r0] 0x74, %r9
	.word 0xd0972000  ! 2824: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xd8dfce80  ! 2825: LDXA_R	ldxa	[%r31, %r0] 0x74, %r12
	.word 0xd68f4e60  ! 2826: LDUBA_R	lduba	[%r29, %r0] 0x73, %r11
	.word 0x87802074  ! 2827: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4bf8e60  ! 2828: STDA_R	stda	%r10, [%r30 + %r0] 0x73
	.word 0xd29cc400  ! 2829: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	mov	0x7f8, %r20
	.word 0xd4946000  ! 2831: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r10
	mov	0x50, %r27
	.word 0xdef504a0  ! 2833: STXA_R	stxa	%r15, [%r20 + %r0] 0x25
	.word 0xde9c2000  ! 2834: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xdebc2000  ! 2835: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xdeac2000  ! 2836: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xd8a7ce80  ! 2837: STWA_R	stwa	%r12, [%r31 + %r0] 0x74
	mov	0x18, %r19
	.word 0x87802025  ! 2839: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd28c2000  ! 2840: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	mov	0x48, %r24
	mov	0x20, %r27
	.word 0xd2842000  ! 2843: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r9
	.word 0xdcdc4400  ! 2844: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	.word 0xdc870e40  ! 2845: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r14
	.word 0x87802020  ! 2846: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2847: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf76000  ! 2848: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x78, %r19
	.word 0xdc87e000  ! 2850: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2851: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802025  ! 2853: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2acc400  ! 2854: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	mov	0x7c0, %r22
	.word 0xd0b78e60  ! 2856: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	mov	0x7c8, %r21
	.word 0xd4bcc400  ! 2858: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0xdca6c9e0  ! 2859: STWA_R	stwa	%r14, [%r27 + %r0] 0x4f
	.word 0xd08f4e60  ! 2860: LDUBA_R	lduba	[%r29, %r0] 0x73, %r8
	.word 0xd4866000  ! 2861: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r10
	mov	0x3e0, %r20
	mov	0x7d0, %r23
	.word 0xd4a66000  ! 2864: STWA_I	stwa	%r10, [%r25 + 0x0000] %asi
	mov	0x70, %r25
	.word 0xd4a66000  ! 2866: STWA_I	stwa	%r10, [%r25 + 0x0000] %asi
	.word 0xd8ce49e0  ! 2867: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r12
	.word 0xd09cc400  ! 2868: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	.word 0xd2aee000  ! 2869: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	.word 0xd28e6000  ! 2870: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r9
	mov	0x7f0, %r23
	.word 0xd2cee000  ! 2872: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	.word 0xd2dea000  ! 2873: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r9
	.word 0xdcd7ce60  ! 2874: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r14
	.word 0xde878e40  ! 2875: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r15
	.word 0xdea6a000  ! 2876: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	.word 0xdef62000  ! 2877: STXA_I	stxa	%r15, [%r24 + 0x0000] %asi
	mov	0x68, %r26
	.word 0xd6ae49e0  ! 2879: STBA_R	stba	%r11, [%r25 + %r0] 0x4f
	mov	0x3d0, %r22
	.word 0xd6a74e60  ! 2881: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	ta	T_CHANGE_PRIV	! macro
	.word 0xdec7ce60  ! 2883: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r15
	.word 0xdea44400  ! 2884: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xd6bee000  ! 2885: STDA_I	stda	%r11, [%r27 + 0x0000] %asi
	.word 0xdaac8400  ! 2886: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	mov	0x18, %r17
	.word 0xdeb40400  ! 2888: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0xd6bcc400  ! 2889: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0xdc9f0e60  ! 2890: LDDA_R	ldda	[%r28, %r0] 0x73, %r14
	.word 0x87802025  ! 2891: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d0, %r22
	.word 0xd0c74e40  ! 2893: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r8
	.word 0xdcdc4400  ! 2894: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	.word 0xd6976000  ! 2895: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	.word 0xd6d72000  ! 2896: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r11
	mov	0x7c0, %r23
	.word 0xd2a544a0  ! 2898: STWA_R	stwa	%r9, [%r21 + %r0] 0x25
	.word 0xd8cf8e60  ! 2899: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r12
	.word 0xd08c8400  ! 2900: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	mov	0x0, %r18
	mov	0x28, %r17
	.word 0xd0ae49e0  ! 2903: STBA_R	stba	%r8, [%r25 + %r0] 0x4f
	.word 0xd4cf8e40  ! 2904: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r10
	.word 0xdc84c400  ! 2905: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	.word 0xd0f7ce80  ! 2906: STXA_R	stxa	%r8, [%r31 + %r0] 0x74
	mov	0x8, %r26
	.word 0xdabf2000  ! 2908: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	mov	0x70, %r16
	mov	0x30, %r19
	.word 0xd4974e80  ! 2911: LDUHA_R	lduha	[%r29, %r0] 0x74, %r10
	.word 0xd0afe000  ! 2912: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0bfa000  ! 2913: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 2914: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd097e000  ! 2915: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xd8bfce60  ! 2916: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	mov	0x28, %r24
	.word 0x87802073  ! 2918: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f8, %r22
	.word 0xdaadc4a0  ! 2920: STBA_R	stba	%r13, [%r23 + %r0] 0x25
	.word 0xdef52000  ! 2921: STXA_I	stxa	%r15, [%r20 + 0x0000] %asi
	.word 0xdcb7ce80  ! 2922: STHA_R	stha	%r14, [%r31 + %r0] 0x74
	.word 0xd6cd6000  ! 2923: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r11
	.word 0xd0cfce60  ! 2924: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r8
	ta	T_CHANGE_HPRIV	! macro
	mov	0x58, %r16
	.word 0xdeade000  ! 2927: STBA_I	stba	%r15, [%r23 + 0x0000] %asi
	.word 0xd68649e0  ! 2928: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r11
	.word 0xdaad2000  ! 2929: STBA_I	stba	%r13, [%r20 + 0x0000] %asi
	.word 0xdaade000  ! 2930: STBA_I	stba	%r13, [%r23 + 0x0000] %asi
	.word 0xda856000  ! 2931: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r13
	.word 0xdab52000  ! 2932: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	mov	0x70, %r25
	mov	0x20, %r17
	mov	0x20, %r25
	.word 0xde9fce80  ! 2936: LDDA_R	ldda	[%r31, %r0] 0x74, %r15
	.word 0xd4bc0400  ! 2937: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xd8df8e60  ! 2938: LDXA_R	ldxa	[%r30, %r0] 0x73, %r12
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd68f4e40  ! 2940: LDUBA_R	lduba	[%r29, %r0] 0x72, %r11
	.word 0xdacfce80  ! 2941: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r13
	.word 0x87802072  ! 2942: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcaf0e60  ! 2943: STBA_R	stba	%r14, [%r28 + %r0] 0x73
	.word 0xd2afce60  ! 2944: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	.word 0x87802074  ! 2945: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2946: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa70e60  ! 2947: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	.word 0xdadc2000  ! 2948: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r13
	.word 0xda9c6000  ! 2949: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xdea5c4a0  ! 2950: STWA_R	stwa	%r15, [%r23 + %r0] 0x25
	.word 0xdcb46000  ! 2951: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xded609e0  ! 2952: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r15
	mov	0x40, %r16
	.word 0xdca78e60  ! 2954: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	mov	0x18, %r26
	.word 0xd2f40400  ! 2956: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xd6a78e40  ! 2957: STWA_R	stwa	%r11, [%r30 + %r0] 0x72
	.word 0xd2a40400  ! 2958: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xd884c400  ! 2959: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	mov	0x3e0, %r23
	mov	0x70, %r18
	.word 0xdcb4e000  ! 2962: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 2963: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 2964: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 2965: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r24
	.word 0xdc97a000  ! 2967: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	.word 0xdca7e000  ! 2968: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcb76000  ! 2969: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xd6bec9e0  ! 2970: STDA_R	stda	%r11, [%r27 + %r0] 0x4f
	mov	0x68, %r27
	.word 0xd69fe000  ! 2972: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	.word 0xdcdc4400  ! 2973: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	.word 0xd2a7e000  ! 2974: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xd8d70e80  ! 2975: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r12
	.word 0xdc97ce40  ! 2976: LDUHA_R	lduha	[%r31, %r0] 0x72, %r14
	mov	0x28, %r19
	.word 0xdcdf8e60  ! 2978: LDXA_R	ldxa	[%r30, %r0] 0x73, %r14
	.word 0xdeae49e0  ! 2979: STBA_R	stba	%r15, [%r25 + %r0] 0x4f
	.word 0xd8ce89e0  ! 2980: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r12
	.word 0xd0b504a0  ! 2981: STHA_R	stha	%r8, [%r20 + %r0] 0x25
	.word 0xd6d7a000  ! 2982: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	mov	0x30, %r19
	.word 0xd69fe000  ! 2984: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	.word 0xd2cf4e40  ! 2985: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r9
	.word 0xd2b7e000  ! 2986: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd4b70e60  ! 2987: STHA_R	stha	%r10, [%r28 + %r0] 0x73
	mov	0x8, %r18
	.word 0xde972000  ! 2989: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0xd4d6c9e0  ! 2990: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r10
	mov	0x28, %r26
	.word 0xdc872000  ! 2992: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xd0948400  ! 2993: LDUHA_R	lduha	[%r18, %r0] 0x20, %r8
	.word 0x87802072  ! 2994: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8c504a0  ! 2995: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r12
	.word 0xde8f0e60  ! 2996: LDUBA_R	lduba	[%r28, %r0] 0x73, %r15
	.word 0x87802020  ! 2997: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbe2000  ! 2998: STDA_I	stda	%r14, [%r24 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xd49609e0  ! 3000: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r10
	.word 0x87802020  ! 3001: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b4e000  ! 3002: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xd4a46000  ! 3003: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xd49c2000  ! 3004: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	.word 0xd2bf4e60  ! 3005: STDA_R	stda	%r9, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 3006: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a46000  ! 3007: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2a4a000  ! 3008: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0xd8b4c400  ! 3009: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0xdabce000  ! 3010: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	mov	0x30, %r24
	.word 0xdcccc400  ! 3012: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	.word 0xdc8f8e60  ! 3013: LDUBA_R	lduba	[%r30, %r0] 0x73, %r14
	ta	T_CHANGE_PRIV	! macro
	mov	0x0, %r27
	.word 0xd0b48400  ! 3016: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xdebe49e0  ! 3017: STDA_R	stda	%r15, [%r25 + %r0] 0x4f
	.word 0xd4d4a000  ! 3018: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0xd8bf4e40  ! 3019: STDA_R	stda	%r12, [%r29 + %r0] 0x72
	.word 0xdebf8e40  ! 3020: STDA_R	stda	%r15, [%r30 + %r0] 0x72
	.word 0xd49c6000  ! 3021: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0xd4cce000  ! 3022: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	mov	0x20, %r18
	.word 0x87802025  ! 3024: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4a62000  ! 3025: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	.word 0xd2b48400  ! 3026: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd2c62000  ! 3027: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3028: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3029: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r27
	mov	0x58, %r16
	.word 0xd0a4c400  ! 3032: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xd89c0400  ! 3033: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	.word 0xd4ac8400  ! 3034: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0x87802025  ! 3035: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r25
	mov	0x30, %r26
	.word 0xd8d7a000  ! 3038: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0xd89f6000  ! 3039: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	.word 0xdab70e40  ! 3040: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	.word 0xd287a000  ! 3041: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0xd6c649e0  ! 3042: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r11
	.word 0xdcc70e80  ! 3043: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r14
	.word 0x8780204f  ! 3044: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3045: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3046: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a504a0  ! 3047: STWA_R	stwa	%r9, [%r20 + %r0] 0x25
	.word 0x8780204f  ! 3048: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc9d44a0  ! 3049: LDDA_R	ldda	[%r21, %r0] 0x25, %r14
	.word 0xd4b74e40  ! 3050: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	.word 0xdc9e09e0  ! 3051: LDDA_R	ldda	[%r24, %r0] 0x4f, %r14
	.word 0xd2af6000  ! 3052: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	mov	0x0, %r26
	.word 0x87802020  ! 3054: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2972000  ! 3055: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	mov	0x3c0, %r22
	.word 0xdc9f8e60  ! 3057: LDDA_R	ldda	[%r30, %r0] 0x73, %r14
	.word 0xd4cc8400  ! 3058: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	.word 0xd6bf2000  ! 3059: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0x8780204f  ! 3061: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdacc4400  ! 3062: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	.word 0xd0c74e80  ! 3063: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r8
	.word 0xdcbe49e0  ! 3064: STDA_R	stda	%r14, [%r25 + %r0] 0x4f
	.word 0xd8b74e60  ! 3065: STHA_R	stha	%r12, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 3066: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e0, %r21
	.word 0xd0c62000  ! 3068: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r8
	mov	0x7d8, %r20
	mov	0x40, %r18
	mov	0x28, %r27
	.word 0xdcb689e0  ! 3072: STHA_R	stha	%r14, [%r26 + %r0] 0x4f
	mov	0x60, %r25
	mov	0x3c0, %r22
	.word 0xd4bee000  ! 3075: STDA_I	stda	%r10, [%r27 + 0x0000] %asi
	.word 0xd4be2000  ! 3076: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	mov	0x28, %r24
	.word 0xda844400  ! 3078: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r13
	mov	0x48, %r25
	.word 0xdecfce80  ! 3080: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r15
	.word 0xd4bc4400  ! 3081: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0x87802072  ! 3082: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f76000  ! 3083: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4b76000  ! 3084: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd4cfe000  ! 3085: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0xdeb78e80  ! 3086: STHA_R	stha	%r15, [%r30 + %r0] 0x74
	.word 0xd8f72000  ! 3087: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xdca7ce80  ! 3088: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	.word 0xd6cf8e40  ! 3089: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r11
	.word 0xd6cfa000  ! 3090: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0xd6cf6000  ! 3091: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6bf6000  ! 3092: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd2ad04a0  ! 3093: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	mov	0x7d8, %r23
	.word 0xdcf72000  ! 3095: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdc97e000  ! 3096: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xdcd72000  ! 3097: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0x87802072  ! 3098: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbe6000  ! 3099: STDA_I	stda	%r14, [%r25 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0xdc866000  ! 3101: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r14
	.word 0x87802020  ! 3102: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8609e0  ! 3103: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r13
	.word 0xd49e49e0  ! 3104: LDDA_R	ldda	[%r25, %r0] 0x4f, %r10
	.word 0xd2d46000  ! 3105: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	.word 0xdebf4e60  ! 3106: STDA_R	stda	%r15, [%r29 + %r0] 0x73
	.word 0xd2840400  ! 3107: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r9
	mov	0x20, %r27
	.word 0xd4ac6000  ! 3109: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 3110: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde8d04a0  ! 3111: LDUBA_R	lduba	[%r20, %r0] 0x25, %r15
	.word 0xd6bfa000  ! 3112: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd6a7a000  ! 3113: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	mov	0x48, %r17
	.word 0xd6df4e40  ! 3115: LDXA_R	ldxa	[%r29, %r0] 0x72, %r11
	.word 0xdca689e0  ! 3116: STWA_R	stwa	%r14, [%r26 + %r0] 0x4f
	mov	0x60, %r24
	.word 0xd6cf8e40  ! 3118: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r11
	.word 0x87802073  ! 3119: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd28ec9e0  ! 3120: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r9
	mov	0x70, %r27
	.word 0xdca4a000  ! 3122: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcac2000  ! 3123: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 3124: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c0, %r21
	.word 0xdcaca000  ! 3126: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	mov	0x0, %r19
	mov	0x68, %r19
	.word 0xd4b78e60  ! 3129: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	mov	0x3f8, %r23
	.word 0x87802073  ! 3131: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3132: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3133: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc87e000  ! 3134: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 3135: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r26
	mov	0x7e0, %r20
	.word 0xdcb70e80  ! 3138: STHA_R	stha	%r14, [%r28 + %r0] 0x74
	.word 0x87802074  ! 3139: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd09c2000  ! 3140: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r8
	.word 0xd0a4a000  ! 3141: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0xd69f4e80  ! 3142: LDDA_R	ldda	[%r29, %r0] 0x74, %r11
	mov	0x78, %r18
	mov	0x8, %r25
	.word 0xd4b7ce60  ! 3145: STHA_R	stha	%r10, [%r31 + %r0] 0x73
	mov	0x0, %r18
	.word 0x87802073  ! 3147: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r25
	mov	0x70, %r26
	.word 0xdcde89e0  ! 3150: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r14
	.word 0xd4afe000  ! 3151: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xdeb7ce60  ! 3152: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	.word 0x87802025  ! 3153: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c0, %r21
	.word 0xd68fa000  ! 3155: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0x87802074  ! 3156: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r18
	mov	0x58, %r27
	mov	0x40, %r18
	.word 0xdeac0400  ! 3160: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0x87802073  ! 3161: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd09ca000  ! 3162: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	.word 0xdac7ce40  ! 3163: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r13
	.word 0x87802020  ! 3164: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0878e40  ! 3165: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r8
	.word 0xd2b584a0  ! 3166: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0xdcdf2000  ! 3167: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	mov	0x8, %r19
	.word 0xdeadc4a0  ! 3169: STBA_R	stba	%r15, [%r23 + %r0] 0x25
	.word 0xd0cd44a0  ! 3170: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r8
	mov	0x58, %r18
	mov	0x68, %r16
	.word 0xd08544a0  ! 3173: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r8
	.word 0x87802020  ! 3174: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r24
	mov	0x70, %r27
	.word 0xd6b40400  ! 3177: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xded6c9e0  ! 3178: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r15
	mov	0x10, %r24
	.word 0xdead84a0  ! 3180: STBA_R	stba	%r15, [%r22 + %r0] 0x25
	.word 0xd0862000  ! 3181: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r8
	.word 0xd08ee000  ! 3182: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r8
	.word 0xdcdfce60  ! 3183: LDXA_R	ldxa	[%r31, %r0] 0x73, %r14
	.word 0xd69d44a0  ! 3184: LDDA_R	ldda	[%r21, %r0] 0x25, %r11
	mov	0x60, %r16
	.word 0xdcbf0e60  ! 3186: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	mov	0x3d0, %r21
	mov	0x38, %r18
	.word 0xdabee000  ! 3189: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	.word 0xd09f8e60  ! 3190: LDDA_R	ldda	[%r30, %r0] 0x73, %r8
	.word 0xdcaf4e60  ! 3191: STBA_R	stba	%r14, [%r29 + %r0] 0x73
	.word 0xd0df8e80  ! 3192: LDXA_R	ldxa	[%r30, %r0] 0x74, %r8
	.word 0x87802074  ! 3193: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e8, %r21
	mov	0x18, %r24
	.word 0xdeb4e000  ! 3196: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 3197: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r18
	.word 0xd28f0e80  ! 3199: LDUBA_R	lduba	[%r28, %r0] 0x74, %r9
	.word 0xd2d40400  ! 3200: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	.word 0xd69d44a0  ! 3201: LDDA_R	ldda	[%r21, %r0] 0x25, %r11
	mov	0x8, %r17
	mov	0x38, %r25
	.word 0x87802073  ! 3204: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b7e000  ! 3205: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0xd09f6000  ! 3206: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	.word 0xd89609e0  ! 3207: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r12
	.word 0xd0c7ce60  ! 3208: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r8
	.word 0xd2d40400  ! 3209: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	.word 0xd6bc4400  ! 3210: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	.word 0x87802073  ! 3211: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3212: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb74e40  ! 3213: STHA_R	stha	%r14, [%r29 + %r0] 0x72
	.word 0x87802073  ! 3214: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0bc0400  ! 3215: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0xd8bf0e40  ! 3216: STDA_R	stda	%r12, [%r28 + %r0] 0x72
	.word 0x8780204f  ! 3217: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc946000  ! 3218: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r14
	mov	0x3c8, %r23
	mov	0x20, %r16
	mov	0x3d8, %r23
	mov	0x7f8, %r21
	.word 0x87802020  ! 3223: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3224: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3225: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcce6000  ! 3226: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r14
	.word 0xd2a70e80  ! 3227: STWA_R	stwa	%r9, [%r28 + %r0] 0x74
	.word 0xd4b6a000  ! 3228: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	.word 0x87802074  ! 3229: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 3230: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r17
	.word 0xd0c78e60  ! 3232: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r8
	.word 0xd4dfe000  ! 3233: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4bfa000  ! 3234: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd48584a0  ! 3235: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r10
	mov	0x48, %r25
	.word 0x87802072  ! 3237: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 3238: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r16
	.word 0xd6b4a000  ! 3240: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd8d689e0  ! 3241: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r12
	.word 0xd6a6c9e0  ! 3242: STWA_R	stwa	%r11, [%r27 + %r0] 0x4f
	.word 0xdef70e40  ! 3243: STXA_R	stxa	%r15, [%r28 + %r0] 0x72
	.word 0x87802025  ! 3244: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a40400  ! 3245: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0xd2f46000  ! 3246: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2aca000  ! 3247: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	mov	0x68, %r16
	mov	0x0, %r18
	.word 0x87802072  ! 3250: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 3251: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6d609e0  ! 3252: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r11
	mov	0x7f8, %r22
	mov	0x40, %r24
	.word 0xd29fa000  ! 3255: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd2972000  ! 3256: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xd2b7e000  ! 3257: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 3258: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28c6000  ! 3259: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0x87802074  ! 3260: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2c72000  ! 3261: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2b7e000  ! 3262: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd6b74e80  ! 3263: STHA_R	stha	%r11, [%r29 + %r0] 0x74
	.word 0xd6bc8400  ! 3264: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xd0dfce80  ! 3265: LDXA_R	ldxa	[%r31, %r0] 0x74, %r8
	.word 0xd6afe000  ! 3266: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd6c76000  ! 3267: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xdcc689e0  ! 3268: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r14
	.word 0xdad72000  ! 3269: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0xda976000  ! 3270: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	.word 0xd08d44a0  ! 3271: LDUBA_R	lduba	[%r21, %r0] 0x25, %r8
	mov	0x60, %r16
	.word 0xdea7a000  ! 3273: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xd49d04a0  ! 3274: LDDA_R	ldda	[%r20, %r0] 0x25, %r10
	.word 0xd2d40400  ! 3275: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	.word 0xdca70e40  ! 3276: STWA_R	stwa	%r14, [%r28 + %r0] 0x72
	.word 0xdeb72000  ! 3277: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	mov	0x78, %r17
	.word 0xded7a000  ! 3279: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xd4b584a0  ! 3280: STHA_R	stha	%r10, [%r22 + %r0] 0x25
	.word 0xdcd72000  ! 3281: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xd8bfce40  ! 3282: STDA_R	stda	%r12, [%r31 + %r0] 0x72
	.word 0xd2bc4400  ! 3283: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0xdebfe000  ! 3284: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xde8f6000  ! 3285: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	.word 0x87802025  ! 3286: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e0, %r21
	.word 0x87802025  ! 3288: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdef72000  ! 3289: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 3290: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdecd2000  ! 3291: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r15
	mov	0x3d0, %r23
	.word 0xde8d6000  ! 3293: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r15
	mov	0x20, %r18
	.word 0x87802074  ! 3295: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f4c400  ! 3296: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd6cf0e40  ! 3297: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r11
	.word 0xdeaf2000  ! 3298: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xd89e09e0  ! 3299: LDDA_R	ldda	[%r24, %r0] 0x4f, %r12
	mov	0x48, %r27
	mov	0x7d0, %r21
	.word 0xda8d84a0  ! 3302: LDUBA_R	lduba	[%r22, %r0] 0x25, %r13
	.word 0xd6df8e60  ! 3303: LDXA_R	ldxa	[%r30, %r0] 0x73, %r11
	.word 0x8780204f  ! 3304: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd28ea000  ! 3305: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r9
	.word 0xd2862000  ! 3306: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r9
	.word 0xd2d544a0  ! 3307: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r9
	.word 0xdad62000  ! 3308: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r13
	.word 0xdac62000  ! 3309: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r13
	mov	0x48, %r18
	.word 0xd4bd04a0  ! 3311: STDA_R	stda	%r10, [%r20 + %r0] 0x25
	.word 0xdcd74e60  ! 3312: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r14
	.word 0xdeb6c9e0  ! 3313: STHA_R	stha	%r15, [%r27 + %r0] 0x4f
	.word 0xdc862000  ! 3314: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r14
	.word 0x87802072  ! 3315: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd084c400  ! 3316: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r8
	.word 0xd2f4a000  ! 3317: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0xd2aca000  ! 3318: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0xd6f7ce60  ! 3319: STXA_R	stxa	%r11, [%r31 + %r0] 0x73
	.word 0xdebce000  ! 3320: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xdec46000  ! 3321: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	.word 0xdcf70e60  ! 3322: STXA_R	stxa	%r14, [%r28 + %r0] 0x73
	.word 0xdc9fce40  ! 3323: LDDA_R	ldda	[%r31, %r0] 0x72, %r14
	mov	0x68, %r27
	.word 0xd2f46000  ! 3325: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2c4e000  ! 3326: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xd6878e60  ! 3327: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r11
	.word 0x87802020  ! 3328: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r27
	mov	0x3c8, %r20
	mov	0x7e0, %r20
	.word 0xd0bf8e80  ! 3332: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	mov	0x50, %r25
	.word 0xdeaca000  ! 3334: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xdea4a000  ! 3335: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xdebca000  ! 3336: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	mov	0x3c8, %r20
	mov	0x20, %r27
	mov	0x3e0, %r21
	.word 0xd296c9e0  ! 3340: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r9
	.word 0xd8a7ce60  ! 3341: STWA_R	stwa	%r12, [%r31 + %r0] 0x73
	.word 0x87802073  ! 3342: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcac2000  ! 3343: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0xd0a74e80  ! 3344: STWA_R	stwa	%r8, [%r29 + %r0] 0x74
	.word 0xdcbc2000  ! 3345: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xdcb42000  ! 3346: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 3347: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r25
	mov	0x7e0, %r20
	.word 0xd4a7ce60  ! 3350: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	.word 0xd6df4e40  ! 3351: LDXA_R	ldxa	[%r29, %r0] 0x72, %r11
	.word 0xdaaec9e0  ! 3352: STBA_R	stba	%r13, [%r27 + %r0] 0x4f
	.word 0xdcc56000  ! 3353: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r14
	.word 0xdcdda000  ! 3354: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r14
	mov	0x20, %r24
	.word 0xdcbda000  ! 3356: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	mov	0x7f8, %r21
	mov	0x8, %r25
	.word 0xd89fce60  ! 3359: LDDA_R	ldda	[%r31, %r0] 0x73, %r12
	.word 0xd4dcc400  ! 3360: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0xd4dd2000  ! 3361: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r10
	.word 0xd4f56000  ! 3362: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	.word 0xd4ade000  ! 3363: STBA_I	stba	%r10, [%r23 + 0x0000] %asi
	mov	0x18, %r27
	.word 0xd4afce80  ! 3365: STBA_R	stba	%r10, [%r31 + %r0] 0x74
	mov	0x0, %r16
	mov	0x10, %r16
	.word 0xd6bda000  ! 3368: STDA_I	stda	%r11, [%r22 + 0x0000] %asi
	.word 0xd2cfce40  ! 3369: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r9
	.word 0x87802020  ! 3370: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49ea000  ! 3371: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	mov	0x68, %r24
	.word 0xd4f6e000  ! 3373: STXA_I	stxa	%r10, [%r27 + 0x0000] %asi
	.word 0xd4a6a000  ! 3374: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	mov	0x40, %r24
	.word 0xd2acc400  ! 3376: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0x87802073  ! 3377: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r24
	.word 0xd0d78e80  ! 3379: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r8
	.word 0xda9c6000  ! 3380: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xdaa4c400  ! 3381: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0x87802020  ! 3382: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49dc4a0  ! 3383: LDDA_R	ldda	[%r23, %r0] 0x25, %r10
	.word 0xd0bc6000  ! 3384: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	mov	0x18, %r16
	.word 0xd0c504a0  ! 3386: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r8
	.word 0xded4a000  ! 3387: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	mov	0x0, %r25
	.word 0xdebc2000  ! 3389: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	mov	0x3c8, %r22
	mov	0x18, %r26
	.word 0xdedc2000  ! 3392: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r15
	mov	0x3e0, %r23
	mov	0x58, %r19
	mov	0x70, %r24
	.word 0xd4870e60  ! 3396: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r10
	.word 0xdcbec9e0  ! 3397: STDA_R	stda	%r14, [%r27 + %r0] 0x4f
	.word 0xd4a44400  ! 3398: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xdadec9e0  ! 3399: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r13
	mov	0x7c8, %r23
	mov	0x78, %r17
	mov	0x68, %r17
	.word 0xd4b74e60  ! 3403: STHA_R	stha	%r10, [%r29 + %r0] 0x73
	.word 0x87802074  ! 3404: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf5a000  ! 3405: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0x87802073  ! 3406: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdadda000  ! 3407: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r13
	mov	0x50, %r19
	.word 0xdabda000  ! 3409: STDA_I	stda	%r13, [%r22 + 0x0000] %asi
	mov	0x70, %r24
	mov	0x7f8, %r22
	.word 0xdadda000  ! 3412: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r13
	.word 0xd6b78e40  ! 3413: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	mov	0x38, %r16
	.word 0xd0dd2000  ! 3415: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0xd4ac4400  ! 3416: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xdebc0400  ! 3417: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0xd8b4c400  ! 3418: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0xd6b40400  ! 3419: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xd4b56000  ! 3420: STHA_I	stha	%r10, [%r21 + 0x0000] %asi
	.word 0xd4a5e000  ! 3421: STWA_I	stwa	%r10, [%r23 + 0x0000] %asi
	.word 0xd0afce40  ! 3422: STBA_R	stba	%r8, [%r31 + %r0] 0x72
	.word 0xd2dc8400  ! 3423: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0xd8b52000  ! 3424: STHA_I	stha	%r12, [%r20 + 0x0000] %asi
	.word 0xd8d649e0  ! 3425: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r12
	.word 0xdac74e60  ! 3426: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r13
	mov	0x3d0, %r22
	mov	0x60, %r16
	.word 0xd4dfce40  ! 3429: LDXA_R	ldxa	[%r31, %r0] 0x72, %r10
	mov	0x78, %r27
	.word 0x87802020  ! 3431: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c5c4a0  ! 3432: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r10
	.word 0x87802020  ! 3433: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 3434: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2f76000  ! 3435: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xd2bfa000  ! 3436: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	mov	0x7d0, %r22
	.word 0xd8bf4e60  ! 3438: STDA_R	stda	%r12, [%r29 + %r0] 0x73
	mov	0x60, %r16
	.word 0xd0b4c400  ! 3440: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0xdcbc8400  ! 3441: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xdebf2000  ! 3442: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xd8a544a0  ! 3443: STWA_R	stwa	%r12, [%r21 + %r0] 0x25
	.word 0x87802020  ! 3444: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 3445: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r27
	.word 0xdca52000  ! 3447: STWA_I	stwa	%r14, [%r20 + 0x0000] %asi
	.word 0xde9544a0  ! 3448: LDUHA_R	lduha	[%r21, %r0] 0x25, %r15
	.word 0xdea44400  ! 3449: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xd2d70e60  ! 3450: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r9
	.word 0xdcad6000  ! 3451: STBA_I	stba	%r14, [%r21 + 0x0000] %asi
	.word 0x87802073  ! 3452: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf7a000  ! 3453: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 3454: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r17
	mov	0x10, %r18
	.word 0xdcafe000  ! 3457: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdc9f6000  ! 3458: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0x87802025  ! 3459: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 3460: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb4a000  ! 3461: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	mov	0x50, %r27
	.word 0xdcd46000  ! 3463: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	mov	0x7f8, %r21
	.word 0x87802073  ! 3465: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcc74e80  ! 3466: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r14
	.word 0xd8d40400  ! 3467: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	.word 0xd28fa000  ! 3468: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	.word 0xd2dfce40  ! 3469: LDXA_R	ldxa	[%r31, %r0] 0x72, %r9
	.word 0xd2a70e40  ! 3470: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	.word 0xd8bdc4a0  ! 3471: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	.word 0xda9fe000  ! 3472: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xdaafa000  ! 3473: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 3474: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda8f6000  ! 3475: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	mov	0x60, %r18
	mov	0x30, %r16
	mov	0x18, %r19
	.word 0xdaaf6000  ! 3479: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xd28689e0  ! 3480: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r9
	.word 0xd8f78e40  ! 3481: STXA_R	stxa	%r12, [%r30 + %r0] 0x72
	.word 0xd6bcc400  ! 3482: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	mov	0x8, %r25
	.word 0xd88f2000  ! 3484: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0xd8c7a000  ! 3485: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xd0dec9e0  ! 3486: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r8
	mov	0x18, %r24
	.word 0xd0df2000  ! 3488: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0xde974e60  ! 3489: LDUHA_R	lduha	[%r29, %r0] 0x73, %r15
	.word 0x87802073  ! 3490: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2af0e40  ! 3491: STBA_R	stba	%r9, [%r28 + %r0] 0x72
	.word 0xdecfce40  ! 3492: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r15
	.word 0xd6bfce80  ! 3493: STDA_R	stda	%r11, [%r31 + %r0] 0x74
	.word 0xdcf42000  ! 3494: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0xdcd4a000  ! 3495: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	.word 0xd2acc400  ! 3496: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0xd2b78e40  ! 3497: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	.word 0x87802025  ! 3498: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4bc6000  ! 3499: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xd494e000  ! 3500: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	.word 0xd4c4a000  ! 3501: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	mov	0x7e0, %r23
	.word 0x87802020  ! 3503: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdead04a0  ! 3504: STBA_R	stba	%r15, [%r20 + %r0] 0x25
	.word 0xdac70e40  ! 3505: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r13
	.word 0x87802025  ! 3506: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc9c0400  ! 3507: LDDA_R	ldda	[%r16, %r0] 0x20, %r14
	mov	0x7d8, %r21
	.word 0xdc9f0e60  ! 3509: LDDA_R	ldda	[%r28, %r0] 0x73, %r14
	.word 0x87802074  ! 3510: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdec42000  ! 3511: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0xd0bc8400  ! 3512: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	mov	0x10, %r27
	mov	0x60, %r18
	.word 0xd8a48400  ! 3515: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	.word 0xd48c6000  ! 3516: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r10
	.word 0xd4a4e000  ! 3517: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xded70e80  ! 3518: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r15
	.word 0xdecec9e0  ! 3519: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r15
	.word 0xdadec9e0  ! 3520: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r13
	.word 0xd4ae09e0  ! 3521: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0x87802025  ! 3522: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f4c400  ! 3523: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 3524: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r18
	.word 0xd6bfce40  ! 3526: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	.word 0xd68ce000  ! 3527: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	.word 0xdc9f8e60  ! 3528: LDDA_R	ldda	[%r30, %r0] 0x73, %r14
	.word 0xd0aca000  ! 3529: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xd0f42000  ! 3530: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0xd28fce40  ! 3531: LDUBA_R	lduba	[%r31, %r0] 0x72, %r9
	.word 0xdec4e000  ! 3532: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	.word 0xd2afce40  ! 3533: STBA_R	stba	%r9, [%r31 + %r0] 0x72
	.word 0xd88ca000  ! 3534: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	.word 0xd2d78e40  ! 3535: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r9
	mov	0x40, %r24
	mov	0x38, %r18
	.word 0xd09f0e40  ! 3538: LDDA_R	ldda	[%r28, %r0] 0x72, %r8
	mov	0x68, %r24
	.word 0xd68c8400  ! 3540: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	.word 0xdaf42000  ! 3541: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xdab4e000  ! 3543: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xdaae89e0  ! 3544: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	.word 0xda8ca000  ! 3545: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r13
	.word 0xda94e000  ! 3546: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r13
	.word 0xdaf46000  ! 3547: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	mov	0x70, %r16
	.word 0xd6b6c9e0  ! 3549: STHA_R	stha	%r11, [%r27 + %r0] 0x4f
	.word 0xd0a74e80  ! 3550: STWA_R	stwa	%r8, [%r29 + %r0] 0x74
	.word 0xd2b46000  ! 3551: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0xd8a44400  ! 3552: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xd0bc6000  ! 3553: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	.word 0xdedec9e0  ! 3554: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r15
	mov	0x58, %r25
	mov	0x78, %r17
	.word 0xd28c2000  ! 3557: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xd2cce000  ! 3558: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	mov	0x7c8, %r20
	.word 0xd2dc2000  ! 3560: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r9
	.word 0xd2ac6000  ! 3561: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd29f0e80  ! 3562: LDDA_R	ldda	[%r28, %r0] 0x74, %r9
	.word 0xd48f4e40  ! 3563: LDUBA_R	lduba	[%r29, %r0] 0x72, %r10
	.word 0xda94e000  ! 3564: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3565: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda870e80  ! 3566: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r13
	.word 0xdadca000  ! 3567: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0xd897ce40  ! 3568: LDUHA_R	lduha	[%r31, %r0] 0x72, %r12
	.word 0xd6848400  ! 3569: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	mov	0x20, %r25
	.word 0x87802020  ! 3571: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadc6000  ! 3572: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0x87802025  ! 3573: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e0, %r22
	.word 0xda8d6000  ! 3575: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r13
	.word 0xda956000  ! 3576: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r13
	.word 0xd0bf4e80  ! 3577: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	.word 0xd6d7ce80  ! 3578: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r11
	.word 0xd4956000  ! 3579: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r10
	.word 0xd0ac4400  ! 3580: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0xdc9584a0  ! 3581: LDUHA_R	lduha	[%r22, %r0] 0x25, %r14
	mov	0x20, %r27
	.word 0x87802072  ! 3583: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0c4c400  ! 3584: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	.word 0xdef48400  ! 3585: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xd8ace000  ! 3586: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0xd6c649e0  ! 3587: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r11
	.word 0x87802020  ! 3588: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r26
	.word 0xd0d72000  ! 3590: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0a7e000  ! 3591: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xd6878e60  ! 3592: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r11
	mov	0x28, %r16
	.word 0xd2876000  ! 3594: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	mov	0x68, %r25
	.word 0xd0f70e60  ! 3596: STXA_R	stxa	%r8, [%r28 + %r0] 0x73
	mov	0x28, %r26
	.word 0xd2bfce60  ! 3598: STDA_R	stda	%r9, [%r31 + %r0] 0x73
	.word 0x87802072  ! 3599: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd28584a0  ! 3600: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r9
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0dfce40  ! 3602: LDXA_R	ldxa	[%r31, %r0] 0x72, %r8
	.word 0xd49ca000  ! 3603: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xdeae49e0  ! 3604: STBA_R	stba	%r15, [%r25 + %r0] 0x4f
	.word 0xdaac2000  ! 3605: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0xd88584a0  ! 3606: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r12
	.word 0x87802072  ! 3607: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbc8400  ! 3608: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 3609: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 3610: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd28d84a0  ! 3611: LDUBA_R	lduba	[%r22, %r0] 0x25, %r9
	.word 0xd0b70e80  ! 3612: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	mov	0x3d8, %r21
	.word 0xdec7a000  ! 3614: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xdecfe000  ! 3615: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xdaf7ce60  ! 3616: STXA_R	stxa	%r13, [%r31 + %r0] 0x73
	.word 0x87802025  ! 3617: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6940400  ! 3618: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	.word 0xdcf78e60  ! 3619: STXA_R	stxa	%r14, [%r30 + %r0] 0x73
	.word 0xdcf48400  ! 3620: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	mov	0x3d8, %r21
	.word 0xd8946000  ! 3622: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	mov	0x58, %r25
	.word 0xd6c504a0  ! 3624: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r11
	.word 0xd4c70e40  ! 3625: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r10
	mov	0x3f0, %r23
	.word 0xdeae49e0  ! 3627: STBA_R	stba	%r15, [%r25 + %r0] 0x4f
	.word 0xd4af4e80  ! 3628: STBA_R	stba	%r10, [%r29 + %r0] 0x74
	.word 0xdc9c4400  ! 3629: LDDA_R	ldda	[%r17, %r0] 0x20, %r14
	.word 0xd6f78e80  ! 3630: STXA_R	stxa	%r11, [%r30 + %r0] 0x74
	.word 0xd0a46000  ! 3631: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xd0a4e000  ! 3633: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0be89e0  ! 3634: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 3635: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3636: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd497a000  ! 3637: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0xd4a72000  ! 3638: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd2acc400  ! 3639: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0xd2a72000  ! 3640: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0xdcae49e0  ! 3641: STBA_R	stba	%r14, [%r25 + %r0] 0x4f
	mov	0x3c8, %r22
	.word 0xd8f5c4a0  ! 3643: STXA_R	stxa	%r12, [%r23 + %r0] 0x25
	.word 0xda8f6000  ! 3644: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0x87802074  ! 3645: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r16
	.word 0xdab6e000  ! 3647: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	.word 0x87802072  ! 3648: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdad70e80  ! 3649: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r13
	.word 0xd4ac0400  ! 3650: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xd4f76000  ! 3651: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 3652: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd88cc400  ! 3653: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	mov	0x8, %r27
	.word 0x87802025  ! 3655: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r16
	.word 0x87802074  ! 3657: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f46000  ! 3658: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8dca000  ! 3659: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	.word 0xd8b4e000  ! 3660: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0xdc85c4a0  ! 3661: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r14
	.word 0xd8cd44a0  ! 3662: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r12
	.word 0xd8aca000  ! 3663: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 3664: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6bd04a0  ! 3665: STDA_R	stda	%r11, [%r20 + %r0] 0x25
	.word 0xd8a46000  ! 3666: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0xd8f46000  ! 3668: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3669: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcc4c400  ! 3670: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	.word 0xd2a76000  ! 3671: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xde94c400  ! 3672: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	.word 0xd0b72000  ! 3673: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd0df2000  ! 3674: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0x87802073  ! 3675: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r25
	.word 0xd0b78e40  ! 3677: STHA_R	stha	%r8, [%r30 + %r0] 0x72
	.word 0x87802073  ! 3678: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdadee000  ! 3679: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r13
	.word 0xdcf70e80  ! 3680: STXA_R	stxa	%r14, [%r28 + %r0] 0x74
	mov	0x7f8, %r21
	.word 0xd8ac8400  ! 3682: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0xdedea000  ! 3683: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r15
	.word 0xd69d44a0  ! 3684: LDDA_R	ldda	[%r21, %r0] 0x25, %r11
	.word 0xd0f62000  ! 3685: STXA_I	stxa	%r8, [%r24 + 0x0000] %asi
	.word 0x87802074  ! 3686: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b7ce40  ! 3687: STHA_R	stha	%r11, [%r31 + %r0] 0x72
	.word 0xd2d7e000  ! 3688: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	mov	0x7f8, %r20
	mov	0x3c8, %r22
	.word 0xd2afe000  ! 3691: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd28f6000  ! 3692: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3693: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bfe000  ! 3694: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xd294c400  ! 3696: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	mov	0x78, %r25
	.word 0xd8c72000  ! 3698: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd09e09e0  ! 3699: LDDA_R	ldda	[%r24, %r0] 0x4f, %r8
	.word 0xd0b76000  ! 3700: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd0c72000  ! 3701: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xd69f4e60  ! 3702: LDDA_R	ldda	[%r29, %r0] 0x73, %r11
	.word 0xd89f4e80  ! 3703: LDDA_R	ldda	[%r29, %r0] 0x74, %r12
	mov	0x38, %r25
	.word 0xd6cc4400  ! 3705: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	mov	0x60, %r27
	.word 0xd4be09e0  ! 3707: STDA_R	stda	%r10, [%r24 + %r0] 0x4f
	.word 0xdcd72000  ! 3708: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0x87802020  ! 3709: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd297ce60  ! 3710: LDUHA_R	lduha	[%r31, %r0] 0x73, %r9
	.word 0xd4b609e0  ! 3711: STHA_R	stha	%r10, [%r24 + %r0] 0x4f
	.word 0xd4b56000  ! 3712: STHA_I	stha	%r10, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 3713: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b689e0  ! 3714: STHA_R	stha	%r8, [%r26 + %r0] 0x4f
	mov	0x3c8, %r20
	.word 0x8780204f  ! 3716: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4dc0400  ! 3717: LDXA_R	ldxa	[%r16, %r0] 0x20, %r10
	.word 0xda9de000  ! 3718: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r13
	.word 0x87802025  ! 3719: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda9fa000  ! 3720: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xdea48400  ! 3721: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xda940400  ! 3722: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	.word 0xdad7ce40  ! 3723: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r13
	.word 0xd4a76000  ! 3724: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 3725: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd48f6000  ! 3726: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xdeacc400  ! 3727: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0x87802020  ! 3728: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6afce60  ! 3729: STBA_R	stba	%r11, [%r31 + %r0] 0x73
	.word 0xdedf2000  ! 3730: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	mov	0x48, %r25
	.word 0x87802074  ! 3732: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 3733: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 3734: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0948400  ! 3735: LDUHA_R	lduha	[%r18, %r0] 0x20, %r8
	mov	0x70, %r19
	.word 0x87802074  ! 3737: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r18
	.word 0xd2b7e000  ! 3739: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd29fe000  ! 3740: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xdcb48400  ! 3741: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xd8a7a000  ! 3742: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	mov	0x58, %r27
	.word 0xdab649e0  ! 3744: STHA_R	stha	%r13, [%r25 + %r0] 0x4f
	.word 0xd4b504a0  ! 3745: STHA_R	stha	%r10, [%r20 + %r0] 0x25
	.word 0xd4f76000  ! 3746: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd6af4e60  ! 3747: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	.word 0x87802025  ! 3748: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd49ec9e0  ! 3749: LDDA_R	ldda	[%r27, %r0] 0x4f, %r10
	.word 0xd4d7a000  ! 3750: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	mov	0x3f8, %r21
	.word 0xdaa74e60  ! 3752: STWA_R	stwa	%r13, [%r29 + %r0] 0x73
	.word 0xd4cc8400  ! 3753: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	.word 0xd0af6000  ! 3754: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xdaf609e0  ! 3755: STXA_R	stxa	%r13, [%r24 + %r0] 0x4f
	.word 0xd8d44400  ! 3756: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	.word 0xdc9f4e60  ! 3757: LDDA_R	ldda	[%r29, %r0] 0x73, %r14
	.word 0xd6afe000  ! 3758: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x3c0, %r23
	.word 0xdadcc400  ! 3760: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0x87802073  ! 3761: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r17
	.word 0xdaa70e60  ! 3763: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	.word 0xd08f0e60  ! 3764: LDUBA_R	lduba	[%r28, %r0] 0x73, %r8
	.word 0x87802072  ! 3765: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbce000  ! 3766: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	mov	0x0, %r25
	.word 0xdc9c2000  ! 3768: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r14
	.word 0x87802072  ! 3769: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb689e0  ! 3770: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	mov	0x38, %r27
	.word 0xdad76000  ! 3772: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3773: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf7e000  ! 3774: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	mov	0x60, %r24
	mov	0x0, %r27
	.word 0xd0cf8e80  ! 3777: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r8
	.word 0xd6a76000  ! 3778: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xd6b72000  ! 3780: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	mov	0x48, %r26
	.word 0xd8a48400  ! 3782: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	.word 0xde8f2000  ! 3783: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xd4a70e80  ! 3784: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	.word 0xdaa4c400  ! 3785: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0xdebfe000  ! 3786: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	mov	0x40, %r26
	.word 0xdecfa000  ! 3788: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xdaf504a0  ! 3789: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	.word 0xd0bf4e60  ! 3790: STDA_R	stda	%r8, [%r29 + %r0] 0x73
	.word 0xdac76000  ! 3791: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0xd4b40400  ! 3792: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	mov	0x60, %r25
	.word 0xd2b76000  ! 3794: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2afe000  ! 3795: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd88e89e0  ! 3796: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r12
	.word 0xd8b74e60  ! 3797: STHA_R	stha	%r12, [%r29 + %r0] 0x73
	.word 0xd8d76000  ! 3798: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	mov	0x58, %r27
	.word 0xd8dfe000  ! 3800: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	mov	0x10, %r17
	.word 0xd8976000  ! 3802: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0xd8bfa000  ! 3803: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xdcf6c9e0  ! 3804: STXA_R	stxa	%r14, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 3805: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b544a0  ! 3806: STHA_R	stha	%r10, [%r21 + %r0] 0x25
	.word 0xd6d72000  ! 3807: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r11
	.word 0xdaac8400  ! 3808: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	mov	0x60, %r19
	.word 0xde9f0e60  ! 3810: LDDA_R	ldda	[%r28, %r0] 0x73, %r15
	mov	0x7d8, %r21
	.word 0xdaa76000  ! 3812: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xde9f4e60  ! 3813: LDDA_R	ldda	[%r29, %r0] 0x73, %r15
	.word 0xd6c7e000  ! 3814: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6972000  ! 3815: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	.word 0xd6bf6000  ! 3816: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd6b7e000  ! 3817: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd6b76000  ! 3818: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd6872000  ! 3819: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd687a000  ! 3820: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6bfe000  ! 3821: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xdab78e80  ! 3822: STHA_R	stha	%r13, [%r30 + %r0] 0x74
	.word 0xdebd04a0  ! 3823: STDA_R	stda	%r15, [%r20 + %r0] 0x25
	.word 0xd6bfe000  ! 3824: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xd697e000  ! 3826: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0xdab584a0  ! 3827: STHA_R	stha	%r13, [%r22 + %r0] 0x25
	.word 0xdcf40400  ! 3828: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xd89fe000  ! 3829: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0xd89f2000  ! 3830: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	mov	0x48, %r27
	mov	0x3c8, %r23
	mov	0x7c8, %r23
	.word 0xd2d44400  ! 3834: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r9
	mov	0x68, %r18
	.word 0xd8cfe000  ! 3836: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xd89fe000  ! 3837: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0xde848400  ! 3838: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	.word 0xde9fe000  ! 3839: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0xdeb7a000  ! 3840: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xd6cc8400  ! 3841: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	mov	0x10, %r17
	mov	0x50, %r18
	.word 0xd6bf8e80  ! 3844: STDA_R	stda	%r11, [%r30 + %r0] 0x74
	.word 0xd696c9e0  ! 3845: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r11
	.word 0xd4aec9e0  ! 3846: STBA_R	stba	%r10, [%r27 + %r0] 0x4f
	.word 0xd8c7ce60  ! 3847: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r12
	.word 0xd4f7ce80  ! 3848: STXA_R	stxa	%r10, [%r31 + %r0] 0x74
	.word 0xdaaf6000  ! 3849: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xdaf72000  ! 3850: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdab7e000  ! 3851: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xda8f2000  ! 3852: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xdeae09e0  ! 3853: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	.word 0xd8b72000  ! 3854: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xdedc0400  ! 3855: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	.word 0xd8b76000  ! 3856: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd2bfce60  ! 3857: STDA_R	stda	%r9, [%r31 + %r0] 0x73
	.word 0x87802020  ! 3858: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ac6000  ! 3859: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xd884a000  ! 3860: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r12
	mov	0x50, %r17
	.word 0x8780204f  ! 3862: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9f8e40  ! 3863: LDDA_R	ldda	[%r30, %r0] 0x72, %r13
	.word 0xdaa4e000  ! 3864: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 3865: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9c2000  ! 3866: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	.word 0xd8d78e80  ! 3867: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r12
	.word 0x87802025  ! 3868: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e8, %r20
	.word 0x8780204f  ! 3870: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4ac2000  ! 3871: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0xd49ca000  ! 3872: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd69609e0  ! 3873: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r11
	.word 0x87802072  ! 3874: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a7ce40  ! 3875: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	.word 0xdcbca000  ! 3876: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdcace000  ! 3877: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0xdcb42000  ! 3878: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 3879: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbf8e60  ! 3880: STDA_R	stda	%r14, [%r30 + %r0] 0x73
	.word 0xdcf40400  ! 3881: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xd68c4400  ! 3882: LDUBA_R	lduba	[%r17, %r0] 0x20, %r11
	.word 0xdeb7ce40  ! 3883: STHA_R	stha	%r15, [%r31 + %r0] 0x72
	.word 0xd69fe000  ! 3884: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	mov	0x38, %r16
	.word 0xd884c400  ! 3886: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	.word 0xd8b689e0  ! 3887: STHA_R	stha	%r12, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 3888: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6be09e0  ! 3889: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	.word 0xd887a000  ! 3890: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xd6f4c400  ! 3891: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0xde9f8e40  ! 3892: LDDA_R	ldda	[%r30, %r0] 0x72, %r15
	mov	0x3f0, %r22
	mov	0x48, %r18
	.word 0xd69f4e40  ! 3895: LDDA_R	ldda	[%r29, %r0] 0x72, %r11
	.word 0xd8df2000  ! 3896: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xdcbdc4a0  ! 3897: STDA_R	stda	%r14, [%r23 + %r0] 0x25
	.word 0xdecfce80  ! 3898: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r15
	.word 0xdca7a000  ! 3899: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcbfe000  ! 3900: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdcf76000  ! 3901: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcf7e000  ! 3902: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xd6cd44a0  ! 3903: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r11
	.word 0xd49f8e60  ! 3904: LDDA_R	ldda	[%r30, %r0] 0x73, %r10
	.word 0xd4976000  ! 3905: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r10
	.word 0xdc8dc4a0  ! 3906: LDUBA_R	lduba	[%r23, %r0] 0x25, %r14
	mov	0x60, %r18
	.word 0x87802020  ! 3908: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r19
	.word 0x87802072  ! 3910: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 3911: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bfce80  ! 3912: STDA_R	stda	%r9, [%r31 + %r0] 0x74
	.word 0x87802072  ! 3913: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda8da000  ! 3914: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r13
	.word 0xdaa5a000  ! 3915: STWA_I	stwa	%r13, [%r22 + 0x0000] %asi
	.word 0xdaade000  ! 3916: STBA_I	stba	%r13, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 3917: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc9584a0  ! 3918: LDUHA_R	lduha	[%r22, %r0] 0x25, %r14
	.word 0x87802073  ! 3919: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r24
	.word 0xdc8f4e60  ! 3921: LDUBA_R	lduba	[%r29, %r0] 0x73, %r14
	.word 0xd0afce60  ! 3922: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	.word 0xd897a000  ! 3923: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0xd4a504a0  ! 3924: STWA_R	stwa	%r10, [%r20 + %r0] 0x25
	mov	0x0, %r16
	.word 0xdedf0e60  ! 3926: LDXA_R	ldxa	[%r28, %r0] 0x73, %r15
	.word 0xdef504a0  ! 3927: STXA_R	stxa	%r15, [%r20 + %r0] 0x25
	.word 0xd2af8e40  ! 3928: STBA_R	stba	%r9, [%r30 + %r0] 0x72
	.word 0xdcaec9e0  ! 3929: STBA_R	stba	%r14, [%r27 + %r0] 0x4f
	.word 0xdef7a000  ! 3930: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xde87a000  ! 3931: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xd28f4e40  ! 3932: LDUBA_R	lduba	[%r29, %r0] 0x72, %r9
	mov	0x38, %r17
	.word 0xde8f0e60  ! 3934: LDUBA_R	lduba	[%r28, %r0] 0x73, %r15
	.word 0xdcb7e000  ! 3935: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	mov	0x48, %r17
	mov	0x28, %r26
	.word 0xd8cfce80  ! 3938: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r12
	.word 0xd6a74e80  ! 3939: STWA_R	stwa	%r11, [%r29 + %r0] 0x74
	.word 0xdcb78e80  ! 3940: STHA_R	stha	%r14, [%r30 + %r0] 0x74
	mov	0x40, %r25
	.word 0xdc8f4e60  ! 3942: LDUBA_R	lduba	[%r29, %r0] 0x73, %r14
	.word 0xde9f6000  ! 3943: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3944: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3945: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r17
	mov	0x40, %r26
	.word 0xd48fce40  ! 3948: LDUBA_R	lduba	[%r31, %r0] 0x72, %r10
	.word 0xd6bc2000  ! 3949: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 3950: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdab4c400  ! 3951: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 3952: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9544a0  ! 3953: LDUHA_R	lduha	[%r21, %r0] 0x25, %r13
	mov	0x3e8, %r22
	mov	0x30, %r16
	.word 0xd2df2000  ! 3956: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3957: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2872000  ! 3958: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2972000  ! 3959: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	mov	0x50, %r18
	.word 0xd8df4e40  ! 3961: LDXA_R	ldxa	[%r29, %r0] 0x72, %r12
	.word 0xdaa72000  ! 3962: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xdacfa000  ! 3963: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xd0dc8400  ! 3964: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0xd0bf8e60  ! 3965: STDA_R	stda	%r8, [%r30 + %r0] 0x73
	.word 0x87802074  ! 3966: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r19
	.word 0xd087a000  ! 3968: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	mov	0x70, %r24
	.word 0xd0afa000  ! 3970: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd2f7ce80  ! 3971: STXA_R	stxa	%r9, [%r31 + %r0] 0x74
	mov	0x20, %r16
	.word 0xd8f72000  ! 3973: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xda848400  ! 3974: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r13
	.word 0xd68fe000  ! 3975: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xd6af2000  ! 3976: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd6876000  ! 3977: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6bfa000  ! 3978: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd6a76000  ! 3979: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd094c400  ! 3980: LDUHA_R	lduha	[%r19, %r0] 0x20, %r8
	mov	0x3c0, %r22
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802020  ! 3983: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a504a0  ! 3984: STWA_R	stwa	%r12, [%r20 + %r0] 0x25
	mov	0x7e8, %r22
	.word 0xded72000  ! 3986: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0x87802074  ! 3987: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xded42000  ! 3988: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	.word 0xdeace000  ! 3989: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	mov	0x68, %r17
	.word 0xdec4e000  ! 3991: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	.word 0x87802074  ! 3992: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdec48400  ! 3993: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	.word 0xdcb42000  ! 3994: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xd4f649e0  ! 3995: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	mov	0x48, %r26
	.word 0xd0f74e60  ! 3997: STXA_R	stxa	%r8, [%r29 + %r0] 0x73
	.word 0xda87ce60  ! 3998: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r13
	.word 0xd284a000  ! 3999: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	mov	0x7d0, %r21
	mov	0x50, %r17
	.word 0xd2ac2000  ! 4002: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd2dc2000  ! 4003: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r9
	.word 0xd2ace000  ! 4004: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xdab70e80  ! 4006: STHA_R	stha	%r13, [%r28 + %r0] 0x74
	.word 0xdeaf0e60  ! 4007: STBA_R	stba	%r15, [%r28 + %r0] 0x73
	.word 0xd8842000  ! 4008: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	mov	0x38, %r16
	.word 0xd8a42000  ! 4010: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8ace000  ! 4011: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	mov	0x3f0, %r22
	mov	0x58, %r17
	.word 0xd08f0e60  ! 4014: LDUBA_R	lduba	[%r28, %r0] 0x73, %r8
	.word 0xd6f4e000  ! 4015: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	.word 0xd8c44400  ! 4016: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r12
	mov	0x60, %r17
	mov	0x18, %r24
	.word 0xdaacc400  ! 4019: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0xdaac2000  ! 4020: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	mov	0x18, %r24
	mov	0x10, %r27
	.word 0xd28e89e0  ! 4023: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r9
	mov	0x48, %r18
	.word 0xd0a78e40  ! 4025: STWA_R	stwa	%r8, [%r30 + %r0] 0x72
	.word 0x87802073  ! 4026: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6944400  ! 4027: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	.word 0xd09f8e60  ! 4028: LDDA_R	ldda	[%r30, %r0] 0x73, %r8
	.word 0xdcdf0e40  ! 4029: LDXA_R	ldxa	[%r28, %r0] 0x72, %r14
	.word 0xd8862000  ! 4030: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r12
	.word 0xd2dc4400  ! 4031: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xd28f4e80  ! 4032: LDUBA_R	lduba	[%r29, %r0] 0x74, %r9
	.word 0xd69ee000  ! 4033: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r11
	.word 0xd6f6e000  ! 4034: STXA_I	stxa	%r11, [%r27 + 0x0000] %asi
	.word 0xd6bee000  ! 4035: STDA_I	stda	%r11, [%r27 + 0x0000] %asi
	.word 0xd6c649e0  ! 4036: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r11
	.word 0xd0b62000  ! 4037: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0xd0c6e000  ! 4039: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r8
	.word 0xd0c66000  ! 4040: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r8
	.word 0x87802074  ! 4041: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0afe000  ! 4042: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	mov	0x48, %r16
	.word 0xd0cfa000  ! 4044: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0xd4df4e40  ! 4045: LDXA_R	ldxa	[%r29, %r0] 0x72, %r10
	.word 0xd2bf8e60  ! 4046: STDA_R	stda	%r9, [%r30 + %r0] 0x73
	mov	0x38, %r18
	.word 0xd2afa000  ! 4048: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 4049: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d8, %r21
	.word 0xd2f66000  ! 4051: STXA_I	stxa	%r9, [%r25 + 0x0000] %asi
	mov	0x7e0, %r21
	.word 0xd2bd04a0  ! 4053: STDA_R	stda	%r9, [%r20 + %r0] 0x25
	.word 0xd4b6e000  ! 4054: STHA_I	stha	%r10, [%r27 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xd4a6a000  ! 4056: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	mov	0x3d8, %r21
	.word 0xd49e6000  ! 4058: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r10
	.word 0xdacec9e0  ! 4059: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r13
	.word 0xd8f5c4a0  ! 4060: STXA_R	stxa	%r12, [%r23 + %r0] 0x25
	.word 0xdece89e0  ! 4061: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r15
	.word 0xd8ae2000  ! 4062: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	.word 0xd6bd84a0  ! 4063: STDA_R	stda	%r11, [%r22 + %r0] 0x25
	.word 0xd88d04a0  ! 4064: LDUBA_R	lduba	[%r20, %r0] 0x25, %r12
	.word 0xdcaea000  ! 4065: STBA_I	stba	%r14, [%r26 + 0x0000] %asi
	.word 0xdc8ee000  ! 4066: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r14
	.word 0xdcd6e000  ! 4067: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r14
	.word 0xdcbc4400  ! 4068: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	mov	0x50, %r19
	.word 0x87802073  ! 4070: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r26
	.word 0xdc8fce80  ! 4072: LDUBA_R	lduba	[%r31, %r0] 0x74, %r14
	.word 0x87802072  ! 4073: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0f66000  ! 4074: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	.word 0xd08ee000  ! 4075: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r8
	.word 0xd0962000  ! 4076: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r8
	.word 0xd0966000  ! 4077: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r8
	.word 0xdcc544a0  ! 4078: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r14
	mov	0x50, %r17
	.word 0xd486e000  ! 4080: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	mov	0x7e0, %r22
	mov	0x60, %r19
	.word 0xdcb6c9e0  ! 4083: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	.word 0xd8d62000  ! 4084: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r12
	mov	0x50, %r24
	.word 0xd88e6000  ! 4086: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r12
	.word 0xd8bea000  ! 4087: STDA_I	stda	%r12, [%r26 + 0x0000] %asi
	.word 0x8780204f  ! 4088: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8cf2000  ! 4089: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4090: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd89d2000  ! 4091: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r12
	.word 0xd4b40400  ! 4092: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0xd0cf4e80  ! 4093: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r8
	.word 0xd6c504a0  ! 4094: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r11
	mov	0x48, %r26
	.word 0xd8bd2000  ! 4096: STDA_I	stda	%r12, [%r20 + 0x0000] %asi
	mov	0x60, %r19
	mov	0x38, %r17
	.word 0xd8ade000  ! 4099: STBA_I	stba	%r12, [%r23 + 0x0000] %asi
	mov	0x30, %r18
	.word 0x87802072  ! 4101: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b72000  ! 4102: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd0a4c400  ! 4103: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xd0c72000  ! 4104: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	mov	0x30, %r26
	mov	0x30, %r26
	.word 0x87802025  ! 4107: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd08f6000  ! 4108: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r8
	.word 0xdcb48400  ! 4109: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	mov	0x7d0, %r21
	.word 0xde978e60  ! 4111: LDUHA_R	lduha	[%r30, %r0] 0x73, %r15
	mov	0x50, %r27
	.word 0xd2ad84a0  ! 4113: STBA_R	stba	%r9, [%r22 + %r0] 0x25
	.word 0xd4bf8e40  ! 4114: STDA_R	stda	%r10, [%r30 + %r0] 0x72
	.word 0xd8d70e60  ! 4115: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r12
	.word 0xdaf689e0  ! 4116: STXA_R	stxa	%r13, [%r26 + %r0] 0x4f
	.word 0xd2ccc400  ! 4117: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	.word 0xdad48400  ! 4118: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0xde976000  ! 4119: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	mov	0x68, %r24
	.word 0xdabf0e80  ! 4121: STDA_R	stda	%r13, [%r28 + %r0] 0x74
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802025  ! 4123: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 4124: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bf4e80  ! 4125: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	.word 0x87802020  ! 4126: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f40400  ! 4127: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	.word 0x87802025  ! 4128: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 4129: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc8fe000  ! 4130: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4131: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c4c400  ! 4132: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r11
	.word 0xdeacc400  ! 4133: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	mov	0x20, %r25
	mov	0x60, %r26
	.word 0xd2a70e60  ! 4136: STWA_R	stwa	%r9, [%r28 + %r0] 0x73
	mov	0x50, %r24
	.word 0xdeac0400  ! 4138: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xdedca000  ! 4139: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xdcb7ce40  ! 4140: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	mov	0x10, %r17
	.word 0xd0bc2000  ! 4142: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	.word 0xd0d46000  ! 4143: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r8
	mov	0x7e8, %r21
	.word 0xd0a46000  ! 4145: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xd2c649e0  ! 4146: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r9
	.word 0x87802020  ! 4147: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f74e80  ! 4148: STXA_R	stxa	%r9, [%r29 + %r0] 0x74
	.word 0xd6cf0e80  ! 4149: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r11
	mov	0x78, %r25
	mov	0x7f8, %r20
	.word 0xd8d7a000  ! 4152: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0x87802025  ! 4153: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8c5a000  ! 4154: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r12
	mov	0x58, %r26
	mov	0x78, %r26
	mov	0x70, %r26
	.word 0xd0c44400  ! 4158: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r8
	.word 0xdc95a000  ! 4159: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r14
	.word 0xd48f4e80  ! 4160: LDUBA_R	lduba	[%r29, %r0] 0x74, %r10
	.word 0xd297ce60  ! 4161: LDUHA_R	lduha	[%r31, %r0] 0x73, %r9
	.word 0xd8df8e80  ! 4162: LDXA_R	ldxa	[%r30, %r0] 0x74, %r12
	.word 0xd29544a0  ! 4163: LDUHA_R	lduha	[%r21, %r0] 0x25, %r9
	.word 0xdaa5e000  ! 4164: STWA_I	stwa	%r13, [%r23 + 0x0000] %asi
	.word 0xdad5a000  ! 4165: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r13
	.word 0xdacde000  ! 4166: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r13
	.word 0xda9da000  ! 4167: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4168: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r21
	.word 0xdcdd84a0  ! 4170: LDXA_R	ldxa	[%r22, %r0] 0x25, %r14
	.word 0x87802020  ! 4171: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcd74e40  ! 4172: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r14
	.word 0xd4ae49e0  ! 4173: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0xd4b76000  ! 4174: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd4a7a000  ! 4175: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4872000  ! 4176: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0x87802074  ! 4177: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r18
	.word 0xd4a4e000  ! 4179: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xd8dc8400  ! 4180: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0x87802025  ! 4181: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebe2000  ! 4182: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	.word 0x87802074  ! 4183: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde8de000  ! 4184: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r15
	.word 0xdeade000  ! 4185: STBA_I	stba	%r15, [%r23 + 0x0000] %asi
	mov	0x38, %r18
	.word 0xde9d2000  ! 4187: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r15
	.word 0xd0f44400  ! 4188: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0x87802020  ! 4189: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa5e000  ! 4190: STWA_I	stwa	%r13, [%r23 + 0x0000] %asi
	.word 0xd697ce60  ! 4191: LDUHA_R	lduha	[%r31, %r0] 0x73, %r11
	mov	0x3f0, %r23
	.word 0xded5e000  ! 4193: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r15
	.word 0xdeb56000  ! 4194: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 4195: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd49649e0  ! 4196: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r10
	.word 0xd2f74e60  ! 4197: STXA_R	stxa	%r9, [%r29 + %r0] 0x73
	.word 0xdec74e60  ! 4198: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r15
	.word 0x87802020  ! 4199: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab7e000  ! 4200: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xda9f0e80  ! 4201: LDDA_R	ldda	[%r28, %r0] 0x74, %r13
	.word 0xd4cfce60  ! 4202: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r10
	mov	0x28, %r16
	.word 0xda870e80  ! 4204: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r13
	.word 0x87802073  ! 4205: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0bea000  ! 4206: STDA_I	stda	%r8, [%r26 + 0x0000] %asi
	mov	0x30, %r24
	.word 0xd68689e0  ! 4208: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r11
	.word 0x87802074  ! 4209: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x70, %r24
	.word 0xd4df2000  ! 4212: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	mov	0x48, %r17
	.word 0xd4f72000  ! 4214: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd0bc4400  ! 4215: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xdcf40400  ! 4216: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	mov	0x7e8, %r20
	.word 0x87802073  ! 4218: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6d78e40  ! 4219: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r11
	.word 0x87802025  ! 4220: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xda97a000  ! 4222: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	mov	0x0, %r27
	.word 0xdcb78e60  ! 4224: STHA_R	stha	%r14, [%r30 + %r0] 0x73
	mov	0x7d8, %r21
	.word 0x87802074  ! 4226: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r22
	.word 0xdcc609e0  ! 4228: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r14
	.word 0xd097a000  ! 4229: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	mov	0x40, %r16
	.word 0xdeaf8e40  ! 4231: STBA_R	stba	%r15, [%r30 + %r0] 0x72
	mov	0x38, %r16
	mov	0x48, %r19
	.word 0xd087e000  ! 4234: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0d72000  ! 4235: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd087a000  ! 4236: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	mov	0x3c8, %r21
	mov	0x8, %r16
	.word 0xd0d7a000  ! 4239: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0xd0f7a000  ! 4240: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd6ce89e0  ! 4241: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r11
	.word 0x87802025  ! 4242: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4b44400  ! 4243: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	.word 0xd2ad2000  ! 4244: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0x8780204f  ! 4245: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2b609e0  ! 4246: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	.word 0xdab6c9e0  ! 4247: STHA_R	stha	%r13, [%r27 + %r0] 0x4f
	.word 0xd6a78e60  ! 4248: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	mov	0x30, %r25
	.word 0xda956000  ! 4250: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4251: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadfa000  ! 4252: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	mov	0x3f8, %r20
	.word 0xd6d74e60  ! 4254: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r11
	.word 0x87802073  ! 4255: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2c4a000  ! 4256: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	.word 0xd29c2000  ! 4257: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	.word 0xdaf7ce80  ! 4258: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	.word 0xd296c9e0  ! 4259: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r9
	.word 0xd2bfce80  ! 4260: STDA_R	stda	%r9, [%r31 + %r0] 0x74
	.word 0xd2dc6000  ! 4261: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r9
	.word 0xd4d40400  ! 4262: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	.word 0xd4944400  ! 4263: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	.word 0xdcf78e60  ! 4264: STXA_R	stxa	%r14, [%r30 + %r0] 0x73
	.word 0xd4a40400  ! 4265: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	mov	0x68, %r16
	mov	0x7f0, %r23
	.word 0xdeace000  ! 4268: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xdebce000  ! 4269: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	mov	0x7f0, %r23
	mov	0x50, %r17
	mov	0x7c0, %r20
	.word 0x87802025  ! 4273: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bf8e40  ! 4274: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	mov	0x3f8, %r20
	.word 0xd4ac8400  ! 4276: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0xdc85c4a0  ! 4277: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r14
	.word 0xd4cca000  ! 4278: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r10
	.word 0xd4942000  ! 4279: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r10
	mov	0x38, %r18
	.word 0xd4f42000  ! 4281: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd6d70e60  ! 4282: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r11
	.word 0xd294a000  ! 4283: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r9
	mov	0x40, %r24
	.word 0xd4978e80  ! 4285: LDUHA_R	lduha	[%r30, %r0] 0x74, %r10
	.word 0xd8f4a000  ! 4286: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xdeac0400  ! 4287: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xd2a4e000  ! 4288: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	mov	0x78, %r24
	.word 0xd2f4a000  ! 4290: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0xd8a6c9e0  ! 4291: STWA_R	stwa	%r12, [%r27 + %r0] 0x4f
	.word 0x87802073  ! 4292: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdabc6000  ! 4293: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 4294: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda94e000  ! 4295: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r13
	.word 0xdab46000  ! 4296: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	mov	0x10, %r17
	mov	0x7c0, %r20
	.word 0x87802020  ! 4299: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cc4400  ! 4300: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r10
	mov	0x28, %r24
	mov	0x7c8, %r22
	.word 0xdcdea000  ! 4303: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r14
	.word 0x87802025  ! 4304: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdacdc4a0  ! 4305: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r13
	.word 0xd0856000  ! 4306: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r8
	mov	0x3e8, %r23
	mov	0x48, %r19
	.word 0xd0852000  ! 4309: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r8
	.word 0xd0a56000  ! 4310: STWA_I	stwa	%r8, [%r21 + 0x0000] %asi
	mov	0x28, %r19
	.word 0xd0b56000  ! 4312: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	.word 0xdcac8400  ! 4313: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xdca609e0  ! 4314: STWA_R	stwa	%r14, [%r24 + %r0] 0x4f
	.word 0x87802074  ! 4315: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 4316: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd08e89e0  ! 4317: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r8
	.word 0xdac5e000  ! 4318: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r13
	.word 0xda952000  ! 4319: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r13
	mov	0x70, %r18
	.word 0xdab52000  ! 4321: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	.word 0xdad56000  ! 4322: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r13
	.word 0x87802074  ! 4323: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd08544a0  ! 4324: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r8
	.word 0x87802020  ! 4325: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f48400  ! 4326: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xd0b46000  ! 4327: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	mov	0x78, %r24
	.word 0xdacf0e80  ! 4329: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r13
	.word 0xd6d4e000  ! 4330: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r11
	.word 0xd6b42000  ! 4331: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0xd6bce000  ! 4332: STDA_I	stda	%r11, [%r19 + 0x0000] %asi
	.word 0xd68c2000  ! 4333: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r11
	.word 0xd6b4e000  ! 4334: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 4335: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a7e000  ! 4336: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xd8ad84a0  ! 4337: STBA_R	stba	%r12, [%r22 + %r0] 0x25
	mov	0x28, %r26
	mov	0x8, %r16
	.word 0xdeaf6000  ! 4340: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xd2b5c4a0  ! 4341: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	mov	0x10, %r17
	mov	0x60, %r16
	.word 0xde976000  ! 4344: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	.word 0xdeb7a000  ! 4345: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xd8bec9e0  ! 4346: STDA_R	stda	%r12, [%r27 + %r0] 0x4f
	.word 0xd4b76000  ! 4347: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd4bfe000  ! 4348: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x10, %r27
	.word 0x87802073  ! 4350: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b6a000  ! 4351: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	.word 0x87802073  ! 4352: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r18
	.word 0xd4a78e60  ! 4354: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	mov	0x3e8, %r20
	.word 0x8780204f  ! 4356: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc8f0e80  ! 4357: LDUBA_R	lduba	[%r28, %r0] 0x74, %r14
	.word 0xd6f7e000  ! 4358: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 4359: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6a7a000  ! 4360: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd2a5c4a0  ! 4361: STWA_R	stwa	%r9, [%r23 + %r0] 0x25
	.word 0xd0972000  ! 4362: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0x87802020  ! 4363: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef7ce60  ! 4364: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0x87802020  ! 4365: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ad6000  ! 4366: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	.word 0xd8956000  ! 4367: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r12
	.word 0xd88d2000  ! 4368: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r12
	.word 0xd8856000  ! 4369: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	.word 0xd8cda000  ! 4370: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r12
	.word 0x87802072  ! 4371: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4372: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88fe000  ! 4373: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8f76000  ! 4374: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	mov	0x20, %r24
	.word 0xd8c649e0  ! 4376: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r12
	.word 0xdab6c9e0  ! 4377: STHA_R	stha	%r13, [%r27 + %r0] 0x4f
	mov	0x7e0, %r22
	.word 0xd6dd44a0  ! 4379: LDXA_R	ldxa	[%r21, %r0] 0x25, %r11
	.word 0xdeafce40  ! 4380: STBA_R	stba	%r15, [%r31 + %r0] 0x72
	.word 0xd6b70e80  ! 4381: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	.word 0x87802025  ! 4382: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd89649e0  ! 4383: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r12
	.word 0xd8876000  ! 4384: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4385: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a48400  ! 4386: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0xd48de000  ! 4387: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r10
	.word 0xd4c5e000  ! 4388: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r10
	mov	0x78, %r18
	.word 0xdcdd44a0  ! 4390: LDXA_R	ldxa	[%r21, %r0] 0x25, %r14
	mov	0x50, %r27
	.word 0xde9de000  ! 4392: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r15
	.word 0xdc870e40  ! 4393: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r14
	.word 0xdea649e0  ! 4394: STWA_R	stwa	%r15, [%r25 + %r0] 0x4f
	.word 0xd8cc0400  ! 4395: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	.word 0x87802020  ! 4396: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r18
	.word 0xdec40400  ! 4398: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xd0df2000  ! 4399: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	mov	0x28, %r18
	.word 0x87802073  ! 4401: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf70e40  ! 4402: STXA_R	stxa	%r13, [%r28 + %r0] 0x72
	.word 0xd4cf0e80  ! 4403: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r10
	mov	0x60, %r16
	.word 0xd8c5e000  ! 4405: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r12
	mov	0x7e8, %r23
	.word 0xde9c4400  ! 4407: LDDA_R	ldda	[%r17, %r0] 0x20, %r15
	.word 0xdcdda000  ! 4408: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r14
	mov	0x3f0, %r21
	.word 0xdade09e0  ! 4410: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r13
	.word 0xd09f4e40  ! 4411: LDDA_R	ldda	[%r29, %r0] 0x72, %r8
	mov	0x40, %r16
	.word 0xd4f5a000  ! 4413: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	.word 0xd6a74e60  ! 4414: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	mov	0x28, %r26
	mov	0x78, %r25
	mov	0x58, %r25
	.word 0xd8d40400  ! 4418: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	mov	0x58, %r17
	.word 0xd6adc4a0  ! 4420: STBA_R	stba	%r11, [%r23 + %r0] 0x25
	.word 0xd28d2000  ! 4421: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r9
	mov	0x3e0, %r21
	.word 0xd2bd6000  ! 4423: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	.word 0xd2bd2000  ! 4424: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	.word 0xd2f52000  ! 4425: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	.word 0xd2f5e000  ! 4426: STXA_I	stxa	%r9, [%r23 + 0x0000] %asi
	mov	0x40, %r16
	mov	0x40, %r16
	.word 0xd29d2000  ! 4429: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r9
	.word 0xd2bde000  ! 4430: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	.word 0xd2f52000  ! 4431: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	mov	0x38, %r24
	.word 0xd2878e80  ! 4433: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r9
	.word 0xde952000  ! 4434: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r15
	.word 0xd4b78e80  ! 4435: STHA_R	stha	%r10, [%r30 + %r0] 0x74
	.word 0xde85a000  ! 4436: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r15
	mov	0x3c8, %r23
	.word 0xd4af0e60  ! 4438: STBA_R	stba	%r10, [%r28 + %r0] 0x73
	mov	0x38, %r27
	.word 0xdac78e40  ! 4440: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r13
	.word 0xd0852000  ! 4441: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r8
	mov	0x7f0, %r23
	.word 0xd0ade000  ! 4443: STBA_I	stba	%r8, [%r23 + 0x0000] %asi
	.word 0x87802073  ! 4444: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0be2000  ! 4445: STDA_I	stda	%r8, [%r24 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xdea609e0  ! 4447: STWA_R	stwa	%r15, [%r24 + %r0] 0x4f
	.word 0xd886e000  ! 4448: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r12
	.word 0xd8f6a000  ! 4449: STXA_I	stxa	%r12, [%r26 + 0x0000] %asi
	mov	0x3f8, %r22
	mov	0x7d8, %r22
	.word 0xdc870e40  ! 4452: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r14
	.word 0xde978e80  ! 4453: LDUHA_R	lduha	[%r30, %r0] 0x74, %r15
	.word 0xd8dea000  ! 4454: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r12
	.word 0xd8d6e000  ! 4455: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r12
	.word 0x87802072  ! 4456: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f74e40  ! 4457: STXA_R	stxa	%r9, [%r29 + %r0] 0x72
	.word 0xd6d78e40  ! 4458: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r11
	.word 0xd6f78e60  ! 4459: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	mov	0x3e8, %r22
	.word 0xdea5c4a0  ! 4461: STWA_R	stwa	%r15, [%r23 + %r0] 0x25
	.word 0xdaa74e60  ! 4462: STWA_R	stwa	%r13, [%r29 + %r0] 0x73
	mov	0x7e0, %r20
	.word 0xd08f0e40  ! 4464: LDUBA_R	lduba	[%r28, %r0] 0x72, %r8
	.word 0xd8c72000  ! 4465: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd2944400  ! 4466: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	mov	0x38, %r25
	mov	0x3d8, %r21
	.word 0x87802020  ! 4469: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f56000  ! 4470: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	.word 0x87802072  ! 4471: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cf8e80  ! 4472: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r10
	.word 0xd4f4a000  ! 4473: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0xd4d42000  ! 4474: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	.word 0xdac70e80  ! 4475: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r13
	.word 0xdcdc4400  ! 4476: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	.word 0xd49c6000  ! 4477: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0xd4f4a000  ! 4478: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0xd4ace000  ! 4479: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0xd4aca000  ! 4480: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 4481: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4482: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r21
	.word 0xd2974e80  ! 4484: LDUHA_R	lduha	[%r29, %r0] 0x74, %r9
	.word 0xdedfce80  ! 4485: LDXA_R	ldxa	[%r31, %r0] 0x74, %r15
	.word 0xd0d4a000  ! 4486: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	.word 0xd08ce000  ! 4487: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0x87802074  ! 4488: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a7e000  ! 4489: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0xdebd04a0  ! 4491: STDA_R	stda	%r15, [%r20 + %r0] 0x25
	.word 0xde9f4e80  ! 4492: LDDA_R	ldda	[%r29, %r0] 0x74, %r15
	mov	0x3d0, %r22
	.word 0xd69504a0  ! 4494: LDUHA_R	lduha	[%r20, %r0] 0x25, %r11
	.word 0xd2bf2000  ! 4495: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	mov	0x28, %r25
	mov	0x3c8, %r22
	.word 0xd2b76000  ! 4498: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 4499: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a72000  ! 4500: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 4501: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2d5a000  ! 4502: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r9
	.word 0xd4d70e60  ! 4503: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r10
	.word 0x87802025  ! 4504: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r26
	.word 0xd6b649e0  ! 4506: STHA_R	stha	%r11, [%r25 + %r0] 0x4f
	.word 0xd4c7a000  ! 4507: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	mov	0x40, %r25
	mov	0x68, %r26
	.word 0xd897ce80  ! 4510: LDUHA_R	lduha	[%r31, %r0] 0x74, %r12
	.word 0xd2a76000  ! 4511: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd2afa000  ! 4512: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xd49689e0  ! 4513: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r10
	.word 0x87802073  ! 4514: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 4515: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebce000  ! 4516: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	mov	0x3c8, %r22
	.word 0xdef46000  ! 4518: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xdeac0400  ! 4519: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xd28f0e40  ! 4520: LDUBA_R	lduba	[%r28, %r0] 0x72, %r9
	.word 0xd4d42000  ! 4521: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	.word 0x87802025  ! 4522: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r17
	.word 0xd4bc8400  ! 4524: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	.word 0xd2b78e80  ! 4525: STHA_R	stha	%r9, [%r30 + %r0] 0x74
	.word 0xd2944400  ! 4526: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	.word 0xd6c7a000  ! 4527: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6c76000  ! 4528: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd0948400  ! 4529: LDUHA_R	lduha	[%r18, %r0] 0x20, %r8
	.word 0x87802020  ! 4530: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a4e000  ! 4531: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0xd28ca000  ! 4532: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2f4a000  ! 4533: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	mov	0x8, %r27
	.word 0x87802020  ! 4535: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded504a0  ! 4536: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r15
	mov	0x3d8, %r22
	.word 0xd6c52000  ! 4538: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r11
	.word 0xdcbfce40  ! 4539: STDA_R	stda	%r14, [%r31 + %r0] 0x72
	.word 0xda87ce40  ! 4540: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r13
	.word 0xd4f5a000  ! 4541: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	.word 0xdef74e40  ! 4542: STXA_R	stxa	%r15, [%r29 + %r0] 0x72
	.word 0xd0b48400  ! 4543: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xdcd5a000  ! 4544: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r14
	.word 0xdca5e000  ! 4545: STWA_I	stwa	%r14, [%r23 + 0x0000] %asi
	.word 0xd6c48400  ! 4546: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	.word 0xd6ad04a0  ! 4547: STBA_R	stba	%r11, [%r20 + %r0] 0x25
	.word 0xd2f5c4a0  ! 4548: STXA_R	stxa	%r9, [%r23 + %r0] 0x25
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x8780204f  ! 4550: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r24
	.word 0xd4c52000  ! 4552: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r10
	mov	0x68, %r19
	.word 0x87802073  ! 4554: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r25
	.word 0xd6ddc4a0  ! 4556: LDXA_R	ldxa	[%r23, %r0] 0x25, %r11
	.word 0x87802072  ! 4557: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4b48400  ! 4558: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd2d78e80  ! 4559: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r9
	.word 0xdef40400  ! 4560: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	mov	0x3f8, %r23
	.word 0xd2d6c9e0  ! 4562: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r9
	.word 0xd4ae2000  ! 4563: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	mov	0x20, %r19
	.word 0x8780204f  ! 4565: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd49ce000  ! 4566: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0xdcf7ce40  ! 4567: STXA_R	stxa	%r14, [%r31 + %r0] 0x72
	.word 0xdeb4e000  ! 4568: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	mov	0x78, %r16
	.word 0xdab649e0  ! 4570: STHA_R	stha	%r13, [%r25 + %r0] 0x4f
	mov	0x30, %r25
	mov	0x3f8, %r23
	.word 0xd8f46000  ! 4573: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0xd8a4a000  ! 4575: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8b4e000  ! 4576: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0xd6a544a0  ! 4577: STWA_R	stwa	%r11, [%r21 + %r0] 0x25
	.word 0xd0bd84a0  ! 4578: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0xd49ca000  ! 4579: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	mov	0x3f0, %r22
	mov	0x60, %r18
	mov	0x40, %r17
	.word 0xde944400  ! 4583: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	mov	0x50, %r24
	.word 0xd2ac6000  ! 4585: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd2bc2000  ! 4586: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xd2aca000  ! 4587: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 4588: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r16
	.word 0xd2aea000  ! 4590: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0xd2aee000  ! 4591: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	.word 0xd28e6000  ! 4592: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r9
	mov	0x3c0, %r21
	.word 0xd2ae2000  ! 4594: STBA_I	stba	%r9, [%r24 + 0x0000] %asi
	.word 0x87802073  ! 4595: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4596: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29de000  ! 4597: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r9
	.word 0xd2a56000  ! 4598: STWA_I	stwa	%r9, [%r21 + 0x0000] %asi
	.word 0xd6bf8e60  ! 4599: STDA_R	stda	%r11, [%r30 + %r0] 0x73
	.word 0xd8a52000  ! 4600: STWA_I	stwa	%r12, [%r20 + 0x0000] %asi
	.word 0xd895a000  ! 4601: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r12
	.word 0xd8f5a000  ! 4602: STXA_I	stxa	%r12, [%r22 + 0x0000] %asi
	.word 0xd8bda000  ! 4603: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	.word 0xd8d5a000  ! 4604: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r12
	.word 0xd8d74e40  ! 4605: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r12
	.word 0x87802073  ! 4606: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4607: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4608: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca72000  ! 4609: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdc8f6000  ! 4610: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcd7a000  ! 4611: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	mov	0x20, %r26
	.word 0xdccf0e40  ! 4613: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r14
	.word 0xd0c5c4a0  ! 4614: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r8
	.word 0x8780204f  ! 4615: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a70e80  ! 4616: STWA_R	stwa	%r9, [%r28 + %r0] 0x74
	.word 0x87802074  ! 4617: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f6a000  ! 4618: STXA_I	stxa	%r8, [%r26 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xd8a44400  ! 4620: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xd296e000  ! 4621: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r9
	.word 0xd2a6a000  ! 4622: STWA_I	stwa	%r9, [%r26 + 0x0000] %asi
	.word 0xdcb7ce40  ! 4623: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x68, %r25
	mov	0x7f0, %r22
	.word 0xd2f6a000  ! 4627: STXA_I	stxa	%r9, [%r26 + 0x0000] %asi
	.word 0xd2d6e000  ! 4628: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r9
	.word 0xd2b6a000  ! 4629: STHA_I	stha	%r9, [%r26 + 0x0000] %asi
	.word 0xd4d74e60  ! 4630: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r10
	.word 0xd4aea000  ! 4631: STBA_I	stba	%r10, [%r26 + 0x0000] %asi
	.word 0xd08d84a0  ! 4632: LDUBA_R	lduba	[%r22, %r0] 0x25, %r8
	.word 0x87802025  ! 4633: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0c504a0  ! 4634: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r8
	mov	0x3f0, %r21
	.word 0xd8b76000  ! 4636: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd8c7a000  ! 4637: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8dfa000  ! 4638: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8f76000  ! 4639: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xd8c7a000  ! 4641: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	mov	0x3c8, %r23
	mov	0x7c0, %r20
	mov	0x48, %r17
	.word 0xd6a44400  ! 4645: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0xdcbec9e0  ! 4646: STDA_R	stda	%r14, [%r27 + %r0] 0x4f
	.word 0xd0f7a000  ! 4647: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xd0a74e60  ! 4649: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	mov	0x28, %r24
	mov	0x7f8, %r21
	.word 0xda8584a0  ! 4652: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r13
	.word 0xd0d76000  ! 4653: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0x87802020  ! 4654: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 4655: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0972000  ! 4656: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xd0af4e80  ! 4657: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	mov	0x7e0, %r21
	mov	0x7c8, %r21
	.word 0xd8a78e80  ! 4660: STWA_R	stwa	%r12, [%r30 + %r0] 0x74
	.word 0x87802072  ! 4661: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r16
	.word 0xd4cca000  ! 4663: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r10
	.word 0xd4b4e000  ! 4664: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xdab6c9e0  ! 4665: STHA_R	stha	%r13, [%r27 + %r0] 0x4f
	.word 0xd4848400  ! 4666: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r10
	.word 0xd8b4a000  ! 4667: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0xd2f78e40  ! 4668: STXA_R	stxa	%r9, [%r30 + %r0] 0x72
	.word 0xd4aca000  ! 4669: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	mov	0x7e0, %r20
	.word 0xdcbf4e40  ! 4671: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	.word 0x87802025  ! 4672: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r25
	.word 0xd2c46000  ! 4674: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0xd2b4a000  ! 4675: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0xd4c6c9e0  ! 4676: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r10
	.word 0x87802020  ! 4677: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc8c0400  ! 4678: LDUBA_R	lduba	[%r16, %r0] 0x20, %r14
	.word 0xd0b4a000  ! 4679: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 4680: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8bcc400  ! 4681: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0xd88fa000  ! 4682: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0xd0c78e60  ! 4683: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r8
	mov	0x7e8, %r23
	mov	0x3c8, %r21
	.word 0xde87a000  ! 4686: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xd8bc0400  ! 4687: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xd8afa000  ! 4688: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 4689: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r19
	.word 0xd8f56000  ! 4691: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	.word 0xdcacc400  ! 4692: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0xd0f5a000  ! 4693: STXA_I	stxa	%r8, [%r22 + 0x0000] %asi
	mov	0x7d8, %r21
	mov	0x7d8, %r22
	.word 0xd0b56000  ! 4696: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	mov	0x8, %r18
	mov	0x3d0, %r22
	.word 0xd8c70e40  ! 4699: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r12
	mov	0x58, %r17
	.word 0xdeb5a000  ! 4701: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	.word 0xdef5a000  ! 4702: STXA_I	stxa	%r15, [%r22 + 0x0000] %asi
	.word 0xdec52000  ! 4703: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r15
	.word 0x87802074  ! 4704: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 4705: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde9c6000  ! 4706: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	mov	0x7e0, %r22
	mov	0x48, %r17
	mov	0x20, %r16
	.word 0xd0dcc400  ! 4710: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0xdca4e000  ! 4711: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcc4e000  ! 4712: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r14
	.word 0xdcd4e000  ! 4713: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	.word 0xdc842000  ! 4714: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	mov	0x7c0, %r20
	.word 0xdc8c2000  ! 4716: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r14
	mov	0x3d0, %r23
	.word 0x87802073  ! 4718: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbe2000  ! 4719: STDA_I	stda	%r14, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 4720: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4721: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdac6c9e0  ! 4722: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r13
	mov	0x68, %r19
	mov	0x8, %r18
	.word 0xdcaf4e40  ! 4725: STBA_R	stba	%r14, [%r29 + %r0] 0x72
	.word 0xd2a7ce60  ! 4726: STWA_R	stwa	%r9, [%r31 + %r0] 0x73
	.word 0xdcafce60  ! 4727: STBA_R	stba	%r14, [%r31 + %r0] 0x73
	mov	0x50, %r26
	.word 0xd29e49e0  ! 4729: LDDA_R	ldda	[%r25, %r0] 0x4f, %r9
	.word 0xded504a0  ! 4730: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r15
	.word 0x87802074  ! 4731: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca72000  ! 4732: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	mov	0x60, %r17
	.word 0xd28d44a0  ! 4734: LDUBA_R	lduba	[%r21, %r0] 0x25, %r9
	.word 0x8780204f  ! 4735: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdac7a000  ! 4736: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xde8fce60  ! 4737: LDUBA_R	lduba	[%r31, %r0] 0x73, %r15
	mov	0x30, %r19
	mov	0x8, %r16
	.word 0xd48dc4a0  ! 4740: LDUBA_R	lduba	[%r23, %r0] 0x25, %r10
	.word 0xd8872000  ! 4741: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	mov	0x18, %r25
	.word 0x87802073  ! 4743: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xded78e60  ! 4744: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r15
	.word 0xd4f6c9e0  ! 4745: STXA_R	stxa	%r10, [%r27 + %r0] 0x4f
	mov	0x3d0, %r22
	.word 0xd6aec9e0  ! 4747: STBA_R	stba	%r11, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 4748: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdca6c9e0  ! 4750: STWA_R	stwa	%r14, [%r27 + %r0] 0x4f
	.word 0xdaf7ce40  ! 4751: STXA_R	stxa	%r13, [%r31 + %r0] 0x72
	mov	0x68, %r25
	.word 0xd4976000  ! 4753: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r10
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd4afe000  ! 4755: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0xd4d72000  ! 4757: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	.word 0xd8ce49e0  ! 4758: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r12
	.word 0xdcdf0e60  ! 4759: LDXA_R	ldxa	[%r28, %r0] 0x73, %r14
	mov	0x7c0, %r23
	mov	0x70, %r25
	.word 0xd8bfe000  ! 4762: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	mov	0x7c0, %r21
	.word 0x87802020  ! 4764: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r27
	.word 0xdaf78e80  ! 4766: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	.word 0xd2acc400  ! 4767: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	mov	0x38, %r27
	.word 0x87802025  ! 4769: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8ad84a0  ! 4770: STBA_R	stba	%r12, [%r22 + %r0] 0x25
	mov	0x7f8, %r23
	.word 0xdeacc400  ! 4772: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xdccec9e0  ! 4773: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r14
	.word 0xd6b544a0  ! 4774: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	.word 0x8780204f  ! 4775: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bfa000  ! 4776: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xdc878e80  ! 4777: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r14
	.word 0xd8cf0e40  ! 4778: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r12
	.word 0x8780204f  ! 4779: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbc2000  ! 4780: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xdcdca000  ! 4781: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xd8df4e40  ! 4782: LDXA_R	ldxa	[%r29, %r0] 0x72, %r12
	mov	0x38, %r25
	.word 0xd2b78e60  ! 4784: STHA_R	stha	%r9, [%r30 + %r0] 0x73
	.word 0xd68ce000  ! 4785: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	.word 0x87802072  ! 4786: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4787: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r20
	.word 0x87802074  ! 4789: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 4790: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b70e60  ! 4791: STHA_R	stha	%r8, [%r28 + %r0] 0x73
	.word 0x8780204f  ! 4792: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r21
	.word 0xd4c7a000  ! 4794: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4a72000  ! 4795: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7e0, %r23
	mov	0x28, %r27
	mov	0x18, %r26
	mov	0x18, %r17
	mov	0x58, %r25
	.word 0xd4bf2000  ! 4802: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd4b72000  ! 4803: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	mov	0x28, %r16
	.word 0xd4b7e000  ! 4805: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	mov	0x50, %r26
	.word 0x87802074  ! 4807: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f62000  ! 4808: STXA_I	stxa	%r10, [%r24 + 0x0000] %asi
	mov	0x58, %r17
	.word 0x87802020  ! 4810: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69584a0  ! 4811: LDUHA_R	lduha	[%r22, %r0] 0x25, %r11
	.word 0x87802074  ! 4812: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8be09e0  ! 4813: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	.word 0xdcaf8e80  ! 4814: STBA_R	stba	%r14, [%r30 + %r0] 0x74
	.word 0xdcc584a0  ! 4815: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r14
	.word 0xd4a4e000  ! 4816: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xd4d4e000  ! 4817: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0xd4d70e40  ! 4818: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r10
	.word 0xd4a42000  ! 4819: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0xd4aca000  ! 4821: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	mov	0x50, %r25
	.word 0xd8944400  ! 4823: LDUHA_R	lduha	[%r17, %r0] 0x20, %r12
	.word 0x87802020  ! 4824: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r19
	.word 0xd2ac2000  ! 4826: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xdacf8e80  ! 4827: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r13
	mov	0x7c8, %r22
	.word 0xdaf46000  ! 4829: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0xdaa4e000  ! 4830: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0xdeae09e0  ! 4831: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	.word 0x87802072  ! 4832: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b4a000  ! 4833: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	mov	0x8, %r25
	.word 0x87802020  ! 4835: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f7a000  ! 4836: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd2f649e0  ! 4837: STXA_R	stxa	%r9, [%r25 + %r0] 0x4f
	.word 0xd6f7a000  ! 4838: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xdaf649e0  ! 4839: STXA_R	stxa	%r13, [%r25 + %r0] 0x4f
	.word 0xd8bfe000  ! 4840: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd8af6000  ! 4841: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xda8f8e40  ! 4842: LDUBA_R	lduba	[%r30, %r0] 0x72, %r13
	.word 0xd6a78e40  ! 4843: STWA_R	stwa	%r11, [%r30 + %r0] 0x72
	.word 0xd09c0400  ! 4844: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	.word 0xd69e49e0  ! 4845: LDDA_R	ldda	[%r25, %r0] 0x4f, %r11
	.word 0xdaac8400  ! 4846: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0xd4b44400  ! 4847: STHA_R	stha	%r10, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 4848: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bc0400  ! 4849: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xde874e40  ! 4850: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r15
	.word 0x87802073  ! 4851: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2978e80  ! 4852: LDUHA_R	lduha	[%r30, %r0] 0x74, %r9
	.word 0xda9cc400  ! 4853: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	.word 0x8780204f  ! 4854: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6bd84a0  ! 4855: STDA_R	stda	%r11, [%r22 + %r0] 0x25
	mov	0x3f0, %r22
	.word 0xdc9f6000  ! 4857: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xde940400  ! 4858: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0xda944400  ! 4859: LDUHA_R	lduha	[%r17, %r0] 0x20, %r13
	mov	0x78, %r17
	.word 0xdcbf4e80  ! 4861: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	mov	0x0, %r24
	.word 0xde976000  ! 4863: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	.word 0x87802074  ! 4864: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef42000  ! 4865: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 4866: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc8f4e60  ! 4867: LDUBA_R	lduba	[%r29, %r0] 0x73, %r14
	.word 0x8780204f  ! 4868: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8c7e000  ! 4869: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8a7e000  ! 4870: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd6cc4400  ! 4871: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	.word 0xded7e000  ! 4872: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0xd8d44400  ! 4873: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	.word 0xd48544a0  ! 4874: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r10
	.word 0xdac7ce80  ! 4875: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r13
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0d76000  ! 4877: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	mov	0x68, %r24
	.word 0x87802020  ! 4879: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b48400  ! 4880: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd2be2000  ! 4881: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	.word 0xd2af4e60  ! 4882: STBA_R	stba	%r9, [%r29 + %r0] 0x73
	.word 0xd8f5c4a0  ! 4883: STXA_R	stxa	%r12, [%r23 + %r0] 0x25
	mov	0x38, %r25
	.word 0x87802020  ! 4885: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r19
	.word 0xd0c74e80  ! 4887: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r8
	mov	0x3f0, %r21
	.word 0xd0b584a0  ! 4889: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	.word 0xd8af0e60  ! 4890: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	.word 0xdebc2000  ! 4891: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0x87802025  ! 4893: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdea72000  ! 4894: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 4895: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f0, %r23
	.word 0xdcbfce60  ! 4897: STDA_R	stda	%r14, [%r31 + %r0] 0x73
	.word 0xd4b74e40  ! 4898: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	mov	0x50, %r26
	.word 0xde844400  ! 4900: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	.word 0x87802073  ! 4901: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2872000  ! 4902: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	mov	0x10, %r25
	mov	0x50, %r27
	.word 0xd29fe000  ! 4905: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd2acc400  ! 4906: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0xdeac0400  ! 4907: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 4908: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6cf8e80  ! 4909: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r11
	.word 0xd4bf8e40  ! 4910: STDA_R	stda	%r10, [%r30 + %r0] 0x72
	mov	0x40, %r19
	.word 0xdaac8400  ! 4912: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0xde846000  ! 4913: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0x87802020  ! 4914: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r23
	.word 0xd4f70e60  ! 4916: STXA_R	stxa	%r10, [%r28 + %r0] 0x73
	.word 0xd4bda000  ! 4917: STDA_I	stda	%r10, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 4918: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4919: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4ae6000  ! 4920: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0xd48e6000  ! 4921: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r10
	.word 0xd2bf8e40  ! 4922: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	.word 0xd0f5c4a0  ! 4923: STXA_R	stxa	%r8, [%r23 + %r0] 0x25
	mov	0x0, %r25
	.word 0xd4c4c400  ! 4925: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r10
	.word 0xd0a609e0  ! 4926: STWA_R	stwa	%r8, [%r24 + %r0] 0x4f
	.word 0xdcb5c4a0  ! 4927: STHA_R	stha	%r14, [%r23 + %r0] 0x25
	.word 0xd6f6a000  ! 4928: STXA_I	stxa	%r11, [%r26 + 0x0000] %asi
	.word 0xd6966000  ! 4929: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r11
	mov	0x48, %r27
	.word 0xd6dea000  ! 4931: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r11
	.word 0xd6a6e000  ! 4932: STWA_I	stwa	%r11, [%r27 + 0x0000] %asi
	.word 0xd6c6a000  ! 4933: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r11
	.word 0xd6cea000  ! 4934: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	.word 0x87802074  ! 4935: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f52000  ! 4936: STXA_I	stxa	%r11, [%r20 + 0x0000] %asi
	.word 0xd0dfce40  ! 4937: LDXA_R	ldxa	[%r31, %r0] 0x72, %r8
	.word 0xdcd48400  ! 4938: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	.word 0xd6ad6000  ! 4939: STBA_I	stba	%r11, [%r21 + 0x0000] %asi
	.word 0xd6a5a000  ! 4940: STWA_I	stwa	%r11, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 4941: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cfa000  ! 4942: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	mov	0x8, %r26
	mov	0x7f0, %r22
	.word 0xd6afe000  ! 4945: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd6a7e000  ! 4946: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xda9e09e0  ! 4947: LDDA_R	ldda	[%r24, %r0] 0x4f, %r13
	.word 0xdac76000  ! 4948: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0xd8a4c400  ! 4949: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xd4b48400  ! 4950: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	mov	0x60, %r17
	.word 0xd6df2000  ! 4952: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xdaf584a0  ! 4953: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	.word 0xd4f74e60  ! 4954: STXA_R	stxa	%r10, [%r29 + %r0] 0x73
	.word 0x87802073  ! 4955: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8b4e000  ! 4956: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	mov	0x3f8, %r22
	.word 0xd88ce000  ! 4958: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	.word 0xd8846000  ! 4959: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	.word 0x87802074  ! 4960: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8ace000  ! 4961: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 4962: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadcc400  ! 4963: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xd6a4e000  ! 4964: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0xd28d84a0  ! 4965: LDUBA_R	lduba	[%r22, %r0] 0x25, %r9
	.word 0xd4bf8e80  ! 4966: STDA_R	stda	%r10, [%r30 + %r0] 0x74
	.word 0xd6f46000  ! 4967: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	mov	0x0, %r17
	.word 0xd6bc2000  ! 4969: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0xd6afce80  ! 4970: STBA_R	stba	%r11, [%r31 + %r0] 0x74
	.word 0xdaac0400  ! 4971: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xd88c2000  ! 4972: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	.word 0xda844400  ! 4973: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r13
	.word 0xdcdd04a0  ! 4974: LDXA_R	ldxa	[%r20, %r0] 0x25, %r14
	mov	0x58, %r25
	mov	0x78, %r24
	.word 0xd8bcc400  ! 4977: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0xd4cfce40  ! 4978: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r10
	.word 0xdca46000  ! 4979: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xda8584a0  ! 4980: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r13
	mov	0x3e0, %r22
	.word 0xd2b70e40  ! 4982: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	.word 0xdca46000  ! 4983: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xd2adc4a0  ! 4984: STBA_R	stba	%r9, [%r23 + %r0] 0x25
	.word 0xd4cf4e60  ! 4985: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r10
	.word 0xd69cc400  ! 4986: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	mov	0x28, %r26
	.word 0xd2d42000  ! 4988: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0xd8af0e60  ! 4989: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	mov	0x3e8, %r23
	.word 0xdea4a000  ! 4991: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xdecce000  ! 4992: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	.word 0xdef42000  ! 4993: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4994: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88fce80  ! 4995: LDUBA_R	lduba	[%r31, %r0] 0x74, %r12
	.word 0xdca74e60  ! 4996: STWA_R	stwa	%r14, [%r29 + %r0] 0x73
	.word 0xd8f4e000  ! 4997: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xdab609e0  ! 4998: STHA_R	stha	%r13, [%r24 + %r0] 0x4f
	mov	0x50, %r18
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_2:
	.word 0xd4ad04a0  ! 1: STBA_R	stba	%r10, [%r20 + %r0] 0x25
	.word 0xd2d5e000  ! 2: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r9
	.word 0xdeb5c4a0  ! 3: STHA_R	stha	%r15, [%r23 + %r0] 0x25
	mov	0x10, %r24
	mov	0x40, %r27
	.word 0xdca56000  ! 6: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	.word 0xdeb74e60  ! 7: STHA_R	stha	%r15, [%r29 + %r0] 0x73
	.word 0xdcb56000  ! 8: STHA_I	stha	%r14, [%r21 + 0x0000] %asi
	.word 0x87802025  ! 9: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde9f4e80  ! 10: LDDA_R	ldda	[%r29, %r0] 0x74, %r15
	mov	0x0, %r19
	.word 0xd0cca000  ! 12: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	.word 0xd0b4a000  ! 13: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 14: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2c649e0  ! 15: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r9
	mov	0x28, %r26
	.word 0xd4b70e40  ! 17: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	mov	0x3d0, %r20
	mov	0x38, %r25
	mov	0x7e8, %r20
	.word 0xd0dd2000  ! 21: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0xde8d84a0  ! 22: LDUBA_R	lduba	[%r22, %r0] 0x25, %r15
	mov	0x58, %r16
	.word 0xd8de49e0  ! 24: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r12
	mov	0x70, %r27
	.word 0xd8bd6000  ! 26: STDA_I	stda	%r12, [%r21 + 0x0000] %asi
	.word 0xdccd84a0  ! 27: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r14
	.word 0x87802020  ! 28: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab7e000  ! 29: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	mov	0x10, %r16
	.word 0xda8f6000  ! 31: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	mov	0x50, %r24
	.word 0xda8fe000  ! 33: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xda87e000  ! 34: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	mov	0x20, %r24
	.word 0x87802020  ! 36: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09c0400  ! 37: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	.word 0xd895e000  ! 38: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r12
	.word 0xd4acc400  ! 39: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xda85a000  ! 40: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r13
	.word 0xda85e000  ! 41: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	.word 0xd08f4e80  ! 42: LDUBA_R	lduba	[%r29, %r0] 0x74, %r8
	.word 0xdab5e000  ! 43: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	.word 0xdabda000  ! 44: STDA_I	stda	%r13, [%r22 + 0x0000] %asi
	mov	0x40, %r27
	.word 0x87802072  ! 46: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa46000  ! 47: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	.word 0xdaa4e000  ! 48: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 49: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaaf2000  ! 50: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdca4c400  ! 51: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xd0df0e60  ! 52: LDXA_R	ldxa	[%r28, %r0] 0x73, %r8
	.word 0xd6d76000  ! 53: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	mov	0x7d8, %r22
	.word 0x87802020  ! 55: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b7e000  ! 56: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd6b76000  ! 57: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd6afa000  ! 58: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x3c0, %r23
	.word 0x87802025  ! 60: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6872000  ! 61: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd697a000  ! 62: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	mov	0x68, %r24
	mov	0x40, %r17
	.word 0x8780204f  ! 65: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcb5c4a0  ! 66: STHA_R	stha	%r14, [%r23 + %r0] 0x25
	mov	0x48, %r25
	mov	0x3e8, %r21
	.word 0xdcd7e000  ! 69: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	mov	0x60, %r16
	mov	0x68, %r27
	.word 0xdc8f6000  ! 72: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdeafce80  ! 73: STBA_R	stba	%r15, [%r31 + %r0] 0x74
	.word 0xdaa7ce40  ! 74: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	.word 0xdcf72000  ! 75: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xd0af0e40  ! 76: STBA_R	stba	%r8, [%r28 + %r0] 0x72
	.word 0xd4f48400  ! 77: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	mov	0x40, %r16
	.word 0x87802020  ! 79: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 80: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 81: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a56000  ! 82: STWA_I	stwa	%r8, [%r21 + 0x0000] %asi
	mov	0x7e0, %r22
	.word 0xd0dd2000  ! 84: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0xd0c5a000  ! 85: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r8
	.word 0xd0f56000  ! 86: STXA_I	stxa	%r8, [%r21 + 0x0000] %asi
	mov	0x40, %r26
	.word 0xd0ada000  ! 88: STBA_I	stba	%r8, [%r22 + 0x0000] %asi
	mov	0x10, %r25
	.word 0xd0bd6000  ! 90: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0xd0a56000  ! 91: STWA_I	stwa	%r8, [%r21 + 0x0000] %asi
	.word 0xdc9fce80  ! 92: LDDA_R	ldda	[%r31, %r0] 0x74, %r14
	mov	0x3d0, %r22
	.word 0xd6dc4400  ! 94: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xd8a689e0  ! 95: STWA_R	stwa	%r12, [%r26 + %r0] 0x4f
	.word 0x87802072  ! 96: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6a48400  ! 97: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	ta	T_CHANGE_PRIV	! macro
	.word 0xd29e09e0  ! 99: LDDA_R	ldda	[%r24, %r0] 0x4f, %r9
	.word 0xdaaec9e0  ! 100: STBA_R	stba	%r13, [%r27 + %r0] 0x4f
	.word 0xd6b7e000  ! 101: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 102: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r17
	.word 0xd68ca000  ! 104: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r11
	.word 0xdabd04a0  ! 105: STDA_R	stda	%r13, [%r20 + %r0] 0x25
	.word 0xd2a4e000  ! 106: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0xdec70e60  ! 107: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r15
	.word 0x87802073  ! 108: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd885e000  ! 109: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r12
	.word 0xd8d5e000  ! 110: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r12
	.word 0x87802020  ! 111: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a7e000  ! 112: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8afe000  ! 113: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd4c44400  ! 114: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r10
	.word 0x87802020  ! 115: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 116: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdedfe000  ! 117: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	mov	0x68, %r25
	mov	0x7e0, %r23
	.word 0xdedfe000  ! 120: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xdebf2000  ! 121: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0xd6cf8e40  ! 122: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r11
	mov	0x3f0, %r21
	.word 0xd6f7e000  ! 124: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6d7a000  ! 125: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	.word 0xdcd70e80  ! 126: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r14
	.word 0xd6f76000  ! 127: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6b72000  ! 128: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xdc8c4400  ! 129: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0xd6872000  ! 130: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	mov	0x7f0, %r23
	.word 0xd6cf2000  ! 132: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	mov	0x7c8, %r23
	.word 0x87802020  ! 134: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 135: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r18
	.word 0xd6bfa000  ! 137: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd29c8400  ! 138: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	.word 0xd6ad84a0  ! 139: STBA_R	stba	%r11, [%r22 + %r0] 0x25
	.word 0xdea48400  ! 140: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xd0a72000  ! 141: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xd0dfe000  ! 142: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xdeafce80  ! 143: STBA_R	stba	%r15, [%r31 + %r0] 0x74
	.word 0xd2a76000  ! 144: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 145: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd285e000  ! 146: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r9
	mov	0x0, %r16
	mov	0x50, %r19
	.word 0xd2bd2000  ! 149: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	.word 0xd2f52000  ! 150: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	mov	0x7c0, %r21
	.word 0xd6ac0400  ! 152: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 153: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r26
	.word 0x87802072  ! 155: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 156: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 157: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef7a000  ! 158: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0xdca649e0  ! 160: STWA_R	stwa	%r14, [%r25 + %r0] 0x4f
	mov	0x10, %r24
	.word 0xdccfe000  ! 162: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	mov	0x78, %r26
	.word 0xdc9f6000  ! 164: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0xdcc7e000  ! 165: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcd76000  ! 166: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	.word 0xdc87e000  ! 167: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0x87802020  ! 168: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r16
	.word 0x87802025  ! 170: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4dec9e0  ! 171: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r10
	.word 0xd887a000  ! 172: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8af6000  ! 173: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd0ae89e0  ! 174: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	.word 0xd0cf6000  ! 175: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0x87802020  ! 176: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 177: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r16
	mov	0x68, %r18
	.word 0xd0bce000  ! 180: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	mov	0x7c8, %r23
	mov	0x50, %r27
	.word 0xd0bce000  ! 183: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xd0cca000  ! 185: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	.word 0xd09fce40  ! 186: LDDA_R	ldda	[%r31, %r0] 0x72, %r8
	mov	0x7e8, %r22
	mov	0x7d0, %r22
	.word 0xdebc6000  ! 189: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xd0b70e60  ! 190: STHA_R	stha	%r8, [%r28 + %r0] 0x73
	.word 0xdcbcc400  ! 191: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0x87802074  ! 192: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcc44400  ! 193: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xde9c4400  ! 194: LDDA_R	ldda	[%r17, %r0] 0x20, %r15
	mov	0x48, %r17
	mov	0x50, %r17
	.word 0xdc84a000  ! 197: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	.word 0xdccc6000  ! 198: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	.word 0xdc8c2000  ! 199: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r14
	.word 0xdcb42000  ! 200: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 201: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcade000  ! 202: STBA_I	stba	%r14, [%r23 + 0x0000] %asi
	.word 0xdcbd2000  ! 203: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	.word 0xdcb5a000  ! 204: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0xdcc52000  ! 205: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r14
	.word 0xdc952000  ! 206: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r14
	.word 0xd6878e60  ! 207: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r11
	.word 0xd0dfce60  ! 208: LDXA_R	ldxa	[%r31, %r0] 0x73, %r8
	.word 0xdc85a000  ! 209: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r14
	mov	0x7d8, %r20
	.word 0x87802020  ! 211: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r24
	.word 0xdc8d6000  ! 213: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r14
	.word 0x87802020  ! 214: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r26
	mov	0x60, %r27
	.word 0xdc8fe000  ! 217: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	mov	0x7f8, %r22
	.word 0xd6f48400  ! 219: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xdcad84a0  ! 220: STBA_R	stba	%r14, [%r22 + %r0] 0x25
	mov	0x28, %r27
	.word 0xd2cd84a0  ! 222: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r9
	mov	0x28, %r19
	.word 0xded76000  ! 224: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	mov	0x3f0, %r22
	.word 0x8780204f  ! 226: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdad44400  ! 227: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0x87802020  ! 228: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 229: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r17
	mov	0x70, %r16
	.word 0xd89fce40  ! 232: LDDA_R	ldda	[%r31, %r0] 0x72, %r12
	.word 0x87802020  ! 233: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r25
	mov	0x68, %r27
	.word 0xd69c6000  ! 236: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r11
	mov	0x10, %r17
	.word 0xde8504a0  ! 238: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r15
	.word 0xd0f46000  ! 239: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0bd44a0  ! 240: STDA_R	stda	%r8, [%r21 + %r0] 0x25
	.word 0x87802074  ! 241: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bf2000  ! 242: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xdef4c400  ! 243: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xd89f4e60  ! 244: LDDA_R	ldda	[%r29, %r0] 0x73, %r12
	mov	0x78, %r27
	.word 0x87802020  ! 246: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 247: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde9f0e60  ! 248: LDDA_R	ldda	[%r28, %r0] 0x73, %r15
	.word 0xd4a46000  ! 249: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xd496c9e0  ! 250: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r10
	.word 0x8780204f  ! 251: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bd04a0  ! 252: STDA_R	stda	%r10, [%r20 + %r0] 0x25
	.word 0x8780204f  ! 253: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaae89e0  ! 254: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	.word 0xd2b74e60  ! 255: STHA_R	stha	%r9, [%r29 + %r0] 0x73
	mov	0x8, %r19
	.word 0x87802020  ! 257: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 258: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8878e60  ! 259: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r12
	mov	0x8, %r16
	.word 0xded72000  ! 261: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xdedf2000  ! 262: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xdecd44a0  ! 263: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r15
	.word 0xd4f72000  ! 264: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4bfe000  ! 265: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd4df2000  ! 266: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0xd48f4e60  ! 267: LDUBA_R	lduba	[%r29, %r0] 0x73, %r10
	.word 0x87802025  ! 268: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r26
	.word 0xd484c400  ! 270: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	.word 0xded7a000  ! 271: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0x87802072  ! 272: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r16
	.word 0x8780204f  ! 274: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bfce80  ! 275: STDA_R	stda	%r12, [%r31 + %r0] 0x74
	mov	0x28, %r25
	.word 0xd68c8400  ! 277: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	.word 0xdabf4e60  ! 278: STDA_R	stda	%r13, [%r29 + %r0] 0x73
	mov	0x28, %r16
	.word 0xd8b6c9e0  ! 280: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	.word 0x87802072  ! 281: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 282: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cf4e40  ! 283: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r11
	.word 0x8780204f  ! 284: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8df2000  ! 285: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	mov	0x20, %r18
	.word 0xdabf4e40  ! 287: STDA_R	stda	%r13, [%r29 + %r0] 0x72
	.word 0x87802020  ! 288: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebcc400  ! 289: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	mov	0x3f0, %r23
	.word 0xdc8fce60  ! 291: LDUBA_R	lduba	[%r31, %r0] 0x73, %r14
	.word 0x87802020  ! 292: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r21
	.word 0xdec4e000  ! 294: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xde9ce000  ! 296: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0x87802025  ! 297: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f504a0  ! 298: STXA_R	stxa	%r8, [%r20 + %r0] 0x25
	.word 0xd0bda000  ! 299: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	.word 0xd0856000  ! 300: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r8
	mov	0x70, %r17
	.word 0xd4af8e60  ! 302: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	mov	0x70, %r26
	mov	0x7c8, %r23
	.word 0xdab504a0  ! 305: STHA_R	stha	%r13, [%r20 + %r0] 0x25
	.word 0x87802020  ! 306: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd89fa000  ! 307: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	mov	0x18, %r17
	.word 0xd8b76000  ! 309: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd8cc8400  ! 310: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0xd69504a0  ! 311: LDUHA_R	lduha	[%r20, %r0] 0x25, %r11
	mov	0x58, %r27
	mov	0x10, %r24
	.word 0x8780204f  ! 314: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f4a000  ! 315: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0xd2f4c400  ! 316: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	mov	0x3d0, %r20
	.word 0xd6c40400  ! 318: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r11
	.word 0xdef44400  ! 319: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xdea5c4a0  ! 320: STWA_R	stwa	%r15, [%r23 + %r0] 0x25
	.word 0xd2dc8400  ! 321: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0xd2cf0e80  ! 322: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r9
	.word 0xdcdc6000  ! 323: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	.word 0xde8f8e60  ! 324: LDUBA_R	lduba	[%r30, %r0] 0x73, %r15
	.word 0xd0bc4400  ! 325: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	mov	0x7e0, %r20
	.word 0xd48c6000  ! 327: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r10
	.word 0xdabf0e40  ! 328: STDA_R	stda	%r13, [%r28 + %r0] 0x72
	mov	0x28, %r19
	mov	0x48, %r17
	.word 0xdcf4a000  ! 331: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xd6acc400  ! 332: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0x87802020  ! 333: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4df0e80  ! 334: LDXA_R	ldxa	[%r28, %r0] 0x74, %r10
	.word 0xdadc6000  ! 335: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xd0b48400  ! 336: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xdaf42000  ! 337: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0xdab42000  ! 338: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xde8cc400  ! 339: LDUBA_R	lduba	[%r19, %r0] 0x20, %r15
	.word 0x87802020  ! 340: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4de2000  ! 341: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r10
	.word 0xd4cee000  ! 342: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r10
	.word 0xd4ce2000  ! 343: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r10
	.word 0xd8a74e80  ! 344: STWA_R	stwa	%r12, [%r29 + %r0] 0x74
	.word 0xdc866000  ! 345: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r14
	.word 0xd2b584a0  ! 346: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0xd48cc400  ! 347: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	.word 0xdcdee000  ! 348: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r14
	.word 0xdcdea000  ! 349: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r14
	.word 0xdcf62000  ! 350: STXA_I	stxa	%r14, [%r24 + 0x0000] %asi
	.word 0xd2b70e60  ! 351: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	mov	0x7f0, %r23
	.word 0xd8aee000  ! 353: STBA_I	stba	%r12, [%r27 + 0x0000] %asi
	.word 0xd8dea000  ! 354: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r12
	mov	0x78, %r27
	mov	0x28, %r27
	.word 0xd8c6c9e0  ! 357: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r12
	.word 0x87802020  ! 358: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c544a0  ! 359: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r9
	.word 0x87802020  ! 360: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cf8e60  ! 361: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r10
	.word 0xda9ca000  ! 362: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	.word 0x87802025  ! 363: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4d609e0  ! 364: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r10
	.word 0x87802073  ! 365: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdedfce40  ! 366: LDXA_R	ldxa	[%r31, %r0] 0x72, %r15
	mov	0x60, %r27
	.word 0xd8b78e80  ! 368: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	.word 0xd6d7a000  ! 369: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	mov	0x40, %r27
	mov	0x20, %r25
	.word 0x8780204f  ! 372: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f8, %r22
	.word 0x87802072  ! 374: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f584a0  ! 375: STXA_R	stxa	%r11, [%r22 + %r0] 0x25
	.word 0x8780204f  ! 376: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 377: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 378: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cf6000  ! 379: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 380: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r16
	.word 0xd2ae89e0  ! 382: STBA_R	stba	%r9, [%r26 + %r0] 0x4f
	.word 0xdedfa000  ! 383: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x3d0, %r20
	.word 0xd0b74e60  ! 385: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	.word 0x87802020  ! 386: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r27
	.word 0xd8f7e000  ! 388: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8976000  ! 389: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	mov	0x0, %r26
	mov	0x30, %r26
	.word 0xd697ce80  ! 392: LDUHA_R	lduha	[%r31, %r0] 0x74, %r11
	mov	0x18, %r27
	mov	0x20, %r16
	.word 0xd6978e40  ! 395: LDUHA_R	lduha	[%r30, %r0] 0x72, %r11
	.word 0xd487a000  ! 396: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	.word 0xd8c4c400  ! 397: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r12
	mov	0x8, %r17
	mov	0x50, %r24
	.word 0xd8d76000  ! 400: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xd8872000  ! 401: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	.word 0x87802072  ! 402: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 403: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r25
	.word 0x87802020  ! 405: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c4c400  ! 406: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0xde8f2000  ! 407: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xdad40400  ! 408: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	.word 0xd8972000  ! 409: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	.word 0xd49f8e60  ! 410: LDDA_R	ldda	[%r30, %r0] 0x73, %r10
	.word 0x87802025  ! 411: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r16
	.word 0xd0d544a0  ! 413: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r8
	mov	0x30, %r16
	mov	0x38, %r18
	.word 0x87802020  ! 416: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac7ce40  ! 417: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r13
	mov	0x3d0, %r22
	.word 0xd4afe000  ! 419: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd4b7e000  ! 420: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xdcdf4e80  ! 421: LDXA_R	ldxa	[%r29, %r0] 0x74, %r14
	mov	0x18, %r26
	.word 0xd2d7a000  ! 423: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0xd0874e40  ! 424: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r8
	.word 0x8780204f  ! 425: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4cfe000  ! 426: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0xd4bf6000  ! 427: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd4a76000  ! 428: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xdc8c8400  ! 429: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0xd4dc4400  ! 430: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	.word 0xd0a40400  ! 431: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0xdeb7e000  ! 432: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xde8f6000  ! 433: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	.word 0xdedf6000  ! 434: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xdecfce40  ! 435: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r15
	.word 0xdef76000  ! 436: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xded72000  ! 437: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0x87802072  ! 438: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde94c400  ! 439: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	mov	0x3f0, %r23
	.word 0xd2d78e40  ! 441: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r9
	.word 0x87802020  ! 442: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r17
	.word 0xdebd6000  ! 444: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	mov	0x10, %r16
	.word 0xdedf4e40  ! 446: LDXA_R	ldxa	[%r29, %r0] 0x72, %r15
	.word 0xd8978e40  ! 447: LDUHA_R	lduha	[%r30, %r0] 0x72, %r12
	.word 0xd0b5c4a0  ! 448: STHA_R	stha	%r8, [%r23 + %r0] 0x25
	.word 0x87802020  ! 449: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r23
	mov	0x3e0, %r22
	.word 0xdcb7e000  ! 452: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xd6d78e60  ! 453: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r11
	.word 0xd6f7e000  ! 454: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6f7e000  ! 455: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd69f2000  ! 456: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	mov	0x3d8, %r22
	mov	0x10, %r18
	.word 0xdcbe49e0  ! 459: STDA_R	stda	%r14, [%r25 + %r0] 0x4f
	.word 0xdaf74e60  ! 460: STXA_R	stxa	%r13, [%r29 + %r0] 0x73
	.word 0xd4bf2000  ! 461: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	mov	0x58, %r18
	mov	0x7c0, %r20
	.word 0xd49f2000  ! 464: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd4876000  ! 465: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xdea74e80  ! 466: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	.word 0xdaa72000  ! 467: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xdadf6000  ! 468: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xd2afce60  ! 469: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	mov	0x40, %r17
	.word 0xdad7e000  ! 471: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xd0f7ce40  ! 472: STXA_R	stxa	%r8, [%r31 + %r0] 0x72
	.word 0xd2f78e60  ! 473: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0xdcf72000  ! 474: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xde8fce80  ! 475: LDUBA_R	lduba	[%r31, %r0] 0x74, %r15
	.word 0xd8a7a000  ! 476: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 477: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e8, %r23
	mov	0x3f8, %r21
	.word 0xdef5c4a0  ! 480: STXA_R	stxa	%r15, [%r23 + %r0] 0x25
	.word 0xdaa62000  ! 481: STWA_I	stwa	%r13, [%r24 + 0x0000] %asi
	mov	0x50, %r27
	.word 0xdaa66000  ! 483: STWA_I	stwa	%r13, [%r25 + 0x0000] %asi
	mov	0x70, %r16
	mov	0x28, %r27
	mov	0x7d0, %r22
	.word 0xda9ea000  ! 487: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r13
	mov	0x3d0, %r21
	mov	0x7d0, %r23
	.word 0xdaa6e000  ! 490: STWA_I	stwa	%r13, [%r27 + 0x0000] %asi
	.word 0xdaf62000  ! 491: STXA_I	stxa	%r13, [%r24 + 0x0000] %asi
	.word 0xdaa6a000  ! 492: STWA_I	stwa	%r13, [%r26 + 0x0000] %asi
	.word 0xdace2000  ! 493: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r13
	.word 0xda8ee000  ! 494: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r13
	.word 0x87802020  ! 495: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r26
	.word 0xdad48400  ! 497: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	mov	0x70, %r16
	.word 0xd8dda000  ! 499: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r12
	mov	0x3c0, %r22
	.word 0xd69609e0  ! 501: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r11
	mov	0x68, %r27
	mov	0x18, %r18
	.word 0xd4978e60  ! 504: LDUHA_R	lduha	[%r30, %r0] 0x73, %r10
	.word 0xdca544a0  ! 505: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0xd4f70e40  ! 506: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	.word 0x87802020  ! 507: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcaf4e60  ! 508: STBA_R	stba	%r14, [%r29 + %r0] 0x73
	.word 0xd6af2000  ! 509: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x0, %r19
	mov	0x7d8, %r23
	.word 0xd68f6000  ! 512: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xdaaf4e60  ! 513: STBA_R	stba	%r13, [%r29 + %r0] 0x73
	.word 0xd287e000  ! 514: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0xd8948400  ! 515: LDUHA_R	lduha	[%r18, %r0] 0x20, %r12
	.word 0xd0c78e80  ! 516: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r8
	.word 0xdaf78e80  ! 517: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	mov	0x68, %r19
	.word 0xd4c7e000  ! 519: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	mov	0x68, %r16
	mov	0x7f0, %r20
	.word 0xd4c7a000  ! 522: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	.word 0xd6c70e40  ! 523: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r11
	.word 0x87802072  ! 524: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2dc6000  ! 525: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r9
	.word 0xd2bce000  ! 526: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xdab7ce80  ! 527: STHA_R	stha	%r13, [%r31 + %r0] 0x74
	.word 0xd0970e80  ! 528: LDUHA_R	lduha	[%r28, %r0] 0x74, %r8
	.word 0xdcd42000  ! 529: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	mov	0x3e0, %r23
	.word 0x8780204f  ! 531: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd484c400  ! 532: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	mov	0x58, %r16
	mov	0x7e8, %r20
	.word 0xdc876000  ! 535: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0xdc8f2000  ! 536: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0xd4f70e40  ! 537: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	.word 0xde8f2000  ! 538: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdea76000  ! 540: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	mov	0x58, %r19
	mov	0x3c8, %r21
	.word 0xdeb72000  ! 543: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	mov	0x28, %r16
	.word 0xde9f2000  ! 545: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xd8f78e80  ! 546: STXA_R	stxa	%r12, [%r30 + %r0] 0x74
	.word 0xda8f6000  ! 547: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	mov	0x78, %r18
	mov	0x58, %r19
	.word 0xd2ae09e0  ! 550: STBA_R	stba	%r9, [%r24 + %r0] 0x4f
	mov	0x60, %r25
	.word 0x87802020  ! 552: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebf6000  ! 553: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	mov	0x0, %r25
	.word 0x87802020  ! 555: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdacc0400  ! 556: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r13
	.word 0x87802074  ! 557: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 558: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4ae49e0  ! 559: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0xd6a40400  ! 560: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0xdabe6000  ! 561: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	.word 0xd6bfce40  ! 562: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	.word 0xda8f0e40  ! 563: LDUBA_R	lduba	[%r28, %r0] 0x72, %r13
	.word 0xdef649e0  ! 564: STXA_R	stxa	%r15, [%r25 + %r0] 0x4f
	.word 0xd2be6000  ! 565: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	mov	0x0, %r24
	.word 0xd4b74e40  ! 567: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	.word 0xd8bee000  ! 568: STDA_I	stda	%r12, [%r27 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0x87802025  ! 570: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd69fce60  ! 571: LDDA_R	ldda	[%r31, %r0] 0x73, %r11
	.word 0xd2d42000  ! 572: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2ac6000  ! 573: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd2a46000  ! 574: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2b78e60  ! 575: STHA_R	stha	%r9, [%r30 + %r0] 0x73
	.word 0xd6bf0e60  ! 576: STDA_R	stda	%r11, [%r28 + %r0] 0x73
	mov	0x3d8, %r23
	.word 0x8780204f  ! 578: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc974e60  ! 579: LDUHA_R	lduha	[%r29, %r0] 0x73, %r14
	.word 0xd0f76000  ! 580: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0dfa000  ! 581: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 582: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x48, %r25
	.word 0xd0a5a000  ! 584: STWA_I	stwa	%r8, [%r22 + 0x0000] %asi
	.word 0xd0f74e40  ! 585: STXA_R	stxa	%r8, [%r29 + %r0] 0x72
	.word 0xd6be49e0  ! 586: STDA_R	stda	%r11, [%r25 + %r0] 0x4f
	.word 0xd2af0e60  ! 587: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	.word 0xd0a5a000  ! 588: STWA_I	stwa	%r8, [%r22 + 0x0000] %asi
	.word 0xdcd48400  ! 589: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	mov	0x70, %r18
	.word 0xde9de000  ! 591: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r15
	.word 0xdef5e000  ! 592: STXA_I	stxa	%r15, [%r23 + 0x0000] %asi
	.word 0xdeb56000  ! 593: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	.word 0xde95a000  ! 594: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r15
	.word 0xded5e000  ! 595: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r15
	.word 0xda9e89e0  ! 596: LDDA_R	ldda	[%r26, %r0] 0x4f, %r13
	.word 0xdcdde000  ! 597: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	.word 0xdc9de000  ! 598: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r14
	.word 0xdea609e0  ! 599: STWA_R	stwa	%r15, [%r24 + %r0] 0x4f
	.word 0x87802072  ! 600: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r19
	.word 0xdcc74e60  ! 602: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r14
	mov	0x70, %r19
	.word 0xdaf7a000  ! 604: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	mov	0x68, %r17
	.word 0xdaa7a000  ! 606: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xdaf76000  ! 607: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdab7a000  ! 608: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xda8f6000  ! 610: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	mov	0x60, %r17
	mov	0x7f0, %r22
	mov	0x38, %r27
	.word 0xdca48400  ! 614: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xd8d40400  ! 615: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	ta	T_CHANGE_PRIV	! macro
	.word 0xd887ce80  ! 617: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r12
	.word 0xd2af6000  ! 618: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 619: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2dda000  ! 620: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r9
	.word 0xd2a5a000  ! 621: STWA_I	stwa	%r9, [%r22 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xd2f52000  ! 623: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	.word 0xd2a5a000  ! 624: STWA_I	stwa	%r9, [%r22 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xd494c400  ! 626: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	.word 0xdc8d44a0  ! 627: LDUBA_R	lduba	[%r21, %r0] 0x25, %r14
	.word 0xd8856000  ! 628: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	.word 0xd8a52000  ! 629: STWA_I	stwa	%r12, [%r20 + 0x0000] %asi
	.word 0x87802072  ! 630: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 631: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r25
	.word 0xd8dc6000  ! 633: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	.word 0xd49584a0  ! 634: LDUHA_R	lduha	[%r22, %r0] 0x25, %r10
	.word 0xde9fce80  ! 635: LDDA_R	ldda	[%r31, %r0] 0x74, %r15
	mov	0x60, %r27
	.word 0xdc944400  ! 637: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	.word 0xd0ac0400  ! 638: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	.word 0xdcc78e80  ! 639: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r14
	.word 0xdeac2000  ! 640: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	mov	0x7e0, %r22
	mov	0x3e0, %r20
	.word 0xde946000  ! 643: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r15
	.word 0xded4a000  ! 644: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	mov	0x10, %r16
	mov	0x0, %r25
	mov	0x3c0, %r23
	.word 0x87802074  ! 648: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc874e60  ! 649: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r14
	.word 0xd4f62000  ! 650: STXA_I	stxa	%r10, [%r24 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd4b6a000  ! 652: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	.word 0x87802074  ! 653: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f7ce60  ! 654: STXA_R	stxa	%r11, [%r31 + %r0] 0x73
	.word 0xda8c2000  ! 655: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r13
	.word 0xda84e000  ! 656: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r13
	.word 0x87802072  ! 657: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd28c4400  ! 658: LDUBA_R	lduba	[%r17, %r0] 0x20, %r9
	.word 0x87802072  ! 659: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cf2000  ! 660: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xdebcc400  ! 661: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	.word 0xd0a76000  ! 662: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	mov	0x3c0, %r22
	mov	0x38, %r27
	.word 0xd8f74e80  ! 665: STXA_R	stxa	%r12, [%r29 + %r0] 0x74
	.word 0xd6afe000  ! 666: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xded7ce80  ! 667: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r15
	.word 0xd08f2000  ! 668: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	.word 0xd4d584a0  ! 669: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r10
	mov	0x28, %r25
	.word 0xd6a7a000  ! 671: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	mov	0x50, %r19
	.word 0xdabe89e0  ! 673: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	.word 0xdcdfa000  ! 674: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	mov	0x50, %r16
	.word 0xd29f8e80  ! 676: LDDA_R	ldda	[%r30, %r0] 0x74, %r9
	.word 0xdaa689e0  ! 677: STWA_R	stwa	%r13, [%r26 + %r0] 0x4f
	.word 0xde944400  ! 678: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	.word 0xd29fa000  ! 679: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd2df2000  ! 680: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0x87802073  ! 681: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6a689e0  ! 682: STWA_R	stwa	%r11, [%r26 + %r0] 0x4f
	mov	0x78, %r26
	.word 0xdcafce60  ! 684: STBA_R	stba	%r14, [%r31 + %r0] 0x73
	.word 0xd6840400  ! 685: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0xd0b544a0  ! 686: STHA_R	stha	%r8, [%r21 + %r0] 0x25
	.word 0x87802020  ! 687: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r23
	.word 0xd0cfe000  ! 689: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xd0cfa000  ! 690: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0xd0976000  ! 691: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0d72000  ! 692: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xdaf78e80  ! 693: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	.word 0xd4bf2000  ! 694: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd6b40400  ! 695: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xd4df2000  ! 696: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	mov	0x40, %r27
	.word 0xd29689e0  ! 698: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r9
	mov	0x60, %r26
	mov	0x40, %r26
	.word 0xd2bf6000  ! 701: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd0cf8e60  ! 702: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r8
	.word 0xd8d76000  ! 703: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	mov	0x3f8, %r22
	.word 0x87802072  ! 705: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8966000  ! 706: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r12
	mov	0x60, %r19
	.word 0xdcdd04a0  ! 708: LDXA_R	ldxa	[%r20, %r0] 0x25, %r14
	.word 0xd4bee000  ! 709: STDA_I	stda	%r10, [%r27 + 0x0000] %asi
	.word 0xd48ee000  ! 710: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r10
	.word 0x87802020  ! 711: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r23
	mov	0x28, %r27
	.word 0x87802025  ! 714: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4bda000  ! 715: STDA_I	stda	%r10, [%r22 + 0x0000] %asi
	mov	0x58, %r19
	.word 0xd4b5e000  ! 717: STHA_I	stha	%r10, [%r23 + 0x0000] %asi
	mov	0x10, %r25
	.word 0xd49da000  ! 719: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r10
	.word 0xd48d2000  ! 720: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0xd4dd6000  ! 721: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r10
	.word 0xd6bfce40  ! 722: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	.word 0xd0dd2000  ! 723: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0xdcaec9e0  ! 724: STBA_R	stba	%r14, [%r27 + %r0] 0x4f
	.word 0xdacfce40  ! 725: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r13
	.word 0xd8c56000  ! 726: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 727: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 728: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdec4c400  ! 729: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	mov	0x60, %r18
	.word 0xd6afa000  ! 731: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd084c400  ! 732: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r8
	.word 0xd2cc8400  ! 733: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0x87802020  ! 734: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r22
	.word 0x87802072  ! 736: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2ce6000  ! 737: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r9
	.word 0xd68cc400  ! 738: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	.word 0xd6f6a000  ! 739: STXA_I	stxa	%r11, [%r26 + 0x0000] %asi
	.word 0xd4b649e0  ! 740: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	.word 0xd096a000  ! 741: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r8
	.word 0xd08ee000  ! 742: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r8
	mov	0x8, %r26
	mov	0x30, %r26
	mov	0x10, %r26
	mov	0x48, %r19
	.word 0xd2b6c9e0  ! 747: STHA_R	stha	%r9, [%r27 + %r0] 0x4f
	.word 0xdec62000  ! 748: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r15
	mov	0x7f8, %r22
	mov	0x40, %r17
	.word 0xdeb62000  ! 751: STHA_I	stha	%r15, [%r24 + 0x0000] %asi
	mov	0x30, %r26
	.word 0xdcaf8e80  ! 753: STBA_R	stba	%r14, [%r30 + %r0] 0x74
	.word 0xdecd44a0  ! 754: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r15
	.word 0xd4be6000  ! 755: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0x87802073  ! 756: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f6a000  ! 757: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	.word 0x87802073  ! 758: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c0, %r20
	mov	0x60, %r19
	.word 0xd8bdc4a0  ! 761: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	.word 0xd6bda000  ! 762: STDA_I	stda	%r11, [%r22 + 0x0000] %asi
	mov	0x50, %r18
	.word 0xdeb5c4a0  ! 764: STHA_R	stha	%r15, [%r23 + %r0] 0x25
	.word 0xde8e09e0  ! 765: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r15
	mov	0x10, %r26
	mov	0x50, %r18
	.word 0xdcdde000  ! 768: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	mov	0x68, %r19
	.word 0xdcada000  ! 770: STBA_I	stba	%r14, [%r22 + 0x0000] %asi
	.word 0xd0f609e0  ! 771: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	.word 0xd096c9e0  ! 772: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r8
	.word 0xd0870e60  ! 773: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r8
	.word 0xd4b78e80  ! 774: STHA_R	stha	%r10, [%r30 + %r0] 0x74
	.word 0xdc978e40  ! 775: LDUHA_R	lduha	[%r30, %r0] 0x72, %r14
	mov	0x60, %r24
	mov	0x70, %r25
	.word 0xdec5e000  ! 778: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r15
	.word 0xdef5e000  ! 779: STXA_I	stxa	%r15, [%r23 + 0x0000] %asi
	.word 0xdea52000  ! 780: STWA_I	stwa	%r15, [%r20 + 0x0000] %asi
	.word 0x87802072  ! 781: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8ce89e0  ! 782: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r12
	.word 0xd09649e0  ! 783: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r8
	.word 0x87802073  ! 784: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f0, %r23
	.word 0xda9c6000  ! 786: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xdab4a000  ! 787: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xd2ae49e0  ! 789: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	mov	0x20, %r17
	.word 0xdadc6000  ! 791: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xd0a40400  ! 792: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0xd48e89e0  ! 793: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r10
	.word 0x87802072  ! 794: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda8584a0  ! 795: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r13
	.word 0xd4a4e000  ! 796: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xd4c4e000  ! 797: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r10
	.word 0xd6d6c9e0  ! 798: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r11
	.word 0xd0c46000  ! 799: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r8
	.word 0xd0dc6000  ! 800: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	.word 0xde9f0e80  ! 801: LDDA_R	ldda	[%r28, %r0] 0x74, %r15
	.word 0xd4b4e000  ! 802: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 803: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 804: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r27
	.word 0xd4bf2000  ! 806: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0xd09c8400  ! 808: LDDA_R	ldda	[%r18, %r0] 0x20, %r8
	.word 0xd48f8e60  ! 809: LDUBA_R	lduba	[%r30, %r0] 0x73, %r10
	.word 0x87802020  ! 810: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c7a000  ! 811: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xdea6c9e0  ! 812: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	.word 0xd4d689e0  ! 813: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r10
	.word 0xdeaf6000  ! 814: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xdebf6000  ! 815: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xde97e000  ! 816: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0x87802020  ! 817: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0be89e0  ! 818: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	.word 0xd2af6000  ! 819: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd2df6000  ! 820: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2b76000  ! 821: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	mov	0x7d8, %r22
	mov	0x0, %r16
	.word 0xd2f72000  ! 824: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0x87802025  ! 826: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb74e60  ! 827: STHA_R	stha	%r15, [%r29 + %r0] 0x73
	mov	0x7f0, %r23
	.word 0xd69f8e60  ! 829: LDDA_R	ldda	[%r30, %r0] 0x73, %r11
	.word 0xdcf7a000  ! 830: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xda8cc400  ! 832: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	.word 0x87802074  ! 833: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 834: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 835: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcaf6000  ! 836: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xd88609e0  ! 837: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r12
	.word 0xdcf72000  ! 838: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	mov	0x28, %r19
	.word 0xdcdf2000  ! 840: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdca7e000  ! 841: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdc87a000  ! 842: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xd4974e40  ! 843: LDUHA_R	lduha	[%r29, %r0] 0x72, %r10
	.word 0x87802074  ! 844: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r16
	.word 0x87802073  ! 846: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdab7ce40  ! 847: STHA_R	stha	%r13, [%r31 + %r0] 0x72
	.word 0xdaa4a000  ! 848: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0x87802025  ! 850: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 851: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r24
	.word 0x8780204f  ! 853: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa7e000  ! 854: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xdacf6000  ! 855: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	mov	0x3d8, %r20
	.word 0xd89544a0  ! 857: LDUHA_R	lduha	[%r21, %r0] 0x25, %r12
	.word 0xd68c8400  ! 858: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	.word 0xde94c400  ! 859: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	.word 0xd8cf2000  ! 860: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	mov	0x58, %r26
	mov	0x30, %r19
	.word 0xd8cf2000  ! 863: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	mov	0x68, %r18
	mov	0x78, %r24
	.word 0x87802020  ! 866: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 867: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b40400  ! 868: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0xdeb5e000  ! 869: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	mov	0x70, %r17
	.word 0x87802072  ! 871: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 872: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdede6000  ! 873: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r15
	.word 0xd2c70e40  ! 874: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r9
	.word 0xd6d7ce80  ! 875: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r11
	.word 0x87802020  ! 876: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadfce40  ! 877: LDXA_R	ldxa	[%r31, %r0] 0x72, %r13
	.word 0xd6b7e000  ! 878: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd4d40400  ! 879: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	.word 0xd6bfe000  ! 880: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0xd6a76000  ! 882: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 883: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 884: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6af6000  ! 885: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd09fce40  ! 886: LDDA_R	ldda	[%r31, %r0] 0x72, %r8
	.word 0xd4dfe000  ! 887: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	mov	0x68, %r26
	.word 0xd4b72000  ! 889: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd0d5c4a0  ! 890: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r8
	mov	0x28, %r16
	.word 0x87802072  ! 892: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 893: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd28504a0  ! 894: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r9
	mov	0x7e8, %r21
	mov	0x20, %r27
	.word 0x87802020  ! 897: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebf4e60  ! 898: STDA_R	stda	%r15, [%r29 + %r0] 0x73
	.word 0x87802072  ! 899: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca4e000  ! 900: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0xdc94a000  ! 901: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0x87802020  ! 902: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca6a000  ! 903: STWA_I	stwa	%r14, [%r26 + 0x0000] %asi
	mov	0x3c0, %r23
	.word 0xdcde2000  ! 905: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r14
	mov	0x10, %r27
	.word 0xdcbee000  ! 907: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	mov	0x3f8, %r21
	mov	0x3c8, %r21
	.word 0xdc966000  ! 910: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r14
	.word 0xdef44400  ! 911: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	mov	0x3d0, %r20
	.word 0x87802072  ! 913: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0bca000  ! 914: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 915: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabf0e40  ! 916: STDA_R	stda	%r13, [%r28 + %r0] 0x72
	.word 0xd2b5e000  ! 917: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	.word 0xd2b5e000  ! 918: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	.word 0xd2dda000  ! 919: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r9
	.word 0xdc8ec9e0  ! 920: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r14
	.word 0xda85e000  ! 921: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	.word 0xdcb78e80  ! 922: STHA_R	stha	%r14, [%r30 + %r0] 0x74
	.word 0xd6aec9e0  ! 923: STBA_R	stba	%r11, [%r27 + %r0] 0x4f
	.word 0x87802025  ! 924: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8a6c9e0  ! 925: STWA_R	stwa	%r12, [%r27 + %r0] 0x4f
	mov	0x3f0, %r20
	mov	0x48, %r25
	mov	0x10, %r16
	.word 0xd4dea000  ! 929: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	mov	0x7c8, %r20
	.word 0xd4b62000  ! 931: STHA_I	stha	%r10, [%r24 + 0x0000] %asi
	mov	0x8, %r19
	.word 0xd4c6e000  ! 933: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r10
	.word 0xd29504a0  ! 934: LDUHA_R	lduha	[%r20, %r0] 0x25, %r9
	.word 0x87802025  ! 935: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8c74e60  ! 936: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r12
	.word 0x87802072  ! 937: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda874e40  ! 938: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r13
	.word 0xd2dd84a0  ! 939: LDXA_R	ldxa	[%r22, %r0] 0x25, %r9
	mov	0x48, %r26
	mov	0x3d0, %r21
	mov	0x0, %r27
	mov	0x3e8, %r23
	.word 0xd6c7e000  ! 944: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6872000  ! 945: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6dfa000  ! 946: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0xdac44400  ! 947: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r13
	mov	0x38, %r18
	mov	0x78, %r24
	ta	T_CHANGE_PRIV	! macro
	mov	0x40, %r16
	.word 0xd4cfa000  ! 952: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	mov	0x28, %r25
	.word 0x87802020  ! 954: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b7ce40  ! 955: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0x87802025  ! 956: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8d7ce80  ! 957: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r12
	mov	0x28, %r26
	.word 0xd4be6000  ! 959: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdadc8400  ! 961: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	.word 0xd0be2000  ! 962: STDA_I	stda	%r8, [%r24 + 0x0000] %asi
	.word 0xdef70e60  ! 963: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	.word 0xdcbe49e0  ! 964: STDA_R	stda	%r14, [%r25 + %r0] 0x4f
	mov	0x8, %r26
	.word 0x87802020  ! 966: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdec42000  ! 967: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	mov	0x30, %r27
	mov	0x58, %r18
	.word 0xde9c2000  ! 970: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0x87802025  ! 971: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde9da000  ! 972: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r15
	.word 0xd6d7ce80  ! 973: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r11
	.word 0xd6cf4e40  ! 974: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r11
	.word 0xd8f44400  ! 975: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xdcd52000  ! 976: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r14
	.word 0xdea609e0  ! 977: STWA_R	stwa	%r15, [%r24 + %r0] 0x4f
	.word 0xd6a544a0  ! 978: STWA_R	stwa	%r11, [%r21 + %r0] 0x25
	.word 0xdcbde000  ! 979: STDA_I	stda	%r14, [%r23 + 0x0000] %asi
	.word 0xdccd6000  ! 980: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r14
	.word 0xd4d44400  ! 981: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0xd295e000  ! 982: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r9
	.word 0xdab609e0  ! 983: STHA_R	stha	%r13, [%r24 + %r0] 0x4f
	.word 0xdad4c400  ! 984: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xd2f52000  ! 985: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	.word 0xdcc689e0  ! 986: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r14
	mov	0x8, %r26
	.word 0xdcf5a000  ! 988: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	.word 0xd6cdc4a0  ! 989: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r11
	.word 0xd4f70e80  ! 990: STXA_R	stxa	%r10, [%r28 + %r0] 0x74
	.word 0xda8d2000  ! 991: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r13
	.word 0x87802073  ! 992: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r27
	.word 0xdaaf6000  ! 994: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 995: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdab5a000  ! 996: STHA_I	stha	%r13, [%r22 + 0x0000] %asi
	.word 0xdcafce40  ! 997: STBA_R	stba	%r14, [%r31 + %r0] 0x72
	.word 0xd88649e0  ! 998: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r12
	.word 0xd4bd2000  ! 999: STDA_I	stda	%r10, [%r20 + 0x0000] %asi
	.word 0xd6bc4400  ! 1000: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	mov	0x70, %r19
	.word 0x8780204f  ! 1002: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d8, %r21
	.word 0xd6d609e0  ! 1004: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r11
	.word 0xdedf8e60  ! 1005: LDXA_R	ldxa	[%r30, %r0] 0x73, %r15
	.word 0xd4a70e40  ! 1006: STWA_R	stwa	%r10, [%r28 + %r0] 0x72
	.word 0xdcb76000  ! 1007: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 1008: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r17
	.word 0xdcf5e000  ! 1010: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0xdcf7ce80  ! 1011: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	.word 0xd6d5e000  ! 1012: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r11
	.word 0xd6a48400  ! 1013: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0xdcdd2000  ! 1014: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r14
	.word 0xdcb5e000  ! 1015: STHA_I	stha	%r14, [%r23 + 0x0000] %asi
	.word 0xdcad6000  ! 1016: STBA_I	stba	%r14, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 1017: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r24
	.word 0xdcbfa000  ! 1019: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdc872000  ! 1020: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcdf6000  ! 1021: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	mov	0x30, %r27
	.word 0xdcbf2000  ! 1023: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	mov	0x3f0, %r21
	.word 0xd48cc400  ! 1025: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	.word 0xd2b504a0  ! 1026: STHA_R	stha	%r9, [%r20 + %r0] 0x25
	.word 0xd8cf0e60  ! 1027: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r12
	mov	0x60, %r18
	.word 0x87802025  ! 1029: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1030: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r18
	.word 0xdaaf0e80  ! 1032: STBA_R	stba	%r13, [%r28 + %r0] 0x74
	mov	0x50, %r16
	mov	0x40, %r18
	mov	0x18, %r26
	.word 0xdabc0400  ! 1036: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xd6870e60  ! 1037: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r11
	mov	0x30, %r17
	mov	0x20, %r18
	.word 0xdcdde000  ! 1040: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	.word 0x87802020  ! 1041: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf74e80  ! 1042: STXA_R	stxa	%r14, [%r29 + %r0] 0x74
	.word 0xd69544a0  ! 1043: LDUHA_R	lduha	[%r21, %r0] 0x25, %r11
	.word 0x87802020  ! 1044: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf7e000  ! 1045: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdc8fe000  ! 1046: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xd8b74e40  ! 1047: STHA_R	stha	%r12, [%r29 + %r0] 0x72
	.word 0x87802020  ! 1048: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a46000  ! 1049: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xd884e000  ! 1050: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r12
	.word 0xd8846000  ! 1051: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	.word 0xd8f46000  ! 1052: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8d7ce60  ! 1053: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r12
	.word 0xd6cf0e60  ! 1054: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r11
	.word 0x87802073  ! 1055: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b6e000  ! 1056: STHA_I	stha	%r10, [%r27 + 0x0000] %asi
	.word 0xd4aee000  ! 1057: STBA_I	stba	%r10, [%r27 + 0x0000] %asi
	.word 0xd4b6e000  ! 1058: STHA_I	stha	%r10, [%r27 + 0x0000] %asi
	.word 0xd4cee000  ! 1059: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r10
	.word 0xd0b40400  ! 1060: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0xd8dc0400  ! 1061: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0x87802020  ! 1062: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cca000  ! 1063: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r10
	.word 0x87802072  ! 1064: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6de49e0  ! 1065: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r11
	mov	0x30, %r18
	.word 0xdad4a000  ! 1067: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0xdaa4c400  ! 1068: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0xd49ca000  ! 1069: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0x87802025  ! 1070: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4d78e40  ! 1071: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r10
	.word 0xdadd6000  ! 1072: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r13
	mov	0x40, %r16
	.word 0x87802074  ! 1074: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2c48400  ! 1075: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0x87802072  ! 1076: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1077: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4df4e60  ! 1078: LDXA_R	ldxa	[%r29, %r0] 0x73, %r10
	.word 0xdcbf6000  ! 1079: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0xdab504a0  ! 1081: STHA_R	stha	%r13, [%r20 + %r0] 0x25
	.word 0xd2978e60  ! 1082: LDUHA_R	lduha	[%r30, %r0] 0x73, %r9
	.word 0xdccf4e80  ! 1083: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r14
	.word 0xd29f0e60  ! 1084: LDDA_R	ldda	[%r28, %r0] 0x73, %r9
	.word 0xdabf4e80  ! 1085: STDA_R	stda	%r13, [%r29 + %r0] 0x74
	.word 0xdcc72000  ! 1086: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xdabd04a0  ! 1087: STDA_R	stda	%r13, [%r20 + %r0] 0x25
	.word 0xd4afce60  ! 1088: STBA_R	stba	%r10, [%r31 + %r0] 0x73
	.word 0xdecf6000  ! 1089: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	mov	0x68, %r24
	.word 0xdecfce40  ! 1091: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r15
	.word 0xd8b40400  ! 1092: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xdabcc400  ! 1093: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	mov	0x68, %r19
	.word 0xd4df6000  ! 1095: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1096: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1097: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 1098: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda940400  ! 1099: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	mov	0x7c8, %r23
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6b7a000  ! 1102: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 1103: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0c609e0  ! 1104: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r8
	.word 0x87802072  ! 1105: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r18
	.word 0xd8afe000  ! 1107: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1108: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x7f8, %r20
	.word 0xdaac0400  ! 1111: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	mov	0x20, %r19
	.word 0x87802020  ! 1113: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebd84a0  ! 1114: STDA_R	stda	%r15, [%r22 + %r0] 0x25
	.word 0x8780204f  ! 1115: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2c5c4a0  ! 1116: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r9
	.word 0xd887a000  ! 1117: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8c7e000  ! 1118: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8b76000  ! 1119: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd89f6000  ! 1120: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	.word 0xd8af2000  ! 1121: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	mov	0x78, %r16
	.word 0xd8d72000  ! 1123: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xdcb4c400  ! 1124: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	mov	0x48, %r26
	mov	0x70, %r18
	.word 0xd0f689e0  ! 1127: STXA_R	stxa	%r8, [%r26 + %r0] 0x4f
	.word 0xd4b609e0  ! 1128: STHA_R	stha	%r10, [%r24 + %r0] 0x4f
	.word 0xd48fa000  ! 1129: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xd49f2000  ! 1130: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd4b76000  ! 1131: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	mov	0x20, %r25
	.word 0xdcb4c400  ! 1133: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0x87802074  ! 1134: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 1135: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r19
	.word 0x87802073  ! 1137: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd487e000  ! 1138: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4af6000  ! 1139: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	mov	0x10, %r16
	mov	0x7e8, %r21
	.word 0xdc94c400  ! 1142: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	.word 0xdcaf4e60  ! 1143: STBA_R	stba	%r14, [%r29 + %r0] 0x73
	.word 0xd0bcc400  ! 1144: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0xd29609e0  ! 1145: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r9
	mov	0x7d8, %r20
	.word 0xd6af4e60  ! 1147: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	.word 0xdc9fe000  ! 1148: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r14
	.word 0xdcb76000  ! 1149: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xdaf78e80  ! 1150: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	mov	0x78, %r26
	.word 0x8780204f  ! 1152: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b7e000  ! 1153: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd49fe000  ! 1154: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x8, %r16
	mov	0x18, %r16
	mov	0x0, %r24
	.word 0xd49fa000  ! 1159: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1160: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bee000  ! 1161: STDA_I	stda	%r10, [%r27 + 0x0000] %asi
	.word 0xd4c62000  ! 1162: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r10
	.word 0xd0870e80  ! 1163: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r8
	.word 0x87802025  ! 1164: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f8, %r21
	mov	0x10, %r18
	.word 0xd29f2000  ! 1167: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd2a76000  ! 1168: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xdcf689e0  ! 1169: STXA_R	stxa	%r14, [%r26 + %r0] 0x4f
	.word 0x8780204f  ! 1170: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda8e09e0  ! 1171: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r13
	mov	0x3e0, %r21
	mov	0x10, %r19
	.word 0xde944400  ! 1174: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	.word 0xd4c76000  ! 1175: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	.word 0xd0afce40  ! 1176: STBA_R	stba	%r8, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 1177: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x48, %r27
	.word 0xdac70e60  ! 1179: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r13
	.word 0xd6bc2000  ! 1180: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0xd6bca000  ! 1181: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	.word 0xd6b46000  ! 1182: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd6946000  ! 1183: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r11
	mov	0x8, %r19
	mov	0x0, %r17
	.word 0xd6bca000  ! 1186: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	.word 0xd6942000  ! 1187: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r11
	.word 0xd6d4e000  ! 1188: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r11
	.word 0xdaf40400  ! 1189: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xdac42000  ! 1190: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0xdaf4e000  ! 1191: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xdabca000  ! 1192: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	mov	0x7c0, %r21
	.word 0xdad46000  ! 1194: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	.word 0x87802073  ! 1195: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd09544a0  ! 1196: LDUHA_R	lduha	[%r21, %r0] 0x25, %r8
	.word 0xd8aea000  ! 1197: STBA_I	stba	%r12, [%r26 + 0x0000] %asi
	mov	0x10, %r27
	.word 0x87802073  ! 1199: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8ae6000  ! 1200: STBA_I	stba	%r12, [%r25 + 0x0000] %asi
	.word 0xda87ce60  ! 1201: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r13
	.word 0xda8e6000  ! 1202: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r13
	mov	0x18, %r26
	.word 0xdecf0e80  ! 1204: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r15
	.word 0xd6be2000  ! 1205: STDA_I	stda	%r11, [%r24 + 0x0000] %asi
	.word 0xd6970e40  ! 1206: LDUHA_R	lduha	[%r28, %r0] 0x72, %r11
	mov	0x3c0, %r21
	.word 0xd0c6a000  ! 1208: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1209: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1210: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69f8e40  ! 1211: LDDA_R	ldda	[%r30, %r0] 0x72, %r11
	.word 0x87802020  ! 1212: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r22
	.word 0xdecce000  ! 1214: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	.word 0xd6c48400  ! 1215: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	.word 0x87802025  ! 1216: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1217: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r19
	.word 0xd8f48400  ! 1219: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xdaa70e40  ! 1220: STWA_R	stwa	%r13, [%r28 + %r0] 0x72
	.word 0x87802025  ! 1221: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcdc4400  ! 1222: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	.word 0xd0df8e60  ! 1223: LDXA_R	ldxa	[%r30, %r0] 0x73, %r8
	mov	0x60, %r27
	.word 0xdc9fa000  ! 1225: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0xdcaf0e40  ! 1226: STBA_R	stba	%r14, [%r28 + %r0] 0x72
	mov	0x7f0, %r23
	.word 0xdcf72000  ! 1228: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xded44400  ! 1229: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	.word 0xd8acc400  ! 1230: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0x87802020  ! 1231: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r19
	.word 0x87802025  ! 1233: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6bfa000  ! 1234: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	mov	0x10, %r25
	mov	0x28, %r16
	mov	0x70, %r18
	mov	0x3f0, %r22
	.word 0xd69f2000  ! 1239: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xd69fe000  ! 1240: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	.word 0xdcdc8400  ! 1241: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	.word 0xdcdf8e60  ! 1242: LDXA_R	ldxa	[%r30, %r0] 0x73, %r14
	.word 0x87802073  ! 1243: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4d4a000  ! 1244: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1245: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r22
	.word 0xd4bc2000  ! 1247: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0x87802025  ! 1249: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r17
	.word 0xd09f4e80  ! 1251: LDDA_R	ldda	[%r29, %r0] 0x74, %r8
	.word 0xd4d7a000  ! 1252: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	.word 0xd4afa000  ! 1253: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd68cc400  ! 1254: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	mov	0x3c0, %r20
	.word 0xdcb78e80  ! 1256: STHA_R	stha	%r14, [%r30 + %r0] 0x74
	.word 0x87802074  ! 1257: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b76000  ! 1258: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0xd2a649e0  ! 1260: STWA_R	stwa	%r9, [%r25 + %r0] 0x4f
	mov	0x7c8, %r20
	mov	0x7c8, %r20
	.word 0xdccf2000  ! 1263: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xdcbfa000  ! 1264: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 1265: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbf0e60  ! 1266: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	mov	0x3f0, %r20
	.word 0x87802020  ! 1268: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f44400  ! 1269: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	mov	0x7c0, %r22
	.word 0xd4952000  ! 1271: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r10
	.word 0x87802074  ! 1272: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f4c400  ! 1273: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	mov	0x10, %r18
	mov	0x3c8, %r21
	mov	0x30, %r18
	.word 0xd6afa000  ! 1277: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6cfa000  ! 1278: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	mov	0x60, %r24
	.word 0xd6848400  ! 1280: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	.word 0xdca7a000  ! 1281: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdaaf8e60  ! 1282: STBA_R	stba	%r13, [%r30 + %r0] 0x73
	.word 0xdca649e0  ! 1283: STWA_R	stwa	%r14, [%r25 + %r0] 0x4f
	.word 0xdabf6000  ! 1284: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xd2bdc4a0  ! 1285: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	mov	0x60, %r27
	mov	0x10, %r26
	.word 0x8780204f  ! 1288: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r18
	mov	0x10, %r27
	.word 0xd4862000  ! 1291: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r10
	.word 0xd2dc4400  ! 1292: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xd0f649e0  ! 1293: STXA_R	stxa	%r8, [%r25 + %r0] 0x4f
	.word 0xd0dea000  ! 1294: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r8
	.word 0xd0a40400  ! 1295: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0x87802025  ! 1296: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda9d04a0  ! 1297: LDDA_R	ldda	[%r20, %r0] 0x25, %r13
	.word 0xd8f544a0  ! 1298: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	mov	0x50, %r16
	mov	0x10, %r26
	.word 0xd0b40400  ! 1301: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0x87802073  ! 1302: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8d40400  ! 1303: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	.word 0xde878e60  ! 1304: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r15
	.word 0xdeaca000  ! 1305: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	mov	0x7f0, %r23
	mov	0x3d0, %r21
	.word 0xdeb4e000  ! 1308: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0xdadf8e80  ! 1310: LDXA_R	ldxa	[%r30, %r0] 0x74, %r13
	.word 0xd2f4e000  ! 1311: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2ac2000  ! 1312: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd2942000  ! 1313: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2c42000  ! 1314: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	mov	0x60, %r16
	.word 0xd2c46000  ! 1316: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0xdab78e40  ! 1317: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	.word 0xd28689e0  ! 1318: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r9
	.word 0x87802073  ! 1319: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 1320: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb78e80  ! 1321: STHA_R	stha	%r14, [%r30 + %r0] 0x74
	.word 0xd4b6e000  ! 1322: STHA_I	stha	%r10, [%r27 + 0x0000] %asi
	.word 0xd2cf4e60  ! 1323: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r9
	.word 0xd6844400  ! 1324: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r11
	mov	0x48, %r16
	.word 0xd2a5c4a0  ! 1326: STWA_R	stwa	%r9, [%r23 + %r0] 0x25
	.word 0xd0874e60  ! 1327: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r8
	mov	0x7f0, %r23
	.word 0xde874e40  ! 1329: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r15
	.word 0x87802072  ! 1330: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4d544a0  ! 1331: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r10
	.word 0xd2f78e60  ! 1332: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0xd0cc6000  ! 1333: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	.word 0x87802073  ! 1334: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0cf6000  ! 1335: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd0a7a000  ! 1336: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0b7e000  ! 1337: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	mov	0x20, %r17
	.word 0xd0cfa000  ! 1339: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0xd0f72000  ! 1340: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xd4bd44a0  ! 1341: STDA_R	stda	%r10, [%r21 + %r0] 0x25
	.word 0xd4d76000  ! 1342: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	mov	0x7e0, %r23
	mov	0x78, %r27
	.word 0xd8adc4a0  ! 1345: STBA_R	stba	%r12, [%r23 + %r0] 0x25
	.word 0xdaafa000  ! 1346: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdabd44a0  ! 1347: STDA_R	stda	%r13, [%r21 + %r0] 0x25
	.word 0xd29fe000  ! 1348: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xdcaf4e80  ! 1349: STBA_R	stba	%r14, [%r29 + %r0] 0x74
	.word 0x8780204f  ! 1350: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f66000  ! 1351: STXA_I	stxa	%r10, [%r25 + 0x0000] %asi
	mov	0x48, %r19
	.word 0x8780204f  ! 1353: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d8, %r22
	.word 0x87802020  ! 1355: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ce49e0  ! 1356: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r12
	mov	0x3e8, %r20
	.word 0xde8504a0  ! 1358: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r15
	mov	0x60, %r25
	.word 0xd2874e80  ! 1360: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r9
	.word 0xd4bf8e40  ! 1361: STDA_R	stda	%r10, [%r30 + %r0] 0x72
	.word 0xd4dfa000  ! 1362: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4bf2000  ! 1363: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 1364: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 1365: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4cfa000  ! 1366: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0x87802025  ! 1367: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f40400  ! 1368: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	.word 0x87802074  ! 1369: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r19
	.word 0xd28ce000  ! 1371: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	mov	0x3c8, %r23
	mov	0x3d0, %r23
	.word 0xd2b4a000  ! 1374: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0xd2bc2000  ! 1375: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xd2f4e000  ! 1376: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 1377: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8c44400  ! 1378: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r12
	.word 0xd2c7a000  ! 1379: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1380: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29c6000  ! 1381: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	.word 0xd284a000  ! 1382: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	.word 0xd6cfce60  ! 1383: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r11
	.word 0x87802020  ! 1384: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r22
	.word 0x8780204f  ! 1386: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1387: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1388: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2c74e80  ! 1389: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r9
	.word 0x8780204f  ! 1390: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 1391: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8afce60  ! 1392: STBA_R	stba	%r12, [%r31 + %r0] 0x73
	.word 0xdabf8e40  ! 1393: STDA_R	stda	%r13, [%r30 + %r0] 0x72
	.word 0xdac7e000  ! 1394: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	mov	0x0, %r17
	.word 0xdacf6000  ! 1396: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	mov	0x10, %r27
	.word 0x8780204f  ! 1398: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa584a0  ! 1399: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	.word 0xdef7a000  ! 1400: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 1401: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdea42000  ! 1402: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	mov	0x10, %r16
	.word 0xdebca000  ! 1404: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xd6c7ce60  ! 1405: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r11
	.word 0xd6f4e000  ! 1406: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0xdea4c400  ! 1408: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	.word 0xd28689e0  ! 1409: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r9
	.word 0xd4d4e000  ! 1410: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	mov	0x48, %r24
	.word 0xdeb7ce60  ! 1412: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	.word 0x87802020  ! 1413: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c7a000  ! 1414: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2afe000  ! 1415: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1416: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r19
	.word 0xdaaf4e80  ! 1418: STBA_R	stba	%r13, [%r29 + %r0] 0x74
	.word 0x87802074  ! 1419: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e8, %r22
	mov	0x40, %r27
	.word 0xd69f6000  ! 1422: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	mov	0x30, %r18
	.word 0xd68f2000  ! 1424: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xd48689e0  ! 1425: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r10
	.word 0x87802020  ! 1426: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cce000  ! 1427: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0xd094e000  ! 1428: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0xd084a000  ! 1429: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0bc4400  ! 1430: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xd69ce000  ! 1431: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r11
	.word 0xd6842000  ! 1432: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r11
	mov	0x70, %r18
	mov	0x7e0, %r23
	mov	0x48, %r27
	mov	0x30, %r24
	mov	0x60, %r27
	mov	0x38, %r18
	.word 0xd6f4a000  ! 1439: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 1440: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6b72000  ! 1441: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xdab7ce40  ! 1442: STHA_R	stha	%r13, [%r31 + %r0] 0x72
	.word 0x87802020  ! 1443: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef72000  ! 1444: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	mov	0x48, %r24
	mov	0x10, %r19
	.word 0xde8fe000  ! 1447: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0x87802020  ! 1448: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb4e000  ! 1449: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0xdec42000  ! 1450: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0xdef42000  ! 1451: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xde846000  ! 1452: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	mov	0x40, %r26
	.word 0xdedc2000  ! 1454: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r15
	.word 0xd0c74e60  ! 1455: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r8
	.word 0x8780204f  ! 1456: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e0, %r23
	.word 0xdcd76000  ! 1458: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	.word 0xdad7ce80  ! 1459: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r13
	.word 0xdabd84a0  ! 1460: STDA_R	stda	%r13, [%r22 + %r0] 0x25
	.word 0xd0af6000  ! 1461: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd4c504a0  ! 1462: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r10
	.word 0xd29649e0  ! 1463: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r9
	.word 0xd2f689e0  ! 1464: STXA_R	stxa	%r9, [%r26 + %r0] 0x4f
	.word 0xd4bfce80  ! 1465: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	mov	0x28, %r26
	mov	0x28, %r27
	.word 0xdcc76000  ! 1468: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xdcdfa000  ! 1469: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcf7e000  ! 1470: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdedfce80  ! 1471: LDXA_R	ldxa	[%r31, %r0] 0x74, %r15
	.word 0xd8afa000  ! 1472: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xd89fe000  ! 1473: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0xdca70e80  ! 1474: STWA_R	stwa	%r14, [%r28 + %r0] 0x74
	.word 0xd6c40400  ! 1475: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r11
	.word 0xd09f0e40  ! 1476: LDDA_R	ldda	[%r28, %r0] 0x72, %r8
	.word 0xdeb7e000  ! 1477: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xde8609e0  ! 1478: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r15
	.word 0xd4bf2000  ! 1479: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1480: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1481: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r24
	.word 0xd4afa000  ! 1483: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd48fe000  ! 1484: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	mov	0x7e8, %r22
	mov	0x70, %r19
	.word 0xd4a7a000  ! 1487: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xdea544a0  ! 1488: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	.word 0xdef44400  ! 1489: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xd29c0400  ! 1490: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	.word 0x87802072  ! 1491: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0f7e000  ! 1492: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0bfe000  ! 1493: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 1494: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a7a000  ! 1495: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd4f649e0  ! 1496: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	.word 0xd69f2000  ! 1497: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xd2be89e0  ! 1498: STDA_R	stda	%r9, [%r26 + %r0] 0x4f
	.word 0xd0d78e40  ! 1499: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r8
	mov	0x3e0, %r21
	.word 0x87802072  ! 1501: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2ad6000  ! 1502: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	mov	0x70, %r27
	.word 0xd2dcc400  ! 1504: LDXA_R	ldxa	[%r19, %r0] 0x20, %r9
	mov	0x68, %r27
	.word 0x87802073  ! 1506: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f72000  ! 1507: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 1508: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c8, %r23
	.word 0xd8df4e40  ! 1510: LDXA_R	ldxa	[%r29, %r0] 0x72, %r12
	.word 0x87802025  ! 1511: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0af8e40  ! 1512: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	mov	0x3c8, %r22
	.word 0xdca42000  ! 1514: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xdcc609e0  ! 1515: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r14
	.word 0xd48c6000  ! 1516: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r10
	.word 0xd49d04a0  ! 1517: LDDA_R	ldda	[%r20, %r0] 0x25, %r10
	.word 0xd48c8400  ! 1518: LDUBA_R	lduba	[%r18, %r0] 0x20, %r10
	.word 0xde84e000  ! 1519: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	.word 0xde948400  ! 1520: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	.word 0xdef42000  ! 1521: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xde8c6000  ! 1522: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	mov	0x68, %r27
	.word 0x87802074  ! 1524: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f0, %r22
	.word 0xdef6e000  ! 1526: STXA_I	stxa	%r15, [%r27 + 0x0000] %asi
	.word 0xde862000  ! 1527: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r15
	.word 0xdeb74e40  ! 1528: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	.word 0xde862000  ! 1529: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r15
	.word 0xd2a78e60  ! 1530: STWA_R	stwa	%r9, [%r30 + %r0] 0x73
	.word 0xdeb6e000  ! 1531: STHA_I	stha	%r15, [%r27 + 0x0000] %asi
	mov	0x48, %r17
	.word 0xdede6000  ! 1533: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r15
	mov	0x78, %r26
	.word 0xdeae6000  ! 1535: STBA_I	stba	%r15, [%r25 + 0x0000] %asi
	.word 0xdab44400  ! 1536: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0xd0dd44a0  ! 1537: LDXA_R	ldxa	[%r21, %r0] 0x25, %r8
	.word 0xd4ac0400  ! 1538: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xd28e2000  ! 1539: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	.word 0xdaa74e40  ! 1540: STWA_R	stwa	%r13, [%r29 + %r0] 0x72
	.word 0xd8a62000  ! 1541: STWA_I	stwa	%r12, [%r24 + 0x0000] %asi
	mov	0x68, %r26
	mov	0x10, %r26
	.word 0xd2b584a0  ! 1544: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0xd8aea000  ! 1545: STBA_I	stba	%r12, [%r26 + 0x0000] %asi
	.word 0x87802072  ! 1546: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2d7ce80  ! 1547: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r9
	.word 0xdabea000  ! 1548: STDA_I	stda	%r13, [%r26 + 0x0000] %asi
	.word 0xda962000  ! 1549: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r13
	.word 0xdaf6e000  ! 1550: STXA_I	stxa	%r13, [%r27 + 0x0000] %asi
	.word 0xd0bf4e80  ! 1551: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	.word 0xd2f6a000  ! 1552: STXA_I	stxa	%r9, [%r26 + 0x0000] %asi
	.word 0xdac584a0  ! 1553: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r13
	.word 0xdccee000  ! 1554: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r14
	.word 0xdea7ce60  ! 1555: STWA_R	stwa	%r15, [%r31 + %r0] 0x73
	.word 0xd4f62000  ! 1556: STXA_I	stxa	%r10, [%r24 + 0x0000] %asi
	mov	0x3f0, %r23
	.word 0xd6b48400  ! 1558: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd8b44400  ! 1559: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0xdef689e0  ! 1560: STXA_R	stxa	%r15, [%r26 + %r0] 0x4f
	.word 0xd0aea000  ! 1561: STBA_I	stba	%r8, [%r26 + 0x0000] %asi
	mov	0x48, %r24
	mov	0x3d0, %r20
	mov	0x50, %r19
	.word 0xd4c40400  ! 1565: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	mov	0x18, %r25
	.word 0xd4a5c4a0  ! 1567: STWA_R	stwa	%r10, [%r23 + %r0] 0x25
	mov	0x0, %r17
	mov	0x78, %r19
	.word 0xdccea000  ! 1570: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r14
	.word 0x87802072  ! 1571: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2878e80  ! 1572: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r9
	mov	0x8, %r18
	.word 0xd8af0e40  ! 1574: STBA_R	stba	%r12, [%r28 + %r0] 0x72
	.word 0xd6afce80  ! 1575: STBA_R	stba	%r11, [%r31 + %r0] 0x74
	.word 0x8780204f  ! 1576: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdabf0e60  ! 1577: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	.word 0xd284c400  ! 1578: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r9
	.word 0x87802073  ! 1579: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdac52000  ! 1580: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r13
	.word 0x87802025  ! 1581: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 1582: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x48, %r24
	mov	0x20, %r26
	.word 0x87802073  ! 1585: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f0, %r22
	.word 0xded544a0  ! 1587: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r15
	.word 0xdaf72000  ! 1588: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	mov	0x3e8, %r23
	.word 0xdcc609e0  ! 1590: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r14
	.word 0xdcf76000  ! 1591: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdc97e000  ! 1592: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xdcafe000  ! 1593: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdcdec9e0  ! 1594: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r14
	.word 0x87802074  ! 1595: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2c78e60  ! 1596: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r9
	.word 0xd8b78e80  ! 1597: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	.word 0x87802074  ! 1598: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r16
	mov	0x7f0, %r21
	.word 0xd6b44400  ! 1601: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xdaa504a0  ! 1602: STWA_R	stwa	%r13, [%r20 + %r0] 0x25
	mov	0x38, %r19
	.word 0xd0852000  ! 1604: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r8
	.word 0xdead04a0  ! 1605: STBA_R	stba	%r15, [%r20 + %r0] 0x25
	.word 0x87802074  ! 1606: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0cf2000  ! 1607: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	mov	0x3f8, %r20
	mov	0x40, %r24
	.word 0xd0f76000  ! 1610: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd29f0e80  ! 1611: LDDA_R	ldda	[%r28, %r0] 0x74, %r9
	.word 0xdab7a000  ! 1612: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdab7e000  ! 1613: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xd2cf0e40  ! 1614: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r9
	.word 0xdccf0e60  ! 1615: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r14
	.word 0xd0af8e40  ! 1616: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	mov	0x3d8, %r20
	.word 0xdccdc4a0  ! 1618: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r14
	.word 0xd4bf2000  ! 1619: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd48c4400  ! 1620: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0xd0f76000  ! 1621: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd2a40400  ! 1622: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0x87802025  ! 1623: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r26
	.word 0x87802073  ! 1625: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd08609e0  ! 1626: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r8
	mov	0x3e8, %r22
	.word 0x8780204f  ! 1628: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdca74e40  ! 1629: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	.word 0xd4846000  ! 1630: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r10
	.word 0x87802074  ! 1631: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4af2000  ! 1632: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd28f8e80  ! 1633: LDUBA_R	lduba	[%r30, %r0] 0x74, %r9
	mov	0x7e8, %r22
	mov	0x38, %r27
	mov	0x78, %r26
	.word 0xd8bf6000  ! 1637: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd8cfa000  ! 1638: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd8c72000  ! 1639: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802072  ! 1641: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r26
	.word 0x87802074  ! 1643: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8946000  ! 1644: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	.word 0xd894a000  ! 1645: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r12
	mov	0x30, %r24
	.word 0xd6b504a0  ! 1647: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	.word 0x87802020  ! 1648: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebe2000  ! 1649: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xdebc0400  ! 1651: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	mov	0x50, %r19
	.word 0xdc8fce80  ! 1653: LDUBA_R	lduba	[%r31, %r0] 0x74, %r14
	mov	0x60, %r17
	.word 0xd4cea000  ! 1655: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r10
	.word 0xd4be2000  ! 1656: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	.word 0xd89cc400  ! 1657: LDDA_R	ldda	[%r19, %r0] 0x20, %r12
	mov	0x30, %r24
	mov	0x7c8, %r20
	.word 0x87802020  ! 1660: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f40400  ! 1661: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xde848400  ! 1662: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	.word 0x87802072  ! 1663: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x20, %r16
	.word 0xdebe49e0  ! 1666: STDA_R	stda	%r15, [%r25 + %r0] 0x4f
	.word 0xdabea000  ! 1667: STDA_I	stda	%r13, [%r26 + 0x0000] %asi
	mov	0x8, %r18
	mov	0x7e0, %r21
	.word 0xd6b78e60  ! 1670: STHA_R	stha	%r11, [%r30 + %r0] 0x73
	.word 0xdc966000  ! 1671: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r14
	.word 0xdcb66000  ! 1672: STHA_I	stha	%r14, [%r25 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xdcbea000  ! 1674: STDA_I	stda	%r14, [%r26 + 0x0000] %asi
	.word 0xdcce6000  ! 1675: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r14
	mov	0x60, %r19
	.word 0x87802025  ! 1677: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcc4c400  ! 1678: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	.word 0xdeb72000  ! 1679: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 1680: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeb76000  ! 1681: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xdca70e40  ! 1682: STWA_R	stwa	%r14, [%r28 + %r0] 0x72
	.word 0x87802020  ! 1683: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0d504a0  ! 1684: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r8
	.word 0x87802074  ! 1685: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2c48400  ! 1686: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	mov	0x18, %r25
	.word 0x87802074  ! 1688: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef78e80  ! 1689: STXA_R	stxa	%r15, [%r30 + %r0] 0x74
	.word 0xd6af0e80  ! 1690: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	mov	0x28, %r16
	.word 0xdcbf4e40  ! 1692: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	mov	0x78, %r17
	.word 0x87802074  ! 1694: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 1695: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0f66000  ! 1696: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	.word 0xdeb78e80  ! 1697: STHA_R	stha	%r15, [%r30 + %r0] 0x74
	.word 0x8780204f  ! 1698: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9ea000  ! 1699: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r13
	.word 0xdaa70e40  ! 1700: STWA_R	stwa	%r13, [%r28 + %r0] 0x72
	.word 0xd4d6a000  ! 1701: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r10
	.word 0xdabfce40  ! 1702: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	.word 0xd6a78e60  ! 1703: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0xd6b44400  ! 1704: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	mov	0x10, %r24
	mov	0x20, %r24
	.word 0xda9e6000  ! 1707: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r13
	.word 0x87802074  ! 1708: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r19
	.word 0xdaa4e000  ! 1710: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0xdabca000  ! 1711: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xdabce000  ! 1712: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 1713: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8af8e40  ! 1714: STBA_R	stba	%r12, [%r30 + %r0] 0x72
	.word 0xd28cc400  ! 1715: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	.word 0xd8b5c4a0  ! 1716: STHA_R	stha	%r12, [%r23 + %r0] 0x25
	.word 0xdcdc6000  ! 1717: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	.word 0xd68cc400  ! 1718: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	.word 0xd28ec9e0  ! 1719: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r9
	.word 0xd0a4e000  ! 1720: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 1721: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bf4e80  ! 1722: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	mov	0x8, %r27
	mov	0x0, %r18
	.word 0xd8c42000  ! 1725: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r12
	.word 0xd8d4a000  ! 1726: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xd897ce40  ! 1727: LDUHA_R	lduha	[%r31, %r0] 0x72, %r12
	.word 0xd0b649e0  ! 1728: STHA_R	stha	%r8, [%r25 + %r0] 0x4f
	.word 0xd4cc2000  ! 1729: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	.word 0xd484e000  ! 1730: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r10
	.word 0xd69fce60  ! 1731: LDDA_R	ldda	[%r31, %r0] 0x73, %r11
	.word 0x87802025  ! 1732: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4b5c4a0  ! 1733: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	.word 0xdcb76000  ! 1734: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xd0be09e0  ! 1735: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0xd0f72000  ! 1736: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xd0afa000  ! 1737: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	mov	0x7f0, %r22
	.word 0xd0af2000  ! 1739: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xdca48400  ! 1740: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xdc94c400  ! 1741: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	.word 0x87802025  ! 1742: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c8, %r20
	.word 0xd4f649e0  ! 1744: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	.word 0xd0878e80  ! 1745: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r8
	.word 0xdab78e80  ! 1746: STHA_R	stha	%r13, [%r30 + %r0] 0x74
	.word 0xd08c8400  ! 1747: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0xdecde000  ! 1748: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r15
	.word 0xdeb56000  ! 1749: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	.word 0xd8f74e40  ! 1750: STXA_R	stxa	%r12, [%r29 + %r0] 0x72
	.word 0xda85a000  ! 1751: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r13
	.word 0xd4a70e80  ! 1752: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	.word 0xd68da000  ! 1753: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r11
	.word 0xd6a56000  ! 1754: STWA_I	stwa	%r11, [%r21 + 0x0000] %asi
	.word 0xd2cf4e60  ! 1755: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r9
	.word 0xd4a689e0  ! 1756: STWA_R	stwa	%r10, [%r26 + %r0] 0x4f
	mov	0x20, %r26
	.word 0xda8da000  ! 1758: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1759: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6be09e0  ! 1760: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	mov	0x58, %r27
	.word 0x87802025  ! 1762: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1763: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1764: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0dc8400  ! 1765: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0xd4a46000  ! 1766: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xdabf0e40  ! 1767: STDA_R	stda	%r13, [%r28 + %r0] 0x72
	.word 0xd88e89e0  ! 1768: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r12
	.word 0x87802072  ! 1769: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4af6000  ! 1770: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd0d74e40  ! 1771: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r8
	mov	0x40, %r24
	.word 0xdcf40400  ! 1773: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xdec7a000  ! 1774: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xdea70e60  ! 1775: STWA_R	stwa	%r15, [%r28 + %r0] 0x73
	.word 0xdca7e000  ! 1776: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	mov	0x68, %r27
	.word 0xd29d44a0  ! 1778: LDDA_R	ldda	[%r21, %r0] 0x25, %r9
	.word 0x87802020  ! 1779: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1780: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4878e80  ! 1781: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r10
	mov	0x70, %r25
	mov	0x0, %r26
	.word 0xd0ce49e0  ! 1784: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r8
	.word 0x87802072  ! 1785: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b649e0  ! 1786: STHA_R	stha	%r9, [%r25 + %r0] 0x4f
	.word 0xd4d78e40  ! 1787: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r10
	.word 0xd2b56000  ! 1788: STHA_I	stha	%r9, [%r21 + 0x0000] %asi
	.word 0xded584a0  ! 1789: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r15
	.word 0xd8d40400  ! 1790: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	.word 0xd4bda000  ! 1791: STDA_I	stda	%r10, [%r22 + 0x0000] %asi
	mov	0x30, %r25
	.word 0xd4cd6000  ! 1793: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r10
	.word 0x87802074  ! 1794: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd48c6000  ! 1795: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r10
	.word 0xd4ac6000  ! 1796: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	.word 0xd4dc6000  ! 1797: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	.word 0xdc944400  ! 1798: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	mov	0x30, %r25
	.word 0xdec4e000  ! 1800: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	.word 0xde9c2000  ! 1801: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xdef4e000  ! 1802: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xded4a000  ! 1803: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	.word 0xde8c6000  ! 1804: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0xdecc2000  ! 1805: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	mov	0x70, %r16
	.word 0x87802074  ! 1807: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdebd6000  ! 1808: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	.word 0xdaf544a0  ! 1809: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	.word 0xd4c78e80  ! 1810: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r10
	.word 0x87802073  ! 1811: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdeb6e000  ! 1813: STHA_I	stha	%r15, [%r27 + 0x0000] %asi
	.word 0x87802074  ! 1814: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2970e40  ! 1815: LDUHA_R	lduha	[%r28, %r0] 0x72, %r9
	.word 0xdcac6000  ! 1816: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xdcbf0e60  ! 1818: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	.word 0x87802020  ! 1819: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaaf4e40  ! 1820: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	.word 0xdabf4e60  ! 1821: STDA_R	stda	%r13, [%r29 + %r0] 0x73
	.word 0xd6dcc400  ! 1822: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	.word 0xd6cf0e60  ! 1823: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r11
	.word 0x87802072  ! 1824: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a7ce80  ! 1825: STWA_R	stwa	%r12, [%r31 + %r0] 0x74
	mov	0x3d8, %r20
	.word 0xd2bc8400  ! 1827: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	.word 0xdcc6e000  ! 1828: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r14
	.word 0xd6948400  ! 1829: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	mov	0x40, %r25
	.word 0xdaf6a000  ! 1831: STXA_I	stxa	%r13, [%r26 + 0x0000] %asi
	.word 0xd4b4c400  ! 1832: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0xd6a4c400  ! 1833: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0xdcdfce80  ! 1834: LDXA_R	ldxa	[%r31, %r0] 0x74, %r14
	.word 0x87802020  ! 1835: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bd04a0  ! 1836: STDA_R	stda	%r12, [%r20 + %r0] 0x25
	mov	0x3c0, %r20
	mov	0x7e8, %r21
	.word 0xdcbfe000  ! 1839: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdcb76000  ! 1840: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1841: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf5a000  ! 1842: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	mov	0x38, %r18
	mov	0x40, %r19
	.word 0x87802020  ! 1845: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r20
	.word 0xdcf46000  ! 1847: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdca4a000  ! 1848: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0xdc846000  ! 1849: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	.word 0xd2c74e60  ! 1850: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r9
	.word 0xd4d4a000  ! 1851: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0xd09fce40  ! 1852: LDDA_R	ldda	[%r31, %r0] 0x72, %r8
	.word 0xdebce000  ! 1853: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xdecce000  ! 1854: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	mov	0x3d8, %r20
	.word 0x87802025  ! 1856: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 1857: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r27
	.word 0xda9f0e80  ! 1859: LDDA_R	ldda	[%r28, %r0] 0x74, %r13
	.word 0xda948400  ! 1860: LDUHA_R	lduha	[%r18, %r0] 0x20, %r13
	.word 0x87802025  ! 1861: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcae49e0  ! 1862: STBA_R	stba	%r14, [%r25 + %r0] 0x4f
	.word 0xd8ac8400  ! 1863: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0xde866000  ! 1864: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r15
	.word 0xdece2000  ! 1865: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r15
	.word 0xdec6a000  ! 1866: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r15
	mov	0x3c8, %r23
	.word 0xd6cf8e60  ! 1868: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r11
	.word 0xdaae2000  ! 1869: STBA_I	stba	%r13, [%r24 + 0x0000] %asi
	.word 0xdaac0400  ! 1870: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xdebea000  ! 1871: STDA_I	stda	%r15, [%r26 + 0x0000] %asi
	.word 0xd8c4c400  ! 1872: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r12
	.word 0xd2ac8400  ! 1873: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xd6be89e0  ! 1874: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	.word 0xd89c0400  ! 1875: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	.word 0x87802072  ! 1876: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1877: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c4c400  ! 1878: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r12
	.word 0xd6f72000  ! 1879: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6d7a000  ! 1880: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	.word 0xd6afe000  ! 1881: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd6dfe000  ! 1882: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	mov	0x18, %r25
	mov	0x8, %r16
	mov	0x18, %r25
	.word 0xd6bfe000  ! 1886: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd6dd84a0  ! 1887: LDXA_R	ldxa	[%r22, %r0] 0x25, %r11
	.word 0x87802025  ! 1888: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r18
	.word 0xdcaca000  ! 1890: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xd2b4c400  ! 1891: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xdcace000  ! 1892: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0xdcbc6000  ! 1893: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xdef48400  ! 1894: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xdcc4a000  ! 1895: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r14
	.word 0x87802025  ! 1896: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf76000  ! 1897: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdccfa000  ! 1898: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xd09ec9e0  ! 1899: LDDA_R	ldda	[%r27, %r0] 0x4f, %r8
	.word 0xd6b7a000  ! 1900: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd6978e80  ! 1901: LDUHA_R	lduha	[%r30, %r0] 0x74, %r11
	.word 0xdc87e000  ! 1902: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcbf8e80  ! 1903: STDA_R	stda	%r14, [%r30 + %r0] 0x74
	mov	0x68, %r16
	mov	0x8, %r18
	mov	0x7c8, %r23
	.word 0xd097a000  ! 1907: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	mov	0x18, %r26
	.word 0xd0976000  ! 1909: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0cc0400  ! 1910: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xdecfce80  ! 1911: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r15
	.word 0x87802025  ! 1912: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r16
	mov	0x18, %r19
	.word 0xd6a40400  ! 1915: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	mov	0x68, %r18
	.word 0xd8bfe000  ! 1917: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	mov	0x60, %r19
	.word 0xda8c0400  ! 1919: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	.word 0xd8944400  ! 1920: LDUHA_R	lduha	[%r17, %r0] 0x20, %r12
	.word 0xd8bf6000  ! 1921: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd89fe000  ! 1922: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0xd8bf2000  ! 1923: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	mov	0x48, %r27
	mov	0x60, %r25
	.word 0xd8df6000  ! 1926: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8bf2000  ! 1927: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd8cfa000  ! 1928: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xdebf4e40  ! 1929: STDA_R	stda	%r15, [%r29 + %r0] 0x72
	.word 0xd2f649e0  ! 1930: STXA_R	stxa	%r9, [%r25 + %r0] 0x4f
	.word 0xda9584a0  ! 1931: LDUHA_R	lduha	[%r22, %r0] 0x25, %r13
	mov	0x28, %r17
	.word 0xd08c8400  ! 1933: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0xd0bf2000  ! 1934: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 1935: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8f78e60  ! 1936: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	mov	0x40, %r18
	.word 0xd0f7a000  ! 1938: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd6a48400  ! 1939: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0xdc8609e0  ! 1940: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r14
	mov	0x10, %r27
	mov	0x28, %r19
	.word 0xd6bf6000  ! 1943: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd6b7e000  ! 1944: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 1945: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd28c0400  ! 1946: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	.word 0x87802020  ! 1947: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2acc400  ! 1948: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0xd0b76000  ! 1949: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xd0972000  ! 1951: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	mov	0x30, %r25
	.word 0xd8bd84a0  ! 1953: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	.word 0x8780204f  ! 1954: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1955: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29c4400  ! 1956: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	.word 0xd2c7ce40  ! 1957: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r9
	mov	0x10, %r25
	.word 0xd0bf6000  ! 1959: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd2f689e0  ! 1960: STXA_R	stxa	%r9, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 1961: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebdc4a0  ! 1962: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	.word 0xd8cc6000  ! 1963: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r12
	.word 0xd894a000  ! 1964: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r12
	.word 0xd2d4c400  ! 1965: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r9
	mov	0x10, %r24
	.word 0xd8d4a000  ! 1967: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xd89ca000  ! 1968: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r12
	.word 0xd8bc6000  ! 1969: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0xd8dc2000  ! 1970: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1971: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdade09e0  ! 1972: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r13
	.word 0xd4afce80  ! 1973: STBA_R	stba	%r10, [%r31 + %r0] 0x74
	.word 0x87802025  ! 1974: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 1975: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b4a000  ! 1976: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xd6bfce80  ! 1977: STDA_R	stda	%r11, [%r31 + %r0] 0x74
	.word 0xd8dc2000  ! 1978: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0xd0b6c9e0  ! 1979: STHA_R	stha	%r8, [%r27 + %r0] 0x4f
	.word 0xd0944400  ! 1980: LDUHA_R	lduha	[%r17, %r0] 0x20, %r8
	mov	0x50, %r26
	mov	0x48, %r24
	mov	0x7d0, %r20
	.word 0x8780204f  ! 1984: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f7e000  ! 1985: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0bf8e80  ! 1986: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	.word 0xdcafe000  ! 1987: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	mov	0x7c0, %r20
	.word 0xdc9f0e80  ! 1989: LDDA_R	ldda	[%r28, %r0] 0x74, %r14
	mov	0x40, %r27
	.word 0x87802025  ! 1991: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 1992: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd68fa000  ! 1993: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	mov	0x60, %r25
	mov	0x7c8, %r23
	.word 0xd6dfe000  ! 1996: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	.word 0xd8b584a0  ! 1997: STHA_R	stha	%r12, [%r22 + %r0] 0x25
	mov	0x3d0, %r23
	.word 0xde87a000  ! 1999: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xdecfa000  ! 2000: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xdec7a000  ! 2001: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xdef76000  ! 2002: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdebf0e60  ! 2003: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	mov	0x7d8, %r21
	.word 0xd2b7e000  ! 2005: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2afe000  ! 2006: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xdca48400  ! 2007: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xd0bfa000  ! 2008: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0xd6b689e0  ! 2009: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	.word 0xdab76000  ! 2010: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 2011: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c8, %r21
	.word 0xd69cc400  ! 2013: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	.word 0xd097e000  ! 2014: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xdcdfce80  ! 2015: LDXA_R	ldxa	[%r31, %r0] 0x74, %r14
	mov	0x48, %r26
	mov	0x3e8, %r20
	.word 0xdcd76000  ! 2018: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	.word 0xdccf2000  ! 2019: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	.word 0xdcd76000  ! 2020: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	.word 0xdc972000  ! 2021: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	.word 0xdc8fe000  ! 2022: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xdca7e000  ! 2023: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdca7e000  ! 2024: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcf4c400  ! 2025: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xde9f2000  ! 2026: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xdab689e0  ! 2027: STHA_R	stha	%r13, [%r26 + %r0] 0x4f
	mov	0x3f0, %r21
	.word 0xd0dfe000  ! 2029: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xd8f78e40  ! 2030: STXA_R	stxa	%r12, [%r30 + %r0] 0x72
	.word 0xdc8f2000  ! 2031: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0xdc878e80  ! 2032: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r14
	.word 0xd4976000  ! 2033: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r10
	mov	0x7c8, %r22
	.word 0x87802073  ! 2035: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 2036: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r27
	.word 0x87802020  ! 2038: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a7e000  ! 2039: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2040: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0acc400  ! 2041: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd4bde000  ! 2042: STDA_I	stda	%r10, [%r23 + 0x0000] %asi
	.word 0xd48d2000  ! 2043: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0xd4f52000  ! 2044: STXA_I	stxa	%r10, [%r20 + 0x0000] %asi
	.word 0xd2bf0e40  ! 2045: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	.word 0xdac40400  ! 2046: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	mov	0x7d0, %r21
	.word 0xd4d5e000  ! 2048: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r10
	mov	0x20, %r25
	mov	0x30, %r16
	.word 0xd6b70e60  ! 2051: STHA_R	stha	%r11, [%r28 + %r0] 0x73
	mov	0x70, %r25
	.word 0xda874e80  ! 2053: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r13
	.word 0x87802020  ! 2054: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8f6000  ! 2055: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	.word 0xdecf6000  ! 2056: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	mov	0x10, %r18
	mov	0x7e8, %r23
	.word 0xd49fce80  ! 2059: LDDA_R	ldda	[%r31, %r0] 0x74, %r10
	.word 0xdace49e0  ! 2060: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r13
	.word 0x87802074  ! 2061: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeb66000  ! 2062: STHA_I	stha	%r15, [%r25 + 0x0000] %asi
	.word 0xd2878e40  ! 2063: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r9
	.word 0xd0b6e000  ! 2064: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	.word 0xd0be6000  ! 2065: STDA_I	stda	%r8, [%r25 + 0x0000] %asi
	.word 0xd09c8400  ! 2066: LDDA_R	ldda	[%r18, %r0] 0x20, %r8
	mov	0x48, %r24
	mov	0x20, %r16
	.word 0x87802025  ! 2069: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8dfe000  ! 2070: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8af6000  ! 2071: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd4f7ce80  ! 2072: STXA_R	stxa	%r10, [%r31 + %r0] 0x74
	.word 0xdeb7e000  ! 2073: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xdea7a000  ! 2074: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 2075: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde9fa000  ! 2076: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	mov	0x40, %r19
	mov	0x60, %r27
	.word 0xdecf2000  ! 2079: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdea7e000  ! 2081: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 2082: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r17
	.word 0xdedca000  ! 2084: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xdea4e000  ! 2085: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xdebc6000  ! 2086: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 2087: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r18
	.word 0xdef42000  ! 2089: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xdeac6000  ! 2090: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 2091: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0d4c400  ! 2092: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	.word 0xd6bc6000  ! 2093: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0xd6dc6000  ! 2094: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r11
	mov	0x78, %r19
	.word 0xd2c649e0  ! 2096: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r9
	.word 0xd4d4a000  ! 2097: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0xd4dce000  ! 2098: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	.word 0xd4b74e40  ! 2099: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	.word 0x87802072  ! 2100: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdadfe000  ! 2101: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0xdaf7e000  ! 2102: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xdea689e0  ! 2103: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	ta	T_CHANGE_PRIV	! macro
	mov	0x3f0, %r22
	.word 0xda972000  ! 2106: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0xdabf6000  ! 2107: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xd68cc400  ! 2108: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	mov	0x30, %r27
	.word 0xd8b7a000  ! 2110: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 2111: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r23
	.word 0xd8cca000  ! 2113: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r12
	.word 0xd8f4a000  ! 2114: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8bc8400  ! 2115: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	mov	0x0, %r25
	.word 0xdead04a0  ! 2117: STBA_R	stba	%r15, [%r20 + %r0] 0x25
	.word 0xdacc0400  ! 2118: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r13
	mov	0x0, %r26
	.word 0xd0ac4400  ! 2120: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0x87802020  ! 2121: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0840400  ! 2122: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdcc48400  ! 2124: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r14
	.word 0xd0afce40  ! 2125: STBA_R	stba	%r8, [%r31 + %r0] 0x72
	.word 0xd8c4a000  ! 2126: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r12
	mov	0x38, %r18
	.word 0xd8bca000  ! 2128: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	mov	0x20, %r26
	.word 0xd0c4c400  ! 2130: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	.word 0xd28c2000  ! 2131: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xd2d42000  ! 2132: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	mov	0x50, %r24
	.word 0x8780204f  ! 2134: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd28f6000  ! 2135: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd29f6000  ! 2136: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xdecc8400  ! 2137: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	.word 0xd8a4c400  ! 2138: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xdcf7ce60  ! 2139: STXA_R	stxa	%r14, [%r31 + %r0] 0x73
	.word 0x87802073  ! 2140: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4af8e40  ! 2141: STBA_R	stba	%r10, [%r30 + %r0] 0x72
	.word 0x87802025  ! 2142: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d0, %r22
	.word 0xd08c4400  ! 2144: LDUBA_R	lduba	[%r17, %r0] 0x20, %r8
	.word 0x87802020  ! 2145: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b5e000  ! 2146: STHA_I	stha	%r8, [%r23 + 0x0000] %asi
	.word 0xd0c56000  ! 2147: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r8
	mov	0x50, %r27
	.word 0x87802073  ! 2149: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r18
	.word 0x87802025  ! 2151: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0962000  ! 2152: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r8
	.word 0xd0c6e000  ! 2153: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r8
	.word 0x87802025  ! 2154: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8d5c4a0  ! 2155: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r12
	.word 0x87802020  ! 2156: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r16
	mov	0x38, %r19
	.word 0xd88f4e80  ! 2159: LDUBA_R	lduba	[%r29, %r0] 0x74, %r12
	.word 0xda9c6000  ! 2160: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xdacca000  ! 2161: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	.word 0xdacca000  ! 2162: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	.word 0xdef78e40  ! 2163: STXA_R	stxa	%r15, [%r30 + %r0] 0x72
	.word 0xdcb4e000  ! 2164: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	mov	0x38, %r26
	.word 0xdca4a000  ! 2166: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcc78e80  ! 2167: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r14
	.word 0x87802073  ! 2168: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 2169: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r16
	.word 0xd0f66000  ! 2171: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	.word 0xd0a6e000  ! 2172: STWA_I	stwa	%r8, [%r27 + 0x0000] %asi
	.word 0xd6ac0400  ! 2173: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0x87802072  ! 2174: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb44400  ! 2175: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0xdaaf4e80  ! 2176: STBA_R	stba	%r13, [%r29 + %r0] 0x74
	.word 0x8780204f  ! 2177: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2976000  ! 2178: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0x87802073  ! 2179: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b72000  ! 2180: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2181: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29e2000  ! 2182: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r9
	.word 0xd4b7ce40  ! 2183: STHA_R	stha	%r10, [%r31 + %r0] 0x72
	mov	0x30, %r24
	.word 0xdaa66000  ! 2185: STWA_I	stwa	%r13, [%r25 + 0x0000] %asi
	.word 0xdec6c9e0  ! 2186: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r15
	.word 0x87802074  ! 2187: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6af4e60  ! 2188: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	.word 0xdcb76000  ! 2189: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xd2de89e0  ! 2190: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r9
	mov	0x58, %r24
	.word 0xdcdf2000  ! 2192: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xd6a7ce60  ! 2193: STWA_R	stwa	%r11, [%r31 + %r0] 0x73
	.word 0xdadf6000  ! 2194: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xdabfa000  ! 2195: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	mov	0x3d0, %r21
	mov	0x40, %r24
	.word 0xda8f2000  ! 2198: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	mov	0x70, %r18
	.word 0xdc978e60  ! 2200: LDUHA_R	lduha	[%r30, %r0] 0x73, %r14
	mov	0x28, %r19
	.word 0xdc8cc400  ! 2202: LDUBA_R	lduba	[%r19, %r0] 0x20, %r14
	mov	0x7f8, %r20
	.word 0x87802074  ! 2204: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e0, %r20
	.word 0xd89f0e80  ! 2206: LDDA_R	ldda	[%r28, %r0] 0x74, %r12
	mov	0x7d8, %r23
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdcae6000  ! 2209: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	.word 0xdcd66000  ! 2210: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r14
	.word 0xdef70e60  ! 2211: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	mov	0x40, %r24
	.word 0xdc8ee000  ! 2213: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r14
	.word 0xdc9e2000  ! 2214: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r14
	.word 0xd8b78e60  ! 2215: STHA_R	stha	%r12, [%r30 + %r0] 0x73
	.word 0xd2c6e000  ! 2216: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r9
	mov	0x18, %r25
	.word 0x87802072  ! 2218: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2219: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0970e80  ! 2220: LDUHA_R	lduha	[%r28, %r0] 0x74, %r8
	mov	0x40, %r19
	.word 0xd4a74e80  ! 2222: STWA_R	stwa	%r10, [%r29 + %r0] 0x74
	.word 0xdcf42000  ! 2223: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0xdea48400  ! 2224: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	mov	0x8, %r27
	.word 0x8780204f  ! 2226: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd086a000  ! 2227: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r8
	.word 0xd0d544a0  ! 2228: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r8
	mov	0x3d0, %r20
	.word 0x87802074  ! 2230: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc948400  ! 2231: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	.word 0x87802020  ! 2232: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2233: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2234: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded76000  ! 2235: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 2236: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 2237: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf48400  ! 2238: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0x87802072  ! 2239: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0df2000  ! 2240: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0x87802072  ! 2241: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b62000  ! 2242: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0xd08e2000  ! 2243: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r8
	.word 0x87802074  ! 2244: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r27
	.word 0xdcdc4400  ! 2246: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	.word 0xd6d78e80  ! 2247: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r11
	mov	0x68, %r25
	.word 0x87802072  ! 2249: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 2250: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f76000  ! 2251: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xd2972000  ! 2252: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 2253: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdab78e80  ! 2254: STHA_R	stha	%r13, [%r30 + %r0] 0x74
	mov	0x28, %r24
	.word 0xdea40400  ! 2256: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xdaf544a0  ! 2257: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	.word 0x87802072  ! 2258: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde9f4e40  ! 2259: LDDA_R	ldda	[%r29, %r0] 0x72, %r15
	mov	0x3c8, %r23
	.word 0xd2dec9e0  ! 2261: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r9
	mov	0x7d8, %r23
	.word 0x87802073  ! 2263: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8a7e000  ! 2264: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8cf6000  ! 2265: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	mov	0x7d0, %r22
	mov	0x68, %r26
	.word 0xd89f2000  ! 2268: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0xd88f6000  ! 2269: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xd29c8400  ! 2270: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	.word 0xd0a7a000  ! 2271: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xdcb7ce40  ! 2272: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	.word 0xded72000  ! 2273: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xd8870e60  ! 2274: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r12
	mov	0x40, %r24
	.word 0xdccfe000  ! 2276: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	.word 0xdcf72000  ! 2277: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	mov	0x40, %r24
	.word 0xdc87e000  ! 2279: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xdaf6c9e0  ! 2280: STXA_R	stxa	%r13, [%r27 + %r0] 0x4f
	mov	0x38, %r18
	.word 0x87802025  ! 2282: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd48f2000  ! 2283: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xdabfce60  ! 2284: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	.word 0xd8f70e40  ! 2285: STXA_R	stxa	%r12, [%r28 + %r0] 0x72
	.word 0xd88609e0  ! 2286: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r12
	.word 0xd0f72000  ! 2287: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	mov	0x7e8, %r23
	mov	0x60, %r27
	mov	0x30, %r24
	.word 0x87802020  ! 2291: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad7ce80  ! 2292: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r13
	.word 0xd2b72000  ! 2293: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd2a76000  ! 2294: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 2295: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2296: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bf2000  ! 2297: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd6f78e40  ! 2298: STXA_R	stxa	%r11, [%r30 + %r0] 0x72
	.word 0xd8b76000  ! 2299: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0xd6a48400  ! 2301: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0xd0ccc400  ! 2302: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	.word 0x87802025  ! 2303: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e0, %r20
	.word 0xdcf7ce80  ! 2305: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	.word 0xd6a504a0  ! 2306: STWA_R	stwa	%r11, [%r20 + %r0] 0x25
	.word 0xde96e000  ! 2307: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r15
	.word 0xdc9e49e0  ! 2308: LDDA_R	ldda	[%r25, %r0] 0x4f, %r14
	mov	0x8, %r19
	.word 0x87802020  ! 2310: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdacc4400  ! 2311: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	.word 0xd2af0e80  ! 2312: STBA_R	stba	%r9, [%r28 + %r0] 0x74
	.word 0x87802020  ! 2313: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r27
	.word 0xd8b42000  ! 2315: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	.word 0xd2c40400  ! 2316: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r9
	.word 0xd294e000  ! 2317: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	.word 0xd2c4a000  ! 2318: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	.word 0xdcc70e40  ! 2319: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r14
	.word 0x8780204f  ! 2320: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f40400  ! 2321: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xd8c56000  ! 2322: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r12
	.word 0xd8c504a0  ! 2323: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r12
	.word 0xdcbda000  ! 2324: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	mov	0x10, %r25
	.word 0xd0dc4400  ! 2326: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	mov	0x38, %r24
	.word 0xd0c7ce40  ! 2328: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r8
	mov	0x58, %r24
	.word 0x8780204f  ! 2330: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 2331: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6af0e60  ! 2332: STBA_R	stba	%r11, [%r28 + %r0] 0x73
	.word 0xd0b5c4a0  ! 2333: STHA_R	stha	%r8, [%r23 + %r0] 0x25
	mov	0x3c8, %r23
	mov	0x48, %r26
	.word 0xdcf40400  ! 2336: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xdeae49e0  ! 2337: STBA_R	stba	%r15, [%r25 + %r0] 0x4f
	.word 0x87802025  ! 2338: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a74e60  ! 2339: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	.word 0xdeae89e0  ! 2340: STBA_R	stba	%r15, [%r26 + %r0] 0x4f
	.word 0xd2a76000  ! 2341: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd4a609e0  ! 2342: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	mov	0x58, %r24
	.word 0xdad4c400  ! 2344: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xd4dd44a0  ! 2345: LDXA_R	ldxa	[%r21, %r0] 0x25, %r10
	.word 0x87802074  ! 2346: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f0, %r22
	.word 0xd0bd04a0  ! 2348: STDA_R	stda	%r8, [%r20 + %r0] 0x25
	.word 0xda9d04a0  ! 2349: LDDA_R	ldda	[%r20, %r0] 0x25, %r13
	.word 0xd6844400  ! 2350: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r11
	.word 0xd48c0400  ! 2351: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	.word 0xd6946000  ! 2352: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r11
	mov	0x70, %r27
	mov	0x58, %r18
	.word 0xd09c0400  ! 2355: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	mov	0x3e8, %r21
	.word 0x87802073  ! 2357: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef70e40  ! 2358: STXA_R	stxa	%r15, [%r28 + %r0] 0x72
	.word 0xd8c72000  ! 2359: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8dfe000  ! 2360: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	mov	0x50, %r16
	.word 0x87802020  ! 2362: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcde49e0  ! 2363: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r14
	.word 0x87802074  ! 2364: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdea70e40  ! 2365: STWA_R	stwa	%r15, [%r28 + %r0] 0x72
	.word 0xd48ca000  ! 2366: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r10
	.word 0xd4946000  ! 2367: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r10
	.word 0xde9f0e60  ! 2368: LDDA_R	ldda	[%r28, %r0] 0x73, %r15
	.word 0xdcd4a000  ! 2369: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	.word 0xd2c7ce40  ! 2370: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r9
	.word 0xd8a4c400  ! 2371: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xd0a4a000  ! 2372: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0xd0bc6000  ! 2373: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	.word 0xd0946000  ! 2374: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0xd2b544a0  ! 2375: STHA_R	stha	%r9, [%r21 + %r0] 0x25
	.word 0xdecc0400  ! 2376: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r15
	.word 0xd88c2000  ! 2377: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	.word 0xd8be49e0  ! 2378: STDA_R	stda	%r12, [%r25 + %r0] 0x4f
	.word 0xdabc2000  ! 2379: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 2380: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa584a0  ! 2381: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	.word 0xdeac6000  ! 2382: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	mov	0x20, %r19
	.word 0x87802072  ! 2384: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49ec9e0  ! 2385: LDDA_R	ldda	[%r27, %r0] 0x4f, %r10
	.word 0xd2a584a0  ! 2386: STWA_R	stwa	%r9, [%r22 + %r0] 0x25
	.word 0xdaad04a0  ! 2387: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	.word 0xd4a56000  ! 2388: STWA_I	stwa	%r10, [%r21 + 0x0000] %asi
	.word 0xd4d5a000  ! 2389: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r10
	mov	0x50, %r25
	.word 0xd495e000  ! 2391: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r10
	.word 0xd0a544a0  ! 2392: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	mov	0x30, %r27
	mov	0x7c0, %r23
	.word 0xdadd2000  ! 2395: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r13
	.word 0xd09c4400  ! 2396: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	mov	0x58, %r27
	.word 0xd2bd6000  ! 2398: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	.word 0xd2b74e60  ! 2399: STHA_R	stha	%r9, [%r29 + %r0] 0x73
	mov	0x38, %r25
	.word 0x87802020  ! 2401: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebce000  ! 2402: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xd2b48400  ! 2403: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	mov	0x3c8, %r21
	.word 0xd6dc6000  ! 2405: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r11
	ta	T_CHANGE_PRIV	! macro
	.word 0xd694a000  ! 2407: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r11
	.word 0xd6ac6000  ! 2408: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	mov	0x0, %r19
	mov	0x3c8, %r22
	mov	0x7d0, %r22
	.word 0xde8f0e80  ! 2412: LDUBA_R	lduba	[%r28, %r0] 0x74, %r15
	.word 0xd4bf4e40  ! 2413: STDA_R	stda	%r10, [%r29 + %r0] 0x72
	.word 0xdcb4e000  ! 2414: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xd486c9e0  ! 2415: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r10
	.word 0xd6b4a000  ! 2416: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd6f70e80  ! 2417: STXA_R	stxa	%r11, [%r28 + %r0] 0x74
	mov	0x40, %r19
	.word 0xdc946000  ! 2419: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r14
	.word 0xdea78e60  ! 2420: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	mov	0x40, %r24
	.word 0xd2bd04a0  ! 2422: STDA_R	stda	%r9, [%r20 + %r0] 0x25
	.word 0xd6dc6000  ! 2423: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r11
	.word 0xdebc0400  ! 2424: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0xd8dc2000  ! 2425: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0xdc9e89e0  ! 2426: LDDA_R	ldda	[%r26, %r0] 0x4f, %r14
	.word 0xd4a48400  ! 2427: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	mov	0x70, %r27
	.word 0xdcafce80  ! 2429: STBA_R	stba	%r14, [%r31 + %r0] 0x74
	.word 0xd2842000  ! 2430: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r9
	.word 0xd0cc8400  ! 2431: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	mov	0x30, %r18
	.word 0x87802073  ! 2433: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r16
	.word 0xd6ae6000  ! 2435: STBA_I	stba	%r11, [%r25 + 0x0000] %asi
	.word 0xdad504a0  ! 2436: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r13
	.word 0xd8cee000  ! 2437: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r12
	mov	0x28, %r17
	.word 0x87802072  ! 2439: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 2440: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb78e60  ! 2441: STHA_R	stha	%r15, [%r30 + %r0] 0x73
	.word 0xd09609e0  ! 2442: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r8
	.word 0xd0ad04a0  ! 2443: STBA_R	stba	%r8, [%r20 + %r0] 0x25
	.word 0xd8f7a000  ! 2444: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 2445: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8af4e60  ! 2446: STBA_R	stba	%r12, [%r29 + %r0] 0x73
	mov	0x68, %r19
	.word 0xdcbd04a0  ! 2448: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	.word 0xdea78e80  ! 2449: STWA_R	stwa	%r15, [%r30 + %r0] 0x74
	.word 0xde876000  ! 2450: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xdea78e80  ! 2451: STWA_R	stwa	%r15, [%r30 + %r0] 0x74
	.word 0xdea4c400  ! 2452: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	.word 0xdea78e60  ! 2453: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	mov	0x58, %r17
	.word 0xd8c72000  ! 2455: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xdabc4400  ! 2456: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	mov	0x70, %r16
	.word 0xd2c48400  ! 2458: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0xd89c4400  ! 2459: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	.word 0xdec7e000  ! 2460: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xded7a000  ! 2461: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xdcaf0e40  ! 2462: STBA_R	stba	%r14, [%r28 + %r0] 0x72
	mov	0x3d0, %r20
	mov	0x20, %r25
	.word 0xdaf74e40  ! 2465: STXA_R	stxa	%r13, [%r29 + %r0] 0x72
	.word 0xd697a000  ! 2466: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	mov	0x58, %r18
	.word 0xd0a4c400  ! 2468: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	mov	0x7e0, %r21
	.word 0xdc9f4e40  ! 2470: LDDA_R	ldda	[%r29, %r0] 0x72, %r14
	.word 0xd0cf6000  ! 2471: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xdcd40400  ! 2472: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	.word 0xd0a7a000  ! 2473: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 2474: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd08f2000  ! 2475: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	mov	0x50, %r17
	.word 0xdeb609e0  ! 2477: STHA_R	stha	%r15, [%r24 + %r0] 0x4f
	.word 0xd4f76000  ! 2478: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4bfa000  ! 2479: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 2480: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r16
	.word 0xd4d4a000  ! 2482: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	mov	0x28, %r18
	.word 0x87802074  ! 2484: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd89c0400  ! 2485: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	.word 0xd6b504a0  ! 2486: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	.word 0xd6f4c400  ! 2487: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0xd6cf6000  ! 2488: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6c689e0  ! 2489: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r11
	mov	0x3f0, %r21
	.word 0xdcf7ce40  ! 2491: STXA_R	stxa	%r14, [%r31 + %r0] 0x72
	.word 0xdacfa000  ! 2492: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xda940400  ! 2493: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	.word 0xdebcc400  ! 2494: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	.word 0xdecfe000  ! 2495: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xd4bd04a0  ! 2496: STDA_R	stda	%r10, [%r20 + %r0] 0x25
	.word 0xdec44400  ! 2497: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0xd2d74e40  ! 2498: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r9
	.word 0xde9d84a0  ! 2499: LDDA_R	ldda	[%r22, %r0] 0x25, %r15
	.word 0x87802073  ! 2500: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r19
	.word 0xda97e000  ! 2502: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	mov	0x3c8, %r23
	.word 0xdaafe000  ! 2504: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xdaa7e000  ! 2505: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xda97ce60  ! 2506: LDUHA_R	lduha	[%r31, %r0] 0x73, %r13
	.word 0xdcd7a000  ! 2507: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0xdc976000  ! 2508: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	mov	0x3c0, %r22
	.word 0xdccfa000  ! 2510: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 2511: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdad6c9e0  ! 2512: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r13
	mov	0x7e0, %r22
	.word 0xdab4c400  ! 2514: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xdadfe000  ! 2515: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0xdaf76000  ! 2516: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdac4c400  ! 2517: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r13
	mov	0x60, %r27
	.word 0xdaa72000  ! 2519: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2520: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8c0400  ! 2521: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0xdade49e0  ! 2522: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r13
	.word 0x8780204f  ! 2523: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdac7a000  ! 2524: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2525: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac4a000  ! 2526: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	mov	0x7c0, %r23
	mov	0x40, %r19
	.word 0xdab4e000  ! 2529: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0xdaa4a000  ! 2531: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	mov	0x3c0, %r22
	mov	0x3f0, %r21
	mov	0x3e0, %r21
	mov	0x68, %r27
	.word 0xdaa4e000  ! 2536: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	mov	0x7c8, %r22
	.word 0xda8c6000  ! 2538: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r13
	.word 0xd8b78e80  ! 2539: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	.word 0xdcf4a000  ! 2540: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdca4a000  ! 2541: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcbce000  ! 2542: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xd6a74e40  ! 2543: STWA_R	stwa	%r11, [%r29 + %r0] 0x72
	.word 0xd8aca000  ! 2544: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	mov	0x3f8, %r20
	mov	0x7d0, %r20
	.word 0xd4adc4a0  ! 2547: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd88ce000  ! 2549: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	mov	0x60, %r16
	.word 0x87802020  ! 2551: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd294c400  ! 2552: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	.word 0x87802020  ! 2553: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbf6000  ! 2554: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xd8f504a0  ! 2555: STXA_R	stxa	%r12, [%r20 + %r0] 0x25
	.word 0xdef7e000  ! 2556: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	mov	0x7e0, %r21
	mov	0x28, %r25
	.word 0x87802072  ! 2559: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xded78e80  ! 2560: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r15
	.word 0xdcc544a0  ! 2561: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r14
	.word 0xd0ad2000  ! 2562: STBA_I	stba	%r8, [%r20 + 0x0000] %asi
	mov	0x68, %r16
	.word 0xd2b48400  ! 2564: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd0a56000  ! 2565: STWA_I	stwa	%r8, [%r21 + 0x0000] %asi
	.word 0xd0dd6000  ! 2566: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r8
	.word 0xd0bde000  ! 2567: STDA_I	stda	%r8, [%r23 + 0x0000] %asi
	mov	0x20, %r16
	.word 0xd08da000  ! 2569: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r8
	mov	0x68, %r26
	mov	0x10, %r27
	.word 0x8780204f  ! 2572: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b5a000  ! 2573: STHA_I	stha	%r8, [%r22 + 0x0000] %asi
	.word 0xd0ad6000  ! 2574: STBA_I	stba	%r8, [%r21 + 0x0000] %asi
	.word 0xd095e000  ! 2575: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r8
	.word 0xdadf8e40  ! 2576: LDXA_R	ldxa	[%r30, %r0] 0x72, %r13
	.word 0x8780204f  ! 2577: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2578: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2579: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaf544a0  ! 2580: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	.word 0xda87e000  ! 2581: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	mov	0x0, %r17
	.word 0xd6df0e40  ! 2583: LDXA_R	ldxa	[%r28, %r0] 0x72, %r11
	.word 0xd8b7e000  ! 2584: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2585: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca544a0  ! 2586: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0xd6bf4e60  ! 2587: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	.word 0xd08ca000  ! 2588: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xd0aca000  ! 2589: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xd08ce000  ! 2590: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0a42000  ! 2591: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xd08ca000  ! 2592: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xd0d42000  ! 2593: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r8
	.word 0xd0b4a000  ! 2594: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xdadd44a0  ! 2595: LDXA_R	ldxa	[%r21, %r0] 0x25, %r13
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x3f8, %r20
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd8dc2000  ! 2599: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0xd8ace000  ! 2600: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0xd4c5c4a0  ! 2601: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r10
	.word 0x87802020  ! 2602: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29584a0  ! 2603: LDUHA_R	lduha	[%r22, %r0] 0x25, %r9
	.word 0xd48fe000  ! 2604: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xd08c0400  ! 2605: LDUBA_R	lduba	[%r16, %r0] 0x20, %r8
	.word 0xdeafa000  ! 2606: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 2607: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdace89e0  ! 2608: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r13
	.word 0x87802020  ! 2609: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeaca000  ! 2610: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xde8c6000  ! 2611: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0x87802020  ! 2612: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded72000  ! 2613: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	mov	0x3e8, %r21
	.word 0xded7e000  ! 2615: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	mov	0x7d8, %r22
	.word 0xdef76000  ! 2617: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xd6bf0e40  ! 2618: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	.word 0xd4af0e40  ! 2619: STBA_R	stba	%r10, [%r28 + %r0] 0x72
	.word 0xdcf7e000  ! 2620: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdeac4400  ! 2621: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0xdcad44a0  ! 2622: STBA_R	stba	%r14, [%r21 + %r0] 0x25
	.word 0x87802073  ! 2623: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a70e80  ! 2624: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	mov	0x3e8, %r23
	mov	0x18, %r17
	.word 0x87802073  ! 2627: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeaf6000  ! 2628: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xdebfa000  ! 2629: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	mov	0x78, %r18
	mov	0x3f0, %r23
	.word 0xdecf2000  ! 2632: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xdef72000  ! 2633: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xde8c0400  ! 2634: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0xdaa76000  ! 2635: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 2636: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4bc8400  ! 2637: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	.word 0xdcd7ce40  ! 2638: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r14
	.word 0xd8bce000  ! 2639: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd8b4a000  ! 2640: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	mov	0x10, %r17
	.word 0x8780204f  ! 2642: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bc6000  ! 2643: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0xd8c46000  ! 2644: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r12
	mov	0x28, %r24
	mov	0x0, %r19
	.word 0xd4bcc400  ! 2647: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0xd48fce40  ! 2648: LDUBA_R	lduba	[%r31, %r0] 0x72, %r10
	.word 0xd4bce000  ! 2649: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0xd2a70e80  ! 2650: STWA_R	stwa	%r9, [%r28 + %r0] 0x74
	.word 0x87802074  ! 2651: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdac40400  ! 2652: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	.word 0xd0952000  ! 2653: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r8
	.word 0xd88f4e60  ! 2654: LDUBA_R	lduba	[%r29, %r0] 0x73, %r12
	.word 0x87802020  ! 2655: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2656: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0842000  ! 2657: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r8
	.word 0xdedf8e80  ! 2658: LDXA_R	ldxa	[%r30, %r0] 0x74, %r15
	.word 0xdcde89e0  ! 2659: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r14
	.word 0x87802025  ! 2660: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2661: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d544a0  ! 2662: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r10
	.word 0x8780204f  ! 2663: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 2664: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 2665: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd695e000  ! 2666: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 2667: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bdc4a0  ! 2668: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	.word 0xd0bc8400  ! 2669: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0xd0df0e80  ! 2670: LDXA_R	ldxa	[%r28, %r0] 0x74, %r8
	.word 0xdcdf6000  ! 2671: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	mov	0x3e0, %r22
	.word 0xdcf78e60  ! 2673: STXA_R	stxa	%r14, [%r30 + %r0] 0x73
	.word 0xd89fe000  ! 2674: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0xd8f76000  ! 2675: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8d7e000  ! 2676: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0xd6b7ce60  ! 2677: STHA_R	stha	%r11, [%r31 + %r0] 0x73
	mov	0x7d0, %r20
	.word 0xdab7a000  ! 2679: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	mov	0x3f8, %r22
	.word 0xdcd74e40  ! 2681: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r14
	.word 0xd6bd04a0  ! 2682: STDA_R	stda	%r11, [%r20 + %r0] 0x25
	.word 0xd4c6c9e0  ! 2683: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r10
	.word 0xdaa74e80  ! 2684: STWA_R	stwa	%r13, [%r29 + %r0] 0x74
	.word 0xd6a72000  ! 2685: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6cfe000  ! 2686: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	mov	0x3f8, %r23
	.word 0x87802072  ! 2688: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r17
	.word 0xd6af8e80  ! 2690: STBA_R	stba	%r11, [%r30 + %r0] 0x74
	.word 0x87802073  ! 2691: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b6a000  ! 2692: STHA_I	stha	%r8, [%r26 + 0x0000] %asi
	.word 0xd2cfce40  ! 2693: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r9
	.word 0xd4c66000  ! 2694: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r10
	.word 0xd4bee000  ! 2695: STDA_I	stda	%r10, [%r27 + 0x0000] %asi
	mov	0x7e0, %r20
	.word 0xd4870e80  ! 2697: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r10
	.word 0xd886a000  ! 2698: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r12
	.word 0xd6a74e60  ! 2699: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	.word 0xdcac4400  ! 2700: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	.word 0xd08ea000  ! 2701: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r8
	.word 0xd4df8e60  ! 2702: LDXA_R	ldxa	[%r30, %r0] 0x73, %r10
	.word 0xdec44400  ! 2703: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0x87802020  ! 2704: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebce000  ! 2705: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xd4b4c400  ! 2706: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 2707: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdecf8e60  ! 2708: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r15
	.word 0xdeb7e000  ! 2709: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xd69f0e60  ! 2710: LDDA_R	ldda	[%r28, %r0] 0x73, %r11
	mov	0x7e8, %r23
	.word 0xd6af8e40  ! 2712: STBA_R	stba	%r11, [%r30 + %r0] 0x72
	.word 0xd48c4400  ! 2713: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0x87802020  ! 2714: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdecc2000  ! 2715: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	.word 0xde942000  ! 2716: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	mov	0x50, %r16
	.word 0xdcbc4400  ! 2718: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	mov	0x50, %r19
	.word 0xd0a46000  ! 2720: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xd2b6c9e0  ! 2721: STHA_R	stha	%r9, [%r27 + %r0] 0x4f
	.word 0xd4d42000  ! 2722: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	.word 0x87802074  ! 2723: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r24
	.word 0xd4874e80  ! 2725: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r10
	.word 0xd6cf6000  ! 2726: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0x87802074  ! 2727: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r25
	.word 0xde878e40  ! 2729: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r15
	mov	0x7c8, %r22
	mov	0x3d0, %r23
	.word 0xdabc4400  ! 2732: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	mov	0x7e0, %r20
	.word 0x87802025  ! 2734: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f8, %r20
	.word 0xd6dd6000  ! 2736: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r11
	mov	0x7c8, %r22
	mov	0x30, %r19
	.word 0xd4bfce60  ! 2739: STDA_R	stda	%r10, [%r31 + %r0] 0x73
	.word 0xd4f40400  ! 2740: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	mov	0x7d0, %r21
	.word 0xd0c78e40  ! 2742: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r8
	.word 0x87802074  ! 2743: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r27
	.word 0xd6dd6000  ! 2745: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r11
	.word 0xd6f5e000  ! 2746: STXA_I	stxa	%r11, [%r23 + 0x0000] %asi
	.word 0xd685a000  ! 2747: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r11
	mov	0x38, %r25
	.word 0xd697ce40  ! 2749: LDUHA_R	lduha	[%r31, %r0] 0x72, %r11
	.word 0xd8f544a0  ! 2750: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	mov	0x30, %r25
	.word 0xd2df0e40  ! 2752: LDXA_R	ldxa	[%r28, %r0] 0x72, %r9
	mov	0x7d0, %r20
	.word 0xded40400  ! 2754: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	.word 0xda8cc400  ! 2755: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	mov	0x20, %r18
	.word 0xd8cf8e60  ! 2757: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r12
	.word 0xd2f609e0  ! 2758: STXA_R	stxa	%r9, [%r24 + %r0] 0x4f
	.word 0xd2ad44a0  ! 2759: STBA_R	stba	%r9, [%r21 + %r0] 0x25
	mov	0x28, %r18
	.word 0xd09da000  ! 2761: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r8
	.word 0xdca74e60  ! 2762: STWA_R	stwa	%r14, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 2763: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 2764: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 2765: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4acc400  ! 2766: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xde84c400  ! 2767: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0x87802072  ! 2768: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd28c2000  ! 2769: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xd2946000  ! 2770: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2771: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r18
	.word 0x87802074  ! 2773: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f48400  ! 2774: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	mov	0x7f0, %r20
	mov	0x58, %r18
	mov	0x7f8, %r23
	.word 0xd0f7a000  ! 2778: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	mov	0x7e0, %r22
	.word 0x87802025  ! 2780: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2ad44a0  ! 2781: STBA_R	stba	%r9, [%r21 + %r0] 0x25
	mov	0x40, %r19
	.word 0xd2f6a000  ! 2783: STXA_I	stxa	%r9, [%r26 + 0x0000] %asi
	.word 0xd2de2000  ! 2784: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2b62000  ! 2786: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	.word 0xdca78e40  ! 2787: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	.word 0xd0d4c400  ! 2788: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	mov	0x3f0, %r21
	mov	0x70, %r27
	.word 0x87802020  ! 2791: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bf8e80  ! 2792: STDA_R	stda	%r12, [%r30 + %r0] 0x74
	.word 0x87802074  ! 2793: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r26
	.word 0x87802072  ! 2795: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeae6000  ! 2796: STBA_I	stba	%r15, [%r25 + 0x0000] %asi
	.word 0xd4a689e0  ! 2797: STWA_R	stwa	%r10, [%r26 + %r0] 0x4f
	.word 0x87802073  ! 2798: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 2799: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6c78e80  ! 2800: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r11
	.word 0xda87a000  ! 2801: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0xdccdc4a0  ! 2802: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r14
	.word 0xdabf2000  ! 2803: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xd6af4e60  ! 2804: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	.word 0xd4f72000  ! 2805: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4a72000  ! 2806: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xdecf8e80  ! 2807: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r15
	mov	0x0, %r19
	.word 0x87802074  ! 2809: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r19
	.word 0xda872000  ! 2811: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0xda8f6000  ! 2812: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xdcd544a0  ! 2813: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r14
	mov	0x3d8, %r20
	.word 0xd48fa000  ! 2815: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0x87802072  ! 2816: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 2817: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r19
	mov	0x8, %r16
	.word 0xd6be49e0  ! 2820: STDA_R	stda	%r11, [%r25 + %r0] 0x4f
	.word 0xd0d7a000  ! 2821: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0xd0a7e000  ! 2822: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xd69f8e60  ! 2823: LDDA_R	ldda	[%r30, %r0] 0x73, %r11
	.word 0xd0976000  ! 2824: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xdcde49e0  ! 2825: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r14
	.word 0xd08cc400  ! 2826: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	.word 0x87802074  ! 2827: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6bc0400  ! 2828: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xd49fce80  ! 2829: LDDA_R	ldda	[%r31, %r0] 0x74, %r10
	mov	0x3f8, %r21
	.word 0xd494e000  ! 2831: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	mov	0x28, %r24
	.word 0xd8f48400  ! 2833: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xde9c2000  ! 2834: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xdebce000  ! 2835: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xdeace000  ! 2836: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xdca7ce80  ! 2837: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	mov	0x50, %r18
	.word 0x87802074  ! 2839: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28c2000  ! 2840: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	mov	0x68, %r27
	mov	0x48, %r25
	.word 0xd2842000  ! 2843: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r9
	.word 0xdcdf0e40  ! 2844: LDXA_R	ldxa	[%r28, %r0] 0x72, %r14
	.word 0xd2840400  ! 2845: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r9
	.word 0x87802073  ! 2846: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 2847: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf76000  ! 2848: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xdc87a000  ! 2850: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0x87802072  ! 2851: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x8780204f  ! 2853: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcafce60  ! 2854: STBA_R	stba	%r14, [%r31 + %r0] 0x73
	mov	0x7e0, %r20
	.word 0xdab48400  ! 2856: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	mov	0x3c8, %r22
	.word 0xdebc0400  ! 2858: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0xdea44400  ! 2859: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xda8d84a0  ! 2860: LDUBA_R	lduba	[%r22, %r0] 0x25, %r13
	.word 0xd486a000  ! 2861: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r10
	mov	0x7c8, %r21
	mov	0x3c8, %r23
	.word 0xd4a62000  ! 2864: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	mov	0x8, %r24
	.word 0xd4a6a000  ! 2866: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	.word 0xd8cc8400  ! 2867: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0xd29d84a0  ! 2868: LDDA_R	ldda	[%r22, %r0] 0x25, %r9
	.word 0xd2aea000  ! 2869: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0xd28e2000  ! 2870: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	mov	0x7f8, %r23
	.word 0xd2cee000  ! 2872: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	.word 0xd2de6000  ! 2873: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r9
	.word 0xded40400  ! 2874: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	.word 0xd684c400  ! 2875: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	.word 0xdea6a000  ! 2876: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	.word 0xdef66000  ! 2877: STXA_I	stxa	%r15, [%r25 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xd0aec9e0  ! 2879: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	mov	0x3d0, %r21
	.word 0xd4a7ce80  ! 2881: STWA_R	stwa	%r10, [%r31 + %r0] 0x74
	ta	T_CHANGE_PRIV	! macro
	.word 0xdec544a0  ! 2883: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r15
	.word 0xdaa689e0  ! 2884: STWA_R	stwa	%r13, [%r26 + %r0] 0x4f
	.word 0xd6be2000  ! 2885: STDA_I	stda	%r11, [%r24 + 0x0000] %asi
	.word 0xd8ae49e0  ! 2886: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	mov	0x50, %r16
	.word 0xd2b689e0  ! 2888: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	.word 0xdabd44a0  ! 2889: STDA_R	stda	%r13, [%r21 + %r0] 0x25
	.word 0xd29d04a0  ! 2890: LDDA_R	ldda	[%r20, %r0] 0x25, %r9
	.word 0x87802020  ! 2891: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r23
	.word 0xd4c70e60  ! 2893: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r10
	.word 0xd2dc4400  ! 2894: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xd697a000  ! 2895: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0xd6d76000  ! 2896: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	mov	0x7d0, %r21
	.word 0xd2a74e40  ! 2898: STWA_R	stwa	%r9, [%r29 + %r0] 0x72
	.word 0xd8ccc400  ! 2899: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r12
	.word 0xd08c0400  ! 2900: LDUBA_R	lduba	[%r16, %r0] 0x20, %r8
	mov	0x50, %r17
	mov	0x68, %r18
	.word 0xdeaf8e60  ! 2903: STBA_R	stba	%r15, [%r30 + %r0] 0x73
	.word 0xdecc8400  ! 2904: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	.word 0xdc8544a0  ! 2905: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r14
	.word 0xdcf5c4a0  ! 2906: STXA_R	stxa	%r14, [%r23 + %r0] 0x25
	mov	0x10, %r25
	.word 0xdabfa000  ! 2908: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	mov	0x38, %r19
	mov	0x0, %r19
	.word 0xda978e40  ! 2911: LDUHA_R	lduha	[%r30, %r0] 0x72, %r13
	.word 0xd0afe000  ! 2912: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0bfa000  ! 2913: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 2914: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd097a000  ! 2915: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	.word 0xd4bc8400  ! 2916: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	mov	0x48, %r25
	.word 0x87802074  ! 2918: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c8, %r23
	.word 0xd4af8e80  ! 2920: STBA_R	stba	%r10, [%r30 + %r0] 0x74
	.word 0xdef5a000  ! 2921: STXA_I	stxa	%r15, [%r22 + 0x0000] %asi
	.word 0xd0b544a0  ! 2922: STHA_R	stha	%r8, [%r21 + %r0] 0x25
	.word 0xd6cda000  ! 2923: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r11
	.word 0xd2cf0e40  ! 2924: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r9
	ta	T_CHANGE_HPRIV	! macro
	mov	0x70, %r19
	.word 0xdead2000  ! 2927: STBA_I	stba	%r15, [%r20 + 0x0000] %asi
	.word 0xd6840400  ! 2928: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0xdaade000  ! 2929: STBA_I	stba	%r13, [%r23 + 0x0000] %asi
	.word 0xdaad2000  ! 2930: STBA_I	stba	%r13, [%r20 + 0x0000] %asi
	.word 0xda856000  ! 2931: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r13
	.word 0xdab56000  ! 2932: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	mov	0x38, %r26
	mov	0x20, %r16
	mov	0x68, %r26
	.word 0xd49f8e40  ! 2936: LDDA_R	ldda	[%r30, %r0] 0x72, %r10
	.word 0xdabe09e0  ! 2937: STDA_R	stda	%r13, [%r24 + %r0] 0x4f
	.word 0xd4df0e80  ! 2938: LDXA_R	ldxa	[%r28, %r0] 0x74, %r10
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xda8e09e0  ! 2940: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r13
	.word 0xdccf8e80  ! 2941: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r14
	.word 0x87802020  ! 2942: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0af0e60  ! 2943: STBA_R	stba	%r8, [%r28 + %r0] 0x73
	.word 0xdaadc4a0  ! 2944: STBA_R	stba	%r13, [%r23 + %r0] 0x25
	.word 0x87802072  ! 2945: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2946: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a70e80  ! 2947: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0xdadc2000  ! 2948: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r13
	.word 0xda9c6000  ! 2949: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xdca74e60  ! 2950: STWA_R	stwa	%r14, [%r29 + %r0] 0x73
	.word 0xdcb46000  ! 2951: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xd0d48400  ! 2952: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	mov	0x20, %r17
	.word 0xdea7ce80  ! 2954: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	mov	0x68, %r25
	.word 0xd2f5c4a0  ! 2956: STXA_R	stxa	%r9, [%r23 + %r0] 0x25
	.word 0xd2a649e0  ! 2957: STWA_R	stwa	%r9, [%r25 + %r0] 0x4f
	.word 0xd0a74e80  ! 2958: STWA_R	stwa	%r8, [%r29 + %r0] 0x74
	.word 0xde84c400  ! 2959: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	mov	0x3d0, %r21
	mov	0x78, %r16
	.word 0xdcb4e000  ! 2962: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 2963: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 2964: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 2965: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r24
	.word 0xdc97a000  ! 2967: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	.word 0xdca76000  ! 2968: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcb7e000  ! 2969: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xd6bc0400  ! 2970: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	mov	0x0, %r27
	.word 0xd69fa000  ! 2972: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0xdcdf4e40  ! 2973: LDXA_R	ldxa	[%r29, %r0] 0x72, %r14
	.word 0xd2a7e000  ! 2974: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xded584a0  ! 2975: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r15
	.word 0xd2978e40  ! 2976: LDUHA_R	lduha	[%r30, %r0] 0x72, %r9
	mov	0x28, %r17
	.word 0xdade09e0  ! 2978: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r13
	.word 0xd2ad04a0  ! 2979: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	.word 0xd8cf4e60  ! 2980: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r12
	.word 0xd8b40400  ! 2981: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xd6d7a000  ! 2982: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	mov	0x20, %r17
	.word 0xd69f2000  ! 2984: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xd2cc8400  ! 2985: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0xd2b72000  ! 2986: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd8b74e60  ! 2987: STHA_R	stha	%r12, [%r29 + %r0] 0x73
	mov	0x8, %r16
	.word 0xde97a000  ! 2989: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	.word 0xd8d6c9e0  ! 2990: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r12
	mov	0x40, %r26
	.word 0xdc87e000  ! 2992: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xdc974e80  ! 2993: LDUHA_R	lduha	[%r29, %r0] 0x74, %r14
	.word 0x8780204f  ! 2994: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdac78e40  ! 2995: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r13
	.word 0xd08c8400  ! 2996: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0x87802074  ! 2997: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbee000  ! 2998: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	mov	0x40, %r17
	.word 0xd897ce40  ! 3000: LDUHA_R	lduha	[%r31, %r0] 0x72, %r12
	.word 0x87802072  ! 3001: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4b42000  ! 3002: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	.word 0xd4a42000  ! 3003: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0xd49ce000  ! 3004: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0xdabf4e80  ! 3005: STDA_R	stda	%r13, [%r29 + %r0] 0x74
	.word 0x87802074  ! 3006: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2a42000  ! 3007: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	.word 0xd2a4e000  ! 3008: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0xd6b504a0  ! 3009: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	.word 0xdabca000  ! 3010: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	mov	0x58, %r24
	.word 0xd4cdc4a0  ! 3012: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r10
	.word 0xda8fce80  ! 3013: LDUBA_R	lduba	[%r31, %r0] 0x74, %r13
	ta	T_CHANGE_PRIV	! macro
	mov	0x68, %r26
	.word 0xd2b48400  ! 3016: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xdcbf0e60  ! 3017: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	.word 0xd4d4e000  ! 3018: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0xd0be49e0  ! 3019: STDA_R	stda	%r8, [%r25 + %r0] 0x4f
	.word 0xd0be49e0  ! 3020: STDA_R	stda	%r8, [%r25 + %r0] 0x4f
	.word 0xd49c2000  ! 3021: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	.word 0xd4cce000  ! 3022: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r10
	mov	0x50, %r17
	.word 0x8780204f  ! 3024: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a62000  ! 3025: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	.word 0xd4b74e40  ! 3026: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	.word 0xd2c62000  ! 3027: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3028: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3029: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r25
	mov	0x68, %r17
	.word 0xd8a544a0  ! 3032: STWA_R	stwa	%r12, [%r21 + %r0] 0x25
	.word 0xd89dc4a0  ! 3033: LDDA_R	ldda	[%r23, %r0] 0x25, %r12
	.word 0xdeacc400  ! 3034: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0x87802025  ! 3035: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r27
	mov	0x0, %r26
	.word 0xd8d72000  ! 3038: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xd89fe000  ! 3039: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0xd4b609e0  ! 3040: STHA_R	stha	%r10, [%r24 + %r0] 0x4f
	.word 0xd287e000  ! 3041: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0xd8c4c400  ! 3042: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r12
	.word 0xd8c5c4a0  ! 3043: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r12
	.word 0x87802073  ! 3044: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3045: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3046: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a74e60  ! 3047: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	.word 0x87802025  ! 3048: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd89fce40  ! 3049: LDDA_R	ldda	[%r31, %r0] 0x72, %r12
	.word 0xd6b4c400  ! 3050: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xd29c4400  ! 3051: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	.word 0xd2afe000  ! 3052: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	mov	0x70, %r27
	.word 0x87802072  ! 3054: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd297a000  ! 3055: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	mov	0x7f0, %r22
	.word 0xde9e49e0  ! 3057: LDDA_R	ldda	[%r25, %r0] 0x4f, %r15
	.word 0xd0cf8e80  ! 3058: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r8
	.word 0xd6bfe000  ! 3059: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0x87802073  ! 3061: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6cf8e40  ! 3062: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r11
	.word 0xd6c4c400  ! 3063: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r11
	.word 0xd2bf4e60  ! 3064: STDA_R	stda	%r9, [%r29 + %r0] 0x73
	.word 0xd2b5c4a0  ! 3065: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	.word 0x87802072  ! 3066: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c0, %r23
	.word 0xd0c66000  ! 3068: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r8
	mov	0x7d0, %r20
	mov	0x20, %r17
	mov	0x20, %r25
	.word 0xdab70e60  ! 3072: STHA_R	stha	%r13, [%r28 + %r0] 0x73
	mov	0x0, %r25
	mov	0x3d0, %r21
	.word 0xd4be6000  ! 3075: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0xd4bea000  ! 3076: STDA_I	stda	%r10, [%r26 + 0x0000] %asi
	mov	0x68, %r26
	.word 0xd6870e80  ! 3078: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r11
	mov	0x48, %r25
	.word 0xd6cfce40  ! 3080: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r11
	.word 0xd4bc0400  ! 3081: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0x87802020  ! 3082: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f72000  ! 3083: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4b76000  ! 3084: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd4cfa000  ! 3085: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0xdeb5c4a0  ! 3086: STHA_R	stha	%r15, [%r23 + %r0] 0x25
	.word 0xd8f76000  ! 3087: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xdca74e80  ! 3088: STWA_R	stwa	%r14, [%r29 + %r0] 0x74
	.word 0xdccc4400  ! 3089: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r14
	.word 0xd6cf6000  ! 3090: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6cfe000  ! 3091: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0xd6bf6000  ! 3092: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xdead04a0  ! 3093: STBA_R	stba	%r15, [%r20 + %r0] 0x25
	mov	0x7d8, %r23
	.word 0xdcf76000  ! 3095: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdc972000  ! 3096: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	.word 0xdcd7e000  ! 3097: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0x87802072  ! 3098: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbea000  ! 3099: STDA_I	stda	%r14, [%r26 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0xdc862000  ! 3101: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 3102: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4874e80  ! 3103: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r10
	.word 0xd09fce80  ! 3104: LDDA_R	ldda	[%r31, %r0] 0x74, %r8
	.word 0xd2d46000  ! 3105: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	.word 0xd8bd44a0  ! 3106: STDA_R	stda	%r12, [%r21 + %r0] 0x25
	.word 0xd2878e40  ! 3107: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r9
	mov	0x40, %r24
	.word 0xd4ace000  ! 3109: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 3110: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8e49e0  ! 3111: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r13
	.word 0xd6bf6000  ! 3112: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd6a7e000  ! 3113: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	mov	0x50, %r19
	.word 0xdadc0400  ! 3115: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	.word 0xdca649e0  ! 3116: STWA_R	stwa	%r14, [%r25 + %r0] 0x4f
	mov	0x18, %r26
	.word 0xdccd44a0  ! 3118: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r14
	.word 0x87802073  ! 3119: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc8f4e60  ! 3120: LDUBA_R	lduba	[%r29, %r0] 0x73, %r14
	mov	0x0, %r25
	.word 0xdca46000  ! 3122: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xdcace000  ! 3123: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 3124: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e8, %r21
	.word 0xdcaca000  ! 3126: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	mov	0x10, %r18
	mov	0x60, %r16
	.word 0xdcb7ce80  ! 3129: STHA_R	stha	%r14, [%r31 + %r0] 0x74
	mov	0x3c0, %r21
	.word 0x87802073  ! 3131: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 3132: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 3133: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc872000  ! 3134: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0x87802020  ! 3135: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r26
	mov	0x3e0, %r21
	.word 0xd8b4c400  ! 3138: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0x87802020  ! 3139: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09c6000  ! 3140: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r8
	.word 0xd0a4a000  ! 3141: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0xd29c4400  ! 3142: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	mov	0x60, %r18
	mov	0x70, %r27
	.word 0xd6b7ce80  ! 3145: STHA_R	stha	%r11, [%r31 + %r0] 0x74
	mov	0x48, %r18
	.word 0x87802072  ! 3147: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r24
	mov	0x58, %r24
	.word 0xdade09e0  ! 3150: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r13
	.word 0xd4af2000  ! 3151: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xdeb504a0  ! 3152: STHA_R	stha	%r15, [%r20 + %r0] 0x25
	.word 0x8780204f  ! 3153: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f8, %r20
	.word 0xd68fa000  ! 3155: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0x87802025  ! 3156: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r19
	mov	0x8, %r24
	mov	0x58, %r16
	.word 0xdaac4400  ! 3160: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	.word 0x87802020  ! 3161: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09ca000  ! 3162: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	.word 0xd2c78e60  ! 3163: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r9
	.word 0x87802073  ! 3164: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0874e40  ! 3165: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r8
	.word 0xd0b44400  ! 3166: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xdcdf6000  ! 3167: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	mov	0x70, %r16
	.word 0xd8af0e80  ! 3169: STBA_R	stba	%r12, [%r28 + %r0] 0x74
	.word 0xdccc8400  ! 3170: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	mov	0x10, %r19
	mov	0x8, %r18
	.word 0xd887ce40  ! 3173: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r12
	.word 0x87802025  ! 3174: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r24
	mov	0x20, %r26
	.word 0xdab70e40  ! 3177: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	.word 0xdcd70e80  ! 3178: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r14
	mov	0x8, %r25
	.word 0xd6afce40  ! 3180: STBA_R	stba	%r11, [%r31 + %r0] 0x72
	.word 0xd086e000  ! 3181: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r8
	.word 0xd08e2000  ! 3182: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r8
	.word 0xd2de89e0  ! 3183: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r9
	.word 0xda9fce60  ! 3184: LDDA_R	ldda	[%r31, %r0] 0x73, %r13
	mov	0x28, %r18
	.word 0xdabc4400  ! 3186: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	mov	0x3f8, %r21
	mov	0x68, %r19
	.word 0xdabea000  ! 3189: STDA_I	stda	%r13, [%r26 + 0x0000] %asi
	.word 0xd29c4400  ! 3190: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	.word 0xd4ac8400  ! 3191: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0xd0df0e80  ! 3192: LDXA_R	ldxa	[%r28, %r0] 0x74, %r8
	.word 0x87802025  ! 3193: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c8, %r23
	mov	0x18, %r25
	.word 0xdeb4e000  ! 3196: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 3197: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r18
	.word 0xde8c0400  ! 3199: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0xd0d48400  ! 3200: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	.word 0xd29f8e80  ! 3201: LDDA_R	ldda	[%r30, %r0] 0x74, %r9
	mov	0x20, %r16
	mov	0x18, %r26
	.word 0x87802020  ! 3204: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b7e000  ! 3205: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0xd09fa000  ! 3206: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	.word 0xd49649e0  ! 3207: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r10
	.word 0xd2c584a0  ! 3208: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r9
	.word 0xd6d74e80  ! 3209: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r11
	.word 0xd2bec9e0  ! 3210: STDA_R	stda	%r9, [%r27 + %r0] 0x4f
	.word 0x87802072  ! 3211: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 3212: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdab649e0  ! 3213: STHA_R	stha	%r13, [%r25 + %r0] 0x4f
	.word 0x87802072  ! 3214: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabd44a0  ! 3215: STDA_R	stda	%r13, [%r21 + %r0] 0x25
	.word 0xd0bc0400  ! 3216: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0x87802073  ! 3217: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc94a000  ! 3218: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	mov	0x7c8, %r20
	mov	0x0, %r18
	mov	0x3d0, %r22
	mov	0x3d8, %r22
	.word 0x8780204f  ! 3223: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 3224: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 3225: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcce6000  ! 3226: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r14
	.word 0xd2a40400  ! 3227: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xd4b66000  ! 3228: STHA_I	stha	%r10, [%r25 + 0x0000] %asi
	.word 0x87802025  ! 3229: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 3230: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r16
	.word 0xd8c544a0  ! 3232: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r12
	.word 0xd4dfe000  ! 3233: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4bfa000  ! 3234: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd8874e40  ! 3235: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r12
	mov	0x40, %r25
	.word 0x87802020  ! 3237: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3238: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r16
	.word 0xd6b4a000  ! 3240: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd8d48400  ! 3241: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0xdaa544a0  ! 3242: STWA_R	stwa	%r13, [%r21 + %r0] 0x25
	.word 0xd8f649e0  ! 3243: STXA_R	stxa	%r12, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 3244: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a609e0  ! 3245: STWA_R	stwa	%r8, [%r24 + %r0] 0x4f
	.word 0xd2f46000  ! 3246: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2aca000  ! 3247: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	mov	0x0, %r18
	mov	0x60, %r18
	.word 0x87802020  ! 3250: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3251: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0d40400  ! 3252: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	mov	0x7e0, %r22
	mov	0x78, %r25
	.word 0xd29f6000  ! 3255: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xd2976000  ! 3256: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0xd2b76000  ! 3257: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 3258: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28ca000  ! 3259: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3260: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c7e000  ! 3261: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0xd2b7e000  ! 3262: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd4b70e40  ! 3263: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	.word 0xdcbf0e60  ! 3264: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	.word 0xd8df4e80  ! 3265: LDXA_R	ldxa	[%r29, %r0] 0x74, %r12
	.word 0xd6af6000  ! 3266: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd6c76000  ! 3267: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xdac689e0  ! 3268: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r13
	.word 0xdad72000  ! 3269: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0xda97a000  ! 3270: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xd48e09e0  ! 3271: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r10
	mov	0x20, %r19
	.word 0xdea7a000  ! 3273: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xde9fce60  ! 3274: LDDA_R	ldda	[%r31, %r0] 0x73, %r15
	.word 0xd0d70e40  ! 3275: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r8
	.word 0xdca48400  ! 3276: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xdeb7e000  ! 3277: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	mov	0x60, %r17
	.word 0xded7e000  ! 3279: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0xd4b609e0  ! 3280: STHA_R	stha	%r10, [%r24 + %r0] 0x4f
	.word 0xdcd7a000  ! 3281: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0xd4bec9e0  ! 3282: STDA_R	stda	%r10, [%r27 + %r0] 0x4f
	.word 0xd8bdc4a0  ! 3283: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	.word 0xdebfa000  ! 3284: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xde8f2000  ! 3285: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3286: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r20
	.word 0x87802020  ! 3288: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef7a000  ! 3289: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3290: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdecd2000  ! 3291: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r15
	mov	0x7e8, %r23
	.word 0xde8d6000  ! 3293: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r15
	mov	0x78, %r19
	.word 0x87802020  ! 3295: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf40400  ! 3296: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xd2cc8400  ! 3297: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0xdeaf2000  ! 3298: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xd09c4400  ! 3299: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	mov	0x0, %r27
	mov	0x7f0, %r22
	.word 0xdc8e09e0  ! 3302: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r14
	.word 0xd0dc8400  ! 3303: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0x87802074  ! 3304: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28ea000  ! 3305: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r9
	.word 0xd286a000  ! 3306: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r9
	.word 0xd8d70e60  ! 3307: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r12
	.word 0xdad66000  ! 3308: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r13
	.word 0xdac6a000  ! 3309: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r13
	mov	0x60, %r17
	.word 0xdebf8e40  ! 3311: STDA_R	stda	%r15, [%r30 + %r0] 0x72
	.word 0xdad48400  ! 3312: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0xd8b70e40  ! 3313: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0xdc86e000  ! 3314: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r14
	.word 0x87802074  ! 3315: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde84c400  ! 3316: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0xd2f4e000  ! 3317: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2aca000  ! 3318: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0xd0f504a0  ! 3319: STXA_R	stxa	%r8, [%r20 + %r0] 0x25
	.word 0xdebc2000  ! 3320: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xdec46000  ! 3321: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	.word 0xdaf70e80  ! 3322: STXA_R	stxa	%r13, [%r28 + %r0] 0x74
	.word 0xdc9d04a0  ! 3323: LDDA_R	ldda	[%r20, %r0] 0x25, %r14
	mov	0x40, %r26
	.word 0xd2f46000  ! 3325: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2c42000  ! 3326: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	.word 0xde84c400  ! 3327: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0x87802072  ! 3328: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r25
	mov	0x3e0, %r20
	mov	0x3f8, %r23
	.word 0xd6bc0400  ! 3332: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	mov	0x58, %r27
	.word 0xdeaca000  ! 3334: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xdea4e000  ! 3335: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xdebca000  ! 3336: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	mov	0x7c8, %r23
	mov	0x48, %r25
	mov	0x3d8, %r22
	.word 0xd0970e80  ! 3340: LDUHA_R	lduha	[%r28, %r0] 0x74, %r8
	.word 0xd2a7ce60  ! 3341: STWA_R	stwa	%r9, [%r31 + %r0] 0x73
	.word 0x87802025  ! 3342: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcac2000  ! 3343: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0xd8a70e40  ! 3344: STWA_R	stwa	%r12, [%r28 + %r0] 0x72
	.word 0xdcbc2000  ! 3345: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xdcb46000  ! 3346: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3347: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r27
	mov	0x3d0, %r21
	.word 0xd0a48400  ! 3350: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0xdedf8e60  ! 3351: LDXA_R	ldxa	[%r30, %r0] 0x73, %r15
	.word 0xdeaf8e40  ! 3352: STBA_R	stba	%r15, [%r30 + %r0] 0x72
	.word 0xdcc5a000  ! 3353: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r14
	.word 0xdcdde000  ! 3354: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r14
	mov	0x30, %r27
	.word 0xdcbda000  ! 3356: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	mov	0x3c0, %r20
	mov	0x10, %r24
	.word 0xda9d44a0  ! 3359: LDDA_R	ldda	[%r21, %r0] 0x25, %r13
	.word 0xd0df0e60  ! 3360: LDXA_R	ldxa	[%r28, %r0] 0x73, %r8
	.word 0xd4dd6000  ! 3361: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r10
	.word 0xd4f56000  ! 3362: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	.word 0xd4ad2000  ! 3363: STBA_I	stba	%r10, [%r20 + 0x0000] %asi
	mov	0x38, %r26
	.word 0xdaafce40  ! 3365: STBA_R	stba	%r13, [%r31 + %r0] 0x72
	mov	0x50, %r18
	mov	0x60, %r16
	.word 0xd6bd6000  ! 3368: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0xd8cc0400  ! 3369: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	.word 0x87802020  ! 3370: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49ee000  ! 3371: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r10
	mov	0x60, %r27
	.word 0xd4f62000  ! 3373: STXA_I	stxa	%r10, [%r24 + 0x0000] %asi
	.word 0xd4a62000  ! 3374: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	mov	0x58, %r27
	.word 0xd8af8e60  ! 3376: STBA_R	stba	%r12, [%r30 + %r0] 0x73
	.word 0x87802074  ! 3377: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r25
	.word 0xdad504a0  ! 3379: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r13
	.word 0xda9c6000  ! 3380: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xd4a78e80  ! 3381: STWA_R	stwa	%r10, [%r30 + %r0] 0x74
	.word 0x87802074  ! 3382: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd89c8400  ! 3383: LDDA_R	ldda	[%r18, %r0] 0x20, %r12
	.word 0xd0bc6000  ! 3384: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	mov	0x40, %r19
	.word 0xdcc74e60  ! 3386: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r14
	.word 0xded4a000  ! 3387: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	mov	0x70, %r24
	.word 0xdebc6000  ! 3389: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	mov	0x7d0, %r23
	mov	0x18, %r24
	.word 0xdedc2000  ! 3392: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r15
	mov	0x3d0, %r20
	mov	0x18, %r18
	mov	0x58, %r27
	.word 0xda84c400  ! 3396: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r13
	.word 0xdabdc4a0  ! 3397: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	.word 0xdca78e80  ! 3398: STWA_R	stwa	%r14, [%r30 + %r0] 0x74
	.word 0xd2dd44a0  ! 3399: LDXA_R	ldxa	[%r21, %r0] 0x25, %r9
	mov	0x3f0, %r21
	mov	0x38, %r19
	mov	0x18, %r17
	.word 0xdeb74e60  ! 3403: STHA_R	stha	%r15, [%r29 + %r0] 0x73
	.word 0x87802020  ! 3404: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf5a000  ! 3405: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 3406: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdadde000  ! 3407: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r13
	mov	0x30, %r19
	.word 0xdabde000  ! 3409: STDA_I	stda	%r13, [%r23 + 0x0000] %asi
	mov	0x20, %r27
	mov	0x7c0, %r21
	.word 0xdadda000  ! 3412: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r13
	.word 0xdcb48400  ! 3413: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	mov	0x70, %r16
	.word 0xd0dde000  ! 3415: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r8
	.word 0xdaaf8e60  ! 3416: STBA_R	stba	%r13, [%r30 + %r0] 0x73
	.word 0xd2bfce80  ! 3417: STDA_R	stda	%r9, [%r31 + %r0] 0x74
	.word 0xd0b40400  ! 3418: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0xd2b6c9e0  ! 3419: STHA_R	stha	%r9, [%r27 + %r0] 0x4f
	.word 0xd4b56000  ! 3420: STHA_I	stha	%r10, [%r21 + 0x0000] %asi
	.word 0xd4a5e000  ! 3421: STWA_I	stwa	%r10, [%r23 + 0x0000] %asi
	.word 0xd8afce40  ! 3422: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	.word 0xd8dec9e0  ! 3423: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r12
	.word 0xd8b5a000  ! 3424: STHA_I	stha	%r12, [%r22 + 0x0000] %asi
	.word 0xd6d70e40  ! 3425: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r11
	.word 0xdec544a0  ! 3426: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r15
	mov	0x3e8, %r22
	mov	0x28, %r18
	.word 0xdadc0400  ! 3429: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	mov	0x58, %r25
	.word 0x87802072  ! 3431: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdac5c4a0  ! 3432: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r13
	.word 0x87802025  ! 3433: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3434: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f72000  ! 3435: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd2bfa000  ! 3436: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0xd0bfce80  ! 3438: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	mov	0x58, %r17
	.word 0xd2b649e0  ! 3440: STHA_R	stha	%r9, [%r25 + %r0] 0x4f
	.word 0xd8bf4e80  ! 3441: STDA_R	stda	%r12, [%r29 + %r0] 0x74
	.word 0xdebfe000  ! 3442: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xd8a70e40  ! 3443: STWA_R	stwa	%r12, [%r28 + %r0] 0x72
	.word 0x87802073  ! 3444: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3445: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r24
	.word 0xdca56000  ! 3447: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	.word 0xde974e40  ! 3448: LDUHA_R	lduha	[%r29, %r0] 0x72, %r15
	.word 0xd4a70e80  ! 3449: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	.word 0xd4d504a0  ! 3450: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r10
	.word 0xdcad2000  ! 3451: STBA_I	stba	%r14, [%r20 + 0x0000] %asi
	.word 0x87802025  ! 3452: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf76000  ! 3453: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 3454: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r18
	mov	0x8, %r16
	.word 0xdcafa000  ! 3457: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xdc9f6000  ! 3458: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r14
	.word 0x87802073  ! 3459: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 3460: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb46000  ! 3461: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xdcd4a000  ! 3463: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	mov	0x3d0, %r20
	.word 0x8780204f  ! 3465: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdec40400  ! 3466: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xd8d649e0  ! 3467: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r12
	.word 0xd28fa000  ! 3468: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	.word 0xd4df8e40  ! 3469: LDXA_R	ldxa	[%r30, %r0] 0x72, %r10
	.word 0xd2a544a0  ! 3470: STWA_R	stwa	%r9, [%r21 + %r0] 0x25
	.word 0xd6be49e0  ! 3471: STDA_R	stda	%r11, [%r25 + %r0] 0x4f
	.word 0xda9f2000  ! 3472: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xdaaf2000  ! 3473: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 3474: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8fe000  ! 3475: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	mov	0x0, %r17
	mov	0x30, %r19
	mov	0x20, %r16
	.word 0xdaafe000  ! 3479: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xda870e60  ! 3480: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r13
	.word 0xd2f7ce40  ! 3481: STXA_R	stxa	%r9, [%r31 + %r0] 0x72
	.word 0xdcbfce80  ! 3482: STDA_R	stda	%r14, [%r31 + %r0] 0x74
	mov	0x30, %r25
	.word 0xd88fe000  ! 3484: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8c72000  ! 3485: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd0de09e0  ! 3486: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r8
	mov	0x60, %r24
	.word 0xd0df2000  ! 3488: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0xd2974e80  ! 3489: LDUHA_R	lduha	[%r29, %r0] 0x74, %r9
	.word 0x8780204f  ! 3490: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0ac8400  ! 3491: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xd8cc8400  ! 3492: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0xdebf0e60  ! 3493: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	.word 0xdcf42000  ! 3494: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0xdcd46000  ! 3495: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	.word 0xdcaf4e60  ! 3496: STBA_R	stba	%r14, [%r29 + %r0] 0x73
	.word 0xd2b6c9e0  ! 3497: STHA_R	stha	%r9, [%r27 + %r0] 0x4f
	.word 0x8780204f  ! 3498: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bca000  ! 3499: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0xd494e000  ! 3500: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	.word 0xd4c4a000  ! 3501: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	mov	0x3e0, %r23
	.word 0x87802020  ! 3503: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcae89e0  ! 3504: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	.word 0xd0c689e0  ! 3505: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r8
	.word 0x87802074  ! 3506: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd09d44a0  ! 3507: LDDA_R	ldda	[%r21, %r0] 0x25, %r8
	mov	0x7e8, %r21
	.word 0xd69d84a0  ! 3509: LDDA_R	ldda	[%r22, %r0] 0x25, %r11
	.word 0x87802020  ! 3510: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdec42000  ! 3511: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0xd4bfce40  ! 3512: STDA_R	stda	%r10, [%r31 + %r0] 0x72
	mov	0x60, %r27
	mov	0x8, %r17
	.word 0xdaa70e40  ! 3515: STWA_R	stwa	%r13, [%r28 + %r0] 0x72
	.word 0xd48c2000  ! 3516: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r10
	.word 0xd4a42000  ! 3517: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0xd2d584a0  ! 3518: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r9
	.word 0xdacc8400  ! 3519: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r13
	.word 0xd4dd44a0  ! 3520: LDXA_R	ldxa	[%r21, %r0] 0x25, %r10
	.word 0xdeac8400  ! 3521: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0x87802073  ! 3522: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f48400  ! 3523: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0x87802025  ! 3524: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r16
	.word 0xd6bc0400  ! 3526: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xd68ca000  ! 3527: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r11
	.word 0xda9c8400  ! 3528: LDDA_R	ldda	[%r18, %r0] 0x20, %r13
	.word 0xd0ac6000  ! 3529: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0xd0f4a000  ! 3530: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xd08e09e0  ! 3531: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r8
	.word 0xdec42000  ! 3532: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0xdcac0400  ! 3533: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xd88c2000  ! 3534: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	.word 0xdcd48400  ! 3535: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	mov	0x30, %r26
	mov	0x8, %r18
	.word 0xde9f0e60  ! 3538: LDDA_R	ldda	[%r28, %r0] 0x73, %r15
	mov	0x78, %r26
	.word 0xd08e89e0  ! 3540: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r8
	.word 0xdaf4e000  ! 3541: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	mov	0x28, %r17
	.word 0xdab4e000  ! 3543: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xd0acc400  ! 3544: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xda8c2000  ! 3545: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r13
	.word 0xda946000  ! 3546: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	.word 0xdaf4e000  ! 3547: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xdab74e40  ! 3549: STHA_R	stha	%r13, [%r29 + %r0] 0x72
	.word 0xd0a48400  ! 3550: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0xd2b42000  ! 3551: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0xd0a78e60  ! 3552: STWA_R	stwa	%r8, [%r30 + %r0] 0x73
	.word 0xd0bca000  ! 3553: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0xd0dec9e0  ! 3554: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r8
	mov	0x50, %r27
	mov	0x58, %r16
	.word 0xd28c2000  ! 3557: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xd2cce000  ! 3558: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	mov	0x7d8, %r20
	.word 0xd2dc2000  ! 3560: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r9
	.word 0xd2ac6000  ! 3561: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd49f8e80  ! 3562: LDDA_R	ldda	[%r30, %r0] 0x74, %r10
	.word 0xd88f4e60  ! 3563: LDUBA_R	lduba	[%r29, %r0] 0x73, %r12
	.word 0xda942000  ! 3564: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3565: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2870e40  ! 3566: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r9
	.word 0xdadc2000  ! 3567: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r13
	.word 0xd497ce40  ! 3568: LDUHA_R	lduha	[%r31, %r0] 0x72, %r10
	.word 0xd08649e0  ! 3569: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r8
	mov	0x78, %r27
	.word 0x87802020  ! 3571: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadc6000  ! 3572: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3573: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r23
	.word 0xda8de000  ! 3575: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r13
	.word 0xda956000  ! 3576: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r13
	.word 0xd4bfce60  ! 3577: STDA_R	stda	%r10, [%r31 + %r0] 0x73
	.word 0xd4d609e0  ! 3578: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r10
	.word 0xd495a000  ! 3579: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r10
	.word 0xdeaf4e40  ! 3580: STBA_R	stba	%r15, [%r29 + %r0] 0x72
	.word 0xd2944400  ! 3581: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	mov	0x28, %r24
	.word 0x87802020  ! 3583: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcc44400  ! 3584: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xdef44400  ! 3585: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xd8aca000  ! 3586: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0xdec70e60  ! 3587: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r15
	.word 0x87802072  ! 3588: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r25
	.word 0xd0d7e000  ! 3590: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0a72000  ! 3591: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xd484c400  ! 3592: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	mov	0x50, %r16
	.word 0xd287a000  ! 3594: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	mov	0x10, %r26
	.word 0xdef609e0  ! 3596: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	mov	0x68, %r27
	.word 0xdcbc0400  ! 3598: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 3599: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd686c9e0  ! 3600: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r11
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6dec9e0  ! 3602: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r11
	.word 0xd49c2000  ! 3603: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	.word 0xdcae09e0  ! 3604: STBA_R	stba	%r14, [%r24 + %r0] 0x4f
	.word 0xdaac2000  ! 3605: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0xd68649e0  ! 3606: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r11
	.word 0x87802020  ! 3607: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bd84a0  ! 3608: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	.word 0x87802072  ! 3609: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3610: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48c4400  ! 3611: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0xdcb44400  ! 3612: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	mov	0x3f8, %r21
	.word 0xdec7e000  ! 3614: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xdecfe000  ! 3615: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xdef44400  ! 3616: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0x87802072  ! 3617: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd497ce80  ! 3618: LDUHA_R	lduha	[%r31, %r0] 0x74, %r10
	.word 0xdcf40400  ! 3619: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xd2f7ce40  ! 3620: STXA_R	stxa	%r9, [%r31 + %r0] 0x72
	mov	0x3d8, %r20
	.word 0xd894e000  ! 3622: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r12
	mov	0x20, %r24
	.word 0xdec7ce80  ! 3624: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r15
	.word 0xd8c74e80  ! 3625: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r12
	mov	0x7c0, %r21
	.word 0xdaaf8e60  ! 3627: STBA_R	stba	%r13, [%r30 + %r0] 0x73
	.word 0xd0acc400  ! 3628: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd09c8400  ! 3629: LDDA_R	ldda	[%r18, %r0] 0x20, %r8
	.word 0xd8f504a0  ! 3630: STXA_R	stxa	%r12, [%r20 + %r0] 0x25
	.word 0xd0a4e000  ! 3631: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	mov	0x7c8, %r22
	.word 0xd0a4a000  ! 3633: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0xdebf0e80  ! 3634: STDA_R	stda	%r15, [%r28 + %r0] 0x74
	.word 0x8780204f  ! 3635: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3636: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4972000  ! 3637: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0xd4a7e000  ! 3638: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xdcaf0e40  ! 3639: STBA_R	stba	%r14, [%r28 + %r0] 0x72
	.word 0xd2a76000  ! 3640: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xdeae49e0  ! 3641: STBA_R	stba	%r15, [%r25 + %r0] 0x4f
	mov	0x3c8, %r21
	.word 0xdef70e60  ! 3643: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	.word 0xda8f6000  ! 3644: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0x87802025  ! 3645: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r16
	.word 0xdab62000  ! 3647: STHA_I	stha	%r13, [%r24 + 0x0000] %asi
	.word 0x87802074  ! 3648: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdad44400  ! 3649: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0xd6acc400  ! 3650: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xd4f7a000  ! 3651: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 3652: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde8e49e0  ! 3653: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r15
	mov	0x48, %r24
	.word 0x87802072  ! 3655: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r19
	.word 0x87802073  ! 3657: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f46000  ! 3658: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8dca000  ! 3659: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	.word 0xd8b46000  ! 3660: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0xd8870e60  ! 3661: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r12
	.word 0xdacfce60  ! 3662: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r13
	.word 0xd8ac6000  ! 3663: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3664: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bf4e80  ! 3665: STDA_R	stda	%r12, [%r29 + %r0] 0x74
	.word 0xd8a4a000  ! 3666: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0xd8f46000  ! 3668: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3669: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdec40400  ! 3670: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xd2a7a000  ! 3671: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xd694c400  ! 3672: LDUHA_R	lduha	[%r19, %r0] 0x20, %r11
	.word 0xd0b7e000  ! 3673: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0xd0df6000  ! 3674: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0x87802074  ! 3675: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r26
	.word 0xd4b4c400  ! 3677: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0x87802074  ! 3678: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdadee000  ! 3679: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r13
	.word 0xd6f7ce40  ! 3680: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	mov	0x7f8, %r22
	.word 0xdeaf4e60  ! 3682: STBA_R	stba	%r15, [%r29 + %r0] 0x73
	.word 0xdedea000  ! 3683: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r15
	.word 0xd09f0e40  ! 3684: LDDA_R	ldda	[%r28, %r0] 0x72, %r8
	.word 0xd0f66000  ! 3685: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 3686: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b48400  ! 3687: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xd2d76000  ! 3688: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	mov	0x7f0, %r22
	mov	0x7d8, %r21
	.word 0xd2af6000  ! 3691: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd28fe000  ! 3692: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	.word 0x87802074  ! 3693: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bfa000  ! 3694: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0xd8978e40  ! 3696: LDUHA_R	lduha	[%r30, %r0] 0x72, %r12
	mov	0x30, %r24
	.word 0xd8c7a000  ! 3698: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xd09e49e0  ! 3699: LDDA_R	ldda	[%r25, %r0] 0x4f, %r8
	.word 0xd0b72000  ! 3700: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd0c7a000  ! 3701: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xd29dc4a0  ! 3702: LDDA_R	ldda	[%r23, %r0] 0x25, %r9
	.word 0xde9c8400  ! 3703: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	mov	0x70, %r25
	.word 0xd8cd44a0  ! 3705: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r12
	mov	0x60, %r26
	.word 0xd2bf0e80  ! 3707: STDA_R	stda	%r9, [%r28 + %r0] 0x74
	.word 0xdcd7a000  ! 3708: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0x87802074  ! 3709: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde9584a0  ! 3710: LDUHA_R	lduha	[%r22, %r0] 0x25, %r15
	.word 0xdeb70e40  ! 3711: STHA_R	stha	%r15, [%r28 + %r0] 0x72
	.word 0xd4b5e000  ! 3712: STHA_I	stha	%r10, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 3713: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b78e40  ! 3714: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	mov	0x3d0, %r23
	.word 0x87802073  ! 3716: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdedf0e40  ! 3717: LDXA_R	ldxa	[%r28, %r0] 0x72, %r15
	.word 0xda9d6000  ! 3718: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3719: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9fe000  ! 3720: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xdaa5c4a0  ! 3721: STWA_R	stwa	%r13, [%r23 + %r0] 0x25
	.word 0xda970e40  ! 3722: LDUHA_R	lduha	[%r28, %r0] 0x72, %r13
	.word 0xd8d7ce80  ! 3723: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r12
	.word 0xd4a72000  ! 3724: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 3725: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd48f6000  ! 3726: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xd0ae49e0  ! 3727: STBA_R	stba	%r8, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 3728: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2af0e80  ! 3729: STBA_R	stba	%r9, [%r28 + %r0] 0x74
	.word 0xdedfe000  ! 3730: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	mov	0x48, %r24
	.word 0x87802020  ! 3732: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3733: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3734: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd894c400  ! 3735: LDUHA_R	lduha	[%r19, %r0] 0x20, %r12
	mov	0x0, %r18
	.word 0x87802020  ! 3737: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r17
	.word 0xd2b72000  ! 3739: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd29fe000  ! 3740: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd8b7ce40  ! 3741: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0xd8a72000  ! 3742: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	mov	0x60, %r27
	.word 0xd6b584a0  ! 3744: STHA_R	stha	%r11, [%r22 + %r0] 0x25
	.word 0xdeb5c4a0  ! 3745: STHA_R	stha	%r15, [%r23 + %r0] 0x25
	.word 0xd4f72000  ! 3746: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd2ad44a0  ! 3747: STBA_R	stba	%r9, [%r21 + %r0] 0x25
	.word 0x87802020  ! 3748: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29f0e80  ! 3749: LDDA_R	ldda	[%r28, %r0] 0x74, %r9
	.word 0xd4d7a000  ! 3750: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	mov	0x7d8, %r23
	.word 0xd8a74e60  ! 3752: STWA_R	stwa	%r12, [%r29 + %r0] 0x73
	.word 0xd8cc8400  ! 3753: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0xd0afa000  ! 3754: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd4f70e40  ! 3755: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	.word 0xd6d74e40  ! 3756: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r11
	.word 0xd09f0e40  ! 3757: LDDA_R	ldda	[%r28, %r0] 0x72, %r8
	.word 0xd6afe000  ! 3758: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0xdaddc4a0  ! 3760: LDXA_R	ldxa	[%r23, %r0] 0x25, %r13
	.word 0x87802072  ! 3761: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r16
	.word 0xd0a44400  ! 3763: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xd48fce40  ! 3764: LDUBA_R	lduba	[%r31, %r0] 0x72, %r10
	.word 0x87802074  ! 3765: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbc2000  ! 3766: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	mov	0x78, %r27
	.word 0xdc9ca000  ! 3768: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r14
	.word 0x87802072  ! 3769: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4b40400  ! 3770: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	mov	0x78, %r26
	.word 0xdad7e000  ! 3772: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0x87802074  ! 3773: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf7a000  ! 3774: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	mov	0x78, %r27
	mov	0x10, %r26
	.word 0xdccd04a0  ! 3777: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r14
	.word 0xd6a7a000  ! 3778: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xd6b7a000  ! 3780: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xdea584a0  ! 3782: STWA_R	stwa	%r15, [%r22 + %r0] 0x25
	.word 0xde8fa000  ! 3783: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0xdea74e80  ! 3784: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	.word 0xdaa689e0  ! 3785: STWA_R	stwa	%r13, [%r26 + %r0] 0x4f
	.word 0xdebf2000  ! 3786: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	mov	0x40, %r25
	.word 0xdecf6000  ! 3788: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0xd8f7ce40  ! 3789: STXA_R	stxa	%r12, [%r31 + %r0] 0x72
	.word 0xd2bd44a0  ! 3790: STDA_R	stda	%r9, [%r21 + %r0] 0x25
	.word 0xdac7e000  ! 3791: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xdeb689e0  ! 3792: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	mov	0x70, %r27
	.word 0xd2b7a000  ! 3794: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd2af6000  ! 3795: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd28f0e80  ! 3796: LDUBA_R	lduba	[%r28, %r0] 0x74, %r9
	.word 0xd4b48400  ! 3797: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd8d76000  ! 3798: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	mov	0x20, %r24
	.word 0xd8dfa000  ! 3800: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	mov	0x18, %r16
	.word 0xd8972000  ! 3802: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	.word 0xd8bf2000  ! 3803: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xdcf78e60  ! 3804: STXA_R	stxa	%r14, [%r30 + %r0] 0x73
	.word 0x87802020  ! 3805: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab649e0  ! 3806: STHA_R	stha	%r13, [%r25 + %r0] 0x4f
	.word 0xd6d72000  ! 3807: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r11
	.word 0xdcad04a0  ! 3808: STBA_R	stba	%r14, [%r20 + %r0] 0x25
	mov	0x40, %r19
	.word 0xd09e89e0  ! 3810: LDDA_R	ldda	[%r26, %r0] 0x4f, %r8
	mov	0x7e0, %r22
	.word 0xdaa72000  ! 3812: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xd89c0400  ! 3813: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	.word 0xd6c7e000  ! 3814: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xd697a000  ! 3815: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0xd6bf6000  ! 3816: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd6b72000  ! 3817: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd6b72000  ! 3818: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd687e000  ! 3819: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xd687a000  ! 3820: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6bfe000  ! 3821: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd8b4c400  ! 3822: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0xd6bfce80  ! 3823: STDA_R	stda	%r11, [%r31 + %r0] 0x74
	.word 0xd6bfe000  ! 3824: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xd6972000  ! 3826: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	.word 0xd0b5c4a0  ! 3827: STHA_R	stha	%r8, [%r23 + %r0] 0x25
	.word 0xdef7ce80  ! 3828: STXA_R	stxa	%r15, [%r31 + %r0] 0x74
	.word 0xd89f2000  ! 3829: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0xd89fa000  ! 3830: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	mov	0x38, %r27
	mov	0x3f0, %r22
	mov	0x3f8, %r20
	.word 0xdad7ce80  ! 3834: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r13
	mov	0x50, %r18
	.word 0xd8cfa000  ! 3836: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd89fa000  ! 3837: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	.word 0xdc85c4a0  ! 3838: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r14
	.word 0xde9f2000  ! 3839: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xdeb7a000  ! 3840: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xdecf0e80  ! 3841: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r15
	mov	0x38, %r18
	mov	0x48, %r18
	.word 0xd2bf0e40  ! 3844: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	.word 0xde96c9e0  ! 3845: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r15
	.word 0xd0af0e40  ! 3846: STBA_R	stba	%r8, [%r28 + %r0] 0x72
	.word 0xd0c78e60  ! 3847: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r8
	.word 0xd0f44400  ! 3848: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xdaaf2000  ! 3849: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdaf72000  ! 3850: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdab7a000  ! 3851: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xda8fa000  ! 3852: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xd2adc4a0  ! 3853: STBA_R	stba	%r9, [%r23 + %r0] 0x25
	.word 0xd8b7a000  ! 3854: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xd6dc4400  ! 3855: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xd8b7e000  ! 3856: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0xd0bd84a0  ! 3857: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0x87802020  ! 3858: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ac2000  ! 3859: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0xd884a000  ! 3860: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r12
	mov	0x68, %r19
	.word 0x87802020  ! 3862: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69f0e60  ! 3863: LDDA_R	ldda	[%r28, %r0] 0x73, %r11
	.word 0xdaa4a000  ! 3864: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 3865: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda9c6000  ! 3866: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0xd0d544a0  ! 3867: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r8
	.word 0x8780204f  ! 3868: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r21
	.word 0x87802025  ! 3870: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4aca000  ! 3871: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0xd49ca000  ! 3872: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd69504a0  ! 3873: LDUHA_R	lduha	[%r20, %r0] 0x25, %r11
	.word 0x8780204f  ! 3874: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa70e60  ! 3875: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	.word 0xdcbce000  ! 3876: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xdcac2000  ! 3877: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0xdcb4a000  ! 3878: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 3879: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6bf8e40  ! 3880: STDA_R	stda	%r11, [%r30 + %r0] 0x72
	.word 0xd2f70e40  ! 3881: STXA_R	stxa	%r9, [%r28 + %r0] 0x72
	.word 0xdc8f4e40  ! 3882: LDUBA_R	lduba	[%r29, %r0] 0x72, %r14
	.word 0xd8b609e0  ! 3883: STHA_R	stha	%r12, [%r24 + %r0] 0x4f
	.word 0xd69f2000  ! 3884: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	mov	0x10, %r19
	.word 0xda87ce80  ! 3886: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r13
	.word 0xd8b6c9e0  ! 3887: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 3888: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6bfce60  ! 3889: STDA_R	stda	%r11, [%r31 + %r0] 0x73
	.word 0xd8876000  ! 3890: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0xdaf584a0  ! 3891: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	.word 0xde9d44a0  ! 3892: LDDA_R	ldda	[%r21, %r0] 0x25, %r15
	mov	0x7d0, %r21
	mov	0x48, %r18
	.word 0xd09dc4a0  ! 3895: LDDA_R	ldda	[%r23, %r0] 0x25, %r8
	.word 0xd8dfa000  ! 3896: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd2bf8e80  ! 3897: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	.word 0xdeccc400  ! 3898: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r15
	.word 0xdca7a000  ! 3899: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcbfa000  ! 3900: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdcf7e000  ! 3901: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcf7a000  ! 3902: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xdacf4e60  ! 3903: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r13
	.word 0xd29d84a0  ! 3904: LDDA_R	ldda	[%r22, %r0] 0x25, %r9
	.word 0xd4976000  ! 3905: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r10
	.word 0xdc8c4400  ! 3906: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	mov	0x38, %r17
	.word 0x87802072  ! 3908: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r18
	.word 0x87802072  ! 3910: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 3911: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabc8400  ! 3912: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	.word 0x87802020  ! 3913: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8da000  ! 3914: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r13
	.word 0xdaa5e000  ! 3915: STWA_I	stwa	%r13, [%r23 + 0x0000] %asi
	.word 0xdaada000  ! 3916: STBA_I	stba	%r13, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 3917: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde974e40  ! 3918: LDUHA_R	lduha	[%r29, %r0] 0x72, %r15
	.word 0x87802020  ! 3919: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r25
	.word 0xd48e89e0  ! 3921: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r10
	.word 0xdaac8400  ! 3922: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0xd8976000  ! 3923: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0xd4a70e40  ! 3924: STWA_R	stwa	%r10, [%r28 + %r0] 0x72
	mov	0x40, %r16
	.word 0xd4de49e0  ! 3926: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r10
	.word 0xdef6c9e0  ! 3927: STXA_R	stxa	%r15, [%r27 + %r0] 0x4f
	.word 0xdaaf0e80  ! 3928: STBA_R	stba	%r13, [%r28 + %r0] 0x74
	.word 0xd2ae89e0  ! 3929: STBA_R	stba	%r9, [%r26 + %r0] 0x4f
	.word 0xdef7e000  ! 3930: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xde87a000  ! 3931: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xd68d84a0  ! 3932: LDUBA_R	lduba	[%r22, %r0] 0x25, %r11
	mov	0x30, %r18
	.word 0xde8f4e40  ! 3934: LDUBA_R	lduba	[%r29, %r0] 0x72, %r15
	.word 0xdcb76000  ! 3935: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	mov	0x60, %r17
	mov	0x30, %r27
	.word 0xdecf8e60  ! 3938: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r15
	.word 0xd2a504a0  ! 3939: STWA_R	stwa	%r9, [%r20 + %r0] 0x25
	.word 0xd0b584a0  ! 3940: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	mov	0x40, %r24
	.word 0xda8f8e60  ! 3942: LDUBA_R	lduba	[%r30, %r0] 0x73, %r13
	.word 0xde9f2000  ! 3943: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0x87802074  ! 3944: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 3945: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x0, %r17
	mov	0x60, %r24
	.word 0xd88ec9e0  ! 3948: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r12
	.word 0xd6bc2000  ! 3949: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 3950: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b544a0  ! 3951: STHA_R	stha	%r9, [%r21 + %r0] 0x25
	.word 0x87802074  ! 3952: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4940400  ! 3953: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	mov	0x3f8, %r20
	mov	0x58, %r17
	.word 0xd2df2000  ! 3956: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3957: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2876000  ! 3958: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xd297e000  ! 3959: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	mov	0x38, %r16
	.word 0xd6df0e40  ! 3961: LDXA_R	ldxa	[%r28, %r0] 0x72, %r11
	.word 0xdaa76000  ! 3962: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xdacfe000  ! 3963: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0xdedc4400  ! 3964: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	.word 0xdabf8e60  ! 3965: STDA_R	stda	%r13, [%r30 + %r0] 0x73
	.word 0x8780204f  ! 3966: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r17
	.word 0xd087a000  ! 3968: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	mov	0x30, %r26
	.word 0xd0afe000  ! 3970: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xdaf70e40  ! 3971: STXA_R	stxa	%r13, [%r28 + %r0] 0x72
	mov	0x68, %r17
	.word 0xd8f7a000  ! 3973: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8844400  ! 3974: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r12
	.word 0xd68fa000  ! 3975: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0xd6af2000  ! 3976: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd687e000  ! 3977: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6bfa000  ! 3978: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd6a7a000  ! 3979: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd4978e60  ! 3980: LDUHA_R	lduha	[%r30, %r0] 0x73, %r10
	mov	0x3f8, %r23
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802074  ! 3983: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a40400  ! 3984: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	mov	0x7c8, %r20
	.word 0xded76000  ! 3986: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0x87802073  ! 3987: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xded42000  ! 3988: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	.word 0xdeac2000  ! 3989: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	mov	0x18, %r17
	.word 0xdec46000  ! 3991: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3992: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c4c400  ! 3993: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0xdcb4a000  ! 3994: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xd4f40400  ! 3995: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	mov	0x40, %r24
	.word 0xd6f584a0  ! 3997: STXA_R	stxa	%r11, [%r22 + %r0] 0x25
	.word 0xdc870e80  ! 3998: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r14
	.word 0xd284e000  ! 3999: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r9
	mov	0x3f0, %r21
	mov	0x28, %r19
	.word 0xd2ace000  ! 4002: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0xd2dc6000  ! 4003: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r9
	.word 0xd2ace000  ! 4004: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	mov	0x18, %r18
	.word 0xd2b78e60  ! 4006: STHA_R	stha	%r9, [%r30 + %r0] 0x73
	.word 0xdead04a0  ! 4007: STBA_R	stba	%r15, [%r20 + %r0] 0x25
	.word 0xd884a000  ! 4008: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r12
	mov	0x30, %r17
	.word 0xd8a42000  ! 4010: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8ace000  ! 4011: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	mov	0x3e0, %r23
	mov	0x58, %r17
	.word 0xda8e49e0  ! 4014: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r13
	.word 0xd6f42000  ! 4015: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	.word 0xd2c5c4a0  ! 4016: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r9
	mov	0x58, %r16
	mov	0x70, %r26
	.word 0xd0af8e40  ! 4019: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0xdaaca000  ! 4020: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	mov	0x48, %r24
	mov	0x50, %r26
	.word 0xdc8f0e40  ! 4023: LDUBA_R	lduba	[%r28, %r0] 0x72, %r14
	mov	0x48, %r16
	.word 0xdaa7ce60  ! 4025: STWA_R	stwa	%r13, [%r31 + %r0] 0x73
	.word 0x87802020  ! 4026: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda97ce40  ! 4027: LDUHA_R	lduha	[%r31, %r0] 0x72, %r13
	.word 0xd49f8e40  ! 4028: LDDA_R	ldda	[%r30, %r0] 0x72, %r10
	.word 0xd4df8e60  ! 4029: LDXA_R	ldxa	[%r30, %r0] 0x73, %r10
	.word 0xd8862000  ! 4030: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r12
	.word 0xd8dd84a0  ! 4031: LDXA_R	ldxa	[%r22, %r0] 0x25, %r12
	.word 0xda8c4400  ! 4032: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0xd69ea000  ! 4033: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r11
	.word 0xd6f66000  ! 4034: STXA_I	stxa	%r11, [%r25 + 0x0000] %asi
	.word 0xd6be2000  ! 4035: STDA_I	stda	%r11, [%r24 + 0x0000] %asi
	.word 0xdcc70e40  ! 4036: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r14
	.word 0xd0b66000  ! 4037: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	mov	0x3c8, %r20
	.word 0xd0c6a000  ! 4039: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r8
	.word 0xd0c62000  ! 4040: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r8
	.word 0x87802074  ! 4041: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0afe000  ! 4042: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	mov	0x8, %r18
	.word 0xd0cfe000  ! 4044: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xdedc8400  ! 4045: LDXA_R	ldxa	[%r18, %r0] 0x20, %r15
	.word 0xd6be49e0  ! 4046: STDA_R	stda	%r11, [%r25 + %r0] 0x4f
	mov	0x30, %r19
	.word 0xd2af2000  ! 4048: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 4049: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c8, %r23
	.word 0xd2f62000  ! 4051: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	mov	0x7e0, %r21
	.word 0xdabf4e60  ! 4053: STDA_R	stda	%r13, [%r29 + %r0] 0x73
	.word 0xd4b66000  ! 4054: STHA_I	stha	%r10, [%r25 + 0x0000] %asi
	mov	0x70, %r18
	.word 0xd4a6a000  ! 4056: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0xd49ee000  ! 4058: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r10
	.word 0xdace09e0  ! 4059: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r13
	.word 0xdef70e40  ! 4060: STXA_R	stxa	%r15, [%r28 + %r0] 0x72
	.word 0xd2cfce40  ! 4061: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r9
	.word 0xd8aee000  ! 4062: STBA_I	stba	%r12, [%r27 + 0x0000] %asi
	.word 0xdabc4400  ! 4063: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xd68f0e80  ! 4064: LDUBA_R	lduba	[%r28, %r0] 0x74, %r11
	.word 0xdcae2000  ! 4065: STBA_I	stba	%r14, [%r24 + 0x0000] %asi
	.word 0xdc8e6000  ! 4066: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r14
	.word 0xdcd6a000  ! 4067: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r14
	.word 0xdebd04a0  ! 4068: STDA_R	stda	%r15, [%r20 + %r0] 0x25
	mov	0x20, %r16
	.word 0x87802025  ! 4070: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r26
	.word 0xdc8e89e0  ! 4072: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r14
	.word 0x87802020  ! 4073: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f62000  ! 4074: STXA_I	stxa	%r8, [%r24 + 0x0000] %asi
	.word 0xd08ee000  ! 4075: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r8
	.word 0xd0966000  ! 4076: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r8
	.word 0xd0962000  ! 4077: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r8
	.word 0xdac78e80  ! 4078: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r13
	mov	0x38, %r19
	.word 0xd486e000  ! 4080: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	mov	0x7c8, %r23
	mov	0x60, %r19
	.word 0xdeb7ce80  ! 4083: STHA_R	stha	%r15, [%r31 + %r0] 0x74
	.word 0xd8d6a000  ! 4084: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r12
	mov	0x18, %r27
	.word 0xd88e2000  ! 4086: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r12
	.word 0xd8bee000  ! 4087: STDA_I	stda	%r12, [%r27 + 0x0000] %asi
	.word 0x87802073  ! 4088: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8cfa000  ! 4089: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0x87802072  ! 4090: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd89de000  ! 4091: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r12
	.word 0xdcb544a0  ! 4092: STHA_R	stha	%r14, [%r21 + %r0] 0x25
	.word 0xd2cc4400  ! 4093: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r9
	.word 0xdac48400  ! 4094: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	mov	0x20, %r24
	.word 0xd8bde000  ! 4096: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	mov	0x58, %r19
	mov	0x40, %r17
	.word 0xd8ad2000  ! 4099: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	mov	0x0, %r17
	.word 0x8780204f  ! 4101: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b76000  ! 4102: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xdca40400  ! 4103: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xd0c72000  ! 4104: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	mov	0x70, %r24
	mov	0x48, %r24
	.word 0x87802073  ! 4107: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd08f6000  ! 4108: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r8
	.word 0xd8b4c400  ! 4109: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	mov	0x7c8, %r22
	.word 0xd2940400  ! 4111: LDUHA_R	lduha	[%r16, %r0] 0x20, %r9
	mov	0x10, %r25
	.word 0xdeaec9e0  ! 4113: STBA_R	stba	%r15, [%r27 + %r0] 0x4f
	.word 0xd0be09e0  ! 4114: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0xdcd609e0  ! 4115: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r14
	.word 0xd8f5c4a0  ! 4116: STXA_R	stxa	%r12, [%r23 + %r0] 0x25
	.word 0xd8cc4400  ! 4117: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r12
	.word 0xdad74e40  ! 4118: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r13
	.word 0xde97a000  ! 4119: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	mov	0x18, %r25
	.word 0xdebe89e0  ! 4121: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802020  ! 4123: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 4124: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabc0400  ! 4125: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0x87802020  ! 4126: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf74e60  ! 4127: STXA_R	stxa	%r14, [%r29 + %r0] 0x73
	.word 0x87802020  ! 4128: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 4129: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc8fa000  ! 4130: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 4131: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcc74e60  ! 4132: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r14
	.word 0xd6ae49e0  ! 4133: STBA_R	stba	%r11, [%r25 + %r0] 0x4f
	mov	0x60, %r24
	mov	0x78, %r25
	.word 0xdaa649e0  ! 4136: STWA_R	stwa	%r13, [%r25 + %r0] 0x4f
	mov	0x40, %r27
	.word 0xd0ac4400  ! 4138: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0xdedc2000  ! 4139: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r15
	.word 0xdab40400  ! 4140: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	mov	0x10, %r18
	.word 0xd0bc6000  ! 4142: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	.word 0xd0d42000  ! 4143: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r8
	mov	0x7f0, %r20
	.word 0xd0a42000  ! 4145: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xd0c70e80  ! 4146: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r8
	.word 0x87802020  ! 4147: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f584a0  ! 4148: STXA_R	stxa	%r9, [%r22 + %r0] 0x25
	.word 0xd6cfce60  ! 4149: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r11
	mov	0x38, %r26
	mov	0x7e0, %r21
	.word 0xd8d7e000  ! 4152: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0x87802025  ! 4153: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8c56000  ! 4154: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r12
	mov	0x70, %r27
	mov	0x10, %r25
	mov	0x8, %r27
	.word 0xdac6c9e0  ! 4158: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r13
	.word 0xdc95a000  ! 4159: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r14
	.word 0xd88d44a0  ! 4160: LDUBA_R	lduba	[%r21, %r0] 0x25, %r12
	.word 0xd6970e60  ! 4161: LDUHA_R	lduha	[%r28, %r0] 0x73, %r11
	.word 0xdedd04a0  ! 4162: LDXA_R	ldxa	[%r20, %r0] 0x25, %r15
	.word 0xde970e60  ! 4163: LDUHA_R	lduha	[%r28, %r0] 0x73, %r15
	.word 0xdaa5a000  ! 4164: STWA_I	stwa	%r13, [%r22 + 0x0000] %asi
	.word 0xdad5e000  ! 4165: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r13
	.word 0xdacda000  ! 4166: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r13
	.word 0xda9da000  ! 4167: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r13
	.word 0x87802072  ! 4168: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c0, %r23
	.word 0xd6dd44a0  ! 4170: LDXA_R	ldxa	[%r21, %r0] 0x25, %r11
	.word 0x87802073  ! 4171: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8d78e40  ! 4172: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r12
	.word 0xd4ac8400  ! 4173: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0xd4b7a000  ! 4174: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd4a76000  ! 4175: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4876000  ! 4176: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 4177: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r17
	.word 0xd4a4a000  ! 4179: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xd4dc8400  ! 4180: LDXA_R	ldxa	[%r18, %r0] 0x20, %r10
	.word 0x87802073  ! 4181: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdebe6000  ! 4182: STDA_I	stda	%r15, [%r25 + 0x0000] %asi
	.word 0x87802025  ! 4183: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde8d2000  ! 4184: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r15
	.word 0xdeada000  ! 4185: STBA_I	stba	%r15, [%r22 + 0x0000] %asi
	mov	0x48, %r16
	.word 0xde9d6000  ! 4187: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r15
	.word 0xdcf44400  ! 4188: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0x87802020  ! 4189: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa56000  ! 4190: STWA_I	stwa	%r13, [%r21 + 0x0000] %asi
	.word 0xda97ce60  ! 4191: LDUHA_R	lduha	[%r31, %r0] 0x73, %r13
	mov	0x7f0, %r20
	.word 0xded5a000  ! 4193: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r15
	.word 0xdeb56000  ! 4194: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 4195: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8940400  ! 4196: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	.word 0xdaf4c400  ! 4197: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xd6c78e60  ! 4198: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r11
	.word 0x87802025  ! 4199: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdab72000  ! 4200: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xd09cc400  ! 4201: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	.word 0xdccec9e0  ! 4202: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r14
	mov	0x30, %r19
	.word 0xda870e80  ! 4204: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r13
	.word 0x87802020  ! 4205: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bea000  ! 4206: STDA_I	stda	%r8, [%r26 + 0x0000] %asi
	mov	0x20, %r26
	.word 0xd8878e60  ! 4208: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r12
	.word 0x87802073  ! 4209: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x78, %r26
	.word 0xd4dfa000  ! 4212: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	mov	0x30, %r16
	.word 0xd4f7a000  ! 4214: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xdcbc8400  ! 4215: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xd0f6c9e0  ! 4216: STXA_R	stxa	%r8, [%r27 + %r0] 0x4f
	mov	0x3c8, %r21
	.word 0x87802074  ! 4218: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4d74e80  ! 4219: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r10
	.word 0x87802020  ! 4220: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xda972000  ! 4222: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	mov	0x50, %r25
	.word 0xdeb7ce60  ! 4224: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	mov	0x3d0, %r22
	.word 0x8780204f  ! 4226: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f0, %r22
	.word 0xd8c48400  ! 4228: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	.word 0xd0976000  ! 4229: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	mov	0x38, %r16
	.word 0xd0af0e40  ! 4231: STBA_R	stba	%r8, [%r28 + %r0] 0x72
	mov	0x58, %r19
	mov	0x38, %r16
	.word 0xd0876000  ! 4234: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0d7e000  ! 4235: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xd087a000  ! 4236: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	mov	0x7d8, %r20
	mov	0x20, %r16
	.word 0xd0d76000  ! 4239: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0f76000  ! 4240: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd4cd04a0  ! 4241: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r10
	.word 0x87802020  ! 4242: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b7ce40  ! 4243: STHA_R	stha	%r9, [%r31 + %r0] 0x72
	.word 0xd2ad2000  ! 4244: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0x8780204f  ! 4245: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b40400  ! 4246: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xd2b74e80  ! 4247: STHA_R	stha	%r9, [%r29 + %r0] 0x74
	.word 0xdca70e40  ! 4248: STWA_R	stwa	%r14, [%r28 + %r0] 0x72
	mov	0x50, %r27
	.word 0xda956000  ! 4250: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 4251: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdadfa000  ! 4252: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	mov	0x3c0, %r23
	.word 0xdad649e0  ! 4254: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r13
	.word 0x87802020  ! 4255: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c46000  ! 4256: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0xd29c2000  ! 4257: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	.word 0xd0f6c9e0  ! 4258: STXA_R	stxa	%r8, [%r27 + %r0] 0x4f
	.word 0xde94c400  ! 4259: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	.word 0xdcbf4e80  ! 4260: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	.word 0xd2dc2000  ! 4261: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r9
	.word 0xdcd5c4a0  ! 4262: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r14
	.word 0xd6948400  ! 4263: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	.word 0xdcf689e0  ! 4264: STXA_R	stxa	%r14, [%r26 + %r0] 0x4f
	.word 0xd6a7ce60  ! 4265: STWA_R	stwa	%r11, [%r31 + %r0] 0x73
	mov	0x60, %r17
	mov	0x3d8, %r21
	.word 0xdeace000  ! 4268: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xdebc2000  ! 4269: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	mov	0x3c0, %r22
	mov	0x10, %r18
	mov	0x3c8, %r20
	.word 0x8780204f  ! 4273: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bf8e80  ! 4274: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	mov	0x7e0, %r22
	.word 0xd0af4e80  ! 4276: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	.word 0xd6844400  ! 4277: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r11
	.word 0xd4cc6000  ! 4278: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	.word 0xd494a000  ! 4279: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r10
	mov	0x18, %r19
	.word 0xd4f4a000  ! 4281: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	.word 0xd6d504a0  ! 4282: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r11
	.word 0xd294e000  ! 4283: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	mov	0x60, %r25
	.word 0xd29504a0  ! 4285: LDUHA_R	lduha	[%r20, %r0] 0x25, %r9
	.word 0xd8f42000  ! 4286: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xd2acc400  ! 4287: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0xd2a42000  ! 4288: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	mov	0x28, %r24
	.word 0xd2f42000  ! 4290: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0xdea689e0  ! 4291: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 4292: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabce000  ! 4293: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 4294: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda94e000  ! 4295: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r13
	.word 0xdab46000  ! 4296: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	mov	0x8, %r16
	mov	0x7f8, %r22
	.word 0x87802073  ! 4299: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8cf8e40  ! 4300: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r12
	mov	0x50, %r27
	mov	0x7e0, %r23
	.word 0xdcde6000  ! 4303: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4304: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8cfce60  ! 4305: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r12
	.word 0xd0856000  ! 4306: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r8
	mov	0x3f8, %r23
	mov	0x0, %r16
	.word 0xd0852000  ! 4309: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r8
	.word 0xd0a56000  ! 4310: STWA_I	stwa	%r8, [%r21 + 0x0000] %asi
	mov	0x78, %r16
	.word 0xd0b5a000  ! 4312: STHA_I	stha	%r8, [%r22 + 0x0000] %asi
	.word 0xd8ac8400  ! 4313: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0xd2a70e80  ! 4314: STWA_R	stwa	%r9, [%r28 + %r0] 0x74
	.word 0x87802072  ! 4315: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 4316: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd08cc400  ! 4317: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	.word 0xdac5a000  ! 4318: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r13
	.word 0xda956000  ! 4319: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r13
	mov	0x40, %r16
	.word 0xdab52000  ! 4321: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	.word 0xdad5a000  ! 4322: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r13
	.word 0x87802025  ! 4323: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2878e40  ! 4324: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r9
	.word 0x87802025  ! 4325: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f7ce60  ! 4326: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	.word 0xd0b46000  ! 4327: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	mov	0x40, %r27
	.word 0xd4cd44a0  ! 4329: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r10
	.word 0xd6d4e000  ! 4330: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r11
	.word 0xd6b4a000  ! 4331: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd6bc6000  ! 4332: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0xd68ca000  ! 4333: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r11
	.word 0xd6b42000  ! 4334: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4335: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a7e000  ! 4336: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xd0afce40  ! 4337: STBA_R	stba	%r8, [%r31 + %r0] 0x72
	mov	0x50, %r24
	mov	0x18, %r17
	.word 0xdeaf6000  ! 4340: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xd8b40400  ! 4341: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	mov	0x18, %r19
	mov	0x20, %r16
	.word 0xde97a000  ! 4344: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	.word 0xdeb7e000  ! 4345: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xdebfce80  ! 4346: STDA_R	stda	%r15, [%r31 + %r0] 0x74
	.word 0xd4b72000  ! 4347: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd4bfa000  ! 4348: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	mov	0x60, %r25
	.word 0x87802020  ! 4350: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b62000  ! 4351: STHA_I	stha	%r10, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 4352: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r19
	.word 0xd4a5c4a0  ! 4354: STWA_R	stwa	%r10, [%r23 + %r0] 0x25
	mov	0x3e8, %r23
	.word 0x87802020  ! 4356: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8e09e0  ! 4357: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r15
	.word 0xd6f76000  ! 4358: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 4359: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a7e000  ! 4360: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xdaa649e0  ! 4361: STWA_R	stwa	%r13, [%r25 + %r0] 0x4f
	.word 0xd0972000  ! 4362: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0x87802020  ! 4363: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf7ce80  ! 4364: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	.word 0x87802072  ! 4365: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8ade000  ! 4366: STBA_I	stba	%r12, [%r23 + 0x0000] %asi
	.word 0xd895e000  ! 4367: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r12
	.word 0xd88d2000  ! 4368: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r12
	.word 0xd885a000  ! 4369: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r12
	.word 0xd8cde000  ! 4370: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r12
	.word 0x87802074  ! 4371: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 4372: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd88fe000  ! 4373: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd8f76000  ! 4374: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	mov	0x58, %r26
	.word 0xd4c74e40  ! 4376: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r10
	.word 0xd8b78e60  ! 4377: STHA_R	stha	%r12, [%r30 + %r0] 0x73
	mov	0x3c8, %r20
	.word 0xd8dc4400  ! 4379: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0xd6af4e80  ! 4380: STBA_R	stba	%r11, [%r29 + %r0] 0x74
	.word 0xd0b48400  ! 4381: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0x87802072  ! 4382: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd296c9e0  ! 4383: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r9
	.word 0xd8876000  ! 4384: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4385: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a504a0  ! 4386: STWA_R	stwa	%r9, [%r20 + %r0] 0x25
	.word 0xd48d6000  ! 4387: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r10
	.word 0xd4c52000  ! 4388: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r10
	mov	0x20, %r19
	.word 0xd8dec9e0  ! 4390: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r12
	mov	0x28, %r27
	.word 0xde9d6000  ! 4392: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r15
	.word 0xdc8609e0  ! 4393: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r14
	.word 0xdca74e40  ! 4394: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	.word 0xdacf4e40  ! 4395: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r13
	.word 0x87802073  ! 4396: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r16
	.word 0xdec40400  ! 4398: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xd0dfa000  ! 4399: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	mov	0x18, %r18
	.word 0x87802073  ! 4401: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f78e60  ! 4402: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	.word 0xdecd44a0  ! 4403: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r15
	mov	0x28, %r18
	.word 0xd8c56000  ! 4405: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r12
	mov	0x7c8, %r22
	.word 0xd09cc400  ! 4407: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	.word 0xdcdd6000  ! 4408: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r14
	mov	0x3d8, %r20
	.word 0xd4df4e80  ! 4410: LDXA_R	ldxa	[%r29, %r0] 0x74, %r10
	.word 0xd89ec9e0  ! 4411: LDDA_R	ldda	[%r27, %r0] 0x4f, %r12
	mov	0x58, %r18
	.word 0xd4f5a000  ! 4413: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	.word 0xdca504a0  ! 4414: STWA_R	stwa	%r14, [%r20 + %r0] 0x25
	mov	0x60, %r24
	mov	0x78, %r27
	mov	0x60, %r25
	.word 0xdcd70e60  ! 4418: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r14
	mov	0x68, %r18
	.word 0xd0af0e80  ! 4420: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	.word 0xd28d6000  ! 4421: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r9
	mov	0x7d0, %r20
	.word 0xd2bd6000  ! 4423: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	.word 0xd2bda000  ! 4424: STDA_I	stda	%r9, [%r22 + 0x0000] %asi
	.word 0xd2f56000  ! 4425: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	.word 0xd2f52000  ! 4426: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	mov	0x50, %r17
	mov	0x0, %r17
	.word 0xd29da000  ! 4429: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r9
	.word 0xd2bd6000  ! 4430: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	.word 0xd2f52000  ! 4431: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	mov	0x68, %r26
	.word 0xde848400  ! 4433: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	.word 0xde95e000  ! 4434: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r15
	.word 0xd2b70e60  ! 4435: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	.word 0xde852000  ! 4436: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r15
	mov	0x3f0, %r23
	.word 0xdaafce40  ! 4438: STBA_R	stba	%r13, [%r31 + %r0] 0x72
	mov	0x28, %r25
	.word 0xd0c5c4a0  ! 4440: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r8
	.word 0xd0852000  ! 4441: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r8
	mov	0x3f0, %r21
	.word 0xd0ad2000  ! 4443: STBA_I	stba	%r8, [%r20 + 0x0000] %asi
	.word 0x87802072  ! 4444: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0be6000  ! 4445: STDA_I	stda	%r8, [%r25 + 0x0000] %asi
	mov	0x20, %r16
	.word 0xd0a4c400  ! 4447: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xd886a000  ! 4448: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r12
	.word 0xd8f66000  ! 4449: STXA_I	stxa	%r12, [%r25 + 0x0000] %asi
	mov	0x3f0, %r23
	mov	0x3d8, %r23
	.word 0xdc848400  ! 4452: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	.word 0xda97ce60  ! 4453: LDUHA_R	lduha	[%r31, %r0] 0x73, %r13
	.word 0xd8dee000  ! 4454: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r12
	.word 0xd8d62000  ! 4455: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r12
	.word 0x87802074  ! 4456: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f4c400  ! 4457: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0xd4d74e60  ! 4458: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r10
	.word 0xd0f7ce60  ! 4459: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	mov	0x7e8, %r20
	.word 0xdca504a0  ! 4461: STWA_R	stwa	%r14, [%r20 + %r0] 0x25
	.word 0xdea504a0  ! 4462: STWA_R	stwa	%r15, [%r20 + %r0] 0x25
	mov	0x7e8, %r21
	.word 0xda8c8400  ! 4464: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	.word 0xd8c72000  ! 4465: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd89649e0  ! 4466: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r12
	mov	0x70, %r26
	mov	0x3e8, %r21
	.word 0x87802020  ! 4469: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f56000  ! 4470: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 4471: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0cc0400  ! 4472: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xd4f42000  ! 4473: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd4d46000  ! 4474: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r10
	.word 0xd0c74e40  ! 4475: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r8
	.word 0xdadf8e40  ! 4476: LDXA_R	ldxa	[%r30, %r0] 0x72, %r13
	.word 0xd49ce000  ! 4477: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0xd4f42000  ! 4478: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd4ac2000  ! 4479: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0xd4ac2000  ! 4480: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 4481: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 4482: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d0, %r23
	.word 0xd2974e40  ! 4484: LDUHA_R	lduha	[%r29, %r0] 0x72, %r9
	.word 0xdcdc4400  ! 4485: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	.word 0xd0d4e000  ! 4486: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	.word 0xd08ca000  ! 4487: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 4488: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a72000  ! 4489: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0xdabf0e60  ! 4491: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	.word 0xda9dc4a0  ! 4492: LDDA_R	ldda	[%r23, %r0] 0x25, %r13
	mov	0x3f0, %r20
	.word 0xd894c400  ! 4494: LDUHA_R	lduha	[%r19, %r0] 0x20, %r12
	.word 0xd2bfe000  ! 4495: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	mov	0x20, %r25
	mov	0x3e0, %r23
	.word 0xd2b7e000  ! 4498: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 4499: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2a7a000  ! 4500: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 4501: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2d56000  ! 4502: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r9
	.word 0xd0d649e0  ! 4503: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r8
	.word 0x87802025  ! 4504: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r24
	.word 0xdeb44400  ! 4506: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0xd4c7a000  ! 4507: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	mov	0x78, %r26
	mov	0x40, %r27
	.word 0xd8948400  ! 4510: LDUHA_R	lduha	[%r18, %r0] 0x20, %r12
	.word 0xd2a7a000  ! 4511: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xd2afe000  ! 4512: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xde970e40  ! 4513: LDUHA_R	lduha	[%r28, %r0] 0x72, %r15
	.word 0x87802020  ! 4514: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4515: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebc6000  ! 4516: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	mov	0x3d0, %r21
	.word 0xdef4e000  ! 4518: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xd8ad44a0  ! 4519: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	.word 0xd68fce60  ! 4520: LDUBA_R	lduba	[%r31, %r0] 0x73, %r11
	.word 0xd4d46000  ! 4521: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 4522: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r16
	.word 0xdebf4e60  ! 4524: STDA_R	stda	%r15, [%r29 + %r0] 0x73
	.word 0xd2b70e80  ! 4525: STHA_R	stha	%r9, [%r28 + %r0] 0x74
	.word 0xd0970e60  ! 4526: LDUHA_R	lduha	[%r28, %r0] 0x73, %r8
	.word 0xd6c72000  ! 4527: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6c76000  ! 4528: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd69689e0  ! 4529: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r11
	.word 0x87802020  ! 4530: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a4a000  ! 4531: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0xd28ca000  ! 4532: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2f4e000  ! 4533: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	mov	0x18, %r24
	.word 0x87802025  ! 4535: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8d70e40  ! 4536: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r12
	mov	0x7f8, %r22
	.word 0xd6c5e000  ! 4538: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r11
	.word 0xd2bc4400  ! 4539: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0xd4878e80  ! 4540: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r10
	.word 0xd4f5e000  ! 4541: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	.word 0xd0f504a0  ! 4542: STXA_R	stxa	%r8, [%r20 + %r0] 0x25
	.word 0xd0b44400  ! 4543: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xdcd5e000  ! 4544: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r14
	.word 0xdca5e000  ! 4545: STWA_I	stwa	%r14, [%r23 + 0x0000] %asi
	.word 0xd8c70e40  ! 4546: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r12
	.word 0xd6af0e60  ! 4547: STBA_R	stba	%r11, [%r28 + %r0] 0x73
	.word 0xd4f78e80  ! 4548: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x8780204f  ! 4550: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r24
	.word 0xd4c5a000  ! 4552: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r10
	mov	0x40, %r18
	.word 0x87802072  ! 4554: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r26
	.word 0xd8de49e0  ! 4556: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r12
	.word 0x87802025  ! 4557: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb78e80  ! 4558: STHA_R	stha	%r15, [%r30 + %r0] 0x74
	.word 0xd8d78e60  ! 4559: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r12
	.word 0xd4f40400  ! 4560: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	mov	0x3c0, %r23
	.word 0xd2d7ce80  ! 4562: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r9
	.word 0xd4ae6000  ! 4563: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	mov	0x18, %r18
	.word 0x87802020  ! 4565: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49c2000  ! 4566: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	.word 0xdaf74e80  ! 4567: STXA_R	stxa	%r13, [%r29 + %r0] 0x74
	.word 0xdeb46000  ! 4568: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	mov	0x48, %r16
	.word 0xd4b6c9e0  ! 4570: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	mov	0x50, %r25
	mov	0x7f0, %r22
	.word 0xd8f42000  ! 4573: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	mov	0x3c8, %r22
	.word 0xd8a42000  ! 4575: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8b46000  ! 4576: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0xd8a7ce40  ! 4577: STWA_R	stwa	%r12, [%r31 + %r0] 0x72
	.word 0xd0bcc400  ! 4578: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0xd49c6000  ! 4579: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	mov	0x7d0, %r21
	mov	0x48, %r16
	mov	0x60, %r16
	.word 0xd2944400  ! 4583: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	mov	0x50, %r27
	.word 0xd2ace000  ! 4585: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0xd2bc6000  ! 4586: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0xd2ace000  ! 4587: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 4588: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r19
	.word 0xd2aea000  ! 4590: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0xd2aea000  ! 4591: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0xd28ee000  ! 4592: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r9
	mov	0x7f0, %r20
	.word 0xd2aee000  ! 4594: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	.word 0x87802025  ! 4595: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4596: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29de000  ! 4597: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r9
	.word 0xd2a5e000  ! 4598: STWA_I	stwa	%r9, [%r23 + 0x0000] %asi
	.word 0xd2bf8e60  ! 4599: STDA_R	stda	%r9, [%r30 + %r0] 0x73
	.word 0xd8a5a000  ! 4600: STWA_I	stwa	%r12, [%r22 + 0x0000] %asi
	.word 0xd8952000  ! 4601: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r12
	.word 0xd8f56000  ! 4602: STXA_I	stxa	%r12, [%r21 + 0x0000] %asi
	.word 0xd8bde000  ! 4603: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0xd8d56000  ! 4604: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r12
	.word 0xd4d44400  ! 4605: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0x87802020  ! 4606: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 4607: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 4608: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca7a000  ! 4609: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdc8fa000  ! 4610: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdcd76000  ! 4611: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	mov	0x60, %r24
	.word 0xdecec9e0  ! 4613: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r15
	.word 0xdec78e60  ! 4614: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r15
	.word 0x87802072  ! 4615: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa40400  ! 4616: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 4617: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f6e000  ! 4618: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xd4a6c9e0  ! 4620: STWA_R	stwa	%r10, [%r27 + %r0] 0x4f
	.word 0xd296a000  ! 4621: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r9
	.word 0xd2a6a000  ! 4622: STWA_I	stwa	%r9, [%r26 + 0x0000] %asi
	.word 0xd6b48400  ! 4623: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x78, %r24
	mov	0x7d8, %r21
	.word 0xd2f6e000  ! 4627: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	.word 0xd2d6e000  ! 4628: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r9
	.word 0xd2b62000  ! 4629: STHA_I	stha	%r9, [%r24 + 0x0000] %asi
	.word 0xd8d70e80  ! 4630: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r12
	.word 0xd4ae6000  ! 4631: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0xd28e89e0  ! 4632: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r9
	.word 0x87802020  ! 4633: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c584a0  ! 4634: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r10
	mov	0x3f0, %r22
	.word 0xd8b72000  ! 4636: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd8c72000  ! 4637: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8dfa000  ! 4638: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8f7a000  ! 4639: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0xd8c76000  ! 4641: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	mov	0x7d0, %r21
	mov	0x3e8, %r21
	mov	0x40, %r16
	.word 0xd8a74e60  ! 4645: STWA_R	stwa	%r12, [%r29 + %r0] 0x73
	.word 0xd4bf8e60  ! 4646: STDA_R	stda	%r10, [%r30 + %r0] 0x73
	.word 0xd0f72000  ! 4647: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	mov	0x3d0, %r23
	.word 0xdea40400  ! 4649: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	mov	0x18, %r26
	mov	0x3f8, %r21
	.word 0xdc844400  ! 4652: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	.word 0xd0d72000  ! 4653: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0x87802074  ! 4654: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 4655: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd097a000  ! 4656: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	.word 0xdeaf0e40  ! 4657: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	mov	0x3f8, %r21
	mov	0x7c0, %r21
	.word 0xd6a78e60  ! 4660: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0x87802020  ! 4661: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r17
	.word 0xd4cc6000  ! 4663: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	.word 0xd4b42000  ! 4664: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	.word 0xdcb74e80  ! 4665: STHA_R	stha	%r14, [%r29 + %r0] 0x74
	.word 0xdc844400  ! 4666: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	.word 0xd8b4a000  ! 4667: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0xdaf78e40  ! 4668: STXA_R	stxa	%r13, [%r30 + %r0] 0x72
	.word 0xd4ac2000  ! 4669: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	mov	0x7f8, %r23
	.word 0xd0bcc400  ! 4671: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0x87802072  ! 4672: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r27
	.word 0xd2c4e000  ! 4674: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xd2b42000  ! 4675: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0xdac6c9e0  ! 4676: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r13
	.word 0x87802072  ! 4677: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd88cc400  ! 4678: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	.word 0xd0b4a000  ! 4679: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 4680: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bc0400  ! 4681: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xd88f6000  ! 4682: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xdac7ce80  ! 4683: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r13
	mov	0x3d8, %r22
	mov	0x3c0, %r21
	.word 0xde87e000  ! 4686: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdabfce40  ! 4687: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	.word 0xd8afa000  ! 4688: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 4689: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r17
	.word 0xd8f52000  ! 4691: STXA_I	stxa	%r12, [%r20 + 0x0000] %asi
	.word 0xd8afce60  ! 4692: STBA_R	stba	%r12, [%r31 + %r0] 0x73
	.word 0xd0f5a000  ! 4693: STXA_I	stxa	%r8, [%r22 + 0x0000] %asi
	mov	0x3f8, %r23
	mov	0x3d0, %r20
	.word 0xd0b56000  ! 4696: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	mov	0x0, %r17
	mov	0x7f0, %r22
	.word 0xdac78e60  ! 4699: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r13
	mov	0x40, %r18
	.word 0xdeb5a000  ! 4701: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	.word 0xdef52000  ! 4702: STXA_I	stxa	%r15, [%r20 + 0x0000] %asi
	.word 0xdec5e000  ! 4703: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r15
	.word 0x87802072  ! 4704: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 4705: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde9ca000  ! 4706: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r15
	mov	0x7f8, %r20
	mov	0x68, %r16
	mov	0x70, %r19
	.word 0xd0dd04a0  ! 4710: LDXA_R	ldxa	[%r20, %r0] 0x25, %r8
	.word 0xdca4a000  ! 4711: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcc4e000  ! 4712: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r14
	.word 0xdcd4a000  ! 4713: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	.word 0xdc842000  ! 4714: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	mov	0x7c8, %r20
	.word 0xdc8ca000  ! 4716: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r14
	mov	0x3f8, %r22
	.word 0x87802020  ! 4718: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbea000  ! 4719: STDA_I	stda	%r14, [%r26 + 0x0000] %asi
	.word 0x87802072  ! 4720: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 4721: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdec70e80  ! 4722: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r15
	mov	0x10, %r17
	mov	0x30, %r16
	.word 0xd8ad04a0  ! 4725: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	.word 0xdea48400  ! 4726: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xd6adc4a0  ! 4727: STBA_R	stba	%r11, [%r23 + %r0] 0x25
	mov	0x0, %r25
	.word 0xd29f0e80  ! 4729: LDDA_R	ldda	[%r28, %r0] 0x74, %r9
	.word 0xd6d4c400  ! 4730: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	.word 0x87802020  ! 4731: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca72000  ! 4732: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	mov	0x10, %r19
	.word 0xd08c8400  ! 4734: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0x87802073  ! 4735: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdac7e000  ! 4736: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xd48f4e40  ! 4737: LDUBA_R	lduba	[%r29, %r0] 0x72, %r10
	mov	0x50, %r16
	mov	0x10, %r18
	.word 0xd28f0e60  ! 4740: LDUBA_R	lduba	[%r28, %r0] 0x73, %r9
	.word 0xd887e000  ! 4741: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	mov	0x8, %r27
	.word 0x87802072  ! 4743: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcd78e60  ! 4744: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r14
	.word 0xd4f649e0  ! 4745: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	mov	0x7f8, %r22
	.word 0xdeacc400  ! 4747: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0x87802025  ! 4748: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdca48400  ! 4750: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xdef44400  ! 4751: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	mov	0x58, %r25
	.word 0xd497e000  ! 4753: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd4af6000  ! 4755: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0xd4d76000  ! 4757: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0xd8cc4400  ! 4758: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r12
	.word 0xdadc4400  ! 4759: LDXA_R	ldxa	[%r17, %r0] 0x20, %r13
	mov	0x7f8, %r23
	mov	0x10, %r26
	.word 0xd8bf6000  ! 4762: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	mov	0x3e0, %r23
	.word 0x87802072  ! 4764: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r27
	.word 0xdcf48400  ! 4766: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xd6afce60  ! 4767: STBA_R	stba	%r11, [%r31 + %r0] 0x73
	mov	0x40, %r26
	.word 0x87802072  ! 4769: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4ac8400  ! 4770: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	mov	0x3e8, %r23
	.word 0xd8ac8400  ! 4772: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0xd2cfce40  ! 4773: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r9
	.word 0xd0b78e60  ! 4774: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	.word 0x87802074  ! 4775: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bfa000  ! 4776: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd0844400  ! 4777: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r8
	.word 0xdecd44a0  ! 4778: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r15
	.word 0x87802074  ! 4779: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbc6000  ! 4780: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xdcdca000  ! 4781: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xd8df0e60  ! 4782: LDXA_R	ldxa	[%r28, %r0] 0x73, %r12
	mov	0x28, %r27
	.word 0xdab70e40  ! 4784: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	.word 0xd68c6000  ! 4785: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r11
	.word 0x87802072  ! 4786: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4787: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r20
	.word 0x87802072  ! 4789: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 4790: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcb689e0  ! 4791: STHA_R	stha	%r14, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 4792: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c8, %r21
	.word 0xd4c7e000  ! 4794: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4a72000  ! 4795: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7c8, %r22
	mov	0x70, %r25
	mov	0x48, %r26
	mov	0x50, %r17
	mov	0x50, %r26
	.word 0xd4bfa000  ! 4802: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd4b72000  ! 4803: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	mov	0x60, %r17
	.word 0xd4b76000  ! 4805: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	mov	0x30, %r27
	.word 0x87802073  ! 4807: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f66000  ! 4808: STXA_I	stxa	%r10, [%r25 + 0x0000] %asi
	mov	0x58, %r16
	.word 0x87802073  ! 4810: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc94c400  ! 4811: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	.word 0x87802020  ! 4812: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2be49e0  ! 4813: STDA_R	stda	%r9, [%r25 + %r0] 0x4f
	.word 0xd0ac0400  ! 4814: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	.word 0xd0c7ce80  ! 4815: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r8
	.word 0xd4a46000  ! 4816: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xd4d4e000  ! 4817: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0xded48400  ! 4818: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	.word 0xd4a46000  ! 4819: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0xd4ac2000  ! 4821: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	mov	0x68, %r25
	.word 0xd2978e80  ! 4823: LDUHA_R	lduha	[%r30, %r0] 0x74, %r9
	.word 0x87802020  ! 4824: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r19
	.word 0xd2ace000  ! 4826: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0xd0cd84a0  ! 4827: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r8
	mov	0x7f0, %r20
	.word 0xdaf4e000  ! 4829: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xdaa4a000  ! 4830: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xdcac0400  ! 4831: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0x87802072  ! 4832: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b4a000  ! 4833: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	mov	0x30, %r26
	.word 0x87802072  ! 4835: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f7a000  ! 4836: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd0f70e80  ! 4837: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0xd6f72000  ! 4838: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xdaf609e0  ! 4839: STXA_R	stxa	%r13, [%r24 + %r0] 0x4f
	.word 0xd8bfa000  ! 4840: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd8af2000  ! 4841: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xd68e09e0  ! 4842: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r11
	.word 0xd4a504a0  ! 4843: STWA_R	stwa	%r10, [%r20 + %r0] 0x25
	.word 0xd29f4e60  ! 4844: LDDA_R	ldda	[%r29, %r0] 0x73, %r9
	.word 0xd69c4400  ! 4845: LDDA_R	ldda	[%r17, %r0] 0x20, %r11
	.word 0xd6af4e40  ! 4846: STBA_R	stba	%r11, [%r29 + %r0] 0x72
	.word 0xdcb689e0  ! 4847: STHA_R	stha	%r14, [%r26 + %r0] 0x4f
	.word 0x8780204f  ! 4848: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bc8400  ! 4849: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xd0878e60  ! 4850: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r8
	.word 0x87802020  ! 4851: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd297ce80  ! 4852: LDUHA_R	lduha	[%r31, %r0] 0x74, %r9
	.word 0xd29c0400  ! 4853: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	.word 0x87802020  ! 4854: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabf8e40  ! 4855: STDA_R	stda	%r13, [%r30 + %r0] 0x72
	mov	0x7e8, %r22
	.word 0xdc9f2000  ! 4857: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xd8974e80  ! 4858: LDUHA_R	lduha	[%r29, %r0] 0x74, %r12
	.word 0xd0978e40  ! 4859: LDUHA_R	lduha	[%r30, %r0] 0x72, %r8
	mov	0x20, %r16
	.word 0xdabf8e60  ! 4861: STDA_R	stda	%r13, [%r30 + %r0] 0x73
	mov	0x38, %r25
	.word 0xde972000  ! 4863: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0x87802074  ! 4864: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef42000  ! 4865: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 4866: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd28f0e40  ! 4867: LDUBA_R	lduba	[%r28, %r0] 0x72, %r9
	.word 0x87802020  ! 4868: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c72000  ! 4869: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8a76000  ! 4870: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xd0cc0400  ! 4871: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xded72000  ! 4872: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xd4d48400  ! 4873: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	.word 0xd0840400  ! 4874: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	.word 0xdcc649e0  ! 4875: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r14
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd0d7e000  ! 4877: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	mov	0x20, %r24
	.word 0x87802025  ! 4879: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b4c400  ! 4880: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xd2be6000  ! 4881: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	.word 0xdaafce60  ! 4882: STBA_R	stba	%r13, [%r31 + %r0] 0x73
	.word 0xd8f78e80  ! 4883: STXA_R	stxa	%r12, [%r30 + %r0] 0x74
	mov	0x58, %r26
	.word 0x87802074  ! 4885: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r18
	.word 0xd2c7ce40  ! 4887: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r9
	mov	0x3f0, %r20
	.word 0xdab584a0  ! 4889: STHA_R	stha	%r13, [%r22 + %r0] 0x25
	.word 0xdcac8400  ! 4890: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xdebc2000  ! 4891: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0x87802072  ! 4893: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdea7e000  ! 4894: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 4895: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f8, %r21
	.word 0xd2bf0e80  ! 4897: STDA_R	stda	%r9, [%r28 + %r0] 0x74
	.word 0xdeb40400  ! 4898: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	mov	0x18, %r24
	.word 0xd48584a0  ! 4900: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r10
	.word 0x87802020  ! 4901: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd287a000  ! 4902: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	mov	0x38, %r26
	mov	0x40, %r24
	.word 0xd29fa000  ! 4905: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd2afce40  ! 4906: STBA_R	stba	%r9, [%r31 + %r0] 0x72
	.word 0xd6af4e60  ! 4907: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	.word 0x87802072  ! 4908: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2cc8400  ! 4909: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0xd6bc4400  ! 4910: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	mov	0x68, %r16
	.word 0xd0afce60  ! 4912: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	.word 0xde84a000  ! 4913: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	.word 0x87802020  ! 4914: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r20
	.word 0xdef504a0  ! 4916: STXA_R	stxa	%r15, [%r20 + %r0] 0x25
	.word 0xd4bd2000  ! 4917: STDA_I	stda	%r10, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 4918: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4919: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4aea000  ! 4920: STBA_I	stba	%r10, [%r26 + 0x0000] %asi
	.word 0xd48ee000  ! 4921: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r10
	.word 0xd4bc4400  ! 4922: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0xdaf74e60  ! 4923: STXA_R	stxa	%r13, [%r29 + %r0] 0x73
	mov	0x20, %r25
	.word 0xd0c7ce40  ! 4925: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r8
	.word 0xdaa70e80  ! 4926: STWA_R	stwa	%r13, [%r28 + %r0] 0x74
	.word 0xdab649e0  ! 4927: STHA_R	stha	%r13, [%r25 + %r0] 0x4f
	.word 0xd6f66000  ! 4928: STXA_I	stxa	%r11, [%r25 + 0x0000] %asi
	.word 0xd696e000  ! 4929: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	mov	0x60, %r27
	.word 0xd6de6000  ! 4931: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r11
	.word 0xd6a6e000  ! 4932: STWA_I	stwa	%r11, [%r27 + 0x0000] %asi
	.word 0xd6c6e000  ! 4933: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r11
	.word 0xd6ce6000  ! 4934: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r11
	.word 0x87802074  ! 4935: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f56000  ! 4936: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	.word 0xd6dd84a0  ! 4937: LDXA_R	ldxa	[%r22, %r0] 0x25, %r11
	.word 0xd8d70e80  ! 4938: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r12
	.word 0xd6ada000  ! 4939: STBA_I	stba	%r11, [%r22 + 0x0000] %asi
	.word 0xd6a5e000  ! 4940: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 4941: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6cfa000  ! 4942: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	mov	0x70, %r24
	mov	0x7e0, %r21
	.word 0xd6af2000  ! 4945: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd6a7a000  ! 4946: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd29d84a0  ! 4947: LDDA_R	ldda	[%r22, %r0] 0x25, %r9
	.word 0xdac72000  ! 4948: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0xdca78e40  ! 4949: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	.word 0xdeb78e80  ! 4950: STHA_R	stha	%r15, [%r30 + %r0] 0x74
	mov	0x48, %r16
	.word 0xd6df2000  ! 4952: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6f74e80  ! 4953: STXA_R	stxa	%r11, [%r29 + %r0] 0x74
	.word 0xdaf44400  ! 4954: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0x87802074  ! 4955: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8b4e000  ! 4956: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xd88c2000  ! 4958: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	.word 0xd884e000  ! 4959: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r12
	.word 0x87802073  ! 4960: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8ace000  ! 4961: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 4962: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6df4e60  ! 4963: LDXA_R	ldxa	[%r29, %r0] 0x73, %r11
	.word 0xd6a4a000  ! 4964: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	.word 0xda8c4400  ! 4965: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0xd2bc4400  ! 4966: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0xd6f4e000  ! 4967: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	mov	0x8, %r19
	.word 0xd6bce000  ! 4969: STDA_I	stda	%r11, [%r19 + 0x0000] %asi
	.word 0xd6ac8400  ! 4970: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xdcafce40  ! 4971: STBA_R	stba	%r14, [%r31 + %r0] 0x72
	.word 0xd88ce000  ! 4972: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	.word 0xd6878e40  ! 4973: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r11
	.word 0xdedc0400  ! 4974: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	mov	0x38, %r26
	mov	0x0, %r24
	.word 0xd2bc0400  ! 4977: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xdece89e0  ! 4978: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r15
	.word 0xdca4e000  ! 4979: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	.word 0xd6848400  ! 4980: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	mov	0x7d8, %r20
	.word 0xdab504a0  ! 4982: STHA_R	stha	%r13, [%r20 + %r0] 0x25
	.word 0xdca42000  ! 4983: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xd4af0e40  ! 4984: STBA_R	stba	%r10, [%r28 + %r0] 0x72
	.word 0xdecf4e60  ! 4985: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r15
	.word 0xd69f0e60  ! 4986: LDDA_R	ldda	[%r28, %r0] 0x73, %r11
	mov	0x20, %r25
	.word 0xd2d46000  ! 4988: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	.word 0xd2ad04a0  ! 4989: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	mov	0x7f8, %r21
	.word 0xdea4e000  ! 4991: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xdecca000  ! 4992: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	.word 0xdef4a000  ! 4993: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 4994: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08cc400  ! 4995: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	.word 0xdaa74e60  ! 4996: STWA_R	stwa	%r13, [%r29 + %r0] 0x73
	.word 0xd8f4e000  ! 4997: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xdeb4c400  ! 4998: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	mov	0x10, %r16
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_1:
	.word 0xdcac8400  ! 1: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xd2d56000  ! 2: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r9
	.word 0xd6b48400  ! 3: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	mov	0x68, %r25
	mov	0x68, %r26
	.word 0xdca56000  ! 6: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	.word 0xd8b40400  ! 7: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xdcb5a000  ! 8: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0x8780204f  ! 9: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd89f8e80  ! 10: LDDA_R	ldda	[%r30, %r0] 0x74, %r12
	mov	0x60, %r18
	.word 0xd0cca000  ! 12: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	.word 0xd0b4a000  ! 13: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 14: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c544a0  ! 15: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r10
	mov	0x70, %r26
	.word 0xd0b74e60  ! 17: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	mov	0x3f8, %r23
	mov	0x50, %r27
	mov	0x7d8, %r22
	.word 0xd0dde000  ! 21: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r8
	.word 0xd28d84a0  ! 22: LDUBA_R	lduba	[%r22, %r0] 0x25, %r9
	mov	0x48, %r17
	.word 0xd8df0e60  ! 24: LDXA_R	ldxa	[%r28, %r0] 0x73, %r12
	mov	0x28, %r24
	.word 0xd8bd6000  ! 26: STDA_I	stda	%r12, [%r21 + 0x0000] %asi
	.word 0xd2ce09e0  ! 27: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r9
	.word 0x87802074  ! 28: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdab72000  ! 29: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	mov	0x0, %r18
	.word 0xda8fe000  ! 31: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	mov	0x60, %r26
	.word 0xda8f2000  ! 33: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xda876000  ! 34: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	mov	0x58, %r24
	.word 0x87802074  ! 36: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd69fce80  ! 37: LDDA_R	ldda	[%r31, %r0] 0x74, %r11
	.word 0xd895e000  ! 38: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r12
	.word 0xdaafce80  ! 39: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	.word 0xda85e000  ! 40: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	.word 0xda85e000  ! 41: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	.word 0xd88d44a0  ! 42: LDUBA_R	lduba	[%r21, %r0] 0x25, %r12
	.word 0xdab52000  ! 43: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	.word 0xdabda000  ! 44: STDA_I	stda	%r13, [%r22 + 0x0000] %asi
	mov	0x58, %r27
	.word 0x87802072  ! 46: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa46000  ! 47: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	.word 0xdaa46000  ! 48: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 49: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaaf2000  ! 50: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xd4a78e40  ! 51: STWA_R	stwa	%r10, [%r30 + %r0] 0x72
	.word 0xd2dd84a0  ! 52: LDXA_R	ldxa	[%r22, %r0] 0x25, %r9
	.word 0xd6d76000  ! 53: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	mov	0x7f0, %r21
	.word 0x87802025  ! 55: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b72000  ! 56: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd6b76000  ! 57: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd6afa000  ! 58: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x7c0, %r21
	.word 0x8780204f  ! 60: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6872000  ! 61: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd697e000  ! 62: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	mov	0x20, %r27
	mov	0x28, %r18
	.word 0x87802020  ! 65: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab48400  ! 66: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	mov	0x8, %r26
	mov	0x3f8, %r21
	.word 0xdcd72000  ! 69: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	mov	0x10, %r16
	mov	0x20, %r24
	.word 0xdc8fa000  ! 72: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xd6af8e60  ! 73: STBA_R	stba	%r11, [%r30 + %r0] 0x73
	.word 0xd8a74e60  ! 74: STWA_R	stwa	%r12, [%r29 + %r0] 0x73
	.word 0xdcf72000  ! 75: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xd2afce40  ! 76: STBA_R	stba	%r9, [%r31 + %r0] 0x72
	.word 0xd6f78e80  ! 77: STXA_R	stxa	%r11, [%r30 + %r0] 0x74
	mov	0x58, %r18
	.word 0x87802073  ! 79: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 80: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 81: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a5a000  ! 82: STWA_I	stwa	%r8, [%r22 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0xd0dda000  ! 84: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r8
	.word 0xd0c5a000  ! 85: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r8
	.word 0xd0f5a000  ! 86: STXA_I	stxa	%r8, [%r22 + 0x0000] %asi
	mov	0x70, %r27
	.word 0xd0ade000  ! 88: STBA_I	stba	%r8, [%r23 + 0x0000] %asi
	mov	0x70, %r26
	.word 0xd0bd6000  ! 90: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0xd0a5e000  ! 91: STWA_I	stwa	%r8, [%r23 + 0x0000] %asi
	.word 0xd89fce80  ! 92: LDDA_R	ldda	[%r31, %r0] 0x74, %r12
	mov	0x7c8, %r23
	.word 0xd4df4e60  ! 94: LDXA_R	ldxa	[%r29, %r0] 0x73, %r10
	.word 0xdaa544a0  ! 95: STWA_R	stwa	%r13, [%r21 + %r0] 0x25
	.word 0x87802072  ! 96: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca40400  ! 97: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	ta	T_CHANGE_PRIV	! macro
	.word 0xd69e89e0  ! 99: LDDA_R	ldda	[%r26, %r0] 0x4f, %r11
	.word 0xdead44a0  ! 100: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	.word 0xd6b76000  ! 101: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 102: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r17
	.word 0xd68c6000  ! 104: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r11
	.word 0xd8bc0400  ! 105: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xd2a42000  ! 106: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	.word 0xdec44400  ! 107: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0x87802072  ! 108: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd885e000  ! 109: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r12
	.word 0xd8d5e000  ! 110: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r12
	.word 0x87802020  ! 111: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a7e000  ! 112: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8afe000  ! 113: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd0c4c400  ! 114: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	.word 0x87802025  ! 115: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 116: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedf2000  ! 117: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	mov	0x28, %r25
	mov	0x7e8, %r23
	.word 0xdedf2000  ! 120: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xdebfa000  ! 121: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xd6cf0e60  ! 122: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r11
	mov	0x3c0, %r23
	.word 0xd6f76000  ! 124: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6d7e000  ! 125: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	.word 0xd0d70e80  ! 126: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r8
	.word 0xd6f72000  ! 127: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6b7a000  ! 128: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xde8e89e0  ! 129: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r15
	.word 0xd687e000  ! 130: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	mov	0x3c8, %r20
	.word 0xd6cf6000  ! 132: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	mov	0x7c8, %r23
	.word 0x8780204f  ! 134: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 135: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r19
	.word 0xd6bfa000  ! 137: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd29d44a0  ! 138: LDDA_R	ldda	[%r21, %r0] 0x25, %r9
	.word 0xd4ad04a0  ! 139: STBA_R	stba	%r10, [%r20 + %r0] 0x25
	.word 0xdca74e60  ! 140: STWA_R	stwa	%r14, [%r29 + %r0] 0x73
	.word 0xd0a72000  ! 141: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xd0dfe000  ! 142: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xdeaec9e0  ! 143: STBA_R	stba	%r15, [%r27 + %r0] 0x4f
	.word 0xd2a7e000  ! 144: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 145: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd285a000  ! 146: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r9
	mov	0x68, %r18
	mov	0x70, %r16
	.word 0xd2bd2000  ! 149: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	.word 0xd2f5a000  ! 150: STXA_I	stxa	%r9, [%r22 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0xdaac4400  ! 152: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	.word 0x87802020  ! 153: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r25
	.word 0x87802074  ! 155: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 156: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 157: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef7e000  ! 158: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0xdaa40400  ! 160: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	mov	0x40, %r26
	.word 0xdccfe000  ! 162: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	mov	0x58, %r25
	.word 0xdc9f2000  ! 164: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xdcc72000  ! 165: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcd76000  ! 166: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	.word 0xdc872000  ! 167: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0x87802072  ! 168: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r17
	.word 0x8780204f  ! 170: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4df0e80  ! 171: LDXA_R	ldxa	[%r28, %r0] 0x74, %r10
	.word 0xd887e000  ! 172: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8afa000  ! 173: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xdcacc400  ! 174: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0xd0cf2000  ! 175: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0x87802025  ! 176: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 177: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r19
	mov	0x60, %r19
	.word 0xd0bc6000  ! 180: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	mov	0x3e8, %r21
	mov	0x30, %r25
	.word 0xd0bca000  ! 183: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	mov	0x28, %r17
	.word 0xd0cca000  ! 185: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	.word 0xd09f4e40  ! 186: LDDA_R	ldda	[%r29, %r0] 0x72, %r8
	mov	0x7c8, %r21
	mov	0x3e8, %r22
	.word 0xdebc6000  ! 189: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xd2b74e80  ! 190: STHA_R	stha	%r9, [%r29 + %r0] 0x74
	.word 0xd8be89e0  ! 191: STDA_R	stda	%r12, [%r26 + %r0] 0x4f
	.word 0x87802072  ! 192: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2c7ce60  ! 193: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r9
	.word 0xd69dc4a0  ! 194: LDDA_R	ldda	[%r23, %r0] 0x25, %r11
	mov	0x60, %r18
	mov	0x58, %r18
	.word 0xdc846000  ! 197: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	.word 0xdccc2000  ! 198: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r14
	.word 0xdc8ce000  ! 199: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	.word 0xdcb4e000  ! 200: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 201: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcad6000  ! 202: STBA_I	stba	%r14, [%r21 + 0x0000] %asi
	.word 0xdcbde000  ! 203: STDA_I	stda	%r14, [%r23 + 0x0000] %asi
	.word 0xdcb5a000  ! 204: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0xdcc5a000  ! 205: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r14
	.word 0xdc95a000  ! 206: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r14
	.word 0xd0870e60  ! 207: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r8
	.word 0xd8de09e0  ! 208: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r12
	.word 0xdc852000  ! 209: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r14
	mov	0x3c0, %r22
	.word 0x87802073  ! 211: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r27
	.word 0xdc8d6000  ! 213: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 214: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r26
	mov	0x8, %r25
	.word 0xdc8f6000  ! 217: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	mov	0x7d8, %r23
	.word 0xdaf584a0  ! 219: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	.word 0xd0afce60  ! 220: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	mov	0x78, %r27
	.word 0xd0cf4e80  ! 222: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r8
	mov	0x10, %r18
	.word 0xded72000  ! 224: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	mov	0x3d8, %r22
	.word 0x87802020  ! 226: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad5c4a0  ! 227: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r13
	.word 0x87802020  ! 228: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 229: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r18
	mov	0x48, %r18
	.word 0xd69c4400  ! 232: LDDA_R	ldda	[%r17, %r0] 0x20, %r11
	.word 0x87802072  ! 233: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r26
	mov	0x30, %r26
	.word 0xd69c6000  ! 236: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r11
	mov	0x38, %r16
	.word 0xd48689e0  ! 238: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r10
	.word 0xd0f4e000  ! 239: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xd4bfce40  ! 240: STDA_R	stda	%r10, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 241: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bf6000  ! 242: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd2f40400  ! 243: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xd29c0400  ! 244: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	mov	0x0, %r25
	.word 0x87802020  ! 246: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 247: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd89d44a0  ! 248: LDDA_R	ldda	[%r21, %r0] 0x25, %r12
	.word 0xd4a46000  ! 249: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xd49584a0  ! 250: LDUHA_R	lduha	[%r22, %r0] 0x25, %r10
	.word 0x87802072  ! 251: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2bd84a0  ! 252: STDA_R	stda	%r9, [%r22 + %r0] 0x25
	.word 0x87802074  ! 253: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeac8400  ! 254: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xdcb70e40  ! 255: STHA_R	stha	%r14, [%r28 + %r0] 0x72
	mov	0x10, %r16
	.word 0x87802020  ! 257: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 258: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda874e40  ! 259: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r13
	mov	0x20, %r17
	.word 0xded7a000  ! 261: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xdedfe000  ! 262: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xd4ce49e0  ! 263: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r10
	.word 0xd4f72000  ! 264: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4bfe000  ! 265: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd4dfa000  ! 266: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd68fce80  ! 267: LDUBA_R	lduba	[%r31, %r0] 0x74, %r11
	.word 0x87802025  ! 268: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r26
	.word 0xd486c9e0  ! 270: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r10
	.word 0xded7a000  ! 271: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0x87802074  ! 272: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r19
	.word 0x87802072  ! 274: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0bf4e40  ! 275: STDA_R	stda	%r8, [%r29 + %r0] 0x72
	mov	0x70, %r26
	.word 0xde8d84a0  ! 277: LDUBA_R	lduba	[%r22, %r0] 0x25, %r15
	.word 0xd6bcc400  ! 278: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	mov	0x38, %r19
	.word 0xd0b74e40  ! 280: STHA_R	stha	%r8, [%r29 + %r0] 0x72
	.word 0x87802072  ! 281: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 282: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacf4e80  ! 283: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r13
	.word 0x87802072  ! 284: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8df2000  ! 285: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	mov	0x8, %r19
	.word 0xdabc4400  ! 287: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0x87802073  ! 288: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0bd44a0  ! 289: STDA_R	stda	%r8, [%r21 + %r0] 0x25
	mov	0x7c8, %r20
	.word 0xdc8f0e60  ! 291: LDUBA_R	lduba	[%r28, %r0] 0x73, %r14
	.word 0x87802074  ! 292: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e0, %r21
	.word 0xdec46000  ! 294: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xde9c6000  ! 296: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0x87802074  ! 297: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef7ce60  ! 298: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0xd0bda000  ! 299: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	.word 0xd0852000  ! 300: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r8
	mov	0x60, %r17
	.word 0xd6adc4a0  ! 302: STBA_R	stba	%r11, [%r23 + %r0] 0x25
	mov	0x10, %r27
	mov	0x7f0, %r21
	.word 0xd4b78e60  ! 305: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	.word 0x87802020  ! 306: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd89fe000  ! 307: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	mov	0x20, %r19
	.word 0xd8b7e000  ! 309: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0xd8cf4e60  ! 310: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r12
	.word 0xd2948400  ! 311: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	mov	0x18, %r26
	mov	0x40, %r27
	.word 0x87802073  ! 314: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f4e000  ! 315: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xdcf7ce60  ! 316: STXA_R	stxa	%r14, [%r31 + %r0] 0x73
	mov	0x7c8, %r22
	.word 0xdcc70e40  ! 318: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r14
	.word 0xdcf74e40  ! 319: STXA_R	stxa	%r14, [%r29 + %r0] 0x72
	.word 0xdca44400  ! 320: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0xdadfce80  ! 321: LDXA_R	ldxa	[%r31, %r0] 0x74, %r13
	.word 0xd0cf0e80  ! 322: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r8
	.word 0xdcdca000  ! 323: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xd88e49e0  ! 324: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r12
	.word 0xd6bc0400  ! 325: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	mov	0x7c0, %r22
	.word 0xd48c2000  ! 327: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r10
	.word 0xdebf8e40  ! 328: STDA_R	stda	%r15, [%r30 + %r0] 0x72
	mov	0x30, %r16
	mov	0x8, %r17
	.word 0xdcf46000  ! 331: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xd2ae09e0  ! 332: STBA_R	stba	%r9, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 333: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedc4400  ! 334: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	.word 0xdadca000  ! 335: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0xd2b544a0  ! 336: STHA_R	stha	%r9, [%r21 + %r0] 0x25
	.word 0xdaf4e000  ! 337: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xdab4e000  ! 338: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xdc8f4e40  ! 339: LDUBA_R	lduba	[%r29, %r0] 0x72, %r14
	.word 0x87802020  ! 340: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4dea000  ! 341: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	.word 0xd4ce6000  ! 342: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r10
	.word 0xd4cea000  ! 343: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r10
	.word 0xd0a74e40  ! 344: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	.word 0xdc866000  ! 345: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r14
	.word 0xd2b544a0  ! 346: STHA_R	stha	%r9, [%r21 + %r0] 0x25
	.word 0xdc8fce40  ! 347: LDUBA_R	lduba	[%r31, %r0] 0x72, %r14
	.word 0xdcdea000  ! 348: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r14
	.word 0xdcdee000  ! 349: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r14
	.word 0xdcf66000  ! 350: STXA_I	stxa	%r14, [%r25 + 0x0000] %asi
	.word 0xdeb74e40  ! 351: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	mov	0x3f8, %r23
	.word 0xd8aee000  ! 353: STBA_I	stba	%r12, [%r27 + 0x0000] %asi
	.word 0xd8dee000  ! 354: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r12
	mov	0x40, %r26
	mov	0x0, %r27
	.word 0xd2c74e60  ! 357: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r9
	.word 0x8780204f  ! 358: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdec70e60  ! 359: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r15
	.word 0x87802020  ! 360: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8cf0e60  ! 361: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r12
	.word 0xda9c6000  ! 362: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r13
	.word 0x87802020  ! 363: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d6c9e0  ! 364: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r10
	.word 0x87802074  ! 365: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6dec9e0  ! 366: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r11
	mov	0x78, %r27
	.word 0xdeb48400  ! 368: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xd6d7e000  ! 369: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	mov	0x38, %r24
	mov	0x78, %r25
	.word 0x87802074  ! 372: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e0, %r22
	.word 0x8780204f  ! 374: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdef44400  ! 375: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0x87802072  ! 376: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 377: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 378: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cf2000  ! 379: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0x87802025  ! 380: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r17
	.word 0xdaacc400  ! 382: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0xdedfe000  ! 383: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	mov	0x3f0, %r21
	.word 0xdcb40400  ! 385: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0x87802074  ! 386: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r24
	.word 0xd8f7a000  ! 388: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd897a000  ! 389: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	mov	0x20, %r26
	mov	0x58, %r24
	.word 0xd49584a0  ! 392: LDUHA_R	lduha	[%r22, %r0] 0x25, %r10
	mov	0x70, %r25
	mov	0x78, %r17
	.word 0xd897ce80  ! 395: LDUHA_R	lduha	[%r31, %r0] 0x74, %r12
	.word 0xd4872000  ! 396: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0xd2c7ce80  ! 397: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r9
	mov	0x30, %r19
	mov	0x48, %r27
	.word 0xd8d72000  ! 400: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xd8872000  ! 401: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	.word 0x87802020  ! 402: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 403: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r25
	.word 0x8780204f  ! 405: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6c78e60  ! 406: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r11
	.word 0xde8fa000  ! 407: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0xded649e0  ! 408: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r15
	.word 0xd897a000  ! 409: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0xd29c4400  ! 410: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	.word 0x87802020  ! 411: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r16
	.word 0xd4d504a0  ! 413: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r10
	mov	0x70, %r17
	mov	0x20, %r17
	.word 0x87802025  ! 416: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcc689e0  ! 417: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r14
	mov	0x3e8, %r21
	.word 0xd4afe000  ! 419: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd4b7a000  ! 420: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd4dec9e0  ! 421: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r10
	mov	0x70, %r27
	.word 0xd2d7a000  ! 423: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0xd8870e80  ! 424: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r12
	.word 0x87802072  ! 425: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cfe000  ! 426: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0xd4bf6000  ! 427: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd4a72000  ! 428: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd68c8400  ! 429: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	.word 0xd6df0e80  ! 430: LDXA_R	ldxa	[%r28, %r0] 0x74, %r11
	.word 0xd4a74e60  ! 431: STWA_R	stwa	%r10, [%r29 + %r0] 0x73
	.word 0xdeb7e000  ! 432: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xde8fa000  ! 433: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0xdedfe000  ! 434: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xd6cf8e40  ! 435: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r11
	.word 0xdef7e000  ! 436: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xded7e000  ! 437: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0x87802025  ! 438: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2970e80  ! 439: LDUHA_R	lduha	[%r28, %r0] 0x74, %r9
	mov	0x7f8, %r22
	.word 0xd2d44400  ! 441: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r9
	.word 0x87802020  ! 442: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r19
	.word 0xdebd6000  ! 444: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	mov	0x20, %r18
	.word 0xdedf4e80  ! 446: LDXA_R	ldxa	[%r29, %r0] 0x74, %r15
	.word 0xd2970e40  ! 447: LDUHA_R	lduha	[%r28, %r0] 0x72, %r9
	.word 0xd8b70e40  ! 448: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0x87802025  ! 449: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c0, %r23
	mov	0x7d8, %r23
	.word 0xdcb76000  ! 452: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xdcd78e80  ! 453: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r14
	.word 0xd6f7a000  ! 454: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6f76000  ! 455: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd69f6000  ! 456: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	mov	0x3f8, %r21
	mov	0x20, %r17
	.word 0xd2bf0e80  ! 459: STDA_R	stda	%r9, [%r28 + %r0] 0x74
	.word 0xdcf70e40  ! 460: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	.word 0xd4bfa000  ! 461: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	mov	0x48, %r18
	mov	0x3c8, %r23
	.word 0xd49f2000  ! 464: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd487e000  ! 465: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd2a40400  ! 466: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xdaa76000  ! 467: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xdadfe000  ! 468: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0xdaac8400  ! 469: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	mov	0x70, %r18
	.word 0xdad7e000  ! 471: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xd8f4c400  ! 472: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xdef48400  ! 473: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xdcf7e000  ! 474: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xd28c8400  ! 475: LDUBA_R	lduba	[%r18, %r0] 0x20, %r9
	.word 0xd8a7a000  ! 476: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 477: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r22
	mov	0x7e0, %r22
	.word 0xdcf44400  ! 480: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xdaa6e000  ! 481: STWA_I	stwa	%r13, [%r27 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xdaa66000  ! 483: STWA_I	stwa	%r13, [%r25 + 0x0000] %asi
	mov	0x38, %r18
	mov	0x28, %r24
	mov	0x3d0, %r21
	.word 0xda9ee000  ! 487: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r13
	mov	0x7e0, %r22
	mov	0x3e0, %r20
	.word 0xdaa66000  ! 490: STWA_I	stwa	%r13, [%r25 + 0x0000] %asi
	.word 0xdaf6a000  ! 491: STXA_I	stxa	%r13, [%r26 + 0x0000] %asi
	.word 0xdaa6e000  ! 492: STWA_I	stwa	%r13, [%r27 + 0x0000] %asi
	.word 0xdacea000  ! 493: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r13
	.word 0xda8e6000  ! 494: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 495: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r25
	.word 0xd8d78e40  ! 497: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r12
	mov	0x38, %r19
	.word 0xd8dd2000  ! 499: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r12
	mov	0x3c0, %r21
	.word 0xd4970e80  ! 501: LDUHA_R	lduha	[%r28, %r0] 0x74, %r10
	mov	0x58, %r26
	mov	0x50, %r19
	.word 0xd694c400  ! 504: LDUHA_R	lduha	[%r19, %r0] 0x20, %r11
	.word 0xd4a7ce80  ! 505: STWA_R	stwa	%r10, [%r31 + %r0] 0x74
	.word 0xdaf44400  ! 506: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0x87802072  ! 507: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8ac0400  ! 508: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xd6afe000  ! 509: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x50, %r19
	mov	0x7f8, %r23
	.word 0xd68fe000  ! 512: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xdaacc400  ! 513: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	.word 0xd287a000  ! 514: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0xd896c9e0  ! 515: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r12
	.word 0xd2c78e40  ! 516: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r9
	.word 0xdef40400  ! 517: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	mov	0x38, %r19
	.word 0xd4c7e000  ! 519: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	mov	0x20, %r19
	mov	0x3e8, %r23
	.word 0xd4c76000  ! 522: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	.word 0xdcc74e60  ! 523: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r14
	.word 0x8780204f  ! 524: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2dc6000  ! 525: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r9
	.word 0xd2bc6000  ! 526: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0xd6b7ce80  ! 527: STHA_R	stha	%r11, [%r31 + %r0] 0x74
	.word 0xde97ce40  ! 528: LDUHA_R	lduha	[%r31, %r0] 0x72, %r15
	.word 0xdcd42000  ! 529: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	mov	0x7d8, %r21
	.word 0x87802072  ! 531: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc87ce80  ! 532: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r14
	mov	0x68, %r16
	mov	0x3d0, %r21
	.word 0xdc876000  ! 535: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0xdc8fa000  ! 536: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdaf74e60  ! 537: STXA_R	stxa	%r13, [%r29 + %r0] 0x73
	.word 0xde8f6000  ! 538: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdea7a000  ! 540: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	mov	0x30, %r16
	mov	0x7f0, %r21
	.word 0xdeb76000  ! 543: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xde9f6000  ! 545: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0xdef78e80  ! 546: STXA_R	stxa	%r15, [%r30 + %r0] 0x74
	.word 0xda8f2000  ! 547: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	mov	0x0, %r16
	mov	0x70, %r17
	.word 0xd8ae89e0  ! 550: STBA_R	stba	%r12, [%r26 + %r0] 0x4f
	mov	0x40, %r25
	.word 0x87802072  ! 552: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebf6000  ! 553: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	mov	0x38, %r24
	.word 0x87802020  ! 555: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeccc400  ! 556: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r15
	.word 0x87802020  ! 557: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 558: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4af4e60  ! 559: STBA_R	stba	%r10, [%r29 + %r0] 0x73
	.word 0xd8a689e0  ! 560: STWA_R	stwa	%r12, [%r26 + %r0] 0x4f
	.word 0xdabe6000  ! 561: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	.word 0xd8bc8400  ! 562: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xd68f0e60  ! 563: LDUBA_R	lduba	[%r28, %r0] 0x73, %r11
	.word 0xd0f74e40  ! 564: STXA_R	stxa	%r8, [%r29 + %r0] 0x72
	.word 0xd2be2000  ! 565: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	mov	0x8, %r26
	.word 0xd0b7ce60  ! 567: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	.word 0xd8bea000  ! 568: STDA_I	stda	%r12, [%r26 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0x87802020  ! 570: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29d04a0  ! 571: LDDA_R	ldda	[%r20, %r0] 0x25, %r9
	.word 0xd2d42000  ! 572: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2ac2000  ! 573: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd2a4a000  ! 574: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	.word 0xdeb4c400  ! 575: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xd6bc8400  ! 576: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	mov	0x7f0, %r23
	.word 0x87802074  ! 578: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd097ce40  ! 579: LDUHA_R	lduha	[%r31, %r0] 0x72, %r8
	.word 0xd0f7e000  ! 580: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0dfe000  ! 581: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0x87802074  ! 582: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r27
	.word 0xd0a5a000  ! 584: STWA_I	stwa	%r8, [%r22 + 0x0000] %asi
	.word 0xd4f6c9e0  ! 585: STXA_R	stxa	%r10, [%r27 + %r0] 0x4f
	.word 0xd4bc0400  ! 586: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xd0ac8400  ! 587: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xd0a5a000  ! 588: STWA_I	stwa	%r8, [%r22 + 0x0000] %asi
	.word 0xd2d70e60  ! 589: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r9
	mov	0x58, %r19
	.word 0xde9de000  ! 591: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r15
	.word 0xdef5a000  ! 592: STXA_I	stxa	%r15, [%r22 + 0x0000] %asi
	.word 0xdeb56000  ! 593: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	.word 0xde95a000  ! 594: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r15
	.word 0xded52000  ! 595: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r15
	.word 0xdc9f8e80  ! 596: LDDA_R	ldda	[%r30, %r0] 0x74, %r14
	.word 0xdcdd6000  ! 597: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r14
	.word 0xdc9da000  ! 598: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r14
	.word 0xdea7ce60  ! 599: STWA_R	stwa	%r15, [%r31 + %r0] 0x73
	.word 0x87802020  ! 600: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r19
	.word 0xd2c40400  ! 602: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r9
	mov	0x48, %r18
	.word 0xdaf76000  ! 604: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	mov	0x68, %r17
	.word 0xdaa7a000  ! 606: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xdaf7e000  ! 607: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xdab7e000  ! 608: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	mov	0x78, %r24
	.word 0xda8f2000  ! 610: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	mov	0x60, %r16
	mov	0x3e0, %r23
	mov	0x48, %r25
	.word 0xd0a70e60  ! 614: STWA_R	stwa	%r8, [%r28 + %r0] 0x73
	.word 0xd2d504a0  ! 615: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r9
	ta	T_CHANGE_PRIV	! macro
	.word 0xd4840400  ! 617: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	.word 0xd2af2000  ! 618: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 619: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dd2000  ! 620: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r9
	.word 0xd2a5e000  ! 621: STWA_I	stwa	%r9, [%r23 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0xd2f5e000  ! 623: STXA_I	stxa	%r9, [%r23 + 0x0000] %asi
	.word 0xd2a5e000  ! 624: STWA_I	stwa	%r9, [%r23 + 0x0000] %asi
	mov	0x50, %r18
	.word 0xdc944400  ! 626: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	.word 0xd88dc4a0  ! 627: LDUBA_R	lduba	[%r23, %r0] 0x25, %r12
	.word 0xd885a000  ! 628: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r12
	.word 0xd8a5e000  ! 629: STWA_I	stwa	%r12, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 630: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 631: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r25
	.word 0xd8dce000  ! 633: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	.word 0xd4974e40  ! 634: LDUHA_R	lduha	[%r29, %r0] 0x72, %r10
	.word 0xd09cc400  ! 635: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	mov	0x28, %r24
	.word 0xd897ce80  ! 637: LDUHA_R	lduha	[%r31, %r0] 0x74, %r12
	.word 0xdcac4400  ! 638: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	.word 0xdac70e80  ! 639: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r13
	.word 0xdeac6000  ! 640: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	mov	0x3d0, %r23
	mov	0x3e0, %r21
	.word 0xde94a000  ! 643: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0xded42000  ! 644: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	mov	0x58, %r17
	mov	0x40, %r26
	mov	0x7e0, %r23
	.word 0x87802020  ! 648: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8874e80  ! 649: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r12
	.word 0xd4f6e000  ! 650: STXA_I	stxa	%r10, [%r27 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd4b6a000  ! 652: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 653: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf78e80  ! 654: STXA_R	stxa	%r14, [%r30 + %r0] 0x74
	.word 0xda8c6000  ! 655: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r13
	.word 0xda846000  ! 656: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r13
	.word 0x87802072  ! 657: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd28c0400  ! 658: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	.word 0x87802020  ! 659: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cfe000  ! 660: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0xd8bc4400  ! 661: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xd0a72000  ! 662: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x7c0, %r22
	mov	0x48, %r26
	.word 0xdaf40400  ! 665: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xd6afa000  ! 666: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd2d609e0  ! 667: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r9
	.word 0xd08f6000  ! 668: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r8
	.word 0xded7ce80  ! 669: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r15
	mov	0x18, %r25
	.word 0xd6a76000  ! 671: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	mov	0x18, %r16
	.word 0xd8bdc4a0  ! 673: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	.word 0xdcdfe000  ! 674: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	mov	0x18, %r18
	.word 0xd09e09e0  ! 676: LDDA_R	ldda	[%r24, %r0] 0x4f, %r8
	.word 0xd4a74e80  ! 677: STWA_R	stwa	%r10, [%r29 + %r0] 0x74
	.word 0xd0978e80  ! 678: LDUHA_R	lduha	[%r30, %r0] 0x74, %r8
	.word 0xd29f2000  ! 679: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd2df2000  ! 680: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 681: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa78e80  ! 682: STWA_R	stwa	%r13, [%r30 + %r0] 0x74
	mov	0x38, %r25
	.word 0xd6af8e60  ! 684: STBA_R	stba	%r11, [%r30 + %r0] 0x73
	.word 0xd88609e0  ! 685: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r12
	.word 0xd8b7ce40  ! 686: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 687: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r21
	.word 0xd0cf6000  ! 689: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd0cf6000  ! 690: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd097a000  ! 691: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	.word 0xd0d72000  ! 692: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xd6f44400  ! 693: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0xd4bfa000  ! 694: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd2b7ce40  ! 695: STHA_R	stha	%r9, [%r31 + %r0] 0x72
	.word 0xd4df6000  ! 696: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	mov	0x58, %r24
	.word 0xd8944400  ! 698: LDUHA_R	lduha	[%r17, %r0] 0x20, %r12
	mov	0x10, %r26
	mov	0x40, %r26
	.word 0xd2bf2000  ! 701: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xdacf0e60  ! 702: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r13
	.word 0xd8d76000  ! 703: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	mov	0x3e0, %r23
	.word 0x8780204f  ! 705: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8962000  ! 706: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r12
	mov	0x68, %r17
	.word 0xd4dc0400  ! 708: LDXA_R	ldxa	[%r16, %r0] 0x20, %r10
	.word 0xd4be6000  ! 709: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0xd48ea000  ! 710: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r10
	.word 0x87802020  ! 711: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r23
	mov	0x28, %r25
	.word 0x8780204f  ! 714: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bde000  ! 715: STDA_I	stda	%r10, [%r23 + 0x0000] %asi
	mov	0x38, %r16
	.word 0xd4b56000  ! 717: STHA_I	stha	%r10, [%r21 + 0x0000] %asi
	mov	0x68, %r26
	.word 0xd49da000  ! 719: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r10
	.word 0xd48de000  ! 720: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r10
	.word 0xd4dde000  ! 721: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r10
	.word 0xdcbfce40  ! 722: STDA_R	stda	%r14, [%r31 + %r0] 0x72
	.word 0xd0dd2000  ! 723: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0xd8ad44a0  ! 724: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	.word 0xdccfce40  ! 725: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r14
	.word 0xd8c5e000  ! 726: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r12
	.word 0x87802073  ! 727: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 728: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c78e80  ! 729: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r10
	mov	0x78, %r16
	.word 0xd6af6000  ! 731: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd08584a0  ! 732: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r8
	.word 0xd0cf0e40  ! 733: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r8
	.word 0x87802025  ! 734: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d0, %r21
	.word 0x87802025  ! 736: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2cea000  ! 737: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r9
	.word 0xd28f8e80  ! 738: LDUBA_R	lduba	[%r30, %r0] 0x74, %r9
	.word 0xd6f62000  ! 739: STXA_I	stxa	%r11, [%r24 + 0x0000] %asi
	.word 0xdcb48400  ! 740: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xd096e000  ! 741: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r8
	.word 0xd08e6000  ! 742: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r8
	mov	0x20, %r24
	mov	0x40, %r25
	mov	0x18, %r25
	mov	0x18, %r18
	.word 0xdab7ce60  ! 747: STHA_R	stha	%r13, [%r31 + %r0] 0x73
	.word 0xdec62000  ! 748: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r15
	mov	0x3d0, %r21
	mov	0x78, %r17
	.word 0xdeb6a000  ! 751: STHA_I	stha	%r15, [%r26 + 0x0000] %asi
	mov	0x28, %r24
	.word 0xd2af4e80  ! 753: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	.word 0xd6cfce60  ! 754: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r11
	.word 0xd4be2000  ! 755: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 756: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f6a000  ! 757: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	.word 0x87802025  ! 758: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f8, %r20
	mov	0x60, %r17
	.word 0xdebe09e0  ! 761: STDA_R	stda	%r15, [%r24 + %r0] 0x4f
	.word 0xd6bd6000  ! 762: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	mov	0x50, %r18
	.word 0xd8b70e40  ! 764: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0xdc8c4400  ! 765: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	mov	0x70, %r24
	mov	0x38, %r18
	.word 0xdcdd2000  ! 768: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r14
	mov	0x40, %r18
	.word 0xdcad2000  ! 770: STBA_I	stba	%r14, [%r20 + 0x0000] %asi
	.word 0xd4f48400  ! 771: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xd2944400  ! 772: LDUHA_R	lduha	[%r17, %r0] 0x20, %r9
	.word 0xd4840400  ! 773: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	.word 0xdcb78e40  ! 774: STHA_R	stha	%r14, [%r30 + %r0] 0x72
	.word 0xd49689e0  ! 775: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r10
	mov	0x70, %r24
	mov	0x38, %r26
	.word 0xdec5e000  ! 778: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r15
	.word 0xdef5a000  ! 779: STXA_I	stxa	%r15, [%r22 + 0x0000] %asi
	.word 0xdea52000  ! 780: STWA_I	stwa	%r15, [%r20 + 0x0000] %asi
	.word 0x87802072  ! 781: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdccdc4a0  ! 782: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r14
	.word 0xda9689e0  ! 783: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r13
	.word 0x87802072  ! 784: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f0, %r21
	.word 0xda9ce000  ! 786: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r13
	.word 0xdab46000  ! 787: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xdcaf0e40  ! 789: STBA_R	stba	%r14, [%r28 + %r0] 0x72
	mov	0x60, %r18
	.word 0xdadca000  ! 791: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0xdaa4c400  ! 792: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0xd68f0e40  ! 793: LDUBA_R	lduba	[%r28, %r0] 0x72, %r11
	.word 0x87802074  ! 794: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd687ce80  ! 795: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r11
	.word 0xd4a4a000  ! 796: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xd4c4a000  ! 797: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	.word 0xd0d70e80  ! 798: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r8
	.word 0xd0c42000  ! 799: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r8
	.word 0xd0dc2000  ! 800: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	.word 0xdc9c4400  ! 801: LDDA_R	ldda	[%r17, %r0] 0x20, %r14
	.word 0xd4b4e000  ! 802: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 803: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 804: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r24
	.word 0xd4bf6000  ! 806: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	mov	0x7f0, %r21
	.word 0xd29cc400  ! 808: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	.word 0xd28c8400  ! 809: LDUBA_R	lduba	[%r18, %r0] 0x20, %r9
	.word 0x87802073  ! 810: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8c7e000  ! 811: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0xdaa44400  ! 812: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0xd4d7ce40  ! 813: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r10
	.word 0xdeafe000  ! 814: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xdebf6000  ! 815: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xde97e000  ! 816: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0x87802020  ! 817: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bfce40  ! 818: STDA_R	stda	%r8, [%r31 + %r0] 0x72
	.word 0xd2afe000  ! 819: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd2df6000  ! 820: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2b7e000  ! 821: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	mov	0x3c8, %r21
	mov	0x68, %r16
	.word 0xd2f7a000  ! 824: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	mov	0x7f0, %r22
	.word 0x87802072  ! 826: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb544a0  ! 827: STHA_R	stha	%r14, [%r21 + %r0] 0x25
	mov	0x7d0, %r22
	.word 0xda9c4400  ! 829: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	.word 0xdcf7e000  ! 830: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	mov	0x40, %r24
	.word 0xdc8fce40  ! 832: LDUBA_R	lduba	[%r31, %r0] 0x72, %r14
	.word 0x8780204f  ! 833: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 834: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 835: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcaf2000  ! 836: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xd28609e0  ! 837: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r9
	.word 0xdcf7a000  ! 838: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	mov	0x18, %r19
	.word 0xdcdf2000  ! 840: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdca76000  ! 841: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdc87a000  ! 842: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xd89649e0  ! 843: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r12
	.word 0x87802025  ! 844: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r17
	.word 0x87802020  ! 846: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb48400  ! 847: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xdaa4e000  ! 848: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	mov	0x7f8, %r23
	.word 0x8780204f  ! 850: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 851: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r26
	.word 0x87802025  ! 853: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaa72000  ! 854: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xdacf2000  ! 855: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	mov	0x7f0, %r23
	.word 0xd896c9e0  ! 857: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r12
	.word 0xde8e09e0  ! 858: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r15
	.word 0xde940400  ! 859: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0xd8cf2000  ! 860: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	mov	0x40, %r25
	mov	0x28, %r19
	.word 0xd8cfe000  ! 863: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	mov	0x30, %r16
	mov	0x28, %r27
	.word 0x87802072  ! 866: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 867: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb74e80  ! 868: STHA_R	stha	%r14, [%r29 + %r0] 0x74
	.word 0xdeb56000  ! 869: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	mov	0x0, %r19
	.word 0x87802072  ! 871: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 872: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdedee000  ! 873: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r15
	.word 0xd0c6c9e0  ! 874: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r8
	.word 0xded70e80  ! 875: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r15
	.word 0x8780204f  ! 876: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6df4e60  ! 877: LDXA_R	ldxa	[%r29, %r0] 0x73, %r11
	.word 0xd6b72000  ! 878: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd2d48400  ! 879: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	.word 0xd6bfe000  ! 880: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0xd6a76000  ! 882: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 883: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 884: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6afa000  ! 885: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xde9c4400  ! 886: LDDA_R	ldda	[%r17, %r0] 0x20, %r15
	.word 0xd4dfe000  ! 887: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	mov	0x18, %r24
	.word 0xd4b7a000  ! 889: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd8d5c4a0  ! 890: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r12
	mov	0x60, %r17
	.word 0x87802020  ! 892: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 893: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2840400  ! 894: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r9
	mov	0x7c8, %r23
	mov	0x58, %r27
	.word 0x87802072  ! 897: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbc4400  ! 898: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0x87802072  ! 899: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca4a000  ! 900: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0xdc94e000  ! 901: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	.word 0x87802073  ! 902: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca6e000  ! 903: STWA_I	stwa	%r14, [%r27 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0xdcdee000  ! 905: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r14
	mov	0x28, %r27
	.word 0xdcbee000  ! 907: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	mov	0x7f0, %r22
	mov	0x3e8, %r21
	.word 0xdc962000  ! 910: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r14
	.word 0xdef74e80  ! 911: STXA_R	stxa	%r15, [%r29 + %r0] 0x74
	mov	0x3c8, %r22
	.word 0x87802073  ! 913: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0bc2000  ! 914: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 915: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bc0400  ! 916: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xd2b5e000  ! 917: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	.word 0xd2b52000  ! 918: STHA_I	stha	%r9, [%r20 + 0x0000] %asi
	.word 0xd2dd2000  ! 919: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r9
	.word 0xdc8f4e40  ! 920: LDUBA_R	lduba	[%r29, %r0] 0x72, %r14
	.word 0xda852000  ! 921: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r13
	.word 0xd4b7ce60  ! 922: STHA_R	stha	%r10, [%r31 + %r0] 0x73
	.word 0xd6afce80  ! 923: STBA_R	stba	%r11, [%r31 + %r0] 0x74
	.word 0x87802072  ! 924: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa6c9e0  ! 925: STWA_R	stwa	%r13, [%r27 + %r0] 0x4f
	mov	0x3f0, %r20
	mov	0x40, %r26
	mov	0x40, %r17
	.word 0xd4dea000  ! 929: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	mov	0x3c8, %r23
	.word 0xd4b62000  ! 931: STHA_I	stha	%r10, [%r24 + 0x0000] %asi
	mov	0x48, %r16
	.word 0xd4c66000  ! 933: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r10
	.word 0xd2974e40  ! 934: LDUHA_R	lduha	[%r29, %r0] 0x72, %r9
	.word 0x87802074  ! 935: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0c74e80  ! 936: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r8
	.word 0x87802020  ! 937: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8874e80  ! 938: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r12
	.word 0xdcdcc400  ! 939: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	mov	0x68, %r24
	mov	0x3f8, %r21
	mov	0x78, %r27
	mov	0x7f8, %r20
	.word 0xd6c7e000  ! 944: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xd687a000  ! 945: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6dfa000  ! 946: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0xd0c4c400  ! 947: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	mov	0x0, %r19
	mov	0x18, %r24
	ta	T_CHANGE_PRIV	! macro
	mov	0x40, %r19
	.word 0xd4cf6000  ! 952: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	mov	0x40, %r26
	.word 0x87802073  ! 954: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b40400  ! 955: STHA_R	stha	%r9, [%r16 + %r0] 0x20
	.word 0x87802072  ! 956: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2d70e80  ! 957: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r9
	mov	0x68, %r24
	.word 0xd4be6000  ! 959: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdcdc8400  ! 961: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	.word 0xd0be2000  ! 962: STDA_I	stda	%r8, [%r24 + 0x0000] %asi
	.word 0xdef44400  ! 963: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xd4bf0e80  ! 964: STDA_R	stda	%r10, [%r28 + %r0] 0x74
	mov	0x0, %r25
	.word 0x87802074  ! 966: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdec4e000  ! 967: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	mov	0x50, %r25
	mov	0x28, %r18
	.word 0xde9ce000  ! 970: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r15
	.word 0x87802072  ! 971: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde9d2000  ! 972: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r15
	.word 0xdad649e0  ! 973: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r13
	.word 0xdacf0e40  ! 974: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r13
	.word 0xd6f48400  ! 975: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xdcd5a000  ! 976: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r14
	.word 0xd2a5c4a0  ! 977: STWA_R	stwa	%r9, [%r23 + %r0] 0x25
	.word 0xdea44400  ! 978: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xdcbd2000  ! 979: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	.word 0xdccde000  ! 980: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r14
	.word 0xd8d44400  ! 981: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	.word 0xd295a000  ! 982: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r9
	.word 0xdab4c400  ! 983: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xdad6c9e0  ! 984: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r13
	.word 0xd2f5e000  ! 985: STXA_I	stxa	%r9, [%r23 + 0x0000] %asi
	.word 0xd6c78e60  ! 986: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r11
	mov	0x10, %r27
	.word 0xdcf56000  ! 988: STXA_I	stxa	%r14, [%r21 + 0x0000] %asi
	.word 0xd2cf0e60  ! 989: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r9
	.word 0xdcf78e40  ! 990: STXA_R	stxa	%r14, [%r30 + %r0] 0x72
	.word 0xda8de000  ! 991: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 992: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r25
	.word 0xdaafa000  ! 994: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 995: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdab52000  ! 996: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	.word 0xd4af8e80  ! 997: STBA_R	stba	%r10, [%r30 + %r0] 0x74
	.word 0xd8878e60  ! 998: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r12
	.word 0xd4bda000  ! 999: STDA_I	stda	%r10, [%r22 + 0x0000] %asi
	.word 0xdcbf4e80  ! 1000: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	mov	0x70, %r16
	.word 0x8780204f  ! 1002: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d0, %r20
	.word 0xd2d4c400  ! 1004: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r9
	.word 0xd6dc4400  ! 1005: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xd4a78e80  ! 1006: STWA_R	stwa	%r10, [%r30 + %r0] 0x74
	.word 0xdcb76000  ! 1007: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1008: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r18
	.word 0xdcf5e000  ! 1010: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0xd2f6c9e0  ! 1011: STXA_R	stxa	%r9, [%r27 + %r0] 0x4f
	.word 0xd6d52000  ! 1012: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r11
	.word 0xdca504a0  ! 1013: STWA_R	stwa	%r14, [%r20 + %r0] 0x25
	.word 0xdcdd2000  ! 1014: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r14
	.word 0xdcb52000  ! 1015: STHA_I	stha	%r14, [%r20 + 0x0000] %asi
	.word 0xdcade000  ! 1016: STBA_I	stba	%r14, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 1017: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r24
	.word 0xdcbf6000  ! 1019: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdc87e000  ! 1020: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcdfe000  ! 1021: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	mov	0x8, %r26
	.word 0xdcbf2000  ! 1023: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0xda8e49e0  ! 1025: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r13
	.word 0xdeb7ce40  ! 1026: STHA_R	stha	%r15, [%r31 + %r0] 0x72
	.word 0xdccf8e40  ! 1027: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r14
	mov	0x30, %r18
	.word 0x87802072  ! 1029: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 1030: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r18
	.word 0xd8ad04a0  ! 1032: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	mov	0x78, %r18
	mov	0x68, %r19
	mov	0x40, %r27
	.word 0xdebc4400  ! 1036: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0xda844400  ! 1037: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r13
	mov	0x28, %r18
	mov	0x58, %r18
	.word 0xdcdd6000  ! 1040: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r14
	.word 0x87802020  ! 1041: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f70e60  ! 1042: STXA_R	stxa	%r10, [%r28 + %r0] 0x73
	.word 0xde9689e0  ! 1043: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r15
	.word 0x87802020  ! 1044: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf7e000  ! 1045: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdc8f2000  ! 1046: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0xdeb5c4a0  ! 1047: STHA_R	stha	%r15, [%r23 + %r0] 0x25
	.word 0x87802020  ! 1048: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a4a000  ! 1049: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8846000  ! 1050: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	.word 0xd8842000  ! 1051: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	.word 0xd8f4a000  ! 1052: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xdad689e0  ! 1053: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r13
	.word 0xdacf0e40  ! 1054: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r13
	.word 0x87802073  ! 1055: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b6e000  ! 1056: STHA_I	stha	%r10, [%r27 + 0x0000] %asi
	.word 0xd4ae6000  ! 1057: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0xd4b66000  ! 1058: STHA_I	stha	%r10, [%r25 + 0x0000] %asi
	.word 0xd4ce6000  ! 1059: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r10
	.word 0xd8b44400  ! 1060: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0xd4df8e60  ! 1061: LDXA_R	ldxa	[%r30, %r0] 0x73, %r10
	.word 0x87802025  ! 1062: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cc6000  ! 1063: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	.word 0x87802073  ! 1064: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6df4e80  ! 1065: LDXA_R	ldxa	[%r29, %r0] 0x74, %r11
	mov	0x28, %r19
	.word 0xdad46000  ! 1067: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	.word 0xd6a78e40  ! 1068: STWA_R	stwa	%r11, [%r30 + %r0] 0x72
	.word 0xd49c2000  ! 1069: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	.word 0x87802025  ! 1070: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8d4c400  ! 1071: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0xdadd2000  ! 1072: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r13
	mov	0x20, %r19
	.word 0x87802072  ! 1074: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdec4c400  ! 1075: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	.word 0x87802020  ! 1076: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1077: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6dfce40  ! 1078: LDXA_R	ldxa	[%r31, %r0] 0x72, %r11
	.word 0xdcbfa000  ! 1079: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	mov	0x7c8, %r23
	.word 0xdab40400  ! 1081: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xd494c400  ! 1082: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	.word 0xdccf0e60  ! 1083: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r14
	.word 0xda9d44a0  ! 1084: LDDA_R	ldda	[%r21, %r0] 0x25, %r13
	.word 0xd6bfce80  ! 1085: STDA_R	stda	%r11, [%r31 + %r0] 0x74
	.word 0xdcc76000  ! 1086: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xd8bd84a0  ! 1087: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	.word 0xdcadc4a0  ! 1088: STBA_R	stba	%r14, [%r23 + %r0] 0x25
	.word 0xdecfe000  ! 1089: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	mov	0x48, %r26
	.word 0xd4cd84a0  ! 1091: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r10
	.word 0xdeb78e40  ! 1092: STHA_R	stha	%r15, [%r30 + %r0] 0x72
	.word 0xd4bc8400  ! 1093: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	mov	0x40, %r19
	.word 0xd4dfe000  ! 1095: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802072  ! 1096: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 1097: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 1098: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda978e80  ! 1099: LDUHA_R	lduha	[%r30, %r0] 0x74, %r13
	mov	0x3c0, %r21
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6b72000  ! 1102: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 1103: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdec78e40  ! 1104: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r15
	.word 0x87802020  ! 1105: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r17
	.word 0xd8afa000  ! 1107: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 1108: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x3e0, %r21
	.word 0xd0af0e80  ! 1111: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	mov	0x0, %r19
	.word 0x87802025  ! 1113: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4bf8e60  ! 1114: STDA_R	stda	%r10, [%r30 + %r0] 0x73
	.word 0x87802025  ! 1115: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdac5c4a0  ! 1116: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r13
	.word 0xd887a000  ! 1117: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8c76000  ! 1118: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8b72000  ! 1119: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd89f2000  ! 1120: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0xd8af6000  ! 1121: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	mov	0x38, %r18
	.word 0xd8d7a000  ! 1123: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0xdcb609e0  ! 1124: STHA_R	stha	%r14, [%r24 + %r0] 0x4f
	mov	0x30, %r26
	mov	0x8, %r18
	.word 0xd8f78e40  ! 1127: STXA_R	stxa	%r12, [%r30 + %r0] 0x72
	.word 0xd0b6c9e0  ! 1128: STHA_R	stha	%r8, [%r27 + %r0] 0x4f
	.word 0xd48f2000  ! 1129: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0xd49fa000  ! 1130: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0xd4b72000  ! 1131: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	mov	0x60, %r27
	.word 0xd0b7ce60  ! 1133: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 1134: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 1135: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r17
	.word 0x87802025  ! 1137: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4872000  ! 1138: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4af2000  ! 1139: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	mov	0x38, %r17
	mov	0x3d8, %r20
	.word 0xd69689e0  ! 1142: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r11
	.word 0xdaaf0e60  ! 1143: STBA_R	stba	%r13, [%r28 + %r0] 0x73
	.word 0xdcbf0e80  ! 1144: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	.word 0xdc940400  ! 1145: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	mov	0x3d8, %r23
	.word 0xd4af0e60  ! 1147: STBA_R	stba	%r10, [%r28 + %r0] 0x73
	.word 0xdc9f2000  ! 1148: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0xdcb72000  ! 1149: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xdaf70e60  ! 1150: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	mov	0x38, %r25
	.word 0x87802073  ! 1152: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b7a000  ! 1153: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd49f6000  ! 1154: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x48, %r19
	mov	0x18, %r19
	mov	0x0, %r26
	.word 0xd49fa000  ! 1159: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 1160: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4be2000  ! 1161: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	.word 0xd4c6e000  ! 1162: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r10
	.word 0xd2878e60  ! 1163: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r9
	.word 0x87802074  ! 1164: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d0, %r22
	mov	0x48, %r18
	.word 0xd29f6000  ! 1167: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xd2a7e000  ! 1168: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xdaf48400  ! 1169: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0x87802073  ! 1170: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd88cc400  ! 1171: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	mov	0x7c0, %r21
	mov	0x68, %r18
	.word 0xd6948400  ! 1174: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	.word 0xd4c72000  ! 1175: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r10
	.word 0xd8ad44a0  ! 1176: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	.word 0x87802073  ! 1177: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r27
	.word 0xdac78e60  ! 1179: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r13
	.word 0xd6bce000  ! 1180: STDA_I	stda	%r11, [%r19 + 0x0000] %asi
	.word 0xd6bc2000  ! 1181: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0xd6b46000  ! 1182: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd694a000  ! 1183: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r11
	mov	0x58, %r17
	mov	0x70, %r18
	.word 0xd6bc2000  ! 1186: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0xd6946000  ! 1187: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r11
	.word 0xd6d4a000  ! 1188: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r11
	.word 0xd2f40400  ! 1189: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xdac4e000  ! 1190: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r13
	.word 0xdaf4e000  ! 1191: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xdabca000  ! 1192: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0xdad4a000  ! 1194: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1195: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0940400  ! 1196: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	.word 0xd8aee000  ! 1197: STBA_I	stba	%r12, [%r27 + 0x0000] %asi
	mov	0x18, %r27
	.word 0x87802074  ! 1199: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8aea000  ! 1200: STBA_I	stba	%r12, [%r26 + 0x0000] %asi
	.word 0xd2878e40  ! 1201: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r9
	.word 0xda8e6000  ! 1202: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r13
	mov	0x18, %r24
	.word 0xdccf0e80  ! 1204: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r14
	.word 0xd6be6000  ! 1205: STDA_I	stda	%r11, [%r25 + 0x0000] %asi
	.word 0xd29609e0  ! 1206: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r9
	mov	0x3e0, %r20
	.word 0xd0c6a000  ! 1208: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r8
	.word 0x87802074  ! 1209: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1210: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49dc4a0  ! 1211: LDDA_R	ldda	[%r23, %r0] 0x25, %r10
	.word 0x87802020  ! 1212: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r20
	.word 0xdecca000  ! 1214: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	.word 0xd6c48400  ! 1215: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	.word 0x87802020  ! 1216: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1217: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r19
	.word 0xdcf74e60  ! 1219: STXA_R	stxa	%r14, [%r29 + %r0] 0x73
	.word 0xdca78e80  ! 1220: STWA_R	stwa	%r14, [%r30 + %r0] 0x74
	.word 0x87802072  ! 1221: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdadf0e80  ! 1222: LDXA_R	ldxa	[%r28, %r0] 0x74, %r13
	.word 0xd0df8e60  ! 1223: LDXA_R	ldxa	[%r30, %r0] 0x73, %r8
	mov	0x20, %r26
	.word 0xdc9fa000  ! 1225: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r14
	.word 0xd2ac4400  ! 1226: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	mov	0x3e8, %r22
	.word 0xdcf7e000  ! 1228: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xd0d70e40  ! 1229: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r8
	.word 0xd2ac0400  ! 1230: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 1231: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r17
	.word 0x87802020  ! 1233: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bfe000  ! 1234: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	mov	0x10, %r27
	mov	0x0, %r18
	mov	0x48, %r16
	mov	0x7d8, %r20
	.word 0xd69f2000  ! 1239: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xd69fe000  ! 1240: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	.word 0xdadec9e0  ! 1241: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r13
	.word 0xdcdf0e80  ! 1242: LDXA_R	ldxa	[%r28, %r0] 0x74, %r14
	.word 0x87802020  ! 1243: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d4a000  ! 1244: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0x87802074  ! 1245: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e8, %r21
	.word 0xd4bc2000  ! 1247: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0x8780204f  ! 1249: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r16
	.word 0xd69dc4a0  ! 1251: LDDA_R	ldda	[%r23, %r0] 0x25, %r11
	.word 0xd4d72000  ! 1252: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	.word 0xd4af2000  ! 1253: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd08f8e60  ! 1254: LDUBA_R	lduba	[%r30, %r0] 0x73, %r8
	mov	0x3e0, %r21
	.word 0xd6b6c9e0  ! 1256: STHA_R	stha	%r11, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 1257: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b7a000  ! 1258: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xdaa5c4a0  ! 1260: STWA_R	stwa	%r13, [%r23 + %r0] 0x25
	mov	0x7c0, %r23
	mov	0x3c0, %r20
	.word 0xdccf6000  ! 1263: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcbfe000  ! 1264: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 1265: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebcc400  ! 1266: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	mov	0x3e0, %r22
	.word 0x8780204f  ! 1268: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8f74e60  ! 1269: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	mov	0x7f8, %r23
	.word 0xd4956000  ! 1271: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r10
	.word 0x87802072  ! 1272: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef7ce40  ! 1273: STXA_R	stxa	%r15, [%r31 + %r0] 0x72
	mov	0x30, %r16
	mov	0x3e8, %r20
	mov	0x0, %r16
	.word 0xd6afe000  ! 1277: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd6cf6000  ! 1278: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	mov	0x18, %r26
	.word 0xde844400  ! 1280: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	.word 0xdca7e000  ! 1281: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcacc400  ! 1282: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0xd2a40400  ! 1283: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xdabf2000  ! 1284: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xd6bf0e80  ! 1285: STDA_R	stda	%r11, [%r28 + %r0] 0x74
	mov	0x38, %r24
	mov	0x18, %r24
	.word 0x87802020  ! 1288: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r18
	mov	0x30, %r24
	.word 0xd486e000  ! 1291: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	.word 0xd4dd84a0  ! 1292: LDXA_R	ldxa	[%r22, %r0] 0x25, %r10
	.word 0xd6f6c9e0  ! 1293: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	.word 0xd0de2000  ! 1294: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r8
	.word 0xdea544a0  ! 1295: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	.word 0x87802074  ! 1296: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd49f4e40  ! 1297: LDDA_R	ldda	[%r29, %r0] 0x72, %r10
	.word 0xd8f78e60  ! 1298: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	mov	0x18, %r19
	mov	0x60, %r25
	.word 0xdeb40400  ! 1301: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0x87802073  ! 1302: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcd40400  ! 1303: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	.word 0xd287ce80  ! 1304: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r9
	.word 0xdeac6000  ! 1305: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	mov	0x3f0, %r21
	mov	0x7e8, %r20
	.word 0xdeb42000  ! 1308: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	mov	0x3e0, %r20
	.word 0xdedd04a0  ! 1310: LDXA_R	ldxa	[%r20, %r0] 0x25, %r15
	.word 0xd2f42000  ! 1311: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0xd2ac2000  ! 1312: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd2942000  ! 1313: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2c46000  ! 1314: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	mov	0x18, %r16
	.word 0xd2c4e000  ! 1316: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xd2b70e40  ! 1317: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	.word 0xd6870e40  ! 1318: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r11
	.word 0x87802072  ! 1319: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 1320: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b78e60  ! 1321: STHA_R	stha	%r11, [%r30 + %r0] 0x73
	.word 0xd4b62000  ! 1322: STHA_I	stha	%r10, [%r24 + 0x0000] %asi
	.word 0xdacd84a0  ! 1323: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r13
	.word 0xdc874e80  ! 1324: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r14
	mov	0x68, %r18
	.word 0xd2a70e80  ! 1326: STWA_R	stwa	%r9, [%r28 + %r0] 0x74
	.word 0xda8649e0  ! 1327: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r13
	mov	0x7e0, %r20
	.word 0xd0878e60  ! 1329: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r8
	.word 0x87802025  ! 1330: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xded74e60  ! 1331: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r15
	.word 0xd2f70e80  ! 1332: STXA_R	stxa	%r9, [%r28 + %r0] 0x74
	.word 0xd0cce000  ! 1333: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1334: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0cfe000  ! 1335: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xd0a72000  ! 1336: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xd0b7e000  ! 1337: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	mov	0x10, %r16
	.word 0xd0cf2000  ! 1339: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0xd0f7a000  ! 1340: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0bf0e40  ! 1341: STDA_R	stda	%r8, [%r28 + %r0] 0x72
	.word 0xd4d76000  ! 1342: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	mov	0x3f8, %r23
	mov	0x60, %r26
	.word 0xd6af8e80  ! 1345: STBA_R	stba	%r11, [%r30 + %r0] 0x74
	.word 0xdaafa000  ! 1346: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xd0be49e0  ! 1347: STDA_R	stda	%r8, [%r25 + %r0] 0x4f
	.word 0xd29f6000  ! 1348: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xdeac4400  ! 1349: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 1350: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4f6a000  ! 1351: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	mov	0x0, %r19
	.word 0x87802025  ! 1353: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e8, %r21
	.word 0x87802020  ! 1355: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cfce80  ! 1356: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r11
	mov	0x7d8, %r22
	.word 0xda8609e0  ! 1358: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r13
	mov	0x18, %r24
	.word 0xd6878e40  ! 1360: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r11
	.word 0xd4bf4e60  ! 1361: STDA_R	stda	%r10, [%r29 + %r0] 0x73
	.word 0xd4df2000  ! 1362: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4bfe000  ! 1363: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1364: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1365: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4cf6000  ! 1366: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0x87802073  ! 1367: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f48400  ! 1368: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0x87802073  ! 1369: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r18
	.word 0xd28c6000  ! 1371: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	mov	0x3e0, %r21
	mov	0x3f0, %r21
	.word 0xd2b4a000  ! 1374: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0xd2bca000  ! 1375: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	.word 0xd2f4e000  ! 1376: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 1377: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac7ce80  ! 1378: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r13
	.word 0xd2c7a000  ! 1379: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1380: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29c2000  ! 1381: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	.word 0xd284e000  ! 1382: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r9
	.word 0xd2cc8400  ! 1383: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0x87802072  ! 1384: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c0, %r22
	.word 0x87802025  ! 1386: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 1387: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1388: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdec689e0  ! 1389: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r15
	.word 0x87802025  ! 1390: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 1391: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0afce60  ! 1392: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	.word 0xd6bf4e80  ! 1393: STDA_R	stda	%r11, [%r29 + %r0] 0x74
	.word 0xdac72000  ! 1394: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	mov	0x0, %r16
	.word 0xdacf6000  ! 1396: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	mov	0x20, %r24
	.word 0x87802020  ! 1398: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca48400  ! 1399: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xdef7a000  ! 1400: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 1401: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdea4a000  ! 1402: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xdebca000  ! 1404: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xd2c78e40  ! 1405: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r9
	.word 0xd6f4a000  ! 1406: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xdca584a0  ! 1408: STWA_R	stwa	%r14, [%r22 + %r0] 0x25
	.word 0xde878e40  ! 1409: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r15
	.word 0xd4d42000  ! 1410: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	mov	0x50, %r26
	.word 0xdab78e60  ! 1412: STHA_R	stha	%r13, [%r30 + %r0] 0x73
	.word 0x87802025  ! 1413: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2c7a000  ! 1414: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2afa000  ! 1415: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1416: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r18
	.word 0xdaad04a0  ! 1418: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	.word 0x87802072  ! 1419: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f0, %r22
	mov	0x8, %r26
	.word 0xd69f2000  ! 1422: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	mov	0x70, %r17
	.word 0xd68f2000  ! 1424: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xdc8544a0  ! 1425: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r14
	.word 0x87802025  ! 1426: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0cce000  ! 1427: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0946000  ! 1428: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0xd0846000  ! 1429: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	.word 0xdebf0e80  ! 1430: STDA_R	stda	%r15, [%r28 + %r0] 0x74
	.word 0xd69c6000  ! 1431: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r11
	.word 0xd6842000  ! 1432: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r11
	mov	0x38, %r17
	mov	0x3e8, %r20
	mov	0x18, %r24
	mov	0x38, %r24
	mov	0x48, %r27
	mov	0x20, %r19
	.word 0xd6f4a000  ! 1439: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 1440: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b76000  ! 1441: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xdcb70e40  ! 1442: STHA_R	stha	%r14, [%r28 + %r0] 0x72
	.word 0x87802072  ! 1443: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef76000  ! 1444: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	mov	0x30, %r24
	mov	0x78, %r18
	.word 0xde8f6000  ! 1447: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	.word 0x87802020  ! 1448: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb42000  ! 1449: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0xdec46000  ! 1450: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	.word 0xdef46000  ! 1451: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xde846000  ! 1452: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	mov	0x0, %r25
	.word 0xdedca000  ! 1454: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xd2c504a0  ! 1455: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r9
	.word 0x87802020  ! 1456: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r20
	.word 0xdcd7e000  ! 1458: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xd0d48400  ! 1459: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	.word 0xd8bd84a0  ! 1460: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	.word 0xd0af6000  ! 1461: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd6c7ce40  ! 1462: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r11
	.word 0xde97ce60  ! 1463: LDUHA_R	lduha	[%r31, %r0] 0x73, %r15
	.word 0xdcf48400  ! 1464: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xd6be49e0  ! 1465: STDA_R	stda	%r11, [%r25 + %r0] 0x4f
	mov	0x30, %r27
	mov	0x10, %r25
	.word 0xdcc76000  ! 1468: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0xdcdf6000  ! 1469: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xdcf72000  ! 1470: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xd0dd04a0  ! 1471: LDXA_R	ldxa	[%r20, %r0] 0x25, %r8
	.word 0xd8afa000  ! 1472: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xd89f6000  ! 1473: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	.word 0xdea7ce80  ! 1474: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	.word 0xdec78e60  ! 1475: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r15
	.word 0xda9c8400  ! 1476: LDDA_R	ldda	[%r18, %r0] 0x20, %r13
	.word 0xdeb7e000  ! 1477: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xd2878e40  ! 1478: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r9
	.word 0xd4bfe000  ! 1479: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 1480: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 1481: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r27
	.word 0xd4afa000  ! 1483: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd48f6000  ! 1484: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	mov	0x3f0, %r23
	mov	0x20, %r16
	.word 0xd4a7a000  ! 1487: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd8a504a0  ! 1488: STWA_R	stwa	%r12, [%r20 + %r0] 0x25
	.word 0xd2f70e60  ! 1489: STXA_R	stxa	%r9, [%r28 + %r0] 0x73
	.word 0xdc9fce40  ! 1490: LDDA_R	ldda	[%r31, %r0] 0x72, %r14
	.word 0x87802020  ! 1491: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f7a000  ! 1492: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0bfe000  ! 1493: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 1494: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a7a000  ! 1495: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0f74e60  ! 1496: STXA_R	stxa	%r8, [%r29 + %r0] 0x73
	.word 0xd69f6000  ! 1497: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	.word 0xd6bfce40  ! 1498: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	.word 0xd4d44400  ! 1499: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	mov	0x7e8, %r22
	.word 0x87802020  ! 1501: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ad6000  ! 1502: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	mov	0x50, %r24
	.word 0xd6dec9e0  ! 1504: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r11
	mov	0x60, %r25
	.word 0x8780204f  ! 1506: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f7e000  ! 1507: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1508: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r23
	.word 0xd6dcc400  ! 1510: LDXA_R	ldxa	[%r19, %r0] 0x20, %r11
	.word 0x8780204f  ! 1511: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2afce60  ! 1512: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	mov	0x7c8, %r23
	.word 0xdca46000  ! 1514: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xdac74e40  ! 1515: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r13
	.word 0xd48c6000  ! 1516: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r10
	.word 0xda9f4e60  ! 1517: LDDA_R	ldda	[%r29, %r0] 0x73, %r13
	.word 0xdc8d84a0  ! 1518: LDUBA_R	lduba	[%r22, %r0] 0x25, %r14
	.word 0xde846000  ! 1519: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	.word 0xd2970e60  ! 1520: LDUHA_R	lduha	[%r28, %r0] 0x73, %r9
	.word 0xdef42000  ! 1521: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xde8c6000  ! 1522: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	mov	0x70, %r24
	.word 0x87802072  ! 1524: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d8, %r22
	.word 0xdef6a000  ! 1526: STXA_I	stxa	%r15, [%r26 + 0x0000] %asi
	.word 0xde86e000  ! 1527: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r15
	.word 0xd4b649e0  ! 1528: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	.word 0xde86a000  ! 1529: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r15
	.word 0xd4a7ce60  ! 1530: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	.word 0xdeb6a000  ! 1531: STHA_I	stha	%r15, [%r26 + 0x0000] %asi
	mov	0x30, %r18
	.word 0xdedea000  ! 1533: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r15
	mov	0x0, %r24
	.word 0xdeae2000  ! 1535: STBA_I	stba	%r15, [%r24 + 0x0000] %asi
	.word 0xd4b5c4a0  ! 1536: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	.word 0xd2de09e0  ! 1537: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r9
	.word 0xdcaf0e80  ! 1538: STBA_R	stba	%r14, [%r28 + %r0] 0x74
	.word 0xd28ea000  ! 1539: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r9
	.word 0xdea74e80  ! 1540: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	.word 0xd8a6e000  ! 1541: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	mov	0x30, %r24
	mov	0x68, %r24
	.word 0xdcb689e0  ! 1544: STHA_R	stha	%r14, [%r26 + %r0] 0x4f
	.word 0xd8ae2000  ! 1545: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 1546: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad78e80  ! 1547: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r13
	.word 0xdabee000  ! 1548: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	.word 0xda966000  ! 1549: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r13
	.word 0xdaf66000  ! 1550: STXA_I	stxa	%r13, [%r25 + 0x0000] %asi
	.word 0xd2bf0e80  ! 1551: STDA_R	stda	%r9, [%r28 + %r0] 0x74
	.word 0xd2f6e000  ! 1552: STXA_I	stxa	%r9, [%r27 + 0x0000] %asi
	.word 0xd8c609e0  ! 1553: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r12
	.word 0xdcce2000  ! 1554: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r14
	.word 0xd2a5c4a0  ! 1555: STWA_R	stwa	%r9, [%r23 + %r0] 0x25
	.word 0xd4f6a000  ! 1556: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	mov	0x3f0, %r21
	.word 0xd0b44400  ! 1558: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xdcb7ce40  ! 1559: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	.word 0xd6f649e0  ! 1560: STXA_R	stxa	%r11, [%r25 + %r0] 0x4f
	.word 0xd0ae2000  ! 1561: STBA_I	stba	%r8, [%r24 + 0x0000] %asi
	mov	0x28, %r25
	mov	0x7f8, %r21
	mov	0x60, %r17
	.word 0xdec48400  ! 1565: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	mov	0x20, %r24
	.word 0xd2a70e60  ! 1567: STWA_R	stwa	%r9, [%r28 + %r0] 0x73
	mov	0x50, %r16
	mov	0x10, %r19
	.word 0xdcce2000  ! 1570: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r14
	.word 0x87802020  ! 1571: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc874e80  ! 1572: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r14
	mov	0x50, %r19
	.word 0xd2af4e80  ! 1574: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	.word 0xd0ae49e0  ! 1575: STBA_R	stba	%r8, [%r25 + %r0] 0x4f
	.word 0x87802025  ! 1576: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabf0e80  ! 1577: STDA_R	stda	%r13, [%r28 + %r0] 0x74
	.word 0xda8689e0  ! 1578: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r13
	.word 0x87802072  ! 1579: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdac56000  ! 1580: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r13
	.word 0x87802025  ! 1581: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 1582: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r27
	mov	0x20, %r27
	.word 0x8780204f  ! 1585: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c0, %r21
	.word 0xd4d4c400  ! 1587: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0xdaf76000  ! 1588: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0xd0c48400  ! 1590: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r8
	.word 0xdcf76000  ! 1591: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdc972000  ! 1592: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	.word 0xdcafa000  ! 1593: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xd6dfce80  ! 1594: LDXA_R	ldxa	[%r31, %r0] 0x74, %r11
	.word 0x87802074  ! 1595: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4c78e60  ! 1596: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r10
	.word 0xd0b78e40  ! 1597: STHA_R	stha	%r8, [%r30 + %r0] 0x72
	.word 0x87802072  ! 1598: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r16
	mov	0x7d8, %r20
	.word 0xdcb4c400  ! 1601: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xd4a584a0  ! 1602: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	mov	0x40, %r16
	.word 0xd0856000  ! 1604: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r8
	.word 0xdeaf8e40  ! 1605: STBA_R	stba	%r15, [%r30 + %r0] 0x72
	.word 0x87802072  ! 1606: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0cfe000  ! 1607: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	mov	0x7c0, %r21
	mov	0x48, %r24
	.word 0xd0f7e000  ! 1610: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd29fce60  ! 1611: LDDA_R	ldda	[%r31, %r0] 0x73, %r9
	.word 0xdab72000  ! 1612: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdab7a000  ! 1613: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdccf4e60  ! 1614: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r14
	.word 0xd6cd84a0  ! 1615: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r11
	.word 0xd4afce40  ! 1616: STBA_R	stba	%r10, [%r31 + %r0] 0x72
	mov	0x7d8, %r21
	.word 0xd0cfce60  ! 1618: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r8
	.word 0xd4bf2000  ! 1619: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd28c8400  ! 1620: LDUBA_R	lduba	[%r18, %r0] 0x20, %r9
	.word 0xd0f7e000  ! 1621: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd2a74e80  ! 1622: STWA_R	stwa	%r9, [%r29 + %r0] 0x74
	.word 0x87802074  ! 1623: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r24
	.word 0x87802020  ! 1625: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2870e80  ! 1626: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r9
	mov	0x3f0, %r20
	.word 0x87802020  ! 1628: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a44400  ! 1629: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0xd484a000  ! 1630: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r10
	.word 0x87802073  ! 1631: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4af2000  ! 1632: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd08dc4a0  ! 1633: LDUBA_R	lduba	[%r23, %r0] 0x25, %r8
	mov	0x3c8, %r21
	mov	0x10, %r25
	mov	0x10, %r24
	.word 0xd8bfa000  ! 1637: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd8cfa000  ! 1638: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd8c72000  ! 1639: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802073  ! 1641: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r26
	.word 0x87802020  ! 1643: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd894a000  ! 1644: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r12
	.word 0xd894a000  ! 1645: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r12
	mov	0x58, %r25
	.word 0xdab48400  ! 1647: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0x87802020  ! 1648: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebee000  ! 1649: STDA_I	stda	%r15, [%r27 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xd8bf0e60  ! 1651: STDA_R	stda	%r12, [%r28 + %r0] 0x73
	mov	0x68, %r19
	.word 0xdc8f0e80  ! 1653: LDUBA_R	lduba	[%r28, %r0] 0x74, %r14
	mov	0x78, %r16
	.word 0xd4cea000  ! 1655: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r10
	.word 0xd4bee000  ! 1656: STDA_I	stda	%r10, [%r27 + 0x0000] %asi
	.word 0xdc9c0400  ! 1657: LDDA_R	ldda	[%r16, %r0] 0x20, %r14
	mov	0x50, %r27
	mov	0x3f8, %r20
	.word 0x87802020  ! 1660: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf74e80  ! 1661: STXA_R	stxa	%r13, [%r29 + %r0] 0x74
	.word 0xd88689e0  ! 1662: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r12
	.word 0x87802074  ! 1663: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x48, %r18
	.word 0xd0bc4400  ! 1666: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xdabe2000  ! 1667: STDA_I	stda	%r13, [%r24 + 0x0000] %asi
	mov	0x28, %r18
	mov	0x3c0, %r23
	.word 0xd0b48400  ! 1670: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xdc962000  ! 1671: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r14
	.word 0xdcb62000  ! 1672: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	mov	0x20, %r16
	.word 0xdcbea000  ! 1674: STDA_I	stda	%r14, [%r26 + 0x0000] %asi
	.word 0xdccea000  ! 1675: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r14
	mov	0x50, %r16
	.word 0x87802025  ! 1677: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6c44400  ! 1678: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r11
	.word 0xdeb7e000  ! 1679: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 1680: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeb72000  ! 1681: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xd0a70e80  ! 1682: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0x87802072  ! 1683: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4d78e80  ! 1684: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r10
	.word 0x8780204f  ! 1685: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdac74e80  ! 1686: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r13
	mov	0x38, %r26
	.word 0x87802020  ! 1688: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf689e0  ! 1689: STXA_R	stxa	%r14, [%r26 + %r0] 0x4f
	.word 0xd4afce40  ! 1690: STBA_R	stba	%r10, [%r31 + %r0] 0x72
	mov	0x20, %r16
	.word 0xdabc4400  ! 1692: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	mov	0x58, %r16
	.word 0x87802073  ! 1694: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 1695: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f66000  ! 1696: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	.word 0xd2b584a0  ! 1697: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0x87802025  ! 1698: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda9e2000  ! 1699: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r13
	.word 0xd0a70e80  ! 1700: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0xd4d6a000  ! 1701: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r10
	.word 0xdcbf8e80  ! 1702: STDA_R	stda	%r14, [%r30 + %r0] 0x74
	.word 0xd2a78e80  ! 1703: STWA_R	stwa	%r9, [%r30 + %r0] 0x74
	.word 0xdab544a0  ! 1704: STHA_R	stha	%r13, [%r21 + %r0] 0x25
	mov	0x8, %r25
	mov	0x68, %r24
	.word 0xda9ea000  ! 1707: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1708: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r17
	.word 0xdaa4a000  ! 1710: STWA_I	stwa	%r13, [%r18 + 0x0000] %asi
	.word 0xdabce000  ! 1711: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0xdabca000  ! 1712: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 1713: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4acc400  ! 1714: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xd48c0400  ! 1715: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	.word 0xd8b78e60  ! 1716: STHA_R	stha	%r12, [%r30 + %r0] 0x73
	.word 0xdcdc6000  ! 1717: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	.word 0xd68c0400  ! 1718: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	.word 0xde8f0e80  ! 1719: LDUBA_R	lduba	[%r28, %r0] 0x74, %r15
	.word 0xd0a4a000  ! 1720: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 1721: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0bfce80  ! 1722: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	mov	0x50, %r27
	mov	0x48, %r18
	.word 0xd8c42000  ! 1725: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r12
	.word 0xd8d42000  ! 1726: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0xd897ce80  ! 1727: LDUHA_R	lduha	[%r31, %r0] 0x74, %r12
	.word 0xdeb609e0  ! 1728: STHA_R	stha	%r15, [%r24 + %r0] 0x4f
	.word 0xd4cc2000  ! 1729: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	.word 0xd484a000  ! 1730: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r10
	.word 0xda9cc400  ! 1731: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	.word 0x8780204f  ! 1732: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b544a0  ! 1733: STHA_R	stha	%r12, [%r21 + %r0] 0x25
	.word 0xdcb76000  ! 1734: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xd0bf8e60  ! 1735: STDA_R	stda	%r8, [%r30 + %r0] 0x73
	.word 0xd0f7e000  ! 1736: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0af6000  ! 1737: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	mov	0x7f8, %r20
	.word 0xd0af2000  ! 1739: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0a74e80  ! 1740: STWA_R	stwa	%r8, [%r29 + %r0] 0x74
	.word 0xd4974e60  ! 1741: LDUHA_R	lduha	[%r29, %r0] 0x73, %r10
	.word 0x87802020  ! 1742: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r22
	.word 0xdaf6c9e0  ! 1744: STXA_R	stxa	%r13, [%r27 + %r0] 0x4f
	.word 0xd88609e0  ! 1745: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r12
	.word 0xd8b74e80  ! 1746: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	.word 0xde8d84a0  ! 1747: LDUBA_R	lduba	[%r22, %r0] 0x25, %r15
	.word 0xdecd6000  ! 1748: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r15
	.word 0xdeb5e000  ! 1749: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	.word 0xd2f649e0  ! 1750: STXA_R	stxa	%r9, [%r25 + %r0] 0x4f
	.word 0xda85a000  ! 1751: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r13
	.word 0xdaa7ce40  ! 1752: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	.word 0xd68de000  ! 1753: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r11
	.word 0xd6a5e000  ! 1754: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	.word 0xdccfce60  ! 1755: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r14
	.word 0xdca4c400  ! 1756: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	mov	0x70, %r25
	.word 0xda8d2000  ! 1758: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1759: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bdc4a0  ! 1760: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	mov	0x18, %r26
	.word 0x87802074  ! 1762: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 1763: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 1764: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8df4e60  ! 1765: LDXA_R	ldxa	[%r29, %r0] 0x73, %r12
	.word 0xd4a46000  ! 1766: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xd2bf4e80  ! 1767: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	.word 0xda8f4e60  ! 1768: LDUBA_R	lduba	[%r29, %r0] 0x73, %r13
	.word 0x87802020  ! 1769: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4af2000  ! 1770: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd6d544a0  ! 1771: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r11
	mov	0x28, %r25
	.word 0xdef649e0  ! 1773: STXA_R	stxa	%r15, [%r25 + %r0] 0x4f
	.word 0xdec7e000  ! 1774: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xdaa74e60  ! 1775: STWA_R	stwa	%r13, [%r29 + %r0] 0x73
	.word 0xdca76000  ! 1776: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	mov	0x0, %r25
	.word 0xd89f0e80  ! 1778: LDDA_R	ldda	[%r28, %r0] 0x74, %r12
	.word 0x8780204f  ! 1779: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 1780: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc87ce40  ! 1781: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r14
	mov	0x8, %r26
	mov	0x60, %r25
	.word 0xdccd44a0  ! 1784: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r14
	.word 0x87802020  ! 1785: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b74e60  ! 1786: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	.word 0xd6d70e40  ! 1787: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r11
	.word 0xd2b5a000  ! 1788: STHA_I	stha	%r9, [%r22 + 0x0000] %asi
	.word 0xdcd78e80  ! 1789: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r14
	.word 0xdcd4c400  ! 1790: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	.word 0xd4bde000  ! 1791: STDA_I	stda	%r10, [%r23 + 0x0000] %asi
	mov	0x50, %r26
	.word 0xd4cde000  ! 1793: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 1794: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd48c2000  ! 1795: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r10
	.word 0xd4ac2000  ! 1796: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0xd4dc6000  ! 1797: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	.word 0xde940400  ! 1798: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	mov	0x50, %r25
	.word 0xdec42000  ! 1800: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0xde9c6000  ! 1801: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r15
	.word 0xdef42000  ! 1802: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xded4e000  ! 1803: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	.word 0xde8ce000  ! 1804: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	.word 0xdecca000  ! 1805: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	mov	0x40, %r18
	.word 0x87802074  ! 1807: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdebde000  ! 1808: STDA_I	stda	%r15, [%r23 + 0x0000] %asi
	.word 0xd2f7ce80  ! 1809: STXA_R	stxa	%r9, [%r31 + %r0] 0x74
	.word 0xd8c70e80  ! 1810: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r12
	.word 0x87802020  ! 1811: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdeb66000  ! 1813: STHA_I	stha	%r15, [%r25 + 0x0000] %asi
	.word 0x87802025  ! 1814: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda94c400  ! 1815: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	.word 0xdcac6000  ! 1816: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	mov	0x68, %r26
	.word 0xd2bf0e60  ! 1818: STDA_R	stda	%r9, [%r28 + %r0] 0x73
	.word 0x87802020  ! 1819: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8afce80  ! 1820: STBA_R	stba	%r12, [%r31 + %r0] 0x74
	.word 0xd0bf8e60  ! 1821: STDA_R	stda	%r8, [%r30 + %r0] 0x73
	.word 0xdcdf0e40  ! 1822: LDXA_R	ldxa	[%r28, %r0] 0x72, %r14
	.word 0xdccfce60  ! 1823: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r14
	.word 0x87802025  ! 1824: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a504a0  ! 1825: STWA_R	stwa	%r8, [%r20 + %r0] 0x25
	mov	0x7e0, %r20
	.word 0xdcbe09e0  ! 1827: STDA_R	stda	%r14, [%r24 + %r0] 0x4f
	.word 0xdcc62000  ! 1828: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r14
	.word 0xda9504a0  ! 1829: LDUHA_R	lduha	[%r20, %r0] 0x25, %r13
	mov	0x68, %r25
	.word 0xdaf62000  ! 1831: STXA_I	stxa	%r13, [%r24 + 0x0000] %asi
	.word 0xdcb584a0  ! 1832: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	.word 0xd6a7ce40  ! 1833: STWA_R	stwa	%r11, [%r31 + %r0] 0x72
	.word 0xd4df8e60  ! 1834: LDXA_R	ldxa	[%r30, %r0] 0x73, %r10
	.word 0x8780204f  ! 1835: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6bfce80  ! 1836: STDA_R	stda	%r11, [%r31 + %r0] 0x74
	mov	0x3e8, %r20
	mov	0x3d8, %r23
	.word 0xdcbf6000  ! 1839: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdcb7a000  ! 1840: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 1841: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf52000  ! 1842: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	mov	0x60, %r17
	mov	0x18, %r19
	.word 0x8780204f  ! 1845: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d0, %r21
	.word 0xdcf4e000  ! 1847: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xdca46000  ! 1848: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xdc846000  ! 1849: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	.word 0xdac5c4a0  ! 1850: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r13
	.word 0xd4d4e000  ! 1851: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0xd89f4e60  ! 1852: LDDA_R	ldda	[%r29, %r0] 0x73, %r12
	.word 0xdebce000  ! 1853: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xdecca000  ! 1854: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	mov	0x3e0, %r21
	.word 0x87802073  ! 1856: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 1857: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r26
	.word 0xd49f0e40  ! 1859: LDDA_R	ldda	[%r28, %r0] 0x72, %r10
	.word 0xd4978e40  ! 1860: LDUHA_R	lduha	[%r30, %r0] 0x72, %r10
	.word 0x87802025  ! 1861: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcaf4e80  ! 1862: STBA_R	stba	%r14, [%r29 + %r0] 0x74
	.word 0xdaaf4e40  ! 1863: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	.word 0xde86a000  ! 1864: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r15
	.word 0xdece2000  ! 1865: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r15
	.word 0xdec6a000  ! 1866: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r15
	mov	0x3f8, %r21
	.word 0xdacf4e80  ! 1868: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r13
	.word 0xdaaea000  ! 1869: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	.word 0xdcaf4e40  ! 1870: STBA_R	stba	%r14, [%r29 + %r0] 0x72
	.word 0xdebe6000  ! 1871: STDA_I	stda	%r15, [%r25 + 0x0000] %asi
	.word 0xd4c70e40  ! 1872: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r10
	.word 0xd4ae09e0  ! 1873: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0xdcbe89e0  ! 1874: STDA_R	stda	%r14, [%r26 + %r0] 0x4f
	.word 0xd89f8e80  ! 1875: LDDA_R	ldda	[%r30, %r0] 0x74, %r12
	.word 0x87802073  ! 1876: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 1877: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4c689e0  ! 1878: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r10
	.word 0xd6f76000  ! 1879: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd6d72000  ! 1880: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r11
	.word 0xd6af6000  ! 1881: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd6dfe000  ! 1882: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	mov	0x38, %r25
	mov	0x10, %r18
	mov	0x50, %r27
	.word 0xd6bf6000  ! 1886: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xdcdf0e60  ! 1887: LDXA_R	ldxa	[%r28, %r0] 0x73, %r14
	.word 0x87802020  ! 1888: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r19
	.word 0xdcac6000  ! 1890: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xd4b78e60  ! 1891: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	.word 0xdcace000  ! 1892: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0xdcbce000  ! 1893: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xd8f4c400  ! 1894: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xdcc42000  ! 1895: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r14
	.word 0x87802073  ! 1896: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf7a000  ! 1897: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xdccf6000  ! 1898: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xd69f4e40  ! 1899: LDDA_R	ldda	[%r29, %r0] 0x72, %r11
	.word 0xd6b76000  ! 1900: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xda978e60  ! 1901: LDUHA_R	lduha	[%r30, %r0] 0x73, %r13
	.word 0xdc87a000  ! 1902: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xd4bd04a0  ! 1903: STDA_R	stda	%r10, [%r20 + %r0] 0x25
	mov	0x70, %r19
	mov	0x50, %r18
	mov	0x7c8, %r23
	.word 0xd097a000  ! 1907: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	mov	0x58, %r27
	.word 0xd0972000  ! 1909: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xd8cf4e40  ! 1910: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r12
	.word 0xd2cf8e40  ! 1911: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r9
	.word 0x87802073  ! 1912: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r16
	mov	0x38, %r18
	.word 0xd8a6c9e0  ! 1915: STWA_R	stwa	%r12, [%r27 + %r0] 0x4f
	mov	0x20, %r16
	.word 0xd8bf2000  ! 1917: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	mov	0x18, %r17
	.word 0xde8ec9e0  ! 1919: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r15
	.word 0xda974e60  ! 1920: LDUHA_R	lduha	[%r29, %r0] 0x73, %r13
	.word 0xd8bf2000  ! 1921: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd89f6000  ! 1922: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	.word 0xd8bf2000  ! 1923: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	mov	0x50, %r25
	mov	0x50, %r24
	.word 0xd8df2000  ! 1926: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8bf6000  ! 1927: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd8cfa000  ! 1928: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xdcbf4e60  ! 1929: STDA_R	stda	%r14, [%r29 + %r0] 0x73
	.word 0xd6f689e0  ! 1930: STXA_R	stxa	%r11, [%r26 + %r0] 0x4f
	.word 0xda97ce40  ! 1931: LDUHA_R	lduha	[%r31, %r0] 0x72, %r13
	mov	0x78, %r19
	.word 0xda8c4400  ! 1933: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0xd0bfa000  ! 1934: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 1935: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f584a0  ! 1936: STXA_R	stxa	%r11, [%r22 + %r0] 0x25
	mov	0x68, %r19
	.word 0xd0f76000  ! 1938: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd8a44400  ! 1939: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xd0874e40  ! 1940: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r8
	mov	0x40, %r25
	mov	0x50, %r19
	.word 0xd6bfa000  ! 1943: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd6b7a000  ! 1944: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 1945: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88d04a0  ! 1946: LDUBA_R	lduba	[%r20, %r0] 0x25, %r12
	.word 0x87802074  ! 1947: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2ac4400  ! 1948: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xd0b72000  ! 1949: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	mov	0x20, %r17
	.word 0xd0972000  ! 1951: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	mov	0x40, %r25
	.word 0xdebe89e0  ! 1953: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 1954: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 1955: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd09fce40  ! 1956: LDDA_R	ldda	[%r31, %r0] 0x72, %r8
	.word 0xd8c689e0  ! 1957: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r12
	mov	0x8, %r25
	.word 0xd0bf2000  ! 1959: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xd0f584a0  ! 1960: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	.word 0x87802074  ! 1961: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbcc400  ! 1962: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xd8cc2000  ! 1963: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r12
	.word 0xd894e000  ! 1964: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r12
	.word 0xd2d44400  ! 1965: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r9
	mov	0x30, %r26
	.word 0xd8d42000  ! 1967: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0xd89ca000  ! 1968: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r12
	.word 0xd8bc6000  ! 1969: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0xd8dc2000  ! 1970: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0x87802025  ! 1971: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2dc4400  ! 1972: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xd2af0e60  ! 1973: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	.word 0x87802020  ! 1974: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1975: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b4e000  ! 1976: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xdcbf0e60  ! 1977: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	.word 0xd8dca000  ! 1978: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	.word 0xd2b78e60  ! 1979: STHA_R	stha	%r9, [%r30 + %r0] 0x73
	.word 0xda97ce40  ! 1980: LDUHA_R	lduha	[%r31, %r0] 0x72, %r13
	mov	0x70, %r26
	mov	0x78, %r26
	mov	0x7c0, %r22
	.word 0x87802025  ! 1984: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f7a000  ! 1985: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xdebc0400  ! 1986: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0xdcaf2000  ! 1987: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xd89fce40  ! 1989: LDDA_R	ldda	[%r31, %r0] 0x72, %r12
	mov	0x50, %r24
	.word 0x87802072  ! 1991: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 1992: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd68fa000  ! 1993: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	mov	0x18, %r27
	mov	0x3f8, %r20
	.word 0xd6df2000  ! 1996: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd2b689e0  ! 1997: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	mov	0x7e8, %r21
	.word 0xde87e000  ! 1999: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdecfa000  ! 2000: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xdec76000  ! 2001: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xdef72000  ! 2002: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xd0bfce80  ! 2003: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	mov	0x7e8, %r21
	.word 0xd2b7a000  ! 2005: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd2afa000  ! 2006: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xd6a70e40  ! 2007: STWA_R	stwa	%r11, [%r28 + %r0] 0x72
	.word 0xd0bf6000  ! 2008: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd8b4c400  ! 2009: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0xdab7e000  ! 2010: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2011: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r20
	.word 0xde9e89e0  ! 2013: LDDA_R	ldda	[%r26, %r0] 0x4f, %r15
	.word 0xd097a000  ! 2014: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	.word 0xd4dd44a0  ! 2015: LDXA_R	ldxa	[%r21, %r0] 0x25, %r10
	mov	0x28, %r27
	mov	0x3c0, %r20
	.word 0xdcd7a000  ! 2018: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0xdccfa000  ! 2019: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	.word 0xdcd7e000  ! 2020: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xdc97a000  ! 2021: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	.word 0xdc8f6000  ! 2022: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xdca7a000  ! 2023: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdca72000  ! 2024: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xd6f48400  ! 2025: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xde9fa000  ! 2026: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	.word 0xd4b74e80  ! 2027: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	mov	0x7d0, %r20
	.word 0xd0dfa000  ! 2029: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0xdef544a0  ! 2030: STXA_R	stxa	%r15, [%r21 + %r0] 0x25
	.word 0xdc8f6000  ! 2031: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r14
	.word 0xd0848400  ! 2032: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r8
	.word 0xd497e000  ! 2033: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	mov	0x7d0, %r23
	.word 0x8780204f  ! 2035: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 2036: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r26
	.word 0x87802074  ! 2038: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a7e000  ! 2039: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 2040: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8ac8400  ! 2041: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0xd4bda000  ! 2042: STDA_I	stda	%r10, [%r22 + 0x0000] %asi
	.word 0xd48de000  ! 2043: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r10
	.word 0xd4f5a000  ! 2044: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	.word 0xd2bf8e60  ! 2045: STDA_R	stda	%r9, [%r30 + %r0] 0x73
	.word 0xdac609e0  ! 2046: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r13
	mov	0x3c8, %r20
	.word 0xd4d52000  ! 2048: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r10
	mov	0x38, %r24
	mov	0x0, %r16
	.word 0xd6b44400  ! 2051: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	mov	0x18, %r27
	.word 0xd884c400  ! 2053: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	.word 0x87802025  ! 2054: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde8fe000  ! 2055: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0xdecfa000  ! 2056: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	mov	0x78, %r18
	mov	0x7e0, %r23
	.word 0xde9e49e0  ! 2059: LDDA_R	ldda	[%r25, %r0] 0x4f, %r15
	.word 0xdcce89e0  ! 2060: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r14
	.word 0x87802020  ! 2061: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb6e000  ! 2062: STHA_I	stha	%r15, [%r27 + 0x0000] %asi
	.word 0xd08609e0  ! 2063: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r8
	.word 0xd0b6a000  ! 2064: STHA_I	stha	%r8, [%r26 + 0x0000] %asi
	.word 0xd0bea000  ! 2065: STDA_I	stda	%r8, [%r26 + 0x0000] %asi
	.word 0xde9f0e60  ! 2066: LDDA_R	ldda	[%r28, %r0] 0x73, %r15
	mov	0x0, %r27
	mov	0x58, %r16
	.word 0x87802020  ! 2069: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8dfa000  ! 2070: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8afa000  ! 2071: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xdcf44400  ! 2072: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xdeb7a000  ! 2073: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xdea7e000  ! 2074: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2075: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9fa000  ! 2076: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	mov	0x70, %r18
	mov	0x20, %r25
	.word 0xdecfe000  ! 2079: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdea76000  ! 2081: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 2082: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r19
	.word 0xdedca000  ! 2084: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xdea4a000  ! 2085: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xdebca000  ! 2086: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 2087: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r19
	.word 0xdef46000  ! 2089: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xdeac2000  ! 2090: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 2091: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2d48400  ! 2092: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	.word 0xd6bc2000  ! 2093: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0xd6dc2000  ! 2094: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r11
	mov	0x10, %r19
	.word 0xdcc74e80  ! 2096: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r14
	.word 0xd4d4a000  ! 2097: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0xd4dca000  ! 2098: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	.word 0xdeb544a0  ! 2099: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	.word 0x87802073  ! 2100: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdadfe000  ! 2101: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0xdaf76000  ! 2102: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdaa70e60  ! 2103: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	ta	T_CHANGE_PRIV	! macro
	mov	0x7c0, %r21
	.word 0xda976000  ! 2106: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	.word 0xdabfa000  ! 2107: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdc8f4e80  ! 2108: LDUBA_R	lduba	[%r29, %r0] 0x74, %r14
	mov	0x48, %r27
	.word 0xd8b76000  ! 2110: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 2111: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d8, %r20
	.word 0xd8cc6000  ! 2113: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r12
	.word 0xd8f42000  ! 2114: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xdcbd04a0  ! 2115: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	mov	0x58, %r27
	.word 0xd8afce60  ! 2117: STBA_R	stba	%r12, [%r31 + %r0] 0x73
	.word 0xd0cf0e60  ! 2118: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r8
	mov	0x68, %r26
	.word 0xdeaf4e40  ! 2120: STBA_R	stba	%r15, [%r29 + %r0] 0x72
	.word 0x87802025  ! 2121: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd88609e0  ! 2122: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r12
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6c40400  ! 2124: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r11
	.word 0xd6af0e60  ! 2125: STBA_R	stba	%r11, [%r28 + %r0] 0x73
	.word 0xd8c4a000  ! 2126: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r12
	mov	0x8, %r17
	.word 0xd8bca000  ! 2128: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	mov	0x30, %r25
	.word 0xd6c544a0  ! 2130: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r11
	.word 0xd28ca000  ! 2131: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2d4a000  ! 2132: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	mov	0x70, %r26
	.word 0x8780204f  ! 2134: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd28f2000  ! 2135: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	.word 0xd29f6000  ! 2136: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xd0cc8400  ! 2137: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0xdca40400  ! 2138: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xd6f74e40  ! 2139: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	.word 0x87802074  ! 2140: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaae49e0  ! 2141: STBA_R	stba	%r13, [%r25 + %r0] 0x4f
	.word 0x87802073  ! 2142: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c8, %r21
	.word 0xd68e09e0  ! 2144: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r11
	.word 0x87802072  ! 2145: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b52000  ! 2146: STHA_I	stha	%r8, [%r20 + 0x0000] %asi
	.word 0xd0c5a000  ! 2147: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r8
	mov	0x20, %r27
	.word 0x87802072  ! 2149: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r19
	.word 0x87802074  ! 2151: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0962000  ! 2152: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r8
	.word 0xd0c62000  ! 2153: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 2154: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6d74e40  ! 2155: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r11
	.word 0x87802072  ! 2156: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r19
	mov	0x40, %r17
	.word 0xd48c4400  ! 2159: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0xda9ce000  ! 2160: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r13
	.word 0xdacc6000  ! 2161: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	.word 0xdacc6000  ! 2162: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r13
	.word 0xdef74e80  ! 2163: STXA_R	stxa	%r15, [%r29 + %r0] 0x74
	.word 0xdcb46000  ! 2164: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	mov	0x30, %r25
	.word 0xdca46000  ! 2166: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xd2c48400  ! 2167: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0x87802020  ! 2168: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2169: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r17
	.word 0xd0f6e000  ! 2171: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	.word 0xd0a6e000  ! 2172: STWA_I	stwa	%r8, [%r27 + 0x0000] %asi
	.word 0xd0ae89e0  ! 2173: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	.word 0x87802073  ! 2174: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6b7ce60  ! 2175: STHA_R	stha	%r11, [%r31 + %r0] 0x73
	.word 0xdeaf0e40  ! 2176: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	.word 0x87802074  ! 2177: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2976000  ! 2178: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2179: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b7a000  ! 2180: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 2181: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29e6000  ! 2182: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r9
	.word 0xdcb4c400  ! 2183: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	mov	0x38, %r26
	.word 0xdaa6a000  ! 2185: STWA_I	stwa	%r13, [%r26 + 0x0000] %asi
	.word 0xd4c649e0  ! 2186: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r10
	.word 0x87802020  ! 2187: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ac0400  ! 2188: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	.word 0xdcb72000  ! 2189: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xd6dfce40  ! 2190: LDXA_R	ldxa	[%r31, %r0] 0x72, %r11
	mov	0x60, %r26
	.word 0xdcdfe000  ! 2192: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xd0a74e60  ! 2193: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	.word 0xdadfe000  ! 2194: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0xdabf6000  ! 2195: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	mov	0x3d8, %r20
	mov	0x38, %r26
	.word 0xda8f2000  ! 2198: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	mov	0x0, %r18
	.word 0xd8978e60  ! 2200: LDUHA_R	lduha	[%r30, %r0] 0x73, %r12
	mov	0x78, %r17
	.word 0xd88c8400  ! 2202: LDUBA_R	lduba	[%r18, %r0] 0x20, %r12
	mov	0x3f0, %r21
	.word 0x87802073  ! 2204: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e0, %r20
	.word 0xd69c0400  ! 2206: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	mov	0x7d8, %r21
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdcaee000  ! 2209: STBA_I	stba	%r14, [%r27 + 0x0000] %asi
	.word 0xdcd6a000  ! 2210: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r14
	.word 0xd4f544a0  ! 2211: STXA_R	stxa	%r10, [%r21 + %r0] 0x25
	mov	0x0, %r25
	.word 0xdc8ee000  ! 2213: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r14
	.word 0xdc9ea000  ! 2214: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r14
	.word 0xd0b48400  ! 2215: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xd2c62000  ! 2216: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r9
	mov	0x68, %r24
	.word 0x87802025  ! 2218: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2219: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde9544a0  ! 2220: LDUHA_R	lduha	[%r21, %r0] 0x25, %r15
	mov	0x40, %r18
	.word 0xd2a74e60  ! 2222: STWA_R	stwa	%r9, [%r29 + %r0] 0x73
	.word 0xdcf42000  ! 2223: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0xdaa7ce40  ! 2224: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	mov	0x78, %r26
	.word 0x8780204f  ! 2226: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd086e000  ! 2227: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r8
	.word 0xded5c4a0  ! 2228: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r15
	mov	0x3c8, %r21
	.word 0x87802020  ! 2230: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2948400  ! 2231: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	.word 0x87802020  ! 2232: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2233: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2234: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded76000  ! 2235: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0x87802020  ! 2236: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2237: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaf74e60  ! 2238: STXA_R	stxa	%r13, [%r29 + %r0] 0x73
	.word 0x87802074  ! 2239: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0dfa000  ! 2240: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0x87802074  ! 2241: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b6a000  ! 2242: STHA_I	stha	%r8, [%r26 + 0x0000] %asi
	.word 0xd08e2000  ! 2243: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r8
	.word 0x87802020  ! 2244: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r25
	.word 0xdadcc400  ! 2246: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xd2d70e60  ! 2247: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r9
	mov	0x50, %r27
	.word 0x87802020  ! 2249: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2250: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f72000  ! 2251: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd297a000  ! 2252: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2253: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdab5c4a0  ! 2254: STHA_R	stha	%r13, [%r23 + %r0] 0x25
	mov	0x28, %r27
	.word 0xdea5c4a0  ! 2256: STWA_R	stwa	%r15, [%r23 + %r0] 0x25
	.word 0xdef7ce60  ! 2257: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0x87802072  ! 2258: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd69c0400  ! 2259: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	mov	0x3d8, %r20
	.word 0xd4dd84a0  ! 2261: LDXA_R	ldxa	[%r22, %r0] 0x25, %r10
	mov	0x3e8, %r20
	.word 0x87802072  ! 2263: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a7e000  ! 2264: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8cfe000  ! 2265: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	mov	0x7f0, %r21
	mov	0x30, %r26
	.word 0xd89f6000  ! 2268: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	.word 0xd88f6000  ! 2269: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xdc9f0e80  ! 2270: LDDA_R	ldda	[%r28, %r0] 0x74, %r14
	.word 0xd0a72000  ! 2271: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xd8b609e0  ! 2272: STHA_R	stha	%r12, [%r24 + %r0] 0x4f
	.word 0xded76000  ! 2273: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0xd8840400  ! 2274: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r12
	mov	0x48, %r25
	.word 0xdccf6000  ! 2276: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0xdcf72000  ! 2277: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xdc87a000  ! 2279: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xd0f4c400  ! 2280: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	mov	0x48, %r16
	.word 0x87802072  ! 2282: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd48fe000  ! 2283: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xd6bd84a0  ! 2284: STDA_R	stda	%r11, [%r22 + %r0] 0x25
	.word 0xd6f6c9e0  ! 2285: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	.word 0xdc84c400  ! 2286: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	.word 0xd0f76000  ! 2287: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	mov	0x3e0, %r21
	mov	0x48, %r27
	mov	0x40, %r25
	.word 0x8780204f  ! 2291: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcd7ce60  ! 2292: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r14
	.word 0xd2b7e000  ! 2293: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2a76000  ! 2294: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 2295: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2296: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bfe000  ! 2297: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd6f48400  ! 2298: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xd8b76000  ! 2299: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	mov	0x3e0, %r20
	.word 0xd8a609e0  ! 2301: STWA_R	stwa	%r12, [%r24 + %r0] 0x4f
	.word 0xd8cc8400  ! 2302: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0x87802074  ! 2303: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3f0, %r20
	.word 0xdef74e60  ! 2305: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	.word 0xd6a48400  ! 2306: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0xde96e000  ! 2307: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r15
	.word 0xd29c4400  ! 2308: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	mov	0x8, %r18
	.word 0x87802020  ! 2310: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cc0400  ! 2311: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r11
	.word 0xd0ac8400  ! 2312: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0x87802020  ! 2313: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r24
	.word 0xd8b46000  ! 2315: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0xd6c4c400  ! 2316: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r11
	.word 0xd2942000  ! 2317: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2c4a000  ! 2318: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	.word 0xdcc609e0  ! 2319: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r14
	.word 0x87802073  ! 2320: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f6c9e0  ! 2321: STXA_R	stxa	%r9, [%r27 + %r0] 0x4f
	.word 0xd8c5a000  ! 2322: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r12
	.word 0xd8c689e0  ! 2323: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r12
	.word 0xdcbd2000  ! 2324: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	mov	0x50, %r27
	.word 0xd0dc0400  ! 2326: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	mov	0x40, %r24
	.word 0xdac40400  ! 2328: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	mov	0x8, %r25
	.word 0x87802074  ! 2330: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 2331: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeaf4e40  ! 2332: STBA_R	stba	%r15, [%r29 + %r0] 0x72
	.word 0xd2b5c4a0  ! 2333: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	mov	0x7e8, %r21
	mov	0x48, %r25
	.word 0xd0f74e40  ! 2336: STXA_R	stxa	%r8, [%r29 + %r0] 0x72
	.word 0xdeac8400  ! 2337: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0x87802074  ! 2338: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a4c400  ! 2339: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xd0afce80  ! 2340: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	.word 0xd2a72000  ! 2341: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0xd8a5c4a0  ! 2342: STWA_R	stwa	%r12, [%r23 + %r0] 0x25
	mov	0x18, %r25
	.word 0xd0d48400  ! 2344: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	.word 0xd0df8e40  ! 2345: LDXA_R	ldxa	[%r30, %r0] 0x72, %r8
	.word 0x87802073  ! 2346: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f0, %r20
	.word 0xdebcc400  ! 2348: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	.word 0xdc9dc4a0  ! 2349: LDDA_R	ldda	[%r23, %r0] 0x25, %r14
	.word 0xda878e60  ! 2350: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r13
	.word 0xd88c4400  ! 2351: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0xd694a000  ! 2352: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r11
	mov	0x38, %r27
	mov	0x28, %r17
	.word 0xd89d84a0  ! 2355: LDDA_R	ldda	[%r22, %r0] 0x25, %r12
	mov	0x7e8, %r23
	.word 0x87802020  ! 2357: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf70e40  ! 2358: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	.word 0xd8c72000  ! 2359: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8dfa000  ! 2360: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	mov	0x48, %r19
	.word 0x87802025  ! 2362: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdedec9e0  ! 2363: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r15
	.word 0x87802025  ! 2364: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4a4c400  ! 2365: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0xd48ca000  ! 2366: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r10
	.word 0xd4942000  ! 2367: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r10
	.word 0xdc9f8e80  ! 2368: LDDA_R	ldda	[%r30, %r0] 0x74, %r14
	.word 0xdcd42000  ! 2369: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	.word 0xd2c70e80  ! 2370: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r9
	.word 0xdaa78e80  ! 2371: STWA_R	stwa	%r13, [%r30 + %r0] 0x74
	.word 0xd0a4a000  ! 2372: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0xd0bca000  ! 2373: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0xd094a000  ! 2374: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	.word 0xd6b70e80  ! 2375: STHA_R	stha	%r11, [%r28 + %r0] 0x74
	.word 0xdace89e0  ! 2376: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r13
	.word 0xd88c2000  ! 2377: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	.word 0xd6bdc4a0  ! 2378: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	.word 0xdabce000  ! 2379: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 2380: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a689e0  ! 2381: STWA_R	stwa	%r9, [%r26 + %r0] 0x4f
	.word 0xdeace000  ! 2382: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	mov	0x8, %r19
	.word 0x87802025  ! 2384: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd49c0400  ! 2385: LDDA_R	ldda	[%r16, %r0] 0x20, %r10
	.word 0xdca44400  ! 2386: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0xd0af0e80  ! 2387: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	.word 0xd4a5a000  ! 2388: STWA_I	stwa	%r10, [%r22 + 0x0000] %asi
	.word 0xd4d52000  ! 2389: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r10
	mov	0x58, %r27
	.word 0xd495e000  ! 2391: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r10
	.word 0xdaa74e40  ! 2392: STWA_R	stwa	%r13, [%r29 + %r0] 0x72
	mov	0x20, %r26
	mov	0x7d0, %r21
	.word 0xdadde000  ! 2395: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r13
	.word 0xd09e89e0  ! 2396: LDDA_R	ldda	[%r26, %r0] 0x4f, %r8
	mov	0x50, %r26
	.word 0xd2bd2000  ! 2398: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	.word 0xdcb584a0  ! 2399: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	mov	0x8, %r27
	.word 0x87802020  ! 2401: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebc2000  ! 2402: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xdab74e60  ! 2403: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	mov	0x3f0, %r20
	.word 0xd6dca000  ! 2405: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r11
	ta	T_CHANGE_PRIV	! macro
	.word 0xd6946000  ! 2407: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r11
	.word 0xd6aca000  ! 2408: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	mov	0x10, %r17
	mov	0x3d8, %r21
	mov	0x3d0, %r20
	.word 0xd88fce40  ! 2412: LDUBA_R	lduba	[%r31, %r0] 0x72, %r12
	.word 0xd6bd44a0  ! 2413: STDA_R	stda	%r11, [%r21 + %r0] 0x25
	.word 0xdcb46000  ! 2414: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xde870e40  ! 2415: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r15
	.word 0xd6b46000  ! 2416: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xdcf584a0  ! 2417: STXA_R	stxa	%r14, [%r22 + %r0] 0x25
	mov	0x10, %r16
	.word 0xdc946000  ! 2419: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r14
	.word 0xd6a504a0  ! 2420: STWA_R	stwa	%r11, [%r20 + %r0] 0x25
	mov	0x50, %r25
	.word 0xd6bc4400  ! 2422: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	.word 0xd6dce000  ! 2423: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0xd6bf4e40  ! 2424: STDA_R	stda	%r11, [%r29 + %r0] 0x72
	.word 0xd8dce000  ! 2425: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	.word 0xd09c8400  ! 2426: LDDA_R	ldda	[%r18, %r0] 0x20, %r8
	.word 0xdca74e60  ! 2427: STWA_R	stwa	%r14, [%r29 + %r0] 0x73
	mov	0x10, %r27
	.word 0xdcae89e0  ! 2429: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	.word 0xd284e000  ! 2430: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r9
	.word 0xd4cf8e40  ! 2431: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r10
	mov	0x38, %r19
	.word 0x87802025  ! 2433: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r19
	.word 0xd6aea000  ! 2435: STBA_I	stba	%r11, [%r26 + 0x0000] %asi
	.word 0xded74e80  ! 2436: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r15
	.word 0xd8ce2000  ! 2437: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r12
	mov	0x0, %r16
	.word 0x87802020  ! 2439: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2440: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b44400  ! 2441: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xde978e60  ! 2442: LDUHA_R	lduha	[%r30, %r0] 0x73, %r15
	.word 0xd8af0e60  ! 2443: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	.word 0xd8f7a000  ! 2444: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 2445: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ac0400  ! 2446: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	mov	0x38, %r17
	.word 0xd2bfce40  ! 2448: STDA_R	stda	%r9, [%r31 + %r0] 0x72
	.word 0xdea78e60  ! 2449: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	.word 0xde876000  ! 2450: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xdca48400  ! 2451: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xd6a7ce60  ! 2452: STWA_R	stwa	%r11, [%r31 + %r0] 0x73
	.word 0xdaa4c400  ! 2453: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	mov	0x30, %r19
	.word 0xd8c76000  ! 2455: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	.word 0xd2bf4e40  ! 2456: STDA_R	stda	%r9, [%r29 + %r0] 0x72
	mov	0x70, %r16
	.word 0xdec44400  ! 2458: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0xd69ec9e0  ! 2459: LDDA_R	ldda	[%r27, %r0] 0x4f, %r11
	.word 0xdec7a000  ! 2460: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xded72000  ! 2461: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xdcac4400  ! 2462: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	mov	0x7e8, %r23
	mov	0x10, %r27
	.word 0xdef504a0  ! 2465: STXA_R	stxa	%r15, [%r20 + %r0] 0x25
	.word 0xd6972000  ! 2466: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	mov	0x40, %r19
	.word 0xdea40400  ! 2468: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	mov	0x3e0, %r23
	.word 0xda9e09e0  ! 2470: LDDA_R	ldda	[%r24, %r0] 0x4f, %r13
	.word 0xd0cf2000  ! 2471: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0xd2d7ce80  ! 2472: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r9
	.word 0xd0a7e000  ! 2473: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 2474: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd08fa000  ! 2475: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	mov	0x40, %r19
	.word 0xd8b70e40  ! 2477: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0xd4f7a000  ! 2478: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4bfe000  ! 2479: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 2480: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r19
	.word 0xd4d46000  ! 2482: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r10
	mov	0x30, %r16
	.word 0x87802025  ! 2484: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc9f8e40  ! 2485: LDDA_R	ldda	[%r30, %r0] 0x72, %r14
	.word 0xd8b649e0  ! 2486: STHA_R	stha	%r12, [%r25 + %r0] 0x4f
	.word 0xd6f4c400  ! 2487: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0xd6cfe000  ! 2488: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0xd4c40400  ! 2489: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	mov	0x3e8, %r23
	.word 0xd2f40400  ! 2491: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xdacfa000  ! 2492: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xd0940400  ! 2493: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	.word 0xd4bf0e80  ! 2494: STDA_R	stda	%r10, [%r28 + %r0] 0x74
	.word 0xdecf2000  ! 2495: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xd2bf8e80  ! 2496: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	.word 0xd6c44400  ! 2497: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r11
	.word 0xded78e40  ! 2498: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r15
	.word 0xd89d84a0  ! 2499: LDDA_R	ldda	[%r22, %r0] 0x25, %r12
	.word 0x87802073  ! 2500: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r17
	.word 0xda97e000  ! 2502: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	mov	0x3f0, %r21
	.word 0xdaafe000  ! 2504: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xdaa7a000  ! 2505: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xd094c400  ! 2506: LDUHA_R	lduha	[%r19, %r0] 0x20, %r8
	.word 0xdcd76000  ! 2507: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	.word 0xdc976000  ! 2508: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	mov	0x3c0, %r22
	.word 0xdccf6000  ! 2510: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2511: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d689e0  ! 2512: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r9
	mov	0x3d8, %r21
	.word 0xd4b48400  ! 2514: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xdadf2000  ! 2515: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0xdaf7a000  ! 2516: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xd6c504a0  ! 2517: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r11
	mov	0x40, %r25
	.word 0xdaa7e000  ! 2519: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2520: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc8f8e80  ! 2521: LDUBA_R	lduba	[%r30, %r0] 0x74, %r14
	.word 0xd8dd84a0  ! 2522: LDXA_R	ldxa	[%r22, %r0] 0x25, %r12
	.word 0x87802074  ! 2523: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdac72000  ! 2524: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0x87802074  ! 2525: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdac46000  ! 2526: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r13
	mov	0x3e8, %r20
	mov	0x28, %r17
	.word 0xdab4a000  ! 2529: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0xdaa42000  ! 2531: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	mov	0x7d8, %r23
	mov	0x7d8, %r20
	mov	0x7e0, %r23
	mov	0x48, %r27
	.word 0xdaa46000  ! 2536: STWA_I	stwa	%r13, [%r17 + 0x0000] %asi
	mov	0x7d0, %r20
	.word 0xda8c6000  ! 2538: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r13
	.word 0xdcb4c400  ! 2539: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xdcf46000  ! 2540: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdca4a000  ! 2541: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcbca000  ! 2542: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xd4a5c4a0  ! 2543: STWA_R	stwa	%r10, [%r23 + %r0] 0x25
	.word 0xd8aca000  ! 2544: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	mov	0x3f0, %r21
	mov	0x7f8, %r20
	.word 0xd2af0e60  ! 2547: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd88c2000  ! 2549: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	mov	0x28, %r18
	.word 0x87802072  ! 2551: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde9544a0  ! 2552: LDUHA_R	lduha	[%r21, %r0] 0x25, %r15
	.word 0x87802020  ! 2553: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbfa000  ! 2554: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xd4f6c9e0  ! 2555: STXA_R	stxa	%r10, [%r27 + %r0] 0x4f
	.word 0xdef7a000  ! 2556: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	mov	0x7f0, %r20
	mov	0x40, %r27
	.word 0x87802020  ! 2559: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcd544a0  ! 2560: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r14
	.word 0xd4c609e0  ! 2561: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r10
	.word 0xd0ad6000  ! 2562: STBA_I	stba	%r8, [%r21 + 0x0000] %asi
	mov	0x60, %r17
	.word 0xdab74e60  ! 2564: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	.word 0xd0a52000  ! 2565: STWA_I	stwa	%r8, [%r20 + 0x0000] %asi
	.word 0xd0dde000  ! 2566: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r8
	.word 0xd0bda000  ! 2567: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	mov	0x50, %r17
	.word 0xd08de000  ! 2569: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r8
	mov	0x40, %r24
	mov	0x58, %r25
	.word 0x87802020  ! 2572: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b56000  ! 2573: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	.word 0xd0ad2000  ! 2574: STBA_I	stba	%r8, [%r20 + 0x0000] %asi
	.word 0xd095e000  ! 2575: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r8
	.word 0xd4dcc400  ! 2576: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0x87802020  ! 2577: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2578: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2579: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f78e80  ! 2580: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	.word 0xda872000  ! 2581: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	mov	0x40, %r17
	.word 0xd8dd44a0  ! 2583: LDXA_R	ldxa	[%r21, %r0] 0x25, %r12
	.word 0xd8b7a000  ! 2584: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 2585: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa44400  ! 2586: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0xdcbc4400  ! 2587: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0xd08ce000  ! 2588: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0ace000  ! 2589: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0xd08ca000  ! 2590: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0xd0a46000  ! 2591: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xd08ce000  ! 2592: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0d4a000  ! 2593: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	.word 0xd0b46000  ! 2594: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0xdede89e0  ! 2595: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x7f0, %r22
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd8dce000  ! 2599: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	.word 0xd8ac2000  ! 2600: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0xdac70e60  ! 2601: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r13
	.word 0x87802073  ! 2602: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda974e80  ! 2603: LDUHA_R	lduha	[%r29, %r0] 0x74, %r13
	.word 0xd48f6000  ! 2604: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xd28dc4a0  ! 2605: LDUBA_R	lduba	[%r23, %r0] 0x25, %r9
	.word 0xdeaf6000  ! 2606: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 2607: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2cfce80  ! 2608: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r9
	.word 0x87802025  ! 2609: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeac2000  ! 2610: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xde8ca000  ! 2611: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0x87802074  ! 2612: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xded76000  ! 2613: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	mov	0x7c0, %r20
	.word 0xded7a000  ! 2615: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	mov	0x3e8, %r21
	.word 0xdef72000  ! 2617: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xdabf4e80  ! 2618: STDA_R	stda	%r13, [%r29 + %r0] 0x74
	.word 0xd0af8e80  ! 2619: STBA_R	stba	%r8, [%r30 + %r0] 0x74
	.word 0xdcf7e000  ! 2620: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xd8acc400  ! 2621: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0xdeacc400  ! 2622: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0x87802073  ! 2623: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6a7ce40  ! 2624: STWA_R	stwa	%r11, [%r31 + %r0] 0x72
	mov	0x3c8, %r23
	mov	0x10, %r17
	.word 0x87802020  ! 2627: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeaf2000  ! 2628: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xdebfe000  ! 2629: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	mov	0x10, %r17
	mov	0x7d0, %r21
	.word 0xdecf6000  ! 2632: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0xdef76000  ! 2633: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdc8dc4a0  ! 2634: LDUBA_R	lduba	[%r23, %r0] 0x25, %r14
	.word 0xdaa72000  ! 2635: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 2636: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbf8e40  ! 2637: STDA_R	stda	%r14, [%r30 + %r0] 0x72
	.word 0xd4d78e40  ! 2638: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r10
	.word 0xd8bce000  ! 2639: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd8b4a000  ! 2640: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	mov	0x68, %r18
	.word 0x87802020  ! 2642: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bce000  ! 2643: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd8c4e000  ! 2644: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	mov	0x28, %r26
	mov	0x20, %r17
	.word 0xd8bf0e80  ! 2647: STDA_R	stda	%r12, [%r28 + %r0] 0x74
	.word 0xd68fce80  ! 2648: LDUBA_R	lduba	[%r31, %r0] 0x74, %r11
	.word 0xd4bce000  ! 2649: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0xdca649e0  ! 2650: STWA_R	stwa	%r14, [%r25 + %r0] 0x4f
	.word 0x87802073  ! 2651: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdec70e60  ! 2652: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r15
	.word 0xd095a000  ! 2653: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r8
	.word 0xd88c8400  ! 2654: LDUBA_R	lduba	[%r18, %r0] 0x20, %r12
	.word 0x87802074  ! 2655: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 2656: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd084e000  ! 2657: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	.word 0xdedc4400  ! 2658: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	.word 0xdede89e0  ! 2659: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r15
	.word 0x87802020  ! 2660: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2661: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0d6c9e0  ! 2662: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r8
	.word 0x87802074  ! 2663: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 2664: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2665: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd695a000  ! 2666: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r11
	.word 0x87802073  ! 2667: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdebfce40  ! 2668: STDA_R	stda	%r15, [%r31 + %r0] 0x72
	.word 0xdebf4e80  ! 2669: STDA_R	stda	%r15, [%r29 + %r0] 0x74
	.word 0xd2dc4400  ! 2670: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xdcdfe000  ! 2671: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	mov	0x3e0, %r20
	.word 0xdaf44400  ! 2673: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0xd89f6000  ! 2674: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	.word 0xd8f76000  ! 2675: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8d72000  ! 2676: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xd2b78e80  ! 2677: STHA_R	stha	%r9, [%r30 + %r0] 0x74
	mov	0x3e8, %r23
	.word 0xdab76000  ! 2679: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0xd8d70e80  ! 2681: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r12
	.word 0xd4bcc400  ! 2682: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0xd2c70e80  ! 2683: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r9
	.word 0xd6a78e40  ! 2684: STWA_R	stwa	%r11, [%r30 + %r0] 0x72
	.word 0xd6a72000  ! 2685: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6cf2000  ! 2686: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	mov	0x3d8, %r20
	.word 0x87802020  ! 2688: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r19
	.word 0xdcaf8e60  ! 2690: STBA_R	stba	%r14, [%r30 + %r0] 0x73
	.word 0x87802073  ! 2691: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b66000  ! 2692: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	.word 0xd6cfce40  ! 2693: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r11
	.word 0xd4c6e000  ! 2694: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r10
	.word 0xd4bee000  ! 2695: STDA_I	stda	%r10, [%r27 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0xdc848400  ! 2697: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	.word 0xd886e000  ! 2698: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r12
	.word 0xd0a6c9e0  ! 2699: STWA_R	stwa	%r8, [%r27 + %r0] 0x4f
	.word 0xdcad84a0  ! 2700: STBA_R	stba	%r14, [%r22 + %r0] 0x25
	.word 0xd08ea000  ! 2701: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r8
	.word 0xd4dcc400  ! 2702: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0xd6c78e80  ! 2703: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r11
	.word 0x87802020  ! 2704: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebc2000  ! 2705: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xd0b70e40  ! 2706: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	.word 0x87802072  ! 2707: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2cc0400  ! 2708: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r9
	.word 0xdeb72000  ! 2709: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xdc9f8e60  ! 2710: LDDA_R	ldda	[%r30, %r0] 0x73, %r14
	mov	0x7f0, %r23
	.word 0xdaafce80  ! 2712: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	.word 0xd88f8e40  ! 2713: LDUBA_R	lduba	[%r30, %r0] 0x72, %r12
	.word 0x8780204f  ! 2714: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdecce000  ! 2715: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	.word 0xde94e000  ! 2716: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	mov	0x60, %r19
	.word 0xd4bf8e80  ! 2718: STDA_R	stda	%r10, [%r30 + %r0] 0x74
	mov	0x18, %r18
	.word 0xd0a4a000  ! 2720: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0xd6b48400  ! 2721: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd4d42000  ! 2722: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	.word 0x87802074  ! 2723: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r24
	.word 0xde8504a0  ! 2725: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r15
	.word 0xd6cfa000  ! 2726: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0x87802072  ! 2727: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r25
	.word 0xde8689e0  ! 2729: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r15
	mov	0x3f8, %r23
	mov	0x3e8, %r23
	.word 0xdebc8400  ! 2732: STDA_R	stda	%r15, [%r18 + %r0] 0x20
	mov	0x7f8, %r21
	.word 0x87802020  ! 2734: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r22
	.word 0xd6dde000  ! 2736: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r11
	mov	0x3d0, %r23
	mov	0x40, %r18
	.word 0xd6bf4e60  ! 2739: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	.word 0xd2f7ce80  ! 2740: STXA_R	stxa	%r9, [%r31 + %r0] 0x74
	mov	0x3c0, %r22
	.word 0xd4c48400  ! 2742: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r10
	.word 0x8780204f  ! 2743: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r24
	.word 0xd6dda000  ! 2745: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r11
	.word 0xd6f5a000  ! 2746: STXA_I	stxa	%r11, [%r22 + 0x0000] %asi
	.word 0xd685e000  ! 2747: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r11
	mov	0x40, %r26
	.word 0xd29504a0  ! 2749: LDUHA_R	lduha	[%r20, %r0] 0x25, %r9
	.word 0xdef4c400  ! 2750: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	mov	0x60, %r25
	.word 0xdedf4e40  ! 2752: LDXA_R	ldxa	[%r29, %r0] 0x72, %r15
	mov	0x7d8, %r22
	.word 0xd0d40400  ! 2754: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	.word 0xd68f8e60  ! 2755: LDUBA_R	lduba	[%r30, %r0] 0x73, %r11
	mov	0x38, %r17
	.word 0xd4cec9e0  ! 2757: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r10
	.word 0xdaf78e80  ! 2758: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	.word 0xdcad44a0  ! 2759: STBA_R	stba	%r14, [%r21 + %r0] 0x25
	mov	0x28, %r18
	.word 0xd09de000  ! 2761: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r8
	.word 0xdea689e0  ! 2762: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	.word 0x8780204f  ! 2763: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 2764: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2765: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4af8e60  ! 2766: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	.word 0xd6878e80  ! 2767: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r11
	.word 0x87802073  ! 2768: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd28ce000  ! 2769: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	.word 0xd294e000  ! 2770: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	.word 0x87802072  ! 2771: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r19
	.word 0x87802072  ! 2773: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef6c9e0  ! 2774: STXA_R	stxa	%r15, [%r27 + %r0] 0x4f
	mov	0x7c0, %r23
	mov	0x38, %r18
	mov	0x7f8, %r21
	.word 0xd0f76000  ! 2778: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0x8780204f  ! 2780: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0af4e60  ! 2781: STBA_R	stba	%r8, [%r29 + %r0] 0x73
	mov	0x8, %r17
	.word 0xd2f66000  ! 2783: STXA_I	stxa	%r9, [%r25 + 0x0000] %asi
	.word 0xd2de6000  ! 2784: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2b66000  ! 2786: STHA_I	stha	%r9, [%r25 + 0x0000] %asi
	.word 0xd0a48400  ! 2787: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0xd8d78e60  ! 2788: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r12
	mov	0x3d8, %r23
	mov	0x50, %r27
	.word 0x87802074  ! 2791: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6bfce40  ! 2792: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	.word 0x87802074  ! 2793: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r26
	.word 0x87802072  ! 2795: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeae2000  ! 2796: STBA_I	stba	%r15, [%r24 + 0x0000] %asi
	.word 0xd8a6c9e0  ! 2797: STWA_R	stwa	%r12, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 2798: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2799: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c74e60  ! 2800: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r11
	.word 0xda87a000  ! 2801: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0xd4cfce60  ! 2802: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r10
	.word 0xdabfe000  ! 2803: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xdeac0400  ! 2804: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xd4f72000  ! 2805: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4a76000  ! 2806: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xdeccc400  ! 2807: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r15
	mov	0x60, %r17
	.word 0x87802020  ! 2809: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r19
	.word 0xda87e000  ! 2811: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0xda8f6000  ! 2812: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xdcd40400  ! 2813: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	mov	0x3f8, %r20
	.word 0xd48f6000  ! 2815: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 2816: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 2817: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r18
	mov	0x28, %r17
	.word 0xdebf4e60  ! 2820: STDA_R	stda	%r15, [%r29 + %r0] 0x73
	.word 0xd0d7a000  ! 2821: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	.word 0xd0a76000  ! 2822: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd69f8e80  ! 2823: LDDA_R	ldda	[%r30, %r0] 0x74, %r11
	.word 0xd097a000  ! 2824: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	.word 0xd4df8e60  ! 2825: LDXA_R	ldxa	[%r30, %r0] 0x73, %r10
	.word 0xde8c0400  ! 2826: LDUBA_R	lduba	[%r16, %r0] 0x20, %r15
	.word 0x87802073  ! 2827: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bf0e60  ! 2828: STDA_R	stda	%r11, [%r28 + %r0] 0x73
	.word 0xd09cc400  ! 2829: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	mov	0x3c0, %r21
	.word 0xd494e000  ! 2831: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r10
	mov	0x60, %r27
	.word 0xd0f609e0  ! 2833: STXA_R	stxa	%r8, [%r24 + %r0] 0x4f
	.word 0xde9c2000  ! 2834: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r15
	.word 0xdebca000  ! 2835: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xdeac2000  ! 2836: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xdea6c9e0  ! 2837: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	mov	0x8, %r16
	.word 0x87802020  ! 2839: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28c2000  ! 2840: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	mov	0x40, %r25
	mov	0x10, %r24
	.word 0xd284a000  ! 2843: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	.word 0xd0dc8400  ! 2844: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0xd0878e40  ! 2845: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r8
	.word 0x87802072  ! 2846: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2847: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf72000  ! 2848: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	mov	0x38, %r19
	.word 0xdc876000  ! 2850: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0x87802025  ! 2851: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802072  ! 2853: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcac0400  ! 2854: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	mov	0x3e0, %r23
	.word 0xdcb44400  ! 2856: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	mov	0x3f8, %r20
	.word 0xd6bf0e40  ! 2858: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	.word 0xdaa5c4a0  ! 2859: STWA_R	stwa	%r13, [%r23 + %r0] 0x25
	.word 0xd68f4e60  ! 2860: LDUBA_R	lduba	[%r29, %r0] 0x73, %r11
	.word 0xd4866000  ! 2861: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r10
	mov	0x7c8, %r20
	mov	0x3f0, %r23
	.word 0xd4a66000  ! 2864: STWA_I	stwa	%r10, [%r25 + 0x0000] %asi
	mov	0x18, %r27
	.word 0xd4a6a000  ! 2866: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	.word 0xd2cc8400  ! 2867: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0xdc9f0e80  ! 2868: LDDA_R	ldda	[%r28, %r0] 0x74, %r14
	.word 0xd2ae2000  ! 2869: STBA_I	stba	%r9, [%r24 + 0x0000] %asi
	.word 0xd28ee000  ! 2870: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r9
	mov	0x3d8, %r22
	.word 0xd2cee000  ! 2872: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r9
	.word 0xd2de2000  ! 2873: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r9
	.word 0xd8d40400  ! 2874: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	.word 0xd4840400  ! 2875: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	.word 0xdea62000  ! 2876: STWA_I	stwa	%r15, [%r24 + 0x0000] %asi
	.word 0xdef6a000  ! 2877: STXA_I	stxa	%r15, [%r26 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xd4ae09e0  ! 2879: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	mov	0x7d8, %r21
	.word 0xd6a40400  ! 2881: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	ta	T_CHANGE_PRIV	! macro
	.word 0xdac78e60  ! 2883: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r13
	.word 0xdca74e60  ! 2884: STWA_R	stwa	%r14, [%r29 + %r0] 0x73
	.word 0xd6bee000  ! 2885: STDA_I	stda	%r11, [%r27 + 0x0000] %asi
	.word 0xd4ae09e0  ! 2886: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	mov	0x50, %r18
	.word 0xd8b584a0  ! 2888: STHA_R	stha	%r12, [%r22 + %r0] 0x25
	.word 0xd8bfce80  ! 2889: STDA_R	stda	%r12, [%r31 + %r0] 0x74
	.word 0xde9c4400  ! 2890: LDDA_R	ldda	[%r17, %r0] 0x20, %r15
	.word 0x87802020  ! 2891: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r23
	.word 0xd4c40400  ! 2893: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	.word 0xd8df4e80  ! 2894: LDXA_R	ldxa	[%r29, %r0] 0x74, %r12
	.word 0xd6972000  ! 2895: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	.word 0xd6d76000  ! 2896: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	mov	0x7e0, %r21
	.word 0xd0a70e60  ! 2898: STWA_R	stwa	%r8, [%r28 + %r0] 0x73
	.word 0xdccc4400  ! 2899: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r14
	.word 0xd48f0e60  ! 2900: LDUBA_R	lduba	[%r28, %r0] 0x73, %r10
	mov	0x20, %r17
	mov	0x18, %r16
	.word 0xd2af4e40  ! 2903: STBA_R	stba	%r9, [%r29 + %r0] 0x72
	.word 0xdecfce40  ! 2904: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r15
	.word 0xdc878e60  ! 2905: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r14
	.word 0xd2f7ce80  ! 2906: STXA_R	stxa	%r9, [%r31 + %r0] 0x74
	mov	0x38, %r27
	.word 0xdabf6000  ! 2908: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	mov	0x28, %r19
	mov	0x20, %r16
	.word 0xd89544a0  ! 2911: LDUHA_R	lduha	[%r21, %r0] 0x25, %r12
	.word 0xd0af2000  ! 2912: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0bf2000  ! 2913: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 2914: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd097a000  ! 2915: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	.word 0xd0bc8400  ! 2916: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	mov	0x40, %r27
	.word 0x87802020  ! 2918: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r23
	.word 0xdcac4400  ! 2920: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	.word 0xdef5a000  ! 2921: STXA_I	stxa	%r15, [%r22 + 0x0000] %asi
	.word 0xd2b649e0  ! 2922: STHA_R	stha	%r9, [%r25 + %r0] 0x4f
	.word 0xd6cda000  ! 2923: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r11
	.word 0xdacf8e60  ! 2924: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r13
	ta	T_CHANGE_HPRIV	! macro
	mov	0x20, %r18
	.word 0xdeade000  ! 2927: STBA_I	stba	%r15, [%r23 + 0x0000] %asi
	.word 0xd28584a0  ! 2928: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r9
	.word 0xdaade000  ! 2929: STBA_I	stba	%r13, [%r23 + 0x0000] %asi
	.word 0xdaada000  ! 2930: STBA_I	stba	%r13, [%r22 + 0x0000] %asi
	.word 0xda85e000  ! 2931: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	.word 0xdab5e000  ! 2932: STHA_I	stha	%r13, [%r23 + 0x0000] %asi
	mov	0x18, %r24
	mov	0x60, %r17
	mov	0x38, %r24
	.word 0xd49d84a0  ! 2936: LDDA_R	ldda	[%r22, %r0] 0x25, %r10
	.word 0xdabf0e80  ! 2937: STDA_R	stda	%r13, [%r28 + %r0] 0x74
	.word 0xd2dec9e0  ! 2938: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd68f4e80  ! 2940: LDUBA_R	lduba	[%r29, %r0] 0x74, %r11
	.word 0xd2cf8e80  ! 2941: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r9
	.word 0x87802025  ! 2942: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2af0e60  ! 2943: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	.word 0xd8afce40  ! 2944: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	.word 0x87802074  ! 2945: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2946: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca40400  ! 2947: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xdadc6000  ! 2948: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xda9c2000  ! 2949: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	.word 0xd6a4c400  ! 2950: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0xdcb4e000  ! 2951: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xd8d74e80  ! 2952: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r12
	mov	0x20, %r18
	.word 0xd2a689e0  ! 2954: STWA_R	stwa	%r9, [%r26 + %r0] 0x4f
	mov	0x50, %r26
	.word 0xd8f584a0  ! 2956: STXA_R	stxa	%r12, [%r22 + %r0] 0x25
	.word 0xdca7ce80  ! 2957: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	.word 0xd0a44400  ! 2958: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xd4874e80  ! 2959: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r10
	mov	0x7c8, %r22
	mov	0x10, %r16
	.word 0xdcb42000  ! 2962: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 2963: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2964: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2965: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r27
	.word 0xdc97a000  ! 2967: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	.word 0xdca76000  ! 2968: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcb72000  ! 2969: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xd2bd04a0  ! 2970: STDA_R	stda	%r9, [%r20 + %r0] 0x25
	mov	0x60, %r27
	.word 0xd69fa000  ! 2972: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0xdadfce40  ! 2973: LDXA_R	ldxa	[%r31, %r0] 0x72, %r13
	.word 0xd2a7a000  ! 2974: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xd6d78e60  ! 2975: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r11
	.word 0xd0978e40  ! 2976: LDUHA_R	lduha	[%r30, %r0] 0x72, %r8
	mov	0x8, %r19
	.word 0xd8dd44a0  ! 2978: LDXA_R	ldxa	[%r21, %r0] 0x25, %r12
	.word 0xd2af8e60  ! 2979: STBA_R	stba	%r9, [%r30 + %r0] 0x73
	.word 0xd8cf0e80  ! 2980: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r12
	.word 0xdcb689e0  ! 2981: STHA_R	stha	%r14, [%r26 + %r0] 0x4f
	.word 0xd6d76000  ! 2982: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	mov	0x60, %r19
	.word 0xd69fa000  ! 2984: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0xdccc8400  ! 2985: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	.word 0xd2b72000  ! 2986: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xdab6c9e0  ! 2987: STHA_R	stha	%r13, [%r27 + %r0] 0x4f
	mov	0x68, %r18
	.word 0xde97a000  ! 2989: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	.word 0xd2d40400  ! 2990: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	mov	0x38, %r26
	.word 0xdc87e000  ! 2992: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xd297ce40  ! 2993: LDUHA_R	lduha	[%r31, %r0] 0x72, %r9
	.word 0x87802073  ! 2994: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8c40400  ! 2995: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	.word 0xd88dc4a0  ! 2996: LDUBA_R	lduba	[%r23, %r0] 0x25, %r12
	.word 0x87802025  ! 2997: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbee000  ! 2998: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	mov	0x70, %r18
	.word 0xde970e40  ! 3000: LDUHA_R	lduha	[%r28, %r0] 0x72, %r15
	.word 0x87802025  ! 3001: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4b46000  ! 3002: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xd4a4a000  ! 3003: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xd49ce000  ! 3004: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0xdcbd84a0  ! 3005: STDA_R	stda	%r14, [%r22 + %r0] 0x25
	.word 0x8780204f  ! 3006: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a4e000  ! 3007: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2a4e000  ! 3008: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0xdab78e60  ! 3009: STHA_R	stha	%r13, [%r30 + %r0] 0x73
	.word 0xdabce000  ! 3010: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	mov	0x40, %r24
	.word 0xd8cf0e40  ! 3012: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r12
	.word 0xda8f8e80  ! 3013: LDUBA_R	lduba	[%r30, %r0] 0x74, %r13
	ta	T_CHANGE_PRIV	! macro
	mov	0x30, %r27
	.word 0xd0b44400  ! 3016: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xdebf0e40  ! 3017: STDA_R	stda	%r15, [%r28 + %r0] 0x72
	.word 0xd4d42000  ! 3018: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	.word 0xd6bf4e60  ! 3019: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	.word 0xdabd84a0  ! 3020: STDA_R	stda	%r13, [%r22 + %r0] 0x25
	.word 0xd49ce000  ! 3021: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0xd4cc2000  ! 3022: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	mov	0x28, %r19
	.word 0x87802072  ! 3024: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a66000  ! 3025: STWA_I	stwa	%r10, [%r25 + 0x0000] %asi
	.word 0xdcb584a0  ! 3026: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	.word 0xd2c62000  ! 3027: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r9
	.word 0x87802072  ! 3028: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3029: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r24
	mov	0x70, %r18
	.word 0xd0a44400  ! 3032: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xdc9f4e80  ! 3033: LDDA_R	ldda	[%r29, %r0] 0x74, %r14
	.word 0xdeac0400  ! 3034: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0x87802020  ! 3035: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r24
	mov	0x68, %r24
	.word 0xd8d76000  ! 3038: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xd89fa000  ! 3039: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	.word 0xdcb649e0  ! 3040: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	.word 0xd287e000  ! 3041: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0xd4c504a0  ! 3042: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r10
	.word 0xd8c74e60  ! 3043: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r12
	.word 0x87802072  ! 3044: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3045: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 3046: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a70e40  ! 3047: STWA_R	stwa	%r10, [%r28 + %r0] 0x72
	.word 0x87802020  ! 3048: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd89f8e40  ! 3049: LDDA_R	ldda	[%r30, %r0] 0x72, %r12
	.word 0xd6b6c9e0  ! 3050: STHA_R	stha	%r11, [%r27 + %r0] 0x4f
	.word 0xd29e49e0  ! 3051: LDDA_R	ldda	[%r25, %r0] 0x4f, %r9
	.word 0xd2afe000  ! 3052: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	mov	0x0, %r24
	.word 0x87802025  ! 3054: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2972000  ! 3055: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	mov	0x3c8, %r21
	.word 0xd49d84a0  ! 3057: LDDA_R	ldda	[%r22, %r0] 0x25, %r10
	.word 0xd8cfce40  ! 3058: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r12
	.word 0xd6bfa000  ! 3059: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	mov	0x7f0, %r21
	.word 0x87802025  ! 3061: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8cfce80  ! 3062: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r12
	.word 0xd2c609e0  ! 3063: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r9
	.word 0xdcbc8400  ! 3064: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xdeb78e40  ! 3065: STHA_R	stha	%r15, [%r30 + %r0] 0x72
	.word 0x87802072  ! 3066: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3e0, %r23
	.word 0xd0c66000  ! 3068: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r8
	mov	0x7d0, %r23
	mov	0x68, %r16
	mov	0x18, %r26
	.word 0xd2b4c400  ! 3072: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	mov	0x8, %r27
	mov	0x3e8, %r20
	.word 0xd4bee000  ! 3075: STDA_I	stda	%r10, [%r27 + 0x0000] %asi
	.word 0xd4bee000  ! 3076: STDA_I	stda	%r10, [%r27 + 0x0000] %asi
	mov	0x10, %r24
	.word 0xde87ce80  ! 3078: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r15
	mov	0x48, %r24
	.word 0xdecfce60  ! 3080: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r15
	.word 0xdabc8400  ! 3081: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	.word 0x87802074  ! 3082: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4f72000  ! 3083: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4b72000  ! 3084: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0xd4cf2000  ! 3085: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xdeb4c400  ! 3086: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xd8f72000  ! 3087: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8a504a0  ! 3088: STWA_R	stwa	%r12, [%r20 + %r0] 0x25
	.word 0xd0cf4e40  ! 3089: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	.word 0xd6cf2000  ! 3090: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0xd6cfe000  ! 3091: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0xd6bf6000  ! 3092: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd6ae09e0  ! 3093: STBA_R	stba	%r11, [%r24 + %r0] 0x4f
	mov	0x7f0, %r21
	.word 0xdcf72000  ! 3095: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdc97e000  ! 3096: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xdcd72000  ! 3097: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0x87802025  ! 3098: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbe2000  ! 3099: STDA_I	stda	%r14, [%r24 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0xdc866000  ! 3101: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r14
	.word 0x87802025  ! 3102: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda874e80  ! 3103: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r13
	.word 0xd89f0e80  ! 3104: LDDA_R	ldda	[%r28, %r0] 0x74, %r12
	.word 0xd2d4e000  ! 3105: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0xd0be89e0  ! 3106: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	.word 0xdc878e40  ! 3107: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r14
	mov	0x8, %r26
	.word 0xd4ac6000  ! 3109: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3110: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8f4e60  ! 3111: LDUBA_R	lduba	[%r29, %r0] 0x73, %r15
	.word 0xd6bf6000  ! 3112: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd6a7a000  ! 3113: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xd0df4e80  ! 3115: LDXA_R	ldxa	[%r29, %r0] 0x74, %r8
	.word 0xdaa609e0  ! 3116: STWA_R	stwa	%r13, [%r24 + %r0] 0x4f
	mov	0x48, %r24
	.word 0xd0cc8400  ! 3118: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0x87802074  ! 3119: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda8c0400  ! 3120: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	mov	0x68, %r24
	.word 0xdca42000  ! 3122: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xdcaca000  ! 3123: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 3124: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r22
	.word 0xdcace000  ! 3126: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	mov	0x0, %r18
	mov	0x10, %r18
	.word 0xd6b4c400  ! 3129: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	mov	0x7c0, %r21
	.word 0x87802020  ! 3131: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3132: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3133: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc876000  ! 3134: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0x87802074  ! 3135: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r27
	mov	0x3c0, %r20
	.word 0xd2b48400  ! 3138: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 3139: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd09c2000  ! 3140: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r8
	.word 0xd0a42000  ! 3141: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xd09c0400  ! 3142: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	mov	0x58, %r19
	mov	0x0, %r27
	.word 0xd6b7ce60  ! 3145: STHA_R	stha	%r11, [%r31 + %r0] 0x73
	mov	0x48, %r18
	.word 0x87802074  ! 3147: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r26
	mov	0x70, %r27
	.word 0xdedd44a0  ! 3150: LDXA_R	ldxa	[%r21, %r0] 0x25, %r15
	.word 0xd4afe000  ! 3151: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd8b44400  ! 3152: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0x87802020  ! 3153: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r20
	.word 0xd68fa000  ! 3155: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3156: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r18
	mov	0x18, %r24
	mov	0x28, %r19
	.word 0xd8afce40  ! 3160: STBA_R	stba	%r12, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 3161: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd09c6000  ! 3162: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r8
	.word 0xd8c584a0  ! 3163: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r12
	.word 0x87802020  ! 3164: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6870e80  ! 3165: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r11
	.word 0xd2b7ce60  ! 3166: STHA_R	stha	%r9, [%r31 + %r0] 0x73
	.word 0xdcdf2000  ! 3167: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	mov	0x58, %r16
	.word 0xd8acc400  ! 3169: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0xd8cf8e60  ! 3170: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r12
	mov	0x20, %r18
	mov	0x60, %r18
	.word 0xde844400  ! 3173: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	.word 0x8780204f  ! 3174: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r25
	mov	0x28, %r27
	.word 0xdcb40400  ! 3177: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xded4c400  ! 3178: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r15
	mov	0x28, %r26
	.word 0xd6aec9e0  ! 3180: STBA_R	stba	%r11, [%r27 + %r0] 0x4f
	.word 0xd086e000  ! 3181: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r8
	.word 0xd08ea000  ! 3182: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r8
	.word 0xd2dc4400  ! 3183: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xd29f8e60  ! 3184: LDDA_R	ldda	[%r30, %r0] 0x73, %r9
	mov	0x40, %r18
	.word 0xd8bf8e40  ! 3186: STDA_R	stda	%r12, [%r30 + %r0] 0x72
	mov	0x7c0, %r21
	mov	0x58, %r19
	.word 0xdabe6000  ! 3189: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	.word 0xde9e09e0  ! 3190: LDDA_R	ldda	[%r24, %r0] 0x4f, %r15
	.word 0xdcaf4e60  ! 3191: STBA_R	stba	%r14, [%r29 + %r0] 0x73
	.word 0xd8dc4400  ! 3192: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0x87802073  ! 3193: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d0, %r22
	mov	0x58, %r26
	.word 0xdeb46000  ! 3196: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 3197: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r17
	.word 0xd48c4400  ! 3199: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0xded609e0  ! 3200: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r15
	.word 0xda9c4400  ! 3201: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	mov	0x78, %r18
	mov	0x38, %r26
	.word 0x87802020  ! 3204: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b72000  ! 3205: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd09f2000  ! 3206: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	.word 0xd69584a0  ! 3207: LDUHA_R	lduha	[%r22, %r0] 0x25, %r11
	.word 0xdac78e60  ! 3208: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r13
	.word 0xdad78e40  ! 3209: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r13
	.word 0xd0be09e0  ! 3210: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0x87802072  ! 3211: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 3212: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb74e80  ! 3213: STHA_R	stha	%r15, [%r29 + %r0] 0x74
	.word 0x87802073  ! 3214: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bdc4a0  ! 3215: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	.word 0xd0bdc4a0  ! 3216: STDA_R	stda	%r8, [%r23 + %r0] 0x25
	.word 0x8780204f  ! 3217: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc94e000  ! 3218: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	mov	0x3f0, %r21
	mov	0x68, %r17
	mov	0x7e8, %r23
	mov	0x3e0, %r22
	.word 0x8780204f  ! 3223: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 3224: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 3225: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdccee000  ! 3226: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r14
	.word 0xdea7ce80  ! 3227: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	.word 0xd4b66000  ! 3228: STHA_I	stha	%r10, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 3229: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3230: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r18
	.word 0xd2c6c9e0  ! 3232: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r9
	.word 0xd4df2000  ! 3233: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4bfa000  ! 3234: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd087ce80  ! 3235: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r8
	mov	0x0, %r24
	.word 0x8780204f  ! 3237: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 3238: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r19
	.word 0xd6b4e000  ! 3240: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xd4d48400  ! 3241: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	.word 0xdaa4c400  ! 3242: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0xd4f78e80  ! 3243: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	.word 0x87802072  ! 3244: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6a44400  ! 3245: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0xd2f42000  ! 3246: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0xd2aca000  ! 3247: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	mov	0x48, %r17
	mov	0x38, %r17
	.word 0x87802072  ! 3250: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 3251: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6d40400  ! 3252: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	mov	0x3f8, %r22
	mov	0x38, %r26
	.word 0xd29f2000  ! 3255: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd2972000  ! 3256: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xd2b7a000  ! 3257: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 3258: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd28ca000  ! 3259: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0x87802073  ! 3260: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2c72000  ! 3261: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2b76000  ! 3262: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd4b7ce40  ! 3263: STHA_R	stha	%r10, [%r31 + %r0] 0x72
	.word 0xdebf0e60  ! 3264: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	.word 0xdcde49e0  ! 3265: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r14
	.word 0xd6afa000  ! 3266: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6c72000  ! 3267: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0xd2c74e60  ! 3268: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r9
	.word 0xdad7e000  ! 3269: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	.word 0xda972000  ! 3270: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0xda8f4e40  ! 3271: LDUBA_R	lduba	[%r29, %r0] 0x72, %r13
	mov	0x70, %r17
	.word 0xdea72000  ! 3273: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xd49f0e40  ! 3274: LDDA_R	ldda	[%r28, %r0] 0x72, %r10
	.word 0xd6d44400  ! 3275: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r11
	.word 0xdaa4c400  ! 3276: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0xdeb72000  ! 3277: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	mov	0x18, %r16
	.word 0xded76000  ! 3279: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0xdcb609e0  ! 3280: STHA_R	stha	%r14, [%r24 + %r0] 0x4f
	.word 0xdcd72000  ! 3281: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xd0bf4e40  ! 3282: STDA_R	stda	%r8, [%r29 + %r0] 0x72
	.word 0xdabf8e40  ! 3283: STDA_R	stda	%r13, [%r30 + %r0] 0x72
	.word 0xdebfa000  ! 3284: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xde8f6000  ! 3285: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	.word 0x87802072  ! 3286: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d0, %r20
	.word 0x8780204f  ! 3288: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdef76000  ! 3289: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 3290: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdecde000  ! 3291: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r15
	mov	0x7c8, %r21
	.word 0xde8d6000  ! 3293: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r15
	mov	0x38, %r16
	.word 0x87802020  ! 3295: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f584a0  ! 3296: STXA_R	stxa	%r10, [%r22 + %r0] 0x25
	.word 0xd4ce49e0  ! 3297: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r10
	.word 0xdeafe000  ! 3298: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xde9f0e80  ! 3299: LDDA_R	ldda	[%r28, %r0] 0x74, %r15
	mov	0x18, %r25
	mov	0x3c0, %r23
	.word 0xde8fce60  ! 3302: LDUBA_R	lduba	[%r31, %r0] 0x73, %r15
	.word 0xd4dd04a0  ! 3303: LDXA_R	ldxa	[%r20, %r0] 0x25, %r10
	.word 0x87802025  ! 3304: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd28ea000  ! 3305: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r9
	.word 0xd286a000  ! 3306: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r9
	.word 0xd2d7ce80  ! 3307: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r9
	.word 0xdad6a000  ! 3308: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r13
	.word 0xdac62000  ! 3309: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r13
	mov	0x40, %r18
	.word 0xd2bf0e40  ! 3311: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	.word 0xd0d6c9e0  ! 3312: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r8
	.word 0xd4b70e60  ! 3313: STHA_R	stha	%r10, [%r28 + %r0] 0x73
	.word 0xdc866000  ! 3314: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 3315: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4848400  ! 3316: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r10
	.word 0xd2f42000  ! 3317: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0xd2ac2000  ! 3318: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd8f70e80  ! 3319: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	.word 0xdebc2000  ! 3320: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xdec4a000  ! 3321: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xdef78e40  ! 3322: STXA_R	stxa	%r15, [%r30 + %r0] 0x72
	.word 0xd29e09e0  ! 3323: LDDA_R	ldda	[%r24, %r0] 0x4f, %r9
	mov	0x10, %r27
	.word 0xd2f4a000  ! 3325: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0xd2c4a000  ! 3326: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	.word 0xde84c400  ! 3327: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0x8780204f  ! 3328: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r27
	mov	0x3d0, %r22
	mov	0x7c8, %r22
	.word 0xd6bfce60  ! 3332: STDA_R	stda	%r11, [%r31 + %r0] 0x73
	mov	0x70, %r27
	.word 0xdeace000  ! 3334: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xdea46000  ! 3335: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xdebc2000  ! 3336: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	mov	0x7d0, %r22
	mov	0x28, %r24
	mov	0x7e8, %r22
	.word 0xd4948400  ! 3340: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	.word 0xd0a48400  ! 3341: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0x87802025  ! 3342: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcac2000  ! 3343: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0xdca4c400  ! 3344: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xdcbce000  ! 3345: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xdcb46000  ! 3346: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3347: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r26
	mov	0x7c0, %r21
	.word 0xd8a7ce60  ! 3350: STWA_R	stwa	%r12, [%r31 + %r0] 0x73
	.word 0xdedc8400  ! 3351: LDXA_R	ldxa	[%r18, %r0] 0x20, %r15
	.word 0xd6ac8400  ! 3352: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xdcc52000  ! 3353: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r14
	.word 0xdcdd6000  ! 3354: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r14
	mov	0x40, %r25
	.word 0xdcbda000  ! 3356: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	mov	0x7e8, %r23
	mov	0x40, %r26
	.word 0xdc9f4e60  ! 3359: LDDA_R	ldda	[%r29, %r0] 0x73, %r14
	.word 0xdcdfce60  ! 3360: LDXA_R	ldxa	[%r31, %r0] 0x73, %r14
	.word 0xd4dd2000  ! 3361: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r10
	.word 0xd4f52000  ! 3362: STXA_I	stxa	%r10, [%r20 + 0x0000] %asi
	.word 0xd4ad6000  ! 3363: STBA_I	stba	%r10, [%r21 + 0x0000] %asi
	mov	0x10, %r26
	.word 0xdcac0400  ! 3365: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	mov	0x70, %r16
	mov	0x68, %r18
	.word 0xd6bda000  ! 3368: STDA_I	stda	%r11, [%r22 + 0x0000] %asi
	.word 0xd2cc8400  ! 3369: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0x87802020  ! 3370: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49ea000  ! 3371: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	mov	0x38, %r27
	.word 0xd4f6a000  ! 3373: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	.word 0xd4a6a000  ! 3374: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xd4ac4400  ! 3376: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 3377: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x0, %r24
	.word 0xdcd70e60  ! 3379: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r14
	.word 0xda9c2000  ! 3380: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r13
	.word 0xd2a689e0  ! 3381: STWA_R	stwa	%r9, [%r26 + %r0] 0x4f
	.word 0x8780204f  ! 3382: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd29cc400  ! 3383: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	.word 0xd0bc2000  ! 3384: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	mov	0x38, %r16
	.word 0xdac70e80  ! 3386: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r13
	.word 0xded46000  ! 3387: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	mov	0x58, %r27
	.word 0xdebce000  ! 3389: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	mov	0x7f0, %r23
	mov	0x28, %r24
	.word 0xdedce000  ! 3392: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r15
	mov	0x7e8, %r22
	mov	0x38, %r16
	mov	0x18, %r25
	.word 0xdc86c9e0  ! 3396: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r14
	.word 0xd2bf8e60  ! 3397: STDA_R	stda	%r9, [%r30 + %r0] 0x73
	.word 0xd0a7ce80  ! 3398: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	.word 0xd2dd04a0  ! 3399: LDXA_R	ldxa	[%r20, %r0] 0x25, %r9
	mov	0x7e8, %r21
	mov	0x30, %r16
	mov	0x58, %r18
	.word 0xd8b44400  ! 3403: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 3404: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf56000  ! 3405: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 3406: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadd2000  ! 3407: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r13
	mov	0x78, %r19
	.word 0xdabd2000  ! 3409: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	mov	0x78, %r26
	mov	0x3f0, %r23
	.word 0xdadda000  ! 3412: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r13
	.word 0xd4b4c400  ! 3413: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	mov	0x20, %r18
	.word 0xd0dd6000  ! 3415: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r8
	.word 0xd0ae49e0  ! 3416: STBA_R	stba	%r8, [%r25 + %r0] 0x4f
	.word 0xdabe49e0  ! 3417: STDA_R	stda	%r13, [%r25 + %r0] 0x4f
	.word 0xd4b78e40  ! 3418: STHA_R	stha	%r10, [%r30 + %r0] 0x72
	.word 0xdeb40400  ! 3419: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0xd4b5a000  ! 3420: STHA_I	stha	%r10, [%r22 + 0x0000] %asi
	.word 0xd4a5e000  ! 3421: STWA_I	stwa	%r10, [%r23 + 0x0000] %asi
	.word 0xdaafce60  ! 3422: STBA_R	stba	%r13, [%r31 + %r0] 0x73
	.word 0xdedc0400  ! 3423: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	.word 0xd8b5e000  ! 3424: STHA_I	stha	%r12, [%r23 + 0x0000] %asi
	.word 0xd6d649e0  ! 3425: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r11
	.word 0xd6c74e60  ! 3426: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r11
	mov	0x7d8, %r21
	mov	0x8, %r19
	.word 0xd0dcc400  ! 3429: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	mov	0x58, %r27
	.word 0x87802025  ! 3431: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcc7ce60  ! 3432: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r14
	.word 0x8780204f  ! 3433: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3434: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f72000  ! 3435: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd2bf6000  ! 3436: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0xdabfce40  ! 3438: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	mov	0x28, %r16
	.word 0xd0b48400  ! 3440: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xd2bf4e40  ! 3441: STDA_R	stda	%r9, [%r29 + %r0] 0x72
	.word 0xdebf6000  ! 3442: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xdaa70e40  ! 3443: STWA_R	stwa	%r13, [%r28 + %r0] 0x72
	.word 0x87802020  ! 3444: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3445: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r27
	.word 0xdca56000  ! 3447: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	.word 0xd0944400  ! 3448: LDUHA_R	lduha	[%r17, %r0] 0x20, %r8
	.word 0xd2a7ce40  ! 3449: STWA_R	stwa	%r9, [%r31 + %r0] 0x72
	.word 0xdad504a0  ! 3450: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r13
	.word 0xdcade000  ! 3451: STBA_I	stba	%r14, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 3452: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf76000  ! 3453: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 3454: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r16
	mov	0x48, %r18
	.word 0xdcaf2000  ! 3457: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdc9f2000  ! 3458: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r14
	.word 0x87802020  ! 3459: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 3460: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcb46000  ! 3461: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	mov	0x68, %r27
	.word 0xdcd42000  ! 3463: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	mov	0x3f8, %r22
	.word 0x87802020  ! 3465: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c78e80  ! 3466: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r9
	.word 0xdad48400  ! 3467: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0xd28fe000  ! 3468: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	.word 0xd8df4e40  ! 3469: LDXA_R	ldxa	[%r29, %r0] 0x72, %r12
	.word 0xdea44400  ! 3470: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xd4bfce60  ! 3471: STDA_R	stda	%r10, [%r31 + %r0] 0x73
	.word 0xda9f2000  ! 3472: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xdaaf6000  ! 3473: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 3474: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8fe000  ! 3475: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	mov	0x58, %r18
	mov	0x58, %r19
	mov	0x78, %r19
	.word 0xdaaf6000  ! 3479: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xde8504a0  ! 3480: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r15
	.word 0xd2f7ce60  ! 3481: STXA_R	stxa	%r9, [%r31 + %r0] 0x73
	.word 0xd6bf4e80  ! 3482: STDA_R	stda	%r11, [%r29 + %r0] 0x74
	mov	0x10, %r25
	.word 0xd88f2000  ! 3484: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0xd8c72000  ! 3485: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd6dd04a0  ! 3486: LDXA_R	ldxa	[%r20, %r0] 0x25, %r11
	mov	0x40, %r26
	.word 0xd0dfe000  ! 3488: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xd295c4a0  ! 3489: LDUHA_R	lduha	[%r23, %r0] 0x25, %r9
	.word 0x87802072  ! 3490: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeacc400  ! 3491: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xdece09e0  ! 3492: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r15
	.word 0xdabdc4a0  ! 3493: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	.word 0xdcf4a000  ! 3494: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcd46000  ! 3495: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	.word 0xdeaf4e80  ! 3496: STBA_R	stba	%r15, [%r29 + %r0] 0x74
	.word 0xd8b78e40  ! 3497: STHA_R	stha	%r12, [%r30 + %r0] 0x72
	.word 0x87802020  ! 3498: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bce000  ! 3499: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0xd4942000  ! 3500: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r10
	.word 0xd4c4a000  ! 3501: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	mov	0x3c0, %r21
	.word 0x87802025  ! 3503: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6acc400  ! 3504: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xd4c5c4a0  ! 3505: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r10
	.word 0x87802020  ! 3506: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49c0400  ! 3507: LDDA_R	ldda	[%r16, %r0] 0x20, %r10
	mov	0x7d0, %r23
	.word 0xd89cc400  ! 3509: LDDA_R	ldda	[%r19, %r0] 0x20, %r12
	.word 0x87802025  ! 3510: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdec4e000  ! 3511: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	.word 0xdebc8400  ! 3512: STDA_R	stda	%r15, [%r18 + %r0] 0x20
	mov	0x18, %r26
	mov	0x0, %r16
	.word 0xd0a78e80  ! 3515: STWA_R	stwa	%r8, [%r30 + %r0] 0x74
	.word 0xd48ce000  ! 3516: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r10
	.word 0xd4a46000  ! 3517: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xd0d5c4a0  ! 3518: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r8
	.word 0xdace89e0  ! 3519: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r13
	.word 0xdedfce40  ! 3520: LDXA_R	ldxa	[%r31, %r0] 0x72, %r15
	.word 0xd8ac4400  ! 3521: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0x87802073  ! 3522: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f544a0  ! 3523: STXA_R	stxa	%r10, [%r21 + %r0] 0x25
	.word 0x87802020  ! 3524: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r18
	.word 0xd6bf0e80  ! 3526: STDA_R	stda	%r11, [%r28 + %r0] 0x74
	.word 0xd68ce000  ! 3527: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	.word 0xd89fce80  ! 3528: LDDA_R	ldda	[%r31, %r0] 0x74, %r12
	.word 0xd0ac6000  ! 3529: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0xd0f46000  ! 3530: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xd08fce40  ! 3531: LDUBA_R	lduba	[%r31, %r0] 0x72, %r8
	.word 0xdec4e000  ! 3532: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	.word 0xd2af8e60  ! 3533: STBA_R	stba	%r9, [%r30 + %r0] 0x73
	.word 0xd88ca000  ! 3534: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	.word 0xdad44400  ! 3535: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	mov	0x0, %r27
	mov	0x68, %r19
	.word 0xd49f0e80  ! 3538: LDDA_R	ldda	[%r28, %r0] 0x74, %r10
	mov	0x10, %r27
	.word 0xd08f4e80  ! 3540: LDUBA_R	lduba	[%r29, %r0] 0x74, %r8
	.word 0xdaf4a000  ! 3541: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	mov	0x20, %r16
	.word 0xdab4e000  ! 3543: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xd8ac0400  ! 3544: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xda8c6000  ! 3545: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r13
	.word 0xda942000  ! 3546: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0xdaf46000  ! 3547: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	mov	0x30, %r16
	.word 0xd8b4c400  ! 3549: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0xd6a40400  ! 3550: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0xd2b4a000  ! 3551: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0xdca70e60  ! 3552: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	.word 0xd0bca000  ! 3553: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0xdadc0400  ! 3554: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	mov	0x18, %r25
	mov	0x0, %r17
	.word 0xd28c6000  ! 3557: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0xd2cca000  ! 3558: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	mov	0x7f8, %r23
	.word 0xd2dca000  ! 3560: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r9
	.word 0xd2ac2000  ! 3561: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd69d44a0  ! 3562: LDDA_R	ldda	[%r21, %r0] 0x25, %r11
	.word 0xd28dc4a0  ! 3563: LDUBA_R	lduba	[%r23, %r0] 0x25, %r9
	.word 0xda94e000  ! 3564: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r13
	.word 0x87802074  ! 3565: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd48584a0  ! 3566: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r10
	.word 0xdadc6000  ! 3567: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xda940400  ! 3568: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	.word 0xd8840400  ! 3569: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r12
	mov	0x10, %r25
	.word 0x8780204f  ! 3571: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdadc2000  ! 3572: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r13
	.word 0x87802073  ! 3573: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d8, %r21
	.word 0xda8d6000  ! 3575: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r13
	.word 0xda95e000  ! 3576: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r13
	.word 0xd4bf0e60  ! 3577: STDA_R	stda	%r10, [%r28 + %r0] 0x73
	.word 0xd0d70e40  ! 3578: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r8
	.word 0xd4956000  ! 3579: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r10
	.word 0xdeacc400  ! 3580: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xd2948400  ! 3581: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	mov	0x78, %r25
	.word 0x87802020  ! 3583: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c40400  ! 3584: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	.word 0xd8f78e40  ! 3585: STXA_R	stxa	%r12, [%r30 + %r0] 0x72
	.word 0xd8ac2000  ! 3586: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0xd0c44400  ! 3587: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r8
	.word 0x87802074  ! 3588: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r27
	.word 0xd0d76000  ! 3590: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0a7a000  ! 3591: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xde878e60  ! 3592: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r15
	mov	0x18, %r18
	.word 0xd287e000  ! 3594: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	mov	0x40, %r26
	.word 0xd8f44400  ! 3596: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	mov	0x50, %r25
	.word 0xd0bc0400  ! 3598: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0x87802074  ! 3599: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0870e80  ! 3600: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r8
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6dfce40  ! 3602: LDXA_R	ldxa	[%r31, %r0] 0x72, %r11
	.word 0xd49c6000  ! 3603: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0xd0ac0400  ! 3604: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	.word 0xdaac6000  ! 3605: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	.word 0xdc8689e0  ! 3606: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r14
	.word 0x87802020  ! 3607: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bf4e80  ! 3608: STDA_R	stda	%r10, [%r29 + %r0] 0x74
	.word 0x87802072  ! 3609: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 3610: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda8c8400  ! 3611: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	.word 0xd2b4c400  ! 3612: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	mov	0x7f0, %r21
	.word 0xdec7a000  ! 3614: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xdecfe000  ! 3615: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xd2f74e40  ! 3616: STXA_R	stxa	%r9, [%r29 + %r0] 0x72
	.word 0x87802020  ! 3617: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd497ce80  ! 3618: LDUHA_R	lduha	[%r31, %r0] 0x74, %r10
	.word 0xd4f40400  ! 3619: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xdcf7ce80  ! 3620: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	mov	0x3e0, %r20
	.word 0xd894a000  ! 3622: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r12
	mov	0x70, %r25
	.word 0xd0c7ce60  ! 3624: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r8
	.word 0xd8c40400  ! 3625: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	mov	0x3c0, %r21
	.word 0xd8ae49e0  ! 3627: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0xd2adc4a0  ! 3628: STBA_R	stba	%r9, [%r23 + %r0] 0x25
	.word 0xdc9f8e80  ! 3629: LDDA_R	ldda	[%r30, %r0] 0x74, %r14
	.word 0xd6f48400  ! 3630: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xd0a46000  ! 3631: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	mov	0x3e0, %r23
	.word 0xd0a42000  ! 3633: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0xd2bc4400  ! 3634: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0x87802073  ! 3635: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3636: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd497e000  ! 3637: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	.word 0xd4a76000  ! 3638: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd6af0e80  ! 3639: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	.word 0xd2a7e000  ! 3640: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0xdaac4400  ! 3641: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	mov	0x3d8, %r23
	.word 0xdaf78e40  ! 3643: STXA_R	stxa	%r13, [%r30 + %r0] 0x72
	.word 0xda8fa000  ! 3644: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0x87802025  ! 3645: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r16
	.word 0xdab66000  ! 3647: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0x87802073  ! 3648: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4d40400  ! 3649: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	.word 0xd0acc400  ! 3650: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd4f7a000  ! 3651: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 3652: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd28f8e40  ! 3653: LDUBA_R	lduba	[%r30, %r0] 0x72, %r9
	mov	0x58, %r27
	.word 0x87802020  ! 3655: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r18
	.word 0x87802073  ! 3657: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f46000  ! 3658: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8dce000  ! 3659: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	.word 0xd8b42000  ! 3660: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	.word 0xd2874e40  ! 3661: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r9
	.word 0xdacf8e40  ! 3662: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r13
	.word 0xd8ace000  ! 3663: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 3664: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbc8400  ! 3665: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xd8a4e000  ! 3666: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xd8f4a000  ! 3668: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 3669: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4c40400  ! 3670: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	.word 0xd2a7a000  ! 3671: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xda9504a0  ! 3672: LDUHA_R	lduha	[%r20, %r0] 0x25, %r13
	.word 0xd0b72000  ! 3673: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd0dfe000  ! 3674: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0x87802072  ! 3675: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r26
	.word 0xd4b7ce60  ! 3677: STHA_R	stha	%r10, [%r31 + %r0] 0x73
	.word 0x87802025  ! 3678: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdade6000  ! 3679: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r13
	.word 0xdaf609e0  ! 3680: STXA_R	stxa	%r13, [%r24 + %r0] 0x4f
	mov	0x3c8, %r22
	.word 0xd6ac4400  ! 3682: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xdede6000  ! 3683: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r15
	.word 0xd09e09e0  ! 3684: LDDA_R	ldda	[%r24, %r0] 0x4f, %r8
	.word 0xd0f6e000  ! 3685: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	.word 0x87802072  ! 3686: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb7ce60  ! 3687: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	.word 0xd2d72000  ! 3688: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	mov	0x7d0, %r21
	mov	0x3d0, %r23
	.word 0xd2af6000  ! 3691: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd28fa000  ! 3692: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3693: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bf6000  ! 3694: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xda974e60  ! 3696: LDUHA_R	lduha	[%r29, %r0] 0x73, %r13
	mov	0x10, %r26
	.word 0xd8c7e000  ! 3698: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0xdc9f4e60  ! 3699: LDDA_R	ldda	[%r29, %r0] 0x73, %r14
	.word 0xd0b72000  ! 3700: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd0c76000  ! 3701: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0xdc9f8e80  ! 3702: LDDA_R	ldda	[%r30, %r0] 0x74, %r14
	.word 0xd09c0400  ! 3703: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	mov	0x48, %r24
	.word 0xd0cc4400  ! 3705: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r8
	mov	0x30, %r24
	.word 0xdabd04a0  ! 3707: STDA_R	stda	%r13, [%r20 + %r0] 0x25
	.word 0xdcd72000  ! 3708: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0x87802020  ! 3709: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda974e60  ! 3710: LDUHA_R	lduha	[%r29, %r0] 0x73, %r13
	.word 0xdcb7ce40  ! 3711: STHA_R	stha	%r14, [%r31 + %r0] 0x72
	.word 0xd4b5e000  ! 3712: STHA_I	stha	%r10, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 3713: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b48400  ! 3714: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	mov	0x3e8, %r23
	.word 0x87802073  ! 3716: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6dfce40  ! 3717: LDXA_R	ldxa	[%r31, %r0] 0x72, %r11
	.word 0xda9de000  ! 3718: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r13
	.word 0x87802025  ! 3719: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda9f2000  ! 3720: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xdaa7ce80  ! 3721: STWA_R	stwa	%r13, [%r31 + %r0] 0x74
	.word 0xde95c4a0  ! 3722: LDUHA_R	lduha	[%r23, %r0] 0x25, %r15
	.word 0xd0d40400  ! 3723: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	.word 0xd4a72000  ! 3724: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 3725: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd48fe000  ! 3726: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xdaafce60  ! 3727: STBA_R	stba	%r13, [%r31 + %r0] 0x73
	.word 0x87802073  ! 3728: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4af4e60  ! 3729: STBA_R	stba	%r10, [%r29 + %r0] 0x73
	.word 0xdedf6000  ! 3730: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	mov	0x58, %r24
	.word 0x8780204f  ! 3732: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 3733: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3734: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8944400  ! 3735: LDUHA_R	lduha	[%r17, %r0] 0x20, %r12
	mov	0x70, %r16
	.word 0x87802020  ! 3737: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r16
	.word 0xd2b7e000  ! 3739: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd29fe000  ! 3740: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xdab78e60  ! 3741: STHA_R	stha	%r13, [%r30 + %r0] 0x73
	.word 0xd8a7e000  ! 3742: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xdeb74e40  ! 3744: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	.word 0xdab609e0  ! 3745: STHA_R	stha	%r13, [%r24 + %r0] 0x4f
	.word 0xd4f7e000  ! 3746: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xd2af4e80  ! 3747: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	.word 0x87802020  ! 3748: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49e89e0  ! 3749: LDDA_R	ldda	[%r26, %r0] 0x4f, %r10
	.word 0xd4d76000  ! 3750: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	mov	0x3e0, %r21
	.word 0xd2a6c9e0  ! 3752: STWA_R	stwa	%r9, [%r27 + %r0] 0x4f
	.word 0xd2cc8400  ! 3753: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0xd0af6000  ! 3754: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xdef7ce40  ! 3755: STXA_R	stxa	%r15, [%r31 + %r0] 0x72
	.word 0xd4d74e80  ! 3756: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r10
	.word 0xd29f4e80  ! 3757: LDDA_R	ldda	[%r29, %r0] 0x74, %r9
	.word 0xd6afe000  ! 3758: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x7c8, %r23
	.word 0xd4dc8400  ! 3760: LDXA_R	ldxa	[%r18, %r0] 0x20, %r10
	.word 0x8780204f  ! 3761: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r18
	.word 0xd2a74e40  ! 3763: STWA_R	stwa	%r9, [%r29 + %r0] 0x72
	.word 0xd48c4400  ! 3764: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0x87802074  ! 3765: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbca000  ! 3766: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	mov	0x40, %r24
	.word 0xdc9c2000  ! 3768: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r14
	.word 0x87802074  ! 3769: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b40400  ! 3770: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	mov	0x50, %r25
	.word 0xdad76000  ! 3772: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0x87802073  ! 3773: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf76000  ! 3774: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	mov	0x68, %r26
	mov	0x10, %r24
	.word 0xdccfce80  ! 3777: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r14
	.word 0xd6a76000  ! 3778: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	mov	0x18, %r16
	.word 0xd6b7a000  ! 3780: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	mov	0x70, %r27
	.word 0xdaa78e60  ! 3782: STWA_R	stwa	%r13, [%r30 + %r0] 0x73
	.word 0xde8f2000  ! 3783: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xd0a7ce40  ! 3784: STWA_R	stwa	%r8, [%r31 + %r0] 0x72
	.word 0xdca6c9e0  ! 3785: STWA_R	stwa	%r14, [%r27 + %r0] 0x4f
	.word 0xdebf6000  ! 3786: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xdecfa000  ! 3788: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xd8f40400  ! 3789: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xd8bc8400  ! 3790: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xdac76000  ! 3791: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r13
	.word 0xd0b584a0  ! 3792: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	mov	0x38, %r26
	.word 0xd2b76000  ! 3794: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2af2000  ! 3795: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd88c4400  ! 3796: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0xd8b504a0  ! 3797: STHA_R	stha	%r12, [%r20 + %r0] 0x25
	.word 0xd8d7a000  ! 3798: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	mov	0x38, %r24
	.word 0xd8dfa000  ! 3800: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	mov	0x78, %r19
	.word 0xd897e000  ! 3802: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	.word 0xd8bfa000  ! 3803: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xdcf48400  ! 3804: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0x87802025  ! 3805: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb78e40  ! 3806: STHA_R	stha	%r15, [%r30 + %r0] 0x72
	.word 0xd6d7a000  ! 3807: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	.word 0xd2ad44a0  ! 3808: STBA_R	stba	%r9, [%r21 + %r0] 0x25
	mov	0x8, %r17
	.word 0xd09fce40  ! 3810: LDDA_R	ldda	[%r31, %r0] 0x72, %r8
	mov	0x7e8, %r20
	.word 0xdaa7e000  ! 3812: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xda9f0e40  ! 3813: LDDA_R	ldda	[%r28, %r0] 0x72, %r13
	.word 0xd6c72000  ! 3814: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6976000  ! 3815: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	.word 0xd6bfe000  ! 3816: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd6b7a000  ! 3817: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd6b72000  ! 3818: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd6876000  ! 3819: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6872000  ! 3820: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6bfa000  ! 3821: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd0b6c9e0  ! 3822: STHA_R	stha	%r8, [%r27 + %r0] 0x4f
	.word 0xdebe89e0  ! 3823: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	.word 0xd6bf2000  ! 3824: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	mov	0x40, %r26
	.word 0xd697e000  ! 3826: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0xd6b48400  ! 3827: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd8f78e40  ! 3828: STXA_R	stxa	%r12, [%r30 + %r0] 0x72
	.word 0xd89f2000  ! 3829: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0xd89f2000  ! 3830: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	mov	0x28, %r26
	mov	0x3e8, %r23
	mov	0x7e8, %r21
	.word 0xdcd74e40  ! 3834: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r14
	mov	0x48, %r18
	.word 0xd8cfa000  ! 3836: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	.word 0xd89fe000  ! 3837: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0xd087ce80  ! 3838: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r8
	.word 0xde9fe000  ! 3839: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0xdeb76000  ! 3840: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xdacf4e40  ! 3841: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r13
	mov	0x50, %r16
	mov	0x0, %r18
	.word 0xd8bc0400  ! 3844: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xda940400  ! 3845: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	.word 0xdcafce40  ! 3846: STBA_R	stba	%r14, [%r31 + %r0] 0x72
	.word 0xdec70e60  ! 3847: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r15
	.word 0xd4f78e80  ! 3848: STXA_R	stxa	%r10, [%r30 + %r0] 0x74
	.word 0xdaaf2000  ! 3849: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdaf76000  ! 3850: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdab76000  ! 3851: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xda8fa000  ! 3852: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xdcac8400  ! 3853: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xd8b72000  ! 3854: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xdadfce60  ! 3855: LDXA_R	ldxa	[%r31, %r0] 0x73, %r13
	.word 0xd8b7a000  ! 3856: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xd4bc0400  ! 3857: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0x87802073  ! 3858: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8ace000  ! 3859: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0xd8842000  ! 3860: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	mov	0x28, %r18
	.word 0x8780204f  ! 3862: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc9d04a0  ! 3863: LDDA_R	ldda	[%r20, %r0] 0x25, %r14
	.word 0xdaa4e000  ! 3864: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 3865: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda9ca000  ! 3866: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	.word 0xded48400  ! 3867: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	.word 0x87802074  ! 3868: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d0, %r20
	.word 0x87802020  ! 3870: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ac2000  ! 3871: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0xd49ca000  ! 3872: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xda9544a0  ! 3873: LDUHA_R	lduha	[%r21, %r0] 0x25, %r13
	.word 0x87802074  ! 3874: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdea74e40  ! 3875: STWA_R	stwa	%r15, [%r29 + %r0] 0x72
	.word 0xdcbc2000  ! 3876: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xdcaca000  ! 3877: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xdcb4e000  ! 3878: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 3879: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdabcc400  ! 3880: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	.word 0xd8f7ce40  ! 3881: STXA_R	stxa	%r12, [%r31 + %r0] 0x72
	.word 0xd28f8e40  ! 3882: LDUBA_R	lduba	[%r30, %r0] 0x72, %r9
	.word 0xd6b7ce80  ! 3883: STHA_R	stha	%r11, [%r31 + %r0] 0x74
	.word 0xd69fa000  ! 3884: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	mov	0x18, %r18
	.word 0xde848400  ! 3886: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	.word 0xd0b584a0  ! 3887: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	.word 0x87802073  ! 3888: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8bf4e80  ! 3889: STDA_R	stda	%r12, [%r29 + %r0] 0x74
	.word 0xd887a000  ! 3890: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xd4f70e60  ! 3891: STXA_R	stxa	%r10, [%r28 + %r0] 0x73
	.word 0xde9f8e60  ! 3892: LDDA_R	ldda	[%r30, %r0] 0x73, %r15
	mov	0x3d8, %r23
	mov	0x48, %r19
	.word 0xd69e09e0  ! 3895: LDDA_R	ldda	[%r24, %r0] 0x4f, %r11
	.word 0xd8df6000  ! 3896: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0xdabc8400  ! 3897: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	.word 0xd6cc4400  ! 3898: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	.word 0xdca7a000  ! 3899: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcbf6000  ! 3900: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdcf7a000  ! 3901: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcf72000  ! 3902: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xd8cf0e80  ! 3903: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r12
	.word 0xd69cc400  ! 3904: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	.word 0xd4976000  ! 3905: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r10
	.word 0xdc8ec9e0  ! 3906: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r14
	mov	0x30, %r19
	.word 0x87802074  ! 3908: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r18
	.word 0x87802020  ! 3910: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3911: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bf0e60  ! 3912: STDA_R	stda	%r9, [%r28 + %r0] 0x73
	.word 0x87802025  ! 3913: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8d6000  ! 3914: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r13
	.word 0xdaa5a000  ! 3915: STWA_I	stwa	%r13, [%r22 + 0x0000] %asi
	.word 0xdaad2000  ! 3916: STBA_I	stba	%r13, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 3917: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde9504a0  ! 3918: LDUHA_R	lduha	[%r20, %r0] 0x25, %r15
	.word 0x8780204f  ! 3919: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r25
	.word 0xde8c4400  ! 3921: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	.word 0xd0af4e60  ! 3922: STBA_R	stba	%r8, [%r29 + %r0] 0x73
	.word 0xd8976000  ! 3923: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0xd6a74e60  ! 3924: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	mov	0x28, %r16
	.word 0xd4dd04a0  ! 3926: LDXA_R	ldxa	[%r20, %r0] 0x25, %r10
	.word 0xd0f40400  ! 3927: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xdead44a0  ! 3928: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	.word 0xd8af8e60  ! 3929: STBA_R	stba	%r12, [%r30 + %r0] 0x73
	.word 0xdef72000  ! 3930: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xde87e000  ! 3931: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xde8f0e60  ! 3932: LDUBA_R	lduba	[%r28, %r0] 0x73, %r15
	mov	0x50, %r18
	.word 0xda8c4400  ! 3934: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0xdcb76000  ! 3935: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	mov	0x70, %r17
	mov	0x40, %r27
	.word 0xdccc4400  ! 3938: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r14
	.word 0xd6a78e80  ! 3939: STWA_R	stwa	%r11, [%r30 + %r0] 0x74
	.word 0xd0b6c9e0  ! 3940: STHA_R	stha	%r8, [%r27 + %r0] 0x4f
	mov	0x30, %r26
	.word 0xde8fce40  ! 3942: LDUBA_R	lduba	[%r31, %r0] 0x72, %r15
	.word 0xde9fa000  ! 3943: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	.word 0x87802020  ! 3944: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3945: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r19
	mov	0x60, %r27
	.word 0xde8dc4a0  ! 3948: LDUBA_R	lduba	[%r23, %r0] 0x25, %r15
	.word 0xd6bc2000  ! 3949: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 3950: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb689e0  ! 3951: STHA_R	stha	%r14, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 3952: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc94c400  ! 3953: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	mov	0x7f0, %r22
	mov	0x60, %r17
	.word 0xd2dfe000  ! 3956: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	.word 0x87802072  ! 3957: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd287e000  ! 3958: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0xd297a000  ! 3959: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	mov	0x60, %r19
	.word 0xd4de49e0  ! 3961: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r10
	.word 0xdaa76000  ! 3962: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xdacfa000  ! 3963: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	.word 0xd8df8e80  ! 3964: LDXA_R	ldxa	[%r30, %r0] 0x74, %r12
	.word 0xd8be09e0  ! 3965: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 3966: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r17
	.word 0xd0872000  ! 3968: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	mov	0x10, %r24
	.word 0xd0af6000  ! 3970: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd2f70e40  ! 3971: STXA_R	stxa	%r9, [%r28 + %r0] 0x72
	mov	0x28, %r16
	.word 0xd8f76000  ! 3973: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd08609e0  ! 3974: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r8
	.word 0xd68f6000  ! 3975: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6af2000  ! 3976: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd687e000  ! 3977: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6bfe000  ! 3978: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd6a76000  ! 3979: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xdc978e80  ! 3980: LDUHA_R	lduha	[%r30, %r0] 0x74, %r14
	mov	0x7e0, %r21
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802073  ! 3983: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a74e40  ! 3984: STWA_R	stwa	%r8, [%r29 + %r0] 0x72
	mov	0x3c8, %r21
	.word 0xded7a000  ! 3986: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 3987: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xded46000  ! 3988: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	.word 0xdeac6000  ! 3989: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xdec4a000  ! 3991: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0x87802072  ! 3992: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2c78e80  ! 3993: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r9
	.word 0xdcb46000  ! 3994: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xdcf7ce60  ! 3995: STXA_R	stxa	%r14, [%r31 + %r0] 0x73
	mov	0x68, %r24
	.word 0xdcf44400  ! 3997: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xda874e60  ! 3998: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r13
	.word 0xd2842000  ! 3999: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r9
	mov	0x3c8, %r23
	mov	0x48, %r18
	.word 0xd2ac2000  ! 4002: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd2dc6000  ! 4003: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r9
	.word 0xd2ace000  ! 4004: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	mov	0x10, %r19
	.word 0xdeb44400  ! 4006: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0xdeae09e0  ! 4007: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	.word 0xd8846000  ! 4008: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	mov	0x20, %r19
	.word 0xd8a42000  ! 4010: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8ac2000  ! 4011: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	mov	0x7d0, %r23
	mov	0x38, %r18
	.word 0xd48c8400  ! 4014: LDUBA_R	lduba	[%r18, %r0] 0x20, %r10
	.word 0xd6f4a000  ! 4015: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	.word 0xd2c584a0  ! 4016: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r9
	mov	0x38, %r17
	mov	0x58, %r26
	.word 0xdeaf4e60  ! 4019: STBA_R	stba	%r15, [%r29 + %r0] 0x73
	.word 0xdaace000  ! 4020: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	mov	0x18, %r24
	mov	0x0, %r27
	.word 0xd08c4400  ! 4023: LDUBA_R	lduba	[%r17, %r0] 0x20, %r8
	mov	0x70, %r19
	.word 0xdea504a0  ! 4025: STWA_R	stwa	%r15, [%r20 + %r0] 0x25
	.word 0x87802025  ! 4026: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6974e40  ! 4027: LDUHA_R	lduha	[%r29, %r0] 0x72, %r11
	.word 0xd09f0e80  ! 4028: LDDA_R	ldda	[%r28, %r0] 0x74, %r8
	.word 0xd2df0e60  ! 4029: LDXA_R	ldxa	[%r28, %r0] 0x73, %r9
	.word 0xd8866000  ! 4030: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r12
	.word 0xd0df0e80  ! 4031: LDXA_R	ldxa	[%r28, %r0] 0x74, %r8
	.word 0xd08c8400  ! 4032: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.w