% Circular Convolution

x = 1:1000;

signal = [sin(2*pi*0.1*x), 0*x];

figure(6), plot(signal)

spec = fft(signal);
filtered_spec = [spec(1:221), zeros(1,1559), spec(1781:2000)];
filtered_signal = ifft(filtered_spec);

figure(7)
subplot(2,1,1)
plot(abs(fftshift(spec)))
title('Magnitude of FFT')
subplot(2,1,2)
plot(phase(fftshift(spec)))
title('Phase of FFT')

figure(8)
subplot(2,1,1)
plot(abs(fftshift(filtered_spec)))
title('Magnitude of FFT')
subplot(2,1,2)
plot(phase(fftshift(filtered_spec)))
title('Phase of FFT')

figure(9), plot(filtered_signal)