experiment = 1;  % Choose which demo to do using this switch


if experiment == 1

% First demo
    
% N = 8;         % Filter order
% N2 = 10;       % Alternate filter order
% F = [0 0.1 1]; % Frequency vector
% Gd = [2 3 1];  % Desired group delay
% R = 0.99;      % Pole-radius constraint
% 
% h = fdesign.arbgrpdelay('N,F,Gd',N,F,Gd)


% Create filter with three passbands and different group delays
t = 0:0.001:30;
f = 0:1/30:1000;
h = (exp(-(t-1).^2).*sin(2*pi*5*t) + exp(-(t-6).^2).*sin(2*pi*10*t))/1000;
figure(1)
subplot(2,1,1)
plot(f,log(abs(fft(h))))
axis([0,15,-inf,inf])
title('Log-Amplitude of frequency response')
subplot(2,1,2)
plot(f,phase(fft(h)))
title('Phase of frequency response')
axis([0,15,-inf,inf])

% Create input signal
tx = 0:0.001:5;
x = (exp(-(tx-3).^2).*cos(2*pi*5*tx) + exp(-(tx-3).^2).*cos(2*pi*10*tx + 1) + exp(-(tx-3).^2).*cos(2*pi*7*tx + 1));


% Demonstrate group delay
figure(2)
clf
subplot(2,1,1)
plot(tx,x)
axis([0,15,-inf,inf])
title('Input')
subplot(2,1,2)
plot(0:0.001:35, conv(x,h), 'r')
axis([0,15,-inf,inf])
title('Output')



else % Second demo

    
% Demonstration with a few sinusoids
t = 0:0.001:5;
amp = [3, 1, 2];
f = [5, 5.2, 5.4]';
ph = [1, 1, 2]';
change = 0:.1:100;

group_delay = 0; % Zero for phase change - one for group delay

for k = 1:length(change)
figure(3)
if group_delay
    plot(t, amp*cos(2*pi*f*t + (ph + [.1;0;-.1]*change(k))*ones(size(t))))
    title('Group Delay')
else
    plot(t, amp*cos(2*pi*f*t + (ph-change(k))*ones(size(t))))
    title('Constant Phase Change')
end
drawnow

end

end

