I = imread('rice.png');
x = double(I);

% Create blur impulse response
blur = [[0.3 0.3 .4 0 0]; [0 .7 .7 .1 0]; [0 .3 1 .3 0]; [0 .1 .7 .7 0]; [0 0 .4 0.3 0.3]];
% Pad zeros around the blur (for the sake of display and for the fft)
bigblur = zeros(101,101);
bigblur(49:53,49:53) = blur;


fblur = fft2(bigblur);
fdeblur = conj(fblur)./(fblur.*conj(fblur) + .1); % This line does the inverse.  A constant is added to the numerator to limit the amplification of noise and edge effects.
deblur = real(ifft2(fdeblur)); % Take the real part in case numerical errors resulted in complex numbers.
%deblur2 = deblur(41:61,41:61);


y = conv2(x,blur);
y = y(3:end-2,3:end-2);

z = conv2(y,deblur);
z = z(51:end-50,51:end-50);


 
 figure(7), imagesc(conv2(bigblur,deblur)), colormap(gray)
 title('Convolution of blur and deblur')

 figure(6), image(z/4), colormap(gray)
 title('Deblurred image')
 figure(5), imagesc(deblur), colormap(gray)
 title('Deblur impulse response')
 figure(4), imagesc(abs(fftshift(fft2(bigblur)))), colormap(gray)
 title('Fourier transform of blur')
 figure(3), imagesc(y), colormap(gray)
 title('Blurred image')
 figure(2), image(x/4), colormap(gray)
 title('Original image')
 figure(1), imagesc(bigblur), colormap(gray)
 title('Blur impulse response')

