function out = quant(in,levels,fig)

% Quick quantization.  Breakpoints are placed at the mean of the
%   reconstruction levels.
%
% Make sure the levels that are supplied are consistent with the
%   dynamic range of the signal!
%
% Syntax:  out = quant(in,levels);    (levels is a vector)
%

in = double(in);

levels = sort(levels);

breaks = [min(in(:)) (levels(2:end)+levels(1:end-1))/2 max(in(:))+1];

out = zeros(size(in));

for i=1:length(levels)
  out = out+levels(i)*((in >= breaks(i)) & (in < breaks(i+1)));
end

out = out+levels(end)*(in == breaks(end));


if min(size(in)) > 1
  if nargin < 3
     figure(99)
     imagesc(out)
     axis equal
     axis tight
     axis off
     colormap(gray)
  elseif (fig ~= 0)
     figure(fig)
     imagesc(out) 
     axis equal
     axis tight
     axis off
     colormap(gray)
  end
end
