function coder(action,param);

warning off

if ((nargin == 0) | ((nargin == 1) & ~isstr(action)))

  symbols = [sort('ETANDSH'),' '];
  bgcol = [0.752941176470588 0.752941176470588 0.752941176470588];

  ud.symbols = symbols;
  ud.word = cell(1,8);
  ud.ind = 1:8;
  ud.wordlen = zeros(1,8);

  h0 = figure('Color',[0.8 0.8 0.8], ...
        'MenuBar','none', ...
        'Name','ELE 201 Text Coder',...
        'Numbertitle','off',...
	'Position',[491 180 666 387], ...
	'Tag','Fig1');

  %  Edit boxes for messages

  %  Original

  origcall = ['ud = get(gcbf,''userdata'');',...
              'g = upper(get(ud.editorig,''string''));',...
              'if isequal(union(ud.symbols+0,g+0),sort(ud.symbols+0)),',...
              '  for i = 1:8,',...
              '    ud.p(i) = length(find(g == ud.symbols(i)))/length(g);',...
              '    set(ud.prob(i),''string'',num2str(ud.p(i)));',...
              '  end,',...
              '  ud.orig = g;',...
              '  set(ud.error,''string'','''');',...
              '  set(gcbf,''userdata'',ud);',...
              'else,',...
              '  set(ud.error,''string'',[''Message contains more than '',ud.symbols]);',...
              '  set(ud.prob,''string'','''');',...
              'end'];

  ud.editorig = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
        'Callback',origcall,...
        'Horiz','left',...
	'ListboxTop',0, ...
	'Position',[21 194.25 315.75 68.25], ...
	'Style','edit', ...
	'Tag','EditText1');

  %  Encoded

  ud.editenc = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
        'Horiz','left',...
	'ListboxTop',0, ...
        'Min',1,'Max',3,...
	'Position',[21 101.25 315.75 68.25], ...
	'Style','edit', ...
	'Tag','EditText1');

  %  Decoded

  ud.textdec = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
        'Horiz','left',...
	'ListboxTop',0, ...
	'Position',[21 9.75 315.75 68.25], ...
	'Style','text', ...
	'Tag','EditText1');

  %  Edit boxes for code words

  wordcall = ['ud = get(gcbf,''userdata'');',...
              'w = get(gcbo,''userdata'');',...
              'st = get(gcbo,''string'');',...
              'bad = 0;',...
              'for i=1:8,',...
              '  if ~(isequal(union(unique(get(ud.code(i),''string'')),[48 49]),[48 49])||length(get(ud.code(i),''string''))==0),',...
              '    set(ud.error,''string'',''There''''s a non-binary codeword.'');',...
              '    bad = 1;',...
              '  end,',...
              'end,',...
              'if bad==0,',...
              '  set(ud.error,''string'',[]);',...
              '  ud.word{w} = st;',...
              '  ud.wordlen(w) = length(st);',...
              '  [t,ud.ind] = sort(ud.wordlen);',...
              '  set(gcbf,''userdata'',ud);',...
              'end,'];

  ud.code(1) = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
        'Callback',wordcall,...
	'ListboxTop',0, ...
	'Position',[371.25 157.5 35.25 15.75], ...
	'Style','edit', ...
        'Userdata',1,...
	'Tag','Edittext2');
  ud.code(2) = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
        'Callback',wordcall,...
	'ListboxTop',0, ...
	'Position',[371.25 135 35.25 15.75], ...
	'Style','edit', ...
        'Userdata',2,...
	'Tag','EditText2');
  ud.code(3) = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
        'Callback',wordcall,...
	'ListboxTop',0, ...
	'Position',[371.25 111 35.25 15.75], ...
	'Style','edit', ...
        'Userdata',3,...
	'Tag','EditText2');
  ud.code(4) = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
        'Callback',wordcall,...
	'ListboxTop',0, ...
	'Position',[371.25 88.5 35.25 15.75], ...
	'Style','edit', ...
        'Userdata',4,...
	'Tag','EditText2');
  ud.code(5) = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
        'Callback',wordcall,...
	'ListboxTop',0, ...
	'Position',[435 158.25 35.25 15.75], ...
	'Style','edit', ...
        'Userdata',5,...
	'Tag','EditText2');
  ud.code(6) = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
        'Callback',wordcall,...
	'ListboxTop',0, ...
	'Position',[435 135.75 35.25 15.75], ...
	'Style','edit', ...
        'Userdata',6,...
	'Tag','EditText2');
  ud.code(7) = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
        'Callback',wordcall,...
	'ListboxTop',0, ...
	'Position',[435 111.75 35.25 15.75], ...
	'Style','edit', ...
        'Userdata',7,...
	'Tag','EditText2');
  ud.code(8) = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
        'Callback',wordcall,...
	'ListboxTop',0, ...
	'Position',[435 89.25 35.25 15.75], ...
	'Style','edit', ...
        'Userdata',8,...
	'Tag','EditText2');

  %  Encode button

  encodecall = ['ud = get(gcbf,''userdata'');',...
                'for i=1:7,for j=(i+1):8,',...
                'if strcmp(ud.word{ud.ind(j)}(1:length(ud.word{ud.ind(i)})),ud.word{ud.ind(i)}),',...
                '  set(ud.error,''string'',''This is not a prefix code!'');',...
                'end,end,end,',...
                'if strcmp(get(ud.error,''string''),[]) == 0,',...
                '  ud.encoded = [];',...
                '  for i=1:length(ud.orig),',...
                '    ud.encoded = [ud.encoded,ud.word{find(ud.symbols==ud.orig(i))}];',...
                '  end,',...
                '  ud.enctext={};',...
                '  for i=1:ceil(length(ud.encoded)/60),',...
                '    ud.enctext{i} = ud.encoded(60*(i-1)+1:min(60*i,length(ud.encoded)));',...
                '  end,',...
                '  set(ud.editenc,''string'',ud.enctext);',...
                '  set(ud.textenc,''string'',[''  Encoded message, '',num2str(length(ud.encoded)/length(ud.orig)),'' bps'']);',...
                '  set(gcbf,''userdata'',ud);',...
                'end,'];

  h1 = uicontrol('Parent',h0, ...
        'Callback',encodecall,...
	'Units','points', ...
	'ListboxTop',0, ...
	'Position',[354.75 20.25 56.25 29.25], ...
	'String','Encode', ...
	'Tag','Pushbutton1');

  %  Decode button

  decodecall = ['ud = get(gcbf,''userdata'');',...
                'frombox = get(ud.editenc,''string'');',...
                'frombox = [frombox{:}];',...
                'frombox(frombox == ''|'') = [];',...
                'frombox(frombox == '' '') = [];',...
                'parsed = []; ud.decoded = [];start = 1;',...
                'while (start <= length(frombox)),',...
                '  for i=1:8,',...
                '    if strcmp(frombox(start:min(start+ud.wordlen(ud.ind(i))-1,length(frombox))),ud.word{ud.ind(i)}),',...
                '       parsed = [parsed,ud.word{ud.ind(i)},'' || ''];',...
                '       ud.decoded = [ud.decoded,ud.symbols(ud.ind(i))];',...
                '       start = start + ud.wordlen(ud.ind(i));',...
                '       break;',...
                '    elseif (i==8),',...
                '       parsed = [parsed,frombox(start),'' || ''];',...
                '       ud.decoded = [ud.decoded,''?''];',...
                '       start = start + 1;',...
                '    end,',...
                '  end,',...
                'end,',...
                'ud.enctext={};',...
                'ud.dectext={};',...
                'for i=1:ceil(length(parsed)/100),',...
                '  ud.enctext{i} = parsed(100*(i-1)+1:min(100*i,length(parsed)));',...
                'end,',...
                'for i=1:ceil(length(ud.decoded)/60),',...
                '  ud.dectext{i} = ud.decoded(60*(i-1)+1:min(60*i,length(ud.decoded)));',...
                'end,',...
                'set(ud.editenc,''string'',ud.enctext);',...
                'set(ud.textdec,''string'',lower(ud.dectext));',...
                'set(gcbf,''userdata'',ud);'];

  h1 = uicontrol('Parent',h0, ...
        'callback',decodecall,...
	'Units','points', ...
	'ListboxTop',0, ...
	'Position',[423 20.25 56.25 29.25], ...
	'String','Decode', ...
	'Tag','Pushbutton1');

  %  Error message text box

  ud.error = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[360.75 56.75 112.5 22], ...
	'Style','text', ...
        'ForegroundColor','r',...
	'Tag','StaticText2');

  %  Name tags for code boxes

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[355.5 159.75 13.5 10.5], ...
	'String','A', ...
	'Style','text', ...
	'Tag','StaticText1');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[355.5 137.25 13.5 10.5], ...
	'String',symbols(2), ...
	'Style','text', ...
	'Tag','StaticText1');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[355.5 114 13.5 10.5], ...
	'String',symbols(3), ...
	'Style','text', ...
	'Tag','StaticText1');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[355.5 90.75 13.5 10.5], ...
	'String',symbols(4), ...
	'Style','text', ...
	'Tag','StaticText1');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[419.25 160.5 13.5 10.5], ...
	'String',symbols(5), ...
	'Style','text', ...
	'Tag','StaticText1');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[419.25 138 13.5 10.5], ...
	'String',symbols(6), ...
	'Style','text', ...
	'Tag','StaticText1');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[419.25 114.75 13.5 10.5], ...
	'String',symbols(7), ...
	'Style','text', ...
	'Tag','StaticText1');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[419.25 91.5 13.5 10.5], ...
	'String',symbols(8), ...
	'Style','text', ...
	'Tag','StaticText1');

  % "Original Text" tag

  ud.textorig = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'HorizontalAlignment','left', ...
	'ListboxTop',0, ...
	'Position',[21 264 129.75 12], ...
	'String','  Original Message, 3 bps', ...
	'Style','text', ...
	'Tag','StaticText3');

  % "Encoded" tag

  ud.textenc = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'HorizontalAlignment','left', ...
	'ListboxTop',0, ...
	'Position',[21 171 129.75 12], ...
	'String','  Encoded Message', ...
	'Style','text', ...
	'Tag','StaticText3');

  % "Decoded" tag

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'HorizontalAlignment','left', ...
	'ListboxTop',0, ...
	'Position',[21 79.5 77.25 12], ...
	'String','  Decoded Message', ...
	'Style','text', ...
	'Tag','StaticText3');

  %  Name tags for probabilities

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[355.5 258.75 13.5 10.5], ...
	'String',symbols(1), ...
	'Style','text', ...
	'Tag','StaticText1');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[355.5 236.25 13.5 10.5], ...
	'String',symbols(2), ...
	'Style','text', ...
	'Tag','StaticText1');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[355.5 213 13.5 10.5], ...
	'String',symbols(3), ...
	'Style','text', ...
	'Tag','StaticText1');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[355.5 189.75 13.5 10.5], ...
	'String',symbols(4), ...
	'Style','text', ...
	'Tag','StaticText1');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[419.25 259.5 13.5 10.5], ...
	'String',symbols(5), ...
	'Style','text', ...
	'Tag','StaticText1');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[419.25 237 13.5 10.5], ...
	'String',symbols(6), ...
	'Style','text', ...
	'Tag','StaticText1');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[419.25 213.75 13.5 10.5], ...
	'String',symbols(7), ...
	'Style','text', ...
	'Tag','StaticText1');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[419.25 190.5 13.5 10.5], ...
	'String',symbols(8), ...
	'Style','text', ...
	'Tag','StaticText1');

  %  Text boxes where probabilities are written

  ud.prob(1) = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[371.25 255.75 34.5 15.75], ...
	'Style','text', ...
	'Tag','StaticText4');
  ud.prob(2) = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[371.25 233.25 34.5 15.75], ...
	'Style','text', ...
	'Tag','StaticText4');
  ud.prob(3) = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[371.25 210 34.5 15.75], ...
	'Style','text', ...
	'Tag','StaticText4');
  ud.prob(4) = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[371.25 186.75 34.5 15.75], ...
	'Style','text', ...
	'Tag','StaticText4');
  ud.prob(5) = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[435.75 257.25 34.5 15.75], ...
	'Style','text', ...
	'Tag','StaticText4');
  ud.prob(6) = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[435.75 234 34.5 15.75], ...
	'Style','text', ...
	'Tag','StaticText4');
  ud.prob(7) = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[435.75 211.5 34.5 15.75], ...
	'Style','text', ...
	'Tag','StaticText4');
  ud.prob(8) = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',bgcol, ...
	'ListboxTop',0, ...
	'Position',[435.75 188.25 34.5 15.75], ...
	'Style','text', ...
	'Tag','StaticText4');
 
  set(h0,'userdata',ud);

elseif strcmp(action,'refresh')

end
