% Need files mp3read.m, mp3info.exe, and mpg123.exe
% Need mp3 file in working directory

%[y,fs] = mp3read('Sleep Away.mp3');
[y,fs] = mp3read('Maid with the Flaxen Hair.mp3');

% Create single vector from stereo signal
% Also, select a five second segment
x = mean(y(20*fs:25*fs+1,:),2);

% Create time vector for graph
t = [1:length(x)]'/fs;

% Processed sounds
x1 = x.*sin(2*pi*1000*t);
x2 = min(max(x,-.1),.1);
x3 = sqrt(abs(x));
x4 = x.^2;

% Downsample by factor of 50
t5 = t(1:50:end);
x5 = x(1:50:end); % With aliasing
fs5 = fs/50;
x5resampled = resample(x,1,50); % With aliasing

figure(1), plot(t,x)
hold on
plot(t5,x5,'.r')
hold off