# convert degrees to radians
# print column titles
# right align degree values
# limit radians to 7 characters
# use math module for cosine and pi
# align cosine value to decimal point
# do the radian formatting as a function call
# store the values in 2 lists


def fixformat(s):		# functions must be defined before being called
	while len(s) < 7:
		s = s + " "

	return s


import math

degree = 0
degreeMax = 180
degreeIncr = 10

radianL = []				# set up a list for the radians
cosineL = []				# set up a list for the cosines

print( "Degrees   Radians    Cosine")

while degree <= degreeMax:
	radian = degree * math.pi / 180
	radianL.append(radian)

	degreeS = str(degree)

	if len(degreeS) == 1:
		degreeS = "  " + degreeS
	elif len(degreeS) == 2:
		degreeS = " " + degreeS

	radianS = str(radian)
	radianS = fixformat(radianS)		# our function call

	cosine = math.cos(radian)
	cosineL.append(cosine)
	cosineS = str(cosine)[:7]

	if cosine >= 0.:
		cosineS = " " + cosineS

	print( degreeS + "       " + radianS[:7] + "   " + cosineS)

	degree += degreeIncr

print( " ")
print( radianL)
print( " ")
print( cosineL)
print( " ")


import platform				# imports can be anywhere in code
import elvispy

host = platform.node()			# get name of my computer
port = 7654

s1 = elvispy.open_session(host, port)		# connect to ElVis running on
					# my computer, listening to default port

elvispy.draw_graph(s1, radianL, cosineL, "Cosine", "Radians", "Cos")
