clear all
cd "/Users/fujiwara/Dropbox (Princeton)/covid/"

*** Locals to be defined by user ***
local x total_ma
local end 30jul2020
******

*Extracts confirmed deaths (by final date) from MinSaude "official" data
import excel csv_minsaude/HIST_PAINEL_COVIDBR_16ago2020.xlsx, sheet("Sheet 1") firstrow clear
*gen date = date(data, "YMD")
gen date = data
 keep if date==td(`end')
rename codmun city_ibge_code
 destring city_ibge_code, replace
 drop if city_ibge_code==.
keep date city_ibge_code obitosAcumulado
destring obitosAcumulado, replace
gen year=2020
save temp_datasets/minsaude.dta, replace

*Downloads latest version and imports data
copy https://raw.githubusercontent.com/capyvara/brazil-civil-registry-data/master/civil_registry_covid_cities.csv brasil_io/civil_registry_covid_cities.csv, replace
 import delimited brasil_io/civil_registry_covid_cities.csv, varnames(1) encoding(ISO-8859-2) clear
 
*Creates total deaths variable
gen total = 0 
foreach i of varlist deaths_sars deaths_pneumonia deaths_respiratory_failure deaths_septicemia deaths_indeterminate deaths_others deaths_covid19 ///
deaths_stroke deaths_stroke_covid19 deaths_cardiopathy deaths_cardiogenic_shock deaths_heart_attack deaths_heart_attack_covid19 deaths_sudden_cardiac {
 replace `i'=0 if `i'==.
 replace total = total + `i'	
}

*Collapses to get total across places of deaths
collapse (sum) total deaths_covid19, by(date state state_ibge_code city city_ibge_code)

*Puts date in Stata format
gen temp = date(date, "YMD")
drop date
rename temp date
format date %td
gen year=year(date)
gen month=month(date)
gen day=day(date)

*Drops DV from IBGE code
gen temp = floor(city_ibge_code/10)
 replace city_ibge_code = temp
 drop temp
 
*Only keeps 2019 and 2020
drop if year==2018
 
*Match it to the 2020 year dates 
replace date = date + 365 if year==2019 & month<=2
replace date = date + 365 + 1 if year==2019 & month>=3

*Appends DATASUS data
append using temp_datasets/datasus_temp_city.dta

*Merges MinSaude data
merge 1:1 city_ibge_code year date using temp_datasets/minsaude.dta
 
*Generates 7-day moving average 
sort year city_ibge_code date
foreach i of varlist total {
gen `i'_ma = (`i' + `i'[_n-1] + `i'[_n-2] + `i'[_n-3] + `i'[_n-4] + `i'[_n-5] + `i'[_n-6])/7  if city_ibge_code==city_ibge_code[_n-6]
}

***FIGURES***

*Weird data
do replication/graph_excess_munic.do `end' `x' "Distrito Federal" 530010 100 15may2020 1
do replication/graph_excess_munic.do `end' `x' "Belo Horizonte" 310620 100 25mar2020 0
do replication/graph_excess_munic.do `end' `x' Goiânia 520870 100 25mar2020 0

*Clear no excess
do replication/graph_excess_munic.do `end' `x' Curitiba 410690 100 25jun2020 1
do replication/graph_excess_munic.do `end' `x' Campinas 350950 50 25mar2020 1
do replication/graph_excess_munic.do `end' `x' "Porto Alegre" 431490 100 25mar2020 0

*Excess but noisy data
do replication/graph_excess_munic.do `end' `x' "São Luís" 211130 100 5apr2020 1
do replication/graph_excess_munic.do `end' `x' Maceió 270430 100 1apr2020 1
do replication/graph_excess_munic.do `end' `x' Recife 261160 150 5apr2020 1
do replication/graph_excess_munic.do `end' `x' Belém 150140 100 10apr2020 1
do replication/graph_excess_munic.do `end' `x' Salvador 292740 100 20apr2020 1

*Clear excess
do replication/graph_excess_munic.do `end' `x' "São Gonçalo" 330490 50 1apr2020 1
do replication/graph_excess_munic.do `end' `x' Manaus 130260 150 24mar2020 1
do replication/graph_excess_munic.do `end' `x' "São Paulo" 355030 350 5mar2020 1
do replication/graph_excess_munic.do `end' `x' "Rio de Janeiro" 330455 350 25mar2020 1
do replication/graph_excess_munic.do `end' `x' Fortaleza 230440 200 5apr2020 1
do replication/graph_excess_munic.do `end' `x' Guarulhos 351880 50 5mar2020 1


*Excess death calculation for 6 cities with clear excess deaths
scalar excess_sum = excess_330490 + excess_130260 + excess_355030 + excess_330455 + excess_230440 + excess_351880
scalar official_sum = official_330490 + official_130260 + official_355030 + official_330455 + official_230440 + official_351880
scalar ratio = excess_sum/official_sum
 scalar list excess_sum official_sum ratio


 
 
