args end x name i ymax begin show

*Excess death numbers
qui sum total if date>=td(`begin') & date<=td(`end') & city_ibge_code==`i' & year==2020
 scalar deaths2020_`i' = r(sum)
qui sum total if date>=td(`begin') & date<=td(`end') & city_ibge_code==`i' & year==2019
 scalar deaths2019_`i' = r(sum)
scalar excess_`i' = deaths2020_`i' - deaths2019_`i'
scalar temp1 = (deaths2020_`i'/deaths2019_`i' - 1)*1000
scalar temp2 = floor(temp1)
scalar percent = temp2/10
qui sum obitosAcumulado if date==td(`end') & year==2020 & city_ibge_code==`i'
scalar official_`i' = r(mean)

*Extract days
qui sum day if date==td(`begin') 
 scalar daybegin = r(mean)
qui sum day if date==td(`end') 
 scalar dayend = r(mean) 
 
*Extract monthbegin
qui sum month if date==td(`begin') 
  if r(mean)==3 { 
	scalar monthbegin = "Mar"
}
else if r(mean)==4 { 
	scalar monthbegin = "Apr" 
}
else if r(mean)==5  {
	scalar monthbegin = "May"
}
else if r(mean)==6  {
	scalar monthend = "Jun"
}
else if r(mean)==7  {
	scalar monthend = "Jul"
}
else if r(mean)==8  {
	scalar monthend = "Ago"
}
*Extract monthend
qui sum month if date==td(`end')
  if r(mean)==3 { 
	scalar monthend = "Mar"
}
else if r(mean)==4 { 
	scalar monthend = "Apr" 
}
else if r(mean)==5  {
	scalar monthend = "May"
}
else if r(mean)==6  {
	scalar monthend = "Jun"
}
else if r(mean)==7  {
	scalar monthend = "Jul"
}
else if r(mean)==8  {
	scalar monthend = "Ago"
}

if excess_`i'>=0 {
 scalar abovebelow = "above"
}
else if excess_`i'<0 {
 scalar	abovebelow = "below"
 scalar percent = -percent
}

*Whether or not to show excess death calculation
if `show'==1 {
local note "" " " " "`=excess_`i'' excess deaths between `=daybegin'/`=monthbegin' - `=dayend'/`=monthend', 2020" "(`=percent'% `=abovebelow' 2019 levels)" " " "Total covid-19 deaths confirmed by" "Health Ministry by `=dayend'/`=monthend': `=official_`i''", ring(0) pos(1) size(*0.9)" 
}
else if `show'==0 {
	local note  " " " "Total covid-19 deaths confirmed by" "Health Ministry by `=dayend'/`=monthend': `=official_`i''", ring(0) pos(1) size(*0.9)"
}
 
*Graph
twoway ///  
 line `x' date if city_ibge_code==`i' & year==2019, lw(medthick) lc(cranberry) || ///
 line `x' date if city_ibge_code==`i' & year==2018, lw(medthin) lc(gs12) || ///
 line `x' date if city_ibge_code==`i' & year==2017, lw(medthin) lc(gs10) || ///
 line `x' date if city_ibge_code==`i' & year==2016, lw(medthin) lc(gs8) || ///
 line `x' date if city_ibge_code==`i' & year==2020 & date<=td(`end'), lw(medthick) lc(black) ||  ///
 line `x' date if city_ibge_code==`i' & year==2019.5, lw(medthick) lc(dkorange)  || ///
 scatter `x' date if city_ibge_code==`i' & year==2020 & date==td(`begin'), mc(navy) msize(tiny) ///
 graphregion(color(white)) ///
 legend(order( 5 "2020 (Arpen)" 1 "2019 (Arpen)" 6 "2019 (Datasus)"  2 "2018 (Datasus)"  3 "2017 (Datasus)" 4 "2016 (Datasus)") rows(2) size(small)) ///
 tlabel(07jan2020 01feb2020 01mar2020 01apr2020 01may2020 01jun2020 01jul2020 `end' 31dec2020, format(%dd-m) labsize(small)) ///
 ytitle("Daily Deaths (7-day Rolling Average)", size(small))  ysc(r(0)) xtitle("") ///
 title("`name': Daily Deaths (All Non-External Causes - 7-Day Rolling Average)", size(small)) ylabel(0(50)`ymax', labsize(small)) ///
 note(`note')
 
graph export figures/excess_`i'.eps, as(eps) replace
graph export figures/excess_`i'.gif, as(gif) replace
