clc
clear
addpath('Programs')
lbl1=['CLAD_fixed_d_S_MC0'];

n=10000;
nboot=1000;
unix=1;
if unix
    mytask=getenv('SLURM_ARRAY_TASK_ID');
    ii=str2num(mytask);
else
    ii=1;
end

np=1;

nrep1=ii;
nrep2=ii;
nrep=1000;
 
logfile_name=strcat(lbl1,num2str(ii,'%03i'),'-Diary.log');
delete(logfile_name);
diary(logfile_name);
diary on
fprintf('Hi there. I hope it is a beautiful day in Naperville\n\n');
fprintf('Todays date is: \n'); fprintf(date);
diary off;

should_print=true;

k=5;




bhat=zeros(nrep,k);
shat1=zeros(nrep,k);
fcts=zeros(nrep,1);

d1=eye(k);
d2=zeros((k*(k-1)),k);
ij=1;
for i=1:(k-1)
    for j=(i+1):k
            d2(ij,i)=1;
            d2(ij,j)=1;
            ij=ij+1;
            d2(ij,i)=1;
            d2(ij,j)=-1;
            ij=ij+1;
    end
end
d2=d2';
directions=[d1 d2];
ndirections=size(directions,2);

for irep=nrep1:nrep2
    
    
    diary on;
    fprintf('\n')
    fprintf('\n*************************************************\n')
    fprintf('\nReplication Number: %d\n',irep)
    fprintf('\n*************************************************\n')
    diary off;
    
    tic
    rng(7509+31*irep,'twister');
    k=5;

    x=(randn(n,k-1)+randn(n,1)*ones(1,k-1))./sqrt(2);
    x(:,1:3)=(x(:,1:3) >= 0.0);
    x=[x ones(n,1)];
    beta=zeros(k,1);
    beta(1:5)=(1:5)./5;
    epsilon=randn(n,1).*(1+x(:,1));
    y=x*beta+epsilon;
    y=y.*(y>0);

    bs = rq(x, y, 0.5);
    para=[1000;0.0001;0.5];
    [bclad,ico]=clad(y,x,bs,para);
    bhat(irep,:)=bclad';
    
    xhat=x*bclad;
    ee=x.*repmat(sign(y-xhat).*(xhat>0),1,k);
    SHAT=cov(ee);

    dat=[y,x];


    
    bclad_boot=zeros(nboot,k);
    b_directional=zeros(nboot,ndirections);
    
    a_s=zeros(nboot*ndirections,1);
    delta_s=zeros(nboot*ndirections,k);
    boot_id=zeros(nboot*ndirections,1);
    iii=ceil(n*rand(n,nboot));
    S=zeros(nboot,k);

    for iboot=1:nboot
        % Draw a bootstrap sample

        datb=dat(iii(:,iboot),:);
        yb=datb(:,1);
        xb=datb(:,2:k+1);
        
        xbhat=xb*bclad;
        ee=xb.*repmat(sign(yb-xbhat),1,k);
        S(iboot,:)=sum(ee(xbhat>0,:))/n;
         
        
        para=[1000;0.0001;0.5];
        [bclad_bs,ico]=clad(yb,xb,bs,para);
        bclad_boot(iboot,:)=bclad_bs';



        % Calculate univarate estimators

        
        
        para=[1000 1.0d-5 0.5];
        
    
    
        for i=1:ndirections
            bb=clad_one_parameter(yb,[xbhat xb*directions(:,i)],0,para);
            b_directional(iboot,i)=bb;
        end


        a_s((iboot-1)*ndirections+1:(iboot-1)*ndirections+ndirections)= b_directional(iboot,:)';
        delta_s((iboot-1)*ndirections+1:(iboot-1)*ndirections+ndirections,:)= directions';
        boot_id((iboot-1)*ndirections+1:(iboot-1)*ndirections+ndirections)=zeros(ndirections,1)+iboot;        
        

    end

    

    shat1(irep,:)=std(bclad_boot);
    
    if unix==1
        filename=['results/' lbl1 '_deltas_and_as_fixed_directions' num2str(irep) '.mat']; 
    else
        filename=[lbl1 '_deltas_and_as_fixed_directions' num2str(irep) '.mat']; 
    end
	save(filename, 'beta', 'bclad', 'a_s', 'delta_s', 'boot_id','shat1','S','SHAT');
    toc
	   
end


    


    

    
    


