function [b,ico]=clad(y,x,best,para)

% /*  This routine calculates the CLAD and censored quantile regression
%     estimator from Powell (1986).
% 
%     Inputs:
%         y       (n x 1)     dependent variable
%         x       (n x k)     independent variable
%         best     (k x 1)     starting value
%         para    (3 x 1)     para[1]=maximum number of iterations
%                             para[2]=maximum change in parameter
%                             para[3]=quantile
% 
%     Outputs:
%         (1)     (k x 1)     parameter estimates
%         (2)     (1 x 1)     logical whick equals 1 if estimation is successful
%  */

    ico=1;
    maxit=para(1);
    mbdif=para(2);
    th=para(3);
    iter=0;
    [n, k]=size(x);
    should_stop=0;
    while (iter <=maxit)&&(should_stop==0)
        iter=iter+1;
%         iter
        b=best;
        if (iter==1) 
            bold=best; 
        else 
            bold=[bold best]; 
        end
        xb=x*b;
        ii=find(xb>0);
        yy=y(ii);
        xx=x(ii,:);
        [s1, s2]=size(xx);
        if (s1<s2)
          bdif=mbdif+1;
%           'rank'
          ico=0;
          should_stop=1;
        else 
            best = rq(xx, yy, th);
            bdif=sqrt(mean((bold-repmat(best,1,size(bold,2))).^2));
%             min(bdif)
%             [ bold best]
            if (min(bdif)<mbdif)
%                 'bd'
                should_stop=1;
            end
        end
    end;
    if iter>maxit
        ico=0;
    end
    ii=find(bdif==min(bdif));
    bold=[bold(:,ii:size(bold,2)) best];
    f=clad_fct(y,x,bold);
    ii=find(f==min(f));
    b=bold(:,ii(1));
end

