function b=clad_one_parameter(y,x,best,para)

% /*  This routine calculates the CLAD and censored quantile regression
%       (not yet)
%     estimator from Powell (1986), HOLDING the coefficient on x(:,1) at 1 and
%     estimating the coefficient on x(:,2). x has dimension 2 
% 
%     Inputs:
%         y       (n x 1)     dependent variable
%         x       (n x 2)     independent variable

%         best     (1 x 1)     starting value
%         para    (3 x 1)     para[1]=maximum number of iterations
%                             para[2]=maximum change in parameter
%                             para[3]=interval width (divided by 2)
% 
%     Outputs:
%         (1)     (1 x 1)     parameter estimate (on x2)
%  */

    
    fun=@(b)clad_fct(y,x,[1;b]);
    [b,fx]=linmin(fun,best,para(3),para(2),para(1));

end

