function [Vcf Hcf V H fctVH]= solve_for_V_and_H_Version3(OMEGA1, OMEGA2, D2, should_print) 

if (nargout~=2)&&(nargout~=5)
    fprintf('\nNumber of Aguments in solve_for_V_and_H_Version1 is incorrect\n')
    stop
end

[Valt,Halt]=solve_for_V_and_H_closed_form(OMEGA1, OMEGA2, D2) ;
Hcf=Halt;
Vcf=Valt;
 
if nargout==5     

    [R,p] = chol(Halt);
   
    if (p>0)
         Valt=OMEGA1;
         Halt=eye(size(OMEGA1,1));
    end;
    Halt;

    k=size(D2,1);
    m2=size(D2,2);
    if should_print;
        disp='iter';
    else;
        disp='off';
    end;

    disp='off';

    Im=eye(m2);
    C2=D2(:,1)*Im(1,:);
    for i=2:m2;  
        C2=[C2; D2(:,i)*Im(i,:)];
    end;

    b=fromVHtoTHETA1(Valt,Halt);
    xdata=[repmat(OMEGA1,1,k);D2;OMEGA2;C2];
    
    fval=f_nlls7(b,OMEGA2,C2,D2);

        
%     np=1800;
%     dth=5;
%     [b,fval]=bo_pso(@(b) f_nlls7(b,OMEGA2,C2,D2),np,b-dth,b+dth,0.1,2,np,100,b);
%     fval
    
    fval_old=fval+1;
    
    while (fval_old > fval+0.01)
        fval_old=fval;
        
        options=optimoptions('lsqcurvefit','MaxFunEvals',100000,'MaxIter',5000,'Display','off');
        [b, fval, residual,exitflag]=lsqcurvefit(@f_nlls7f,b,xdata,zeros(k^2,k^2),[],[],options);
        
        np=800;
        dth=0.5;
        
        fh = @(b) f_nlls7(b',OMEGA2,C2,D2);
        options=optimoptions('particleswarm','SwarmSize',np,'Display','off','InitialSwarm',b','MaxTime',12*60*60,'UseParallel',false);
        [b_ps,fval_ps]=particleswarm(fh,length(b),(b-dth)',(b+dth)',options);
        if (fval_ps<fval)
            fval=fval_ps;
            b=b_ps';
        end
        
%         fprintf('fminsearch \n\n');
        opti=optimset('Display','off','MaxFunEvals',50000,'MaxIter',1000,'TolFun',1.0e-10,'TolX',1.0e-8);
        [b_nm, fval_nm]=fminsearch(@(b) f_nlls7(b,OMEGA2,C2,D2),b, opti);
        if (fval_nm<fval)
            fval=fval_nm;
            b=b_nm;
        end
        
        np=800;
        dth=0.1*abs(b)+0.01;
        fh = @(b) f_nlls7(b',OMEGA2,C2,D2);
        options=optimoptions('particleswarm','SwarmSize',np,'Display','off','InitialSwarm',b','MaxTime',12*60*60,'UseParallel',false);
        [b_ps,fval_ps]=particleswarm(fh,length(b),(b-dth)',(b+dth)',options);
        if (fval_ps<fval)
            fval=fval_ps;
            b=b_ps';
        end
    end

        

    


    [V,H]=fromTHETAtoVH1(b);
    fctVH=fval;
    
    
end 
	
end



