clear
addpath('L:\Hu10\MCtest\CLAD\2018Unix\Sol4HV')
rng(7509+31*1,'twister');
    k=5;
    n=100000;

    x=(randn(n,k-1)+randn(n,1)*ones(1,k-1))./sqrt(2);
    x(:,1:3)=(x(:,1:3) >= 0.0);
    x=[x ones(n,1)];
    beta=zeros(k,1);
    beta(1:5)=(1:5)./5;
    epsilon=randn(n,1).*(1+x(:,1));
    
    xf=x.*repmat(normpdf(zeros(n,1),0,( (1+x(:,1)))),1,k);
    xb=x*beta;
    ii=find(xb>0);
    xx=x(ii,:);
    xf=xf(ii,:);
    v=xx'*xx/n;
    h=xx'*xf/n;
    hinv=inv(h);
    vhat=(1/4)*hinv*v*hinv';
    shat_asy=sqrt(diag(vhat)/10000);

nrep=1000;
k=5;
results=struct('tstats',[],'shats',[],'th_hats',[],'Htot',[],'Vtot',[]);

for imethod=1:1
    tstats=zeros(nrep,k);
    shats=zeros(nrep,k);
    th_hats=zeros(nrep,k);
    Htot=zeros(k,k);
    Vtot=zeros(k,k);
    
    tstats1=zeros(nrep,k);
    tstats2=zeros(nrep,k);
    shats1=zeros(nrep,k);
    


    for ire=1:nrep

        ire
        filename=['L:\Hu10\MCtest\CLAD\2018Unix\results\CLAD_fixed_d_S_MC0_deltas_and_as_fixed_directions' num2str(ire) '.mat']; 
        load(filename);
        shats1(ire,:)=shat1(ire,:);
        id=unique(boot_id);
        nboot=length(id);
        k=size(delta_s,2);

        Coefs(nboot) = struct('cH', [], 'cS', []);
        Xtilde=zeros(length(a_s),k*(k+1)/2);
        
        ahat=zeros(nboot,k*k);
        for ib=1:nboot
           ii=find(boot_id==id(ib));
           a=a_s(ii);
           ahat(ib,:)=a';
        end
%         ahat=normal_lize(ahat);

%         ahat=ahat-0*repmat(mean(ahat),size(ahat,1),1);
          
        for ib=1:nboot
           ii=find(boot_id==id(ib));
           a=ahat(ib,:)';
           delta=delta_s(ii,:);
           X=zeros(size(delta,1),k*(k+1)/2);
           Z=zeros(size(delta,1),k);
           for idelta=1:size(delta,1);
               coef_on_h=zeros(k,k);
               coef_on_s=delta(idelta,:);
               for j=1:k
                   for l=1:k
                       coef_on_h(j,l)=delta(idelta,j)*delta(idelta,l)*a(idelta);
                   end
               end
               coef_on_h=-diag(diag(coef_on_h))+2*coef_on_h;
               X(idelta,:)=vecdiag(coef_on_h)';
               Z(idelta,:)=coef_on_s;
           end
           Coefs(ib).cH=X;
           Coefs(ib).cS=Z;
           PZ=Z*inv(Z'*Z)*Z';
           MZ=eye(size(PZ,1))-PZ;
           Xt=MZ*X;
           Xtilde(ii,:)=Xt;
        end

        XtXt=Xtilde'*Xtilde;
        kk=size(XtXt,1);
        A=XtXt(1:k,1:k);
        B=XtXt(1:k,(k+1):kk);
        C=XtXt((k+1):kk,(k+1):kk);
        AA=A-(B/C)*B';
        [v,e]=eig(AA);

        if imethod==1
            e=diag(e);
            emin=min(e);
            imin=find(e==emin);
            imin=imin(1);
            b1=v(:,imin);
            b2=-C\B'*b1;
            b=[b1;b2];
%             imethod
%             b
        elseif imethod==2
            xx=-Xtilde(:,2:size(Xtilde,2));
            yy=Xtilde(:,1);
            bb=regress(yy,xx);
            b=[1;bb];
%             imethod
%             b
        else % will not use
            xx=-[Xtilde(:,1:3) Xtilde(:,5:size(Xtilde,2)) ];
            yy=Xtilde(:,4);
            bb=regress(yy,xx);
            b=[bb(1:3);1;bb(4:size(Xtilde,2)-1)];
            imethod
            b
        end



        s_estimates=zeros(nboot,k);

    %     V=zeros(k,k);
        for ib=1:nboot
           y=Coefs(ib).cH*b;
           z=Coefs(ib).cS;
           s=(z'*z)\z'*y;
    %        e=y-z*s;
    %        Vs=inv(z'*z)*(e'*e)/(size(z,1)-size(z,2));
    %        ss_star=s*s'-Vs;
    %        V=V+ss_star;
           s_estimates(ib,:)=s';
        end
    %     V=V/nboot;

        H=ivecdiag(b);
        H=-diag(diag(H))+H+H';
        H=H*(H(1,1)/abs(H(1,1)));
        V=robust_cov(s_estimates);
        Htot=Htot+H;
        Vtot=Vtot+V;
        Hinv=inv(H);
        Vth=Hinv'*V*Hinv;
        s=sqrt(diag(Vth));

        shats(ire,:)=s';
        tstats(ire,:)=((bclad-beta)./s)';
        tstats1(ire,:)=((bclad-beta)./shats1(ire,:)')';
        tstats2(ire,:)=((bclad-beta)./shat_asy)';
        th_hats(ire,:)=bclad';

    end
    
    results(imethod).tstats=tstats;
    results(imethod).shats=shats;
    results(imethod).th_hats=th_hats;
    results(imethod).Htot=Htot;
    results(imethod).Vtot=Vtot;
    
    fprintf('\n')
 
    fprintf('ours')
    pmatrix([mean(abs(tstats)>1.28);std(tstats)])
    fprintf('regular BS')
    pmatrix([mean(abs(tstats1)>1.28);std(tstats1)])
    fprintf('asymptotic')
    pmatrix([mean(abs(tstats2)>1.28);std(tstats2)])
    
    fprintf('\n')
    fprintf('\n')
    fprintf('ours')
    pmatrix([mean(shats); median(shats)])
    fprintf('regular BS')
    pmatrix([mean(shats1); median(shats1)])
    fprintf('asymptotic')
    pmatrix(shat_asy')
    fprintf('empirical')
    pmatrix(std(th_hats))
    
    
end
save('CLAD_results','results');




