clear
addpath('L:\Hu10\MCtest\CLAD\2018Unix\Sol4HV')
rng(7509+31*1,'twister');
    k=5;
    n=100000;

    x=(randn(n,k-1)+randn(n,1)*ones(1,k-1))./sqrt(2);
    x(:,1:3)=(x(:,1:3) >= 0.0);
    x=[x ones(n,1)];
    beta=zeros(k,1);
    beta(1:5)=(1:5)./5;
    epsilon=randn(n,1).*(1+x(:,1));
    
    xf=x.*repmat(normpdf(zeros(n,1),0,( (1+x(:,1)))),1,k);
    xb=x*beta;
    ii=find(xb>0);
    xx=x(ii,:);
    xf=xf(ii,:);
    v=xx'*xx/n;
    h=xx'*xf/n;
    hinv=inv(h);
    vhat=(1/4)*hinv*v*hinv';
    shat_asy=sqrt(diag(vhat)/10000);

nrep=1000;
k=5;
results=struct('tstats',[],'shats',[],'th_hats',[],'Htot',[],'Vtot',[]);

    tstats1=zeros(nrep,k);
    shats1=zeros(nrep,k);
    tstats2=zeros(nrep,k);
    
    tstats=zeros(nrep,k);
    shats=zeros(nrep,k);
    th_hats=zeros(nrep,k);
    Htot=zeros(k,k);
    Vtot=zeros(k,k);
    d1=eye(k);
    d2=zeros((k*(k-1)),k);
    ij=1;
    for i=1:(k-1)
        for j=(i+1):k
                d2(ij,i)=1;
                d2(ij,j)=1;
                ij=ij+1;
                d2(ij,i)=1;
                d2(ij,j)=-1;
                ij=ij+1;
        end
    end
    d2=d2';
    directions=[d1 d2];

    for ire=1:nrep

        fprintf('ire = %6i\n',ire)
        filename=['L:\Hu10\MCtest\CLAD\2018Unix\results\CLAD_fixed_d_S_MC0_deltas_and_as_fixed_directions' num2str(ire) '.mat']; 
        load(filename);
        shats1(ire,:)=shat1(ire,:);
        id=unique(boot_id);
        nboot=length(id);
        k=size(delta_s,2);


        
        ahat=zeros(nboot,k*k);
        for ib=1:nboot
           ii=find(boot_id==id(ib));
           a=a_s(ii);
           ahat(ib,:)=a';
        end
%         ahat=normal_lize(ahat);

%         ahat=ahat-0*repmat(mean(ahat),size(ahat,1),1);
          
        OMEGA2=cov(ahat);
        OMEGA1=OMEGA2(1:k,1:k);
        D2=directions;
            
        [Vcf Hcf V H fctVH]= solve_for_V_and_H_Version2018(OMEGA1, OMEGA2, D2, 0) ;

        Htot=Htot+H;
        Vtot=Vtot+V;
        Hinv=inv(H);
        Vth=Hinv'*V*Hinv;
        s=sqrt(diag(Vth));

        shats(ire,:)=s';
        tstats(ire,:)=((bclad-beta)./s)';
        tstats1(ire,:)=((bclad-beta)./shats1(ire,:)')';
        tstats2(ire,:)=((bclad-beta)./shat_asy)';
        th_hats(ire,:)=bclad';

    end
    
    results.tstats=tstats;
    results.shats=shats;
    results.th_hats=th_hats;
    results.Htot=Htot;
    results.Vtot=Vtot;
    
    fprintf('\n')
 
    fprintf('ours')
    pmatrix([mean(abs(tstats)>1.28);std(tstats)])
    fprintf('regular BS')
    pmatrix([mean(abs(tstats1)>1.28);std(tstats1)])
    fprintf('asymptotic')
    pmatrix([mean(abs(tstats2)>1.28);std(tstats2)])
    
    fprintf('ours')
    pmatrix([mean(shats); median(shats)])
    fprintf('regular BS')
    pmatrix([mean(shats1); median(shats1)])
    fprintf('asymptotic')
    pmatrix(shat_asy')
    fprintf('empirical')
    pmatrix(std(th_hats))
    
    

save('CLAD_results_HV');