#!/bin/bash
# this assumes you cd to the dir containing two subdirs:
#   - "mfiles" with matlab scripts you need
#   - "jobstdout" where you might want to put stdoutput
# and job output directory

#SBATCH --workdir=.
#SBATCH --time=0-3:59:00
#SBATCH --cpus-per-task=1 --mem=4096
#SBATCH -J stage1
#SBATCH --mail-type=ALL
#SBATCH -o 'jobstdout/slurm-%j.log'
#SBATCH --array=1-1000

scontrol show job $SLURM_JOB_ID
# the following lines assume modules
. /usr/share/Modules/init/bash
module purge
module load matlab

hostname
date

matlab -nodisplay -r "CLAD_fixed_directions_S_MC0Unix; exit;"

