program fhh,eclass
version 10.1

	if replay() {
		display "Replay not implemented"
	}
	else {
		syntax varlist(min=5) [if] [in] [, DETails, tau(real 100), NODummy]

		local g_id: word 1 of `varlist'
		local p_id: word 2 of `varlist'
		local calt: word 3 of `varlist'
		local depvar: word 4 of `varlist'
		local S: word 5 of `varlist'
		local x1: word 6 of `varlist'

		if (("`x1'"=="")&("`nodummy'"=="nodummy")) display as err "If you specify nodummy, you must supply covariates!"
		else {
		local nox=0
		if ("`x1'"=="") local nox=1

		local printdetails=1
		if !("`details'"=="details") local printdetails=0

		local nod=0
		if ("`nodummy'"=="nodummy") local nod=1

		marksample touse
 
		display " "
		display as text _dup(78) "="
		display " "
		display "FHH:     Estimation of Grouped Duration Model"
		display "         Based on Frederiksen, Honor and Hu (2007)"
		display "         Version 0.2"
		display " "
		display as text _dup(78) "-"
		display " "

		tempname b V nn ch2 
		mata: fhhmata("`varlist'","`touse'",`printdetails', `tau', `nox', `nod')

		
		mat b = r(beta)
		mat V= r(V)
		matrix `nn'= r(N)
		matrix `ch2'= r(chi2)
		
		local ncoef=colsof(b)
		local  ddd=""


		if (`nox'==0) {
 		local nvars=`ncoef'-`nn'[3,1]+1
		if (`nod'==1) local nvars=`ncoef'
		local i
		forvalues i=1/`nvars' {
		local j=`i'+5
		local expvar: word `j' of `varlist'
		local ddd="`ddd' `expvar'" 
		}
		}



		if (`nod'==0) {
		local k=`nvars'+1
		forvalues i=`k'/`ncoef' {
		local j=`i'-`k'+2
		local ddd="`ddd' Duration_`j'" 
		}
		}

		matrix colnames b= `ddd'  
		matrix colnames V= `ddd'   
		matrix rownames V= `ddd' 


	
		local N = `nn'[1,1]

		ereturn clear	

		ereturn post b V, depname(`depvar') obs(`N') esample(`touse')
		ereturn local cmdline `"`0'"'
		ereturn local cmd "fbb"
		if (`printdetails'==1) display as text _dup(78) "-"
		display " "
		display as txt "Number of Obs  :" as res %16.0f `nn'[1,1] %22s " " as txt %-10s "Unit ID:" as res %14s "`g_id'"
		display as txt "Number of Units:" as res %16.0f `nn'[2,1] %22s " " as txt %-10s "Obs. ID:"  %14s as res "`p_id'"
		display as txt "Tau:            " as res %16.0f `tau' %22s " " as txt %-13s "ChiSq:"%11.2f as res `ch2'[1,1]
		display as txt "Maximum Duration:  " as res %13.0f `nn'[3,1] %22s " " as txt %-18s "Prob > ChiSq:"%6.4f as res `ch2'[2,1]


		display " "
		ereturn display 
		display " "
		display as text _dup(78) "="
		}

	}
end
