function [ I1 ] = I1_varcorr(X,level_vec)
% Compute summary statistics for varcorr problem
% X is cosine transform
% level vec is percentiles, level_vec = [0.67 0.90]' for example
%
q = size(X,1);
X_cos = X(:,1);
Y_cos = X(:,2);

tmp = (1:1:q)';
wght = pi*tmp;
% % Normalize weights to sum to q so scaling is the same as I(0)
wght = wght/mean(wght);

X_cos = X_cos.*wght;
Y_cos = Y_cos.*wght;

% Construct weights and reweight the terms

rhohat = (Y_cos'*X_cos)/sqrt((X_cos'*X_cos)*(Y_cos'*Y_cos));
I1.rhohat = rhohat;

%  Compute Regression Coefficient, etc.
bhat = X_cos\Y_cos;
I1.bhat = bhat;
xxi = 1/(X_cos'*X_cos);
Yhat_cos = X_cos*bhat;
U_cos = Y_cos-Yhat_cos;
ssr = U_cos'*U_cos;
tss = Y_cos'*Y_cos;
rss = Yhat_cos'*Yhat_cos;
s2_u = ssr/(q-1);
I1.ssr = ssr;
I1.sigma2hat = s2_u;
se_bhat = sqrt(s2_u*xxi);
r2 = 1-ssr/tss;
I1.r2 = r2;
beta_ci = NaN(size(level_vec,2),2);
rho_ci = NaN(size(level_vec,2),2);
sigma2_ci = NaN(size(level_vec,2),2);
for i = 1:size(level_vec,2);
    tcv = tinv(1-level_vec(i)/2,q-1);
    beta_ci(i,1) = bhat-tcv*se_bhat;
    beta_ci(i,2) = bhat+tcv*se_bhat;
    pctl = level_vec(i)/2;
    pctu = 1-pctl;
    nrep = 50000;
    e1 = randn(q,nrep);
    e2 = randn(q,nrep);
    a11 = sum(e1.^2)';
    a22 = sum(e2.^2)';
    a12 = sum(e1.*e2)';
    ngrid = 501;
    rho_grid = linspace(-1,1,ngrid)';
    pctl_vec = NaN(ngrid,1);
    pctu_vec = NaN(ngrid,1);
    syy = a11;
    for ii = 1:ngrid;
      rho = rho_grid(ii);
      tmp = sqrt(1-rho*rho);
      syx = rho*a11+tmp*a12;
      sxx = rho*rho*a11 + tmp*tmp*a22 + 2*rho*tmp*a12;
      rhat = syx./sqrt(sxx.*syy);
      pct = pctile(rhat,[pctl;pctu]);
      pctl_vec(ii) = pct(1);
      pctu_vec(ii) = pct(2);
    end;
    tmp = (pctl_vec < rhohat).*(pctu_vec > rhohat);
    if sum(tmp) > 0;
     cor_cset = rho_grid(tmp==1);
     rho_ci(i,1) = min(cor_cset);
     rho_ci(i,2) = max(cor_cset);
    end;
    % sigma2 confidence set
    chi_l = chi2inv(pctl,q-1);
    chi_u = chi2inv(pctu,q-1);
    sigma2_ci(i,1) = ssr/chi_u;   % Times q because we care about trace
    sigma2_ci(i,2) = ssr/chi_l;
end;
I1.beta_ci = beta_ci;
I1.rho_ci = rho_ci;
I1.sigma2_ci = sigma2_ci;  
end

