function [ rslt ] = b_compute(data,lfparm,dens_h0,dens_h1,dens_ystar,dens_w_ystar,beta_compute,parmdir)
% This version 11/15/2017, mww

tol = .01;   % tolerance for posterior.  It should integrated to 1-tol
% Construct Results for Absolute value of Correlations 

level_vec = lfparm.level_vec/100;  %Percentiles

% Read in Sigma matrix parameters under H1 values of parameters
% q variables
q = lfparm.q; 
qstr = ['_' num2str(q)];    
str_tmp = [parmdir 'Parm_h1_' lfparm.problem_label qstr]; 
load (str_tmp);
str_tmp = [parmdir 'Parm_h0_' lfparm.problem_label qstr];
load (str_tmp);
str_tmp = [parmdir 'alfd_h0_' lfparm.problem_label qstr]; 
load (str_tmp);

% -- Compute a grid of values of beta .. begin with I(0) confidence set
 X = data.X(:,1);
 Y = data.X(:,2);
 
 % Some percentiles for the grid points
 pct_vec = linspace(.00001,.001,15)';
 pct_vec = [pct_vec;linspace(.0015,.05,30)'];
 pct_vec = [pct_vec;linspace(.055,.10,30)'];
 pct_vec = [pct_vec;linspace(.11,.495,30)'];

 if q == 3;
  pct_vec = linspace(.0001,.001,15)';
  pct_vec = [pct_vec;linspace(.0015,.05,30)'];
  pct_vec = [pct_vec;linspace(.055,.10,30)'];
  pct_vec = [pct_vec;linspace(.11,.495,30)'];
 end;
 
 if q == 2;
  pct_vec = linspace(.005,.010,20)';
  pct_vec = [pct_vec;linspace(.02,.05,30)'];
  pct_vec = [pct_vec;linspace(.055,.10,30)'];
  pct_vec = [pct_vec;linspace(.11,.495,30)'];
 end;
     
 pct_vec = [pct_vec;flipud(1-pct_vec)];
 [beta_vec delta_beta sebhat] = beta_grid(X,Y,pct_vec);  


% Construct Average likelihood*scale value under alternative values of theta
avg_like_h1 = compute_avg_like_h1(dens_h1,data,Parm_h1); 

% Bayes Posterior:
% % Compute marginal likelihood using theta1 with uniform prior
avg_like_ystar = compute_avg_like_h1(dens_ystar,data,Parm_h1); 

isig = 1 ;
nsig_max = 5;
while isig <= nsig_max;
  ngrid = size(beta_vec,1);
  posterior = NaN(ngrid,1);
  for ii = 1:ngrid;
    b_theta_test = beta_vec(ii);
    data.W = (data.U(1,1)*b_theta_test - data.U(1,2))/data.U(2,2); 
    posterior(ii) = compute_avg_like_h1(dens_w_ystar,data,Parm_h1); 
  end;
  % normalize by marginal likelihood;
  posterior = posterior/avg_like_ystar;
  % normalize posterior so that sum (not integral) is equal to 1
  posterior = posterior.*delta_beta*abs(data.U(1,1)/data.U(2,2));
     if sum(posterior) < 1-tol;
      isig = isig+1;
      fprintf('    Posterior integrates to: %6.3f \n',sum(posterior));
      fprintf('       Minimum and Maximum values %9.4g %9.4g \n',[beta_vec(1) beta_vec(end)]);
      if isig <= nsig_max;
        % Expand Grid;
        tmp = [0.025; (0.1:0.1:0.9)'];
        tmp = tmp*pct_vec(1);
        pct_vec = [tmp;pct_vec;flipud(1-tmp)];
        [beta_vec delta_beta sebhat] = beta_grid(X,Y,pct_vec);   
        fprintf('      Beta: increasing number of grid points for posterior \n');
      else
        fprintf('Warning: Beta Results may not be accurate, posterior integrates to %6.3f \n\n',sum(posterior)); 
      end;
    else
      isig = 100;
    end;  
end;
beta_vec_posterior = beta_vec;
% Add 2 additional element to sig_vec so that posterior sums to unity;
post_error = 1-sum(posterior);
if post_error > 0;
   beta_vec_posterior = [beta_vec(1)-delta_beta(1);beta_vec;beta_vec(end)+delta_beta(end)];
   posterior = [post_error/2;posterior;post_error/2];
end;
posterior = posterior/sum(posterior);
 
% Compute Prior and posterior mean and median
  prior_mean = NaN;
  posterior_mean = posterior'*beta_vec_posterior;
  prior_median = NaN;
  posterior_median = df_pct(posterior,beta_vec_posterior,0.5);

ibeta = 1;
beta_vec = beta_vec_posterior;
while ibeta == 1;
  ngrid = size(beta_vec,1);
  beta_test = NaN(ngrid,size(lfparm.level_vec,2));
  for ii = 1:ngrid;
    b_theta_test = beta_vec(ii);
    data.W = (data.U(1,1)*b_theta_test - data.U(1,2))/data.U(2,2); 
    [avg_like_h0,tmp] =  compute_avg_like_h0(dens_h0,beta_compute,data,lfparm,Parm_h0,alfd_h0);
    beta_test(ii,:) = avg_like_h0 > avg_like_h1;
  end;   
 
  if sum(beta_test(1,:)) > 0;
      tmp = linspace(0.05,1.0,30)';
      tmp = flipud(tmp);
      tmp = beta_vec(1)-tmp*sebhat;
      beta_vec = [tmp;beta_vec];
      fprintf('\n \n Lowering beta_lower %6.3f \n',beta_vec(1));
  end;
  if sum(beta_test(end,:)) > 0;
      tmp = linspace(0.05,1.0,30)';
      tmp = beta_vec(end)+tmp*sebhat;
      beta_vec = [beta_vec;tmp];
      fprintf('\n \n Increasing sig_upper %6.3f \n',beta_vec(end));
  end;
  if sum(beta_test(1,:)) + sum(beta_test(end,:)) == 0;
      ibeta = 0;
      beta_ci = NaN(size(lfparm.level_vec,2),2);
      posterior_cs = NaN(size(lfparm.level_vec,2),2);
      posterior_cdf = NaN(size(lfparm.level_vec,2),2);
      prior_cs = NaN(size(lfparm.level_vec,2),2);
      for i = 1:size(lfparm.level_vec,2);
         if max(beta_test(:,i)) > 0;
          beta_ci(i,1) = min(beta_vec(beta_test(:,i)==1));
          beta_ci(i,2) = max(beta_vec(beta_test(:,i)==1));
         end;
         [posterior_cs(i,1) posterior_cdf(i,1)]=df_pct(posterior,beta_vec_posterior,level_vec(i)/2);
         [posterior_cs(i,2) posterior_cdf(i,2)]=df_pct(posterior,beta_vec_posterior,1-level_vec(i)/2);
         if isnan(beta_ci(i,1)) == 1;
             beta_ci(i,1) =  posterior_cs(i,1);
         end;
         if beta_ci(i,1) > posterior_cs(i,1);
             beta_ci(i,1) =  posterior_cs(i,1);
         end;
         if isnan(beta_ci(i,2)) == 1;
            beta_ci(i,2) =  posterior_cs(i,2);
         end;
         if beta_ci(i,2) < posterior_cs(i,2);
            beta_ci(i,2) =  posterior_cs(i,2);
         end;
      end;   
  end;
end;

% fprintf('Posterior CS CDF values \n');
% prtmat_comma_screen(posterior_cdf,'%5.3f','\n');

% Save results
rslt.posterior_cs = posterior_cs;
rslt.prior_cs = prior_cs;
rslt.prior_mean = prior_mean;
rslt.ci = beta_ci;
rslt.prior_median = prior_median;
rslt.posterior_mean = posterior_mean;
rslt.posterior_median = posterior_median;

end

