function [ beta_vec delta_beta sebhat  ] = beta_grid(X,Y,pct_vec )
% Compute Grid of values for sigma;

ndf = size(X,1)-size(X,2);
bhat = X\Y;
u = Y-X*bhat;
ssr = u'*u;
s2 = ssr/ndf;
sebhat = sqrt(s2/sum(X.^2));
t_pct = tinv(pct_vec,ndf);
b_pct = bhat+sebhat*t_pct;
delta_beta = b_pct(2:end)-b_pct(1:end-1);        % Cell width
beta_vec = (b_pct(1:end-1)+b_pct(2:end))/2;      % Midpoint

end

