function [ avg_lik_h0, beta_vec ] = compute_avg_like_h0(dens_h0,beta_compute,data,lfparm,Parm_h0,alfd_h0)
% This version 11/27/2016, mww
%  Compute lambda-weighted average density under h0
%  Also compute values of rho (parameter of interest) 
%


avg_lik_h0 = NaN(lfparm.number_th0,size(lfparm.level_vec,2));
beta_vec = NaN(lfparm.number_th0,1);   
% Parameter of interest
for ilevel = 1:size(lfparm.level_vec,2);                   % Different levels for test
    for igrid = 1:lfparm.number_th0;
        alfd=alfd_h0(ilevel,igrid);
        lams = alfd.lams;
        n_th = size(lams,1);
        like_h0 = NaN(n_th,1);
        for i = 1:n_th;
            % Compute Density
            Parm = Parm_h0(ilevel,igrid,i);
            like_h0(i) = dens_h0(Parm,data);
            if (i == 1) & (ilevel == 1);
               beta_vec(igrid) = beta_compute(Parm.omega);
            end;
         end;
         avg_lik_h0(igrid,ilevel) = mean(like_h0.*lams);  
    end; 
end;

end

