function [avg_like_h1,like_h1,posterior,beta_vec ] = compute_like_h1(dens_h1,beta_compute,data,Parm_h1)
% This version 11/27/2016, mww
%  Compute average density under h1
%  Compute posterior under uniform prior
%

n_th = size(Parm_h1,2);
like_h1 = NaN(n_th,1);
beta_vec = NaN(n_th,1);
for i = 1:n_th;
    % Compute Density
    Parm = Parm_h1(i);
    like_h1(i) = dens_h1(Parm,data);
    beta_vec(i) = beta_compute(Parm.omega);
end;
avg_like_h1 = mean(like_h1);
posterior = like_h1/sum(like_h1);

end

