function [ corr_rslt ] = corr_compute(data,lfparm,dens_h0,dens_h1,beta_compute,parmdir);
% This version 11/27/2016, mww
% Construct Results for Correlations 

level_vec = lfparm.level_vec/100;  %Percentiles

% Read in Sigma matrix parameters under H1 values of parameters
% q variables
q = lfparm.q;
qstr = ['_' num2str(q)];    
str_tmp = [parmdir 'Parm_h1_' lfparm.problem_label qstr]; 
load (str_tmp);
str_tmp = [parmdir 'Parm_h0_' lfparm.problem_label qstr];
load (str_tmp);
str_tmp = [parmdir 'alfd_h0_' lfparm.problem_label qstr]; 
load (str_tmp);

% Construct likelihood value for all values of theta under alternative
[avg_like_h1,like_h1,posterior,beta_vec_h1] = compute_like_h1(dens_h1,beta_compute,data,Parm_h1);
prior = ones(size(beta_vec_h1,1),1)/size(beta_vec_h1,1);  % Prior is uniform

% Compute Prior and posterior mean and median
prior_mean = prior'*beta_vec_h1;
posterior_mean = posterior'*beta_vec_h1;
prior_median = df_pct(prior,beta_vec_h1,0.5);
posterior_median = df_pct(posterior,beta_vec_h1,0.5);
beta2 = beta_vec_h1.^2;
r2_posterior_median = df_pct(posterior,beta2,0.5);

% Compute Confidence Sets
[avg_like_h0,beta_vec] =  compute_avg_like_h0(dens_h0,beta_compute,data,lfparm,Parm_h0,alfd_h0);
beta_test = avg_like_h0 > avg_like_h1;
% ---------- Repeat Using negative value of x(.,2) to get negative value of correlation ---------
data_neg = data;
data_neg.X(:,2) = -data_neg.X(:,2);
data_neg.Xstd(:,2) = -data_neg.Xstd(:,2);
avg_like_h1_neg = compute_avg_like_h1(dens_h1,data_neg,Parm_h1);
[avg_like_h0_neg,beta_vec_neg] =  compute_avg_like_h0(dens_h0,beta_compute,data_neg,lfparm,Parm_h0,alfd_h0);
beta_test_neg = avg_like_h0_neg > avg_like_h1_neg;
% Summarize positive and negative values of rho and results
beta_vec = [flipud(-beta_vec_neg);beta_vec];
beta_test = [flipud(beta_test_neg);beta_test];
beta_ci = NaN(size(lfparm.level_vec,2),2);
posterior_cs = NaN(size(lfparm.level_vec,2),2);
posterior_cdf = NaN(size(lfparm.level_vec,2),2);
prior_cs = NaN(size(lfparm.level_vec,2),2);

for i = 1:size(lfparm.level_vec,2);
    if max(beta_test(:,i)) > 0;
          beta_ci(i,1) = min(beta_vec(beta_test(:,i)==1));
          beta_ci(i,2) = max(beta_vec(beta_test(:,i)==1));
    end;
    [posterior_cs(i,1) posterior_cdf(i,1)]=df_pct(posterior,beta_vec_h1,level_vec(i)/2);
    [posterior_cs(i,2) posterior_cdf(i,2)]=df_pct(posterior,beta_vec_h1,1-level_vec(i)/2);
    prior_cs(i,1)=df_pct(prior,beta_vec_h1,level_vec(i)/2);
    prior_cs(i,2)=df_pct(prior,beta_vec_h1,1-level_vec(i)/2);
    if isnan(beta_ci(i,1)) == 1;
      beta_ci(i,1) =  posterior_cs(i,1);
    end;
    if beta_ci(i,1) > posterior_cs(i,1);
      beta_ci(i,1) =  posterior_cs(i,1);
    end;
    if isnan(beta_ci(i,2)) == 1;
      beta_ci(i,2) =  posterior_cs(i,2);
    end;
    if beta_ci(i,2) < posterior_cs(i,2);
      beta_ci(i,2) =  posterior_cs(i,2);
    end;
    prior_cs(i,1)=df_pct(prior,beta_vec_h1,level_vec(i)/2);
    prior_cs(i,2)=df_pct(prior,beta_vec_h1,1-level_vec(i)/2);
end;

% fprintf('Posterior CS CDF values \n');
% prtmat_comma_screen(posterior_cdf,'%5.3f','\n');

% Save results
corr_rslt.posterior_cs = posterior_cs;
corr_rslt.prior_cs = prior_cs;
corr_rslt.prior_mean = prior_mean;
corr_rslt.ci = beta_ci;
corr_rslt.prior_median = prior_median;
corr_rslt.posterior_mean = posterior_mean;
corr_rslt.posterior_median = posterior_median;
corr_rslt.r2_posterior_median = r2_posterior_median;

end

