function [ ctran ] = untitled(data,lfparm )
% Compute cosine transforms and standardized cosine transforms
%
x = data.x;
calvec = data.calvec;
% Eliminate any missing values
tmp = packr([calvec x]);
calvecp = tmp(:,1);
xp = tmp(:,2:end);
ismpl = smpl(calvecp,lfparm.sfirst,lfparm.slast,data.nper);
calvec_smpl = calvecp(ismpl==1);
dnobs_smpl = size(calvec_smpl,1);
xp = xp(ismpl==1,:);
nseries = size(x,2);
q = lfparm.q;
X = NaN(q,nseries);
Xstd = NaN(q,nseries);
Xproj = NaN(dnobs_smpl,nseries);
Xproj_m = NaN(dnobs_smpl,nseries);

for i = 1:nseries;
   [X_mean,X_cos] = xp_compute(xp(:,i),q);
   X_norm = X_cos/sqrt(X_cos'*X_cos); 
   psi = psi_compute(dnobs_smpl,q);
   X_proj = psi*(inv(psi'*psi))*X_cos;
   X_proj_m = X_proj + X_mean;
   X(:,i) = X_cos;
   Xstd(:,i) = X_norm;
   Xproj(:,i) = X_proj;
   Xproj_m(:,i) = X_proj_m;
end;
ctran.x_smpl = xp;
ctran.X = X;
ctran.Xstd = Xstd;
ctran.Xproj = Xproj;
ctran.Xproj_m = Xproj_m;
ctran.calvec_smpl = calvec_smpl;
ctran.dnobs_smpl = dnobs_smpl;
ctran.psi = psi;

end

