function [val] = getdens_2xscale_sym(Parm,data)
% This version 10/31/2017, mww
  q = Parm.q;
  X = data.Xstd(:,1);
  Y = data.Xstd(:,2);
  sinv_xx = Parm.sigma_inv(1:q,1:q);
  sinv_yy = Parm.sigma_inv(q+1:end,q+1:end);
  sinv_yx = Parm.sigma_inv(q+1:end,1:q);
  a = sqrt(X'*sinv_xx*X);
  b = sqrt(Y'*sinv_yy*Y);
  r=Y'*sinv_yx*X;
  r=r/(a*b);
  val=sqrt(Parm.sigma_inv_det);
  val=val*getnime(r,a,b,q);
end

% ------ FORTRAN --------
% 	function getdens_2xscale_sym(Siginv,Y) result(val)
% 		type(Siginv_type)	:: Siginv
% 		real(kind=ywp)	:: Y(nY)
% 		real	:: val
% 		real	:: a,b,r
% 		a=sqrt(sum(Y(1:q)*matmul(Siginv%mat11,Y(1:q))))
% 		b=sqrt(sum(Y(q+1:)*matmul(Siginv%mat22,Y(q+1:))))
% 		r=sum(Y(q+1:2*q)*matmul(Siginv%mat21,Y(1:q)))
% 		r=r/(a*b)
% 		val=sqrt(Siginv%det)*getnime(r,a,b)
% 	end function