function [ val ] = getdens_tri_beta0(Parm,data)
% This version 11/27/2016, mww

 q = Parm.q;
 X = data.Xstar(:,1);
 Y = data.Xstar(:,2);
 W = data.W;
 SW = NaN(2,2);
 S = NaN(3,3);
 Ilam = NaN(3,2);
 b_theta = Parm.gamma;    % Value of parameter of interest

 sinv_xx = Parm.sigma_inv(1:q,1:q);
 sinv_yy = Parm.sigma_inv(q+1:2*q,q+1:2*q);
 sinv_xy = Parm.sigma_inv(1:q,q+1:2*q);

 S(1,1) = X'*sinv_xx*X;
 S(2,2) = Y'*sinv_yy*Y;
 S(1,2) = X'*sinv_xy*Y;
 S(2,1) = S(1,2);
 S(1,3) = X'*sinv_xy*X;
 S(3,1) = S(1,3);
 S(2,3) = X'*sinv_yy*Y;
 S(3,2) = S(2,3);
 S(3,3) = X'*sinv_yy*X;
 Ilam(1:2,:)=eye(2);
 Ilam(3,:)=[b_theta -W];
 SW = Ilam'*S*Ilam;
 sig1 = sqrt(SW(1,1));
 sig2 = sqrt(SW(2,2));
 r = SW(1,2)/(sig1*sig2);
 val=sqrt(Parm.sigma_inv_det)*getnime(r,sig1,sig2,q);
end

% % % % --- FORTRAN ---
% 	function getdens_tri_beta0(Siginv,Y) result(val)
% 		type(Siginv_type)	:: Siginv
% 		real(kind=ywp)	:: Y(nY)
% 		real	:: val
% 		real	:: S(3,3),Ilam(3,2),SW(2,2),SWdet
% 		real	:: sig1,sig2,r
% 
% 		S(1,1)=sum(Y(1:q)*matmul(Siginv%mat11,Y(1:q)))
% 		S(2,1)=sum(Y(q+1:2*q)*matmul(Siginv%mat21,Y(1:q)))
% 		S(1,2)=S(2,1)
%         S(2,2)=sum(Y(q+1:2*q)*matmul(Siginv%mat22,Y(q+1:2*q)))            
%         S(3,1)=sum(Y(1:q)*matmul(Siginv%mat21,Y(1:q)))
%         S(1,3)=S(3,1)
%         S(3,2)=sum(Y(q+1:2*q)*matmul(Siginv%mat22,Y(1:q)))
%         S(2,3)=S(3,2)
% 		S(3,3)=sum(Y(1:q)*matmul(Siginv%mat22,Y(1:q)))
% 
% 		Ilam(1:2,1:2)=eye(2)
%         Ilam(3,:)=[Siginv%gamma,-real(Y(2*q+1))]
%         SW=matmul(transpose(Ilam),matmul(S,Ilam))
% 		
% 		sig1=sqrt(SW(1,1))
% 		sig2=sqrt(SW(2,2))
% 		r=SW(1,2)/(sig1*sig2)
% 
% 		val=sqrt(Siginv%det)*getnime(r,sig1,sig2)
% 		
% 		if(val/=val .or. val>1E100) then
% !$omp critical
% 			call mdisp(real(Y))
% 			call mdisp(S)
% 			call mdisp(SW)
% 			call mdisp([sig1,sig2,r])
% 			val=0
% !$omp end critical
% 		endif
% !		val=sqrt(Siginv%det)*.5*(90*(Sqrt(1 - r**2)*(327680 + r**2*(17587235 + 4*r**2*(25557485 + 34245973*r**2 + 11433184*r**4 + 669688*r**6))) + 3465*r*(693 + 2*r**2*(5775 + 16*r**2*(1155 + 990*r**2 + 220*r**4 + 8*r**6)))*asin(r)))/((sig1*sig2*(1-r**2))**12/sqrt(1 - r**2))
% 	end function