function [val] = getdens_tri_inv(Parm,data);
% This version 10/31/2017, mww
  q = Parm.q;
  X = data.Xstar(:,1);
  Y = data.Xstar(:,2);
  SW = NaN(2,2);
  Sv = NaN(2,1);
  sinv_xx = Parm.sigma_inv(1:q,1:q);
  sinv_yy = Parm.sigma_inv(q+1:end,q+1:end);
  sinv_xy = Parm.sigma_inv(1:q,q+1:end);
  SW(1,1) = X'*sinv_xx*X;
  SW(2,2) = Y'*sinv_yy*Y;
  SW(1,2) = X'*sinv_xy*Y;
  SW(2,1) = SW(1,2);
  Sv(1,1) = X'*sinv_xy*X;
  Sv(2,1) = X'*sinv_yy*Y;
  S0 = X'*sinv_yy*X;
  SW = SW - Sv*Sv'/S0;
  sig1=sqrt(SW(1,1));
  sig2=sqrt(SW(2,2));
  r=SW(1,2)/(sig1*sig2);
  val=sqrt(Parm.sigma_inv_det/S0);
  a=sig2; 
  b=sig1;	
  val=val*getnimd(r,a,b,q);
end

%   -- FORTRAN ----
% function getdens_tri_inv(Siginv,Y) result(val)
% 		type(Siginv_type)	:: Siginv
% 		real(kind=ywp)	:: Y(nY)
% 		real	:: val
% 		real	:: SW(2,2),Sv(2),S0,SWdet
% 		real	:: sig1,sig2,r
% 		real	:: a,b
% 		
% 		SW(1,1)=sum(Y(1:q)*matmul(Siginv%mat11,Y(1:q)))
% 		SW(2,1)=sum(Y(q+1:2*q)*matmul(Siginv%mat21,Y(1:q)))
% 		SW(1,2)=SW(2,1)
%         SW(2,2)=sum(Y(q+1:2*q)*matmul(Siginv%mat22,Y(q+1:2*q)))            
% 			
% 		Sv(1)=sum(Y(1:q)*matmul(Siginv%mat21,Y(1:q)))
%         Sv(2)=sum(Y(q+1:2*q)*matmul(Siginv%mat22,Y(1:q)))
% 			
% 		S0=sum(Y(1:q)*matmul(Siginv%mat22,Y(1:q)))
% 
% 		SW=SW-spread(Sv/S0,dim=2,ncopies=2)*spread(Sv,dim=1,ncopies=2)
% 		
% 		sig1=sqrt(SW(1,1))
% 		sig2=sqrt(SW(2,2))
% 		r=SW(1,2)/(sig1*sig2)
% 		val=sqrt(Siginv%det/S0)
% 		a=sig2; b=sig1
% 		val=val*getnimd(r,a,b)
% 	end function
