function [ val ] = getdens_tri_stddev0(Parm,data)
% This version 11/27/2016, mww

 q = Parm.q;
 X = data.Xstar(:,1);
 Y = data.Xstar(:,2);
 W = data.W;
 SW = NaN(2,2);
 Sv = NaN(2,1);
 b_theta = Parm.gamma;    % Value of parameter of interest
 
 sinv_xx = Parm.sigma_inv(1:q,1:q);
 sinv_yy = Parm.sigma_inv(q+1:2*q,q+1:2*q);
 sinv_xy = Parm.sigma_inv(1:q,q+1:2*q);

 SW(1,1) = X'*sinv_xx*X;
 SW(2,2) = Y'*sinv_yy*Y;
 SW(1,2) = X'*sinv_xy*Y;
 SW(2,1) = SW(1,2);
 Sv(1,1) = X'*sinv_xy*X;
 Sv(2,1) = X'*sinv_yy*Y;
 S0 = X'*sinv_yy*X;
 SW = SW - Sv*Sv'/S0;
 c = sqrt(SW(1,1));
 b=(b_theta/W)*SW(1,2)/c;
 d2=((b_theta/W)^2)*SW(2,2);
 val=0.5*sqrt(2*pi*(Parm.sigma_inv_det)/S0)*(c*W)^(-q)*b_theta^(q-1)*exp(-0.5*(d2-b^2));
 val=val*getni(b,q);
 
end

% % ---- Fortran ---- 
% function getdens_tri_stddev0(Siginv,Y) result(val)
% 		type(Siginv_type)	:: Siginv
% 		real(kind=ywp)	:: Y(nY)
% 		real	:: val
% 
% 		real	:: SW(2,2),Sv(2),S0,SWdet
% 		real	:: b,c,d2
% 		
%         SW(1,1)=sum(Y(1:q)*matmul(Siginv%mat11,Y(1:q)))
% 		SW(2,1)=sum(Y(q+1:2*q)*matmul(Siginv%mat21,Y(1:q)))
% 		SW(1,2)=SW(2,1)
%         SW(2,2)=sum(Y(q+1:2*q)*matmul(Siginv%mat22,Y(q+1:2*q)))            
% 			
% 		Sv(1)=sum(Y(1:q)*matmul(Siginv%mat21,Y(1:q)))
%         Sv(2)=sum(Y(q+1:2*q)*matmul(Siginv%mat22,Y(1:q)))
% 			
% 		S0=sum(Y(1:q)*matmul(Siginv%mat22,Y(1:q)))
% 
% 		SW=SW-spread(Sv/S0,dim=2,ncopies=2)*spread(Sv,dim=1,ncopies=2)
%         c=sqrt(SW(1,1))
%         b=(Siginv%gamma/Y(2*q+1))*SW(1,2)/c
%         d2=(Siginv%gamma/Y(2*q+1))**2*SW(2,2)
% 		val=0.5*sqrt(2*pi*Siginv%det/S0)*(c*Y(2*q+1))**(-q)*Siginv%gamma**(q-1)*exp(-.5*(d2-b**2))
% 		val=val*getni(b)
%     end function