function [ val ] = getnimd(r,a,b,q)
% This version 11/1/2017, mww
% evaluates normal integral with powers equal to q - 2 on a and q-1 on b
% 
		if q == 2
			val=pi/(a*b^2 - a*b^2*r^2);
		elseif q==3
			val=(pi*(1 + r^2))/(a^2*b^3*(-1 + r^2)^2);
		elseif q==4
			val=(-2*pi*(1 + 3*r^2))/(a^3*b^4*(-1 + r^2)^3);
		elseif q==5
			val=(6*pi*(1 + 6*r^2 + r^4))/(a^4*b^5*(-1 + r^2)^4);
		elseif q==6
			val=(-24*pi*(1 + 5*r^2*(2 + r^2)))/(a^5*b^6*(-1 + r^2)^5);
		elseif q==7
			val=(120*pi*(1 + r^2)*(1 + 14*r^2 + r^4))/(a^6*b^7*(-1 + r^2)^6);
		elseif q==8
			val=(-720*pi*(1 + 7*r^2*(3 + 5*r^2 + r^4)))/(a^7*b^8*(-1 + r^2)^7);
		elseif q==9
			val=(2520*pi*((-1 + r)^(-8) + (1 + r)^(-8)))/(a^8*b^9);
		elseif q==10
			val=(20160*pi*(-(-1 + r)^(-9) + (1 + r)^(-9)))/(a^9*b^10);
		elseif q==11
			val=(181440*pi*((-1 + r)^(-10) + (1 + r)^(-10)))/(a^10*b^11);
		elseif q==12
			val=(1814400*pi*((-1 + r)^12*(1 + r) - (-1 + r)*(1 + r)^12))/(a^11*(b - b*r^2)^12);
		elseif q==13
			val=(19958400*pi*(-((-1 + r)^13*(1 + r)) - (-1 + r)*(1 + r)^13))/(a^12*(b - b*r^2)^13);
		elseif q==14
			val=(239500800*pi*((-1 + r)^14*(1 + r) - (-1 + r)*(1 + r)^14))/(a^13*(b - b*r^2)^14);
		elseif q==15
			val=(3113510400*pi*(-((-1 + r)^15*(1 + r)) - (-1 + r)*(1 + r)^15))/(a^14*(b - b*r^2)^15);
		elseif q==16
			val=(43589145600*pi*((-1 + r)^16*(1 + r) - (-1 + r)*(1 + r)^16))/(a^15*(b - b*r^2)^16);
		elseif q==17
			val=(653837184000*pi*(-((-1 + r)^17*(1 + r)) - (-1 + r)*(1 + r)^17))/(a^16*(b - b*r^2)^17);
		elseif q==18
			val=(10461394944000*pi*((-1 + r)^18*(1 + r) - (-1 + r)*(1 + r)^18))/(a^17*(b - b*r^2)^18);
		elseif q==19
			val=(177843714048000*pi*(-((-1 + r)^19*(1 + r)) - (-1 + r)*(1 + r)^19))/(a^18*(b - b*r^2)^19);
		elseif q==20
			val=(3201186852864000*pi*((-1 + r)^20*(1 + r) - (-1 + r)*(1 + r)^20))/(a^19*(b - b*r^2)^20);
		elseif q==21
			val=(60822550204416000*pi*(-((-1 + r)^21*(1 + r)) - (-1 + r)*(1 + r)^21))/(a^20*(b - b*r^2)^21);
		elseif q==22
			val=(1216451004088320000*pi*((-1 + r)^22*(1 + r) - (-1 + r)*(1 + r)^22))/(a^21*(b - b*r^2)^22);
		elseif q==23
			val=(25545471085854720000.0*pi*(-((-1 + r)^23*(1 + r)) - (-1 + r)*(1 + r)^23))/(a^22*(b - b*r^2)^23);
		elseif q==24
			val=(562000363888803840000.0*pi*((-1 + r)^24*(1 + r) - (-1 + r)*(1 + r)^24))/(a^23*(b - b*r^2)^24);
	  elseif q==25
			val=(1.292600836944249e22*pi*(-((-1 + r)^25*(1 + r)) - (-1 + r)*(1 + r)^25))/(a^24*(b - b*r^2)^25);
		elseif q==26
			val=(3.102242008666197e23*pi*((-1 + r)^26*(1 + r) - (-1 + r)*(1 + r)^26))/(a^25*(b - b*r^2)^26);
		elseif q==27
			val=(7.755605021665493e24*pi*(-((-1 + r)^27*(1 + r)) - (-1 + r)*(1 + r)^27))/(a^26*(b - b*r^2)^27);
		elseif q==28
			val=(2.0164573056330283e26*pi*((-1 + r)^28*(1 + r) - (-1 + r)*(1 + r)^28))/(a^27*(b - b*r^2)^28);
		elseif q==29
			val=(5.444434725209176e27*pi*(-((-1 + r)^29*(1 + r)) - (-1 + r)*(1 + r)^29))/(a^28*(b - b*r^2)^29);
		elseif q==30
			val=(1.5244417230585694e29*pi*((-1 + r)^30*(1 + r) - (-1 + r)*(1 + r)^30))/(a^29*(b - b*r^2)^30);	  
	  else
      fprintf('q = %5i \n',q);
      error('Density not implemented for this value of q');
    end			
end 

% ...... Fortran Code -----
%
%     function getnimd(r,a,b)	result(val)		! evaluates normal integral with powers equal to q - 2 on a and q-1 on b
% 		real	:: r,a,b,val
% 		select case(q)
% 			case(2)
% 			val=pi/(a*b**2 - a*b**2*r**2)
% 			case(3)
% 			val=(pi*(1 + r**2))/(a**2*b**3*(-1 + r**2)**2)
% 			case(4)
% 			val=(-2*pi*(1 + 3*r**2))/(a**3*b**4*(-1 + r**2)**3)
% 			case(5)
% 			val=(6*pi*(1 + 6*r**2 + r**4))/(a**4*b**5*(-1 + r**2)**4)
% 			case(6)
% 			val=(-24*pi*(1 + 5*r**2*(2 + r**2)))/(a**5*b**6*(-1 + r**2)**5)
% 			case(7)
% 			val=(120.*pi*(1 + r**2)*(1 + 14*r**2 + r**4))/(a**6*b**7*(-1 + r**2)**6)
% 			case(8)
% 			val=(-720*pi*(1 + 7*r**2*(3 + 5*r**2 + r**4)))/(a**7*b**8*(-1 + r**2)**7)
% 			case(9)
% 			val=(2520.*pi*((-1 + r)**(-8) + (1 + r)**(-8)))/(a**8*b**9)
% 			case(10)
% 			val=(20160.*pi*(-(-1 + r)**(-9) + (1 + r)**(-9)))/(a**9*b**10)
% 			case(11)
% 			val=(181440.*pi*((-1 + r)**(-10) + (1 + r)**(-10)))/(a**10*b**11)
% 			case(12)
% 			val=(1.8144e6*pi*((-1 + r)**12*(1 + r) - (-1 + r)*(1 + r)**12))/(a**11*(b - b*r**2)**12)
% 			case(13)
% 			val=(1.99584e7*pi*(-((-1 + r)**13*(1 + r)) - (-1 + r)*(1 + r)**13))/(a**12*(b - b*r**2)**13)
% 			case(14)
% 			val=(2.395008e8*pi*((-1 + r)**14*(1 + r) - (-1 + r)*(1 + r)**14))/(a**13*(b - b*r**2)**14)
% 			case(15)
% 			val=(3.1135104e9*pi*(-((-1 + r)**15*(1 + r)) - (-1 + r)*(1 + r)**15))/(a**14*(b - b*r**2)**15)
% 			case(16)
% 			val=(4.35891456e10*pi*((-1 + r)**16*(1 + r) - (-1 + r)*(1 + r)**16))/(a**15*(b - b*r**2)**16)
% 			case(17)
% 			val=(6.53837184e11*pi*(-((-1 + r)**17*(1 + r)) - (-1 + r)*(1 + r)**17))/(a**16*(b - b*r**2)**17)
% 			case(18)
% 			val=(1.0461394944e13*pi*((-1 + r)**18*(1 + r) - (-1 + r)*(1 + r)**18))/(a**17*(b - b*r**2)**18)
% 			case(19)
% 			val=(1.77843714048e14*pi*(-((-1 + r)**19*(1 + r)) - (-1 + r)*(1 + r)**19))/(a**18*(b - b*r**2)**19)
% 			case(20)
% 			val=(3.201186852864e15*pi*((-1 + r)**20*(1 + r) - (-1 + r)*(1 + r)**20))/(a**19*(b - b*r**2)**20)
% 			case(21)
% 			val=(6.0822550204416e16*pi*(-((-1 + r)**21*(1 + r)) - (-1 + r)*(1 + r)**21))/(a**20*(b - b*r**2)**21)
% 			case(22)
% 			val=(1.21645100408832e18*pi*((-1 + r)**22*(1 + r) - (-1 + r)*(1 + r)**22))/(a**21*(b - b*r**2)**22)
% 			case(23)
% 			val=(2.554547108585472e19*pi*(-((-1 + r)**23*(1 + r)) - (-1 + r)*(1 + r)**23))/(a**22*(b - b*r**2)**23)
% 			case(24)
% 			val=(5.6200036388880384e20*pi*((-1 + r)**24*(1 + r) - (-1 + r)*(1 + r)**24))/(a**23*(b - b*r**2)**24)
% 			case(25)
% 			val=(1.292600836944249e22*pi*(-((-1 + r)**25*(1 + r)) - (-1 + r)*(1 + r)**25))/(a**24*(b - b*r**2)**25)
% 			case(26)
% 			val=(3.102242008666197e23*pi*((-1 + r)**26*(1 + r) - (-1 + r)*(1 + r)**26))/(a**25*(b - b*r**2)**26)
% 			case(27)
% 			val=(7.755605021665493e24*pi*(-((-1 + r)**27*(1 + r)) - (-1 + r)*(1 + r)**27))/(a**26*(b - b*r**2)**27)
% 			case(28)
% 			val=(2.0164573056330283e26*pi*((-1 + r)**28*(1 + r) - (-1 + r)*(1 + r)**28))/(a**27*(b - b*r**2)**28)
% 			case(29)
% 			val=(5.444434725209176e27*pi*(-((-1 + r)**29*(1 + r)) - (-1 + r)*(1 + r)**29))/(a**28*(b - b*r**2)**29)
% 			case(30)
% 			val=(1.5244417230585694e29*pi*((-1 + r)**30*(1 + r) - (-1 + r)*(1 + r)**30))/(a**29*(b - b*r**2)**30)
% 			case default
% 				print *,"cannot evaluate density for this value of q",q
% 				stop				
% 		end select
% 	end function	