function [ sig_vec delta_sig  ] = sigma_grid(X,Y,pct_vec )
% Compute Grid of values for sigma

ndf = size(X,1)-size(X,2);
bhat = X\Y;
u = Y-X*bhat;
ssr = u'*u;
chi_pct = chi2inv(pct_vec,ndf);
s2_pct = ssr./flipud(chi_pct);
s_pct = sqrt(s2_pct);
s_pct = s_pct*sqrt(size(X,1));                  %  Note SIGMA matrix is normalized so that average diagonal element is unity. We want trace of sigma (see mapping from sample variance of projections to sum of projection coefficients.  Thus, the standard deviation depends on the number of terms in the projection 
delta_sig = s_pct(2:end)-s_pct(1:end-1);        % Cell width
sig_vec = (s_pct(1:end-1)+s_pct(2:end))/2;      % Midpoint

end

