function [ rslt ] = stddev_compute(data,lfparm,dens_h0,dens_h1,dens_ystar,dens_w_ystar,beta_compute,parmdir)

% This version 11/27/2016, mww

tol = .01;   % tolerance for posterior.  It should integrated to 1-tol
% Construct Results for Absolute value of Correlations 

level_vec = lfparm.level_vec/100;  %Percentiles

% Read in Sigma matrix parameters under H1 values of parameters
% q variables
q = lfparm.q;
qstr = ['_' num2str(q)];    
str_tmp = [parmdir 'Parm_h1_' lfparm.problem_label qstr]; 
load (str_tmp);
str_tmp = [parmdir 'Parm_h0_' lfparm.problem_label qstr];
load (str_tmp);
str_tmp = [parmdir 'alfd_h0_' lfparm.problem_label qstr]; 
load (str_tmp);

% -- Compute a grid of values of beta .. begin with I(0) confidence set
 X = data.X(:,1);
 Y = data.X(:,2);
 % find quantiles of posterior
 pct_vec = linspace(.00001,.001,15)';
 pct_vec = [pct_vec;linspace(.0015,.05,30)'];
 pct_vec = [pct_vec;linspace(.055,.10,30)'];
 pct_vec = [pct_vec;linspace(.11,.495,30)'];

 if q == 3;
  pct_vec = linspace(.0001,.001,15)';
  pct_vec = [pct_vec;linspace(.0015,.05,30)'];
  pct_vec = [pct_vec;linspace(.055,.10,30)'];
  pct_vec = [pct_vec;linspace(.11,.495,30)'];
 end;
 
 if q == 2;
  pct_vec = linspace(.005,.010,20)';
  pct_vec = [pct_vec;linspace(.02,.05,30)'];
  pct_vec = [pct_vec;linspace(.055,.10,30)'];
  pct_vec = [pct_vec;linspace(.11,.495,30)'];
 end;
     
 pct_vec = [pct_vec;flipud(1-pct_vec)];
 [sig_vec delta_sig] = sigma_grid(X,Y,pct_vec);   

% Construct Average likelihood*scale value under alternative values of theta
avg_like_h1 = compute_avg_like_h1(dens_h1,data,Parm_h1); 

% Bayes Posterior:

% Compute marginal likelihood using theta1 with uniform prior
avg_like_ystar = compute_avg_like_h1(dens_ystar,data,Parm_h1); 

isig = 1 ;
nsig_max = 5;
while isig <= nsig_max;
  ngrid = size(sig_vec,1);
  posterior = NaN(ngrid,1);
  for ii = 1:ngrid;
    sig_theta_test = sig_vec(ii);
    data.W = abs(sig_theta_test/data.U(2,2));  
    posterior(ii) = compute_avg_like_h1(dens_w_ystar,data,Parm_h1); 
  end;
  % normalize by marginal likelihood;
  posterior = posterior/avg_like_ystar;  
  % normalize posterior so that sum (not integral) is equal to 1
  posterior = posterior.*delta_sig/abs(data.U(2,2));
  fprintf('posterior sum %6.3f \n',sum(posterior));
    if sum(posterior) < 1-tol;
      isig = isig+1;
      fprintf(' Minimum and Maximum values %9.4g %9.4g \n',[sig_vec(1) sig_vec(end)]);
      if isig <= nsig_max;
        % Expand Grid;
        tmp = [0.025; (0.1:0.1:0.9)'];
        tmp = tmp*pct_vec(1);
        pct_vec = [tmp;pct_vec;flipud(1-tmp)];
        [sig_vec delta_sig] = sigma_grid(X,Y,pct_vec);  
        fprintf('STDEV: increasing number of grid points for posterior \n');
      else
        fprintf('     STDEV Results may not be accurate \n\n'); 
      end;
    else
      isig = 100;
    end;  
end;
sig_vec_posterior = sig_vec;
% Add 2 additional element to sig_vec so that posterior sums to unity;
post_error = 1-sum(posterior);
if post_error > 0;
   sig_vec_posterior = [sig_vec(1)-delta_sig(1);sig_vec;sig_vec(end)+delta_sig(end)];
   posterior = [post_error/2;posterior;post_error/2];
end;
posterior = posterior/sum(posterior);

% Compute Prior and posterior mean and median
  prior_mean = NaN;
  posterior_mean = posterior'*sig_vec_posterior;
  prior_median = NaN;
  posterior_median = df_pct(posterior,sig_vec_posterior,0.5);
  
isig = 1;
sig_vec = sig_vec_posterior;
while isig == 1;
  ngrid = size(sig_vec,1);
  sig_test = NaN(ngrid,size(lfparm.level_vec,2));
  for ii = 1:ngrid;
    sig_theta_test = sig_vec(ii);
    data.W = abs(sig_theta_test/data.U(2,2));     
    [avg_like_h0,tmp] =  compute_avg_like_h0(dens_h0,beta_compute,data,lfparm,Parm_h0,alfd_h0);
    sig_test(ii,:) = avg_like_h0 > avg_like_h1;
  end;   
 
  if sum(sig_test(1,:)) > 0;
      tmp = (0.5:0.01:0.99)';
      tmp = tmp*sig_vec(1);
      sig_vec = [tmp;sig_vec];
      fprintf('\n \n Lowering sig_lower %6.3f \n',sig_vec(1));
  end;
  if sum(sig_test(end,:)) > 0;
      tmp = (1.01:0.01:1.50)';
      tmp = tmp*sig_vec(end);
      sig_vec = [sig_vec;tmp];
      fprintf('\n \n Increasing sig_upper %6.3f \n',sig_vec(end));
  end;
  if sum(sig_test(1,:)) + sum(sig_test(end,:)) == 0;
      isig = 0;
      sig_ci = NaN(size(lfparm.level_vec,2),2);
      posterior_cs = NaN(size(lfparm.level_vec,2),2);
      posterior_cdf = NaN(size(lfparm.level_vec,2),2);
      prior_cs = NaN(size(lfparm.level_vec,2),2);
      for i = 1:size(lfparm.level_vec,2);
         if max(sig_test(:,i)) > 0;
          sig_ci(i,1) = min(sig_vec(sig_test(:,i)==1));
          sig_ci(i,2) = max(sig_vec(sig_test(:,i)==1));
         end;
         [posterior_cs(i,1) posterior_cdf(i,1)]=df_pct(posterior,sig_vec_posterior,level_vec(i)/2);
         [posterior_cs(i,2) posterior_cdf(i,2)]=df_pct(posterior,sig_vec_posterior,1-level_vec(i)/2);
         if isnan(sig_ci(i,1)) == 1;
             sig_ci(i,1) =  posterior_cs(i,1);
         end;
         if sig_ci(i,1) > posterior_cs(i,1);
             sig_ci(i,1) =  posterior_cs(i,1);
         end;
         if isnan(sig_ci(i,2)) == 1;
            sig_ci(i,2) =  posterior_cs(i,2);
         end;
         if sig_ci(i,2) < posterior_cs(i,2);
            sig_ci(i,2) =  posterior_cs(i,2);
         end;
      end;   
  end;  
end;

% fprintf('Posterior CS CDF values \n');
% prtmat_comma_screen(posterior_cdf,'%5.3f','\n');

% Save results
 rslt.posterior_cs = posterior_cs;
 rslt.prior_cs = prior_cs;
 rslt.prior_mean = prior_mean;
 rslt.ci = sig_ci;
 rslt.prior_median = prior_median;
 rslt.posterior_mean = posterior_mean;
 rslt.posterior_median = posterior_median;

end

