% Averages by Administration
%   mww, 7/22/2015
%

clear all;
small = 1.0e-10;
big = 1.0e+6; 

outdir = '/Users/mwatson/Dropbox/demrep/ddisk/matlab/out/';
outfile_name = [outdir 'avg_by_administration.out'];
fileID = fopen(outfile_name,'w');

% Load Data 
dr_data_calendar;

iq = 1;
qmin = 12;      % Minimum number of quarters in administration for computing results .. if less than this then data are missing @
nma = 6;        % Number of algs for HAC Standard errors

dem_rep_ind;

slist = {
{'gdp', 3}; ... 
};


for istr = 1:size(slist,1);
   ustr = char(slist{istr,1}{1,1});
   eval(['ylevel = ' ustr ';']);
   itran = slist{istr,1}{1,2};
   if itran == 1;
     ydata = ylevel;
   end;
   if itran == 3;
     ydata = NaN*zeros(dnobs,1);
     ydata(2:dnobs) = 100*(((ylevel(2:dnobs)./ylevel(1:dnobs-1)).^4)-1.0);
   end;
   if itran == 10;
     ydata = 16*ylevel;  % Multiply by 16 so this will be average quarters in 16-quarter administration @
   end;
   Truman_2_y = ydata(Truman_2==1,:);
   Eisenhower_1_y = ydata(Eisenhower_1==1,:);
   Eisenhower_2_y = ydata(Eisenhower_2==1,:);
   Kennedy_1_y = ydata(Kennedy_1==1,:);
   Johnson_1_y = ydata(Johnson_1==1,:);
   Nixon_1_y = ydata(Nixon_1==1,:);
   Nixon_2_y = ydata(Nixon_2==1,:);
   Carter_1_y = ydata(Carter_1==1,:);
   Reagan_1_y = ydata(Reagan_1==1,:);
   Reagan_2_y = ydata(Reagan_2==1,:);
   BushG_1_y = ydata(BushG_1==1,:);
   Clinton_1_y = ydata(Clinton_1==1,:);
   Clinton_2_y = ydata(Clinton_2==1,:);
   BushGW_1_y = ydata(BushGW_1==1,:);
   BushGW_2_y = ydata(BushGW_2==1,:);
   Obama_1_y = ydata(Obama_1==1,:);

  dem = [Truman_2_y Kennedy_1_y Johnson_1_y Carter_1_y Clinton_1_y Clinton_2_y Obama_1_y];
  rep = [Eisenhower_1_y Eisenhower_2_y Nixon_1_y Nixon_2_y Reagan_1_y Reagan_2_y BushG_1_y BushGW_1_y BushGW_2_y];
  
  % -- Cluster by 4-year administration
  dem_pavg = NaN*zeros(size(dem,2),1);
  rep_pavg = NaN*zeros(size(rep,2),1);
  for i = 1:size(dem,2);
    tmp = packr(dem(:,i));
 	if size(tmp,1) >= qmin;
 	  dem_pavg(i) = mean(tmp);
    end;
  end;
  for i = 1:size(rep,2);
    tmp = packr(rep(:,i));
 	if size(tmp,1) >= qmin;
 	 rep_pavg(i) = mean(tmp);
    end;
  end;
  
  % Output 
  fprintf(fileID,[ustr ',']);
  fprintf(fileID,'      Democratic Averages \n');
  for i = 1:size(dem_pavg,1);
      fprintf(fileID,'          %4.2f \n',dem_pavg(i));
  end;
  fprintf(fileID,'      Republican Averages \n');
  for i = 1:size(rep_pavg,1);
      fprintf(fileID,'          %4.2f \n',rep_pavg(i));
  end;
end;


