% Averages by Country
%   mww, 7/22/2015
%

clear all;
small = 1.0e-10;
big = 1.0e+6; 

outdir = '/Users/mwatson/Dropbox/demrep/ddisk/matlab/out/';
outfile_name = [outdir 'avg_by_country.out'];
fileID = fopen(outfile_name,'w');

% Load Data 
dr_data_calendar;

iq = 1;
qmin = 12;      % Minimum number of quarters in administration for computing results .. if less than this then data are missing @
nma = 6;        % Number of algs for HAC Standard errors

dem_rep_ind;

slist = {'cn','fr','de','uk'};

for istr = 1:size(slist,2);
   ustr = char(slist{1,istr});
   y_ustr = [ustr '_g_gdp'];
   x_ustr = [ustr '_left'];
   eval(['g_gdp = ' y_ustr ';']);
   eval(['left = ' x_ustr ';']);
   
   y = g_gdp;
   x = [ones(dnobs,1) left];
   tmp = [calvec y x];
   tmp = packr(tmp);
   calp = tmp(:,1);
   yp = tmp(:,2);
   xp = tmp(:,3:4);
   [b,vb,se_b,ser,rbarsq] = hac(yp,xp,nma,1);
   right_b = [1 0]';
   left_b = [1 1]';
   dif_b = [0 1]';
   bleft = left_b'*b;
   se_bleft = sqrt(left_b'*vb*left_b);
   bright = right_b'*b;
   se_bright = sqrt(right_b'*vb*right_b); 
   bdif = dif_b'*b;
   se_bdif = sqrt(dif_b'*vb*dif_b);
   fprintf(fileID,['Country: ' ustr '\n'])';
   fprintf(fileID,'   Sample Period: %5.3f - %5.3f \n',[calp(1) calp(end)]);
   fprintf(fileID,'     Left: %5.2f (%5.2f) \n',[bleft se_bleft]);
   fprintf(fileID,'     Right: %5.2f (%5.2f) \n',[bright se_bright]);
   fprintf(fileID,'     Difference: %5.2f (%5.2f) \n',[bdif se_bdif]);
end;


