% Presidents and the Fed Chair
% mww, 7/22/2015

clear all;
small = 1.0e-10;
big = 1.0e+6; 

outdir = '/Users/mwatson/Dropbox/demrep/ddisk/matlab/out/';
outfile_name = [outdir 'avg_by_fedchair.out'];
fileID = fopen(outfile_name,'w');

% Load Data 
dr_data_calendar;

iq = 1;
qmin = 12;      % Minimum number of quarters in administration for computing results .. if less than this then data are missing @
nma = 6;        % Number of algs for HAC Standard errors

dem_rep_ind;
ismpl = smpl(calvec,[1949 2],[2013 1],4);

% Compute Cross Tabs of GDP Growth Rates and Party Control 
ylevel = gdp;
ydata = NaN*zeros(dnobs,1);
ydata(2:dnobs) = 100*(((ylevel(2:dnobs)./ylevel(1:dnobs-1)).^4)-1.0);
d_gdp = ydata;


% Save Data where Dem or Rep President 
isel = (dem_ind+rep_ind).*ismpl;
d_gdp = d_gdp(isel==1);
d_fed = d_fed(isel==1);
dem_ind = dem_ind(isel==1);
rep_ind = rep_ind(isel==1);
r_fed = 1-d_fed;

dd = dem_ind.*d_fed;
dr = dem_ind.*r_fed;
rd = rep_ind.*d_fed;
rr = rep_ind.*r_fed;
  
y = d_gdp;
x = [dd dr rd rr];
[b,vb,se_b,ser,rbarsq] = hac(y,x,nma,1);
fprintf(fileID,'All Interactions \n');
fprintf(fileID,'  dd = %5.2f (%5.2f) %3i \n',[b(1) se_b(1) sum(x(:,1))]);
fprintf(fileID,'  dr = %5.2f (%5.2f) %3i \n',[b(2) se_b(2) sum(x(:,2))]);
fprintf(fileID,'  rd = %5.2f (%5.2f) %3i \n',[b(3) se_b(3) sum(x(:,3))]);
fprintf(fileID,'  rr = %5.2f (%5.2f) %3i \n',[b(4) se_b(4) sum(x(:,4))]);

fprintf(fileID,'Presidents \n');
x = [(dd+dr) (rd+rr)]; 
[b,vb,se_b,ser,rbarsq] = hac(y,x,nma,1);
fprintf(fileID,'  d = %5.2f (%5.2f) %3i \n',[b(1) se_b(1) sum(x(:,1))]);
fprintf(fileID,'  r = %5.2f (%5.2f) %3i \n',[b(2) se_b(2) sum(x(:,2))]);

fprintf(fileID,'Fed \n');
x = [(rd+dd) (dr+rr)]; 
[b,vb,se_b,ser,rbarsq] = hac(y,x,nma,1);
fprintf(fileID,'  d = %5.2f (%5.2f) %3i \n',[b(1) se_b(1) sum(x(:,1))]);
fprintf(fileID,'  r = %5.2f (%5.2f) %3i \n',[b(2) se_b(2) sum(x(:,2))]);

fprintf(fileID,'Overall \n');
x = [dd+dr+rd+rr]; 
[b,vb,se_b,ser,rbarsq] = hac(y,x,nma,1);
fprintf(fileID,'  Overall = %5.2f (%5.2f) %3i \n',[b(1) se_b(1) sum(x(:,1))]);

 

