% Presidents and the Legislature
% mww, 5/26/2015

clear all;
small = 1.0e-10;
big = 1.0e+6; 

outdir = '/Users/mwatson/Dropbox/demrep/ddisk/matlab/out/';
outfile_name = [outdir 'avg_by_leg.out'];
fileID = fopen(outfile_name,'w');

% Load Data 
dr_data_calendar;

iq = 1;
qmin = 12;      % Minimum number of quarters in administration for computing results .. if less than this then data are missing @
nma = 6;        % Number of algs for HAC Standard errors

%dem_rep_ind_2;
dem_rep_ind;

% Compute Cross Tabs of GDP Growth Rates and Party Control 
ylevel = gdp;
ydata = NaN*zeros(dnobs,1);
ydata(2:dnobs) = 100*(((ylevel(2:dnobs)./ylevel(1:dnobs-1)).^4)-1.0);
d_gdp = ydata;

% Houses Dems, Split, Reps 
d_tot = d_house+d_senate;
leg_dem = d_tot == 2;
leg_rep = d_tot == 0;
leg_split = (d_tot < 2).*(d_tot > 0);

% Save Data where Dem or Rep President -- eliminate pre-Truman(2) 
isel = dem_ind+rep_ind;
d_gdp = d_gdp(isel==1);
leg_dem = leg_dem(isel==1);
leg_split = leg_split(isel==1);
leg_rep = leg_rep(isel==1);
dem_ind = dem_ind(isel==1);
rep_ind = rep_ind(isel==1);

dd = dem_ind.*leg_dem;
dr = dem_ind.*leg_rep;
ds = dem_ind.*leg_split;
rd = rep_ind.*leg_dem;
rr = rep_ind.*leg_rep;
rs = rep_ind.*leg_split;
  
y = d_gdp;
x = [dd ds dr rd rs rr];
[b,vb,se_b,ser,rbarsq] = hac(y,x,nma,1);
fprintf(fileID,'All Interactions \n');
fprintf(fileID,'  dd = %5.2f (%5.2f) %3i \n',[b(1) se_b(1) sum(x(:,1))]);
fprintf(fileID,'  ds = %5.2f (%5.2f) %3i \n',[b(2) se_b(2) sum(x(:,2))]);
fprintf(fileID,'  dr = %5.2f (%5.2f) %3i \n',[b(3) se_b(3) sum(x(:,3))]);
fprintf(fileID,'  rd = %5.2f (%5.2f) %3i \n',[b(4) se_b(4) sum(x(:,4))]);
fprintf(fileID,'  rs = %5.2f (%5.2f) %3i \n',[b(5) se_b(5) sum(x(:,5))]);
fprintf(fileID,'  rr = %5.2f (%5.2f) %3i \n',[b(6) se_b(6) sum(x(:,6))]);

fprintf(fileID,'Presidents \n');
x = [(dd+ds+dr) (rd+rs+rr)]; 
[b,vb,se_b,ser,rbarsq] = hac(y,x,nma,1);
fprintf(fileID,'  d = %5.2f (%5.2f) %3i \n',[b(1) se_b(1) sum(x(:,1))]);
fprintf(fileID,'  r = %5.2f (%5.2f) %3i \n',[b(2) se_b(2) sum(x(:,2))]);

fprintf(fileID,'Legislator \n');
x = [(rd+dd) (ds+rs) (dr+rr)]; 
[b,vb,se_b,ser,rbarsq] = hac(y,x,nma,1);
fprintf(fileID,'  d = %5.2f (%5.2f) %3i \n',[b(1) se_b(1) sum(x(:,1))]);
fprintf(fileID,'  s = %5.2f (%5.2f) %3i \n',[b(2) se_b(2) sum(x(:,2))]);
fprintf(fileID,'  r = %5.2f (%5.2f) %3i \n',[b(3) se_b(3) sum(x(:,3))]);

fprintf(fileID,'Overall \n');
x = [dd+ds+dr+rd+rs+rr]; 
[b,vb,se_b,ser,rbarsq] = hac(y,x,nma,1);
fprintf(fileID,'  Overall = %5.2f (%5.2f) %3i \n',[b(1) se_b(1) sum(x(:,1))]);

 

