% Averages by Party and Difference
% Last year of Adm - last year of previous adm.
%   mww, 7/22/2015
%

clear all;
small = 1.0e-10;
big = 1.0e+6; 

outdir = '/Users/mwatson/Dropbox/demrep/ddisk/matlab/out/';
outfile_name = [outdir 'avg_changes_by_party.out'];
fileID = fopen(outfile_name,'w');

% Load Data 
dr_data_calendar;

iq = 1;
qmin = 12;      % Minimum number of quarters in administration for computing results .. if less than this then data are missing @
nma = 6;        % Number of algs for HAC Standard errors

dem_rep_ind;

slist = {'unrate','d_ppce','d_pgdp','r_tb3m','r_fedfunds'};

for istr = 1:size(slist,2);
   ustr = char(slist{1,istr});
   eval(['y = ' ustr ';']);
   % Construct 4 quarter average 
   y_avg = NaN*zeros(dnobs,1);
   y_avg(4:dnobs) = (y(1:dnobs-3)+y(2:dnobs-2)+y(3:dnobs-1)+y(4:dnobs))/4;
   
   
   % Construct value in last year relative to last year in previous Administration 
   ydata = y_avg;
   ii = smpl(calvec,[1949 1],[1949 1],4);
   tmp = ydata(Truman_2==1);
   tmp2 = tmp;
   tmp = tmp-ydata(ii==1);
   Truman_2_y = tmp(end);
   tmp1 = tmp2;
   
   tmp = ydata(Eisenhower_1==1);
   tmp2 = tmp;
   tmp = tmp-tmp1(end);
   Eisenhower_1_y = tmp(end);
   tmp1 = tmp2;
   
   tmp = ydata(Eisenhower_2==1);
   tmp2 = tmp;
   tmp = tmp-tmp1(end);
   Eisenhower_2_y = tmp(end);
   tmp1 = tmp2;
   
   tmp = ydata(Kennedy_1==1);
   tmp2 = tmp;
   tmp = tmp-tmp1(end);
   Kennedy_1_y = tmp(end);
   tmp1 = tmp2;
   
   tmp = ydata(Johnson_1==1);
   tmp2 = tmp;
   tmp = tmp-tmp1(end);
   Johnson_1_y = tmp(end);
   tmp1 = tmp2;
   
   tmp = ydata(Nixon_1==1);
   tmp2 = tmp;
   tmp = tmp-tmp1(end);
   Nixon_1_y = tmp(end);
   tmp1 = tmp2;
   
   tmp = ydata(Nixon_2==1);
   tmp2 = tmp;
   tmp = tmp-tmp1(end);
   Nixon_2_y = tmp(end);
   tmp1 = tmp2;
   
   tmp = ydata(Carter_1==1);
   tmp2 = tmp;
   tmp = tmp-tmp1(end);
   Carter_1_y = tmp(end);
   tmp1 = tmp2;
   
   tmp = ydata(Reagan_1==1);
   tmp2 = tmp;
   tmp = tmp-tmp1(end);
   Reagan_1_y = tmp(end);
   tmp1 = tmp2;
   
   tmp = ydata(Reagan_2==1);
   tmp2 = tmp;
   tmp = tmp-tmp1(end);
   Reagan_2_y = tmp(end);
   tmp1 = tmp2;
   
   tmp = ydata(BushG_1==1);
   tmp2 = tmp;
   tmp = tmp-tmp1(end);
   BushG_1_y = tmp(end);
   tmp1 = tmp2;
   
   tmp = ydata(Clinton_1==1);
   tmp2 = tmp;
   tmp = tmp-tmp1(end);
   Clinton_1_y = tmp(end);
   tmp1 = tmp2;
   
   tmp = ydata(Clinton_2==1);
   tmp2 = tmp;
   tmp = tmp-tmp1(end);
   Clinton_2_y = tmp(end);
   tmp1 = tmp2;
   
   tmp = ydata(BushGW_1==1);
   tmp2 = tmp;
   tmp = tmp-tmp1(end);
   BushGW_1_y = tmp(end);
   tmp1 = tmp2;
   
   tmp = ydata(BushGW_2==1);
   tmp2 = tmp;
   tmp = tmp-tmp1(end);
   BushGW_2_y = tmp(end);
   tmp1 = tmp2;
   
   tmp = ydata(Obama_1==1);
   tmp2 = tmp;
   tmp = tmp-tmp1(end);
   Obama_1_y = tmp(end);
   tmp1 = tmp2;
   
   dem = [Truman_2_y Kennedy_1_y Johnson_1_y Carter_1_y Clinton_1_y Clinton_2_y Obama_1_y];
   rep = [Eisenhower_1_y Eisenhower_2_y Nixon_1_y Nixon_2_y Reagan_1_y Reagan_2_y BushG_1_y BushGW_1_y BushGW_2_y];
  
   dem_pavg = dem';
   rep_pavg = rep';
   a_rep = packr(rep_pavg);
   n_rep = size(a_rep,1);
   a_dem = packr(dem_pavg);
   n_dem = size(a_dem,1);
   dem_avg = mean(a_dem);
   dem_std = std(a_dem);
   dem_se_clust = dem_std/sqrt(n_dem);
   rep_avg = mean(a_rep);
   rep_std = std(a_rep);
   rep_se_clust = rep_std/sqrt(n_rep); 
   dif_avg = dem_avg-rep_avg;
   dif_se_clust = sqrt(dem_se_clust.^2+rep_se_clust.^2);

  
   % Under random assignment of party of administrations
  a_all = [a_dem;a_rep];
  n_all = n_dem+n_rep;
  mean_all = mean(a_all);
  mean_dem = mean(a_dem);
  mean_rep = (n_all/n_rep)*(mean_all-(n_dem/n_all)*mean_dem);
  dr_gap = mean_dem-mean_rep;
  dem_val_all = nchoosek(a_all,n_dem);
  mean_dem_all = mean(dem_val_all,2);
  mean_rep_all = (n_all/n_rep)*(repmat(mean_all,size(mean_dem_all,1),1)-(n_dem/n_all)*mean_dem_all);
  dr_gap_all = mean_dem_all-mean_rep_all;
  
  num = sum(abs(dr_gap_all) >= abs(dr_gap));
  den = nchoosek(n_all,n_dem);
  pval_ts = num/den;
  
  % Output 
  fprintf(fileID,[ustr ',']);
  fprintf(fileID,'%4.2f ',dem_avg);
  fprintf(fileID,'(%4.2f), ',dem_se_clust);
  fprintf(fileID,'%4.2f ',rep_avg);
  fprintf(fileID,'(%4.2f), ',rep_se_clust);
  fprintf(fileID,'%4.2f ',dif_avg);
  fprintf(fileID,'(%4.2f), ',dif_se_clust);
  fprintf(fileID,'%4.2f ,',pval_ts);
  fprintf(fileID,'%6i  %6i \n',[num den]);
end;


